﻿USE sofia;
DROP TABLE IF EXISTS sofia.msc_vpl;
CREATE TABLE msc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES msc_vpl WRITE;
INSERT INTO msc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Fɔlɔfɔlɔ, Alla ka sankolo dan ka duukolo dan, ");
INSERT INTO msc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","kɔni duu rabɛnni tɛrɛ tɛ waati wo rɔ. Fen fen tɛrɛ sa a kan. Ji dunba le tɛrɛ a yɔrɔ bɛɛ rɔ, a ni dibi. Alla la Nii tɛrɛ ye taa ni sɛ kɛla ji kunna san ma. ");
INSERT INTO msc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Alla ka a fɔ ko: «Kɛnɛ ye bɔ!» Kɛnɛ bɔra. ");
INSERT INTO msc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Alla ka a yen ko kɛnɛ ka ɲi. A ka kɛnɛ ni dibi fara i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A ka kɛnɛ tɔɔ la ko tele, ka dibi tɔɔ la ko su. Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon fɔlɔ ri. ");
INSERT INTO msc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Alla kumara ikɔ ko: «Dan ye kɛ jiilu tɛma, ka ii fara i ɲɔɔn na.» ");
INSERT INTO msc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Wo kɛra. Ji mɛn tɛrɛ san ma, a ni mɛn tɛrɛ duu ma, a ka woilu fara i ɲɔɔn na, ka kɛnɛgbɛ ladan ii tɛma. Alla ka a fɔ ɲa mɛn ma, a kɛra ten. ");
INSERT INTO msc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","A ka kɛnɛgbɛ tɔɔ la ko san. Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon filana ri. ");
INSERT INTO msc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Alla kumara ikɔ ko: «Ji mɛn ye san kɔrɔ, wo bɛɛ ye ladɛn yɔrɔ kelen dɔ, kosa gbelemala ye bɔ gbɛ ma.» A ka a fɔ ɲa mɛn ma, a kɛra wo ɲa ma. ");
INSERT INTO msc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","A ka gbelemala wo tɔɔ la ko duu, ka ji ladɛnnin tɔɔ la ko kɔɔji. Alla ka a yen ko wo ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nba, a ka a fɔ ko: «Binilu ni sumanilu ye fɛrɛn duu kan ka ii kisɛilu labɔ ka kɛ si ri. Jiri denta su bɛɛ fanan ye bɔ, mɛn ye kisɛ ni kolo kɛla ii den dɔ.» Alla ka a fɔ ɲa mɛn ma, a kɛra wo ɲa. ");
INSERT INTO msc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Duu ka bin su bɛɛ labɔ, mɛn ye kisɛ kɛla. Jiri denta su bɛɛ fanan bɔra, mɛn ye kisɛ ni kolo kɛla ii den dɔ. Alla ka a yen ko wo ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon sawana ri. ");
INSERT INTO msc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Alla kumara ikɔ ko: «Kɛnɛbɔlan ye bɔ san dɔ, ka tele ni su fara i ɲɔɔn na. Woilu ye sali lonilu yiraka, a ni lon damira ni san damira. ");
INSERT INTO msc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Woilu ye kɛ san dɔ, ka kɛnɛ labɔ duu kan.» Alla ka a fɔ ɲa mɛn ma, a kɛra ten. ");
INSERT INTO msc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Alla ka kɛnɛbɔlan belebele fila rabɛn, tele ni karo. Woilu rɔ bonba ba, tele kɔnin, Alla ka wo lasii lon kun na. Mɛn dɔɔman, karo kɔnin, a ka wo lasii su kun na. A ka loloilu fanan dan. ");
INSERT INTO msc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","A ka kɛnɛbɔlan woilu kɛ san dɔ, kosa ii ri kɛnɛ labɔ duu kan. ");
INSERT INTO msc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","A ka ii lasii tele ni su kun na, ka kɛnɛ ni dibi fara i ɲɔɔn na. Alla ka a yen ko wo ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon naaninna ri. ");
INSERT INTO msc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Alla kumara ikɔ ko: «Niimafen ye kɛ ji rɔ ka siyaya kosɛbɛ. Kɔnɔilu ye ii gban san ni duu tɛ.» ");
INSERT INTO msc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","A ka ji rɔ niimafen masilani belebelebailu dan, a ni ji rɔ niimafen tɔ bɛɛ. Fen woilu bɛɛ kɛra ji rɔ ka siyaya, a bɛɛ ni a su. A ka kɔnɔ su bɛɛ fanan dan. Alla ka a yen ko wo ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","A kumara ka baraka don ii rɔ. A ka a fɔ ko: «Ai ye jiri ka siyaya kɔɔji fan bɛɛ rɔ.» A ka a fɔ kɔnɔilu yɛ ko: «Ai ye jiri ka siyaya duukolo kan.» ");
INSERT INTO msc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon looluna ri. ");
INSERT INTO msc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Alla kumara ikɔ ko: «Nimafen su bɛɛ ye kɛ duu kan, so kɔndɔ kolofenilu wo, waa rɔ soboilu wo, ni niimafen mɛsɛn mɛn ye taamala duu ma, a bɛɛ ni a su!» A ka a fɔ ɲa mɛn ma, a kɛra ten. ");
INSERT INTO msc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Waarɔ sobo ni so kɔndɔ kolofen ni niimafen mɛsɛn mɛn ye taamala duu ma, a ka woilu su bɛɛ dan. Alla ka a yen ko wo ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Wo kɔ, Alla ka a fɔ ko: «An di adamaden dan ka a kɛ an munuɲa ri, ka a su sudunya an ɲɔɔn na. Ii ri ii sii duu bɛɛ kun na, ka ii sii jɛɛ kun na, a ni kɔnɔilu ni kolofenilu ni niimafen mɛsɛn mɛn ye taamala duu ma.» ");
INSERT INTO msc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nba, Alla ka adamaden dan ka a kɛ a jɛrɛ munuɲa le ri. Wo rɔ, a ka cɛɛ dan, ka muso fanan dan. A ka adamaden dan ten de. ");
INSERT INTO msc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Alla kumara ka baraka don ii rɔ. A ka a fɔ ko: «Ai ye jiri ka jɛnsɛn duu fan bɛɛ rɔ, ka ai la fanka sii duu kan. Ai ye ai sii jɛɛ ni kɔnɔilu ni niimafen tɔilu bɛɛ kun na.» ");
INSERT INTO msc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A ka a fɔ ii yɛ ko: «Duu suman su su, n da wo bɛɛ di ai ma. Ka a la wo kan, jiri denta fen fen ye duu kan, n da wo fanan bɛɛ di ai ma, mɛn ye kisɛ ni kolo kɛla ii denilu rɔ. Wo bɛɛ ri kɛ ai balo ri. ");
INSERT INTO msc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","So kɔndɔ kolofenilu ni waa rɔ soboilu ni kɔnɔilu ni niimafen mɛsɛn mɛn ye taamala duu ma, niimafen bɛɛ kɔnin, n da bin ni fira bɛɛ di woilu ma ka kɛ ii balo ri.» Nba, a ka a fɔ ɲa mɛn ma, a kɛra ten. ");
INSERT INTO msc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Alla ka dalifen mɛn dan, a ka a yen ko wo ka ɲi bakɛ. Nba, su kora ka kɛnɛ bɔ. Wo kɛra lon wɔɔrɔna ri. ");
INSERT INTO msc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nba, sankolo ni duukolo ni ii kɔndɔfen bɛɛ danda ɲa mɛn ma, wo le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tele wɔrɔnwulana sera ka a tɛrɛn Alla ra ban baarala. A ka a la baara bɛɛ ban tele wɔɔrɔ wo le kɔrɔ. Tele wɔrɔnwulana lon, a ka ɲɔɲɔ wo lon. ");
INSERT INTO msc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Alla ka tele wɔrɔnwulana bonya ka a bɔ lon tɔilu ma, ka a masɔrɔn a ma baara si kɛ wo lon. ");
INSERT INTO msc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nba, Alla ka sankolo ni duukolo dan ɲa mɛn ma, wo le ye ɲin di. Allabatala Alla ka sankolo ni duukolo dan tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","bin ni jiri tun tɛ duukolo kan fɔlɔ, baa Allabatala Alla tun ma sanci lana duu kan fɔlɔ. Mɔɔ si tun tɛ ye fɔlɔ ka duu sɛnɛ fanan. ");
INSERT INTO msc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tenke le tɛrɛ bɔla duu kɔrɔ ka duu yɔrɔ bɛɛ sɔ. ");
INSERT INTO msc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Allabatala Alla ka duu buuri ta ka adamaden dabɛn wo la. A ka ɲenemaya fɔɲɔ fɛ adamaden nunwo rɔ. Wo rɔ, adamaden wo kɛra nima ri. ");
INSERT INTO msc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nba, Allabatala Alla ka nakɔ labɔ Edɛni jamana rɔ, mɛn ye telebɔ fan fɛ. A tun ka adamaden mɛn dan, a ka wo bila nakɔ wo kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Allabatala Alla ka jiri su bɛɛ lafɛrɛn yɔrɔ wo rɔ, jiri mɛnilu ka ɲi kosɛbɛ. Ii den duman. A ka jiri su fila gbɛrɛ lafɛrɛn nakɔ tɛma. Kelen tɛrɛ ɲenemaya jiri ri. A tɔ kelen tɛrɛ mɔɔ lalɔnniɲala koɲuma ni kojuu faranfaasi la. ");
INSERT INTO msc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ba do tɛrɛ bɔni Edɛni jamana rɔ ka latamin nakɔ wo rɔ, mɛn ye a yɔrɔ bɛɛ sɔla ji la. A bɔ mɛn kɛni nakɔ wo rɔ, a farara ka kɛ ba bolo naanin di. ");
INSERT INTO msc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ba fɔlɔ tɔɔ ko Pisɔn. Wo ye woyenna ka Habila jamana laminin. Sanin ye bɔla jamana wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Sanin wo ye sanin jɛrɛwolo le ri. Jiri kasila latikɔlɔnnaman fanan ye ye. Kabakurun do fanan ye bɔla ye, mɛn tɔɔ ko onikisi. ");
INSERT INTO msc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ba filana tɔɔ ko Kiyɔn. Wo le ye woyenna ka Kusi bɔnsɔn na jamana bɛɛ laminin. ");
INSERT INTO msc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ba sawana tɔɔ ko Tikire. Wo le ye woyenna ka wa Asuri so telebɔ fan fɛ. Ba naaninna tɔɔ ko Efirati. ");
INSERT INTO msc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nba, Allabatala Alla ka adamaden bila Edɛni nakɔ ɲuma rɔ, ko a ye a sɛnɛ ka a janto a rɔ. ");
INSERT INTO msc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Allabatala Alla ka a fɔ a yɛ ko: «Jiriden dɔɔnta fen fen ye yan, i ye wo bɛɛ dɔɔn. ");
INSERT INTO msc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Kɔni, jiri mɛn ye mɔɔ lalɔnniɲala koɲuma ni kojuu faranfaasi la, i kana wo den dɔɔn de! Ni i ka a dɔɔn lon mɛn na, i ri faa.» ");
INSERT INTO msc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Wo kɔ, Allabatala Alla ka a fɔ ko: «Ka cɛɛ to a kelen na, wo ma ɲi. N di a dɛmɛnba rabɛn, mɛn di bɛn a ma.» ");
INSERT INTO msc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wo rɔ, Allabatala Alla ka sobo su bɛɛ ni kɔnɔ su bɛɛ dan duu buuri la, ka ii bɛɛ lana cɛɛ ma, kosa a ri ii kelen kelenna bɛɛ tɔɔ la. A ka tɔɔ mɛnilu fɔ, woilu kɛra ii tɔɔilu ri. ");
INSERT INTO msc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Cɛɛ ka tɔɔ la so kɔndɔ kolofen ni kɔnɔilu, ni waa rɔ soboilu bɛɛ la. Kɔni a dɛmɛnba ma sɔrɔn woilu rɔ, mɛn bɛnni a ma kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Wo rɔ Allabatala Alla ka sunoo ba don cɛɛ ɲa rɔ. A sunoora. Ka a to sunoo rɔ, Allabatala Alla ka barasa kolo kelen ta cɛɛ fari rɔ, ka sobo bila wo nɔ rɔ ka a da tuun wo la. ");
INSERT INTO msc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Allabatala Alla ka barasa kolo wo ta ka muso rabɛn, ka na muso di cɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Cɛɛ ka a fɔ ko: «A koloilu bɔni n koloilu le rɔ. A fari bɔni n fari le rɔ. N di a tɔɔ la ko muso, ka a masɔrɔn a bɔni cɛɛ le rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Wo le kosɔn, cɛɛ ri a mataa a fa ni a na la, ka to a muso fɛ. A fila ri kɛ mɔɔ kelen di. ");
INSERT INTO msc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nba, wo tuma cɛɛ ni a muso fila bɛɛ fari makolon de tɛrɛ, kɔni fari makolontɔya maloya tun tɛ ii la. ");
INSERT INTO msc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nba, Allabatala Alla ka waa rɔ sobo mɛnilu dan, duuma sa le kewuyani tɛrɛ wo tɔ bɛɛ ko. Lon do rɔ, sa ka a fɔ muso yɛ ko: «Tuɲa wa, Alla ka a fɔ ko: ‹Ai kana nakɔ ɲuma jiriden si dɔɔn?›» ");
INSERT INTO msc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Muso ka a jabi: «A sɔnni an ye nakɔ ɲuma jiriden dɔɔn. ");
INSERT INTO msc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kɔni jiri mɛn ye nakɔ ɲuma tɛma, Alla ka a fɔ an yɛ ko: ‹Ai kana wo le den dɔɔn. Ai kana ai maa a la. Ni ai ka ai maa a la, ai ri faa.›» ");
INSERT INTO msc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sa ka a fɔ muso yɛ ko: «Tuɲa tɛ wo rɔ. Ai tɛ faa fɛwu! ");
INSERT INTO msc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Alla ka a lɔn ko ai wa jiriden wo dɔɔn lon mɛn na, ai ri kɛ hankilimailu ri. Ai ri kɛ ikomin Alla, ka koɲuma ni kojuu faranfaasi lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Muso ka a yen ko jiriden wo ka ɲi, a duman kosɛbɛ. A ka a yen fanan ko jiriden wo ri mɔɔ kɛ hankilima ri. Wo rɔ, muso ka do kadi ka a dɔɔn, ka do di a cɛɛ ma, mɛn lɔni tɛrɛ a tɔrɔfɛ. Wo ka a ta ka a dɔɔn. ");
INSERT INTO msc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ii banni a dɔɔnna, ii ka hankili sɔrɔn ka ii jɛrɛ yen ɲa gbɛrɛ ma. Ii ka a yen ko ii fari makolon de. Ii ka toro firailu kara i ɲɔɔn na ka ii kɛ feriyabɔ ri ka ii jɛrɛ sutura. ");
INSERT INTO msc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Nba, wura fɛ, Allabatala Alla tɛrɛ ye a mataamala nakɔ ɲuma rɔ, fɔɲɔ tɛɛra dooni dooni waati mɛn na. Cɛɛ ni a muso ka a natɔla kan mɛn ka ibori a kɔrɔ ka wa ii dokon Alla ma jiriilu tɛma. ");
INSERT INTO msc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Allabatala Alla ka a kan nabɔ cɛɛ ma ko: «I ye mi?» ");
INSERT INTO msc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Cɛɛ ka a jabi: «N ka i natɔla kan mɛn nakɔ ɲuma rɔ tuma mɛn na, n silanda, baa n fari makolon de. Wo le kosɔn, n ka n dokon.» ");
INSERT INTO msc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Allabatala Alla ka a fɔ ko: «Yon de ka a fɔ i yɛ ko i fari makolon de? N ka tɔn sii jiri mɛn na, i ra wo le den dɔɔn wa?» ");
INSERT INTO msc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Cɛɛ ka a fɔ ko: «I ka muso mɛn di n ma, wo le ka jiriden wo di n ma. N ka a dɔɔn.» ");
INSERT INTO msc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Allabatala Alla ka a fɔ muso yɛ ko: «I ka nfen kɛ ɲin di?» Muso ka a fɔ ko: «Sa le ka n manɛɛn ka n lɔɔ a dɔɔnna.» ");
INSERT INTO msc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Allabatala Alla ka a fɔ sa yɛ ko: «I ra wo kɛ. Wo le kosɔn, n di tɔrɔya la i kan ka tamin kolofen ni waa rɔ sobo bɛɛ kan. Sisen i ri i sɔmɔn i kɔnɔ kan, ka buuri dɔɔn i la dunuɲaratɛɛ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","N di juuya ladon i ni muso tɛ, ka a ladon i bɔnsɔn ni a bɔnsɔn tɛ. A ri i kun gbasi. I fanan di a sen tintiri cin.» ");
INSERT INTO msc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Allabatala Alla ka a fɔ muso yɛ ko: «N di do la i la tin tɔrɔya kan. I ri i la kɔnɔmaya bɛɛ kɛ dun ba rɔ. A lɔɔ ri kɛ i la, ka sii i cɛɛ kun na, kɔni i ri to a fanka kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Allabatala Alla ka a fɔ Adama yɛ ko: «I ra i muso kan lamɛn ka jiriden dɔɔn, n ka tɔn sii mɛn na ko i kana a dɔɔn. Wo rɔ, n di duu tiɲan ile kosɔn. Duu tɛ sɔn ka i balo di i ma fo i wa baara siyaman kɛ. A ri kɛ wo ɲa i la dunuɲaratɛɛ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tiriwɔnin ni bin juu ri fɛrɛn duukolo kan kɔni i balo ri kɛ sɛnɛsumanilu ri. ");
INSERT INTO msc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","I tɛ balo sɔrɔn ni i ma wasi. A ri kɛ wo ɲa haan i wa i kɔsɛ duu rɔ, i danni duu mɛn dɔ kɔnin. I kɔsɛtɔ buuri wo le rɔ, baa i bɔni buuri le rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Nba, Adama ka a muso tɔɔ la ko Hawa, baa ale le kɛra mɔɔ bɛɛ na ri. ");
INSERT INTO msc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Allabatala Alla ka gbolo faanin doilu ladan ka woilu kɛ durukibailu ri ka ii bila Adama ni a muso kan na. ");
INSERT INTO msc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Allabatala Alla ka a fɔ ko: «Awa, cɛɛ ra kɛ ikomin ande do, ka koɲuma ni kojuu lɔn. A kana a bolo rasɔmɔn ma ɲenemaya jiri ma ka a den kadi ka a dɔɔn. Ni a ka a dɔɔn a ri to ɲenema rɔ habadan.» ");
INSERT INTO msc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Wo rɔ, Allabatala Alla ka ii labɔ Edɛni nakɔ ɲuma rɔ, ko ii ye wa duu sɛnɛ, Alla ka ii dan duu mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nba, Allabatala Alla ka Adama ni Hawa gbɛn ɲa wo le ma. A ka mɛlɛkailu lalɔ nakɔ ɲuma donda la telebɔ fan fɛ. A ka fanmuru fanan bila ye, ta ye mɛnɛnna mɛn na. Fanmuru tama wo ye mininmininna tuma bɛɛ. A ka woilu bila le ye, kosa mɔɔ si kana tamin ka wa ɲenemaya jiri ma. ");
INSERT INTO msc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nba, nbenba Adama ni a muso nma Hawa dɛnda. Nma Hawa ka kɔnɔ ta ka Kabila sɔrɔn. A ka a fɔ ko: «Allabatala da n dɛmɛn ka dencɛ sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Wo kɔ, a ka kɔnɔ ta ikɔ tuun ka Kabila dɔɔcɛ Abila sɔrɔn. Abila kɛra kolofengbɛngbɛnna ri. Kabila kɛra sɛnɛkɛla ri. ");
INSERT INTO msc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Lon do rɔ, Kabila ka a la sɛnɛsuman doilu ta ka na a la sɔ ka na woilu di Allabatala ma. ");
INSERT INTO msc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abila fanan ka a la saa doilu di Allabatala ma. Saa woilu tɛrɛ ii na den fɔlɔ le ri. Abila ka ii kannatɛɛ ka Allabatala sɔ ii ken dɔ. Abila ni a la saraka diyara Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kɔni Kabila ni a la saraka ma diya Allabatala yɛ. Kabila mɔnɛra wo rɔ kojuuya, ka a ɲa wulen kosɛbɛ! ");
INSERT INTO msc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Allabatala ka a fɔ Kabila yɛ ko: «Nfenna i ye mɔnɛla fɔɔ ka i ɲa wulen ten? ");
INSERT INTO msc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ni i ka koɲuma kɛ, n di n ban i rɔ wa? Ni i ma koɲuma kɛ, kojuu a ri kɛ ikomin wara, mɛn ye i makɔnɔla i la bon da la. A lɔɔ ri kɛ a la, ka sii i kun na, kɔni i kana sɔn a rɔ le, fo i ye se a la le.» ");
INSERT INTO msc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nba, Kabila ka a fɔ a dɔɔcɛ Abila yɛ ko: «An ye wa waa rɔ.» Ii sera ye tuma mɛn na Kabila bera a dɔɔcɛ kan ka a faa. ");
INSERT INTO msc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Allabatala ka a fɔ Kabila yɛ ko: «I dɔɔcɛ Abila ye mi?» Kabila ka a fɔ ko: «N ma a diya lɔn. Nde le a kɔnɔgbɛnba ri wa?» ");
INSERT INTO msc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Allabatala ka a fɔ ko: «I ka nfen kɛ ɲin? I dɔɔcɛ jeli bɔtɔla kule kan bɔra duu ma ka se n ma yan, ko ka a ta sara i la. ");
INSERT INTO msc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sisen, n di tɔrɔya la i kan. I wa fen fen sɛnɛ, a tɛ sɔn butun, baa i ra i dɔɔcɛ jeli le bɔ ka kɛ duu wo kan. ");
INSERT INTO msc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","I wa duu sɛnɛ, i tɛ suman foyi sɔrɔn a rɔ. I ri kɛ mɔɔ ri, sii yɔrɔ kelen tɛ mɛn bolo.» ");
INSERT INTO msc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kabila ka a fɔ Allabatala yɛ ko: «I ra n jahadi mɛn la n kan, wo ka bon ka tamin. N ti se wo kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","A ragbɛ! I ra n gbɛn ka bɔ duu kan bi. Fo n ye wa n dokon ka n bɔ i ɲakɔrɔ, ka kɛ mɔɔ ri, sii yɔrɔ kelen tɛ mɛn bolo. Mɛn wa n sɔrɔn wo ri n faa.» ");
INSERT INTO msc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Allabatala ka a fɔ Kabila yɛ ko: «Ni mɔɔ mɔɔ ka Kabila faa, n di i jeli sara wo la siɲa wɔrɔnwula.» Allabatala ka a tɔɔmasere la Kabila kan, sa mɔɔ mɛn wa a yen, wo kana a faa. ");
INSERT INTO msc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Wo rɔ, Kabila bɔra Allabatala ɲakɔrɔ ka wa i sii Nodi jamana rɔ, mɛn ye Edɛni jamana telebɔ fan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nba, Kabila ni a muso dɛnda. A muso ka kɔnɔ ta ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Hanɔki. Wo sɔrɔn kɔ, Kabila ka so do sii ka wo tɔɔ la a dencɛ Hanɔki la. ");
INSERT INTO msc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hanɔki ka Iradi sɔrɔn. Iradi ka Metujayeli sɔrɔn. Metujayeli ka Metusayeli sɔrɔn. Metusayeli ka Lamɛki sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamɛki ka muso fila ta. Kelen tɔɔ ko Ada. A tɔ kelen tɔɔ ko Tisila. ");
INSERT INTO msc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ka dencɛ sɔrɔn ka wo tɔɔ la ko Jabali. Mɔɔ mɛnilu ye ii siila faaninbonilu la ka ii la kolofenilu kɔnɔgbɛn, Jabali kɛra wo bɛɛ benba ri. ");
INSERT INTO msc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabali dɔɔcɛ le Jubali ri. Wo le kɛra korafɔla ni fulɛfɔla bɛɛ benba ri. ");
INSERT INTO msc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tisila fanan ka dencɛ sɔrɔn ka wo tɔɔ la ko Tubali Kabila. Wo kɛra numun di. A tɛrɛ ye sula ni nɛɛfin nadanna. Tubali Kabila dɔɔmuso tɔɔ ko Nama. ");
INSERT INTO msc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lon do rɔ, Lamɛki ka a fɔ a musoilu yɛ ko: «Ada ni Tisila, ai ye n kan namɛn. Ai, Lamɛki musoilu, ai ye ai tolo malɔ n na kuma la. Cɛɛ mɛn ka n madimin, n da wo faa. Kanberen mɛn sera n ma, n da wo faa. ");
INSERT INTO msc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","A fɔra ko ni mɔɔ mɛn ka Kabila faa, a julu ri sara wo tii la siɲa wɔrɔnwula. Kɔni Lamɛki la julu ri sara fɔɔ siɲa biwɔrɔnwula ni siɲa wɔrɔnwula.» ");
INSERT INTO msc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nba, Adama ni a muso dɛnda. A muso ka kɔnɔ ta ka dencɛ sɔrɔn ikɔ tuun. A ka wo tɔɔ la ko Sɛti, baa a ka a fɔ ko: «Alla ra dencɛ gbɛrɛ di n ma Abila nɔ rɔ, Kabila ka mɛn faa kɔnin.» ");
INSERT INTO msc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nba, Sɛti fanan ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Enosi. Mɔɔilu ka Allabatala tara damira Enosi tele le rɔ, ko a ye ii dɛmɛn. ");
INSERT INTO msc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama bɔnsɔn tɔɔ le sɛbɛni ɲin di. Alla ka mɔɔ dan lon mɛn na, a ka a dan ka a kɛ a jɛrɛ munuɲa le ri. ");
INSERT INTO msc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","A ka ii dan ka ii kɛ cɛɛ ni muso ri. A banni ii danna, a kumara ka baraka don ii rɔ ka ii tɔɔ la ko mɔɔ. ");
INSERT INTO msc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama sɔrɔn ka san kɛmɛ ni san bisawa bɔ tuma mɛn na, a ka dencɛ sɔrɔn, mɛn kɛra a la munuɲa ri. Adama ni a dencɛ tɛrɛ su kelen de ri. A ka a tɔɔ la ko Sɛti. ");
INSERT INTO msc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛti sɔrɔn kɔrɔ, Adama ka san kɛmɛ seyin de kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A si san bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san bisawa le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛti si ka san kɛmɛ ni san loolu bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Enosi. ");
INSERT INTO msc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosi sɔrɔn kɔrɔ, Sɛti ka san kɛmɛ seyin ni san wɔrɔnwula le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛti si san bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san tan ni fila le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi si ka san bikɔnɔndɔ bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Kenan. ");
INSERT INTO msc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan sɔrɔn kɔrɔ, Enosi ka san kɛmɛ seyin ni san tan ni loolu le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi si san bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san loolu le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan si ka san biwɔrɔnwula bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Mahalalɛli. ");
INSERT INTO msc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalɛli sɔrɔn kɔrɔ, Kenan ka san kɛmɛ seyin ni san binaanin de kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan si san bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san tan de ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalɛli si ka san biwɔɔrɔ ni san loolu bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Jɛrɛdi. ");
INSERT INTO msc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jɛrɛdi sɔrɔn kɔrɔ, Mahalalɛli ka san kɛmɛ seyin ni san bisawa le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalɛli si san bɛɛ ladɛnnin kɛra san kɛmɛ seyin ni san bikɔnɔndɔ ni san loolu le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jɛrɛdi si ka san kɛmɛ ni san biwɔɔrɔ ni san fila bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Hanɔki. ");
INSERT INTO msc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Hanɔki sɔrɔn kɔrɔ, Jɛrɛdi ka san kɛmɛ seyin de kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jɛrɛdi si san bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san biwɔɔrɔ ni san fila le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hanɔki si ka san biwɔɔrɔ ni san loolu bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Metusalemu. ");
INSERT INTO msc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusalemu sɔrɔn kɔrɔ, Hanɔki ka san kɛmɛ sawa le kɛ Alla la dɛn dɔ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hanɔki si san bɛɛ ladɛnnin kɛra san kɛmɛ sawa ni san biwɔɔrɔ ni san loolu le ri. ");
INSERT INTO msc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hanɔki mɛnda Alla la dɛn dɔ. A tunura ka a masɔrɔn Alla ka a ta ka wa a ri. ");
INSERT INTO msc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalemu si ka san kɛmɛ ni san biseyin ni san wɔrɔnwula bɔ tuma mɛn na, a ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Lamɛki. ");
INSERT INTO msc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamɛki sɔrɔn kɔrɔ, Metusalemu ka san kɛmɛ wɔrɔnwula ni san biseyin ni san fila le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusalemu si bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san biwɔɔrɔ ni san kɔnɔndɔ le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamɛki si ka san kɛmɛ ni san biseyin ni san fila bɔ tuma mɛn na, a ka dencɛ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","A ka wo tɔɔ la ko Nuhan. A ka a fɔ ko: «Allabatala ka duu tiɲan ka an bila baara gbɛlɛn dɔ. Kɔni cɛɛ ɲin de kɛtɔ an masabarila baara gbɛlɛn jusukasi kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhan sɔrɔn kɔrɔ, Lamɛki ka san kɛmɛ loolu ni san bikɔnɔndɔ ni san loolu le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamɛki si bɛɛ ladɛnnin kɛra san kɛmɛ wɔrɔnwula ni san biwɔrɔnwula ni san wɔrɔnwula le ri. Wo dafanin, a sara. ");
INSERT INTO msc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhan ka san kɛmɛ loolu sɔrɔn tuma mɛn na, a ka Sɛmu ni Hamu ni Jafɛti sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nba, mɔɔilu tɛrɛ ye siyaya la duukolo kan tuma mɛn na, ii ka denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wo kɛni, Alla dencɛilu ka ii ɲa lɔ denmuso woilu rɔ ka a yen ko woilu kenɲi kosɛbɛ. Mɛnilu diyara ii yɛ, ii ka woilu ta ka ii kɛ ii musoilu ri. ");
INSERT INTO msc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Wo le rɔ, Allabatala ka a fɔ ko: «N ka n na nii don mɔɔilu rɔ, kɔni n tɛ sɔn a ye mɛn ii rɔ fɔɔ habadan, baa ii tɛ foyi ri fo faribanku, fen banta kɔnin. Ii si san bɛɛ ladɛnnin tɛ tamin san kɛmɛ ni san muwan kan.» ");
INSERT INTO msc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Alla dencɛilu sera mɔɔilu denmusoilu ma tuma mɛn na, woilu ka kɔnɔ ta ka deni sɔrɔn. Den woilu kɛra mɔɔilu jan belebele ri, mɛnilu tɔɔ ko Nefilimu. Kɛbi waati taminni, woilu kɛra cɛɛ fadiyanin di. Ii tɔɔilu bɔra kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Allabatala ka a yen ko adamadenilu kɔnɔrɔjuuya ra wara dunuɲa rɔ. A ka a yen ko fen si tɔ adamadenilu jusu rɔ fɔɔ miriyajuu tuma bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Allabatala nimisara adamadenilu dan ko rɔ duukolo kan. A sɛwani tun tɛ. ");
INSERT INTO msc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A ka a fɔ ko: «N da mɔɔ mɛnilu dan, n di woilu halaki ka ii bɔ duukolo kan. Adamadenilu wo, kolofenilu wo, waa rɔ soboilu wo, kɔnɔilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, n di wo bɛɛ halaki ka a masɔrɔn n da nimisa ii dan ko rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kɔni Nuhan diyara Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhan bɔnsɔn de ɲin di. Nuhan de tɛrɛ mɔɔ telenni ri. A kelen de ma kojuu kɛ a la waati rɔ. A mɛnda Alla la dɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","A ka dencɛ sawa sɔrɔn, Sɛmu ni Hamu ni Jafɛti. ");
INSERT INTO msc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Wo tuma, juuya warani fan bɛɛ Alla ɲakɔrɔ duukolo kan. Mɔɔilu karagbɛlɛman tɛrɛ i ɲɔɔn na fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Alla ka a yen ko duukolo ra tiɲan juuya la. Mɔɔ bɛɛ kɛwali ra juuya fɔɔ ka a dan natamin. ");
INSERT INTO msc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Wo rɔ, Alla ka a fɔ Nuhan yɛ ko: «N da a latɛɛ ko mɔɔilu bɛɛ ri halaki n bolo, baa karagbɛlɛya ra jɛnsɛn ii bolo fɔɔ ka duukolo fa. N kɛtɔ ii bɛɛ ni duukolo halakila i ɲɔɔn fɛ le. ");
INSERT INTO msc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wa jiri ɲuma ɲinin ka kulunba rabɛn i jɛrɛ yɛ. I ye a kɔndɔ ratala ka a kɛ bonkɔndɔilu ri, ka ban ka a kɔndɔla ni a kɔkanna bɛɛ mamun tulubɔ fasani la. ");
INSERT INTO msc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","I ye a rabɛnna ɲa mɛn ma, wo le ye ɲin di. I ye a janya kɛ nunkan ɲa kɛmɛ sawa ri, ka a kɔndɔ kɛ nunkan ɲa biloolu ri, ka a lɔ kɛ nunkan ɲa bisawa ri. ");
INSERT INTO msc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","I ye fɔɲɔ don yɔrɔ bɔ a san fɛ, ka wo lɔ kɛ nunkan ɲa kelen di. I ye donda bɔ kulunba fan kelen fɛ, ka kulunba kɛ ikomin sankaso, ka a kɛ duuma bon ni tɛma bon ni san ma bon di. ");
INSERT INTO msc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","N jɛrɛ kɛtɔ ji dunba lanala duu kan. Fen fen ye a niilakili san kɔrɔ, wo bɛɛ ri halaki. Fen bɛɛ ri faa duu kan. ");
INSERT INTO msc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kɔni n di teriya ta i yɛ ka i kisi. I ri don kulunba kɔndɔ, i ni i dencɛilu, a ni i muso ni i dencɛilu musoilu. ");
INSERT INTO msc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","I ye niimafen su bɛɛ fila fila ladon i fɛ kulunba kɔndɔ, cɛman ni musoman, sa woilu ri to niimaya rɔ. ");
INSERT INTO msc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kɔnɔilu wo, kolofenilu wo, waa rɔ soboilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, a su bɛɛ fila fila ri na i ma sa ii ri to niimaya rɔ. ");
INSERT INTO msc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I ye dɔɔnninfen su bɛɛ do ta ka a lamara i fɛ kulunba kɔndɔ. Wo ri kɛ balo ri ile ni woilu yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nba, Alla ka Nuhan jamari ko ko la, Nuhan ka wo bɛɛ kɛ ikomin a fɔra a yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nba, Allabatala ka a fɔ Nuhan yɛ ko: «I ye don kulunba kɔndɔ, i ni i la denbaya. N da a yen ko i kelen pe le telenni n ɲakɔrɔ adamaden bɛɛ tɛma. ");
INSERT INTO msc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","I ye sobo sɛniman su bɛɛ ta i fɛ, a cɛman wɔrɔnwula ni a musoman wɔrɔnwula. Sobo mɛn sɛniman tɛ, i ye wo su bɛɛ fanan ta, cɛman kelen ni musoman kelen. ");
INSERT INTO msc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","I ye kɔnɔ su bɛɛ fanan ta, cɛman wɔrɔnwula ni musoman wɔrɔnwula, sa ii siya kana tunu duukolo kan. ");
INSERT INTO msc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","A ra to tele wɔrɔnwula ma. Wo wa dafa, n di sanci lana duukolo kan. Sanci wo ri tele binaanin ni su binaanin kɛ nali la. Wo ri kɛ sababu ri. Fen mɛnilu danni n bolo, wo bɛɛ ri halaki ka bɔ duu kan.» ");
INSERT INTO msc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Allabatala ka Nuhan jamari ko ko la, a ka wo bɛɛ kɛ. ");
INSERT INTO msc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nba, ka a tɛrɛn Nuhan sɔrɔn da san kɛmɛ wɔɔrɔ bɔ, ji dunba nara duukolo kan. ");
INSERT INTO msc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhan ni a dencɛilu ni a muso ni a dencɛilu musoilu, ii bɛɛ donda kulunba kɔndɔ kosa ii ri kisi ji dunba ma. ");
INSERT INTO msc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Wo lon, sobo mɛnilu sɛniman a ni mɛnilu sɛniman tɛ, a ni kɔnɔilu ni niimafen mɛsɛn mɛnilu ye taamala duu ma, ");
INSERT INTO msc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wo bɛɛ fila fila nara Nuhan ma, a cɛman ni a musoman. Ii bɛɛ donda kulunba kɔndɔ, ikomin Alla ka Nuhan jamari ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","A tele wɔrɔnwulana, sanci nara duukolo kan. ");
INSERT INTO msc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhan sɔrɔn san kɛmɛ wɔɔrɔna, wo karo filana tele tan ni wɔrɔnwulana, ji bondon mɛn ye duu kɔrɔ, wo tera ka ji bɔn duu kan. Sankolo ji bondon fanan da lakara. ");
INSERT INTO msc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Wo rɔ, sanci ba nara duu kan. A ka tele binaanin ni su binaanin kɛ, a ma tɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Sanci nara lon mɛn, wo lon kelen Nuhan ni a dencɛilu donda kulunba kɔndɔ. A dencɛilu le tɛrɛ Sɛmu ni Hamu ni Jafɛti ri. Nuhan muso donda ii fɛ, a ni a dencɛilu muso sawa. ");
INSERT INTO msc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nimafen su bɛɛ donda kulunba kɔndɔ ii fɛ. Waarɔ soboilu wo, kolofenilu wo, niimafen mɛsɛn mɛnilu ye taamala duu ma, a ni kɔnɔilu wo, kawa ye fen fen na, woilu su bɛɛ donda. ");
INSERT INTO msc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nba, fen fen ye a niilakili, wo bɛɛ fila fila donda kulunba kɔndɔ Nuhan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nimafen su bɛɛ donda, cɛman ni musoman, ikomin Alla ka jamarili kɛ ɲa mɛn ma. Ii bɛɛ donda tuma mɛn na, Allabatala ka kulunba da tuun Nuhan ma. ");
INSERT INTO msc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nba, sanci ka tele binaanin kɛ, a ye nala duukolo kan. Ji siyayara ka kɛ ji dunba ri, ka kulunba kɔrɔta ka bɔ duu ma. ");
INSERT INTO msc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ji yɛlɛra ka siyaya kosɛbɛ. Kulunba funda ji kan ka wa. ");
INSERT INTO msc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ji tora yɛlɛla kojuuya fɔɔ ka koyinkɛ bɛɛ latunun fan bɛɛ san kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ji yɛlɛra koyinkɛ woilu kun na ka se fo nunkan ɲa tan ni loolu, ka koyinkɛ latunun fewu! ");
INSERT INTO msc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nimafen bɛɛ faara duukolo kan. Kɔnɔilu wo, kolofenilu wo, waa rɔ soboilu wo, niimafen mɛsɛnilu wo, mɛnilu ye taamala duu ma, mɔɔilu wo, ii bɛɛ faara. ");
INSERT INTO msc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Fen fen ye duukolo kan, ni a ye a niilakilila, wo bɛɛ faara. ");
INSERT INTO msc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Allabatala ka duukolo niimafen bɛɛ halaki wo ɲa le ma. Mɔɔilu wo, soboilu wo, kɔnɔilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, ii bɛɛ halakira ka bɔ duukolo kan. A tora Nuhan dɔrɔn de ma, a ni mɛnilu tɛrɛ a kun kulunba kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ji ka tele kɛmɛ ni biloolu kɛ duukolo kan, a ma majii. ");
INSERT INTO msc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kɔni Alla hankili tora Nuhan dɔ, a ni waa rɔ soboilu ni so kɔndɔ kolofenilu, mɛnilu tɛrɛ a kun kulunba kɔndɔ. Wo rɔ, Alla ka fɔɲɔ lawuli ka a tɛɛ duu kan ka ji majii. ");
INSERT INTO msc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Duukolo ji bondon da tuunda, a ni sankolo ji bondon. Sanci tɛɛra. ");
INSERT INTO msc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ji tora majiila dooni dooni duukolo kan. Tele kɛmɛ ni tele biloolu taminda tuma mɛn na, ji madooyara. ");
INSERT INTO msc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","A karo wɔrɔnwulana tele tan ni wɔrɔnwulana, kulunba nara i sii Arara jamana koyinkɛ do kan. ");
INSERT INTO msc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ji tora madooyala fɔɔ ka se karo tanna ma. Wo karo tele fɔlɔ, koyinkɛilu kunilu bɔra. ");
INSERT INTO msc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tele binaanin taminda tuma mɛn na, Nuhan ka fɔɲɔ don da laka, a tun ka mɛn bɔ kulunba la. ");
INSERT INTO msc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","A ka ɲaɲasila do bila. Wo bɔra ka taa ni sɛ kɛ haan ji yara duukolo kan tuma mɛn na. ");
INSERT INTO msc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Wo kɔ, a ka kanba do bila ka a kɔrɔsi ni ji ra dɔɔya duukolo kan. ");
INSERT INTO msc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kanba wo bɔ mɛn kɛni, a ma sii yɔrɔ sɔrɔn. A ka a kɔsɛ ka na Nuhan ma kulunba kɔndɔ, baa ji tɛrɛ ye duukolo yɔrɔ bɛɛ kan fɔlɔ. Nuhan ka a bolo labɔ ka kanba mira ka a ladon a fɛ kulunba kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhan ka a to tele wɔrɔnwula ye tamin ikɔ tuun, ka ban ka kanba bila ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wura fɛ, kanba ka a kɔsɛ Nuhan ma. Olibiye fira kɛndɛ ye a da la. Nuhan ka a lɔn wo le rɔ ko ji ra fɔlɔ madɔɔyala duukolo ka a fɔ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A ka a to tele wɔrɔnwula ye tamin ikɔ, ka ban ka kanba bila. Kanba wa mɛn kɛni, a ma a kɔsɛ Nuhan ma wo kɔ. ");
INSERT INTO msc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhan sɔrɔn san kɛmɛ wɔɔrɔ ni kelen, wo karo fɔlɔ tele fɔlɔ, ji tun tɛ duukolo kan butun. Nuhan ka kulunba kunnafen waranka ka a yen ko duu ra fɔlɔ jala. ");
INSERT INTO msc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","A karo filana tele muwan ni wɔrɔnwulana sera ka a tɛrɛn duu ra ja fewu! ");
INSERT INTO msc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nba, Alla kumara Nuhan fɛ ko: ");
INSERT INTO msc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«I ye bɔ kulunba kɔndɔ sisen, i ni i muso ni i dencɛilu ni ii musoilu. ");
INSERT INTO msc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","I ye niimafen bɛɛ labɔ. Kɔnɔilu wo, waa rɔ soboilu wo, so kɔndɔ kolofenilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, i ye ii bɛɛ labɔ, sa ii ri jiri ka siyaya duukolo fan bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wo rɔ, Nuhan bɔra kulunba kɔndɔ, a ni a dencɛilu ni a muso ni a dencɛilu musoilu. ");
INSERT INTO msc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nimafen bɛɛ bɔra. Waarɔ soboilu wo, so kɔndɔ kolofenilu wo, kɔnɔilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, bɛɛ ni a la siya bɔra kulunba kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhan ka Alla saraka janin diya do lɔ ka Allabatala bato kanma. A ka sobo sɛniman ni kɔnɔ sɛniman su bɛɛ do ta ka Allabatala sɔ ii rɔ. A ka ii janin Alla saraka janin diya wo kan, ka ii kɛ buuri ri. ");
INSERT INTO msc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Saraka wo suma diyara Allabatala yɛ. Allabatala ka a latɛɛ ko: «N tɛ duu danka adamaden kosɔn butun. N ka a lɔn ko ka bɔ ii den mɛsɛnya waati ma fɔɔ ka na se ii la mɔɔya laban ma, ii miriya bɛnni kojuu le ma. Hali wo, n tɛ sɔn ka niimafen bɛɛ halaki butun, ikomin n ka a kɛ ɲa mɛn ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ka bɔ bi ma ka wa haan dunuɲa laban, si foyi tuma ni suman ka tuma, nɛnɛ tuma ni tara tuma, sanma ni telema, su ni tele, wo si tɛ ban.» ");
INSERT INTO msc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Alla kumara ka baraka don Nuhan ni a dencɛilu rɔ. A ka a fɔ ii yɛ ko: «Ai ye jiri ka siyaya duukolo fan bɛɛ rɔ ka a fa. ");
INSERT INTO msc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nimafen bɛɛ ri silan ai yɛ kosɛbɛ. Waarɔ soboilu wo, so kɔndɔ kolofenilu wo, kɔnɔilu wo, jɛɛilu wo, ni niimafen mɛsɛn mɛnilu ye taamala duu ma, wo bɛɛ ri silan ai yɛ. Ii bɛɛ ri kɛ ai la fanka kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nimafen bɛɛ ri kɛ balo ri ai yɛ. N ka suman di ai ma ɲa mɛn ma, n ye niimafenilu fanan dila ai ma ɲa kelen wo le ma. ");
INSERT INTO msc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kɔni ai kana sobo ni a jeli dɔɔn muumɛ! Baa a nimaya ye a jeli le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ni sobo do ka mɔɔ jeli labɔ ka a faa, sobo wo ka kan ka faa. Ni mɔɔ do ka a mɔɔɲɔɔ faa, wo fanan di faa. ");
INSERT INTO msc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Nde Alla ka mɔɔ dan ka a kɛ n jɛrɛ munuɲa le ri. Wo rɔ, mɔɔ mɔɔ wa a mɔɔɲɔɔ jeli labɔ ka a faa, mɔɔ ri wo fanan jeli labɔ ka a faa. ");
INSERT INTO msc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nba, ai kɔnin, ai ye jiri ka siyaya. Ai ye sɛrɛya ka siyaya duukolo fan bɛɛ rɔ ka a fa.» ");
INSERT INTO msc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Alla ka a fɔ Nuhan ni a dencɛilu yɛ ko: ");
INSERT INTO msc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Sisen teriya ri tɔ nde ni aile tɛma, a ni ai bɔnsɔn mɛn ye nala ai kɔ ");
INSERT INTO msc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","a ni duukolo niimafen, mɛn bɛɛ tɛrɛ ai kun, fen fen bɔra ai fɛ kulunba kɔndɔ, kɔnɔilu wo, so kɔndɔ kolofenilu wo, waa rɔ soboilu wo. ");
INSERT INTO msc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Teriya ɲin ye tɔla n ni duukolo niimafen bɛɛ tɛma. Ji dunba tɛ niimafen bɛɛ halaki butun. Ji dunba tɛ kɛ butun ka duukolo bɛɛ tiɲan.» ");
INSERT INTO msc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Alla ka a fɔ ikɔ ko: «N ye teriya mɛn tala ai yɛ a ni ai bɔnsɔn bɛɛ ni niimafen bɛɛ fɔɔ habadan, wo tɔɔmasere le ɲin di. ");
INSERT INTO msc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","N di nincinankan labɔ san fɛ bandafin kɔrɔ. Nincinankan wo le n na teriya tɔɔmasere le ri, n ye teriya mɛn tala dunuɲa bɛɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tuma tuma, ni n ka bandafin nadɛn duukolo kun na, ni nincinankan fanan bɔra, ");
INSERT INTO msc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","wo rɔ, n di n hankili bila n na teriya rɔ, n ka mɛn ta ai ni niimafen su bɛɛ yɛ. N tɛ ji siyaya ka a kɛ ji dunba ri butun ka niimafen bɛɛ halaki. ");
INSERT INTO msc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nincinankan wa bɔ bandafin kɔrɔ, n di wo yen ka n hankili bila n na teriya banbali rɔ, n ka mɛn ta duukolo niimafen su bɛɛ yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Alla ka a fɔ Nuhan yɛ ko: «N da teriya mɛn ta duukolo niimafen bɛɛ yɛ, wo tɔɔmasere le wo ri.» ");
INSERT INTO msc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Nba, Nuhan dencɛ mɛnilu bɔra a fɛ kulunba kɔndɔ, woilu le tɛrɛ Sɛmu ni Hamu ni Jafɛti ri. Nuhan dencɛ sawa le woilu ri. Woilu le bɔnsɔn jɛnsɛnda ka se duukolo fan bɛɛ rɔ. Wo rɔ, Kanaan fa le tɛrɛ Hamu ri. ");
INSERT INTO msc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nba, Nuhan ka sɛnɛ damira. Ale le fɔlɔ ka rɛsɛnfɛ sɛnɛ. ");
INSERT INTO msc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lon do rɔ, Nuhan ka rɛsɛnji do min ka a ɲa laminin. A fari makolon lani tɛrɛ a la faaninbon kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaan fa Hamu ka a fa Nuhan fari makolon yen, ka wa wo fɔ a badenma fila yɛ lu ma. ");
INSERT INTO msc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sɛmu ni Jafɛti ka durukiba ta ka a la ii kanbankun kan ka don ii kɔnkɔma ii fa la faaninbon na ka ii fa sutura. Ii ma sɔn ii ɲayen na ii fa kan, kosa ii kana a fari makolon yen fewu. ");
INSERT INTO msc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nba, rɛsɛnji ka Nuhan bila tumana mɛn na, a dencɛ dɔɔmanni Hamu ka ko mɛn kɛ a la, wo fɔra a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Wo rɔ, Nuhan ka a fɔ ko: «Alla ma tɔrɔya lara Hamu dencɛ Kanaan kan. Ka a kɛ a kɔrɔcɛilu la jɔntajɔn di, Alla ma wo kɛra.» ");
INSERT INTO msc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuhan ka a fɔ ko: «N di Allabatala tando, Sɛmu Maari Alla kɔnin. Alla ma Kanaan kɛ Sɛmu la jɔn di, Alla ma wo kɛra. ");
INSERT INTO msc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Alla ma Jafɛti bonyara, Ka a bɔnsɔn sii Sɛmu bɔnsɔn fɛ, Alla ma wo kɛra. Alla ma Kanaan kɛ ii la jɔn di, Alla ma wo kɛra.» ");
INSERT INTO msc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nba, ji dunba tamin kɔ, Nuhan ka san kɛmɛ sawa ni san biloolu le kɛ. ");
INSERT INTO msc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","A si bɛɛ ladɛnnin kɛra san kɛmɛ kɔnɔndɔ ni san biloolu le ri. Wo bɛɛ taminni, a sara. ");
INSERT INTO msc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ji dunba tamin kɔ, Nuhan dencɛilu Sɛmu ni Hamu ni Jafɛti ka dencɛilu sɔrɔn. Ii bɔnsɔn le ɲin di. ");
INSERT INTO msc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafɛti dencɛilu le ten: Komɛri, Makɔki, Madayi, Jaban, Tubali, Mesɛki a ni Tirasi. ");
INSERT INTO msc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Komɛri dencɛilu le Asikɛnasi, ni Rifati ni Tokarima ri. ");
INSERT INTO msc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Jaban dencɛilu le ten: Elisiya, Tarasisi, Kitimu a ni Dodanimu. ");
INSERT INTO msc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Jaban bɔnsɔn jɛnsɛnda ka wa i sii kɔɔji da la, a bɛɛ ni a la duu, a bɛɛ ni a la kumakan, a bɛɛ ni a mɔɔilu, a bɛɛ ni a la jamana. ");
INSERT INTO msc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hamu dencɛilu le ten: Kusi, Misiran, Puti a ni Kanaan. ");
INSERT INTO msc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi dencɛilu le ten: Sɛba, Habila, Sabita, Rayɛma a ni Sabiteka. Rayɛma dencɛilu le Seba ni Dedan di. ");
INSERT INTO msc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi dencɛ do le Nimurodu ri. Wo le fɔlɔ kɛra fankatii ri duukolo kan. ");
INSERT INTO msc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","A kɛra donso fadimanba ri Allabatala ɲana. Wo rɔ a ye fɔla doilu ma ko: «A kɛni donso fadimanba le ri, Allabatala ɲakɔrɔ ikomin Nimurodu tɛrɛ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimurodu kɛra faama ri. A fɔlɔma le ka a sii Babilɔni ni Erɛki ni Akadi soilu kun na. So sawa wo bɛɛ tɛrɛ Sineyari jamana le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","A bɔra jamana wo rɔ ka wa Asuri jamana rɔ. A ka Ninibe ni Rehobotiri ni Kalasi ");
INSERT INTO msc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ni Resɛni soilu sii ka ii lɔ. Resɛni ye Ninibe ni Kalasi so fila le tɛ. So ba le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misiran kɛra mɛnilu benba ri, woilu le ten: Ludi bɔnsɔn, Anamu bɔnsɔn, Lehabi bɔnsɔn, Nafitu bɔnsɔn, ");
INSERT INTO msc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patirusi bɔnsɔn, Kafitori bɔnsɔn a ni Kasiluhi bɔnsɔn. Filisitiilu bɔra Kasiluhi bɔnsɔn le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan dencɛ fɔlɔ le tɛrɛ Sidɔn di, ka Hɛti tuun wo la. ");
INSERT INTO msc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","18","Mɔɔ mɛnilu fanan bɔra Kanaan dɔ, woilu le ten: Jebusikailu, Amɔrikailu, Kirikasikailu, Hifikailu, Arikailu, Sinikailu, Arifadikailu, Semarikailu a ni Hamarikailu. Kanaanka jɛnsɛnda. ");
INSERT INTO msc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ii la jamana ye damirala Sidɔn de ka wa Kerari fan fɛ, ka wa se fɔɔ Kasa. A ye wala Sɔdɔmu ni Kɔmɔri ni Adima ni Seboyimu fan fɛ, ka wa se fɔɔ Lesa. ");
INSERT INTO msc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hamu bɔnsɔn de woilu ri, a bɛɛ ni a la mɔɔilu, a bɛɛ ni a kumakan, a bɛɛ ni a la duu, a bɛɛ ni a la jamana. ");
INSERT INTO msc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jafɛti kɔrɔcɛ Sɛmu fanan ka dencɛilu sɔrɔn. Sɛmu wo le kɛra Ebɛri bɔnsɔn bɛɛ benba ri. ");
INSERT INTO msc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛmu dencɛilu le ten: Elamu, Asuri, Aripasadi, Ludi a ni Aramu. ");
INSERT INTO msc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramu dencɛilu le ten: Usi, Huli, Kɛtɛri a ni Masi. ");
INSERT INTO msc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripasadi wo ka Selasi sɔrɔn. Selasi ka Ebɛri sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebɛri ka dencɛ fila sɔrɔn. Kelen tɔɔ ko Pelɛji ka a masɔrɔn duukolo ratalara a tele le rɔ. A dɔɔcɛ tɔɔ ko Jokitan. ");
INSERT INTO msc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Jokitan dencɛilu le ten: Alimodadi, Selɛfu, Hasamawɛti, Jeraki, Hadoramu, Usali, Dikila, Obali, Abimayɛli, Seba, Ofiri, Habila a ni Jobabu. Nba, woilu bɛɛ tɛrɛ Jokitan dencɛilu le ri. ");
INSERT INTO msc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Duu mɛn ye Mesa ni Sefari tɛ, ii ta le tɛrɛ wo bɛɛ ri. Yɔrɔ wo ye koyinkɛilu kɔrɔ telebɔ fan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nba woilu bɛɛ kɛra Sɛmu denni le ri, a bɛɛ ni a la mɔɔilu, a bɛɛ ni a la kumakan, a bɛɛ ni a la duu, a bɛɛ ni a la jamana. ");
INSERT INTO msc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nba, Nuhan dencɛilu bɔnsɔn de woilu ri, a bɛɛ ni a bɔnsɔn, a bɛɛ ni a jamana. Mɔɔ woilu le jɛnsɛnda ka kɛ jamana siyaman di duukolo kan ji dunba kɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dunuɲa mɔɔilu bɛɛ tɛrɛ ye kan kelen de mɛnna. Ii bɛɛ tɛrɛ ye i ɲɔɔn famunna. ");
INSERT INTO msc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ii bɔra telebɔ fan dɔ, ka wa gbɛkannan ba do tɛrɛn Sineyari jamana rɔ. Ii ka i sii dinkira wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lon do rɔ, ii ka a fɔ i ɲɔɔn yɛ ko: «An ye birikiilu gbasi ka ii janin kosɛbɛ.» Ii ma kabakurun ta fɔɔ biriki. Ii ma boro fanan ta, fɔɔ tulubɔ fasani. ");
INSERT INTO msc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ii ka a fɔ ko: «An ye so lɔ an jɛrɛ yɛ, ka sankaso jan lɔ a kɔndɔ. Wo lɔ ye se haan sankolo ma, sa an di tɔɔ sɔrɔn. Ni an ma wo kɛ, an di jɛnsɛn duukolo fan bɛɛ fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Allabatala jiira ka so ni sankaso jan dagbɛ, adamadenilu ka mɛn lɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","A ka a fɔ ko: «A ragbɛ. Ii bɛɛ ye siya kelen de ri, ii bɛɛ ye kan kelen de mɛnna. Ii ye baara mɛn kan ɲin, ii la baara fɔlɔ le wo ri. A tɛ mɛn bakɛ, ii wa ii miri fen fen ma, ii ri se wo kɛla. ");
INSERT INTO msc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","An ye jii ka ii kan basan, sa ii kana se i ɲɔɔn kan mɛnna butun.» ");
INSERT INTO msc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wo rɔ, Allabatala ka ii farafara ka ii bɔ dinkira wo rɔ, ka ii jɛnsɛn duukolo fan bɛɛ rɔ. Ii la so lɔ ko ra dan wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Wo le kosɔn, dinkira wo tɔɔ lara ko Babɛli, baa Allabatala ka dunuɲa mɔɔilu bɛɛ kumakan basan ye le, ka ban ka ii jɛnsɛn duukolo fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nba, Sɛmu bɔnsɔn de ɲin di. Sɛmu sɔrɔn ka san kɛmɛ bɔ tuma mɛn na, a ka Aripasadi sɔrɔn. Wo kɛra san fila ji dunba kɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aripasadi sɔrɔn kɔrɔ, Sɛmu ka san kɛmɛ loolu le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aripasadi sɔrɔn ka san bisawa ni san loolu bɔ tuma mɛn na, a ka Selasi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selasi sɔrɔn kɔrɔ, Aripasadi ka san kɛmɛ naanin ni san sawa le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selasi sɔrɔn ka san bisawa bɔ tuma mɛn na, a ka Ebɛri sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebɛri sɔrɔn kɔrɔ, Selasi ka san kɛmɛ naanin ni san sawa le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebɛri sɔrɔn ka san bisawa ni san naanin bɔ tuma mɛn na, a ka Pelɛji sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛji sɔrɔn kɔrɔ, Ebɛri ka san kɛmɛ naanin ni san bisawa le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelɛji sɔrɔn ka san bisawa bɔ tuma mɛn na, a ka Eruhu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Eruhu sɔrɔn kɔrɔ, Pelɛji ka san kɛmɛ fila ni san kɔnɔndɔ le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Eruhu sɔrɔn ka san bisawa ni san fila bɔ tuma mɛn na, a ka Seruki sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruki sɔrɔn kɔrɔ, Eruhu ka san kɛmɛ fila ni san wɔrɔnwula le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruki sɔrɔn ka san bisawa bɔ tuma mɛn na, a ka Nakɔri sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakɔri sɔrɔn kɔrɔ, Seruki ka san kɛmɛ fila le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakɔri sɔrɔn ka san muwan ni san kɔnɔndɔ bɔ tuma mɛn na, a ka Teraki sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teraki sɔrɔn kɔrɔ, Nakɔri ka san kɛmɛ ni san tan ni kɔnɔndɔ le kɛ, ka dencɛ ni denmusoilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teraki sɔrɔn ka san biwɔrɔnwula bɔ tuma mɛn na, a ka Iburama ni Nakɔri ni Haran sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teraki bɔnsɔn de ɲin di. A ka Iburama ni Nakɔri ni Haran sɔrɔn. Haran ka Luti sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran sara ka a fa kɛndɛ to. A la saya kɛra a sɔrɔn jamana le rɔ, Kalide jamana kɔnin. A sara Uri so le kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Iburama ni Nakɔri ka furu kɛ. Iburama muso tɔɔ le tɛrɛ ko Sarayi. Nakɔri ka Haran denmuso do furu, mɛn tɔɔ ko Milika. Haran denmuso do fanan tɔɔ ko Sisika. ");
INSERT INTO msc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi tɛrɛ densɔrɔnbali le ri. Den tun tɛ a bolo. ");
INSERT INTO msc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nba, Teraki ka a dencɛ Iburama ni a mamarencɛ Luti ta ka wa Kanaan jamana rɔ. Luti ye Haran den de ri. Teraki ka a biranmusoni Sarayi fanan ta, mɛn ye Iburama muso ri. Ii bɛɛ bɔra Uri so la ka Kanaan bɔnsɔn na jamana sila mira. Uri wo ye Kalide jamana le rɔ. Kɔni ii se mɛn kɛni Haran, ii ka i sii ye. ");
INSERT INTO msc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teraki si bɛɛ ladɛnnin kɛra san kɛmɛ fila ni san loolu le ri. A sara Haran ye. ");
INSERT INTO msc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nba, Allabatala kumara Iburama yɛ ko: «Iburama, i ye bɔ i la jamana rɔ, ka bɔ i badenmailu tɛma, ka bɔ i fa la lu ma. I ye wa jamana do rɔ, n kɛtɔ mɛn yirakala i la. ");
INSERT INTO msc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","N di i bɔnsɔn kɛ jamana ba ri ye. N di baraka don i rɔ, ka i tɔɔ bonya. Mɔɔilu ri baraka sɔrɔn i la sababu rɔ. ");
INSERT INTO msc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mɔɔ mɛn ba duwa i yɛ ka i miri koɲuma, n di ɲumaya kɛ wo tii yɛ. Mɔɔ mɛn ba i danka, n di tɔrɔya la wo kan. I ri kɛ sababu ri, siyailu bɛɛ ri baraka sɔrɔn n bolo.» ");
INSERT INTO msc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Iburama wulira ka wa ikomin Allabatala ka a fɔ a yɛ ɲa mɛn ma. Luti taara a fɛ. Iburama bɔra Haran ka wa, ka a tɛrɛn a sɔrɔn da san biwɔrɔnwula ni san loolu bɔ. ");
INSERT INTO msc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Iburama ka a muso Sarayi ta a ni a kɔrɔcɛ dencɛ Luti a ni a jɔnilu a ni a bolofen bɛɛ. A tun ka fen fen sɔrɔn Haran, a ka wo bɛɛ ta. Ii bɔra wo ɲa le ma ka wa Kanaan jamana rɔ. Iburama ni a la mɔɔilu seni ye, ");
INSERT INTO msc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ii ka jamana ratɛɛ ka wa Sɛkɛmu, More la jiriju ba lɔni dinkira mɛn dɔ. Wo tuma, Kanaanka tɛrɛ jamana wo rɔ ye fɔlɔfɔlɔ. ");
INSERT INTO msc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Awa Allabatala ka a jɛrɛ yiraka Iburama la, ka a fɔ a yɛ ko: «N di duu ɲin bɛɛ di i bɔnsɔn ma.» Wo le rɔ, Iburama ka saraka janin diya lɔ Allabatala bato kanma, Allabatala mɛn ka a jɛrɛ yiraka a la. ");
INSERT INTO msc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Iburama bɔra ye ka wa koyinkɛilu fan fɛ, mɛnilu ye Bɛtɛli so telebɔ fan fɛ. A ka a la faaninbon lɔ ye, ka Bɛtɛli to a telebe fan fɛ, ka Ayi to a telebɔ fan. A ka saraka janin diya lɔ Allabatala bato kanma ye ka a tara. ");
INSERT INTO msc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Iburama bɔra ye ka jamana wo rataama ka wa Nɛkɛbi mara. ");
INSERT INTO msc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nba, wo tuma kɔnkɔ ba ra don jamana kɔndɔ. Wo juuyara kosɛbɛ. Wo rɔ, Iburama wara Misiran jamana rɔ ka mɛn ye. ");
INSERT INTO msc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ii dontɔla Misiran, Iburama ka a fɔ a muso Sarayi yɛ ko: «N ka a lɔn ko i kenɲi ba le. ");
INSERT INTO msc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ni Misirankailu ka i yen, ii ri a lɔn ko n muso le i ri. Wo rɔ, ii ri n faa ka i kɛndɛ to. ");
INSERT INTO msc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","I jaandi, ni an sera ye, i ye a fɔ ko n dɔɔmuso le i ri, sa ii ri n damira koɲuma ka n to i la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Iburama ni a muso sera Misiran tuma mɛn na, Misirankailu ka a yen ko Sarayi kenɲi kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Misiran mansa Ferawunala mɔɔbailu ka Sarayi yen tuma mɛn na, ii wara a mankutun fɔ Ferawuna yɛ. A ka wo mɛn ka mɔɔilu lɔ Sarayi tala ka na a ri a wara. ");
INSERT INTO msc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","A ka Iburama mira koɲuma Sarayi la ko kosɔn, ka kolofen su bɛɛ di Iburama ma: saailu wo, bailu wo, nisiilu wo, ɲɔɔmɛilu wo, faliilu wo, jɔnilu a ni jɔnmusoilu. ");
INSERT INTO msc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kɔni Allabatala ka yankaro juuilu bila Ferawuna ni a la bonkɔndɔmɔɔilu la Iburama muso Sarayi la ko kosɔn. ");
INSERT INTO msc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Wo rɔ, Ferawuna ka Iburama kili ka a fɔ a yɛ ko: «I ra nfen kɛ n na ten? Nfenna i ma a fɔ n yɛ ko i muso le? ");
INSERT INTO msc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nfenna i ka a fɔ ko i dɔɔmuso le? Wo le ka a kɛ, nde ka a ta ko n ye a kɛla n muso ri. Hen, i muso le ɲin de. A mira, i ye wa a ri!» ");
INSERT INTO msc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ferawuna ka a fɔ a la mɔɔilu yɛ ko ii ye Iburama ni a muso labɔ Misiran, a ni ii bolofenilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Iburama ni a muso bɔra Misiran ka wa Nɛkɛbi. A wara a bolofenilu bɛɛ ri. Luti wara a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Iburama tun da kɛ fentii ba ri. Kolofen ni wodigbɛ ni sanin tɛrɛ a bolo a ɲa ma. ");
INSERT INTO msc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A bɔra Nɛkɛbi ka wa Bɛtɛli. A tun ka a la faaninbon lɔ dinkira mɛn dɔ kɔrɔman, a sera ye. Dinkira wo tɛrɛ Bɛtɛli ni Ayi soilu tɛ le, ");
INSERT INTO msc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Iburama tun ka Alla saraka janin diya lɔ dinkira mɛn dɔ. A se mɛn kɛni ye, a ka Allabatala matara. ");
INSERT INTO msc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Kolofenilu ni mɔɔilu tun ka siya Luti fanan bolo, mɛn tɛrɛ ye taamala Iburama fɛ. ");
INSERT INTO msc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Wo le kosɔn, dinkira wo dɔɔyara ii fila bolo, baa ii bolofenilu ka siya kosɛbɛ. Ii fila tun ti se tola dinkira kelen dɔ. ");
INSERT INTO msc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Lon do rɔ, kɛlɛ wulira Iburama la kolofen kɔnɔmadenilu ni Luti la kolofen kɔnɔmadenilu tɛ. Wo tuma, Kanaanka ni Peresikailu fanan siini jamana wo rɔ ye. ");
INSERT INTO msc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Wo rɔ, Iburama ka a fɔ Luti yɛ ko: «An kana sɔn kɛlɛ ye wuli ile ni nde tɛ ma, wala ile la kolofen kɔnɔmadenilu ni nde la kolofen kɔnɔmadenilu tɛ ma. An ye badenma le ri. ");
INSERT INTO msc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","I ye jamana mafɛnɛ. Ɲin bɛɛ tɛ dinkira le ri wa? An ye fara. Ni bolomaran yan fan fɛ la le duman i yɛ, i ye wo ta. Nde ri to bolokinin yan fan fɛ. Ni bolokinin yan fan fɛ la le duman i yɛ, i ye wo ta. Nde ri to bolomaran yan fan fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Luti ka a ɲa lɔ ka Juridɛn Ba dinban bɛɛ ragbɛ. A ka a yen ko ji kɔ nɔɔman dinkira wo rɔ, ikomin a nɔɔman Allabatala la nakɔ ɲuma rɔ ɲa mɛn ma, wala ikomin Misiran ye ɲa mɛn ma ji ko rɔ. A tɛrɛ wo ɲa haan Sowari so. Dinkira wo ka ɲi tɛrɛ fɔlɔ. Tuma wo, Allabatala tun ma Sɔdɔmu ni Kɔmɔri soilu halaki fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nba, Luti ka wo yen ka Juridɛn Ba dinban bɛɛ ɲanatɔnbɔn ka a kɛ a ta ri. Wo rɔ, a bɔra Iburama fɛ ka wa telebɔ fan fɛ. Badenma fila wo farara wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iburama ka i sii Kanaan jamana rɔ. Luti wara i sii ba dinban soilu fan fɛ, ka a la faaninbonilu lɔ Sɔdɔmu so donda la. ");
INSERT INTO msc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sɔdɔmukailu tun ka juu kosɛbɛ, ka kojuu siyaman kɛ, ka Allabatala hakɛ ta. ");
INSERT INTO msc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Luti ni Iburama farani kɔ rɔ, Allabatala ka a fɔ Iburama yɛ ko: «Iburama, i ɲa lɔ. Ka bɔ i lɔ dinkira ye i ɲa lawa tele kankan bolomaran fan fɛ, a ni tele kankan bolokinin fan fɛ, telebɔ fan fɛ a ni telebe fan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I ɲa ye jamana mɛn bɛɛ la ɲin, n di wo bɛɛ di i ni i bɔnsɔn ma, ka a kɛ ai ta ri kadawu! ");
INSERT INTO msc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","N di i bɔnsɔn siyaya ka ii kɛ ikomin dunuɲa kiɲɛ. Ni mɔɔ ri se dunuɲa kiɲɛ jatela, i bɔnsɔn fanan di se jatela. ");
INSERT INTO msc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","I wuli ka jamana rataama, ka a janya ni a bonya ragbɛ, baa n ye a bɛɛ dila ile le ma.» ");
INSERT INTO msc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Iburama ka a la faaninbonilu bɔ, ka wa i sii Mamere la jiriju bailu kɔrɔ. Dinkira wo ye Heburɔn so da la. A ka saraka janin diya wɔse rabɛn Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wo tuma, Amurafɛli ye Sineyari jamana mansaya la. Ariyɔki ye Elasari jamana mansaya la. Kedorilamɛri ye Elamu jamana mansaya la. Tidali ye Koyimu jamana mansaya la. ");
INSERT INTO msc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Mansa naanin woilu ka ii ladɛn ka wa mansa Bera kɛlɛ, a ni mansa Birisa ni mansa Sineyabu ni mansa Sɛmɛbɛri ni mansa mɛn siini Bela so kun na. Bela tɔɔ fanan ko Sowari. Bera siini tɛrɛ Sɔdɔmu so kun na. Birisa siini tɛrɛ Kɔmɔri so kun na. Sineyabu siini tɛrɛ Adima so kun na. Sɛmɛbɛri siini tɛrɛ Seboyimu so kun na. ");
INSERT INTO msc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mansa loolu woilu wara i ladɛn Sidimu dinban dɔ, Dalaba Kɔɔjilama ye dinkira mɛn dɔ bi. ");
INSERT INTO msc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ii tun da san tan ni fila kɛ, ii ye mansa Kedorilamɛri la fanka kɔrɔ. A san tan ni sawana, ii muruntira a ma. ");
INSERT INTO msc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A san tan ni naaninna, Kedorilamɛri ni a fɛ mansailu wulira ka na, ka mansa mɛnilu kɛlɛ; Refayikailu mɛnilu siini Asiterɔti Karinayimu so la, Sisikailu mɛnilu siini Hamu so la, Emukailu mɛnilu siini Sawe Kiriyatayimi so la, ka ye mɔɔilu kɛlɛ ka ii se woilu la. ");
INSERT INTO msc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ii wara Horilu kɛlɛ woilu bara, koyinkɛ ma dinkira do rɔ, Seyiri la jamana rɔ, ka se woilu la. Ii ka ii gbɛn haan Heliparan, so mɛn ye wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Wo kɔ, Kedorilamɛri ni a dafaɲɔɔilu ka ii kɔsɛ ka na En Misipati, mɛn tɔɔ ko Kadɛsi. Mɔɔ mɛnilu tɛrɛ ye Amalɛki bɔnsɔn na jamana rɔ, ii ka woilu kɛlɛ ye, ka se woilu la ka ai la jamana bɛɛ ta. Ii sera Amɔrikailu fanan na, mɛnilu siini tɛrɛ Asarɔn Tamari so la. ");
INSERT INTO msc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Wo rɔ, Sɔdɔmu mansa bɔra, a ni Kɔmɔri mansa ni Adima mansa ni Seboyimu mansa ni Bela mansa. Bela wo tɔɔ fanan ko Sowari. Mansa woilu bɔra ka wa kɛlɛ diya Sidimu dinban dɔ. ");
INSERT INTO msc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ii wara ka Elamu mansa Kedorilamɛri kɛlɛ, a ni Koyimu mansa Tidali ni Sineyari mansa Amurafɛli ni Elasari mansa Ariyɔki. Mansa loolu woilu ka mansa naanin kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nba, Sɔdɔmu mansa ni Kɔmɔri mansa ni ii la mɔɔilu ka i bori ii juuilu ɲɛ. Ii siyaman borimantɔ bera tulubɔ fasani denkailu rɔ, baa wo ka siya tɛrɛ Sidimu dinban dɔ. Mɛnilu ma be denka rɔ, woilu ka i bori fɔɔ tindilu kan. ");
INSERT INTO msc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Wo rɔ, Kedorilamɛri ni a la mɔɔilu wara ka Sɔdɔmu ni Kɔmɔri nanfulu bɛɛ ta, a ni ii la dɔɔnninfenilu bɛɛ. Ii ka wo bɛɛ ta ka wa a ri. ");
INSERT INTO msc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ii ka Iburama badenma Luti fanan mira ka wa a ri, a ni a bolofen bɛɛ, baa ale fanan siini tɛrɛ Sɔdɔmu so le kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mɔɔ do borimantɔ nara ka wo bɛɛ ɲafɔ Iburama yɛ, a ye fɔla mɛn ma ko Heburu cɛɛ. Wo tuma, Iburama siini tɛrɛ Mamere la jiriju bailu tɔrɔfɛ. Mamere wo tɛrɛ Amɔrika mɔɔ do le ri. A badenmailu le Esikoli ni Anɛri ri. Wo bɛɛ tɛrɛ Iburama dɛnkuruilu le ri. ");
INSERT INTO msc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Iburama badenma mira ko fɔra a yɛ tuma mɛn na, a ka a la mɔɔilu kili, mɛnilu kusan kɛlɛla. Cɛɛ fadinman mɔɔ kɛmɛ sawa ni mɔɔ tan ni seyin mɛn bɛɛ sɔrɔnni Iburama wara woilu bɔra, ka mansailu kɔsaran fɔɔ Daan so la. ");
INSERT INTO msc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Su rɔ, Iburama ka a la mɔɔilu ratalan ka be mansailu kan. Iburama ka ii kɛlɛ ka se ii la, ka ii gbɛn haan Hoba. So wo ye Damasi so tele kankan bolomaran fan fɛla. ");
INSERT INTO msc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Mansailu tɛrɛ ra nanfulu mɛn bɛɛ ta, Iburama ka wo bɛɛ mira ii la ka na a ri. A nara a badenma Luti fanan di, a ni Luti bolofenilu bɛɛ ni muso mɛnilu mirani tɛrɛ wo ni mɔɔ tɔilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Nba, Iburama ka mansa Kedorilamɛri ni a mansa ɲɔɔnilu kɛlɛ ka se ii la, ka ban ka i kɔsɛ. A kɔsɛtɔ, Sɔdɔmu mansa wara a kunbɛn Sawe dinban dɔ, mɔɔilu ye a fɔla mɛn ma ko mansa la dinban. ");
INSERT INTO msc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salɛmu so mansa Mɛlikisedɛki nara Iburama kunbɛn ka sɔ buru ni rɛsɛnji a rɔ. Alla Kɔrɔtaniba sarakalasela le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","A duwara Iburama yɛ ko: «Alla ye ɲumaya kɛ Iburama yɛ, Alla Kɔrɔtaniba, mɛn ka san dan ka duu dan. ");
INSERT INTO msc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","An ye Alla Kɔrɔtaniba tando, mɛn ka i juuilu di i ma.» Iburama ka mɛnilu sɔrɔn kɛlɛ rɔ, a ka wo bɛɛ ja bɔ ka a di Mɛlikisedɛki ma. ");
INSERT INTO msc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sɔdɔmu mansa ka a fɔ Iburama yɛ ko: «N na mɔɔilu lasɛ n ma. Kɔni i ka nanfulu mɛn mira, i ye wo ta.» ");
INSERT INTO msc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iburama ka a jabi: «N da n bolo kɔrɔta ka n kali Allabatala la, Alla Kɔrɔtaniba, mɛn ka san dan ka duu dan. ");
INSERT INTO msc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","N da n kali wo la ko n tɛ i bolofen si tala, hali jisikari, wala sanbara julu. N tɛ a foyi ta, sa i kana a fɔ ko ile le ka Iburama kɛ nanfulutii ri. ");
INSERT INTO msc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","N tɛ foyi tala fo n na mɔɔilu ka mɛn kɛ ii balo ri. Kɔni mɛnilu wara n kɔfɛ, Anɛri wo, Esikoli wo, Mamere wo, fen mɛnilu sɔrɔnda kɛlɛ rɔ woilu ri ii nii bɔ wo rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Wo waati taminni kɔ rɔ, Iburama ka Allabatala kumakan mɛn kibarɔ misaliya rɔ. A ka a fɔ ko: «Iburama i kana silan. N di i lantanka fen bɛɛ ma ka i sara kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Iburama ka a jabi: «N Tii Allabatala, den tɛ n bolo. I ri nfen de di n ma wo rɔ? Damasika mɛn tɔɔ ko Eliyɛsɛri, wo le kɛtɔ n na bon cɛtala ri.» ");
INSERT INTO msc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Iburama ka a fɔ ko: «I ma den si di n ma. Wo rɔ, n na jɔn, mɛn ye n wara yan, wo le kɛtɔ n cɛtala ri.» ");
INSERT INTO msc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Iburama ka Allabatala kumakan mɛn jabili rɔ ko: «Wo kuma tɛ. Cɛɛ wo tɛ kɛla i cɛtala ri, fo i jɛrɛ den, i kɛtɔ mɛn sɔrɔnna. Wo le kɛtɔ i cɛtala.» ");
INSERT INTO msc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Allabatala ka Iburama labɔ kɛnɛma ka a fɔ a yɛ ko: «Iburama, i ɲa lɔ san dɔ, ka lolo bɛɛ jate, ni i ri se wo dan lɔnna.» Allabatala ka a fɔ ko: «Loloilu siyaman ɲa mɛn ma, i bɔnsɔn di siyaya wo ɲa.» ");
INSERT INTO msc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iburahima lara Allabatala la kuma la, wo rɔ Allabatala ka a jate mɔɔ telenni ri. ");
INSERT INTO msc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Allabatala ka a fɔ a yɛ ko: «Nde le Allabatala ri, mɛn ka lɔ i ɲɔrɔ ka i labɔ Uri so kɔndɔ Kalide jamana rɔ. N ka i lana yan de, ka jamana ɲin di i ma ka a kɛ i cɛtala ri.» ");
INSERT INTO msc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kɔni Iburama ka a jabi: «N tii Allabatala, n di se a lɔnna di ko jamana ɲin di kɛ n ta ri?» ");
INSERT INTO msc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Allabatala ka a fɔ ko: «Nisi muso kelen mira ka na a di n ma, a ni bamuso kelen ni saaji kelen. Wo bɛɛ ye kɛ san sawa sawa ri. I ye kanba kelen fanan mira, a ni sokɔndɔkanbanin kelen.» ");
INSERT INTO msc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Iburama nara woilu bɛɛ di a ma, ka ii faa ka kolofenilu sensen a tɛma fila ri, kɔni a ma kɔnɔilu sensen. A ka kunkundun woilu bilabila ka ii ɲabɛn i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Duwailu jiira soboilu ma tuma mɛn na, Iburama ka ii gbɛn. ");
INSERT INTO msc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nba, tele be tumana, sunɔɔ ba donda Iburama ɲa rɔ. Ka a tɛrɛn a ye sunɔɔ rɔ, silan juu ni dibi ba sera a ma. ");
INSERT INTO msc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Allabatala ka a fɔ a yɛ ko: «Iburama, i ye a lɔn ko i bɔnsɔn di kɛ londanilu ri jamana gbɛrɛ rɔ. Ii ri kɛ jɔnilu ri, ka tɔrɔ kojuuya haan san kɛmɛ naanin wa dafa. ");
INSERT INTO msc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kɔni jamana mɛn kɛtɔ ii bilala jɔnya rɔ, n di kititɛɛ jamana wo kan. Kiti wa kɛ, i bɔnsɔn di bɔ jamana wo rɔ nanfulu siyaman di. ");
INSERT INTO msc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ile kɔnin di i la kɔrɔya diya bɔ, ka sa hɛrɛ rɔ. Ii ri i su don. ");
INSERT INTO msc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I denilu bɔnsɔn naaninna ri ii kɔsɛ yan, baa yan mɔɔilu, ni woilu ye Amɔrikailu le ri, ii la kojuu ma dan natamin fɔlɔ ka se ii gbɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nba, tele bera ka dibi don tuma mɛn na, sinkɔn sisima ni kala mɛlɛn taminda sobo kunkundunilu tɛma. ");
INSERT INTO msc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Wo lon jɛrɛ rɔ, teriya donda Allabatala ni Iburama tɛma. A ka a fɔ a yɛ ko: «N di duu ɲin di i bɔnsɔn ma, ka bɔ Misiran Ba ma, ka wa haan ba belebele ba ma, mɛn ye Efirati Ba ri kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Dinkira wo ye Kenikailu bolo, a ni Kenisikailu ni Kadimonikailu ");
INSERT INTO msc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ni Hɛtikailu ni Peresikailu ni Refayikailu ");
INSERT INTO msc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ni Amɔrikailu ni Kanaanka ni Kirikasikakailu ni Jebusikailu.» ");
INSERT INTO msc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Iburama muso Sarayi tun ma den sɔrɔn a yɛ. Wo tuma, Misiranka sunkurun do tɛrɛ Sarayi bolo jɔnya la, mɛn tɔɔ ko Hajara. ");
INSERT INTO msc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lon do rɔ, Sarayi ka a fɔ Iburama yɛ ko: «N cɛɛ, Allabatala ma sɔn n ye den sɔrɔn. I ye wa i la n na jɔnmuso Hajara fɛ. Ni Alla sɔnda, a ri den sɔrɔn n yɛ.» Iburama sɔnda Sarayi la kuma ma. ");
INSERT INTO msc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wo rɔ, a muso Sarayi ka a la jɔn Misiranka sunkurun di a ma ka a kɛ a muso ri, wo ka a tɛrɛn Iburama ra san tan kɛ Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Iburama wara a la Hajara fɛ. Hajara ka kɔnɔ ta. Hajara ka a yen tuma mɛn na ko a kɔnɔ ma le, a ma a tii Sarayi jii foyi le ri, fo ka a dɔɔya. ");
INSERT INTO msc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Wo rɔ, Sarayi ka a fɔ Iburama yɛ ko: «Ko mɛn ye kɛla n na, wo bɔni ile le rɔ. N ka n na jɔn di i ma ka a kɛ i muso ri. Kɔni a ka a yen tuma mɛn na ko a kɔnɔ ma le, a ma n jii foyi le ri. Allabatala, a ye wo kititɛɛ nde ni ile tɛma!» ");
INSERT INTO msc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iburama ka Sarayi jabi: «Ale le wo ri. I la jɔnmuso ye i la fanka le kɔrɔ. Mɛn wa i diya, i ye wo kɛ a la.» Wo rɔ, Sarayi ka Hajara tɔrɔ kojuuya, fɔɔ Hajara ka i bori a kɔrɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Allabatala la mɛlɛka ka Hajara yen tenke do rɔ wula kɔndɔ; tenke wo ye Suri sila dafɛ. ");
INSERT INTO msc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mɛlɛka ka a fɔ a yɛ ko: «Ile, Hajara, Sarayi la jɔnmuso, i bɔni mi? I watɔ mi?» Hajara ka a jabi: «N borini n tii Sarayi le kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Allabatala la mɛlɛka ka a fɔ a yɛ ko: «I kɔsɛ i tii wara, ka wa i fanmajii a yɛ ka a kan mira.» ");
INSERT INTO msc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Mɛlɛka ka a fɔ ko: «N di i bɔnsɔn siyaya a ɲa ma, fɔɔ mɔɔ tɛ wo jate lɔn muumɛ!» ");
INSERT INTO msc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Habadan Mansala la mɛlɛka ka a fɔ a yɛ ikɔ tuun ko: «I ɲa lɔ. I kɔnɔ ma le, i ri dencɛ sɔrɔn. I ye wo tɔɔ la ko Isumayila, baa Allabatala da i la jusukasi kan namɛn. ");
INSERT INTO msc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Den wo ri kɛ ikomin waa rɔ sofali, mɛn bilani a jɛrɛ ma. A ti se a la yala a badenma tɛma. A ni a badenmailu tɛ bɛn.» ");
INSERT INTO msc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajara ka a fɔ ko: «Allabatala ɲayen n na», wo rɔ a ka tɔɔ do la ko: «Alla mɛn kɔrɔtanin ɲayen n na.» ");
INSERT INTO msc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Wo le rɔ, kɔkun mɛn ye Kadɛsi so ni Bɛrɛdi so tɛ, mɔɔilu ye wo kilila ko Lasayi Rɔyi. ");
INSERT INTO msc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Wo taminni kɔ, Hajara ka dencɛ sɔrɔn Iburama yɛ. Iburama ka den tɔɔ la ko Isumayila. ");
INSERT INTO msc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hajara ka Isumayila sɔrɔn tuma mɛn na, Iburama sɔrɔn tun da san biseyin ni san wɔɔrɔ bɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Iburama sɔrɔn ka san bikɔnɔndɔ ni san kɔnɔndɔ bɔ tuma mɛn na, Allabatala ka a jɛrɛ yiraka a la ka a fɔ a yɛ ko: «Nde le Alla Sebɛɛtii ri. I ye n na sila taama ka kɛ mɔɔ telenni ba ri. ");
INSERT INTO msc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Wo wa kɛ, n di an na teriya mafa i yɛ ka i bɔnsɔn siyaya kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Iburama ka wo mɛn ka a ɲakɔrɔ bɛn duu ma. Alla kumara a yɛ ko: ");
INSERT INTO msc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«An ye teriya mɛn tala, wo le ye ɲin di. Jamana siyaman di bɔ i rɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","A tɛ fɔ i ma butun ko Iburama. I kilitɔ le sisen ko Iburahima, baa n di i kɛ jamana siyaman benba ri. ");
INSERT INTO msc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","N di i jiri kosɛbɛ. I bɔnsɔn di siyaya ka kɛ jamanailu ri. Mansailu ri bɔ i bɔnsɔn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","An na teriya wo ri tɔ an tɛma a ni i bɔnsɔnilu fanan, mɛnilu bɛɛ natɔ i kɔ. Teriya wo tɛ banna habadan. N di kɛ i Maari Alla ri, a ni i bɔnsɔn ta. ");
INSERT INTO msc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I ye londanya la jamana mɛn dɔ bi, n di jamana wo di ile ni i bɔnsɔn bɛɛ ma. Kanaan jamana wo ri kɛ ile ni i bɔnsɔn ta ri habadan. N di kɛ i bɔnsɔn na Maari Alla ri.» ");
INSERT INTO msc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Alla ka a fɔ Iburahima yɛ ko: «I ni i bɔnsɔn bɛɛ ye an na teriya sila taama ka n kan mira. Ai ka kan ka diyagboya ko mɛn kɛ, wo le ye ɲin di. Ai cɛɛ kelen kelenna bɛɛ ye faaninta kɛ. ");
INSERT INTO msc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ai wa faaninta kɛ, wo ri kɛ an na teriya tɔɔmasere ri nde ni aile tɛma. ");
INSERT INTO msc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ka bɔ bi ma haan ka wa, dencɛilu bɛɛ ye faaninta kɛ ii sɔrɔn tele seyin ma. Hali jɔnilu. Jɔn fen fen wa sɔrɔn i wara, i ye a faaninta kɛ wo ɲa le ma. I wa jɔn fen fen san wodi la siya gbɛrɛilu ma, wo fanan ye faaninta kɛ ɲa kelen wo ma. ");
INSERT INTO msc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ni a sɔrɔnda i wara, ni i ka a san i la wodigbɛ la, a bɛɛ ye faaninta kɛ. Wo le rɔ, n na teriya tɔɔmasere ri kɛ ai fari ma, ka a yiraka ko teriya wo ri mɛn kadawu. ");
INSERT INTO msc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ni cɛɛ mɛn ma faaninta kɛ ka wo nɔ kɛ a fari ma, wo ye fara a badenmailu la, baa n kan mɛn diyagboya le, a ma wo kɛ. Wo rɔ, a ra n na teriya sila bila.» ");
INSERT INTO msc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nba, Alla ka a fɔ Iburahima yɛ ko: «I kana a fɔ i muso ma butun ko Sarayi. A tɔɔ le sisen ko Saran. ");
INSERT INTO msc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","N di baraka don a rɔ. N di a kɛ, a ri dencɛ sɔrɔn i yɛ. N di baraka don Saran na kɔ rɔ ka a kɛ siyailu ma ri. Mansailu ri bɔ a bɔnsɔn dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iburahima ka a ɲakɔrɔ bɛn duu ma. Kɔni a ka Alla la kuma mɛn a yɛlɛra ka a fɔ a jɛrɛ kɔndɔ ko: «Cɛɛ mɛn sɔrɔn da san kɛmɛ bɔ, wo kɛtɔ den sɔrɔnna di? Saran fanan da san bikɔnɔndɔ sɔrɔn. Wo ri se moyila den na wa?» ");
INSERT INTO msc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","A ka Alla madiya ko: «I jaandi. I ye baraka don Isumayila la ko rɔ, ka i janto a rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Alla ka a jabi: «Wo kuma tɛ, kɔni i muso Saran di dencɛ sɔrɔn i yɛ. I ri a tɔɔ la ko Isiyaka. Teriya ri don n ni Isiyaka tɛma, a ni a bɔnsɔn mɛnilu natɔ a kɔ. Teriya wo ri mɛn kadawu. ");
INSERT INTO msc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mɛn lɔni Isumayila la ko ma, i ka mɛn dali n fɛ, n di wo kɛ. N di baraka don a la ko rɔ ka den siyaman di a ma, ka a bɔnsɔn siyaya kosɛbɛ. A ri faama tan ni fila sɔrɔn. N di jamana ba do bɔ a rɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kɔni n na teriya ri tɔ n ni Saran dencɛ Isiyaka le tɛma, mɛn Saran di sɔrɔn i yɛ ɲin tuma sandɔ.» ");
INSERT INTO msc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Alla banda kumala Iburahima yɛ tumana mɛn na, a bɔra Iburahima fɛ. ");
INSERT INTO msc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wo lon kelen dɔ, Iburahima ka Isumayila la faaninta kɛ, ka a la jɔn bɛɛ fanan faaninta kɛ, mɛnilu sɔrɔnni a wara a ni mɛnilu sanni a bolo. Cɛɛman kelen kelenna mɛn bɛɛ tɛrɛ a wara, Iburahima ka wo bɛɛ faaninta kɛ ikomin Alla ka a fɔ a yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iburahima jɛrɛ ka faaninta kɛ ka a tɛrɛn a sɔrɔn da san bikɔnɔndɔ ni san kɔnɔndɔ bɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A dencɛ Isumayila ka faaninta kɛ ka a tɛrɛn a sɔrɔn da san tan ni sawa bɔ. ");
INSERT INTO msc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Wo lon kelen dɔ, Iburahima ni a dencɛ Isumayila fila bɛɛ ka faaninta kɛ, ");
INSERT INTO msc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","a ni cɛɛman mɛnilu bɛɛ tɛrɛ Iburahima wara. Jɔn mɛnilu sɔrɔnni a wara, a ni mɛnilu sanni a bolo siya gbɛrɛilu ma, woilu bɛɛ ka faaninta kɛ a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lon do rɔ, Allabatala ka a jɛrɛ yiraka Iburahima la Mamere la jiriju bailu kɔrɔ. Wo ka Iburahima siini tɛrɛ a la faaninbon da la tele kunna rɔ. ");
INSERT INTO msc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Iburahima ka a ɲa lɔ ka cɛɛ sawa lɔni yen. Ii tun ma jan a la. A ka ii yen tuma mɛn na, a borimantɔ bɔra a la faaninbon da la ka wa ii labɛn, ka a majii bakɛ ka ii fo. ");
INSERT INTO msc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","A ka a fɔ ii yɛ ko: «N tiilu, ai jaandi, ai kana tamin n wara ten. ");
INSERT INTO msc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ko ji ye na ka ai sen mako, ka ban ka ai ɲɔɲɔ lulen na. ");
INSERT INTO msc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","N ye wa dɔɔnninfen ɲiinin a ye dɔɔnnin kɛ. Baa, ai ra na ai la baaraden wara. Ai ti se bɔla yan wo ɲa a ma dɔɔnnin ke. A wa banda dɔɔnninna a ri sila mira ka wa.» Ii ka Iburahima jabi: «Ale le wo ri, wo tɛ baasi ri.» ");
INSERT INTO msc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iburahima borimantɔ donda a la faaninbon na ka a fɔ Saran yɛ ko: «I kaliya ka farinin muun ɲuma sumanifen ɲa sawa suman, ka a gbasi ka a kɛ buru ri.» ");
INSERT INTO msc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Iburahima ka a bori ka wa nisi warɛ rɔ, ka nisiden tɔlɔni do mira, mɛn sobo duman. A ka wo don a la jɔn do bolo. Jɔn wo ka a kaliya ka nisiden kannatɛɛ ka a sobo tibi. ");
INSERT INTO msc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Iburahima ka nɔnɔ sunɔni ni nɔnɔ kɛndɛ ta, ka nisiden sobo tibini la woilu kan ka wa wo bɛɛ sii londan sawa kɔrɔ. Ii tɛrɛ ye dɔɔnninna tuma mɛn na, Iburahima ka a lɔ ii dafɛ jiri kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ii ka Iburahima maɲininka ko: «I muso Saran ye mi?» A ka a fɔ ko: «A ye faaninbon na.» ");
INSERT INTO msc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kelen ka a fɔ ko: «N di na bɔ i fɛ ɲin tuma sandɔ. Wo ri a tɛrɛn i muso Saran da dencɛ sɔrɔn.» Saran siini tɛrɛ londancɛ wo kɔfɛ faaninbon da la, ka a tolo malɔ a la. ");
INSERT INTO msc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Wo tuma, Iburahima ni Saran da kɔrɔ kosɛbɛ. Den sɔrɔn waati ra tamin Saran kan. ");
INSERT INTO msc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saran ka kuma wo mɛn tuma mɛn na, a yɛlɛra a jɛrɛ ma, ka a fɔ ko: «Nde kɔrɔni ba le. N cɛɛ fanan da cɛmɔɔya kosɛbɛ. N di se den sɔrɔnna wo rɔ, ka sɛwa wo rɔ wa?» ");
INSERT INTO msc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Wo rɔ, Allabatala ka a fɔ Iburahima yɛ ko: «Nfenna Saran ye yɛlɛla ka sika a den sɔrɔn ko rɔ a kɔrɔya waati? ");
INSERT INTO msc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Allabatala se kaɲala fen su ɲuman de kɛla? Ɲin tuma sandɔ, n di na bɔ i fɛ yan. Wo ri a tɛrɛn i la muso Saran da dencɛ sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saran silanda ka wuya fɔ ko: «Nde ma yɛlɛ de!» Kɔni Allabatala ka a fɔ ko: «I yɛlɛra le jɔ!» ");
INSERT INTO msc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nba, londan woilu wuli mɛn kɛni ka wa, Iburahima wara ii bilasila. Ii sera tindi do kan ka ii ɲa lɔ Sɔdɔmu so fan fɛ lala. ");
INSERT INTO msc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Allabatala ka a fɔ a jɛrɛ ma ko: «N kɛtɔ mɛn kɛla, n di wo dokon Iburahima ma wa? ");
INSERT INTO msc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Baa a ri kɛ jamatii ba ri, fanka ye mɛn na. Iburahima ri kɛ sababu ri, siya bɛɛ ri baraka sɔrɔn n bolo. ");
INSERT INTO msc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","N da a ɲenematɔmɔn, kosa a ri a denilu ni a bɔnsɔn bɛɛ jamari ko ii ye n na sila taama telenbaya rɔ. Ni ii ka wo kɛ, n di n na teriya mafa, n ka mɛn ta Iburahima yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nba, Allabatala ka a fɔ Iburahima yɛ ko: «Sɔdɔmukailu ni Kɔmɔrikailu jalakili kan da siyaya. Ii la ko haramunnin a ra wara kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Wo rɔ, n watɔ ii ragbɛla, sa n di a lɔn ni ii ra kojuu kɛ ikomin a fɔra n ɲana ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Cɛɛ woilu bɔra Iburahima tɔrɔfɛ ka wa Sɔdɔmu fan fɛ. Kɔni Iburahima lɔni tora Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","A ka a madon a la ka a fɔ a yɛ ko: «Allabatala, i ri jahadi la mɔɔ telenniilu ni mɔɔ telenbaliilu bɛɛ ɲɔɔn kan wa? ");
INSERT INTO msc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ni i ka mɔɔ telenni biloolu tɛrɛn so kɔndɔ ye, i ri jahadi la so kɔndɔ mɔɔilu bɛɛ kan wa? I ti se so kɔndɔ mɔɔilu tola ye mɔɔ telenni biloolu woilu la ko kosɔn wa? ");
INSERT INTO msc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ka mɔɔ telenniilu faa mɔɔ telenbaliilu fɛ, i tɛ ko su wo kɛla fewu. I tɛ sɔnna ka mɔɔ teleni ni mɔɔ telenbaliilu jate kelen di ka jahadi la ii bɛɛ kan. I tɛ ko su wo kɛla fewu! Ile le dunuɲa bɛɛ kititɛɛla ri, mɛn ye kojuu ni koɲuma faranfaasila.» ");
INSERT INTO msc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Allabatala ka Iburahima jabi: «Ni n ka mɔɔ telenni biloolu tɛrɛn Sɔdɔmu, n di so kɔndɔ mɔɔ bɛɛ to ye mɔɔ ɲuma biloolu woilu la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iburahima ka a fɔ a yɛ ikɔ tuun ko: «Maari, i ye diɲɛ. N tɛ foyi ri fo banku, kɔni n ye n dajala ka kuma i yɛ. ");
INSERT INTO msc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ni i ka a tɛrɛn mɔɔ telenni tɛ mɔɔ biloolu bɔ don? Ni mɔɔ loolu dɔrɔn ka mɔɔ biloolu jan, i ri jahadi la so bɛɛ kan mɔɔ loolu woilu la ko kosɔn wa?» Allabatala ka a jabi: «Ni n ka mɔɔ telenni binaanin ni loolu tɛrɛn so kɔndɔ, n tɛ jahidi la so kan.» ");
INSERT INTO msc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iburahima kumara a yɛ ikɔ ko: «Ni mɔɔ telenni ma tamin mɔɔ binaanin kan don?» Allabatala ka a fɔ ko: «Mɔɔ binaanin woilu la ko kosɔn, n tɛ jahadi la so kan.» ");
INSERT INTO msc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iburahima ka a fɔ ko: «Maari, i jaandi, i kana diminya n ma, kɔni n ye kumala ikɔ. Ni i ka mɔɔ telenni bisawa dɔrɔn tɛrɛn so kɔndɔ don?» Allabatala ka a fɔ ko: «Ni n ka mɔɔ telenni bisawa tɛrɛn ye, n tɛ jahadi la so kan.» ");
INSERT INTO msc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iburahima ka a fɔ ko: «Maari, ye n diɲɛ. N ye n dajala ka kuma i yɛ ikɔ. Ni i ka a tɛrɛn ko mɔɔ telenni tɛ tamin mɔɔ muwan kan don?» Allabatala ka a jabi: «N tɛ jahadi la so kan mɔɔ muwan woilu la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iburahima ka a fɔ ko: «Maari, i kana diminya n ma. N na kuma dan de ɲin di. Ni mɔɔ telenni muumɛ kɛra mɔɔ tan di don?» Allabatala ka a fɔ ko: «N tɛ jahadi la so kan mɔɔ tan woilu la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Allabatala banni kumala Iburahima fɛ, a wara. Iburahima ka i kɔsɛ ka wa a wara. ");
INSERT INTO msc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nba, mɛlɛka fila wo sera Sɔdɔmu wura fɛ. Luti tɛrɛ siini so donda la. A ka ii yen tuma mɛn na, a wulira ka wa ii labɛn ka majii bakɛ ka ii tuwa. ");
INSERT INTO msc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","A ka a fɔ ko: «N tiilu, ai jaandi, ai ye diɲɛ ka na jiya n wara. Ai ye ai sen mako ka sii yan. Sɔɔma jona, n di sila di ai ma, sa ai ri wa ai la taama rɔ.» Mɛlɛkailu ka Luti jabi: «Ɛɛn. An di sii kɛnɛma yan.» ");
INSERT INTO msc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kɔni Luti kumara ii yɛ ka a magbɛlɛya, fɔɔ ii sɔnda ka wa jiya a wara. A la mɔɔilu ka buru fununbali ni dɔɔnnin ba rabɛn. Luti ka wo bɛɛ sii a la londanilu kɔrɔ. Ii ka dɔɔnnin kɛ. ");
INSERT INTO msc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ka a tɛrɛn ii ma i la fɔlɔ, Sɔdɔmukailu bɔra fan bɛɛ rɔ ka na bon naminin. Kanberenilu wo, mɔɔbakɔrɔilu wo, ii bɛɛ nara. ");
INSERT INTO msc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ii ka ii kan nabɔ Luti ma ko: «Cɛɛ mɛn nani i wara yan su ɲin dɔ, ii ye mi? I ye ii lana an ma. An ye a fɛ ka an na ii fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Luti bɔra bon na, ka bon da tuun londanilu ma. ");
INSERT INTO msc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","A ka fɔ: «N badenmailu. Ai jaandi, ai kana kojuu ɲin kɛ. ");
INSERT INTO msc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","N denmuso fila ye yan, wo si ma cɛɛ lɔn fɔlɔ. N di woilu lana ai ma ka ii di ai ma. Fen fen wa diya ai yɛ, ai ye wo kɛ ii la. Kɔni ai kana foyi kɛ cɛɛ ɲinilu la, baa ii nani londanya le la n wara.» ");
INSERT INTO msc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","So kɔndɔ mɔɔilu ka a fɔ i ɲɔɔn yɛ ko: «Cɛɛ ɲin tɛ foyi le ri fɔɔ londan, kɔni sisen a ye a fɛ ka kɛ an na kuntii ri.» Ii ka a fɔ Luti yɛ ko: «I bɔ sila la an tɛma. Ni i ma i bɔ an yɔrɔ, an di mɛn kɛ i la, wo ri juuya i la londanilu ta ri.» Ii ka Luti tuntun fanka la ka sudunya bon na sa ii ri da kadi ka don. ");
INSERT INTO msc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kɔni cɛɛ fila woilu ka da laka ka ii boloilu labɔ ka Luti mira. Ii ka a ladon bon na ka da sɔɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ii ka mɔɔilu bɛɛ ɲa fuyenya bonda kɔrɔ. Fen fen tɛrɛ don ko rɔ bon na, woilu bɛɛ ɲa fuyenyara, kanberen wo, mɔɔbakɔrɔ wo, woilu bɛɛ. Wo rɔ, ii ka bonda ɲinin ka kaɲa. ");
INSERT INTO msc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Cɛɛ fila wo ka a fɔ Luti yɛ ko: «I la mɔɔ doilu ye so kɔndɔ yan wa? I ye a bɛɛ labɔ so kɔndɔ. I biran wo, i dencɛilu wo, i denmusoilu wo, i la mɔɔ bɛɛ labɔ, ");
INSERT INTO msc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","baa an kɛtɔ so ɲin bɛɛ halakila le. Ii jalakili kan da siyaya Allabatala ɲana. Wo rɔ, ale le ka an lɔ ii halakila.» ");
INSERT INTO msc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nba, Luti bɔra ka wa kuma a biranilu yɛ, mɛnilu ka a denmusoilu mamira. A ka a fɔ ii yɛ ko: «Ai ye wuli. An ye an bori ka bɔ so kɔndɔ. Allabatala kɛtɔ so halakila le!» Kɔni, Luti biranilu ka a kuma jate yɛlɛmako le ri. ");
INSERT INTO msc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sɔɔma da la, mɛlɛka woilu ka a fɔ Luti yɛ ka a magbɛlɛya a yɛ ko: «I kaliya! I ye i muso ni i denmuso fila ta ka wa. Ni wo tɛ, ai ri halaki so jahadi rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kɔni, Luti ka a la sumaya. Wo rɔ, ii ka a mira a bolo ma, a ni a muso ni a denmuso fila ka wa ii ri so kɔkan. Allabatala kininkinira ii ma wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ii bɔ mɛn kɛni so kɔndɔ, mɛlɛka kelen ka a fɔ ii yɛ ko: «Ai ye ai bori ka wa ka ai jɛrɛ kisi. Ai kana ai kɔfɛnɛ. Ai kana ai lɔ dinban yɔrɔ si rɔ. Ai ye i bori ka wa koyinkɛ kan, sa ai kana halaki.» ");
INSERT INTO msc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Luti ka fɔ: «Ɛɛ, n tii. I jaandi. ");
INSERT INTO msc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","I ra ban ka n kisi, kɔni n ti se n borila fɔɔ koyinkɛ kan. Sani n ye se ye, n di jahadi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","I ɲa lɔ. I ma so wo yen, mɛn ma jan yan na. So wo ka doo. N di se wo sɔrɔnna. N tii, i jaandi. N ye n bori ka wa so mɛsɛn wo la, sa n di kisi.» ");
INSERT INTO msc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mɛlɛka ka a fɔ ko: «Ale le wo ri. N da diɲɛ wo ma. I kan so mɛn ma wo ri, n tɛ jahadi la wo kan. ");
INSERT INTO msc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kɔni ai ye i kaliya ka wa don ye. Ni ai ma se ye, n ti se foyi kɛla.» So mɛn Luti ka a fɔ a ma ko a dɔɔman, so wo tɔɔ lara ko Sowari. ");
INSERT INTO msc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Luti donda Sowari so kɔndɔ ka a tɛrɛn tele ra yɛlɛ. ");
INSERT INTO msc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Wo tuma, Allabatala ka ta tinbiriki lamaa lajii Sɔdɔmu ni Kɔmɔri kan ikomin sanci kisɛ. Allabatala jɛrɛ le ka wo lajii ka bɔ sankolo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Wo rɔ, Allabatala ka so woilu bɛɛ janin, a ni dinban bɛɛ. Mɔɔilu bɛɛ halakira, a ni jiri ni bin bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ii watɔla, Luti muso ka kɔfɛnɛ dinkira mɛn dɔ, a yɛlɛmanda ka kɛ kɔɔ kaba ri. ");
INSERT INTO msc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wo sɔɔma da la jona, Iburahima wara kuma diya wo rɔ, a ni Allabatala tun kumara i ɲɔɔn fɛ dinkira mɛn kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","A ka a ɲa lɔ ka Sɔdɔmu ni Kɔmɔri soilu ragbɛ, a ni dinban bɛɛ. A ka sisi wulitɔla yen. Sisi bɔra ikomin ta wa jiri mira furu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nba, Alla ka dinban so bɛɛ halaki tuma mɛn na, a ka a miri Iburahima ma ka Luti kisi ta la halakili ma. Ta wo ka so bɛɛ halaki, Luti siini tɛrɛ dinkira mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Luti ma sɔn ka to Sowari ka a masɔrɔn a silanni. Wo rɔ, a ka a denmuso fila ta ka wa ii ri koyinkɛ kan. Ii ka ii sii falan na ye. ");
INSERT INTO msc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lon do rɔ a denmuso kɔrɔmamɔɔ ka a fɔ a dɔɔmuso yɛ ko: «An fa ra kɔrɔya. Cɛɛ fanan tɛ yan, mɛn di an furu, ikomin a ye kɛla dunuɲa fan bɛɛ rɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","An ye dɔlɔ di an fa ma. A wa a min ka a ɲa laminin, an di an na a fɛ, sa an di den sɔrɔn, sa an fa bɔnsɔn kana tunun dunuɲa ma.» ");
INSERT INTO msc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ii ka dɔlɔ di ii fa ma su wo rɔ. A ka a min fɔɔ ka a ɲa laminin. A denmuso kɔrɔmamɔɔ wara a la a fɛ. Luti ma a la tumana lɔn. A ma a wuli tumana fanan lɔn. ");
INSERT INTO msc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wo sɔɔma da la, Luti denmuso kɔrɔmamɔɔ ka a fɔ a dɔɔmuso yɛ ko: «Su rɔ, n ka n la n fa fɛ. Su ba ko: an ye dɔlɔ di a ma ikɔ. A wa a min ka a ɲa laminin, ile ri wa i la a fɛ, sa an fa bɔnsɔn kana tunun dunuɲa ma.» ");
INSERT INTO msc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ii ka dɔlɔ di ii fa ma su wo rɔ ikɔ. A ka a min fɔɔ ka a ɲa laminin. A denmuso dɔɔmamɔɔ wara a la a fɛ. Luti ma a la tumana lɔn. A ma a wuli tumana fanan lɔn. ");
INSERT INTO msc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nba, Luti denmuso fila bɛɛ ka kɔnɔ ta Luti fɛ ɲa wo le ma. ");
INSERT INTO msc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","A denmuso kɔrɔmamɔɔ ka dencɛ sɔrɔn ka a tɔɔ la ko Mowabu. Mowabu bɔnsɔn mɛn ye ye bi, wo benba le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A dɔɔmuso fanan ka dencɛ sɔrɔn, ka a tɔɔ la kɔ Bɛnami. Amoni bɔnsɔn mɛn ye ye bi, wo benba le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nba, Iburahima bɔra Mamere ka wa Nɛkɛbi, ka taa i sii Kadɛsi a ni Suri so fila tɛma. Ka a tɛrɛn a ye Kerari, ");
INSERT INTO msc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iburahima ka a fɔ ye mɔɔilu yɛ Saran na ko rɔ ko: «N dɔɔmuso le.» Wo le rɔ, Kerari mansa Abimelɛki ka a la mɔɔilu lɔ Saran mirala kosa a ri a kɛ a la muso ri. ");
INSERT INTO msc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kɔni su do rɔ, Alla ka a jɛrɛ yiraka Abimelɛki la sibo rɔ, ka a fɔ a yɛ ko: «Abimelɛki i ɲa lɔ. A tɛ mɛn i ri faa dɛ, baa i nɔ muso mɛn mirala ɲin di, a furunin de.» ");
INSERT INTO msc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Wo ka a tɛrɛn, Abimelɛki tun ma a la Saran fɛ fɔlɔ. Wo rɔ, a ka Alla jabi: «Faama, i ri se n na jamana halakila hali an ma kojuu kɛ wa? ");
INSERT INTO msc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","A cɛɛ le ma a fɔ n yɛ ko a dɔɔmuso le ɲin di wa? Muso fanan ma a fɔ ko ale kɔrɔcɛ le wa? N kɔnin ka ko ɲin kɛ jusu gbɛya le la. N ma kojuu kɛ.» ");
INSERT INTO msc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Alla ka Abimelɛki jabi sibo kelen wo rɔ ko: «N ka a lɔn ko i ka ko ɲin kɛ jusu gbɛya le rɔ. Wo le rɔ, nde le ka a kɛ, i ma i la a fɛ fɔlɔ ka ko haramunnin kɛ. ");
INSERT INTO msc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nba, cɛɛ wo muso lasɛ a ma. N na nabi de a ri. A ri madiyali kɛ i yɛ sa i kana faa. Ni i ma a muso lasɛ a ma, i ye la a la ko i ri faa fewu, i ni i la mɔɔ bɛɛ!» ");
INSERT INTO msc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Sɔɔma da la jona, Abimelɛki ka a la mɔɔilu kili ka ko wo bɛɛ ɲafɔ ii yɛ. Ii ka wo mɛn ka silan kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelɛki ka Iburahima kili ka a fɔ a yɛ ko: «Cɛɛ, i ka nfen kɛ an na ɲin de ten? N na kojuu su ɲuman kɛla i la fo i ra kojuu ɲin ɲɔɔn nase nde ni n na jamana mɔɔilu ma? I ra mɛn kɛla n na ɲin, mɔɔ ma kan ka wo kɛ i mɔɔɲɔɔ na habadan! ");
INSERT INTO msc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","I ka ko ɲin kɛ nfenna?» ");
INSERT INTO msc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iburahima ka a jabi: «N tɛrɛ ye n mirila le ko n tɛ mɔɔ sɔrɔn jamana ɲin dɔ, mɛn silanni Alla yɛ. N ko yan mɔɔilu ri n faa n na muso kosɔn. Wo le rɔ, n ka a fɔ i yɛ ko n dɔɔmuso le. ");
INSERT INTO msc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Wo bɛɛ ni a ta, n dɔɔmuso bɛrɛ bɛrɛ le a ri. An bɛɛ ye fa kelen de la, kɔni an tɛ na kelen na. N ka a furu ka a kɛ n muso ri. ");
INSERT INTO msc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Alla ka n nabɔ n fa wara tuma mɛn na n ka wa taama rɔ, n ka a fɔ Saran yɛ ko: ‹I ka kan ka ɲumaya mɛn kɛ n yɛ wo rɔ, wo le ye ɲin di. An wa wa yɔrɔ yɔrɔ, i ye a fɔ ye mɔɔilu yɛ ko «N kɔrɔcɛ le a ri.»›» ");
INSERT INTO msc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelɛki ka Iburahima muso Saran nasɛ a ma, ka saailu ni bailu ni nisiilu la a kan, a ni jɔnilu. ");
INSERT INTO msc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A ka a fɔ Iburahima yɛ ko: «N na jamana ragbɛ. A yɔrɔ mɛn wa diya i yɛ, i ye wa i sii ye.» ");
INSERT INTO msc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A ka a fɔ Saran yɛ ko: «A ragbɛ! N da wodigbɛ waa kelen di i kɔrɔcɛ ma ka a yiraka ai wara mɔɔ bɛɛ la ko i ma kojuu kɛ. Mɔɔ bɛɛ ri a lɔn ko i ra jo sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Iburahima ka Alla tara Abimelɛki yɛ. Wo rɔ, Alla ka Abimelɛki lakɛndɛya, a ni a la muso ni a la jɔn muso bɛɛ, wo le rɔ ai ri se den sɔrɔn ikɔ tuun ");
INSERT INTO msc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","baa Allabatala tun da densɔrɔnbaliya jankarɔ le bila Abimelɛki muso bɛɛ la Iburahima muso Saran mira kosɔn. ");
INSERT INTO msc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Allabatala hinara Saran na ikomin a tun ka a fɔ ɲa mɛn ma. A ka lahidi mɛn ta a yɛ fɔlɔ, a ka wo mafa. ");
INSERT INTO msc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Wo rɔ, Iburahima la cɛmɔɔbaya waati rɔ, Saran ka kɔnɔ ta ka dencɛ sɔrɔn a yɛ, waati mɛn fɔni Alla bolo kɔrɔmanna. ");
INSERT INTO msc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Saran ka dencɛ mɛn sɔrɔn, Iburahima ka wo tɔɔ la ko Isiyaka. ");
INSERT INTO msc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isiyaka sɔrɔn tele seyin, Iburahima ka a faaninta kɛ, ikomin Alla ka a jamari a yɛ ɲa mɛn ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isiyaka sɔrɔnda ka a tɛrɛn Iburahima sɔrɔn da san kɛmɛ bɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saran ka a fɔ ko: «Ɛɛ! Alla ra n nasɛwa fɔɔ n da ɲalen ka yɛlɛ bakɛ. Ko ɲin wa fɔ mɔɔ mɛn yɛ, wo fanan di sɛwa ka yɛlɛ n fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Saran kumara ikɔ ko: «Yon tun di a fɔ Iburahima yɛ ko Saran di sin di den ma wa? Kɔni n da dencɛ sɔrɔn a yɛ, ka a tɛrɛn a ra cɛmɔɔya kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nba, den bonyara. Ii ka a da bɔ sin na lon mɛn dɔ, Iburahima ka tolon ba kɛ. ");
INSERT INTO msc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Misiranka muso Hajara ka dencɛ mɛn sɔrɔn Iburahima yɛ, wo tɛrɛ ye Isiyaka mayɛlɛla. Saran ka wo yen ");
INSERT INTO msc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ka a fɔ Iburahima yɛ ko: «I ye jɔnmuso wo ni a dencɛ gbɛn. N dencɛ Isiyaka le dɔrɔn di kɛ i cɛtala ri. A dencɛ tɛ kɛ i cɛtala ri fewu!» ");
INSERT INTO msc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Saran na kuma wo gbara Iburahima la kosɛbɛ, ka a masɔrɔn Isumayila fanan ye a den de ri. ");
INSERT INTO msc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kɔni Alla ka a fɔ a yɛ ko: «Iburahima, wo kana gba i la i dencɛ ni i la jɔnmuso la ko. Saran ba fen fen ɲinin i fɛ, i ye wo kɛ a yɛ, baa n ka bɔnsɔn mɛn lahidi ta i yɛ, bɔnsɔn wo bɔtɔ Isiyaka le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kɔni n di i la jɔnmuso dencɛ bɔnsɔn fanan siyaya ka a kɛ jamatii ri ka a masɔrɔn a bɔra ile le rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wo duusagbɛni, Iburahima ka buru ta ka a di Hajara ma, ka ji kɛ jikɛfen gbololama kɔndɔ ka wo fanan di a ma. A ka a den di a ma ko ii ye wa. Hajara bɔra Iburahima wara wo rɔ ka wa a mataama wula kɔndɔ, Bɛri-Seba so kɔkan. ");
INSERT INTO msc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ii ka ii mataama wula kɔndɔ haan ji banda jikɛfen kɔndɔ. Ji banda tuma mɛn na, Hajara ka a den to jirinin do lulen na. ");
INSERT INTO msc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","A ka a mabɔ a den na ko biɲɛ sɔmɔndiya ko kelen jatela ka a sii, baa a ka a miri ko a tɛ a fɛ ka a den faatɔla yen. A ka a sii ye ka kasi kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kɔni Alla ka den kasi kan mɛn. Wo rɔ, Alla la mɛlɛka ka a kan nabɔ Hajara ma ka bɔ sankolo rɔ. A ka a fɔ ko: «Hajara, nfen kɛni? I kana silan. Alla ra i den kasi kan mɛn. ");
INSERT INTO msc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","I wuli ka wa den bolo mira. N di a bɔnsɔn siyaya ka a kɛ jamana ba ri.» ");
INSERT INTO msc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Alla ka Hajara ɲa laka. A ka kɔlɔn do yen. A wara jikɛfen nafa ji rɔ ka na a di den ma. Den ka ji min. ");
INSERT INTO msc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Alla tora den fɛ. A kunbayara, ka a sii wula kɔndɔ ka a kɛ biɲɛfilila ri. ");
INSERT INTO msc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","A siini tɛrɛ Paran wula kɔndɔ. A na ka Misiranka muso do furu ka wo di a ma. ");
INSERT INTO msc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nba, lon do rɔ Abimelɛki ka a la kɛlɛden kuntii Pikɔli ta ka wa Iburahima wara. A ka a fɔ Iburahima yɛ ko: «Alla ye i fɛ i la ko bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Wo rɔ, n ye a fɛ i ye i kali Alla la yan bi, ko nde ni n denilu, a ni n mamarenilu, ko i tɛ an si janfa. I ye londan de ri n na jamana rɔ yan. N ka ɲumaya mɛn kɛ i yɛ wo rɔ, n da wo kɛ. Wo ɲa kelen ma, i ka kan ka ɲumaya wo kɛ n yɛ, i ye wo kɛ. I ye an na jamana mɛn dɔ bi, i ka kan ka ɲumaya mɛn kɛ wo la mɔɔilu yɛ, i ye wo fanan kɛ.» ");
INSERT INTO msc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iburahima ka a fɔ ko: «Ale le wo ri, n da n kali wo la.» ");
INSERT INTO msc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kɔni Iburahima ka Abimelɛki jalaki kɔlɔn do la ko rɔ, baa Abimelɛki la jɔnilu tun da wo mira fanka la. ");
INSERT INTO msc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelɛki ka Iburahima jabi: «N ma a lɔn n na jɔn mɛn ka kɔlɔn mira. Ile ma foyi fɔ n yɛ. N ma a lɔn fo bi.» ");
INSERT INTO msc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Iburahima ka a la saa doilu bɔ, a ni a la bailu a ni a la nisiilu bɔ ka a di Abimelɛki ma, ii la teriya rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iburahima ka saadenni musoman wɔrɔnwula gbɛrɛ fanan bɔ a la saa kuru rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelɛki ka a maɲininka ko: «I ka saaden musoman wɔrɔnwula ɲin bɔ nfenna ko rɔ?» ");
INSERT INTO msc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iburahima ka a fɔ ko: «Saadenni musoman wɔrɔnwula ɲin mira. Ii ye kɛ an sere ri ka a yiraka ko nde le ka kɔlɔn ɲin sen.» ");
INSERT INTO msc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Wo le rɔ, ii ka dinkira wo tɔɔ la ko Bɛri-Seba, baa Iburahima ni Abimelɛki ka ii kali ii ɲɔɔn yɛ dinkira wo le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ii ka ii kali ii ɲɔɔn yɛ tuma mɛn na, Abimelɛki ni a la kɛlɛden kuntii Pikɔli ka ii kɔsɛ ii wara Filisiti jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Iburahima ka tamarisiju turu Bɛri-Seba ka Allabatala bato, Maari mɛn tɛ banna kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Iburahima mɛnda Filisiti jamana wo rɔ ka waati jan kɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nba, waati wo taminni kɔ rɔ, Alla ka Iburahima kɔrɔbɔ. A ka a kili ko: «Iburahima.» Iburahima ka a fɔ ko: «Naamun.» ");
INSERT INTO msc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Alla ka a fɔ ko: «I ye Isiyaka ta, i dencɛ kelen pe, mɛn duman i yɛ. I ye wa a ri Morija mara rɔ. N di koyinkɛ do yiraka i la ye. I ye wa koyinkɛ wo kan ka Isiyaka kɛ saraka ri ka n sɔ a la ye. I ye a faa ka a janin ka a kɛ buuri ri.» ");
INSERT INTO msc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wo Duusa gbɛni, Iburahima wulira jona ka lɔɔ tɛɛ Alla sɔlifen janin kanma ka a la fali rabɛn. A ka a la jɔncɛ fila kili, a ni a dencɛ Isiyaka. Ii bɛɛ ka sila mira ka wa. Alla ka dinkira mɛn ko fɔ a yɛ, ii wara ye. ");
INSERT INTO msc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ii ka tele sawa kɛ taaman na. Iburahima ka a ɲa lɔ wula jan na ka dinkira wo yen. ");
INSERT INTO msc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Iburahima ka a fɔ a la jɔnilu yɛ ko: «N ni n dencɛ watɔ koyikɛ wo kan ka Alla bato. Ai ye an makɔnɔ fali dafɛ yan. An natɔ.» ");
INSERT INTO msc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iburahima ka Alla sɔlifen janin lɔɔ sii a dencɛ Isiyaka kun ma, ka a la muru ta, a ni takisɛ. Ii fila wara ii ɲɔɔn fɛ. ");
INSERT INTO msc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isiyaka ka a fɔ a fa yɛ ko: «N fa.» Iburahima ka a fɔ ko: «Naamun.» Isiyaka ka a fɔ ko: «Takisɛ ye an bolo, lɔɔ fanan ye an bolo. Saadennin ye mi, an ye mɛn kela saraka janinta ri Alla ma?» ");
INSERT INTO msc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iburahima ka a jabi: «N den, Alla ri an mako ɲa ka saadennin ko ɲanabɔ.» Ii fila tora wa la i ɲɔɔn fɛ. ");
INSERT INTO msc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Dinkira mɛn ko fɔni a yɛ Alla bolo, ii sera ye. Iburahima ka saraka janin diya lɔ ka lɔɔ la wo kan. Wo kɛni, a ka a dencɛ Isiyaka sidi ka a lala saraka janin diya kan lɔɔ kun na. ");
INSERT INTO msc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","A ka a la muru ta ko a ye a dencɛ kannatɛɛla. ");
INSERT INTO msc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kɔni Allabatala la mɛlɛka tora sankolo rɔ ka a kan nabɔ Iburahima ma ko: «Iburahima, Iburahima!» Iburahima ka a fɔ ko: «Naamun.» ");
INSERT INTO msc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mɛlɛka ka a fɔ ko: «I kana i bolo lase i den ma de! I kana foyi kɛ a la. N da a lɔn sisen ko i silanni Alla yɛ, ka a masɔrɔn i ma i ban ka i dencɛ kelen pe di Alla ma.» ");
INSERT INTO msc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Iburahima ka a ɲa lɔ ka saaji do yen. A mirani a kere ma tunin do rɔ. Iburahima wara saaji wo mira ka a kɛ saraka ri Allabatala sɔ kanma a dencɛ nɔ rɔ. A ka a faa ka a janin ka a kɛ buuri ri. ");
INSERT INTO msc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Iburahima ka dinkira wo tɔɔ la ko: «Allabatala ri mɔɔ mako ɲa.» Wo le rɔ, mɔɔilu ye a fɔla bi ko: «Allabatala ri mɔɔ mako ɲa a la koyinkɛ kan.» ");
INSERT INTO msc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Allabatala la mɛlɛka tora sankolo rɔ ka Iburahima kili a siɲa filana rɔ, ");
INSERT INTO msc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ka a fɔ a yɛ ko: «Allabatala ka a fɔ ko: ‹I ma i ban i dencɛ kelen pe faala ka a kɛ saraka ri ka a di n ma. Ikomin i ra wo kɛ, n da n kali n jɛrɛ tɔɔ la, ko ");
INSERT INTO msc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","i ri baraka. N di i bɔnsɔn siyaya ikomin lolo ye sankolo rɔ ɲa mɛn ma, wala kɔɔji da la kiɲɛ siyaman yɛ ɲa mɛn dɔ. I bɔnsɔn di se ii juuilu la, fɔɔ ka woilu la soilu mira ii la. ");
INSERT INTO msc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Wo ri kɛ sababu ri, siya bɛɛ ri baraka sɔrɔn n bolo i bɔnsɔn fɛ, baa i ra n kan mira ka a kɛ.›» ");
INSERT INTO msc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nba, Iburahima ni a dencɛ ka ii kɔsɛ ka wa a la jɔnilu tɛrɛn ye. Ii bɛɛ ka sila mira ka wa Bɛri-Seba. Iburahima ka a sii ye le ka mɛn. ");
INSERT INTO msc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Waati wo taminni, a fɔra Iburahima yɛ ko a badenma cɛɛ Nakɔri muso Milika fanan da dencɛilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A dencɛ fɔlɔma tɔɔ ko Usi. A dencɛ filana tɔɔ ko Busi. A dencɛ sawana tɔɔ ko Kemuhɛli. Kemuhɛli wo ye Aramu fa le ri. ");
INSERT INTO msc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Milika dencɛ naaninna tɔɔ ko Kesɛdi, ka Haso tuun wo la, ka Pilidasi tuun wo la, ka Jidilafe tuun wo la, ka ban ka Betuwɛli tuun wo la. ");
INSERT INTO msc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwɛli wo le denmuso le Rebeka ri. Milika ka dencɛ seyin wo le sɔrɔn Iburahima badenma cɛɛ Nakɔri yɛ. ");
INSERT INTO msc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nakɔri jɔn muso, mɛn tɔɔ ko Rehuma, wo fanan ka dencɛilu sɔrɔn a yɛ. Wo dencɛilu tɔɔ le ten: Tebaki, Kahamu, Tahasi a ni Maaka. ");
INSERT INTO msc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saran ka san kɛmɛ ni san muwan ni wɔrɔnwula bɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","a sara Kanaan jamana Kiriyati Ariba so kɔndɔ, mɛn tɔɔ bi ko Heburɔn. Iburahima ka a sii Saran su kun na a ka kasi. ");
INSERT INTO msc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Iburahima bɔra a muso Saran su dafɛ, ka wa kuma Hɛtika yɛ, ");
INSERT INTO msc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","a ka a fɔ ko: «Nde ye londan de ri ai wara yan. Ai ye dinkira do san n ma, sa n di a kɛ kaburu so ri ka n muso su don ye.» ");
INSERT INTO msc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hɛtika ka Iburahima jabi: ");
INSERT INTO msc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«An fa, i tolo malɔ an kan na. Ile ye Alla la faamaden de ri an tɛma yan. An na kaburu so dinkira mɛn ba diya i yɛ, i ye i la su don ye. An si tɛ an ban wo ma ka an na duu di i ma. I ye i muso su don.» ");
INSERT INTO msc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iburahima ka a wuli ka a majii Hɛtikailu ɲana. ");
INSERT INTO msc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A ka a fɔ ii yɛ ko: «Nba, ni ai sɔnda n ye n muso sutura, ai jaandi, ai ye Sohari dencɛ Efurɔn madiya n yɛ. ");
INSERT INTO msc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Falan mɛn ye a bolo Makipela, a la sɛnɛ kɔnkɔ fɛ kɔnin, a ye wo san n ma. A sɔnkɔ wa kɛ wodi mɛn di, n di wo di a ma ai ɲakɔrɔ yan, sa dinkira wo ri kɛ n na kaburu so ri.» ");
INSERT INTO msc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Wo ka a tɛrɛn Efurɔn jɛrɛ siini Hɛtika tɛma so donda la ye, baa ale fanan tɛrɛ Hɛtika de ri. A ka Iburahima jabi jama bɛɛ ɲana ko: ");
INSERT INTO msc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«An fa, i tolo malɔ n kan na. N di sɛnɛ ni falan bɛɛ di i ma ka a la a ɲɔɔn kan. N ye a bɛɛ dila i ma ka n badenmailu kɛ a sere ri. Wa, i muso su don.» ");
INSERT INTO msc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Iburahima ka a majii so kɔndɔ mɔɔ bɛɛ ɲana. ");
INSERT INTO msc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A ka a fɔ Efurɔn yɛ wo bɛɛ ɲakɔrɔ ko: «I jaandi, i tolo malɔ n na. N di sɛnɛ ɲin sankɔ di i ma. I ye a mira, sa n di wa n muso su don ye.» ");
INSERT INTO msc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efurɔn ka a fɔ Iburahima yɛ ko: ");
INSERT INTO msc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«N na faama, i tolo malɔ n na. Sɛnɛ ɲin sankɔ tɛ tamin wodigbɛ kilo naanin a ni tala la. Wo ri nfen ɲa nde ni ile tɛma? Wa i muso su don.» ");
INSERT INTO msc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Efurɔn ka sɛnɛ sankɔ mɛn fɔ, Iburahima sɔnda wo ma. A ka wodigbɛ wo suman Hɛtika bɛɛ ɲana ka a di Efurɔn ma, wodigbɛ kilo naanin a ni tala la, ka bɛn julailu la sumanni ɲa ma. ");
INSERT INTO msc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Wo rɔ, Iburahima ka Efurɔn na sɛnɛ san a ma, sɛnɛ mɛn tɛrɛ Makipela, Mamere fan fɛ. Sɛnɛ wo ni a falan ni a jiri bɛɛ haan ka wa se sɛnɛ dan na, ");
INSERT INTO msc_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","wo bɛɛ kɛra Iburahima ta ri. Hɛtika mɛn bɛɛ siini tɛrɛ ladɛn dɔ so donda la ye, woilu kɛra ii sere ri. ");
INSERT INTO msc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Iburahima bɔra ye ka a wa a muso Saran su don falan na Makipela, Mamere fan fɛ Kanaan jamana. Mamere wo tɔɔ le fanan ko Heburɔn. ");
INSERT INTO msc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Wo le kosɔn, sɛnɛ wo ni a falan bɛɛ kɛra Iburahima ta ri, ka a kɛ a la kaburu so ri. A ka wo san Hɛtika de ma. ");
INSERT INTO msc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nba, Iburahima kɔrɔyara kosɛbɛ, Allabatala tun ka baraka don a la ko bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Lon do rɔ, a ka a dɛmɛnba kili, mɛn ye a la nanfulu kunnasiila ri, a ka a fɔ a yɛ ko: «I bolo la n woro kɔrɔ ka lahidi ta n yɛ ka i kali. ");
INSERT INTO msc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","An siini Kanaanka le tɛma yan, kɔni n ye a fɛ i ye i kali Allabatala tɔɔ rɔ, mɛn ye sankolo ni duukolo tii ri, ko i tɛ Kanaanka denmuso si furu ka a di n dencɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","I ye i kali ko i ri wa n fa jamana rɔ, ka wa denmuso do furu n dencɛ Isiyaka yɛ n badenmailu wara.» ");
INSERT INTO msc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Dɛmɛnba wo ka a fɔ ko: «Ni denmuso ma sɔn ka na nde kɔfɛ yan don? N ye wa i dencɛ ri i fa jamana rɔ wa?» ");
INSERT INTO msc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iburahima ka a fɔ ko: «Ɛɛn de! I kana wa n dencɛ ri ye fewu! ");
INSERT INTO msc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Allabatala Alla, mɛn ye sankolo tii ri, wo ka n nabɔ n fa so la, ka n nabɔ n sɔrɔn jamana rɔ. A kumara ka a kali n yɛ ko a ri jamana ɲin di n bɔnsɔn ma. Ale le jɛrɛ kɛtɔ a la mɛlɛka bilala i ɲɛ ka wa n fa jamana rɔ, sa i ri muso do sɔrɔn n dencɛ yɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ni muso ma sɔn ka na i kɔfɛ, wo kalili kunko ri bɔ i ma, kɔni i kana wa n dencɛ ri de!» ");
INSERT INTO msc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","A dɛmɛnba ka a bolo la a tii Iburahima woro kɔrɔ ka a kali ko a ri wo bɛɛ kɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Wo rɔ, Iburahima la dɛmɛnba ka ɲɔɔmɛ tan ta a tii la ɲɔɔmɛilu rɔ ka wa Nakɔri la so la, Aramu Naharayimu mara rɔ. A tii la fen ɲuma ba doilu wara a kun ma. ");
INSERT INTO msc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","A se mɛn kɛni ye, a ka ɲɔɔmɛilu lala kɔlɔn da la so kɔkan. A donda wura da le fɛ, musoilu ye wala ji ta diya kɔlɔn da la waati mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A ka Alla tara ko: «Allabatala, n tii Iburahima Maari Alla, i jaandi, i ye n na sila diya n na bi. I ye ɲumaya kɛ n tii Iburahima yɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","N lɔni kɔlɔn da la yan, so kɔndɔ sunkurunilu ri na ji ta diya yan sisen. ");
INSERT INTO msc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","N ba a fɔ sunkurun mɛn yɛ ko: ‹I la jitafen najii ka n sɔ ji rɔ, n ye n min›, ni wo ka n sɔ, ka ban ka n na ɲɔɔmɛilu fanan namin, nba sunkurun wo ye kɛ i la baaraden Isiyaka muso ri, i jɛrɛ ka mɛn natɛɛ a ma. Ni wo bɛɛ kɛra, n di a lɔn ko i ra ɲumaya kɛ n tii yɛ ka a masɔrɔn i ra kɛ a Maari Alla ri.» ");
INSERT INTO msc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sani a ye ban Alla matarala, Rebeka nara ka a tɛrɛn a la jitafen ye a kanbankun kan. Rebeka ye Betuwɛli denmuso le ri. Betuwɛli ye Milika dencɛ le ri. Milika ye Nakɔri la muso le ri, Iburahima kɔrɔcɛ kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Sunkurun wo kenɲi kosɛbɛ. A ma cɛɛ lɔn fɔlɔ. A wara ji ta diya, ka a la jitafen nafa ka a kɔsɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Iburahima dɛmɛnba ka i bori ka wa a labɛn, ka a fɔ a yɛ ko: «N na, i jaandi, i ye n sɔ ji rɔ, n ye n min.» ");
INSERT INTO msc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Sunkurun ka a kaliya ka a la jitafen majii, ka cɛɛ wo jabi: «N fa, i min.» A ka a la jitafen mira a bolo la ka cɛɛ sɔ ji rɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","A banni ji minna, sunkurun ka a fɔ ko: «I lɔ, n di wa ji ta ka i la ɲɔɔmɛilu fanan sɔ ji rɔ. A bɛɛ ye ii min ka wasa.» ");
INSERT INTO msc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A ka i kaliya ka a la jitafen najii ka ji kɛ kolofen na jiminfen kɔndɔ ka i bori ka wa ji ta ikɔ. A tora ji tala ka na haan ɲɔɔmɛilu bɛɛ banda ii minna. ");
INSERT INTO msc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","A tɛrɛ ye baara wo kan tuma mɛn na, cɛɛ wo ka a lɔ ka a mafɛnɛ. A ma foyi fɔ. A ka sunkurun kɔrɔsi ka a lɔn ni Allabatala da a la sila diyala. ");
INSERT INTO msc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ɲɔɔmɛ bɛɛ banda ji minna tuma mɛn na, cɛɛ ka nundɔlafen sanin do labɔ, mɛn sumannin di karamun loolu bɔ. A ka bololafen sanin fila fanan nabɔ, mɛn sumannin di karamun kɛmɛ a ni karamun tan ni loolu bɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A ka sunkurun maɲininka ko: «Hakɛ to, yon denmuso ye ile ri? I fa ri sɔn ka nde ni n taamaɲɔɔnilu jiya a wara wa?» ");
INSERT INTO msc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka ka a jabi: «Nakɔri ni Milika dencɛ Betuwɛli, wo denmuso le nde ri. ");
INSERT INTO msc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ai ri jiya diya sɔrɔn an wara. Bin ni fira siyaman ye an bolo fanan ka a di i la ɲɔɔmɛilu ma.» ");
INSERT INTO msc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Cɛɛ ka wo mɛn ka a tin birin ka Allabatala bato. ");
INSERT INTO msc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","A ka a fɔ ko: «N di Allabatala tando, n tii Iburahima Maari Alla, a ma ban a la kaninteya ma. Allabatala le ka a lɔ n ɲɔrɔ ka n na n di n tii Iburahima badenmailu ma yan.» ");
INSERT INTO msc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Sunkurun ka a bori ka wa a bɛɛ ɲafɔ mɔɔilu yɛ a na wara. ");
INSERT INTO msc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Wo ka Rebeka kɔrɔcɛ do tɛrɛn ye, mɛn tɔɔ ko Laban. Wo ka wo bɛɛ mɛn tuma mɛn na, a bɔra ka a bori ka wa cɛɛ wo kɔ kɔlɔn da la, ");
INSERT INTO msc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","baa Laban tun ka nundɔlafen ni bololafen yen a dɔɔmuso bolo la. Rebeka ka a dantɛɛli mɛn kɛ, Laban tolo tɛrɛ ye wo bɛɛ la. A sera kɔlɔn da la, ka cɛɛ lɔni tɛrɛn a la ɲɔɔmɛilu dafɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban ka a fɔ a yɛ ko: «N fa, ile, Allabatala ka baraka don ile mɛn na kɔ rɔ, nfenna i lɔni kɔkan yan? An ye wa lu ma. N da dinkira rabɛn i yɛ, ka dinkira fanan dabɛn i la ɲɔɔmɛilu yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Wo rɔ, cɛɛ wara Laban kɔfɛ lu ma. Ii sisen ye, Laban ka ɲɔɔmɛilu la donin bɛɛ lajii, ka bin ni fira di ii ma. A nara ji di cɛɛ ni a taamaɲɔɔnilu ma. Ii ka ii sen mako. ");
INSERT INTO msc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A ka dɔɔnnin sii ii kɔrɔ. Kɔni cɛɛ ka a fɔ ko: «N tɛ dɔɔnnin kɛla fɔlɔ, fo n ye dantɛɛli kɛ fɔlɔ.» Laban ka a jabi: «Ale le wo ri. I ye dantɛɛli fɔlɔ kɛ.» ");
INSERT INTO msc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Cɛɛ ka a fɔ ko: «N ye Iburahima dɛmɛnba le ri. ");
INSERT INTO msc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Allabatala ka baraka don n tii la wo rɔ kosɛbɛ ka a kɛ nanfulutii ri. A ra saa ni baa ni nisiilu di a ma, a ni wodigbɛ ni sanin, a ni jɔnilu ni jɔnmusoilu, a ni ɲɔɔmɛilu ni faliilu. ");
INSERT INTO msc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","N tii Iburahima muso Saran ka dencɛ sɔrɔn a yɛ a la musokɔrɔbaya waati rɔ. N tii ra a bolofen bɛɛ di a dencɛ wo le ma. ");
INSERT INTO msc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nba, lon do rɔ, n tii ka a fɔ n yɛ ko n ye n kali a yɛ ko a siini Kanaan bɔnsɔn wara mɛn dɔ ɲin, ko n kana sɔn ka wo denmuso si furu a dencɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ko n ye wa a fa jamana rɔ ka muso ɲinin a dencɛ yɛ a badenmailu wara. ");
INSERT INTO msc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","N ka a maɲininka ko ni denmuso ma a sɔn ka na n kɔfɛ don? ");
INSERT INTO msc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A ka n jabi a ye taamala ka bɛn Allabatala mɛn kan ma, wo jɛrɛ ri a la mɛlɛka bila n ɲɛ ka n na sila diya n na, kosa n di muso furu a dencɛ yɛ a badenmailu wara a fa jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","N tii ka a fɔ ko n ba se a fa la jamana rɔ, ko ni a badenmailu ka i ban muso dila n ma, ko n na kalili kunko ri bɔ n ma wo rɔ. Ko kalili kunko wo tɛ bɔ n ma ɲa gbɛrɛ si ma fo wo ba kɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Nba, n se mɛn kɛni kɔlɔn da la bi, n ka Alla matara ko: ‹Allabatala, n tii Iburahima Maari Alla, i jaandi, i ye n na sila diya n na. ");
INSERT INTO msc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","N lɔni kɔlɔn da la yan. Sunkurun mɛn ba na ji ta diya yan, ni n ka a fɔ wo yɛ ko: «Na, i ye i la jitafen najii ka n sɔ ji rɔ,» ");
INSERT INTO msc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ni a ka n jabi: «Do min, n ye wa do fanan ta ka na a di i la ɲɔɔmɛilu ma,» nba sunkurun wo ye kɛ n tii la dencɛ la muso ri, Allabatala jɛrɛ ka mɛn natɛɛ a ma.› ");
INSERT INTO msc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nba, sani n ye ban madiyali kɛla n kɔndɔ, n ka Rebeka natɔla yen. A la jitafen ye a kanbankun kan. A wara jitafen wo lafa. N ka a fɔ a yɛ ko: ‹N na, n sɔ ji rɔ.› ");
INSERT INTO msc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A ka a kaliya ka jitafen majii a kanbankun na ka a fɔ ko: ‹I min. N di i la ɲɔɔmɛilu fanan sɔ ji rɔ.› Wo rɔ, n ka n min. N banni n minna, a ka n na ɲɔɔmɛilu fanan sɔ ji rɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","N ka a maɲininka ko: ‹Yon denmuso ye ile ri?› A ka a fɔ ko: ‹Nakɔri ni Milika dencɛ Betuwɛli denmuso le nde ri.› N ka nundɔlafen don a nun dɔ, ka a bololafen bila a bolo la. ");
INSERT INTO msc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","N ka n tin birin ka Allabatala bato, n tii Iburahima Maari Alla kɔnin. N ka wo tando ka a masɔrɔn a ka a lɔ n ɲɔrɔ ka na n di n tii Iburahima badenmailu wara, ka ii denmuso sɔrɔn n tii dencɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nba, ni ii ye a fɛ ka kaninteya yirika n tii la, ai ye wo fɔ n yɛ. Ni ai fanan ti se wo kɛla, ai ye wo fɔ n yɛ, kosa n ka kan ka mɛn kɛ, n ye wo kɛ.» ");
INSERT INTO msc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ni Betuwɛli ka a jabili kɛ ko: «Ko ɲin bɔni Allabatala jɛrɛ le rɔ. An ti se wo masɔsɔla. ");
INSERT INTO msc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka le ɲin di. A ta, i ye wa a ri. A ye kɛ i tii dencɛ la muso ri, ikɔ Allabatala a ra a latɛɛ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Iburahima dɛmɛnba ka jabili wo mɛn tuma mɛn na, a ka a ɲakɔrɔ bɛn duu ma ka Allabatala bato. ");
INSERT INTO msc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A ka wodigbɛ masidilifen ni sanin masidilifen labɔ ka woilu di Rebeka ma, a ni faanin. A ka fen ɲuma bailu di a kɔrɔcɛ ni a na fanan ma. ");
INSERT INTO msc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Wo rɔ, kuma wo banni, cɛɛ ni a taamaɲɔɔnilu ka dɔɔnnin kɛ, ka ii min, ka su si. Ii kununni sɔɔma da la, cɛɛ ka a fɔ Rebeka la mɔɔilu yɛ ko: «Ai ye sila di n ma sa n di n kɔsɛ n tii wara.» ");
INSERT INTO msc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebeka kɔrɔcɛ ni a na ka jabili kɛ ko: «A to sunkurun ye tele tan ɲɔɔn kɛ an fɛ yan fɔlɔ. Wo ba tamin, a ri wa.» ");
INSERT INTO msc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Cɛɛ ka a fɔ ko: «Ai jaandi, ai kana n nanɔɔ butun, baa Allabatala a ra n na sila diya n na. Ai ye a to n ye kɔsɛ n tii wara jona.» ");
INSERT INTO msc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ii ka a jabi: «Nba, an ye sunkurun kili ka a maɲininka.» ");
INSERT INTO msc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ii ka Rebeka kili ka a maɲininka ko: «I ri taa cɛɛ ɲin kɔfɛ sisen wa?» A ka a fɔ ko: «N di wa.» ");
INSERT INTO msc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Wo rɔ, ii ka ii badenma muso Rebeka bila ka wa Iburahima dɛmɛnba ni a taamaɲɔɔnilu kɔfɛ. Jɔnmuso mɛn ka a mamira, wo wara Rebeka malɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ii watɔla, Rebeka wara mɔɔilu duwara a yɛ. Ii ka a fɔ ko: «An badenma muso, Alla ye i bɔnsɔn siyaya ka a kɛ mɔɔ waa siyaman siyaman di, Alla ma wo kɛra. Alla ye ii se ii juuilu la, Alla ma wo kɛra.» ");
INSERT INTO msc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebeka ni a la jɔnmusoilu ka ii rabɛn ka yɛlɛ ɲɔɔmɛilu kan, ka ii bila Iburahima dɛmɛnba kɔfɛ. A wara Rebeka ri wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Wo ka a tɛrɛn, Isiyaka ra bɔ Bɛri Lasayi Rɔyi fan fɛ, Nɛkɛbi mara rɔ. ");
INSERT INTO msc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lon do rɔ, Isiyaka wara a mataamala diya wula kɔndɔ wura da fɛ. A ka a ɲa lɔ ka ɲɔɔmɛilu natɔla yen. ");
INSERT INTO msc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka ka a ɲa lɔ ka Isiyaka yen tuma mɛn na, a jiira ka bɔ a la ɲɔɔmɛ kan. ");
INSERT INTO msc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","A ka Iburahima dɛmɛnba maɲininka ko: «Mɛn bɔtɔ wula rɔ ka na an kunbɛn ɲin, yon de wo ri?» Cɛɛ ka a fɔ ko: «N tii le wo ri.» Wo rɔ, Rebeka ka a la kunnabirin kɛ a kun na. ");
INSERT INTO msc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nba, cɛɛ tun ka fen fen kɛ a la taama rɔ, a ka wo bɛɛ ɲafɔ Isiyaka yɛ. ");
INSERT INTO msc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isiyaka wara Rebeka ri a na Saran na faaninbon na, ka a furu ka a kɛ a muso ri. Isiyaka ka Rebeka kanin kosɛbɛ, a diyara a yɛ. Wo rɔ, Isiyaka jususumara a na la saya ko rɔ. ");
INSERT INTO msc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nba, Iburahima ka muso gbɛrɛ furu, mɛn tɔɔ ko Ketura. ");
INSERT INTO msc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Wo ka dencɛilu sɔrɔn Iburahima yɛ: Simiran, Jokisan, Medan, Madiyan, Sisibaki a ni Suwahi. ");
INSERT INTO msc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iburahima dencɛ Jokisan fanan ka dencɛ fila sɔrɔn: Seba ni Dedan. Dedan dencɛilu kɛra Asirikailu ni Letusikailu ni Lemikailu le ri. ");
INSERT INTO msc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Iburahima dencɛ Madiyan dencɛilu le ten: Efa, Efɛri, Hanɔki, Abida a ni Elida. Wo bɛɛ ye Ketura bɔnsɔn de ri. ");
INSERT INTO msc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Iburahima ka a cɛ bɛɛ di Isiyaka le ma, ");
INSERT INTO msc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","kɔni a ka a jɔn muso tɔilu dencɛilu fanan sɔ fen doilu rɔ. Sani a ye sa, Iburahima ka woilu lawa telebɔ jamana rɔ, ka ii mabɔ a dencɛ Isiyaka la. ");
INSERT INTO msc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Iburahima si san bɛɛ ladɛnnin kɛra san kɛmɛ ni san biwɔrɔnwula ni san loolu le ri. ");
INSERT INTO msc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","A ka a la kɔrɔya diya bɔ kosɛbɛ ka sa ka la a benbailu kan. ");
INSERT INTO msc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A dencɛ fila, mɛnilu ye Isiyaka ni Isumayila ri, woilu ka a su don Makipela falan na, Mamere fan fɛ. Dinkira wo tɛrɛ ye Hɛtika Sohari dencɛ Efurɔn bolo kɔrɔman na, ");
INSERT INTO msc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","kɔni Iburahima ka wo le san a ma. A ni a muso Saran su donda ye. ");
INSERT INTO msc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Iburahima sani kɔ rɔ, Alla ka baraka don a dencɛ Isiyaka la kɔ rɔ. Isiyaka siini tɛrɛ Bɛri Lasayi Rɔyi le la. ");
INSERT INTO msc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nba, Iburahima dencɛ Isumayila bɔnsɔn de ɲin di, Saran na jɔnmuso Misiranka Hajara a ka mɛn sɔrɔn Iburahima yɛ. ");
INSERT INTO msc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isumayila dencɛilu tɔɔ le ɲin di, ka bɛn ii sɔrɔn waati ma. A dencɛ fɔlɔ tɔɔ ko Nebayɔti, ka Kedari tuun wo la, ka Adibɛli tuun wo la, ka Mibisamu tuun wo la, ");
INSERT INTO msc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ka Misima tuun wo la, ka Duma tuun wo la, ka Masa tuun wo la, ");
INSERT INTO msc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ka Hadadi tuun wo la, ka Tema tuun wo la, ka Jeturi tuun wo la, ka Nafisi tuun wo la, ka Kedima tuun wo la. ");
INSERT INTO msc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isumayila dencɛilu le wo ri, mɛnilu kɛra faama tan ni fila le ri, ka ii sii kabila tan ni fila kun na, bɛɛ ni ii la so. ");
INSERT INTO msc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isumayila ka san kɛmɛ ni san bisawa ni san wɔrɔnwula le sɔrɔn, ka sa ka la a benbailu kan. ");
INSERT INTO msc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","A bɔnsɔn siini tɛrɛ Asuri so sila la, Misiran telebɔ fan fɛ, Habila ni Suri soilu tɛma. Ii ni ii badenma tɛrɛ ma i sii i ɲɔɔn fɛ. ");
INSERT INTO msc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Nba, Iburahima dencɛ Isiyaka bɔnsɔn de ɲin di. Iburahima ka Isiyaka sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isiyaka sɔrɔn ka san binaanin bɔ tuma mɛn na, a ka Rebeka furu. Rebeka fa le tɛrɛ Betuwɛli ri. Betuwɛli ye Aramu bɔnsɔn do le ri ka bɔ Padani Aramu. Rebeka kɔrɔcɛ le tɛrɛ Aramu bɔnsɔn Laban di. ");
INSERT INTO msc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isiyaka ka Allabatala matara a muso yɛ ka a masɔrɔn a tɛrɛ densɔrɔnbali le ri. Allabatala ka a la tarali kan mira, Rebeka ka filani kɔnɔ ta. ");
INSERT INTO msc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ka a tɛrɛn ii ma sɔrɔn fɔlɔ, denilu bilara i ɲɔɔn na ii na kɔnɔ rɔ. Rebeka ka a fɔ ko: «Nfenna ɲin ye kɛla n na?» A wara Allabatala maɲininka ko wo ma. ");
INSERT INTO msc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Allabatala ka a jabi: «Jamana fila le ye i kɔnɔ. Jamana fila ri bɔ i kɔnɔ rɔ. Kelen fanka ri bonya kelen ta ri. Kɔrɔmamɔɔ ri kɛ dɔɔmamɔɔ la baaraden de ri.» ");
INSERT INTO msc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Nba, Rebeka moyi lon seni, a moyira filani le la. ");
INSERT INTO msc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mɛn fɔlɔma sɔrɔnda, wo wulenni de tɛrɛ, si le tɛrɛ ye a fari ma. Wo rɔ ii ka wo tɔɔ la ko Esawu. ");
INSERT INTO msc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wo kɔ rɔ, a dɔɔcɛ nara, a kɔrɔcɛ sen tintiri mirani a bolo. Ii ka wo tɔɔ la ko Yakuba. Rebeka ka ii sɔrɔn ka a tɛrɛn Isiyaka sɔrɔn da san biwɔɔrɔ bɔ. ");
INSERT INTO msc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Denilu bonyara ka kɛ kanberen di. Esawu kɛra donso fadiman di, waa rɔ taama diyara a yɛ. Kɔni, Yakuba kɛra mɔɔ masumanin di, a tun tɛ a mabɔla faaninbon na kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esawu duman tɛrɛ Isiyaka yɛ, ka a masɔrɔn a tɛrɛ ye sobo sɔrɔnna Esawu le sababu le rɔ. Yakuba duman tɛrɛ Rebeka yɛ. ");
INSERT INTO msc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lon do rɔ, Yakuba tɛrɛ ye sɔsɔ tibila. Esawu kɔnkɔto ba nara ka bɔ wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","A ka a fɔ Yakuba yɛ ko: «Kɔnkɔ ba le n na ɲin. I jaandi, i ye n sɔ i la sɔsɔ wulen dɔ. N ye a dɔɔn.» Nba, kuma wo kɛra sababu ri, mɔɔilu ka a fɔ Esawu ma ko Edɔmu. ");
INSERT INTO msc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakuba ka a jabi: «Ni i ka i la kɔrɔmamɔɔya di n ma fɔlɔ, n di i sɔ.» ");
INSERT INTO msc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu ka a fɔ ko: «Kɔnkɔ kɛtɔ n faala. Kɔrɔmamɔɔya ye nfen ɲala n ma?» ");
INSERT INTO msc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakuba ka a jabi: «I kali Alla la fɔlɔ.» Esawu ka a kali a yɛ, ka a la kɔrɔmamɔɔya falen Yakuba ma wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Wo rɔ Yakuba ka a sɔ sɔsɔ ni buru rɔ. Esawu ka a dɔɔn ka ji min ka a wuli ka wa. Nba, a kɛra ten de. Esawu ma a la kɔrɔmamɔɔya jate foyi ri. ");
INSERT INTO msc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nba, wo bɛɛ taminni kɔ rɔ, kɔnkɔ donda jamana kɔndɔ. Kɔni kɔnkɔ mɛn donda Iburahima la waati rɔ, wo ni ɲin tɛ kelen di. Isiyaka wara Filisitiilu la mansa Abimelɛki wara, Kerari so la. ");
INSERT INTO msc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Allabatala bɔra gbɛ rɔ Isiyaka yɛ, ka a fɔ a yɛ ko: «I kana wa Misiran! N kɛtɔ jamana mɛn yirakala i la, i ye wa i sii ye. ");
INSERT INTO msc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","I ye mɛn jamana wo rɔ fɔlɔ. N di to i fɛ, ka baraka don i la ko rɔ, ka yɔrɔ ɲin bɛɛ di i ni i bɔnsɔn ma. Wo rɔ n di n na lahidi mafa, n ka mɛn ta i fa Iburahima yɛ. ");
INSERT INTO msc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ko lolo ka siya ɲa mɛn ma, n di i bɔnsɔn siyaya wo ɲa ma, ka duu ɲin bɛɛ di ii ma. Siyailu bɛɛ ri baraka sɔrɔn n bolo i bɔnsɔn na sababu rɔ. ");
INSERT INTO msc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","N di baraka don i la ko rɔ, ka a masɔrɔn Iburahima ka n kan mira ka a kɛ. N ka mɛn fɔ a yɛ, a ka wo bɛɛ kɛ. A ka n na jamarili ni n na sariya bɛɛ latelen.» ");
INSERT INTO msc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Wo rɔ, Isiyaka ka a sii Kerari ye. ");
INSERT INTO msc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ye cɛɛilu tun ba Isiyaka maɲininka a muso la ko ma, a ri a fɔ ko a dɔɔmuso le. A silanni tɛrɛ a fɔla ii yɛ ko a muso le, sa ii kana a faa ka Rebeka ta, baa Rebeka kenɲi ba le tɛrɛ. ");
INSERT INTO msc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nba, Isiyaka mɛnda Kerari. Lon do rɔ, Filisiti la mansa Abimelɛki ka a ɲa labɔ a la bon na ka Isiyaka ni a muso Rebeka yen. Ii ye tolon kɛla i ɲɔɔn fɛ. ");
INSERT INTO msc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelɛki ka Isiyaka kili ka a fɔ a yɛ ko: «I muso le ɲin di jɔ! Nfenna i ka a fɔ an yɛ ko i dɔɔmuso le?» Isiyaka ka a jabi: «N ka a fɔ ka a masɔrɔn a tɛrɛ n kɔndɔ ko ai ri n faa ka a ta.» ");
INSERT INTO msc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelɛki ka a fɔ ko: «I ka nfen ko kɛ an na ɲin de ten? Ni n na jamana mɔɔ do tun ka a la i muso fɛ wo rɔ don? Ni wo tun kɛra, i tun di an lɔ ko haramunnin kɛla ri!» ");
INSERT INTO msc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelɛki ka a jasere mala a la mɔɔ bɛɛ yɛ ko: «Mɔɔ mɛn ba a maa Isiyaka la, wala a muso la, n di wo tii faa.» ");
INSERT INTO msc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nba, wo san kelen Isiyaka ka suman sɛnɛ jamana wo rɔ. A la suman sɔnda kosɛbɛ, a ka suman si mɛn foyi, a ka wo ɲɔɔn kɛmɛ sɔrɔn, baa Allabatala ka baraka don a la suman dɔ. ");
INSERT INTO msc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isiyaka bolofen siyayara, fɔɔ ka a kɛ nanfulutii ba ri. ");
INSERT INTO msc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Saa ni ba ni nisi ni jɔnilu tɛrɛ a bolo. Wo rɔ, a la ko ɲangboya ka Filisitiilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Wo bolo ma, ii ka bɔɔ kɛ a la kɔlɔn bɛɛ kɔndɔ fo ka ii ja. A fa Iburahima la jɔnilu le tun ka kɔlɔn woilu sen a la tele rɔ. ");
INSERT INTO msc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelɛki ka Isiyaka kili ka a fɔ a yɛ ko: «I ye bɔ an wara yan. I fanka ka bon an ta ri.» ");
INSERT INTO msc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Wo rɔ, Isiyaka bɔra ye ka wa a la faaninbon lɔ Kerari dinban dɔ, ka a sii dinkira wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A fa Iburahima tun ka kɔlɔn mɛnilu sen dinkira wo rɔ a tele rɔ, Filisitiilu nara ka woilu bɛɛ lafa a la saya kɔ rɔ. Isiyaka ka kɔlɔn wo bɛɛ rabɔ ko kura. A fa tun ka tɔɔ mɛn la kɔlɔnilu la, Isiyaka ka tɔɔ kelen kelenna kɔlɔnilu la ii la. ");
INSERT INTO msc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Lon do rɔ, Isiyaka la jɔnilu ka kɔlɔn do sen dinban dɔ ka se ji ma. ");
INSERT INTO msc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kerari kolofen kɔnɔmadenilu nara ka Isiyaka la kolofen kɔnɔmadenilu kɛlɛ, ka a fɔ ko: «Kɔlɔn ɲin ye an ta le ri.» Isiyaka ka kɔlɔn wo tɔɔ la ko Esɛki, ka a masɔrɔn ii kɛlɛra a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isiyaka la jɔnilu ka a kɔlɔn dogbɛrɛ sen. Kɔni Kerarikailu nara ka ii kɛlɛ wo fanan fɛ. Isiyaka ka wo tɔɔ la ko Sitina. ");
INSERT INTO msc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A ka yɔrɔ wo bila ka wa yɔrɔ gbɛrɛ, ka kɔlɔn gbɛrɛ sen ye ikɔ. Mɔɔ si ma ii kɛlɛla wo fɛ. Wo rɔ, Isiyaka ka wo tɔɔ la ko Rehoboti. A ka a fɔ ko: «Sisen Allabatala da dinkira di an ma. An di sabati jamana ɲin kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isiyaka bɔra ye ka wa Bɛri-Seba. ");
INSERT INTO msc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Su wo rɔ, Allabatala bɔra gbɛ rɔ a yɛ, ka a fɔ a yɛ ko: «Nde ye i fa Iburahima Maari Alla le ri. I kana silan, baa n ye i fɛ. N di ɲumaya kɛ i yɛ ka i bɔnsɔn siyaya n na baaraden Iburahima la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isiyaka ka Alla saraka janin diya lɔ ye Allabatala bato kanma. A ka a la faaninbon lɔ dinkira wo rɔ. A la jɔnilu ka kɔlɔn gbɛrɛ sen. ");
INSERT INTO msc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Lon do rɔ, mansa Abimelɛki ni a lalila Ahusati ni a la kɛlɛden kuntii Pikɔli bɔra Kerari ka na Isiyaka wara. ");
INSERT INTO msc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isiyaka ka ii maɲininka ko: «Waati taminni, ai ka n tɔrɔ ka n gbɛn ka n nabɔ ai la jamana rɔ. Nfenna ai nani n wara yan sisen?» ");
INSERT INTO msc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ii ka a jabi: «An da a yen ko Allabatala ye i fɛ. An ye teriya sidi an ɲɔɔn tɛma, ka bɛn kan kelen ma. ");
INSERT INTO msc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ikomin an ma kojuu kɛ i la, i fanan tɛ kojuu kɛ an na. An ka koɲuma le kɛ i yɛ. I bɔra an tɔrɔfɛ hɛrɛ le rɔ. An da a yen sisen ko Allabatala ra baraka don i la ko rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isiyaka ka tibili ba kɛ ii yɛ. Ii ka dɔɔnnin kɛ ka ii min. ");
INSERT INTO msc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wo duusa gbɛ jona, ii ka ii kali i ɲɔɔn yɛ ko ii tɛ kojuu kɛ i ɲɔɔn na. Wo banni, Isiyaka ka sila di ii ma. Ii bɔra hɛrɛ le rɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nba, wo lon kelen, Isiyaka la jɔnilu bɔra kɔlɔn sen diya ka na a fɔ a yɛ ko: «An da kɔlɔn sen ka se ji ma.» ");
INSERT INTO msc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isiyaka ka kɔlɔn wo tɔɔ la ko Seba. Wo le ka a kɛ, so wo tɔɔ lara ko Bɛri-Seba haan bi. ");
INSERT INTO msc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Nba, Esawu sɔrɔn ka san binaanin bɔ tuma mɛn na, a ka Hɛtika sunkurun fila furu. Kelen tɔɔ ko Yuditi. Wo fa tɛrɛ Bɛɛri le ri. A tɔ kelen tɔɔ ko Basimati. Wo fa tɛrɛ Elɔn de ri. ");
INSERT INTO msc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Muso woilu la ko ka Isiyaka ni Rebeka jusu tɔrɔ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Nba, Isiyaka kɔrɔra kosɛbɛ. A ɲa tɛrɛ tɛ fen na sa la wula rɔ. Lon do rɔ, a ka a dencɛ fɔlɔ Esawu kili ko: «N dencɛ.» Esawu ka a jabi: «Naamun.» ");
INSERT INTO msc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isiyaka ka a fɔ ko: «A ragbɛ, n da kɔrɔ. N ma n sa waati lɔn. ");
INSERT INTO msc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","I ye i la donsoya muran ta, i la biɲɛkala ni i la biɲɛ, ka wa sobo ɲinin wula kɔndɔ. I ye na sobo di n ma. ");
INSERT INTO msc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Suman mɛn duman n yɛ, i ye wo tibi ka a sii n kɔrɔ. N di wo dɔɔn ka duwa i yɛ sani n ye sa waati mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Jaa, Isiyaka ka mɛn fɔ a dencɛ Esawu yɛ, Rebeka tolo tɛrɛ ye wo bɛɛ la. Esawu bɔra ka wa sobo ɲinin diya wula kɔndɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka ka a fɔ a dencɛ Yakuba yɛ ko: «N da i fa kumakan mɛn. A ra a fɔ i kɔrɔcɛ Esawu yɛ ko: ");
INSERT INTO msc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹i ye na sobo ri. Ko suman mɛn duman n yɛ, ko i ye wo tibi ka a sii n kɔrɔ. Ko n di wo dɔɔn ka duwa i yɛ Allabatala ɲana sani n ye sa waati mɛn dɔ›.» ");
INSERT INTO msc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebeka ka a fɔ ko: «Nba, n dencɛ, i tolo malɔ. N ye mɛn fɔla i yɛ, i ye wo kɛ. ");
INSERT INTO msc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wa badenni ɲuma fila mira baa kuru rɔ ka na ii ri. Suman mɛn duman i fa yɛ, n di wo tibi. ");
INSERT INTO msc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","N ba ban wo tibila, i ri wa a di i fa ma. A ri wo dɔɔn ka duwa i yɛ sani a ye sa waati mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakuba ka a na jabi: «Kɔni i ka a lɔn ko n kɔrɔcɛ Esawu fari fan bɛɛ ye si le ri. Si don tɛ nde ma. ");
INSERT INTO msc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ni n fa ka a maa n na don? Ni wo kɛra, a ri n jate janfate ri. N tɛ duwa si sɔrɔn, fo danka.» ");
INSERT INTO msc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","A na ka a fɔ ko: «N dencɛ, Alla ye a kɛ danka wo kana i mira fo nde. N ka mɛn fɔ, i ye wo kɛ dɔrɔn. Wa bailu mira ka na ii ri.» ");
INSERT INTO msc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakuba wara baa fila mira ka na ii di a na ma. A na ka a fa diyanan tibili kɛ. ");
INSERT INTO msc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Esawu la faanin ɲuma tɛrɛ ye a na bolo bon na. Rebeka ka faanin wo ta ka wo don a dencɛ dɔɔmanni Yakuba bolo. A ka a bila a ma. ");
INSERT INTO msc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Rebeka ka badenni gbolo ta ka Yakuba bolokailu masidi. A ka a kan fanan masidi, si tun tɛ a fan mɛnilu ma. ");
INSERT INTO msc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","A ka suman tibini wo don Yakuba bolo, ka buru la a kan, a tun ka mɛn gbasi. ");
INSERT INTO msc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakuba wara wo ri a fa wara, ka a fa kili ko: «N fa.» Isiyaka ka a fɔ ko: «Naamun. N dencɛ ɲuman de kan?» ");
INSERT INTO msc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakuba ka a fa jabi: «I dencɛ fɔlɔ Esawu le kan. I ka mɛn fɔ n yɛ, n da wo kɛ. I wuli ka i sii ka n na sobo dɔɔn, sa i ri duwa n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isiyaka ka a fɔ a dencɛ yɛ ko: «Ɛɛ, n dencɛ! I ra kaliya. I ka sobo sɔrɔn jona di?» Yakuba ka a fɔ ko: «Allabatala, i Maari Alla, wo le ka n harijee fulɛn.» ");
INSERT INTO msc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isiyaka ka a fɔ ko: «N dencɛ, i madon n na yan. N ye n bolo maa i la ka a lɔn ni Esawu le ile ri.» ");
INSERT INTO msc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakuba ka a madon a fa la. A fa ka a maa a la ka a fɔ ko: «I kan bɔni Yakuba kan na, kɔni i boloilu ye Esawu boloilu le ri.» ");
INSERT INTO msc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isiyaka filira Yakuba ma, ka a masɔrɔn si tɛrɛ ye a boloilu ma ikomin Esawu boloilu tɛrɛ ye ɲa mɛn ma, wo bolo ma a duwara a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isiyaka ka Yakuba maɲininka ko: «Tuɲa le wa, ko n dencɛ Esawu le ile ri?» Yakuba ka a jabi «Nde le.» ");
INSERT INTO msc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isiyaka ka a fɔ ko: «Suman di n ma. N di i la sobo dɔɔn ka duwa i yɛ.» Yakuba ka suman sii a kɔrɔ. A ka dɔɔnnin kɛ. Yakuba nara rɛsɛnji fanan di. A ka wo min. ");
INSERT INTO msc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Isiyaka banda dɔɔnninna ka a fɔ a yɛ ko: «N den, i madon n na ka n sunbu.» ");
INSERT INTO msc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakuba ka a madon a la ka a sunbu. Isiyaka ka a la faanin suma mɛn tuma mɛn na, a ka a duwa a yɛ ko: «N dencɛ suma ye ikomin sɛnɛ suma duman ɲa mɛn ma, Allabatala ka baraka don sɛnɛ mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","N dencɛ, Alla ma i la sɛnɛkɛ duu ɲumaya ka sanci ɲuma lana a kan, Alla ma wo kɛra. Ka i la suman ni i la rɛsɛnji siyaya kosɛbɛ, Alla ma wo kɛra. ");
INSERT INTO msc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ka mɔɔilu bila i la fanka kɔrɔ, Alla ma wo kɛra. Ka siyailu lana ka ii majii i kɔrɔ, Alla ma wo kɛra. Ka i lasii i badenmailu kun na, Alla ma wo kɛra. Ka i na la den bɛɛ lana ka ii majii i kɔrɔ, Alla ma wo kɛra. Mɔɔ mɛn ba i danka, Alla ma tɔrɔya lara wo kan. Mɔɔ mɛn ba duwa i yɛ, Alla ma ɲumaya kɛra wo yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Nba, Isiyaka banni duwala Yakuba yɛ, Yakuba bɔra a fa tɔrɔfɛ. A ma mɛn bakɛ wo kɔ rɔ, a kɔrɔcɛ Esawu nara ka bɔ donsoya diya wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","A ka suman duman tibi, ka wa a di a fa ma. A ka a fɔ a fa yɛ ko: «N fa, i ye i wuli. I ye i dencɛ la sobo dɔɔn, ka duwa n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A fa ka a fɔ ko: «Yon de kan?» A ka a jabi: «Nde le kan, i dencɛ fɔlɔ Esawu.» ");
INSERT INTO msc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isiyaka yɛrɛyɛrɛra kojuuya. A ka a fɔ ko: «Yon wara sobo faa ka wo tibi ka na a sii n kɔrɔ? N ka wo dɔɔn ka duwa a tii yɛ sani i ye na. N da duwa a yɛ, n ti se wo yɛlɛmanna butun.» ");
INSERT INTO msc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nba, Esawu ka a fa la kuma wo mɛn tuma mɛn na, a jusu kasira. A kulera kojuuya ka a fɔ a fa yɛ ko: «N fa, i ye duwa n fanan yɛ!» ");
INSERT INTO msc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isiyaka ka a jabi: «I dɔɔcɛ le nara janfa rɔ ka i la duwawu sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu ka a fɔ ko: «Mɛn ka a tɔɔ la ko Yakuba, jo ye wo fɛ, baa a ra janfa don n ma siɲa fila. A tɔɔ bɛnni a ma fewu! A ka n na kɔrɔmamɔɔya mira n na ka wo kɛ a ta ri. A ra n na duwawu fanan ta. N fa, i ma duwa si bila n yɛ wa?» ");
INSERT INTO msc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isiyaka ka a jabi: «A ragbɛ! N da a lasii i kun na, ka a badenma tɔ bɛɛ kɛ a la baaraden di. N da suman ni rɛsɛnji siyaman baraka don a la ko rɔ. N dencɛ, n ye nfen kɛ i yɛ?» ");
INSERT INTO msc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu ka a fa madiya ikɔ tuun ko: «N fa, duwa kelen pe wo le tɛrɛn i bolo wa? I ye duwa n fanan yɛ.» Esawu kulera ka wɔyɔ ka kasi kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A fa ka a fɔ a yɛ ko: «Duu ɲuma ye yɔrɔ mɛn dɔ, sanci ɲuma ye na la a kan, i ri janya wo la. ");
INSERT INTO msc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","I ri i balo sɔrɔn i la fanmuru le la. I ri kɛ i dɔɔcɛ la baaraden de ri, kɔni i wa murunti tuma mɛn na, i ri i jɛrɛ bɔ a la fanka kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nba, Isiyaka ka duwawu mɛn kɛ Yakuba yɛ, wo kɛra sababu ri, Yakuba gboyara Esawu yɛ. Esawu ka a miri ko: «N fa la sa waati a ra sudunya. Ni a sara, an ba ban a su don na, n di n dɔɔcɛ Yakuba faa.» ");
INSERT INTO msc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Esawu miri tɛrɛ ye mɛn di, wo fɔra Rebeka yɛ. Wo rɔ, a ka a dencɛ Yakuba kili ka a fɔ a yɛ ko: «I tolo malɔ. A lɔɔ ye i kɔrɔcɛ Esawu la ka i faa ka a la mɔnɛ bɔ i rɔ. ");
INSERT INTO msc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","N den, i ye n kan mira ka a kɛ. I bori sisen ka wa n kɔrɔcɛ Laban wara Haran. ");
INSERT INTO msc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","I ye mɛn a wara ye dɔɔni, fɔɔ i kɔrɔcɛ jusu ye ban sumala. ");
INSERT INTO msc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","I kɔrɔcɛ la diminya ba mala, i ka mɛn kɛ a la, a ri ɲina wo kɔ rɔ. Wo ba kɛ, n di kela di i ma ko i ye na. Ni wo tɛ n kana bɔnɔ ai fila bɛɛ la ko rɔ lon kelen dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nba Rebeka ka a fɔ Isiyaka yɛ ko: «N kɔrɔ, Esawu ka Hɛtika sunkurun mɛnilu furu ɲin, woilu ra n sɛɛ kojuuya, fɔɔ ka dunuɲa lɔɔ bɔ n na. Ni Yakuba fanan ka Hɛtika sunkurun do ta, mɛn ye woilu ɲɔɔn di, wo ri n tɔrɔ wo ɲa jɛrɛ jɛrɛ ma. Saya ka fisa wo ri paaɔn!» ");
INSERT INTO msc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Wo rɔ, Isiyaka ka Yakuba kili ka duwa a yɛ, ka a fɔ a yɛ ko: «I kana muso ta Kanaan jamana denmusoilu rɔ de! ");
INSERT INTO msc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Wa i benba Betuwɛli wara Padami Aramu, ka i barincɛ Laban denmuso do furu. ");
INSERT INTO msc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Alla Sebɛɛtii ye baraka don i la ko rɔ ka i jiri ka i bɔnsɔn siyaya. Alla ye jama siyaman bɔ i rɔ. ");
INSERT INTO msc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Alla ka baraka mɛn kɛ i benba Iburahima la ko rɔ, a ye baraka wo ɲɔɔn kɛ i ni i bɔnsɔn na ko rɔ, kosa jamana ɲin di kɛ i ta ri, i yɔrɔ mɛn dɔ ɲin di i ye londan de ri haan bi, baa Alla ka jamana ɲin di Iburahima le ma.» ");
INSERT INTO msc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isiyaka ka Yakuba lawa Padani Aramu, ko a ye wa Laban wara, mɛn ye Aramu bɔnsɔn Betuwɛli dencɛ ri. Laban de Yakuba ni Esawu na Rebeka kɔrɔcɛ ri. ");
INSERT INTO msc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Nba, Esawu ka a yen ko Isiyaka ra duwa Yakuba yɛ ka a lawa Padani Aramu, ko a ye muso do ta ye. A ka a yen fanan ko a fa ra duwa Yakuba yɛ tuma mɛn na, a ka a fɔ a yɛ ko a kana muso ta Kanaan jamana denmusoilu rɔ de! ");
INSERT INTO msc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esawu ka a yen fanan ko Yakuba ka a fa ni a na kan mira ka wa Padani Aramu. ");
INSERT INTO msc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esawu ka a lɔn wo le rɔ ko Kanaan jamana sunkurun ma di a fa Isiyaka yɛ. ");
INSERT INTO msc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Wo rɔ, a wara Isumayila wara, mɛn ye Iburahima dencɛ ri. A ka wo denmuso do furu ka a la a musoilu kan. Sunkurun wo tɔɔ le ko Mahalati. A kɔrɔcɛ tɔɔ ko Nebayɔti. ");
INSERT INTO msc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nba, Yakuba bɔra Bɛri-Seba ka wa Haran. ");
INSERT INTO msc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A ye sila kan tuma mɛn na, a sera dinkira do rɔ ka si ye, baa su tun da ko a ma. A ka a la, ka kabakurun do ta ka a don a kun kɔrɔ a sunɔɔra. ");
INSERT INTO msc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ka a tɔ sunɔɔ rɔ a ka sankale do yen sibo rɔ. Wo lɔni duu ma, a kun seni fɔɔ bandakolo ma. Alla la mɛlɛkailu ye jii ni yɛlɛla sankale wo ma. ");
INSERT INTO msc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Allabatala jɛrɛ ka a fɔ ko: «Nde le Allabatala ri, i benba Iburahima ni i fa Isiyaka Maari Alla. I lani duu mɛn kan ɲin de, n di wo di i ni i bɔnsɔn ma. ");
INSERT INTO msc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","I bɔnsɔn di siyaya ikomin duukolo kiɲɛ, ka jɛnsɛn ka wa telebɔ ni telebe rɔ, ka wa tele kankan bolomaran ni tele kankan bolokinin dɔ. I ni i bɔnsɔn di kɛ sababu ri, siyailu bɛɛ di baraka sɔrɔn n bolo. ");
INSERT INTO msc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I tolo malɔ. N ye i fɛ tuma bɛɛ rɔ. I wa kɛ wa la yɔrɔ yɔrɔ rɔ, n di i latanka kojuu ma. N di i kɔsɛ ka i lana jamana ɲin dɔ ikɔ. N tɛ bɔ i fɛ haan n da n lahidi mafa, mɛn n da ta i yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakuba kunura sunɔɔ rɔ tuma mɛn na, a ka a fɔ ko: «Allabatala ye dinkira ɲin dɔ yan. N tun ma a lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakuba silanda. A ka a fɔ ko: «Dinkira masilannin de ɲin di de! Dinkira ɲin tɛ foyi di fo Alla la bon! Sankolo don dinkira ri tɛrɛn yan.» ");
INSERT INTO msc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakuba wulira sɔɔma da la jona. A tun ka kabakurun mɛn don a kun kɔrɔ, a ka wo ta ka a lalɔ ka a kɛ tɔɔmasere ri ka tulu mun a kan. ");
INSERT INTO msc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","A ka dinkira wo tɔɔ la ko Bɛtɛli. A tɔɔ fɔlɔ le tɛrɛ ko Lusi. ");
INSERT INTO msc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakuba ka dakan ta Alla yɛ ko: «Ni Alla tora n fɛ ka n natanka n na taama ɲin dɔ, ka suman ni fereyabɔ di n ma, ");
INSERT INTO msc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","sa n di n kɔsɛ hɛrɛ rɔ ka na n fa so la, ni i ka wo bɛɛ kɛ ten, Allabatala ri kɛ n Maari Alla ri. ");
INSERT INTO msc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","N da kabakurun mɛn nalɔ ka a kɛ tɔɔmasere ri yan, wo ri kɛ Alla la bon di. I wa fen fen di n ma, n di wo ja di i ma.» ");
INSERT INTO msc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakuba ka sila mira ka wa telebɔ jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A seni yɔrɔ do rɔ, a ka kɔlɔn do yen wula rɔ. Saa kuru sawa lani tɛrɛ kɔlɔn da la. Wo ye laminna kɔlɔn wo le rɔ. Kɔlɔn wo da tuunni kabakurun mɛn na, wo ka bon tɛrɛ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kolofen kɔnɔmadenilu ii wa ii la saa bɛɛ ladɛn tuma mɛn na, ii ri kabakurun makurukuru ka a labɔ kɔlɔn da la, ka saa ii lamin. Saa wa ban ii minna tuma mɛn na, ii ri kabakurun makurukuru ka kɔlɔn da latunun a la ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakuba ka kolofen kɔnɔmadenilu maɲininka ko: «N badenmailu, ai bɔni mi?» Ii ka a jabi: «An bɔni Haran de.» ");
INSERT INTO msc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakuba ka a fɔ ko: «Ai ka Laban lɔn wa, Nakɔri mamaren?» Ii ka a jabi: «An ka a lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakuba ka ii maɲininka ko: «Tana tɛ a la ye?» Ii ka a fɔ ko: «Tana si tɛ a la ye. I ma a denmuso Rasɛli yen? A natɔla a la saailu ri.» ");
INSERT INTO msc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakuba ka a fɔ ko: «Ai ɲa lɔ. Tele ka jan fɔlɔ, saailu ladɛn waati ma se fɔlɔ. Ai ye saailu lamin ka wa ii ri bin dɔɔn diya.» ");
INSERT INTO msc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kolofen kɔnɔmadenilu ka a jabi: «An ti se wo kɛla, fɔɔ saa bɛɛ wa ban nala fɔlɔ. Ii wa na, an di kabakurun makurukuru ka a bɔ kɔlɔn da la ka saailu lamin.» ");
INSERT INTO msc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakuba ye kumala kolofen kɔnɔmadenilu fɛ tuma mɛn na, Rasɛli nara a fa la saailu ri. Ale le tɛrɛ ii kɔnɔmaden de. ");
INSERT INTO msc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakuba ka a barincɛ Laban denmuso Rasɛli ni a la saailu yen tuma mɛn na, a wara kabakurun makurukuru ka a bɔ kɔlɔn da la, ka a barincɛ la saailu lamin. ");
INSERT INTO msc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakuba ka Rasɛli sunbu ka sɛwa kosɛbɛ fɔɔ ka kasi. ");
INSERT INTO msc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","A ka a fɔ Rasɛli yɛ ko: a ye a fa dɔɔmuso Rebeka den de ri. Rasɛli borimantɔ wara wo fɔ a fa yɛ. ");
INSERT INTO msc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ka a dɔɔmuso dencɛ Yakuba la ko mɛn tuma mɛn na, a ka a bori ka wa a kɔfɛ. A seni a tɔrɔfɛ, a ka a bolo mininminin a kan ma ka a sunbu, ka wa a ri lu ma. Yakuba ka dantɛɛli kɛ Laban yɛ. ");
INSERT INTO msc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ka kuma wo mɛn tuma mɛn na, a ka a jabi: «An bɛɛ ye buruju kelen de ri jɔ!» Yakuba ka karo kelen kɛ Laban tɔrɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lon do rɔ, Laban ka a fɔ Yakuba yɛ ko: «N badenma le i ri fewu, kɔni wo bɛɛ ni a ta, i ma kan ka baara kɛ n yɛ ni n ma i sara. I sara ka kan ka kɛ mɛn di, i ye wo fɔ n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Wo ka a tɛrɛn, denmuso fila ye Laban bolo. Kɔrɔmamɔɔ tɔɔ ko Leya. A dɔɔmuso tɔɔ ko Rasɛli. ");
INSERT INTO msc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya ɲakisɛ tɛrɛ ye kenɲi, kɔni Rasɛli kenɲi ɲa bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rasɛli diyara Yakuba yɛ kosɛbɛ. Wo rɔ, a ka Laban jabi: «N di san wɔrɔnwula kɛ baara la i yɛ yan, kosa i ri i denmuso filana Rasɛli di n ma.» ");
INSERT INTO msc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ka a fɔ ko: «N wa a di ile ma, wo ka fisa a dini ri mɔɔ gbɛrɛ ma. To n tɔrɔfɛ yan.» ");
INSERT INTO msc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Wo rɔ, Yakuba ka san wɔrɔnwula kɛ baara la Rasɛli sɔrɔn kanma, kɔni Rasɛli ladiyaɲɛ kosɔn san wɔrɔnwula wo kɛra a ɲana ikomin tele dando ");
INSERT INTO msc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","San wɔrɔnwula dafanin, Yakuba ka a fɔ Laban yɛ ko: «N muso di n ma sisen. Waati mɛn fɔni, wo ra dafa. N ye a fɛ an ye dɛn.» ");
INSERT INTO msc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nba, Laban ka a siiɲɔɔ bɛɛ kili ka tibili ba kɛ, ");
INSERT INTO msc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","kɔni su wo rɔ, a ka a denmuso Leya ta ka wa a di Yakuba ma. Yakuba ni Leya dɛnda. ");
INSERT INTO msc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban ka a la jɔnmuso do di Leya ma ka a kɛ a la jɔn di. Jɔnmuso wo tɔɔ ko Silipa. ");
INSERT INTO msc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Duusagbɛni, Yakuba ka Leya le yen ye! A wara a fɔ Laban yɛ ko: «I nɔ nfen de kɛla n na ɲin ten? N ka baara kɛ i yɛ Rasɛli le sɔrɔn ko rɔ. Nfenna i ra n janfa?» ");
INSERT INTO msc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ka a jabi: «Ka dɔɔmamɔɔ furu kɔrɔmuso ɲɛ, wo tɛ kɛla an wara yan. ");
INSERT INTO msc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","I sabari ka lɔɔkun ɲin dafa Leya la kɔɲɔ bon na. Wo wa tamin, n di Rasɛli fanan di i ma. Wo rɔ, i ri san wɔrɔnwula gbɛrɛ kɛ n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakuba sɔnda wo ma. A ka lɔɔkun wo dafa Leya fɛ. Wo taminni, Laban ka a denmuso Rasɛli fanan di a ma. ");
INSERT INTO msc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban ka a la jɔnmuso Bilaha di Rasɛli ma ka a kɛ a la jɔnmuso ri. ");
INSERT INTO msc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakuba ni Rasɛli dɛnda. Rasɛli diyara a yɛ ka tamin Leya kan. Yakuba ka san wɔrɔnwula kɛ baarala Laban yɛ ikɔ tuunni. ");
INSERT INTO msc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Allabatala ka a yen ko Leya ma duman Yakuba yɛ kosɛbɛ, tuma mɛn na, a ka den sɔrɔn nɔɔya Leya yɛ, kɔni Rasɛli tɛrɛ ye densɔrɔnbali le ri. ");
INSERT INTO msc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya ka kɔnɔ ta ka dencɛ sɔrɔn. A ka a fɔ ko: «Allabatala ra n na tɔrɔya yen. N di diya n cɛɛ yɛ sisen.» Wo le rɔ, a ka den tɔɔ la ko Rubɛn. ");
INSERT INTO msc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A ka kɔnɔ ta ikɔ tuunni ka dencɛ sɔrɔn. A ka a fɔ ko: «Allabatala ra a mɛn ko n ma duman n cɛɛ yɛ. Wo rɔ, a ra den ɲin fanan di n ma.» Wo le rɔ, a ka den wo tɔɔ la ko Simeyɔn. ");
INSERT INTO msc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leya ka kɔnɔ ta ikɔ tuunni ka dencɛ sɔrɔn. A ka a fɔ ko: «Sisen kɔni, n cɛɛ ri i fasa n ma, ka a masɔrɔn n da dencɛ sawa sɔrɔn a yɛ.» Wo le rɔ, a ka den wo tɔɔ la ko Lebi. ");
INSERT INTO msc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A ka kɔnɔ ta ikɔ tuunni ka dencɛ sɔrɔn. A ka a fɔ ko: «Sisen, n di Allabatala tando.» Wo le rɔ, a ka den wo tɔɔ la ko Yahuda. Wo kɔ, a ka den sɔrɔn madooya. ");
INSERT INTO msc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nba, Rasɛli ka a yen tuma mɛn na ko a ma den sɔrɔn Yakuba yɛ, a kɔrɔmuso la keleya ka a mira. A ka a fɔ Yakuba yɛ ko: «I ye den di n fanan ma. Ni wo tɛ n di faa.» ");
INSERT INTO msc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakuba jusu bɔra. A ka a fɔ a yɛ ko: «N ye Alla le ɲɔɔn jala wo rɔ wa? Ale le ma i lakanya den sɔrɔnna wa?» ");
INSERT INTO msc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rasɛli ka a fɔ ko: «Nba, n na jɔnmuso Bilaha ta, i ye si a fɛ, sa a ri den sɔrɔn n yɛ, sa n fanan di kɛ denbatii ri.» ");
INSERT INTO msc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Wo rɔ, Rasɛli ka a la jɔnmuso Bilaha di Yakuba ma, ka a kɛ a muso ri. Yakuba ni wo sira. ");
INSERT INTO msc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilaha ka kɔnɔ ta Yakuba la, ka dencɛ sɔrɔn a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rasɛli ka a fɔ ko: «Alla ra jo di n ma. N ka mɛn fɔ, a ra wo mɛn ka n sɔ dencɛ la.» Wo le rɔ, Rasɛli ka den wo tɔɔ la ko Daan. ");
INSERT INTO msc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rasɛli la jɔnmuso Bilaha ka kɔnɔ ta Yakuba la ikɔ, ka a dencɛ filana sɔrɔn a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rasɛli ka a fɔ ko: «Nde ni n kɔrɔmuso bilani tɛrɛ an ɲɔɔn na kojuuya. Sisen, n kɔnin da se a la.» Wo le rɔ, a ka den wo tɔɔ la Nafitali. ");
INSERT INTO msc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Nba, Leya ka a yen tuma mɛn na ko a tɛ kɔnɔ tala butun, a ka a la jɔnmuso Silipa ta ka a di Yakuba ma ka a kɛ a muso ri. ");
INSERT INTO msc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silipa ka kɔnɔ ta. A ka dencɛ sɔrɔn Yakuba yɛ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya ka a fɔ ko: «N da kunnadiya.» Wo le rɔ, a ka den wo tɔɔ la ko Kadi. ");
INSERT INTO msc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa ka kɔnɔ ta ikɔ tuunni. A ka a dencɛ filana sɔrɔn Yakuba yɛ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya ka a fɔ ko: «Ɛɛ, n da sɛwa kosɛbɛ. Musoilu ri a fɔ n ma sisen ko mɔɔ ɲalenni le n di.» Wo le rɔ, a ka den wo tɔɔ la ko Asɛri. ");
INSERT INTO msc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Suman ka waati, Rubɛn wara jiri lulu doilu tɛrɛn sɛnɛ rɔ. A ka lulu woilu bɔ ka na ii di a na ma. Rasɛli ka jiri lulu woilu yen Leya bolo tuma mɛn na, a ka a fɔ ko: «I jaandi, i ye n sɔ i dencɛ la ɲanman basi jiri lulu doilu rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kɔni Leya ka a jabi: «I ra n cɛɛ bɔ n bolo kɔni wo ma i wasa, ko di? I ri n dencɛ la ɲanman basi jiri lulu fanan bɔ n bolo wa?» Rasɛli ka a fɔ ko: «Ale le wo ri. Ni i ka n sɔ i dencɛ la ɲanman basi jiri lulu rɔ, n na cɛɛ Yakuba ri si i fɛ su ɲin dɔ.» Leya sɔnda wo ma. ");
INSERT INTO msc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Wura fɛ, Yakuba nara ka bɔ sɛnɛ rɔ. Leya ka i bori ka wa a kunbɛn, ka a fɔ a yɛ ko: «I sitɔ nde le wara bi. N da i sɔrɔn n dencɛ la ɲanman basi jiri lulu la.» Yakuba sira Leya fɛ su wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Alla tolo tɛrɛ ye Leya la tarali kan na. Wo rɔ, Leya ka kɔnɔ ta ka a dencɛ looluna sɔrɔn Yakuba yɛ. ");
INSERT INTO msc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya ka a fɔ ko: «Alla ra n sara ka a masɔrɔn n ka n na jɔnmuso di n cɛɛ ma.» Wo le rɔ, a ka dencɛ wo tɔɔ la ko Isakari. ");
INSERT INTO msc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya ka kɔnɔ ta ikɔ tuunni ka a dencɛ wɔɔrɔna sɔrɔn Yakuba yɛ. ");
INSERT INTO msc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","A ka a fɔ ko: «Alla ra ko ba kɛ n yɛ. N cɛɛ ri n bonya sisen, ka a masɔrɔn n da dencɛ wɔɔrɔ sɔrɔn a yɛ.» Wo le rɔ, a ka den wo tɔɔ la ko Sabulɔn. ");
INSERT INTO msc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Wo kɔ rɔ, a ka denmuso fanan sɔrɔn, ka wo tɔɔ la ko Dina. ");
INSERT INTO msc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nba, Alla hankili tora Rasɛli la ko kɔ, ka a la tarali kan namɛn, ka den ko nɔɔya a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Wo rɔ, a ka kɔnɔ ta ka dencɛ sɔrɔn. A ka a fɔ ko: «Alla ra maloya bɔ n na. ");
INSERT INTO msc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Allabatala ye dencɛ gbɛrɛ la ɲin kan.» Wo le rɔ, a ka den wo tɔɔ la ko Yusufu. ");
INSERT INTO msc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Nba, Rasɛli ka Yusufu sɔrɔn tuma mɛn na, Yakuba ka a fɔ Laban yɛ ko: «Sila di n ma. N ye n kɔsɛ n wara. ");
INSERT INTO msc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","I ye n musoilu ni n denilu di n ma. N ka baara kɛ i yɛ, woilu le la ko rɔ. I ye ii di n ma, sa n di wa. N da baara mɛn kɛ i yɛ, i jɛrɛ ka wo lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban ka a jabi: «N fa, i sabari. N da ɲaɲininnin kɛ ka a yen ko Allabatala ka baraka don n ko rɔ ile le la ko kosɔn. ");
INSERT INTO msc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Wo rɔ, i sara ka kan ka bɛn mɛn na, i ye wo fɔ n yɛ. N di wo di i ma.» ");
INSERT INTO msc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakuba ka a jabi: «Nde ka baara kɛ i yɛ ɲa mɛn ma, i jɛrɛ ka wo lɔn. I la kolofenilu siyayara ɲa mɛn ma nde bolo, i ka wo fanan lɔn. ");
INSERT INTO msc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","N nara kolofen mɛn tɛrɛn i bolo, woilu ma siya tɛrɛ, kɔni sisen, ii ra siyaya ka kɛ kolofen kuru ba ri. Allabatala ka baraka don i la ko rɔ nde le la ko kosɔn. Wo rɔ, n tɛ baara kɛ n jɛrɛ yɛ sisen, ka n na denbaya balo wa?» ");
INSERT INTO msc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban ka a fɔ ko: «N ye nfen di i ma ka a kɛ i sara ri?» Yakuba ka a jabi: «I kana foyi di nde ma, kɔni ni i ka ko kelen pe ɲin kɛ n yɛ, n di to yan ka i la saailu gbɛn ka ii kanda. ");
INSERT INTO msc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I ye diɲɛ, n ye wa i la kolofen bɛɛ kɔrɔsi bi. N wa kolofen finman mɛnilu yen, n di woilu bɔ a rɔ, a ni kolofen manɲɛɛnman. Woilu ri kɛ n sara ri. ");
INSERT INTO msc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Lon do natɔ, ni i ka n na kolofen kɔrɔsi i ri a lɔn ni n telenni wala n telenni tɛ. Ni i ka baa do yen n bolo, mɛn manɲɛɛnman tɛ, i ri a lɔn ko n da wo sonya ile ma. Ni i ka saa do yen n bolo, mɛn finni tɛ, i ri a lɔn ko n da wo sonya ile ma.» ");
INSERT INTO msc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ka a fɔ ko: «Ale le wo ri. I ka a fɔ ɲa mɛn ma, a ri kɛ wo ɲa ma.» ");
INSERT INTO msc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Wo lon kelen, Laban wara bakɔrɔn manɲɛɛnman ni bamuso manɲɛɛnman bɛɛ bɔ a la kolofenilu rɔ. Fen fen, ni gbɛ ye a rɔ, a ka wo bɛɛ bɔ ii rɔ. A ka saa finilu la woilu kan ka a bɛɛ karifa a dencɛilu la. ");
INSERT INTO msc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ii ka tele sawa taama kɛ kolofen woilu ri ka ii mabɔ Yakuba la fewu! Yakuba tora Laban na kolofenilu gbɛnna ka ii lakandan. ");
INSERT INTO msc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nba, Yakuba ka jiribolo kɛndɛ doilu tɛɛ jiri su sawa la, pepiliye, amande, a ni pilatani. A ka jiribolo kɛndɛ woilu fara doilu bɔ ii ma ka jiribolo woilu manɲɛɛn. ");
INSERT INTO msc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","A ka jiribolo kɛndɛ manɲɛɛnnin woilu bilabila bailu la jiminfen kɔndɔ, sa bailu wa na ii min diya, ii ri jiribolo manɲɛɛnnilu yen, baa bailu ye yɛlɛla i ɲɔɔn kan i min waati le. ");
INSERT INTO msc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ii wa yɛlɛ i ɲɔɔn kan jiribolo woilu ɲɛ, ii ri den manɲɛɛnilu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakuba ka saamusoilu bɔ kolofen tɔilu rɔ, ka ii bila Laban na saa manɲɛɛnilu ni finmanilu ɲakɔrɔ, sa ii ri Laban na saa woilu yen. Wo rɔ, Yakuba la saa woilu ka den manɲɛɛnman ni den finmanilu sɔrɔn. Wo bolo ma, Yakuba ka kolofen kuru sɔrɔn a jɛrɛ yɛ. A ma sɔn a ta ni Laban ta ye basan. ");
INSERT INTO msc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ni kolofen tɔlɔnninilu nara ka i min, Yakuba ri jiribolo manɲɛɛnilu bila jiminfen kɔndɔ ii ɲakɔrɔ. Wo rɔ, ii ri yɛlɛ i ɲɔɔn kan jiribolo dafɛ, ");
INSERT INTO msc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","kɔni ni kolofen baraninilu nara ka i min, Yakuba tɛ jiribolo bila jiminfen kɔndɔ ii ɲakɔrɔ. Wo bolo ma, kolofen baranin denilu kɛra Laban ta ri, kɔni kolofen tɔlɔnni denilu kɛra Yakuba ta ri. ");
INSERT INTO msc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nba, Yakuba kɛra fentii ri wo ɲa le ma. A ka kolofen mɛsɛn siyaman sɔrɔn. A ka jɔnilu ni jɔnmusoilu fanan sɔrɔn, a ni ɲɔɔmɛilu ni faliilu. ");
INSERT INTO msc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban dencɛilu tɛrɛ ye a fɔla ko: «Yakuba ra an fala nanfulu bɛɛ ta. A ra a jɛrɛ kɛ fentii ri wo rɔ an fa bolofen dɔ.» Wo kuma fɔra Yakuba yɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakuba ka Laban nakɔrɔsi ka a yen ko Laban tɛrɛ ye a mirila a ma ɲa mɛn ma fɔlɔ, a tɛ a mirila a ma wo ɲa ma butun. ");
INSERT INTO msc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lon do rɔ, Allabatala ka a fɔ Yakuba yɛ ko: «I kɔsɛ i fa so la, ka wa i badenmailu tɛma. N di to i fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Wo rɔ, Yakuba ka kela di Rasɛli ni Leya ma ko ii ye na a tɛrɛn wula kɔndɔ, a la kolofen ye yɔrɔ mɛn. ");
INSERT INTO msc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ii seni ye, Yakuba ka a fɔ ii yɛ ko: «N da a yen ai fa ɲa rɔ ko a tɛrɛ ye mirila n ma ɲa mɛn ma fɔlɔfɔlɔ, a tɛ mirila n ma wo ɲa ma butun, kɔni n fa Maari Alla ra to n fɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ai jɛrɛ ka a lɔn ko n da baara kɛ ai fa yɛ n fanka bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hali wo, ai fa ka n janfa, ka do bɔ n sara la ko tan, kɔni Alla ma sɔn a ye kojuu kɛ n na. ");
INSERT INTO msc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ni ai fa ka a fɔ ko finman ni gbɛman ye kolofen mɛnilu rɔ, ko woilu ri kɛ n sara ri, nba, kolofen bɛɛ ra kɛ finman ni gbɛman di. Ni a ka a fɔ ko kolofen mɛnilu manɲɛɛnnin, ko woilu ri kɛ n ta ri, nba, kolofen bɛɛ ri manɲɛɛn. ");
INSERT INTO msc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Alla le ka ai fa la kolofenilu bɔ a bolo ka ii di nde ma.» ");
INSERT INTO msc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yakuba ka a fɔ a musoilu yɛ ikɔ tuun ko: «Kolofen ye yɛlɛla i ɲɔɔn kan waati mɛn na, n sibora. N ka a yen sibo rɔ ko bakɔrɔn mɛnilu ye yɛlɛla baamusoilu kan, wo bɛɛ manɲɛɛnnin de. ");
INSERT INTO msc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Wo waati rɔ, Alla la mɛlɛka ka a fɔ n yɛ ko: ‹Yakuba.› N ka a fɔ ko: ‹Naamun.› ");
INSERT INTO msc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","A ka a fɔ ko: ‹Bakɔrɔn mɛnilu ye yɛlɛla bamusoilu kan, i ye woilu kɔrɔsi. A bɛɛ manɲɛɛnnin de. A ye wo ɲa le ka a masɔrɔn Laban ka fen fen kɛ i la, n ka wo bɛɛ yen.› ");
INSERT INTO msc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","A ka a fɔ ko: ‹Alla le nde ri, mɛn ka a jɛrɛ yiraka i la Bɛtɛli. I ka tulu mun kabakurun kan dinkira mɛn dɔ ka a kɛ tɔɔmasere ri, ka i dakan ta n yɛ. Nba, sisen, i wuli ka bɔ jamana ɲin dɔ, ka i kɔsɛ i fa so la.›» ");
INSERT INTO msc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rasɛli ni Leya ka a jabi: «An tɛ foyi sɔrɔnna yan an fa la cɛ rɔ a la saya kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","An fa jɛrɛ tɛ an jatela foyi ri sisen fo siya gbɛrɛ mɔɔ. A ra an san, ka an furu fen bɛɛ dɔɔnnin ka a ban.» ");
INSERT INTO msc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ii ka a fɔ ko: «Alla ra nanfulu mɛn bɛɛ mira an fa la ka a di i ma, an ta le wo bɛɛ ri, a ni an denilu. Nba, Alla ka mɛn fɔ i yɛ, i ye wo kɛ fasayi.» ");
INSERT INTO msc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Wo rɔ, Yakuba wulira ka a musoilu ni a denilu layɛlɛ ɲɔɔmɛilu kan, ka sila mira ka wa. ");
INSERT INTO msc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","A ka a la kolofen bɛɛ bila a ɲɛ ka wa a fa Isiyaka wara, Kanaan jamana rɔ. A ka a la kolofenilu ni a bolofen bɛɛ ta, a tun ka fen fen sɔrɔn Padani Aramu. ");
INSERT INTO msc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ii watɔla, Rasɛli ka a fa Laban na jooilu sonya ka wa ii ri a bolo. A ka woilu sonya a fa kɔ ma, baa Laban wani tɛrɛ a la saailu si mali diya. ");
INSERT INTO msc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakuba ka Aramu bɔnsɔn Laban janfa wo ɲa le ma. A ma a sara a la fo ka a dokon a ma ka wa. ");
INSERT INTO msc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A ka a bolofen bɛɛ ta ka a bori. A ka Efirati Ba tɛɛ, ka wa Kiliyadi koyinkɛ jamana fan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yakuba wa tele sawanan lon, a fɔra Laban yɛ ko Yakuba ra a bori. ");
INSERT INTO msc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban ka a badenmailu ladɛn ka wa Yakuba kɔ. Ii ka tele wɔrɔnwula kɛ a kɔsaranna. Ii ka Yakuba tɛrɛn Kiliyadi koyinkɛ yɔrɔ rɔ, ");
INSERT INTO msc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","kɔni sani ii ye i ɲɔɔn yen, Alla ka a jɛrɛ yiraka Aramu bɔnsɔn Laban na sibo rɔ, ka a fɔ a yɛ ko: «Laban, i ye a kɛ koɲuma. I kana Yakuba danka, i kana duwawu kɛ a yɛ!» ");
INSERT INTO msc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Nba, Laban wara Yakuba tɛrɛn tumana mɛn na, Yakuba tun da a la faaninbonilu lɔ koyinkɛ do le kan. Laban ni a badenmailu ka ii la faaninbonilu lɔ Kiliyadi koyinkɛilu kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban wara ka a fɔ Yakuba yɛ ko: «I ka nfen de ko kɛ n na ɲin ten? I ra janfa don n ma ka n denmusoilu ta ikomin jɔn ye mirala kɛlɛ rɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nfenna i ka i dooko n ma ka i bori? I ma i sara n na fo ka n janfa. Ni wo tɛ, n tun di tolon ba kɛ i yɛ. An tun di sɛwa ka donkilila, ka sɛsɛ fɔ, ka kora fɔ ka i bilasila. ");
INSERT INTO msc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hali ka n denmusoilu ni n mamarenilu kɔndɔn, i ma wo fɛrɛ di n ma. I na nfen nalonmaya ko kɛla ɲin di? ");
INSERT INTO msc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","An ye yɔrɔ mɛn dɔ ɲin, a se ye n yɛ ka kojuu kɛ i la, kɔni su taminni, i fa Maari Alla kumara n yɛ sibo rɔ. A ka a fɔ ko: ‹Laban, i ye a kɛ koɲuma. I kana Yakuba danka, i kana duwawu kɛ a yɛ.› ");
INSERT INTO msc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nba, n ka a lɔn ko i kunfani ba le tɛrɛ ka wa i fa so la, kɔni nfenna i ka n na jooilu sonya?» ");
INSERT INTO msc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakuba ka Laban jabi: «N ka n bori ka a masɔrɔn n silanni tɛrɛ i ɲɛ. A tɛrɛ ye n kɔndɔ ko i ri i denmusoilu bɔ n bolo fanka la ");
INSERT INTO msc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","kɔni i la jooilu ta fan fɛ, ni i ka woilu tɛrɛn mɔɔ mɛn bolo yan, wo tii ri faa de! An badenmailu siini yan ka kɛ an sereilu ri. Wa i ɲalankalan an na dinkira bɛɛ rɔ. Ni i ka i la fen do yen, i ye a ta.» Yakuba tun ma a lɔn ko Rasɛli le ka a fa Laban na jooilu sonya. ");
INSERT INTO msc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban wara a ɲalankalan Yakuba la faaninbon na, ka bɔ ye ka wa a ɲalankalan Leya la faaninbon na, ka bɔ ye ka wa a ɲalankalan jɔnmuso fila la faaninbonilu la. A ma fen si yen ye. A bɔra ye ka wa a ɲalankalan Rasɛli la faaninbon na. ");
INSERT INTO msc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Jaa, Rasɛli le tun ka a fa la jooilu dookoma ɲɔɔmɛ siifen kɔrɔ, ka a sii a kan. Laban ka a ɲalankalan fan bɛɛ rɔ bon na, kɔni a ma foyi yen. ");
INSERT INTO msc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rasɛli ka a fɔ a yɛ ko: «N fa, i ri hakɛ to. N ye n bolo kɛla ji rɔ karo la bi. Wo rɔ, n ti se n wulila.» Laban ka a la jooilu ɲinin fan bɛɛ rɔ, kɔni a ma ii yen. ");
INSERT INTO msc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Wo rɔ, Yakuba jusu bɔra Laban kanma fo ka a kɛlɛ lɔɔ tɛrɛ ye a la. A ka a fɔ a yɛ ko: «I ra n kɔsaran ten nfenna? N ka kojuu su ɲuman de kɛ i la? N ka hakɛ su ɲuman ta i la? ");
INSERT INTO msc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nba, i ra i ɲalankalan ka n bolofen bɛɛ mafɛnɛ sisen, i ka i la fen su ɲuman yen? I ka mɛn yen, wo labɔ an badenma bɛɛ ɲana yan, sa ii ri kititɛɛ an tɛma. ");
INSERT INTO msc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nde ka san muwan kɛ i wara. I la saamusoilu ni i la bamusoilu fen fen kɔnɔ ma tiɲan. N ma i la saaji si mafaa ka a dɔɔn. ");
INSERT INTO msc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Wara wa mɛn mira ka wo faa, n tɛ wo yiraka i la. N jɛrɛ ri wo ɲɔɔn sara. Mɛn wa sonya su rɔ, a ni mɛn wa sonya tele rɔ, i ri a fɔ ko n ye wa wo ɲɔɔn ɲinin. ");
INSERT INTO msc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tara gbara n na tele rɔ. Nɛnɛ ka n mira su rɔ. N ma se sunoola. ");
INSERT INTO msc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","N ka san muwan kɛ i wara. N ka san tan ni naanin kɛ baarala i yɛ i denmuso fila ko kosɔn. N ka san wɔɔrɔ kɛ baarala ka kolofen doilu sɔrɔn, kɔni i ka do bɔ n sara la siɲa tan. ");
INSERT INTO msc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","N benba Iburahima Maari Alla, n fa silanni Maari Alla mɛn yɛ kɔnin, ni wo tun ma kɛ n fɛ, sa i ra n bolokolon gbɛn a to, kɔni Alla ka n na tɔrɔya le yen. N ka baara mɛn kɛ, ale le ka wo lɔn. Wo le kosɔn, a ka kititɛɛ ile ni nde tɛ su taminni ɲin dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban ka Yakuba jabi: «Muso ɲin ye n denmusoilu le ri. Ii den ye n mamaren de ri. Kolofen ɲin ye n na kolofen de ri. I ɲayen fen fen na ɲin, n ta le wo bɛɛ ri, kɔni n ti se n denmusoilu ni n mamarenilu bɔla i bolo butun. ");
INSERT INTO msc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Wo rɔ, An ye teriya sidi an ni ɲɔɔn tɛma, sa sereya ri kɛ nde ni ile tɛma ka a yiraka ko jususuma ye to an tɛma.» ");
INSERT INTO msc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakuba ka kabakurun do ta ka a lalɔ ka a kɛ tɔɔmasere ri. ");
INSERT INTO msc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","A ka a fɔ a badenmailu yɛ ko: «Ai ye na kabakurun di.» Ii ka kabakurun ta ka a ton i ɲɔɔn kan. Wo kɛni, ii bɛɛ ka i ladɛn ka dɔɔnnin kɛ kabakurun ton tɔrɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban ka kabakurun ton wo tɔɔ la ko Sekari Sahaduta. Yakuba ka a tɔɔ la ko Kalɛdi. ");
INSERT INTO msc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban ka a fɔ ko: «Kabakurun ton mɛn ye sereya le ri nde ni ile tɛma bi.» Wo le kosɔn yɔrɔ wo tɔɔ lara ko Kalɛdi. ");
INSERT INTO msc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A ye kilila fanan ko Misipa, ka a masɔrɔn Laban ka a fɔ Yakuba yɛ ko: «An wa fara, Allabatala ye an fila bɛɛ kɔrɔsi. ");
INSERT INTO msc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ni i ka kojuu kɛ n denmusoilu la, ni i ka muso gbɛrɛilu ta, hali n ma ko lɔn a rɔ, Alla ɲayen an fila bɛɛ la. I kana ɲina wo kɔ rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban ka a fɔ Yakuba yɛ ko: «I ɲa lɔ kabakurun ton ɲin dɔ, ka i ɲa lɔ kabakurun ɲin dɔ, n ka mɛn lɔ ka a kɛ tɔɔmasere ri. ");
INSERT INTO msc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kabakurun ton ɲin di kɛ sereya ri. Kabakurun lɔni ɲin fanan di kɛ sereya ri. Wo rɔ, n kana tamin ii la ka wa i kɛlɛ. I fanan kana tamin ii la ka na n kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","I benba Iburahima ni n benba Nakɔri a ni ii failu Maari ri kititɛɛ nde ni ile tɛma.» Yakuba ka a kali Alla la, a fa Isiyaka silanni mɛn yɛ. ");
INSERT INTO msc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakuba ka kolofen do faa ka Alla sɔ wo rɔ koyinkɛ kan ye, ka a janin ka a badenma bɛɛ kili ko ii ye na dɔɔnnin kɛ. Ii ka dɔɔnnin kɛ ka si koyinkɛ kan ye. ");
INSERT INTO msc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wo sɔɔma da la jona, Laban wulira ka a denmusoilu ni a mamarenilu kɔndɔn ka duwa ii yɛ, ka ban ka sila mira ka a kɔsɛ a wara. ");
INSERT INTO msc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakuba ni a la mɔɔilu ka sila mira ka wa. Ii watɔla, Alla la mɛlɛka doilu nara bɛn Yakuba la. ");
INSERT INTO msc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","A ka ii yen waati mɛn na, a ka a fɔ ko: «Dinkira ɲin ye Alla la daa makɛ diya le ri.» Wo rɔ, a ka dinkira wo tɔɔ la ko Mahanimu. ");
INSERT INTO msc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakuba ka keladenilu lawa a ɲɛ a kɔrɔcɛ Esawu ma Seyiri la jamana rɔ, Edɔmu mara rɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","A ka ii kelaya ko: «Ai ye wa a fɔ n tii Esawu yɛ ko a la jɔncɛ Yakuba ka a fɔ ko n wani tɛrɛ Laban wara. Ko n tun da mɛn ye, kɔni sisen n da n kɔsɛ. ");
INSERT INTO msc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ko nisi ye n bolo, a ni fali, a ni saa, a ni baa, a ni jɔnilu ni jɔnmusoilu. Ko n ye kela la wala a ma, sa n na ko ri diya n tii Esawu yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Keladenilu wara kela wo fɔ Esawu yɛ. Ii ban mɛn kɛni kela fɔla, ii ka ii kɔsɛ Yakuba ma ka a fɔ a yɛ ko: «An wara i kɔrɔcɛ Esawu tɛrɛn ye. A natɔ i labɛnna. Cɛɛ kɛmɛ naanin ye a bolo.» ");
INSERT INTO msc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakuba silanda kojuuya fɔɔ ka a kɔnɔ rakaliya. A ka a la mɔɔilu ratala ka ii kɛ kuru fila ri, ka a la saa a ni ba a ni nisi a ni ɲɔɔmɛilu fanan datala wo ɲa ma. ");
INSERT INTO msc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A tɛrɛ ye a mirila ko: «Ni Esawu nara be kuru kelen kan, a tɔ kelen di i bori ka bɔ a bolo.» ");
INSERT INTO msc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","A ka Alla tara ko: «Ɛɛ Allabatala, n benba Iburahima ni n fa Isiyaka Maari, ile le ka a fɔ n yɛ ko n ye n kɔsɛ n fa so la, ka wa n badenmailu tɛma. I ka a fɔ ko i ri hɛrɛ kɛ n yɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","I la kaninteya ka bon nde ma. N ka Juridɛn Ba tɛɛ fɔlɔman, foyi tɛrɛ tɛ n bolo, fo n na taama gbeleke dɔrɔn, kɔni bi, n na mɔɔilu ra siyaya kosɛbɛ, fɔɔ ka kɛ kuru fila ri. ");
INSERT INTO msc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","I jaandi, i ye n bɔ n kɔrɔcɛ Esawu bolo. N silanni a ɲɛ. A kana na be n kan, ka n na denilu ni ii nailu faa. ");
INSERT INTO msc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I jɛrɛ le ka a fɔ ko i ri hɛrɛ kɛ n yɛ ka n bɔnsɔn siyaya ikomin kɔɔji kiɲɛ, mɔɔ tɛ wo mɛn dan lɔnna.» ");
INSERT INTO msc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yakuba banda Alla matarala ka su si dinkira wo rɔ. A ka a la kolofen doilu ɲenematɔmɔn, ka ii sanba a kɔrɔcɛ Esawu ma. ");
INSERT INTO msc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","A ka bamuso kɛmɛ fila ni bakɔrɔn muwan bɔ, ka saamuso kɛmɛ fila ni saaji muwan la woilu kan. ");
INSERT INTO msc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","A ka ɲɔɔmɛmuso bisawa ni woilu sinmindenilu fanan bɔ. Ka la woilu bɛɛ kan, a ka nisimuso binaanin ni tora tan fanan bɔ, a ni falimuso muwan ni falicɛ tan. ");
INSERT INTO msc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","A ka kolofen woilu kɛ kuru doilu ri, bɛɛ ni a ta. A ka kuru kelen kelenna bɛɛ karifa a la jɔn kelen kelenna la. A ka a fɔ ii yɛ ko: «Ii ye wa n ɲɛ, ka tɛɛ ladon kolofen kuruilu tɛma.» ");
INSERT INTO msc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","A ka a fɔ jɔn fɔlɔ yɛ ko: «I wa n kɔrɔcɛ Esawu yen, a ri i maɲininka ko: ‹I tii ye yon di? I watɔ mi ten? Kolofen ɲinilu ye yon ta ri?› ");
INSERT INTO msc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A wa ɲininkali kɛ ten, i ye a jabi: ‹I la jɔncɛ Yakuba ta le. A ka ii lana ile le ma, ko ka a tii Esawu sanba. A jɛrɛ natɔ kɔfɛ.›» ");
INSERT INTO msc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yakuba ka kuma kelen wo fɔ jɔn filana yɛ, a ni jɔn sawanan, a ni a tɔ bɛɛ, kolofen kuruilu karifani mɛnilu la. A ka a fɔ ii yɛ ko: «Ai wa n kɔrɔcɛ Esawu yen, ai ye jabili kelen wo di a ma. ");
INSERT INTO msc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ai ye a fɔ a yɛ fanan ko a la jɔncɛ Yakuba natɔ le ɲin di.» Yakuba ye a mirila ko: «Ni n ka a ladiya kolofenilu la fɔlɔ, a jusu ri suma. Wo rɔ, an wa an ɲɔɔn yen, n na ko ri diya a yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nba, Yakuba ka sanba fen woilu lawa a ɲɛ, kɔni ale jɛrɛ ka su si dinkira wo rɔ ye. ");
INSERT INTO msc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Su kelen wo rɔ, Yakuba wulira. A ka a muso fila ni a la jɔnmuso fila, a ni a dencɛ tan ni kelen, natamin Jabɔki ba kɔma. ");
INSERT INTO msc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","A ka ii latamin ba kɔ, ka ban ka a bolofenilu bɛɛ fanan natamin. ");
INSERT INTO msc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yakuba kelen pe tora ba fan kelen wo fɛ. Su wo rɔ, cɛɛ do nara be Yakuba kan. Ii ka sɛɛdon fɔɔ ka kɛnɛ bɔ. ");
INSERT INTO msc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Cɛɛ wo ka a yen ko a ti na lasela Yakuba la waati mɛn na, a ka Yakuba gbasi a worokudu rɔ. Wo rɔ, Yakuba woro kolo mukara. ");
INSERT INTO msc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Cɛɛ ka a fɔ ko: «I ye n bila. Kɛnɛ bɔtɔ le.» Yakuba ka a jabi: «N tɛ! Ni i ma baraka don n dɔ, n tɛ i bila fewu!» ");
INSERT INTO msc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Cɛɛ ka a fɔ ko: «I tɔɔ di?» A ka a jabi: «N tɔɔ le Yakuba.» ");
INSERT INTO msc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Cɛɛ ka a fɔ ko: «I tɔɔ tɛ wo ri butun. I tɔɔ le sisen ko Isirayɛli, ka a masɔrɔn i ni Alla ra sɛɛdon, i ni mɔɔilu ra sɛɛdon, wo bɛɛ rɔ fanka ye i bolo.» ");
INSERT INTO msc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakuba ka a fɔ a yɛ ko: «I jaandi, i tɔɔ fɔ n yɛ.» Cɛɛ ka a fɔ ko: «Nfenna i ye n tɔɔ maɲininkala?» A ka baraka don Yakuba la ko rɔ. ");
INSERT INTO msc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yakuba ka wo dinkira tɔɔ la ko Penuyɛli. Wo kɔrɔ le ko: «N da Alla yen ɲa ni ɲa, kɔni n ma faa.» ");
INSERT INTO msc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yakuba bɔra Penuyɛli telebɔ waati. A tɛrɛ ye taamala ka jii a sen kelen ma ka a masɔrɔn a sen da muka. ");
INSERT INTO msc_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Nba, Yakuba gbasira a worokudu le rɔ wo ɲa le ma. Wo le ka a kɛ, Isirayɛlika tɛ kolofen worokudu fasa dɔɔnna, haan bi. ");
INSERT INTO msc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nba, Yakuba ka a ɲa lɔ ka Esawu natɔla yen. Cɛɛ mɔɔ kɛmɛ naanin ye a kɔfɛ. Wo rɔ, Yakuba ka a denilu ratala Rasɛli ni Leya tɛma, a ni jɔnmuso fila tɛma, bɛɛ ni a na. ");
INSERT INTO msc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","A ka jɔnmusoilu ni ii den bila ɲɛfɛ, ka Leya ni a denilu tuun woilu la, ka Rasɛli ni Yusufu bila kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","A jɛrɛ taminda ɲɛfɛ. A wara ka i majii bakɛ siɲa wɔrɔnwula, ka i madon a kɔrɔcɛ Esawu la. ");
INSERT INTO msc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esawu ka i bori ka na a labɛn. A ka a to a kan ka a sunbu. Ii fila bɛɛ kasira. ");
INSERT INTO msc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esawu ka a ɲa lɔ ka Yakuba musoilu ni a denilu yen. A ka a fɔ ko: «Mɛnilu nani i fɛ ɲin di, yon de woilu ri?» Yakuba ka a fɔ ko: «N tii, Alla ra a ɲumaya yiraka n ma ka den mɛnilu di n ma, woilu le ten.» ");
INSERT INTO msc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Jɔnmusoilu ni ii deni ka ai madon ka ai majii ka a fo. ");
INSERT INTO msc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya ni a denilu fanan nara ka ii majii. A laban, Rasɛli ni Yusufu nara ka ii majii. ");
INSERT INTO msc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esawu ka Yakuba maɲininka ko: «N bɛnda kolofen kuru siyaman di. Wo kɔrɔ ye nfen di?» Yakuba ka a jabi: «N tii, n ka ii lawa i ma, kosa n na ko ri diya i yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu ka a fɔ ko: «N doo, fen siyaman ye nde fanan bolo. I bolofenilu ye to i bolo.» ");
INSERT INTO msc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kɔni Yakuba ka a fɔ ko: «I jaandi. Ni n na ko ra diya i yɛ, i ye woilu mira. N ɲa la i kan sisen, wo le ikomin n da n ɲa la Alla kan ka a masɔrɔn i ra n damira koɲuma. ");
INSERT INTO msc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","I jaandi. N ka i sanba fen mɛnilu la, i sabari ka woilu mira. Alla ra ɲumaya kɛ n ma. N bolofen ka siya, n dɛsɛni tɛ foyi la.» Yakuba ka wo magbɛlɛya kosɛbɛ fɔɔ Esawu diɲɛra wo ma. ");
INSERT INTO msc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esawu ka a fɔ a yɛ ko: «An ye wa. N di wa i malɔ.» ");
INSERT INTO msc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakuba ka a jabi: «N tii, i jɛrɛ ka a lɔn ko denilu la ko ka gbɛlɛn. Fanka tɛ ii la. Kolofenilu ni ii sinmindenilu ye n bolo fanan. N kana ɲina woilu kɔ. Ni n ka taama lakaliya tele kelen kɔrɔ dɔrɔn, wo tɛ bɛn. Kolofenilu ri faa. ");
INSERT INTO msc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","N tii, i ye wa n ɲɛ sisen. N di wa dɔɔni dɔɔni, ka bɛn kolofenilu ni denilu taama ɲa ma. N di i tɛrɛn Seyiri la jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu ka a fɔ ko: «Ale le wo ri. N na mɔɔ doilu ri to n kɔ ka i malɔ.» Yakuba ka a fɔ ko: «N tii, i kana i jɛrɛ tɔrɔ butun. Ni n diyara i yɛ, wo ri n wasa.» ");
INSERT INTO msc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Wo rɔ, Esawu ka sila mira wo lon kelen ka wa Seyiri la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kɔni Yakuba wara Sukɔti. A ka a la bon lɔ ye, ka gba lɔ a la kolofenilu yɛ. Wo le kosɔn, ii ka dinkira wo tɔɔ la ko Sukɔti. ");
INSERT INTO msc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakuba bɔra Padani Aramu ka wa. A ɲuma donda Sɛkɛmu so kɔndɔ, mɛn ye Kanaan jamana rɔ. A seni ye, a ka a la faaninbon lɔ so kɔkan. ");
INSERT INTO msc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","A la faaninbon lɔni dinkira mɛn, a ka wo dinkira san Sɛkɛmu fa Hamɔri bɔnsɔn de ma. A ka a san wodigbɛ kɛmɛ le la. ");
INSERT INTO msc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","A ka Alla saraka janin diya lɔ dinkira wo rɔ, ka wo tɔɔ la ko Alla ye Isirayɛli Maari le ri. ");
INSERT INTO msc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Nba, Leya ka denmuso mɛn sɔrɔn Yakuba yɛ, wo tɔɔ le tɛrɛ ko Dina. Lon do rɔ, Dina wara bɔ diya sunkurunilu fɛ so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kanberen do tɛrɛ ye, mɛn tɔɔ ko Sɛkɛmu. Wo fa le Hifika Hamɔri ri, mɛn ye jamanatiiya la. Sɛkɛmu ka Dina yen waati mɛn na, a ka a mira fanka la ka a la a fɛ ka a ratiɲan. ");
INSERT INTO msc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Yakuba denmuso Dina diyara Sɛkɛmu yɛ kosɛbɛ. A ka a kanin. Wo rɔ, Sɛkɛmu kumara a yɛ koɲuma, kosa a la ko ri diya sunkurun yɛ. ");
INSERT INTO msc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sɛkɛmu ka a fɔ a fa Hamɔri yɛ ko: «I ye sunkurun ɲin furu n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","A fɔra Yakuba yɛ ko Sɛkɛmu ra a denmuso ratiɲan. Wo tuma, a dencɛilu ye kolofen dafɛ wula kɔndɔ. Wo rɔ, Yakuba ma foyi fɔ fo ka ii makɔnɔ. ");
INSERT INTO msc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sɛkɛmu fa Hamɔri nara bɔ Yakuba fɛ, ka na kuma a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakuba dencɛilu nara ka bɔ wula kɔndɔ. A fɔra ii yɛ tuma mɛn na ko Sɛkɛmu ra ii dɔɔmuso ratiɲan, ii dunyara ka mɔnɛ kojuuya, baa Sɛkɛmu na mɛn kɛla, kojuu ba le wo ri Isirayɛli la mɔɔilu wara. Mɔɔ tɛ wo kɛla muumɛ! ");
INSERT INTO msc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamɔri ka a fɔ Yakuba yɛ ko: «I denmuso duman n dencɛ Sɛkɛmu yɛ kosɛbɛ. N ye ai madiyala, ai ye a di n ma, a ye kɛ a muso ri. ");
INSERT INTO msc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","An ye kɛ furuɲɔɔnmailu ri. Ai ye ai denmusoilu di an ma. An fanan di an denmusoilu di ai ma. ");
INSERT INTO msc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ai di to an fɛ an wara yan. Jamana bɛɛ labilani ai yɛ. Ai ye i sii yan ka a julaya kɛ. Ai ye duu san ka a kɛ ai ta ri.» ");
INSERT INTO msc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sɛkɛmu ka a fɔ Dina fa ni a kɔrɔcɛilu yɛ ko: «Ai jaandi, ai ye hina n na. Ai ye diɲɛ n yɛ. Ai wa fen fen ɲinin n fɛ, n di wo bɔ ka a di ai ma. ");
INSERT INTO msc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ai ye furu nanfulu ba ni wodi siyaman fɔ. N di wo bɛɛ bɔ ikomin ai ka a fɔ ɲa mɛn ma, sa ai ri denmuso di n ma ka a kɛ n muso ri.» ");
INSERT INTO msc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ikomin Sɛkɛmu tun da ban ii dɔɔmuso ratiɲanna, Yakuba dencɛilu ka Sɛkɛmu ni a fa Hamɔri jabi janfa kuma la. ");
INSERT INTO msc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ii ka a fɔ ko: «Ka an dɔɔmuso di kojiibali ma, wo tɛ bɛn. Maloya ko ba le wo ri an wara. ");
INSERT INTO msc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","An tɛ sɔn wo ma fɔɔ ai cɛman bɛɛ ye a wara fɔɔ wo bɛɛ wa faaninta kɛ ikomin an bɛɛ faaninta kɛni ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ni wo kɛra, an di an denmusoilu di ai ma. An fanan di ai denmusoilu furu. An di an sii ai tɛma yan ka kɛ mɔɔ kelen di. ");
INSERT INTO msc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ni ai kɔnin ma sɔn faaninta kɛ ko ma, an di an denmuso mira ka wa a ri.» ");
INSERT INTO msc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kuma wo diyara Hamɔri ni a dencɛ Sɛkɛmu yɛ. ");
INSERT INTO msc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sɛkɛmu bɔra ye i kɔrɔ ka wa ko wo rabɛn, baa Yakuba denmuso duman a yɛ kosɛbɛ. Sɛkɛmu wo bonyani tɛrɛ ka tamin mɔɔ bɛɛ kan a fa wara. ");
INSERT INTO msc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamɔri ni a dencɛ Sɛkɛmu wara ladɛn diya so donda la ka kuma so kɔndɔ mɔɔilu yɛ. ");
INSERT INTO msc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ii ka a fɔ ko: «Mɔɔ mɛn ye an duɲɔɔnilu le ri. An ye diɲɛ ii ye to an na jamana kɔndɔ ka julaya kɛ an na jamana rɔ, baa an na jamana ka bon, an bɛɛ ri kun a kɔndɔ. An di ii denmusoilu furu ka an denmusoilu di ii ma. ");
INSERT INTO msc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kɔni ko do ye an tɛma. Ni cɛɛ bɛɛ ma sɔn ka faaninta kɛ, ikomin ii bɛɛ faaninta kɛni ɲa mɛn ma, ii tɛ sɔn ka ii sii an tɛma ka an kɛ mɔɔ kelen di. ");
INSERT INTO msc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ni ii ka ii sii an tɛma yan, ii la kolofen ni ii bolofen bɛɛ tɛ kɛ an ta ri wa? An ye sɔn faaninta kɛ ko wo ma, sa ii ri to an tɛma yan.» ");
INSERT INTO msc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","So kɔndɔ mɔɔilu bɛɛ sɔnda Hamɔri ni a dencɛ Sɛkɛmu la kuma wo ma. Wo rɔ, cɛɛ mɛnilu tɛrɛ ye so kɔndɔ, wo bɛɛ faanintara. ");
INSERT INTO msc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Nba, ii la faaninta kɛ tele sawana lon, ka dimin to ii kan, Yakuba dencɛ fila, Simeyɔn ni Lebi kɔnin, mɛnilu ni Dina ye fa kelen ni na kelen na, woilu ka ii la fanmuruilu ta ka na be so kɔndɔ mɔɔilu kan, mɔɔilu mɛn hankili tɛ kɛlɛ wo ma. Ii nara don so kɔndɔ mɔɔilu ɲɛnama, ka cɛɛilu bɛɛ faa. ");
INSERT INTO msc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ii ka Hamɔri ni a dencɛ Sɛkɛmu fanan faa fanmuru la, ka ii dɔɔmuso Dina ta Sɛkɛmu la bon na ka wa a ri. ");
INSERT INTO msc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yakuba dencɛ tɔilu nara fureilu lani tɛrɛn ye tuma mɛn na, ii ka so kɔndɔ mɔɔilu bolofen bɛɛ ta, ka a masɔrɔn Sikɛmu ka ii dɔɔmuso ratiɲan. ");
INSERT INTO msc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ii ka saa ni baa ni nisi ni faliilu ta. Ii ka fen mɛnilu yen so kɔndɔ a ni sɛnɛilu rɔ, ii ka wo bɛɛ ta. ");
INSERT INTO msc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ii ka nanfulu bɛɛ mira, ka musoilu ni denilu bɛɛ mira. Fen fen tɛrɛ ye bon na so kɔndɔ, ii wara wo bɛɛ ri. ");
INSERT INTO msc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakuba ka a fɔ Simeyɔn ni Lebi yɛ ko: «Ai ka mɛn kɛ ɲin di, wo ri kɛ ko ba ri n kun na. Ai ra n gboya yan mɔɔilu yɛ, Kanaanka ni Peresikailu kɔnin. N na mɔɔilu ma siya. Ni yan mɔɔilu ka ii ladɛn ka be an kan, n ni n na denbaya bɛɛ ri faa.» ");
INSERT INTO msc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ii ka a jabi: «A ka an dɔɔmuso jate ikomin sunkurunba. Wo bɛnni wa?» ");
INSERT INTO msc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Lon do rɔ, Alla ka a fɔ Yakuba yɛ ko: «I ye wa i sii Bɛtɛli. I wa se ye, i ye saraka janin diya do lɔ Alla yɛ, mɛn ka a jɛrɛ yiraka i la wo lon ka a tɛrɛn i boritɔ i kɔrɔcɛ Esawu kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Wo rɔ, Yakuba ka a fɔ a la denbaya ni a la mɔɔilu bɛɛ yɛ ko: «Joo mɛnilu ye ai bolo, ai ye wo bɛɛ lafili. Ai ye ai jɛrɛ sɛninya, ka ai la faanin sɛnimanilu bila ai kan na. ");
INSERT INTO msc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","An bɔtɔ yan ka wa Bɛtɛli. N watɔ saraka janin diya do lɔla Alla yɛ ye, mɛn ka n na tarali lamɛn ka n dɛmɛn n na tɔrɔya waati rɔ. A ra to n fɛ n na taama bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Joo mɛnilu tɛrɛ ye ii bolo, ii nara wo bɛɛ di Yakuba ma, a ni tololafen mɛnilu tɛrɛ ye ii tolo la. Yakuba ka denka sen jiriju ba do kɔrɔ Sɛkɛmu so dafɛ, ka wo fen bɛɛ dokon. ");
INSERT INTO msc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ii wulira ka wa tuma mɛn na, Alla ka silan ba bila ye mɔɔilu la so bɛɛ kɔndɔ. Wo le ka a kɛ, mɔɔ si ma bɔ ka bila Yakuba ni a dencɛilu kɔ. ");
INSERT INTO msc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakuba ni a la mɔɔilu sera Lusi, so mɛn tɔɔ bi ko Bɛtɛli. Wo ye Kanaan jamana le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakuba ka saraka janin diya lɔ Alla yɛ ye, ka a tɔɔ la ko: «Bɛtɛli la Alla,» baa a ka a bori a kɔrɔcɛ Esawu kɔrɔ tuma mɛn na, Alla ka a jɛrɛ yiraka a la dinkira wo le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Wo tuma, Debora sara, mɛn tun ka Rebeka lamɔ. Ii ka wo su don jiriju do kɔrɔ Bɛtɛli so dafɛ, ka jiri wo tɔɔ la ko An Ye Kasila Jiri Ɲin Kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakuba nara Bɛtɛli ka bɔ Padani Aramu tuma mɛn na, Alla ka a jɛrɛ yiraka a la ikɔ tuunni, ka kuma ka baraka don a la ko rɔ. ");
INSERT INTO msc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Alla ka a fɔ a yɛ ko: «I tɔɔ le tɛrɛ ko Yakuba, kɔni i tɔɔ tɛ ten butun ko Yakuba. I tɔɔ le sisen ko Isirayɛli.» Alla ka a tɔɔ la ko Isirayɛli wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Alla ka a fɔ a yɛ ikɔ tuunni ko: «Alla Sebɛɛtii le nde ri. I ye jiri ka siyaya. Jamana siyaman di bɔ i rɔ. I bɔnsɔn doilu ri kɛ mansailu ri. ");
INSERT INTO msc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","N ka duu mɛn di Iburahima ni Isiyaka ma, n di wo di i ma. I bɔnsɔn mɛnilu natɔ i kɔ, n di a di woilu fanan ma.» ");
INSERT INTO msc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Alla kumara Yakuba yɛ dinkira mɛn na, a wara. ");
INSERT INTO msc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakuba ka tɔɔmasere kabakurun do lɔ dinkira wo rɔ, Alla kumara a yɛ dinkira mɛn dɔ kɔnin. A ka rɛsɛnji labɔn kabakurun wo kan, ka Alla sɔ wo rɔ. A ka tulu fanan nabɔn a kan. ");
INSERT INTO msc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Alla kumara a yɛ dinkira mɛn na, Yakuba ka wo dinkira tɔɔ la ko Bɛtɛli. ");
INSERT INTO msc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ii bɔra Bɛtɛli ka wa. Ii tun ma sudunya Efirata la tuma mɛn na, Rasɛli moyi lon sera. A la tin gbɛlɛyara kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A ye tin kan tuma mɛn na, tinkɔrɔsilali ka a fɔ a yɛ ko: «I kana silan, i ra dencɛ kura sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kɔni Rasɛli ma bɔ a rɔ. A satɔla ka a den tɔɔ la ko Bɛnoni. A sanin kɔrɔ, Yakuba ka den tɔɔ la ko Bɛniyaminu. ");
INSERT INTO msc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nba, Rasɛli sara. Ii ka a su don Efirata sila da la. Efirata wo tɔɔ le bi ko Bɛtilɛhɛmu. ");
INSERT INTO msc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakuba ka tɔɔmasere kabakurun do lɔ Rasɛli kaburu kan. Kabakurun wo lɔni ye haan bi. ");
INSERT INTO msc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isirayɛli ni a la mɔɔilu bɔra ye ka wa ai la faaninbonilu lɔ Mikidali Edɛri kɔma. ");
INSERT INTO msc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ai siini ye tuma mɛn na, Rubɛn ka i la Bilaha fɛ, mɛn ye a fa Isirayɛli jɔn muso do ri. Rubɛn ka mɛn kɛ, wo fɔra a fa Isirayɛli yɛ. Yakuba dencɛilu tɛrɛ mɔɔ tan ni fila le ri. ");
INSERT INTO msc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya ka Rubɛn de fɔlɔ sɔrɔn, ka Simeyɔn tuun wo la, ka Lebi tuun wo la, ka Yahuda tuun wo la, ka Isakari tuun wo la, ka Sabulɔn tuun wo la. Rubɛn tɛrɛ Yakuba den fɔlɔ le ri. ");
INSERT INTO msc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rasɛli dencɛilu tɛrɛ ye Yusufu ni Bɛniyaminu ri. ");
INSERT INTO msc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rasɛli la jɔnmuso Bilaha ka Daan ni Nafitali sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leya la jɔnmuso Silipa ka Kadi ni Asɛri sɔrɔn. Nba, woilu le Yakuba dencɛilu le ri, a musoilu ka mɛn sɔrɔn a yɛ Padani Aramu. ");
INSERT INTO msc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nba, Yakuba sera a fa Isiyaka wara Mamere, Kiriyati Ariba so da la. Bi, mɔɔilu ye a fɔla Kiriyati Ariba le ma ko Heburɔn. Iburahima siini tɛrɛ dinkira wo le rɔ. Isiyaka fanan siini tɛrɛ ye le. ");
INSERT INTO msc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isiyaka sɔrɔn ka san kɛmɛ ni san biseyin bɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","a sara ka la a benbailu kan. A kɔrɔra ka a la kɔrɔya diya bɔ. A dencɛ fila Esawu ni Yakuba ka a su don. ");
INSERT INTO msc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esawu bɔnsɔn de ɲin di. Mɔɔilu ye a fɔla Esawu le ma ko Edɔmu. ");
INSERT INTO msc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu ka Kanaan jamana sunkurun doilu furu. Do tɔɔ ko Ada, mɛn tɛrɛ Hɛtika Elɔn denmuso le ri. Do fanan tɔɔ ko Olibama, mɛn tɛrɛ Ana denmuso le ri. A benba tɛrɛ Hifi do le ri, mɛn tɔɔ ko Sibeyɔn. ");
INSERT INTO msc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esawu ka Basimati fanan furu, Isumayila denmuso kɔnin. Basimati kɔrɔcɛ tɔɔ ko Nebayɔti. ");
INSERT INTO msc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ka Elifasi sɔrɔn Esawu yɛ. Basimati ka Rewɛli sɔrɔn a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama ka Jɛwusi ni Jalamu ni Kora sɔrɔn. Esawu dencɛilu le woilu ri, a musoilu ka mɛnilu sɔrɔn a yɛ Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Nba, lon do rɔ, Esawu wara jamana gbɛrɛ rɔ ka a mabɔ a dɔɔcɛ Yakuba la. A ka a musoilu ta, a ni a dencɛilu ni a denmusoilu a ni a la mɔɔ tɔilu bɛɛ. A ka a la kolofen ni a bolofen fanan bɛɛ ta, a tun ka mɛn bɛɛ sɔrɔn Kanaan jamana rɔ. A ka wo bɛɛ mira ka wa yɔrɔ gbɛrɛ rɔ, ");
INSERT INTO msc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","baa a ni a dɔɔcɛ Yakuba bolofenilu ka siya tɛrɛ kosɛbɛ. Wo kɛra sababu ri ii fila ma se tola i ɲɔɔn kan yɔrɔ kelen dɔ. Ii siini tɛrɛ jamana mɛn dɔ, wo dɔɔman tɛrɛ ii fila bolo ka a masɔrɔn ii la kolofenilu wara kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Wo rɔ, Esawu bɔra ye ka wa i sii koyinkɛ ma yɔrɔ do rɔ, Seyiri la jamana rɔ. Mɔɔilu ye a fɔla Esawu ma ko Edɔmu. ");
INSERT INTO msc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esawu le kɛra Edɔmukailu bɛɛ benba ri, mɛnilu siini Seyiri la koyinkɛ ma jamana rɔ. A bɔnsɔn de ɲin di. ");
INSERT INTO msc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esawu dencɛilu le ten: Elifasi, Esawu muso Ada dencɛ. Rewɛli, Esawu muso Basimati dencɛ. ");
INSERT INTO msc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Esawu dencɛ Elifasi dencɛilu le ten: Teman, Omar, Sefo, Katamu a ni Kenasi. ");
INSERT INTO msc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esawu dencɛ Elifasi ka jɔn muso do fanan ta. Wo tɔɔ ko Timina. Ale le ka Amalɛki sɔrɔn a yɛ. Esawu muso Ada bɔnsɔn de woilu ri. ");
INSERT INTO msc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Esawu dencɛ Rewɛli dencɛilu le ten: Nahati ni Serahi ni Sama ni Misa ri. Esawu muso Basimati bɔnsɔn de woilu ri. ");
INSERT INTO msc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esawu muso Olibama, wo tɛrɛ Ana denmuso le ri. A benba tɛrɛ Sibeyɔn de ri. Olibama ka dencɛ mɛnilu sɔrɔn Esawu yɛ, woilu le tɛrɛ Jɛwusi ni Jalamu ni Kora ri. ");
INSERT INTO msc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nba, mɛnilu kɛra kabilabatii ri Esawu bɔnsɔn dɔ, woilu le ten. A dencɛ fɔlɔ Elifasi dencɛ woilu rɔ, mɛnilu kɛra kabilatii ri, woilu le ten: Teman, Omar, Sefo, Kenasi, ");
INSERT INTO msc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Katamu a ni Amalɛki. Kabilatii mɛnilu bɔra Elifasi rɔ Edɔmukailu na jamana rɔ, woilu le le tɛrɛ ɲin di. Esawu la muso Ada bɔnsɔn de woilu ri. ");
INSERT INTO msc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esawu dencɛ Rewɛli dencɛ mɛnilu kɛra kabilabatii ri, woilu le ten: Nahati, Serahi, Sama a ni Misa. Kabilatii mɛnilu bɔra Rewɛli rɔ Edɔmukailu na jamana rɔ, woilu le tɛrɛ ɲin di. Esawu muso Basimati bɔnsɔn de woilu ri. ");
INSERT INTO msc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esawu muso Olibama dencɛ mɛnilu kɛra kabilabatii ri, woilu le ten: Jɛwusi, Jalamu a ni Kora. Esawu muso Olibama dencɛ mɛnilu kɛra kabilatii ri, woilu le tɛrɛ ɲin di. Olibama tɛrɛ Ana denmuso le ri. ");
INSERT INTO msc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nba, woilu le Esawu dencɛ ri, a ni kabilatii. Edɔmukailu de woilu ri. ");
INSERT INTO msc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Nba, Esawu ka Hori Seyiri dencɛilu mɛnilu tɛrɛn Edɔmukailu na jamana rɔ, woilu le ten Lotan, Sobali, Sibeyɔn, Ana, ");
INSERT INTO msc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disɔn, Esɛri a ni Disan. Seyiri dencɛilu le woilu ri, mɛnilu kɛra Horilu la kabilatii ri Edɔmukailu na jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan dencɛilu le tɛrɛ Hori ni Hɛman ri. Lotan dɔɔmuso le tɛrɛ Timina ri. ");
INSERT INTO msc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali dencɛilu le ten: Aliban, Manahati, Ebali, Sefo a ni Onamu. ");
INSERT INTO msc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeyɔn dencɛilu le tɛrɛ Aja ni Ana ri. Ana wo tɛrɛ ye a fa la faliilu gbɛnna tuma mɛn na, ale le fɔlɔfɔlɔ ka ji kaliman yen bɔ duu rɔ wula kɔndɔ ye. ");
INSERT INTO msc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana dencɛ le tɛrɛ Disɔn di. A denmuso tɛrɛ Olibama ri. ");
INSERT INTO msc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disɔn dencɛilu le ten: Hɛmɛdan, Esiban, Jitiran a ni Keran. ");
INSERT INTO msc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esɛri dencɛilu le tɛrɛ Bilan ni Saban ni Akan di. ");
INSERT INTO msc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan dencɛilu le tɛrɛ Usi ni Aran di. ");
INSERT INTO msc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nba, Horilu la kabilatii le ten: Lotan, Sobali, Sibeyɔn, Ana, ");
INSERT INTO msc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disɔn, Esɛri a ni Disan. Mɛnilu kɛra Horilu la kabilatii ri Seyiri la jamana rɔ, woilu le tɛrɛ ɲin di. ");
INSERT INTO msc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sani mansa ye a sii Isirayɛlika kun na, mansa mɛnilu tɛrɛ ye mansaya la Edɔmukailu na jamana rɔ, woilu le ɲin di. ");
INSERT INTO msc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beyɔri dencɛ Bela kɛra mansa ri Edɔmukailu na jamana kun na. A siini tɛrɛ so mɛn na, wo le tɔɔ ko Dinhaba. ");
INSERT INTO msc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela sani, Serahi dencɛ Jobabu kɛra mansa ri a nɔ rɔ. Wo siini tɛrɛ so mɛn na, wo le tɔɔ ko Bɔsira. ");
INSERT INTO msc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobabu sani, Husamu siira mansaya la a nɔ rɔ. Ale bɔra Temanka jamana le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu sani, Bedadi dencɛ Hadadi siira mansaya la a nɔ rɔ. Wo le ka Madiyan bɔnsɔn kɛlɛ Mowabu bɔnsɔn na jamana rɔ ka se ii la. A siini tɛrɛ so mɛn na, wo le tɔɔ ko Abiti. ");
INSERT INTO msc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi sani, Samula siira mansaya la a nɔ rɔ. Ale bɔni Masirekan de. ");
INSERT INTO msc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula sani, Sawuli le kɛra mansa ri a nɔ rɔ. Wo bɔra Rehoboti, mɛn ye ba da la. ");
INSERT INTO msc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawuli sani, Akibori dencɛ Bahali-Hanan siira mansaya la a nɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akibori dencɛ Bahali-Hanan sani, Hadari siira mansaya la a nɔ rɔ. Ale siini tɛrɛ so mɛn na, wo le tɔɔ ko Pawu. A muso tɔɔ le ko Metabɛli. Metabɛli tɛrɛ Matiredi denmuso le ri. A benba le tɛrɛ Me-Sahabu le ri. ");
INSERT INTO msc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nba, kabilatii mɛnilu bɔra Esawu denilu rɔ, woilu tɔɔ le ɲin di, a bɛɛ ni a la mɔɔilu, a bɛɛ ni a la duu. Ii tɔɔ le ten: Timina, Aliba, Jetɛti, ");
INSERT INTO msc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Pinon, ");
INSERT INTO msc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenasi, Teman, Misari, ");
INSERT INTO msc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Madiyɛli a ni Iramu. Woilu le kɛra kabilatii ri Edɔmukailu na jamana rɔ, a bɛɛ ni a la duu. Esawu le kɛra Edɔmukailu bɛɛ benba ri. ");
INSERT INTO msc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nba, Yakuba ka i sii Kanaan jamana rɔ, a fa siini tɛrɛ dinkira mɛn dɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yakuba dencɛilu la ko le ɲin di. Yusufu sɔrɔn ka san tan ni wɔrɔnwula bɔ tuma mɛn na, a tɛrɛ ye saailu ni bailu gbɛnna a kɔrɔcɛilu fɛ. A tɛrɛ ye a fa la jɔn musoilu Bilaha ni Silipa dencɛilu dɛmɛnna. Dencɛ woilu tɛrɛ ye ko bɛnbali mɛnilu kɛla la, Yusufu tɛrɛ ye wo bɛɛ ɲafɔla a fa yɛ. ");
INSERT INTO msc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusufu duman tɛrɛ Isirayɛli yɛ ka tamin a den tɔ bɛɛ la ka a masɔrɔn a ka Yusufu sɔrɔn a la cɛmɔɔbaya waati le rɔ. Wo rɔ, Yakuba ka duruki kɔrɔbila manɲɛɛnman do di Yusufu ma. ");
INSERT INTO msc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yusufu kɔrɔcɛilu ka a yen ko a duman ii fa yɛ ka tamin ii tɔ bɛɛ la. Wo rɔ, Yusufu gboyara ii yɛ fɔɔ ii ka ii ban kuma ɲuma fɔla a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lon do rɔ, Yusufu sibora. A ka wo ɲafɔ a kɔrɔcɛilu yɛ tuma mɛn na, do lara a la gboyaɲɛ kan. ");
INSERT INTO msc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","A ka a fɔ ii yɛ ko: «Ai ye i tolo malɔ n na sibo kan na! ");
INSERT INTO msc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","N sibora an bɛɛ ye sɛnɛ rɔ. An tɛrɛ ye suman kala ka a lasidi. Wo yɔrɔni bɛɛ, n ta sumansidi ka i wuli ka i lɔ. Ai la sumansidilu nara n ta laminin ka i majii a kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","A kɔrɔcɛilu ka a jabi: «A ye di? A lɔɔ ye i la ka i sii an kun na ka kɛ an na mansa ri wa?» A gboyara ii yɛ ikɔ tuunni ka tamin fɔlɔman na a la sibo ni a la kumailu kosɔn. ");
INSERT INTO msc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yusufu sibora ikɔ. A ka wo fanan ɲafɔ a kɔrɔcɛilu yɛ. A ka a fɔ ko: «Ai la tolo malɔ n na. N da sibo ikɔ tuun. N ka tele yen a ni karo ni lolo tan ni kelen. Wo bɛɛ ka i majii n kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A ka sibo ɲafɔ a fa ni a kɔrɔcɛilu yɛ tuma mɛn na, a fa jamanda a ma ko: «Sibo su ɲuman de wo ri? I ye a fɛ nde ni i na ni i kɔrɔcɛilu bɛɛ ye na an majii i kɔrɔ wa?» ");
INSERT INTO msc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A la ko ɲangboya ka a kɔrɔcɛilu mira, kɔni a fa tɛrɛ ye i mirila sibo wo ma waati bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nba, lon do rɔ Yusufu kɔrɔcɛilu wara ii fa la kolofenilu gbɛn diya Sɛkɛmu. ");
INSERT INTO msc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isirayɛli ka a fɔ Yusufu yɛ ko: «I kɔrɔcɛilu ra wa kolofenilu gbɛn diya Sɛkɛmu. N ye a fɛ i ye wa bɔ ye.» Yusufu ka a fɔ ko: «Ale le wo ri.» ");
INSERT INTO msc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakuba ka a fɔ a yɛ ko: «Wa bɔ ii fɛ. Ni ii kɛndɛ, ni ko tɛ kolofenilu fanan na, i ye na wo fɔ n yɛ.» Wo rɔ, a ka Yusufu lawa ka bɔ Heburɔn dinban dɔ. A se mɛn kɛni Sɛkɛmu, ");
INSERT INTO msc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","a tɛrɛ ye a mataamala wula kɔndɔ. Cɛɛ do ka a tɛrɛn ye ka a maɲininka ko: «I ye nfen ɲininna?» ");
INSERT INTO msc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu ka a fɔ ko: «N ye n kɔrɔcɛilu le ɲininna. Ii ye kolofenilu gbɛnna. I ka ii diya lɔn wa?» ");
INSERT INTO msc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Cɛɛ ka a fɔ ko: «Ii ra bɔ yan. N ka ii kan mɛn ko ii watɔ Dotan.» Yusufu bɔra ye ka wa ii kɔ. A ka ii tɛrɛn Dotan. ");
INSERT INTO msc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","A kɔrɔcɛilu ka a natɔla yen fɔɔ yɔrɔ jan. Sani a ye se ii ma, a kɔrɔcɛilu ka janfa don a ma ko ii ri a faa. ");
INSERT INTO msc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ii ka a fɔ i ɲɔɔn yɛ ko: «Ai ɲa lɔ, sibotii wo natɔ la le ten! ");
INSERT INTO msc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","An ye an wuli ka a faa. An ye a lafili kɔlɔn jaran kɔndɔ ka a fɔ ko wara juu le ka a faa ka a dɔɔn. A la sibo ri kɛ mɛn di wo rɔ, an di wo yen.» ");
INSERT INTO msc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubɛn ka kuma wo mɛn tuma mɛn na, a lɔɔ tɛrɛ ye a la ka Yusufu kisi ii ma. A ka a fɔ ko: «An kana a faa. ");
INSERT INTO msc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ai kana a jeli labɔ. Ai ye a lafili kɔlɔn jaran ɲin kɔndɔ wula kɔndɔ yan, ai kana ko kɛ a la.» Rubɛn ka wo fɔ kosa a ri wa ii kɔfɛ ka Yusufu layɛlɛ kɔlɔn dɔ ka wa a di a fa ma. ");
INSERT INTO msc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nba, Yusufu se mɛn kɛni ii ma, ii ka a la duruki kɔrɔbila manɲɛɛnman wo bɔ a kan na. ");
INSERT INTO msc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ii ka a mira ka a lafili kɔlɔn do kɔndɔ. Kɔlɔn wo jani le tɛrɛ, ji tun tɛ a kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ii siini tɛrɛ dɔɔnninna tuma mɛn na, ii ka ii ɲa lɔ ka jula doilu tamintɔla la yen. Woilu tɛrɛ ye Isumayilaka le ri. Ii bɔtɔ Kiliyadi ka wa Misiran. Wusulan ni tulu suma duman ni latikɔlɔn tɛrɛ ye ii la ɲɔɔmɛilu la donin dɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahuda ka a fɔ a badenmailu yɛ ko: «Ni an ka an dɔɔcɛ faa ka a dokon, an di tɔnɔ su ɲuman sɔrɔn wo la? ");
INSERT INTO msc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","An ye a san Isumayilaka julailu ma. An jɛrɛ kana a faa. An dɔɔcɛ le. An bɛɛ ye badenma le ri.» A badenmailu sɔnda wo ma. ");
INSERT INTO msc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wo rɔ, Madiyanka julailu tamintɔla, Yusufu kɔrɔcɛilu ka a layɛlɛ kɔlɔn kɔndɔ, ka a san Isumayilaka woilu ma wodigbɛ muwan na. Woilu ka a san ka wa a ri Misiran. ");
INSERT INTO msc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nba, Rubɛn nara kɔlɔn da la ii kɔfɛ, kɔni a ma Yusufu tɛrɛn kɔlɔn kɔndɔ. Wo gbara a la kojuuya fɔɔ a ka a la duruki rafarafara. ");
INSERT INTO msc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","A wara a dɔɔcɛilu tɛrɛn ye ka a fɔ ii yɛ ko: «Kanberen tɛ kɔlɔn kɔndɔ ye butun! N ye wala di?» ");
INSERT INTO msc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Wo rɔ, ii ka bakɔrɔn do faa ka Yusufu la duruki kɔrɔbila ta ka a bila wo jeli rɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ii wara duruki kɔrɔbila di ii fa ma ka a fɔ ko: «An ka duruki kɔrɔbila ɲin tɛrɛn wula rɔ. I ye a ragbɛ ni i dencɛ ta le.» ");
INSERT INTO msc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakuba ma fili a ma. A ka a fɔ ko: «N dencɛ la duruki kɔrɔbila le jɔ. Wara juu ra a faa ka a dɔɔn. Ɛɛ, n dencɛ Yusufu! Wara ra a rafarafara.» ");
INSERT INTO msc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakuba ka a la duruki rafarafara jusukasi kosɔn, ka landa faanin bila a kan na ikomin landa faanin. A ka tele siyaman kɛ kasila kojuuya a dencɛ la saya ko rɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A dencɛilu ni a denmusoilu tɛrɛ ye nala ko ii ye ii fa jususumala. Kɔni a ma sɔn a jususuma ko ma. A ka a fɔ ko: «N kasimantɔ ri to n dencɛ la ko la haan n di faa.» Yusufu fa kasira ten de a la saya ko rɔ. ");
INSERT INTO msc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nba, Madiyanka julailu sera Misiran ka Yusufu san Ferawuna ɲɛmɔɔ Potifari ma. Potifari tɛrɛ Ferawuna la kandaninnailu la kuntii le ri. ");
INSERT INTO msc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nba, a ma mɛn bakɛ, Yahuda bɔra a badenmailu tɛma, ka wa a sii Adulamuka do tɔrɔfɛ mɛn tɔɔ ko Hira. ");
INSERT INTO msc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yahuda ka Kanaanka sunkurun do yen ye, mɛn fa tɔɔ ko Suwa. A ka sunkurun wo furu. Ii dɛnda. ");
INSERT INTO msc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Muso ka kɔnɔ ta ka dencɛ sɔrɔn Yahuda yɛ. Yahuda ka den wo tɔɔ la ko Ɛri. ");
INSERT INTO msc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A ka kɔnɔ gbɛrɛ ta, ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Onan. ");
INSERT INTO msc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","A ka kɔnɔ gbɛrɛ ta ikɔ tuun ni, ka dencɛ sɔrɔn. A ka wo tɔɔ la ko Sela. Den wo sɔrɔnda ka Yahuda tɛrɛn Akesibu so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Waati wo taminni kɔ, Yahuda ka muso do furu Ɛri yɛ, a dencɛ fɔlɔ kɔnin. Muso wo tɔɔ le tɛrɛ ko Tamari. ");
INSERT INTO msc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kɔni, Ɛri kɛra mɔɔ juu le ri Allabatala ɲana. Wo rɔ, Allabatala ka a faa. ");
INSERT INTO msc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yahuda ka a fɔ a dencɛ Onan yɛ ko: «I ye i numɔɔmuso ta, i kɔrɔcɛ muso kɔnin. Ai ye dɛn, sa den di sɔrɔn i kɔrɔcɛ yɛ, sa i kɔrɔcɛ bɔnsɔn kana tunun.» ");
INSERT INTO msc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kɔni Onan ka a yen ko ni den wo sɔrɔnda, a tɛ jate ale ta ri, fo a kɔrɔcɛ ta ri. Wo rɔ, Onan ni muso wo wa dɛn, a tɛ sɔnna a siji ye don a rɔ. A ri wo bɛɛ kɛ duu ma, kosa a kana bɔnsɔn di a kɔrɔcɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tɛrɛ ye mɛn kɛla, wo ma diya Allabatala yɛ. Wo rɔ, Allabatala ka ale fanan faa. ");
INSERT INTO msc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yahuda ka a fɔ Tamari yɛ ko: «I kana sii cɛɛ gbɛrɛ kun. I wa, to i fa wara fo n dencɛ Sela wa se i furu ma.» Yahuda ka wo fɔ ka a masɔrɔn a silanni ka Tamari di Sela ma, baa Sela kana faa ikomin a kɔrɔcɛilu faara ɲa mɛn ma. Tamari wara a fa wara wo rɔ. ");
INSERT INTO msc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Waati wo taminni kɔ, Yahuda muso sara, Suwa denmuso kɔnin. Yahuda la jusukasi sumara tuma mɛn na, a wara Timina, mɔɔilu tɛrɛ ye a la saailu si malila dinkira mɛn dɔ. A duɲɔɔncɛ Adulamuka Hira wara a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A fɔra Tamari yɛ ko a birancɛ Yahuda watɔ a la saailu si mali diya Timina. ");
INSERT INTO msc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamari ka a lɔn ko a numɔɔcɛ Sela ra se furu ma, kɔni a birancɛ Yahuda ma sɔn a ye sii wo kun. Wo rɔ, Tamari ka a la landa faanin bɔ a fari ma, ka a la bitiran birin a kun na, ka a ɲa latunun. A wara ka a sii a jɛrɛ ma Enayimu so donda la, Timina sila la ye. ");
INSERT INTO msc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yahuda tamintɔ ka Tamari siini yen. A ka a jate jatɔmuso le ri, ka a masɔrɔn Tamari tun da a ɲa matunun. ");
INSERT INTO msc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda filira a ma fewu! A ma a lɔn ko a biranmuso le. A wara a fɔ a yɛ ko: «N ye a fɛ ka n la i fɛ.» Tamari ka a fɔ ko: «Ni n diɲɛra, i ri nfen di n ma?» ");
INSERT INTO msc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda ka a jabi: «N di badenni kelen bɔ n na bailu rɔ ka a lana i ma.» Tamari ka a fɔ ko: «I ri nfen bila a kun kɔrɔ sani i ye ba lana n ma?» ");
INSERT INTO msc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yahuda ka a fɔ ko: «N ye nfen di i ma?» Tamari ka a jabi: «I tɔɔ tɔɔmasere ye fen mɛn kan, i ye wo ni a julu di n ma, ka i la gbeleke la woilu kan.» Yahuda ka wo bɛɛ di a ma. Ii dɛnda. Wo rɔ, Tamari ka kɔnɔ ta Yahuda fɛ. ");
INSERT INTO msc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamari ka a kɔsɛ a wara. A ka bitiran bɔ a kun na ka a la landa faanin bila a kan na ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahuda ka badenni lawa muso ma a duɲɔɔncɛ Adulamuka bolo, kosa a ka fen mɛnilu di muso ma, a duɲɔɔncɛ ye woilu mira ka na. Cɛɛ wo wara, kɔni a ma muso yen. ");
INSERT INTO msc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","A ka cɛɛ doilu maɲininka Enayimu ko: «Jatɔmuso mɛn tɛrɛ ye a siila sila la yan so donda la, a ye mi?» Ii ka a jabi: «An ma jatɔmuso si yen yan fɔlɔ.» ");
INSERT INTO msc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Cɛɛ ka a kɔsɛ ka a fɔ Yahuda yɛ ko: «N ma muso wo tɛrɛn ye. Ye cɛɛilu ka a fɔ ko ii ma jatɔmuso si yen ye fɔlɔ.» ");
INSERT INTO msc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda ka a fɔ ko: «Baasi tɛ wo ri. Fen woilu ye to a bolo. An kana an jɛrɛ lamaloya a ɲininna. Kɔni n ka baden nawa a ma. Ni i ma a yen, a ma ban?» ");
INSERT INTO msc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nba, karo sawa taminni kɔ rɔ, a fɔra Yahuda yɛ ko a biranmuso Tamari ra jatɔya kɛ. Ko sisen, ko a ra kɔnɔ ta. Yahuda ka kuma wo mɛn tuma mɛn na, a ka a fɔ ko: «Ai ye wa a labɔ kɛnɛma ka a janin!» ");
INSERT INTO msc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mɔɔilu wara Tamari mira. Ii ye a labɔla kɛnɛma tuma mɛn na, a ka kela lawa a birancɛ ma ko: «Mɛn ka kɔnɔ la n na, a la fenilu le ɲin di. I ye tɔɔmasere fen ɲin ni a julu ragbɛ, ka gbeleke fanan dagbɛ ni i ka woilu tii lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahuda ka wo fenilu ragbɛ ka a yen ko a ta le. A ka a fɔ ko: «Muso ɲin telenni ka tamin nde la, baa n tun ka kan ka a di n dencɛ Sela le ma ka a kɛ a muso ri, kɔni n ma sɔn wo ma.» Yahuda ma a la Tamari fɛ wo kɔ. ");
INSERT INTO msc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Nba, a moyi waati sera tuma mɛn na, den kɛra filani ri. ");
INSERT INTO msc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A moyitɔla, den kelen ka a bolo labɔ. Tinkɔrɔsilali ka a bolo mira ka kari wulen do sidi a la ka a fɔ ko: «Ɲin de ye fɔlɔ ri.» ");
INSERT INTO msc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kɔni den ka a bolo ladon ikɔ tuunni. A filani-ɲɔɔn bɔra. Tinkɔrɔsilali le ka a fɔ ko: «Ile le ra sila bɔ jɔ!» Wo rɔ, a ka wo tɔɔ la ko Pɛrɛsi. ");
INSERT INTO msc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A dɔɔmanin bɔra a kɔ, kari wulen sidini wo bolo la. Ii ka wo tɔɔ la ko Serahi. ");
INSERT INTO msc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nba, Isumayilaka jula woilu wara Yusufu ri Misiran ka a san Ferawuna la ɲɛmɔɔ Potifari ma. Potifari tɛrɛ mansa la kandaninnailu la kuntii le ri. ");
INSERT INTO msc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Allabatala tora Yusufu fɛ ka a la ko bɛɛ sabati. A tɛrɛ ye baarala a tii Potifari la bon na, Misiranka wo kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A tii ka a yen ko Allabatala ye Yusufu fɛ ko bɛɛ rɔ, baa a wa a bolo bila fen fen dɔ, Allabatala ri wo bɛɛ sabati. ");
INSERT INTO msc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu diyara a tii yɛ. Wo rɔ, a ka Yusufu kɛ a jɛrɛ dɛmɛnba ri, ka a lasii a la mɔɔilu bɛɛ kun na, ka a kɛ a la nanfulu kunnasiiba ri. ");
INSERT INTO msc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kɛbi Misiranka cɛɛ wo ka Yusufu lasii a la nanfulu ni a la mɔɔ bɛɛ kun na, Allabatala ka ɲumaya kɛ a yɛ ka ko bɛɛ sabati a wara ka a masɔrɔn Yusufu la ko rɔ. Allabatala ka Potifari bolofen bɛɛ ɲumaya, mɛnilu ye so kɔndɔ, a ni mɛnilu ye sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifari ka a la ko bɛɛ to Yusufu bolo. A ma a jɛrɛ tɔrɔ foyi la fɔɔ a tɛrɛ ye mɛnilu dɔɔnna. Yusufu tɛrɛ ye kanberen kenyanin de ri. A fari dafanin a kan. A ɲada fanan kenɲi. ");
INSERT INTO msc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lon do rɔ, Potifari muso ɲabɔra Yusufu la. A ka a fɔ Yusufu yɛ ko: «Na, i la n fɛ.» ");
INSERT INTO msc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yusufu ma sɔn fewu. A ka a fɔ muso wo yɛ ko: «I ɲa lɔ. N tii tɛ a jɛrɛ tɔrɔla foyi la a wara yan ka a masɔrɔn n ye yan. A ra a bolofen bɛɛ karifa n na. ");
INSERT INTO msc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A la fanka ni n ta bɛɛ ka kan a wara yan. N sawo ye fen bɛɛ rɔ lu ma yan fo ile, baa i ye a muso le ri. N ti se kojuu su wo kɛla, ka haramu kɛ Alla ɲana.» ");
INSERT INTO msc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hali wo, muso wo ma a boloka wo si rɔ. Lon lon a tɛrɛ ye Yusufu madiyala, kɔni Yusufu ma sɔn ka i la a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lon do rɔ, Yusufu wara baara diya bon na. Wo ka a tɛrɛn bonkɔndɔ jɔn si tun tɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Muso ka Yusufu mira a la duruki ma, ko a ye a la a fɛ. Kɔni Yusufu ka a bori a yɛ ka bɔ bon na ka a la duruki to muso bolo. ");
INSERT INTO msc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Muso ka a yen tuma mɛn na ko Yusufu borimantɔ ra bɔ bon na ka a la duruki to a bolo, ");
INSERT INTO msc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a ka a kan nabɔ bonkɔndɔ jɔnilu ma. Woilu nani, a ka a fɔ ii yɛ ko: «Ai la ragbɛ. N cɛɛ ka Heburu cɛɛ mɛn nana an ma, wo ra an dɔɔya. A ra don n ka a fɔ ko a ye i lala n fɛ. Kɔni n kulera fanka la. ");
INSERT INTO msc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","A ka n kule kan mɛn tuma mɛn na, a borimantɔ bɔra bon na ka a la duruki to n dafɛ yan.» ");
INSERT INTO msc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Muso ka duruki wo lamara a dafɛ ka Yusufu tii Potifari makɔnɔ. ");
INSERT INTO msc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Wo nani, muso ka dantɛɛli bɛɛ kɛ a cɛɛ yɛ ɲa kelen wo ma ko: «I ka Heburu jɔncɛ mɛn nana an ma, wo ra don n kan ka n dɔɔya. ");
INSERT INTO msc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kɔni n kulera tuma mɛn na, a borimantɔ bɔra bon na ka a la duruki to n dafɛ yan.» ");
INSERT INTO msc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nba, a ka a muso la kuma mɛn Yusufu la ko rɔ tuma mɛn na, a jusu bɔra kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Wo rɔ, a wara Yusufu mira ka a bila kaso la, mansa la kasodeni bilani dinkira mɛn. Yusufu tora kaso la ye. ");
INSERT INTO msc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kɔni Allabatala tora Yusufu fɛ. A ka ɲumaya kɛ Yusufu yɛ. Wo rɔ, a ka Yusufu dɛmɛn ka a la ko diya kaso bon kuntii yɛ. ");
INSERT INTO msc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Wo rɔ, kaso bon kuntii ka Yusufu lasii kasoden tɔ bɛɛ kun na kaso bon na. Yusufu le tɛrɛ ko bɛɛ ɲanabɔla ye. ");
INSERT INTO msc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kasobon kuntii ka ko mɛn bɛɛ to Yusufu bolo, a ma hamin wo si la butun baa Allabatala tɛrɛ ye Yusufu fɛ. A ka fen fen kɛ, Allabatala ka wo bɛɛ sabati. ");
INSERT INTO msc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Waati wo taminni kɔ, Misiran mansa la minninfendila ni a la burugbasila ka kojuu do kɛ a la. ");
INSERT INTO msc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ferawuna jusu bɔra mɔɔba fila woilu kanma, a la minninfendilailu la kuntii ni a la burugbasilailu la kuntii kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","A ka ii mira ka ii bila kaso la, Yusufu bilani dinkira mɛn dɔ. Kaso wo tɛrɛ ye kasoden kandaninna kuntiiba la bon dafɛ. ");
INSERT INTO msc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kasoden kandaninna kuntiiba ka ii karifa Yusufu la, ko a ye kɛ ii dɛmɛnba ri. Ii mɛnda kaso la. ");
INSERT INTO msc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Lon do rɔ, mansa la minninfendila ni a la burugbasila sibora su rɔ. Wo ka a tɛrɛn ii ye kaso la fɔlɔ. Ii fila sibora, kɔni sibo kelen tun tɛ. Ii kɔrɔilu tun tɛ kelen di fanan. ");
INSERT INTO msc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wo duusa gbɛ, Yusufu ka a yen ko hamin ba ye ii la. ");
INSERT INTO msc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","A ka mansa la ɲɛmɔɔ maɲininka ko: «Nfen kɛni ai sɛwani tɛ bi?» ");
INSERT INTO msc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ii ka a jabi: «An fila ra sibo, kɔni mɔɔ tɛ yan mɛn di sibo woilu kɔrɔilu fɔ an yɛ.» Yusufu ka a fɔ ko: «Sibo kɔrɔ lɔnba tɛ Alla le ri wa? Ai ka mɛnilu yen sibo rɔ, ai ye woilu ɲafɔ n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wo rɔ, mansa la minninfendilailu la kuntii ka mɛn yen, a ka wo fɔ Yusufu yɛ. A ka a fɔ ko: «N siboni le, n ka rɛsɛnju do yen n ɲɛ. ");
INSERT INTO msc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Bolo sawa ye a la. A fira wa bɔ damira, a ri a fɛrɛn ka den ka kɛ rɛsɛn mɔnɛnilu ri i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Misiran mansa la minninfen tɛrɛ ye n bolo. Wo rɔ, n ka rɛsɛn mɔni woilu kadi, ka ii rabirin mansa la minninfen kɔndɔ, ka a di a ma.» ");
INSERT INTO msc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu ka a fɔ ko: «Wo kɔrɔ le ɲin di. Bolo sawa wo ye tele sawa le ri. ");
INSERT INTO msc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tele sawa wa tamin, mansa ri i bɔ kaso la, ka i bila i la baara kɔrɔ la. I ri a la minninfen don a bolo ikomin i darini a kɛla ɲa mɛn ma kɔrɔman. ");
INSERT INTO msc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","I wa hɛrɛ wo sɔrɔn tuma mɛn na, i jaandi, i kana ɲina n kɔ. I ka kan ka ɲumaya kɛ n yɛ baa n ka i dɛmɛn. I ye n na ko fɔ Ferawuna yɛ wo rɔ, kosa a ri n nabɔ kaso la, ");
INSERT INTO msc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","baa mɔɔilu ka n mira fanka le la ka n nabɔ Heburuilu la jamana rɔ. Kɛbi ii ka n nana yan, n ma kojuu kɛ, mɔɔ ri mɔɔ bila kaso la mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Nba, burugbasilailu la kuntii ka a yen ko Yusufu ka a duɲɔɔncɛ la sibo kɔrɔ fɔ ka a diya. Wo rɔ, ale ka a fɔ Yusufu yɛ ko: «N fanan sibora. N ka see sawa yen n kun ma. ");
INSERT INTO msc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","See mɛn tɛrɛ ye sanfɛ, burun su bɛɛ tɛrɛ ye wo kɔndɔ. Wo bɛɛ rabɛnni tɛrɛ Ferawuna yɛ, kɔni kɔnɔilu tɛrɛ ye jiila a ma ka fen woilu dɔɔn see kɔndɔ n kun dɔ ma.» ");
INSERT INTO msc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu ka a fɔ ko: «Sibo wo kɔrɔ le ɲin di. Seye sawa wo fanan ye tele sawa le ri. ");
INSERT INTO msc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tele sawa wa tamin, Ferawuna ri i bɔ kaso la, ka i kun tɛɛ a la ka i su dun jiri la. Kɔnɔilu ri na i sobo dɔɔn.» ");
INSERT INTO msc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nba, tele fila a sawana, wo kɛra Ferawuna sɔrɔn lon sankunbɛn tolon di. Wo rɔ, Ferawuna ka tibili ba kɛ a la jamana mɔɔbailu yɛ. A ka minninfendilailu la kuntii ni burugbasilailu la kuntii labɔ kaso la ka ii lana mɔɔbailyu bɛɛ ɲana. ");
INSERT INTO msc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A ka minninfendilailu kuntii bila a la baara kɔrɔ la, kosa a ri Ferawuna la minninfen don a bolo ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kɔni Ferawuna ka burugbasilailu la kuntii wo dun jiri la ikomin Yusufu ka a fɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Minninfendilailu la kuntii ma a miri Yusufu ma wo kɔ. A ɲinara a kɔ fewu. ");
INSERT INTO msc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","San fila taminnin kɔ rɔ, Misiran mansa sibora ka a jɛrɛ lɔni yen Nili Ba dala. ");
INSERT INTO msc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A lɔni tora ye tuma mɛn na, nisimuso tɔlɔni wɔrɔnwula bɔra ji rɔ ka na bin dɔɔn diya ba dala. ");
INSERT INTO msc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A ma mɛn bakɛ, nisimuso barani wɔrɔnwula fanan bɔra Nili Ba ji rɔ. Woilu nara ii lɔ nisimuso tɔlɔni woilu tɔrɔfɛ ba dala. ");
INSERT INTO msc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nisimuso barani kojuuyani woilu ka nisimuso ɲuma tɔlɔni wɔrɔnwula woilu dɔɔn ka ban. Wo kɛni, mansa kunura sunɔɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","A sunɔɔra ikɔ ka sibo gbɛrɛ fanan la. A ka sumantɔnsɔn wɔrɔnwula yen. Wo bɛɛ bɔni sumangbala kelen de la. Ii kisɛ bɛɛ kunba. Ii ka ɲi. ");
INSERT INTO msc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A ma mɛn bakɛ, sumantɔnsɔn wɔrɔnwula gbɛrɛ bɔra. Woilu kisɛ mɛsɛnman. Ii kɛni ikomin fɔɲɔ ba wa suman janfɔ a gban na. ");
INSERT INTO msc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sumantɔnsɔn mɛnilu kisɛni mɛsɛnman, woilu ka suman ɲuma wɔrɔnwula woilu dɔɔn, mɛnilu kisɛ kunba. Wo kɛni, mansa kunura ka a yen ko sibo le tɛrɛ. ");
INSERT INTO msc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Wo duusagbɛni, mansa jusumakasara. Wo rɔ, a ka Misiran jamana fɛlɛlilailu bɛɛ ni a hankilimailu bɛɛ kili. A ka mɛn yen sibo rɔ, a ka wo ɲafɔ ii yɛ, kɔni wo si ma se ka a la sibo kɔrɔ fɔ a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","A la minninfendilailu la kuntii kumara a yɛ ko: «Mansa, n hankili ra bila n na kojuu kɛni rɔ sisen. ");
INSERT INTO msc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","I mɔnɛra an, i la jɔnilu ma tuma mɛn na wo lon, i ka nde ni i la burugbasilailu la kuntii bila kaso la kasoden kandaninna kuntiiba la ɲala kaso la. ");
INSERT INTO msc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","An mɔɔ fila bɛɛ sibora su kelen dɔ. Sibo woilu kɔrɔilu tun tɛ kelen di. ");
INSERT INTO msc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Heburu kanberen do tɛrɛ ye an fɛ kaso la. Kasoden kandaninna kuntiiba la jɔn de tɛrɛ. An mɔɔ fila ka mɛn yen sibo rɔ, an ka wo ɲafɔ a yɛ. A ka woilu kɔrɔilu fɔ an yɛ. ");
INSERT INTO msc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A ka a kɔrɔ mɛn fɔ, a kɛra wo ɲa le ma! I ka nde lasɛ n na baara kɔrɔ la, ka ban ka burugbasilailu la kuntii dun jiri la.» ");
INSERT INTO msc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mansa ka kela lawa ko Yusufu ye na. Mɔɔilu borimantɔ wara Yusufu labɔ kaso la. Yusufu ka a bonbosi li ka a la faanin mayɛlɛman, ka wa i lɔ Misiran mansa ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","A seni ye, mansa ka a fɔ a yɛ ko: «N da sibo le kɛ. Mɔɔ si ma se ka wo kɔrɔ fɔ n yɛ. A fɔra n yɛ ko i ri se sibo kɔrɔ fɔla.» ");
INSERT INTO msc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu ka mansa jabi: «Mansa, nde ti se, kɔni Alla ri a kɔrɔ ɲuma di i ma.» ");
INSERT INTO msc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mansa ka a fɔ a yɛ ko: «N sibora ka n lɔni yen Nili Ba dala. ");
INSERT INTO msc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","N lɔni tora ye tuma mɛn na, nisimuso wɔrɔnwula bɔra ji rɔ ka na bin dɔɔn diya ba dala. Ii ka ɲi kosɛbɛ. Ii tɔlɔni. ");
INSERT INTO msc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","A ma mɛn, nisimuso wɔrɔnwula gbɛrɛ fanan bɔra ji rɔ. Woilu barani tɛrɛ kojuuya. Ii kɛjuuyani ka tamin. Sobo jɔnjɔn tun tɛ ii la. N tun ma nisi gbɛrɛ kɛjuuyani woilu ɲɔɔn yen fɔlɔ munun Misiran jamana muumɛ rɔ yan. ");
INSERT INTO msc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nisimuso barani woilu, mɛnilu kɛjuuyani kɔnin, woilu ka nisimuso tɔlɔni wɔrɔnwula wo dɔɔn, mɛnilu fɔlɔma bɔra ji rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Hali ii ka woilu dɔɔn, mɔɔ ti se wo lɔn na, ka a masɔrɔn ii fari barani tɛrɛ ɲa mɛn ma fɔlɔ, a ye ɲa kelen wo ma munun. Wo kɛni, n kunura sunɔɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","N sunɔɔra ikɔ ka sibo. N ka sumantɔnsɔn ɲuma wɔrɔnwula yen. Woilu bɔni sumangban kelen de la. Ii bɛɛ kisɛ kunba. ");
INSERT INTO msc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A ma mɛn bakɛ, sumantɔnsɔn wɔrɔnwula gbɛrɛ bɔra. Woilu tun kisɛni tɛ jɔnjɔn. Ii bɛɛ kisɛ mɛsɛnman. Ii kɛni ikomin fɔɲɔ ba wa suman janfɔ a gban na. ");
INSERT INTO msc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Sumantɔnsɔn mɛsɛnman woilu ka Sumantɔnsɔn ɲuma wɔrɔnwula wo dɔɔn. Nba, n ka wo bɛɛ fɔ n na fɛlɛlilailu yɛ, kɔni woilu si ma se wo kɔrɔ fɔla n yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yusufu ka a fɔ mansa yɛ ko: «I la sibo fila bɛɛ ye kɔrɔ kelen de ri. Alla natɔ mɛn kɛla, a ra wo le yiraka i la. ");
INSERT INTO msc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nisimuso ɲuma wɔrɔnwula wo misaliya ye san wɔrɔnwula le ri. Sumantɔnsɔn ɲuma wɔrɔnwula wo fanan misaliya ye san wɔrɔnwula le ri. Sibo fila wo bɛɛ ye kɔrɔ kelen de ri. ");
INSERT INTO msc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nisimuso barani kɛjuuyani wɔrɔnwula mɛn bɔra ji rɔ kɔfɛ, wo ye san wɔrɔnwula le ri. Sumantɔnsɔn mɛsɛnman wɔrɔnwula wo, fɔɲɔ ka mɛnilu ja, wo fanan ye san wɔrɔnwula kɔnkɔ le ri. ");
INSERT INTO msc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Mansa, n ka a fɔ i yɛ ɲa mɛn ma, a ye wo ɲa le ma. Alla kɛtɔ mɛn kɛla, a ra wo le yiraka i la. ");
INSERT INTO msc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","San wɔrɔnwula mɛnilu natɔ, suman di sɔn a ɲa jɛrɛ jɛrɛ ma Misiran jamana fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","San woilu wa tamin, kɔnkɔ ri na ka san wɔrɔnwula kɛ. Mɔɔilu ka suman ba mɛn sɔrɔn san diyani wɔrɔnwula woilu kɔrɔ, ii ri ɲina wo bɛɛ kɔ, kɔnkɔ ri juuya jamana bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kɔnkɔ ri juuya kosɛbɛ. Mɔɔilu ka suman mɛn sɔrɔn san diyani wɔrɔnwula wo rɔ, wo bɛɛ ri ɲina ii la fewu. ");
INSERT INTO msc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Mansa, i ka sibo ɲin kɛ siɲa fila. Wo kɔrɔ le ko Alla ra ban wo ko latɛɛ la. Alla ri wo kɛ lakaliyali bolo ma. ");
INSERT INTO msc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Wo rɔ, mansa, i ye mɔɔ hankilima do ɲinin, mɛn ka ko kɔrɔ lɔn, ka wo lasii Misiran jamana kun na. ");
INSERT INTO msc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","I ye mɔɔba doilu lasii jamana kɔndɔ, sa mɔɔ woilu wa suman mɛn sɔrɔn, mɔɔba woilu ye a tala looluna lamara. Ii ye a kɛ wo ɲa jamana fan bɛɛ rɔ san diyani wɔrɔnwula bɛɛ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","I ye a fɔ ii yɛ ko ii ye suman woilu bɛɛ ladɛn wo ɲa le ma san woilu kɔrɔ, ka wo bɛɛ ladɛn jamana soilu la i tɔɔ rɔ ka a kɔnɔgbɛn. ");
INSERT INTO msc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Sa san wɔrɔnwula kɔnkɔ ba don Misiran jamana rɔ tuma mɛn na, suman lamarani woilu ri kɛ jamana mɔɔilu la balo ri.» ");
INSERT INTO msc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yusufu ka mɛn fɔ, wo diyara Misiran mansa ni a la ɲɛmɔɔilu bɛɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mansa ka a fɔ a la ɲɛmɔɔilu yɛ ko: «An di mɔɔ sɔrɔn Misiran yan, Alla la Nii ye mɛn dɔ ikomin cɛɛ ɲin?» ");
INSERT INTO msc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mansa ka a fɔ Yusufu yɛ ko: «Alla ra wo bɛɛ yiraka i la. Wo rɔ, mɔɔ si tɛ yan, mɛn hankili ka bon i ta ri, mɛn ka ko kɔrɔ lɔn ile ri. ");
INSERT INTO msc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","N di i lasii n na jamana kun na. I wa mɛn fɔ, n na mɔɔilu ri wo kɛ. Mansaya dɔrɔn de ri kɛ i ni nde tɛma. ");
INSERT INTO msc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","N da i lasii Misiran jamana bɛɛ kun na.» ");
INSERT INTO msc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Mansa ka a la bolola koyini bɔ a bolo la, a la mansaya tɔɔmasere ye mɛn kan, ka wo don Yusufu bolo la. A ka faanin ɲumaɲuma di a ma, ka kanna nɛɛ saninnaman bila a kan na. ");
INSERT INTO msc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A ka a la sowontoro filana don Yusufu bolo. Mɔɔilu wara sowontoro wo ɲɛ ka ii kan nabɔ ko: «Bɛɛ ye ii majii!» Misiran mansa ka Yusufu lasii Misiran jamana bɛɛ kun na wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mansa ka a fɔ Yusufu yɛ ko: «Nde le Misiran mansa ri, kɔni mɔɔilu kana foyi kɛ Misiran jamana rɔ butun fɔɔ ile wa sɔn mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Mansa ka Yusufu tɔɔ la ko Safinati Paneya, ka Potifera denmuso Asanati di a ma ka a kɛ a muso ri. Potifera wo tɛrɛ ye Ɔni so mɔɔilu la joo sarakalasela le ri. Nba, Yusufu kɛra Misiran jamana kunnasiila ri wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","A ka baara wo damira Ferawuna yɛ ka a tɛrɛn a sɔrɔn da san bisawa bɔ. A bɔra mansa dafɛ, ka wa Misiran jamana rataama. ");
INSERT INTO msc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Awa, san wɔrɔnwula kɛra, suman ye sɔnna a ɲa jɛrɛ jɛrɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","San san, Yusufu ri suman nadɛn suman ka waati la Misiran jamana fan bɛɛ rɔ a so mɛsɛn a ni a so kunba. Suman kanin yɔrɔ yɔrɔ a ka suman namara wo yɔrɔ kelen de bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Wo rɔ, Yusufu ti se a jatela butun baa a tɛrɛ ka siya kojuuya ikomin ba kiɲɛ. ");
INSERT INTO msc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Sani san wɔrɔnwula kɔnkɔ ye don jamana kɔndɔ, Yusufu muso Asanati ka dencɛ fila sɔrɔn a yɛ. Asanati wo tɛrɛ ye Ɔni so mɔɔilu la joo sarakalasela Potifera denmuso le ri. ");
INSERT INTO msc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu ka a dencɛ fɔlɔ tɔɔ la ko Manase, baa a ka a fɔ ko Alla ra a laɲina a la tɔrɔya bɛɛ kɔ rɔ, ka a hankili bɔ a fa wara rɔ. ");
INSERT INTO msc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A ka a dencɛ filana tɔɔ la ko Efirayimu, baa a ka a fɔ ko Alla ka a kɛ, a tɔrɔni tɛrɛ jamana mɛn dɔ, a ra jiri ye. ");
INSERT INTO msc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","San diyani wɔrɔnwula wo dafara Misiran tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","san wɔrɔnwula kɔnkɔ donda ikomin Yusufu ka a fɔ ɲa mɛn ma. Kɔnkɔ donda jamana gbɛrɛilu bɛɛ rɔ, kɔni suman namarani tɛrɛ fan bɛɛ rɔ Misiran. ");
INSERT INTO msc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kɔnkɔ sera Misirankailu ma tuma mɛn na, ii wara Misiran mansa madiya ko a ye suman di ii ma. Mansa ka ii jabi: «Ai ye wa Yusufu tɛrɛn ye. A wa mɛn fɔ ai yɛ, ai ye wo kɛ.» ");
INSERT INTO msc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kɔnkɔ juuyara ka se Misiran jamana yɔrɔ bɛɛ rɔ, tuma mɛn na, Yusufu ka suman namara bondonilu da laka, ka suman san Misirankailu ma. ");
INSERT INTO msc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mɔɔilu bɔra jamana bɛɛ rɔ ka na suman san diya Yusufu ma Misiran, baa kɔnkɔ gbɛlɛyara dunuɲa fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nba, a fɔra Yakuba yɛ ko suman ye sɔrɔnna Misiran tuma mɛnna, a ka a fɔ a dencɛilu yɛ ko: «Nfenna ai siini ai ɲɔɔn dagbɛla yan ten? ");
INSERT INTO msc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","N da a mɛn ko suman ye sɔrɔnna Misiran. Ai ye wa do san an yɛ, sa an kana faa kɔnkɔ bolo yan.» ");
INSERT INTO msc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Wo rɔ, Yusufu kɔrɔcɛilu mɔɔ tan wulira ka wa suman san diya Misiran, ");
INSERT INTO msc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","kɔni Yakuba ma sɔn Yusufu dɔɔcɛ Bɛniyaminu ye wa a kɔrɔcɛilu kɔfɛ, baa Yakuba silanni tɛrɛ ko kojuu kana a sɔrɔn sila la. ");
INSERT INTO msc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Isirayɛli dencɛilu ni mɔɔ gbɛrɛilu wara suman san diya Misiran, baa kɔnkɔ tɛrɛ ye Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Wo ka a tɛrɛn, Yusufu ye jamana kuntiiya la Misiran. Ale le tɛrɛ suman sanna mɔɔ bɛɛ ma. Wo le ka a kɛ, a kɔrɔcɛilu nara Yusufu ma, ka ii majii a kɔrɔ, ka ii kun majii. ");
INSERT INTO msc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu ka a kɔrɔcɛilu yen tuma mɛn na, a ma fili ii ma, kɔni a ka a kɛ ikomin a ma ii lɔn. A jamanda ii ma ka a fɔ ko: «Ai bɔni mi?» Ii ka a jabi: «An bɔni Kanaan jamana le rɔ, ka na suman ɲinin diya yan.» ");
INSERT INTO msc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusufu ma fili a kɔrɔcɛilu ma, kɔni woilu filira ale ma. ");
INSERT INTO msc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu hankili bilara a la siboilu rɔ, a ka a kɔrɔcɛilu yen sibo rɔ ɲa mɛn ma. A ka a fɔ ii yɛ ko: «Ai nani jamana lakɔrɔsi diya le, sa ai ri a lɔn ai ri se an na ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ii ka a jabi: «An tii, wo kuma tɛ! Ande, i la jɔnilu nani suman san diya le dɔrɔn. ");
INSERT INTO msc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","An bɛɛ ye cɛɛ kelen den de ri. Mɔɔ telenniilu le ande ri. An tɛ jamana si lakɔrɔsila.» ");
INSERT INTO msc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusufu ka a fɔ ko «Ɛɛn de! Ai nani jamana lakɔrɔsi diya le.» ");
INSERT INTO msc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ii ka a fɔ ko: «An ye i la jɔnilu le ri. An bɛɛ ye fa kelen de la. An fa siini Kanaan jamana le rɔ. A dencɛilu tɛrɛ mɔɔ tan ni fila le ri. An dɔɔcɛ ye an fa dafɛ ye bi. A tɔ kelen da sa.» ");
INSERT INTO msc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusufu ka a fɔ ko: «N ka a fɔ ɲa mɛn ma, a ye wo ɲa kelen de ma jɔ! Ai nani jamana lakɔrɔsi diya le! ");
INSERT INTO msc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","N di ii la kuma fɛsɛfɛsɛ ɲa mɛn ma, wo le ye ɲin di. Ni ai dɔɔcɛ dɔɔmani ma na yan, ai tɛ bɔ yan fewu. N ye n kali la wo la Misiran mansa tɔɔ le rɔ. ");
INSERT INTO msc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ai mɔɔ kelen ye wa ai dɔɔcɛ ta ka na a ri. Ai tɔilu ri wo makɔnɔ kaso la yan. Wo rɔ, n di ai la kuma fɛsɛfɛsɛ. Ni ai ka tuɲa le fɔ, n di wo lɔn. Ni wo tɛ, ai ma na foyi kanma, fo ka an na jamana lakɔrɔsi dɔrɔn. N ye n kalila wo rɔ Misiran mansa tɔɔ le rɔ!» ");
INSERT INTO msc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Wo rɔ, a ka ii bila kaso la. Ii ka tele sawa kɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","A tele sawana, Yusufu ka a fɔ ii yɛ ko: «Nba, n silanni Alla yɛ. Wo rɔ, n ye mɛn fɔla ai yɛ, ai ye wo mira, sa ai ri kisi. ");
INSERT INTO msc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ni mɔɔ telenniilu le ai ri, mɔɔ kelen ye to kaso la yan ai bɛɛ nɔ rɔ. Ai tɔilu ye wa suman di ai la denbaya kɔnkɔto ma, ");
INSERT INTO msc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","kɔni a fɛrɛ tɛ fo ai ye na ai dɔɔcɛ dɔɔmani ri yan. A wa na, n di a lɔn ko ai ka tuɲa le fɔ n yɛ, sa ai kana faa.» Ii sɔnda wo ma. ");
INSERT INTO msc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ii ka a fɔ i ɲɔɔn yɛ ko: «Sika tɛ a rɔ, tɔrɔya ɲin da an sɔrɔn Yusufu le kosɔn. Wo lon, a tɔrɔra an ɲakɔrɔ. A ka an madiya ko an ye hina a la, kɔni an ka an ban a rɔ. Wo le kosɔn kojuu ɲin da an sɔrɔn bi.» ");
INSERT INTO msc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubɛn ka a fɔ ii yɛ ko: «N ma a fɔ ai yɛ ko ai kana kojuu kɛ den na wa, kɔni ai ma sɔn n na kuma ma? Nba, a jeli ɲininkali le ɲin ka a hakɛ bɔ an dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ii ma a lɔn ko Yusufu tolo ye ii kan na, baa ii ni Yusufu wa kuma, kan nataminna ri ii kan natamin i ɲɔɔn ma. ");
INSERT INTO msc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu ka a mabɔ ii la ka wa kasi. A kɔsɛ mɛn kɛni, a kumara ii yɛ, ka ban ka Simeyɔn bɔ ii rɔ ka a bolo sidi ii ɲana. ");
INSERT INTO msc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu ka a fɔ a la mɔɔilu yɛ ko ii ye a kɔrɔcɛilu la bɔrɔilu lafa suman na, ka ii kelen kelenna bɛɛ la wodi bila ii la bɔrɔ woilu kɔndɔ, ka suman fanan di ii ma ka a kɛ ii sila fanda ri. Ii ka wo bɛɛ kɛ ikomin Yusufu ka a fɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ii ka bɔrɔilu la ii la faliilu kɔ kan, ka sila mira ka wa. ");
INSERT INTO msc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Su kora ii ma tuma mɛn na, ii ka ii lɔ yɔrɔ do rɔ ka sii ye. Mɔɔ kelen ka a la bɔrɔ da laka ko a ye dɔɔnnin dila a la fali ma. A ka a la wodi yen bɔrɔ kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","A ka a fɔ a badenmailu yɛ ko: «N na wodi a ra lasɛ n ma. A ye n na bɔrɔ kɔndɔ yan.» Ii kɔndafilira kojuuya. Ii kɔndakaliyara ka a fɔ ii ɲɔɔn yɛ ko: «Alla ra nfen de kɛ an na ɲin de ten?» ");
INSERT INTO msc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nba, ii se mɛn kɛni ii fa Yakuba wara Kanaan jamana rɔ, ko mɛn ka ii sɔrɔn, ii ka wo bɛɛ dantɛɛli kɛ a yɛ. Ii ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«Misiran jamana kuntii jamanda an ma kosɛbɛ! A ka an jalaki ko an wani ii la jamana lakɔrɔsi diya le. ");
INSERT INTO msc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","An ka a jabi an ye mɔɔ telenniilu le ri, ko an ma jamana si lakɔrɔsi fɔlɔ habadan. ");
INSERT INTO msc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","An ka a fɔ ko an bɛɛ ye fa kelen de la, ko an mɔɔ tan ni fila le tɛrɛ an fa bolo. Ko kelen da sa. Ko an dɔɔcɛ dɔɔmani ye an fa dafɛ ye Kanaan jamana rɔ, ");
INSERT INTO msc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","kɔni jamana kuntii wo ka a fɔ ko a ri a lɔn ko an ye mɔɔ telenniilu ri ɲa mɛn ma, ko wo le ye ɲin di. Ko an ye mɔɔ kelen to a bolo ye, ka na suman di an wara mɔɔilu kɔnkɔto ma. ");
INSERT INTO msc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ko an ye wa an dɔɔcɛ dɔɔmani ri a ma. Wo wa kɛ, ko a ri a lɔn ko an ma wa jamana lakɔrɔsi kanma, ko a ri a lɔn ko an ye mɔɔ telenniilu le ri, kosa a ri an badenma bɔ kaso la. Ko a ri jamana bɛɛ labila an yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Nba, ii ka suman nabɔ ii la bɔrɔilu kɔndɔ tuma mɛn na, ii bɛɛ ka ii la wodi bila bɔrɔneilu sidini yen suman bɔrɔilu kɔndɔ. Ii ni ii fa ka wodi sidini wo yen tuma mɛn na, ii bɛɛ silanda. ");
INSERT INTO msc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ii fa Yakuba ka a fɔ ii yɛ ko: «Ɛɛ! Ai ye n denilu bɔla n bolo. Yusufu tɛ yan butun. Simeyɔn fanan tɛ yan butun. Sisen ai ye a fɛ ka Bɛniyaminu fanan mira ka wa wo ri. Ɲin tɔrɔya bɛɛ ye nde le kan.» ");
INSERT INTO msc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubɛn ka a fɔ a fa yɛ ko: «I ye Bɛniyaminu karifa nde la. N di a lasɛ i ma. Ni n ma na Bɛniyaminu ri, i ye n dencɛ fila bɛɛ faa Bɛniyaminu nɔ rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakuba ka a fɔ ko: «Ɛɛn de! N dencɛ tɛ wala ai kɔfɛ! A kɔrɔcɛ Yusufu ra sa ka wo kelen pe to. Sisen n da kɔrɔ. Ni ko ka ale fanan sɔrɔn taama rɔ, n di faa jusumakasa bolo.» ");
INSERT INTO msc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nba, kɔnkɔ juuyara jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakuba dencɛilu nara suman mɛn di ka bɔ Misiran, wo bantɔla le tɛrɛ. Wo rɔ, Yakuba ka a fɔ ii yɛ ko: «Ai ye wa suman do san an yɛ Misiran.» ");
INSERT INTO msc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A dencɛ Yahuda ka a jabi: «Cɛɛ wo ka a fɔ an yɛ le ka a magbɛlɛya kosɛbɛ ko an tɛ a yen butun fo an dɔɔcɛ wa kɛ an kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ni i sɔnda an dɔɔcɛ Bɛniyaminu ye wa an kɔfɛ, an di wa ka suman san i yɛ. ");
INSERT INTO msc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ni i kɔnin ma sɔn, an tɛ wa ye, baa cɛɛ wo ka a fɔ an yɛ ko an tɛ a yen butun fo an dɔɔcɛ wa kɛ an kɔfɛ.» ");
INSERT INTO msc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isirayɛli ka a fɔ ko: «Ai ra kojuu kɛ n na de! Nfenna ai ka a fɔ cɛɛ wo yɛ ko ai dɔɔcɛ ye ai kɔma?» ");
INSERT INTO msc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A dencɛilu ka a jabi: «Cɛɛ wo ka ɲininkali siyaman kɛ an kun, ka an maɲininka an na ko ma, a ni an na denbaya la ko ma. A ka a fɔ ko: ‹Ai fa kɛndɛ wa? Ai dɔɔcɛ ye ye?› An ka a jabi ten tuun. An ma wo lɔn ko a ri a fɔ an yɛ ko an ye wa an dɔɔcɛ ri.» ");
INSERT INTO msc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yahuda ka a fɔ a fa Isirayɛli yɛ ko: «N fa, i ye n dɔɔcɛ karifa n na, sa an di wa i kɔrɔ. Wo wa kɛ, kɔnkɔ tɛ ile ni ande a ni an denilu faa yan. ");
INSERT INTO msc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nde jɛrɛ ri n lɔ den kunko la. Ni ko ka a sɔrɔn, i ye nde maɲininka. Ni n ma na a ri i ma, ka a lalɔ i ɲakɔrɔ, wo jalakili tɛ bɔ n kan habadan. ");
INSERT INTO msc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ni an kɔnin tun ma lanɔɔ yan, sa an da wa ka na siɲa fila.» ");
INSERT INTO msc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ii fa Isirayɛli ka a fɔ ko: «Nba, diyagboya le. Wo rɔ, ai ye an na jamana fen ɲuma doilu bila ai la bɔrɔilu kɔndɔ ka jamana kuntii wo sanba. Ai ye tulu do ta, a ni li ni wusulan ni latikɔlɔn ni jiriden doilu, pisitasi ni amande kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ai wara wodi mɛn di fɔlɔ, ai ye wo ɲɔɔn fila ta, baa wodi mɛn bilani tɛrɛ ai la bɔrɔilu kɔndɔ, fo ai ye ai kɔsɛ wo ri. Ai ri a sɔrɔn, ii ɲinanin de. ");
INSERT INTO msc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nba, ai ye ai dɔɔcɛ ta ka wa cɛɛ wo tɛrɛn ye sisen. ");
INSERT INTO msc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Alla Sebɛɛtii ye ai la hina don a rɔ, kosa a ri Bɛniyaminu ni Simeyɔn nasɛ ai ma, kɔni ni n bɔnɔra n deni la, n di bɔnɔ wo rɔ kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Wo rɔ, ii ka Bɛniyaminu ta, a ni sanba fenilu, a ni wodi wo ɲɔɔn fila, ka sila mira ka wa Misiran. Ii se mɛn kɛni ye, ii wara Yusufu tɔrɔfɛ, ka ii lɔ a ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu ka Bɛniyaminu yen ii fɛ tuma mɛn na, a ka a fɔ a la bon kunnasiila yɛ ko: «Wa mɔɔ ɲinilu ri n na bon na, ka kolofen do faa ka a tibi. Ii kɛtɔ telerɔ dɔɔnnin kɛla nde le fɛ bi.» ");
INSERT INTO msc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Cɛɛ wo ka ii malɔ Yusufu la bon na ikomin Yusufu ka a fɔ a yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ii watɔla Yusufu la bon na, wo ka ii masilan. Ii ka a fɔ ko: «An da lana yan wodi ko le rɔ, wodi mɛn bilara an na bɔrɔilu kɔndɔ an na ko fɔlɔ rɔ. Ii kɛtɔ bela an kan de, ka an na faliilu ta, ka an mira ka an kɛ jɔnilu ri.» ");
INSERT INTO msc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Wo rɔ, ii ka i madon Yusufu la bon kunnasiila la bonda la ka kuma a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ii ka a fɔ ko: «An fa, hakɛ to an yɛ. Waati taminni, an nara suman san diya yan. ");
INSERT INTO msc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","An bɔ mɛn kɛni yan, an ka an lɔ an sii diya. An ka an na bɔrɔilu da laka ka wodi bilani yen bɔrɔilu kɔndɔ. An na wodi bɛɛ le tɛrɛ, an ka mɛn san suman na. Wodi wo nani an bolo ka a lasɛ ai ma. ");
INSERT INTO msc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Suman sankɔ fanan nani an bolo, kɔni mɛn ka wodi do wo bila an na bɔrɔilu rɔ wo lon, an ma wo lɔn.» ");
INSERT INTO msc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bon kunnasiila ka ii jabi: «Ai kana hamin wo la. Ai kana silan. Ai Maari Alla a ni ai fa Maari Alla, wo le ka wodi wo bila bɔrɔilu kɔndɔ ai yɛ. Ni wo tɛ, ai ka suman sankɔ mɛn bɔ, n ka wo sɔrɔn.» Wo rɔ, cɛɛ wo wara Simeyɔn ta ka na a di ii ma, ");
INSERT INTO msc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ka ii bɛɛ ladon Yusufu la bon na. A ka ji di ii ma ko ii ye ii sen mako. A ka dɔɔnnin di ii la faliilu fanan ma. ");
INSERT INTO msc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ii nara sanba fen mɛnilu ri, ii ka woilu labɔ ka Yusufu makɔnɔ, baa a fɔra ii yɛ ko a ri na telerɔ dɔɔnnin diya ii fɛ ye. ");
INSERT INTO msc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu sera a wara tuma mɛn na, ii nara a la sanbailu di a ma bon na ka ii majii a kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusufu ka ii fo ko: «Tana tɛ ai la? Wo lon, ai ka ai fa la ko fɔ n yɛ ko a ra kɔrɔya. Ale don? A kɛndɛ fɔlɔ?» ");
INSERT INTO msc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ii ka Yusufu jabi: «Tana si tɛ an fa la, i la jɔncɛ kɔnin. A kɛndɛ.» Ii ka ii kun majii Yusufu kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu ka a ɲanakalan ka a dɔɔcɛ Bɛniyaminu yen, a jɛrɛ na la den. A ka a fɔ ko: «Ai ka ai dɔɔcɛ mɛn na ko fɔ, wo le ye ɲin di wa?» Ii ka a fɔ ko: «Ɔɔn, ale le.» Yusufu ka a fɔ a yɛ ko: «N den, Allama ɲumaya kɛra i yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Bɛniyaminu hina donda Yusufu la kosɛbɛ. Wo rɔ, a kasitɔla le tɛrɛ. A ka bɔ ii tɔrɔfɛ i kɔrɔ ka wa a jɛrɛ la bon kɔndɔ ka kasi. ");
INSERT INTO msc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","A ka ban kasila tuma mɛn na, a ka a ɲa lako, ka wa ii tɛrɛn ye. A ka a jɛrɛ mira ka a fɔ a la mɔɔilu yɛ ko ii ye na balo di ii ma. ");
INSERT INTO msc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ii ka Yusufu la balo bɔ a la a dan na, ka a badenmailu ta bɔ a dan na. Misiranka mɛnilu tɛrɛ ye, ii ka woilu fanan ta bɔ a dan na, baa Misirankailu ti sɔn ka dɔɔnnin kɛ Heburuilu fɛ. Ii tana le wo ri. ");
INSERT INTO msc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusufu ka a badenmailu lasii a ɲakɔrɔ, ka ii tuun i ɲɔɔn na ka bɛn ii si kasabiya ma, ka a damira kɔrɔmamɔɔ ma ka wa se dɔɔmamɔɔ ma. Ii ka ii siiɲa wo yen tuma mɛn na, ii ka i ɲɔɔn dagbɛ ka kabannakoya. ");
INSERT INTO msc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Balo mɛn tɛrɛ ye Yusufu kɔrɔ, a la mɔɔilu ka a badenmailu bɛɛ sɔ wo le rɔ. Bɛniyaminu ka mɛn sɔrɔn, wo kɛra a kɔrɔcɛilu ta ɲɔɔn loolu le ri. Ii ka dɔɔnnin kɛ ka ii min, ka sɛwa Yusufu la kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nba Yusufu ka a fɔ a la bon kunnasiila yɛ ko: «Ii la bɔrɔilu lafa suman na. Ii la faliilu di se donin mɛn kɔrɔ, i ye wo jate di ii ma. I wa bɔrɔilu lafa, i ye ii kelen kelenna bɛɛ la wodi la suman kan ii la bɔrɔilu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","I ye n na wodigbɛ minninfen bila dɔɔmamɔɔ la bɔrɔ kɔndɔ a la wodi kan.» Bon kunnasiila ka wo bɛɛ kɛ ikomin Yusufu ka a fɔ a yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wo duusagbɛni jona Yusufu ka sila di ii ma. Ii ka ii la doninilu la ii la faliilu kɔ kan, ka wa. ");
INSERT INTO msc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ka a tɛrɛn ii ma janfa so la fɔlɔ, Yusufu ka a fɔ a la bon kunnasiila yɛ ko: «Wa ii kɔ! I wa se ii ma tuma mɛn na, i ye a fɔ ii yɛ ko: ‹Nfenna ai ka koɲuma sara kojuu la? ");
INSERT INTO msc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nfenna ai ka n tii la minninfen sonya? A ye a minna wo le la, a ye ɲaɲinin kɛla wo le la. Ai ra kojuu ba le kɛ ɲin di de!›» ");
INSERT INTO msc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bon kunnasiila wara se ii ma tuma mɛn na, a kumara ii yɛ ikomin Yusufu ka a fɔ a yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ii ka a jabi: «An tii, nfenna i ye an jalakila ten? An tɛ ko su wo kɛla fewu! ");
INSERT INTO msc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","I jɛrɛ ka a lɔn ko an nani wodi ri an na bɔrɔilu kɔndɔ wo lon, ka bɔ Kanaan jamana rɔ ka na wodi wo di i ma. A ye di? An di wodigbɛ wala sanin sonya i tii la bon na wo rɔ wa? ");
INSERT INTO msc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","An tii, ni i ka minninfen yen an si kunma, wo tii ri faa. Ka a la wo kan fanan, an tɔilu ri kɛ i la jɔnilu ri.» ");
INSERT INTO msc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bon kunnasiila ka a fɔ ko: «Ale le wo ri, n da diɲɛ wo ma, kɔni minninfen wa yen mɔɔ mɛn kunma, wo ri kɛ n na jɔn di. Ai tɔilu tɛ jalakili.» ");
INSERT INTO msc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Wo yɔrɔ wo rɔ, ii ka ii la bɔrɔilu lajii duu ma ka ii da laka. ");
INSERT INTO msc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Bon kunnasiila ka bɔrɔilu ragbɛ. A ka a damira kɔrɔmamɔɔ ta ma, ka wa se doomamɔɔilu ta ma. A ka minninfen yen Bɛniyaminu la bɔrɔ kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wo le rɔ, ii ka ii la durukiilu rafara ii kan na jusukasi bolo ma. Ii ka ii la bɔrɔilu la faliilu kɔ kan, ka ii kɔsɛ so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yahuda ni a badenmailu sera Yusufu wara ka a tɛrɛn a ye ye fɔlɔ. Ii ka ii la duu ma a kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusufu ka a fɔ ii yɛ ko: «Ai na nfen ko kɛla ɲin ten? Ai ma a lɔn ko nde ɲɔɔn di ɲaɲinin kɛ ka koilu lɔn wa?» ");
INSERT INTO msc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda ka a fɔ ko: «N tii, an ti se foyi fɔla. Kuma tɛ an bolo butun. An ti se an bɔla ko ɲin dɔ. Alla jɛrɛ le ra an sɔnjuu labɔ gbɛ rɔ. An bɛɛ ye i la jɔnilu le ri sisen, minninfen yenni mɛn kunma, a ni an tɔilu bɛɛ.» ");
INSERT INTO msc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusufu ka a jabi kɔnin ko: «Ka ii bɛɛ jalaki ten, n tɛ ko su wo kɛla fewu! Minninfen yenni mɛn kunma, wo le kɛtɔ n na jɔn di. Ai tɔilu ye wa hɛrɛ rɔ ai fa wara.» ");
INSERT INTO msc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yahuda ka a madon Yusufu la, ka a fɔ a yɛ ko: «N tii, i jaandi, i ye diɲɛ n ye kuma i yɛ. N ka a lɔn ko i ni Misiran mansa bɛɛ ka kan. I kana mɔnɛ n ma. ");
INSERT INTO msc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","N tii, an na ko fɔlɔ yan, i ka an maɲininka an fa ni an badenmailu ma. ");
INSERT INTO msc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","An ka i jabi an fa ye ye, ko a ra kɔrɔya kosɛbɛ. Ko an dɔɔcɛ dɔɔmani fanan ye ye, an fa kɔrɔyanin ka mɛn sɔrɔn. Doomamɔɔ wo kɔrɔcɛ ra faa, ka a kelen pe to. Dogbɛrɛ tɛ ye butun, a ni mɛn ye na kelen na. A la ko duman an fa yɛ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","I ka a fɔ an yɛ ko an ye na a ri yan, kosa i ɲa ri la a kan. ");
INSERT INTO msc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","An ka a fɔ i yɛ wo lon ko den ti se bɔ la an fa tɔrɔfɛ. Ni a bɔra a tɔrɔfɛ an fa ri faa, ");
INSERT INTO msc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","kɔni, an tii, i ka an jabi ni an dɔɔcɛ ma na an kɔfɛ yan, ko an tɛ i yen butun. ");
INSERT INTO msc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«Wo rɔ, an ka an kɔsɛ an fa wara tuma mɛn na, an ka i la kuma lase a ma. ");
INSERT INTO msc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Lon do rɔ, an fa ka a fɔ ko an ye na suman do san ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","An ka a jabi an ti se nala suman san diya fo an dɔɔcɛ wa na an kɔfɛ, baa cɛɛ wo ka a fɔ ko an tɛ a yen butun fo an dɔɔcɛ wa kɛ an kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","An fa ka a fɔ an yɛ ko an ka a lɔn ko a muso Rasɛli ka dencɛ fila-pe le sɔrɔn a yɛ. ");
INSERT INTO msc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ko kelen da tunun a ma. Ko a miri rɔ, ko wara juu le ka a mira ka a rafarafara. Ko kɛbi wo lon, a ma a yen butun. ");
INSERT INTO msc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ko ni an wara do ɲin fanan di don? Ni ko ka a sɔrɔn taama rɔ, ko a kɔrɔyani ri faa niilafin dɔ. An fa kan ten. ");
INSERT INTO msc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Nba, ni n ka n kɔsɛ i la jɔncɛ, n fa, ma sisen ka den to n kɔ yan, wo tɛ bɛn. Den wo le ye n fa la ko bɛɛ ri. ");
INSERT INTO msc_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","N fa wa a yen tuma mɛn na ko den wo ma a kɔsɛ an fɛ, a ri faa. An fa kɔrɔyani ri faa jusumakasa rɔ, wo le rɔ an di kɛ wo sababu ri. ");
INSERT INTO msc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ka a la wo kan, n ka n lɔ den na kunko la. N ka a fɔ n fa yɛ ko ni n ma kɔsɛ den di a ma, n fa hakɛ ri to nde kan kadawu. ");
INSERT INTO msc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","I jaandi, i ye n kɛ i la jɔn di den nɔ rɔ, kosa den di a kɔsɛ a kɔrɔcɛilu kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","N ye n kɔsɛla n fa ma di, ni den tɛ n bolo? N tɛ i se n fa jusumakasani yenna fewu.» ");
INSERT INTO msc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nba, Yahuda banni kumala, Yusufu ma se a jɛrɛ mirala a la jɔnilu ɲana. A ka ii jamari ko ii bɛɛ ye bɔ. Mɔɔ gbɛrɛ si tun tɛ ye tumana mɛn na, fo Yusufu ni a badenmailu, Yusufu ka a jɛrɛ yiraka ii la. ");
INSERT INTO msc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","A kasira kosɛbɛ, fo Misirankailu ka a kasi kan mɛn kɔkan. Wo ko fɔra mɔɔilu ɲana Misiran mansa wara. ");
INSERT INTO msc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu ka a fɔ a badenmailu yɛ ko: «Yusufu le nde ri! N fa kɛndɛ wa?» Yusufu badenmailu ma se a jabila, baa ii silanni tɛrɛ kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu ka a fɔ ko: «Ai ye i madon n na.» Ii ka i madon a la tuma mɛn na, a ka a fɔ ko: «Ai badenma Yusufu le nde ri, ai ka mɛn san Isumayila bɔnsɔn julailu ma mɛn ye taala Misiran. ");
INSERT INTO msc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ai jusu kana a lafin. Ai kana mɔnɛ ai jɛrɛ ma n san ko rɔ. Alla le ka n nana ai ɲɛ yan sa n di kɛ sababu ri ka mɔɔilu kisi kɔnkɔ ma. ");
INSERT INTO msc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kɔnkɔ san fila le jamana kɔndɔ ɲin. A ra to san loolu le ma, sɛnɛkɛlailu ti nala foyi sɔrɔnna sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Alla le ka n lɔ ai ɲɛ yan ka an to yan an fa bɔnsɔnilu kisibaya kanma, sa ai bɔnsɔn kana tunun dunuya ma. ");
INSERT INTO msc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aile ma n nana yan de. Alla le ka n nana yan ka n kɛ Misiran mansa lalila ri, ka n nasii mansa la bon kun na, ka n nasii Misiran jamana bɛɛ kun na. ");
INSERT INTO msc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ai ye ai kaliya ka i kɔsɛ n fa ma. Ai ye a fɔ a yɛ ko a dencɛ Yusufu ka a fɔ ko Alla ra a lasii Misiran jamana bɛɛ kun na. Ko a ye a kaliya ka na n tɛrɛn yan. ");
INSERT INTO msc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ko a ri a sii Kosɛni jamana rɔ, ka to n tɔrɔfɛ yan. Ko a ye na, a ni a la denilu ni a la mamarenilu ni a la kolofenilu ni a bolofen bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ko n di ii balo, baa kɔnkɔ ri san loolu kɛ fɔlɔ. Sa a ni a la mɔɔ bɛɛ kana bolokolonya kojuuya.» ");
INSERT INTO msc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusufu ka a fɔ ko: «Nba, ai ɲayen n na sisen. N dɔɔcɛ Bɛniyaminu fanan ɲayen n na. Ai ra a yen ko Yusufu jɛrɛ le kumala ai yɛ. ");
INSERT INTO msc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mɔɔilu ye n bonyala ɲa mɛn ma Misiran yan, ai ye wo fɔ n fa yɛ. Ai ra fen fen yen ai ɲa la yan, ai ye wa wo bɛɛ fɔ a ye, ka ban ka na a ri jona.» ");
INSERT INTO msc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Nba, Yusufu ka a ton a dɔɔcɛ Bɛniyaminu kan ka kasi. Bɛniyaminu fanan ka a ton a kan ka kasi. ");
INSERT INTO msc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusufu kasimantɔ ka a ton a kɔrɔcɛ kelen kelenna bɛɛ kan ka ii sunbu. Wo le ka a kɛ, a kɔrɔcɛilu ka kuma damira a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nba, Yusufu badenmailu na ko fɔra Ferawuna wara tuma mɛn na, wo diyara mansa ni a la ɲɛmɔɔ bɛɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mansa ka Yusufu kili ka a fɔ a yɛ ko: «A fɔ i badenmailu yɛ ko ii ye ii doninilu la ii la faliilu kɔ kan ka ii kɔsɛ Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Ii wa se ye, ii ye ii fa ni ii la mɔɔ bɛɛ ta ka na ii ri n ma. N di duu ɲuma di ii ma, mɛn ka ɲi duu bɛɛ ri Misiran. Ii ri an na jamana balo ɲuma dɔɔn. ");
INSERT INTO msc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","I ye a fɔ i badenmailu yɛ fanan ko ii wa kɛ wala, ii ye wontoro doilu ta Misiran yan. Ii wa se ii fa wara, ii ri ii musoilu ni ii denilu ni ii fa lasii wontoro woilu kɔndɔ ka na woilu ri yan. ");
INSERT INTO msc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ni ii bolofen doilu tora ii kɔ ye, ii kana hamin woilu la, baa Misiran fen ɲumaɲumailu le ditɔ ii ma yan.» ");
INSERT INTO msc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nba, Misiran mansa ka mɛn fɔ Isirayɛli denilu yɛ, ii ka wo kɛ. Yusufu ka wontoroilu di ii ma, ka bɛn mansa la kuma ma. A ka sila fanda suman fanan di ii ma. ");
INSERT INTO msc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A ka faanin kura di ii kelen kelenna bɛɛ ma, kɔni a ka wodigbɛ kɛmɛ sawa ni faanin kura loolu di Bɛniyaminu ma. ");
INSERT INTO msc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A ka a fa sanba falicɛ tan ni falimuso tan na. A ka falicɛ woilu donin Misiran fen ɲumailu la, ka falimusoilu donin sumankisɛ ni buru ni dɔɔnninfen gbɛrɛilu la, mɛnilu ri a fa balo taama rɔ. ");
INSERT INTO msc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","A ka sila di a badenmailu ma wo rɔ ka a fɔ ii yɛ ko: «Ai kana silan de!» ");
INSERT INTO msc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ii bɔra Misiran ka wa ii fa Yakuba tɛrɛn Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ii seni ye, ii ka a fɔ a yɛ ko: «Yusufu kɛndɛ le! Ale le jɛrɛ siini Misiran jamana bɛɛ kun na sisen.» Kuma wo bararɔ Yakuba rɔ fo ka a dan natamin. A ma la a la fewu. ");
INSERT INTO msc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","A dencɛilu ka Yusufu la kuma bɛɛ lase a ma tuma mɛn na, Yakuba ka wo bɛɛ mɛn ka wontoroilu yen fanan, Yusufu ka mɛnilu lana a ta kanma. Wo le rɔ, a sɛwara ka a ɲaalen. ");
INSERT INTO msc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A ka a fɔ ko: «N dencɛ Yusufu kɛndɛ fɔlɔ! Nde tɛ foyi ɲininna butun ka tamin wo kan. N di wa n ɲa la a kan sisen sani n ye sa.» ");
INSERT INTO msc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wo rɔ, Isirayɛli ka a bolofen bɛɛ ta ka sila mira ka wa Misiran. A sera Bɛri-Seba, a ka saraka bɔ ka a di a fa Isiyaka Maari Alla ma. ");
INSERT INTO msc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Su wo rɔ, Alla ka Isirayɛli kili ko: «Yakuba, Yakuba!» A ka jabi: «Naamun.» ");
INSERT INTO msc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Alla ka a fɔ ko: «N ye i fa Maari Alla le ri. I kana silan Misiran taa ko rɔ, baa n di i bɔnsɔn siyaya ye kosɛbɛ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","N jɛrɛ di wa i kɔfɛ Misiran. N jɛrɛ le kɛtɔ i bɔnsɔn nanala yan fanan. I sa tuma wa se, Yusufu jɛrɛ ri i ɲakisɛ latunun.» ");
INSERT INTO msc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Wo rɔ, Yakuba wulira ka bɔ Bɛri-Seba. A dencɛilu ka a ladon wontoro kɔndɔ, Misiran mansa ka mɛn nana a ta kanma. Ii ka ii denilu ni ii musoilu fanan nadon wontoroilu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ii ka ii la kolofenilu fanan ta, a ni ii bolofenilu bɛɛ, ii ka mɛnilu sɔrɔn Kanaan jamana rɔ. Yakuba ni a la denbaya bɛɛ wara Misiran wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A dencɛilu bɛɛ wara a kɔfɛ, a ni a denmusoilu, a ni a mamarenilu, a la denbaya bɛɛ kɔnin. Woilu bɛɛ wara Misiran Yakuba kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nba Isirayɛlika mɛnilu wara Misiran, Yakuba ni a la dencɛilu kɔnin, wo tɔɔilu le ɲin di. Yakuba dencɛ fɔlɔ tɔɔ le ko Rubɛn. ");
INSERT INTO msc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubɛn dencɛilu le ten: Hanɔki, Palu, Hɛsirɔn a ni Karimi. ");
INSERT INTO msc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeyɔn, wo dencɛilu le ten: Jɛmuwɛli, Jamin, Owadi, Jakin, Sohari, Sawuli. Sawuli na tɛrɛ Kanaanka do le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lebi, wo dencɛilu le Kerisɔn ni Kohati ni Merari ri. ");
INSERT INTO msc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, wo dencɛilu le ten: Ɛri, Onan, Sela, Pɛrɛsi a ni Serahi, kɔni Ɛri ni Onan sara Kanaan jamana rɔ. Pɛrɛsi dencɛilu le Hɛsirɔn ni Hamuli ri. ");
INSERT INTO msc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakari, wo dencɛilu le ten: Tola, Puwa, Yɔbu a ni Simirɔn. ");
INSERT INTO msc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sabulɔn, wo dencɛilu le Serɛdi ni Elɔn ni Jalɛli ri. ");
INSERT INTO msc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Leya ka dencɛ mɛnilu sɔrɔn Yakuba yɛ Padani Aramu, woilu le woilu ri. A ka denmuso do fanan sɔrɔn a yɛ ye, mɛn tɔɔ ko Dina. Yakuba bɔnsɔn mɛnilu bɔni Leya rɔ, wo bɛɛ ladɛnnin kɛra mɔɔ bisawa ni mɔɔ sawa le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kadi, wo dencɛilu le ten: Sɛfɔn, Haki, Suni, Ɛsibon, Ɛriya, Arɔdi, a ni Arɛli. ");
INSERT INTO msc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛri, wo dencɛilu le ten: Imina, Isiba, Isibi a ni Beriya. Asɛri denmuso tɔɔ ko Sera. Beriya dencɛilu le Hebɛra ni Malikiyɛli ri. ");
INSERT INTO msc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Silipa wo tɛrɛ jɔnmuso le ri, Laban ka mɛn di a denmuso Leya ma. Yakuba bɔnsɔn mɛnilu bɔni Silipa rɔ, wo bɛɛ ladɛnnin kɛra mɔɔ tan ni wɔɔrɔ le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakuba muso Rasɛli dencɛilu le Yusufu ni Bɛniyaminu ri. ");
INSERT INTO msc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Asanati ka dencɛ fila sɔrɔn Yusufu yɛ Misiran. Do tɔɔ ko Manase. Do tɔɔ ko Efirayimu. Asanati tɛrɛ Potifera denmuso le ri, mɛn tɛrɛ ye Ɔni so mɔɔilu la joo sarakalasela ri. ");
INSERT INTO msc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bɛniyaminu dencɛilu le ten: Bela, Bekeri, Asibɛli, Kera, Naman, Ɛhi, Rɔsi, Mupimi, Hupimi a ni Aridi. ");
INSERT INTO msc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Rasɛli ka dencɛ mɛnilu sɔrɔn Yakuba yɛ, woilu le woilu ri. Yakuba bɔnsɔn mɛnilu bɔni Rasɛli rɔ, wo bɛɛ ladɛnnin kɛra mɔɔ tan ni naanin le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daan, wo dencɛ le Husimu ri. ");
INSERT INTO msc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafitali, wo dencɛilu le ten: Jasɛli, Kuni, Jesɛri, a ni Silɛmu. ");
INSERT INTO msc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilaha ka dencɛ mɛnilu sɔrɔn Yakuba yɛ woilu le woilu ri. Bilaha wo tɛrɛ jɔnmuso le ri, Laban ka mɛn di a denmuso Rasɛli ma. Yakuba dencɛ mɛnilu bɔni Bilaha rɔ, wo bɛɛ ladɛnnin kɛra mɔɔ wɔrɔnwula le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Mɔɔ mɛnilu wara Misiran Yakuba kɔfɛ, mɛnilu bɔni ale rɔ kɔnin, woilu bɛɛ ladɛnnin tɛrɛ mɔɔ biwɔɔrɔ ni mɔɔ wɔɔrɔ le ri. A biranmusoilu ma jate. ");
INSERT INTO msc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusufu ka dencɛ fila sɔrɔn Misiran. Nba, Yakuba la mɔɔ mɛnilu nara Misiran, wo bɛɛ ladɛnnin kɛra mɔɔ biwɔrɔnwula le ri. ");
INSERT INTO msc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nba, Yakuba ka Yahuda lawa a ɲɛ Misiran, ka wa a fɔ Yusufu yɛ ko ii ye i ɲɔɔn bɛn Kosɛni jamana rɔ. Yakuba ni a la mɔɔilu sera Kosɛni tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu donda a la sowontoro kɔndɔ ka wa a fa kunbɛn Kosɛni. A ka a fa yen tuma mɛn na, a ka a fa labɛn ka a kɛ a kɔnkɔndɔ ka kasi. A mɛnda kasila kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakuba ka a fɔ Yusufu yɛ ko: «Hali ni n sara bi, wo tɛ baasi ri, baa n da i yen, ka a lɔn ko i kɛndɛ le.» ");
INSERT INTO msc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu ka a fɔ a badenmailu ni a fa la tɔilu yɛ ko: «N di wa a fɔ mansa yɛ ko n badenmailu ni n fa la mɔɔilu bɛɛ ra bɔ Kanaan jamana rɔ ka na n ma. ");
INSERT INTO msc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","N di a fɔ a yɛ ko ai bɛɛ ye kolofen kɔnɔmadenilu le ri, ko ai la baara le kolofen namara ri. N di a fɔ a yɛ ko ai ra na ai la kolofen bɛɛ ri, a ni ai bolofenilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Wo rɔ, ni mansa ka ai kili ka ai la baara maɲininka, ");
INSERT INTO msc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ai ye a jabi: ‹An tii, an ye kolofen namarala le ri kɛbi an na denniya tumana. An benbailu bɛɛ ka wo baara le kɛ.› Ni ai ka a jabi wo ɲa mɛn ma, a ri sɔn ai ye ai sii Kosɛni jamana rɔ, baa kolofen kɔnɔmadenilu ma di Misirankailu yɛ muumɛ.» ");
INSERT INTO msc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Wo rɔ, Yusufu wara a fɔ Misiran mansa yɛ ko: «N fa ni n badenmailu ra na ka bɔ Kanaan jamana rɔ. Ii nani ii la kolofenilu ri, a ni ii bolofen bɛɛ. Ii ye Kosɛni sisen.» ");
INSERT INTO msc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusufu ka a badenma loolu yiraka mansa la, a ka mɛnilu lana wo kanma mansa wara. ");
INSERT INTO msc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mansa ka woilu maɲininka ko: «Ai la baara ye nfen di?» Ii ka mansa jabi: «An tii, an ye kolofen kɔnɔmadenilu le ri, ikomin an benbailu tɛrɛ ye ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","An nani sii diya ɲininna i wara yan, ka a masɔrɔn kɔnkɔ ra gbɛlɛya an kan Kanaan jamana rɔ. Kolofenilu la dɔɔnnin tɛ ye butun. Wo rɔ, an tii, an ye i madiyala, i jaandi, i ye diɲɛ an ye an sii Kosɛni jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Mansa ka a fɔ Yusufu yɛ ko: «I fa ni i badenmailu ra na i ma. ");
INSERT INTO msc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","An na jamana Misiran ye i ta le ri. Wa i fa ni i badenmailu lasii yɔrɔ ɲumaɲuma rɔ, yɔrɔ mɛn ka ɲi a tɔ bɛɛ ri. Ii ye ii sii Kosɛni. Ni i ka doilu sɔrɔn ii rɔ, mɛnilu kusan kolofen marala kosɛbɛ, i ye n na kolofen fanan don woilu bolo.» ");
INSERT INTO msc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusufu ka a fa Yakuba lana ka a yiraka mansa la. Yakuba duwara mansa yɛ. ");
INSERT INTO msc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Mansa ka Yakuba maɲininka ko: «N fa, i sɔrɔn da san yɛli bɔ?» ");
INSERT INTO msc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakuba ka a fɔ ko: «N da san kɛmɛ ni san bisawa sɔrɔn n na dunuɲaratɛɛ bɛɛ rɔ, wo bɛɛ rɔ, n si ma siya a ni n da tɔrɔya siyaman sɔrɔn. N si ma siyaya ikomin n failu ka si sɔrɔn ii la dunuɲaratɛɛ rɔ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakuba duwara mansa yɛ ikɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusufu ka duu di a fa ni a badenmailu ma ka ii lasii Misiran jamana rɔ ikomin mansa ka a fɔ a yɛ ɲa mɛn ma. Duu wo tɛrɛ ye Ramɛsisi le. Yɔrɔ wo ka ɲi jamana yɔrɔ tɔ bɛɛ ri. ");
INSERT INTO msc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu ka a fa ni a badenmailu ni a fa la mɔɔ balo, bɛɛ ni a la denbaya. ");
INSERT INTO msc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nba, kɔnkɔ juuyara kosɛbɛ, ka a masɔrɔn suman tun tɛ sɔrɔnna fan si. Mɔɔilu fanka tɛrɛ ye dɛsɛla kɔnkɔ bolola Misiran jamana ni Kanaan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Misirankailu ni Kanaankailu ka ii la wodi bɛɛ san Yusufu ma suman na. Yusufu ka wodi wo mira Misiran mansa yɛ ka wa a di a la bon na. ");
INSERT INTO msc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wodi banda Misirankailu ni Kanaankailu bolo la tuma mɛn na, Misiranka bɛɛ nara Yusufu tɛrɛn ka a fɔ a yɛ ko: «Suman di an ma. I kana sɔn an ye faa i ɲana ten. An na wodi bɛɛ ra ban fewu.» ");
INSERT INTO msc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu ka ii jabi: «Ni ai la wodi banda, ai ye na ai la kolofenilu ri, ka wa woilu falɔn suman na.» ");
INSERT INTO msc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Wo rɔ, ii nara ii la kolofenilu ri Yusufu ma. Soilu ni saailu ni bailu ni nisiilu ni faliilu, ii nara wo bɛɛ ri. Yusufu ka kolofen wo bɛɛ falen suman na, ka mɔɔilu balo san kelen wo kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","San wo taminni, ii nara Yusufu tɛrɛn ikɔ, ka a fɔ a yɛ ko: «An fa, i ka a lɔn ko an na wodi ra ban. An na kolofen bɛɛ ra kɛ i ta ri fanan. Foyi ma to an bolo fo an jɛrɛ ni an na duu. ");
INSERT INTO msc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","I jaandi, i kana sɔn an ye faa i ɲana ten, sa an na duu rakolon kana to. I ye an ni an na duu san suman na. An di kɛ mansa la jɔnilu ri. An na duu ri kɛ a ta ri. I ye suman di an ma, sa an di balo. I ye si di an ma, sa an na sɛnɛilu lakolon kana to.» ");
INSERT INTO msc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Wo rɔ, Yusufu ka Misiran duu bɛɛ san mansa yɛ. Misirankailu bɛɛ ka ii la sɛnɛilu san, ka a masɔrɔn kɔnkɔ ra juuya fɔɔ ka a dan natamin. Jamana duu bɛɛ kɛra mansa ta ri ɲa wo le ma. ");
INSERT INTO msc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ka bɔ jamana kun do la, ka wa bila a kun do la, Yusufu ka jamana mɔɔilu kɛ jɔnilu ri. ");
INSERT INTO msc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","A ka duu bɛɛ san, fɔɔ duu mɛn tɛrɛ ye mɔɔilu la joo sɔlailu bolo, baa mansa tɛrɛ ye mɔɔilu la joo sɔlailu sɔla suman na tuma bɛɛ. Suman wo kɛra woilu balo ri. Wo le kosɔn woilu ma ii la duu san. ");
INSERT INTO msc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusufu ka a fɔ mɔɔilu yɛ ko: «N da ai ni ai la duu san mansa yɛ bi. Nba, ai ye si ɲin ta ka wa a foyi ai la sɛnɛilu rɔ, ");
INSERT INTO msc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","kɔni ai wa suman mɛn ka, ai ye wo tala loolu ri, ka tala kelen di mansa ma. A tɔ naanin, ai ta le wo ri. Ai ye do kɛ si ri, ka do kɛ balo ri, sa ai ri ai jɛrɛ ni ai denilu ni ai wara mɔɔilu bɛɛ balo.» ");
INSERT INTO msc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ii ka Yusufu jabi: «An fa, i ra koɲuma kɛ an yɛ ka an kisi kɔnkɔ ma. An di kɛ mansa la jɔnilu ri.» ");
INSERT INTO msc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusufu ka sariya sii Misiran jamana rɔ ko mɔɔilu wa suman mɛn ka, wo ye tala loolu ri, ka tala kelen di mansa ma. Sariya wo siini ye fɔlɔ haan bi. Mɔɔilu la joo sarakalaselailu la duu le dɔrɔn ma kɛ mansa ta ri. ");
INSERT INTO msc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nba, Isirayɛli la mɔɔilu ka ii sii Kosɛni jamana rɔ Misiran. Ii ka nanfulu sɔrɔn ye ka jiri kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakuba si bɛɛ ladɛnnin kɛra san kɛmɛ ni san binaanin ni san wɔrɔnwula le ri. A ka san tan ni wɔrɔnwula kɛ Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A sa waati sudunyanin tuma mɛn na, a ka a dencɛ Yusufu kili ka a fɔ a yɛ ko: «Ni n duman i yɛ, i ye i bolo la n woro kɔrɔ ka lahidi ta n yɛ ko i ka kan ka ɲumaya mɛn kɛ n yɛ, i ri wo kɛ ka kankelentiiya kɛ n yɛ n na saya kɔ rɔ, ko i tɛ n su don Misiran jamana rɔ yan fewu. ");
INSERT INTO msc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","N ye a fɛ i ye n su don n benbailu su don diya. I ye n su ta ka bɔ Misiran ka wa a don diya wo rɔ.» Yusufu ka a fɔ ko: «N di a kɛ ikomin i ka a fɔ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakuba ka a fɔ ko: «I kali n yɛ.» Yusufu ka a kali a yɛ. Wo rɔ, Yakuba ka i birin a la lafen kun na ka Alla bato. ");
INSERT INTO msc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Waati wo taminni a fɔla Yusufu yɛ ko a fa ma kɛndɛ. Wo rɔ, a ka a dencɛ fila ta, Manase ni Efirayimu kɔnin, ka wa a fa tuwa. ");
INSERT INTO msc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","A fɔra Yakuba yɛ tuma mɛn na ko a dencɛ Yusufu ra na, a ka a raja ka i wuli, ka i sii a la lafen kan. ");
INSERT INTO msc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakuba ka a fɔ Yusufu yɛ ko: «Alla Sebɛɛtii bɔra gbɛ rɔ n yɛ Lusi so dafɛ Kanaan jamana rɔ, ka ɲumaya kɛ ka baraka don n na kɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","A ka a fɔ n yɛ ko: ‹N di i jiri, ka i bɔnsɔn siyaya ka a kɛ jama siyaman ba ri. N di jamana ɲin di i bɔnsɔn ma i kɔma rɔ, ka a kɛ ii ta ri kadawu.›» ");
INSERT INTO msc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakuba ka a fɔ Yusufu yɛ ko: «I ka i dencɛ Efirayimu ni i dencɛ Manase sɔrɔn Misiran yan ka a tɛrɛn n tun ma na i tɔrɔfɛ fɔlɔ, kɔni sisen, n da woilu kɛ n denilu ri. Efirayimu ni Manase ra kɛ n ta ri sisen ikomin Rubɛn ni Simeyɔn ye n ta ri ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ni i ka den mɛnilu sɔrɔn woilu kɔ, woilu ri kɛ i ta ri. Woilu bɔnsɔn di duu sɔrɔn Efirayimu ni Manase bɔnsɔn ta ni rɔ. ");
INSERT INTO msc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","N bɔra Padani Aramu rɔ ka n kɔsɛ n fa wara tuma mɛn na, Rasɛli sara ka n niilafin kojuuya. A sara sila la Kanaan jamana rɔ, ka a tɛrɛn an tun da sudunya Efirata so la. N ka a su don Efirata sila la ye.» Efirata mɛn tɔɔ bi ko Bɛtilɛhɛmu. ");
INSERT INTO msc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isirayɛli ka Yusufu dencɛilu yen tuma mɛn na, a ka a fɔ ko: «Yon de ɲinilu ri?» ");
INSERT INTO msc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu ka a fa jabi: «Alla ka dencɛ fila mɛn di n ma yan, woilu le ɲin di.» Yakuba ka a fɔ ko: «Ii lana n ma yan, sa n di duwawu kɛ ii yɛ.» ");
INSERT INTO msc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Isirayɛli ɲa lafinni tɛrɛ. A tun tɛ fen nasala kosɛbɛ butun. Yusufu ka a dencɛilu madon a la tuma mɛn na, Isirayɛli ka a ton ii kan ka ii sunbu. ");
INSERT INTO msc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","A ka a fɔ Yusufu yɛ ko: «N ma a lɔn fewu ko n di i yen butun, kɔni Alla ra a kɛ n da i dencɛilu fanan yen sisen.» ");
INSERT INTO msc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yusufu ka a dencɛilu ta ka ii bɔ a fa sen kan, ka a majii, ka a kun majii a fa kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","A wulira ka a dencɛilu madon a fa la, ka Efirayimu lasii a fa bolomaran fɛ, ka Manase lasii a fa bolokinin fɛ. ");
INSERT INTO msc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Hali wo, Isirayɛli ka a bolo latamin a ɲɔɔn kɔ rɔ. A ka a bolokinin natamin ka a la Efirayimu kun dɔ, ni a ye dɔɔmamɔɔ ri. A ka a bolomaran natamin ka a la Manase kun dɔ, wo mɛn ye den fɔlɔ ri. ");
INSERT INTO msc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Wo rɔ, a duwara Yusufu yɛ ko: «N benba Iburahima ni n fa Isiyaka tɛrɛ ye taamala ka bɛn Alla mɛn kan ma, wo ye ɲumaya kɛ den ɲinilu yɛ. Alla mɛn ka a lɔ n ɲɔrɔ ka a damira n sɔrɔn waati ma haan ka se bi ma, wo ye ɲumaya kɛ den ɲinilu yɛ. ");
INSERT INTO msc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Alla mɛn nara n ma ikomin mɛlɛka, ka n kisi kojuu bɛɛ ma, Wo ye ɲumaya kɛ den ɲinilu yɛ. Denilu sababu la n tɔɔ kana tunun, A ni n benba Iburahima tɔɔ ni n fa Isiyaka tɔɔ. Ka ii bɔnsɔn siyaya a ɲa jɛrɛ jɛrɛ ma duukolo kan, Alla ma wo kɛra.» ");
INSERT INTO msc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu ka a yen tuma mɛn na ko a fa ra a bolokinin la Efirayimu kun dɔ, wo ma diya Yusufu yɛ. A ka a fa bolo mira ka a bɔ Efirayimu kun dɔ, ka a la a dencɛ fɔlɔ Manase kun dɔ. ");
INSERT INTO msc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","A ka a fɔ a fa yɛ ko: «N fa, i filinin de. Den fɔlɔ le Manase ri. I bolokinin la wo kun dɔ.» ");
INSERT INTO msc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","A fa, kɔnin, ma sɔn wo ma. A ka a fɔ ko: «N dencɛ, n ye mɛn kɛla, n ka wo lɔn jɔ. Manase bɔnsɔn fanan di siyaya ka kɛ kabila ba ri. A ri bonya, kɔni a dɔɔcɛ ri bonya ka tamin a kan. A dɔɔcɛ bɔnsɔn di kɛ jama siyaman di.» ");
INSERT INTO msc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A duwara ii yɛ wo lon. A ka a fɔ ko: «Isirayɛlika di duwa mɔɔilu yɛ ai tɔɔ le rɔ ka a fɔ ko: ‹Alla ma i kɛra ikomin Efirayimu ni Manase ye ɲa mɛn ma.›» Wo rɔ, Yakuba ka Efirayimu bila Manase ɲɛ. ");
INSERT INTO msc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","A ka a fɔ Yusufu yɛ ko: «N satɔ le, kɔni Alla ri to ai fɛ. A ri ai lasɛ ai fa wara Kanaan jamana rɔ ikɔ. ");
INSERT INTO msc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","N di i sɔ ka tamin i badenmailu kan, ka Sɛkɛmu koyinkɛ ma yɔrɔ di i ma. N ka Amɔrikailu kɛlɛ n na fanmuru ni biɲɛkala la ka yɔrɔ ɲuma wo mira ii la.» ");
INSERT INTO msc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakuba ka a dencɛilu kili ko: «Ai ye na ai ladɛn n tɔrɔfɛ. N ye a fɛ ka koilu lase ai ma, mɛnilu kɛtɔ ii la sini natɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","N dencɛilu, ai ye na ai tolo malɔ nde ai fa Yakuba la, a ye fola n ma ko Isirayɛli. ");
INSERT INTO msc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubɛn, ile le n dencɛ fɔlɔ ri. I fɔlɔ le kɛra n na cɛya ni n na fanka fɔlɔ ri. Bonya ni sebaya ye i bolo ka tamin i dɔɔcɛilu kan, ");
INSERT INTO msc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","kɔni i ye ikomin ji ba woyetɔ, mɛn ti se a jɛrɛ mirala. I ti nala kɛla bonkun ri fewu, baa i ra i la i fa la lafen kan ka si a muso fɛ. A ka a la n na lafen kan ka a manɔɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyɔn ni Lebi miriya ye ko kelen de ri. Ii ka ii la fanmuruilu ta ka wa tiɲannin kɛ. ");
INSERT INTO msc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ii wa kuma gbundu rɔ, n tɛ sɔn ka n sen bila wo rɔ. Ii wa ladɛn kɛ, n di n ban wala, baa ii mɔnɛra ka mɔɔilu faa. Ii juuyara ka nisiilu sen fasailu tɛɛ. ");
INSERT INTO msc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Alla ye tɔrɔya la ii kan ii la mɔnɛ wo kosɔn, baa ii la mɔnɛ ka juu, a ni ii la ɲenikɛjuuya wo kosɔn, baa ii la ɲenikɛjuuya ka ii kɛ hinabaliilu le ri. N di ii bɔnsɔn datala Yakuba bɔnsɔn na jamana rɔ. N di ii lajɛnsɛn Isirayɛlika la jamana yɔrɔ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda, i badenmailu ri ile le tando. I ri se i juuilu la. I faludenmailu ri ii majii i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahuda ye ikomin yara kanberen de, mɛn di wa sobo faa ka wo dɔɔn, ka na i rasɔmɔn ka i la. Yon di a lawuli? ");
INSERT INTO msc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Faamaya gbeleke tɛ bɔ Yahuda bolo. Mansaya gbeleke ri to a bɔnsɔn bolo fo mansaya tii wa na, dunuɲa bɛɛ ri i majii mɛn kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","A ri a la fali sidi rɛsɛnju la, ka a la faliden sidi rɛsɛnju ɲuma ɲuma la. A ri a la faanin ko rɛsɛnji la, ka a la durukiba ko rɛsɛnji la, mɛn wulenni ikomin jeli. ");
INSERT INTO msc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A ɲailu ri lafin ikomin rɛsɛnji. A ɲinilu ri lagbɛ ikomin nɔnɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sabulɔn di i sii kɔɔji da la. Kulunbailu lɔ diya ri kɛ a wara ri. A la duu ri wa fɔɔ Sidɔn so fan fɛ. ");
INSERT INTO msc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakari ye ikomin fali, fanka ba ye mɛn na. A ri a la a la donin bɔrɔilu tɛma. ");
INSERT INTO msc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ni a ka a yen tuma mɛn na ko jamana wo ka ɲi, ko yɔrɔ wo duman kosɛbɛ, a ri a kɔ rabɛn donin ta kanma ka kɛ jɔn di ka diyagboya baara kɛ. ");
INSERT INTO msc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Daan di a sii a la mɔɔilu kun na ka ii la kiti tɛɛ, a ri kɛ ikomin Isirayɛli kabila tɔilu fanan. ");
INSERT INTO msc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan ye ikomin sa, mɛn lani sila dafɛ, ikomin fɔnfɔnni, mɛn ye sila mɛsɛnilu la. A ri so cin a sen ma, ka so tii labe a kɔ kan.» ");
INSERT INTO msc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yakuba ka a fɔ ko: «Ɛɛ Allabatala, n ye i makɔnɔla, i ye n kisi.» ");
INSERT INTO msc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","A ka a fɔ ko: «Benkaninnailu ri na be Kadi kan, kɔni a ri ii gbɛn ka ii kɔsaran kojuuya. ");
INSERT INTO msc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asɛri ri suman duman sɔrɔn; a ri dɔɔnninfen duman di mansailu ma. ");
INSERT INTO msc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafitali a la fɛrɛnin ikomin minanmuso, mɛn ye a jɛrɛ ma, mɛn ye den ɲumailu sɔrɔnna a jɛrɛ ma. ");
INSERT INTO msc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusufu ye ikomin jiri mɛn ye a denna kosɛbɛ, jiri mɛn lɔni tenke dafɛ, mɛn bolo ye janyana fɔɔ ka tamin dandan kun na. ");
INSERT INTO msc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kalabiɲetiilu wulira a kanma kojuuya. Ii ka biɲɛilu lafili a ma ka a tɔrɔ kosɛbɛ, ");
INSERT INTO msc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","kɔni Yusufu la biɲɛkala ma yɛrɛyɛrɛ. A boloilu ka fanka sɔrɔn Alla Sebɛɛtii bolo, mɛn ye Yakuba dɛmɛnna. Wo le ye mɔɔ latankala le ri, mɛn ye Isirayɛli lakandanna, mɛn barakani ikomin farakolo. ");
INSERT INTO msc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","I fa Maari ye i dɛmɛnna. Alla Sebɛɛtii ye ɲumaya kɛla i yɛ. A ri fen ɲumailu di i ma ka bɔ san ma. A ri ji di i ma ka bɔ duu kɔrɔ. A ri i denilu ni i la kolofenilu siyaya. ");
INSERT INTO msc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Fen ɲumailu ye bɔla koyinkɛ kɔrɔilu la, nanfuluilu ye bɔla fɔlɔ tindilu la, kɔni Alla ka ɲumaya mɛnilu kɛ i fa yɛ, woilu ka bon woilu bɛɛ ri. Alla ye wo ɲɔɔn kɛ Yusufu yɛ. Alla ye a kɛ, ɲumaya woilu ye mɛn Yusufu fɛ, mɛn ɲenematɔmɔnni ka bɔ a badenmailu rɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bɛniyaminu fadima ikomin wara juu. Sɔɔma a ye sobo mirala ka do dɔɔn. Wura la, a ri a tɔ ratalan.» ");
INSERT INTO msc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nba, Isirayɛli kabila tan ni fila le woilu ri. Ii fa duwara ii yɛ tuma mɛn na, a ka kuma woilu fɔ. A duwara ii kelen kelenna bɛɛ ye, bɛɛ ni a la duwa. ");
INSERT INTO msc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nba, Yakuba ka a fɔ a dencɛilu yɛ ko: «N satɔla le ka la n benbailu kan. Ni n sara, ai ye wa n su don n benbailu dafɛ falan na, falan mɛn ye Hɛtika Efurɔn na sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Falan wo ye Makipela, Mamere telebɔ fan fɛ Kanaan jamana rɔ. N benba Iburahima ka dinkira wo le san Hɛtika Efurɔn ma, ka a kɛ a la su don diya ri. ");
INSERT INTO msc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","N benba Iburahima ni a muso n ma Saran su don diya ye ye le. N fa Isiyaka ni a muso n na Rebeka fanan su don diya ye ye le. N ka Leya su don ye le fanan. ");
INSERT INTO msc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Duu wo ni falan bɛɛ sanda Hɛtika de ma.» ");
INSERT INTO msc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nba, Yakuba banni kumala, a ka a la a la lafen kan ka sa, ka la a benbailu kan. ");
INSERT INTO msc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yusufu ka a ton a fa su kan ka a sunbu ka kasi. ");
INSERT INTO msc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nba, Yusufu ka a fɔ a la dandalilailu yɛ ko ii ye a fa fure rabɛn ka baara kɛ kosa a kana toli, ka ban ka a mamininminin. Ii wara Isirayɛli fure rabɛn. ");
INSERT INTO msc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ii ka tele binaanin kɛ baarala. Ii la fure rabɛn ɲa le wo ri. Misirankailu ka tele biwɔrɔnwula kɛ a saya kasila. ");
INSERT INTO msc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Saya kasi waati wo taminni, Yusufu ka a fɔ Misiran mansa la mɔɔbailu yɛ ko: «Ni n na ko diyara ai yɛ ai ye wa kuma mansa yɛ. Ai ye a fɔ a yɛ ko ");
INSERT INTO msc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","n fa ka kuma do fɔ n yɛ a sa tumana la. A ka a fɔ ko n ye n kali a yɛ ko ni a sara, ko n di wa a su don Kanaan jamana rɔ. Ko a ka su don diya mɛn dabɛn a jɛrɛ yɛ, ko n ye wa a su don dinkira wo rɔ. N fa kan de wo ri. Wo rɔ, n ye mansa madiyala, a ye sɔn n ye wa n fa su don. N wa ban, n di na.» ");
INSERT INTO msc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ferawuna ka jabi: «Wa i fa su don ikomin i ka i kali a yɛ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Wo rɔ, Yusufu wara a fa su don diya. Misiran mansa la ɲɛmɔɔ bɛɛ wara a malɔ, a ni mansa wara mɔɔbailu ni Misiran jamana mɔɔbailu. ");
INSERT INTO msc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusufu wara mɔɔ bɛɛ fanan wara, a ni a kɔrɔcɛilu ni a dɔɔcɛ ni a fa wara mɔɔ bɛɛ. A den ni a la kolofenilu le tora ii kɔ ma Kosɛni. ");
INSERT INTO msc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sowontoro laborilailu ni so laborilailu fanan wara Yusufu malɔ. A kɛra jama siyaman ba le ri. ");
INSERT INTO msc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ii sera Atadi la suman magbasi gbere la Juridɛn Ba dala waati mɛn na, ii bɛɛ ka san kasi kɛ ye, ka kule kan ba labɔ. Yusufu ka tele wɔrɔnwula kɛ san kasila ye. ");
INSERT INTO msc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ye duurenilu, Kanaanka kɔnin, woilu ka wo yen tuma mɛn na ii ka a fɔ ko: «Misirankailu ra saya kasi ba le kɛ ten de!» Wo le kosɔn dinkira wo tɔɔ lara ko Abɛli-Misirayimu, yɔrɔ mɛn ye Juridɛn Ba dala. ");
INSERT INTO msc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nba, Yakuba satɔla ka mɛn fɔ a dencɛilu yɛ, ii ka wo kɛ. ");
INSERT INTO msc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ii wara a su ri Kanaan jamana rɔ, ka a su don falan na Makipela, Mamere telebɔ fan fɛ, falan a ni duu mɛn Iburahima ka san Hɛtika Efurɔn ma, ka a kɛ a la su don diya ri. ");
INSERT INTO msc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusufu banda a fa su donna tuma mɛn na, a ka a kɔsɛ Misiran. A badenmailu ni mɛnilu bɛɛ wara a fɛ a fa su don diya, woilu bɛɛ ka ii kɔsɛ a fɛ. ");
INSERT INTO msc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Nba, Yusufu kɔrɔcɛilu ka a yen ko ii fa Yakuba tɛ ii fɛ butun. Wo rɔ, ii ka a fɔ i ɲɔɔn yɛ ko: «An ka kojuu mɛn kɛ Yusufu la, ni an gboyara a yɛ don? A tɛ wo julu sara an na wa?» ");
INSERT INTO msc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Wo le rɔ, ii ka kela lawa Yusufu ma ko: «Sani i fa ye sa, a ka kuma do fɔ. ");
INSERT INTO msc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","A ka a fɔ ko an ye a fɔ i yɛ. Ko i jaandi, i ye i kɔrɔcɛilu la hakɛ ni ii la juluman yafa ii ma, ii ka mɛn kɛ i la. An fa kan de wo ri. Wo rɔ, an ye i madiyala, i ye yafa an ma an na kojuuilu rɔ, ande mɛnilu ye i fa Maari la jɔnilu ri.» Kela wo fɔra Yusufu yɛ tuma mɛn na, a kasira. ");
INSERT INTO msc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A kɔrɔcɛilu jɛrɛ nara ii majii a kɔrɔ duu ma, ka a fɔ a yɛ ko: «Ande ye i la jɔnilu le ri.» ");
INSERT INTO msc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusufu ka a fɔ ii yɛ ko: «Ai kana silan. N ye Alla nɔ le rɔ wa? ");
INSERT INTO msc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mɛn kɛra n na, ai ka wo kɛ kojuu kɛ kanma, kɔni Alla ka wo kɛ koɲuma le kɛ kanma, kosa mɔɔ siyaman di kisi n bolola yan bi. ");
INSERT INTO msc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Wo rɔ, ai kana silan. N di n janto ai rɔ, ai ni ai denilu bɛɛ.» Yusufu kumara ii yɛ kaninteya la, ka ii jususuma. ");
INSERT INTO msc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nba, Yusufu ni a fa la mɔɔilu tora Misiran. Yusufu si bɛɛ ladɛnnin kɛra san kɛmɛ ni san tan de ri. ");
INSERT INTO msc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","A ka a tolomirailu yen, a dencɛ Efirayimu ni a dencɛ Manase mamarenilu kɔnin. Manase dencɛ Makiri, wo ka denilu sɔrɔn tuma mɛn na, ii nara a la Yusufu sen kan. ");
INSERT INTO msc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Lon do rɔ, Yusufu ka a fɔ a badenmailu yɛ ko: «N satɔla le, kɔni Alla ri a janto ai rɔ ka ai ta ka bɔ jamana ɲin dɔ ka wa ai ri lahidi jamana rɔ, baa a ka kali an benba Iburahima ni an benba Isiyaka ni an fa Yakuba yɛ ko jamana wo ri kɛ ii ta ri.» ");
INSERT INTO msc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusufu ka a fɔ a badenmailu yɛ ko: «Ai ye i kali n yɛ ko Alla wa na ai dɛmɛn ka ai labɔ Misiran yan, ko ai ri wa n koloilu ri.» ");
INSERT INTO msc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusufu sara Misiran ka a tɛrɛn a sɔrɔn tun da san kɛmɛ ni san tan bɔ. Misirankailu ka a su rabɛn ka baara kɛ sa a kana toli. Wo banda mɛn kɛ, ii ka a mamininminin ka a la su balankari kɔndɔ Misiran.");
INSERT INTO msc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Nba, Yakuba mɛn tɔɔ fanan ko Isirayɛli, wo wa mɛn kɛni Misiran jamana rɔ, a ni a dencɛilu wara, bɛɛ ni a la denbaya. A dencɛilu tɔɔ le ɲin di: ");
INSERT INTO msc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubɛn, Simeyɔn, Lebi, Yahuda, ");
INSERT INTO msc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakari, Sabulɔn, Bɛniyaminu, ");
INSERT INTO msc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daan, Nafitali, Kadi a ni Asɛri. ");
INSERT INTO msc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yakuba la mɔɔilu bɛɛ ladɛnnin kɛra mɔɔ biwɔrɔnwula le ri. A dencɛ Yusufu kelen de tɛrɛ ye Misiran. ");
INSERT INTO msc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Nba, Yusufu a ni a dɔɔcɛ ni a kɔrɔcɛilu, a ni mɛnilu tɛrɛ ye a tɔrɔfɛ waati wo rɔ, woilu bɛɛ kɔrɔra ka sa. ");
INSERT INTO msc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isirayɛlika jirira ka siyaya kosɛbɛ ii ka ban ka fanka ba sɔrɔn ka jamana lafa ii la mɔɔilu la. ");
INSERT INTO msc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nba, waati jan taminni kɔ rɔ, mansa kura do siira Misiran jamana kun na, mɛn tun ma foyi lɔn Yusufu la ko rɔ. ");
INSERT INTO msc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Mansa wo ka a fɔ a la mɔɔilu yɛ ko: «Ai ma a yen? Isirayɛlika ka siya an di. Ii la jama ka bon an na jama ri, a ni ii la fanka ka bon an na fanka ri. ");
INSERT INTO msc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Wo rɔ, an ye ɲaɲinin ii la ko ma. Ni wo tɛ, ii ri to siyayala. Ni kɛlɛ nara lon mɛn na, ii ri la an juuilu kan ka an kɛlɛ, ka ban ka bɔ an na jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Wo le rɔ, ii ka baara kuntiilu lasii Isirayɛlika kun na, ka ii tɔrɔ baara gbɛlɛn na. Wo bolo ma, Isirayɛlika ka Pitɔn so ni Ramɛsisi so lɔ. So woilu kɛra Ferawuna la fen namara dinkirailu ri. ");
INSERT INTO msc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Misirankailu ka Isirayɛlika tɔrɔ kojuuya, kɔni Isirayɛlika tora siyayala ka jɛnsɛn. Wo le kɛra sababu ri, Isirayɛlika la ko jiitɔya donda Misirankailu la kojuuya. ");
INSERT INTO msc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ii ka Isirayɛlika mira karagbɛlɛya la ka ii bila baara gbɛlɛn na. ");
INSERT INTO msc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ii ka ii tɔrɔ fɔɔ ka a dan natamin, ka ii bila baara gbɛlɛn bailu la. Ii ka ii lɔ diyagboya biriki gbasila, a ni bɔɔ bɔrɔnna, ka ii lɔ diyagboya sɛnɛ baara su bɛɛ kɛla. Ii ka ii lɔ diyagboya baara mɛnilu kɛla, woilu bɛɛ kɛra baara gbɛlɛn de ri. ");
INSERT INTO msc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nba, lon do rɔ, Misiran mansa kumara Heburuilu la tinkɔrɔsila fila yɛ. Wo kelen tɔɔ le ko Sifira, do wo tɔɔ ko Puwa. ");
INSERT INTO msc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","A ka a fɔ woilu yɛ ko: «Ai wa wa Heburu musoilu dɛmɛn den sɔrɔn diya tuma tuma, ai ye den dagbɛ. Ni a kɛra cɛɛ ri, ai ye a faa. Ni a kɛra muso ri, ai ye a kɛndɛ to.» ");
INSERT INTO msc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tinkɔrɔsilailu kɔnin silanda Alla yɛ. Misiran mansa ka mɛn fɔ, ii ma sɔn wo kɛla. Ii ka den cɛman kɛndɛ to. ");
INSERT INTO msc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Misiran mansa ka tinkɔrɔsilailu kili ka ii maɲininka ko: «Nfenna ai ka wo kɛ? Nfenna ai ra Heburuilu den cɛman to ye?» ");
INSERT INTO msc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tinkɔrɔsilailu ka a fɔ ko: «Heburu musoilu tɛ ikomin Misiran musoilu. Ii kaliman moyila. Sani an ye don ii kan, wo ri a tɛrɛn ii ra ban moyila.» ");
INSERT INTO msc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Awa, Isirayɛlika tora siyayala. Fanka ba kɛra ii la. Alla ka ɲumaya kɛ tinkɔrɔsila woilu yɛ. ");
INSERT INTO msc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","A ka denbaya di woilu fanan ma, ka a masɔrɔn ii silanda a yɛ. ");
INSERT INTO msc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Misiran mansa ka a la mɔɔ bɛɛ jamari ko: «Heburu musoilu wa den cɛmanta mɛnilu sɔrɔn, ai ye wo bɛɛ mira ka ii lafili Nili Ba ji rɔ, kɔni ai ye den musomanta kɛndɛ to.» ");
INSERT INTO msc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nba, waati wo la, Lebi bɔnsɔn cɛɛ do ka Lebi bɔnsɔn muso do furu. ");
INSERT INTO msc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Muso wo ka kɔnɔ ta ka dencɛ sɔrɔn. A ka a yen tuma mɛn na ko den ka ɲi, a ka a dokon fɔɔ karo sawa. ");
INSERT INTO msc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Karo sawa taminni kɔ rɔ, muso ma se den doonna butun. Wo rɔ, a ka see do ta, mɛn nadanni bin kala jan na. A ka wo mamun tulubɔ fasani ni mananji la. A ka den ta ka a lala see wo kɔndɔ, ka wa wo sii jirɔbin kuruilu tɛma Nili Ba rɔ. ");
INSERT INTO msc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Den wo kɔrɔmuso wara i lɔ dinkira do rɔ, mɛn ma jan den na kosɛbɛ, sa a ri a lɔn ko mɛn kɛtɔ den sɔrɔn na. ");
INSERT INTO msc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ferawuna denmuso nara a ko diya ba la. Jɔn sunkurun mɛnilu nani a malɔla, woilu wara ii mataama ba dala. Ferawuna denmuso ka see yen jirɔ binilu tɛma, ka a la jɔnmuso do lɔ a tala. ");
INSERT INTO msc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Jɔnmuso nani see ri, Ferawuna denmuso ka a da laka ka den yen a kɔndɔ. A hina ba donda a rɔ, baa den ye kasila. A ka a fɔ ko: «Heburu do dencɛ le ɲin di.» ");
INSERT INTO msc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Den kɔrɔmuso nara ka Ferawuna denmuso maɲininka ko: «I ye a fɛ n ye wa Heburu muso do ɲinin wa, mɛn di den sɔ sin dɔ i yɛ?» ");
INSERT INTO msc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ferawuna denmuso ka a jabi: «Ale le wo ri. Wa.» Sunkurun wara ka den na le kili. ");
INSERT INTO msc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Den na nani, Ferawuna denmuso ka a fɔ a yɛ ko: «I ye den ɲin ta ka a sɔ sin dɔ n yɛ. N di i sara.» Muso ka den ta ka a sɔ sin dɔ. ");
INSERT INTO msc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Den kunbayara dɔɔni tuma mɛn na, a na wara ka a di Ferawuna denmuso ma. Wo ka den kɛ a jɛrɛ dencɛ ri. A ka a fɔ ko: «N di den tɔɔ la ko Musa, baa n ka a ta ba ji le kan.» ");
INSERT INTO msc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Nba, Musa kunbayara. Lon do rɔ, a wara bɔ a badenma Heburuilu fɛ. A ka a yen ko Misirankailu tɛrɛ ye ii diyagboyala baara gbɛlɛnilu la. A ka Misiranka cɛɛ do yen Heburu cɛɛ do gbasila, mɛn ye Musa badenma do ri. ");
INSERT INTO msc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa ka a ɲalakalan fan bɛɛ rɔ, mɔɔ si tɛrɛ sa a laminin dɔ. A ka Misiranka cɛɛ wo gbasi ka a faa, ka a su dokon kiɲɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Wo duusa gbɛ, Musa wara bɔ a badenmailu tɔrɔfɛ ikɔ tuun. Sisen a ka Heburu cɛɛ fila tɛrɛn ye, ii ye kɛlɛla. Jo tɛ mɛn bolo, Musa ka a fɔ wo yɛ ko: «Nfenna i ye i badenma wo gbasila?» ");
INSERT INTO msc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Wo ka a jabi: «Yon ka i kɛ an na kuntii ri a ni an na kititɛɛla ri? I ye a fɛ ka nde fanan faa wa, ikomin i ka Misiranka cɛɛ faa ɲa mɛn ma kunun?» Musa silanda. A ka i miri ko: «Sika tɛ a rɔ, n ka mɛn kɛ kunun, mɔɔilu ra wo lɔn.» ");
INSERT INTO msc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Musa la mɔɔfaa ko fɔra Ferawuna yɛ tuma mɛn na, a tɛrɛ ye Musa ɲininna fɔɔ ka a faa, kɔni Musa ka i bori a kɔrɔ ka wa Madiyan bɔnsɔn na jamana rɔ. A se mɛn kɛni ye, a ka a sii kɔlɔn do tɔrɔfɛ ye. ");
INSERT INTO msc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Awa, Madiyan bɔnsɔn na sarakalasela do tɛrɛ ye, denmuso wɔrɔnwula tɛrɛ ye mɛn bolo. Denmuso woilu nara ii fa la kolofen mɛsɛnilu ri ii lamin diya kɔlɔn na ye. Denmusoilu ka ji ta damira ka a kɛ kolofenilu minfen kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ka denmusoilu to baara wo la, saagbɛnbɛnna doilu nara ka ii gbɛn, kɔni Musa ka wuli ka denmuso woilu lakandan, ka ji layɛlɛ kɔlɔn kɔndɔ, ka denmusoilu la kolofenilu lamin. ");
INSERT INTO msc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Denmusoilu ka i kɔsɛ ii fa Rewɛli wara tuma mɛn na, wo ka ii maɲininka ko: «Nfen de ka a kɛ ai ra na jona bi?» ");
INSERT INTO msc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ii ka a fɔ ko: «Misiranka cɛɛ do le ka an bɔ saagbɛngbɛnnailu bolo. Ka a la wo kan, ka ban ka ji layɛlɛ kɔlɔn dɔ an yɛ ka an na kolofenilu lamin.» ");
INSERT INTO msc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Rɛwɛli ka a denmusoilu maɲininka ko: «Cɛɛ wo ye mi? Nfenna ai ka a to ai kɔma ye? Ai ye wa a kili. A ye na dɔɔnnin kɛ an tɔrɔfɛ.» ");
INSERT INTO msc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa sɔnda ka a sii cɛɛ wo wara, mɛn ka a denmuso Sefora di Musa ma. ");
INSERT INTO msc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sefora ka kɔnɔ ta ka dencɛ sɔrɔn Musa yɛ. Musa ka den tɔɔ la ko Kerisɔn, baa a ka a fɔ ko a ye londan de ri jamana wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nba, san siyaman taminni kɔ rɔ, Misiran mansa wo sara. Isirayɛlika tɛrɛ ye ii kule kan nabɔla fɔlɔ, baa jɔnya baara tun da ii sɛɛ fɔɔ ka a dan natamin. Ii tɛrɛ ye ii makasila Alla yɛ ko a ye ii dɛmɛn. ");
INSERT INTO msc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Alla tolo tɛrɛ ye ii la makasila kan na. A jan tɛrɛ ye a la teriya rɔ, a tun ka mɛn sidi Iburahima ni Isiyaka ni Yakuba yɛ. ");
INSERT INTO msc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","A ka Isirayɛlika yen tuma mɛn na, ii hina donda a la. ");
INSERT INTO msc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Nba, Musa tɛrɛ ye a birancɛ Rɛwɛli la kolofen mɛsɛnilu marala. A birancɛ tɛrɛ ye Madiyan bɔnsɔn na sarakalasela le ri. Awa, lon do rɔ, Musa wara kolofenilu ri wula kɔndɔ, fɔɔ ka wa se Horɛbu koyinkɛ kɔrɔ, mɛn tɔɔ le ko Alla la koyinkɛ. ");
INSERT INTO msc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ka Musa to yɔrɔ wo rɔ, Allabatala la mɛlɛka ka a jɛrɛ yiraka a la jiri tunin tamɛlɛnama rɔ. Musa ka a ragbɛ. Ta ye jiri tunin na kɔni a tɛ janinna. ");
INSERT INTO msc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa miri ko: «N ye n madon a la ka kabanan ko ɲin mafɛnɛ. Nfenna jiri tunin ɲin tɛ janinna?» ");
INSERT INTO msc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Allabatala ka a yen tuma mɛn na ko Musa ra madon ka a ragbɛ, a tora jiri tunin dɔ ka a kan nabɔ Musa ma ko: «Musa, Musa.» Musa ka a jabi: «Naamun.» ");
INSERT INTO msc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Allabatala ka a fɔ ko: «I kana i madon yan na. I la sanbara bɔ i sen dɔ, baa i lɔni yɔrɔ mɛn dɔ ɲin, yɔrɔ sɛniman de wo ri. ");
INSERT INTO msc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","N ye i fa Maari le ri. N ye i benba Iburahima Maari le ri, a ni i benba Isiyaka, a ni i benba Yakuba Maari.» Musa ka a ɲakɔrɔ dokon ka a masɔrɔn a silanda ka Alla ragbɛ. ");
INSERT INTO msc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Allabatala ka a fɔ ko: «Misirankailu ye n na mɔɔilu tɔrɔla ɲa mɛn ma Misiran, n da wo yen. Ii la baara kuntiilu ye mɛn kɛla ii la, n da wo fanan yen ka ii kasi kan mɛn. N ka ii la tɔrɔya lɔn. ");
INSERT INTO msc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","N da jii ka ii bɔ Misirankailu bolo, ka ii labɔ Misiran jamana rɔ, ka wa ii ri jamana ba do rɔ, mɛn ka ɲi, a duman kosɛbɛ. Damununta duman ye bɔla jamana wo rɔ a ɲa jɛrɛ jɛrɛ ma, li ni nɔnɔ a ni jiri denta su bɛɛ ye bɔla ye. Kanaanka siini ye le, a ni Hɛtika ni Amɔrikailu ni Peresikailu ni Hifikailu ni Jebusikailu. ");
INSERT INTO msc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isirayɛlika kasi kan da se n ma yan. Misirankailu karagbɛlɛman ii ɲa mɛn ma, n da wo bɛɛ yen. ");
INSERT INTO msc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nba, sisen n ye i lawala ka kuma Ferawuna yɛ. Wa! I ye i lɔ n na mɔɔilu ɲɔrɔ ka ii labɔ Misiran jamana kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa ka Alla jabi: «Nde wa? N tɛ foyi ri! N di se n lɔla Ferawuna ɲakɔrɔ di, ka n lɔ Isirayɛlika ɲɔrɔ ka ii labɔ Misiran?» ");
INSERT INTO msc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Alla ka a fɔ ko: «N di kɛ i kɔfɛ. I wa n na mɔɔilu labɔ Misiran jamana rɔ tuma mɛn na, ai ri na n bato koyinkɛ ɲin kan yan. Wo ri kɛ tɔɔmasere ri i yɛ ko nde le ka i kelaya.» ");
INSERT INTO msc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa ka a fɔ ko: «Ni n di wa Isirayɛlika tɛrɛn ye, n di a fɔ ii yɛ ko ii benbailu Maari ra n kelaya ii ma. Ii wa n maɲininka i tɔɔ ma don? N ye nfen fɔ ii yɛ wo rɔ?» ");
INSERT INTO msc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Alla ka Musa jabi: «Mɛn Ye Ye, nde le wo ri. I ye a fɔ Isirayɛlika yɛ ko ‹Mɛn Ye Ye a jɛrɛ ka n lawa ai ma.› ");
INSERT INTO msc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","I ye wa a fɔ Isirayɛlika yɛ ko ‹Allabatala le ka n kelaya ai ma, ale mɛn ye ai benba Iburahima Maari Alla ri, a ni ai benba Isiyaka ta, a ni ai benba Yakuba ta. A tɔɔ ye ten de haan ka wa habadan. Mɔɔilu kɛtɔ a kilila tɔɔ wo le la tuma bɛɛ.› ");
INSERT INTO msc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","I ye wa Misiran. I wa se ye, i ye Isirayɛlika la mɔɔbakɔrɔilu ladɛn ka a fɔ ii yɛ ko: ‹Maari Allabatala ra a jɛrɛ yiraka n na. Ko a ye ai benbailu Maari Alla le ri, Iburahima ta a ni Isiyaka ta ni Yakuba ta kɔnin. A fɔ ko: «Mɛn bɛɛ ye kɛla ai la Misiran, ko n da wo yen. ");
INSERT INTO msc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ko wo le rɔ, n ka a fɔ ko n di ai labɔ tɔrɔya rɔ Misiran, ka wa ai ri jamana do rɔ, Kanaankailu ni Hɛtikailu ni Amɔrikailu ni Peresikailu ni Hifikailu ni Jebusikailu siini jamana mɛn kɔndɔ, dɔɔnninta duman ye bɔla jamana wo rɔ a ɲa jɛrɛ jɛrɛ ma, li ni nɔnɔ a bɛɛ ye bɔla ye.»› ");
INSERT INTO msc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Isirayɛlika di la i la kuma la ka wo mira. I ni Isirayɛlika la mɔɔbakɔrɔilu ri wa Misiran mansa tɛrɛn ye, ka a fɔ a yɛ ko: ‹Heburuilu Maari Allabatala ra an nabɛn. Ko wo rɔ, ko an ye Misiran mansa madiyala ko i ye an bila, kosa an di tele sawa kɛ taamana wula kɔndɔ ka wa ka saraka bɔ an Maari Allabatala ma.› ");
INSERT INTO msc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","N ka a lɔn fewu ko a tɛ sɔn ka ai bila hali n wa diyagboya fanka la a kan. ");
INSERT INTO msc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Wo le rɔ, n di n wuli Misirankailu kanma ka n na sebaya yiraka ii la. N di kabannakoilu kɛ, mɛnilu ri tɔrɔya su bɛɛ la ii kan. N wa ban woilu kɛla, Ferawuna ri ai bila sa ai ri wa. ");
INSERT INTO msc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","N jɛrɛ ri a kɛ, Misirankailu ri ai bonya. Wo rɔ, ai bɔtɔla ye, ai bolokolon ti nala bɔla ka wa. ");
INSERT INTO msc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isirayɛlika muso kelen kelenna bɛɛ ri a Misiranka musoman siiɲɔɔ a ni Misiranka musoman mɛn siini a bon na tara fen saninnamanilu ni fen wodigbɛlamanilu la, a ni faaninilu la. Ai Isirayɛlika ri faanin ni masidifen woilu bila ai dencɛilu ni ai denmusoilu kan na. Ai ri Misirankailu bolokolonya wo ɲa ma.» ");
INSERT INTO msc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa ka Allabatala jabi: «Ni ii ma la n na ka sɔn n na kuma ma don? Ni ii ka a fɔ ko ‹Allabatala ma a jɛrɛ yiraka i la,› n ye nfen kɛla wo rɔ?» ");
INSERT INTO msc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Allabatala ka a maɲininka ko: «Nfen de ye i bolo ye?» Musa ka a fɔ ko: «N na gbeleke le n bolo.» ");
INSERT INTO msc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Allabatala ka a fɔ ko: «A lafili duu ma.» A ka a lafili duu ma tuma mɛn na, gbeleke yɛlɛmanda ka kɛ duuma sa ri. Musa ka a bori a kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Allabatala ka a fɔ Musa yɛ ikɔ tuun ko: «I bolo rasɔmɔn ka sa wo mira a ko ma.» A ka a bolo rasɔmɔn ka a mira a ko ma. Sa yɛlɛmanda ka kɛ gbeleke ri a bolo ikɔ tuun. ");
INSERT INTO msc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Allabatala ka a fɔ a yɛ ko: «I ri wo kɛ, sa ii ri la a la ko Allabatala a ra a jɛrɛ yiraka i la, Allabatala mɛn ye ii benbailu Maari ri, Iburahima Maari Alla a ni Isiyaka Maari Alla a ni Yakuba fanan Maari Alla kɔnin.» ");
INSERT INTO msc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Allabatala ka a fɔ a yɛ ikɔ tuun ko: «I bolo ladon i la duruki kɔrɔ ka a la i sisi kan.» A ka a bolo ladon a la duruki kɔrɔ ka a la a sisi kan. A ka a labɔ tuma mɛn na, a gbɛni tɛrɛ fɛfɛ, baa kuna tun da a mira. ");
INSERT INTO msc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Allabatala ka a fɔ ko: «I bolo ladon i la duruki kɔrɔ ikɔ tuun.» Musa ka a bolo ladon a la duruki kɔrɔ ikɔ tuun. A ka a labɔ tuma mɛn na, a bolo kɛndɛyara ikomin a tɛrɛ ye ɲa mɛn ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Allabatala ka a fɔ ko: «I la gbeleke wa yɛlɛman ka kɛ sa ri tuma mɛn na, ni Isirayɛlikailu ma sɔn fɔlɔ ka la i la ka i la kuma jate, i ye tɔɔmasere kabannako filana ɲin yiraka ii la. Ii ri la i la wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ni ii ma la tɔɔmasere kabannako fila ɲin na ka sɔn i la kuma ma, i ye ji do ta Nili Ba rɔ ka a labɔn duu ma. Wo ri yɛlɛman ka kɛ jeli ri duu ma.» ");
INSERT INTO msc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa ka a fɔ Allabatala yɛ ko: «Faama, i ri hakɛ to. N ma kusan kumala. Sani i ye kuma n yɛ fɔlɔ, n tun ma kusan kumala. I ra kuma n yɛ bi fanan, hali bi n ma kusanya kumala fɔlɔ. N da a radiyani tɛ fewu. N nɛn sidini le.» ");
INSERT INTO msc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Allabatala ka a fɔ a yɛ ko: «Yon de ka mɔɔ da ladan? Yon de ye mɔɔ kɛla bobo ri, wala tolo gbɛdɛn? Yon ka a kɛ mɔɔ ɲa ye fen yenna, wala ka a ɲa fuyen? Nde Allabatala de woilu kɛla. ");
INSERT INTO msc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","I ye wa sisen. I wa kɛ kumala, n jɛrɛ ri kɛ i tɔrɔfɛ ka i dɛmɛn. I ka kan ka mɛn fɔ, n di wo yiraka i la.» ");
INSERT INTO msc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Musa ka a fɔ ko: «Ee Allabatala, i jaandi, i ye mɔɔ gbɛrɛ lawa.» ");
INSERT INTO msc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Allabatala mɔnɛra Musa kanma ka a fɔ a yɛ ko: «I kɔrɔcɛ Haruna don, mɛn ye Lebi bɔnsɔn mɔɔ le ri? N ka a lɔn ko wo kusan kumala a ɲa ma. A ye sila kan sisen ka na i labɛn. A wa i yen tuma mɛn na, a jusu ri sɛwa kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I ri kuma a yɛ ka kuma don a da rɔ, a ka kan ka mɛn fɔ. N di ai mɔɔ fila dɛmɛn kumala. Ai ka kan ka mɛnilu kɛ, n di ai karan woilu la. ");
INSERT INTO msc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A ri kuma jama yɛ i nɔ rɔ. A ri kɛ i la kumafɔba ri. A ri i la kuma fɔ ikomin i ye Alla la kuma fɔla ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","I la gbeleke ye wa i bolo, baa i ri tɔɔmasere kabannakoilu kɛ wo la.» ");
INSERT INTO msc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nba, Musa bɔra ye ka a kɔsɛ a birancɛ Jɛtiro wara, ka wa a fɔ a yɛ ko: «I ye sila di n ma, sa n di n kɔsɛ n badenmailu ma Misiran. N ye a fɛ ka a lɔn ni ii kɛndɛ le.» Jɛtiro ka a fɔ ko: «I ye wa fasayi! Alla ye jususuma don i yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ka Musa to Madiyan, Allabatala ka a fɔ a yɛ ko: «I ye i kɔsɛ Misiran, baa mɛnilu tɛrɛ ye i faa ko rɔ, woilu ra sa.» ");
INSERT INTO msc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Wo rɔ, Musa ka a muso ni a dencɛilu ta, ka ii layɛlɛ fali do kan, ka Misiran sila mira. Alla la gbeleke tɛrɛ ye a bolo. ");
INSERT INTO msc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Allabatala ka a fɔ Musa yɛ ikɔ tuun ko: «N da sebaya di i ma ka ko makabani kɛ. I wa i kɔsɛ Misiran tuma mɛn na, i ye woilu bɛɛ kɛ Ferawuna ɲakɔrɔ, kɔni nde le ri a kɛ a jusu ri a ragbɛlɛya. A tɛ sɔn ka Isirayɛlikailu bila kɔma. ");
INSERT INTO msc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","I ye a fɔ Ferawuna yɛ ko: ‹Nde Allabatala ka a fɔ ko: «Isirayɛlikailu ye n dencɛ fɔlɔ le ri. ");
INSERT INTO msc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","N ka a fɔ i yɛ ko i ye a bila sa a ri wa n bato, kɔni i ra i ban a bila ko ma. Wo rɔ, n di i dencɛ fɔlɔ faa.»›» ");
INSERT INTO msc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Nba, Musa watɔla Misiran, a ni a la denbaya sira sila la yɔrɔ do rɔ. Allabatala wulira Musa kanma ye ko a kɛtɔ a faala. ");
INSERT INTO msc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kɔni Musa muso Sefora ka kaba lɛsɛni do ta ka a dencɛ a la faaninta kɛ wo la. A ka a dencɛ ɲɔɔrɔ gbolo wo maa a sen na ii tɛma, ka a fɔ a yɛ ko: «I ra kɛ n furucɛ jelitii ri.» ");
INSERT INTO msc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Allabatala ka Musa to ye wo rɔ. Sefora tun ka a fɔ Musa ma ko «n furucɛ jelitii» ka a masɔrɔn faaninta kɛ ko wo le fɛ. ");
INSERT INTO msc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nba, Allabatala ka a fɔ Haruna yɛ ko: «I ye wa Musa labɛn wula rɔ.» Haruna ka a wuli ka wa. A wara Musa tɛrɛn Alla la koyinkɛ kɔrɔ, ka a sunbu tuwali rɔ. ");
INSERT INTO msc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Allabatala ka kuma mɛnilu fɔ Musa yɛ a la kelaya tuma, Musa ka woilu bɛɛ fɔ Haruna yɛ. Allabatala ka tɔɔmasere kabannako mɛnilu yiraka Musa la ko a ye woilu kɛ Misiran, Musa ka woilu fanan ɲafɔ Haruna yɛ. ");
INSERT INTO msc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa ni Haruna wara ka Isirayɛlikailu la mɔɔbakɔrɔilu bɛɛ ladɛn. ");
INSERT INTO msc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Allabatala tun ka kuma mɛnilu bɛɛ fɔ Musa yɛ, Haruna ka woilu fɔ mɔɔbakɔrɔilu yɛ. A ka tɔɔmasere kabannakoilu kɛ Isirayɛlikailu ɲakɔrɔ fanan. ");
INSERT INTO msc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Isirayɛlikailu lara kuma ni tɔɔmasere kabannako woilu la. Ii ka a mɛn tuma mɛn na ko Allabatala a ra ii la tɔrɔya yen ka na ii dɛmɛn kanma, ii ka ii ɲakɔrɔ bɛn duu ma ka a bato. ");
INSERT INTO msc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Nba, wo kɔ rɔ, Musa ni Haruna wara Ferawuna wara, ka a fɔ a yɛ ko: «Isirayɛlika Maari Allabatala ka a fɔ ko i ye a la mɔɔilu bila sa ii ri wa ka sali ba kɛ wula kɔndɔ ale bato kanma.» ");
INSERT INTO msc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ferawuna ka a fɔ ko: «Yon ye Allabatala wo ri? Nfenna n ye a kan mirala ka Isirayɛlika bila? Nde ma Allabatala wo lɔn fewu. N tɛ Isirayɛlika bilala.» ");
INSERT INTO msc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa ni Haruna ka a jabi: «Heburuilu Maari Alla a ra a jɛrɛ yiraka an na. An ye i madiyala, i ye an bila. An ye tele sawa kɛ taamala wula kɔndɔ, ka wa saraka doilu bɔ an Maari Allabatala yɛ, sa Allabatala kana an gbasi jankarɔ la, wala fanmuru la.» ");
INSERT INTO msc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ferawuna ka a fɔ ko: «Ai, Musa ni Haruna, nfenna ai ye mɔɔilu labanna ii la baara ma? Ai ye i kɔsɛ baara diya! ");
INSERT INTO msc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Heburuilu ra siyaya bakɛ sisen jamana kɔndɔ yan. Nfenna ai ye ii la baara lalɔla?» ");
INSERT INTO msc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Wo lon kelen dɔ Ferawuna ka baara kɔrɔsilabailu ni baara kuntiilu jamari ko: ");
INSERT INTO msc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Heburuilu ye bin mɛn kɛla bɔɔ rɔ ka birikiilu gbasi, ai ye wo da boloka. Ii ye wa bin wo ɲinin ii jɛrɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Hali wo, ii darini biriki jate mɛn gbasila, ai ye a fɔ ii yɛ ko ii ye wo ɲɔɔn jate gbasi fɔlɔ fasayi. Ai kana foyi bɔ wo la, baa ii ra kɛ salabatɔilu ri. Wo le kosɔn, ii ye a fɔla ko: An ye wa saraka bɔ an Maari Alla ma. ");
INSERT INTO msc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ai ye baarala siyaya ii ma, ka ii ɲagba kosɛbɛ. Wo wa kɛ, ii tɛ ii tolo malɔ wuyafɔla kuma la butun.» ");
INSERT INTO msc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nba, baara kɔrɔsilabailu ni baara kuntiilu wara kuma wo fɔ Isirayɛlika yɛ ko: «Ferawuna ka a fɔ ko a sa bin dila ai ma butun. ");
INSERT INTO msc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ko ai ye wa bin ɲinin ai jɛrɛ yɛ yɔrɔ yɔrɔ rɔ. Wo bɛɛ ni a ta, ai tɛrɛ ye biriki jate mɛn gbasila kɔrɔman na, fɔɔ ii ye wo jate gbasi fɔlɔ. Fen tɛ bɔla jate wo la.» ");
INSERT INTO msc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Wo le rɔ, Isirayɛlika jɛnsɛnda Misiran jamana fan bɛɛ rɔ, ka wa bin wo ɲinin. ");
INSERT INTO msc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Baara kuntiilu tɛrɛ ye ii latuntunna, ka a fɔ ii yɛ ko: «Ai darini tɛrɛ biriki jate mɛn gbasila tele kelen kɔrɔ ka a tɛrɛn an ye bin dila ai ma, ai ye wo ɲɔɔn jate gbasi lon lon.» ");
INSERT INTO msc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ferawuna la baara kuntiilu wulira ka baara Isirayɛlika kɔrɔsibailu gbasi, baara kuntiilu tun ka Isirayɛlika mɛnilu lasii mɔɔ tɔilu kun na baara kɔrɔsi kanma kɔnin. Baara kuntiilu ka a fɔ ii yɛ ko: «Ai darini tɛrɛ biriki jate mɛn gbasila, nfenna ai ma wo ɲɔɔn jate gbasi kunun ni bi?» ");
INSERT INTO msc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Nba baara kɔrɔsiba woilu wara Ferawuna wara ka ii makasi. Ii ka a fɔ a yɛ ko: «Nfenna i ye ɲin ɲɔɔn kɛla i la jɔnilu la? ");
INSERT INTO msc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bin tɛ dila an ma, kɔni baara kuntiilu ye an jamarila ko an ye biriki gbasi. Ka a la wo kan, ii ye an gbasila. Jo tɛ i la mɔɔilu bolo la.» ");
INSERT INTO msc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ferawuna kɔni ka a fɔ ko: «Ai ye salaba jɛrɛ jɛrɛilu le ri. Wo le rɔ, ai ye a fɔla tuma bɛɛ ko: ‹An ye wa saraka bɔ Allabatala yɛ.› ");
INSERT INTO msc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ai ye wa baara kɛ sisen. Bin tɛ dila ai ma butun, kɔni ai darini tɛrɛ biriki jate mɛn gbasila kɔrɔman, ai ye biriki jate wo gbasi fanan.» ");
INSERT INTO msc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nba, a fɔra baara kɔrɔsilabailu yɛ tuma mɛn na ko ii darini tɛrɛ biriki jate mɛn gbasila kɔrɔman, ko ii ye wo jate gbasi lon lon, ii ka a yen ko ii ni Isirayɛlika bɛɛ a ra tɔrɔya ba sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ii bɔtɔla Ferawuna wara, ii bɛnda Musa ni Haruna ri. Woilu tɛrɛ ye ii makɔnɔla ye. ");
INSERT INTO msc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ii ka a fɔ Musa ni Haruna yɛ ko: «Ai ka ko mɛn kɛ, Allabatala ye wo ragbɛ ka wo hakɛ bɔ ai rɔ. Ai ra an magboya Ferawuna ni a la mɔɔilu ɲakɔrɔ. A kɛni ikomin ai ka fan de di Ferawuna ma ko a ye an faa fanmuru la.» ");
INSERT INTO msc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Awa, Musa bɔra ye ka wa Allabatala matara, ka a fɔ a yɛ ko: «N Maari Alla, nfenna i ka kojuu kɛ i la mɔɔilu la? Nfenna i ka n kelaya ka n nana yan? ");
INSERT INTO msc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kɛbi n wara ka kuma Ferawuna yɛ i tɔɔ rɔ, a ra kojuu kɛ i la mɔɔilu la. Ile fanan ma foyi kɛ ka ii bɔ a bolo.» ");
INSERT INTO msc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Allabatala ka a fɔ Musa yɛ ko: «N kɛtɔ mɛn kɛla Ferawuna la, i jɛrɛ ri wo yen i ɲa la sisen. N di a diyagboya n na sebaya a la fɔɔ a ri Isirayɛlika bila. Ɔɔn, n di a diyagboya n na sebaya a la fɔɔ a ri ii gbɛn ka ii labɔ a la jamana kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Alla ka a fɔ Musa yɛ fanan ko: «Nde le Allabatala ri. ");
INSERT INTO msc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","N ka n jɛrɛ yiraka Iburahima ni Isiyaka ni Yakuba la, ka a fɔ ii yɛ ko n ye Alla Sebɛɛtii le ri, kɔni n tɔɔ mɛn ye Allabatala ri, ii ma n lɔn tɔɔ wo la. ");
INSERT INTO msc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","N ka teriya sidi ii yɛ ko n di Kanaan jamana di ii ma, ii siini tɛrɛ londanya la jamana mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nba, sisen n da Isirayɛlika kurun kan mɛn, baa ii bilani jɔnya rɔ Misirankailu bolo. N ka teriya mɛn sidi, n hankili ye wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Wo le rɔ, i ye wa a fɔ Isirayɛlika yɛ ko: ‹Nde le Allabatala ri. Misirankailu ra diyagboya baara mɛn la ai kan, ko n kɛtɔ ai bɔla wo rɔ. Ko n di ai labɔ Misirankailu bolo, sa ai kana to woilu la jɔnya wo rɔ butun. Ko n di ai kunka n na sebaya ba la, ka Misirankailu la kɛwaliilu hakɛ bɔ ii rɔ. ");
INSERT INTO msc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ko n di Isirayɛlika kɛ n na mɔɔilu ri. Ko n di kɛ ai Maari Alla ri. Ko ai ri a lɔn ko n ye ai Maari Allabatala de ri, mɛn ye ai labɔla diyagboya baara rɔ Misirankailu bolo. ");
INSERT INTO msc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ko n ka n kali Iburahima ni Isiyaka ni Yakuba yɛ n bolo layɛlɛnin, ko n di jamana mɛn di ii ma, ko n di ai ladon jamana wo kɔndɔ. Ko n di jamana wo kɛ ai ta ri. Nde le Allabatala ri.›» ");
INSERT INTO msc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Nba, Musa wara kuma wo fɔ Isirayɛlika yɛ, kɔni woilu jiitɛɛni tɛrɛ kojuuya ii la jɔnya gbɛlɛnya bolo ma. Wo rɔ, ii ma sɔn lala a la kumakan na. ");
INSERT INTO msc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Awa, Allabatala ka a fɔ Musa yɛ ikɔ tuun ko: ");
INSERT INTO msc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«I ye wa a fɔ Misiran mansa Ferawuna yɛ ko a ye Isirayɛlika bila sa ii ri bɔ a la jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Musa ka Allabatala jabi: «Ni Isirayɛlika ma sɔn n na kuma ma. Ferawuna ri sɔn n na kuma ma wo rɔ wa? Wo kuma tɛ, baa nde ma kusan kumala.» ");
INSERT INTO msc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Allabatala kɔnin kumara Musa ni Haruna yɛ Isirayɛlika ni Misiran mansa Ferawuna la ko rɔ. A ka a fɔ ko ii ye Isirayɛlika labɔ Misiran. ");
INSERT INTO msc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isirayɛlika denbaya la kuntiilu tɔɔ le ɲin di. Isirayɛli dencɛ fɔlɔ tɔɔ le ko Rubɛn. Rubɛn dencɛilu tɔɔ le ten: Hanɔki, Palu, Hɛsirɔn, a ni Karimi. Nba, Rubɛn bɔnsɔn de ɲin di. ");
INSERT INTO msc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeyɔn dencɛilu tɔɔ le ten: Jɛmuwɛli, Jamin, Owadi, Jakin, Sohari, a ni Sawuli. Sawuli na tɛrɛ ye Kanaanka le ri. Nba, Simeyɔn bɔnsɔn de ɲin di. ");
INSERT INTO msc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Isirayɛli dencɛ Lebi ka san kɛmɛ ni san bisawa ni san wɔrɔnwula le sɔrɔn. Wo dencɛilu tɔɔ le ko Kerisɔn ni Kohati ni Merari. ");
INSERT INTO msc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kerisɔn dencɛilu tɛrɛ ye Libini ni Simeyi ri, wo bɛɛ ni a denbayala. ");
INSERT INTO msc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohati dencɛilu tɔɔ le ɲin di: Amuramu, Isehari, Heburɔn, a ni Usiyɛli. Kohati ka san kɛmɛ ni san bisawa a ni san sawa le sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari dencɛilu tɛrɛ ye Mahili ni Musi ri. Nba, woilu bɛɛ tɛrɛ ye Lebi bɔnsɔn mɔɔ le ri. ");
INSERT INTO msc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu ka a tɛnɛnmuso Jokebɛdi furu. Wo ka dencɛ fila sɔrɔn a yɛ, mɛnilu ye Haruna ni Musa ri. Amuramu ka san kɛmɛ ni san bisawa ni san wɔrɔnwula le sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isehari dencɛilu tɛrɛ ye Kora ni Nɛfɛki ni Sikiri ri. ");
INSERT INTO msc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiyɛli dencɛilu tɛrɛ ye Misayɛli ni Elisafan ni Sitiri ri. ");
INSERT INTO msc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haruna ka Aminadabu denmuso Eliseba le furu, mɛn ye Nasɔn dɔɔmuso ri. Eliseba ka dencɛ naanin sɔrɔn Haruna yɛ. Woilu tɔɔ ko Nadabu ni Abihu ni Elasari a ni Itamari. ");
INSERT INTO msc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora dencɛilu tɛrɛ ye Asiri ni Elakana ni Abiyasafu ri. Kora la bɔnsɔn le ɲin di. ");
INSERT INTO msc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Haruna dencɛ Elasari ka Putiyɛli denmuso do furu. Wo ka dencɛ sɔrɔn a yɛ, mɛn tɔɔ ko Finehasi. Nba, mɔɔ mɛnilu a ra madan ɲin, woilu ye Lebi bɔnsɔn mɔɔ la denbayala kuntiilu le ri, a bɛɛ ni a la mɔɔilu. ");
INSERT INTO msc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Allabatala kumara Haruna ni Musa woilu le yɛ, ka a fɔ ii yɛ ko ii ye Isirayɛlika labɔ Misiran ikomin kɛlɛden dɛkuru. ");
INSERT INTO msc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa ni Haruna le wara ka a fɔ Misiran mansa Ferawuna yɛ ko a ye Isirayɛlika bila sa ii ri bɔ a la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Nba, Allabatala kumara Musa yɛ Misiran tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","a ka a fɔ a yɛ ko: «Nde le Allabatala ri. N kɛtɔ fen fen fɔla i yɛ, i ye wa wo fɔ Misiran mansa Ferawuna yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Wo tuma, Musa ka Allabatala jabi: «Nde ma kusan kumala. Nfenna Ferawuna ri a tolo malɔ nde la wa?» ");
INSERT INTO msc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Allabatala ka Musa jabi: «N di ile kɛ Ferawuna ɲana ikomin Alla. I kɔrɔcɛ Haruna ri kɛ ikomin i la nabi. ");
INSERT INTO msc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","N wa fen fen fɔ i yɛ, i ye wo fɔ i kɔrɔcɛ Haruna yɛ. Ale ri wo lase Ferawuna ma. Haruna ri a fɔ a yɛ ko a ye Isirayɛlika bila sa ii ri bɔ a la jamana rɔ, ");
INSERT INTO msc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","kɔni nde le a kɛla Ferawuna jusu ri a ragbɛlɛya. N di n na tɔɔmasere ni kabannakoilu siyaya Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Hali wo, Ferawuna tɛ sɔn ai la kuma ma. Wo rɔ, n di n wuli Misirankailu kanma ka n na sebaya ba yiraka ii la, ka ko latɔn ii la kojuuya. N di n na jama Isirayɛlika labɔ Misiran ikomin kɛlɛden kuru. ");
INSERT INTO msc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","N wa n wuli Misirankailu kanma ka n na sebaya yiraka ii la, ka ban ka Isirayɛlika labɔ ii tɛma, Misirankailu ri a lɔn ko nde le ye Allabatala ri.» ");
INSERT INTO msc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa ni Haruna ka Allabatala kan mira ka a kɛ ikomin a ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa ni Haruna wara kuma Ferawuna yɛ tuma mɛn na, Musa sɔrɔn tun da san biseyin bɔ. A kɔrɔcɛ Haruna sɔrɔn tun da san biseyin ni san sawa bɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nba, Allabatala ka a fɔ Musa ni Haruna yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Ferawuna a wa a fɔ ai yɛ tuma mɛn na ko ai ye tɔɔmasere kabannako do kɛ, ile Musa, i ye a fɔ Haruna yɛ ko a ye a la gbeleke lafili duu ma Ferawuna ɲakɔrɔ. Gbeleke ri yɛlɛman ka kɛ sa ri.» ");
INSERT INTO msc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musa ni Haruna wara ii lɔ Ferawuna ɲakɔrɔ. Allabatala tun ka mɛn fɔ ii yɛ, ii ka wo kɛ. Haruna ka a la gbeleke lafili duu ma Ferawuna ni a la mɔɔilu ɲakɔrɔ. Gbeleke yɛlɛmanda ka kɛ sa ri ii ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ferawuna ka Misiran mɔɔ famunninilu ni senkolailu kili. Woilu fanan ka ko wo ɲɔɔn kɛ ii la daliluilu la. ");
INSERT INTO msc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ii bɛɛ ka ii la gbelekeilu lafili duu ma. Woilu fanan yɛlɛmanda ka kɛ sailu ri, kɔni Haruna ta ka ii tailu lakunun. ");
INSERT INTO msc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Wo bɛɛ ni a ta, Ferawuna jusu a ragbɛlɛyanin de tɛrɛ fɔlɔ. A ma sɔn Musa ni Haruna la kuma ma ikomin Allabatala tun ka a fɔ a yɛ ɲa mɛn ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Nba, Allabatala ka a fɔ Musa yɛ ko: «Ferawuna jusu a ragbɛlɛyanin. A banni mɔɔilu bila ko ma. ");
INSERT INTO msc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sini sɔɔma Ferawuna ri bɔ ka wa Nili Ba da la. I ye wa a tɛrɛn ye a wa tumana. Gbeleke mɛn yɛlɛmanda ka kɛ sa ri, i ye wo ta i bolo ka wa a ɲɔɔnbɛn ba da la ye. ");
INSERT INTO msc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","I ye a fɔ a yɛ ko: ‹Allabatala mɛn ye Heburuilu Maari Alla ri, a ka n lawa i ma. Ko a ka a fɔ i yɛ ko: «N na mɔɔilu bila sa ii ri wa n bato kanma wula kɔndɔ.» Ko kɔni haan bi, i ma sɔn kuma wo ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","18","Ko Allabatala ka a fɔ ko: «I ye i ɲa lɔ! Ko n di Nili Ba ji gbasi n na gbeleke la, gbeleke mɛn ye n bolo. Ko ba ri yɛlɛman ka kɛ jeli ri wo rɔ. Ko jɛɛ mɛnilu ye ba ji rɔ, ko woilu ri faa. Ko ba ri toli ka a suma bɔ. Ko Misirankailu ti nala sela Nili Ba ji minna. Ko ka a la wo kan, ko ale Ferawuna ri a lɔn ko nde le Allabatala ri.»›» ");
INSERT INTO msc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Allabatala ka a fɔ Musa yɛ ikɔ tuun ko: «I ye a fɔ Haruna yɛ ko a ye a la gbeleke ta ka a rasɔmɔn Misiran jiilu kun na, bailu wo, kɔilu wo, dalailu wo, a ni denka jimanilu wo. Ji wo bɛɛ ri yɛlɛman ka kɛ jeli ri. Ji ye yɔrɔ yɔrɔ rɔ, hali mɛn ye daa jirilamanilu ni daa kabalamanilu kɔndɔ, wo bɛɛ ri yɛlɛman ka kɛ jeli ri.» ");
INSERT INTO msc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Allabatala ka mɛn fɔ Musa ni Haruna yɛ, ii ka wo mira ka a kɛ. A ka a la gbeleke kɔrɔta ka Nili Ba ji gbasi a la Ferawuna ni a la mɔɔilu ɲakɔrɔ. Ji wo bɛɛ yɛlɛmanda ka kɛ jeli ri. ");
INSERT INTO msc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Jɛɛilu faara. Ba tolira ka a suma bɔ. Wo rɔ, Misirankailu ma se ba ji minna. Ji yɛlɛmanda ka kɛ jeli ri Misiran yɔrɔ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Misiran senkolailu kɔnin wo fanan ka wo ɲɔɔn kɛ ii la daliluilu la. Wo rɔ, Ferawuna jusu a ragbɛlɛyanin tora ikomin Allabatala ka a fɔ a yɛ ɲa mɛn ma. A ma sɔn Musa ni Haruna la kuma ma. ");
INSERT INTO msc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","A ka a kɔ don ii la ka a kɔsɛ a wara. Musa ni Haruna tun ka mɛn kɛ, a ma wo jate. ");
INSERT INTO msc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Misirankailu bɛɛ ka denkailu sen Nili Ba dafɛ min ji ɲinin kanma, baa ii tun ti se ba ji minna. ");
INSERT INTO msc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nba, Allabatala ka Nili Ba ji yɛlɛman ka a kɛ jeli ri. Wo ka tele wɔrɔnwula le kɛ. Wo dafara. ");
INSERT INTO msc_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Wo kɔ rɔ, Allabatala ka a fɔ Musa yɛ ko: «Ai ye wa a fɔ Ferawuna yɛ ko: ‹Allabatala ka a fɔ ko: «N na mɔɔilu bila sa ii ri wa n bato kanma. ");
INSERT INTO msc_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ko ni i ma sɔn ka ii bila sa ii ri wa, ko n di todilu lasiyaya ka i la jamana yɔrɔ bɛɛ lafa. Ko woilu ri kɛ tɔrɔya ba ri. ");
INSERT INTO msc_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Ko Nili Ba ji ri lafa todilu la. Ko ii ri bɔ ba ji rɔ ka wa i jɛrɛ la bon kɔndɔ, ka don i sibon kɔndɔ, ka yɛlɛ hali i la lafen kan, ka don i la jamana ɲɛmɔɔilu ni i la mɔɔilu bɛɛ la bonilu kɔndɔ. Ko todilu ri don hali buru gbasi diyailu rɔ, a ni buru gbasi muranilu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Ko todilu ri yɛlɛ ile ni i la jamana ɲɛmɔɔilu ni i la mɔɔilu bɛɛ kan.»›» ");
INSERT INTO msc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Allabatala ka a fɔ Musa yɛ ko: «I ye a fɔ Haruna yɛ ko a ye a la gbeleke ta ka wo rasɔmɔn bailu ni kɔilu ni denka jiman yɔrɔilu kun na ka todilu lana Misiran jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Wo rɔ, Haruna ka a la gbeleke rasɔmɔn Misiran jiilu kun na. Todilu bɔra ji rɔ wo rɔ, ka Misiran jamana yɔrɔ bɛɛ fa. ");
INSERT INTO msc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ferawuna la senkolailu kɔnin fanan ka wo ɲɔɔn kɛ ii la daliluilu la. Ii fanan ka todilu lana Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ferawuna ka Musa ni Haruna kili ka a fɔ ii yɛ ko: «Ai ye Allabatala madiya ko a ye todi ɲinilu bɔ nde ni n na mɔɔilu kan. Ni wo kɛra, n di Isirayɛlika bila sa ii ri wa saraka bɔ Allabatala yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musa ka a fɔ Ferawuna yɛ ko: «N fa, bonya ye i bolo sisen ka a waati latɛɛ. I ye a fɛ n ye Allabatala madiya ile ni i la ɲɛmɔɔilu ni i la jamana kɔndɔ mɔɔilu yɛ waati ɲuman na, sa todilu ri mabɔ ai ni ai la bonilu la? N wa Allabatala madiya, todilu tɛ kɛ yɔrɔ si rɔ butun fɔɔ Nili Ba rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ferawuna ka a fɔ ko: «I ye madiyali kɛ n yɛ sini.» Musa ka a fɔ ko: «I ka mɛn fɔ, a ri kɛ ten, sa i ri a lɔn ko an Maari Allabatala ɲɔɔn si tɛ. ");
INSERT INTO msc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Todilu ri mabɔ i ni i la bonilu la, a ni i la jamana ɲɛmɔɔilu ni i la mɔɔilu bɛɛ la. Todilu tɛ kɛ yɔrɔ si butun fɔɔ Nili Ba rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Musa ni Haruna bɔra Ferawuna wara ka wa. Musa ka Allabatala madiya kosɛbɛ todilu la ko rɔ, Allabatala tun ka mɛnilu lana Ferawuna tɔrɔya diya. ");
INSERT INTO msc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa ka Allabatala madiya mɛn na, Allabatala ka wo kɛ. Todilu bɛɛ faara bonilu kɔndɔ, a ni bondailu kɔndɔ, a ni sɛnɛilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Misirankailu ka todi suilu ton nadɛn ii ɲɔɔn kan. Woilu tolira ka ii suma bɔ jamana yɔrɔ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ferawuna ka a yen tuma mɛn na ko tɔrɔya wo ra bɔ a kan, a ka a jusu nagbɛlɛya ikɔ tuun kosɛbɛ, ikomin Allabatala tun ka a fɔ ɲa mɛn ma. A tun tɛ sɔnna Musa ni Haruna la kuma ma. ");
INSERT INTO msc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Nba, Allabatala ka a fɔ Musa yɛ ko: «I ye a fɔ Haruna yɛ ko a ye a la gbeleke kɔrɔta ka duu buuri gbasi a la. Buuri ri yɛlɛman ka kɛ wolowoloniilu ri Misiran jamana fan bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Musa ni Haruna ka Allabatala kan mira ka wo kɛ. Haruna ka a la gbeleke kɔrɔta ka duu buuri gbasi a la. Buuri yɛlɛmanda ka kɛ wolowoloniilu ri Misiran jamana fan bɛɛ rɔ. Wolowoloniilu tɛrɛ ye mɔɔilu ni niimafen bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ferawuna la senkolailu tɛrɛ ye a tɔrɔfɛ ii ka buuri yɛlɛman ka a kɛ wolowoloniilu ri ii la daliluilu la, kɔni ii ma se wo kɛla. Wolowoloniilu tora mɔɔilu ni niimafenilu tɔrɔla. ");
INSERT INTO msc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ferawuna la senkolailu ka a fɔ Ferawuna yɛ ko: «Ko ɲin kɛni Alla le bolo de!» Ferawuna kɔnin a jusu a ragbɛlɛyanin de tɛrɛ. A ma sɔn Musa ni Haruna la kuma ma ikomin Allabatala tun ka a fɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nba, Allabatala ka a fɔ Musa yɛ ko: «I ye i wuli sɔɔma da la jona ka wa Ferawuna kunbɛn. A wa kɛ wala ji da la tuma mɛn na, i ye wa a tɛrɛn ye. I ye a fɔ a yɛ ko: ‹Allabatala ka a fɔ ko: «N na mɔɔilu bila sa ii ri wa n bato. ");
INSERT INTO msc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ko ni i ma sɔn n na mɔɔilu bila ko ma, n di siten siyaman siyaman ba lana, siten mɛnilu ye mɔɔilu cinna. Ko woilu ri wara i ni i la ɲɛmɔɔilu ni i la jamana mɔɔilu ma. Ko sitenilu ri don i jɛrɛ la bonilu la, ka Misirankailu la bonilu fanan fa. Ko sitenilu ri siyaya ka duu lafin. ");
INSERT INTO msc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ko kɔni n wa sitenilu lana lon mɛn, n di Kosɛni jamana wo mara ka ii latanka woilu ma, n na mɔɔilu siini yɔrɔ mɛn dɔ kɔnin. Ko sitenilu ti se yɔrɔ wo rɔ muumɛ. Ko n di wo kɛ sa i ri a lɔn ko nde Allabatala ye Misiran jamana rɔ yan. ");
INSERT INTO msc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ko i la mɔɔilu ri tɔrɔya mɛn sɔrɔn sitenilu bolo, n di n na mɔɔilu latanka wo ma. Ko tɔɔmasere kabannako wo ri kɛ sini.»›» ");
INSERT INTO msc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nba, Allabatala tun ka a fɔ ɲa mɛn ma, a ka a kɛ wo ɲa. Sitenilu siyaman siyaman ba nara don Ferawuna la bon na, a ni a la ɲɛmɔɔilu la bonilu la. Jamana yɔrɔ bɛɛ tiɲanda sitenilu bolo. ");
INSERT INTO msc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ferawuna ka Musa ni Haruna kili, ka a fɔ ii yɛ ko: «Ai ye wa saraka bɔ ai Maari Alla ma, kɔni ai ye to jamana kɔndɔ yan.» ");
INSERT INTO msc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musa ka a fɔ ko: «Wo ti se kɛla, baa an di saraka mɛnilu bɔ an Maari Allabatala yɛ, saraka woilu ye Misirankailu tana le ri. Fen mɛn ye ii tana do ri, ni an ka wo kɛ saraka di ii ɲana, ii ti an mabon kaba la wa? ");
INSERT INTO msc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","An Maari Allabatala da an jamari ko an ye tele sawa kɛ taamala ka wa wula rɔ. Ko a wa saraka mɛn fɔ an yɛ ye, ko an ye wo bɔ a yɛ ye.» ");
INSERT INTO msc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ferawuna ka a fɔ ko: «Awa, n di ai bila sa ai ri wa wula rɔ ka saraka bɔ ai Maari Allabatala yɛ, kɔni ai kana wa yɔrɔ jan de. Ai ye madiyali kɛ n yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa ka a fɔ ko: «N wa bɔ i wara yan, n di Allabatala madiya i kɔrɔ. Wo rɔ, sitenilu ri bɔ ile ni i la ɲɛmɔɔilu ni i la jamana mɔɔilu kan sini, kɔni i kana janfa kɛ ikɔ tuun, ka i ban Isirayɛlika bila ko ma sa ii ri wa saraka bɔ Allabatala yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa bɔra Ferawuna tɔrɔfɛ ka wa Allabatala madiya. ");
INSERT INTO msc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Allabatala ka a kɛ ikomin Musa ka a madiya ɲa mɛn ma. A ka sitenilu bɔ Ferawuna ni a la ɲɛmɔɔilu ni a la jamana mɔɔilu kan. Hali siten kelen ma to ye. ");
INSERT INTO msc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ferawuna kɔnin a ka a jusu ragbɛlɛya ikɔ tuunni. A ma sɔn Isirayɛlika bila ko ma. ");
INSERT INTO msc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Wo tamin kɔ rɔ, Allabatala ka a fɔ Musa yɛ ko: «I ye wa a fɔ Ferawuna yɛ ko: ‹Heburuilu Maari Allabatala ka a fɔ ko: «N na mɔɔilu bila sa ii ri wa n bato. ");
INSERT INTO msc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ko ni i ka i ban ii bila ko ma ka ii to i bolo, ");
INSERT INTO msc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ko i la kolofen mɛnilu ye sɛnɛ rɔ, ko nde Allabatala ri i wuli woilu kanma n na sebaya la. Ko n di jankarɔ juu bila i la soilu la, a ni i la faliilu, a ni i la ɲɔɔmɛilu, a ni i la nisiilu, a ni i la saailu ni bailu. ");
INSERT INTO msc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ko kɔni nde Allabatala n di dannafarabɔ kɛ Isirayɛlika la kolofenilu ni Misirankailu la kolofenilu tɛma. Isirayɛlika la kolofen si tɛ faa.»›» ");
INSERT INTO msc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nba, Allabatala ri ko wo kɛ lon mɛn, a ra ban wo latɛɛla, baa a ka a fɔ ko: «Nde Allabatala n di ko wo kɛ jamana kɔndɔ sini.» ");
INSERT INTO msc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wo duu sa gbɛ, Allabatala ka a kɛ ikomin a tun ka a fɔ ɲa mɛn ma. Misirankailu la kolofenilu bɛɛ faara, kɔni foyi ma faa Isirayɛlika la kolofenilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ferawuna ka mɔɔilu lawa ko wo lakɔrɔsi kanma. Woilu wara ko wo lakɔrɔsili diya ka na a fɔ a yɛ ko foyi ma faa Isirayɛlika la kolofenilu rɔ. Wo bɛɛ ni a ta kɔnin, Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. A ma sɔn ka Isirayɛlika bila sa ii ri wa. ");
INSERT INTO msc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Wo kɛ mɛn kɛra, Allabatala ka a fɔ Musa ni Haruna yɛ ko: «Ai ye wa bolo ɲa dando ta buurigbɛ rɔ fen janin diya. Musa ye wa buurigbɛ wo lasadi san ma Ferawuna ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Wo ri jɛnsɛn Misiran jamana fan bɛɛ rɔ ikomin gbangban, ka sumuni bɔ mɔɔilu ni kolofenilu ma. Sumuninilu ri kɛ dailu ri mɔɔilu ni kolofenilu fariilu ma Misiran jamana fan bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nba, Musa ni Haruna wara buurigbɛ do ta fen janin diya ka wa ii lɔ Ferawuna ɲakɔrɔ. Musa ka buurigbɛ wo lasadi san ma. Buurigbɛ wo ka sumuni bɔ mɔɔilu ni kolofenilu ma. Sumuniilu kɛra dailu ri woilu fari ma. ");
INSERT INTO msc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ferawuna la senkolailu ma se nala ii lɔla Musa ɲakɔrɔ, baa sumuniilu tun da bɔ ii fari fan bɛɛ ma, ikomin Misiranka tɔilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Allabatala le ka a kɛ Ferawuna jusu gbɛlɛyani tɛrɛ. Ferawuna ma sɔn Musa ni Haruna la kuma ma ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Wo tamin kɔ rɔ, Allabatala ka a fɔ Musa yɛ ko: «I ye i wuli sɔɔma da la jona ka wa Ferawuna tɛrɛn ye. I ye a fɔ a yɛ ko: ‹Allabatala, Heburuilu Maari Alla kɔnin, wo ka a fɔ ko: «N na mɔɔilu bila sa ii ri wa n bato. ");
INSERT INTO msc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ko sisen, ko n di tɔrɔya lase ile ma, tɔrɔya mɛn di juuya kosɛbɛ. Ko tɔrɔya wo ri se i la ɲɛmɔɔilu ni i la mɔɔilu fanan ma. Ko n di tɔrɔya wo lase ii bɛɛ ma sa ile ri a lɔn ko n ɲɔɔn si tɛ dunuɲa ɲin dɔ. ");
INSERT INTO msc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ko n tun di se ka n bolo lawuli i ni i la mɔɔilu kanma, ka jankarɔ fitinna ba la ii kan. Ko ni n tun ka a kɛ ten, sa ii ra ban latununna ka bɔ duɲa rɔ. ");
INSERT INTO msc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ko kɔni n da i kɛndɛ to kosa n di n na sebaya yiraka i la. Ko ka a la wo kan, ko n da i kɛndɛ to sa n tɔɔ ri bonya dunuɲa fan bɛɛ rɔ fanan. ");
INSERT INTO msc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ko kɔni jɛrɛdabaya ye i rɔ fɔlɔ, baa i banni n na mɔɔilu bila ko ma. ");
INSERT INTO msc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ko ale le wo ri. Ko ɲin tuma sini, ko n di sancikoloilu lajii. Ko sancikoloilu wo ri juuya fɔɔ ka a dan natamin. Ko wo ɲɔɔn ma jii Misiran kɛbi Misiran jamana siira. ");
INSERT INTO msc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ko wo rɔ, ko i ye i la mɔɔilu jamari sisen ko ii ye wa ii la kolofenilu ni ii bolofenilu bɛɛ ta ka wa woilu ri yɔrɔ lakandannin do rɔ, sa sancikolo kana se ii ma. Ko mɔɔ ni kolofen mɛnilu wa to gbɛ rɔ sɛnɛ rɔ, mɛnilu ma ladon yɔrɔ lakandannin do rɔ, sancikolo di jii woilu kan ka woilu kelen kelenna bɛɛ faa.»›» ");
INSERT INTO msc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Nba, Ferawuna la ɲɛmɔɔ mɛnilu silanda Allabatala la kuma yɛ, woilu borimantɔ wara ii la jɔnilu ni ii la kolofenilu ladon yɔrɔ lakandannin doilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mɛnilu kɔnin ma Allabatala la kuma jate, woilu ka ii la jɔnilu ni ii la kolofenilu to sɛnɛ rɔ ye. ");
INSERT INTO msc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Allabatala ka a fɔ Musa yɛ ko: «I ye i bolo kɔrɔta san ma sa sancikolo a ri jii Misiran jamana bɛɛ kan. A ri jii mɔɔilu ni kolofenilu ni sɛnɛfenilu bɛɛ kan Misiran fan bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Awa, Musa ka a la gbeleke kɔrɔta san ma tuma mɛn na, Allabatala ka bandakan nabɔ ka sancikoloilu lajii, ka ta lajii fɔɔ duu ma. Allabatala ka sancikoloilu lajii Misiran jamana kan ikomin sanci ba. ");
INSERT INTO msc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sancikoloilu tɛrɛ ye jiila. Ta tɛrɛ ye jiila yɔrɔ bɛɛ. Kɛbi Misiran jamana siira, sancikoloilu wo ɲɔɔn tun ma jii fɔlɔ, baa a juuyara kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sancikoloilu ka mɔɔilu ni kolofenilu halaki Misiran jamana fan bɛɛ rɔ, mɔɔ ni kolofen mɛnilu tora gbɛ ma sɛnɛilu rɔ kɔnin. A ka sɛnɛfenilu bɛɛ tiɲan fanan, ka jiriilu bɛɛ kadi kadi. ");
INSERT INTO msc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Wo kɛra fan bɛɛ rɔ fo Kosɛni mara kelen, Isirayɛlika siini yɔrɔ mɛn kɔnin. Sancikoloilu ma se ye le. ");
INSERT INTO msc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ferawuna ka Musa ni Haruna kili ka a fɔ ii yɛ ko: «N da kojuu kɛ siɲa ɲin dɔ. Jo ye Allabatala de bolo. Jo tɛ nde ni n na mɔɔilu le bolo. ");
INSERT INTO msc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ai ye Allabatala madiya, baa Alla la bandakan ni a la sancikoloilu ii ra an bɔ. N di ai bila. N tɛ ai lalɔla butun.» ");
INSERT INTO msc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa ka a fɔ a yɛ ko: «N wa bɔ so kɔndɔ tuma mɛn na, n di n boloilu kɔrɔta Allabatala yɛ. Bandakan ni sancikoloilu ri i lɔ, sa i ri a lɔn ko dunuɲa ye Allabatala ta le ri, ");
INSERT INTO msc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","kɔni n ka a lɔn ko ile ni i la ɲɛmɔɔilu ma silan Allabatala Alla yɛ fɔlɔ fewu!» ");
INSERT INTO msc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nba, sɛnɛfen mɛn tɔɔ ko lin, wo tun da fɛrɛn. Mɛn tɔɔ ko horija, wo tun da a kisɛ. Sancikoloilu ka wo fila bɛɛ tiɲan, ");
INSERT INTO msc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","kɔni sɛnɛfen mɛn tɔɔ ko bile, wo su fila ma tiɲan sancikolo bolo baa woilu tɛ fɛrɛnna jona. ");
INSERT INTO msc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nba, Musa bɔra Ferawuna wara ka wa so kɔkan. A ka a bolo lawuli Allabatala yɛ ka a madiya. Bandakan ni sancikolo tɛɛra. Sanci tɛɛra. ");
INSERT INTO msc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ferawuna ka a yen tuma mɛn na ko sanci ni sancikolo ni bandakan a ra lalɔ, a ka kojuu kɛ ikɔ tuunni, baa a ni a la ɲɛmɔɔilu ka ii jusu gbɛlɛya. ");
INSERT INTO msc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. A ma sɔn ka Isirayɛlikailu bila sa ii ri wa. Wo kɛra ikomin Allabatala a tun ka kuma don Musa da rɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Sancikolo ban kɔ jii la Misirankailu kan wo kɛ, Allabatala ka a fɔ Musa yɛ ko: «I ye wa Ferawuna tɛrɛn ye. Nde le ka a kɛ a ni a la ɲɛmɔɔilu jusu gbɛlɛyani, sa n di se n na tɔɔmasere kabannako ɲinilu kɛla ii ɲana. ");
INSERT INTO msc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ka a la wo kan, nde le ka wo kɛ sa ai ri a fɔ ai denilu ni ai mamarenilu yɛ n ka tɔɔmasere kabannako mɛnilu kɛ Misirankailu tɛma ka ii dɔɔya ɲa mɛn ma. Ai bɛɛ ri a lɔn ko Allabatala le nde ri.» ");
INSERT INTO msc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musa ni Haruna wara Ferawuna tɛrɛn ye, ka a fɔ a yɛ ko: «Heburuilu Maari Allabatala ka a fɔ ko: ‹I ri sɔn ka i fanmajii nde yɛ lon ɲuman? Ko i ye n na mɔɔilu bila sa ii ri wa n bato. ");
INSERT INTO msc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ko ni i ka i ban n na mɔɔilu bila ko ma, ko n di tɔɔnkasailu lana i la jamana kɔndɔ sini. ");
INSERT INTO msc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ko woilu ri siyaya ka yɔrɔ bɛɛ mira fɔɔ ka duu fin. Ko wo rɔ, ko mɔɔilu ti nala sela ka duu yen butun. Ko sancikoloilu ma sɛnɛfen mɛnilu tiɲan, tɔɔnkasailu ri wo bɛɛ dɔɔn. Ko jiri jiri ye sɛnɛ rɔ, tɔɔnkasailu ri wa firailu bɛɛ dɔɔn. ");
INSERT INTO msc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ko ii ri i la bonilu fa, ka i la ɲɛmɔɔilu ni Misirankailu bɛɛ la bonilu fa. Ko n di kɛ tɔɔnkasa siyaman ba ri, i failu ni i benbailu ma mɛn ɲɔɔn yen kɛbi ii ka ii sii jamana kɔndɔ yan.›» Musa banni wo fɔla, a bɔra Ferawuna wara ka wa. ");
INSERT INTO msc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ferawuna la ɲɛmɔɔilu ka a fɔ Ferawuna yɛ ko: «An fa, cɛɛ wo ri an tɔrɔ haan waati ɲuman? I ti sɔn ka ii la mɔɔilu bila wa, sa ii ri wa ii Maari Allabatala bato? Misiran da tiɲan, i ma wo ɲayen fɔlɔ wa?» ");
INSERT INTO msc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Wo rɔ, Ferawuna ka Musa ni Haruna kili ikɔ tuun, ka a fɔ ii yɛ ko: «Ai ye wa ai Maari Allabatala bato, kɔni yon ni yon watɔ?» ");
INSERT INTO msc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa ka a jabi: «An bɛɛ ri wa, den mɛsɛnilu wo, mɔɔbakɔrɔilu wo, cɛɛilu wo, musoilu wo, an bɛɛ ri wa. An na kolofenilu bɛɛ ri wa an bolo fanan, baa an watɔ sali ba le kɛla Allabatala yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ferawuna ka a fɔ ii yɛ ko: «Ka ai ni ai musoilu ni ai denilu bɛɛ bila sa ai ri wa, n ti sɔn wo ma habadan! Ai ye n janfa ko le rɔ. ");
INSERT INTO msc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ɛɛn de! Cɛɛilu dɔrɔn ye wa Allabatala bato, baa ai ka wo le maɲininka.» Ferawuna ka Musa ni Haruna gbɛn wo rɔ, ka ii labɔ a wara. ");
INSERT INTO msc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Allabatala ka a fɔ Musa yɛ ko: «I ye i bolo kɔrɔta Misiran jamana kun na sa tɔɔnkasailu ri na jamana kɔndɔ. Ii ri na jamana kɔndɔ sɛnɛfen ni bin bɛɛ dɔɔn, mɛnilu tora ye sancikolo bolo kɔnin.» ");
INSERT INTO msc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musa ka a la gbeleke kɔrɔta Misiran jamana kun na. Allabatala ka fɔɲɔ ba do lana ka bɔ telebɔ fan fɛ. Fɔɲɔ ka tele ni su bɛɛ kɛ tɛɛla. Wo duusa gbɛ da ka a tɛrɛn fɔɲɔ a ra tɔɔnkasailu lana. ");
INSERT INTO msc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tɔɔnkasailu jɛnsɛnda ka Misiran yɔrɔ bɛɛ mira, ka i sii fan bɛɛ rɔ. Ii ka siya tɛrɛ kojuuya. Misirankailu tun ma wo ɲɔɔn yen fɔlɔ fewu. Ii ti nala wo ɲɔɔn yenna butun. ");
INSERT INTO msc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tɔɔnkasailu ka duu bɛɛ mira fɔɔ ka a bɛɛ fin. Ii ka sɛnɛfenilu ni binilu bɛɛ dɔɔn, a ni jiridenilu bɛɛ. Sancikolo tun ma mɛnilu tiɲan, ii ka wo bɛɛ dɔɔn. Ii ma fira si to jiriilu la. Ii ma sɛnɛfen ni bin si to sɛnɛilu rɔ, mɛn ma dɔɔn. A kɛra wo ɲa le ma Misiran jamana yɔrɔ bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ferawuna ka Musa ni Haruna kili i kɔrɔ, ka a fɔ ii yɛ ko: «Nde le ra kojuu kɛ ai Maari Allabatala la. N da kojuu kɛ ai fanan na. ");
INSERT INTO msc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ai jaandi, ai ye yafa n ma mɛn fanan dɔ. Ai ye ai Maari Allabatala madiya n yɛ, sa a ri tɔrɔya juu ɲin mabɔ n na.» ");
INSERT INTO msc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa bɔra Ferawuna wara wo rɔ, ka wa Allabatala madiya. ");
INSERT INTO msc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Wo rɔ, Allabatala ka fɔɲɔ ba lana ka bɔ telebe rɔ. Fɔɲɔ wo ka tɔɔnkasailu ta ka wa ii lafili Kɔɔji Fararɔbin dɔ. Tɔɔnkasa kelen ma to Misiran jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kɔni, Allabatala le ka Ferawuna jusu a ragbɛlɛya. A ma sɔn ka Isirayɛlikailu bila, sa ii ri wa. ");
INSERT INTO msc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Allabatala ka a fɔ Musa yɛ ikɔ tuunni ko: «I ye i bolo kɔrɔta san ma sa dibi ri don Misiran jamana kɔndɔ. Dibi wo ri bonya ka kɛ ikomin mɔɔ ri se a bolo maala a la.» ");
INSERT INTO msc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa ka a bolo kɔrɔta san ma. Dibi fin juu donda Misiran jamana bɛɛ rɔ ka tele sawa kɛ. ");
INSERT INTO msc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tele sawa wo kɔrɔ, Misirankailu ma se ii ɲɔɔn yenna muumɛ. Ii si ma se bɔla bon na, kɔni Isirayɛlikailu siini tɛrɛ yɔrɔ yɔrɔ, kɛnɛya tɛrɛ ye yɔrɔ wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ferawuna ka Musa kili ka a fɔ a yɛ ko: «Nba, ai ye wa Allabatala bato. Ai musoilu ni ai den mɛsɛnilu ri wa ai kɔfɛ, kɔni ai la kolofenilu ye to ai kɔma yan.» ");
INSERT INTO msc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa ka a fɔ ko: «Wo tɛ bɛn. Fo i ye a to an na kolofenilu ye wa an bolo, baa an di wo doilu kɛ sarakailu a ni doilu saraka janintailu ri an Maari Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Fo an na kolofenilu ye wa an bolo. Hali an na kolofen kelen pe tɛ to an kɔma yan, baa an kɛtɔ doilu le kɛla saraka ri an Maari Allabatala yɛ, kɔni an di mɛn kɛ saraka ri a yɛ, an ti nala wo lɔnna fɔɔ an wa se ye tuma mɛn na.» ");
INSERT INTO msc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Allabatala kɔnin ka a kɛ Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. Ferawuna ma sɔn ka Isirayɛlika bila, sa ii ri wa. ");
INSERT INTO msc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ferawuna ka a fɔ Musa yɛ ko: «Bɔ n ɲakɔrɔ! I kana i lɔ n ɲakɔrɔ butun. I wa na i lɔ n ɲakɔrɔ lon lon, i ri faa wo lon!» ");
INSERT INTO msc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa ka a fɔ ko: «Ale le wo ri. N da wo mɛn. N tɛ i lɔ i ɲakɔrɔ butun.» ");
INSERT INTO msc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Nba, Allabatala ka a fɔ Musa yɛ ko: «A ra to tɔrɔya kelen ma, n di mɛn la Ferawuna ni a la mɔɔilu kan. N wa wo la Ferawuna kan, a ri ai bila sa ai ri wa. Wo tuma a ri i gbɛn fewu. ");
INSERT INTO msc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","I ye wa a fɔ Isirayɛlikailu yɛ ko ii bɛɛ ye ii siiɲɔɔ Misirankailu tara fen saninnaman ni fen wodigbɛlaman na.» ");
INSERT INTO msc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Allabatala ka Isirayɛlika la ko diya Misirankailu yɛ kosɛbɛ. Ferawuna la ɲɛmɔɔilu ni a la jamana kɔndɔ mɔɔilu bɛɛ tɛrɛ ye Musa bonyala kosɛbɛ fanan. ");
INSERT INTO msc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa ka a fɔ ko: «Allabatala ka a fɔ ko: ‹Su tala waati, n di tamin Misiran jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Dencɛ fɔlɔilu bɛɛ ri sa Misiran jamana kɔndɔ. Ale mɛn ye mansayala, a dencɛ fɔlɔ ti nala tola ye. Hali jɔnmuso mɛn ye kɔlɔn tuu kɛla ye, wo fanan dencɛ fɔlɔ ti nala tola ye. Ii bɛɛ ri sa. Ii la kolofenilu fanan den fɔlɔ cɛmanta wo fanan ti nala tola. ");
INSERT INTO msc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mɔɔilu ri ii kule kan nabɔ kojuuya Misiran jamana fan bɛɛ rɔ. Wo ɲɔɔn ma kɛ fɔlɔ. A ɲɔɔn ti nala kɛla butun. ");
INSERT INTO msc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kɔni a mankan tɛ kɛ Isirayɛlikailu wara. Hali wulu tɛ wonwon ii ma, wala ii la kolofenilu ma. Ai ri a lɔn wo rɔ ko Allabatala a ra dannafarabɔ don Misirankailu ni Isirayɛlika tɛma.›» ");
INSERT INTO msc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Musa ka a fɔ Ferawuna yɛ ko: «Ko wo wa kɛ, i la ɲɛmɔɔilu ri na ka ii la n kɔrɔ ka n madiya ko n ye bɔ Misiran jamana rɔ yan, nde ni n na mɔɔilu bɛɛ. Wo wa kɛ, n di bɔ jamana ɲin dɔ yan.» Musa banni wo fɔla, a mɔnɛni ba le bɔra Ferawuna wara ka wa. ");
INSERT INTO msc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Allabatala ka a fɔ Musa yɛ ko: «Ferawuna tɛ sɔn ai la kuma ma. Wo ri kɛ sababu ri sa n di doilu la n na kabannakoilu kan Misiran jamana kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa ni Haruna ka kabannako woilu bɛɛ kɛ Ferawuna ɲakɔrɔ, kɔni Allabatala ka a kɛ Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. A ma sɔn ka Isirayɛlikailu bila, sa ii ri bɔ a la jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nba, ka Musa ni Haruna to Misiran jamana kɔndɔ, Allabatala ka a fɔ ii yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Ai ye karo ɲin jate ai la karo fɔlɔ ri. A ri kɛ ai la san damira karo ri. ");
INSERT INTO msc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ai ye a fɔ Isirayɛlikailu bɛɛ yɛ ko: ‹Karo ɲin tele tan, cɛɛ bɛɛ ye saaden wala baden mira a la denbaya yɛ, denbaya kelen kolofen kelen, ");
INSERT INTO msc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","kɔni ni denbaya mɛn mɔɔilu ma siya, ii ni ii siiɲɔɔilu ye dɛn kolofen kelen na, siiɲɔɔ mɛnilu sudunman ii la kɔnin. Ii ye kolofen do faa, mɛn di mɔɔilu bɛɛ bɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kolofen wo ye kɛ san kelen saaji wala bakɔrɔn di, fɛɛ tɛ mɛn na. ");
INSERT INTO msc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ii ye kolofen wo lamara fɔɔ karo ɲin tele tan ni naanin. Wo lon, Isirayɛlikailu bɛɛ ye ii ta faa fitiri waati. ");
INSERT INTO msc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ii kɛtɔ kolofenilu sobo dɔɔnna bon mɛnilu kɔndɔ, ii ye kolofenilu jeli do ta ka a susa bonda fodufɛla filaman ni ii da kankun kan. ");
INSERT INTO msc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ii ye sobo wo janin ka a dɔɔn su wo jɛrɛ rɔ. Ii ye wo ni buru fununbali ni fira kunamanta dɔɔn kelen di. ");
INSERT INTO msc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ai kana a kɛndɛ dɔɔn. Ai kana a tibi ji la ka a dɔɔn. Ai ye a gbunturun de janin, hali a kun, ni a gbɛlɛn, ni a kɔndafen bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ai kana sobo a tɔ si lasii. Ni a tɔ tora sɔɔma, ai ye wo janin ka a kɛ buuri ri. ");
INSERT INTO msc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ai ka kan ka sobo wo dɔɔn ɲa mɛn ma, wo le ɲin di: ai ye ai tɛsidi taama kanma, ka ai la sanbara don. Ai ye ai la gbeleke mira ai bolo. Ai ye ai kaliya sobo wo dɔɔnna. Allabatala la Taminkunna Sali le wo ri. ");
INSERT INTO msc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«‹Baa n di tamin Misiran jamana yɔrɔ bɛɛ rɔ su wo jɛrɛ rɔ ka Misiran jamana dencɛ fɔlɔilu ni kolofen den cɛmanta fɔlɔilu bɛɛ faa. N di jahadi la Misirankailu la batofenilu bɛɛ kan. Allabatala le nde ri. ");
INSERT INTO msc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Kɔni jeli mɛn susani bondailu la, wo ri kɛ tɔɔmasere ri ka a yiraka n na ko ai ye bon woilu le kɔndɔ. N wa jeli wo yen, n di tamin ai kun na. Wo rɔ, ka n to Misirankailu gbasila, kojuu si ti nala sela ai ma. ");
INSERT INTO msc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Lon ɲin ye kɛ ai bolo hankilijii lon ba ri kadawu. Ni wo lon sera san san, ai ye sali ba kɛ ka nde Allabatala bonya. Sali ko wo ye kɛ sariya banbali ri ai bolo, a ni ai bɔnsɔnilu bolo, mɛnilu natɔ ai kɔ.›» ");
INSERT INTO msc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Allabatala ka a fɔ ikɔ tuun ko: «Ai ye buru fununbali dɔɔn tele wɔrɔnwula kɔrɔ. Wo tele fɔlɔ, ai ye lɛbɛn bɛɛ labɔ ai la bonilu la. Ni mɔɔ mɔɔ ka buru lɛbɛnniman dɔɔn tele wɔrɔnwula wo kɔrɔ, wo tii ri gbɛn ka bɔ Isirayɛlikailu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","A tele fɔlɔ, ai ye ai ladɛn ka nde Allabatala bato. A tele wɔrɔnwulana fanan, ai ye ai ladɛn ka nde Allabatala bato. Ai kana baara si kɛ tele woilu rɔ. Ka tibili kɛ ai jɛrɛ yɛ, n ma a fɔ wo ma. ");
INSERT INTO msc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Ai ye Buru Fununbali Sali wo kɛ san san, baa wo lon jɛrɛ le rɔ, n ka ai labɔ Misiran ikomin kɛlɛden kuru. Wo le rɔ, ni wo lon sera san san, ai ye sali wo kɛ. Sali ko wo ye kɛ sariya banbali ri ai bolo, a ni ai bɔnsɔnilu bolo, mɛnilu natɔ ai kɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","San karo fɔlɔ ɲin, ka bɔ tele tan ni naanin fitiri waati ka wa se tele muwan ni kelen fitiri waati, ai kana buru lɛbɛnniman dɔɔn, fo buru fununbali. ");
INSERT INTO msc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tele wɔrɔnwula woilu bɛɛ kɔrɔ, lɛbɛn si kana yen ai la bonilu la. Ni mɔɔ mɔɔ ka buru lɛbɛnman dɔɔn, wo tii ri gbɛn ka bɔ Isirayɛlikailu la dɛkuru rɔ. Ni a kɛra londan di, ni a kɛra duuren di, a ri gbɛn ka bɔ Isirayɛlikailu la dɛkuru rɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ai kana buru si dɔɔn, lɛbɛn ye mɛn dɔ. Ai wa ai sii yɔrɔ yɔrɔ rɔ, ai ye buru fununbali dɔɔn.» ");
INSERT INTO msc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa ka Isirayɛlikailu la mɔɔbakɔrɔilu bɛɛ kili ka a fɔ ii yɛ ko: «Ai bɛɛ ye wa sisen ka kolofen mɛsɛn mira ai la denbayailu yɛ ka a kannatɛɛ ka Taminkunna Sali kɛ. ");
INSERT INTO msc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ai ye kolofen wo jeli kɛ muran do kɔndɔ. Jiri mɛn tɔɔ ko hisopi, ai ye wo bolo do sun jeli wo rɔ, ka jeli susa bonda lamininilu rɔ, a da kankun kan ni a bonda fodufɛla fila ma kɔnin. Mɔɔ si kana bɔ a la bon na fɔɔ sɔɔma. ");
INSERT INTO msc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Allabatala ri tamin Misiran jamana kɔndɔ ka Misirankailu dencɛ fɔlɔilu faa su rɔ. Ni a ka jeli yen a da kankun kan ni a bonda fodufɛla filaman ma, a ri tamin bon wo kun na. A ti sɔn niitɛɛ mɛlɛka ye don ai la bon woilu la ka ai dencɛ fɔlɔilu faa. ");
INSERT INTO msc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Ai ni ai bɔnsɔnilu ye to sali ɲin kɛla san san haan kadawu. A ye sariya banbali le ri. ");
INSERT INTO msc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Allabatala ka lahidi ta ko a ri jamana mɛn di ai ma, ai wa se ye tuma mɛn na, ai ye sali ɲin kɛ. ");
INSERT INTO msc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ni ai denilu ka sali ɲin kɔrɔ maɲininka ai la, ");
INSERT INTO msc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ai ye a fɔ ii yɛ ko: ‹An ye kolofen wo kɛla Taminkunna Sali saraka de ri ka Allabatala bonya. Ko ka an to Misiran, Allabatala nara ka Misirankailu dencɛ fɔlɔilu faa. Ko wo tuma, a taminda an na bonilu kun na ka an na denbayailu to ye.›» Nba, Musa banni wo bɛɛ fɔla, Isirayɛlikailu ka ii ɲakɔrɔ bɛn duu ma ka Allabatala bato. ");
INSERT INTO msc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Wo kɔ rɔ, ii bɔra ye ka wa a kɛ ikomin Allabatala tun ka a fɔ Musa ni Haruna yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nba, duu talaman, Allabatala ka dencɛ fɔlɔilu bɛɛ faa Misiran jamana rɔ. Ka a damira Ferawuna jɛrɛ dencɛ fɔlɔ ma ka wa se fɔɔ kasodenilu dencɛ fɔlɔ ma, dencɛ fɔlɔ bɛɛ faara. Kolofenilu den fɔlɔ cɛmanilu bɛɛ faara fanan. ");
INSERT INTO msc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ferawuna ni a la baaradenilu ni Misiran jamana mɔɔ bɛɛ kununda su wo rɔ. Mɔɔilu kule kan bɔra kojuuya Misiran yɔrɔ bɛɛ rɔ, baa bon si ma to saya ma kɛ yɔrɔ mɛn na. ");
INSERT INTO msc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Su kelen wo rɔ, Ferawuna ka Musa ni Haruna kili ka a fɔ ii yɛ ko: «Ai ye ai wuli ka bɔ n na mɔɔilu tɛma, ai ni Isirayɛlikailu bɛɛ. Ai ye wa Allabatala bato ikomin ai ka a fɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ai ye ai la kolofenilu bɛɛ fanan ta ikomin ai ka a fɔ ɲa mɛn ma. Ai ye wo bɛɛ ta ka wa! Ai ye duwawu kɛ n yɛ fanan.» ");
INSERT INTO msc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Misirankailu gbɛdɛnda Isirayɛlikailu la ko ii ye bɔ Misiran jamana rɔ jona, baa Misirankailu ka a fɔ ko: «Ni ii ma bɔ yan, an bɛɛ ri faa.» ");
INSERT INTO msc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Wo rɔ, Isirayɛlikailu ka buru janinbaliilu ta ka wo la buru gbasi muranilu rɔ, kɔni ii ma lɛbɛn si kɛ buru wo rɔ. Ii ka muran woilu lasidi faanin dɔ ka woilu sii ii kanbankun kan. ");
INSERT INTO msc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isirayɛlikailu ka Misirankailu tara fen saninnaman ni fen wodigbɛlaman ni faaninilu la ikomin Musa tun ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Allabatala ka Isirayɛlikailu la ko diya Misirankailu yɛ. Wo rɔ, Isirayɛlikailu ka fen fen tara Misirankailu la, woilu dira ii ma. Isirayɛlikailu ka Misirankailu bolokolonya ten de fewu! ");
INSERT INTO msc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isirayɛlikailu bɔra Ramɛsisi so kɔndɔ ka wa Sukɔti so kɔndɔ. Mɛnilu tɛrɛ ye ii sen ma, woilu tun di mɔɔ waa kɛmɛ wɔɔrɔ ɲɔɔn bɔ. Musoilu ni den mɛsɛnilu ma dan. ");
INSERT INTO msc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ii wara ii la kolofenilu ri ii bolo, saailu ni bailu ni nisiilu kɔnin. Woilu ka siya tɛrɛ. Siya gbɛrɛ mɔɔ siyaman wara ii fɛ fanan. ");
INSERT INTO msc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isirayɛlikailu seni yɔrɔ do rɔ, ii tun bɔra Misiran buru janinbali mɛnilu ri, ii ka woilu wusu ka a kɛ buru fununbali ri ka a dɔɔn. Lɛbɛn tun tɛ buru woilu rɔ, ka a masɔrɔn Misirankailu tun ka Isirayɛlikailu labɔ Misiran jona. Wo le ka a kɛ, ii tun ma fɛrɛ sɔrɔn ka lɛbɛn kɛ buru wo rɔ, wala ka dɔɔnninfenilu rabɛn ii la taama kanma. ");
INSERT INTO msc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nba, Isirayɛlikailu tun ka san kɛmɛ naanin ni san bisawa le kɛ Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","San kɛmɛ naanin ni san bisawa wo dafara lon mɛn na, wo lon kelen Allabatala a la mɔɔilu bɔra Misiran ikomin kɛlɛden kuru. ");
INSERT INTO msc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Allabatala ka a janto ii rɔ su wo rɔ, ka ii labɔ Misiran jamana rɔ. Wo rɔ, san san haan kadawu, Isirayɛlikailu bɛɛ ye si ɲana su wo rɔ baa su wo bilani a dan na Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Allabatala ka a fɔ Musa ni Haruna yɛ ko: «Taminkunna Sali dɔɔnnin sariya le ɲin di. Lɔndan si kana wo saraka dɔɔn. ");
INSERT INTO msc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ai ye jɔn mɛnilu sanna, woilu ri se a dɔɔnna ni ai ka ii faaninta kɛ fɔlɔ, ");
INSERT INTO msc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","kɔni londan taminbatɔilu ni baaraden mɛnilu ye sarala, woilu si kana a dɔɔn. ");
INSERT INTO msc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«Ai wa saraka sobo wo rabɛn bon mɛn na, ai ye a dɔɔn bon wo kɔndɔ. Mɔɔ si kana bɔ sobo ri kɛnɛma. Ai wa sobo wo dɔɔn, ai kana a kolo si kadi. ");
INSERT INTO msc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isirayɛlikailu bɛɛ ye Taminkunna Sali wo kɛla. ");
INSERT INTO msc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ni londan do siini ai tɛma, mɛn ye a fɛ ka Taminkunna Sali kɛ ka Allabatala bonya, fo wo tii ni a wara cɛɛilu bɛɛ ye faaninta kɛ fɔlɔ. Ni wo kɛra, a ri se Taminkunna Sali kɛla ikomin Isirayɛlikailu. Cɛɛ mɛn ma faaninta kɛ, wo si kana Taminkunna Sali saraka dɔɔn. ");
INSERT INTO msc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Sariya kelen wo le ye Isirayɛlikailu ni londanilu bɛɛ kan.» ");
INSERT INTO msc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Awa, Isirayɛlikailu bɛɛ ka a kɛ ikomin Allabatala ka Musa ni Haruna jamari ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Wo lon kelen, Allabatala ka Isirayɛlikailu labɔ Misiran ikomin kɛlɛden kuru. ");
INSERT INTO msc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Den fɔlɔ mɛnilu ye ai bolo, ai ye woilu bɛɛ di n ma ka ii kɛ n ta ri. Ni a kɛra muso muso dencɛ fɔlɔ ri, ni a kɛra kolofen kolofen den cɛmanta fɔlɔ ri, woilu bɛɛ ye kɛ n ta ri.» ");
INSERT INTO msc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nba, Musa ka a fɔ Isirayɛlikailu yɛ ko: «Ai ye ai hankili to lon ɲin dɔ, ai bɔra Misiran jɔnya rɔ lon mɛn dɔ, baa Allabatala ka ai labɔ yɔrɔ wo rɔ a la sebaya ba la. Wo le kosɔn, ai kana buru lɛbɛnman dɔɔn wo lon. ");
INSERT INTO msc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ai bɔni bi le Abibu karo la. ");
INSERT INTO msc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Allabatala ka a kali ai benbailu yɛ ale jɛrɛ tɔɔ la ko a ri jamana do di ii ma, dɔɔnninta duman ye bɔla jamana wo rɔ a ɲa jɛrɛ jɛrɛ ma, li ni nɔnɔ a bɛɛ ye bɔla ye. Kanaankailu siini jamana wo kɔndɔ, a ni Hɛtikailu ni Amɔrikailu ni Hifikailu ni Jebusikailu. Allabatala wa ai ladon ye tuma mɛn na, karo ɲin ɲɔɔn wa se san san ai ye sali ɲin kɛ. ");
INSERT INTO msc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ai ye buru fununbali dɔɔn tele wɔrɔnwula kɔrɔ. A tele wɔrɔnwulana lon, ai ye sali kɛ ka Allabatala bonya. ");
INSERT INTO msc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ai ye buru fununbali dɔɔn tele wɔrɔnwula kɔrɔ. Buru lɛbɛnman a kana kɛ ai bolo. Lɛbɛn kana kɛ ai la jamana yɔrɔ si fanan dɔ. ");
INSERT INTO msc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ai ye a ɲafɔ ai dencɛilu yɛ wo lon ko: ‹Allabatala ka ko ba kɛ n yɛ n bɔtɔla Misiran. Wo le ka a kɛ, n ye sali ɲin kɛla.› ");
INSERT INTO msc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","A ri kɛ i la tɔɔmasere ri ikomin bololafen mɛn bilani i bolo la wala mɛn sidinin i tin na ka kɛ hankili bila fen di, ka ban ka Allabatala a la sariya kuma a ye to i da rɔ waati bɛɛ, ka a masɔrɔn Allabatala ka i labɔ Misiran a la sebaya bolo la. ");
INSERT INTO msc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Wo le rɔ, ai ye tola sali ɲin kɛla a waati wo la san san.» ");
INSERT INTO msc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Musa ka a fɔ Isirayɛlikailu yɛ ikɔ tuun ko: «Allabatala ka a kali ai benbailu yɛ ko a ri ai ladon Kanaan na duu kɔndɔ. A wa jamana wo kɛ ai ta ri tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ai ye ai dencɛ fɔlɔilu bɛɛ di Allabatala ma ka ii kɛ a ta ri. Ai la kolofenilu den cɛmanta fɔlɔilu bɛɛ ri kɛ Allabatala ta ri fanan. ");
INSERT INTO msc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ni faliden de, ai ye saaden wala baden saraka wo nɔ rɔ ka faliden kunka. Ni ai tɛ a fɛ ka faliden wo kunka, ai ye wo kan kadi ka a faa. A fɛrɛ tɛ fo ai ye ai dencɛ fɔlɔilu bɛɛ kunka. ");
INSERT INTO msc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«Ai dencɛilu ri ai maɲininka lon do rɔ ko ai ye ko mɛn kɛla ɲin, ko wo kɛ kun a ye nfen di? Ii wa ai maɲininka wo ma, ai ye a fɔ ii yɛ ko: ‹Allabatala ka an nabɔ jɔnya rɔ Misiran jamana rɔ a la sebaya bolo la. ");
INSERT INTO msc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ko Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. Ko a ma sɔn ka an bila. Ko wo rɔ Allabatala ka Misirankailu dencɛ fɔlɔilu bɛɛ faa, ka Misirankailu la kolofenilu den cɛmanta fɔlɔilu bɛɛ fanan faa. Ko wo le rɔ, n ye kolofenilu den cɛmanta fɔlɔilu bɛɛ kɛla sarakafenilu ri Allabatala yɛ, ka n jɛrɛ dencɛ fɔlɔilu bɛɛ kunka.›» ");
INSERT INTO msc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Musa ka a fɔ ii yɛ ikɔ tuun ko: «Sali ɲin ye tɔɔmasere le ri, ikomin mɔɔ ye mɛn bilala a bolo la a ni a tin na sa a kana ɲina. Sali ɲin sababu la, an tɛ ɲinala ko Allabatala ka an nabɔ Misiran jamana rɔ a la sebaya bolo la.» ");
INSERT INTO msc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nba, Ferawuna ka Isirayɛlikailu bila sa ii ri wa tuma mɛn na, Alla ma ii lawa Filisitiilu la jamana sila kan. Sila wo sudunman, kɔni Alla ka a yen ko ni ii wara sila wo kan ka ye mɔɔilu wulitɔla yen ii kanma, ii ri silan ka ii hankili yɛlɛman ka ii kɔsɛ Misiran. ");
INSERT INTO msc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Wo rɔ, Alla ka ii lawa wula kɔndɔ la sila le kan, mɛn ye taminna ka wa Kɔɔji Fararɔbin fan fɛ. Isirayɛlikailu bɔra Misiran tuma mɛn na, ii rabɛnni tɛrɛ kɛlɛkɛ kanma. ");
INSERT INTO msc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ii bɔtɔla, Musa wara Yusufu a kolo ri a bolo, baa sani Yusufu ye sa, a ka a fɔ a badenmailu yɛ ko sika tɛ a rɔ Alla ri na ii dɛmɛn. Ko a badenmailu ye ii kali a yɛ ko Alla wa ii labɔ Misiran jamana rɔ tuma mɛn na, ii ye a kolo ta ka wa woilu ri ii bolo. ");
INSERT INTO msc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nba, Isirayɛlikailu bɔra Sukɔti ka wa ii daa makɛ wula tɔrɔfɛ, yɔrɔ mɛn tɔɔ ko Etan. ");
INSERT INTO msc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Allabatala tɛrɛ ye wala ii ɲɛ tuma bɛɛ. Tele rɔ, Allabatala sanfinnama ri a bilani ii ɲɛ ka sila yiraka ii la. Su rɔ, Allabatala tamɛlɛnnama a ri bila ii ɲɛ ka mɛlɛn bɔ ii ɲɛ. Wo rɔ, ii sera taamala su ni tele. ");
INSERT INTO msc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tele tele, sanfinnama tɛrɛ ye mɔɔilu ɲɛ tuma bɛɛ. Su su, a tamɛlɛnnama tɛrɛ ye mɔɔilu ɲɛ tuma bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«I ye a fɔ Isirayɛlikailu yɛ ko ii ye ii kɔsɛ ka wa ii daa makɛ Pihahirɔti so dala, Mikidɔli so ni kɔɔji tɛma. Ii ye wa ii daa makɛ ye le, ka ii ɲabɛn Bahali-Sɛfɔn so la kɔɔji dala. ");
INSERT INTO msc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ni ii ka wo kɛ, Ferawuna ri a fɔ ko: ‹Ii ra kɔndafili wula kɔndɔ, wadiya tɛ ii la wo kɔ.› ");
INSERT INTO msc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","N di a kɛ Ferawuna jusu ri a ragbɛlɛya. A ri wuli wo rɔ ka ii kɔsaran, kɔni n di se Ferawuna ni a la kɛlɛdenilu la. Mɔɔilu ri n tando wo rɔ. N wa se woilu la, Misirankailu ri a lɔn ko nde le Allabatala ri.» Isirayɛlikailu ka a kɛ ikomin Allabatala ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Awa, a fɔra Ferawuna yɛ tuma mɛn na ko Isirayɛlikailu ra wa, a ni a la ɲɛmɔɔilu miriya yɛlɛmanda. Ii ka a fɔ i ɲɔɔn yɛ ko: «An da nfen de kɛ ɲin di? Nfenna an sɔnda ii ye wa? Ii tɛ an bolo jɔnya la butun wo rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ferawuna ka a la sowontoroilu ni a la kɛlɛdenilu rabɛn Isirayɛlikailu kɔsaran kanma. ");
INSERT INTO msc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","A ka sowontoro ɲuma kɛmɛ wɔɔrɔ ta ka woilu la Misiran sowontoro tɔilu bɛɛ kan. A ka kɛlɛden kuntii lasii sowontoroilu kelen kelenna bɛɛ kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Allabatala ka a kɛ Ferawuna jusu a ragbɛlɛyanin de tɛrɛ. Wo rɔ, a ka Isirayɛlikailu kɔsaran. Wo tuma, ii ye bɔla Misiran jusulatɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Misirankailu la sowontoroilu ni sofadenilu ni kɛlɛdenilu bɛɛ wara Isirayɛlikailu kɔ, ka woilu kɔsaran fɔɔ ka wa sudunya ii daa makɛ diya rɔ i kɔrɔ kɔɔji dala. Yɔrɔ wo ye Pihahirɔti so tɔrɔfɛ, ka ɲabɛn Bahali-Sɛfɔn so ma. ");
INSERT INTO msc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Isirayɛlikailu ka ii ɲa lɔ ka Ferawuna ni a la kɛlɛdenilu natɔla yen ii kanma. Woilu tun da sudunya ii la i kɔrɔ! Wo rɔ, Isirayɛlikailu silanda kojuuya ka ii makasi Allabatala yɛ ko a ye ii dɛmɛn. ");
INSERT INTO msc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ii ka a fɔ Musa yɛ ko: «An su don yɔrɔ le tun tɛ sɔrɔnna Misiran wa? I nani an di an faa diya le wula kɔndɔ yan wo rɔ wa? Ni wo tɛ, i ka an nabɔ Misiran nfenna? ");
INSERT INTO msc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ka an to Misiran, an ma a fɔ i yɛ ba ko ni an bɔra ye, ko su ɲin di an sɔrɔn? An ka a fɔ i yɛ ko i ye an to ten, ko an di to Misiran ye ka kɛ Misirankailu la jɔnilu ri, baa jɔnya wo ka fisa an na saya ri wula kɔndɔ yan.» ");
INSERT INTO msc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa ka ii jabi: «Ai kana silan. Ai ye makɔnɔni kɛ ikɔ tuun! Allabatala ri ai kisi ɲa mɛn ma bi, ai ri wo yen. Ai ɲa ye Misiranka mɛnilu la ɲin, ai tɛ woilu yen butun fewu. ");
INSERT INTO msc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Allabatala ri woilu kɛlɛ ai nɔ rɔ. Ai ye i sabari ka wo ragbɛ ikɔ tuun.» ");
INSERT INTO msc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Awa, Allabatala ka a fɔ Musa yɛ ko: «I ye i makasila n yɛ nfenna, ko n ye ai dɛmɛn? I ye a fɔ Isirayɛlikailu yɛ ko ii ye i wuli ka wa. ");
INSERT INTO msc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","I ye i la gbeleke kɔrɔta kɔɔji kun na ka kɔɔji fara i ɲɔɔnna, sa Isirayɛlikailu ri tamin duu jaran ma kɔɔji nɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nde ri a kɛ Misirankailu jusu ri a ragbɛlɛya. Wo rɔ, ii ri don ai kɔ. Wo wa kɛ, n di se Ferawuna ni a la kɛlɛdenilu ni a la sowontoroilu ni a la sofadenilu bɛɛ la. Mɔɔilu ri n tando wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","N wa se Ferawuna ni a la sowontoroilu ni a la sofadenilu bɛɛ la, ka n na gbiliya yiraka, Misirankailu a ri a lɔn ko nde le Allabatala ri.» ");
INSERT INTO msc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Alla la mɛlɛka mɛn tun ye wala Isirayɛlikailu ɲɛfɛ, wo taminda ii kɔfɛ. Sanfinnama fanan bɔra ii ɲɛfɛ ka tamin ii kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Wo bilara Misirankailu ni Isirayɛlikailu tɛma. Su wo bɛɛ rɔ, dibi donda Misirankailu wara fan fɛ, kɔni kɛnɛ bɔra Isirayɛlikailu wara fan fɛ. Wo rɔ, Misirankailu ni Isirayɛlikailu ma ii madon i ɲɔɔn na su wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa ka a bolo kɔrɔta kɔɔji kun na. Allabatala ka fɔɲɔ ba lana ka bɔ telebɔ fan fɛ. Wo tɛɛra su muumɛ rɔ. Fɔɲɔ wo ka kɔɔji ta fɔɔ ka a tɛɛfara fila ri ka duu jaran bɔ a tɛma. ");
INSERT INTO msc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isirayɛlikailu taminda ji tɛɛfaranin wo tɛma duu jaran kan. Ji layɛlɛnin tɛrɛ i ɲɔɔn kan ka kɛ ikomin jin ii bolokinin fan fɛ ni ii bolomaran fan fɛ. ");
INSERT INTO msc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Misirankailu ka ii kɔsaran. Ferawuna a la sofadenilu ni a la sowontoroilu bɛɛ donda kɔɔji tɛfaranin tɛma ka wa Isirayɛlikailu kɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Suba ma, Allabatala tora tamɛlɛnnama ni sanfinnama a rɔ ka a ɲa lɔ Misiran kɛlɛdenilu rɔ. Ale ka a kɛ Misiran kɛlɛdenilu kɔndafilira piripara fɔɔ ka ii silan! ");
INSERT INTO msc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","A ka ii la sowontoroilu sen bɔla. Ii wa ko gbɛlɛyara wo rɔ. Misirankailu ka wo yen tuma mɛn na, ii ka a fɔ i ɲɔɔn yɛ ko: «Allabatala ye an kɛlɛla Isirayɛlikailu yɛ. An ye an bori ka an bɔ yan, an ye ii to ye.» ");
INSERT INTO msc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Allabatala ka a fɔ Musa yɛ ko: «I ye i bolo kɔrɔta kɔɔji kun na, sa ji ri kadi ka jii Misirankailu ni ii la sowontoroilu ni ii la sofadenilu kan.» ");
INSERT INTO msc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa ka a bolo kɔrɔta kɔɔji kun na. Bandakada le tɛrɛ, kɔɔji ka a kɔsɛ a nɔ rɔ. Misirankailu tɛrɛ ye a fɛ ka ii bori ji ɲɔ rɔ, kɔni Allabatala ka a kadi ii kan. ");
INSERT INTO msc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kɔɔji ka a kɔsɛ a nɔ rɔ ka sowontoroilu ni sofadenilu bɛɛ mira, Ferawuna a la kɛlɛdenilu bɛɛ kɔnin. Mɛnilu bɛɛ donda kɔɔji rɔ Isirayɛlikailu kɔ, woilu bɛɛ tora ji rɔ. Hali mɔɔ kelen pe ma bɔ a rɔ. ");
INSERT INTO msc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isirayɛlikailu kɔnin tun ka ii taama duu jaran kan ka tamin kɔɔji tɛɛfaranin tɛma. Ji tun nayɛlɛra i ɲɔɔn kan ka kɛ ikomin jin de ii bolokinin fan fɛ a ni ii bolomaran fan fɛ. ");
INSERT INTO msc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Nba, Allabatala ka Isirayɛlikailu kisi Misirankailu ma wo lon. Isirayɛlikailu ka Misirankailu fureilu lani yen kɔɔji da la ye. ");
INSERT INTO msc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Allabatala ka fanka ba mɛn be Misirankailu kan, Isirayɛlikailu ka wo yen ii ɲa la. Wo rɔ, ii silanda Allabatala yɛ. Ii lara ale la, ka la a la jɔncɛ Musa fanan na. ");
INSERT INTO msc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Nba, Musa ni Isirayɛlikailu ka kalaman bɔ kɛ Allabatala yɛ ko: «An di kalaman bɔ kɛ Allabatala yɛ baa a ra se a juuilu la fewu. A ra soilu ni kɛlɛdenilu bɛɛ lafili kɔɔji rɔ. ");
INSERT INTO msc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Allabatala ye fanka dila n ma. N ye kalaman ɲin bɔla ale le kosɔn. Ale le ra n kisi n juuilu ma. N Maari Alla le; n di a bato. N fa Maari Alla le; n di a bonya. ");
INSERT INTO msc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Allabatala ye ikomin kɛlɛkɛla fadiman. A tɔɔ le ko Allabatala. ");
INSERT INTO msc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ale ra Ferawuna a la kɛlɛdenilu ni wo la sowontoroilu lafili kɔɔji rɔ. Hali Ferawuna a la jalatii fisamantɛilu tora Kɔɔji Fararɔbin wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ji dunba wo ka woilu latunun fewu. Ii jiira ji kɔrɔ ikomin kabakurun. ");
INSERT INTO msc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ee Allabatala, fanka jɛrɛ jɛrɛ ye i bolo la. I ra i juuilu mɔɲɔnkɔ fewu i bolo la! ");
INSERT INTO msc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","I ra se i juuilu la ka ii halaki, ka bonya ba sɔrɔn wo rɔ. I mɔnɛra ka ii halaki, ikomin ta ye bin jaran janinna ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","I ka fɔɲɔ labɔ i nun dɔ fanka la tuma mɛn na, jiilu ka ii ladɛn i ɲɔɔn kan. Ji mɛn tun ye woyenna, wo ka i lɔ ka kɛ ikomin jin. Ji dunba wo ka i lɔ kɔɔji tɛma ka a raja. ");
INSERT INTO msc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","An juuilu ka a fɔ ko: ‹n di ii kɔsaran fɔɔ ka ii mira. Ko n di ii bolofenilu rafara an ɲɔɔn tɛma. Ko fen fen lɔɔ ye n na, ko n di wo bɛɛ ta. Ko n ni n na fanilu sɔmɔn n laa wo rɔ ka ii halaki.› ");
INSERT INTO msc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kɔni Allabatala, i ka i dafɔɲɔ fɛ kɔɔji kan. Ji ka ii bɛɛ latunun. Ii jiira ji fankama wo kɔrɔ ikomin nɛɛfinbɔɔ. ");
INSERT INTO msc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ee batofen gbɛrɛ ɲuman di kɛ ikomin Allabatala, mɛn ye i ɲɔɔn di? Ɛɛn de, i ɲɔɔn tɛ. Yon sɛniman wa ikomin ile? Nɔɔrɔ ye yon na ikomin ile? Yon ye kabannakoilu kɛla ikomin ile? ");
INSERT INTO msc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","I ka i bolo rasɔmɔn dɔrɔn, dunuɲa ka an juuilu lakunun. ");
INSERT INTO msc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","I ra i la mɔɔilu kunka. I ri i lɔ an ɲɔrɔ i la kaninteya la a ni i la sebaya la, ka wa i sii diya sɛniman dɔ. ");
INSERT INTO msc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Siya tɔilu ka wo kibaro mɛn tuma mɛn na, ii silanda fɔɔ ka yɛrɛyɛrɛ. Silan ba wo ka Filisitiilu mira. ");
INSERT INTO msc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔmukailu la kuntiilu silanda kojuuya. Mowabukailu la ɲɛmɔɔilu yɛrɛyɛrɛra silan bolo ma. Kanaankailu jiitɛɛra fewu. ");
INSERT INTO msc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ii silanda kojuuya fɔɔ ka yɛrɛyɛrɛ. Allabatala, ii ka i la sebaya yen tuma mɛn na, ii tora ii nɔ rɔ ikomin farakolo. Ii ma se foyi kɛla fɔɔ i la mɔɔilu banda taminna, i ka mɔɔ mɛnilu kunka jɔnya rɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Allabatala, i ye i la mɔɔilu ladonna i la jamana kɔndɔ, ka i lasii i la koyinkɛ lahidi kan, i ka mɛn suwandi ka a kɛ i jɛrɛ sii diya ri, i, Allabatala, i ka bon mɛn lɔ i jɛrɛ bato kanma. ");
INSERT INTO msc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Allabatala ri a la mansaya kɛ kadawu. ");
INSERT INTO msc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Baa, Ferawuna la sowontoroilu ni a la sofadenilu bɛɛ donda kɔɔji tɛɛfaranin tɛma tuma mɛn na, Allabatala ka kɔɔji kadi ka a jii ii kan ka ii bɛɛ latunun. Kɔni Isirayɛlikailu ka ii taama duu jaran kan ka tamin kɔɔji tɛɛfaranin tɛma.» ");
INSERT INTO msc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nabi Miriyamu, Haruna kɔrɔmuso, wo ka sɛsɛ do ta a bolo. Isirayɛli muso tɔilu bɛɛ fanan ka doilu ta ka ii bila Miriyamu kɔ, ka sɛsɛilu fɔ ka don kɛ. ");
INSERT INTO msc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriyamu ka kalaman bɔ kɛ ka a fɔ ii yɛ ko: «Ai ye kalaman bɔ kɛ Allabatala yɛ, baa a ra se a juuilu la fewu. A ra soilu ni sofadenilu bɛɛ lafili kɔɔji rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Nba, Musa ka Isirayɛlikailu ta ka bɔ Kɔɔji Fararɔbin dɔ. A lɔra ii ɲɔrɔ ka wa se Suri wula kɔndɔ. Ii ka tele sawa taama kɛ wula kɔndɔ, ii ma ji tɛrɛn ye. ");
INSERT INTO msc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ii sera yɔrɔ do rɔ, mɛn tɔɔ ko Mara, kɔni ii ma se wo ji minna, baa a kunanin tɛrɛ. Wo le kosɔn, yɔrɔ wo tɔɔ lara ko Mara. ");
INSERT INTO msc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Isirayɛlikailu wulira ka ii makasi Musa kan. Ii ka a fɔ ko: «An di nfen minna yan?» ");
INSERT INTO msc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa ka a makasi Allabatala yɛ, ko a ye a dɛmɛn. Allabatala ka jiri do yiraka a la. Musa ka jiri kunkundun wo ta ka a bila ji rɔ. Ji diyara kosɛbɛ! Ka ii to ye, Alla ka sariyailu di ii ma, ii ka kan ka taama ka bɛn mɛnilu ma. A ka ii kɔrɔbɔ ye fanan. ");
INSERT INTO msc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","A ka a fɔ ii yɛ ko: «Ni ai ka i raja ka nde Allabatala kan natelen, ka taama ka bɛn n sawo ma, ka n na jamariliilu ni n na sariyailu bɛɛ labato, n ka jankarɔ mɛnilu la Misirankailu kan, n tɛ wo si la ai kan, baa n ye Allabatala le ri, mɛn ye ai lakɛndɛyala.» ");
INSERT INTO msc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Nba, Isirayɛlikailu bɔra Mara ka wa se Elimu. Kɔ yɔrɔ tan ni fila ni tamaroju biwɔrɔnwula tɛrɛ ye yɔrɔ wo rɔ. Ii ka ii daa makɛ ji da la ye. ");
INSERT INTO msc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isirayɛlikailu bɛɛ bɔra Elimu ka wa se Sin wula kɔndɔ. Yɔrɔ wo ye Elimu ni Sinayi koyinkɛ tɛ. Ii sera ye ka a tɛrɛn ii bɔ karo filana ni tele tan ni loolu ka bɔ Misiran. ");
INSERT INTO msc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ka ii to wula kɔndɔ ye, Isirayɛlikailu bɛɛ wulira ka Musa ni Haruna makuma. ");
INSERT INTO msc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ii ka a fɔ Musa ni Haruna yɛ ko: «Ni Allabatala tun ka an faa Misiran jamana rɔ, wo ka fisa ko ɲin di paaɔn, baa an tɛrɛ ye sobo sɔrɔnna Misiran, ka suman dɔɔn fɔɔ ka an wasa, kɔni ai ra na an di wula kɔndɔ yan sa an bɛɛ ri faa kɔnkɔ bolo.» ");
INSERT INTO msc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Allabatala ka a fɔ Musa yɛ ko: «N di dɔɔnninfen najii ai ma. Lon lon, bɛɛ ri wa a la telenfen ta a rɔ. N di ii kɔrɔbɔ wo rɔ, ka a yen ni ii ri n kumakan natelen, wala ni ii tɛ a latelen. ");
INSERT INTO msc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tele wɔɔrɔna wa se lɔɔkun lɔɔkun, ii ye wa dɔɔnninfen wo do ta ka na a tibi, ii ye wo siyaya ka a kɛ lon tɔilu ta ɲɔɔn fila ri.» ");
INSERT INTO msc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa ni Haruna ka a fɔ Isirayɛlikailu bɛɛ yɛ ko: «Bi wura fɛ, ai ri a lɔn ko Allabatala de ka ai labɔ Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sini sɔɔma, ai ri Allabatala la nɔɔrɔ yen ai ɲa la, baa ai ka kuma mɛnilu fɔ Allabatala ma, a ka woilu mɛn. Nfenna ai ye ai kuma mɛsɛn kɛla nde ni Haruna ma? Andeilu tɛ foyi ri.» ");
INSERT INTO msc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa ka a fɔ ko: «Allabatala a ri sobo di ai ma wura la, ai ri wo dɔɔn. Sɔɔma, a ri dɔɔnnin gbɛrɛ di ai ma, ai ri wo dɔɔn fɔɔ ka ai fa, baa ai ka kuma mɛsɛn mɛnilu fɔ a ma, a ka wo bɛɛ mɛn. Ai ye mɛn fɔla, ai tɛ wo fɔla andeilu ma, baa andeilu tɛ foyi ri. Ai ye wo fɔla Allabatala de ma.» ");
INSERT INTO msc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa ka a fɔ Haruna yɛ ko: «I ye a fɔ Isirayɛlikailu bɛɛ yɛ ko ii ye na ii ladɛn yɔrɔ kelen dɔ Allabatala ɲakɔrɔ, baa ii ra kuma mɛsɛn mɛnilu fɔ ale ma, a ra wo bɛɛ mɛn.» ");
INSERT INTO msc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Nba, ka Haruna to kumala jama rɔ, ii ka ii ɲa lɔ ka Allabatala a la nɔɔrɔ yen banda rɔ wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Isirayɛlikailu ra kuma mɛsɛn mɛnilu bɛɛ fɔ n ma, n da wo mɛn. I ye a fɔ ii yɛ ko: ‹Ai ri sobo dɔɔn wura la. Ko sɔɔma, ko ai ri fa dɔɔnnin gbɛrɛ la. Ko ai ri a lɔn wo rɔ ko nde le ai Maari Allabatala ri.›» ");
INSERT INTO msc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nba, wura fɛ, wɔlɔ siyaman ba jiira ka i sii Isirayɛlikailu daa makɛ diya. Sɔɔma konbi lara duu ma daa makɛ diya laminin fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Konbi wo jara tuma mɛn na, fen doilu buruburuni tora duu ma. A mɛsɛnman, a gbɛni. ");
INSERT INTO msc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isirayɛlikailu ka wo yen tuma mɛn na, ii ka i ɲɔɔn maɲininka ko: «Nfen de ɲin di?» Baa ii ma a lɔn ko fen mɛn ye wo ri. Musa ka ii jabi: «Dɔɔnninfen de wo ri, Allabatala ka mɛn di ai ma. ");
INSERT INTO msc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Allabatala ka mɛn fɔ dɔɔnninfen ɲin na ko rɔ, wo le ɲin di. A ka a fɔ ko ai bɛɛ ye wa do ta, mɛn di ai la dɔɔnninta bɔ. Mɔɔ mɛn jate ye ai bolo bon na, ai ye wo sumanifen ɲa fila jate ta.» ");
INSERT INTO msc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isirayɛlikailu ka a kɛ ikomin Allabatala ka a fɔ ɲa mɛn ma. Doilu ka siyaman ta, doilu ma siyaman ta. ");
INSERT INTO msc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ii ka wo suman sumanifen na tuma mɛn na, ii ka a yen ko mɛnilu ka siyaman ta, woilu ta to ma to, mɛnilu ma siyaman ta, woilu ta ma dɛsɛ. Mɔɔ kelen kelenna tun ka jate mɛn ta, wo ka a la dɔɔnninta bɔ. ");
INSERT INTO msc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa ka a fɔ ko: «Mɔɔ si kana dɔɔnninfen wo tɔ lasii.» ");
INSERT INTO msc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kɔni doilu ma ii tolo malɔ Musa la kuma wo la. Ii ka ii ta tɔ lasii. Tunbuilu donda wo rɔ. A suma bɔra kojuuya. Musa mɔnɛra ii kanma. ");
INSERT INTO msc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nba, sɔɔma sɔɔma mɔɔilu ri wa dɔɔnninfen wo do ta, mɛn di ai la dɔɔnninta bɔ. Tele wa bɔ kosɛbɛ tuma mɛn na, dɔɔnninfen mɛn wa to duu ma, wo ri yelen ka tunun. ");
INSERT INTO msc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A tele wɔɔrɔna lon, mɔɔilu wara tele fila ta ta dɔɔnninfen wo rɔ. Mɔɔ kelen kelenna ta kɛra sumanifen ɲa naanin di. Jama ɲɛmɔɔilu wara wo ɲafɔ Musa yɛ. ");
INSERT INTO msc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa ka ii jabi: «Allabatala ka wo le fɔ. Sini, ai ye baara bila fewu. Ɲɔɲɔ lon de wo ri, mɛn bilani a dan na Allabatala yɛ. Ni ai ye a fɛ ka dɔɔnninfen mɛn wusu, ai ye woilu wusu bi. Ni ai ye a fɛ ka mɛn tibi, ai ye woilu tibi bi. Ai ye bi ta bɔ a la ka a tɔ kɛ sinin ta a ri.» ");
INSERT INTO msc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ii ka a tɔ kɛ sinin ta ri ikomin Musa tun ka a fɔ ii yɛ ɲa mɛn ma. Wo duusa gbɛ, wo suma tun tɛ bɔla, tunbu tun ma don a rɔ. ");
INSERT INTO msc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa ka a fɔ ii yɛ ko: «Ai ka mɛn bila ye kunun, ai ye woilu dɔɔn bi, baa bi ye Ɲɔɲɔ lon de ri, mɛn bilani a dan na Allabatala yɛ. Ai tɛ dɔɔnninfen wo yen duu ma bi. ");
INSERT INTO msc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tele wɔɔrɔ kɔrɔ, ai ri dɔɔnninfen wo do ta, kɔni tele wɔrɔnwulana lon ye Ɲɔɲɔ lon de ri. Ai tɛ foyi yen duu ma wo lon.» ");
INSERT INTO msc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Wo bɛɛ ni a ta, doilu bɔra ka wa dɔɔnninfen wo ɲinin diya tele wɔrɔnwulana lon. Ii ma foyi tɛrɛn ye. ");
INSERT INTO msc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Allabatala ka a fɔ Musa yɛ ko: «Ai ri ai ban n na sariya a ni n na tɔn mafɛnɛ la haan waati ɲuman? ");
INSERT INTO msc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ai ye ai hankili to a rɔ ko nde le ka Ɲɔɲɔ lon di ai ma. Wo le rɔ, tele wɔɔrɔna lon wa se, n di tele filana dɔɔnnin di ai ma. Tele wɔrɔnwulana lon wa se, bɛɛ ye to a wara. Mɔɔ si kana bɔ.» ");
INSERT INTO msc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Wo rɔ, ii bɛɛ ka baara bila ka i ɲɔɲɔn tele wɔrɔnwulana lon ma. ");
INSERT INTO msc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isirayɛlikailu ka dɔɔnninfen wo tɔɔ la ko mana. A bɔni binkisɛ do le la, mɛn gbɛni. A duman ikomin dɛba mɛn nabɛnni li la. ");
INSERT INTO msc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa ka a fɔ ii yɛ ko: «Allabatala ka a fɔ ko: ‹ai ye dɔɔnninfen ɲin sumanifen ɲa fila lamara ai bɔnsɔnilu yɛ, mɛnilu natɔ ai kɔ. Ko n ka ai labɔ Misiran ka ai balo dɔɔnninfen mɛn na wula kɔndɔ, kosa ai bɔnsɔnilu ri wo yen ii ɲa la.›» ");
INSERT INTO msc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa ka a fɔ Haruna yɛ ko: «I ye daa do ta ka dɔɔnninfen wo sumanifen ɲa fila kɛ a kɔndɔ ka woilu bila Allabatala ɲakɔrɔ. A ri a lamara ka a kɛ sereya ri an bɔnsɔnilu yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Haruna ka a kɛ ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. A ka mana kɛ daa kɔndɔ ka a sii tɔɔmasere kankira ɲɛfɛ a lamara kanma. ");
INSERT INTO msc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isirayɛlikailu ka san binaanin kɛ mana wo dɔɔnna. Ii ka wo dɔɔn haan ii sera Kanaan jamana dan na, ii kɛtɔ ii siila jamana mɛn dɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Nba, ii tɛrɛ ye mana sumanna sumanifen mɛnilu ma, wo ɲa tan bɛnda sumanifen ba ɲa kelen de ma. Sumanifen ba wo tɔɔ le ko hɛfa. ");
INSERT INTO msc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nba, Isirayɛlikailu bɛɛ bɔra Sin wula kɔndɔ ka wa ikomin Allabatala ka a fɔ ii yɛ ɲa mɛn ma. Ii ka i mataama dooni dooni fɔɔ ka wa se yɔrɔ do rɔ, mɛn tɔɔ ko Refidima. Ii ka ii daa makɛ ye, kɔni ii ma minninji tɛrɛn ye. ");
INSERT INTO msc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Wo le ka a kɛ mɔɔilu wulira ka Musa makuma ko: «Ai ye ji di an ma.» Musa ka ii jabi: «Ai ye nde makumala nfenna? Ai ye i tɛɛla Allabatala rɔ nfenna ka a kɔrɔbɔ?» ");
INSERT INTO msc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kɔni ji lɔɔ tɛrɛ ye ii la kojuuya. Wo rɔ, ii wulira ka a kɛ Musa makuma ri. Ii ka a fɔ ko: «Nfenna i ka an nabɔ Misiran ka an ni an denilu ni an na kolofenilu bɛɛ faa ji lɔɔ bolo wa?» ");
INSERT INTO msc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa ka a dalakasi Allabatala yɛ ko: «N ka kan ka nfen kɛ mɔɔ ɲinilu yɛ? A ra to dooni ii ri n ton kaba la.» ");
INSERT INTO msc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Allabatala ka Musa jabi: «I ye Isirayɛlikailu la mɔɔbakɔrɔ doilu ta ka wa jama ɲɛfɛ. I la gbeleke ye wa i bolo, i ka Nili Ba gbasi gbeleke mɛn na. ");
INSERT INTO msc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","N di n lɔ i ɲɛfɛ Horɛbu koyinkɛ farakolo do kan. I ye farakolo wo gbasi i la gbeleke la. Ji ri bɔ wo rɔ, mɔɔilu ri ji wo min.» Musa ka a kɛ wo ɲa kelen ma Isirayɛlikailu la mɔɔbakɔrɔilu ɲana. ");
INSERT INTO msc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa ka yɔrɔ wo tɔɔ la ko Meriba, ka a masɔrɔn Isirayɛlikailu ka sɔsɔli kɛ ye. A ka tɔɔ gbɛrɛ fanan la a la ko Masa, ka a masɔrɔn Isirayɛlikailu ka Allabatala kɔrɔbɔ ye le, ka a fɔ ko: «Allabatala ye an tɛma wa, wa a tɛ an tɛma?» ");
INSERT INTO msc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Nba, Amalɛkikailu wulira ka na Isirayɛlikailu kɛlɛ Refidima. ");
INSERT INTO msc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Wo rɔ, Musa ka a fɔ Josuwe yɛ ko: «I ye mɔɔ doilu suwandi, mɛnilu ri kɛlɛ kɛ an yɛ. Ai ye wa Amalɛkikailu kɛlɛ. Sini n di wa n lɔ tindi kan ye. Alla la gbeleke ri kɛ n bolo.» ");
INSERT INTO msc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Musa ka mɛn fɔ, Josuwe ka wo kɛ. A ni a la kɛlɛdenilu wara ka Amalɛkikailu kɛlɛ. Wo waati kelen, Musa ni Haruna ni Huri yɛlɛra tindi wo kan. ");
INSERT INTO msc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa wa a boloilu kɔrɔtani to tuma mɛn na, Isirayɛlikailu la kɛlɛdenilu ri nɔ sɔrɔn. Kɔni a wa a boloilu lajii tuma mɛn na, Amalɛkikailu ri nɔ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kɔni Musa bolo fila bɛɛ ra kunda. Wo rɔ, Haruna ni Huri nara kabakurun do ri. Musa ka a sii wo kan. Ka a siini to, Haruna ni Huri ka a boloilu mira ka ii kɔrɔta. Do ka a bolokinin mira, do ka a bolomaran mira. Wo rɔ Musa boloilu kɔrɔtani tora haan tele be waati. ");
INSERT INTO msc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Wo le ka a kɛ, Josuwe ni a la mɔɔilu sera Amalɛkikailu la a la fanmuru la fewu. ");
INSERT INTO msc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Allabatala ka a fɔ Musa yɛ ko: «I ye ko ɲin sɛbɛ kitabu lamininnin dɔ sa mɔɔilu kana ɲina wo rɔ. I ye a karan Josuwe ɲana sa a ri a mɛn, baa n di Amalɛkikailu halaki fɔɔ dunuɲa mɔɔilu ri ɲina ii la ko la fewu.» ");
INSERT INTO msc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa ka saraka janin diya lɔ ka a tɔɔ la ko: «Allabatala ra se di n ma.» ");
INSERT INTO msc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa ka a fɔ ko: «Amalɛkikailu wulira Allabatala la mansaya kanma. Wo le rɔ, Allabatala ri ii kɛlɛ kadawu.» ");
INSERT INTO msc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Nba, Allabatala Alla tun ka mɛn bɛɛ kɛ Musa ni Isirayɛlikailu yɛ ka ii labɔ Misiran, wo fɔra Musa birancɛ Jɛtiro yɛ, mɛn ye Madiyankailu la sarakalasela ri. ");
INSERT INTO msc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Musa muso Sefora tɛrɛ ye a fa Jɛtiro bolo a wara, baa Musa tun ka a lawa ko a ye waati do kɛ ye. ");
INSERT INTO msc_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Sefora dencɛ fila fanan tɛrɛ ye Jɛtiro bolo ye. Musa tun ka a dencɛ kelen tɔɔ la ko Kerisɔn, baa a ka a fɔ ko: «N ye londan de ri.» ");
INSERT INTO msc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","A ka dencɛ do fanan tɔɔ la ko Eliyɛsɛri, baa a ka a fɔ ko: «N fa Maari Alla ra n dɛmɛn ka n bɔ Ferawuna bolo, mɛn tɛrɛ ye fɛrɛ ɲininna n ma ka n faa fanmuru la.» ");
INSERT INTO msc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Musa birancɛ Jɛtiro ka Musa muso ni a dencɛilu ta ka wa Musa tɛrɛn wula kɔndɔ. Wo tuma Musa ni Isirayɛlikailu daa makɛni Alla la koyinkɛ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jɛtiro ka kela lawa Musa ma ko: «Nde, i birancɛ Jɛtiro, natɔ bɔla i tɔrɔfɛ. I muso ni a dencɛ fila natɔ a kɔfɛ.» ");
INSERT INTO msc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Wo rɔ, Musa wara a birancɛ kunbɛn diya. A seni ye, a ka i majii ka a fo, ka ban ka a sunbu. Ii ka foli di i ɲɔɔn ma. Ii banni wo la, ii wara don Musa la faaninbon na. ");
INSERT INTO msc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Allabatala ka ko mɛn bɛɛ kɛ Ferawuna ni a la mɔɔilu la Isirayɛlikailu dɛmɛn ko rɔ, Musa ka wo bɛɛ ɲafɔ a birancɛ yɛ. Isirayɛlikailu ka tɔrɔya mɛn bɛɛ sɔrɔn sila la, a ni Allabatala ka ii kisi ɲa mɛn ma, Musa ka wo fanan ɲafɔ a birancɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Allabatala ka koɲuma mɛn bɛɛ kɛ Isirayɛlikailu yɛ, ka ii bɔ Misirankailu bolo ɲa mɛn ma ka ii kisi, Jɛtiro sɛwara wo bɛɛ la kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jɛtiro ka a fɔ ko: «Tandoli ye Allabatala yɛ, mɛn ka ai bɔ Ferawuna bolo, ka a la mɔɔilu labɔ Misirankailu la fanka kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","N ka a lɔn sisen ko Allabatala ka bon batofen tɔilu bɛɛ ri, baa Misirankailu tɛrɛ jɛrɛdabayani Isirayɛlikailu ma; wo le kosɔn Alla ka Misirankailu halaki.» ");
INSERT INTO msc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Musa birancɛ Jɛtiro nara saraka ni saraka janinta di Alla ma. Haruna ni Isirayɛlikailu la mɔɔbakɔrɔilu bɛɛ nara ka dɔɔnnin kɛ Musa birancɛ fɛ Alla ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wo duu sa gbɛnin, Musa wara i sii ka a kɛ mɔɔilu la kititɛɛ ri. Ka bɔ sɔɔma ma haan ka se wura la, jama lɔni tɛrɛ a laminin dɔ ka makɔnɔni kɛ. ");
INSERT INTO msc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Musa tɛrɛ ye mɛn bɛɛ kɛla mɔɔilu yɛ ɲin, a birancɛ ka wo yen. Wo rɔ, a ka a fɔ Musa yɛ ko: «I ye nfen kɛla ɲin di? Nfenna kosɔn ile kelen pe siini mɔɔilu la kititɛɛla yan? Ka bɔ sɔɔma ma haan wura la, jama bɛɛ lɔni i laminin dɔ ka makɔnɔni kɛ.» ");
INSERT INTO msc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa ka a birancɛ jabi: «N ye wo kɛla ka a masɔrɔn mɔɔilu ye nala n ma ka Alla diyanan ko lɔn. ");
INSERT INTO msc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ni sɔsɔli wulira doilu tɛ, ii ri na wo fɔ n yɛ, n di wo kititɛɛ ii tɛma. N di ii lalɔnniya Alla la jamariliilu ni a la sariyailu la.» ");
INSERT INTO msc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jɛtiro ka a fɔ ko: «I ye baarala ɲa mɛn ma, wo ma ɲi de. ");
INSERT INTO msc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","I ri i jɛrɛ sɛɛ fewu, ka mɔɔilu fanan sɛɛ. Baara wo ka bon i kelen ma. I kelen ti se wo kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","I tolo malɔ n na kumakan na, n ye i lalila. Alla ye i dɛmɛn ka n na lalilikan mira. Ile ka kan ka kuma mɔɔilu tɔɔ rɔ Alla yɛ, ka ii la sɔsɔliilu lase a ma. ");
INSERT INTO msc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","I ye ii karan Alla la jamariliilu ni a la sariyailu la. Ii ka kan ka sila taama ɲa mɛn ma, a ni ii ka kan ka ko mɛnilu kɛ, i ye woilu bɛɛ yiraka ii la. ");
INSERT INTO msc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ka a la wo kan, i ye mɔɔ doilu suwandi jama bɛɛ tɛma, mɛnilu ri se ko la, mɛnilu fanan silanni Alla ɲɛ. Woilu ye kɛ mɔɔilu ri, jama lani mɛnilu la, mɛnilu sidini tuɲa la, dibirafen mira ma di mɛnilu yɛ. I ye mɔɔ woilu sii jama kun na. I ye doilu sii mɔɔ waa kelen kelen kun na, ka doilu sii mɔɔ kɛmɛ kɛmɛ kun na, ka doilu sii mɔɔ biloolu biloolu kun na, ka doilu fanan sii mɔɔ tan tan kun na. ");
INSERT INTO msc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Woilu ye mɔɔilu la sɔsɔliilu kititɛɛ lon lon. Ni kiti mɛn bonyara ii ma, ii ri na wo ri ile ma, kɔni ii ri sɔsɔli mɛsɛnilu kititɛɛ ye. Wo rɔ, i ri i lafɛrɛn dɔɔni, baa ii ri i dɛmɛn baara ba wo la. ");
INSERT INTO msc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Alla ye i jamarila mɛn na, ni i ka wo kɛ i ri se wo baara la. Mɔɔ bɛɛ la sɔsɔliilu ri ɲanabɔ wo rɔ, ii ri kɔsɛ ii wara jususuma dɔ.» ");
INSERT INTO msc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Nba, Musa ka a tolo malɔ a birancɛ la lalilikan na ka wo bɛɛ mira. ");
INSERT INTO msc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A ka mɔɔilu suwandi Isirayɛlikailu bɛɛ tɛma, mɛnilu ri se ko la, ka woilu sii jama kun na. A ka doilu lasii mɔɔ waa kelen kelen kun na, ka doilu lasii mɔɔ kɛmɛ kɛmɛ kun na, ka doilu lasii mɔɔ biloolu biloolu kun na, ka doilu fanan nasii mɔɔ tan tan kun na. ");
INSERT INTO msc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Woilu le tɛrɛ ye mɔɔilu la sɔsɔliilu kititɛɛla lon lon. Ni kiti mɛn gbɛlɛyara ii ma, ii ri na wo ri Musa ma, kɔni ii ri sɔsɔli mɛsɛnilu kititɛɛ ye. ");
INSERT INTO msc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Nba, wo kɔ, Musa ka sila di a birancɛ ma. Wo ka i kɔsɛ ka wa a la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Nba, Isirayɛlikailu bɔra Refidima ka wa se Sinayi wula kɔndɔ. A karo sawana bɔra lon mɛn ii bɔni kɔ rɔ Misiran jamana rɔ, wo lon kelen ii sera Sinayi wula kɔndɔ. Ii ka ii daa makɛ koyinkɛ kɔrɔ wula kɔndɔ ye. ");
INSERT INTO msc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa yɛlɛra koyinkɛ kan, ka wa Alla labɛn. Allabatala tora koyinkɛ kun tɛma ka a fɔ Musa yɛ ko: «I ye kuma ɲin fɔ Yakuba bɔnsɔnilu yɛ, Isirayɛlikailu kɔnin. Ko: ");
INSERT INTO msc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Ai jɛrɛ ka a yen ko n ka ai labɔ Misiran ɲa mɛn ma ka ai ta ikomin bibi ye a denilu tala a kawa na ɲa mɛn ma, n ka ai Isirayɛlikailu ta wo ɲa le ma ka na ai ri n ma yan. ");
INSERT INTO msc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sisen, ni ai ka ai raja ka n kumakan natelen ka n na teriya bonya, n ka mɛn sidi an tɛma, ai ri kɛ n na mɔɔilu ri, mɛnilu duman n yɛ ka tamin siya tɔilu bɛɛ kan. Hali wo dunuɲa bɛɛ ye n ta le ri, ");
INSERT INTO msc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Aile, Isirayɛlikailu, ai ri kɛ mansaya sarakalaselailu ri, jamana sɛniman mɛn ye nde yɛ.› I ye wa kuma wo fɔ Isirayɛlikailu yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musa jiira koyinkɛ la ka wa Isirayɛlikailu la mɔɔbakɔrɔilu kili. Allabatala ka kuma mɛnilu jamari a la, a ka wo bɛɛ lase ii ma. ");
INSERT INTO msc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mɔɔ woilu bɛɛ ladɛnnin ka Musa jabi: «Allabatala ka mɛnilu fɔ, an di wo bɛɛ labato.» Musa wara mɔɔilu la jabili di Allabatala ma. ");
INSERT INTO msc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Allabatala ka a fɔ Musa yɛ ko: «N di na i ma banda do rɔ, sa n wa kuma i yɛ tuma mɛn na, mɔɔilu ri n kumakan mɛn ka la i la tuma bɛɛ.» Jama tun ka mɛn fɔ, Musa ka wo dantɛɛ Allabatala yɛ. ");
INSERT INTO msc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Allabatala ka a fɔ Musa yɛ ko: «I ye jii ka i kɔsɛ mɔɔilu ma, ka a fɔ ii yɛ ko bi a ni sini ii ye ii jɛrɛ sɛninya. I ye a fɔ ii yɛ ko ii ye ii la faanin fanan ko. ");
INSERT INTO msc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ii ye ban ii rabɛnna sani sinikɛndɛ tɛ, baa sinikɛndɛ n di jii Sinayi koyinkɛ kun na mɔɔ bɛɛ ɲana. ");
INSERT INTO msc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","I ye dan bila koyinkɛ laminin fan bɛɛ rɔ, ka a fɔ mɔɔilu yɛ ko ii ye a kɛ koɲuma, ii kana yɛlɛ koyinkɛ kan. Ii kana se koyinkɛ ma muumɛ. Mɔɔ mɔɔ wa se koyinkɛ ma, a ri faa! ");
INSERT INTO msc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mɔɔ si kana a bolo maa mɔɔ wo la. Ii ye a ton kaba la ka a faa. Ni wo tɛ, ko ii ye a bon biɲɛ la ka a faa. Mɔɔ wo, kolofen wo, ni mɛn ka tɔn wo tiɲan, ii kana wo tii kɛndɛ to. Ii wa buru fɛ kan ba mɛn tuma mɛn na, ii ri se i madonna koyinkɛ la.» ");
INSERT INTO msc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musa jiira ka bɔ koyinkɛ kan ka wa a fɔ mɔɔilu yɛ ko ii ye ii jɛrɛ sɛninya. Ii ka ii la faaninilu fanan ko. ");
INSERT INTO msc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Musa ka a fɔ ii yɛ ikɔ tuunnin ko: «Ai ye ban ai jɛrɛ rabɛnna sani sinikɛndɛ. Ai ni ai musoilu kana dɛn tele fila ɲin kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nba, lon mɛn fɔni, wo lon telebɔ mɛn kɛni, banda a sankulu kan bɔra, sanfɛrɛnilu jiira fanan. Bandafin jiini tɛrɛ koyinkɛ kun dɔ. Buru fɛ kan ba do bɔra. Wo kɛni, mɔɔilu bɛɛ silanda kojuuya fɔɔ ka yɛrɛyɛrɛ daa makɛ diya ye. ");
INSERT INTO msc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa lɔra jama bɛɛ ɲɔrɔ ka bɔ daa makɛ diya ka wa Alla labɛn. Ii wara i lɔni koyinkɛ wo kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinayi koyinkɛ fan bɛɛ kɛra sisi ri, baa Allabatala tun ni ta le jiira i ɲɔɔn fɛ koyinkɛ kun tɛma. Sisi ba tɛrɛ ye yɛlɛla ikomin fuuru. Koyinkɛ yɔrɔ bɛɛ yɛrɛyɛrɛra kojuuya. ");
INSERT INTO msc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Buru fɛ kan tora bonyala. Musa tɛrɛ ye kumala a ni Alla fanan tɛrɛ ye a jabila a kan na. ");
INSERT INTO msc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Allabatala jiira Sinayi koyinkɛ kun tɛma. A tora koyinkɛ kun tɛma ye ka Musa kili. Musa yɛlɛra. ");
INSERT INTO msc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","A seni ye, Allabatala ka a fɔ a yɛ ko: «I ye jii ka i jaseremala mɔɔilu yɛ, sa ii kana tamin dan wo la ka na nde Allabatala ragbɛ. Ni wo tɛ, ii siyaman di faa. ");
INSERT INTO msc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hali Alla sarakalasela mɛnilu ye ii madonna nde Allabatala la, fo ii ye ii jɛrɛ sɛninya le fɔlɔ. Ni wo tɛ, n di ii faa.» ");
INSERT INTO msc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa ka Allabatala jabi: «Mɔɔilu tɛ sɔnna yɛlɛla Sinayi koyinkɛ kan yan, baa i jɛrɛ ka i jaseremala an yɛ ko an ye dan kɛ koyinkɛ laminin dɔ ka koyinkɛ bɛɛ kɛ yɔrɔ sɛniman di.» ");
INSERT INTO msc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Allabatala ka a fɔ a yɛ ko: «I ye jii ka wa Haruna ta ka na a ri yan, kɔni Alla sarakalaselailu ni mɔɔ tɔilu kana tamin dan kan, ka yɛlɛ, ka na nde Allabatala ma de! Ni wo tɛ, n di ii faa.» ");
INSERT INTO msc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa jiira wo rɔ, ka wa mɔɔilu tɛrɛn ye ka kuma wo fɔ ii yɛ. ");
INSERT INTO msc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Wo kɔ rɔ, Alla ka kuma ɲin bɛɛ fɔ ko: ");
INSERT INTO msc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Nde le i Maari Allabatala ri. Nde le ka ai labɔ Misiran ai tɛrɛ ye jɔnya la yɔrɔ mɛn. ");
INSERT INTO msc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Ai kana batofen gbɛrɛ si bato nde kɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Ai kana bisiki si lɛsɛ ai jɛrɛ yɛ ka a bato. Fen mɛnilu ye sankolo rɔ wo, fen mɛnilu ye duu kan wo, fen mɛnilu ye ji rɔ wo, ai kana woilu si bisiki ladan. ");
INSERT INTO msc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ai kana i majii wo si kɔrɔ ka a bato, baa nde le ai Maari Allabatala ri. N ye Alla keleyatɔ le ri. N ti sɔn ai ye fen gbɛrɛ si bato. Ni mɔɔ mɛn ka n nagboyaɲɛ ka a ban n dɔ, n di wo hakɛ bɔ wo tii rɔ, a ni a denilu a ni a mamarenilu a ni a tolomirailu rɔ, a ni woilu fanan denilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kɔni ni mɔɔ mɛn ka n kanin ka n na jamariliilu sila taama, n di n na kaninteya yiraka wo la haan ka wa se a bɔnsɔn farɔkɛ waa kelenna ma. ");
INSERT INTO msc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Ai kana ai Maari Allabatala tɔɔ fɔ fuu. Ni mɔɔ mɛn ka n tɔɔ fɔ fuu, nde Allabatala n di ko latɔn wo tii la. ");
INSERT INTO msc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Ai ye ai hankili to Ɲɔɲɔ lon dɔ, ka wo bila a dan na nde Alla yɛ. ");
INSERT INTO msc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ai ye baara kɛ tele wɔɔrɔ kɔrɔ, ka ai la ko bɛɛ kɛ, ");
INSERT INTO msc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","kɔni tele wɔrɔnwulana ye Ɲɔɲɔ lon de ri, mɛn bilani nde ai Maari Allabatala yɛ. Ai kana baara si kɛ wo lon. Ai jɛrɛ, ai dencɛilu, ai denmusoilu, ai la jɔncɛilu, ai la jɔnmusoilu a ni ai la kolofenilu, woilu si kana baara kɛ wo lon. Hali londan mɛnilu siini ai wara, woilu kana baara si kɛ wo lon, ");
INSERT INTO msc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","baa nde Allabatala le ka san dan ni duu dan ni kɔɔji fanan dan, a ni ii kɔndɔfenilu bɛɛ. N ka wo bɛɛ dan tele wɔɔrɔ le kɔrɔ, ka ɲɔɲɔ tele wɔrɔnwulana lon. Wo le rɔ, n ka tele wɔrɔnwulana baraka, ka a bila n yɛ ka a kɛ tele sɛniman di. ");
INSERT INTO msc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Ai ye ai fa ni ai na bonya, sa ai ri si jan sɔrɔn jamana rɔ, ai Maari Allabatala ye jamana mɛn dila ai ma. ");
INSERT INTO msc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Ai kana mɔɔ faa. ");
INSERT INTO msc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Ai kana kaninkɛ kɛ. ");
INSERT INTO msc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Ai kana suɲali kɛ. ");
INSERT INTO msc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Ai kana kɛ sere juu ri, mɛn ye wuya lala a mɔɔɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Ai kana ai nata la ai mɔɔɲɔɔ na bon fɛ. Ai kana ai nata la ai mɔɔɲɔɔ na muso fɛ, wala a la jɔncɛ, wala a la jɔnmuso, wala a la nisi, wala a la fali, wala a bolofen si.» ");
INSERT INTO msc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Awa, mɔɔilu tɛrɛ ye sankulu kan ni buru fɛ kan mɛnna. Ii tɛrɛ ye sanfɛrɛnilu yenna jiila koyinkɛ kan, ka sisi wulitɔ fanan yen koyinkɛ kan. Ii ka wo bɛɛ yen tuma mɛn na, ii silanda fɔɔ ka yɛrɛyɛrɛ. Wo rɔ, ii lɔni tora yɔrɔ jan. ");
INSERT INTO msc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ii ka a fɔ Musa yɛ ko: «I jaandi, i jɛrɛ ye kuma an yɛ, an di an tolo malɔ i la, kɔni Alla kana kuma an yɛ, ni wo tɛ an bɛɛ ri faa.» ");
INSERT INTO msc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa ka ii jabi: «Ai kana silan, baa Alla ra na ka ai kɔrɔbɔ. A ye a fɛ ai ye kɛ Alla ɲɛsilanɲɛbailu ri sa ai kana kojuu kɛ.» ");
INSERT INTO msc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nba, ka ii lɔni to wula jan na ye, Musa ka i madon sanfin wo la, Alla tɛrɛ ye sanfin mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Allabatala ka a fɔ Musa yɛ ko: «I ye a fɔ Isirayɛlikailu yɛ ko: ‹ai ra a yen ai jɛrɛ ɲa la ko n tora san dɔ ka kuma ai yɛ. ");
INSERT INTO msc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ai kana joo wodigbɛlamanilu wala joo saninnamanilu ladan ai jɛrɛ yɛ, ka woilu bato nde kɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ai ye banku ta ka saraka janin diya lɔ n yɛ. Ai ye ai la saa ni baa ni nisi mɛnilu kɛla saraka janintailu ni jususuma sarakailu ri, ai ye woilu kannatɛɛ ka ai di n ma saraka janin diya wo kan. N wa yɔrɔ yɔrɔ suwandi sa ai ri n bato ye, n di na ai tɛrɛn ye ka baraka don ai la ko rɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ni ai ka n na saraka janin diya do lɔ kaba la, ai kana a lɔ kaba malɛsɛninilu la. Ka a masɔrɔn, kaba malɛsɛnin di n na saraka janin diya manɔɔ. ");
INSERT INTO msc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ai kana yɛlɛ yɛlɛdiyailu kan ka wa saraka bɔ, sani mɔɔ mɛnilu lɔni duu ma kana ai la fari makolonna yen ai la faanin ju kɔrɔ.›» ");
INSERT INTO msc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Allabatala ka a fɔ Musa yɛ ikɔ tuun ko: «I ye sariya ɲinilu fɔ Isirayɛlikailu yɛ. ");
INSERT INTO msc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ni ai ka Heburu jɔncɛ san, a ye baara kɛ ai yɛ san wɔɔrɔ kɔrɔ. Kɔni a san wɔrɔnwulana wa se, ai ye a bila sa a ri wa. A ma kan ka foyi sara a bila ko rɔ. ");
INSERT INTO msc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ni ai ka a san ka a tɛrɛn muso tɛ a kun, ai ye a kelen bila. Ni ai ka a san ka a tɛrɛn muso tii le a ri, ai ye a ni a muso bila. ");
INSERT INTO msc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kɔni ni jɔncɛ wo muso ka denilu sɔrɔn a yɛ ka a tɛrɛn a jɔntii le ka muso wo di a ma, muso ni a denilu ri to jɔntii bolo. Jɔncɛ kelen di wa. ");
INSERT INTO msc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«Kɔni ni jɔncɛ ka a fɔ ko a jɔntii ni a muso ni a denilu duman a yɛ, ko wo le kosɔn a tɛ a fɛ a jɔntii ye a bila, ");
INSERT INTO msc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","jɔntii ri wa jɔn di Alla ɲakɔrɔ. A ri wa jɔn di wo rɔ ka a lalɔ bonda la, wala bonda la jiri la, ka a tolo sɔɔ sɔɔlifen na. Wo rɔ jɔncɛ ri to baarala jɔntii yɛ a si bɛɛ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Nba, ni cɛɛ do ka a denmuso feere ka a kɛ jɔnmuso ri, denmuso tɛ hɔrɔya ikomin jɔncɛilu ye hɔrɔyala ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ni denmuso ma diya a jɔntii yɛ, mɛn ka a san a furu kanma, jɔntii ye a to denmuso fa ye a kunka. Jɔntii kana denmuso feere siya gbɛrɛ mɔɔ ma. Wo sariya tɛ a bolo, janfa le wo ri. ");
INSERT INTO msc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ni jɔntii ka denmuso wo di a dencɛ ma, fɔɔ a ye a mira ikomin a denmuso. ");
INSERT INTO msc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ni jɔntii ka jɔnmuso kɛ a muso ri, ka ban ka muso gbɛrɛ furu ka a la jɔnmuso kan, fo a ye jɔnmuso balo, ka a feriyabɔ, ka la a fɛ ikomin a darini a kɛla ɲa mɛn ma kɔrɔman na. ");
INSERT INTO msc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ni jɔntii ma ko sawa wo kɛ jɔnmuso yɛ, jɔnmuso ri kanhɔrɔya ka wa a sankɔ sa a lasɛ la.» ");
INSERT INTO msc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Mɔɔ mɛn wa mɔɔ gbasi ka a faa, wo tii ye faa. ");
INSERT INTO msc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kɔni ni mɔɔ ka mɔɔ faa ka a tɛrɛn a miriya tun tɛ a la ka a faa, kɔni Alla le ka a kɛ wo kɛra a bolo, mɔɔfaala wo ye i bori ka wa a makandan yɔrɔ do rɔ, n kɛtɔ mɛn yirakala ai la. ");
INSERT INTO msc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ni mɔɔ do ka a lawuli a ma ka a mɔɔɲɔɔ faa kewuya la, ai ye wo tii mira ka a faa, hali ni a ra i bori ka wa a makandan n saraka janin diya rɔ. ");
INSERT INTO msc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Ni mɔɔ mɛn ka a fa gbasi, wala a na gbasi, wo tii ye faa. ");
INSERT INTO msc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Ni mɔɔ mɛn ka mɔɔ do sonya ka wa a ri, wo tii ye faa. Ni ai ka mɔɔ wo tɛrɛn a bolo, wala ni ai ka a tɛrɛn a ra mɔɔ wo feere, wo tii ye faa. ");
INSERT INTO msc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Ni mɔɔ mɛn ka a fa wala a na danka, wo tii ye faa. ");
INSERT INTO msc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","«Ni mɔɔ do ka a mɔɔɲɔɔ madimin kaba la wala a bolo la sɔsɔli rɔ, ka a kɛ sababu ri a mɔɔɲɔɔ wo lani ri to a la lafen kan ka mɛn, ai kana ko kɛ wo tii la fɔlɔ, fɔɔ ka makɔnɔni kɛ. Kɔ fɛ, ni madiminbatɔ ka gbeleke ta ka i wuli ka taama damira lu ma, a gbasila kana jalaki butun. Kɔni madiminbatɔ la baara lalɔ mɛn kɛra, a gbasila ye wodi bɔ ka wo sara madiminbatɔ yɛ. Ka a la wo kan, a ye a janto madiminbatɔ rɔ haan a wa kɛndɛya fewu. ");
INSERT INTO msc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Mɔɔ wa a la jɔncɛ wala a la jɔnmuso gbasi gbeleke la, ni jɔn wo faara wo kosɔn, ko ye latɔn jɔntii la. ");
INSERT INTO msc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kɔni ni jɔn wo ka tele kelen wala tele fila kɛ a ma faa, ko kana latɔn jɔntii la, baa a ta le jɔn di fasayi! ");
INSERT INTO msc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Cɛɛ fila wa to kɛlɛla ka se muso kɔnɔma do ma, ka a kɛ sababu ri a moyira jona, ni muso ma madimin ba kɛ, mɛn sera a ma wo ri wodi bɔ. A ka kan ka wodi jate mɛn bɔ, muso tii ri wo fɔ, kɔni fɔɔ kititɛɛlailu wa sɔn jate wo ma. ");
INSERT INTO msc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kɔni ni kojuu ka muso sɔrɔn, ai ye wo ta sara, nii ye sarala nii de la, ");
INSERT INTO msc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ɲa ye sarala ɲa le la, ɲin ye sarala ɲin de la, bolo ye sarala bolo le la, sen ye sarala sen de la. ");
INSERT INTO msc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Mɛn wa do majanin, ai ye wo fanan majanin. A wa do madimin, ai ye a fanan madimin. Mɛn wa mɔɔ gbasi ka yɔrɔ do funu, ai ye wo tii fanan gbasi ka yɔrɔ do funu. ");
INSERT INTO msc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Ni mɔɔ do ka a la jɔncɛ wala a la jɔnmuso gbasi ka se wo ɲa ma ka a ɲa fuyen, fo a ye jɔn wo kanhɔrɔya. Wo ri kɛ ɲa wo sara ri. ");
INSERT INTO msc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ni a ka a la jɔncɛ wala a la jɔnmuso gbasi ka wo ɲi bɔ a da rɔ, fo a ye jɔn wo kanhɔrɔya. Wo ri kɛ ɲi wo sara ri. ");
INSERT INTO msc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Ni tora do ka cɛɛ wala muso sɔɔ ka a faa, ai ye tora wo bon kaba la ka a faa. Mɔɔ kana tora wo sobo dɔɔn. Kɔni ai kana tora tii jalaki wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ni tora wo darini mɔɔilu sɔɔla, ka a tɛrɛn mɔɔilu ra wo fɔ a tii yɛ kɔni a ma sɔn ka a janto a rɔ, ni tora wo ka mɔɔ do sɔɔ ka a faa, ai ye tora wo bon kaba la ka a faa ka a tii fanan faa. ");
INSERT INTO msc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kɔni ni sayabatɔ la denbaya ka a fɔ ko tora tii ye wodi bɔ sa a kana faa, tora tii ri wodi bɔ ka a nii kunka. Kɔni wodi jate mɛn fɔni, fo a ye wo bɛɛ sara le fasayi. ");
INSERT INTO msc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ni tora ka mɔɔ do dencɛ wala denmuso sɔɔ, sariya kelen ɲin ye mɛn fɔla, ai ye wo kɛ. ");
INSERT INTO msc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ni tora ka jɔncɛ wala jɔnmuso sɔɔ, tora tii ye wodi gbanan bisawa bɔ ka a di jɔn tii ma. Kɔni ai ri tora wo bon kaba la. ");
INSERT INTO msc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Ni mɔɔ do ka ji lamara denka sen ka a da lakani to, ni wo tɛ a ka ji lamara denka kɔrɔ da lakani to, ni tora wala sofali nara be wo kɔndɔ, ");
INSERT INTO msc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","denka tii ri kolofen sankɔ lasɛ kolofen tii ma. Kɔni kolofen wo sobo ri kɛ denka tii ta ri. ");
INSERT INTO msc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Ni mɔɔ do la tora ka mɔɔ gbɛrɛ ta madimin fɔɔ a sara, nisi tii fila woilu ye dɛ ka tora kelen wo feere ka a sankɔ wodi rafara ii ɲɔɔn tɛ. Ii ri tora faani sobo fanan ratala ii ɲɔɔn tɛ. ");
INSERT INTO msc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ni mɔɔilu tun ka a lɔn kɔrɔman ko tora wo darini torailu sɔɔla, kɔni a tii ma sɔn a jantola a rɔ, tora tii wo ye tora faani ɲɔɔn bɔ ka a di tora tii do wo ma. Tora faani wo ri kɛ a ta ri. ");
INSERT INTO msc_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Ni mɔɔ do ka nisi wala saa sonya ka a faa, wala ka a feere, a ye nisi loolu sara nisi kelen nɔ rɔ. Ni saa le, a ye saa naanin lasɛ saa kelen nɔ rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Ni mɔɔ do ka son dontɔla yen bon na su rɔ ka a gbasi ka a faa, wo tii tɛ jalaki mɔɔ faa ko rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kɔni ni mɔɔ do ka son dontɔla yen ka a gbasi ka a faa ka a tɛrɛn tele ra bɔ, wo tii ri jalaki mɔɔ faa ko rɔ. Awa, ni son mirara, a ra fen mɛnilu sonya, fo a ye woilu bɛɛ sara le fewu. Ni wodi tɛ a bolo, fo a jɛrɛ ye feere ka a sɔnkɔ lasɛ fen tii ma. ");
INSERT INTO msc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Son wa nisi wala sofali wala saa sonya, ni mɔɔilu ra son mira ka a tɛrɛn kolofen kɛndɛ wo ye a bolo fɔlɔ, fo a ye wo ɲɔɔn fila lasɛ. ");
INSERT INTO msc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Ni mɔɔ do ka a la kolofen bila sɛnɛ rɔ, wala rɛsɛnfɛ rɔ, ni kolofen wara a kun fɛ ka wa mɔɔ do la sɛnɛfen do dɔɔn, kolofen tii ye wo sara. Kolofen ka fen fen dɔɔn, kolofen tii ri wo ɲɔɔn sara ka bɔ a la sɛnɛfen ɲuma ɲumailu rɔ, wala a la rɛsɛn ɲuma ɲumailu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Mɔɔ mɛn wa ta su a wara, ni ta wo ka bin wɔninmanilu mira ka wa do la sɛnɛ rɔ ka sumansidi doilu janin, wala suman mɛnilu ma ka fɔlɔ, wala sɛnɛ bɛɛ, ta sula ye fen woilu bɛɛ sara. ");
INSERT INTO msc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Ni mɔɔ do ka a la wodi wala a la bolofen doilu karifa a siiɲɔɔ la kɔni woilu sonyara a siiɲɔɔ na bon na, ni son mirara, son ye wo ɲɔɔn fila lasɛ. ");
INSERT INTO msc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kɔni ni ii ma son yen, fo bon tii ye wa i lɔ Alla ɲana ka a kali ko a ma a siiɲɔɔ na bolofen wo sonya. ");
INSERT INTO msc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","«Ni mɔɔ doilu ka sɔsɔli kɛ fen do kan, a kɛra nisi ri wo, a kɛra sofali ri wo, a kɛra saa ri wo, a kɛra faanin di wo, a kɛra fen fen di mɛn tununni, ni ii fila ye a fɔla ko a ta le ye fen wo ri, ii ye wa i lɔ Alla ɲakɔrɔ. Alla wa mɛn jalaki ko a jo tɛ, wo ri fen wo ɲɔɔn fila lasɛ a duɲɔɔn ma. ");
INSERT INTO msc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Mɔɔ wa a la sofali wala a la nisi wala a la saa wala a la kolofen gbɛrɛ karifa a siiɲɔɔ do la, ni kolofen wo sara wala a madiminda, ni wo tɛ tiɲannilailu nara fo a kɔ ma, ");
INSERT INTO msc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","fo siiɲɔɔ wo ye wa ka a kali Allabatala ɲana ko a ma ko si kɛ kolofen na. Kolofen tii ye diɲɛ wo ma. A siiɲɔɔ ti nala kolofen wo ɲɔɔn sarala wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kɔni ni mɔɔ le tun ka kolofen sonya siiɲɔɔ wara, fo siiɲɔɔ ye kolofen wo ɲɔɔn nasɛ kolofen tii ma. ");
INSERT INTO msc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ni waa rɔ sobo le tun ka kolofen mira ka a rafarafara, siiɲɔɔ ye na sobo tɔ wo ri ka a kɛ sereya ri. A tɛ wodi bɔ wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","«Ni mɔɔ do ka kolofen sinkan a siiɲɔɔ ma, kɔni kolofen madiminda a tii kɔ, wala a sara, a tɛrɛ ye mɛn bolo, fɔɔ wo ye a ɲɔɔn sara le. ");
INSERT INTO msc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kɔni ni ko kɛra kolofen na a tii ɲana le, mɛn ka kolofen wo sinkan a tii ma, wo tɛ a ɲɔɔn sara. Ni kolofen tii tun ka wodi sɔrɔn ka kolofen sinkan, ka a tɛrɛn kolofen da sa, fo a tii ye a wasa don sinkanni wodi wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Ni cɛɛ ka sunkurun do yen, mɛn da a jɛrɛ kanda, mɛn fanan mamirani tɛ, ni cɛɛ ka sunkurun wo manɛɛn ka i la a fɛ, fɔɔ a ye furu nanfulu bɔ ka sunkurun wo furu. ");
INSERT INTO msc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ni sunkurun wo fa ka i ban a dila cɛɛ wo ma, fo cɛɛ wo ye furu nanfulu bɛɛ bɔ le hali a ma denmuso sɔrɔn. Mɔɔilu ye jate mɛn bɔla ka sunkurun wo ɲɔɔn furu, mɛn kɔnin da a jɛrɛ kanda, fo cɛɛ ye jate wo bɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Muso mɛn ye subaya kɛla, ai kana sɔn wo ye to ɲenemaya rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Ni mɔɔ do ni kolofen dɛra, ai ye mɔɔ wo faa. ");
INSERT INTO msc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Mɛn wa batofen do sɔ, mɛn kɔnin tɛ nde Allabatala ri, wo tii ye faa. ");
INSERT INTO msc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Ai kana kojuu kɛ londanilu la ka ii tɔrɔ kojuuya, baa ai fanan kɛra londanilu le ri Misiran jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«Ai kana kojuu kɛ cɛsamusoilu ni faratanniilu la. ");
INSERT INTO msc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ni ai ka ko kɛ ii la, ii wa ii makasi nde yɛ ko n ye ii dɛmɛn, n di n tolo malɔ ii kan na. ");
INSERT INTO msc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","N di mɔnɛ ai kanma wo rɔ. N di a kɛ ai ri faa fanmuru la. Ai musoilu ri kɛ cɛsamusoilu ri. Ai denilu ri kɛ faratanniilu ri. ");
INSERT INTO msc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","«Ni ai ka julu don dɛsɛbatɔ do la, ni a ye n na jama mɔɔ do ri, ai kana fen la wodi wo jate kan ka a kɛ ai la tɔnɔ ri. Julumuntii ye tɔnɔ ɲininna ten de. ");
INSERT INTO msc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ni ai ka ai siiɲɔɔ na durukiba ta julu kun kɔrɔ, wura wura ai ye a lasɛ a ma, ");
INSERT INTO msc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","baa wo kelen pe le ye a bolo. A wa a la su rɔ, a ri nfen kɛ a la birinkan di ni wo tɛ? Nba, ni a ka a makasi nde yɛ ko n ye a dɛmɛn, n di n tolo malɔ a kan na, baa hinatii le nde ri. ");
INSERT INTO msc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Ai kana Alla mananin. Ai kana ai la kuntii danka. ");
INSERT INTO msc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Ai wa suman ni rɛsɛnji mɛn sɔrɔn, ai ye n ta fan bɔ ka a kɛ saraka di. Ai kana kundasumaya wo kɛla. «Ai ye ai den fɔlɔilu di nde Allabatala ma. ");
INSERT INTO msc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Ai ye ai la nisiden fɔlɔilu fanan di n ma wo ɲa, a ni ai la saaden fɔlɔilu. Ai ye a to kolofen den fɔlɔ woilu ye to ii nailu fɛ tele wɔrɔnwula kɔrɔ. Ii sɔrɔn tele seyin, ai ye ii di nde ma. ");
INSERT INTO msc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ai ri kɛ n na mɔɔ sɛnimanilu le ri. Wo rɔ, waa rɔ sobo wa kolofen mɛn rafarafara, ai kana wo sobo dɔɔn. Ai ye wo lafili wuluilu kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Ai kana wuya lajɛnsɛn mɔɔilu tɛma. Ai wa kɛ sere ri kiti diya, ai kana wuya fɔ ka mɔɔ juu dɛmɛn. ");
INSERT INTO msc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ai kana ai bila jama kɔ ka wa kojuu kɛ. Ai wa kɛ sereilu ri kiti diya, ai kana ai la sereya jɛnkɛ ka ai bila jama kɔ ka wuya fɔ. ");
INSERT INTO msc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ni bolokolon nara kiti diya, ai kana wuya fɔ a la ko kininkinin kosɔn ka a dɛmɛn. ");
INSERT INTO msc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Ni ai bɛnda ai juu la nisi ri, wala a la sofali ri, mɛn da tunun a ma, ai ye a mira ka wa a ri a tii ma. ");
INSERT INTO msc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ni ai ka ai juu yen sila la, a la sofali beni a donin gbilin kɔrɔ, ai kana a to ye. Ai ye ai juu dɛmɛn a la sofali a lawulila. ");
INSERT INTO msc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Bolokolon wa na kiti diya, fɔɔ ka wo la kiti tɛɛ telenbaya la. ");
INSERT INTO msc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ai kana wuya la ai mɔɔɲɔɔ na kiti diya. Ai kana kiti gboya mɔɔ jalakibali la, wala mɔɔ telenni la, ka woilu faa, baa mɛn wa kojuu wo kɛ, n tɛ yafa wo ma. ");
INSERT INTO msc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ai kana surɔfen mira, ka a masɔrɔn surɔfen de ye a kɛla mɔɔilu tɛ sɔn tuɲa yenna. Mɔɔ telenni ye kititɛɛ mɛnilu kɛla, surɔfen ye woilu tiɲanna. ");
INSERT INTO msc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Ai kana londanilu tɔrɔ. Ai jɛrɛ ka a lɔn londanya ye ɲa mɛn ma, baa ai tɛrɛ ye londan de ri Misiran jamana rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Ai ye sɛnɛ kɛ san wɔɔrɔ kɔrɔ, ka lanni kɛ ka suman nadon. ");
INSERT INTO msc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kɔni a san wɔrɔnwulana, ai ye ai la duu wo to ye, ai kana a sɛnɛ. Bolokolon mɛnilu ye ai tɛma, woilu ri balo do sɔrɔn ye, baa suman doilu ri fɛrɛn a jɛrɛ ma. Bolokolonilu fanan wa mɛn to ye, waa rɔ soboilu ri wo dɔɔn. Ai ye wo ɲɔɔn kɛ ai la rɛsɛnfɛilu fanan dɔ, a ni ai la olibiye fɛilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Baara kɛta mɛn wa kɛ ai ma, ai ye wo kɛ tele wɔɔrɔ kɔrɔ. Kɔni tele wɔrɔnwulana lon, ai kana baara si kɛ. Wo rɔ, ai la nisi ni ai la faliilu ri ii ɲɔɲɔ, a ni i la jɔnmuso la dencɛ ni londan mɛnilu siini ai wara. ");
INSERT INTO msc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«N ka mɛnilu bɛɛ fɔ ai yɛ, ai ye woilu bɛɛ labato fewu. Ai kana batofen gbɛrɛilu si bonya muumɛ. Mɔɔilu kana woilu tɔɔ mɛn ai da rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«San san ai ye sali sawa kɛ ka n bonya. ");
INSERT INTO msc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","«A waati wa se Abibu karo la, ai ye Buru Fununbali Sali kɛ, ka buru lɛbɛnta dɔɔn tele wɔrɔnwula kɔrɔ ikomin n ka a fɔ ai yɛ ɲa mɛn ma. Ai ye a kɛ ten, baa ai bɔra Abibu karo le la Misiran. Kɔni ai kana na n bato diya ni niilifen ma na ai bolo. ");
INSERT INTO msc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ai ri Sumanka Sali kɛ san san. Wo tuma, ai ri ai la suman kura fɔlɔilu kɛ saraka ri, ai ra mɛnilu sɔrɔn ai la sɛnɛ rɔ. Ai wa ban sɛnɛ baarala san san ka suman nadon, ai ye Suman Nadon sali kɛ. ");
INSERT INTO msc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","San san, ai la cɛɛilu bɛɛ ye na sali sawa ɲin kɛ n ɲakɔrɔ ka n bato, nde mɛn ye ai Maari Allabatala ri. ");
INSERT INTO msc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Ai wa kolofen kɛ saraka ri ka wo jeli di n ma, ai kana buru fanan di n ma, lɛbɛn ye mɛn dɔ. Ai wa kɛ kolofen bɔla n yɛ sali tumana, wo ken kana su si. ");
INSERT INTO msc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","San san ai wa suman kura fɔlɔ mɛnilu ka, ai ye na wo ɲuma ɲumailu ri ai Maari Allabatala a la bon na. «Ai kana badenni sobo tibi a na nɔnɔ la.» ");
INSERT INTO msc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«N di mɛlɛka lawa ai ma, mɛn di wa ai ɲɛ ka ai lakandan sila la. A ri ai lana jamana rɔ, n ka mɛn dabɛn ai yɛ. ");
INSERT INTO msc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ai ye ai tolo malɔ mɛlɛka wo la ka a kumakan mira ka wo kɛ, baa a ye ko bɛɛ kɛla n tɔɔ le rɔ. Ai kana a masɔsɔ. Ni ai ka a sɔsɔ a ti nala yafala ai ma. ");
INSERT INTO msc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kɔni ni ai ka ai tolo malɔ a la koɲuma ka n kumakan bɛɛ latelen, ai juuilu ri kɛ n juuilu ri, ai kɛlɛɲɔɔnilu ri kɛ n kɛlɛɲɔɔnilu ri. ");
INSERT INTO msc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«N na mɛlɛka ri wa ai ɲɛfɛ ka ai ladon jamana wo rɔ. Amɔrikailu siini ye, a ni Hɛtikailu ni Peresikailu ni Kanaankailu ni Hifikailu ni Jebusikailu, kɔni n di woilu halaki. ");
INSERT INTO msc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ai kana i majii ii la batofenilu ɲɛ ka woilu bato. Ai kana i ladɛn ii la dina ko kɛɲailu rɔ. Ai ye ii la batofen bisikilu ratiɲan fewu. Ai ye ii la kaba lalɔni batotailu rakadikadi. ");
INSERT INTO msc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ni ai ka ai Maari Allabatala bato, n di balo ɲuma ni ji siyaman di ai ma, ka jankarɔ mabɔ ai la. ");
INSERT INTO msc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ai muso si kɔnɔ ti tiɲan ai la jamana rɔ. Muso si tɛ kɛ densɔrɔnbali ri. N di si jan di ai ma ka ai sabati. ");
INSERT INTO msc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«N di a kɛ, jamanailu bɛɛ mɔɔilu wa ai na ko mɛn, ii ri silan kosɛbɛ. Ai wa se yɔrɔ yɔrɔ, ye mɔɔilu ri kɔndafili ai ɲɛ kojuuya. Ai juuilu bɛɛ ri i bori ai ɲɛ. ");
INSERT INTO msc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","N di dondoli kunbailu lawa ai ɲɛ ka Hifikailu ni Kanaankailu ni Hɛtikailu gbɛn. ");
INSERT INTO msc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kɔni n ti nala woilu gbɛnna ai ɲɛ san kelen kɔrɔ, sa jamana rakolon kana to, baa waa rɔ soboilu kana siyaya ai ma ka ai tɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","N di to mɔɔilu gbɛnna ai ɲɛ dooni dooni haan ai ye siyaya ka jamana wo bɛɛ mira ka a kɛ ai ta ri. ");
INSERT INTO msc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","N di ai la jamana dan sii. A dan di bɔ Kɔɔji Fararɔbin ma ka wa se fɔɔ Filisitiilu la kɔɔji ma, ka bɔ Sinayi wula ma ka wa se fɔɔ Efirati Ba ma. N di jamana wo duurenilu don ai bolo, ka ii gbɛn ai ɲɛ. ");
INSERT INTO msc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ai kana teriya don ai ni woilu tɛma, wala ai ni ii la batofenilu tɛma. ");
INSERT INTO msc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ai kana sɔn mɔɔ woilu ye i sii ai la jamana kɔndɔ sani ii ri ai lɔ nde Allabatala hakɛ tala, baa ni ai ka ii la batofenilu bato, a ri kɛ ikomin ai ra mira miralifen na.» ");
INSERT INTO msc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Allabatala ka a fɔ Musa yɛ ko: «I ye na yɛlɛ koyinkɛ kan ka i madon n na, i ni Haruna ni Nadabu ni Abihu ni Isirayɛlika mɔɔbakɔrɔ biwɔrɔnwula. Ai kana ai madon bakɛ ka yɔrɔ jannin to an tɛma ka ai tinbirin ka nde bato. ");
INSERT INTO msc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wo kɔ rɔ, ile kelen ye yɛlɛ koyinkɛ kun tɛma, ka i madon n na. A tɔilu kana na i madon n na. Jama fanan kana yɛlɛ koyinkɛ kan i kɔfɛ.» ");
INSERT INTO msc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa wara ka Allabatala la kuma ni jamariliilu bɛɛ lase jama ma. Mɔɔ bɛɛ ladɛnnin ka a fɔ ko: «Allabatala ka mɛn fɔ, an di woilu bɛɛ kɛ.» ");
INSERT INTO msc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Allabatala tun ka kuma mɛnilu fɔ, Musa ka wo bɛɛ sɛbɛ. Wo duusa gbɛ, Musa wulira sɔɔma jona ka saraka janin diya lɔ koyinkɛ kɔrɔ, ka ban ka kaba tan ni fila lalɔ, Isirayɛlika la kabila kelen kaba kelen. ");
INSERT INTO msc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","A ka Isirayɛlika kanberen doilu lɔ saraka janintailu a ni jususuma saraka bɔla. Ii ka saraka janintailu bɔ ka woilu kɛ buuri ri, ka tora doilu bɔ ka woilu kɛ duɲɔɔnya saraka ri. ");
INSERT INTO msc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa ka saraka woilu jeli rafara fila ri, ka fan kelen kɛ muran kɔndɔ, ka fan kelen sadisadi saraka janin diya kan. ");
INSERT INTO msc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Alla tun ka teriya mɛn sidi ii yɛ, Musa ka wo kitabu ta ka a karan kan ba la jama ɲana. Jama ka a fɔ ko: «Allabatala ka mɛnilu fɔ, an di woilu bɛɛ latelen.» ");
INSERT INTO msc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa tun ka jeli mɛn kɛ muran kɔndɔ, a ka wo ta ka a sadisadi mɔɔilu kan. A ka a fɔ ko: «Allabatala ka teriya mɛn sidi a ni ai tɛ jamarili ɲinilu fɛ, jeli ɲin de ye wo siila.» ");
INSERT INTO msc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Nba, Musa ni Haruna wara yɛlɛ koyinkɛ kan, a ni Nadabu ni Abihu ni Isirayɛlika mɔɔbakɔrɔ biwɔrɔnwula. ");
INSERT INTO msc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ii ka Isirayɛlika Maari Alla yen. Fen do tɛrɛ ye a sen kɔrɔ. A kɛni ikomin wo rabɛnni kuru bulemanilu le rɔ, mɛnilu tɔɔ ko safiri. Woilu nɔɔrɔ tɛrɛ ye ikomin san jɛrɛ nɔɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Alla ma kojuu kɛ Isirayɛlika la ɲɛmɔɔ woilu la. Ii ka Alla yen, ka dɔɔnnin kɛ ka ii min ye. ");
INSERT INTO msc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Allabatala ka a fɔ Musa yɛ ko: «I ye yɛlɛ koyinkɛ kan, ka na i madon n na ka to ye. N di walan kabalamanilu don i bolo, n na sariya jamariliilu sɛbɛni mɛnilu kan, sa i ri jama karan woilu la.» ");
INSERT INTO msc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa ni a dɛmɛnba Josuwe wulira bɔ kanma ye. Musa yɛlɛra Alla la koyinkɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kɔni yani a ye bɔ ɲɛmɔɔilu fɛ, a ka a fɔ ii yɛ ko: «Ai ye an makɔnɔ yan, haan an wa na. Haruna ni Huri ri to ai fɛ. Ni sɔsɔli su su donda mɔɔilu tɛma, ii ye wa Haruna ni Huri tɛrɛn.» ");
INSERT INTO msc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Awa, Musa yɛlɛra koyinkɛ kan tuma mɛn na, banda ka koyinkɛ latunun. ");
INSERT INTO msc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Allabatala la gbiliya jiira Sinayi koyinkɛ kan ka to ye. Banda ka koyinkɛ latunun tele wɔɔrɔ kɔrɔ. A tele wɔrɔnwulana ma, Allabatala tora banda rɔ ka Musa kili. ");
INSERT INTO msc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Isirayɛlika mɛnilu tɛrɛ ye daa makɛ diya, woilu ka Allabatala la gbiliya yen koyinkɛ kun na. Wo kɛni ii ɲana ikomin ta ba ra koyinkɛ kun mira. ");
INSERT INTO msc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa donda banda rɔ, a yɛlɛra koyinkɛ kun tɛma. A ka su binaanin ni tele binaanin kɛ ye. ");
INSERT INTO msc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«I ye a fɔ Isirayɛlika yɛ ko ii ye na niilifenilu di n ma. Mɔɔ mɔɔ ye a fɛ ka fen do di, i ye wo mira n yɛ. ");
INSERT INTO msc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ii la niilifenilu ka kan ka kɛ mɛnilu ri, woilu le ɲin: sanin, wodigbɛ, sulanɛɛ, ");
INSERT INTO msc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kari buleman, kari wulenman ɲalagbɛ, kari wulenman kadi kadi, a ni faaningbɛ ɲuma, baa si, ");
INSERT INTO msc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","a ni saaji gbolo kolone wulenman ni gbolo kolonin ɲuma su gbɛrɛilu ni kasiya jiri. ");
INSERT INTO msc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ii ye na olibiye tulu ri, mɛn di kɛ fitinailu rɔ. Ii ye na sumadiyalanilu fanan di, mɛnilu ri kɛ wusulan ni suwandili tulu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Kabakuru mɛn tɔɔ ko onikisi, ai ye na wo ri, a ni kuru ragbɛlɛn gbɛrɛilu. Kaba woilu ri kara n sarakalasela la kɔkanbila durukini kan, a ni a la sisirɔ bɔrɔni kan. ");
INSERT INTO msc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Isirayɛlikailu ye faaninbon sɛniman do ladan n yɛ, sa n di n daa makɛ ii tɛma. ");
INSERT INTO msc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","N di n daa makɛ faaninbon wo ni a kɔndɔ fenilu sawura yiraka i la. I ri a bɛɛ ladan ikomin sawura wo ye ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Ai ye teriya tɔɔmasere kankira ladan kasiya jiri rɔ. A janya ye kɛ nunkan ɲa fila ni tala ri, a kɔndɔ ye kɛ nunkan ɲa kelen ni tala ri, a lɔ ye kɛ nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ai ye sanin jɛrɛwolo la a kɔndɔla ni a kɔkanna bɛɛ kan ka a jiri bɛɛ latunun. Ai ye a da kirinkirin bɛɛ kɛ sanin di. ");
INSERT INTO msc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ai ye koyina saninnaman naanin nadan, ka woilu bila kankira sen naanin na, sen kelen koyina kelen. Wo rɔ, koyina fila ri kɛ kankira fan kelen fɛ, a tɔ fila ri kɛ fan do fɛ. ");
INSERT INTO msc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ai ye gbelekeilu rabɛn kasiya jiri rɔ, ka sanin la woilu ma ka a jiri bɛɛ latunun. ");
INSERT INTO msc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ai ye woilu don koyinailu rɔ teriya tɔɔmasere kankira fan fila bɛɛ rɔ, sa kankira ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Gbeleke woilu donni ye to koyinailu rɔ. Ai kana woilu labɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","N kɛtɔ sereya mɛn sɛbɛla, i ye wo bila teriya tɔɔmasere kankira kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Ai ye julumun kafari dalatuun nadan sanin jɛrɛwolo la. A janya ye kɛ nunkan ɲa fila ni tala ri. A kɔndɔ ye kɛ nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ai ri serubɛn bisiki kelen kelen nadan datuun na a kun fila la. Ai ri woilu ladan sanin gbasinin dɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ai ye serubɛn bisiki kelen nadan kankira datuun na a kun kelen na, ka a tɔ kelen nadan dalatuun kun do wo la. Serubɛn bisiki fila ni kankira dalatuun bɛɛ ye ladan ka a kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Serubɛn sawura fila ri ɲabɛn ɲɔɔn ma, ka ii ɲa lɔni to julumun kafari datuun na. Ii kawailu ri layɛlɛ san ma, ka birin kankira datuun na kun na. ");
INSERT INTO msc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","N kɛtɔ walan kabalaman fila mɛn dila ile ma, i ri woilu bila teriya tɔɔmasere kankira kɔndɔ ka a dalatuun ii ma. ");
INSERT INTO msc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","N kɛtɔ n jɛrɛ yirakala i la teriya tɔɔmasere kankira datuun na sanma ye, serubɛn bisiki fila tɛma. N ye a fɛ Isirayɛlikailu ye taama ɲa mɛn ma, n di wo sariyailu bɛɛ di i ma ye le.» ");
INSERT INTO msc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Awa, ai ye tabali kelen nadan kasiya jiri rɔ. A janya ye kɛ nunkan ɲa fila ri, a kɔndɔ ye kɛ nunkan ɲa kelen di, a lɔ ye kɛ nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ai ye sanin jɛrɛwolo la tabali wo bɛɛ ma ka jiri bɛɛ latunun, ka a da kirinkirin bɛɛ kɛ sanin di. ");
INSERT INTO msc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ai ye fɛrɛnilu kankan tabali la tabali fan bɛɛ la. Fɛrɛn woilu bonya ri bɛn bolo koyini naanin bonya ma. Ai ye dagbolo saninnaman kɛ fɛrɛn woilu la. ");
INSERT INTO msc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ai ye koyina naanin nadan sanin dɔ, ka woilu kelen kelenna don tabali tonkon naanin na a sen kelen kelenna dafɛ. ");
INSERT INTO msc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Koyinailu ye lasudunya fɛrɛnilu la. Tabali ta gbelekeilu ri don koyina woilu rɔ sa tabali ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ai ye gbeleke fila ladan kasiya jiri rɔ, ka sanin la woilu kan ka jiri bɛɛ latunun. Gbeleke woilu ri kɛ tabali madoninfenilu ri. ");
INSERT INTO msc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Muran mɛnilu ri bila tabali kan, ai ye woilu ladan sanin jɛrɛwolo la. Wo doilu ri kɛ ikomin pileti ni kalamailu ni jilafɛilu ni daailu. N sarakalaselailu ri rɛsɛnji kɛ muran woilu kɔndɔ ka a labɔn ka a kɛ niilifen di. ");
INSERT INTO msc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Saraka buru ri bila tabali ɲin kan. Saraka buru ka kan ka kɛ n ɲakɔrɔ ye tuma bɛɛ.» ");
INSERT INTO msc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Ai ye fitinasiifen ladan sanin jɛrɛwolo gbasinin dɔ. A sen ni a kala ye kɛ fen kelen di, a ni a fitinasii daaninilu ni a kuruilu ni a fɛrɛn bisikilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Bolon wɔɔrɔ ri bɔ a kala ma. Bolon sawa ri kɛ bolokinin fɛ, bolon sawa ri kɛ bolomaran fɛ. ");
INSERT INTO msc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ai ye daani sawa ladan bolon kelen kelenna bɛɛ la, ka woilu kɛ amande jiriden munuɲa ri, bɛɛ ni a kuruilu, bɛɛ ni a fɛrɛnilu. ");
INSERT INTO msc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ai ye daani naanin nadan fitinasiifen kala la, ka woilu fanan kɛ amande jiriden munuɲa ri, bɛɛ ni a kuruilu, bɛɛ ni a fɛrɛnilu. ");
INSERT INTO msc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Bolon fila fila ye farala kala la yɔrɔ sawa mɛnilu rɔ, ai ye kuru kelen nadan kala la yɔrɔ woilu kelen kelenna bɛɛ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Fitinasiifen ni a kuruilu ni a bolonilu bɛɛ ri i ladan sanin jɛrɛwolo gbasinin dɔ. Wo bɛɛ ye kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Ai ye fitina wɔrɔnwula ladan ka woilu sii fitinasiifen kan, sa ii ri a ɲɛfɛla layelen. ");
INSERT INTO msc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ai ye fitina rabɔlanilu ni buurigbɛ kɛ fenilu ladan sanin jɛrɛwolo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Fitinasiifen ni a muranilu bɛɛ ye ladan sanin jɛrɛwolo kilo bisawa la. ");
INSERT INTO msc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Musa, i ye a kɛ koɲuma. I ye baara ɲin bɛɛ kɛ ka a bɛn sawura ma, mɛn ye yirakala i la koyinkɛ kan yan.» ");
INSERT INTO msc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Ai ye n daa makɛ faaninbon nadan faanin jan tan na. Faanin woilu ye kɛ faaningbɛ ɲuma ri, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ye mɛn na. Mɛn kusan faanin sɔɔla kosɛbɛ, wo ye serubɛn sawurailu ta ii kan. ");
INSERT INTO msc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Faanin tan woilu bɛɛ ye kanya. Ii janya ye kɛ nunkan ɲa muwan ni seyin di. Ii kɔndɔ ye kɛ nunkan ɲa naanin di. ");
INSERT INTO msc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ai ye faanin loolu kara i ɲɔɔn na, ka a tɔ loolu fanan kara i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Faanin loolu mɛn karani i ɲɔɔn na, ai ye tonilu bila faanin looluna wo dagbolo la. Ai ye wo ɲɔɔn kɛ faanin tɔ loolu fanan na, mɛnilu karani i ɲɔɔn na. Ai ye ton woilu ladan kari buleman dɔ, ");
INSERT INTO msc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ka ton biloolu biloolu bila faanin fila wo dagbolo la, ka ii ɲa bɛn i ɲɔɔn ma. ");
INSERT INTO msc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ai ye fendamirafen saninnaman biloolu ladan, ka woilu kelen kelenna bɛɛ don ton fila fila rɔ ka faanin fila woilu tuun i ɲɔɔn na. Wo rɔ, faaninbon muumɛ ri tuun i ɲɔɔn na ka kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Ai ye faanin jan tan ni kelen nadan baa si la, ka ii kɛ faaninbon kunnabirin di. ");
INSERT INTO msc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Faanin tan ni kelen woilu bɛɛ ye kanya. Ii janya ye kɛ nunkan ɲa bisawa ri. Ii kɔndɔ ye kɛ nunkan ɲa naanin di. ");
INSERT INTO msc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ai ye faanin loolu kara i ɲɔɔn na, ka faanin tɔ wɔɔrɔ kara i ɲɔɔn na. Faanin wɔɔrɔna ye rakunbɛn fila ri kunnabirin wo ɲɛfɛla rɔ. ");
INSERT INTO msc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Faanin loolu mɛnilu karani i ɲɔɔn na, ai ye ton biloolu bila faanin wo looluna dagbolo la. Faanin tɔ wɔɔrɔ mɛnilu fanan karani i ɲɔɔn na, ai ye ton biloolu bila wo wɔɔrɔna dagbolo la. ");
INSERT INTO msc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ai ye fendamirafen sulanɛɛlaman biloolu ladan, ka woilu don faaninilu tonilu rɔ. Wo rɔ, faaninilu ri tuun i ɲɔɔn na ka kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Faanin tan ni kelen wo janya ri tamin bon janya kan. Faanin kelen talantɛ mɛn di to, ai ye a to wo ye jii bon kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Faanin tan ni kelen wo bonya ri tamin bon bonya kan fanan. Faanin nunkan ɲa kelen di to faanin fan fila bɛɛ fɛ. Ai ye a to wo ye jii bon fan fila bɛɛ fɛ ka a bɛɛ datuun. ");
INSERT INTO msc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Ai ye faaninbon kunnabirin nadan saaji gboloilu la, mɛnilu ra wulen, ka kunnabirin gbɛrɛ fanan nadan gbolo kolonin ɲumailu su gbɛrɛ la. Kunnabirin filana wo ri la saaji gbolo ta kan ka to a san fɛ. ");
INSERT INTO msc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Ai ye kasiya jiriilu ta ka faaninbon damira jiriilu ladan, mɛnilu ri lalɔ ka faaninbon mira. ");
INSERT INTO msc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Woilu kelen kelenna bɛɛ janya ye kɛ nunkan ɲa tan di. Ii bonya ye kɛ nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ai ye tɛmala jiri fila bila jiri woilu tɛma, ka tɛmala jiri woilu ɲabɛn i ɲɔɔn ma. Faaninbon damira jiriilu bɛɛ ye ladan wo ɲa. ");
INSERT INTO msc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","19","Faaninbon damira jiri muwan di lalɔ faaninbon tele kankan bolokinin dɔ. Ai ye woilu ladan, ka siifenju wodigbɛlaman binaanin fanan nadan, mɛnilu bilatɔ damira jiri woilu ju kɔrɔ, damira jiri kelen siifenju fila, baa sen fila mɛnilu ye damira jiriilu bɛɛ ma, woilu bɛɛ ye don siifenju rɔ, sen kelen siifenju kelen. ");
INSERT INTO msc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Faaninbon damira jiri muwan di lalɔ faaninbon tele kankan bolomaran dɔ fanan. Ai ye woilu ladan, ka siifenju wodigbɛlaman binaanin fanan nadan, jiri kelen siifenju fila. ");
INSERT INTO msc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Faaninbon damira jiri wɔɔrɔ ri lalɔ faaninbon telebe rɔ, bon kɔ ma kɔnin. Ai ye woilu ladan, ");
INSERT INTO msc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ka jiri fila fanan nadan, mɛnilu ri lalɔ bon kɔ ma ka kɛ faaninbon tonkonilu ri. ");
INSERT INTO msc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Tonkon jiri fila ɲinilu bɛɛ ye ladan jiri fila fila la, mɛnilu tansanni duu ma ka bɛn i ɲɔɔn ma san fɛ. Jiri fila kunilu ri mira i ɲɔɔn na koyina kelen na. Ai ye tonkon jiri fila bɛɛ ladan ten. ");
INSERT INTO msc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Wo rɔ, faaninbon damira jiri seyin kɛtɔ lalɔla bon kɔfɛ la muumɛ rɔ. Siifenju wodigbɛlaman tan ni wɔɔrɔ kɛtɔ bilala woilu kɔrɔ, jiri kelen siifenju fila. ");
INSERT INTO msc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Ai ye gbeleke ladan kasiya jiri rɔ, mɛnilu ri kankan faaninbon damira jiriilu kan ka woilu ramira. Gbeleke loolu ri kankan faaninbon fan kelen damira jiriilu kan. ");
INSERT INTO msc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Gbeleke loolu ri kankan faaninbon fan do damira jiriilu kan. Gbeleke loolu fanan di kankan faaninbon kɔfɛ la damira jiriilu kan, bon telebe fan fɛ kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kankan gbeleke mɛnilu ri kɛ gbeleke loolu loolu woilu tɛma ta ri, ai ye woilu ladan sa ii ri bɔ faaninbon fan kelen tonkon do la ka wa se fan wo tonkon do ma. Ii ri don koyina saninnamanilu rɔ damira jiriilu talantɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ai ye sanin la faaninbon damira jiriilu kan ka jiri bɛɛ latunun, ka sanin la gbeleke kankantailu fanan kan ka jiri bɛɛ latunun. Ai ye koyina saninnamanilu ladan ka woilu kɛ faaninbon damira jiriilu la. Gbeleke kankantailu ri don woilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Nba, Musa, n ka mɛn yiraka i la koyinkɛ kan yan, i ye n na faaninbon lɔ ka a bɛn wo ma. ");
INSERT INTO msc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Ai ye bon tatɛɛfaanin nadan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Mɔɔ mɛn kusan faanin sɔɔla kosɛbɛ, wo ri serubɛn sawurailu ta a kan. ");
INSERT INTO msc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ai ye tatɛɛfaanin dun samasen naanin nadan kasiya jiri la, ka sanin la woilu kan ka jiri bɛɛ latunun. Ai ye sɔɔlan saninnamanilu kɛ samasen woilu la, ka samasen sii siifenju wodigbɛlaman naanin kan, samasen kelen siifenju kelen. Ai ye tatɛɛfaanin dun sɔɔlan woilu la. ");
INSERT INTO msc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ai ye tatɛɛfaanin wo dun samasenilu la fendamirafenilu kɔrɔ, ka teriya tɔɔmasere kankira sii faanin kɔfɛ. Faanin wo ri kɛ yɔrɔ sɛniman ni yɔrɔ sɛniman fisamantɛ dan fara bɔ ri. ");
INSERT INTO msc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ai ye julumun kafari dalatuun sii teriya tɔɔmasere kankira kan yɔrɔ sɛniman fisamantɛ kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ai ye tabali sii tatɛɛfaanin ɲɛfɛ faaninbon tele kankan bolomaran fan fɛ, ka fitinasiifen lɔ faaninbon tele kankan bolokinin fan fɛ ka a ɲabɛn tabali la. ");
INSERT INTO msc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Faanin mɛn di dun faaninbon donda la, ai ye wo ladan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Mɛn kusan faanin sɔɔla, wo ye a sɔɔ ka a ɲa. ");
INSERT INTO msc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ai ye kasiya jiri loolu ladan, ka sanin la woilu kan ka jiri bɛɛ latunun. Ai ye siifenju sulanɛɛlaman loolu ladan, jiri kelen siifenju kelen. Ai ye sɔɔlan saninnamanilu kɛ jiriilu la, ka donda faanin dun woilu la.» ");
INSERT INTO msc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Ai ye saraka janin diya kelen nadan kasiya jiri rɔ, ka a lɔ kɛ nunkan ɲa sawa ri. A fan naanin bɛɛ ye kanya, ka a bonya ni a janya bɛɛ kɛ nunkan ɲa loolu ri. ");
INSERT INTO msc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ai ye saraka janin diya tonkon kelen kelenna bɛɛ ladan ka ii kɛ kolofen kere la munuɲa ri. Ai ye sulanɛɛ la saraka janin diya yɔrɔ bɛɛ kan, ka a jiri bɛɛ latunun. ");
INSERT INTO msc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ai ye buurigbɛ kɛ muranilu ladan, a ni buurigbɛ tafenilu ni jeli kɛ muranilu ni sobo sɔɔlanilu ni takisɛ kɛ fenilu. Ai ye saraka janin diya muran woilu bɛɛ ladan sulanɛɛlaman na. ");
INSERT INTO msc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ai ye sansan sulanɛɛlaman nadan, ka koyina sulanɛɛlaman kelen kelen nadan a tonkon naanin na. ");
INSERT INTO msc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ai ye sansan sulanɛɛlaman wo la dagbolo kɔrɔ saraka janin diya kɔndɔ, sa a ri bɔ saraka janin diya ju kɔrɔ yɔrɔ ka se a lɔ tɛmala rɔ. ");
INSERT INTO msc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ai ye gbelekeilu rabɛn kasiya jiri rɔ saraka janin diya madonni kanma, ka sulanɛɛ la woilu yɔrɔ bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ai wa kɛ saraka janin diya madonnila, ai ri gbeleke woilu don koyina sulanɛɛlamanilu rɔ saraka janin diya fan fila bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ai ye saraka janin diya lɔ jiri fɛrɛnilu la ka a kɔndɔ rakolon to. Ii ye a lɔ ikomin n ka a yiraka i la ɲa mɛn ma ka i to koyinkɛ kan yan.» ");
INSERT INTO msc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Awa, ai ye n daa makɛ faaninbon naminin faaningbɛ ɲuma le la ka lukɔndɔla labɔ. Faaninbon tele kankan bolokinin fan fɛ, faanin janya ri kɛ nunkan ɲa kɛmɛ ri. ");
INSERT INTO msc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Faanin woilu ri damira samasen muwan bolo, mɛnilu siini siifenju sulanɛɛlaman muwan kan. Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu ye kɛ samasenilu la. ");
INSERT INTO msc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Faaninbon tele kankan bolomaran fan fanan ye rabɛn wo ɲa kelen ma. A laminin faaninilu janya ye kɛ nunkan ɲa kɛmɛ ri. Faanin woilu ri damira samasen muwan bolo, mɛnilu kelen kelenna bɛɛ siini a siifenju sulanɛɛlaman kan. Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu ye kɛ samasenilu la. ");
INSERT INTO msc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Faaninbon telebe fan fɛ, faanin janya ye kɛ nunkan ɲa biloolu ri. Faanin woilu ri damira samasen tan bolo, mɛnilu kelen kelenna bɛɛ siini a siifenju kan. ");
INSERT INTO msc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Faaninbon telebɔ fan fɛ, faanin janya ye kɛ nunkan ɲa biloolu ri. ");
INSERT INTO msc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Lukɔndɔla donda ri kɛ fan wo fɛ. Donda fan fila bɛɛ fɛ, faaninilu janya ri kɛ nunkan ɲa tan ni loolu ri. Faanin woilu ri damira samasen sawa sawa bolo, mɛnilu kelen kelenna bɛɛ siini a siifenju kan. ");
INSERT INTO msc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Faanin mɛn di bila lu donda jɛrɛ la, wo janya ye kɛ nunkan ɲa muwan di. Mɛn kusan faanin sɔɔ la, wo ye faanin wo rabɛn faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Faanin wo ri damira samasen naanin bolo, mɛnilu kelen kelenna bɛɛ siini a siifenju kan. ");
INSERT INTO msc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu ye kɛ lukɔndɔla laminin samasenilu bɛɛ la. Woilu kelen kelenna bɛɛ ye sii a siifenju sulanɛɛlaman kan. ");
INSERT INTO msc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Lukɔndɔla janya ye kɛ nunkan ɲa kɛmɛ ri. A bonya ye kɛ nunkan ɲa biloolu ri. A laminin faaninilu lɔ ye kɛ nunkan ɲa loolu ri. Woilu ye ladan faaningbɛ ɲuma la. Samasen siifenju ye dan sulanɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Faaninbon muranilu bɛɛ ye ladan sulanɛɛ la. Faaninbon ni a laminin faaninilu ri sidi bɔlɔ mɛnilu la duu ma, woilu fanan ye kɛ sulanɛɛ ri.» ");
INSERT INTO msc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«I ye Isirayɛlikailu jamari ko ii ye na olibiye tulu ɲuma ɲuma ri, sa fitinailu ri se lamɛlɛnna waati bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Haruna ni a dencɛilu ye fitinasiifen sii n daa makɛ faaninbon kɔndɔ. Ii ri a sii tatɛɛfaanin ɲɛfɛ, teriya tɔɔmasere kankira siini mɛn kɔfɛ kɔnin. Fitinailu ye mɛlɛn n ɲakɔrɔ ye lon lon ka bɔ wura fɛ fɔɔ sɔɔma da la. Sariya le wo ri, Isirayɛlikailu ka kan ka mɛn nataama haan ka wa kadawu.» ");
INSERT INTO msc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Alla ka a fɔ ko: «Musa, i ye i kɔrɔcɛ Haruna kili ko a ye na, a ni a dencɛilu Nadabu ni Abihu ni Elasari ni Itamari. I ri ii bɔ Isirayɛlikailu rɔ ka ii bila a dan na, sa ii ri kɛ n sarakalaselailu ri ka wo baara kɛ n yɛ. ");
INSERT INTO msc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ai ri faanin ɲuma ɲuma kara i kɔrɔcɛ Haruna yɛ, mɛn di bonya di a ma. Faanin wo ri kɛ fen sɛniman di. ");
INSERT INTO msc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Mɛnilu kusan karalila kosɛbɛ, n ka wo famunyali di mɛnilu ma kɔnin, i ye woilu kili. I ye a fɔ ii yɛ ko ii ye Haruna la faaninilu kara, a ri mɛnilu bila a kan na a lasii lon. Wo kɔ rɔ, a ri woilu bila a kan na ka n saraka baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ii ye sisirɔ bɔrɔni ni kɔkanbila durukini kara, a ni durukiba ni wo duruki kɔrɔbila sɔɔni ni jalamu ni tɛsidilan. Ii ye faanin sɛniman woilu kara i kɔrɔcɛ Haruna ni a dencɛilu yɛ, baa woilu ri n na sarakalasela baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ii ye faanin woilu kara faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni sanin na. ");
INSERT INTO msc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Mɛnilu kusan bololabaara kɛla kosɛbɛ, woilu ye kɔkanbila durukini ladan. Ii ye a ladan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni sanin na. ");
INSERT INTO msc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kanbankun julu kelen kelen ye kɛ kɔkanbila durukini tonkon fila la, sa a ɲɛfɛla yɔrɔ ni a kɔfɛla yɔrɔ ri se tuunna i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ii ye tɛsidilan sɔɔni ɲuma kɛ kɔkanbila durukini la. Tɛsidilan ni kɔkanbila durukini ri kɛ fen kelen di. Ii baaraɲa fanan ye kanya. Ii ye tɛsidilan nadan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni sanin na. ");
INSERT INTO msc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","10","Kabakuru mɛn tɔɔ ko onikisi, ai ye wo kabakurun fila ta ka Isirayɛli dencɛilu tɔɔ sɛbɛ woilu kan ka bɛn ii si kasabi ma. Ai ye tɔɔ wɔɔrɔ sɛbɛ kabakurun fɔlɔ kan, ka a tɔ wɔɔrɔ sɛbɛ kabakurun filana kan. ");
INSERT INTO msc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ai ye Isirayɛli dencɛilu tɔɔ sɛbɛ kabakurun fila woilu kan ikomin sɛbɛli ye kɛla kabakurun kan ɲa mɛn ma ka a kɛ ɲanɔɔ di. Wo kɔ rɔ, ai ye kabakurun fila wo don fendamirafen saninnamanilu rɔ, kabakurun kelen fendamirafen kelen. ");
INSERT INTO msc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Wo wa kɛ, ai ye ii bila kɔkanbila durukini kanbankun julu fila la. Kabakurun woilu ri kɛ hankili bila fenilu ri Isirayɛlikailu la ko rɔ. Haruna wa faanin wo don, Isirayɛlikailu tɔɔ ri kɛ a kanbankun kan ka kɛ hankili bila fen di nde Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ai ye fendamirafen saninnaman fila ladan, kabakurun fila wo ri bila mɛnilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Wo wa kɛ, ai ye julu saninnaman fila ladan sanin jɛrɛwolo la. Ai ye woilu mɔrɔmɔrɔ ikomin julukisɛ ye mɔrɔmɔrɔla ɲa mɛn ma, ka ban ka ii nara kabakurun woilu fendamirafenilu la.» ");
INSERT INTO msc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Mɛn kusan bololabaara kɛla kosɛbɛ, wo ye ko latɛɛ sisirɔ bɔrɔni ladan. A ye a ladan sanin na, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni faaningbɛ ɲuma la ikomin kɔkanbila durukini. ");
INSERT INTO msc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","A wa lakadi ka a la ɲɔɔn kan a fan naanin bɛɛ ri kanya. A janya ni a bonya bɛɛ ri kɛ sinbiri ɲa kelen di. ");
INSERT INTO msc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","A ye a masidi kabakurun sankɔgbɛlɛnilu la, ka woilu nara a la safa naanin na. A safa fɔlɔ ye kɛ saridiwan kuru ri, a ni topase kuru ni emerada kuru. ");
INSERT INTO msc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","A safa filana ye kɛ karibunkili kuru ri, a ni safiri kuru ni jaman kuru. ");
INSERT INTO msc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","A safa sawana ye kɛ jasinti kuru ri, a ni akate kuru ni ametisi kuru. ");
INSERT INTO msc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","A safa naaninna ye kɛ kirisaliti kuru ri, a ni onikisi kuru ni jasipe kuru. Kuru woilu bɛɛ ye don fendamirafen saninnamanilu rɔ, kuru kelen fendamirafen kelen. ");
INSERT INTO msc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kabakuru bɛɛ ladɛnnin ye kɛ tan ni fila ri, ka a bɛn Isirayɛlikailu la kabilailu jate ma. Ii tɔɔilu ye sɛbɛ nɛɛ la kabakurunilu kan, kabakurun kelen tɔɔ kelen. Tɔɔilu ye sɛbɛ ikomin tɔɔ ye sɛbɛla ɲa mɛn ma ɲanɔɔ kan. ");
INSERT INTO msc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Ai ye julu saninnaman fila ladan, mɛnilu ri bila sisirɔ bɔrɔni la. Ai ye ii ladan sanin jɛrɛwolo la, ka ii mɔrɔmɔrɔ ikomin julukisɛ ye mɔrɔmɔrɔla ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ai ye koyina saninnaman fila ladan, ka ii sidi sisirɔ bɔrɔni sanfɛ tonkon fila la. ");
INSERT INTO msc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ai ye julu saninnaman woilu kunilu don koyina kelen kelenna rɔ sisirɔ bɔrɔni tonkon fila la, ");
INSERT INTO msc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ka ii kun gbɛrɛilu don fendamirafenilu la, ni a ye kanbankun julu fila la kɔkanbila durukini ɲɛfɛla rɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ai ye koyina saninnaman fila gbɛrɛ ladan ka woilu sidi sisirɔ bɔrɔni kɔfɛ yɔrɔ la a duuma fan tonkon fila la. ");
INSERT INTO msc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ai ye koyina saninnaman fila gbɛrɛ ladan ka woilu sidi kɔkanbila durukini kanbankun julu fila ɲɛfɛla rɔ. Ai ye ii sidi julu woilu ju kɔrɔ kara diya dafɛ tɛsidilan kun dɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ai ye sisirɔ bɔrɔni koyinailu ni kɔkanbila durukini koyinailu bila i ɲɔɔn ma juluɲala bule la, sa sisirɔ bɔrɔni ri to a nɔ rɔ kɔkanbila durukini kan tɛsidilan kun dɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Haruna wa kɛ donna yɔrɔ sɛniman kɔndɔ tuma tuma, ko latɛɛ sisirɔ bɔrɔni ri kɛ a sɔn kan. Isirayɛli dencɛilu tɔɔ sɛbɛni kuruilu kan bɔrɔni wo kan. Tɔɔ woilu ri kɛ hankilibilafen di nde Allabatala ɲakɔrɔ kadawu. ");
INSERT INTO msc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","I ye Urima ni Tumima bila sisirɔ bɔrɔni kɔndɔ, sa ii ri kɛ Haruna jusu kan a don tuma Allabatala ɲakɔrɔ yɔrɔ sɛniman kɔndɔ. Urima ni Tumima ye n kiti ɲinin fenilu le ri Isirayɛlikailu bolo. Haruna wa na a lɔ Allabatala ɲakɔrɔ tuma tuma yɔrɔ sɛniman kɔndɔ, fo woilu ye kɛ a sɔn kan.» ");
INSERT INTO msc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Awa, Haruna ri kɔkanbila durukini bila durukiba mɛn kan, ai ye wo bɛɛ ladan faanin buleman na. ");
INSERT INTO msc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ai ye kun don woo bɔ a tɛmala rɔ, ka faanin gbiliman kara woo laminin dɔ ka a kɛ dagbolo ri, sa durukiba kana fara. ");
INSERT INTO msc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ai ye kerenati jiridenilu sawura ta kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la durukiba sen kɔrɔlailu dagbolo muumɛ kan. Ai ye talan dennin saninnamanilu bila bila jiridenilu sawura tɛma. ");
INSERT INTO msc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Talan dennin saninnaman kelen ye tuun kerenati jiriden sawura kelen kelenna bɛɛ la dagbolo muumɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haruna wa wuli n na sarakalasela baara kɛla, fo a ye durukiba wo bila a kan na. A don tuma ni a bɔ tuma yɔrɔ sɛniman kɔndɔ nde Allabatala ɲakɔrɔ, talan mɛnilu ye durukiba dagbolo la, woilu mankan di bɔ. Wo ɲa ma, Haruna ti nala faala. ");
INSERT INTO msc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Ai ye saninfɛdɛ do ladan sanin jɛrɛwolo la, ka sɛbɛli do kɛ a ka a fɔ ko: ‹A bilani a dan na Allabatala yɛ.› Ai ye wo sɛbɛ ikomin sɛbɛli ye kɛla tɔɔ ɲanɔɔ kan ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","I ye saninfɛdɛ wo sidi bitiran ɲɛfɛla rɔ julu buleman na. ");
INSERT INTO msc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Wo le rɔ, Haruna wa don yɔrɔ sɛniman kɔndɔ tuma tuma nde Allabatala ɲakɔrɔ, saninfɛdɛ wo ri kɛ a tin na. Wo ri a yiraka ko Haruna ye a lɔla Isirayɛlikailu la kojuuilu kunko la, ii ka mɛnilu kɛ ii la sarakailu bɔ tuma. Ikomin saninfɛdɛ ni a sɛbɛli wo ri kɛ Haruna tin na, n di sɔn Isirayɛlikailu la sarakailu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Ai ye duruki kɔrɔbila ni bitiran rabɛn faaningbɛ ɲuma la. Mɛn kusan faanin sɔɔla, wo ye tɛsidilan dabɛn ka a sɔɔ ka a ɲa. ");
INSERT INTO msc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ai ye duruki kɔrɔbila ni tɛsidilan ni fula ɲumailu ladan Haruna dencɛilu yɛ, mɛnilu ri bonya di ii ma. ");
INSERT INTO msc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","I ye faanin woilu bila i kɔrɔcɛ Haruna ni a dencɛilu kan na ka tulu mun ii kun na, ka ii lasii n na sarakalasela baara la. I ri ii bila a dan na ten sa ii ri n na sarakalasela baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ai ye kurusi kurunniilu ladan ii yɛ faaningbɛ la. Kurusi woilu ye bɔ ii soro rɔ ka na dan ii woro rɔ. Ii ri woilu don ii la durukiilu kɔrɔ sa ii ri ii jɛrɛ sutura. ");
INSERT INTO msc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haruna ni a dencɛilu wa don n na faaninbon kɔndɔ, wala ii wa ii madon saraka janin diya la ka baara kɛ yɔrɔ sɛniman kɔndɔ, fo ii ye faanin woilu bila ii kan na. Ni wo tɛ, ii ri jalaki ka sa. Sariya le wo ri, mɛn ka kan ka latelen Haruna ni a bɔnsɔnilu bolo kadawu!» ");
INSERT INTO msc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Allabatala ka a fɔ Musa yɛ ko: «I ka kan ka Haruna ni a dencɛilu bila a dan na ɲa mɛn ma n na sarakalasela baara kɛ kanma, ale le ɲin. I ye tora bulan kelen mira, a ni saaji fila, fɛɛ tɛ mɛnilu la. ");
INSERT INTO msc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","I ye farinin muun ɲuma ta, ka buru labɛn a la a ni katɔ ni dɛba, lɛbɛn ti mɛn na, ka tulu mun a ma. ");
INSERT INTO msc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","I ye woilu bɛɛ bila see kelen kɔndɔ. I wa na tora ni saaji fila ri ii kannatɛɛ diya, i ye na see wo fanan di. ");
INSERT INTO msc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«I ye Haruna ni a dencɛilu lana n na faaninbon da la, ka ii ko ji la. ");
INSERT INTO msc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Wo wa kɛ, i ye duruki kɔrɔbila ni durukiba bila Haruna kan na, a ni kɔkanbila durukini ni sisirɔ bɔrɔni, ka ban ka kɔkanbila durukini sidi a ma tɛsidilan na, jesedanna kusan ka mɛn nadan. ");
INSERT INTO msc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","I ye bitiran kɛ Haruna kun na, ka kuntiiya tɔɔmasere sɛniman sidi bitiran kan. ");
INSERT INTO msc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","I ye suwandili tulu mun a kun na ka a bila a dan na n na baara kanma. ");
INSERT INTO msc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Wo wa kɛ, i ri Haruna dencɛilu lana ka duruki kɔrɔbila bila ii kan na. ");
INSERT INTO msc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","I ye ii tɛsidi tɛsidilanilu la, ka ban ka bitiran kɛ ii kun na. N na sarakalasela baara ri kɛ Haruna ni a bɔnsɔnilu ta ri kadawu. Sariya rabilabali le wo ri. Wo wa kɛ, i ri Haruna ni a dencɛilu bila a dan na baara wo kanma. ");
INSERT INTO msc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«I ye tora lana n na faaninbon da la. Haruna ni a dencɛilu ye ii boloilu la a kun kan. ");
INSERT INTO msc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","I ye tora kannatɛɛ nde Allabatala ɲakɔrɔ n na faaninbon da la ye. ");
INSERT INTO msc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","I ye i bolo koyini su tora jeli rɔ ka a mun saraka janin diya tonkon kereilu la, ka a jeli tɔilu bɛɛ labɔn saraka janin diya ju fɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Wo wa kɛ, ken mɛn ye tora kɔnɔ rɔ, i ye wo bɛɛ ta, a ni biɲɛ fan ɲuma ni kɔrɔkudu fila ni woilu kenilu bɛɛ. I ye wo bɛɛ la saraka janin diya kan ka ii janin ka kɛ buuri ri. ");
INSERT INTO msc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kɔni i ye tora sobo ni a gbolo ni a noo bɛɛ janin ta rɔ jama daa makɛ diya kɔfɛ. Wo le ri kɛ saraka ri, mɛn di n sarakalaselailu la julumunilu labe. ");
INSERT INTO msc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«I ye saaji fila wo kelen mira. Haruna ni a dencɛilu ye ii bolo la wo kun kan. ");
INSERT INTO msc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","I ye saaji kannatɛɛ ka a jeli ta ka a sadisadi saraka janin diya fan bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","I ye saaji boso ka a tɛɛtɛɛ. I ye a kɔnɔrɔfenilu ni a senilu rako, ka woilu bila sobo kurunkurun ni kunkolo kan. ");
INSERT INTO msc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","I ye saaji bu bɛɛ janin saraka janin diya kan saraka janinta la. Saraka janinta le a ri, mɛn di bɔ nde Allabatala yɛ ka a janin ta la. Wo suma duman n yɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Wo wa kɛ, i ye saaji filana ta. Haruna ni a dencɛilu ye ii boloilu la a kun na. ");
INSERT INTO msc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","I ye a kannatɛɛ ka a jeli do ta ka wo mun Haruna ni a dencɛilu bolokinin tolo nun na, ka do fanan mun ii bolokinin bolo kunkuruba kan, a ni ii bolokinin sen kunkuruba. I ye jeli tɔ sadisadi saraka janin diya fan bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Jeli mɛn sadisadini saraka janin diya kan, i ye wo do ta, ka suwandili tulu do fanan ta ka woilu sadisadi Haruna ni a dencɛilu kan, a ni ii la faaninilu bɛɛ kan. Wo le rɔ, Haruna ni a dencɛilu ni ii la faaninilu ri bila a dan na ka kɛ fen sɛniman di. ");
INSERT INTO msc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Saaji filana wo ye saraka ri, mɛn ye bɔla ka Haruna ni a dencɛilu bila ii dan na n na baara kanma. Wo rɔ, i ye saaji ken ta, a ni a kɔ ni a jusu fan ɲuma ni a kɔrɔkudu fila bɛɛ ni ken mɛn ye woilu lamininna ni ken mɛn ye kɔnɔrɔ nooilu laminin bɛɛ rɔ. I ye bolokininma woro fanan ta. ");
INSERT INTO msc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","I ye buru fununbali kelen ni buru kelen mɛn dabɛnni tulu la ni burunin kelen ta see kɔndɔ, mɛn bilani nde Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","I ye fen woilu bɛɛ don Haruna ni a dencɛilu bolo, ko ii ye woilu layɛlɛ nde Allabatala ɲakɔrɔ ka a yiraka ko ii ye a bɛɛ dila n ma. ");
INSERT INTO msc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Wo wa kɛ, i ye fen woilu bɔ ii bolo ka woilu bila saraka janin diya kan ka ii janin. Sarakailu le ii ri, mɛnilu ri bɔ nde Allabatala yɛ ka janin ta la. Wo suma duman n yɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«I ye Haruna lasii saaji sisi layɛlɛ Allabatala ɲakɔrɔ, ka a yiraka ko i ye a bɛɛ dila nde Allabatala ma. Sisi wo ye ile niiyɔrɔ le ri. ");
INSERT INTO msc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","N sarakalasela lasii saaji sisi ni a woro mɛnilu kɔrɔtara n ɲakɔrɔ, ko woilu bilani a dan na ka kɛ n ta ri. Ko Haruna ni a dencɛilu niiyɔrɔ le woilu ri. ");
INSERT INTO msc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Isirayɛlikailu wa jususuma saraka bɔ tuma tuma, ii ye niimafen wo sisi ni a woro di nde Allabatala ma. Woilu ri kɛ Haruna ni a bɔnsɔnilu niiyɔrɔ ri. ");
INSERT INTO msc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Haruna la faanin sɛniman di kɛ a bɔnsɔnilu ta ri a sani kɔ rɔ. Suwandili tulu muntɔ kɛla a nɔrɔbila kan lon mɛn ka wo bila a dan na n na baara kɛ kanma, a nɔrɔbila wo ri Haruna la faanin wo bila a kan na. ");
INSERT INTO msc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Haruna dencɛ mɛn wa bila a nɔ rɔ n na sarakalasela baara la, wo wa don n na faaninbon na ka n na sarakalasela baara damira yɔrɔ sɛniman kɔndɔ, a ri faanin woilu bila a kan na tele wɔrɔnwula kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Nba, saaji mɛn kɛra saraka ri ka Haruna ni a dencɛilu sii n na sarakalasela baara la, i ye wo sobo ta ka a tibi yɔrɔ sɛniman do rɔ. ");
INSERT INTO msc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Haruna ni a dencɛilu ri sobo wo dɔɔn, a ni buru mɛnilu ye see kɔndɔ. Ii ye woilu dɔɔn n na faaninbon da la. ");
INSERT INTO msc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Saraka woilu bɔra ka ii la julumunilu labe ka ii bila ii dan na ii lasii tuma n na sarakalasela baara la. Ii ye woilu dɔɔn. Kɔni mɔɔ gbɛrɛ si kana fen woilu dɔɔn, baa fen woilu sɛniman. ");
INSERT INTO msc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ni sobo wo tɔ siira haan sɔɔma da la, wala buru tɔ, wo ye janin ka kɛ buuri ri. A kana a dɔɔn, baa a sɛniman. ");
INSERT INTO msc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«N ye mɛnilu fɔla i yɛ, i ye woilu bɛɛ kɛ Haruna ni a dencɛilu yɛ ka ii bila n na sarakalasela baara rɔ. I ye wo bɛɛ kɛ lon lon tele wɔrɔnwula kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","I ye tora kelen bɔ lon lon ka kɛ sɔlɔnali saraka ri. I ri saraka janin diya sɛninya wo ɲa. Wo wa kɛ, i ri tulu mun a kan ka a bila a dan na ka a kɛ n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","I ye wo bɛɛ kɛ ten lon lon tele wɔrɔnwula kɔrɔ. Wo bolo ma, saraka janin diya wo ri kɛ fen sɛniman ba ri. Fen fen wa a maa a la, wo fanan di kɛ fen sɛniman di.» ");
INSERT INTO msc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Ai ye san kelen saa bulan fila bɔ saraka janin diya kan lon lon kadawu. ");
INSERT INTO msc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ai ye saa bulan kelen bɔ sɔɔma, ka kelen bɔ wura fɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ai ye farinin ɲuma kilo sawa ni olibiye susunin tulu litiri kelen ta ka woilu ɲaamin i ɲɔɔn na, ka wo bɔ saa bulan fɛ sɔɔma. Ai ye rɛsɛnji litiri kelen ni tala labɔn, ka wo fanan kɛ saraka ri. ");
INSERT INTO msc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ai ye saa bulan filana bɔ wura fɛ, ka farinin ni olibiye tulu ni rɛsɛnji la a kan ikomin sɔɔma ta. Saraka janinta le a ri, mɛn di bɔ nde Allabatala yɛ ka janin ta la ka kɛ buuri ri. Wo suma duman n yɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ai ni ai bɔnsɔnilu ye saraka janinta woilu bɔ tuma bɛɛ. Ai ye ii bɔ nde Allabatala ɲakɔrɔ kunbɛn faaninbon da la. N kɛtɔ n na jama kunbɛnna ye le ka kuma i yɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","N di Isirayɛlikailu kunbɛn ye le. N nɔɔrɔ ri yɔrɔ wo bila a dan na ka a kɛ n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","N di n na faaninbon ni saraka janin diya bila a dan na ka ii kɛ n ta ri. N di Haruna ni a dencɛilu fanan bila ii dan na n na baara kanma, sa ii ri n na sarakalasela baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","N di n makɛ Isirayɛlikailu tɛma ka kɛ ii Maari ri. ");
INSERT INTO msc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ii ri a lɔn ko nde le ii Maari Allabatala ri, mɛn ka ii labɔ Misiran jamana rɔ sa n di n makɛ ii tɛma. N ye ii Maari Allabatala le ri.» ");
INSERT INTO msc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Ai ye wusulanjanin saraka janin diya ladan kasiya jiri la. ");
INSERT INTO msc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Wo fan naanin bɛɛ ye kanya, ka a janya ni a bonya bɛɛ kɛ nunkan ɲa kelen kelen di. A lɔ ye kɛ nunkan ɲa fila ri. Kere munuɲa ye kɛ a tonkon naanin bɛɛ la, kɔni kereilu ni saraka janin diya bɛɛ ye kɛ fen kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ai ye sanin jɛrɛwolo la a sanfɛ a ni a kɛrɛfɛ naanin yɔrɔ bɛɛ a ni a kereilu bɛɛ kan, ka da kirinkirin bɛɛ kɛ sanin di a fan naanin bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ai ye koyina saninnaman fila ladan da kirinkirin wo kɔrɔ saraka janin diya fan fila fɛ, fan kelen koyina fila. Sarakabɔdiya ta gbelekeilu ri don koyina woilu rɔ, sa saraka janin diya ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ai ye gbelekeilu rabɛn kasiya jiri la ka sanin la ii yɔrɔ bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ai ye saraka janin diya wo sii tatɛɛfaanin ɲɛfɛ. Teriya tɔɔmasere kankira ni a julumun kafari dalatuun ye tatɛɛfaanin wo kɔfɛ. Tuma tuma n kɛtɔ i kunbɛnna yɔrɔ wo le rɔ. ");
INSERT INTO msc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Haruna wa fitinailu rabɛn sɔɔma sɔɔma, a ye wusulan sumaduman janin saraka janin diya wo kan. ");
INSERT INTO msc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","A wa fitinailu lamɛlɛn wura wura, a ye wusulan sumaduman janin ikɔ tuunni. Wusulan ye to janinna wo ɲa ma nde Allabatala ɲakɔrɔ tuma bɛɛ. Ai bɔnsɔnilu bɛɛ ye a kɛ ten haan ka wa kadawu. ");
INSERT INTO msc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ai kana wusulan su gbɛrɛ janin wusulanjanin saraka janin diya kan. Ai kana sarakailu bɔ a kan, mɛnilu ri janin ka kɛ buuri ri. Ai kana suman kɛ saraka ri ka a bɔ a kan. Ai kana rɛsɛnji kɛ saraka ri ka wo labɔn a kan. ");
INSERT INTO msc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","San san, kolofen mɛn bɔni ka a kɛ sɔlɔnali saraka ri, Haruna ye wo jeli ta ka a kɛ saraka janin diya kereilu kan. Haruna ri saraka janin diya sɛninya ten siɲa kelen san san. Ai bɔnsɔnilu ye a kɛ ten haan ka wa kadawu. Sarakabɔdiya wo bilani a dan na ka kɛ nde Allabatala ta ri. A sɛniman ba le.» ");
INSERT INTO msc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Allabatala ka a fɔ Musa yɛ ikɔ tuunni ko: ");
INSERT INTO msc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«I wa tɔɔ sɛbɛli kɛ ka Isirayɛlikailu jate lɔn, ii kelen kelenna bɛɛ ye ii jɛrɛ nii kunka wodi bɔ ka a di nde Allabatala ma, sa tɔrɔya kana ii sɔrɔn tɔɔ sɛbɛli waati la. ");
INSERT INTO msc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mɛnilu tɔɔ wa sɛbɛ, ii kelen kelenna bɛɛ ye wodigbɛ karamun wɔɔrɔ bɔ. Karamun wɔɔrɔ ye Allabatobonba sɛkɛli tala le. Wo ri kɛ niilifen di ka a di nde Allabatala ma. Yɔrɔ sɛniman jateli bɛnni karamun tan ni fila le ma. ");
INSERT INTO msc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Mɔɔ mɛnilu sɔrɔn da san muwan bɔ, i ri woilu ni woilu kɔrɔilu bɛɛ tɔɔ sɛbɛ. Woilu bɛɛ ye niilifen wo di nde Allabatala ma. ");
INSERT INTO msc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ii wa karamun wɔɔrɔ wo di nde Allabatala ma ka kɛ sɔlɔnali fen ii yɛ, nanfulutii kana foyi la a ta kan, bolokolon kana foyi bɔ a ta la. ");
INSERT INTO msc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","I wa sɔlɔnali wodi wo sɔrɔn Isirayɛlikailu la, i ri a kɛ n na faaninbon dabɛnfen di. Wodi wo ri kɛ hankilibilafen di ka nde Allabatala hankili bila a la ko Isirayɛlikailu nii da kunka.» ");
INSERT INTO msc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ai ye koli muran ba sulanɛɛlaman nadan koli kanma, ka a siifenju sulanɛɛlaman fanan nadan. Ai ye a sii kunbɛn faaninbon ni saraka janin diya tɛma, ka ji kɛ a kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haruna ni a dencɛilu ye ii boloilu ni ii senilu mako ji wo la. ");
INSERT INTO msc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","Ii wa kɛ donna kunbɛn faaninbon na tuma mɛn na, ii ye ii boloilu ni ii senilu ko ji woilu la sa ii kana faa. Ka a la wo kan, ii wa kɛ ii madonna saraka janin diya la tuma mɛn na ka saraka janin ta la Allabatala yɛ, ii ye ii boloilu ni ii senilu mako sa ii kana faa. Jamarili le wo ri Haruna ni a bɔnsɔnilu bɛɛ ma haan ka wa kadawu.» ");
INSERT INTO msc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Allabatala ka a fɔ Musa yɛ ikɔ tuunni ko: ");
INSERT INTO msc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","24","«I ye sumadiyalanilu bɛɛ rɔ ɲuma doilu ta. I ye muri latikɔlɔn jilama kilo wɔɔrɔ ta, a ni kanɛli sumaduman kilo sawa, ni sinamɔnɛ sumaduman kilo sawa, ni kase sumaduman kilo wɔɔrɔ. Woilu bɛɛ ka kan ka bɛn yɔrɔ sɛniman na jateli ma. I ye olibiye tulu litiri naanin fanan ta. ");
INSERT INTO msc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Latikɔlɔn nadanna do ye woilu bɛɛ basan ka a kɛ suwandili tulu sɛniman di, mɛn suma duman. Tulu wo ri kɛ fen sɛniman de ri, mɛn ye kɛla fen wala mɔɔ kan ka wo bila a dan na. ");
INSERT INTO msc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","I ye tulu wo ta ka dooni mun kunbɛn faaninbon ni teriya tɔɔmasere kankira kan, ");
INSERT INTO msc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","a ni tabali ni a muran, a ni fitinasiifen ni a muran bɛɛ, a ni wusulanjanin saraka janin diya, ");
INSERT INTO msc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","a ni saraka janinta bɔ diya ni a muran bɛɛ, a ni koli muran ba ni a siifenju fanan. ");
INSERT INTO msc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","I ri fen woilu bila a dan na ten, ka ii kɛ n ta ri fasayi. Ii ri kɛ fen sɛnimanilu ri. Ni fen fen ka a maa woilu la, wo fanan di kɛ fen sɛniman di. ");
INSERT INTO msc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«I ye tulu dooni mun Haruna ni a dencɛilu kan ka ii bila a dan na n na baara kanma. Ii ri n na sarakalasela baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","I ye a fɔ Isirayɛlikailu yɛ ko n na suwandili tulu le ɲin di. Ko a sɛniman haan ka wa kadawu. ");
INSERT INTO msc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mɔɔ si kana a ta ka a fari mamun a la. Mɔɔ si kana fenilu ladan, mɛnilu ri kɛ a su ri. A sɛniman de. Ai ye a jate fen sɛniman di. ");
INSERT INTO msc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mɔɔ mɔɔ wa a ɲɔɔn nadan, wo tii ri gbɛn a la jama tɛma. Mɔɔ mɔɔ wa tulu wo kɛ mɔɔ gbɛrɛ kan, mɛn tɛ n sarakalasela ri, wo tii ri gbɛn a la jama tɛma.» ");
INSERT INTO msc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Allabatala ka a fɔ Musa yɛ ko: «Sumadiyalan mɛnilu tɔɔ ko sitaki ni ɔnkile ni kalibanun, a ni wusulan sumaduman jɛrɛwolo, i ye wo ta ka a bɛɛ rakanya. ");
INSERT INTO msc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Sumaduman nadanna do ye woilu bɛɛ ni kɔɔ basan ka a kɛ wusulan jɛrɛwolo ri, mɛn suma duman. Ai ye a jate fen sɛniman di, mɛn bilani a dan na n na baara kanma. ");
INSERT INTO msc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","I ye wusulan wo do ta ka a rasisi ka a kɛ muun di, ka a bila teriya tɔɔmasere kankira ɲɛfɛ kunbɛn faaninbon kɔndɔ. N ye i kunbɛnna ye le. Ai ye wusulan wo jate fen sɛniman ba ri. ");
INSERT INTO msc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ai kana sumadiyalan woilu ta ka wusulan do ladan ai jɛrɛ yɛ, mɛn ni ɲin bɛɛ ka kan. Ai ye a jate fen sɛniman ba ri, mɛn ye Allabatala ta ri. ");
INSERT INTO msc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mɔɔ mɔɔ wa wusulan wo ɲɔɔn nadan sa a ri sɛwa wo sumaduman dɔ, wo tii ri gbɛn a la jama tɛma.» ");
INSERT INTO msc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«N da Yahuda kabila Uri mamaren Besalɛli, Huri dencɛ kɔnin, suwandi baara ɲin kanma. ");
INSERT INTO msc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","N da n Nii lajii Besalɛli rɔ. Wo rɔ, a hankili duman, a la lɔnnin ka bon. A seni baara su bɛɛ kɛla. ");
INSERT INTO msc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","A senin fen kɛɲimantailu ladanna sanin na, a ni wodigbɛ la, a ni sulanɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","A seni kabakurun kisɛilu lɛsɛla, ka ii bila fendamirafenilu la. A seni jiri fanan lɛsɛla. A kusan baara su bɛɛ kɛla. ");
INSERT INTO msc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","N da Ahisamaki dencɛ Oholiyabu fanan suwandi ka a kɛ Besalɛli dɛmɛnba ri. Oholiyabu ye Daan kabila mɔɔ do le ri. N da famunyali di bololabaarala gbɛrɛilu fanan ma n na baara kanma. Wo rɔ, n ka a fɔ i yɛ ko ai ye fen mɛnilu ladan, ii ri se wo bɛɛ ladanna. ");
INSERT INTO msc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ii ri se n na faaninbon nadanna, a ni teriya tɔɔmasere kankira a ni a julumun kafari dalatuun ni faaninbon muranilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Ii ri se tabali ni a muranilu bɛɛ ladanna, a ni fitinasiifen saninnaman jɛrɛwolo ni a muranilu bɛɛ, a ni wusulanjanin saraka janin diya. ");
INSERT INTO msc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Ii ri se saraka janin diya fanan nadanna, sarakailu ri janin mɛn kan ka kɛ buuri ri. Ii ri saraka janin diya wo muranilu bɛɛ fanan nadan, a ni koli muran ba ni a siifenju. ");
INSERT INTO msc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ii ye faanin kenɲi bailu fanan nadan, n sarakalasela Haruna la faanin sɛnimanilu ni a dencɛilu la faaninilu kɔnin. Haruna ni a dencɛilu ri faanin woilu bila ii kan na ka n na sarakalasela baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ii ri suwandili tulu ladan, a ni wusulan suma duman, mɛn di janin yɔrɔ sɛniman kɔndɔ. Awa, ii ri fen woilu bɛɛ ladan ikomin n ka a ɲafɔ i yɛ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«I ye a fɔ Isirayɛlikailu yɛ ko ii ye Ɲɔɲɔ lonilu bɛɛ bonya, baa Ɲɔɲɔ lon ye tɔɔmasere le ri kadawu ii ni nde tɛma. A ri a yiraka ii la ko Allabatala le nde le ri, mɛn ye ii bilala a dan na ka ii kɛ n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ii ye Ɲɔɲɔ lon bonya, baa lon sɛniman de wo ri ii bolo. Ni mɔɔ mɛn ma sɔn lon wo bonyala fo ka baara do kɛ wo lon, ii ye a labɔ a badenmailu tɛma ka a faa. ");
INSERT INTO msc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ii ye baara kɛ tele wɔɔrɔ kɔrɔ, kɔni tele wɔrɔnwulana le Ɲɔɲɔ lon de ri, mɛn bilani a dan na Allabatala bonya kanma. Mɔɔ mɛn wa baara su su kɛ Ɲɔɲɔ lon kɔndɔ, ii ye wo faa. ");
INSERT INTO msc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ii ni ii bɔnsɔnilu bɛɛ ka kan ka Ɲɔɲɔ lon nabato ka a bonya, baa teriya banbali le kadawu. ");
INSERT INTO msc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ɲɔɲɔ lon ye tɔɔmasere le ri n ni Isirayɛlikailu tɛma kadawu, baa nde Allabatala le ka san ni duu dan tele wɔɔrɔ kɔrɔ, kɔni tele wɔrɔnwulana lon, n ka baara lalɔ ka n dafɔɲɔ.» ");
INSERT INTO msc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Awa, Allabatala banda kumala Musa yɛ Sinayi koyinkɛ kan tuma mɛn na, a ka teriya tɔɔmasere walan kabalaman fila don Musa bolo, Alla jɛrɛ ka sariyailu sɛbɛ mɛnilu kan. ");
INSERT INTO msc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Awa, mɔɔilu ka a yen ko Musa ra mɛn a ma jii ka bɔ koyinkɛ kan, ii ka i ɲɔɔn nadɛn Haruna kanma, ka a fɔ a yɛ ko: «I wuli, i ye batofenilu ladan an yɛ, mɛn di lɔ an ɲɔrɔ! An ma a lɔn mɛn ka Musa sɔrɔn, mɛn ka a lɔ an ɲɔrɔ ka an nabɔ Misiran.» ");
INSERT INTO msc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haruna ka a fɔ ii yɛ ko: «Ai ye wa tololafen saninnamanilu ta, mɛnilu ye ai musoilu ni ai dencɛilu ni ai denmusoilu toloilu la. Ai ye na woilu di n ma.» ");
INSERT INTO msc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mɔɔilu bɛɛ ka ii la tololafen saninnamanilu bɔ ii toloilu la ka na woilu di Haruna ma. ");
INSERT INTO msc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Haruna ka tololafenilu mira, ka ii yelen ka lɛsɛlifen do ta ka nisiden sawura ladan. Mɔɔilu ka a yen tuma mɛn na, ii ka a fɔ ko: «Isirayɛlikailu, an na batofenilu le ɲin di, mɛn ka an nabɔ Misiran.» ");
INSERT INTO msc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Haruna ka wo yen tuma mɛn na, a ka saraka janin diya lɔ nisiden bisiki ɲɛ ka a fɔ ko: «Sini ri kɛ sali ri ka Allabatala bato.» ");
INSERT INTO msc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wo duu sa gbɛ, ii sorira ka saraka janintailu a ni jususuma sarakailu bɔ. Wo kɔ rɔ, ii ka ii sii ka dɔɔnnin kɛ ka ii min, ka ban ka ii lawuli ii lamaa kanma. ");
INSERT INTO msc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Wo rɔ, Allabatala ka a fɔ Musa yɛ ko: «I kaliya, i ye jii koyinkɛ kɔrɔ sisen, baa i la mɔɔilu ra julumun ba kɛ, jama mɛn bɔra Misiran i bolo kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ii ra bɔ sila kan jona, n ka mɛn yiraka ii la. Ii ra nisiden sawura ladan sanin yelenni la, ka ii birin wo kɔrɔ. Ii ra wo bato ka sarakailu bɔ a yɛ ka a fɔ ko: ‹Isirayɛlikailu, an na batofenilu le ɲin di, mɛn ka an nabɔ Misiran.›» ");
INSERT INTO msc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Allabatala ka a fɔ Musa yɛ ko: «N da jama wo yen. Ii ye mɔɔ kun gbɛlɛnilu le ri. ");
INSERT INTO msc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sisen, i kana n nalɔ. N mɔnɛni ii kanma kojuuya. N di ii halaki, ka ban ka jama ba bɔ ile rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa ka a Maari Allabatala matara kosɛbɛ ko: «Allabatala, i ka i la jama labɔ Misiran sebaya ba la, a ni fanka ba la. Nfenna i ri mɔnɛ ii kanma kojuuya? ");
INSERT INTO msc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ni i ka ii halaki, Misirankailu ri a fɔ ko i ka an nabɔ ye sa i ri kojuu kɛ an na. Ko i tun ye a fɛ ka an nana koyinkɛ ma yɔrɔ rɔ ka an faa, ka an si latunun ka bɔ dunuɲa rɔ. I ye i la mɔnɛ masuma. I ye a fɛ ka kojuu ba mɛn kɛ i la mɔɔilu la, i ye wo bila. ");
INSERT INTO msc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","I ye i hankili to i la jɔnilu rɔ, an benbailu Iburahima ni Isiyaka ni Isirayɛli kɔnin. I ka i kali i jɛrɛ tɔɔ rɔ woilu yɛ ko i ri ii bɔnsɔnilu siyaya ikomin sankolo loloilu. Ko i ri jamana di ii bɔnsɔn woilu ma ka a kɛ ii cɛ ri kadawu.» ");
INSERT INTO msc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Allabatala ka masilannikan mɛn fɔ ko a ri a la jama halaki, a ka wo to ye. ");
INSERT INTO msc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa jiira ka bɔ koyinkɛ kan. Teriya tɔɔmasere walan kabalaman fila ye a bolo, Alla la sariya sɛbɛni mɛnilu kan. Sariya woilu sɛbɛni walanilu ɲɛfɛla kan, a ni ii kɔfɛla. ");
INSERT INTO msc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Walanilu tɛrɛ Alla la baara nɔ le ri. Sɛbɛli mɛn tɛrɛ ye ii kan, wo tɛrɛ Allabatala bolo nɔ le ri. ");
INSERT INTO msc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Awa, Josuwe ka jama mankan mɛn tuma mɛn na, a ka a fɔ Musa yɛ ko: «Kɛlɛ mankan ye daa makɛ diya ye.» ");
INSERT INTO msc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa ka a fɔ ko: «Se sɔrɔnba kan tɛ wo ri, se sɔrɔnbali fanan kan tɛ. Mɛn ye n tolo la, wo ye donkilila kan de ri.» ");
INSERT INTO msc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa seni daa makɛ diya tuma mɛn na, a ka nisiden sawura wo yen, ka jama yen don kɛla. A mɔnɛra kojuuya, fɔɔ ka walan kabalaman fila lafili ka ii rakadikadi koyinkɛ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ii tun ka nisiden sawura mɛn nadan, Musa ka wo ta ka a bila ta rɔ ka a janin, ka ban ka a muumuu. A ka muun wo kɛ ji rɔ ka ji wo di jama ma ko ii ye a min. ");
INSERT INTO msc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa ka a fɔ Haruna yɛ ko: «Jama ka nfen kɛ i la fɔɔ i ka ii bila julumun ba rɔ ten?» ");
INSERT INTO msc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haruna ka a fɔ ko: «N fa, i kana mɔnɛ. I jɛrɛ ka a lɔn ko julumun kɛ duman ba le mɔɔ ɲinilu yɛ. ");
INSERT INTO msc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ii ka a fɔ n yɛ ko: ‹I ye batofenilu ladan an yɛ, mɛn di lɔ an ɲɔrɔ. Ka a masɔrɔn, an ma a lɔn mɛn kɛni wo cɛɛ Musa la mɛn ka an labɔ Misiran.› ");
INSERT INTO msc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Wo rɔ, n ka a fɔ ii yɛ ko sanin ye mɔɔ mɔɔ bolo, ko woilu ye a labɔ. Nba, ii ka woilu labɔ ka a di n ma. N ka a ta ka a bila ta rɔ. Nisiden sawura ɲin bɔra a rɔ!» ");
INSERT INTO msc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa ka a yen ko Haruna ka mɔɔilu to ii jɛrɛ diyanan ko kɛla. Ko wo le kosɔn, ii juuilu ra ii jate mayɛlɛfen di. ");
INSERT INTO msc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa wara a lɔ daa makɛ diya donda la. A ka a kan nabɔ ko: «Mɔɔ mɛnilu ye Allabatala fɛ, wo bɛɛ ye na yan.» Lebi bɔnsɔnilu bɛɛ wara ii lɔ a laminin dɔ. ");
INSERT INTO msc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","A ka a fɔ ii yɛ ko: «Isirayɛlikailu Maari Allabatala ka a fɔ ko cɛɛilu bɛɛ ye ii la fanmuru ta ka daa makɛ diya yɔrɔ bɛɛ rataamataama. Ii ye tamin mɔɔilu sii diya bɛɛ la, ka ii badenma cɛɛilu faa, a ni ii duɲɔɔnilu ni ii siiɲɔɔilu.» ");
INSERT INTO msc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Musa ka mɛn fɔ, Lebi bɔnsɔnilu ka wo bɛɛ kɛ. Mɔɔ waa sawa ɲɔɔn faara Isirayɛlikailu rɔ wo lon kelen. ");
INSERT INTO msc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Wo kɔ rɔ, Musa ka a fɔ Lebi bɔnsɔnilu yɛ ko: «Bi, ai ra bila a dan na Allabatala la baara kanma, baa ai ma ai ban wulila ai dencɛilu ni ai badenma cɛɛilu kanma. Allabatala ra baraka don ai la ko rɔ bi.» ");
INSERT INTO msc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wo duu sa gbɛ Musa ka a fɔ jama yɛ ko: «Ai ra julumun ba kɛ. Sisen, n di yɛlɛ koyinkɛ la ka wa Allabatala kunbɛn. Tumadɔ n di kafarili kɛ ai yɛ ten ai julumunilu la ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Musa yɛlɛra koyinkɛ kan ka wa Allabatala labɛn, ka a fɔ a yɛ ko: «Aa, Allabatala. Jama ɲin ka julumun ba le kɛ de. Ii ka batofenilu saninnaman nadan. ");
INSERT INTO msc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Sisen, n ye i madiyala, i ye yafa ii ma. Ni i ma sɔn wo ma, i ye n tɔɔ bɔ i la kitabu kɔndɔ, i ka mɛn sɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Allabatala ka a fɔ Musa yɛ ko: «Mɔɔ mɛnilu ka julumun kɛ n na, n ye woilu le tɔɔ bɔla n na kitabu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","I ye wa sisen. N ka yɔrɔ mɛn ko fɔ i yɛ, i ye lɔ jama ɲɔrɔ ka wa ii ri ye. N na mɛlɛka ri wa i ɲɛfɛ, kɔni n na waati wa se, n di n hakɛ bɔ ii rɔ ii la julumun ko kosɔn.» ");
INSERT INTO msc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nba, Allabatala ka a hakɛ bɔ jama rɔ ka a masɔrɔn ii le ka a fɔ Haruna yɛ ko a ye nisiden sawura wo ladan ii yɛ. ");
INSERT INTO msc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Allabatala ka a fɔ Musa yɛ ko: «I ye wuli ka bɔ yan, i ni jama mɛn nara i bolo ka bɔ Misiran. N ka n kali Iburahima ni Isiyaka ni Yakuba yɛ ko n di jamana mɛn di ii bɔnsɔnilu ma, i ye wa ye. ");
INSERT INTO msc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","N di n na mɛlɛka lawa ai ɲɛfɛ. N di Kanaankailu gbɛn ka ii labɔ jamana wo kɔndɔ, ka Amɔrikailu fanan gbɛn, a ni Hɛtikailu ni Peresikailu ni Hifikailu ni Jebusikailu. ");
INSERT INTO msc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ai ye wuli ka wa ye. Damununta duman ye bɔla jamana wo rɔ a ɲa jɛrɛ jɛrɛ ma, li ni nɔnɔ a bɛɛ ye bɔla ye. N kɔnin ti nala wala ai fɛ, sa n kana ai halaki sila la, baa ai ye mɔɔ kun gbɛlɛnilu le ri.» ");
INSERT INTO msc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mɔɔilu ka kunnagboya kuma wo mɛn tuma mɛn na, ii jusukasira. Mɔɔ si ma sɔn masidifenilu bilala a ma, ");
INSERT INTO msc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","baa Allabatala tun ka a fɔ Musa yɛ ko: «I ye a fɔ Isirayɛlikailu yɛ ko ii ye mɔɔ kun gbɛlɛnilu le ri. Ko ni n wara ii fɛ hali waati kuru ɲin kelen kɔrɔ, n di ii halaki. Ko ii ye ii la masidifenilu bɛɛ bɔ ii ma sisen. Ko wo kɔ rɔ, ko n ka kan ka ii mira ɲa mɛn ma, n di wo latɛɛ.» ");
INSERT INTO msc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Isirayɛlikailu bɔ mɛn kɛni Horɛbu koyinkɛ kan, ii ka ii la masidifenilu bɔ ii ma. ");
INSERT INTO msc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nba, Musa tɛrɛ ye faaninbon do tala ka wa a lɔ kɔkan, ka a yɔrɔ mataa daa makɛ diya la. A ka a fɔ wo ma ko Alla kunbɛn faaninbon. Mɔɔ mɔɔ tɛrɛ ye a fɛ ka ii la kunko yiraka Allabatala la, woilu tɛrɛ ye bɔla ka wa Alla Kunbɛn Diya Faaninbon na daa makɛ diya kɔkan. ");
INSERT INTO msc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musa tun wa kɛ wala faaninbon wo la tuma tuma, mɔɔilu bɛɛ ri i wuli ka i lɔ ii jɛrɛ la faaninbon da la ka Musa watɔla ragbɛ fɔɔ a wa ban donna faaninbon na tuma mɛn na. ");
INSERT INTO msc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa wa don faaninbon kɔndɔ tuma mɛn na, sanfinnama ri jii ka a lɔ faaninbon da la. Allabatala ri kuma Musa yɛ. ");
INSERT INTO msc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ni mɔɔilu ka sanfinnama wo lɔni yen faaninbon da la tuma mɛn na, ii bɛɛ ri i lɔ ii la faaninbon da la, ka ban ka i ɲakɔrɔ bɛn duu ma ka Alla bato. ");
INSERT INTO msc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Allabatala tun di kuma Musa yɛ ɲa ni ɲa ikomin mɔɔ ye kumala a teri yɛ ɲa mɛn ma. Wo kɔ rɔ, Musa ri a kɔsɛ daa makɛ diya. Kɔni a la dɛmɛnba Josuwe tora faaninbon kɔndɔ ye. Josuwe tɛrɛ ye kanberen de ri. A fa tɔɔ ko Nun. ");
INSERT INTO msc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa ka a fɔ Allabatala yɛ ko: «A ragbɛ, ile le ka a fɔ n yɛ ko: ‹Na jama ɲin di›, kɔni i kɛtɔ mɛn lɔla n fɛ ka n dɛmɛn, i ma wo tii fɔ n yɛ. I ka a fɔ ko: ‹N ka i tɔɔ lɔn›, a ni, ‹I la ko duman n yɛ.› ");
INSERT INTO msc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ni n da i la hina sɔrɔn, i sɔn i ye i la silailu yiraka n na kosa n ye i lɔn ka to i la hina sɔrɔnna. Jama ɲin fanan jate ko i la jama le ai ri.» ");
INSERT INTO msc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Allabatala ka a fɔ ko: «N nɔɔrɔ ri wa i fɛ ka i rafɔɲɔ.» ");
INSERT INTO msc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa ka a fɔ a yɛ ko: «Ni i jɛrɛ tɛ wala an kɔfɛ, i kana a fɔ an yɛ ko an ye bɔ yan. ");
INSERT INTO msc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ni i ma wa an kɔfɛ, mɔɔ si tɛ a lɔn ko n na ko ni i la jama la ko duman i yɛ. Ni i ma wa an kɔfɛ, foyi tɛ andeilu faranfaasi duukolo kan siya tɔilu ma.» ");
INSERT INTO msc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Allabatala ka a fɔ Musa yɛ ko: «I ka mɛn tara, n di wo kɛ, baa i la ko duman n yɛ. N da i tɔɔ lɔn.» ");
INSERT INTO msc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa ka a fɔ ko: «Awa, i la nɔɔrɔ yiraka n na.» ");
INSERT INTO msc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Allabatala ka a fɔ ko: «N di tamin i ɲakɔrɔ ka n na ɲumaya yiraka i la, ka n tɔɔ fɔ i yɛ ko Allabatala. N ye a fɛ ka ɲumaya kɛ mɔɔ mɛn yɛ, n di ɲumaya kɛ wo yɛ. N ye a fɛ ka hina mɔɔ mɛn na, n di hina wo la. ");
INSERT INTO msc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Kɔni i ti se n ɲakɔrɔla yenna, baa mɔɔ si ti se n ɲakɔrɔla yenna ka a to ɲenemaya rɔ. ");
INSERT INTO msc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yɔrɔ do ye n tɔrɔfɛ yan. I ri se i lɔla farakolo kan ye. ");
INSERT INTO msc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","N na nɔɔrɔ wa kɛ taminna tuma mɛn na, n di i don farakolo falan kɔndɔ ka n bolo birin i kun na fɔɔ n wa ban taminna. ");
INSERT INTO msc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Wo kɔ rɔ, n di n bolo bɔ ye, i ri n kɔ yen. Kɔni mɔɔ ti nala n ɲakɔrɔla yenna.» ");
INSERT INTO msc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Allabatala ka a fɔ Musa yɛ ko: «I ye walan kabalaman fila lɛsɛ ka ii kɛ ikomin fɔlɔmantailu, i ka mɛnilu rakadikadi. Kuma mɛnilu sɛbɛni tɛrɛ walan fɔlɔmantailu kan, n di woilu sɛbɛ walan kurailu fanan kan. ");
INSERT INTO msc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","I ye i jɛrɛ rabɛn sisen sini sɔɔma. Ni duusa gbɛra, i ye yɛlɛ Sinayi koyinkɛ kun na ka i lɔ n ɲakɔrɔ ye. ");
INSERT INTO msc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mɔɔ si kana yɛlɛ ka na i kɔfɛ. Mɔɔ si kana a madon koyinkɛ yɔrɔ si la fanan. Hali saailu ni bailu ni nisiilu fanan kana tamin koyinkɛ kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nba, Musa ka walan kabalaman fila lɛsɛ ka woilu kɛ ikomin fɔlɔmantailu. Sɔɔma jona, a sorira ka yɛlɛ Sinayi koyinkɛ kan ikomin Allabatala ka a fɔ a yɛ ɲa mɛn ma. Walan fila wo tɛrɛ ye a bolo. ");
INSERT INTO msc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Allabatala jiira sanfinnama dɔ, ka na i lɔ Musa tɔrɔfɛ ye, ka a jɛrɛ tɔɔ fɔ ko Allabatala. ");
INSERT INTO msc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Allabatala taminda a ɲakɔrɔ ka a fɔ ko: «Allabatala ye Allabatala le ri. N ye Alla le ri, mɛn ye kininkinin tii ri, mɛn fanan ye ɲumaya kɛla mɔɔilu yɛ. N tɛ mɔnɛla jona. N na kaninteya ni n na kankelentiiya ka bon. ");
INSERT INTO msc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","N ye n na kaninteya yirakala n na mɔɔilu la haan ii bɔnsɔn farɔkɛ waailu. N ye telenbaliya ni murunti ni kojuu yafala mɔɔilu ma. Kɔni n tɛ kojuu kɛlaba jalakibali to ye. N ye failu la julumun hakɛ bɔla ii denilu le rɔ, a ni ii mamarenilu rɔ, a ni ii tolomirailu rɔ, a ni woilu fanan denilu rɔ.» ");
INSERT INTO msc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa ka a ɲakɔrɔ bɛn duu ma i kɔrɔ ka Alla bato. ");
INSERT INTO msc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","A ka a fɔ ko: «Maari Alla, ni n na ko duman i yɛ, n ye i madiyala i ye wa an kɔfɛ. N ka a lɔn ko mɔɔ kun gbɛlɛnilu le ɲinilu ri. Kɔni n ye i madiyala, i ye an na telenbaliya koilu ni an na julumunilu kafari, ka an mira ikomin i la jama.» ");
INSERT INTO msc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Allabatala ka a fɔ ko: «A ragbɛ, n ye teriya sidila ai ma. N di kabannakoilu kɛ i la jama bɛɛ ɲana, mɛnilu ɲɔɔn ma kɛ fɔlɔ dunuɲa yɔrɔ si rɔ, mɛnilu ɲɔɔn ma kɛ fɔlɔ siya gbɛrɛilu si tɛma. I laminin mɔɔilu bɛɛ ri n na kɛwali makabanibailu yen, n kɛtɔ mɛnilu kɛla ka fara ile la. ");
INSERT INTO msc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","N ye mɛn fɔla i yɛ bi, i ye woilu mira ka a latelen. N di Amɔrikailu gbɛn ai ɲɛ, a ni Kanaankailu ni Hɛtikailu ni Peresikailu ni Hifikailu ni Jebusikailu. ");
INSERT INTO msc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ai ye a kɛ koɲuma. Ai kana teriya si don ai ni jamana wo mɔɔilu tɛma, sani a ri kɛ ikomin ai ra mira miralifen na. ");
INSERT INTO msc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ai ye ii la saraka bɔ diyailu te, ka ii la kaba lalɔni batotailu rakadikadi, ka ii la Asera lɔkudun tɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ai kana batofen gbɛrɛ si bato, baa Allabatala le nde ri, mɛn tɛ sɔn mɔɔilu ye fen gbɛrɛ bato. N tɔɔ ko Alla keleyatɔ. ");
INSERT INTO msc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ai ye a kɛ koɲuma. Ai kana teriya don ai ni jamana wo mɔɔilu tɛma. Ni wo kɛra, ii wa ii madon ii la natala ii jusu rɔ ii la batofenilu la ka saraka bɔ woilu yɛ, ii ri ai kili. Wo rɔ, ai ri wa ii la sarakailu do dɔɔn. ");
INSERT INTO msc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ni ai ka duɲɔɔnya don ai ni ii tɛma, ai ri ii denmusoilu furu ka ii di ai dencɛilu ma. Denmusoilu wo wa ii madon ii la natala ii jusu rɔ ii la batofenilu la, ii ri ai dencɛilu manɛɛn, ka a kɛ sababu ri woilu fanan di batofen woilu bato. ");
INSERT INTO msc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Ai kana nɛɛ yelen ka batofen nadan. ");
INSERT INTO msc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Ai ye Buru Fununbali Sali kɛ. Ni a waati latɛɛni sera Abibu karo la, ai ye buru fununbali dɔɔn tele wɔrɔnwula kɔrɔ ikomin n ka a fɔ ai yɛ ɲa mɛn ma, baa ai bɔra Misiran Abibu karo wo le la. ");
INSERT INTO msc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Den fɔlɔilu bɛɛ ye n ta le ri, hali ai la kolofen bonbailu ni ai la kolofen mɛsɛnilu den fɔlɔ cɛmanilu. ");
INSERT INTO msc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Kɔni ni faliden fɔlɔ le, ai ye saaden wala badenni di n ma wo nɔ rɔ ka wo kunka. Ni ai ma a kunka ten, fo ai ye a kan kadi ka a faa. Ai ye ai dencɛ fɔlɔilu bɛɛ kunka. «Mɔɔ si kana na n bato diya ni niilifen ma na ai bolo. ");
INSERT INTO msc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ai ye baara kɛ tele wɔɔrɔ kɔrɔ, kɔni tele wɔrɔnwulana lon, ai ye baara lalɔ ka i ɲɔɲɔ. Hali sɛnɛkɛ waati ni sumanka waati, ni tele wɔrɔnwulana lon sera, ai ye baara lalɔ ka i ɲɔɲɔ. ");
INSERT INTO msc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Ai ri Lɔɔkun Sali kɛ san san. Wo tuma, ai ra bile tɔnsɔn mɛnilu fɔlɔ ka, ai ri woilu kɛ saraka ri. Ai wa ban sɛnɛ baarala san san ka suman nadon, ai ye Suman Nadon Sali kɛ. ");
INSERT INTO msc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","San san ai la cɛɛilu bɛɛ ye na n ɲakɔrɔ siɲa sawa ka n bato, nde mɛn ye Isirayɛlikailu Maari Allabatala ri. ");
INSERT INTO msc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","N di siyailu gbɛn ka a mabɔ ai ɲɛ ka do kafu ai la jamana la bonya ma. San san, ai wa kɛ wala ai Maari Allabatala ɲakɔrɔ ka a bato siɲa sawa, n tɛ sɔn mɔɔ si ye a nata la ai la jamana kan ka a mira ai kɔ. ");
INSERT INTO msc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Ai wa kolofen bɔ ka a kɛ n yɛ saraka ri, ai kana wo jeli ni buru la a ɲɔɔn kan ka a di n ma, lɛbɛn ye buru mɛn dɔ. Ai wa kolofen bɔ ka a kɛ Taminkunna Sali saraka ri, ai kana sɔn wo sobo tɔ ye su si. ");
INSERT INTO msc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«San san ai wa suman kura fɔlɔ mɛnilu ka, ai ye na wo ɲuma ɲumailu ri ai Maari Allabatala la bon na. «Ai kana badenni tibi a na nɔnɔ la.» ");
INSERT INTO msc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Allabatala ka a fɔ Musa yɛ ikɔ tuunni ko: «I ye kuma ɲinilu sɛbɛ, baa n da teriya sidi nde ni ile tɛma, a ni nde ni Isirayɛlikailu bɛɛ tɛma, ka a bɛn kuma woilu le ma.» ");
INSERT INTO msc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa ka tele binaanin ni su binaanin kɛ Allabatala tɔrɔfɛ ye. A ma dɔɔnnin kɛ. A ma ji min. A ka Allabatala la teriya kumailu sɛbɛ walan kabalamanilu kan, Allabatala la sariya tan kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa jiira ka bɔ Sinayi koyinkɛ kan. Teriya tɔɔmasere walan kabalaman fila ye a bolo, Allabatala la sariya sɛbɛni mɛnilu kan. A ɲakɔrɔla tɛrɛ ye mɛlɛnmɛlɛnna ka a masɔrɔn a ni Allabatala kumara i ɲɔɔn fɛ. Kɔni Musa ma wo lɔn. ");
INSERT INTO msc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haruna ni Isirayɛlikailu bɛɛ ka Musa yen tuma mɛn na, ii ka a yen a ɲakɔrɔla ye mɛlɛnmɛlɛnna. Ii ma sɔn i madonna a la, baa ii silanni. ");
INSERT INTO msc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kɔni Musa ka ii kili. Awa Haruna ni jama kuntiilu bɛɛ nara a tɛrɛn, wo rɔ Musa kumara ii yɛ. ");
INSERT INTO msc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Wo kɔ rɔ, Isirayɛlikailu bɛɛ ka i madon a la. Allabatala tun ka Musa jamari mɛnilu la Sinayi koyinkɛ kan, Musa ka wo bɛɛ fɔ ii yɛ. ");
INSERT INTO msc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa ban kɔ rɔ kumala ii yɛ, a ka faanin birin a ɲakɔrɔ da la. ");
INSERT INTO msc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ka a ta waati wo ma, ni Musa donda Allabatala ɲakɔrɔ kuma diya, a ri faanin wo bɔ a ɲakɔrɔla la haan a wa bɔ tuma mɛn na. Ni a bɔra ye tuma mɛn na, Allabatala tun ka a jamari ko ko la, a ri wo fɔ Isirayɛlikailu yɛ. ");
INSERT INTO msc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Isirayɛlikailu ri a yen ko Musa ɲakɔrɔla ye mɛlɛnmɛlɛnna. Wo kɔ rɔ, Musa ri faanin wo birin a ɲakɔrɔla la ikɔ tuunni, haan a wa don ikɔ tuun Allabatala kan ka kumaɲɔɔnya. ");
INSERT INTO msc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa ka Isirayɛlikailu jama bɛɛ ladɛn ka a fɔ ii yɛ ko: «Allabatala ka jamarili mɛnilu di ai ma, ko ai ye woilu kɛ, ii le ɲin. ");
INSERT INTO msc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ai ye baara kɛ tele wɔɔrɔ kɔrɔ, kɔni tele wɔrɔnwulana lon ye kɛ ai yɛ lon sɛniman di. Ɲɔɲɔ lon de wo ri, mɛn bilani a dan na Allabatala bonya kanma. Ni mɔɔ mɛn ka baara kɛ wo lon, ai ye wo tii faa. ");
INSERT INTO msc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hali ka ta ladɛn ai la bon do kɔndɔ Ɲɔɲɔ lon, ai kana wo kɛ.» ");
INSERT INTO msc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa ka a fɔ Isirayɛlikailu jama bɛɛ yɛ ko: «Allabatala ka jamari ko: ");
INSERT INTO msc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‹ai ye fen doilu bɔ ai bolofenilu rɔ ka woilu kɛ niilifenilu ri ka ii di Allabatala ma. Mɔɔ mɛnilu ri sɔn wo ma, ii bɛɛ ye na niilifen di. Ii ye na sanin di, a ni wodigbɛ ni sulanɛɛ ");
INSERT INTO msc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ni faaningbɛ ɲuma. Ii ye na baa siilu fanan di, ");
INSERT INTO msc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","a ni saaji gbolo kolonin wulenman ni gbolo kolonin ɲuma su gbɛrɛilu ni kasiya jiri. ");
INSERT INTO msc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Ii ye na olibiye tulu ri, mɛn di kɛ fitinailu rɔ. Ii ye na sumadiyalanilu fanan di, mɛnilu di kɛ wusulan ni suwandili tulu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Kabakuru mɛn tɔɔ ko onikisi, ii ye na wo ri, a ni kabakurun ragbɛlɛn gbɛrɛilu, ka woilu kara Allabatala la sarakalasela la kɔkanbila durukini kɔkan, a ni a la sisirɔ bɔrɔni kɔkan. ");
INSERT INTO msc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mɛnilu kusan bolo la baarala, ii ye na ka fenilu rabɛn, Allabatala ka mɛnilu bɛɛ ko fɔ. ");
INSERT INTO msc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ii ri Alla daa makɛ faaninbon nadan, a ni a faaninbon wo kunnabirin. Ii ri Alla daa makɛ faaninbon fendamirafenilu fanan nadan, a ni a damira jiriilu ni a kankan gbelekeilu ni a samasenilu ni a siifenjuilu. ");
INSERT INTO msc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ii ri teriya tɔɔmasere kankira fanan nadan, a ni a gbelekeilu ni a dalatuun ni bon tatɛɛfaanin, kankira ri sii mɛn kɔma. ");
INSERT INTO msc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ii ri tabali fanan nadan, a ni a gbelekeilu ni a muranilu bɛɛ. Ii ri saraka buru fanan dabɛn, mɛn di bila tabali kan, mɛn di to Allabatala ɲakɔrɔ tuma bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ii ri fitinasiifen ni a muranilu bɛɛ ladan, a ni a fitinailu ni fitina tulu. ");
INSERT INTO msc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Ii ri wusulanjanin saraka janin diya ni a gbelekeilu ladan, a ni wusulan suma duman ni suwandili tulu. Ii ri faanin fanan nadan, mɛn di dun faaninbon donda la. ");
INSERT INTO msc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ii ri saraka janin diya ladan, sarakailu ri janin mɛn kan ka kɛ buuri ri. Ii ri saraka janin diya wo sansan sulanɛɛlaman fanan nadan, a ni saraka janin diya gbeleke ni a muranilu bɛɛ. Ii ri koli muran ba ladan, a ni a siifenju. ");
INSERT INTO msc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ii ri lukɔndɔla laminin faanin fanan nadan, a ni woilu lɔ jiriilu ni jiriilu siifenilu, ka lukɔndɔla donda faanin fanan nadan. ");
INSERT INTO msc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Faaninbon ni a lukɔndɔla laminin faaninilu ri sidi bɔlɔ mɛnilu la duu ma, ii ri woilu fanan nadan, a ni ii juluilu. ");
INSERT INTO msc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ii ri faanin kenɲi bailu fanan nadan, n na sarakalasela Haruna la faanin sɛnimanilu ni a dencɛilu la faaninilu kɔnin. Haruna ni a dencɛilu ri faanin woilu bila ii kan na ka Alla la sarakalasela baara kɛ yɔrɔ sɛniman kɔndɔ.›» ");
INSERT INTO msc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Isirayɛlikailu jama bɛɛ bɔra Musa ɲakɔrɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","A ko donda mɛnilu jusu rɔ ka ii kɛ waninkɛɲumatiilu ri, woilu bɛɛ nara niilifenilu ri Allabatala ma a daa makɛ faaninbon ni a kɔndɔfenilu bɛɛ baara kanma, a ni a sarakalaselailu la faanin sɛnimanilu. ");
INSERT INTO msc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Cɛɛ waninkɛɲumatiilu ni muso waninkɛɲumatiilu bɛɛ nara fen saninnaman su bɛɛ ri. Ii nara masidifen saninnamanilu ri, a ni tololafen saninnamanilu ni bolo la koyina saninnamanilu ni kanna kɔnɔn saninnamanilu. Ii bɛɛ nara niilifen saninnaman woilu ri ka ii kɔrɔta Allabatala ɲakɔrɔ ka ii di a ma. ");
INSERT INTO msc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ni faaningbɛ ɲuma tɛrɛ ye mɛnilu bolo, woilu nara woilu ri, a ni baa siilu ni saaji gbolo kolonin wulenman ni gbolo kolonin ɲuma gbɛrɛilu. ");
INSERT INTO msc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Mɛnilu bɛɛ tɛrɛ ye a fɛ ka wodigbɛ wala sulanɛɛ kɛ niilifen di, woilu nara woilu di Allabatala ma. Kasiya jiri tɛrɛ ye mɛnilu bolo, jiri mɛn di Alla daa makɛ faaninbon baara do ɲa kɔnin, woilu nara woilu fanan di. ");
INSERT INTO msc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Muso mɛnilu kusan wurundili kɛla, ii bɛɛ ka kari ladan ten ka na woilu ri. Ii nara kari buleman di, a ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ni faanin ɲuma. ");
INSERT INTO msc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Muso mɛnilu bɛɛ jusu sɔnda a ni mɛnilu kusan baa si wurundila kosɛbɛ, woilu ka wo wurundi. ");
INSERT INTO msc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Isirayɛlikailu la ɲɛmɔɔilu nara onikisi kabakurunilu ni kabakurun ragbɛlɛn gbɛrɛilu ri, mɛnilu ri kara kɔkanbila durukini ni sisirɔ bɔrɔni la. ");
INSERT INTO msc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ii nara tulu ni sumadiyalanilu fanan di. Tulu wo fan kelen di kɛ fitina tulu ri. A tɔ fan kelen di kɛ suwandili tulu ri. Sumadiyalan woilu fan kelen kɛra suwandili tulu rɔ. A tɔ fan kelen kɛra wusulan di. ");
INSERT INTO msc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isirayɛlika waninkɛɲumatiilu bɛɛ nara ii la bɔnjɛrɛrɔ niilifenilu ri Allabatala ma baara kɛ kanma, a tun ka baara mɛn bɛɛ ko fɔ ii yɛ ka fara Musa la. ");
INSERT INTO msc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa ka a fɔ Isirayɛlikailu yɛ ko: «A ragbɛ. Allabatala ra Uri dencɛ Besalɛli suwandi. Yahuda kabila mɔɔ le ri. A benba ye Huri le ri, Uri fa kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Allabatala ra Besalɛli lawasa Alla la Nii Sɛniman na. Wo rɔ, a hankili duman, a kusan, a la lɔnnin ka bon. A seni baara su bɛɛ kɛla. ");
INSERT INTO msc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","A seni fen kenɲiilu ladanna sanin na, a ni wodigbɛ la, a ni sulanɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","A seni kabakurun kisɛilu lɛsɛla, ka ii bila fendamirafenilu la. A seni jiri fanan lɛsɛla. A kusan bolo labaara su bɛɛ kɛla. ");
INSERT INTO msc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Allabatala ra se di Besalɛli ni Ahisamaki dencɛ Oholiyabu ma ka mɔɔilu karan sa woilu fanan di baara su woilu kɛ. Oholiyabu ye Daan kabila mɔɔ le ri. ");
INSERT INTO msc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","A ka se di ii ma sa ii di se baara su bɛɛ kɛla. Ii ye bololabaara ɲuma kɛla. Ii ye kolɔnnailu le ri, mɛnilu ye fen ɲatɔnɔmailu ni fen kenɲiilu ladanna. Faanin sɔɔlailu le ii ri, mɛnilu ye faaningbɛ ɲuma sɔɔla kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la. Ii kusan jese danna fanan. Ka bolo la baara su bɛɛ kɛ, ii seni wo la kosɛbɛ. Ka fen ɲatɔnɔmailu ni fen kenɲiilu ladan, ii seni wo fanan na kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Awa, Besalɛli ni Oholiyabu ni mɔɔ mɛnilu kusan bɛɛ ri, woilu ye baara kɛ koɲuma ka a bɛn Allabatala la kuma ma. Allabatala ra se ni famunyali di ii ma sa ii ri se Alla daa makɛ faaninbon ni a kɔndɔfenilu bɛɛ ladanna.» ");
INSERT INTO msc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Nba, Musa ka Besalɛli ni Oholiyabu kili baara kanma a ni bolo labaara la gbɛrɛilu Allabatala tun ka sebaya di mɔɔ mɛnilu ma, mɛnilu bɛɛ sɔnda nala ka baara wo kɛ. ");
INSERT INTO msc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isirayɛlikailu tun nara niilifen mɛnilu di Musa ma Alla daa makɛ faaninbon baara kanma, Musa ka fen woilu don baarakɛla woilu bolo baara kanma. Kɔni Isirayɛlikailu tora nala bɔnjɛrɛrɔ niilifenilu ri sɔɔma sɔɔma. ");
INSERT INTO msc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Wo kɛra sababu ri, baarakɛla kusan ba woilu mɛnilu tɛrɛ ye Alla daa makɛ faaninbon baara kɛla, woilu ka ii la baara lalɔ. ");
INSERT INTO msc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ii wara Musa tɛrɛn ye ka a fɔ a yɛ ko: «Allabatala ka baara ko fɔ. An mako ye fen mɛnilu la ka baara wo kɛ, mɔɔilu ye nala woilu ri fɔɔ ka a dan natamin.» ");
INSERT INTO msc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","A kɛra ten, Musa ka kela lawa ii daa makɛ diya yɔrɔ bɛɛ rɔ ko mɔɔ si kana na niilifen di butun Alla daa makɛ faaninbon baara kanma. Wo rɔ, jama ka niilifen di boloka, ");
INSERT INTO msc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","baa niilifen mɛnilu tun da di, woilu tun di se ka baara laban ka a tɔ to. ");
INSERT INTO msc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Mɛnilu bɛɛ kusan bolo labaara kɛla kosɛbɛ baarakɛlailu tɛma, woilu ka Alla daa makɛ faaninbon jɛrɛ ladan faanin janya tan na. Faanin woilu tɛrɛ faaningbɛ ɲumailu le ri, kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ye mɛnilu la. Mɛn kusan faanin sɔɔla kosɛbɛ, wo ka serubɛn sawurailu ta woilu kan. ");
INSERT INTO msc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Faanin tan woilu bɛɛ kanyara. Ii janya kɛra nunkan ɲa muwan ni seyin di. Ii kɔndɔ kɛra nunkan ɲa naanin le ri. ");
INSERT INTO msc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ii ka faanin loolu kara i ɲɔɔn na, ka a tɔ loolu fanan kara i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Faanin loolu mɛn karani i ɲɔɔn na, ii ka tonilu bila wo faanin looluna dagbolo la. Ii ka wo ɲɔɔn kɛ faanin tɔ loolu fanan na, mɛnilu karani ii ɲɔɔn na. Ii ka ton woilu ladan kari buleman dɔ, ");
INSERT INTO msc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ka ton biloolu biloolu bila faanin fila woilu dagboloilu la, ka ii ɲa bɛn i ɲɔɔn ma. ");
INSERT INTO msc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ii ka fendamirafenilu saninnaman biloolu ladan, mɛnilu ka ton fila fila mira ka faanin fila woilu tuun i ɲɔɔn na. Wo rɔ, faaninbon muumɛ ka i ɲɔɔn mira ka kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ii ka faanin janya tan ni kelen nadan baa si la, ka ii kɛ faaninbon kunnabirin di. ");
INSERT INTO msc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Faanin tan ni kelen woilu bɛɛ kanyara. Ii janya kɛra nunkan ɲa bisawa ri. Ii kɔndɔ kɛra nunkan ɲa naanin di. ");
INSERT INTO msc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ii ka faanin loolu kara i ɲɔɔn na, ka faanin tɔ wɔɔrɔ kara i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Faanin loolu mɛnilu karani i ɲɔɔn na, ii ka ton biloolu bila faanin wo looluna dagbolo la. Faanin tɔ wɔɔrɔ mɛnilu fanan karani i ɲɔɔn na, ii ka ton biloolu bila wo wɔɔrɔna dagbolo la. ");
INSERT INTO msc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ii ka fendamirafen sulanɛɛlaman biloolu fanan nadan. Faanin fila woilu ri tuun i ɲɔɔn na woilu la, ka a kɛ fen kelen di. ");
INSERT INTO msc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ii ka faaninbon kunnabirin nadan saaji gboloilu la, mɛnilu tun da wulen, ka kunnabirin gbɛrɛ fanan nadan gbolo kolonin ɲumailu la. Kunnabirin filana wo ri la saaji gbolo ta kan ka to a san fɛ. ");
INSERT INTO msc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ii ka kasiya jiriilu ta ka faaninbon damira jiriilu ladan mɛnilu lalɔtɔ. ");
INSERT INTO msc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Woilu kelen kelenna bɛɛ janya kɛra nunkan ɲa tan di. Ii bonya kɛra nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Ii ka tɛmala jiri fila bila jiri woilu tɛma, ka tɛmala jiri woilu ɲabɛn i ɲɔɔn ma. Ii ka faaninbon damira jiriilu bɛɛ ladan wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ii ka faaninbon damira jiri muwan nadan. Woilu lalɔtɔ faaninbon tele kankan bolokinin fan fɛ. ");
INSERT INTO msc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ii ka siifenju wodigbɛlaman binaanin fanan nadan, mɛnilu bilatɔ jiri woilu ju kɔrɔ, jiri kelen siifenju fila, baa sen fila mɛnilu ye jiriilu bɛɛ la, woilu bɛɛ dontɔ siifenju rɔ, sen kelen siifenju kelen. ");
INSERT INTO msc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","26","Faaninbon damira jiri muwan mɛnilu ri lalɔ faaninbon tele kankan bolomaran dɔ, ii ka woilu ladan, ka siifenju wodigbɛlaman binaanin fanan nadan, jiri kelen siifenju fila. ");
INSERT INTO msc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Faaninbon damira jiri wɔɔrɔ mɛnilu ri lalɔ faaninbon telebe rɔ, bon kɔfɛla kɔnin, ii ka woilu ladan, ");
INSERT INTO msc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ka jiri fila fanan nadan, mɛnilu lalɔtɔ bon kɔfɛla rɔ ka kɛ faaninbon tonkonilu ri. ");
INSERT INTO msc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ii ka tonkon jiri fila ɲinilu bɛɛ ladan jiri fila fila la, mɛnilu tansanni i ɲɔɔn ma duu ma ka bɛn i ɲɔɔn ma san fɛ. Jiri fila kunilu mirani i ɲɔɔn na koyina kelen na. Ii ka tonkon jiri fila bɛɛ ladan ten. ");
INSERT INTO msc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Wo rɔ, faaninbon damira jiri seyin di lalɔ bon kɔfɛ la muumɛ rɔ. Siifenju wodigbɛlaman tan ni wɔɔrɔ ri bila woilu kɔrɔ, jiri kelen siifenju fila. ");
INSERT INTO msc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ii ka gbeleke kankantailu ladan kasiya jiri rɔ, mɛnilu ri kankan faaninbon damira jiriilu kan ka woilu ramira. Gbeleke loolu ri kankan faaninbon fan kelen jiriilu kan. ");
INSERT INTO msc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Gbeleke loolu ri kankan faaninbon fan do damira jiriilu kan. Gbeleke loolu fanan di kankan faaninbon kɔfɛ la damira jiriilu kan, bon telebe fan fɛ kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kankan gbeleke mɛnilu ri kɛ gbeleke loolu loolu woilu tɛma ta ri, ii ka woilu ladan sa ii ri bɔ faaninbon fan kelen tonkon do la ka wa se fan wo tonkon do ma. ");
INSERT INTO msc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ii ka sanin la faaninbon damira jiriilu kan ka jiri bɛɛ latunun, ka sanin la gbeleke kankantailu fanan kan ka jiri bɛɛ latunun. Ii ka koyina saninnamanilu ladan ka woilu kɛ faaninbon damira jiriilu la. Gbeleke kankantailu ri don woilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ii ka bon tatɛɛfaanin nadan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Mɛn kusan faanin sɔɔla kosɛbɛ, wo ka serubɛn sawurailu ta a kan. ");
INSERT INTO msc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ii ka tatɛɛfaanin dun samasen naanin nadan kasiya jiri la, ka sanin la woilu kan ka jiri bɛɛ latunun. Ii ka sɔɔlan saninnamanilu kɛ samasen woilu kan, ka samasen sii siifenju wodigbɛlaman naanin kan, jiri kelen siifenju kelen. ");
INSERT INTO msc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Faanin mɛn di dun faaninbon donda la, ii ka wo ladan faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Mɛn kusan faanin sɔɔla, wo ka a sɔɔ ka a ɲa. ");
INSERT INTO msc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ii ka faanin dunjiri loolu ladan, ka sɔɔlanilu kɛ woilu la. Wo kɔ rɔ, ii ka sanin la jiri woilu kun na, a ni faanindun koyinailu kan, mɛnilu tɛrɛ ye jiriilu la, ka ban ka siifenju sulanɛɛlaman loolu ladan, jiri kelen siifenju kelen. ");
INSERT INTO msc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalɛli ka teriya tɔɔmasere kankira ladan kasiya jiri rɔ. A janya kɛra nunkan ɲa fila ni tala ri. A bonya kɛra nunkan ɲa kelen ni tala ri. A lɔ kɛra nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A ka sanin jɛrɛwolo la a kɔndɔla ni a kɔkanna bɛɛ ma, ka a jiri bɛɛ latunun. A ka a da kirinkirin bɛɛ kɛ sanin di. ");
INSERT INTO msc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A ka koyina saninnaman naanin nadan, ka woilu kelen kelenna bila kankira sen naanin na. Wo rɔ, koyina fila bilara kankira fan kelen fɛ, a tɔ fila bilara a fan do fɛ. ");
INSERT INTO msc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","A ka gbelekeilu rabɛn kasiya jiri rɔ, ka sanin la woilu ma ka a jiri bɛɛ latunun. ");
INSERT INTO msc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","A ka woilu don koyinailu rɔ teriya tɔɔmasere kankira fan fila bɛɛ rɔ, sa kankira ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","A ka julumun kafari dalatuun nadan sanin jɛrɛwolo la. A janya kɛra nunkan ɲa fila ni tala ri. A kɔndɔ kɛra nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","A ka serubɛn bisiki kelen kelenna ladan datuun na kun fila ma. A ka woilu ladan sanin gbasinin dɔ. ");
INSERT INTO msc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","A ka serubɛn bisiki kelen nadan kankira datuun na kun kelen na, ka a tɔ kelen nadan datuun na kun do wo la. Serubɛn bisiki fila ni kankira datuun na bɛɛ kɛra fen kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Serubɛn bisiki fila ɲabɛnni i ɲɔɔn na, ka ii ɲa lɔni to kankira datuun na rɔ. Ii kawailu layɛlɛra san ma, ka birin kankira datuun na kun na. ");
INSERT INTO msc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Besalɛli ka tabali kelen nadan kasiya jiri rɔ. A janya kɛra nunkan ɲa fila ri, a kɔndɔ kɛra nunkan ɲa kelen di, a lɔ kɛra nunkan ɲa kelen ni tala ri. ");
INSERT INTO msc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","A ka sanin jɛrɛwolo la tabali wo bɛɛ ma ka jiri bɛɛ latunun, ka a da kirinkirin bɛɛ kɛ sanin di. ");
INSERT INTO msc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","A ka fɛrɛnilu kankan tabali la tabali fan bɛɛ la. Fɛrɛn woilu bonya bɛnda bolo koyini naanin bonya ma. A ka a da kirinkirin bɛɛ kɛ sanin di fɛrɛn woilu la. ");
INSERT INTO msc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","A ka koyina naanin nadan sanin dɔ, ka woilu kelen kelenna don tabali tonkon naanin na a sen kelen kelenna dafɛ. ");
INSERT INTO msc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","A ka koyinailu lasudunya fɛrɛnilu la. Tabali ta gbelekeilu ri don koyina woilu rɔ sa tabali ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","A ka tabali ta gbelekeilu rabɛn kasiya jiri rɔ, ka sanin la woilu ma ka a jiri bɛɛ latunun. ");
INSERT INTO msc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Muran mɛnilu ri bila tabali kan, a ka woilu ladan sanin jɛrɛwolo la. Wo doilu kɛni ikomin pileti ni kalamailu ni jilafɛilu ni daailu. Alla sarakalaselailu ri rɛsɛnji kɛ muran woilu kɔndɔ, ka a labɔn ka a kɛ niilifen di. ");
INSERT INTO msc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","A ka fitinasiifen nadan sanin jɛrɛwolo gbasinin dɔ. A kala ni a sen, a ni a fitinasii daaninilu ni a kuruilu ni a fɛrɛn bisikilu bɛɛ kɛra fen kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Bolon wɔɔrɔ bɔra a kala rɔ. Bolon sawa kɛra bolokinin fɛ, bolon sawa kɛra bolomaran fɛ. ");
INSERT INTO msc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","A ka daani sawa ladan bolon kelen kelenna bɛɛ la, ka woilu kɛ amande jiriden munuɲa ri, bɛɛ ni a kuruilu, bɛɛ ni a fɛrɛnilu. ");
INSERT INTO msc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A ka daani naanin nadan fitinasiifen kala la, ka woilu fanan kɛ amande jiriden munuɲa ri, bɛɛ ni a kuruilu, bɛɛ ni a fɛrɛnilu. ");
INSERT INTO msc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A ka kuru kelen kɛ bolon fila fila fara yɔrɔ kɔrɔ kala la. Fitinasiilan bolon wɔɔrɔ bɛɛ kɛra ten. ");
INSERT INTO msc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Fitinasiilan ni a kuruilu ni a bolonilu bɛɛ ri ladan sanin jɛrɛwolo gbasinin dɔ. Wo bɛɛ kɛra fen kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","A ka fitina wɔrɔnwula ladan, a ni a rabɔlanilu ni a buurigbɛ kɛ fenilu. A ka wo bɛɛ ladan sanin jɛrɛwolo la. ");
INSERT INTO msc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","A ka fitinasiifen ni a muranilu bɛɛ ladan sanin jɛrɛwolo kilo bisawa rɔ. ");
INSERT INTO msc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","A ka wusulanjanin saraka janin diya ladan kasiya jiri la. Wo fan naanin bɛɛ kanyara. A fan kelen kelen bɛɛ kɛra nunkan ɲa kelen di. A lɔ kɛra nunkan ɲa fila ri. Kere munuɲa kɛra a tonkon naanin bɛɛ la, kɔni kereilu ni saraka janin diya bɛɛ tɛrɛ ye fen kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A ka sanin jɛrɛwolo la a yɔrɔ bɛɛ kan, a sanfɛ yɔrɔ ni a kɛrɛfɛ yɔrɔilu a ni a kereilu bɛɛ. A ka a da kirinkirin bɛɛ kɛ sanin di a fan naanin bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A ka koyina saninnaman fila ladan da kirinkirin wo kɔrɔ saraka janin diya fan fila fɛ, fan kelen koyina fila. Sarakabɔdiya ta gbelekeilu tɛrɛ ye donna koyina woilu rɔ, sa saraka janin diya ri se madonninna. ");
INSERT INTO msc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","A ka gbelekeilu rabɛn kasiya jiriilu la ka sanin la ii yɔrɔ bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Besalɛli ka wusulan sumaduman jɛrɛwolo ladan, ka suwandili tulu sɛniman fanan nadan. A ka woilu ladan ikomin latikɔlɔn nadanna ye latikɔlɔn nadan ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Awa, sarakailu ri janin saraka janin diya mɛn kan ka a kɛ buuri ri, Besalɛli ka wo ladan kasiya jiri la. Sarakabɔdiya fan naanin bɛɛ kanyara. A fan kelen kelenna bɛɛ kɛra nunkan ɲa loolu ri. A lɔ kɛra nunkan ɲa sawa ri. ");
INSERT INTO msc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","A ka kere kelen kelenna ladan saraka janin diya tonkon naanin bɛɛ la. Sarakabɔdiya ni kereilu bɛɛ tɛrɛ ye fen kelen de ri. Besalɛli ka sulanɛɛ la a yɔrɔ bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","A ka buurigbɛ kɛ muranilu ladan, a ni buurigbɛ tafenilu ni jeli kɛ muranilu ni sobo sɔɔlanilu ni takisɛ kɛ fenilu. A ka saraka janin diya muran woilu bɛɛ ladan sulanɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","A ka sansan sulanɛɛlaman ladan, ka wo bila saraka janin diya kɔndɔ. A ka a bila da kirinkirin kɔrɔ saraka janin diya lɔ tɛmala rɔ. ");
INSERT INTO msc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","A ka koyina sulanɛɛlamanilu ladan sansan wo tonkon naanin na, tonkon kelen koyina kelen. Sarakabɔdiya madonni gbelekeilu ri don koyina woilu rɔ. ");
INSERT INTO msc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","A ka gbelekeilu rabɛn kasiya jiri la ka sulanɛɛ la woilu yɔrɔ bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","A ka gbeleke woilu don koyina sulanɛɛlamanilu rɔ saraka janin diya fan fila bɛɛ fɛ, sa mɔɔilu ri se saraka janin diya madonninna. A ka saraka janin diya ladan jiri fɛrɛnilu la, ka a kɔndɔ rakolon to. ");
INSERT INTO msc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Muso mɛnilu tɛrɛ ye ii ladɛnna faaninbon da la ka faaninbon baara kɛ, woilu ka ii la dubalenilu di. Besalɛli ka woilu ta ka koli muran ba sulanɛɛlaman ni a siifenju sulanɛɛlaman nadan woilu la. ");
INSERT INTO msc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","A ka lukɔndɔla laminin faaninilu ladan faaningbɛ ɲumailu la. Lukɔndɔla laminin faanin mɛn di dun faaninbon tele kankan bolokinin fan fɛ, wo janya kɛra nunkan ɲa kɛmɛ ri. ");
INSERT INTO msc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Faanin wo duntɔ samasen muwan de la. Besalɛli ka samasen woilu ladan, a ni ii siifenju sulanɛɛlaman, samasen kelen siifenju kelen. Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu kɛra samasen na. ");
INSERT INTO msc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Lukɔndɔla laminin faanin mɛn di dun faaninbon tele kankan bolomaran dɔ, wo fanan janya kɛra nunkan ɲa kɛmɛ ri. Faanin woilu duntɔ samasen muwan de la, mɛnilu kelen kelenna siini a siifenju sulanɛɛlaman kan. Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu kɛra samasen na. ");
INSERT INTO msc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Faaninbon telebe rɔ, faanin janya kɛra nunkan ɲa biloolu ri. Faanin woilu duntɔ samasen tan de la, mɛnilu kelen kelenna siini a siifenju kan. Sɔɔlan wodigbɛlamanilu ni faanindun koyina wodigbɛlamanilu kɛra samasen na. ");
INSERT INTO msc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Faaninbon telebɔ rɔ, lukɔndɔla janya kɛra nunkan ɲa biloolu ri. ");
INSERT INTO msc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Lukɔndɔla donda kɛra fan wo fɛ. Donda fan fila bɛɛ fɛ, faaninilu janya kɛra nunkan ɲa tan ni loolu ri. Faanin woilu duntɔ samasen sawa sawa le la, mɛnilu kelen kelenna siini a siifenju kan. ");
INSERT INTO msc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Lukɔndɔla laminin faaninilu bɛɛ rabɛnni faaningbɛ ɲuma la. ");
INSERT INTO msc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Samasen siifenju ladanni sulanɛɛ la. Sɔɔlan ni koyina mɛnilu tɛrɛ ye samasen na, woilu bɛɛ ladanni wodigbɛ la. Wodigbɛ lara samasen bɛɛ kun na. Koyina wodigbɛlaman tɛrɛ ye samasen bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Mɛn kusan faanin sɔɔ la, wo ka lu donda faanin dabɛn faaningbɛ ɲuma la, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Wo janya kɛra nunkan ɲa muwan di. A lɔ kɛra nunkan ɲa loolu ri, ikomin lukɔndɔla laminin faaninilu lɔ. ");
INSERT INTO msc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","A samasen naanin ni woilu siifenju naanin nadanni sulanɛɛ la. Sɔɔlan ni koyina mɛnilu tɛrɛ ye samasen na, woilu bɛɛ ladanni wodigbɛ la. Wodigbɛ lara samasen bɛɛ kun na. ");
INSERT INTO msc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Faaninbon ni a laminin faaninilu ri sidi bɔlɔ mɛnilu la duu ma, woilu fanan nadanni sulanɛɛ la. ");
INSERT INTO msc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","23","Allabatala ka mɛn fɔ Musa yɛ, Uri dencɛ Besalɛli ka wo bɛɛ ladan. Yahuda kabila mɔɔ le a ri. A benba ye Huri le ri, Uri fa kɔnin. Besalɛli dɛmɛnba le tɛrɛ Ahisamaki dencɛ Oholiyabu ri, ni a ye Daan kabila mɔɔ ri. Oholiyabu tɛrɛ ye bololabaara ɲuma le ri. A tɛrɛ ye kolɔnna le ri, mɛn tɛrɛ ye fen ɲatɔnɔmailu ni fen kenɲiilu ladanna. Faanin sɔɔla tɛrɛ ye a ri fanan, mɛn tɛrɛ ye faaningbɛ ɲuma sɔɔla kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la. Nba, Alla daa makɛ faaninbon mɛn ye Alla la teriya tɔɔmasere daa makɛ faaninbon di. Faaninbon wo ladanda fen mɛnilu la, Musa ka a fɔ Lebi bɔnsɔn mɔɔilu yɛ ko ii ye wo jatebɔ ka a bɛɛ sɛbɛ. Alla sarakabɔla Haruna dencɛ Itamari tɛrɛ ye jatebɔ baara wo kuntii le ri. Ii ka mɛnilu sɛbɛ, woilu le ɲin di. ");
INSERT INTO msc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Isirayɛlikailu ka sanin mɛnilu kɔrɔta Allabatala ɲakɔrɔ ka a di a ma, woilu kɛra kilo waa kelen de ri. Woilu bɛɛ donda yɔrɔ sɛniman baara rɔ. ");
INSERT INTO msc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Isirayɛlika mɛnilu tɔɔ sɛbɛra jama jatebɔ waati, woilu ka wodigbɛ di wo waati. Ii ka jate mɛn di, wo bɛɛ ladɛnnin kɛra kilo waa sawa ni kilo kɛmɛ naanin ni kilo muwan de ri. ");
INSERT INTO msc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Mɔɔ mɛnilu sɔrɔn tun da san muwan bɔ, woilu ni woilu kɔrɔilu bɛɛ tɔɔ sɛbɛra. Ii bɛɛ ladɛnnin kɛra mɔɔ waa kɛmɛ wɔɔrɔ ni mɔɔ waa sawa ni mɔɔ kɛmɛ loolu ni mɔɔ biloolu. Ii kelen kelenna bɛɛ ka wodigbɛ karamun wɔɔrɔ bɔ. Yɔrɔ sɛniman jateli bɛnni karamun tan ni fila le ma. Ii bɛɛ ka wo tala bɔ ten. ");
INSERT INTO msc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Besalɛli ka wodigbɛ kilo waa sawa ni kilo kɛmɛ naanin ta wo rɔ ka wo yelen ka siifenju kɛmɛ ladan, mɛnilu ri bila faaninbon jiriilu kɔrɔ, a ni faaninbon tatɛɛfaanin samasen kɔrɔ, siifenju kelen, wodigbɛ kilo bisawa ni kilo naanin. ");
INSERT INTO msc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Wodigbɛ kilo muwan tora. A ka wo ta ka samasen sɔɔlanilu ni koyinailu ladan, ka do fanan la samasen kun na. ");
INSERT INTO msc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Isirayɛlikailu ka sulanɛɛ mɛnilu kɔrɔta Allabatala ɲakɔrɔ ka a di a ma, woilu kɛra kilo waa fila ni kilo kɛmɛ naanin ni kilo muwan ni kelen de ri. ");
INSERT INTO msc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","A ka siifenju ladan sulanɛɛ woilu la, siifenju mɛnilu ri bila faaninbon donda samasen kɔrɔ. Ii ka saraka janin diya sulanɛɛlaman fanan nadan sulanɛɛ woilu la, a ni a sansan sulanɛɛlaman ni a muranilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","A ka siifenju gbɛrɛilu fanan nadan sulanɛɛ woilu la. Siifenju woilu ri bila lukɔndɔla laminin samasen kɔrɔ, a ni lu donda samasen kɔrɔ. Faaninbon ni a laminin faaninilu ri sidi bɔlɔ mɛnilu la duu ma, a ka woilu fanan nadan sulanɛɛ woilu la. ");
INSERT INTO msc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nba, ii ka kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ta ka faanin kenɲi bailu ladan, Alla la sarakalaselailu ri mɛnilu bila ii kan na ii don tuma yɔrɔ sɛniman kɔndɔ ka Alla la baara kɛ. Ii ka faanin sɛnimanilu fanan kara Haruna yɛ ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ii ka kɔkanbila durukini ladan sanin na, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni faaningbɛ ɲuma la. ");
INSERT INTO msc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ii ka sanin gbasi kosɛbɛ ka a fɛya, ka a ratɛɛ. Ii ka sanin wo ta ka a don don faaningbɛ ɲuma rɔ, ka a don don kari buleman fanan dɔ, a ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi. Mɛnilu kusan bololabaara kɛla kosɛbɛ ri baara wo kɛ. ");
INSERT INTO msc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ii ka kanbankun julu kelen kelen bila kɔkanbila durukini tonkon fila la, sa a ri se tuunna i ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ii ka tɛsidilan ɲuma ɲuma kɛ kɔkanbila durukini la. Tɛsidilan ni kɔkanbila durukini kɛra fen kelen di. Ii la baaraɲa kanyara fanan. Ii ka tɛsidilan kara kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni faaningbɛ ɲuma la, a ni sanin na, ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ii ka onikisi kabakurun fila rabɛn ka ii don fendamirafen saninnamanilu rɔ, kabakurun kelen fendamirafen kelen. Ii ka Isirayɛli dencɛilu tɔɔ sɛbɛ kabakurun woilu kan ikomin sɛbɛli ye kɛla kabakurun kan ɲa mɛn ma ka a kɛ ɲanɔɔ ri. ");
INSERT INTO msc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Wo kɔ rɔ, ii ka kabakurun woilu bila kɔkanbila durukini kanbankun julu fila la, ka ii kɛ hankili bilafenilu ri Isirayɛlikailu la ko rɔ ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Mɛn kusan bololabaara kɛla kosɛbɛ, wo ka sisirɔ bɔrɔni ladan. A ka a ladan sanin na, a ni kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la, a ni faaningbɛ ɲuma la ikomin kɔkanbila durukini ladanda ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ni sisirɔ bɔrɔni wo lakadira ka a la i ɲɔɔn kan, a fan naanin bɛɛ ri kanya. A janya ni a bonya bɛɛ kɛra sinbiri ɲa kelen di. ");
INSERT INTO msc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ii ka a masidi kabakurun sankɔgbɛlɛnilu la, ka woilu nara a la ka kɛ safa naanin di. A safa fɔlɔ kɛra saridiwan kabakurun ri, a ni topase kabakurun ni emerada kabakurun. ");
INSERT INTO msc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","A safa filana kɛra karibunkili kuru ri, a ni safiri kuru ni jaman. ");
INSERT INTO msc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","A safa sawana kɛra jasinti kuru ri, a ni akate kuru ni ametisi kuru. ");
INSERT INTO msc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","A safa naaninna kɛra kirisaliti kuru ri, a ni onikisi kuru ni jasipe kuru. Kuru woilu bɛɛ donda fendamirafen saninnamanilu rɔ, kuru kelen fendamirafen kelen. ");
INSERT INTO msc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kabakuru bɛɛ ladɛnnin kɛra tan ni fila ri, ka a bɛn Isirayɛlikailu la kabilailu jate ma. Ii tɔɔilu sɛbɛra nɛɛ la kabakurunilu kan, kabakurun kelen tɔɔ kelen. Tɔɔilu sɛbɛra ikomin tɔɔ ye sɛbɛla ɲa mɛn ma ɲanɔɔ kan. ");
INSERT INTO msc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ii ka julu saninnaman fila ladan, mɛnilu ri bila sisirɔ bɔrɔni la. Ii ka ii ladan sanin jɛrɛwolo la, ka a mɔrɔmɔrɔ ikomin julukisɛ ye mɔrɔmɔrɔla ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ii ka fendamirafen saninnaman fila ni koyina saninnaman fila ladan, ka koyina fila woilu sidi sisirɔ bɔrɔni sanfɛ tonkon fila la. ");
INSERT INTO msc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ii ka julu saninnaman fila woilu kun do don koyinailu rɔ sisirɔ bɔrɔni tonkon fila la ");
INSERT INTO msc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ka ii kun do don fendamirafenilu la, mɛn ye kanbankun julu fila la kɔkanbila durukini ɲɛfɛla rɔ. ");
INSERT INTO msc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ii ka koyina saninnaman fila gbɛrɛ ladan ka woilu sidi sisirɔ bɔrɔni kɔfɛ yɔrɔ la a duuma fan tonkon fila la. ");
INSERT INTO msc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Wo kɔ rɔ, ii ka koyina saninnaman fila gbɛrɛ ladan ka woilu sidi kɔkanbila durukini kanbankun julu fila ɲɛfɛla rɔ. Ii ka ii sidi julu woilu ju kɔrɔ kara diya dafɛ tɛsidilan kun dɔ. ");
INSERT INTO msc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ii ka sisirɔ bɔrɔni koyinailu ni kɔkanbila durukini koyinailu bila i ɲɔɔn na juluɲala bule la, sa sisirɔ bɔrɔni ri to a nɔ rɔ kɔkanbila durukini kan tɛsidilan kun dɔ. Ii ka a kɛ ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Haruna ri kɔkanbila durukini bila durukiba mɛn kan, ii ka wo bɛɛ ladan kari buleman na. Mɛn kusan jese danna ka wo baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ii ka kun don diya woo bɔ a tɛmala rɔ, ka faanin gbiliman kara woo laminin dɔ, sa durukiba kana fara. ");
INSERT INTO msc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ii ka kerenati jiridenilu sawura ta ta kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi ni faaningbɛ ɲuma la durukiba sen kɔrɔlailu dagbolo kan. ");
INSERT INTO msc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ii ka talan denninilu ladan sanin jɛrɛwolo la, ka woilu bila bila durukiba sen kɔrɔlailu dagbolo la kerenati jiridenilu sawura tɛma. ");
INSERT INTO msc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ii ka talan dennin saninnaman do tuun kerenati jiriden sawura kelen kelenna bɛɛ la durukiba dagbolo muumɛ kan. Alla la sarakalasela wa wa wuli a la baara kɛla, a ri durukiba wo bila a kan na ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","28","Ii ka Haruna ni a dencɛilu la duruki kɔrɔbilailu ni kurusi kurunniilu ladan faaningbɛ ɲuma la, ka Haruna la bitiran ni a dencɛilu la fula ɲumailu fanan nadan faaningbɛ ɲuma la. Mɛn kusan jese danna ka wo baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ii ka tɛsidilan nadan faaningbɛ ɲuma la, ka a sɔɔ kari buleman ni kari wulenman ɲalagbɛ ni kari wulenman kadi kadi la ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. Mɛn kusan faanin sɔɔ la ka wo baara kɛ. ");
INSERT INTO msc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ii ka saninfɛdɛ do ladan, mɛn ye kuntiiya tɔɔmasere sɛniman di. Ii ka a ladan sanin jɛrɛwolo la, ka sɛbɛli do kɛ a kan ikomin sɛbɛli ye kɛla ɲanɔɔ kan ɲa mɛn ma. Sɛbɛli wo ka a fɔ ko: «A bilani a dan na Allabatala yɛ.» ");
INSERT INTO msc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ii ka julu buleman sidi saninfɛdɛ wo la, sa a ri se sidila bitiran na mɛn ye a sanfɛ ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nba, ii banda fenilu bɛɛ baarala ten, mɛnilu ri kɛ Alla daa makɛ faaninbon di, Alla Kunbɛn Diya Faaninbon kɔnin. Isirayɛlikailu ka a bɛɛ kɛ ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ii nara Alla daa makɛ faaninbon fen bɛɛ ri Musa ma. Ii nara faaninilu ri, mɛnilu ri kɛ faaninbon jɛrɛ ri, ka na faaninbon kɔndɔfenilu bɛɛ fanan di. Ka a la woilu kan, ii nara fen ɲinilu ri: fendamirafenilu, faanin damira jiriilu, kankan gbelekeilu, samasenilu, a ni siifenjuilu. ");
INSERT INTO msc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ii nara faaninbon kunnabirin fila ri. Do ladanni saaji gboloilu la, mɛnilu ra wulen. A tɔ kelen nadanni gbolo kolonin ɲumailu la. Ii nara bon tatɛɛfaanin fanan di, ");
INSERT INTO msc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","a ni teriya tɔɔmasere kankira ni a gbelekeilu ni a julumun kafari dalatuun. ");
INSERT INTO msc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ii nara tabali fanan di, a ni a muranilu bɛɛ ni saraka buru mɛn di bila tabali kan, mɛn kɔnin dini Allabatala ma. ");
INSERT INTO msc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ii nara fitinasiifen di, mɛn nadanni sanin jɛrɛwolo la. A fitinailu siini tɛrɛ a kan. Ii nara fitinasiifen muranilu bɛɛ fanan di, a ni fitina tulu. ");
INSERT INTO msc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Wusulanjanin saraka janin diya saninnaman fanan nara ii bolo, a ni suwandili tulu, a ni wusulan suma duman, a ni faanin mɛn di dun faaninbon donda la. ");
INSERT INTO msc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ii nara saraka janin diya sulanɛɛlaman di, a ni a sansan sulanɛɛlaman, ni a gbelekeilu ni a muranilu bɛɛ. Koli muran ba nara ii bolo, a ni a siifenju. ");
INSERT INTO msc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ii nara lukɔndɔla laminin faaninilu ri, a ni samasen ni woilu siifenju, ka na faaninbon donda faanin fanan di. Faaninbon lukɔndɔla laminin faaninilu ri sidi bɔlɔ mɛnilu la duu ma, ii nara woilu fanan di, a ni ii juluilu. Ii nara fen bɛɛ ri, mɛnilu bilatɔ Alla daa makɛ faaninbon kɔndɔ, Alla Kunbɛn Diya Faaninbon kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ii nara faanin kenɲi bailu le ri, Alla la sarakalasela Haruna la faanin sɛnimanilu ni a dencɛilu la faaninilu kɔnin. Haruna ni a dencɛilu ri faanin woilu bila ii kan na ka Alla sarakalasela baara kɛ yɔrɔ sɛniman kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isirayɛlikailu ka fen wo bɛɛ baara ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa ka fen woilu bɛɛ ragbɛ kosɛbɛ. A ka a yen ko ii ka baara wo bɛɛ kɛ ikomin Allabatala tun ka a fɔ ɲa mɛn ma. Wo rɔ, Musa ka duwawu kɛ ii yɛ. ");
INSERT INTO msc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Allabatala ka a fɔ Musa yɛ ko: ");
INSERT INTO msc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«San karo fɔlɔ tele fɔlɔ lon, i ye n daa makɛ faaninbon lɔ, n daa makɛ faaninbon kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","I ye teriya tɔɔmasere kankira bila a kɔndɔ bon tatɛɛfaanin kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","I ye tabali ladon faaninbon kɔndɔ ka buruilu bila a kan, a ni tabali muranilu bɛɛ. Wo kɔ rɔ, i ye fitinasiifen nadon faaninbon kɔndɔ ka fitinailu sii sii a kan. ");
INSERT INTO msc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","I ye wusulanjanin saraka janin diya saninnaman sii teriya tɔɔmasere kankira ɲɛfɛ, ka donda faanin dun faaninbon donda la. ");
INSERT INTO msc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Saraka ri janin ka kɛ buuri ri saraka janin diya mɛn kan, i ye wo sii Alla daa makɛ faaninbon donda la, Alla Kunbɛn Diya Faaninbon kɔnin. ");
INSERT INTO msc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","I ye koli muran ba sii Alla kunbɛn faaninbon ni saraka janin diya tɛma ka ji kɛ a rɔ. ");
INSERT INTO msc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","I ye laminin faanin dun lukɔndɔla laminin dɔ, ka donda faanin dun lu da la. ");
INSERT INTO msc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«I ye suwandili tulu ta ka do mun n daa makɛ faaninbon ma, a ni a kɔndɔfenilu bɛɛ. Wo rɔ, i ri a ni a muran bɛɛ bila a dan na ka ii kɛ fen sɛnimanilu ri, mɛn ye n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Saraka di janin ka kɛ buuri ri saraka janin diya mɛn kan, i ye suwandili tulu do mun wo fanan kan, a ni a muran bɛɛ. Wo rɔ, i ri saraka janin diya bila a dan na ka a kɛ fen sɛniman ba ri, mɛn ye n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","I ye suwandili tulu do mun koli muran ba fanan ma, a ni a siifenju. Wo rɔ, i ri ii bila a dan na ka a kɛ n ta ri. ");
INSERT INTO msc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«I ye Haruna ni a dencɛilu lana n kunbɛn faaninbon da la ka ii ko ji la. ");
INSERT INTO msc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Wo wa kɛ, i ye faanin sɛniman woilu bila Haruna kan na, ka suwandili tulu do mun a ma. Wo rɔ, i ri a bila a dan na n na sarakalasela baara kɛ kanma. ");
INSERT INTO msc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","I ye a dencɛilu lana ka duruki kɔrɔbilailu bila ii kan na. ");
INSERT INTO msc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","I ye suwandili tulu mun ii ma ikomin i ka do mun ii fa fɔlɔ ma ɲa mɛn ma, sa ii ri n na sarakalasela baara kɛ. I wa tulu wo mun ii ma ten, ii ni ii bɔnsɔn cɛɛilu ri kɛ Alla la sarakalaselailu ri kadawu.» ");
INSERT INTO msc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Allabatala ka mɛnilu fɔ Musa yɛ, Musa ka wo bɛɛ kɛ a ɲa ma. ");
INSERT INTO msc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","San filana karo fɔlɔ, wo tele fɔlɔ lon, a ka Alla daa makɛ faaninbon lɔ. ");
INSERT INTO msc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa kɛra baara bɛɛ kuntii ri. Ii ka siifenju bila bila, ka faaninbon damira jiriilu lɔ, ka kankan gbelekeilu don ii rɔ, ka samasen lɔ. ");
INSERT INTO msc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ii ka kunnabirin kɛ faaninbon kun na, ka kunnabirin filana la fɔlɔma kan. Ii ka wo kɛ ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ii ka walan kabalaman fila bila teriya tɔɔmasere kankira kɔndɔ, ka kankira gbelekeilu don a koyinailu rɔ, ka a julumun kafari dalatuun la a kan. ");
INSERT INTO msc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ii ka teriya tɔɔmasere kankira wo ladon faaninbon kɔndɔ, ka bon tatɛɛfaanin sidi ka kankira ɲamadoon. Ii ka wo kɛ ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ii ka tabali ladon faaninbon kɔndɔ ka a sii faaninbon tele kankan bolomaran dɔ bon tatɛɛfaanin ɲɛfɛ. ");
INSERT INTO msc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ii ka saraka buruilu sii tabali kan Allabatala ɲakɔrɔ, ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Wo kɔ rɔ, ii ka fitinasiifen nadon faaninbon kɔndɔ ka a lalɔ faaninbon tele kankan bolokinin dɔ, ka a ɲabɛn tabali la. ");
INSERT INTO msc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ii ka fitinailu sii fitinasiifen kan Allabatala ɲakɔrɔ ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ii ka saraka janin diya saninnaman nadon faaninbon kɔndɔ ka a sii tatɛɛfaanin ɲɛfɛ, ");
INSERT INTO msc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ka wusulan sumaduman janin a kan ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Wo kɔ rɔ, ii ka donda faanin sidi faaninbon da la. ");
INSERT INTO msc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Saraka di janin ka kɛ buuri ri saraka janin diya mɛn kan, ii ka wo sii Alla daa makɛ faaninbon da la, Alla Kunbɛn Diya Faaninbon kɔnin, ka ban ka kolofen sarakailu janin saraka janin diya wo kan ka ii kɛ buuri ri. Ii ka suman sarakailu fanan bɔ saraka janin diya wo kan. Ii ka wo kɛ ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ii ka koli muran ba sii faaninbon ni saraka janin diya tɛma, ka ji kɛ a kɔndɔ koli kanma. ");
INSERT INTO msc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa ni Haruna ni a dencɛilu ka ii boloilu ni ii senilu mako ji wo rɔ. ");
INSERT INTO msc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ka a ta wo lon ma, ii wa ii don faaninbon na tuma tuma, a ni ii wa kɛ ii madonna saraka janin diya la tuma tuma, ii ri ii ko ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ii ka lukɔndɔla laminin faanin dun samasen na ka faaninbon ni saraka janin diya laminin, ka donda faanin fanan dun lu da la. Nba, Musa banda baara bɛɛ la wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Wo kɔ rɔ, sanfin jiira ka birin Alla Kunbɛn Diya Faaninbon kun na, Alla daa makɛ faaninbon kɔnin. Allabatala la nɔɔrɔ ka faaninbon nafa. ");
INSERT INTO msc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa ma se donna Alla Kunbɛn Diya Faaninbon kɔndɔ, Alla daa makɛ faaninbon kɔnin, baa sanfin birinni tora a kun na. Ka a la wo kan, Allabatala la nɔɔrɔ tun da a lafa. ");
INSERT INTO msc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ni sanfin wo tun kɔrɔtara ka bɔ faaninbon kun na tuma tuma, Isirayɛlikailu tun di sila mira ka wa. A kɛra wo ɲa le ma ii la taama bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kɔni ni sanfin tun ma kɔrɔta, ii tun tɛ bɔla ii nɔ rɔ. Ii tun di makɔnɔni kɛ fɔɔ sanfin wa kɔrɔta lon mɛn kokura. ");
INSERT INTO msc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Allabatala la sanfin tɛrɛ ye faaninbon kun na tele rɔ. Ta tɛrɛ ye mɛlɛnmɛlɛnna sanfin dɔ su rɔ Isirayɛlikailu bɛɛ ɲakɔrɔ. A kɛra wo ɲa le ma ii la taama bɛɛ rɔ.");
INSERT INTO msc_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Allabatala la baaraden Musa sani kɔ, Allabatala kumara Musa dɛmɛnba Josuwe yɛ, mɛn ye Nun dencɛ ri. ");
INSERT INTO msc_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Allabatala ka a fɔ ko: «N na baaraden Musa ra sa. I wuli sisen ka Juridɛn Ba tɛɛ, i ni jama bɛɛ. Ai ye don jamana kɔndɔ, n kɛtɔ mɛn dila ai Isirayɛlikailu ma. ");
INSERT INTO msc_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ni ai sera yɔrɔ yɔrɔ rɔ, n di yɔrɔ wo di ai ma ikomin n ka lahidi ta Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Ka bɔ wula tele kankan bolokinin dɔ, ka wa se fɔɔ Lebanon koyinkɛ ma yɔrɔ tele kankan bolomaran dɔ, duu wo bɛɛ ri kɛ ai ta ri. Ka bɔ Efirati Ba da la telebɔ rɔ, ka tamin Hɛtikailu la jamana bɛɛ la, ka wa telebe rɔ fɔɔ ka dan kɔɔji la, wo bɛɛ ri kɛ ai ta ri. ");
INSERT INTO msc_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","I juu si ti se i la kɛlɛ rɔ i si bɛɛ kɔrɔ. N di kɛ i fɛ ikomin n kɛra Musa fɛ ɲa mɛn ma. N tɛ bɔ i fɛ; n tɛ i bila. ");
INSERT INTO msc_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","«I jusulatɛɛ ka kɛ jusu ragbɛlɛn di, baa i ri i lɔ jama ɲɔrɔ ka jamana wo mira ka a kɛ ii ta ri, ikomin n ka lahidi ta ii benbailu yɛ. ");
INSERT INTO msc_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","I jusulatɛɛ ka kɛ jusu ragbɛlɛn di dɔrɔn. N na baaraden Musa ka sariya mɛnilu di i ma, i ye wo bɛɛ taama a ɲa ma. I kana bɔ sila wo kan ka wa fan si fɛ. Ni i ka sila wo lataama a ɲa ma, i la ko kɛtailu bɛɛ ri sabati. ");
INSERT INTO msc_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","N na sariya kitabu kumailu ye kɛ i da rɔ waati bɛɛ. I ye i miri woilu ma su ni tele, sa fen fen sɛbɛni kitabu wo kɔndɔ, i ri wo bɛɛ mira ka kɛ a ɲa ma. Ni wo kɛra, i la ko bɛɛ ri sabati kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","N ma a fɔ i yɛ wa ko i ye i jusulatɛɛ ka kɛ jusu ragbɛlɛn di? I kana silan, i kana yɛrɛyɛrɛ, baa i Maari Allabatala ye i fɛ i la ko kɛtailu bɛɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Wo rɔ, Josuwe ka a fɔ jama kuntiilu yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","«Ai ye tamin daa makɛ diya rɔ ka a fɔ mɔɔilu bɛɛ yɛ ko: ‹Ai ye dɔɔnnifen dabɛn, baa yani tele sawa ai ri Juridɛn Ba tɛɛ ka don jamana wo kɔndɔ ka a kɛ ai ta ri, Maari Allabatala kɛtɔ jamana mɛn dila ai ma.›» ");
INSERT INTO msc_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Josuwe kumara Rubɛn kabila yɛ, a ni Kadi kabila ni Manase kabila talantɛ. A ka a fɔ ii yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","«Allabatala la baaraden Musa ka mɛn fɔ ai yɛ, ai ye hankili to wo rɔ. A ka a fɔ ko ai Maari Allabatala ri ai lasii hɛrɛ rɔ yan ka duu ɲin di ai ma, an ye duu mɛn kan bi. ");
INSERT INTO msc_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","15","Wo le rɔ, ai muso ni ai denilu ni ai la kolofenilu ri to ai la jamana rɔ yan, Musa ka jamana mɛn di ai ma Juridɛn Ba telebɔ rɔ yan. Kɔnin ai mɛnilu ye kɛlɛkɛ cɛɛilu ri, ai bɛɛ ye ai la kɛlɛkɛfenilu ta ka ba tɛɛ ai badenma doilu ɲɛrɔ. Ai ye wa ii dɛmɛn fɔɔ Allabatala wa ii fanan nasii hɛrɛ rɔ, ikomin a ka ai lasii hɛrɛ rɔ yan ɲa mɛn ma. Ai Maari Allabatala ye jamana wo dila ai badenmailu ma. Ai ye wa ii dɛmɛn fɔɔ ii wa jamana wo kɛ ii ta ri. Ii wa ban jamana mirala, ai ri ai kɔsɛ ka na jamana ɲin dɔ yan, Allabatala la baaraden Musa ka mɛn di ai ma ka a kɛ ai ta ri Juridɛn Ba telebɔ rɔ yan.» ");
INSERT INTO msc_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Rubɛn kabila, ni Kadi kabila, ni Manase kabila talantɛ ka Josuwe jabi: «Ni i ka fen fen fɔ an yɛ, an di wo kɛ. Ni i ka an kelaya ka wa yɔrɔ yɔrɔ, an di wa ye. ");
INSERT INTO msc_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","An di i kan mira ko bɛɛ rɔ, ikomin an ka Musa kan mira ɲa mɛn ma. I Maari Allabatala ye to i fɛ ikomin a tora Musa fɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Mɔɔ mɛn wa murunti i kanma ka a ban i kan mirala an di wo faa. Ile kɔnin ye i jusulatɛɛ tuun ka kɛ jusu ragbɛlɛn di.» ");
INSERT INTO msc_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Nba, ka Isirayɛlikailu daa makɛni to Sitimu, Nun dencɛ Josuwe ka mɔɔ fila lawa ko: «Ai ye wa Kanaan jamana lakɔrɔsi dokon dɔ, katɛrɛtɛ Jeriko so.» Ii bɔra ye ka wa. Ii sera Jeriko so kɔndɔ tuma mɛn na, ii wara jiya sunkurunba do kan. A tɔɔ ko Rahabu. ");
INSERT INTO msc_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","A fɔra Jeriko mansa yɛ ko: «I ɲa lɔ! Isirayɛlika doilu donda so kɔndɔ su rɔ. Ko woilu nani jamana lakɔrɔsi kan de ma.» ");
INSERT INTO msc_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Wo rɔ, mansa ka kela lawa Rahabu ma ko: «Cɛɛ mɛnilu nani jiyala i wara, i ye ii labɔ ka ii don an bolo, baa woilu nani an na jamana lakɔrɔsi kan de ma.» ");
INSERT INTO msc_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Rahabu ka cɛɛ fila woilu dokon, ka wa a fɔ mansa la keladenilu yɛ ko: «Tuɲa le. Mɔɔ woilu nara n wara yan. Kɔnin n tun ma ii bɔ diya lɔn. ");
INSERT INTO msc_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Su kora tuma mɛn na, ii bɔra yan ka wa, ka a tɛrɛn mɔɔilu watɔ so donda tuun diya. N ma a lɔn ii wara diya mɛn dɔ. Ai ye ai kaliya ka wa ii kɔ, ai ri kɛ ii rɔ ka ii mira.» ");
INSERT INTO msc_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Kɔnin Rahabu tun wara cɛɛ fila woilu ri a la bon kun bilinin kan ka ii ladoon bin kala doilu kɔrɔ bin mɛn tɔɔ ko lin, a tun ka kala mɛnilu bila ye kɔrɔman janin kanma. ");
INSERT INTO msc_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Nba, mansa la keladenilu bɔra ye ko ii watɔ mɔɔ woilu kɔ. Mɔɔilu ye Juridɛn Ba tɛɛla diya mɛn dɔ ii sen ma, keladenilu wara diya wo sila fɛ. Ii bɔni so donda la, mɔɔilu ka da wo tuun i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Sani cɛɛ fila ye sunɔɔ, Rahabu yɛlɛra a la bon kun bilinin kan, ");
INSERT INTO msc_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ka a fɔ ii yɛ ko: «N ka a lɔn ko Allabatala ra an na jamana ɲin di ai Isirayɛlikailu ma. Ai ɲɛsilanɲɛ ra an bɛɛ mira yan. Jamana mɔɔ bɛɛ jiitɛɛniba le, ");
INSERT INTO msc_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","baa a fɔra an ɲana ko ai bɔtɔla Misiran jamana rɔ tuma mɛn na, ko Allabatala ka Kɔɔji Fararɔbin ja ai ɲɛrɔ. Ai ka mɛn kɛ Amɔrikailu la mansa fila la Juridɛn Ba telebɔ rɔ, mansa Sihɔn ni mansa Ɔki kɔnin, wo fanan fɔra an ɲana. Ko ai ka woilu halaki fewu. ");
INSERT INTO msc_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Wo fɔra an ɲana tuma mɛn na, an jiitɛɛra kosɛbɛ. Jusulatɛɛ tɛ mɔɔ si la yan ka ai kɛlɛ, baa ai Maari Allabatala siini fen bɛɛ kun na sankolo rɔ, a ni duukolo kan yan. ");
INSERT INTO msc_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Nba, n da koɲuma kɛ ai yɛ. Sisen ai ye ai kali Allabatala tɔɔ la n yɛ ko ai ri koɲuma kɛ n fa la denbaya yɛ. Ai ye tɔɔmasere do yiraka n na, sa n di se lala ai la. ");
INSERT INTO msc_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Ai ye lahidi ta n yɛ ko ai ri n fa ni n na kisi, a ni n badenmacɛilu ni n badenmamusoilu, a ni ii la denbayailu bɛɛ. Ko ai ti sɔn mɔɔilu ye an faa.» ");
INSERT INTO msc_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Cɛɛ woilu ka Rahabu jabi: «Ni ai faara, Alla ye an fanan faa! Kɔnin i kana foyi fɔ mɔɔ gbɛrɛ yɛ an na ko rɔ jamana ɲin kɔndɔ yan. Wo rɔ, Allabatala wa jamana ɲin di an ma, an di an na kaninteya ni an na kankelentiiya yiraka i la.» ");
INSERT INTO msc_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Wo rɔ, Rahabu ka cɛɛ fila lajii julu la bon fɔɲɔ don da fɛ sa ii ri wa, baa Rahabu la bon lɔni tɛrɛ so laminin jin de kɔndɔ. Fɔɲɔ don da wo bɛnni so kɔkan la le ma. ");
INSERT INTO msc_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Awa, Rahabu ka a fɔ ii yɛ ko: «Ai ye wa koyinkɛ ma yɔrɔ rɔ, sa ai kana bɛn mɔɔ woilu la, mɛnilu kɔnin ye ai kɔ. Ai ye wa ai dokon yɔrɔ wo rɔ ka tele sawa kɛ ye. Wo ri a tɛrɛn mɔɔ woilu ra i kɔsɛ ka na so kɔndɔ yan. Wo rɔ, ai ri sila ta ka wa.» ");
INSERT INTO msc_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Cɛɛ fila ka a fɔ a yɛ ko: «I ka a fɔ an yɛ ko: A mafɛnɛ, an ye bɔla kali kan mɛn di, i ka an ko an ye an kali ɲa mɛn ma, ni kali kan wo tɛ tiɲan, ");
INSERT INTO msc_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","andeilu Isirayɛlikailu wa don ai la jamana kɔndɔ yan tuma mɛn na, i ye julu wulenman ɲin sidi fɔɲɔ don da la, i kɛtɔ an najiila fɔɲɔ don da mɛn fɛ. I ye i la mɔɔilu bɛɛ ladɛn i fɛ bon kɔndɔ yan. I fa wo, i na wo, i badenmailu wo, i la denbayailu wo, i ye woilu bɛɛ ladɛn bon kɔndɔ yan. ");
INSERT INTO msc_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ni i la mɔɔ do bɔra bon na ka wa so kɔndɔ ka faa, wo hakɛ tɛ andeilu ma, baa a jɛrɛ le ka wo ɲinin. Kɔni ni kojuu do kɛra mɔɔ do la, mɛn ye i fɛ i la bon kɔndɔ yan, wo hakɛ ye andeilu ma. ");
INSERT INTO msc_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Kɔni ni i ka an na ko fɔ mɔɔ gbɛrɛ yɛ, an ka kalili kan mɛn ta i yɛ ɲin, an tɛ nala wo dafala butun.» ");
INSERT INTO msc_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Rahabu ka a fɔ, ko: «Ale le wo ri. N da sɔn wo ma.» Wo rɔ, a ka sila di cɛɛ fila wo ma. Ii wani kɔ, Rahabu ka julu wulenman sidi a la fɔɲɔ don da la. ");
INSERT INTO msc_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Ii wara koyinkɛ ma yɔrɔ rɔ ka ii dokon, ka tele sawa kɛ ye. Mansa la keladenilu ka ii ɲinin sila fan bɛɛ rɔ tele sawa wo kɔrɔ ka kaɲa. Mansa la keladenilu ma ii yen tuma mɛn na, ii ka i kɔsɛ ka wa Jeriko. ");
INSERT INTO msc_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Wo rɔ, cɛɛ fila jiira ka bɔ koyinkɛ ma yɔrɔ rɔ ka Juridɛn Ba tɛɛ ka wa Nun dencɛ Josuwe tɛrɛn ye. Ko mɛn bɛɛ kɛra ii la taama rɔ, ii ka woilu bɛɛ ɲafɔ Josuwe yɛ. ");
INSERT INTO msc_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ii ka a fɔ a yɛ ko: «Sika tɛ a rɔ: Allabatala ra jamana bɛɛ di an ma. Ye mɔɔilu silanni an yɛ fo ka ii jiitɛɛ.» ");
INSERT INTO msc_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Nba, wo duusa gbɛ, Josuwe ni Isirayɛlikailu bɛɛ wulira sɔɔma da la jona ka bɔ Sitimu ka wa Juridɛn Ba da la. Ii seni ye, ii wara ii daa makɛ ba da la sani ii ye ba tɛɛ. ");
INSERT INTO msc_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Tele sawa taminni kɔ, jama kuntiilu taminda daa makɛ diya yɔrɔ bɛɛ rɔ, ");
INSERT INTO msc_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ka a fɔ mɔɔilu yɛ ko: «Ai wa Lebi bɔnsɔn Alla la sarakalaselailu yen bɔla daa makɛ diya rɔ ai Maari Allabatala la teriya tɔɔmasere kankira ri tuma mɛn na, ai ye bɔ ai wara ka ai bila ii kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ii ri lɔ ai ɲɔrɔ. Ai ye kilo kelen to ai ni teriya tɔɔmasere kankira tɛma. Ai kana ai madon a la kojuuya. Wo rɔ, ai ka kan ka sila mɛn ta ai ri a lɔn, baa ai watɔ sila mɛn fɛ, ai ma sila wo taama fɔlɔ munun.» ");
INSERT INTO msc_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Josuwe ka a fɔ mɔɔilu yɛ ko: «Ai ye ai jɛrɛ sɛninya, baa Allabatala ri kabannako kɛ ai ɲɛ sini.» ");
INSERT INTO msc_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Josuwe ka a fɔ Alla la sarakalaselailu yɛ ko: «Ai ye teriya tɔɔmasere kankira ta ka tamin mɔɔilu ɲɛfɛ.» Wo rɔ, ii ka wo kankira ta ka tamin mɔɔilu ɲɛfɛ. ");
INSERT INTO msc_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Allabatala ka a fɔ Josuwe yɛ ko: «Bi n di i bonya damira Isirayɛlikailu bɛɛ ɲana, sa ii ri a lɔn ko n ye i fɛ, ikomin n tɛrɛ ye Nabi Musa fɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Alla la sarakalasela mɛnilu ye teriya tɔɔmasere kankira tala, i ye a fɔ woilu yɛ ko: ‹Ai wa se Juridɛn Ba da la tuma mɛn na, ai ye jii ji rɔ ka ai lɔ ye.›» ");
INSERT INTO msc_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Josuwe ka a fɔ Isirayɛlikailu yɛ ko: «Ai ye na. Ai Maari Allabatala ka a fɔ ko a kɛtɔ ko mɛnilu kɛla ai yɛ, n di woilu fɔ ai yɛ.» ");
INSERT INTO msc_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Josuwe ka a fɔ, ko: «Ai ri a lɔn ko Alla Ɲɛnɛma ye ai fɛ, wo le ɲin di. Ai ri a lɔn fanan ko a ri jamana mɔɔilu gbɛn ai ɲɛ: Kanaankailu wo, Hɛtikailu wo, Hifikailu wo, Peresikailu wo, Kirikasikailu wo, Amɔrikailu wo, Jebusikailu wo, a ri woilu bɛɛ gbɛn ka ii bɔ ai ɲɛ. ");
INSERT INTO msc_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ai ɲa lɔ! Maari mɛn siini duukolo bɛɛ kun na, a la teriya tɔɔmasere kankira kɛtɔ taminna ai ɲɛ, ka wa jii Juridɛn Ba ji rɔ. ");
INSERT INTO msc_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Sisen ai ye cɛɛ tan ni fila suwandi ka bɔ Isirayɛlikailu la kabila bɛɛ rɔ, kabila kelen cɛɛ kelen. ");
INSERT INTO msc_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ni Alla la sarakalaselailu, mɛn ye Allabatala la teriya tɔɔmasere kankira ladoninna, ni ii sera ji rɔ tuma mɛn na, Juridɛn Ba woyen a ri lɔ i kɔrɔ. Ji ri layɛlɛ i ɲɔɔn kan yɔrɔ kelen san fɛ ka kɛ ikomin dandan.» ");
INSERT INTO msc_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Nba, Isirayɛlikailu bɔra ii daa makɛ diya rɔ ye ko ii watɔ Juridɛn Ba tɛɛla. Alla la sarakalaselailu tɛrɛ ye ii ɲɛfɛ, teriya tɔɔmasere kankira tɛrɛ ye woilu bolo. ");
INSERT INTO msc_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","(Sumanka waati le tɛrɛ; wo waati la, Juridɛn Ba ri fa kojuuya fɔɔ ka bɔn.) Awa, teriya tɔɔmasere kankira tɛrɛ ye Alla la sarakalasela mɛnilu bolo, woilu sera ba ma ka ii sen najii ji rɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ba ji mɛn tɛrɛ ye woyenna ka bɔ ba san dɔ, wo ka a lɔ i kɔrɔ. Ji layɛlɛra i ɲɔɔn kan Adama so da fɛ, mɛn ye Saratani so tɔrɔfɛ. Yɔrɔ wo ka jan tɛrɛ Isirayɛlikailu la. Ji layɛlɛra i ɲɔɔn kan ye ka kɛ ikomin dandan. Ji ma se taminna ye ka woyen ka wa Araba gbɛkannan dɔ, mɔɔilu ye a fɔla mɛn ma ko Dalaba Kɔɔjilama. A kɛra ten de, Isirayɛlikailu bɛɛ sera ba tɛɛla Jeriko so ɲɛtelenma rɔ. ");
INSERT INTO msc_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Nba sarakalaselailu, mɛn madonni tɛrɛ Allabatala la teriya tɔɔmasere kankira, woilu ka ii lɔ duu jaran kan Juridɛn Ba tɛma. Isirayɛlikailu bɛɛ taminda ba tɛma ye duu jaran kan haan jamana mɔɔ bɛɛ sera ye. ");
INSERT INTO msc_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Jama bɛɛ banni Juridɛn Ba tɛɛla tuma mɛn na, Allabatala ka a fɔ Josuwe yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","«Ai ye cɛɛ tan ni fila suwandi jama rɔ, kabila kelen cɛɛ kelen. ");
INSERT INTO msc_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","I ye a fɔ cɛɛ tan ni fila woilu yɛ ko ii bɛɛ ye kabakurun kelen kelen ta Juridɛn Ba tɛma, Alla la sarakalaselailu lɔni yɔrɔ mɛn dɔ. Ii ye kabakurun woilu madonin fo ai wa se ai daa makɛ diya tuma mɛn na. Ii ri kabakurunilu bila ye.» ");
INSERT INTO msc_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Josuwe ka cɛɛ tan ni fila suwandi ka bɔ Isirayɛlikailu rɔ, kabila kelen cɛɛ kelen. A ka woilu makili, ");
INSERT INTO msc_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ka a fɔ ii yɛ ko: «Ai ye wa tamin ai Maari Allabatala la teriya tɔɔmasere kankira ɲɛfɛ ka don Juridɛn Ba tɛmala rɔ. Ai ye kabakurunilu ta ye, mɔɔ kelen kabakurun kelen. Ai wa woilu ta, ai ye ii la ai kanbankun kan, kabila bɛɛ ni a la kabakurun. ");
INSERT INTO msc_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","7","Kabakurun woilu ri kɛ tɔɔmasere ri ai tɛma. Ni ai denilu ka woilu kɔrɔ maɲininka sini natɔ, ai ri a fɔ ii yɛ wo lon, ko Alla la sarakalaselailu ka Allabatala la teriya tɔɔmasere kankira ta ka wa Juridɛn Ba tɛɛ. Ko ii donda ji rɔ tuma mɛn na, ko Juridɛn Ba tɛɛra fila ri Allabatala la teriya tɔɔmasere kankira ɲɛfɛ. Ko kabakurun ɲinilu ye hankilibilafen de ri tuma bɛɛ, ka Isirayɛlikailu hankili bila ko ba wo rɔ.» ");
INSERT INTO msc_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Josuwe ka mɛn fɔ Isirayɛlikailu yɛ, ii ka wo mira ka a kɛ. Ii ka kabakurun tan ni fila ta ka bɔ Juridɛn Ba tɛma, kabila kelen kabakurun kelen, ikomin Allabatala ka a fɔ Josuwe yɛ ɲa mɛn ma. Ii ka kabakurun woilu madonin ka wa ii bila ii daa makɛ diya. ");
INSERT INTO msc_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Josuwe ka kabakurun tan ni fila gbɛrɛ lɔ Juridɛn Ba tɛma ye, Alla la sarakalaselailu lɔni teriya tɔɔmasere kankira ri yɔrɔ mɛn. Kabakurun woilu ye ye hali bi. ");
INSERT INTO msc_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Alla la sarakalaselailu lɔni tora teriya tɔɔmasere kankira ri Juridɛn Ba jani tɛma fo jama banda ko bɛɛ kɛla tuma mɛn na ikomin Allabatala tun ka Josuwe jamari ɲa mɛn ma. Wo bɛɛ kɛra ikomin Musa ka a fɔ Josuwe yɛ ɲa mɛn ma. Jama ka ii kaliya le ka ba tɛɛ. ");
INSERT INTO msc_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Ii bɛɛ banda ba tɛɛla waati mɛn na, Alla la sarakalaselailu bɔra ba tɛmala rɔ, ka tamin jama ɲɛfɛ Allabatala la teriya tɔɔmasere kankira ri. ");
INSERT INTO msc_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Rubɛn kabila cɛɛilu ni Kadi kabila cɛɛilu ni Manase kabila talantɛ cɛɛilu, woilu ka ba tɛɛ Isirayɛlika tɔilu ɲɛrɔ, ii la kɛlɛkɛfenilu ye ii bolo, ikomin Musa tun ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Kɛlɛkɛdenilu waa binaanin ka ba tɛɛ Allabatala ɲakɔrɔ ka wa Jeriko gbɛkannan dɔ. Ii bɛɛ rabɛnni kɛlɛkɛ kanma. ");
INSERT INTO msc_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Wo lon, Allabatala ka Josuwe bonya Isirayɛlikailu bɛɛ ɲana. Ii ka a bonya a si bɛɛ kɔrɔ ikomin ii tun ka Musa bonya ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Nba, Allabatala ka a fɔ Josuwe yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","«Alla la sarakalasela mɛnilu ye Allabatala la teriya tɔɔmasere kankira madoninna, i ye a fɔ woilu yɛ ko ii ye bɔ Juridɛn Ba tɛma.» ");
INSERT INTO msc_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Josuwe ka a fɔ Alla la sarakalaselailu yɛ ko: «Ai ye bɔ Juridɛn Ba tɛma.» ");
INSERT INTO msc_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Wo rɔ, Alla la sarakalaselailu bɔra Juridɛn Ba rɔ teriya tɔɔmasere kankira ri. Ii senilu sera duukolo jani ma tuma mɛn na, Juridɛn Ba ji ka a kɔsɛ a nɔ rɔ i kɔrɔ, ka woyen kojuuya ka yɔrɔ bɛɛ fa ikomin a tɛrɛ ye kɛla ɲa mɛn ma fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Jama ka Juridɛn Ba tɛɛ ii la san karo fɔlɔ tele tan. Ii wara ii daa makɛ Kilikali so dafɛ. Yɔrɔ wo ye Jeriko telebɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Josuwe ka kabakurun tan ni fila woilu lalɔ ye, cɛɛ tan ni fila tun ka mɛnilu ta Juridɛn Ba rɔ. ");
INSERT INTO msc_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","A ka a fɔ Isirayɛlikailu yɛ ko: «Lon do rɔ, ni ai denilu ka ai maɲininka kabakurun ɲinilu kɔrɔ ma, ");
INSERT INTO msc_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","ai ye a fɔ ii yɛ ko Isirayɛlikailu ka Juridɛn Ba tɛɛ ii sen ma duukolo jaran kan. ");
INSERT INTO msc_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Baa ai Maari Allabatala ka Juridɛn Ba ji ja ai ɲɛ haan ai bɛɛ banda ba tɛɛla, ikomin a ka Kɔɔji Fararɔbin ja an ɲɛ ɲa mɛn ma haan an bɛɛ taminda. ");
INSERT INTO msc_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","A ka wo le kɛ, sa dunuɲa mɔɔilu bɛɛ ri a lɔn ko Allabatala la sebaya ka bon. Ka a la wo kan, a ka a kɛ sa ai ri silan ai Maari Allabatala ɲɛ tuma bɛɛ.» ");
INSERT INTO msc_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Amɔrikailu la mansa mɛnilu siini tɛrɛ Juridɛn Ba telebe rɔ, a ni Kanaankailu la mansa mɛnilu siini kɔɔji da la, woilu ka a mɛn ko Allabatala ka Juridɛn Ba ja Isirayɛlikailu ɲɛ haan ii bɛɛ banda taminna. Mansa woilu ka wo mɛn tuma mɛn na, ii silanda. Jusulatɛɛ tun tɛ ii la butun ka Isirayɛlikailu kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Nba, waati kelen wo la Allabatala ka a fɔ Josuwe yɛ ko: «Kaba doilu lɛsɛ ka ii kɛ muruilu ri, ka Isirayɛlika cɛɛilu bila ko rɔ.» ");
INSERT INTO msc_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Josuwe ka kaba doilu lɛsɛ ka ii kɛ muruilu ri ka Isirayɛlika cɛɛilu la faaninta kɛ. Ii la faaninta wo kɛra yɔrɔ mɛn, ii ka yɔrɔ wo tɔɔ la ko Faaninta kɛ Koyinkɛ. ");
INSERT INTO msc_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","5","Isirayɛlika cɛman mɛnilu bɔra Misiran ka a tɛrɛn ii ra se kɛlɛ ma, woilu bɛɛ la faaninta kɛni le tɛrɛ. Ii bɛɛ sara wula kɔndɔ ye, Isirayɛlikailu tɛrɛ ye taamataamala yɔrɔ mɛn. Kɔni dencɛ mɛnilu sɔrɔnda wula kɔndɔ ye, woilu tun ma faaninta kɛ. Wo le kosɔn, Josuwe ka ii la faaninta kɛ. ");
INSERT INTO msc_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Isirayɛlikailu tun ka san binaanin de kɛ taamala wula kɔndɔ, haan cɛɛ mɛnilu bɔra Misiran ka a tɛrɛn ii ra se kɛlɛ rɔ, woilu bɛɛ sara. Allabatala tun ka lahidi ta ii benbailu yɛ ko a ri jamana ɲin di ii ma, kɔnin cɛɛ mɛnilu bɔra Misiran, ii tun ma sɔn Allabatala la kuma mirala. Wo rɔ, Allabatala ka a kali ko a tɛ sɔn woilu ɲa ye la jamana kan, li ni nɔnɔ ka siya jamana mɛn kɔndɔ ɲin. ");
INSERT INTO msc_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Allabatala ka ii dencɛilu bila ii nɔ rɔ. Josuwe ka woilu kojiiya, baa woilu bɛɛ kojiibali le tɛrɛ fɔlɔ. Ii tun ma kojiiya taama waati wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Ii bɛɛ kojiiyani kɔ, ii tora ii daa makɛ diya rɔ fɔɔ ka ii la dailu kɛndɛya. ");
INSERT INTO msc_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Allabatala ka a fɔ Josuwe yɛ ko: «Jɔnya maloya tɛrɛ ye ai la Misiran, kɔnin n da wo bɔ ai la bi.» Wo le rɔ, yɔrɔ wo tɔɔ lara ko Kilikali haan bi. ");
INSERT INTO msc_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Ka Isirayɛlikailu daa makɛni to Kilikali, ii ka Taminkunna Sali kɛ Jeriko gbɛkannan dɔ. Wo kɛra karo wo tele tan ni naaninna wura da la. ");
INSERT INTO msc_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Wo duu sa gbɛ, ii ka buru fununbali ni sumankisɛ jilanni doilu dɔɔn. ");
INSERT INTO msc_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Wo lon kelen, dɔɔnnifen mɛn tɔɔ ko mana, wo dɔɔn nalɔra. Isirayɛlikailu ma mana sɔrɔn wo kɔ rɔ. Ka a damira san wo ma, ii ka Kanaan jamana sumandenilu le dɔɔn. ");
INSERT INTO msc_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Nba, lon do rɔ, ka Josuwe to Jeriko da fɛ, Josuwe ka cɛɛ do lɔni yen a ɲana. Fanmuru ye a bolo, wo bɔni a la rɔ. Josuwe ka a madon a la ka a maɲininka ko: «Ile ye andeilu do le ri wa, wa i ye an juu do le ri?» ");
INSERT INTO msc_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Cɛɛ ka a fɔ ko: «Nde ni ai si tɛ. N ye Allabatala la kɛlɛjama la kuntii le ri. N natɔ le ɲin.» Josuwe ka a be wo sen kɔrɔ ka a ɲa birin duu ma ka a bonya. Josuwe ka a fɔ ko: «I la jɔn ye nde ri. I ye a fɛ n ye nfen de kɛ sa?» ");
INSERT INTO msc_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Allabatala la kɛlɛjama la kuntii ka a jabi: «I la sanbara bɔ i sen dɔ, baa i lɔni yɔrɔ mɛn kan ɲin, yɔrɔ sɛniman de wo ri.» Josuwe ka wo kɛ. ");
INSERT INTO msc_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Jɛrikokailu tun ka so da tuun ka a sɔɔ kosɛbɛ Isirayɛlikailu la ko kosɔn. Mɔɔ tun tɛ donna, mɔɔ tun tɛ bɔla. ");
INSERT INTO msc_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Allabatala ka a fɔ Josuwe yɛ ko: «A ragbɛ, n ye Jeriko so labilala i ma, a ni a mansa ni a la kɛlɛdenilu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Ile ni i la kɛlɛkɛjama ye ai taama ka Jeriko so laminin siɲa kelen lon lon. Ai ye wo kɛ tele wɔɔrɔ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Alla la sarakalasela wɔrɔnwula ri bila teriya tɔɔmasere kankira ɲɛfɛ. Saaji kere ye kɛ woilu kelen kelenna bɛɛ bolo, kere mɛnilu ye fɛla ka a kan nabɔ ikomin buru. Tele wɔrɔnwulana, ai ye ai taama ka so laminin siɲa wɔrɔnwula. Alla la sarakalaselailu ye ii taama ai ɲɛ ka to kereilu fɛla. ");
INSERT INTO msc_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","«Jama wa ban so lamininna siɲa wɔrɔnwula, Alla la sarakalaselailu ri kere fɛ kan ba labɔ. Ai wa wo mɛn waati mɛn na, jama bɛɛ ye kule ba kɛ. Jeriko so laminin jin di be wo rɔ. Jama bɛɛ ri ii latelen ka don so kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Nun dencɛ Josuwe ka Alla la sarakalaselailu makili ka a fɔ ii yɛ ko: «Ai ye Allabatala la teriya tɔɔmasere kankira ta. Alla la sarakalasela wɔrɔnwula ye bila wo ɲɛ, saaji kere ye kɛ woilu kelen kelenna bɛɛ bolo.» ");
INSERT INTO msc_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","A ka a fɔ Isirayɛlikailu yɛ ko: «Ai ye wa sisen! Ai ye ai taama ka so laminin. Kɛlɛkɛden doilu ye bila Allabatala la teriya tɔɔmasere kankira ɲɛfɛ. Ii la kɛlɛkɛfenilu ye kɛ ii bolo.» ");
INSERT INTO msc_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","9","Nba, ii ka a kɛ ikomin Josuwe ka a fɔ ɲa mɛn ma. Kɛlɛkɛden doilu fɔlɔ wara, ka Alla la sarakalaselailu tuun woilu la, mɛnilu tɛrɛ ye buru fɛla. Teriya tɔɔmasere kankira bilara burutiilu kɔfɛ. Kɛlɛkɛden doilu bilara teriya tɔɔmasere kankira kɔ. Ka ii bɛɛ to wala, keretiilu ye kereilu fɛla. ");
INSERT INTO msc_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Nba Josuwe tun ka a fɔ Isirayɛlikailu yɛ ko: «Mɔɔ si kana kule, mɔɔ si kana a kan nabɔ. Ai kana kuma si fɔ fɔɔ n wa a fɔ ai yɛ lon mɛn na ko ai ye kule. N wa wo fɔ, ai ye kule.» ");
INSERT INTO msc_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Awa, Josuwe ka a kɛ ko Allabatala la teriya tɔɔmasere kankira ye so laminin siɲa kelen, ka ban ka ii kɔsɛ ii daa makɛ diya rɔ ka si ye. ");
INSERT INTO msc_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Wo duusa gbɛ sɔɔma da la jona, Josuwe wulira. A ka a fɔ Alla la sarakalaselailu yɛ ko ii ye teriya tɔɔmasere kankira ta. ");
INSERT INTO msc_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Ii bɛɛ wara so laminin ikomin ii tun ka a kɛ ɲa mɛn ma kɔrɔman. Kɛlɛden doilu fɔlɔ wara, ka Alla la sarakalasela keretiilu tuun woilu la ka kɛlɛdenilu do tuun woilu kɔfɛ. Josuwe ka a kɛ ko Allabatala la teriya tɔɔmasere kankira ye so laminin siɲa kelen ka ii bɛɛ to wala, keretiilu ye kereilu fɛla. ");
INSERT INTO msc_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Wo lon ii wara so laminin siɲa kelen, ka ban ka ii kɔsɛ ii daa makɛ diya. Ii ka a kɛ wo ɲa ma tele wɔɔrɔ kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","A tele wɔrɔnwulana, ii wulira sɔɔma da la jona ka wa so laminin wo ɲa kelen ma. Kɔni wo lon, ii ka so laminin siɲa wɔrɔnwula. ");
INSERT INTO msc_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Ii banni so lamininna siɲa wɔrɔnwula, Alla la sarakalaselailu ka kereilu fɛ fanka la. Josuwe ka a fɔ jama yɛ ko: «Ai ye kule kan ba bɔ, baa Allabatala ra so di ai ma. ");
INSERT INTO msc_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ai ye Jeriko so bɛɛ te, ka a kɔndɔfenilu bɛɛ tiɲan, ka niimafenilu bɛɛ faa, baa so wo ye sar aka ri Allabatala yɛ. Kɔni ai kana foyi kɛ Rahabu la, ni a ye sunkurunba ri. Ai kana foyi kɛ a la mɔɔilu la, mɛnilu bɛɛ ye a fɛ a la bon na ye, baa ale le ka an na keladenilu dokon.» ");
INSERT INTO msc_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Josuwe ka a fɔ kɛlɛdenilu yɛ fanan ko: «Ai ye a kɛ koɲuma sa ai kana fen si ta tɔn siini fen mɛn na, baa wo bɛɛ ye dila Allabatala le ma. Ni ai ka do ta, ai ri kɛ sababu ri, Alla ri an na jama bɛɛ halaki fewu an daa makɛ diya rɔ yan. ");
INSERT INTO msc_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ai ye wodigbɛilu ni saninilu bɛɛ bila a dan na Allabatala yɛ, a ni sulanɛɛfenilu bɛɛ, ni nɛɛmanfenilu bɛɛ. Wo bɛɛ ye bila Allabatala la nanfulu lamara diya.» ");
INSERT INTO msc_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Nba, Alla la sarakalaselailu ka kereilu fɛ. Jama ka kere fɛ kan mɛn tuma mɛn na, ii ka kule kan ba labɔ. Jeriko so laminin jin bɛɛ bera. Isirayɛlikailu ka ii bori ka ii telen ka don so kɔndɔ. Ii ka so bɛɛ mira. ");
INSERT INTO msc_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ii ka Jɛrikokailu bɛɛ faa fanmuru la. Ii ka cɛɛilu ni musoilu faa, ka dennilu ni mɔɔbailu faa. Hali nisiilu ni saailu ni faliilu, ii ka woilu bɛɛ faa. ");
INSERT INTO msc_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Josuwe kumara cɛɛ fila wo yɛ, mɛnilu tun wara jamana lakɔrɔsi. A ka a fɔ ko: «Ai ye wa sunkurunba wara. Ai ye a labɔ, a ni a la mɔɔilu bɛɛ, ikomin ai ka lahidi ta a yɛ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Kanberen fila woilu wara Rahabu wara, ka wa Rahabu labɔ, a ni a fa ni a na, a ni a badenmailu ni a la mɔɔilu bɛɛ. Ii ka woilu bɛɛ labɔ ka wa ii ri yɔrɔ do rɔ, mɛn ye Isirayɛlikailu daa makɛ diya kɔ ma. ");
INSERT INTO msc_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Wo kɔ rɔ, Isirayɛlikailu la kɛlɛdenilu ka ta bila Jeriko so la, ka so ni a kɔndɔfenilu bɛɛ janin. Kɔni ii ka wodigbɛilu ni saninilu ni sulanɛɛfenilu ni nɛɛmanfenilu bɛɛ ta, ka woilu bila Allabatala la nanfulu lamara diya. ");
INSERT INTO msc_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Josuwe ka sunkurunba Rahabu ni a la denbaya bɛɛ kɛndɛ to ye, a ni a la mɔɔ bɛɛ, baa Rahabu tun ka cɛɛ fila wo ladoon, Josuwe ka mɛnilu lɔ Jeriko so lakɔrɔsila. Rahabu ka i sii Isirayɛlikailu tɛma. Hali bi a bɔnsɔnilu ye Isirayɛli rɔ. ");
INSERT INTO msc_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Nba, Josuwe ni a la mɔɔilu banni so tela, a ka a kali mɔɔ bɛɛ yɛ ko: «Ni mɔɔ mɔɔ wulira ko a ye Jeriko so lɔla kokura, Danka ye wo tii kan. A wa wo baara damira lon mɛn na, a dencɛ fɔlɔ ri sa. A wa so donda datuun bila lon mɛn na, a dencɛ dɔɔmanni fanan di sa.» ");
INSERT INTO msc_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Nba, Allabatala tora Josuwe fɛ. Josuwe tɔɔ bɔra jamana fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Kɔni Isirayɛlikailu ma sɔn Alla la sariya ka so nanfulu bɛɛ halaki. Yahuda kabila cɛɛ do le tɛrɛ ye, mɛn tɔɔ ko Akan. Akan fa tɔɔ ko Karimi, wo fa tɔɔ ko Sabidi, wo fanan fa tɔɔ ko Serahi. Alla ka mɛn jamari ii ma, Akana ma wo latelen, baa a ka Jeriko so kɔndɔ fen doilu ta. Akana ka mɛn kɛ wo ri, wo kɛra sababu ri Allabatala mɔnɛra Isirayɛlikailu kanma kojuuya. ");
INSERT INTO msc_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Nba, Josuwe ka mɔɔ fila lawa ka bɔ Jeriko ka wa Ayi so kɔndɔ. Ayi wo ye Bɛtɛli so telebɔ rɔ. A ma jan Bɛti-Abeni so la. Josuwe ka a fɔ ko: «Ai ye wa yɔrɔ wo lakɔrɔsi.» Cɛɛ fila wo wara Ayi lakɔrɔsi wo rɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Ii kɔsɛ mɛn kɛni Josuwe ma, ii ka a fɔ ko: «I kana mɔɔ bɛɛ lawa Ayi so kanma. Kun tɛ wo la. I ye cɛɛ waa fila lawa, ni wo tɛ cɛɛ waa sawa. I kana mɔɔ bɛɛ lawa ka ii sɛɛ fuu, baa Ayikailu ma siya.» ");
INSERT INTO msc_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Wo rɔ, Josuwe ka cɛɛ waa sawa ɲɔɔn lawa Ayi kanma. Kɔni Ayikailu sera ii la. Ii ka ii bori Ayikailu ɲɛ. ");
INSERT INTO msc_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Ayikailu ka ii gbɛn ka bɔ so donda la ka jii tindi la ka wa se fɔɔ yɔrɔ do rɔ, mɛn tɔɔ ko Sɛbarin. Ii jii mɛn kɛni tindi la, Ayikailu ka mɔɔ bisawa ni wɔɔrɔ ɲɔɔn faa Isirayɛlikailu la kɛlɛdenilu rɔ. Isirayɛlikailu bɛɛ jiitɛɛra wo rɔ kojuuya. ");
INSERT INTO msc_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Josuwe ni Isirayɛlikailu la ɲɛmɔɔilu ka ii la faanin rafarafara, ka ii be duu ma Allabatala la teriya tɔɔmasere kankira ɲɛ. Ii ka buuri kɛ ii kun ma ka a kɛ jusumakasa tɔɔmasere ri. Ii mɛnda ye fɔɔ fitiri waati. ");
INSERT INTO msc_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Ka ii lani to ye, Josuwe ka a fɔ ko: «Ee, Maari ba Allabatala! Nfenna i ka an na jama lɔ Juridɛn Ba tɛɛla ka na an di Amɔrikailu ma an halaki kanma? Hali ni an tun tora Juridɛn Ba kɔma, wo tun ka fisa ɲin di! ");
INSERT INTO msc_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Maari, n ma a lɔn n ye nfen fɔ, baa Isirayɛlikailu ra ii bori ii juuilu kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Kanaankailu ni jamana mɔɔ tɔilu ri wo kibaro mɛn. Ii ri na an naminin ka be an kan ka an bɛɛ faa, ka an na siya latunun ka ii bɔ duukolo kan. I ri nfen de kɛ sisen sa i tɔɔ ba kana tiɲan?» ");
INSERT INTO msc_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Allabatala ka Josuwe jabi: «I wuli! Nfen kosɔn i lani duu ma ye? ");
INSERT INTO msc_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isirayɛlikailu ka kojuu le kɛ. Ii ra n na teriya tiɲan. N ka a fɔ ii yɛ ko ii ye so kɔndɔ fenilu bɛɛ halaki. Kɔni n ka mɛn fɔ, ii ma wo latelen, baa ii ka wo fen doilu ta. Ii ka woilu sonya, ka ii bila ii jɛrɛ bolofenilu rɔ, ka tɔɲɔli kɛ. ");
INSERT INTO msc_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Wo le kosɔn Isirayɛlikailu ti se ii lɔla ii juuilu ɲɛrɔ butun. Isirayɛlikailu ra kɛ fen halakitailu ri. Wo sababu la, ii ye ii borila ii juuilu kɔrɔ. Tɔn siini fenilu la, ni ai ma wo tiɲan, n ti nala kɛla ai fɛ butun. ");
INSERT INTO msc_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","I wuli ka wa Isirayɛlikailu sɛninya ka ii rabɛn, sini la ko rɔ. I ye a fɔ ii yɛ ko: ‹Ai ye ai jɛrɛ sɛninya, baa Isirayɛlikailu Maari Allabatala ka a fɔ ko fen mɛnilu bilani tɛrɛ a dan na ka a halaki, woilu ye ai do bolo. Ko ai ti se ai lɔla ai juuilu ɲɛ butun, fɔɔ ai wa fen woilu labɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Ko sini sɔɔma, ai la kabilailu ye ai madon nde Allabatala la kelen kelen. Ko n wa kabila mɛn yiraka, wo bonkɔndɔlailu ye ai madon n na kelen kelen. Ko n wa bonkɔndɔla mɛn suwandi, wo denbayailu ye ai madon n na kelen kelen. Ko n wa denbaya mɛn suwandi, wo cɛɛilu ye ai madon n na kelen kelen. ");
INSERT INTO msc_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Ko fen mɛnilu bilani a dan na ka a halaki, ko woilu ye mɔɔ mɛn bolo, ko n di wo tii yiraka wo ɲa le ma. Ko ale ye lafili ta rɔ ka halaki, a ni a bolofenilu ni a la mɔɔilu bɛɛ. Ko ka a masɔrɔn a ka nde Allabatala la teriya tiɲan. Ko a ka maloya ko ba le kɛ Isirayɛlikailu tɛma.›» ");
INSERT INTO msc_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Wo duusa gbɛ sɔɔma da la jona, Josuwe wulira. A ka Isirayɛlikailu la kabilailu bɛɛ lana kelen kelen Allabatala ɲakɔrɔ. Allabatala ka Yahuda kabila yiraka. ");
INSERT INTO msc_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Josuwe ka Yahuda kabila bonkɔndɔlailu bɛɛ lana kelen kelen. Allabatala ka Seraki la bonkɔndɔla yiraka. Josuwe ka Seraki la bonkɔndɔla denbayailu bɛɛ lana kelen kelen. Allabatala ka Sabidi la denbaya yiraka. ");
INSERT INTO msc_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Josuwe ka Sabidi la denbaya cɛɛilu bɛɛ lana kelen kelen, Allabatala ka Akan yiraka. Akana fa le tɛrɛ Karimi ri, Karimi fa tɛrɛ Sabidi ri, Sabidi fa tɛrɛ Serahi ri. Woilu tɛrɛ Yahuda kabila le rɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Josuwe ka a fɔ Akan yɛ ko: «N den, i ye Isirayɛlikailu Maari Allabatala bonya. I ye tuɲa fɔ. I ka mɛn kɛ, wo fɔ n yɛ; i kana foyi dokon n ma.» ");
INSERT INTO msc_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Akan ka Josuwe jabi: «Tuɲa le. Nde le ka kojuu kɛ Isirayɛlikailu Maari Allabatala la. N ka ko mɛn kɛ, wo le ɲin di: ");
INSERT INTO msc_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","N ka durukiba ɲuma ɲuma do yen nanfulu wo rɔ. Durukiba wo bɔni Sineyari jamana rɔ. N ka wodigbɛ kilo fila ni sanin kuru karamu kɛmɛ loolu fanan yen. N ka fen woilu yen tuma mɛn na, n nata lara ii kan, fɔɔ n ka ii ta. Ii doonni ye duu rɔ n na faaninbon na, wodigbɛ ye fen tɔilu kɔrɔ ye.» ");
INSERT INTO msc_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Josuwe ka mɔɔ doilu lawa Akana na faaninbon na. Woilu borimantɔ wara kɔrɔsili kɛ ye. Ii ka fen woilu doonni yen duukolo kɔrɔ, wodigbɛ ye fen tɔilu kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Ii ka fen woilu ta ka na ii ri Josuwe ni Isirayɛlikailu ma. Ii ka fen woilu bila Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Josuwe ni Isirayɛlikailu bɛɛ ka Serahi bɔnsɔn Akan mira, ka wodigbɛ ni durukiba ni sanin kuru fanan mira, a tun ka mɛnilu dokon. Ii ka a dencɛilu ni a denmusoilu bɛɛ fanan mira. Hali a la nisiilu, ni a la faliilu ni a la saailu, ni a la bailu, ii ka wo bɛɛ mira, ka a la faaninbon ni a bolofen tɔilu bɛɛ ni a la mɔɔ bɛɛ ta ka wa ii ri Akɔri dinban na. ");
INSERT INTO msc_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Ii seni ye, Josuwe ka a fɔ Akana yɛ ko: «Nfenna i ka tɔrɔya lase an ma? Nba, Allabatala ri tɔrɔya be i jɛrɛ kan bi.» Isirayɛlikailu bɛɛ ka Akan a ni a la denbaya mabon kabakurun na ka ii faa, ka ii janin. ");
INSERT INTO msc_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Isirayɛlikailu ka kabakurun siyaman nadɛn ka wo ton Akana su kan. Kabakurun ton wo ye ye hali bi. Wo le kosɔn, ii ka diya wo tɔɔ la ko Akɔri dinban. Tɔɔ wo le ye a la hali bi. Nba, Akana na saya kɔ, Allabatala la diminya malara. ");
INSERT INTO msc_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Allabatala ka a fɔ Josuwe yɛ ko: «I kana silan, i kana jiitɛɛ. I ye kɛlɛdenilu bɛɛ ta ka wa Ayikailu kanma. A ragbɛ, n di Ayi mansa don i bolo, a ni a la mɔɔilu ni a la so ni a la duu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","I ka mɛn kɛ Jeriko so ni a mansa la, i ye wo ɲɔɔn kɛ Ayi so ni a mansa la. Kɔni ai wa se ii la, ai ri ii bolofenilu ni ii la kolofenilu ta ka wo kɛ ai jɛrɛ ta ri. Awa, i ye kɛlɛden doilu dokon so kɔma, mɛnilu ri bara Ayikailu rɔ ka be ii kan.» ");
INSERT INTO msc_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Josuwe ni a la kɛlɛdenilu bɛɛ wulira ka wa Ayi so kanma. Josuwe ka kɛlɛden fadinman mɔɔ waa bisawa suwandi, ka woilu lawa su rɔ. ");
INSERT INTO msc_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","A ka a fɔ ii yɛ ko: «Ai ye ai tolo malɔ. Ai ye wa ai dokon so kɔma, kɔnin ai kana ai mabɔ so la kosɛbɛ. Ai ye ai rabɛn kɛlɛ kanma. ");
INSERT INTO msc_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Kɔnin nde ni kɛlɛden tɔ mɛnilu ye n fɛ, an di an madon Ayi so da la. Ayikailu wa bɔ ko ii ye an kɛlɛla, andeilu ri an bori ii ɲɛ ikomin an ka a kɛ ɲa mɛn ma kɔrɔman. ");
INSERT INTO msc_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Ii fanan di bori an kɔ, ka an gbɛn. An di ii manɛɛn wo ɲa, fɔɔ ka ii labɔ so kɔndɔ ka wa ii ri yɔrɔ jan, baa ii ri a fɔ ko an da an bori ii kɔrɔ ikomin an ka an bori ii kɔrɔ ɲa mɛn ma fɔlɔ. Wo rɔ an wa an bori ii kɔrɔ tuma mɛn na, ");
INSERT INTO msc_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ai ri wuli ka bɔ ai dokon diya rɔ, ka wa be so mɔɔilu kan. An Maari Allabatala ri so di ai ma. ");
INSERT INTO msc_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ai wa so mira tuma mɛn na, ai ye ta bila so la ikomin Allabatala ka a fɔ ɲa mɛn ma. N ka kuma mɛnilu fɔ ai yɛ wo ri, ai ye woilu mira ka ii latelen.» ");
INSERT INTO msc_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Wo rɔ, Josuwe ka kɛlɛden waa bisawa woilu lawa ii dokon diya Bɛtɛli ni Ayi soilu tɛma, Ayi so telebe rɔ kɔnin. Kɔni Josuwe ka su wo kɛ jama fɛ ii daa makɛ diya ye. ");
INSERT INTO msc_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Wo duusa gbɛ sɔɔma da la jona, Josuwe wulira ka a la kɛlɛden tɔilu ladɛn. Ale ni Isirayɛlikailu la ɲɛmɔɔilu ka ii bila kɛlɛdenilu ɲɛ ka wa Ayi so kanma. ");
INSERT INTO msc_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Ii bɛɛ wara Josuwe kɔfɛ ka wa fɔɔ ka ii madon Ayi so da la. Ii ka ii daa makɛ so tele kankan bolomaran dɔ, ka dinban do to ii ni so tɛma. ");
INSERT INTO msc_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Josuwe ka mɔɔ waa loolu suwandi ko ii ye wa ii dokon Bɛtɛli ni Ayi soilu tɛma, Ayi so telebe rɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Wo rɔ, Josuwe ka kɛlɛdenilu bila yɔrɔ fila rɔ. A fan ba tɛrɛ ye ii daa makɛ diya so tele kankan bolomaran dɔ. A tɔilu doonni tɛrɛ so telebe rɔ. Josuwe ka su wo kɛ dinban dɔ. ");
INSERT INTO msc_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Wo duusa gbɛ jona, Ayi mansa ka Josuwe la kɛlɛdenilu yen so tele kankan bolomaran dɔ. Wo rɔ, a ni Ayi kɛlɛdenilu bɛɛ borimantɔ bɔra ka wa Isirayɛlikailu kanma. Ii bɛɛ wara Isirayɛlikailu kɔ yɔrɔ do rɔ Juridɛn Ba fan fɛ ye ko ii ye ii kɛlɛla. Mansa ma a lɔn ko kɛlɛden doilu doonni so kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Josuwe ni Isirayɛli kɛlɛdenilu bɛɛ ka a kɛ ikomin Ayikailu ra se ii la, ka ii bori ii kɔrɔ ka wa wula kɔndɔ sila fɛ. ");
INSERT INTO msc_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Nba, Ayi mansa ka sokɔndɔ cɛɛilu bɛɛ kili ko ii ye bɔ ka wa Isirayɛlikailu kɔ. Wo rɔ, ii wara Josuwe ni Isirayɛlikailu kɔsaran. Isirayɛlikailu ka ii manɛɛn ka wa ii ri fɔɔ yɔrɔ jan ka ii mabɔ so la. ");
INSERT INTO msc_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Cɛɛ si ma to Ayi so kɔndɔ, a ni Bɛtɛli so kɔndɔ. Ii bɛɛ bɔra ka wa Isirayɛlikailu la kɛlɛdenilu kɔ, ka so da lakani to. ");
INSERT INTO msc_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Allabatala ka a fɔ Josuwe yɛ ko: «I ye i la tanba lɔ Ayi so la, baa n di so bila i la sebaya kɔrɔ.» Nba, Josuwe ka a la tanba lɔ Ayi so la. ");
INSERT INTO msc_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Josuwe ka wo kɛ tuma mɛn na, a la kɛlɛden mɛnilu doonni so telebe rɔ, woilu wulira i kɔrɔ ka bɔ ii dokon diya rɔ. Ii borimantɔ donda Ayi so kɔndɔ, ka so mira, ka ta bila so la i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","21","Ayikailu ka ii kɔfɛni ka sisi wulitɔla yen so kɔndɔ. Josuwe ni a la kɛlɛden mɛnilu borini tɛrɛ ka wa wula kɔndɔ sila fɛ, woilu fanan ka sisi wulitɔla yen. Ii ka a lɔn wo rɔ, ko kɛlɛden mɛnilu doonni tɛrɛ so telebe rɔ, ko woilu ra don so kɔndɔ ka so mira ka ta su a la. Wo rɔ, Josuwe ni a la kɛlɛdenilu ka ii kɔsɛ ka na Ayikailu kanma. Ayikailu ma sila si sɔrɔn, ii ri bɔsi Isirayɛlikailu bolo sila mɛn fɛ. ");
INSERT INTO msc_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Isirayɛlika mɛnilu ka ta bila so la, woilu fanan bɔra so kɔndɔ ka na Ayikailu kanma. Isirayɛlikailu ka Ayikailu laminin fan bɛɛ rɔ, ka ii faa. Mɔɔ si ma se a borila. Mɔɔ si kɛndɛ ma to ye, ");
INSERT INTO msc_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","fɔɔ Ayi mansa. Isirayɛlikailu ka a mira ka na a ri Josuwe ma. ");
INSERT INTO msc_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Isirayɛlikailu ka Ayi kɛlɛdenilu bɛɛ faa wula kɔndɔ ye, ii tun ka Isirayɛlikailu kɔsaran ka wa diya mɛn dɔ. Isirayɛlikailu ka ii bɛɛ faa fanmuru la, ka ban ka ii kɔsɛ Ayi so kɔndɔ ka sokɔndɔ mɔɔ tɔilu bɛɛ faa fanmuru la. ");
INSERT INTO msc_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Mɔɔ waa tan ni fila le faara wo lon, cɛɛilu ni musoilu bɛɛ. Ayikailu bɛɛ faara. ");
INSERT INTO msc_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Josuwe ka a la tanba rasɔmɔnnin to Ayi so la fɔɔ Ayikailu bɛɛ halakira. ");
INSERT INTO msc_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Isirayɛlikailu ka kolofenilu ni nanfulu mɛnilu tɛrɛn so kɔndɔ, ii ka wo bɛɛ mira ikomin Allabatala tun ka a fɔ Josuwe yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Josuwe ka Ayi janin ka a kɛ tunbun di, mɛn ti se lɔla butun. Hali bi a ye ɲa wo le ma munun. ");
INSERT INTO msc_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","A ka Ayi so mansa faa ka a su dun jiri la, ka a to ye haan wura la. Tele be waati la, Josuwe ka a fɔ ko ii ye a su lajii ka a bɔ jiri la, ka a lafili so donda la. Ii ka wo kɛ, ka ban ka kabakurun siyaman ton a kan. Kabakurun ton wo ye ye hali bi. ");
INSERT INTO msc_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Wo kɔ rɔ, Josuwe ka Isirayɛlikailu Maari Allabatala saraka janin diya lɔ Ebali koyinkɛ kan. ");
INSERT INTO msc_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","Josuwe ka saraka janin diya wo lɔ ka a kɛ ikomin Allabatala la baaraden Musa ka a fɔ Isirayɛlikailu yɛ ɲa mɛn ma. A ka a lɔ kabakurunilu le la, nɛɛ tun ma se mɛnilu ma fewu ka a lɛsɛ, baa a sɛbɛni ɲa wo le ma Musa la sariya kitabu rɔ. Isirayɛlikailu ka sarakailu janin Allabatala yɛ wo kan ka ii kɛ buuri ri, ka jususuma sarakailu fanan bɔ wo kan. ");
INSERT INTO msc_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Musa tun ka sariya mɛnilu sɛbɛ, Josuwe ka woilu sɛbɛ kabakurun doilu kan Isirayɛlikailu bɛɛ ɲana ye. ");
INSERT INTO msc_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Nba, Isirayɛlikailu bɛɛ lɔni tɛrɛ Allabatala la teriya tɔɔmasere kankira fan fila fɛ. Ii la mɔɔbailu tɛrɛ ye, a ni ii la ɲɛmɔɔilu ni ii la kititɛɛlailu. Ii la londanilu fanan tɛrɛ ye, mɛnilu siini ii tɛma. Jama bɛɛ ɲɛsiini Alla la sarakalaselailu la, mɛnilu bɔni Lebi kabila rɔ kɔnin, teriya tɔɔmasere kankira tɛrɛ ye mɛnilu bolo. Jama talantɛ kelen lɔni Ebali koyinkɛ fan fɛ, talantɛ do lɔni tɛrɛ Kerisimu koyinkɛ fan fɛ, baa Allabatala la baaraden Musa ka a fɔ fɔlɔfɔlɔ ko ii ye a kɛ ten de, ka duwawu kɛ Isirayɛlikailu yɛ. ");
INSERT INTO msc_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Nba Josuwe ka sariya kumailu bɛɛ karan a kan ba la, ikomin woilu sɛbɛni sariya kitabu kɔndɔ ɲa mɛn ma. Allabatala ri koɲuma mɛnilu kɛ a la jama yɛ ni ii ka a kan nabato, a ni a ri tɔrɔya mɛnilu lase ii ma ni ii ma wo labato, Josuwe ka wo bɛɛ karan. ");
INSERT INTO msc_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","A ka Musa la jamariliilu bɛɛ karan. Wo si ma to ye ni Josuwe ma mɛn karan Isirayɛlikailu bɛɛ ɲana. Musoilu ni dennilu fanan tɛrɛ ye jama rɔ ye, a ni londan mɛnilu siini Isirayɛlikailu tɛma. ");
INSERT INTO msc_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Mansa mɛnilu siini Juridɛn Ba telebe rɔ, woilu bɛɛ ka a mɛn ko Isirayɛlikailu ra se ii juuilu la: koyinkɛ ma yɔrɔ mansailu wo, gbɛkannan mansailu wo, kɔɔji da la mansailu wo, a ni Lebanon koyinkɛ ma yɔrɔ mansailu wo. Mansa woilu le ye Hɛtikailu ni Amɔrikailu ni Kanaankailu ni Peresikailu ni Hifikailu a ni Jebusikailu la mansailu ri. ");
INSERT INTO msc_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Ii ka ii ɲɔɔn nadɛn ka ii kan kɛ kelen di ko ii ye Josuwe ni Isirayɛlikailu kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Nba, Kibeyɔnkailu fanan ka a mɛn ko Josuwe ni Isirayɛlikailu ka Jeriko so ni Ayi so halaki. ");
INSERT INTO msc_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Kɔni woilu ka a latɛɛ ko ii ri kewuya kɛ Isirayɛlikailu la. Wo rɔ, ii ka bɔrɔ kɔrɔilu ta taamara ta kanma, ka rɛsɛnji foroko kɔrɔman farafarani doilu fanan ta, mɛnilu rakarakarani. Ii ka woilu bɛɛ la ii la faliilu kɔ la. ");
INSERT INTO msc_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Ii ka duruki farafaranilu bila ii kan na, ka sanbara kɔrɔilu don ii senilu rɔ, mɛnilu karakarani. Ii ka buru kɔrɔilu bila ii la bɔrɔilu kɔndɔ, buru mɛnilu ra ja fo ka a mafun. ");
INSERT INTO msc_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Ii wara Josuwe tɛrɛn Isirayɛlikailu daa makɛ diya Kilikali. Ii ka a fɔ Josuwe ni Isirayɛlikailu bɛɛ yɛ ko: «An bɔni jamana jan do le rɔ. An ye a fɛ ai ye teriya don an ni ai tɛma.» ");
INSERT INTO msc_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Isirayɛlikailu ka ii jabi: «Tumadɔ ai siini an dafɛ yan. Ni wo le, an kana teriya don an ni ai tɛma.» ");
INSERT INTO msc_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Kibeyɔnkailu ka a fɔ Josuwe yɛ ko: «An ye i la jɔnilu le ri.» Kɔni Josuwe ka ii maɲininka ko: «Ai ye siya ɲuman de ri? Ai bɔni mi?» ");
INSERT INTO msc_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ii ka Josuwe jabi: «I la jɔnilu bɔni jamana jan de rɔ ka na ai tɛrɛn, baa ai Maari Allabatala ka ko ba mɛnilu kɛ, woilu fɔra an ɲana. A ka kabannako mɛnilu kɛ ai yɛ Misiran, an ka wo mɛn fanan. ");
INSERT INTO msc_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","A ka mɛn kɛ Amɔrikailu la mansa fila la Juridɛn Ba telebɔ rɔ, an ka wo fanan mɛn. Mansa fila wo kɛra Sihɔn, Hɛsibon mansa le ri, a ni Ɔki, Basan mansa le ri mɛn siini tɛrɛ Asitarɔti so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","An na mɔɔbailu ni an na jamana mɔɔilu bɛɛ ka a fɔ an yɛ ko an ye an dabɛn taama la ka sila fanda bila an kun. Ko an ye na a fɔ ai yɛ ko an ye ai la jɔnilu le ri. Ko ai ye teriya don an ni ai tɛma. ");
INSERT INTO msc_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Ai ye an na buruilu ragbɛ! An bɔra an wara lon mɛn na ka na ai tɛrɛn yan, an ka woilu kalaman de bila an kun. Kɔni sisen ai ye a ragbɛ: ii ra ja fo ka a mafun. ");
INSERT INTO msc_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ai ye an na rɛsɛnji forokoilu fanan dagbɛ! An bɔ mɛn kɛni an wara, an ka woilu kura kura le lafa rɛsɛnji la. Sisen ai ma a yen, ii ra farafara. An na durukiilu ni an na sanbarailu bɛɛ fanan da tiɲan an na taama jan bolo.» ");
INSERT INTO msc_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Nba, Isirayɛlikailu ka Kibeyɔnkailu la sila fanda mafɛnɛ, kɔni ii ma Allabatala maɲininka ko wo ma. ");
INSERT INTO msc_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Josuwe ka teriya don ii ni Isirayɛlikailu tɛma ko Isirayɛlikailu ri ii ɲenema to hɛrɛ rɔ. Isirayɛlikailu la ɲɛmɔɔilu fanan ka ii kali ko ii ri lahidi wo bonya. ");
INSERT INTO msc_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Nba, Isirayɛlikailu ka teriya don ii ni Kibeyɔnkailu tɛma lon mɛn na, wo tele sawanan, Isirayɛlikailu ka a mɛn ko Kibeyɔnkailu wara ma jan ii la. ");
INSERT INTO msc_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Wo rɔ, Isirayɛlikailu ka sila ta ka wa ye. Tele fila a sawanan, ii sera Kibeyɔnkailu la soilu ma. So woilu tɔɔ le ɲin: Kibeyɔn, Kefira, Beerɔti a ni Kiriyati-Jeharimu. ");
INSERT INTO msc_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Wo bɛɛ ni a ta, Isirayɛlikailu ma ii mira, baa ii la ɲɛmɔɔilu tun da ii kali Kibeyɔnkailu yɛ Isirayɛlikailu Maari Allabatala tɔɔ la, ko ii ti nala foyi kɛla ii la. Kɔni Isirayɛlikailu bɛɛ wulira ka ii makasi ii la ɲɛmɔɔilu kan. ");
INSERT INTO msc_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Ii la ɲɛmɔɔilu bɛɛ ka a fɔ jama bɛɛ yɛ ko: «An ti se mɔɔ ɲinilu madiminna butun, baa an da an kali Isirayɛlikailu Maari Allabatala tɔɔ la ko an ti nala foyi kɛla ii la. ");
INSERT INTO msc_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Fo an ye ii ɲenema to. Ni wo tɛ an di Alla la mɔnɛ lase an jɛrɛ ma, baa an da an kali ii yɛ ka ban. Kɔni an di mɛn kɛ ii la, wo le ɲin di. ");
INSERT INTO msc_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","An di ii ɲenema to, kɔni ii ri to lɔɔ tɛɛla a ni ji tala an na jama bɛɛ yɛ.» A kɛra, ikomin mɔɔbailu ka a fɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Josuwe ka Kibeyɔnkailu makili ka a fɔ ii yɛ ko: «Nfenna ai ka an janfa ko ai bɔni yɔrɔ jan, ka a tɛrɛn ai siini an da fɛ yan? ");
INSERT INTO msc_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Nba, sisen kɔnin ai ye danka rɔ, ka ai to lɔɔ tɛɛla, ka to ji tala fanan, Maari Alla la bon baara kanma kadawu.» ");
INSERT INTO msc_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Kibeyɔnkailu ka Josuwe jabi: «An fa, an ka ko ɲin kɛ ka a masɔrɔn an silanni ko ai ri an bɛɛ faa, baa i la jɔnilu lalɔnni gbɛya rɔ ko ai Maari Allabatala ka a fɔ a la baaraden Musa yɛ ko a ri jamana ɲin bɛɛ di ai ma. Ko ai wa na, ko ai ye jamana mɔɔilu bɛɛ faa ka bɔ ai ɲɛrɔ. ");
INSERT INTO msc_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Sisen, an ye ai la fanka kɔrɔ. Mɛn wa ai telen, ai ye wo kɛ an na.» ");
INSERT INTO msc_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Wo rɔ, Josuwe ka Kibeyɔnkailu lakandan Isirayɛlikailu ma. A ma sɔn woilu ye ii faa. ");
INSERT INTO msc_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Wo lon, a ka ii bila lɔɔ tɛɛ ni ji ta baarala Isirayɛlikailu yɛ. Ka a la wo kan, Alla la sarakalaselailu mako ye lɔɔ ni ji mɛnilu la Allabatala saraka janin diya la baara ko rɔ, fo Kibeyɔnkailu ye na woilu fanan di. Allabatala wa yɔrɔ mɛn kɛ a bato diya ri, ii ri baara wo kɛ yɔrɔ wo rɔ. Hali bi ii bɔnsɔnilu ye baara wo le la. ");
INSERT INTO msc_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Nba, Jerusalɛmu mansa Adoni Sedɛki ka a mɛn ko Josuwe ra Ayi so mira. Ko a ka sokɔndɔ mɔɔilu ni a mansa bɛɛ halaki, ikomin a tun ka Jeriko sokɔndɔ mɔɔilu ni a mansa halaki ɲa mɛn ma. Ko Kibeyɔnkailu ra hɛrɛ ɲinin Isirayɛlikailu fɛ, ka duɲɔɔnya don ii ni woilu tɛma ka ii sii woilu tɛma. ");
INSERT INTO msc_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Jerusalamukailu bɛɛ silanda kojuuya wo rɔ, baa Kibeyɔn tɛrɛ ye so ba le ri. A ka bon Ayi so ri, a ni mansasoilu bɛɛ ka kan. Kibeyɔn cɛɛilu bɛɛ tɛrɛ ye cɛɛ fadiyanin de ri fanan. ");
INSERT INTO msc_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Wo le kosɔn, Jerusalɛmu mansa Adoni Sedɛki ka kela lawa Heburɔn mansa Ohamu ma, a ni Jaramutu mansa Piramu ni Lakisi mansa Jafiya ni Ekilon mansa Debiri. ");
INSERT INTO msc_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","A ka a fɔ ko: «Ai ye na ka n dɛmɛn ka Kibeyɔnkailu kɛlɛ, baa ii ra hɛrɛ ɲinin Josuwe ni Isirayɛlikailu fɛ ka duɲɔɔnya don ii ni woilu tɛma.» ");
INSERT INTO msc_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Wo bolo ma, Jerusalɛmu mansa ni Heburɔn mansa ni Jaramutu mansa ni Lakisi mansa ni Ekilon mansa a ni ii la kɛlɛdenilu ka ii ɲɔɔn nadɛn. Mansa woilu ye Amɔrikailu la mansa loolu le ri. Ii ni ii la kɛlɛdenilu bɛɛ wara Kibeyɔnkailu kanma, ka ii daa makɛ Kibeyɔn so laminin dɔ ko ii ye a kɛlɛla. ");
INSERT INTO msc_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Kibeyɔnkailu ka kela lawa Josuwe yɛ Kilikali ko: «I kana i la jɔnilu to ii kelen na. I jaandi, i kaliya, i ye na an nakisi. I ye an dɛmɛn, baa Amɔrikailu la mansa mɛnilu siini koyinkɛ ma yɔrɔilu rɔ, woilu bɛɛ ra ii ɲɔɔn nadɛn ka na an kanma.» ");
INSERT INTO msc_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Josuwe ka wo mɛn tuma mɛn na, a ka a la cɛɛ fadiyaninilu ni a la kɛlɛden tɔilu bɛɛ ladɛn. Ii bɛɛ bɔra Kilikali ka wa kɛlɛ diya. ");
INSERT INTO msc_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Allabatala ka a fɔ Josuwe yɛ ko: «I kana silan mansa woilu ni ii la kɛlɛdenilu yɛ. N di ii bila i la fanka kɔrɔ. Ii si ti nala sela i kɛlɛla.» ");
INSERT INTO msc_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Josuwe ni a la kɛlɛdenilu bɔni Kilikali, ii ka su muumɛ kɛ taama la. Wo rɔ, ii nara bara Amɔrikailu rɔ ka be ii kan. ");
INSERT INTO msc_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Allabatala ka a kɛ Amɔrikailu silanda Isirayɛlikailu yɛ kosɛbɛ, fɔɔ ka ii hankili ɲaamin. Isirayɛlikailu ka ii kɛlɛ ka mɔɔ siyaman faa ii rɔ Kibeyɔn ye, ka ban ka a tɔilu kɔsaran Bɛti-Hɔrɔn so sila la. Ii tɛrɛ ye Amɔrikailu kɛlɛla ka wa se fɔɔ Aseka ni Makeda soilu ma. ");
INSERT INTO msc_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Amɔrikailu ka ii bori Isirayɛlikailu kɔrɔ Aseka so sila la, mɛn bɔni Bɛti-Hɔrɔn. Ii boritɔla ten, Allabatala ka a kɛ sancikolo kunbailu jiira ii ma ka bɔ sankolo rɔ haan ii sera Aseka. Sancikolo ka mɔɔ siyaman faa ii rɔ ka tamin Isirayɛlikailu ka mɛnilu faa fanmuru la. ");
INSERT INTO msc_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Wo lon kelen--lon mɛn Allabatala ka Amɔrikailu bɔsi Isirayɛlikailu bolo--Josuwe ka i lɔ Isirayɛlikailu bɛɛ ɲana ka Allabatala matara ko: «Tele, i lɔ Kibeyɔn so kundɔ. Karo, ile lɔni ye to Ajalɔn dinban kundɔ.» ");
INSERT INTO msc_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Tele ka i lɔ wo rɔ. Karo fanan lɔni tora a nɔ rɔ. Ii tora ii ɲa ma fɔɔ Isirayɛlikailu ka ii la mɔnɛ bɔ ii juuilu rɔ. Ko woilu bɛɛ sɛbɛni Jasɛri la kitabu kɔndɔ. Tele lɔni tora sankolo tɛma; a ka tele kelen ɲɔɔn kɛ, a ma be. ");
INSERT INTO msc_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Wo ɲɔɔn tun ma kɛ fɔlɔ. A ɲɔɔn fanan ti nala kɛla butun, baa mɔɔ ka mɛn fɔ, Allabatala sɔnda ka wo kɛ. Sika tɛ a rɔ, Allabatala jɛrɛ le tɛrɛ kɛlɛ kɛla Isirayɛlikailu yɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Kɛlɛ banni, Josuwe ni Isirayɛlikailu bɛɛ ka ii kɔsɛ ii daa makɛ diya rɔ Kilikali. ");
INSERT INTO msc_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Nba, Amɔrikailu la mansa loolu tun ka ii bori ka wa ii dokon falan do la Makeda so da fɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","A fɔra Josuwe yɛ ko mɔɔilu ka Amɔrikailu la mansa loolu doonni tɛrɛn falan na Makeda so da fɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","Josuwe ka a fɔ a la mɔɔilu yɛ ko: «Ai ye wa kabakurun belebeleba doilu makurukuru ka falan datuun, ka mɔɔ doilu bila yɔrɔ wo kɔnɔgbɛn na. ");
INSERT INTO msc_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Kɔni ai kana mɛn ye. Ai ye ai juuilu kɔsaran fewu ka ii kɛlɛ. Ai kana a to ii ye don ii la soilu kɔndɔ, baa ai Maari Allabatala ra ii bila ai la fanka kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Josuwe ni Isirayɛlikailu ka Amɔrikailu halaki fewu. Dɔɔni ii ma ii bɛɛ faa. Mɔɔ dando mɛnilu ma faa, woilu borira ka wa don ii la so bailu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Nba, Isirayɛlikailu bɛɛ ka ii kɔsɛ hɛrɛ rɔ Josuwe ma ii daa makɛ diya Makeda. Mɔɔ si ma Isirayɛlikailu mafɔ wo kɔ. ");
INSERT INTO msc_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Awa, Josuwe ka a fɔ ko: «Ai ye wa falan da laka sisen ka Amɔrikailu la mansa loolu labɔ. Ai ye na ii ri n ma.» ");
INSERT INTO msc_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Ii wara mansa loolu labɔ falan na. Mansa loolu woilu le siini tɛrɛ Jerusalɛmu so kun na, a ni Heburɔn so ni Jaramutu so ni Lakisi so ni Ekilon so, bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Ii nara mansa woilu ri Josuwe ma tuma mɛn na, a ka Isirayɛlika cɛɛilu bɛɛ makili ko ii ye na. Josuwe ka a fɔ a la kɛlɛden kuntiilu yɛ ko: «Ai ye na ai senilu la mansa ɲinilu kan kan.» Ii nara ii senilu la mansailu kan kan. ");
INSERT INTO msc_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Josuwe ka a fɔ ii yɛ ko: «Ai kana silan, ai jusu kana tiɲan! Ai ye ai raja, ka ai jusu latɛɛ, baa Allabatala ri ɲin ɲɔɔn kɛ ai juuilu bɛɛ la, ai kɛtɔ mɛnilu kɛlɛla.» ");
INSERT INTO msc_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Josuwe ka mansa woilu faa, ka ii su dun jiriju loolu la. Ii dunni tora jiri la fɔɔ tele be waati. ");
INSERT INTO msc_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Tele be waati la, Josuwe ka a fɔ a la mɔɔilu yɛ ko ii ye mansailu suilu lajii ka bɔ jirijuilu la. Josuwe la mɔɔilu ka ii suilu lajii ka wa woilu lafili falan kɔndɔ, mansailu doonni tɛrɛ falan mɛn kɔndɔ. Josuwe la mɔɔilu ka kabakurun ba doilu la falan da la ka a datuun woilu la. Hali bi kabakurun ba woilu ye ye. ");
INSERT INTO msc_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Wo lon kelen Josuwe ni a la kɛlɛdenilu wara Makeda so kɛlɛ ka se ye mɔɔilu la. Josuwe ni a la kɛlɛdenilu ka Makeda mansa ni sokɔndɔ mɔɔilu bɛɛ faa fanmuru la. A ka ii bɛɛ halaki; a ma mɔɔ si to ye. Josuwe tun ka mɛn kɛ Jeriko mansa la, a ka wo ɲɔɔn kɛ Makeda mansa la. ");
INSERT INTO msc_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Josuwe ni Isirayɛlikailu bɛɛ bɔra Makeda ka wa Libina so kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Allabatala ka Libina so ni a mansa fanan di Isirayɛli kɛlɛdenilu ma. Ii ka Libina sokɔndɔ mɔɔilu bɛɛ faa fanmuru la. Ii ma mɔɔ si to ye. Josuwe tun ka mɛn kɛ Jeriko mansa la, a ka wo ɲɔɔn kɛ Libina mansa la. ");
INSERT INTO msc_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Josuwe ni Isirayɛlikailu bɛɛ bɔra Libina ka wa Lakisi. Ii seni ye, ii ka so laminin ka a kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Kɛlɛ tele filana lon, Allabatala ka Lakisi so di Isirayɛlikailu ma. Ii ka Lakisi sokɔndɔ mɔɔilu bɛɛ faa fanmuru la, ikomin ii tun ka a kɛ Libina so kɔndɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Wo tuma, Kɛsɛri mansa Horamu ni a la mɔɔilu nara Lakisikailu dɛmɛn kanma. Kɔni Josuwe ni a la kɛlɛdenilu ka ii kɛlɛ ka se ii la. Ii ma mɔɔ si to ye. ");
INSERT INTO msc_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Josuwe ni Isirayɛlikailu bɛɛ bɔra Lakisi ka wa Ekilon. Ii seni ye, ii ka so laminin ka a kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Wo lon kelen Josuwe ni a la mɔɔilu ka so mira. Ii ka Ekilon sokɔndɔ mɔɔilu bɛɛ faa fanmuru la, ka ii halaki, ikomin ii tun ka a kɛ Lakisi so kɔndɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Josuwe ni Isirayɛlikailu bɛɛ bɔra Ekilon ka wa Heburɔn, ka so wo kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Ii ka Heburɔn mira, ka a mansa ni sokɔndɔ mɔɔilu bɛɛ faa fanmuru la ka ii bɛɛ halaki. Ii ma mɔɔ si to ye. Ii ka ye mɔɔilu bɛɛ faa ikomin ii tun ka a kɛ Ekilon ɲa mɛn ma. Ii ka Heburɔn so mɛsɛnilu fanan mira, ka ye mɔɔilu bɛɛ faa. ");
INSERT INTO msc_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Wo kɔ rɔ, Josuwe ni Isirayɛlikailu bɛɛ wara Debiri so kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Josuwe ni a la kɛlɛdenilu ka Debiri so ni a mansa ni Debiri so mɛsɛnilu bɛɛ mira, ka woilu mɔɔilu bɛɛ faa fanmuru la, ka ii bɛɛ halaki. Ii ma mɔɔ si to ye. Ii tun ka mɛn kɛ Heburɔn so kɔndɔ la a ni Libina sokɔndɔ mɔɔilu ni woilu la mansa la, ii ka wo ɲɔɔn de kɛ Debiri sokɔndɔ mɔɔilu ni ii la mansa la. ");
INSERT INTO msc_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Josuwe ka jamana wo bɛɛ se, koyinkɛ ma yɔrɔilu ni gbɛkannan ni telebe koyinkɛ ma yɔrɔ ni ii la mansailu bɛɛ. A ka mɔɔilu bɛɛ halaki, mɛnilu bɛɛ ka jan, a ka fen bɛɛ faa mɛn ye a niilakilila ikomin Allabatala, Isirayɛli la Alla ka a jamari ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Josuwe ka ii kɛlɛ ka bɔ Kadɛsi-Baraneya so la haan Kasa so, a ni Kosɛni jamana bɛɛ, ka wa sii Kibeyɔn so la. ");
INSERT INTO msc_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Wo le ka a kɛ, Josuwe ni a la kɛlɛdenilu sera mansa woilu bɛɛ la kɛlɛ kelen de rɔ ka ii la duuilu mira ii la. Baa, Isirayɛlikailu Maari Allabatala tɛrɛ ye kɛlɛ kɛla ii yɛ. ");
INSERT INTO msc_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Ii banda wo bɛɛ mirala tuma mɛn na, ii ka ii kɔsɛ ii daa makɛ diya Kilikali. ");
INSERT INTO msc_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Nba, Hasɔri so mansa Jabin ka ko woilu mɛn tuma mɛn na, a ka kela lawa Madoni so mansa Jobabu ma, a ni Simirɔn so ni Akisafu so mansailu ma. ");
INSERT INTO msc_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","A ka kela lawa tele kankan bolomaran mansailu ma fanan, mɛnilu siini koyinkɛ ma yɔrɔilu rɔ. A ka kela lawa Juridɛn Ba dinban mansailu ma, mɛnilu siini Kinerɛti Dala tele kankan bolokininma, ka kela lawa gbɛkannan mansailu ma telebe rɔ, ka kela lawa Dori so mansa ma. ");
INSERT INTO msc_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","A ka kela lawa Kanaankailu fanan ma, mɛnilu siini telebɔ rɔ, a ni mɛnilu siini telebe rɔ. A ka kela lawa Amɔrikailu fanan ma, a ni Hɛtikailu ma, a ni Peresikailu ma, a ni Jebusikailu ma, mɛnilu siini koyinkɛ ma yɔrɔilu rɔ, a ni Hifikailu ma, mɛnilu siini Hɛrimɔn koyinkɛ kɔrɔ Misipa jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Mansa woilu ni ii la kɛlɛdenilu bɛɛ bɔra kɛlɛ kanma. Ii jama ba le tɛrɛ. Ii ka siya ikomin kɔɔji dala kiɲɛ. Sowontoro siyaman ni so siyaman tɛrɛ ye ii bolo. ");
INSERT INTO msc_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Mansa woilu bɛɛ ka i ɲɔɔn nadɛn Merɔmu Kɔ da la ka ii daa makɛ ye. Ii bɛɛ bɛnda kan kelen ma, ko ii ye Isirayɛlikailu kɛlɛla. ");
INSERT INTO msc_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Allabatala ka a fɔ Josuwe yɛ ko: «I kana silan ii ɲɛrɔ fewu, baa ɲin tuma sini, wo ri a tɛrɛn n da woilu bɛɛ di ai ma, ii su ri to Isirayɛlikailu ɲakɔrɔ. Ai ri ii la soilu senfasailu tɛɛ, ka ta bila ii la sowontoroilu la.» ");
INSERT INTO msc_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Nba Josuwe ni a la kɛlɛdenilu wara bara ii rɔ Merɔmu Kɔ da la ka ii kɛlɛ. ");
INSERT INTO msc_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","Allabatala ka ii di Isirayɛlikailu ma. Josuwe la kɛlɛdenilu ka ii kɛlɛ ka ii gbɛn ka ii kɔsaran tele kankan bolomaran ma ka wa se fɔɔ Sidɔn so ba ni Misirefɔti Mayimu so ma. Ii ka ii kɔsaran telebɔ rɔ ka wa se fɔɔ Misipa dinban rɔ. Ii ka ii bɛɛ faa, hali mɔɔ kelen ma to. ");
INSERT INTO msc_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Allabatala tun ka mɛn fɔ Josuwe yɛ, a ka wo bɛɛ kɛ. A ka ii la soilu senfasailu tɛɛ, ka ii la sowontoroilu bɛɛ janin. ");
INSERT INTO msc_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Kɛlɛ wo banni, Josuwe ni a la kɛlɛdenilu ka ii kɔsɛ ka Hasɔri so kɛlɛ ka a mira ka a mansa faa fanmuru la. Wo tuma, Hasɔri so le tɛrɛ ye jamanailu bɛɛ kun na. ");
INSERT INTO msc_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Ii ka Hasɔri sokɔndɔ mɔɔilu bɛɛ faa fanmuru la, ka ii halaki fewu. Ii ma woilu si to. Ii ka ta bila so la fanan ka wo bɛɛ janin. ");
INSERT INTO msc_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Nba, mansa mɛnilu bɛɛ wulira Isirayɛlikailu kanma, Josuwe ni a la kɛlɛdenilu wara woilu la soilu bɛɛ mira. Ii ka woilu mansailu ni sokɔndɔ mɔɔilu bɛɛ faa fanmuru la. Ii ka ii bɛɛ halaki fewu, ikomin Allabatala la baaraden Musa tun ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","So mɛnilu siini tɛrɛ tindilu kan, Isirayɛlikailu ma so woilu si janin, ni Hasɔri so kelen tɛ. Josuwe ka Hasɔri so kelen de janin. ");
INSERT INTO msc_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Josuwe la kɛlɛdenilu ka so kɔndɔ mɔɔilu la nanfuluilu ni ii la kolofenilu bɛɛ ta. Kɔni ii ka sokɔndɔ mɔɔilu bɛɛ faa fanmuru la, ka ii halaki fewu. Ii ma wo si to. ");
INSERT INTO msc_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Allabatala tun ka mɛn fɔ a la baaraden Musa yɛ, ale fanan ka wo bɛɛ fɔ Josuwe yɛ. Josuwe ka wo bɛɛ kɛ. Allabatala ka fen fen fɔ Musa yɛ, Josuwe ka wo bɛɛ kɛ a ɲa ma. ");
INSERT INTO msc_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Nba Josuwe ni a la kɛlɛdenilu ka se sɔrɔn jamana bɛɛ kan ɲa wo le ma. Ii ka se sɔrɔn koyinkɛ ma yɔrɔ kan, a ni tele kankan bolokinin jamana kan, a ni Kosɛni mara kan, a ni telebe jamana kan, mɛn ye koyinkɛilu ni kɔɔji tɛma, a ni Juridɛn Ba dinban dɔ, a ni Isirayɛli la koyinkɛ ma yɔrɔ ni wo gbɛkannan kan, mɛnilu ye tele kankan bolomaran dɔ. ");
INSERT INTO msc_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","Ii ka yɔrɔ bɛɛ mira ka bɔ Halaka Koyinkɛ la, mɛn kɔnin ye Seyiri jamana fan fɛ, ka wa se fɔɔ Bahali Kadi so ma, mɛn ye Lebanon dinban dɔ Hɛrimɔn koyinkɛ kɔrɔ. Ii ka ye mansailu bɛɛ mira ka woilu bɛɛ faa. ");
INSERT INTO msc_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Josuwe tɛrɛ ye mansa woilu kɛlɛla tele siyaman dɔ. ");
INSERT INTO msc_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","So si ma duɲɔɔnya don a ni Josuwe tɛma, ka hɛrɛ ɲinin Isirayɛlikailu fɛ fo Kibeyɔn, Hifikailu siini tɛrɛ yɔrɔ mɛn dɔ. Isirayɛlikailu ka so tɔilu bɛɛ kɛlɛ ka ii bɛɛ mira, ");
INSERT INTO msc_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","baa Allabatala le ka a kɛ so woilu mɔɔilu kun gbɛlɛyara, fo ii ka Isirayɛlikailu kɛlɛ. Allabatala ka wo kɛ le sa Isirayɛlikailu ri ii halaki fewu ka ii bɛɛ faa hinabaliya rɔ ikomin a tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Waati wo la, Josuwe ni a la kɛlɛdenilu wara Anakikailu kɛlɛ koyinkɛ ma yɔrɔilu rɔ. Woilu siini tɛrɛ Heburɔn ni Debiri ni Anabu soilu kɔndɔ, a ni Yahuda kabila ni Isirayɛli la koyinkɛ ma yɔrɔ rɔ. Josuwe ni a la kɛlɛdenilu ka ii bɛɛ faa, ka ii ni ii la soilu bɛɛ halaki. ");
INSERT INTO msc_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Ii ka Anakikailu bɛɛ faa Isirayɛli jamana kɔndɔ fɔɔ mɔɔ dando mɛnilu siini tɛrɛ Kasa ni Kati ni Asidɔdi soilu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","A kɛra ten, Josuwe ka jamana wo bɛɛ mira, ikomin Allabatala ka a fɔ Musa yɛ ɲa mɛn ma. Josuwe ka jamana wo rafara Isirayɛlikailu tɛma, kabila bɛɛ ni a la duu. Wo bɛɛ kɔrɔ, kɛlɛ banda jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Nba, Isirayɛlikailu tun da se mansa fila la Juridɛn Ba telebɔ rɔ, ka woilu la jamana mira ii la. Mansa woilu la jamanailu ye bɔla Arinɔn Dinban ma, ka wa se fɔɔ Hɛrimɔn Koyinkɛ ma; Juridɛn Ba mɛn ye telebɔ fan bɛɛ tɛrɛ ii bolo. ");
INSERT INTO msc_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Sihɔn tɛrɛ ye Amɔrikailu la mansa le ri. A siini tɛrɛ Hɛsibon so kɔndɔ. Arinɔn Dinban talantɛ tɛrɛ ye a la mara rɔ. Wo dan tɛrɛ ye bɔla Arowɛri so la. Kiliyadi mara talantɛ fanan tɛrɛ ye a ta le ri, ka wa se fɔɔ Jabɔki ba ma. Jabɔki ba ye dan di Sihɔn na jamana ni Amonika la jamana tɛma. ");
INSERT INTO msc_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Juridɛn Ba dinban telebɔ fan fanan tɛrɛ ye a la mara le ri. Wo dan tɛrɛ ye bɔla Kinerɛti Dalaba la ka wa se fɔɔ Araba Dala, mɔɔilu ye a fɔla mɛn ma ko Dalaba Kɔɔjilama. Dan tɛrɛ ye bɔla ye ka wa Bɛti-Jesimɔti so la, ka bɔ ye ka wa Pisika koyinkɛ la. ");
INSERT INTO msc_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Mansa Ɔki, mɛn tɛrɛ ye Refa siya mɔɔ laban do le ri. Wo tɛrɛ ye Basan jamana le kun na. A la mansasoilu tɛrɛ Asitarɔti ni Edereyi le ri. ");
INSERT INTO msc_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","A la mara tɛrɛ ye Hɛrimɔn Koyinkɛ le ri, a ni Saleka mara, a ni Basan jamana yɔrɔ bɛɛ, ka wa se fɔɔ Kesurikailu la jamana dan na, a ni Maakakailu la jamana dan na. A la mara tɛrɛ ye Kiliyadi jamana talantɛ le ri fanan, ka wa se fɔɔ Hɛsibon na mansa Sihɔn na jamana dan na. ");
INSERT INTO msc_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Allabatala la baaraden Musa ni Isirayɛlikailu sera mansa fila woilu la. Allabatala la baaraden Musa ka jamana woilu ratala Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ tɛma. ");
INSERT INTO msc_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Nba, Josuwe ni Isirayɛlikailu sera mansa doilu la Juridɛn Ba telebe rɔ fanan. Ka bɔ Bahali Kadi so Lebanon dinban dɔ ka wa se fɔɔ Halaka Koyinkɛ la Seyiri jamana fan fɛ, Isirayɛlikailu sera ye mansailu bɛɛ la. Josuwe ka duu woilu bɛɛ don Isirayɛlikailu kabilailu bolo. ");
INSERT INTO msc_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Duu woilu tɛrɛ ye koyinkɛ ma yɔrɔ le rɔ, a ni telebe jamana rɔ, mɛn ye koyinkɛilu ni kɔɔji tɛma, a ni Juridɛn Ba dinban dɔ, a ni koyinkɛda la, a ni wula kɔndɔ, a ni tele kankan bolokinin jamana rɔ. Hɛtikailu siini tɛrɛ jamana woilu rɔ, a ni Amɔrikailu ni Kanaankailu ni Peresikailu ni Hifikailu ni Jebusikailu. ");
INSERT INTO msc_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Isirayɛlikailu ka se sɔrɔn mansa mɛnilu la, woilu le ɲin di: Jeriko so mansa (mɔɔ kelen), Ayi so mɛn ye Bɛtɛli da fɛ, wo mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","Jerusalɛmu so mansa (mɔɔ kelen), Heburɔn so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","Jaramutu so mansa (mɔɔ kelen), Lakisi so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","Ekilon so mansa (mɔɔ kelen), Kɛsɛri so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","Debiri so mansa (mɔɔ kelen), Kedɛri so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","Horima so mansa (mɔɔ kelen), Aradi so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","Libina so mansa (mɔɔ kelen), Adulamu so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","Makeda so mansa (mɔɔ kelen), Bɛtɛli so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","Tapuwa so mansa (mɔɔ kelen), Hefɛra so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","Afɛki so mansa (mɔɔ kelen), Lasarɔn so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","Madoni so mansa (mɔɔ kelen), Hasɔri so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","Simerɔn Merɔn so mansa (mɔɔ kelen), Akisafu so mansa (mɔɔ kelen). ");
INSERT INTO msc_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","Tanaki so mansa (mɔɔ kelen), Mekido so mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","Kedɛsi so mansa (mɔɔ kelen), Jokineyamu so mɛn ye Karamɛli koyinkɛ kɔrɔ, wo mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","Dori so mansa mɛn ye Nafati Dori tɔrɔfɛ (mɔɔ kelen), Koyimu so mɛn ye Kilikali mara rɔ, wo mansa (mɔɔ kelen), ");
INSERT INTO msc_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","a ni Tirisa so mansa (mɔɔ kelen). A bɛɛ ladɛnnin ye mansa bisawa ni kelen de ri. ");
INSERT INTO msc_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Nba, waati wo taminni kɔ, Allabatala kumara Josuwe yɛ ka a tɛrɛn Josuwe ra kɔrɔ kosɛbɛ. Allabatala ka a fɔ ko: «I ra kɔrɔ kosɛbɛ. Kɔni Isirayɛlikailu ka kan ka yɔrɔ mɛnilu mira fɔlɔ, woilu ka siya ba le. ");
INSERT INTO msc_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","3","Ai ma Filisitiilu la jamana bɛɛ mira fɔlɔ, a ni ii la mansaso loolu. So woilu ye Kasa ri, a ni Asidɔdi ni Asakalon ni Kati ni Ɛkɛron, Abakailu la jamana fanan ma bɛɛ mira fɔlɔ. Ai ma Kesurikailu la jamana bɛɛ mira, mɛn ye Misiran jamana telebɔ rɔ. Yɔrɔ mɛn ye bɔla Sihɔri ba la Misiran dan na ka wa tele kankan bolomaran dɔ fɔɔ Ɛkɛron so ma, ai ma wo mira fɔlɔ. Mɔɔilu ye yɔrɔ wo jatela Kanaankailu ta le ri. ");
INSERT INTO msc_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","Ai ma Kanaanka la jamana bɛɛ fanan mira. Wo ye bɔla Mehara so le la, mɛn ye Sidɔnkailu ta ri, ka wa se fɔɔ Afɛki so ma Amɔrikailu la jamana dan na. ");
INSERT INTO msc_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","Ai ma Kɛbalikailu la duu mira fɔlɔ. Telebɔ rɔ, ai ma Lebanon koyinkɛ ma yɔrɔ bɛɛ ta munun. Wo ye bɔla Bahali Kadi so la Hɛrimɔn koyinkɛ kɔrɔ, ka wa se fɔɔ Lebo Hamati ma. ");
INSERT INTO msc_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","Koyinkɛma yɔrɔ mɛn ye Lebanon ni Misirefɔti Mayimu tɛma, ai ma wo fanan mira fɔlɔ. Ye mɔɔilu ye Sidɔnkailu le ri. Awa, n kan ye yɔrɔ mɛnilu bɛɛ ma ko ai ma woilu mira fɔlɔ, n jɛrɛ ri ii gbɛn ka bɔ ai ɲakɔrɔ. I ri duu wo bɛɛ ratala Isirayɛlikailu tɛma, ka a kɛ ii ta ri, ikomin n ka a fɔ i yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","I ye a ratalan kabila kɔnɔndɔ tɛma, a ni Manase kabila talantɛ.» ");
INSERT INTO msc_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Nba, Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ tun ka ii niiyɔrɔ sɔrɔn Juridɛn Ba kɔ. Allabatala la baaraden Musa ka duu di ii ma ye. ");
INSERT INTO msc_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Ii la yɔrɔ dan bɔni so fila le la. Do ye Arinɔn Kɔ dinban tɛmala rɔ. A tɔ kelen ye Arowɛri so le ri, ni a ye Arinɔn Kɔ da la. Medeba gbɛkannan bɛɛ fanan tɛrɛ ye a rɔ, ka wa se fɔɔ Dibɔn so ma. ");
INSERT INTO msc_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Ii la yɔrɔ ye wala fɔɔ Amonikailu la jamana dan na. Amɔrikailu la mansa Sihɔn na soilu bɛɛ fanan tɛrɛ ye a rɔ. Sihɔn na mansaso tɛrɛ ye Hɛsibon di. ");
INSERT INTO msc_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Kiliyadi jamana fanan tɛrɛ ye ie la yɔrɔ rɔ, a ni Kesurikailu la jamana ni Maakakailu la jamana. Hɛrimɔn Koyinkɛ bɛɛ tɛrɛ ye a rɔ, a ni Basan jamana bɛɛ ka wa se fɔɔ Saleka mara rɔ. ");
INSERT INTO msc_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Basan jamana mansa Ɔki siini tɛrɛ yɔrɔ mɛnilu bɛɛ kun na, woilu bɛɛ tɛrɛ ye a rɔ. Wo la mansasoilu tɛrɛ ye Asitarɔti ni Edereyi ri. Ɔki tɛrɛ Refayilu la siya mɔɔ laban do le ri. Awa, Musa ka mɔɔ woilu bɛɛ kɛlɛ, ka se ii la, ka ii gbɛn, ka ii la jamanailu mira ii la. ");
INSERT INTO msc_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Kɔni Isirayɛlikailu ma Kesurikailu ni Maakakailu gbɛn. Wo le kosɔn hali bi Kesuri ni Maaka siini Isirayɛlikailu fɛ. ");
INSERT INTO msc_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Lebi bɔnsɔnilu le kelen pe ma duu sɔrɔn Musa bolo, baa ii cɛ ye bɔla saraka janintailu le rɔ, mɔɔilu ye mɛnilu bɔla ka janin Isirayɛlikailu Maari Allabatala yɛ. Allabatala jɛrɛ le ka wo lahidi ta Lebi bɔnsɔnilu yɛ. ");
INSERT INTO msc_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Musa tun ka duu do di Rubɛn kabila ma, bɔnsɔn bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Yɔrɔ wo dan tɛrɛ ye Arowɛri so ri, mɛn ye Arinɔn Kɔ da la. So mɛn ye Arinɔn Kɔ dinban tɛmala rɔ, wo fanan tɛrɛ ye yɔrɔ wo dan do le ri. Gbasan mɛn ye Medeba so laminin dɔ, wo tɛrɛ ye yɔrɔ wo rɔ. ");
INSERT INTO msc_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","20","Hɛsibon so tɛrɛ ye yɔrɔ wo rɔ, a ni a laminin soilu bɛɛ. Woilu le ɲin di: Dibɔn, Bamoti-Bahali, Bɛti-Bali-Mɛyon, Jahasi, Kedemɔtu, Mefata, Kiriyatayimi, Sibima, Sereti Sahara mɛn ye dinban tindi kan, Bɛti-Peyɔrɔ, Bɛti-Jesimɔti, a ni Pisika koyinkɛ. ");
INSERT INTO msc_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","Ka a la laminin so woilu kan, yɔrɔ mɛnilu bɛɛ tɛrɛ ye Amɔrikailu la mansa Sihɔn bolo ye le kɔrɔman, wo bɛɛ tɛrɛ ye Rubɛn kabila ta le ri. Sihɔn tele rɔ, a la mansaso tɛrɛ ye Hɛsibon de ri. Musa tun ka a kɛlɛ ka se a la, ka se Madiyan jamana kuntiilu fanan na. Kuntii woilu tɔɔ le ko Ebi ni Rɛkɛmu ni Suru ni Huri ni Reba. Ii siini tɛrɛ ye jamana kɔndɔ ye, kɔni ii tɛrɛ ye mansa Sihɔn na fanka le kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Isirayɛlikailu ka mɔɔ woilu kɛlɛ tuma mɛn na, ii ka mɔɔ siyaman faa fanmuru la. Beyɔri dencɛ Balami tɛrɛ ye woilu do le ri. Balami tɛrɛ ye fɛlɛlila le ri. ");
INSERT INTO msc_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Juridɛn Ba tɛrɛ ye Rubɛn kabila la duu dan de ri telebe rɔ. Awa, so ba ni so mɛsɛn mɛnilu dira Rubɛn kabila ma ka a kɛ ii la niiyɔrɔ ri, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Musa tun ka duu do di Kadi kabila fanan ma, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Jasɛri so ye ii la yɔrɔ le rɔ, a ni Kiliyadi jamana soilu bɛɛ. Amonikailu la jamana fan kelen fanan ye a rɔ, ka wa se fɔɔ Arowɛri so ma, ni a ye Raba so da fɛ. ");
INSERT INTO msc_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","Yɔrɔ wo tɛrɛ ye bɔla Hɛsibon na, ka wa se fɔɔ Ramata Misipe ni Betonimu soilu ma. A tɛrɛ ye bɔla Mahanimu so la, ka wa se fɔɔ Lodabara. ");
INSERT INTO msc_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Bɛti-Haramu so fanan tɛrɛ ye a rɔ, a ni Bɛti-Nimira so ni Sukɔti so ni Safon so. A ni so bɛɛ mɛnilu tɛrɛ ye mansa Sihɔn na jamana kɔrɔ kɔndɔ Juridɛn Ba dinban rɔ. Sihɔn na mansaso tɛrɛ ye Hɛsibon de ri. Yɔrɔ wo ye Juridɛn Ba telebɔ rɔ. A ye wala tele kankan bolomaran dɔ ka se fɔɔ Kinerɛti Dala ma. ");
INSERT INTO msc_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Awa, so ba ni so mɛsɛn mɛnilu dira Kadi kabila ma ka a kɛ ii ta ri, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Musa tun ka yɔrɔ di Manase kabila talantɛ fanan ma, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Ii la yɔrɔ tɛrɛ ye bɔla Mahanimu so le la. Basan jamana bɛɛ tɛrɛ ye a rɔ, a ni Jayiri la so ni biwɔɔrɔ mɛn ye jamana wo kɔndɔ. Basan mansa Ɔki le siini tɛrɛ yɔrɔ wo bɛɛ kun na kɔrɔman. ");
INSERT INTO msc_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Kiliyadi jamana talantɛ tɛrɛ ye yɔrɔ wo rɔ fanan, a ni Asitarɔti so ni Edereyi so. So fila woilu tɛrɛ ye Basan mansa Ɔki la mansaso kɔrɔilu le ri. Awa, yɔrɔ wo bɛɛ dira Makiri la bonkɔndɔla talantɛ ma, denbaya bɛɛ ni a ta. Makiri tɛrɛ ye Manase dencɛ le ri. ");
INSERT INTO msc_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Nba, ka Musa to Mowabu jamana gbɛkannan dɔ, a ka ye duu ratala wo ɲa. Yɔrɔ wo ye Jeriko so telebɔ rɔ, Juridɛn Ba kɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Kɔni Musa ma yɔrɔ si di Lebi kabilailu ma. Isirayɛlikailu Maari Allabatala kɛra woilu niiyɔrɔ ri, ikomin a ka lahidi ta ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Awa, Alla la sarakalasela Elasari ni Nun dencɛ Josuwe ni Isirayɛlikailu la kabila tiilu, woilu ka Kanaan jamana ratala Isirayɛlikailu tɛma. A kɛra ɲa mɛn ma, wo le ɲin di. ");
INSERT INTO msc_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","Ii ka kalabe kɛ duu ratala ko rɔ Isirayɛlikailu la kabila kɔnɔndɔ ni a talantɛ tɛma, ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","4","Yusufu bɔnsɔnilu kɛra kabila fila le ri, Manase kabila ni Efirayimu kabila. Musa tun ka yɔrɔ do di kabila fila ni a talantɛ ma kɔrɔman Juridɛn Ba telebɔ rɔ. Kɔni a ma yɔrɔ si di Lebi bɔnsɔnilu le ma. A ka so dando le di woilu ma, ka a kɛ woilu sii diya ri. A ka so woilu laminin duu fanan di ii ma ka a kɛ ii la kolofenilu damaɲinin diyailu ri. ");
INSERT INTO msc_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Awa, Isirayɛlikailu ka jamana ratalan ikomin Allabatala tun ka a fɔ Musa yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Lon do rɔ, ka Isirayɛlikailu to Kilikali, Yahuda kabila mɔɔ doilu nara Josuwe tɛrɛn. Jefunɛ dencɛ Kalɛbu, mɛn bɔni Kenisi bonkɔndɔla, ka a fɔ Josuwe yɛ ko: «Ka an to Kadɛsi-Baraneya ye, Allabatala kumara a la mɔɔ Musa yɛ ile ni nde la ko rɔ. A ka mɛn fɔ, i ka wo lɔn. ");
INSERT INTO msc_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Wo tuma, n sɔrɔn da san binaanin bɔ. Allabatala la baaraden Musa ka n lawa ka bɔ Kadɛsi-Baraneya, ko n ye na jamana ɲin nakɔrɔsi. N ka n kɔsɛ mɛn kɛ, n tun ka mɛnilu yen jamana kɔndɔ, n ka woilu ɲafɔ a yɛ telenbaya rɔ. ");
INSERT INTO msc_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","N badenma mɛnilu wara n tɔrɔfɛ, woilu fanan ka dantɛɛli kɛ. Kɔni ii ka mɛn fɔ, wo ka jama tunagboya. Kɔni n ka lemɛniya la n Maari Allabatala rɔ fewu. ");
INSERT INTO msc_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Wo lon, Musa ka a kali n yɛ ko n wara ka n taama jamana mɛn kɔndɔ wo lakɔrɔsi kanma, ko wo le kɛtɔ n ni n denilu ta ri kadawu. Ko ka a masɔrɔn n ka lemɛniya la n Maari Allabatala dɔ fewu. ");
INSERT INTO msc_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","A ragbɛ. Allabatala ka n kɛndɛ to fɔɔ ka na se bi ma, ikomin a ka lahidi ta ɲa mɛn ma. A ka kuma wo fɔ Musa yɛ ka Isirayɛlikailu to wula kɔndɔ ye. San binaanin ni loolu le ye waati wo ni bi tɛma. Nba, n ye yan sisen. N sɔrɔn da san biseyin ni loolu le bɔ. ");
INSERT INTO msc_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Kɔni fanka mɛn tɛrɛ ye n na n lawa waati Musa bolo, wo fanka kelen ye n na fɔlɔ. Sebaaya ye n na ikomin n tɛrɛ ye ɲa mɛn ma fɔlɔ. N di se kɛlɛ kɛla, n di se baara kɛla. ");
INSERT INTO msc_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Sisen, i ye koyinkɛ ma yɔrɔ wo di n ma, Allabatala ka mɛn lahidi ta n yɛ wo lon. I jɛrɛ ka a mɛn wo lon ko Anakikailu le ye jamana wo rɔ. Ii la soilu ye so bailu le ri, jin ye mɛnilu lamininna. Kɔni ni Allabatala tora n fɛ, n di Anakikailu bɛɛ gbɛn ikomin Allabatala jɛrɛ ka a fɔ ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Nba, Josuwe ka duwawu kɛ Jefunɛ dencɛ Kalɛbu yɛ, ka Heburɔn so di a ma ka a kɛ a ta ri. ");
INSERT INTO msc_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Wo rɔ haan bi, Heburɔn ye Kalɛbu bɔnsɔnilu ta le ri ka a masɔrɔn Kalɛbu ka lemɛniya la Isirayɛlikailu Maari Allabatala rɔ fewu. ");
INSERT INTO msc_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Waati taminni, Heburɔn tɛrɛ ye kilila le ko Kiriyati Ariba. Wo kɔrɔ le ko Ariba la so. Ariba le tɛrɛ mɔɔ malɔnni ba ri Anakikailu rɔ. Wo bɛɛ kɔrɔ, kɛlɛ banda jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Yahuda kabila ka yɔrɔ mɛn sɔrɔn kalabe rɔ, wo tɛrɛ ye wala tele kankan bolokinin dɔ ka se fɔɔ Edɔmu jamana dan ma, ni a ye Sini wula kɔndɔ tele kankan bolokinin dɔ fan fɛ bakɛ. ");
INSERT INTO msc_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Tele kankan bolokinin dɔ fan fɛ, yɔrɔ wo dan ye bɔla Dalaba Kɔɔjilama tele kankan bolokinin dɔ bolo fara la. ");
INSERT INTO msc_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","A ye wala Kɔsɔn Koyinkɛ tele kankan bolokinin dɔ, ka wa se Sini. A ye bɔla ye ka wa Kadɛsi-Baraneya so tele kankan bolokinin dɔ, ka bɔ ye ka wa Hɛsirɔn so la. A ye bɔla ye ka wa Adari so la, ka bɔ ye ka wa Karika so la. ");
INSERT INTO msc_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","A ye bɔla ye ka wa Asimɔn so la, ka bɔ ye ka wa se Misiran Kɔ ma. Kɔ wo ye dan de ri ka wa se fɔɔ Kɔɔjiba ma. Wo kɛra Yahuda kabila la duu dan de ri tele kankan bolokinin dɔ fan fɛ. ");
INSERT INTO msc_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Telebɔ rɔ fan fɛ, a dan ye Dalaba Kɔɔjilama le ri, ka wa se fɔɔ Juridɛn Ba bila diya ma Dalaba Kɔɔjilama rɔ. Tele kankan bolomaran dɔ fan fɛ, a dan ye bɔla Juridɛn Ba bila diya ye ");
INSERT INTO msc_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ka wa se fɔɔ Bɛti-Hɔkila so ma, ka bɔ ye ka wa Bɛti-Araba so tele kankan bolomaran dɔ, ka wa se fɔɔ Bohan na kabakurun ma. Bohan tɛrɛ ye Rubɛn dencɛ le ri. ");
INSERT INTO msc_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Dan ye bɔla ye ka wa Akɔri dinban tɛma ka wa se fɔɔ Debiri so ma. A ye bɔla ye ka wa tele kankan bolomaran fan fɛ ka wa se fɔɔ Kilikali so ma, mɛn ɲabɛnni Adumimu tindi la dinban tele kankan bolokinin dɔ. Dan ye wala En Semɛsi kɔ ma, ka wa se En Rokɛla so ma. ");
INSERT INTO msc_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","A ye bɔla ye ka tamin Bɛni Hinɔmu dinban tɛmala rɔ, Jebusikailu la tindi tele kankan bolokinin fudu fan fɛ. Jerusalɛmu so ye tindi wo kun de rɔ. Dan ye bɔla ye ka wa fɔɔ koyinkɛ kun dɔ, koyinkɛ mɛn ye Hinɔmu dinban telebe rɔ. Koyinkɛ wo ye Refayilu la dinban tele kankan bolomaran dɔ. ");
INSERT INTO msc_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Dan ye bɔla koyinkɛ kun dɔ ka wa fɔɔ Nɛfitoha ji bu yɔrɔ rɔ. A ye bɔla ye ka wa Ɛfirɔn koyinkɛ soilu la, ka bɔ ye ka wa Bahala so la, mɛn tɔɔ fanan ko Kiriyati-Jeharimu. ");
INSERT INTO msc_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Ka bɔ Bahala, dan ye wala telebe rɔ ka wa se fɔɔ Seyiri Koyinkɛ ma, ka bɔ ye ka tamin Yeharimu Koyinkɛ tele kankan bolomaran fudu fan fɛ. Yɔrɔ wo tɔɔ fanan ko Kesalɔn. Dan ye bɔla ye ka wa Bɛti-Sɛmɛsi so la, ka bɔ ye ka wa Timina so la. ");
INSERT INTO msc_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Dan ye wala Ɛkɛron so koyinkɛ tele kankan bolomaran fudu fɛ, ka bɔ ye ka wa Sikirɔn so la, ka tamin ye ka wa Bahala Koyinkɛ ma. A ye bɔla ye ka wa se fɔɔ Jabinɛli so ma, ka bɔ ye ka wa se Kɔɔjiba ma. ");
INSERT INTO msc_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Kɔɔji ba tɛrɛ ye dan de ri telebe rɔ. Awa, Yahuda kabila la bonkɔndɔlailu ka yɔrɔ mɛn sɔrɔn, wo danilu le wo ri. ");
INSERT INTO msc_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Josuwe ka yɔrɔ do di Jefunɛ dencɛ Kalɛbu ma Yahuda kabila la duu kɔndɔ, ikomin Allabatala ka a fɔ Josuwe yɛ ɲa mɛn ma. A ka Kiriyati Ariba so di a ma, mɛn ye kilila fanan ko Heburɔn. Ariba tɛrɛ ye Anaki fa le ri. ");
INSERT INTO msc_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Kalɛbu ka Anaki bɔnsɔnilu sawa gbɛn ka ii labɔ Heburɔn so kɔndɔ. Woilu tɔɔilu ko Sesayi ni Ahiman ni Talimayi. ");
INSERT INTO msc_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Kalɛbu bɔra ye ka wa Debirikalu kanma. Fɔlɔ Debiri so tɔɔ le tɛrɛ ko Kiriyati Sefɛra. ");
INSERT INTO msc_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Wo tuma, Kalɛbu ka a fɔ ko: «Ni mɔɔ mɛn ka Kiriyati Sefɛrakailu kɛlɛ ka ii la so mira, n di n denmuso Akisa di wo tii ma ka a kɛ a muso ri.» ");
INSERT INTO msc_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Otiniyɛli tɛrɛ ye Kalɛbu dɔɔcɛ Kenasi dencɛ le ri. Ale wara so kɛlɛ ka a mira. Wo rɔ, Kalɛbu ka a denmuso di a ma ka a kɛ a muso ri. ");
INSERT INTO msc_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Akisa seni a cɛɛ la bon na, a ka a fɔ a cɛɛ yɛ ko wo ka kan ka duu do ɲinin a fa fɛ. Wo kɔ rɔ, Akisa wara bɔ a fa fɛ. A jiira ka bɔ a la fali kan tuma mɛn na, Kalɛbu ka a maɲininka ko: «A ye di? N ye nfen kɛ i yɛ?» ");
INSERT INTO msc_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Akisa ka a fɔ ko: «I jaandi, i ye n nadiya. I ye tenkema yɔrɔilu di n ma, baa i ka duu di n ma tele kankan bolokinin de ma.» Wo rɔ, Kalɛbu ka sandɔ tenkema yɔrɔilu di a ma, a ni duula tenkema yɔrɔilu. ");
INSERT INTO msc_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Yahuda kabila ka duu mɛn sɔrɔn, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Wula kɔndɔ so mɛnilu ye tele kankan bolokinin dɔ bakɛ Yahuda kabila la duu rɔ, so mɛnilu kɔnin ma jan Edɔmukailu la jamana dan na, woilu tɔɔ le ɲin di: Kabisela, Edɛru, Yakuru, ");
INSERT INTO msc_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","Kina, Dimona, Adeyada, ");
INSERT INTO msc_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","Kedɛsi, Hasɔri, Jitinan, ");
INSERT INTO msc_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","Sifu, Telemu, Behalotu, ");
INSERT INTO msc_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","Hasɔri Hadata, Keriyota Hɛsirɔn mɛn tɔɔ fanan ko Hasɔra, ");
INSERT INTO msc_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","Amama, Sema, Molada, ");
INSERT INTO msc_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","Hasɔra Kada, Hesimɔn, Bɛti-Pɛlɛta, ");
INSERT INTO msc_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","Hasara-Suwali, Bɛri-Seba, Bisihotiya, ");
INSERT INTO msc_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","Bahala, Hiyimu, Ɛsɛmu, ");
INSERT INTO msc_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","Elitolada, Kesili, Horima, ");
INSERT INTO msc_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","Sikilaka, Madimana, Sansana, ");
INSERT INTO msc_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","Lebahota, Silimu, Ayin, a ni Rimɔn. Wo bɛɛ ladɛnnin kɛra so ba muwan ni kɔnɔndɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Yahuda kabila la so mɛnilu tɛrɛ ye telebe gbɛkannan yɔrɔ rɔ, woilu tɔɔ le ɲin: Ɛsitahɔla, Sora, Asɛna, ");
INSERT INTO msc_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","Sanowa, En Kanimu, Tapuwa, Enamu, ");
INSERT INTO msc_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","Jaramutu, Adulamu, Soko, Aseka, ");
INSERT INTO msc_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","Sarayimu, Aditayimu, a ni Kedera (mɛn tɔɔ fanan ko Kederotayimu). Woilu bɛɛ ladɛnnin kɛra so ba tan ni naanin de ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Senan, Hadasa, Mikidala Kada, ");
INSERT INTO msc_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","Dileyan, Misipe, Jokitɛla, ");
INSERT INTO msc_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","Lakisi, Bosikata, Ekilon, ");
INSERT INTO msc_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","Kabɔn, Lahimasa, Kitilisu, ");
INSERT INTO msc_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","Kederɔti, Bɛti-Dakɔn, Nama, a ni Makeda. Woilu bɛɛ ladɛnnin kɛra so ba tan ni wɔɔrɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Libina, Etɛra, Asan, ");
INSERT INTO msc_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","Jɛfɛta, Asina, Nesibu, ");
INSERT INTO msc_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","Keyila, Akisibu, a ni Maresa. Woilu bɛɛ ladɛnnin kɛra so ba kɔnɔndɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Ɛkɛron so fanan tɛrɛ ye Yahuda kabila la duu rɔ, a ni a so mɛsɛnilu ni a todailu. ");
INSERT INTO msc_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","So ba ni so mɛsɛn mɛnilu tɛrɛ ye Ɛkɛron ni Kɔɔjiba tɛma, mɛnilu kɔnin ma jan Asidɔdi so la, woilu bɛɛ tɛrɛ ye a rɔ. ");
INSERT INTO msc_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Asidɔdi so ni Kasa so fanan tɛrɛ ye a rɔ, a ni ii so mɛsɛnilu ni ii todailu. Yɔrɔ wo ye wala tele kankan bolokinin dɔ fan fɛ ka wa se fɔɔ Misiran kɔ ma. A ye wala telebe rɔ fan fɛ ka wa se fɔɔ Kɔɔjiba ma. ");
INSERT INTO msc_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Yahuda kabila la so mɛnilu tɛrɛ ye koyinkɛ ma yɔrɔ rɔ, woilu tɔɔ le ɲin di: Samiri, Jatira, Soko, ");
INSERT INTO msc_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","Dana, Kiriyati Sana mɛn tɔɔ fanan ko Debiri, ");
INSERT INTO msc_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","Anabu, Esitemoya, Animu, ");
INSERT INTO msc_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","Kosɛni, Holɔn, a ni Kilo. Woilu bɛɛ ladɛnnin kɛra so ba tan ni kelen de ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Araba, Duma, Esana, ");
INSERT INTO msc_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","Janimu, Bɛti-Tapuwa, Afeka, ");
INSERT INTO msc_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","Humeta, Kiriyati Ariba mɛn tɔɔ fanan ko Heburɔn, a ni Sihɔri. Woilu bɛɛ ladɛnnin kɛra so ba kɔnɔndɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Mahɔn, Karamɛli, Sifu, Juta, ");
INSERT INTO msc_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","Jisirele, Jokidehamu, Sanowa, ");
INSERT INTO msc_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","Kahini, Kibeya, a ni Timina. Woilu bɛɛ ladɛnnin kɛra so ba tan de ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Halula, Bɛti-Sura, Kedɔru, ");
INSERT INTO msc_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","Marata, Bɛti-Anɔti, a ni Elitekɔna. Wo bɛɛ ladɛnnin kɛra so ba wɔɔrɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Kiriyati Bali mɛn tɔɔ fanan ko Kiriyati-Jeharimu, a ni Raba. Wo bɛɛ ladɛnnin kɛra so ba fila le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","So doilu tɛrɛ ye wula kɔndɔ. Woilu tɔɔ le ɲin: Bɛti-Araba, Midini, Sekaka, ");
INSERT INTO msc_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","Nibisan, Kɔɔ so, a ni En Kedi. Woilu bɛɛ ladɛnnin kɛra so ba wɔɔrɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Yahuda kabila mɔɔilu ma se Jebusikailu gbɛnna ka ii labɔ Jerusalɛmu so kɔndɔ. Wo rɔ, Jebusikailu siini Yahuda kabila mɔɔilu tɛma so kɔndɔ ye haan bi. ");
INSERT INTO msc_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Yusufu bɔnsɔnilu ka yɔrɔ mɛn sɔrɔn kalabe rɔ, wo danilu le ɲin di. A dan ye bɔla Juridɛn Ba le ma Jeriko so jiman yɔrɔ telebɔ rɔ, ka tamin wula kɔndɔ tɛmala rɔ, ka wa se Bɛtɛli so koyinkɛ ma yɔrɔ ma. ");
INSERT INTO msc_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","A dan tele kankan bolokinin ye bɔla ye ka wa Lusi so la, ka bɔ ye ka tamin Atirɔti so la, Arakikailu la mara rɔ. ");
INSERT INTO msc_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","A ye bɔla ye ka wa telebe rɔ ka se Jafeletikailu la jamana dan ma, ka bɔ ye ka wa se Duula rɔ Bɛti-Hɔrɔn so ma, ka tamin ye ka wa Kɛsɛri so la, ka bɔ ye ka wa se Kɔɔjiba ma. ");
INSERT INTO msc_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Nba, Yusufu bɔnsɔnilu kɛra kabila fila le ri, Manase kabila ni Efirayimu kabila. Ii ka yɔrɔ mɛn sɔrɔn ka a kɛ ii ta ri, wo le wo ri. ");
INSERT INTO msc_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Efirayimu kabila ka yɔrɔ wo fan kelen sɔrɔn, bonkɔndɔla bɛɛ ni a ta. Ii la yɔrɔ dan ye bɔla Atirɔti Adari so le la, mɛn ye telebɔ rɔ. A ye bɔla ye ka wa Sandɔ Bɛti-Hɔrɔn so la, ");
INSERT INTO msc_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ka bɔ ye ka wa Kɔɔjiba ma, tele kankan bolomaran dɔ fan fɛ, a dan ye bɔla Mikimetata so la, ka wa telebɔ rɔ ka se fɔɔ Tanata Silo so ma, ka tamin ye ka wa Janoya so la. ");
INSERT INTO msc_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","A ye bɔla Janoya ka wa Atirɔti so ni Nara so la, ka tamin ye ka wa Jeriko, ka bɔ ye ka wa Juridɛn Ba ma. ");
INSERT INTO msc_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Ka bɔ Tapuwa so la ka wa telebe fan fɛ haan Kana Kɔ la, ka bɔ ye ka wa se Kɔɔjiba ma. Efirayimu kabila ka yɔrɔ mɛn sɔrɔn, wo danilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Ka a la wo kan, ii ka so ba doilu ni woilu so mɛsɛnilu sɔrɔn Manase kabila la yɔrɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Kɔni Efirayimu kabila mɔɔilu ma Kanaankailu gbɛn ka ii labɔ Kɛsɛri so kɔndɔ. Wo le kosɔn Kanaankailu siini Efirayimu kabila mɔɔilu tɛma hali bi. Kɔni Efirayimu kabila mɔɔilu ye diyagboya baara lala ii kan. ");
INSERT INTO msc_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Manase kabila fanan ka yɔrɔ do sɔrɔn. Manase tɛrɛ ye Yusufu dencɛ fɔlɔ ri. Manase dencɛ fɔlɔ tɛrɛ ye Makiri le ri. Makiri dencɛ tɛrɛ ye Kiliyadi ri. Makiri tɛrɛ ye kɛlɛden fadiyanin de ri. Josuwe tun ka Kiliyadi jamana ni Basan jamana di ale ma. ");
INSERT INTO msc_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Manase kabila tɔilu ka duu sɔrɔn, bonkɔndɔla bɛɛ ni a ta. Bonkɔndɔla woilu ye Abiyɛsɛri la bonkɔndɔla ri, a ni Helɛka ta ni Asiriyɛla ta ni Sɛkɛmu ta ni Hefɛra ta ni Semida ta. Woilu le ye Yusufu dencɛ Manase bɔnsɔnilu ri, a bɛɛ ni a la bonkɔndɔla. ");
INSERT INTO msc_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Awa, Manase dencɛ tɛrɛ ye Makiri ri. Makiri dencɛ tɛrɛ ye Kiliyadi ri. Kiliyadi dencɛ tɛrɛ ye Hefɛra ri. Hefɛra dencɛ tɛrɛ ye Selofehadi ri. Selofehadi ma dencɛ sɔrɔn fo denmusoilu gbansan. A denmusoilu tɔɔ ko Mahala ni Nowa ni Hɔkila ni Milika ni Tirisa. ");
INSERT INTO msc_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Denmuso woilu wara Alla la sarakalasela Elasari ni Nun dencɛ Josuwe ni Isirayɛlikailu la bonkɔndɔla tiilu tɛrɛn, ka a fɔ ii yɛ ko: «Allabatala ka Musa jamari ko a ye niiyɔrɔ do di andeilu fanan ma ikomin an badenma cɛmandeilu.» Wo rɔ, ii ka niiyɔrɔ do di ii fanan ma ikomin ii badenma cɛmandeilu, ka a bɛn Allabatala la jamarili ma. ");
INSERT INTO msc_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Wo le ka a kɛ, Manase kabila ta kɛra niiyɔrɔ tan de ri Juridɛn Ba telebe rɔ. Niiyɔrɔ woilu lara ii la niiyɔrɔ fila kan Juridɛn Ba telebɔ rɔ, mɛnilu ye Kiliyadi jamana ni Basan jamana ri, ");
INSERT INTO msc_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","baa Manase bɔnsɔn musomandeilu ka duu sɔrɔn ikomin Manase bɔnsɔn cɛmandeilu ka duu sɔrɔn ɲa mɛn ma. Kiliyadi jamana kɛra Manase kabila mɔɔ gbɛrɛilu ta ri. ");
INSERT INTO msc_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Manase kabila la niiyɔrɔ ye bɔla Asɛri kabila la niiyɔrɔ dan de la ka wa fɔɔ Mikimetata so la, mɛn ye Sɛkɛmu so telebɔ rɔ. Dan ye bɔla Mikimetata ka wa tele kankan bolokinin fan fɛ, ka wa se fɔɔ En Tapuwa wara. ");
INSERT INTO msc_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Tapuwa so ye dan de ri Manase kabila la niiyɔrɔ ni Efirayimu kabila la niiyɔrɔ tɛma. Tapuwa so jɛrɛ ye Efirayimu kabila ta le ri, kɔnin a laminin duu ye Manase kabila ta le ri. ");
INSERT INTO msc_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Awa, dan ye bɔla Tapuwa so la ka wa tele kankan bolokinin dɔ fan fɛ ka se fɔɔ Kana dinban tele kankan bolokinin fan ma. Ye so doilu tɛrɛ ye Efirayimu kabila ta ri. Manase kabila la soilu ye woilu laminin na. Dan ye wala dinban wo fɛ a tele kankan bolomaran fan fɛ ka wa se fɔɔ Kɔɔjiba ma. ");
INSERT INTO msc_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Efirayimu kabila la niiyɔrɔ tɛrɛ ye Kana dinban tele kankan bolokinin dɔ. Manase kabila la niiyɔrɔ tɛrɛ ye dinban wo tele kankan bolomaran dɔ. Kɔɔjiba le tɛrɛ ye kabila fila bɛɛ dan di telebɔ rɔ. Asɛri kabila la niiyɔrɔ ye Manase kabila la niiyɔrɔ tele kankan bolomaran dɔ. Isakari kabila la niiyɔrɔ ye Manase kabila la niiyɔrɔ telebɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Manase kabila la so doilu tɛrɛ ye Isakari kabila la niiyɔrɔ kɔndɔ, a ni Asɛri kabila ta. So woilu ye Bɛti-Sɛyan so ni Ibileyamu so le ri, a bɛɛ ni a so mɛsɛnilu. Ka a la woilu kan, Dori so tɛrɛ ye Manase kabila ta le ri, a ni Endori so ni Tanaki so ni Mekido so ni Nafɛti la so mɛsɛn sawa, a bɛɛ ni a mɔɔilu, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Kɔnin Manase kabila mɔɔilu ma se Kanaankailu gbɛnna ka ii labɔ so woilu kɔndɔ. Wo le rɔ, Kanaankailu siini tora ye. ");
INSERT INTO msc_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Wo bɛɛ ni a ta, Isirayɛlikailu ka fanka sɔrɔn tuma mɛn na, ii ka diyagboya baarailu la Kanaankailu kan. Kɔni Isirayɛlikailu ma woilu gbɛn ka ii labɔ ye. ");
INSERT INTO msc_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Lon do rɔ, Yusufu bɔnsɔnilu nara Josuwe tɛrɛn, ka a fɔ a yɛ ko: «I ka niiyɔrɔ kelen pe di andeilu ma nfenna? I ma a yen, Allabatala ra ɲumaya kɛ andeilu yɛ ka an kɛ jama siyaman ba ri.» ");
INSERT INTO msc_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Josuwe ka a fɔ ii yɛ ko: «Ni ai ka siya fɔɔ Efirayimu kabila la koyinkɛ ma yɔrɔ dɔɔman ai rɔ, ai ye wa duu matɛɛ Peresikailu ni Refayilu la tu kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Yusufu bɔnsɔnilu ka a fɔ ko: «Tuɲa le, koyinkɛ ma yɔrɔ wo dɔɔman andeilu rɔ. Kɔni kɛlɛkɛ sowontoro nɛɛlamanilu ye Kanaankailu bolo, mɛnilu kɔnin siini Bɛti-Sɛyan dinban dɔ ni Bɛti-Sɛyan so mɛsɛnilu kɔndɔ ni Jisirele dinban dɔ.» ");
INSERT INTO msc_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Josuwe ka a fɔ Yusufu bɔnsɔnilu yɛ, mɛn ye Efirayimu kabila ni Manase kabila ri ko: «Ai ka siya, ai fanka fanan ka bon. Ai ti nala danna niiyɔrɔ kelen pe sɔrɔnna. ");
INSERT INTO msc_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Koyinkɛma yɔrɔ ri kɛ ai ta ri, mɛn ye tu le ri. Ai ye wa a matɛɛ ka a bɛɛ muumɛ kɛ ai ta le ri. Fanka ye Kanaankailu la. Kɛlɛkɛ sowontoro nɛɛlamanilu le ii bolo. Kɔni ai ri se ii gbɛnna.» ");
INSERT INTO msc_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Isirayɛlikailu bɛɛ wara i ɲɔɔn nadɛn Silo so kɔndɔ, ka Alla la daa makɛ faaninbon nawuli ka a lɔ ye. Wo ka a tɛrɛn jamana bilani ii la fanka kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Kɔni Isirayɛlikailu kabila wɔrɔnwula tun ma niiyɔrɔ duu sɔrɔn fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Josuwe ka a fɔ Isirayɛlikailu yɛ, ko, «Allabatala, ai failu Alla ka duu mɛn don ai bolo, ai ri ta ko bɔrɔ kɛ haan waati ɲuman wa? ");
INSERT INTO msc_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Ai ye cɛɛilu suwandi kabilailu bɛɛ rɔ, kabila kelen cɛɛ sawa. N di woilu lawa jamana yɔrɔilu bɛɛ rataamala. Jamana ye ɲa mɛn ma, ii ri wo bɛɛ sɛbɛ an dɛmɛn kanma jamana ratalala. Ii wa ban wo bɛɛ sɛbɛla, ii ri na n tɛrɛn yan. ");
INSERT INTO msc_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Ai ri jamana ratalan yɔrɔ wɔrɔnwula ri. Yahuda kabila ri to ii la niiyɔrɔ rɔ tele kankan bolokinin dɔ. Yusufu bɔnsɔnilu ri to ii la niiyɔrɔ rɔ tele kankan bolomaran dɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Ai ye niiyɔrɔ wɔrɔnwula wo tɔɔmasere ɲa sɛbɛ, ka na a di n ma. N di kalabe kɛ ai la kabila kelen kelenna yɛ an na Maari Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Kɔni Lebi bɔnsɔnilu le ti nala niiyɔrɔ sɔrɔnna jamana kɔndɔ ai tɛma, baa ii ye Allabatala la sarakalaselailu le ri, baa Allabatala la sarakalase ye ii cɛ le ri. Kadi kabila ni Rubɛn kabila ni Manase kabila talantɛ, woilu ra ii la niiyɔrɔ sɔrɔn Juridɛn Ba telebɔ rɔ. Allabatala la baaraden Musa ka ii la niiyɔrɔ di ii ma.» ");
INSERT INTO msc_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Nba, ii ka mɔɔ mɛnilu suwandi ka wa jamana ragbɛ, woilu ka ii rabɛn wali kanma. Sani ii ye wa, Josuwe ka jamarili di ii ma ko: «Ai ye wa jamana rataama, ka a ragbɛ kosɛbɛ. Jamana ye ɲa mɛn ma, ai ye wo sɛbɛ ka na n tɛrɛn yan. N di kalabe kɛ Allabatala ɲakɔrɔ Silo yan, sa bɛɛ ri a ta sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Ii bɔra ye ka wa jamana rataama. Jamana ye ɲa mɛn ma, ii ka wo bɛɛ sɛbɛ kitabu lamininnin dɔ, ka so bɛɛ tɔɔilu fanan sɛbɛ, ka jamana ratala yɔrɔ wɔrɔnwula ri. Ii banni wo la, ii ka ii kɔsɛ ka na Josuwe tɛrɛn daa makɛ diya Silo. ");
INSERT INTO msc_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Josuwe ka kalabe kɛ Allabatala ɲakɔrɔ Silo, ka jamana ratalan Isirayɛlikailu tɛma, kabila bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Kalabe ka niiyɔrɔ fɔlɔ mɛn ta, wo kɛra Bɛniyaminu kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. Niiyɔrɔ wo kɛra Yahuda kabila la niiyɔrɔ ni Yusufu bɔnsɔnilu la niiyɔrɔ tɛma. ");
INSERT INTO msc_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Tele kankan bolomaran dɔ fan fɛ, niiyɔrɔ wo dan tɛrɛ ye bɔla Juridɛn Ba le ma, ka wa tamin Jeriko so tele kankan bolomaran fudu fɛ, ka wa telebe rɔ ka tamin koyinkɛ ma yɔrɔ fɛ, ka wa se fɔɔ wula kɔndɔ Bɛti-Abeni so da fɛ. ");
INSERT INTO msc_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","A ye bɔla ye ka wa tamin Lusi so tele kankan bolokinin fudu fɛ. Lusi ye kilila fanan ko Bɛtɛli. Dan ye bɔla ye ka wa Atirɔti Adari so la, mɛn ye koyinkɛ kun dɔ Bɛti-Hɔrɔn duula rɔ so tele kankan bolokinin dɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","Koyinkɛ wo telebe rɔ, dan ye tamin ka wa tele kankan bolokininma fan fɛ ka se fɔɔ Kiriyati Bali ma, mɛn ye kilila fanan ko Kiriyati-Jeharimu. A ye Yahuda kabila la so do le ri. Awa, Bɛniyaminu kabila la niiyɔrɔ dan de tɛrɛ wo ri telebe rɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Tele kankan bolokinin dɔ, a dan ye bɔla Kiriyati-Jeharimu so da la ka wa telebe rɔ fan fɛ ka se fɔɔ Nɛfitoha ji bɔ yɔrɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","A ye bɔla ye ka wa se koyinkɛ sen ma, koyinkɛ mɛn lɔni Bɛni Hinɔmu dinban da fɛ. Yɔrɔ wo ye Refayilu la dinban tele kankan bolomaran dɔ. Dan ye bɔla ye ka tamin Hinɔmu dinban tɛma Jebusikailu la tindi tele kankan bolokinin fudu fɛ, ka wa se fɔɔ En Rokɛla so ma. ");
INSERT INTO msc_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","A ye bɔla En Rokɛla ka wa tele kankan bolomaran fan fɛ ka se fɔɔ En Semɛsi ma, ka bɔ ye ka wa Keliyɔta so la. So wo ɲabɛnni Adumimu tindi la. Dan ye bɔla ye ka wa Bohan na kabakurun na. Bohan tɛrɛ ye Rubɛn dencɛ le ri. ");
INSERT INTO msc_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Dan ka a tamin Araba koyinkɛ ɲakɔrɔ a tele kankan bolomaran fan fɛ, ka jii Araba kɔndɔ ");
INSERT INTO msc_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ka wa Bɛti-Hɔkila koyinkɛ tele kankan bolomaran fudu fɛ. A ye bɔla ye ka wa se Dalaba Kɔɔjilama ma tele kankan bolomaran dɔ, Juridɛn Ba ye bilala Dala wo rɔ yɔrɔ mɛn. Dan de tɛrɛ woilu ri tele kankan bolokinin dɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Juridɛn Ba tɛrɛ ye dan de ri telebɔ rɔ. Awa, Bɛniyaminu kabila la bonkɔndɔlailu ka niiyɔrɔ mɛn sɔrɔn, wo danilu le wo ri a fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Bɛniyaminu bonkɔndɔla la soilu le ɲin di: Jeriko, Bɛti-Hɔkila, Emɛka Kesisi, ");
INSERT INTO msc_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","Bɛti-Araba, Semarayimu, Bɛtɛli, ");
INSERT INTO msc_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","Abimu, Para, Ofira, ");
INSERT INTO msc_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","Kefara Hamoni, Ɔfini, a ni Keba. Wo bɛɛ ladɛnnin ye so ba tan ni fila le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","So mɛnilu lara woilu kan, woilu le ɲin: Kibeyɔn, Rama, Beerɔti, ");
INSERT INTO msc_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","Misipa, Kefira, Mosa, ");
INSERT INTO msc_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","Rɛkɛmu, Iripɛli, Tarala, ");
INSERT INTO msc_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","Sela, Helɛfu, Kibeya, Kiriyati a ni Jebusikailu la so, ni a ye Jerusalɛmu ri. Wo bɛɛ ladɛnnin ye so ba tan ni naanin de ri, a bɛɛ ni a so mɛsɛnilu. Bɛniyaminu kabila ka niiyɔrɔ mɛn sɔrɔn ka a kɛ ii ta ri, wo le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Kalabe ka niiyɔrɔ filana mɛn ta, wo kɛra Simeyɔn kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. Ii la niiyɔrɔ lamininni Yahuda kabila la duu le la. ");
INSERT INTO msc_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","So mɛnilu tɛrɛ ye ii la niiyɔrɔ rɔ, woilu le ɲin: Bɛri-Seba, Molada, ");
INSERT INTO msc_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","Hasara-Suwali, Baala, Ɛsɛmu, ");
INSERT INTO msc_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","Elitolada, Betulu, Horima, ");
INSERT INTO msc_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","Sikilaka, Bɛti-Marikabɔti, Hasara-Susa, ");
INSERT INTO msc_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","Bɛti-Lebabɔta, a ni Saruwɛn. Woilu bɛɛ ladɛnnin ye so ba tan ni sawa ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","So mɛnilu lara woilu kan, woilu ye Ayin ni Rimɔn di, a ni Etɛra ni Asan. So ba naanin de woilu ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","So mɛsɛn mɛnilu bɛɛ ye so woilu laminin dɔ, woilu fanan ye a rɔ, ka wa se fɔɔ Baalata Bɛri so ma, mɛn tɔɔ fanan ko Nɛkɛbi Ramati. Simeyɔn kabila ka niiyɔrɔ mɛn sɔrɔn, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Awa, ikomin Yahuda kabila la niiyɔrɔ tun ka bon ii ma, Josuwe ka a fan do ta ka wo kɛ Simeyɔn kabila ta ri. Wo le kosɔn Simeyɔn kabila la niiyɔrɔ lamininni de Yahuda kabila la duu la. ");
INSERT INTO msc_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Kalabe ka niiyɔrɔ sawanan mɛn ta, wo kɛra Sabulɔn kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. Ii la niiyɔrɔ dan tɛrɛ ye wala fɔɔ Sarida so la. ");
INSERT INTO msc_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","A ye bɔla ye ka wa telebe fan fɛ ka wa se fɔɔ Mareyali so ma, ka bɔ ye ka wa Dabɛsɛta so la, ka bɔ ye ka wa dinban ma, mɛn ye Jokineyamu so telebɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Ka bɔ Sarida so fan gbɛrɛ fɛ, dan tɛrɛ ye wala telebɔ fan fɛ ka wa se Kisilɔta Tabɔri mara ma, ka bɔ ye ka wa Dabɛrata so la, ka tamin ye ka wa fɔɔ Jafiya so la. ");
INSERT INTO msc_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","A ye bɔla ye ka wa telebɔ fan fɛ, ka wa se fɔɔ Kati-Hefɛri so ni Eti Kasini so la, ka bɔ ye ka wa Rimɔn so la, ka tamin ye ka wa Neya so la. ");
INSERT INTO msc_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Dan ye taminna Neya so tele kankan bolomaran dɔ ka wa Hanatɔn so la, ka bɔ ye ka wa dan Ifita Eli dinban dɔ. ");
INSERT INTO msc_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","So ba tan ni fila le tɛrɛ Sabulɔn kabila la niiyɔrɔ wo rɔ, a bɛɛ ni a so mɛsɛnilu. So tan ni fila doilu le ɲin: Katati, Nahalali, Simirɔn, Idala, a ni Bɛtilɛhɛmu. ");
INSERT INTO msc_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Sabulɔn kabila ka niiyɔrɔ mɛn sɔrɔn, a ni a so bailu ni a so mɛsɛnilu, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Kalabe ka niiyɔrɔ naaninnan mɛn ta, wo kɛra Isakari kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Ii la niiyɔrɔ soilu le ɲin di: Jisirele, Kesulɔta, Sunɛmu, ");
INSERT INTO msc_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","Hafarayimu, Siyɔn, Anaharati, ");
INSERT INTO msc_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","Rabita, Kisiyɔn, Ebɛsi, ");
INSERT INTO msc_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","Remɛta, En Kanimu, En Hada, a ni Bɛti-Pasɛsa. ");
INSERT INTO msc_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Ii la niiyɔrɔ dan de tɛrɛ sela Tabɔri koyinkɛ ma, ka bɔ ye ka wa Sahasuma so la, ka bɔ ye ka wa Bɛti-Sɛmɛsi so la, ka bɔ ye ka wa dan Juridɛn Ba la. So ba tan ni wɔɔrɔ tɛrɛ ye ii la niiyɔrɔ rɔ, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Isakari kabila ka niiyɔrɔ mɛn sɔrɔn, a ni a so bailu ni a so mɛsɛnilu, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Kalabe ka yɔrɔ loolunan mɛn ta, wo kɛra Asɛri kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Ii la niiyɔrɔ soilu le ɲin: Hɛlikata, Hali, Betɛn, Akisafu, ");
INSERT INTO msc_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","Alamelɛka, Amadi, a ni Misala. Ii la niiyɔrɔ telebe rɔ, dan ye wala Karamɛli koyinkɛ ni Sihɔri Libinati la. ");
INSERT INTO msc_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","28","A ye bɔla ye ka wa Bɛti-Dakɔn fan fɛ telebɔ rɔ, ka wa se fɔɔ Sabulɔn kabila la niiyɔrɔ dan ma, a ni Ifita Eli dinban ma. A ye bɔla ye ka wa tele kankan bolomaran fan fɛ, ka wa se Bɛti-Emɛki so ma, a ni Neyɛli so ma. A ye bɔla ye ka wa sila kolo kelen wo kan, ka tamin Kabuli so la, a ni Abidɔn so ni Rehobu so ni Hamɔn so ni Kana so, ka wa dan Sidɔn so ba da la. ");
INSERT INTO msc_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Dan ye bɔla ye ka wa Rama so, ka wa se Tiri so ma, mɛn lamininni jin na. A ye bɔla ye ka tamin Hosa so fan fɛ ka wa dan Kɔɔjiba la so doilu tɔrɔfɛ, Akisibu mara rɔ. ");
INSERT INTO msc_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","Yɔrɔ wo so bɛɛ ladɛnnin kɛra so ba muwan ni fila le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Asɛri kabila ka niiyɔrɔ mɛn sɔrɔn, a ni a so bailu ni a so mɛsɛnilu, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Kalabe ka niiyɔrɔ wɔɔrɔna mɛn ta, wo kɛra Nafitali kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Ii la niiyɔrɔ dan tɛrɛ ye bɔla Hɛlɛfu so ni jiriju ba le la, ni a ye Sananimu so da la, ka wa Adami Nekɛbu so la. A ye bɔla ye ka wa Jabuneyɛli so la, ka bɔ ye ka wa Lakumu so la, ka bɔ ye ka wa dan Juridɛn Ba la. ");
INSERT INTO msc_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Wo kɔ rɔ, dan tɛrɛ ye wala telebe fan fɛ ka tamin Asinɔti Tabɔri so la ka wa se Hukɔki so ma. Sabulɔn kabila la niiyɔrɔ tɛrɛ ye dan de ri tele kankan bolokinin dɔ. Asɛri kabila la niiyɔrɔ tɛrɛ ye dan de ri telebe rɔ. Juridɛn Ba tɛrɛ ye dan de ri telebɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Ii la niiyɔrɔ so mɛnilu lamininni jin na, woilu le ɲin: Sidimu, Sɛri, Hamati, Rakata, Kinerɛti, ");
INSERT INTO msc_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","Adama, Rama, Hasɔri, ");
INSERT INTO msc_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","Kedɛsi, Edereyi, En Hasori, ");
INSERT INTO msc_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","Yirɔn, Mikidali Eli, Horɛmu, Bɛti-Anati, a ni Bɛti-Sɛmɛsi. Wo bɛɛ ladɛnnin kɛra so ba tan ni kɔnɔndɔ le ri, a bɛɛ ni a so mɛsɛnilu. ");
INSERT INTO msc_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Nafitali kabila ka niiyɔrɔ mɛn sɔrɔn, a ni a so bailu ni a so mɛsɛnilu, woilu le wo ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Kalabe ka niiyɔrɔ wɔrɔnwulana mɛn ta, wo kɛra Daan kabila ta le ri, bonkɔndɔla bɛɛ ni a ta. ");
INSERT INTO msc_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Ii la niiyɔrɔ soilu le ɲin: Sora, Ɛsitahɔla, Iri Semɛsi, ");
INSERT INTO msc_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","Saalabin, Ajalɔn, Jitila, ");
INSERT INTO msc_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","Elɔn, Timina, Ɛkɛron, ");
INSERT INTO msc_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","Eliteke, Kibetɔn, Baalata, ");
INSERT INTO msc_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","Jehuda, Bene Beraka, Kati-Rimɔn, ");
INSERT INTO msc_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","Jarakɔn tenkeilu, Rakɔn, a ni duu mɛn ye Jafa so laminin dɔ. ");
INSERT INTO msc_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","48","Daan kabila ka niiyɔrɔ mɛn sɔrɔn, a ni a so bailu ni a so mɛsɛnilu, wo le wo ri, bonkɔndɔla bɛɛ ni a ta. Kɔni ii la duu bɔsira le ii la. Wo kɔ rɔ, ii wara Lesɛmu so kɛlɛ. Ii ka so mira ka sokɔndɔ mɔɔilu bɛɛ faa fanmuru la, ka ii sii ye. Ii ka ii benba tɔɔ la so wo la, ka a kili ko Daan. ");
INSERT INTO msc_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Nba, Isirayɛlikailu banda jamana bɛɛ ratalala tuma mɛn na, ii ka niiyɔrɔ do di Nun dencɛ Josuwe fanan ma. ");
INSERT INTO msc_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","A ka so mɛn ɲinin ii fɛ, ii ka wo di a ma ikomin Allabatala ka a fɔ ɲa mɛn ma. Ii ka Timinata Sera so le di a ma, mɛn ye Efirayimu kabila la koyinkɛ ma yɔrɔ rɔ. Josuwe ka so wo lɔ kokura ka a sii ye. ");
INSERT INTO msc_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Awa, Alla la sarakalasela Elasari ni Nun dencɛ Josuwe ni Isirayɛlikailu la ɲɛmɔɔilu ka kalabe kɛ ka niiyɔrɔ do di kabila kelen kelenna bɛɛ ma. Ii ka kalabe wo kɛ Allabatala ɲakɔrɔ a la faaninbon da la Silo. Ii ka jamana bɛɛ ratalan ka ban wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Allabatala ka a fɔ Josuwe yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","«I ye a fɔ Isirayɛlikailu yɛ ko ii ye so doilu suwandi ka ii kɛ makandanni soilu ri, ikomin n ka a fɔ ai yɛ ɲa mɛn ma ka fara Musa la. ");
INSERT INTO msc_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Ni mɔɔ do filira ka mɔɔ faa, ka a tɛrɛn a ma a lawuli a ma, wo tii ri se a borila ka wa a jɛrɛ makandanni so woilu la. Wo rɔ, a ri a jɛrɛ tala sayabatɔ sɔrɔn ɲɔɔn na, mɛn ka kan ka wo ta sara. ");
INSERT INTO msc_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Ni mɔɔfaala ka a bori ka wa so woilu do la, a wa se ye, a ye a lɔ so donda la fɔlɔ. Ko mɛn taminni, a ri wo ɲafɔ so mɔɔbakɔrɔilu yɛ ye. Woilu ri a ladon so kɔndɔ ka siibon di a ma. A ri to ii wara ye. ");
INSERT INTO msc_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Ni sayabatɔ ta saralila ka mɔɔfaala kɔsaran fɔɔ so kɔndɔ, sokɔndɔ mɔɔilu kana mɔɔfaala don wo bolo, baa mɔɔfaala ma mɔɔ wo faa a lagboyaɲɛ ma. A ka a faa le, a ma a lawuli a ma. ");
INSERT INTO msc_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Mɔɔfaala ye to so kɔndɔ ye fɔɔ jama wa ban a la kititɛɛla ka a fɔ ko tuɲa wo rɔ, ko a ma a lawuli a ma ka mɔɔ wo faa. Ii wa ban kiti wo tɛɛla, a ye to so kɔndɔ ye fɔlɔ fɔɔ Alla la sarakalasela kuntiiba wa sa, mɛn kɔnin ye kuntiibaya la waati wo la. Ni wo sara, mɔɔfaala ri se a kɔsɛla a jɛrɛ wara, a ka a bori ka bɔ so mɛn kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Awa, Isirayɛlikailu ka so sawa bila a dan na Juridɛn Ba telebe rɔ ka ii kɛ makandanni soilu ri. Ii ka Kedɛsi suwandi a ni Sɛkɛmu ni Kiriyati Ariba. Kedɛsi, mɛn ye Kalile mara rɔ, wo ye Nafitali kabila la duu koyinkɛ ma yɔrɔ le rɔ. Sɛkɛmu ye Efirayimu kabila la duu koyinkɛ ma yɔrɔ rɔ. Kiriyati Ariba ye kilila fanan ko Heburɔn. Wo ye Yahuda kabila la duu koyinkɛ ma yɔrɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Ii ka so sawa fanan bila a dan na Juridɛn Ba kɔma, Jeriko so telebɔ rɔ. Ii ka Bɛsɛri suwandi, a ni Ramɔtu ni Kolan. Bɛsɛri ye wula kɔndɔ Rubɛn kabila la duu rɔ. Wula wo ye gbɛkannan ba rɔ ye. Ramɔtu ye Kadi kabila la duu rɔ Kiliyadi jamana kɔndɔ. Kolan ye Manase kabila la duu rɔ Basan jamana kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Isirayɛlikailu ka so woilu suwandi ka ii kɛ makandanni soilu ri. Ni Isirayɛlika do wala Isirayɛlikailu la londan do ka mɔɔ do faa ka a tɛrɛn a ma a lawuli a ma, wo tii ri se a borila ka wa a jɛrɛ makandan so woilu do kɔndɔ ka a jɛrɛ tala sayabatɔ sɔrɔn ɲɔɔn wo la, mɛn ka kan ka wo ta sara. A ri to ye sa a kana faa sani a la kiti ye ban tɛɛla. ");
INSERT INTO msc_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Lebi bɔnsɔnilu la kabila kuntiilu wara Alla la sarakalasela Elasari ni Nun dencɛ Josuwe tɛrɛn ye, a ni Isirayɛlika doilu la kabilailu kuntiilu. ");
INSERT INTO msc_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","Ii wara woilu tɛrɛn Silo so kɔndɔ Kanaan jamana rɔ. Ii ka a fɔ ii yɛ ko: «Allabatala ka jamarili di ka fara Musa la ko so doilu ye di an ma, mɛnilu ri kɛ an siiyɔrɔilu ri. Ko duu fanan ye di an ma so woilu laminin dɔ, mɛn di kɛ an na kolofenilu damaɲinin diyailu ri.» ");
INSERT INTO msc_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Nba, ka bɛn Allabatala la jamarili wo ma, Isirayɛlikailu ka so doilu ni woilu kolofenilu damaɲinin diyailu di Lebi bɔnsɔnilu ma. So woilu tɛrɛ ye Isirayɛlika doilu la duukoloilu kan. ");
INSERT INTO msc_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Matɛɛli ka Kohati la bonkɔndɔla fɔlɔ mira. Wo rɔ, Isirayɛlikailu ka so tan ni sawa di Alla la sarakalasela Haruna la denbaya ma, baa Haruna la denbaya tɛrɛ ye Kohati la bonkɔndɔla fan kelen de ri. Ii ka so mɛnilu di, woilu ye Yahuda kabila la duu rɔ, a ni Simeyɔn kabila ta, ni Bɛniyaminu kabila ta. ");
INSERT INTO msc_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Isirayɛlikailu ka so tan de di Kohati la bonkɔndɔla tɔilu ma. So woilu ye Efirayimu kabila la duu rɔ, a ni Daan kabila ta, ni Manase kabila talantɛ ta. ");
INSERT INTO msc_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Ii ka so tan ni sawa fanan di Kerisɔn na bonkɔndɔla ma. So woilu ye Isakari kabila la duu rɔ, a ni Asɛri kabila ta, ni Nafitali kabila ta, ni Manase kabila talantɛ ta, wo mɛn ye Basan jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Ii ka so tan ni fila le di Merari la bonkɔndɔla ma. So woilu ye Rubɛn kabila la duu rɔ, a ni Kadi ta ni Sabulɔn ta. ");
INSERT INTO msc_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Isirayɛlikailu ka so woilu di Lebi bɔnsɔnilu ma, a bɛɛ ni a kolofenilu damaɲinin diyailu. Ii ka a kɛ ten ka a bɛn Allabatala la jamarili ma, a ka mɛn di ka fara Musa la. ");
INSERT INTO msc_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","Awa, Haruna la denbaya bɔni Kohati la bonkɔndɔla le rɔ, mɛn ye Lebi bɔnsɔnilu rɔ. Isirayɛlikailu ka kalabe kɛ tuma mɛn na, kala ka Kohati la bonkɔndɔla fɔlɔ le ta. Wo rɔ, Isirayɛlikailu ka soilu di Haruna la denbaya fɔlɔ ma. Ii ka so doilu di ii ma Yahuda kabila la duu rɔ, a ni Simeyɔn kabila ta. ");
INSERT INTO msc_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Ii ka Kiriyati Ariba so ni a laminin duu di ii ma. So wo ye Yahuda kabila la duu koyinkɛ ma yɔrɔ rɔ. A tɔɔ lani tɛrɛ Ariba la, mɛn ye Anaki fa ri. Kɔni a tɔɔ le sisen ko Heburɔn. ");
INSERT INTO msc_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Kɔni Heburɔn so sɛnɛilu ni a so mɛsɛnilu tun dira Jefunɛ dencɛ Kalɛbu ma fɔlɔ ka a kɛ a ta ri. ");
INSERT INTO msc_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","14","Heburɔn tɛrɛ makandanni so do le ri. Ii ka Heburɔn so di Alla la sarakalasela Haruna la denbaya ma, ka Libina so la wo kan, a ni Jatira ni Esitemoha, ");
INSERT INTO msc_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","16","Holɔn ni Debiri ni Ayin ni Juta a ni Bɛti-Sɛmɛsi. Wo bɛɛ ladɛnnin kɛra so kɔnɔndɔ le ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. So woilu bɛɛ ye Yahuda kabila la duu rɔ, a ni Simeyɔn kabila ta. ");
INSERT INTO msc_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","18","Ii ka Kibeyɔn ni Keba fanan di ii ma, a ni Anatɔti ni Alamɔn. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. So naanin wo bɛɛ ye Bɛniyaminu kabila la duu rɔ. ");
INSERT INTO msc_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Awa, Haruna la denbaya, Alla la sarakalaselailu kɔnin, ii ka so tan ni sawa sɔrɔn, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Wo kɔ rɔ, Isirayɛlikailu ka soilu di Lebi bɔnsɔn Kohati la bonkɔndɔla denbaya tɔilu ma. So woilu ye Efirayimu kabila la duu le rɔ. ");
INSERT INTO msc_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","22","Ii ka Sɛkɛmu so di ii ma ye, mɛn ye Efirayimu kabila la duu koyinkɛ ma yɔrɔ rɔ. Sɛkɛmu ye makandanni so le ri. Ii ka Kɛsɛri so fanan di ii ma, a ni Kibisayimu ni Bɛti-Hɔrɔn. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","24","Ii ka so doilu di ii ma Daan kabila la duu rɔ fanan. Ii ka Eliteke di ii ma ye, a ni Kibetɔn ni Ajalɔn ni Kati-Rimɔn. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Ka a la wo kan, ii ka so doilu fanan di ii ma, Manase kabila talantɛ la duu rɔ, Tanaki a ni Kati-Rimɔn kɔnin. Wo bɛɛ ladɛnnin kɛra so fila le ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Nba, Isirayɛlikailu ka so tan woilu di Kohati la bonkɔndɔla denbaya tɔilu ma, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Wo kɔ rɔ, Isirayɛlikailu ka so doilu di Lebi bɔnsɔn Kerisɔn la bonkɔndɔla ma Manase kabila talantɛ la duu rɔ, mɛn ye telebɔ rɔ. Ii ka Kolan di ii ma. Kolan ye makandanni so do le ri. A ye Basan jamana rɔ. Ii ka Besetera fanan di ii ma. Wo bɛɛ ladɛnnin kɛra so fila ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","29","Ii ka so doilu fanan di ii ma Isakari kabila la duu rɔ. Ii ka Kisiyɔn di ii ma ye, a ni Dabɛrata ni Jaramutu ni En Kanimu. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","31","Ka a la woilu kan, ii ka so doilu di ii ma Asɛri kabila la duu rɔ. Ii ka Misala di ii ma ye, a ni Abidɔn ni Hɛlikata ni Rehobu. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Ii ka so doilu fanan di ii ma Nafitali kabila la duu rɔ. Ii ka Kedɛsi di ii ma ye, mɛn ye makandanni so do ri. Kedɛsi ye Kalile mara rɔ. Ii ka Hamɔtu Dori so la wo kan, a ni Karitan. Wo bɛɛ ladɛnnin kɛra so sawa le ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Nba, Isirayɛlikailu ka so tan ni sawa woilu di Kerisɔn kabila ma, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","35","Wo kɔ rɔ, Isirayɛlikailu ka so doilu di Lebi bɔnsɔnilu tɔilu fanan ma, mɛn ye Merari la bonkɔndɔla ri. Ii ka Jokineyamu so di ii ma Sabulɔn kabila la duu rɔ, ka Karita so la wo kan, a ni Dimina ni Nahalali. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","37","Ii ka soilu fanan di ii ma Rubɛn kabila la duu rɔ. Ii ka Bɛsɛri di ii ma ye, ka Jahasi so la wo kan, a ni Kedemɔtu, a ni Mefata. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","39","Ii ka soilu fanan di ii ma Kadi kabila la duu rɔ. Ii ka Ramɔtu di ii ma ye, mɛn ye makandanni so do ri. A ye Kiliyadi jamana rɔ. Ii ka Mahanimu so la wo kan, a ni Hɛsibon ni Jasɛri. Wo bɛɛ ladɛnnin kɛra so naanin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Nba, Isirayɛlikailu ka so tan ni fila woilu di Lebi bɔnsɔn toilu ma, Merari la bonkɔndɔla kɔnin. ");
INSERT INTO msc_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Lebi bɔnsɔnilu ka so mɛnilu sɔrɔn Isirayɛlikailu la niiyɔrɔilu rɔ, wo bɛɛ ladɛnnin kɛra so binaanin ni so seyin de ri, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","So wo bɛɛ dira ii ma, a bɛɛ ni a kolofenilu damaɲinin diyailu. ");
INSERT INTO msc_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Nba, Allabatala ka jamana wo bɛɛ di Isirayɛlikailu ma, ikomin a tun ka lahidi ta ii benbailu yɛ ɲa mɛn ma. Isirayɛlikailu ka jamana mira ka a kɛ ii siiyɔrɔ ri. ");
INSERT INTO msc_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Allabatala ka hɛrɛ kɛ ii yɛ ii laminin dandeilu bɛɛ rɔ, ikomin a ka lahidi ta ii benbailu yɛ ɲa mɛn ma. A ka sebaya di ii ma ii juuilu bɛɛ kan. Woilu si ma se ii lɔla ii ɲɛ. ");
INSERT INTO msc_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Allabatala ka lahidi mɛnilu ta Isirayɛlikailu yɛ, a ka wo bɛɛ dafa. Lahidi kelen ma to ni a ma mɛn dafa. ");
INSERT INTO msc_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Nba, Josuwe ka Rubɛn kabila makili, a ni Kadi kabila ni Manase kabila talantɛ. ");
INSERT INTO msc_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","A ka a fɔ ii yɛ ko: «Allabatala la baaraden Musa ka jamarili mɛnilu di, ai ra wo bɛɛ kɛ koɲuma. N ka jamarili mɛnilu di, ai ra wo bɛɛ fanan kɛ a ɲa ma. ");
INSERT INTO msc_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Waati jan kɔrɔ haan bi, ai ma ai ban ai badenma Isirayɛlikailu dɛmɛnna. Ai Maari Allabatala ka ai lɔ mɛn kɛla, ai ra wo kɛ. ");
INSERT INTO msc_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Ai Maari Allabatala ka lahidi ta ko a ri ai badenmailu lasii hɛrɛ rɔ yan. Sisen, a ra lahidi wo dafa. Nba, sisen ai ye ai kɔsɛ ka wa ai jɛrɛ la duu kan, Musa ka mɛn di ai ma Juridɛn Ba telebɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Kɔni Musa ka a fɔ ai yɛ ko ai ye ai Maari Allabatala kanin kosɛbɛ, ko ai ye a la sila taama. Ko ai ye a la jamariliilu bɛɛ mira ka woilu kɛ. Ko ai ye ai fasa a ma. Ko ai ye a bato ai jusukun bɛɛ la, a ni ai sɛɛbɛ bɛɛ la. Ai ye jamarili ni sariya woilu latelen kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","8","Josuwe banni wo fɔla, a ka duwawu kɛ ii yɛ, ka sila di ii ma. A ka a fɔ ko: «Ai ra nanfulu ba sɔrɔn. Ai ye wa woilu ri ai wara. Kolofen siyaman ye ai bolo, a ni wodigbɛilu ni saninilu ni sulanɛɛilu ni nɛɛfin. Faanin siyaman fanan ye ai bolo. Ai ka nanfulu wo bɛɛ mira ai juuilu le la. Sisen, ai ye wa woilu ratala ai ni ai badenmailu tɛma.» Wo rɔ, ii ka ii kɔsɛ ka wa ii wara. Musa tun ka duu do di Manase kabila talantɛ ma Basan mara rɔ, Juridɛn Ba telebɔ rɔ. Josuwe le ka duu do di kabila wo talantɛ tɔ kelen ma Juridɛn telebe rɔ, ii badenma Isirayɛlika tɔilu tɛma. ");
INSERT INTO msc_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Rubɛn kabila mɔɔilu ni Kadi kabila mɔɔilu ni Manase kabila talantɛ mɔɔilu bɔra Isirayɛlika tɔilu fɛ Silo so kɔndɔ, ni a ye Kanaan jamana rɔ. Ii ka sila mira ka wa ii wara Kiliyadi jamana rɔ. Yɔrɔ wo le dira ii ma, ka a kɛ ii ta ri, ikomin Allabatala ka a fɔ ɲa mɛn ma ka fara Musa la. ");
INSERT INTO msc_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Ii se mɛn kɛni Kelilɔti, ii ka saraka janin diya belebele ba do lɔ Juridɛn Ba dala Kanaan jamana rɔ ye. ");
INSERT INTO msc_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","A fɔra Isirayɛlika tɔilu yɛ ko Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ ka saraka janin diya belebele ba do lɔ Juridɛn Ba dala Kanaan jamana rɔ Kelilɔti tɔrɔfɛ. ");
INSERT INTO msc_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Ii ka wo mɛn tuma mɛn na, ii bɛɛ ka ii ɲɔɔn nadɛn Silo, ko ii watɔ kabila woilu kɛlɛla. ");
INSERT INTO msc_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Isirayɛlikailu ka Alla la sarakalasela Elasari dencɛ Finehasi kelaya, ko a ye wa Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ tɛrɛn ye Kiliyadi jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Ii ka jama ɲɛmɔɔ mɔɔ tan lawa a fɛ, kabila kelen ɲɛmɔɔ kelen. Ɲɛmɔɔ tan woilu bɛɛ ye denbaya kuntiilu le ri Isirayɛlikailu la bonkɔndɔlailu tɛma. ");
INSERT INTO msc_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Woilu wara Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ tɛrɛn Kiliyadi, ka a fɔ ii yɛ ko: ");
INSERT INTO msc_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","«Allabatala la mɔɔilu bɛɛ ka a fɔ ko ai ra bɔ Allabatala la sila kan, ka saraka janin diya lɔ ai jɛrɛ yɛ. Ko nfenna ai ka kojuu ba ɲin kɛ Isirayɛlikailu Maari Alla la? Ko nfenna ai ra murunti Allabatala kanma ten? ");
INSERT INTO msc_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","An tɛrɛ ra tiɲani mɛn kɛ Peyɔri ye, wo dɔɔman wa? Adon, haan bi an tɛrɛ ma an nasɛninya wo julumun na ko ma hali a ra fitinna jankarɔ lana Allabatala la jama bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Ko a ye di? Ko ai ye bɔla Allabatala la sila kan wo rɔ sisen wa? Ko ni ai muruntira Allabatala kanma bi, sini a ri dimin Isirayɛlikailu jama bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Ko ni a ye ai ɲana ko ai la jamana ma bɛn Allabatala bato le ma, ai ye ai kɔsɛ a la jamana ma, a la daa makɛ faaninbon lɔni mɛn kɔndɔ. Ko ai ye wa ai sii andeilu fɛ ye. Ko kɔni ai kana saraka janin diya gbɛrɛ lɔ ai jɛrɛ yɛ, ka wo la an na Maari Allabatala ta kan. Ko ai kana murunti Allabatala kanma ten, wala ka murunti andeilu ma. ");
INSERT INTO msc_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Ko ai jɛrɛ ka a lɔn ko Serahi dencɛ Akan ka kojuu ba kɛ waati taminni, baa a ka fen do ta, Allabatala tun ka tɔn sii mɛn tala. Ko Allabatala la mɔnɛ ma se Isirayɛlikailu bɛɛ ma wo rɔ wa? Ko Akana kelen ma faa a la kojuu kosɔn de?» ");
INSERT INTO msc_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ ka kabila gbɛrɛilu la bonkɔndɔlailu ɲɛmɔɔilu jabi. ");
INSERT INTO msc_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","Ii ka a fɔ ko: «Alla le ye Sebɛɛtii ri, ale le ye Allabatala ri! Alla le ye Sebɛɛtii ri, ale le Allabatala ri! Ale ka a lɔn andeilu ka saraka janin diya lɔ kun mɛn na. Fo Isirayɛlikailu fanan ye a lɔn. Ni a kɛra kojuu ba le ri Allabatala ma, wala murunti ko ri a kanma, ii ka kan ka an halaki bi. ");
INSERT INTO msc_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","An ma saraka janin diya wo lɔ an bɔ kanma Allabatala la sila kan. An ma a lɔ sarakailu janinta kanma, wala ka suman sarakailu wala jususuma sarakailu bɔ a kan. Ni an ka a lɔ kun woilu le la, Allabatala jɛrɛ ye wo hakɛ bɔ an dɔ. ");
INSERT INTO msc_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","Kɔni wo ko tɛ. An ka a lɔ hamin de kosɔn, baa an silanni de ko ai bɔnsɔnilu kana a fɔ an bɔnsɔnilu yɛ sini natɔ ko: ‹Dɛ ɲuman ye ai ni Isirayɛlikailu Maari Allabatala tɛma? ");
INSERT INTO msc_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Allabatala jɛrɛ le ma Juridɛn Ba bila an ni ai Rubɛn kabila ni Kadi kabila mɔɔilu tɛma wa? Ai niiyɔrɔ foyi le tɛ Allabatala fɛ.› Nba, ni wo kɛra, ai bɔnsɔnilu ri kɛ sababu ri an bɔnsɔnilu ri Allabatala bato boloka. ");
INSERT INTO msc_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","Wo le kosɔn an ka a fɔ ko an di saraka janin diya ɲin lɔ. Kɔni an ma a lɔ ko an ye saraka janintailu janinna a kan, wala ka saraka gbɛrɛilu bɔ a kan. ");
INSERT INTO msc_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","An ka a lɔ le, sa a ri kɛ sereya ri ai ni andeilu tɛma, a ni ai bɔnsɔnilu ni an bɔnsɔnilu tɛma, ko andeilu fanan ye Allabatala ɲakɔrɔ. Ko an fanan ye an na saraka janintailu janinna ye, ka an na saraka gbɛrɛilu ni jususuma sarakailu fanan bɔ a yɛ ye. Saraka bɔ diya wo ri kɛ sababu ri, ai bɔnsɔnilu ti nala a fɔla an bɔnsɔnilu yɛ sini natɔ ko, ‹ai niiyɔrɔ foyi tɛ Allabatala fɛ.› ");
INSERT INTO msc_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","An ka a fɔ ko lon do rɔ ni ii ka kuma wo fɔ an yɛ, wala an bɔnsɔnilu yɛ, an di a fɔ ii yɛ ko, ‹ii ye Allabatala saraka janin diya bisiki wo ragbɛ. Ko an benbailu le ka wo lɔ. Ko kɔni ii ma a lɔ saraka janinta kanma, wala ka saraka gbɛrɛ bɔ a kan de. Ko ii ka a lɔ sa a ri kɛ sereya ri ai ni andeilu tɛma.› ");
INSERT INTO msc_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","Nba, a miriya tɛ an na fewu ka murunti Allabatala kanma ka bɔ a la sila kan. An ma saraka janin diya wo lɔ saraka janintailu janin kanma a kan, wala ka suman saraka wala sarakailu gbɛrɛilu bɔ a kan. An tɛ a fɛ ka saraka bɔ saraka janin diya si kan, fo an Maari Allabatala saraka janin diya, mɛn ye a la daa makɛ faaninbon donda la.» ");
INSERT INTO msc_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Nba Rubɛn kabila ni Kadi kabila ni Manase kabila ka kuma mɛn fɔ, wo diyara Alla la sarakalasela Finehasi ni jama la ɲɛmɔɔ tan wo yɛ, Isirayɛlikailu denbaya kuntii mɛnilu nani Finehasi fɛ kɔnin. ");
INSERT INTO msc_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Alla la sarakalasela Elasari dencɛ Finehasi ka Rubɛn kabila ni Kadi kabila ni Manase kabila talantɛ jabi: «An bɛɛ ka a lɔn sisen ko Allabatala ye an fɛ, baa a miriya tɛrɛ ye an na ko ai ka kojuu ba mɛn kɛ Allabatala la, ai ma wo kɛ. Wo rɔ, ai ra Isirayɛlikailu lakandan Allabatala bolo, baa ai ma a fanka labe andeilu bɛɛ kan.» ");
INSERT INTO msc_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Nba, Alla la sarakalasela Elasari dencɛ Finehasi ni ɲɛmɔɔ tan woilu bɔra Rubɛn kabila ni Kadi kabila wara Kiliyadi jamana rɔ, ka ii kɔsɛ Kanaan jamana rɔ. Ii seni ye, ii ka dantɛɛli kɛ Isirayɛlikailu yɛ. ");
INSERT INTO msc_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Dantɛɛli wo diyara ii yɛ. Ii ka Allabatala tando. Ii miri tɛrɛ ye a la ɲa mɛn ma kɔrɔman ko ii ri wa Rubɛn kabila ni Kadi kabila kɛlɛ ka ii la jamana ratiɲan, kɔnin dantɛɛli wo kosɔn ii ma ii miri wo ma butun. ");
INSERT INTO msc_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Rubɛn kabila ni Kadi kabila ka saraka bɔ diya tɔɔ la ko «Sereya le a ri an tɛma ko Allabatala kelen pe le Alla ri.» ");
INSERT INTO msc_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Awa, Allabatala ka hɛrɛ di Isirayɛlikailu ma waati jan kɔrɔ, ka ii bɔ ii juuilu bolo, mɛnilu ye ii laminin dɔ. Josuwe tun da kɛ mɔɔbakɔrɔ ba ri. ");
INSERT INTO msc_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","Lon do rɔ, Josuwe ka Isirayɛlikailu bɛɛ makili, a gbengben ii la mɔɔbailu ni ii la ɲɛmɔɔilu ni ii la kititɛɛlailu ni ii la kuntiilu. A ka a fɔ ii yɛ ko: «N da kɛ mɔɔbakɔrɔ ba ri. ");
INSERT INTO msc_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Ai Maari Allabatala ka ko mɛnilu kɛ jamana ɲin mɔɔilu la ai kosɔn, ai ka wo bɛɛ yen. Baa ai Maari Allabatala jɛrɛ le ka ii kɛlɛ ai yɛ. ");
INSERT INTO msc_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","A ragbɛ, yɔrɔ mɛn ye bɔla Juridɛn Ba la ka wa se fɔɔ Kɔɔji ba ma telebe rɔ, n ka kalabe kɛ ka duu wo bɛɛ ratala ai la kabilailu tɛma. N ka siya mɛnilu kɛlɛ ka ii la duu mira ii la, a ni siya mɛnilu la duu ma mira ii la fɔlɔ, n ka wo bɛɛ di ai ma ka a kɛ ai ta ri. ");
INSERT INTO msc_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Ai Maari Allabatala jɛrɛ le ri mɔɔ woilu gbɛn ka ii mabɔ ai la. Ale le ri a kɛ, ii ri ii bori ai ɲɛ. Ai ri ii la jamana mira ka a kɛ ai ta ri, ikomin ai Maari Allabatala ka lahidi ta ai yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","«Fen fen sɛbɛni Musa la sariya kitabu rɔ, ai ye ai sɛɛbɛ don kosɛbɛ wo bɛɛ bonya ma ka wo kɛ. Ai kana bɔ sila wo kan ɲa si ma. ");
INSERT INTO msc_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Ai kana duɲɔɔnya don ai ni siya gbɛrɛilu tɛma, mɛnilu ye ai tɛma fɔlɔ. Ai kana ii maarilu tara, ai kana ai kali woilu tɔɔ la. Ai kana ai tin birin ii ɲana ka ii bato. ");
INSERT INTO msc_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Ai ye ai fasa ai Maari Allabatala ma, ikomin ai darini a kɛla ɲa mɛn ma kɔrɔman haan bi. ");
INSERT INTO msc_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Allabatala ka siya ba ni fankamailu le gbɛn ka bɔ ai ɲɛrɔ. Haan bi woilu si ma se a lɔla ai yɛ. ");
INSERT INTO msc_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Ai rɔ mɔɔ kelen di se ai juuilu mɔɔ waa kelen gbɛnna, baa ai Maari Allabatala le ye kɛlɛ kɛla ai yɛ, ikomin a ka a lahidi ta ai yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Nba, ai ye ai janto ai jɛrɛ rɔ kosɛbɛ ka ai Maari Allabatala kanin. ");
INSERT INTO msc_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","«Kɔni ni ai ka ai ban Alla rɔ ka kafu siyailu kan, mɛnilu kɔnin ye ai tɛma fɔlɔ, ka woilu denmusoilu furu, ka teriya don ai ni ii tɛma, ");
INSERT INTO msc_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ai ye la a la ko ai Maari Allabatala ti nala siya woilu gbɛnna ai ɲɛ butun. Siya woilu ri kɛ ikomin miralifen, mɛn di ai mira, ka kɛ ikomin denka, ai natɔ bela mɛn kɔndɔ. Ii ri kɛ ikomin gbiɲɛ, mɛn di ai gbasi ai kɔ rɔ, ka kɛ ikomin wɔnin, mɛn ye ai ɲailu rɔ. A laban na, ai ri tunun jamana ɲuma ɲin kɔndɔ, ai Maari Allabatala ka mɛn di ai ma. ");
INSERT INTO msc_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","«Nba, a tɛ mɛn bakɛ n na waati ri se. Ai ka a lɔn ai jusukun ni ai sɔnɔmɛ bɛɛ rɔ ko ai Maari Allabatala ka lahidi ɲuma mɛnilu ta ai yɛ, ko wo si ma to ye, a ma mɛn dafa. A ka lahidi wo bɛɛ dafa ai yɛ. Lahidi si ma to ye, a ma mɛn dafa. ");
INSERT INTO msc_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","«Kɔni a ka a la lahidi ɲuma bɛɛ dafa ɲa mɛn ma, a ri a la masilannikan bɛɛ kɛ ai la wo ɲa le ma, fɔɔ ka ai halaki jamana ɲuma ɲin kɔndɔ, a ka mɛn di ai ma. ");
INSERT INTO msc_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ai Maari Allabatala ka teriya mɛn ta ka a don ai ni a tɛma, ni ai ka ai ban wo jamariliilu bonyala fo ka wa ai birin maari gbɛrɛilu ɲɛ ka woilu bato, Allabatala ri mɔnɛ ai kanma kosɛbɛ. Ni wo kɛra, ai ri halaki jona jamana ɲuma ɲin kɔndɔ, a ka mɛn di ai ma.» ");
INSERT INTO msc_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Nba, Josuwe ka Isirayɛlikailu la kabilailu bɛɛ ladɛn Sɛkɛmu. A ka Isirayɛlikailu la mɔɔbailu makili, a ni jama ɲɛmɔɔilu ni kititɛɛlailu ni kuntiilu. Ii bɛɛ nara ii lɔ Alla ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Josuwe ka a fɔ jama bɛɛ ladɛnnin yɛ ko: «Isirayɛlikailu Maari Allabatala ka a fɔ ko: ‹Fɔlɔfɔlɔ, ai benbailu siini tɛrɛ Efirati Ba kɔ. Ai benba Teraki tɛrɛ ye wo do le ri, mɛn ye Iburahima ni Nakɔri fa ri. Ai benbailu tɛrɛ ye maari gbɛrɛilu le batola ye. ");
INSERT INTO msc_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Kɔni nde le ka ai benba Iburahima labɔ jamana wo rɔ Efirati Ba kɔ, ka a ta ka wa a ri Kanaan jamana bɛɛ rɔ. N ka a dencɛ Isiyaka di a ma, ka a bɔnsɔnilu siyaya. ");
INSERT INTO msc_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","N ka dencɛ fila di Isiyaka ma, Yakuba ni Esawu. N ka Seyiri koyinkɛ ma yɔrɔilu di Esawu ma, ka a kɛ a ta ri. Kɔni Yakuba ni a dencɛilu wara Misiran. ");
INSERT INTO msc_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Wo kɛ mɛn ɲin, n ka Musa ni Haruna lawa ai benbailu ma Misiran. N ka Misirankailu gbasi tɔrɔya siyaman na ye, ka ban ka ai labɔ jamana wo kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","N ka ai benbailu labɔ Misiran jamana rɔ tuma mɛn na, ii wara se Kɔɔji Fararɔbin ma. Misirankailu ka ii kɔsaran sowontoroilu ni soilu la. ");
INSERT INTO msc_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Ai benbailu ka ii makasi nde Allabatala yɛ, ko n ye ii dɛmɛn. N ka dibi don ii ni Misirankailu tɛma. N ka kɔɔji lana Misirankailu kan, ka ii bɛɛ latunun. N ka mɛn kɛ Misirankailu la, ai jɛrɛ ka wo lɔn. Wo kɔ rɔ, ai ka waati jan kɛ wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","N ka ai lawa Amɔrikailu la jamana kɔndɔ, mɛn ye Juridɛn Ba telebɔ rɔ. Amɔrikailu ka ai kɛlɛ, kɔni n ka ii bila ai fanka kɔrɔ. Ai ka ii la jamana mira ka a kɛ ai ta ri, ka a masɔrɔn n tɛrɛ ye ii halakila ai ɲɛ le. ");
INSERT INTO msc_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Sipɔri dencɛ Balaki fanan wulira ko a ye ai kɛlɛla. Mowabukailu la mansa le tɛrɛ a ri. A ka kela lawa Beyɔri dencɛ Balami ma, ko a ye na ai danka. ");
INSERT INTO msc_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Kɔni n ma sɔn Balami ye ai danka. Wo le rɔ, a ka duwawu le kɛ ai yɛ. N ka ai tala Balaki bolo wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Wo kɔ rɔ, ai ka Juridɛn Ba tɛɛ ka wa se Jeriko so ma. Jerikokailu ka ai kɛlɛ, kɔni n ka ii bila ai la fanka kɔrɔ. Amɔrikailu fanan ka ai kɛlɛ, a ni Peresikailu ni Kanaankailu ni Hɛtikailu ni Kirikasikailu ni Hifikailu ni Jebusikailu. Kɔni n ka woilu bɛɛ bila ai la fanka kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","N ka woilu masilan, ka ii gbɛn ai ɲɛrɔ. Ai la fanmurutiilu ni ai la biɲɛilu ma kɛ sababu ri de ko ai sera ii la. Nde le ka ii gbɛn ikomin n ka Amɔrikailu la mansa fila gbɛn ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","N ka duu di ai ma ten, ai ma mɛn sɛnɛ. N ka soilu di ai ma ka ai sii woilu kɔndɔ, soilu ai ma mɛnilu lɔ. N ka rɛsɛnfɛilu ni olibiye tuilu di ai ma, ai ma mɛnilu turu. Ai ye rɛsɛnju ni olibiyeju woilu denilu dɔɔnna.›» ");
INSERT INTO msc_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","«Ai ye silan Allabatala yɛ sisen, ka a la sila taama gbɛya ni kankelentiiya rɔ. Ka ai benbailu to Efirati Ba kɔ, ii tɛrɛ ye maari doilu batola. Ka ii to Misiran, ii tɛrɛ ye dogbɛrɛilu batola. Sisen, ai ye maari woilu bɛɛ to ye, ka Allabatala bato. ");
INSERT INTO msc_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ni Allabatala bato ma di ai yɛ, ai ye maarilu suwandi bi, ai ye a fɛ ka mɛnilu bato. Ai benbailu tɛrɛ ye maari mɛnilu batola Efirati Ba kɔ, ai ye woilu suwandi. Ni wo tɛ, ai ye Amɔrikailu la maarilu suwandi, baa ai siini Amɔrikailu la jamana le rɔ ɲin. Nde kɔnin ni n na denbaya, andeilu ri Allabatala bato.» ");
INSERT INTO msc_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Jama ka Josuwe jabi: «Wo kuma tɛ! Andeilu ti nala an banna Allabatala dɔ ka maari gbɛrɛ bato, ");
INSERT INTO msc_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","baa an Maari Allabatala le ka andeilu ni an benbailu labɔ jɔnya rɔ Misiran. Ale le ka tɔɔmasereilu kɛ an jɛrɛ ɲana. Ale le ka an nakanda an na taama bɛɛ rɔ, ka an nakanda siyailu tɛma, an taminda mɛnilu la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","A ka siyailu bɛɛ gbɛn ka ii bɔ an ɲɛ, hali Amɔrika mɛnilu siini tɛrɛ jamana ɲin dɔ. Wo le kosɔn, andeilu fanan di Allabatala le bato, baa ale le ye an Maari Alla ri.» ");
INSERT INTO msc_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Josuwe ka a fɔ jama yɛ ko: «Ai ti nala sela Allabatala batola, baa Alla sɛniman de. A tɛ sɔn muumɛ ai ye batofen gbɛrɛ la ale kan ka a bato. Ni ai ka a la sariya tiɲan ka kojuuilu kɛ, a ti nala yafala ai ma. ");
INSERT INTO msc_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Allabatala ka koɲumailu kɛ ai yɛ. Kɔni ni ai ka a bato boloka ka wa siyailu maarilu bato, a ri wuli ai kanma. A ri kojuu kɛ ai la ka ai halaki.» ");
INSERT INTO msc_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Jama ka Josuwe jabi: «Ɛɛn de! An tɛ sɔn ka siyailu maarilu bato. An di Allabatala dɔrɔn de bato.» ");
INSERT INTO msc_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Josuwe ka a fɔ ko: «Ai ra kɛ ai jɛrɛ sere ri ko ai ra Allabatala suwandi ko ai ri a bato.» Ii ka a fɔ ko: «Ɔɔn, an ye an jɛrɛ sere ri.» ");
INSERT INTO msc_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Josuwe ka a fɔ ko: «Kɔni batofen mɛnilu ye ai bolo munun, siya gbɛrɛilu ye mɛnilu batola, ai ye woilu bɛɛ ratiɲan fewu! Ai ye ai jusu latɛɛ fewu ko ai ri Isirayɛlikailu Maari Allabatala la sila taama ka kɛ a ta le ri fewu.» ");
INSERT INTO msc_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Jama ka Josuwe jabi: «An di an Maari Allabatala bato, ka a la jamariliilu mira ka woilu kɛ.» ");
INSERT INTO msc_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Wo lon, Josuwe ka teriya sidi Isirayɛlikailu ni Allabatala tɛma Sɛkɛmu so kɔndɔ ye. A ka sariya di ii ma, a ni jamariliilu. ");
INSERT INTO msc_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Josuwe ka woilu sɛbɛ Alla la sariya kitabu rɔ. Wo kɔ rɔ, a ka kabakurun ba do ta ka a lalɔ jiriju do kɔrɔ Allabatala la yɔrɔ sɛniman dafɛ. ");
INSERT INTO msc_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Josuwe ka a fɔ jama bɛɛ yɛ ko: «Ai ye kabakurun ɲin dagbɛ. A ye an na sereya ri. Allabatala ka kuma mɛn bɛɛ fɔ an yɛ yan, kabakurun ɲin da wo bɛɛ mɛn. A lalɔni yan ka ai hankili bila a rɔ ko ai kana ai ban ai Maari Alla rɔ.» ");
INSERT INTO msc_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Josuwe banni kumala jama yɛ, a ka sila di ii ma. Bɛɛ wara a wara. ");
INSERT INTO msc_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Nba, ko woilu bɛɛ taminni kɔ, Nun dencɛ Josuwe sara, mɛn ye Allabatala la baaraden di. A ka san kɛmɛ ni san tan de sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ii ka a su don a jɛrɛ la niiyɔrɔ rɔ, mɛn dira a ma Timinata Sera so kɔndɔ. So wo ye Efirayimu kabila la koyinkɛ ma yɔrɔ le rɔ, Kaase Koyinkɛ tele kankan bolomaran dɔ. ");
INSERT INTO msc_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Isirayɛlikailu ka Allabatala bato Josuwe la tele bɛɛ rɔ. Ii tora a batola mɔɔbakɔrɔilu fanan na tele bɛɛ rɔ, Josuwe sara ka mɔɔbakɔrɔ mɛnilu to ye kɔnin. Allabatala tun ka koɲuma mɛnilu kɛ Isirayɛlikailu yɛ, mɔɔbakɔrɔ woilu ka woilu bɛɛ yen. ");
INSERT INTO msc_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Isirayɛlikailu nara Yusufu su kolo mɛnilu ri ka bɔ Misiran, ii wara woilu don Sɛkɛmu. Fɔlɔfɔlɔ ii benba Yakuba ka wodigbɛ kɛmɛ bɔ ka yɔrɔ wo san Hamɔri la mɔɔilu ma. Hamɔri tɛrɛ ye Sɛkɛmu fa le ri. Yɔrɔ wo kɛra Yusufu bɔnsɔnilu ta le ri. ");
INSERT INTO msc_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Haruna dencɛ Elasari sara tuma mɛn na, ii ka a su don Kibeya. Yɔrɔ wo le dira a dencɛ Finehasi ma. A ye Efirayimu kabila la koyinkɛ ma yɔrɔ rɔ.");
INSERT INTO msc_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Kɛlɛkuntiilu tɛrɛ ye mɔɔilu marala waati mɛn na Isirayɛlika la jamana rɔ, kɔnkɔ ba donda ye waati wo rɔ. Wo tuma cɛɛ do siini tɛrɛ Bɛtilɛhɛmu so kɔndɔ, mɛn ye Yahuda la kabila la duu rɔ. Cɛɛ wo tɔɔ ko Ɛlimɛlɛki. A muso tɔɔ ko Nahomi. Dencɛ mɔɔ fila tɛrɛ ye ii bolo. Kelen tɔɔ ko Malon, do tɔɔ ko Kiliyon. Ɛlimɛlɛki ni a la denbaya bɔni Efirata la buruju le rɔ. Awa, kɔnkɔ ba wo kɛra sababu ri, Ɛlimɛlɛki ka a muso ni a dencɛ mɔɔ fila ta ka wa Mowabu la jamana rɔ. Ii taara ii sii ye. ");
INSERT INTO msc_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Wo taminni kɔ rɔ, Ɛlimɛlɛki sara ka a muso Nahomi kelen to, a ni a dencɛ mɔɔ fila. ");
INSERT INTO msc_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Waati wo taminni kɔ rɔ, a dencɛ mɔɔ fila wo ka Mowabuka muso fila furu. Kelen tɔɔ ko Oropa. Do wo tɔɔ ko Ruti. Nba, Nahomi ni a dencɛilu ka san tan de kɛ Mowabu la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Wo kɔ rɔ, Malon ni Kiliyon sara ka ii na Nahomi kelen to, dentanya ni cɛtanya rɔ. ");
INSERT INTO msc_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Lon do rɔ, ka Nahomi to Mowabu la jamana rɔ, a fɔra a ɲana ko Allabatala ra a la ɲumaya yiraka a la mɔɔilu la. Ko a ka balo ko lanɔɔya ii yɛ. Wo rɔ, Nahomi ni a biranmuso fila ka ii rabɛn ko ii watɔ Nahomi wara Bɛtilɛhɛmu. ");
INSERT INTO msc_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ii bɔra i ɲɔɔn fɛ ii sii diya kɔrɔ rɔ ka sila mira ka wa Yahuda la kabila la duu rɔ. ");
INSERT INTO msc_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ka ii to sila kan, Nahomi ka a fɔ Oropa ni Ruti yɛ ko: «Sisen, ai fila bɛɛ ye i kɔsɛ ka wa ai nailu wara. Allabatala ye a la kaninteya yiraka ai la, ikomin ai ka kaninteya yiraka ai cɛɛilu la, mɛnilu sani, a ni nde jɛrɛ la. ");
INSERT INTO msc_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Allabatala ye ai bɛn hɛrɛ ma cɛɛ kura wara.» A banni wo fɔla, a ka ii sunbu, ii tɛrɛ ye fara bolo le ma. Denmuso fila kasira kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ii ka a fɔ Nahomi yɛ ko: «Ɛɛn! An di wa i kɔfɛ i badenmailu wara.» ");
INSERT INTO msc_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Kɔni Nahomi ka a fɔ ko: «Ai ye ai kɔsɛ ai wara, n denmusoilu. Nfenna ai ye a fɛ ka na n kɔfɛ? Baa, n di se dencɛ gbɛrɛ sɔrɔnna butun, mɛn di ai furu? ");
INSERT INTO msc_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ai ye ai kɔsɛ ai wara, n denmusoilu. Ɔɔn, ai ye wa. N da kɔrɔya furu ma. Ni wo tɛ, ni n ka n miri ko tumado n di se dencɛ sɔrɔnna ikɔ, n tɛrɛ ri wa su ɲin dɔ cɛɛ kura wara, ka dencɛ do sɔrɔn a la, ");
INSERT INTO msc_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ai ri se ai banna furu ko ma wo rɔ wa, ka ai sii ka n dencɛ woilu makɔnɔ haan ii ye bonya? Ɛɛn, n denmusoilu. N na dunuɲaratɛɛ gbɛlɛman ai ta ri, baa Allabatala jɛrɛ le ka tɔrɔya lala nde kan.» ");
INSERT INTO msc_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Wo rɔ, Oropa ni Ruti kasira ikɔ kosɛbɛ. Oropa ka a biranmuso Nahomi tuwa ka a sunbu, kɔni Ruti fasani tora Nahomi ma. ");
INSERT INTO msc_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nahomi ka a fɔ Ruti yɛ ko: «I ɲa lɔ, i kɔrɔmuso kɔsɛtɔla ka wa a la mɔɔilu ma a ni a la batofen. I fanan ye i kɔsɛ i ye wa i wara. Ɔɔn, i ye wa a kɔfɛ.» ");
INSERT INTO msc_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kɔni Ruti ka a jabi: «I kana a fɔ n yɛ ko n ye n bɔ i kɔfɛ. I kana a fɔ n yɛ ko n ye wa n wara. I wa wa yɔrɔ yɔrɔ, n di wa ye. I wa i sii yɔrɔ mɛn dɔ, n di n sii ye. I la mɔɔilu ri kɛ n na mɔɔilu ri. I Maari fanan di kɛ n Maari ri. ");
INSERT INTO msc_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","I wa sa yɔrɔ mɛn dɔ, n fanan di sa ye. Mɔɔilu ri n su don ye. Ni n ka n bɔ i kɔfɛ ni saya tɛ, Allabatala a la jakankata juu ri be n kan.» ");
INSERT INTO msc_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nba, Nahomi ka a yen ko Ruti jusu latɛɛni ko a ri wa a kɔfɛ. Wo rɔ, a ma a sɔsɔ wo kɔ. ");
INSERT INTO msc_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ii mɔɔ fila ka sila mira ka wa se Bɛtilɛhɛmu. Ii seni ye, ka so bɛɛ lamaa. So musoilu ka i ɲɔɔn maɲininka ko: «Nahomi le ye ri wa?» ");
INSERT INTO msc_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Kɔni Nahomi ka a fɔ ii yɛ ko: «Ai kana n kili de ko Nahomi butun fo Maratɔɔ, baa Alla Sebɛɛtii a ra tɔrɔya ba lase n ma. ");
INSERT INTO msc_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","N bɔtɔla yan, fen siyaman tɛrɛ ye n bolo, kɔni Allabatala a ra n bolokolon nasɛ. Ai ye n kilila nfenna wo rɔ ko Nahomi? Alla Sebɛɛtii a ra ban a kɔnkɔ donna n na. A ra n tɔrɔya kojuuya.» ");
INSERT INTO msc_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Awa, Nahomi ka a kɔsɛ Bɛtilɛhɛmu ɲa wo le ma ka bɔ Mowabu la jamana rɔ. A biranmuso Ruti mɛn ye Mowabuka di, wo nara a kɔfɛ. Ii sera Bɛtilɛhɛmu ka a tɛrɛn horija suman ka waati damirasan de tɛrɛ. ");
INSERT INTO msc_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nba, Nahomi cɛɛ mɛn sani, wo badenma do tɛrɛ ye ye, a ni mɛn ye buruju kelen mɔɔ ri. Wo tɔɔ ko Bɔwasi. Nanfulutii le, mɔɔba le. ");
INSERT INTO msc_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Lon do rɔ, Mowabuka Ruti ka a fɔ Nahomi yɛ ko: «A to n ye wa sɛnɛ rɔ. N di wa sɛnɛgban matɔmɔn kɛ baaraden do kɔ, mɛn wa hina n na ka sɔn n ye to a kɔfɛ.» Nahomi ka a jabi: «Ale le wo ri n den. I ye wa.» ");
INSERT INTO msc_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ruti wulira wo rɔ ka wa sɛnɛ rɔ. A seni ye, a ka sɛnɛgban matɔmɔn damira baaraden do kɔfɛ, mɛnilu ye suman kala. A tɛrɛ ye sɛnɛ mɛn dɔ, Bɔwasi ta le wo ri, mɛn ni Ɛlimɛlɛki ye buruju kelen mɔɔ ri. ");
INSERT INTO msc_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","A ma mɛn bakɛ, Bɔwasi nara ka bɔ Bɛtilɛhɛmu. A ka baaradenilu fo ko: «Allabatala ye to ai fɛ!» Baaradenilu ka a lamira ko: «Allabatala ye ɲumaya kɛ i yɛ!» ");
INSERT INTO msc_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bɔwasi ka a la baaraden kuntii maɲininka ko: «Denmuso wo don? Yon ye a ri?» ");
INSERT INTO msc_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Baaraden kuntii ka a fɔ ko: «Mowabuka denmuso le, mɛn ni Nahomi nani ka bɔ Mowabu la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","A ka n madiya ko: ‹I ye n to n ye sɛnɛgban do matɔmɔn sumankalailu kɔfɛ.› A nara sɔɔma le, a ye baarala, haan sisen a ma a ɲɔɲɔ.» ");
INSERT INTO msc_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Wo rɔ, Bɔwasi ka a fɔ Ruti yɛ ko: «N denmuso, i tolo malɔ: I kana wa sɛnɛgban matɔmɔn diya sɛnɛ gbɛrɛ rɔ de. I ye to yan. I ye baara n na baaraden musomanilu kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","I ye a ragbɛ cɛɛilu ye suman kala dinkira mɛn dɔ. I ye i bila baaraden musomanilu kɔfɛ. N da a fɔ n na baaradenilu yɛ ko ii kana i ɲagba. Ji lɔɔ wa i mira, i ye wa i min jundaa kɔndɔ, n na baaraden mɛsɛnilu ka mɛn nafa.» ");
INSERT INTO msc_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ruti ka a ɲakɔrɔ bɛn duu ma ka a fɔ Bɔwasi yɛ ko: «Nfenna i ra hina n na ka n mira koɲuma fewu? N tɛ foyi ri fo londan.» ");
INSERT INTO msc_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bɔwasi ka a jabi: «I ka mɛn kɛ i biranmuso yɛ, i cɛɛ sani kɔ, wo bɛɛ fɔra n ɲana. I ka i fa ni i na to ye ka i sɔrɔn jamana to ye, ka na i sii mɔɔ gbɛrɛ tɛma yan, i tun ma mɛnilu lɔn kɔrɔman na. ");
INSERT INTO msc_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","I ka mɛn kɛ, Allabatala a ye i sara wo bɛɛ la. I ra na ka i jɛrɛ bila Isirayɛlika Maari Allabatala lakandalila kɔrɔ. A ye i sara a ɲa jɛrɛjɛrɛ ma.» ");
INSERT INTO msc_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ruti ka Bɔwasi jabi: «N fa, i ra koɲuma kɛ n yɛ. I ka kuma ɲuma fɔ n yɛ ka a tɛrɛn n ma se i la baaraden musoman kelen dɔ. Wo ra n sɛɛbɛ don.» ");
INSERT INTO msc_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Damunin waati seni, Bɔwasi ka a fɔ Ruti yɛ ko: «Na dɔɔnnin kɛ. Buru do ta. I ye a sun manfen dɔ.» Ruti nara a sii baaradenilu dafɛ tuma mɛn na, Bɔwasi ka sumankisɛ majaninni do di a ma. Ruti ka woilu dɔɔn ka a fa ka a tɔ to. ");
INSERT INTO msc_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","A banni dɔɔnninna, a ka a wuli ka wa sɛnɛgban matɔmɔn diya ikɔ. A wani ikɔ, Bɔwasi ka a fɔ a la baaraden cɛmanilu yɛ ko: «Ai ye a to a ye sɛnɛgban matɔmɔn sumansidi tɛma. Ai kana a makuma de. ");
INSERT INTO msc_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ka a la wo kan, ai wa suman ka, ai ye do bɔ ai bolo rɔ ka woilu labe duu ma, sa a ri ii matɔmɔn. Ai kana jalakili si la a kan.» ");
INSERT INTO msc_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ruti ka sɛnɛgban matɔmɔn ye haan wura fɛ, ka ban ka suman gbasi, a tun ka mɛn matɔmɔn. A ka horija suman kisɛ mɛn sɔrɔn, wo ka bɔrɔ tala kelen nafa. ");
INSERT INTO msc_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","A wara suman bɔrɔ tala wo ri so kɔndɔ. A biranmuso Nahomi ka a yen a ka suman kisɛ jate matɔmɔn. Ruti ka a la dɔɔnninfen tɔ fanan nabɔ ka a di a ma. ");
INSERT INTO msc_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nahomi ka a maɲininka ko: «I ka sɛnɛgban matɔmɔn kɛ mi bi? I ka baara kɛ sɛnɛ ɲuman de rɔ? Alla ye ɲumaya kɛ wo tii yɛ, mɛn ɲara i la.» Ruti ka dantɛɛli bɛɛ kɛ ko: «N ka baara kɛ sɛnɛ mɛn dɔ bi, wo tii tɔɔ ko Bɔwasi.» ");
INSERT INTO msc_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nahomi ka a fɔ ko: «Allabatala ye ɲumaya kɛ Bɔwasi yɛ, mɛn ma a la kaninteya yiraka boloka an niimailu la, a ni sayabatɔilu la. An sɔrɔn ɲɔɔn sudun mɛnilu ka kan ka an kunka, Bɔwasi ye woilu do le ri.» ");
INSERT INTO msc_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Mowabuka Ruti ka a fɔ ko: «A ka a fɔ n yɛ fanan ko n ye to sɛnɛgban matɔmɔnna a la baaradenilu kɔfɛ haan ii wa ban a la suman bɛɛ kala.» ");
INSERT INTO msc_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nahomi ka a jabi: «Wo ka ɲi, n den. I ye to baarala Bɔwasi la baaraden musomanilu kɔfɛ sa mɔɔ gbɛrɛilu kana kojuu kɛ i la.» ");
INSERT INTO msc_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ruti tora wo rɔ sɛnɛgban matɔmɔnna Bɔwasi la baaraden musomanilu kɔfɛ haan bile ni horija suman ka bɛɛ banda. A siini tɛrɛ a biranmuso Nahomi wara tuma bɛɛ. ");
INSERT INTO msc_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Lon do rɔ, Nahomi ka a fɔ Ruti yɛ ko: «N den, n ka kan ka ɲaɲinin i la ko ma, sa i ri hɛrɛ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","I tɛrɛ ye sɛnɛgban matɔmɔnna Bɔwasi la baaraden musomanilu kɔfɛ. I ka a lɔn Bɔwasi ye an badenma le ri. I ɲa lɔ. Wura ɲin na, i ri a tɛrɛn a ye horija suman rafɛla suman magbasi gbere ma. ");
INSERT INTO msc_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","I ye i ko ka sumadiyalan sisa i ma ka i la durukijan ɲuma bila i kan na. I ye wa ye, kɔni i kana i jɛrɛ yiraka a la fɔɔ a wa ban dɔɔnninna ka a min. ");
INSERT INTO msc_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","A wa taa a la tuma mɛn na, i ye a ragbɛ a ɲuma la sa i ri a lɔn a lani dinkira mɛn. A wa sunɔɔ, i ye i madon a la ka a la birinkan bɔ a sen ma ka i la a sen kɔrɔ. Wo rɔ i ka kan ka mɛn kɛ, a ri wo fɔ i yɛ.» ");
INSERT INTO msc_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ruti ka a fɔ ko: «I ka mɛn fɔ n yɛ, n di a bɛɛ kɛ.» ");
INSERT INTO msc_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ruti wara Bɔwasi la suman magbasi gbere ma. A biranmuso tun ka mɛn fɔ a yɛ, a ka wo bɛɛ latelen. ");
INSERT INTO msc_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bɔwasi banda dɔɔnninna ka a min, a nii lasɛwani tɛrɛ ye a ma. A taara a la suman ton dafɛ. Ruti ka a madon a la koɲuma, ka birinkan bɔ Bɔwasi sen ma, ka a la a sen kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Duu talama, Bɔwasi barara i wulila. A ka a yɛlɛman ka muso do lani yen a sen kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bɔwasi ka a fɔ ko: «Yon ye?» Ruti ka a jabi: «Ruti le, i la jɔnmuso kɔnin. I ye n furu, baa i ye an sɔrɔn ɲɔɔn sudun de ri, mɛn ka kan ka n furu.» ");
INSERT INTO msc_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bɔwasi ka a jabi: «Allabatala ye baraka don i rɔ! I ma taa kanberenilu kɔ furu ko rɔ, kanberen fentii wala kanberen bolokolon. I banni mɛn kɛla ɲin di, wo ye kaninteya misaliya le ri i ni i biranmuso tɛma, wo ka bon ka tamin fɔlɔman kan. ");
INSERT INTO msc_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Sisen, n den, i kana silan. I ye mɛn fɛ, n di wo bɛɛ kɛ i yɛ, ka a masɔrɔn so kɔndɔ mɔɔilu bɛɛ ka a lɔn ko muso telenni le ye ile ri. ");
INSERT INTO msc_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tuɲa le wo ri, n ye i kunkala le ri, mɛn ka kan ka i furu, kɔni i kunkala gbɛrɛ ye ye, mɛn fanan ye i sɔrɔn ɲɔɔn sudun i yɛ ka tamin nde la. ");
INSERT INTO msc_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","I ye to yan su ɲin dɔ. Sini sɔɔma, n di a mafɛnɛ ni cɛɛ wo ri i furu ikomin a ka kan ka a kɛ ɲa mɛn ma. Ni a ye a fɛ ka a kɛ, wo ri bɛn. A ye a kɛ, kɔni n ye n kalila Allabatala ɲenema tɔɔ la ko ni cɛɛ wo tɛ a fɛ ka a janto i rɔ, nde le ri a kɛ. I la yan haan sɔɔma.» ");
INSERT INTO msc_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Wo rɔ, Ruti lani tora Bɔwasi sen kɔrɔ, kɔni a wulira suba dibi rɔ, sa mɔɔ kana a yen, baa Bɔwasi tɛ a fɛ mɔɔ ye a lɔn ko Ruti nara suman magbasi gbere ma ye. ");
INSERT INTO msc_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bɔwasi ka a fɔ a yɛ ko: «I la taafɛ kɔkansidi wo fulɛn, i ye a mira koɲuma.» A ka wo mira koɲuma. Bɔwasi ka horija suman kisɛ bɔrɔ kelen ɲɔɔn suman ka wo kɛ Ruti la taafɛ rɔ. Wo kɔ rɔ, Bɔwasi ka a kɔsɛ so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruti seni a biranmuso wara, wo ka a maɲininka ko: «A ye di, n den? A diyara wa?» Bɔwasi ka mɛn bɛɛ kɛ a yɛ, Ruti ka wo bɛɛ dantɛɛli kɛ. ");
INSERT INTO msc_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ka a la wo kan, Ruti ka a fɔ ko: «A ka bɔrɔ kelen ɲɔɔn di n ma ko n kana n kɔsɛ n biranmuso wara ni n ma a sanba.» ");
INSERT INTO msc_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nahomi ka a fɔ ko: «N den, i sabari. I ye makɔnɔni kɛ yan fɔɔ i wa a yen ko ɲin nabantɔ ɲa mɛn ma, baa cɛɛ wo jusu ti nala lala, ni a ma ko ɲin ɲabɔ bi.» ");
INSERT INTO msc_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Nba, Bɔwasi wara ka i sii so donda la, makoilu ye ɲabɔla dinkira mɛn dɔ. A ma mɛn, a ka Ɛlimɛlɛki sɔrɔn ɲɔɔn sudun yen, a tun ka mɛn na ko fɔ Ruti yɛ. Cɛɛ wo tamintɔla le tɛrɛ. Bɔwasi ka a kili ko: «N fa! Na, i sii yan.» Wo rɔ, cɛɛ nara ka i sii. ");
INSERT INTO msc_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bɔwasi ka so mɔɔbakɔrɔ tan fanan kili ko ii ye na i sii. Woilu nara i sii. ");
INSERT INTO msc_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Bɔwasi ka a fɔ Ɛlimɛlɛki sɔrɔn ɲɔɔn sudun yɛ ko: «Nahomi a ra na ka bɔ Mowabu la jamana rɔ. A ye an badenmacɛ Ɛlimɛlɛki la sɛnɛ mayira bolo le ma. ");
INSERT INTO msc_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Wo le rɔ, a ye n kɔndɔ ko n ka kan ka wo la i tolo ma, ka i lali ko i ye sɛnɛ wo san mɔɔilu ɲana, n na mɔɔbakɔrɔilu ni mɔɔ tɔ mɛnilu siini yan. Awa, ni i ye a fɛ ka a kunka, i ye a kunka. Ni i tɛ a fɛ fanan, i ye a fɔ n yɛ, baa sɛnɛ kunka saratii ye i fɔlɔ le bolo, ka nde tuun ile la.» Cɛɛ ka a fɔ ko: «N di a kunka.» ");
INSERT INTO msc_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bɔwasi ka a fɔ ko: «Ni i ka sɛnɛ wo kunka Nahomi ma lon mɛn na, fo i ye Mowabuka Ruti furu wo lon, mɛn ye Ɛlimɛlɛki dencɛ la furuɲa muso ri. I ye Ruti furu, sa sayabatɔ a ri kɔ sɔrɔn, ka sɛnɛtiiya to a la denbaya kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Cɛɛ ka a fɔ ko: «Ni wo le, n ti se sɛnɛ kunkala baa n kana n jɛrɛ bolokolonya. Sɛnɛ kunka saratii a ye i bolo sisen, i ye a kunka. Nde ti se a kunkala.» ");
INSERT INTO msc_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Nba, waati taminni kɔ, ni badenma sudun ka sayabatɔ la duu kunka Isirayɛlika wara, wala ka duu kunka saratii latamin mɔɔ gbɛrɛ ma, fo mɔɔ kelen ye a la sanbara bɔ a sen dɔ ka a madon a tɔ mɔɔ kelen bolo. Wo ri kɛ tɔɔmasere ri, ka ko wo lasereya. ");
INSERT INTO msc_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Wo le ko kosɔn cɛɛ wo ka a fɔ Bɔwasi yɛ tuma mɛn na ko: «I ye wo sɛnɛ kunka.» A ka a la sanbara bɔ ka a di a ma. ");
INSERT INTO msc_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Wo kɔ rɔ, Bɔwasi ka a fɔ mɔɔbakɔrɔilu ni mɔɔ tɔ bɛɛ yɛ ko: «Ai ye sereilu le ri bi ko n da Ɛlimɛlɛki ni Kiliyon ni Malon bolofen bɛɛ kunka Nahomi ma. ");
INSERT INTO msc_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","N ye Ruti fanan tala a ra a kɛ n muso ri. A ye Mowabuka muso le ri, mɛn tɛrɛ ye Malon kun. N ye Ruti furula sa kɔ ri bɔ sayabatɔ kɔ rɔ, ka sɛnɛtiiya to a la denbaya kɔndɔ. N ye a furula sa Malon tɔɔ kana tunun a badenmailu tɛma, a ni a fa so kɔndɔ. Ai ye wo sereilu ri bi.» ");
INSERT INTO msc_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Wo rɔ, mɔɔbakɔrɔilu ni mɔɔ tɔ mɛnilu bɛɛ tɛrɛ ye so donda la ye, woilu ka a fɔ ko: «An ye wo sereilu le ri! Allabatala ye ɲumaya kɛ muso wo yɛ, mɛn dontɔ i wara! A ye a kɛ ikomin Rasɛli ni Leya, Yakuba la muso fila mɛnilu ka an benbailu sɔrɔn. Allabatala ye i sabati Efirata la bonkɔndɔla kɔndɔ, ka i tɔɔ bɔ Bɛtilɛhɛmu, Alla ma wo kɛra. ");
INSERT INTO msc_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Allabatala ye den siyaman di i ma sunkurun ɲin fɛ. Ka i la denbaya kɛ ikomin Yahuda ni Tamari dencɛ Pɛrɛsi ta, Alla ma wo kɛra!» ");
INSERT INTO msc_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Wo rɔ, Bɔwasi ka Ruti furu sidi. Ii dɛnda. Allabatala ka baraka don Ruti rɔ. A ka kɔnɔ ta ka dencɛ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Wo le kosɔn, Bɛtilɛhɛmu musoilu ka a fɔ Nahomi yɛ ko: «Tandoli ye Allabatala yɛ mɛn ma sɔn bi ka i bila ni kunkala sa i la. Ka wo tɔɔ bɔ Isirayɛlika tɛma, Alla ma wo kɛra. ");
INSERT INTO msc_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","A ri i nii lasɛwa ikɔ tuun, ka a lɔ i kɔrɔ i la kɔrɔya waati, baa i biranmusoni mɛn tɔnɔ ka bon i ma dencɛ wɔrɔnwula tɔnɔ ri, i duman mɛn yɛ kɔnin, wo le ka den ɲin sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Wo rɔ, Nahomi ka den ta ka a la a sen kan. Ale le ka den namɔ. ");
INSERT INTO msc_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","A siiɲɔɔ musoilu ka a fɔ ko: «Nahomi ra dencɛ sɔrɔn.» Ii ka den tɔɔ la ko Obedi. Obedi le kɛra Jɛsɛ fa ri. Jɛsɛ wo le ka Dawuda sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Pɛrɛsi bɔnsɔn de ɲin di. Pɛrɛsi ka Hɛsirɔn sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hɛsirɔn ka Ramu sɔrɔn. Ramu ka Aminadabu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabu ka Nasɔn sɔrɔn. Nasɔn ka Salimɔn sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salimɔn ka Bɔwasi sɔrɔn. Bɔwasi ka Obedi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedi ka Jɛsɛ sɔrɔn. Jɛsɛ ka Dawuda sɔrɔn.");
INSERT INTO msc_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Nba, lon do rɔ, Allabatala kumara Amitayi dencɛ Nabi Junusa yɛ. ");
INSERT INTO msc_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","A ka a fɔ ko: «I wuli! I ye sila mira i kɔrɔ. I ye wa Ninibe so ba kɔndɔ ka ye mɔɔilu jalakikan fɔ ii yɛ, baa ii ye kojuu mɛnilu kɛla, nde ka woilu lɔn.» ");
INSERT INTO msc_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Kɔni Nabi Junusa ma sɔn ka wa Ninibe. A ka Tarasisi sila mira ka wa ko a ye a mataala Allabatala la ka bɔ a ɲakɔrɔ. A sera Jafa so kɔndɔ ka wa kɔɔji dala ye. A ka kulunba do tɛrɛn ye, mɛn watɔ Tarasisi. A ka kulunba tɛɛ sara bɔ, ka don kulunba kɔndɔ. A ni kulunkɔndɔ mɔɔilu wara kɔɔji ka a fɔ ko ii ye wala Tarasisi. Nabi Junusa ye a fɛ ka a mataa Allabatala la ka bɔ a ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Kɔni Allabatala ka fɔɲɔ ba lana kɔɔji kan. Fɔɲɔ bonyara fɔɔ kulunba tɛrɛ ye tiɲan ko rɔ. ");
INSERT INTO msc_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Kulunkɔndɔ baaradenilu silanda kojuuya. Ii kelen kelenna bɛɛ ka a maari madiya ko wo ye ii kisi. Ii ka kulunkɔndɔ doninilu lafili kɔɔji rɔ sa kulunba ri fɛya kɔɔji kan. Wo ka a tɛrɛn Nabi Junusa ra jii kulunba kɔndɔ. A tɛrɛ ye sunɔɔla bakɛ. ");
INSERT INTO msc_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Kulun naborila wara a tɛrɛn ye ka a kan nabɔ a ma ko: «Nfenna i lani sunɔɔ rɔ? I wuli! I ye i maari madiya! Tumado wo ri kininkinin an na ko la ka an kisi sa an kana faa.» ");
INSERT INTO msc_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Kɔ fɛ, ii ka a fɔ i ɲɔɔn yɛ ko: «An ye a kalabe kɛ ka a lɔn mɛn ka kojuu ɲin nase an ma.» Ii ka a kalabe kɛ. Kala ka Nabi Junusa mira. ");
INSERT INTO msc_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ii ka Nabi Junusa maɲininka ko: «Yon ye kojuu ɲin nasela an ma? Ile don, i la baara ye nfen di? I bɔni mi? I ye jamana ɲuman de mɔɔ ri? Siya ɲuman ye i ri?» ");
INSERT INTO msc_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Nabi Junusa ka ii jabi: «Heburu le nde ri. N ye Maari Allabatala le batola, sankolo Maari, mɛn ka kɔɔji ni duukolo dan.» ");
INSERT INTO msc_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Ii silanda kojuuya kuma wo la, ka a maɲininka wo rɔ ko: «I ka ko suu ɲuman de kɛ?» Baa Nabi Junusa tun ka a fɔ ii yɛ kɔrɔman ko a boritɔla le ka bɔ Allabatala ɲakɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Nba, kɔɔji tora lamaala fɔɔ ka tamin fɔlɔma kan. Wo rɔ, ii ka a fɔ Nabi Junusa yɛ ko: «An ye nfen kɛ i la sa kɔɔji ri a masuma an naminin dɔ?» ");
INSERT INTO msc_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Nabi Junusa ka a fɔ ko: «Ai ye n mira ka n nafili kɔɔji rɔ. Wo wa kɛ, kɔɔji ri a masuma ai laminin dɔ, baa n ka a lɔn ko fɔɲɔ ba ɲin wulini ai kanma nde le la ko rɔ.» ");
INSERT INTO msc_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Wo bɛɛ ni a ta, kulunkɔndɔ baaradenilu ka kulun bori kɛ ii fanka bɛɛ la, sa ii ri gbere masɔrɔn. Kɔni ii ma se, baa kɔɔji tora lamaala fɔɔ ka tamin fɔlɔma kan. ");
INSERT INTO msc_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ii ka Allabatala matara wo rɔ ko: «Ɛɛ, Allabatala. I jaandi! Ni an ka cɛɛ ɲin nafili kɔɔji rɔ ka a faa, i kana an datiɲan. Ni an ka a faa ka a tɛrɛn a ye mɔɔ jalakibali le ri, i kana an jalaki a faa rɔ, baa, Allabatala, ko mɛn wa diya i yɛ, i ye wo le kɛla.» ");
INSERT INTO msc_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Wo rɔ, ii ka Nabi Junusa mira ka a lafili kɔɔji rɔ. Kɔɔji masumara i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Kulunkɔndɔ baaradenilu ka wo yen tuma mɛn na, ii silanda Allabatala yɛ kosɛbɛ. Ii ka saraka bɔ ka Allabatala sɔ wo la, ka dakan ta a yɛ. ");
INSERT INTO msc_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Awa, Allabatala ka jɛɛ ba do lana mɛn ka Nabi Junusa lakunun. Nabi Junusa ka tele sawa ni su sawa kɛ jɛɛ kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ka a to jɛɛ kɔndɔ, Nabi Junusa ka a Maari Allabatala tara. ");
INSERT INTO msc_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","A ka a fɔ ko: «Allabatala, ka n to tɔrɔya ba rɔ, n ka i matara. I ka n jabi. Ka n to lakira rɔ saya rɔ, n kulera dɛmɛnni ko rɔ. I ka n namɛn. ");
INSERT INTO msc_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","I ka n nafili kɔɔji rɔ, fɔɔ kɔɔji dun ba kɔrɔ. Kɔɔji ka n naminin fan bɛɛ rɔ. I ka kɔɔji kuru ba mɛnilu lana, woilu bɛɛ lara n kan. ");
INSERT INTO msc_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","N tɛrɛ ye a fɔla n jɛrɛ ma ko i ra n gbɛn ka n bɔ i ɲakɔrɔ. Kɔni n lani a la n di i la bon sɛniman yen ikɔ tuun. ");
INSERT INTO msc_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Kɔɔji ka n natunun ka n na ɲenemaya masilan. N jiira fɔɔ kɔɔji dun ba kɔrɔ. Kɔɔjikɔrɔ binilu mɔrɔnmɔrɔnni tɛrɛ n kun ma. ");
INSERT INTO msc_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","N jiira fɔɔ koyinkɛilu sen kɔrɔ kɔɔji kɔrɔ. N sera suilu la jamana rɔ. A da bɛɛ sɔɔra n ma kadawu. Kɔni ile, n Maari Allabatala, i ka n kɛndɛ layɛlɛ lakira kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","N Maari Allabatala, ka a to dɔɔni n tun di sa, n miriya sera i ma. I ka n na matarali kan namɛn i la bon sɛniman kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Mɔɔ mɛnilu ye batofen ɲatɔnɔntanilu batola, woilu ri bɔnɔ i la kaninteya rɔ. ");
INSERT INTO msc_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Kɔni nde ri kalaman bɔ i yɛ ka i tando, ka saraka di i ma. N ka dakan mɛn ta i yɛ, n di wo mafa. Allabatala, ile kelen pe le ri se mɔɔ kisila.» ");
INSERT INTO msc_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Awa, Allabatala kumara jɛɛ ba yɛ. Wo rɔ, jɛɛ ba ka Nabi Junusa labɔ gbere ma. ");
INSERT INTO msc_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Allabatala kumara Nabi Junusa yɛ a siɲa filana rɔ. ");
INSERT INTO msc_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","A ka a fɔ ko: «I ye i wuli ka wa Ninibe so ba kɔndɔ. N wa mɛn fɔ i yɛ, i ye wo lase Ninibekailu ma.» ");
INSERT INTO msc_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Wo rɔ, Nabi Junusa wulira ka wa Ninibe, ikomin Allabatala ka a fɔ a yɛ ɲa mɛn ma. Ninibe tɛrɛ ye so ba le ri, mɔɔ ri tele sawa taama kɛ mɛn kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Nabi Junusa seni Ninibe, a donda so kɔndɔ ka tele kelen kɛ taamala, ka ban ka ye mɔɔilu kawandi ko: «Yani tele binaanin, gbalo ba ri kɛ Ninibe.» ");
INSERT INTO msc_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Alla ka mɛn fɔ Ninibekailu yɛ ka fara Nabi Junusa la, ii lara wo la. Ii ka a fɔ ko bɛɛ ye sun don ka landa faanin bila ii kan na, denilu ni mɔɔbailu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Nba, wo kibaro sera Ninibe mansa ma tuma mɛn na, a ka i wuli a la mansaya siifen dɔ ka a la mansaya faanin bɔ a kan na. A ka landa faanin bila a kan na ka i sii buurigbɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Wo kɔ, a ka mɔɔilu lɔ kelalasela Ninibekailu ma ko: «Mansacɛ ni a la ɲɛmɔɔilu ka a fɔ ko tɔn da sii mɔɔilu ni kolofenilu bɛɛ ma, nisiilu ni saailu ni bailu kɔnin. Ii si kana dɔɔnnin kɛ. Ii si kana ii min. ");
INSERT INTO msc_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Mɔɔilu bɛɛ ye landa faanin bila ii kan na, ka do sidi kolofenilu bɛɛ kan na. Mɔɔ kelen kelenna bɛɛ ye Alla matara a fanka bɛɛ la. Bɛɛ ye a ban a sɔn juu rɔ, ka kojuu kɛ boloka. ");
INSERT INTO msc_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Baa, yon ka a lɔn? Tumado ko Alla ri a la bolorabɛn yɛlɛman an kanma ka a ban a la mɔnɛ ba rɔ, kosa an kana faa.» ");
INSERT INTO msc_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Alla ka a yen mɛn kɛ ko Ninibekailu ra nimisa ka ii la kojuuilu boloka, a ka a miriya yɛlɛman. A ka masilannikan mɛn fɔ ii yɛ ko a kɛtɔ gbalo ba lala ii kan, a ka wo to ye. ");
INSERT INTO msc_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Wo ma diya Nabi Junusa yɛ fewu. A mɔnɛra kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","A ka Allabatala matara ko: «Aa, Allabatala, ka n to n na jamana kɔndɔ fɔlɔ, a miriya tɛrɛ ye n na ko i ri a kɛ ten. Wo le ka a kɛ, n ka n kaliya ka n bori ka wa Tarasisi. Baa n tun ka a lɔn fewu ko i ye Alla le ri, mɛn na kininkinin ni ɲumaya ka bon kosɛbɛ. I ti mɔnɛla jona. I ye mɔɔilu kaninna kojuuya. I wa masilannikan mɛnilu fɔ, i rabɛnni tuma bɛɛ ka woilu to ye. ");
INSERT INTO msc_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Allabatala, sisen, i ye n bɔ duunuɲa rɔ yan, baa saya fisa n yɛ ka tamin ɲenemaya la.» ");
INSERT INTO msc_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Allabatala ka Nabi Junusa jabi: «A ye di? I jɔ ye mɔnɛ rɔ wa?» ");
INSERT INTO msc_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Nba, Nabi Junusa bɔra Ninibe so kɔndɔ, ka wa i sii telebɔ rɔ. A ka gbaa do lɔ ye, ka i sii wo kɔrɔ lulen na ka makɔnɔni kɛ, baa a ye a fɛ ka a yen ko mɛn tamintɔ so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Wo tuma, Maari Allabatala ka fɛɛjuu do lafɛrɛn ka yɛlɛ Nabi Junusa kun na ka lulen di a ma, ka a bɔ a la niilafin dɔ. Nabi Junusa sɛwara fɛɛjuu wo la kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Wo duusa gbɛ sɔɔma da la, Alla ka tunbu do lana. Tunbu wo donda fɛɛjuu rɔ ka a dɔɔn ka a ja. ");
INSERT INTO msc_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Tele yɛlɛra tuma mɛn na, Alla ka fɔɲɔ ba kalaman nana ka bɔ telebɔ rɔ. Tele gbara Nabi Junusa kun na kojuuya fo a betɔ le tɛrɛ. A tɛrɛ ye a fɛ ka sa. A ka a fɔ ko: «Saya kɔni ka fisa n ma ka tamin ɲenemaya kan.» ");
INSERT INTO msc_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Alla ka Nabi Junusa maɲininka ko: «A ye di? I jɔ ye mɔnɛ rɔ fɛɛjuu ja ko rɔ wa?» Nabi Junusa ka a fɔ ko: «N kɛ! N jɔ ye a rɔ! N da mɔnɛ haan ka n sɔn saya ma.» ");
INSERT INTO msc_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Allabatala ka a fɔ ko: «Fɛɛjuu ni wo hina ye i la. I don ma baara si kɛ a la, mɛn di a labonya. A fɛrɛnda su fɔlɔ rɔ ka ja su filana rɔ. ");
INSERT INTO msc_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","I ye a fɛ nde kana kininkinin Ninibekailu ma, so belebele wo kɔndɔ mɔɔ waa kɛmɛ a ni waa muwan mɛnilu mɛn ti se bolokinin ni bolomaran faranfasila, kolofen siyaman ba wo ma jate ma lɔn.»");
INSERT INTO msc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Isa Ɲenematɔmɔnin buruju le ɲin di. Isa tɛrɛ Dawuda ni Iburahima bɔnsɔn de ri. ");
INSERT INTO msc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iburahima ka Isiyaka sɔrɔn. Isiyaka ka Yakuba sɔrɔn. Yakuba ka Yahuda sɔrɔn, a ni wo kɔrɔcɛilu ni dɔɔcɛilu. ");
INSERT INTO msc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ka Pɛrɛsi ni Seraki sɔrɔn. Woilu na tɔɔ le tɛrɛ ko Tamari. Perɛsi ka Hɛsirɔn sɔrɔn. Hɛsirɔn ka Ramu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu ka Aminadabu sɔrɔn. Aminadabu ka Nasɔn sɔrɔn. Nasɔn ka Salimɔn sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimɔn ka Bɔwasi sɔrɔn. Wo na tɔɔ ko Rahabu. Bɔwasi ka Obedi sɔrɔn. Wo na le tɛrɛ Rutu ri. Obedi ka Jɛsɛ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛsɛ ka mansa Dawuda sɔrɔn. Dawuda ka Sulemani sɔrɔn. Wo na tɛrɛ Uriya muso le ri. ");
INSERT INTO msc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemani ka Rehobowan sɔrɔn. Rehobowan ka Abiya sɔrɔn. Abiya ka Asafu sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafu ka Jusafati sɔrɔn. Jusafati ka Jehoramu sɔrɔn. Jehoramu ka Usiyasi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiyasi ka Jotamu sɔrɔn. Jotamu ka Ahasi sɔrɔn. Ahasi ka Esekiyasi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyasi ka Manase sɔrɔn. Manase ka Amɔn sɔrɔn. Amɔn ka Josiya sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya ka Jekoniya ni dencɛ gbɛrɛilu sɔrɔn. Awa, Jekoniya tele rɔ, Babilɔnikailu ka Isirayɛlikailu mira ka wa ii ri kɛlɛkɔrɔbori rɔ Babilɔni jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isirayɛlikailu seni kɔ kɛlɛkɔrɔbori diya Babilɔni jamana rɔ, Jekoniya ka Seyalatiyɛli sɔrɔn. Seyalatiyɛli ka Serobabɛli sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serobabɛli ka Abihudi sɔrɔn. Abihudi ka Eliyakimu sɔrɔn. Eliyakimu ka Asori sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asori ka Sadoki sɔrɔn. Sadoki ka Akimu sɔrɔn. Akimu ka Eliyudi sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudi ka Elasari sɔrɔn. Elasari ka Matan sɔrɔn. Matan ka Yakuba sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakuba ka Yusufu sɔrɔn. Yusufu ka Mariyamu furu. Mariyamu wo le ka Isa sɔrɔn, mɔɔilu ye a fɔla mɛn ma ko Ɲenematɔmɔnin. ");
INSERT INTO msc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nba, ka bɔ Iburahima ma ka na a sii Dawuda la, wo bɛɛ ladɛnnin kɛra farɔkɛ tan ni naanin de ri. Ka bɔ Dawuda ma ka na Isirayɛlikailu lawa waati rɔ kɛlɛkɔrɔbori rɔ Babilɔni jamana rɔ, wo bɛɛ ladɛnnin kɛra farɔkɛ tan ni naanin de ri. Ka bɔ ii wa waati ma kɛlɛkɔrɔbori diya Babilɔni jamana rɔ ka na a sii Ɲenematɔmɔnin na, wo bɛɛ ladɛnnin kɛra farɔkɛ tan ni naanin de ri. ");
INSERT INTO msc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nba, Isa Ɲenematɔmɔnin sɔrɔnda ɲa mɛn ma, wo le ɲin di. A na Mariyamu mamirani tɛrɛ Yusufu bolo. Kɔni sani a ye wa a sii Yusufu wara ka kɛ a muso ri, Nii Sɛniman ka a kɛ Mariyamu ka kɔnɔ ta. ");
INSERT INTO msc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu ka wo yen mɛn kɛ, a tun tɛ a fɛ ka Mariyamu tɔɔ tiɲan mɔɔilu ɲana, baa Yusufu tɛrɛ mɔɔ telenni le ri. Wo rɔ, a ka a latɛɛ ko a ri Mariyamu bila sutura bolo ma. ");
INSERT INTO msc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ka Yusufu to a mirila wo ma, Maari la mɛlɛka ka a jɛrɛ yiraka a la sibo rɔ, ka a fɔ a yɛ ko: «Yusufu, Dawuda bɔnsɔn, i kana silan Mariyamu furu ko yɛ, baa Nii Sɛniman de ka a kɛ a ra kɔnɔ ta. ");
INSERT INTO msc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A ri dencɛ sɔrɔn. I ye a tɔɔ la ko Isa, baa ale le kɛtɔ a la mɔɔilu kisila ii la kojuuilu ma.» ");
INSERT INTO msc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Awa, ko woilu bɛɛ kɛni sa Maari la kuma ri kanbali, a ka mɛn don a la nabi da rɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«I ɲa lɔ! Sunkurun mɛn da a jɛrɛ lakanda, wo ri kɔnɔ ta ka dencɛ sɔrɔn. Dencɛ wo tɔɔ ri la ko Emanuwɛli.» Emanuwɛli kɔrɔ le ko Alla ye an dafɛ. ");
INSERT INTO msc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu wulira sunɔɔ rɔ mɛn kɛ, a ka a kɛ ikomin Maari la mɛlɛka tun ka a fɔ a yɛ ɲa mɛn ma. A wara Mariyamu ta ka na a ri a wara, ka a kɛ a muso ri. ");
INSERT INTO msc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kɔni ii ma dɛn fɔɔ Mariyamu moyira dencɛ la. Yusufu ka den tɔɔ la ko Isa. ");
INSERT INTO msc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isa sɔrɔnda Bɛtilɛhɛmu so kɔndɔ, ni a ye Jude mara rɔ. Wo tuma, mansa Herodi siini mansaya la. Isa sɔrɔnni kɔ, lɔnninna doilu bɔra telebɔ rɔ ka na Jerusalɛmu. ");
INSERT INTO msc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ii ka a maɲininka ko: «Yahudiyailu la mansa mɛn sɔrɔnda sisen, wo ye mi? Ka an to an wara telebɔ rɔ, an ka a lolo yen. An da na a bonya diya.» ");
INSERT INTO msc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuma wo fɔra mansa Herodi yɛ tuma mɛn na, a kɔndafilira, a ni Jerusalɛmukailu bɛɛ. ");
INSERT INTO msc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mansa ka Isirayɛlikailu la sarakalaselailu bɛɛ ni sariya karanmɔɔilu bɛɛ ladɛn, ka ii maɲininka ko, «Ɲenematɔmɔnin ka kan ka sɔrɔn mi?» ");
INSERT INTO msc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ii ka a fɔ ko: «A ka kan ka sɔrɔn Bɛtilɛhɛmu le, ni a ye Jude mara rɔ, baa nabi do ka a sɛbɛ ko: ");
INSERT INTO msc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ile Bɛtilɛhɛmu, ile mɛn ye Jude mara rɔ, i tɛ Jude mara soilu rɔ dɔɔmanni ri de! Baa kuntii do ri bɔ i kɔndɔ, mɛn di a janto n na jama Isirayɛlikailu rɔ.›» ");
INSERT INTO msc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wo kɔ rɔ, Herodi ka lɔnninna woilu kili dokon dɔ ka ii maɲininka lolo bɔ waati ma. Ii tun ka a yen waati mɛn, ii ka wo fɔ a yɛ. ");
INSERT INTO msc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wo rɔ, a ka sila di ii ma ko ii ye wa Bɛtilɛhɛmu. A ka a fɔ ko: «Ai ye wa den yɔrɔ ɲinin koɲuma ye. Ai wa a yen, ai ye kela lawa n yɛ, sa n fanan di wa a bonya.» ");
INSERT INTO msc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herodi ka kuma wo fɔ ka ban tuma mɛn na, lɔnninnailu bɔra ye ka wa. Ka ii to sila kan, ii ka lolo kelen wo yen ii ɲɛfɛ, ii tun ka mɛn yen ii wara telebɔ rɔ. Den tɛrɛ ye yɔrɔ mɛn dɔ, lolo wo wara a lɔ yɔrɔ wo kun dɔ. ");
INSERT INTO msc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lɔnninnailu ka lolo yen tuma mɛn na, ii jusu sɛwara kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ii don mɛn kɛra bon na, ii ka den ni a na Mariyamu yen ye. Ii ka ii ɲɔnkin ka den bonya. Wo kɔ rɔ, ii ka ii la kankirailu da laka ka sɔlifen sankɔgbɛlɛnilu labɔ ka woilu di den ma. Ii ka sanin di a ma, a ni wusulan ni latikɔlɔn sumaduman mɛn tɔɔ ko muri. ");
INSERT INTO msc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wo kɔ rɔ, Alla ka a lasobi lɔnninnailu la sibo rɔ ko ii kana kɔsɛ Herodi wara butun. Wo rɔ, ii ka sila gbɛrɛ ta ka wa ii la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nba, lɔnninnailu wani kɔ, Maari la mɛlɛka do ka a jɛrɛ yiraka Yusufu la sibo rɔ, ka a fɔ a yɛ ko: «I wuli ka den ni a na ta ka i bori ka wa Misiran jamana rɔ. I ye to ye fɔɔ n wa a fɔ i yɛ lon mɛn ko i ye na, baa Herodi kɛtɔ den yɔrɔ ɲininna a faa ko rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wo rɔ, Yusufu wulira su rɔ, ka den ni a na ta ka wa Misiran. ");
INSERT INTO msc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A tora Misiran fɔɔ ka Herodi sa. Wo kɛra ka Maari la kuma kanbali, a tun ka mɛn don a la nabi da rɔ ko: «N ka n dencɛ kili ko a ye bɔ Misiran.» ");
INSERT INTO msc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nba, Herodi ka a ɲayen tuma mɛn na ko lɔnninnailu ra a majuwaya, a jusu bɔra kojuuya. A ka mɔɔilu lawa Bɛtilɛhɛmu so kɔndɔ, a ni a mara yɔrɔ bɛɛ rɔ. Ko den cɛman mɛnilu si ma tamin san fila kan fɔlɔ, ii ye woilu bɛɛ faa. Herodi danda san fila dencɛilu ma ka a bɛn lɔnninnailu la lolo yen waati ma, ii tun ka mɛn fɔ a yɛ. ");
INSERT INTO msc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wo rɔ, Nabi Jeremiya tun ka mɛn fɔ, wo kanbalira ko: ");
INSERT INTO msc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Kan do bɔra Rama so kɔndɔ, kasi mankan ba a ni jusumakasa mankan ba. Rasɛli ye kasila a denilu la ko la. A ma sɔn mɔɔ si ye a masabari, baa a denilu tɛ ye butun.» ");
INSERT INTO msc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi sani kɔrɔ, Maari la mɛlɛka do ka a jɛrɛ yiraka Yusufu la sibo rɔ Misiran. ");
INSERT INTO msc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Mɛlɛka ka a fɔ a yɛ ko: «I wuli ka den ni a na ta. Ai ye i kɔsɛ Isirayɛlikailu la jamana rɔ, baa mɔɔ mɛnilu tɛrɛ ye a ɲininna ka den faa, woilu ra sa.» ");
INSERT INTO msc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu wulira wo le rɔ, ka den ni a na ta ka wa Isirayɛlikailu la jamana rɔ. ");
INSERT INTO msc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kɔni Yusufu ka a mɛn ko Arikilayosi le siini mansaya la Jude mara kun na a fa Herodi nɔ rɔ. Wo rɔ, a silanda ka wa Jude mara rɔ. Alla ka a lasobi sibo rɔ ko a ye wa Kalile mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A wara a sii Nasarɛti so kɔndɔ. Wo kɛni sa Alla la kuma ri kanbali, a ka mɛn don a la nabiilu da rɔ ko mɔɔilu ri a fɔ Isa ma ko Nasarɛtika. ");
INSERT INTO msc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nba, wo waati la, Yuhana mɛn ye mɔɔ sunna ji rɔ, a sera Jude wula kɔndɔ. A tɛrɛ mɔɔilu kawandila ko: ");
INSERT INTO msc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ai ye tubi, baa Harijeene Mansaya waati ra se.» ");
INSERT INTO msc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Baa Nabi Esayi ka Yaya la ko fɔ ko: «Kilikan ba bɔra wula kɔndɔ ko: ‹Ai ye sila rabɛn Faama yɛ, ka silaninilu latelen a yɛ.›» ");
INSERT INTO msc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nba, duruki mɛn tɛrɛ ye Yaya kan na, wo tɛrɛ ye ɲɔɔmɛ si le ri. A tɛsidini tɛrɛ gbolojulu la. A la dɔɔnninfenilu tɛrɛ ye tonkasailu ni waa rɔ li le ri. ");
INSERT INTO msc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mɔɔ siyaman ba tɛrɛ ye bɔla Jerusalɛmu so kɔndɔ, a ni Jude mara rɔ, a ni Juridɛn Ba laminin yɔrɔilu bɛɛ rɔ, ka wa Yaya tɛrɛn ye. ");
INSERT INTO msc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A ri ii sun ji rɔ Juridɛn Ba rɔ, ii wa i lɔ ii la julumun na waati mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farisi siyaman ni Sadusi siyaman tɛrɛ ye nala Yaya ma sun ji rɔ kanma. A ka wo yen ka a fɔ ii yɛ ko: «Ai, fɔnfɔnni la munuɲailu! Alla la kiti mɛn natɔ, yon de ka ai lali ko ai ye ai bori wo kɔrɔ ten? ");
INSERT INTO msc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ai ye kɛwaliilu kɛ, mɛnilu ri a yiraka ko ai ra tubi. ");
INSERT INTO msc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ai kana ai miri ka a fɔ ko a ri bɛn ka a masɔrɔn Iburahima le ye ai benba ri! Ɛɛn. N di a fɔ ai yɛ ko Alla ri se kabakurun ɲinilu yɛlɛmanna ka ii kɛ Iburahima bɔnsɔnilu ri. ");
INSERT INTO msc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sisen, tɛɛran tii ra wuli jiri tɛɛ kanma. Jiri mɛnilu tɛ den ɲuma kɛla, woilu bɛɛ ri tɛɛ ka lafili ta rɔ. ");
INSERT INTO msc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nde ye ai sunna ji le rɔ, ka a yiraka ko ai ra tubi. Kɔni mɔɔ mɛn natɔ n kɔ, wo fanka ka bon n ta ri. Hali ka a la sanbara mira a yɛ, wo ka bon nde ma. Ale ri ai sun Nii Sɛniman dɔ, a ni ta. ");
INSERT INTO msc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A la baarafen ye a bolo, a ri sumankisɛ ni a bu bɔ ɲɔɔn dɔ baarafen mɛn na. A ri a la suman magbasi gbere lagbɛ, ka sumankisɛ kɛ bondon kɔndɔ, ka bu bɛɛ janin ta la. Ta wo ye ta sabali le ri.» ");
INSERT INTO msc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wo kɔ rɔ, Isa bɔra Kalile mara rɔ ka na Yaya tɛrɛn Juridɛn Ba dala sa Yaya ri a sun ji rɔ, ");
INSERT INTO msc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kɔni Yaya tɛrɛ ye a fɛ ka a ban. A ka a fɔ Isa yɛ ko: «Ile le ka kan ka nde sun ji rɔ. Nfenna i ra na n tɛrɛn ten?» ");
INSERT INTO msc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Isa ka a jabi: «I ye diɲɛ wo ma fɔlɔ, baa a bɛnni an ye wo kɛ sa an di Alla sawo bɛɛ kanbali.» Wo rɔ, Yaya sɔnda ka a sun ji rɔ. ");
INSERT INTO msc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Isa sunni ji rɔ kɔ, a bɔra ji rɔ i kɔrɔ. Sankolo da lakara. A ka Alla Nii Sɛniman jiitɔla yen a kan ikomin kanba. ");
INSERT INTO msc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kumakan do bɔra sankolo rɔ ko: «N diyana dencɛ le ten. N sɛwani ale rɔ kosɛbɛ.» ");
INSERT INTO msc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wo kɔ rɔ, Nii Sɛniman ka Isa ɲɛmira ka wa a ri wula kɔndɔ a kɔrɔbɔ kanma Ibulusa bolo. ");
INSERT INTO msc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Isa ka tele binaani ni su binaani kɛ, a ye sun donna. Wo banni kɔ, kɔnkɔ ka a mira. ");
INSERT INTO msc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Majuuwalila ka a madon a la, ka a fɔ a yɛ ko: «Ni ile le ye Alla Dencɛ ri, i ye a fɔ kabakurun woilu yɛ ko ii ye yɛlɛman ka kɛ buru ri.» ");
INSERT INTO msc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kɔni Isa ka a jabi: «A sɛbɛni Alla la kitabu kɔndɔ ko: ‹Mɔɔ tɛ se balola buru gbansan na. Ɛɛn, mɔɔ mako ye Alla la kumailu fanan na ka balo, kuma mɛnilu bɛɛ ye bɔla Alla da rɔ.›» ");
INSERT INTO msc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wo kɔ rɔ, Ibulusa ka Isa ta ka wa a ri Jerusalɛmu, ni a ye so sɛniman di. A ka a lalɔ Allabatobonba kun dɔ, ");
INSERT INTO msc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ka a fɔ a yɛ ko: «Ni ile le ye Alla Dencɛ ri, i ye i juran ka bɔ yan, baa a sɛbɛni ko: ‹Alla ri a la mɛlɛkailu jamari i la ko rɔ. Wo rɔ, ii ri i mira ii bolo la sa i sen kana se kabakurun ma.›» ");
INSERT INTO msc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isa ka Ibulusa jabi: «A sɛbɛni fanan ko: ‹I kana i la Maari Alla kɔrɔbɔ.›» ");
INSERT INTO msc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wo kɔ rɔ, Setana wara a ri koyinkɛ jan ba do kan, ka dunuɲa mansaya bɛɛ yiraka a la, a ni ii la gbiliya. ");
INSERT INTO msc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A ka a fɔ Isa yɛ ko: «Ni i sɔnda ka i ɲɔnkin n kɔrɔ ka n bato, n di woilu bɛɛ di i ma.» ");
INSERT INTO msc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Isa ka a fɔ a yɛ ko: «I ye bɔ n kɔ Setana, baa a sɛbɛni ko: ‹I ye i la Maari Alla le bato ka baara kɛ ale kelen pe yɛ.›» ");
INSERT INTO msc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wo rɔ, Ibulusa bɔra a fɛ ka wa. Mɛlɛkailu nara ka Isa makoilu ɲa. ");
INSERT INTO msc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Isa ka a mɛn tuma mɛn na ko Yaya ra mira ka a bila kaso la, a ka a kɔsɛ ka wa Kalile mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kɔni a ma a sii Nasarɛti so kɔndɔ. A wara Kapɛrinahumu so le kɔndɔ ka a sii ye. So wo ye Kalile dalaba dala, Sabulɔn mara ni Nafitali mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wo kɛra sa Alla la kuma ri kanbali, a ka mɛn don a la Nabi Esayi da rɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Sabulɔn mara ni Nafitali mara, mɛnilu ye Kalile dalaba fan fɛ Juridɛn Ba telebe rɔ, Kalile mara kɔnin, siya gbɛrɛ mɔɔ siini yɔrɔ mɛn. ");
INSERT INTO msc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mɔɔ mɛnilu siini tɛrɛ dibi rɔ ye, woilu ka kɛnɛ ba do yen. Mɛnilu siini tɛrɛ saya dibi rɔ, kɛnɛya bɔra woilu ma.» ");
INSERT INTO msc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Awa, kɛbi waati wo la, Isa ka kawandili damira ka a fɔ ko: «Ai ye tubi, baa Harijeene Mansaya ra se.» ");
INSERT INTO msc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lon do rɔ, Isa tɛrɛ ye taamana Kalile Dala dafɛ. A ka nakelenɲɔɔma fila yen. Woilu ye Simɔn di (a ye fɔla mɛn ma ko Piyɛri) a ni Andere. Woilu tɛrɛ ye jɔɔ filila ji rɔ, baa ii ye jɛɛmiralailu le ri. ");
INSERT INTO msc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Isa ka a fɔ ii yɛ ko: «Ai ye na ai bila n kɔ. Ai ye jɛɛ ɲininna, kɔni n di ai karan mɔɔilu ɲininna.» ");
INSERT INTO msc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ii ka ii la jɔɔilu to ye i kɔrɔ ka ii bila Isa kɔ. ");
INSERT INTO msc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Isa taminni yɔrɔ wo la dɔɔni, A ka badenma fila yen mɛn ye na ni fa la. Woilu tɛrɛ ye Sebede dencɛ Yakuba a ni Yuhana ri. Ii ni ii fa siini tɛrɛ ye ii la jɔɔilu rabɛnna kulun kɔndɔ. Isa ka Yakuba ni Yuhana kili. ");
INSERT INTO msc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ii ka ii bila Isa kɔ i kɔrɔ, ka ii fa ni kulun to ii kɔ. ");
INSERT INTO msc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isa tɛrɛ ye Kalile mara fan bɛɛ rataamala. A tɛrɛ ye mɔɔilu karanna ii la salibonilu la, ka Harijeene Mansaya kibaro ɲuma lase, ka mɔɔilu lakɛndɛya ka ii bɔ ii la jankarɔ rɔ a ni ka ii lakɛndɛya ka ii bɔ ii la fɛɛmaya bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Isa tɔɔ bɔra Siri jamana yɔrɔ bɛɛ rɔ. Mɔɔilu tɛrɛ ye nala jankarɔtoilu bɛɛ ri a ma. Jankarɔ su siyaman tɛrɛ ye woilu kan. Mɛnilu tɔrɔni kojuuya farikɔrɔ dimin na, ii nara woilu ri, a ni jinatɔilu ni kirikirimasatɔilu ni kɔrɔngbɔilu. A ka woilu bɛɛ lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɔɔ siyaman ba bilani tɛrɛ a kɔ. Ii bɔni tɛrɛ Kalile mara rɔ, a ni Dekapɔli mara ni Jerusalɛmu so ni Jude mara ni Juridɛn Ba kɔfɛla. ");
INSERT INTO msc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Isa ka jama yen tuma mɛn na, a yɛlɛra koyinkɛ kan ka a sii. A la karandenilu ka ii madon a la. ");
INSERT INTO msc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A ka ii karan damira ko: ");
INSERT INTO msc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mɔɔ mɛnilu ka a lɔn ko ii mako ye Alla la, woilu ye barakadenilu ri, baa Harijeene Mansaya ye ii ta le ri. ");
INSERT INTO msc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mɔɔ mɛnilu jusumakasani, woilu ye barakadenilu ri, baa Alla ri ii jususuma. ");
INSERT INTO msc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɔɔ mɛnilu sabarini, woilu ye barakadenilu ri, baa Alla ri duukolo di ii ma ka a kɛ ii ta ri. ");
INSERT INTO msc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mɔɔ mɛnilu ye a fɛ ka kɛ telenbailu ri, ni wo lɔɔ ye gbala ii la ikomin dɔɔnnin lɔɔ ni minnin lɔɔ ye gbala mɔɔilu la ɲa mɛn ma, woilu ye barakadenilu ri, baa ii ye mɛn ɲininna, Alla ri wo di ii ma. ");
INSERT INTO msc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mɔɔ mɛnilu ye hinala ii mɔɔɲɔɔilu la, woilu ye barakadenilu ri, baa Alla ri hina ii la fanan. ");
INSERT INTO msc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mɔɔ mɛnilu kɔndɔ gbɛni, woilu ye barakadenilu ri, baa ii ri Alla yen. ");
INSERT INTO msc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mɔɔ mɛnilu ye hɛrɛ donna ii ni ii mɔɔɲɔɔilu tɛma, woilu ye barakadenilu ri, baa Alla ri ii jate a denilu ri. ");
INSERT INTO msc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mɔɔ mɛnilu ye tɔrɔla mɔɔilu bolo ka a masɔrɔn ii ye Alla diyana koilu kɛla, woilu ye barakadenilu le ri, baa Harijeene Mansaya ye ii ta le ri. ");
INSERT INTO msc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mɔɔilu wa ai nani, ka ai tɔrɔ, ka wuya la ai la, ka kuma juu su bɛɛ fɔ ai ma nde kosɔn, ai ye barakadenilu ri. ");
INSERT INTO msc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ai ye sɛwa ka ɲaalen, ka a masɔrɔn ai ri barayiba sɔrɔn sankolo rɔ, baa nabi mɛnilu taminda ai ɲɛfɛ, ii ka woilu fanan tɔrɔ ten de. ");
INSERT INTO msc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Nba, aile ye kɔɔ ri duukolo kan yan. Kɔni ni kɔɔ timinya bɔra a la, a ri se timinyala ikɔ di? A tɛ foyi ɲala butun. A ri lafili kɛnɛ ma, mɔɔilu tamintɔ ri a radɔn. ");
INSERT INTO msc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Aile ye yelen di dunuɲa rɔ yan. So mɛn siini tindi kan, wo ti se doonna. ");
INSERT INTO msc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mɔɔ tɛ fitina lamɛlɛnna ka a bila see kɔrɔ. Ɛɛn, a ri a sii fitinnasiifen kan sa a ri yelen di bonkɔndɔ mɔɔilu bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Fɔɔ ai la yelen ye bɔ ten mɔɔilu ɲana, sa ii ri ai la koɲuma kɛnɛniilu yen ka ai Fa gbiliya, ai Fa mɛn ye sankolo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ai kana ai miri ko n nara le ka Musa la sariya wala nabiilu la kumailu bɔ ye. Ɛɛn, n ma na ka woilu bɔ ye, fɔɔ ka ii kanbali. ");
INSERT INTO msc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","N di tuɲa fɔ ai yɛ: haan ka wa se sankolo ni duukolo ban lon ma, foyi tɛna bɔla sariya rɔ hali sariyatonbe kelen wala a sɛbɛli den kelen fɔɔ sariya bɛɛ wa kanbali. ");
INSERT INTO msc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wo rɔ, mɔɔ mɛn wa jamarili ɲinilu do tiɲan, hali jamarili mɛn ma bon a tɔilu bɛɛ ri, ka mɔɔilu fanan karan jamarili wo tiɲanna, wo tii ri jate bɛɛ rɔ dɔɔmanni ri Harijeene Mansaya rɔ. Kɔni mɔɔ mɛn wa jamarili ɲinilu labato, ka mɔɔilu fanan karan woilu labatola, wo tii ri jate mɔɔba ri Harijeene Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","N di tuɲa fɔ ai yɛ ko ni ai la telenbaya ma tamin Farisilu ni sariya karanmɔɔilu ta kan, ai tɛ don Harijeene Mansaya rɔ fewu. ");
INSERT INTO msc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ai ka a mɛn ko a fɔra ai benbailu yɛ ko: ‹I kana mɔɔ faa,› ko ‹ni mɔɔ wa mɔɔ faa, a ri a lɔ Alla ɲakɔrɔ a kiti kanma.› ");
INSERT INTO msc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kɔni n ye a fɔla ai yɛ ko ni mɔɔ mɔɔ mɔnɛra a badenma kanma, wo bɛnnin de ka a makiti. Ni mɔɔ mɛn ka a badenma nani ko a mɔɔ koron, mɔɔilu ka kan ka wa wo tii ri Yahudiya la kititɛɛ dɛkuru tɛma. Ni mɔɔ mɔɔ ka a fɔ a badenma ma ko a nalonma, wo tii bɛnnin jahanama ta le rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wo le rɔ, i wa kɛ sɔlifen bɔla Alla la saraka janin diya ɲakɔrɔ, ni i hankili jiira a la ko ko do ye i ni i badenma tɛ, ");
INSERT INTO msc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","i ye i la sɔlifen to Alla la saraka janin diya ɲakɔrɔ. I ye wa ka i ni i badenma tɛrabɛn fɔlɔ. Wo kɔ rɔ, i ri wa i la sɔlifen di Alla ma. ");
INSERT INTO msc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Ni mɔɔ do ye wala i ri kititɛɛla wara ko a ye a makasila i kan, ai watɔla, i ye ko bɛɛ kɛ ka kɛlɛ ban jona. Ni wo tɛ, ni a wara i don kititɛɛla bolo, wo ri i don kaso bon kuntii bolo. Wo fanan di i bila kaso la. ");
INSERT INTO msc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N di tuɲa fɔ i yɛ. I tɛ bɔ kaso la fewu, fɔɔ i wa ban wodi fɔni bɛɛ muumɛ sarala. ");
INSERT INTO msc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ai ka a mɛn ko a fɔra ko: ‹I kana kaninkɛ kɛ.› ");
INSERT INTO msc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kɔni n ye a fɔla ai yɛ ko ni i ka muso do ragbɛ ka kunfan a fɛ, i ra ban kaninkɛ kɛla muso wo fɛ i jusu rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wo rɔ, ni i bolokininma ɲa kɛra sababu ri ka i lɔ kojuu kɛla, i ye a bɔ ka a lafili, baa i bɔnɔ i farikolo yɔrɔ kelen na, wo le ka fisa i ma sani i farikolo dafanin ye lafili jahanama rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni i bolokinin kɛra sababu ri ka i lɔ kojuu kɛla, a tɛɛ a la ka a lafili, baa i bɔnɔ i farikolo yɔrɔ kelen na, wo le ka fisa i ma sani i farikolo dafanin ye wa jahanama rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«A fɔra fanan ko: ‹Ni cɛɛ mɛn ye a fɛ ka a muso bila, fɔɔ a ye furusa sɛbɛ di a ma.› ");
INSERT INTO msc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kɔni n ye a fɔla ai yɛ ko mɔɔ mɔɔ wa a muso bila ka a tɛrɛn muso wo tun ma jalonya kɛ, wo tii ra kaninkɛla sila le bila muso wo kɔrɔ. Mɔɔ mɛn wa muso furusani furu, wo tii fanan da kaninkɛ. ");
INSERT INTO msc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Fanan, ai ka a mɛn ko a fɔra ai benbailu yɛ ko: ‹I kana i kalilikan tiɲan. I wa dakan mɛn ta Alla yɛ, i ye wo dafa.› ");
INSERT INTO msc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kɔni n ye a fɔla ai yɛ ko ai kana ai kali muumɛ. Ai kana ai kali sankolo la, baa Alla la Mansaya siifen de wo ri. ");
INSERT INTO msc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ai kana ai kali duukolo la, baa Alla sen lɔ yɔrɔ le wo ri. Ai kana ai kali Jerusalɛmu la, baa Mansaba Alla la so le wo ri. ");
INSERT INTO msc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ai kana ai kali ai jɛrɛ kun na, baa ai ti se hali ai kunsi kelen gbɛla, wala ka a fin. ");
INSERT INTO msc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni ai sɔnda ko ma, ai ye a fɔ dɔrɔn ko ‹ɔɔn›. Ni ai ma sɔn ko ma, ai ye a fɔ dɔrɔn ko ‹ɛɛn›. Ai ye dan wo ma. Mɛnilu wa la wo kan, woilu bɛɛ bɔni Setana rɔ. ");
INSERT INTO msc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ai ka a mɛn ko a fɔra ko: ‹Ni mɛn ka ɲa te, ai ye wo fanan ɲa te. Ni mɛn ka ɲin kadi, ai ye wo fanan ɲin kadi.› ");
INSERT INTO msc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kɔni n ye a fɔla ai yɛ ko ai kana ai ta julu sara mɔɔ la mɛn ye a fɛ ka kojuu kɛ ai la. Ɔɔn, ni mɔɔ do ka i bolokininma tolo gbasi, i ni a to kelen fanan lɔ a yɛ. ");
INSERT INTO msc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni mɔɔ ye a fɛ ka wa i ri kiti diya sa a ri i la duruki kɔrɔbila mira i la, i ye i la durukiba fanan di a ma. ");
INSERT INTO msc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ni mɔɔ ka i diyagboya ko i ye a la donin ta ka kilo kelen taama kɛ a fɛ, i ye a la donin ta ka kilo fila taama kɛ a fɛ. ");
INSERT INTO msc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ni mɔɔ ka i tara fen na, i ye a sɔ. Ni mɔɔ ka a fɔ ko i ye i la fen sinkan a ma, i kana i ban a ma. ");
INSERT INTO msc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ai ka a mɛn ko a fɔra ko: ‹I ye i mɔɔɲɔɔilu kanin, ka i juuilu kɔn.› ");
INSERT INTO msc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kɔni n ye a fɔla ai yɛ ko ai ye ai juuilu kanin, ka Alla tara ai tɔrɔbailu yɛ. ");
INSERT INTO msc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ni ai ka a kɛ ten, ai ri kɛ ai sankolo rɔ Fa denilu ri. Baa ale le ye a la tele labɔla mɔɔ juuilu ni mɔɔ ɲumailu fila bɛɛ yɛ. A ye sanci nanala mɔɔ telenniilu ni mɔɔ telenbaliilu fila bɛɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni wo tɛ, ni ai ka ai kaninbailu dɔrɔn kanin, ai ri barayi ɲuman sɔrɔn wo la? Hali niisankɔmiralailu ye wo ɲɔɔn kɛla. ");
INSERT INTO msc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni ai ye ai badenmailu le dɔrɔn de fola, wo ye ko ba ri wa? Ɛɛn. Hali Alla lɔnbaliilu ye wo ɲɔɔn kɛla. ");
INSERT INTO msc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ai ye kɛ mɔɔ dafaninilu ri ikomin ai sankolo rɔ Fa dafanin ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ai ye ai janto ai jɛrɛ rɔ. Ai kana ai la telenbaya kɛwaliilu kɛ mɔɔilu ɲana sa ii ri woilu kɛni yen ai bolo. Ni ai ka wo kɛ, ai Fa mɛn ye sankolo rɔ, wo tɛna barayi foyi di ai ma. ");
INSERT INTO msc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Wo rɔ, i wa kɛ dɛsɛbatɔ sɔla, i kana buru fɛ i mayira kanma ikomin jɛrɛmayuwailu ye a kɛla ɲa mɛn ma. Ii ye wo kɛla salibonilu kɔndɔ, a ni sila dailu la, sa mɔɔilu ri ii tando. N di tuɲa fɔ ai yɛ: ii la barayi dan de mɔɔilu la tandoli wo ri. ");
INSERT INTO msc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","I wa kɛ dɛsɛbatɔ sɔla i bolokinin na, i bolomaran ma kan ka wo lɔn. ");
INSERT INTO msc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wo rɔ, i la dɛsɛbatɔ sɔli ri kɛ dokon dɔ. Mɛn ye kɛla dokon dɔ, i Fa Alla ye wo yenna, ka i barayi. ");
INSERT INTO msc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ai wa kɛ Alla tarala, ai kana wo kɛ ikomin jɛrɛmayuwailu ye a kɛla ɲa mɛn ma. Baa a duman ii yɛ ka ii lɔ salibonilu kɔndɔ, a ni sila dailu la, ka Alla tara, sa mɔɔilu ri ii yen. N di tuɲa fɔ ai yɛ: ii la barayi dan de mɔɔilu la tandoli wo ri. ");
INSERT INTO msc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kɔni i wa kɛ Alla tarala, i ye don i la bon na ka da tuun i jɛrɛ ma. I ye i Fa Alla tara ye, baa a ye yɔrɔ doonni wo rɔ. Mɛn ye kɛla dokon dɔ, i Fa Alla ye wo yenna, ka i barayi. ");
INSERT INTO msc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ai wa kɛ a tarala, ai kana kuma siyaman fɔ fuu ikomin Alla lɔnbaliilu ye a kɛla ɲa mɛn ma. A ye woilu kɔndɔ ko ii la kuma siyaya le kosɔn ii tarali ri lamɛn. ");
INSERT INTO msc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ai kana wo ɲɔɔn kɛ, baa ai mako ye fen fen na, ai Fa Alla ka wo lɔn sani ai ye a tara. ");
INSERT INTO msc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Ai ka kan ka Alla tara ɲa mɛn ma, wo le ɲin di. An Fa mɛn ye sankolo rɔ, i tɔɔ sɛniman ye bonya ka. ");
INSERT INTO msc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","I la Mansaya ye na. I sawo ye kɛ duukolo kan ikomin a ye kɛla sankolo rɔ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","An mako ye dɔɔnnin mɛn na bi, i ye wo di an ma. ");
INSERT INTO msc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","I ye an na kojuuilu makoto, ikomin an fanan da mɔɔilu makoto, mɛnilu ra kojuu kɛ an na. ");
INSERT INTO msc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","I kana a to an ye manɛɛn ka bila kojuu rɔ. Kɔni i ye an bɔsi Setana bolo. ");
INSERT INTO msc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ni ai ka ai hakɛtabailu makoto, ai Fa mɛn ye sankolo rɔ, wo fanan di ai makoto. ");
INSERT INTO msc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kɔni ni ai ma ai hakɛtabailu makoto, ai Fa fanan tɛ ai la hakɛilu makoto. ");
INSERT INTO msc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ai wa kɛ sun donna lon mɛn na, ai kana ai ɲakɔrɔ sidi ikomin jɛrɛmayuwailu ye a kɛla ɲa mɛn ma. Woilu ye ii ɲakɔrɔ sidila sa mɔɔilu ri a lɔn ko ii ye sun dɔ. N di tuɲa fɔ ai yɛ: ii la barayi dan de mɔɔilu la tandoli ri. ");
INSERT INTO msc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","I wa kɛ sun donna, i ye i ɲa lako, ka tulu sumaduman kɛ i kun dɔ, ");
INSERT INTO msc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sa mɔɔilu kana a lɔn ko i ye sun dɔ. Kɔni i Fa mɛn doonni, wo ri a lɔn. Mɛn ye kɛla dokon dɔ, i Fa ye wo yenna, ka i barayi. ");
INSERT INTO msc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ai kana nanfulu ladɛn ai jɛrɛ yɛ dunuɲa rɔ yan, ɲɛnbɛrɛilu ni kɔrikɔri ye tiɲanni kɛla yɔrɔ mɛn. Sonilu fanan ye da kadila ka don ka suɲali kɛ. ");
INSERT INTO msc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ai ye nanfulu ladɛn ai jɛrɛ yɛ sankolo rɔ, ɲɛnbɛrɛilu ni kɔrikɔri ti se tiɲanni kɛla yɔrɔ mɛn. Sonilu fanan ti se da kadila ka suɲali kɛ ye. ");
INSERT INTO msc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Baa i la nanfulu ye yɔrɔ mɛn dɔ, i solɔmɛ fanan ye yɔrɔ wo le rɔ. ");
INSERT INTO msc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Mɔɔ ɲa le ye a farikolo fitina ri. Wo rɔ, ni i ɲa kisɛ ka ɲi, kɛnɛ ri don a la, ka i kɔndɔ gbɛ. ");
INSERT INTO msc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kɔni ni i ɲa kisɛ ma ɲi, i fari fan bɛɛ ri to dibi rɔ. Nba, yelen mɛn ka kan ka tɛrɛn i rɔ, ni wo ra to dibi rɔ, dibi ba le wo ri fewu! ");
INSERT INTO msc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Mɔɔ ti se ka baara kɛ kuntii fila yɛ waati kelen. Ni kuntii kɛra fila ri jɔncɛ ri do kanin ka tamin do kan. A ri do kumakan bonya ka tamin do ta la. Wo rɔ, ai ti se ai jii lala Alla ni nanfulu rɔ. ");
INSERT INTO msc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Wo le kosɔn, n ye a fɔla ai yɛ ko ai kana hamin ai la dunuɲaratɛɛ la, ai la dɔɔnnin ko la; wala a faribanku la ko la, ai ye mɛn bilala a ma. Ai la niimaya ma bon dɔɔnnin ko ri wa? Ai fari la ko ma bon feriyabɔ ko ri wa? ");
INSERT INTO msc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ai ye kɔnɔilu kɔrɔsi, mɛnilu ye ii gbanna san ma. Ii tɛ sɛnɛ kɛla, ii tɛ suman kala. Ii tɛ suman nadonna bondon kɔndɔ. Kɔni ai Fa mɛn ye sankolo rɔ, wo ye ii balola. A ye di? Ai ɲatɔnɔ ka bon ii ta ri, wo tɛ? ");
INSERT INTO msc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yon ye ai tɛma, mɛn di se waati kelen lala a si kan a la hamin baraka rɔ? ");
INSERT INTO msc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nfenna ai ye haminna ai la feriyabɔ ko la? Ai ye waa rɔ binilu kɔrɔsi, ii ye wulila ɲa mɛn ma. Ii tɛ baara kɛla, ii tɛ feriyabɔ ladanna. ");
INSERT INTO msc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kɔni n ye a fɔla ai yɛ ko hali mansa Sulemani mɛn kɛra nanfulutiiba ri, wo ma faanin si don mɛn kenɲi ka se bin fere woilu kelen dɔ. ");
INSERT INTO msc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nba, bin mɛnilu ye waa rɔ bi, woilu ri janin ta la sini. Ni Alla ka fereilu bila ii la, mɛnilu ye ikomin ii la feriyabɔ, Alla ti se feriyabɔ dila ai fanan ma wa, ai mɛn na lemɛniya ka dɔɔ? ");
INSERT INTO msc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wo le rɔ, ai kana hamin ka a fɔ ko: ‹An di nfen dɔɔn, an di nfen min, an di feriyabɔ sɔrɔn di?› ");
INSERT INTO msc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Siya gbɛrɛ mɔɔilu le ye haminna ko woilu la. Ai Fa mɛn ye sankolo rɔ, wo ka a lɔn ko ai fanan mako ye fen woilu bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ai ye a ɲinin Alla la Mansaya ni a la telenbaya ko le ma fɔlɔ. Ni ai ka a kɛ ten, fen bɛɛ ri di ai ma fanan. ");
INSERT INTO msc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ai kana hamin sini koilu la. Ai ye sini koilu to sini yɛ. Mɔɔilu ye tɔrɔya mɛn sɔrɔnna lon kelen kɔrɔ, wo ri lon wo bɔ.» ");
INSERT INTO msc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Isa tora kumala ko: «Ai kana mɔɔ kiti, sa ai fanan kana makiti; ");
INSERT INTO msc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","baa ai wa mɔɔilu makiti ɲa mɛn ma, ai fanan ye makitila wo ɲa le ma. Ai ye sumannifen mɛn jatela mɔɔilu yɛ, sumannifen kelen de fanan ye jatela ai fanan yɛ Alla bolo. ");
INSERT INTO msc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nfenna i ye ɲamanin mafɛnɛla i badenma ɲa ma, ka a tɛrɛn i tɛ fɛrɛn kɔrɔsila, mɛn ye i jɛrɛ ɲa ma? ");
INSERT INTO msc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A ye di? Ka fɛrɛn to i jɛrɛ ɲa ma, i ri se a fɔla i badenma yɛ di ko: ‹I ye a to n ye ɲamanin wo bɔ i ɲa ma›? ");
INSERT INTO msc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jɛrɛmayuwa! I ye fɛrɛn bɔ i jɛrɛ ɲa ma fɔlɔ. Ni i ka a kɛ ten, i ri fen yen koɲuma ka se ɲamanin bɔla i badenma ɲa ma. ");
INSERT INTO msc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Ai kana fen sɛniman di wuluilu ma. Ni wo tɛ, ii ri ii kɔsɛ ai ma ka ai rafarafara. Ai kana kɔrɔn kisɛ di kɔsɛilu ma. Ni wo tɛ, ii ri wo radɔn. ");
INSERT INTO msc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ai wa matara foyi la, ai ri wo sɔrɔn; ai wa ɲinin, a ri a sɔrɔn; ai wa da makonkon, a ri laka ai yɛ. ");
INSERT INTO msc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ka a masɔrɔn mɔɔ si wa matara, a ri a sɔrɔn; mɔɔ wa fen ɲinin, a ri a sɔrɔn; mɔɔ wa da makonkon, a ri laka a yɛ. ");
INSERT INTO msc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","A ye di? Ni a dencɛ do ka buru tara a la, yon de ai rɔ, mɛn di kabakurun di a ma? ");
INSERT INTO msc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wala, ni a dencɛ ka i matara jɛɛ la, a ri sa don a bolo wa? ");
INSERT INTO msc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nba, ni aile, adamadenilu mɛn ka juu, ai kusan fen ɲuma dila ai denilu ma, wo gbɛnin de an Fa Alla mɛn ye sankolo rɔ ye fen ɲumailu dila a tarabailu ma! ");
INSERT INTO msc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wo rɔ, ai ye a fɛ mɔɔilu ye ko mɛnilu bɛɛ kɛ ai yɛ, ai jɛrɛ ye woilu ɲɔɔn kɛ ii yɛ, ka a masɔrɔn wo ye sariya ni nabiilu la sɛbɛli dafanin de.» ");
INSERT INTO msc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Ai ye don don diya dɔɔmanni fɛ, baa sila mɛn ye wala mɔɔ halaki diya ma, wo don diya ka bon. Sila wo taama duman. Mɔɔ siyaman ye wala sila wo le fɛ. ");
INSERT INTO msc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kɔni sila mɛn ye wala ɲenemaya rɔ, wo don diya dɔɔman. Wo sila taama gboman. A sɔrɔnbailu fanan ma siya. ");
INSERT INTO msc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ai ye ai jɛrɛ kɔrɔsi wuya nabiilu ma. Ii ye ii jɛrɛ kɛla ikomin saailu, mɛnilu ma juu, ka a tɛrɛn wara juuilu le. ");
INSERT INTO msc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ai ri woilu lɔn ii la kɛwaliilu le fɛ, ikomin jiri ye lɔnna a den fɛ ɲa mɛn ma. A ye di? Mɔɔ ri se rɛsɛnden mɔnɛn kadila bin wɔninma la wa? Mɔɔ ri se toroden kadila jiri tunin wɔninma la wa? Wo kuma tɛ. ");
INSERT INTO msc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jiri ɲuma bɛɛ ri den ɲuma le kɛ, kɔni jiri juu ri den juu kɛ. ");
INSERT INTO msc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jiri ɲuma ti se den juu kɛla, jiri juu fanan ti se den ɲuma kɛla. ");
INSERT INTO msc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jiri mɛnilu tɛ den ɲuma kɛla, woilu bɛɛ ri tɛɛ ka lafili ta rɔ. ");
INSERT INTO msc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wo le rɔ, ai ri se wuya nabiilu lɔnna ii la kɛwaliilu fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Mɔɔ mɛnilu ye a fɔla ko: ‹Maari, Maari,› woilu bɛɛ tɛ donna Harijeene Mansaya rɔ fɔɔ mɛnilu ye n Fa Alla sawo kɛla. ");
INSERT INTO msc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mɔɔ siyaman di a fɔ n yɛ wo lon ko: ‹Maari, Maari, an ma kelaya kuma fɔ i tɔɔ rɔ wa? An ma jinailu gbɛn ka ii bɔ mɔɔilu fɛ i tɔɔ rɔ wa? An ma kabannako siyaman kɛ i tɔɔ rɔ wa?› ");
INSERT INTO msc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wo lon, n di a fɔ ii yɛ ka a gbɛ ko: ‹N ma ai lɔn fewu. Aile sariya tiɲannailu, ai ye bɔ n fɛ de!›» ");
INSERT INTO msc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Nba, mɔɔ mɔɔ wa a tolo malɔ n na kuma la, ka wo labato, wo tii ri kɛ ikomin cɛɛ famunyani mɛn ka a la bon lɔ fara kan. ");
INSERT INTO msc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sanci nara, ji woyenda, sanci fɔɲɔ sera bon wo ma. Kɔni bon ma be, baa a juu siini fara kan. ");
INSERT INTO msc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kɔni mɔɔ mɔɔ wa a tolo malɔ n na kuma ɲin na kɔni a ma wo labato, wo tii ye ikomin cɛɛ nalonma, mɛn ka a la bon lɔ kiɲɛ kan. ");
INSERT INTO msc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sanji nara, ji woyenda, sanci fɔɲɔ sera bon wo ma. Bon wo bera ka tiɲan fewu.» ");
INSERT INTO msc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nba, Isa banni kuma ɲinilu fɔla, a la karan ka jama kabannakoya, ");
INSERT INTO msc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","baa a ka ii karan ikomin se ye mɛn bolo mɔɔilu kan. A ma ii karan ikomin ii la sariya karanmɔɔilu ye ii karanna ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Isa jiira ka bɔ koyinkɛ kan tuma mɛn na, jama ba ka ii bila a kɔ. ");
INSERT INTO msc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kunatɔ do nara a ɲɔnkin duu ma Isa kɔrɔ, ka a fɔ a yɛ ko: «Maari, ni i sɔnda, a se ye i yɛ ka n nasɛniya.» ");
INSERT INTO msc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isa ka a bolo rasɔmɔn ka a maa cɛɛ la, ka a fɔ a yɛ ko: «N da sɔn, i ye lasɛninya.» A la kuna sɛniyara i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Isa ka a fɔ a yɛ ko: «I ye i janto i jɛrɛ rɔ, i kana wo ko fɔ mɔɔ si yɛ. Wa sarakalasela tɔrɔfɛ, a ye i fari ragbɛ. Wo wa ban, Musa ka saraka mɛn fɔ, ka a kɛ sereya ri, i ye wo bɔ ka a yiraka bɛɛ la ko i ra kɛndɛya.» ");
INSERT INTO msc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Awa, Isa wara Kapɛrinahumu. A dontɔla so kɔndɔ, kɛlɛden kuntii do nara ka a madiya ko: ");
INSERT INTO msc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Maari, n na baaraden lani bon na. Kɔrɔngbɔnin jankarɔ ra a mira ka a lala. A tɔrɔni kojuuya.» ");
INSERT INTO msc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Isa ka a fɔ a yɛ ko: «N di wa a lakɛndɛya.» ");
INSERT INTO msc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kɔni kɛlɛden kuntii ka a fɔ ko: «Maari, i ma kan ka don n wara, baa a dahanin tɛ n yɛ ko i ye don n na bon na! Kɔni ni i ka kuma kelen fɔ dɔrɔn, n na baaraden di kɛndɛya wo rɔ, ");
INSERT INTO msc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","baa n ye kuntii do la se kɔrɔ, kɛlɛden doilu fanan ye n na se kɔrɔ. N wa a fɔ mɛn yɛ ko a ye wa, wo ri wa. N wa a fɔ mɛn yɛ ko a ye na, wo ri na. N wa a fɔ n na jɔn yɛ ko a ye mɛn kɛ, a ri wo kɛ.» ");
INSERT INTO msc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isa ka kuma wo mɛn tuma mɛn na, a kabannakoyara. A ka a fɔ a kɔbilabailu yɛ ko: «N di tuɲa fɔ ai yɛ ko n ma mɔɔ si sɔrɔn Isirayɛlikailu tɛma fɔlɔ, mɛn lemɛniyani ikomin cɛɛ ɲin. ");
INSERT INTO msc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N di a fɔ ai yɛ ko lon do rɔ, mɔɔ siyaman di bɔ telebɔ ni telebe rɔ ka na i sii dɔɔnnin diya Iburahima ni Isiyaka ni Yakuba dafɛ Harijeene Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kɔni mɛnilu tɛrɛ ka kan ka kɛ Alla la Mansaya mɔɔilu ri, ii ri lafili dibi rɔ kɔkan, kasi ni a ɲin macin ye yɔrɔ mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Isa ka a fɔ kɛlɛden kuntii yɛ ko: «Wa i wara. I ka mɛn ɲinin, wo ri kɛ i yɛ i la lemɛniya kosɔn.» Wo waati kelen, kɛlɛden kuntii la baaraden kɛndɛyara. ");
INSERT INTO msc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Isa wani Piyɛri wara lon do rɔ, a ka Piyɛri biranmuso lani yen. Fari makaliya ye a la. ");
INSERT INTO msc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Isa ka a maa muso bolo la, fari makaliya bɔra a fari rɔ. A wulira ka gba don ii yɛ. ");
INSERT INTO msc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wura donnin, jama nara mɔɔ siyaman di Isa tɔrɔfɛ jina juuilu ye mɛnilu fɛ. Isa ka jinailu gbɛn a la kuma la, ka jankarɔtɔilu bɛɛ lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wo kɛra sa Alla la kuma ri kanbali, a ka mɛn don Nabi Esayi da rɔ ko: «Fen mɛnilu tɛrɛ ye an sɛɛla, a ka woilu ta. Jankarɔ mɛnilu tɛrɛ ye an kan, a ka woilu bɔ an kan.» ");
INSERT INTO msc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Isa ka a yen ko jama ba ye a laminin dɔ mɛn kɛ, a ka a fɔ a la karandenilu yɛ ko: «An ye wa dala kɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sariya karanmɔɔ do ka a madon Isa la, ka a fɔ a yɛ ko: «Karanmɔɔ, i wa kɛ wala fan fan, n di n bila i kɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isa ka a jabi: «Denka ye sɔyaninilu bolo, ɲaa ye kɔnɔilu bolo. Kɔni yɔrɔ si tɛ Mɔɔ Dencɛ bolo, a ri a la ka a ɲɔɲɔ yɔrɔ mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Isa la karanden gbɛrɛ ka a fɔ a yɛ ko: «Maari, i ye a to n ye wa n fa su don fɔlɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Isa ka a fɔ a yɛ ko: «I ye i bila n kɔ. I ye a to mɔɔ saniilu ye ii la mɔɔ saniilu suilu don.» ");
INSERT INTO msc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isa ka a sii kulun kɔndɔ tuma mɛn na, a la karandenilu wara a kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka ii to ji kan, fɔɲɔba do wulira i kɔrɔ. Fɔɲɔ bonya kojuu ma, ji wunwanailu tɛrɛ ye donna kulun kɔndɔ. Wo ka a tɛrɛn Isa ye sunɔɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Karandenilu ka ii madon a la ka a lakunun ko: «Maari, i ye an kisi! An faatɔ le!» ");
INSERT INTO msc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A ka ii jabi: «Nfenna ai ye silanna? Ai tɛ lemɛniyala kosɛbɛ!» A wulira ka ji ni fɔɲɔ makuma. Mankan masumara fewu. ");
INSERT INTO msc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cɛilu kabannakoyara. Ii ka a kɛ a fɔ ri i ɲɔɔn yɛ ko: «Ee! Cɛɛ ɲin ye mɔɔ su ɲuman de ri? Hali fɔɲɔ ni ji ye a kan mirala.» ");
INSERT INTO msc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Isa ni a la karandenilu banda dala tɛɛla ka se Kadara mara rɔ. Jinatɔ fila bɔra kaburuilu rɔ ka na Isa kunbɛn. Jinatɔ woilu fadiman, fɔɔ mɔɔ tun ti se taminna ye. ");
INSERT INTO msc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ii kulera kan ba la ko: «Alla Dencɛ, i ye nfen ɲininna an fɛ? I nani an tɔrɔ diya le rɔ, sani an na tɔrɔya waati ye se wa?» ");
INSERT INTO msc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Wo ka a tɛrɛn kɔsɛ kuru ba ye dɔɔnninna yɔrɔ jan. ");
INSERT INTO msc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jinailu ka Isa madiya ko: «Ni i ka an gbɛn, i ye diɲɛ an ye wa don kɔsɛ kuru ɲin dɔ.» ");
INSERT INTO msc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Isa ka a fɔ ii yɛ ko: «Ai ye wa!» Jinailu bɔra cɛɛ fila wo fɛ ka wa don kɔsɛilu rɔ. Ii donda kɔsɛilu rɔ mɛn kɛ, kɔsɛilu bɛɛ ka ii bori kojuuya, ka jii tindi la ka wa don dala ji rɔ. Ii bɛɛ tununda ji rɔ ka faa. ");
INSERT INTO msc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kɔsɛ gbɛnnailu ka ii bori ka wa so kɔndɔ. Ko mɛnilu kɛni, ii ka wo bɛɛ lakali, katɛrɛtɛ jinatɔilu lakɛndɛyara ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","So kɔndɔ mɔɔilu bɛɛ bɔra ka na Isa tɛrɛn. Ii ka a yen tuma mɛn na, ii ka a madiya ko a ye a sabari ka bɔ ii la mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isa donda kulun kɔndɔ, ka dala tɛɛ, ka wa se a jɛrɛ la so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka a to ye, mɔɔilu nara kɔrɔngbɔbatɔ do ri a ma, wo lani a la gbeke kan. Isa ka a yen ko ii ra lemɛniya ko a ri se cɛɛ lakɛndɛyala. Wo rɔ, a ka a fɔ kɔrɔngbɔbatɔ yɛ ko: «N dencɛ, i sɛɛbɛ don. I la kojuuilu ra makoto.» ");
INSERT INTO msc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sariya karanmɔɔ doilu ka wo mɛn ka a fɔ ii jɛrɛ kɔndɔ ko: «Cɛɛ ɲin ye Alla lafɛya ko kɛla.» ");
INSERT INTO msc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isa ka ii miriya lɔn. A ka a fɔ ii yɛ ko: «Nfenna miriya juu ɲin ɲɔɔn ye ai jusukun dɔ? ");
INSERT INTO msc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A ye di? Ka a fɔ ko ‹i la kojuuilu ra makoto› wala ka a fɔ ko ‹i ye wuli ka taama,› wo fila rɔ ɲuman de fɔ duman? ");
INSERT INTO msc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nba, n di a yiraka ai la ko a se ye nde Mɔɔ Dencɛ yɛ ka kojuuilu makoto dunuɲa rɔ yan.» Wo rɔ, a ka a fɔ kɔrɔngbɔbatɔ yɛ ko: «I wuli ka i la lafen ta ka wa i wara.» ");
INSERT INTO msc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Cɛɛ wulira ka wa a wara. ");
INSERT INTO msc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jama ka wo yen tuma mɛn na, ii silanda. Ii ka Alla bonya, baa ale le ka se ba ɲin di mɔɔilu ma! ");
INSERT INTO msc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Isa bɔra ye ka wa. A watɔla, a ka cɛɛ do siini yen niisankɔ mira diya, cɛɛ mɛn tɔɔ ko Matiyu. Isa ka a fɔ a yɛ ko: «I ye na i bila n kɔ.» Matiyu wulira ka a bila Isa kɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lon do rɔ, Isa wara dɔɔnnin diya Matiyu wara. Niisɔnkɔmirala siyaman ni kojuu kɛla siyaman fanan nani tɛrɛ ye. Woilu tɛrɛ ye dɔɔnninna Isa ni a la karandenilu fɛ. ");
INSERT INTO msc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisi doilu ka wo yen tuma mɛn na, ii ka a fɔ Isa la karandenilu yɛ ko: «Nfenna ai la karanmɔɔ ye sɔnna ka dɔɔnnin kɛ niisankɔmiralailu ni kojuukɛlailu fɛ?» ");
INSERT INTO msc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isa ka wo mɛn ka ii jabi: «Mɔɔ mɛnilu kɛndɛ, woilu mako tɛ dandalila la. Jankarɔtoilu le mako ye dandalila la. ");
INSERT INTO msc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuma mɛn sɛbɛni Alla la kitabu kɔndɔ ɲin, ai ye wa ai miri wo kɔrɔ ma. A sɛbɛni ko: ‹N ye a fɛ mɔɔ ye hina mɔɔ la. Wo duman n yɛ ka tamin saraka bɔli kan.› Nba, n ma na ka mɔɔ telenbailu kili fɔɔ kojuukɛlailu.» ");
INSERT INTO msc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wo kɔ, Yaya la karandenilu nara Isa tɛrɛn, ka a maɲininka ko: «Andeilu ni Farisilu darini sun donna. Nfenna i la karandenilu tɛ wo kɛla?» ");
INSERT INTO msc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isa ka ii jabi: «A ye di? Ka kɔɲɔcɛ to a duɲɔɔilu dafɛ kɔɲɔmalɔ rɔ, kɔɲɔcɛ duɲɔɔilu ri se ii ɲakɔrɔ sidila wa? Wo kuma tɛ. Kɔni lon do natɔ, kɔɲɔcɛ ri bɔ ii tɛma. Wo lon, ii ri sun don. ");
INSERT INTO msc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Mɔɔ tɛ faanin kura kunkundun ta ka faanin kɔrɔ labadi. Ni mɔɔ ka wo kɛ, faanin kura ri faanin kɔrɔ sɔmɔn ka a fara. A faraɲa wo ri juuya ka tamin fɔlɔmanta kan. ");
INSERT INTO msc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mɔɔ tɛ rɛsɛnji kura burundun foroko kɔrɔ kɔndɔ. Ni mɔɔ ka wo kɛ, foroko ri fara, rɛsɛnji ri bɔ. Foroko ri tiɲan. Ɔɔn, mɔɔ ri rɛsɛnji kura kɛ foroko kura le kɔndɔ. Wo rɔ, fen si tɛ tiɲan.» ");
INSERT INTO msc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka Isa to kuma ɲin fɔla, Yahudiya la ɲɛmɔɔ do nara a birin Isa ɲɛ, ka a madiya ko: «N denmuso sasan de ten ten. I ye na i bolo la a kan. Wo rɔ, a ri balo.» ");
INSERT INTO msc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isa ni a la karandenilu wulira ka ii bila cɛɛ kɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wo ka a tɛrɛn, muso jankarɔto do ye ye. A ra san tan ni fila kɛ jelibɔ jankarɔ ye a la. A ka a madon Isa la a kɔfɛ ka a maa a la durukiba dakun na, ");
INSERT INTO msc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","baa a tɛrɛ ye a fɔla a jɛrɛ kɔndɔ ko: «Ni n sera ka a maa a la duruki la gbansan, n di lakɛndɛya.» ");
INSERT INTO msc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isa ka a kɔfɛni ka muso yen. A ka a fɔ a yɛ ko: «N denmuso, i sɛɛbɛ don. I la lemɛniya ra i lakɛndɛya.» Muso kɛndɛyara i kɔrɔ ye. ");
INSERT INTO msc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nba, Isa donda ɲɛmɔɔ la bon kɔndɔ. A ka fulɛfɔlailu tɛrɛn ye, a ni jama mɛn ye mankanba bɔla. ");
INSERT INTO msc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","A ka a fɔ ii yɛ ko: «Ai ye wa. Sunkurun ma sa, a ye sunɔɔ rɔ tuun.» Kɔni ii ka a bɔrɔbɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jama bɛɛ labɔra kɛnɛma tuma mɛn na, Isa donda bon kɔndɔ, ka sunkurun su mira a bolo ma. Sunkurun wulira. ");
INSERT INTO msc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mɔɔilu ka wo ko kibaro mɛn wo jamana yɔrɔ bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Isa bɔra ye ka wa. Ɲa fuyen fila wulira ka ii bila a kɔ, ii ye wɔyɔla ko: «Dawuda dencɛ, i ye hina an na.» ");
INSERT INTO msc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Isa donda bon na tuma mɛn, ɲa fuyen fila ka ii madon a la. A ka ii maɲininka ko: «Ai lani a la ko n di se ai ɲa lakala wa?» Ii ka a fɔ ko: «Ɔɔn, Maari, an lani wo la.» ");
INSERT INTO msc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wo rɔ, Isa ka a bolo maa ii ɲa la. A ka a fɔ ko: «Ai la lemɛniya kosɔn, ai ɲa ri laka.» ");
INSERT INTO msc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ii ɲa lakara. Isa ka a fɔ ii yɛ ka a magbɛlɛya ko: «Ai kana ko wo fɔ mɔɔ si yɛ.» ");
INSERT INTO msc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kɔni ii bɔni kɔ so kɔndɔ, Isa tun ka mɛn kɛ, ii ka wo lakali fan bɛɛ mara wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cɛɛ fila wo bɔra tuma mɛn na ka wa, mɔɔilu nara cɛɛ jinatɔ do ri Isa ma wo waati kelen. Jina tun da cɛɛ wo kɛ bobo ri. ");
INSERT INTO msc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isa ka jina gbɛn mɛn kɛ dɔrɔn, bobo cɛɛ wo kumara. Jama kabannakoyara ka a fɔ ko: «Wo ɲɔɔn ma kɛ Isirayɛlikailu la jamana kɔndɔ fɔlɔ fewu.» ");
INSERT INTO msc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kɔni Farisilu ka a fɔ ko: «Jinailu la kuntii ye se dila Isa ma ka jinailu gbɛn ka bɔ mɔɔilu fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isa tɛrɛ ye soilu ni bondailu bɛɛ rataamala. A tɛrɛ ye mɔɔilu karanna ii la salibonilu la, ka Harijeene Mansaya kibaro ɲuma lase, ka jankarɔto su bɛɛ lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A ka jama yen tuma mɛn na, ii kininkinin donda a rɔ. Ii bɛɛ haminni, ka tunagboya. Ii ye ikomin saailu, gbɛngbɛnna tɛ mɛnilu la. ");
INSERT INTO msc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A ka a fɔ a la karandenilu yɛ ko: «Suman kata ka siya, kɔni baaraden ma siya. ");
INSERT INTO msc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wo le rɔ, ai ye sɛnɛtii madiya, sa a ri baaradenilu lɔ suman kala a la sɛnɛ rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Wo kɔ rɔ, Isa ka a la karanden tan ni fila kili, ka sebaya di ii ma sa ii ri se jina juuilu gbɛnna, a ni ka jankarɔ juuilu su bɛɛ lakɛndɛya a ni ka fɛɛmailu bɛɛ lakɛndɛya ii la fɛɛmayailu bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Talibidenba tan ni fila woilu tɔɔ le ɲin: fɔlɔman Simɔn, mɔɔilu ye a fɔla mɛn ma ko Piyɛri, a ni a dɔɔcɛ Andere, a ni Sebede dencɛ Yakuba ni a dɔɔcɛ Yuhana, ");
INSERT INTO msc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","a ni Filipe ni Baritɔlɔmi, a ni Tomasi ni Matiyu mɛn ye niisankɔmirala ri, a ni Alife dencɛ Yakuba ni Tade, ");
INSERT INTO msc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a ni Simɔn, faso lahɔrɔya lɔɔ ye mɛn na, a ni Judasi Sikariyɔti, mɛn natɔ Isa donna mɔɔilu bolo. ");
INSERT INTO msc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isa ka mɔɔ tan ni fila woilu kelaya. A ka a fɔ ko: «Ai kana wa siya gbɛrɛilu fɛ, ai kana don Samarikailu la so si kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kɔni ai ye wa Isirayɛlikailu fɛ, wo mɛnilu tununni ikomin saailu. ");
INSERT INTO msc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ai wa tamin fan fan na, ai ye mɔɔilu kawandi ko Harijeene Mansaya waati ra se. ");
INSERT INTO msc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ai ye jankarɔtoilu lakɛndɛya, ka suilu lawuli, ka kunatɔilu lakɛndɛya, ka jinailu gbɛn ka ii bɔ mɔɔilu fɛ. Ai ka a sɔrɔn gbansan, ai fanan ye a di gbansan. ");
INSERT INTO msc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ai kana sanin, wala wodigbɛ, wala wodi si bila ai la tɛmasidi rɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ai kana bɔrɔ ta, ai kana duruki kɔrɔbila fila ta. Ai kana sanbara fila ta, wala gbeleke fila, baa baaraden ni dɔɔnnin de ka kan. ");
INSERT INTO msc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ni ai donda so ba do kɔndɔ, wala so mɛsɛn, ai ye mɔɔ bɛrɛ do ɲinin, a bɛnnin mɛn ma ka ai jiya. Ai ye to wo bolo fɔɔ ai bɔ waati wa se so wo kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ai wa don wo tii la bon na, ai ye ye mɔɔilu tuwa. ");
INSERT INTO msc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ni a bɛnnin ii ma ka ai ramira koɲuma, ai la duwawu ri mira ii ma. Ni a bɛnnin tɛ ii ma ka ai ramira koɲuma, ai la duwawu ri a kɔsɛ ai ma. ");
INSERT INTO msc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ni mɔɔilu ma sɔn ka ai jiya, ni wo tɛ, ni ii ma sɔn ai la kuma ma, ai bɔtɔla lu ma, wala so kɔndɔ, ai ye ye gbangban bɔ ai sen ma. ");
INSERT INTO msc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N di tuɲa fɔ ai yɛ: Alla wa mɔɔilu kiti lon mɛn, mɔɔ woilu la kiti ri gbɛlɛya ka tamin hali Sɔdɔmu ni Kɔmɔri ta kan. ");
INSERT INTO msc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ai tolo malɔ! N ye ai lawala kela diya ikomin saailu, mɛnilu bilani wara juuilu tɛma. Ai ye kɛ hankilimailu ri, ikomin duuma sailu. Ai ye kɛ kojuukɛbali ri ikomin kanbailu. ");
INSERT INTO msc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ai ye ai janto ai jɛrɛ rɔ mɔɔilu kanma. Ii ri ai mira ka wa ai ri kititɛɛ diya. Ii ri ai gbasi gbiɲɛ la ii la salibonilu kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ii ri ai mira ka wa ai ri faamailu ni mansailu ma, ka a masɔrɔn ai ye n na karandenilu ri. Ai ri kɛ n sere ri wo rɔ, ka n na ko fɔ ii yɛ, ka n na ko fɔ siya gbɛrɛilu fanan yɛ. ");
INSERT INTO msc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ii wa ai mira ka wa ai ri kiti diya, ai ka kan ka kuma mɛnilu fɔ ye, a ni ai ka kan ka woilu fɔ ɲa mɛn ma, ai kana hamin woilu la, baa ai ka kan ka mɛn fɔ, Alla jɛrɛ ri wo don ai da rɔ wo waati kelen na. ");
INSERT INTO msc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Baa ai ri kuma mɛn fɔ, woilu tɛna kɛ ai jɛrɛ la kuma ri. Ai Fa Alla Nii de ri kuma don ai da rɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Mɔɔ ri a badenma don mɔɔilu bolo sa ii ri a faa. Fa fanan di wo ɲɔɔn kɛ a den na. Mɔɔilu ri murunti ii sɔrɔnbailu kanma, ka ii don mɔɔilu bolo sa ii ri ii faa. ");
INSERT INTO msc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ai ri gboya mɔɔilu bɛɛ yɛ n tɔɔ kosɔn. Kɔni mɔɔ mɛn wa a muɲun haan a la ban, wo tii ri kisi. ");
INSERT INTO msc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ni ii ka ai tɔrɔ so do la, ai ye ai bori ka wa so gbɛrɛ la. N di tuɲa fɔ ai yɛ: sani ai ye ban Isirayɛlikailu la jamana so bɛɛ taamala, Mɔɔ Dencɛ ri na. ");
INSERT INTO msc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Karanden tɛ bonyala a la karanmɔɔ ri. Jɔn fanan tɛ bonyala a jɔntii ri. ");
INSERT INTO msc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ni karanden kɛra a la karanmɔɔ ɲɔɔn di, a dan de wo ri. Ni jɔn kɛra a jɔntii ɲɔɔn di, a dan de wo ri. A ye di? Ni mɔɔilu ka kuma juu fɔ lutii jɛrɛ ma ko Ibulusa le ye a ri, ii tɛ do fɔ lu kɔndɔ mɔɔilu ma ka tamin wo kan wa? ");
INSERT INTO msc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Wo le kosɔn, ai kana silan mɔɔ woilu yɛ. Fen fen doonni, wo bɛɛ ri bɔ gbɛ rɔ. Gbundu ko tɛ ye, mɛn tɛ lɔn. ");
INSERT INTO msc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","N wa mɛnilu fɔ ai yɛ dibi rɔ, ai ye wo fɔ tele rɔ. N wa mɛnilu fɔ ai tolo kɔrɔ kan majii rɔ, ai ye ai lɔ bon kun bilinin kan ka wo fɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ai kana silan mɛn di se mɔɔ farikolo halakila kɔni ti se foyi kɛla mɔɔ nii na. Ai ye silan yɛ mɛn di se mɔɔ nii ni a faribanku bɛɛ halakila jahanama kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ai ye kɔnɔ mɛsɛn fila mayirala wodi gbanan mɛsɛn kelen na, ko di? Kɔni hali kɔnɔ wo kelen tɛ be duu ma ni ai Fa Alla ma sɔn a ma. ");
INSERT INTO msc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ai ta fan fɛ, ai Fa ka hali ai kunsiilu bɛɛ jate lɔn. ");
INSERT INTO msc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wo le rɔ, ai kana silan. Ai ɲatɔnɔma ka tamin kɔnɔ mɛsɛn siyaman nadɛnni kan. ");
INSERT INTO msc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Ni mɔɔ mɔɔ ka a fɔ mɔɔilu ɲana ko a ye n ta ri, n fanan di a fɔ n Fa Alla yɛ, mɛn ye sankolo rɔ, ko wo tii ye n ta ri. ");
INSERT INTO msc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɔni ni mɔɔ mɛn ka a fɔ mɔɔilu ɲana ko a tɛ n ta ri, n fanan di a fɔ n Fa Alla yɛ, mɛn ye sankolo rɔ, ko wo tii tɛ n ta ri. ");
INSERT INTO msc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ai kana ai miri ko n da na jususuma di duukolo kan de. N ma na jususuma di de. N nani fanmuru le ri. ");
INSERT INTO msc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Baa n nani ka dencɛ ni a fa bila ɲɔɔn na, ka denmuso ni a na bila ɲɔɔn na, ka muso ni a dencɛ muso bila ɲɔɔn na. ");
INSERT INTO msc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mɔɔ juuilu ri kɛ a jɛrɛ la mɔɔilu ri. ");
INSERT INTO msc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kɔni mɔɔ mɛn wa a fa wala a na kanin ka tamin n kan, wo tii ti se kɛla n na karanden di. Mɔɔ mɛn wa a dencɛ wala a denmuso kanin ka tamin n kan, wo tii fanan ti se kɛla n na karanden di. ");
INSERT INTO msc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mɔɔ mɛn ma sɔn ka a jɛrɛ gbɔngbɔn jiri ta ka a bila n kɔ, wo tii ti se kɛla n na karanden di, ");
INSERT INTO msc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","baa mɔɔ mɛn ye a fɛ ka a nii kisi, wo tii ri bɔnɔ ɲenemaya bɛrɛbɛrɛ la. Kɔni ni mɔɔ mɛn bɔnɔra a faribanku rɔ nde kosɔn, wo tii ri a jɛrɛ kisi. ");
INSERT INTO msc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ni mɔɔ mɛn ka ai mira koɲuma, wo tii ra n mira koɲuma. Ni mɔɔ mɛn ka n mira koɲuma, wo tii ra n kelayaba mira koɲuma. ");
INSERT INTO msc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ni mɔɔ mɛn ka nabi do ramira koɲuma ka a masɔrɔn nabi le, nabi ye barayi mɛn sɔrɔnna, wo tii fanan di wo ɲɔɔn sɔrɔn. Ni mɔɔ mɛn ka mɔɔ telenni do ramira koɲuma ka a masɔrɔn mɔɔ telenni le, mɔɔ telenni ye barayi mɛn sɔrɔnna, wo tii fanan di wo ɲɔɔn sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","N di tuɲa fɔ ai yɛ: ni mɔɔ mɛn ka hali ji suma jilafɛ ɲa kelen di n na mɔɔ dɔɔmani do ma ka a masɔrɔn n na karanden de, wo tii tɛ bɔnɔ barayi wo rɔ. Sika tɛ wo rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nba, Isa banda lalilikan woilu fɔla a la karanden tan ni fila yɛ tuma mɛn na, a bɔra ye ka wa Yahudiya la soilu kɔndɔ ka mɔɔilu karan, ka ii kawandi. ");
INSERT INTO msc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Awa, ka Yaya to kaso la, Ɲenematɔmɔnin na kɛwaliilu fɔra a ɲana. Wo rɔ, a ka a la karanden doilu kelaya Isa ma. ");
INSERT INTO msc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ii wara Isa maɲininka ko: «Alla kɛtɔ mɔɔ mɛn nanala, wo ye ile le ri wa, wa an ye mɔɔ gbɛrɛ makɔnɔ?» ");
INSERT INTO msc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isa ka ii jabi: «Ai ye mɛnilu mɛnna, a ni ai ye mɛnilu yenna, ai ye wa woilu fɔ Yaya yɛ. ");
INSERT INTO msc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ko ɲa fuyenilu ɲa ra laka, nambarailu ra taama koɲuma, kunatɔilu ra kɛndɛya, tologbedenilu tolo ra laka, suilu ra wuli ka bɔ saya rɔ, kibaro ɲuma ra lase bolokolonilu ma. ");
INSERT INTO msc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sɛwa ye wo tii yɛ mɛn tɛ bilala fili rɔ n na ko rɔ!» ");
INSERT INTO msc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yaya la keladenilu watɔla, Isa kumara jama yɛ Yaya la ko rɔ. A ka a fɔ ko: «Ai wara nfen dagbɛ diya wula kɔndɔ? Ai ka bin gbansan de ragbɛ wa, fɔɲɔ ye mɛn namaala? Wo kuma tɛ! ");
INSERT INTO msc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ai wara nfen dagbɛ diya wo rɔ? Faanin dagbɛlɛn tii wa? Wo kuma tɛ. Mɛnilu ye faanin dagbɛlɛn donna, woilu ye sɔrɔnna mansabolon kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ai wara nfen dagbɛ diya? Ii ma wa nabi do ragbɛ wa? N di a fɔ ai yɛ ko nabi le tɛrɛ. Kɔni ale ka bon nabi ri paaɔn! ");
INSERT INTO msc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A la ko sɛbɛni Alla la kitabu kɔndɔ ko: ‹A ragbɛ, n di n na keladen nawa i ɲɛrɔ. Wo ri i la sila rabɛn i yɛ.› ");
INSERT INTO msc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«N di tuɲa fɔ ai yɛ: muso si ma den sɔrɔn fɔlɔ mɛn ka bon Yaya ri. Wo bɛɛ ni a ta, mɛn ka doo a tɔ bɛɛ ri Harijeene Mansaya rɔ, wo tii ka bon Yaya ri. ");
INSERT INTO msc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ka bɔ Yaya la kawandili kɛ waati ma haan ka na se bi ma, mɔɔilu ye Harijeene Mansaya kɛlɛla fanka la. Mɔɔ fadinmailu ye a ɲininna ka a mira, ");
INSERT INTO msc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","baa sani Yaya ye nala, nabiilu bɛɛ ni Musa la sariya ka Harijeene Mansaya ko fɔ. ");
INSERT INTO msc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni ai sɔnda ka la a la, Nabi Eli tɔɔ mɛn ko fɔra ko a ri na ikɔ, Yaya le wo ri. ");
INSERT INTO msc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tolo ye mɛn ma, wo tii ye a tolo malɔ kuma wo la. ");
INSERT INTO msc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«N ye bi mɔɔilu lala nfen ma? Ii bɔni denninilu la, mɛnilu siini lɔfɛ rɔ. Ii ye a fɔla ii duɲɔɔnilu yɛ ko: ");
INSERT INTO msc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹A ragbɛ. An ka fule fɔ ai yɛ, kɔni ai ma sɔn ka dɔn kɛ. An ka saya donkili la ai yɛ, kɔni ai ma kasi.› ");
INSERT INTO msc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«Baa Yaya nara, a ma dɔɔnnin kɛ, a ma minnin kɛ. Wo rɔ, mɔɔilu ka a fɔ ko jinatɔ le a ri. ");
INSERT INTO msc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mɔɔ Dencɛ fanan nara. A ye dɔɔnnin kɛla, a ye minnin kɛla. Wo rɔ, ai ka a fɔ ko wo ye noma ni dolominna le ri. Ko a ka a duɲɔɔnilu kɛ niisankɔmiralailu ni kojuukɛlailu le ri. Kɔni famunyali ri jo sɔrɔn a kɛwaliilu fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wo kɔ rɔ, Isa tun ka kabannako siyaman kɛ so mɛnilu kɔndɔ, a wulira wo mɔɔilu jalakila, baa ii tun ma tubi. ");
INSERT INTO msc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Isa ka a fɔ ikɔ ko: «Korasɛnkailu, gbalo ye ai yɛ. Bɛtisayidakailu, gbalo ye ai fanan yɛ. Kabannako ba mɛnilu kɛra ai rɔ, ni woilu tun kɛra Tiri so kɔndɔ, wala Sidɔn so kɔndɔ, ye mɔɔilu tun di kojuu kɛ boloka kɛbi waati jan. Ii tun di buurigbɛ kɛ ii kun dɔ, ka kasanbɔrɔ faanin bila ii kan na, ii la tubi tɔɔmasere ri. ");
INSERT INTO msc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wo le kosɔn, n di a fɔ ai yɛ ko kiti lon wa se, ai la kiti ri gbɛlɛya ka tamin Tirikailu ni Sidɔnkailu ta kan. ");
INSERT INTO msc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapɛrinahumukailu, ai don? Ai ri bonya haan ka se sankolo rɔ wa? Wo kuma tɛ! Ai ri jii fɔɔ ka se jahanama kɔndɔ! Baa kabannako mɛnilu kɛra ai tɛma, ni woilu tun kɛra Sɔdɔmu so kɔndɔ, Sɔdɔmu so tun di tɛrɛn ye haan bi. ");
INSERT INTO msc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wo le kosɔn, n di a fɔ ai yɛ ko kiti lon wa se, ai la kiti ri gbɛlɛya ka tamin Sɔdɔmukailu ta kan.» ");
INSERT INTO msc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Wo tuma, Isa ka a fɔ ko: «N Fa Alla, sankolo ni duukolo Maari, n ye baraka bilala i yɛ, i ka lɔnnin yiraka denninilu la, i ka wo doon mɔɔ famunyanilu ni hankilimailu ma. ");
INSERT INTO msc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɔɔn, n Fa. A diyara i yɛ ka wo kɛ. ");
INSERT INTO msc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«N Fa Alla ra fen bɛɛ karifa n na a la ko rɔ. Mɔɔ si ma Fa Alla Dencɛ lɔn bɛrɛbɛrɛ kɛ fɔɔ Fa Alla. Mɔɔ si fanan ma Fa Alla lɔn bɛrɛbɛrɛ kɛ fɔɔ a Dencɛ. Dencɛ wo wa a Fa yiraka mɛnilu la, woilu fanan di se a lɔnna. ");
INSERT INTO msc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ai mɛnilu sɛɛni ai la donin ba kɔrɔ, ai ye na n ma. N di lafɔɲɔ di ai ma. ");
INSERT INTO msc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ai ye n na donin ta gbeleke ta, ka n na karan mira, nde n jɛrɛ majiini, ai ri niilafɔɲɔ sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ka a masɔrɔn, n na donin ta gbeleke tɛ gbiliya, n na donin de fɛya.» ");
INSERT INTO msc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A ma mɛn ba kɛ wo kɔ, Isa ni a la karandenilu tɛrɛ ye taminna sɛnɛ do tɛma Ɲɔɲɔ lon do rɔ. Kɔnkɔ tɛrɛ ye karandenilu la. Wo rɔ, ii ka sɛnɛsuman ɲɔrɔn doilu kadi ka woilu ɲuun. ");
INSERT INTO msc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisi doilu ka wo yen tuma mɛn na, ii ka a fɔ Isa yɛ ko: «A ragbɛ, i la karandenilu ye ko mɛn kɛla ten Ɲɔɲɔ lon, wo dahani tɛ!» ");
INSERT INTO msc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Isa ka ii jabi: «A ye di? Mansa Dawuda ka mɛn kɛ kɔrɔman, ai ma wo karan wa? Kɔnkɔ tɛrɛ ye a ni a taamaɲɔɔnilu la. ");
INSERT INTO msc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wo rɔ, Dawuda donda Alla la bon kɔndɔ ka buru dɔɔn, buru mɛn bilani Alla yɛ ye. Kɔni ka a bɛn sariya ma, a ni a taamaɲɔɔnilu tun ma kan ka buru wo dɔɔn fɔɔ sarakalaselailu kelen. ");
INSERT INTO msc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ai ma a karan Musa la sariya rɔ ko sarakalaselailu ye baara kɛla Allabatobonba kɔndɔ Ɲɔɲɔ lon wa? Ii ye Ɲɔɲɔ lon sariya tiɲanna ten, kɔni wo tɛ jatela kojuu ri. ");
INSERT INTO msc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N di a fɔ ai yɛ ko do ye yan, mɛn ka bon Allabatobonba di. ");
INSERT INTO msc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Alla ye a fɔla a la kitabu kɔndɔ ko: ‹N ye a fɛ mɔɔ ye hina mɔɔ la. Wo duman n yɛ ka tamin saraka bɔ kan.› Ni ai tun ka kuma wo kɔrɔ lɔn, ai tun tɛ kiti labe mɔɔilu kan, mɛnilu ma kojuu kɛ, ");
INSERT INTO msc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","baa Mɔɔ Dencɛ le ye Ɲɔɲɔ lon tii ri.» ");
INSERT INTO msc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A bɔra ye ka wa wo mɔɔilu la salibon na. ");
INSERT INTO msc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wo ka a tɛrɛn cɛɛ bolofaani do ye ye. Mɔɔ doilu ka Isa maɲininka ko: «Ka mɔɔ lakɛndɛya Ɲɔɲɔ lon, wo dahani wa?» Baa ii tɛrɛ ye fɛrɛ ɲininna a ma. ");
INSERT INTO msc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isa ka a fɔ ii yɛ ko: «Ni saa kelen pe ye ai rɔ do bolo don? Ni saa wo bera denka kɔndɔ Ɲɔɲɔ lon, a tii tɛ a labɔ wa? ");
INSERT INTO msc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mɔɔ ka fisa saa ri paaɔn, wa di? Wo le rɔ, ka koɲuma kɛ mɔɔ yɛ Ɲɔɲɔ lon, wo le dahani.» ");
INSERT INTO msc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Isa ka ii jabi ten mɛn kɛ, a ka a fɔ cɛɛ bolosani yɛ ko: «I bolo rasɔmɔn.» Cɛɛ ka a bolo rasɔmɔn mɛn kɛ, a bolo kɛndɛyara fewu ka kɛ ikomin a bolo tɔ kelen. ");
INSERT INTO msc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisilu bɔra ka wa i ɲɔɔn yen ka Isa faa ɲa ɲinin. ");
INSERT INTO msc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ii tɛrɛ ye mɛn kan, Isa ka wo lɔn. Wo rɔ, a bɔra ye ka wa. Jama ba bilara a kɔ. A ka bɛɛ lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kɔni a ka a fɔ woilu yɛ ka a magbɛlɛya ko ii kana a la ko fɔ mɔɔ si yɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A ka wo kɛ le kosa Alla la kuma ri kanbali, a ka mɛn don Nabi Esayi da rɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«N na baaraden le ten, n ka mɛn suwandi. A duman n yɛ kosɛbɛ, n ye niisɔndiyala a la ko rɔ. N di n Nii Sɛniman lana a fɛ, a ri kiti ko fɔ siya tɔilu yɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A tɛna sɔsɔli kɛla, a tɛna pɛrɛnna. Mɔɔilu tɛna a kan mɛnna sila kan. ");
INSERT INTO msc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A tɛna gbala jaran dakadila, hali mɛn da ratiɲan. A tɛna fitinna lasala, hali mɛn ta ye sala, haan telen ye kunnafulen sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Siyailu bɛɛ ri ii jii la ale kan.» ");
INSERT INTO msc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wo kɔ rɔ, ii nara jinatɔ do ri Isa ma. Jina tun ka a ɲa fuyen ka a kɛ bobo ri. Isa ka a lakɛndɛya. Jinatɔ kumara, a ɲa lakara. ");
INSERT INTO msc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɔɔilu bɛɛ kabannakoyara. Ii ka a fɔ ko: «Mɛn di kili ko Mansa Dawuda dencɛ, ale le ɲin di wa?» ");
INSERT INTO msc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisilu ka wo mɛn tuma mɛn na, ii ka a fɔ ko: «Jinailu la kuntiiba Ibulusa le ye se dila cɛɛ ɲin ma ka jinailu gbɛn ka bɔ mɔɔilu fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kɔni Isa ka ii la miriya lɔn. Wo rɔ, a ka a fɔ ii yɛ ko: «Mansaya mɛn mɔɔilu wa wuli ka i ɲɔɔn kɛlɛ, mansaya wo ri tiɲan fewu. So kelen mɔɔilu, wala denbaya kelen mɔɔilu, wa wuli ka i ɲɔɔn kɛlɛ, so wo tɛ mɛn, bon wo fanan tɛ mɛn. ");
INSERT INTO msc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wo ɲa kelen ma, ni Setana ye Setana gbɛnna, a ye a jɛrɛ kɛlɛla. A la mansaya ri mɛn wo rɔ di? ");
INSERT INTO msc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A ye di? Ni n ye jinailu gbɛnna Ibulusa baraka rɔ, ai la karandenilu ye jinailu gbɛnna yon baraka rɔ? Ai la karandenilu ri ai la kiti tɛɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kɔni ni n ye jinailu gbɛnna Alla Nii Sɛniman baraka le rɔ, wo ra a yiraka ko Alla la Mansaya ra se ai tɛma. ");
INSERT INTO msc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mɔɔ ti se donna cɛɛ fankama la bon kɔndɔ ka wo bolofenilu sonya ni a ma cɛɛ fankama wo mira fɔlɔ ka a sidi, wa di? A wa a sidi, a ri a bolofenilu sonya. ");
INSERT INTO msc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Nba, mɔɔ mɛn tɛ n fɛ, wo ye n juu le ri. Mɔɔ mɛn tɛ n dɛmɛnna ka mɔɔilu ladɛn, wo ye baarala ka mɔɔilu lajɛnsɛn. ");
INSERT INTO msc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wo le kosɔn n di fɔ ai yɛ: mɔɔilu la kojuuilu bɛɛ ni Alla tanama kumailu bɛɛ ri se makotola. Kɔni ni mɔɔ mɔɔ ka Nii Sɛniman tanama ko kɛ, Alla tɛna wo tii makotola fewu. ");
INSERT INTO msc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ni mɔɔ ka Mɔɔ Dencɛ mafɔ, a ri se makotola. Kɔni ni mɔɔ ka Nii Sɛniman mafɔ, a tɛ makoto dunuɲa ɲin dɔ yan, a tɛ makoto sini natɔ fanan. ");
INSERT INTO msc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Jiri mɛn ka ɲi, wo den ka ɲi. Jiri mɛn ma ɲi, wo den ma ɲi. Jiri ye lɔnna a den de fɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ai fɔnfɔnni munuɲailu! Ai ma ɲi. Ai ri se kuma ɲuma fɔla wo rɔ di? Mɔɔ jusukun fani mɛn na, a da ye wo le fɔla. ");
INSERT INTO msc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mɔɔ ɲuma ri koɲuma kɛ, baa wo ye bɔla a ɲuma yɔrɔ lakandannin rɔ. Kɔni mɔɔ mɛn ma ɲi, wo ri kojuu kɛ, baa wo ye bɔla a juu yɔrɔ lakandannin rɔ. ");
INSERT INTO msc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","N di a fɔ ai yɛ ko Alla la kiti tɛɛ lon wa se, mɔɔilu ka kuma ɲatɔnɔntan mɛnilu fɔ ii da rɔ, ii ri woilu bɛɛ fɔkun fɔ Alla yɛ, ");
INSERT INTO msc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","baa i la kumailu ri kɛ sababu ri, Alla ri jɔ di i ma, wala a ri kiti labe i kan.» ");
INSERT INTO msc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wo kɔ rɔ, Farisi doilu ni sariya karanmɔɔ doilu ka a fɔ a yɛ ko: «An na karanmɔɔ, an ye a fɛ i ye tɔɔmasere kabannakoma do kɛ an ɲana, ka a yiraka ko Alla ye i fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Isa ka ii jabi: «Bi mɔɔilu kɛwaliilu juuman. Ii tɛ sɔnna ka to Alla kɔ. Ii ye a fɛ ka tɔɔmasere kabannakoma yen, kɔni tɔɔmasere si tɛ yiraka ii la ni Nabi Junusa ta tɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Baa Nabi Junusa ka tele sawa ni su sawa kɛ jɛɛ ba kɔndɔ ɲa mɛn ma, Mɔɔ Dencɛ fanan di tele sawa ni su sawa kɛ duu kɔrɔ wo ɲa ma. ");
INSERT INTO msc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Alla wa mɔɔilu la kiti tɛɛ lon mɛn, Ninibekailu ri wuli ka sɔn la bi mɔɔilu la, baa Nabi Junusa ka woilu kawandi tuma mɛn na, ii ka tubi ka na Alla ma. Sisen, mɔɔ do ye yan, mɛn ka bon Nabi Junusa ri. ");
INSERT INTO msc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Alla wa mɔɔilu la kiti tɛɛ lon mɛn, Seba jamana mansa muso ri wuli ka sɔn la bi mɔɔilu la, baa a bɔra fɔɔ dunuɲa kun do la ka na a tolo malɔ mansa Sulemani la famunyali kumailu la. Sisen, mɔɔ do ye yan, mɛn ka bon mansa Sulemani ri. ");
INSERT INTO msc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Jina wa gbɛn ka bɔ cɛɛ do rɔ, a ri yɔrɔ jaranilu taamataama wula kɔndɔ ka ɲɔɲɔ diya ɲinin. Kɔni a ri kaɲa. ");
INSERT INTO msc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Wo kɔ rɔ, a ri a fɔ ko: ‹N di n kɔsɛ ka wa n bɔ diya rɔ.› A wa se ye, a ri a tɛrɛn ko yɔrɔ wo rakolon de, ka sɛninya ikomin bon mɛn da firan ka a kɔndɔ rabɛn. ");
INSERT INTO msc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Wo rɔ, jina ri wa ka jina wɔrɔnwula ladɛn, mɛnilu ka juu a jɛrɛ ri. A ni woilu bɛɛ ri na ka don yɔrɔ wo rɔ ka ii sii ye. A laban, jinatɔ la ko ri juuya ka tamin a fɔlɔman na. Bi mɔɔ juuilu ta ye kɛla wo ɲa le ma.» ");
INSERT INTO msc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nba, ka Isa to kumala jama yɛ, a na a ni a dɔɔcɛilu nara ii lɔ kɛnɛ ma, ko ii ye a fɛ ka kuma a yɛ. ");
INSERT INTO msc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mɔɔ do ka a fɔ Isa yɛ ko: «I na ni i dɔɔcɛilu lɔni kɛnɛ ma. Ii ye a fɛ ka kuma i yɛ.» ");
INSERT INTO msc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Isa ka mɔɔ wo jabi: «Yon ye n na ri? N dɔɔcɛilu ye yon ni yon di?» ");
INSERT INTO msc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A ka a bolo lɔ a la karandenilu la. A ka a fɔ ko: «Mɔɔ ɲinilu le n na ni n dɔɔcɛilu ri, ");
INSERT INTO msc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","baa mɔɔ mɛnilu ye n Fa sawo kɛla, n Fa mɛn ye sankolo rɔ kɔnin, woilu le ye n dɔɔcɛilu ri, a ni n dɔɔmusoilu ni n nailu.» ");
INSERT INTO msc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wo lon kelen, Isa bɔra bon na ka wa a sii dala da la. ");
INSERT INTO msc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jama ba ka ii ladɛn a laminin dɔ. Wo rɔ, a donda kulun do kɔndɔ ka a sii. Jama bɛɛ lɔni tora gbere ma ye. ");
INSERT INTO msc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A ka ko siyaman fɔ ii yɛ kuma kɔrɔlamailu rɔ. A ka a fɔ ko: «Ai tolo malɔ. Sifoyila do bɔra ka wa si foyi diya sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ka a to si foyila, si doilu bera sila dala. Kɔnɔilu nara woilu ta ta. ");
INSERT INTO msc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Si doilu bera farama yɔrɔ kan, banku ma siya yɔrɔ mɛn. Si woilu fɛrɛnda jona, baa banku ma siya ye. ");
INSERT INTO msc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tele bɔra kosɛbɛ tuma mɛn na, ii mɔrɔnmɔrɔnda. Ii jara, baa ii luluilu ma don duu rɔ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Si doilu bera bin wɔninma yɔrɔ rɔ. Sumanilu wulira mɛn kɛ, wɔninilu fanan wulira ka ii dɔɔn. ");
INSERT INTO msc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nba, si doilu fanan bera duu duman dɔ. Suman woilu sɔnda kosɛbɛ. Si doilu ka ii ɲɔɔn kɛmɛ kɛ, doilu ka ii ɲɔɔn biwɔɔrɔ kɛ, doilu ka ii ɲɔɔn bisawa kɛ. ");
INSERT INTO msc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tolo ye mɛn ma, wo tii ye a tolo malɔ kuma wo la.» ");
INSERT INTO msc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Karandenilu ka ii madon Isa la ka a maɲininka ko: «Nfenna i ye kumala mɔɔilu yɛ kuma kɔrɔlamailu rɔ?» ");
INSERT INTO msc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A ka a fɔ ii yɛ ko: «Harijeene Mansaya ko mɛnilu doonni tɛrɛ, woilu lɔnnin da di ai le ma. Kɔni wo ma di ii ma, ");
INSERT INTO msc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","baa fen ye mɛn bolo, do ri la wo tii ta kan. A ta ri siyaya. Kɔni fen tɛ mɛn bolo, hali fitini mɛn ye a bolo, wo ri mira a la. ");
INSERT INTO msc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wo le kosɔn, n ye kumala ii yɛ kuma kɔrɔlamailu rɔ, baa ii ye ragbɛli kɛla, kɔni ii tɛ foyi yenna. Ii ye ii tolo malɔla, kɔni ii tɛ foyi mɛnna, ii tɛ foyi famunna. ");
INSERT INTO msc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wo rɔ, ii ka a kɛ, Nabi Esayi ka mɛn fɔ, wo ra kanbali. A ka a fɔ ko: ‹Ai ri ai tolo malɔ kosɛbɛ, kɔni ai tɛna foyi famunna. Ai ri ragbɛli kɛ kosɛbɛ, kɔni ai tɛna foyi yenna. ");
INSERT INTO msc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Baa siya ɲin da ii ban famunyali ma. Ii ra ii tolo gbɛdɛn ka ii ɲa masidi. Ni wo tɛ, ii ɲa tun di yenni kɛ, ii tolo tun di mɛnni kɛ, ii hankili tun di famunyali sɔrɔn, ii tun di ii kɔsɛ ka na nde Alla ma. Wo rɔ, n tun di ii kisi.›» ");
INSERT INTO msc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Kɔni ai ye barakadenilu le ri, baa ai ɲa ye yenni kɛla, ai tolo fanan ye mɛnni kɛla. ");
INSERT INTO msc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","N di tuɲa fɔ ai yɛ: ai ɲa ye mɛn yenna, a lɔɔ tɛrɛ ye nabi siyaman ni mɔɔ telenni siyaman na ka wo yen, kɔni ii ma fɛrɛ sɔrɔn ka ii ɲa la wo kan. Ai tolo ye mɛn namɛnna, a lɔɔ tɛrɛ ye ii la ka wo mɛn, kɔni ii ma fɛrɛ sɔrɔn ka ii tolo malɔ a la.» ");
INSERT INTO msc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Isa ka a fɔ ko: «Ai tolo malɔ, ai ri sifoyila kuma kɔrɔlama lamɛn. ");
INSERT INTO msc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mɛnilu wa Harijeene Mansaya kuma lamɛn, kɔni ii tɛ a famun, Ko Juu Tii nala wo rɔ, ka a bɔ ii jusu rɔ. Woilu kɛni le ikomin si mɛnilu bila sila kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Si mɛn bera farama yɔrɔ kan, wo ye mɔɔilu le ri mɛn da Alla la kuma lamɛn, ka a mira i kɔrɔ ka sɛwa. ");
INSERT INTO msc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kɔni lulu ti ye, a ni kuma wo ma sabati ii jusukun dɔ bɛrɛ bɛrɛ kɛ. Ii tɛ mɛn ba kɛ lemɛniya sila kan, baa ni gbɛlɛya ka ii sɔrɔn, wala ni mɔɔilu ka ii tɔrɔ Alla la kuma kosɔn, ii ri sila bila i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Si mɛn bera bin wɔninma yɔrɔ rɔ, wo le mɔɔilu mɛn ka Alla la kuma lamɛn, kɔni dunuɲa koilu hamin da don ii jusukun dɔ. Nanfulu lɔɔ ri ii mira ka ii magbɛrɛnkɛ. Ko woilu bɛɛ kosɔn, Alla la kuma ri mabali ii jusukun dɔ, ka kɛ ikomin sɛnɛfen ɲatɔntan, mɛn ma den. ");
INSERT INTO msc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nba, si mɛn bera duu duman dɔ, wo le mɔɔ ri mɛn ye Alla la kuma mɛnna ka a famun. Kuma wo ri sabati a jusukun dɔ, ka kɛ ikomin suman si mɛn ye ɲala ka i ɲɔɔn kɛmɛ kɛ, wala i ɲɔɔn biwɔɔrɔ, wala i ɲɔɔn bisawa.» ");
INSERT INTO msc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Isa ka kuma kɔrɔlama gbɛrɛ fɔ ii yɛ. A ka a fɔ ko: «Harijeene Mansaya ye ikomin cɛɛ do la ko. A ka suman si ɲuma foyi a la sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kɔni, ka mɔɔilu bɛɛ to sunɔɔ rɔ su rɔ, a juu nara bin juu do kisɛ foyi sumanfɛ wo rɔ, ka wa. ");
INSERT INTO msc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nba, suman fɛrɛnda ka wuli, ka a den. Wo tuma, mɔɔilu ka bin juuilu fanan yen. ");
INSERT INTO msc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sɛnɛtii la jɔnilu wara a fɔ a yɛ ko: ‹An tii, i ma suman si ɲuma foyi i la sɛnɛ rɔ wa? Bin juu woilu bɔni mi ten?› ");
INSERT INTO msc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sɛnɛtii ka a fɔ ko: ‹N juu do nɔ le.› Ii ka a maɲininka ko: ‹I ye a fɛ an ye wa binilu bɔ sumanfɛ wo rɔ wa?› ");
INSERT INTO msc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A ka a fɔ ko: ‹Ɛɛn, ai ye a to ye. Ni wo tɛ, ni ai ka binilu bɔ, ai ri suman doilu fanan bɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ai ye ii bɛɛ to ye. Ii ye wuli i ɲɔɔn fɛ fɔɔ sumanka waati wa se. Ni sumanka waati sera, n di a fɔ sumankalailu yɛ ko ii ye bin juuilu fɔlɔ bɔ, ka ii lasidi, ka ii janin. Wo wa kɛ, ii ri suman ka ka a ladon n na bondon kɔndɔ.›» ");
INSERT INTO msc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Isa ka kuma kɔrɔlama gbɛrɛ fɔ mɔɔilu yɛ. A ka a fɔ ko: «Harijeene Mansaya ye ikomin bɔrɔn fira kisɛ. Cɛɛ do ka bɔrɔn fira kisɛ lan a la sɛnɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kisɛ wo dɔɔman ka tamin kisɛilu bɛɛ kan. Kɔni a wa fɛrɛn ka wuli, a ri bonya ka tamin nakofen bɛɛ kan. A ri kɛ ikomin jiri, ka bolon bailu labɔ, fɔɔ waa rɔ kɔnɔilu ri se ii ɲaanilu lala a bolonilu la.» ");
INSERT INTO msc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A ka kuma kɔrɔlama gbɛrɛ fɔ ii yɛ. A ka a fɔ ko: «Harijeene Mansaya ye ikomin lɛbɛn, muso ka mɛn dɔɔni kɛ farinin muun kilo muwan ni kelen dɔ ka wo kɛ dɛɛba ri. Lɛbɛn wo ka dɛɛba bɛɛ lawuli ka a funun.» ");
INSERT INTO msc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isa ka wo bɛɛ fɔ jamailu yɛ kuma kɔrɔlamailu le rɔ. A ma foyi fɔ ii yɛ ni a ma wo fɔ kuma kɔrɔlama rɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A ka a kɛ ten sa nabi la kuma ri kanbali, mɛn ka a fɔ ko: «N di kuma kuma kɔrɔlamailu le rɔ. Ko mɛnilu doonni kɛbi dunuɲa dan waati la, n di woilu fɔ.» ");
INSERT INTO msc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wo kɔ rɔ, Isa bɔra jama fɛ ka wa don bon na. A la karandenilu ka ii madon a la, ka a fɔ a yɛ ko: «Kuma kɔrɔlama mɛn ye bin juu wuli ko fɔla sɛnɛ rɔ, i ye wo kɔrɔ fɔ an yɛ.» ");
INSERT INTO msc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isa ka ii jabi: «Mɛn ye suman si ɲuma foyila, wo ye Mɔɔ Dencɛ ri. ");
INSERT INTO msc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sɛnɛ wo le ye dunuɲa ri. Suman si ɲuma, wo ye mansaya denilu ri. Bin juuilu ye Kojuu Tii la mɔɔilu le ri. ");
INSERT INTO msc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Juu mɛn ka bin juu kisɛilu foyi sɛnɛ rɔ, wo le Ibulusa jɛrɛ ri. Sumanka waati, wo le ye dunuɲa laban di. Sumankalailu ye mɛlɛkailu ri. ");
INSERT INTO msc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bin juuilu ye ladɛnna ɲa mɛn ma ka janin ta la, wo ɲɔɔn di kɛ dunuɲa laban waati. ");
INSERT INTO msc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mɔɔ Dencɛ ri a la mɛlɛkailu kelaya ka na. Mɛnilu ye mɔɔilu bilala kojuu kɛ rɔ, a ni mɛnilu ye kojuu kɛla, a la mɛlɛkailu ri woilu bɛɛ ladɛn ka ii bɔ Mɔɔ Dencɛ la Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mɛlɛkailu ri woilu lafili ta ba rɔ, kasi ni a ɲin macin ye yɔrɔ mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɔni mɔɔ telenniilu ri bonya sɔrɔn ka mɛlɛnmɛlɛn ikomin tele ii Fa la mansaya rɔ. Tolo ye mɛn ma, wo tii ye a tolo malɔ kuma wo la.» ");
INSERT INTO msc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Isa kan ikɔ ko: «Harijeene Mansaya ye ikomin nanfulu mɛn doonni duukolo kɔrɔ sɛnɛ do rɔ. Lon do rɔ, cɛɛ do ka wo yen. A ka a ta ka a dokon duukolo kɔrɔ kokura. A sɛwani ba wara a bolofenilu bɛɛ majira, ka na sɛnɛ wo san. ");
INSERT INTO msc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Harijeene Mansaya ye ikomin julacɛ mɛn ye koronkisɛ ɲumailu ɲininna. ");
INSERT INTO msc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lon do rɔ, a ka koron kisɛ ɲuma do yen, mɛn ka ɲi ka tamin. A wara a bolofenilu bɛɛ majira, ka na koron kisɛ wo san. ");
INSERT INTO msc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Harijeene Mansaya ye ikomin jɔɔ fanan, mɔɔilu ka mɛn fili kɔɔji rɔ, ka jɛɛ su bɛɛ mira. ");
INSERT INTO msc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A wa fa jɛɛ la, jɛɛmiralailu ri a sɔmɔn ka a labɔ gbere ma. Ii ri ii sii ka jɛɛilu rawoloma. Mɛnilu ka ɲi, ii ri woilu bila muranilu kɔndɔ. Mɛnilu ma ɲi, ii ri woilu lafili. ");
INSERT INTO msc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","A ri kɛ wo ɲa le dunuɲa laban waati. Mɛlɛkailu ri mɔɔ juuilu rawoloma ka ii bɔ mɔɔ telenniilu rɔ, ");
INSERT INTO msc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ka ii lafili ta ba rɔ, kasi ni a ɲin macin ye yɔrɔ mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isa ka karandenilu maɲininka ko: «Ai ka kuma ɲin bɛɛ famun wa?» Ii ka a fɔ ko: «Ɔɔn.» ");
INSERT INTO msc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wo rɔ, Isa ka a fɔ ii yɛ ko: «Nba, sariya karanmɔɔ mɛnilu ra karan Harijeene Mansaya ko rɔ, woilu bɛɛ ye ikomin lutii mɛn ye fen kura ni fen kɔrɔ fila bɛɛ labɔla a la nanfulu lamara diya rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nba, Isa banni kuma kɔrɔlama wo fɔla, a bɔra yɔrɔ wo rɔ ka wa. ");
INSERT INTO msc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A wara a wara so. A tɛrɛ ye mɔɔilu karanna salibon kɔndɔ ye. A lamɛnbailu kabannakoyara, ka a fɔ ko: «Cɛɛ ɲin ka famunyali wo sɔrɔn mi? Kabannako kɛ sebaya mɛn ye a bolo, a ka wo sɔrɔn mi? ");
INSERT INTO msc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jirisila dencɛ le tɛ wa? A na le tɛ Mariyamu ri wa? Yakuba ni Yusufu ni Simɔn ni Judi, a dɔɔcɛilu tɛ woilu ri wa? ");
INSERT INTO msc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A dɔɔmusoilu bɛɛ tɛ an wara yan wa? Nba, a ka famunyali ni sebaya ɲin sɔrɔn mi?» ");
INSERT INTO msc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Miriya wo le kɛra sababu ri ka ii bɛɛ kundatiɲan, ii ma la Isa la. Isa ka a fɔ ii yɛ ko: «Mɔɔilu ye nabi bonyala yɔrɔ bɛɛ rɔ fɔɔ a jɛrɛ wara, a ni a la denbayailu tɛma.» ");
INSERT INTO msc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Isa ma kabannako siyaman kɛ yɔrɔ wo rɔ ka a masɔrɔn mɔɔilu la lemɛniyabaliya fɛ. ");
INSERT INTO msc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nba, wo waati la, mansa Herodi ka Isa la ko mɛn. ");
INSERT INTO msc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A ka a fɔ a la baaradenilu yɛ ko: «Yaya le ɲin. A ra wuli ka bɔ saya rɔ. Wo le ka a kɛ, sebaya ye a bolo ka kabannakoilu kɛ.» ");
INSERT INTO msc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nba, mansa Herodi tun da Yaya mira ka a sidi ka a bila kaso la. A ka wo kɛ a kɔrɔcɛ Filipe muso le kosɔn, mɛn tɔɔ ko Herodiyasi, ");
INSERT INTO msc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","baa Yaya tora a fɔla a yɛ ko: «Muso wo ma kan ka sii i kun. Wo dahani tɛ!» ");
INSERT INTO msc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi tun ye a fɛ ka Yaya faa, kɔni a silanni tɛrɛ jama yɛ, baa jama tɛrɛ ye Yaya jatela nabi le ri. ");
INSERT INTO msc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodi sɔrɔnlon sankunbɛn kɛra lon mɛn, ii ka tolon kɛ. Herodiyasi denmuso ka dɔn kɛ mɔɔilu tɛma tolon diya ye. Wo diyara Herodi yɛ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wo rɔ, a ka a kali sunkurun yɛ ko a wa mɛn ɲinin a fɛ, a ri wo di a ma. ");
INSERT INTO msc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sunkurun na ka a fɔ a yɛ a ka kan ka mɛn ɲinin mansa fɛ. Wo rɔ, a wara a fɔ mansa yɛ ko: «N ye a fɛ i ye muran di n ma, Yaya kun ye mɛn kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuma wo ka mansa niilafin kosɛbɛ. Kɔni a tun da ban a kalila a la mɔɔ kiliniilu bɛɛ ɲana. Wo rɔ, a ka jamarili di a la mɔɔilu ma ko ii ye Yaya kun di a ma. ");
INSERT INTO msc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A ka mɔɔ lɔ Yaya kun tɛɛla a la kaso la. ");
INSERT INTO msc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A ka a kun tɛɛ a la ka a bila muran do kɔndɔ. A nara wo ri sunkurun ma. Sunkurun wara a di a na ma. ");
INSERT INTO msc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yaya la karandenilu nara a su ta ka wa a sutura. Ii wara wo kibaro lase Isa ma. ");
INSERT INTO msc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isa ka Yaya faa ko mɛn tuma mɛn na, a kelen donda kulun dɔ ka bɔ ye ka wa. A wara se yɔrɔ do ma, mɔɔ tun tɛ yɔrɔ mɛn. Mɔɔilu ka a wa ko mɛn tuma mɛn na, ii bɔra soilu kɔndɔ ka wa a kɔ ii sen na. ");
INSERT INTO msc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Isa bɔra kulun kɔndɔ tuma mɛn na, a ka jama ba yen. Ii kininkinin donda a la. Jankarɔto mɛnilu tɛrɛ ii rɔ, a ka woilu lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wura fɛ, a la karandenilu ka ii madon a la ka a fɔ a yɛ ko: «A ragbɛ, an ye wula le kɔndɔ yan. Su ra ko. I ye sila di jama ma sa ii ri wa dɔɔnninfen san diya yan naminin so mɛsɛnilu kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Isa ka ii jabi: «Ii mako tɛ wo la. Ai jɛrɛ ye dɔɔnnin di ii ma.» ");
INSERT INTO msc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Karandenilu ka a fɔ ko: «Foyi tɛ an bolo yan fɔɔ burukala loolu ni jɛɛ fila.» ");
INSERT INTO msc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Isa ka a fɔ ko: «Ai ye na woilu ri n ma yan.» ");
INSERT INTO msc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A ka a fɔ jama yɛ ko ii ye ii sii duu ma bin kɛndɛ kan. Wo kɔ rɔ, a ka burukala loolu ni jɛɛ fila ta, ka a ɲa layɛlɛ sankolo ma ka baraka bila Alla yɛ. A ka buru rakadikadi, ka a di a la karandenilu ma. Ii ka a ratala jama tɛma. ");
INSERT INTO msc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mɔɔ bɛɛ ka dɔɔnnin kɛ ka ii fa. Jama banni dɔɔnninna, Isa la karandenilu ka buru kunkundun tɔilu ladɛn, ka see tan ni fila lafa wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jama mɛn ka dɔɔnnin wo kɛ, cɛɛ waa loolu ɲɔɔn tɛrɛ ye a rɔ. Musoilu ni denilu ma jate. ");
INSERT INTO msc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wo kɔ rɔ, Isa ka a fɔ a la karandenilu yɛ i kɔrɔ ko ii ye don kulun kɔndɔ. Ko ii ye wa dala kɔma a ɲɛrɔ. Ko ale watɔ sila dila jama ma. ");
INSERT INTO msc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nba, a banni sila dila jama ma, Isa kelen wara Alla tara diya koyinkɛ do kan. Su kora ka a tɛrɛn a kelen ye ye fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wo tuma, karandenilu la kulun da janfa pon gbelemala la. Ji kuruilu tɛrɛ ye ii la kulun namaala. Fɔɲɔ tɛrɛ ye ii kunbɛnna. ");
INSERT INTO msc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dondon kasi waati ɲɔɔn, Isa ka a taama ji kan ka wa ii kɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɔni karandenilu ka a taamatɔla yen ji kan tuma mɛn na, silan ba ka ii mira. Ii ka a fɔ ko, «su kɔrɔ do jiya le!» Ii kulera, baa ii silanni. ");
INSERT INTO msc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kɔni Isa kumara ii yɛ i kɔrɔ. A ka a fɔ ko: «Ai ye ai jusulatɛɛ! Nde le. Ai kana silan!» ");
INSERT INTO msc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyɛri ka a fɔ ko: «Maari, ni ile le, i ye n jamari ko n ye taama ji kan ka wa i tɛrɛn ye.» ");
INSERT INTO msc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Isa ka a fɔ ko: «Na.» Piyɛri jiira ka bɔ kulun kɔndɔ ka taama ji kan ka wa Isa kɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kɔni Piyɛri ka a yen tuma mɛn na ko fɔɲɔ fanka ka bon kojuuya, a silanda ka jii damira ji kɔrɔ. A kulera ko: «Maari, i ye n kisi!» ");
INSERT INTO msc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isa ka a bolo rasɔmɔn i kɔrɔ ka Piyɛri mira. A ka a fɔ a yɛ ko: «Ile, mɛn na lemɛniya ka dɔɔ. Nfenna i ye sikasikala?» ");
INSERT INTO msc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Isa ni Piyɛri donda kulun kɔndɔ tuma mɛn na, fɔɲɔ ka a lɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Karanden mɛnilu tɛrɛ ye kulun kɔndɔ, woilu ka ii birin Isa kɔrɔ. Ii ka a fɔ ko: «Tuɲa le, ile le Alla Dencɛ ri.» ");
INSERT INTO msc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nba, ii ban mɛn kɛni dala tɛɛla, ii sera Kenesarɛti mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ye mɔɔilu ka a ɲayen tuma mɛn na ko Isa le, ii ka mɔɔilu lɔ a na ko fɔla mara fan bɛɛ rɔ. Wo rɔ, mɔɔilu nara ii la jankarɔtoilu bɛɛ ri Isa ma, ");
INSERT INTO msc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ka a madiya ko a ye diɲɛ ii ye ii bolo maa a la duruki dakun gbansan na. Mɔɔ mɔɔ ka a bolo maa a la, woilu bɛɛ kɛndɛyara. ");
INSERT INTO msc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wo kɔ rɔ, Farisi doilu ni sariya karanmɔɔ doilu bɔra Jerusalɛmu ka na Isa tɛrɛn. ");
INSERT INTO msc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ii ka a maɲininka ko: «Nfenna i la karandenilu ye an benbailu la landa tiɲanna? Ii ye dɔɔnnin kɛla ka a tɛrɛn ii ma ii bolo lako fɔlɔ.» ");
INSERT INTO msc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isa ka a fɔ ii yɛ ko: «Ai don? Nfenna ai ye ai la landailu bonyala ka Alla la sariya tiɲan? ");
INSERT INTO msc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Baa Alla ka a fɔ ko: ‹I ye i na ni i fa bonya.› Ko: ‹Ni mɔɔ mɛn ka a fa wala a na danka, wo tii ka kan ka faa le.› ");
INSERT INTO msc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kɔni ai ka a fɔ ko mɔɔ ri se a fɔla a fa wala a na yɛ ko: ‹I ka kan ka dɛmɛnfen mɛn sɔrɔn n bolo, n da wo bila a dan na Alla yɛ.› ");
INSERT INTO msc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ai ka a fɔ ko ni a ka a fɔ ten, a diyagboyani tɛ butun ka a fa bonya niilifen na. Wo rɔ, ai ra Alla la kuma to ye, ka ai la landailu bila a nɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ai jɛrɛmayuwailu, Nabi Esayi ka mɛn fɔ ai la ko rɔ fɔlɔfɔlɔ, wo bɛnni kosɛbɛ. A ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Mɔɔ ɲinilu ye n bonyala ii da le la, kɔni ii jusukun ma senin n na muumɛ! ");
INSERT INTO msc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ii ye n batola fuu. Ii ye mɔɔilu karanna mɛnilu la, woilu tɛ foyi ri fɔɔ adamadenilu la jamariliilu.›» ");
INSERT INTO msc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wo kɔ rɔ, Isa ka jama kili, ka a fɔ ii yɛ ko: «Ai bɛɛ ye ai tolo malɔ n na kuma la ka a famun. ");
INSERT INTO msc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mɔɔ ye fen fen donna a da rɔ ka a dɔɔn, wo si ti se mɔɔ nɔɔla. Kɔni mɛnilu ye bɔla mɔɔ da rɔ, wo le ye mɔɔ nɔɔla.» ");
INSERT INTO msc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A la karandenilu ka ii madon a la, ka a fɔ a yɛ ko: «I ma a lɔn ko i la kuma gbara Farisilu la wa?» ");
INSERT INTO msc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Isa ka a fɔ ko: «N Fa mɛn ye sankolo rɔ, ni wo jɛrɛ ma lannifen mɛn lan, woilu ri bɔ ka faa. ");
INSERT INTO msc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ai ye Farisilu to ye. Ii ye ɲa fuyenilu le ri, ii jɛrɛ le ye i ɲɔɔn na gbeleke mirabailu ri. Ni ɲa fuyen don ka ɲa fuyen do la gbeleke mira, ii fila bɛɛ ri be denka rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyɛri ka a fɔ Isa yɛ ko: «Kuma kɔrɔlama wo kɔrɔ fɔ an yɛ.» ");
INSERT INTO msc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isa ka a fɔ ko: «A ye di? Ai fanan ma se ko ɲayenna wa? ");
INSERT INTO msc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ai ma a ɲayen wa ko fen mɛn ye donna mɔɔ da rɔ, wo ye wala a kɔnɔ le rɔ? Mɔɔ wo wa wa kɔkan, fen wo ri bɔ. ");
INSERT INTO msc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kɔni kuma mɛnilu ye bɔla mɔɔ da rɔ, woilu ye bɔla a jusukun de rɔ. Woilu le ye mɔɔ nɔɔla, ");
INSERT INTO msc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","baa ko kɔrɔn mɛn ye bɔla mɔɔ jusukun dɔ, woilu le ɲin di: miriya juu, mɔɔfaa, kaninkɛla, jatɔya su bɛɛ, suɲali, sereya juu bɔ, a ni mɔɔ tɔɔ tiɲan. ");
INSERT INTO msc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ko woilu le ye mɔɔ nɔɔla. Kɔni ka dɔɔnnin kɛ bolo lakobali la, wo tɛ mɔɔ nɔɔla.» ");
INSERT INTO msc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wo kɔ rɔ, Isa bɔra yɔrɔ wo rɔ ka wa Tiri ni Sidɔn mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ye muso do nara Isa tɛrɛn. Kanaanka le tɛrɛ a ri. A tɛrɛ ye a kule kan nabɔla ko: «Maari, Dawuda dencɛ, i ye hina n na. Jina do ye n denmuso tɔrɔla kojuuya!» ");
INSERT INTO msc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kɔni Isa ma foyi fɔ. A la karandenilu ka ii madon a la, ka a madiya ko: «Muso ɲin gben, a bilani an kɔfɛ ka a kule kan nabɔ kojuuya.» ");
INSERT INTO msc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isa ka a fɔ ko: «Alla ma n kelaya mɔɔ gbɛrɛ si ma ni Isirayɛlikailu tɛ, woilu mɛnilu ye ikomin saa tununnilu.» ");
INSERT INTO msc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kɔni muso wo nara a be Isa sen kɔrɔ, ka a fɔ a yɛ ko: «Maari, i ye n dɛmɛn.» ");
INSERT INTO msc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isa ka a fɔ ko: «Ka denninilu la dɔɔnnin ta ka a lafili wuluilu kɔrɔ, wo ti bɛn.» ");
INSERT INTO msc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Muso ka a jabi: «Maari, tuɲa le wo ri. Kɔni wuluilu ye dɔɔnnin buruburu dɔɔnna, mɛn ye bela duu ma ii tiilu la tabali kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Isa ka a jabi: «Aa, muso. I la lemɛniya ka bon! I ka mɛn ɲinin, a ye kɛ i yɛ.» A denmuso kɛndɛyara wo waati kelen. ");
INSERT INTO msc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isa bɔra yɔrɔ wo rɔ, ka wa Kalile Dala da la. A yɛlɛra koyinkɛ do kan ka a sii ye. ");
INSERT INTO msc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jama ba nara a tɛrɛn. Ii nara nambarailu ri, a ni ɲa fuyenilu ni bolokelenilu ni boboilu ni jankarɔto siyaman gbɛrɛilu. Ii nara woilu bɛɛ ri, ka ii lala Isa kɔrɔ. A ka ii bɛɛ lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ii ka ii yen tuma mɛn na ko boboilu ra kuma damira, bolokelenilu ra kɛndɛya, nambarailu ra ii taama, a ni ɲafuyenilu ɲa ra laka; jama kabannakoyara. II bɛɛ ka Isirayɛlikailu la Maari Alla tando. ");
INSERT INTO msc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isa ka a la karandenilu kili, ka a fɔ ii yɛ ko: «Jama ɲin kininkinin ye n na. Ii ra tele sawa le kɛ n dafɛ yan. Dɔɔnnifen si tɛ ii bolo. N tɛ a fɛ ka sila di ii kɔnkɔtɔ ma ten. Ni wo tɛ, ii ri kirɔn ii la sila la.» ");
INSERT INTO msc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Karandenilu ka Isa jabi: «An di buru sɔrɔn mi wula kɔndɔ yan, mɛn di jama ba ɲin ɲɔɔn bɔ?» ");
INSERT INTO msc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isa ka a fɔ ii yɛ ko: «Burukala yɛli ye ai bolo?» Ii ka a fɔ ko: «Burukala wɔrɔnwula, a ni jɛɛ mɛsɛnni dando» ");
INSERT INTO msc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Isa ka a fɔ jama yɛ ko ii ye ii sii duu ma. ");
INSERT INTO msc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A ka burukala wɔrɔnwula ni jɛɛ woilu ta, ka baraka bila Alla yɛ, ka ii rakadikadi, ka ii di karandenilu ma. Karandenilu ka woilu ta ka ii ratalatala jama tɛma. ");
INSERT INTO msc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jama bɛɛ ka dɔɔnnin kɛ ka ii fa. Buru kunkundun ni jɛɛ tɔ mɛn toni, Isa la karandenilu ka see wɔrɔnwula lafa wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cɛɛ mɔɔ waa naanin ka dɔɔnnin kɛ. Musoilu ni denninilu ma jate. ");
INSERT INTO msc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A ka sila di jama ma, Isa donda kulun do kɔndɔ ka wa Makadan mara rɔ. ");
INSERT INTO msc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisilu ni Sadusiilu nara ka Isa kɔrɔbɔ. Ii ka a fɔ ko a ye tɔɔmasere kabannakoma do kɛ ii ɲana, mɛn bɔni sankolo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Isa ka a fɔ ko: «Ni ai ka sankolo ɲa wulenni yen fitiri waati, ai ri a fɔ ko sanci tɛna nala sini. ");
INSERT INTO msc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sɔɔma, ni ai ka sankolo ɲa finni yen, ai ri a fɔ ko sanci ri na bi, baa san da fin. Nba, ai kusan sankolo koilu faranfaasila ka woilu famun. A ye di wo rɔ? Tɔɔmasere mɛnilu ye kɛla waati ɲin na, nfenna ai ti se ka woilu famun? ");
INSERT INTO msc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mɔɔ juuilu ni lemɛniyabaliilu ye a fɛ ka tɔɔmasere kabannakoma yen, kɔni tɔɔmasere si tɛ yiraka ai la ni Nabi Junusa ta ɲɔɔn tɛ.» Wo kɔ rɔ, a ka ii to ye ka wa. ");
INSERT INTO msc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nba, Isa ni a la karandenilu wara dala kɔ. Kɔni karandenilu ɲinara, ii ma buru ta. ");
INSERT INTO msc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Isa ka a fɔ ii yɛ ko: «Ai ɲa lɔ. Ai ye ai janto ai jɛrɛ rɔ Farisilu ni Sadusiilu la lɛbɛn kanma.» ");
INSERT INTO msc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Karandenilu ka a fɔ i ɲɔɔn yɛ ko: «An ma na buru ri. Wo le ka a kɛ, a ka kuma wo fɔ.» ");
INSERT INTO msc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isa ka ii la miriya lɔn. Wo rɔ, a ka a fɔ ii yɛ ko: «Ai la lemɛniya ka dɔɔ! Nfenna ai ye a fɔla i ɲɔɔn yɛ ko buru tɛ ai bolo? ");
INSERT INTO msc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ai ma a ɲayen fɔlɔ wa? N ka burukala loolu ta ka cɛɛ waa loolu balo mɛn kɛ, a ni ai ka see jate mɛn nafa buru kunkundun tɔilu la, wo ra bɔ ai kɔndɔ wa? ");
INSERT INTO msc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","N ka burukala wɔrɔnwula ta ka cɛɛ waa naanin balo mɛn kɛ, a ni ai ka see jate mɛn nafa buru kunkundun tɔilu la, wo ra bɔ ai kɔndɔ wa? ");
INSERT INTO msc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","N kan tun tɛ buru ma. Nfenna ai ma wo ɲayen fɔlɔ? Nba, ai ye ai janto ai jɛrɛ rɔ Farisilu ni Sadusiilu la lɛbɛn kanma.» ");
INSERT INTO msc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wo rɔ, karandenilu ka a ɲayen ko Isa ma a fɔ ii yɛ ko «ai ye ai janto ai jɛrɛ rɔ buru lɛbɛn kanma.» A ka a fɔ ii yɛ ko «ai ye ai janto ai jɛrɛ rɔ Farisilu ni Sadusiilu la karan de kanma.» ");
INSERT INTO msc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Awa, Isa ni a la karandenilu seni Sesare Filipi mara rɔ, a ka ii maɲininka ko: «Mɔɔilu ye Mɔɔ Dencɛ jatela yon di?» ");
INSERT INTO msc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ii ka a jabi: «Doilu ka a fɔ ko Yaya le. Doilu ka a fɔ ko Nabi Eli le. Dogbɛrɛilu ka a fɔ ko Nabi Jeremiya le, wala nabi gbɛrɛ, mɛn taminda kɔrɔman.» ");
INSERT INTO msc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A ka ii maɲininka ko: «Ai don? Ai ye n jatela yon di?» ");
INSERT INTO msc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔn Piyɛri ka a fɔ ko: «I ye Ɲenematɔmɔnin de ri, mɛn ye Alla ɲenema Dencɛ ri.» ");
INSERT INTO msc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Isa ka a jabi: «Junusa dencɛ Simɔn, i ye barakaden de ri, baa i ka mɛn fɔ ɲin di, adamaden si ma wo fɔ i yɛ. N Fa Alla mɛn ye sankolo rɔ, wo le ka a yiraka i la. ");
INSERT INTO msc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","N di a fɔ i yɛ fanan ko ile le Piyɛri ri, mɛn kɔrɔ ye ko farakolo. N di n na lemɛniya jama lalɔ farakolo wo kan. Saya ni a fanka tɛna nɔ sɔrɔnna dɛkuru wo ma. ");
INSERT INTO msc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N di Harijeene Mansaya daɲinilu di i ma. Ni i ka fen fen sidi duukolo kan yan, wo ri sidi sankolo rɔ. Ni i ka fen fen fulɛn duukolo kan yan, wo ri fulɛn sankolo rɔ fanan.» ");
INSERT INTO msc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Isa ka a fɔ ii yɛ ka a magbɛlɛya kosɛbɛ ko ii kana a fɔ mɔɔ si yɛ ko ale le Ɲenematɔmɔnin di. ");
INSERT INTO msc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A ka a fɔ ii yɛ ko a ka kan ka wa Jerusalɛmu ka tɔrɔ siyaman ba sɔrɔn mɔɔbakɔrɔilu ni sarakalaseba kuntiilu ni sariya karanmɔɔilu bolo. A ka kan fanan ka faa, a ni tele sawanan, ka wuli ka bɔ saya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyɛri ka a kili ka a mabɔ karanden tɔilu la dɔɔni, ka a makuma damira. A ka a fɔ ko: «Maari, Alla ye i tanka wo ma. Wo ti kɛla fewu!» ");
INSERT INTO msc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kɔni Isa ka a kɔfɛni ka Piyɛri makuma ko: «Ile, Setana. Bɔ n kɔrɔ! Ile ye n kundatiɲanna le ri, baa Alla sawo ye mɛn di, i tɛ i mirila wo ma, fɔɔ mɔɔilu sawo.» ");
INSERT INTO msc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wo kɔ rɔ, Isa ka a fɔ a la karandenilu yɛ ko: «Ni mɔɔ mɛn ye a fɛ ka a bila n kɔ, fɔɔ wo tii ye a ban a jɛrɛ rɔ ka a gbɔngbɔn jiri mira ka a jɛrɛ bila n kɔ, ");
INSERT INTO msc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","baa mɔɔ mɛn ye a fɛ ka a nii kisi, wo tii ri bɔnɔ ɲenemaya bɛrɛbɛrɛ la. Kɔni ni mɔɔ mɛn bɔnɔra a nii la nde kosɔn, wo tii ri a jɛrɛ kisi. ");
INSERT INTO msc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A ye di? Ni mɔɔ ka dunuɲa bɛɛ sɔrɔn ka bɔnɔ ɲenemaya bɛrɛbɛrɛ la, dunuɲa sɔrɔn ri nfen ɲa a ma wo rɔ? Mɔɔ ri se nfen dila ka a nii kunka? ");
INSERT INTO msc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nde Mɔɔ Dencɛ ri na n Fa nɔɔrɔ rɔ, n ni a la mɛlɛkailu. Wo lon, n di bɛɛ sara ka a bɛn a tii kɛwaliilu ma. ");
INSERT INTO msc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N di tuɲa fɔ ii yɛ. Doilu ye ai tɛma yan, mɛnilu tɛ sa ni ai ma Mɔɔ Dencɛ natɔla yen ka kɛ mansa ri.» ");
INSERT INTO msc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nba, tele wɔɔrɔ taminnin kɔrɔ, Isa ka Piyɛri ni Yakuba ni wo dɔɔcɛ Yuhana kili ka wa ii ri koyinkɛ jan do kan. Mɔɔ gbɛrɛ tun tɛ ye. ");
INSERT INTO msc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Isa kɛɲa yɛlɛmanda karanden sawa woilu ɲakɔrɔ. A ɲakɔrɔla mɛlɛnmɛlɛnda ikomin tele. A la faaninilu gbɛra pepe ikomin yelen. ");
INSERT INTO msc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nabi Musa ni Nabi Eli bɔra gbɛ rɔ karanden sawa woilu ɲakɔrɔ. Woilu ni Isa tɛrɛ ye kumala i ɲɔɔn yɛ. ");
INSERT INTO msc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyɛri ka a fɔ Isa yɛ ko: «Maari, an na yan, wo bɛnni. Ni i sɔnda, n di gba sawa lɔ, i ta kelen, Nabi Musa ta kelen, a ni Nabi Eli ta kelen.» ");
INSERT INTO msc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka Piyɛri to kuma wo la, duru yelen nara ka birin ii kun na. Kumakan do bɔra duru rɔ ko: «N diyana dencɛ le ten. N sɛwani ale la kosɛbɛ. Ai ye ai tolo malɔ a la.» ");
INSERT INTO msc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Karandenilu ka kuma wo mɛn tuma mɛn na, ii silanda kojuuya fɔɔ ka ii be duu ma ka ii ɲa birin. ");
INSERT INTO msc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kɔni Isa ka a madon ii la ka a bolo maa ii la, ka a fɔ ii yɛ ko: «Ai kana silan, ai ye wuli.» ");
INSERT INTO msc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ii ka ii ɲakɔrɔta tuma mɛn na, ii ma mɔɔ si yen fɔɔ Isa kelen pe. ");
INSERT INTO msc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ka Isa ni a la karandenilu to jiila ka bɔ koyinkɛ la, a ka ii jamari ko, ii ka ko mɛn yen, ii kana wo fɔ mɔɔ si yɛ, fɔɔ Mɔɔ Dencɛ wa wuli ka bɔ saya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ii ka a maɲininka ko: «Nfenna sariya karanmɔɔilu ye a fɔla ko Nabi Eli fɔlɔ le ka kan ka na?» ");
INSERT INTO msc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isa ka ii jabi: «Tuɲa le, Nabi Eli ri na ka fen bɛɛ rabɛn. ");
INSERT INTO msc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","N ye a fɔla ai yɛ ko Nabi Eli ra ban nala. Kɔni mɔɔilu ma a lɔn. Ii ka ii sawonan koilu bɛɛ kɛ a la. Mɔɔ Dencɛ fanan di tɔrɔ ii bolo wo ɲa kelen de ma.» ");
INSERT INTO msc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Karandenilu ka a ɲayen wo rɔ ko a ye kumala ii yɛ Yaya le la ko kan. ");
INSERT INTO msc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Isa ni karandenilu sera jama rɔ tuma mɛn na, cɛɛ do ka a madon Isa la. A ka a ɲɔnkin Isa kɔrɔ ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Maari, i ye hina n dencɛ la. Kerekeremansa ye a la, a ra tɔrɔla kosɛbɛ. Siɲa siyaman a ri a labe ta rɔ, walama ji rɔ. ");
INSERT INTO msc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N nara a ri i la karandenilu ma, kɔni ii ma se a lakɛndɛyala.» ");
INSERT INTO msc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isa ka a fɔ ko: «Ai bi mɔɔilu ye lemɛniyabali ni kun gbɛdɛnilu le ri. N di to ai tɛma haan waati ɲuman? N di ai la ko muɲunnin fɔɔ waati ɲuman? Nba, ai ye na den di n ma yan.» ");
INSERT INTO msc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isa jamanda jina ma. Wo rɔ, jina bɔra den fɛ. Den kɛndɛyara i kɔrɔ ye. ");
INSERT INTO msc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wo kɔ rɔ, Isa la karandenilu ka ii madon a la ka a maɲininka ii dan na ko: «Nfenna andeilu ma se jina wo gbɛnna?» ");
INSERT INTO msc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Isa ka ii jabi: «Ai ma se ka a masɔrɔn ai la lemɛniya le ka dɔɔ. N di tuɲa fɔ ai yɛ: Hali ni ai la lemɛniya dɔɔman ikomin bɔrɔn fira kisɛ, ni ai ka a fɔ koyinkɛ ɲin yɛ ko a ye bɔ a nɔ rɔ ka wa, a ri wa. Ko si tɛ ye, ai ti se mɛn kɛla. ");
INSERT INTO msc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kɔni jina ɲin ɲɔɔn ti se bɔla mɔɔ fɛ, ni ai ma sun don ka Alla tara.» ");
INSERT INTO msc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nba, lon do rɔ, karandenilu bɛɛ ka i ɲɔɔn nadɛn Kalile mara rɔ. Isa ka a fɔ ii yɛ ko: «Mɔɔ Dencɛ kɛtɔ donna mɔɔilu bolo. ");
INSERT INTO msc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Woilu ri a faa. Kɔni tele fila a sawana, a ri wuli ka bɔ saya rɔ.» Kuma wo ka karandenilu jusukasi kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Isa ni a la karandenilu sera Kapɛrinahumu so kɔndɔ. Ka ii to ye, Allabatobonba niisankɔ miralalailu ka ii madon Piyɛri la ka a maɲininka ko: «Ai la karanmɔɔ tɛ Allabatobonba wodi sarala wa?» ");
INSERT INTO msc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyɛri ka a jabi: «Ɔɔn, a ye a sarala.» Piyɛri wara don bon kɔndɔ. Kɔni sani a ye kuma, Isa fɔlɔ le ka a fɔ a yɛ ko: «Simɔn, dunuɲa mansailu ye mɔɔ niisankɔ ni fen tɔilu niisankɔ mirala yon na? Ai denilu wa, wala londanilu? I la miriya ye di?» ");
INSERT INTO msc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyɛri ka a jabi: «Londanilu.» Isa ka a fɔ ko: «Wo rɔ, a denilu sen tɛ a rɔ. ");
INSERT INTO msc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wo bɛɛ ni a ta, an tɛ a fɛ ka mɔɔ ɲinilu tɔrɔ. Wo le kosɔn, i ye wa dala la ka lɔn bila ji rɔ. I wa jɛɛ fɔlɔ mɛn mira, i ye wo da laka ka a dakɔndɔla ragbɛ. I ri wodi gbanan do yen ye. I ye wa wo di ii ma. Nde ni ile ka kan ka wodi mɛn sara, wo ri a bɔ.» ");
INSERT INTO msc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nba, waati wo rɔ, karandenilu ka ii madon Isa la, ka a maɲininka ko: «Yon ye ɲɛmɔɔ ri Harijeene Mansaya rɔ?» ");
INSERT INTO msc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Isa ka den do kili, ka wo lalɔ ii tɛma, ");
INSERT INTO msc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ka a fɔ ii yɛ ko: «N di tuɲa fɔ ai yɛ: ni ai ma ai sɔn yɛlɛman ka kɛ ikomin denninilu, ai tɛna donna Harijeene Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mɔɔ mɛn wa a jɛrɛ fanmajii ka kɛ ikomin denni ɲin, wo tii le ye ɲɛmɔɔ ri Harijeene Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ni mɔɔ mɛn sɔnda ka denni ɲin ɲɔɔn mira koɲuma nde kosɔn, wo tii ra n jɛrɛ le mira wo ri. ");
INSERT INTO msc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Den mɛnilu lemɛniyani n ma ɲin di, ni mɔɔ do kɛra sababu ri ka woilu kɛ kojuu kɛla ri, a ka fisa ko kabakurun belebeleba ye sidi wo tii kan na ka a lafili kɔɔji dun ba rɔ. ");
INSERT INTO msc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gbalo ye dunuɲa mɔɔilu yɛ ka a masɔrɔn ko mɛnilu ye mɔɔilu bilala juulumun dɔ a fɛrɛ ti ye fɔɔ wo ko suilu ye kɛ le kɔni ii ye farala mɔɔ mɛnilu la, gbalo ye wo tiilu yɛ! ");
INSERT INTO msc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Ni i bolo kelen wala i sen kelen ye kɛla sababu ri ka i lɔ kojuu kɛla don? I ye wo tɛɛ a la ka a bɔ ye, baa ni i fɛɛtɔ wala i senkelen donda ɲenemaya jɛrɛ jɛrɛ rɔ, wo ka fisa i ma sani i bolofilatii wala i senfilatii ye wa don jahanama kɔndɔ, ta sabali ye yɔrɔ mɛn. ");
INSERT INTO msc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ni i ɲa kelen ye kɛla sababu ri ka i lɔ kojuu kɛla don? I ye a labɔ ka a lafili, baa ni i ɲakelentii donda ɲenemaya jɛrɛ jɛrɛ rɔ, wo ka fisa i ma sani i ɲafilatii ye lafili jahanama kɔndɔ, ta ye yɔrɔ mɛn. ");
INSERT INTO msc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","«Ai ye ai janto ai jɛrɛ rɔ. Ai kana denni ɲinilu si dɔɔya, baa n di a fɔ ai yɛ ko mɛlɛka mɛnilu ye ii jantola ii rɔ, woilu ri se ii madonna n Fa Alla la Harijeene rɔ tuma bɛɛ. ");
INSERT INTO msc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","A ye di? Ni saa kelen tununda saa kɛmɛ tii ma, a tɛ a tɔ bikɔnɔndɔ ni kɔnɔndɔ to koyinkɛ yɔrɔ rɔ ye ka wa saa tununni ɲinin diya wa? ");
INSERT INTO msc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","N di tuɲa fɔ ai yɛ: ni a ka a yen, a ri sɛwa a la ka tamin a tɔ bikɔnɔndɔ ni kɔnɔndɔ la ko kan, mɛnilu ma tunun a ma. ");
INSERT INTO msc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wo ɲa kelen de ma, ai Fa mɛn ye Harijeene rɔ, wo tɛ a fɛ hali dennin ɲinilu kelen pe a ye fɔ a la. ");
INSERT INTO msc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Nba, ni i badenma ka kojuu kɛ, i ye wa a tɛrɛn. A ka mɛn kɛ, i ye wo ɲafɔ a yɛ, i kelen a kelen. Ni a sɔnda i la kuma ma, i ni a ri kɛ badenmailu jɛrɛ jɛrɛilu ri ikɔ tuun. ");
INSERT INTO msc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɔni ni a ma sɔn i la kuma ma, i ye mɔɔ kelen wala mɔɔ fila ta, ka wa a tɛrɛn, sa fen fen wa fɔ, woilu bɛɛ ye fɔ sere fila wala sere sawa ɲana. ");
INSERT INTO msc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɔni ni a ka a ban ii la kuma rɔ, i ye ko wo fɔ lemɛniya jama yɛ. Ni a ka a ban dɛkuru wo la kuma rɔ, a ye kɛ i ma ikomin siya gbɛrɛilu wala niisɔnkɔmirala. ");
INSERT INTO msc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","N di tuɲa fɔ ai yɛ: ni ai ka fen fen sidi duukolo kan yan, wo ri sidi sankolo rɔ. Ni ai ka fen fen fulɛn duukolo kan yan, wo ri fulɛn sankolo rɔ fanan. ");
INSERT INTO msc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«N di do la wo kan. Ni ai rɔ mɔɔ fila bɛnda ko do rɔ ka Alla tara a la duukolo kan yan, n Fa Alla mɛn ye sankolo rɔ, a ri wo kɛ ai yɛ, ");
INSERT INTO msc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","baa ni mɔɔ fila wala mɔɔ sawa ka i ɲɔɔn nadɛn n tɔɔ rɔ, n ye ii tɛma ye.» ");
INSERT INTO msc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nba, Piyɛri ka a madon Isa la, ka a maɲininka ko: «Maari, ni n badenma ye kojuu kɛla n na, n ka kan ka a makoto fɔɔ siɲa yɛli? Siɲa wɔrɔnwula wa?» ");
INSERT INTO msc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isa ka a jabi: «Ɛɛn, i kana dan siɲa wɔrɔnwula ma. I ye wo tii makoto fɔɔ siɲa biwɔrɔnwula sii diyama wɔrɔnwula. ");
INSERT INTO msc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Wo le rɔ, Harijeene Mansaya ye ikomin tariku ɲin. Mansacɛ do tɛrɛ ye ye, mɛn na julu tɛrɛ ye a la baaraden doilu la. A tun ye a fɛ ka wodi ko wo ɲanabɔ. ");
INSERT INTO msc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A wulira wo ɲanabɔla tuma mɛn na, mɔɔilu ka a la baaraden do lana a ma, a la miliyɔn siyaman julu ye mɛn na. ");
INSERT INTO msc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Se tun tɛ baaraden yɛ ka julu wo sara. Wo rɔ, maari ka jamarili di ko ii ye baaraden wo feere, ka a muso ni a denilu fanan feere, a ni a bolofenilu bɛɛ, sa julu wo ri sara. ");
INSERT INTO msc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kɔni baaraden ka a be duu ma ka a la maari sen kɔrɔ. A ka a madiya kosɛbɛ ko: ‹I ye i muɲun. N di i la wodi bɛɛ sara.› ");
INSERT INTO msc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Baaraden kininkinin donda maari rɔ. Wo rɔ, a ka baaraden bila, ka diɲɛ a la julu rɔ. ");
INSERT INTO msc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Baaraden bɔra ye ka wa. A bɛnda a baaraden ɲɔɔn di, a la julu tɛrɛ mɛn na. A ka wo mira a kan ma ka a raja fɔɔ ka a niilakili ja a rɔ, ka a fɔ a yɛ ko: ‹N na julu sara!› ");
INSERT INTO msc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A baaraden ɲɔɔn ka a be duu ma a sen kɔrɔ, ka a madiya ko: ‹I ye i muɲun, n di i la wodi sara.› ");
INSERT INTO msc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kɔni baaraden ma sɔn fewu. A ka cɛɛ mira ka a bila kaso la ko ni a ma a la julu sara, a tɛ bɔ ye. ");
INSERT INTO msc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A baaraden ɲɔɔnilu ka wo yen tuma mɛn na, woilu jusu tɔrɔra kosɛbɛ. Ii wara wo bɛɛ fɔ ii la maari yɛ. ");
INSERT INTO msc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Maari ka baaraden wo kili, ka a fɔ a yɛ ko: ‹Ile, baaraden juu! Julu mɛn tɛrɛ ye i la, n ka wo bɛɛ to i yɛ ka a masɔrɔn i ka n madiya. ");
INSERT INTO msc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","N hinara i la ɲa mɛn ma, i fanan tun ti se hinala i baaraden ɲɔɔn na wo ɲa ma?› ");
INSERT INTO msc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A la maari mɔnɛra kosɛbɛ. A ka a la baaraden bolo don kaso kandanilailu bolo ka a tɔrɔya haan ni julu bɛɛ sara.» ");
INSERT INTO msc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«N Fa mɛn ye sankolo rɔ, wo fanan di wo ɲɔɔn kɛ ai kelen kelenna bɛɛ la ni ai ma ai badenmailu makoto ai jusukun bɛɛ la.» ");
INSERT INTO msc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nba, Isa banni wo fɔla, a bɔra Kalile mara rɔ ka wa Jude mara rɔ mɛn ye Juridɛn Ba kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jama ba bilara a kɔ. A ka woilu lakɛndɛya ye. ");
INSERT INTO msc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisi doilu ka ii madon Isa la. Ii tɛrɛ ye a kɔrɔbɔla. Wo rɔ, ii ka a maɲininka ko: «A dahani cɛɛ ye a muso bila ko bɛɛ rɔ wa?» ");
INSERT INTO msc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isa ka ii jabi: «Mɛn sɛbɛni kitabu kɔndɔ, ai ma wo karan wa? A sɛbɛni ko Danni Maari ka dunuɲa dan tuma mɛn na, a ka cɛɛ ni muso le dan. ");
INSERT INTO msc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Alla ka a fɔ ko: ‹Wo le kosɔn, cɛɛ ri mataa a fa ni a na la, ka sidi a muso ma. Ii fila bɛɛ ri kɛ mɔɔ kelen di.› ");
INSERT INTO msc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wo rɔ, ii tɛ jatela mɔɔ fila ri butun fɔɔ mɔɔ kelen. Wo le kosɔn, Alla ka mɛnilu ladɛn ka ii kɛ kelen di, mɔɔ si kana woilu fara ka ii bɔ i ɲɔɔn na.» ");
INSERT INTO msc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisilu ka Isa maɲininka ikɔ tuun ko: «Ni wo le, nfenna Nabi Musa ka jamarili di ko ni cɛɛ ye a fɛ ka furusa, fɔɔ a ye furusasɛbɛ rabɛn ka a muso bila.» ");
INSERT INTO msc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isa ka ii jabi: «Ai kun gbɛlɛman tɛrɛ. Wo le ka a kɛ, Nabi Musa sɔnda ai ye ai musoilu bila. Ni wo tɛ, fɔlɔfɔlɔ a tun tɛ ten. ");
INSERT INTO msc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kɔni n di a fɔ ai yɛ ko ni mɔɔ mɛn ka a muso bila ka muso gbɛrɛ ta, ka a tɛrɛn a muso fɔlɔ wo tun ma kaninkɛ, wo tii ra kaninkɛ.» ");
INSERT INTO msc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Isa la karandenilu ka a fɔ a yɛ ko: «Aa! Ni a ye ten de cɛɛ ni a muso tɛma, a ka fisa cɛɛ ma ni a ma muso si ta.» ");
INSERT INTO msc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isa ka ii jabi: «Cɛɛilu bɛɛ ti se sɔnna kuma wo ma de, fɔɔ ni Alla ka a se di mɛnilu ma. ");
INSERT INTO msc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ko doilu ye a kɛla, cɛɛilu ri ii ban muso tala. Cɛɛ doilu ye ye, mɛnilu sɔrɔnda ka a tɛrɛn ii ti se dɛla muso fɛ. Cɛɛ doilu fanan ye ye, mɔɔilu ra mɛnilu bɔ cɛya rɔ. Cɛɛ doilu fanan ye ye, mɛnilu ti sɔnna ka furu kɛ Harijeene Mansaya kosɔn. Mɔɔ mɛn di se sɔnna kuma ɲin ma, wo tii ye sɔn wo ma.» ");
INSERT INTO msc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mɔɔ doilu nara denninilu ri Isa ma, sa a ri a bolo la ii kan ka Alla matara ii yɛ, kɔni karandenilu jamanda denninilu ma. ");
INSERT INTO msc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Isa ka a fɔ ii yɛ ko: «Ai ye a to denninilu ye na n ma. Ai kana ii bali, baa Harijeene Mansaya ye ii ɲɔɔn su ta le ri.» ");
INSERT INTO msc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Awa, a banni a bolo lala denninilu kan, a bɔra ye ka wa. ");
INSERT INTO msc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A watɔla, cɛɛ do ka a madon a la, ka a fɔ a yɛ ko: «Karanmɔɔ, n ka kan ka koɲuma ɲuman kɛ, sa n di ɲenemaya banbali sɔrɔn?» ");
INSERT INTO msc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isa ka a fɔ a yɛ ko: «Nfenna i ye n maɲininkala koɲuma ko ma? Alla kelen pe le ka ɲi. Ni i ye a fɛ ka ɲenemaya jɛrɛ jɛrɛ sɔrɔn, i ye Alla la sariya labato.» ");
INSERT INTO msc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Cɛɛ ka a fɔ ko: «Sariya ɲuman?» Isa ka a jabi: «I kana mɔɔ faa, i kana kaninkɛ kɛ, i kana suɲali kɛ, i kana kɛ sere juu ri, ");
INSERT INTO msc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","i ye i fa ni i na bonya, i ye i mɔɔɲɔɔ kanin ikomin i jɛrɛ.» ");
INSERT INTO msc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kanberen ka a fɔ ko: «N da sariya woilu bɛɛ labato. Nfen da n jɛn fɔlɔ?» ");
INSERT INTO msc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isa ka a jabi: «Ni i ye a fɛ i la koilu bɛɛ ye dafa, i ye wa i bolofenilu feere ka a wodi ratala fantanilu tɛma. Wo rɔ, nanfulu wa di kɛ i bolo sankolo rɔ. Wo kɔ rɔ, i ye na i bila n kɔ.» ");
INSERT INTO msc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kanberen ka wo mɛn tuma mɛn na, a niilafinni wulira ka wa, baa a bolofen ka siya. ");
INSERT INTO msc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wo kɛni, Isa ka a fɔ a la karandenilu yɛ ko: «N di tuɲa fɔ ai yɛ: nanfulutii don Harijeene Mansaya rɔ, wo gbɛlɛman de! ");
INSERT INTO msc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɔɔn, n di a fɔ ai yɛ ikɔ tuun ko ɲɔɔmɛ don duman sayilan woo la ka tamin nanfulutii don kan Alla la Mansaya rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Karandenilu ka wo mɛn ka kabannakoya kosɛbɛ. Ii ka a fɔ ko: «Yon di se kisila wo rɔ sa?» ");
INSERT INTO msc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isa ka ii ragbɛ ka a fɔ ii yɛ ko: «Mɔɔ ti se wo kɛla, kɔni Alla ri se ko bɛɛ kɛla.» ");
INSERT INTO msc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyɛri ka a fɔ a yɛ ko: «A ye di? Andeilu ra fen bɛɛ to ye ka an bila i kɔ. An di nfen sɔrɔn wo rɔ?» ");
INSERT INTO msc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isa ka a fɔ a yɛ ko: «N di tuɲa fɔ i yɛ: dunuɲa wa kɛ dunuɲa kura ri, Mɔɔ Dencɛ ri a sii a la mansaya siifen dɔ, mɛn gbiliyani. Ai mɛnilu ra ai bila n kɔ, ai fanan di ai sii mansaya siifen tan ni fila rɔ, ka Isirayɛlikailu la kabila tan ni fila la kiti tɛɛ. ");
INSERT INTO msc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ni mɔɔ mɛn ka a la bon to a kɔ ye, wala a dɔɔilu ni a kɔrɔilu, wala a na, wala a fa, wala a denilu, wala a la sɛnɛilu, nde kosɔn, wo tii ri woilu ɲɔɔn kɛmɛ sɔrɔn, ka ɲenemaya banbali fanan sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kɔni ɲɛmɔɔ siyaman di kɛ kɔmɔɔilu ri. Kɔmɔɔ siyaman di kɛ ɲɛmɔɔilu ri fanan.» ");
INSERT INTO msc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nba, Isa ka kuma kɔrɔlama do fɔ ii yɛ. A ka a fɔ ko: «Harijeene Mansaya kɛnin ikomin sɛnɛtii do la ko. Sɛnɛtii wo bɔra sɔɔma da la jona ka wa baaraden doilu ɲinin, mɛnilu ri sɔn ka wa baara diya a la rɛsɛnfɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A ka mɔɔ mɛnilu sɔrɔn, a ni woilu bɛnda a rɔ ko tele kelen baara sara ri kɛ wodi gbanan kelen di. Wo rɔ, a ka ii lawa baara diya a la rɛsɛnfɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Waati sawa ɲɔɔn taminni kɔ, sɛnɛtii bɔra ikɔ tuun. A ka mɔɔ doilu lɔni yen bara rɔ, mɛn tɛ foyi kɛla. ");
INSERT INTO msc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A ka a fɔ woilu yɛ ko: ‹Ai fanan ye wa baara diya rɛsɛnfɛ rɔ. Sara mɛn ka kan ka a di ai ma, n di wo di ai ma.› ");
INSERT INTO msc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mɔɔ woilu wara rɛsɛnfɛ rɔ. Midi waati, sɛnɛtii bɔra ka wa wo ɲɔɔn kɛ. Waati sawa taminni wo kɔ, a bɔra ka wa wo ɲɔɔn kɛ ikɔ tuun. ");
INSERT INTO msc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wura fɛ, sɛnɛtii bɔra ikɔ tuun. A ka mɔɔ doilu lɔni yen ikɔ. A ka a fɔ woilu yɛ ko: ‹Nfenna ai ka tele bɛɛ ban lɔ rɔ yan, ai ma baara kɛ?› ");
INSERT INTO msc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ii ka a jabi: ‹An ma baara kɛ ka a masɔrɔn mɔɔ si ma an ta baara la.› A ka a fɔ ii yɛ ko: ‹Ai fanan ye wa baara diya n na rɛsɛnfɛ rɔ.› ");
INSERT INTO msc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Nba, tele bera tuma mɛn na, sɛnɛtii ka a fɔ a la baara kuntii yɛ ko a ye baaradenilu kili ka ii sara. Ko baaraden mɛnilu nara a tɔilu bɛɛ kɔ, ko a ye sarali damira woilu ma, ka na se mɔɔ fɔlɔilu ma. ");
INSERT INTO msc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wo rɔ, mɔɔ mɛnilu sera ye telebe tumana, a ka wodi gbanan kelen di ii kelen kelenna bɛɛ ma. ");
INSERT INTO msc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mɔɔ mɛnilu fɔlɔ sera baara diya, sarali dakun seni ii ma, ii tɛrɛ ye ii mirila ko ii sara ri siyaya ka tamin tɔilu ta kan de. Kɔni woilu bɛɛ ka wodi gbanan kelen kelen sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nba, wodi dini kɔ ii ma, ii ka sɛnɛtii mafɔ damira. ");
INSERT INTO msc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ii ka a fɔ ko: ‹Baaraden mɛnilu nara bɛɛ kɔ ɲin, ii ka waati kelen pe baara le kɛ. Kɔni i ra an ni woilu bɛɛ sara kɛ kelen di, ka a tɛrɛn andeilu le ka an daja tele muumɛ kɔrɔ, ka baara kɛ tele kɔrɔ.› ");
INSERT INTO msc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sɛnɛtii ka ii rɔ kelen jabi: ‹N badenma, n ma i tɔɲɔ de! An bɛnda wodi gbanan kelen de ma, wo tɛ? ");
INSERT INTO msc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","I ye i la sara ta ka wa. Mɔɔ mɛn nara baara diya ai tɔilu kɔ, n ye a fɛ ka wodi gbanan kelen di wo fanan ma, ikomin n ka a di i ma ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A ye di? N ma kan ka n na bolofenilu kɛ ɲa ma mɛn duman n yɛ wa? Ni wo tɛ, n fonesere, wo ɲangboya ye i la wa?› ");
INSERT INTO msc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Wo le rɔ, kɔmɔɔilu ri kɛ ɲɛmɔɔilu ri. Ɲɛmɔɔilu ri kɛ kɔmɔɔilu ri fanan.» ");
INSERT INTO msc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nba, Isa watɔla Jerusalɛmu, a ka a la karanden tan ni fila kili ii dan na. Ka ii to taamala, a ka a fɔ ii yɛ ko: ");
INSERT INTO msc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ai ɲa lɔ! An watɔ Jerusalɛmu. Mɔɔ Dencɛ ri don sarakalasela kuntiiilu ni sariya karanmɔɔilu bolo. Woilu ri kiti labe a kan ko a ka kan ka faa. ");
INSERT INTO msc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ii ri a don siya gbɛrɛ mɔɔilu bolo sa woilu ri a lafɛya, ka a gbasi bonsan la, ka a gbɔngbɔn jiri kan ka a faa. Kɔni tele fila a sawana, a ri wuli.» ");
INSERT INTO msc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nba, Sebede muso nara Isa tɛrɛn a dencɛ fila ri. A ka a majii Isa kɔrɔ ka a madiya ko do la. ");
INSERT INTO msc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Isa ka a fɔ a yɛ ko: «Ai ye a fɛ n ye nfen de kɛ ai yɛ?» A ka Isa jabi: «I ye a to n dencɛ fila ye ii sii i dafɛ. Kelen di a sii i bolokinin fɛ, a tɔ kelen di a sii i bolomaran fɛ, i wa don i la mansaya la tuma mɛn na.» ");
INSERT INTO msc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kɔni Isa ka a jabi: «Ai ye ko mɛn tarala, ai ma wo kɔrɔ lɔn. Tɔrɔya mɛn kɛtɔ n sɔrɔnna, ai ri se wo muɲunna wa?» Sebede dencɛ fila ka Isa jabi: «Ɔɔn, an di se a kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Isa ka a fɔ ko: «N di tɔrɔya mɛn muɲun, ai fanan di wo ɲɔɔn muɲun. Kɔni sii diya mɛnilu ye n bolokinin ni n bolomaran fɛ, woilu diba tɛ nde ri. N Fa ka sii diya woilu rabɛn mɔɔ mɛnilu yɛ, a ri ii di woilu le ma.» ");
INSERT INTO msc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Karanden tɔ tan ka kuma wo mɛn tuma mɛn na, woilu mɔnɛra badenma fila woilu kanma. ");
INSERT INTO msc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kɔni Isa ka karandenilu bɛɛ kili, ka a fɔ ii yɛ ko: «Ai ka a lɔn ko jamana mansailu ye kuntiiya kɛla ii la jamanadenilu kan diyagboya la. Jamana mɔɔbailu ri fanka la jamanadenilu kan. ");
INSERT INTO msc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A ma kan ka kɛ ten ai tɛma. Mɛn ye a fɛ ka kɛ mɔɔba ri ai rɔ, wo tii ka kan ka kɛ ai dɛmɛnba ri. ");
INSERT INTO msc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mɛn ye a fɛ ka kɛ ai rɔ ɲɛmɔɔ ri, wo tii ye kɛ ai la jɔn di. ");
INSERT INTO msc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wo ɲa kelen ma, Mɔɔ Dencɛ ma na dunuɲa rɔ ko mɔɔilu ye baara kɛ a yɛ. A jɛrɛ nara baara kanma, a ni ka a nii di ka kɛ mɔɔ siyaman kunka sara ri.» ");
INSERT INTO msc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nba, Isa ni a la karandenilu bɔtɔla Jeriko so kɔndɔ, jama ba bilara a kɔ. ");
INSERT INTO msc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ɲa fuyen cɛɛ fila siini tɛrɛ sila dala. Woilu ka a mɛn tuma mɛn na ko Isa le tamintɔ, ii wɔyɔra ko: «Maari, mansa Dawuda dencɛ, i ye hina an na.» ");
INSERT INTO msc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jama ka ii makuma ko ii ye ii makun. Kɔni ii pɛrɛnda ka tamin fɔlɔman kan ko: «Maari, mansa Dawuda dencɛ, i ye hina an na.» ");
INSERT INTO msc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Isa ka a lɔ ka ii kili, ka a fɔ ii yɛ ko: «Ai ye a fɛ n ye nfen de kɛ ai yɛ?» ");
INSERT INTO msc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ii ka a fɔ ko: «Maari, an ye a fɛ i ye an ɲa laka.» ");
INSERT INTO msc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ii kininkinin donda Isa la. A ka a maa ii ɲa la, ii ɲa lakara i kɔrɔ ye. Ii ka ii bila Isa kɔ i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Awa, Isa ni a la karandenilu sudunyani Jerusalɛmu so la, ii sera Bɛtifase so kɔndɔ, ni a ye Olibiye Koyinkɛ la. Ka ii to ye, Isa ka a la karanden mɔɔ fila kelaya. ");
INSERT INTO msc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A ka a fɔ ii yɛ ko: «So mɛsɛn mɛn ye an ɲɛfɛ wo ri, ai ye wa ye. Ai wa don so kɔndɔ, ai ri falimuso do sidini yen i kɔrɔ. A den ye a dafɛ. Ai ye a fulɛn ka na ii ri yan. ");
INSERT INTO msc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ni mɔɔ do ka ai maɲininka, ai ye wo tii jabi: ‹Maari le mako ye ii la.› Wo tii ri ii lana i kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Awa, ko woilu bɛɛ kɛni sa Maari la kuma ri kanbali, a ka mɛn don a la nabi da rɔ. Wo ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ai ye a fɔ Siyonkailu yɛ ko: ‹Ai ɲa lɔ! Ai la mansa natɔ le ten. A fanmajiini, a siini falimuso le kan. Ɔɔn, a siini fali den kan, falimuso denni kɔnin.›» ");
INSERT INTO msc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nba, karandenilu wara a kɛ ikomin Isa ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ii nara falimuso ni a den di. Ii ka ii la durukibailu la faliilu kɔ rɔ. Isa yɛlɛra ka a sii ii kan. ");
INSERT INTO msc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jama siyaman ba ka ii la durukibailu fɛnsɛn sila kan Isa ɲɛfɛ. Doilu ka jiri bolon mɛsɛnilu tɛɛ ka woilu fɛnsɛn sila kan a ɲɛfɛ. ");
INSERT INTO msc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mɔɔ mɛnilu tɛrɛ ye Isa ɲɛfɛ, a ni mɛnilu tɛrɛ ye a kɔfɛ, woilu tɛrɛ ye ii kan ba labɔla ko: «Tandoli ye kɛ mansa Dawuda dencɛ yɛ! Mɛn ye nala Maari tɔɔ rɔ ten, Alla ra ɲumaya kɛ wo yɛ. Tandoli ye kɛ sankolo rɔ!» ");
INSERT INTO msc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Isa donda Jerusalɛmu tuma mɛn na, so bɛɛ lamaara. Mɔɔilu bɛɛ ka a fɔ ko: «Ee, yon de ɲin di ten?» ");
INSERT INTO msc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jama ka ii jabi: «Nabi Isa le ɲin, mɛn ye bɔla Nasarɛti, Kalile mara rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Awa, Isa donda Allabatobonba jin kɔndɔ. A ka jula ni sanninkɛla mɛnilu tɛrɛn Allabatobonba jin kɔndɔ ye, a ka woilu bɛɛ gbɛn ka ii labɔ ye. A ka wodifalennailu la tabaliilu labebe, ka kanba julailu la siifenilu fanan nabebe. ");
INSERT INTO msc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A ka a fɔ ye mɔɔilu yɛ ko: «A sɛbɛni Alla la Kitabu kɔndɔ ko: ‹N na bon di kɛ Alla tara diya ri.› Kɔni ai ra a kɛ bɛnkanninnailu dokon diya ri.» ");
INSERT INTO msc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ɲafuyenilu ni senkelenninilu ka ii madon Isa la Allabatobonba jin kɔndɔ ye. A ka woilu lakɛndɛya. ");
INSERT INTO msc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sarakalasela kuntiiilu ni sariya karanmɔɔilu ka Isa la kabannako kɛniilu yen ye. Ii ka denni doilu fanan yen, mɛnilu tɛrɛ ye ii kan ba labɔla Allabatobonba jin kɔndɔ ye ko: «Tandoli ye kɛ mansa Dawuda dencɛ yɛ!» Wo rɔ, sarakalasela kuntiiilu ni sariya karanmɔɔilu mɔnɛra. ");
INSERT INTO msc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ii ka a fɔ Isa yɛ ko: «I tolo ye denilu kan na wa?» Isa ka ii jabi: «Ɔɔn, n tolo ye a la. A ye di? Mɛn sɛbɛni Alla la kitabu kɔndɔ, ai ma wo karan fɔlɔ wa? A sɛbɛni ko: ‹Denninilu ni sinmindenilu ye i tandola, baa i jɛrɛ ka tandoli kan wo don ii da rɔ.›» ");
INSERT INTO msc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Isa ka ii to ye ka wa. A bɔra so kɔndɔ ka wa su kɛ Betani. ");
INSERT INTO msc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wo duusa gbɛ, Isa wulira ka a kɔsɛ Jerusalɛmu. A watɔla, kɔnkɔ ka a mira. ");
INSERT INTO msc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A ka toroju do yen sila dala. A ka a madon a la ka a ragbɛ. Kɔni a ma toroden yen, fɔɔ fira gbansan. A ka a fɔ a yɛ ko: «I tɛna i den butun fewu!» Toroju jara i kɔrɔ ye. ");
INSERT INTO msc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Karandenilu ka wo yen tuma mɛn na, ii kabannakoyara. Ii ka a fɔ ko: «Ee, toroju jara i kɔrɔ wo rɔ di?» ");
INSERT INTO msc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isa ka a fɔ ko: «N di tuɲa fɔ ai yɛ: ni lemɛniya ye ai rɔ, ni ai fanan ma sikasika, n ka mɛn kɛ toroju la ɲin, ai ri se wo ɲɔɔn kɛla. Ka a la wo kan, ni ai ka a fɔ koyinkɛ ɲin yɛ ko: ‹I ye bɔ i nɔ rɔ ka wa be kɔɔji rɔ,› a ri kɛ ten. ");
INSERT INTO msc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ni ai ka lemɛniya la Alla rɔ, ai wa fen fen ɲinin a fɛ, ai ri wo sɔrɔn.» ");
INSERT INTO msc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Isa wara don Allabatobonba jin kɔndɔ. Ka a to mɔɔilu karanna ye, sarakalasela kuntiiilu ni mɔɔbakɔrɔilu nara a tɛrɛn ye, ka a maɲininka ko: «I ye baara mɛn kɛla ɲin, yon ka i lɔ wo la? I ye yon se kɔrɔ?» ");
INSERT INTO msc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isa ka ii jabi: «N fanan di ai maɲininka ko kelen ma. Ni ai ka n jabi, n di a fɔ ai yɛ mɛn ka n lɔ baara ɲin kɛla. ");
INSERT INTO msc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A ye di? Yon de ka Yaya lɔ mɔɔilu sunna ji rɔ? Alla le ka a lɔ wa, wala mɔɔilu?» Ii ka a fɔ i ɲɔɔn yɛ ko: «Ni an ka a fɔ ko Alla le ka Yaya lɔ, a ri a fɔ an yɛ ko: ‹Wo rɔ, nfenna ai ma la Yaya la kuma la?› ");
INSERT INTO msc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kɔni an kana a fɔ ko: ‹Mɔɔilu le ka Yaya lɔ de!› An silanni ii mɔnɛ la, baa jama bɛɛ ye Yaya jatela nabi le ri.» ");
INSERT INTO msc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wo rɔ, ii ka Isa jabi: «An ma a lɔn.» Isa fanan ka ii jabi: «Nba, ni wo le, n tɛna a fɔla ai yɛ mɛn ka n lɔ baara ɲin kɛla. ");
INSERT INTO msc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Ai ye ai mirila di? Dencɛ fila tɛrɛ ye mɔɔbakɔrɔ do bolo. A ka a fɔ a dencɛ fɔlɔ yɛ ko: ‹N dencɛ, i ye wa baara kɛ rɛsɛnfɛ rɔ bi.› ");
INSERT INTO msc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Den ka a fɔ ko: ‹N tɛ wala.› Kɔni kɔfɛ, a nimisara. A wara rɛsɛnfɛ rɔ wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mɔɔbakɔrɔ ka kuma kelen wo fɔ dencɛ filana yɛ. A ka a fɔ ko: ‹N fa, n di wa.› Kɔni a ma wa. ");
INSERT INTO msc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wo dencɛ fila rɔ, ɲuman de ka a fa sawo kɛ?» Ii ka a fɔ ko: «Dencɛ fɔlɔ wo.» Isa ka a fɔ ko: «N di tuɲa fɔ ai yɛ: niisankɔmiralailu ni sunkurunbailu ye donna ai ɲɛfɛ Alla la Mansaya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Baa Yaya nara ka telenbaya sila yiraka ai la, a ni ai ma la ale la; kɔni niisankɔmiralailu ni sunkurunbailu lara a la. Ai ka a yen ko ii lara Yaya la. Hali wo, ai ma nimisa kɔfɛ ka la ale la. ");
INSERT INTO msc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ai ye ai tolo malɔ kuma kɔrɔlama gbɛrɛ la. Lutii do ka rɛsɛnfɛ labɔ ka a laminin sansan na. A ka denka sen, mɛn di kɛ rɛsɛnji bɔ diya ri. A ka gbalan mayɛlɛni do fanan lɔ, mɛn di kɛ sɛnɛ kɔnɔgbɛn diya ri. A banni wo bɛɛ la, a ka rɛsɛnfɛ karifa sɛnɛkɛla doilu la. Wo kɔ rɔ, a wara taama rɔ. ");
INSERT INTO msc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Rɛsɛnden kadi waati sudunyara tuma mɛn na, a ka a la jɔnilu lawa sɛnɛkɛlailu tɛrɛn ye, ko ii ye a niiyɔrɔ di a ma rɛsɛnden kadiniilu rɔ. ");
INSERT INTO msc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kɔni jɔnilu sera ye tuma mɛn na, sɛnɛkɛlailu ka ii mira. Ii ka do gbasi, ka dogbɛrɛ faa, ka dogbɛrɛ bon kabakurun la. ");
INSERT INTO msc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nba, rɛsɛnfɛ tii ka jɔn gbɛrɛilu kelaya ikɔ tuun. Woilu ka siya tɛrɛ fɔlɔmantailu ri. Kɔni sɛnɛkɛlailu ka woilu fanan mira ikomin ii ka fɔlɔmantailu mira ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","A laban, a ka a jɛrɛ dencɛ kelaya ii ma. A ka a fɔ ko: ‹Sɛnɛkɛla woilu ri n dencɛ bonya.› ");
INSERT INTO msc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kɔni sɛnɛkɛlailu ka dencɛ wo yen tuma mɛn na, ii ka a fɔ i ɲɔɔn yɛ ko: ‹Cɛtala le ɲin di. Ai ye na, an ye wa a faa ka a fa cɛ ta.› ");
INSERT INTO msc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ii ka dencɛ wo mira, ka a lafili rɛsɛnfɛ kɔkan, ka a faa. ");
INSERT INTO msc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«A ye di? Lutii wa se rɛsɛnfɛ rɔ, a ri nfen de kɛ sɛnɛkɛlailu la?» ");
INSERT INTO msc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ii ka a jabi: «A ri be mɔɔ juu woilu kan hinabaliya la ka ii faa. Wo kɔ rɔ, a ri a la rɛsɛnfɛ karifa mɔɔ gbɛrɛilu la, mɛnilu ri a ta niiyɔrɔ di a ma rɛsɛndenilu kadi waati.» ");
INSERT INTO msc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isa ka a fɔ ii yɛ ko: «Mɛn sɛbɛni Alla la kitabu kɔndɔ, ai ma wo karan fɔlɔ wa? A sɛbɛni ko: ‹Bon lɔlailu ka ii ban kabakurun mɛn dɔ, wo le kɛra bon jusii kabakurun di. Maari nɔ le wo ri. A kɛra an ɲana kabannako ri.›» ");
INSERT INTO msc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Wo le kosɔn, n di a fɔ ai yɛ ko Alla la Mansaya ri ta ai bolo, ka di siya gbɛrɛ ma, mɛn di Alla la Mansaya jiriden nawara. ");
INSERT INTO msc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nba, kabakurun wo mɛn fanan ko fɔra, ni mɔɔ mɔɔ kɔnin bera kabakurun wo kan, wo tii koloilu bɛɛ ri kadikadi. Ni kabakurun wo fanan bera mɔɔ mɔɔ kan, a ri wo tii ramɔɲɔnkɔ fewu.» ");
INSERT INTO msc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sarakalasela kuntiiilu ni Farisilu ka kuma kɔrɔlama woilu mɛn tuma mɛn na, ii ka a ɲayen ko Isa kan ii le ma. ");
INSERT INTO msc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ii ka a ɲa ɲinin ka Isa mira. Kɔni ii silanda jama yɛ, baa mɔɔilu tɛrɛ ye Isa jatela nabi ri. ");
INSERT INTO msc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nba, Isa ka kuma kɔrɔlama dogbɛrɛilu fɔ ii yɛ ikɔ tuun. A ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Harijeene Mansaya ye ikomin mansacɛ, mɛn ka dɔɔnninba rabɛn a dencɛ la kɔɲɔ ko rɔ. ");
INSERT INTO msc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mansacɛ tun ka dɔɔnnin ko fɔ mɔɔ mɛnilu yɛ, a ka a la jɔncɛilu lɔ woilu kilila dɔɔnnin diya. Kɔni mɔɔ woilu tun tɛ a fɛ ka na. ");
INSERT INTO msc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mansacɛ ka jɔn gbɛrɛilu lawa ikɔ tuun. A ka a fɔ ko: ‹Ai ye a fɔ mɔɔ kilini woilu yɛ ko «n da dɔɔnninba rabɛn. Ko torailu ra faa, a ni nisi tɔlɔninilu. Ko a bɛɛ ra mɔ. Ko ai ye na dɔɔnnin diya.»› ");
INSERT INTO msc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kɔni mɔɔ mɛnilu kilini, woilu si ma mansa la kilikan jate. Do bɔra ka wa a la sɛnɛ rɔ. Do bɔra ka wa a la julaya kɛ diya. ");
INSERT INTO msc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tɔilu ka mansacɛ la jɔnilu mira, ka ii tɔrɔ kosɛbɛ, ka ii faa. ");
INSERT INTO msc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Mansacɛ mɔnɛra wo rɔ. A ka a la kɛlɛdenilu lawa mɔɔfaala woilu kanma. Kɛlɛdenilu ka ii bɛɛ faa, ka ii la so janin. ");
INSERT INTO msc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mansacɛ ka a fɔ a la jɔnilu yɛ ko: ‹Kɔɲɔ dɔɔnninba ra rabɛn. Kɔni mɛnilu kilini tɛrɛ, woilu si tɛrɛ ma daha wo ye ii kili. ");
INSERT INTO msc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wo le rɔ, ai ye wa sila ba fara diyailu la. Ai wa mɔɔ mɔɔ tɛrɛn ye, ai ye ii bɛɛ kili ko ii ye na kɔɲɔ dɔɔnnin diya.› ");
INSERT INTO msc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jɔnilu wulira ka wa sila dailu la. Ii ka mɔɔ mɛnilu tɛrɛn ye, ii ka woilu bɛɛ kili dɔɔnnin diya, mɔɔ juuilu ni mɔɔ ɲumailu bɛɛ. Wo rɔ, kɔɲɔ dɔɔnninba tɛrɛ ye bon mɛn kɔndɔ, wo fara mɔɔ kiliniilu la. ");
INSERT INTO msc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Mansacɛ donda bon kɔndɔ ko a ri a ɲa la mɔɔ kiliniilu kan. A ka cɛɛ do yen ye, kɔɲɔmalɔ faanin tɛ mɛn kan na. ");
INSERT INTO msc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mansacɛ ka a fɔ cɛɛ wo yɛ ko: ‹N duɲɔɔncɛ, a ye di? Kɔɲɔmalɔ faanin tɛ i kan na. I donda bon na yan wo rɔ di?› Cɛɛ ma foyi sɔrɔn ka a fɔ. ");
INSERT INTO msc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mansacɛ ka a fɔ baaradenilu yɛ ko: ‹Ai ye a senilu ni a boloilu sidi ka a lafili dibi rɔ kɔkan, yɔrɔ mɛn mɔɔilu ri kasi ka a ɲin macin.›» ");
INSERT INTO msc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Isa ka kuma do la wo kan ko: «Mɔɔ siyaman kilini, kɔni mɛnilu suwandini, woilu ma siya.» ");
INSERT INTO msc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wo kɔ rɔ, Farisilu bɔra ye ka wa i ɲɔɔn yen ka ɲa ɲinin Isa la ko ma. Ii ye a fɛ a ye kuma do fɔ, mɛn di kɛ a mira sababu ri. ");
INSERT INTO msc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ii ka ii la karanden doilu ni mansa Herodi kɔmɔɔ doilu lawa Isa ma. Woilu wara a fɔ Isa yɛ ko: «Karanmɔɔ, an ka a lɔn ko i ye tuɲa fɔla. Mɔɔilu ka kan ka Alla la sila taama ɲa mɛn, i ye ii karanna wo la tuɲa jɛrɛ jɛrɛ rɔ. I tɛ silanna mɔɔ si yɛ, i tɛ mɔɔ bɔla mɔɔ rɔ fanan. ");
INSERT INTO msc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A ye di wo rɔ? Ka niisankɔ bɔ ka a di Rɔmu mansa Sesari ma, wo bɛnni an ma wa, wa wo bɛnni tɛ? I ye i la miriya fɔ an yɛ.» ");
INSERT INTO msc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kɔni Isa ka ii la miriyajuu lɔn. Wo rɔ, a ka a fɔ ii yɛ ko: «Ai jɛrɛmayuwailu, nfenna ai ye n kɔrɔbɔla? ");
INSERT INTO msc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ai ye niisankɔ sarala wodi gbanan mɛn na, ai ye wo do yiraka n na, n ye a ragbɛ.» Ii ka gbanan wo kelen di a ma. ");
INSERT INTO msc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A ka ii maɲininka ko: «Yon munuɲa ni yon tɔɔ ye gbanan ɲin kan?» ");
INSERT INTO msc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ii ka a fɔ ko: «Rɔmu mansa Sesari.» Isa ka a fɔ ko: «Nba, ai ye mansa Sesari la fen di mansa Sesari ma. Ai ye Alla fanan ta di Alla ma.» ");
INSERT INTO msc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Isa la jabili ka ii kabannakoya. Ii bɔra a fɛ ka wa. ");
INSERT INTO msc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wo lon kelen, Sadusiilu nara Isa tɛrɛn. Sadusiilu ye a fɔla ko mɔɔ si tɛ wulila ka bɔ saya rɔ. Awa, wo doilu nara ka Isa maɲininka ko: ");
INSERT INTO msc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Karanmɔɔ, Nabi Musa ka a fɔ ko ni i kɔrɔcɛ sara ka a muso densɔrɔnbali to ye, i ye muso wo ta sa a ri den sɔrɔn i kɔrɔcɛ yɛ. ");
INSERT INTO msc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Awa, cɛɛ wɔrɔnwula tɛrɛ ye an wara rɔ yan, mɛnilu tɛrɛ ye cɛɛ kelen denilu ri. Kɔrɔmamɔɔ ka muso do furu. A sara ka a muso densɔrɔnbali to a kɔ. A dɔɔcɛ ka muso wo ta. ");
INSERT INTO msc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kɔni wo fanan sara, ka muso densɔrɔnbali to a kɔ. A kɛra wo ɲa le fɔɔ muso wo siira cɛɛ wɔrɔnwula woilu bɛɛ kun, kɔni a ma den sɔrɔn. ");
INSERT INTO msc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cɛɛ woilu bɛɛ sani kɔ, muso fanan sara. ");
INSERT INTO msc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A ye di? Su lawuli lon, muso ri kɛ yon ta ri cɛɛ wɔrɔnwula woilu tɛma? Baa a siira ii kelen kelen na bɛɛ kun.» ");
INSERT INTO msc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isa ka ii jabi: «Ai filini, baa ai ma Alla la kitabu kɔrɔ famun. Ai ma foyi lɔn Alla la sebaya ko rɔ fanan! ");
INSERT INTO msc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Baa suilu wa wuli saya kɔ, cɛɛ tɛna muso furula, muso fanan tɛna siila cɛɛ kun. Ii bɛɛ ri kɛ ikomin sankolo rɔ mɛlɛkailu. ");
INSERT INTO msc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Su lawuli ko fan fɛ, Alla ka mɛn fɔ ai yɛ a la kitabu kɔndɔ, ai ra wo karan, ko di? ");
INSERT INTO msc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","A ka a fɔ ko: ‹N ye Iburahima Maari le ri, a ni Isiyaka ta, a ni Yakuba ta.› A tɛ suilu Maari ri. Ɛɛn de! A ye mɔɔ ɲenemailu Maari le ri.» ");
INSERT INTO msc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jama ka kuma wo mɛn tuma mɛn na, ii kabannakoyara a la karan ma. ");
INSERT INTO msc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisilu ka a mɛn tuma mɛn na ko Isa ka Sadusiilu da bɔ a rɔ, woilu ka ii ladɛn ka wa Isa tɛrɛn. ");
INSERT INTO msc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sariya karanmɔɔ do tɛrɛ ye ii rɔ. Wo ka ɲininkali kɛ Isa kun a kɔrɔbɔ kanma. A ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Karanmɔɔ, sariya ɲuman gbɛlɛman sariya tɔilu bɛɛ di?» ");
INSERT INTO msc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isa ka a fɔ a yɛ ko: «‹I ye i la Maari Alla kanin i jusukun bɛɛ la, a ni i sɔlɔmɛ bɛɛ la, a ni i miriya bɛɛ la.› ");
INSERT INTO msc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wo ye sariya fɔlɔ le ri, mɛn gbɛlɛman sariya tɔilu bɛɛ ri. ");
INSERT INTO msc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sariya mɛn tuunni wo la, wo fanan gbɛlɛman ikomin fɔlɔmanta. Ale le ɲin. ‹I ye i mɔɔɲɔɔ kanin ikomin i jɛrɛ.› ");
INSERT INTO msc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sariya bɛɛ ni nabiilu la karan bɛɛ sidini sariya fila wo le la.» ");
INSERT INTO msc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ka Farisilu ladɛnnin to, Isa ka ɲininkali kɛ ii kun. ");
INSERT INTO msc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","A ka a fɔ ko: «A ye di? Ai ye ai mirila di Ɲenematɔmɔnin na ko rɔ? Yon dencɛ le a ri?» Ii ka Isa jabi: «Mansa Dawuda dencɛ le.» ");
INSERT INTO msc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Isa ka a fɔ ii yɛ ko: «Kɔni Nii Sɛniman ka a kɛ, Dawuda jɛrɛ ka a fɔ Ɲenematɔmɔnin ma ko Maari. Wo kɛra di? Baa Dawuda ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Maari Alla ka a fɔ n na Maari yɛ ko: «Na i sii n bolokinin fɛ, haan n wa ban i juuilu bilala i sen kɔrɔ.»› ");
INSERT INTO msc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Awa, ni Dawuda jɛrɛ ye a fɔla a ma ko Maari ten, a don di se kɛla a dencɛ ri di?» ");
INSERT INTO msc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mɔɔ si ma se ka Isa jabi. Ka a ta wo lon ma, mɔɔ si ma sɔn ka ɲininkali kɛ a kun butun. ");
INSERT INTO msc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wo kɔ rɔ, Isa kumara jama ni a la karandenilu yɛ. A ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ka mɔɔilu karan Nabi Musa la sariya la, se wo karifani Sariya karanmɔɔilu ni Farisilu la. ");
INSERT INTO msc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wo rɔ, ii wa mɛn fɔ ai yɛ, ai ye wo labato. Kɔni ii jɛrɛ ye kɛwali mɛnilu kɛla, ai kana woilu ɲɔɔn kɛ de, baa ii ye mɛn fɔla, ii tɛ wo kɛla. ");
INSERT INTO msc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ii ye donin gbilinilu sidila ka woilu sii mɔɔilu kun. Ii jɛrɛ don ti sɔn ka mɔɔ woilu dɛmɛn hali dɔɔni. ");
INSERT INTO msc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wo rɔ, ii ye ko bɛɛ kɛla kosa mɔɔilu ye ii yen. Ka a masɔrɔn, ii ye Kitabu kumailu sɛbɛla, ii ye ii sidila ii tindailu la a ni ii boloilu la haan a bonyara ka dan natamin, ka ii la durukiilu masidini julu denni janilu la. ");
INSERT INTO msc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sii diya ɲumaɲumailu le duman ii yɛ dɔɔnninba diya. Mɔɔbailu la sii diyailu duman ii yɛ salibonilu la. ");
INSERT INTO msc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ii ye a fɛ mɔɔilu ye ii kɔndɔn jamama yɔrɔilu rɔ. Ii ye a fɛ fanan mɔɔilu ye a fɔ ii ma ko ‹Rabi›. ");
INSERT INTO msc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kɔni ai kana sɔn mɔɔilu ye a fɔ ai ma ko ‹Rabi›, baa karanmɔɔ kelen de ye ai la. Ai tɔilu ye badenmailu le ri. ");
INSERT INTO msc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ai kana a fɔ mɔɔ si ma duukolo kan yan ko n fa, baa Fa kelen de ye ai la, ni a ye Alla ri, mɛn ye sankolo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ai kana sɔn mɔɔilu ye a fɔ ai ma ko ‹karanmɔɔ›, baa karanmɔɔ kelen de ye ai bolo, ni a ye Ɲenematɔmɔnin di. ");
INSERT INTO msc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mɔɔ mɛn ka bon tɔilu ri ai tɛma, wo ye tɔilu la baaraden di. ");
INSERT INTO msc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mɔɔ mɔɔ wa a jɛrɛ bonya, Alla ri wo majii. Kɔni mɔɔ mɔɔ wa a jɛrɛ fanmajii, Alla ri wo bonya. ");
INSERT INTO msc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","«Gbalo ye ai sariya karanmɔɔilu ni Farisilu yɛ! Ai jɛrɛmayuwailu! Baa ai ra Harijeene Mansaya da tuun mɔɔilu ɲɛrɔ. Ai jɛrɛ tɛ don a rɔ, mɛnilu fanan ye a fɛ ka don, ai ti sɔn woilu ye don. ");
INSERT INTO msc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Gbalo ye ai sariya karanmɔɔilu ni Farisilu yɛ! Ai jɛrɛmayuwailu! Baa ai ye wala fan bɛɛ rɔ duukolo kan, ai ye kɔɔji fanan tɛɛla, sa ai ri mɔɔ ɲinin, mɔɔ mɛn di sɔn ka don ai la dina rɔ. Kɔni ai wa a ladon, ai ye a kɛla jahanamaden di ka tamin ai jɛrɛ kan fɔɔ siɲa fila. ");
INSERT INTO msc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Gbalo ye ai ɲafuyenilu yɛ mɛn ye ɲafuyen gbeleke mirala. Ai ka a fɔ ko ni mɔɔ do ka a kali Allabatobonba la, ko kalili wo tɛ foyi ri. Ko kɔni ni mɔɔ do ka a kali Allabatobonba kɔndɔ sanin na, ko fɔɔ wo tii ye kalilikan wo dafa. ");
INSERT INTO msc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ai nalonmailu ni fuyenilu! Ɲuman de ka bon? Sanin de ka bon wa, wa Allabatobonba, wo mɛn ye sanin wo kɛla sanin sɛniman di? ");
INSERT INTO msc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ai kan fanan ko ni mɔɔ ka a kali sarakabɔdiya la, ko wo tɛ foyi ri. Kɔni saraka mɛn ye saraka janin diya kan, ni mɔɔ ka a kali wo la, ko fɔɔ wo tii ye kalilikan wo dafa. ");
INSERT INTO msc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ai ɲa fuyenilu! Ɲuman de ka bon? Saraka le ka bon wa, wala saraka janin diya, wo mɛn ye saraka wo kɛla saraka sɛniman di? ");
INSERT INTO msc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ni mɔɔ ka a kali saraka janin diya la, fen fen ye a kan, wo tii ra a kali wo bɛɛ fanan na. ");
INSERT INTO msc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ni mɔɔ ka a kali Allabatobonba la, wo tii ra a kali Allabatobonba la, a ni bontii Alla fanan na, mɛn siini bon na ye. ");
INSERT INTO msc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ni mɔɔ ka a kali sankolo la, wo tii ra a kali Alla la Mansaya siifen na, a ni Alla jɛrɛ le la, mɛn siini a rɔ. ");
INSERT INTO msc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Gbalo ye ai sariya karanmɔɔilu ni Farisilu yɛ! Ai jɛrɛmayuwailu! Ai ye ai la nakɔ firamɛsɛnilu kelen kelenna bɛɛ jaa bɔla, ka Alla la sariya bonbailu to ye, ni ii ye telenbaya ko ni hina ko ni lemɛniya ko ri. Ai ka kan ka woilu le fɔlɔ kɛ, ka a tɔilu la woilu kan. ");
INSERT INTO msc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ai ɲafuyenilu yɛ mɛn ye ɲafuyen gbeleke mirala. Ai ye ai la minji sɛnsɛnna ka hali wolowoloni bɔ a rɔ, ka a tɛrɛn ai ye ɲɔɔmɛ lakununna. ");
INSERT INTO msc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Gbalo ye ai sariya karanmɔɔilu ni ai Farisilu yɛ! Ai jɛrɛmayuwailu! Ai ye jilafɛilu ni tasailu kɔkanna makola ka ii gbɛ. Kɔni woilu fani fen mɛnilu la, ai ka woilu sɔrɔn suɲali ni natabaya le rɔ. ");
INSERT INTO msc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi fuyen! I ye jilafɛ ni tasa kɔndɔ le fɔlɔ ko. Wo rɔ, ii kɔkanna fanan di sɛninya. ");
INSERT INTO msc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Gbalo ye ai sariya karanmɔɔilu ni Farisilu yɛ! Ai jɛrɛmayuwailu! Ai ye ikomin kaburu mɛn kɔkanna ra bɔrangbɛ ka kenɲiya, ka a tɛrɛn a kɔnɔ fani mɔɔ koloilu ni nɔɔ su bɛɛ la. ");
INSERT INTO msc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nba, ai fanan ye ten de. Ai wa kɛ mɔɔilu ɲakɔrɔ, ai kɛni ikomin mɔɔ telenniilu. Kɔni ai kɔndɔ fani jɛrɛmayuwaya ni kojuu la. ");
INSERT INTO msc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Gbalo ye ai sariya karanmɔɔilu ni ai Farisilu yɛ! Ai jɛrɛmayuwailu! Ai ye nabiilu kaburuilu lɔla. Alla la telenba mɛnilu sani, ai ye woilu kaburuilu masidila ka ii lakenɲa. ");
INSERT INTO msc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ai ye a fɔla ko: ‹Ni an tɛrɛ ye ye an benbailu la waati rɔ, an tun tɛ ii dɛmɛn nabiilu faala.› ");
INSERT INTO msc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ai ye a yirakala wo le fɛ ko ai le nabiilu faabailu denilu ri. ");
INSERT INTO msc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nba, ai benbailu ka baara mɛn damira, ai ye wo dafa fasayi! ");
INSERT INTO msc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ai duuma sailu! Ai, fɔnfɔnni la munuɲailu! Alla ri kiti labe ai kan ka ai lafili jahanama kɔndɔ! Ai ri bɔ kiti wo kɔrɔ di? ");
INSERT INTO msc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wo le kosɔn, n di nabiilu kelaya ai ma, a ni mɔɔ famunyaniilu ni sariya karanmɔɔilu. Ai ri doilu gbɔngbɔn jiri kan ka ii faa. Ai ri doilu gbasi gbiɲɛ la ai la salibonilu kɔndɔ. Ii wa bori ka bɔ so do la ka wa so gbɛrɛ la, ai ri ii kɔsaran. ");
INSERT INTO msc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","N di woilu kelaya ai ma sa telenbailu bɛɛ faa kunko ri be ai kan, telenba mɛnilu bɛɛ faara mɔɔilu bolo duukolo kan. Abila, mɛn telenba, a fɔlɔ faara. A laban, Baraki dencɛ Sakariya faara. Ai ka wo le faa Allabatobonba ni saraka janin diya tɛma. ");
INSERT INTO msc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N di tuɲa fɔ ai yɛ: mɔɔ woilu bɛɛ faa kunko ri be bi mɔɔilu kan. ");
INSERT INTO msc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Ee Jerusalɛmukailu, Jerusalɛmukailu. Ai ye nabiilu faala. Alla wa mɛnilu lɔ ai kawandila, ai ye woilu bonna kaba la ka ii faa. Siɲa siyaman, n tɛrɛ ye a fɛ ka ai ladɛn ikomin sisɛ wa ye a denilu ladɛnna ɲa mɛn ma ka ii dokon a kanban kɔrɔ. Kɔni ai ma sɔn. ");
INSERT INTO msc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sisɛn, ai la bon dakolon di to ai bolo, ");
INSERT INTO msc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","baa n di a fɔ ai yɛ ko ai ɲa tɛna lala n kan butun fɔɔ ni ai ka a fɔ lon mɛn na ko: ‹Mɛn ye nala Maari tɔɔ rɔ ten, Alla ra ɲumaya kɛ wo yɛ.›» ");
INSERT INTO msc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nba, Isa bɔra Allabatobonba jin kɔndɔ. A watɔla, a la karandenilu ka ii madon a la, ka a jin kɔndɔ bonilu yiraka Alla batobonba la. ");
INSERT INTO msc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Isa ka ii jabi: «Ai ɲa ye fen woilu bɛɛ la, wo tɛ? Awa, n di tuɲa fɔ ai yɛ: lon do rɔ, woilu bɛɛ ri tete, ka a kabakurunilu bɛɛ jɛnsɛn ka a bɔ i ɲɔɔn kan.» ");
INSERT INTO msc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ka Isa siini to Olibiye Koyinkɛ kan, a la karandenilu ka ii madon a la, ka a maɲininka ii dan na ko: «I kan ye ko mɛnilu ma, woilu ri kɛ waati ɲuman? Tɔɔmasere su ɲuman de ri a yiraka ko i natɔ, a ni ko waati laban wo ra se?» ");
INSERT INTO msc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isa ka ii jabi: «Ai ye ai janto ai jɛrɛ rɔ sa mɔɔ si kana ai lafili, ");
INSERT INTO msc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","baa mɔɔ siyaman di na n tɔɔ rɔ, ka a fɔ ko: ‹Nde le ye Ɲenematɔmɔnin di.› Ii ri mɔɔ siyaman nafili wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A ri kɛlɛ ko mɛn yɔrɔ do rɔ, wala ko kɛlɛ wulitɔ le yɔrɔ do rɔ, kɔni ai kana silan. Fɔɔ ko woilu ye kɛ. Kɔni wo tɛna kɛ waati laban di fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Siya ri wuli siya gbɛrɛ kanma. Mansaya do ri wuli dogbɛrɛ kanma. Kɔnkɔ ba ni duukolo yɛrɛyɛrɛ ri kɛ yɔrɔ doilu rɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ko woilu bɛɛ ye tɔrɔya damira le ri, ikomin tinkɔnɔdimin fɔlɔ mɛn ye muso moyitɔla mirala. ");
INSERT INTO msc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Mɔɔilu ri ai don mɔɔilu bolo, sa woilu ri ai tɔrɔ, ka ai faa. Ai ri gboya dunuɲa mɔɔilu bɛɛ yɛ n tɔɔ kosɔn. ");
INSERT INTO msc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mɔɔ siyaman di n na sila bila, ka i ɲɔɔn don mɔɔilu bolo, ka gboya i ɲɔɔn yɛ. ");
INSERT INTO msc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wuya nabi siyaman di wuli, ka mɔɔ siyaman nafili. ");
INSERT INTO msc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kojuukɛ ri wara kojuuya. Wo le kosɔn, mɔɔ siyaman di a mɔɔɲɔɔilu kanin boloka kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kɔni mɔɔ mɛn wa a muɲun fɔɔ tɔrɔya waati wa ban, wo tii ri kisi. ");
INSERT INTO msc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kibaro ɲuma mɛn ye Harijeene Mansaya ko fɔla, wo ri kawandi dunuɲa yɔrɔ bɛɛ rɔ, sa siyailu bɛɛ ri a sereya mɛn. Wo kɔ rɔ, dunuɲa laban di se. ");
INSERT INTO msc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ai wa Fen Haramunnin yen lɔnin yɔrɔ sɛninman dɔ mɛn ye halaki kɛla, Nabi Daniyɛli ka mɛn na ko fɔ, (Mɔɔ mɛn ye ɲin karanna, wo ri a kɔrɔ lɔn.) ");
INSERT INTO msc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ni waati wo sera, mɔɔ mɛnilu ye Jude mara rɔ, woilu ye ii bori ka wa koyinkɛilu kan. ");
INSERT INTO msc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ni waati wo ka mɔɔ mɛn tɛrɛn bon kun bilinin kan, wo tii kana jii fenilu ta kanma bon kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wo wa mɔɔ mɛn tɛrɛn sɛnɛ rɔ, wo tii kana a kɔsɛ a wara ko a ye a la durukiba tala. ");
INSERT INTO msc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Waati wo la, muso kɔnɔmailu ri tɔrɔ kosɛbɛ, a ni muso mɛnilu ye sinmin den tiilu ri. ");
INSERT INTO msc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ai ye Alla tara, sa ai la bori ko wo kana kɛ nɛnɛ tuma rɔ, wala Ɲɔɲɔ lon, ");
INSERT INTO msc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","baa wo tuma tɔrɔya ri gbɛlɛya kojuuya. Wo ɲɔɔn ma kɛ fɔlɔ kɛbi dunuɲa danda waati mɛn na fɔɔ ka na se bi ma. Adon tɔrɔya wo ɲɔɔn tɛna kɛla butun habadan. ");
INSERT INTO msc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ni wo waati tun ma rasudunya, mɔɔ si ti kisi wo rɔ, kɔni a la mɔɔ suwandiniilu la ko kosɔn a ri a rasudunya. ");
INSERT INTO msc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wo tuma, ni mɔɔ do ka a fɔ ko ‹A ragbɛ! Ɲenematɔmɔnin ye yan,› wala ‹A ye ye,› ai kana la a la, ");
INSERT INTO msc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","baa wuya nabiilu ri wuli, a ni mɛnilu ka a fɔ ko iile ye Ɲenematɔmɔnin di. Ii ri tɔɔmasere bailu ni kabannakoilu kɛ ka Alla la mɔɔ suwandiniilu lafili, ni wo ri se kɛla. ");
INSERT INTO msc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","N da wo bɛɛ fɔ ai yɛ sani ii ye kɛ. ");
INSERT INTO msc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Wo rɔ, ni mɔɔilu ka a fɔ ai yɛ ko: ‹A ragbɛ! A ye wula kɔndɔ,› ai kana wa ye. Ni ii ka a fɔ ko: ‹A ragbɛ! A doonni sutura yɔrɔ do rɔ yan,› ai kana la wo la, ");
INSERT INTO msc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","baa sanfɛrɛn ye bɔla telebɔ rɔ ka san mɛlɛnmɛlɛn fɔɔ telebe rɔ ɲa mɛn ma, Mɔɔ Dencɛ natɔla ri kɛ wo ɲa. ");
INSERT INTO msc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sobo su wa kɛ yɔrɔ mɛn dɔ, duwailu ri ii ladɛn yɔrɔ wo rɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Tɔrɔya tuma wa ban, tele ri fin i kɔrɔ. Karo tɛ kɛnɛ bɔ butun. Loloilu ri bebe ka bɔ sankolo rɔ. Sankolo kɔndɔ fankatiilu ri juujuu ka bɔ ii nɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wo tuma, mɔɔ Dencɛ la tɔɔmasere ri bɔ gbɛ rɔ sankolo rɔ. Duukolo kan siyailu bɛɛ ri jusumakasa. Ii ri Mɔɔ Dencɛ natɔla yen duru kan ka bɔ sankolo rɔ sebaya ni nɔɔrɔ ba rɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mɔɔ Dencɛ ri a la mɛlɛkailu kelaya buru fɛ kan ba la. Ii ri wa telebe ni telebɔ rɔ, a ni tele kankan bolomaran ni tele kankan bolokinin dɔ, ka a la mɔɔ suwandiniilu ladɛn. Ka bɔ sankolo kun do la fɔɔ ka wa se a kun do la, a la mɛlɛkailu ri woilu ladɛn. ");
INSERT INTO msc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ai ye famunyali sɔrɔn ka fara toroju kuma kɔrɔlama la. Ai wa a bolonilu yen naronna ka fira kurailu labɔ, ai ri a lɔn ko sanci kun na waati ra se. ");
INSERT INTO msc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wo ɲa kelen ma, ni ai ka ko woilu bɛɛ yen tuma mɛn na, ai ri a lɔn ko wo waati ra sudunya, fɔdiya a ra se. ");
INSERT INTO msc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N di tuɲa fɔ ai yɛ: sani bi mɔɔilu ye ban sala, ko woilu bɛɛ ri ban kɛla. ");
INSERT INTO msc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lon do rɔ, sankolo ni duukolo ri ban ka tunun fewu, kɔni n na kumailu tɛ tamin habadan! ");
INSERT INTO msc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ko woilu ri kɛ lon mɛn na, a ni waati mɛn na, mɔɔ si ma wo lɔn. Mɛlɛka mɛnilu ye sankolo rɔ, woilu fanan ma a lɔn. Hali Dencɛ jɛrɛ ma a lɔn, fɔɔ Fa kelen pe. ");
INSERT INTO msc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ko mɛnilu kɛra Nuhan tele rɔ, Mɔɔ Dencɛ ri na ka ko woilu kɛni tɛrɛn. ");
INSERT INTO msc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nuhan tele rɔ, sanci ba tun ma na tuma mɛn fɔlɔ, mɔɔilu tɛrɛ ye dɔɔnnin ni minnin kɛla. Ii tɛrɛ ye muso furula, ka ii denmuso di cɛɛilu ma furu la, haan Nuhan donda kulunba kɔndɔ lon mɛn dɔ. ");
INSERT INTO msc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ii ma sobi foyi ma, fɔɔ sanci ba nara ka ii bɛɛ halaki. Mɔɔ Dencɛ na lon fanan di kɛ wo ɲa. ");
INSERT INTO msc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wo lon, cɛɛ fila ri tɛrɛn sɛnɛ rɔ, kelen di ta ka kelen to ye. ");
INSERT INTO msc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Muso fila ri tɛrɛn suman si diya, ii ye sumankisɛ sila. Kelen di ta ka kelen to ye. ");
INSERT INTO msc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wo rɔ, ai ye to ai ɲana, baa ai ma a lɔn ai la Maari ri na lon mɛn. ");
INSERT INTO msc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ai ye ko ɲin famun: ni lutii tun ye a kalama ko son di na a wara waati mɛn, a tun di to a ɲana. Wo rɔ, a tun ti sɔn son ye don a la bon na. ");
INSERT INTO msc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wo le kosɔn, ai fanan dabɛnni ye to, baa Mɔɔ Dencɛ ri na waati do rɔ, ai hankili tɛ waati mɛn na. ");
INSERT INTO msc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Jɔn ɲuman ye jatela mɔɔ sɛbɛ ri, wala mɔɔ famunyani? Jɔntii ri baara karifa jɔn wo la ko a ye dɔɔnnin di jɔn tɔilu ma a waati la. ");
INSERT INTO msc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ni jɔntii nara ka jɔn wo tɛrɛn baara kan, jɔn wo ri kɛ barakaden de ri. ");
INSERT INTO msc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","N di tuɲa fɔ ai yɛ: jɔntii ri jɔn wo kɛ a bolofenilu bɛɛ kunnasiila ri. ");
INSERT INTO msc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kɔni ni jɔn wo kɛra jɔn juu ri, tumadɔ a ri a miri ko: ‹N jɔntii ra mɛn, a ti nala jona.› ");
INSERT INTO msc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wo rɔ, tumadɔ a ri wuli a baaraden ɲɔɔn tɔilu gbasila, ka dɔɔnnin kɛ ka dɔlɔ min mɔɔilu fɛ, mɛnilu ɲa lamininni. ");
INSERT INTO msc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kɔni jɔn wo jɔntii ri na lon do rɔ, jɔn hankili tɛ lon mɛn kɔ, a hankili tɛ waati mɛn na. ");
INSERT INTO msc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","A wa na, a ri jahadi la jɔn kan kojuuya, ka a bila jɛrɛmayuwailu tɛma, kasi ni a ɲin macin ye yɔrɔ mɛn dɔ.» ");
INSERT INTO msc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Wo lon, Harijeene Mansaya ri kɛ ikomin sunkurun tan na ko mɛn ka ii la fitinnailu ta ka wa kɔɲɔcɛ kunbɛn diya. ");
INSERT INTO msc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ii rɔ mɔɔ loolu tɛrɛ ye hankilitanilu ri. A tɔ loolu tɛrɛ ye mɔɔ famunyaniilu ri. ");
INSERT INTO msc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sunkurun hankilitanilu ka ii la fitinna ta, kɔni ii ma fitinna olibiye tulu ta ii bolo. ");
INSERT INTO msc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kɔni sunkurun hankilimailu ka ii la fitinnailu ta, a ni ii la olibiye tulu baraninilu. ");
INSERT INTO msc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kɔɲɔcɛ mɛnda a ma na. Sunɔɔ ka sunkurun tan bɛɛ mira, ii bɛɛ sunɔɔra. ");
INSERT INTO msc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Duu talama, wɔyɔ kan do bɔra ko: ‹Kɔɲɔcɛ ra na, ai ye bɔ ka wa a kunbɛn!› ");
INSERT INTO msc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sunkurun tan bɛɛ wulira ka ii la fitinnailu rabɛn. ");
INSERT INTO msc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sunkurun hankilitanilu ka a fɔ sunkurun famunyaniilu yɛ ko: ‹Ai ye an sɔ ai la tulu do la, baa an na fitinnailu satɔ le.› ");
INSERT INTO msc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɔni sunkurun famunyaniilu ka ii jabi: ‹Wo tɛ bɛn, baa an na tulu ti se an bɛɛ bɔla. Ai ye wa julailu wara ka do san ai jɛrɛ yɛ.› ");
INSERT INTO msc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Awa, ka sunkurun hankilitanilu wani to tulu san diya, kɔɲɔcɛ nara. Sunkurun mɛnilu rabɛnni, woilu ni kɔɲɔcɛ wara don kɔɲɔmalɔ tolon dɔ. Mɔɔilu ka da tuun. ");
INSERT INTO msc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kɔ fɛ, sunkurun tɔilu nara ka bɔ tulu san diya. Ii ka ii kan nabɔ ko: ‹Maari, maari, i ye da laka an yɛ!› ");
INSERT INTO msc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɔni a ka ii jabi: ‹N di tuɲa fɔ ai yɛ: n ma ai lɔn.›» ");
INSERT INTO msc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Wo le rɔ, ai ye to ai ɲana, baa Maari ri na lon mɛn, a ni waati mɛn, ai ma wo si lɔn. ");
INSERT INTO msc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«A ri kɛ ikomin cɛɛ do la ko. Cɛɛ wo watɔla taama rɔ, a ka a la jɔnilu kili ka a la bolofenilu karifa ii la. ");
INSERT INTO msc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A ka wodi gbanan saninnama waa loolu di do ma, ka waa fila di dogbɛrɛ ma, ka waa kelen di a sawana ma. A ka jate wo di ii ma ka a bɛn ii se ko ma. A banni wo la, a wulira kelen di ka wa taama rɔ. ");
INSERT INTO msc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jɔn mɛn ka gbanan saninnama waa loolu sɔrɔn, ale wulira julaya kɛla wodi wo rɔ i kɔrɔ. A ka gbanan saninnama waa loolu gbɛrɛ sɔrɔn tɔnɔ ri. ");
INSERT INTO msc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mɛn ka waa fila sɔrɔn, ale fanan ka a ta kɛ ɲa kelen wo ma, ka gbanan saninnama waa fila gbɛrɛ sɔrɔn tɔnɔ ri. ");
INSERT INTO msc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kɔni mɛn ka waa kelen sɔrɔn, wo wara denka sen ka a la kuntii la wodi don ye ka a latunun. ");
INSERT INTO msc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nba, jɔnilu la kuntii ka waati jan kɛ a ma na. Wo kɔ rɔ, a nara ka bɔ taama rɔ. A ka jɔnilu kili ko ka wodi ko ɲabɔ. ");
INSERT INTO msc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jɔn mɛn ka wodi gbanan saninnama waa loolu sɔrɔn, wo nara waa loolu gbɛrɛ ri ka a la a ta wodi kan. A ka a fɔ ko: ‹N na kuntii, i ka wodi gbanan saninnama waa loolu le karifa n na. I ɲa lɔ. N da wodi gbanan saninnama waa loolu tɔnɔ sɔrɔn wo la.› ");
INSERT INTO msc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A la kuntii ka a fɔ ko: ‹Wo ra bɛn. Jɔn ɲuma le i ri, a ni landaɲa mɔɔ. Fen fitini le dira i ma, kɔni i ka wo mira koɲuma. Sisen n di fen siyaman karifa i la. Na, i ni i la kuntii ye sɛwa kelen di.› ");
INSERT INTO msc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jɔn mɛn ka wodi gbanan saninnama waa fila sɔrɔn, wo nara ka a fɔ kuntii yɛ ko: ‹N na kuntii, i ka wodi gbanan saninnama waa fila le karifa n na. I ɲa lɔ. N da wodi gbanan saninnama waa fila tɔnɔ sɔrɔn wo la.› ");
INSERT INTO msc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A la kuntii ka a fɔ ko: ‹Wo ra bɛn. Jɔn ɲuma le i ri, a ni landaɲa mɔɔ. Fen fitini le dira i ma, kɔni i ka wo mira koɲuma. Sisen n di fen siyaman karifa i la. Na, i ni i la kuntii ye sɛwa kelen di.› ");
INSERT INTO msc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jɔn mɛn ka wodi gbanan saninnama waa kelen sɔrɔn, wo nara ka a fɔ kuntii yɛ ko: ‹N na kuntii, n tun ka a lɔn ko i la ko gbɛlɛman. I ri suman ka i ma mɛn sɛnɛ. I ma si foyi yɔrɔ mɛn i ri ye suman ka. ");
INSERT INTO msc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wo le kosɔn, n silanda. N wara denka sen ka i la wodi don ye ka a latunun. I ɲa lɔ. N da i la wodi lasɛ i ma.› ");
INSERT INTO msc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A la kuntii ka a fɔ ko: ‹Jɔn juu le i ri, a ni sala. I tun ka a lɔn ko n di suman ka, n ma mɛn sɛnɛ. Ko n ma si foyi yɔrɔ mɛn, n di ye suman ta. ");
INSERT INTO msc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wo rɔ, i tun ka kan ka n na wodi bila wodi lamarabon na, tɔnɔ ye sɔrɔnna yɔrɔ mɛn. Ni i tun ka a kɛ ten, n tun di na ka n na wodi ni a tɔnɔ sɔrɔn ye. ");
INSERT INTO msc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wo le rɔ, wodi gbanan saninnama waa kelen mɛn ye a bolo, ai ye wo mira ka a di jɔn fɔlɔman ma, wodi gbanan saninnama waa tan ye mɛn bolo, ");
INSERT INTO msc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","baa fen ye mɛn bolo, do fanan di la wo tii ta kan ka a siyaya. Kɔni fen tɛ mɛn bolo, hali fitini mɛn ye wo bolo, wo ri ta a bolo. ");
INSERT INTO msc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ai ye jɔn ɲatɔntan ɲin nafili dibi rɔ kɔkan, kasi ni a ɲin macin ye yɔrɔ mɛn dɔ.› ");
INSERT INTO msc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Mɔɔ Dencɛ wa na a la gbiliya rɔ lon mɛn, a la mɛlɛkailu bɛɛ ri na a malɔ. A ri a sii a la mansaya siifen gbiliyani rɔ. ");
INSERT INTO msc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dunuɲa siyailu bɛɛ ri ii ladɛn a ɲakɔrɔ. A ri ii fara ka ii bɔ i ɲɔɔn dɔ, ikomin saagbɛngbɛnna ye saailu ni baailu farala ɲa mɛn ma ka ii bɔ i ɲɔɔn dɔ. ");
INSERT INTO msc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A ri saailu bila a bolokinin fɛ, ka baailu bila a bolomaran fɛ. ");
INSERT INTO msc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wo kɔ rɔ, mansa ri a fɔ bolokininmatailu yɛ ko: ‹Na, aile mɛn kunnadiyani n Fa bolo; ai ye na mansaya sɔrɔn mɛn dabɛnni a yɛ kɛbi dunuɲa dan waati, ");
INSERT INTO msc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","baa ai ka n kɔnkɔtɔ yen tuma mɛn na, ai ka n sɔ dɔɔnnin dɔ. Ai ka n jilɔɔtɔ yen tuma mɛn na, ai ka n sɔ ji rɔ. N tɛrɛ ye londanya rɔ tuma mɛn na, ai ka n jiya. ");
INSERT INTO msc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ai ka n farimakolon yen tuma mɛn na, ai ka n sɔ feriyabɔ rɔ. N jankarɔto tɛrɛ tuma mɛn na, ai ka ai janto n dɔ. N tɛrɛ ye kaso la tuma mɛn na, ai wara bɔ n fɛ.› ");
INSERT INTO msc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mɔɔ telenni woilu ri a fɔ a yɛ ko: ‹Maari, an ka i kɔnkɔtɔ yen lon ɲuman de ka i sɔ dɔɔnnin dɔ? An ka i jilɔɔtɔ yen lon ɲuman ka i sɔ ji rɔ? ");
INSERT INTO msc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","An ka i yen londanya rɔ lon ɲuman ka i lajiya? Ni wo tɛ, an ka i farimakolon yen lon ɲuman ka i sɔ feriyabɔ rɔ? ");
INSERT INTO msc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","An ka i jankarɔto yen lon ɲuman ka wa bɔ i ma? Ni wo tɛ, an ka a mɛn lon ɲuman ko i ye kaso la ka wa bɔ i ma?› ");
INSERT INTO msc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mansa ri ii jabi: ‹N di tuɲa fɔ ai yɛ: ni ai ka koɲuma kɛ n badenma do yɛ mɛn dɔɔman ii bɛɛ tɛma, ai ka wo kɛ n jɛrɛ le yɛ.› ");
INSERT INTO msc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Wo kɔ rɔ, mansa ri a fɔ bolomarannatailu yɛ ko: ‹Ai dankadenilu, ai ye bɔ n ɲakɔrɔ ka wa ta sabali rɔ, mɛn dabɛnni Ibulusa ni a la mɛlɛkailu yɛ, ");
INSERT INTO msc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","baa ai ka n kɔnkɔtɔ yen tuma mɛn na, ai ma n sɔ dɔɔnnin dɔ. Ai ka n jilɔɔtɔ yen tuma mɛn na, ai ma n sɔ ji rɔ. ");
INSERT INTO msc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N tɛrɛ ye londanya rɔ, kɔni ai ma n jiya. Ai ka n farimakolon yen, kɔni ai ma n sɔ feriyabɔ rɔ. N jankarɔto le tɛrɛ, kɔni ai ma wa bɔ n fɛ. N tɛrɛ ye kaso la, kɔni ai ma wa bɔ n fɛ.› ");
INSERT INTO msc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mɔɔ woilu fanan di a fɔ a yɛ ko: ‹Maari, an ka i kɔnkɔtɔ yen lon ɲuman, wala ka i jilɔɔtɔ yen, wala ka i yen londanya rɔ, wala ka i farimakolon yen, wala ka i jankarɔto yen, wala ka i bilani yen kaso la, ni an ma i dɛmɛn?› ");
INSERT INTO msc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mansa ri ii jabi: ‹N di tuɲa fɔ ai yɛ. Ai ka ai ban koɲuma kɛla mɔɔ ɲinilu dɔɔmamɔɔ do yɛ mɛn kɛ, ai ka ii ban koɲuma kɛla nde jɛrɛ le yɛ wo ri.› ");
INSERT INTO msc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nba, mɔɔ woilu ri wa tɔrɔ banbali yɔrɔ rɔ. Kɔni mɔɔ telenniilu ri wa to ɲenemaya banbali rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Isa banda kuma wo bɛɛ fɔla tuma mɛn na, a ka a fɔ a la karandenilu yɛ ko: ");
INSERT INTO msc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ai ka a lɔn ko a ra to tele fila ma, Taminkunna Sali ri kɛ. Ni wo lon sera, Mɔɔ Dencɛ ri mira ka a gbɔngbɔn jiri kan ka a faa.» ");
INSERT INTO msc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wo tuma, sarakalasela kuntiiilu ni Yahudiya la mɔɔbakɔrɔilu wara ladɛn diya sarakalasela kuntiiba la bon na. Wo tɔɔ ko Kayifasi. ");
INSERT INTO msc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ii ka i ɲɔɔn yen ka Isa mira ɲa ɲinin kewuya rɔ a faa ko rɔ. ");
INSERT INTO msc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kɔni ii ka a fɔ ko: «an kana a mira sali waati la. Ko ni wo tɛ, mɔɔilu ri wuli ka murunti.» ");
INSERT INTO msc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Awa, Isa wara cɛɛ do wara Betani so kɔndɔ, cɛɛ mɛn tɔɔ ko Simɔn Kunatɔ. ");
INSERT INTO msc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ka Isa siini to dɔɔnnin diya, muso do wulira ka na daa alabasitari ri, mɛn fani latikɔlɔn tulu dagbɛlɛn na. Muso wo ka latikɔlɔn tulu wo burundun Isa kun ma. ");
INSERT INTO msc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Karandenilu ka wo yen tuma mɛn na, ii mɔnɛra ka a fɔ ko: «Tiɲanni ɲin kun ye nfen di? ");
INSERT INTO msc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tulu ɲin tun di se feerela wodi ba la, ka wodi wo kɛ fantanilu dɛmɛnfen di.» ");
INSERT INTO msc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kɔni Isa ka wo mɛn ka a fɔ ii yɛ ko: «Nfenna ai ye muso tɔrɔla? A ra koɲuma kɛ n yɛ, ");
INSERT INTO msc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","baa fantanilu ye ai fɛ waati bɛɛ. Kɔni n tɛna tola ai fɛ yan haan waati bɛɛ de. ");
INSERT INTO msc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Muso ɲin ka latikɔlɔn tulu burundun n fari kan ka a rabɛn n su don kanma. ");
INSERT INTO msc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","N di tuɲa fɔ ai yɛ: kibaro ɲuma ɲin wa lase mɔɔilu ma yɔrɔ yɔrɔ dunuɲa rɔ yan, muso ka mɛn kɛ ɲin, wo fanan di fɔ ye, sa mɔɔilu hankili ri to ale rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wo kɔ rɔ, Isa la karanden mɛn tɔɔ ko Judasi Sikariyɔti, wo wara sarakalasela kuntiiilu tɛrɛn ye. Yahudasi tɛrɛ ye Isa la karanden tan ni fila do le ri. ");
INSERT INTO msc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yahudasi ka a fɔ sarakalasela kuntiiilu yɛ ko: «Ni n ka Isa don ai bolo, ai ri nfen di n ma?» Ii ka wodigbɛ gbanan bisawa di a ma. ");
INSERT INTO msc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ka bɔ lon wo ma, Yahudasi ka fɛrɛ ɲinin ka Isa don ii bolo. ");
INSERT INTO msc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nba, Buru Fununbali Sali lon fɔlɔ rɔ, Isa la karandenilu ka ii madon a la ka a maɲininka ko: «I ye a fɛ an ye Taminkunna Sali dɔɔnnin dabɛn i yɛ mi?» ");
INSERT INTO msc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Isa ka a fɔ ii yɛ ko: «Ai ye wa fakarisa tɛrɛn so kɔndɔ. Ai ye a fɔ a yɛ ko: ‹Karanmɔɔ ka a fɔ ko: «N na waati ra sudunya. Ko n ni n na karandenilu ri Taminkunna Sali kɛ i wara.»›» ");
INSERT INTO msc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Isa ka mɛn fɔ, karandenilu ka a kɛ ten. Ii wara Taminkunna Sali dɔɔnnin dabɛn ye. ");
INSERT INTO msc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Fitiri waati, a ni a la karanden tan ni fila ka ii sii dɔɔnnin diya. ");
INSERT INTO msc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka ii siini to dɔɔnnin na, Isa ka a fɔ ii yɛ ko: «N di tuɲa fɔ ai yɛ: ai rɔ kelen di n don mɔɔ juuilu bolo.» ");
INSERT INTO msc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Karandenilu niilafinda kosɛbɛ kuma wo kosɔn. Ii bɛɛ ka a fɔ a yɛ kelen kelen ko: «Maari, nde le wo ri wa?» ");
INSERT INTO msc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Isa ka a fɔ ko: «N ni mɔɔ mɛn da an bolo bila fɛ kelen de kɔndɔ, wo le n janfala. ");
INSERT INTO msc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mɔɔ Dencɛ ri faa ikomin a sɛbɛni a la ko rɔ ɲa mɛn ma. Kɔni mɔɔ mɛn di a don mɔɔ juuilu bolo, gbalo ye wo tii yɛ. Hali ni wo tii sɔrɔnbali tun tora, wo tun ka fisa a ma paaɔn.» ");
INSERT INTO msc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasi mɛn kɛtɔ Isa donna mɔɔ juuilu bolo, wo ka a fɔ Isa yɛ ko: «Karanmɔɔ, nde le wo ri wa?» Isa ka a jabi: «I jɛrɛ le kan ten.» ");
INSERT INTO msc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nba, ka ii to dɔɔnnin na Isa ka buru ta ka baraka bila Alla yɛ. A ka buru rakadikadi, ka a di ii ma ka a fɔ ii yɛ ko: «Ai ye ɲin mira ka a dɔɔn. N fari le ɲin di.» ");
INSERT INTO msc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wo kɔ rɔ, a ka minninfen ta, rɛsɛnji ye a kɔndɔ. A ka baraka bila Alla yɛ, ka ban ka minninfen di ii ma. A ka a fɔ ko: «Ai bɛɛ ye do min a rɔ. ");
INSERT INTO msc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","N jeli le ɲin di, mɛn ye teriya sidila an tɛma. A bɔnni mɔɔ siyaman de yɛ sa ii la kojuuilu ri makoto. ");
INSERT INTO msc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N di a fɔ ai yɛ ko n tɛna rɛsɛnji minna butun fewu, fɔɔ n ni ai wa a kura min n Fa la mansaya rɔ lon mɛn na.» ");
INSERT INTO msc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Awa, ii ka kalaman bɔ Alla yɛ, ka ban ka wa Olibiye Koyinkɛ kan. ");
INSERT INTO msc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ii seni ye, Isa ka a fɔ ii yɛ ko: «Ai bɛɛ ri ai ban n dɔ, baa a sɛbɛni ko: ‹N di saagbɛngbɛnna gbasi ka a faa, saa kuru ri jɛnsɛn.› ");
INSERT INTO msc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Kɔni ni n wulira ka bɔ saya rɔ, n di wa ai makɔnɔ Kalile mara rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyɛri ka a fɔ Isa yɛ ko: «Hali ni tɔilu bɛɛ ka i bila ka ii bori, n kɔnin tɛna i bilala habadan.» ");
INSERT INTO msc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isa ka a jabi: «N di tuɲa fɔ i yɛ: bi su ɲin dɔ jɛrɛ, sani dondon ye kasi, i ri a fɔ mɔɔilu yɛ haan siɲa sawa ko i ma n lɔn.» ");
INSERT INTO msc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kɔni Piyɛri ka a fɔ a yɛ ko: «N tɛ a fɔ habadan ko n ma i lɔn, hali ni mɔɔilu wulira ile ni nde faala kelen di.» Karanden tɔilu bɛɛ fanan ka a fɔ ten. ");
INSERT INTO msc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nba, Isa ni a la karandenilu sera yɔrɔ do rɔ, mɛn tɔɔ ko Ketisemane. Isa ka a fɔ ii yɛ ko: «Ai ye ai sii yan ka n makɔnɔ. N watɔ ɲɛfɛ dɔɔni Alla matara diya.» ");
INSERT INTO msc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A ka Piyɛri ni Sebede dencɛ fila kili ko ii ye wa a malɔ. Isa niilafinda, a jusu tɔrɔra kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A ka a fɔ ii yɛ ko: «Jusukasi ra wara n ma. A ye ikomin n satɔ le. Ai ye mɛn yan ka ai to ɲana n fɛ.» ");
INSERT INTO msc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A wara ɲɛfɛ dɔɔni, ka a be duu ma ka a ɲa birin. A ka Alla tara ko: «N Fa, ni a ri se bɛnna, i ye nii ɲakankata minninfen ɲin mataa n na, kɔni n jɛrɛ sawo kana kɛ fɔɔ i sawo.» ");
INSERT INTO msc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wo kɔ rɔ, Isa ka a kɔsɛ ka wa karanden sawa tɛrɛn. Ii ye sunɔɔ rɔ. A ka a fɔ Piyɛri yɛ ko: «A se tɛ ai yɛ ka to ai ɲana n fɛ hali waati kelen wa? ");
INSERT INTO msc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ai ye to ai ɲana ka Alla tara, sa ai kana manɛɛn ka bila kojuu rɔ. Sika tɛ a rɔ, sɔlɔmɛ bɛnna a ma kɔni fanka tɛ faribanku la.» ");
INSERT INTO msc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Isa bɔra ii fɛ a siɲa filana rɔ ka wa Alla matara ikɔ tuun. A ka a fɔ ko: «N Fa, ni a ti se bɛnna i ye nii ɲakankata minninfen ɲin mataa n na ko fɔɔ a ye n sɔrɔn, wo rɔ i sawo ye kɛ.» ");
INSERT INTO msc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A kɔsɛ mɛn kɛni karandenilu ma, a ka ii tɛrɛn sunɔɔ rɔ ikɔ tuun, baa sunɔɔ ba tɛrɛ ye ii ɲa rɔ. ");
INSERT INTO msc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wo rɔ, a bɔra ii fɛ ka wa ɲɛfɛ ikɔ tuun, ka Alla tara a siɲa sawana rɔ. A tun ka mɛn fɔ kɔrɔman, a ka wo fɔ ikɔ tuun. ");
INSERT INTO msc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A ka a kɔsɛ ka na karandenilu tɛrɛn ikɔ tuun, ka a fɔ ii yɛ ko: «Ai ye sunɔɔ rɔ fɔlɔ ka ai ɲɔɲɔ wa? Ai ɲa lɔ, waati ra se. Sisen, Mɔɔ Dencɛ kɛtɔ donna kojuukɛlailu bolo. ");
INSERT INTO msc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ai ye ai wuli, an ye wa. Mɛn di n don mɔɔ juuilu bolo, wo ra na.» ");
INSERT INTO msc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nba, ka Isa to kumala, Judasi sera ye, wo mɛn ye Isa la karanden tan ni fila do ri. A ni jama ba nara. Fanmuruilu ni gbelekeilu ye ii bolo. Ii kelayani sarakalasela kuntiiilu ni Yahudiya la mɔɔbakɔrɔilu le bolo. ");
INSERT INTO msc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mɛn kɛtɔ Isa donna ii bolo, a tun ka tɔɔmasere yiraka ii la. A ka a fɔ ko: «N wa n ton mɛn kan ka a sunbu, wo le. Ai ye a mira.» ");
INSERT INTO msc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Awa, Yahudasi ka a madon Isa la i kɔrɔ ka a fɔ a yɛ ko: «Karanmɔɔ, i ni su!» A ka a ton a kan ka a sunbu. ");
INSERT INTO msc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isa ka a jabi: «N duɲɔɔ, i nani mɛn kɛ kanma, i ye wo kɛ.» Wo tuma, ii ka ii kɛ Isa kan, ka a mira. ");
INSERT INTO msc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Isa la karanden do ka a la fanmuru bɔ a laa rɔ ka sarakalasela kuntiiba la jɔncɛ gbasi, ka a tolo kelen tɛɛ a la. ");
INSERT INTO msc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Isa ka a fɔ karanden wo yɛ ko: «I la fanmuru don a laa rɔ! Mɔɔ mɛn wa fanmuru mira kɛlɛkɛ kanma, wo tii fanan di faa fanmuru la. ");
INSERT INTO msc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","I ma a lɔn wa ko n di se n Fa tarala ko a ye n dɛmɛn? Ni n ka a tara ten, a ri mɛlɛka kuru tan ni fila lana n dɛmɛn kanma sisɛn. ");
INSERT INTO msc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɔni ni n ka n Fa tara ten, mɛn sɛbɛni Alla la kitabu kɔndɔ, wo ri se kanbalila di? Baa a sɛbɛni ko ko ɲinilu ka kan ka kɛ ten.» ");
INSERT INTO msc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wo tuma, Isa ka a fɔ jama yɛ ko: «Ai nani n mira diya gbelekeilu ni fanmuruilu ri ikomin mɔɔilu ye bɔla bɛnkanninna kanma ɲa mɛn ma. N siini tɛrɛ mɔɔilu karanna lon lon Allabatobonba jin kɔndɔ. Ai ma n mira ye. ");
INSERT INTO msc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kɔni nabiilu ka mɛnilu sɛbɛ Alla la kitabu kɔndɔ, sa woilu ye kanbali: wo le ka a kɛ, ko ɲinilu bɛɛ kɛni ten.» Isa la karandenilu bɛɛ ka a to ye ka ii bori ka wa. ");
INSERT INTO msc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Awa, Isa mirabailu wara a ri sarakalasela kuntiiba Kayifasi wara. Sariya karanmɔɔilu ni mɔɔbakɔrɔilu ladɛnnin tɛrɛ ye. ");
INSERT INTO msc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ii watɔla Isa ri ye, Piyɛri bilani tɛrɛ ii kɔ. Kɔni a tora yɔrɔ jan. A wara ten fɔɔ ka na se sarakalasela kuntiiba la lu kɔndɔ. A donda ye, ka wa a sii sarakalasela kuntiiba la bon kandaninnailu fɛ, ka a ragbɛ ko ɲin di laban ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sarakalasela kuntiilu ni Yahudiya la kititɛɛla dɛkuru mɔɔilu bɛɛ tɛrɛ ye wuya kuma do ɲininna Isa kanma, mɛn di se ka kɛ a faa sababu ri. ");
INSERT INTO msc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mɔɔ siyaman nara ka wuya fɔ ka kɛ serejuuilu ri. Wo bɛɛ ni a ta, ladɛn mɔɔilu ma jalaki yɔrɔ sɔrɔn Isa kanma. A laban, mɔɔ fila nara ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Cɛɛ ɲin ka a fɔ ko a ri se ka Allabatobonba te, ka ban ka a lɔ ikɔ tele sawa kɔrɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wo rɔ, sarakalasela kuntiiba wulira jama tɛma ka Isa maɲininka ko: «Mɔɔ ɲinilu ye kuma mɛnilu fɔla i ma, i tɛ woilu jabila wa?» ");
INSERT INTO msc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kɔni Isa ka a makun. Sarakalasela kuntiiba ka a fɔ a yɛ ko: «N ye i jamarila Alla ɲenema tɔɔ rɔ ko i ye tuɲa fɔ an yɛ. Ile le ye Ɲenematɔmɔnin di wa, Alla Dencɛ kɔnin?» ");
INSERT INTO msc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isa ka a jabi: «I jɛrɛ le kan ten. Kɔni n di a fɔ ai yɛ ko ai ri Mɔɔ Dencɛ siini yen Sebɛɛtii Alla bolokinin fɛ. Wo kɔ rɔ, ai ri a natɔla yen duruilu tɛma ka bɔ sankolo rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wo rɔ, sarakalasela kuntiiba ka a jɛrɛ la durukiba mira ka a rafara. A ka a fɔ ko: «A ra Alla tanama ko kɛ. An mako tɛ mɔɔilu la sereya la butun. Ai jɛrɛ ka a la Alla tanama kumailu mɛn. ");
INSERT INTO msc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","An ye nfen kɛ wo rɔ?» Ii bɛɛ ka a fɔ ko Isa ni saya ka kan. ");
INSERT INTO msc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mɔɔ doilu wulira ii daji tula a ɲa rɔ, ka a gbasi ii bolokudu la, ka a tolo gbasi. ");
INSERT INTO msc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ii ka a fɔ ko: «Ile, Ɲenematɔmɔnin, i ye kelaya kuma fɔ an yɛ. Mɛn ka i gbasi, wo tɔɔ fɔ an yɛ!» ");
INSERT INTO msc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Awa, wo tuma Piyɛri siini tɛrɛ lu ma. Ka a to ye, jɔnmuso do ka a madon a la, ka a fɔ a yɛ ko: «Ile fanan tɛrɛ ye Kalileka Isa la dɛkuru rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kɔni Piyɛri ma sɔn wo ma mɔɔilu ɲana. A ka muso jabi: «N ma i la kuma ɲayen.» ");
INSERT INTO msc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piyɛri bɔra ye ka wa lu da la. Jɔnmuso gbɛrɛ ka a yen, ka a fɔ ye mɔɔilu yɛ ko: «Cɛɛ ɲin tɛrɛ ye Isa Nasarɛtika la dɛkuru rɔ.» ");
INSERT INTO msc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyɛri ma a lɔ a la. A ka a kali ko: «N ma cɛɛ wo lɔn.» ");
INSERT INTO msc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A ma mɛn ba kɛ, mɔɔ mɛnilu lɔni tɛrɛ ye, woilu ka a fɔ Piyɛri yɛ ko: «Sika tɛ a rɔ, i fanan ye mɔɔ woilu do le ri, baa i kumaɲa ye a yirakala ko i bɔni Kalile.» ");
INSERT INTO msc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piyɛri ka a fɔ ko: «N ye n kalila ko n ma cɛɛ wo lɔn. Ni n ka wuya fɔ, Alla ye ko latɔn n na.» Dondon kasira i kɔrɔ. ");
INSERT INTO msc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Isa tun ka mɛn fɔ, Piyɛri hankili bilara wo rɔ, baa Isa ka a fɔ a yɛ ko: «Sani dondon ye kasi bi, i ri a fɔ mɔɔilu yɛ siɲa sawa ko i ma n lɔn.» Wo rɔ, Piyɛri bɔra ye ka wa kasi kojuuya. ");
INSERT INTO msc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɛnɛ bɔ mɛn kɛni, sarakalasela kuntiilu ni Yahudiya la mɔɔbakɔrɔilu bɛɛ ka ai ɲɔɔn yen ka Isa faa ɲa ɲinin. ");
INSERT INTO msc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ii ka a sidi, ka wa a ri jamanatii Pilate wara. ");
INSERT INTO msc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nba, Judasi mɛn ka Isa don mɔɔilu bolo, wo ka a yen tuma mɛn na ko ii ka kiti labe Isa kan ko a ye faa, a nimisara. Ii nɔ wodigbɛ gbanan bisawa mɛn dila a ma Isa janfa saraya ri, a ka wo lasɛ sarakalasela kuntiilu ni mɔɔbakɔrɔilu ma. ");
INSERT INTO msc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A ka a fɔ ii yɛ ko: «N da kojuu kɛ, baa n ka mɔɔ jalakibali don ai bolo, mɛn kɛtɔ faala.» Ii ka a fɔ ko: «Hɛn! An na ko tɛ wo rɔ. I kunko le wo ri fasayi!» ");
INSERT INTO msc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judasi ka wodigbɛ gbanan woilu lafili Allabatobonba kɔndɔ ye, ka wa a jɛrɛ dun julu la ka a jɛrɛ faa. ");
INSERT INTO msc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sarakalasela kuntiilu ka wodigbɛ gbananilu matɛɛ. Ii ka a fɔ ko: «An kana wodi ɲin bila kankira rɔ Allabatobonba kɔndɔ. Wo dahani tɛ, baa wodi ɲin ye mɔɔ jeli sankɔ le ri.» ");
INSERT INTO msc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ii ka ɲɔɔn yen ka bɛn kan kelen ma. Wo rɔ, ii ka wodi wo ta ka bankudaa ladanna do la sɛnɛ san ko ii ri a kɛ londan kaburuso ri. ");
INSERT INTO msc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wo le kosɔn, haan ka na se bi ma, mɔɔilu ye a fɔla sɛnɛ wo ma ko Mɔɔ Jeli Sɛnɛ. ");
INSERT INTO msc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nabi Jeremiya ka mɛn fɔ fɔlɔfɔlɔ, wo dafara wo ɲa le ma. A ka a fɔ ko: «Ii ka wodigbɛ gbanan bisawa ta, Isirayɛlika doilu ka a fɔ ko a ni wodi jate mɛn ka kan. ");
INSERT INTO msc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ii ka wo di bankudaa ladanna la sɛnɛ sankɔ kanma, ikomin Maari ka n jamari ɲa mɛn ma.» ");
INSERT INTO msc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wo tuma, mɔɔilu ka Isa lalɔ mara jamanatii ɲana. Kunnasiila ka a maɲininka ko: «Ile le Yahudiyailu la mansa ri wa?» Isa ka a fɔ ko: «I jɛrɛ le kan ten.» ");
INSERT INTO msc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sarakalasela kuntiilu ni mɔɔbakɔrɔilu ka a jalaki, kɔni a ma foyi fɔ. ");
INSERT INTO msc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilate ka a fɔ a yɛ ko: «Ii ra sɔn siyaman la i la. I ma wo mɛn wa?» ");
INSERT INTO msc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kɔni Isa ma sɔn ka jabili si di, hali kuma kelen. Wo ka Pilate kabannakoya kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nba, jamanatii darini kasoden kelen bilala Taminkunna Sali waati san san, jama ye a fɛ a ye mɛn bila. ");
INSERT INTO msc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nba, wo ka cɛɛ do tɛrɛn kaso la ye, mɛn tɔɔ ko Barabasi. Wo tɔɔjuu tun da bɔ kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wo rɔ, jama ka ii ladɛn Pilate wara tuma mɛn na, a ka ii maɲininka ko: «Nba, ai ye a fɛ n ye mɔɔ ɲuman de bila ai yɛ? Barabasi wa, wala Isa, mɔɔilu ye a fɔla mɛn ma ko Ɲenematɔmɔnin?» ");
INSERT INTO msc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Baa Pilate ka a lɔn ko keleya le ka a kɛ ii ka Isa don ale bolo. ");
INSERT INTO msc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka Pilate siini to kititɛɛ diya rɔ, a muso ka kela lawa a ma ko: «I kana i sen bila mɔɔ telenni wo la ko rɔ, baa n da tɔrɔ sibo rɔ kosɛbɛ ale le kosɔn bi.» ");
INSERT INTO msc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kɔni sarakalasela kuntiilu ni mɔɔbakɔrɔilu ka jama kɔndasu ko ii ye Pilate madiya ko a ye Barabasi bila ka Isa faa. ");
INSERT INTO msc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kunnasiila ka ii maɲininka ikɔ tuun ko: «Mɔɔ fila ɲin dɔ, ai ye a fɛ n ye mɔɔ ɲuman bila ai yɛ?» Ii ka a fɔ ko: «I ye Barabasi bila.» ");
INSERT INTO msc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate ka ii maɲininka ko: «Ai ye a fɛ n ye nfen kɛ Isa la wo rɔ, mɔɔilu ye a fɔla mɛn ma ko Ɲenematɔmɔnin?» Ii bɛɛ ka a fɔ ko: «A ye gbɔngbɔn jiri kan ka a faa!» ");
INSERT INTO msc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilate ka a fɔ ko: «Nfenna? A ka kojuu ɲuman de kɛ?» Kɔni ii ka do la ii la wɔyɔ kan kan ikɔ tuun ko: «A ye gbɔngbɔn jiri kan ka a faa!» ");
INSERT INTO msc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate ka a yen tuma mɛn na ko a la kuma tɛ foyi ɲala, ko jama muruntitɔ le, a ka ji ta ka a bolo ko jama ɲana, ka a fɔ ii yɛ ko: «N sen ti cɛɛ ɲin jeli labɔn ko rɔ. A ko ye ai bolo.» ");
INSERT INTO msc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mɔɔilu bɛɛ ka a fɔ ko: «Ale le wo ri. A jeli kunko ye be ande ni an denilu ma.» ");
INSERT INTO msc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wo rɔ, a ka Barabasi bila, ka ban ka mɔɔilu lɔ Isa gbasila gbiɲɛ la. Wo kɔ rɔ, a ka Isa don kɛlɛdenilu bolo ko ii ye wa a gbɔngbɔn jiri kan. ");
INSERT INTO msc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kunnasiila la kɛlɛdenilu wara Isa ri mara kunnasiila la mansabolon kɔndɔ, ka kɛlɛden tɔilu bɛɛ kili ko ii ye na. ");
INSERT INTO msc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ii ka a jɛrɛ la faaninilu bɔ a kan na, ka durukiba wulenman kadi kadi bila a kan na. ");
INSERT INTO msc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ii ka jiri bolon wɔninmailu mɔrɔmɔrɔ ii ɲɔɔn ma ka ii kɛ mansa fula munuɲa ri, ka wo la a kun na, ka gbeleke do don a bolokinin dɔ. Wo kɛni, ii ka ii ɲɔnkin a kɔrɔ ka a lafɛya ko: «Yahudiyailu la mansa, an ye i fola.» ");
INSERT INTO msc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ii ka ii daji tu a kan, ka gbeleke mira a bolo ka a gbasi a la a kun dɔ ko siyaman. ");
INSERT INTO msc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ii banni a lafɛyala, ii ka durukiba wulenman kadi kadi bɔ a kan na, ka a jɛrɛ la faaninilu bila a kan na. Wo kɔ rɔ, ii bɔra a ri ka wa a gbɔngbɔn diya. ");
INSERT INTO msc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nba, ii watɔla, ii bɛnda cɛɛ do la, mɛn tɔɔ ko Simɔn Sirɛnika. Kɛlɛdenilu ka a diyagboya ka Isa la gbɔngbɔn jiri la a kan ma. ");
INSERT INTO msc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ii wara se yɔrɔ do rɔ, mɛn tɔɔ ko Kɔlikota. Wo kɔrɔ le ko kunkolo yɔrɔ. ");
INSERT INTO msc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ii seni ye, ii ka rɛsɛnji di Isa ma, fen kunaman ɲaaminni mɛn na. A ka rɛsɛnji wo nene tuma mɛn na, a ma sɔn ka a min. ");
INSERT INTO msc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ii ka Isa gbɔngbɔn jiri kan tuma mɛn na, ii ka matɛɛli kɛ a la faaninilu ratala kanma ii tɛma. ");
INSERT INTO msc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ii banni wo bɛɛ la, ii ka ii sii ka ii janto Isa rɔ. ");
INSERT INTO msc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ii tun ka walan do bila gbɔngbɔn jiri ma Isa kun na. A gbɔngbɔn kun sɛbɛni walan wo kan ko: «Isa le ɲin, ni a ye Yahudiyailu la mansa ri.» ");
INSERT INTO msc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Isa ni bɛnkaninnailu fila gbɔngbɔnda jiriilu kan waati kelen na. Bɛnkaninna kelen gbɔngbɔnda jiri do kan a bolokinin fɛ, a tɔ kelen a bolomaran fɛ. ");
INSERT INTO msc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Taminbatɔilu tɛrɛ ye a nanila, ka ii kun dɔndɔn a kanma. ");
INSERT INTO msc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ii ka a fɔ a yɛ ko: «Hɛn! I ma a fɔ ko i ri se Allabatobonba tela ka a lɔ ikɔ tele sawa kɔrɔ wa? I ye i jɛrɛ kisi. Ni ile le ye Alla Dencɛ ri, i ye jii ka bɔ jiri kan.» ");
INSERT INTO msc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wo ɲa kelen ma, sarakalasela kuntiilu ni sariya karanmɔɔilu ni mɔɔbakɔrɔilu fanan tɛrɛ ye a lafɛyala. Ii ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«A ka doilu kisi, kɔni a ti se a jɛrɛ kisila. Ni a ye Isirayɛlikailu la mansa ri, a ye jii ka bɔ jiri kan! Ni a ka wo le kɛ, an di lemɛniya a ma. ");
INSERT INTO msc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A lani Alla la. Nba, ni a la ko duman Alla yɛ, fɔɔ a ye a kisi sisen, baa a ka a fɔ ko: ‹N ye Alla Dencɛ ri.›» ");
INSERT INTO msc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bɛnkaninna fila mɛnilu gbɔngbɔnni jiri doilu kan a dafɛ, woilu fanan tɛrɛ ye a naninna ten. ");
INSERT INTO msc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nba, tele tala seni, dibi donda jamana fan bɛɛ rɔ. A tora ten haan wura tele la. ");
INSERT INTO msc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wo tuma, Isa wɔyɔra kan ba la ko: «Eli, Eli, lama sabakatani?» Wo kɔrɔ le ko: «N Maari, n Maari. Nfenna i ra n bila?» ");
INSERT INTO msc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɔɔ mɛnilu lɔni tɛrɛ ye, wo doilu ka wo mɛn ka a fɔ ko: «Cɛɛ ɲin ye Nabi Eli le kilila.» ");
INSERT INTO msc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ii tɛma kelen ka a bori ka wa fuu do ta i kɔrɔ, ka a sun rɛsɛnji kumunni rɔ. A ka wo dun kala la ka a la Isa da la ko a ye a min. ");
INSERT INTO msc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɔni tɔilu ka a fɔ ko: «A to ten. An ye a ragbɛ, ni Nabi Eli ri na ka a kisi.» ");
INSERT INTO msc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isa ka kule kan ba bɔ ikɔ tuun, ka a nii di Alla ma ka sa. ");
INSERT INTO msc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wo waati kelen, Allabatobonba tɛɛtɛɛ faanin farara fila ri ka bɔ san ma ka se duu ma. Duukolo yɛrɛyɛrɛra, farakoloilu tera. ");
INSERT INTO msc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kaburuilu dalakara, mɔɔ sɛniman mɛnilu sani, wo siyaman su kununda. ");
INSERT INTO msc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ii bɔra ii la kaburuilu kɔndɔ. Isa wulini kɔ ka bɔ saya rɔ, ii donda Jerusalɛmu, ni a ye so sɛniman di. Mɔɔ siyaman ka ii yen. ");
INSERT INTO msc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rɔmu kɛlɛden kuntii ni kɛlɛden tɔ mɛnilu ye ii jantola Isa rɔ, woilu ka duukolo yɛrɛyɛrɛ yen, ka ko kɛni woilu fanan yen. Wo rɔ, ii silanda kosɛbɛ. Ii ka a fɔ ko: «Tuɲa le, Alla Dencɛ le tɛrɛ cɛɛ ɲin di.» ");
INSERT INTO msc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Muso siyaman tora yɔrɔ jan ka ko woilu ragbɛ. Woilu ni Isa le nani kelen di ka bɔ Kalile. Ii bilani tɛrɛ a kɔ a dɛmɛn kanma. ");
INSERT INTO msc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mariyamu Makidalaka tɛrɛ ye muso woilu rɔ, a ni Yakuba ni Yusufu na Mariyamu, a ni Sebede muso. ");
INSERT INTO msc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nba, su kotɔ le tɛrɛ. Cɛɛ nanfulutii do nara, mɛn tɔɔ ko Yusufu. A bɔni Arimate. Ale fanan tɛrɛ ye Isa la karanden do le ri. ");
INSERT INTO msc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A wara Pilate madiya ko a ye diɲɛ Yusufu ye wa Isa su ta ka a don. Pilate diɲɛra. A ka a la mɔɔilu jamari ko ii ye Isa su di Yusufu ma. ");
INSERT INTO msc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu wara Isa su ta, ka a kasanke faaningbɛ sɛniman do la. ");
INSERT INTO msc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A wara a don kaburu kura kɔndɔ, a tun ka mɔɔilu lɔ mɛn senna farakolo rɔ a jɛrɛ yɛ. Wo kɔ rɔ, a ka kabakurun ba makurukuru ka a la kaburu da la ka wo da tuun. A banni wo la, a bɔra ye ka wa. ");
INSERT INTO msc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyamu Makidalaka ni a tɔɔma Mariyamu siini tɛrɛ ka ii ɲa telen kaburu la. ");
INSERT INTO msc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Isa sara lon mɛn, wo lon tɛrɛ ye Ɲɔɲɔ lon ɲasii lon de ri. Wo duusa gbɛ, sarakalasela kuntiilu ni Farisilu wulira ka wa Pilate tɛrɛn ye. ");
INSERT INTO msc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ii ka a fɔ a yɛ ko: «Maari, an hankili ye a rɔ ko ka wuyafɔla wo to nii na, a ka a fɔ ko tele fila a sawana a ri wuli ka bɔ saya rɔ. ");
INSERT INTO msc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","I ye mɔɔilu lɔ kaburu kɔrɔsila fɔɔ tele sawa wa dafa, baa ni a la karandenilu wara a su ta ka a dokon, ka a fɔ mɔɔilu yɛ ko a ra wuli ka bɔ saya rɔ, wuya wo ri juuya ka tamin fɔlɔmanta kan.» ");
INSERT INTO msc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate ka a fɔ ko: «Kɔnɔgbɛnnailu ye ai bolo. Ai ye ii lawa ka kaburu kandan ii se ko bɛɛ la.» ");
INSERT INTO msc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wo rɔ, ii wara tɔɔmasere kɛ kabakurun kan, ka kɔnɔgbɛnnailu lalɔ ko ii ye kaburu kɔrɔsi koɲuma. ");
INSERT INTO msc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɲɔɲɔ lon taminni kɔ, Lahadi lon sɔɔma da la jona, Mariyamu Makidalaka ni a tɔɔma Mariyamu wara kaburu ragbɛ diya. ");
INSERT INTO msc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I kɔrɔ duukolo yɛrɛyɛrɛra fanka la, baa Maari la mɛlɛka do bɔra sankolo rɔ, ka na kabakurun bɔ kaburu da la, ka a sii kabakurun wo kan. ");
INSERT INTO msc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A ye mɛlɛnmɛlɛnna ikomin sanfɛrɛn. A la duruki gbɛni pepe. ");
INSERT INTO msc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mɔɔ mɛnilu tɛrɛ ye kaburu lakɔrɔsila, woilu silanda mɛlɛka yɛ kojuuya fɔɔ ka be duu ma ka kɛ ikomin mɔɔ saniilu. ");
INSERT INTO msc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mɛlɛka ka a fɔ musoilu yɛ ko: «Ai kana silan. N ka a lɔn ko ai ye Isa le ɲininna, mɛn gbɔngbɔnni tɛrɛ jiri kan. ");
INSERT INTO msc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A tɛ yan, baa a ra wuli ikomin a ka a fɔ ɲa mɛn ma. A su lani tɛrɛ yɔrɔ mɛn dɔ, ai ye na wo ragbɛ. ");
INSERT INTO msc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wo kɔ rɔ, ai borimantɔ ye wa a fɔ a la karandenilu yɛ ko a ra wuli ka bɔ saya rɔ. Ko a watɔ ai makɔnɔla Kalile, ai ri a yen ye. A ragbɛ. N nani mɛn fɔ kanma ai yɛ, wo le wo ri.» ");
INSERT INTO msc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Musoilu ka ii kaliya ka bɔ kaburu da la ka wa. Ii silanni, kɔni sɛwa ba tɛrɛ ye ii la. Ii borimantɔ wara ka kibaro wo bɛɛ fɔ karandenilu yɛ. ");
INSERT INTO msc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ii watɔla, Isa barara bɔla ii ɲɛfɛ ka ii labɛn. A ka a fɔ ko: «N ye ai fola.» Ii ka ii madon a la, ka a sen mira ka a bato. ");
INSERT INTO msc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Isa ka a fɔ ii yɛ ko: «Ai kana silan. Ai ye wa a fɔ n badenmailu yɛ ko ii ye wa Kalile. Ko ii ri n yen ye.» ");
INSERT INTO msc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka musoilu to sila kan ka wa, kaburu kɔrɔsiba doilu wulira ka wa so kɔndɔ. Ko mɛnilu kɛni, ii wara wo bɛɛ fɔ sarakalasela kuntiilu yɛ. ");
INSERT INTO msc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sarakalasela kuntiilu ni mɔɔbakɔrɔilu wara i ɲɔɔn yen ka kuma wo ko rɔ. Ii ban mɛn kɛni kumala, ii ka wodi siyaman di kɛlɛdenilu ma, ");
INSERT INTO msc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka a fɔ ii yɛ ko: «Ai ye a fɔ mɔɔilu yɛ ko: ‹Ka an to sunɔɔ rɔ su rɔ, Isa la karandenilu nara ka a su ta ka wa a ri.› ");
INSERT INTO msc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ni ko ɲin fɔra mara kunnasiila yɛ, an di kuma a yɛ, ka wo kunko bɔ ai ma.» ");
INSERT INTO msc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kɛlɛdenilu ka wodi mira. A fɔra ii yɛ ɲa mɛn ma, ii wara wo kɛ. Wo rɔ, tariku wo ye fɔla Yahudiyailu tɛma hali bi. ");
INSERT INTO msc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Awa, karanden tan ni kelen wara Kalile. Isa ka koyinkɛ mɛn ko fɔ ii yɛ, ii wara ye. ");
INSERT INTO msc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ii ka Isa yen ye tuma mɛn na, ii ka a bato, kɔni doilu sikara. ");
INSERT INTO msc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isa ka a madon ii la, ka a fɔ ii yɛ ko: «Se ra di n ma fen bɛɛ kan Harijeene rɔ, a ni duukolo kan. ");
INSERT INTO msc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wo le rɔ, ai ye wa mɔɔilu kɛ n na karandenilu ri siyailu bɛɛ tɛma. Ai ye ii sun ji rɔ Fa Alla tɔɔ ni Dencɛ tɔɔ ni Nii Sɛniman tɔɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","N ka jamarili fen fen di ai ma, ai ye ii karan woilu la, sa ii ri woilu labato. Ai ɲa lɔ! N ye ai dafɛ tuma bɛɛ, fɔɔ ka wa se dunuɲa laban ma.»");
INSERT INTO msc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ko ba doilu dafanin an tɛma yan. Wo bolo ma, mɔɔ siyaman da wuli ka wo kibaro mafɛnɛ ka a sɛbɛ damira. ");
INSERT INTO msc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mɛnilu ka wo bɛɛ kɛni yen ii ɲa la ka sereya kɛbi a damira waati la, a ni mɛnilu kelayani wo kibaro lasela, woilu ka a bɛɛ lase an ma. Ii ka a lase ɲa mɛn ma, a sɛbɛbailu ye a sɛbɛla wo ɲa le ma. ");
INSERT INTO msc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","N tericɛ ɲuma Teyofili, n fanan da ko wo bɛɛ fɛsɛfɛsɛ kɛbi a damira waati. Wo le rɔ, n da a yen ko n ka kan ka a bɛɛ sɛbɛ koɲuma ka a lawa i ma, ");
INSERT INTO msc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kosa i ri a lɔn ko i karanni ko mɛn na, wo ye tuɲa jɛrɛ jɛrɛ le ri. ");
INSERT INTO msc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Waati wo rɔ, Herodi tɛrɛ ye Jude maratiiyala. Wo tuma, sarakalasela do tɛrɛ ye, mɛn tɔɔ ko Sakariya. A tɛrɛ ye Abiya la sarakalasela dɛkuru le rɔ. A muso, Elisabɛti, fanan tɛrɛ sarakalasela kuntiiba Haruna bɔnsɔn de ri. ");
INSERT INTO msc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariya ni a muso, ii fila tɛrɛ ye mɔɔ telennin de ri Alla ɲakɔrɔ. Ii tɛrɛ ye Maari Alla la sariyailu ni jamari bɛɛ bonyala. ");
INSERT INTO msc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kɔni den tun tɛ ii bolo, baa Elisabɛti tɛrɛ ye densɔrɔnbali le ri. Ii fila tun da kɔrɔya. ");
INSERT INTO msc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lon do rɔ, dakun sera Sakariya la sarakalasela dɛkuru ma ko ii ye wa sarakalase diya Allabatobonba la. ");
INSERT INTO msc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ka bɛn ii la namun ma, Sakariya suwandira ko a ye don Allabatobonba la ka wusulan janin yɔrɔ sɛniman kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wusulan wa kɛ janinna waati mɛn na, jama ba ye Alla matarala kɛnɛ ma Allabatobonba kɔma. ");
INSERT INTO msc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wo tuma, Maari Alla la mɛlɛka nara i lɛnkɛnɛmaya Sakariya ɲakɔrɔ. Mɛlɛka wo ka i lɔ wusulan saraka janin diya bolokinin fɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariya ka mɛlɛka yen tuma mɛn na ka a magban. A silanda kojuuya. ");
INSERT INTO msc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kɔni mɛlɛka ka a fɔ a yɛ ko: «Sakariya, i kana silan. I ra mɛn ɲinin matarali rɔ, Alla ra wo mɛn. I muso Elisabɛti ri dencɛ sɔrɔn i yɛ. I ye den tɔɔ la ko Yaya. ");
INSERT INTO msc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Den wo ri i diya kosɛbɛ. A wa sɔrɔn, mɔɔ siyaman di sɛwa bakɛ wo, ");
INSERT INTO msc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","baa den wo kɛtɔ mɔɔ ba le ri Maari ɲakɔrɔ. A tɛ rɛsɛnji wala dɔlɔ su su min habadan. Kɛbi a na kɔnɔ ma ye a la Alla la Nii Sɛniman ye a fɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A ri kɛ sababu ɲuma ri, mɛn di Isirayɛlikailu siyaman lasɛ Maari Alla ma. ");
INSERT INTO msc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A ri wa Maari ɲɛfɛ, ka Alla la baara kɛ. A la hankili ni a la sebaya ye ikomin Nabi Eli fanan tɛrɛ ye ɲa mɛn ma. Wo rɔ, a ri deni ni ii failu tɛ rabɛn, ka mɔɔ muruntini yɛlɛman ka kɛ mɔɔ sɛbɛ ri, ka Alla la mɔɔilu rabɛn ka ii bila sila bɛrɛ kan.» ");
INSERT INTO msc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya ka mɛlɛka maɲininka ko: «N di la wo la ɲa ɲuman de ma? I ma a lɔn ko n da kɔrɔya wa? N muso fanan da kɔrɔya.» ");
INSERT INTO msc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mɛlɛka ka Sakariya jabi: «Jibirila ye nde ri. N ye n lɔla Alla dafɛ. Ale jɛrɛ ra n kelaya i ma ko n ye na kibaro ɲuma ɲin lase i ma. ");
INSERT INTO msc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awa n da kelaya mɛn fɔ i yɛ, i ma la wo la. Wo rɔ, i kɛtɔ bobo ri fo n na kela wa ban dafala lon mɛn na. Wo lon wa se, kela wo ri dafa fewu!» ");
INSERT INTO msc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nba, mɔɔilu tɛrɛ ye Sakariya makɔnɔ la kɛnɛ ma. Ii kɔndafilira ka a masɔrɔn a tun da mɛn yɔrɔ sɛniman kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakariya bɔ mɛn kɛni kɛnɛ ma, a ma se kumala ii yɛ. Ii ka a yen ko Sakariya ra fen do yen yɔrɔ sɛniman kɔndɔ, baa a tɛrɛ ye kuma tɔɔmasereyala a bolo le la jama ɲana, kɔni a mɛnda boboya rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakariya la baara waati banda tuma mɛn na, a ka kɔsɛ a wara. ");
INSERT INTO msc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A ma mɛn bakɛ wo kɔ, a muso ka kɔnɔ ta. Wo kɔ, Elisabɛti ka karo loolu kɛ a ma bɔ a la wara. ");
INSERT INTO msc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","A ko: «A ragbɛ! Maari ka ko mɛn kɛ n yɛ waati mɛnna, a ka miriya ta ka maloya bɔ n na mɔɔilu ɲana.» ");
INSERT INTO msc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabɛti la kɔnɔmaya karo wɔɔrɔna, Alla ka mɛlɛka Jibirila kelaya Nasarɛti so la, Kalile mara rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A wara se sunkurun do ma ye, mɛn tɔɔ ko Mariyamu. Mariyamu wo tun ma cɛɛ lɔn fɔlɔ. A mamirani tɛrɛ ye cɛɛ do bolo la, mɛn tɔɔ ko Yusufu. Yusufu tɛrɛ ye Mansa Dawuda bɔnsɔn de ri. ");
INSERT INTO msc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mɛlɛka donda Mariyamu kan ka a fɔ a yɛ ko: «N na tuwali ye i yɛ, ile, barakaden. Alla ye ile fɛ.» ");
INSERT INTO msc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tuwali kan wo ka Mariyamu kɔndafili kosɛbɛ. A ma a kɔrɔ lɔn. ");
INSERT INTO msc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mɛlɛka ka a fɔ a yɛ ko: «Mariyamu, i kana silan. I la ko ra diya Alla yɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Awa i ri kɔnɔ ta ka dencɛ sɔrɔn. I ye a tɔɔ la ko Isa. ");
INSERT INTO msc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A ri kɛ mɔɔba ri. Mɔɔilu ri a fɔ ale ma ko Alla Kɔrɔtaninba Dencɛ. Maari Alla ri a benba Mansa Dawuda la mansaya di a ma. ");
INSERT INTO msc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A ri i sii Yakuba bɔnsɔn kun na fɔɔ habadan. A la mansaya ti ban fewu!» ");
INSERT INTO msc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyamu ka mɛlɛka maɲininka wo ma ko: «Wo ri se kɛla di, baa cɛɛ si ma se n ma fɔlɔ?» ");
INSERT INTO msc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mɛlɛka ka a jabi: «Alla la Nii Sɛniman di jii i ma. Alla Kɔrɔtaninba sebaya ri birin i kun na. Wo bolo ma, i ye dencɛ mɛn sɔrɔnna a ye den sɛniman de ri, a ri kili ko Alla Dencɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","I badenma muso Elisabɛti ra harijee dencɛ la a la musokɔrɔbaya waati rɔ. Ale tun da jate densɔrɔnbali le ri, kɔni a kɔnɔ karɔ wɔɔrɔna le ten. ");
INSERT INTO msc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Alla bali ko sa ye.» ");
INSERT INTO msc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyamu ka jabili kɛ ko: «N ye Maari la jɔn de ri. Alla ye a kɛ ka bɛn i kumakan ma.» Mɛlɛka bɔra Mariyamu wo ɲana le ma ka wa. ");
INSERT INTO msc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A ma mɛn bakɛ wo kɔ, Mariyamu ka a rabɛn ka a kaliya ka wa so do la Jude mara koyinkɛ yɔrɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A se mɛn kɛni ye, a donda Sakariya la bon na ka Elisabɛti tuwa. ");
INSERT INTO msc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabɛti ka Mariyamu tuwali kan mɛn tuma mɛn na, a den ka a lamaa bakɛ a kɔnɔ rɔ. Wo tuma, Alla la Nii Sɛniman jiira Elisabɛti rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabɛti ka a kan nabɔ wo baraka rɔ ka a fɔ Mariyamu yɛ ko: «Alla ra ɲumaya kɛ i yɛ ka tamin muso bɛɛ la. I harijeene den mɛn na, Alla ra ɲumaya kɛ wo fanan yɛ!» ");
INSERT INTO msc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Elisabɛti ka a fɔ ikɔ tuun ko: «Nde ye mɔɔ su ɲuman de ri fo n Maari na jɛrɛ ra nabɔ n fɛ yan? ");
INSERT INTO msc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","I ma a yen? N ka i tuwali kan mɛn tuma mɛn na, n den sɛwara ka a lamaa bakɛ n kɔnɔ rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Maari Alla ka mɛn fɔ i yɛ wo lon, i lani a la ko wo ri dafa. Wo bolo ma, muso barakanin de ile ri.» ");
INSERT INTO msc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyamu ka a ko: «N ye Maari bonyala n sɔlɔmɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","N nii da sɛwa ka ɲaalen n Kisiba Alla ko rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","A sɔnda ka a janto n dɔ, a la jɔnmuso fanmajiini. Wo bolo ma, ka damira bi haan ka wa, mɔɔ ri a fɔ n ma ko barakaden, ");
INSERT INTO msc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","baa Alla Sebɛɛtii ra ko ba kɛ n yɛ. A tɔɔ sɛniman dɛ! ");
INSERT INTO msc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Alla ri kininkinin mɔɔilu ma mɛnilu ka a bonya, a ni ii denilu ni ii mamarenilu. ");
INSERT INTO msc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A ra ko ba siyaman kɛ a la fanka rɔ. A ra doilu gbɛn a rɔ, mɛnilu ye jɛrɛdaba ri. ");
INSERT INTO msc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A ra mansaya bɔ mansailu bolo, kɔni a ka mɔɔ fanmajiininilu kɔrɔta. ");
INSERT INTO msc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A ra kɔnkɔtoilu sɔ dɔɔnnin ɲuma rɔ fɔɔ ka iwasa, kɔni a ka nanfulutiilu gbɛn ka ii lawa bolokolonya rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A ma ɲina a la kininkinin mɔɔilu kɔ. Wo rɔ, a ra a la jɔnilu dɛmɛn, Isirayɛlikailu kɔnin. ");
INSERT INTO msc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","A tun ka wo lahidi ta an benba Iburahima ni a bɔnsɔn yɛ fɔɔ ka wa kadawu.» ");
INSERT INTO msc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nba, Mariyamu mɛnda Elisabɛti tɔrɔfɛ ye. A ka karo sawa ɲɔɔn kɛ, ka ban ka wa a wara. ");
INSERT INTO msc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nba, Elisabɛti moyi lon sera. A moyira dencɛ la. ");
INSERT INTO msc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A siiɲɔɔilu ni a badenmailu ka a mɛn ko Maari Alla ra kininkinin a ma ka ko ba kɛ a yɛ. Ii bɛɛ sɛwara. ");
INSERT INTO msc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A sɔrɔn tele seyin, ii bɛɛ nara ka den kojiiya kɛ. Ii tɛrɛ ye a fɛ ka a tɔɔ la a fa Sakariya la. ");
INSERT INTO msc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kɔni a na ka ii jabi: «Wo tɛ bɛn. A tɔɔ le ko Yaya.» ");
INSERT INTO msc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ii ka a sɔsɔ ko: «Ai badenmailu rɔ mɔɔ si tɔɔ tɛ Yaya.» ");
INSERT INTO msc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ii ka kuma Sakariya yɛ ii bolo la, ka a maɲininka den tɔɔ ma. ");
INSERT INTO msc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakariya ka ii jabi a la kuma la a bolo la ko ii ye walan do don a bolo. Ii ka do don a bolo. A ka a ta ka sɛbɛli kɛ a ka a fɔ ko: «Den tɔɔ le Yaya.» Ii bɛɛ ka wo yen ka kabannakoya. ");
INSERT INTO msc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","I kɔrɔ ye, Sakariya da lakara. A sera kumala ikɔ tuun. A ka Alla tando bakɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wo ka ye mɔɔilu bɛɛ masilan. Mɔɔilu bɛɛ tɛrɛ ye a barola ko ɲinilu kan Jude koyinkɛ yɔrɔ wo fan bɛɛ rɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mɛnilu ka kibaro wo lamɛn, woilu tɛrɛ ye i mirila ko: «Den wo ri kɛ mɔɔ su ɲuman di?» Baa, ii ka Alla la baraka yen den kan. ");
INSERT INTO msc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Alla la Nii Sɛniman jiira Sakariya rɔ, ka kelaya ko: ");
INSERT INTO msc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Tandoli ye Isirayɛlikailu Maari Alla yɛ, baa a ra na ka a la mɔɔilu hɔrɔya. ");
INSERT INTO msc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A ra Kisiba di an ma ka bɔ a la jɔncɛ Mansa Dawuda bɔnsɔn dɔ. ");
INSERT INTO msc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","A ra wo kɛ ikomin a la nabi sɛnimanilu ka a fɔ ɲa mɛn ma kɛbi waati jan. ");
INSERT INTO msc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kisiba wo ri an kisi an juuilu ma, ka an bɔ an kɔniyabailu bɛɛ bolo. ");
INSERT INTO msc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A ra hina an failu la, baa a ra a janto a la teriya sɛniman dɔ, ");
INSERT INTO msc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","a ka mɛn sidi an benba Iburahima yɛ kɔnin. ");
INSERT INTO msc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A ko: ko a ri an kisi an juuilu fanka ma. Kosa an kana silan mɔɔilu kɔrɔ, fo ka Alla bato ");
INSERT INTO msc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sɛninya rɔ, a ni telenbaya rɔ. An di baara kɛ a ɲana wo ɲa ma, haan ka an si tele bɛɛ ban.» ");
INSERT INTO msc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","«N den, mɔɔilu ri i kili ko: ‹Alla Kɔrɔtaninba la nabi.› Ka a masɔrɔn i ri wa Maari ɲɛ, ka a la sila rabɛn a yɛ. ");
INSERT INTO msc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A ri kisi ko lɔnninya di a la mɔɔilu ma, tuma mɛn na ii julumun ye a makotola, ");
INSERT INTO msc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","baa an na Maari Alla ye hina tii le ri. Wo bolo ma, a ri kɛnɛ labɔ an yɛ ikomin tele bɔtɔla. ");
INSERT INTO msc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sa mɛnilu ye Alla lɔnbaliya dibi rɔ, a ni mɛnilu silanni saya dibi yɛ, woilu ri bɔ dibi wo bɛɛ rɔ. Sa an di se ka jususuma sila taama.» ");
INSERT INTO msc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nba, den wo bonyara ka kɛ mɔɔ ri, ka sɛɛbɛ sɔrɔn a nii dɔ. A wara to wula kɔndɔ fɔɔ a ka a jɛrɛ yiraka Isirayɛlikailu la lon mɛn. ");
INSERT INTO msc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nba, lon do rɔ, Rɔmu mansaba Ɔjusiti ka a fɔ ko a la mansaya yɔrɔ bɛɛ mɔɔilu bɛɛ ye wa tɔɔ sɛbɛli diya. ");
INSERT INTO msc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kirinisi le tɛrɛ ye jamanatiiya la Siri waati wo la, wo tɔɔ sɛbɛli fɔlɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ka bɛn tɔɔ sɛbɛ ko ma, mɔɔ bɛɛ wara a fa so kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wo rɔ, Yusufu bɔra Nasarɛti, mɛn ye Kalile mara rɔ, ka wa Jude mara rɔ. A wara Bɛtilɛhɛmu, Mansa Dawuda la so kɔnin, ka a masɔrɔn ale ye Mansa Dawuda bɔnsɔn de ri. ");
INSERT INTO msc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariyamu wara a kɔfɛ, mɛn mamirani a bolo la. Ii fila wara ii tɔɔ sɛbɛli diya Bɛtilɛhɛmu. Wo tuma, Mariyamu kɔnɔma le tɛrɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ka ii to Bɛtilɛhɛmu, Mariyamu moyi lon sera. ");
INSERT INTO msc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A moyira a dencɛ fɔlɔ la. A ka faanin miniminin den ɲɛrɛnni ma ka a la kolofen na dɔɔnnin kɛ fen kɔndɔ, baa ii tun ma jiya diya sɔrɔn londan jiya bon na. ");
INSERT INTO msc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wo tuma, saagbɛngbɛnna doilu tɛrɛ ye Bɛtilɛhɛmu so da la. Ii tɛrɛ ye sila ii ɲana waa rɔ ye, ka ii janto ii la saa kuruilu rɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Su wo rɔ, Maari Alla la mɛlɛka do ka a jɛrɛ yiraka woilu la. Maari Alla nɔɔrɔ mɛlɛnda ka ii laminin, ka ii masilan kojuuya. ");
INSERT INTO msc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kɔni mɛlɛka ka a fɔ ii yɛ ko: «Ai kana silan, baa n nani kibaro ɲuma fɔla ai yɛ, mɛn di ai la jamana mɔɔilu bɛɛ lasɛwa kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kisiba ra sɔrɔn ai yɛ bi, Mansa Dawuda la so kɔndɔ. Ale le Maari ri, Ɲenematɔmɔnin kɔnin. ");
INSERT INTO msc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","N ye tɔɔmasere mɛn yirakala ai la: Ai ye wa den ɲɛrɛnni sɔrɔn, a mamini faanin dɔ, a lani soboilu la dɔɔnnin kɛ fen kɔndɔ.» ");
INSERT INTO msc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","I kɔrɔkɔrɔ wo rɔ, wo yɔrɔ kelen dɔ, mɛlɛka siyaman ba bɔra ka na la mɛlɛka fɔlɔman wo kan. Ii bɛɛ ladɛnnin ka Alla tando ko: ");
INSERT INTO msc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Gbiliya ye kɛ Alla yɛ mɛn ye sankolo rɔ. Jususuma ye kɛ mɔɔilu yɛ duukolo kan, mɔɔ mɛnilu duman a yɛ kɔnin.» ");
INSERT INTO msc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mɛlɛkailu kosɛ mɛn kɛni sankolo rɔ, saagbɛngbɛnnailu ka a fɔ i ɲɔɔn yɛ ko: «An ye wa Bɛtilɛhɛmu. Alla ra ko mɛn lase an ma, an ye wa wo lakɔrɔsi.» ");
INSERT INTO msc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ii ka ikaliya ka wa Mariyamu ni Yusufu tɛrɛn. Ii ka den ɲɛrɛnni lani tɛrɛn kolofenilu la dɔɔnnin kɛ fen kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ii ka den wo yen ɲa mɛn ma, ii ka wo bɛɛ dantɛɛli kɛ mɔɔilu yɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mɛnilu ka ii la dantɛɛli kan namɛn, woilu bɛɛ kabannakoyara. ");
INSERT INTO msc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kɔni Mariyamu ka wo bɛɛ to a jusu rɔ ka imiri wo ma kosɛbɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Saagbɛngbɛnnailu wo ka ii kɔsɛ waati mɛn na, ii bɛɛ ka Alla gbiliya ka a tando, ii ka mɛn bɛɛ lamɛn a ni ii ka mɛn bɛɛ yen, a bɛɛ kɛra ikɔ mɛlɛka ka a fɔ ii yɛ ɲa mɛn ma. ");
INSERT INTO msc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Den sɔrɔn ka tele seyin bɔ tuma mɛn, ii ka a la kojii kɛ. A tɔɔ lara ko Isa, mɛlɛka ka tɔɔ mɛn fɔ Mariyamu yɛ, ka a tɛrɛn a tun ma kɔnɔ ta buru. ");
INSERT INTO msc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ii sɛninya waati dafara tuma mɛn, sɛninya waati mɛn sɛbɛni Nabi Musa la sariya rɔ kɔnin, Yusufu ni Mariyamu wara den di Jerusalɛmu. Ii wara a yiraka kanma Maari Alla la, ");
INSERT INTO msc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","baa a sɛbɛni Maari Alla la sariya rɔ ko: «Ni i den fɔlɔ kɛra cɛman di, den wo ye a bila a dan na Maari Alla yɛ.» ");
INSERT INTO msc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Maari Alla la sariya ka saraka mɛn fɔ, ko kanba fila wala kanba wulenni fila, Yusufu ni Mariyamu ka wo bɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wo tuma, cɛɛ do tɛrɛ ye Jerusalɛmu ye, mɛn tɔɔ ko Simeyɔn. Mɔɔ ɲuma le tɛrɛ; a silanni Alla yɛ a ɲa jɛrɛ jɛrɛ ma. Alla tun ka kisiba lahidi mɛn ta Isirayɛlikailu yɛ, Simeyɔn tɛrɛ ye wo dafa makɔnɔla. Alla la Nii Sɛniman tɛrɛ ye Simeyɔn kan. ");
INSERT INTO msc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Alla la Nii Sɛniman tun da a yiraka a la ko a tɛ sa fewu fɔɔ a ɲa wa ban lala Maari la Ɲenematɔmɔnin kan. ");
INSERT INTO msc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nba, Alla la Nii Sɛniman ka Simeyɔn nana Allabatobonba jin kɔndɔ. Wo waati kelen, Yusufu ni Mariyamu nara den di ye ka sariya ko ɲanabɔ. Ii don mɛn kɛni Allabatobonba jin kɔndɔ, ii bɛnda Simeyɔn na. ");
INSERT INTO msc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔn ka den ɲɛrɛnni ta ka Alla tando. A ka a fɔ ko: ");
INSERT INTO msc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Sisen, n Maari Alla, i ri i la jɔn boloka ka wa jususuma dɔ ka bɛn i la kumakan ma. ");
INSERT INTO msc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","N jɛrɛ ɲa ra la i la kisiba kan bi, ");
INSERT INTO msc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","i ka mɛn dabɛn adamadenilu bɛɛ ɲana. ");
INSERT INTO msc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A kɛtɔ kɛnɛbɔlan di, mɛn di i la sila yiraka siya gbɛrɛilu la. A ri bonya di i la mɔɔilu Isirayɛli ma.» ");
INSERT INTO msc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mɛn fɔni Isa ma Simeyɔn bolo, wo ka a fa ni a na kabannakoya. ");
INSERT INTO msc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyɔn duwara ii yɛ, ka ban ka a fɔ Isa na Mariyamu yɛ ko: «I tolo malɔ! Den ɲin di Isirayɛlikailu siyaman nabe, ka siyaman fanan kɔrɔta. A ri kɛ Alla la tɔɔmasere ri, mɔɔ siyaman di i ban mɛn dɔ kɔnin. ");
INSERT INTO msc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wo rɔ, miriya mɛnilu ye mɔɔ siyaman kɔndɔ, woilu ri bila gbɛ rɔ. Kɔni ile, i ri dunin ba sɔrɔn i jusu rɔ. A ri kɛ ikomin fanmuru wa i sɔɔ.» ");
INSERT INTO msc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wo ka Alla la nabi muso do fanan tɛrɛn Allabatobonba kɔndɔ, mɛn tɔɔ ko Ana. A fa, mɛn bɔni Asɛri bɔnsɔn dɔ, a tɔɔ tɛrɛ ye ko Fanuyɛli. Ana ra kɔrɔya bakɛ. A sunkurunya waati, a furura a cɛɛ bolo ka san wɔrɔnwula kɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A furu san wɔrɔnwula, a cɛɛ sara ka a kelen to ye. Sisen, a sɔrɔn tun da san biseyin a ni san naanin bɔ. A ye Allabatobonba kɔndɔ tuma bɛɛ, ka Alla bato su ni tele. A la baara ye sun don di, a ni Alla matara. ");
INSERT INTO msc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana nara se Yusufu ni Mariyamu kɔfɛ. A ka baraka bila Alla yɛ kosɛbɛ, ka ban ka wo den na ko fɔ mɔɔilu yɛ, mɛnilu jii lani Alla ka a fɔ ko a ri Jerusalɛmukailu hɔrɔya ka bɔ ii la tɔrɔya rɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Fen fen fɔni Alla la sariya rɔ, Yusufu ni Mariyamu ka wo bɛɛ kɛ, ka ban ka i kɔsɛ Kalile mara rɔ. Ii wara i sii ii jɛrɛ la so la, Nasarɛti kɔnin. ");
INSERT INTO msc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Denni kunbayara, ka fanka sɔrɔn a fari rɔ. A walijiyara. Alla la ɲumaya ye a kan. ");
INSERT INTO msc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","San san Isa sɔrɔnbailu tun di wa Taminkunna Sali kɛ Jerusalɛmu. ");
INSERT INTO msc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ka bɛn Isirayɛli mɔɔilu la namun ma, Isa ka san tan ni fila sɔrɔn san mɛn na, a fanan wara sali rɔ a sɔrɔnbailu kɔfɛ. ");
INSERT INTO msc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sali ban mɛn kɛni, Isa sɔrɔnbailu ka sila ta ka wa so. Jaa, Isa ra to ii kɔma Jerusalɛmu ye, kɔni ii ma wo lɔn. ");
INSERT INTO msc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iko ii mɔɔ siyaman ba tɛrɛ ye sila kan ka wa so, ii lara a la ko Isa ye ii taama ɲɔɔn do bolo jama tɛma ye. Wo bolo ma, ii ka tele wo muumɛ kɛ taamala. Kɔni fitiri waati seni, ii ma Isa yen fewu! Ii ka a ɲinin ii wara mɔɔilu tɛma, a ni ii taama ɲɔɔnilu. ");
INSERT INTO msc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ii ma a yen. Wo rɔ, ii ka i kɔsɛ ka wa a ɲinin Jerusalɛmu. ");
INSERT INTO msc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A tele sawanan lon, ii donda Allabatobonba jin kɔndɔ ka Isa siini tɛrɛn dina karanmɔɔilu tɛma. A tɛrɛ ye a tolo malɔla ii la ka ɲininkali kɛ ii kun ma. ");
INSERT INTO msc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A la hankilimaya ni a la jabili ka woilu bɛɛ kabannakoya. ");
INSERT INTO msc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A sɔrɔnbailu ka a yen tuma mɛn, ii fanan kabannakoyara. A na ka a maɲininka ko: «N dencɛ, nfenna i ra ko su ɲin kɛ an na? An haminni tɛrɛ kojuuya. An tun da i ɲinin fan bɛɛ ka kaɲa.» ");
INSERT INTO msc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Isa ka a jabi: «Nfenna ai tɛrɛ ye n ɲininna ten? Ai ma a lɔn ko n ye n fa la bon na wa?» ");
INSERT INTO msc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kɔni a sɔrɔnbailu ma wo kɔrɔ lɔn. ");
INSERT INTO msc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Isa wara ii kɔfɛ Nasarɛti, ka to ii bolo ye. A tɛrɛ ye ii kan mirala tuma bɛɛ ka bonya di ii ma. Ko mɛnilu bɛɛ taminni, a na kɔnin ka woilu bɛɛ to a jusu rɔ. ");
INSERT INTO msc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isa tora kunbayala a fari rɔ. A walijiyara. A diyara Alla yɛ, a ni mɔɔilu fanan yɛ. ");
INSERT INTO msc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nba, Rɔmu mansaba Tiberi la mansaya san tan ni looluna, Ponse Pilate tɛrɛ ye Jude mara kun na, ni Herodi tɛrɛ ye Kalile mara kun na, ni a kɔrɔcɛ Filipe tɛrɛ ye Iture ni Tirakoniti marailu kun na, a ni Lisaniyasi tɛrɛ ye Abilɛni mara kun na. ");
INSERT INTO msc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi ni Kayifasi tɛrɛ ye sarakalasela kuntiibaya la. Wo tuma, Alla ka a la kuma lase Sakariya dencɛ Yaya ma wula kɔndɔ. ");
INSERT INTO msc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaya wulira wo rɔ, ka wa kawandili kɛ Juridɛn Ba fan dɔ. A ka a fɔ mɔɔilu yɛ ko ii ye sun ji rɔ tubi kanma, sa Alla ri yafa ii julumun dɔ. ");
INSERT INTO msc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wo kɛra ikomin Nabi Esayi ka a sɛbɛ ɲa mɛn ma ko: «Mɔɔ do ri na a kan nabɔ wula kɔndɔ ka a fɔ mɔɔilu yɛ ko ii ye sila ba rabɛn Maari yɛ, ka ban ka sila denni bɛɛ latelen a yɛ. ");
INSERT INTO msc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dinban kɔndɔla bɛɛ ye lafa. Koyinkɛ ni tindi bɛɛ ye rakanya. Sila rakundunilu ye latelen. Sila juu ye rabɛn ka nunku. ");
INSERT INTO msc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Wo wa kɛ, adamadenilu bɛɛ ri Alla la kisi ko yen.» ");
INSERT INTO msc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jama tɛrɛ ye nala Yaya ma sun ji rɔ kanma. A ka a fɔ doilu yɛ ko: «Aileilu fɔnfɔnni, yon ka Alla la kititɛɛ ɲafɔ ai yɛ? ");
INSERT INTO msc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ai ye kɛwali kɛ ikomin jiri den mɛn da yiraka ko ai tubini. Ai kana a fɔ ai jɛrɛ yɛ ko ‹Iburahima ye an fa le ri.› Baa n ye fɔla ai yɛ ko Alla ri se kaba ɲin kɛla Iburahima denilu di. ");
INSERT INTO msc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sisen, tɛɛran da wuli jiri lulu tɛɛ kanma. Jiri mɛnilu tɛ den ɲuma kɛla, woilu ri tɛɛ ka lafili ta rɔ.» ");
INSERT INTO msc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mɔɔilu ka Yaya maɲininka ko: «An ye nfen de kɛ wo rɔ?» ");
INSERT INTO msc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaya ka ii jabi: «Duruki kɔrɔbila fila ye mɛn bolo, wo ye fɛriyatɔ sɔ duruki kelen na. Dɔɔnin fen tii, wo fanan ye mɔɔ sɔ wo ɲa ma.» ");
INSERT INTO msc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Niisankɔmirala doilu fanan nani sun ji rɔ kanma. Ii ka Yaya maɲininka ko: «Karanmɔɔ, an ye nfen de kɛ wo rɔ?» ");
INSERT INTO msc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A ka a fɔ ii yɛ ko: «Ai ka kan ka jate mɛn mira mansa yɛ, ai ye dan wo ma. Ai kana foyi la wo kan.» ");
INSERT INTO msc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kɛlɛden doilu fanan nara a maɲininka ko: «Andeilu don? Andeilu ka kan ka nfen de kɛ wo rɔ?» A ka ii jabi: «Ai kana mɔɔ bolofen si mira a la fanka la. Ai kana maborili kɛ wuya la fanan. Ai ye ai wasa don ai sara rɔ.» ");
INSERT INTO msc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ii bɛɛ tɛrɛ ye imirila ii jusu rɔ ko: «Mɔɔ Ɲenematɔmɔnin mɛn ko fɔni, Yaya le wo ri wo rɔ wa?» Baa, mɔɔilu tɛrɛ ye wo kisiba makɔnɔla. ");
INSERT INTO msc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ka bɛn ii miriya wo ma, Yaya ka a fɔ ii yɛ ko: «Nde ye ai sunna ji rɔ, kɔni dogbɛrɛ natɔ n kɔ, mɛn fanka ka bon n ta ri. Hali ka n birin ka a la sanbara julu fulɛn a yɛ, wo ka bon nde ma. Ale natɔ ai sunna Alla la Nii Sɛniman dɔ, a ni ta! ");
INSERT INTO msc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A la fɛrɛ ye a bolo, a ri a la sɛnɛ suman bu ni a fofo ni a kisɛ bɔ a ɲɔɔn dɔ fɛrɛ mɛn na. A wa wuli wo baara kanma, a ri suman kisɛ ni a bu bɔ ɲɔɔn dɔ. A ri suman kisɛ kɛ bondon kɔndɔ, ka ban ka bu bɛɛ janin ta la. Ta wo ye ta sabali ri, mɛn tɛ ban habadan.» ");
INSERT INTO msc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yaya ka fen siyaman fɔ ii yɛ, ka ii kawandi, ka Alla la kibaro ɲuma lase ii ma. ");
INSERT INTO msc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yaya ka jamanatii Herodi jalaki fanan, ka a masɔrɔn a tun da a kɔrɔcɛ muso Herodiyasi mira a la. Yaya ka Herodi jalaki kojuu siyaman dɔ. ");
INSERT INTO msc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jalakili wo gbara Herodi la, fɔɔ ka Yaya mira ka a bila kaso la. Herodi ka kojuu kɛ wo rɔ, ka wo fanan la a la kojuu tɔilu bɛɛ kan. ");
INSERT INTO msc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mɔɔilu ye nala sun ji rɔ kanma tuma mɛn na, Isa fanan nara a sun diya ji rɔ. Ka Isa to Alla matarala sun ji rɔ diya ye, sankolo lakara. ");
INSERT INTO msc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Alla la Nii Sɛniman ka kanba fari ɲɔɔn ta ka jii Isa kan. Kumakan do bɔra sankolo rɔ ka a fɔ ko: «N niikan dencɛ le i ri. I duman n yɛ kosɛbɛ!» ");
INSERT INTO msc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Isa bɔra sun ji rɔ diya ka a la baara damira. Wo ka a tɛrɛn a ra san bisawa ɲɔɔn sɔrɔn. Mɔɔilu tɛrɛ a jatela Yusufu dencɛ le ri. Yusufu tɛrɛ Heli den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tɛrɛ Matati den de ri. Matati tɛrɛ Lebi den de ri. Lebi tɛrɛ Mɛlɛki den de ri. Mɛlɛki tɛrɛ Janayi den de ri. Janayi tɛrɛ Yusufu den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu tɛrɛ Matatiyasi den de ri. Matatiyasi tɛrɛ Amɔsi den de ri. Amɔsi tɛrɛ Nahɔmu den de ri. Nahɔmu tɛrɛ Esili den de ri. Esili tɛrɛ Nakayi den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakayi tɛrɛ Maati den de ri. Maati tɛrɛ Matatiyasi den de ri. Matatiyasi tɛrɛ Semi den de ri. Semi tɛrɛ Joseki den de ri. Joseki tɛrɛ Joda den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda tɛrɛ Jowanan den de ri. Jowanan tɛrɛ Resa den de ri. Resa tɛrɛ Serobabɛli den de ri. Serobabɛli tɛrɛ Seyalatiyɛli den de ri. Seyalatiyɛli tɛrɛ Nɛri den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛri tɛrɛ Mɛlɛki den de ri. Mɛlɛki tɛrɛ Adi den de ri. Adi tɛrɛ Kosamu den de ri. Kosamu tɛrɛ Elimada den de ri. Elimada tɛrɛ Eri den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri tɛrɛ Josuwe den de ri. Josuwe tɛrɛ Eliyɛsɛri den de ri. Eliyɛsɛri tɛrɛ Jorimu den de ri. Jorimu tɛrɛ Matati den de ri. Matati tɛrɛ Lebi den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi tɛrɛ Simeyɔn den de ri. Simeyɔn tɛrɛ Yahuda den de ri. Yahuda tɛrɛ Yusufu den de ri. Yusufu tɛrɛ Jonamu den de ri. Jonamu tɛrɛ Eliyakimu den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimu tɛrɛ Mɛliya den de ri. Mɛliya tɛrɛ Mɛna den de ri. Mɛna tɛrɛ Matata den de ri. Matata tɛrɛ Natan den de ri. Natan tɛrɛ Mansa Dawuda den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Mansa Dawuda tɛrɛ Jɛsɛ den de ri. Jɛsɛ tɛrɛ Obedi den de ri. Obedi tɛrɛ Bɔwasi den de ri. Bowosi tɛrɛ Salimɔn den de ri. Salimɔn tɛrɛ Nasɔn den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasun tɛrɛ Aminadabu den de ri. Aminadabu tɛrɛ Adimɛn den de ri. Adimɛn tɛrɛ Arini den de ri. Arini tɛrɛ Hɛsirɔn den de ri. Hɛsirɔn tɛrɛ Pɛrɛsi den de ri. Pɛrɛsi tɛrɛ Yahuda den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda tɛrɛ Yakuba den de ri. Yakuba tɛrɛ Isiyaka den de ri. Isiyaka tɛrɛ Iburahima den de ri. Iburahima tɛrɛ Tera den de ri. Tera tɛrɛ Nahori den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakori tɛrɛ Seruki den de ri. Seruki tɛrɛ Rakawu den de ri. Rakawu tɛrɛ Falɛki den de ri. Falɛki tɛrɛ Ebɛri den de ri. Ebɛri tɛrɛ Sala den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala tɛrɛ Kanaan den de ri. Kanaan tɛrɛ Arifasadi den de ri. Arifasadi tɛrɛ Sɛmu den de ri. Sɛmu tɛrɛ Nuhan den de ri. Nuhan tɛrɛ Lamɛki den de ri. ");
INSERT INTO msc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛki tɛrɛ Metusalemu den de ri. Metusalemu tɛrɛ Hanɔki den de ri. Hanɔki tɛrɛ Yarɛdi den de ri. Yarɛdi tɛrɛ Mahalalɛli den de ri. Mahalalɛli tɛrɛ Kenan den d