﻿USE sofia;
DROP TABLE IF EXISTS sofia.msb_vpl;
CREATE TABLE msb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES msb_vpl WRITE;
INSERT INTO msb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Amo ini an mga kalulululuhi ni Jesu-Cristo na kalahi ni David kag kalahi man ni Abraham. ");
INSERT INTO msb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham ama ni Isaac na ama ni Jacob. Si Jacob naman ama ni Juda kag san iya mga kamaranghod na lalaki. ");
INSERT INTO msb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ini si Juda ama ninda Fares kag Zara na an iloy si Tamar; si Fares naman ama ni Esrom na ama ni Aram. ");
INSERT INTO msb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram ama ni Aminadab na ama ni Naason na ama naman ni Salmon. ");
INSERT INTO msb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon ama ni Booz na an iloy si Rahab. Si Booz naman ama ni Obed na an iloy si Ruth, tapos si Obed ama ni Jesse ");
INSERT INTO msb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na ama san nagin hadi na si David. Tapos, si David ama ni Solomon na an iloy dati asawa ni Urias. ");
INSERT INTO msb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon naman ama ni Roboam na ama ni Abias na ama naman ni Asa. ");
INSERT INTO msb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa ama ni Josafat na ama ni Joram na ama naman ni Ozias. ");
INSERT INTO msb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias ama ni Jotam na ama ni Acaz na ama naman ni Esequias. ");
INSERT INTO msb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esequias ama ni Manases na ama ni Amon na ama naman ni Josias. ");
INSERT INTO msb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ini siya ama ni Jeconias kag san iya mga kamaranghod na lalaki. Sana na panahon nangyari an pagkabihag san mga taga-Israel sa Babilonia. ");
INSERT INTO msb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pakatapos sani: si Jeconias nagin ama ni Salatiel na ama ni Zorobabel. ");
INSERT INTO msb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel ama ni Abiud na ama ni Eliaquim na ama naman ni Azor. ");
INSERT INTO msb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor ama ni Sadoc na ama ni Aquim na ama naman ni Eliud. ");
INSERT INTO msb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud ama ni Eleazar na ama ni Matan na ama naman ni Jacob. ");
INSERT INTO msb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ini siya an nagin ama ni Jose na asawa ni Maria na nagin iloy ni Jesus na ginatawag na Cristo. ");
INSERT INTO msb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kun sugad nagkaigwa sin katorse na kalulululuhan tuna kan Abraham hasta kan David. Nagkaigwa man sin katorse na mga kalulululuhan tuna kan David pakadto sa pagkabihag san mga taga-Israel sa Babilonia. Tapos, katorse naman na kalulululuhan tuna sa pagkabihag sa Babilonia hasta kan Cristo. ");
INSERT INTO msb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Niyan amo ini an pagkaanak kan Jesu-Cristo. San karaslon pa lang an iya iloy na si Maria kan Jose kag wara pa sinda magbiyo, naaraman na niya na nagbudos si Maria. Nangyari ini sa gahom san Espirito Santo pero dili ini aram ni Jose. ");
INSERT INTO msb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kay matanos siya na tawo nag-isip na bulagan si Maria pero sa sikreto lang kay dili niya gusto na maaluhan siya sa kadamuan. ");
INSERT INTO msb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","San ginaisip-isip ini ni Jose, may anghel san Ginoo na nagpakita sa iya sa damgo kag nagsabi, “Jose, kalahi ni David, ayaw pag-alang-alang pag-ako kan Maria na magin asawa mo kay an iya pagbudos paagi sa gahom san Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Magaanak siyaʼn lalaki kag pagangaranan niyo siyaʼn Jesus dahilan na siya an masalbar san iya mga katawuhan sa inda mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nangyari ini tanan agod matuman an ginsabi san Ginoo paagi sa propeta na amo ini, ");
INSERT INTO msb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tandai, may birhen na magabudos tapos magaanak sin lalaki na pagatawagon Emmanuel (na an gusto sabihon, ‘An Dios adi sa aton.’)” ");
INSERT INTO msb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagmata ni Jose gintuman niya an ginsugo sa iya san anghel san Ginoo. Kaya ginpakasalan niya si Maria, ");
INSERT INTO msb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pero wara sinda magdurog hasta na siya nag-anak. Lalaki an gin-anak niya kag pagkatapos an bata ginngaranan ni Jose sin Jesus. ");
INSERT INTO msb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","San gin-anak si Jesus sa lungsod san Betlehem sa probinsya san Judea si Herodes amo an hadi. Sani na panahon may nag-arabot na mga madunong na tawo sa Jerusalem hali sa nasyon sa sirangan. ");
INSERT INTO msb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nagahunga sinda, “Hain an gin-anak na magigin hadi san mga Judio? San sa sirangan pa kami nakita namon an bituon na tanda na siya nabuhay na kaya nagkadi kami agod sambahon siya.” ");
INSERT INTO msb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pakabati sani san hadi na si Herodes kinulbaan gayod siya hasta an tanan na mga taga-Jerusalem. ");
INSERT INTO msb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaya ginpatiripon niya an tanan na mga namumuno san kapadian kag san mga paratukdo san Kasuguan tapos ginhunga kun diin iaanak an Cristo na magigin hadi san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sinabat siya ninda. “Sa Betlehem sa Judea kay ini susog sa ginsurat san propeta, ");
INSERT INTO msb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Lungsod san Betlehem sa kadutaan san mga lahi ni Juda, dili ka gayod an pinakamenos na lungsod didto, kay may mamumuno na mahali sa imo na amo an magapamahala san akon mga katawuhan, an mga taga-Israel.’,” ");
INSERT INTO msb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kaya ginpatawag ni Herodes idtoʼn mga madunong na tawo sa sikreto lang na makigkita sa iya kag ginhunga sa inda kun kasan-o gayod nagpakita an bituon. ");
INSERT INTO msb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pakaaram niya nagtugon sa inda, “Magpa-Betlehem kamo kag hanapon sin maayo an bata. Kun makit-an niyo siya paaramon niyo ako kay agod makakadto man ako kag makasamba sa iya.” ");
INSERT INTO msb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pakabati san ginsabi san hadi nagralakat na sinda. Sa inda paglakat nakita an bituon na nagpakita sa sirangan. Amo ini an nagagiya sa inda hasta na nag-abot sa tungod san lugar na nahuhulidan san bata. Tapos nag-udong. ");
INSERT INTO msb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pakakita ninda sani na nangyari nalipay gayod sinda kag nagsulod sa balay. ");
INSERT INTO msb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pag-abot ninda didto nakit-an an bata kaupod si Maria na iya iloy. Nagruluhod dayon sinda kag nagsamba sa iya. Pakatapos inabrihan an inda mga surudlan kag naghalad sa iya sin mga regalo na oro, mira kag mahal na kamangyan. ");
INSERT INTO msb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Myintras didto pa sinda ginpadaanan sinda san Dios paagi sa damgo na dili magbalik kan Herodes. Kaya nag-uli sinda sa inda sadiri na nasyon na iba na an gin-agihan. ");
INSERT INTO msb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pakahali lang ninda may damgo si Jose. Didi nagpakita sa iya an anghel san Ginoo na nagasabi, “Magbangon ka, iupod an bata kag san iya iloy, tapos dumulag kamo pa-Ehipto kay hahanapon ni Herodes an bata agod patayon. Tapos didto lang anay kamo hasta na sabihan ko ikaw.” ");
INSERT INTO msb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kaya nagbangon dayon si Jose kag gin-upod an bata kag san iloy sani pa-Ehipto sana mismo na gabi. ");
INSERT INTO msb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pakatapos nag-istar sinda didto hasta san pagkamatay ni Herodes. Nangyari ini agod matuman an ginsabi san Ginoo na paagi sa propeta, “Gintawag ko an akon anak hali sa Ehipto.” ");
INSERT INTO msb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Daku-dako gayod an kaurit ni Herodes pakaaram na linuko siya sadtoʼn mga madunong na tawo. Kaya nagsugo siya na patayon didto sa Betlehem kag sa mga baryo sani an tanan na mga bata na lalaki na may duha ka tuig an edad paubos. Susog ini sa panahon na iya naaraman sadtoʼn mga madunong na tawo na nagpakita an bituon. ");
INSERT INTO msb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Paagi sani natuman an ginsabi san propeta na si Jeremias, ");
INSERT INTO msb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“May nabati na tangis, nagabakho kag malanog na pagnguyngoy sa Rama. Ginatangisan ni Raquel an iya mga anak kag habo mag-udong kay sinda tanan patay na.” ");
INSERT INTO msb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Niyan pakapatay ni Herodes may anghel san Ginoo na nagpakita gihapon kan Jose sa damgo didto sa Ehipto na nagasabi, ");
INSERT INTO msb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Magbangon ka, darha an bata kag san iya iloy tapos magkadto kamo sa Israel kay patay na idtoʼn mga nagahandom na ipapatay an bata.” ");
INSERT INTO msb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nagbangon si Jose kag gin-upod an bata kag san iloy sani pakadto sa Israel. ");
INSERT INTO msb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero pakaaram niya na si Arquelao an nagsubli sa iya ama na si Herodes bilang hadi san Judea nahadlok si Jose na magbalik didto. Ugaling dahilan sa ginpadaanan na siya sa damgo naghali siya kag nagpakadto sa Galilea. ");
INSERT INTO msb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Didto naman siya nag-istar sa lungsod na ginatawag na Nazaret. Paagi sani natuman na an ginsabi san mga propeta manungod kan Jesus, “Pagatawagon siya na Nazareno.” ");
INSERT INTO msb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nag-abot an panahon na magapakita si Juan na Parabunyag. Pagpakita niya nagtukdo siya sa Judea sa disyerto. Amo ini an iya mensahe sa mga nagakaradto sa iya, ");
INSERT INTO msb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Magbasol kamo kag magbaya san pagkasala kay haros magtuna an pagahadi san Dios.” ");
INSERT INTO msb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan an ginsambit san propeta na si Isaias san magsabi siya, “May nagasiyak sa disyerto ‘Preparara an agihan para sa pag-abot san Ginoo. Tadunga an iya mga pagaagihan.’” ");
INSERT INTO msb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nakasul-ot si Juan sin bado na himo sa barahibo san hayop na ginatawag na kamelyo. Ginpahaan niya sin anit kag an iya lang pagkaon mga duron kag dugos. ");
INSERT INTO msb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Niyan may nagkaradto sa iya na damu-damo na taga-Jerusalem, taga-Judea kag mga tagaprobinsya sa magluyo san suba san Jordan. ");
INSERT INTO msb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Didto sa suba san Jordan ginbunyagan niya sinda na nagaako san inda kasalan. ");
INSERT INTO msb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","San makita niya na damoʼn mga tawoʼn Pariseo kag mga Saduceo an nagaarabot agod magpabunyag gin-uritan niya sinda, “Kamo na bagaʼn mga sawa, nano, ginaisip niyo na makadulag sa maabot na grabe na kaurit san Dios? ");
INSERT INTO msb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kun nagabasol kamo kag nagbaya san pagkasala, maghimoʼn mga pagpamatuod sani. ");
INSERT INTO msb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pero basi iniisip niyo na dili na niyo kinahanglan magbaya pa sa iyo pagkasala kay si Abraham an iyo kalulululuhi kaya masasalbar na kamo. Ayaw kamo pag-isip sana. Ginasiguro ko sa iyo na bisan mga kalahi kamo ni Abraham kinahanglan niyo magbasol kag magbaya sa pagkasala. Kun habo kamo, kaya san Dios na makahimo sin tunay na mga kalahi ni Abraham hali sani na mga bato didi imbes sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tandai pa ini: bagaʼn mga kahoy kamo kag yana preparado na an wasay na iuutod sa gamot san mga kahoy. Idtoʼn dili nagabungaʼn matahom pagapuludon kag igadabok.” ");
INSERT INTO msb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sabi pa ni Juan sa kadamuan, “Ako an nagapambunyag sa iyo paagi sa tubig bilang tanda na nagbasol kamo san kasal-an kag nagbaya sani pero may maabot na mas makagagahom pa ki sa akon kaya dili ngani ako angay bisan magdara san iya mga sandalyas. Siya an magabunyag sa iyo paagi sa Espirito Santo kag kalayo. ");
INSERT INTO msb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pagabulagon niya an mga maraot na tawo sa mga maayo pareho san paghimalid para ibulag an mga upa kag titipunon naman an mga humay sa kamalig. Tapos an mga upa susunugon niya sa dili mapaparong na kalayo.” ");
INSERT INTO msb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sani naman na panahon si Jesus na hali sa Galilea nagpakadto sa suba san Jordan agod magpabunyag kan Juan. ");
INSERT INTO msb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ginabalibadan kuntani siya ni Juan na nagasabi, “Ako an nagakinahanglan na bunyagan mo pero ikaw lugod an nagkadi sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sinabat siya ni Jesus, “Himuon ta ini yana dahilan na amo ini an dapat mangyari agod matuman an tanan na kagustuhan san Dios.” Kaya nagtugot si Juan kag ginbunyagan si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Niyan pakabunyag kan Jesus naghaw-as siya dayon sa tubig. Tapos nagbuka an langit kag nakita niya an Espirito san Dios na nagapaitsura bagaʼn salampati nagalusad pakadto sa iya. ");
INSERT INTO msb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tapos may boses na nabati hali sa langit, “Ini an akon palangga na anak na ginakalipay ko gayod.” ");
INSERT INTO msb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pakatapos sani gin-giyahan si Jesus san Espirito Santo pakadto sa disyerto agod matintaran san demonyo. ");
INSERT INTO msb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nag-ayuno si Jesus sin 40 na adlaw kag 40 na gab-i. Pakatapos ginutom siya. ");
INSERT INTO msb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sani nag-abot an nagatintar kag sinabihan siya, “Kun matuod na anak ka man gayod san Dios sugua ini na mga bato na magin tinapay.” ");
INSERT INTO msb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero nagsabat si Jesus, “Nasurat sa Banal Na Kasuratan, ‘Dili lang tinapay an makapabuhay sa tawo kundi an kada surmaton san Dios.’,” ");
INSERT INTO msb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pakatapos gin-upod siya san demonyo sa banal na syudad kag pinatindog sa alituktok san templo. ");
INSERT INTO msb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tapos, ginsabihan naman, “Kun matuod na anak ka man gayod san Dios, lumukso ka hali didi kay nasurat, ‘Pagasuguon niya an iya mga anghel na atamanon ka. Kaya pagahuyutan ka ninda agod bisan an imo mga tiil dili masakitan sa bato.’,” ");
INSERT INTO msb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero ginsabihan siya ni Jesus, “Nasurat man, ‘Dili mo dapat pagporbaran an Ginoo na imo Dios.’,” ");
INSERT INTO msb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gin-upod naman siya san demonyo sa tuktok san hataas gayod na bukid kag ginpakita sa iya an tanan na kahadian san kinab-an kag san kabantugan sani. ");
INSERT INTO msb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tapos, sinabihan siya, “Ini tanan ihahatag ko sa imo kun magluhod ka kag magsamba sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero, sinabat siya ni Jesus, “Humali ka, Satanas, kay nasurat, ‘Sambaha an Ginoo na imo Dios kag siya lang gayod an imo dapat pagsirbihan.’,” ");
INSERT INTO msb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pakatapos binayaan siya san demonyo kag nag-arabot an mga anghel agod mag-ataman sa iya. ");
INSERT INTO msb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Niyan pakabarita ni Jesus na ginpapriso si Juan nagbalik siya sa Nazaret sa Galilea. ");
INSERT INTO msb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Dili nagdugay naghali siya didto kag nag-istar sa Capernaum sa higad san danaw na lungsod sa lugar san Zebulun kag Neftali. ");
INSERT INTO msb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nangyari ini agod matuman an ginsabi san propeta na si Isaias na, ");
INSERT INTO msb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mga tawo didto sa lugar san Zebulun kag Neftali, sa may kalundan man sa patabok san Jordan kag sa Galilea na may nagaistar na damo na mga dili-Judio, ");
INSERT INTO msb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","kamo na nabubuhay sa kadulman san kasal-an nakakita sin grabe na kapaw-an. Idto man na mga nagaistar sa lugar na may anino san kamatayon nabanaagan sani!” ");
INSERT INTO msb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuna sadto nagpahayag si Jesus sani na mensahe, “Magbasol kamo san iyo kasal-an kag magbaya sani kay haros magtuna na an pagahadi san Dios.” ");
INSERT INTO msb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Myintras nagalakat si Jesus sa higad san danaw san Galilea nakita niya an magmanghod na Simon na ginatawag na Pedro kag san manghod sani na si Andres. Mga parapangisda sinda kaya adto didto sinda sa lawod nagapanglambat. ");
INSERT INTO msb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nagtawag siya sa inda, “Mag-upod kamo sa akon kay tukduan ta kamo na magin mga parapanglambat sin mga tawo.” ");
INSERT INTO msb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ginbayaan dayon ninda an mga lambat kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sa uruunhan may nakita naman siya na duha pa na magmanghod na sinda Santiago kag Juan na mga anak ni Zebedeo. Adto sinda sa inda sakayan na nagatungkap san inda mga lambat kaupod an ama, tapos gintawag sinda ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kaya ginbayaan man dayon ninda an inda ama na si Zebedeo sa sakayan kag nag-upod naman kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ginpanglibot ni Jesus an bilog na Galilea na nagapangtukdo sa inda mga sinagoga, nagapahayag san Maayo Na Barita san kahadian kag ginapaayo an manlain-lain na sakit kag mga dipirensya sa lawas san mga tawo. ");
INSERT INTO msb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tapos an barita manungod sa iya nakalukop sa bilog na Siria. Kaya gindara sa iya an tanan na mga masakiton na may manlain-lain na ginabatyag kag kasakitan. Amo man an mga nagkasurudlan san maraot na espirito, mga buntugon kag mga paralitiko kag ginpaayo naman niya sinda tanan. ");
INSERT INTO msb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Damo na katawuhan an nagsurunod sa iya. Taga-Galilea sinda, taga-Decapolis, taga-Jerusalem, taga-Judea kag may hali pa sa unhan san Jordan. ");
INSERT INTO msb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pakakita ni Jesus san damu-damo na mga tawo nagsagka siya sa bukid. San mag-ingkod siya nag-arapiki an iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tapos nagtuna siya pagsurmaton kag amo ini an iya katukduan. ");
INSERT INTO msb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Malipay an mga nagaako na kinahanglan gayod ninda an Dios kay para sa inda an kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Malipay an mga nagaagrangay kay pagalipayon. ");
INSERT INTO msb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Malipay an mga mapainubuson kay iiredaron ninda an bilog na kinab-an. ");
INSERT INTO msb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Malipay an mga nagahandom gayod na magtuman san kagustuhan san Dios pareho san tawo na ginagutom kag ginauhaw kay tutumanon san Dios an inda ginahandom. ");
INSERT INTO msb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Malipay an mga maluluy-on kay pagakaluy-an man sinda san Dios. ");
INSERT INTO msb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Malipay an mga may malinis na tagipusuon kay makakaatubang ninda an Dios. ");
INSERT INTO msb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Malipay an mga nagapasiro kay tatawagon sinda na mga anak san Dios. ");
INSERT INTO msb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Malipay an mga ginapasakitan sa pagtuman ninda sa pagbuot san Dios kay para sa inda an kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Malipay kamo kun ginatuya-tuya kamo san mga tawo, ginapasakitan kag ginapakaraot paagi sa mga buwa dahilan sa pagsunod niyo sa akon. ");
INSERT INTO msb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Magsadya kamo kag magkalipay kay dako gali an nakatigana para sa iyo na premyo sa langit. Pareho man sani an pagpasakit sadtoʼn nagkauruna sa iyo na mga propeta. ");
INSERT INTO msb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Pareho kamo san asin para sa kinab-an pero kun an asin mawar-an sin lasa pan-o pa ini mapapaarat gihapon? Wara na iniʼn pulos pa kundi itapok, tapos tamak-tamakan lang san mga tawo. ");
INSERT INTO msb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamo ilaw para sa kinab-an pareho san syudad na nasa ibabaw san bukid dili matatago. ");
INSERT INTO msb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wara gayod sin masindi sin ilawan tapos isusulod la sa baldi kundi ginabutang sa dapat na tungtungan agod makapapawa sa tanan na ada sa sulod san balay. ");
INSERT INTO msb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sugad man kamo talinguhaa na magin ilaw para sa katawuhan na makita man lugod ninda an iyo matanos na hinimuan kaya pagaumawon an iyo Ama na adto sa langit. ");
INSERT INTO msb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ayaw niyo paghunaa na nagkadi ako agod paraon an Kasuguan ni Moises kag an katukduan san mga propeta kundi agod tumanon ini tanan. ");
INSERT INTO msb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ginasiguro ko sa iyo na myintras may langit kag duta waraʼn mapapara na parte o linya sani na Kasuguan hasta na matuman an tanan. ");
INSERT INTO msb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaya pagakilalahon na bantog sa kahadian san langit an magtuman san Kasuguan kag magtukdo sa mga iba na amo man an himuon. Pero ibibilang naman na waraʼn pakinabang sa kahadian san langit an makasala bisan sa usad la na sugo kag magtukdo sa iba na amo man an himuon. ");
INSERT INTO msb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tandaan an ginasabi ko: kun an iyo pagkamatanos dili maglabaw san sa mga Pariseo kag mga paratukdo san Kasuguan dili gayod kamo makasulod sa kahadian san langit.” ");
INSERT INTO msb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nagpadayon si Jesus, “Nabatian na niyo an ginsabi ni Moises sa aton mga kalulululuhi, ‘Dili ka magpatay kay an magpatay pagahusgaran.’ ");
INSERT INTO msb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero amo ini an masasabi ko, bisan an maurit sa iya kapwa pagahusgaran man. An magpakaalo sa iya kapwa pagapaatubangon sa pinakahataas na korte san mga Judio kag an magsabi sa iya kapwa, ‘Buang ka!’ pagahusgaran para sa kalayo sa impyerno. ");
INSERT INTO msb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kaya kun makadto ka sa altar san Dios para maghalad, tapos madumduman mo na an imo kapwa may maraot na buot sa imo, ");
INSERT INTO msb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","insigida bayai anay an imo halad sa atubangan san altar. Tapos kumadto ka sa iya agod makigsiro. Pakatapos bumalik ka kag amo na maghalad. ");
INSERT INTO msb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kun may tawo na masampa sin kaso kontra sa imo, makiulian ka tulos myintras nagapakadto pa lang kamo sa husgado kay basi iintriga ka sa huwes kag ihatag ka niya sa gwardya, tapos prisuhon ka. ");
INSERT INTO msb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kun mangyari dili ka gayod makaluwas hasta na mabayadan an tanan mo na nautang. ");
INSERT INTO msb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nabatian na niyo an nasabi sa Kasuguan, ‘Dili ka magpanambay!’ ");
INSERT INTO msb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero amo ini an masasabi ko, kun may nagaturok sa babayi na may malaw-ay na paghandom nagkasala na siyaʼn pagpanambay sa iya sadiri na tagipusuon. ");
INSERT INTO msb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Usad pa, kun an imo tuo na mata amo an dahilan san imo pagkakasala, lukata kag itapok ina. Mas maayo pa na mawar-an sin usad na parte san imo lawas kisa an bilog mo na lawas itapok sa impyerno. ");
INSERT INTO msb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dili la ina, kun an dahilan san imo pagkakasala amo an imo tuo na kamot, utuda kag itapok. Mas maayo pa na mawar-an sin usad na parte an imo lawas kisa an bilog mo na lawas itapok sa impyerno. ");
INSERT INTO msb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nasabi man sa Kasuguan, ‘Kun may makigbulag sa iya asawa na babayi, dapat na hatagan niya siyaʼn kasuratan san inda pagbulag.’ ");
INSERT INTO msb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero amo ini an masasabi ko, kun may lalaki na makigbulag sa iya asawa dahil sa nano man na dahilan, pwera lang kun nagpanambay na ini, ginapakasala niya siyaʼn panambay kun mag-asawa ini gihapon. Nagakasala man sin pagpanambay an mag-asawa sa babayi na ginbulagan. ");
INSERT INTO msb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nabatian pa niyo an ginsabi ni Moises sa aton mga kalulululuhi kasadto pa, ‘Dili ka magbuwa kundi tumanon an nano man na ginsumpa mo sa Ginoo.’ ");
INSERT INTO msb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Pero amo ini an masasabi ko, ‘Dili ka gayod magsumpa kun magtuga. Ayaw pagsumpa paagi sa pagsambit san langit kay ina an trono san Dios, ");
INSERT INTO msb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni paagi san duta kay ina an tungtungan san iya tiil, ni paagi san Jerusalem kay ina an syudad san Makagagahom na Hadi. ");
INSERT INTO msb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ayaw man pagsumpa na magsambit san imo sadiri na ulo kay bisan usad man san imo buhok dili mo kaya na papution o paitumon. ");
INSERT INTO msb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kaya sabihon mo na lang na oo kun oo an igasabat, kag dili kun dili. Nagahali na sa demonyo an nano man na magsobra pa sana. ");
INSERT INTO msb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Niyan nabati man niyo na nasabi sa Kasuguan, ‘Mata sa mata kag ngipon sa ngipon an pagahusgar niyo.’ ");
INSERT INTO msb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","“Pero amo ini an masasabi ko, ayaw pag-ato sa mga maraot na tawo kundi kun sampadungon ka sa tuo mo na pisngi, pabayaan la siya na sampadungon pa hasta an luyo. ");
INSERT INTO msb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sugad man kun iakusar ka para kuhaon an imo bado, pabayaan la siya na kuhaon pa an imo alikboy. ");
INSERT INTO msb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kun may magpirit sa imo na magpaupod sin usad ka kilometro para magbitbit san iya kargada, updan mo pa hasta sa duha ka kilometro. ");
INSERT INTO msb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tagaan mo an nagapangayo sa imo kag ayaw pagbalibadi an magautang sa imo. ");
INSERT INTO msb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nabatian pa niyo an nasabi sa Kasuguan, ‘Kamut-an niyo an iyo katakin kag kabadlian an iyo kaaway.’ ");
INSERT INTO msb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Pero amo ini an masasabi ko, kamut-an niyo an iyo kaaway kag ipangadyi idtoʼn nagapasakit sa iyo ");
INSERT INTO msb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","agod maipakita niyo na tunay kamo na mga anak san iyo Ama na adto sa langit tungod na siya an nagapasirak san adlaw sa mga maraot kag matanos kag amo man an nagapauran sa inda tanan. ");
INSERT INTO msb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kay kun an mga namumut-an niyo idto lang na may pagkamuot sa iyo ayaw niyo paglaumi na pagapremyuhan kamo san Dios. Nano, dili ginahimo man ina san mga makasal-anon na parasukot san buwis? ");
INSERT INTO msb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kay kun an iyo ginatin-o an iyo lang mga kakilala, nano an kaibahan sa pagkamuot niyo sani sa iba? Nano, dili ginahimo man ina san mga dili-Judio? ");
INSERT INTO msb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaya magpakabanal kamo na pareho man san Dios na iyo Ama sa langit.” ");
INSERT INTO msb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nagpadayon si Jesus, “Paghimat na dili niyo ginahimo an iyo mga maayo na himo agod dayawon lang kamo san mga tawo. Kun himuon niyo ini, dili kamo babalusan san iyo Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaya kun may gusto sa iyo maglimos, ayaw pagpadayaw sa sadiri paagi sa pagpatunog sa trumpita sana mismo na oras na pareho san mga pakitaʼn-tawo lang na ginahimo sa sulod san mga sinagoga kag bisan sa mga kamino agod dayawon sinda san mga tawo. Ginasiguro ko sa iyo na nabaton na ninda an balos. ");
INSERT INTO msb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero kun ikaw maglimos, sa sikreto lang. Halimbawa, ayaw pag-ipaaram sa wala mo na kamot kun nano an ginahimo san imo tuo, ");
INSERT INTO msb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kay agod an imo Ama na amo an nakakita san tanan na ginahimo mo sa sikreto amo an mabalos sa imo. ");
INSERT INTO msb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Niyan kun kamo nagapangadyi ayaw pag-irog sa mga pakitaʼn-tawo lang. Naiila sinda mangadyi na nakatindog sa mga sinagoga kag sa mga kanto san mga kamino agod makita san mga tawo. Ginasiguro ko sa iyo na nabaton na ninda an balos. ");
INSERT INTO msb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero kun ikaw magapangadyi, magsulod sa imo kwarto, sirahi an pwertahan kag mangadyi sa imo Ama na dili nakikita. Tapos siya na maaram san ginhimo mo sa sikreto an mabalos sa imo. ");
INSERT INTO msb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Niyan sa iyo pangadyion ayaw pagparasurmaton sin mga waraʼn pulos pareho san ginahimo san mga dili-Judio kay nagahuna sinda na paagi san inda halaba na mga pagpangadyi babation sinda. ");
INSERT INTO msb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ayaw pag-irog sa inda kay aram na dati san iyo Ama kun nano an kinahanglan niyo antes kamo mangayo sa iya. ");
INSERT INTO msb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pareho sani an iyo pagpangadyi, ‘Ama namon sa langit, pagalangan an banal mo na ngaran, ");
INSERT INTO msb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mag-abot lugod an pagahadi mo sa duta. Matuman man an pagbuot mo didi sugad man sa langit. ");
INSERT INTO msb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hatagi man kami yana san amon kinahanglan na pagkaon. ");
INSERT INTO msb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Patawada kami san amon mga sala pareho san pagpatawad namon san mga nagkasala sa amon. ");
INSERT INTO msb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ayaw man kami pagtuguti na masugtan kundi ilikay kami sa karautan kay ikaw an pinakalabaw na hadi na may poder kag glorya hasta na lang.’ ");
INSERT INTO msb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kaya kun patawadon niyo an mga nagkasala sa iyo, pagapatawadon man kamo san iyo Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero kun dili niyo sinda mapatawad, dili man kamo papatawadon san iyo Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kun mag-ayuno kamo, ayaw pagkuris-ong na pareho san mga pakitaʼn-tawo lang. Sinda nagakuris-ong agod makita san mga tawo na sinda nagaayuno. Ginasiguro ko sa iyo na nabaton na ninda an balos. ");
INSERT INTO msb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero kun mag-ayuno kamo, sudlaya an iyo buhok kag maghiram-os, ");
INSERT INTO msb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agod dili mamangnuhan san mga tawo an iyo pag-ayuno kundi an iyo lang Ama na dili nakikita. Tapos siya na maaram san tanan na ginahimo sa sikreto amo an mabalos sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dili kamo magtipon sin kayamanan didi sa mundo kun diin pagabukbukon, pagakalawangon kag may mga tawo na magapirit pagsulod agod mangawat. ");
INSERT INTO msb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kundi magtipon lugod kamoʼn kayamanan sa Dios sa langit na wara sin makasira bisan bukbok o kalawang kag dili makakawat. ");
INSERT INTO msb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nasabi ko ini kay kun hain an imo kayamanan, adto man an kaila san imo tagipusuon. ");
INSERT INTO msb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Pareho san ilaw an mata para sa lawas. Niyan kun maayo an imo mata, mapapawaan man an bilog na lawas. ");
INSERT INTO msb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero kun maraot an imo mata madulom man an bilog mo na lawas. Kaya, kun an ilaw sa imo madulom, grabe gayod an kadulom sani! ");
INSERT INTO msb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wara sin makapauripon sin sabay sa duha na amo kay pagakabadlian niya an usad kag pagapalabihon an ikaduha. Kun dili sugad sani, magigin matinumanon siya sa usad kag igasikway an ikaduha. Dili kamo pwede makapauripon sin sabay sa Dios kag sa kwarta.” ");
INSERT INTO msb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nagpadayon si Jesus, “Kun sugad, tandaan an ginasabi ko: ayaw kahandal kun nano an iyo kakaunon kag iinumon agod mabuhay. Amo man kun nano an ibabado sa iyo lawas. Nasabi ko ini kay igwaʼn mas mahalaga pa sa pagkabuhay ki sa pagkaon kag sa lawas ki sa bado. ");
INSERT INTO msb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Masdi an mga sapat. Dili ini nagatanom, dili nagaani kag dili nagatipon sa kamalig kundi ginapakaon ini san iyo Langitnon na Ama. Nano, dili mas mahalaga pa kamo kisa sa inda? ");
INSERT INTO msb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kun sa bagay, sin-o man sa iyo an makadagdag sin usad ka oras sa iya pagkabuhay kun magahandal? Wara gayod! ");
INSERT INTO msb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Usad pa, nano kay nahahandal kamo kun nano an iyo ibabado? Masdi niyo kun pan-o nagaturubo an mga burak sa kabukidan. Dili ini nagatrabaho kag dili nagatahi san mga bado. ");
INSERT INTO msb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero tandaan an sasabihon ko sa iyo na bisan si Solomon, na mayaman gayod, wara nakasul-ot sin pareho katahom san usad man sani na mga burak. ");
INSERT INTO msb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Niyan kun ginabaduan ngani san Dios an dinghot na ada yana buhay, kag pagkabuwas igadabok, dili ba kamo nagatuod na kamo mismo mababaduan niya? Mga kulang gayod kamo sin pagtuod! ");
INSERT INTO msb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kaya ayaw kamo kahandal na nagasabi, ‘Nano daw an amon kakaunon? Nano daw an amon iinumon? Nano daw an amon ibabado?’ ");
INSERT INTO msb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ini an mga bagay na ginahandalan san mga dili-Judio pero ayaw niyo pag-iruga sinda kay an tanan na kinahanglan niyo maaram gayod an iyo Langitnon na Ama. ");
INSERT INTO msb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kaya an mas mahalaga amo ini na handuma anay lugod niyo an pagahadi san Dios kag san iya katanusan sa iyo pagkabuhay kay ina tanan na mga bagay igahatag man lang sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ayaw lang kahandal san para sa buwas kay an buwas igwaʼn dapat na atubangon. Tama na sa kada adlaw an sadiri niya na kahandalan.” ");
INSERT INTO msb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nagpadayon si Jesus pagtukdo, “Dili kamo maghusgar agod dili man kamo paghusgaran. ");
INSERT INTO msb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Matuod ini kay kun pan-o kamo maghusgar sa iba amo man an gagamiton paghusgar sa iyo. Sugad man an sukol na ginagamit niyo sa iba amo man an sukol na gagamiton sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nano kay nakikita mo an puling sa mata san imo kapwa na dili mo ngani nanginginanuhan an kahoy sa sadiri mo na mata? ");
INSERT INTO msb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nano kay sasabihon mo pa sa imo kapwa, ‘Kamanghod, pabayaan mo lang na halion ko an puling sa imo mata,’ na igwa ka man sin kahoy sa sadiri mo na mata? ");
INSERT INTO msb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mga pakitaʼn-tawo lang, kuhaa anay an kahoy sa sadiri mo na mata kay agod makakita ka na sin maayo pagkuha san puling sa mata san imo kapwa. ");
INSERT INTO msb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Usad pa, ayaw pag-ipirit na itukdo an surmaton san Dios sa mga tawo na habo magbati. Ina bagaʼn paghatag san mga banal sa kaiduan na basi balikan man lang kamo, tapos duksulan. Pareho man san paglabay san iyo mga perlas sa kababuyan na pagatamak-tamakan lang ini. ");
INSERT INTO msb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kun may kinahanglan ka, mangayo sa Dios kay pagahatagan kamo. Maghanap kay ipapakita niya sa iyo. Magtawag sa iya kay pagaabrihan niya an pwertahan sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Himuon niyo ini kay an nangangayo sa Dios amo an pagahatagan. An nagahanap amo an makakita kag an nagatawag sa iya amo an pagaabrihan san pwertahan. ");
INSERT INTO msb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Niyan, halimbawa, sin-o sa iyo an mahatag sin bato sa iya anak kun mangayo siya sin tinapay? ");
INSERT INTO msb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amo man kun mangayo sa iyo sin isda, nano, hahatagan niyo sin sawa? ");
INSERT INTO msb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kun kamo ngani na mga maraot an ugali pero maaram maghatag sin mga maayo na bagay sa iyo mga kaanakan, sing-ano pa gayod ada an iyo Ama sa langit an mahatag sin mga maayo na bagay sadtoʼn mangayo sa iya! ");
INSERT INTO msb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kaya kun nano an iyo ginahandom na himuon sa iyo san iba, himua man sa inda kay amo ini an katukduan san Kasuguan ni Moises kag san mga propeta. ");
INSERT INTO msb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“May duha na pwertahan para sa pagpili: kun gusto niyo mabuhay, magsulod sa masigpit na pwertahan. Pero dako an pwertahan kag halapad an agihan pakadto sa pagkasira sa impyerno kag damo an nagasulod sani. ");
INSERT INTO msb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero dyutay an pwertahan para sa buhay kag masigpit an agihan pakadto didto. Mga pira lang an nagapili sani. ");
INSERT INTO msb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Paghimat kamo sa mga buwaon na propeta. Makada sinda sa iyo na nagapakitaʼn mapainubuson pareho sa mga karnero pero sa sulod sinda mga simaron na hayop. ");
INSERT INTO msb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makikilala niyo sinda paagi sa inda mga ginahimo pareho man san iyo naaraman sa mga tanom paagi sa bunga sani. Halimbawa, nano, pwede puduon sa katunukan an mga ubas o an bunga san higera? Syimpre dili! ");
INSERT INTO msb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Maayo an bunga san maayo na kahoy pero kun maraot na kahoy, maraot man an bunga. ");
INSERT INTO msb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sugad man dili mamumungaʼn maraot an maayo na kahoy ni an maraot na kahoy mamumungaʼn maayo. ");
INSERT INTO msb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","An kada puno san kahoy na dili namumungaʼn maayo uutudon kag igadabok sa kalayo. ");
INSERT INTO msb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pareho sani makikilala niyo idtoʼn mga buwaon na propeta paagi sa bunga san inda mga ginahimo. ");
INSERT INTO msb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Niyan an mga makasulod sa kahadian san langit dili an tanan na mga nagatawag sa akon sin ‘Ginoo, Ginoo,’ kundi idto lang na nagatuman san kagustuhan san akon Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pag-abot san adlaw san pagsulod sani na kahadian damo an mahunga sa akon sin, ‘Ginoo, Ginoo, nano, dili kami nagsurmaton san mensahe san Dios, nakapahali san mga demonyo kag naghimoʼn mga milagro paagi sa ngaran mo? Kaya, pasuluda man kami.’ ");
INSERT INTO msb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tapos pagasabihan ko sinda, ‘Mga makasal-anon, dili ko kamo kilala kaya magpaharayo kamo sa akon.’ ");
INSERT INTO msb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Niyan an tanan na nagapamati saniʼn akon mga surmaton tapos magatuman sani pareho sinda san madunong na tawo na nagtindog san iya balay sa bato. ");
INSERT INTO msb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Usad na adlaw may bagyo kaya an balay hinampas san makusog na hangin na may uran kag nagbaha pero wara natumba tungod na bato an natindugan. ");
INSERT INTO msb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","An tanan naman na nagapamati saniʼn akon mga surmaton pero dili magatuman sani pareho sinda san patal na tawo na nagtindog san iya balay sa mabaybay na lugar. ");
INSERT INTO msb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tapos may bagyo na nag-abot kaya an balay hinampas san makusog na hangin na may uran kag nagbaha. Tapos natumba ini kag naruba.” ");
INSERT INTO msb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pakatapos pagsurmaton sani ni Jesus, nagngalas an mga kadamuan sa iya katukduan, ");
INSERT INTO msb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","dahilan na nagatukdo siya bilang tawo na may poder kag dili pareho san inda mga paratukdo san Kasuguan san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Paglusad ni Jesus hali sa bukid, damu-damo na mga tawo an nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Didi may leprosohon na nag-apiki kag nagluhod sa atubangan niya tapos nagasabi, “Ginoo, kun gustuhon mo mapaayo mo ako.” ");
INSERT INTO msb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Gin-unat ni Jesus an iya kamot kag gindapatan siya na nagasabi, “Oo, gusto ko. Mag-ayo ka!” Nawara dayon an leproso sani kag malinis na siya. ");
INSERT INTO msb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tapos gintugon siya ni Jesus, “Ayaw gayod pagpanumat bisan kanin-o kundi kumadto ka kag magpakita sa padi. Tapos maghalad ka san regalo susog sa Kasuguan ni Moises bilang pagpamatuod sa mga tawo na nag-ayo ka na.” ");
INSERT INTO msb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pagsulod lang ni Jesus sa Capernaum, may namumuno san mga suldados na Romano na nag-apiki sa iya kag nakimaluoy, ");
INSERT INTO msb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ginoo, may suruguon ako kag adto siya nagahigda na paralisado. Nagatios man siya sin grabe.” ");
INSERT INTO msb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Kun sugad, makadto ako agod ayuhon siya,” an sabi ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nagsabat an namumuno san mga suldados, “Ginoo, dili ako angay na magpadayon sa imo sa akon balay. Pero magsurmaton ka lang kag maaayo an akon suruguon. ");
INSERT INTO msb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nasabi ko ini kay may nagasakop sa akon kag may mga ginasakupan man ako na mga suldados. Kun pagsabi ko sa usad na ‘Lakat,’ malakat siya, kag sa iba naman, ‘Kumadi ka,’ tapos matulos siya. Kun ginasabi ko man sa akon suruguon, ‘Himua ini,’ tutumanon niya.” ");
INSERT INTO msb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pakabati sani ni Jesus nagngalas, inaatubang an kadamuan na nagasurunod sa iya kag nagsurmaton, “Ginasiguro ko sa iyo na wara pa gayod ako makakita sin may pareho saniʼn pagtuod sa bilog na Israel. ");
INSERT INTO msb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tandai ini: damo an magaarabot na hali sa sirangan kag kalundan na makiatubang sa may lamesa kaupod ni Abraham, Isaac kag Jacob didto sa kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero an iba na mga sakop san kahadian na nagasupak sa akon itatapok paluwas sa kaduluman. Didto maganguruyngoy kag magaparagot sinda sa kasakit.” ");
INSERT INTO msb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sinabihan ni Jesus an namumuno, “Lakat. Mangyayari ina susog sa imo pagtuod.” Sadto mismo na kaorason nag-ayo an iya suruguon. ");
INSERT INTO msb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pagsulod ni Jesus sa balay ni Pedro nakita niya an ugangan na babayi ni Pedro na nagahigda kay may kalintura. ");
INSERT INTO msb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gindapatan ni Jesus san iya kamot an babayi tapos hinaw-asan ini san kalintura. Kaya bumangon dayon siya kag nag-asikaso sa iya. ");
INSERT INTO msb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagtunod san adlaw damo an ginpangdara sa iya na nagkasurudlan san mga maraot na espirito kag ginpaluwas niya ini paagi san iya surmaton, kaya gin-ayo an tanan na mga masakiton. ");
INSERT INTO msb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nangyari ini agod matuman an sinabi san propeta na si Isaias, “Ginhali niya an atonmga ginabatyag kag gin-ayo an aton mga sakit.” ");
INSERT INTO msb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","San makita ni Jesus an damu-damo na mga tawo na nagapatalibod sa iya nagsugo siya sa mga disipulos na pasakayon ninda siya patabok san danaw. ");
INSERT INTO msb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Antes sinda magsakay may paratukdo san Kasuguan na naghalapit kag nagsabi sa iya, “Maestro, magaupod ako sa imo bisan magpakain ka.” ");
INSERT INTO msb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Didi sinabihan siya ni Jesus, “May unugan an mga garong kag an mga sapat na nagalupad may mga salag pero ako na Anak San Tawo wara ngani bisan istaran.” ");
INSERT INTO msb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","May iba man na disipulos na nagsabi sa iya, “Ginoo, tuguti ako na makauli anay hasta na ikalubong ko an akon ama.” ");
INSERT INTO msb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero ginsabat siya ni Jesus, “Pabayai na ilubong san mga tawo na bagaʼn patay an inda sadiri na mga patay kundi mag-upod ka sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pakatapos nagsakay si Jesus sa sarakyan kag nag-urupod an iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pagsakay ninda, bigla na lang may subasko sa danaw. Kun kaya nasasabyahan sinda san balod pero natuturog lang si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kaya san nag-apiki sinda sa iya, inda ginpukaw na nagasabi, “Ginoo, isalbar na kami kay malulunod na kita.” ");
INSERT INTO msb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Didi sinabihan niya sinda, “Mga tawo na kulang an pagsarig, nano kay nagakaharadlok kamo?” Tapos pagbangon niya ginsugo an hangin kag mga balod na mag-udong, kaya malinaw na gayod. ");
INSERT INTO msb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nagkangarawa an mga lalaki na an sabi, “Nanoʼn klase ini na tawo na an hangin kag san mga balod nagasunod sa iya?” ");
INSERT INTO msb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pag-abot ni Jesus sa tabok san danaw, sa lugar san Gadarena, may nagsugat sa iya na duha na lalaki hali sa rulubngan na mga kweba. Ini na mga tawo nagkasurudlan sin mga maraot na espirito, kaya mga maisog gayod sinda na wara sin nakaagi sadto na agihan. ");
INSERT INTO msb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Insigida nagsiyak sinda, “Anak san Dios, nano an pakilabot mo sa amon? Nano, nagkadi ka agod pasakitan kami bisan dili pa tama an panahon?” ");
INSERT INTO msb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Niyan nangyari man na may damu-damo na mga baboy an nanginginaon na medyo huruharayo sa inda. ");
INSERT INTO msb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pakakita sani, nakimaluoy an mga demonyo, “Kun pahalion mo kami, pasuluda na lang kami sa kababuyan.” ");
INSERT INTO msb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kaya nagsabi siya, “Sige.” Tapos nagruluwas kag nagsurulod sa kababuyan. Nagharabas ini tanan palusad sa pangpang, nagkahurulog sa danaw kag nagkarulumos sa tubig. ");
INSERT INTO msb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","An mga parabantay naman san kababuyan nagdaralagan palungsod. Didto ninda ginpamarita an tanan lalo na gayod an nangyari sadtoʼn duha na nagkasurudlan san mga maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kaya nagruluwas dayon an tanan na tagasyudad agod sugaton si Jesus. Pakakita ninda sa iya, nakimaluoy na maghali na siya sa inda lugar. ");
INSERT INTO msb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Paghali sadto na lugar, nagsakay gihapon sinda Jesus sa inda sarakyan kag nagtabok pakadto sa iya sadiri na lungsod. ");
INSERT INTO msb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pag-abot didto, may mga lalaki na nagdara sa iya sin paralitiko na nasa higdaan. San mapanginano ni Jesus na ginhimo ninda tungod san inda pagtuod sa iya, nagsabi siya sa paralitiko, “Anak, pakusuga an imo buot. Napatawad na an imo mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dahilan sani may iba na mga paratukdo san Kasuguan na nakahuna-huna, “Ginabasang-basang sanian Dios!” ");
INSERT INTO msb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero aram ni Jesus kun nano an inda ginaisip kaya naghunga siya, “Nano kay nagaisip kamoʼn maraot? ");
INSERT INTO msb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hain sani an mas maayo sabihon, ‘Ginapatawad na an imo mga kasal-an,’ o ‘Bangon kag lakat’? ");
INSERT INTO msb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ugaling pagapamatuudan ko sa iyo agod maaraman niyo na ako na Anak San Tawo may poder magpatawad san mga kasal-an didi sa kinab-an.” Tapos sinabihan niya an paralitiko, “Bangon, bitbita an imo higdaan kag umuli ka.” ");
INSERT INTO msb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bumangon man ini kag umuli na. ");
INSERT INTO msb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pakakita sani, nahahadlok naman an kadamuan kaya gin-umaw an Dios na naghatag sa mga tawo sin poder na pareho sani. ");
INSERT INTO msb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Paghali didto, nagpadayon si Jesus paglakat. Sa uruunhan may nakita siya na parasukot san buwis na an ngaran Mateo. Adto siya nakaingkod sa may kolektahan san buwis. Sinabihan siya ni Jesus, “Mag-upod ka sa akon.” Kaya tumindog naman ini kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Usad na adlaw myintras nakikaon si Jesus sa balay ninda Mateo may nag-arabot na damo na mga parasukot san buwis kag iba na mga parakasala na nag-ingkod man kasabay ni Jesus kag san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pakakita sani san mga Pariseo naghunga sinda sa iya mga disipulos, “Nano kay nakikaon an iyo maestro kasabay san mga parasukot san buwis kag iba na mga makasasala?” ");
INSERT INTO msb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pakabati man sani ni Jesus nagsabat siya, “Dili nagakinahanglan sin duktor an waraʼn sakit kundi an mga masakiton. ");
INSERT INTO msb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sige, arama man kun nano an gusto sabihon san mga surmaton: ‘Kaluoy an gusto ko, dili sakripisyo.’ Matuod na nagkadi ako didi sa kinab-an dili sa pag-agda sa mga matanos kundi sa mga makasasala.” ");
INSERT INTO msb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Niyan nag-arapiki kan Jesus an mga disipulos ni Juan na Parabunyag na naghurunga, “Nano kay dili nagaayuno an imo mga disipulos pareho san amon kag san mga Pariseo?” ");
INSERT INTO msb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ginsabat sinda ni Jesus paagi sa istorya, “Nano, mamumundo daw an mga abay sa kasal myintras kaupod pa ninda an karaslon na lalaki? Syimpre dili, pero maabot an adlaw na pagakuhaon siya sa inda kag amo pa lang sinda makaayuno dahilan san kamunduan.” ");
INSERT INTO msb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tapos gin-istoryahan pa niya sinda para mapahayag na an iya bag-o na katukduan iba sa mga daan. “Waraʼn matangkop sin bag-o na tela sa daan na yamit kay, kun amo ini an iya himuon, an gintangkop na bag-o makuro kag mas lalo na madako an gisi. ");
INSERT INTO msb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sugad man, waraʼn masulod sin bag-o na bino sa daan na anit na surudlan, kay kun sugad, maputok an anit na surudlan kag an bino mawawasak. Kaya an bino masasayang kag masisira an surudlan. Kun kaya an bag-o na bino dapat lugod sa bag-o na anit na surudlan agod mapupuslan an tanan.” ");
INSERT INTO msb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Myintras nakisurmaton pa si Jesus sa inda, may namumuno naman na hali sa sinagoga na nag-apiki kag nagluhod sa atubangan niya na nagsabi, “Namatay pa lang an anak ko na daragita pero kadtua lang tabi kag idapat mo lang sa iya an imo kamot kay siya mabubuhay.” ");
INSERT INTO msb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tumindog dayon si Jesus kag nag-upod. Amo man an iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Didto man may babayi na ginadugo sa sulod san dose ka tuig. Kaya nag-apiki siya sa likod ni Jesus kag gindutdot an sidsid san iya ginasul-ot. ");
INSERT INTO msb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ginhimo niya ini kay inisip niya sa iya sadiri “Kun madutdot ko lang bisan an iya ginasul-ot magaayo na ako.” ");
INSERT INTO msb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Naglingi si Jesus kag pakakita sa iya nagsabi, “Tia, pakusuga an imo buot kay an pagtuod mo sa akon amo an nakaayo sa imo.” Sadto mismo nag-ayo na ngani an babayi. ");
INSERT INTO msb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pag-abot naman ni Jesus sa balay san opisyal, nakita niya an mga paratugtog san plawta kag san kadamuan na makusog an inda pagnguruyngoy. ");
INSERT INTO msb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kaya nagsabi siya, “Hali anay kamo dida kay dili patay an bata kundi natuturog lang.” Gintarawhan siya ninda. ");
INSERT INTO msb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero pakapaluwas san kadamuan, nagsulod si Jesus sa kwarto kun diin an bata, kinaptan an iya kamot kag ini nagbangon. ");
INSERT INTO msb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nakalukop naman ini na pangyayari sa tanan na mga lungsod patalibod sana na lugar. ");
INSERT INTO msb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pagpadayon ni Jesus hali didto, may duha na buta na lalaki na nagsunod sa iya na nagaagrangay sin makusog, “Lahi ni David, kaluy-i kami.” ");
INSERT INTO msb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pagsulod naman ni Jesus sa balay nag-apiki man sa iya an duha na buta. Kaya ginhunga sinda niya, “Nano, nagatuod kamo na mahimo ko ini?” Nagsabat sinda, “Opo, Ginoo.” ");
INSERT INTO msb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pakatapos dinuunan ni Jesus an inda mga mata na nagasabi, “Matuman lugod ini susog sa iyo pagtuod.” ");
INSERT INTO msb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Didi namuklat an inda mga mata. Tapos gintugon sinda ni Jesus, “Talinguhaa na wara gayod sin makaaram sani.” ");
INSERT INTO msb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero naglakat sinda na ginabarita sa tanan na lugar an manungod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pakahali pa lang gayod san duha na buta, may gindara naman sa iya na tawo na naapa kay nasudlan san maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pakapaluwas san maraot na espirito nakasurmaton an dati apa kag nginarat an kadamuan na nagasarabi, “Wara pa gayod sin nangyari na sugad sani sa Israel.” ");
INSERT INTO msb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero nagsabi an mga Pariseo, “Paagi lang san namumuno san mga demonyo an pagpaluwas niya san mga demonyo.” ");
INSERT INTO msb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Niyan ginpanglibot ni Jesus an tanan na mga kalungsudan kag kabaryuhan sadtoʼn lugar na nagatukdo sa inda mga sinagoga, nagapahayag san Maayo Na Barita san kahadian san Dios kag an tanan na may mga sakit kag may mga ginabatyag ginapangayo niya. ");
INSERT INTO msb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pakakita niya sa kadamuan naluoy siya sa inda kay ginasamok kag waraʼn nagaasikaso sa inda bagaʼn karnero na waraʼn nagaataman. ");
INSERT INTO msb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Didi sinabihan ni Jesus an iya mga disipulos, “Bagaʼn bugana na aranihon ini na mga tawo pero kulang lang an paraani. ");
INSERT INTO msb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kaya maghangyo sa Ginoo na tag-iya san aranihon agod magsugo sin mga paraani sa iya aranihon.” ");
INSERT INTO msb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pakasabi ni Jesus sani, gintiripon niya an iya dose na disipulos kag ginhatagan sindaʼn poder agod makapaluwas sin mga maraot na espirito kag agod makabulong san mga may sakit kag san may mga ginabatyag. ");
INSERT INTO msb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","An mga ngaran sani na dose na disipulos na nagin apostoles amo ini: una si Simon na ginatawag Pedro kag san iya manghod na si Andres, tapos an magmanghod na sinda Santiago kag Juan na mga anak ni Zebedeo. ");
INSERT INTO msb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ada man sinda Felipe kag Bartolome, si Tomas kag si Mateo na parasukot san buwis, si Santiago na anak ni Alfeo, si Tadeo, ");
INSERT INTO msb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon na panatiko kag si Judas Iscariote na amo an magatraydor kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Antes ginsugo ni Jesus ini na dose na maglakat agod magpahayag, gintugon sinda sugad sani, “Ayaw kamo pagkadto sa mga lugar san mga dili-Judio kag ayaw pagsulod sa bisan nano na lungsod san mga Samaritano, ");
INSERT INTO msb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kundi kadtua an mga taga-Israel na bagaʼn mga nalalagalag na karnero. ");
INSERT INTO msb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sa iyo paglakat ipahayag na haros magtuna na an pagahadi san Dios. ");
INSERT INTO msb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paayuha an masakiton kag san mga leprosohon, buhayon an patay, kag paluwason an mga demonyo. Nakabaton kamo sani na poder na waraʼn bayad, kaya gamita man ini na dili nagapabayad. ");
INSERT INTO msb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Dili kamo magdara sin kwarta na oro o plata o bronse sa iyo mga pitaka. ");
INSERT INTO msb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sa iyo paglakat dili man kamo magdara sin surudlan, liwanan, sandalyas kag balon kay angay na hatagan an paratrabaho san iya mga kinahanglan. ");
INSERT INTO msb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Sa diin na lungsod o baryo na iyo kadtuan maghunga kun may matanos didto, tapos makiistar sa iya balay hasta na maghali kamo. ");
INSERT INTO msb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagsulod niyoʼn balay, magalang tapos magsabi, ‘Mapasa iyo lugod an kalinaw na hali sa Dios.’ ");
INSERT INTO msb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Niyan kun magpadayon sa iyo an tagbalay, mapasa inda an iyo kalinaw pero kun dili, mapabalik sa iyo an kalinaw. ");
INSERT INTO msb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kun may dili magpadayon sa iyo o mamati sa iyo ginasabi, taphuda anay an alpog sa iyo mga tiil paghali niyo sana na balay o lungsod bilang padaan na may paghusgar na maabot sa inda. ");
INSERT INTO msb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ginasiguro ko sa iyo na sa adlaw san paghusgar mas pagakaluy-an san Dios an mga makasasala na mga taga-Sodoma kag taga-Gomora ki sa mga tawo sana na balay o lungsod.” ");
INSERT INTO msb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nagpadayon pa si Jesus, “Dumduma na ginasugo ta kamo na bagaʼn mga karnero sa tunga san mga maisog na hayop, kaya magin madunong kamo na pareho san mga sawa pero mabuot naman na pareho san mga salampati. ");
INSERT INTO msb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pero maglikay sa mga tawo kay pagaakusaron kamo ninda sa mga konseho, kag pagalatiguhon man kamo sa inda mga sinagoga. ");
INSERT INTO msb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pagabistahon kamo ninda sa atubangan san mga gobernador kag mga hadi dahilan sa pagsunod niyo sa akon. Mangyari ini agod makatestigo kamo sa inda kag sa mga dili-Judio manungod san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero kun iatubang kamo sa inda, ayaw kahandal kun nano an iyo isasabi o kun nano an iyo isasabat kay pag-abot san oras gigiyahan kamo san iyo isasabi. ");
INSERT INTO msb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sana mismo dili kamo an magasurmaton kundi an Espirito Santo san Dios na iyo Ama amo an magasurmaton paagi sa iyo.” ");
INSERT INTO msb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nagsabi man si Jesus, “Sana na panahon may mga tawo na amo mismo an magapapatay sa inda sadiri na mga kamanghod. Amo man an mga ama igapapatay an inda mga anak. Sugad man, may kabataan na magakontra sa inda mga ginikanan kag igapapatay sinda. ");
INSERT INTO msb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kamo naman pagakabadlian san tanan tungod kay kamo an mga nagasunod sa akon pero an mga masasalbar sa paghusgar san Dios amo an mga magpadayon pagsunod sa akon hasta sa katapusan sani. ");
INSERT INTO msb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kun pagapasakiton kamo sa usad na lungsod, dumulag sa masunod. Ginasiguro ko sa iyo na dili pa niyo nalilibot an tanan na lungsod san Israel magaabot na ako na Anak San Tawo.” ");
INSERT INTO msb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nagpadayon si Jesus, “Pareho baga sani, dili malabaw an disipulos sa iya maestro, amo man an suruguon sa iya amo. ");
INSERT INTO msb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tama na sa disipulos kun magin pareho siya sa iya maestro kag an suruguon man sa iya amo. Kaya kun Beelzebul an ginatawag ninda sa akon na amo san tagbalay, sigurado na pagatawagon na kamo sugad sana kay mga kaurupod ko kamo sana na balay. ");
INSERT INTO msb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pero ayaw kamo kahadlok sa inda kay mahahayag an tanan na natatago, kag an tanan na ginatahuban maaaraman. ");
INSERT INTO msb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kaya ihayag niyo sa kapaw-an an ginasabi ko sa iyo sa madulom, kag isiyak sa kaatupan an mabati niyo sa akon sa hutik. ");
INSERT INTO msb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ayaw kamo kahadlok san makapatay san lawas pero dili makapatay san kalag kundi kahadlukan niyo idtoʼn pareho makapatay san lawas kag kalag sa impyerno. ");
INSERT INTO msb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nano, dili ba matuod na manentimos an baligyaan san duha ka maya didi sa aton? Pero dili mahuhulog sa duta bisan usad sani kun dili itugot san iyo Langitnon na Ama. ");
INSERT INTO msb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bisan ngani an iyo buhok binilang tanan san Dios. ");
INSERT INTO msb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaya ayaw gayod kamo kahadlok kay mas mahalaga kamo sa iya ki sa damo na mga maya. ");
INSERT INTO msb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tandai ini: an nagaako sa atubangan san mga tawo na siya para sa akon amo man an pagahimuon ko na Anak San Tawo sa iya sa atubangan san akon Ama na nasa langit. ");
INSERT INTO msb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero an magsabi sa atubangan san mga tawo na dili siya para sa akon amo man an pagahimuon ko sa iya sa atubangan san akon Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ayaw paghunaa na nagkadi ako para magdaraʼn kalinaw sa mga tawo sa kinab-an. Dili kalinaw an akon dara kundi araway. ");
INSERT INTO msb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nagkadi ako agod paawayon ‘an anak na lalaki sa iya ama, an anak na babayi sa iya iloy, an umagad na babayi sa ugangan na babayi. ");
INSERT INTO msb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","An mga magigin kaaway ngani san tawo an kaurupod niya sa panimalay.’ ");
INSERT INTO msb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pwera pa sani dili angay sa akon an tawo na nagapalabi sa iya ama kag iloy sin mas pa sa akon. Amo man an nagapalabi sa anak na babayi o lalaki sin mas pa sa akon. ");
INSERT INTO msb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dili man angay sa akon an habo magdara san iya sadiri na krus na amo an pagtios tungod sa akon tapos makakaupod ko. ");
INSERT INTO msb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mawawar-an lugod sin buhay an nagapasiguro san iya sadiri na buhay, pero an mawawar-an sin buhay alang-alang sa akon magkakaigwa lugod san buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kun may nagapadayon sa iyo, ako man an ginapadayon niya, kag kun ginapadayon niya ako amo man an nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kun may magpadayon sin tawo dahilan na ini propeta man, makabaton siya sin premyo na pareho san para lang sa propeta. Sugad man, may iba na premyo na pareho san para lang sa matanos. Ini naman para sa nagapadayon sa tawo dahilan na ini matanos. ");
INSERT INTO msb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tandai man ini: an sigurado gayod na makabaton sin premyo amo idtoʼn bisan magpainom lang sin matugnaw na tubig sa usad sani na pinakamenos na mga disipulos dahilan na ini akon parasunod.” ");
INSERT INTO msb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pakatuguna ni Jesus sa iya mga disipulos nagpadayon siya paglakat agod magtukdo kag magpahayag san Maayo Na Barita sa mga lungsod sa Galilea. ");
INSERT INTO msb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sadto si Juan na Parabunyag adto sa prisuhan. Pakaarami man niya san manungod sa mga ginahimo ni Cristo, ");
INSERT INTO msb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nagsugo siya sin mga disipulos agod hungaon si Cristo. Pag-abot ninda ginhunga siya ninda, “Sir, nano, ikaw na po an ginasabi sa Banal Na Kasuratan na maabot o mapaabot pa kami sin iba?” ");
INSERT INTO msb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nagsabat si Jesus, “Kadto kag sumati niyo si Juan san iyo nabati kag nakita sugad sani: ");
INSERT INTO msb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nakakita gihapon an mga buta, an mga pilay nakalakat na, naayo naman an mga leprosohon kag an mga bungol nakabati. Nabuhay gihapon an mga patay kag an mga pobre nakabati san Maayo Na Barita na ginapahayag sa inda. ");
INSERT INTO msb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sugad man, malipay idtoʼn dili nawawar-an sin pagtuod sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagharali san mga ginsugo, nagtuna naman pag-istorya si Jesus sa mga katawuhan manungod kan Juan: “Nano an ginalaom niyo na makita san pagkadto sa disyerto? Usad na tawo na pareho sa kadinghutan na ginapalid-palid san hangin? ");
INSERT INTO msb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kun dili sugad sana, nano gayod an ginalaom niyo na makita? Tawo na nakabado sin matahom? Syimpre dili, kay idtoʼn nagabarado sin mga matahom adto nagaistar sa mga palasyo san mga hadi. ");
INSERT INTO msb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kun kaya ngani, nano kay nagkadto kamo? Para makakita sin propeta? Oo, labaw pa gayod sa propeta an nakita niyo, ");
INSERT INTO msb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","kay siya an katumanan san nasurat sa Banal Na Kasuratan, ‘Kitaa, may suruguon ako na mapauna sa imo. Siya an magapreparar san imo aagihan.’ ");
INSERT INTO msb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ginasiguro ko sa iyo, sa tanan na kabataan na gin-anak sa mga babayi, wara na gayod sin nakalabaw kan Juan na Parabunyag. Ugaling mas labaw pa ki sa iya an pinakamenos sa kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Manungod sani na kahadian ginasakyada ini san mga may grabe na pwersa kag ini ginaagaw ninda tuna na nagpahayag si Juan hasta yana. ");
INSERT INTO msb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hasta na nag-abot si Juan ginbarita san mga propeta kag sa Kasuguan ni Moises an manungod san pag-abot san pagahadi san Dios. ");
INSERT INTO msb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Niyan, kun gusto niyo mag-ako ini, si Juan amo an Elias na ginbarita kasadto na magabalik sa kinab-an agod magpreparar para sani na pagahadi. ");
INSERT INTO msb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nagpadayon pa si Jesus, “Sa nano ko maikukumparar an mga tawo na nabubuhay yana? Pareho sinda sa mga kabataan na nagairingkod sa merkado kag nagapasiriyak-siyak sa inda mga kakanam sugad sani, ");
INSERT INTO msb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Gintugtugan namon kamo sin plawta pero dili man kamo nagsarayaw. Tapos nagkanta naman kamiʼn mamunduon pero wara kamo pagtarangis.’ ");
INSERT INTO msb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Sugad man, pagkita san mga tawo na an ugali ni Juan pag-ayuno kag waraʼn pag-inom sin bino nagasabi sinda, ‘Nasudlan siya sin demonyo.’ ");
INSERT INTO msb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nakita naman ninda ako na Anak San Tawo na an ugali mag-inom sin bino kag dili mag-ayuno kag niyan nagasabi sinda, ‘Kitaa an makagod kag parahubog. Nakiamigo ngani siya sa mga parasukot san buwis kag sa iba na mga parakasala.’ Ugaling an mga himo amo an nakapamatuod san kadunungan.” ");
INSERT INTO msb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pakatapos sani ginpanguritan ni Jesus an mga katawuhan sa mga lungsod kun diin siya nagpanghimoʼn damo na mga milagro kasadto kay habo sinda magbaya san inda kasal-an. ");
INSERT INTO msb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sabi niya, “Kamakaluluoy niyo na mga taga-Corazin! Kamakaluluoy man niyo na taga-Betsaida! Kun an ginhimo na mga milagro sa iyo, didto paghimua kasadto sa maraot na mga syudad san Tiro kag Sidon na ginasira san Dios, dugay na an mga tagadidto nagsul-ot sin bado na sako kag nagsaburak sin abo sa inda mga ulo agod ipakita na sinda nagabasol kag nagabaya san inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero tandai ini, sa adlaw san paghusgar mas pagakaluy-an san Dios an mga taga-Tiro kag mga taga-Sidon ki sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kamo naman na mga taga-Capernaum, nano, gusto ba niyo na magpakamatanos pareho san sa langit? Itatapok lugod kamo sa impyerno. Kay kun an mga milagro na ginhimo sa iyo, ginhimo didto sa lungsod san Sodoma na nasira, hasta yana adto pa ini. ");
INSERT INTO msb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero tandai ini: sa adlaw san paghusgar mas pagakaluy-an san Dios an mga maraot na taga-Sodoma ki sa iyo.” ");
INSERT INTO msb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tapos nangadyi si Jesus, “Ama, na Ginoo san langit kag duta, nagapasalamat ako sa imo kay gintago mo ini na kaaraman sa mga madunong kag mga may pagsabot pero ginhayag mo sadtoʼn mga maluya an pagsabot sugad san mga dyutay na bata. ");
INSERT INTO msb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Opo, Ama, kay ginkalipay mo an pagahimo sani.” ");
INSERT INTO msb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tapos nagpadayon siya gihapon pagsabi sa mga tawo, “An tanan na poder ginhatag sa akon san akon Ama. Waraʼn nakakakilala sa Anak kundi an Ama. Wara man sin nakakakilala sa Ama kundi an Anak kag sadto man na mga ginagusto san Anak na pahayagan san manungod sa Ama. ");
INSERT INTO msb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kamo tanan na napapagal, kadi sa akon. Kamo na nabubug-atan san kahandalan, kadi man, kay papapahuwayon ta kamo tanan. ");
INSERT INTO msb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pas-ana an akon yugo. Tapos tugutan ako na magtukdo sa iyo kay mabuot ako kag maluluy-on. Kun sugad, magkakaigwa kamo sin kalinaw sa tagipusuon, ");
INSERT INTO msb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kay masayon lang darhon an akon yugo kag magaan an akon pas-anon.” ");
INSERT INTO msb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sadto na panahon na Adlaw San Pagpahuway nag-aragi sinda Jesus sa katriguhan. Ginurutom an iya mga disipulos kaya nagtuna sinda magpamudo sin mga bunga kag pakapaniti ginakaraon. ");
INSERT INTO msb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pero pakakita sani san mga Pariseo ginsabihan siya ninda, “Kitaa an imo mga disipulos kay nagahimo san dili dapat himuon sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ginhunga man niya sinda, “Nano, wara pa kamo kabasa kun nano an ginhimo ni David san ginutom siya kag sadtoʼn mga kaurupod niya? ");
INSERT INTO msb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nangyari ini san magsulod siya sa templo san Dios kag ginkuha an mga tinapay na ginhalad sa Dios na dili ngani sinda dapat magkaon kundi an mga padi lang pero kinaraon ninda. ");
INSERT INTO msb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Usad pa. Nano, dili man niyo nabasa sa Kasuguan na an mga padi sa templo ginasupak an Adlaw San Pagpahuway pero dili sinda nagakasala? ");
INSERT INTO msb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero amo ini an sasabihon ko sa iyo, adi an mas labaw pa ki sa templo. ");
INSERT INTO msb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kaya kun nasabutan lang niyo an gusto sabihon san mga surmaton, ‘dili sakripisyo an gusto ko kundi kaluoy,’ dili niyo ginhusgaran idtoʼn mga dili nagkasala. ");
INSERT INTO msb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nasabi ko ini kay ako na Anak San Tawo amo an Ginoo na makabuot sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Paghali didto nagpakadto si Jesus sa inda sinagoga. ");
INSERT INTO msb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sana man mismo may lalaki didto na kimay. Kaya sa paglaom na may ikaakusar kontra kan Jesus naghunga sa iya an mga Pariseo, “Nano, kontra ba sa aton Kasuguan an pagpamulong kun Adlaw San Pagpahuway?” ");
INSERT INTO msb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ginsabat sinda ni Jesus, “Kun igwa didi sa iyo sin may karnero na mahulog sa buho na hadalom sa Adlaw San Pagpahuway, nano, dili niya ini kuhaon? Syimpre! ");
INSERT INTO msb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas lalo pa na mahalaga an tawo ki sa karnero. Sugad man, susog sa Kasuguan an paghimoʼn kaayuhan sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kaya ginsabihan niya an lalaki, “Iunat an imo kamot.” Gin-unat man sani kag an iya pagkakimay nag-ayo na kag kapareho na ini san sa luyo. ");
INSERT INTO msb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dahilan sani nagruluwas an mga Pariseo kag nagtuna pagplano kontra kan Jesus kun pan-o siya ninda maipapatay. ");
INSERT INTO msb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pakaarami sani ni Jesus naghali siya sadto na lugar. Damo na mga tawo an nagsurunod sa iya kag gin-ayo niya an tanan na may ginabatyag, ");
INSERT INTO msb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","pero pinadaanan niya sinda na dili siya igpamarita. ");
INSERT INTO msb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ginhimo niya ini agod matuman an ginsabi san propeta na si Isaias: ");
INSERT INTO msb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Adi an akon suruguon na pinili ko. Siya an akon palangga na ginakalipay ko gayod. Ihahatag ko sa iya an akon Espirito kag igapahayag niya an matuod na hustisya sa tanan na tawo. ");
INSERT INTO msb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Dili siya makigsuay, dili magsiyak kag wara gayod sin bisan makabati san iya boses sa mga kamino. ");
INSERT INTO msb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pareho san buak na bagakay kag san nagakipat-kipat na lampara an mga kulang san pagtuod sa iya. Pero dili siya magabari kag dili magaparong sa inda kundi pagapakusugon niya an inda pagtuod hasta na an hustisya san Dios ipalukop niya sa tanan na lugar. ");
INSERT INTO msb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tapos an mga tawo didto sa tanan na nasyon magasarig sa iya.” ");
INSERT INTO msb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pakatapos may gindara kan Jesus na tawo na nasudlan sin maraot na espirito na nakapabuta kag nakapaapa sa iya. Gin-ayo siya ni Jesus kaya nakasurmaton kag nakakita gihapon. ");
INSERT INTO msb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nangawa an tanan na katawuhan sa ginhimo ni Jesus kaya nagahurunga-hunga, “Dili kaya ini an kalahi san dati hadi na si David?” ");
INSERT INTO msb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero pakabati sani san mga Pariseo, nagsabi, “Paagi lang kan Beelzebul na namumuno san mga demonyo an pagpaluwas niya san mga demonyo.” ");
INSERT INTO msb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aram ni Jesus an inda ginaisip kaya sinabihan niya sinda, “Maruruba an kahadian na pirme may araraway sa inda mismo. Amo man magaburulag an syudad o pamilya na pirme may araraway sa inda mismo. ");
INSERT INTO msb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kaya kun ginapaluwas ni Satanas an iya sadiri na mga sakop, may pag-araraway sa iya mismo. Kun sugad, pan-o magapadayon an iya pagahadi? ");
INSERT INTO msb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","May hunga pa. Kun paagi kan Beelzebul nagapaluwas ako san mga demonyo, kanin-o man gali poder na nahimo man ini san iyo mga katawuhan? Kaya ini sinda mismo an magapamatuod na sala kamo. ");
INSERT INTO msb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ugaling kun paagi sa Espirito san Dios an pagpaluwas ko san mga demonyo, ina nagapamatuod na an pagahadi san Dios adi na sa iyo.” ");
INSERT INTO msb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nagpadayon pa si Jesus sa iba na istorya, “O halimbawa baga, pan-o masulod an balay san maisog na tawo agod kuhaon an iya mga butang kun dili anay siya gapuson? Kun sugad, amo pa lang makakawatan an iya balay.” ");
INSERT INTO msb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nagpadayon si Jesus, “Kaya mga kontra gayod sa akon an dili nakiupod sa akon kag nagaburulag lugod an dili nagabulig sa akon magtipon. ");
INSERT INTO msb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Niyan ginasiguro ko sa iyo na papatawadon an tanan na mga kasal-an san tawo hasta an pagpakaraot sa tawo pero dili gayod papatawadon an magpakaraot sa Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","An magsurmaton naman kontra sa akon na Anak San Tawo papatawadon pero an magsurmaton kontra sa Espirito Santo dili gayod papatawadon bisan san-o.” ");
INSERT INTO msb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nagsurmaton pa si Jesus, “Niyan ipahalimbawa ta man sa kahoy. Kun maayo ini, nagabunga man sin maayo pero kun maraot, maraot man an bunga. Kaya makikilala naton an kahoy paagi sa bunga sani. ");
INSERT INTO msb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pareho kamo sana kay baga kamoʼn kasawahan! Pan-o kamo makasurmaton sin maayo na kamo mismo maraot? Kay kun nano man an ada gayod sa tagipusuon amo man an ginasurmaton. ");
INSERT INTO msb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hali sa iya malinis na tagipusuon an maayo na tawo nagapakita sin maayo na nahimuan. An maraot naman na tawo nagapakitaʼn mga maraot na hinimuan na hali sa iya maati na tagipusuon. ");
INSERT INTO msb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero amo ini an sasabihon ko sa iyo: sa adlaw san paghusgar an tanan na mga tawo dapat mag-atubang sa Dios manungod sa kada naisurmaton na waraʼn pulos. ");
INSERT INTO msb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kaya pagapatanuson kamo o pagakondinaron paagi sa iyo ginsurmaton.” ");
INSERT INTO msb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pakatapos may mga Pariseo kag mga paratukdo san Kasuguan na nagsabi sa iya, “Sir, gusto namon makita na nagahimo kaʼn milagro bilang tanda na pagapamatuod na ikaw hali sa Dios.” ");
INSERT INTO msb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero sinabat sinda ni Jesus, “Maraot kag makasal-anon na mga tawo an nagapangayo sin tanda. Ugaling waraʼn ipapakita sa inda kundi an pareho na nangyari sa propeta na si Jonas. ");
INSERT INTO msb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kay pareho ni Jonas na nagtulo ka adlaw kag nagtulo ka gab-i sa sulod san tiyan san dako na isda amo man ako na Anak San Tawo magatulo ka adlaw kag magatulo man ka gab-i sa idalom san duta. ");
INSERT INTO msb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Sa adlaw san maabot na paghusgar san Dios adto na an mga taga-Nineve kaurupod niyo na mga tawo na nabuhay yana. Magapamatuod ngani sinda kontra sa iyo kay nagbasol gayod sinda sa inda mga kasal-an kag nagbaya sani kasadto san magtukdo si Jonas pero bisan adi na yana an mas labaw pa ki sa iya habo naman kamo mamati. ");
INSERT INTO msb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kun maabot gayod ina na adlaw, adto man an ginatawag na Reyna san Timog kaupod niyo na mga tawo na nabuhay yana. Aakusaron man niya kamo kay kasadto hali pa gayod siya sa harayo na lugar san kinab-an para mamati san kadunungan ni Solomon pero, kitaa, bisan adi na yana an mas labaw pa ki kan Solomon, habo naman kamo mamati. ");
INSERT INTO msb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ipahalimbawa ta naman sa maraot na espirito,” an sabi ni Jesus. “Pagluwas sani sa tawo nagaagi-agi siya sa mga disyerto agod maghanap sin mapahuwayan pero kay waraʼn mahanapan, ");
INSERT INTO msb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kaya masabi siyaʼn, ‘Mabalik ako sa akon ginhalian na istaran.’ Pag-abot niya didto, nakita na waraʼn sulod, malinis kag gin-ayo na idto. ");
INSERT INTO msb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tapos magahali gihapon siya kag magatiripon pa sin pito na espirito na mas maraot pa sa iya. Didto naman sinda tanan magasulod kag magaistar. Dahilan sani mas grabe an kamutangan sadtoʼn tawo ki san dati. Kaya amo man an mangyayari sani na maraot na mga tawo na nabubuhay yana.” ");
INSERT INTO msb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Myintras nagasurmaton pa si Jesus sa mga tawo, nag-abot an iya iloy kag mga kamaranghod na lalaki. Adto sinda sa luwas na nagahangyo na makisurmaton sa iya. ");
INSERT INTO msb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kaya may usad didto na nagsabi sa iya, “Kitaa, ada sa luwas an imo iloy kag mga kamaranghod na lalaki na gusto makigsurmaton sa imo.” ");
INSERT INTO msb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero sinabat siya ni Jesus sin hunga, “Sin-o an akon iloy kag sarasin-o an akon mga kamaranghod na lalaki?” ");
INSERT INTO msb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tapos tinukdo an iya mga disipulos kag nag-sabi, “Adi an akon iloy kag mga kamaranghod na lalaki. ");
INSERT INTO msb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","An tanan na nagatuman sa pagbuot san akon amasa langit amo an akon iloy, mga kamaranghod na lalaki kag babayi.” ");
INSERT INTO msb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sadto mismo na adlaw paghali ni Jesus sa balay nagpakadto siya sa higad san danaw kag nag-ingkod. ");
INSERT INTO msb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Damu-damo na katawuhan an nagtiripon sa iya kaya nagsakay siya sa baruto kag nag-ingkod. An tanan naman na katawuhan nagtirindog sa baybayon. ");
INSERT INTO msb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","May pasadi-sadi na ginsurmaton siya sa inda paagi sa mga istorya. Ginsabihan niya, “May parauma na nagpauma para magsabwag. ");
INSERT INTO msb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sa iya pagsabwag may mga binhi na nakatupa sa may dalan pero ini ginturuka san mga sapat na nag-abot. ");
INSERT INTO msb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","May nakatupa man sa kabatuhan na dyutay an duta. Nagturubo dayon ini kay hamabaw man lang an duta, ");
INSERT INTO msb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pero pagragit san adlaw naluyos kag nag-uga idto kay wara makagamot sin maayo. ");
INSERT INTO msb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","May mga binhi naman na nakatupa sa katunukan pero pagdaragko san katunukan nasiutan ini kag namatay. ");
INSERT INTO msb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Niyan may iba na mga binhi na nakatupa sa mataba na duta kag nagburunga gayod. May mga nagbunga sin ginatos, may tigsisenta kag may tigtraynta kada binhi. ");
INSERT INTO msb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kaya kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pakatapos nagharalapit an mga disipulos kan Jesus kag naghunga sa iya, “Nano kay nagatukdo ka sani na mga tawo paagi sin mga istorya?” ");
INSERT INTO msb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nagsabat si Jesus, “Kamo an gintugutan na maaraman an mga misteryo san kahadian san langit pero sa inda wara igtugut. ");
INSERT INTO msb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Manungod sani an igwa na hahatagan pa kaya mabugana na pero an wara-wara kukuhaan pa bisan an nano man na ada na sa iya. ");
INSERT INTO msb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaya ngani nakisurmaton ako sa inda paagi sa mga istorya kay bisan sing-ano ninda sin kasud-ong dili gihapon nakakita kag bisan sing-ano sin kapamati dili man gihapon nakabati kag nakasabot. ");
INSERT INTO msb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natuman man gayod sa inda an ginsabi san propeta na si Isaias na nagsabi, ‘Magapamati man kamo pirme pero dili gihapon makasabot. Magakita kamo pirme pero dili man gihapon makapanginano.’ ");
INSERT INTO msb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nagpadayon si Isaias, ‘Kay manol ini na mga katawuhan bagaʼn mga bungol kag mga piyong pa sinda, kay basi makipanginano, makabati kag makasabot, tapos magabalik sinda sa akon kag mapaayo ko sinda.’ ");
INSERT INTO msb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kundi palabi an iyo mga mata kag mga talinga kay nakakita kag nakabati. ");
INSERT INTO msb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ginasiguro ko sa iyo, kasadto damo na mga propeta kag matanos na tawo an nagahandom na makakita san iyo nakita pero dili ninda nakita. Nagahandom man makabati san iyo nababatian pero dili ninda nabati. ");
INSERT INTO msb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kaya pamatii an gusto sabihon sani na istorya san parauma. ");
INSERT INTO msb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","An nakapamati na wara makasabot san surmaton manungod san kahadian pareho san binhi na nakatupa sa dalan. Tapos nagaabot an demonyo kag nagaagaw san surmaton na ginpamatian. ");
INSERT INTO msb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Idtoʼn naman na nakatupa sa kabatuhan amo idtoʼn mga nakabati san surmaton tapos nagatuod dayon kag nagakarilipay. ");
INSERT INTO msb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero wara makagamot sa inda sadiri kaya nagatubo anay sin kadali pero oras na may kalisdanan o kasakitan dahilan san pagsunod sa katukduan nawawara dayon an inda pagtuod. ");
INSERT INTO msb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Idto naman na nakatupa na binhi sa katunukan amo idtoʼn nakabati san surmaton pero an mga kahandalan san pagkabuhay kag an kasadya hali san kayamanan amo an nagapalimot san surmaton kaya wara ini makapamunga. ");
INSERT INTO msb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Idto ugaling na mga nakasabwag man na binhi sa mataba na duta amo idtoʼn mga nagapamati san surmaton kag nakasabot. Sinda idtoʼn bagaʼn mga tanom na nakapamunga gayod sin ginatos, sin tigsisenta o sin tigtraynta kada binhi.” ");
INSERT INTO msb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","May iba pa na gin-istorya si Jesus sa kadamuan. “Pareho sa tawo na nagpasabwag sin maayo na binhi sa iya uma an pagahadi san Dios. ");
INSERT INTO msb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Usad na gab-i myintras tururog an mga suruguon san tag-iya may nag-abot na kaaway kag nagsabwag man sin dinghot sadto man mismo na uma tapos lumakat. ");
INSERT INTO msb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kaya pagturubo san tanom kag nagtuna mamunga nagturunga man an mga dinghot. ");
INSERT INTO msb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Nagkadto sa tag-iya an mga suruguon kag naghunga, ‘Sir, maayo man an binhi na ginsabwag namon sa imo umahan, pan-o man nagkadinghot?’ ");
INSERT INTO msb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ginsabat niya sinda, ‘May kaaway na naghimo sani.’ “Pakabati sani ginhunga naman siya san mga suruguon, ‘Nano, gusto mo ba na gabuton namon an dinghot?’ ");
INSERT INTO msb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Pero nagsabat an amo, ‘Ayaw, kay basi paggabot niyo san dinghot makaupod man an trigo. ");
INSERT INTO msb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabayai lang niyo na durungan ini magtubo hasta pag-ani kay sa tiganihan sabihon ko na lang sa mga paraani na unahon anay paggabot san mga dinghot, tapos butuk-butukon agod isugba sa kalayo. Pero an trigo itipon sa akon kamalig.’,” ");
INSERT INTO msb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","May iba pa na gin-istorya si Jesus sa inda. “Pareho man san pisog san mustasa na tinanom sin tawo sa iya uma an pagahadi san Dios. ");
INSERT INTO msb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Amo ini an pinakadyutay sa tanan na pisog pero pagtubo amo man an pinakadako sa mga tanom sa uma. Nagin kahoy ini kaya nagahurugdon an mga sapat kag nagasaralag sa mga sanga sani.” ");
INSERT INTO msb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","May iba pa na gin-istorya si Jesus sa inda. “Pareho man san pampaalsa na ginatawag lebadura an pagahadi san Dios. Ginmiskla ina san babayi sa tulo ka sukol na arina. Tapos dahilan sani nag-alsa an bilog na minasa.” ");
INSERT INTO msb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ini tanan gintukdo ni Jesus sa kadamuan paagi sa mga istorya. Dili ngani siya nagatukdo sa inda kun dili paagi sa istorya. ");
INSERT INTO msb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nangyari ini agod matuman an ginsabi san propeta: “Magagamit akoʼn mga istorya sa pakigsurmaton sa inda. Igapahayag ko an mga misteryo na dili pa naaaraman magtuna sa paglalang san kinab-an.” ");
INSERT INTO msb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pakatapos sani binayaan ni Jesus an kadamuan kag nagsulod sa balay. Nag-arapiki an mga disipulos niya kag may nagsabi, “Ipahayag man sa amon an gusto sabihon san istorya san mga dinghot sa uma.” ");
INSERT INTO msb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nagsabat si Jesus, “Idtoʼn nagsabwag san maayo na binhi amo ako na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","An uma amo an kinab-an kag an gusto sabihon san maayo na binhi an katawuhan na nagapasakop sa pagahadi san Dios. An mga dinghot naman an katawuhan na nagapasakop sa Maraot na Espirito na amo si Satanas. ");
INSERT INTO msb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Siya man an demonyo na nagtanom sani na dinghot. Tapos an pag-ani amo an katapusan san kinab-an kag an mga paraani amo an mga anghel. ");
INSERT INTO msb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Pareho na an dinghot gintipon kag ginsunog sa kalayo amo man an mangyayari sana na mga tawo sa katapusan san kinab-an. ");
INSERT INTO msb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Susuguon ko na Anak San Tawo an akon mga anghel agod tiripunon an tanan na ginapakasala an mga tawo kag an mga nagahirimoʼn karautan. ");
INSERT INTO msb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tapos igaitsa ini tanan sa kalayo sa impyerno na didto maganguruyngoy an mga tawo kag magaragot an inda mga ngipon sa pagsakit. ");
INSERT INTO msb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","An mga matanos naman magasirak pareho san adlaw didto sa kahadian san inda Ama. Kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nagpadayon si Jesus, “Bagaʼn kayamanan na natatago sa uma an pagahadi san Dios. Pareho ini san tawo na pakakita sani na kayamanan tinahuban gihapon. Nag-uli siya sa kalipay kag binaligya an tanan niya na nakasadirihan tapos binakal idtoʼn uma. ");
INSERT INTO msb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“An pagahadi san Dios pareho san negosyante na nagaparapanghanap sin mga pinakamaayo na perlas. ");
INSERT INTO msb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pakakita sin pinakapambihira sani, umuli kag binaligya an tanan niya na nakasadirihan, tapos binakal ini. ");
INSERT INTO msb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sugad man, an pagahadi san Dios pareho san lambat na gin-itsa sa dagat kag nakakuha sin manlain-lain na isda. ");
INSERT INTO msb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pakapuno sani ginhaw-as pabaybayon san mga parapangisda. Tapos pag-iringkod ninda gintipon ninda an mga maayo na isda sa surudlan pero ginpilak an mga maraot na klase. ");
INSERT INTO msb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amo man an mangyayari sa katapusan san kinab-an. Makaradi an mga anghel tapos lalainon ninda an mga maraot na tawo sa mga matanos. ");
INSERT INTO msb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","An mga maraot iitsa sa nagadaba-daba na kalayo kun diin maganguruyngoy sinda didto kag magaragot an inda mga ngipon sa kasakit.” ");
INSERT INTO msb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Nano, nasabutan niyo ini tanan?” an hunga ni Jesus. Nagsabat sinda, “Opo.” ");
INSERT INTO msb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ginsabihan gihapon niya sinda, “Pareho sa tagbalay na ginapaluwas an iya mga gamit na bag-o kag daan hali sa iya taguan ini an kada paratukdo san Kasuguan na gintukduan manungod san kahadian san langit.” ");
INSERT INTO msb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pakatapos pakaistorya sani naghali si Jesus didto. ");
INSERT INTO msb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pagbalik naman niya sa iya sadiri na lugar, nagtukdo siya sa mga tagadidto sa inda sinagoga. Nangawa sinda kag naghurunga, “Pan-o nagin madunong ini na tawo kag makahimo sani na mga milagro? ");
INSERT INTO msb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nano, dili ba anak lang siya san panday? Dili ba an iya iloy si Maria? Nano, dili ba an iya kamaranghod na lalaki sinda Santiago, Jose, Simon kag Judas? ");
INSERT INTO msb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","An tanan naman na iya kamaranghod na babayi, nano, dili man sinda an aton kaurupod? Kun sugad pan-o naaraman sani na tawo an paghimo san mga milagro?” ");
INSERT INTO msb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kaya urit sinda kan Jesus. Pero ginasabihan niya sinda, “Bisan sin-o na propeta ginagalangan bisan diin pwera lang sa iya sadiri na lungsod kag panimalay.” ");
INSERT INTO msb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaya kay wara sindaʼn pagtuod, kulang an mga milagro na ginhimo niya didto. ");
INSERT INTO msb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sadto na panahon nabaritaan ni Herodes na namumuno san Galilea an manungod sa kabantugan ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tapos nagsabi sa mga opisyales, “Amo man gayod ini siya si Juan na Parabunyag na nabuhay gihapon kaya dahilan sani ada na sa iya ini na mga kagamhanan.” ");
INSERT INTO msb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Niyan ini si Herodes amo an nagpadakop kan Juan, nagpagapos kag nagpapriso sa iya dahilan na ginsaway siya ni Juan kay nag-asawa siya kan Herodias na asawa san iya manghod na si Felipe. ");
INSERT INTO msb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sinabihan siya ni Juan, “Dili tugut sa Kasuguan na asawahon mo an asawa san imo manghod.” ");
INSERT INTO msb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Dahilan sani gusto niya na ipapatay si Juan kaya lang nahahadlok siya sa mga tawo kay nagatuod sinda na propeta si Juan. ");
INSERT INTO msb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nag-abot an adlaw san nagselebrar si Herodes san iya pagkaanak. Sadto nagsayaw an daraga na anak ni Herodias sa atubangan san mga bisita. Nakapalipay gayod siya kan Herodes, ");
INSERT INTO msb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kaya nagsumpa ini na ihatag sa daraga an nano man na hangyuon niya. ");
INSERT INTO msb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sa pagsunod sa gintugon man san iya iloy nangayo an daraga, “Ihatag sa akon didi an ulo ni Juan na Parabunyag na nakabutang sa bandihado.” ");
INSERT INTO msb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Didi namundo an hadi, ugaling dahilan san iya ginsumpa sa atubangan san mga bisita nagsugo siya na ihatag an ginahangyo san daraga. ");
INSERT INTO msb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaya ginpapugutan sin ulo si Juan didto sa prisuhan. ");
INSERT INTO msb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tapos gindara an ulo na nakabutang sa bandihado kag hinatag sa daraga na amo naman an nagdara sa iya iloy. ");
INSERT INTO msb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pakabaritai sani san mga disipulos ni Juan nagkaradto sinda kag kinuha an iya lawas, tapos linubong. Pakatapos nagkaradto sinda kan Jesus kag ginsumat an nangyari. ");
INSERT INTO msb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pakabarita man sani ni Jesus, sumakay siya sa sarakyan sa tubig kag naghali didto sin sikreto pakadto sa mamingaw na lugar na waraʼn tawo. Pero pakaarami naman sani san kadamuan nagsurunod sinda sa iya na nagaralakat hali sa mga lungsod. ");
INSERT INTO msb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagdungka ni Jesus sa baybayon kag nakita an damu-damo na katawuhan, naluoy siya sa inda kag ginpangayo an inda mga masakiton. ");
INSERT INTO msb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","San tunod na an adlaw nagharalapit sa iya an mga disipulos kag nagsabi, “Usad ini na mamingaw na lugar kag tunod na an adlaw. Pahalia na an mga tawo agod makakadto sa kabaryuhan para makabakal san inda makaon.” ");
INSERT INTO msb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero nagsabat lugod si Jesus, “Dili na kinahanglan na magralakat pa sinda. Hatagi na lang niyo sindaʼn makaon.” ");
INSERT INTO msb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nagsabat naman sinda, “Lima lang ka bilog na tinapay kag duha ka bilog na isda an amon dara.” ");
INSERT INTO msb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Didi nagsugo si Jesus, “Darha niyo pakadi sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tapos nagsugo siya na paingkudon an mga katawuhan sa kadinghutan. Pagkuha niya san lima ka bilog na tinapay kag duha na isda, humangad sa langit kag nagpasalamat sa Dios. Tapos gin-utud-utod niya ina, tinunol sa iya mga disipulos na amo naman an nagpanghatag sa kadamuan. ");
INSERT INTO msb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nagkaraon sinda tanan hasta na nagkaburusog. Tapos san pagtipon san mga disipulos san nagkabirilin nakapuno pa sin dose na bangkat. ");
INSERT INTO msb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Idto na nagkaraon mga lima ka libo na mga kalalakihan pwera pa san mga babayi kag kabataan. ");
INSERT INTO msb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pakatapos sani ginpasakay dayon ni Jesus sa inda sarakyan an mga disipulos kag ginpauna sa tabok san danaw myintras ginapauli niya an katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pakapaulia na niya sani nagsagka siya sa bukid na sulo lang agod magpangadyi. Pagkagab-i siya na lang an nabilin. ");
INSERT INTO msb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sani mismo na kaorason an ginasakyan san mga disipulos adto na sa tunga san lawod na ginalamba-lamba san balod dahilan na sungsungon an hangin. ");
INSERT INTO msb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","San maalas kwatro na an kaagahon naghalapit sa inda si Jesus na nagalakat sa ibabaw san tubig. ");
INSERT INTO msb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero san makita san mga disipulos na nagalakat siya sin sugad nagkaharadlok sinda na nagasiriyak, “Adaw, multo!” ");
INSERT INTO msb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero sinabihan sinda dayon ni Jesus, “Ayaw kamo kahadlok! Ako baga ini! Pakusuga an iyo buot!” ");
INSERT INTO msb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Didi nagsabat si Pedro, “Ginoo, kun ikaw gayod ina pakadaa ako sa imo na magalakat man sa ibabaw san tubig!” ");
INSERT INTO msb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Kadi,” an sugo ni Jesus. Kaya lumusad si Pedro sa sarakyan kag nagtuna paglakat sa ibabaw san tubig pakadto kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero pakakita ni Pedro san kakusog san hangin nahadlok siya kag nagtuna pag-umlod. Kaya nakasiyak siya, “Ginoo, isalbar man ako!” ");
INSERT INTO msb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Gintunol dayon ni Jesus an iya kamot kag hinawidan si Pedro. Tapos nagsabi, “Marasa pa na kulang an imo pagsarig. Nano kay nagduda ka pa?” ");
INSERT INTO msb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pakasakay ninda sa sarakyan naudong an hangin. ");
INSERT INTO msb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","An mga disipulos naman na adto dati sa sarakyan nagduruko sa atubangan ni Jesus na nagsabi, “Matuod gayod na ikaw an Anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pakatabok sa danaw nagdungka sinda sa lugar san Genesaret. ");
INSERT INTO msb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pakakilalahi sa iya san mga tagadidto, pinangbarita sa tanan na katarakin kag ginpangdara sa iya an tanan na masakiton didto. ");
INSERT INTO msb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tapos nakimaluoy sa iya na pabayaan lang na makadutdot sinda sa sidsid san iya bado. Idto tanan na nakadutdot nag-arayo. ");
INSERT INTO msb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nagkaradto kan Jesus an mga Pariseo kag mga paratukdo san Kasuguan na hali sa Jerusalem kag naghunga, ");
INSERT INTO msb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nano kay an imo mga disipulos dili nagasunod san kaugalian san mga kalulululuhi kundi nagakaraon na dili anay nagahugas san kamot sa tama na paagi?” ");
INSERT INTO msb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ginsabat man sinda ni Jesus, “Nano man kamo kay ginasupak niyo an sugo san Dios dahilan san iyo kaugalian? ");
INSERT INTO msb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nagsugo an Dios, ‘Galangan mo an imo ama kag iloy,’ kag ‘An nagapakaraot sa iya ama kag iloy dapat gayod ipapatay.’ ");
INSERT INTO msb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero kamo naman nagasabi, ‘Kun may magsabi sa iya ama o iloy: Nakatalaga na sa Dios an dapat ko na ikabulig sa iyo,’ dili na siya dapat maggalang sa inda paagi sa pagsustento. ");
INSERT INTO msb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kaya paagi sani ginabalewara niyo an surmaton san Dios tungod san iyo kaugalian. ");
INSERT INTO msb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga pakitaʼn-tawo lang! Tama an ginsabi ni Isaias manungod sa iyo! ");
INSERT INTO msb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ginagalangan ako sani na mga tawo sa surmaton lang pero an inda mga tagipusuon harayo sa pagsunod sa akon. ");
INSERT INTO msb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Waraʼn pulos an pagsamba na ginahalad ninda sa akon kay an katukduan na inda ginapahayag mga kasuguan lang san mga tawo.’,” ");
INSERT INTO msb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ginpahalapit ni Jesus an mga tawo kag ginsabihan, “Pamatii niyo ako kag sabuta! ");
INSERT INTO msb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dili nakapaati sa tawo an nagasulod sa ba-ba kundi an nagaluwas sani.” ");
INSERT INTO msb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pakatapos sadto nagkaradto sa iya an mga disipulos kag naghunga, “Nano, dili mo ba aram na nagkaururit an mga Pariseo pakabati sana na ginsabi mo?” ");
INSERT INTO msb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nagsabat si Jesus, “Pagagabuton an kada tanom na dili tinanom san akon langitnon na Ama. ");
INSERT INTO msb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabayai lang sinda. Pareho sinda sa mga buta na nagakabit sin otro buta kag kun san-o man may buta na nagakabit sa kapwa niya buta, pareho sinda tanan mahuhulog sa kali.” ");
INSERT INTO msb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Didi naghangyo sa iya si Pedro, “Ipahayag man sa amon ini na gin-istorya mo.” ");
INSERT INTO msb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Naghunga naman si Jesus, “Nano, dili pa gihapon kamo nakasarabot? ");
INSERT INTO msb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nano, dili niyo aram na an nagasulod sa ba-ba nagaagi sa tiyan tapos iluluwas gayod? ");
INSERT INTO msb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kaya ngani an ginasurmaton na hali sa tagipusuon amo an nakapaati sa tawo. ");
INSERT INTO msb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nasabi ko ini kay sa tagipusuon nagahali an mga maraot na kaisipan, pagpatay, pagpanambay, pagdurog sa dili asawa, pangawat, pagtestigo sin kabuwaan kag pagtuya-tuya san kapwa. ");
INSERT INTO msb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Amo ini an nakapaati sa tawo pero kun magkaon na wara anay maghugas san kamot dili gayod nakapaati sa tawo.” ");
INSERT INTO msb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naghali didto si Jesus kag nagpakadto sa lugar na halapit sa mga lungsod san Tiro kag Sidon. ");
INSERT INTO msb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Didto may babayi na taga-Cana na nagaistar sadto na lugar na nagahalapit sa iya kag nagasiyak, “Sir, Lahi ni David, maluoy ka man sa akon kay an akon anak na babayi nasudlan sin maraot na espirito kag ginapasakitan sin grabe.” ");
INSERT INTO msb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero wara siya pagsabata ni Jesus. Kaya ginhalapitan siya san iya mga disipulos kag nakimaluoy, “Pahalia na siya kay nagaparasunod sa aton na sige an kasiyak.” ");
INSERT INTO msb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Didi nagsabat si Jesus, “Ginsugo ako para lang sa mga tawo na taga-Israel na pareho san mga karnero na nalalagalag.” ");
INSERT INTO msb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero naghalapit na an babayi kag lumuhod sa atubangan niya na nagasabi, “Sir, buligi man ako.” ");
INSERT INTO msb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nagsabat naman didi si Jesus, “Dili maayo na kuhaon an pagkaon sa kabataan kag ibahog lugod sa kaiduan.” ");
INSERT INTO msb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nagsabat man an babayi, “Opo, Sir, pero bisan ngani an mga ido nababahugan man ngani san mga mumho na nagakatarakdag sa lamesa san inda amo.” ");
INSERT INTO msb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kaya ginsabihan siya ni Jesus, “Tia, matuod man gayod na hugot an pagsarig mo! Nangyari na an imo ginahandom.” Tapos sadto mismo nag-ayo dayon an iya anak na babayi. ");
INSERT INTO msb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hali didto nagpadayon si Jesus kag nag-agi sa baybayon san Galilea. Tapos nagsagka siya sa bukid kag nag-ingkod didto. ");
INSERT INTO msb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Damu-damo na mga tawo an nagkaradto sa iya na may mga dara na pilay, kimay, buta, apa kag mga iba pa. Ginbutang ninda sa may tiilan ni Jesus ini kag gin-ayo niya. ");
INSERT INTO msb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kaya nangangawa an kadamuan pakakita na an apa nakasurmaton, an kimay naayo, an pilay nakalakat kag an buta nakakita. Dahilan sani gin-umaw ninda an Dios san Israel. ");
INSERT INTO msb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pakatapos sani ginpahalapit ni Jesus an iya mga disipulos kag sinabihan, “Naluluoy ako sa mga tawo kay nagparaupod na sinda sa akon sin matulo na ka adlaw yana kag wara sin makaon. Habo ko naman sinda na paulion na gurutom kay basi magkadirismayo sinda sa dalan.” ");
INSERT INTO msb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kaya ginhunga siya san iya mga disipulos, “Sani na kabukidan diin man kita makuhaʼn tinapay na makaigo ipakaon sa kadamuan?” ");
INSERT INTO msb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Didi naghunga si Jesus sa inda, “Pira ka bilog na tinapay an ada sa iyo?” Nagsabat sinda, “Pito po kag mga pira ka bilog na tigdyutay na isda.” ");
INSERT INTO msb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ginpairingkod niya sa duta an katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tapos kinuha an pito ka bilog na tinapay kag san isda. Pakapasalamat sa Dios gin-utud-utod ina kag tinunol sa iya mga disipulos na amo man an nagpanghatag sa katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nagkaraon sinda tanan kag nagkaburusog. Pagkatapos, pito pa ka bangkat an natipon na mga sobra. ");
INSERT INTO msb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Niyan upat ka libo na kalalakihan an nagkaraon pwera pa san kababayihan kag kabataan. ");
INSERT INTO msb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pakapaulia ni Jesus san kadamuan nagsakay siya sa dako na baruto kag nagpakadto sa lugar san Magadan. ");
INSERT INTO msb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Niyan nagkaradto naman kan Jesus an mga Pariseo kag mga Saduceo agod porbaran siya. Kaya naghunga sinda kun may milagro siya na ikapakita bilang tanda na hali sa langit an iya poder. ");
INSERT INTO msb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nagsabat siya, “Kun nagatunod na an adlaw nasabi kamo, ‘Maayo an panahon buwas kay mapula an langit.’ ");
INSERT INTO msb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tapos pagkaaga naman nasabi kamo, ‘Maraot an panahon yana kay nagapula-pula an langit kag madampog.’ Maaram kamo magtugma kun may uran o wara kun nakikita niyo an panganuron pero dili gali niyo aram an gusto sabihon san mga tanda na ginapakita san Dios manungod sani na panahon. ");
INSERT INTO msb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Maraot an mga tawo na nabubuhay yana kay nagbaya sinda sa Dios. Gusto ninda makakita sin milagro bilang tanda san akon gahom pero waraʼn ipapakita sa inda kundi an pareho san nangyari sa propeta na si Jonas.” Tapos didi niya binayaan sinda. ");
INSERT INTO msb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pakatabok san mga disipulos sa danaw nadumduman ninda na wara gali sinda magdaraʼn pagkaon. ");
INSERT INTO msb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Didi sinabihan sinda ni Jesus, “Paghimat kag paglikay sa lebadura san mga Pariseo kag Saduceo.” ");
INSERT INTO msb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nagairistoryahan an mga disipulos, “Basi ginsabi niya ini kay nalimot kita magdaraʼn pagkaon.” ");
INSERT INTO msb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pakaaram sani ni Jesus, ginhunga sinda, “Mga kulang an pagsarig, nano kay ginairistoryahan niyo na wara kamoʼn pagkaon? ");
INSERT INTO msb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Dili pa ba gihapon kamo nakapanginano? Nano, nalimutan na niyo an nangyari sa lima ka bilog na tinapay na ginpakaon sa lima ka libo na mga tawo kag pagkatapos kun pira pa ka bangkat na may natipon kamo? ");
INSERT INTO msb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nano, nalimutan na niyo an nangyari sa pito ka bilog na tinapay na ginpakaon sa upat ka libo kag pagkatapos kun pira pa ka bangkat na sobra an iyo natipon? ");
INSERT INTO msb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nano kay dili pa gihapon niyo nasasabutan na dili manungod sa pagkaon an ginasabi ko? Kaya maglikay gayod kamo sa lebadura san mga Pariseo kag Saduceo.” ");
INSERT INTO msb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Niyan didi lang ninda nasabutan na an likayan dili kay an lebadura sa paghimo sin tinapay kundi an mga ginatukdo san mga Pariseo kag Saduceo. ");
INSERT INTO msb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pag-abot ninda Jesus sa lugar san Cesarea Filipo naghunga siya sa iya mga disipulos, “Sumati daw niyo ako kun nano an pagkakilala san mga tawo sa akon na Anak San Tawo?” ");
INSERT INTO msb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nagsabat sinda, “May nagasabi na ikaw kuno si Juan na Parabunyag na nabuhay gihapon, an iba naman na ikaw kuno si Elias kag may iba pa gayod na ikaw kuno si Jeremias o usad san mga kasadto na mga propeta.” ");
INSERT INTO msb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Pero kamo, nano an pagkakilala niyo sa akon?” an hunga ni Jesus sa inda. ");
INSERT INTO msb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Didi ginsabat siya ni Simon Pedro, “Ikaw an Cristo na Mesias. Ikaw an Anak san buhay na Dios.” ");
INSERT INTO msb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nagsabat naman si Jesus, “Ginpalabi ka, Simon, anak ni Jonas, kay dili tawo an naghayag sani sa imo kundi an akon Ama na adto sa langit. ");
INSERT INTO msb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kaya tandai ini: ikaw ginatawag Pedro, kag didi sani na bato titipunon ko an akon mga katawuhan bilang akon simbahan. Dili ini kaya daugon san gahom hali sa impyerno. ");
INSERT INTO msb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ihahatag ko sa imo an mga lyabi san kahadian san langit. Kaya an igabawal mo sa kinab-an igabawal man sa langit, kag an itutugot mo sa kinab-an itutugot man sa langit.” ");
INSERT INTO msb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tapos ginpadaanan gayod niya an iya mga disipulos na dili magpanumat bisan kanin-o na siya an Cristo. ");
INSERT INTO msb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuna sadto nagtuna si Jesus pagpahayag sa iya mga disipulos na dapat siya magkadto sa Jerusalem kag magtios sin grabe sa mga kagurangan na namumuno san mga Judio, mga namumuno san kapadian kag mga paratukdo san Kasuguan, tapos papatayon pero sa ikatulo ka adlaw bubuhayon gihapon. ");
INSERT INTO msb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Didi ginbulag anay siya ni Pedro sa kadamuan kag nagtuna pagsaway sa iya, “Ginoo, buyag! Dili gayod ini mangyayari sa imo.” ");
INSERT INTO msb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero gin-atubang siya ni Jesus kag gin-uritan, “Layas dida, Satanas! Ulang ka lang sa akon kay an imo ginaisip dili an sa Dios kundi an sa tawo.” ");
INSERT INTO msb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pakatapos sani ginsabihan ni Jesus an iya mga disipulos, “Kun may gusto mag-upod sa akon bilang disipulos ko dili niya dapat sundon an sadiri niya na kabubut-on kundi sundon lugod an kaburut-on ko kag pas-anon an iya krus na amo an pagtios tungod sa akon. ");
INSERT INTO msb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nasabi ko ini kay an nagahandom masalbar an iya buhay para sa iya sadiri mawawar-an sani pero an maghalad san iya buhay alang-alang sa akon magkakaigwa lugod sani. ");
INSERT INTO msb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kay nano man an pakinabang san tawo kun mapasa iya an bilog na kinab-an kun an kabalyo sani an pagkasira san iya buhay? Syimpre wara gayod! Kay wara man siyaʼn mahatag agod mapabalik ina na buhay. ");
INSERT INTO msb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ginasabi ko ini kay ako na Anak San Tawo mabalik na may glorya san akon Ama kaupod an mga anghel. Tapos didto ko babalusan an kada usad susog sa iya nagkahirimuan. ");
INSERT INTO msb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ginasiguro ko sa iyo na igwa sin pira sa iyo na nagatindog didi na dili mapapatay hasta na makita an pag-abot ko na Anak San Tawo bilang hadi.” ");
INSERT INTO msb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pakalipas sin unom ka adlaw gin-agda ni Jesus sinda Pedro, Santiago kag san kamanghod sani na si Juan pagsagka kaupod niya sa hataas na bukid na sinda-sinda lang. ");
INSERT INTO msb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Didto sa atubangan mismo ninda nag-iba an hitsura ni Jesus. Nagbanaag an iya bayhon na pareho san kasilaw san adlaw, kag pumuti-puti gayod an iya bado na nagakinang. ");
INSERT INTO msb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Myintras sinda nagamiron nagpakita sa inda sinda Moises kag Elias na nakisurmaton sa iya. ");
INSERT INTO msb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Didi ginsabihan ni Pedro si Jesus, “Ginoo, maayo man na adi kita. Kun gusto mo magatindog ako didi sin tulo na kubung-kubong na usad para sa imo, usad naman kan Moises kag usad pa kan Elias.” ");
INSERT INTO msb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nagasurmaton pa si Pedro san nahandungan dayon sinda sin masilaw na dampog kag hali sani may nabati na nagasurmaton, “Adi an akon palangga na Anak na ginakalipay ko gayod. Pamatii niyo siya!” ");
INSERT INTO msb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pakabati sani san mga disipulos nagharapa sinda sa grabe na kahadlok. ");
INSERT INTO msb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pero ginhalapitan sinda ni Jesus kag gintapik na nagasabi, “Tindog kamo kag ayaw kahadlok.” ");
INSERT INTO msb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tapos paghangad ninda wara na sindaʼn nakita na iba kundi si Jesus na lang. ");
INSERT INTO msb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","San paglugsad na ninda hali sa bukid ginmandahan sinda sani ni Jesus, “Ayaw gayod kamo pagpanumat bisan kanin-o san iyo nakita hasta ako na an Anak San Tawo mabuhay gihapon hali sa pagkamatay.” ");
INSERT INTO msb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Didi man naghunga sa iya an mga kaupod niya na mga disipulos, “Nano kay nagasarabi an mga paratukdo san Kasuguan na dapat mauuna anay pagpakadi si Elias antes an Cristo?” ");
INSERT INTO msb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nagsabat si Jesus, “Matuod na mauuna si Elias pag-abot agod ipreparar an tanan-tanan. ");
INSERT INTO msb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero ginasiguro ko sa iyo na nag-abot na si Elias, ugaling wara siya ninda makilala kaya ginhimo sa iya an gusto ninda himuon. Sugad man pagapatiuson ninda ako na Anak San Tawo.” ");
INSERT INTO msb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sani lang nasabutan san mga disipulos na an ginasabi niya amo an manungod kan Juan na Parabunyag. ");
INSERT INTO msb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","San nakiupod gihapon sinda sa kadamuan, may tawo na naghalapit kag nagluhod sa atubangan ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tapos nagsabi, “Ginoo, kaluy-i man an akon anak na lalaki kay may buntog kag grabe an pagtios. Pirme-pirme siya natutumba sa kalayo kag sa tubig. ");
INSERT INTO msb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gindara ko na siya sa imo mga disipulos pero wara siya ninda mapaayo.” ");
INSERT INTO msb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nagsabat si Jesus, “Marasa pa kamo na mga tawo yana na panahon na waraʼn pagtuod kag mga sutil! Hasta san-o ta kamo dapat pakiupudan? Nano, hasta na lang magatios ako sa iyo? Sige, pakadia niyo siya sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tapos sinaway ni Jesus an maraot na espirito kag ini naghali dayon. Sadto mismo nag-ayo dayon an bata. ");
INSERT INTO msb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pakatapos san sinda-sinda na lang an mga disipulos ni Jesus nag-arapiki sa iya kag naghunga, “Nano kay wara namon mapaluwas idtoʼn demonyo?” ");
INSERT INTO msb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nagsabat si Jesus, “Kay kulang an iyo pagtuod. Ginasiguro ko sa iyo na kun may pagtuod lang kamo na an kadyutay pareho san pisog san mustasa, makasabi kamo sani na bukid, ‘Humali ka didi kag bumalhin ka didto,’ tapos mabalhin ina. Kaya, kun sugad, an tananmahihimo niyo. ");
INSERT INTO msb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ini na klase dili niyo mapaluwas pwera lang sa paagi san pagpangadyi kag pag-ayuno.” ");
INSERT INTO msb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Usad sin adlaw san nagtiripon sinda sa Galilea ginsabihan sinda ni Jesus, “Ako na Anak San Tawo iintriga sa gahom san katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tapos igapapatay ako pero pag-ikatulo ka adlaw bubuhayon gihapon.” Didi nakabatyag anmga disipulos sin grabe na kamunduan. ");
INSERT INTO msb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pag-abot ninda sa Capernaum nagkadto kan Pedro an mga parasukot san buwis san templo kag naghunga, “Nano, nagabayad man san buwis para sa templo an imo amo?” ");
INSERT INTO msb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Opo,” an sabat niya. Tapos pagsulod niya sa balay nauna si Jesus paghunga sa iya, “Simon, nano an paghuna mo sani? Nano nagasukot sin buwis an mga hadi sani na kinab-an sa inda mga katawuhan o sa mga dayo?” ");
INSERT INTO msb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pagsabat ni Pedro, “Sa mga dayo.” Sinabihan siya ni Jesus, “Kun sugad dili na dapat magbayad an inda mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero bisan sugad sani kumadto ka sa danaw kag mamalakwit. Tapos pagdawi moʼn usad bukaha an ba-ba kay may makikita ka na plata na kwarta. Kuhaa ina kag ibayad sa mga parasukot san buwis san templo para sa aton na duha agod dili sinda mamundo sa aton.” ");
INSERT INTO msb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tapos, nag-arapiki kan Jesus an mga disipulos kag naghunga, “Sin-o an pinakalabaw sa kahadian san langit?” ");
INSERT INTO msb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","May gintawag si Jesus na bata kag pinatindog sa atubangan ninda. ");
INSERT INTO msb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","Tapos nagsabat siya, “Ginasiguro ko sa iyo na an pinakalabaw sa kahadian san langit amo an magmapainubuson pareho sani na tigdyutay na kabataan. Dili gayod kamo magigin sakop sa kahadian san langit hasta na dili kamo magbag-o kag magin mapainubuson pareho sani na dyutay na bata. ");
INSERT INTO msb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","An makaako naman sin pareho sani na bata alang-alang sa akon ginaako man ako. ");
INSERT INTO msb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pero kun may nakapakasala sani na mga kabataan na may pagtuod sa akon, maayo pa na bitayan idto sin dako na ginlingan na bato sa liog kag buntugan sa dagat. ");
INSERT INTO msb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kamakaluluoy san mga katawuhan san kinab-an kay may mga maghidara sa mga tawo paghimoʼn kasal-an! Pirme gayod igwa sin sugad sana pero grabe an kastigo para sa iya na ginahalian sana na pagatintar. ");
INSERT INTO msb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Niyan kun an imo kamot o tiil an dahilan san imo pagkasala, utuda kag ipilak! Mas maayo pa na mabuhay ka na pungkol ki sa duha an imo kamot o tiil tapos ipilak ka lang sa kalayo na dili gayod napaparong. ");
INSERT INTO msb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kun an imo naman mata an dahilan san imo pagkasala, lukata kag ipilak! Mas maayo pa na makasulod ka sa langit na usad lang an mata ki sa duha an mata tapos ipilak ka sa kalayo san impyerno.” ");
INSERT INTO msb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kun sugad talinguhaa gayod niyo na dili kamo makadaug-daog bisan usad sani na mga tigdyutay na kabataan kay an inda mga anghel pirme ngani nasa atubangan san akon Ama sa langit. ");
INSERT INTO msb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nagkadi ngani ako na Anak San Tawo sa kinab-an para isalbar an mga tawo na nalalagalag sa dalan san kasal-an. ");
INSERT INTO msb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sugad baga sani na halimbawa. Sa paghuna niyo nano an pagahimuon san tawo na may usad ka gatos na karnero kun mawara anusad sani? Syimpre, babayaan niyaan 99 na nagapanginaon agod hanapon an nalalagalag. ");
INSERT INTO msb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Matuod gayod na kun makita niya ini mas lalo na malilipay siya para sani ki sa 99 na dili nalagalag. ");
INSERT INTO msb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sugad man habo gayod an iyo Ama sa langit na may mawara bisan usad sani na mga tirigdyutay na kabataan.” ");
INSERT INTO msb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Niyan kun may nagkasala sa imo na kapwa, kadtua kag sabihi san iya nahimo na sala na kamo lang na duha. Kun magpamati siya sa imo, mabalik an iyo dati maayo na pagpasinunud-sunod. ");
INSERT INTO msb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero kun habo siya magpamati sa imo, mag-agda ka sin usad o duha ka tawo agod mapamatuudan san duha o tulo na mga testigos an iyo tanan na gin-istoryahan. ");
INSERT INTO msb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kun habo siya magpamati sa inda, ipaaram sa pagtiripon san mga nagatuod bilang simbahan. Tapos kun habo pa gihapon siya magpamati bisan sani, ibilang mo na siya na waraʼn paggalang sa Dios kaya pareho san dili-Judio kag parasukot san buwis.” ");
INSERT INTO msb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ginasiguro ko sa iyo na an igabawal niyo sa kinab-an igabawal man sa langit kag an itutugot niyo sa kinab-an itutugot man sa langit. ");
INSERT INTO msb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ginasiguro ko sa iyo na kun may duha sa iyo didi sa duta magkausad sa pagpangadyi agod mangayo, igahatag ini sa iyo san akon Ama sa langit, ");
INSERT INTO msb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","kay kun hain man may duha o tulo na nagkatiripon dahilan sa akon ada ako kaupod ninda.” ");
INSERT INTO msb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pakatapos sani nag-apiki si Pedro kan Jesus kag naghunga, “Ginoo, kun may magkasala sa akon nakapwa ko, pira na beses ko siya dapat patawadon? Hasta sa ikapito?” ");
INSERT INTO msb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ginsabat siya ni Jesus, “Dili lang ngani kay pito na beses kundi pito na 70 beses.” ");
INSERT INTO msb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kun kaya an kahadian naman san langit bagaʼn hadi na gusto husayon an iya mga pautang sa iya mga suruguon. ");
INSERT INTO msb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","San pagtuna na pagkwenta san mga pautang may ginpaatubang sa iya na lalaki na un milyon pisos an utang. ");
INSERT INTO msb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Niyan, kay wara siyaʼn ikabayad, nagsugo an amo na ibaligya siya bilang uripon amo man an iya asawa, kaanakan kag san tanan niya na kasadirihan agod makabayad. ");
INSERT INTO msb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Dahilan sani lumuhod an suruguon sa may tiilan san iya amo kag nakimaluoy, ‘Pasensyaha anay ako yana kay pagabayadan ko man an tanan ko na utang.’ ");
INSERT INTO msb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naluoy sa iya an amo kaya pinatawad siya san iya utang kag pinauli. ");
INSERT INTO msb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Pagluwas niya didto may nakasugat siya na iya kapwa suruguon na nakautang man sa iya sin syin pisos. Hinuyutan ini kag tinuok myintras ginasabihan, ‘Bayadi an imo utang sa akon.’ ");
INSERT INTO msb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Didi man nagluhod an kapwa niya suruguon sa may tiilan niya na nakimaluoy, ‘Pasensyaha na lang anay ako yana kay pagabayadan ta man ikaw.’ ");
INSERT INTO msb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pero wara siya magtugot kundi pinapriso idto hasta na makabayad san utang. ");
INSERT INTO msb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pakakita sani na pangyari san kaurupod ninda na mga suruguon nagkaururit gayod. Tapos kumadto sinda sa amo kag ginsumat an tanan na pangyari. ");
INSERT INTO msb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kaya pinatawag san amo idtoʼn una na suruguon kag sinabihan, ‘Waraʼn pulos na suruguon! Pinatawad ta ikaw san tanan mo na utang kay nakimaluoy ka sa akon. ");
INSERT INTO msb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nano, dili ba dapat naluoy ka man sa kapwa mo suruguon pareho san pagkaluoy ko sa imo?’ ");
INSERT INTO msb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Naurit gayod an amo kaya pinapriso ini hasta na mabayadan an tanan na utang. ");
INSERT INTO msb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Sugad man sani an pagahimuon sa iyo tanan san akon Ama sa langit kun dili hali sa tagipusuon an pagpatawad niyo sa iyo kapwa.” ");
INSERT INTO msb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pakatapos sani na pagtukdo naghali naman si Jesus sa Galilea kag nagpakadto sa Judea sa unhan san suba san Jordan. ");
INSERT INTO msb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Damu-damo na katawuhan an nagsurunod sa iya, tapos didto ginpangayo niya sinda na may ginabatyag. ");
INSERT INTO msb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niyan may mga Pariseo na naghalapit kan Jesus agod porbaran siya. Naghunga sinda, “Nano, kontra sa Kasuguan na bulagan san asawa na lalaki an iya asawa bisan nano an dahilan?” ");
INSERT INTO msb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nagsabat siya, “Basi wara pa niyo nabasa sa Kasuratan na sa katuna-tunai an naglalang ‘ginlalang an mga tawo na magin lalaki kag babayi.’ ");
INSERT INTO msb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tapos nagsabi, ‘Dahilan sani pagabayaan san lalaki an iya ama kag iloy kag makig-upod sa iya asawa. Tapos, sinda na duha magigin usad na lang na lawas.’ ");
INSERT INTO msb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kaya dili na sinda duha kundi usad na lang. Kun kaya an ginbiyo san Dios dili dapat pagbulagon san tawo.” ");
INSERT INTO msb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ginhunga naman siya san mga Pariseo, “Kun sugad nano kay nagsugo si Moises na kinahanglan san lalaki mahatagan an iya asawa sin kasuratan na nakibulag na siya tapos mapaluwas siya?” ");
INSERT INTO msb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ginsabat man sinda ni Jesus, “Dahilan san iyo kasutilan kaya gintugot ni Moises na bulagan niyo an iyo asawa pero dili sugad sani sa katunaan san paglalang. ");
INSERT INTO msb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kaya ginasiguro ko sa iyo na an lalaki na makibulag sa iya asawa tapos mag-asawa man gihapon nagakasala sin pagpanambay pwera lang kun an pakigbulag niya dahilan sa pagpanambay san iya asawa.” ");
INSERT INTO msb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Didi naman nagsabi sa iya an mga disipulos, “Kun sugad sani an kamutangan san lalaki kag san iya asawa, mas maayo pa na dili na lang mag-asawa.” ");
INSERT INTO msb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ginsabat niya sinda, “Dili an tanan makaako sani na katukduan kundi para lang sadtoʼn ginhatagan sani. ");
INSERT INTO msb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","May mga lalaki na dili makaasawa kay dati na sa inda pagkabuhay. An iba tungod sa pagbuot san kapwa tawo. Tapos igwa pa gayod sadtoʼn dili nagaasawa kay ginapalabi an pagsirbe sa Dios. Pabayai na akuon san makaako ini na katukduan.” ");
INSERT INTO msb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Niyan may mga tawo na nagdara kan Jesus sin tigdyutay na kabataan agod madapatan niya kag pangadyian pero pakakita sani san mga disipulos ginsaway idtoʼn mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sinabihan naman sinda ni Jesus, “Ayaw niyo pag-ulanga an mga tigdyutay na kabataan kundi pakadia sa akon kay para sa pareho sa inda an kahadian san langit.” ");
INSERT INTO msb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tapos pagkadapati niya san kabataan kag nangadyi para sa inda naghali naman siya didto. ");
INSERT INTO msb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Usad na bes may lalaki na naghalapit kan Jesus kag naghunga, “Maestro, nano an maayo na dapat ko himuon agod masadiri ko an buhay na waraʼn katapusan?” ");
INSERT INTO msb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ginsabat siya ni Jesus, “Nano kay nagahunga ka sa akon manungod sa maayo? May usad lang na nagahimo sin maayo. Ugaling kun gusto mo na magkaigwaʼn buhay na waraʼn katapusan, tumana an Kasuguan ni Moises.” ");
INSERT INTO msb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naghunga gihapon an lalaki, “An nano na kasuguan?” An sabat naman ni Jesus amo ini, “Dili ka magpatay, dili ka magpanambay, dili ka magpangawat, dili ka magtestigos sin kabuwaan. ");
INSERT INTO msb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Galangan mo an imo ama kag iloy, tapos, dapat kamut-an mo an imo kapwa pareho san imo pagkamuot sa imo sadiri.” ");
INSERT INTO msb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sinabihan man siya san batan-on na lalaki, “Gintuman ko ini tanan. Nano pa gayod an mga kakulangan ko?” ");
INSERT INTO msb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Didi nagsabat si Jesus, “Kun gusto mo gayod na waraʼn kakulangan an imo buhay, kuhaon an imo kasadirihan kag ibaligya ini, tapos an kabaklanan ipanghatag mo sa pobre kay magkakaigwa ka sin kayamanan didto kaupod san Dios sa langit. Pakatapos bumalik ka kag mag-upod sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero pakabati sani san batanon na lalaki lumakat siya na mamunduon kay mayaman-yaman siya. ");
INSERT INTO msb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pakatapos ginsabihan ni Jesus an iya mga disipulos, “Ginasiguro ko sa iyo na malisod gayod sa mga mayaman an pagsulod sa kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kaya tandaan an ginasabi ko: mas masayon pa makaagi an kamelyo sa luho san dagom ki sa pagsulod san mayaman sa kahadian san langit.” ");
INSERT INTO msb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pakabati sani nagkangarawa gayod an mga disipulos na nagahurunga, “Kun sugad, sin-o man gali an masasalbar?” ");
INSERT INTO msb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ginsud-ong sinda ni Jesus kag ginsabihan, “Dili kaya san mga tawo na mahimo sani pero kaya san Dios kay siya an makahimo san tanan.” ");
INSERT INTO msb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Didi man nagsurmaton si Pedro kag naghunga, “Kami gali? Ginbayaan namon an tanan agod mag-upod sa imo. Nano man an para sa amon?” ");
INSERT INTO msb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sinabihan naman sinda ni Jesus, “Ginasiguro ko sa iyo na sa maabot na panahon hihimuon san Dios an bag-o na kinab-an. Sani na panahon magaingkod man ako na Anak San Tawo sa akon trono na gloryoso kag kamo na parasunod ko maingkod man sa dose na mga trono agod maghusgar san mga lahi san dose na mga anak ni Israel. ");
INSERT INTO msb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sugad man an magbaya san mga balay, mga kamaranghod, ama kag iloy, kaanakan o kasadirihan dahilan sa akon makabaton sin damu-damo gayod kag magkakaigwa san buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ugaling pag-abot sana na adlaw damo na mga tawo na nauna yana an mauurhi kag damo na mga naurhi naman yana na mauuna sana na adlaw.” ");
INSERT INTO msb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nagpadayon si Jesus, “May istorya pa. Sa kahadian san langit an Dios nakapareho sani na tag-iya. “Usad na bes may tag-iya sin uma na aga pa nagluwas na para maghanap sin mga masusuhulan pagtrabaho sa iya ubasan. ");
INSERT INTO msb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pakatapos na magkauyon sinda na an suhol usad na dinaryo sa usad ka adlaw, ginpakadto na niya sinda sa iya ubasan. ");
INSERT INTO msb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Pagluwas niya na mga alas nuebe na an aga may nakita siya na iba na nagatirindog sa merkado na waraʼn trabaho kaya sinabihan niya, ");
INSERT INTO msb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Kumadto man kamo kag magtrabaho sa akon ubasan kay hahatagan ta kamo sin tama na suhol.’ ");
INSERT INTO msb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kaya nagkaradto sinda. “Pagluwas pa gihapon niya na mga alas dose kag alas dos amo man an iya ginhimo na pag-agda. ");
INSERT INTO msb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pag-alas singko an hapon nagluwas pa gayod siya kag may nakita pa gihapon na mga tawo na nagatirindog didto. Kaya ginhunga niya, ‘Nano kay adi kamo didi na waraʼn ginahimo maghapon?’ ");
INSERT INTO msb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“‘Kay wara man sa amon sin nagasuhol,’ an sabat ninda. “Didi man sinabihan sinda, ‘Sige, kadto man kamo sa akon ubasan.’ ");
INSERT INTO msb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pagkagab-i sinabihan san tag-iya san ubasan an iya engkargado, ‘Tawaga an mga trabahador kag bayadi san inda suhol tuna sa mga naurhi hasta sa mga nauna.’ ");
INSERT INTO msb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Niyan an kada usad san mga nagkaururhi nakabaton sin usad na dinaryo. ");
INSERT INTO msb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","San pag-apiki san mga nagkauruna nag-isip na mas dako an inda mababaton pero parareho man gihapon sinda tig-urusad na dinaryo. ");
INSERT INTO msb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pakabaton ninda nagreklamo sa tag-iya, ");
INSERT INTO msb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Usad lang ka oras an natrabahuan sani na mga nagkaururhi pero kami maghapon na nagpagal kag nagpabalhas. Nano man kay parareho lang an suhol na ginhatag sa amon?’ ");
INSERT INTO msb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ginsabat niya an usad sa inda, ‘Amigo, wara ta ikaw pagdayaa. Nagkasarabot baga kita sa usad na dinaryo. ");
INSERT INTO msb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kaya kuhaa an imo suhol kag uli na kay gusto ko na bayadan ini na nagkaururhi sin pareho san ginbayad ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Syimpre, may gahom ako sa paggamit san akon kwarta sa nano man na gusto ko. O basi naawa ka lang kay maluluy-on ako.’,” ");
INSERT INTO msb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tapos nagsabi si Jesus, “Kaya an mga tawo na naurhi mauuna kag an mga nauna mauurhi naman.” ");
INSERT INTO msb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","San pagsagka ni Jesus pa-Jerusalem ginbulag niya an dose kag myintras nagalakat sinabihan sinda, ");
INSERT INTO msb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Niyan nagasagka kita pa-Jerusalem kag didto ako na Anak San Tawo igaintriga sa mga namumuno san kapadian kag sa mga paratukdo san Kasuguan. Pagahusgaran ako ninda sin kamatayon, ");
INSERT INTO msb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tapos igaintriga man sa mga dili-Judio agod tuya-tuyaon, latiguhon kag patayon paagi sa pagpako sa krus pero sa ikatulo na adlaw bubuhayon ako gihapon.” ");
INSERT INTO msb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Didi naghalapit kan Jesus an iloy san mga anak ni Zebedeo na kaupod sinda kag nagluhod sa iya atubangan agod maghangyo. ");
INSERT INTO msb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hinunga niya an babayi, “Nano an gusto mo?” Nagsabat ini, “Ituga mo sa akon na ini na duha ko na anak an makaingkod sa magluyo mo kun magahadi ka sa imo glorya didto sa Jerusalem.” ");
INSERT INTO msb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero ginsabat siya ni Jesus, “Dili niyo aram kun nano an iyo ginahangyo kay dapat anay ako magtios antes magahadi.” Tapos, pagsud-ong sa duha, naghunga siya, “Nano, makainom kamo sa kupa na akon pagainuman?” Nagsabat sinda, “Opo.” ");
INSERT INTO msb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Amo ngani,” an sabi niya. “Pagainuman man niyo an kupa na akon pagainuman pero an pagapaingkod sa magluyo ko wara sa akon poder kay ina para sadtoʼn natiganahan na san akon Ama.” ");
INSERT INTO msb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pakabati sani san napulo nagkaururit sa magmanghod. ");
INSERT INTO msb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero ginpahalapit sinda ni Jesus kag sinabihan, “Aram niyo na an mga namumuno san mga dili-Judio amo an mga nagadaog sa inda kag an mga bantog na namumuno naman sani amo an nagasakop sa inda. ");
INSERT INTO msb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dili ina dapat na mangyari sa iyo kundi an nagahandom magin pinakalabaw sa iyo kinahanglan magin suruguon niyo, ");
INSERT INTO msb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","kag an gusto magpalabaw sa iyo kinahanglan magpauripon man siya sa tanan ");
INSERT INTO msb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","pareho man sa akon na Anak San Tawo. Nagpakadi ako sa kinab-an dili agod sirbihan kundi magsirbe kag ihalad an akon buhay bilang pagtubos para sa kadamuan.” ");
INSERT INTO msb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Paghali ninda sa Jerico damu-damo na mga tawo an nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Didto may duha na buta na lalaki na nagaingkod sa may higad san kamino. Pakabati ninda na nagalabay si Jesus nagsiyak sinda, “Ginoo, Lahi ni David, kaluy-i man kami.” ");
INSERT INTO msb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ginsaway sinda san kadamuan kag ginpapuyo pero mas lalo lugod sinda sumiyak sin makusog, “Ginoo, Lahi ni David, kaluy-i man kami!” ");
INSERT INTO msb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Didi umudong si Jesus kag tinawag sinda, “Kadi kamo.” Tapos hinunga niya sinda, “Nano an gusto niyo na himuon ko para sa iyo?” ");
INSERT INTO msb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nagsabat sinda sa iya, “Ginoo, gusto namon na an amon mga mata makakita.” ");
INSERT INTO msb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nagbatyag sin kaluoy si Jesus sa inda tapos dinapatan an inda mga mata. Sadto mismo nakakita sinda kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","San nagadangadang na sinda Jesus sa Jerusalem nakaabot na sinda sa Betfage na adto na sa Bukid San Kaolibohan, nagsugo si Jesus sin duha na disipulos, ");
INSERT INTO msb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Kumadto kamo sa kaatubang na baryo kag pagsulod niyo makakita dayon kamo sin nakahigot na asno na may tinday. Hubadi anay niyo tapos guyuda pakadi. ");
INSERT INTO msb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kun may maghunga sa iyo sabihi, ‘Ginakinahanglan ini san Ginoo,’ kag ipapadara man dayon sa iyo.” ");
INSERT INTO msb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nangyari ini agod matuman an ginsabi san propeta: ");
INSERT INTO msb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sabiha sa katawuhan san Sion, ‘Kitaa, nagaabot dida sa iyo an iyo hadi. Mapainubuson siya na nakasakay sa asno. Oo, sa tinday san asno siya sakay.’,” ");
INSERT INTO msb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kaya naglakat an mga disipulos kag gintuman an ginsugo sa inda ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pakahubadi gin-guyod ninda an asno kag san tinday pabalik kan Jesus. Pag-abot didto ginkamadiruhan ninda san inda mga alikboy tapos nagsakay si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Damo man na mga tawo an nagralatag san inda mga alikboy sa iya aagihan agod galangan siya susog sa inda kaugalian. May mga iba naman na nag-urutod sinmga sanga san mga kahoy na naglatag man sa iya pagaagihan. ");
INSERT INTO msb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tapos an kadamuan na nagauna kag san mga nagasurunod sa iya nagasiriyak, “Umawon ini na Lahi ni David!” “Ginpalabi ini siya na nagapakadi sa ngaran san Ginoo!” “Kamo sa pinakahataas sa langit, mag-umaw man sa iya!” ");
INSERT INTO msb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagsulod na niya sa Jerusalem nagakariribok an bilog na katawuhan sa syudad, “Sin-o ini?” an hunga ninda. ");
INSERT INTO msb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nagsabat an kadamuan, “Siya an propeta na si Jesus na taga-Nazaret na sakop san Galilea.” ");
INSERT INTO msb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pagkatapos nagsulod si Jesus sa templo kag ginpaluwas niya sinda tanan na nagabaligya didto hasta man an mga nagapamakal. Pinangtumba naman niya an mga lamesa san mga parabaralyo sin kwarta kag an mga ingkudan sadtoʼn mga parabaligyaʼn mga salampati. ");
INSERT INTO msb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tapos nagsabi siya, “Nasurat sa Banal Na Kasuratan an ginsabi san Dios, ‘An pagatawagon san akon balay amo an balay na pangadyian,’ pero ginahimo lugod niyo ini bilang istaran san mga makawat.” ");
INSERT INTO msb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","May mga buta didto kag mga pilay na nagharalapit sa iya sa templo. Tapos ginpangayo niya sinda. ");
INSERT INTO msb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","May mga kabataan man na nagasiriyak sa sulod san templo, “Mabuhay an Lahi ni David!” Pakabati sani kag pakakita san mga makangangalas na ginahimo ni Jesus, nagkaururit an mga namumuno san kapadian kag mga paratukdo san Kasuguan. ");
INSERT INTO msb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kaya ginhunga ninda siya, “Nano, nakabati ka san inda ginasarabi?” “Oo,” an sabat niya. “Nano, wara pa gayod niyo ini mabasa, ‘An ba-ba san mga kabataan kag san mga madudo ginpahatag mo sin pag-umaw sa imo sadiri.’,” ");
INSERT INTO msb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pakatapos binayaan sinda ni Jesus kag nagpakadto sa syudad san Betania tapos didto siya nagpalipas san gab-i. ");
INSERT INTO msb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkaaga nagalakat sinda Jesus pagbalik sa syudad. Ginutom si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kaya pakakita niya san kahoy na higera sa may higad san kamino nagtulos siya pero wara siyaʼn nakita na bunga kundi kadahunan lang. Sana mismo nagmaldisyon siya, “Dili ka gayod magbunga hasta na lang,” tapos nag-uga dayon an puno san kahoy. ");
INSERT INTO msb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pakakita sani nagkangarawa an mga disipulos, “Napan-o kay uga dayon an higera?” ");
INSERT INTO msb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nagsabat si Jesus, “Matuod gayod na kun may pagtuod kamo kag waraʼn pagduha-duha, dili lang kay mahihimo niyo an ginhimo ko sani na puno san higera kundi bisan sabihon niyo sani na bukid, ‘Gabot kag ipilak an sadiri mo sa dagat,’ mangyayari ina. ");
INSERT INTO msb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sugad man kun may pagtuod kamo mababaton niyo an tanan na iyo ayuon paagi sa pagpangadyi.” ");
INSERT INTO msb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pagsulod naman ni Jesus sa templo naghalapit sa iya an mga namumuno san kapadian kag san mga Judio. Myintras siya nagatukdo naghunga sinda, “Kanin-o pagbuot an paghimo mo sani? Sin-o gayod an naghatag sani na otoridad sa imo?” ");
INSERT INTO msb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ginsabat naman sinda ni Jesus, “Hungaon ta man kamo kag kun masabat niyo pagasabaton ko naman kun kanin-o otoridad an paghimo ko sani. ");
INSERT INTO msb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Niyan, sabata daw ako niyo kun kanin-o pagbuot naghali an otoridad ni Juan para magpambunyag? Hali sa Dios sa langit ina o sa mga tawo?” Didi sinda nagpahurunga-hunga kun nano an ikasabat. “Kun sabihon naton, ‘Hali sa langit,’ mahunga naman siya, ‘Kun amo nano kay wara niyo siya pagtuudi?’ ");
INSERT INTO msb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero kun sabaton naman naton, ‘Hali sa tawo,’ makaharadlok man kita sa mga tawo kay ginakilala ninda tanan na propeta si Juan.” ");
INSERT INTO msb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaya an inda sabat kan Jesus amo, “Dili namon aram.” Ginsabat naman sinda niya, “Kun sugad dili ko man sasabihon sa iyo kun kanin-o otoridad ginahimo ko ini.” ");
INSERT INTO msb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Pareho baga sa masunod na istorya. Nano an masasabi niyo sani? May tawo na duha an iya anak na lalaki. Kinadto niya an magurang kag sinabihan, ‘Anak, magkadto ka yana kag magtrabaho sa ubasan.’ ");
INSERT INTO msb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Nagsabat an anak, ‘Habo ako,’ pero pagtaud-taod nakahuna-huna siya na maayo pa magkadto siya. Kaya nagpaubasan siya. ");
INSERT INTO msb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Tapos kumadto naman an ama sa manghod kag amo man an ginsugo. “Nagsabat an anak, ‘Opo, makadto ako,’ pero wara siya magkadto. ");
INSERT INTO msb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Sin-o sa duha an nagsunod sa pagbuot san ama? “An magurang,” an sabat ninda. Ginsabihan naman sinda ni Jesus, “Ginasiguro ko sa iyo na an mga parasukot san buwis kag mga malaw-ay na babayi nauuna pa sa iyo pagpasakop sa kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nagkadi ngani sa iyo si Juan pagpahayag san matuod na katanusan, ugaling, wara niyo siya pagtuudi kundi an mga nagtuod lugod sa iya an mga parasukot san buwis kag mga malaw-ay na babayi. Pero bisan ngani nakita niyo ini, wara pa gihapon kamo magliwat san isip kag magtuod sa iya.” ");
INSERT INTO msb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pamatii pa niyo ini na iba na istorya. May tawo na nagtanom sin damo na ubas. Kinudalan niya patalibod, nagbuho sin pugaan san ubas kag nagtindog sin hataas na bantayan. Tapos ginpapletihan sa mga parabantay kag nagkadto sa harayo na lugar. ");
INSERT INTO msb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pag-abot san panahon san tigpuduan, ginsugo san tag-iya an iya mga suruguon sa mga parabantay para magkuha san iya bahin na produkto san ubasan. ");
INSERT INTO msb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ginburuligan san mga parabantay an iya mga suruguon. Binaralbag an nauna, pinatay an ikaduha kag binato an ikatulo. ");
INSERT INTO msb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nagsugo pa gihapon siyaʼn iba pa na iya mga suruguon na mas damo ki san nauna pero amo man an ginhimo sa inda. ");
INSERT INTO msb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sa katapus-tapusi ginsugo niya an iya anak na lalaki sa paghuna na gagalangan ninda ini na iya anak. ");
INSERT INTO msb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pero pakakita san mga parabantay sa anak, nagkaurusad sinda pagsabi, ‘Amo ini an iredero. Kadi kamo, patyon ta siya agod an iya irensyahon sa aton na.’ ");
INSERT INTO msb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kaya ginburuligan naman ninda siya tapos gindara sa luwas kag pinatay. ");
INSERT INTO msb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Niyan kun mag-abot an tag-iya san ubasan nano kaya an iya hihimuon sadtoʼn mga parabantay?” ");
INSERT INTO msb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nagsabat sinda, “Pamatyon gayod niya idtoʼn mga nagapatay kag papapletihan sa iba na makahatag sa iya san iya bahin sa tama na panahon.” ");
INSERT INTO msb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tapos didi sinda ginhunga ni Jesus, “Nano, wara pa gayod niyo mabasa sa Banal Na Kasuratan, ‘An bato na ginhabuan sanmga parabalay amo lugod an nagin pinakaimportante na bato sa balay. An Ginoo an naghimo sani kag makangarawa gayod sa aton’? ");
INSERT INTO msb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kaya dapat ako magsabi sa iyo na kukuhaon sa iyo an kahadian san Dios kag ihahatag sa katawuhan na magatuman san kagustuhan niya. ");
INSERT INTO msb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Magakabaralian an mahulog sani na bato pero kun may mahulugan sani madudunot gayod.” ");
INSERT INTO msb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pakabati san mga namumuno san kapadian kag mga paratukdo san Kasuguan sani na mga istorya, namalisyahan ninda na sinda an ginapatamaan niya. ");
INSERT INTO msb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kaya gusto na kuntani ninda dakupon si Jesus, ugaling kay nahahadlok sinda sa mga tawo kay ginaako siya na propeta. ");
INSERT INTO msb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nag-istorya pa si Jesus sa inda manungod sa pagsulod sa kahadian san langit. ");
INSERT INTO msb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ini bagaʼn pareho sa hadi na nagpaponsya para sa kasal san iya anak na lalaki. ");
INSERT INTO msb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Niyan ginsugo san hadi an iya mga suruguon agod tawagon an mga imbitado, ugaling habo ini magkaradto. ");
INSERT INTO msb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“May mga ginsugo pa gihapon siyaʼn iba pa san iya mga suruguon. Nagsabi siya, ‘Paaramon niyo an mga imbitado na preparado na an tanan sa akon ponsya. An akonmga toro kag san ginpataba na mga baka ginparatay na. Preparado na an tanan. Kadi na kamo sa kasalan.’ ");
INSERT INTO msb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pero wara ninda pag-intyindiha an imbitasyon. May nagpakadto sa iya uma kag may iba na nag-asikaso sa iya negosyo. ");
INSERT INTO msb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","May mga iba pa gayod na gindakop an iya mga suruguon, ginpakaaluhan kag ginpangpatay. ");
INSERT INTO msb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tungod sani urit-urit gayod an hadi, kaya sinugo an iya mga suldados. Ginpatay ninda idtoʼn mga parapatay-tawo kag pinasunog an inda lungsod. ");
INSERT INTO msb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pakatapos sinabihan niya an iya mga suruguon, ‘Preparado na an ponsya pero idtoʼn mga imbitado dili angay. ");
INSERT INTO msb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kadto lugod kamo sa mga kamino sa mga lungsod kag imbitari sa ponsya an kada makita niyo.’ ");
INSERT INTO msb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kaya nagruluwas an mga suruguon kag nagkaradto sa mga kamino. Ginpangupod ninda an inda makita, maayo man o maraot. Kaya napuno sin mga bisita an lugar na ginponsyahan. ");
INSERT INTO msb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Pagsulod san hadi agod kitaon an mga bisita, may namasdan siya na tawo na dili nakabado san sa pangkasal. ");
INSERT INTO msb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kaya sinabihan niya, ‘Amigo, pan-o ka nakasulod didi na dili ka man nakabadoʼn pangkasal?’ Wara kasabat an tawo. ");
INSERT INTO msb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kaya sinugo san hadi an mga suruguon, ‘Gapusa niyo an iya kamot hasta an tiil kag iitsa paluwas sa kadulman. Didto maganguruyngoy an mga tawo kag magraragot an inda mga ngipon sa kasakit.’ ");
INSERT INTO msb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Sugad man damo an ginaimbitaran magsulod sa Kahadian san Langit pero mga pira lang an napipili.” ");
INSERT INTO msb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nagharali an mga Pariseo agod pag-iristoryahan kun pan-o ninda madakop si Jesus sa iya ginapanurmaton. ");
INSERT INTO msb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kaya ginsugo pakadto sa iya an inda mga disipulos kaupod san mga sakop ni Herodes agod sabihon, “Maestro, aram namon na matanos ka na tawo kag nagatukdo san kamatuudan manungod san pagbuot san Dios. Wara ka man sin ginapalabi bisan sin-o kay dili mo ginapanginano kun sin-o an tawo. ");
INSERT INTO msb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kun kaya, nano sa paghuna mo, tama na susog sa Kasuguan na magbayad kitaʼn buwis kan Cesar?” ");
INSERT INTO msb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero aram ni Jesus an inda maraot na kaisipan kaya sinabihan sinda, “Mga pakitaʼn-tawo, nano kay gusto niyo ako porbaran? ");
INSERT INTO msb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Abir, pakita niyo sa akon an kwarta na ginabayad niyo sa buwis.” Dinarhan siya ninda sin dinaryo. ");
INSERT INTO msb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tapos ginhunga sinda ni Jesus, “Kanin-o pamayhon kag ngaran an adi didi?” ");
INSERT INTO msb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Kan Cesar,” an sabat ninda. Kaya ginsabihan sinda ni Jesus, “Maayo, kun sugad ihatag kan Cesar an para kan Cesar kag sa Dios an para sa Dios.” ");
INSERT INTO msb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pakabati ninda sana nagkangarawa sinda. Tapos binayaan ninda siya kag nagralakat. ");
INSERT INTO msb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadto mismo na adlaw may nagkaradto man kan Jesus na pira na mga Saduceo. Ini sinda mga Judio na dili nagatuod san pagkabuhay gihapon kaya naghunga sinda sa iya, ");
INSERT INTO msb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestro, nagsugo sa aton si Moises kun may lalaki na mamatay na waraʼn anak, an manghod san lalaki dapat na asawahon an biyuda agod makaanak sinda para sa magurang na napatay. ");
INSERT INTO msb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Niyan may pito na magmaranghod na lalaki didi sa amon. Nangasawa an subang pero napatay na waraʼn anak kaya an balo gin-asawa san iya manghod. ");
INSERT INTO msb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Amo man an nangyari sa ikaduha, ikatulo na manghod hasta sa ikapito na napatay man na wara gayod sin anak. ");
INSERT INTO msb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sa katapusan napatay man an babayi. ");
INSERT INTO msb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Niyan sa pagkabuhay gihapon sin-o sa pito an pagakilalahon niya na asawa kay nagin asawa niya sinda tanan?” ");
INSERT INTO msb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero ginsabat sinda ni Jesus, “Sala kamo kay dili niyo nasasabutan an Banal Na Kasuratan kag an gahom san Dios. ");
INSERT INTO msb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sa pagkabuhay gihapon dili na magaarasawahan an mga tawo kundi pareho na san mga anghel sa langit. ");
INSERT INTO msb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Manungod naman sa pagkabuhay gihapon, nano, wara pa gayod kamo kabasa kun nano an ginsabi sa iyo san Dios, ");
INSERT INTO msb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ako an Dios ni Abraham, an Dios ni Isaac kag an Dios ni Jacob?’ An gusto sabihon sani na dili siya Dios san mga patay kundi Dios san mga buhay.” ");
INSERT INTO msb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","San pakabati sani san kadamuan nagngalas sinda san iya gintukdo. ");
INSERT INTO msb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pakabati naman san mga Pariseo na natagalpo an mga Saduceo sa sabat ni Jesus, nagtiripon sinda sa iya. ");
INSERT INTO msb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Niyan may abugado didto sa inda na naghunga agodmaporbaran siya. ");
INSERT INTO msb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestro, nano an pinakalabaw na sugo sa Kasuguan?” ");
INSERT INTO msb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nagsabat si Jesus, “‘Kamut-an mo an Ginoo na imo Dios sa imo puso, sa bilog moʼn tagipusuon kag sa tanan san imo pagaisip.’ ");
INSERT INTO msb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Amo ini an pinakalabaw kag pinakauna na sugo. ");
INSERT INTO msb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","An ikaduha naman nakapareho sani, ‘Kamut-an mo an imo kapwa pareho san pagkamuot mo sa imo sadiri.’ ");
INSERT INTO msb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Didi sani na duha na sugo ginbasi an bilog na Kasuguan ni Moises kag mga katukduan san mga propeta.” ");
INSERT INTO msb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Myintras nagkatiripon an mga Pariseo, naghunga si Jesus sa inda, ");
INSERT INTO msb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nano an masasabi niyo manungod kan Cristo? Kanin-o siya anak?” Nagsabat sinda, “Kalahi san datiʼn hadi na si David.” ");
INSERT INTO msb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nagpadayon paghunga si Jesus, “Kun sugad nano kay ‘Ginoo’ an tawag sa iya ni David san magsabi paagi sa Banal na Espirito, ");
INSERT INTO msb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nagsabi an Ginoo sa akon Ginoo, Mag-ingkod ka sa may tuo ko hasta na ipasakop ko sa imo an imo mga kaaway.’ ");
INSERT INTO msb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Niyan kun ginatawag siya ni David sin Ginoo pan-o siya magin kalahi niya?” ");
INSERT INTO msb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wara man sa inda sin nakasabat bisan usad kaya magtuna sadto wara na sin nagkusug-kusugan sin buot na maghunga sa iya. ");
INSERT INTO msb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pakatapos sadto may ginsabi naman si Jesus sa mga tawo kag sa iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“An mga Pariseo kag mga paratukdo san Kasuguan amo an mga ginakilala na paratukdo san Kasuguan na ginhatag kan Moises. ");
INSERT INTO msb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaya sunudon niyo kag himuon an nano man na ginatukdo ninda sa iyo pero ayaw kamo pagsunod san inda ginahimo kay an inda ginahimo dili susog san inda ginatukdo. ");
INSERT INTO msb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nahimo sinda sin mga sugo na bagaʼn mabug-at na dararhon kag ginapapas-an ini sa abaga san iba pero sinda mismo habo ngani magtikwil bisan usad na tudlo sa pagbulig. ");
INSERT INTO msb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ginahimo ninda an tanan agod makita san mga tawo pareho san paghigot sa inda agtang kag butkon sin mga dyutay na pitaka na may kasuratan san Kasuguan. Ginahimo man ninda na pahalabaon an adurno sa sidsid san inda sul-ot. ");
INSERT INTO msb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Naiila gayod sinda mag-ingkod sa pinakahalandon na pwesto sa mga ponsya kag sa unahan na ingkudan sa mga sinagoga. ");
INSERT INTO msb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Naiila pa sinda pagalangan sa merkado kag pagtawagon sinda na ‘Rabi,’ an gusto sabihon ‘maestro.’ ");
INSERT INTO msb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ugaling kamo naman dili dapat magpatawag sin ‘Rabi’ kay ako lang an ginatawag sani kag pareho kamo tanan bagaʼn magmaranghod. ");
INSERT INTO msb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ayaw man pagtawag sa sin-o man didi sa duta sin ‘Ama’ kay usad lang an iyo ama kag siya an Dios na adto sa langit. ");
INSERT INTO msb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dili man kamo magpatawag sin ‘Maestro’ kay usad lang an iyo paratukdo. Siya an Cristo. ");
INSERT INTO msb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","An pinakalabaw sa iyo magigin suruguon niyo, ");
INSERT INTO msb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","kay an nagapakalabaw papakamenuson kag an nagapakamenos papalabawon.” ");
INSERT INTO msb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Ginasirahan niyo an kahadian san langit sa mga tawo. Kamo mismo dili nagasulod kag dili man niyo ginatugutan magsulod idtoʼn mga gusto. ");
INSERT INTO msb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Nagaprobitsar kamo san mga kasadirihan san mga balo kag nagapangadyi kamo sin halagba sa atubangan san mga tawo para lang magpakita, kaya tungod sani mas grabe gayod an kastigo niyo. ");
INSERT INTO msb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy pa kamo kay mga pakitaʼn-tawo lang! Ginalibot niyo an kadagatan kag kadutaan na makadara kamo sin dili-Judio na magin Judio, tapos ginahimo niyo na sobra pa siya kaangay na mapaimpyerno ki sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Makaluluoy gayod kamo kay bagaʼn mga buta na nagaparakabit sin iba na mga buta. Kamo an nagatukdo na kun may nagasumpa paagi sa pagsambit san templo dili siya obligado pero kun may nagasumpa paagi sa pagsambit san oro na ada sa templo obligado gayod siya. ");
INSERT INTO msb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bagaʼn buta kamo kag mga buang! Nano an mas mahalaga, an oro o an templo na amo an nagapabanal sa oro? ");
INSERT INTO msb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Nagatukdo pa kamo na kun may nagasumpa paagi sa pagsambit san altar dili siya obligado pero kun may nagasumpa paagi sa pagsambit san halad na ada sa altar obligado gayod siya! ");
INSERT INTO msb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bagaʼn mga buta kamo! Nano an mas mahalaga, an halad o an altar na nagapabanal sa halad? ");
INSERT INTO msb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","An nagasumpa paagi sa pagsambit san altar ginasumpa man an tanan na ada sana. ");
INSERT INTO msb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","An nagasumpa naman paagi sa pagsambit san templo nagasumpa man paagi mismo sani kag san Dios na nagaistar dida. ");
INSERT INTO msb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","An nagasumpa paagi sa pagsambit san langit nagasumpa man paagi sa trono san Dios kag sa nagaingkod dida. ");
INSERT INTO msb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Kamo an mga nagaharalad sin ikanapulo na parte san bisan mga utanon na waraʼn pulos pero ginapabayaan an mga mahalaga na bagay san Kasuguan na amo an katanusan, pagkaluoy kag pagkamatinumanon! Amo ini an dapat niyo sunudon na dili man gihapon napapabayaan an iba. ");
INSERT INTO msb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bagaʼn buta kamo na parakabit san mga buta! Pareho kamo san nagasara san dyutay na tayangaw sa iya irimnon pero nagatulon san bilog na daku-dako na kamelyo. ");
INSERT INTO msb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Ginalinisan niyo an sa luwas san iyo tasa kag plato pero sa sulod puno sin pandaya kag kapasluan. ");
INSERT INTO msb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamo na bagaʼn mga buta na Pariseo, linisi anay an sulod san iyo tasa kag plato tapos ginlinisan man ngani hasta an sa luwas. ");
INSERT INTO msb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Baga kamoʼn mga pantyon na ginpaputi. Sa luwas matahom kitaon pero sa sulod puno san mga tul-ang san mga tawo na namatay kag san tanan na mga kaatian. ");
INSERT INTO msb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pareho man kamo sana! Sa luwas bagaʼn matanos pero sa sulod mga pagpakitaʼn-tawo lang kag makasal-anon.” ");
INSERT INTO msb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mga Pariseo kag mga paratukdo san Kasuguan, makaluluoy gayod kamo kay mga pakitaʼn-tawo lang! Nagatindog kamoʼn mga rulubngan san mga propeta kag ginadikuraran an mga monumento san mga kasadto na matanos na tawo. ");
INSERT INTO msb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","An ginasabi niyo, ‘Kun buhay na kami sa panahon san amon mga kalulululuhi, dili gayod kami nadamay sa mga nagpatay san mga propeta!’ ");
INSERT INTO msb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kaya kamo man gihapon an nagatestigo kontra sa iyo sadiri na kamo mga lahi san nagpapatay sa mga propeta! ");
INSERT INTO msb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sige, tapusa na lang niyo an maraot na gintunaan san iyo mga kalulululuhi. ");
INSERT INTO msb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mga sawa kamo kag mga lahi sani! Kakastiguhon kamo san Dios sa impyerno. Pan-o kamo makalibre sani? ");
INSERT INTO msb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kun kaya ngani mapadara ako sin mga propeta, mga madunong na tawo kag mga paratukdo san Kasuguan na an iba sa inda iyo pagapatayon kag igapako sa krus. An iba naman iyo pagalatiguhon sa mga sinagoga kag pagapasakitan sa mga kalungsudan. ");
INSERT INTO msb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Dahilan sani may magaabot sa iyo na kastigo sa pagpatay san tanan na matanos na tawo sa kinab-an magtuna sa pagpatay sa waraʼn sala na si Abel hasta sa pagpatay sa anak ni Baraquias na si Zacarias na iyo ginpatay sa katung-anan san pinakabanal na lugar sa templo kag san altar. ");
INSERT INTO msb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ginasiguro ko sa iyo na ini tanan mangyayari sa mga tawo na nabubuhay yana.” ");
INSERT INTO msb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mga taga-Jerusalem! Mga taga-Jerusalem! Marasa pa na ginapatay niyo an mga propeta kag ginabato idtoʼn mga ginsugo sa iyo san Dios! Kadamo na beses ngani na ako naghandom na tipunon kamo pareho san umagak na ginatiripon an iya mga piso sa idalom san iya mga pakpak pero ginhabuan niyo! ");
INSERT INTO msb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bahala na kamo kay pagapabayaan an iyo kabalayan kag dili na pagaistaran. ");
INSERT INTO msb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tandaan an masasabi ko na sa iyo: dili na niyo ako makikita gihapon hasta na magsabi kamoʼn, ‘Palabihon lugod san Dios an nagapakadi sa ngaran san Ginoo!’,” ");
INSERT INTO msb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Paghali ni Jesus sa templo, nagharalapit an mga disipulos agod ipakita sa iya na matahom ini. ");
INSERT INTO msb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero sinabat niya sinda, “Nakikita niyo ini tanan? Ginasiguro ko sa iyo na waraʼn nagaturumbawan na bato didi na mabibilin ni usad kay an tanan maruruba.” ");
INSERT INTO msb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","San nakaingkod si Jesus sa may Bukid San Kaolibohan nagkaradto sa iya an mga disipulos na sinda-sinda lang tapos nagsabi, “Sabihi kami kun san-o ini mangyayari kag nano an tanda na igapakita san imo pagbalik kag san katapusan san kinab-an.” ");
INSERT INTO msb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nagsabat si Jesus, “Maglikay gayod kamo na dili maluko san sin-o man, ");
INSERT INTO msb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","kay damo an magaabot na masambit san ngaran ko kag magaangkon, ‘Ako an Cristo.’ Kaya damo na mga tawo an pagalukuhon ninda. ");
INSERT INTO msb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ayaw kamo pagkahandal sa mga barita na may mga gyera o mga nagasabi-sabi na may gyera na maabot. Dapat ini mangyari pero dili pa ina an katapusan. ");
INSERT INTO msb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Magagyerera pa man an mga nasyon kag an mga kahadian naman magapauruataki. Magkakaigwa sin grabe na gutom kag mga paglinog sa damoʼn lugar. ");
INSERT INTO msb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ini tanan pagtuna pa lang san kalisudan na bagaʼn pagsakit sa pag-anak. ");
INSERT INTO msb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tapos dadakupon kamo kag iintriga agod kastiguhon kag ipapatay. Pagakabadlian man kamo san katawuhan san tanan na nasyon dahilan sa akon. ");
INSERT INTO msb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Sani na panahon may damo na mawawaraan sin pagsarig. May mga magapaturutraydoran kag magaururitan sa kada usad. ");
INSERT INTO msb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Damoʼn maruluwas na mga buwaon na mga propeta. Damo sindaʼn pagalukuhon ");
INSERT INTO msb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","kag dahilan sa paglukop san karautan sa kinab-an mawawara an pagkamuot san haros tanan na mga tawo sa Dios. ");
INSERT INTO msb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero masasalbar an may masarig na pagtuod hasta sa katapusan san buhay. ");
INSERT INTO msb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Igapahayag man sa bilog na kinab-an ini na Maayo Na Barita manungod san kahadian agod makabati an tanan na katawuhan. Sani pa lang mangyayari an katapusan.” ");
INSERT INTO msb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Niyan kasadto pa ginpahayag san propeta na si Daniel an manungod san ‘bagay na mauuritan gayod san Dios kag magapasira sa tawo.’ Dapat gayod na masabutan ini san nagabasa. Pakakita niyo na ini nakatungtong na sa banal na lugar, ");
INSERT INTO msb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","dapat magdulag na sa mga kabukidan idtoʼn adto sa Judea. ");
INSERT INTO msb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kun may tawo na adto sa atop dili na siya dapat maglusad pa agod magkuha san iya mga garamiton. ");
INSERT INTO msb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kun may tawo naman na adto na sa uma, dili na gayod siya dapat mag-uli pa para magkuha san iya bado. ");
INSERT INTO msb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kun sugad kamakaluluoy man sadtoʼn mga budos kag may mga ginapadudo pag-abot sana na panahon! ");
INSERT INTO msb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Mangadyi kamo na an iyo pagdulag dili makatagbo na tighagkutan o Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nasabi ko ini kay sana na panahon magkakaigwa sin grabe na pagtios an katawuhan na dili pa nabatyagan tuna san katuna-tunai san kinab-an hasta yana kag dili na mangyayari gihapon hasta na lang. ");
INSERT INTO msb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mala ngani kun wara pagpahalip-uta san Ginoo ina na mga adlaw wara gayod sin mabibilin na buhay. Pero alang-alang sa iya mga pinili pinahalip-ot niya ina. ");
INSERT INTO msb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kun may nagasabi sa iyo sana na panahon na, ‘Kitaa, adi an Cristo!’ o ‘Kitaa, adto siya!’ ayaw pagtuod sana. ");
INSERT INTO msb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nasabi ko ini kay damo an maruluwas na magapatuod na mga Cristo kag mga propeta sinda. Makakahimo sinda sin mga makangangawa na mga bagay kag mga milagro agod makaluko bisan sa mga pinili san Dios kun mahimo ninda. ");
INSERT INTO msb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pamatii gayod kay ginpadaanan ta na kamo antes pa ini mangyari. ");
INSERT INTO msb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kun magsabi sinda sa iyo, ‘Kitaa, adto siya sa disyerto,’ ayaw kamo pagkadto didto. Kun magsabi naman sinda, ‘Kitaa, adi siya nagatago,’ dili man kamo magtuod, ");
INSERT INTO msb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","kay pareho san kilat na nagaidlap sa sirangan hasta sa kalundan an pag-abot ko na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mangyayari gayod ini pareho san pagtiripon san mga uwak kun diin may patay.” ");
INSERT INTO msb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pakatapos lang san mga patios sana na mga adlaw pagapadulumon an adlaw, mawawar-an sin pawa an bulan, magakahurulog an mga bituon sa langit kag an mga makagagahom sa kalangitan pagauy-ugon. ");
INSERT INTO msb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sana mismo maganguruyngoy an tanan na katawuhan san kinab-an kay makikita ninda sa langit an tanda ko na Anak San Tawo. Taud-taod magaabot ako na nakatungtong sa mga dampog sa langit kag makikita san mga tawo na may gahom ako kag masilaw gayod na glorya. ");
INSERT INTO msb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tapos sa makusog na tunog san trumpita susuguon ko an akon mga anghel na tiripunon an akon mga pinili na katawuhan hali sa bilog na kinab-an. ");
INSERT INTO msb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Dapat kamo makaaram sin leksyon hali sa puno san kahoy na ginatawag higera. Pagsaringsing san mga sanga sani kag pag-uruslot san mga dahon naaaraman niyo na halapit na an kwaresma didi sa aton. ");
INSERT INTO msb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sugad man kun makita niyo idtoʼn tanan na mga pangyayari, maaaraman niyo na halapit na ako mag-abot, bagaʼn ada na lang gayod sa pwertahan. ");
INSERT INTO msb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ginasiguro ko sa iyo na mangyayari idtoʼn tanan antes na magkamaratay an mga tawo na nabuhay yana. ");
INSERT INTO msb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An langit kag duta mawawara pero magapadayon hasta na lang an akon mga surmaton.” ");
INSERT INTO msb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nagpadayon si Jesus, “Niyan manungod san oras kag adlaw san akon pagbalik waraʼn iba na maaram kundi an Ama lang. Bisan ngani an mga anghel sa langit kag ako mismo na iya anak dili maaram. ");
INSERT INTO msb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pero makapareho san kamutangan san kapanahunan ni Noe an kamutangan didi sa kinab-an pagbalik ko na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sadto na panahon antes nagbaha an kinab-an wara pag-intyindiha san mga tawo. Adlaw-adlaw nagakaraon sinda, nagairinom kag kun minsan nagaarasawa hasta sa adlaw na nag-sulod si Noe sadtoʼn sarakyan sa tubig na ginatawag arka. ");
INSERT INTO msb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wara ninda namangnuhi an mangyayari hasta na bumuhos an baha kag inanod sinda tanan. Sugad man sani an kamutangan sa pag-abot ko na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sana man mismo may duha na lalaki na nagatrabaho sa umahan. Kukuhaon an usad kag an iya kaupod ibibilin. ");
INSERT INTO msb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","May duha naman na babayi na nagagiling. Kukuhaon an usad kag an iya kaupod ibibilin. ");
INSERT INTO msb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaya magbantay kamo kay dili niyo aram kun san-o maabot an iyo Ginoo. ");
INSERT INTO msb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandai ini: kun may tag-iya san balay na aram an oras pagkagab-i na magaabot an makawat, magabantay gayod siya kag dili niya pagatugutan na masulod an iya balay. ");
INSERT INTO msb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaya kamo man dapat na pirme magbantay kay magaabot ako na Anak San Tawo sa oras na dili niyo ginalauman.” ");
INSERT INTO msb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Niyan kun sin-o man an matinumanon kag madunong na suruguon, siya an ginpaniwalaan san iya amo sa iba pa na mga suruguon agod magpakaon sa inda sa tama na oras. ");
INSERT INTO msb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kaya malipay ina na suruguon kun ina an ginahimo niya pagbalik san iya amo. ");
INSERT INTO msb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ginasiguro ko sa iyo na igapaniwala sa iya san amo an tanan niya na kasadirihan. ");
INSERT INTO msb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero kun maraot ina na suruguon, iisipon niya, ‘Madudugay pa an akon amo’. ");
INSERT INTO msb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kaya pagabalbagon an iya mga kapwa suruguon, tapos makikaon kag makiinuman kaupod san mga parahubog. ");
INSERT INTO msb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tapos sa adlaw na dili niya ginalauman magaabot an iya amo sa oras na dili niya aram. ");
INSERT INTO msb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Didi kakastiguhon siya kag ibibiyo sa mga pakitaʼn-tawo lang. Didto maganguruyngoy an mga tawo kag magararagot an inda mga ngipon sa kasakit.” ");
INSERT INTO msb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nagpadayon si Jesus, “Sana na panahon san pagbalik ko an pagsulod sa kahadian san langit pareho san napulo na abay na kadaragahan na nagruluwas agod sugaton an karaslon na lalaki. Nagdara man sinda san inda mga ilawan. ");
INSERT INTO msb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima sa inda an mga patal kag lima an mga madunong. ");
INSERT INTO msb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","An mga patal may dara na mga ilawan pero wara magdaraʼn risirba na lana. ");
INSERT INTO msb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","An mga madunong naman may dara man na mga ilawan, amo man an puno na surudlan san lana. ");
INSERT INTO msb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nadugay an karaslon na lalaki kaya inabot sin kapirawon an mga daraga kag nagkaraturog an tanan. ");
INSERT INTO msb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“San matungaʼn gab-i na may nagsiyak, ‘Adi na an karaslon na lalaki! Luwas na kamo agod sugaton siya!’ ");
INSERT INTO msb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kaya nagbarangon an mga daraga tapos ginpreparar an inda mga ilawan. ");
INSERT INTO msb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Didi naghangyo an mga iba sa mga madunong, ‘Hatagi man kami san iyo lana kay mapaparong na an amon ilawan.’ ");
INSERT INTO msb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Pero nagsabat an mga madunong, ‘Basi dili makaigo sa aton tanan. Mas maayo pa na kumadto kamo sa nagabaligya kag magbakal san para sa iyo.’ ");
INSERT INTO msb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nakahali lang sinda agod magbakal sin lana san mag-abot an karaslon na lalaki. Idtoʼn mga preparado nakaupod sa iya pagsulod sa ponsya san kasalan, tapos sinirahan an pwertahan. ");
INSERT INTO msb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Taud-taod nag-abot naman an iba na mga abay na nagatarawag, ‘Sir, Sir, abrihi man kami.’ ");
INSERT INTO msb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pero ginsabat san karaslon na lalaki, ‘Dili ini maabri kay dili ta gayod kamo kilala.’,” ");
INSERT INTO msb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tapos ginsabihan sinda ni Jesus, “Magin maikmat gayod kamo pareho sadtoʼn mga madunong kay dili niyo aram an adlaw o an oras san akon pagbalik.” ");
INSERT INTO msb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nagpadayon si Jesus, “Amo gihapon ini nakapareho sa tawo na mapakadto sa iba na lugar. Antes maglakat ginpatawag niya an iya mga suruguon kag ginpaniwala sa inda an iya kapital. ");
INSERT INTO msb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ginhatagan niya an kada usad susog sa inda kakayahan sa pagnegosyo. An una hinatagan niyaʼn lima ka kwarta na oro, an ikaduha, duha ka kwarta na oro, kag an ikatulo, usad ka kwarta na oro. Pakatapos lumakat na siya. ");
INSERT INTO msb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“An ginhatagan sin lima ka kwarta na oro lumakat man dayon, tapos ginnegosyo kag nakaganansya sin lima pa. ");
INSERT INTO msb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","An nakabaton naman sin duha ka kwarta na oro amo man an ginhimo kag nakaganansya sin duha pa. ");
INSERT INTO msb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero an nakabaton sin usad ka kwarta na oro nag-uli, tapos nagbuho sa duta kag didto gintago an kwarta san iya amo. ");
INSERT INTO msb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Sa kadugayan, nagbalik an amo sadtoʼn mga suruguon kag ginkwenta an mga ginbilin sa inda. ");
INSERT INTO msb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naghalapit an nakabaton sin lima ka kwarta na oro na dara an ganansya na lima pa. Tapos nagsumat siya, ‘Sir, adi an lima ka kwarta na oro na ginbilin mo sa akon kag san ganansya pa na lima.’ ");
INSERT INTO msb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Didi sinabihan siya san iya amo, ‘Maayo an ginhimo mo, masarig kag matinumanon na suruguon. Kay matinumanon ka sa pira na mga bagay, kaya ginapamahala ko sa imo an mas damo. Kadi kag makiglipay ka kaupod ko na imo amo!’ ");
INSERT INTO msb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tapos naghalapit man an ginbilinan niya sin duha ka kwarta na oro na nagasabi, ‘Sir, adi man an ginbilin mo sa akon na duha ka kwarta kag san ganansya pa na duha.’ ");
INSERT INTO msb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Didi ginsabihan man siya, ‘Maayo an ginhimo mo, masarig kag matinumanon na suruguon. Kay matinumanon ka sa pira na mga bagay, kaya igapamahala ko man sa imo an mas damo. Kadi kag makiglipay ka kaupod ko na imo amo!’ ");
INSERT INTO msb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Idto naman na ginbilinan sin usad ka kwarta na oro naghalapit man na nagasabi, ‘Sir, aram ko na maisog ka na tawo na nagaani san dili mo tinanom kag nagatipon san dili mo sinabwag. ");
INSERT INTO msb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nahadlok ako sani, kaya ginlubong ko an imo kwarta sa duta. Niyan adi ngani an ginbilin mo sa akon.’ ");
INSERT INTO msb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Pero ginsabat siya san iya amo, ‘Maraot kag tamad na suruguon! Nano, aram mo gali na nagaani ako san dili ko tinanom kag nagatipon san dili ko sinabwag? ");
INSERT INTO msb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mas maayo pa na ginbilin mo sa mga nagapaporsyento an kwarta agod pagbalik ko, makabaton ako san kapital kag san akon porsyento.’ ");
INSERT INTO msb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tapos ginsugo niya an iba na suruguon, ‘Kadi, kuhaa an kwarta sa iya kag ihatag sa tawo na may napulo.’ ");
INSERT INTO msb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Nasabi ko ini kay pagadagdagan pa an igwa na agod magbugana, pero an wara-wara pagakuhaon pa an nano man na ada sa iya. ");
INSERT INTO msb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kaya ina na waraʼn pulos na suruguon itapok paluwas sa kadulman. Didto maganguruyngoy an mga tawo kag magararagot an inda mga ngipon sa kasakit!” ");
INSERT INTO msb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Nagpadayon si Jesus, “Magabalik ako na Anak San Tawo kaupod san tanan na mga anghel agod magin hadi. Didi may glorya ako san Dios kaya matahom an akon pag-abot kag may gahom man. Sani na panahon, magaingkod ako sa akon masilaw na trono agod maghadi. ");
INSERT INTO msb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","An katawuhan naman san mga nasyon pagatiripunon sa atubangan ko. Pakatapos pagalain-lainon ko sinda pareho san ginahimo san pastor paglain-lain san karnero sa mga kanding. ");
INSERT INTO msb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An mga tawo na bagaʼn sa karnero an pagtratar igabutang ko sa akon banda tuo kag an bagaʼn sa kanding naman sa pagtratar didto sa akon wala. ");
INSERT INTO msb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Pakatapos, pagasabihan ko bilang hadi idtoʼn mga sa tuo ko, ‘Kadi, kamo na mga ginpalabi san akon Ama, iredara niyo an kahadian na ginpreparar para sa iyo tuna pa san paglalang san kinab-an. ");
INSERT INTO msb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","San nagutom ako ginpakaon niyo. San napaha ginpainom niyo. Dayo ako pero ginpadayon niyo. ");
INSERT INTO msb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Huba ako kaya ginbaduan niyo, masakit kag gin-ataman, priso kag ginbisita man niyo!’ ");
INSERT INTO msb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Didi, magahunga sa akon an mga matanos, ‘Ginoo, kasan-o ka namon nakita na gutom tapos ginpakaon? Napaha, tapos ginpainom? ");
INSERT INTO msb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kasan-o ka naman namon nakita na dayo pero ginpadayon ka man, huba kaya ginbaduan? ");
INSERT INTO msb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kasan-o ka pa gayod namon nakita na masakit o adto sa prisuhan kag ginbisita?’ ");
INSERT INTO msb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Bilang hadi masabat man ako sa inda, ‘Ginasiguro ko sa iyo na an tanan na ginhimo niyo sa bisan usad sani na mga pinakamenos ko na parasunod, ginhimo man niyo sa akon.’ ");
INSERT INTO msb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pakatapos sasabihan ko man an mga adto sa wala ko, ‘Magpaharayo kamo sa akon. Kamo na mga ginmaldisyon, kakastiguhon kamo sa dili napaparong na kalayo na ginpreparar para kan Satanas kag sa iya mga sakop. ");
INSERT INTO msb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay san gutom ako wara niyo pagpakauna. San napaha ako wara niyo pagpainuma. ");
INSERT INTO msb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dayo ako pero wara niyo pagpadayuna, huba pero wara niyo pagbadui, masakit kag priso pero wara niyo pagbisitaha.’ ");
INSERT INTO msb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Didi man sinda mahunga, ‘Ginoo, kasan-o ka namon nakita na gutom o paha o dayo, huba o masakit o adto sa prisuhan pero wara mag-ataman sa imo?’ ");
INSERT INTO msb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Pagasabaton ko sinda, ‘Ginasiguro ko sa iyo na sa oras na naghabo kamo paghimo bisan usad sani na mga pinakamenos ko na parasunod, wara man niyo paghimua sa akon.’ ");
INSERT INTO msb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ini sinda papakadtuon sa kastigo na waraʼn katapusan, pero an mga matanos sa buhay na waraʼn katapusan.” ");
INSERT INTO msb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pakatapos ni Jesus pagtukdo sani tanan, ginsabihan niya an iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Aram niyo na duha pa ka adlaw pyista na sa Paskwa. Dida dadakupon ako na Anak San Tawo tapos ipapako sa krus.” ");
INSERT INTO msb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sadto mismo na kaurason an mga namumuno san kapadian kag san mga namumuno san mga Judio nagtiripon sa palasyo san pinakapuno na padi na amo si Caifas. ");
INSERT INTO msb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Didto nagplano sinda na ipadakop sin patraydor si Jesus kag ipapatay. ");
INSERT INTO msb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero nagkauruyon sinda, “Dili ini dapat himuon sa kapyistahan kay basi magsaramok an mga tawo.” ");
INSERT INTO msb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","San adto sa Betania si Jesus sa balay ni Simon na kasadto may leproso, ");
INSERT INTO msb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","may nagkadto sa iya na babayi. May dara iniʼn surudlan na hinimo sa alabastro na bato puno sin pahumot na mahalon. Ginbu-bo niya ini sa ulo ni Jesus myintras adto siya sa may lamesa. ");
INSERT INTO msb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pakakita sani naurit an mga disipulos tapos nagahunga, “Nano kay ginsayang ina? ");
INSERT INTO msb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mababaligya kuntani sin mahal an sugad sana na pahumot kag an kabaklanan sana ikapanghatag sa pobre.” ");
INSERT INTO msb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Namangnuhan ni Jesus an ginasabi ninda kaya ginhunga man sinda, “Nano kay ginapakiaraman niyo inaʼn babayi? Maayo kag matahom an ginhimo niya sa akon. ");
INSERT INTO msb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Adi pirme sa iyo an mga pobre pero ako dili pirme adi sa iyo. ");
INSERT INTO msb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pagbu-bo niya sani na pahumot sa akon lawas hinimo niya ini bilang preparasyon sa paglubong sa akon. ");
INSERT INTO msb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ginasiguro ko sa iyo na ini na nahimo sani na babayi igaistorya man bilang pagdumdom sa iya bisan diin igapahayag an Maayo Na Barita manungod sa akon sa bilog na kinab-an.” ");
INSERT INTO msb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pakatapos sadto si Judas Iscariote na usad san mga dose na disipulos nagpakadto sa mga namumuno san kapadian. ");
INSERT INTO msb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pag-abot sa inda ginhunga niya, “Kun iintriga ko sa iyo si Jesus, pira an ihahatag sa akon?” Dahilan sani nagkauruyon sinda sa 30 bilog na plata kag ginhatagan siya. ");
INSERT INTO msb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kaya tuna sadto nagahanap si Judas sin maayo na oportunidad agod traydoran si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa primero na adlaw san kapyistahan san Tinapay Na Waraʼn Lebadura nagkaradto kan Jesus an iya mga disipulos na nagahunga, “Diin mo gusto ipreparar namon an pagkaon sa Paskwa?” ");
INSERT INTO msb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nagsabat siya, “Kumadto kamo sa syudad. Didto may tawo na iyo sasabihan, ‘Nagapasabi an Maestro, Halapit na an oras san akon pagkamatay kaya sa imo balay ako magakaon san panihapon sa Paskwa kaupod an akon mga disipulos.’,” ");
INSERT INTO msb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ginsunod naman sanmga disipulos an gintugon sa inda ni Jesus kag ginpreparar an pagkaon sa Paskwa. ");
INSERT INTO msb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkagab-i adto na sinda Jesus kag san iya dose na disipulos sa inda mga pwesto sa lamesa. ");
INSERT INTO msb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","San nagakaraon sinda nagsabi siya, “Matuod na may usad sa iyo na matraydor sa akon.” ");
INSERT INTO msb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pakabati sani nagkamurundo gayod sinda, tapos usad-usad na naghunga sa iya, “Nano, Ginoo, ako ina?” ");
INSERT INTO msb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Didi nagsabat si Jesus, “An kadungan ko pagsawsaw sa mangko amo an matraydor sa akon. ");
INSERT INTO msb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mangyayari gayod ini sa akon na Anak San Tawo susog sa nasurat sa Banal Na Kasuratan pero kamakaluluoy man sana na matraydor sa akon! Maayo pa lugod sana na tawo na dili na lang siya gin-anak.” ");
INSERT INTO msb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Si Judas naman na amo an magtraydor sa iya naghunga man, “Nano, Ginoo, ako ina?” Ginsabat siya ni Jesus, “Ikaw an nagsabi sana.” ");
INSERT INTO msb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","San nagakaraon pa sinda kumuha si Jesus sin tinapay, nagpasalamat sa Dios, gin-utud-utod kag ginpanghatag sa mga disipulos tapos nagsabi, “Kaon kamo. Ini an akon lawas.” ");
INSERT INTO msb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pakatapos may ginkuha siya na kupa kag, pakapasalamat sa Dios, hinatag sa inda kag nagsabi, “Inom kamo, ");
INSERT INTO msb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kay ini an akon dugo na amo an pagpamatuod san sinumpaan san Dios. Pagapaawason ini para sa kadamuan agod mapatawad an inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ginasiguro ko sa iyo na dili na ako mainom gihapon sin duga san mga ubas hasta pag-abot san adlaw na mainom ako san bag-o na bino kaupod niyo sa kahadian san akon Ama.” ");
INSERT INTO msb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pakatapos ninda pagkanta san salmo nagpakadto sinda sa Bukid San Kaolibohan. ");
INSERT INTO msb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Didto ginsabihan sinda ni Jesus, “Yana na gab-i magdudurulag kamo tanan kag babarayaan niyo ako kay nasurat sa Banal Na Kasuratan, ‘Papatayon ko an nagaataman tapos maburulag an manada san mga karnero.’ ");
INSERT INTO msb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero pagkabuhay ko gihapon mauuna ako sa iyo sa Galilea.” ");
INSERT INTO msb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pakabati sani nagsabi si Pedro, “Dili gayod ako mabaya bisan magbaraya sinda tanan.” ");
INSERT INTO msb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Didi sinabat siya ni Jesus, “Ginasiguro ko sa imo na yana mismo na gab-i antes magturaok an manok pagapaambutan mo ako sin makatulo na beses.” ");
INSERT INTO msb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nagsabi naman si Pedro sa iya, “Dili ta ikaw pagapaambutan bisan ako mamatay kaupod mo.” Amo man an ginsarabi san tanan na mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Niyan nagkadto si Jesus kaupod an iya mga disipulos sa lugar na ginatawag na Getsemani. Didto ginsabihan naman niya sinda, “Didi anay kamo mag-ingkod myintras mapangadyi ako sa may uruunhan.” ");
INSERT INTO msb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tapos gin-agda niya si Pedro kag san duha na anak ni Zebedeo na mag-upod sa iya. Pag-abot didto nakabatyag si Jesus sin dako na kahandal kag pagkamundo. ");
INSERT INTO msb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kaya ginsabihan niya sinda, “Namumundo gayod ako na bagaʼn mapapatay. Maghulat kamo didi kag magbantay kaupod ko.” ");
INSERT INTO msb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pagpauruunhan pa niya naghapa sa duta tapos nagpangadyi, “Ama ko, kun mahimo halia man sa akon ini na kupa pero dili an akon pagbuot kundi an sa imo lugod an masunod.” ");
INSERT INTO msb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Taud-taod pagbalik niya sa tulo na disipulos naabtan niya na tururog. Kaya ginhunga niya si Pedro, “Nano, dili niyo kaya magbantay kaupod ko sin usad lang ka oras? ");
INSERT INTO msb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kinahanglan kamo magbantay kag magpangadyi agod dili masugtan kay bisan makusog an pagbuot an lawas maluya.” ");
INSERT INTO msb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa ikaduha na beses nagharayo gihapon si Jesus kag nagpangadyi, “Ama ko, kun dili man lang mahali sa akon ini na kupa hasta na dili ko mainumnan, matuman lugod an pagbuot mo.” ");
INSERT INTO msb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pagbalik naman niya sa mga disipulos naabtan man gihapon niya sinda na tururog kay ginadaog na gayod ini sinda san kapirawon. ");
INSERT INTO msb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kaya binayaan naman niya sinda tapos sa ikatulo na beses nangadyi gihapon na amo man an ginasabi. ");
INSERT INTO msb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sa katapus-tapusi nagbalik siya sa mga disipulos kag sinabihan, “Nano, tururog pa ba gihapon kamo kag nagapahuruway? Kitaa baya niyo, adi na an oras na ako na Anak San Tawo igaintriga sa mga parakasala. ");
INSERT INTO msb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangon na kamo! Kitaa! Ada na an matraydor sa akon kaya hamos na kita.” ");
INSERT INTO msb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nagasurmaton pa si Jesus san mag-abot si Judas, usad san dose na disipulos. May mga kaurupod siya na damo na katawuhan na sinugo san mga namumuno san kapadian kag mga namumuno san mga Judio. Armado man sinda sin mga talibong kag mga balbag. ");
INSERT INTO msb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Antes pa sani nagkasarabot na sinda na si Judas mahatag sin tanda sa inda, “An harukan ko amo na ina siya kaya dakupon niyo.” ");
INSERT INTO msb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nagdiretso man dayon si Judas pagtulos kan Jesus kag nagsabi, “Kumusta ka, Sir?” tapos hinarukan siya. ");
INSERT INTO msb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Didi nagsabi si Jesus sa iya, “Amigo, himua na dayon an tuyo mo.” Pakasabi sani ginturulos siya ninda kag dinakop. ");
INSERT INTO msb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dahilan sadto usad san mga parasunod ni Jesus an nagbugnot san iya talibong kag may tinigbas na suruguon san pinakapuno san kapadian kaya nautas an talinga sani. ");
INSERT INTO msb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ugaling sinabihan siya ni Jesus, “Ibalik mo sa taguban an imo talibong kay an tanan na nagagamit sana mapapatay man paagi sana. ");
INSERT INTO msb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nano, dili mo aram na kun gugustuhon ko makapangayo akoʼn bulig sa akon Ama na magsugo sin 7,000 na mga anghel agod magbantay sa akon? ");
INSERT INTO msb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero kun sugad sani pan-o matuman an Banal Na Kasuratan na nagasabi na ini dapat mangyari?” ");
INSERT INTO msb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tapos inatubang ni Jesus an kadamuan kag ginhunga, “Nano, tulisan an paghuna niyo sa akon kay nagdarara pa kamo sin mga talibong kag mga balbag para lang dakupon ako? Adto ako pirme uruadlaw na nagatukdo sa templo pero wara man niyo pagdakupa. ");
INSERT INTO msb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nangyari ugaling ini tanan agod matuman an mga nasurat san mga propeta.” Didi binarayaan siya san tanan na mga disipulos kag nagdurulag. ");
INSERT INTO msb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Didto sa balay ni Caifas na pinakapuno san kapadian dinara si Jesus san mga tawo na nagdakop sa iya. Adto man didto nagtiripon an mga paratukdo san Kasuguan kag mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nagsunod naman si Pedro pero sa huruharayo kag pag-abot sa balay san pinakapuno san kapadian nagsulod siya sa natad tapos nag-ingkod katakin san mga bantay agod magmasid kun nano an mangyayari. ");
INSERT INTO msb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Niyan an mga namumuno san kapadian kag an bilog na Konseho nagapangita sin mga buwaon na testigos kontra kan Jesus agod mahusgaran siya sin kamatayon. ");
INSERT INTO msb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero wara sindaʼn maikondinar bisan pa ngani damoʼn nagtindog na nagtestigos sin kabuwaan. ");
INSERT INTO msb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","San katapus-tapusi may duha na nagtindog kag nagsabi, “Nagsurmaton ini, ‘Igwa akoʼn gahom na rubaon an templo san Dios tapos itindog man gihapon sa sulod sin tulo ka adlaw.’,” ");
INSERT INTO msb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Didi tumindog an pinakapuno na padi kag naghunga kan Jesus, “Nano, wara kaʼn ikakasabat? Nano an masasabi mo sa mga ginpasibanghod ninda kontra sa imo?” ");
INSERT INTO msb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero si Jesus nagpuyo lang. Kaya sinabihan siya san pinakapuno na padi, “Ginasugo ta ikaw sa ngaran san Dios na buhay na sabihon mo sa amon kun ikaw man gayod an Cristo na Anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ginsabat siya ni Jesus, “Ikaw an nagsabi sana pero ginasiguro ko sa iyo na dili na lang madugay makikita niyo ako na Anak san Tawo na nakaingkod sa tuo san Makagagahom. Tapos makikita naman niyo na magabalik ako sa kinab-an na nakatungtong sa mga dampog sa langit.” ");
INSERT INTO msb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dahilan sani pinaksi san pinakapuno na padi an sadiri niya na bado sa kaurit kag nagsabi, “Pagbasang-basang ini sa Dios! Nano pa na ibidinsya an kinahanglan naton? Niyan nabati pa lang niyo an iya pagbasang-basang sa Dios. ");
INSERT INTO msb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nano sa paghuna niyo?” Nagsarabat sinda, “Dapat siya patayon.” ");
INSERT INTO msb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tapos ginludaan an bayhon ni Jesus kag ginsuruntok siya. May iba pa myintras ginasampadong siya nagasarabi, ");
INSERT INTO msb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Tugmaha daw, Cristo! Sin-o an nagsampadong sa imo?” ");
INSERT INTO msb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Niyan myintras nagaingkod si Pedro sa natad san balay, may nagkadto sa iya na suruguon na babayi na ginasabihan, “Ikaw kaupod man ni Jesus na taga-Galilea.” ");
INSERT INTO msb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Didi nagpaambot si Pedro sa atubangan san tanan, “Dili ko aram kun nano an ginasabi mo.” ");
INSERT INTO msb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tapos naglakat siya pero pag-abot sa pwertahan may suruguon naman na babayi na nakakita sa iya. Sinabihan niya an mga tawo na adto didto, “Ini na tawo kaupod man sana na Jesus na taga-Nazaret.” ");
INSERT INTO msb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nagpaambot gihapon si Pedro na nagsumpa, “Dili ko kilala ina na tawo!” ");
INSERT INTO msb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagtaud-taod nag-arapiki naman gihapon kan Pedro an mga nagatirindog didto. Sinabihan ninda, “Sigurado gayod na usad ka man sa inda kay nakikilala sa imo panurmaton.” ");
INSERT INTO msb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Didi nagtuna siya pagsabi, “Maldisyunon lugod ako san Dios kun dili tama an akon ginasabi.” Tapos nagsumpa, “Dili ko kilala ina na tawo!” Sana mismo may nagturaok na manok. ");
INSERT INTO msb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tapos nadumduman ni Pedro an ginsabi sa iya ni Jesus, “Antes magturaok an manok pagapaambutan mo ako sin tulo na beses.” Didi naghali si Pedro kag nagparabakho gayod. ");
INSERT INTO msb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pagkaaga nagtiripon an tanan na namumuno san kapadian kag san mga Judio. Nagplano sinda kun pan-o ipapatay si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tapos pakagapos ninda sa iya, ginpadara pakadto kan Pilato na gobernador na taga-Roma kag didto gin-intriga si Jesus. ");
INSERT INTO msb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Si Judas naman na nagtraydor kan Jesus nagbasol gayod san iya ginhimo san maaraman na ginhusgaran ini sin kamatayon. Kaya inuli niya an 30 ka bilog na plata sa mga namumuno san kapadian kag san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","An sabi niya, “Nagkasala ako paagi san pagtraydor ko san waraʼn kasalasala na tawo.” Pero ginsabat siya ninda, “Nano an labot namon sana? Ikaw sana an may labot.” ");
INSERT INTO msb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tapos pinilak ni Judas an 30 ka bilog na plata sa may salog san templo tapos humali kag nagbitay san iya sadiri. ");
INSERT INTO msb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinamurot naman san mga namumuno san kapadian an mga plata kag nagsarabi, “Dili ini dapat ihulog sa surudlan san kwarta para sa templo kay kabayadan ini sin kamatayon.” ");
INSERT INTO msb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kaya nagkaurusad sinda na ibakal sin uma san parahimoʼn kuron agod himuon na rulubngan san mga dayo. ");
INSERT INTO msb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dahilan sani gintawag idto na Uma san Dugo hasta niyan. ");
INSERT INTO msb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tapos natuman gayod an sinabi san propeta na si Jeremias, “30 ka bilog na plata an kantidad na ginkauruyunan san mga taga-Israel na ibayad para sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kinuha ninda ina kag uma an ginbakal ninda sa parahimo sin kuron pareho san ginsugo sa akon san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Niyan adto na si Jesus ginapaatubang sa gobernador. Tapos ginhunga siya sani, “Nano, ikaw an hadi san mga Judio?” Nagsabat si Jesus, “Ikaw an nagsabi sana.” ");
INSERT INTO msb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","San ginaakusar naman siya san mga namumuno san kapadian kag san mga Judio wara gayod siya magsabat. ");
INSERT INTO msb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kaya ginhunga gihapon siya ni Pilato, “Nano, dili mo nababati an tanan na mga akusasyon ninda kontra sa imo?” ");
INSERT INTO msb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero wara lang gayod gihapon magsabat si Jesus sin nano man sa inda. Kaya nagngalas gayod si Pilato. ");
INSERT INTO msb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Niyan sa kada pyista sugad sani nakaugalian na san gobernador na magpaluwas sin priso na gusto paluwason san mga tawo. ");
INSERT INTO msb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sadto naman may bantog na priso na an ngaran Barabas. ");
INSERT INTO msb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kaya san pagtiripon san kadamuan hinunga sinda ni Pilato, “Sin-o an gusto niyo na paluwason ko: si Barabas o si Jesus na ginatawag na Cristo?” ");
INSERT INTO msb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ginhimo ini ni Pilato kay aram niya na gin-akusar si Jesus dahilan sa pagkaawa. ");
INSERT INTO msb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pwera pa sani myintras nagaingkod na siya sa paghusgar may ginpasabi sa iya an iya asawa, “Ayaw pagpakiaram sana na matanos na tawo kay sani na adlaw damo akoʼn gintios paagi sa panamguhan manungod sana na tawo.” ");
INSERT INTO msb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ugaling an mga namumuno san kapadian kag san mga Judio ginsulsulan na an kadamuan na palibrihon si Barabas pero si Jesus ipapatay. ");
INSERT INTO msb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaya ginhunga gihapon sinda san gobernador, “Sin-o sa duha an gusto niyo na palibrihon ko?” “Si Barabas,” an sabat ninda. ");
INSERT INTO msb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Kun sugad nano an himuon ko sani na tawo na ginatawag na Cristo?” hunga naman ni Pilato. Nagsiriyak an tanan, “Ipapako siya sa krus!” ");
INSERT INTO msb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Naghunga gihapon si Pilato, “Kay nano? Nano an karautan na nahimo niya sa iyo?” Pero mas lalo na nagsiriyak sindaʼn makusog, “Ipapako siya sa krus!” ");
INSERT INTO msb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pakakita ni Pilato na wara siyaʼn mahimo kundi nagatuna naman magsamok an katawuhan nagkuha siyaʼn tubig tapos ginhugasan an iya mga kamot sa atubangan san kadamuan na nagasabi, “Wara akoʼn labot sa kamatayon sani na tawo. Kamo na an bahala.” ");
INSERT INTO msb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nagsarabat naman an tanan na katawuhan, “Kami kag san amon mga kaanakan amo an bahala manabat san iya kamatayon.” ");
INSERT INTO msb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kaya pinalibre ni Pilato si Barabas para sa inda pero si Jesus naman ginpalatigo, tapos gin-intriga sa inda para ipapako sa krus. ");
INSERT INTO msb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Paghali didto ginguyod si Jesus san mga suldados ni Pilato pasulod sa palasyo san gobernador kag ginpatiripon patalibod niya an tanan na kasuldadosan. ");
INSERT INTO msb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hinubaan anay ninda si Jesus tapos ginsul-utan sin lila na kapa. ");
INSERT INTO msb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pakahimui ninda sin korona hali sa sanga na tunukon, ginkoronahan kag ginpahuyot siya sin bagakay sa iya tuo na kamot. Bilang pagtuya-tuya sa iya nagaluhud-luhod tayuay sinda sa iya atubangan kag nagasarabi, “Mabuhay an Hadi san mga Judio!” ");
INSERT INTO msb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ginaludaan siya ninda kag ginakuha an bagakay tapos ginbalbag sa ulo. ");
INSERT INTO msb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","San matubsan na sinda sin kakatuya-tuya sa iya, ginhubaan naman siya kag ginsul-utan san iya mismo bado, tapos ginguyod siya paluwas agod ipako sa krus. ");
INSERT INTO msb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pagluwas ninda may nasugat na lalaki na taga-Cirene na an ngaran Simon. Ini siya ginpirit ninda na magpas-an san krus ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pag-abot ninda sa lugar na ginatawag Golgota na an gusto sabihon lugar san kabunguan, ");
INSERT INTO msb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ginpainom ninda si Jesus sin bino na hinaluan sin apdo pero pakatimtimi wara niya pag-inuma. ");
INSERT INTO msb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Didto ginpako siya ninda sa krus kag ini ginpatindog. Tapos ginbarahin man ninda an iya mga sul-ot. ");
INSERT INTO msb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","38","Sa may uluhan naman niya may nakasurat na amo an akusasyon kontra sa iya, “AMO INI SI JESUS. SIYA AN HADI SAN MGA JUDIO.” Sa magluyo niya may duha na makawat na ginpako man sa mga krus. Tapos an mga suldados nag-iringkod didto kag nagbantay sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Niyan gintuya-tuya man siya san mga nagaaragi na ginatangu-tango an inda ulo na ");
INSERT INTO msb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nagasarabi, “Ikaw gali na magruba san templo kag mapatindog man lang sani sa sulod san tulo ka adlaw, isalbar mo an imo sadiri! Kun matuod na anak ka man gayod san Dios maglusad ka dida sa krus.” ");
INSERT INTO msb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ginatuya-tuya man siya san mga namumuno san kapadian kaupod san mga paratukdo san Kasuguan kag san mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nagsabi sinda, “Nasalbar niya an iba pero dili niya masalbar an iya sadiri. Kun siya man gayod an Hadi san Israel, dapat siya maglusad yana sa krus kay magatuod kita sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nagasarig siya sa Dios. Kaya magpasalbar siya sa iya kun namumut-an man gayod siya sani kay nagaparasabi man siya, ‘Anak ako san Dios.’,” ");
INSERT INTO msb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bisan man ngani an mga makawat na ginpako kadungan niya nagtuya-tuya man sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mga alas dose an udto san magdulom an bilog na nasyon hasta na mga alas tres an hapon. ");
INSERT INTO msb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pag-alas tres naman sumiyak si Jesus, “Eloi, Eloi, lama sabachtani?” na an gusto sabihon, “Dios ko, Dios ko, nano kay ginpabayaan mo ako?” ");
INSERT INTO msb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Niyan may mga nagatirindog didto na pakabati sani nagsabi, “Ginatawag niya si Elias.” ");
INSERT INTO msb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","May usad naman sa inda na nagdali-dali dayon pagkuhaʼn ispungha na iya ginbasa san suka, binutang sa punta san bagakay tapos gin-itsa niya ini kan Jesus agod ipasupsop sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero may nagsaraway na iba sa iya, “Hulat anay kay kitaon ta kun mag-abot man gayod si Elias agod ilibre siya sa krus.” ");
INSERT INTO msb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero nagsiyak gihapon didi si Jesus sin makusog kag sana mismo gin-intriga niya an iya espirito sa Dios. ");
INSERT INTO msb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sadto man nagisi sa tunga an kurtina san templo tuna sa ibabaw paubos. Naglinog kag napihak an kabatuhan. ");
INSERT INTO msb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naabrihan an mga rulubngan kag damoʼn nagkamaratay na mga banal an nagkaburuhay gihapon. ");
INSERT INTO msb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nagruluwas man sinda sa rulubngan. San pagkabuhay gihapon ni Jesus nagsulod sinda sa banal na lungsod kun diin nagpakirita sinda sa damoʼn katawuhan. ");
INSERT INTO msb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Paglinog kag pakakita san tanan na pangyayari, nagkaharadlok an namumuno san mga suldados kag san mga kaurupod niya na adto didto nagabantay kan Jesus. Tapos nakasabi, “Matuod man gayod na ini na tawo anak san Dios!” ");
INSERT INTO msb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","May damo man didto na kababayihan na nagamarasid sa may huruharayo. Ini sinda an nagsurunod kan Jesus kasadto hali pa sa Galilea kay nagaasikaso sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","An iba sa inda sinda Maria Magdalena, Maria na iloy ni Santiago kag Jose kag an iloy san mga anak na lalaki ni Zebedeo. ");
INSERT INTO msb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Antes magtunod an adlaw sadto may nag-abot na mayaman na taga-Arimatea. Si Jose an iya ngaran kag nagin disipulos man siya ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nagpakadto siya kan Pilato agod ayuon an lawas ni Jesus. Nagsugo man si Pilato na ihatag ini sa iya. ");
INSERT INTO msb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kaya kinuha ni Jose an lawas kag pinutos ini sa bag-o na tela na lino. ");
INSERT INTO msb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tapos ginlubong sa sadiri niya na rulubngan na bag-o pa lang niya ginpabuho sa bato. Ginpaligidan naman niya sin dako man na bato para sirahan an pwertahan sani tapos nag-uli na siya. ");
INSERT INTO msb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sinda Maria Magdalena naman kag san usad pa na Maria nagairingkod didto na nakaatubang sa rulubngan. ");
INSERT INTO msb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkaotro adlaw na amo an pakatapos san ginatawag na adlaw san Pagpreparar nakipagkita kan Pilato an mga namumuno san kapadian kag san mga Pariseo. ");
INSERT INTO msb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","An sabi ninda, “Sir, nadumduman namon na san buhay pa idtoʼn buwaon nagsabi siya, ‘Pag-ikatulo ka adlaw mabubuhay gihapon ako.’ ");
INSERT INTO msb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kaya magsugo ka na bantayan sin maayo an rulubngan hasta sa ikatulo ka adlaw kay basi magkaradto an iya mga disipulos kag kawaton an iya lawas. Tapos manumat sinda sa katawuhan, ‘Nabuhay siya hali sa pagkamatay.’ Kun sugad, ini na urhi na kabuwaan amo an pinakagrabe sa nauna na buwa.” ");
INSERT INTO msb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ginsabat man sinda ni Pilato, “Pag-upod kamo sin mga gwardya, tapos kumadto kamo kag bantayi gayod niyo sin maayo an rulubngan sa abot san makakaya niyo.” ");
INSERT INTO msb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kaya, nagkaradto sinda kag ginpasiguruhan nindaʼn pangtahob na bato an rulubngan paagi sa pagbutang sin selyos, tapos may mga ginbilin na gwardya para magbantay. ");
INSERT INTO msb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Myintras maaga pa san primero na adlaw san semana pakalipas san Adlaw San Pagpahuway, si Maria Magdalena kag san iba pa na Maria nagpakadto sa rulubngan agod makita. ");
INSERT INTO msb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sadto mismo naglinog sin makusog kay may naglusad hali sa langit na anghel san Ginoo agod makadto sa rulubngan. Kaya nagpakadto man siya didto kag pinaligid an bato hali sa pwertahan tapos gin-ingkudan ina. ");
INSERT INTO msb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","An kapawa san iya bayhon bagaʼn kilat kag an iya bado maputi-puti gayod pareho san gapas. ");
INSERT INTO msb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dahilan sani nagkurudog an mga bantay sa kahadlok sa iya kag nagkaturumba na bagaʼn mga patay. ");
INSERT INTO msb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tapos nagsurmaton an anghel sa mga babayi, “Dili kamo dapat mahadlok kay aram ko na an ginahanap niyo si Jesus na ginpako sa krus. ");
INSERT INTO msb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wara na siya didi kay nabuhay gihapon siya pareho san ginsabi niya. Kadi kag kitaa ngani an ginlubngan sa iya. ");
INSERT INTO msb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tapos kumadto dayon kamo kag sumatan an iya mga disipulos na nabuhay siya gihapon kag mauuna sa iyo sa Galilea. Didto siya niyo makikita. Tandai gayod an ginsabi ko sa iyo.” ");
INSERT INTO msb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nagharali man dayon an mga babayi sa ginlubngan na may kahadlok pero may dako man na kalipay. Tapos nagdali-dali sinda pakadto sa iya mga disipulos agod sumatan san gintugon sa inda. ");
INSERT INTO msb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Paglakat ninda bigla sinda sinugat ni Jesus kag kinumusta. Nagturulos man an mga babayi kag nagsarakom sa iya tiil para magsamba sa iya. ");
INSERT INTO msb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Didi man sinda sinabihan ni Jesus, “Ayaw kamo kahadlok! Kadto kag sabihi niyo an akon mga kamaranghod na lalaki na magpakadto sinda sa Galilea kay makikita ninda ako didto.” ");
INSERT INTO msb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Sadto man na nagaralakat an mga babayi, may mga bantay na nagpakaradto sa syudad agod isumat sa mga namumuno san kapadian an tanan na nangyari. ");
INSERT INTO msb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kaya nagtiripon naman sinda kaupod san mga namumuno san mga Judio. Pakatapos ninda pag-iristoryahan, hinatagan sin dako na kantidad an mga suldados ");
INSERT INTO msb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na may ginapahimo, “Amo ini an dapat niyo isabi, ‘Pagkagab-i myintras tururog kami, nagkaradi an iya mga disipulos kag kinawat an iya lawas.’ ");
INSERT INTO msb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kun maaraman man ini san gobernador kami an bahala magsabat sa iya. Kaya wara na kamoʼn handal.” ");
INSERT INTO msb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Binaton naman san mga gwardya an kwarta kag gintuman an gintugon sa inda. Hasta man ngani yana amo na ini an ginapalukop na istorya san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","An onse na disipulos naman nagpakadto sa Galilea didto sa bukid na gintugon sa inda ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pakakita ninda didto sa iya, ginsamba siya bisan pa ngani may iba sa inda na may pagduda. ");
INSERT INTO msb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gintulos sinda ni Jesus kag sinabihan, “Ako an ginhatagan san tanan na gahom san langit kag san duta. ");
INSERT INTO msb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaya pagralakat niyo, tukduan an mga katawuhan sa tanan na mga nasyon na magin mga disipulos ko. Bunyagan sinda sa ngaran san Ama, san Anak kag san Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tapos tukdui niyo sinda na magtuman san tanan na ginsugo ko sa iyo. Tandai man ini: pirme ako kaupod niyo hasta sa katapusan san kinab-an.”");
INSERT INTO msb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Amo ini an pagtuna san Maayo Na Barita manunungod kan Jesu-Cristo na Anak Na Lalaki san Dios. ");
INSERT INTO msb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","An propeta na si Isaias nakasurat manungod sa ginsabi san Dios sa Anak, “Kitaa, may susuguon ako pakada sa kinab-an na mauuna sa imo. Magapreparar siya san imo aagihan.” ");
INSERT INTO msb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Siya an magasiyak sa disyerto, ‘Preparara an agihan sa pag-abot san Ginoo. Tadunga an iya mga pagaagihan.’,” ");
INSERT INTO msb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Niyan natuman ini san nakita si Juan sa disyerto. Didto siya nagapangtukdo sa mga katawuhan na nagkadto sa iya na kinahanglan ninda magbasol kag magbaya sa inda pagkasala, tapos, magpabunyag para sa kapatawadan sani. ");
INSERT INTO msb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","An nagkaradto sa iya amo an haros tanan na mga taga-Judea kag mga tagasyudad san Jerusalem, kag didto sa suba san Jordan. Ginbunyagan niya sinda san nag-ako sinda san inda kasal-an. ");
INSERT INTO msb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ini si Juan nakasul-ot sin bado na himo sa barahibo san hayop na ginatawag na kamelyo. Ginpahaan niya sin anit kag an iya lang pagkaon mga duron kag dugos. ");
INSERT INTO msb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Amo ini an ginasabi niya, “May maabot na mas makagagahom pa ki sa akon, kaya dili ngani ako angay bisan maghubad san sintas san iya mga sandalyas. ");
INSERT INTO msb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ako an nagapambunyag sa iyo paagi sa tubig pero siya amo an magabunyag sa iyo paagi sa Espirito Santo.” ");
INSERT INTO msb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sani naman na panahon si Jesus hali sa Nazaret, usad na lugar san Galilea, kag didto man sa suba san Jordan siya ginbunyagan ni Juan. ");
INSERT INTO msb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pakahaw-as lang ni Jesus sa tubig nakita dayon an pagbuka san langit kag an Espirito Santo na nagapaitsura bagaʼn salampati nagalusad pakadto sa iya. ");
INSERT INTO msb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pakatapos may boses na nabati hali sa langit, “Ikaw an akon palangga na Anak na ginakalipay ko gayod.” ");
INSERT INTO msb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tapos, ginpakadto dayon siya san Espirito sa disyerto. ");
INSERT INTO msb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kwarenta na adlaw siya didto na ginatintaran ni Satanas. Mga kaupod lang niya an mga hayop didto kag an mga anghel nagaataman sa iya. ");
INSERT INTO msb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Niyan, pakadakop kan Juan nagkadto si Jesus sa Galilea kag nagpahayag san Maayo Na Barita san Dios. ");
INSERT INTO msb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Amo ini an ginasabi niya, “Adi na an panahon! Haros magtuna na an paghadi san Dios kaya ngani magbasol na kamo kag magbaya sa iyo pagkasala, tapos magtuod sa Maayo Na Barita!” ");
INSERT INTO msb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","San nagaagi si Jesus sa higad san danaw san Galilea, nakita niya an duha na magmanghod na amo sinda Simon kag san manghod sani na si Andres. Mga parapangisda sinda kaya adto didto sinda sa lawod nagapanglambat. ");
INSERT INTO msb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nagtawag siya sa inda kag nagsabi, “Mag-upod kamo sa akon kay tutukduan ta kamo na magin mga parapanglambat sin mga tawo.” ");
INSERT INTO msb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ginbayaan man dayon ninda an mga lambat kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pag-uruunhan ninda nakita man ni Jesus an magmanghod na mga anak ni Zebedeo na amo sinda Santiago kag Juan. Adto man sinda sa inda sakayan na nagatungkap san inda mga lambat. ");
INSERT INTO msb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tapos gintawag dayon niya sinda. Kaya ginbayaan ninda an inda ama na si Zebedeo sa sarakyan kaupod san mga kabulig kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa inda paglakat nakaabot sinda sa Capernaum. Pagka-Adlaw San Pagpahuway nagsulod dayon si Jesus sa sinagoga kag nagtuna pagtukdo sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nagkangarawa sinda sa iya katukduan kay nagatukdo siya bilang tawo na may poder. Dili ini pareho san mga paratukdo san inda Kasuguan. ");
INSERT INTO msb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sani man mismo sa inda sinagoga may nagsiyak na lalaki na ginsudlan sin maraot na espirito, ");
INSERT INTO msb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus na taga-Nazaret, nano an pakilabot mo sa amon? Nano, nagkadi ka agod siraon kami? Aram ko kun sin-o ka. Ikaw an Banal na hali sa Dios.” ");
INSERT INTO msb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero gin-uritan siya ni Jesus, “Puyo dida! Lumuwas ka sa iya!” ");
INSERT INTO msb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tapos an tawo ginpakudog gayod san maraot na espirito kag pagsiyak sin makusog an espirito lumuwas sa iya. ");
INSERT INTO msb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaya nangarat gayod sinda tanan kag nagapahurunga-hunga, “Nano ini? Bag-o na katukduan? May poder na ginasugo niya an mga maraot na espirito kag nagatuman naman sinda!” ");
INSERT INTO msb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kaya nadali lang an pakalukop san barita manungod kan Jesus sa tanan na lugar san Galilea. ");
INSERT INTO msb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Paghali ninda Jesus sa sinagoga nagsulod dayon sa balay ninda Simon kag Andres kaupod sinda Santiago kag Juan. ");
INSERT INTO msb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Didto nakahigda na may kalintura an ugangan na babayi ni Simon, kaya ginsabihan dayon ninda si Jesus san kamutangan sani. ");
INSERT INTO msb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kinadto naman ni Jesus an masakit, ginkaptan sa kamot, pinatindog kag hinaw-asan dayon ini san kalintura. Tapos nagtuna siya pag-asikaso sa inda. ");
INSERT INTO msb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagtunod san adlaw gindara sa iya an tanan na mga may sakit kag amo man idtoʼn ginsudlan san mga demonyo. ");
INSERT INTO msb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","An tanan gayod na tawo sa lungsod nagtiripon sa may pwertahan san balay. ");
INSERT INTO msb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Damu-damo siyaʼn ginpaayo na mga masakiton na may manlain-lain na ginabatyag. Pinahali man niya an damo na demonyo sa mga nagkasurudlan sani kag wara pagtuguti na makasurmaton pa kay kilala na ninda kun sin-o siya. ");
INSERT INTO msb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Madulum-dulom pa sa aga, nagbangon na siya, nagluwas sa balay kag nagkadto sa mamingaw na lugar agod nagpangadyi. ");
INSERT INTO msb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tapos, nagparahanap sa iya si Simon kag san iya iba pa na kaurupod. ");
INSERT INTO msb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","San makit-an ninda siya sinabihan, “An tanan nagaparahanap sa imo.” ");
INSERT INTO msb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nagsabat siya, “Hamos kita sa masunod na mga lungsod agod magpahayag man didto kay amo ini an dahilan san pagpakadi ko.” ");
INSERT INTO msb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ginpanglibot niya an bilog na Galilea na nagapangtukdo sa inda mga sinagoga kag nagapaluwas san mga demonyo sa tawo. ");
INSERT INTO msb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","San adto pa si Jesus didto may leprosohon na nagluhod sa may tiilan niya kag nakimaluoy, “Sir, kun gustuhon mo mapaayo mo ako.” ");
INSERT INTO msb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sa dako na kaluoy gin-unat ni Jesus an iya kamot kag gindapatan an leprosohon na nagasabi, “Oo, gusto ko. Mag-ayo ka!” ");
INSERT INTO msb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nawara dayon an leproso sani kag malinis na siya. ");
INSERT INTO msb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Tapos, gintugon gayod siya ni Jesus, “Ayaw gayod pagpanumat bisan kanin-o kundi kumadto ka kag magpakita sa padi. Tapos, maghalad ka para sa pag-ayo mo susog sa Kasuguan ni Moises bilang pagpamatuod sa mga tawo na nag-ayo ka na.” Tapos, ginpauli siya dayon. ");
INSERT INTO msb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero paglakat niya ginpamarita lugod sa tanan na lugar an nangyari sa iya. Kun kaya ngani si Jesus dili na basta makakadto sa mga lungsod kundi didto na lang sa mga waraʼn tawo na lugar. Bisan sugad sani damu-damo lang gihapon na mga tawo an nagakaradto sa iya. ");
INSERT INTO msb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Niyan pakaligad san pira ka adlaw nagbalik si Jesus sa Capernaum. Nakalukop dayon sa tanan didto na nag-uli na siya. ");
INSERT INTO msb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kaya ngani kay damu-damo naman na mga tawo an nagtiripon sa iya, haros wara sindaʼn lugar na makatindog bisan sa luwas san pwertahan lang. Myintras ginapahayag niya an Maayo Na Barita sa inda, ");
INSERT INTO msb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","may paralitiko na nag-abot na ginabayawan pakadto sa iya san upat na tawo. ");
INSERT INTO msb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tungod san kadamuan na tawo dili na sinda makahalapit kan Jesus. Kun kaya nagsaraka sinda sa atop kag didi gintangkasan an atop sa may tungod ni Jesus. Tapos gintunton ninda an nahihigdaan san paralitiko. ");
INSERT INTO msb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","San mapanginano ni Jesus an inda ginhimo dahilan san pagtuod sa iya, nagsabi siya sa paralitiko, “Anak, napatawad na an imo mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sadto na kaurason may mga paratukdo san Kasuguan na nagairingkod patalibod na nagairisip, ");
INSERT INTO msb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nano kay nakasurmaton ini na tawo sin pareho sadto? Usad ini na pagbasang-basang sa Dios! Waraʼn makapatawad san kasal-an kundi an Dios lang gayod!” ");
INSERT INTO msb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Namalisyahan dayon ni Jesus ini na inda ginapanghuna-huna kaya ginhunga niya sinda, “Nano kay sugad sana an pag-isip niyo? ");
INSERT INTO msb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hain sani an mas maayo sabihon sa paralitiko na, ‘An imo mga sala napatawad na,’ o ‘Tindog, bitbita an imo duyan kag lakat’? ");
INSERT INTO msb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ugaling pagapamatuudan ko sa iyo agod maaraman niyo na ako na Anak San Tawo may poder sa pagpatawad san mga kasal-an didi sa kinab-an.” Tapos sinabihan niya an paralitiko, ");
INSERT INTO msb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Adi an akon sugo sa imo: bangon kag bitbita an imo higdaan, tapos umuli ka na.” ");
INSERT INTO msb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tapos nagtindog an paralitiko, binitbit dayon an iya higdaan kag naghali myintras nagamiriron sinda. Kaya nagngaralas sinda tanan kag gin-umaw an Dios na nagasabi, “Wara pa gayod kami nakakita sin sugad sani!” ");
INSERT INTO msb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Niyan, nagbalik gihapon si Jesus sa may higad san danaw. Tapos, gintiripunan naman siya san damu-damo na mga tawo kaya gintukduan niya sinda. ");
INSERT INTO msb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkatapos, myintras nagalakat siya, nakita niya an anak ni Alfeo na si Levi na parasukot san buwis na nagaingkod sa may kolektahan san buwis. Sinabihan siya ni Jesus, “Mag-upod ka sa akon.” Kaya, tumindog naman ini kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","San nagakaon sinda Jesus kag san iya mga disipulos sa balay ni Levi damo na parasukot san buwis kag makasasala an kadurungan ninda Jesus kay damo sinda na nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kaya san nakita san mga Pariseo na paratukdo san Kasuguan na nakikaon sinda kaupod ni Jesus, ginhunga ninda an iya mga disipulos, “Nano kay nakikaon siya kaupod san mga parasukot san buwis kag iba na mga makasasala?” ");
INSERT INTO msb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","San mabatian ini ni Jesus ginsabat sinda, “Dili nagakinahanglan sin duktor an waraʼn sakit kundi idtoʼn mga masakiton. Nagkadi ako dili sa pag-agda sa mga matanos kundi sa mga parakasala.” ");
INSERT INTO msb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Usad sin adlaw myintras nagaayuno an mga disipulos ni Juan na Parabunyag kag san sa mga Pariseo, may mga nag-arabot na naghunga kan Jesus, “Nagaayuno na ngani an mga disipulos ni Juan kag san sa mga Pariseo. Nano kay dili nagaayuno an imo mga disipulos?” ");
INSERT INTO msb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ginsabat naman sinda ni Jesus paagi sa istorya, “Nano, pwede kaayuno an mga abay sa kasal myintras kaupod pa ninda an kinasal? Dili gayod sinda makaayuno myintras an kinasal kaupod pa ninda. ");
INSERT INTO msb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero maabot an adlaw na pagakuhaon siya sa inda kag amo pa lang sinda makaayuno tungod san kamunduan.” ");
INSERT INTO msb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tapos gin-istoryahan pa niya sinda para mapahayag na an iya bag-o na katukduan dili makabiyo sa mga daan. “Waraʼn matangkop sin bag-o na tela sa daan na bado, kay kun amo ini an himuon, an gintangkop na bag-o makuro kag mas lalo na madako an gisi. ");
INSERT INTO msb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sugad man, waraʼn masulod sin bag-o na bino sa daan na anit na surudlan kay kun sugad maputok an anit na surudlan kag an bino mawawasak. Kaya an bino masasayang kag masisira an surudlan. Kun kaya an bag-o na bino dapat lugod sa bag-o na anit na surudlan.” ");
INSERT INTO msb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Usad na Adlaw San Pagpahuway san sinda Jesus nagaaragi sa katriguhan, nagtuna an iya mga disipulos magpamudo sin mga binhi. ");
INSERT INTO msb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","San makita sinda san mga Pariseo naghunga naman ini kan Jesus, “Kitaa! Nano kay ginahimo ninda an ginabawal kun Adlaw San Pagpahuway?” ");
INSERT INTO msb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nagsabat naman siya, “Nano, wara pa kamo kabasa kun nano an ginhimo ni David san ginutom siya kag sadtoʼn mga kaurupod niya kay wara sindaʼn pagkaon? ");
INSERT INTO msb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","San si Abiatar pa an pinakapuno san kapadian nagsulod si David sa templo san Dios kag kinuha an mga tinapay na ginhalad sa Dios na dili ngani dapat kaunon san iba pwera lang san mga padi. Ginbahinan niya an iya mga kaurupod tapos kinaraon ninda tanan.” ");
INSERT INTO msb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tapos ginsabihan niya sinda, “An Adlaw San Pagpahuway hinimo para sa tawo, dili an tawo para sa Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaya ako na Anak San Tawo amo an Ginoo na makabuot sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sa iba na adlaw nagsulod gihapon si Jesus sa sinagoga kag may lalaki didto na kimay. ");
INSERT INTO msb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","May mga nagamarasid man didto sa iya kun magabulong siya san kimay sa Adlaw San Pagpahuway agod may ikaakusar sinda sa iya. ");
INSERT INTO msb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aram niya an inda paghuna kaya tinawag an kimay, “Kadi anay.” ");
INSERT INTO msb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tapos naghunga siya sa mga nagamarasid, “Sabata ako, nano, pwede na himuon an kaayuhan kag salbaron an tawo sa Adlaw San Pagpahuway? O mas maayo an paghimo sin maraot kag pagpatay?” Pero wara sinda nagsarabat. ");
INSERT INTO msb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kaya nagsud-ong siya patalibod na may kaurit pero namumundo man gayod tungod san kasutilan sani na mga tawo na habo magtuod sa iya. Pakatapos ginsabihan niya an kimay, “Iunat an imo kamot.” Gin-unat man sani kag an iya pagkakimay nag-ayo na. ");
INSERT INTO msb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dahilan sani nagruluwas an mga Pariseo kag nagtuna mag-istoryahan sa mga sakop ni Herodes kun pan-o siya ninda maipapatay. ");
INSERT INTO msb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Si Jesus kaupod san iya mga disipulos nagkadto sa higad san danaw kag damo na mga taga-Galilea an nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","May nag-tiripon man sa iya na damu-damo pa na mga taga-Judea, mga taga-Jerusalem, mga taga-Idumea, kag tagadidto pa sa unhan san Jordan kag sa iba pa na lugar san Tiro kag Sidon dahilan na nabati ninda an damo na mga maayo na nahimo niya. ");
INSERT INTO msb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaya sinugo ni Jesus an iya mga disipulos na prepararan siya sin baruto na masakyan agod dili siya masu-suan san katawuhan. ");
INSERT INTO msb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Problema ini kay tungod na damo siya sin nabulong kaya tanan na mga masakiton an nakidis-ukan agod makadutdot lang sa iya. ");
INSERT INTO msb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niyan san makita si Jesus saniʼn mga tawo na ginsurudlan san mga maraot na espirito, nagharapa naman sinda kag nagsiriyak ina na mga espirito, “Ikaw an Anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ginmandahan gayod niya an mga maraot na espirito na dili igsabi kun sin-o siya. ");
INSERT INTO msb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pakatapos nagsagka si Jesus sa bukid, tapos tinawag idtoʼn mga nauyunan niya kag nagtulos naman sinda sa iya. ");
INSERT INTO msb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dose sinda na pinili niya kag gintawag sindaʼn apostoles. Tapos ginsabihan, “Kamo magigin kaurupod ko kag susuguon ko kamo na magpahayag san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kamo man pagahatagan ko sin poder na makapahali san mga demonyo.” ");
INSERT INTO msb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","An napili niya amo ini: si Simon na ginpangaranan niyaʼn Pedro, ");
INSERT INTO msb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","an mga anak ni Zebedeo na magmanghod na sinda Santiago kag Juan na ginpangaranan niya sin Boanerges na an gusto sabihon, mga Anak san Dalugdog. ");
INSERT INTO msb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tapos si Andres naman, Felipe, Bartolome, Mateo, Tomas, si Santiago na anak ni Alfeo, Tadeo, si Simon na panatiko, ");
INSERT INTO msb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kag si Judas Iscariote na amo an magatraydor sa iya. ");
INSERT INTO msb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pakatapos nag-uli si Jesus sa iya ginadayunan. Damu-damo gihapon na mga tawo an nagtiriripon sa iya didto na dili na ngani sinda Jesus makakaon. ");
INSERT INTO msb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","San mabaritaan san iya pamilya ini na pangyari, kinadto siya para atamanon kay may nagsabi na siya nabubuang. ");
INSERT INTO msb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero an mga paratukdo naman san Kasuguan na naghali sa Jerusalem nagsabi, “Ada sa iya si Beelzebul kaya paagi lang sani na namumuno san mga demonyo an pagpaluwas niya san mga demonyo.” ");
INSERT INTO msb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaya tinawag niya sinda kag ginpahayagan paagi sa mga istorya. “Pan-o si Satanas makapahali kan Satanas,” an hunga niya. ");
INSERT INTO msb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Kun may kahadian na may araraway sa inda mismo, dili ini madudugay. ");
INSERT INTO msb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kun may panimalay man na may araraway sa inda mismo, dili man ini madudugay. ");
INSERT INTO msb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kun si Satanas ginakontra san iya mga sakop kag naburulag sinda, dili siya magadugay. Amo na ini an katapusan sani. ");
INSERT INTO msb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","O kun ipamutang ta pa, waraʼn masulod sa balay san tawo na maisog agod kuhaon an mga butang sani kun dili anay gapuson ini. Tapos amo na niya makawatan an balay sani.” ");
INSERT INTO msb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nagpadayon si Jesus, “Tandai an sasabihon ko! An tanan na kasal-an san katawuhan mapapatawad hasta an pagpakaraot sa tawo o bisan man sa Dios, ");
INSERT INTO msb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero an magpakaraot sa Espirito Santo dili gayod mapapatawad hasta na lang kundi kakastiguhon siya sa impyerno hasta na lang.” ");
INSERT INTO msb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ini an ginsabi niya kay nagsarabi sinda na siya may maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niyan, nag-abot an iya iloy kag mga kamaranghod na lalaki. Nagahurulat sinda sa luwas kag ginpatabian siya. ");
INSERT INTO msb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Damu-damo na mga tawo an nagairingkod patalibod ni Jesus san siya ginsabihan, “Kitaa, ada sa luwas an imo iloy kag mga kamaranghod na lalaki na ginapatabian ka.” ");
INSERT INTO msb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nagsabat siya, “Sin-o an akon iloy? Sarasin-o an akon mga kamaranghod na lalaki?” ");
INSERT INTO msb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pakasud-ong niya sa nagairingkod patalibod nagsabi siya, “Adi an akon iloy kag mga kamaranghod! ");
INSERT INTO msb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","An tanan na nagatuman san pagbuot san Dios amo an akon iloy kag akon mga kamaranghod na lalaki kag babayi.” ");
INSERT INTO msb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sa iba na adlaw nagtuna si Jesus pagtukdo didto sa may higad san danaw. Tungod kay damu-damo na mga tawo an nagtiripon patalibod niya, nagsakay siya sa sarakyan sa danaw kag didto nag-ingkod. An kadamuan naman adto sa may pangpang san danaw. ");
INSERT INTO msb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","May pasadi-sadi na gintukdo siya sa inda paagi sa mga istorya. Sa iya pagtukdo nagsabi siya, ");
INSERT INTO msb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Niyan pamati kamo! May parauma na nagpauma para magsabwag. ");
INSERT INTO msb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sa iya pagsabwag may mga binhi na nakatupa sa may dalan pero tinuruka ini san mga sapat na nag-arabot. ");
INSERT INTO msb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","May mga nakatupa man sa kabatuhan na didto dyutay la an duta. Nagturubo dayon ini kay hamabaw man lang an duta, ");
INSERT INTO msb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","pero pagragit san adlaw naluyos, tapos nag-uga idto kay wara makagamot sin maayo. ");
INSERT INTO msb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","May iba naman na mga binhi na nakatupa sa katunukan pero pagdaragko san katunukan nasiutan ini kaya wara kapamunga. ");
INSERT INTO msb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Niyan may iba man na mga binhi na nakatupa sa mataba na duta, nagturubo sin maayo, nagdaragko kag nagburunga. May mga nagbunga sin tigtraynta, may tigsisenta kag an iba pa ginatos kada binhi.” ");
INSERT INTO msb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pakatapos nagsabi pa siya, “Kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","San si Jesus na lang kag san dose na mga disipulos kaupod pa an mga pira ka tawo na nakatiripon sa iya, ginhunga ninda siya kun nano an gusto sabihon san iya gin-istorya. ");
INSERT INTO msb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nagsabat naman siya, “Kamo an gintugutan na maaraman an sikreto san kahadian san Dios pero sa mga iba an tanan sani ginatukdo paagi sa mga istorya, ");
INSERT INTO msb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agod bisan ‘sing-ano an kakita ninda dili gihapon ninda mapanginanuhan kag abir sing-ano an kapamati ninda dili gihapon sinda makasabot, kay kun nasasabutan ninda ini magabag-o na kuntani sinda kag an inda mga sala mapatawad.’,” ");
INSERT INTO msb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sinabihan sinda ni Jesus, “Nano, dili niyo ini nasasabutan na istorya? Kun sugad, pan-o pa niyo masasabutan an iba pa na sugad sani? Amo ini an gusto sabihon sana na istorya. ");
INSERT INTO msb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","An ginasabwag san parauma amo an mga surmaton san Dios. ");
INSERT INTO msb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pareho an nakatupa sa dalan na mga binhi amo idtoʼn mga nakabati sana na surmaton, tapos nagaabot dayon si Satanas kag nagahali san surmaton na inda nabati. ");
INSERT INTO msb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pareho man san mga binhi na nakatupa sa kabatuhan idtoʼn mga nakabati san surmaton, tapos nagatuod dayon kag nagakarilipay. ");
INSERT INTO msb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero kay wara ninda ini ipasabuot kaya dili ini nadudugay. Nagatubo anay an inda pagtuod sin kadali pero oras na may kalisdanan o kasakitan dahilan san pagsunod sa katukduan, nawawara dayon an inda pagtuod. ");
INSERT INTO msb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“May mga iba pa na pareho man san mga binhi na ginsabwag sa katunukan. Nakabati sinda san surmaton, ");
INSERT INTO msb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero an mga kahandalan san pagkabuhay, an kasadya san kayamanan kag san paghandom san damo na mga bagay amo an nagapalimot san surmaton kaya wara ini makapamunga. ");
INSERT INTO msb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pareho naman san mga binhi na nakatupa sa mataba na duta amo ini an mga nakapamati san surmaton kag nagasunod man sani bagaʼn mga tanom na nakapamunga sin tigtraynta, sin tigsisenta o sin ginatos kada binhi.” ");
INSERT INTO msb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nagsurmaton pa si Jesus, “Nano, ginasindihan an ilawan para tahuban sa bangkat o itago sa sirong san katri? Syimpre dili! Dapat ini ipaitaas agod mapawaan an tanan. ");
INSERT INTO msb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","May panahon man na ihahayag gayod an nano man na bagay na gintago kag an nano man na ginsikreto ipapaaram man. ");
INSERT INTO msb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","An sin-o man na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nagsabi pa si Jesus, “Isipa sin maayo an iyo ginapamatian. An sukulan na ginagamit niyo amo man an sukulan na gagamiton sa iyo kag papasobrahan pa ina. ");
INSERT INTO msb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaya, siya na igwa pagadagdagan pa pero sa iya na wara-wara gayod an nano man na dyutay na ada sa iya pagakuhaon pa.” ");
INSERT INTO msb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nagpadayon pa gayod si Jesus, “Pareho pa san nagasabwag san mga binhi sa iya uma an kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sa damo na mga adlaw kag gab-i, bisan magturog o magmata an parauma, an mga binhi nagaturok kag nagadaragko pero wara siyaʼn kaaraman kun pan-o ini nagatubo. ");
INSERT INTO msb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","An duta amo mismo an nagapaturok kag nagapabunga san mga tanom. Primero mauslot, masunod an uhay tapos an matimsog na pasi. ");
INSERT INTO msb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Paghinog san bunga insigida ginagarab kay amo na an tig-anihan.” ");
INSERT INTO msb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nagsurmaton pa si Jesus, “Sa nano naton ikapareho an kahadian san Dios? Nano daw na istorya an makapahayag sani? ");
INSERT INTO msb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pareho ini san pisog san mustasa na kun ginatanom amo an pinakadyutay sa mga pisog sa bilog na kinab-an. ");
INSERT INTO msb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero kun natanom na ini nagigin pinakadako san mga tinanom kag nagsasaranga sin daragko kaya nasasalagan kag nasisirungan san mga sapat.” ");
INSERT INTO msb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sa paggamit sin manlain-lain na istorya gintukdo ni Jesus an surmaton san Dios susog sa inda kakayahan na pagsabot. ");
INSERT INTO msb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kun sa kadamuan, an iya panukdo pirme paagi sa istorya pero kun siya kag san iya mga disipulos lang, ginapahayag niya an tanan. ");
INSERT INTO msb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagkagab-i sadto na adlaw gin-agda sinda ni Jesus, “Hamos kita patabok san danaw.” ");
INSERT INTO msb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kaya gin-upod ninda si Jesus sa inda dako na baruto kag nagpalawod. Igwa pa sin iba na mga sarakyan na nagsabay sa inda. ");
INSERT INTO msb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Taud-taod may umabot na subasko kag nasasabyahan san balod an inda sarakyan kaya haros malunod na ini. ");
INSERT INTO msb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero maanok an pakakaturog ni Jesus sa ulin na nakaulon pa. Pinukaw siya kag sinabihan ninda, “Maestro, wara ka baʼn labot kun malunod kita?” ");
INSERT INTO msb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nagbangon siya kag ginsaway an hangin, “Udong!” Tapos ginsugo naman niya an mga balod, “Ayaw pagparahiwag!” Nag-udong dayon an hangin kaya malinaw na gayod. ");
INSERT INTO msb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tapos sinabihan niya sinda, “Nano kay nagkaharadlok kamo? Nano, wara pa gayod kamo sin pagsarig sa akon?” ");
INSERT INTO msb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wara sindaʼn ikasabat kay nagkangarawa gayod sinda pero nagpahurunga-hunga, “Nano daw ini siya kay an hangin kag mga balod ngani nagasunod sa iya!” ");
INSERT INTO msb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nag-abot sinda Jesus sa lugar san mga Geraseno sa tabok san danaw. ");
INSERT INTO msb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pakalusad lang ni Jesus sa sarakyan may nakasugat siya na lalaki hali sa rulubngan na mga kweba. Ini na lalaki nasudlan sin maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kaya adto na siya nagaistar sa rulubngan na mga kweba kag wara na gayod sin makagapos sa iya bisan kadena. ");
INSERT INTO msb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pirme na ini siya ginagapos kag ginakadenahan ugaling dili nadudugay kay iya ginabugto an kadena kag ginarangka an pusas sa tiil kag wara na gayod sin nakadaog sa iya. ");
INSERT INTO msb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sa tanan na adlaw kag gab-i pirme siya nagaparasiyak sa may rulubngan na mga kweba kag sa mga kabukidan. Ginaparagamit man niya an mga bato agod samadan an iya lawas. ");
INSERT INTO msb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pakalantaw san lalaki kan Jesus sa harayo, nagdalagan ini paapiki kag nagluhod sa may tiilan niya. ");
INSERT INTO msb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Tapos nagmanda si Jesus, “Maraot na espirito, lumuwas ka sa lawas sani na tawo.” Didi naman an espirito paagi sani na lalaki nagsiyak sin makusog, “Jesus, anak san Pinakalabaw na Dios, nano an pakilabot mo sa akon? Magsumpa ka sa ngaran san Dios na dili mo ako pagpasakitan.” ");
INSERT INTO msb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pakatapos hinunga siya ni Jesus, “Sin-o ka?” Nagsabat siya, “An ngaran ko Damo kay damu-damo kami.” ");
INSERT INTO msb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nakimaluoy gayod siya na dili pagpalayason sadto na lugar an mga maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Niyan didto sa higad san bukid may damu-damo na mga baboy na nanginginaon, ");
INSERT INTO msb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kaya an mga maraot na espirito nakimaluoy kan Jesus, “Sugua na lang kami na makakadto sa mga baboy agod makasulod sa mga lawas sani.” ");
INSERT INTO msb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kaya tinugutan niya sinda. Nagruluwas naman sinda sa lawas san tawo kag nagsulod sa mga baboy. Tapos idto na maduha ka libo na mga baboy nagharabas palusad san pangpang, nagkahurulog sa danaw kag didto nagkarulumos. ");
INSERT INTO msb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","An mga parabantay naman san kababuyan nagdaralagan palungsod kag didto ginpamarita ini kag sa mga baryo sa patalibod. Kaya an mga tawo nagkaradto para makita kun nano man gayod an nangyari. ");
INSERT INTO msb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pag-abot ninda kan Jesus nakita ninda idtoʼn lalaki na dati ginsudlan san mga maraot na espirito. Adto na siya nagaingkod, nakaliwan na kag maayo na an kaisipan. Kaya an mga tawo nagkaharadlok. ");
INSERT INTO msb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Idto naman na mga nakakita ginpamarita sa inda an nangyari sadtoʼn ginsudlan san mga demonyo kag san sa mga baboy pa. ");
INSERT INTO msb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kaya nakimaluoy an mga tawo kan Jesus para humali sa inda lugar. ");
INSERT INTO msb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","San makasakay na sinda Jesus sa inda sarakyan, idtoʼn lalaki na ginluwasan san mga demonyo nakimaluoy sa iya na tugutan siya mag-upod. ");
INSERT INTO msb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wara magtugot si Jesus kundi sinabihan siya, “Umuli ka sa imo mga kahilungsod kag isumat sa inda an tanan na hinimo san Ginoo sa imo kag kun sing-ano an iya kaluoy sa imo.” ");
INSERT INTO msb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kaya lumakat an lalaki kag ginapamarita patalibod san Decapolis an tanan na hinimo sa iya ni Jesus. Didi nagkangarawa an tanan. ");
INSERT INTO msb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pag-abot gihapon ni Jesus sa luyo san danaw na nakasakay sa sarakyan, damu-damo naman na mga tawo an nagtiripon sa iya sa higad san danaw. ");
INSERT INTO msb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Taud-taod may nag-abot na nagapamuno san sinagoga na an ngaran Jairo. Pakakita ni Jairo kan Jesus lumuhod sa may tiilan na nakimaluoy, ");
INSERT INTO msb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Sir, tikamatayon na gayod an anak ko na daragita kaya pakikadto anay kag pakidapat lang san imo kamot sa iya agod mag-ayo kag mabuhay siya.” ");
INSERT INTO msb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kaya umupod si Jesus kan Jairo. Damu-damo man na mga tawo an nagasurunod kag nagasurusuan sa kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Niyan didto sa kadamuan may babayi man na grabe an sakit. Pirme siya ginadugo sa sulod san dose ka tuig. ");
INSERT INTO msb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nagtios gayod siya sa damu-damo na mga duktor na nagburulong. Kaya naubos na an iya kwarta sin kapabulong pero imbes na mag-ayo naggrabe pa lugod siya. ");
INSERT INTO msb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nabaritaan niya an pagapambulong ni Jesus kaya nakisu-suan man siya sa may likudan ni Jesus kag gindutdot an bado sani. ");
INSERT INTO msb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ginhimo niya ini kay inisip niya, “Kun madutdot ko lang bisan an iya ginasul-ot magaayo na ako.” ");
INSERT INTO msb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Didto mismo nabatyagan san babayi na nahalin an dugay na niya na problema kay naudong dayon an pagparadugo sa iya. ");
INSERT INTO msb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pakabatyag dayon ni Jesus na may gahom na lumuwas hali sa iya, lumingi sa mga tawo kag naghunga, “Sin-o an nagdutdot sa akon bado?” ");
INSERT INTO msb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nagsabat naman an iya mga disipulos, “Nakita mo gayod na damu-damo an nagadiris-ukan sa patalibod mo, kaya nano kay mahunga-hunga ka pa kun sin-o an nagdutdot sa imo bado?” ");
INSERT INTO msb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero nagsud-ong si Jesus sa patalibod na ginahanap pa kun sin-o gayod an naghimo sadto. ");
INSERT INTO msb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Palibhasa aram san babayi an nangyari, naghalapit siya na nahahadlok kag nagapangudog kan Jesus. Nagluhod ini sa tiilan niya kag ginsabi an tanan na kamatuudan. ");
INSERT INTO msb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sinabihan niya an babayi, “Tia, an imo pagtuod sa akon amo an nakaayo sa imo. Umuli ka sa kalinaw san isip kag mag-ayo ka sa imo pagtios.” ");
INSERT INTO msb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Myintras nagasurmaton pa si Jesus may nag-arabot hali sa balay ni Jairo kag nagsumat, “Sir, an imo anak patay na. Siguro, dili mo na kinahanglan na samukon pa an Maestro.” ");
INSERT INTO msb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wara lang pag-intyindiha ni Jesus ini na inda ginsumat kundi sinabihan an opisyal, “Ayaw kahadlok, kundi magtuod ka lang gayod sa akon.” ");
INSERT INTO msb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tapos wara si Jesus sin gintugutan na iba para mag-upod sa iya kundi si Jairo, sinda Pedro, Santiago kag san manghod sani na si Juan. ");
INSERT INTO msb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pag-abot ninda sa balay san opisyal nakita ni Jesus na nagakaribok an mga tawo. May nagatarangis kag may naganguruyngoy sin makusog. ");
INSERT INTO msb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagsulod niya sinabihan sinda, “Nano ini na kasamukan kag pagnguyngoy? Dili patay an bata kundi natuturog lang.” ");
INSERT INTO msb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pakabati sani gintarawhan lang siya ninda kaya pinaluwas sinda ni Jesus. Pakatapos inagda niya an ginikanan san bata hasta an tulo niya na disipulos kag sumulod sa kwarto na ginahigdaan san bata. ");
INSERT INTO msb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pag-abot didto kinaptan ni Jesus sa kamot an bata kag sinabihan, “Talita koum” na an gusto sabihon, “Nene, bumangon ka.” ");
INSERT INTO msb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bumangon dayon an bata kag lumakat patalibod san kwarto. Dose anyos an iya edad. Kaya nginarat gayod an tanan sani na nangyari. ");
INSERT INTO msb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pakatapos ginpadaanan sinda ni Jesus na dili gayod ini pag-ibarita bisan kanin-o man kag ginsugo sinda, “Hatagi siya sin makaon.” ");
INSERT INTO msb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Paghali didto si Jesus nag-uli sa iya sadiri na lungsod kaupod an iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pag-abot san Adlaw San Pagpahuway nagtuna siya pagtukdo sa sinagoga. An kadamuan sa inda na nagbarati nagkangarawa na nagasabi, “Diin siya nagkuha sani na iya ginapanurmaton? Nano na kadunungan ini na hinatag sa iya? Pan-o siya nakahimo sani na mga milagro? ");
INSERT INTO msb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dili ba ini an panday na anak ni Maria kag an iya mga kamaranghod pa sinda Santiago, Jose, Judas kag Simon? Dili ba tagaaton pa ngani an iya mga kamaranghod na babayi?” Kaya dili ninda siya gin-ako. ");
INSERT INTO msb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero ginsabihan sinda ni Jesus, “Bisan sin-o na propeta ginagalangan bisan diin pwera lang sa iya sadiri na lungsod, sa sadiri na mga kaigmanghudan kag panimalay.” ");
INSERT INTO msb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sani na kamutangan wara gayod si Jesus sin nahimuan na milagro didto pwera la ngani may mga pira na ginbulong siya paagi san pagdapat san iya kamot sa mga masakit. ");
INSERT INTO msb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaya nangawa siya kay wara gayod sindaʼn pagtuod sa iya. Bisan sugad sana an kamutangan naglibot si Jesus sa mga baryo na nagapangtukdo. ");
INSERT INTO msb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tapos pagtawag niya san iya dose na disipulos ginhatagan sin poder sa pagpahali san mga maraot na espirito sa mga tawo. Pakatapos sinugo sinda sin tigduha-duha agod makapahayag san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Amo ini an iya mga gintugon sa inda, “Dili kamo magdara sin nano man na bagay pwera lang san tungkod. Dili magbalon sin pagkaon, surudlan o kwarta sa iyo bulsa. ");
INSERT INTO msb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dili magdara sin liwanan pero pwede kamo makasandalyas.” ");
INSERT INTO msb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nagsabi pa siya sa inda, “Kun sin-o an magpadayon sa iyo, didto lang kamo mag-istar hasta na kamo maghali sana na lungsod. ");
INSERT INTO msb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ugaling kun may mga lugar na wara sin magpadayon o magpamati sa iyo, paghali niyo dida taphuda anay an alpog sa iyo tiil bilang padaan na may paghusgar na maabot sa inda.” ");
INSERT INTO msb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kaya nagralakat sinda kag magpahayag na an katawuhan dapat magbasol kag magbaya sa inda pagkasala. ");
INSERT INTO msb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Damo na mga demonyo an ginpaluwas ninda sa mga nasudlan na tawo kag ginlahidan ninda sin lana an mga masakiton kag nag-arayo. ");
INSERT INTO msb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Niyan nabaritaan san hadi na si Herodes an manunungod kan Jesus tungod na siya kilala na. May nagsabi na, “Siya si Juan na Parabunyag na nabuhay gihapon kaya dahilan sani ada na sa iya ini na mga kagamhanan.” ");
INSERT INTO msb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","An iba naman nagsabi, “Siya si Elias.” An iba pa gayod nagasabi, “Siya propeta pareho san kasadto.” ");
INSERT INTO msb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pakabati ni Herodes san tanan nagsabi, “Siya si Juan na ginpapugutan ko sin ulo kag yana nabuhay gihapon.” ");
INSERT INTO msb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Niyan ini si Herodes amo an nagpadakop kan Juan, nagpagapos kag nagpapriso sa iya kay ginsaway niya si Herodes, “Dili tugut sa Kasuguan na asawahon mo an asawa san imo manghod.” Nagasabi siya sani dahilan na gin-asawa ni Herodes si Herodias na asawa san iya kamanghod na si Felipe. ");
INSERT INTO msb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kaya daku-dako an paghumot ni Herodias kan Juan na gusto niya ini ipapatay. Pero dili niya nahimo ");
INSERT INTO msb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","dahilan na si Herodes nahahadlok kan Juan kay aram niya na matanos kag banal ini na tawo kaya ginpabantayan niyaʼn maayo. San pakabati ni Herodes kan Juan nalisang siya pero nalilipay man mamati. ");
INSERT INTO msb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Niyan pag-abot san komplianyo ni Herodes may oportunidad si Herodias na matuman an iya humot kay nagpaponsya si Herodes para sa iya mga opisyales, mga namumuno na suldados kag mga kilala na tawo san Galilea. ");
INSERT INTO msb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Didi sumulod an daraga na anak ni Herodias kag nagsayaw para sa inda. Ginpalipay gayod si Herodes kag san iya mga bisita. Kaya sinabihan niya an daraga, “Ayua kun nano man an gusto mo kay igahatag ko.” ");
INSERT INTO msb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nagsumpa pa ngani siya sa daragita, “Ihahatag ko sa imo an nano man na ayuon mo bisan an katunga san akon kahadian.” ");
INSERT INTO msb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tapos nagluwas an daraga kag naghunga sa iya iloy, “Mama, nano daw an aayuon ko?” Nagsabat an iloy, “An ulo ni Juan na Parabunyag.” ");
INSERT INTO msb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nagbalik dayon an daraga pakadto sa hadi kag nag-ayo, “Gusto ko na ihatag mo sa akon sugad sana dayon an ulo ni Juan na Parabunyag na nakabutang sa bandihado.” ");
INSERT INTO msb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pakabati sani san hadi namundo gayod siya pero wara nakabalibad san gin-ayo san daraga kay nakatuga siya sa iya kag makaaralo man siya sa mga bisita kun bawion niya an iya surmaton. ");
INSERT INTO msb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kaya may sinugo dayon siya na suldados na darhon sa iya an ulo ni Juan. Sinunod san suldados an sugo san hadi. Pinugutan niya si Juan sa prisuhan, ");
INSERT INTO msb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tapos dinara an ulo sani na nakabutang sa bandihado kag hinatag sa daraga. Hinatag naman dayon san daraga sa iya iloy. ");
INSERT INTO msb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","San mabaritaan ini san mga disipulos ni Juan kumadto sinda kag kinuha an iya lawas tapos linubong. ");
INSERT INTO msb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nagbalik an mga apostoles ni Jesus sa iya kag ginsumatan siya san tanan na inda nahimuan kag ginpangtukdo. ");
INSERT INTO msb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Damu-damo na mga tawo an nagaarabot agod makaistorya kan Jesus tapos nagaharalin kaya wara ngani sinda Jesus sin panahon bisan sa pagkaon. Tapos sinabihan ni Jesus an mga apostoles, “Kadi anay kamo. Hamos na pakadto na kita-kita lang sa mapuyo na lugar agod magpahuway.” ");
INSERT INTO msb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kaya nagsarakay sinda sa sarakyan agod magkadto sa mamingaw na lugar na sinda-sinda lang. ");
INSERT INTO msb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Damu-damo ugaling na mga tawo na nakita sinda sa inda pagsakay an nakakilala sa inda. Kaya nagdaralagan an mga tawo hali sa tanan na lungsod kag nauna sa inda pag-abot didto. ");
INSERT INTO msb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","San paglusad ni Jesus sa sarakyan, damu-damo na mga tawo an iya nakita kag nagbatyag siya sin kaluoy sa inda kay baga sinda an mga karnero na waraʼn nagaataman. Kaya nagtuna siya pagtukdo sa inda sin mga manlain-lain na mga bagay. ");
INSERT INTO msb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","San banda hapon na, nagharalapit sa iya an iya mga disipulos kag nagsabi, “Usad ini na mamingaw na lugar kag pasado na sa oras, ");
INSERT INTO msb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","kaya pahalia na an mga tawo agod makakadto sa mga kaumahan kag mga baryo patalibod para makabakal sin makaon.” ");
INSERT INTO msb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero nagsabat si Jesus, “Hatagi na lang niyo sindaʼn makaon.” Nagsabi naman an mga disipulos sa iya, “Nagakinahanglan ina sin sobra pa sa walo ka bulan na sweldo san usad na trabahador. Nano, magastos pa ba kami sin sugad sana sa tinapay para ipakaon sa inda?” ");
INSERT INTO msb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naghunga si Jesus, “Pira ka bilog na tinapay an ada sa iyo? Kadtua kag kitaa anay niyo.” San maaraman na ninda kun pira ka bilog ginsumatan siya, “Lima ka bilog na tinapay kag duha ka bilog na isda.” ");
INSERT INTO msb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tapos ginmandahan niya sinda na paingkudon an tanan na mga tawo paagi sa paggrupu-grupo sa may dinghot. ");
INSERT INTO msb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nag-iringkod naman an mga tawo sin grupu-grupo. May mga grupo na may ginatos kag may mga iba pa man tigsurusingkwenta kada grupo. ");
INSERT INTO msb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kinuha ni Jesus an lima ka bilog na tinapay kag duha na isda tapos humangad siya sa langit kag nagpasalamat sa Dios. Tapos gin-utud-utod niya an tinapay kag ginbarahin sa iya mga disipulos agod ipanghatag sa mga tawo. Pag-utud-utod man niya san duha kabilog na isda ginbarahin naman sa inda. ");
INSERT INTO msb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nagkaraon sinda tanan hasta na nagkaburusog. ");
INSERT INTO msb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pakatapos nakatipon pa an mga disipulos sin dose ka bangkat na puno sin mga utud-utod na tinapay kag isda. ");
INSERT INTO msb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lima ka libo na kalalakihan an nagkaraon. ");
INSERT INTO msb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pakatapos sani ginpasakay dayon ni Jesus sa sarakyan an iya mga disipulos kag ginpauna sa Betsaida sa tabok san danaw myintras ginapauli niya an mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pakapaulia niya sani nagsagka siya sa bukid agod magpangadyi. ");
INSERT INTO msb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pagkagab-i an sarakyan na ginasakyan san mga disipulos nasa lawod na pero nabilin si Jesus na amo lang sa bukid. ");
INSERT INTO msb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nalantawan niya na ginakapoy sin kabugsay an iya mga disipulos sa pagtabok tungod na sungsungon an hangin. Kaya san maalas kwatro na an kaagahon naghalapit sa inda si Jesus na nagalakat sa ibabaw san tubig. Kuntani lalabayan lang niya sinda, ");
INSERT INTO msb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ugaling kay nakita ninda tanan na nagalakat siya sugad sana nagsiriyak sinda, “Adaw, multo!” kay huna ninda na multo ina. ");
INSERT INTO msb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kaya nagkaharadlok sinda tanan. Pero ginsabihan man dayon sinda ni Jesus, “Ayaw kamo kahadlok! Ako baga ini! Pakusuga an iyo buot!” ");
INSERT INTO msb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pakasakay niya sa sarakyan naudong an hangin. Natagalpo sinda, ");
INSERT INTO msb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kay bisan ginhimo niya an milagro sa tinapay wara pa sindaʼn pagkakilala san iya poder kay kulang pa an inda pagtuod. ");
INSERT INTO msb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sa inda pagtalabok nakaabot sinda sa lugar san Genesaret kag didto sinda nagdungka. ");
INSERT INTO msb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagrulusad ninda nakilala dayon si Jesus san mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Idtoʼn nakakita nandaralagan sa mga may sakit sa tanan na lugar didto kag gindara ninda na nasa duyan an mga masakiton pakadto sa lugar na nabaritaan ninda na adto siya. ");
INSERT INTO msb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tapos kun hain siya mapakadto bisan sa mga lungsod, sa mga baryo, o sa umahan, ginabutang ninda an mga masakiton sa mga tyangihan. Nakimaluoy ini na mga masakiton na padutduton lang sinda bisan kun sa sidsid lang san iya bado, kag an tanan na nakadutdot sa iya bado nagkaarayo. ");
INSERT INTO msb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sadtoʼn panahon may nagtiripon patalibod ni Jesus na mga Pariseo kag san iba na mga paratukdo san Kasuguan na naghali sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Didto nagmangno sinda na an iba niya na mga disipulos nagakaraon na bagaʼn maati an kamot kay antes sinda magkaon wara mahugasi an mga kamot susog sa kaugalian san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Niyan an tanan na mga Judio kag lalo na an mga Pariseo antes magkaon nagahugas anay san kamot susog sa kaugalian san inda mga kalulululuhan. ");
INSERT INTO msb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amo man pag-abot ninda hali sa merkado nagahugas anay sa tama na paagi antes magkaon. Damo pa gayod sindaʼn ginasunod na mga kasadto na kaugalian pareho san paghugas san ginainuman, mga kuron, mga kaldero (kag mga higdaan). ");
INSERT INTO msb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kaya hinunga si Jesus sani na mga Pariseo kag mga paratukdo san Kasuguan, “Nano kay an imo mga disipulos dili nagasunod san kaugalian san mga kalulululuhi kundi nagakaraon na dili nagahugas san mga kamot sa tama na paagi?” ");
INSERT INTO msb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nagsabat si Jesus, “Tama si Isaias san nagsabi siya manungod sa iyo mga pakitaʼn-tawo lang sugad san nasurat, ‘Ini na mga tawo ginagalangan ako sa surmaton lang, pero habo an inda mga tagipusuon magsunod sa akon. ");
INSERT INTO msb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Waraʼn kapuslanan an inda pagsamba sa akon kay an ginatukdo ninda hali lang sa kaisipan san tawo, dili sa Dios.’ ");
INSERT INTO msb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ginpabayaan na ngani niyo an Kasuguan san Dios kag ginapalabi lugod an kaugalian san tawo.” ");
INSERT INTO msb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nagpadayon pa siya, “Mahusay gayod an iyo pagsikway san Kasuguan san Dios para lang masunod an iyo kaugalian! ");
INSERT INTO msb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Halimbawa, nagsabi si Moises, ‘Galangon mo an imo ama kag iloy,’ kag ‘An nagapakaraot sa iya ama kag iloy dapat gayod ipapatay.’ ");
INSERT INTO msb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero kamo naman nagasabi, ‘Kun may magsabi sa iya ama o iloy: Abir an nano man na adi sa akon na ikakabulig sa iyo, ");
INSERT INTO msb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ina an ginatawag ko Corban’ (na an gusto sabihon, halad ina sa Dios), kaya ginabawal na sa iya an paghimo sin nano pa man para sa iya ama kag iloy. ");
INSERT INTO msb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sani na paagi ginabalewara niyo an surmaton san Dios tungod san kaugalian na gintukdo sa iyo hasta sa iyo mga lahi. Damo pa kamoʼn ginapanghimo na pareho sani.” ");
INSERT INTO msb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ginpahalapit gihapon ni Jesus an mga tawo kag sinabihan, “Pamatii ako kag sabuta niyo tanan! ");
INSERT INTO msb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Waraʼn hali sa guwa san tawo na nakapaati pagsulod sani sa iya kundi an nagaluwas sa tawo an nakapaati sa iya. ");
INSERT INTO msb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","An sin-o man na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","San pagbayai niya sa katawuhan nagsulod siya sa balay. Tapos naghunga an mga disipulos manungod sa iya gin-istorya. ");
INSERT INTO msb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ginsabat niya sinda, “Nano, dili pa man kamo nakasarabot? Dili ba niyo aram na an nano man na hali sa guwa na nakasulod sa tawo dili makapaati sa iya, ");
INSERT INTO msb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tungod na dili ini nagsulod sa iya tagipusuon kundi sa iya tiyan tapos maluwas sa iya lawas?” (Kaya sani ginapatunayan ni Jesus na an tanan na mga pagkaon makakaon.) ");
INSERT INTO msb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nagpadayon pa siya, “An nano man na nagaluwas na hali sa tagipusuon san tawo amo an nakapaati sa iya. ");
INSERT INTO msb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay an ada sa tagipusuon san tawo nagahali an mga maraot na kaisipan, pagdurog sa dili asawa, pangawat, pagpatay, ");
INSERT INTO msb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","panambay, pagkapaslo sa kwarta, grabe na karautan, pagpanluko, maraot na pagkabuhay, pagkaawa, pagpakaraot sa kapwa, mapahitaason kag kabuangan. ");
INSERT INTO msb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ini tanan na mga karautan nagahali sa kabubut-on san tawo kag amo ini an nakapaati sa iya.” ");
INSERT INTO msb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Naghali si Jesus didto kag pumakadto sa Tiro kag Sidon. Sumulod siya didto sa usad na balay kay habo na may makaaram na adto siya pero wara siya katago. ");
INSERT INTO msb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Niyan may babayi didto na may daragita na nasudlan sin maraot na espirito. Pakabarita sani na babayi na adto si Jesus kumadto dayon siya kag lumuhod sa may tiilan ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Griego idtoʼn babayi pero nabuhay siya sa Fenicia na adto sa Siria. Nakimaluoy man siya kan Jesus na pahalion an maraot na espirito na nagsulod sa iya anak. ");
INSERT INTO msb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sinabihan naman niya an babayi, “An mga kabataan anay an pakaunon kay dili tama na kuhaon an pagkaon sa inda kag ibahog lugod sa kaiduan.” ");
INSERT INTO msb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero sinabat siya san babayi, “Tama, Ginoo, pero an mga ido sa sirong san lamesa nababahugan man ngani san nagakatarakdag na mga mumho san mga bata.” ");
INSERT INTO msb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tapos ginsabihan siya ni Jesus, “Tia, dahilan sani na pagsabi mo makauli ka na. An maraot na espirito naghali na sa imo bata.” ");
INSERT INTO msb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Umuli na an babayi kag inabtan niya na an bata nakahigda na sa katri kag wara na an maraot na espirito. ");
INSERT INTO msb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagbalik ni Jesus hali sa Tiro nag-agi siya sa Sidon pakadto sa Danaw san Galilea hasta sa mga lugar san Decapolis. ");
INSERT INTO msb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Didto may mga tawo na dinarhan siya sin apa na lalaki kag nakimaluoy sinda na dapatan lang ni Jesus san iya kamot an tawo agod mag-ayo ini. ");
INSERT INTO msb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Gin-agda ini ni Jesus na mag-upod sa iya kag binulag sa kadamuan. Tapos sinulod niya an iya mga tudlo sa mga talinga san tawo. Pakatapos nagluda kag gindutdot an dila sani. ");
INSERT INTO msb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pakahimo sani humangad si Jesus sa langit, nagginhawa sin halawig kag nagsabi, “Effata!” na an gusto sabihon “Mag-abri!” ");
INSERT INTO msb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Insigida nakabati an tawo, nakahiwag man an iya dila kag nakasurmaton sin klarado. ");
INSERT INTO msb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ginpadaanan ni Jesus an kadamuan na dili gayod magpanumat bisan kanin-o. Pero kun sing-ano an kapadaan niya mas lalo man lugod na inda ini ginpamarita. ");
INSERT INTO msb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaya grabe gayod an inda pagngalas kan Jesus kag nagasabi, “Ginhimuan niya sin maayo an tanan. Ginapabati niya an mga bungol kag ginapasurmaton an mga apa.” ");
INSERT INTO msb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sadto na panahon may nagtiripon gihapon kan Jesus na pagkadamu-damo na katawuhan. Adto sinda kaupod niya sa sulod sin tulo ka adlaw kaya nagkaurubusan gayod sinda sin balon. Ginpahalapit ni Jesus an iya mga disipulos kag sinabihan sinda, ");
INSERT INTO msb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kaluoy ko sa mga katawuhan tungod na nakiupod sinda sa akon sa sulod sin tulo na ka adlaw yana kag waraʼn makaon. ");
INSERT INTO msb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kun paulion ko sinda na gutom basi magkadirismayo sinda sa dalan kay an iba sa inda hali pa sa harayo na lugar.” ");
INSERT INTO msb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nagsabat an iya mga disipulos, “Adi kita sa kabukidan kaya diin kita makuha didi sin makaigo na pagkaon para ipakaon sani na mga katawuhan?” ");
INSERT INTO msb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Naghunga naman siya sa inda, “Pira ka bilog na tinapay an ada sa iyo?”, “Pito lang,” an inda sabat. ");
INSERT INTO msb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ginpairingkod ni Jesus an mga katawuhan sa duta. Tapos kinuha niya an pito ka bilog na tinapay. Pakapasalamat gin-utud-utod an tinapay kag ginbarahin sa iya mga disipulos agod ipanghatag ninda sa katawuhan. ");
INSERT INTO msb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Igwa man sinda sin pira ka bilog na isda. Pakapasalamati man sani ni Jesus ginsugo niya an mga disipulos na ipanghatag sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nagkaraon sinda tanan kag nagkaburusog. Pagkatapos an nabilin na mga tinapay kag isda ginpunpon san mga disipulos kag nakapuno pa sin pito na bangkat. ");
INSERT INTO msb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mga upat ka libo na mga tawo an adto didto. Pagkabusog na san mga tawo pinauli na sinda ni Jesus ");
INSERT INTO msb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kag sadto mismo nagsakay siya sa dako na baruto kaupod an iya mga disipulos kag nagkadto sinda sa lugar san Dalmanuta. ");
INSERT INTO msb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pag-abot ninda didto nagkadto naman an mga Pariseo kan Jesus kag nagtuna pakigsuay sa iya. Nangayo sinda na maghimo siya sin milagro bilang tanda na hali sa langit an iya poder. Ini pagporbar lang sa iya. ");
INSERT INTO msb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Naghangos naman sin halawig si Jesus na nagsabi, “Nano kay nagahanap kamo sin tanda? Tandai an sasabihon ko, wara sin nano man na tanda na igapakita sani na katawuhan.” ");
INSERT INTO msb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tapos binayaan sinda ni Jesus kag nagsakay gihapon sa dako na baruto patabok. ");
INSERT INTO msb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Niyan didto sa baruto nalimtan gali san mga disipulos magdara sin balon. Usad lang ka bilog na tinapay an dara didto ninda. ");
INSERT INTO msb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Didi ginpadaanan sinda ni Jesus, “Paghimat kamo! Likayi niyo an lebadura san mga Pariseo kag amo man ni Herodes.” ");
INSERT INTO msb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nag-iristoryahan sinda, “Tungod na wara kita sin tinapay kaya nagsabi siya sana.” ");
INSERT INTO msb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naaraman ni Jesus kaya hinunga sinda, “Nano kay ginairistoryahan niyo na wara kamoʼn dara na tinapay? Dili pa ba niyo naiintyindihan? Wara pa ba kamoʼn pagkasabot? Matugas lang gihapon kamo? ");
INSERT INTO msb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nano, dili kamo nakagamit san mga mata para makita? May talinga man kamo, kaya nano, dili kamo nakagamit sani para mamati? Dili ba niyo nadudumduman? ");
INSERT INTO msb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","San utud-utudon ko an lima ka bilog na tinapay para sa lima ka libo ka tawo, pira ka bangkat an iyo natipon?” An sabat ninda, “Dose.” ");
INSERT INTO msb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“San hinimo ko naman sa pito ka bilog na tinapay para sa upat ka libo, pira pa ka bangkat an iyo natipon?” Nagsabat gihapon sinda, “Pito.” ");
INSERT INTO msb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ginhunga pa gihapon sinda ni Jesus, “Wara pa ba kamo kasabot?” ");
INSERT INTO msb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pagdungka ninda sa Betsaida may buta na lalaki na gindara san iba na mga tawo kan Jesus kag nakimaluoy sinda para dapatan ini. ");
INSERT INTO msb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kinabit an buta paluwas san baryo. Didto ginludaan ni Jesus an mata san buta, gindapatan san iya kamot kag hinunga, “May nakikita ka ba?” ");
INSERT INTO msb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","An tawo na nakaaninag pa lang nagsabat, “Nakakita na akoʼn mga tawo pero baga sinda an mga kahoy na nagaralakat.” ");
INSERT INTO msb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tapos dinapatan gihapon ni Jesus an mata san lalaki kag ini nakakita na sin maayo. Nagpawa na an iya pangita san tanan na bagay. ");
INSERT INTO msb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kaya pinauli siya ni Jesus na ginasabi, “Ayaw na pagbalik didto sa baryo.” ");
INSERT INTO msb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nagpauruunhan sinda Jesus pakadto sa mga baryo san Cesarea Filipo. Sa inda pagalakat hinunga niya an mga disipulos, “Sumati daw niyo ako kun nano an pagkakilala sa akon san mga tawo.” ");
INSERT INTO msb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nagsabat sinda, “An sabi san iba ikaw kuno si Juan na Parabunyag, an iba man nagasabi na ikaw kuno si Elias, kag may nagasarabi pa na ikaw kuno usad san mga kasadto na mga propeta.” ");
INSERT INTO msb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Pero kamo naman, nano an pagkakilala niyo sa akon?” naghunga gihapon si Jesus. Nagsabat naman si Pedro, “Ikaw an Cristo na gintuga san Dios na ipapakadi.” ");
INSERT INTO msb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ginpadaanan naman niya sinda na dili gayod magpanumat bisan kanin-o man manungod sa iya. ");
INSERT INTO msb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nagtuna si Jesus pagtukdo sa inda na siya na Anak San Tawo dapat magtios sin grabe, pagapaambutan san mga kamagurangan na namumuno san mga Judio, mga namumuno san kapadian kag mga paratukdo san Kasuguan. Tapos papatayon siya pero pakalipas sin tulo ka adlaw mabubuhay gihapon. ");
INSERT INTO msb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hayag na sinabi niya ini. Tapos ginbulag anay siya ni Pedro sa kadamuan kag nagtuna pagsaway sa iya. ");
INSERT INTO msb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero paglingi sinud-ong ni Jesus an iya mga disipulos kag gin-uritan si Pedro na an sabi, “Layas dida, Satanas! An imo ginaisip dili makaDios kundi makatawo.” ");
INSERT INTO msb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ginpahalapit ni Jesus an mga tawo kaupod an iya mga disipulos kag ginsabihan sinda, “Kun may gusto mag-upod sa akon bilang disipulos ko dili dapat niya sundon an sadiri niya na kabubut-on kundi sundon lugod an kaburut-on ko kag pas-anon an iya krus na amo an pagtios tungod sa akon. ");
INSERT INTO msb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nasabi ko ini kay an nagahandom na masalbar an iya buhay para sa iya sadiri mawawar-an lugod sani, pero an maghalad san iya buhay alang-alang sa akon kag sa Maayo Na Barita masasalbar lugod sani. ");
INSERT INTO msb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kay nano man an pakinabang san tawo kun mapasa iya an bilog na kinab-an kag an kabalyo sani an pagkawara san iya buhay? Syimpre wara gayod! ");
INSERT INTO msb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay wara man siyaʼn mahatag agod mapabalik ina na buhay. ");
INSERT INTO msb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaya kun may tawo na ikakaalo ako kag san akon mga surmaton sani na makalalaw-ay kag makasasala na panahon, ikakaalo ko man siya bilang Anak San Tawo pagbalik ko sa kapawa san glorya san akon Ama kag kaupod an mga banal na anghel.” ");
INSERT INTO msb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nagpadayon si Jesus pag-istorya, “Ginasiguro ko sa iyo na igwa sin pira sa iyo na nagatindog didi na dili mamamatay hasta makita an pag-abot san kahadian san Dios na magaabot na may kagamhanan.” ");
INSERT INTO msb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkalipas sin unom ka adlaw gin-agda ni Jesus sinda Pedro, Santiago kag Juan pagsagka kaupod niya sa hataas na bukid na sinda-sinda lang gayod. Didto sa atubangan mismo ninda nag-iba an hitsura ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nagputi-puti na nagakinang-kinang an iya bado kag wara na sin makapaputi pa gayod sin pareho sadto didi sa kinab-an. ");
INSERT INTO msb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Myintras sinda nagamiron nagpakita sa inda sinda Elias kag Moises kag nakisurmaton sinda kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Didi ginsabihan ni Pedro si Jesus, “Maestro, maayo man na adi kita. Tugutan kami na magtindog didi sin tulo na kubung-kubong na an usad sa imo, usad naman kan Moises kag usad pa kan Elias.” ");
INSERT INTO msb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nasabi ini ni Pedro kay nagkaharadlok gayod sinda kaya dili niya aram kun nanoʼn sabihon. ");
INSERT INTO msb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Taud-taod may dampog na nahandungan sinda kag didto may nabati sinda na boses, “Amo ini an akon pinalangga na Anak. Pamatii niyo siya!” ");
INSERT INTO msb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Paglingat-lingat dayon ninda sa patalibod wara sinda sin iba na nakita kundi si Jesus lang. ");
INSERT INTO msb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Paglugsad na ninda hali sa bukid ginpadaanan naman niya sinda na, “Ayaw gayod kamo pagpanumat bisan kanin-o san iyo nakita hasta ako na an Anak San Tawo mabuhay gihapon hali sa pagkamatay.” ");
INSERT INTO msb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tinandaan ninda sin maayo an padaan ni Jesus pero nagpahurunga-hunga kun nano an gusto sabihon san “pagkabuhay gihapon hali sa pagkamatay.” ");
INSERT INTO msb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tapos hinunga ninda si Jesus, “Nano kay nagasarabi an mga paratukdo san Kasuguan na dapat mauuna anay pagpakadi si Elias antes an Cristo?” ");
INSERT INTO msb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“Matuod,” an sabat niya, “Mauuna si Elias pag-abot para kitaon na an tanan-tanan nasa tama na kamutangan. Pero nano kay nasabi sa Banal Na Kasuratan na ako na Anak San Tawo magatios gayod kag igasikway? ");
INSERT INTO msb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tandai an sasabihon ko, nag-abot na si Elias kag gintratar siya san mga tawo sugad san gusto ninda susog sa nasurat sa Banal Na Kasuratan manungod sa iya.” ");
INSERT INTO msb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Paglugsad na ninda Jesus sa bukid kag nagapahalapit man gihapon sa iba na mga disipulos, nakita ninda na damu-damo anmga tawo patalibod kag may mga paratukdo man san Kasuguan na nakigsuay pa sa inda. ");
INSERT INTO msb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pakalantaw san mga tawo kan Jesus nagkangarawa sinda kag nagdaralagan pakadto sa iya agod kumustahon siya. ");
INSERT INTO msb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Naghunga si Jesus, “Nano an ginapakigsuayan niyo sa inda?” ");
INSERT INTO msb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","May tawo sa kadamuan na nagsabat, “Maestro, ginpakadi ko sa imo an akon anak na lalaki kay ginsudlan siya sin maraot na espirito na nakapaapa sa iya. ");
INSERT INTO msb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kun ginaataki siya ginasagmok siya sa duta, nagabura an iya ba-ba, nagapagot an iya ngipon kag nagapanugas san iya lawas. Nakimaluoy ako sa imo mga disipulos na pahalion an maraot na espirito pero wara sindaʼn nahimo.” ");
INSERT INTO msb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sinabat naman sinda ni Jesus, “Mga waraʼn pagtuod, hasta san-o ta kamo dapat pagatiusan? Nano, dapat ako makiupod sa iyo hasta na lang? Sige, pakadia niyo siya sa akon.” ");
INSERT INTO msb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kaya dinara ninda an bata sa iya. Pakakita lang san maraot na espirito kan Jesus ginauy-og dayon an bata na natumba sa duta na nagaligid-ligid kag nagabura an baba. ");
INSERT INTO msb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Hinunga ni Jesus an ama, “Kasan-o pa nagtuna ini na nangyayari sa iya?” “Tuna san dyutay pa siya na bata,” an sabat san ama. ");
INSERT INTO msb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Pirme siya sani ginalabog sa kalayo kag tubig para patayon. Kaya kun may mahimo ka man lang, maluoy ka sa amon kag buligi man kami.” ");
INSERT INTO msb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“‘Kun may mahimo’?” an sabat ni Jesus! “An tanan mahihimo kun may pagtuod.” ");
INSERT INTO msb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Insigida sumiyak an ama san bata, “Nagatuod po ako. Punui man an kakulangan san akon pagtuod.” ");
INSERT INTO msb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pakakita ni Jesus na nagadamo an mga miron na nagadiris-ukan patalibod, sinaway niya an maraot na espirito, “Ikaw na espirito na nakapaapa kag nakapabungol, magluwas ka sa bata kag ayaw na gayod pagsulod pa.” ");
INSERT INTO msb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pakasiyak san maraot na espirito gin-uy-og sin makusog an bata kag naghali na. An bata nakahigda didto na bagaʼn patay na, kaya an kadamuan nagasarabi, “Patay na siya.” ");
INSERT INTO msb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero kinaptan siya ni Jesus sa kamot, binangon kag nakatindog na siya. ");
INSERT INTO msb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pagsulod na gihapon ni Jesus sa balay kag sinda-sinda na lang san iya mga disipulos naghunga sinda, “Nano kay wara namon mapaluwas idtoʼn demonyo?” ");
INSERT INTO msb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ginsabat sinda ni Jesus, “Amo ini an klase san maraot na espirito na napapahali lang paagi sa pagpangadyi.” ");
INSERT INTO msb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Paghali ninda sadto na lugar nag-agi sinda sa Galilea pero habo si Jesus na maaraman pa ini san mga tawo, ");
INSERT INTO msb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay ginatukduan niya an iya mga disipulos. Ginasabi niya, “Ako na Anak San Tawo iintriga sa gahom san katawuhan tapos igapapatay ako pero pag-ikatulo ka adlaw mabubuhay gihapon.” ");
INSERT INTO msb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dili pa gihapon ninda nasabutan an iya gusto sabihon kag nahahadlok sinda maghunga sa iya. ");
INSERT INTO msb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pag-abot ninda sa Capernaum, nagsulod sinda sa balay. Didto hinunga sinda ni Jesus, “Nano an ginaparasuruayan niyo sa dalan?” ");
INSERT INTO msb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Waraʼn nagsabat sa inda kay an ginasuruayan ninda kun sin-o gayod sa inda an pinakalabaw sa tanan. ");
INSERT INTO msb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kaya nag-ingkod si Jesus, tinawag an dose kag sinabihan, “An gusto mag-una kinahanglan na magpaurhi anay kag magin suruguon san tanan.” ");
INSERT INTO msb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tapos nagkuha siya sin bata kag pinatindog niya sa atubangan ninda. Kinugos niya ini, ");
INSERT INTO msb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","kag nagsabi, “An makaako sin pareho sani na bata sa ngaran ko ginaako man ako kag an mag-ako sa akon dili lang ako an iya ginaako kundi an nagsugo sa akon.” ");
INSERT INTO msb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Niyan may ginsumat si Juan sa iya, “Maestro, nakakita kami sin lalaki na nagapaluwas sin mga demonyo sa lawas san mga tawo paagi sa imo ngaran. Kaya ginbawalan namon siya kay dili man naton kaupod.” ");
INSERT INTO msb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero sinabihan sinda ni Jesus, “Ayaw niyo siya pagbawali kay wara sin tawo na pakatapos maghimo sin milagro sa ngaran ko mapakaraot dayon sa akon. ");
INSERT INTO msb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","An dili nagakontra sa aton apin sa aton. ");
INSERT INTO msb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Idtoʼn maghatag sa iyo sin tubig na irimnon tungod kay mga sakop kamo ni Cristo sigurado gayod na makabaton siyaʼn balos.” ");
INSERT INTO msb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kun may nakapakasala sani na mga kabataan na may pagtuod sa akon maayo pa na bitayan idto sin dako na gilingan na bato sa liog kag ipilak sa dagat. ");
INSERT INTO msb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kun an imo kamot amo an makapakasala sa imo, utuda ina! Maayo pa na mabuhay ka na pungkol ki sa may duha na kamot kag mapaimpyerno ka sa kalayo na dili gayod napaparong. ");
INSERT INTO msb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Didto an mga ulod waraʼn udong sin kakakutkot san mga lawas kag dili man gayod napaparong an kalayo. ");
INSERT INTO msb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kun an imo tiil amo man an makapakasala sa imo, utuda ina! Maayo pa na mabuhay ka na pilay ki sa duha an tiil mo kag mapaimpyerno ka lugod. ");
INSERT INTO msb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Didto an mga ulod waraʼn udong sin kakakutkot san mga lawas kag dili man gayod napaparong an kalayo. ");
INSERT INTO msb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kun an imo naman mata an dahilan san imo pagkasala, lukata! Mas maayo pa na makasulod ka sa kahadian san Dios na may usad lang an mata ki sa duha an imo mata kag mapaimpyerno ka. ");
INSERT INTO msb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Didto ‘an mga ulod waraʼn udong sin kakakutkot san mga lawas kag dili man gayod napaparong an kalayo.’ ");
INSERT INTO msb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“An tanan magapalinis paagi sa kalayo pareho san pagpabanal san sakripisyo paagi san asin. ");
INSERT INTO msb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maayo an asin pero kun an asin mawar-an sin arat pan-o pa ini mapaarat gihapon? Magin pareho lugod kamo san asin kag dili na kamo magsaramok.” ");
INSERT INTO msb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Paghali ninda Jesus sa Capernaum nagpakadto sa probinsya san Judea kag hasta sa unhan san suba san Jordan. Damu-damo man na mga tawo an nagtiriripon kan Jesus kag pareho san dati na iya ginahimo gintukduan niya sinda. ");
INSERT INTO msb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","May mga Pariseo na naghalapit sa iya kag naghunga agod maporbaran siya. “Nano, kontra sa Kasuguan na bulagan san lalaki an iya asawa?” ");
INSERT INTO msb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ginsabat sinda ni Jesus, “Nano an ginmanda ni Moises sa iyo?” ");
INSERT INTO msb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nagsabat sinda, “Gintugutan ni Moises na pahalion san lalaki an iya asawa pakasurat na niya san kasuratan sa pakigbulag kag ginhatag ini sa iya.” ");
INSERT INTO msb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Niyan ginsabihan sinda ni Jesus, “Dahilan sa iyo kasutilan kaya ginsurat niya ini na sugo. ");
INSERT INTO msb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero sa katuna-tunai pa san paglalang susog sa Kasuratan, ‘ginlalang san Dios an mga tawo na magin lalaki kag babayi.’ ");
INSERT INTO msb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Dahilan sani pagabayaan san lalaki an iya ama kag iloy, ");
INSERT INTO msb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kag makig-upod sa iya asawa,’ tapos sindaʼn duha magigin usad na lang na lawas. Kaya dili na sinda duha kundi usad na lang. ");
INSERT INTO msb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kun kaya an ginbiyo san Dios dili dapat pagbulagon san tawo.” ");
INSERT INTO msb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagbalik ninda Jesus sa balay naghurunga gihapon sa iya an mga disipulos manungod sani. ");
INSERT INTO msb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ginsabat niya sinda na “An lalaki na makigbulag sa iya asawa kag mag-asawa sa iba nagakasala sin pagpanambay kontra sa iya asawa. ");
INSERT INTO msb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Amo man kun an babayi bulagan an iya asawa kag magpaasawa sa iba siya man nagakasala sin pagpanambay.” ");
INSERT INTO msb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","May mga tawo na nagadara kan Jesus sin tigdyutay na kabataan agod madapatan niya pero pakakita sani san mga disipulos ginsaway idtoʼn mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","San makita ni Jesus an inda hinimo naurit kag sinabihan sinda, “Ayaw niyo pag-ulanga an mga tigdyutay na kabataan kundi pakadia sa akon kay para sa pareho sani na mga bata an kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ginasiguro ko sa iyo na an sin-o man na dili magpasakop sa paghadi san Dios na pareho sin dyutay na bata dili makasulod sana na kahadian.” ");
INSERT INTO msb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tapos ginkugos niya an mga kabataan, gindapatan san iya kamot kag ginbendisyunan. ");
INSERT INTO msb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","San magtuna na si Jesus paglakat, may lalaki na nagdalagan pakadto sa iya, nagluhod sa atubangan niya kag naghunga, “Maayo na maestro, nano an dapat ko himuon agod masadiri ko an buhay na waraʼn katapusan?” ");
INSERT INTO msb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ginhunga siya ni Jesus, “Nano kay ginatawag mo ako na maayo? Waraʼn iba na maayo kundi an Dios lang. ");
INSERT INTO msb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aram mo na an mga Kasuguan: ‘Dili ka magpatay, dili ka magpanambay, dili ka magpangawat, dili ka magtestigos sin kabuwaan, dili ka magdaya, galangan mo an imo ama kag iloy.’,” ");
INSERT INTO msb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ginsabihan siya san lalaki, “Maestro, gintuman ko ina tanan tuna san bata pa ako.” ");
INSERT INTO msb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sinud-ong siya ni Jesus na may pagkamuot kag sinabihan, “Igwa pa sin kulang sa imo. Mag-uli ka, ibaligya an tanan mo na kasadirihan tapos ipanghatag sa pobre an kabaklanan kay magkakaigwa ka sin kayamanan kaupod sa Dios sa langit. Pakatapos bumalik ka kag mag-upod sa akon.” ");
INSERT INTO msb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naglain an buot san lalaki pakabati niya sadto kag mamunduon na naglakat dahilan na mayaman-yaman siya. ");
INSERT INTO msb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Paglingi ni Jesus sa iya mga disipulos sinabihan, “Malisod gayod sa mga mayaman an pagsulod sa kahadian san Dios!” ");
INSERT INTO msb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nagkangarawa an mga disipulos sa iya mga surmaton. Pero nagpadayon pagsurmaton sa inda si Jesus, “Mga anak, malisod gayod an pagsulod sa kahadian san Dios! ");
INSERT INTO msb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas masayon pa makaagi an kamelyo sa luho san dagom ki sa pagsulod san mayaman sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mas lalo na nagkangarawa an iya mga disipulos. Kaya naghunga sinda, “Kun sugad sin-o man gali an masasalbar?” ");
INSERT INTO msb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ginsud-ong sinda ni Jesus kag ginsabihan, “Dili kaya an mga tawo na mahimo sani pero kaya san Dios kay siya an makahimo san tanan.” ");
INSERT INTO msb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Didi nagsabi si Pedro, “Kitaa. Ginbayaan namon an tanan agod mag-upod sa imo.” ");
INSERT INTO msb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nagsabat si Jesus, “Matuod na ginasabi ko sa iyo, waraʼn nabaya san panimalay, mga kamaranghod, ama, iloy, mga anak, o kasadirihan dahilan sa akon kag sa pagpalukop san Maayo Na Barita ");
INSERT INTO msb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na dili makabaton sin ginatus-gatos sani na panahon sin mga panimalay, mga kamaranghod, mga ama, mga iloy, mga kabataan kag mga kasadirihan na may kaupod man na kasakitan kag sa maabot na panahon magkakaigwa naman sin buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Damo ugaling na mga kilala na tawo yana an mapapaubos kag an mapapaitaas naman an mga dili kilala na tawo yana.” ");
INSERT INTO msb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","San nagasaragka na sinda pakadto sa Jerusalem nauna si Jesus. Nagkangarawa an mga disipulos kag nagkaharadlok idtoʼn mga tawo naman na nagasurunod sa inda. Ginbulag gihapon ni Jesus an dose na disipulos kag ginpahayagan sinda kun nano an mangyayari sa iya. ");
INSERT INTO msb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Tandai pa niyo an sasabihon ko, yana nagasagka kita pa-Jerusalem kag pag-abot didto ako na Anak San Tawo igaintriga sa mga pinakapuno san kapadian kag sa mga paratukdo san Kasuguan. Tapos magahusgar sinda na patayon ako kaya iintriga naman sa mga dili-Judio. ");
INSERT INTO msb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kun ada na ako sa inda, sinda magatuya-tuya, magaluda, magabunal kag magapatay sa akon pero sa ikatulo na adlaw mabubuhay ako gihapon.” ");
INSERT INTO msb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naghalapit kan Jesus an magmanghod na sinda Santiago kag Juan na mga anak ni Zebedeo tapos ginsabihan siya, “Maestro, gusto namon na himuon mo an pagahangyuon namon sa imo.” ");
INSERT INTO msb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ginhunga niya sinda, “Nano an gusto niyo na himuon ko para sa iyo?” ");
INSERT INTO msb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nagsabat sinda, “Tuguti na makaingkod kami sa magluyo mo kun magahadi ka sa imo glorya didto sa Jerusalem.” ");
INSERT INTO msb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Didi ginsabihan sinda ni Jesus, “Dili niyo aram kun nano an iyo ginahangyo kay dapat anay ako magtios antes magahadi. Nano, makainom kamo sa kupa na akon pagainuman? Nano, makaako man kamo san pagbunyag na para sa akon?” ");
INSERT INTO msb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nagsabat man sinda, “Opo.” Tapos, ginsabihan naman sinda ni Jesus, “Amo ngani, pagainuman man niyo an kupa na akon pagainuman kag kamo pagabunyagan pareho san pagbunyag sa akon. ");
INSERT INTO msb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ugaling wara akoʼn poder na magpili kun sin-o an papaingkudon sa akon magluyo kundi ina para sadtoʼn natiganahan na.” ");
INSERT INTO msb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pakabati sani san napulo nagtuna sinda magkaururit kanda Santiago kag Juan. ");
INSERT INTO msb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaya ginpahalapit sinda tanan ni Jesus kag ginsabihan, “Aram niyo na an mga namumuno sa mga dili-Judio amo an nagadaog sa inda kag an mga bantog amo an nagasakop sa inda. ");
INSERT INTO msb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero dili ina dapat na mangyari sa iyo kundi an nagahandom magin pinakalabaw sa iyo kinahanglan magin suruguon niyo, ");
INSERT INTO msb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","kag an gusto magpalabaw sa iyo kinahanglan magpauripon man siya sa tanan. ");
INSERT INTO msb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nasabi ko ini kay ako na Anak San Tawo nagpakadi sa kinab-an dili agod sirbihan kundi magsirbe kag ihalad an akon buhay bilang pagtubos para sa kadamuan.” ");
INSERT INTO msb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nakaagi sinda Jesus sa Jerico kag san mahali na kaupod san damo na mga tawo nalabayan ninda an anak ni Timeo na si Bartimeo. Buta siya kag ada na nakaingkod sa may higad san kamino nagapakilimos. ");
INSERT INTO msb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","San mabaritaan niya na nagadangadang si Jesus na taga-Nazaret nagsiyak siya, “Jesus, Lahi ni David, kaluy-i ako!” ");
INSERT INTO msb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Damo an nagsaway sa iya kag nagporbar papuyuon siya pero nagsiyak lugod siyaʼn mas makusog pa, “Lahi ni David, kaluy-i ako!” ");
INSERT INTO msb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Umudong si Jesus kag nagsabi, “Pakadia siya.” Kaya gintawag ninda an buta kag ginsabihan, “Pakusuga an imo buot. Tumindog ka kay ginpatawag ka niya.” ");
INSERT INTO msb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pakahali san iya alikboy tumindog siya dayon kag kumadto kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ginhunga siya ni Jesus, “Nano an gusto mo na himuon ko para sa imo?” An sabat san buta, “Maestro, gusto ko po makakita.” ");
INSERT INTO msb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ginsabihan siya ni Jesus, “Umuli ka. An pagtuod mo amo an nakaayo sa imo.” Sana mismo nakakita dayon siya kag nagsunod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","San nagadangadang na sinda Jesus sa Jerusalem ada na an Betfage kag Betania na adto na sa Bukid San Kaolibohan. Didi nagsugo si Jesus sin duha san iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kumadto kamo sa kaatubang na baryo kag pagsulod dayon niyo, makakita kamo sin nakahigot na tinday na asno na wara pa gayod masakyi. Hubadi anay niyo tapos guyuda pakadi. ");
INSERT INTO msb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kun may maghunga sa iyo, ‘Nano kay ginahimo niyo ina?’ Sabihi sinda na, ‘Ginakinahanglan ini san Ginoo kag ibabalik man dayon.’,” ");
INSERT INTO msb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Naglakat na sinda sa baryo kag nakita an nakahigot na tinday sa kilid san kamino halapit sa may pwertahan. San ginahubad ninda ini, ");
INSERT INTO msb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","may nagatindog na mga tawo didto na naghunga, “Nano kay ginahubad niyo ina na tinday?” ");
INSERT INTO msb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ginsurmatan sinda san pareho san ginpasabi sa inda ni Jesus kaya pinabayaan na lang sinda na guyudon an tinday. ");
INSERT INTO msb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ginuyod ninda ini pakadto kan Jesus tapos hinapinan san inda mga alikboy an likod sani kag nagsakay si Jesus. ");
INSERT INTO msb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Damo na mga tawo an nagralatag san inda mga alikboy sa iya aagihan sa paggalang sa iya. An iba man naglatag sin madahon na mga sanga na ginbarali ninda sa mga kahoy sa umahan kay gusto ninda maggalang man. ");
INSERT INTO msb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","An mga tawo na nagkauruna sa iya kag san nagasurunod nagasiriyak sin, “Hosanna! Ginpalabi ini siya na nagapakadi sa ngaran san Ginoo!” ");
INSERT INTO msb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Ginpalabi san Dios an nagaabot na hadi na masubli kan Hadiʼn David na aton kalulululuhan! Umawon an pinakalabaw sa tanan!” ");
INSERT INTO msb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pag-abot ni Jesus sa Jerusalem nagsulod sa templo. San makita na niya an tanan patalibod palibhasa tikapo na sa oras nagluwas siya kag nagbalik sa Betania na kaupod an dose. ");
INSERT INTO msb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkaaga san mahali na sinda sa Betania nakabatyag sin kagutom si Jesus. ");
INSERT INTO msb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Harayo pa may puno san kahoy na ginatawag higera na madahon an nalantawan niya. Naghalapit siya agod kitaon kun may bunga pero wara gayod siyaʼn nakita kundi mga dahon lang palibhasa dili pa tigbungahan. ");
INSERT INTO msb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ginsabihan niya an puno san higera, “Wara na lugod sin makakaon pa san imo bunga.” Ini nabatian san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pag-abot ninda Jesus sa Jerusalem nagsulod siya sa templo kag nagtuna pagpaluwas san mga parabaligya kag mga nagapamakal didto. Pinangtumba naman niya an mga lamesa san mga parabaralyo sin kwarta kag an mga ingkudan sadtoʼn mga parabaligyaʼn mga salampati. ");
INSERT INTO msb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ginbawal man niya na magsulod sa templo an mga dara na itirinda. ");
INSERT INTO msb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tapos gintukduan niya sinda kag ginsabihan, “Dili ba nasurat na an ginsabi san Dios: ‘An akon balay amo an balay para sa tanan na katawuhan kag an pagatawagon sana amo an balay na pangadyian?’ Pero nano an ginhimo niyo? Ginhimo niyo ini bilang ‘istaran san mga makawat.’” ");
INSERT INTO msb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nabaritaan ini san mga namumuno san kapadian kag mga paratukdo san Kasuguan. Kaya nagahanap sinda sin paagi na patayon siya kay nagakaharadlok sinda sa iya dahilan na an tanan na mga tawo nagkangarawa sa iya pagtukdo. ");
INSERT INTO msb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pagkagab-i naghali sinda Jesus sa syudad. ");
INSERT INTO msb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Paglabay ninda otro aga nakita ninda an kahoy na higera na nag-uga hasta sa gamot. ");
INSERT INTO msb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadumduman ni Pedro an nangyari kaya ginsabihan niya si Jesus, “Maestro, kitaa! Nag-uga an higera na ginmaldisyon mo.” ");
INSERT INTO msb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ginsabat sinda ni Jesus, “Magtuod sa Dios. ");
INSERT INTO msb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Matuod an ginasabi ko sa iyo: an magsabi sani na bukid, ‘Gabot kag ipilak an sadiri mo sa dagat,’ na waraʼn pagduha-duha sa iya tagipusuon kundi nagatuod na an iya ginasabi mangyayari, ini hihimuon san Dios para sa iya. ");
INSERT INTO msb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kaya matuod an ginasabi ko sa iyo, bisan nano man an ayuon niyo sa iyo pangadyi, magtuod na nabaton na kay ina mapapasa iyo. ");
INSERT INTO msb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sa iyo naman pagpangadyi na nakatindog, patawada anay an mga nagkasala sa iyo agod patawadon man san Ama sa langit an iyo mga nahimo na kasal-an. ");
INSERT INTO msb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kun dili man kamo magpatawad lalo na dili pagapatawadon san Ama sa langit an iyo mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nag-abot man gihapon sinda sa Jerusalem kag myintras nagalakat si Jesus didto sa templo nagturulos sa iya an mga namumuno san kapadian, mga paratukdo san Kasuguan kag mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tapos ginhunga siya, “Kanin-o pagbuot an paghimo mo sani? Sin-o gayod an naghatag sa imo sin otoridad sa paghimo sani?” ");
INSERT INTO msb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ginsabat naman sinda ni Jesus, “Hungaon ta man kamo kag kun masabat niyo ako pagasabaton ko naman kun kanin-o otoridad an paghimo ko sani. ");
INSERT INTO msb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Niyan, sumati daw ako niyo kun kanin-o pagbuot naghali an otoridad ni Juan para magpambunyag. Hali sa Dios sa langit ina o sa mga tawo? Sabata niyo ako.” ");
INSERT INTO msb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Didi sinda nagpahurunga-hunga kun nano an ikasabat. “Kun sabihon naton, ‘Hali sa langit,’ mahunga naman siya, ‘Kun amo, nano kay wara niyo siya pagtuudi?’ ");
INSERT INTO msb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nano, sasabaton naman naton, ‘Hali sa tawo?’,” Habo sinda sana kay nahahadlok man sinda sa mga tawo kay an tanan ginakilala si Juan na matuod na propeta. ");
INSERT INTO msb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaya an inda sabat kan Jesus amo ini, “Dili namon aram.” Ginsabat naman niya sinda, “Kun sugad dili ko man sasabihon sa iyo kun kanin-o otoridad ginahimo ko ini.” ");
INSERT INTO msb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nagtuna si Jesus pagsurmaton sa inda sin istorya, “May tawo na nagtanom sin damo na ubas. Kinudalan niya patalibod, nagbuho sin pugaan san ubas kag nagtindog sin hataas na bantayan. Tapos ginpapletihan niya sa mga parabantay kag nagkadto sa harayo na lugar. ");
INSERT INTO msb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pag-abot san panahon san tigpuduan may ginsugo siya pakadto sa mga parabantay para magkuha san iya bahin na produkto. ");
INSERT INTO msb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero ginburuligan san mga parabantay an iya ginsugo, binurubalbag kag pinauli na waraʼn dara. ");
INSERT INTO msb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Tapos may ginsugo gihapon siyaʼn ikaduha na suruguon pakadto sa mga parabantay pero inda ini pinalo sa ulo kag pinakaaluhan. ");
INSERT INTO msb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","May usad pa na ginsugo pero pinatay ninda ini. Damo pa man sin pinangsugo an tag-iya. An iba binurubalbag ninda kag ginpapatay man an iba. ");
INSERT INTO msb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tapos an iya pinakapalangga na anak na lalaki an nabilin na lang na suguon. Kaya ginsugo niya ini pakadto sa inda kag nagsabi sa iya sadiri, ‘Pagagalangan ninda an akon anak.’ ");
INSERT INTO msb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Pero pakakita san mga parabantay, nag-iristoryahan sinda na nagasabi, ‘Amo ini an iredero. Kadi kamo, patyon naton agod an iya irensyahon mapapasa aton.’ ");
INSERT INTO msb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kaya dinakop ninda an anak san tag-iya, pinatay kag initsa an iya lawas sa luwas san ubasan. ");
INSERT INTO msb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Niyan, nano an hihimuon san tag-iya san ubasan? Makadto siya kag patayon idtoʼn mga parabantay tapos pagapapletihan an ubasan sa iba. ");
INSERT INTO msb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nano, wara pa niyo nabasa ini sa Banal Na Kasuratan, ‘An bato na ginhabuan san mga parabalay amo lugod an nagin pinakaimportante na bato sa balay. ");
INSERT INTO msb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","An Ginoo an naghimo sani kag makangangawa gayod sa aton’?” ");
INSERT INTO msb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tapos an mga namumuno san mga Judio ipapadakop kuntani si Jesus kay namalisyahan ninda na sinda an ginapatamaan sadtoʼn istorya pero nahahadlok sinda sa kadamuan. Kaya pinabayaan na lang ninda si Jesus kag nagharali sinda. ");
INSERT INTO msb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pakatapos ginsugo ninda an pira ka tawo na Pariseo kag mga sakop ni Herodes para madakop si Jesus sa iya mga ginapanurmaton. ");
INSERT INTO msb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nagkadto sinda sa iya kag naghunga, “Maestro, aram namon na matanos ka na tawo kag matuod an pagtukdo mo manungod san pagbuot san Dios. Wara ka man sin ginapalabi bisan sin-o kay dili mo ginapanginano kun sin-o an tawo. Kaya susog sa Kasuguan tama ba na magbayad sin buwis kan Cesar? ");
INSERT INTO msb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kun kaya nano sa paghuna mo? Tama kita magbayad o dili?” Pero aram ni Jesus na panluko lang an inda kaisipan kaya ginsabihan sinda, “Nano kay gusto niyo ako porbaran? Abir, darhi daw ako niyo sin sinsilyo kay kitaon ta.” ");
INSERT INTO msb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kaya dinarhan siya tapos ginhunga sinda, “Kanin-o pamayhon kag ngaran an adi didi?” “Kan Cesar,” an sabat san mga sinugo. ");
INSERT INTO msb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kaya, ginsabihan sinda ni Jesus, “Kun sugad ihatag kan Cesar an para kan Cesar kag sa Dios an para sa Dios.” Nagkangarawa sinda sa iya. ");
INSERT INTO msb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pagkatapos may pira na mga Saduceo na nagkadto kan Jesus. Ini sinda mga Judio na dili nagatuod san pagkabuhay gihapon, kaya naghunga sinda sa iya, ");
INSERT INTO msb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maestro, naaraman namon sa Kasuguan na ginsurat ni Moises na kun may magurang na lalaki na napatay kag waraʼn anak, an manghod dapat na asawahon an biyuda agod makaanak sinda para sa magurang na napatay. ");
INSERT INTO msb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Niyan may pito na magmaranghod na lalaki. An subang nangasawa kag napatay na waraʼn anak. ");
INSERT INTO msb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","An ikaduha inasawa man an biyuda kag siya man napatay na waraʼn anak. Amo man an nangyari sa ikatulo na manghod. ");
INSERT INTO msb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Napatay sinda na pito na wara gayod sin anak. Sa katapusan napatay man an babayi. ");
INSERT INTO msb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Niyan pag-abot san pagkabuhay gihapon sin-o sa pito an pagakilalahon niya na tunay na asawa dahilan na nagin asawa siya san pito na magmaranghod?” ");
INSERT INTO msb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ginsabat sinda ni Jesus, “Sala kamo kay dili niyo nasasabutan an Banal Na Kasuratan o an gahom san Dios. ");
INSERT INTO msb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sa pagkabuhay gihapon an mga lalaki kag babayi dili na magaarasawahan kay kapareho na sinda san mga anghel sa langit. ");
INSERT INTO msb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Niyan manungod man san pagkabuhay gihapon, nano, wara pa gayod kamo sin nabasa sa libro ni Moises manungod sa nagalaad na tanom na dili nasusunog? Didto nagsurmaton an Dios sa iya kag nagsabi, ‘Ako an Dios ni Abraham, an Dios naman ni Isaac kag ni Jacob.’ ");
INSERT INTO msb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dili siya Dios san mga patay kundi san mga buhay. Sala gayod kamo!” ");
INSERT INTO msb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Niyan may paratukdo san Kasuguan na nabatian san inda pagsuruay. Namalisyahan niya na maayo an pakasabat ni Jesus sa inda kaya nagpahalapit siya kag naghunga man sa iya, “Nano an pinakalabaw na sugo sa Kasuguan?” ");
INSERT INTO msb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nagsabat si Jesus, “Amo ini an pinakalabaw: ‘Mga taga-Israel, pamati kamo! An Ginoo na aton Dios amo lang an Ginoo. ");
INSERT INTO msb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dapat mo kamut-an an Ginoo na imo Dios sa imo puso, sa bilog moʼn tagipusuon, sa tanan san imo pagaisip kag paagi man sa paggamit mo san tanan na kusog sa pagsirbe sa iya.’ ");
INSERT INTO msb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","An ikaduha amo ini: ‘Kamut-an mo an imo kapwa pareho san pagkamuot mo sa imo sadiri.’ Wara na sin iba na sugo na makalabaw pa sani.” ");
INSERT INTO msb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nagsurmaton man an paratukdo san Kasuguan, “Maayo, Maestro. Tama gayod na usad lang an Dios kag wara na sin iba kundi siya lang. ");
INSERT INTO msb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dapat kamut-an siya sa bilog na tagipusuon, sa bilog na pag-iisip kag kusog kag kamut-an an kapwa pareho san pagkamuot mo sa imo sadiri. Mas maayo pa ini ki sa nano man na halad o sakripisyo.” ");
INSERT INTO msb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","San nabati ni Jesus na maayo an iya panabat ginsabihan siya, “Haros makasulod ka na sa kahadian san Dios.” Pakatapos sadto waraʼn nagkusug-kusugan sin buot na maghunga pa sa iya. ");
INSERT INTO msb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nagatukdo si Jesus sa templo kag naghunga, “Nano kay ginasabi san mga paratukdo san Kasuguan na an Cristo amo an kalahi ni David? ");
INSERT INTO msb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","San nasa gahom si David san Espirito Santo siya mismo nakasabi, ‘An Ginoo nagsabi sa akon Ginoo, Mag-ingkod ka sa may tuo ko hasta na ipasakop ko sa imo an imo mga kaaway.’ ");
INSERT INTO msb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kay si David mismo nagtawag sa iya sin Ginoo pan-o magin kalahi ni David an Cristo?” Waraʼn nakasabat pero nagpamati na nalipay an kadamuan na mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa pagpadayon niya pagtukdo ginsabi na, “Likayi an mga paratukdo san Kasuguan. Naiila sinda mamasyar na nakabisti sin halaba kag mamahalon. Naiila man sinda na galangan lalo na sa merkado. ");
INSERT INTO msb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Naiila man sinda mag-ingkod sa unahan san mga sinagoga kag sa pinakahalandon na pwesto sa mga ponsya. ");
INSERT INTO msb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Amo ini an mga tawo na nagaprobitsar san sadiri san mga biyuda kag nagapangadyi sin halagba sa pagpakita lang. Kaya, mas grabe gayod an kastigo ninda.” ");
INSERT INTO msb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Niyan nag-ingkod si Jesus na nakaatubang sa ginahulugan san kwarta para sa gastos sa templo kag nagamasid sa mga tawo na nagahulog san inda kwarta didto. Kadamuan san mga mayaman nagahulog sin daragko na kantidad. ");
INSERT INTO msb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Taud-taod may pobre na biyuda na naghulog sin duha na sentimos. ");
INSERT INTO msb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tinawag ni Jesus an iya mga disipulos kag ginsabihan sinda, “Matuod gayod na mas dako pa an ginhulog sani na pobre na biyuda ki sa tanan na naghatag. ");
INSERT INTO msb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sinda naghatag hali sa inda kabuganaan pero an biyuda naman sa iya kapobrehan ginhatag gayod an tanan hasta na ngani an isurugpon pa sa ginhawa.” ");
INSERT INTO msb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","San nagaluwas na si Jesus sa templo ginsabihan siya san usad san iya mga disipulos, “Maestro, kitaa kun sing-ano kadaragko san mga bato kag katahom san mga gusali san templo!” ");
INSERT INTO msb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nagsabat si Jesus, “Nakikita ba niyo iniʼn mga daragko na mga gusali? An tanan maruruba. Waraʼn mabibilin ni usad saniʼn nagatarakin na bato.” ");
INSERT INTO msb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Taud-taod san sinda-sinda na lang nagaingkod si Jesus sa Bukid San Kaolibohan na nakaatubang sa templo. Tapos sinda Pedro naman, Santiago, Juan kag Andres naghunga sa iya, ");
INSERT INTO msb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Sabihi kami kun san-o ini mangyayari kag nano an tanda na igapakita na ini tanan haros matutuman na?” ");
INSERT INTO msb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kaya ginsabihan naman sinda ni Jesus, “Maglikay gayod kamo na dili maluko san sin-o man manungod sani. ");
INSERT INTO msb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Damo an magaabot na masambit san ngaran ko kag magasabi, ‘Ako an Cristo.’ Kaya damo na mga tawo an pagalukuhon ninda. ");
INSERT INTO msb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ayaw kamo pagkahandal sa mga barita na may mga gyera o mga nagasabi-sabi na may gyera na maabot. Dapat ini mangyari pero dili pa ina an katapusan san mga tanda. ");
INSERT INTO msb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Magagyerera pa man an mga nasyon, kag an mga kahadian naman magapauruataki. Sa iba-iba na mga lugar magkakaigwa sin mga linog kag didto man sa iba na mga lugar magakulang sin pagkaon kaya magkakaigwa sin gutom. Amo ini an pagtuna pa lang san kalisudan na bagaʼn primero na sakit san pag-anak. ");
INSERT INTO msb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Maglikay kamo mismo. Pagadarhon kamo san mga tawo sa inda mga konseho. Pagakastiguhon man kamo sa mga sinagoga kag pagpapaatubangon kamo sa mga gobernador kag mga hadi tungod sa akon agod magpamatuod sa atubangan ninda. ");
INSERT INTO msb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero dapat ipahayag anay an Maayo Na Barita sa tanan na nasyon. ");
INSERT INTO msb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kun dakupon kamo kag iatubang sa husgado, ayaw kahandal kun nano an iyo isasabat kundi sabihon an nano man na ginapaisip sa iyo sana mismo na panahon kay dili kamo mismo an magasurmaton kundi an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sana man na panahon may mga tawo na amo mismo an magapapatay sa inda mga kamaranghod. Amo man mga ama na igapapatay an inda mga anak. Sugad man may kabataan na magakontra sa inda mga ginikanan kag igapapatay sinda. ");
INSERT INTO msb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kamo naman pagakabadlian san tanan na katawuhan dahilan na nagasunod kamo sa akon, pero an mga masasalbar sa paghusgar san Dios amo an mga magpadayon pagsarig sa akon hasta sa katapusan sani. ");
INSERT INTO msb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sa maabot na panahon makikita an ginatawag na ‘bagay na mababadlian gayod san Dios kag magapasira man sa tawo.’ Tandai: dapat gayod na masabutan ini san nagabasa. Pakakita niyo sani na ginbutang sa dili man angay, kinahanglan idtoʼn adto sa Judea magdulag na sa kabukidan. ");
INSERT INTO msb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kun may tawo na adto sa atop san iya balay dili na siya dapat na magsulod pa sa balay para magkuha sin bisan nano niya na garamiton. ");
INSERT INTO msb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kun may tawo naman na adto na sa uma dili na gayod siya dapat mag-uli pa para magkuha san iya bado. ");
INSERT INTO msb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kun sugad kamakaluluoy man sadtoʼn mga budos kag may mga ginapadudo pag-abot sana na panahon! ");
INSERT INTO msb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mangadyi gayod na dili ini mangyari kun tighagkutan, ");
INSERT INTO msb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kay sana na panahon magkakaigwa sin grabe na pagtios na wara pa mangyari tuna san paglalang san Dios san kinab-an hasta niyan kag dili na mangyayari gihapon hasta na lang. ");
INSERT INTO msb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kun wara pagpahalip-uta san Ginoo ina na mga adlaw wara gayod sin mabibilin na buhay. Pero alang-alang sa iya mga pinili pinahalip-ot niya ina. ");
INSERT INTO msb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kun may magsabi sa iyo sana na panahon na, ‘Kitaa, adi an Cristo!’ o ‘Kitaa, adto siya!’ ayaw pagtuod sana, ");
INSERT INTO msb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","kay damoʼn maruluwas na mga magapatuud-tuod na mga Cristo kag mga propeta. Makakahimo sinda sin mga milagro kag makangangawa na mga bagay agod makaluko bisan sa mga pinili san Dios kun mahimo ninda. ");
INSERT INTO msb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ginpadaanan ta na kamo sani tanan antes pa ini mangyari kaya dapat kamo maglikay.” ");
INSERT INTO msb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nagpadayon pa si Jesus, “Pero pakatapos san kasakitan sana na mga adlaw, ‘pagapadulumon an adlaw kag mawawar-an sin pawa an bulan. ");
INSERT INTO msb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Magakahurulog an mga bituon hali sa langit kag an mga makagagahom sa kalangitan pagauy-ugon.’ ");
INSERT INTO msb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Pakatapos makikita san mga tawo na magaabot ako na Anak San Tawo sa mga dampog na may kagamhanan kag glorya. ");
INSERT INTO msb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pagasuguon ko naman an akon mga anghel sa upat na higad san kinab-an para tiripunon an akon mga pinili na mga tawo hali sa bilog na kinab-an. ");
INSERT INTO msb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Dapat kamo makaaram sin leksyon hali sa puno san kahoy na ginatawag higera. Pagsaringsing san mga sanga sani kag pag-uruslot san mga dahon naaaraman niyo na halapit na an kwaresma didi sa aton. ");
INSERT INTO msb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sugad man kun makita niyo idtoʼn mga pangyayari, maaaraman niyo na halapit na ako mag-abot, bagaʼn ada na lang gayod sa pwertahan. ");
INSERT INTO msb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ginasiguro ko sa iyo na mangyayari idtoʼn tanan antes na magkamaratay an mga tawo na nabuhay yana. ");
INSERT INTO msb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","An langit kag duta mawawara pero magapadayon hasta na lang an akon mga surmaton.” ");
INSERT INTO msb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nagpadayon si Jesus, “Niyan manungod san oras kag adlaw san akon pagbalik waraʼn iba na maaram kundi an Ama lang. Bisan ngani an mga anghel sa langit kag ako mismo na iya anak dili maaram. ");
INSERT INTO msb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaya magmaikmat kamo kag magbantay kay dili niyo aram kun san-o ini mangyayari. ");
INSERT INTO msb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pareho ini san magalakat na binilin an iya balay sa mga suruguon. Ginapatrabaho niya an kada usad sin sadiri na trabaho kag pinadaanan an bantay sa pwertahan na magbantay gayod. ");
INSERT INTO msb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kaya magbantay kamo kay dili niyo aram kun san-o an pag-abot san tag-iya san balay, kun sa gab-i, sa tungaʼn gab-i, sa pagturaok san manok o sa maaga. ");
INSERT INTO msb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kay basi umabot siya sin bigla kag maabtan kamo na turog. ");
INSERT INTO msb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kaya kun nano an ginasabi ko sa iyo ginasabi ko man sa tanan: magbantay gayod!” ");
INSERT INTO msb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mga duha pa ka adlaw antes san Paskwa kag san pyista san Tinapay Na Waraʼn Lebadura an mga pinakapuno san kapadian kag san mga paratukdo san Kasuguan nagahanap sin paagi para si Jesus patraydor na ipadakop kag ipapatay. ");
INSERT INTO msb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero sabi ninda, “Dili ini dapat na himuon sa kapyistahan kay basi magsaramok an mga tawo.” ");
INSERT INTO msb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Myintras na adto si Jesus sa Betania nagakaon sa balay ni Simon na kasadto may leproso, may sumulod na babayi na may daraʼn surudlan na himo sa alabastro na bato puno sin mahal na pahumot kay puro nardo. Pinusa niya an surudlan kag ginbu-bo an pahumot sa ulo ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pero may iba didto na nagairistoryahan na naurit, “Nano kay gintiawan ina na pahumot? ");
INSERT INTO msb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Makabaligya kuntani ina sin sobra pa na 300 na dinaryo kag an kabaklanan sana ikapanghatag sa pobre.” Kaya ginsaway ninda an babayi. ");
INSERT INTO msb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ginsabihan sinda ni Jesus, “Nano kay ginapakiaraman niyo siya? Pabayai lang niyo kay maayo an ginhimo niya sa akon. ");
INSERT INTO msb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Matuod ini kay adi pirme sa iyo an mga pobre kag nano man na oras mabubuligan niyo sinda pero ako dili pirme adi sa iyo. ");
INSERT INTO msb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hinimo san babayi an gutob san iya makakaya. Ginpahumutan niya an akon lawas bilang preparasyon sa paglubong sa akon. ");
INSERT INTO msb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Matuod gayod na ini na nahimuan sani na babayi igaistorya man bilang pagdumdom sa iya bisan diin igapahayag an Maayo Na Barita sa bilog na kinab-an.” ");
INSERT INTO msb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Myintras na adto pa si Jesus sa Betania si Judas Iscariote, usad san dose na mga disipulos, nagpakadto sa mga namumuno san kapadian. May plano siya na patraydoran si Jesus sa inda. ");
INSERT INTO msb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nalipay gayod sinda san pakabati sani kag nagtuga na hatagan siya sin kwarta. Kaya tuna sadto nagahanap si Judas sin maayo na oportunidad agod patraydoran sa inda si Jesus. ");
INSERT INTO msb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sa primero na adlaw san kapyistahan san Tinapay Na Waraʼn Lebadura, kun san-o an ugali san mga Judio na magpatay sin kordero para sa panigab-i sa adlaw san Paskwa, hinunga si Jesus san iya mga disipulos, “Diin mo gusto na ihanda namon an pagkaon sa Paskwa?” ");
INSERT INTO msb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kaya nagsugo sin duha niya na disipulos, “Kumadto kamo sa syudad. Pag-abot niyo didto may makakasugat kamo na lalaki na may daraʼn tibod san tubig. Sundon niyo siya ");
INSERT INTO msb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hasta sa sulod san balay na iya pagasuludan, kag didto sabihon sa tag-iya sani, ‘Nagapahunga an Maestro, Hain an kwarto para sa mga bisita na makaon ako san handa san Paskwa kaupod san akon mga disipulos?’ ");
INSERT INTO msb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","May itutukdo siya sa iyo na dako na kwarto saibabaw na kompleto na sin garamiton kag mahusay na. Didto kamo maghanda para sa aton.” ");
INSERT INTO msb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nagkadto sa syudad an duha na disipulos na iya ginsugo kag nakita ninda an tanan na ginsabi sa inda kaya ginpreparar an pagkaon sa Paskwa. ");
INSERT INTO msb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkagab-i nag-abot si Jesus kaupod an dose. ");
INSERT INTO msb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Myintras nagakaraon sinda sa lamesa si Jesus nagsurmaton, “Matuod an ginasabi ko sa iyo, may usad didi sa iyo na nagakaon kaupod ko na matraydor sa akon.” ");
INSERT INTO msb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Didi nagkamurundo sinda kag an kada usad naghunga kan Jesus, “Nano, Ginoo, ako ina?” ");
INSERT INTO msb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nagsabat si Jesus sa inda, “Usad siya sa iyo na dose. Amo siya idtoʼn nakisaro sa akon. ");
INSERT INTO msb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Oo, mangyayari gayod sa akon na Anak San Tawo susog sa nasurat sa Banal Na Kasuratan pero kamakaluluoy man sana na matraydor sa akon! Maayo pa lugod sana na tawo na dili na lang siya gin-anak.” ");
INSERT INTO msb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Myintras nagakaraon pa sinda nagkuha si Jesus sin tinapay, nagpasalamat sa Dios, gin-utud-utod kag ginpanghatag sa iya mga disipulos na nagasabi, “Kaon kamo. Ini an akon lawas.” ");
INSERT INTO msb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pakatapos may ginkuha naman siya na kupa kag, pakapasalamat sa Dios, hinatag sa inda, tapos nag-inom sinda tanan. ");
INSERT INTO msb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Didi naman ginsabihan niya sinda, “Ini an akon dugo na amo an pagpamatuod san sinumpaan san Dios. Pagapaawason ini para sa kadamuan. ");
INSERT INTO msb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ginasiguro ko sa iyo na dili na ako mainom gihapon sin duga san mga ubas hasta sa pag-abot san adlaw na mainom ako san bag-o na bino sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pakatapos ninda pagkanta sin salmo nagpakadto sinda sa Bukid San Kaolibohan. ");
INSERT INTO msb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Didto ginsabihan sinda ni Jesus, “Pagabayaan ako niyo tanan sugad sa nasurat, ‘Papatayon ko an nagaataman kaya magaburulag an mga karnero.’ ");
INSERT INTO msb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero pagkabuhay ko gihapon mauuna ako sa iyo sa Galilea.” ");
INSERT INTO msb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tapos nagsurmaton si Pedro, “Bisan magbaya sinda tanan ako naman dili gayod.” ");
INSERT INTO msb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ginsabihan siya ni Jesus, “Matuod gayod na yana na gab-i antes magturaok an manok sin makaduha pagapaambutan mo ako sin makatulo na beses.” ");
INSERT INTO msb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero nagpirit gihapon si Pedro na nagsurmaton, “Dili ta ikaw pagapaambutan bisan ako mamatay kaupod mo.” Amo man an ginsarabi san tanan. ");
INSERT INTO msb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pakaabot ninda sa lugar na ginatawag na Getsemani ginsabihan ni Jesus an iya mga disipulos, “Mag-ingkod kamo didi myintras makadto ako para magpangadyi.” ");
INSERT INTO msb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pakatapos gin-agda niya sinda Pedro, Santiago kag Juan na mag-upod sa iya. Pag-abot didto nakabatyag si Jesus sin dako gayod na kahandal kag pagkamundo man. ");
INSERT INTO msb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kaya ginsabihan sinda ni Jesus, “Namumundo gayod ako na bagaʼn mapapatay. Maghulat kamo didi kag magbantay.” ");
INSERT INTO msb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pag-uruunhan niya naghapa sa duta kag nagpangadyi na kun mahimo dili siya makabatyag sin pagtios sa maabot na oras. ");
INSERT INTO msb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tapos nagsabi siya, “Abba, Ama, kaya ka na mahimo san tanan. Halia man sa akon ini na kupa pero dili an akon pagbuot kundi an sa imo lugod an masunod.” ");
INSERT INTO msb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagbalik niya sa tulo na disipulos tururog na sinda. Gintawag niya si Pedro, “Simon, nano, turog ka? Dili mo ba kaya na magbantay sin usad lang ka oras? ");
INSERT INTO msb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kinahanglan kamo magbantay kag magpangadyi agod dili masugtan kay bisan makusog an pagbuot an lawas maluya.” ");
INSERT INTO msb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nagbalik gihapon si Jesus kag nagpangadyi na pareho an iya ginapangamuyo. ");
INSERT INTO msb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagbalik niya sa tulo, amo man gihapon naabtan niya na tururog kay ginadaog gayod sinda san kapirawon. Dili ninda aram kun nano an isabat sa iya. ");
INSERT INTO msb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","San ikatulo na na pagbalik ni Jesus sinabihan niya sinda, “Nano, nagatururog kamo hasta na lang kag nagapahuruway? Tama na ina! Nag-abot na an oras! Kitaa, kay ako na Anak San Tawo igaintriga sa mga parakasala. ");
INSERT INTO msb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangon na kamo! Kitaa! Ada na an matraydor sa akon, kaya hamos na kita.” ");
INSERT INTO msb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nagasurmaton pa si Jesus san mag-abot si Judas, usad san dose. May mga kaurupod na armado sin mga talibong kag mga balbag. Sinugo sinda san mga namumuno san kapadian, mga paratukdo san mga Kasuguan kag mga kagurangan na mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Niyan nagkasarabot na sinda na si Judas mahatag sin tanda, “An haharukan ko amo ina siya. Kaya dakupa niyo kag siguruha na mabantayan sin maayo sa iyo paglakat.” ");
INSERT INTO msb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kaya san pag-abot ni Judas nagdiretso pagtulos kan Jesus kag nagsabi, “Rabi!” Pakatapos ginharukan siya. ");
INSERT INTO msb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gindakop dayon kag ginpugulan nindaʼn maayo si Jesus. ");
INSERT INTO msb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero usad san mga nagamiron an nagbugnot san iya ispada, gintigbas an suruguon san pinakapuno na padi kag nautas an talinga sani. ");
INSERT INTO msb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tapos nagsurmaton si Jesus, “Nano, tulisan an paghuna niyo sa akon kay nagdarara pa kamo san mga talibong kag mga balbag para lang dakupon ako? ");
INSERT INTO msb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ada ako pirme sa iyo uruadlaw na nagatukdo sa templo kag wara man niyo pagdakupa. Pero ini nangyari agod matuman an Banal Na Kasuratan.” ");
INSERT INTO msb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tapos ginbayaan dayon siya san mga disipulos kag nagdurulag. ");
INSERT INTO msb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","May nagsunod sa iya na batan-on na lalaki na nakatapis sin manipis na tela. ");
INSERT INTO msb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Gindakop siya ninda pero ini na tawo nakadaplos kaya nabilin an iya tapis kag nagdalagan na huba. ");
INSERT INTO msb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pag-abot ninda sa Jerusalem ginguyod man si Jesus sa pinakapuno na padi. Tapos naman nagtiripon didto an tanan na mga puno san kapadian, an mga namumuno san mga Judio kag an mga paratukdo san Kasuguan. ");
INSERT INTO msb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro naman nagsunod kanda Jesus pero sa huruharayo. Nagdiretso siya hasta sa natad san palasyo san pinakapuno na padi. Didto nag-ingkod siya katakin san mga bantay sa may kalayo kag nagpainit man. ");
INSERT INTO msb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Niyan an mga puno san kapadian kag san bilog na konseho naghanap sin ibidinsya kontra kan Jesus agod mahusgaran siya sin kamatayon pero wara sindaʼn nakuha. ");
INSERT INTO msb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bisan damo didto an naghimuwa sa iya an inda pagtestigo dili nagkaparareho. ");
INSERT INTO msb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sa katapus-tapusi may pira na nagtindog kag nagbuwa sugad sani, ");
INSERT INTO msb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nabatian namon siya na nagsabi, ‘Rurubaon ko ini na templo na himo san tawo kag sa sulod sin tulo ka adlaw matindog ako sin bag-o na dili himo san tawo.’,” ");
INSERT INTO msb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero dili man gihapon nagakaparareho an mga testigo kontra sa iya. ");
INSERT INTO msb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Didi nagtindog an pinakapuno na padi kag naghunga kan Jesus, “Wara ka ba sin ikakasabat sana? Nano an masasabi mo sa mga ginsabi ninda kontra sa imo?” ");
INSERT INTO msb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero wara siya magribok. Ginhunga gihapon siya san pinakapuno na padi, “Nano, ikaw an Cristo na amo an anak san pinakapaladan?” ");
INSERT INTO msb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nagsabat si Jesus, “Ako ina kag makikita niyo ako na Anak San Tawo na nakaingkod sa tuo san Pinakamakagagahom. Tapos pagbalik ko naman didi sa kinab-an makikita niyo ako na nakatungtong sa mga dampog sa langit.” ");
INSERT INTO msb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Didi ginisi san pinakapuno na padi an sadiri niya na bado kay sa huna-huna niya pagbasang-basang sa Dios an ginsabat ni Jesus. Tapos naghunga, “Nano kay kinahanglan pa naton an mga testigos? ");
INSERT INTO msb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nabati niyo an iya pagbasang-basang sa Dios. Nano sa paghuna niyo?” An tanan nagkaurusad na siya dapat ipapatay. ");
INSERT INTO msb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tapos may iba sa inda na nagtuna pagluda sa iya. Gintahuban man ninda an iya mga mata tapos ginparasuntok. Ginsiyakan pa siya na nagasabi, “Tugmaha daw, propeta!” Pero san wara siya magsabat ginkuha siya san mga bantay kag ginparasuntok pa. ");
INSERT INTO msb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Myintras si Pedro adto sa natad san palasyo may nag-abot na babayi na suruguon san pinakapuno na padi. ");
INSERT INTO msb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkita niya kan Pedro na nagapainit didto tinurok niya kag ginsabihan, “Ikaw kaupod man ni Jesus na taga-Nazaret.” ");
INSERT INTO msb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero nagpaambot siya na nagasabi, “Dili ko aram. Dili ko nasasabutan kun nano an gusto mo sabihon.” Pakatapos nagluwas si Pedro sa pwertahan. ");
INSERT INTO msb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Didto nakita gihapon siya san suruguon na babayi kag nagsabi ini sa mga nagairistambay didto, “Usad man ini sa inda.” ");
INSERT INTO msb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero nagpaambot gihapon si Pedro. Taud-taod an mga adto didto na halapit sa iya nagsabi, “Matuod na usad ka man sa inda kay taga-Galilea ka.” ");
INSERT INTO msb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Didi nagtuna siya pagsabi na maldisyunon lugod siya san Dios tapos nagsumpa, “Dili ko kilala ina na tawo na ginasabi niyo.” ");
INSERT INTO msb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sani mismo na oras nagturaok an manok sa ikaduha na beses. Tapos nadumduman dayon ni Pedro an ginsabi ni Jesus sa iya na, “Antes magturaok an manok sin makaduha pagapaambutan mo ako sin tulo na beses.” Didi nagparabakho gayod siya. ");
INSERT INTO msb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagkaaga antes magbitlak an adlaw nagtiriripon an pinakapuno na padi kaupod an mga namumuno san mga Judio, mga paratukdo san Kasuguan kag an bilog na Konseho. Nag-urusad sinda kun nano an himuon. Kaya ginpagapos ninda si Jesus, ginpadara kan Pilato kag inintriga sa iya. ");
INSERT INTO msb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ginhunga siya ni Pilato, “Nano, ikaw an hadi san mga Judio?” “Ikaw an nagsabi sana,” an sabat ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Damo an ginsang-at na akusasyon san pinakapuno san kapadian kontra kan Jesus. ");
INSERT INTO msb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ginhunga gihapon siya ni Pilato, “Wara ka baʼn ikasabat? Kitaa kun sing-ano kadamo an akusasyon ninda kontra sa imo!” ");
INSERT INTO msb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero wara gihapon magsabat si Jesus kaya nagngalas si Pilato. ");
INSERT INTO msb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Niyan kada kapyistahan ugali na ni Pilato an pagpaluwas sin priso na aayuon san mga tawo. ");
INSERT INTO msb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sadto na panahon may priso na ginatawag Barabas. Kaupod siya san mga rebelde na nakapatay kasadto san magkaigwa sin kasamok. ");
INSERT INTO msb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nag-arapiki an kadamuan kan Pilato kag nagtuna paghangyo sa iya na himuon an nakaugalian na niya na pagpaluwas sin usad na priso. ");
INSERT INTO msb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ginhunga sinda ni Pilato, “Nano, gusto niyo na paluwason ko an hadi san mga Judio?” ");
INSERT INTO msb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nabatyagan ni Pilato na si Jesus gin-akusar dahilan sa pagkaawa san mga pinakapuno san kapadian. ");
INSERT INTO msb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero an mga tawo ginsulsulan san mga pinakapuno san kapadian na an paluwason lugod si Barabas. ");
INSERT INTO msb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nagsurmaton gihapon si Pilato, “Kun sugad, nano an hihimuon ko sani na tawo na ginatawag niyo na hadi san mga Judio?” ");
INSERT INTO msb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nagsiriyak sindaʼn, “Ipako siya sa krus!” ");
INSERT INTO msb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ginhunga sinda ni Pilato, “Kay nano? Nano an karautan na nahimo niya?” Pero mas lalo lugod na nagsiriyak sindaʼn makusog na nagasabiʼn, “Ipako siya sa krus!” ");
INSERT INTO msb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kaya, agod mapalipay ni Pilato an mga tawo, pinalibre niya si Barabas. Tapos, pakapalatigo niya kan Jesus, gin-intriga siya sa inda para ipako sa krus. ");
INSERT INTO msb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ginguyod si Jesus san mga suldados sa pretoryo na amo an pinakasulod san palasyo tapos pinatawag an tanan na suldados. ");
INSERT INTO msb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ginsul-utan ninda siya sin lila na kapa, ginhimuan sin korona na tunok kag ginkoronahan siya. ");
INSERT INTO msb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pakatapos patuya na ginasaluduhan siya, “Mabuhay an Hadi san mga Judio!” ");
INSERT INTO msb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ginparapalo siya sa ulo, gintuprahan kag nagaruluhod-luhod man sinda na bagaʼn nagagalang sa iya. ");
INSERT INTO msb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pakatapos san inda pagtuya-tuya kan Jesus ginhubaan siya san lila na kapa kag ginsul-utan gihapon san sadiri niya na bado. Tapos ginluwas siya para ipako sa krus. ");
INSERT INTO msb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Niyan may umaragi na si Simon na taga-Cirene na nagasulod sa Jerusalem hali sa uma. Siya an ama ninda Alejandro kag Rufo. Ginpirit siya san mga suldados na magpas-an san krus ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ginguyod ninda si Jesus sa lugar na ginatawag Golgota na an gusto sabihon lugar na ginatawag bungo. ");
INSERT INTO msb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tapos ginhatagan ninda si Jesus sin bino na may sakot na bulong na ginatawag mira pero wara niya ini pag-inuma. ");
INSERT INTO msb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Didto ginpako siya ninda sa krus kag ini ginpatindog. Ginbarahin man ninda an iya mga sul-ot paagi sa pagparipahan agod aram ninda kun arin an bahin san kada usad. ");
INSERT INTO msb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebe san aga san ginpako ninda si Jesus sa krus. ");
INSERT INTO msb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Didto man may nakasurat na akusasyon kontra sa iya sugad sani, “AMO INI AN HADI SAN MGA JUDIO.” ");
INSERT INTO msb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kadungan niya an duha na tulisan na ginpako ninda sa magluyo niya. ");
INSERT INTO msb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kaya an nasurat sa Banal Na Kasuratan natuman na, “Ginhusgaran siya kaupod san mga makasasala.” ");
INSERT INTO msb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gintuya-tuya man siya san mga nagaaragi na ginatangu-tango an inda ulo na nagasarabi, “Aba, ikaw na magruba san templo kag mapatindog man lang gihapon sana sa sulod san tulo ka adlaw, ");
INSERT INTO msb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","maglusad ka sa krus kag isalbar an imo sadiri!” ");
INSERT INTO msb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pareho man gintuya-tuya siya san mga pinakapuno san kapadian kag mga paratukdo san Kasuguan na nagasarabi, “Nasalbar niya an iba pero dili niya masalbar an iya sadiri! ");
INSERT INTO msb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Makikita na naton kun makalusad man gayod sa krus an Cristo na Hadi san Israel. Kun mahimo niya ini matuod kita sa iya.” Bisan ngani an duha na nakapako na kadungan niya nagtuya-tuya man sa iya. ");
INSERT INTO msb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mga alas dose an udto san magdulom an bilog na nasyon hasta na mga alas tres an hapon. ");
INSERT INTO msb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","San maalas tres naman an hapon nagsiyak si Jesus sa makusog na boses, “Eloi, Eloi, lama sabachtani?” na an gusto sabihon, “Dios ko, Dios ko, nano kay ginpabayaan mo ako?” ");
INSERT INTO msb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","San mabatian ini san mga miron didto nagsarabi sinda, “Pamatii, ginatawag niya si Elias.” ");
INSERT INTO msb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","May nagdalagan kag ginbasa an ispungha sin suka, ginbutang sa punta san bagakay kag gintunol kan Jesus para ipasupsop sa iya na nagasabi, “Hulaton ta kag kitaon kun maabot man gayod si Elias agod ilusad siya sa krus.” ");
INSERT INTO msb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero nagsiyak si Jesus sin makusog, tapos nautsan. ");
INSERT INTO msb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sani mismo na oras an kurtina sa templo nagisi sa tunga tuna sa ibabaw paubos. ");
INSERT INTO msb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Didto sa may atubangan ni Jesus nagatindog an namumuno san mga suldados. Pagkabati niya san siyak ni Jesus kag nakita kun pan-o siya napatay nagsabi siya, “Matuod man gayod na ini na tawo anak san Dios!” ");
INSERT INTO msb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","May mga babayi man na nagamarasid sa may huruharayo. Sinda Maria Magdalena, Salome kag Maria na iloy san magmanghod na sinda Santiago kag Jose. ");
INSERT INTO msb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","San adto pa si Jesus sa Galilea ini na mga babayi nag-upod kag nagaasikaso sa iya. May iba pa na mga babayi na adto didto na nag-urupod sa iya pa-Jerusalem. ");
INSERT INTO msb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Napatay si Jesus san adlaw san Pagpreparar na gusto sabihon bisperas san Adlaw San Pagpahuway. Pagkagab-i sana na adlaw nag-abot si Jose na taga-Arimatea. Usad man siya na kilala na myimbro san Konseho. Nabubuhay gayod siya sa paglaom na makita an kahadian san Dios. Pag-abot niya makusog an buot na nagkadto kan Pilato para ayuon an lawas ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nangawa si Pilato na patay na gali si Jesus kaya ginpatawag niya an kapitan san mga suldados kay iya ginhunga kun matuod gayod na patay na ini. ");
INSERT INTO msb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","San mapamatuudan san kapitan san mga suldados na patay na man gayod si Jesus gintugutan ni Pilato si Jose na kuhaon an lawas. ");
INSERT INTO msb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tapos nagbakal si Jose sin tela, ginlusad an lawas sa krus kag ginputos sadtoʼn tela. May lubungan si Jose na ginkutkot sa bato kaya didto niya ginlubong si Jesus. Pakatapos ginpaligidan sin bato para sirahan an pwertahan san ginlubungan. ");
INSERT INTO msb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nagamarasid sa iya ginahimo sinda Maria Magdalena kag Maria na iloy ni Jose kag gintandaan ninda kun diin ginlubong si Jesus. ");
INSERT INTO msb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pagliwas san Adlaw San Pagpahuway sinda Maria Magdalena, Salome kag Maria na iloy ni Santiago nagbakal sin mga pahumot na ilalahid sa lawas ni Jesus. ");
INSERT INTO msb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Maaga pa gayod sa primero na adlaw san semana nagkadto sinda sa lubungan pagbitlak pa lang san adlaw. ");
INSERT INTO msb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nagapahurunga-hunga sinda, “Sin-o daw an makapaligid para sa aton san bato sa may pwertahan san lubungan?” ");
INSERT INTO msb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pag-abot sa may lubungan nakita ninda na an daku-dako na bato napaligid na kag abyirto na an pwertahan. ");
INSERT INTO msb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pagsulod ninda sa lubungan may nakita sinda na batan-on na lalaki na nagaingkod sa banda tuo. Nakabado siya sin puti kaya nagkangarawa sinda. ");
INSERT INTO msb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nagsabi siya sa inda, “Dili kamo magngalas. Ginahanap niyo si Jesus na taga-Nazaret na ginpako sa krus. Nabuhay siya gihapon kaya wara na siya didi. Kitaa, amo ini an ginlubungan sa iya. ");
INSERT INTO msb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pero kadto na kamo, sumati an iya mga disipulos kag ni Pedro na nauuna na si Jesus sa inda sa Galilea. Makikita ninda siya didto sugad san ginsabi niya.” ");
INSERT INTO msb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nagluwas an mga babayi sa lubungan na nagadalagan kay nagkurudog sinda kag nagkangarawa. Kaya wara sinda sin ginsumatan bisan sin-o man dahilan na nagkaharadlok sinda. ");
INSERT INTO msb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aga pa san primero na adlaw san semana pagkabuhay gihapon ni Jesus nagpakita anay siya primero kan Maria Magdalena na kasadto ginpahalian niya sin pito na demonyo. ");
INSERT INTO msb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tapos nagkadto si Maria kag ginsumatan an dati na kaurupod ni Jesus na nagamurundo kag nagabarakho. ");
INSERT INTO msb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero wara sinda magtuod sa ginsabi niya na buhay si Jesus kag nakita niya. ");
INSERT INTO msb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pakatapos sani nagpakita gihapon si Jesus sa duha na nagalakat paluwas san lungsod na iba na man an iya hitsura. ");
INSERT INTO msb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nagbalik dayon an duha kag ginpamarita sa iba pero wara ninda pagtuudi sinda. ");
INSERT INTO msb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pakatapos sani nagpakita si Jesus sa onse mismo myintras sinda nagakaraon sa lamesa. Gin-uritan niya sinda dahilan san inda pagduha-duha kag katig-ahan san inda mga tagipusuon kay habo magtuod sa mga nakakita na nabuhay gihapon siya. ");
INSERT INTO msb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ginsabi pa ni Jesus sa inda, “Lakat kamo sa bilog na kinab-an kag didto ipahayag an Maayo Na Barita sa tanan na katawuhan. ");
INSERT INTO msb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","An mga magtuod kag magpabunyag masasalbar pero pagakondinaron an mga dili magatuod. ");
INSERT INTO msb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ini na mga tanda magaupod sadtoʼn may pagtuod: sa ngaran ko makapahali sinda sin mga demonyo kag magasurmaton sindaʼn bag-o na panurmaton. ");
INSERT INTO msb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kun makakapot sindaʼn mga sawa kag kun makainom sin hilo dili sinda maaano. Magaayo an mga masakiton na madapatan san inda kamot!” ");
INSERT INTO msb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pakasurmaton sani ni Ginooʼn Jesus sa inda ginpahitaas siya palangit kag nag-ingkod sa tuo san Dios. ");
INSERT INTO msb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pagkatapos sani nagralakat sinda kag nagpahayag san Maayo Na Barita sa tanan na lugar na inda naabutan tapos ginbuligan man sinda san Ginoo na ginpamatuudan an inda ginapahayag paagi sa mga tanda na nag-upod sani.");
INSERT INTO msb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ginagalangan na Teofilo, damo na an nagtalinguha pagtipon sin mga istorya manungod san mga nangyari na didi. ");
INSERT INTO msb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","An inda gintipon amo an ginpaaram na sa amon sadtoʼn sa katuna-tunai pa mga testigos kag mga paratukdo san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kaya pakatapos na masusi ko gayod tuna sa tuna hasta sa katapusan an tanan na pangyari nagtalinguha ako na isurat sa imo an pasurunod sani ");
INSERT INTO msb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","agod maaraman mo an kamatuudan manungod san tanan na gintukdo sa imo. ");
INSERT INTO msb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Amo ini an nangyari. San si Herodes pa an hadi san Judea igwaʼn padi sa grupo ni Abias na an ngaran Zacarias. An asawa niya si Elisabet hali sa lahi ni Aaron. ");
INSERT INTO msb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pareho sinda mga matanos sa mata san Dios kay ginasunod gayod ninda sin maayo an tanan na mga kasuguan kag mga katukduan san Ginoo. ");
INSERT INTO msb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kaya lang wara sinda sin anak kay baog si Elisabet kag sinda pareho na gurang. ");
INSERT INTO msb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Usad sin adlaw, nagasirbe an grupo ni Zacarias sa templo san Dios bilang padi. ");
INSERT INTO msb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Susog san nakaugalian san mga kapadian, napili si Zacarias paagi sa pagripa na magsulod sa templo san Ginoo agod magsamba didto paagi san pagsunog sin pahumot na insenso. ");
INSERT INTO msb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sa luwas naman an tanan na katawuhan nagapangadyi myintras ginasunog an insenso. ");
INSERT INTO msb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Didto sa sulod may nakita si Zacarias na anghel san Ginoo na nakatindog sa banda tuo san altar na ginasunugan san insenso. ");
INSERT INTO msb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nangarat siya kag nakabatyag sin kahadlok. ");
INSERT INTO msb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero nagsabi an anghel sa iya, “Zacarias, ayaw kahadlok kay ginpamatian na san Dios an imo pangadyi. Kaya magkakaanak kamo ni Elisabet sin lalaki kag siya pagangaranan niyoʼn Juan. ");
INSERT INTO msb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Igakalipay mo gayod siya kag amo man san kadamuan pagkaanak sa iya. ");
INSERT INTO msb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Magigin labaw siya sa mata san Ginoo kag dili gayod siya magainom sin bino o makahubog na irimnon. Bisan adto pa siya sa tiyan san iya iloy ada na sa iya an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Damo na mga taga-Israel an pagapabalikon niya sa Ginoo na inda Dios. ");
INSERT INTO msb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Magauna siya sa Ginooʼn Jesus pareho sa espirito kag poder ni Elias na propeta san Dios kasadto para papalanggaon gihapon an mga ama sa inda mga anak kag an mga sutil na mapabalik sa kadunungan pareho san mga matanos agod mapreparar an mga tawo na magin angay sa Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ginhunga ni Zacarias an anghel, “Pan-o ako makasiguro sani? Gurang na ako kag amo man an akon asawa.” ");
INSERT INTO msb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nagsabat an anghel, “Ako si Gabriel na suruguon sa atubangan san Dios kag sinugo niya ako agod ipaabot sa imo ini na mga maayo na barita. ");
INSERT INTO msb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tandai ini! Magigin apa ka kag dili ka makasurmaton hasta na dili ini mangyari tungod na dili ka nagatuod san mga ginapangsabi ko sa imo na matuod man gayod na mangyayari sa tama na panahon.” ");
INSERT INTO msb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Myintras an mga tawo sa luwas na nagahulat kan Zacarias nagngaralas kun nano kay nadugay siya sa sulod. ");
INSERT INTO msb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","San pagluwas niya wara na siya makasurmaton sa inda kag nagapasabot na lang sa inda paagi san kamot kay apa na siya. Kaya napanginanuhan ninda na si Zacarias nakakita sin pangitaon didto. ");
INSERT INTO msb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","San matapos na an panahon san iya pagtrabaho bilang padi nag-uli na siya. ");
INSERT INTO msb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wara madugay an iya asawa na si Elisabet nagbudos kag sa sulod san lima ka bulan nagkulong siya sa inda balay. ");
INSERT INTO msb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ginsabi niya, “Himo ini san Ginoo sa akon kay sa iya kagustuhan hinali an kaaluhan na akon gintios sa mga tawo.” ");
INSERT INTO msb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","San ikaunom ka bulan san pagbudos ni Elisabet sinugo san Dios an anghel na si Gabriel pakadto sa Nazaret na usad na lungsod sa Galilea. ");
INSERT INTO msb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nagpakadto siya kan Maria na usad na birhen na ginapangasawa ni Jose hali sa lahi san dati na hadi na si David. ");
INSERT INTO msb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pag-abot san anghel sa balay sani nagsabi siya, “Maglipay ka. Ikaw an pinalabi san Dios kag ada sa imo an Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kinulbaan gayod si Maria san ginapanurmaton sa iya kag gin-isip-isip kun nano an gusto sabihon sani. ");
INSERT INTO msb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pero ginsabihan siya san anghel, “Ayaw kahadlok, Maria, kay pinalabi ka sa mata san Dios. ");
INSERT INTO msb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tandai! Magabudos kag magaanak kaʼn lalaki kag pagangaranan mo siyaʼn Jesus. ");
INSERT INTO msb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Palabawon siya kag pagatawagon na Anak san Pinakalabaw na Dios. Pareho san iya kalulululuhan na si David pagapahadion siya san Ginooʼn Dios. ");
INSERT INTO msb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Didto magahadi siya san lahi ni Jacob hasta na lang kag an iya kahadian waraʼn katapusan.” ");
INSERT INTO msb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Niyan, ginhunga ni Maria an anghel, “Pero pan-o ini mangyari na adi wara akoʼn asawa?” ");
INSERT INTO msb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ginsabat siya san anghel, “Mapakada sa imo an Espirito Santo kag pagapabuduson ka san gahom san Pinakalabaw na Dios. Kaya an imo iaanak magin banal kag pagatawagon na Anak san Dios. ");
INSERT INTO msb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kitaa, bisan ngani an imo primahon na si Elisabet apisar san iya kagurangon nagbudos. Siya na ginatawag san mga tawo na baog yana ikaunom na ka bulan an iya pagbudos, ");
INSERT INTO msb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kay waraʼn imposible sa Dios.” ");
INSERT INTO msb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kaya nagsabat si Maria, “Suruguon ako san Ginoo. Mangyari lugod ini sa akon na ginsabi mo.” Tapos ginbayaan na siya san anghel. ");
INSERT INTO msb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pakalipas sin pira ka adlaw nag-apura si Maria pakadto sa usad na lungsod sa kabukidan san Judea, ");
INSERT INTO msb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","kag pagsulod sa balay ni Zacarias ginkumusta si Elisabet. ");
INSERT INTO msb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pakabati lang ni Elisabet san pangumusta ni Maria ada na sa iya an gahom san Espirito Santo kag insigida an bata sa iya tiyan naghiwag. ");
INSERT INTO msb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tapos nagsurmaton si Elisabet sin makusog, “Pinalabi ka sa tanan na mga babayi kag pinalabi man an bata na ada sa imo tiyan. ");
INSERT INTO msb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Malipay gayod ako na ginabisita san iloy san akon Ginoo ");
INSERT INTO msb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","kay pakabati ko lang san imo pangumusta an bata sa akon tiyan naghiwag sa dako na kalipay. ");
INSERT INTO msb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Oo, malipay ka na nagtuod na matutuman an gintuga sa imo san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Didi nagsabi si Maria, “O kalag ko, umawon mo an Ginoo. ");
INSERT INTO msb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nalilipay gayod ako dahilan sa Dios na akon Parasalbar, ");
INSERT INTO msb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kay napanginanuhan niya ako na mapainubuson niya na suruguon! Tuna niyan pagasabihon san tanan na katawuhan na palabi ako, ");
INSERT INTO msb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kay siya na makagagahom na Dios ginhimuan ako sin maayo na mga gawi. Banal an iya ngaran. ");
INSERT INTO msb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tuna pa kasadto hasta yana ginakaluuyan niya an bisan sin-o na may paggalang sa iya. ");
INSERT INTO msb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ginpakita niya an kusog san iya butkon kag binurulag an mga nagaisip na labaw sinda. ");
INSERT INTO msb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","May mga makagagahom na hadi na ginpalusad niya sa inda mga ingkudan pero an mga mapainubuson ginpahitaas niya. ");
INSERT INTO msb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ginpabuganaan niya an mga nagugutom pero an mga mayaman ginpahali sin waraʼn dara. ");
INSERT INTO msb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ginbuligan niya si Israel na iya suruguon kay nadumduman niya na maluoy kan Abraham kag san iya mga kaapu-apuhan hasta na lang. Kaya natuman niya an iya gintuga sa aton mga kalulululuhan.” ");
INSERT INTO msb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nagdayon si Maria kanda Elisabet sin matulo ka bulan, pakatapos nag-uli na. ");
INSERT INTO msb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nag-abot an panahon na magaanak si Elisabet kag nag-anak siya sin lalaki. ");
INSERT INTO msb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","San mabatian san iya mga katarakin kag mga kaigmanghudan ini na dako na kaluoy na ginpakita sa iya san Ginoo, nakiusad sinda sa iya kalipay. ");
INSERT INTO msb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pag-ikawalo ka adlaw nagtiripon sinda agod ipaturi an bata. Didi ginaisip ninda na siya pagangaranan sin Zacarias na pareho san sa iya ama. ");
INSERT INTO msb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero nagsurmaton an iya iloy, “Dili! Pagangaranan siyaʼn Juan.” ");
INSERT INTO msb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ginsabihan ninda si Elisabet, “Aba! Wara man gali sin usad sa iyo pamilya an may ngaran na sugad sana.” ");
INSERT INTO msb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tapos, ginpasabot ninda an ama kun nano an gusto niya na ngaran sa bata. ");
INSERT INTO msb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagpasabot sin masuratan an ama kag may ginsurat, “An ipangaran sa iya Juan.” Nangawa sinda tanan. ");
INSERT INTO msb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sadto dayon nakasurmaton si Zacarias kag nag-umaw sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nagkangarawa an tanan ninda na katarakin kag ini na pangyari gin-iristoryahan sa bilog na kabukidan san Judea. ");
INSERT INTO msb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","An tanan naman na nakabati ginsahuna-huna na lang idtoʼn tanan, “Nano daw an maaabtan sani na bata?” Ginsabi ninda ini kay naaraman ninda na an pagpalabi san Ginoo ada sa iya. ");
INSERT INTO msb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Niyan, ada na kan Zacarias na iya ama an gahom san Espirito Santo kaya nagsabi, ");
INSERT INTO msb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Umawon an Ginoo na Dios san Israel kay nagpakadi siya kag ginlibre an iya mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nagpadara siya sa aton sin makagagahom na Parasalbar hali sa lahi san iya suruguon na si David. ");
INSERT INTO msb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ini ginpahayag san Dios paagi sa iya mga banal na propeta kasadto na mga panahon ");
INSERT INTO msb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","na isalbar kita niya sa aton mga kaaway kag sa tanan na nababadli sa aton. ");
INSERT INTO msb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ginkaluuyan niya an aton mga kalulululuhan sugad san gintuga kag nadumduman an iya banal na ginsumpaan. ");
INSERT INTO msb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ini an gintuga kan Abraham na usad sani ");
INSERT INTO msb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","na pagasalbaron kita sa aton mga kaaway agod wara kitaʼn kahadlok na makasirbe ");
INSERT INTO msb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","sa kabanalan kag katanusan sa atubangan san Dios sa tanan na adlaw san aton pagkabuhay.” ");
INSERT INTO msb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Paglingi niya sa bata nagsabi siya, “Anak ko, pagatawagon ka na propeta san Dios na Pinakalabaw sa tanan. Mauuna ka sa Ginoo agod ipreparar an aagihan niya ");
INSERT INTO msb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kag ipaaram sa iya mga tawo na masasalbar sinda paagi sa pagpatawad san inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ini na pagpatawad paagi sa dako na kaluoy san aton Dios. An pagsalbar niya pareho san pagsirak sa aton san adlaw ");
INSERT INTO msb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para mapawaan idtoʼn nabubuhay sa kadulman san kasal-an kag nasa anino san kamatayon. Magpakita man ina sa aton san paagi na mabuhay sa kalinaw.” ");
INSERT INTO msb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pakatapos sani nagdako an bata kag an iya espirito nagkusog sa pagsunod sa Dios. Didto siya nagaistar sa disyerto hasta sa adlaw na siya nagtuna pagtukdo sa mga taga-Israel. ");
INSERT INTO msb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sadtoʼn panahon may sugo hali kan Cesar Augusto na magpalista an katawuhan na sakop san Roma. ");
INSERT INTO msb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini an primero na pagpalista san katawuhan na ginhimo san si Kirenio amo pa an gobernador sa Siria. ");
INSERT INTO msb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaya an kada usad nag-uli sa lungsod san inda kalulululuhan agod magpalista. ");
INSERT INTO msb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Niyan, may tawo na an ngaran si Jose na naghali sa iya lungsod san Nazaret sa Galilea kag nagpakadto sa lungsod san dati na hadi na si David. Ini na lungsod ginatawag na Betlehem sa Judea. Nagkadto siya agod magpalista dahilan na siya kalahi ni David. ");
INSERT INTO msb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","An kaupod niya amo si Maria na iya magigin asawa na sadto na kaurason tikaanakon. ");
INSERT INTO msb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Myintras na adto sinda nag-abot an oras san iya pag-anak. ");
INSERT INTO msb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Didi gin-anak niya an iya subang na lalaki kag ginputos sa pambata na gamit, pakatapos ginhulid sa balalong kay wara na gayod sin bakante para sa inda sa istaran para sa mga dayunan. ");
INSERT INTO msb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Halapit didto igwaʼn mga pastor sa kabukidan na pagkagab-i ginabantayan an inda mga karnero. ");
INSERT INTO msb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Niyan, may nagpakita sa inda na anghel san Ginoo kag an kapawa san glorya san Ginoo nagpawa sa inda. Kaya nagkaharadlok gayod sinda. ");
INSERT INTO msb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ginsabihan sinda san anghel, “Ayaw kamo kahadlok! Pamati, may maayo ako na barita para sa iyo na makapalipay gayod sa tanan na katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Niyan pa lang sa Betlehem na lungsod ni David, may Parasalbar na gin-anak para sa iyo. Siya si Cristo na amo an Ginoo. ");
INSERT INTO msb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Adi an tanda para sa iyo: makikita niyo an bata na napuputos sa pambata na gamit kag nakahulid sa balalong.” ");
INSERT INTO msb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Insigida kaupod na san anghel, an damo pa gayod ka manada na anghel hali sa langit na nagaumaw sa Dios kag nagakaranta, ");
INSERT INTO msb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Umawon an Dios sa pinakahitaas na langit, kay nagahatag siya sin katrangkiluhan sa mga tawo na iya ginakalipay sa duta.” ");
INSERT INTO msb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Paghali sa inda san mga anghel na pabalik sa langit, nag-iristoryahan an mga pastor, “Hamos kita sa Betlehem kag kitaon ta ini na mga pangyayari na ginpaaram sa aton san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kaya nag-apura sinda pagkadto kag pag-abot nakita ninda si Maria, si Jose kag an nakahulid na bata sa balalong. ");
INSERT INTO msb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pakakita ninda sa bata ginpanumat ninda an ginsabi sa inda manungod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nagkangarawa an tanan na nakabati san ginpangistorya san mga pastor. ");
INSERT INTO msb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ini tanan na mga surmaton ginpasabuot na lang ni Maria pero ginparaisip-isip. ");
INSERT INTO msb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pakatapos nag-uli an mga pastor na ginapasalamatan kag ginaumaw an Dios tungod san tanan na inda naaraman kag nakita sugad gayod san ginsabi sa inda. ");
INSERT INTO msb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pag-ikawalo ka adlaw kag panahon na san pagpaturi san bata, ginngaranan siyaʼn Jesus na amo an ngaran na ginsabi san anghel antes siya ginbudos. ");
INSERT INTO msb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pagkaadlaw naman san seremonyas san paglinis sa mag-iloy susog sa Kasuguan ni Moises gindara ninda si Jesus pa-Jerusalem. Didto sa templo ginhalad siya ninda sa Ginoo para magin iya suruguon ");
INSERT INTO msb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","susog sa sugo san Ginoo na “an tanan na subang na lalaki ihalad sa Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Amo man bilang sakripisyo susog sa Kasuguan san Ginoo maghalad sin “usad na padis na salampati o dili kaya duha na piso na balod.” ");
INSERT INTO msb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Niyan, didto sa Jerusalem igwaʼn lalaki na an ngaran Simeon. Matanos siya kag diosnon na tawo. Nagalaom siya san pagkasalbar san katawuhan san Israel kag an Espirito Santo ada sa iya. ");
INSERT INTO msb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ginpaaram siya san Espirito Santo na dili siya mamamatay hasta na dili niya makita an Mesias na gintuga san Ginoo. ");
INSERT INTO msb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Niyan, sa paggiya san Espirito nagpakadto siya sa templo kag san gindara na san ginikanan an bata na si Jesus didto agod masunod an nasabi sa Kasuguan, ");
INSERT INTO msb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ginkugos ni Simeon an bata kag gin-umaw an Dios, ");
INSERT INTO msb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yana, O Ginoo, pwede mo na bawian sin buhay an imo suruguon. May katrangkiluhan na ako kay gintuman mo na an imo gintuga sa akon ");
INSERT INTO msb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","tungod na nakita ko na an Parasalbar ");
INSERT INTO msb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na imo ginpreparar na makita san tanan na nasyon. ");
INSERT INTO msb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Siya an ilaw na magagiya sa mga dili-Judio sa kamatuudan kag maghatag sin galang sa imo mga taga-Israel.” ");
INSERT INTO msb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kaya nagngalas an ginikanan san bata sa mga ginsabi manungod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tapos ginbendisyunan sinda ni Simeon kag ginsabihan si Maria an iloy, “Tandai, ini na bata amo an ginpili san Dios para sa kapeligrohan san iba kag pagkasalbar man san iba sa Israel. Usad siya na tanda hali sa Dios na igasikway san kadamuan. ");
INSERT INTO msb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kaya an maraot ninda na kaisipan maaaraman. Sa parte mo naman an pagtios bagaʼn matarom na ispada na matusok sa imo sadiri na puso.” ");
INSERT INTO msb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Didto igwa man sin propeta na babayi na an ngaran niya si Ana. Anak siya ni Fanuel na hali sa lahi ni Aser kag gurang na siya. Pito ka tuig an iya pag-asawa antes siya nabiyuda pero 84 na niyan an iya edad. Dili na gayod siya nagahali sa templo kundi adlaw gab-i didto an iya pag-umaw sa Dios na may pag-ayuno kag pagpangadyi. ");
INSERT INTO msb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nag-abot siya sadto mismo na oras kag nagtuna pagpasalamat sa Ginoo kay nakita man si Jesus. Ginsurmaton pa niya an manungod sa bata sa tanan na nagalaom san pagkalibre san Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","San natuman na san ginikanan ni Jesus an tanan susog sa Kasuguan san Ginoo, nag-uli na sinda sa inda sadiri na lungsod na Nazaret na sakop san Galilea. ");
INSERT INTO msb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nagdako an bata kag nagin masarig kag madunong kag ginaataman siya sin maayo san Dios. ");
INSERT INTO msb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tuig-tuig nakaugalian na san mga ginikanan ni Jesus na magpakadto sa Jerusalem para sa Pyista san Paskwa. ");
INSERT INTO msb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","San dose anyos na siya nagpakadto sinda para sa Pyista pareho san dati na ninda na ginahimo. ");
INSERT INTO msb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","San mauli na sinda pakatapos san Pyista si Jesus nagpabilin sa Jerusalem na waraʼn kaaraman an iya mga ginikanan. ");
INSERT INTO msb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nagahuna sinda na si Jesus kaupod san iba na nagaralakat. San mausad na ka adlaw an inda paglakat ginparahanap na ninda si Jesus sa inda mga igmanghod kag mga kakilala. ");
INSERT INTO msb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","San wara na ninda makita nagbalik sinda sa Jerusalem na nagaparahanap sa iya bisan diin. ");
INSERT INTO msb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","San ikatulo na ka adlaw nakita ninda si Jesus sa templo. Didto nagaingkod siya kaurupod san mga maestro san Kasuguan, nagapamati kag nagahinunga sa inda. ");
INSERT INTO msb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","An tanan na nakabati sa iya nangawa san iya kadunungan kag mga panabaton. ");
INSERT INTO msb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","San makita siya nginarat man an iya mga ginikanan. Pakatapos ginhunga siya san iya iloy, “Anak, nano kay sugad ka sana? Kitaa, kay nahandal kag nagparahanap kami sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ugaling ginhunga man sinda ni Jesus, “Nano kay ginaparahanap niyo ako? Dili ba niyo aram na dapat ako nasa balay man san akon Ama?” ");
INSERT INTO msb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero wara ninda masabuti an iya gusto sabihon. ");
INSERT INTO msb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tapos, nag-uli siya kaupod na ninda pa-Nazaret kag didto masinunudon na sa inda pero an tanan ginsabuot na lang san iya iloy. ");
INSERT INTO msb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nagdako si Jesus, nagdugang an iya kadunungan kag nakapalipay sa Dios kag sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ikakinsi ka tuig san paghadi ni Tiberio Cesar, si Poncio Pilato amo man an gobernador san Judea. Si Herodes naman an namumuno san Galilea. An iya kamanghod na si Felipe amo an namumuno san lugar san Iturea kag Traconite kag si Lesanias amo man an namumuno san Abilinia. ");
INSERT INTO msb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sani pa na panahon an mga namumuno san kapadian amo sinda Anas kag Caifas. Sani man nakaabot an tugon san Dios kan Juan na anak ni Zacarias didto sa disyerto. ");
INSERT INTO msb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Niyan, nagtukdo si Juan sa mga tawo sa mga probinsya sa magluyo san suba san Jordan na sinda magpabunyag sa pagpamatuod na nagbaya na sinda sa kasal-an agod patawadon sinda san Dios. ");
INSERT INTO msb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Manungod sani na tawo nasurat san propeta na si Isaias sa libro san iya mga ginsabi, “May nagasiyak sa disyerto ‘Preparara an agihan sa pag-abot san Ginoo. Tadunga an iya mga pagaagihan. ");
INSERT INTO msb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","An tanan na mga hamubo na lugar dapat abunuhan, pataga an tanan na mga kabukidan. An paliku-liko na mga agihan dapat tadungon kag dapat punuan an mga lubak-lubak na dalan. ");
INSERT INTO msb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pakatapos an magasalbar na hali sa Dios makikita san tanan na katawuhan.’,” ");
INSERT INTO msb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaya sinabihan ni Juan an kadamuan na nagkaradto agod magpabunyag sa iya, “Kamo na bagaʼn mga sawa, nano, ginaisip niyo na makadulag sa maabot na grabe na kaurit san Dios? ");
INSERT INTO msb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kun nagabasol kamo kag nagabaya san mga kasal-an maghimoʼn mga pagpamatuod sani kay basi iniisip niyo na dili na niyo kinahanglan magbaya san pagkasala pa kay si Abraham an iyo kalulululuhi kaya masasalbar na kamo. Ayaw kamo pag-isip sana. Ginasiguro ko sa iyo na bisan mga kalahi kamo ni Abraham kinahanglan niyo magbasol kag magbaya san pagkasala. Kun habo kamo, kaya san Dios na makahimo sin tunay na mga kalahi ni Abraham hali sani na mga bato didi imbes sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Niyan, bagaʼn mga kahoy kamo kag bisan ngani yana preparado na an wasay na iuutod sa gamot san mga kahoy. Idtoʼn dili nagabungaʼn matahom pupuludon kag igadabok.” ");
INSERT INTO msb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Naghurunga sa iya an mga kadamuan, “Nano man gali an dapat namon himuon?” ");
INSERT INTO msb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nagsabat si Juan, “An duha an bado dapat ibahin niya an usad sani sa tawo na wara kag idtoʼn igwaʼn ginakaon amo man an iya himuon.” ");
INSERT INTO msb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Igwa man sin mga parasukot san buwis na nagkaradto para magpabunyag kag naghunga sa iya, “Sir, saka kami, nano an dapat namon himuon?” ");
INSERT INTO msb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ginsabat sinda ni Juan, “An tama lang gayod an isukot niyo.” ");
INSERT INTO msb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","May mga suldados man na naghunga sa iya, “Saka kami gali? Nano man an dapat namon himuon?” Nagsabat siya, “Ayaw pagpangwarta paagi sa pakusugan o buwa na pag-akusar kundi kinahanglan na makontento kamo san iyo sweldo!” ");
INSERT INTO msb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Niyan, sa dako na paglaom sa gintuga san Dios na maabot an Cristo nagahuna an katawuhan na basi si Juan amo siya, ");
INSERT INTO msb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","pero ginsabat sinda tanan ni Juan, “Ako an nagapambunyag sa iyo paagi sa tubig pero igwaʼn maabot na mas makagagahom pa ki sa akon kaya dili ngani ako angay bisan maghubad san sintas san iya mga sandalyas. Siya an magabunyag sa iyo paagi sa Espirito Santo kag kalayo. ");
INSERT INTO msb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pagabulagon niya an mga maraot na tawo sa mga maayo pareho san paghimalid para ibulag an mga upa kag titipunon naman an mga humay sa kamalig. Pakatapos an mga upa susunugon niya sa dili mapaparong na kalayo.” ");
INSERT INTO msb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Niyan, paagi san damo pa na mga pakisurmaton gintukdo sa inda ni Juan an maayo na barita manungod kan Cristo. ");
INSERT INTO msb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pero an namumuno na si Herodes ginparasaway ni Juan dahilan na ginasambay si Herodias na asawa na san kamanghod sani kag san iba pa na mga karautan na ginhimo. ");
INSERT INTO msb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ginpanamas pa ni Herodes ini tanan san ginpapriso niya si Juan. ");
INSERT INTO msb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero antes sani na pangyayari may adlaw na pakapabunyag san tanan na katawuhan didto kag pakatapos mismo pagbunyag kan Jesus. Myintras nagapangadyi siya nagbuka an langit kag ");
INSERT INTO msb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","an Espirito Santo na nagapaitsura bagaʼn salampati naglusad pakadto sa iya. Pakatapos may boses na nabati hali sa langit, “Ikaw an akon palangga na Anak na ginakalipay ko gayod.” ");
INSERT INTO msb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","San pagtuna ni Jesus pagtukdo mga 30 anyos na an iya edad. Anak siya ni Jose na amo ini an paghuna san mga tawo. Si Jose anak ni Eli ");
INSERT INTO msb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na anak ni Matat. Ini si Matat anak ni Levi na anak ni Melqui kag si Melqui naman anak ni Jana na anak ni Jose. ");
INSERT INTO msb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose anak ni Matatias na anak ni Amos. Ini si Amos anak ni Nahum na anak ni Esli. Si Esli anak ni Nage ");
INSERT INTO msb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na anak ni Maat na anak ni Matatias. Si Matatias anak ni Semei na anak ni Jose. Si Jose anak ni Juda ");
INSERT INTO msb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na anak ni Joana. Si Joana anak ni Resa na anak ni Zorobabel na anak ni Saltiel na anak ni Neri. ");
INSERT INTO msb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri anak ni Melqui na anak ni Adi. Ini si Adi anak ni Cosam na anak ni Elmodam na anak ni Er. ");
INSERT INTO msb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er naman anak ni Josue na anak ni Eliezer na anak ni Jorim na anak naman ni Matat. Si Matat anak ni Levi ");
INSERT INTO msb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na anak ni Simeon na anak ni Juda kag ini si Juda anak naman ni Jose na anak ni Jonan na anak ni Eliaquim ");
INSERT INTO msb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na anak ni Melea. Ini si Melea anak ni Mainan na anak ni Matat na anak ni Natan na anak ni David. ");
INSERT INTO msb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David anak ni Jesse na anak ni Obed kag si Obed anak naman ni Booz. Si Booz anak ni Salmon na anak ni Naason ");
INSERT INTO msb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na anak ni Aminadab na anak ni Admin. Si Admin anak naman ni Arni na anak ni Esrom na anak ni Fares. Ini si Fares anak ni Juda ");
INSERT INTO msb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na anak ni Jacob. Si Jacob anak ni Isaac na anak naman ni Abraham. Ini si Abraham anak ni Tare na anak ni Nacor. ");
INSERT INTO msb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nacor anak ni Serug na anak ni Ragau na anak naman ni Peleg kag si Peleg anak ni Heber na anak ni Sala. ");
INSERT INTO msb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala anak ni Cainan na anak ni Arfaxad na anak ni Sem. Si Sem anak ni Noe na anak ni Lamec, ");
INSERT INTO msb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na anak ni Metusalem na anak naman ni Enok. Si Enok anak ni Jared na anak ni Mahalaleel, na anak ni Cainan. ");
INSERT INTO msb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan anak ni Enos na anak naman ni Set kag si Set anak ni Adan na anak san Dios. ");
INSERT INTO msb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Niyan, si Jesus nasa gahom san Espirito Santo na ada sa iya, naghali sa suba san Jordan kag gin-giyahan siya san Espirito pakadto sa disyerto. Adto siya didto sa sulod ");
INSERT INTO msb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","san 40 ka adlaw na ginatintaran san demonyo. Sa sulod sadto na panahon nag-ayuno siya kag pakatapos ginutom. ");
INSERT INTO msb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kaya sinabihan siya san demonyo, “Kun matuod na ikaw man gayod an Anak san Dios sugua ini na bato na magin tinapay.” ");
INSERT INTO msb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero nagsabat si Jesus, “Nasurat sa Banal Na Kasuratan na, ‘Dili lang tinapay an makapabuhay sa tawo.’,” ");
INSERT INTO msb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pakatapos ginpasakat siya san demonyo sa hitaas na lugar kag sa usad lang na pagkipat ginpakita sa iya an tanan na kahadian san kinab-an ");
INSERT INTO msb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kag sinabihan siya, “Ihahatag ko sa imo ini tanan na kagamhanan kag kabantugan sani na mga kahadian kay ini ginhatag sa akon kag ikakahatag ko sa magustuhan ko. ");
INSERT INTO msb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaya kun pagasambahon mo ako ina tanan mapasa imo.” ");
INSERT INTO msb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero sinabat siya ni Jesus, “Nasurat sa Banal Na Kasuratan: ‘Sambahon mo an Ginoo na imo Dios kag siya lang gayod an imo dapat pagasirbihan.’,” ");
INSERT INTO msb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dinara naman siya san demonyo sa Jerusalem kag pinatindog sa alituktok san templo. Pakatapos sinabihan siya, “Kun matuod man gayod na ikaw an Anak san Dios lumukso ka hali didi, ");
INSERT INTO msb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kay nasurat, ‘Pagapabantayan ka niya sa iya mga anghel na atamanon ka,’ ");
INSERT INTO msb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kag usad pa, ‘Pagahuyutan ka ninda agod bisan an imo mga tiil dili masakitan sa bato.’,” ");
INSERT INTO msb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero ginsabat siya ni Jesus, “Nasurat na, ‘Dili mo dapat pagporbaran an Ginoo na imo Dios.’,” ");
INSERT INTO msb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","San maubos na san demonyo an tanan na paagi sa pagtintar sa iya, nagbaya an demonyo sa iya hasta naman na may panahon siya para matintaran gihapon. ");
INSERT INTO msb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Si Jesus na may gahom san Espirito Santo nagbalik sa Galilea. Nakalukop sa patalibod na mga lungsod an barita manungod sa iya, ");
INSERT INTO msb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","kag pagtukdo niya sa mga sinagoga gin-umaw siya san tanan. ");
INSERT INTO msb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pag-abot ni Jesus sa Nazaret na iya gindak-an, nagsulod siya sa sinagoga sa Adlaw San Pagpahuway pareho san dati na niya ginahimo. Pagtindog niya para magbasa, ");
INSERT INTO msb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ginhatag sa iya an kasuratan san propeta na si Isaias. Ginbuklad ini ni Jesus kag pakahanapi san nakasurat didto manungod sa iya mismo, ginbasaʼn makusog. ");
INSERT INTO msb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Adi sa akon an Espirito san Ginoo kay ginpili niya ako na magtukdo san maayo na barita sa mga pobre. Ginsugo man niya ako para itukdo na may kalibrihan an mga nagkabirihag ni Satanas, kag sa mga buta na makakita sinda. An mga ginadaug-daog ilibre hali sa mga nagadaug-daog sa inda. ");
INSERT INTO msb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Itukdo man sa tanan na adi na an panahon san pagasalbar san Ginoo san iya katawuhan.” ");
INSERT INTO msb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ginlukot gihapon niya an kasuratan, gin-uli sa kabulig kag nag-ingkod na. Niyan, an tanan sasinagoga nakamasid sa iya. ");
INSERT INTO msb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pakatapos nagtuna siya pagsurmaton sa inda, “Myintras nagapamati kamo natutuman na ini na nasurat.” ");
INSERT INTO msb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nagkangarawa an tanan san iya mga matahom na panurmaton kag nauyunan siya. Pakatapos nagpahurunga-hunga sinda, “Dili ba anak lang ini ni Jose?” ");
INSERT INTO msb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Didi nagpadayon si Jesus pagsurmaton, “Tama gayod an paghuna ko na sasabihon niyo ini sa akon, ‘Duktor, bulunga anay an sadiri mo.’ An gusto niya sabihon, ‘Himuon man didi sa imo sadiri na lungsod an nabatian namon na ginhimo mo sa Capernaum.’,” ");
INSERT INTO msb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kaya nagdagdag siya, “Matuod an ginasabi ko sa iyo na waraʼn propeta na ginaako sa iya sadiri na lungsod. ");
INSERT INTO msb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pareho baga na damo sin mga biyuda sa Israel san panahon san propeta na si Elias san nagsira an langit sa sulod sin tulo ka tuig kag unom ka bulan na grabe na gutom an gintios san bilog na Israel, ");
INSERT INTO msb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero wara pagsugua si Elias san Dios bisan sa diin man sani na mga lugar kundi didto lang sa biyuda na dili-Judio pero taga-Sarepta sa lugar san Sidon. ");
INSERT INTO msb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sugad man san kapanahunan san propeta na si Eliseo damu-damoʼn mga leprosohon sa Israel pero wara gayod sa inda sin nabulong pwera lang kan Naaman na dili-Judio kundi taga-Siria.” ");
INSERT INTO msb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kaya san pakabati sani san mga tawo sa sinagoga nagkaururit gayod sinda sa iya. ");
INSERT INTO msb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tumirindog sinda, ginguyod paluwas san lungsod kag gindara ninda sa pangpang san bukid na natitindugan san inda lungsod agod iitsa siya, ");
INSERT INTO msb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","pero nag-agi lang siya sa tunga san kadamuan kag binayaan sinda. ");
INSERT INTO msb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pakatapos nagpakadto si Jesus sa Capernaum na lungsod san Galilea kag sa Adlaw San Pagpahuway nagatukdo siya sa mga tawo didto. ");
INSERT INTO msb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nagkangarawa sinda sa iya katukduan kay may poder an iya panurmaton. ");
INSERT INTO msb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Didto sa sinagoga igwa sin tawo na nasudlan sin maraot na demonyo kag nagsiyak sin makusog, ");
INSERT INTO msb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Jesus na taga-Nazaret, nano an pakilabot mo sa amon? Nano, nagkadi ka ba agod siraon kami? Aram ko kun sin-o ka. Ikaw an Banal na hali sa Dios.” ");
INSERT INTO msb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero ginsaway siya ni Jesus, “Puyo dida! Lumuwas ka sa iya!” Tapos pakapasagmok san demonyo sa tawo sa atubangan ninda, lumuwas na ini na wara na siya pagpasakiti. ");
INSERT INTO msb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kaya, nangarat gayod sinda tanan kag nagpahurunga-hunga, “Nano ini na klaseʼn surmaton? An mga maraot na espirito nasusugo niya na may gahom kag otoridad, tapos nagruluwas ini!” ");
INSERT INTO msb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kaya naglukop an barita manungod sa iya sa tanan na mga lungsod sa patalibod. ");
INSERT INTO msb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pagluwas ni Jesus sa sinagoga nagkadto siya sa balay ni Simon. Didto an ugangan na babayi ni Simon grabe an kalintura kaya nakimaluoy sinda kan Jesus na paayuhon ini. ");
INSERT INTO msb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nagtindog si Jesus sa tungod san masakit kag ginpahali an kalintura sani. Sadto mismo hinaw-asan ini san kalintura san may sakit kaya bumangon dayon ini kag nag-asikaso sa inda. ");
INSERT INTO msb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","San matunod na an adlaw gindara san mga tawo sa iya idto tanan na may ginbatyag na manlain-lain na mga sakit. Pagdapat lang niya san iya kamot sa kada usad nag-arayo dayon. ");
INSERT INTO msb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Damo man na mga tawo an ginluwasan san mga demonyo na nagasiyak, “Matuod na Anak ka san Dios!” Pero ginsaway niya sinda kag wara pagtuguti na magsurmaton pa dahilan na aram ninda na siya an Cristo. ");
INSERT INTO msb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagkaaga naghali si Jesus kag nagpakadto sa mamingaw na lugar. Ginparahanap siya san katawuhan kag pakakita sa iya ginhawidan na dili sinda pagbayaan. ");
INSERT INTO msb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ginsabat niya sinda, “Dapat ko man itukdo an Maayo Na Barita san kahadian san Dios sa iba man na mga lungsod kay amo ina an katuyuan san akon pagpakadi.” ");
INSERT INTO msb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kaya si Jesus nagpadayon pagtukdo sa mga sinagoga san Judea. ");
INSERT INTO msb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Usad sin adlaw pagtindog ni Jesus sa may Danaw san Genesaret damo na mga tawo an nagsurusuan patalibod niya sa pagpamati san katukduan manungod sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","May nakita siyaʼn duha na baruto sa pangpang. Nakalusad na an mga parapangisda kag ginalinisan an inda mga lambat. ");
INSERT INTO msb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kaya sumakay siya sa baruto ni Simon kag naghangyo na ihuruharayo sa pangpang. Pakatapos nag-ingkod na siya sa baruto kag nagtukdo sa katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","San mahuman na siya pagsurmaton sinabihan niya si Simon, “Magpalawod kamo kag didto ihulog an iyo mga lambat agod makapanguha.” ");
INSERT INTO msb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nagsabat si Simon, “Sir, nag-aga kamiʼn katrabaho kag wara gayod sin nakuha pero dahilan sa ginsabi mo ihuhulog ko an mga lambat.” ");
INSERT INTO msb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","San himuon ninda ini damu-damo sindaʼn nalambat na isda na nagkaparaksi na an inda mga lambat. ");
INSERT INTO msb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kaya ginpaypay ninda na mag-apiki an inda mga kaurupod na nasa iba na baruto agod buligan sinda. Nag-arapiki man sinda kag napuno ninda an duha na baruto na haros malunod na. ");
INSERT INTO msb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","San pakakita sani ni Simon Pedro nagluhod siya sa may atubangan ni Jesus na nagasabi, “Ginoo, bayai ako kay parakasala ako,” ");
INSERT INTO msb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","kay nangawa gayod siya san kadamuan san inda nakuha na isda. ");
INSERT INTO msb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Amo man an iya mga kaurupod na sinda Santiago kag Juan na mga anak ni Zebedeo. Pero ginsabihan ni Jesus si Simon, “Ayaw kahadlok kay magtuna niyan mga tawo na an imo lalambaton.” ");
INSERT INTO msb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kaya pagdungka ninda ginbayaan an tanan kag nag-upod para magin sumurunod niya. ");
INSERT INTO msb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","San adto si Jesus sa usad na lungsod may nag-abot na tawo na puno an lawas sin leproso. Pakakita niya kan Jesus naghapa kag nakimaluoy sa iya. “Ginoo, kun gustuhon mo mapaayo ako.” ");
INSERT INTO msb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Gin-unat ni Jesus an iya kamot kag gindapatan siya na nagasabi, “Oo, gusto ko. Mag-ayo ka!” Insigida nawara dayon an iya leproso. ");
INSERT INTO msb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gintugon siya ni Jesus, “Ayaw pagpanumat bisan kanin-o kundi kumadto ka kag magpakita sa padi. Tapos maghalad ka para sa pag-ayo mo susog sa Kasuguan ni Moises bilang pagpamatuod sa mga tawo na nag-ayo ka na.” ");
INSERT INTO msb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero mas lalo na nakalukop an barita manungod sa iya. Kaya damu-damo an nagtiripon para magpamati kag magpabulong san inda mga sakit, ");
INSERT INTO msb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","pero nagaparakadto siya sa mga mamingaw na lugar para magpangadyi. ");
INSERT INTO msb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Usad sin adlaw myintras nagatukdo si Jesus na ada man sa iya an kagamhanan san Ginoo agod makapamulong, igwa sin mga nagaurusyuso na Pariseo kag mga paratukdo san Kasuguan na nagairingkod. Mga hali sinda sa kada lungsod san Galilea, san Judea kag sa syudad san Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Taud-taod may nag-abot na pira ka tawo may dara na paralitiko na nasa higdaan. Nagpirit sinda na maisulod sa balay an may sakit sa atubangan ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero tungod sa kadamuan san tawo wara na sindaʼn maagihan. Kaya nagsarakat sinda sa atop kag didto gintangkasan an parte sa ibabaw ni Jesus tapos gintunton an paralitiko na nasa higdaan sa tunga san nagatiripon sa may atubangan ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pakakita niya san inda ginhimo dahilan san pagtuod nagsabi, “Amigo, napatawad na an imo mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","An mga Pariseo kag mga paratukdo san Kasuguan nagahunga sa inda mismo sadiri, “Sin-o man ini na nagabasang-basang san Dios? Waraʼn makapatawad san kasal-an kundi an Dios lang gayod!” ");
INSERT INTO msb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero aram ni Jesus an inda kaisipan kaya ginhunga, “Nano kay sugad sana an pag-isip niyo? ");
INSERT INTO msb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hain sani an mas maayo sabihon, ‘Napatawad na an imo mga kasal-an,’ o ‘Bangon kag lakat’? ");
INSERT INTO msb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ugaling pagapamatuudan ko sa iyo agod maaraman niyo na ako na Anak San Tawo may poder sa pagpatawad san mga kasal-an didi sa kinab-an.” Pakatapos ginsabihan niya an paralitiko na tawo, “Adi an akon sugo sa imo: bangon kag bitbita an imo higdaan, tapos umuli ka.” ");
INSERT INTO msb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Insigida sa atubangan ninda nagbangon an paralitiko, ginbitbit an iya higdaan kag umuli na nagaumaw sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nagngaralas sinda tanan kag nangawa kaya gin-umaw an Dios na nagasabi, “Yana na adlaw nakakita kami sin makangangalas na mga bagay!” ");
INSERT INTO msb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pakatapos sani nagluwas si Jesus. May nakita siya na parasukot san buwis na an ngaran Levi na nagaingkod sa may kolektahan san buwis. Sinabihan siya ni Jesus, “Mag-upod ka sa akon.” ");
INSERT INTO msb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kaya tumindog si Levi, binayaan an tanan kag nag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sa iba na adlaw ginpaponsyahan si Jesus ni Levi sa iya balay. Damo na mga parasukot san buwis kag san iba pa an kaaratubang ninda sa lamesa. ");
INSERT INTO msb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero pakakita sani san mga Pariseo kag san inda mga paratukdo san Kasuguan nagreklamo sinda sa iya mga disipulos, “Nano kay nakikaon kag nakiinom kamo kaupod san mga parasukot san buwis kag iba na mga makasasala?” ");
INSERT INTO msb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nabatian ini ni Jesus kaya ginsabat sinda, “Dili nagakinahanglan sin duktor an waraʼn sakit kundi idtoʼn mga masakiton. ");
INSERT INTO msb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nagkadi ako didi sa kinab-an dili sa pag-agda sa mga matanos kundi sa mga makasasala agod makapangbasol kag magbaya sinda sa inda pagkasala.” ");
INSERT INTO msb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kaya ginsabat man siya ninda, “Pirme nagaayuno kag nagaparapangadyi an mga disipulos ni Juan na Parabunyag, amo man an mga disipulos san mga Pariseo, pero an sa imo padayon sa pagkaon kag pag-inom.” ");
INSERT INTO msb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ginsabat naman sinda ni Jesus paagi sa istorya, “Nano, mapaayuno niyo an mga abay sa kasal myintras kaupod pa ninda an kinasal? Syimpre dili, ");
INSERT INTO msb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","pero maabot an adlaw na pagakuhaon siya sa inda kag amo pa lang sinda magaayuno dahilan san kamunduan.” ");
INSERT INTO msb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pakatapos gin-istoryahan pa niya sinda para mapahayag na an iya bag-o na katukduan dili makabiyo sa mga daan. “Waraʼn matangkop sin bag-o na tela sa daan na bado kay kun amo ini an himuon an gintangkop na bag-o makuro kag mas lalo na madako an gisi. ");
INSERT INTO msb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sugad man, waraʼn masulod sin bag-o na bino sa daan na anit na surudlan kay, kun sugad, maputok an anit na surudlan kag an bino mawawasak. Kaya an bino masasayang kag masisira an surudlan. ");
INSERT INTO msb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kun kaya an bag-o na bino dapat lugod sa bag-o na anit na surudlan. ");
INSERT INTO msb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wara man sin magusto pag-inom sin bag-o na bino kun nakainom san dugay na. An sabi pa ngani, ‘Mas maayo an daan.’,” ");
INSERT INTO msb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Usad sin Adlaw San Pagpahuway san sinda Jesus nagaaragi sa katriguhan, an iya mga disipulos nagpamudo sin mga binhi kag pakapaniti ginakaraon ninda. ");
INSERT INTO msb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pero may iba na mga Pariseo na naghunga, “Nano kay ginahimo niyo an ginabawal kun Adlaw San Pagpahuway?” ");
INSERT INTO msb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ginsabat sinda ni Jesus, “Nano, wara pa kamo nakabasa kun nano an ginhimo ni David san ginutom siya kag sadtoʼn mga kaurupod niya? ");
INSERT INTO msb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nangyari ini san magsulod siya sa templo san Dios kag kinuha an mga tinapay na ginhalad sa Dios na dili ngani dapat kaunon san iba pwera lang san mga padi. Ginbahinan niya an iya mga kaurupod tapos kinaraon ninda tanan.” ");
INSERT INTO msb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pakatapos ginsurmatunan niya sinda, “Ako na Anak San Tawo amo an Ginoo na makabuot sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Usad naman sin Adlaw San Pagpahuway nagsulod si Jesus sa sinagoga agod magtukdo. May lalaki didto na kimay an tuo na kamot. ");
INSERT INTO msb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kaya sa paglaom na may ikaakusar na kontra kan Jesus, an mga Pariseo kag san mga paratukdo san Kasuguan ginmasdan gayod siya kun magabulong san kimay sa Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero aram na niya an inda ginaisip kaya ginsabihan lugod an tawo na kimay, “Kadi anay kag magtindog didi!” Kaya nagtindog siya didto. ");
INSERT INTO msb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Didi ginsabihan sinda ni Jesus, “Hungaon ta kamo. Nano an tama na himuon sa Adlaw San Pagpahuway? Maghimo sin maayo o maghimo sin maraot? Magsalbar sin tawo o magpatay?” ");
INSERT INTO msb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tapos ginsud-ong sinda tanan ni Jesus na nasa patalibod niya kag ginsabihan an lalaki, “Iunat an imo kamot.” Nagsunodan lalaki kag an iya pagkakimay nag-ayo na. ");
INSERT INTO msb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero sobra gayod an inda kaurit kan Jesus kaya nagtuna pag-iristoryahan kun nano an dapat na himuon ninda sa iya. ");
INSERT INTO msb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sani man na panahon nagpakadto si Jesus sa bukid para magpangadyi. Naagahan siya didto pagpangadyi sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkaaga tinawag niya an iya mga disipulos tapos nagpili siyaʼn dose kag gintawag sindaʼn apostoles. ");
INSERT INTO msb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Amo ini sinda: si Simon na iya ginngaranan na Pedro kag san iya kamanghod na si Andres, si Santiago, si Juan, si Felipe, si Bartolome, ");
INSERT INTO msb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago na anak ni Alfeo, si Simon na panatiko, ");
INSERT INTO msb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas na anak ni Santiago kag si Judas Iscariote na amo an magatraydor sa iya. ");
INSERT INTO msb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Naglugsad sinda Jesus kag nag-udong sa usad na patag na lugar. Damo san iya mga disipulos an nagatiripon didto kaurupod san damu-damo na mga tawo na tagamanlain-lain na lugar san Judea, Jerusalem kag sa baybayon na lugar san Tiro kag Sidon, ");
INSERT INTO msb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","na nagkaradto agod makapamati sa iya kag makapabulong san inda mga sakit. Ginpaluwas man niya idtoʼn mga maraot na espirito na nakasulod sa mga tawo kaya nabulong ini. ");
INSERT INTO msb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","An tanan na katawuhan nagatalinguha na makadut-dot sa iya kay may nagaluwas sa iya na gahom na amo an nakabulong sa inda tanan. ");
INSERT INTO msb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tapos ginsud-ong ni Jesus an iya mga disipulos kag nagsabi, “Malipay kamo na mga pobre kay para sa iyo an kahadian san Dios! ");
INSERT INTO msb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Malipay man kamo na nagugutom yana kay pagabusugon. Malipay man kamo na nagatarangis yana kay pagapatawahon pag-abot san kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Malipay naman kamo kun ginakabadlian san mga tawo, ginapaluwas sa inda, ginatuya-tuya kag ginasikway na pareho san kriminal dahilan sa pagtuod sa akon na Anak San Tawo! ");
INSERT INTO msb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pareho ini san ginhimo san inda mga kalulululuhan sa mga propeta kasadto kaya magsadya pag-abot sana na adlaw kag magsayaw sa kalipay kay dako gali an nakatigana para sa iyo na premyo sa langit. ");
INSERT INTO msb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero kamakaluluoy man niyo na mga mayaman kay naliaw na kamo! ");
INSERT INTO msb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kamakaluluoy man niyo na mga burusog yana kay kamo magugutom! Kamakaluluoy man niyo na mga nagatarawa yana kay kamo magamurundo kag magatarangis! ");
INSERT INTO msb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kamakaluluoy man niyo kun kamo ginadayaw san tanan na katawuhan, kay pareho man sana an pagtratar san inda mga kalulululuhan sa mga buwaon na mga propeta. ");
INSERT INTO msb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pero kamo na mga nagapamarati, pamatii gayod ini: kamut-an niyo an iyo mga kaaway, himuan niyo sin maayo an nauurit sa iyo, ");
INSERT INTO msb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","handuma an kaayuhan sa nagamaldisyon sa iyo kag ipangadyi niyo an nagapakaraot sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kun sampadungon an kapihak mo na pisngi itugot mo man na sampadungon pa hasta an sa luyo. Kun ginaagaw an imo alikboy dili mo ig-imot hasta an bado mo. ");
INSERT INTO msb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Hatagi an nagapangayo sa imo kag ayaw na pagbawia an mga kinawat na kasadirihan mo. ");
INSERT INTO msb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sugad man himua sa iba an gusto mo na himuon man san mga tawo sa imo. ");
INSERT INTO msb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kun an mga kamut-an niyo idto lang na may pagkamuot sa iyo, nano, pagadayawon kamo san Dios dahilan sana? Bisan ngani an mga makasasala namumuot man sadtoʼn namumuot man sa inda! ");
INSERT INTO msb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kun an himuan lang niyo sin kaayuhan an naghimo man lang sin maayo sa iyo, nano, pagadayawon kamo san Dios dahilan sana? Kay bisan ngani an mga makasasala pareho man sana an ginahimo. ");
INSERT INTO msb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Usad pa gayod kun an pautangon lang niyo idtoʼn ginalauman niyo na makabalos man lang, nano, pagadayawon kamo san Dios dahilan sana? Bisan an mga makasasala nagapautang man sa kapwa makasasala para makabalik gihapon sa inda an pareho na kantidad! ");
INSERT INTO msb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kundi kamut-an niyo an iyo mga kaaway kag himuan sin kaayuhan kag magpahuram na dili nagalaom na balusan. Makabaton kamo sin daku-dako na premyo kag magigin mga anak san Pinakalabaw sa tanan na dios kay siya mismo maluluy-on sadtoʼn mga waraʼn utang na buot kag mga maimot. ");
INSERT INTO msb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaya magin maluluy-on man lugod kamo pareho san Dios na iyo Ama na maluluy-on. ");
INSERT INTO msb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ayaw paghusgar sa kapwa tapos dili ka man pagahusgaran. Ayaw pagkondinar tapos dili ka man pagakondinaron san Dios. Magpatawad tapos pagapatawadon ka man niya. ");
INSERT INTO msb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Maghatag kag pagahatagan ka man. Tama na sukol na dinasok, inuy-og kag sobra pa an ihahatag sa imo kay kun nano man an sukol na ginagamit mo amo man an sukol na gagamiton sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nagsurmaton man siya sa inda sani na istorya, “Nano, makagiya an buta sa kapareho niya buta? Syimpre dili. Sigurado gayod na sinda na duha mahuhulog sa kali. ");
INSERT INTO msb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Waraʼn disipulos na mas labaw pa ki sa iya maestro pero an kompleto na tinukduan na disipulos kapareho gayod san iya maestro.” ");
INSERT INTO msb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nagsurmaton gihapon si Jesus sin istorya, “Nano kay nakikita mo an puling sa mata san imo kapwa pero an kahoy sa sadiri mo na mata dili mo ngani nanginginanuhan? ");
INSERT INTO msb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nano kay sasabihon mo pa sa imo kapwa, ‘Kamanghod, pabayaan mo na halion ko an puling san imo mata,’ na dili mo ngani nakikita an kahoy sa sadiri mo na mata! Pakitaʼn-tawo ka lang. Kuhaa anay an kahoy sa sadiri mo na mata kay agod makakita ka na sin maayo pagkuha san puling sa mata san imo kapwa.” ");
INSERT INTO msb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Tapos nagpadayon si Jesus pagsabi, “Waraʼn maayo na kahoy na nagabunga sin maraot kag wara naman sin maraot na kahoy na nagabunga sin maayo. ");
INSERT INTO msb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nakikilala an kahoy sa mismo bunga sani. Halimbawa, nano, napupudo sa katunukan an bunga san higera o mga ubas? Syimpre dili! ");
INSERT INTO msb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kun sa tawo man an mga maayo nakahimoʼn kaayuhan dahilan na puno sin kaayuhan an iya tagipusuon. An maraot naman nakahimo man sin karautan dahilan na puro karautan an ada sa iya kay kun nano man an ada gayod sa tagipusuon amo man an ginasurmaton. ");
INSERT INTO msb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nano kay ginatawag niyo ako na Amo pero dili man ginatuman an ginasugo ko? ");
INSERT INTO msb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Igapakita ko sa iyo kun kanin-o nakapareho an nagapatukdo sa akon, nagapamati san akon mga surmaton kag ini ginasabuhay. ");
INSERT INTO msb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pareho siya sa nagbuho sin hadalom hasta sa kabatuhan na amo an nagin pundasyon san iya balay. Pagtindog na san balay may pagbaha kag bumuswang an tubig pakadto sadtoʼn balay pero wara gayod mauy-og kay tama an pakapanday. ");
INSERT INTO msb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero idtoʼn namati kag wara man pagtumana nakapareho man sa nagtindog sin balay sa duta na wara sin maayo na pundasyon. San pagbuswang san baha nasira kag grabe an pakaruba sadto na balay!” ");
INSERT INTO msb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pakatapos pagsurmaton ni Jesus san tanan na gusto niya ipabati sa mga tawo, nagpakadto siya sa Capernaum. ");
INSERT INTO msb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Didto may palangga na suruguon an namumuno san mga suldados. Masakit siya kag tikamatayon. ");
INSERT INTO msb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","San pakabarita niya kan Jesus naghangyo siya sin pira na mga namumuno san mga Judio na pakadto sa iya para makimaluoy na mag-upod kag ayuhon an iya suruguon. ");
INSERT INTO msb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pag-abot ninda kan Jesus nakimaluoy gayod sinda sin maayo, “Angay gayod na himuon mo ini sa iya, ");
INSERT INTO msb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kay siya mainangay-angayon sa aton na mga tawo. Siya pa ngani an nagpahimo san amon sinagoga.” ");
INSERT INTO msb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kaya nag-upod si Jesus sa inda kag san halapit na siya sa balay ginpasugat naman siya san namumuno sa iya mga amigo na may ginapasabi, “Ginoo, ayaw na pagpagala pa an imo sadiri kay dili ako angay na magpadayon sa imo sa akon balay. ");
INSERT INTO msb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sugad man dili ako angay makig-atubang sa imo pero magsurmaton ka lang kay an akon suruguon mabubulong. ");
INSERT INTO msb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nasabi ko ini kay may nagasakop sa akon kag may mga ginasakupan man ako na mga suldados. Kun pagsabi ko sa usad na ‘Lakat,’ malakat siya, kag sa iba naman, ‘Kumadi ka,’ tapos matulos siya. Kun ginasabi ko man sa akon suruguon, ‘Himua ini,’ tutumanon niya.” ");
INSERT INTO msb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pakabati sani ni Jesus nagngalas gayod siya, inatubang an kadamuan na nagasurunod sa iya kag nagsurmaton, “Ginasiguro ko sa iyo na wara pa gayod ako makakita sin may pareho saniʼn pagtuod sa bilog na Israel.” ");
INSERT INTO msb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Niyan, san magbalik na sa balay an mga ginsugo nakita ninda na nag-ayo na an suruguon. ");
INSERT INTO msb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pagkaotro adlaw sadto nagkadto si Jesus sa lungsod na ginatawag na Nain kaurupod an iya mga disipulos kag san damo na katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","San halapit na siya sa may pwertahan san lungsod may nasugat siyaʼn mga tawo na may irulubong na lalaki. Ini sulo lang na anak san iya iloy na biyuda pa. May damo man na kahilungsod na nakigdamay sa iya. ");
INSERT INTO msb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pakakita san Ginoo sa biyuda naluoy gayod kaya nag-apiki siya kag nagsabi, “Ayaw pagtangis.” ");
INSERT INTO msb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tapos, gindapat niya an kamot sa taol san patay kag nag-urudong an nagabarayaw. May ginsabi siya, “Batan-on, bumangon ka!” ");
INSERT INTO msb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kaya nagbangon an dati patay kag nagtuna pagsurmaton. Pakatapos ginkabit siya ni Jesus pakadto sa iya iloy. ");
INSERT INTO msb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","An tanan nagkaharadlok kag nag-umaw sa Dios na nagasarabi, “May nag-abot sa aton na labaw na propeta. An Dios nag-abot para isalbar an iya katawuhan.” ");
INSERT INTO msb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ini naman na barita manungod sa iya nakalukop sa bilog na Judea kag sa patalibod na mga lugar. ");
INSERT INTO msb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ini tanan na mga pangyari ginbarita kan Juan san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kaya gintawag niya an duha san iya mga disipulos kag pinakadto sa Ginoo agod maghunga, “Sir, nano, ikaw na po an ginasabi sa Banal Na Kasuratan na maabot o mapaabot pa kamiʼn iba?” ");
INSERT INTO msb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pag-abot didto kan Jesus san duha na sinugo nagsabi sinda, “Sir, ginpakadi na po kami sa imo ni Juan na Parabunyag para maghunga, ‘Ikaw na po ba an ginasabi sa Banal Na Kasuratan na maabot o mapaabot pa kamiʼn iba?’,” ");
INSERT INTO msb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sadtoʼn kaurason damo naʼn ginapangbulong si Jesus na mga may sakit, may mga ginabatyag, nagkasurudlan sin mga maraot na espirito kag may mga buta na ginpakita gihapon niya. ");
INSERT INTO msb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaya ginsabat niya an mga ginsugo, “Kadto kag sumati niyo si Juan kun nano an iyo nakita kag nabatian didi na amo ini: nakakita gihapon an mga buta, nakalakat na an mga pilay, naayo naman an mga leprosohon kag an mga bungol nakabati. Nabuhay gihapon an mga patay kag an mga pobre nakabati san Maayo Na Barita na ginapahayag sa inda. ");
INSERT INTO msb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sugad man, malipay idtoʼn dili nawawar-an sin pagtuod sa akon.” ");
INSERT INTO msb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagharali san mga ginsugo ni Juan nagtuna naman si Jesus pag-istorya sa mga katawuhan manungod kan Juan, “San pagkadto niyo sa disyerto nano an ginalaom niyo na makita didto? Usad na tawo na pareho sa uhot na ginapalid-palid san hangin? ");
INSERT INTO msb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nano man gali an ginahuna niyo na makita? Tawo na nakabado sin matahom? Syimpre dili, kay idtoʼn nagabarado sin mga matahom kag nabubuhay sa kabuganaan adto nagaistar sa mga palasyo san mga hadi! ");
INSERT INTO msb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kun kaya ngani nano man gayod an ginkadtuan niyo na makita? Propeta? Oo, kag tandai ini, mas labaw pa gayod sa propeta an nakita niyo, ");
INSERT INTO msb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","kay siya an katumanan san nasurat sa Banal Na Kasuratan, ‘Kitaa, may suruguon ako na mapauna sa imo. Siya an magapreparar san imo aagihan.’,” ");
INSERT INTO msb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nagpadayon si Jesus, “Tandai ini na ginasabi ko sa iyo, sa tanan na kabataan na gin-anak san mga babayi wara na gayod sin nakalabaw kan Juan. Ugaling mas labaw ki sa iya an pinakamenos sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(An tanan na mga tawo na nagpamati sa iya kag amo man an mga parasukot san buwis, nag-ako na tama an katuyuan san Dios kay nagpabunyag sinda kan Juan, ");
INSERT INTO msb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","pero an mga Pariseo kag mga Paratukdo san Kasuguan nagsikway san katuyuan san Dios para sa inda sadiri kag wara nagpabunyag kan Juan.) ");
INSERT INTO msb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Didi naman nagpadayon si Jesus, “Niyan, sa nano ko maikukumparar an mga tawo na nabubuhay yana? Kay nano an napaparehuan ninda? ");
INSERT INTO msb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pareho sinda sa mga kabataan na nagairingkod sa merkado kag nagapasiriyak-siyak sa inda mga kakanam sugad sani, ‘Gintugtugan kamo namon sin plawta pero dili man kamo nagsarayaw! Tapos, nagkanta naman kamiʼn mamunduon pero wara kamo nagtarangis!’ ");
INSERT INTO msb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bagaʼn amo man kamo ini. Nagkadi si Juan na Parabunyag na nagaayuno kag dili nagainom sin bino pero nagsarabi kamo, ‘Nasudlan siya sin demonyo!’ ");
INSERT INTO msb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nagkadi naman ako na Anak San Tawo na nagakaon kag nagainom tapos nagsarabi naman kamo, ‘Kitaa niyo siya. An makagod kag parahubog. Amigo man siya san mga parasukot san buwis kag san mga makasasala!’ ");
INSERT INTO msb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ugaling an kadunungan san Dios ginpamatuudan na matanos san tanan na nagaako sani.” ");
INSERT INTO msb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pagkatapos gin-imbitaran pagkaon si Jesus san usad san mga Pariseo. Pag-abot niya sa balay sani nagtulos siya sa lamesa para magkaon. ");
INSERT INTO msb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taud-taod may nag-abot naman gali na tagalungsod na babayi na nagapabayad. Pakabarita niya na makikaon si Jesus sadtoʼn Pariseo nagdara siya sin pahumot na nasa surudlan na himo sa alabastro na bato. ");
INSERT INTO msb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nagtindog siya sa may likudan ni Jesus kag sa may tiilan sani nagaparatangis na ginapaturuan san iya luha an tiil ni Jesus. Tapos ginpahidan niya idto san iya buhok pero pakatapos iya ginparaharukan kag ginpahumutan an tiil sani. ");
INSERT INTO msb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","San makita ini san Pariseo na nag-imbitar kan Jesus nakasabi sa iya sadiri, “Kun matuod man gayod na propeta ini na tawo aram na niya kun sin-o kag nanoʼn klase na babayi an nagdutdot sa iya kay ini nagapabayad na babayi.” ");
INSERT INTO msb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ginpahalapit siya ni Jesus kag sinabihan, “Simon, may isasabi ako sa imo.” “Nano ina, Maestro?” an hunga niya. ");
INSERT INTO msb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“May duha na tawo na nangutang sa parapautang. An usad nakautang sin 500 pisos kag an usad 50. ");
INSERT INTO msb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wara sinda nakabayad kaya ginpasensya na lang niya sinda na duha. Niyan, sin-o sa duha an mamumuot gayod sa iya?” ");
INSERT INTO msb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Siguro an usad na mas dako sin utang,” an sabat ni Simon. “Tama ka,” an sabat man ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pakatapos ginlingi niya an babayi kag naghunga naman, “Simon, nakikita mo ini na babayi? Nagkadi ako sa imo balay kag wara mo paghatagi sin tubig para ihugas san akon tiil pero siya ginpaturuan san iya luha an akon tiil kag gintrapuhan pa san iya buhok. ");
INSERT INTO msb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wara mo ako pagharuki pero siya ginparaharukan an akon tiil tuna san pag-abot ko lang. ");
INSERT INTO msb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wara mo paglahidi bisan lana an akon ulo pero siya ginpahumutan an akon mga tiil. ");
INSERT INTO msb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaya tandai an ginasabi ko sa imo, ginpatawad na an damo niya na mga sala kay grabe gayod an iya kamuot sa akon. Sugad man an ginpatawad sin dyutay, dyutay man an ginapakita na pagkamuot.” ");
INSERT INTO msb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tapos sinabihan ni Jesus an babayi, “Ginpatawad na an imo mga kasal-an.” ");
INSERT INTO msb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Niyan, idtoʼn mga tawo na kaurupod niya pagkaon sa lamesa nakasabi sa inda sadiri, “Sin-o daw ini na tawo na bisan mga kasal-an nakapatawad siya?” ");
INSERT INTO msb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero sinabihan niya an babayi, “An imo pagtuod amo an nakasalbar sa imo. Hala, uli na na may kalinaw san isip!” ");
INSERT INTO msb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pakatapos sadto nagpanglurulungsod kag nagpangburubaryo si Jesus sa pagtukdo kag pagpahayag san Maayo Na Barita manungod sa kahadian san Dios. Nag-upod sa iya an dose, ");
INSERT INTO msb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hasta an iba pa na mga babayi na nagkaarayo san inda mga sakit kag ginluwasan san mga maraot na espirito. Amo man ini si Maria na ginatawag Magdalena na hali sa iya pito na demonyo an napaluwas. ");
INSERT INTO msb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kaupod pa sinda Juana na asawa ni Chuza na katiwala ni Herodes, Susana kag san iba pa na may mga kaya amo an nagaburulig sa panginahanglan ninda Jesus. ");
INSERT INTO msb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pagtiripon san kadamuan na tawo na tagamanlain-lain pa na mga lungsod para makita siya, ginsurmaton niya ini na istorya: ");
INSERT INTO msb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“May parauma na nagpauma para magsabwag sin mga binhi. Sa iya pagsabwag may mga binhi na nakatupa sa may dalan. Nagkataramak-tamakan idto kag tinuruka san mga sapat. ");
INSERT INTO msb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","May nakatupa man sa kabatuhan pero pagragit san adlaw nag-uruga tungod na wara sin tubig. ");
INSERT INTO msb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","May nakatupa naman sa katunukan pero nagdaragko an katunukan kaupod san mga tanom, kaya nasiutan ini kag namatay. ");
INSERT INTO msb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Niyan, may iba pa man na mga binhi na nakatupa gayod sa mataba na duta, nagturubo kag nagburunga sin mananggatos kada binhi.” Pakaistorya sani ni Jesus nagsiyak siya, “Kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pakatapos, ginhunga siya san iya mga disipulos kun nano an gusto sabihon sani na istorya, ");
INSERT INTO msb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nagsabat naman siya, “Kamo an gintugutan na maaraman an mga misteryo san kahadian san Dios, pero sa iba an tanan sani ginatukdo paagi sa istorya agod ‘bisan sing-ano ninda sin kasud-ong dili gihapon ninda nakakita, bisan sing-ano ninda sin kapamati dili gihapon sinda nakasabot.’ ");
INSERT INTO msb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Niyan, an gusto sabihon san istorya amo ini: an binhi amo an surmaton san Dios. ");
INSERT INTO msb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Idto na nakatupa sa dalan na mga binhi amo idtoʼn nakabati san surmaton, tapos nagaabot dayon an demonyo kag nagahali sadtoʼn surmaton agod dili sinda magtuod kag masalbar. ");
INSERT INTO msb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Idto naman na nakatupa sa kabatuhan pareho san mga nakabati san surmaton, tapos nagatuod kag nagakarilipay. Pero wara ninda ini ipasabuot, kaya nagatuod sinda sin kadali pero pakatintari ginapabayaan dayon an inda pagtuod. ");
INSERT INTO msb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sadto naman na katunukan kun diin nakatupa an mga binhi amo sinda an mga tawo na nakabati, pero sa inda pagpadayon nadaog sinda san kahandalan, mga kayamanan kag mga kinab-anon na kalipay sa buhay kaya an inda pagtuod wara magbaskog. ");
INSERT INTO msb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Idto ugaling na mga nakasabwag man na binhi sa mataba na duta amo an mga tawo na pakabati san surmaton, nagatuod na may hugot sa buot kag sa maayo na tagipusuon, nagpadayon hasta magbunga an inda pagtuod.” ");
INSERT INTO msb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nagpadayon si Jesus sin iba na istorya. “Waraʼn nagasindi sin ilawan pakatapos ginatahuban agod dili makapawa o ginabutang sa sirong san katri kundi ginatungtong ina agod makita an kapawa sana san mga tawo na nagasurulod. ");
INSERT INTO msb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sugad sani, wara sin natago na dili mahahayag kag wara sin ginsikreto na dili maaaraman kag mahahayag man. ");
INSERT INTO msb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kaya pamati gayod sin maayo kay siya na igwa pagahatagan pa, pero an wara bisan sing-ano ka dyutay an ginahuna-huna niya na ada sa iya pagakuhaon pa.” ");
INSERT INTO msb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niyan, nagpakadto kan Jesus an iya iloy kag san mga kamaranghod na lalaki pero dili sinda nakaapiki tungod san kadamuan san tawo. ");
INSERT INTO msb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kaya may nagsabi kan Jesus, “Ada sa luwas an imo iloy kag mga kamaranghod na lalaki kay gusto makigkita sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero ginsabat niya sinda, “An akon iloy kag mga kamaranghod na lalaki amo idtoʼn mga nagapamarati san surmaton san Dios kag nagatuman sani.” ");
INSERT INTO msb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Usad sin adlaw sinabihan ni Jesus an iya mga disipulos, “Hamos kita patabok san danaw.” Kaya nagsakay siya sa dako na baruto kaurupod sinda kag nagpalawod. ");
INSERT INTO msb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Taud-taod nakakaturog si Jesus. Sa katung-anan san danaw inabot sinda sin subasko kag may tubig na nakasulod na sa inda sarakyan. Nasa peligro gayod sinda. ");
INSERT INTO msb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kaya gintulos ninda siya kag ginpukaw na nagasabi, “Sir, Sir, malulunod na kita.” Nagbangon siya kag ginsugo an hangin kag an grabe na mga balod tapos nag-udong ini. Tapos malinaw na. ");
INSERT INTO msb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sinabihan niya sinda, “Nano kay wara kamoʼn pagsarig sa akon?” Nagkaharadlok sinda kag nagngalas, tapos nagapahurunga-hunga, “Sin-o daw ini kay an hangin kag mga balod ngani nagasunod sa iya kun suguon niya?” ");
INSERT INTO msb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nagdungka sinda Jesus sa lugar san Geraseno na katabok san Galilea. ");
INSERT INTO msb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Paghaw-as pa lang ni Jesus, may nagsugat sa iya na tagalungsod na lalaki na nasudlan sin mga demonyo. Dugay na, wara ini siya nagabado o nagaistar sin balay kundi sa mga rulubngan na mga kweba. ");
INSERT INTO msb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pakakita lang niya kan Jesus sumiyak kag natumba sa atubangan niya. Pakatapos nagsurmaton sin makusog, “Jesus, anak san Pinakalabaw na Dios, nano an pakilabot mo sa akon? Nakimaluoy ako sa imo, ayaw man ako pagpasakiti.” ");
INSERT INTO msb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nakasabi sani an tawo kay ginmandahan na ni Jesus an malaw-ay na espirito na lumuwas sa lawas san tawo. Ini na espirito damo naʼn beses ginapakisay-kisay an tawo. Kaya, ginapabantayan, ginakadenahan kag ginapusasan sa tiil agod mapaukoy siya, pero iya ini ginapangbugto kag ginatabog siya san demonyo sa kabukidan. ");
INSERT INTO msb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kaya ginhunga siya ni Jesus, “Nano an ngaran mo?” Nagsabat ini, “Damo,” kay damu-damo na mga demonyo an nagsulod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nakimaluoy sinda kan Jesus na dili sinda pagpalayason pakadto sa kahidaluman na waraʼn sukol. ");
INSERT INTO msb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Niyan, didto sa higad san bukid may damu-damo na mga baboy na nanginginaon. Pakakita sani nakimaluoy sa iya an mga demonyo na pasudlon na lang sinda sa mga baboy. Kaya tinugutan niya sinda. ");
INSERT INTO msb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pakatapos, an mga demonyo nagruluwas sa lawas san tawo kag nagsulod sa mga baboy. Nagharabas ini pagdaralagan palusad sa pangpang, nagkahurulog sa danaw kag nagkarulumos. ");
INSERT INTO msb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pakakita san mga parabantay san kababuyan sa nangyari, nagdaralagan sinda palungsod kag ginpamarita an inda nakita sa lungsod kag sa mga baryo didto sa patalibod. ");
INSERT INTO msb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kaya, nagkaradto an mga tawo para makita kun nano man gayod an nangyari. Pag-abot ninda kan Jesus nakita man ninda na nakaingkod sa may tiilan niya an tawo na ginluwasan san mga demonyo. Adto na siya nakaliwan na kag maayo an kaisipan kaya nagkaharadlok an mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Idto naman na mga nakakita amo an nag-istorya sa inda kun pan-o nag-ayo ini na tawo na nasudlan san mga demonyo. ");
INSERT INTO msb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pakaaram ninda sani, an tanan na mga taga-Geraseno nagahangyo kan Jesus na maghali sa inda lugar kay nagkaharadlok gayod sinda. Kaya, nagsakay gihapon sinda Jesus sa inda sarakyan agod mag-uli. ");
INSERT INTO msb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","An tawo naman na ginluwasan san mga demonyo nakimaluoy kan Jesus na tugutan siya mag-upod pero ginpauli siya ni Jesus na sinabihan, ");
INSERT INTO msb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Mag-uli ka sa iyo kag ipaaram mo sa tanan an kaayuhan na hinimo san Dios sa imo.” Kaya, naglakat an tawo kag ginparapanumat niya sa tanan na katawuhan san syudad an hinimo sa iya ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pag-abot gihapon ni Jesus sa luyo san danaw malipayon na ginsugat siya san kadamuan kay adto na sinda nagapahurulat sa iya. ");
INSERT INTO msb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Taud-taod may nag-abot man na lalaki na an ngaran Jairo na usad na namumuno san sinagoga. Lumuhod siya sa may tiilan ni Jesus kag nakimaluoy siya na kun mahimo na makakadto siya sa inda balay, ");
INSERT INTO msb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kay an iya usad-usadi na anak na babayi, na dose anyos an edad, tikamatayon. San pakadto na si Jesus, nagasurusuan an kadamuan. ");
INSERT INTO msb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Didto may babayi na ginadugo sa sulod sin dose ka tuig kag wara pa man sin bisan sin-o na nakabulong sa iya. ");
INSERT INTO msb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kaya nakisu-suan man siya sa may likudan ni Jesus kag gindutdot an sidsid san iya ginasul-ot, Insigida naudong dayon an pagparadugo sa iya. ");
INSERT INTO msb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Paglingi ni Jesus naghunga siya, “Sin-o an nagdutdot sa akon?” San magpaambot an tanan nagsurmaton si Pedro, “Maestro, nano kay nakahunga ka na ada an katawuhan nagapatalibod kag nagadiris-ukan pakada sa imo?” ");
INSERT INTO msb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero nagsabat si Jesus, “Igwa gayod sin nagdutdot sa akon kay nabatyagan ko na may nagguwa sa akon na gahom.” ");
INSERT INTO msb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pakamalisyahi san babayi na dili gali siya makatago, naghalapit na nagapangudog, nagluhod sa may tiilan ni Jesus kag ginpahayag sa atubangan san mga tawo kun nano kay gindutdot niya si Jesus kag kun pan-o siya naayo sadto mismo. ");
INSERT INTO msb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kaya, ginsabihan siya ni Jesus, “Tia, an imo pagtuod amo an nakaayo sa imo. Makalakat ka na sa kalinaw san isip.” ");
INSERT INTO msb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nagasurmaton pa si Jesus san may nag-abot na hali sa balay ni Jairo kag nagsumat, “Sir, an imo anak patay na. Siguro, dili mo na kinahanglan na samukon pa an Maestro.” ");
INSERT INTO msb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero san nabatian ini ni Jesus sinabihan niya si Jairo, “Ayaw kahadlok, magtuod ka lang sa akon kag maaayo siya.” ");
INSERT INTO msb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","San pag-abot ni Jesus sa balay ni Jairo wara siyaʼn gintugutan na mag-upod sa iya sa sulod pwera lang kanda Pedro, Juan kag Santiago, kag san mga ginikanan san bata. ");
INSERT INTO msb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nagatarangis an tanan kag nagamundo sa nangyari sa bata. Pero nagsurmaton si Jesus, “Udong na kamo pagtangis. Dili siya patay kundi natuturog lang.” ");
INSERT INTO msb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero gintarawhan siya kay aram ninda na patay na gayod an bata. ");
INSERT INTO msb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","An hinimo naman niya kinaptan an bata sa kamot kag tinawag, “Anak, bumangon ka.” ");
INSERT INTO msb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nabuhay gihapon an bata kag insigida bumangon. Kaya nagsugo si Jesus na hatagan an bata sin makaon. ");
INSERT INTO msb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nangarat an mga ginikanan san bata, pero ginmandahan sinda ni Jesus na dili magpanumat bisan kanin-o san nangyari. ");
INSERT INTO msb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Usad naman sin adlaw gintiripon ni Jesus an dose kag hinatagan sin gahom kag otoridad na makapaluwas san tanan na mga demonyo kag makabulong san mga masakiton. ");
INSERT INTO msb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tapos sinugo niya sinda para itukdo an manungod san kahadian san Dios kag magpangbulong. ");
INSERT INTO msb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Gintugon niya sinda, “Ayaw pagdara sin nano pa man sa iyo paglakat bisan tungkod, surudlan, pagkaon o kwarta kag liwanan. ");
INSERT INTO msb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","An sin-o man na panimalay na magapadayon sa iyo, didto na lang kamo mag-istar hasta na maghali kamo sana na lugar. ");
INSERT INTO msb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sadto naman na lungsod na dili magpadayon sa iyo paghali niyo sa inda taphuda anay an alpog sa iyo tiil bilang padaan na may paghusgar na maabot sa inda.” ");
INSERT INTO msb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kaya nagralakat sinda kag nagpangburubaryo sa pagtukdo san Maayo Na Barita kag pagpamulong san katawuhan bisan diin. ");
INSERT INTO msb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Niyan nabaritaan ni Herodes na namumuno san Galilea an tanan na nangyayari manungod kan Jesus didto kaya nalisang siya kay basi nabuhay gihapon si Juan na Parabunyag susog sa ginasarabi san iba na mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","An iba man nagasarabi na si Elias nagpakita gihapon kag may iba pa gayod na nagasarabi na an usad san mga kasadto na mga propeta nabuhay gihapon. ");
INSERT INTO msb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero nagsurmaton si Herodes, “Dili ako matuod na si Juan ini kay ginpapugutan ko siya, pero sin-o ini na akon nababaritaan?” Kaya mas lalo na nagahandom siya na makita si Jesus. ");
INSERT INTO msb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pagbalik san mga apostoles ginsumatan ninda si Jesus san inda nagkahirimuan. Tapos gin-agda niya ini na sinda-sinda lang pakadto sa usad na lungsod na ginatawag Betsaida. ");
INSERT INTO msb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pakaaram san katawuhan, nagsurunod man sinda kan Jesus. Kaya, gin-agda niya sinda kag gin-istoryahan manungod sa kahadian san Dios. Ginbulong man niya idtoʼn nagakinahanglan na mabulong. ");
INSERT INTO msb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","San takop na an kahapunanon nagharalapit sa iya an dose kag nagsabi, “Pahalia na an mga tawo agod makakadto sa mga baryo kag mga sitio para makapanghanap sin maistaran kag sin makaon kay adi kita didi sa mamingaw na lugar.” ");
INSERT INTO msb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero nagsabat lugod si Jesus, “Hatagi na lang niyo sindaʼn makaon.” Pero nagreklamo sinda, “Lima lang ka bilog na tinapay kag duha ka bilog na isda an amon dara pwera lang kun magbakal kita sin pagkaon para sani tanan na katawuhan.” ");
INSERT INTO msb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kay mga lima ka libo na kalalakihan an adto didto. Pero sinabihan niya an iya mga disipulos, “Paingkuda sinda sin tigsurusingkwenta kada grupo.” ");
INSERT INTO msb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sinunod ninda kag pinaingkod an tanan. ");
INSERT INTO msb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tapos, kinuha ni Jesus an lima ka bilog na tinapay kag an duha ka bilog na isda, humangad siya sa langit kag nagpasalamat sa Dios. Pagkatapos gin-utud-utod ini kag gintunol sa iya mga disipulos agod ipanghatag sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nagkaraon sinda tanan hasta na nagkaburusog. Pakatapos gintipon san mga disipulos an sobra na dose pa ka bangkat. ");
INSERT INTO msb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Usad sin adlaw san si Jesus sulo lang na nagapangadyi, naghalapit an iya mga disipulos. Tapos nagsabi siya sa inda, “Sumati daw niyo ako kun nano an pagkakilala sa akon san mga tawo.” ");
INSERT INTO msb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nagsabat sinda, “Sabi san iba na ikaw si Juan na parabunyag. An iba man na ikaw kuno si Elias, kag an iba pa gayod na ikaw kuno usad san mga kasadto na mga propeta na nabuhay gihapon.” ");
INSERT INTO msb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naghunga gihapon si Jesus, “Pero kamo, nano an pagkakilala niyo sa akon?” Nagsabat si Pedro, “Ikaw an Cristo san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Niyan, ginpadaanan gayod niya sinda na dili magpanumat bisan kanin-o man manungod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pakatapos ginsabihan pa niya sinda. “Dapat ako na Anak San Tawo magtios sin grabe. Pagapaambutan san mga kamagurangan na namumuno san mga Judio, mga namumuno san kapadian kag mga paratukdo san Kasuguan, tapos papatayon pero sa ikatulo ka adlaw bubuhayon gihapon.” ");
INSERT INTO msb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pagpadayon ni Jesus ginsabihan niya hasta an tanan, “Kun may gusto mag-upod sa akon bilang disipulos ko, dili niya dapat sundon an sadiri niya na kabubut-on kundi sundon lugod an kaburut-on ko kag pas-anon an iya krus uruadlaw na amo an pagtios tungod sa akon. ");
INSERT INTO msb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nasabi ko ini kay an nagahandom masalbar an iya buhay para sa iya sadiri mawawar-an sani, pero an maghalad san iya buhay alang-alang sa akon masasalbar lugod sani. ");
INSERT INTO msb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kay nano man an pakinabang san tawo kun mapasa iya an bilog na kinab-an kag an balyo sani amo an pagsuko o pagkawara san iya buhay? Syimpre wara gayod! ");
INSERT INTO msb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Sugad man kun may tawo na dili magaako sa akon kay ginakaalo niya ako kag san akon katukduan, ako na Anak San Tawo igakaalo man siya kag dili ko aakuon pag-abot ko sa akon glorya kag sa glorya man san akon Ama kag san mga banal na anghel. ");
INSERT INTO msb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ginasiguro ko sa iyo na igwa sin pira sa iyo na nagatindog didi na dili mapapatay hasta na makita an kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mga walo ka adlaw pakatapos niya pagsabi sani, gin-agda ni Jesus sinda Pedro, Juan kag Santiago pagsagka sa bukid para magpangadyi. ");
INSERT INTO msb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Myintras nagapangadyi siya didto, nag-iba an hitsura san iya bayhon kag nagsinggat gayod an iya bado sa kaputi. ");
INSERT INTO msb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bigla na lang may duha na lalaki na nag-abot kag nakisurmaton sa iya. Amo ini sinda Moises kag Elias. ");
INSERT INTO msb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nagpakita ini na duha na may langitnon na glorya na nakasilaw bagaʼn adlaw, kag nagsurmaton manungod sa pagtaliwan ni Jesus na mangyayari sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Niyan naman si Pedro kag san iya mga kaurupod mga maanok gayod an katurog pero pagmata ninda nakita an glorya ni Jesus kag an duha na lalaki na nagatindog kaupod niya. ");
INSERT INTO msb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","San mahali na an duha, sinabihan ni Pedro si Jesus, “Sir, maayo man na adi kita. Tugutan kami na magtindog didi sin tulo na kubung-kubong na usad sa imo, usad naman kan Moises kag usad pa kan Elias.” Dili niya namangnuhan an iya ginasabi. ");
INSERT INTO msb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Myintras nagasurmaton pa siya may madakmol na dampog kag nahandungan sinda. San matahuban na nagkaharadlok sinda. ");
INSERT INTO msb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tapos, may nabati sinda na nagasurmaton hali sa dampog, “Amo ini an akon Anak na ginpili ko. Pamatii niyo siya.” ");
INSERT INTO msb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pakatapos sadto, nakita ninda na si Jesus na lang. Kaya, ginpasabuot san mga disipulos an inda nakita kag wara gayod sin ginsumatan sadto na kaurason. ");
INSERT INTO msb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagkasunod na adlaw naglugsad na sinda hali sa bukid kag didto damu-damo na mga tawo an nagsugat kan Jesus. ");
INSERT INTO msb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Insigida may lalaki sa kadamuan na nagsiyak, “Maestro, nakimaluoy ako sa imo, pakikita man tabi san akon bugtong na anak na lalaki. ");
INSERT INTO msb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ginasudlan siya san maraot na espirito kag bigla lang na nagasiyak, ginapakisay-kisay siya hasta na magbura an ba-ba, tapos, ginaparapasakitan siya kag haros habo na maghali sa iya. ");
INSERT INTO msb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nakimaluoy ako sa imo mga disipulos na pahalion an maraot na espirito pero dili ninda kaya.” ");
INSERT INTO msb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nagsabat si Jesus, “Marasa pa kamo na mga tawo yana na panahon na waraʼn pagtuod kag mga sutil! Hasta san-o ta kamo dapat pagatiusan? Nano, hasta na lang magatios ako sa iyo?” Tapos sinabihan an lalaki, “Sige, darha didi an imo anak.” ");
INSERT INTO msb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","San nagapahalapit na kan Jesus an bata ginpasagmok siya sa duta san maraot na espirito kag ginauy-og. Pero sinaway ni Jesus an maraot na espirito kag naayo an bata. Tapos gin-uli na siya sa iya ama. ");
INSERT INTO msb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","An tanan naman nagkangarawa sa kagamhanan san Dios. San nagkakangarawa pa an tanan san mga ginhimo ni Jesus, sinabihan niya an iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Itanom niyo sa isip ini na mga surmaton, ako na Anak San Tawo iintriga sa gahom san katawuhan.” ");
INSERT INTO msb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero dili ninda nasabutan kun nano an gusto sabihon sani na iya ginsabi kay gintago ini sa inda agod dili ninda mapanginano kag nahahadlok man sinda maghunga sa iya. ");
INSERT INTO msb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Niyan, nagsuruay an iya mga disipulos kun sin-o sa inda an labaw sa tanan. ");
INSERT INTO msb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero san mapanginano ni Jesus kun nano an inda ginaisip may kinuha siyaʼn dyutay na bata, pinaingkod sa iya katakin, ");
INSERT INTO msb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kag ginsabihan sinda, “An makaako sin pareho sani na bata alang-alang sa akon ginaako man ako, kag an mag-ako sa akon ginaako man an nagsugo sa akon. Kun sugad an pinakamenos sa iyo amo an pinakalabaw sa tanan.” ");
INSERT INTO msb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Didi, nagsurmaton si Juan, “Maestro, nakakita kami sin lalaki na nagapaluwas sin mga demonyo paagi sa imo ngaran. Kaya ginbawalan namon siya kay dili man naton kaupod.” ");
INSERT INTO msb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero sinabihan siya ni Jesus, “Ayaw niyo siya pagsawaya kay an dili nagakontra sa iyo kaapin niyo.” ");
INSERT INTO msb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","San nagadangadang na an panahon san pagsakat ni Jesus sa langit, nagtuna siya pagpakadto gayod sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kaya nagsugo siya sin mga mag-una sa iya agod ihanda an pag-abot niya. Mga Samaritano an mga tawo sana na baryo. ");
INSERT INTO msb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ugaling an mga tagadidto wara magpadayon sa iya kay an tuyo gayod niya pa-Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","San maaraman ini ninda Santiago kag Juan na duha san iya mga disipulos, ginhunga siya, “Ginoo, nano, gusto mo na mag-ayo kami na pauranan sindaʼn kalayo na hali sa langit agod ugdawon sinda?” ");
INSERT INTO msb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero gin-atubang sinda ni Jesus kag gin-uritan. ");
INSERT INTO msb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pakatapos nagpadayon sinda sa masunod na baryo. ");
INSERT INTO msb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","San nagaralakat na sinda may nakasugat sinda sa kamino na tawo na nagsabi kan Jesus, “Sir, magaupod ako sa imo bisan magpakain ka.” ");
INSERT INTO msb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Didi sinabihan siya ni Jesus, “May unugan an mga garong kag an mga sapat na nagalupad may mga salag pero ako na Anak San Tawo wara ngani bisan istaran.” ");
INSERT INTO msb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","May sinabihan pa siya na tawo, “Kadi, umupod ka sa akon,” kaya lang nagsabat an tawo, “Ginoo, tuguti ako na makauli anay hasta na ikalubong ko an akon ama.” ");
INSERT INTO msb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero ginsabat siya ni Jesus, “Pabay-i na ilubong san mga tawo na bagaʼn patay san inda sadiri na mga patay pero ikaw makadto sa kadamuan kag itukdo an manungod sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","May iba pa gayod na nagsabi sa iya, “Ginoo, maupod man po ako sa imo pero mapaaram anay ako sa balay.” ");
INSERT INTO msb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sinabihan siya ni Jesus, “An nagahuyot san kaling san arado na nagaparalingi dili angay sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pakatapos sani nagpili gihapon an Ginoo sin 72 disipulos kag ginsugo sinda tigduha-duha na mag-una sa iya sa tanan na mga lungsod kag mga lugar na iya man pagakadtuan. ");
INSERT INTO msb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ginsabihan niya sinda, “Damoʼn gusto makabati san Maayo Na Barita pero kulang sa inda an mga magatukdo. Bagaʼn bugana na aranihon ini na mga tawo pero kulang lang an paraani. Kaya maghangyo kamo sa Ginoo na tag-iya san anihon agod magsugo siya sin mga paraani sa iya aranihon. ");
INSERT INTO msb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Sige, kadto na kamo pero tandai na ginasugo ta kamo bagaʼn mga karnero sa tunga san mga maisog na hayop. ");
INSERT INTO msb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ayaw kamo pagdara sin pitaka, surudlan o sandalyas kag ayaw pag-udong sa pakig-istoryahan bisan sa sin-o man na masugatan niyo sa dalan. ");
INSERT INTO msb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Sa diin man na balay na iyo suludan sabiha dayon niyo sa tag-iya, ‘Mapasa iyo an kalinawan hali sa Dios.’ ");
INSERT INTO msb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kun an nagaistar didto tawo na may kalinaw an isip hali sa Dios, mapasa inda an kalinawan pero kun dili mabalik ina sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mag-istar kamo sana na balay, kaunon niyo kag inumon an nanuman na ihanda sa iyo tungod naman na an paratrabaho dapat lang na hatagan san iya suhol. Ayaw pagparaburubalhin sin balay. ");
INSERT INTO msb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Sa kadtuan niyo na lungsod na maayo an pagpadayon sa iyo kauna an nanuman na ginhanda para sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ayuha an mga masakiton sana na lungsod kag isabi na ‘Halapit na sa iyo an oras na an Dios amo an magahadi sa iyo.’ ");
INSERT INTO msb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero sa diin man na lungsod na iyo kadtuan kag habo magpadayon sa iyo, lumuwas kamo sa inda mga kamino kag isabi, ");
INSERT INTO msb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Bisan an alpog san iyo lungsod na nakadukot sa amon mga tiil igataphod namon bilang padaan na pagakastiguhon kamo san Dios. Tandai niyo ini, an kahadian san Dios nagpahalapit na sa iyo.’ ");
INSERT INTO msb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ginasiguro ko sa iyo na pag-abot sana na adlaw san paghusgar mas pagakaluy-an san Dios an mga maraot na taga-Sodoma ki sadtoʼn mga tawo sana na lungsod na magakontra sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kamakaluluoy niyo na mga taga-Corazin! Kamakaluluoy man niyo na mga taga-Betsaida! Kun an ginhimo na mga milagro sa iyo didto paghimua kasadto sa maraot na mga syudad san Tiro kag Sidon na ginsira san Dios, dugay na an mga tagadidto nagsul-ot sin bado na ginahimoʼn sako kag nagsaburak sin abo sa inda mismo mga ulo agod ipakita na sinda nagabasol kag nagabaya san inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tungod sana mas pagakaluy-an san Dios an mga taga-Tiro kag mga taga-Sidon ki sa iyo sa adlaw san paghusgar. ");
INSERT INTO msb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kamo naman na mga taga-Capernaum, nano, gusto niyo na magpakamatanos pareho san sa langit? Itatapok lugod kamo sa impyerno.” ");
INSERT INTO msb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Kaya an nagapamati sa iyo na mga disipulos ko nagapamati sa akon. An nagasikway sa iyo nagasikway sa akon kag idtoʼn nagasikway sa akon ginasikway man an nagsugo sa akon.” ");
INSERT INTO msb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nagbalik an 72 na tawo na ginsugo na mga malipay na an sabi, “Ginoo, bisan an mga demonyo nagtuman sa amon san ginsugo namon sa ngaran mo.” ");
INSERT INTO msb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sinabihan sinda ni Jesus, “Nakita ko an pakahulog ni Satanas hali sa langit na bagaʼn kilat. ");
INSERT INTO msb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tandai, ginhatagan ta kamo sin gahom na makadaog san karautan bagaʼn pagtamak sa mga sawa kag mga uyang amo man san tanan na gahom san mga kaaway kag waraʼn makapasakit sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ayaw kamo pagkalipay dahilan na napatuman niyo an mga maraot na espirito kundi magkalipay tungod na an iyo mga ngaran nasurat sa libro na adto sa langit.” ");
INSERT INTO msb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sadto man na oras na palipay si Jesus san Espirito Santo kag nagsabi, “Ama na Ginoo san langit kag duta, nagapasalamat ako sa imo kay gintago mo ini na kaaraman sa mga madunong kag mga may pagsabot pero ginhayag mo sadtoʼn mga maluya an pagsabot sugad san mga dyutay na bata. Opo, Ama ko, kay ginkalipay mo an pagahimo sani. ");
INSERT INTO msb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Niyan, an tanan na poder ginhatag sa akon san akon Ama. Wara sin makakilala kun sin-o an Anak kundi an Ama, kag kun sin-o an Ama kundi an Anak kag sadto naman na mga ginagusto san Anak na pahayagan san manungod sa Ama.” ");
INSERT INTO msb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pakatapos, gin-atubang ni Jesus an iya mga disipulos kag nagsabi, “Palabi an nakakita san iyo nakikita, ");
INSERT INTO msb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","kay matuod gayod na damo kasadtoʼn mga propeta kag mga hadi na gusto man makakita san iyo nakikita pero wara ninda makita. Nagahandom man makabati san iyo nababatian pero wara ninda mabati.” ");
INSERT INTO msb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Igwaʼn abugado na nagtindog kag naghunga kan Jesus agod porbaran siya, “Maestro, nano an dapat ko na himuon agod masadiri ko an waraʼn katapusan na buhay?” ");
INSERT INTO msb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ginsabat siya ni Jesus, “Adto na sa Kasuguan nasurat an himuon. Nano an imo nabasa?” ");
INSERT INTO msb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nagsabat man an tawo, “‘Kamut-an mo an Ginoo na imo Dios sa imo puso, sa bilog moʼn tagipusuon, sa tanan san imo pagaisip kag paagi man sa paggamit mo san tanan na kusog sa pagsirbe sa iya,’ kag ‘kamut-an mo an imo kapwa pareho san imo sadiri.’,” ");
INSERT INTO msb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nag-uyon si Jesus, “Tama an pakasabi mo. Himua ina kag mabubuhay ka.” ");
INSERT INTO msb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero kay gusto niya na mapatanos an iya sadiri ginhunga si Jesus, “Sin-o an akon kapwa?” ");
INSERT INTO msb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nagsabat si Jesus paagi sin istorya, “Igwaʼn gintulis na Judio na naglugsad hali sa Jerusalem pakadto sa Jerico. Hinubaan siya, binaog kag binayaan na tikamatayon. ");
INSERT INTO msb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nangyari man na may padi na nagaagi sadto na dalan pero pakakita niya sa tawo linabayan lang. ");
INSERT INTO msb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sugad man may Levita na pag-abot sadto na lugar kag pakakita niya sa tawo nagtabok paluyo na dalan kag naglabay man lang. ");
INSERT INTO msb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","May Samaritano naman na kontra san mga Judio pero sa iya paglakaton nakaabot sadto na lugar kag pakakita san kamutangan san tawo naluoy. ");
INSERT INTO msb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ginhalapitan niya ini tapos ginbu-buan sin lana kag bino an mga samad sani kag ginbutukan. Pakatapos ginsakay sa iya kabayo an tawo, gindara sa usad na dayunan kag gin-ataman siya. ");
INSERT INTO msb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkaotro adlaw nagkuha siya sin kwarta na duha ka bilog na plata kag hinatag sa tag-iya san dayunan na nagasabi, ‘Atamana siya kag kun may magastos pa pagabayadan ta ikaw pagbalik ko.’,” ");
INSERT INTO msb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Niyan, ginhunga siya ni Jesus, “Sin-o sani na tulo sa paghuna mo an nagin kapwa san gintulis na tawo?” ");
INSERT INTO msb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“An tawo na naluoy sa iya,” an sabat san abugado. Sinabihan siya ni Jesus, “Kadto na kag sugad man sani an himuon mo.” ");
INSERT INTO msb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","San paglakaton ni Jesus kag san iya mga disipulos nakaabot sinda sa usad na baryo kag may babayi na an ngaran Marta na nagpadayon sa inda. ");
INSERT INTO msb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Igwa siya sin kamanghod na an ngaran Maria na nagaingkod sa may tiilan san Ginoo kag nagapamati san iya ginatukdo. ");
INSERT INTO msb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Niyan, si Marta, na nahahandal pag-asikaso san mga ginahanda, nag-apiki kan Jesus kag nagsabi, “Ginoo, dili mo ba namamalisyahan na ginapabayaan lang ako san akon kamanghod sa pagtrabaho? Pakisabi man sa iya na buligan ako.” ");
INSERT INTO msb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ginsabat siya san Ginoo: “Marta, Marta, nahandal ka kag nalilisang san damo na mga bagay, ");
INSERT INTO msb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero usad lang an kinahanglan. Amo ini an ginpili ni Maria na maayo na parte na dili mahahali sa iya.” ");
INSERT INTO msb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Usad sin bes nagapangadyi si Jesus sa usad na lugar. Pakatapos niya usad san iya mga disipulos naghangyo, “Ginoo, tukdui man kami pagpangadyi na pareho man san gintukdo ni Juan na Parabunyag sa iya mga disipulos.” ");
INSERT INTO msb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kaya ginsabihan niya sinda, “Pagpangadyi niyo sabihon, ‘Ama, pagalangan an banal mo na ngaran. Mag-abot lugod an pagahadi mo. ");
INSERT INTO msb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hatagi kami san amon kinahanglan na pagkaon uruadlaw. ");
INSERT INTO msb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patawada kami san amon mga sala kay ginapatawad namon an tanan na mga nakasala sa amon. Ayaw man kami pagtuguti na masugtan.’,” ");
INSERT INTO msb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sinabihan pa sinda ni Jesus, “Ipamutang ta na usad sa iyo may kaamigo na nagkadto sa iya na tungaʼn gab-i kag nagsabi, ‘Migo, pahurama man anay ako sin tulo ka bilog na tinapay, ");
INSERT INTO msb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kay may kakilala ako na nag-abot sa balay hali sa paglakaton kag wara akoʼn ikapakaon sa iya.’ ");
INSERT INTO msb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Tapos ginsabat siya san nasa sulod, ‘Ayaw na ako pag-ulanga. Sirado na kag nagahirigda na kami san mga bata. Dili na ako mabangon para hatagan ka san panginahanglan mo.’ ");
INSERT INTO msb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ugaling, matuod gayod na mabangon siya agod ihatag an tanan na pagkinahanglan san iya amigo, dili dahilan san inda pag-amigo kundi dahilan san pagpakimaluoy san usad. ");
INSERT INTO msb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kaya tandai an ginasabi ko sa iyo, mangayo sa Dios kay pagahatagan kamo. Maghanap kay ipapakita niya sa iyo. Magtawag sa iya kay pagaabrihan niya an pwertahan sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Himuon niyo ini kay an nangangayo sa Dios amo an pagahatagan. An nagahanap amo an makakita kag an nagatawag sa iya amo an pagaabrihan san pwertahan. ");
INSERT INTO msb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Niyan, halimbawa, sin-o sa iyo na mga ama an mahatag sin sawa sa iya anak kun mangayo siyaʼn isda, ");
INSERT INTO msb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","o kaya uyang kun mangayo iniʼn itlog? ");
INSERT INTO msb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kun kamo ngani na mga maraot an ugali maaram maghatag sin mga maayo na bagay sa iyo kaanakan, sing-ano pa gayod ada an iyo Ama sa langit an mahatag san Espirito Santo sadtoʼn mangayo sa iya?” ");
INSERT INTO msb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Usad sin bes may ginapahali na demonyo si Jesus kay amo ini an nakapaapa sa tawo, pero pakahali lang san demonyo nakasurmaton na an apa kag nangawa an mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero may iba sa inda na nagsabi, “Paagi lang kan Beelzebul na namumuno san mga demonyo an pagpaluwas niya san mga demonyo.” ");
INSERT INTO msb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Myintras may iba naman nagpangayo kan Jesus sin milagro bilang tanda agod porbaran na hali man gayod siya sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero kay aram niya an inda ginaisip ginsabihan sinda, “Maruruba an kahadian na pirme may araraway sa inda mismo. Amo man magaburulag an pamilya na pirme may araraway sa inda mismo. ");
INSERT INTO msb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sugad man kun si Satanas mismo ginakontra an iya sadiri na mga sakop, pan-o magapadayon an iya pagahadi? Nagahunga ako sani kay nagasabi kamo na paagi kan Beelzebul nagapahali ako sin mga demonyo. ");
INSERT INTO msb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Niyan, kun paagi kan Beelzebul nagapaluwas ako san mga demonyo, kanin-o man gali poder na nahimo man ini san iyo mga katawuhan? Kaya ini sinda mismo an magapamatuod na sala kamo. ");
INSERT INTO msb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ugaling kun paagi sa poder san Dios an pagpaluwas ko san mga demonyo, ina nagapamatuod na an pagahadi san Dios adi na sa iyo.” ");
INSERT INTO msb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nagpadayon pa si Jesus, “Kay kun ipamutang ta sa makusog na armado na tawo pirme nagabantay sa iya balay, dili siya makakawatan bisan nano, ");
INSERT INTO msb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","pero kun dayuhon siya san mas makusog pa sa iya, madadaog siya kag an tanan na armas na iya ginsarigan aagawon kag pagabarahinon an mga nakawat sa iya. ");
INSERT INTO msb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kun sugad an dili nakiupod sa akon mga kontra gayod sa akon kag an dili nagabulig sa akon pagtipon nagapaburulag lugod. ");
INSERT INTO msb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ipahalimbawa ta naman sa maraot na espirito,” an sabi ni Jesus. “Pagluwas sani sa tawo nagaagi-agi ini sa mga disyerto agod maghanap sin mapahuwayan pero kay waraʼn mahanapan kaya masabi, ‘Mabalik ako sa akon ginhalian na istaran.’ ");
INSERT INTO msb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pag-abot sani didto nakita na waraʼn sulod, malinis kag gin-ayo na idto. ");
INSERT INTO msb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kaya magahali gihapon ini kag magatiripon pa sin pito na espirito na mas maraot pa ki sa iya. Didto sinda masulod kag maistar. Dahilan sani mas grabe an kamutangan sadtoʼn tawo ki san dati.” ");
INSERT INTO msb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nagasurmaton pa si Jesus san may babayi didto sa kadamuan na nagsiyak, “Pinalabi gayod san Dios an babayi na nagbudos kag nagpadudo sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero nagsabat si Jesus, “Mas palabi pa gayod idtoʼn nagapamati san katukduan manungod sa Dios kag nagatuman sani.” ");
INSERT INTO msb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Myintras nagadamo an mga tawo nagpadayon pagsurmaton si Jesus, “Sing-ano ka makasasala an mga katawuhan yana! Nagaparapangayo sindaʼn tanda pero waraʼn ipapakita sani kundi an pareho san nangyari sa propeta na si Jonas. ");
INSERT INTO msb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sugad san siya nagin tanda sa mga taga-Nineve paagi sa pag-istar niya sin tulo ka adlaw sa tiyan san dako na isda sa dagat pero nakaluwas gihapon na buhay, sugad man ako na Anak San Tawo magin tanda man sani na mga tawo yana na panahon. ");
INSERT INTO msb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sa adlaw san paghusgar an reyna san lungsod na ginatawag Sheba matindog kaupod an mga tawo sani na panahon kag pagakondinaron sinda, kay hali pa gayod siya sa harayo na lugar san kinab-an para mamati san kadunungan ni Solomon, pero kitaa, adi na yana an mas labaw pa ki kan Solomon. ");
INSERT INTO msb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sa adlaw san paghusgar an mga tawo naman san Ninive matindog kaupod ini na mga tawo kag kukondinaron sinda kay nagbasol sinda kag nagbaya sa inda pagkasala dahilan san katukduan ni Jonas pero, kitaa, adi an mas labaw pa ki sa iya.” ");
INSERT INTO msb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Didi naman nagpadayon si Jesus pagsabat sa inda na gusto makakita sin tanda, “Waraʼn masindi sin ilawan tapos itago o isulod sa baldi kundi ginabutang sa dapat na tungtungan sani agod an kapawa makita san mga nagasurulod. ");
INSERT INTO msb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pareho san ilaw an imo mata para sa lawas. Kun maayo an imo mata mapapawaan man an bilog mo na lawas pero kun maraot an imo mata madulom man an bilog mo na lawas. ");
INSERT INTO msb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kun sugad makasiguro ka na an ilaw na nasa sulod sa imo dili ngani madulom. ");
INSERT INTO msb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kay kun an imo lawas puno sin kapawaan kag waraʼn parte na madulom magigin mapawa iniʼn biyo na pareho san ilawan na nagabanaag sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nakatapos pa lang si Jesus pagsurmaton san may Pariseo na nag-imbitar sa iya na magkaon sa inda. Nagdayon siya kag nag-ingkod sa may lamesa. ");
INSERT INTO msb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nangarat an Pariseo san makita siya na wara anay maghugas antes magkaon. ");
INSERT INTO msb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaya ginsabihan siya san Ginoo, “Kamo na mga Pariseo! Ginalinisan niyo an sa luwas san lawas sugad san paglinis san tasa kag plato pero an sa sulod san lawas maraot gayod dahilan sa kapasluan kag karautan. ");
INSERT INTO msb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga buang! Dili ba an Dios na naghimo san sa luwas amo man an naghimo san sa sulod? ");
INSERT INTO msb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dapat magbahin anay san sa imo sa mga pobre kag an tanan magigin malinis para sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makaluluoy man gihapon kamo na mga Pariseo! Ginahalad niyo an ikanapulo na parte bisan an pinakamenos san iyo mga produkto pero napapabayaan niyo an katanusan kag pagkamuot san Dios! Amo ini an dapat niyo sunudon na dili man gihapon napapabayaan an iba. ");
INSERT INTO msb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makaluluoy man kamo na mga Pariseo kay naiila pirme mag-ingkod sa pinakaunahan san mga sinagoga kag naiila man paggalangan sa may merkado. ");
INSERT INTO msb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Makaluluoy pa kamo kay baga kamoʼn mga lubungan na waraʼn tanda. Kaya bagaʼn natatamakan san mga tawo na dili nakikilalahan an pagkadunot didto.” ");
INSERT INTO msb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Didi usad na paratukdo san Kasuguan san mga Judio an nagsurmaton, “Maestro, kun nagasurmaton kaʼn irog sani ginatuya mo man kami.” ");
INSERT INTO msb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero ginsabat ni Jesus, “Makaluluoy man kamo na mga paratukdo san Kasuguan kay ginapahimo niyo an mga tawo sin mga malisod na panurundon na dili kaya pero kamo mismo habo ngani magtikwil bisan usad na tudlo sa pagbulig sa inda. ");
INSERT INTO msb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Makaluluoy man kamo kay ginatindog niyo an mga rulubngan san mga propeta na ginpatay san iyo mga kalulululuhan! ");
INSERT INTO msb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kaya paagi sani nagapamatuod kamo kag nagauyon san ginhimo san iyo mga kalulululuhan. Sinda an nagpatay kag kamo naman an nagatindog san rulubngan. ");
INSERT INTO msb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dahilan sani sa iya kadunungan nagsabi an Dios, ‘Magasugo ako sa inda sin mga propeta kag mga apostoles na an iba pagapatayon ninda kag an iba naman pagapasakitan. ");
INSERT INTO msb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kaya ini na mga tawo yana amo an manabat tungod san pagpatay sa mga propeta tuna san paglalang san kinab-an. ");
INSERT INTO msb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ini nagtuna sa dugo ni Abel hasta sa dugo ni Zacarias na ginpatay sa katung-anan san altar kag san pinakabanal na lugar sa templo. Matuod gayod na ini na mga tawo yana amo an magapanabat san tanan. ");
INSERT INTO msb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Makaluluoy pa gayod kamo na mga paratukdo san Kasuguan kay kinuha niyo an lyabi san pwertahan sa pakaaram san manungod sa pagkasalbar na kamo mismo wara magsurulod kag gin-ulang pa niyo an mga nagasulod.” ");
INSERT INTO msb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Paghali ni Jesus didto grabe an pagpakaraot sa iya san mga paratukdo san Kasusugan kag mga Pariseo kag ginapirit gayod siya na magsabat san damo ninda na mga hunga, ");
INSERT INTO msb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","agod madakop ninda siya sa nano man na sala na basi maisurmaton niya. ");
INSERT INTO msb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","San libo-libo na an mga tawo na nagtiriripon haros nagapataramak-tamak na sinda. Didi nagtuna si Jesus pagsurmaton anay sa iya mga disipulos. “Paglikay kamo sa lebadura san mga Pariseo na amo an pagsagin-sagin. ");
INSERT INTO msb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero mahahayag an tanan na natatago kag an tanan na ginatahuban maaaraman. ");
INSERT INTO msb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sugad man an nano na ginsabi niyo sa kadulman mababatian man sa kapawaan kag an nano man na iyo ginahutik sa sulod san kwarto igasiyak hali sa mga kabubungan.” ");
INSERT INTO msb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga amigo ko, tandai an ginasabi ko sa iyo, ayaw kamo kahadlok sadtoʼn mga makapatay san lawas na pakatapos sana wara naʼn mahimuan pa, ");
INSERT INTO msb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","kundi ipapaaram ko an dapat niyo kahadlukan: kahadluki an Dios na pakatapos pagpatay may gahom na magtapok sa iyo sa impyerno. Matuod gayod na siya an dapat niyo kahadlukan. ");
INSERT INTO msb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dili ba an baligyaan sin lima na maya duha ka sentimos? Pero bisan usad man sani dili nalilimutan sa mata san Dios. ");
INSERT INTO msb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hasta an mga buhok niyo sa ulo binilang tanan san Dios. Kaya ayaw kamo kahadlok. Mas mahalaga kamo ki sa damo na mga maya.” ");
INSERT INTO msb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nagpadayon pa si Jesus, “Matuod gayod na an nagaako sa atubangan san mga tawo na siya para sa akon, amo man an pagahimuon ko na Anak San Tawo sa iya sa atubangan san mga anghel san Dios. ");
INSERT INTO msb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero an magsabi sa atubangan san mga tawo na dili siya para sa akon amo man an pagahimuon ko sa iya sa atubangan san mga anghel san Dios. ");
INSERT INTO msb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","An nagapakaraot sa akon na Anak San Tawo pagapatawadon pero an magtuya-tuya sa Espirito Santo dili mapapatawad. ");
INSERT INTO msb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Niyan, ayaw kamo kahandal kun pan-o an pagsabat niyo o kun nano an iyo isasabi kun darhon kamo sa mga sinagoga kag iatubang sa mga namumuno kag mga may otoridad. ");
INSERT INTO msb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pag-abot sana na oras an Espirito Santo amo an magatukdo sa iyo kun nano an iyo igasabat.” ");
INSERT INTO msb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Igwa sin tawo sa kadamuan na nagsabi sa iya, “Maestro, sabihi man an akon kamanghod na bahinan ako san amon irensya.” ");
INSERT INTO msb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ginsabat siya ni Jesus, “Amigo, sin-o an nagpili sa akon na magin huwes niyo o parabahin san iyo irensyahon?” ");
INSERT INTO msb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pakatapos ginsabihan niya sinda, “Paghimat gayod kamo kag paglikay sa nano man na klaseʼn kapasluan kay an buhay san tawo wara sa kadamo san iya kasadirihan.” ");
INSERT INTO msb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pakatapos nagsurmaton si Jesus sa inda sin istorya na amo ini, “May mayaman na tawo na abunda an ani sa iya uma. ");
INSERT INTO msb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kaya nag-isip-isip siya, ‘Nano daw an dapat ko himuon kay wara na akoʼn mabutangan san mga naani?’ ");
INSERT INTO msb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Pakaisip nagsabi siya sa iya sadiri, ‘Ah, amo ini an akon hihimuon. Rurubaon ko an akon mga kamarin tapos magapatindog akoʼn mas daragko pa kag didto ko sasarayon an tanan ko na mga naani kag san iba pa na mga kasadirihan ko.’ ");
INSERT INTO msb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pakatapos, masabi ako sa akon sadiri, ‘Damo ka naʼn nasaray na mga bagay para sa mga maabot na mga tuig! Magpahayahay ka na lang, magkaon, mag-inom kag magkalipay!’ ");
INSERT INTO msb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Pero ginsabihan siya san Dios, ‘Buang ka! Yana mismo na gab-i babawion ko an imo buhay. Tapos kanin-o mapakadto an mga bagay na ginpreparar mo?’ ");
INSERT INTO msb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Kaya amo ini an mangyayari sa tawo na nagapayaman sa iya sadiri pero dili nagapayaman sa mga bagay manungod sa Dios.” ");
INSERT INTO msb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pakatapos pag-istorya sani nagsabi naman si Jesus sa iya mga disipulos, “Kun kaya ngani tandai an ginasabi ko sa iyo, ayaw kahandal kun nano an iyo kakaunon agod mabuhay o kun nano an ibabado sa iyo lawas. ");
INSERT INTO msb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nasabi ko ini kay igwaʼn mga mas mahalaga pa sa pagkabuhay ki sa pagkaon kag sa lawas ki sa bado. ");
INSERT INTO msb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kitaa an mga sapat. Dili sinda nagahasok o nag-ani man. Wara sindaʼn kamarin ni umahan pero ginapakaon sinda san Dios. Niyan, kamo pa ada na mahalaga ki sa mga sapat! ");
INSERT INTO msb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sin-o sa iyo an pwede makasumpay san iya buhay bisan usad lang ka oras paagi san iya kahandalan? Wara gayod! ");
INSERT INTO msb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kun dili ngani kamo nakahimo san dyutay na bagay sugad sana nano man kay nagaparahandal kamo san iba pa? ");
INSERT INTO msb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kitaa kun pan-o nagatubo an mga burak. Dili ini nagatrabaho o nagatahiʼn bado pero tandaan an sasabihon ko sa iyo na bisan si Solomon na mayaman gayod wara nakasul-ot sin pareho katahom san usad man sani na mga burak. ");
INSERT INTO msb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kaya, kun ginabaduan ngani san Dios an dinghot sa kabukidan na yana buhay kag pagkabuwas igadabok, mas lalo pa ada kamo na dili pagabaduan san Dios. Mga kulang gayod kamo sin pagtuod! ");
INSERT INTO msb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kaya ayaw kamo pagparapalipong kun nano man an iyo kaunon o inumon. Ayaw kahandal! ");
INSERT INTO msb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","An mga waraʼn pagtuod didi sa kinab-an amo an nagapalipong sani tanan pero an iyo Ama maaram na kinahanglan niyo ini. ");
INSERT INTO msb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kundi handuma anay lugod niyo an pagahadi san Dios sa iyo pagkabuhay kay ina na mga bagay igahatag na lang sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mga pinalangga ko na disipulos, ayaw kamo kahadlok kay ginakalipay san iyo Ama na pagapabahinon kamo sa iya pagahadi. ");
INSERT INTO msb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kun sugad ibaligya an iyo mga kasadirihan kag ipanghatag an kabaklanan sa mga pobre. Magkaigwa kamoʼn surudlan na dili madudunot, kayamanan sa Dios sa langit na dili mawawara kag didto wara man sin makawat na makakuha o kuraratsa na makutkot sana. ");
INSERT INTO msb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nasabi ko ini kay kun hain an iyo kayamanan adto man an kaila san iyo tagipusuon. ");
INSERT INTO msb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Talinguhaa na pirme kamo nakabado kag handa sa pagsirbe sa Dios pareho sa mga suruguon na nagahulat sa inda amo pagbalik sani hali sa kasalan. Adto na sinda handa kag nakasindi an mga ilawan agod maabrihan dayon kun magpaabri ini. ");
INSERT INTO msb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Papalabihon idtoʼn mga suruguon na naabtan san amo na mata kag nagahulat sa iya pagbalik. Matuod gayod na magapreparar siya, pagapaingkudon sinda sa lamesa kag pagasirbihan. ");
INSERT INTO msb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Malipay sinda kun maabtan na preparado abir tungaʼn gab-i o maaga. ");
INSERT INTO msb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandai niyo ini na kun may tag-iya san balay na aram an oras pagkagab-i na magaabot an makawat, dili siya mapabaya na makasulod ini sa iya balay. ");
INSERT INTO msb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaya kamo man dapat maghanda kay magaabot ako na Anak San Tawo sa oras na dili niyo ginalauman.” ");
INSERT INTO msb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Naghunga si Pedro, “Ginoo, para lang ba sa amon ini na istorya o para sa tanan?” ");
INSERT INTO msb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nagsabat an Ginoo, “Sin-o baga an matinumanon kag madunong na katiwala? Siya an ginpaniwalan san iya amo sa iba pa na mga suruguon agod magpakaon sa inda sa tama na oras. ");
INSERT INTO msb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kaya malipay ina na suruguon kun ina an ginahimo niya pagbalik san iya amo. ");
INSERT INTO msb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ginasiguro ko sa iyo na an tanan na mga kasadirihan san amo igapaniwala sana na suruguon. ");
INSERT INTO msb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero kun ina na suruguon mag-isip na, ‘Wara pa gali magbalik an akon amo.’ Tapos ginapambaog an mga suruguon na lalaki kag babayi kag sige an kalipay sa kakakaon kag kahuhubog. ");
INSERT INTO msb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Myintras ginahimo niya ini maabot an iya amo sa adlaw na dili niya ginalauman kag sa oras na dili niya aram. Tapos kakastiguhon siya sin grabe kag ibibiyo sa mga sutil. ");
INSERT INTO msb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Niyan, kakastiguhon sin grabe idtoʼn suruguon na nakaaram san pagbuot san iya amo pero dili man ginatuman. ");
INSERT INTO msb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ugaling dyutay lang an kastigo sadtoʼn dili maaram kag nagakasala san dapat ikakakastigo sa iya. An ginhatagan sin damo hahanapan man sin damo kag idtoʼn ginsarigan sin dako pagalauman man sin sobra.” ");
INSERT INTO msb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nagpadayon si Jesus, “An pagdara sa kinab-an san kalayo an dahilan kun nano kay nagkadi ako kag ginahandom ko na kuntani nagalaad na ina! ");
INSERT INTO msb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dapat ako mabunyagan sa pagtios kag ginakulbaan gayod ako hasta na matapos ini! ");
INSERT INTO msb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nano, nagahuna kamo na nagkadi ako para magdara sin kalinaw sa duta? Tandai an ginasabi ko sa iyo, dili kalinaw kundi sin pagkaburulag. ");
INSERT INTO msb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kay magtuna yana an pamilya na may lima na myimbro pagapakurontrahon: tulo kontra sa duha kag duha kontra sa tulo. ");
INSERT INTO msb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Magakorontrahan sinda! An ama kontra sa anak na lalaki kag an anak na lalaki kontra sa iya ama. An iloy kontra sa anak na babayi kag an anak na babayi kontra sa iloy. An ugangan na babayi kontra sa umagad na babayi kag an umagad na babayi kontra sa ugangan na babayi.” ");
INSERT INTO msb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nagsurmaton gihapon si Jesus sa kadamuan, “Kun makakita kamo sin dampog na hali sa banda kalundan masabi dayon kamo na tikauranon tapos amo man gayod ina. ");
INSERT INTO msb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Usad pa, kun mabatyagan niyo an hangin sa timugan masabi kamo na maragit an init kag tama ina. ");
INSERT INTO msb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mga pakitaʼn-tawo lang! Maaram kamo san kamutangan san langit kag duta pero nano man kay dili kamo maaram san mga nangyayari yana? ");
INSERT INTO msb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Niyan, nano kay dili niyo mismo husgaran kun nano an tama? ");
INSERT INTO msb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Halimbawa, kun mag-atubang ka sa husgado kaupod san imo kontra, talinguhaon mo na sa dalan pa lang makipag-ayuhan ka na sa iya kay basi iatubang ka sa huwes tapos iintriga ka sa pulis kag prisuhon ka. ");
INSERT INTO msb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ginasiguro ko sa imo, kun ina an mangyayari dili ka gayod makaluwas hasta na mabayadan mo an ultimo sentimo san imo multa.” ");
INSERT INTO msb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sadto man na kaurason may mga adto didto na nagbarita kan Jesus manungod sa ginpapatay ni Pilato na mga taga-Galilea myintras nagahalad sinda sin mga sakripisyo sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kaya ginhunga niya sinda, “Nano sa paghuna niyo kay nagtios sinda sin sugad? Nano, mas grabe kamakasasala ini na mga taga-Galilea ki san iba sa inda? ");
INSERT INTO msb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Matuod gayod na ginasabihan ta kamo, dili sinda irog sana kag kun sugad kun dili kamo magbasol kag magbaya san iyo pagkasala mapapatay man kamo na pareho sa inda. ");
INSERT INTO msb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nano man sa paghuna niyo manungod sadtoʼn disiotso ka tawo na naumpagan san tore sa Siloam kag nagkamaratay? Nano, mas makasasala sinda ki san iba na mga tawo na nagairistar sa Jerusalem? ");
INSERT INTO msb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Matuod gayod na ginasabihan ta kamo na dili sinda irog sana pero kun dili kamo magbaya san iyo pagkasala mamamatay man kamo na pareho sa inda.” ");
INSERT INTO msb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tapos gin-istoryahan niya sinda sani, “May nagtanom sin kahoy na ginatawag higera sa iya uma. Pakatapos san paghanap niyaʼn bunga wara gayod sin nakita. ");
INSERT INTO msb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaya ginsabihan niya an parabantay, ‘Kitaa, tulo na ako ka tuig sin kabalik-balik para maghanap sin bunga sani na higera pero wara gayod ako makakita. Puuha kay kanugon pa san duta na gintanuman sani.’ ");
INSERT INTO msb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Pero ginsabat siya san parabantay, ‘Sir, pabayai lang anay sin usad pa ka tuig kag hatagi akoʼn panahon hasta na mabayu-bo an patalibod sani kag maabunuhan gihapon. ");
INSERT INTO msb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tapos kun magbunga sa otro tuig maayo gayod pero kun dili, pungunon mo.’,” ");
INSERT INTO msb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pagkaadlaw san Pagpahuway nagtukdo si Jesus sa usad san mga sinagoga. ");
INSERT INTO msb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","May babayi didto na disiotso anyos ginpapilay san maraot na espirito. Dili siya nakatiso kundi ku-ko na gayod. ");
INSERT INTO msb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pakakita sa iya ni Jesus tinawag kag sinabihan an babayi, “Maayo ka na sa imo sakit.” ");
INSERT INTO msb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pakadapati niya sa babayi san iya kamot insigida naayo siya kaya nag-umaw sa Dios. ");
INSERT INTO msb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero naurit an namumuno san sinagoga kay nagpangayo si Jesus sa Adlaw San Pagpahuway kaya nagsabi sa mga tawo, “Igwa sin unom ka adlaw para sa pagtrabaho. Magkadi kamo sana na mga adlaw kag magpaayo pero dili sa Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ginsabat siya san Ginoo, “Mga pakitaʼn-tawo lang! An kada usad sa iyo ginahubadan an iyo baka o kabayo sa turil kun Adlaw San Pagpahuway agod makaluwas para makainom. ");
INSERT INTO msb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Amo man ini na babayi na kaapu-apuhan ni Abraham na sa disiotso anyos na gakot ni Satanas. Dili ba maayo na hubadan siya sa Adlaw San Pagpahuway?” ");
INSERT INTO msb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","San pakasurmaton niya sani nagkaaraluhan an tanan na nagakontra sa iya pero an tanan na mga tawo nagkarilipay sa mga makangangalas na ginhimo niya. ");
INSERT INTO msb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kaya naghunga si Jesus, “Nano ko ipapareho sa kahadian san Dios? Sa nano ko ikakakumparar ini? ");
INSERT INTO msb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Pareho ini san pisog san mustasa na gintanom san tawo sa iya taramnan. Pakatapos nagdako ini kag nagin kahoy. Kaya an mga sapat nagasaralag sa mga sanga sani.” ");
INSERT INTO msb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Naghunga gihapon si Jesus sa inda, “Sa nano ko ikapareho an kahadian san Dios? ");
INSERT INTO msb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Magadako ini pareho na kun ginmiskla san babayi an pampaalsa na lebadura sa tulo ka sukol na arina, nag-alsa an bilog na minasa.” ");
INSERT INTO msb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pakaistorya nagpadayon si Jesus paglakaton sa mga kalungsudan kag kabaryuhan na nagatukdo myintras nagapakadto sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","May naghunga sa iya, “Ginoo, pipira lang ba an masasalbar?” Kaya ginsabihan niya sinda, ");
INSERT INTO msb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Talinguhaa na makaagi kamo sa masigpit na pwertahan sa langit kay damo an gusto na makaagi pero dili makasulod. ");
INSERT INTO msb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kay halimbawa sugad sani, sa oras na magtindog an tagbalay kag sirahan an pwerta ada kamo sa guwa magaparapaabri kag magtawag, ‘Ginoo, abrihi man tabi kami.’ “Pero sasabaton kamo niya, ‘Dili ko aram kun tagadiin kamo!’ ");
INSERT INTO msb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Pakatapos masabi kamo, ‘Dili ba nag-urupod kita kasadto pagkaon kag pag-inom? Nano, dili ka nagtukdo sa amon lungsod?’ ");
INSERT INTO msb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Pero masabat siya, ‘Dili ko gayod aram kun tagadiin kamo. Maglayas kamo tanan na mga parakasala!’ ");
INSERT INTO msb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Didto maganguruyngoy kamo kag magaragot an iyo ngipon pakakita niyo kanda Abraham, Isaac, Jacob kag san tanan na mga propeta sa kahadian san Dios pero kamo mismo ginpaluwas. ");
INSERT INTO msb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","May mga tawo na magaarabot hali sa tanan na parte san kinab-an, sa may sirangan kag kalundan, sa may amihan kag timog na makiatubang sa may lamesa sa kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaya may mga tawo na naurhi yana na mauuna kag may mga nauna yana na mauurhi naman.” ");
INSERT INTO msb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sadto man na oras may nag-arabot na pira na mga Pariseo kag ginsabihan ninda si Jesus, “Humali ka sani na lugar kay gusto ka ipapatay ni Herodes.” ");
INSERT INTO msb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nagsabat siya, “Kadto kamo kag sabihi ina na buwaon, ‘Kitaa, nagapaluwas ako san mga demonyo, nagapamulong yana kag buwas kag sa ikatulo ka adlaw matatapos na an trabaho ko.’ ");
INSERT INTO msb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero yana, buwas kag sa masunod pa na adlaw magapadayon gihapon ako paglakat kay dili angay sa propeta na mapatay sa luwas san Jerusalem.” ");
INSERT INTO msb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tapos nagsabi siya manungod sani, “Mga taga-Jerusalem, mga taga-Jerusalem, marasa pa kay ginapatay niyo an mga propeta kag ginabato idtoʼn mga ginsugo sa iyo san Dios! Kadamo na beses ngani na ako nagahandom na tipunon kamo na mga katawuhan pareho san umagak na ginatiripon an iya mga piso sa idalom san iya mga pakpak pero ginhabuan niyo! ");
INSERT INTO msb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tandai, pagapabayaan an iyo kabalayan. Tandaan an masasabi ko sa iyo: dili na niyo ako makikita hasta na magsabi kamo na, ‘Palabihon lugod san Dios an nagapakadi sa ngaran san Ginoo!’,” ");
INSERT INTO msb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Usad naman na Adlaw San Pagpahuway san si Jesus nakikaon sa balay san usad sa mga ginakilala na Pariseo ginamasdan gayod siya sani kag san mga kaurupod. ");
INSERT INTO msb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Didto man sa atubangan ni Jesus may tawo na hurubag an mga batiis kag butkon, ");
INSERT INTO msb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","kaya ginhunga niya an mga abugado kag mga Pariseo, “Nano, kontra ba sa aton Kasuguan an pagpamulong kun Adlaw San Pagpahuway?” ");
INSERT INTO msb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero waraʼn nakaribok sa inda kaya hinuyutan niya an tawo, ginpaayo kag pinauli. ");
INSERT INTO msb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pakatapos ginhunga gihapon niya, “Kun igwa didi sa iyo sin may anak na mahulog sa bubon o an baka man, nano, dili ba niya ini haw-ason dayon bisan sa Adlaw San Pagpahuway? Syimpre!” ");
INSERT INTO msb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wara gihapon sin nakasabat sani sa inda. ");
INSERT INTO msb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Niyan kay nariparuhan niya didto an pagpili san mga bisita san importante na ingkudan, ginsurmatunan niya sinda sani na istorya. ");
INSERT INTO msb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Nagsabi siya, “Kun imbitaran ka sa kinasal ayaw pag-ingkod sa pinakamaayo na pwesto kay basi may gin-imbitaran na tawo na mas kilala ki sa imo. ");
INSERT INTO msb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tapos apikihon ka san nag-imbitar sa imo kaupod idtoʼn bisita kag sabihon, ‘Ipahunod na lang an imo ingkudan sani na tawo.’ Sa imo kaalo mahali ka kag mabalhin sa pinakamenos na pwesto. ");
INSERT INTO msb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kundi kun imbitado ka dumiretso sa pinakamenos na pwesto kag didto ka mag-ingkod kay agod pag-abot san nag-imbitar masabi siya, ‘Amigo, hamos kita didto sa maayu-ayo na pwesto.’ Sana na paagi makikita san tanan na kaurupod mo sa lamesa na ginagalangan ka. ");
INSERT INTO msb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay an nagapakalabaw papakamenuson kag an nagapakamenos papalabawon.” ");
INSERT INTO msb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pakatapos sinabihan ni Jesus an nag-imbitar sa iya, “Kun maghatag kaʼn ponsya ayaw lang pag-imbitari an imo mga amigo, mga kamaranghod, mga igmanghod o an mga mayaman mo na katakin kay pagaimbitaran ka man ninda kag paagi sani makabalos na sinda sa imo. ");
INSERT INTO msb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kundi kun magpaponsya ka imbitari an mga pobre, mga pilay, mga paki kag mga buta. ");
INSERT INTO msb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kay tungod sani bibendisyunan ka san Dios kay dili sinda makabalos sa imo kundi pagabalusan ka sa pagkabuhay gihapon san mga matanos.” ");
INSERT INTO msb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pakabati sani sadtoʼn usad san nagakaraon sa lamesa sinabihan si Jesus, “Malipay idtoʼn makakaon sa ponsya sa kahadian san Dios!” ");
INSERT INTO msb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero ginsabat siya ni Jesus, “Nakapareho ina sani na istorya. Igwaʼn tawo na pagpreparar niyaʼn dako na ponsya nangimbitar sin damu-damo na katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pag-abot san oras san ponsya ginsugo niya an suruguon na sabihon sadtoʼn mga inimbitaran, ‘Kadi na kamo kay an tanan preparado na!’ ");
INSERT INTO msb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pero an tanan nagbaralibad. An una nagsabi, ‘Nakabakal akoʼn duta kag makadto ako para kitaon ini kaya ikaw na lang an bahala magpasensya.’ ");
INSERT INTO msb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“May usad naman na nagsabi, ‘Nakabakal ako sin lima na padis na baka kag mapakadto na ako agod kitaon kun matiano. Kaya ikaw na lang an bahala sa akon magpasensya.’ ");
INSERT INTO msb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“An usad naman amo ini an balibad, ‘Kakakasal ko lang kaya dili ako makakadto.’ ");
INSERT INTO msb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Pagbalik san suruguon ginsumat niya ini sa iya amo. Kaya sa kaurit san amo ginsugo gihapon niya ini, ‘Dali kag kumadto ka sa mga kamino kag mga dalan san lungsod kag darha pakadi an mga pobre, an mga pilay, an mga buta kag san mga paki.’ ");
INSERT INTO msb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Pagbalik naman san suruguon nagsumat, ‘Sir, natuman an ginmanda mo pero igwa lang gihapon sin bakante.’ ");
INSERT INTO msb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kaya sinabihan san amo an iya suruguon, ‘Kumadto ka sa mga kaumahan kag mga kasityuhan kag piriton mo na magkadi an mga tawo agod mapuno gayod an akon balay. ");
INSERT INTO msb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ginasiguro ko gayod sa iyo na wara sadtoʼn mga gin-imbitaran an makatilaw san akon ponsya!’,” ");
INSERT INTO msb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Niyan damu-damo na mga tawo an nag-urupod kan Jesus sa iya paglakat kaya gin-atubang niya kag sinurmatunan sinda, ");
INSERT INTO msb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kun gusto niyo magin mga parasunod ko an pagkamuot niyo sa akon dapat magin mas labaw ki sa iyo pagkamuot sa iba. An iyo pagkamuot sa iba bisan kun sa iyo ama, iloy, asawa, kaanakan o kamaranghod, bisan pa ngani an pagkamuot sa iyo sadiri dapat magin bagaʼn kaurit sa pagkumparar sa iyo pagkamuot sa akon agod angay kamo na magin mga parasunod ko. ");
INSERT INTO msb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","An dili mag-upod kag habo mamatay alang-alang sa akon dili man angay magin disipulos ko. ");
INSERT INTO msb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kun kaya ngani ipamutang ta na igwa didi sa iyo sin nagaplano na magpatindog sin tore. Dili ba anay maingkod kag trabahuon niya kun sing-ano an magagasto kay agod makita kun makakaya niya ini? ");
INSERT INTO msb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kay basi kun iya na ini mapatunaan kag pakatapos amo pa niya nakita na dili gali niya kaya na ipahuman, pagatuya-tuyaon siya san mga umaragi kag sasabihon, ");
INSERT INTO msb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Adi an tawo na nagpatindog sin tore kag dili man gali niya kaya ipahuman.’ ");
INSERT INTO msb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Usad pa, nano na klaseʼn hadi na nakigyera sa iya kapareho hadi an dili anay maingkod kag mag-isip-isip na kun an kaupod niya na 10,000 na mga suldados makakaya sa iya kaaway na igwa sin 20,000 na suldados? ");
INSERT INTO msb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kay kun dili ninda makaya, myintras harayo pa an inda kaaway masugo na siya sin suruguon na makipag-areglar. ");
INSERT INTO msb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sugad man sana an dili magbaya san tanan niya na mga kasadirihan dili angay magin parasunod ko. ");
INSERT INTO msb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Pareho ini siya sa maayo na asin na kun mawar-an sin lasa pan-o pa ini mapaarat gihapon? ");
INSERT INTO msb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dili ina angay sa duta man o sa abuno kaya angay lang ina na ipilak pareho san tawo kun dili magsikway san kasadirihan. “Kamo na makabati, magpamati sin maayo!” ");
INSERT INTO msb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Usad naman sin adlaw may mga parasukot san buwis kag iba pa na mga mas makasasala pa gayod an nagharalapit kan Jesus para mamati sa iya. ");
INSERT INTO msb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kaya nagangurub-ngurob an mga Pariseo kag mga paratukdo san Kasuguan na nagasarabi, “Ini na tawo nakikiupod sa mga makasasala kag nakikaon pa ngani sa inda.” ");
INSERT INTO msb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kaya gin-istoryahan niya sinda sani: ");
INSERT INTO msb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nano an himuon san may usad ka gatos na karnero kun mawara an usad sani? Dili ba pagabayaan niya an 99 sa kabukidan kag hanapon an nalalagalag hasta na makita ini? ");
INSERT INTO msb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tapos kun makita, dili ba malilipay siya kag iya ini pagapas-anon pauli? ");
INSERT INTO msb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pakatapos pag-abot niya sa balay iimbitaran an iya mga amigo kag mga katarakin, ‘Magkalipay kita kay naagihan ko na an akon karnero na nawara!’ ");
INSERT INTO msb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sugad man gayod sani kun may makasasala na nagabasol kag nagbaya sa iya pagkasala. Mas lalo na an pagkalipay sa langit para sa iya ki sa 99 na mga matanos na dili na kinahanglan na magbasol. ");
INSERT INTO msb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Halimbawa amo man kun may babayi na may napulo na sinsilyo na plata, nawar-an sin usad sani, dili ba niya sisindihan an ilawan, sisilhigan an balay kag hahanapon sin maayo hasta na makita ini? ");
INSERT INTO msb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pakatapos iimbitaran an iya mga amiga kag mga katarakin, ‘Magkalipay kita kay naagihan ko an akon sinsilyo na plata na nawara.’ ");
INSERT INTO msb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sugad man gayod sani kun may makasasala na nagabasol kag nagbaya sa iya pagkasala may kalipay sa atubangan san mga anghel san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nagpadayon pa si Jesus pag-istorya, “May tawo na may duha na anak na lalaki. ");
INSERT INTO msb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sinabihan san manghod an ama, ‘Papa, nano daw kun ikahatag mo na sa akon an irensya ko.’ Kaya gintunga san ama an iya sadiri sa inda. ");
INSERT INTO msb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Pakalipas san pira ka adlaw binaligya san manghod an iya kabahinan kag nagpakadto sa harayo na lugar. Didto ginwaldas niya sa paluko an iya kwarta. ");
INSERT INTO msb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","San magastos na niya an tanan nagkaigwa sadto na lugar sin grabe na gutom kaya nakabatyag siya sin kalisod. ");
INSERT INTO msb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dahilan sani nagpasweldo siya sa usad na tagadidto. Tapos ginsugo siya sa uma agod mag-ataman sin kababuyan. ");
INSERT INTO msb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gusto kuntani niya magpabusog bisan bahog na lang san mga baboy ugaling kay waraʼn nagahatag sa iya. ");
INSERT INTO msb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“San makahuna-huna siya nagsabi sa iya sadiri, ‘Damu-damo na mga sweldado na trabahador san akon ama an nagasurobra an pagkaon pero ako didi tikamatayon na sa gutom! ");
INSERT INTO msb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maayo pa lugod umuli sa akon ama kag sabihan siya, Papa, nagkasala ako sa Dios kag sa imo. ");
INSERT INTO msb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Dili na ako angay na magin anak mo kundi himua na la ako na usad san mga sweldado mo na trabahador.’ ");
INSERT INTO msb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kaya humali siya sadto na lugar kag nag-uli sa iya ama. “Harayo pa nalantawan na siya san iya ama na nakabatyag sin dako na kaluoy. Dumalagan siya agod sugaton an iya anak. Sinakom niya kag ginhinarukan pa. ");
INSERT INTO msb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Pakatapos nagsurmaton an iya anak, ‘Papa, nagkasala ako sa Dios kag sa imo. Dili na ako angay na magin anak mo.’ ");
INSERT INTO msb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pero ginsugo lugod san ama an mga suruguon, ‘Dali! Sul-uti siya sin pinakamatahom na bado, singsingi kag sapatosi. ");
INSERT INTO msb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kuhaa an pinataba na tinday na baka kag pataya tapos magponsya kita kag magkalipay, ");
INSERT INTO msb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kay ginhuna na patay na ini na akon anak pero buhay gali. Naglayas pero nakabalik.’ Kaya nagkalipay sinda. ");
INSERT INTO msb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Myintras nagakalipay sinda adto sa uma an magurang na anak. Pagdangadang niya sa inda balay nakabati siyaʼn tugtugan kag sayawan. ");
INSERT INTO msb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kaya may tinawag siya na suruguon kag ginhunga kun nano ini na kasadyaan. ");
INSERT INTO msb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ginsabat siya, ‘Nag-uli an imo manghod na maayo an lawas kaya nagpapatay an imo ama san pinataba na tinday na baka para magkasadya.’ ");
INSERT INTO msb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Naurit gayod an magurang mala ngani kay habo magsulod. Kaya ginkadto siya san iya ama kag nakimaluoy sa iya. ");
INSERT INTO msb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero ginsabat niya an iya ama, ‘Kitaa, sa tanan na tuig na ginsirbihan ta ikaw wara gayod ako makatanda na nagsuay ako sa imo pero wara mo ngani ako paghatagi bisan na lang tinday na kanding para magkalipay na kaupod an akon mga amigo. ");
INSERT INTO msb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Niyan, san ini na imo anak nagbalik pakatapos naiwaldas sa paluko an imo sadiri sa iya mga malaw-ay na babayi, ginpapatyan mo pa san pinataba na tinday na baka.’ ");
INSERT INTO msb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Didi nagpahayag sa iya an ama, ‘Anak, adi ka pirme kaupud-upod ko kag an tanan ko na sadiri sa imo man. ");
INSERT INTO msb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero tama na magkalipay gayod kita kay nakauli na an imo kamanghod na naglayas kasadto. Ginhuna naton na patay na siya pero kitaa, kay buhay gali!’,” ");
INSERT INTO msb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ginsabi pa ni Jesus sa iya mga disipulos, “Igwaʼn mayaman na may katiwala kag may nagsumat na ginaparapalugi an iya kasadirihan. ");
INSERT INTO msb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kaya ginpatawag niya an katiwala kag sinabihan, ‘Nano ini na nababati ko manungod sa imo? Iintriga na sa akon an tanan kay magtuna niyan wara ka naʼn labot sani.’ ");
INSERT INTO msb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kaya nakasabi sa iya sadiri an katiwala, ‘Kay ginpahali na ako san akon amo, nano na daw an akon himuon? Dili ko kaya an pag-uma. Makaaralo man ako kun magpakilimos. ");
INSERT INTO msb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, aram ko na gali kun nano an akon himuon agod makasiguro ako na kun pahalion ako sa akon trabaho igwa gayod sin mapadayon sa akon.’ ");
INSERT INTO msb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kaya ginpatawag niya usad-usad an may mga utang sa iya amo. Ginhunga niya an nauna, ‘Pira an nautang mo sa akon amo?’ ");
INSERT INTO msb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“‘100 ka tibod na lana,’ an sabat. “Sinabihan siya san katiwala, ‘Adi an listahan san imo utang. Dali! Liwata kag himua na 50.’ ");
INSERT INTO msb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Tapos may ginhunga pa siyaʼn usad, ‘Ikaw, Amigo, pira an utang mo?’ “‘Usad ka gatos ka sako na arina,’ an sabat. “Sinabihan siya san katiwala, ‘Adi an listahan san imo pagkakautang, isurat na 80!’ ");
INSERT INTO msb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Pakatapos gindayaw san amo an madaya na katiwala tungod sa iya kalistuhan kay an mga makasasala sani na kinab-an mga maayo makigbagay sa inda kapareho ki san mga matanos. ");
INSERT INTO msb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kaya tandai ini: gamita an kwarta na magkaigwa ka sin damo na kakilala kag siguruha na kun maubos man ini pagapadayunon ka sa istaran na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Matitiwalaan man sa dako na kwarta an tawo na nasasarigan sa dyutay na kwarta kag an nagadaya sa dyutay na kwarta an magadaya man sa dako. ");
INSERT INTO msb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kun dili ka na ngani napipiyaran sin kayamanan san kinab-an, sin-o pa ada an magpiyar sa imo san tunay na kayamanan san Dios? ");
INSERT INTO msb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sugad man kun dili ka ngani napipiyaran san mga bagay na dili sa imo, sin-o pa ada an mahatag sin para sa imo sadiri? ");
INSERT INTO msb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Waraʼn makapauripon sin sabay sa duha na amo kay pagakabadlian niya an usad kag pagapalabihon an ikaduha. Kun dili sugad sani, magigin matinumanon siya sa usad kag igasikway niya an ikaduha. Dili kamo pwede makapauripon sin sabay sa Dios kag sa kwarta.” ");
INSERT INTO msb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","An mga Pariseo na makikwarta nakabati sani tanan kag gintarawhan ninda si Jesus. ");
INSERT INTO msb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pero sinabihan niya sinda, “Kamo idtoʼn nagapatuud-tuod na mga matanos sa mata san tawo pero aram san Dios an iyo mga tagipusuon. Tandai ini, an ginapahalagahan san tawo waraʼn pulos sa mata san Dios. ");
INSERT INTO msb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Hasta sa kapanahunan ni Juan na Parabunyag an ginasunod an Kasuguan ni Moises kag san mga sinurat san mga propeta. Tuna sadto an maayo na barita manungod sa kahadian san Dios ginapahayag kag an kada usad nagapirit na makasulod sani. ");
INSERT INTO msb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero kun an Kasuguan an pagsurmatunan mas madali pa na paraon an langit kag duta kisa halion an gahom bisan an pinakamenos na parte sani. ");
INSERT INTO msb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“An lalaki na makigbulag sa iya asawa kag mag-asawa sa iba nagakasala sin pagpanambay. An lalaki naman na mag-asawa sa ginbulagan na babayi nagakasala man sin pagpanambay.” ");
INSERT INTO msb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nagpadayon si Jesus, “May mayaman na nakaugalian na magsul-ot sin mga matahom na bado kag magpabugana sa pagkaon uruadlaw. ");
INSERT INTO msb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Didto sa may pwertahan san natad sani na mayaman may nakahigda na parapakilimos na samadon. An ngaran niya si Lazaro. ");
INSERT INTO msb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ini siya nagahandom na magkaon san bisan mga mumho na lang na nahuhulog sa may lamesa san mayaman, ugaling kay ginaparasamok siya san mga ido kag ginadilapan an iya mga samad. ");
INSERT INTO msb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Niyan namatay an parapakilimos kag gindara san mga anghel sa namumutangan ni Abraham. Namatay naman an mayaman kag ginlubong. ");
INSERT INTO msb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa iya grabe na pagtios sa impyerno, naghangad an mayaman kag nakita si Abraham na iya kalulululuhi kaupod si Lazaro. ");
INSERT INTO msb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kaya nagsiyak siya, ‘Abraham, ama ko, maluoy ka man sa akon. Sugua si Lazaro na isawsaw an punta san iya tudlo sa tubig kag papriskuhon an akon dila kay nagasakit ako didi sa kalayo.’ ");
INSERT INTO msb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Pero nagsabat si Abraham, ‘Anak, dumduma na san nabubuhay ka pa nagpakasawa ka sa imo pagkabuhay sa kinab-an pero si Lazaro nagtios sin dako na kalisudan. Niyan ginapalipay siya didi pero ikaw naman an nagatios dida. ");
INSERT INTO msb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pwera pa sani sa tunga san kamutangan naton may halapadon na tukal agod an mga adi didi dili makapakada kag an ada dida dili makapakadi.’ ");
INSERT INTO msb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Tapos sinabi san mayaman, ‘Lolo, nakimaluoy ako sa imo na suguon mo si Lazaro pakadto sa balay san akon ginikanan, ");
INSERT INTO msb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","para mapadaanan an lima ko na kamaranghod agod dili na sinda makapakadi pa didi sani na lugar san kastigo.’ ");
INSERT INTO msb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Pero sinabat naman siya ni Abraham, ‘Adto sa inda an Kasuguan ni Moises kag san mga sinurat san mga propeta na angay lang ninda pamatian.’ ");
INSERT INTO msb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nagsabi naman an mayaman, ‘Kulang pa po idto. Pero kun may magkadto sa inda hali sa mga patay, pagabayaan gayod ninda an paghimo sin kasal-an.’ ");
INSERT INTO msb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ginsabat pa siya ni Abraham, ‘Dili man gihapon sinda magatuod sa usad na namatay na nabuhay gihapon kun dili sinda nagapamati san Kasuguan ni Moises kag mga sinurat san mga propeta.’,” ");
INSERT INTO msb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ginsabihan ni Jesus an iya mga disipulos, “Sigurado gayod na maabot an mga tintasyon pero grabe man an kastigo para sadtoʼn magadara sani! ");
INSERT INTO msb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas maayo pa sa iya na bitayan sin gilingan na bato sa liog kag ipilak sa dagat ki sa madara pa niya paghimo sin kasal-an an mga katawuhan na may pagtuod. ");
INSERT INTO msb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaya paghimat kamo! “Kun magkasala an imo kapwa, sawaya siya kag kun magbasol patawada. ");
INSERT INTO msb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kun nagkasala siya sa imo sin pito na beses sa usad ka adlaw tapos magbalik sa imo kag magsabi, ‘Nagabasol ako,’ dapat patawadon mo siya.” ");
INSERT INTO msb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Naghangyo an mga apostoles sa Ginoo, “Dagdagi man po an amon pagtuod.” ");
INSERT INTO msb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nagsabat an Ginoo, “Kun an iyo pagtuod kapareho lang kadyutay sa pisog san mustasa masusugo niyo ini na kahoy na ginatawag na sikamora, ‘Magbalhin ka kag magtubo sa dagat!’ Tapos pagasundon kamo. ");
INSERT INTO msb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ipamutang ta na usad sa iyo may suruguon na nagaarado o nagapastor san karnero. Pagbalik niya hali sa uma aagdahon ba dayon niyo siya, ‘Kadi kag kumaon ka anay?’ Syimpre dili! ");
INSERT INTO msb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kundi an isusugo lugod niyo sa iya, ‘Preparara an akon panigab-ihan tapos pagliwan kag sirbihe ako myintras nagakaon kag nagainom. Pakatapos ko amo ka naman magkaon kag mag-inom.’ ");
INSERT INTO msb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nano, pagapasalamatan kaya an suruguon kay nagtuman san ginsugo sa iya? ");
INSERT INTO msb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pareho man ini sa iyo kun matuman na niyo an tanan na ginsugo sa iyo masabi kamo, ‘Mga suruguon lang kami. Ginhimo lang namon an amon obligasyon.’,” ");
INSERT INTO msb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","San pagpakadto ni Jesus sa Jerusalem nag-agi siya sa may lindero san Samaria kag Galilea. ");
INSERT INTO msb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagsulod niya sa usad na baryo sinugat siya sin napulo na leprosohon na nagatirindog sa huruharayo. ");
INSERT INTO msb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nagtawag sinda sa iya sin kusog, “Jesus! Maestro! Maluoy ka man sa amon.” ");
INSERT INTO msb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pakakita ni Jesus sa inda nagsabi, “Kadto kamo kag magpakita sa mga padi.” Myintras nagalakat nag-arayo dayon sinda. ");
INSERT INTO msb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pakakita san usad na nag-ayo na siya, nagbalik, nag-umaw sa Dios sa makusog na boses, ");
INSERT INTO msb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","pakatapos naghapa sa may tiilan ni Jesus kag nagpasalamat sa iya. Idto na tawo usad na Samaritano. ");
INSERT INTO msb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Niyan naghunga si Jesus, “Dili ba napulo tanan an nag-arayo? An siyam gali, hain man? ");
INSERT INTO msb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nano kay ini lang na dayuhan an nagbalik na nagpasalamat sa Dios?” ");
INSERT INTO msb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pakatapos sinabihan ni Jesus an lalaki, “An imo pagtuod an nakapaayo sa imo. O, sige, kadto na.” ");
INSERT INTO msb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ginhunga si Jesus san mga Pariseo kun san-o maabot an kahadian san Dios. Amo ini an sabat ni Jesus, “An kahadian san Dios dili magaabot na may igapakita na mga tanda, ");
INSERT INTO msb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","kag wara man sin makasabi na ‘Adi na didi!’ o ‘Adto na didto!’ kay matuod na ina adi na kaupod niyo.” ");
INSERT INTO msb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ginsabihan ni Jesus an iya mga disipulos, “Maabot an panahon na magahandom kamo na makita an pagbalik ko gihapon na Anak San Tawo pero dili niyo ina makikita. ");
INSERT INTO msb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pagasabihan kamo san katawuhan ‘Kitaa, adi siya,’ o ‘Kitaa, adto siya!’ Pero ayaw pag-apas sa inda. ");
INSERT INTO msb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay sa adlaw san pag-abot ko, ako, na Anak San Tawo, magasidlak pareho san kilat na nagasidlak sa luyo na parte san langit pero nakapawa hasta man sa luyo. ");
INSERT INTO msb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero antes sani, dapat magtios anay ako sin grabe kag igsikway sani na mga tawo yana. ");
INSERT INTO msb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kaya pareho san kamutangan san kapanahunan ni Noe an kamutangan didi sa kinab-an pagbalik san Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sadto na panahon an mga tawo nagakaraon kag nagairinuman, an kababayihan kag kalalakihan nag-arasawahan hasta sa adlaw na nagsulod si Noe sadtoʼn sarakyan sa tubig na ginatawag arka kag nagbuhos an baha na nakapatay san tanan pwera sadtoʼn adto sa arka. ");
INSERT INTO msb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Sugad man san nangyari san kapanahunan ni Lot an mga tawo nagakaraon, nagairinuman, nagapamarakal kag nagabaraligya, nagataranom kag nagabaralay man, ");
INSERT INTO msb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","pero sa adlaw san paghali ni Lot sa Sodoma, an Dios nagpauran sin kalayo kag asupre hali sa langit na nakapatay sa inda tanan sa Sodoma. ");
INSERT INTO msb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Pareho man sani an mangyayari sa pag-abot san adlaw san paghayag sa akon na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pag-abot sana na adlaw an adto sa atop dili na maglusad pa agod kuhaon an iya mga garamiton sa sulod san balay. An adto man sa mga uma dili na dapat mag-uli pa. ");
INSERT INTO msb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dumduma an asawa ni Lot na nagin asin san paglingi sa nasunog na syudad san Sodoma. ");
INSERT INTO msb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kun sugad an nagahandom na masalbar an iya buhay mawawara niya ini pero an mawawar-an sani na buhay dahilan sa pagsunod sa akon magkakaigwa lugod. ");
INSERT INTO msb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tandaan an masasabi ko: sana na kagab-ihon may duha na tawo na nasa usad na higdaan. Pagakuhaon an usad pero an iya kaupod ibibilin. ");
INSERT INTO msb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","May duha naman na babayi na magaupod sa paggiling. Pagakuhaon an usad pero an iya kaupod ibibilin.” ");
INSERT INTO msb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Naghunga an mga disipulos sa iya, “Sa diin po, Ginoo.” Nagsabat si Jesus, “Kun hain may patay adto man magatiripon an mga uwak.” ");
INSERT INTO msb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pakatapos nag-istorya pa si Jesus agod magtukdo sa inda na pirme sinda mangadyi kag dili magluya an buot. ");
INSERT INTO msb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sabi niya, “Igwaʼn huwes sa usad na lungsod na waraʼn ginagalangan bisan an Dios. ");
INSERT INTO msb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sadto man na lungsod igwaʼn biyuda na nagaparabalik-balik sa iya na nakimaluoy sin hustisya kontra sa iya kaaway. ");
INSERT INTO msb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Dugay anay nagparahabo an huwes pero sa kadugayan nakasabi siya sa iya sadiri, ‘Bisan dili ako nahahadlok sa Dios ni maggalang kanin-o man, ");
INSERT INTO msb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hahatagan ko na lang sin hustisya ini na biyuda kay pirme ako ginaparasamok kag basi sa iya kabalik-balik lipungon pa an akon ulo.’,” ");
INSERT INTO msb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kaya didi nagsabi an Ginoo, “Nabatian niyo kun nano an ginsabi san dili matanos na huwes. ");
INSERT INTO msb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Niyan dili ba magahatag an Dios sin hustisya sa iya mga pinili na nagaagrangay adlaw gab-i? Nano pagaparabalibadan daw sinda niya? ");
INSERT INTO msb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ginasiguro ko sa iyo na igahatag dayon niya sa inda an hustisya. Pero pag-abot ko na Anak San Tawo dyutay na lang gayod an makikita ko na may pagtuod sa akon didi sa kinab-an.” ");
INSERT INTO msb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Amo ini an gin-istorya ni Jesus sadtoʼn mga tawo na an pagkita sa inda sadiri matanos kag ginamenos an sa iba. ");
INSERT INTO msb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Sadto may duha ka tawo na nagkadto sa templo para magpangadyi. An usad sani Pariseo kag an usad parasukot san buwis. ");
INSERT INTO msb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Niyan nagtindog didto an Pariseo kag nagpangadyi manungod sa iya sadiri, ‘Dios ko, nagapasalamat ako sa imo na dili ako pareho san iba na mga tawo na mga paslo sa kwarta, waraʼn hustisya, parapanambay kag lalo na gayod dili ako pareho sani na parasukot san buwis. ");
INSERT INTO msb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nagaayuno akoʼn duha na beses sa usad na semana. Ginahatag ko sa templo an ikanapulo na parte san akon kita.’ ");
INSERT INTO msb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“An parasukot naman san buwis nagtindog sa huruharayo na dili man lang ngani makahangad sa langit kundi iya ginapukpok an iya dughan kag nagsabi, ‘Dios ko, maluoy ka man sa akon na makasasala.’ ");
INSERT INTO msb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Tandaan an ginasabi ko: ini na tawo nag-uli na matanos sa pagkita san Dios ki sadtoʼn usad kay an nagapakalabaw pagapakamenuson kag an nagapakamenos papalabawon.” ");
INSERT INTO msb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Niyan may mga tawo na nagadara kan Jesus sin mga tigdyutay na kabataan agod madapatan san kamot niya pero pakakita sani san mga disipulos, ginsaway idtoʼn mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero tinawag lugod ni Jesus an mga bata na magtulos sa iya kag nagsurmaton, “Ayaw niyo pag-ulanga an mga tigdyutay na kabataan kundi pakadia sa akon kay an kahadian san Dios para sa inda na pareho sani na mga bata. ");
INSERT INTO msb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ginasiguro ko sa iyo na an dili magpasakop sa paghadi san Dios na pareho sin dyutay na bata dili makasulod sana na kahadian.” ");
INSERT INTO msb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","May usad na namumuno na naghunga sani kan Jesus, “Maayo na maestro, nano tabi an dapat ko na himuon agod masadiri ko an buhay na waraʼn katapusan?” ");
INSERT INTO msb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pero ginhunga man siya ni Jesus, “Nano kay ginatawag mo ako na maayo? Waraʼn iba na maayo kundi an Dios lang.” ");
INSERT INTO msb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pakatapos nagpadayon siya, “Aram mo na an Kasuguan! ‘Dili ka magpanambay, dili ka magpatay, dili ka magpangawat, dili ka magtestigos sin kabuwaan, galangan mo an imo ama kag iloy.’,” ");
INSERT INTO msb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nagsabat man an lalaki, “Gintuman ko ina tanan tuna pa san bata pa ako.” ");
INSERT INTO msb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pakabati sani ni Jesus sinabihan siya, “Igwa paʼn kulang sa imo. Ibaligya an tanan mo na kasadirihan kag ipanghatag sa mga pobre an kabaklanan kay magkakaigwa ka sin kayamanan kaupod san Dios sa langit. Pakatapos bumalik ka kag mag-upod sa akon.” ");
INSERT INTO msb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pakabati man sani san lalaki namundo siya dahilan na mayaman-yaman siya. ");
INSERT INTO msb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ginasud-ong siya ni Jesus na nagasurmaton, “Malisod gayod sa mga mayaman an pagsulod sa kahadian san Dios! ");
INSERT INTO msb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas masayon pa na makaagi an kamelyo sa luho san dagom ki sa pagsulod san mayaman sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Naghunga an mga nakabati sani, “Kun sugad, sin-o man gali an masasalbar?” ");
INSERT INTO msb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nagsabat si Jesus, “An dili kaya san mga tawo na mahimo, makahimo an Dios.” ");
INSERT INTO msb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Didi nagsurmaton si Pedro, “Kami gali? Ginbayaan namon an tanan agod mag-upod sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kaya sinabihan sinda ni Jesus, “Ginasiguro ko sa iyo na waraʼn nagbaya sin balay, asawa, mga kamanghod, mga ginikanan o kaanakan alang-alang sa kahadian san Dios ");
INSERT INTO msb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na dili makabaton sin mas sobra pa sani yana na panahon kag sin buhay na waraʼn katapusan sa maabot.” ");
INSERT INTO msb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ginbulag ni Jesus an dose na disipulos kag sinabihan, “Tandai, nagasagka kita pa-Jerusalem kun diin matutuman an tanan na sinurat san mga propeta manungod sa akon na Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Didto igaintriga ako sa mga dili-Judio, pagatuya-tuyaon, pagakastiguhon kag pagaludaan. ");
INSERT INTO msb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pakatapos lalatiguhon kag ipapatay pero sa ikatulo ka adlaw mabubuhay ako gihapon.” ");
INSERT INTO msb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero wara sindaʼn nasabutan san ginpanurmaton niya kay bagaʼn natago ini kag wara gayod sinda kapanginano san gusto sabihon sani. ");
INSERT INTO msb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","San nagadangadang na si Jesus sa Jerico igwaʼn buta na nagapakilimos sa higad san kamino. ");
INSERT INTO msb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","San pakabati sani na damo an nagaaragi naghunga kun nano an kasibutan. ");
INSERT INTO msb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ginsumat sa iya na nagaagi si Jesus na taga-Nazaret. ");
INSERT INTO msb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kaya sumiyak siya, “Jesus, Lahi ni David, kaluy-i ako.” ");
INSERT INTO msb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ginsaway siya san nauuna na tawo kag ginpapuyo pero lalo lugod na sumiyak siyaʼn mas makusog, “Lahi ni David, kaluy-i ako.” ");
INSERT INTO msb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Didi umudong si Jesus kag nagmanda na darhon an buta sa iya. San paghalapit hinunga niya, ");
INSERT INTO msb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nano an gusto mo na himuon ko para sa imo?” Nagsabat an buta, “Ginoo, gusto ko po makakita.” ");
INSERT INTO msb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sinabihan siya ni Jesus, “Hala, kita! An imo pagtuod amo an nakaayo sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Insigida nakakita siya, nag-upod kan Jesus kag nag-umaw sa Dios. Pakakita san mga tawo san nangyari nag-umaw man an tanan. ");
INSERT INTO msb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nagsulod si Jesus sa Jerico pero nagaagi lang. ");
INSERT INTO msb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Igwa didtoʼn tawo na an ngaran Zaqueo. Ini siya mayaman kag amo an namumuno san mga parasukot san buwis. ");
INSERT INTO msb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nagahandom gayod siya na makita kun nano na klaseʼn tawo si Jesus pero kay sa kadamuan san tawo kag pututan siya dili niya makita si Jesus. ");
INSERT INTO msb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaya nag-una-una siya kag sumakat sa kahoy para lang na makita si Jesus na maagi sadtoʼn agihan. ");
INSERT INTO msb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagtungod ni Jesus sadto na lugar humangad siya kag sinabihan si Zaqueo, “Dali, lusad dida kay makidayon ako sa imo balay yana.” ");
INSERT INTO msb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nagdali-dali siya paglusad kag pag-abot sa iya balay, malipayon na ginpadayon si Jesus. ");
INSERT INTO msb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nagngurub-ngurob an tanan pakakita san pangyari, “Nakidayon siya sa balay sin makasasala.” ");
INSERT INTO msb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Myintras tumindog si Zaqueo kag nagsurmaton, “Ginoo, igahatag ko sa pobre an katunga san akon mga sadiri kag kun may nagkadarayaan ako, pagaulian koʼn duha ka doble.” ");
INSERT INTO msb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pakatapos sinabihan siya ni Jesus, “Yana na adlaw nag-abot na an pagkasalbar sani na panimalay kay ini na tawo anak man ni Abraham. ");
INSERT INTO msb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Amo na ini kay ako na Anak San Tawo nagkadi sa kinab-an agod hanapon kag isalbar an mga tawo na nawawara.” ");
INSERT INTO msb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Myintras nagapamati an mga tawo nagpadayon si Jesus pagsurmaton sin istorya kay halapit na sinda sa Jerusalem kag nakahuna-huna na igapakita dayon didto an kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaya nagtuna siya, “May prinsipe na nagpakadto sa harayo na lugar agod mahimo siya na hadi kag pakatapos mabalik gihapon. ");
INSERT INTO msb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pakatawaga san napulo niya na mga suruguon hinatagan sin kwarta na oro an kada usad kag ginsabihan, ‘Inegosyo niyo ini hasta sa pagbalik ko.’ ");
INSERT INTO msb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pero nabadli sa iya an mga insakupan kaya paghali niya may ginpaabot sinda na mensahe sugad sani, ‘Habo kami magpasakop sani na tawo!’ ");
INSERT INTO msb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Niyan san pagbalik sadtoʼn prinsipe bilang hadi na, ginpatawag niya an mga suruguon na ginhatagan niyaʼn kwarta agod usisahon kun sing-ano na an ganansya san kada usad. ");
INSERT INTO msb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“An nauna pag-abot nagsabi, ‘Sir, an ginhatag mo na kwarta nagtubo sin napulo pa.’ ");
INSERT INTO msb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nagsabat an hadi, ‘Mapaniwalaan na suruguon, maayo an hinimo mo! Kaya ikaw an pagapamahalaan ko san napulo na syudad kay nagin matinumanon ka bisan sa dyutay na bagay.’ ");
INSERT INTO msb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Pakatapos nag-abot an ikaduha kag nagsabi, ‘Sir, nakalima pa an ginhatag mo na kwarta!’ ");
INSERT INTO msb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Sani man na usad sinabihan niya, ‘Ikaw man an magapamahala sin lima na syudad!’ ");
INSERT INTO msb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Paghali sani may nag-abot pa na usad kag nagsabi, ‘Sir, adi an imo kwarta. Ginputos ko iniʼn maayo sa tela ");
INSERT INTO msb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tungod na nahahadlok ako sa imo kay maisog ka. Ginakuha mo bisan dili sa imo kag ginaani mo bisan dili sa imo tanom!’ ");
INSERT INTO msb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ginsabat siya san hadi, ‘Buang na suruguon,’ an sabi niya. ‘Hali sa sadiri mo na panurmaton ginakondinar ta ikaw. Kay aram mo na daan na maisog ako, nagakuha san bisan dili akon kag nagaani san dili ko tanom. ");
INSERT INTO msb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nano man kay wara mo ighulog sa bangko an kwarta ko agod pagbalik ko makuha ko an kwarta hasta an porsyento?’ ");
INSERT INTO msb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Pakatapos sinabihan niya an nagatirindog didto, ‘Hala, kuhaa an kwarta sa iya kag ihatag sa tawo na nakaganansyaʼn napulo.’ ");
INSERT INTO msb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nagreklamo sinda sa iya, ‘Anay, Sir, igwa na siyaʼn napulo na ganansya!’ ");
INSERT INTO msb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“‘Amo man gayod kag manungod san pagkamatinumanon ginasiguro ko sa iyo na an igwa pagadagdagan pa pero sa tawo na wara, bisan nano na ada sa iya pagakuhaon pa. ");
INSERT INTO msb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Niyan idto naman na mga kaaway ko na habo magin hadi ako ninda daraha sinda pakadi kag pataya sa atubangan ko.’,” ");
INSERT INTO msb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pakatapos ni Jesus pagsurmaton sani, nauuna siya pagsagka pakadto sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Niyan san nagadangadang na siya sa Betfage kag Betania na adto na sa Bukid San Kaolibohan nagsugo siya sin duha san iya mga disipulos kag sinabihan, ");
INSERT INTO msb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kadto kamo sa kaatubang na baryo kay pagsulod niyo makakita kamoʼn nakahigot na tinday na asno na wara pa gayod masakyi. Hubadi anay niyo tapos guyuda pakadi. ");
INSERT INTO msb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kun may maghunga sa iyo kun nano an ginahimo niyo sabihan niyo na, ‘Ginakinahanglan ini san Ginoo.’,” ");
INSERT INTO msb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kaya naglakat an mga ginsugo kag nakita ninda an ginsabi sa inda. ");
INSERT INTO msb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Myintras ginahubadan ninda an tinday, naghunga an mga tag-iya, “Nano kay ginahubadan niyo an tinday?” ");
INSERT INTO msb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nagsabat sinda, “Ginakinahanglan ini san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pakatapos gin-guyod ninda pakadto kan Jesus an tinday, ginkamadiruhan san inda mga alikboy kag pinasakay siya. ");
INSERT INTO msb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pakatapos ginlatag man san iba an inda mga alikboy sa kamino na ginaagihan ni Jesus sa paggalang sa iya. ");
INSERT INTO msb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","San nagahalapit na siya sa palugsadan san Bukid San Kaolibohan nalipay an tanan na mga disipulos kag nagtuna pagsiyak san pag-umaw sa Dios dahilan sa tanan na mga milagro na inda nakita. ");
INSERT INTO msb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nagsiriyak sinda, “Ginpalabi lugod san Dios an hadi na nagapakadi sa ngaran san Ginoo! Magkaigwa lugod sin kalinaw kag glorya sa kahitaasan san langit!” ");
INSERT INTO msb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Niyan may mga Pariseo na nagreklamo kan Jesus, “Maestro, sawaya an imo mga disipulos.” ");
INSERT INTO msb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero nagsabat siya, “Ginasiguro ko sa iyo na kun magpuruyo ini sinda, an magasiriyak lugod an mga bato.” ");
INSERT INTO msb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","San nagadangadang na siya kag nasud-ungan an syudad, nakatangis si Jesus na nagasabi, ");
INSERT INTO msb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Kun naarman mo lang na yana an kinahanglan para sa pakigsiruan kaya lang nakatago na ina sa imo pangita. ");
INSERT INTO msb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Oo, maabot an oras na pagatambakan sin mga duta san imo mga kaaway an luwas san imo mga pader agod makaagi sinda pasulod kag pagapalibutan ka sa kada kilid mo. ");
INSERT INTO msb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pagasiraon ka kag san tanan na mga tawo na nasa sulod san imo pader. Wara sindaʼn ibibilin bisan usad na bato na nakatungtong tungod na wara mo pagkilalaha an pag-abot sa imo san Ginoo!” ");
INSERT INTO msb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pakatapos nagsulod si Jesus sa templo nagtuna siya pagpaluwas san mga parabaligya. ");
INSERT INTO msb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nagsurmaton siya, “Nasurat sa Banal Na Kasuratan an ginsabi san Dios, ‘An akon balay amo an balay na pangadyian’ pero ginhimo lugod niyo ini bilang ‘istaran san mga makawat.’,” ");
INSERT INTO msb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Uruadlaw nagapangtukdo sa templo si Jesus, pero an mga namumuno san kapadian, mga paratukdo san Kasuguan kag san mga namumuno na mga tawo nagahanap sin paagi na patayon siya. ");
INSERT INTO msb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero wara sindaʼn maisip na paagi na himuon ini kay naila na gayod an mga tawo magpamati sa iya. ");
INSERT INTO msb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Usad sin adlaw myintras nagatukdo si Jesus sa mga tawo sa templo kag nagapahayag san Maayo Na Barita, nagtiripon sa iya an mga namumuno san kapadian, mga paratukdo san Kasuguan kag mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tapos nagsurmaton sinda sa iya, “Abir, sumati daw kami kun kanin-o pagbuot an paghimo mo sani. Sin-o an naghatag sa imo sani na otoridad?” ");
INSERT INTO msb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ginsabat sinda ni Jesus, “Pagahungaon ko anay kamo. ");
INSERT INTO msb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sumati man daw niyo ako kun kanin-o pagbuot naghalin an otoridad ni Juan para magpambunyag. Hali sa Dios sa langit ina o sa tawo?” ");
INSERT INTO msb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Didi sinda nagpahurunga-hunga kun nano an ikasabat. “Kun sabihon naton, ‘Hali sa langit,’ mahunga naman siya, ‘Kun amo nano kay wara niyo siya pagtuudi?’ ");
INSERT INTO msb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero kun sabaton naman naton, ‘Hali sa tawo,’ babatuhon kita san mga tawo kay nagatuod gayod sinda na propeta si Juan.” ");
INSERT INTO msb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaya an sabat ninda na dili ninda aram kun diin ini hali. ");
INSERT INTO msb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Didi ginsabat sinda ni Jesus, “Kun sugad dili ko man sasabihon sa iyo kun kanin-o otoridad ginahimo ko ini.” ");
INSERT INTO msb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niyan, nagpadayon si Jesus sin pag-istorya sa mga tawo, “May tawo na nagtanom sin damo na ubas. Ini ginpapletihan niya sa mga parabantay tapos nagkadto sa harayo na lugar kag nadugay didto. ");
INSERT INTO msb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","San pag-abot san panahon san tigpuduan may ginsugo siya pakadto sa mga parabantay para magkuha san iya bahin na produkto. Pero ginburuligan san mga parabantay an iya ginsugo kag pinauli na waraʼn dara. ");
INSERT INTO msb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pero may ginsugo gihapon siyaʼn ikaduha. Ginburuligan man ini gihapon san mga parabantay kag gintuya-tuya, pakatapos pinauli man na waraʼn dara. ");
INSERT INTO msb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nagpadayon pa an tag-iya pagsugo san ikatulo. Niyan ini sinamadan san mga parabantay kag initsa paluwas. ");
INSERT INTO msb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kaya nakasabi an tag-iya san ubasan, ‘Nano daw an maayo ko na himuon? Maayo pa suguon ko sa inda an palangga ko na anak. Siguro gagalangan ninda siya!’ ");
INSERT INTO msb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Pero pakakita san mga parabantay sa anak san tag-iya, nagkaurusad sinda pagsabi, ‘Amo ini an iredero. Patyon ta siya agod an iya irensyahon sa aton na.’ ");
INSERT INTO msb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kaya gindara anay ninda siya sa luwas san ubasan kag pinatay. “Niyan, nano daw an hihimuon sa inda san tag-iya san ubasan? ");
INSERT INTO msb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Syimpre, kakadtuon niya kag papatyon idtoʼn mga parabantay, pakatapos pagapapletihan niya an ubasan sa iba.” Pakabati sani nagsabi an mga nagbarati, “Buyag!” ");
INSERT INTO msb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero tinurok sinda ni Jesus kag hinunga, “Nano man gali an gusto sabihon sani na parte san Banal Na Kasuratan, ‘An bato na ginhabuan sanmga parabalay amo lugod an nagin pinakaimportante na bato sa balay’? ");
INSERT INTO msb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Magakabaralian an mahulog sani na bato pero kun may mahulugan sani madudunot gayod.” ");
INSERT INTO msb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sadto mismo gusto na kuntani dakupon si Jesus san mga paratukdo san Kasuguan kag san mga namumuno san kapadian kay namalisyahan ninda na sinda an ginapatamaan sadto na istorya, ugaling kay nagkaharadlok sinda sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kaya ginpaburubantayan ninda siya kag nagsugo sin mga tawo na nagasagin-sagin na mga matanos para dakupon si Jesus sa iya mga ginapanurmaton agod iatubang siya ninda sa gobernador na may otoridad kag poder. ");
INSERT INTO msb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Naghunga sinda sa iya, “Maestro, aram namon na tama an imo ginapanurmaton kag ginapanukdo. Wara ka sin ginapalabi kundi nagatukdo san kamatuudan manungod san pagbuot san Dios sa tawo. ");
INSERT INTO msb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Niyan, sabihi daw kami kun tama na susog sa Kasuguan na magbayad kitaʼn buwis kan Cesar.” ");
INSERT INTO msb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero aram ni Jesus an inda maraot na katuyuan kaya sinabihan sinda, ");
INSERT INTO msb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pakitaa daw ako niyoʼn sinsilyo.” Ginpakita ninda an sinsilyo. Pakatapos naghunga siya, “Kanin-o pamayhon kag ngaran an adi didi?” ");
INSERT INTO msb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Kan Cesar,” an sabat ninda. Kaya, ginsabihan niya sinda, “Maayo, kun sugad ihatag kan Cesar an para kan Cesar kag sa Dios an para sa Dios.” ");
INSERT INTO msb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Niyan wara gayod ninda madakop si Jesus sa iya panurmaton sa atubangan san kadamuan kundi nagngalas pa lugod sinda san iya sabat kag nagpuruyo na lang. ");
INSERT INTO msb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Niyan may nagkaradto man kan Jesus na pira na mga Saduceo. Ini sinda mga Judio na dili nagatuod san pagkabuhay gihapon, kaya naghunga sinda sa iya, ");
INSERT INTO msb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Maestro, naaraman naton sa Kasuguan na ginsurat ni Moises na kun may mamatay na lalaki kag mabilin an iya asawa na waraʼn anak, dapat asawahon san kamanghod san lalaki an biyuda agod makaanak sinda para sa magurang na napatay. ");
INSERT INTO msb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Niyan igwaʼn pito na magmaranghod na lalaki. An subang nag-asawa pero napatay na waraʼn anak. ");
INSERT INTO msb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","An ikaduha na kamanghod gin-asawa man an biyuda pero napatay man na waraʼn anak. ");
INSERT INTO msb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pakatapos an ikatulo naman gin-asawa an biyuda pero napatay man na waraʼn anak. Amo man an nangyari hasta sa ikapito na kamanghod. ");
INSERT INTO msb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sa katapusan napatay man an babayi. ");
INSERT INTO msb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Niyan, sa pagkabuhay gihapon sin-o sa pito an pagakilalahon san babayi na tunay na asawa kay nagin mga asawa siya san pito na magmaranghod?” ");
INSERT INTO msb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ginsabat sinda ni Jesus, “Didi sa kinab-an an mga babayi kag lalaki nagaarasawa. ");
INSERT INTO msb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","An mga angay mabuhay gihapon hali sa kamatayon kag mabuhay sana na maabot na panahon dili na magaarasawahan an mga tawo, ");
INSERT INTO msb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","kay dili na sinda mamamatay dahilan na pareho na sinda san mga anghel. Sinda man mga anak na san Dios tungod na ginbuhay gihapon sinda. ");
INSERT INTO msb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bisan si Moises mismo nagapamatuod na ginabuhay gihapon an mga patay. Dahilan sa nangyari sa iya manungod sa nagalaad na tanom kun diin an Ginoo gintawag niya na ‘an Dios ni Abraham kag an Dios man ni Isaac kag ni Jacob.’ ");
INSERT INTO msb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","An gusto sabihon sani na an Ginoo amo an Dios san mga buhay dili san mga patay kay para sa iya buhay an tanan.” ");
INSERT INTO msb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tapos may nagsurmaton na mga paratukdo san Kasuguan, “Maestro, maayo an imo pakapahayag.” ");
INSERT INTO msb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kaya wara naʼn nagkusug-kusugan sin buot na maghunga pa sa iya. ");
INSERT INTO msb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nagpadayon si Jesus pagsurmaton sa inda, “Nano kay nakasabi an mga tawo na an Cristo kalahi ni David? ");
INSERT INTO msb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kay si David mismo nagsabi sa Libro san mga Salmo, ‘An Ginoo nagsabi sa akon Ginoo: Mag-ingkod ka sa may tuo ko hasta na himuon ko ");
INSERT INTO msb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","na tungtungan san imo mga tiil an mga kaaway mo.’ ");
INSERT INTO msb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Didi gintawag ni David an Cristo na Ginoo, kaya pan-o an Cristo magin kalahi ni David?” ");
INSERT INTO msb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pagpamarati san tanan na mga tawo sinabihan ni Jesus an iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Paghimat sa mga paratukdo san Kasuguan na naiila maglakat na mga matahom an ginasul-ot kag gusto paggalangan sa mga merkado, magkaigwaʼn pinakamaayo na ingkudan sa mga sinagoga kag pinakahalandon na pwesto sa mga ponsya. ");
INSERT INTO msb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nagaprobitsar man sinda san mga kasadirihan san mga biyuda kag sa pagsagin-sagin na banal sinda nagapangadyi sin mga halagba. Kaya, mas grabe gayod an kastigo ninda.” ");
INSERT INTO msb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","San nagapangmasid-masid ni Jesus, namasdan niya an mga mayaman na nagahulog san inda mga halad sa ginahulugan san kwarta para sa gastos sa templo. ");
INSERT INTO msb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","May nakita man siyaʼn pobre na biyuda na naghulog sin duha na sentimos. ");
INSERT INTO msb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pakatapos nagsabi siya, “Matuod gayod na mas dako pa an ginhulog sani na pobre na biyuda ki sa inda tanan, ");
INSERT INTO msb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kay naghatag sinda hali sa inda kabuganaan pero siya naman sa iya kapobrehan ginhatag gayod an tanan hasta na ngani an isurugpon sa ginhawa.” ");
INSERT INTO msb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Myintras, ginaistoryahan san iba an manungod sa templo kun pan-o ini ginpatahom san mga mahalon na bato kag mga regalo na ginhalad san mga tawo sa Dios. Didi nagpadayon si Jesus pagsurmaton, ");
INSERT INTO msb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Maabot an panahon na wara gayod ni usad na bato na mabibilin sani tanan na iyo makikita didi yana kay an tanan maruruba.” ");
INSERT INTO msb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kaya ginhunga siya san mga disipulos, “Maestro, san-o man ini mangyayari kag nano an tanda na igapakita na ini na tanan halapit na matuman?” ");
INSERT INTO msb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nagsabat siya, “Maghimat gayod kamo na dili maluko kay damo an magaabot na magasambit man san ngaran ko kag magasabi, ‘Ako an Cristo,’ kag, ‘Halapit na an katapusan san kinab-an.’ Pero ayaw gayod pag-apas sa inda. ");
INSERT INTO msb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kun makabarita naman kamoʼn manungod sa gyera kag mga pagkasamok, ayaw kahadlok kay dapat ini mangyari anay pero dili pa ina dayon an katapusan.” ");
INSERT INTO msb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pakatapos sinabihan pa niya sinda, “Magagyerera an mga nasyon, kag an mga kahadian magapauruataki. ");
INSERT INTO msb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Magakaigwa sin mga makusog na linog, mga panakit kag gutom sa mga manlain-lain na lugar. Magakaigwaʼn makaharadlok na kiritaon kag makangangalas na mga tanda hali sa langit. ");
INSERT INTO msb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero antes sani tanan pagadakupon kamo kag pagapasakitan. Pagabistahon kamo sa mga sinagoga kag pagaprisuhon tapos igaatubang sa mga hadi kag mga gobernador dahilan sa pagsunod niyo sa akon. ");
INSERT INTO msb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Amo ini gayod kay agod makatestigo kamo sa inda manungod san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kaya ipahimutang an kaisipan niyo. Ayaw kalisang sa pagdepensa san iyo sadiri ");
INSERT INTO msb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kay ako mismo an magapasurmaton sa iyo kag magahatag sin kadunungan na waraʼn sin-o man na kaaway an makadaog o makahimuwa sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pagatraydoran kamo bisan san mga ginikanan, mga kamanghod, mga kaurupod kag mga kakilala kag pagapatayon an iba sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pagakabadlian kamo san tanan na katawuhan dahilan sa akon, ");
INSERT INTO msb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pero wara ni usad san iyo buhok sa ulo an mawawara. ");
INSERT INTO msb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kun magmatiniuson kamo amo ini an makahatag sa iyo sin buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kun makita niyo na ginapalibutan na san mga suldados an Jerusalem maaaraman niyo na halapit na ini masira. ");
INSERT INTO msb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kaya idtoʼn adto sa Judea dapat magdulag na sa mga kabukidan. Idtoʼn nasa syudad maghali na kag idtoʼn adto sa mga kaumahan dili magsulod sa syudad, ");
INSERT INTO msb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","kay amo na ini an panahon sa pagbalos san Dios para matuman an tanan na nasurat sa Banal Na Kasuratan. ");
INSERT INTO msb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Makaluluoy idtoʼn mga budos kag may mga ginapadudo pa na mga kabataan pag-abot sana na panahon! Kay magkakaigwaʼn grabe na pagtios sana na lugar kag uuritan gayod sin grabe san Dios ini na mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","May pagapatayon sa sundang, may pagabihagon san tanan na mga nasyon kag an Jerusalem pagasiraon san mga dili-Judio hasta na matapos an pagahadi ninda didto. ");
INSERT INTO msb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Magakaigwa sin mga tanda sa adlaw, sa bulan kag sa mga bituon. Sa duta magakaigwaʼn grabe na kalisangan. An mga tawo san mga nasyon mangingirhat san dinaguhob san kadagatan kag daragko na mga balod. ");
INSERT INTO msb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Magakadirismayo an mga tawo sa kahadlok sa kaisip san mga makaharadlok na mangyayari sa kinab-an kay pagauy-ugon an mga makagagahom sa kalangitan. ");
INSERT INTO msb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pakatapos makikita san mga tawo na magaabot ako na Anak San Tawo sa mga dampog na may poder kag masilaw gayod na glorya. ");
INSERT INTO msb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Niyan kun magtuna na ini na mga pangyayari tumindog kag humangad kamo kay halapit na an pagsalbar sa iyo.” ");
INSERT INTO msb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Niyan gin-istoryahan sinda ni Jesus, “Huna-hunaa niyo an kahoy na ginatawag higera kag san iba na mga kahoy. ");
INSERT INTO msb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kun makita niyo na nagasararingsing na ini, naaaraman na halapit na an kwaresma didi sa aton. ");
INSERT INTO msb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sugad man kun makita niyo idtoʼn mga pangyayari, maaaraman na niyo na halapit na maghadi sa kinab-an an Dios. ");
INSERT INTO msb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ginasiguro ko sa iyo na mangyayari idtoʼn tanan antes na magkamaratay an mga tawo na nabuhay yana. ");
INSERT INTO msb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","An langit kag duta mawawara pero magapadayon hasta na lang an akon mga surmaton.” ");
INSERT INTO msb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kaya maghimat kamo! Ayaw pagkasibot sa mga kalipayan, paghurubugan kag pagkahandal sani na buhay kay basi ina na adlaw nag-abot sin bigla pareho san paglabtik san padlong. ");
INSERT INTO msb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mangyayari man ini sa tanan na mabubuhay sana na adlaw. ");
INSERT INTO msb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaya kinahanglan man gayod kamo magbantay kag nagapangadyi agod makalibre sa tanan na mangyayari kag agod makaatubang sa akon na Anak San Tawo.” ");
INSERT INTO msb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uruadlaw nagatukdo si Jesus sa templo pero pagkagab-i nagapakadto siya sa Bukid San Kaolibohan kag didto nagapalipas san gab-i. ");
INSERT INTO msb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tapos pagkamaaga nagatiripon na an tanan na katawuhan patalibod niya sa templo para magpamati sa iya. ");
INSERT INTO msb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Niyan halapit na an kapyistahan san Tinapay Na Waraʼn Lebadura na ginatawag Paskwa. ");
INSERT INTO msb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","An mga namumuno san kapadian kag mga paratukdo san Kasuguan nagahanap sin paagi para ipapatay si Jesus pero dili ninda mahimoʼn hayag kay nahahadlok sinda sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Didi sinudlan ni Satanas si Judas na an apilyido Iscariote, usad san dose. ");
INSERT INTO msb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nagkadto siya sa mga namumuno san kapadian kag sa mga opisyales san mga gwardya para iristoryahan an plano sa pagtraydor niya kan Jesus. ");
INSERT INTO msb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nalipay gayod sinda kag nagtuga na hatagan si Judas sin kwarta. ");
INSERT INTO msb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nag-uyon siya kaya tuna sadto nagahanap siya sin maayo na oportunidad agod patraydor na iintriga si Jesus sa inda na dili mamalisyahan san mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nag-abot an adlaw san kapyistahan san Tinapay Na Waraʼn Lebadura kun san-o an dapat na pagpatay san iharalad na kordero na kakaunon para sa Paskwa. ");
INSERT INTO msb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sana na adlaw ginsugo ni Jesus sinda Pedro kag Juan na nagasabi, “Kadto kamo kag ihanda an pagkaon para sa Paskwa agod kaunon naton.” ");
INSERT INTO msb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Diin mo gusto ihanda ini?” an hunga ninda. ");
INSERT INTO msb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nagsabat siya, “Pamati, pagsulod niyo sa syudad, may makakasugat kamoʼn lalaki na may daraʼn tibod na tubig. Sundon niyo siya hasta sa sulod san balay na iya pagasudlan kag ");
INSERT INTO msb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","didto sabihon sa tag-iya sani, ‘Nagapahunga sa imo an Maestro, Hain an kwarto para sa mga bisita kun diin makaon ako san handa san Paskwa kaupod san akon mga disipulos.’ ");
INSERT INTO msb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","May itutukdo siya sa iyo sin dako na kwarto sa ibabaw na kompleto na sin garamiton kag preparado na. Didto kamo maghanda para sa aton.” ");
INSERT INTO msb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nagkadto an duha na disipulos kag nakita ninda an tanan na ginsabi sa inda. Kaya ginpreparar ninda an pagkaon sa Paskwa. ");
INSERT INTO msb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pag-abot san oras nag-ingkod na si Jesus para magkaon kaupod an iya mga apostoles. ");
INSERT INTO msb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sinabihan niya sinda, “Kaila ko na gayod na makadungan kamo pagkaon sani na kaunon sa Paskwa antes san akon pagtios, ");
INSERT INTO msb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","kay dili ko na ngani ini maootro hasta na an gusto sabihon sani matuman sa kahadian san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pakatapos may ginkuha siya na kupa kag, pakapasalamat sa Dios, nagsabi, “Batuna niyo ini kag mag-irinom kamo didi. ");
INSERT INTO msb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ginasiguro ko sa iyo na tuna niyan dili na ako mainom san duga san mga ubas hasta na mag-abot na an pagahadi san Dios.” ");
INSERT INTO msb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pakatapos nagkuha siyaʼn tinapay kag pakapasalamat gin-utud-utod kag pinanghatag sa inda na nagasabi, “Ini an akon lawas na ginahatag ko para sa iyo. Kaunon niyo ini bilang pagdumdom sa akon.” ");
INSERT INTO msb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sugad man ginkuha niya an kupa pakatapos san panigab-i kag nagsabi, “Didi sani na kupa amo an pagpamatuod san bag-o na sinumpaan san Dios na ipapatuman paagi sa akon dugo na ipapaawas para sa iyo. ");
INSERT INTO msb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero kitaa kay adi kaupod ko pagkaon an matraydor sa akon. ");
INSERT INTO msb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mangyayari sa akon na Anak San Tawo an susog sa ginbuot san Dios pero kamakangingirhat man san kastigo san matraydor sa akon!” ");
INSERT INTO msb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kaya nagtuna sinda pagpahurunga-hunga kun sin-o man gayod sa inda an makahimo sani. ");
INSERT INTO msb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nagsuruay man sinda kun sin-o sa inda an pagakilalahon na pinakalabaw. ");
INSERT INTO msb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Didi sinabihan sinda ni Jesus, “Sa mga dili-Judio an mga hadi amo an may pagsakop sa inda kag idtoʼn may otoridad sa inda amo an ginatawag na mga parapangataman. ");
INSERT INTO msb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero iba kamo kay an pinakalabaw sa iyo dapat mag-ugali bilang pinakamanghod sa tanan kag an namumuno mag-ugali bilang suruguon, ");
INSERT INTO msb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","kay sin-o man gali an mas labaw, an ginasirbihan o an nagasirbe? Syimpre an ginasirbihan gayod. Pero adi ako kaupud-upod niyo bilang usad na nagasirbe! ");
INSERT INTO msb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kamo an mga nagapabilin na kaupod ko sa akon mga kalisudan. ");
INSERT INTO msb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kaya ginahatag ko sa iyo an gahom san pagsakop pareho san paghatag sa akon san akon Ama ");
INSERT INTO msb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","agod makakaon kamo kag makainom kaupod ko didto sa akon kahadian kag makaingkod sa mga trono agod maghusgar san dose na mga lahi san Israel.” ");
INSERT INTO msb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Didi naman nag-istorya si Jesus, “Simon, Simon, paglikay kay nangayo si Satanas na porbaran ka agod magbaya ka sa akon na bagaʼn pagpabulag san upa sa bugas, ");
INSERT INTO msb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pero ginpangadyi ta ikaw, Simon, na dili man lugod mawara an imo pagtuod kag kun maulian ka na sani pakusuga man an imo mga kamanghudan sa pagtuod.” ");
INSERT INTO msb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nagsabat si Simon, “Ginoo, preparado ako magpapriso kag mamatay kaupod mo.” ");
INSERT INTO msb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Didi nagsurmaton si Jesus, “Pedro, may ginasabi ako sa imo na dili pa ngani maturaok an manok yana na adlaw pagapaambutan mo akoʼn tulo na beses na kilala mo ako.” ");
INSERT INTO msb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pakatapos ginhunga man sinda ni Jesus, “San suguon ta kamo na waraʼn pitaka, surudlan o sandalyas, nano, nagkulang kamo?” “Wara,” an sabat ninda. ");
INSERT INTO msb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sinabihan niya sinda, “Pero yana kun igwa kamoʼn pitaka darha ina. Kun may surudlan darha man. Kun wara kamoʼn sundang ibaligya an iyo ginasul-ot kag magbakal, ");
INSERT INTO msb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","kay matuod gayod na matutuman sa akon an mga surmaton san Banal Na Kasuratan na amo ini, ‘Ginbiyo siya sa mga kriminal.’ Matuod na an nasasabi sa Banal Na Kasuratan manungod sa akon natutuman na.” ");
INSERT INTO msb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Niyan nagsabi sinda, “Ginoo, igwa didi sin duha na sundang!” “Tama na ina!” an sabat niya. ");
INSERT INTO msb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nagluwas si Jesus sa syudad kag pareho san iya nakaugalian na nagpakadto sa Bukid San Kaolibohan. Nagsunod man an mga disipulos. ");
INSERT INTO msb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pag-abot ninda didto nagtugon siya, “Mangadyi kamo agod dili matintaran.” ");
INSERT INTO msb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pakatapos nagpauruunhan siya sa dili na siya mababatian kag nagluhod para mangadyi, ");
INSERT INTO msb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama, kun maayo sa kabubut-on mo halia man tabi sa akon ini na kupa pero dili an akon pagbuot kundi an sa imo lugod an masunod.” ");
INSERT INTO msb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Didi may nagpakita sa iya na anghel hali sa langit na nagpasarig sa iya. ");
INSERT INTO msb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Dahilan san grabe na kasakit inungod pa gayod niya an iya pagpangadyi kag nagtururo an iya balhas sa duta na bagaʼn tinuro san dugo. ");
INSERT INTO msb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagtindog niya pakapangadyi binalikan an mga disipulos kag naabtan na tururog dahilan sa kapagalan ninda tungod sa dako na kamunduan. ");
INSERT INTO msb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tapos naghunga siya, “Nano kay tururog kamo? Bangon kag mangadyi kamo agod dili madaog san tintasyon.” ");
INSERT INTO msb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nagasurmaton pa si Jesus san may nag-abot na mga tawo na ginapangunahan ni Judas na usad san dose. Ginhalapitan niya si Jesus agod harukan. ");
INSERT INTO msb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero ginhunga siya ni Jesus, “Judas, pagatraydoran mo ba ako na Anak San Tawo paagi sa harok?” ");
INSERT INTO msb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pakakita san mga kaurupod ni Jesus kun nano an mangyayari naghunga, “Ginoo, nano, gamiton na namon an amon mga sundang?” ");
INSERT INTO msb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tapos usad sa inda an tumigbas sa suruguon san pinakapuno san kapadian kag nautas an tuo na talinga. ");
INSERT INTO msb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero nagsurmaton si Jesus, “Ayaw kamo sana!” Pakatapos dinapatan niya an nautudan san talinga kag nagkaigwa gihapon iniʼn talinga. ");
INSERT INTO msb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sani naman nagsurmaton si Jesus sa mga namumuno san kapadian, sa mga namumuno san mga gwardya san templo kag sa mga namumuno san mga Judio na nagkadto pagdakop sa iya, “Nano, tulisan an paghuna niyo sa akon kay nagdarara pa kamoʼn mga talibong kag mga balbag? ");
INSERT INTO msb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sa pag-ururupod naton uruadlaw sa templo wara niyo ako pagdakupa. Pero amo na ini an ginahulat niyo na oras na pagdakop sa akon. Amo man an paglabaw san poder ni Satanas sa kaduluman san karautan.” ");
INSERT INTO msb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Niyan, pakadakupa kan Jesus san mga nag-arestar sa iya, dinara sa balay san pinakapuno san kapadian. Si Pedro naman nakasunod pero sa huruharayo. ");
INSERT INTO msb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nagdabok sinda sa tunga san natad kag nag-ingkod patalibod sani. Nag-ingkod man si Pedro katakin ninda. ");
INSERT INTO msb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","San nagaingkod na siya didto sa nabanaagan san kalayo, may nakakita sa iya na suruguon na babayi, tinurok siya kag sinabihan, “Ini siya kaupod man sana na tawo.” ");
INSERT INTO msb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero nagpaambot si Pedro, “Babayi, dili ko siya kilala.” ");
INSERT INTO msb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Taud-taod may nakakita naman sa iya kag nagsabi, “Usad ka man san kaupod sana na tawo.” “Amigo, dili ako,” an sabat ni Pedro. ");
INSERT INTO msb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pakalipas san mausad ka oras may nagpirit gayod na nagasabi, “Sigurado gayod na ini siya kaupod man sana na tawo kay taga-Galilea man siya.” ");
INSERT INTO msb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero nagsabat si Pedro, “Amigo, ambot kun nano an ginasabi mo.” Sadto mismo tumuraok an manok myintras nagasurmaton pa siya. ");
INSERT INTO msb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pakatapos liningi si Pedro san Ginoo kag sinud-ong. Didto nadumduman ni Pedro an ginsabi sa iya, “Antes magturaok an manok yana na adlaw pagapaambutan mo na ako sin tulo na beses.” ");
INSERT INTO msb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Didi naghali si Pedro kag nagparabakho gayod. ");
INSERT INTO msb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Niyan gintuya-tuya kag ginpasakitan si Jesus san mga nagabantay sa iya. ");
INSERT INTO msb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tinahuban man ninda an iya mga mata kag ginmanda, “Abir, tigmaha daw kun sin-o an nagsuntok sa imo.” ");
INSERT INTO msb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tapos nagpadayon sinda sin sobra na pagtuya-tuya sa iya. ");
INSERT INTO msb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkaaga nagkaigwa sin pagtiripon an mga namumuno san mga Judio kaurupod san mga namumuno san kapadian kag mga paratukdo san Kasuguan. Ginpaatubang siya ninda sa inda Konseho. ");
INSERT INTO msb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tapos sinabihan siya ninda, “Sabihi kami kun ikaw man gayod an Cristo.” Nagsabat si Jesus, “Kun sabihan ta kamo dili man gihapon kamo matuod ");
INSERT INTO msb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kag kun hungaon ta kamo dili man kamo masabat. ");
INSERT INTO msb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero magtuna yana magaingkod ako na Anak San Tawo sa pinakaimportante na pwesto sa may tuo san Makagagahom na Dios.” ");
INSERT INTO msb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kaya an tanan naghunga, “An gusto mo sabihon na ikaw an Anak San Dios?” Nagsabat si Jesus, “Kamo an nagsabi sana.” ");
INSERT INTO msb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sa katapus-tapusi nagsarabi sinda, “Nano pa man na mga testigos an kinahanglan ta? Nabatian na naton mismo sa iya sadiri na panurmaton.” ");
INSERT INTO msb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tumindog an bilog na konseho kag dinara ninda si Jesus kan Pilato na gobernador. ");
INSERT INTO msb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pag-abot didto, gintunaan ninda pag-akusara si Jesus sani, “Naaraman namon ini na tawo na ginasulsulan an mga tawo na kontrahon an amon nasyon. Ginabawal an pagbayad sin buwis kan Cesar kag nagaangkon na siya mismo si Cristo, usad na hadi.” ");
INSERT INTO msb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hinunga siya ni Pilato sani, “Nano, ikaw an hadi san mga Judio?” “Ikaw an nagsabi sana,” an sabat ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kaya sinabihan ni Pilato an mga namumuno san kapadian kag an katawuhan, “Wara akoʼn makita na may sala ini na tawo.” ");
INSERT INTO msb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero nagpirit sinda, “Paagi sa pagtukdo niya ginapasamok an mga tawo sa bilog na Judea magtuna sa Galilea hasta didi.” ");
INSERT INTO msb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pakabati sani ni Pilato, naghunga siya kun taga-Galilea ini na tawo. ");
INSERT INTO msb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pakaaram na nasasakupan siya ni Herodes, gin-agi anay si Jesus kan Herodes na adto man sa Jerusalem sadto na mga adlaw. ");
INSERT INTO msb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pakakita niya kan Jesus nalipay siya kay nabati na niya an manungod kan Jesus kag nagahandom gayod na makita siya na nagahimoʼn milagro. ");
INSERT INTO msb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kaya damo siyaʼn ginhunga kan Jesus pero wara gayod siya pagsabata. ");
INSERT INTO msb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Grabe man na mga akusasyon na ginasarabi kontra sa iya san mga namumuno san kapadian kag mga paratukdo san Kasuguan na adto didto. ");
INSERT INTO msb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ginapakaaluhan kag ginatuya-tuya siya ni Herodes kaurupod an iya mga suldados. Pakatapos sinul-utan siya sin matahom na kapa kag binalik kan Pilato. ");
INSERT INTO msb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sadto man mismo na adlaw nagkaamigo gihapon sinda Herodes kag Pilato na dati anay magkaaway. ");
INSERT INTO msb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ginpatipon naman ni Pilato an mga namumuno san kapadian, mga namumuno san mga Judio kag san katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tapos ginsabihan, “Gindara niyo sa akon ini na tawo bilang usad na nagasulsul san katawuhan pagkontra sa gobyerno. Niyan gin-usisa ko na siya sa atubangan niyo pero wara naman akoʼn nakita na may sala siya. ");
INSERT INTO msb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Abir man ngani si Herodes. Kaya ginpabalik siya sa aton. Niyan wara gayod siyaʼn nahimo na sala na dapat siya ipapatay. ");
INSERT INTO msb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kaya ipalatigo na lang siya pakatapos paulion.” ");
INSERT INTO msb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nagdurungan sinda tanan pagsiriyak, “Patayon ina na tawo! Ipaluwas sa amon si Barabas!” ");
INSERT INTO msb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ini na Barabas napriso tungod na kaupod san pagsamok sa syudad kag pagpatay. ");
INSERT INTO msb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kay gusto ni Pilato palibrihon si Jesus nakisurmaton siya sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero nagsiriyak lugod sinda, “Ipako siya sa krus! Ipako siya!” ");
INSERT INTO msb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sa ikatulo na beses ginhunga ni Pilato an katawuhan, “Kay nano? Nano an karautan na nahimo niya? Wara akoʼn makita na dahilan kontra sa iya na dapat siya patayon, kaya ipalatigo ko na lang siya kag pakatapos palibrihon.” ");
INSERT INTO msb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero nagpirit gayod sinda kag nagsiriyak sin makusog na gusto gayod ninda ipapako si Jesus. Sa katapus-tapusi napasunod ninda si Pilato. ");
INSERT INTO msb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kaya nagmanda siya na matuman an inda kagustuhan. ");
INSERT INTO msb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ginpalibre an gin-ayo ninda na tawo na napriso tungod sa pagsamok kag pagpatay pero gin-intriga si Jesus para mangyari an inda kagustuhan. ");
INSERT INTO msb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","San ginapalakat na san mga suldados si Jesus para ipako sa krus may hali sa uma na tawo na an ngaran si Simon na taga-Cirene. Ginpirit ninda siya na magpas-an san krus na ginadara ni Jesus kag magsunod sa iya. ");
INSERT INTO msb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nagsurunod man sa iya an damu-damo na mga tawo hasta mga babayi man na nagamundo kag naganguyngoy parasa iya. ");
INSERT INTO msb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero liningi sinda ni Jesus kag sinabihan, “Mga kababayihan na taga-Jerusalem, ayaw niyo ako pagtangisi kundi tangisi an iyo sadiri kag san iyo mga kaanakan. ");
INSERT INTO msb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sigurado gayod na may maabot na mga adlaw na masarabi an mga tawo, ‘Malipay idtoʼn mga baog, mga babayi na waraʼn anak kag wara gayod magpadudo!’ ");
INSERT INTO msb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sana na maabot na panahon ‘sisiyakan san mga katawuhan an mga kabukidan, Tumpagi kami! kag sa mga bakilid, Tahubi kami!’ ");
INSERT INTO msb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kay kun sugad sani an ginahimo sa akon na bagaʼn sanga na buhay pa, nano an pagahimuon sa iyo na mga Judio kay kamo bagaʼn kahoy na uga na?” ");
INSERT INTO msb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","May duha na kriminal na ginpaupod man guyod agod patayon kaupod ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pag-abot ninda tanan sa lugar na ginatawag na Bungo, didto ginpako san mga suldados si Jesus sa krus kag amo man an duha na kriminal sa magluyo niya. Tapos ginpatindog ini tanan. ");
INSERT INTO msb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Niyan, nagsurmaton si Jesus, “Ama ko, patawada sinda kay dili ninda aram an inda ginahimo.” Pakatapos ginbarahin ninda an iya mga sul-ot paagi sa pagparipahan. ");
INSERT INTO msb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nagamarasid didto an mga miron sa iya pero ginaparatuya-tuya siya san mga namumuno san mga Judio. An sabi ninda, “May ginsalbar siya na mga iba, niyan, ipasalbar man daw niya mismo an iya sadiri kun siya man gayod an Cristo, an Pinili san Dios!” ");
INSERT INTO msb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","An mga suldados naman gintuya-tuya siya kag gintunulan sin suka ");
INSERT INTO msb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na nagasabi, “Kun ikaw man gayod an hadi san mga Judio isalbar an imo sadiri!” ");
INSERT INTO msb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sa may uluhan niya igwaʼn nakasurat, “AMO INI AN HADI SAN MGA JUDIO.” ");
INSERT INTO msb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gintuya-tuya man siya san usad san mga kriminal na nakapako, “Dili ka ba an Cristo? Isalbar daw an sadiri mo hasta kami.” ");
INSERT INTO msb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ginsaway siya san usad, “Wara ka baʼn kahadlok sa Dios na adi pareho mo man ginkondinar? ");
INSERT INTO msb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pero dapat lang na mangyari ini sa aton kay ginabalusan lang kita san aton pagkakasala. Pero ini na tawo wara gayod sin nahimo na kasal-an.” ");
INSERT INTO msb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pakatapos sinabihan niya si Jesus, “Jesus, dumduman ako pag-abot mo sa imo kahadian.” ");
INSERT INTO msb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","“Ginasiguro ko sa imo na yana mismo kaupod ta ikaw sa Paraiso,” an sabat ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mga alas dose an udto san magdulom an bilog na nasyon hasta na mga alas tres an hapon. ");
INSERT INTO msb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Myintras nagadulom an adlaw natungà pagkagisi an kurtina san templo. ");
INSERT INTO msb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tapos sumiyak si Jesus na nagasabi, “Ama ko, sa imo mga kamot ginaintriga ko an akon espirito.” Pakasabi niya sani nautsan na siya. ");
INSERT INTO msb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pakakita san namumuno san mga suldados sani na pangyayari nag-umaw sa Dios kag nagsabi, “Matuod man gayod na matanos ini na tawo.” ");
INSERT INTO msb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kaya an tanan na katawuhan na nagtiripon pagmiron nag-uruli na ginapukpok an inda dughan sa grabe na kamunduan. ");
INSERT INTO msb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Myintras sa huruharayo nagamarasid naman an tanan na mga kakilala ni Jesus hasta man an mga kababayihan na nag-urupod sa iya hali sa Galilea kag nakita ninda an tanan na mga pangyayari. ");
INSERT INTO msb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Niyan may nag-abot na myimbro san Konseho na an ngaran Jose na taga-Arimatea. Maayo siya kag matanos kag nabubuhay sa paglaom na makita man an kahadian san Dios. Dili siya nag-uyon sa ginplano kag ginhimo san mga kaurupod niya na mga Judio. ");
INSERT INTO msb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kaya ini siya nagpakadto kan Pilato kag gin-ayo an lawas ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pakatunton niya sani sa krus pinutos sa tela na lino kag linubong sa rulubngan na ginkutkot sa bato na wara pa gayod nalubngi. ");
INSERT INTO msb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Adlaw ini sadto san Pagpreparar kag halapit na pagtuna an Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nagsurunod naman kan Jose an mga kababayihan na nag-urupod kan Jesus paghali sa Galilea. Nakita ninda an ginlubngan kag an pakapamutang san patay. ");
INSERT INTO msb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tapos nag-uli sinda kag nagpreparar sin mga pahumot para sa lawas ni Jesus. Nagpahuruway na sinda pagka-Adlaw San Pagpahuway susog sa ginapatuman san Kasuguan. ");
INSERT INTO msb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","San maaga pa san primero na adlaw san semana nagbalik an kababayihan sa rulubngan na dara an ginpreparar ninda na mga pahumot. ");
INSERT INTO msb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pag-abot didto nakita ninda na napaligid na an bato na nakatahob sa luho san rulubngan, ");
INSERT INTO msb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","pero pagsulod ninda, wara na didto an lawas san Ginooʼn Jesus. ");
INSERT INTO msb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Myintras nagatindog sinda didto na dili aram kun nano an himuon, may duha na lalaki na nagpakita sa inda na nakasilaw an sul-ot. ");
INSERT INTO msb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sa dako na kahadlok nagduko an mga babayi. Pero ginhunga sinda san duha na lalaki, “Nano kay ginahanap niyo sa mga patay an buhay? ");
INSERT INTO msb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wara na siya didi. Nabuhay siya gihapon. Dumduma niyo an iya ginsabi san adto siya sa Galilea ");
INSERT INTO msb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","na siya na Anak San Tawo dapat iintriga sa mga makasasala, ipapako sa krus kag tapos sa ikatulo ka adlaw mabubuhay gihapon.” ");
INSERT INTO msb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Didi nadumduman ninda an ginpanurmaton ni Jesus. ");
INSERT INTO msb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","San pagbalik san kababayihan hali sa rulubngan ginsumat ninda an tanan sa onse na apostoles kag sa iba pa. ");
INSERT INTO msb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","An kababayihan na nagsurumat sa mga apostoles amo sinda Maria Magdalena, Juana, Maria na iloy ni Santiago kag san iba na mga kaurupod na babayi. ");
INSERT INTO msb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ini na inda ginbarita bagaʼn himu-himo lang sa paghuna san mga apostoles kaya dili ninda gintuudan. ");
INSERT INTO msb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kaya lang si Pedro bumangon kag dumalagan sa rulubngan. Pagsudip niya nakita na lang an ginputos na tela kag wara naʼn iba. Pakatapos nag-uli na siya na nagaisip kun nano an nangyari sa lawas. ");
INSERT INTO msb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sana mismo na adlaw may duha na disipulos na nagalakat pakadto sa usad na baryo na ginatawag Emaus mga onse ka kilometro hali sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Myintras nagalakat ginaistoryahan ninda an manungod san tanan na mga nangyari. ");
INSERT INTO msb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","San sige an inda istoryahan nakisabay mismo si Jesus sa inda. ");
INSERT INTO msb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero bagaʼn may nagapugol sa inda para dili siya makilala. ");
INSERT INTO msb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hinunga sinda ni Jesus, “Nano an ginaparaistoryahan niyo sa iyo pagalakat?” Umudong sinda na mamunduon. ");
INSERT INTO msb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kaya nagsabat an usad sa inda na an ngaran Cleopas, “Ikaw ba lang gayod ada an nagpa-Jerusalem na dili maaram san mga nangyari didto san nakaligad na mga adlaw?” ");
INSERT INTO msb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Sa nano?” an iya hunga. Sinabat siya ninda, “Manungod kan Jesus na taga-Nazaret. Ini siya makagagahom na propeta sa gawi kag surmaton sa mata san Dios kag sa katawuhan. ");
INSERT INTO msb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gin-intriga siya san mga namumuno san kapadian kag san amon man mga namumuno sa mga Judio para ipapatay, tapos ginpapako ninda sa krus. ");
INSERT INTO msb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ginlauman pa namon na siya an masalbar san Israel kag pwera pa sani ikatulo yana ka adlaw san pakapangyari sani. ");
INSERT INTO msb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Usad pa, ginpangalas kami san mga babayi na kaurupod namon. Maaga pa kuno nagpakadto sinda sa ginlubngan kag ");
INSERT INTO msb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","san wara ninda makita an lawas ni Jesus nagbalik sinda na may barita manungod sa mga anghel na nagpakita sa inda kag nagsabi na siya buhay. ");
INSERT INTO msb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nagkaradto naman sa ginlubngan an iba san amon mga kaurupod kag nakita ninda an tanan na ginsabi sa inda san mga babayi pero wara ninda makita si Jesus.” ");
INSERT INTO msb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Didi sinabihan ni Jesus an duha, “Mga tanga na mga tawo, mga matugas pagpatuudon san tanan na ginsabi san mga propeta! ");
INSERT INTO msb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nano, dili na kinahanglan sana na Cristo magtios pakatapos amo na ipaitaas sa kalangitan kag didto galangan san Dios Ama?” ");
INSERT INTO msb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kaya agod mapadumdom sinda magtuna kan Moises hasta sa tanan na mga propeta ginpahayag ni Jesus sa inda an nasusurat sa Banal Na Kasuratan manungod sa iya sadiri. ");
INSERT INTO msb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","San nagahalapit na sinda sa baryo na inda kakadtuan, si Jesus bagaʼn magapadayon kuntani sa iya paglakat. ");
INSERT INTO msb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero ginhawidan ninda siya na nagasabi, “Didi ka na lang anay sa amon kay tunod na an adlaw kag magab-i na.” Kaya nag-upod si Jesus sa inda. ");
INSERT INTO msb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","San makaraon na sinda, kinuha niya an tinapay kag nagpasalamat sa Dios pakatapos pinihak-pihak kag ginpanghatag sa inda. ");
INSERT INTO msb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Didi namuklat an inda kaisipan kag nakilala ninda siya. Pakatapos bigla siyaʼn nawara. ");
INSERT INTO msb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Niyan, nagpahunga-hunga sinda, “Dili ba nakabatyag kitaʼn bagaʼn kaiba sa aton tagipusuon myintras nakiistorya siya sa aton sa dalan kag ginpahayag an Banal Na Kasuratan?” ");
INSERT INTO msb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sadto mismo nagbalik sinda sa Jerusalem. Nakita ninda didto an onse na nagtiripon kaurupod san iba pa. ");
INSERT INTO msb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ginsabihan an duha, “Matuod man gayod na nabuhay an Ginoo mala ngani kay nagpakita siya kan Simon.” ");
INSERT INTO msb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gin-istorya naman san duha an nangyari sa inda sa dalan kag kun pan-o man nindaʼn nakilala an Ginoo sa pagpihak san tinapay. ");
INSERT INTO msb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nagairistoryahan pa sinda manungod sani tanan san maghayag bigla si Jesus na nakatindog sa inda atubangan kag sinabihan sinda, “An kalinawan hali sa Dios mapasa iyo.” ");
INSERT INTO msb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nginarat sinda kag nagkaharadlok kay an huna ninda multo idto! ");
INSERT INTO msb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero nagsurmaton si Jesus, “Nano kay nagakaharadlok kamo kag nagaduda? ");
INSERT INTO msb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kitaa niyo an akon mga kamot kag san tiil. Matuod na ako ini. Kapti niyo ako kag kitaa sin maayo. Waraʼn multo na may lawas pareho gayod san nakikita niyo sa akon na igwa.” ");
INSERT INTO msb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pakasabi niya sani ginpakita an iya mga kamot kag tiil. ");
INSERT INTO msb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Surusobra gayod an inda kalipay pero bagaʼn dili sinda makatuod. Nagkamurungnan sinda. Tapos nagpadayon siya pagsurmaton, “Nano, igwa kamo didiʼn makaon?” ");
INSERT INTO msb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kaya ginhatagan ninda siya sin inihaw na isda ");
INSERT INTO msb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","na binaton man niya kag kinaon sa inda pagkita. ");
INSERT INTO msb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Niyan, sinabihan pa niya sinda, “Amo ini an gusto ko ipasabot san pagsabi ko sadto san kaupod pa ako niyo na dapat mangyari an tanan na nakasurat manungod sa akon sa Kasuguan ni Moises, sa mga surat san mga propeta kag sa mga Salmo.” ");
INSERT INTO msb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kaya ginpamuklat niya an inda kaisipan agod masabutan an Banal Na Kasuratan. ");
INSERT INTO msb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Sinabihan niya sinda, “Ini an nasurat na magatios an Cristo kag sa ikatulo ka adlaw mabubuhay gihapon. ");
INSERT INTO msb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Niyan, dapat igatukdo sa gahom san iya ngaran an manungod san pagbasol kag pagbaya sa pagkasala para sa kapatawadan san mga kasal-an. Igapalukop ini sa entiro na kinab-an magtuna sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kamo gayod an mga testigos sani. ");
INSERT INTO msb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Tandai niyo, igasugo ko sa iyo an Espirito Santo na gintuga san akon Ama. Didto lang anay kamo sa syudad hasta na mag-abot sa iyo hali sa langit ini na gahom san Espirito.” ");
INSERT INTO msb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pakatapos ginpaupod sinda ni Jesus hasta sa Betania. Pag-abot didto tinaas niya an iya mga kamot kag ginbendisyunan sinda. ");
INSERT INTO msb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","San ginabendisyunan niya sinda, ginapaharayo siya na ginapahitaas palangit. ");
INSERT INTO msb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pakasamba ninda sa iya nagbalik sinda sa Jerusalem na malipay gayod. ");
INSERT INTO msb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tapos adto na sinda pirme sa templo nagaumaw sa Dios.");
INSERT INTO msb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antes pa ngani ginlalang san Dios an kinab-an, igwa naʼn ginatawag na Surmaton. Ini na Surmaton kaupod niya kag an Surmaton amo an Dios. ");
INSERT INTO msb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Magkaupod sinda sa katuna-tunai pa, ");
INSERT INTO msb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","kag paagi sa iya ginlalang san Dios an tanan. Wara gayod sin nahimo na dili paagi sa iya. ");
INSERT INTO msb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Siya an ginhalinan san buhay kag an buhay niya nagin kapaw-an sa katawuhan. ");
INSERT INTO msb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ina man na kapaw-an nagabanaag sa kaduluman kag wara gayod ina kayaha sani. ");
INSERT INTO msb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Niyan, igwaʼn sinugo na tawo an Dios na an ngaran Juan. ");
INSERT INTO msb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","An katuyuan sani amo an pagpamatuod manungod sadtoʼn kapaw-an agod paagi sa iya magtuod sana an tanan. ");
INSERT INTO msb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Dili siya an kapaw-an kundi an magapamatuod sani, ");
INSERT INTO msb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","kay sadto nagapakadi sa kinab-an an matuod na kapaw-an na nagapabanaag sa mga isip san tanan na katawuhan. ");
INSERT INTO msb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dati adi na siya sa kinab-an kag bisan ngani ginlalang ini paagi sa iya, dili siya kilala san mga tawo sa kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nagkadto siya sa iya sadiri na lugar pero wara siya pag-akua san iya mga kalahi. ");
INSERT INTO msb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero sadtoʼn mga nag-ako kag nagtuod sa iya ginhatagan niyaʼn otoridad na magin mga anak san Dios. ");
INSERT INTO msb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ini sinda nagin mga anak san Dios dili hali sa pagpakatawo, ni sa lawasnon na kaila, ni sa pagbuot san tawo kundi sa pagbuot san Dios mismo. ");
INSERT INTO msb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Niyan, idtoʼn ginatawag na Surmaton nagin tawo kag nag-istar kaupod namon. Mabuot gayod siya kag kamatuudan an pirme niya ginasurmaton. Nakita man namon an glorya san iya pagkadios. Amo ini an glorya san bugtong na anak san Ama. ");
INSERT INTO msb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Amo siya an ginpamatuudan ni Juan san magpanawagan, “Amo ini na tawo an ginasabi ko san ginsurmaton ko na siya na maabot kasunod ko mas labaw ki sa akon, tungod na ada na siya sa katuna-tunai pa antes ngani ako gin-anak.” ");
INSERT INTO msb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Niyan, paagi sa dako niya na pagkamuot, nakabaton man kita tanan sin sunod-sunod na mga bendisyon. ");
INSERT INTO msb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","An Kasuguan san Dios nakaabot sa aton paagi kan Moises pero an grasya kag kamatuudan san Dios paagi kan Jesu-Cristo. ");
INSERT INTO msb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wara pa gayod sin nakakita san Dios kundi an bugtong na anak na Dios man. Siya na palangga san Ama amo man an nagpakilala san Dios mismo. ");
INSERT INTO msb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","San nagsugo an mga namumuno san mga Judio sin mga padi kag mga Levita hali sa Jerusalem agod hungaon si Juan kun sin-o siya, amo ini an pagsabat niya. ");
INSERT INTO msb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“Dili ako an Cristo na gintuga san Dios,” an hayagan niya na pagsumat. ");
INSERT INTO msb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tapos naghunga sinda sa iya, “Sin-o ka man gali? Ikaw ba si Elias?” Nagsabat siya, “Dili ako.” “Nano, ikaw an propeta na gintuga san Dios?” hunga naman ninda. “Dili,” an ginsabat niya. ");
INSERT INTO msb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ginhunga gihapon siya ninda, “Sin-o ka man gayod? Sabata kami agod masabi namon sadtoʼn nagsugo sa amon. Nanoʼn masabi mo manungod sa imo sadiri?” ");
INSERT INTO msb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Didi siya nagpahayag paagi sa mga surmaton san propeta na si Isaias, “Ako an nagapanawagan sa disyerto, ‘Tadunga an agihan san Ginoo.’,” ");
INSERT INTO msb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Niyan, ini na mga tawo an sinugo san mga Pariseo ");
INSERT INTO msb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kag nagpadayon sinda paghunga sa iya, “Nano kay nagapangbunyag ka kun dili ka man gali an Cristo, ni si Elias, ni an propeta?” ");
INSERT INTO msb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nagpahayag gihapon si Juan sa inda, “Nagabunyag ako sin tubig pero may usad sa iyo na dili niyo nakikilala. ");
INSERT INTO msb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nagapakadi siya kasunod ko, kay mas labaw pa siya sa akon, dili ako angay bisan maghubad san sintas san iya sandalyas.” ");
INSERT INTO msb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nangyari ini sa Betania sa unhan san suba san Jordan kun diin siya nagapangbunyag. ");
INSERT INTO msb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","San sunod na adlaw pakakita kan Jesus na nagatulos, nagsabi si Juan, “Kitaa, adi an kordero san Dios na magahali san mga sala san katawuhan sa kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amo na ini an tawo na ginaparasabi ko: usad na tawo na maabot kasunod ko na mas labaw sa akon kay ada na siya sa katuna-tunai pa antes ngani ako gin-anak. ");
INSERT INTO msb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dili ko siya kilala sadto pero siya an dahilan kun nano kay ginpakadi ako sa pagbunyag sin tubig agod ipakilala siya sa aton na mga taga-Israel.” ");
INSERT INTO msb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Amo ini an ginpahayag pa ni Juan, “Nakita ko na nagalusad an Espirito hali sa langit nagapaitsura bagaʼn salampati kag nagpabilin sa iya. ");
INSERT INTO msb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dili ko pa gihapon siya kilala sadto pero ginsabihan ako san nagsugo sa akon na magbunyag na magsabi, ‘An tawo na makita mo na lusadan san Espirito kag pirmehan sani, amo na ina an magapambunyag paagi sa paghatag san Espirito Santo.’,” ");
INSERT INTO msb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tapos nagpadayon pa si Juan, “Nakita ko man gayod ini kag ginapamatuudan ko sa iyo na siya an Anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagkasunod na adlaw adto man gihapon si Juan. May kaupod siyaʼn duha na disipulos. ");
INSERT INTO msb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nagsabi si Juan san makita niya na nagalabay si Jesus, “Kitaa! Siya an kordero san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pakabati sani sumunod kan Jesus an duha na disipulos. ");
INSERT INTO msb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paglingi ni Jesus nakita sinda na nagasunod kag ginhunga, “Nano an gusto niyo?” Nagsabat sinda, “Rabi, (na an gusto sabihon, Maestro) diin ka nagaistar?” ");
INSERT INTO msb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Kadi kamo kag kitaa,” an sabat ni Jesus. Kaya nag-upod sinda kag nakita kun diin man gayod siya nagaistar. Kay maalas kwatro na an hapon, nagpabilin sinda kaupod niya sadto na adlaw. ");
INSERT INTO msb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Usad sani na duha na nagsunod kan Jesus pakabati san ginsabi ni Juan amo si Andres na kamanghod ni Simon Pedro. ");
INSERT INTO msb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ginhanap dayon niya an iya kamanghod kag sinabihan, “Naagihan na namon an Mesias (na an gusto sabihon, Cristo).” ");
INSERT INTO msb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pakatapos, gin-upod niya siya kan Jesus. Tinurok si Pedro ni Jesus kag sinabihan, “Ah, ikaw gali si Simon na anak ni Juan. Pagangaranan ka sin Cefas,” (ini pareho san ngaran na Pedro na an gusto sabihon, “bato”). ");
INSERT INTO msb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagkasunod na adlaw nakaisip pagkadto si Jesus sa Galilea. Didto pakahanap kan Felipe sinabihan niya, “Mag-upod ka sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ini si Felipe taga-Betsaida kag kahilungsod ninda Andres kag Pedro. ");
INSERT INTO msb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tapos pakahanap naman ni Felipe kan Nataniel sinumatan, “Nataniel, naagihan na namon siya na ginsurat ni Moises sa libro na may Kasuguan kag ginsurat man san mga propeta. Siya si Jesus an anak ni Jose na taga-Nazaret.” ");
INSERT INTO msb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Taga-Nazaret? Nano, may maayo pa na nagahali sana na lugar?” an hunga ni Nataniel. “Kadi baya kag kitaa,” an sabat naman ni Felipe. ");
INSERT INTO msb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pakakita ni Jesus na nagatulos si Nataniel, nagsabi siya, “Kitaa siya na tunay na Israelita kay waraʼn kabuwaan sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Pan-o ka nakaaram sa akon?” an hunga ni Nataniel. Nagsabat si Jesus, “San adto ka pa sa tungod san kahoy na higera, nakita ta ikaw antes ka gintawag ni Felipe.” ");
INSERT INTO msb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","An sabat ni Nataniel, “Maestro, ikaw an Anak san Dios! Ikaw an hadi san Israel!” ");
INSERT INTO msb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Naghunga naman si Jesus, “Nano, nagtuod ka lang mili kay nagsabi ako na nakita ta ikaw san adto ka pa sa tungod san kahoy na higera? Mas labaw pa sana na mga bagay an makikita mo.” ");
INSERT INTO msb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tapos nagpadayon pa siya, “Matuod gayod na makikita niyo an pag-abri san langit kag an mga anghel san Dios nagasarakat-lusad pakadi sa akon na Anak San Tawo.” ");
INSERT INTO msb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pag-ikatulo ka adlaw nagkaigwa sin kasalan sa Cana didto sa Galilea. Adto na an iloy ni Jesus, ");
INSERT INTO msb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","kag imbitado man sani na kasalan sinda Jesus kag san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","San maubusan san bino sinabihan si Jesus san iya iloy, “Wara na sindaʼn bino.” ");
INSERT INTO msb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ginsabat naman niya ini, “Ayaw ako pag-idamay kay dili ko pa panahon.” ");
INSERT INTO msb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero sinabihan san iya iloy an mga suruguon, “Himua niyo an isugo niya sa iyo.” ");
INSERT INTO msb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Niyan, igwa didtoʼn unom na tapayan san tubig para paghugas susog sa nakaugalian na san mga Judio. An kada usad sani sulod sin 20 pa 30 ka galon. ");
INSERT INTO msb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tapos sinabihan ni Jesus an mga suruguon, “Pun-a niyoʼn tubig ina na mga tapayan.” Kaya pinuno man gayod ninda. ");
INSERT INTO msb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“O, hala, pagtabo na kamo kag darhi an nagapamahala sani na ponsya,” an sabi niya sa inda. Kaya dinarhan ninda. ");
INSERT INTO msb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Niyan, aram san mga suruguon na hali sa tubig idtoʼn bino pero dili ina aram san nagapamahala. Kaya pakatimtimi niya sana na tubig na nagin bino, tinawag niya an kinasal na lalaki, ");
INSERT INTO msb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tapos sinabihan niya, “Kadamuan, an una na ginasirbihan maayo na bino kag ginatago anay an maluya na klaseʼn irimnon hasta na damo naʼn nainom an mga bisita, pero kamo, gintigana an maayo na bino hasta niyan.” ");
INSERT INTO msb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ini na ginhimo ni Jesus sa Cana san Galilea amo an tuna san iya mga milagro. Didto ginpakita niya an iya gloryoso na gahom kaya an mga disipulos nagturuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pakatapos sani, naglugsad si Jesus sa Capernaum kaupod an iya iloy, an iya mga kamaranghod kag mga disipulos. Didto nag-istar sinda sin pira lang ka adlaw. ");
INSERT INTO msb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","San mapaskwa na san mga Judio, nagsagka si Jesus sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Didto sa templo nakita niya an mga tawo na nagabaraligyaʼn baka, karnero, mga salampati kag san mga parabalyoʼn kwarta na sibot sa inda negosyo. ");
INSERT INTO msb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pakahimo ni Jesus sin latigo na pisi, gin-abog sinda tanan sa templo hasta an mga baka kag mga karnero. An mga sinsilyo san mga parabalyoʼn kwarta binu-bo man niya kag tinumba an inda mga lamesa. ");
INSERT INTO msb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tapos gin-uritan ni Jesus an mga parabaligyaʼn salampati, “Halia niyo ini didi! Ayaw paghimua na merkado an balay san akon Ama.” ");
INSERT INTO msb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Didi nadumduman san iya mga disipulos an nasurat sa Banal Na Kasuratan: “O, Dios Ama, bagaʼn kalayo na mapatay sa akon an pagmalasakit sa imo balay.” ");
INSERT INTO msb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tapos nagpakiaram an mga namumuno san mga Judio kag naghunga, “Nano an ikapakita mo sa amon na tanda na may poder ka na himuon ini?” ");
INSERT INTO msb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nagsabat si Jesus, “Kun rubaon niyo ini na templo, titindugon ko gihapon sa sulod san tulo ka adlaw.” ");
INSERT INTO msb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ginsabihan naman siya san mga Judio, “Tulo la ka adlaw! Nano na! 46 anyos gintrabaho ini na templo. Nano, matitindog mo ada ini sa sulod la sin tulo ka adlaw?” ");
INSERT INTO msb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero an ginasurmaton ni Jesus na templo amo an iya lawas. ");
INSERT INTO msb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kaya san pagkabuhay gihapon niya, an iya mga disipulos nakadumdom na ginsabi niya ini kaya man ngani nagturuod sinda sa Banal Na Kasuratan kag san mga surmaton na iya ginsabi. ");
INSERT INTO msb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Myintras si Jesus adto sa Jerusalem para sa paskwa damo an nagtuod sa iya pakakita san mga milagro na iya ginhimo. ");
INSERT INTO msb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero wara ginpaniwala ni Jesus an iya sadiri sa inda kay aram gayod niya an tanan manungod san mga tawo. ");
INSERT INTO msb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dili na kinahanglan na tukduan pa siya manungod sa inda kay siya mismo maaram na san tagipusuon san tawo. ");
INSERT INTO msb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Igwaʼn Pariseo na an ngaran Nicodemo. Usad siya na namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Usad sin gab-i nagkadto siya kan Jesus kag naghunga, “Maestro, aram namon na maestro ka na hali sa Dios dahilan na waraʼn makahimo sani na mga milagro na ginaparahimo mo kun wara dida sa iya an Dios.” ");
INSERT INTO msb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nagsabat si Jesus, “Matuod gayod na kun may tawo na dili ianak otro para sa Dios dili siya magin sakop sani.” ");
INSERT INTO msb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero naghunga si Nicodemo, “Pan-o ianak gihapon an gurang na? Nano, makabalik pa siya sa tiyan san iya iloy kag ianak gihapon?” ");
INSERT INTO msb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nagsabat naman si Jesus, “Matuod gayod na an dili ianak gihapon paagi sa tubig kag Espirito dili makasulod sa kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","An gin-anak sa tawo may buhay na pagkatawo kag an gin-anak gihapon sa Espirito san Dios may buhay na pagkadios hali naman sana na Espirito. ");
INSERT INTO msb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ayaw pagngalas na ginsabihan ko ikaw na dapat ianak otro kamo tanan. ");
INSERT INTO msb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Halimbawa, nagapakadto an hangin kun hain sani gusto kag bisan nababatian an hagunos dili mo aram kun diin hali o kun diin makadto. Bagaʼn sugad man sana an paghimo san Espirito sa gin-anak niya.” ");
INSERT INTO msb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nalisang si Nicodemo kaya naghunga gihapon, “Pan-o ina mangyari?” ");
INSERT INTO msb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ginsabat siya ni Jesus, “Bantog ka na maestro sa Israel kag dili mo ba ini nasasabutan? ");
INSERT INTO msb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Matuod gayod na ginasurmaton lang namon an amon naaaraman kag an amon nakita ginatestigo, pero dili niyo ginatuudan an amon ginasabi. ");
INSERT INTO msb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dili ngani niyo ginatuudan an ginasurmaton ko manungod sa mga nangyayari sa kinab-an kaya pan-o kamo magtuod sa akon kun magsurmaton ako sa iyo manungod sa nangyayari sa kalangitan. ");
INSERT INTO msb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wara pa sin nakasaka sa langit kundi ako na Anak San Tawo na naglusad hali sa langit. ");
INSERT INTO msb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dapat pa man ihitaas ako na Anak San Tawo pareho san ginhitaas ni Moises sa disyerto an ginhimo niya na bagaʼn sawa, ");
INSERT INTO msb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agod an may pagsarig sa akon magkakaigwaʼn buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Matuod na kay namut-an gayod san Dios an katawuhan san kinab-an, kaya ginsugo ngani niya an iya bugtong na anak agod an buhay sani magigin halad para sa inda kasal-an. Niyan, dili mawawar-an sin buhay an may pagsarig sa iya kundi magkakaigwa lugod sin buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dili ginsugo san Dios an iya anak pakadi sa kinab-an para maghusgar, kundi paagi sa iya masalbar an katawuhan san kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Waraʼn huhusgaran na nagatuod sa iya anak pero an dili nagatuod sa iya ginhusgaran na tungod na wara siyaʼn pagsarig sani na anak san Dios. ");
INSERT INTO msb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","An ginbasihan san paghusgar amo ini: nagpakadi sa kinab-an an ilaw pero mas naiilaan san mga tawo an kadulman ki sa kapaw-an kay mga maraot an ginaparahimo ninda. ");
INSERT INTO msb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kay an nagaparahimoʼn karautan habo san kapaw-an kag nagalikay sana kay nahadlok na basi maaraman an iya mga ginahimo. ");
INSERT INTO msb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero an nabubuhay sa kamatuudan an nagapahalapit sa kapaw-an agod makita sin maayo na an iya mga ginahimo susog sa kagustuhan san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pakatapos sani nagpakadto sinda Jesus kag san iya mga disipulos sa lugar san Judea. Nag-istar siya didto kaupod ninda kag nagapambunyag. ");
INSERT INTO msb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sadto man na panahon nagapambunyag man si Juan sa Enon halapit sa Salim dahilan na damo didtoʼn tubig, kaya damoʼn tawo an nagakaradto agod magpabunyag pa sa iya. ");
INSERT INTO msb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nangyari ini antes san pakapriso ni Juan. ");
INSERT INTO msb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Niyan, an mga disipulos ni Juan kag san usad na Judio nagasuruay manungod sa paghugas na nakaugalian na san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kaya nagpakaradto sinda kan Juan kag nagsumat, “Rabi, idtoʼn kaupod mo sa unhan san Jordan na gintestigusan mo, adi na naman siya nagapambunyag kag an tanan nagakaradto na sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nagsabat si Juan, “Waraʼn bantog sugad sana an tawo kun dili ginatugot sa iya san Dios. ");
INSERT INTO msb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamo mismo an mga testigo na nagsabi ako na dili ako an Cristo, kundi ako lang an ginsugo na mag-una sa iya. ");
INSERT INTO msb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Halimbawa, an karaslon na babayi para sa karaslon na lalaki pero an abay san karaslon na lalaki na adto didto kag nakabati san iya boses nalilipay gayod, kaya sugad sani niyan malipay-lipay gayod ako. ");
INSERT INTO msb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sigurado na siya magigin bantog pero ako naman dapat magpahunod,” sabi ni Juan. ");
INSERT INTO msb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Labaw sa tanan siya na tagalangit. An tagakinab-an naman tagakinab-an lang gayod kag pareho man san mga tagakinab-an an iya panurmaton. Kaya labaw man gayod an tagalangit. ");
INSERT INTO msb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nagatestigo siya sa iya mga nakita kag nabatian pero mga pira lang an nagatuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero an tanan na nagaako san iya ginatestigo nagapamatuod na matuod an ginsabi san Dios, ");
INSERT INTO msb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","kay siya na ginsugo san Dios amo an nakasurmaton san iya mensahe dahilan na an Espirito Santo na ginhatag sa iya san Dios biyo na sa gahom. ");
INSERT INTO msb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Namumuot an Ama sa Anak kag ginpabuot sa iya an tanan. ");
INSERT INTO msb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","An nagatuod sa Anak nagakaigwaʼn buhay na waraʼn katapusan, pero an dili nagatuod sa Anak dili magakaigwa sana na buhay kundi ada sa iya an grabe na kaurit san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pakaarami ni Jesus na nabaritaan san mga Pariseo na mas damo siyaʼn nadadara kag nabubunyagan ki kan Juan, ");
INSERT INTO msb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","bisan pa ngani dili si Jesus an nagabunyag kundi an iya mga disipulos, ");
INSERT INTO msb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","naghali siya sa Judea kag nagbalik sa Galilea. ");
INSERT INTO msb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sa iya pagpakadto pagaagihan niya an Samaria. ");
INSERT INTO msb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kaya sa iya paglakaton nakaabot siya sa usad na lungsod san Samaria na gintawag Sicar na halapit sa uma na ginhatag sadto ni Jacob sa iya anak na si Jose. ");
INSERT INTO msb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Adto didto an bubon sadtoʼn Jacob. Nag-ingkod si Jesus sa kilid sani kay pagal siya sa iya paglakaton kag maalas dose na sadto. ");
INSERT INTO msb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Taud-taod may nag-abot na Samaritana na maalog. Ginsabihan ni Jesus an babayi, “Painuma man.” ");
INSERT INTO msb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Myintras an iya mga disipulos naman adto na sa lungsod agod magbakal sin makaon. ");
INSERT INTO msb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ginsabihan siya san Samaritana, “Nano, ikaw na Judio mangayo sa akon sin mainom na ako Samaritana?” (Nagsabi siya sani kay an mga Judio dili nakiupod sa mga Samaritano.) ");
INSERT INTO msb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nagsabat si Jesus, “Kun aram mo lang an ginahatag san Dios kag kun sin-o ini na nagapangayo sa imoʼn mainom, ikaw pa an mangayo sa iya kag pagahatagan sin tubig na nagahatag-buhay.” ");
INSERT INTO msb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","An hunga naman sa iya san babayi, “Sir, wara ka sin ikatimba kag hadalom an bubon. Diin ka makuha sana na tubig na nagahatag-buhay. ");
INSERT INTO msb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pwera pa sani, ginhimo ini kasadto san amon kalulululuhi na si Jacob para sa amon kag didi siya mag-inom kag san iya mga kaanakan, bisan man ginpainuman san iya mga kahayupan. Nano, mas labaw ka pa sa iya?” ");
INSERT INTO msb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Amo ini an sabat sa iya ni Jesus, “Mapapaha gihapon an nagainom sani na tubig, ");
INSERT INTO msb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero dili na gayod mapapaha pa an mag-inom san tubig na ihahatag ko pero magigin bagaʼn burabod ina sa iya na tubig na magabulos kag hahatagan siya san buhay na waraʼn katapusan.” ");
INSERT INTO msb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nagsabat an babayi, “Sir, hatagi ako sana na tubig agod dili na ako mapaha kag dili na magparakadi pag-alog.” ");
INSERT INTO msb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sinabihan siya ni Jesus, “Kadto, tawaga an imo asawa tapos magbalik ka.” ");
INSERT INTO msb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nagsabat an babayi, “Wara ako sin asawa.” Ginsabihan siya ni Jesus, “Tama an sabi mo na wara kaʼn asawa ");
INSERT INTO msb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kay nagkaigwa ka sin lima kag an kaupod mo yana dili mo tunay na asawa. Tama gayod an ginsabi mo!” ");
INSERT INTO msb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Didi nagsabat an babayi, “Ah, sigurado, sir, propeta ka. ");
INSERT INTO msb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","An amon mga kalulululuhi didi sani na bukid nagasamba sa Dios pero kamo na mga Judio nagasabi na didto sa Jerusalem an dapat na lugar pagsambahan sa iya san mga tawo.” ");
INSERT INTO msb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nagsabi si Jesus, “Maʼm, tuudi ako! Halapit na an oras na kamo masamba sa Ama dili sani na bukid o sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nagasamba kamo san dili niyo kilala pero kami na mga Judio kilala namon an amon ginasamba kay paagi sa amon gintuga san Dios an pagkasalbar san mga tawo. ");
INSERT INTO msb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Halapit na an oras kag adi na yana na an tunay na mga nagasamba magaumaw gayod sa Ama paagi sa Espirito Santo kag kamatuudan. Amo ina an klaseʼn nagasamba na naiilaan niya. ");
INSERT INTO msb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Espirito an Dios kag an nagasamba sa iya dapat na magsamba paagi sa Espirito kag may kamatuudan.” ");
INSERT INTO msb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","An sabat san babayi, “Aram ko na maabot an Mesias na amo an Cristo. Pag-abot niya ipapahayag sa amon an tanan.” ");
INSERT INTO msb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Didi siya ginsabihan ni Jesus, “Ako na nakiistorya sa imo amo na an ginasabi mo.” ");
INSERT INTO msb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pakasabi gayod niya sani, amo man an pag-abot san iya mga disipulos. Nginarat sinda pakakita na nakiistoryahan siya sa usad na babayi pero wara sa inda sin naghunga, “Nano an gusto mo maaraman sa iya?” o “Nano kay nakiistoryahan ka sa iya?” ");
INSERT INTO msb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tapos binilin san babayi an iya tibod, nagpakadto sa lungsod kag gin-agda an mga tawo, ");
INSERT INTO msb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hamos baya kamo kag kitaa kay may tawo na nagsabi sa akon san tanan ko na nahimo. Amo na kaya ini an Cristo?” ");
INSERT INTO msb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kaya nagruluwas sinda sa lungsod kag nagpakadto kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Myintras tanto, ginpirit si Jesus san mga disipulos, “Maestro, kaon anay tabi.” ");
INSERT INTO msb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero ginsabat pa lugod niya sinda, “Igwa akoʼn pagkaon na dili niyo aram.” ");
INSERT INTO msb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pakabati sani nagpahurunga-hunga an mga disipulos, “Nano, may nagdara sa iyaʼn pagkaon?” ");
INSERT INTO msb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Didi nagpahayag si Jesus: “An akon pagkaon amo an pagtuman san kabubut-on san nagsugo sa akon kag an pagtapos san ginpahimo niya. ");
INSERT INTO msb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nano, dili may kasabihan kamo: ‘Upat ka bulan pa kag tig-anihan na?’ Pero kitaa an iyo patalibod! Tig-anihan na baga! ");
INSERT INTO msb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","An nagaani may suhol ngani kag nakatipon sin produkto para sa buhay na waraʼn katapusan agod pareho magakalipay an parasabwag kag paraani. ");
INSERT INTO msb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kaya matuod an kasabihan, ‘An usad nagasabwag pero an iba naman nagaani sani.’ ");
INSERT INTO msb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Halimbawa, ako nagsugo sa iyo agod mag-ani san dili niyo ginpaglan pagsabwag. An iba an nagpagal pero kamo an nagpulos san inda pinagalan.” ");
INSERT INTO msb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sana mismo damo na mga Samaritano sadto na lungsod an nagtuod kan Jesus dahilan san ginsabi san babayi, “Sinabi niya an tanan ko na hinimo.” ");
INSERT INTO msb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Niyan, pagtulos san mga Samaritano, naghangyo na magpabilin anay si Jesus sa inda. Kaya didto siya nagpalipas sin duha ka adlaw. ");
INSERT INTO msb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tungod sani damo pa an nagturuod dahilan san iya mga katukduan. ");
INSERT INTO msb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kaya ginsabihan ninda an babayi, “Niyan, dili lang kami nagatuod dahilan san imo ginsumat kundi nabatian pa gayod namon siya mismo kag naaraman na siya man gayod an Parasalbar san kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pakalipas san duha ka adlaw si Jesus nagpa-Galilea, ");
INSERT INTO msb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","kay siya mismo nagsabi na waraʼn ginagalangan na propeta sa iya sadiri na lugar. ");
INSERT INTO msb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pag-abot niya didto, ginpadayon siya san mga taga-Galilea kay san nakipamyista sinda sa Jerusalem para sa Paskwa nakita ninda an tanan na ginhimo niya didto. ");
INSERT INTO msb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Niyan, nakabalik gihapon si Jesus sa Cana san Galilea kun diin ginhimo niya an tubig na bino. Igwa didto sa Capernaum sin opisyal na may anak na masakit. ");
INSERT INTO msb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pakabati sani na opisyal na si Jesus nag-abot sa Galilea hali sa Judea, nagkadto siya sa iya sa Cana kag nakimaluoy kan Jesus na maglugsad sa Capernaum agod ayuhon an iya anak na tikamatayon. ");
INSERT INTO msb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tapos ginhunga siya ni Jesus, “Nano, dili kamo magaturuod sa akon kun dili kamo nakakita sin mga tanda kag mga milagro?” ");
INSERT INTO msb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ginsabihan gihapon siya san opisyal, “Ginoo, kadto man anay tabi antes mamatay an akon anak.” ");
INSERT INTO msb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nagsabat si Jesus, “Uli na, maayo na an imo anak.” Nagtuod an tawo san ginsabi sa iya ni Jesus kaya naglakat na siya. ");
INSERT INTO msb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","San nagapauli na siya, sinugat siya san iya mga suruguon na nagbarita na maayo na an iya anak. ");
INSERT INTO msb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pakabati sani, ginhunga niya sinda kun nanoʼn oras naulian an bata kag ginsabihan siya ninda, “Kagahapon na mga ala una an adlaw siya nahaw-asan san iya kalintura.” ");
INSERT INTO msb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nadumduman san ama na sana man na kaurason siya ginsabihan ni Jesus na, “Maayo na an imo anak.” Kaya siya mismo nagtuod kag san bilog niya na panimalay. ");
INSERT INTO msb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Amo ini an ikaduha na milagro na ginhimo ni Jesus san pagkadto niya sa Galilea hali sa Judea. ");
INSERT INTO msb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagpira ka adlaw nagpa-Jerusalem si Jesus para sa usad na pyista san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Didto sa Jerusalem sa may ginatawag na Pwertahan San Mga Karnero igwa sin kariguan na tangke na sa Hebreo ginatawag na Betsata. Ini na kariguan igwaʼn lima na sirungan. ");
INSERT INTO msb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Didto damoʼn nakahigda na mga masakiton, mga buta, mga pilay kag mga paralisado. ");
INSERT INTO msb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","May tawo na adto didto na 38 anyos na an ginabatyag. ");
INSERT INTO msb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pakakita sa iya ni Jesus na nakahigda didto kay dati na niya aram na dugay na ini na kamutangan san tawo ginhunga niya, “Gusto mo na mag-ayo ka gihapon?” ");
INSERT INTO msb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","An sabat san masakiton na tawo, “Sir, waraʼn mabulig sa akon pakadto sa tangke sa oras na an tubig ginahiwag. Kaya myintras nagahalapit ako igwa na sin nauuna sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nagsugo si Jesus, “Tindog, bitbita an imo banig kag lakat.” ");
INSERT INTO msb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nag-ayo dayon siya, binitbit an iya banig kag naglakat. Adlaw sadto San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kaya ginsabihan san mga namumuno san mga Judio an nabulong na tawo, “Adlaw baga niyan San Pagpahuway. Dili tugot na magdara ka san imo banig.” ");
INSERT INTO msb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero sinabat niya sinda, “An tawo na nagbulong sa akon nagsabi, ‘Bitbita an imo banig kag lakat.’,” ");
INSERT INTO msb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naghunga sinda, “Sin-o an nagsugo sa imo na himuon ini?” ");
INSERT INTO msb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wara makilala san tawo kun sin-o idto na nagbulong sa iya kay nakahali na si Jesus tungod sa kadamuan san tawo. ");
INSERT INTO msb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Taud-taod, nahanapan siya ni Jesus sa templo kag nagsabi, “Niyan na maayo ka na, ayaw na pagparakasala kay basi mas grabe pa sadto an mangyari sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nagbalik an tawo kag sinumat sa mga namumuno san mga Judio na si Jesus an nagbulong sa iya. ");
INSERT INTO msb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kaya didi gintunaan san mga namumuno san mga Judio an pagpakaalo kan Jesus tungod kay ginhimo niya ini sa Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ginsabat sinda ni Jesus, “An akon Ama nagatrabaho pa kag amo man ako.” ");
INSERT INTO msb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Dahilan sani mas lalo na gusto siya ipapatay san mga namumuno san mga Judio kay dili lang na ginsupak niya an Kasuguan kun Adlaw San Pagpahuway kundi gintawag pa gayod niya an Dios na iya Ama. Kaya ginatumpar an iya sadiri na pareho san Dios. ");
INSERT INTO msb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Didi nagpahayag si Jesus, “Matuod gayod na wara ako sin nahihimo sa sadiri ko na pagbuot kundi an nano man lang na nakita ko na ginahimo san akon Ama. An nano man na ginahimo niya ginahimo ko man na iya anak. ");
INSERT INTO msb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Namumut-an san Ama ako na iya anak kag ginapakita sa akon an tanan na iya ginahimo. Tapos, mas labaw pa sani an ipapakita niya sa akon agod magngalas gayod kamo. ");
INSERT INTO msb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kun pan-o ginabuhay san Ama an patay, amo man ako na Anak niya. Ginabuhay ko an sin-o man na gusto ko buhayon. ");
INSERT INTO msb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Waraʼn ginahusgaran an Ama kundi hinatag niya sa akon na iya Anak an tanan na gahom san paghusgar ");
INSERT INTO msb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","agod maggalang an tanan sa akon na Anak niya pareho san paggalang ninda sa akon Ama. An dili nagagalang sa Anak dili man nagagalang sa Ama na amo an nagsugo sa iya. ");
INSERT INTO msb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Matuod gayod na an nagapamati sa akon kag nagatuod sa nagsugo sa akon magkakaigwa sin buhay na waraʼn katapusan. Kaya dili na siya pagahusgaran kundi ada na sa iya ina na buhay imbes na kamatayon. ");
INSERT INTO msb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Matuod gayod na halapit na an oras kag adi na ngani gayod na an mga tawo na bagaʼn patay magabati san boses ko na Anak san Dios. An tanan naman na nakabati kag magatuman san akon mga surmaton an mabubuhay. ");
INSERT INTO msb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Dahilan na an ginhalinan san buhay an Ama, hinatag man niya sa akon na iya anak an gahom agod magin halinan man san buhay. ");
INSERT INTO msb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ginhatagan pa akoʼn otoridad sa paghusgar tungod na Anak ako San Tawo. ");
INSERT INTO msb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ayaw pagngalas sani kay maabot pa an oras na an tanan na nasa rulubngan makabati san boses ko. ");
INSERT INTO msb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tapos idtoʼn mga maayoʼn hinimuan mabarangon na ada na sa inda an hasta na lang na buhay pero idtoʼn naghirimoʼn karautan mabarangon man pero huhusgaran pa. ");
INSERT INTO msb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Wara akon mahihimo sa akon sadiri na gahom. Makahusgar lang ako susog sa akon nabati hali sa Dios. Niyan, matanos an akon pagahusgar tungod na an akon katuyuan na matuman an kabubut-on san nagsugo sa akon, dili sa akon sadiri na kabubut-on. ");
INSERT INTO msb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kun nagatestigo ako manungod sa akon sadiri dili ina tunay na pagpamatuod. ");
INSERT INTO msb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero igwaʼn iba na nakatestigo sa akon kag aram ko na matuod an pagtestigo niya sa akon. ");
INSERT INTO msb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“May ginsugo kamo kan Juan kag nagtestigos siya san kamatuudan manungod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dili gusto sabihon na nagasarig ako sa pagtestigo na hali sa tawo kundi ginasabi ko ini agod masalbar kamo. ");
INSERT INTO msb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bagaʼn nagalaad kag nagabanaag na ilaw si Juan kag sa iya ilaw naiila kamo na magkalipay anay sin kadali. ");
INSERT INTO msb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Igwa akoʼn pagtestigo na mas labaw pa ki san kan Juan. An ginahimo ko na amo an ginapahimo sa akon san Ama amo ini na pagtestigo na nagapamatuod na sinugo niya ako. ");
INSERT INTO msb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","An Ama na nagsugo sa akon, siya mismo nagatestigo man manungod sa akon. Dili pa niyo nabatian an iya boses o nakita an iya hitsura ");
INSERT INTO msb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","kag an iya surmaton dili pa niyo ginaako kay dili kamo nagatuod sa iya sinugo. ");
INSERT INTO msb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ginaadalan niyo an Banal Na Kasuratan kay sa paghuna niyo didi magahanap kamoʼn buhay na waraʼn katapusan pero ini mismo nagapamatuod gayod manungod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero habo gihapon kamo magkadi sa akon agod magkaigwaʼn buhay. ");
INSERT INTO msb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Dili ko kinahanglan an pag-umaw na hali sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero naaraman ko na wara kamoʼn pagkamuot sa Dios. ");
INSERT INTO msb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nagkadi ako na may otoridad hali sa akon Ama pero wara ako niyo pag-akua. Kun may magkadi sa iyo na may sadiri siya na otoridad, aakuon niyo. ");
INSERT INTO msb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Dili man gayod kamo makatuod sa akon kay an ginaasikaso niyo an pagdayaw sa usad kag usad pero an pagdayaw san amo lang na Dios dili niyo ginahandom. ");
INSERT INTO msb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ayaw paghuna na ako an magaakusar sa iyo sa atubangan san Ama. Si Moises na ginalauman niyo amo an nagaakusar sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kun nagtuod gayod kamo kan Moises, magatuod man kamo sa akon kay nagsurat siya manungod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero pan-o kamo makatuod san akon mga surmaton kun dili kamo nagatuod san iya mga kasuratan?” ");
INSERT INTO msb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pakalipas san pira na adlaw nagkadto si Jesus patabok san Danaw san Galilea na ginatawag man na Danaw san Tiberias. ");
INSERT INTO msb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","May kadamuan man na nagsurunod sa iya kay nakita ninda an mga milagro na hinimo niya sadtoʼn mga masakiton. ");
INSERT INTO msb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tapos nagsagka si Jesus sa bukid kag nag-ingkod didto kaupod an iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Halapit na an pyista san Paskwa san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Paglantaw ni Jesus nakita niya an damo na mga tawo na nagadangadang kaya ginhunga kan Felipe, “Diin kita makabakal sin pagkaon para ipakaon sani na mga tawo?” ");
INSERT INTO msb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ginhunga niya ini bilang pagporbar kan Felipe kay aram na niya an iya hihimuon. ");
INSERT INTO msb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nagsabat si Felipe, “Dili pa makapaigo an suhol para sa walo ka bulan para ibakal sin pagkaon agod ipakaon sa kada usad sa inda bisan dyutay la gayod.” ");
INSERT INTO msb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Si Andres na kamanghod ni Simon Pedro, usad man siya san mga disipulos ni Jesus, nagsabi sa iya, ");
INSERT INTO msb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Igwa didi sin bata kag may dara siyaʼn lima ka bilog na tinapay kag duha ka bilog na isda pero sing-ano lang ina sani na kadamuan?” ");
INSERT INTO msb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sinabihan sinda ni Jesus, “Paingkuda niyo an mga tawo.” May halapad didto na kadinghutan kaya nag-iringkod sinda. Malima ka libo sadto an kalalakihan lang. ");
INSERT INTO msb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pakatapos kinuha ni Jesus an tinapay, nagpasalamat sa Dios kag ginpangpahatag sadto tanan na nagairingkod. Amo man an ginhimo niya sa duha ka bilog na isda kag nagkaraon sinda hasta na nagkaburusog. ");
INSERT INTO msb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","San burusog na sinda, ginsabihan ni Jesus an iya mga disipulos, “Tipuna niyo an mga sobra na wara gayod sin matiawan.” ");
INSERT INTO msb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kaya tinipon ninda kag dose pa na bangkat an napuno san sobra san nagkaraon san lima na tinapay. ");
INSERT INTO msb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pakakita sani na milagro na ginhimo ni Jesus, nagsabi an mga tawo, “Amo gayod ini an propeta na mapakadi sa kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aram ni Jesus na pipiriton siya ninda na magin hadi kaya nagdulag siya na sulo lang pabukid. ");
INSERT INTO msb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pagkagab-i an mga disipulos ni Jesus nagpabaybayon. ");
INSERT INTO msb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tapos nagsakay sinda sa sarakyan kag nagtuna pagtalabok sa danaw pakadto sa Capernaum. Madulom na sadto pero wara pa si Jesus. ");
INSERT INTO msb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mabalod pa kay makusog an hangin. ");
INSERT INTO msb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","San nakarimo na sinda sin mga unom ka kilometro, nalantawan ninda si Jesus na nagalakat sa ibabaw san tubig kag nagatulos sa sakayan. Kaya nagkaharadlok gayod sinda, ");
INSERT INTO msb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","pero sinabihan sinda ni Jesus, “Ako ini. Ayaw kamo kahadlok.” ");
INSERT INTO msb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tapos malipay sinda na pasakayon si Jesus kag taud-taod nakaabot an sakayan sa kadtuan ninda. ");
INSERT INTO msb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagkaaga an mga tawo na nagpabilin sa baybayon sa luyo san danaw aram na usad na lang an sakayan na adto didto kahapon. Aram man ninda na si Jesus wara mag-upod sa sakayan na ginsakyan san iya mga disipulos kay naghali na sinda lang. ");
INSERT INTO msb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero igwa sin mga sakayan na hali sa Tiberias na nagdungka halapit sa lugar na ginkaunan ninda san tinapay pakapasalamat san Ginoo. ");
INSERT INTO msb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pakakita san mga tawo na wara didto si Jesus hasta an iya mga disipulos, sinda mismo nagsarakay sa mga sarakyan kag nagpakadto sa Capernaum na nagahanap kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","San nakita ninda si Jesus sa luyo na baybayon san danaw naghunga sinda sa iya, “Maestro, kasan-o ka pa didi?” ");
INSERT INTO msb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nagsabat si Jesus, “Matuod gayod na nangingita kamo sa akon dili kay sa mga milagro na nakita niyo kundi kay nagkaburusog kamo san tinapay na iyo ginkaon. ");
INSERT INTO msb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayaw pagparapagal sin pagkaon na nasisira kundi an pagkaon na matagal para sa buhay na waraʼn katapusan. Amo ini an pagkaon na ako na Anak San Tawo magahatag sa iyo kay ako an ginhatagan san Dios Ama san otoridad agod himuon ini.” ");
INSERT INTO msb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kaya ginhunga siya ninda, “Nano an dapat namon na himuon agod mahimo namon an naiilaan san Dios?” ");
INSERT INTO msb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ginsabat sinda ni Jesus, “Amo ini an naiilaan san Dios na magtuod kamo sa ginsugo niya.” ");
INSERT INTO msb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kaya naghurunga pa sinda, “Nano man na milagro an ikapakita mo sa amon agod magtuod kami sa imo? Abir, nano an hihimuon mo? ");
INSERT INTO msb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bisan ngani an aton mga kalulululuhan sa disyerto nagkaraon sin ginatawag na mana sugad san nasurat sa Banal Na Kasuratan na ‘Ginhatagan niya sinda sin pagkaon na makaon hali sa langit.’,” ");
INSERT INTO msb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nagsabat si Jesus, “Matuod gayod na an naghatag sa iyo sin pagkaon na hali sa langit dili si Moises kundi an akon Ama. Siya an nagahatag sa iyo sin tunay na pagkaon na hali sa langit. ");
INSERT INTO msb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ini na pagkaon san Dios amo an naghali sa langit kag nagahatag sin buhay sa kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nagsabi sinda, “Sir, hatagi kami pirme sana na pagkaon.” ");
INSERT INTO msb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Didi nagpahayag si Jesus: “Ako an pagkaon na nagahatag sin buhay. An makiusad sa akon dili gayod gugutumon hasta na lang kag an magtuod sa akon dili man papahaon hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero pareho san ginsabi ko sa iyo, dili kamo nagatuod sa akon bisan ngani nakita na niyo ako. ");
INSERT INTO msb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","An tanan na tawo na ginatiwala sa akon san Ama makiusad sa akon kag an mga makiusad sa akon dili ko gayod pagahabuan ");
INSERT INTO msb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kay naglusad ako hali sa langit para tumanon an kabubut-on san nagsugo sa akon kag dili an sadiri ko na kabubut-on. ");
INSERT INTO msb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Niyan, an gusto san nagsugo sa akon amo ini: na dili ko pagwaraon bisan usad san tanan na mga gintiwala niya sa akon kundi buhayon gihapon sinda tanan sa katapusan na adlaw. ");
INSERT INTO msb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Matuod na ini an kagustuhan san akon Ama. An tanan na nakakita sa anak kag nagatuod sa iya magkakaigwa sin buhay na waraʼn katapusan kag bubuhayon ko gihapon siya sa katapusan na adlaw.” ");
INSERT INTO msb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Didi nagtuna pagngurob-ngurob sa iya an mga namumuno na mga Judio tungod kay nagsabi siya, “Ako an pagkaon na naghali sa langit.” ");
INSERT INTO msb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kaya nagsarabi sinda, “Dili ba ini si Jesus na anak ni Jose? Kilala naton an iya ama kag iloy. Pan-o niya masabi na naglusad siya hali sa langit?” ");
INSERT INTO msb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nagsabat si Jesus, “Ayaw kamo pagngurob-ngurob. ");
INSERT INTO msb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wara sin makiusad sa akon kun dili ipahalapit san Ama na nagsugo sa akon. Tapos, bubuhayon ko siya sa katapusan na adlaw. ");
INSERT INTO msb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nasurat sa libro san propeta na si Isaias, ‘Tapos, pagatukduan sinda tanan san Dios!’ An nagapamati kag nakaaram sa Ama nakiusad sa akon. ");
INSERT INTO msb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dili gusto sabihon na may nakakita na sa Ama pwera san naghali sa iya. Siya lang gayod an nakakita sa Ama. ");
INSERT INTO msb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Matuod gayod na an may pagtuod sa akon an nagakaigwa sin buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ako an pagkaon na nagahatag-buhay. ");
INSERT INTO msb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nagkamaratay ngani an aton mga kalulululuhan sa disyerto bisan nagkaraon sin mana. ");
INSERT INTO msb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Niyan, adi na an pagkaon na hali sa langit. An magkaon sani dili mamamatay. ");
INSERT INTO msb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako man an buhay na pagkaon na naglusad hali sa langit. An magkaon sani na pagkaon mabubuhay hasta na lang kag an pagkaon na igahatag ko amo an akon lawas agod mabuhay an katawuhan san kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pakasabi ni Jesus sani, nagsuruay gayod an mga Judio kag nagpahurunga-hunga sinda. “Pano an paghatag sani na tawo san iya lawas agod makaon naton?” ");
INSERT INTO msb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kaya sinabihan sinda ni Jesus, “Matuod gayod na kun dili niyo makaon an lawas ko na Anak San Tawo kag inumon an akon dugo, wara gayod kamoʼn buhay na hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","An magkaon san akon lawas kag mag-inom san akon dugo nagakaigwa sin buhay na waraʼn katapusan kag bubuhayon ko gihapon siya sa katapusan na adlaw, ");
INSERT INTO msb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","kay an akon lawas an matuod man gayod na pagkaon kag an matuod na inumon an akon dugo. ");
INSERT INTO msb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","An magkaon san akon lawas kag mag-inom san akon dugo nakikiusad sa akon kag ako ada man sa iya. ");
INSERT INTO msb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ako na sinugo san Ama na buhay ginahatagan niyaʼn buhay, kaya sugad man an magkaon sa akon mabubuhay dahilan sa akon. ");
INSERT INTO msb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ini an pagkaon na hali sa langit. Dili pareho san pagkaon na ginkaon san aton mga kalulululuhi na nagkamaratay. An magkaon sani na pagkaon mabubuhay hasta na lang.” ");
INSERT INTO msb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ini tanan an ginpahayag niya sa sinagoga myintras nagatukdo siya sa Capernaum. ");
INSERT INTO msb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pakabati sani, damo san iya mga disipulos an nagsabi, “Nakasakit sin kabubut-on ini na panurmaton. Sin-o an makaako sani?” ");
INSERT INTO msb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aram ni Jesus na nagangurub-ngurob an mga disipulos manungod sani kaya ginhunga niya sinda, “Nano, mahabo na kamo dahilan sani? ");
INSERT INTO msb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Saka, kun makita niyo ako na Anak San Tawo nagasaka sa langit na dati ko istaran, nano an huna-huna niyo? ");
INSERT INTO msb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","An Espirito Santo amo an nagahatag sin buhay hasta na lang. Dili ini mahimo san tawo. An mga surmaton na ginsabi ko sa iyo hali sa Espirito kag makahatag san buhay hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero igwa sin pira sa iyo na dili nagatuod.” Nasabi ini ni Jesus kay pagtuna pa lang aram na niya kun sin-o idtoʼn dili nagatuod kag kun sin-o an matraydor sa iya. ");
INSERT INTO msb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tapos, nagpadayon siya, “Amo ini an dahilan kun nano kay ginsabi ko sa iyo na waraʼn makiusad sa akon kun dili tugutan san Ama.” ");
INSERT INTO msb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pakatapos sani, damo sa mga disipulos an nagbaya kag nag-udong pag-upod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kaya ginhunga ni Jesus an dose, “Kamo, nano, gusto man niyo na magharali?” ");
INSERT INTO msb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nagsabat si Simon Pedro, “Ginoo, kanin-o pa man kami mapakadto? Ada sa imo an mga surmaton manungod san buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Para sa amon nagtuod na kami kag naaraman na naman na ikaw an Banal san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nagsabat si Jesus. “Dili ba dose kamo na akon pinili pero demonyo an usad sa iyo?” ");
INSERT INTO msb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Si Judas na anak ni Simon Iscariote an iya gusto sabihon kay amo ini na tawo an matraydor sa iya bisan usad siya san dose. ");
INSERT INTO msb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pakatapos sani na mga pagtukdo, nagpanglugar-lugar si Jesus sa Galilea. Wara siya magpa-Judea kay ginahanap siya san mga namumuno san mga Judio agod patayon. ");
INSERT INTO msb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","San halapit na an Pyista san mga Judio kun diin sinda nagairistar sa payag-payag, ");
INSERT INTO msb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ginsabihan siya san iya mga kamaranghod na lalaki, “Humali ka didi kag magkadto sa Judea agod an imo mga ginahimo makita san imo mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Waraʼn nagahimo sa sikreto kun gusto na makilala. Kaya kun maghimo ka sani magpakilala ka sa katawuhan san kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ginsabi ini ninda kay bisan ngani sinda wara sin pagtuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ginsabihan sinda ni Jesus, “Dili pa ini an panahon ko pagpakilala. Dili sugad sa iyo na an tanan na panahon paripareho lang. ");
INSERT INTO msb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Waraʼn dahilan maurit sa iyo an mga tagakinab-an na nagakontra sa Dios pero nauurit sinda sa akon kay ginahayag ko an karautan na ginahimo ninda. ");
INSERT INTO msb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kaya kamo na lang mismo an mamyista. Dili ako masagka kaupod niyo kay dili pa gayod ini an akon panahon.” ");
INSERT INTO msb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pakasabi niya sani nagpabilin siya sa Galilea. ");
INSERT INTO msb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","San pagharali na san iya mga kamaranghod pakadto sa pyistahan, nagkadto man siya pero dyutay lang an nakaaram. ");
INSERT INTO msb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ginapangita siya san mga namumuno san mga Judio sa mga nagapamyista kag nagahurunga, “Hain siya?” ");
INSERT INTO msb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","An mga tawo man nagapahurutik-hutik manungod sa iya myintras nagasarabi an iba, “Matanos siya na tawo.” An iba naman nagasarabi, “Dili! Siya gayod an nagapalibog sa mga tawo.” ");
INSERT INTO msb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero sa kahadlok sa mga namumuno san mga Judio waraʼn nagasurmaton sa hayag manungod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Makatung-anan na san pyista na nagkadto si Jesus sa templo kag nagtukdo. ");
INSERT INTO msb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nagngalas an mga Judio na nagahunga, “Pan-o ini na tawo nakaaram sani tanan na wara man siya mag-adal manungod san aton Kasuguan?” ");
INSERT INTO msb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kaya ginsabat sinda ni Jesus, “Dili sa akon ini na ginatukdo ko kundi sa nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pagaaramon san gusto magtuman san kabubut-on san Dios kun an akon katukduan hali sa iya o sa sadiri ko. ");
INSERT INTO msb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An nagasurmaton hali sa sadiri niya na isip nagahandom na magapadayaw siya mismo pero matuod an nagahandom na pagadayawon an nagsugo sa iya kag dili siya mabuwa. ");
INSERT INTO msb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Dili ba ginhatagan kamo ni Moises san Kasuguan? Pero wara sa iyo sin nagatuman sani! Nano kay gusto ako niyo patayon?” ");
INSERT INTO msb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","May nagsabat sa kadamuan, “Nasasapawan ka ada sin demonyo! Sin-o an gusto magpatay sa imo?” ");
INSERT INTO msb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nagsabat si Jesus, “Naghimo lang akoʼn milagro sa Adlaw San Pagpahuway kag nagngalas kamo tanan. ");
INSERT INTO msb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kasadto nagsugo sa iyo si Moises na magpaturi (pero dili ini hali kan Moises kundi sa mga kalulululuhi), kaya nagaturi kamo abir sa Adlaw San Pagpahuway. ");
INSERT INTO msb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kun ginatugot niyo magturi sin bata sa Adlaw San Pagpahuway agod dili malapas an Kasuguan ni Moises, nano kay naurit kamo sa akon kay may ginbulong ako na bilog na lawas san tawo sa Adlaw San Pagpahuway? ");
INSERT INTO msb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ayaw kamo paghusgar susog sa nakikita lang kundi maghusgar kamo susog sa tunay na kamatuudan.” ");
INSERT INTO msb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kaya may mga taga-Jerusalem na naghurunga, “Nano, dili amo ini na tawo an ginahumutan ninda patayon? ");
INSERT INTO msb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Niyan, adi siya nagasurmaton sin hayag pero wara sindaʼn masabi kontra sa iya! Nano, pag-ako kaya ninda ini na siya man gayod an Cristo? ");
INSERT INTO msb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dili lang pwede ini kay aram naton tanan kun tagadiin ini na tawo pero pag-abot san Cristo waraʼn makaaram kun tagadiin siya.” ");
INSERT INTO msb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Niyan, pagtukdo ni Jesus sa templo nagsurmaton siya sa makusog na boses, “Kun sugad, kilala ba gali niyo ako kag aram man kun tagadiin? Pero dili ako nagpakadi sa sadiri ko na katuyuan. Igwaʼn nagsugo sa akon na dili niyo kilala kag matuod gayod siya. ");
INSERT INTO msb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero kilala ko siya kay hali ako sa iya kag siya man gayod an nagsugo sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pakabati ninda sani gusto na kuntani ninda dakupon si Jesus pero waraʼn nakahuna-huna paghalapit sa iya kay dili pa niya oras. ");
INSERT INTO msb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero damoʼn mga tawo an nagtuod sa iya kag nagsabi, “Pagkadi ni Cristo mahimo kaya siya sin mas damo na mga milagro ki sani na tawo?” ");
INSERT INTO msb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nabatian san mga Pariseo an ginahurutikan san mga tawo manungod kan Jesus, kaya nagsugo an mga mamumuno san kapadian kag mga Pariseo sin mga gwardya sa templo na magdakop sa iya. ");
INSERT INTO msb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tapos nagsabi si Jesus, “Kadali na lang san igakaupod ko sa iyo kag pakatapos mabalik na ako sa nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hahanapon niyo ako pero dili na ako niyo makikita kay dili kamo makakadto sa akon kakadtuan.” ");
INSERT INTO msb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kaya nagpahurunga-hunga anmga namumuno san mga Judio, “Hain daw ini na tawo makadto na dili naton makikita? Makadto kaya siya sa mga lugar san mga dili-Judio na nagkaarabutan san aton mga kapwa Judio kag magtukdo kaya sa mga dili-Judio? ");
INSERT INTO msb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nano an gusto sabihon san ginsabi niya na ‘Hahanapon niyo ako kag dili na niyo makikita,’ kag sani na ‘Dili kamo makakadto sa akon kakadtuan’?” ");
INSERT INTO msb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sa katapusan na adlaw san pyista, na amo an pinakaimportante na adlaw, nagtindog si Jesus kag nagsurmaton sa makusog na boses. “Kun may napapaha, pakadia sa akon kag mag-inom. ");
INSERT INTO msb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tapos mangyayari sa nagatuod sa akon pareho san nasabi sa Banal Na Kasuratan, ‘Hali sa iya tagipusuon mabulos an mga tubig na nagahatag-buhay.’” ");
INSERT INTO msb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ini ginsabi niya manungod sa Espirito na ihahatag sa mga nagtuod sa iya. Pero an Espirito dili pa ginhatag kay wara pa gindara si Jesus sa kalangitan para pagalangan. ");
INSERT INTO msb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pakabati san mga tawo sani na mga surmaton, may iba sa inda na nagsarabi, “Matuod na amo na ini siya an propeta na ginparapahulat naton.” ");
INSERT INTO msb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","An iba man nagsarabi, “Siya an Cristo!” Pero an iba man, “Dili magahali sa Galilea an Cristo! ");
INSERT INTO msb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nasurat ngani sa Banal Na Kasuratan na an Cristo usad na kaapu-apuhan ni David kag hali sa lungsod san Betlehem na amo mismo an lugar ni David.” ");
INSERT INTO msb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kaya wara nagkaurusad sa isip an mga tawo manungod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","May iba sa inda na gusto siya dakupon pero waraʼn nakahuna-huna paghalapit sa iya. ");
INSERT INTO msb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nagbalik an mga gwardya sa mga namumuno san kapadian kag mga Pariseo na naghunga, “Nano kay wara niyo siya madara?” ");
INSERT INTO msb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kaya nagsabat an mga gwardya, “Waraʼn nakapanurmaton pareho san otoridad sani na tawo.” ");
INSERT INTO msb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nagsabat man an mga Pariseo, “Nano, hasta kamo nalipat man? ");
INSERT INTO msb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nano, may nabaritaan kamona an mga namumuno o bisan usad na Pariseo nagatuod na sa iya? ");
INSERT INTO msb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero ini na katawuhan, dili sinda maaram san Kasuguan na ginhatag kasadto sa aton ni Moises. Nakondinar na gayod sinda san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Usad sa mga Pariseo, na si Nicodemo na nakigkita kasadto kan Jesus, naghunga sa inda, ");
INSERT INTO msb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nano, ginatugot gali san aton Kasuguan na husgaran an tawo na dili anay siya ginbista agod aramon kun nano an iya nahimo?” ");
INSERT INTO msb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nagsarabat sinda, “Nano, kahilungsod ka man niya na taga-Galilea? Adali an Banal Na Kasuratan kag makikita mo na waraʼn propeta na magahali sa Galilea.” ");
INSERT INTO msb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tapos nag-uruli sinda. ");
INSERT INTO msb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Myintras nagkadto si Jesus sa Bukid San Kaolibohan. ");
INSERT INTO msb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Aga pa san nagbalik gihapon si Jesus sa templo. San makita siya san tanan na katawuhan, nagtiripon sinda sa iya. Kaya nag-ingkod kag nagtuna siya pagtukdo sa inda. ");
INSERT INTO msb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Niyan, myintras nagatukdo siya, an mga paratukdo san Kasuguan kag mga Pariseo may ginguyod na babayi na nadakop pagpasambay. Pakapatindog ninda sani sa tunga ");
INSERT INTO msb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ginsabihan si Jesus, “Maestro, ini na babayi nadakpan na nagapasambay. ");
INSERT INTO msb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Niyan, susog sa ginapahimo sa aton san Kasuguan ni Moises dapat kondinaron an sugad sani na babayi paagi sa pagbato. Ikaw, nano an masasabi mo?” ");
INSERT INTO msb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Naghunga sinda sani bilang pagporbar kay nagapangita sindaʼn magamit na akusasyon kontra kan Jesus. Pero nagduko si Jesus kag nagtuna pagsurat san iya tudlo sa duta. ");
INSERT INTO msb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Myintras nagapirit sinda paghunga sa iya, nagtindog siya kag ginsabihan sinda, “An sin-o man sa iyo na wara magkasala amo an una na magbato sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tapos nagduko gihapon si Jesus kag nagpadayon pagsurat sa duta. ");
INSERT INTO msb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pakabati ninda sani, usad-usad na nagharali tuna sa pinakagurang hasta na si Jesus na lang an nabilin kaupod san babayi na nagatindog didto. ");
INSERT INTO msb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tapos nagtiso si Jesus kag naghunga sa babayi, “Hain na sinda? Nano, wara sin nagkondinar sa imo?” ");
INSERT INTO msb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Wara man, Sir,” an sabat san babayi. Nagsabi naman si Jesus, “Ako man dili makondinar sa imo. Mag-uli ka na kag ayaw na pagpakasala.” ");
INSERT INTO msb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nakisurmaton gihapon si Jesus sa mga tawo, “Ako an ilaw san kinab-an. An nagaupod sa akon dili magalakat sa kadulman san kasal-an kundi magakaigwa san ilaw na nagahatag-buhay.” ");
INSERT INTO msb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Amo man ini an ginsabat san mga Pariseo, “Ikaw lang an nagatestigo sa imo sadiri kaya wara inaʼn kamatuudan.” ");
INSERT INTO msb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nagsabat si Jesus, “Bisan ako magtestigos sa akon sadiri, matuod ini kay aram ko kun tagadiin ako kag kun mapakain ako. Pero kamo dili maaram sani. ");
INSERT INTO msb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kamo an nagahusgar basi sa kaisipan san tawo pero ako waraʼn ginahusgaran. ");
INSERT INTO msb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kun ugaling maghusgar ako matuod ina kay dili lang ako kundi kaupod ko an nagsugo sa akon, ");
INSERT INTO msb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","kag nakasurat sa iyo Kasuguan na kun magkauyon an duha na testigo matuod ini. ");
INSERT INTO msb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nagatestigo ako sa akon sadiri kag nagatestigo man an Ama na nagsugo sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tapos ginhunga naman siya ninda, “Hain an imo Ama?” Nagsabat si Jesus, “Dili ako niyo kilala ni an akon Ama. Kun kilala niyo ako, kilala man niyo an akon Ama.” ");
INSERT INTO msb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ginsurmaton niya ini sa may ginahaladan myintras siya nagatukdo sa templo. Waraʼn nagdakop sa iya kay dili pa napapanahon an pagdakop sa iya. ");
INSERT INTO msb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sinabihan gihapon sinda ni Jesus, “Magahali ako kag hahanapon niyo pero mamamatay kamo na may kasal-an. Dili kamo makakadto sa akon kakadtuan.” ");
INSERT INTO msb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nag-iristoryahan an mga namumuno san mga Judio, “Siguro magapakamatay siya kun kaya nagsabi siya na dili kita makakadto sa iya kakadtuan.” ");
INSERT INTO msb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ginsabihan niya sinda, “Kamo tagaubos pero ako tagaitaas. Kamo tagadidi sani na kinab-an pero ako dili tagadidi. ");
INSERT INTO msb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kaya ginasabi ko sa iyo na magakamaratay kamo na may mga kasal-an. Magkakamatuod gayod ini kun dili kamo magtuod na ako amo idtoʼn ginasabi ko na ako.” ");
INSERT INTO msb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ginhunga siya ninda, “Sin-o ka man?” Nagsabat si Jesus, “Kun nano an ginsabi ko sa iyo san katuna-tunai, amo ako idto. ");
INSERT INTO msb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Damo pa gayod akoʼn ikasabi kag ikahusgar sa iyo pero ginapaaram ko sa kinab-an an nabatian ko sa nagsugo sa akon kag matuod an tanan na ginasabi niya.” ");
INSERT INTO msb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dili ninda nasabutan na an iya ginasurmaton an manungod sa iya Ama. ");
INSERT INTO msb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kaya nagsabi si Jesus, “Kun ginpahitaas na niyo ako na Anak San Tawo amo pa lang niyo masasabutan na ako amo idto ginasabi ko kag wara akoʼn ginahimo na sa akon kagustuhan kundi an gintukdo sa akon san Ama amo man an akon ginasumat. ");
INSERT INTO msb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Siya na nagsugo sa akon an kaupod ko kag dili ako niya ginpabayaan kay pirme ko ginahimo an makapalipay sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Myintras nagasabi siya sani damo an nagtuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kaya sinabihan ni Jesus an mga Judio na nagatuod sa iya, “Mga disipulos ko man gayod kamo kun matinumanon sa akon mga katukduan. ");
INSERT INTO msb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Maaaraman niyo an kamatuudan manungod sa Dios kag ini na kamatuudan amo an malibre sa iyo.” ");
INSERT INTO msb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nagsabat sinda. “Kalahi kami ni Abraham kag wara pa gayod magpauripon bisan kanin-o. Niyan, sin-o ka man na magsabiʼn malilibre kami?” ");
INSERT INTO msb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nagsabat si Jesus, “Tandai niyo ini, an nagakasala nagapauripon sa iya kasal-an. ");
INSERT INTO msb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Niyan, waraʼn uripon na nagaistar hasta na lang sa panimalay san iya amo pero an anak hasta na lang nagaistar sani. ");
INSERT INTO msb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kaya kun ilibre kamo san Anak san Dios, malilibre man gayod kamo sana na pagkauripon. ");
INSERT INTO msb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aram ko na kalahi kamo ni Abraham pero bisan sugad sana gusto niyo ako patayon kay habo kamo mag-ako san akon katukduan. ");
INSERT INTO msb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","An ginasurmaton ko an nakita ko sa akon Ama. Kamo naman an nabati niyo sa iyo ama amo an ginahimo niyo.” ");
INSERT INTO msb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gin-otro gihapon ninda an inda sabat, “Kalulululuhi namon si Abraham.” Kaya ginsabihan naman sinda ni Jesus, “Kay ginasabi niyo na kalahi kamo ni Abraham, nano kay dili niyo ginahimo an ginhimo niya. ");
INSERT INTO msb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gusto niyo ako patayon na ginasabi lang sa iyo an kamatuudan na akon nabati sa Dios. Wara sana maghimo si Abraham. ");
INSERT INTO msb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ginahimo niyo an himo san iyo ama.” Nagsabat sinda, “Usad lang an amon ama na amo an Dios kag mga tunay kami niya na anak.” ");
INSERT INTO msb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nagsabat si Jesus, “Kun an Dios an iyo Ama, namumut-an man niyo ako kay naghali ako sa iya kag adi na ako pero dili sa akon sadiri na kabubut-on nagkadi ako kundi kay ginsugo niya ako. ");
INSERT INTO msb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nano kay dili niyo nasasabutan an ginasabi ko? Dahilan na habo niyo akuon an akon mensahe. ");
INSERT INTO msb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","An demonyo an iyo ama kag gusto niyo himuon an naiilaan niya. Parapatay-tawo siya tuna pa sa katuna-tunai kag wara siyaʼn labot sa kamatuudan kay an kamatuudan wara sa iya kundi siya an ginhalinan san mga buwa kag an pagbuwa amo an ugali na niya kay buwaon siya. ");
INSERT INTO msb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ugaling ako an nagasurmaton san kamatuudan kaya dili kamo nagatuod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sin-o sa iyo an makapamatuod na ako may kasal-an? Kun matuod an ginasurmaton ko, nano kay dili kamo nagatuod sa akon? ");
INSERT INTO msb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mga anak san Dios an nagatuman san mga surmaton niya. Dili kamo nagatuman sani kay dili kamo mga anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nagsabat naman an mga Judio, “Sigurado na tama gayod kami sa pagsabi na ikaw Samaritano kag may demonyo.” ");
INSERT INTO msb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nagsabat si Jesus, “Wara akoʼn demonyo kundi ginagalangan ko an akon Ama pero ginapakaraot niyo ako. ");
INSERT INTO msb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dili ako nagapaumaw san akon sadiri. Igwaʼn nagapamahala sana kag siya an magahusgar. ");
INSERT INTO msb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tandai niyo ini: dili mapapatay an nagatuman san akon katukduan.” ");
INSERT INTO msb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nagsabi an mga Judio, “Niyan naaraman namon na may demonyo ka man gayod. Namatay si Abraham kag amo man an mga propeta pero nagasabi ka na an nagatuman san imo katukduan dili mapapatay hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nano, labaw ka pa ki sa amon kalulululuhi na si Abraham na patay na? Nagkamaratay man ngani an mga propeta. Kay sin-o ka man?” ");
INSERT INTO msb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nagsabat naman si Jesus, “Kun nagapaumaw ako san sadiri ko, waraʼn pulos ina na pag-umaw. An nagaumaw sa akon an akon Ama na ginaangkon niyo na siya an iyo Dios. ");
INSERT INTO msb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bisan ngani dili niyo siya nakilala pero ako kilala ko siya. Kun sabihon ko lugod na dili ko siya kilala, magigin buwaon ako pareho man niyo. Pero kilala ko man gayod siya kag matuod na ginatuman ko an iya katukduan. ");
INSERT INTO msb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nagkalipay an iyo kalulululuhi na si Abraham sa paghuna na makita an pag-abot ko sa kinab-an. Nakita man niya kaya nalipay gayod siya.” ");
INSERT INTO msb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Didi naghunga an mga Judio sa iya, “Wara ka pa nganiʼn 50 anyos kag nagasabi kaʼn nakita mo na si Abraham?” ");
INSERT INTO msb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nagsabat gihapon si Jesus, “Matuod gayod na ako dati na antes pa kan Abraham.” ");
INSERT INTO msb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kaya nagpurot sindaʼn mga bato agod batuhon siya pero nakatago siya kag nagluwas sa templo. ");
INSERT INTO msb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Myintras nagalakat si Jesus, may nakita siyaʼn tawo na gin-anak na buta. ");
INSERT INTO msb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ginhunga siya san iya mga disipulos, “Maestro, sin-o an may sala kaya nabuhay siya na buta? Ini daw na tawo o an iya mga ginikanan?” ");
INSERT INTO msb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nagsabat si Jesus, “Pareho sinda waraʼn sala. Nabuhay siya na buta agod ikahayag paagi sa iya an gahom san Dios. ");
INSERT INTO msb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Niyan, myintras bagaʼn adlaw pa, dapat pagparahimuon ta an mga ginasugo sa aton san Dios na nagsugo sa akon. Maabot an gab-i na wara naʼn makatrabaho. ");
INSERT INTO msb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Myintras adi ako sa kinab-an ako an ilaw para sa mga tagakinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pakasabi sani, nagluda siya sa duta kag naghimo sin lapok paagi sa luda. Tapos linahid niya sa mata san buta na lalaki ");
INSERT INTO msb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","kag sinabihan, “Kadto kag paghiram-os sa tangke san Siloe.” (An gusto sabihon sani, Sinugo.) Kaya naglakat an buta kag nanghiram-os. Tapos nag-uli na nakakita na siya. ");
INSERT INTO msb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nagpahurunga-hunga an iya mga katarakin kag san mga tawo na kasadto nakakita sa iya na nakilimos, “Nano, dili amo ini idtoʼn tawo na dati anay nagaingkod kag parapakilimos?” ");
INSERT INTO msb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","May mga nagsabat, “Oo, amo ina siya.” May mga iba naman na nagsabi, “Dili, nakamayo lang siya.” Pero an lalaki mismo nagsabi, “Ako amo idto.” ");
INSERT INTO msb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tapos ginhunga siya ninda, “Sa pan-o na paagi kay nakakita ka na?” ");
INSERT INTO msb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nagsabat an dati buta, “An tawo na ginatawag na Jesus naghimo sin lapok, linahidan an akon mga mata kag nagsabi, ‘Kadto kag manghiram-os ka sa Siloe.’ Kaya nagkadto ako kag pakahiram-os nakakita na!” ");
INSERT INTO msb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Naghunga sinda, “Hain naman siya?” “Ambot,” an sabat niya. ");
INSERT INTO msb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ginpaupod san mga tawo an dati buta na lalaki sa mga Pariseo. ");
INSERT INTO msb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Niyan, Adlaw sadto San Pagpahuway san naghimo si Jesus sin lapok kag ginpamuklat an mga mata san lalaki. ");
INSERT INTO msb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kaya naghunga man sa iya an mga Pariseo kun pan-o kay nakakita na siya. Ginsabihan naman niya sinda, “Linahidan niya sin lapok an akon mga mata kag ginpahiram-os. Pakatapos, nakakita na ako.” ");
INSERT INTO msb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Didi may pira na mga Pariseo na nagsabi, “Dili hali sa Dios ina na tawo kay wara niya paggalangi an Adlaw San Pagpahuway.” Pero may mga iba man na nagsabi, “Pan-o makahimo san mga milagro sugad sani an parakasala?” Kaya wara sinda magkapararehoʼn isip. ");
INSERT INTO msb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tapos naghunga gihapon sinda sa dati buta, “Ikaw naman, nano an masasabi mo manungod sa iya kay an imo mga mata napamuklat niya?” “Propeta siya,” an sabat san lalaki. ");
INSERT INTO msb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero wara magtuod an mga namumuno san mga Judio na an tawo dati buta kag nakakita na hasta na dili anay ginpatawag an mga ginikanan ");
INSERT INTO msb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kag ginhunga sinda, “Matuod man gayod na ini na lalaki an anak niyo? Nano, ginasabi niyo na gin-anak siya buta na? Kun amo, nano kay nakakita na siya?” ");
INSERT INTO msb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nagsabat an mga ginikanan, “Aram namon na siya an amon anak kag gin-anak na buta ");
INSERT INTO msb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","pero dili namon aram kun nano kay nakakita na siya o kun sin-o an nagpamuklat san iya mga mata. Hungaa niyo siya. May tama naman siya na kaisipan. Siya na mismo an makapahayag.” ");
INSERT INTO msb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nagsurmaton sani an iya mga ginikanan kay hadlok sinda sa mga namumuno san mga Judio na nagkaigwaʼn pagkasarabutan na an mag-ako kan Jesus na amo an Cristo pagapahalion sa sinagoga. ");
INSERT INTO msb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kaya amo ini an dahilan kun nano kay ginsabi san iya mga ginikanan, “Hungaa niyo siya kay may isip na siya.” ");
INSERT INTO msb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sa ikaduha na beses tinawag gihapon ninda an dati na buta kag ginsabihan siya, “Sa atubangan san Dios sabihi kami san kamatuudan, kay kami, aram namon na parakasala ina na tawo.” ");
INSERT INTO msb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nagsabat siya, “Dili ko aram kun parakasala siya. An aram ko lang na kasadto buta ako pero yana nakakita na.” ");
INSERT INTO msb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ginhunga gihapon siya ninda, “Nano an ginhimo niya sa imo? Pan-o niya napamuklat an imo mga mata?” ");
INSERT INTO msb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nagsabat siya, “Ginsabi ko na sa iyo pero habo man kamo mamati. Nano kay gusto niyo na bation gihapon? Nano, gusto man niyo na magin disipulos niya?” ");
INSERT INTO msb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pakabati sani gintuya-tuya siya ninda, “Ikaw an disipulos niya pero kami disipulos ni Moises. ");
INSERT INTO msb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Aram namon na nagsurmaton kan Moises an Dios pero ina na tawo dili namon aram kun tagadiin.” ");
INSERT INTO msb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nagsabat an dati buta, “Makangangawa ini! Ginpamuklat niya an akon mga mata kag dili niyo aram kun tagadiin siya! ");
INSERT INTO msb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aram namon na an Dios dili ginapamatian an mga parakasala kundi idtoʼn mga nagasamba sa Dios kag nagatuman san iya kabubut-on. ");
INSERT INTO msb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tuna san paglalang san kinab-an wara pa gayod sin nabaritaan na may nakapamuklat san mga mata san tawo na gin-anak buta na. ");
INSERT INTO msb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kun ina na tawo dili hali sa Dios, wara siyaʼn mahimo.” ");
INSERT INTO msb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nagsabat sinda, “Gin-anak ka kag nagdako na parakasala, tapos niyan ikaw pa an matukdo sa amon?” Kaya pinatuklang siya paluwas. ");
INSERT INTO msb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Niyan, san nabaritaan ni Jesus na ginpaluwas an dati buta, nahanapan niya ini kag ginhunga, “Nano, nagatuod ka sa Anak San Tawo?” ");
INSERT INTO msb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nagsabat an lalaki, “Sir, sin-o siya? Sabihi ako agod tuudan ko siya.” ");
INSERT INTO msb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ginsabihan siya ni Jesus, “Nakita mo na siya kag siya ini na nakiistorya sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","An sabat niya, “Ginoo, nagatuod ako sa imo,” tapos nagsamba siya kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nagsabi si Jesus, “Nagpakadi ako sa kinab-an agod husgaran an mga tawo para an mga buta na magtuod sa akon makakita, kag idto naman na nakakita pero habo magtuod magigin bagaʼn mabuta lugod.” ");
INSERT INTO msb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","May mga Pariseo na adto didto kaupod niya na pakabati sani naghunga, “Nano, bagaʼn mga buta man kami?” ");
INSERT INTO msb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ginsabat sinda ni Jesus, “Kun mga buta kamo wara kamoʼn kasal-an pero kay nagasabi kamo na nakakita, may kasal-an pa kamo.” ");
INSERT INTO msb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nagpadayon pa si Jesus, “Matuod gayod na makawat kag tulisan an dili nagaagi sa pwertahan san turil san mga karnero kundi sa iba na paagi. ");
INSERT INTO msb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero an nagaagi sa pwertahan amo an pastor san mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ginapasulod siya san bantay sa pwertahan kag nagakilala san iya boses an mga karnero. Ginatawag niya ini na sadiri niya na karnero paagi sa ngaran kag ginagiyahan paluwas. ");
INSERT INTO msb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pakapaluwas na niya san tanan, nagauna siya sani kag nagasurunod an mga karnero sa iya kay kilala sani an iya boses. ");
INSERT INTO msb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero sa dayuhan wara sinda magasunod kundi mas nagadurulag pahilayo sa iya kay dili sani kilala an iya boses.” ");
INSERT INTO msb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gin-istorya ni Jesus ini sa inda pero wara ninda masabutan kun nano an iya gusto sabihon. ");
INSERT INTO msb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kaya nagsurmaton gihapon si Jesus sa inda, “Matuod gayod na ako an pwertahan para sa mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mga makawat kag tulisan an tanan na parabantay na nauna sa akon pagkadi pero an mga karnero wara mag-intyindi sa inda. ");
INSERT INTO msb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ako an pwertahan. Masasalbar an mga mag-agi sa akon, tapos sinda bagaʼn karnero na makaguwa-sulod kag makakitaʼn mahuraban. ");
INSERT INTO msb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","An makawat naman, an katuyuan niya mangawat, magpatay kag magsira. Pero ako an nagpakadi agod magkaigwa sindaʼn buhay kag magpabugana pa lugod sin buhay. ");
INSERT INTO msb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako man an maayo na pastor. An pastor na maayo amo an nagahalad san iya buhay para sa mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","An sinuhulan naman, na dili amo an matuod na pastor na tagsadiri san mga karnero, ginapabayaan an mga karnero kag nadalagan sa oras na makita niya na nagaarapiki na an maisog na hayop. Kaya ginatabag kag ginaburulag man sani an mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nadulag siya kay sinuhulan lang kag waraʼn pagmalasakit sa mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Pero ako naman an pastor na maayo. Pareho san pakakilala sa akon san Ama kag an pakakilala ko man sa iya, kilala ko an akon mga karnero kag kilala man ako sani. Kaya ginahalad ko an akon buhay para sani. ");
INSERT INTO msb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Niyan, igwa pa man akoʼn iba na mga karnero na dili pa parte sani na manada. Sinda man dapat ko na tipunon kag babation ninda an akon boses. Tapos usad na lang an manada kag usad an pastor. ");
INSERT INTO msb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Namumut-an ako san Ama kay ginahalad ko an akon buhay agod mabuhay gihapon ako. ");
INSERT INTO msb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waraʼn makahali san buhay ko. Ginahalad ko ina sa sadiri ko na kabubut-on. Igwa akoʼn gahom na ihalad ko ina kag kagamhanan na bawion gihapon kay ini an ginsugo sa akon san akon Ama.” ");
INSERT INTO msb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tungod sani na mga surmaton wara man gihapon magkaparareho an isip san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kadamuan sa inda nagsarabi, “Nasudlan siyaʼn demonyo kaya nagabuang. Nano kay nagaparapamarati pa kamo sa iya?” ");
INSERT INTO msb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","An iba naman nagasabi, “Dili amo ini an panurmaton san tawo na nasudlan san demonyo. Nano, may demonyo kaya na makapakita sin buta?” ");
INSERT INTO msb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nag-abot an panahon san ginaselebrar san mga Judio an pyista san pagdidikar sa templo kasadto sa Jerusalem. Tighagkutan sadto ");
INSERT INTO msb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","kag si Jesus nasa templo nagaagi sa lugar na ginatawag na portico ni Solomon. ");
INSERT INTO msb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Gintiripunan siya san mga Judio kag nagsabi, “Nano kay ginaparapahulat mo pa kami? Kun ikaw man gayod an Cristo, sabihi na ngani kami.” ");
INSERT INTO msb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nagsabat si Jesus, “Ginsabihan ta na kamo pero dili man kamo nagatuod sa akon. An mga milagro na ginahimo ko sa ngaran san akon Ama amo an nagapamatuod manungod sa akon ");
INSERT INTO msb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","pero dili kamo nagatuod kay dili ta kamo mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","An akon mga karnero nagapamati san akon boses, kilala ko sinda kag nagasunod sinda sa akon. ");
INSERT INTO msb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ginahatagan ko sinda sin buhay na waraʼn katapusan. Dili sinda mawawar-an sani kag wara man sin makaagaw sa inda sa akon. ");
INSERT INTO msb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","An akon Ama na nagpaniwala sa inda sa akon amo an pinakalabaw sa tanan kag waraʼn makaagaw sa inda sa iya. ");
INSERT INTO msb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako kag san Ama usad lang.” ");
INSERT INTO msb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tapos an mga Judio nagpururot naman gihapon sin mga bato agod batuhon siya. ");
INSERT INTO msb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kaya sinabihan sinda ni Jesus, “Damoʼn mga maayo na hinimuan an ginpakita ko sa iyo na ginsugo san Ama na himuon ko. Hain sani na mga milagro na pagabatuhon niyo ako?” ");
INSERT INTO msb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ginsabat siya san mga Judio, “Dili ka namon batuhon dahilan san mga maayo mo na hinimuan kundi an imo pagpakaraot sa Dios sa pag-angkon na ikaw Dios pero tawo ka lang.” ");
INSERT INTO msb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ginsabat sinda ni Jesus, “Nano, dili nasurat sa iyo mismo Kasuratan na an Dios nagsabi sa mga namumuno kasadto na mga dios sinda? ");
INSERT INTO msb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Niyan, kun mga dios man gayod an pagtawag san Dios sadtoʼn mga gintiwalaan san surmaton niya kag an Kasuratan matuod hasta na lang, ");
INSERT INTO msb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nano, pagtuya-tuya ina sa iyo kun ako, na ginpili san Ama kag ginsugo sa kinab-an, nagsabi na, ‘Ako an anak niya?’ ");
INSERT INTO msb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ayaw kamo pagtuod sa akon kun dili ko ginahimo an mga ginapahimo san akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero kun ginahimo ko magtuod kamo sani na mga pagpamatuod bisan pa ngani dili kamo nagatuod sa akon. Tapos, maaraman niyo kag masiguro na an Ama nakig-usad sa akon kag ako sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ginporbaran gihapon ninda na dakupon si Jesus pero nakadulag sa inda. ");
INSERT INTO msb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nagbalik siya gihapon pagtabok sa Jordan sa lugar na kun diin sadto nagapambunyag anay si Juan. Didto nag-istar si Jesus ");
INSERT INTO msb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","kag damo an nagkaradto didto sa iya tapos nagsabi, “Wara maghimoʼn milagro si Juan pero matuod an tanan na ginsabi niya manungod sani na tawo.” ");
INSERT INTO msb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kaya, damo sadtoʼn mga tawo an nagtuod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Niyan may masakit na an ngaran Lazaro na nagaistar sa baryo san Betania kaupod an iya duha na kamanghod na babayi na sinda Maria kag Marta. ");
INSERT INTO msb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ini si Maria amo idtoʼn pira-pira pa na panahon nagbu-bo sin pahumot sa tiil san Ginoo kag ginpahidan san iya buhok. ");
INSERT INTO msb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kaya nagpasugo kan Jesus an magmanghod na babayi na may pasabi, “Ginoo, grabe an sakit san imo palangga na amigo.” ");
INSERT INTO msb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pero pakabati sani ni Jesus nagsabi, “Ini na iya sakit dili pa sa kamatayon kundi para sa pag-umaw san Dios agod an anak niya pagaumawon paagi sani.” ");
INSERT INTO msb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Palangga ni Jesus sinda Marta, an iya kamanghod na babayi kag Lazaro. ");
INSERT INTO msb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero apisar sani, pakabarita ni Jesus na masakit si Lazaro, nagpabilin pa gayod siyaʼn duha ka adlaw sani na lugar. ");
INSERT INTO msb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pakatapos sani, ginsabihan niya an iya mga disipulos, “Hamos, mabalik kita sa Judea.” ");
INSERT INTO msb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nagsabat an mga disipulos, “Maestro, dili pa lang dugay na gusto ka batuhon didto san mga Judio. Nano, makadto ka pa gihapon?” ");
INSERT INTO msb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nagsabat si Jesus, “Nano, dili dose oras an maghapon? An nagalakat kun adlaw dili napapangkog kay nakakita siya paagi san kapaw-an sani na kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero an nagalakat sa kagab-ihon napapangkog kay waraʼn ilaw sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pakasabi sani ni Jesus nagpadayon pa siya, “Nagakaturog an aton amigo na si Lazaro pero kakadtuon ko agod pukawon siya.” ");
INSERT INTO msb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ginsabihan siya san mga disipulos, “Ginoo, kun nagakaturog lang sigurado na magaayo siya.” ");
INSERT INTO msb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Niyan, an ginsabi ni Jesus amo an manungod sa kamatayon ni Lazaro pero sa paghuna ninda sani na pagkaturog an gusto niya sabihon na turog gayod. ");
INSERT INTO msb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kaya hayag nagsabi si Jesus, “Patay na si Lazaro, ");
INSERT INTO msb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","pero alang-alang sa iyo, ginakalipay ko na wara ako didto agod magtuod kamo sa akon. Hamos, makadto kita sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas na ginatawag na kapid nagsabi sa kaurupod niya na mga disipulos, “Hamos man kita agod mamatay kaupod san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pag-abot ninda Jesus, naaraman niya na upat na ka adlaw an pakalubong kan Lazaro. ");
INSERT INTO msb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kay halapit lang an Betania sa Jerusalem, mga tulo ka kilometro an kaharayo, ");
INSERT INTO msb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","damoʼn mga Judio na tagadidto an nagkaradto kanda Marta kag Maria agod makigdamay sa pagkamatay san inda kamanghod na lalaki. ");
INSERT INTO msb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pakabati ni Marta na nagadangadang si Jesus, nagluwas kag nagsugat sa iya myintras si Maria nagpabilin sa inda balay. ");
INSERT INTO msb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ginsabihan ni Marta si Jesus, “Ginoo, kun adi ka lang wara mamatay an akon kamanghod. ");
INSERT INTO msb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero bisan nangyari ini aram ko na an nano man na pagahangyuon mo sa Dios makapahimo siya sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ginsabat man siya ni Jesus, “Mabubuhay gihapon an imo kamanghod.” ");
INSERT INTO msb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nagsabat si Marta, “Aram ko po na mabubuhay gihapon siya sa adlaw san pagkabuhay gihapon san mga patay.” ");
INSERT INTO msb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Didi nagpahayag si Jesus, “Ako an nagabuhay gihapon san katawuhan kag an nagapabuhay sa inda kaupod san Dios hasta na lang. An nagatuod sa akon mabubuhay bisan namatay siya. ");
INSERT INTO msb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kaya an nagatuod kag nabubuhay sa pakig-usad sa akon dili mapapatay hasta na lang. Nagatuod ka ba sani?” ");
INSERT INTO msb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nagsabat si Marta, “Opo, Ginoo, nagatuod ako na ikaw an Cristo. Ikaw an anak san Dios na ginsabi kasadto na mapakadi kuno sani na kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pakasabi sani ni Marta, nag-uli siya kag may ginsikreto kan Maria, “Nag-abot na an Maestro kag gusto makigkita sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pakabati sani tumindog dayon si Maria kag nagkadto kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Niyan dili pa si Jesus nakaabot sa baryo. Adto pa siya sa lugar na ginsugatan sa iya ni Marta. ");
INSERT INTO msb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Myintras an mga Judio naman na adto didto sa balay na nakigdamay kan Maria nakita na nagdali-dali siya pagtindog kag pagluwas, nagsurunod sinda sa paghuna na mapakadto siya sa ginlubngan agod magnguyngoy didto. ");
INSERT INTO msb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagkasugati ni Maria kan Jesus nagluhod sa may tiilan niya na nagasabi, “Ginoo, kun adi ka lang wara napatay an akon kamanghod.” ");
INSERT INTO msb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pakakita ni Jesus na nagatangis sinda Maria kag san mga Judio na nakigdamay sa iya, nakabatyag siya sin grabe na kaurit kag natandog an iya puso. ");
INSERT INTO msb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tapos naghunga siya, “Diin niyo siya ginlubong?” Ginsabat siya ninda, “Ginoo, kadi kag kitaa.” ");
INSERT INTO msb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Didi, nagtangis si Jesus. ");
INSERT INTO msb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kaya nagsabi an mga Judio, “Kitaa, sobra gayod an pagpalangga niya kan Lazaro!” ");
INSERT INTO msb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero may nagsabi man na iba, “Napakita niya an buta, dili kaya niya mapugulan an pagkamatay sani na tawo kun adi siya?” ");
INSERT INTO msb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Natandog gayod sin grabe an puso ni Jesus na naghalapit siya sa ginlubngan. Kweba ini na gintahuban sin bato. ");
INSERT INTO msb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","San adto na sinda nagsugo si Jesus, “Halia an bato.” Pero nagreklamo si Marta na kamanghod san patay, “Ginoo, may baho na siya yana kay upat na ka adlaw an iya pakamatay.” ");
INSERT INTO msb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ginsabat siya ni Jesus, “Ginsabihan ta na baga ikaw na kun magtuod ka sa akon, makikita mo an gloryoso na gahom san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kaya ginhali san mga tawo an bato. Pakatapos, naghangad si Jesus kag nagsabi, “Ama, nagapasalamat ako sa imo kay ginapamatian mo an akon pangadyi. ");
INSERT INTO msb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aram ko na pirme mo ako ginapamatian pero ginasabi ko ini agod magtuod an mga tawo na adi sa patalibod na sinugo mo ako.” ");
INSERT INTO msb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pakasabi niya sani, nagsiyak siya, “Lazaro, magluwas ka dida.” ");
INSERT INTO msb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tapos nagluwas man an dati patay na naburubudan sin tela an iya mga kamot kag tiil kag an iya pamayhon natahuban sin otro tela. Ginsugo sinda ni Jesus, “Hubadi niyo siya agod libre na.” ");
INSERT INTO msb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Damo na mga Judio na kaurupod ni Maria an nakakita san ginhimo ni Jesus kaya nagtuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero may iba sa inda na nagpakadto sa mga Pariseo agod isumat an ginhimo ni Jesus. ");
INSERT INTO msb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kaya gintiripon san mga namumuno na kapadian kag san mga Pariseo an inda konseho, tapos ginhunga, “Nano an himuon ta kay ini na tawo nagapanghimoʼn damo na mga milagro? ");
INSERT INTO msb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kun tugutan ta lang siya magpadayon sa iya ginahimo, magatuod sa iya an tanan kag basi magaako sa iya bilang hadi, tapos mapakadi an mga taga-Roma na otoridad kag sisiraon ninda an aton templo kag an aton nasyon.” ");
INSERT INTO msb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tapos usad sa inda na an ngaran si Caifas na amo an pinakapuno na padi sadto na tuig nagsabi, “Bagaʼn dili gayod niyo nasasabutan an aton kamutangan. ");
INSERT INTO msb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dili niyo nasasabutan na mas maayo pa sa iyo na may mapatay na usad na tawo para sa kadamuan na tawo ki sa mapara an bilog na nasyon.” ");
INSERT INTO msb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Dili siya sani nagsurmaton sa iya sadiri na kabubut-on kundi bilang pinakapuno na padi sana na tuig siya an ginpasabi san Dios na mamamatay si Jesus alang-alang sa mga taga-Israel. ");
INSERT INTO msb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Dili lang ini kundi agod pag-urusadon man sa inda an iba man na mga tawo na magigin katawuhan san Dios sa iba na mga lugar sa kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaya sadto na adlaw nagtuna sinda pagplano na patayon si Jesus. ");
INSERT INTO msb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pakaarami sani ni Jesus, dili na siya nagapakita sin hayag sa mga Judio kundi naghali siya didto kag nagpakadto sa lungsod na ginatawag na Efrem na halapit sa disyerto. Didto siya nag-istar kaupod san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Niyan, halapit na an pyista san Paskwa san mga Judio kaya damo na mga tawo na hali sa kaumahan an nagpa-Jerusalem antes sani agod malinisan an inda sadiri sa kasal-an susog sa ginsugo sa Kasuguan. ");
INSERT INTO msb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pag-abot ninda didto ginhanap si Jesus kag nagairistoryahan myintras nagairistambay sa templo, “Nano sa paghuna niyo, dili ada siya mamimyista?” ");
INSERT INTO msb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Niyan, nagsugo kasadto an mga namumuno san kapadian kag san mga Pariseo na kun may maaram san lugar ni Jesus, dapat paaramon sinda agod inda ikapadakop. ");
INSERT INTO msb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Unom pa ka adlaw antes san Paskwa, nagpa-Betania si Jesus didto sa ginaistaran ni Lazaro na kasadto ginbuhay niya gihapon hali sa pagkamatay. ");
INSERT INTO msb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Didto ginpaponsyahan si Jesus. Si Marta an nagsirbe kag si Lazaro naman usad san mga kaatubang niya sa may lamesa. ");
INSERT INTO msb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Niyan, si Maria may daraʼn tunga sa litro san mahalon na olor na puro nardo. Ini ginbu-bo niya sa mga tiil ni Jesus, tapos ginpahidan san iya buhok. Napuno an balay san humot san olor. ");
INSERT INTO msb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pero nagsabi si Judas Iscariote, usad san mga disipulos ni Jesus (na amo an matraydor sa iya), ");
INSERT INTO msb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nano kay dili ginbaligya ina na olor sin 300 na dinaryo kag an kabaklanan ipanghatag sa mga pobre?” ");
INSERT INTO msb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Dili niya ini ginsabi kay may pagmalasakit sa pobre kundi kay siya makawat. Siya an nagadara san surudlan san inda kwarta kag anad na siya na kuhaan ini. ");
INSERT INTO msb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Didi nagsabi si Jesus, “Pabayai ini na babayi kay gintigana niya ina na pahumot para sa akon lubong. ");
INSERT INTO msb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pirme kaupud-upod niyo an mga pobre pero ako dili pirme adi sa iyo.” ");
INSERT INTO msb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pakaarami san damo na mga Judio na adto sa Betania si Jesus, nagkaradto sinda agod makita siya kag lalo na si Lazaro na iya ginbuhay gihapon hali sa pagkamatay. ");
INSERT INTO msb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaya ginplanuhan san mga namumuno san kapadian na patayon man si Lazaro, ");
INSERT INTO msb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kay paagi sa iya damo na mga Judio an nagbaraya sa inda kag nagaturuod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pagkaotro adlaw an kadamuan san mga namyista nakabati na nagadangadang na si Jesus sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kaya nagbaranggi sinda sin mga sanga na bagaʼn palmera agod ibutang sa agihan niya susog san inda kaugalian tapos nagruluwas agod sugaton siya na nagasiriyak, “Hosanna! Ginpalabi ini siya na nagapakadi sa ngaran san Ginoo! Umawon siya kay siya an hadi naton na mga Judio!” ");
INSERT INTO msb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Niyan may naagihan si Jesus na pareho san tinday na kabayo na ginatawag tinday san asno kag ginsakyan niya pareho san nakasurat sa kasuratan, ");
INSERT INTO msb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mga katawuhan san Sion, ayaw kahadlok. Kitaa, nagaabot na an imo hadi na nakasakay sa tinday na asno.” ");
INSERT INTO msb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sadto mismo wara anay nasabutan san iya mga disipulos ini na nangyari pero pakasakat ni Jesus sa iya trono sa langit, amo pa lang ninda nadumduman ini na sinurat manungod sa iya kag ginhimo ninda ini sa iya. ");
INSERT INTO msb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Niyan, san tawagon ni Jesus si Lazaro na magluwas sa rulubngan kag ginbuhay gihapon siya hali sa pagkamatay, an katawuhan na kaupod didto ni Jesus nag-istorya pagpira-pira sa mga iba pa kun nano an nangyari kan Lazaro. ");
INSERT INTO msb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kaya an mga namyista nagruluwas pagsugat kan Jesus kay nabaritaan ninda na siya an naghimo sadtoʼn milagro. ");
INSERT INTO msb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Didi sani idtoʼn mga Pariseo naman nagpabarasul-basol, “Nakita na niyo. Wara na kita sin mahimo pa. An tanan na tawo sa kinab-an nagaurupod na sa iya!” ");
INSERT INTO msb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Niyan, may mga Griego kaupod sadtoʼn nagpa-Jerusalem sa pagsamba dahilan sa pyista. ");
INSERT INTO msb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nag-arapiki ini sinda kan Felipe na taga-Betsaida sa Galilea kag ginsabihan siya, “Sir, gusto namon makigkita kan Jesus.” ");
INSERT INTO msb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nagkadto si Felipe kan Andres kag ginsabihan ini, tapos, nag-upod naman sinda para sabihan si Jesus. ");
INSERT INTO msb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ginsabat sinda ni Jesus, “Nag-abot na an oras na maumaw an Anak San Tawo. ");
INSERT INTO msb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Matuod gayod na kun dili ikasabwag an binhi na trigo kag mamatay, pirme lang ini sulo. Ugaling kun mamatay ini, tapos magtubo, magapamungaʼn damo. ");
INSERT INTO msb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","An namumuot sa sadiri niya na buhay mawawar-an sani. An dili nagapahalaga sa iya buhay didi sa kinab-an kundi ginapahalagahan lugod niya an kagustuhan san Dios makatigana ina na buhay para sa buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","An tanan na nagapasakop san sadiri sa akon dapat magsunod sa akon. Kun hain ako, adto man an akon suruguon. An magpasakop sa akon pagagalangan man san akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nahahandal gayod ako. Nano, maayo kun masasabi ko, ‘Ama ko, ilikay man ako sa maabot na oras san pagtios’? Dili gayod kay amo ini an katuyuan san akon pagkadi na amo an magtios. ");
INSERT INTO msb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kaya, Ama, ipagalang an imo ngaran.” Tapos, may boses hali sa langit, “Ginpagalangan ko na ina kag pagagalangan ko gihapon.” ");
INSERT INTO msb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","May mga tawo na adto didto na nakabati sani kag nagsarabi na nagdalugdog. May iba naman na nagsarabi na igwaʼn anghel na nakisurmaton sa iya. ");
INSERT INTO msb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nagsabat si Jesus, “Dili para sa akon ina na boses kundi alang-alang sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Niyan, amo na ini an panahon san pagahusgar san Dios sani na kinab-an. Adi na an panahon na dadaugon an prinsipe sani na si Satanas. ");
INSERT INTO msb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tapos, pagpahitaas sa akon hali sa duta, papawilihon ko an tanan na mga tawo sa akon sadiri paagi sana.” ");
INSERT INTO msb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ginsabi niya ini agod ipasabot kun pan-o siya mamamatay. ");
INSERT INTO msb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ginsabat siya san mga tawo, “Naaraman namon sa Kasuguan na an Cristo magapadayon hasta na lang. Nano kay ginasabi mo na an Anak San Tawo dapat na ihitaas? Sin-o ini na Anak San Tawo?” ");
INSERT INTO msb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kaya ginsabihan sinda ni Jesus, “Madali na lang na panahon na an ilaw magapabilin pa sa iyo. Magpadayon pa kamo myintras adi pa an ilaw agod dili kamo maabtan san dulom na amo an kasal-an kay an nagalakat sa kadulman dili aram kun mapakain siya. ");
INSERT INTO msb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Myintras igwa pa kamoʼn ilaw, magtuod sani agod magin mga tawo kamo na ada pirme an ilaw.” Pakasabi ni Jesus sani, binayaan niya sinda kag nagtago sa inda. ");
INSERT INTO msb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan naghimo si Jesus sin damo na mga milagro sa atubangan san mga Judio, wara gihapon sinda magtuod sa iya. ");
INSERT INTO msb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nangyari ini agod matuman an ginsabi san propeta na si Isaias, “Ginoo, waraʼn nagatuod san amon ginsumat kag wara man sin nagaako san gahom na ginhayag mo.” ");
INSERT INTO msb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Dili sinda nakatuod kay susog sa ginsabi man ni Isaias, ");
INSERT INTO msb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ginbuta niya sinda sa isip kag ginpasutil agod an inda mga mata dili makakita san kamatuudan, dili makasabot kag dili magbalik sa akon agod paayuhon ko, sabi san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ginsabi ini ni Isaias kay may pangitaon siya san glorya ni Jesus kag nagsurmaton manungod mismo sa iya. ");
INSERT INTO msb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Apisar sani, damo an nagtuod sa iya bisan sa mga namumuno, ugaling dahilan sa kahadlok sa mga Pariseo dili sinda nagahayag kay basi palayason sinda sa sinagoga. ");
INSERT INTO msb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","An dahilan sani kay naiilaan pa ninda an pagdayaw san mga tawo ki sa pagdayaw san Dios. ");
INSERT INTO msb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tapos, sa makusog na boses nagsurmaton si Jesus sa kadamuan, “An magtuod sa akon dili lang nagatuod sa akon kundi hasta man sa nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","An nakakita sa akon nakakita naman sa iya na nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nagpakadi ako sa kinab-an bilang ilaw agod an nagatuod sa akon dili na gayod magpadayon sa kadulman. ");
INSERT INTO msb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dili ako nagahusgar san nagapamati san akon mga surmaton pero dili nagatuman sani kay dili ako nagpakadi agod husgaran an katawuhan sa kinab-an kundi isalbar sinda. ");
INSERT INTO msb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","May nagahusgar naman san nagasikway sa akon kag dili nagaako san akon ginasabi kag ini mismo na ginsikway niya amo an makapahusgar sa iya sa katapusan na adlaw na amo an adlaw san paghusgar. ");
INSERT INTO msb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Niyan, dili ako nagsurmaton hali sa akon sadiri na kabubut-on kundi hali sa akon Ama na nagsugo sa akon. Siya an nagsugo kun nano an akon pagasabihon kag kun pan-o an pagapahayag. ");
INSERT INTO msb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aram ko man na an nagasunod sa iya Kasuguan magakaigwa sin buhay na waraʼn katapusan. Kaya, an akon ginasurmaton amo lang an ginasugo sa akon san Ama.” ");
INSERT INTO msb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","San bisperas san kapyistahan san Paskwa, aram na ni Jesus na nag-abot na an oras na mabaya na siya sani na kinab-an kag mauli sa Ama. Pirme namut-an ni Jesus an mga nagin sadiri niya na tawo didi sa kinab-an kag niyan ipapakita niya sa inda an pinakabiyo na pagkamuot niya sa inda. ");
INSERT INTO msb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Myintras nagapanigab-i sinda Jesus kag san iya mga disipulos, si Judas na anak ni Simon Iscariote ginpaisip san dyablo na magtraydor kan Jesus. ");
INSERT INTO msb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aram ni Jesus na ginpaniwala sa iya san Ama an kagamhanan agod himuon an tanan. Aram man niya na hali siya sa Dios kag magabalik gihapon sa iya. ");
INSERT INTO msb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kaya tumindog si Jesus, hinuba an iya pansuon na bado kag nagbalighot sin twalya sa iya hawak. ");
INSERT INTO msb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tapos, pakabuhos niyaʼn tubig sa planggana, nagtuna paghugas san mga tiil san iya mga disipulos kag pagtrapo sani paagi san twalya na nakabalighot sa iya hawak. ");
INSERT INTO msb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pagtungod niya kan Simon Pedro nagsabi ini sa iya, “Ginoo, dili mo naman dapat hugasan an akon tiil.” ");
INSERT INTO msb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ginsabat siya ni Jesus, “Dili mo pa yana nasasabutan an akon ginahimo pero sa maabot masasabutan mo na.” ");
INSERT INTO msb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nagpatugas si Pedro, “Hasta na lang dili ka gayod magahugas san akon tiil!” Didi nagpahayag si Jesus, “Kun dili ko hugasan an imo tiil, dili ko na ikaw kausad.” ");
INSERT INTO msb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nagsabat si Simon Pedro, “Ginoo, dili lang kay an akon tiil an imo hugasan kundi hasta an akon kamot kag ulo!” ");
INSERT INTO msb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nagsabat si Jesus, “An nagkarigo na dili na kinahanglan hugasan pa pwera na lang sa iya tiil kay malinis na siya. Sugad man kamo mga malinis na pero dili an tanan sa iyo.” ");
INSERT INTO msb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Niyan, nakasabi si Jesus sani na “pero dili tanan sa iyo malinis” kay aram naman niya kun sin-o an magatraydor sa iya. ");
INSERT INTO msb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pakahugas niya san inda mga tiil, ginsul-ot gihapon an iya ginhuba na pansuon kag nagbalik sa lamesa. “Nano, nasabutan niyo an ginhimo ko sa iyo?” an hunga niya. ");
INSERT INTO msb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Ginatawag niyo ako na Maestro kag Ginoo. Matuod ina kay ako amo gayod ina. ");
INSERT INTO msb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kaya, kun ako na iyo Ginoo kag Maestro naghugas san iyo mga tiil, dapat magpahurugas-hugas man kamo san iyo tiil. ");
INSERT INTO msb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ginpakita ta kamo sin halimbawa agod irugon man niyo kun nano an ginhimo ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Matuod gayod na waraʼn suruguon na labaw pa ki sa iya amo kag wara sin ginsugo na labaw pa sa nagsugo sa iya. ");
INSERT INTO msb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Niyan na aram na niyo ini tanan na ginsabi ko, malipay kamo kun tumanon niyo. ");
INSERT INTO msb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Dili kamo tanan an ginapabatian ko. Aram ko an akon mga pinili pero dapat matuman na an nasusurat sa Banal Na Kasuratan na amo ini, ‘An nakisaro sa akon sa lamesa nagin kontra sa akon.’ ");
INSERT INTO msb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ginasabi ko na sa iyo antes ini mangyari, kay kun mangyari ini amo pa lang kamo magatuod na ako amo idtoʼn ginsabi ko kasadto na ako. ");
INSERT INTO msb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Matuod gayod na an mag-ako sa sinugo ko nagaako man sa akon kag an mag-ako sa akon nagaako man sa nagsugo sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pakasabi sani ni Jesus nahandal gayod siya kag nagsabi sin hayag, “Matuod gayod na may usad sa iyo na matraydor sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nagpasurusurud-ong an mga disipulos kay dili ninda aram kun sin-o an iya ginapatamaan. ");
INSERT INTO msb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Niyan, an palangga na disipulos ni Jesus na katakin gayod niya kaya bagaʼn nakasandig na sa iya ");
INSERT INTO msb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","an ginpasabot ni Simon Pedro na hungaon kun sin-o ina na iya ginsabi. ");
INSERT INTO msb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kaya nakasandig na siya kan Jesus na naghunga, “Ginoo, sin-o ba ina?” ");
INSERT INTO msb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“Siya amo an hahatagan ko sani na tinapay pakasawsaw ko,” an sabat ni Jesus. Kaya pakasawsaw niya sani hinatag kan Judas na anak ni Simon Iscariote. ");
INSERT INTO msb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pakabaton naman sani ni Judas nagsulod sa iya si Satanas. Pakatapos ginsabihan siya ni Jesus, “Himua dayon an hihimuon mo.” ");
INSERT INTO msb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Waraʼn adto sa lamesa na nakasabot kun nano kay ginsabi ini ni Jesus. ");
INSERT INTO msb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","May pira sa inda na naghuna na tungod kay si Judas an nagahuyot san kwarta ginasabihan siya ni Jesus, “Magbakal ka san aton mga kinahanglanon sa pyista,” o kadaka ginasabihan siya na maglimos sa pobre. ");
INSERT INTO msb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pakabaton ni Judas san tinapay nagluwas siya dayon. Gab-i na sadto. ");
INSERT INTO msb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pakaluwas ni Judas nagsabi si Jesus, “Niyan, tikahayagon an galang ko na Anak San Tawo kag paagi sa akon an glorya naman san Dios. ");
INSERT INTO msb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kun gin-galang an Dios paagi sa akon, pagagalangan naman ako dayon san Dios mismo. ");
INSERT INTO msb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mga namumut-an ko na baga man lang an akon kaanakan, dili na ako madudugay pakig-upod sa iyo. Paghali ko, hahanapon niyo ako pero ginasabi ko sa iyo pareho san ginsabi ko man sa mga namumuno san mga Judio na dili kamo makakadto sa akon kakadtuan. ");
INSERT INTO msb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pero may bag-o na sugo ako para sa iyo: magkaminuruutan kamo. Dapat gayod na magkaminuruutan kamo pareho san pagkamuot ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kay kun magkaminuruutan kamo, makikilala san tanan na kamo mga disipulos ko.” ");
INSERT INTO msb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pakabati sani naghunga sa iya si Simon Pedro, “Ginoo, mapakain ka?” Nagsabat si Jesus, “Sa akon kakadtuan dili ka makasunod niyan pero dili madugay masunod ka na.” ");
INSERT INTO msb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Naghunga gihapon si Pedro, “Ginoo, nano kay dili ako pwede magsunod sa imo niyan? Handa ako mamatay alang-alang sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ginsabat siya ni Jesus, “Nano, handa ka man gayod mamatay alang-alang sa akon? Matuod gayod na antes pa magaturaok an manok ginpaambutan mo na akoʼn tulo ka beses.” ");
INSERT INTO msb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tapos nagsurmaton si Jesus sa tanan na mga disipulos, “Ayaw kamo kahandal kundi magtuod sa Dios kag sa akon. ");
INSERT INTO msb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Makadto ako sa istaran san akon Ama agod magpreparar san lugar para sa iyo kay didto damoʼn mga kwarto. Kun dili ini matuod dili ako masumat sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pakapreparar ko sin lugar para sa iyo, mabalik gihapon ako agod iupod na kamo, tapos kun hain ako adto man kamo. ");
INSERT INTO msb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Niyan, aram na niyo an pagpakadto sa akon kakadtuan.” ");
INSERT INTO msb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nagsabi sa iya si Tomas, “Ginoo, dili pa namon aram kun mapakain ka, kaya pan-o namon maaraman an pagpakadto?” ");
INSERT INTO msb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ginsabat siya ni Jesus, “Ako an dalan pagpakadto sa Ama. Ako man an ginahalinan san kamatuudan manungod sa iya kag an nagahatag sin waraʼn katapusan na buhay. Waraʼn makakadto sa iya kun dili paagi sa akon. ");
INSERT INTO msb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kun nakilala niyo ako nakilala man niyo an akon Ama. Tuna niyan kilala na niyo siya kag nakita na niyo.” ");
INSERT INTO msb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ginsabihan naman si Jesus ni Felipe, “Ginoo, ipakita sa amon an Ama kag kontento na kami.” ");
INSERT INTO msb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nagsabat naman si Jesus, “Felipe, dugay na na panahon an pag-urupod naton kag dili mo lang gihapon ako kilala? An nakakita sa akon nakakita man sa Ama. Kaya nano kay masabi ka na ‘Ipakita sa amon an Ama’? ");
INSERT INTO msb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nano, dili ka nagatuod na nakig-usad ako sa Ama kag siya nakig-usad man sa akon? Dili hali sa akon sadiri na kabubut-on an mga ginasabi ko sa iyo. Ginahimo san Ama na adi sa akon an iya mismo mga himo. ");
INSERT INTO msb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dapat magtuod kamo sa akon na nakig-usad ako sa Ama kag siya man sa akon. Pero kun dili niyo mahimo, magtuod lang kamo dahilan sani na mga hinimo ko. ");
INSERT INTO msb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Matuod gayod na an nagatuod sa akon makahimo san akon mga ginaparahimo kag mas labaw pa sana an mga mahihimo niya kay makadto ako sa Ama. ");
INSERT INTO msb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pwera pa sani, hihimuon ko an nano man na ayuon niyo susog sa pagbuot ko agod umawon an Ama paagi sa Anak. ");
INSERT INTO msb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kaya hihimuon ko man gayod an nano man na ayuon niyo paagi sa ngaran ko. ");
INSERT INTO msb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kun namumuot kamo sa akon, tutumanon niyo an akon mga kasuguan. ");
INSERT INTO msb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kaya aayuon ko sa Ama na hatagan kamo sin iba pa na Parabulig na magaupod sa iyo hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","An makakaupod niyo amo an Espirito na makapasabot sa iyo san kamatuudan manungod sa Dios. Ini an Espirito na dili makaako an katawuhan san kinab-an kay dili ninda siya nakikita o nakikilala. Pero kilala niyo siya kay siya kaupod niyo kag ada siya magaistar sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Bisan maghali na ako dili ta kamo pagapabayaan na bagaʼn mga ilo pero mabalik ako. ");
INSERT INTO msb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pakatapos sin kadali na panahon dili na ako makikita san katawuhan san kinab-an pero makikita niyo ako. Kay buhay ako kaya mabubuhay man kamo. ");
INSERT INTO msb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sana na adlaw masasabutan niyo na ako adto sa pakig-usad sa akon Ama. Kamo nakig-usad sa akon kag ako man sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","An namumuot sa akon amo an nag-ako san akon mga kasuguan kag nagatuman sana. An namumuot pa gayod sa akon mamumut-an san Ama kag ako man mamumuot kag magapakita sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","May iba na Judas (kay dili ini si Judas Iscariote) na naghunga man, “Ginoo, nano kay sa amon ka lang mapakita kag dili sa katawuhan san kinab-an?” ");
INSERT INTO msb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Didi naman nagpahayag si Jesus, “An namumuot sa akon tutumanon an akon mga surmaton kag mamumuot man sa iya an akon Ama. Tapos makiusad kami sa iya kag iistaran namon siya. ");
INSERT INTO msb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","An dili naman namumuot sa akon dili nagatuman san akon mga surmaton. Niyan, dili hali sa akon sadiri an surmaton na iyo nababati kundi hali sa Ama na nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ini tanan ginasabi ko sa iyo myintras adi pa ako kaupod niyo. ");
INSERT INTO msb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero igwaʼn Parabulig na amo an Espirito Santo na ipapadara sa iyo san Ama para sa lugar ko. Siya an magapadumdom san tanan na ginsabi ko sa iyo kag magatukdo sa iyo manungod sani. ");
INSERT INTO msb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","An kalinaw ibibilin ko sa iyo kaya may kalinaw kamo hali sa akon. Iba ini san pagapalinaw sa iyo san katawuhan sa kinab-an na dili nagasunod sa akon. Kaya ayaw kamo kahandal kag kahadlok. ");
INSERT INTO msb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nabati niyo na ginsabi ko, ‘Mahali na ako pero mabalik gihapon.’ Kun namumuot kamo sa akon magin malipay kamo na makadto ako sa Ama kay mas labaw siya ki sa akon. ");
INSERT INTO msb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ginsabi ko na ini sa iyo antes mangyari agod kun mangyari magtuod kamo. ");
INSERT INTO msb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Madali na lang na panahon na makisurmaton pa ako sa iyo kay an Dyablo na amo an prinsipe sani na kinab-an nagadangadang na. Kaya lang, wara iniʼn gahom sa akon ");
INSERT INTO msb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero agod maaraman san katawuhan san kinab-an na namumuot ako sa Ama, ginatuman ko an ginsugo niya sa akon. Hamos na kita.” ");
INSERT INTO msb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Pakalarga ninda nagsabi si Jesus, “Ako an tunay na puno san ubas kag an akon Ama an paraataman. ");
INSERT INTO msb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pupuludon niya an dili nagapamunga na sanga na ada sa akon pero an tanan na mga nagapamunga na sanga ginapungon niya agod mas lalo na mamunga. ");
INSERT INTO msb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mga malinis na kamo paagi san mga gintukdo ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Magpadayon kamo na kausad ko kag ako man sa iyo. Pareho san sanga na dili makapamunga sa sadiri lang niya kundi dapat kausad ini san puno, amo man kamo dili makapamunga kun dili magpadayon sa pakig-usad sa akon. ");
INSERT INTO msb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ako an puno kag kamo an mga sanga. Nagapamungaʼn damo an nagapadayon pakig-usad sa akon kag ako man ada sa pakig-usad sa iya. Matuod ini kay dili kamo makapamunga kun wara ako sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","An dili naman nagapadayon pakig-usad sa akon pareho sa gintapok na sanga na nauuga, kaya, ginatipon ini na mga sanga, ginadabok sa kalayo kag nauugdaw. ");
INSERT INTO msb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pero kun nagapadayon kamo pakig-usad sa akon kag pirme man niyo ginatuman an akon mga surmaton, maaayo niyo an nano man na iyo gusto kag ihahatag sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kun nagapamunga kamoʼn damo, nagapamatuod kamo na mga disipulos ko kag paagi sani ginaumaw an akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“An pagkamuot ko sa iyo pareho san pagkamuot sa akon san Ama. Dapat kamo magpadayon sa akon pagkamuot, ");
INSERT INTO msb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","kag magapadayon gayod kamo sa akon pagkamuot kun tumanon niyo an akon mga kasuguan pareho na gintuman ko an mga kasuguan san akon Ama kag nagapadayon sa iya pagkamuot sa akon. ");
INSERT INTO msb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ginsabi ko ini sa iyo agod mapalipay kamo san akon kalipay kag mabiyo an iyo kalipay. ");
INSERT INTO msb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Amo ini an akon sugo: magkaminuruutan kamo pareho san pagkamuot ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","An pinakalabaw na pagkamuot na ikapakita sin tawo para sa iya mga kaamigo amo an pagpakamatay para sa inda. ");
INSERT INTO msb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mga kaamigo ta kamo kun tumanon niyo an mga ginasugo ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Dili ta na kamo ginatawag na mga uripon kundi mga kaamigo kay an uripon dili aram an ginahimo san iya amo. Pero bilang mga kaamigo ko ginsumat ko sa iyo an tanan na nabatian ko sa akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Dili kamo an nagpili sa akon kundi ako an nagpili sa iyo kag nagbutang na mamuhay kamo na nagapamunga kag magapadayon ini na bunga hasta na lang. Kun sugad, ihahatag sa iyo san Ama an nano man na ayuon niyo sa iya sa ngaran ko. ");
INSERT INTO msb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kaya ginaotro ko an akon sugo: magkaminuruutan kamo. ");
INSERT INTO msb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kun ginasikway kamo san tagakinab-an, dumduma niyo na ginsikway na anay ninda ako antes kamo. ");
INSERT INTO msb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kun katawuhan kuntani kamo san kinab-an, mamumut-an kamo san katawuhan sani bilang sadiri ninda. Pero palibhasa dili kamo katawuhan san kinab-an kundi ginpili ta kamo hali sa inda, kaya ginasikway kamo ninda. ");
INSERT INTO msb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dumduma an ginsabi ko sa iyo: ‘waraʼn uripon na labaw sa iya amo.’ Kaya kun ginpasakitan ninda ako, pagapasakitan man kamo. Kun gintuman ninda an akon katukduan, tutumanon man ninda hasta an katukduan niyo. ");
INSERT INTO msb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero hihimuon ninda sa iyo ini tanan dahilan na sa akon kamo kag dahilan man na dili ninda kilala an nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Kun wara ako nagpakadi kag nagsurmaton sa inda, wara sindaʼn kasal-an. Pero sa sugad wara na sindaʼn ikadahilan san inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","An nagasikway sa akon ginasikway man an akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kun wara ako naghimo sa atubangan ninda sani na mga himo na wara pa gayod sin nakahimo, dili sinda masasala pero sa sugad na nakita na ninda ini tanan, sa gihapon ginasikway ninda ako kag san akon Ama. ");
INSERT INTO msb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ugaling nangyari ini agod matuman an nasusurat sa inda Kasuguan na amo ini, ‘Ginsikway ako ninda na waraʼn dahilan.’ ");
INSERT INTO msb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pero pag-abot san Parabulig na hali sa Ama, magatestigo siya manungod sa akon. Siya amo an Espirito na magapasabot san kamatuudan kaya ipapadara ko siya sa iyo hali sa Ama. ");
INSERT INTO msb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tapos kamo naman magatestigo man kay mga kaurupod ta kamo tuna san katuna-tunai. ");
INSERT INTO msb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ini tanan ginsabi ko sa iyo agod dili niyo bayaan an iyo pagtuod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pagapahalion kamo sa mga sinagoga kag maabot ngani an adlaw na magahuna an mapatay sa iyo na ini pagsirbe sa Dios. ");
INSERT INTO msb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hihimuon ninda ini kay dili ninda nakilala an Ama hasta ako. ");
INSERT INTO msb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero ginsabi ko ini sa iyo agod pag-abot sana na oras kun mangyari ini madumduman niyo na ako nagpadaan sani sa iyo. Wara ko anay ini pag-isabi sa iyo kasadto kay kaupod pa ako niyo. ");
INSERT INTO msb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Niyan mabalik na ako sa nagsugo sa akon pero wara naman ni usad sa iyo sin naghunga kun mapakain ako, ");
INSERT INTO msb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kundi namumundo kamo kay ginsabi ko ini sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kaya lang matuod gayod na ini na paghali ko para sa iyo sadiri na kaayuhan kay kun dili, dili man mapakadi sa iyo an Parabulig. Pero kun maghali ako papakadion ko siya sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pag-abot niya igapamatuod niya sa katawuhan na sala an inda paghuna manungod sa kasal-an kag manungod sa katanusan kag paghusgar. ");
INSERT INTO msb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","An una, manungod sa kasal-an kay igapakita niya na may sala sinda kay dili nagatuod sa akon. ");
INSERT INTO msb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tapos, manungod naman sa katanusan kay igapamatuod man niya na matanos ako kay mapakadto ako sa Ama kag dili na ako niyo makikita. ");
INSERT INTO msb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sa urhi, manungod sa paghusgar kay igapakita niya na huhusgaran an mga tawo kay ginhusgaran na san Dios an Dyablo na namumuno sani na kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Damo pa an mga sarabihon ko sa iyo pero dili pa niyo ini kakayahon yana. ");
INSERT INTO msb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pag-abot san Espirito na magapasabot san kamatuudan, papaaramon kamo niya san bilog na kamatuudan na hali sa Dios kay dili siya magasurmaton hali sa iya sadiri kundi sasabihon lang niya kun nano an iya nabati kag igapahayag pa niya sa iyo an mga maabot. ");
INSERT INTO msb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Gagalangan niya ako kay an tanan na igapahayag niya sa iyo an babatunon anay niya hali sa akon. ");
INSERT INTO msb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kay sa akon an tanan na nasa Ama. Kaya ginsabi ko sa iyo na hali sa akon an tanan na igapahayag niya sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Sa halip-ot lang na panahon, dili na ako niyo makikita. Pakatapos dili madugay makikita naman niyo ako gihapon.” ");
INSERT INTO msb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kaya didi nagpahurunga-hunga an iba san iya mga disipulos, “Nano daw an iya gusto sabihon na sa halip-ot na panahon dili ta na siya makikita, pakatapos dili madugay makikita naman gihapon naton siya? Nano man ini na mabalik siya sa Ama? ");
INSERT INTO msb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nano daw an iya gusto sabihon san ‘sa halip-ot na panahon’? Dili ta aram kun nano.” ");
INSERT INTO msb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Didi aram na ni Jesus na may ihurunga sinda sa iya kaya nagsabi siya, “Nano, nagapahurunga-hunga kamo kun nano an gusto sabihon san akon ginasabi, ‘Mga pira-pira pa dili na ako niyo makikita. Pakatapos dili madugay makikita naman niyo ako gihapon’? ");
INSERT INTO msb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Matuod gayod na maganguruyngoy kag magabarakho kamo myintras magakalipay an katawuhan san kinab-an. Mamumundo kamo pero an iyo kamunduan magigin kalipayan. ");
INSERT INTO msb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pagpuros san babayi na nagaanak, namumundo kay nagatios siya. Pero pakaanak niya nalilimutan niya an iya pagsakit kay kalipay niya na may nabuhay naman na bata sa kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Pareho man niyo na sugad nagmumundo pero magakirita gihapon kita. Tapos malilipay gayod kamo kag waraʼn makaulang sa iyo sana na kalipayan. ");
INSERT INTO msb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pag-abot sana na adlaw dili na niyo ako pagahungaon pa. Matuod gayod na an nano man na ayuon niyo sa Ama sa akon ngaran igahatag niya sa iyo. ");
INSERT INTO msb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta sugad wara kamo nangayo na ginagamit an ngaran ko. Niyan, mangayo kamo kay kamo makabaton sani agod mabiyo an iyo kalipay. ");
INSERT INTO msb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ginsabi ko sa iyo ini tanan paagi sa mga istorya. Maabot an oras na dili na ako makisurmaton sa iyo paagi sa mga istorya kundi hayag na igaistorya ko sa iyo an manungod sa Ama. ");
INSERT INTO msb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pag-abot sana na adlaw, mangangayo kamo paagi sa paggamit san akon ngaran kag dili ako kinahanglan mag-ayo sa Ama alang-alang sa iyo, ");
INSERT INTO msb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kay an Ama mismo namumuot sa iyo kay namumuot kamo sa akon kag nagtuod man kamo na ako hali sa Ama. ");
INSERT INTO msb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naghali ako sa Ama kag nagkadi sa kinab-an. Niyan, babayaan ko ini kag mabalik sa Ama.” ");
INSERT INTO msb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Didi nagsarabi an iya mga disipulos, “Niyan nagasurmaton ka na sin hayag kag dili na paagi sa mga istorya! ");
INSERT INTO msb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aram na namon na naaaraman mo na an tanan kag dili na kinahanglan na maghulat hasta maghunga pa sa imo antes maaram mo kun nano an iniisip niya. Tungod sani nagatuod kami na ikaw hali sa Dios.” ");
INSERT INTO msb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ginsabat sinda ni Jesus, “Nano, nagatuod na kamo niyan? ");
INSERT INTO msb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pamati kamo, maabot na an oras kag matuod man gayod na adi na na pagaburulagon kamo. Kada iya may uulian kag pagabayaan ako na waraʼn kaupod. Pero pirme ako may kaupod kay an Ama adi sa pakig-usad sa akon. ");
INSERT INTO msb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ini tanan ginsabi ko sa iyo agod magkaigwa kamo san kalinawan paagi sa pakig-usad sa akon. Magatios ugaling kamo didi sa kinab-an pero pakusuga an iyo buot kay nadaog ko na an poder didi sani na kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pakasurmaton sani ni Jesus, naghangad siya sa langit kag nagpangadyi, “O Ama, adi na an oras. Pagalangan mo ako bilang imo anak agod ikaw naman an pagalangan ko. ");
INSERT INTO msb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Niyan, ginhatagan mo akoʼn poder na sakupon an tanan na katawuhan agod idtoʼn mga ginpaniwala mo sa akon bubuhayon ko hasta na lang. ");
INSERT INTO msb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amo ini an paagi kun pan-o an mga tawo mabubuhay hasta na lang: dapat ninda nakikilala ka na amo lang an matuod na Dios kag amo man ako na si Jesu-Cristo na sinugo mo. ");
INSERT INTO msb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ginpagalangan ko ikaw sa katawuhan san kinab-an paagi sa pagtapos san ginpahimo mo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kaya, Ama, pagalangan mo ako sa imo mismo atubangan pareho san ginpagalangan mo ako kasadto san kaupod mo ako antes ginlalang an kinab-an. ");
INSERT INTO msb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ginpakilala ta ikaw sa mga tawo na ginpaniwala mo sa akon hali sa kinab-an. Dati sa imo sinda pero ginpaniwala mo sa akon kag gintuman ninda an imo mensahe. ");
INSERT INTO msb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Niyan, aram ninda na hali man gayod sa imo an tanan na ginhatag mo sa akon, ");
INSERT INTO msb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kay gintukdo ko sa inda an mga ginsabi mo sa akon kag gin-ako ninda ini. Matuod na aram man ninda na ako hali sa imo kag nagatuod pa na ako sinugo mo. ");
INSERT INTO msb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ginapangadyi ko sinda. Dili ako nagapangadyi san tagakinab-an kundi para sadtoʼn ginpaniwala mo sa akon kay sinda sa imo man. ");
INSERT INTO msb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sa imo an tanan na sa akon kag sa akon man an tanan na sa imo. Niyan, ginaumaw ako paagi sa inda. ");
INSERT INTO msb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Magabaya ako sa kinab-an kay mabalik na sa imo pero sinda nasa kinab-an pa. Banal na Ama, agod magkaurusad sinda pareho ta, atamana man sinda paagi sa poder san imo ngaran na amo an ginhatag mo man ngani sa akon. ");
INSERT INTO msb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tuna san amon pag-urupod, gin-ataman ko sinda paagi sa imo poder na ginhatag mo man ngani sa akon. Gin-ataman ko sinda, kaya wara ni usad man sa inda na nawara hasta na lang kundi idto man lang gayod na nawara agod matuman an kasuratan. ");
INSERT INTO msb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Niyan, mapakada ako sa imo pero ginasabi ko ini tanan myintras adi pa ako sa kinab-an agod makabahin sinda san akon biyo na kalipayan. ");
INSERT INTO msb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gintukdo ko sa inda an ginsabi mo sa akon kag ginasikway sinda san mga tagakinab-an kay dili sinda kaurusad sani pareho sa akon na dili man kausad sa inda. ");
INSERT INTO msb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dili ko ginahangyo na halion mo sinda sa kinab-an kundi ilikay mo sinda sa gahom san Dyablo. ");
INSERT INTO msb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Dili sinda kaurusad sa mga tagakinab-an pareho sa akon na dili man kausad sa mga tagakinab-an. ");
INSERT INTO msb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Himua sinda na imo banal na katawuhan paagi sa kamatuudan san katukduan mo. Matuod gayod an mga surmaton mo. ");
INSERT INTO msb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ginsugo ko sinda pakadto sa mga tagakinab-an pareho san pagsugo mo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Niyan, nagahalad na ako san akon buhay alang-alang sa inda agod himuon sinda na banal na katawuhan. ");
INSERT INTO msb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Dili lang sinda an ginapangadyi ko kundi paagi sa inda mga katukduan may mga magatuod man sa akon na ginapangadyi ko pa. ");
INSERT INTO msb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ama, ginapangadyi ko na magkaurusad na sinda tanan pareho na ikaw adi sa pakig-usad sa akon kag ako man sa imo. Ginaayo ko man na magkaurusad lugod sinda sa aton agod magturuod an katawuhan san kinab-an na ginsugo mo ako. ");
INSERT INTO msb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ginpaambit ko sa akon mga disipulos an paggalang na ginhatag mo sa akon agod magkaurusad lugod sinda pareho na kita nagkausad. ");
INSERT INTO msb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Oo, may paggalang sinda paagi san pakig-usad ko sa inda sugad san akon paggalang paagi man san pakig-usad mo naman sa akon. Kaya biluga an pagkaurusad ninda agod maaraman san katawuhan san kinab-an na ikaw an nagsugo sa akon kag namumut-an mo man an akon mga disipulos pareho san pagkamuot mo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, gusto ko na kun diin man ako, makaupod sa akon idtoʼn mga hinatag mo sa akon na mga katawuhan agod makita ninda an akon glorya. Ginhatag mo ini sa akon kay antes pa ginlalang an kinab-an namut-an mo ako. ");
INSERT INTO msb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O matanos na Ama, dili nakaaram sa imo an katawuhan san kinab-an pero aram ta ikaw kag maaram man ini na mga disipulos na ikaw an nagsugo sa akon. ");
INSERT INTO msb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ginhayag ko ikaw sa inda kag padayon ko na igahayag agod mapasa inda an pagkamuot mo sa akon kag ako mismo mapasa inda man.” ");
INSERT INTO msb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pakapangadyi ni Jesus nagluwas siya kaupod san iya mga disipulos kag nagtabok sa sapa san Cedron. Didto may hardin kun diin nagsulod sinda. ");
INSERT INTO msb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Idtoʼn lugar kabisado ni Judas na nagatraydor kan Jesus kay dati pirme sinda nagatiripon didto. ");
INSERT INTO msb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kaya, pakapatiripuna ni Judas san grupo san mga suldados kag san mga bantay na sinugo san mga namumuno san kapadian kag mga Pariseo, gin-giyahan niya sinda pakadto sadtoʼn lugar na may mga daraʼn ilawan, kurukod kag armas. ");
INSERT INTO msb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pag-abot ninda didto, sinugat sinda ni Jesus kay aram niya an tanan na mangyayari sa iya. Kaya ginhunga niya, “Sin-o an ginahanap niyo?” ");
INSERT INTO msb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nagsabat sinda, “Si Jesus na taga-Nazaret.” Didi, nagsabat si Jesus, “Ako siya.” Si Judas na nagatraydor sa iya kaupod ninda. ");
INSERT INTO msb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pakasabi ni Jesus sin “Ako siya,” nagsiribog sinda kag nagkaturumba sa duta. ");
INSERT INTO msb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hinunga gihapon niya sinda, “Sin-o man gayod an ginahanap niyo?” Nagsabat sinda, “Si Jesus na taga-Nazaret.” ");
INSERT INTO msb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Ginsabihan ta kamo na ako siya, kaya kun ako man gayod an ginahanap niyo, pabayai na mag-uruli an kaurupod ko,” an sabat ni Jesus. ");
INSERT INTO msb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nasabi niya ini agod matuman an iya ginsurmaton, “Sa mga ginpaniwala mo sa akon wara akoʼn nawara sa inda ni usad.” ");
INSERT INTO msb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tapos hinugnot ni Simon Pedro an iya dara na talibong, tinigbas an tuo na talinga san suruguon san pinakapuno san kapadian, kaya nautas ini. Malco an ngaran sadtoʼn suruguon. ");
INSERT INTO msb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sinabihan ni Jesus si Pedro, “Ibalik an imo talibong sa taguban. Nano, dili mo aram na dapat ko inumon an nasa kupa san pagtios na hinatag sa akon san Ama?” ");
INSERT INTO msb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kaya, dinakop si Jesus san mga suldados kaupod san inda kapitan kag san mga bantay na mga Judio. Pakatapos gin-gapos siya. ");
INSERT INTO msb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dinara anay siya ninda kan Anas kay si Anas ugangan ni Caifas na amo an pinakanamumuno san kapadian sadto na tuig. ");
INSERT INTO msb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas amo idtoʼn nagsabi sa mga namumuno na Judio sin “Maayo pa kun dapat usad lang na tawo an mamatay para sa mga tawo na Judio.” ");
INSERT INTO msb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Niyan, nagsunod kan Jesus si Simon Pedro kag sin usad pa na disipulos. Nakatapo naman na kilala san pinakapuno san kapadian idtoʼn disipulos kaya nakaupod siya kan Jesus pasulod sa natad san palasyo san pinakapuno san kapadian. ");
INSERT INTO msb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero nagpabilin sa luwas sa may pwertahan si Pedro. Kaya, nagluwas idtoʼn disipulos na kilala san pinakapuno san kapadian kag ginpakisurmatunan an babayi na nagabantay sa pwertahan, tapos gin-upod si Pedro pasulod. ");
INSERT INTO msb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Naghunga kan Pedro iniʼn suruguon na babayi na nagabantay sa pwertahan, “Nano, dili disipulos ka man sana na tawo?” Nagsabat siya, “Ambot, dili ako.” ");
INSERT INTO msb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mahagkot sadto kaya nagdabok sin uring sa kalayo an mga suruguon kag san mga bantay. Nagtirindog sinda didto patalibod na nagapainit. Adto man didto si Pedro nagapainit kaupod man ninda. ");
INSERT INTO msb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Niyan, ginhunga naman si Jesus san pinakapuno san kapadian manungod sa iya mga disipulos kag katukduan. ");
INSERT INTO msb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nagsabat si Jesus, “Gintukdo ko ini na hayag agod mabati san tanan na tawo sa kinab-an. Pirme ako nagatukdo sa mga sinagoga kag sa templo kun diin ginatiripunan san tanan na mga Judio. Wara ako sin ginsikreto. ");
INSERT INTO msb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kaya nano kay ginapirit niyo ako na magtestigos kontra sa akon sadiri? Hungaa sa mga nagapamarati sa akon kun nano an akon gintukdo. Aram ninda kun nano an ginsabi ko.” ");
INSERT INTO msb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pakasurmaton sani ni Jesus, sumampadong sa iya an usad san mga bantay na nagatindog didto na nagasabi, “Nano, amo ina an pagsabat sa pinakapuno san kapadian?” ");
INSERT INTO msb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nagsabat si Jesus, “Kun nagsurmaton akoʼn dili tama pamatuudan mo ina pero kun matuod ini nano kay ginsampadungan mo ako?” ");
INSERT INTO msb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pakatapos ginpadara ni Anas si Jesus na nakagapos pakadto kan Caifas na pinakanamumuno san kapadian. ");
INSERT INTO msb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Myintras adto didto sa may tungod san kalayo si Simon Pedro na nagapainit, may naghunga sa iya, “Nano, dili disipulos ka man sana na tawo?” “Ambot, dili ako,” an sabat niya. ");
INSERT INTO msb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","May naghunga man na suruguon san pinakapuno na padi, “Nano, dili ta man ikaw nakita na kaupod niya sa hardin?” Ini siya paryente sadtoʼn lalaki na nautas ni Pedro an talinga. ");
INSERT INTO msb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nagpaambot gihapon Si Pedro kag nagturaok dayon an manok. ");
INSERT INTO msb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aga na sadto san paghali san mga namumuno na Judio sa balay ni Caifas kag ginguyod si Jesus sa ginatawag na Pretoryo na amo an dako na istaran san gobernador na hali sa Roma. Wara sinda mismo magsulod didi kay basi makasala sinda sa inda mismo Kasuguan kag dili makakaon san panihapon sa Paskwa. ");
INSERT INTO msb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaya nagluwas an gobernador na si Pilato kag naghunga, “Nano an akusasyon niyo kontra sani na tawo?” ");
INSERT INTO msb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nagsabat sinda, “Kun wara siyaʼn sala dili na namon siya gindara pakadi sa imo.” ");
INSERT INTO msb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sinabihan sinda ni Pilato, “Kamo an bahala sa iya. Husgari niyo siya paagi sa iyo sadiri na Kasuguan.” Nagsabat an mga namumuno san mga Judio, “Dili tugot sa amon na magpatay bisan sin-o.” ");
INSERT INTO msb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nangyari ini agod matuman an ginsabi ni Jesus kun pan-o siya mamatay. ");
INSERT INTO msb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kaya nagbalik gihapon si Pilato sa palasyo kag ginpatulos si Jesus, “Nano, ikaw an hadi san mga Judio?” an iya hunga. ");
INSERT INTO msb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nagsabat si Jesus, “Ini kaya na imo hunga hali sa sadiri mo na kabubut-on o may nagsabi sa imo manungod sa akon?” ");
INSERT INTO msb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nagsabat si Pilato, “Nano, Judio ako? Gindara ka sa akon san mga namumuno niyo na mga Judio kag mga namumuno san kapadian. Nano an ginhimo mo?” ");
INSERT INTO msb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Didi nagpahayag si Jesus, “Dili sani na kinab-an an akon kahadian. Kun an akon kahadian adi sani na kinab-an, an akon mga parasunod makig-away agod dili ako mapasa mga Judio. Pero an akon kahadian wara sani na kinab-an.” ");
INSERT INTO msb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Kun sugad, hadi ka?” an hunga ni Pilato. “Ikaw an nagsabi sana,” an sabat naman ni Jesus. “Matuod na ako hadi. Tungod sani gin-anak ako kag nagpakadi sa kinab-an agod magin testigo manungod san kamatuudan. An sin-o man na gusto maaram san kamatuudan an nagapamati sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Kamatuudan, nano ina?” an hunga ni Pilato. Pakahunga sani nagluwas siya gihapon kag nagsabi sa mga Judio, “Wara akoʼn nakikita na sala kontra sani na tawo. ");
INSERT INTO msb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero susog sa iyo kaugalian nagabuhi ako sa iyo sin priso sa adlaw san Paskwa. Nano, gusto niyo na buhian ko an hadi niyo na mga Judio?” ");
INSERT INTO msb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kaya nagsiriyak sinda, “Dili ini na tawo kundi si Barabas.” Niyan, ini siya tulisan. ");
INSERT INTO msb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Niyan, ginpakuha ni Pilato si Jesus kag ginpalatigo. ");
INSERT INTO msb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pakatapos sani naghimo an mga suldados sin korona hali sa mga balagon na tunukon kag ginkorona sa ulo ni Jesus. Tapos sinul-utan siya sin lila na kapa. ");
INSERT INTO msb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nag-arapiki sinda sa iya na nagasarabi, “Mabuhay an Hadi san mga Judio!” kag ginaparasarampadong siya ninda. ");
INSERT INTO msb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nagluwas gihapon si Pilato kag sinabihan an mga Judio, “Kitaa, ginapakita ko siya sa iyo agod maaraman niyo na wara akoʼn makita na sala sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kaya ginpaluwas si Jesus na nakukoronahan sin tunok kag nakasul-ot san lila na kapa. Sinabihan sinda ni Pilato, “Kitaa, adi an tawo!” ");
INSERT INTO msb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pakakita sa iya san mga namumuno san kapadian kag san mga bantay nagsiriyak, “Ipako siya! Ipako siya!” Nagsabat si Pilato, “Kamo mismo an magkuha sa iya kag ipako sa krus kay wara akoʼn makita na sala sa iya.” ");
INSERT INTO msb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nagsabat an mga Judio, “Igwa kamiʼn layi kag susog sani dapat siya ipapatay kay gin-angkon niya na siya an Anak san Dios.” ");
INSERT INTO msb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pakabati ni Pilato pagsabi ninda sani, nagdugang an iya kahadlok. ");
INSERT INTO msb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pagsulod gihapon niya sa palasyo ginhunga niya si Jesus, “Tagadiin ka?” Pero wara magsabat si Jesus. ");
INSERT INTO msb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kaya ginhunga gihapon siya ni Pilato, “Nano, habo ka makisurmaton sa akon? Dili mo kaya aram na may gahom ako na buhian ka o ipapako sa krus?” ");
INSERT INTO msb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Didi nagsabat si Jesus, “May gahom ka lang sa akon kay ginhatag ina sa imo hali sa Dios. Kaya ngani, mas labaw pa an kasal-an san nag-intrigar sa imo sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pakabati sani ni Pilato nagtalinguha siya na buhian si Jesus pero nagsiriyak gayod an mga Judio, “Kun buhian mo siya dili ka na kaamigo ni Cesar. Kay, aram mo, kontra kan Cesar an tanan na nagaangkon na siya hadi.” ");
INSERT INTO msb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pakabati naman sani ni Pilato, ginpaluwas niya si Jesus kag nag-ingkod sa ingkudan san paghusgar sa lugar na ginatawag na Salog Na Bato na sa Hebreo ginatawag na Gabata. ");
INSERT INTO msb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sadto maalas dose na san adlaw san Pagpreparar antes san adlaw san Paskwa. Nagsabi siya sa mga Judio, “Kitaa, adi an hadi niyo.” ");
INSERT INTO msb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero nagsiriyak sinda, “Halia siya, halia siya! Ipako siya!” Naghunga naman si Pilato, “Nano, gusto niyo na ipapako ko an iyo hadi?” Nagsabat an mga namumuno san kapadian, “Wara kami sin iba na hadi kundi si Cesar.” ");
INSERT INTO msb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sa katapus-tapusi, inintrigar ni Pilato si Jesus sa inda agod ipapako sa krus. ");
INSERT INTO msb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kaya kinuha si Jesus san mga suldados kag ginpaluwas siya na pas-an an iya krus pakadto sa ginatawag na Lugar San Bungo na ginatawag man sa Hebreo, Golgota. ");
INSERT INTO msb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Didto ninda ginpako siya sa krus kadungan san duha ka tawo sa magluyo niya. Tapos ginpatindog ini tanan. ");
INSERT INTO msb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","May ginsurat si Pilato kag ginbutang sa krus na an nakasurat sugad sini, “AMO INI SI JESUS NA TAGA-NASARET. SIYA AN HADI SAN MGA JUDIO.” ");
INSERT INTO msb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Damoʼn mga Judio an nakabasa sadto tungod kay halapit lang sa syudad idtoʼn lugar na ginpakuan kan Jesus kag an pakasurat sa Hebreo, Latin kag Griego. ");
INSERT INTO msb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kaya an mga namumuno san kapadian na mga Judio nagreklamo kan Pilato, “Dili mo dapat sinurat na ‘Hadi san mga Judio’ kundi ‘Ini na tawo nagsabi, Ako an hadi san mga Judio!’,” ");
INSERT INTO msb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nagsabat si Pilato, “An nasurat ko na dili na maliliwat.” ");
INSERT INTO msb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pakapako kan Jesus sa krus san mga suldados, kinuha ninda an sul-ot sani na mga yamit na inda na hinuba kag ginbahin ninda sin kaupat na parte, tig-urusad sinda. Amo man kinuha ninda an iya pangsuon. Pero ini waraʼn tinahian kay bilog na ginhimo tuna sa liog hasta sa sidsid. ");
INSERT INTO msb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kaya nagkauruyon sinda na imbes barahinon, ripahon na lang ninda kun sin-o an makakuha. Sani na pangyari natuman an Kasuratan na nasabi, “Ginbarahin ninda an akon mga sul-ot kag ginripahan an akon pansuon.” Kaya amo ini an ginhimo san mga suldados. ");
INSERT INTO msb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Niyan, sa may krus na ginpakuan kan Jesus nakatindog an iya iloy kag san kamanghod sani, tapos si Maria na asawa ni Clopas kag si Maria Magdalena. ");
INSERT INTO msb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pakakita ni Jesus sa iya iloy kag san katakin sani na palangga niya na disipulos, sinabihan niya an iya iloy, “Kitaa, ada na an imo anak.” ");
INSERT INTO msb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sa disipulos naman, “Kitaa, ada na an imo iloy.” Tuna sadto ginpadayon siya san disipulos sa inda balay. ");
INSERT INTO msb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Taud-taod, kay aram ni Jesus na an tanan na katuyuan san Dios para sa iya natuman na kag agod matuman pa an nasurat sa Kasuratan, nagsabi siya, “Napapaha ako.” ");
INSERT INTO msb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Niyan, igwa didto sin mangko na puno sin suka. Kaya kumuha sindaʼn ispungha, hinurom didto sa suka tapos ginbutang sa punta san sanga san kahoy na ginatawag hisopo kag gin-apiki sa iya ba-ba. ");
INSERT INTO msb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pakatimtimi ni Jesus san suka nagsabi, “Tapos na,” dinuko an iya ulo kag gin-intriga niya an iya espirito sa Dios. ");
INSERT INTO msb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Adlaw sadto san Pagpreparar antes san adlaw san Paskwa. Habo ninda mabilin sa krus an mga patay sadto na Adlaw San Pagpahuway kay importante ina na adlaw, kaya ginhangyo san mga namumuno san mga Judio kan Pilato na balion an mga batiis sani na tulo ka tawo agod mapatay dayon kag kuhaon an mga lawas. ");
INSERT INTO msb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tungod sani nagkadto an mga suldados kag binali an mga batiis san una na tawo na ginpako na kadungan ni Jesus. Tapos ginsunod an usad pa. ");
INSERT INTO msb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero pag-abot ninda kan Jesus nakita ninda na patay na, kaya wara na ninda pagbalia an iya mga batiis. ");
INSERT INTO msb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ugaling may usad san mga suldados na nagbangkaw san iya kilid. Umawas dayon an dugo kag tubig. ");
INSERT INTO msb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nagsumat an nakakita sani na pangyari agod magtuod man kamo. Matuod an iya pagkatestigo kay aram niya na matuod an iya ginasabi. ");
INSERT INTO msb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Niyan nangyari ini tanan agod matuman ini na kasuratan, “Waraʼn mababali ni usad man na iya tul-ang.” ");
INSERT INTO msb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sa iba na parte san Kasuratan may nasurat man, “Pagamasdan ninda siya na inda binangkaw.” ");
INSERT INTO msb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pakatapos sani naghangyo kan Pilato si Jose na taga-Arimatea na ipakuha sa iya an lawas ni Jesus agod ilubong. Ini si Jose disipulos man ni Jesus ugaling sikreto lang kay nahahadlok siya sa mga namumuno san mga Judio. Tinugutan siya ni Pilato kaya nagkadto kag kinuha an lawas. ");
INSERT INTO msb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","May nag-upod man kan Jose na amo si Nicodemo. Ini siya an nagbisita kasadto kan Jesus sa gab-i. Nagdara siya sin pahumot na mira na may sakot na duga san tanom na aloe, mga 33 kilos an kabug-at. ");
INSERT INTO msb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kaya pinutos ninda an lawas ni Jesus sa tela na lino kaupod sani na mga pahumot susog sa kaugalian san paglubong san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Niyan, igwa sin hardin didto sa lugar na ginpakuan kan Jesus. Sani na hardin igwa sin bag-o na lubungan na kweba na wara pa malubngi. ");
INSERT INTO msb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Didto ninda ginlubong si Jesus kay halapit lang ini kag sadto adlaw san Pagpreparar para sa Paskwa san mga Judio. ");
INSERT INTO msb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Maaga pa san primero na adlaw san semana nagkadto si Maria Magdalena sa ginlubngan kan Jesus. Pag-abot didto nakita niya na nahali na an bato na nakasira sa lubungan. ");
INSERT INTO msb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kaya pakakita niya nagdalagan siya diretso pakadto kan Simon Pedro kag sa disipulos na palangga ni Jesus. Pag-abot naman didto nagsumat siya, “Kinuha ninda an lawas san Ginoo sa lubungan kag dili namon aram kun diin ini ginbutang.” ");
INSERT INTO msb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kaya pakabarita nagluwas man dayon sinda Pedro kag sani na disipulos tapos nagpakadto sa lubungan. ");
INSERT INTO msb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Sabay sinda na nagdalagan pero matulin dumalagan an disipulos ki kan Pedro kaya una nakaabot sa lubungan. ");
INSERT INTO msb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pakadung-aw didto nakita an ginputos na mga tela na lino pero wara siya magsulod. ");
INSERT INTO msb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nag-abot kasunod niya si Simon Pedro, nagsulod dayon sa lubungan kag nakita an tela na lino didto kag ");
INSERT INTO msb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","amo man an tela na gintahob sa ulo ni Jesus. Dili ini kaupod san ginputos na tela na lino kundi nalulukot man ini na bulag sa mga iba. ");
INSERT INTO msb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tapos nagsulod man an disipulos na nauna pag-abot sa lubungan. Nakita niya kaya nagtuod siya. ");
INSERT INTO msb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero apisar sana dili pa ninda masabutan an ginsurat sa Kasuratan na dapat si Jesus mabuhay gihapon. ");
INSERT INTO msb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pakakita na ninda san tanan nag-uruli na. ");
INSERT INTO msb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pag-uruli san mga disipulos nagpabilin si Maria na nagatangis sa luwas san lubungan. Myintras nagatangis nagdung-aw siya agod makita man an nasa sulod. ");
INSERT INTO msb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nakakita siya sin duha na anghel na nakabadoʼn puti na nagaingkod sa may ginhulidan san lawas ni Jesus. Sa may uluhan an usad kag an usad naman sa may tiilan. ");
INSERT INTO msb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ginhunga ninda an babayi, “Nano kay nagatangis ka?” An sabat niya, “May nagkuha san lawas san akon Ginoo kag dili ko aram kun diin ninda ginbutang.” ");
INSERT INTO msb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pakasabi niya sani, naglingi siya palikod kag nakita si Jesus na nagatindog didto pero wara niya siya makilala. ");
INSERT INTO msb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ginhunga siya ni Jesus. “Nano kay nagatangis ka? Sin-o an ginahanap mo?” Sa paghuna niya na si Jesus amo an nagaataman sadto na hardin kaya nagsabat siya, “Tio, kun ikaw an nagkuha sa iya itukdo sa akon kun diin mo ginbutang kay kukuhaon ko siya.” ");
INSERT INTO msb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ginsabihan siya ni Jesus, “Maria.” Nag-atubang dayon si Maria kag nagsabi sa Hebreo, “Raboni!” (na gusto sabihon Maestro). ");
INSERT INTO msb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ginpadaanan siya ni Jesus, “Ayaw pagkapot sa akon kay wara pa ako magsaka pakadto sa Ama kundi kadto sa akon mga kamaranghod kag sabiha na magasaka na ako pakadto sa iya na akon Ama kag Dios man. Siya man an inda Ama kag Dios.” ");
INSERT INTO msb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tapos nagbalik si Maria Magdalena kag ginsumat sa mga disipulos na nakita niya an Ginoo amo man an ginpasabi ni Jesus sa iya. ");
INSERT INTO msb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pagkagab-i sadto na primero na adlaw san semana, nagtiripon an mga disipulos kag trangkado gayod an mga pwertahan san balay kay nahadlok sinda sa mga namumuno san mga Judio. Didi nag-abot si Jesus kag nagtindog sa tunga ninda na nagasabi, “An kalinawan hali sa Dios mapasa iyo.” ");
INSERT INTO msb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pakasabi niya sani ginpakita sa inda an iya mga kamot kag san iya kilid. Kaya nalipay gayod an mga disipulos pakakita ninda sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tapos ginsabihan gihapon sinda ni Jesus, “An kalinawan hali sa Dios mapasa iyo. Ginasugo ta kamo pareho san pagsugo sa akon san Ama.” ");
INSERT INTO msb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pakasabi naman niya sani ginhangusan niya sinda kag nagsabi: “Batuna niyo an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","An kanin-o man mga kasal-an na iyo patawadon mapapatawad kag an kanin-o man mga kasal-an na dili niyo patawadon dili mapapatawad.” ");
INSERT INTO msb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Si Tomas na ginatawag na Kapid, usad man san Dose, dili kaupod sanmga disipulos san nagpakita si Jesus sa inda. ");
INSERT INTO msb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kaya ginsumatan siya san iba na mga disipulos, “Nakita namon an Ginoo.” Pero nagsabat siya, “Kun dili ko makita an luho na inagihan san pako sa iya mga kamot tapos ikasulod an akon tudlo kag amo man sa iya samad sa kilid, dili ako matuod.” ");
INSERT INTO msb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pagkaotro Domingo naman, adto gihapon an mga disipulos sa balay kag niyan kaupod na ninda si Tomas. Trangkado an mga pwertahan pero nagsulod si Jesus kag nagtindog sa tunga ninda. “An kalinawan hali sa Dios mapasa iyo,” an sabi niya sa inda. ");
INSERT INTO msb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pakatapos, nagsabi siya kan Tomas, “Kitaa an akon mga kamot. Ibutang didi an imo tudlo. Ikab-ot an imo kamot kag isulod sa akon kilid. Ayaw pagduha-duha kundi magtuod ka.” ");
INSERT INTO msb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nagsabat si Tomas, “Ikaw an Ginoo ko kag Dios ko man!” ");
INSERT INTO msb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ginhunga naman siya ni Jesus, “Nano, nagatuod ka kay nakita mo ako? Malipay idtoʼn nagatuod bisan wara nakakita.” ");
INSERT INTO msb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Niyan sa pagkabuhay ni Jesus damo na iba na mga milagro an hinimo niya sa atubangan san mga disipulos na dili nasurat sani na libro. ");
INSERT INTO msb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ugaling, ginsurat ini agod magtuod kamo na si Jesus amo an ginatawag Cristo na Anak san Dios kag sa pagsarig sa iya magkakaigwa kamoʼn buhay na hasta na lang paagi sa pakig-usad sa iya. ");
INSERT INTO msb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pakatapos sani, nagpakita gihapon si Jesus sa mga disipulos didto sa higad san Danaw san Tiberias kag amo ini an nangyari. ");
INSERT INTO msb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nag-urupod sinda Simon Pedro, Tomas na ginatawag na Kapid, Nataniel na taga-Cana sa Galilea, an mga anak ni Zebedeo kag san duha pa san iya mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ginsabihan sinda ni Simon Pedro, “Mapangisda ako.” Nagsarabat sinda, “Maupod man kami.” Kaya nagpadanaw sinda kag nagsakay sa dako na baruto pero wara gayod sinda sin makuha na isda sadto na gab-i. ");
INSERT INTO msb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sadto pagbitlak pa lang san adlaw, adto na didto si Jesus nagatindog sa baybayon pero wara siya makilala san mga disipulos. ");
INSERT INTO msb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ginhunga sinda ni Jesus, “Mga amigo, nano, may nakuha kamo na isda?” Nagsabat sinda, “Wara gayod.” ");
INSERT INTO msb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ginsabihan niya sinda, “Ihulog niyo an lambat sa banda tuo san sakayan kay makakuha kamo.” Kaya hinulog ninda an lambat. Pakatapos haros dili na ninda mabatak paibabaw an lambat tungod sa kadamuan san isda. ");
INSERT INTO msb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tapos nagsabi kan Pedro an disipulos na palangga ni Jesus, “An Ginoo ina.” Pakabati ni Simon Pedro na an Ginoo idto, ginsul-ot dayon an iya halaba na bado kay gintangkas niya ini, tapos lumangoy pabaybay. ");
INSERT INTO msb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pero an iba na mga disipulos nagpahubasan na guyod an lambat na puno sin isda kay halapit lang sinda sa baybayon, mga syin metro lang an kaharayo. ");
INSERT INTO msb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagsalta ninda sa baybayon, nakita ninda na igwaʼn tinapay kag may baga san uring na may mga ginaihaw na isda. ");
INSERT INTO msb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ginsugo sinda ni Jesus, “Pagdara kamoʼn isda na nakuha pa lang niyo.” ");
INSERT INTO msb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kaya nagsakay si Simon Pedro sa sakayan kag ginuyod an lambat pabaybayon na puno sin daragko na isda, mga 153 bilog idto. Bisan sugad sadto kadamo an mga isda pero wara magisi an lambat. ");
INSERT INTO msb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Gin-agda sinda ni Jesus, “Kadi na kamo, mamahaw na kita.” Wara na sin nagkusug-kusugan sin buot na maghunga kun sin-o siya kay aram ninda na siya an Ginoo. ");
INSERT INTO msb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Naghalapit si Jesus, kinuha an tinapay kag ginpanghatag sa inda kag amo man an isda. ");
INSERT INTO msb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ikatulo na beses ini na paghayag ni Jesus sa mga disipulos pagkabuhay niya gihapon. ");
INSERT INTO msb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pakakaon ginhunga ni Jesus si Simon Pedro, “Simon, anak ni Juan, nano, namumuot ka sa akon mas labaw pa saniʼn iba?” Nagsabat siya, “Opo, Ginoo, aram mo na namumut-an ta ikaw.” Ginsabihan siya ni Jesus, “Atamana an akon katawuhan pareho san pastor na ginapahurab an mga kordero.” ");
INSERT INTO msb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sa gihapon ginhunga siya ni Jesus, “Simon, anak ni Juan, nano, namumuot ka sa akon?” Nagsabat siya, “Opo, Ginoo, aram mo na namumut-an ta ikaw.” Ginsabihan siya ni Jesus, “Atamana an akon katawuhan pareho san pastor na ginaataman an mga karnero.” ");
INSERT INTO msb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ginhunga gihapon siya ni Jesus sa ikatulo na beses, “Simon, anak ni Juan, nano, namumuot ka sa akon?” Nagmundo si Pedro kay ginhunga siya niya sin makatulo na “Nano, namumuot ka sa akon,” kaya nagsabi, “Ginoo, naaaraman mo an tanan. Aram mo na namumuot ako sa imo.” Ginsabihan siya ni Jesus, “Atamana an akon katawuhan pareho san pastor na ginapahurab an mga karnero. ");
INSERT INTO msb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Matuod gayod na san batan-on ka pa, ikaw mismo an nagasul-ot sa sadiri mo kag nagalakat kun diin mo gusto pero paggurang mo, uunaton mo na lang an imo mga kamot kag iba na an magasul-ot sa imo tapos papakadtuon ka sa dili mo gusto.” ");
INSERT INTO msb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ginsabi ini ni Jesus agod ipasabot niya kun pan-o mamamatay si Pedro kag paagi sana ikapagalang an Dios. Pakatapos sani ginsabihan niya si Pedro, “Sundon mo ako.” ");
INSERT INTO msb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","San naglingi si Pedro nakita niya an disipulos na palangga ni Jesus na nagasunod sa inda. Siya idtoʼn nagsandig sa dughan ni Jesus san nagapanigab-i sinda kag naghunga, “Ginoo, sin-o an matraydor sa imo?” ");
INSERT INTO msb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Niyan pakakita sa iya ginhunga ni Pedro si Jesus, “Ginoo, saka ini siya?” ");
INSERT INTO msb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nagsabat si Jesus, “Kun gustuhon ko na mabuhay siya hasta na magbalik ako, nano man an labot mo? Magsunod ka sa akon.” ");
INSERT INTO msb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tungod sani nakalukop an barita sa mga sumurunod ni Jesus na dili mamamatay ini na disipulos. Pero wara ginsabi ni Jesus kan Pedro na dili mamamatay ini na disipulos kundi nagsabi, “Kun gustuhon ko na mabuhay siya hasta sa pagbalik ko, nano man an labot mo?” ");
INSERT INTO msb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Amo ini an disipulos na nagatestigo sani tanan kag sinurat man niya ini. Niyan aram namon na matuod an iya pagtestigo. ");
INSERT INTO msb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Damo pa an mga ginhimo ni Jesus. Kun masurat an tanan, sa paghuna ko, dili makaigo sa kinab-an an tanan na mga libro na masuratan sani.");
INSERT INTO msb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pinalangga na Teofilo: Ginsurat ko kasadto sa akon una na libro an manungod sa gintunaan paghimua kag pagtukdo ni Jesus, ");
INSERT INTO msb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta sa adlaw na gindara siya palangit. Nangyari ini pakatuguna niya paagi sa gahom san Espirito Santo sa mga apostoles na pinili niya. ");
INSERT INTO msb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa sulod san 40 ka adlaw pagkapatay niya, nagpakita siya sa inda kag nagpamatuod naman na buhay siya sa damo na mga paagi. Sani nagsurmaton man siya manungod sa kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Myintras nakig-upod pa siya sa inda ginsugo niya, “Ayaw kamo pagharali sa Jerusalem kundi maghulat san gintuga san Ama na ginsabi ko sa iyo kasadto. ");
INSERT INTO msb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Matuod na nagpambunyag si Juan sin tubig pero sa dili madugay pagabunyagan kamo paagi san Espirito Santo.” ");
INSERT INTO msb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Niyan, san magtiripon an mga apostoles kaupod ni Jesus, naghunga sinda sa iya, “Ginoo, nano, ini an panahon na hihimuon mo naman gihapon an kahadian san Israel?” ");
INSERT INTO msb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nagsabat si Jesus sa inda, “Wara kamoʼn labot na maaraman an oras o panahon na ginbutang san Ama paagi san iya mismo poder. ");
INSERT INTO msb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero pag-abot sa iyo san Espirito Santo, may mababaton kamo na poder, tapos, magigin testigos ko kamo sa mga taga-Jerusalem, mga taga-Judea, mga taga-Samaria kag sa tanan na katawuhan sa kinab-an.” ");
INSERT INTO msb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pakasabi sani, ginpahitaas siya palangit kag natahuban san dampog myintras nagakita sinda. ");
INSERT INTO msb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","San nagatururok pa man sinda palangit, bigla na lang may nagtindog sa katakin ninda na duha na lalaki na nakabisti sin puti. ");
INSERT INTO msb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tapos, naghunga, “Mga taga-Galilea, nano kay nagatirindog kamo didi kag nagaharangad-hangad sa langit? Ini na Jesus na ginkuha na sa iyo pakadto sa langit magabalik sa pareho man na paagi san makita niyo siya na nagpakadto sa langit.” ");
INSERT INTO msb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nagbalik an mga apostoles pakadto sa Jerusalem hali sa ginatawag na Bukid san Kaolibohan na halapit sa syudad, mga usad ka kilometro an kaharayo. ");
INSERT INTO msb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","San pagsulod ninda sa Jerusalem, nagsaka sa kwarto kun diin sinda nagaistar. Ini amo sinda Pedro, Juan, Santiago kag Andres, Felipe, Tomas, Bartolome kag Mateo, Santiago na anak ni Alfeo, Simon na panatiko kag si Judas na anak ni Santiago. ");
INSERT INTO msb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pirme sinda nagatiripon para magpangadyi kaupod man an kababayihan kag si Maria na iloy ni Jesus, amo man an iya mga kamaranghod na lalaki. ");
INSERT INTO msb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mga pira-pira ka adlaw nagkaigwa sinda sin pagtiripon. Mga 120 sinda tanan. Didi nagtindog si Pedro kag nagsabi, ");
INSERT INTO msb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga kaigmanghudan, dapat matuman an kasuratan na ginsurmaton kasadto pa san Espirito Santo paagi san kasadto na hadi na si David manungod kan Judas na amo an naggiya sadtoʼn mga nag-arestar kan Jesus. ");
INSERT INTO msb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Judas kagrupo naton kay ginpili man siya na makibahin san aton trabaho. ");
INSERT INTO msb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Niyan tungod sa kwarta na nabaton ni Judas sa paghimo sin maraot, nagbakal siya sin duta. Didi mismo siya nagbigti na una an ulo, kaya bumuskad an katunga san iya lawas kag lumuwas an tanan niya na mga bituka. ");
INSERT INTO msb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nabaritaan ini na nangyari san tanan na taga-Jerusalem, kaya ginatawag ninda ini sa inda sadiri na surmaton na Akeldama na an gusto sabihon ‘Uma san Dugo.’,” ");
INSERT INTO msb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nagsabi pa si Pedro, “Sugad sani an nasurat sa libro san Salmo, ‘Pabayai an istaran niya kag dili magtugot na may mag-istar didto bisan kanin-o man.’ Nasurat man na, ‘Pasublian sa iba an iya trabaho.’ ");
INSERT INTO msb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kaya, dapat may iba na makaintra sa aton na magtestigos sa pagkabuhay gihapon san Ginoo na si Jesus. Kinahanglan usad siya sa aton grupo san panahon na kaupod ta pa si Jesus magtuna san si Juan nagapambunyag hasta sa adlaw na si Jesus ginpaitaas palangit.” ");
INSERT INTO msb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kaya may duha sinda na ginpapilian: si Matias kag si Jose na ginatawag Barsabas na ginatawag man Justo. ");
INSERT INTO msb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tapos, nangadyi sinda, “Ginoo, ikaw an nakaaram san tagipusuon san tanan na katawuhan, kaya ipakita sa amon kun sin-o sani na duha an imo pinili ");
INSERT INTO msb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na magsubli sani na trabaho na pagkaapostol na ginbayaan ni Judas para magkadto sa lugar na angay sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Didi ginripa ninda an pagpili sani na duha. Si Matias an napili. Kaya siya an gindugang sa grupo san onse na mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pag-abot san adlaw na ginatawag Pentecostes, nagtiripon an tanan na nagaturuod. ");
INSERT INTO msb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bigla na lang may tunog na hali sa langit bagaʼn hagunos san makusog na hangin na nagsulod sa bilog na balay kun diin sinda nagairingkod. ");
INSERT INTO msb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tapos, may nakita sinda na bagaʼn mga dila san kalayo na nagburulag-bulag kag nagtungtong sa may ulo san kada usad. ");
INSERT INTO msb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","An katapusan sani, nagin puno sinda tanan san Espirito Santo, tapos nagtuna pagsurmaton sin manlain-lain na lenggwahi susog sa ginapasurmaton sa inda san Espirito. ");
INSERT INTO msb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Niyan, may nagaistar sa Jerusalem na mga Judio hali sa kada usad na nasyon san kinab-an na matinumanon gayod sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pakabati ninda sani na tunog, nagtiripon sinda na kadamuan sa mga nagatuod. Tapos, nangawa gayod kay an kada usad nakabati sa inda sadiri na lenggwahi san ginasurmaton sana na mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa pagkangawa ninda nakahunga, “Nano, dili ini na mga nagasurmaton taga-Galilea? ");
INSERT INTO msb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kaya, nano kay an aton mga sadiri na surmaton an nababatian ta sa inda? ");
INSERT INTO msb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kitaa, mga taga-Partia kita, taga-Media, taga-Elam, mga nagaistar sa Mesopotamia, Judea kag sa Capadocia. Mga hali sa Ponto kag Asia, ");
INSERT INTO msb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","sa Frigia kag Panfilia, Ehipto kag sa parte san Libya na apiki na sa Cirene, bisan mga bisita hali sa Roma, ");
INSERT INTO msb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","pareho Judio kag dili-Judio na nadara sa pagka-Judaismo. Amo man mga taga-Creta kag Arabia, pero nabati naton tanan na nagasurmaton sinda sa aton mga sadiri na lenggwahi manungod sa mga makangangalas na ginhimo san Dios.” ");
INSERT INTO msb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","An tanan nagkangarawa kag nagkabururong na nagapahurunga-hunga kun nano an gusto sabihon sani. ");
INSERT INTO msb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero an iba naman patuya na nagsabi, “Mga hubog lang ini sinda.” ");
INSERT INTO msb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Didi, nagtindog si Pedro kaupod an onse na mga apostoles kag nagsurmaton sin makusog sa mga tawo, “Kapareho ko na mga Judio kag mga nagairistar sa Jerusalem, mamati kamo sa akon kag tuguti man ako magpahayag kun nano an gusto sabihon sani. ");
INSERT INTO msb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dili mga hubog ini na mga tawo susog sa iyo paghuna kay alas nuebe pa lang san aga, ");
INSERT INTO msb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","kundi amo ini an ginsabi kasadto san Propeta na si Joel, ");
INSERT INTO msb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nagsabi an Dios, Amo ini an hihimuon ko sa mga urhi na adlaw san kinaban. Papakadaon ko an akon Espirito sa tanan na mga katawuhan. Kaya, an iyo mga anak na lalaki kag mga babayi magasurmaton san ipapasabi sa inda san Espirito Santo. Makakita sin mga pangitaon an mga batan-on na mga lalaki, kag an iyo naman mga kagurangan may mga pangitaon man paagi sa mga damgo. ");
INSERT INTO msb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oo, bisan ngani an akon mga uripon, pareho lalaki kag babayi, papakadaon ko man an akon Espirito sa inda kag magasurmaton man sinda san ipapasabi sa inda san Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Magapakita ako sin mga milagro sa kalangitan, kag sa kinab-an sin mga makangangalas na may dugo o kalayo kag madakmol na aso. ");
INSERT INTO msb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Magadulom an adlaw kag magapula an bulan bagaʼn dugo. Ini tanan antes mag-abot an dako kag gloryoso na adlaw san Dios. ");
INSERT INTO msb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tapos, an tanan na magatawag sa Dios masasalbar.’ ");
INSERT INTO msb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mga Israelita, pamatii niyo ini na mga surmaton: si Jesus na taga-Nazaret an ginsugo san Dios. Ginapamatuudan ini san mga milagro, makangangalas kag tanda na ginhimo san Dios paagi sa iya na aram na niyo kay an tanan nangyari sa iyo atubangan. ");
INSERT INTO msb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tapos, gin-intriga siya sa iyo susog sa sadiri na kabubut-on kag pagkaaram na san Dios, tapos, ginpapako niyo sa krus kag ginpapatay sa pagbulig san mga makasal-anon na mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ugaling ginbuhay gihapon siya san Dios kag ginlibre hali sa sakit san kamatayon kay ini dili gayod makapugol sa iya. ");
INSERT INTO msb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nagsabi ngani si David manungod sa iya, ‘Nakita ko an Ginoo pirme sa atubangan ko kag adi siya sa akon tuo agod dili ako mahandal. ");
INSERT INTO msb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kaya dahilan sani nalipay gayod ako. Nagsiyak ako sa paglipay, kag bisan may kamatayon may paglaom gayod, ");
INSERT INTO msb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kay dili mo papabay-an an akon kalag sa lugar san mga patay, kag dili mo man pagatugutan na magdunot an imo banal na suruguon. ");
INSERT INTO msb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ginpakita mo sa akon an paagi san pagkabuhay gihapon, kag ginakalipay ko an imo pakiupod sa akon.’ ");
INSERT INTO msb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga kaigmanghudan, aram gayod niyo na namatay na an aton kalulululuhi na si David, tapos ginlubong kag an iya lubungan adi pa sa aton hasta yana. ");
INSERT INTO msb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Propeta man siya kaya aram niya an tuga san Dios na may sumpa sa iya na may hihimuon na hadi sa lahi niya. ");
INSERT INTO msb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Naaraman man niya an hihimuon san Dios kaya nagsurmaton siya manungod sa pagkabuhay gihapon san Cristo na wara ini pabayai sa lugar san mga patay kag dili magdunot an iya lawas. ");
INSERT INTO msb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Niyan, ini na Cristo si Jesus na ginbuhay gihapon san Dios hali sa kamatayon kag mga testigos sani kami tanan. ");
INSERT INTO msb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","San ginpahataas siya sa pwesto na pinakaimportante sa tuo san Dios, ginbaton niya sa iya an gintuga na Espirito Santo. Niyan, hali sani na Espirito ginhatag naman niya sa amon an ginakita kag ginabati niyo yana. ");
INSERT INTO msb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pero si David dili nagasabi manungod sa iya sadiri kay wara siya mismo nagkadto sa langit, kundi amo ini an sabi niya, ‘Nagsabi an Ginoo sa akon Ginoo, Mag-ingkod ka sa may tuo ko hasta na himuon ko ");
INSERT INTO msb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","na tungtungan san imo mga tiil an mga kaaway mo.’ ");
INSERT INTO msb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kaya kita tanan na mga taga-Israel makaaram na may kasiguruhan na ini si Jesus na ginpako niyo sa krus ginbutang san Dios bilang Ginoo kag Cristo!” ");
INSERT INTO msb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pakabati ninda sani, nakonsensya gayod sinda, kaya naghunga kan Pedro kag sa iba na mga apostoles, “Mga kaigmanghudan, nano an dapat namon himuon?” ");
INSERT INTO msb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nagsabat si Pedro, “Magbasol kamo kag magbaya sa iyo mga kasal-an kag magpabunyag sa ngaran ni Jesu-Cristo para sa kapatawadan san iyo mga sala, tapos makabaton kamo san Espirito Santo na amo an regalo san Dios. ");
INSERT INTO msb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ini an tuga niya para sa iyo, sa iyo mga kaanakan kag sa tanan na mga ada sa harayo na amo an tanan na tatawagon san Ginoo na aton Dios para sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kaya, ginpadaanan pa sinda ni Pedro paagi san damo pa na surmaton, kag naghangyo siya, “Isalbar an iyo sadiri sa pagkondinar na maabot sani na mga maraot na mga tawo na nabubuhay yana!” ");
INSERT INTO msb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tapos, nabunyagan an mga nagtuod san iya pagpahayag. Kaya mga tres mil na tawo an nakadagdag sa inda pag-ururupod sadtoʼn adlaw. ");
INSERT INTO msb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Adlaw-adlaw ada sinda sa pagtiripon kaupod san mga iba na nagatuod padayon sa pag-aram san katukduan san mga apostoles, nakibahin sa pagpihak-pihak san tinapay sa pagdumdom sa Ginoo kag sa pagpangadyi. ");
INSERT INTO msb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Didi sani na panahon damo man na mga milagro kag makagagahom na mga himo an nahimo paagi sa mga apostoles, kaya nagkangaralas naman gayod an mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","An tanan naman na mga nagturuod nabubuhay sa pag-ururupod kag nakibahin san inda mga kasadirihan sa kada usad. ");
INSERT INTO msb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Halimbawa, ginabaligya ninda an mga kadutaan kag kasadirihan, tapos ginabarahin-bahin an kabaklanan sa mga iba susog sa inda mga kinahanglan. ");
INSERT INTO msb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nagpadayon man sinda pagtiripon bilang grupo uruadlaw sa templo, tapos sa inda mga balay nagpirihak-pihak san tinapay sa pagdumdom san Ginoo sa pagsamba kag nagkaraon na malipay kag mapainubuson an inda mga tagipusuon. ");
INSERT INTO msb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kaya, uruadlaw nagaumaw sinda sa Dios kag ginagalangan san tanan na tawo. Uruadlaw man an mga ginasalbar ginadugang san Ginoo sa inda grupo. ");
INSERT INTO msb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Niyan, mga alas tres na san hapon, oras san pagpangadyi, nagakadto sinda Pedro kag Juan sa templo. ");
INSERT INTO msb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Didto sa may pwertahan san ginatawag na “Pwertahan Na Matahom”, may pilay na lalaki tuna pa san gin-anak. Ginadara siya didto uruadlaw para magpalimos sa mga nagasulod sa templo. ");
INSERT INTO msb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","San makita niya sinda Pedro kag Juan na magasulod sa templo, nagsabi siya, “Sir, makilimos!” ");
INSERT INTO msb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ginturok ninda siya tapos nagsabi si Pedro, “Magkita ka sa amon!” ");
INSERT INTO msb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kaya nagkita man siya sa inda kay nagalaom na makabaton sin nano man. ");
INSERT INTO msb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Didi nagsabi si Pedro, “Wara akoʼn kwarta, pero an adi sa akon ihahatag ko sa imo. Paagi sa poder na ginhatag sa akon ni Jesu-Cristo na taga-Nazaret, nagasugo ako sa imo na tumindog kag maglakat!” ");
INSERT INTO msb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ginhawidan ni Pedro sa tuo na kamot kag ginbuligan niya pagtindog. Sana mismo nagbaskog an tiil san tawo kag bukun-bukunan. ");
INSERT INTO msb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Naglukso siya kag nagtuna na paglakat. Tapos, kaupod ninda nagsulod siya sa templo na nagalakat, nagalukso kag nagaumaw sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nakita siya san tanan na mga katawuhan myintras nagalakat kag nagaumaw siya sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","San makilala ninda siya na amo an makililimos na nagaparaingkod sa may ginatawag Pwertahan Na Matahom san templo para magpalimos, nagkangarawa kag nangarat sinda sa nangyari sa iya. ");
INSERT INTO msb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Myintras nakahuyot an dati pilay kanda Pedro kag Juan sa parte san templo na ginatawag Portico Ni Solomon, nagdaralagan pahalapit sa inda an mga tawo na nangawa sa nangyari. ");
INSERT INTO msb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pakakita ni Pedro sa kadamuan, nagsurmaton siya sa inda, “Mga katawuhan san Israel, nano kay nangawa kamo sani? Nano kay nagaturok kamo sa amon na bagaʼn sa paghuna niyo nakalakat siya paagi sa amon gahom o pagkadiosnon? ");
INSERT INTO msb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","An Dios ninda Abraham, Isaac, Jacob, kag san aton iba na mga kalulululuhan amo an naghatag sa iya suruguon na si Jesus sin pwesto kaupod niya sa kalangitan. Siya an gin-intriga niyo kag ginsikway sa atubangan ni Pilato san gin-isipan pa sani na buhian siya. ");
INSERT INTO msb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Oo, matuod na ginsikway man gayod niyo siya na banal kag matanos kundi gin-ayo lugod niyo kan Pilato na magbuhi sin nagpatay sin tawo. ");
INSERT INTO msb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tapos ginpapatay niyo an gintunaan san buhay na waraʼn katapusan, pero ginbuhay siya gihapon san Dios hali sa mga patay kag mga testigos kami manungod sani. ");
INSERT INTO msb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Niyan an gahom san iya ngaran amo an naghatag sin kabaskog sani na pilay na tawo. Ini na nakita kag naaraman niyo naayo paagi sa pagsarig kan Jesus. An pagsarig sa iya amo an nakaayo sani na tawo kag nakikita na niyo tanan. ");
INSERT INTO msb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mga kaigmanghudan, aram ko na idto an nahimo niyo kag san iyo mga namumuno sa kan Jesus kay dili niyo siya kilala. ");
INSERT INTO msb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero paagi sani gintuman san Dios an pagpaaram niya paagi sa tanan niya na mga propeta kasadto na an iya Cristo magatios. ");
INSERT INTO msb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kaya, magbasol kamo kag magbaya san pagkasala tapos magbalik sa pagsunod sa Dios agod halion niya an iyo mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tapos, kun himuon niyo ini, may panahon lugod kamo san pagpahuway hali sa iya kag papakadion niya sa iyo an Cristo na si Jesus na ginpili na niya bilang iyo parasalbar. ");
INSERT INTO msb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kinahanglan na magpirme siya sa langit hasta na mag-abot an panahon na mabag-o an tanan susog sa gintuga san Dios kasadto pa paagi sa iya mga banal na propeta. ");
INSERT INTO msb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Basi nadumduman niyo an pagsabi ni Moises kasadto sugad sani, ‘An Ginoo na iyo Dios magapakada sa iyo sin propeta na kalahi niyo pareho na ginpakadi niya ako. Dapat niyo sunudon an tanan na sasabihon niya sa iyo. ");
INSERT INTO msb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","An dili magpamati san sasabihon sana na propeta ibubulag sa mga katawuhan san Dios kag pagasiraon.’ ");
INSERT INTO msb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Oo, manungod sani na mga adlaw ginsumat man kasadto san tanan na propeta na nagsurmaton tuna kan Samuel hasta sa mga nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Niyan, para sa iyo naman an mga gintuga san Dios na ginsumat kasadto san mga propeta kag iredero man kamo san sinumpaan san Dios na ginhatag sa iyo mga kalulululuhan san sabihon niya kan Abraham, ‘Paagi sa imo mga lahi pagabendisyunan an tanan na mga katawuhan sa kinab-an.’ ");
INSERT INTO msb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kaya san ginpili san Dios an iya suruguon, ginsugo anay siya sa iyo para bendisyunan kamo paagi sa pagpabaya san kada usad sa iyo sa maraot niyo na mga himo.” ");
INSERT INTO msb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Myintras nagasurmaton pa sinda Pedro kag Juan sa mga tawo, nag-abot an mga kapadian, mga Saduceo kag san namumuno san mga bantay sa templo. ");
INSERT INTO msb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Burubadli sinda sa duha na apostoles kay nagapangtukdo ini sa mga tawo na kay nabuhay gihapon si Jesus nagapamatuod naman ini na may pagkabuhay an mga patay. ");
INSERT INTO msb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kaya gindakop ninda sinda na duha kag ginpriso paaga kay gab-i na sadto. ");
INSERT INTO msb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero nagturuod an kadamuan na nakabati sadtoʼn pagpahayag, kaya nag-abot sa mga 5,000 an kadamo san mga lalaki na nagaturuod. ");
INSERT INTO msb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagkaaga sadto, nagkatiripon sa Jerusalem an mga namumuno san mga kapadian, mga myimbro san konseho kag mga paratukdo sa Kasuguan. ");
INSERT INTO msb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kaupod man ninda si Anas na pinakanamumuno san mga kapadian, sinda Caifas, Juan, Alejandro kag san mga lalaki san pamilya san pinakanamumuno san mga kapadian. ");
INSERT INTO msb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pakapatinduga ninda sa mga apostoles sa inda atubangan, ginhunga, “Kanin-o gahom o ngaran an iyo ginamit paghimo sani?” ");
INSERT INTO msb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tapos, nagsabat si Pedro na nasa gahom san Espirito Santo: “Mga namumuno san mga tawo kag mga kagurangan naton na mga Judio, ");
INSERT INTO msb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kun ginahunga niyo kami niyan manungod sa maayo na ginhimo sani na pilay, kag kun nano an paagi na napaayo siya, ");
INSERT INTO msb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dapat maaraman niyo kag san tanan na taga-Israel na nakatindog na ini na tawo sa iyo atubangan na maayo na paagi sa poder san ngaran ni Jesu-Cristo na taga-Nazaret. Siya an iyo ginpapako sa krus kag ginbuhay gihapon san Dios. ");
INSERT INTO msb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ini si Jesus an ginasabi sa Banal Na Kasuratan na, ‘An bato na ginsikway niyo na mga panday nahimo lugod na pinakamahalaga na bato para sa balay.’ ");
INSERT INTO msb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ada lang kan Jesu-Cristo makikita an pagkasalbar kay sa bilog na kinab-an wara na sin iba pa na ginpili san Dios sa mga tawo agod kita malibre sa iya kastigo.” ");
INSERT INTO msb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nangawa an mga myimbro san konseho sa kaisog na ginpakita ninda Pedro kag Juan, lalo na san maaraman ninda na mga tawo lang sinda na waraʼn inadalan. Kaya nakilala ninda na ini sinda kaupod kasadto ni Jesus. ");
INSERT INTO msb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pakakita naman ninda na an tawo na napaayo nagatindog kaupod ninda Pedro kag Juan, wara sinda sin masabi kontra sani. ");
INSERT INTO msb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ginpaluwas anay ninda an apostoles sa konseho, tapos, nagsururmaton na sinda lang. ");
INSERT INTO msb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nano an himuon ta sani na mga tawo kay hayag na sa bilog na Jerusalem an milagro na inda ginhimo kag dili kita makapaambot sani? ");
INSERT INTO msb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero agod dili na ini makaabot pa sa iba na mga tawo, paaramon ta sinda na dili gayod na magsurmaton sa iba manungod sani na ngaran ni Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kaya ginpatawag gihapon sinda Pedro kag ginpadaanan, “Ayaw kamo pagsurmaton kag pagtukdo pa sa ngaran ni Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero nagsabat sinda Pedro kag Juan, “Kamo na an magpili kun hain an tama sa mata san Dios: an pagsunod sa iya o sa iyo, ");
INSERT INTO msb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","kay dilinamon pwede udungon an pagsurmaton san amon nakita kag nabatian.” ");
INSERT INTO msb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kaya ginpadaanan gayod sinda antes ginpaluwas. An mga namumuno naman waraʼn paagi na pagakastiguhon sinda kay nahahadlok sa mga katawuhan na nagaumaw sa Dios tungod sa nangyari. ");
INSERT INTO msb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Usad pa, sobra na sa 40 ka tuig an edad san lalaki na nag-ayo. ");
INSERT INTO msb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","San ginpaluwas na sinda Pedro kag Juan, nagkadto sinda sa inda mga kaurupod, tapos ginbarita an ginsabi san namumuno san mga kapadian kag san iba na mga namumuno san mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pakabati ninda, nagdurungan sinda pagpangadyi sa Dios, “Pinakamakagagahom na Dios, ikaw an naglalang san langit, duta, dagat kag tanan na adi sani na kinab-an. ");
INSERT INTO msb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","San magsurmaton ka paagi san amon kalulululuhan na si David na imo suruguon na gin-giyahan san Espirito Santo, nagsabi ka, ‘Nano kay naurit gayod an mga dili-Judio, kag nagplano sin waraʼn pulos an mga tawo? ");
INSERT INTO msb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nagahanda sa pakig-ato an mga hadi sa kinab-an, kag nagatiripon man an mga namumuno kontra sa Ginoo kag sa iya Mesias.’ ");
INSERT INTO msb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Matuod ini kay nagkauyon man gayod sani mismo na syudad sinda Herodes kag Poncio Pilato kaupod an mga dili-Judio kag san katawuhan san Israel kontra sa imo banal na suruguon na si Jesus na ginbutang mo na Mesias. ");
INSERT INTO msb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nagtiripon sinda agod maghimo san ginplano mo kasadto na dapat mangyari susog sa imo kabubut-on kag poder. ");
INSERT INTO msb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kaya, Ginoo, pamatii an inda mga paghulga kag tuguti kami na mga suruguon mo na magsurmaton san imo mensahe na may kaisog san buot. ");
INSERT INTO msb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iabot mo an imo gahom sa pagpaayo kag itugot na may mga makangangalas kag mga milagro na himuon sa ngaran san imo banal na suruguon na si Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pakapangadyi ninda, nayugyog an lugar na ginatiripunan ninda. Tapos, napuno sinda tanan san Espirito Santo kag nagkaigwa sin kaisog san buot pagsurmaton san mensahe san Dios. ");
INSERT INTO msb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Niyan nagkaurusad sinda tanan sa isip kag tagipusuon. Wara sin nagsabi na an nano man na iya kasadirihan sa iya lang gayod kundi para man sa tanan. ");
INSERT INTO msb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sa dako naman na gahom nagpadayon pagtestigos an mga apostoles san pagkabuhay gihapon san Ginooʼn Jesus, kag igwa sinda sin diosnon na dako na buot na pagkamahinatagon sa kada usad. ");
INSERT INTO msb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Waraʼn ginakulang sa inda grupo kay an may mga sadiri na kadutaan o mga kabalayan ginabaligya kag ginadara ninda an kabaklanan na kwarta, ");
INSERT INTO msb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tapos ginhatag sa mga apostoles. Ginabarahin naman ninda ini susog sa pagakinahanglan san kada usad. ");
INSERT INTO msb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Amo idto an ginhimo ni Jose, usad na Levita na taga-Cipre na gin-anggaan san mga apostoles sin Bernabe (na an gusto sabihon, “Parapakusog sin buot.”) ");
INSERT INTO msb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","May uma siya na ginbaligya, tapos gindara an kinabaklanan kag ginhatag sa mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Niyan, may mag-asawa na an mga ngaran Ananias kag Safira. Si Ananias naman nagbaligya sin parte san inda kadutaan, ");
INSERT INTO msb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","pero gintago an iba na kwarta san kabaklanan na aram man san iya asawa. Tapos, ginhatag an iba sa mga apostoles bagaʼn ina an tanan na kabaklanan. ");
INSERT INTO msb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ugaling, gin-usisa siya ni Pedro, “Ananias, nano kay nagpadaog ka kan Satanas kaya nakabuwa sa Espirito Santo paagi sa pag-iban sa kinabaklanan san duta? ");
INSERT INTO msb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nano, dili sa imo man ini antes nabaligya? Tapos, san mabaligya na, dili nasa imo man gihapon an kinabaklanan? Kun sugad, nano kay nagplano ka na pagdaya sa amon? Nagbuwa ka sa Dios dili sa tawo.” ");
INSERT INTO msb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pakabati man dayon sani ni Ananias, napatay siya kag natumba. Didi may mga batan-on na mga lalaki na nagtirindog, ginputos an patay, gindara paluwas, tapos ginlubong. Pakatapos, nagkaharadlok an tanan na nakabati san nangyari kan Ananias. ");
INSERT INTO msb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Niyan, pakalipas naman sin mga tulo ka oras, nagsulod an asawa ni Ananias na waraʼn kaaraman san nangyari. ");
INSERT INTO msb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ginhunga man siya ni Pedro, “Sabihi ako, nano, amo lang ini an kabaklanan san duta niyo?” “Opo, amo lang ina,” an sabat niya. ");
INSERT INTO msb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Didi nagsabi sa iya si Pedro, “Nano kay ginkauyunan niyo na porbaran an Espirito san Ginoo? Kitaa, ada na sa pwertahan an mga naglubong sa imo asawa. Ikaw naman yana an masunod!” ");
INSERT INTO msb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sadto mismo napatay man siya. Pagsulod san mga batan-on na lalaki, nakita ninda na patay na an babayi, kaya ginlubong siya sa katakin san iya asawa. ");
INSERT INTO msb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dahilan sani, nagkaharadlok gayod an tanan na mga nagatuod kag san iba na nakabati sani. ");
INSERT INTO msb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Niyan, nagatiripon an tanan na nagatuod sa parte san templo na ginatawag, Portico Ni Solomon. Didto may damo na mga milagro kag makangangalas an ginhimo san mga apostoles sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Waraʼn tagaluwas na nagporbar pag-intra sa inda bisan sinda gin-galang sani na mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero damo pa na mga kalalakihan kag kababayihan an nagatuod sa Ginoo. Kaya gindagdag man sinda sa grupo san mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Niyan, tungod san mga milagro gindara an mga masakiton sa mga kamino, ginpahigda sa mga katri kag mga banig agod kun mag-agi si Pedro matamaan man lang san iya anino an iba sa inda. ");
INSERT INTO msb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Damo man na mga katawuhan an nagkadto hali sa mga lungsod sa palibot san Jerusalem na nagadara san inda mga masakiton kag an may mga maraot na espirito, tapos nagkaarayo sinda tanan. ");
INSERT INTO msb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dahilan sani na mga gawi san mga apostoles, nagkaarawa gayod sa inda an pinakanamumuno san kapadian kag san tanan niya na mga kaurupod na mga Saduceo, kaya nagturulos sinda, ");
INSERT INTO msb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","tapos, gindakop an mga apostoles kag ginpapriso. ");
INSERT INTO msb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero sana na gab-i an anghel san Ginoo gin-abrihan an mga pwertahan san prisuhan, ginpaluwas sinda kag nagsabi, ");
INSERT INTO msb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Magpakadto kamo sa templo, tapos sa pagtindog niyo sa may natad sani, magtukdo manungod sani na bag-o na pagkabuhay.” ");
INSERT INTO msb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pakabati man ninda sani, nagluwas sinda kag maaga pa sadto nagsulod gihapon sa natad san templo sa pagtukdo. Niyan nagtiripon gihapon an pinakanamumuno san mga kapadian kag san mga kaurupod niya. Gintawag ninda an tanan na mga namumuno san mga Judio sa pagtiripon san tanan sa konseho. Tapos ginpakuha ninda sa prisuhan an mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero pag-abot didto san mga bantay, wara na ninda makita an mga apostoles sa prisuhan, kaya nagbalik sinda kag nagsumat, ");
INSERT INTO msb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nakita namon na nakakandado sin maayo an mga pwertahan san prisuhan kag nakatindog didto an mga bantay. Pero pag-abri namon, wara sin tawo sa sulod.” ");
INSERT INTO msb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pakabati sani, naburong an pinakanamumuno san mga kapadian kag an namumuno san mga bantay. Dili sinda makaisip kun nano naman an mangyayari. ");
INSERT INTO msb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Taud-taod, may nag-abot na nagbarita sa inda, “An mga lalaki na ginpapriso niyo, kitaa, kay adto na sinda didto sa templo nagatukdo sa mga tawo.” ");
INSERT INTO msb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tapos, nagkaradto sa templo an namumuno kag san iya mga katawuhan. Gin-upod ninda an mga apostoles sa konseho pero wara sinda maggamit sin pwersa kay nahadlok sinda na batuhon san mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pakadaraha ninda sa mga apostoles, ginpaatubang ini sinda sa konseho kag gin-usisa san pinakanamumuno san mga kapadian. ");
INSERT INTO msb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tapos, nagsabi, “Ginbawalan gayod kamo namon na dili magtukdo manungod sani na tawo, pero kitaa an iyo ginhimo! Ginpalukop lugod niyo sa bilog na Jerusalem an iyo katukduan kag gusto pa niyo na kami an manabat san iya kamatayon.” ");
INSERT INTO msb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pero nagsabat si Pedro kag san iba na mga apostoles, “Dapat sunudon namon an Dios, dili an tawo. ");
INSERT INTO msb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Siya an Dios san aton kalulululuhan na nagbuhay kan Jesus hali sa kamatayon pakatapos na ginpapatay niyo siya paagi sa pagpapako sa krus. ");
INSERT INTO msb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ginpahataas siya san Dios sa iya tuo bilang Namumuno kag Parasalbar agod tagaan an mga taga-Israel sin panahon na magbasol kag magbaya sa inda pagkasala, tapos mapatawad an inda mga kasal-an. ");
INSERT INTO msb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Niyan, mga testigos kami sani, amo man an Espirito Santo na ginhatag san Dios sa magasunod sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pakabati sani, naurit gayod sinda kag gusto ipapatay an mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero may nagtindog sa konseho na Pariseo na an ngaran si Gamaliel. Paratukdo siya san Kasuguan kag ginagalangan sa lungsod. Nagsugo siya na paluwason anay an mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tapos, nagsabi, “Mga namumuno san Israel, paghimat sa iyo hihimuon sani na mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nasabi ko ini kay kasadto nagpakita si Teudas na nagaangkon na gamhanan, kaya mga 400 ka tawo an nag-urupod sa iya. Pero pinatay siya, kag an tanan na nagsunod sa iya nagburulag, kaya nawara man gihapon an iya grupo. ");
INSERT INTO msb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pakatapos, nagluwas naman si Judas na taga-Galilea san panahon san pagpalista kag nakakuha man sin damo na sumurunod niya. Pero ginpatay siya kag nagburulag man gihapon an tanan na nagsurunod sa iya. ");
INSERT INTO msb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kaya, gusto ko sabihon sa iyo manungod sani na mga tawo na dili kamo maghimo sin kontra sa inda. Pabayai na lang sinda kay kun an mga plano kag mga trabaho ninda hali sa tawo, mawawara man lang ini, ");
INSERT INTO msb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","pero kun hali ini sa Dios, dili niyo sinda madadaog. Maluwas pa lugod na nagaato kamo sa Dios!” ");
INSERT INTO msb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kaya ginsunod ninda an iya ginsabi kag pakapatawaga ninda sa mga apostoles, ginpabunal kag ginpadaanan na dili sinda magsurmaton gihapon manungod kan Jesus, pakatapos ginpaluwas na sinda. ");
INSERT INTO msb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Naghali naman an mga apostoles sa konseho na malipay gayod kay gin-angay san Dios na magtios sinda sin kaaluhan tungod sa ngaran ni Jesus. ");
INSERT INTO msb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kada adlaw sa templo kag sa kabalayan nagpadayon sinda sa pagtukdo kag pagpahayag na si Jesus an Mesias. ");
INSERT INTO msb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Sani na panahon na nagadamo na an mga disipulos, nagkaigwa sin suruay sa mga Judio na mga Griego kag sa mga Judio na mga Hebruhanon. Ini na mga Judio na Griego nagsabi na napabayaan na an inda mga balo sa uruadlaw ninda na panginahanglan. ");
INSERT INTO msb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kaya gintiripon san dose na apostoles an mga disipulos kag ginsabihan, “Dili tama na pabayaan namon an pagpahayag san mga surmaton san Dios agod magpanghatag sin pagkaon. ");
INSERT INTO msb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Niyan, mga kaigmanghudan, magpili kamo sin pito ka tawo dida sa iyo na waraʼn ikasabi an pag-uugali kag ada sa inda an Espirito Santo kag kadunungan, kay ibubutang namon sinda sani na trabaho. ");
INSERT INTO msb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pero kami naman, gagamiton namon an tanan na panahon sa pagpangadyi kag pagapahayag san mga surmaton san Dios.” ");
INSERT INTO msb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Napalipay naman an tanan na mga katawuhan san inda ginsabi, kun kaya ginpili ninda si Esteban na may dako na pagsarig kag ada man sa iya an Espirito Santo, amo man sinda Felipe, Procoro, Nicanor, Timon, Parmenas, kag Nicolas na usad na dili-Judio hali sa Antioquia na nadara sa pagtuod. ");
INSERT INTO msb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ginpaatubang sinda sa mga apostoles na nakadapat san mga kamot sa inda myintras nagapangadyi. ");
INSERT INTO msb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nagpadayon paglukop an surmaton san Dios. Nagdamo an bilang san mga disipulos sa Jerusalem kag damo man na kapadian an nagsunod san pagtuod kan Jesu-Cristo. ");
INSERT INTO msb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Niyan, si Esteban ginbendisyunan gayod san Dios, kaya nagkaigwaʼn diosnon na gahom. Naghimo siya sin damo na mga milagro kag makangangalas sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ugaling, ginkontra si Esteban san iba na mga myimbro sa sinagoga na ginatawag Mga Ginlibre Na Mga Tawo. Mga Judio sinda na taga-Cirene kag taga-Alejandria. May nakaupod man sinda na taga-Cilicia kag mga taga-Asia. ");
INSERT INTO msb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nagsuruay sinda kan Esteban, pero dili ninda nadaog siya kay an Espirito Santo naghatag sa iya sin kadunungan sa pagsurmaton. ");
INSERT INTO msb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kaya patago ninda na ginsuhulan an iba na mga tawo na magsabi sin, “Nabati namon siya na nagapakaraot kontra kan Moises kag sa Dios.” ");
INSERT INTO msb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sani na paagi ginpasamok ninda an mga tawo, mga namumuno sa mga Judio, kag mga paratukdo san Kasuguan. Kaya, ginkadto ninda siya, gindakop kag ginpaatubang sa konseho. ");
INSERT INTO msb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pakatapos, nagkuha sindaʼn mga magtestigos sin buwa manungod sa iya. “Ini na tawo dili nagaudong pagpakaraot kontra sa banal na templo kag sa Kasuguan ni Moises. ");
INSERT INTO msb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Matuod ini kay nabatian namon siya pagsabi na rurubaon an templo saniʼn Jesus na taga-Nazaret kag babalyuhan an mga kaugalian na ginhatag sa aton ni Moises.” ");
INSERT INTO msb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ginturok si Esteban san tanan na nakaingkod sa konseho kag nakita ninda tanan na an bayhon niya bagaʼn bayhon san anghel. ");
INSERT INTO msb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Didi ginhunga si Esteban san pinakanamumuno san kapadian, “Nano, matuod ini na ginsumat ninda?” ");
INSERT INTO msb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nagsabat si Esteban, “Mga kaigmanghudan na lalaki kag mga ama sa Israel, pamatii ako! An banal na Dios nagpakita sa aton kalulululuhan na si Abraham san nag-istar pa siya sa Mesopotamia antes siya nagkadto sa Haran. ");
INSERT INTO msb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Didto nagsabi sa iya, ‘Bayai an imo kaigmanghudan kag lungsod, tapos magpakadto ka sa lugar na ipapakita ko sa imo.’ ");
INSERT INTO msb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kaya, naghali siya sa lugar san Kaldea kag nag-istar sa Haran. “San namatay an iya ama, ginpabalhin siya san Dios sani na lugar na iyo ginaistaran yana. ");
INSERT INTO msb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero wara siya paghatagi san Dios sin parte sani para sadirihon niya, bisan na lang usad na pie an kadako. Kundi gintugaan siya na ini ihahatag sa iya agod magin sadiri niya kag sa iyamga lahi bisan wara pa siya sinanak. ");
INSERT INTO msb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Amo ini an ginsabi sa iya san Dios, ‘Magigin mga dayo an imo mga lahi sa pagaistaran ninda na manlain-lain na nasyon. Pagauripunon sinda kag pagadaug-daugon sa sulod sin 400 ka tuig. ");
INSERT INTO msb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero pagahusgaran ko an katawuhan na inda pagasirbihan. Pakatapos magaharali sinda sana na lugar kag magasamba sa akon sani na lugar.’ ");
INSERT INTO msb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Didi ginsugo san Dios kan Abraham an paghimo san pagturi na tanda san iya ginsumpaan. Kaya nagin ama si Abraham ni Isaac kag ginturi sa ikawalo na adlaw pakaanak sa iya. Si Isaac naman an nagin ama ni Jacob na amo man an nagin ama san dose naton na kalulululuhan.” ");
INSERT INTO msb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nagpadayon si Esteban, “Niyan, si Jose an usad sani na kalulululuhan na ginkaawaan sana na onse na mga kamaranghod niya. Kaya, siya ginbaligya ninda kag nagin uripon siya sa Ehipto. Pero an Dios ada sa iya, ");
INSERT INTO msb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kag ginlibre siya sa iya mga kalisudan. Ginhatagan siya san Dios sin maayo na ugali kag kadunungan san mag-atubang siya kan Paraon na hadi san Ehipto. Tapos, ginbutang siya na gobernador san Ehipto kag san bilog na mga kasadirihan san Paraon. ");
INSERT INTO msb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Sadto nagkaigwa sin gutom kag pagtios sa bilog na Ehipto kag Canaan na lugar san aton kalulululuhan. Wara sinda sin makuhaan sin pagkaon. ");
INSERT INTO msb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero san mabaritaan ni Jacob na may pagkaon sa Ehipto, ginsugo niya pakadto an iya mga anak na aton mga kalulululuhan bilang primero na pagbisita. ");
INSERT INTO msb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","San ikaduha na pagkadto ninda, nagpakilala na si Jose sa iya mga kamaranghod kaya naaraman ni Paraon an manungod sa iya pamilya. ");
INSERT INTO msb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pakatapos, ginpasuguan ni Jose an iya ama na si Jacob kag san bilog niya na pamilya na magkadto sa Ehipto. 75 ka tawo sinda tanan. ");
INSERT INTO msb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kaya naglusad pa-Ehipto sinda Jacob. Didto sinda nag-istar hasta sa inda kamatayon kaupod san aton mga kalulululuhan. ");
INSERT INTO msb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tapos, gindara an inda mga lawas sa Siquem kag ginlubong sa lubungan na ginbakal ni Abraham sin nagkapira na kwarta na plata sa mga anak ni Hamor. ");
INSERT INTO msb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“San halapit na an panahon san pagtuman san Dios sa iya gintuga kan Abraham, nagdamo na an aton mga kalulululuhan sa Ehipto. ");
INSERT INTO msb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tapos, may iba naman na nagin hadi sa Ehipto na dili nakakilala kan Jose. ");
INSERT INTO msb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Didi ginluko niya an aton mga kalulululuhan kag ginpirit niya na pabayaan an inda mga bag-o na gin-anak na mga bata agod magkaparatay. ");
INSERT INTO msb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Sani man na panahon, gin-anak si Moises, usad na bata na nawiwilihan san Dios. Ginpadako anay siya sa inda sadiri na balay sin tulo ka bulan. ");
INSERT INTO msb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","San ginpatapok siya, gin-ataman siya san anak na babayi ni Paraon kag ginpadako na bagaʼn sadiri na anak. ");
INSERT INTO msb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Gintukduan si Moises san tanan na kaaraman san mga Ehiptohanon kag nagin bantog sa pagsurmaton kag sa mga paggawi. ");
INSERT INTO msb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“San 40 na an edad ni Moises, naisipan niya na bisitahon an mga kapareho niya na taga-Israel. ");
INSERT INTO msb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","May nakita siya na Ehiptohanon na ginadaug-daog an usad na kalahi niya, kaya gin-apinan niya ini kag bilang pagbalos napatay niya idtoʼn Ehiptohanon. ");
INSERT INTO msb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","An huna niya masasabutan san iya mga kahilungsod na ililibre sinda san Dios paagi sa iya pero wara ninda ini masabuti. ");
INSERT INTO msb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagkaotro adlaw may nakita siya na duha na Israelita na nagaaway kag gusto niya ini pasiruon na an sabi, ‘Mga amigo, pareho kamo Israelita. Nano kay nagaaway kamo?’ ");
INSERT INTO msb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Pero ginwahi siya san nagapasakit sa usad kag naghunga, ‘Sin-o an nagbutang sa imo na magin namumuno kag parahusgar sa amon? ");
INSERT INTO msb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nano, gusto mo man ako patayon pareho san ginhimo mo na pagpatay kahapon sadtoʼn Ehiptohanon?’ ");
INSERT INTO msb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Pakabati sani ni Moises nagdulag siya kag nagin layas sa lugar san Median. Didto nag-asawa siya kag nagkaigwa sindaʼn duha na anak na lalaki. ");
INSERT INTO msb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pakalipas sin 40 ka tuig, may nagpakita kan Moises na usad na anghel sa kakadlaganan san Bukid san Sinai paagi sa nagakalayo na tanom. ");
INSERT INTO msb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nangawa si Moises sa nakita niya kag san ginhalapitan niya agod usisahon, nabati niya an boses san Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Nagsabi ini, ‘Ako an Dios san imo mga kalulululuhan, an Dios ninda Abraham, Isaac kag Jacob.’ Nagkudog si Moises kag wara siya pagkusug-kusugan sin buot na magkita. ");
INSERT INTO msb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Nagsabi naman sa iya an Ginoo, ‘Halia an imo sandalyas kay banal ini na ginatindugan mo na lugar. ");
INSERT INTO msb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nakita ko gayod an grabe na pagtios san mga katawuhan ko sa Ehipto. Nabati ko man an inda mga agrangay kaya ako nagpakadi para ilibre sinda. Niyan, kumadi ka kay susuguon ko ikaw pa-Ehipto.’ ");
INSERT INTO msb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Amo ini si Moises na ginsikway san katawuhan san Israel san naghunga sinda, ‘Sin-o an nagbutang sa imo na magin namumuno kag parahusgar?’ Pero yana siya an ginsugo san Dios na magin namumuno kag parasalbar paagi sa bulig san anghel na nagpakita sa iya sadtoʼn tanom. ");
INSERT INTO msb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Gin-giyahan niya an mga katawuhan paluwas sa Ehipto san magpakita siya sin makangangalas kag milagro didto sa Dagat Na Pula kag sa disyerto sa sulod sin 40 ka tuig. ");
INSERT INTO msb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Siya man gihapon an Moises na nagsabi sa mga taga-Israel, ‘An Dios mapili sin usad sa iyo na hihimuon na propeta pareho san pagpili sa akon.’ ");
INSERT INTO msb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Siya an kaupod san katawuhan san Israel na gintiripon sa disyerto. Adto didto siya kaupod ngani san aton mga kalulululuhan kag san anghel na nagsurmaton sa iya sa Bukid san Sinai. Siya an ginpaniwalaan san mga surmaton na nagahatag sin buhay hali sa Dios para ihatag sa aton. ");
INSERT INTO msb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero wara nagsunod an aton mga kalulululuhan sa iya kundi ginsikway pa siya kag sa inda tagipusuon gusto lugod ninda magbalik sa Ehipto. ");
INSERT INTO msb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kaya, san wara siya didto, nagsabi sinda kan Aaron, ‘Himui kami sin diosdiosan na maggiya sa aton. Manungod naman sani na Moises na naggiya sa aton hali sa Ehipto, dili naton aram kun nano an nangyari sa iya.’ ");
INSERT INTO msb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaya, naghimo sinda sin diosdiosan sa porma na baka, naghalad didi kag nagsaradya sa ginhimo ninda. ");
INSERT INTO msb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pero an Dios gintalikdan kag ginpabayaan sinda na magsamba sa mga bituon sa kalangitan, pareho san nasurat sa libro san mga propeta: ‘Mga katawuhan san Israel, wara kamo naghalad sa akon sin ginpatay na mga hayop kag mga halad sa sulod san 40 ka tuig sa disyerto. ");
INSERT INTO msb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kundi gindara lugod niyo an tulda ni Moloc, kag an bituon san iyo diosdiosan na si Refan, mga diosdiosan na iyo ginhimo para sambahon. Kaya, papalayason ko kamo sa unhan pa san Babilonia.’,” ");
INSERT INTO msb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nagpadayon si Esteban, “Ada kasadto sa disyerto kaupod san aton mga kalulululuhan an tulda na may pagpamatuod san Dios. An irugan sani ginpakita san Dios kan Moises kag ginsugo siya na maghimo susog sana. ");
INSERT INTO msb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pakatapos, nairedar naman ini san aton mga kalulululuhan hali sa inda ama. Ina man an gindara ninda san giyahon sinda ni Josue sa pagsakop san mga kadutaan san mga nasyon na gintabog san Dios. Tapos, nagpirme ina didi hasta san panahon ni David, ");
INSERT INTO msb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","na ginpalabi san Dios. Sana na panahon nagpangayo si David sa Dios na tugutan siya na magtindog sin balay para sa iya na ginasambahan san aton kalulululuhan na mga kalahi ni Jacob. ");
INSERT INTO msb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Si Solomon ugaling an nagpatindog sin balay para sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pero an pinakalabaw sa tanan na Dios dili nagaistar sa mga balay na ginhimo san tawo. Sugad sana an ginsabi san propeta na si Isaias, ");
INSERT INTO msb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nagsabi an Dios, An langit amo an akon trono, kag an duta amo an akon tungtungan san akon mga tiil. Kaya, nano na klase an balay na igatindog niyo sa akon? Hain an lugar na akon pahuwayan? ");
INSERT INTO msb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nano, dili ako mismo an naghimo san tanan, an hunga san Dios.’,” ");
INSERT INTO msb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Nagpadayon si Esteban, “Kamo na mga sutil na tawo, dili pa nagbag-o an iyo mga tagipusuon, kabungol gayod niyo sa mensahe san Dios. Pirme niyo ginasikway an Espirito Santo pareho man san iyo mga kalulululuhan. ");
INSERT INTO msb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nano, may propeta na wara pagpasakita san iyo mga kalulululuhan? Ginpatay man ninda an nagpaaram na mapakadi an Matanos na si Jesus na niyan gintraydoran kag ginpapatay niyo. ");
INSERT INTO msb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo an nagbaton san Kasuguan san Dios na gindara san mga anghel pero wara kamo nagsunod!” ");
INSERT INTO msb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Niyan, pakabati ninda sani kan Esteban, naurit gayod kag nagpagot sa kaurit sa iya. ");
INSERT INTO msb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero si Esteban na ada sa iya an Espirito Santo, naghangad palangit kag nakita an masilaw na kapaw-an san Dios kag si Jesus na nagatindog sa iya tuo. ");
INSERT INTO msb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tapos, nagsabi si Esteban, “Kitaa, nakita ko an langit na nag-abri kag an Anak San Tawo nagatindog sa tuo san Dios.” ");
INSERT INTO msb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero nagsiriyak sinda kag gintahuban an inda mga talinga, tapos, nagdurungan pagdalagan pakadto sa iya. ");
INSERT INTO msb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pakatapos gin-guyod ninda siya paluwas san syudad, tapos nagtuna pagbato. Para makabuno sindaʼn maayo, an mga nagabarato naman ginhuba an inda mga pangsuon kag ginbilin sa may tiilan san usad na batan-on na an ngaran Saulo. ");
INSERT INTO msb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Myintras ginabato ninda si Esteban, nagpangadyi ini, “Ginooʼn Jesus, padayunon an akon espirito.” ");
INSERT INTO msb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tapos, nagluhod siya kag nagsiyak, “Ginoo, ayaw man sinda pagpanabata sani na kasal-an.” Pakasabi sani namatay siya. ");
INSERT INTO msb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kauyon man si Saulo sa pagpatay kan Esteban. Sadto mismo na adlaw may nagtuna na grabe na pagpasakit sa mga nagatuod sa Jerusalem, kaya pwera lang san mga apostoles nagburulag an tanan sa mga probinsya san Judea kag Samaria. ");
INSERT INTO msb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Niyan, may mga diosnon na lalaki naman na ginlubong Si Esteban kag grabe gayod an inda pagnguyngoy sa iya. ");
INSERT INTO msb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero ginasamok gayod ni Saulo an mga nagatuod. Ginapangsulod niya an inda mga balay kag ginapaguyod an mga kalalakihan kag mga kababayihan, tapos ginpapriso. ");
INSERT INTO msb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Niyan idtoʼn mga nagkaburulag nagapampahayag san mga surmaton san Dios. ");
INSERT INTO msb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe na kasadto usad san inda parapamahala nagkadto sa usad na lungsod san Samaria kag didto ginpahayag sa inda an manungod kan Cristo. ");
INSERT INTO msb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","San mabati san kadamuan an mga ginsabi ni Felipe kag nakita an mga milagro na nahimo niya, nagpamarati gayod sinda. ");
INSERT INTO msb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","May nagluwas na mga maraot na espirito na nagasiyak sin makusog hali sa kadamuan na ginsudlan sani. Damo man sin nag-ayo na mga paralisado kag mga pilay. ");
INSERT INTO msb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kaya nagkaigwa gayod sin dako na kalipay sa syudad. ");
INSERT INTO msb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Niyan, may tawo na an ngaran si Simon na dati na nagahimo sin salamangka sa syudad kag ginakangawahan san katawuhan sa nasyon san Samaria. Nagahambog ini na siya kuno may dako na poder. ");
INSERT INTO msb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nagturuod sinda tanan sa iya, hali sa pinakamenos na tawo hasta sa pinakalabaw na nagasabi, “Ini na tawo amo an poder san Dios, kaya siya an ginatawag ‘An Dako Na Poder’.” ");
INSERT INTO msb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nagpamati sinda sa iya kay dugay na sinda ginpangawa san iya pagsalamangka. ");
INSERT INTO msb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero san nagtuod sinda san pagpahayag ni Felipe san Maayo Na Barita manungod kan Jesu-Cristo kag sa pagahadi san Dios, maglalaki man o babayi nagkaburunyagan an tanan. ");
INSERT INTO msb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bisan ngani mismo si Simon nagtuod kag pakabunyagi, nagsunud-sunod kan Felipe kay nangawa gayod siya pakakita san mga tanda kag dako na mga milagro na nahimo. ");
INSERT INTO msb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Niyan san mabaritaan san mga apostoles sa Jerusalem na an katawuhan sa Samaria nag-ako na san surmaton san Dios, ginpakadto ninda sinda Pedro kag Juan. ");
INSERT INTO msb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pag-abot ninda didto, nagpangadyi sinda sa Dios na ipakada niya sa inda an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ini naman wara pa nagpakada sa bisan kanin-o man sa inda kundi nabunyagan lang sinda sa ngaran ni Ginooʼn Jesus. ");
INSERT INTO msb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kaya, gindapatan sinda ninda Pedro kag Juan san inda mga kamot, tapos, ada na sa inda an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pakakita naman sani ni Simon na ginhatag an Espirito paagi sa pagdapat san kamot san mga apostoles, gusto niya maghatag sa inda sin kwarta agod magkaigwa man sani na poder. ");
INSERT INTO msb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nagsabi siya, “Hatagi man ako sani agod makabaton man san Espirito Santo an madapatan ko san akon kamot.” ");
INSERT INTO msb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pero ginsabat siya ni Pedro, “Mapaimpyerno ka lugod kag sa imo kwarta kay sa huna-huna mo na makukuha an regalo san Dios paagi sani! ");
INSERT INTO msb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wara ka ngani sin labot sani na trabaho kay an imo tagipusuon dili matanos sa mata san Dios. ");
INSERT INTO msb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kaya magbasol ka kag magbaya sa imo mga maraot na ginaisip kag magpangadyi sa Ginoo na basi kun pwede mapatawad ka sani. ");
INSERT INTO msb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nasabi ko ini kay nakikita ko na awairo ka gayod kag priso san kasal-an.” ");
INSERT INTO msb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nagsabat naman si Simon, “Ipangadyi ako sa Ginoo na wara kuntani sa mga sinabi mo na mangyari sa akon.” ");
INSERT INTO msb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Niyan, pakapamatuod kag pakapahayag san mga surmaton san Ginoo, nagtuna sinda pagbalik sa Jerusalem. Sa inda paglakat, nagapahayag sinda san Maayo Na Barita sa naagihan ninda na mga kabaryuhan san Samaria. ");
INSERT INTO msb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Niyan, may anghel san Ginoo na nagsabi kan Felipe, “Maghanda ka kag magkadto sa katimugan sa may disyerto na dalan pakadto sa Gaza hali sa Jerusalem.” ");
INSERT INTO msb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kaya, naghanda man si Felipe kag nagpakadto. Sadto naman may nag-abot na lalaki na kapon na taga-Etiopia. Siya an nagapamahala sa tanan na kayamanan san Candace na reyna san Etiopia. Kasadto nagkadto siya sa Jerusalem para magsamba, tapos niyan nagapauli na. ");
INSERT INTO msb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","San pauli na myintras nagasakay sa karuwahe na pareho san kalesa, nagabasa san libro na ginsurat san propeta na si Isaias. ");
INSERT INTO msb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Didi naman nagsabi an Espirito Santo kan Felipe, “Kadto kag mag-upod ka sani na karuwahe.” ");
INSERT INTO msb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nagdalagan man dayon si Felipe pakadto sa iya kag nabati na nagabasa ini san libro ni Isaias, kaya naghunga, “Nano, nasasabutan mo an imo ginabasa?” ");
INSERT INTO msb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nagsabat ini, “Pan-o ko masabutan kun wara sin maggiya sa akon?” Didi gin-agda si Felipe na magsaka kag mag-ingkod kaupod niya. ");
INSERT INTO msb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Niyan, an parte san Banal Na Kasuratan na ginabasa niya amo ini: “Baga siya an patyon na karnero, bagaʼn kordero na dili nagaribok sa atubangan san nagagunting san iya barahibo. Pareho man siya ina, wara magsurmaton. ");
INSERT INTO msb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nagpakaalo siya kag wara siya hatagi sin hustisya. Sin-o an makasusog san iya lahi, kay an iya buhay sa kinab-an natapos na?” ");
INSERT INTO msb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Didi man naghunga an opisyal kan Felipe, “Sabihi daw ako kun sin-o an ginsabi didi san propeta, manungod kaya sa iya mismo o sa iba?” ");
INSERT INTO msb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nagsurmaton man dayon si Felipe kag tuna sani na kasuratan, ginsurmatunan niya siya san Maayo Na Barita ni Jesus. ");
INSERT INTO msb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Myintras nagabiyahe sinda, may nalabayan sinda na may tubig, kaya naghunga an opisyal, “Kitaa, adi may tubig! Nano an makaulang sa pagpabunyag ko?” ");
INSERT INTO msb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Nagsabat sa iya si Felipe, “Mabunyagan ka kun magtuod ka sin hugot sa imo tagipusuon.” Nagsabat man siya, “Oo, nagatuod ako na si Jesu-Cristo an Anak san Dios.”) ");
INSERT INTO msb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ginpaudong san opisyal an karuwahe kag naglusad sinda pakadto sa tubig, tapos nabunyagan siya ni Felipe. ");
INSERT INTO msb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paghaw-as na ninda sa tubig, si Felipe ginkuha san Espirito san Ginoo. Kaya wara na niya siya makita kundi nagpadayon na malipay. ");
INSERT INTO msb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Namangnuhan na lang ni Felipe na adto na siya sa lugar san Azoto. Sa pagpadayon niya, nagpangpahayag siya sa tanan didto na kalungsudan hasta na makaabot siya sa Cesarea. ");
INSERT INTO msb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Si Saulo naman myintras nagapadayon paghulga sin pagpatay sa mga disipulos san Ginoo, nagkadto sa pinakanamumuno san mga kapadian, ");
INSERT INTO msb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kag nagpangayo sin surat para sa mga namumuno san mga sinagoga sa Damasco agod kun may makita siya didto na mga nagasunod sa Paagi san Ginoo, bisan mga lalaki man o mga babayi, dadarhon niya pabalik sa Jerusalem na gapos. ");
INSERT INTO msb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","San paglakat niya na halapit na sa Damasco, bigla na lang may nakasilaw na ilaw hali sa langit na nagpawa sa iya patalibod. ");
INSERT INTO msb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natumba dayon siya kag may nabatian na boses na an sabi, “Saulo, Saulo! Nano kay ginapersigir mo ako?” ");
INSERT INTO msb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naghunga siya, “Sir, sin-o ka man?” Nagsabat an boses, “Ako si Jesus na ginapersigir mo. ");
INSERT INTO msb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Niyan bangon kag magsulod ka sa syudad. Pag-abot mo didto may magasabi sa imo kun nano an hihimuon mo.” ");
INSERT INTO msb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","An mga lalaki na kaupod niya sa paglakat natagalpo kag nakabati sin boses pero waraʼn nakikita. ");
INSERT INTO msb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Si Saulo naman nagtindog kag ginmuklat an iya mga mata, pero dili na siya makakita. Kaya ginkabit na lang siya hasta pa-Damasco. ");
INSERT INTO msb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tulo ka adlaw dili siya nakakita kag wara magkaon ni mag-inom. ");
INSERT INTO msb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Niyan, may disipulos didto sa Damasco na an ngaran si Ananias. Gintawag siya san Ginoo sa usad na pangitaon, “Ananias.” Nagsabat siya, “Adi ako, Ginoo.” ");
INSERT INTO msb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Didi, ginsugo siya, “Magkadto ka sa kalye na ginatawag Matadong. Didto magsulod ka sa balay ni Judas kag maghunga naman kun may lalaki didto na taga-Tarso na an ngaran si Saulo. Maaabutan mo siya na nagapangadyi, ");
INSERT INTO msb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kag may nakita pa siya sa pangitaon na tawo na an ngaran Ananias na nagsulod kag gindapatan siya san kamot agod magbalik an iya pagkita.” ");
INSERT INTO msb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pero nagreklamo si Ananias, “Ginoo, nabaritaan ko sa kadamuan an manungod sani na tawo, kun sing-ano an karautan na ginhimo niya sa imo katawuhan sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Adi na siya kag may kasuratan na sugo hali sa pinakanamumuno san kapadian na dakupon an tanan na nagasamba sa imo.” ");
INSERT INTO msb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero ginsabihan siya san Ginoo, “Magkadto ka kay ginpili ko siya na ipakilala ako sa mga dili-Judio, mga hadi kag mga taga-Israel, ");
INSERT INTO msb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","kag ipapakita ko sa iya kun sing-ano dapat siya magtios alang-alang sa akon.” ");
INSERT INTO msb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kaya nagpakadto si Ananias kag pagsulod sa balay, nakita niya si Saulo. Tapos, gindapat niya an iya kamot kag nagsabi, “Kamanghod na Saulo, nagsugo sa akon an Ginooʼn Jesus na nagpakita sa imo sa agihan san pagpakadi mo agod maulian gihapon an imo pagkita kag mapasa imo an Espirito Santo.” ");
INSERT INTO msb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sana mismo may nagkahurulog na bagaʼn himbis san isda hali sa mata ni Saulo kag nakakita na siya. Tapos nagtindog siya kag nagkadto para mabunyagan. ");
INSERT INTO msb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pakakaon niya, nagbaskog man gihapon. Nagpira pa siya ka adlaw didto kaupod san mga disipulos sa Damasco. ");
INSERT INTO msb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Didto ginpahayag dayon niya sa inda sinagoga na si Jesus an Anak san Dios. ");
INSERT INTO msb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","An tanan na nakabati sa iya nangawa kag naghunga, “Dili amo ini an tawo na nagpasamok sa Jerusalem sa mga nagasamba kan Jesus? Mala man ngani kay nagkadi siya sa katuyuan na dakupon sinda bilang priso kag darhon sa pinakanamumuno san kapadian.” ");
INSERT INTO msb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero nagdugang lugod an kabaskog ni Saulo sa pagpamatuod niya na si Jesus an Cristo. Kaya wara gayod kakontra san ginpamatuod niya an mga Judio na nagaistar didto sa Damasco. ");
INSERT INTO msb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagkaligad sin damoʼn adlaw, an mga Judio naghimo sin plano na patayon si Saulo, ");
INSERT INTO msb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero naaraman niya ini. An inda plano an pagbantayan siya sa mga pwertahan san lungsod adlaw kag gab-i agod patayon. ");
INSERT INTO msb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero kinuha siya san mga disipulos usad na gab-i kag gintunton sa pader na nakasulod sa basket. Tapos, nagbalik siya pa-Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pag-abot ni Saulo sa Jerusalem, nagporbar siya pag-upod sa mga disipulos pero nahadlok sinda sa iya, kay wara sinda magtuod na disipulos na siya. ");
INSERT INTO msb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ugaling gin-upod siya ni Barnabas sa mga apostoles kag nagpahayag sa inda kun pan-o nakita ni Saulo sa dalan an Ginoo na nagsurmaton sa iya. Ginsabi man niya kun pan-o siya nagpahayag na waraʼn kahadlok sa Damasco manungod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kaya nag-istar na si Saulo kaupod ninda kag naglibot sa bilog na Jerusalem, na nagapahayag sin waraʼn kahadlok manungod sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Didi nagsurmaton kag nakigsuay siya sa mga Judio na Griego pero gusto ninda siya patayon. ");
INSERT INTO msb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kaya, san maaraman ini san mga nagatuod ginpakadto siya sa Cesarea, tapos ginpalarga pa-Tarso. ");
INSERT INTO msb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pagkatapos, nagkaigwa sin kalinaw kag nagkusog sa pagtuod an mga nagatuod sa bilog na Judea, Galilea, kag Samaria. Pagpakusog san inda buot paagi sa bulig san Espirito Santo, nagdamo gayod sinda kag namumuhay na may paggalang sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Niyan myintras nagpanglibot si Pedro bisan diin, nagpakadto man siya sa mga katawuhan san Dios na nagaistar sa Lida. ");
INSERT INTO msb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","May nakita siya didto na lalaki na an ngaran si Eneas na paralisado kag nagaparahigda na lang sa sulod sin walo ka tuig. ");
INSERT INTO msb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tapos, nagsabi si Pedro sa iya, “Eneas, naayo ka na ni Jesu-Cristo. Magbangon ka kag himuson an imo higdaan.” Nagtindog man dayon siya. ");
INSERT INTO msb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pakakita naman sa iya san mga taga-Lida kag Saron, nagturuod man sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Niyan didto sa lungsod san Jope may nagatuod man na babayi na an ngaran Tabita, na Dorcas an gusto sabihon sa Griego. Nagaparahimo siyaʼn maayo na gawi kag nagabulig sa mga nagakinahanglan. ");
INSERT INTO msb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sadto na panahon nagkasakit siya kag namatay. Pakapunasi sa iya, ginbutang sa kwarto sa ibabaw. ");
INSERT INTO msb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tapos, pakabaritai san mga nagatuod didto sa Jope na adto si Pedro sa Lida, nagsugo sin duha na tawo pakadto sa iya kay halapit lang iniʼn Lida sa Jope. Ginpatabian ninda siya na magkadto anay sa inda kag magdali gayod. ");
INSERT INTO msb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kaya nag-upod man dayon si Pedro sa inda. San pag-abot niya, gin-upod siya ninda pakadto sa ibabaw na kwarto. Didto, nagtiripon sa iya an tanan na mga balo. Nagatarangis sinda myintras ginapakita sa iya an mga bado kag mga pangsuon na ginhimo ni Dorcas san buhay pa ini. ");
INSERT INTO msb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pero ginpaluwas sinda tanan ni Pedro, tapos nagluhod kag nangadyi. Didi gin-atubang an minatay kag nagsabi, “Tabita, magbangon ka!” Ginmuklat man sani an iya mga mata kag san makita si Pedro, nag-ingkod. ");
INSERT INTO msb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ginhuyutan ni Pedro an iya kamot kag ginpatindog. Pakatawaga sa tanan na mga katawuhan san Dios kag mga balo ginpaatubang siya na buhay. ");
INSERT INTO msb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Naaraman ini sa bilog na Jope, kaya damo an nagtuod sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pakatapos sani, nag-istar si Pedro sa Jope sin damo pa ka adlaw kaupod ni Simon na paratina san anit. ");
INSERT INTO msb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kasadto, didto sa Cesarea, may namumuno san mga suldados na Italyano, na an ngaran Cornelio. ");
INSERT INTO msb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ini siya diosnon na may paggalang sa Dios kag amo man an iya bilog na panimalay. Paralimos siya sa mga nagakinahanglan kag mapinanangadyion sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Usad na adlaw san mga alas tres an hapon may anghel san Dios na nakita niya sin klarado sa pangitaon na nagasulod kag nagatawag, “Cornelio!” ");
INSERT INTO msb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nagsud-ong siya na may kahadlok sa anghel kag nagsabat, “Nano po, Ginoo?” Nagsabi ini sa iya, “An imo mga pangadyi kag mga pagbulig ginbaton na para handumanan mo sa atubangan san Dios.” ");
INSERT INTO msb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Niyan, magpasugo ka sin mga lalaki sa Jope kag pakadion mo si Simon na ginatawag Pedro. ");
INSERT INTO msb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nagaistar siya kan Simon na paratina san anit na an balay halapit sa may dagat. ");
INSERT INTO msb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Paghali san anghel na nagsurmaton sa iya, nagtawag siya sin duha niya na suruguon kag usad na diosnon na suldados hali sa iya mga kabulig. ");
INSERT INTO msb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pakasumati sa inda san nangyari, ginsugo sinda pa-Jope. ");
INSERT INTO msb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagkaotro na adlaw, myintras nagahalapit na sinda sa syudad, nagsaka si Pedro sa atop san balay na mga alas dose na para magpangadyi. ");
INSERT INTO msb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nakabatyag siyaʼn gutom kag gusto na niya magkaon, pero myintras ginahanda pa ninda ini, nakakita siya sin pangitaon. ");
INSERT INTO msb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Didi nakita niya na nag-abri an langit na may bagaʼn dako na habol na ginatunton pakinab-an. ");
INSERT INTO msb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","An sulod sani amo an tanan na mga klaseʼn hayop, mga sawa kag mga sapat. ");
INSERT INTO msb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tapos, may nabatian siya na boses, “Pedro, tumindog ka, magpatay kag magkaon!” ");
INSERT INTO msb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero nagsabat si Pedro, “Habo ako, Ginoo, kay wara pa ako kakaon sin nano man na ginabawal o dili malinis sa amon na mga Judio.” ");
INSERT INTO msb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nagpadayon gihapon an boses, “An ginlinis na san Dios dili mo na dapat pagtawagon na bawal.” ");
INSERT INTO msb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tulo na beses ini nangyari, pakatapos, ginbalik dayon palangit idtoʼn gintunton. ");
INSERT INTO msb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Niyan myintras ginaisip ni Pedro kun nano an gusto sabihon sadto na pangitaon na nakita niya, nag-abot naman sa Jope an mga ginsugo ni Cornelio kag nagpanghunga anay san balay ni Simon. Kaya niyan, nagatindog sinda sa may pwertahan san balay, ");
INSERT INTO msb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","kag nagtawag para hungaon kun nagaistar didto si Simon na ginatawag Pedro. ");
INSERT INTO msb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Myintras ginaisip pa man ni Pedro an pangitaon, an Espirito nagsabi sa iya, “Kitaa, may tulo na lalaki na nagahanap sa imo. ");
INSERT INTO msb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Maglusad ka, tapos, mag-upod sa inda na waraʼn pagduha-duha kay ginsugo ko sinda.” ");
INSERT INTO msb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Naglusad man si Pedro pakadto sa mga lalaki kag nagsabi, “Ako an ginahanap niyo. Nano, may tuyo kamo sa akon?” ");
INSERT INTO msb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nagsabat sinda, “Si Cornelio an amon amo. Namumuno siya san mga suldados kag matanos man na tawo. May paggalang siya sa Dios kag ginagalangan man san mga Judio. Kahapon may ginsabihan siya na banal na anghel na patabian ka na magkadto sa iya balay agod mabati an sasabihon mo.” ");
INSERT INTO msb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kaya ginpadayon sinda ni Pedro kag nagpalipas san gab-i didto. Pagkaaga, nag-upod siya sa inda paglakat, kaupod man an iba san mga kamaranghod sa pagtuod na taga-Jope. ");
INSERT INTO msb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkaotro naman na adlaw, nakaabot sinda sa Cesarea. Didto ginapahulat na sinda ni Cornelio. Myintras nagapahulat siya gintiripon niya an iya mga kaigmanghudan kag mga amigo. ");
INSERT INTO msb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pag-abot lang ni Pedro, ginsugat siya ni Cornelio, nagluhod sa iya tiilan kag nagsamba sa iya. ");
INSERT INTO msb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ginpatindog siya ni Pedro na nagasabi, “Tumindog ka. Tawo man lang ako.” ");
INSERT INTO msb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Myintras nagaistoryahan sinda nagasulod sa balay kag nakita didto ni Pedro na damo sin mga tawo na nagtiripon. ");
INSERT INTO msb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kaya nagsabi siya sa inda, “Kamo mismo maaram na susog sa Kasuguan namon na mga Judio ginbawal na makig-upod o magbisita sa mga dili-Judio kay bagaʼn maati sinda sa aton, pero ginpakita sa akon san Dios na dili ko dapat pagtawagon an bisan sin-o na tawo bagaʼn maati. ");
INSERT INTO msb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaya san ginpatabian niyo ako, nagkadi dayon ako na waraʼn reklamo. Niyan, ginahunga ko kamo kun nano kay ginpatabian niyo ako.” ");
INSERT INTO msb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Didi nagsabat si Cornelio, “Mga upat na ka adlaw yana na sugad man sani na alas tres an hapon, nagapangadyi ako sa balay. Bigla na lang may nagtindog sa atubangan ko na lalaki na makintab an sul-ot. ");
INSERT INTO msb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nagsabi, ‘Cornelio, ginbati na san Dios an imo pangadyi kag an imo pagbulig naman nadumduman niya. ");
INSERT INTO msb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Magsugo ka pakadto sa Jope kag patabian si Simon na ginatawag Pedro. Siya nagaistar didto sa balay ni Simon na paratina san anit. Halapit ina sa may dagat.’ ");
INSERT INTO msb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kaya ginpasuguan ta dayon, kag maayo kay nagkadi ka. Niyan adi kami tanan sa pagkita san Dios para mamati san tanan na ginapasabi sa imo san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nagtuna si Pedro pagsurmaton, “Matuod na nakikita ko na waraʼn ginapalabi an Dios, ");
INSERT INTO msb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","pero sa kada nasyon an may paggalang sa iya kag an nagatuman sa iya nauuyunan niya. ");
INSERT INTO msb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aram niyo kun nano an ginpahayag san Dios kasadto sa mga taga-Israel manungod san Maayo Na Barita san kalinaw paagi kan Jesu-Cristo na Ginoo san tanan. ");
INSERT INTO msb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ini an surmaton na ginpahayag magtuna sa Galilea hasta sa bilog na Judea pakatapos san panahon ni Juan na Parabunyag. ");
INSERT INTO msb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Aram man niyo na si Jesus na taga-Nazaret ginhatagan san Dios san Espirito Santo kag poder. Amo man kun pan-o nagaupod sa iya an Dios kaya nagapanghimo siya sin mga kaayuhan kag an tanan na ginsakop san Dyablo ginlibre niya sa pagpaayo. ");
INSERT INTO msb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Niyan kami mga testigos san tanan na ginhimo ni Jesus sa lugar san mga Judio kag sa Jerusalem. Sa katapus-tapusi, ginpatay siya paagi sa pagpako sa iya sa krus. ");
INSERT INTO msb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero ginbuhay siya gihapon san Dios pag-ikatulo ka adlaw, kag ginpakita sa mga tawo, ");
INSERT INTO msb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","pero dili sa tanan kundi sa amon lang na pinili san Dios na magtestigos na nakikaon kag nakiinom kaupod niya pakatapos na nabuhay gihapon siya hali sa kamatayon. ");
INSERT INTO msb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ginsugo naman niya kami na magpahayag sa mga katawuhan kag magtestigos na siya an ginpili san Dios na maghusgar san mga buhay kag san mga patay. ");
INSERT INTO msb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","An tanan man na propeta nagtestigos manungod sa iya na an magtuod sa iya pagapatawadon san inda mga kasal-an paagi san iya ngaran.” ");
INSERT INTO msb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Myintras nagasurmaton pa sani si Pedro, bigla nagsulod an Espirito Santo sa inda tanan na nakabati sani. ");
INSERT INTO msb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kaya, nagkangarawa an mga nagatuod na Judio na kaupod ni Pedro kay an regalo na Espirito Santo ginhatag man bisan sa mga dili-Judio. ");
INSERT INTO msb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Aram ninda ini kay nabati ninda na nagasurmaton an mga dili-Judio sin manlain-lain na mga surmaton kag ginaumaw an Dios. Pakatapos nagpadayon si Pedro, ");
INSERT INTO msb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ini na mga tawo nakabaton san Espirito Santo pareho man naton. Nano, may makabawal sa inda pagpabunyag paagi sa tubig?” ");
INSERT INTO msb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kaya ginsugo niya sinda na magpabunyag sa ngaran ni Jesu-Cristo. Pakatapos, gin-agda ninda siya na magpabilin didto sin pira ka adlaw. ");
INSERT INTO msb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Niyan, nabaritaan san mga apostoles kag san mga kamaranghod sa pagtuod sa Judea na an mga dili-Judio nag-ako man san katukduan san Dios. ");
INSERT INTO msb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kaya pag-abot ni Pedro sa inda ginatiripunan sa Jerusalem, ginsuay siya san mga Judio na nagaapin sa pagturi. ");
INSERT INTO msb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ginsukmat siya ninda, “Nagbisita ka sa mga dili turi na mga tawo kag nakikaon ka pa ngani sa inda!” ");
INSERT INTO msb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Didi ginpahayag ni Pedro sa inda an mga pasurunod na pangyari. ");
INSERT INTO msb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Myintras nagapangadyi ako didto sa syudad san Jope, nakakita ako sin pangitaon na may ginatunton na bagaʼn halapad na habol hali sa langit. Bagaʼn nagahalapit idto sa akon. ");
INSERT INTO msb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kaya, ginmasdan ko sin maayo kag may nakita ako sa sulod na manlain-lain na mga kumadlaganon na hayop, mga sawa kag mga sapat. ");
INSERT INTO msb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tapos, may nabati ako na boses na an sabi, ‘Pedro, magtindog ka, magpatay kag magkaon.’ ");
INSERT INTO msb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Pero nagsabat ako, ‘Ginoo, habo ako kay wara pa gayod ako kakaon sin ginabawal sa amon na mga Judio.’ ");
INSERT INTO msb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Nagpadayon gihapon an boses hali sa langit, ‘An ginlinis na san Dios dili mo dapat pagtawagon na bawal.’ ");
INSERT INTO msb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Niyan, nangyari ini sin makatulo na beses, tapos, an tanan ginpabalik palangit. ");
INSERT INTO msb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sana man mismo may tulo ka tawo na nag-abot sa ginaistaran namon. Ginsugo kuno sinda pakadi sa akon hali sa Cesarea. ");
INSERT INTO msb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tapos, ginsabihan naman ako san Espirito Santo na mag-upod sa inda na waraʼn pagduha-duha. Ini man na unom ta na kamaranghod sa pagtuod didi nag-upod man sa akon kag nagsulod kami sa balay sadtoʼn tawo. ");
INSERT INTO msb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ginsumat naman niya sa amon kun pan-o kuno may nakita siya na anghel na nagatindog sa iya balay na nagasabi, ‘Magsugo ka pakadto sa Jope agod pakadion si Simon na ginatawag Pedro. ");
INSERT INTO msb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pagasabihan niya kamo san paagi na masasalbar ka kag san imo mga panimalay.’ ");
INSERT INTO msb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“San matuna na ako pagsurmaton, nagsulod sa inda tanan an Espirito Santo pareho man san nangyari sa aton san una. ");
INSERT INTO msb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Didi ko man nadumduman an ginsurmaton san Ginoo, ‘Si Juan nagbunyag paagi san tubig, pero kamo naman pagabunyagan sa Espirito Santo.’ ");
INSERT INTO msb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Niyan, kun an Dios naghatag sin pareho na regalo sa inda sugad man na naghatag siya sa aton san magtuod kita sa Ginooʼn Jesu-Cristo, pan-o ako makakontra sa Dios?” ");
INSERT INTO msb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pakabati ninda sani, wara sinda kapangsabat, kundi gin-umaw lang ninda an Dios. Nagsabi sinda, “Kaya, nag-ako man an Dios san mga dili-Judio agod makapagbasol sinda kag magkaigwaʼn buhay hasta na lang.” ");
INSERT INTO msb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Niyan, idtoʼn mga nagkaburulag tungod sa pagpasakit na nangyari san napatay si Esteban nakaabot hasta sa Fenicia, Cipre kag Antioquia. Nagapahayag sinda san surmaton san Dios sa mga Judio lang. ");
INSERT INTO msb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero may pira san mga nagatuod na taga-Cipre kag Cirene na nagpakadto sa Antioquia. Pag-abot didto, nagpahayag sinda sa mga Griego manungod kan Ginooʼn Jesus. ");
INSERT INTO msb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Paagi san poder san Ginoo an inda pagpahayag, kaya damo na mga tawo an nagtuod kag nagsarig sa iya. ");
INSERT INTO msb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ini na barita nakaabot sa simbahan san mga nagaturuod sa Jerusalem kaya ginsugo ninda si Bernabe pa-Antioquia. ");
INSERT INTO msb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pag-abot niya didto kag nakita an mga maayo na ginhimo san Dios sa katawuhan, nalipay gayod siya. Tapos, ginpakusog niya an buot san tanan na magpadayon pagkamatinumanon sa Ginoo sa bilog ninda na tagipusuon. ");
INSERT INTO msb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kay maayo na tawo si Bernabe kag may gahom san Espirito Santo kaupod san pagtuod, damo pa an nadagdag sa nagatuod sa Ginoo dahilan san iya ginasabi. ");
INSERT INTO msb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hali didto nagpakadto si Bernabe sa Tarso para hanapon si Saulo. ");
INSERT INTO msb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pakakita niya sa iya, gin-upod niya pabalik pakadto sa Antioquia. Sa sulod sin usad ka tuig nakig-upod sinda sa mga nagaturuod sa simbahan didto kag nagtukdo sa kadamuan na mga tawo. Didto sa Antioquia kauna-unahi gintawag an mga disipulos na mga Kristyano. ");
INSERT INTO msb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sani man na panahon may mga propeta na nag-abot sa Antioquia hali sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","May usad sa inda na an ngaran Agabo, nagtindog siya kag paagi sa paggiya san Espirito Santo nagsurmaton na magakaigwa sin dako na gutom sa bilog na kinab-an. Nangyari man gayod ini san panahon ni Claudio. ");
INSERT INTO msb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Dahilan sani nakaisip an mga disipulos na an kada usad sa inda susog sa kakayahan ninda, magpadara sin bulig sa mga kamaranghod sa pagtuod na nagaistar sa Judea. ");
INSERT INTO msb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kaya ginhimo ninda ini kag ginpadara idto paagi kanda Bernabe kag Saulo pakadto sa mga namumuno sa mga nagatuod didto. ");
INSERT INTO msb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sana man na panahon, nagtuna pagpasakit an Hadi na si Herodes sa iba na mga nagatuod. ");
INSERT INTO msb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ginpapatay niya paagi sa ispada si Santiago na kamanghod ni Juan. ");
INSERT INTO msb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pakakita niya na nalipay an mga Judio dahilan sana, ginpadakop man niya si Pedro. Nangyari ini san kapyistahan san Tinapay na Waraʼn Lebadura. ");
INSERT INTO msb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pakatapos na gindakop si Pedro, ginpriso kag ginpabantayan siya sa upat na grupo san mga suldados. Ginaisip man ni Herodes na pakatapos san kapyistahan ipapaatubang si Pedro sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kaya si Pedro napriso, pero an mga nagatuod nangadyi gayod sa Dios para sa iya. ");
INSERT INTO msb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Sana mismo na gab-i antes pagapaatubangon ni Herodes si Pedro sa mga tawo, nagakaturog ini sa tunga san duha na suldados. Nakagapos man siya sa duha na kadena kag may mga bantay sa pwertahan san prisuhan. ");
INSERT INTO msb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bigla na lang may nagpakita na anghel san Ginoo kag may nagpawa sa sulod san prisuhan. Ginparatapik si Pedro sa kilid kag ginpukaw, tapos nagsabi, “Dali, magbangon ka.” Natangkas dayon an kadena sa iya mga kamot. ");
INSERT INTO msb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pakatapos, ginsabihan siya san anghel, “Husaya an bado mo para paglakat kag isul-ot an imo sandalyas.” Nagsunod man dayon si Pedro. Tapos, nagsabi gihapon an anghel sa iya, “Ialikboy an imo pangsuon kag magsunod sa akon.” ");
INSERT INTO msb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kaya, nagsunod siya sa anghel paluwas san prisuhan, pero dili niya aram na matuod an nangyayari kundi naghuna siya na nakakita lang sin pangitaon. ");
INSERT INTO msb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pakalampas ninda sa una kag ikaduha na bantay, nakaabot sinda sa bakal na pwertahan pakadto sa syudad. Nag-abri mismo ini kag nakaluwas sinda, tapos, nakaagi sa kalye. Didi ginbayaan dayon siya san anghel. ");
INSERT INTO msb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nakamangno naman si Pedro kag nagsabi, “Niyan aram ko naman gayod na nagsugo an Dios san iya anghel para ilibre ako sa poder ni Herodes kag sa mga ginalauman san mga Judio.” ");
INSERT INTO msb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pakamangno niya sani, nagpakadto siya sa balay ni Maria, iloy ni Juan na ginatawag man na Marcos. Didto may damoʼn nagatiriponna nagapangadyi para sa iya. ");
INSERT INTO msb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pagtuktok ni Pedro sa may pwertahan, naghalapit an suruguon na babayi na an ngaran si Roda agod aramon kun sin-o idto. ");
INSERT INTO msb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pakakilala san boses ni Pedro, wara niya abrihi an pwertahan kundi tungod sa iya kalipay, nagdalagan lugod pasulod kag nagbarita na si Pedro ada sa may pwertahan nagatindog. ");
INSERT INTO msb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nagsabat sinda, “Nagabuang ka na siguro.” Pero nagpirit siya na matuod ini. Kaya, nagsabi gihapon sinda, “An iya anghel ina!” ");
INSERT INTO msb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ugaling, nagparatuktok gayod si Pedro. Tapos, san abrihan ninda ini, nakita siya didto kaya nagkangarawa sinda. ");
INSERT INTO msb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ginsinyasan sinda na magpuyo, tapos gin-istorya niya sa inda kun pan-o siya ginpaluwas san Ginoo sa prisuhan. Nagtugon siya, “Pakisabi niyo sani kan Santiago kag sa mga kamaranghod sa pagtuod.” Pakatapos naghali na siya kag nagpakadto sa iba na lugar. ");
INSERT INTO msb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pagkaaga na, an mga bantay nagkarilibog gayod kun hain si Pedro. ");
INSERT INTO msb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","San ginpahanap siya ni Herodes kag wara mahanapi, ginpanghunga an mga bantay, pakatapos, ginpapatay sinda. Tapos, nagpakadto siya sa Cesarea hali sa Judea kag nagpirme didto. ");
INSERT INTO msb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Kasadto naurit si Herodes sa mga katawuhan san mga lugar san Tiro kag Sidon, kaya nagtiripon sinda kag nagpakadto sa iya. Pakatapos na makigsurmaton kan Blasto na tagapamahala san hadi, nagpaupod sinda agod makighusay kay nagasarig lang sinda san inda pagkaon sa kadutaan san hadi. ");
INSERT INTO msb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sa gintalaan na adlaw, ginsul-ot ni Herodes an iya bado na panghadi, tapos, nag-ingkod sa iya trono kag nagsurmaton sa mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nagsiriyak an mga tawo, “Dili ini tawo na nagasurmaton kundi dios!” ");
INSERT INTO msb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sadto mismo, gintamaan siya san anghel san Ginoo sin sakit kay wara niya galangi an Dios. Kaya ginkutkot siya san mga ulod hasta namatay. ");
INSERT INTO msb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","An surmaton san Dios nagpadayon lugod paglukop kag nagdagdag an mga nagatuod. ");
INSERT INTO msb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sinda Bernabe kag Saulo naman nagbalik hali sa Jerusalem pakatuman san inda tuyo didto kag ginpaupod sa inda si Juan na ginatawag man Marcos. ");
INSERT INTO msb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Niyan, kaupod san mga nagatuod sa Antioquia may mga propeta kag mga paratukdo. An iba sa inda didi amo sinda Bernabe kag Saulo, Simon na ginabansagan na Negro, Lucio na taga-Cirene, kag Manaen na myimbro san panimalay san Gobernador na si Herodes. ");
INSERT INTO msb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Myintras nagasamba sinda sa Ginoo kag nagaayuno, nagsabi an Espirito Santo, “Ipili niyo ako kanda Bernabe kag Saulo kay may trabaho ako para sa inda.” ");
INSERT INTO msb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pakatapos ninda pag-ayuno kag pagpangadyi, gindapatan san inda kamot sa pagbendisyon an duha kag ginpalakat na. ");
INSERT INTO msb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kaya, nagpakadto sa Seleucia sinda Bernabe kag Saulo na ginsugo san Espirito Santo. Tuna didto naglayag sinda pakadto sa Cipre. ");
INSERT INTO msb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pag-abot ninda sa Salamina, ginpahayag an Maayo Na Barita hali sa Dios sa mga sinagoga san mga Judio. Kaupod man ninda si Juan Marcos. ");
INSERT INTO msb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","San malibot na ninda an bilog na isla hasta sa Pafos, may nakasugat sinda na salamangkero na an ngaran si Bar-Jesus na usad na Judio na nagaangkon na propeta. Ginatawag man siyaʼn Elimas. ");
INSERT INTO msb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kaupod siya san gobernador san isla na si Sergio Paulo, usad na madunong na nagpatawag kanda Bernabe kag Saulo kay gusto niya mabati an mga surmaton manungod sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero ginkontra sinda ni Elimas na salamangkero (amo ini an gusto sabihon san iya ngaran). Ginhimo niya ini kay ginatalinguha niya na pahabuon an gobernador sa pagtuod kan Jesu-Cristo. ");
INSERT INTO msb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tapos, si Saulo na ginatawag man Pablo na nasa gahom san Espirito Santo, ginturok an salamangkero ");
INSERT INTO msb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kag nagsabi, “Anak ka san Dyablo, kaaway san tanan na pagkamatanos, dayaon kag maraot gayod, pirme mo ginahimuan an matanos na katukduan san Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Niyan pagakastiguhon ka san Ginoo, mabubuta kag pira-pira na mga adlaw dili makakita san kapaw-an.” Nabatyagan dayon ni Elimas an kadulom, kaya naghanap siya sin makakabit sa iya. ");
INSERT INTO msb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","An gobernador naman nagtuod kan Saulo san makita niya an nangyari kay nangawa siya sa mga katukduan manungod san Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Niyan naglayag sinda Pablo hali sa Pafos kag nakaabot sa Perge san Panfilia. Didi ginbayaan sinda ni Juan kag nagbalik sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pero nagpadayon pa sinda Pablo hali sa Perge kag nakaabot sa Antioquia san Pisidia. Pagkaadlaw San Pagpahuway nagsulod sinda sa sinagoga kag nag-ingkod didto. ");
INSERT INTO msb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pakatapos pakabasa sin mga pira sa Kasuguan kag san kasuratan san mga propeta, ginpasuguan sinda san mga namumuno san sinagoga na nagasabi, “Mga kaigmanghudan, kun igwa kamo sin isarabi sa mga tawo, sabihan na niyo.” ");
INSERT INTO msb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kaya nagtindog si Pablo, ginsinyasan sinda na magpuyo kag nagsabi, “Mga katawuhan san Israel kag kamo na mga dili-Judio na may paggalang sa Dios, mamati. ");
INSERT INTO msb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","An Dios san mga katawuhan san Israel an nagpili san aton mga kalulululuhan kag ginhimo sinda na dako na nasyon myintras nagaistar sinda sa Ehipto. Ginpaluwas sinda san Dios sa Ehipto paagi san iya dako na poder. ");
INSERT INTO msb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sa sulod san 40 ka tuig gin-ataman sinda sa disyerto. ");
INSERT INTO msb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","San iya ginsira an pito na nasyon sa duta san Canaan, ginpairensya sinda san duta sa sulod san 450 na tuig. ");
INSERT INTO msb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Pakatapos sani, an Dios nagbutang sin mga huwes agod maghadi sa inda hasta sa panahon san propeta na si Samuel. ");
INSERT INTO msb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tapos, nangayo sinda sin hadi. Kaya, ginhatag man sa inda san Dios si Saulo na anak ni Cis na hali sa lahi ni Benjamin. Siya an naghadi sa inda sa sulod sin 40 ka tuig. ");
INSERT INTO msb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","San halion si Saulo san Dios, ginhatag naman si David para maghadi sa inda. Amo ini an ginsabi san Dios manungod sa iya, ‘Nakita ko na si David na anak ni Jesse an tawo na nauuyunan ko. Siya magasunod sa tanan san akon kagustuhan.’ ");
INSERT INTO msb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Hali sani na lahi ni David, ginhatag san Dios sa Israel an iya gintuga na Parasalbar na si Jesus. ");
INSERT INTO msb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes san iya pag-abot, nagtukdo si Juan sin bunyag na may kinahanglan na pagbasol kag pagbaya san pagkasala sa tanan na katawuhan san Israel. ");
INSERT INTO msb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","San matatapos na siya sa iya mga ginahimo, ginsabi niya sa mga tawo, ‘Nano, sa paghuna niyo ako an Mesias? Dili ako siya, pero maabot siya kasunod ko kag dili ngani ako angay bisan magtangkas san iya mga sandalyas.’ ");
INSERT INTO msb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mga kaigmanghudan ko na hali sa lahi ni Abraham kag sa mga dili-Judio na may paggalang sa Dios, ginpadara sa aton ini na mensahe manungod sa pagkasalbar. ");
INSERT INTO msb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pero an mga tawo sa Jerusalem kag san inda mga namumuno dili maaram na siya an Parasalbar. Dili man sinda nakasabot san mga mensahe san mga propeta na ginabasa kada Adlaw San Pagpahuway. Pero paagi sa pagkondinar kan Jesus ginpamatuod naman ninda ina na mga mensahe. ");
INSERT INTO msb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan wara man sindaʼn nakita na ibidinsya para husgaran siya sin kamatayon, nag-ayo pa sinda kan Pilato na ipapatay siya. ");
INSERT INTO msb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tapos, pakatuman ninda san tanan na ginasabi manungod sa iya sa Kasuratan, ginlusad siya sa krus kag ginlubong. ");
INSERT INTO msb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero ginbuhay gihapon siya san Dios hali sa kamatayon. ");
INSERT INTO msb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pakatapos, damo pa na mga adlaw nagpakita siya sa mga nag-upod sa iya sa Jerusalem hali sa Galilea, na amo an mga testigos niya sa mga katawuhan. ");
INSERT INTO msb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Kaya ginadara namon an Maayo Na Barita na amo an gintuga san Dios sa aton mga kalulululuhan. ");
INSERT INTO msb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ini gintuman niya sa aton na inda mga anak san ginbuhay gihapon niya si Jesus pareho man san nakasurat sa ikaduha na Salmo na an Dios nagsabi, ‘Ikaw an akon anak, kag nagin ama mo ako yana.’ ");
INSERT INTO msb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Manungod naman sa pagpamatuod na ginbuhay si Jesus hali sa kamatayon kag dili na gayod madudunot, nagsurmaton an Dios sani na paagi, ‘Ihahatag ko sa iyo tanan an banal kag sigurado na mga bendisyon ni David.’ ");
INSERT INTO msb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nagsabi pa man siya sa iba na Salmo sugad sani, ‘Dili mo pagatugutan na magtios sin pagkadunot an imo Banal.’ ");
INSERT INTO msb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Matuod ini kay pakatuman ni David sa katuyuan san Dios sa iya sadiri na panahon, napatay kag ginlubong kaupod san iya mga kalulululuhan, tapos nagdunot, ");
INSERT INTO msb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","pero si Jesus na ginbuhay gihapon san Dios wara magdunot. ");
INSERT INTO msb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kun sugad, mga kaigmanghudan, sigurado na maaraman niyo na may kapatawadan kamo san kasal-an paagi kan Jesus susog sa aton pagpahayag. ");
INSERT INTO msb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Niyan, paagi sa iya an tanan na nagatuod sani ginlibre sa tanan na kastigo na an Kasuguan ni Moises dili makalibre sa iyo. ");
INSERT INTO msb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kaya maghimat agod dili mangyari sa iyo an ginsabi san mga propeta: ");
INSERT INTO msb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kitaa niyo, mga paratuya-tuya, magngalas kag mapatay, kay may ginahimo ako sa iyo kapanahunan, na dili gayod niyo matutuudan bisan may magsabi pa sani sa iyo.” ");
INSERT INTO msb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pagluwas na ninda naghangyo an mga tawo na magsurmaton gihapon sinda sani sa masunod na Adlaw San Pagapahuway. ");
INSERT INTO msb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pakatapos san pagtiripon sa sinagoga, damo na mga Judio kag mga dili-Judio na nadara sa pagtuod san mga Judio an nagsunod kanda Pablo kag Bernabe. Tapos, nagsurmaton ini sa inda kag nagpakusog san inda buot na magpadayon sa pagsarig sa pagkamaluluy-on san Dios. ");
INSERT INTO msb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pagkaotro Adlaw San Pagpahuway, haros an bilog na syudad nagtiripon agod mamati san katukduan san Dios. ");
INSERT INTO msb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero pakakita san mga Judio sa kadamuan, nagkaarawa sinda, kaya ginkontra an ginsabi ni Pablo kag ginpakaraot pa siya. ");
INSERT INTO msb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ugaling, sinda Pablo kag Bernabe naman nagsurmaton lugod na makusog an buot, “Kinahanglan isabi anay gayod sa iyo an katukduan san Dios. Niyan, kay ginsikway niyo ini kag ginhusgaran mismo niyo na dili kamo angay sa buhay na waraʼn katapusan, kaya makadto kami sa mga dili-Judio. ");
INSERT INTO msb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Matuod ini kay sugad sani an ginsugo sa amon san Ginoo na, ‘Ginbutang ko kamo na magin bagaʼn ilaw sa mga dili-Judio, agod madara niyo an pagkasalbar sa bilog na kinab-an.’,” ");
INSERT INTO msb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pakabati sani san mga dili-Judio, nagkarilipay sinda kag gin-galangan an katukduan san Dios. Tapos nagtuod idtoʼn ginpili para sa buhay na waraʼn katapusan. ");
INSERT INTO msb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kaya, an katukduan san Ginoo nakalukop sa bilog sana na lugar. ");
INSERT INTO msb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero ginsulsulan san mga Judio an mga diosnon na kababayihan na kilala sa lungsod, amo man an kalalakihan na nagapamuno sa lungsod. Sugad sani nagtuna sinda pagpersigir kanda Pablo kag Bernabe, tapos ginpalayas sinda sa inda lugar. ");
INSERT INTO msb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pero ginpagpag sani na duha an alpog san inda mga tiil bilang pagtestigo kontra sa mga tagadidto kag nagpakadto sinda sa Iconio. ");
INSERT INTO msb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","An mga disipulos naman sa Antioquia nagkarilipay gayod kag napasa inda an Espirito Santo. ");
INSERT INTO msb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Didto naman sa Iconio, nagsulod sinda Pablo kag Bernabe sa sinagoga san mga Judio kag nagsurmaton sin maayo mala ngani kay damo an nadara sa pagtuod na mga Judio kag mga Griego. ");
INSERT INTO msb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tapos, an mga dili nagatuod na mga Judio ginpasamok an mga dili-Judio kag ginpaisip sinda sin maraot kontra sa mga kamaranghod sa pagtuod. ");
INSERT INTO msb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero, nagdugay an duha didto, nagsurmaton para sa Ginoo na waraʼn kahadlok sa mga tawo kag nagtestigos na matuod an inda mensahe manungod sa iya kapatawadan san mga sala, tapos, ginhatagan sinda san Dios sin poder na maghimo sin mga milagro kag makangangalas na mga gawi. ");
INSERT INTO msb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","An mga katawuhan naman sa syudad nabahin; may mga nag-apin sa mga Judio kag an iba sa mga apostoles. ");
INSERT INTO msb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Didi nakaisip an mga Judio kag mga dili-Judio kaupod an inda mga namumuno na pasakitan sinda kag batuhon. ");
INSERT INTO msb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero naaraman ini san mga apostoles kaya nagdulag sinda pakadto sa Listra kag Derbe, mga syudad san Licaonia, kag sa palibot na lugar. ");
INSERT INTO msb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Didto sinda nagpahayag san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Niyan, didto sa Listra may lalaki na nagaingkod sa luwas na dili gayod nakalakat kay pilay siya tuna pa san gin-anak. ");
INSERT INTO msb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Namati siya kan Pablo na nagasurmaton. Si Pablo naman ginakita siya sin maayo kag san mapanginanuhi na may pagtuod siya na mag-ayo, ");
INSERT INTO msb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","nagsabi sin makusog, “Magtindog ka!” Nagtindog dayon ini kag naglakat. ");
INSERT INTO msb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pakakita san kadamuan sa ginhimo ni Pablo, nagsiriyak sinda sa sadiri ninda na surmaton sa Licaonia, “An mga dios nagpakadi sa aton pareho sa mga tawo!” ");
INSERT INTO msb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kaya, ginpangaranan ninda si Bernabe sin Zeus. Si Pablo naman, tungod kay siya an parasurmaton, ginpangaranan man ninda sin Hermes. ");
INSERT INTO msb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Niyan, an templo san Zeus ada lang sa atubangan san syudad. Tapos, an padi naman san Zeus kaupod san mga katawuhan nagdara sin mga turo kag mga kulintas na burak sa may pwertahan sa syudad kag gusto na maghalad sin mga sakripisyo. ");
INSERT INTO msb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero san mabati ini ninda Bernabe kag Pablo, gin-gisi ninda an inda mismo mga bado sa pagkaurit susog sa inda ugali kag nagdalagan pakadto sa kadamuan na nagasiyak, ");
INSERT INTO msb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mga katawuhan, nano kay ginahimo niyo ini? Tawo lang kami pareho niyo na nagadara sa iyo san Maayo Na Barita agod magbaya kamo sani na mga waraʼn pulos na mga kaugalian pakadto lugod sa buhay na Dios na naglalang san langit, duta, dagat kag an tanan na ada sana. ");
INSERT INTO msb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kasadto, gintugutan niya an tanan na nasyon na sundon an inda kagustuhan. ");
INSERT INTO msb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero pirme siya nagahatag sin pruwiba na buhay siya paagi sa maayo na ginhimo niya. Halimbawa, ginahatagan kamo sin uran hali sa langit kag mga ani sa tama na panahon agod malipay man an iyo mga tagipusuon kag mabusog kamo sin mga pagkaon.” ");
INSERT INTO msb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bisan sani na mga surmaton nalisudan pa gihapon sinda pagsaway san mga tawo sa paghalad sa inda. ");
INSERT INTO msb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pero may mga Judio na nag-abot didto hali sa Antioquia kag Iconio na nadara an katawuhan. Kaya, nag-upod sinda tanan sa pagbato kan Pablo, tapos, gin-guyod ninda siya paluwas san syudad sa paghuna na patay na siya. ");
INSERT INTO msb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero pagtiripon sa iya san mga disipulos, nagbangon siya kag nagbalik sa lungsod. Tapos, pagkasunod na adlaw nagkadto sinda ni Bernabe sa Derbe. ");
INSERT INTO msb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Niyan, pakapahayag ninda san Maayo Na Barita sa Derbe, nakahidara sinda sin damo na magin mga disipulos. Tapos, nagbalik sinda sa Listra kag sa Iconio kag, pagkatapos, sa Antioquia. ");
INSERT INTO msb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Didto ginpakusog ninda an mga buot san mga nagatuod kag ginsabihan na magpadayon sa pagtuod. Nagsabi pa na maagi anay kita sin damo na pasakit antes makasulod sa kahadian san Dios. ");
INSERT INTO msb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Myintras naman, nagbulig sinda sa mga nagatuod sa pagbutang na may pangadyi kag pag-ayuno sin mga namumuno sa kada simbahan. Tapos, ginpaniwala ninda sinda sa Ginoo na amo an ginatuudan ninda. ");
INSERT INTO msb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pakaagi ninda sa Pisidia, nakaabot naman sa Panfilia. ");
INSERT INTO msb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Didto, gintukdo man ninda sa Perge an Maayo Na Barita hali san Dios kag pakatapos nagpakadto sa Atalia. ");
INSERT INTO msb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Hali didto, naglayag pabalik sa Antioquia kun diin kasadto ginpaniwala sinda sa pag-ataman san Dios para sa trabaho na natapos na ninda. ");
INSERT INTO msb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pag-abot ninda sa Antioquia, gintiripon ninda an mga nagatuod kag ginsumatan san tanan na ginhimo san Dios paagi sa inda kag kun pan-o gin-abrihan niya an agihan san pagtuod sa mga dili-Judio. ");
INSERT INTO msb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tapos, nagdugay man sinda didto kaupod san mga disipulos. ");
INSERT INTO msb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","May iba naman na mga tawo na nag-abot sa Antioquia hali sa Judea kag nagatukdo sa mga nagatuod na waraʼn masasalbar hasta na maturi na susog sa kaugalian ni Moises. ");
INSERT INTO msb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ginkontra gayod sinda ninda Pablo kag Bernabe, kaya ngani nagsuruay sinda! Tapos, an isip san mga disipulos didto na mapakadto sinda Pablo kag Bernabe kaupod san pira na tagadidto pa-Jerusalem agod makaistorya sa mga apostoles kag sa mga namumuno san mga nagatuod manungod sani. ");
INSERT INTO msb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kaya, pakapakadtua sa inda san mga nagatuod, nag-agi anay sa Fenicia kag Samaria. Didi ginbarita ninda kun pan-o nagatuod an mga dili-Judio sa Dios, kaya, nakapalipay gayod ini sa mga kamaranghod sa pagtuod didto. ");
INSERT INTO msb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pag-abot ninda sa Jerusalem, ginpadayon sinda san mga nagatuod, mga apostoles kag mga namumuno na ginsumatan ninda san ginhimo san Dios paagi sa inda. ");
INSERT INTO msb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero may nagtindog didto na iba na mga nagatuod na Pariseo na nagsabi, “Kinahanglan gayod turion an mga dili-Judio kag patumanon sa Kasuguan ni Moises.” ");
INSERT INTO msb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","An mga apostoles naman kag mga namumuno san mga nagatuod nagtiripon agod makaistorya manungod sani. ");
INSERT INTO msb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pakatapos san halaba na mga suruay, tumindog si Pedro kag nagsabi, “Mga kaigmanghudan, naaraman niyo na kasadto ginpili ako san Dios sa iyo na magtukdo sa mga dili-Judio san Maayo Na Barita agod magtuod sinda. ");
INSERT INTO msb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Sugad pa man an Dios na nakaaram san tagipusuon san mga tawo naghatag sa inda san Espirito Santo pareho man san sa aton. ");
INSERT INTO msb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ginlinisan man niya an inda mga tagipusuon kay nagtuod sinda, kaya wara naʼn kaibahan sinda sa aton. ");
INSERT INTO msb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Niyan, nano kay ginaporbaran pa niyo an Dios paagi sa pag-obligar sana na mga dili-Judio na wara ngani naton makaya, bisan man san aton mga kalulululuhan? ");
INSERT INTO msb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ugaling, nagatuod kita na masasalbar paagi sa pagkamaluluy-on na may pagkamuot san Ginooʼn Jesus pareho man sana na mga dili-Judio.” ");
INSERT INTO msb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Didi, mapuyo an mga nagtiripon myintras namamati san mga sumat ninda Bernabe kag Pablo manungod san mga milagro kag makangangalas na ginhimo san Dios paagi ninda sa mga dili-Judio. ");
INSERT INTO msb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pakasurmaton ninda, nagsabat man si Santiago, “Mga kaigmanghudan, pamati kamo sa akon. ");
INSERT INTO msb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Si Simon nagsumat kun pan-o an Dios nagmalasakit sa mga dili-Judio kag nagpili sa inda sin mga tawo para sa iya mismo. ");
INSERT INTO msb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nagakauyon gayod ini sa mga surmaton san mga propeta, pareho san nasurat, ");
INSERT INTO msb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pakatapos sani mabalik ako, kag pagatindugon ko gihapon an istaran ni David na natumpag. Ititindog ko ini hali sa pagkasira kag aayuhon gihapon, ");
INSERT INTO msb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","agod magahanap sa Ginoo an iba na mga katawuhan na amo an tanan na mga dili-Judio na ginpili na magin katawuhan ko, ");
INSERT INTO msb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","an sabi san Ginoo na naghayag sani tuna pa kasadto.’ ");
INSERT INTO msb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Kaya, sa huna-huna ko, dili ta pagsamukon an mga dili-Judio na nagtuod sa Dios, ");
INSERT INTO msb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","kundi suratan ta sinda na dili magkaon sin nano man na ginhalad sa mga diosdiosan, sin mga hayop na wara pagpadugua sin dugo mismo kag maglikay sa malaw-ay na kaila. ");
INSERT INTO msb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nasabi ko ini kay kasadto pa na panahon ginatukdo an Kasuguan ni Moises sa kada syudad kag ginabasa hasta yana sa mga sinagoga kada Adlaw San Pagpahuway.” ");
INSERT INTO msb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tapos, nagkauruyon an mga apostoles kag mga namumuno kaupod an bilog na mga nagatuod na magpili sin pira ka tawo hali sa grupo agod pakadtuon sa Antioquia kaupod ninda Pablo kag Bernabe. Ginpili ninda sinda Judas na ginatawag Barsabas kag Silas na mga ginagalangan san kamaranghudan. ");
INSERT INTO msb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ginpadarahan man ninda sinda san surat na amo ini an ginsabi: “Mga kamaranghod sa pagtuod na dili-Judio sa Antioquia, Siria kag Cilicia, kami na mga apostoles kag mga namumuno san mga nagatuod, nagapangumusta sa iyo. ");
INSERT INTO msb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Nabaritaan namon na an iba na hali sa amon grupo ginasamok kag ginapalipong kamo tungod sa inda ginapanurmaton, bisan wara namon sinda pagsugua na maghimo sani. ");
INSERT INTO msb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaya nagkauruyunan namon na magpili kag magsugo sa iyo sin mga tawo kaupod san aton pinalangga na Bernabe kag Pablo, ");
INSERT INTO msb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","na nagtaya san inda buhay sa pagsirbe sa aton Ginoo na si Jesu-Cristo. ");
INSERT INTO msb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kun sugad, ginasugo namon sa iyo sinda Judas kag Silas na magapahayag sa iyo san nasasabi didi sa surat. ");
INSERT INTO msb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nasabi ko ini kay nagkauruyunan man namon sa bulig san Espirito Santo na dili na kamo pagdagdagan pa sin obligasyon pwera sani na mga kinahanglan gayod. ");
INSERT INTO msb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Dili man kamo magkaon sin ginhalad sa mga diosdiosan, sin ginpatay na wara pagpadugua sin dugo mismo kag maglikay sa malaw-ay nakaila. Niyan, mapapaayo kamo kun magpaharayo sani. “Paaram na.” ");
INSERT INTO msb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kaya, pakasugua sa inda, nagpakadto sinda sa Antioquia, kag pakapatiripuna sa mga kamaranghod sa pagtuod didto, ginhatag an surat. ");
INSERT INTO msb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pakabasa naman sani san katawuhan, nalipay gayod sinda sa ginsabi na pagpakusog san inda buot. ");
INSERT INTO msb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sinda Judas kag Silas naman na mga propeta, damo sin ginsabi sa inda kag ginpakusog man an inda mga buot. ");
INSERT INTO msb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pakaistar ninda didto sin madugay-dugay, ginpauli sinda ninda na may kalinaw san isip sa nagsugo sa inda. ");
INSERT INTO msb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero nakaisip si Silas na mapabilin didto. ");
INSERT INTO msb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pero nagpabilin sinda Pablo kag Bernabe sa Antioquia kag kaupod san iba man nagapangtukdo kag nagapangpahayag san mga katukduan san Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagkadugay-dugay, nagsabi si Pablo kan Bernabe, “Hamos, balikon ta kag bisitahon an mga kamaranghod sa pagtuod sa kada syudad na ginpahayagan naton san mga surmaton san Ginoo agod kumustahon sinda.” ");
INSERT INTO msb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Kaya, gin-gusto ni Bernabe na iupod si Juan na ginatawag Marcos. ");
INSERT INTO msb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero habo ni Pablo na paupudon kay wara ini magpadayon pag-upod sa inda kasadto hasta sa katapusan san inda trabaho kundi nagbalik kag ginbayaan sinda sa Panfilia. ");
INSERT INTO msb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nagsuay gayod sinda, kaya nagbulag sin lakat. Gin-upod ni Bernabe si Marcos kag naglayag sinda pakadto sa Cipre. ");
INSERT INTO msb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Pablo naman ginpili iupod si Silas kag naglakat sinda pakapangadyi san mga kamaranghod sa pagtuod na pagabantayan sinda san kaluoy san Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tapos, nagpakadto sinda Pablo sa Siria kag Cilicia na ginpakusog ninda an buot san mga nagatuod. ");
INSERT INTO msb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Niyan, nagpadayon gihapon paglakat sinda Pablo sa Derbe, tapos, diretso pa-Listra. Didto may disipulos na an ngaran Timoteo, anak san Judio na babayi na nagatuod man, pero Griego an iya ama. ");
INSERT INTO msb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ginpamatuudan san mga kamaranghod sa pagtuod na taga-Listra kag Iconio na maayo na tawo si Timoteo. ");
INSERT INTO msb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gusto siya ni Pablo iupod, kaya ginturi niya ini kay aram san tanan na Judio sa lungsod na Griego an iya ama. ");
INSERT INTO msb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pagpadayon ninda paglakat sa mga syudad, ginpaaram sa mga nagatuod na tumanon an ginkauruyunan san mga apostoles kag mga namumuno na adto sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kaya, nagkusog sa pagtuod an mga nagatuod kag uruadlaw nagdamo lugod sinda. ");
INSERT INTO msb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Niyan nag-agi sinda sa lugar san Frigia kag Galacia kay wara sinda pagtuguti san Espirito Santo na magpahayag san Maayo Na Barita sa probinsya san Asia. ");
INSERT INTO msb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pag-abot ninda sa tabok san Misia, gusto kuntani ninda magsulod sa probinsya san Bitinia, pero wara sinda pagtuguti san Espirito ni Jesus. ");
INSERT INTO msb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kaya pag-agi sa Misia, nagpakadto sinda sa Troas. ");
INSERT INTO msb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pagkagab-i sadto may nakita si Pablo na pangitaon kun diin may lalaki na taga-Macedonia nagatindog kag makimaluoy sa iya, “Magpakadi ka tabi sa Macedonia agod mabuligan mo kami.” ");
INSERT INTO msb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kaya, pakatapos sani na pangitaon, naghanda dayon kami pakadto sa Macedonia kay naisip namon na an Dios nagtawag sa amon na magpahayag man san Maayo Na Barita sa mga tawo didto. ");
INSERT INTO msb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hali sa Troas naglayag kami pakadto dayon sa Samotracia kag pagkaaga sana pakadto naman sa Neapolis. ");
INSERT INTO msb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Hali didto nagpakadto kami sa Filipos na parte san Roma kag an nangunguna na lungsod sana na parte san Macedonia. Nagpabilin kami didto sin pira ka adlaw. ");
INSERT INTO msb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sa Adlaw San Pagpahuway, nagluwas kami sa lungsod kag nagkadto sa may suba na ginhuna namon na may lugar san pangadyian. Kaya nag-ingkod kami didto kag nakisurmaton sa mga babayi na nagtitiripon. ");
INSERT INTO msb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","May nakabati sa amon na an ngaran si Lydia na taga-Tiatira. Parabaligya siya sin mga asul na tela kag usad man na nagasamba sa Dios. Ginpasabot siya san Dios sa mga ginasurmaton ni Pablo. ");
INSERT INTO msb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kaya, nagkaburunyagan sinda kag san iya bilog na panimalay. Pakatapos, gin-agda kami, “Kun ginahuna niyo na may pagtuod ako sa Ginoo, hamos kamo sa balay kag didto magdayon.” Nagpirit gayod siya kag amo an nasunod. ");
INSERT INTO msb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Usad sin adlaw, mapakadto na kami sa lugar san pangadyian. Didi may nagsugat sa amon na uripon na babayi na ginsudlan san maraot na espirito na nagahatag sa iya sin poder na magsurmaton kun nano an mangyayari sa maabot na panahon. Dako an ginakita san iya mga amo paagi sani. ");
INSERT INTO msb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Myintras nagasunod siya sa amon ninda Pablo nagasiyak, “Mga suruguon ini na mga tawo san pinakalabaw na Dios. Sinda man an nagapahayag sa iyo san paagi san pagkasalbar.” ");
INSERT INTO msb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ginparahimo niya ini uruadlaw hasta nabadli si Pablo. Kaya gin-atubang kag ginsabihan an espirito, “Ginasugo ta ikaw sa ngaran ni Jesu-Cristo na magluwas sa iya.” Sana mismo nagluwas an espirito. ");
INSERT INTO msb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero san mapanginano san mga amo san babayi na wara na an inda paglaom na makakwarta, gindakop ninda sinda Pablo kag Silas, gin-guyod pakadto sa atubangan san mga namumuno sa may plasa. ");
INSERT INTO msb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tapos, pakapaatubanga sa inda sa mga namumuno na mga Romano nagsabi, “Judio ini na mga tawo kag ginasamok an aton lungsod. ");
INSERT INTO msb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nagatukdo sinda sin mga kaugalian na ginabawal sa aton na mga Romano na akuon kag himuon.” ");
INSERT INTO msb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ginburuligan sinda san mga tawo, tapos, gin-gisi naman san mga namumuno an mga bado ninda Pablo kag Silas agod bunalon, tapos, nagsugo na bunalon sinda. ");
INSERT INTO msb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pakabunali sin grabe, gintuklang pasulod san prisuhan kag ginpabantayan sinda sin maayo. ");
INSERT INTO msb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bilang pagsunod sa sugo, ginbutangan sinda san namumuno san mga bantay sa pinakasulod san prisuhan, tapos, ginsalipit an inda mga tiil sa mga gin-ukit na buho san duha na mabug-at na kahoy. ");
INSERT INTO msb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","San matungaʼn gab-i na, nagapangadyi kag nagakanta sin mga himno sa Dios sinda Pablo kag Silas. An iba naman na mga priso nagabarati sa inda. ");
INSERT INTO msb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bigla na lang may makusog na linog. Nauy-og an pundasyon san prisuhan, tapos, nag-abri dayon an mga pwertahan kag nagkatarangkas an mga kadena san mga priso. ");
INSERT INTO msb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nagmata an namumuno san mga bantay kag san nakita niya na abyirto na an mga pwertahan, naghuna siya na nakadulag an mga priso, kaya ginkuha an iya ispada agod magbigti. ");
INSERT INTO msb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero nagsiyak si Pablo, “Ayaw pagbigti kay adi kami tanan.” ");
INSERT INTO msb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nag-ayo sin ilaw an namumuno san mga bantay, nagsulod kag nagluhod na nagakudog sa kahadlok sa tiilan ninda Pablo kag Silas. ");
INSERT INTO msb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ginpaluwas niya sinda kag naghunga, “Nano an dapat ko himuon agod masalbar?” ");
INSERT INTO msb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nagsabat sinda, “Magtuod sa Ginooʼn Jesus agod masalbar ka kag san imo bilog na panimalay.” ");
INSERT INTO msb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tapos, ginpahayag ninda an Maayo Na Barita manungod sa Ginoo sa iya kag sa tanan na sakop san iya panimalay. ");
INSERT INTO msb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sadto mismo na gab-i gin-upod sinda san namumuno san mga bantay kag ginhugasan an inda mga samad. Tapos, nabunyagan dayon siya kaupod an iya bilog na panimalay. ");
INSERT INTO msb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pakatapos ginpadayon niya sa iya balay kag ginpakaon sinda. Nalipay gayod siya kaupod an bilog niya na panimalay kay nagtuod sinda sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pero pagkaaga na, ginsugo san mga namumuno san lungsod an mga suldados, “Paluwasa na idtoʼn mga tawo.” ");
INSERT INTO msb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kaya, ginsabihan san namumuno san mga bantay si Pablo, “An mga namumuno san lungsod nagpasugo na paluwason kamo. Kaya magluwas na kamo kag maglakat na may kalinaw san isip.” ");
INSERT INTO msb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero nagsabi si Pablo sa mga suldados, “Ginpabunalan ninda kami sa kadamuan bisan wara pa kami mahusgari. Mga pumuluyo man ngani kami na Romano pero ginpapriso. Niyan, patago lang kami na paluwason? Dili pwede! Pakadia sinda mismo kag paluwason kami.” ");
INSERT INTO msb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ginsumat ini san mga suldados sa mga namumuno san lungsod. Pakabarita ninda na mga pumuluyo ini san Roma nahadlok sinda. ");
INSERT INTO msb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kaya, nagkadto sinda kag nangayo sin tawad. Tapos, ginpaluwas ninda sinda kag naghangyo na maghali sa syudad. ");
INSERT INTO msb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kaya, nagluwas man dayon sinda sa prisuhan kag nagkadto kanda Lydia. Pakakita ninda didto sa mga kamaranghod sa pagtuod, ginpakusog an mga buot sani kag naghali na. ");
INSERT INTO msb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pakaagi ninda Pablo sa Amfipolis kag Apolonia, nagkadto sinda sa Tesalonica kun diin may gintiripunan san mga Judio na ginatawag sinagoga. ");
INSERT INTO msb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Susog sa nakaugalian na ni Pablo nagsulod siya sa sinagoga. Didto kada Adlaw San Pagpahuway sa sulod san tulo ka semana, nakigsuay siya sa inda manungod sa Banal Na Kasuratan. ");
INSERT INTO msb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ginapahayag kag ginapamatuudan na kinahanglan magtios si Cristo kag mabuhay gihapon hali sa kamatayon. Tapos, nagsabi, “Iniʼn ginapahayag ko sa iyo na Jesus, amo an Cristo.” ");
INSERT INTO msb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","May iba sa inda na nadara kag nag-upod kanda Pablo kag Silas. Amo man an kadamuan na mga diosnon na Griego kag mga kilala na mga babayi. ");
INSERT INTO msb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero nagkaarawa an mga Judio, kaya may gintiripon sinda na mga waraʼn pulos na istambay sa kalye, tapos, ginsamok ninda an bilog na lungsod kag ginsulong an balay ni Jason. Ginahanap ninda didi sinda Pablo kag Silas agod iatubang sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","San wara ninda makita, gin-guyod ninda si Jason kag san iba na mga kamaranghod sa pagtuod sa mga otoridad san syudad kag nagsiyak, “Nagpakadi idtoʼn mga tawo na nagasamok bisan diin, kag ginpadayon man ni Jason sa iya balay. ");
INSERT INTO msb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Usad pa, nagasupak sinda san mga kasuguan ni Cesar sa pagsabi na may iba pa na hadi na an ngaran Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pakabati sani san mga tawo kag otoridad san lungsod, nagkasaramok sinda. ");
INSERT INTO msb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ini naman si Jason kag san iya mga kaurupod ginpapyiansa san mga namumuno san lungsod antes ginpaluwas. ");
INSERT INTO msb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sadto mismo na gab-i ginpadulag naman sinda Pablo kag Silas pa-Berea san mga kamaranghod. Pag-abot ninda didto nagsulod sa sinagoga san mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Niyan ini na mga Judio didi mas mga maayo ki sa mga taga-Tesalonica kay nagbati sinda sa mensahe manungod kan Jesus na may pagkaila. Ginaadalan anay ninda an Banal Na Kasuratan kada adlaw kun matuod man gayod ini. ");
INSERT INTO msb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Damo sa inda na mga Judio an nagtuod, amo man an mga Griego na mga babayi na kilala sa lungsod hasta an mga lalaki. ");
INSERT INTO msb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero san maaraman san mga Judio sa Tesalonica na an katukduan san Ginoo ginpahayag ni Pablo sa Berea, nagkadto man sinda kag ginsulsulan an mga tawo na magsaramok. ");
INSERT INTO msb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kaya, ginpadulag naman dayon si Pablo san mga kamaranghod pakadto sa may dagat, pero nagpabilin didto sinda Silas kag Timoteo. ");
INSERT INTO msb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Gindul-ong si Pablo hasta sa Atenas. Tapos, nag-uli naman pa-Berea an mga nagdul-ong na dara an tugon ni Pablo kanda Silas kag Timoteo na magsunod sa dili madugay na panahon. ");
INSERT INTO msb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Myintras nagahulat didto sa Atenas si Pablo kanda Silas kag Timoteo, nabadli gayod siya san makita na damo sin mga diosdiosan an lungsod. ");
INSERT INTO msb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kaya, nakigsuay siya manungod kan Jesu-Cristo sa mga Judio sa sinagoga kag mga dili-Judio na nagasamba sa Dios, amo man sa kadamuan na mga tawo uruadlaw sa may merkado kag sa mga nakapangabot didto. ");
INSERT INTO msb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","An iba naman sani amo an mga paratukdo san kaisipan na pagka-Epicurea kag pagka-Estoico. May nagahunga, “Nano an gusto sabihon sani na nagdudunung-dunungan?” Nagsabi man an iba, “Pareho man siya san nagatukdo manungod san iba na mga dios.” Nasabi ninda ini kay ginapahayag niya si Jesus kag an iya pagkabuhay gihapon hali sa pagkamatay. ");
INSERT INTO msb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kaya gin-upod ninda siya agod iatubang sa pagtiripon san konseho sa Areopago. Tapos, ginhunga, “Gusto namon tabi na maaraman kun nano ini na bag-o na katukduan na ginasabi mo. ");
INSERT INTO msb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kay bag-o sa amon pamati ini, kaya gusto man gayod namon maaraman an gusto sabihon sani.” ");
INSERT INTO msb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Niyan, an tanan na mga taga-Atenas kag mga dayo na nag-istar didto ginapakinabangan an inda oras sa pagsurmaton o pagpamati sin bag-o na kaisipan. ");
INSERT INTO msb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kaya, si Pablo na nagatindog sa tunga san pagtiripon san konseho sa Areopago nagsabi, “Mga katawuhan san Atenas, napapanginanuhan ko na maungod kamo sa pagsamba sa mga dios. ");
INSERT INTO msb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kay san pag-agi ko kag nakita an iyo ginasamba, nakita ko man an altar na may nakasurat sani, ‘Sa dili kilala na dios.’ An nano man na iyo ginasamba na dili kilala, amo ini an ginasurmaton ko sa iyo. ");
INSERT INTO msb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“An Dios na naglalang san kinab-an kag san tanan na adi didi, amo an Ginoo san langit kag duta kag dili nagaistar sa mga templo na hinimo san tawo. ");
INSERT INTO msb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dili man siya ginasirbihan san tawo na bagaʼn nagakinahanglan sin nano pa man kay siya mismo an nagahatag sa tanan na tawo san tanan na kinahanglan hasta buhay kag ginhawa. ");
INSERT INTO msb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hali sa usad na tawo ginlalang niya an tanan na nasyon san katawuhan para mag-istar sa bilog na kinab-an. Siya man mismo an nagbutang san tama na panahon san inda pagpakita, kag mga lindero san lugar na inda pagaistaran. ");
INSERT INTO msb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ginhimo niya ini agod pagahanapon ninda an Dios sa paglaom na sa paghanap makita siya. An matuod lang, dili gayod siya harayo sa kada usad sa aton, ");
INSERT INTO msb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","kay, ‘Paagi sa iya nabubuhay kita, nagahiwag, kag adi yana,’ pareho san ginsabi san iba sa iyo na mga parasurat, ‘Kita man gayod mga anak niya.’ ");
INSERT INTO msb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kay kita mga anak san Dios, dili naton paghunaon na an Dios pareho san porma san oro, o plata o bato na amo an ginhimo susog sa kaisipan kag paagi san kamot san tawo. ");
INSERT INTO msb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sadto na panahon san wara pa kaaram sa iya an mga tawo ginpabayaan lang san Dios an inda ginhimo. Pero niyan nagsugo siya na an mga tawo sa tanan na lugar magbasol kag magbaya sa inda pagkasala. ");
INSERT INTO msb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kay nagbutang na siya sin adlaw na pagahusgaran niya sa kamatuudan an kinab-an paagi sa iya ginpili na tawo. Tungod sani naghatag an Dios sin pruwiba sa tanan paagi sa pagbuhay sana mismo na tawo hali sa kamatayon.” ");
INSERT INTO msb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Niyan, pakabati ninda kan Pablo na nagsurmaton manungod san pagkabuhay gihapon hali sa kamatayon, may iba na nagtuya-tuya, pero may iba naman na nagsabi, “Gusto namon mabati na magsurmaton ka gihapon manungod sani.” ");
INSERT INTO msb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Tapos ginbayaan ni Pablo an pagtiripon. ");
INSERT INTO msb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero may iba na nag-upod sa iya kag nagtuod san ginsabi niya. Usad na sani si Dionisio na myimbro san konseho san Areopago, may babayi man na an ngaran si Damaris kag may iba pa gayod. ");
INSERT INTO msb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pakatapos sani, naghali si Pablo sa Atenas kag nagpakadto sa Corinto. ");
INSERT INTO msb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Didto may nakasugat siya na Judio na an ngaran si Aquila na taga-Pontus hali pa lang sa Italia kaupod an iya asawa na si Priscila. Adto sinda kay nagsugo an hadi na si Claudio na maghali sa Roma an tanan na mga Judio. Usad sin adlaw nagbisita kanda Aquila si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kay pareho man an inda pangabuhay paagi sa paghimo sin tulda, nag-istar siya didto kag nagtrabaho kaupod ninda. ");
INSERT INTO msb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sa kada Adlaw San Pagpahuway nagapahayag siya manungod kan Jesu-Cristo sa sinagoga, kag nagatalinguha gayod na madara sa pagtuod an mga Judio kag mga Griego. ");
INSERT INTO msb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pag-abot ninda Silas kag Timoteo hali sa Macedonia, nasisibot si Pablo sa pagpahayag, nagapamatuod sa mga Judio na an Cristo amo si Jesus. ");
INSERT INTO msb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","San ginkontra man kag ginpakaraot ninda si Pablo, ginpagpag niya an iya bado susog sa inda ugali kag nagsabi, “Kun mawara kamo sa pagtuod, bahala na kamo sa iyo sadiri! Dili niyo ako mababasol. Tuna niyan magapahayag na lang ako sa mga dili-Judio.” ");
INSERT INTO msb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kaya naghali siya kag nagpakadto sa balay san tawo na an ngaran Tito Justo na usad man siya na nagasamba sa Dios. An balay sani katakin san sinagoga. ");
INSERT INTO msb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","An namumuno naman san sinagoga didto amo si Crispo. Ini siya nagtuod man sa Ginooʼn Jesus kaupod san iya bilog na panimalay. Damo man na mga tawo sa Corinto na nakabati san katukduan ni Pablo an nagtuod kag nabunyagan. ");
INSERT INTO msb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Usad sin gab-i an Ginoo nagsabi kan Pablo sa pangitaon, “Dili ka mahadlok kundi magpadayon pagsurmaton kag dili mag-udong, ");
INSERT INTO msb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kay kaupod mo ako kag waraʼn malabot sa imo dahilan na kadamuan didi sani na syudad mga katawuhan ko.” ");
INSERT INTO msb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kaya, mga usad ka tuig may tunga nag-istar didto si Pablo na nagapangtukdo san katukduan hali san Dios sa inda. ");
INSERT INTO msb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ugaling san si Gallio an gobernador san Acaya, nagbiriyo an mga Judio sa pagdakop kan Pablo kag gin-upod siya sa korte. ");
INSERT INTO msb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","An sabi ninda, “Ginahidara sani na tawo an katawuhan na magsamba sa Dios sa paagi na kontra sa Kasuguan.” ");
INSERT INTO msb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pero san masurmaton na kuntani si Pablo, nagsabi si Gallio sa mga Judio, “Kun ini sala na himo o kasal-an, may rason ako na magpamati sa iyo na mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero kay ina suruay manungod sa mga surmaton, mga ngaran kag sadiri niyo na Kasuguan, kamo na mismo an maghusay sana. Dili ako an mahusgar sana.” ");
INSERT INTO msb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kaya, ginpahali niya sinda sa korte. ");
INSERT INTO msb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tapos, gindakop naman san mga Griego si Sostenes an namumuno sa sinagoga kag ginbunal sa atubangan san korte. Pero wara ini pagmangnuha ni Gallio. ");
INSERT INTO msb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pakatapos sani na pangyayari nag-istar pa didto si Pablo sin madugay-dugay, tapos nagpaaram sa mga kamaranghod kag naglayag pakadto sa Siria kaupod sinda Priscila kag Aquila. Pag-abot ninda sa Cencrea, ginpakagis an iya buhok kay may panuga siya sa Dios. ");
INSERT INTO msb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nakaabot man sinda sa Efeso kag didto ginbilin sinda ni Pablo. Tapos, nagsulod siya sa sinagoga kag nakisuay sa mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Paghangyo ninda na magdugay anay siya didto, wara siya magtugot. ");
INSERT INTO msb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kundi san pagpaaram na niya sa inda, nagsabi na magabalik siya sa inda kun sa pagbuot san Dios. Tapos, naglayag na siya hali sa Efeso. ");
INSERT INTO msb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pagdungka sa Cesarea, nagkadto siya sa Jerusalem kag ginpangumusta an mga nagatuod. Pakatapos nagpadayon pa-Antioquia. ");
INSERT INTO msb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pakaistar niya didto sin madugay-dugay, naglakat kag nagpanglugar-lugar sa Galacia kag Frigia na ginpakusog an pagsarig san mga disipulos. ");
INSERT INTO msb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Niyan, may Judio na an ngaran si Apolos na taga-Alejandria na nakaabot man sa Efeso. Maayo gayod siya sa pagsurmaton kag may maayo na kaaraman sa Banal Na Kasuratan. ");
INSERT INTO msb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Gintukduan siya manungod sa Ginoo, kag sa dako niya na paghandom nagsurmaton kag nagtukdo siya sin tama manungod kan Jesus. Ugaling an aram niya hasta lang sa pagbunyag ni Juan. ");
INSERT INTO msb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Makusog an buot na nagtuna siya pagsurmaton sa sinagoga pero pakabati sa iya ninda Priscila kag Aquila, gin-agda siya kag gintukduan pa sin tama gayod san pangyayari kan Jesus pakapatay ni Juan. ");
INSERT INTO msb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","San maghandom siya na magtabok sa Acaya, ginbuligan siya san mga kamaranghod sa pagtuod kag nagsurat sa mga disipulos na padayunon siya. Pag-abot niya didto, ginbuligan niya an mga tawo na paagi sa pagkamaluluy-on san Dios nagtuod kan Jesus. ");
INSERT INTO msb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nahimo ini kay nadaog gayod niya an mga Judio sa inda suruay sa atubangan san kadamuan kag ginpamatuudan niya hali sa Banal Na Kasuratan na si Jesus amo an Cristo na parasalbar na ginapaabot san mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Myintras si Apolos adto sa Corinto, nag-agi naman si Pablo sa kabukidan kag nakaabot sa Efeso. Didto may nakita siya na iba na mga disipulos. ");
INSERT INTO msb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ginhunga niya sinda, “Nano, napakada sa iyo an Espirito Santo san nagtuod kamo?” Nagsabat sinda, “Wara, dili pa gayod ngani namon nabatian na may Espirito Santo.” ");
INSERT INTO msb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Naghunga gihapon si Pablo, “Pan-o man kamo nabunyagan?” “Paagi sa bunyag na ginahimo ni Juan,” an sabat ninda. ");
INSERT INTO msb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nagpadayon si Pablo, “An pagbunyag ni Juan para sadtoʼn mga nagbasol san inda kasal-an, tapos ginasabihan an mga tawo na magtuod sa maabot na kasunod niya na amo si Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pakabati ninda sani, nabunyagan sinda sa ngaran san Ginoo na si Jesus. ");
INSERT INTO msb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Tapos, san gindapatan sinda ni Pablo san iya mga kamot, napakada sa inda an Espirito Santo. Kaya ginpasurmaton sinda sin manlain-lain na lenggwahi na dili ninda masabutan kag nagsurmaton san ginpasabi sa inda san Dios. ");
INSERT INTO msb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mga dose sinda tanan. ");
INSERT INTO msb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Uruadlaw nagsulod naman si Pablo sa sinagoga kag sa sulod sin tulo ka bulan nagsurmaton na makusog an buot. Nakisuay gayod siya kag nagtalinguha na mahidara sinda manungod sa paghadi san Dios. ");
INSERT INTO msb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero may iba na nagpasutil kag habo magtuod. Pagpakaraot pa ninda sa katukduan manungod sa Ginooʼn Jesus sa atubangan san tanan, ginbayaan sinda ni Pablo kaupod san iya mga disipulos. Tapos, uruadlaw gin-istoryahan ninda Pablo an mga tawo manungod kan Jesus sa lugar ni Tiranio na amo an ginatiripunan. ");
INSERT INTO msb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nagpadayon ini sa sulod san duha ka tuig. Kaya, an tanan na taga-Asia, mag-Judio man kag mag-Griego, nakabati san katukduan manungod sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Niyan, makangangalas na gayod an mga milagro na ginhimo san Dios didto paagi kan Pablo. ");
INSERT INTO msb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kaya, bisan mga panyo o mga pangsuon na gindup-ot sa iya gindara sa mga masakiton. Naaayo sinda kag nagaluwas an mga maraot na espirito sa inda. ");
INSERT INTO msb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Niyan, may iba na mga Judio na nagakadto sa manlain-lain na lugar agod magpaluwas man san mga maraot na espirito sa mga tawo. Nagtalinguha sinda na gamiton an ngaran san Ginooʼn Jesus sadtoʼn may mga maraot na espirito paagi sa pagsabi, “Ginasugo ko kamo na magluwas sa ngaran san Ginooʼn Jesus na ginapahayag ni Pablo.” ");
INSERT INTO msb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","An nagahimo sani amo an pito na anak san pinakanamumuno na padi san mga Judio na si Esceva an iya ngaran. ");
INSERT INTO msb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero nagsabat sa inda an maraot na espirito, “Kilala ko si Jesus kag si Pablo, pero sin-o man kamo?” ");
INSERT INTO msb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Didi gin-atakihan sinda san tawo na may maraot na espirito. Ginlabu-labo sinda, kay grabe an kusog sani. Tapos, ginsakop sinda kag nadaog. Kaya, nagdaralagan naman sinda paluwas san balay na huba kag nagkasaramadan. ");
INSERT INTO msb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Naaraman ini san tanan na mga taga-Efeso, mag-Judio man o mag-Griego. Tapos, nagkaharadlok sinda tanan kag gin-galang an ngaran ni Ginooʼn Jesus. ");
INSERT INTO msb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kaya, kadamuan sadtoʼn mga nagatuod an nagaatubang sa inda pagtiripon, nag-ako kag naghayag san mga maraot na ginahimo ninda. ");
INSERT INTO msb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Damo man sadtoʼn nagahimo sin salamangka an nagtipon san inda mga libro kag ginsunog sa atubangan san tanan. Pakakwenta ninda san halaga sani, nakaabot sa sobra sin un milyon pisos. ");
INSERT INTO msb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kaya an surmaton san Ginoo naglukop gayod kag naglabaw. ");
INSERT INTO msb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Niyan pakatapos sani na pangyari, nakaisip si Pablo na mag-agi sa Macedonia kag Acaya pakadto sa Jerusalem. Nagplano siya na pakatapos didto, kinahanglan na magkadto man siya sa Roma. ");
INSERT INTO msb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pakasugo niya sin duha san iya kabulig na sinda Timoteo kag Erasto pa-Macedonia, nag-istar anay siya sa probinsya san Asia. ");
INSERT INTO msb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sana man na panahon, nagkaigwa sin kasamok didto sa Efeso dahilan sa katukduan manungod sa Ginoo. ");
INSERT INTO msb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sugad sani an nangyari: may parahimo sin diosdiosan na plata na an ngaran si Demetrio. Nagahimo siya sin istatwa ni Artemis hali sa plata, kaya, dako man an ganansya sa iya mga trabahador. ");
INSERT INTO msb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Niyan, gintiripon niya sinda tanan kaupod an iba na an trabaho pareho man san sa inda kag ginsabihan, “Mga Kaigmanghudan, aram niyo na hali sani na pangabuhay an aton kayamanan. ");
INSERT INTO msb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nakikita kag nababatian niyo mismo ini si Pablo na ginapasunod kag ginapatuod an damo na mga tawo, dili lang an mga taga-Efeso kundi haros sa bilog na probinsya san Asia, na dili kuno matuod na dios an hinimo san tawo. ");
INSERT INTO msb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","May delikaduhan man na masira an aton negosyo kag dili lang ina kundi mawawar-an sin paggalang an templo man san pinakadiosa na si Artemis. Pwera pa sana mawawaraʼn pulos an pagkahalandon niya na ginasamba sa bilog na probinsya san Asia kag kinab-an.” ");
INSERT INTO msb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pakabati sani san kadamuan, nagkaururit kag nagtuna pagsiriyak, “Halandon gayod si Artemis, diosa san mga taga-Efeso!” ");
INSERT INTO msb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kaya, nagkasaramok an bilog na syudad kag nagharagunos an mga katawuhan pakadto sa inda ginatiripunan na guyud-guyod sinda Gayo kag Aristarco na taga-Macedonia na kaupod ni Pablo sa iya paglakat. ");
INSERT INTO msb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Gusto gayod ni Pablo na magsulod man agod magpahayag sa mga katawuhan pero ginpugulan siya san mga disipulos. ");
INSERT INTO msb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","May iba man na mga otoridad san probinsya na mga amigo niya na nagpasugo sa iya. Naghangyo naman sinda na dili siya magpakita sa ginatiripunan. ");
INSERT INTO msb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nagkasaramok an tanan, kaya an iba nagsiriyak sin lain man sa iba kag an kadamuan sa inda dili gali maaram kun nano kay nagtiripon sinda. ");
INSERT INTO msb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Niyan, si Alejandro gintulak paunhan san mga Judio kag may iba sa kadamuan na nagsiyak sin mga tugon. Nagsenyas siya san iya kamot na gusto niya magpahayag sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero san siya makilala ninda na Judio, nagdurungan sinda pagsiyak sin mga duha ka oras, “Halandon gayod si Artemis, diosa san mga taga-Efeso!” ");
INSERT INTO msb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tapos, idtoʼn tagapamahala san lungsod nagpapuyo sa mga tawo kag nagsabi, “Mga katawuhan san Efeso, nano, dili aram na san tanan na an syudad san Efeso amo an tagapamahala san templo san halandon na Artemis kag san banal na bato na nahulog hali sa langit? ");
INSERT INTO msb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Sa nakikita ta na ini dili man masupak, dapat magpuyo na lang kamo kag dili na magharus-haros. ");
INSERT INTO msb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nasabi ko ini kay gindara niyo ini didi na mga tawo na dili man nangawat sa templo kag dili man nagpakaraot san aton diosa. ");
INSERT INTO msb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kaya, kun may reklamo sa kanin-o man si Demetrio kag san iya mga trabahador, abyirto an mga korte kag may mga magahusgar. Kaya, paakusara sinda. ");
INSERT INTO msb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ugaling, kun may kinahanglan pa kamo, pagahusayon ina sa dati na adlaw san pagtiripon. ");
INSERT INTO msb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Dapat mag-uruli na kita kay delikado kita na maakusar sin pagsaramok niyan na wara man kita sin dahilan na makapamatuod sani na kasamok.” ");
INSERT INTO msb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pakasabi sani, ginpauli na niya an kadamuan. ");
INSERT INTO msb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pakatapos san kasamok, gintiripon ni Pablo an mga disipulos kag pakapakusuga san inda buot nagpaaram na, tapos naglakat na pa-Macedonia. ");
INSERT INTO msb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pakalibuta niya san mga lugar sani kag napakusog pa gayod an mga buot san mga nagatuod didto, nakaabot siya sa Grecia. ");
INSERT INTO msb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nag-istar siya didto sin tulo ka bulan. Myintras nagahanda na siya pakadto sa Siria, naaraman niya na may plano kontra sa iya an mga Judio, kaya nag-isip siya na magbalik paagi sa Macedonia. ");
INSERT INTO msb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gin-updan siya ni Sopater na taga-Berea, anak ni Pirro. Nag-upod man sinda Aristarco kag Segundo na taga-Tesalonica, si Gayo na taga-Derbe, si Timoteo kag an mga taga-Asia na sinda Tiquico kag Trofimo. ");
INSERT INTO msb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nag-una sinda paglayag pa-Troas kag naghulat didto sa amon. ");
INSERT INTO msb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Naglayag naman kami hali sa Filipos pakatapos san Pyista San Tinapay na Waraʼn Lebadura. Sa sulod sin lima ka adlaw naabutan namon sinda sa Troas diin nag-istar kami sin pito ka adlaw. ");
INSERT INTO msb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sa una na adlaw san semana, nagtiripon kami para sa pagpihak-pihak san tinapay sa pagdumdom san urhi na panigab-i san Ginoo. Didi nagsurmaton si Pablo sa mga tawo kag nagpadayon hasta tungaʼn gab-i kay mahali na siya pagkaaga. ");
INSERT INTO msb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Damo sin mga ilaw didto sa ginatiripunan namon na kwarto sa ibabaw san balay. ");
INSERT INTO msb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Niyan, may nagaingkod sa may pasamano na batan-on na lalaki na an ngaran Eutico. Nakaturog siya myintras nagapadayon si Pablo pagsurmaton. San turog na gayod siya, nahulog sa duta hali sa ikatulo na eskalon kag paghakwat ninda sa iya patay na. ");
INSERT INTO msb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pero naglusad si Pablo kag ginsakom niya na nagsabi, “Dili kamo mahandal kay buhay pa siya.” ");
INSERT INTO msb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pagsaka gihapon ni Pablo kag ginpihak-pihak an tinapay tapos nagkaon, nakisurmaton pa siya sa inda hasta sa kaagahon. Pakatapos, naghali na siya. ");
INSERT INTO msb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Gin-uli ninda an batan-on na buhay kag nalipay gayod sinda. ");
INSERT INTO msb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nakaisip si Pablo na maglakat pakadto sa Ason pero gintugon niya sa amon na mag-una kami sa sarakyan kag maglayag pakadto didto. Tapos, pagapasakayon namon siya didto. ");
INSERT INTO msb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pagsugat niya sa amon sa Ason, ginpasakay namon siya, tapos nagpakadto kami sa Mitilene. ");
INSERT INTO msb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Hali didto nakaabot kami sa Quio pagkasunod na adlaw. Pagkaotro na adlaw nakaabot kami sa Samos kag sa masunod pa gayod na adlaw nakaabot kami sa Mileto. ");
INSERT INTO msb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Gin-isip ni Pablo na dili mag-agi sa Efeso agod dili siya madugay sa probinsya san Asia kay nagadali siya na makaabot sa Jerusalem kun mahimo antes san adlaw san Pentecostes. ");
INSERT INTO msb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Hali sa Mileto nagpasugo siya sa Efeso kag ginpatawag an mga namumuno san mga nagatuod. ");
INSERT INTO msb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pagtiripon ninda nagsabi si Pablo: “Kamo mismo an nakaaram kun nano an akon pagkabuhay sa tanan na oras myintras kaupod niyo ako, tuna san una na adlaw pag-abot ko sa Asia. ");
INSERT INTO msb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nagsirbe ako sa Ginoo na mapainubuson kag may pagtangis dahilan sa mga pasakitan na nag-abot sa akon paagi sa mga himo san mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aram niyo na wara ako magduha-duha pagtukdo sa iyo sin nano man na makabulig. Nagatukdo pa gayod ako sa iyo sa kadamuan kag sa mga balay. ");
INSERT INTO msb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pareho man gayod an pagtukdo ko sa mga Judio kag mga Griego na dapat sinda magtuod sa Dios kag magbaya san inda pagkasala, amo man san pagtuod sa aton Ginooʼn Jesu-Cristo. ");
INSERT INTO msb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Niyan, ginpirit ako sa espirito na mapakadto sa Jerusalem na dili ko aram kun nano an mangyayari didto sa akon, ");
INSERT INTO msb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","pwera lang na nagpadaan sa akon an Espirito Santo sa kada syudad na nakaagi kami na nagahulat an prisuhan kag kastigo sa akon. ");
INSERT INTO msb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pero dili ko gayod ginapahalagahan an akon buhay agod, sa katapusan sana, matapos man an trabaho na ginhatag sa akon san Ginooʼn Jesus na amo an pagtestigo san Maayo Na Barita san kaluoy san Dios. ");
INSERT INTO msb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Niyan, kitaa, aram ko na an tanan sa iyo na ginpahayagan ko san pagahadi san Dios dili na ako makikita pa gihapon. ");
INSERT INTO msb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kaya, ginatestigo ko sa iyo niyan na adlaw na dili ako mababasol kun may mawara sa iyo sa kamatuudan, ");
INSERT INTO msb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kay wara ako magduha-duha pagtukdo sa iyo san bilog na katuyuan san Dios. ");
INSERT INTO msb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bantayi an iyo sadiri kag san tanan na katawuhan na ginpaniwala sa iyo san Espirito Santo. Atamanon gayod niyo an mga nagatuod sa Dios na nagin sadiri niya paagi sa dugo san iya sadiri na anak. ");
INSERT INTO msb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","“Maaram ako na pagbaya ko may mga buwaon na paratukdo bagaʼn mga maisog na hayop na magasulod sa iyo kag dili ninda pagapalibrihon an mga nagatuod sa kalukuhan. ");
INSERT INTO msb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Maabot man an oras na may mga maluwas sa iyo mismo kaurupod na magasurmaton sin mga buwa agod magpasunod sa mga disipulos. ");
INSERT INTO msb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kaya, magmaikmat, dumdumon niyo na sa sulod san tulo ka tuig wara ako mag-udong pagtukdo sa iyo sa kada adlaw kag gab-i na may tangis sa pagkahadlok na may habo magtuod. ");
INSERT INTO msb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Niyan, ginapaniwala ko kamo sa pag-ataman san Dios kag sa iya mga surmaton na may pagkamaluluy-on. Amo ini an nakapakusog sa iyo kag makahatag sin irensyahon kaupod sadtoʼn tanan na mga nalinisan na san sala. ");
INSERT INTO msb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Wara ako maawa sa bisan kanin-o kwarta, oro, o bado. ");
INSERT INTO msb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kamo mismo nakaaram na nagtrabaho ako san akon mga kinahanglan kag sadtoʼn mga kaupod ko. ");
INSERT INTO msb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Paagi sani na pagtrabaho sin ungod sa tanan ginpakita ko sa iyo na dapat kita magbulig sa mga maluya kag nagadumdom mismo san ginsabi san Ginooʼn Jesus, ‘Mas malipay an nagahatag ki sa nagabaton.’,” ");
INSERT INTO msb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pakasurmaton ni Pablo, nagluhod kag nangadyi siya kaupod ninda tanan. ");
INSERT INTO msb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nagatarangis sinda tanan myintras ginasakom kag ginaharukan si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nagkamurundo gayod sinda tungod sa iya ginsurmaton na dili na sinda magakirita pa. Pakatapos, gindul-ong ninda siya sa may sarakyan sa dagat. ");
INSERT INTO msb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Paghali namon sa mga namumuno sa Efeso, naglayag na kami diretso pakadto sa Cos. Pagkaotro adlaw sa Rodas naman kag hali didto pakadto sa Patara. ");
INSERT INTO msb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pakakita namon sin sarakyan na magatabok pakadto sa Fenicia, nagsakay kami kag naglayag naman. ");
INSERT INTO msb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pakakita namon san Cipre, naglabay lang kami sa timog sana, tapos, nagpadayon pa-Siria kag nagdungka sa Tiro kay madiskarga didto an sarakyan sin mga kargamento. ");
INSERT INTO msb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Didto nakigkita kami sa mga nagatuod kaya nag-istar kami kaupod ninda sin pito ka adlaw. Ginsabihan ninda si Pablo paagi sa poder san Espirito Santo na ada sa inda na dili magpadayon sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Pero, pakatapos san amon pag-istar didto, nagpaaram na kami agod magpadayon sa amon pagbiyahe. Sinda tanan kaupod san inda mga asawa kag mga anak nag-upod sa amon pakadto sa luwas san syudad kag didto sa baybayon nagluhod kami sa pagpangadyi. ");
INSERT INTO msb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pakapaaram na, nagsakay na kami kag sinda naman nag-uruli na. ");
INSERT INTO msb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Hali sa Tiro nagpadayon kami sa Tolemaida. Pag-abot didto, ginpangumusta namon an mga kamaranghod sa pagtuod kag nag-istar kaupod ninda sin usad ka adlaw. ");
INSERT INTO msb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pagkaaga naghali na kami didto kag nagpa-Cesarea. Didi nagdayon kag nag-istar kami sa balay ni Felipe na paratukdo san Maayo Na Barita. Usad siya sa pito na mga pinili sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","May upat siya na anak na daraga na may regalo na magsurmaton kun nano an mangyayari sa maabot na panahon. ");
INSERT INTO msb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Myintras adto kami sin pira ka adlaw, may nag-abot na propeta hali sa Judea na an ngaran si Agabo. ");
INSERT INTO msb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nagtulos siya sa amon kag ginkuha an paha ni Pablo. Tapos, gin-gapos an sadiri niya na mga tiil kag mga kamot na nagasabi, “Amo ini an ginasabi san Espirito Santo, ‘Sugad sani an mga Judio sa Jerusalem gagapuson an tag-iya sani na paha kag iintriga sa mga dili-Judio.’,” ");
INSERT INTO msb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Pakabati namon sani, nakimaluoy kami kag san mga tawo didto kan Pablo na dili siya magkadto sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pero nagsabat siya, “Nano kay nagatangis kamo kag nagapasakit san akon tagipusuon? Aram man niyo na handa na ako dili lang na mapriso kundi bisan mamatay sa Jerusalem alang-alang sa Ginooʼn Jesus.” ");
INSERT INTO msb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","San dili siya mahidara, nag-udong na lang kami kag nagsabi, “Matuman lugod an pagbuot san Ginoo.” ");
INSERT INTO msb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kaya, pakatapos sani na mga adlaw naghanda na kami kag nagkadto sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","May iba man na mga disipulos hali sa Cesarea na nag-upod sa amon. Gin-giyahan ninda kami didto sa amon pagaistaran sa balay ni Mnason. Taga-Cipre siya na dugay na disipulos. ");
INSERT INTO msb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Pag-abot namon sa Jerusalem, maayo man an pagpadayon sa amon san mga kamaranghod sa pagtuod. ");
INSERT INTO msb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pagkaotro adlaw, nag-upod sa amon si Pablo pakadto kan Santiago. Adto naman didto an tanan na mga namumuno san mga nagatuod. ");
INSERT INTO msb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ginkumusta sinda ni Pablo, tapos ginsumat niya an tanan na ginhimo san Dios para sa mga dili-Judio paagi sa iya pagpahayag san Maayo Na Barita. ");
INSERT INTO msb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pakabati ninda sani, gin-umaw ninda an Dios. Tapos, may ginsabi sinda sa iya, “Aram mo, kamanghod, may mga linibo na Judio didi na mga nagtuod kag tanan sinda ginasunod gayod an Kasuguan. ");
INSERT INTO msb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ginsumatan sinda manungod sa imo na ginatukduan mo kuno an tanan na mga Judio na nagaistar sa katakin san mga dili-Judio na pabayaan kuno an Kasuguan ni Moises kag ginsabihan na dili pagturion an inda mga anak o magsunod sa mga kaugalian. ");
INSERT INTO msb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Niyan, sigurado makabati gayod sinda na nag-abot ka na. Kaya, nano an himuon ta? ");
INSERT INTO msb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Ini na sasabihon namon sa imo an dapat mo himuon. May upat didi na lalaki na may panuga. ");
INSERT INTO msb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Iupod ini sinda kag mag-intra ka sa inda sa seremonyas san paglinis pero bayadan mo an inda gastos agod magpakagis man sinda san inda buhok. Sani na paagi makaaram an tanan na dili matuod an mga sabi-sabi manungod sa imo kundi ikaw mismo nabubuhay sa pagtuman san Kasuguan. ");
INSERT INTO msb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Manungod naman sa mga dili-Judio na nagatuod, nagpadara kami sin surat sa inda na nagkauruyunan kami na dili sinda magkaon san ginhalad sa mga diosdiosan, san hayop na gintuok kag san dugo, kag maglikay sa kalaw-ayan.” ");
INSERT INTO msb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kaya, gin-upod ni Pablo idtoʼn mga lalaki. Pagkaotro adlaw ginhimo niya an seremonyas san paglinis kaupod ninda kag nagsulod sa templo para ipaaram sa mga padi kun san-o matatapos an mga adlaw san paglinis kag kun san-o mahalad san sakripisyo para sa kada usad sa inda. ");
INSERT INTO msb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","San matatapos na an pito na adlaw san seremonyas, may mga Judio hali sa probinsya san Asia na nakakita sa iya sa sulod san templo. Kaya ginpasaramok ninda an mga katawuhan, tapos gindakop si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Nagsiriyak sinda, “Mga katawuhan san Israel, bulig kamo! Amo ini an tawo na nagatukdo sa tanan na lugar kontra sa mga Judio, sa Kasuguan kag sani na templo. Pwera pa sani, may mga Griego man na gin-upod pa niya sa templo, kaya paagi sani bagaʼn ginpaati niya iniʼn banal na lugar.” ");
INSERT INTO msb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Nasabi ninda ini kay dili pa lang dugay nakita ninda si Trofimo na taga-Efeso kaupod ni Pablo sa syudad kag gin-isip ninda na ginpasulod naman ni Pablo sa templo. ");
INSERT INTO msb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dahilan sani nagkasaramok an bilog na syudad. Nagdurungan pagdalagan an mga tawo, tapos gindakop si Pablo kag gin-guyod paluwas san templo. Tapos, ginsirahan dayon ninda an pwertahan sani. ");
INSERT INTO msb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Myintras ginatalinguha ninda patayon si Pablo, may nagbarita sa pinakanamumuno san mga suldados na Romano na nagakasaramok an bilog na Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nagpatiripon dayon siya sin mga suldados kag inda mga namumuno, tapos, nagpakadto sa mga katawuhan. Pakakita ninda sa mga suldados kag san pinakanamumuno, nag-udong sinda pagpalo kan Pablo. ");
INSERT INTO msb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pakatapos nagtulos an pinakanamumuno, ginpadakop si Pablo kag ginpagapos ini sa duha na kadena. Naghunga kun sin-o siya kag kun nano an iya ginahimo. ");
INSERT INTO msb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","May iba na nagsiriyak sin lain man sa iba. Kaya, kay dili niya maaraman an kamatuudan tungod sa kasamok, ginsugo niya na darhon si Pablo sa kwartel. ");
INSERT INTO msb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pag-abot ninda sa hagdanan haros ginaalsa na siya san mga suldados kay dili ninda mapugulan an mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nagsunod naman dayon an grupo san mga katawuhan na nagasiriyak, “Pataya siya!” ");
INSERT INTO msb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","San isusulod na si Pablo sa kwartel, naghangyo siya sa pinakanamumuno, “Sir, pwede ako makisurmaton sa imo?” Naghunga naman an pinakanamumuno, “Nano, makasurmaton ka sin Griego? ");
INSERT INTO msb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Dili ba ikaw an taga-Ehipto na dili pa lang dugay nagtuna sin araway kag naggiya sin upat ka libo na mga rebelde pakadto sa kadlagan?” ");
INSERT INTO msb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nagsabat si Pablo, “Judio ako, hali sa Tarso na sakop san Cilicia. Pumuluyo ako sani na kilala na syudad. Kaya, ginahangyo ko sa imo na pasurmatunon ako sa mga katawuhan.” ");
INSERT INTO msb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pakatuguti sa iya, nagtindog si Pablo sa hagdanan, nagsenyas san iya kamot sa mga tawo. Tapos, san magpuruyo na an tanan, nagsurmaton siya sa inda sa Hebreo. ");
INSERT INTO msb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mga kaigmanghudan kag mga kamagurangan, pamatii an ipapahayag ko manungod sa akon sadiri,” an sabi ni Pablo. ");
INSERT INTO msb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pakabati ninda na ginasurmatunan sinda sa Hebreo na lenggwahi, nagin mapuyo pa gayod sinda. Tapos, nagpadayon si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Judio ako na gin-anak sa Tarso, usad na syudad na sakop san Cilicia, pero nagdako sani na syudad sa pagtukdo ni Gamaliel. Gintukduan ako sin maayo manungod sa Kasuguan san aton kalulululuhan kag nagasunod gayod sa Dios pareho sa iyo yana. ");
INSERT INTO msb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“Ginpasakitan ko man anay agod ipapatay an mga parasunod san ginatawag na Paagi san Ginoo. Bisan mga lalaki o mga babayi gin-gapos kag ginpriso ko. ");
INSERT INTO msb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sugad man na makatestigo sa akon an pinakanamumuno na padi kag san bilog na konseho. May mga surat ngani ako hali sa inda para sa aton mga kalahi na Judio sa Damasco agod ipaaram sa inda an tuyo ko didto. Kaya, nagpakadto ako para arestaron idtoʼn mga parasunod kag darahon na nakagapos sa Jerusalem agod kastiguhon.” ");
INSERT INTO msb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Nagpadayon pa si Pablo, “San nagapahalapit na ako sa Damasco, mga alas dose na kaadlawan sadto, may masilaw na ilaw hali sa langit na bigla na lang nagpawa sa akon. ");
INSERT INTO msb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Natumba ako sa duta kag nakabati sin boses, ‘Saulo, Saulo, nano kay ginapersigir mo ako?’ ");
INSERT INTO msb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Nagsabat ako, ‘Sir, sin-o ka man?’ “Nagsabat siya sa akon, ‘Ako si Jesus na taga-Nazaret na ginapersigir mo.’ ");
INSERT INTO msb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Niyan, idtoʼn mga kaupod ko nakakita san ilaw pero wara kabati san boses na nagasurmaton sa akon. ");
INSERT INTO msb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Didi ako naghunga, ‘Nano an hihimuon ko, Ginoo?’ “Nagsabat an Ginoo sa akon, ‘Magtindog ka kag magkadto sa Damasco. Didto sasabihan ka san ipapahimo sa imo.’ ");
INSERT INTO msb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","San dili ako makakita tungod san kapawa san ilaw, ginkabit na lang ako sadtoʼn mga kaupod ko kag nakaabot kami sa Damasco. ");
INSERT INTO msb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“May tawo didto na an ngaran si Ananias. Nagasunod gayod siya sa aton Kasuguan kag ginagalangan san tanan na mga Judio didto. ");
INSERT INTO msb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Naghalapit kag pakatindog sa katakin ko nagsabi, ‘Kamanghod na Saulo, makakita ka lugod gihapon.’ Sana mismo nakakita ako sa iya. ");
INSERT INTO msb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nagsabi naman siya, ‘An Dios san aton kalulululuhan nagpili sa imo agod maaraman mo an iya pagbuot kag makita man an Matanos na Suruguon na si Jesus kag mabati mismo an iya boses. ");
INSERT INTO msb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Magigin testigo ka sa mga tawo para sa iya manungod san imo nakita kag nabati. ");
INSERT INTO msb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Niyan, nano kay nagahulat ka pa? Tindog kag magpabunyag ka, kag malinisan ka sa imo mga kasal-an paagi sa pag-ayò sa iya sin kapatawadan.’ ");
INSERT INTO msb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Pagbalik ko sa Jerusalem kag nagapangadyi sa templo, may pangitaon ako. ");
INSERT INTO msb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Didi nakita ko an Ginoo na nagsabi sa akon, ‘Pagdali-dali kag humali ka dayon sa Jerusalem kay dili ninda pagabation an imo pagpamatuod manungod sa akon,’ ");
INSERT INTO msb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nagsabat ako, ‘Ginoo, sinda mismo nakaaram na nagkadto ako sa kada sinagoga kag gindakop idtoʼn nagatuod sa imo, tapos ginpapriso ko sinda kag ginpabunal. ");
INSERT INTO msb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pwera pa sani, adto ako mismo nagaasikaso san mga bado san mga nagpatay kan Esteban na imo testigo. Nagatindog ako didto na nagauyon san inda ginahimo.’ ");
INSERT INTO msb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Nagsabi man siya sa akon, ‘Maglakat ka, kay susuguon ko ikaw sa harayo pakadto sa mga dili-Judio.’,” ");
INSERT INTO msb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Namati sinda hasta nasambitan ni Pablo an mga dili-Judio, tapos nagsiriyak gayod, “Patya siya, kay dili siya angay mabuhay.” ");
INSERT INTO msb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Myintras nagasiriyak sinda, ginapaypay an inda mga bado kag nagasaburak sin alpog paibabaw susog sa inda ugali kun maurit. ");
INSERT INTO msb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","An pinakanamumuno naman san mga suldados nagsugo na darhon si Pablo sa kwartel, tapos bunalon siya agod maaraman ninda an kamatuudan kun nano kay nagasiriyak an katawuhan kontra sa iya. ");
INSERT INTO msb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pero san gin-gapos na siya, naghunga sa usad na namumuno san mga suldados na nagatindog didto, “Tama kaya sa iyo layi na magbunal sin pumuluyo san Roma na dili pa ngani napamatuudan kun may sala?” ");
INSERT INTO msb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pakabati sani, nagkadto an namumuno sa inda pinakanamumuno kag naghunga, “Sir, kitaa, kay an sabi sani na tawo na Romano man gayod siya! Nano kaya an himuon naton kay aram mo na bawal magbunal san Romano kun wara pa mahusgari?” ");
INSERT INTO msb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kaya nagkadto naman kan Pablo an pinakanamumuno kag naghunga man sa iya, “Sabihi ako, nano, Romano ka man gayod?” Nagsabat siya, “Opo”. ");
INSERT INTO msb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nagpadayon an pinakanamumuno, “Nagin Romano man ako paagi sa pagbayad sin damo na kwarta.” “Nagsabat si Pablo, ‘Pero gin-anak ako na Romano.’,” ");
INSERT INTO msb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kaya idtoʼn mga mausisa kuntani kan Pablo nagharali dayon. Nahadlok man an pinakanamumuno san naaraman niya na si Pablo pumuluyo na Romano kag ginpagapos pa niya siya. ");
INSERT INTO msb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Pero pagkaaga, sa paghandom na maaraman an matuod na dahilan kun nano kay gin-akusar san mga Judio si Pablo, ginpatangkas san pinakanamumuno an gapos sani kag ginpasuguan an mga pinakanamumuno san kapadian kag san tanan na konseho para magtiripon. Pakatapos, gintawag si Pablo kag ginpaatubang sa inda. ");
INSERT INTO msb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Si Pablo naman ginturok an mga konseho kag nagsabi, “Mga kaigmanghudan, nabuhay ako na malinis an pag-iisip hasta yana sa atubangan san Dios.” ");
INSERT INTO msb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Dahilan sani an pinakanamumuno na padi na si Ananias nagsugo sadtoʼn mga nagatindog sa katakin ni Pablo na sampadungon ini sa baba. ");
INSERT INTO msb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pero nagsabi naman si Pablo sa iya, “Sasampadungon ka san Dios, ikaw na nagapakitaʼn tawo! Nagaingkod ka dida para husgaran ako susog sa Kasuguan, pero kontra sa Kasuguan na ginsugo mo na sampadungon ako!” ");
INSERT INTO msb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Idto man na mga tawo na halapit kan Pablo nagsabi, “Ginapakaraot mo an pinakanamumuno na padi san Dios?” ");
INSERT INTO msb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nagsabat si Pablo na, “Mga kaigmanghudan, dili ko aram na siya an pinakanamumuno na padi. Pasensya na lang ako kay nasurat sa Banal Na Kasuratan, ‘Dili ka magpakaraot san nagahadi san imo katawuhan.’,” ");
INSERT INTO msb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Niyan, san mapanginanuhan ni Pablo na mga Saduceo an iba sa grupo kag an iba naman mga Pariseo, nagsiyak siya sa konseho, “Mga kaigmanghudan, ako Pariseo kag anak man ako sin mga Pariseo. Ginpaatubang ako didi dahilan lang sa paglaom na mabubuhay gihapon an mga patay.” ");
INSERT INTO msb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pakasabi niya sani, nagsuruay an mga Saduceo kag mga Pariseo, kaya, natungà an mga nagatiripon. ");
INSERT INTO msb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nangyari ini kay sa paghuna san mga Saduceo waraʼn pagkabuhay gihapon kag wara man sin anghel o espirito. Pero sa paghuna naman san mga Pariseo, ginakilala ini tanan. ");
INSERT INTO msb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kaya, nagtuna pagkusog an siriyak. May iba na mga paratukdo san Kasuguan sa grupo san Pariseo na nagtirindog kag nakisuay, “Wara kamiʼn nakikita na sala sani na tawo. Basi may espirito o anghel na nagsurmaton man gayod sa iya!” ");
INSERT INTO msb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","San naggrabe na an suruay, an pinakanamumuno san mga suldados na nahahadlok na basi burugnuton si Pablo, nagsugo sa mga suldados na maglusad kag piriton siya pagkuhaa sa inda kag darahon siya sa kwartel. ");
INSERT INTO msb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pagkagab-i sana, an Ginoo nagtindog sa may tungod ni Pablo kag nagsabi, “Pakusuga an imo buot kay pareho san imo pagpamatuod manungod sa akon didi sa Jerusalem, magapamatuod ka man didto sa Roma.” ");
INSERT INTO msb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","San adlaw na, may mga Judio na nagplano kag nagsumpa na dili magkaon o mag-inom hasta na dili ninda mapatay si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Sobraʼn 40 an nagkauruyon sani. ");
INSERT INTO msb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tapos, nagkadto sinda sa mga namumuno na padi kag mga namumuno san mga Judio kag nagsabi, “Nagsumpa gayod kami na dili magkaon hasta na dili mapatay namon si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Niyan, kamo kag san mga konseho, magpaaram sa pinakanamumuno na darhon si Pablo sa iyo na bagaʼn aaramon gayod niyo sin maayo an manungod sa iya. Tapos, handa na kami na patayon siya antes makahalapit.” ");
INSERT INTO msb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pero an anak na lalaki san kamanghod ni Pablo na babayi nabati an inda plano, kaya nagkadto kag nagsulod sa kwartel para isumat kan Pablo. ");
INSERT INTO msb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pakatapos, nagtawag si Pablo sin namumuno san mga suldados kag ginsabihan, “Darha ini na batan-on sa pinakanamumuno san suldados kay may sasabihon siya.” ");
INSERT INTO msb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kaya, gin-upod niya ini pakadto sa pinakanamumuno kag nagsabi, “An priso na si Pablo gintawag ako kag naghangyo sa akon na darahon ini na batan-on sa imo kay may sasabihon siya.” ");
INSERT INTO msb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ginkabit siya san pinakanamumuno, gin-upod sa higad kag ginhunga, “Nano an sasabihon mo sa akon?” ");
INSERT INTO msb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nagsabat an batan-on, “An mga Judio nagkauruyon na hangyuon sa imo na darhon si Pablo sa konseho buwas na bagaʼn uusisahon siya. ");
INSERT INTO msb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pero ayaw pagtuguti kay sobraʼn 40 san inda mga katawuhan an nagahulat sa pag-agi niya dahilan na nagsumpa sinda na dili makaon o mainom hasta na dili mapatay ninda si Pablo. Yana ngani handa na sinda na nagahulat san pag-uyon mo.” ");
INSERT INTO msb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kaya, ginpauli na san pinakanamumuno an batan-on kag gintugon gayod, “Ayaw pagsumat bisan kanin-o na ginsumatan mo ako sani.” ");
INSERT INTO msb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Pakatapos may gintawag na duha na namumuno san mga suldados an pinakanamumuno kag nagsabi, “200 na mga suldados an ihanda niyo kaupod sin 70 na nakakabayo kag 200 man na parapana na magpakadto hasta sa Cesarea sa alas nuebe yana na gab-i. ");
INSERT INTO msb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pasakayon man si Pablo sa kabayo kag darhon siya na waraʼn kaanuhan kan Gobernador Felix.” ");
INSERT INTO msb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tapos, nagpadara siyaʼn surat na sugad sani: ");
INSERT INTO msb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Halandon na Gobernador Felix, kumusta. Ini na surat hali sa akon, si Claudio Lisias. ");
INSERT INTO msb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Ini na tawo gindakop sanmga Judio kag san papatayon na kuntani ninda naabutan ko kag san mga suldados, kaya ginlibre san maaraman namon na Romano gali siya. ");
INSERT INTO msb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Sa paghandom na maaraman kun nano kay gin-akusar siya, gin-upod namon siya sa konseho. ");
INSERT INTO msb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Naaraman ko na gin-akusar siya manungod sa inda Kasuguan, pero wara man siya sin ginhimo na kinahanglan na siya patayon o prisuhon. ");
INSERT INTO msb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kaya san may nagsumat sa akon na may plano kontra sa iya, ginsugo ko dayon pakada sa imo kag ginsugo ko man an mga nag-akusar sa iya na magpahayag sa imo kun nano an gindilian ninda sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Didi nagsunod an mga suldados sa ginsugo sa inda. Ginkuha ninda si Pablo kag gindara sana mismo na gab-i hasta sa Antipatris. ");
INSERT INTO msb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pagkaaga, an mga nagaralakat na mga suldados an nagbalik sa kwartel pero nagpadayon an mga suldados na nakakabayo kaupod ni Pablo. ");
INSERT INTO msb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pag-abot ninda sa Cesarea gintunol sa gobernador an surat kag gin-intriga man sa iya si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pakabasa san surat, ginhunga kun tagadiin siya. Pakaarami naman na si Pablo taga-Cilicia, ");
INSERT INTO msb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nagsabi an Gobernador, “Bibistahon ko ikaw kun mag-abot na an mga nag-akusar sa imo”. Pakatapos, pinabantayan niya si Pablo sa palasyo ni Herodes. ");
INSERT INTO msb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pakatapos san lima ka adlaw, nagkadto sa Cesarea an pinakanamumuno na padi na si Ananias kaupod san mga namumuno san mga Judio kag san abugado na si Tertulo. Ginsabi ninda sa gobernador an inda mga sumbong kontra kan Pablo. ");
INSERT INTO msb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pakatawaga kan Pablo, nagtuna si Tertulo pag-akusar sa iya, “Kagalang-galang na gobernador, tungod san imo paggobyerno nagakaigwa gayod kami sin kalinaw kag paagi san imo kadunungan damo na an mga kabag-uhan na ginhimo para sani na nasyon. ");
INSERT INTO msb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sa tanan na paagi kag bisan diin man ginaako namon ini na may pasalamat. ");
INSERT INTO msb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Pero habo ko na maulang ka pa, kaya ginahangyo ko na pamatian kami sin kadali na may maayo na kaburut-on. ");
INSERT INTO msb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Nakita namon na ini na tawo usad na nagaparatuna sin mga kasamok. Ginapasamok niya an mga Judio sa bilog na kinab-an kag usad siya san mga namumuno san grupo san mga Nazareno. ");
INSERT INTO msb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ginporbar pa ngani niya na intrimison an templo, kaya gindakop namon siya. Huhusgaran kuntani namon siya susog sa amon Kasuguan, ");
INSERT INTO msb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","pero nag-abot an pinakanamumuno san mga suldados na si Lisias kag gin-agaw siya sa amon, tapos, ginsugo an mga nag-akusar sa iya na magpakadi sa imo. ");
INSERT INTO msb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Sa pag-usisa mo mismo sa iya, maaaraman mo an tanan na amon ginaakusar sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","An mga Judio nag-uyon man sa akusasyon kag nagapamatuod na an tanan nangyari man gayod susog sa iya ginsabi. ");
INSERT INTO msb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","San ginpasabot siya san gobernador na magsurmaton, nagsabat si Pablo: “Naaraman ko na dugay na panahon nagin huwes ka sani na nasyon, kaya ginakalipay ko na magdepensa san akon sadiri sa atubangan mo. ");
INSERT INTO msb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kun imo susihon, maaaraman mo na wara pa nagsobra sin dose ka adlaw tuna san pagkadto ko sa Jerusalem para magsamba. ");
INSERT INTO msb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wara man ako makita san mga Judio na nakigsuay kanin-o man o nagapasamok bisan sa templo o sa sinagoga o sa syudad. ");
INSERT INTO msb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Dili man ngani sinda makapamatuod sa imo san nano man na ginaakusar ninda kontra sa akon. ");
INSERT INTO msb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Pero ini an aakuon ko sa imo: nagasamba ako sa Dios san amon mga kalulululuhan susog sa Paagi san Ginoo na ginasabi ninda na dili susog sa Kasuguan san mga Judio. Pero nagatuod man ako san tanan na ginsurat sa Kasuguan kag sa mga ginsurat san mga propeta. ");
INSERT INTO msb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","May paglaom ako sa Dios na may pagkabuhay gihapon para sa tanan na tawo, bisan san matanos o dili matanos, na ginaako man ngani ninda. ");
INSERT INTO msb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Kaya, pirme ako nagatalinguha na wara akoʼn sala sa Dios o sa mga tawo. ");
INSERT INTO msb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Niyan, pakatapos sin pira ka tuig na wara ako sa Jerusalem, nagbalik ako para magdara sin mga limos kag mga halad. ");
INSERT INTO msb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Myintras ginahimo ko ini nakita ninda ako sa templo pakatapos na ginhimo ko an seremonyas san paglinis. Wara didto sin mga katawuhan o kasamok. Pero may iba na mga Judio hali sa probinsya san Asia na adto man didto. ");
INSERT INTO msb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Dapat adi sinda sa atubangan mo para mag-akusar kun igwa man gayod sinda sin ikakaakusar kontra sa akon. ");
INSERT INTO msb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kay wara ini na mga Judio didi, pasurmatuna sa mga adi didi kun may sala ako san gin-usisa ako san konseho, ");
INSERT INTO msb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","pwera lang sani na ginsiyak ko sa inda atubangan, ‘Adi ako niyan ginaakusar sa iyo atubangan manungod sa pagtuod sa pagkabuhay gihapon san mga patay.’,” ");
INSERT INTO msb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pero si Felix, na may maayo gayod na pagkasabot manungod sa Paagi san Ginoo, gintapos an bista na nagsabi, “Pag-abot ni Lisias na pinakanamumuno huhusgaran ko an iyo kaso.” ");
INSERT INTO msb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pakatapos, ginsugo niya an namumuno san mga suldados na bantayan si Pablo pero hatagan sin dyutay na pagkalibre kag tugutan an iya mga amigo na mag-asikaso san iya mga kinahanglan. ");
INSERT INTO msb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pagkapira ka adlaw, nag-abot si Felix kaupod an iya asawa na si Drusila na Judio man. Ginpasuguan niya si Pablo kag namati sa iya mga ginasurmaton manungod sa pagtuod kan Cristo Jesus. ");
INSERT INTO msb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pagsurmaton ni Pablo manungod sa pagkamatanos, pagdisiplina sa sadiri kag sa maabot na paghusgar, nahadlok si Felix kaya nagsabi, “Maghali ka anay kay kun igwa akoʼn lugar, ipapatawag ta na lang ikaw.” ");
INSERT INTO msb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pero nagalaom pa man siya na hahatagan ni Pablo sin kwarta. Kaya, ginapasuguan niya pirme si Pablo kag nakig-istorya sa iya. ");
INSERT INTO msb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pakatapos sin duha ka tuig, ginbalyuhan si Felix ni Porcio Festo sa pagkagobernador. Pero antes si Felix maghali, kag tungod na nagahandom siya na mapalipay an mga Judio, ginpabayaan niya si Pablo sa prisuhan. ");
INSERT INTO msb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Niyan, mga tulo ka adlaw pag-abot ni Festo didto sa iya probinsya, nagpakadto siya sa Jerusalem hali sa Cesarea. ");
INSERT INTO msb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Didto an mga namumuno na padi kag san mga namumuno san mga Judio ginpaaram siya manungod sa pagkontra ninda kan Pablo. Nagpirit naman sinda paghangyo kan Festo ");
INSERT INTO msb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","na ipabalhin si Pablo sa Jerusalem agod mapalipay sinda. Ginsabi ninda ini kay may plano sinda na abangan sinda Pablo sa dalan pa lang agod patayon siya. ");
INSERT INTO msb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nagsabat si Festo, “Adto si Pablo ginapabantayan na priso sa Cesarea kag ako mismo magabalik didto dayon. ");
INSERT INTO msb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Kaya, paupuda sa akon an iyo mga namumuno kag kun igwa sin sala ini na tawo, paakusara sinda.” ");
INSERT INTO msb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pakaistar niya didto kaupod ninda sin dili magsobra sa walo o napulo ka adlaw, nagpauli siya sa Cesarea. Pagkaotro adlaw nag-ingkod siya sa korte kag ginsugo na paatubangon sa iya si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pag-abot niya, nagtiripon sa iya an mga Judio na nagpakadto hali sa Jerusalem na nagsumat sin mga grabe na akusasyon kontra sa iya na dili man ninda mapamatuudan. ");
INSERT INTO msb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Didi nagdepensa si Pablo, “Wara ako sin nahimo na sala kontra sa Kasuguan san mga Judio o sa templo o kan Cesar.” ");
INSERT INTO msb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pero si Festo na gusto pauyunan an mga Judio nagsabi kan Pablo, “Nano, gusto mo magkadto sa Jerusalem kag didto sa atubangan ko mahusgaran manungod sani na mga akusasyon?” ");
INSERT INTO msb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nagsabat si Pablo, “Nagatindog ako sa atubangan san korte san emperador na si Cesar kun diin ako dapat pagahusgaran. Manungod naman sa mga Judio, ikaw mismo maaram na wara akoʼn nahimo na sala. ");
INSERT INTO msb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kun ugaling nakasala man ako sa Kasuguan kag naghimo sin nano man na angay ako mamatay, dili ako madulag sa kamatayon, pero kun dili matuod an mga sumbong ninda kontra sa akon, waraʼn may poder, bisan sin-o man, na makahatag sa akon sa inda. Magahangyo ako yana na mahusgaran ako ni Cesar.” ");
INSERT INTO msb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Didi nakigsurmaton anay si Festo sa iya konseho, tapos nagsabi kan Pablo, “Nagahangyo ka kan Cesar, kaya sa iya ka magkadto.” ");
INSERT INTO msb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","San pira na ka semana an nag-agi, nagpakadto sa Cesarea si Agripa na hadi kag Berenice para maghatag sin paggalang kan Festo. ");
INSERT INTO msb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Pakaistar ninda didto sin pira-pira na, ginsumat ni Festo sa hadi an kaso ni Pablo, “May priso didi na wara paluwasa ni Felix. ");
INSERT INTO msb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Niyan, san adto ako sa Jerusalem, an mga namumuno na padi kag san mga namumuno man san mga Judio nagsumbong sa akon manungod sa iya kag naghangyo na kondinaron ko siya. ");
INSERT INTO msb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ginsabat ko sinda na dili kaugalian san mga Romano na kondinaron an gin-akusar antes na makaatubang an nag-akusar kag makalugar na magdepensa susog sa akusasyon kontra sa iya. ");
INSERT INTO msb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Kaya, pagtiripon ninda didi, wara ko pagdugaya kundi pag-otro adlaw nag-ingkod ako sa korte kag nagsugo na paatubangon ini na tawo. ");
INSERT INTO msb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Pagtindog san mga nag-akusar, wara sinda mag-akusar sa iya sin nano man na maraot na ginhuna ko na hihimuon ninda, ");
INSERT INTO msb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","kundi igwa sindaʼn ginasuruayan manungod sa inda ginatuudan kag kan Jesus na patay na, pero ginapirit na buhay sabi sani ni Pablo. ");
INSERT INTO msb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tungod kay dili ko aram an hihimuon, naghunga ako sa iya kun gusto niya magkadto sa Jerusalem agod mahusgaran didto manungod sani. ");
INSERT INTO msb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pero san maghangyo si Pablo na ipadayon lang an pagpapriso sa iya hasta sa paghusgar san emperador, ginsugo ko na prisuhon lang gihapon siya hasta na ipadara ko siya kan Cesar.” ");
INSERT INTO msb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Didi nagsabi si Agripa kan Festo, “Gusto ko mismo na mabati ini na tawo.” “Buwas mismo makapamati ka sa iya,” an sabat ni Festo. ");
INSERT INTO msb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kaya, pagkaaga nag-abot sinda Agripa kag Berenice na may grabe na adurno kag matahom na parada. Nagsulod sinda sa dako na kwarto sa pagtiripon kaupod an mga namumuno san kasuldadosan kag an mga kilala na tawo sa syudad. Sa sugo naman ni Festo, ginpasulod si Pablo. ");
INSERT INTO msb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Tapos, nagsabi si Festo, “Hadiʼn Agripa kag an tanan na adi didi, kitaa ini na tawo. Ginreklamo siya sa akon san tanan na katawuhan san Judio didi kag sa Jerusalem. Nagasiyak sinda na dili pa siya dapat mabuhay. ");
INSERT INTO msb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pero, pag-usisa ko, naaraman na wara man siyaʼn nahimo na dapat patayon. Niyan, kay naghangyo siya mismo san paghusgar san emperador, kaya naisip ko na ipadara siya. ");
INSERT INTO msb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ugaling wara ako sin ikakasurat sa Halandon na Emperador manungod sa iya. Kaya, gindara ko siya didi sa atubangan niyo kag lalo na gayod sa imo, Hadiʼn Agripa, na pakatapos na mausisa naton siya, igwa na akoʼn maisusurat. ");
INSERT INTO msb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Nasabi ko ini kay para sa akon, waraʼn rason na magpadara sin priso na dili sabihon an akusasyon sa iya.” ");
INSERT INTO msb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Didi nagsabi si Agripa kan Pablo, “Ginatugutan ko na depensahan mo an imo sadiri.” Pakatapos gin-itsa ni Pablo an iya kamot kag nagpahayag sa iya sadiri: ");
INSERT INTO msb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Hadiʼn Agripa, maswerte ako na sa imo atubangan magdepensa ako san akon sadiri niyan kontra sa tanan na akusasyon san mga Judio. ");
INSERT INTO msb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Nasabi ko ini kay maaram ka gayod san kaugalian kag ginasuruayan san mga Judio. Kaya niyan nagahangyo na ako na pamatian mo na may pagpasensya. ");
INSERT INTO msb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Niyan, aram na san tanan na mga Judio an akon buhay tuna pa sa pagkabata didto sa amon nasyon kag didto man sa Jerusalem. ");
INSERT INTO msb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Aram naman ninda dati na kun magatestigo sinda na nabubuhay ako bilang Pariseo na amo an grupo san amon ginatuudan kag nagasunod gayod san tanan na Kasuguan ni Moises. ");
INSERT INTO msb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Niyan, nagatindog ako didi na mahusgaran kay nagalaom ako sa gintuga san Dios sa aton mga kalulululuhan. ");
INSERT INTO msb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ini an gintuga na ginalauman san amon dose na kalahian na mapasa inda. Dahilan sani, nagaparasamba sinda sa iya adlaw kag gab-i. Pinalangga na Hadi, kaya ginaakusar ako san mga Judio tungod sani na paglaom. ");
INSERT INTO msb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Maayo gayod na magtuod kita tanan na an Dios nagabuhay san mga patay. ");
INSERT INTO msb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Kasadto, ako mismo nagatuod na dapat himuon an tanan sa pagkontra sa pagtuod kan Jesus na taga-Nazaret. ");
INSERT INTO msb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ginhimo ko man ngani ini sa Jerusalem. Dili lang ginpapriso ko an kadamuan na mga diosnon sa otoridad na ginhatag sa akon san mga namumuno na padi, kundi san ginpatay sinda nag-uyon pa ako kontra sa inda. ");
INSERT INTO msb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pirme ko sinda ginakastigo sa mga sinagoga kag nagatalinguha pagpirit na pagpakarauton pa ninda si Jesus. Tapos, sa grabe ko pa ngani na kaurit, ginpasakitan ko sinda hasta man an adto sa harayo na mga syudad. ");
INSERT INTO msb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Tungod sani kaya ako nagpakadto sa Damasco na may otoridad kag mga sugo san mga namumuno na padi. ");
INSERT INTO msb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Niyan, Halandon na Hadi, pagkaalas dose na kaadlawan sadto, may nakita ako sa dalanon sin ilaw hali sa langit na masilaw pa sa adlaw. Nagpawa ini sa patalibod namon san akon mga kaurupod. ");
INSERT INTO msb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","San nagkaturumba kami tanan sa duta, may nabati ako na boses na nagasurmaton sa akon sa Hebreo, ‘Saulo, Saulo, nano kay ginapersigir mo ako? Ikaw man lang an nasasakitan san ginahimo mo. Baga ka man lang an baka na nagasikad sa pampalo san nagaataman sani.’ ");
INSERT INTO msb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Didi ako naghunga, ‘Sir, sin-o ka man?’ “Nagsabat an Ginoo, ‘Ako si Jesus na imo ginapersigir. ");
INSERT INTO msb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Niyan, magbangon ka kag magtindog kay nagpakita ako sa imo agod pilion ka na magin akon suruguon. Dapat ka man magtestigos san mga nakita mo sa akon yana kag sa mga ipapakita ko pa sa imo. ");
INSERT INTO msb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ililibre ko ikaw sa mga kalahi mo na Judio kag sa mga dili-Judio kun diin didto ta ikaw susuguon. ");
INSERT INTO msb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","An hihimuon mo amo an pagpasabot sa inda agod magbaya sinda sa kaduluman san kasal-an pakadto sa kapaw-an san Dios. Agod mahali man sinda sa poder ni Satanas pakadto sa Dios kay agod an inda mga sala mapatawad. Tapos, paagi sa pagtuod sa akon magkaigwa sinda sin lugar kaupod san mga nalinisan san kasal-an.’ ");
INSERT INTO msb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kaya, Hadiʼn Agripa, dili ako nagsupak san langitnon na pangitaon. ");
INSERT INTO msb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Nagpahayag anay ako sa mga tawo didto sa Damasco, amo man sa Jerusalem kag amo man sa bilog na lugar san Judea kag sa mga dili-Judio. Nagpahayag ngani ako na dapat sinda magbasol kag magbaya sa sala tapos magsunod man sa Dios. Tapos naman, nagtugon ako sa inda na dapat sinda magpakita sin pagpatuod san inda pagbasol paagi sa inda mga gawi. ");
INSERT INTO msb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Dahilan sani, gindakop ako san mga Judio myintras adto ako sa templo kag gintalinguha ako patayon. ");
INSERT INTO msb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bisan hasta yana, ginabuligan ako san Dios, kaya nagatindog ako didi sa pagtestigo sa mga kilala na tawo kag sa mga dili kilala. Wara akoʼn ginasabi kundi an mga ginsabi san mga propeta kag ni Moises na mangyayari. ");
INSERT INTO msb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Amo ini an ginsabi ninda na an Cristo dapat magtios, tapos, bilang an mauuna na mabubuhay hali sa kamatayon magpaaram sa amon na mga Judio manungod san ilaw san pagkasalbar kag amo man sa mga dili-Judio.” ");
INSERT INTO msb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Niyan, pagpahayag sani ni Pablo manungod san iya sadiri, ginsiyakan siya ni Festo, “Pablo, nabuang ka na ada! An sobra mo na kaaraman an nakapabuang sa imo.” ");
INSERT INTO msb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pero nagsabat si Pablo, “Halandon na Festo, dili ako nabubuang kundi matuod kag may kadunungan an ginasurmaton ko. ");
INSERT INTO msb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Hadiʼn Agripa, aram ko na makasurmaton ako sa imo na waraʼn kahadlok kay aram mo an manungod sani na ginasurmaton ko. Nakakasiguro ako na wara sani na dili mo aram kay wara ini ginhimo sa patago. ");
INSERT INTO msb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Niyan, Hadiʼn Agripa, nano, nagatuod ka sa mga propeta? Aram ko gayod na nagatuod ka.” ");
INSERT INTO msb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nagsabat naman si Agripa kan Pablo paagi sa hunga, “Nano, ginahuna mo na mapipirit mo ako na magin Kristyano sa kadali lang na panahon?” ");
INSERT INTO msb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nagsabat si Pablo, “Sa kadali o madugay man na panahon, ginaayo ko sa Dios na dili lang ikaw kundi amo man an tanan na mga nakabati sa akon yana na adlaw magin pareho ko man pwera lang sani na pagkakadena.” ");
INSERT INTO msb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pakatapos sani, nagtindog an hadi, an gobernador, si Berenice kag an mga nagairingkod kaupod ninda. ");
INSERT INTO msb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Paghali na ninda, nag-iristoryahan sinda, “Waraʼn ginhimo ini na tawo na dapat patayon siya o prisuhon.” ");
INSERT INTO msb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tapos, nagsabi si Agripa kan Festo, “Nalibre na kuntani siya kun wara maghangyo kan Cesar.” ");
INSERT INTO msb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","San nagkauruyunan na maglayag kami pakadto sa Italia, si Pablo kag san iba na mga priso gindul-ong ninda kan Julio na usad na opisyal san kasuldadosan na Romano na ginngaranan “Kasuldadosan San Emperador”. ");
INSERT INTO msb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Pagpasakay sa amon sa barko na hali sa Adramitio na malarga na pakadto sa mga dungkaan san probinsya san Asia, naglayag kami kaupod ni Aristarco na taga-Tesalonica sa probinsya san Macedonia. ");
INSERT INTO msb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pagkaotro adlaw nakaabot kami sa Sidon. Mabuot man si Julio kan Pablo kaya gintugutan siya na makigkita sa iya mga amigo agod mahatagan san iya mga kinahanglan. ");
INSERT INTO msb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nagpadayon kami hali didto kag tungod kay sungsungon an hangin nagpaagi kami sa salipod na parte san Cipre. ");
INSERT INTO msb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Pakatabok namon sin kadagatan, nag-agi kami sa tungod san Cilicia kag Panfilia, tapos, nakaabot kami sa Mira, usad na lungsod san Licia. ");
INSERT INTO msb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Didto may nakita an opisyal na barko na hali sa Alejandria na mapakadto sa Italia kaya ginpabalhin kami didto. ");
INSERT INTO msb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mahinay lang an amon paglayag sin pira ka adlaw pero sa grabe na kalisudan nakaagi kami halapit sa Gnido. Tapos, kay sungsungon naman an hangin, nag-agi na lang kami sa higad san Salmon, tapos paagi sa salipod na parte san Creta. ");
INSERT INTO msb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Paglayag lang namon halapit sa baybayon kag sa grabe man na kalisod, nakaabot kami sa lugar na ginatawag Maayo na Dungkaan halapit sa syudad san Lasea. ");
INSERT INTO msb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Damo na oras an amon natiawan kag delikado na an pagpadayon san biyahe kay lipas na an adlaw san pag-ayuno kag halapit na an tigbagyuhan. Kaya, ginpadaanan sinda ni Pablo, ");
INSERT INTO msb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mga opisyales, nakikita ko na delikado an aton biyahe kag dako an kasiraan kag kapyerdihan, dili lang sa mga kargamento kag sa barko kundi sa aton man mga buhay.” ");
INSERT INTO msb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pero nagtuod an opisyal sa ginsabi san kapitan kag san tag-iya san barko ki sa kan Pablo. ");
INSERT INTO msb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kaya, kay an dungkaan dili maayo na taguan sa panahon san tighagkutan, an kadamuan nagkauruyon na magpadayon paglayag sa pagtalinguha na makaabot sa Fenice, dungkaan sa Creta na nakaatubang sa amihanan na sulnupan kag timog na sulnupan agod makapalipas didto san tighagkutan. ");
INSERT INTO msb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Niyan, paghuyop sin hinay san hangin hali sa timog, ginhuna ninda na pwede maglayag. Gin-isa ninda an angkla kag naglayag sa halapit lang san baybayon san Creta. ");
INSERT INTO msb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pero wara madugay may makusog na hangin na ginatawag amihan na naghampak hali sa isla. ");
INSERT INTO msb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Naghampak ini sa sarakyan kag dili na namon masugat an hangin, kaya nagpaanod na lang kami. ");
INSERT INTO msb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pag-agi namon sa salipod san nakatungod sa habagat na parte san isla san Cauda. Ginpakarga gayod namon an bote bisan malisod. ");
INSERT INTO msb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Pakakarga ninda sani, ginhugutan an pisi patalibod san katungaan san barko. Sa kahadlok na magsagyad sa mga uruisla sa atubangan san baybayon san Libya, gin-ariya ninda an layag kag nagpaanod na lang. ");
INSERT INTO msb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nagpadayon an makusog na bagyo kaya pagkaotro adlaw, nagtuna sinda pagpangitsa san mga kargamento sa dagat. ");
INSERT INTO msb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Pag-ikatulo naman ka adlaw may ginpangitsa man gihapon sinda na mga garamiton sa barko san inda mismo mga kamot. ");
INSERT INTO msb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","San wara magluwas an adlaw bisan mga bituon sin damo na adlaw, kag an hangin nagpadayon pagkusog, nawara na an amon paglaom na masalbar pa. ");
INSERT INTO msb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Niyan, kay dugay na sinda na waraʼn makaon, nagtindog si Pablo sa atubangan ninda kag nagsabi, “Mga opisyales, dapat namati kamo sa akon kag dili naglayag hali sa Creta. Kun sugad kuntani nalikayan naton ini na kasiraan kag kapyerdihan. ");
INSERT INTO msb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Niyan, ginahangyo ko sa iyo na pakusuga an iyo buot kay wara sa iyo sin mapapatay. An sarakyan lang an masisira. ");
INSERT INTO msb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","“Nasabi ko ini kay sani na gab-i may nagtindog na anghel san Dios sa atubangan ko. Amo ini an Dios na tag-iya sa akon kag an ginasamba ko. ");
INSERT INTO msb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Nagsabi an anghel, ‘Pablo, dili ka mahadlok. Dapat ka makig-atubang kan Cesar. Kaya, kay mabuot an Dios isasalbar ka niya kag san tanan na imo kaurupod.’ ");
INSERT INTO msb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kaya, kusugon niyo an iyo buot kay may pagtuod ako sa Dios na mangyayari ini pareho san ginsabi sa akon. ");
INSERT INTO msb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Pero ki