﻿USE sofia;
DROP TABLE IF EXISTS sofia.mrr_vpl;
CREATE TABLE mrr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mrr_vpl WRITE;
INSERT INTO mrr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","देवुळ इद बूमते लोहतोग़, येसु किर्स्तु, वेना लोप्पा नना रासलाह आतन. सास्त्रमते वेनाङ तादोर-बाबोरा लेका रासिस तासतोर, ओर इह मतोर. येसु (यहुदि जाततोरा पेदामुय्तोग़)अब्रहम मुय्तोना, ओसो दाविद राजाना पुळ्गताहि पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्रहम मुय्तोना मग़ि इसकि पुटिस मतोग़, इसक मुय्तोना मग़ि याकुबि, याकुब मुय्तोह्‌कु बारा मग़्कु पुटिस मतोर. ओरग्डाहि ओर्वोग़ यहुदाल इनवाल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहुदानाङ मग़्कु पर्साल ओसो जेराल, वेरा तलोग़ि तामरि इनदनदु. पर्साना मग़ि एस्रोनि, एस्रोनिना मग़ि अराम. ");
INSERT INTO mrr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","अरामना कूळते आमिनदाबि पुटटोग़, आमिनदाबिना मग़ि नहसोनि, नहसोनिना मग़ि साल्मोन. ");
INSERT INTO mrr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","साल्मोन वेग़ राहबि इनदनद (दुस्रा जाततद) आंचाना संगे जोळेम आतस्के, ओना कूळते बोहजि पुटटोग़. वेग़ बोहजि रूतिना संगे जोळेम आतस्के ओबेदि पुटटोग़,(अद रूति वने दुस्रा जातता आंदु). ओबेदिना मग़ि यीसाल. ");
INSERT INTO mrr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","पया यीसाह्‌कु दाविद राजाल पुटटोग़. मुने बेदु ऊरियाना मुते मता, अद रांडे मुतेना संगे दाविद जोळेम आतस्के, साल्मोन पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","पया साल्मोन राजाना मग़ि रहबामि, रहबामिना मग़ि अबियाल, अबियाना मग़ि आसाल. ");
INSERT INTO mrr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","पया आसाह्‌कु यहोसपति, यहोसपतिह्‌कु योरमि, योरमना कूळते उजियाल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उजियाह्‌कु योतमि, योतमिह्‌कु अहजि, अहजिह्‌कु एजेक्याल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","एजेक्याह्‌कु मनासे, मनासेह्‌कु आमोनि, आमोनिह्‌कु योसियाल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","योसियाना मग़िह्‌कु यकोनियाल, वेना पया ओसो उय्तुर पेकोर पुटटोरे. अद वेलाते बेबिलोन देसेमतोर यहुदि जाततोरगा वासि लळय कीतोर, लळय कीसि यहुदि जाततोर वेल्‍लाटोर लोकुरिनु तमा देसेमते दोहच ओतोर. ");
INSERT INTO mrr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबिलोनते ओरिन दोहच ओतापेग़्के यकोनियाह्‌कु साल्तियाल, साल्तियाह्‌कु जरुबाबेल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुबाबेलिह्‌कु अबिहुदि, अबिहुदिह्‌कु एल्यकिमि, एल्यकिमिह्‌कु अजुराल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजुराह्‌कु सादोकि, सादोकिह्‌कु याकमि, याकमिह्‌कु एलिहुदि पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलिहुदिह्‌कु एलियजरि, एलियजरिह्‌कु मतानि, मतानिह्‌कु याकुबि पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","पया याकुबिह्‌कु योसेपि पुटटोग़. योसेपना मुते मरियालि, तेनाये पोटाताहि कोनि येसु पुट वातोग़, ओने देवुळ लोहतोग़ पिसिह केवाल किर्स्तु इन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","इद्रमलेह्‌का अब्रहम मुय्तोनाहि दाविद राजानगा एवनाह, सबे पोसि चोव्दा तादो-पीळिङ आताङ. ओसो दाविदिनाहि यहुदि लोकुरिन बेबिलोनते दोहच ओस मतोर अव दियाङ एवनाह चोव्दा तादो-पीळिङ आताङ. अहे ओरिनु बेबिलोनते ओतग्डाहि इतेके, देवुळ लोहतोग़ पिसिह केवाना पुटमुळ एवनाह, चोव्दा तादो-पीळिङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","देवुळ लोहतोग़ पिसिह केवाल येसु इद्रम पुटटोग़ इतेके, ओना तलोग़ मरियानु योसेपि ताल्ह्‌किसि पोल्‍लो करल कीस मतोग़. वेर इर्वुर जोळेम आयनामुनेन, अदु नेलाङ हव्कतद दिसता; इदु देवुळता पवित्र जीवाता लावता मेटेन आता. ");
INSERT INTO mrr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","तान ताल्ह्‌कतोग़ कोय्तोग़ योसेपि, अदु नेलाङ हव्कता इन्जि ओग़ पुतोग़. ओग़ कर्तुळ मन्कल मताह्‌कु, तान लोकुरा मुनेह इजक तेंडनायो, इद्रम ओना विचर मता. अदिनेनाह्‌कु नना तान कुस्क्ने विळ्सिसीकन इन्जि, ओग़ विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","तना जीवाते वेग़ इद्रम आलिह कीनेके ऊळाटु, देवुळबाबाना उंद देवतुलि कलाते वासि ओन वेहता, “ए योसेपि, दाविद राजाना पुळ्गतोनिन, मरियाना पोटाते बेद पेनेम मन्ह्‌ता, अदु मन्कना आयो, मति देवुळता पवित्र जीवातेनाहिये मन्ह्‌ता. अदिह्‌क निमा तान ततलाह पेग़्के-मुनेह आयमा. ");
INSERT INTO mrr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","अदु पेकान पुटिह कीयग़ा, ओना पेदिरि येसु (इतेके देवुळि पिसिह कीस्ता) इनजोर तासा. बाराह्‌क इतेके ओग़े तना लोकुरिन, ओरा पापमताहि पिसिह केवाल आयनोग़,” इन्जि देवतुल वेहता. ");
INSERT INTO mrr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","(इव सबे बाराह्‌कु इद्रम आताङ इतेके, वेल्‍लाङे वर्साना मुने, देवुळबाबाल तना कबुरतोना संगे इदिनलोप्पा वेहचि, ऊळाटु, कोय्तोह्‌क अनवदु लेया पिला नेलाङ हव्कग़ा, तान्क पेकाल पुटनोग़. अहे ओना पेदिरि “इमानुवेल” इन्जि तासनुर, इह वेहच मतोग़. “इमानुवेल” इतेके “मावा तोळ देवुळि”, इद्रम अर्तम आस्ता. देवुळि मुने वेहच मताङ इव गोटिङ इंजेके करल आताङ.) ");
INSERT INTO mrr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","पया योसेपि उंजिस तेदताहे देवतुल वेहतपे सबे कीतोग़. अहे मरियानु मर्मिङ कीयलाह लोन ओतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","मतिंगा अदु रिकम आनाह्‌जोमु, ओग़ ताना संगे ऐंगे कलियोग़, कय बोयोग़. तान्क पेकाल पुटटस्के योसेपि ओना पेदिरि येसु तासतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","बेह्‌रोग़ एरोद राजाना कालमते, यहुदा पटटा बेत्लेहेम नाटेनगा येसु पुटिस मतोग़. ताना पया अद पटटा मोदुल सहर येरुसलेमते, बोर उकान ऊळिसि पुनवालोर वातोर. ओर पोळ्‍द पेसनेनाहि वेल्‍लाय जेक देसेमताहि येरुसलेमते वासि, पता कीयलाह बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“यहुदिरा राजाल पुटटोग़ इनजोर तोहतनद उकातुन माट पोळ्‍द पेसना बाजे ऊळतोम, अहे ओन दंडुम अरयकोम इन्जि वातोम. ओग़ पुटटोग़ु बेगाडोग़?” इन्जि वेर उकान ऊळवालोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","(दुस्रोग़ ओसो बोग़ राजाल पुटटोग़), इद कबुर केंजिसि एरोद राजाना जीवा डक इता, अद्रमे एरोद इंजेके बाताल कीयनोग़, इन्जि आलिह कीसि पूरा येरुसलेमतोर वने मिळ्ह्‌कतप आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","पया राजाल यहुदिराङ सबेटोर पेर्मालोरिन ओसो सास्त्रमगूरुरिन, उंदि जागाते जमा कीसि ओरिन ताल्ह्‌कतोग़, “मीवा सास्त्रम वेहतपु, देवुळ लोहवाल राजाना पुटमुळि, बेगा आस मनदग़ा?” इन्जि राजाल ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","अस्के ओर इतोर, “यहुदा पटटा बेत्लेहेम नाटे, महरज! बाराह्‌क इतेके देवुळता मुनेतोग़ कबुरतोग़, सास्त्रमते तेना लोप्पा इद्रम रासिस तासतोग़: ‘ए यहुदा पटटा बेत्लेहेम नाटेनोरिर, मीवाय नाटे नावा इस्रयेललोकुरिन अय केवाल ओर्वोग़ सेह्‌नाल पुटनोग़ इन्जि मीवा नाग़ यहुदा पटटे उड्ला नाग़ इनमाटु,’ इन्जि देवुळ इन्ह्‌ता.” ");
INSERT INTO mrr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","इद पोल्‍लो केंजिसि, एरोद राजाल उकान ऊळवालोरिन “इह वाट,” इन्जि तनगा कुस्क्ने केयतोग़, केयिसि “मीक बेद उका दिसता, तान मीट ऊळतस्केडाहि नेंड एवनाह बेचोक दियाङ आताङ, नाक बराबर वेहाटु,” इन्जि ओग़ु (पुट वाता पेकाना वय्स पुनदलाह) ओरिन बेस ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ओर राजान वेहतापया, राजाल ओरिन बेत्लेहेमतके लोहतोग़, लोहनेके ओरिन नाळेह कीस इतोग़, “मीटु अगा अन्जि ओन पेकान बेस-नेह्‌ना पर्ह्‌काटु. मीक दोर्कतोग़ इतेके, नाक वासि ओना जाडा वेहाटु, अस्के नना वने अन्जि, ओन दंडुम अरयकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","राजानाङ इव पोल्‍लोङ केंजिसि ओर उकान ऊळवालोरु बेत्लेहेम नाटे दायलाह पेसतोर. पया ऊळाटु, बेद उकातुन ओर पोळ्‍द पेसनके ऊळिस मतोर, अदे उका ओरा मुनेह-मुनेह पेससोर अंदु, पया पेकाल मता लोता पोग़ोन अन्जि रोमता. ");
INSERT INTO mrr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","उका रोमतदिन ऊळिसि, ओरिह्‌क बेचोनो गिर्दा वाता! ");
INSERT INTO mrr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","पया ओरु उका रोमतद लोतगा नेङतोर, अगा पेकानु, ओना तलोग़ मरियानु ऊळतोर, ऊळिसि पेकानाङ काल्क अर्सि, ओरु ओन दंडुम अरतोर. ओसो ओरु तमाङ सोमताङ पेटिनु तेंडिसि, बंगरि, वेल्‍ला दाराता दूपमि, अतर्नेयु, इद्रमताङ पेकाह्‌कु वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","पया वेन पेकान एरोद हव्कनोग़, इदिन देवुळ पुन्जि “एरोद राजानके मल्स अनमाटु,” इन्जि ओरिह्‌कु कलाते कबुर वेहता. अदिह्‌कु ओरु तमा देसेमतके दुस्रा अग़दुह्‌क पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","उकान ऊळवालोर अतापया ऊळाटु, योसेपिन उंदि देवतुल कलाते कलियिसि वेहता, “पेकान हव्कलाहि, एरोद राजाल कोज पेह्‌कसोर मन्ह्‌तोग़. अदिह्‌के निमा तेदा, पेकानु, ओना तलिनु पोसि मिसर देसेमते विता. अहे अग्डाहि मल्स वाटु इन्जि, नना नीक वेहनाह्‌जोम, मीटु अगाने मन्ह्‌टु,” इन्जि वेहता. ");
INSERT INTO mrr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","अदिह्‌क पया योसेपि सीता अरताहे पेकानु, ओना तलिन पोसि, नग़्काडा-नग़्काने मिसर देसेमते पेसिस विततोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","अहे ओरु बेह्‌रोग़ एरोद राजाल हानाह्‌जोम, अद देसेमतेन मतोर, पया मल्स वातोर. नना नावा मग़िनु मिसर देसेमतग्डाहि केयतन इन्जि, वेल्‍लाङे वर्साना मुने देवुळबाबाल तना कबुरतोना संगे वेहचि. ओर मल्स वातस्के, अद कबुर करल आता. ");
INSERT INTO mrr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ओर मुवुर मिसर देसेमते अतापया, उकान ऊळवालोर नाक नाळेह कीतोर इनजोर ऊळिसि, एरोद राजाल पकाय ओङ आतोग़. ओङ आसि, उकान ऊळवालोरिन ताल्ह्‌कता वेलाता लेका कीसि, (वेग़ पुटटोग़ पेकाल रेंड वर्साह्‌क उड्लोग़ मनदनोग़ इन्जि, राजाल पुतोग़. इद्रम गंता कीसि, वेग़ पेकाल बेत्लेहेमतेन इंजेक मनदनोग़ इन्जि,) बेत्लेहेमते ओसो तानाङ एरेगूरेताङ नाह्‌कने, बोर रेंड वर्सानोर ओसो ओरिह्‌काय उड्लोर पेकोर मतोर, ओरगा सीपय्किन लोहचि, ओरिनु कतमे हव्कनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","देवुळता कबुरतोग़ यिर्मयाल वेल्‍लाङ वर्साना मुने वेहतद मता, अद इह मन्ह्‌ता: रामा इनदनद नाटे, दुकमते आस्कनाङ अळयनाङ, केयनाङ, बेरा आल्का वेनदा वाता. रागो तनाङ पिलाङ-पेकोर हातोर इन्जि अळयह्‌ता. ओर हाताह्‌कु, अदु मेक्‍र्ने मनदा पग़वो आंदु. बेत्लेहेमतोर पेकोरिन हव्कतस्के इद पोल्‍लो करल आता. ");
INSERT INTO mrr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","एरोद राजाल हातापया, मिसर देसेमते योसेपना लोतोर मनेके उंद देवतुल कलात कलियिसि ओन वेहता, ");
INSERT INTO mrr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“योसेपि, पेकान हव्कलाह ऊळिंदुर, ओर हातोर. निमा इंजेके तेदिसि पेकानु, ओसो ओना तलिन पोसि, इस्रयेल देसेमते मल्स अन,” इता. ");
INSERT INTO mrr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","अदिह्‌क पया ओग़ तेदिसि, पेकानु ओसो पेकाना तलिनु पोसि, इस्रयेल देसेमते मल्स वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","मति यहुदा पटटे अर्केलाल राजाल तना तपे बेरोग़ एरोदिना जागाते राजेम कीस्तोग़, तेन केंजिसि ओग़ अद पटटे दायलाह रेयतोग़. ओसो कलाते देवुळता कबुर दोर्कताह्‌कु, यहुदा पटटुन विळ्सिसि गालिल पटटे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अगा एव्सि ओग़ु नासरेत इनदनद (मरियाना) नाटे अन्जि जागा आतोग़. “ओन नासरेततोग़ इनदनुर,” इद्रम देवुळता कबुरतोर, देवुळ लोहवाल राजाना लोप्पा मुने वेहच मतोर, अद इंजेके करल आता. ");
INSERT INTO mrr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","वेल्‍लाङ वर्साङ आताङ, येसु बेर्सतोग़. अव दियाने पापमताहि मिळ्न्दनद सीना इनजोरे, लोकुरिन देवुळता पेदिरते योहन इनवाल एते मीहन्दोग़. वेग़ु यहुदा पटटा पेळ्ह्‌कल बूमते देवुळता कबुर वेहचोर वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“देवुळि मन्कलोरगा राजेम कीयनद कगो एवयलाह आता. अदिह्‌क मीटु मीवा पापमताहि मिळ्न्दिसि देवुळतके वाटु,” इद्रम वेग़ वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","वेल्‍लाङे वर्साना मुने देवुळता कबुरतोग़ यसयाल इनवाल, पवित्र सास्त्रमते रासिस तासतोग़, अद इह मन्ह्‌ता, पेळ्ह्‌कल बूमते केयवाना उंदि बेरा आल्का वेनदा वास्ता: “सामि मीवा जीवातगा वायना इन्जि, ओना अग़दुन तीर्ह्‌काटु, ओना वायनद अग़दुन कसुम कीम्ह्‌टु.” इद्रम रासतोग़. इंजेके योहन पेळ्ह्‌कल बूमते वातस्के, अद पोल्‍लो करल आता. ");
INSERT INTO mrr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","मुनेता कालमते एलियाल कबुरतोना लेह्‌का, योहननाङ केग़यनाङ केनकेनेताङ, इतेके रूटुह्‌कनाङ केल्कने कोटटद गेंदे उहन्दोग़, नंडटुह्‌कु तोलाता पेटा दोहन्दोग़. ओना तिंडि इतेके पापेङ, ओग़्वेनेय अचोने मंदु. ");
INSERT INTO mrr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","वेना वेहता कबुरतुन केंजिसि, येरुसलेम सहरतोर, यहुदा पटटाङ नाह्‌कनोर, योर्दन बेरेग़कचुलतोर, इद्रम वेल्‍लाटोरे वेनाङ केंजलाह वांदुर. ");
INSERT INTO mrr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ओर तमा कीता पापमतुन कबुल आसि, योर्दन बेरेटगा वासि, योहनना कयदे देवुळता पेदिरते एग़ मींदुर. ");
INSERT INTO mrr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","मति यहुदिराङ पेदल्कना रेंड तुंगानोर, उय्तुर परुसिर इनवालोर, उय्तुर सदुकिर इनवालोर, वेर वेल्‍लाटोरे योहननके, माक वने एते मीहा इनजोर वातोर. मति योहन ओरिन इतोग़, “ए वीसमतरस्कना लेह्‌काडोरिर! पापमता अग़दाहि देवुळतके मलवालेवा, (वेट देवुळता पेदिरते एग़ मीतेके), देवुळि ईयनद सिक्साताहि माट पिन्ह्‌ट अरयकोम इनजोर बाराह्‌क इह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","अदिह्‌के देवुळता पेदिरते एग़ मीयनामुने, मीवा पापमता अग़दाहि मिळ्न्दिसि, सेतेमता कबळ कीस तोहाटु. ");
INSERT INTO mrr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ओसो माट बह मतेकाय अब्रहम मुय्तोना कूळतोरोम, इतेके देवुळ आचतोर लोकुरोम, अदिह्‌क माट पिसकोम इनजोर, मीट मुर्तिये विचर केमाटु. इह केंजाट, देवुळि अब्रहम मुय्तोह्‌क पेकोरिन, इव बंडानग्डाह वने पुटिह कीया पग़यह्‌ता, पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ओसो ऊळाटु, मराता मोदुदुन नळ्कलाहि, देवुळता कयदे मग़्स तयर मन्ह्‌ता. बेद मरा बेसता काया आदो आयग़ा, तान नळ्किस किसतगा वाटिसीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","तमा पापमताहि मिळ्न्दतोर इन्जि तोहतलाह, नना लोकुरिह्‌कु देवुळता पेदिरते सिरप एते मीहवानन आंदन. मति नाक तेला बेह्‌रोग़ ओर्वोग़ डीसातोग़ मन्ह्‌तोग़, ओग़ नावा पया वायनोग़. ओना कादुन इटलाह वने नना ओप्पोन, अचोन नना उड्लोनन! ओग़ देवुळता पवित्र जीवाते ओसो किसते, मीक मीहवाल आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओना कयदे एत मन्ह्‌ता. ओग़ वंजिन एहचिसि, बेसतानु डोमेते दोसनोग़, दोर्बेतुन बारा पिववद किसते बोळ्सिसीयनोग़, इद्रम मीक कीयनोग़,” इन्जि योहन परुसिरिन, सदुकिरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","अस्के पया येसु गालिल पटटाहि पेसिसि, योहनना कयदे देवुळता पेदिरते एग़ मीकन इन्जि, योर्दन बेरेटगा वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","मति योहन येसुनु अह केमा इनजोरे, “नीवाय कयदे नना मीयना लेह्‌का मन्जि, निमा नयके वातिन, इद बहु?” इनजोर योहन येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","अस्के येसु इतोग़, “अहे आयि, बाराह्‌क इतेके देवुळ माकु बह कीयलाह ताना विचर मन्ह्‌ता, अद मारतेक माक बेसु.” अदिह्‌कु योहन “इंगो तेला!” इन्जि अहे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","येसु एतगा मुळ्न्दिसि चट्‌ने पोग़ोन तेदतस्के ऊळाट, पोग़ोटा बूमि पङ्ने आसि,देवुळता जीवा परेवा पिटेलेह्‌का तनगा वास दळ्म अरतदिन, येसु ऊळतोग़! ");
INSERT INTO mrr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","पया पोग़ोटाहि देवुळता आल्का केंज वाता, “वेग़े नावा जीवा कीतोग़ मग़ि, वेना लोप्पा नना पका गिर्दाते मह्‌नन,” इद्रम वेनदा वाता. ");
INSERT INTO mrr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","अस्के देयह्‌कना मुक्यानेनाहि येसुना पट ऊळना गावले इन्जि, देवुळता जीवा ओनु पेळ्ह्‌कल बूमते ओसीता. ");
INSERT INTO mrr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","पया अगा रेंड वीसाङ दियाङ, नग़्का-पियल उपस मताह्‌कु, येसुह्‌कु पकाय कग़्व वसता. ");
INSERT INTO mrr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","अस्के देयह्‌कना मुक्याल येसुना पट ऊळलाह, ओना एरे वास इता, “निमा देवुळता मग़निन मनाह्‌कु, इव बंडानु आरिङ मारियिह कीम,” इता. ");
INSERT INTO mrr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","मति ओग़ इतोग़, “आयो, मन्कल सिरपि तिनदनद तिंडटे पिसोग़ आस्तोग़, मति देवुळता तोडटाहि पेसनद, उंद-उंद पोल्‍लोतुन केंजतेकेन पिसनोग़, इद्रम देवुळता सास्त्रम मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","6","पया देयह्‌कना मुक्याल ओनु पवित्र सहरतगा (इतेके येरुसलेमतगा) ओसि मंदिरता कुपोटगा ओन निल्पिह कीस इता, “निमा देवुळता मग़नन इनजोर इह्‌निन इतेके, इळ्न डेया! नीक बाराय आयो आयग़ा, बाराह्‌क इतेके: नीक काप आडना इन्जि, देवुळि तनाङ देवतुल्किनलोहतग़ा. नीवाङ काल्क चेट पेह्‌चनायो इन्जि, अव नीकु पोग़ोन तमाङ कय्कने एतनुङ, इद्रम सास्त्रम वेहतह्‌ता,” इनजोर देयह्‌कना मुक्याल इता. ");
INSERT INTO mrr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","अस्के तान येसु इतोग़, “आयो! (बय्तळ कबळ कीतेक तेला, देवुळ नाक पिसिह कीयग़ा, इद्रम इन्जि)बोग़े देवुळता पट ऊळनदायो, इह वने पवित्र सास्त्रम वेहतह्‌ता,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ताना पया देयह्‌कना मुक्याल येसुनु उंद पका बेरा मेटाकोकतगा ओता, ओसि ओन्कु दुनियाताङ सबे राजेह्‌क, ओसो अविस्कना सोबातुन तोहता. ");
INSERT INTO mrr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","तोहचि येसुन इता, “ऊळा, इव पूरा नावाङे आंदुङ. निमा नावाङ काल्क अर्सि नाक मोळ्कतिन इतेके, नना नीकु इव कतमे दिसनवु ईकन,” इता. ");
INSERT INTO mrr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","अस्के येसु तान इतोग़, “एय देयमतिन, निमा इग्डाहि विता, बाराह्‌क इतेके देवुळतुने मोळ्कना, तानाये माळना कीयना, इद्रम सास्त्रम वेहतह्‌ता.” ");
INSERT INTO mrr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","पया देयह्‌कना मुक्याल ओन विळ्सिस अता. तेना पया ऊळाट, देवतुल्क अगा वासि, येसुना जीवातुन सितुर कीयलाह, ओसो ओना पिसवग़ता तिंडि ईसि, ओना सेवा कीताङ. ");
INSERT INTO mrr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","अस्के पया योहनिन जेल ओस मतोर इन्जि, येसु केंजतोग़. तेन केंजिसि, ओग़ यहुदा पट विळ्सिसि गालिल पटटे तना नाग़ नासरेत अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","पया नासरेत नाटुन विळ्सिस, कापेर्नाग़ मनदलाह अतोग़. इद नाग़ु गालिल सम्दुरकचुल मता, इद एरियातुन मुनेता कालमते जाबलुन-नाप्‍तलि इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","अह आतस्के, वेल्‍लाङ वर्साङ मुने, यसयाल इनवाल देवुळता कबुरतोग़, बेद कबुर वेहच मतोग़, अद करल आता: ");
INSERT INTO mrr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","योर्दन बेरेटा अबर बाजे मनदनद, गालिल सम्दुरकचुदा जाबलुन-नाप्‍तलिना बूमते, गालिल इनदनद यहुदि आयवोराबूमते ");
INSERT INTO mrr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ईकळते उदतपु पापमते मतोरु, देवुळता बेरा वेह्‌च ऊळनुर. बेगा लोकुर देवुळता जीवालेवा हातप मन्ह्‌तोर, अगाने ताना वेह्‌च दींचग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","अस्केडाहि देवुळता पोल्‍लो येसु वेहता बोटटोग़: “देवुळि मन्कलोरगा राजेम कीयनद कगो एवयलाह आता. अदिह्‌क मीटु मीवा पापमताहि मिळ्न्दिसि, देवुळतके वाटु,” इद्रम वेग़ वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","उंदि दिया येसु गालिल सम्दुरकचुलिये ताकसोर अनेके, सिमोनि, आंद्रेयाल वेर तमोग़ इर्विरिन ऊळतोग़ (सिमोनना दुस्रा पेदिरि पत्रु मता). वेर मीन्क पोयवालोरु, तमाङ वदिङ सम्दुरलोप्पा आहन्दुर. ");
INSERT INTO mrr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","येसु अस्के ओरिन इतोग़, “दट नावा संगे. मीट इचानाह मीन्क पोयंदिर, मति इंजेके मीटु मन्कलोरिन नयगा तवालोरिर आयकिर, अद्रम नना मीक कीकन, वाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","इदिन केंजिसि, वदिन अगान विळ्सिसि, वेर तमोग़ इर्वुर येसुना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","अग्डाहि पेसिस मुनेह अनेके, ओसो जेबेदि इनवानाङ इर्वुर मग़्कु, याकुबि ओसो ओर्वोग़ योहनि, वेर दिसतोर. वेरु तमा तपेना संगे ओडातगा उदिसि, तमाङ वदिन ओर्कुल कीयलाह आसि. ओरिन वने “नावा संगे वाट,” इनजोर येसु केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","केयतस्के चट्‌नेन वेरु ओडातुन, तमा तपेन अगान विळ्सिसि, येसुना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","पया ओराङ पार्तनाताङ लोह्‌कनगा देवुळता पोल्‍लो काग़्हचोरे, देवुळि लोकुरगा राजेम कीयनदिना लोप्पा बेसता कबुर पोकुर कीसोरे, अहे लोकुराङ सबे रोगह्‌किन, दुकिनु सव्रे कीसोरे, पूरा गालिलमेंड येसु तनाङ कग़यवालोर बार तिरियतोर. ");
INSERT INTO mrr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","येसुनाङ कीताङ कबस्क पूरा सुरिया पटमेंड आबुर आताङ. अस्के सबे रीतिनाङ रोगह्‌कने ऊटेम आस मतोरु, कुर्मुटटप आतोरु, पटापुटा नोयनद दुकतोरु ओसो देयह्‌क पोयतोरु, कुळ्न्दिल रोगह्‌कनोरु, कय्क-काल्क वाग़तोरु, इद्रम सबे रोगह्‌कनोरिन येसुनके ततोर. ततस्के येसु सबेटोरिन सव्रे कीसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","पया गालिल, दाकपालिस, यहुदा, योर्दन बेरेटा अबरता बूमि, इव पटिनाहि, अहे येरुसलेम सहरताहि लोकुर, गोह्‌डिनाङ गोह्‌डिङ येसुना पयाह अंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","अस्के पया अद मांदतुन ऊळिसि, येसु गुड्रापोग़ोन अतोग़, अन्जि काग़्हतलाह उदतोग़. ओग़ उदतस्के, ओनाङ कग़यवालोर ओनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","पया येसु ओरिन काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“बोर माट पापमतोरोम इन्जि देवुळतुन पर्ह्‌किह्‌तोर, ओर देवुळता देय्वातोर. देवुळबाबाल अद्रमतोरिह्‌के राजाल आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“बोर दुकमते अळयह्‌तोर, ओर देवुळता देय्वातोर. देवुळि ओरिन मानेह कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“बोरु माट उड्लोरोम इन्ह्‌तोर, ओर देवुळता देय्वातोर. देवुळ पूना बूम पुटिह कीयग़ा अस्के, ओरिह्‌के आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“देवुळता सेतेमते ताकलाह बोरु उनडा वसतप अहे कग़्विह्‌क आतप मन्ह्‌तोर, ओर देवुळता देय्वातोर. देवुळि ओरिन पंजिह कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“बोरु दुस्रोरिन जीवा लोपतप मन्ह्‌तोर, ओर देवुळता देय्वातोर. ओरिन इंका देवुळ जीवा लोपतप मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“बोरु तमाङ जीवाङ देवुळतगाने तासिह्‌तोर, ओर देवुळता देय्वातोर. बेस्काय उंद दिया ओरु देवुळतुन ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“बोरु लोकुरा कोंटेतुन माय्‍पिह कीसि, गूनम कीयलाह ऊळिह्‌तोर, ओर देवुळता देय्वातोर. ओरिन देवुळि नावाङ मग़्क-मयास्कनिर इनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“बोरिह्‌कु देवुळता सेतेमते ताकनेनाह्‌क दुस्रोर तिपल कीस्तोर, ओर देवुळता देय्वातोर. देवुळबाबाल अद्रमतोरिह्‌के राजाल आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“नावा पेदिर मीक अरताह्‌कु लोकुर बेस्के मीकु पास्कनुर, तिपल कीयनुर, अहे मीवा अडम मताङ-लेवाङ जोल कूदिङ वळ्ह्‌कनुर, अस्के मीट देवुळता देय्वातोरिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","अवटे मीट गिर्दाते एंदना-पाग़ना कीम्ह्‌टु, बाराह्‌क इतेके देवुळदीपते देवुळि मीकु बेरा इनम ईयग़ा. मीवा मुनेतोर देवुळता कबुर वेहवालोर पेदल्किह्‌कु अद्रमलेह्‌काने विरुद वाता, ओरा पोग़ोन वने देवुळि गिर्दा आंदु. ");
INSERT INTO mrr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“(इह केंजाट, मीटु ओवुर तिंडटगा वाटटाह्‌के मिटस आस्ता, ओसो अद अवो वने. अद्रमे) मीटे इद बूमता ओवुरलेह्‌का आंदिर. (दुनियातोरा लाग्वा बुद वीळनदायो इन्जि, मीट सेतेमताङ कबस्क कीम्ह्‌टु.) मति ओवुरता मिटस अतु बार इतेके, अद ओवुर मुनेतलेह्‌का ओसो आयग़ाया? पया अदिन पलते पोहचीतस्के, मन्कलोर काल्कने ओय्कना-विह्‌कना कीतस्के, ताना बातय कबळ अरवो. ");
INSERT INTO mrr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“मेटापोग़ोन उदता सहर नग़्का-पियल सबेटोरिह्‌क दिसिह्‌ता, मको, अद्रमलेह्‌का मीटे इद दुनियाता वेह्‌चलेह्‌का आंदिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","चिमलि नीर्विह कीसि, बह डूटलोप्पा तासिह्‌तोरा? आयो, तान बोव्लापोग़ोन तासतस्के, लोन अंता वेह्‌च आस्ता. ");
INSERT INTO mrr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","इद्रमलेह्‌का मीवाङ सेतेम कबस्क लोकुरा मुनेह वेह्‌चलेह्‌का दिसिङ. अस्के ओर अव कबस्किन ऊळिसि, देवुळदीपते मनवाल मीवा बाबान मान ईयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“मोसानाङ अडोनु, अहे देवुळता कबुरतोरा सास्त्रमतुन, पाय्‍पिह कीयलाह नना वातन, इद्रम मीटु मुर्तिय विचर केमाटु. नना इतेक पाय्‍पिह कीयलाह आयो, मति सास्त्रमतुन पूरा करल कीयलाह वातन. ");
INSERT INTO mrr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","इह केंजाट, नना सेतेम वेहतह्‌नन, पोग़ोटा बूमि, इळ्ता बूमि बूळेम आनाह्‌जोम, पूरा सास्त्रम करल आयवालेवा, अडोना सास्त्रमते रासतविनग्डाहि उंद गीता, उंद सुनेतेला मायो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","अदिह्‌कु बोराय इचीटा अडोतुन माळोर, ओसो दुस्रोरिन वने अहे तमा मतप काग़्हतह्‌तोर, ओरु देवुळ राजेम कीयना लोकुरगा, सबेटोरिह्‌क उड्लोर आयनुर. मति बोर इव अडोनु माळिह्‌तोर, ओसो अहे काग़्हतह्‌तोर, ओरु देवुळ राजेम कीयना लोकुरगा बेरोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","इंजेके सास्त्रमगूरुर, परुसिर देवुळता पोल्‍लोतुन कर्तुळते नोमिह्‌तोर इह्‌निर बहे. मति नना मीकु वेहतह्‌नन इतेके, वेरिह्‌काय वीळिस मीट देवुळता पोल्‍लोतुन माळवालेवा, मीकु देवुळ राजेम कीयना लोकुरगा जागा दोर्को आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ ‘निमा बोने हव्कनायो. हव्कवाल नेयम जोकना सिक्सातगा अरयनोग़,’ इद्रम देवुळि मुनेतोर पेदल्किन वेहच मता, तेन मीट पुतिरे. ");
INSERT INTO mrr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","मति इंजेके नना मीक वेहतह्‌नन, बोग़ तना ऐंगेटोनु उगसे ओङ कीस्तोग़, ओग़ वने देवुळता नेयम जोकना सिक्सातगा अरयनोग़. ओसो बोग़ तना ऐंगेटोना कदर रेहतह्‌तोग़, ओग़ु यहुदि जाततोराङ पेदल्कना बेरा कोरटटगा दांड निहतनोग़. ओसो बोग़ दुस्रोनु ‘एय, पिसा-बय्तळि!’ इद्रम इन्ह्‌तोग़, ओग़ु देयह्‌कना मळ्गना किसबटटा सिक्सातुह्‌क ओजनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“अदिनेनाह्‌कु ओकावेला निमा नीवा कोडि मंदिरता गर्यातगा वाटलाह ओय्ह्‌निन, अस्के बोग़ विस्वसि नीवा अडम गुरागुरा मन्ह्‌तोग़ इन्जि, अगा तेना सीता बार नीक वाता इतेके, नीवा कोडि गर्यामुनेह अगाने अहे तासा, अह कीस पेसिस अन. मुने नीवा अडमतोग़ विस्वसिना संगे ईनाह-आनाह कलियिसि, गूनम आम्ह्‌टु. पया अग्डाह मल्स वासि, नीवा कोड वाटा. ");
INSERT INTO mrr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“निमा नीक कसुर ओपवाल बार नेयम केवानके अनेकेन, अस्केने ओना ओङतुन रेहतलाहि, ओग़ बाताल ताल्ह्‌कनोग़, आतल कीम. अह केविन इतेके, ओग़ कसुर ओपवाल नीक नेयम केवाना कयदे ईयनोग़, वेग़ पया नीकु पोलिसना कयदे ईयनोग़, अहे निमा जेललोप्पा दाकिन. ");
INSERT INTO mrr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","इह केंजा, नीक सेतेम वेहतह्‌नन, निमा आक्रिते कोतातुह्‌क कोता जोळे केवालेवा, अग्डाहि मुर्तिय पलते पेस पग़विन आयकिन. ");
INSERT INTO mrr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“साट्याल कबळ कीयनद आयो, इद्रमता अडो मीट मोसा मुय्तोना सास्त्रमताह केंजतिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","नना मात्रम मीक वेहतह्‌नन, बोग़ाय बेदे आंचानके साट्याल विचरते ऊळिह्‌तोग़, ओग़ु तना जीवाते तान कवतोग़े. ");
INSERT INTO mrr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अदिनेनाह्‌क नीवा विचरतगा, कोंडाते ऊळिस पापम कीयलाह आतेके, कोंडातुन बोग़ाय पेग़्हचीतेक आवालि, इद्रम निमा पापम आयमाकि इन्जि जिद कीमु. बाराह्‌क इतेके नीवा पूरा मेंदुलि, देयमदीपता अमेसाता सिक्सातगा दायना वाटो, नीवा मेंदुदा उंदि कोंडा बूळेम आयना, इद नीके पाय्दाता. ");
INSERT INTO mrr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अद्रमे नीवा विचरते कयदे बार पापम कीयलाह आतिन इतेके, कयदुन बोग़ाय डायिस पोहचीतेक बेस आवालि, इद्रम निमा पापम आयमाकि इन्जि, जिद कीमु. बाराह्‌क इतेके नीवा पूरा मेंदुलि, देयमदीपता अमेसाता सिक्सातगा दायना वाटो, नीवा मेंदुदा उंदि कय बूळेम आयना, इद नीके पाय्दाता. ");
INSERT INTO mrr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“बोग़ तना मुतेन विळ्सिसीस्तोग़, ओग़ु तान्क कळ्पाकग़ देहतनद सीटि रासिसीयना, इद्रम मोसानाङ अडोने वेहतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","नना मात्रम मीक वेहतह्‌नन, मुते दुस्रोन कववालेवा, बोग़ाय तना मुतेनु देहचीस्तोग़, तेला मति देवुळता मुनेह, अदु ओना मुते इंका मन्ह्‌ताये. अदिह्‌कु अदु दुस्रोन्क आतेके, ओर इर्वुर आसि देवुळता मुनेह सिंड्रि-साट्याल आतोरे. इद्रमि आंचाना मुनेतोग़ मुजो तान देहचीतस्के, तान सिंड्रि आनाह कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“देवुळता मुनेह कीतद किरियातुन माग़्ङमा, मति तान करल कीमु, इन्जि मुनेतोर पेदल्किन मोसानाङ अडोने वेहतद मता, तेन ओसो मीट केंजतिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","नना मात्रम मीक वेहतह्‌नन, किरिया ओतनाय आयो! देवुळदीपता वने किरिया ओतमाटु, बाराह्‌क इतेके देवुळ अगा राजेम कीयलाह उदिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","अहे बूम आयि इनजोर, बूमतुन बह ओतमाटु, बाराह्‌क इतेके अदु देवुळ राजेम कीयना लोकुर मनदना जागा आंदु. येरुसलेमतुन वने ओतमाटु, बाराह्‌क इतेके अद बेह्‌रा देवुळराजाना सहर आंदु. ");
INSERT INTO mrr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","किरिया इनजोरे तलातुन बह इटमा, बाराह्‌क इतेके निमा उंदाय नीवा तलाता केदुन पिळ्से केलु, कार्यल केलु कीयाय पग़विन, सबे देवुळताये कयदे मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","इतेके मीवा वळ्ह्‌कमुळि इंगो इतेक इंगो, आयो इतेक आयो, कीयना मतेके इंगो कीकन इनु, कीयना लेवेक इसि केवोन इनु, इचोने मनदना गावले. इविस्किह्‌क वीळिस एक्‍वा पोल्‍लोङ (किरियाङ-कोस्क, ओतना) देयह्‌कनाङ आस्ताङ. ");
INSERT INTO mrr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“बोग़ाय नीवा कोंडातुन पेग़्हतेके, ओना कोंडातुन पेग़्हतनदु, बोग़ाय नीवा पदुन ओग़्हतेके, ओना पदुन ओग़्हतनदु, इह वेहतदिन मीट मोसानाङ अडोने केंजतिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","नना मात्रम मीक वेहतह्‌नन, बोग़ नीक कोंटे कीस्तोग़, ओना अडम दायनायो. बोग़ाय नीवा तिनळ बुकातुन चापुळ ईतेके, दावळ बुकातुन वने चापुळ ईयलाह ईमु. ");
INSERT INTO mrr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","बोग़ाय नीक कचिरतगा ओसि, नेयम देहवाना मुनेह नीवा केग़ता आङतुन ओयकन इनदनोग़, ओन्कु निमा नीवा केग़ता कोटजगातुन वने ओयलाह ईमु. ");
INSERT INTO mrr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","अद्रमे बोग़ सीपय नीक बीगर पोग़्सिह कीसि, वेळेटुन पोसि, दोबेङ-नूकेङ कीसोरे कोसमेंड ओतेके, ओना संगे निमा रेंड कोस्क जागा अनु. ");
INSERT INTO mrr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","बोग़ाय नीक बातालाय ताल्ह्‌कतेके, ओन्कु अद ईमु. अहे बोग़ाय नियग्डाहि करा ताल्ह्‌कनोग़, ओन्क ईयलाह निमा पेग़्के-मुनेह आयमा. ");
INSERT INTO mrr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“नीवा ऐंगेटोनु जीवा कीम, कोटुलतोन बार अडम ऊळा, इद्रम मीक काग़्हवालोर वेहचि, तेन मीट केंजतिरे. ");
INSERT INTO mrr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","मति नना मीक वेहतह्‌नन, मीट मीवाङ कोटुलतोरिन वने जीवा कीम्ह्‌टु, ओसो बोर मीक तिपल कीस्तोर, ओर बेस पिसिर इनजोरे, देवुळतुन कोळ्‍व कीसोर ताल्ह्‌काटु. ");
INSERT INTO mrr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","बाराह्‌क इतेके मीवा देवुळबाबाल तना पोळ्‍द पेहचि, नेह्‌नोरिह्‌क, लाग्वोरिह्‌क, सबेटोरिह्‌क वेह्‌च ईस्तोग़. अहे सेतेमतोरिह्‌क, पापमतोरिह्‌क, तना पेग़ अर्ह्‌चीस्तोग़. अद्रमलेह्‌का मीट वने ओना लेह्‌का, मीवा कोटुलतोरिन जीवा कीतेके, मीवा पोग़ोटोग़ बाबानाङ मग़्क-मयास्‍क आय्ह्‌निर इन्जि, सबेटोरिह्‌क दिसकिर. ");
INSERT INTO mrr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","बोर मीक जीवा कीस्तोर, सिरप ओरिने मीट जीवा कीतिर इतेके, मीक देवुळि बाताल इनम ईयग़ा? सिद्‌वा एनवालोर मुळ्हेर वने अहे कीस्तोरा, केवोर? ");
INSERT INTO mrr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","मीटु सिरप मीवाङ गोततोरा संगे बेस तिरियतिर इतेके, विस्वस केवोरा, मीवा परक पया बाताल? देवुळतुन पुनवोर वने अहे कीस्तोरा, केवोर? ");
INSERT INTO mrr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","अदिह्‌क बेद्रम मीवा देवुळदीपतोग़ बाबाल पूरा सेतेम मन्ह्‌तोग़, अद्रम मीट वने पूरा सेतेमते ताकाटु. ");
INSERT INTO mrr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“मन्कलोर ऊळिस मीक मान ईयनुर, इद विचरते मीट मीवा दर्मम ओरा मुनेह केमाटु. कीतिर इतेके मीवा देवुळदीपतोग़ बाबानगा, मीकु बाताले इनम दोर्को आयग़ा, अदिह्‌के अह बेस्केन केमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","मन्कनेनाहि माकु मान-पान दोर्कना इन्जि, सोङ केवालोर पार्तनाताङ लोह्‌कने ओसो अग़िनगा सबेटोरिह्‌क दिसनाह, इद्रमता दर्मम कीस्तोर. इह केंजाट, नना सेतेम वेहतह्‌नन, ओरिह्‌क तमा इनम (सिरप लोकुराय मान) पूरा दोर्कतपे मन्ह्‌ता. मति मीट ओरा लेह्‌का सबेटोरिह्‌क दिसना इन्जि, डोल पासोरे दर्मम केमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","मीट बेस्के दर्मम कीय्ह्‌निर अस्के, मीवा ऐंगे मतोरु बोरे मुर्तिय पुनदनायो. ");
INSERT INTO mrr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","मीवा दर्मम बोन्के तोहवा केमेन ईयना, अस्के मीवा दिसवद कबळतुन ऊळवाल बाबाल मीक इनम ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“मीट बेस्के देवुळतुन पार्तना कीयलाह दाय्ह्‌निर अस्के, सोङ केवालोरा लेह्‌का मनमाटु. बाराह्‌क इतेके ओरु माक लोकुर ऊळिस मान ईयनुर इन्जि, पार्तनाताङ लोह्‌कने ओसो अग़िनाङ मूलानगा निचि, पार्तना कीयलाह ओरिह्‌क गिर्दा वास्ता. इह केंजाट, नना सेतेम वेहतह्‌नन, ओर तमा इनमतुन (इतेके सिरप लोकुराय मानतुन) पूरा दोर्किह कीतोरे. ");
INSERT INTO mrr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","मति मीट बेस्के देवुळता संगे वळ्ह्‌कलाह इनजोर दाय्ह्‌निर अस्के, मीवा लोनलोप्पा नेङाटु, नेङिसि तेल्पतुन केहचि, मीट बोन्के दिसवा, मीवा देवुळदीपतोग़ बाबाना संगे वळ्ह्‌काटु. अस्के मीवा दिसवद कबळतुन ऊळवाल बाबाल मीक इनम ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ओसो मीट देवुळता संगे वळ्ह्‌कनेके देवुळतुन पुनवोरा लेह्‌का पिचुळ-पिचुळ वळ्ह्‌कमाटु. ‘माट वेल्‍लाङे वळ्ह्‌कतल, इतेके मावा कोळ्‍वतुन देवुळ केंजग़ा,’ इद्रम ओरिह्‌क आस्ता. ");
INSERT INTO mrr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","मीक बाताल गावले मन्ह्‌ता, तान मीट ताल्ह्‌कनामुनेन, मीवा बाबाल पुन्जिये मन्ह्‌तोग़. अदिह्‌के मीट देवुळतुन पुनवोरा लेह्‌का, पिचुळ-पिचुळ वळ्ह्‌कमाट बह! ");
INSERT INTO mrr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","अदिनेनाह्‌क देवुळता संगे बाताङ वळ्ह्‌कनवु, अविन मोदुल कीसि मीकु पुन्पिह कीसीय्ह्‌नन, अव इहलेह्‌का मन्ह्‌ताङ: जोहर सामि, मावा देवुळदीपतोग़ बाबानिन, सबेटोर नीवा पेदिरतुन मान ईयिर. ");
INSERT INTO mrr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","बेद्रम नीवा दीपतोर नीवाङ केंजिह्‌तोर, अहे इद बूमतोर वने नीवाङ केंजिर इन्जि, इद बूमते नीवा राजेम निल्पिह कीमु. ");
INSERT INTO mrr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","मावा दिनमता तिंडि नेंड माक ईमु. ");
INSERT INTO mrr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ओसो बहु माट मावा अडम मता कसुरतोरिन मापि कीतोम, अहु मावाङ कसुर्किन मापि कीमु. ");
INSERT INTO mrr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ओसो कंदाता वेलाते माक पापमते अर्हमा, मति माक देयह्‌कना मुक्यानाहि पिसिह कीमु. राजेमि, लावु, डीसाङ इव अमेसाताङ नीवाङे मन्ह्‌ताङ. माट ताल्ह्‌कतप आयि.” ");
INSERT INTO mrr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ओकावेला मीट लोकुरा कसुरतुन मापि कीतिर इतेके, मीवा पोग़ोटोग़ बाबाल मीवा कसुरतुन वने मापि कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","मति ओकावेला मीट लोकुरिन मापि केविर इतेके, मीवा पोग़ोटोग़ बाबाल वने, मीवा कसुरतुन मापि केवोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“मीट बेस्के उपस कीय्ह्‌निर अस्के, सोङ केवालोरा लेह्‌का मीवा मोकम सोळसोळ आयमाकि. माट उपस कीसोर मह्‌नोम, इद्रम लोकुर ऊळिस माक मान ईयनुर इन्जि, ओरु तमाङ तोडिङ वाग़िह कीस्तोर. इह केंजाट, नना सेतेम वेहतह्‌नन, लोकुरा मान, अचोने ओरा इनम! ");
INSERT INTO mrr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","मति मीट बेस्के उपस कीय्ह्‌निर अस्के, तितोरा लेह्‌का एग़ मीसि, नेय ओकिस तला ऊळाटु. ");
INSERT INTO mrr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","बाराह्‌क इतेके मीवा उपस लोकुरिह्‌क दिसनायो, सिरप मीवा दिसवोग़ बाबाले ऊळना. अस्के मीवा दिसवा कबळतुन ऊळवाल बाबाल मीक इनम ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“मीटु मियेनाह्‌कु इद बूमते वेल्‍ला मालसोम गुम केमाटु. इगा एल्म तिन्ह्‌ता, सिलुम पोयह्‌ता, ओसो कलेर लोतुन विर्हचि कलिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","मति इद बूमते मालसोम गुम केवा, देवुळतेनाह्‌कु इहे ताकना इन्जि, बेस्केन मारवद मालसोम मियेनाह्‌कु देवुळदीपते गुम आयग़ा. अगा एल्म तिनो, सिलुम पोयो, कलेर कलोर. ");
INSERT INTO mrr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","नना मीक बाराह्‌क वेहतह्‌नन इतेके, बेगा मीवा मालसोम मनदग़ा (देवुळदीपते मनि, इद बूमते मनि), अगाने मीवा सीता वने मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“मीवा कोंडा मीवा मेंदुदा वेह्‌चलेह्‌का आंदु. मीवा नद्र देवुळतके मतेक अचोन, मीवा लोप्पा पूरा वेह्‌च मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","मति मीवा नद्र देवुळतके इलवेके, मीवा लोप्पा पूरा ईकळे मनदग़ा. अदिनेनाह्‌कु मीवा लोप्पा मनदनद वेह्‌चि ओकावेला ईकळ बार आता इतेके, अद ईकळि सिडापडाता मुर्गंगाता आयग़ा! ");
INSERT INTO mrr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“बोग़ाय इर्वुर माल्कालोरा सेवा-साकुर कीया पग़वोग़. बाराह्‌क इतेके ओग़ु ओर्विन बार कोटुल कीयनोग़, ओर्विन बार जीवा कीयनोग़. इलवेके ओग़ु ओर्विना पोल्‍लो केंजनोग़, ओर्विना पोल्‍लो बार केंजोग़ आयनोग़. अद्रमे मीट वने मालसोमु ओसो देवुळि, इव रेंडिना सेवा मुर्तिय कीया पग़विर. ");
INSERT INTO mrr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“अदिह्‌के नना मीक वेहतह्‌नन इतेके, पिसमुळतेनाह्‌क माट बाताङ तिनदकोम, उनडकोम, ओसो मीवा मेंदुलतेनाह्‌कु माट बाताङ केग़यकोम इनजोरे, मीट आलिह कीसोर मनमाटु. मीवा जीवा सिरप तिनदलाहे, मेंदुल सिरप गेंदेङ केग़यलाहे मन्ह्‌ताया? ");
INSERT INTO mrr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","पग़ियनाङ पिटेनके ऊळाट, अले! अव वीतोङ वने, कोयोङ वने, अहे डोमेने गुम केवोङ वने. तेला मति मीवा देवुळदीपतोग़ बाबाल अविस्किह्‌क तिंडि ईस्तोग़. देवुळता मुनेह अविस्किह्‌काय वीळिस, मीट एक्‍वा मोलातोरिर आंदिर, इतेके निटमे देवुळि मीवा पिसवग़तुन सीता कीयग़ाये. ");
INSERT INTO mrr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तिनदना-उनडना, इविनलोप्पा आलिह कीसोरे मीवा पिसना-पिसवग़ता उंद पूटा वने मीट वीळिह कीया पग़विर. पग़यकिरा? ");
INSERT INTO mrr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“अद्रमे मीटु गेंदेना लोप्पा बाराह्‌कु आलिह कीसोर मह्‌निर? इव सोबाताङ गेळापुंगेह्‌किन ऊळाट अले, अव बहु वलियताङ! नना मीक वेहतह्‌नन, अव कह्‌टेम केवोङ, नूदे गेंदेङ अर्होङ वने. ");
INSERT INTO mrr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","तेला मति साल्मोन राजाल पका सोबाता राजजगा मलियतस्के वने, अव पुंगेह्‌कना सोबाता बराबर बेस्केन एव्वोग़! ");
INSERT INTO mrr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","इंजेके गेळापुंगेह्‌क नेंड मन्ह्‌ताङ, नाळ बूळेम आस्ताङ. एय विस्वस इलवोरिर, इद्रमता रोंडातुन देवुळि इचोन बेसताङ केग़यनाङ उहपिह कीसीस्ता इतेके, मीक अदु बेचोन कासा कीसि, गेंदे केग़्‍पिह कीसीयग़ा! ईयग़ाया, एवो? ");
INSERT INTO mrr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","अदिह्‌के बाताङ तिनदकोम, उनडकोम, केग़यकोम, इविना लोप्पा मीट आलिह कीसोर मनमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","देवुळतुन पुनवोर इसि, इव कतमे दोर्किह कीयलाह वितापूंडा आस्तोर. मति इव सबेटव मीक गावले मन्ह्‌ताङ, तेन मीवा देवुळदीपतोग़ बाबाल पुन्जिये मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","देवुळि मीवा नडुमि राजेम कीयना इतेके, ताना सेतेमतुन मीट सबेटविह्‌क मुने, इदे मोदुल पोल्‍लो इन्जि पर्ह्‌काटु. अह पर्ह्‌कतिर इतेके, मीक बाताङ गावले मन्ह्‌ताङ, अव कतमे देवुळि मीक ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","नाळ बाताल आयग़ा, तेन आलिह कीसोर मनमाटु. नाळता सीता नाळि! नेटा रंदि, नेटुह्‌क वेल्‍लाय मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दुस्रोरा तप तोहमाटु, तोहतिर इतेके देवुळ वने मीवा तप तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","बाराह्‌क इतेके, दुस्रोरिन बह मीट तप तोहतह्‌निर, अहे देवुळि मीक वने तप तोहतग़ा. अहे बेद गोट्‍टाते मीट दुस्रोरिह्‌क कहच ईय्ह्‌निर (इतेके इळ्न अर्हतह्‌निर), अदे गोट्‍टाते देवुळि मीक वने कहच ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","निमा नीवा कोंडाते मनदनद इळ्पेलेह्‌काडा बेरा तपतुन सीता केवा, नीवा गोतयाना कोंडाता पोडलेह्‌काडा इचीटा तपतुन बाराह्‌क ऊळिह्‌निन? ");
INSERT INTO mrr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","नीवाय कोंडाता इळ्पेतुन ऊळवा, नीवा कोंडाता पोडि तेंडलाह ईम नाकु इन्जि, निमा नीवा गोतयान बह इनदा पग़यकिन? ");
INSERT INTO mrr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","एय सोङ केवानिन! मुने निमा नीवा कोंडाता इळ्पेतुन तेंडा. ताना पया नीवा गोतयाना कोंडाता पोडि तेंडलाह, बेस तोवया पग़यकिन. ");
INSERT INTO mrr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“बोर देवुळताङ पोल्‍लोनु पोहचीतप ऊळिह्‌तोर, ओरिह्‌कु मीट पका दाराताङ मोतिना लेह्‌काडाङ देवुळताङ पवित्र मनदनव पोल्‍लोङ वेहमाटु. मीट वेहतिर इतेके, ओर पदिना लेह्‌का अव पोल्‍लोनु ओय्केङ-विह्‌केङ कीयनुर. ओसो नय्कना लेह्‌का मीक कस्किसि पिळ्हपळ कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“‘ताल्ह्‌कसोर मतेके ईकन, पर्ह्‌कसोर मतेके दोर्कग़ा, तेल्प कोह्‌कसोर मतेके तेग़यकन’ इन्जि, देवुळ मीक इन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","बाराह्‌क इतेके बोग़ ताल्ह्‌किह्‌तोग़, ओन्क ईयग़ा. बोग़ पर्ह्‌किह्‌तोग़, ओन्क दोर्कग़ा. बोग़ कोह्‌किह्‌तोग़, ओन्क तेग़यिस ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","तपेनु तना मग़ि आरि ताल्ह्‌कतेके ओन्क बंडा ईयनोग़, ओसो मीन ताल्ह्‌कतेके ओन्क तरसतुन ईयनोग़, इद्रमतोग़ बोग़ाय मन्कल मियगा मन्ह्‌तोग़ा? ");
INSERT INTO mrr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","मीट पापमतोरिर मन्ज तेला, मीवाङ पिलाङ-पेकोरिह्‌क बेसता मादुन ईयलाह पुह्‌निर, इतेके मीवा देवुळदीपतोग़ बाबाल, ओन ताल्ह्‌कवालोरिह्‌क बेचोटा बेसतल माल ईयनोग़! ");
INSERT INTO mrr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“लोकुर मीवा संगे बेद्रम ताकना इन्जि मीवा विचर मन्ह्‌ता, अद्रमे मीटु ओरा संगे ताकाटु. बाराह्‌क इतेके मोसानाङ अडोङ ओसो देवुळता कबुरतोरा सास्त्रम, कतम इदे पोल्‍लोते ओंडेम आताङ. ");
INSERT INTO mrr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“रेंड अग़िङ मन्ह्‌ताङ, बेद अग़दुन पोयतकिर? बेरा दर्वजात्कु वेल्‍ला पस मन्ह्‌ता, अद नेर्वता अग़ि बूळेम आयनके ओस्ता, अद अग़दे अनवालोरु वेल्‍लाय मुल मन्ह्‌तोर. मति वेल्‍ला पस इलवदु उड्ला अग़ि अमेसाता पिसमुळतके ओस्ता, इद अग़ि वेल्‍लाय कमि मुडुह्‌क दोर्किह्‌ता. अदिह्‌के मीटु वेल्‍ला पस इलवद दर्वजात्कु लोप्पा नेङाटु. ");
INSERT INTO mrr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“देवुळता कबुर जोलते वेहवालोरग्डाहि उसरते मन्ह्‌टु. ओरु गोरेनलेह्‌का नाळेह केवप दिसिह्‌तोर, मति ओरा पोटालोप्पाडा विचरि, पिळ्हपळ कीयनाङ लोळ्ङानलेह्‌का मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ओराङ कीयनाङ कबस्कनाहि, मीट ओर बेद्रमतोर इन्जि पुनदकिर. कोये-जपिनाहि अंगुर पंडिङ कोयोर. ओसो लिंगुळ आपानाङ जपिनाहि तोया पंडिङ कोयोर. कोयह्‌तोरा? ");
INSERT INTO mrr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","अद्रमे बेसता मरा बार बेसताङ तिनदनाङ कायाङ आदिह्‌ता, करबता मरा बार तिनवव कायाङ आदिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","बेसतल मरा लाग्वाङ कायाङ आदो, अहे करबता मरा बेसताङ कायाङ आदो. ");
INSERT INTO mrr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","बेद मरा बेसताङ कायाङ आदो, अद्रमताङ सबे मरानु नळ्किस किसतगा वाटिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","अद्रमलेह्‌का देवुळता कबुर वेहवालोरिन ओराङ कबस्कनाहि सेतेमतोरु, जोलतोरु इनजोर, मीट ओरिन पुनदकिर. (ओसो जोलतोरिनु देवुळि अहे सिक्सा ईयग़ा.) ");
INSERT INTO mrr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“नाकु ‘सामि, सामि’ इनवालोर सबेटोर, देवुळदीपता राजेमते नेङोर आयनुर, मति देवुळदीपतोग़ नावा बाबाना पोल्‍लो वेहतप ताकवालोर, ओरे मात्रम अगा दाया पग़यनुर. ");
INSERT INTO mrr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","नना नेयम कीयनद आक्रि दियाते, वेल्‍लाटोर नयगा वासि, देवुळदीपते नेङलाह ईयनोग़ इन्जि, ‘ओ सामि, माट नीवा पेदिरते देवुळता कबुर वेहतोम, ओसो नीवाय पेदिरते देयह्‌क-बूतह्‌किन पूंडटोम, ओसो नीवाय पेदिरते बेचोटाङ बेरा डीसाताङ कबस्क कीतोम. कीतोमा, केवोम, सामि?’ इनजोर नाक इनदनुर. ");
INSERT INTO mrr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","अस्के कोनि नना ओरिनु, ओरा मोकम मुनेह इनदकन, ‘एय देवुळता पोल्‍लोतुन केंजवोरिर, नना मीक मुर्तिय पुनोन, मीट नयग्डाहि पेसिस अन्ह्‌टु!’ इह इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“बोर नावाङ इव पोल्‍लोन केंजिसि अहे ताकिह्‌तोर, ओरु पर्पा जागाते लोन तेहतोग़ु, बेसता तेल्वतोग़ मन्कनलेह्‌का आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","तेहतापया पेग़ वाता, उड्रा वाता, बेह्‌रा दूंद-मुर्गम वासि लोतगाह्‌क अता, तेला मति अद लोन मुटो, बाराह्‌क इतेके तानाङ पाय्वाङ पर्पा जागाते दोहतव मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","मति बोर नावाङ इव काग़्हतव पोल्‍लोन केंजिसि अहलेह्‌का ताकोर, ओरु उस्को पर्वतगा लोन तेहतोग़, तेल्वलेवोग़ मन्कनलेह्‌का आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","तेहतापया पेग़ वाता, उड्रा वाता, दूंद-मुर्गम वाता, वासि अद लोतगाह्‌क अता. अस्के अद लोन मुटिस, पूराय बूळेम आता.” ");
INSERT INTO mrr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","इव पोल्‍लोङ येसु वेहतलाह मारिह कीतस्के लोकुर ओनाङ काग़्हतनाङ पोल्‍लोन केंजिसि बयल आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","बाराह्‌क इतेके, येसु ओरिनु ओराङ सास्त्रमगूरुरा लेह्‌का काग़्होग़, मति तन्के अदिकर मतपु, लोकुरिन काग़्हन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","गुड्रापोग़ोटाहि येसु तनाङ कग़यवालोर बार इळ्न रेगतस्के, गोह्‌डिनाङ गोह्‌डिङ ओना पयाह-पयाहे मंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","अस्के ओर्वोग़ मोंडरोगमतोग़ येसुनगा वातोग़. (अद्रमतोरिन यहुदिर कळ्‍वोग़तासिंदुर.) ओग़ येसुनगा वासि, “बाबा, नीवा विचर मतेके, नाक सव्रे कीसि, नावा कळ्‍वोग़तुन तेंड पग़यकिन,” इनजोर येसुन मिंडाङ कोटिसि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","“अह इतेके अले, नावा विचर मन्ह्‌ताये! निमा सव्रेम आम,” इनजोर येसु इतोग़. इतस्के, (यहुदिरा मोंडरोगमतोन इटवद नोमळता अडोतुन नोमवा,) येसु ओन कय आहच बोयतोग़. अस्के चट्‌नेन ओना मोंडरोगम मायता. ");
INSERT INTO mrr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","“इंजेके मोंडरोगम सव्रेम आतेनाह्‌क, मोक ईयलाह मोसानाङ अडोङ मतपु, निमा कुदि अन्जि, सव्रेम आतन इन्जि, बूमयाह्‌क मात्रम तोहा. बूमयानके अनेके, इद पोल्‍लोतुन बोन्के बह वेहमा. सव्रेम आताह्‌कु मोक ईतोग़ इन्जि, बूमयाल सबेटोरिह्‌क वेहतनोग़, अस्के नियगा मोंडरोगमता कळ्‍वोग़ मनो आयग़ा,” इनजोरे मोंडरोगमतोन येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","पया येसु कापेर्नाग़ वातस्के, सीपय्कना ओर्वोग़ दरोगाल ओनक्‍के वासि, कालगडेम अरसोर साय्ता ताल्ह्‌कतोग़, “ओ गूरु, नावा साकुर केवाल कय-काल वावा, वेल्‍लाय दुकते अर्सि, लोते ऊल्गसोर मन्ह्‌तोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","अस्के येसु दरोगान इतोग़, “नना वासि ओनु सव्रे कीकन,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","अस्के वेग़ दरोगाल येसुन इतोग़, “गूरु, निमा नावा लोनलोप्पा वायना इन्जि, नना लायक इलेन. नना वने ओर्विना कय इळ्न मह्‌नन, अहे नावा कय इळ्न उय्तुर सीपय्क मन्ह्‌तोर. नना वग़ोग़ सीपयिन ‘अन!’ इनजोर वेहतेके, ओग़ दास्तोग़, ओसो दुस्रोनु ‘वाय!’ इनजोर केयतेके, ओग़ वास्तोग़. अहे नावा साकुर केवानु ‘इद कीम, रा!’ इनजोर वेहतेके, अद कबळतुन ओग़ कीस्तोग़े. (इद्रमि, इद रोगमता पोग़ोन नीवा अदिकर मन्ह्‌ता;) निमा मात्रम उंद पोल्‍लो वळ्ह्‌कतिन इतेके, नावा साकुर केवाल सव्रेम आयनोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","इद पोल्‍लोतुन केंजिसि, येसु पकाय बामतोग़. अस्के तना पयाह वावालोर मुडुन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, इचोटा बेरा विस्वस नाकु मावोर इस्रयेलतोरगा बोनगान बह दिसो! ");
INSERT INTO mrr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","इदे निटम पोल्‍लो, मीट केंजाटु, वेग़ दरोगानलेह्‌काडोर बूममेटोर यहुदि आयवोर ईनाह-आनाह जमा आयनुर. जमा आसि देवुळदीपता राजेमतगा मावाङ मुनेतोर पेदल्क अब्रहमि, इसकि, याकुबि, वेरा संगे कुळ्प तिनदना बतते उदनुर. ");
INSERT INTO mrr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","मति माट इस्रयेलतोरोम इन्जि देवुळदीपते नेङकोम, इद्रम इनवालोर उय्तुरिन, देवुळ मनवदु ईकळता जागाते देवुळि पलत पोहचीयग़ा. अगा ओरु अळयना, पल्क कोग़्कना कीयनुर.” ");
INSERT INTO mrr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","पया दरोगान येसु इतोग़, “अले, निमा लोन अन, निमा विस्वस कीतपु, नीवा साकुर केवाल सव्रेम आयेग़,” इतोग़. अदे गट्काते वेग़ दरोगाना साकुर केवाल सव्रेम आतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","येसु पया तनाङ कग़यवालोर बार, सिमोन पत्रुना लोन अतोग़, अस्के पत्रुना आतो पकाय दंडटे कटुदगा टेटेम अर्स मता. ");
INSERT INTO mrr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","अस्के येसु ताना दंडटुन ऊळिसि, ताना कयदुन बोयताहे, दंड रेगता. पया अद तेदिसि, ओरिह्‌क जावा-एग़ कीसीता. ");
INSERT INTO mrr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","अदे दिया मुलतस्के, वेल्‍लाटोर देयह्‌क-बूतह्‌क पोयतोरिनु, येसु विळ्सिह कीयनोग़ इन्जि, लोकुर ओनगा ततोर. ततस्के येसु तना तोडटा पोल्‍लोतेन अव देयह्‌किन उकुम ईस पूंडटोग़; ओसो सबे दुकिनोरिन सव्रे कीसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","इद्रमि यसयाल इनवाल मुने रासतदु देवुळता कबुर इंजेके करल आता, अद कबुर इह मन्ह्‌ता: ओग़ कुदि मावा दुकतुन पूंडटोग़, मावा रोगमतुन पोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","पया येसु तना सर्ने वेल्‍लाय मुल मन्ह्‌तोर इन्जि ऊळतोग़, ऊळिसि तना ऐंगेटोरिनु “गालिल सम्दुरता अबर बाजे दाकल,” इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","अस्के ओर्वोग़ सास्त्रमगूरु येसुनगा वासि इतोग़, “गूरु, निमा बेके दाकिन, अकेन नना नीवा संगे वायकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","मति येसु ओन इतोग़, “कोय्लेस्किह्‌क मनदलाह बार गळ्‍दाङ, पोग़ोटाङ पिटेह्‌क मनदलाह बार गूडाङ मन्ह्‌ताङ. मति नना माने-मन्कना नडुम पुटिसाय मति, नाक तला रोयिह कीयलाह वने जागा इले. (निमा वने अद्रम मनदलाह तयर मह्‌निना?)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","पया दुस्रोग़ ओनाङ कग़यवाल ओन इतोग़, “गूरु, (नना नीवा संगे वायकन, निटमे. मति) मुने नाक बाबाना लोन दायलाह ईमु. बाबाल हायनोग़ अस्के, नना ओन पोहचि नियके वायकन” इह ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“आयो, निमा नावा संगे इंजेकेन वय. देवुळता जीवालेवोरु हातपे मन्ह्‌तोर, ओरे तमाङ हातोरिन पोहिर!” इन्जि येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","अस्के पया तनाङ कग़यवालोरा संगे, येसु ओडाते उदिसि, सम्दुरता अबर बाजे दायलाह पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","अनेक अनेके, दोम्‍क्‍नेने सम्दुरतगा बेरा दूंदि वाता, वासि एताङ लच्काने ओडातुन कोळ्ङिह कींदु. मति येसु इसि पर्वालेवा उंजिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","अस्के ओर कग़यवालोर येसुनगा एरे वासि ओन तेहतोर. “ए गूरु, माक पिसिह कीमु, माट मुळ्न्दिह्‌नल!” इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","अस्के येसु उंजिस तेदताहे ओरिन इतोग़, “एय विस्वसलेवोरिर, (नयगा मीक पिसिह कीयलाह लाव मन्ह्‌ता इन्जि मीट पुनविरा,) मीट पया बार्किया रेयतिर?” इद्रम इतोग़. पया ओग़ नितोग़, निचि अद दूंदतुन, एतुन वेग़्हतोग़, अस्के दोम्‍क्‍नेन दूंद-मुर्गम मायता, अहे सबे मेलियनाङ बाताङ मेर्क्ने आताङ. ");
INSERT INTO mrr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","तेन ऊळिस कग़यवालोर पकाय बामतोर. वेर पया इनदलातोर, “वेना उकुमतुन वळ्यु, लच्काङ केंजिह्‌ताङ इतेके, वेग़ बेद्रमतोग़ मन्कल मनदनोग़ रा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","पया सम्दुरता अबरि, गदरे इनदनद एरियातगा ओर एवतोर. अगा हातोरिन पोहतलाह पांजाङ मताङ. ओर एवतस्के, अव पांजानाह इर्वुर देयह्‌क पोयतोरु पेसिस वानेके ओन्क कलियतोर. वेर इर्वुर इचोन आकाङ-दोकानोर मंदुर इतेके, वेर मनदनद अग़दुह्‌कु बोग़े बह दाया पग़वोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","येसुन ऊळिसि, वेर पकाय जोरते केयतोर, “एय देवुळता मग़निन, निमा बार्किया माक अडम आय्ह्‌निन? नेयम कीयनद कगो एवयनामुनेन, निमा माक सिक्सा ईयलाह वातिना? ");
INSERT INTO mrr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","मति निमा माक पूंडना मतेके ओके ऊळा, वेल्‍लाय जेक गोह्‌ड पदिङ मेयिह्‌ताङ, अके माक लोहचीमु,” इनजोरे देयह्‌क येसुन कालगडेम अरताङ. ");
INSERT INTO mrr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","अस्के येसु “अन्ह्‌ट, पेसाट!” इतोग़, इताहे देयह्‌क चट्‌नेन पेसिस, पदिना गोह्‌डटगा तुर्म्ने नेङताङ. अस्के गोह्‌ड पदिङ अद कस्क्ने मनदनद मेटा ओळ्सिये, मुटेङ-मुळ्गेङ आसोर, सम्दुरकचुल वित बोटटाङ. एतगा पया कुबोग़ इनाह अर्सि, कतमे मुळ्न्दिस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","पदिङ मेहवालोर पया, इद उबता-उबिय आता पोल्‍लोतुन, तमा नाटे वेहतलाह विततोर. देयह्‌क पोयतोरा लोप्पा बह बह आता, इदिन पूरा नाटेनोरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","वेहतस्के मावाङ कतम पदिङ बूळेम आताङ इन्जि, अग्डोर पूरा नाग़मेटोर रेयतोर, रेयिसि येसुनगा वासि कलियतोर. ओन कलियिसि इतोर, “मयगा निमा मनमा, मावा सिवातग्डाहि पलते पेसिसि, अबर बूम अन,” इनजोर येसुन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","पया येसु तनाङ कग़यवालोर बारा तना नाग़, कापेर्नाग़ मल्स दायलाह, ओडाते उदिस मन्जि वेंडटोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","कापेर्नाग़ एवतोर अस्के पया, कय्क-काल्क वाग़तोग़ ओर्विन, तना उंजना कटुल अग़्के, येसु सव्रे कीयनोग़ इन्जि, ओनगा उय्तुर बोरो ततोर. ओरा विस्वसतुन ऊळिसि, येसु दुकतोन इतोग़, “अल बाबा, दीरा पोय्म. नना नीवाङ कसुर्किन मापि कीय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","अह इताहे, अगा मतोर सास्त्रमगूरुर तमतमाये कुस्कुस इंदुर, “ऊळाट, वेग़ मन्कल उगसे देवुळतन इतपे बह पोग़यिह्‌तोग़!” इद्रम वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ओरा पोटाताङ विचर्किन पुन्जि येसु इतोग़, “मीवा पोटाते नावा लोप्पा बाराह्‌क कुळ्सा वळ्ह्‌किह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","वेन रोगमतोन ‘नीवाङ कसुर्कना मापि आता,’ इह इतेके अल्कोया? बारा वेनु ‘तेदिस अन,’ इनदनद अल्कोया? इंजेके नना माने-मन्कना नडुम पुटटोनन मन्जि, देवुळतेनाह नयगा इद बूमते, पापमतुन मापि कीयनद अदिकर इंका मन्ह्‌ता इन्जि, मीक तोहतकन,” इनजोर येसु ओरिन इतोग़. पया कय-काल वाग़तोन येसु इतोग़, “तेदा रा! नीवा कटुल उळ्हचि, पोसि, लोन अन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","पया ओग़ तेदिसि, तना लोन दिगदिग अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","देवुळि मन्कह्‌क इचोटा बेरा अदिकर ईता, तेन ऊळिसि अगा मतोर लोकुर, देवुळतुन रेयिसि तान जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","अग्डाह पया येसु पेसिस अनेके, सिद्‌वा एतना नाकातगा, मत्याल इनवाल उदिस मतोग़. ओन ऊळिस येसु इतोग़, “नावाङ कग़यवानिन आयकिन, दय!” अह इताहे, मत्याल तेदिसि येसुना संगे दाया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","अस्के पया येसु तनाङ कग़यवालोरा संगे, मत्याना लोते गाटो तिनदलाह उदिस मतोग़. अस्के सिद्‌वा एनवालोर, ओसो दुस्रोर पाप्यहलोर, इद्रमतोर वेल्‍लाटोरे ओरा बतते वासि उदतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","तेन ऊळिसि परुसिर ताल्ह्‌कतोर, “सिद्‌वा एनवालोर, पाप्यहलोर, इद्रमतोर पोहचीतप मतोरा संगे, मीवा गूरु बह तिन्ह्‌तोग़?” इनजोर कग़यवालोरिन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ओरा वळ्ह्‌कनदिन केंजिसि, येसु ओरिन इतोग़, “रोगमलेवोरु डाक्‍टरनके अनोर, मति रोगम मतोरे तमा दुकतुन पोहतलाह दास्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","अद्रमलेह्‌काने नना नेह्‌नोरोम इनवालोरिन आयो, मति पापिरिन केयलाह वातन, इद पोल्‍लो सीताते तासाटु. मोक-मोह्‌रम ईयना वाटो, ओर्विनेनाह्‌क जीवा लोपतप मनदनद बेसु, इहे नावा विचर मन्ह्‌ता, इद सास्त्रमते देवुळ वेहतद पोल्‍लोता अर्तमि बाताल आस्तायो, अन्ज कग़याटु,” इद्रम येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","उंद देबा देवुळता पेदिरते एते मीहवाल योहननाङ कग़यवालोर, येसुनगा वासि ताल्ह्‌कतोर, “गूरु, परुसिर ओसो माटु ऊक-ऊके उपस कीय्ह्‌नोम, मति नीवाङ कग़यवालोर मात्रमि उपस केवोर, इदिनलोप्पा निमा बार इह्‌निन?” इह इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","अस्के येसु इतोग़, “मावा नडुम मर्मपेकाल मन्ह्‌तोग़ इन्जि, संगेतोर मर्मिनस्के उपस ओसो बार्किया कीयनुर? मति कोटुलतोर वासि मर्मपेकान ओरग्डाहि एग़्‍पिह कीसि पोस ओयनुर, इद्रमता वेला वायग़ा, अद तूकने ओर दुकम आसि तिनोर आयनुर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","(इतापया ओरिह्‌क ओसो पुन्पिह कीयनाङ पीटोने इद्रम वेहतोग़.) “इदिन केंजाटु, पाळ्ना गेंदेता अग़ता बूकातगा मेतलाह, पूना गेंदे बोग़े ओल्सोग़. ओल्सतेके पूना गेंदे एग़ गुंजिसि ऊयिह्‌ता, ऊयिसि पाळ्नातुन अग़्हचि, इंका ओसो बेरा बूका कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अद्रमे ओयवदु पूना अंगुर जोमातुन, पाळ्ना तोलाजोर्काते बोग़े एन्दोग़. एन्दतेक इसि मिङतद जोमा ओयिसि, जोर्का ओसो आङिसि अग़यह्‌ता, अग़्स पया जोमा पूरा वाङिह्‌ता. मति पूना मिङतद अंगुर जोमा एन्दलाहि, पूनाये आङवदु तोलाजोर्का गावले. अस्के कोनि जोर्का, जोमा इव रेंड आसि अक्‍र्नेन मनदनुङ,” इद्रम येसु योहननाङ कग़यवालोरिनु वेहतोग़. (नना पूनाङ-पूनाङ पोल्‍लोङ काग़्हतह्‌नन, अविस्कनगा पाळ्ना रिवजताङ पोल्‍लोङ काल्ह्‌पनायो इन्जि, येसु इव पुन्पिह कीयनाङ पीटोङ वेहतोग़.) ");
INSERT INTO mrr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","इव गोटिङ येसु ओरा संगे वळ्ह्‌कनेके, बोग़ो ओर्वोग़ साय्बाल अगा वासि, “नावा मयाळि इचोटे हाता, गूरु. मति निमा वास मात्रम तान बोयतिन इतेके, अद तेग़्कग़ा” इनजोरे, येसुनाङ काल्क मोळ्कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","21","पया येसु तेदिसि तनाङ कग़यवालोरा संगे अनेके, बारा वर्साङ आनाह कुर्माते बादा आयनद उंद आंचाळि, ओन ऊळिसि ओना पयाह वाता. नना मात्रम ओना गेंदेतुन बोयतेकाय सव्रेम आयकन, इद्रम आलिह कीसि, ओना पयाह वाता. वासि, अद ओना गेंदे कोङतुन बोयता. ");
INSERT INTO mrr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","बोयमुळतुह्‌कु येसु पेग़्के मल्स ऊळिसि, अद आंचान इतोग़, “पेडि, निमा दीरा पोय्म! नना नीक सव्रे कीकन इन्जि, निमा विस्वस कीताह्‌के, बेस आतिन.” इताहे अदे गट्काते अद आंचाना बादा मायता. ");
INSERT INTO mrr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","अस्के पया हाता पिलाता लोन ओर वातस्के, अगा अळवालोर-केयवालोरिन, तुरुस्क ऊरवालोरिन, येसु ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ऊळिसि ओरिन इतोग़, “तिट, नाक अग़ ईम्ह्‌टु. पिला हायो, अद निद्रतेन मन्ह्‌ता!” अह इतस्के, पोहता वाता मुल येसुन कवतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","अगा वाता मुडुन ओग़ पलत पेहतस्के, पिला मता जागातगा येसु नेङतोग़, नेङिसि ताना कयदुन पोयतोग़, अस्के अद हाता पिला जीवा अरता. ");
INSERT INTO mrr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","इद पोल्‍लो अद पूरा एरियामेंड आबुर आता. ");
INSERT INTO mrr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","येसु अग्डाहि पेसिस अनेके, (देवुळ लोहतोग़ राजाल येसुये इन्जि नमिसि,) इर्वुर गुडिर ओना पयाह पयाह अनजोर केयसोर इंदुर, “ए दाविद राजाना कूळतोनिन, मावा पोग़ोन दया कीमु!” ");
INSERT INTO mrr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ओग़ पया लोन ओळियतस्के, ओर गुडिर ओनगा वातोर. अस्के येसु ओरिन इतोग़, “नना मीक सव्रे कीया पग़यकन, इद्रमि मीवा विस्वस मन्ह्‌ताया?” इन्जि ताल्ह्‌कतोग़. अस्के “इंगो गूरु,” इनजोर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","“मीट विस्वस कीतपु मीक आयि,” इन्जि येसु ओराङ कोंडान इटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अस्के ओर तोवया बोटटोर. पया येसु ओरिन वेहतोग़, “ऊळाटु, इद पोल्‍लो बोग़े बार पुनदनायो.” ");
INSERT INTO mrr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","मति ओर अग्डाहि पेसिस अतापया, अद पोल्‍लोतुन पूरा एरियामेंड आबुर कीसीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","पया अग्डाहि येसु तनाङ कग़यवालोरा संगे पेसिस अनजोर मनेके ऊळाट, मूका देयम पोयतोन ओर्विनु, लोकुर येसुनके ततोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","देयमतुन येसु पेहच पूंडटोग़, अस्के ओग़ मूकाल वळ्ह्‌क बोटटोग़. तेन ऊळिसि लोकुर बामिसि इनदलातोर, “इस्रयेल देसेमते इद्रम आतदिनु, बेस्केन ऊळतद इले रा!” इनजोर वळ्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","मति परुसिर इनदलातोर, “वेग़ देयह्‌कना मुक्याना लावतेने देयह्‌किन पूंडिह्‌तोग़, रा!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","अस्के पया येसु तनाङ कग़यवालोर बार, अद पटटे सबे नाह्‌कने तिरियिंदुर. बेक अतेकाय ओग़ु ओराङ पार्तनाताङ लोह्‌कनगा काग़्हचोरे, देवुळि मन्कलोरगा राजेम कीयनद बेसता कबुरतुन पोकुर कीसोरे, सबे रोगह्‌किन, दुकह्‌किन सव्रे कीसोर तिरियिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","अग्डोर लोकुरिन येसु ऊळतोग़ इतेके, कोपाललेववु गोरेनलेह्‌का ओरु गळबळते लेसतप, आरेम आतप मतोर. तेन ऊळिसि ओन्कु ओरा मान वसता. ");
INSERT INTO mrr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","अस्के येसु तनाङ कग़यवालोरिन इतोग़, “वेर लोकुर पोलमते वेल्‍लाय पंटालेह्‌का मन्ह्‌तोर, मति वेरिन देवुळतगा तवालोर बूतिनोर आलोर. ");
INSERT INTO mrr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","अदिह्‌के पोलमता माल्काललेह्‌काडा देवुळि, लोकुरिन बेसता कबुर वेहचि, तनगा तवालोर बूतिनोरिन लोहि इन्जि, मीटु अर्ज कीसोर मन्ह्‌टु,” इन्जि येसु ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","अस्के पया येसु तनाङ कग़यवालोरिन, बारा मांदतुन एरे केयतोग़. केयिसि ओरिह्‌कु देयह्‌क-बूतह्‌क पूंडलाहि, रोगह्‌किन-दुकह्‌किन सव्रे कीयलाहि, अदिकर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ओर कग़यवालोर बारा मन्कलोराङ पेदिर्क इह मताङ: मुने सिमोन (ओने पत्रु इंदुर) ओसो आंद्रेयाल, वेर तमोग़ इर्वुर मतोर; पया जेबेदिनाङ इर्वुर मग़्कु याकुब ओसो योहन; ");
INSERT INTO mrr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","पिलिप ओसो बार्तोलोम; तोमाल ओसो मत्याल (ओग़ सिद्‌वा एनवाल मन्ज तेला); अल्पुना मग़ि याकुब ओसो तदु; ");
INSERT INTO mrr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सिमोन (ओग़ रोम सर्करता अडम पार्टितोग़), ओसो यहुदा इस्केर्योत (वेग़े आक्रिते येसुन कोंटेतोरा कयदे पोसीतोग़). (वेरे येसुनाङ बारा मांदि बळयिरआंदुर.) ");
INSERT INTO mrr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","ओरिन येसु इद्रम काग़्हच लोहतोग़: “मावा इस्रयेल देसेमतोर इतेके, लेसताङ गोरेनलेह्‌का मन्ह्‌तोर, अदिह्‌क ओरेकेन मीट अन्ह्‌टु; मति ओरिन विळ्सिसि, दुस्राङ जातिनोरक्‍के मात्रम अनमाटु, अहे सामरिया पटटाङ नाह्‌कने नेङमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","मीट अनेके ‘देवुळता राजेम कीयनाङ दियाङ एवयलाह आताङ,’ इनजोर वेहचोर अन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","रोगह्‌लोरिन सव्रे कीसोर, हातोरिन जीवा अर्हचोर, मोंडरोगमतोरिन सुद्रे कीसोर, देयह्‌किन पूंडसोर अन्ह्‌टु. मीक नना पुनेमते अदिकर ईतन, अहे मीट वने पुनेमते दुस्रोरा सेवा कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“अनेके मीवाङ नंडिने बंगरताङ, वेंडटाङ, रागताङ कोताङ बह तासमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","अहे जोर्का कांजमाटु, रेंड-रेंड जगाङ, रेंड-रेंड एल्पुस्क, ओसो कयदे डुडि, इविन ओयमाटु. मीट देवुळताय बूततोरिर इतेके, लोकुर मीक दर्मम कीयना गावले. ");
INSERT INTO mrr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","मीटु बेदाय नाटे दाकिर, अस्के अगा बोग़ नेह्‌नोग़ मन्ह्‌तोग़, ओना पता कीम्ह्‌टु. ओसो मीट पेसिस अनाह्‌जोम, ओनगाने मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ओसो लोते नेङनेके, मीक सुकम दोर्कि, इद्रमता बर्कतता पोल्‍लो इन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अद लोतोरु बेस मीक जागा-पग़्सा कीयलाह गिर्दा आतोर इतेके, मीवा वळ्ह्‌कतद बर्कत ओरगा मनदग़ा. मति ओर गिर्दा आयोर इतेके, देवुळता बर्कत ओरगा मनो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","बेद नाटेनोर मीक एरे केवोर, मीवा कबुरतुन केंजोर, अद नाटेनाहि पेसनेके, (ओर देवुळता सिक्सातुह्‌क ओजिह्‌तोर इनजोर तोहतलाहि,) मीट मीवाङ काल्कना दुरातुन अगान दुल्पाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","इह केंजाट, नना सेतेम वेहतह्‌नन, सोदोम-गोमोरा अव नाह्‌कनोरिन देवुळ (ओराङ लाग्वाङ कबस्कनेनाह्‌क, मुने सिक्सा ईसि) बूळे कीता इन्जि पुतिर. तान वीळिसि मीक एरे केवोर इव नाह्‌कनोरिनु, नेयमता आक्रि दियाते देवुळि वेल्‍ला सिक्सा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“इद केंजाट, लोळ्ङानगा गोरेन लोहतपु, नना मीक दुनियाते लोहतह्‌नन. अदिह्‌कु मीटु तरस्कना लेह्‌का सत्रल मन्ह्‌टु, मति परेवाङ मतप, नाळेह केवोरा लेह्‌का वने मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","मति मन्कलोराहि उसरते मन्ह्‌टु. ओर मीकु कोरट-कचिर्कनगा ओसीयनुर, तमाङ पार्तनाताङ लोह्‌कने मीक नल्हतनुर. ");
INSERT INTO mrr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ओसो नाक नमताह्‌कु, मीकु सर्करता मुनेह, अहे राजालोरा मुनेह, निल्पिह कीयनुर. अस्के मीटु ओरिह्‌कु, ओसो यहुदि आयवोर दुस्राङ जातिनोरिह्‌कु, नावा लोप्पा साक्सि वेहतकिर. ");
INSERT INTO mrr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","बेस्के मीक ओरा कयदे ईयनुर अस्के, मीट मीवाय बुदते वेहवालोरिर आयविर आयकिर. मति मीवा देवुळबाबाना जीवा मीकु वळ्ह्‌कलाह बुदिङ ईयग़ा. अद ईतस्के, बेद बह वळ्ह्‌कना, इद मीक अदे गट्काते एर्का आयग़ा. अदिह्‌के तेना लोप्पा मुनेन मीट आलिह केमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“विस्वसलेवोग़ तमोग़ बार तना विस्वसि दादानु, ओसो विस्वसलेवोग़ तपे बार तना विस्वसि मग़िनु हव्कलाहि पोसीयनुर. विस्वसलेवोर मग़्क-मयास्‍क विस्वसिर तलोग़-तपेरा विरुद तेदिसि, ओरिन हव्कलाह वेहतनुर. ");
INSERT INTO mrr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ओसो मीट नाक नमवालोरिर आताह्‌कु, दुनियातोर मीकु कोटुल कीयनुर. मति आक्रि एवनाह बोर दीरा पोस मन्ह्‌तोर, ओरिन देवुळि पिसिह कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","उंद नाटे बेस्के ओर मीक बोबा कीयनुर अस्के, दुस्रा नाटे मीट पटादुळ विताटु. इह केंजाट, नना सेतेम वेहतह्‌नन, इस्रयेलतोराङ सबे नाह्‌कने मीट नावा कबुर वेहतलाह मारिह कीयनामुनेने, नना माने-मन्कना नडुम पुटटोनन देवुळदीपताहि मल्स वायकन. ");
INSERT INTO mrr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“कग़यवाल तना गूरुह्‌क बेरोग़ आस्तोग़ा? अहे ओर्युलतोग़ तना माल्काह्‌क बेरोग़ आस्तोग़ा? ");
INSERT INTO mrr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","आयो, कग़यवाल गूरुनलेह्‌का ओसो ओर्युलतोग़ माल्कानलेह्‌का आयना, इचोने ओन्क बेसु. नना लोता माल्कानन मन्ज तेला, नाके ओर देयह्‌कना मुक्याल इन्ह्‌तोर; मीट इतेके लोता मन्कलोरिर इन्जि, मीक बेचोन वीळिस तिपल कीयनुर, इदिन सीताते तासाटु! ");
INSERT INTO mrr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ओर तिपल कीयनस्के, ओरिह्‌क रेयमाटु. सबे मकिह कीतव पोल्‍लोङ पङ्ने आयनुङ, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","बेद नना मीक ईकळते वेहतह्‌नन, अदिन मीटु वेह्‌चते लोकुरा मुनेह पिङम-पङम वेहाटु. ओसो बेव नना मीवा केवदे वेहतह्‌नन, अविनु लोता पोग़ोन निचि, पोकुर कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“बोर मेंदुदुन हव्क पग़यह्‌तोर मति जीवातुन इट पग़वोर, ओर मन्कलोरिह्‌क मीट रेयमाटु. ओरिन रेयवा, जीवातुन ओसो मेंदुदुन, इव रेंडिन आसि पिववद किसबटटा सिक्सातगा बूळे कीया पग़यनद देवुळि, तान्के रेयाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ऊळाटु, कोळ्का पिटेह्‌कु बाता बिसद मन्ह्‌ताया? इले, तेला मति मीवा देवुळदीपतोग़ बाबाना विचरलेवा, अविस्कनग्डाहि उंद वने पोग़ोटाहि इळ्न अर्सि डोलो. ");
INSERT INTO mrr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","मति मीट इतेके वेल्‍लाङे कोळ्का पिटेह्‌काय वीळिस, देवुळबाबाना मुनेह एक्‍वा मोलातोरिर. ओसो (ओग़ मीवा लोप्पा कतम पुन्ह्‌तोग़,) मीवा तलातगा बेचोक केल्क मन्ह्‌ताङ, इद वने ओग़ पुन्ह्‌तोग़. (मीकु देवुळता विचरलेवा बातय आयो आयग़ा,) अदिह्‌के मीटु ओर तिपल केवालोरिह्‌क रेयमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“बोरु लोकुरा मुनेह येसुनाङ कग़यवानन इन्जि कबुल आस्तोर, ओरिन नना वने आक्रि नेयमता वेलाते, नावा देवुळदीपतोग़ बाबाना मुनेह, वेर मावोरे इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","बोर बारा नाकु लोकुरा मुनेह पुनोन इनदनुर, ओरिनु नना वने नावा देवुळदीपतोग़ बाबाना मुनेह, वेर मावोर आयोर इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“सबेटोर लोकुर गूनमते मनदना इन्जि, वेग़ इद बूमते वातोग़ इनजोर, नावा लोप्पा इनमाटु. बाराह्‌क इतेके लोकुर गूनमते मनदना इन्जि वावोन, मति नना वाताह्‌के नाक नमवालोरु, नाक नमवोरु, वेरा नडुम जग्ळम पुटग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","इतेके नयेनाह्‌के तपेना संगे मग़ि, तलिना संगे मयाळि, अहे आतोना संगे कोयाळि, इद्रम वेर कोंटेङ आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","लोताय मांदि तमतमाये कोंटेनोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","बोर नाकाय वीळिसि तमाङ तलिस्क-तपेरिन एक्‍वा जीवा कीस्तोर, ओर नावाङ कग़यलाह ओप्पोर. अहे बोर नाकाय वीळिसि तमाङ मग़्क-मयास्किन एक्‍वा जीवा कीस्तोर, ओर वने नावाङ कग़यलाह ओप्पोर. ");
INSERT INTO mrr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ओसो बोर तमा हव्कनागुटा कांजतप, नावा पयाह वाताह्‌कु, कोंटेङ, अड्सन्क आपलाह तयर आयोर, ओर वने नावाङ कग़यलाह ओप्पोर. ");
INSERT INTO mrr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","बोर इंजेके तमा कुदता जीवातुन पिसिह कीयलाहि ऊळिह्‌तोर, ओर आक्रिते बूळेम आयनुर. मति बोर नयेनाह्‌कु सबे पोहतह्‌तोर, ओरिह्‌क देवुळि पूना जीवा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“बोर मीक एरे कीस्तोर, ओर नाक वने एरे कीतप मन्ह्‌तोर; ओसो बोर नाक एरे कीस्तोर, ओरु नाक लोहवाल बाबान वने एरे कीतप मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","देवुळता कबुरतोग़ ओर्विन, कबुरतोग़ इन्जि बोर बेस ऊळिह्‌तोर, ओरिह्‌कु देवुळतेनाह कबुरतोनाय इनम दोर्कग़ा. ओसो सेतेम मन्कल ओर्विन, सेतेमतोग़ इन्जि बोर बेस ऊळिह्‌तोर, ओरिह्‌कु सेतेमतोनाय इनम दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","इह केंजाट, नना सेतेम वेहतह्‌नन, मियग्डाहि ओर्वोग़ उड्लोन्क इंका येसुनाङ कग़यवाल इन्जि, उंद गिलसमेंड दळ्ङता एग़ तेला उनडलाह बोग़ ईयनोग़, ओन्कु इद दर्ममता इनम देवुळताहि निटमे दोर्कग़ा,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","अस्के येसु तनाङ बळयिर, बारा मांदतुन इव अडोङ वेहतनाङ मारिह कीतस्के, तना कबुरतुन पोकुर कीयलाहि, ओरिन लोहतोग़. लोहचि, ओग़ अग्डाहि पेसिस, अग्डाङ नाह्‌कने देवुळता कबुर वेहचोरे, काग़्हचोरे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","देवुळता पेदिरते एते मीहवाल योहन जेलते मनेके, देवुळ लोहतोग़ येसुराजानाङ कबस्किन केंजतोग़. केंजिसि वेग़ तनाङ कग़यवालोरिन इतोग़, “येसुनगा अन्जि इद्रम ताल्ह्‌किस वाटु, ‘बोग़ देवुळ लोहवाल पिसिह केवाल राजाल वावाल मतोग़, ओग़ बह निमानेया? बार माटु दुस्रोना अग़ ऊळकोमा?’” इन्जि ओरिन येसुनगा लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","वेर कग़यवालोर येसुनगा वासि अह ताल्ह्‌कतस्के, येसु वेरिन इतोग़, “मीट बाताङ केंजिह्‌निर, ऊळिह्‌निर, अविने मल्स अन्जि योहनिह्‌क वेहाट: ");
INSERT INTO mrr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","नाक देवुळ ईतद लावते गुडिर तोवयलाह आतोर, कूटालोर ताकलाह आतोर, मोंडरोगमतोर सव्रेम आस्तोर, एव्डालोर वेनदलाह आतोर, हातोर बार तेग़्किह्‌तोर, गरिबतोरिह्‌क बेसता कबुर केंजलाह दोर्किह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","नना बोनन आंदन इन्जि, बोर उन्क-मन्क आयोर, ओर देय्वातोरे, इह इनजोर योहनिन वेहाट,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","योहननाङ कग़यवालोर अग्डाहि पेसिस अनेके, येसु मुडोरा संगे पया योहनना लोप्पा वेहता बोटटोग़, “पेळ्ह्‌कल बूमते मीटु योहननाङ केंजलाह अतिर अस्के, बेद्रमता मन्कन ऊळलाह अन्जि? वळ्यते विग़्कु-वग़्कु आयनद काग़रोंडालेह्‌का, तना पोल्‍लोतुन मिळ्हच-मिळ्हच वेहवान ऊळलाह अन्जिया? ");
INSERT INTO mrr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","अद्रमतोन आयवेके पया, बोन ऊळ अन्ज मतिर? रेसेम गेंदेङ उहतोग़ मन्कनुया? केंजाटु, रेसेम गेंदेङ उहतोर मन्कलोर पेळ्ह्‌कल बूमतगा मनोर, राजमिदेनगान मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","पया बाराह्‌क अन्ज मतिर, रा? देवुळता कबुरतोन ऊळलाह, आयोया? मीक नना वेहतह्‌नन, मुनेतोर देवुळता कबुरतोरा सेवातुह्‌क वीळिस, योहनना सेवा मता, अद्रमतोने मीट अन्जि ऊळतिर. ");
INSERT INTO mrr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ओनाय लोप्पा देवुळि मुने तना लोहवाल पिसिह केवान वेहच मता, ‘ऊळा, नना नावा बळयिन नीवा मुने लोहतह्‌नन. निमा लोकुरा जीवातगा वायना इन्जि, नीवा अग़दुन ओग़ तीर्ह्‌कनोग़.’ इदे सास्त्रमते रासतद मन्ह्‌ता. (ओग़ बळयि इतेके योहनिये.) ");
INSERT INTO mrr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","इह केंजाट, नना सेतेम वेहतह्‌नन इतेके, देवुळताङ पाळ्नाङ अडोने ताकवालोरगा, देवुळता पेदिरते एग़ मीहवाल योहनिह्‌काय वीळिस, बोग़े बेरोग़ पुटोग़ आसि. मतिंगा बोरगा देवुळ राजेम कीस्ता, ओरग्डाहि सबेटोरिह्‌क उड्लोग़ वने योहनिह्‌काय बेरोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","देवुळता पेदिरते एग़ मीहवाल योहन, कबुर वेहचोर वाताङ दियानाहि नेंड एवनाह्‌जोम, देवुळ तना राजेमतुन जोरतेने निल्पिह कीसोर मन्ह्‌ता, अह आसि लोकुर तान पोयतलाह, दोबेङ-नूकेङ कीसोरे लोप्पा नेङिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","इतेके योहन वानाह्‌जोमु, देवुळताङ सबेटोर कबुरतोरा सास्त्रम ओसो मोसानाङ अडोङ, मुनेने देवुळ लोहवाल राजाल वायनदिना लोप्पा वेहच मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","मुनेतोर कबुरतोर बेस्के ‘(देवुळ लोहवाल राजाना मुने), एलियाल कबुरतोग़ इद बूमते मल्स वायनोग़,’ इनजोर इंदुर, अस्के ओरु योहनना लोप्पाने वेहन्दुर. इदिन पुनदलाह मीवा विचर मन्ह्‌ता इतेके पुन्ह्‌टु: योहन इतेके एलियाललेह्‌काडोग़े! ");
INSERT INTO mrr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","मियग्डाहि बोरिह्‌कु पुनदलाह गिर्दा मन्ह्‌ता, नावा पोल्‍लोतुन बेस केंजाटु! ");
INSERT INTO mrr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“मीट योहननाङ केंजवोरिर, नावाङ इंका केंजवोरिर, मीट बेद्रमतोरिर इनदना, तेन केंजाट. बोर पेकोर बजरतगा कग़्सलाह उदिसि, तमाङ गोतयालोरिन केयिह्‌तोर. केयसोर ओर इन्ह्‌तोर, ‘मीक इनजोर माटु तुरुस्कने रेला पाटाता रेगा ऊरतोम, तेला मति मीट एंदविर. पया माट हामुर रेगाताङ पाटाङ ओतोम, तेला मति मीट मोरो-मोरो इनजोरे, अळसोरे अर्युल पायविर.’ ");
INSERT INTO mrr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","अद्रमे योहन लोकुरा संगे उदसोर बेस तिनजोर-उनजोर वावोग़, अदिह्‌क इसि ओनगा देयम मन्ह्‌ता, इद्रम ओन इन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","मति माने-मन्कना नडुम पुटटोनन बेस तिनजोर-उनजोर वाताह्‌क इसि, नाक वळ्ह्‌किह्‌तोर, ‘ओन ऊळाट, ओग़ उळ्बे, ओचे, सिद्‌वा एनवालोरा, पाप्यहलोरा गोतयाल!’ इद्रम नाक इन्ह्‌तोर. (योहन अह मताह्‌क वने मीक अरवोये, नना इह मताह्‌क वने मीक अरवोये.) मति बोर देवुळता बुदते ताकिह्‌तोर, ओराङ कबस्क सेतेम दिसनुङ,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","पया बेव नाह्‌कने येसु तनाङ बेह्‌रा डीसाताङ वेल्‍लाङे कबस्क कीतोग़, अग्डोरु पापमताहि मिळ्न्दवाह्‌कु, ओरिन ओग़ु इहलेह्‌का तप तोहता बोटटोग़: ");
INSERT INTO mrr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ए कोराजिन नाटेनोरिर! ए बेत्‍सेदा नाटेनोरिर! देवुळि मीक सिक्सा ईयग़ा. बाराह्‌क इतेके मियगा बेव बेरा डीसाताङ कबस्क कीतन, अवु सोर, सिदोन इव लाग्वाङ नाह्‌कने कीस मतेके, अग्डोरु अस्केन बेस्कोटे निटमे केंजेर; पोता-गेंदेङ उहचि, तलातगा नेग़ दोसिसि, मावा पापमताहि मिळ्न्दतोम इन्जि, ओर तोहेर. (मति मीट इतेक मीवा पापमताहि मिळ्न्दविर!) ");
INSERT INTO mrr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","करल इदे मन्ह्‌ता, सोर, सिदोन इव नाह्‌िकह्‌काय वीळिसि, मीक नेयमता आक्रि दियाते देवुळि वेल्‍ला सिक्सा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ओसो ए कापेर्नाटेनोरिर! मीट देवुळदीपतगा पोग़ोन एवयकोम इह्‌निरा? आयो, देवुळि मीक इळ्ने हानादीपतगा पोहचीयग़ा! मियगा नना बेव बेरा डीसाताङ कबस्क कीतन, अव कबस्क सोदोम नाटे तेला कीस मतेके, अद नाटेनोर तमा पापमताहि मिळ्न्देर, अह आसि सोदोम नेंड एवनाह्‌जोम पिसालि, देवुळि तान बूळे केवो आवालि.(मति मीट इतेक मीवा पापमताहि मिळ्न्दविर!) ");
INSERT INTO mrr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","नना मीक वेहतह्‌नन, सोदोमतुह्‌काय वीळिसि, मीकु नेयमता आक्रि दियाते, देवुळि वेल्‍ला सिक्सा ईयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","अस्के येसु देवुळतुन जोहर कीस इतोग़, “ए बाबा! इळ्ता, पोग़ोटा बूमता सामिनिन! नना नीक जोहर कीय्ह्‌नन, बाराह्‌क इतेके निमा इव सेतेम पोल्‍लोनु, बुदतोरोम, पका तेळियतोरोम इनवालोरिह्‌क तोहवालेवा, उड्लोरोम, बुदलेवोरोम इनवालोरिह्‌क तोहतिन. ");
INSERT INTO mrr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","निटमे बाबा, नीवा विचर इद्रमे कीयनद मता.” ");
INSERT INTO mrr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","पया येसु इतोग़, “नावा बाबाल नाकु सबे पुनदलाह ईतोग़. देवुळबाबान विळ्सिस, बोग़े बार देवुळता मग़िन पुनोग़. ओसो बाबान सिरप नना, ओना मग़नन, पुह्‌नन, ओसो बाबान तोहतलाह बोरिन नना आचिह्‌नन, ओर वने बाबान पुनदनुर. ");
INSERT INTO mrr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“एय कह्‌टेम कीसोर बागतोरिर, (वेल्‍लाङे अडोङ-उतुर्कना) मोता कांजतोरिर, मीट सबेटोरिर नयके वाटु, अस्के नना मीवाङ जीवाह्‌कु आरम ईकन. ");
INSERT INTO mrr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","नना पेदातनम केवानन आयोन, ओसो जीवाते कुलुल मह्‌नन. अदिह्‌क (मीवा पूहतद जुवातुन पोहचि,) मीट नावाये जुवा कांजाटु. ओसो नावाङ कग़याटु, अहे कीम्ह्‌टु, अस्के मीवाङ जीवाह्‌कु आरम दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","बाराह्‌क इतेके नावा जुवा पूहो, नावा मोता अल्को मन्ह्‌ता!” ");
INSERT INTO mrr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","अद तूकने येसु तनाङ कग़यवालोर बार, वारमता पोल्वादियाते बोराङो पोलह्‌कना नडुमतुह्‌क अतोर. अनेके ओरिह्‌क कग़्व वसताह्‌कु, ओर गोह्‌कनाङ एन्किन ऊचिसि तिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","तेन ऊळिसि उय्तुर परुसिर इतोर, “पोल्वादियाते बेदे कबळ इटलाह पोलो, तानु नीवाङ कग़यवालोर नोमोर” इन्जि, येसुन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","अस्के येसु ओरिन इतोग़, “मुनेता कालमते दाविद राजाल तनाङ ऐंगेटोर बार, ओरिह्‌क कग़्व वसतस्के बह कीतोर, तेन मीटु सास्त्रमते बेस्केन अर्वविरा? ");
INSERT INTO mrr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ओरु देवुळता रावुळतगा बह अतोर; अगा देवुळतुह्‌क वाटटाङ बेव आरिङ सिरप बूमयालोरिह्‌के तिनदलाह पोलिह्‌ताङ, अवे आरिनु बूमयालोर ओरिह्‌क तिनदलाह ईतोर.(अस्के देवुळि दाविद राजानु तपतिन इन्जि इनो अले.) ");
INSERT INTO mrr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","अद्रमे पोल्वादिया मतेकाय, बूमयालोरिह्‌कु मंदिरता माळना कबळ कीयना पोलिह्‌ता, अस्के ओर पोल्वादियाता अडोतुन कळ्‍वोग़ केवोर, इदिन मीटु सास्त्रमते अर्वविरा? ");
INSERT INTO mrr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","नना मीक वेहतह्‌नन, मंदिरतुह्‌काय वीळिस बेरा पोल्‍लो मियगा एवता! ");
INSERT INTO mrr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","मोक-मोह्‌रम ईयना वाटो, ओर्विनेनाह्‌क मीटु जीवा लोपतप मनदनद बेसु, इहे नावा विचर मन्ह्‌ता, इद सास्त्रमते देवुळ वेहतद पोल्‍लोता अर्तम मीट पुन्ज मनेरिर इतेके, कसुरलेवोरिन मीट तप तासविर आवेरिर. ");
INSERT INTO mrr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","बाराह्‌क इतेके नना माने-मन्कना नडुम पुटटोनन मन्जि, पोल्वादियाते पोलनदिन, पोलवदिन वेहतनद अदिकर नाक मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","अग्डाहि पेसिस पया, येसु तनाङ कग़यवालोरा संगे ओरा पार्तनाता लोन अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","अतस्के अगा ओर्वोग़ वाग़ता कयदोग़ मतोग़. अस्के येसुन तप तोहतलाह इनजोरे, “पोल्वादियाते दुकतुन सव्रे कीयनद कबळ पोलिह्‌ताया, बार पोलोया?” इन्जि ओनु परुसिर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","अस्के ओरिन येसु इतोग़, “मियग्डाहि ओर्विनगा उंदिय गोरे मतेके, अदु पोल्वादियाते बोंदातगा अरतेके, तान अदे दिया ओग़ु तेंडोग़ आयनोग़ा? ओग़ निटमे तेंडनोग़! ");
INSERT INTO mrr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ऊळाटु, गोरेतुह्‌काय मन्कना जीवा बेचोटा बेरा मन्ह्‌ता! अदिनेनाह्‌कु पोल्वादियाते ओर्विनेनाह्‌क बेसता कबळ कीयना पोलिह्‌ता,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","पया “कय आहा!” इनजोर येसु वाग़ता कयदोन इताहे, ओग़ तना कयदुन आहतोग़. अस्के अद वाग़ता कयु, दुस्रा कयलेह्‌का सव्रेम आता. ");
INSERT INTO mrr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","मति ओर परुसिर पलत पेसिसि, येसुन बह कीस हव्ककल इनजोरे, तमतमाय वळ्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","इव पोल्‍लोङ केंजिसि, येसु अग्डाहि पेसतोग़. अस्के वेल्‍लाय मुल ओना पयाह अतोर. ओराङ सबेटोर रोगह्‌लोरिन ओग़ सव्रे कीसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“केंजाटु, नना मियेनाह्‌क इह कीतन इन्जि, बेगान बह वेहमाटु!” इनजोर येसु सव्रेम आतोरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","इद्रमि यसयाल इनवाल देवुळता मुनेतोग़ कबुरतोग़, देवुळ लोहवाल राजाना लोप्पा बेद पोल्‍लो वेहच मतोग़, अद इंजेके करल आता. अद इह मन्ह्‌ता: ");
INSERT INTO mrr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","देवुळि इन्ह्‌ता, “ऊळाटु, वेग़ नावा सेवकि, वेने नना आचतन, वेनगाने नना जीवा वाटिह्‌नन, वेना संगे नना गिर्दाते मह्‌नन. वेना पोग़ोन नना नावा पवित्र जीवातुन रेहतकन. वेग़ सबे जातिनोरिह्‌कु, नावा सेतेमतुन आबुर कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","वेग़ बोनाय संगे वह्‌चोग़ आयनोग़, जोरते केयोग़ आयनोग़. ओसो वेना आळो बजरते लोकुरिह्‌क वेनदा वावो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","वेना सेतेम गेल्सनाह्‌जोमु, वेग़ु सनिसारम पोयतप मनवालोरिनु वेग़्होग़ आयनोग़, ओसो आसालेवप मनवालोरिह्‌कु आसा ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","अहे वेनगा सबे जातिनोर आसाते मनदनुर,” इन्जि इन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","अस्के पया देयह्‌क पोयताह्‌कु, मूकाल-गुडि आता मन्कनु, लोकुर येसुनके ततोर. ततस्के येसु ओन सव्रे कीसीतोग़, अस्के ओग़ मन्कल वळ्ह्‌क बोटटोग़, अहे तोवया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","अस्के लोकुर पका बामिसि इनदलाह आतोर, “बह दाविद राजाना कूळते पुट वावाल मतोग़, वेग़ ओग़े पिसिह केवाल मनदनोग़ा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","मति अगा मतोर परुसिर इदिन केंजिस इतोर, “वेग़ कोनि बेल्जेबुब इनदनद देयह्‌कना मुक्यानाय साय्ताते, देयह्‌किन पूंड पग़यह्‌तोग़!” इद्रम अडम वळ्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","परुसिराङ पोटाताङ विचर्क पुन्जि, येसु ओरिन इतोग़, “बेदाय राजेमते तमाय नडुमि कोंटेङ पुटटेके, अद राजेम लेङिह्‌ता. अहे लोतगाय, नाटेनगाय कोंटेङ पुटटेके, अव वने निलोङ. ");
INSERT INTO mrr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अद्रमे देयह्‌कना मुक्याल तनाङे देयह्‌किन पूंडटेके, अविस्कनगा वने कोंटेङ मन्ह्‌ताङ. पया अविना राजेम बह नितग़ा? ");
INSERT INTO mrr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अले, मीट इतपु, देयह्‌कना मुक्याना लावते नना देयह्‌किन पूंडटेके, मीवोर पया देयह्‌किन पूंडिह्‌तोर, बह ओर वने देयह्‌कनाये लावते पूंडिह्‌तोरा? इद्रम मीवाङ विचर्क चुकताङ इन्जि, ओर तमाय तोहतनुर! ");
INSERT INTO mrr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","मति देयह्‌किन नना देवुळता जीवाता लावते पूंडिह्‌नन इतेके, मियगा देवुळ राजेम कीयलाह आता, इदिन पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","इदिन पुन्पिह कीयलाह, नना मीक उंद पोल्‍लो वेहतह्‌नन: उंद लोतगा नेङिसि लूटे केवाल मुने अग्डोग़ पळ्योनु दोहवालेवा, अग्डा मादुन लूटे कीसि पेहता पग़यनोग़ा? आयो, ओन मुने दोहतेकेने, ओना लोतुन वेग़ लूटे कीस ओयनोग़. (अद्रमलेह्‌का देयह्‌कना पळ्योन दोहतेकेने, नना देयह्‌किन पूंड पग़यकन.) ");
INSERT INTO mrr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“बोर नावा संगे गोतते मनोर, ओर नावा विरुद मन्ह्‌तोर. ओसो बोर नावा संगे लोकुरिन जमा कीयलाह तोळ आयोर, ओरु नयग्डाहि लोकुरिन बिरोबटो कीस्तोर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","पया (ओर परुसिर देवुळता जीवातुन उस्कतप वळ्ह्‌किह्‌तोर, इदिन तोहतलाह) येसु ओसो इतोग़, “नना मीक वेहतह्‌नन इतेके, मन्कना सबे पापमतुनु अहे देवुळता अडम वळ्ह्‌कतदिनु, देवुळि मापि कीया पग़यग़ा. मति देवुळता पवित्र जीवातुन बोग़ उस्किह्‌तोग़, ओन मात्रम देवुळ मापि केवो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","अहे बोग़ माने-मन्कना नडुम पुटटोना अडम वळ्ह्‌किह्‌तोग़, ओन इंका देवुळि मापि कीया पग़यग़ा. मति देवुळता पवित्र जीवाताङ कबस्किन बोग़ उस्किह्‌तोग़, ओन देवुळ मापि केवो आयग़ा. इद कालमते आयि, वायना कालमते आयि, बेस्केन मापि केवो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“केंजाटु, मराङ तमाङ कायानग्डाहे पुनदा वास्ताङ. मरा बेसतल इतेके, तानाङ कायाङ वने बेसताङ. अहे मरा लागो इतेके, तानाङ कायाङ वन लागोङ. ");
INSERT INTO mrr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","एय वीसमतरसलेह्‌काडोरिर, मीट लाग्वोरिर मन्जि, मीक नेह्‌नाङ गोटिङ बह वळ्ह्‌क वायनुङ! बाराह्‌क इतेके, पोटातगा बेव पोल्‍लोङ निंदिस मन्ह्‌ताङ, अवे पोल्‍लोङ तोडटाहि पेसिह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","बेसतोग़ मन्कल तना पोटाताहि बेसताङ पोल्‍लोङ पेसिह कीस्तोग़, अहे लाग्वोग़ मन्कल तना पोटाताहि लाग्वाङ पोल्‍लोङ पेसिह कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ओसो नना मीक वेहतह्‌नन, आक्रि नेयमता दियाते, देवुळि मीवा तोडटाहि पेसतद, उंद-उंद उगसता पोल्‍लोता इसब मियग्डाह एतग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","बाराह्‌क इतेके, आक्रि नेयमता दियाते, निमा कसुरतोनिन मह्‌निना, इलविना, इदिन नीवाङ इद बूमते वळ्ह्‌कताङ पोल्‍लोङ तोहतनुङ,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","अस्के उय्तुर परुसिर, सास्त्रमगूरुर येसुनगा वासि इतोर, “गूरु, नीवा कयदग्डाहि बामिह कीयनद सीना माक ऊळना मन्ह्‌ता,” इद्रम ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","अस्के येसु ओरिन इतोग़, “लाग्वोरु, देवुळतुन केंजवोरु, नावाङ बेरा डीसाताङ कबस्किन ऊळतोर इद पीळतोरु, नाक सीना ताल्ह्‌किह्‌तोर. मति योनाल इनवाल देवुळता कबुरतोन्क बह बह आता, सिरप अदे सीना नना ओरिह्‌क तोहतकन, तान विळ्सिस दुस्रा सीना तोहोन. ");
INSERT INTO mrr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","इतेके योनाल बेद्रम नग़्का-पियल मूंड दियाङ बेरा मीनता पोटालोप्पा मतोग़, अद्रमे माने-मन्कना नडुम पुटटोनन, नना नग़्का-पियल मूंड दियाङ इद बूमता लोप्पा मिंजिस मनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","केंजाटु, योनाना कबुरतुन केंजिसि निनवे सहरतोरु, तमा पापमताहि मिळ्न्दतोर इन्जि पुतिर. ऊळाटु, योनाह्‌काय वीळिस बेरा पोल्‍लो मियगा एवता, (मति मीट इतेक केंजविर). अदिह्‌के आक्रि नेयमता दियाते, निनवे सहरतोर निचि, इद पीळतोरिनु तप तासनुर. ");
INSERT INTO mrr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","अद्रमलेह्‌काने सीबा देसेमता रानि साल्मोन राजाना बुदताङ पोल्‍लोङ केंजलाहि, वेल्‍ला जेकताहि इगा वास मता. ऊळाटु, साल्मोनिह्‌काय वीळिस बेरा पोल्‍लो मियगा एवता, मति मीट इतेक केंजविर. अदिह्‌के आक्रि नेयमता दियाते, अद रानि वने निचि, इद पीळतोरिनु तप तासग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“(इद पीळता बाताल आयग़ा, इदिन पुन्पिह कीयलाह नना मीक उंद पोल्‍लो वेहतह्‌नन.) उंद देयमि बेस्के मन्कनाहि पेसिह्‌ता अस्के, अद तन्क मनदलाह, इके-अके मेटाङ-मेटाङ वेलियिस, जागाङ पर्ह्‌किस ऊळिह्‌ता, मति तान्कु जागा दोर्को. ");
INSERT INTO mrr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","अस्के अद देयमि आलिह कीस्ता, ‘बोनग्डाहि नना पेसिस वातन, अगा ओसोवन मल्स दाकन,’ इद्रम इन्ह्‌ता. पया अन्ज ऊळिह्‌ता अस्के, अद मुनेता लोनु रिकम आतदु, नेहतदु, ऊसतदु, इद्रम तान्कु बेस दिसिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","अस्के पया अद अन्जि, तन्काय लाग्वव एळुङ देयह्‌किन, तना संगे गोत कीस ततह्‌ता. अस्के अवु ओग़ मन्कना लोप्पा नेङिस जागा आस्ताङ. पया ओना इंजेटा गोसा, मुनेतदिह्‌काय वेल्‍ला करबता आस्ता. अद्रमलेह्‌काने इद लाग्वा पीळतोरिह्‌कु, तमाङ जीवाने नावाङ पोल्‍लोह्‌क जागा एवाह्‌कु, इद्रमे गोसा आयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जमा आता मुडा संगे येसु वळ्ह्‌कसोर मनेके, ओना तलोग़ि, ओनाङ तमोर वासि, ओना संगे वळ्ह्‌कना मन्ह्‌ता इन्जि, लोता पलते निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","अस्के बोग़ो येसुन वेहतोग़, “गूरु, नीवा यायालि, नीवाङ तमोर पलते नीवा अग़ ऊळसोर निच मन्ह्‌तोर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","इदिन केंजिस येसु ओन इतोग़, “नावा यायालि, नावाङ तमोर, नावा लोतोर बोरु, इदिन मीट पुह्‌निरा?” ");
INSERT INTO mrr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","इतस्के पया तनाङ कग़यवालोरक्‍के कय ऊपिसि, “ऊळाटु! नावा लोतोर इतेके निटम वेरे! ");
INSERT INTO mrr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","बोर नावा देवुळदीपतोग़ बाबाल वेहतपु ताकिह्‌तोर, ओरे नावा दादाललेह्‌का, तमोग़लेह्‌का, एलाळलेह्‌का, अकाललेह्‌का, तलोग़लेह्‌का एरेटोर आंदुर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","अदे दिया येसु लोताह पेसिसि, सम्दुरकचुल अन्जि उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","वेल्‍लामुलु ओना पेग़्के गोह्‌डिनाङ गोह्‌डिङ वांदुर, अदिह्‌कु ओग़ु एग़कचुल उंद ओडातगा अन्जि, काग़्हतलाह उदतोग़. कतमतोर पया ओना मुनेह दडकचुल नितोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","पया ओग़ु वेल्‍लाङ पोल्‍लोङ, पुन्पिह कीयनाङ पीटोने वेहता बोटटोग़. उंद पीटो इह मता: “केंजाटु, वीतवाल ओर्वोग़ विजा वीतलाह पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ओग़ वीतनेके उडुन विजा अग़दगा अरता, अदिनु पिटेङ वासि कतम तिताङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","उडुन विजा आद बंडाना जागाते अरता. अगा आदता पोग़ोन बर्बर तोळ्यो मताह्‌कु, अद तोळ्यो उबिसि अग्डा विजा चट्पिटे मोन्ह्‌टटा. ");
INSERT INTO mrr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","मति ईर्क लोप्पा अनवाह्‌कु, एद तेग़तस्के पोर्ह्‌काङ वाग़ताङ, पया वतिस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ओसो उडुन विजा कोये-जपिना जागाते अरता. पया कोये-जपिङ बेर्सिसि, अग्डा पेसना वंज-सोपतुन हव्कताङ, बेर्स एवोङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","उचुन विजा इसि राब जागाते अरता. अरताह्‌कु अदु उंद-उंद मोदुदुह्‌कु बेगा डेडा वीसा (30), बेगा मूंड वीसाङ (60), बेगा नूरु (100) इद्रमलेह्‌का तेना पंटा वाता. ");
INSERT INTO mrr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","मियग्डाहि बोरिह्‌क पुनदलाह गिर्दा मन्ह्‌ता, नावा पोल्‍लोतुन बेस केंजाटु!” इनजोर येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","पया तनाङ कग़यवालोर ओनगा वासि ताल्ह्‌कतोर, “निमा लोकुरिह्‌कु पुन्पिह कीयनाङ पीटोने बाराह्‌क वळ्ह्‌कसोर मह्‌निन, गूरु?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","येसु पया ओरिन इतोग़ “मीक इतेके, देवुळि तना राजेमताङ मकतव पोल्‍लोन पुनदलाह बुद ईता, ओरिह्‌क बार एवो. ");
INSERT INTO mrr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","केंजाटु, बोनगा पुनदनद बुद मन्ह्‌ता, ओन्कु देवुळि ओसो इंका ईयग़ा, ओन्कु वेल्‍लाय दोर्कग़ा. मति बोनगा पुनदनद बुद इले, ओनगा उचुन मतद बुदतुन वने, देवुळि ऊंदिस ओयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","अदिनेनाह्‌कु नना पुन्पिह कीयनव पीटोने ओरिन वळ्ह्‌किह्‌नन, बह इतेके ओर तमाङ कोंडाने नावाङ कबस्किन ऊळिह्‌तोर, तमाङ केव्कने नावाङ पोल्‍लोन केंजिह्‌तोर, मति तमा बुदते ऊळलाह, केंजलाह, पुनदलाह ओर गळ्स आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","यसयाल इनवाल (तना कालमतोरा लोप्पा) मुने रासतद देवुळता कबुर इह वेहतह्‌ता: ‘ओर लोकुर नावाङ केंजलाह कोनि केंजसोर मनदनुर, मति ओरिह्‌क बेस्केन तेळियो आयग़ा; नावाङ कबस्किन ऊळलाह कोनि ऊळसोर मनदनुर, मति अविना अर्तम ओरिह्‌कु बेस्केन तेळियो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","बाराह्‌क इतेके ओरा बुद गळ्स आता; केव्कने केनकेने केंजिह्‌तोर, ओसो तमाङ कोंडाङ पिहतह्‌तोर. अद्रम आसि ओर कोंडाने ऊळ पग़वोर, केव्कने केंज पग़वोर, बुदते पुनदा पग़वोर, अहे सव्रेम आयलाह नयगा वावोर,’ इन्जि देवुळ यसयान इन्ह्‌ता. (इद पोल्‍लो नावाङ केंजवोरा लोप्पा इर्सा करल आता.) ");
INSERT INTO mrr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“मति मीट बारा नावाङ कबस्किन ऊळिह्‌निर, नावाङ पोल्‍लोन केंजिह्‌निर इतेके मीट देय्वातोरिर. ");
INSERT INTO mrr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","इह केंजाट, नना सेतेम वेहतह्‌नन, नेंड मीट बेव ऊळिह्‌निर, केंजिह्‌निर, अविनु मुनेतोर देवुळता कबुरतोर ओसो सेतेमतोरु, इद्रम वेल्‍लाटोरे ऊळलाह, केंजलाह पप्ळेम आंदुर. मति ओरिह्‌कु ऊळ दोर्को, केंज दोर्को. ");
INSERT INTO mrr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“मीटु इंजेके विजाता पीटोता अर्तमतुन पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","अद विजा इतेके देवुळ राजेम कीयना लोप्पाडा बेसता कबुरि. इद कबुरतुन बोग़ केंजिह्‌तोग़, मति ओन्क तेळियो आस्ता, ओना जीवातगा वीततद विजातुनु, देयह्‌कना मुक्याल वासि ऊंदिस ओस्ता. इद्रमतोर लोकुर विजा अरतद अग़दा जागालेह्‌का आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","बेद आदतगा विजा अरता, अद इहलेह्‌का आस्ता. बोर कबुरतुन गिर्दाते चट्‌नेन केंजिह्‌तोर, मति अद पोल्‍लो जीवाते गडवाह्‌कु, गळ्के बहे दीरा पोयतह्‌तोर. पया देवुळता पोल्‍लोतुन नमतेनाह्‌क अड्सनाय, तिपलाय वाता इतेके, चट्‌नेन ओर विस्वसते पेग़्के अरयह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","कोये-जपिङ मतद जागा इहलेह्‌काडा आंदु. बोर कबुरतुन केंजिह्‌तोर, मति सम्सरमताङ आल्सुळ्क ओसो अनम-दनमता उळ्बे, इव कोयेनलेह्‌काडाङ देवुळता पोल्‍लोतुन ओरा जीवातगा मोन्ह्‌ट एवोङ, पया अद पोल्‍लो बातय पाय्दाता आयो. ");
INSERT INTO mrr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","मति राब जागा इहलेह्‌काडा आंदु. बोर कबुरतुन केंजिह्‌तोर, काळ्ङिह्‌तोर, पया ओरु पलत पेसिसि बेसताङ कबस्क कीस्तोर. बेद्रम राब जागातगा अरतद विजा, उंद-उंद मोदुदुह्‌कु बेगा डेडा वीसा (30), बेगा मूंड वीसाङ (60), बेगा नूरु (100) इद्रमलेह्‌का तेना पंटा वाता, अद्रमता राब जागालेह्‌का ओर मन्कलोर आस्तोर, अद्रमता पंटालेह्‌का ओराङ कबस्क दिसनुङ,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ओसो उंदि पुन्पिह कीयनद पीटो येसु ओरिन वेहतोग़. “देवुळता राजेम कीयनाङ अडोङ इहलेह्‌का आंदुङ. बोग़ो ओर्वोग़ तना पोलमते बेसता गोह्‌कना विजा वीततोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","मति सबेटोर उंजतस्के, नग़्का ओना कुळ्सातोग़ वासि, गोह्‌कनगा अकलतुन वीतिसि अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","पया पोटाङ आसि मीतस्के, गोह्‌कनाङ एन्क दिसताङ, अस्के अकल रोंडा वने दिसता. ");
INSERT INTO mrr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“अस्के लोता ओर्युलतोर वासि माल्कान इतोर, ‘महरज, निमा नीवा पोलमते बेसता विजा वीतिस मतिन इसि? अगा पया अकल रोंडा बेनाह वाता?’ इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘इद कबळि नावा कुळ्सातोना बोनायो मनदग़ा मति!’ इन्जि माल्काल ओरिन इतोग़. ‘निमा पया बह इह्‌निन, माट अकलतुन तह्‌ककोमा?’ इन्जि ओर्युलतोर माल्कान ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘एंह-एंह, आयो, अकलतुन तह्‌कनेके, मीट ओकावेला गोह्‌किन बार तह्‌ककिर! ");
INSERT INTO mrr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","कोयनाह्‌जोम अव वलियसोर अहे मनिङ. पया कोयना वेलाते नना कोयवालोरिन वेहतकन, “मुने अकल रोंडातुन कोय्म्ह्‌टु, कोसि तानाङ पिनयाङ दोहच, गुम कीसि बोळ्सिसीम्ह्‌टु. पया नावाङ गोह्‌किन मात्रमि डोमेते दोसाटु,” इनदकन,’ इन्जि माल्काल ओर्युलतोरिन वेहतोग़.” ");
INSERT INTO mrr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","पया देवुळता राजेम बेद्रम बेर्सग़ा, तेन पुन्पिह कीयलाह, येसु ओसो रेंड पीटोङ वेहतोग़. “देवुळता राजेम इहलेह्‌का आंदु. बोग़ो ओर्वोग़ तना लकाते, पुलुळ पेनेम वीततोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","केंजाटु, पुलुळ इतेके पका उड्ला पेनेम मन्ह्‌ता, ऊळविरा? तेला मति वलियतस्के, बेरा मरा आस्ता, अस्के तानाङ पंगानगा पिटेङ वासि गूडाङ पंडिह्‌ताङ.” ");
INSERT INTO mrr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","येसु पया ओरिह्‌कु दुस्रा उंद पीटो वेहतोग़. “देवुळता राजेम इहलेह्‌का आंदु. बेद उंद आंचाळि इचुने ओयता पिंडटुन, मूंड तवाङ पिंडटगा काल्ह्‌पता. अस्के मनेक मनेक, अग्डा पूरा पिंडि ओयता.” ");
INSERT INTO mrr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","इव सबे पोल्‍लोङ, येसु लोकुरिन पुन्पिह कीयनाङ पीटोने वेहतोग़. पुन्पिह कीयनाङ पीटोङलेवा, येसु ओरा संगे बातय वळ्ह्‌कोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","इदिनलोप्पा देवुळ तना कबुरतोना संगे मुने वेहच मता, अद पोल्‍लो इंजेके करल आता, अद इह मन्ह्‌ता: नना नावा तोडटे पुन्पिह कीयनाङ पीटोङ वेहतकन. बूम पुटटग्डाहि मकिस मतव पोल्‍लोनु, नना वळ्ह्‌किस तोहतकन. ");
INSERT INTO mrr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","पया येसु लोकुरिन विळ्सिसि लोन अतोग़. अस्के तनाङ कग़यवालोर ओनगा वास इतोर, “गूरु, पोलमते वीततद अकल रोंडाता पीटोतुन, माक पङ्ने तेळियिह कीस वेहा,” इद्रम ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","अस्के ओग़ ओरिन वेहतोग़, “केंजाटु, बेसता विजा वीतवाल इतेके, माने-मन्कना नडुम पुटटोनन, ननाने आंदन. ");
INSERT INTO mrr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","पोलमि, इद बारा दुनिया आंदु. बेसता विजा, इद बारा देवुळतुन मावा राजाल इन्जि नमवालोरु. अकलतुन वीतवाल इतेके, अदे देयह्‌कना मुक्याल आंदु. अकल रोंडा, इद बारा तानाङ केंजवालोरु. पंटा कोयना वेला, इद बारा बूम मारनद आक्रि वेला, अस्केने देवुळ कतमतोरा नेयम कीयग़ा. ओसो कोयवालोर इतेके देवतुल्क आंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“अस्के बेद्रमि अकल रोंडातुन कोसि, गुम कीस मन्जि किसतगा वाटिह्‌तोर, अद्रमि इद बूमता आक्रि वेलाते आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","अद वेलाते माने-मन्कना नडुम पुटटोनन, नना नावाङ देवतुल्किनु लोहतकन. नावा राजेमते वायलाह एवोरिनु, ओसो लाग्वाङ केवालोरिनु, वेर कतमतोरिने अव देवतुल्कु नावा राजेमताहि पेहचीयनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","देवतुल्क ओरिनु जमा कीसि, मळ्गना पिववद किसबटटगा वाटनुङ. अगा अमेसा केयना, अळयना, मुडुर-मुडुर पल्क कोग़्कना आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","अस्के सेतेमतोर तमा देवुळबाबाना राजेमते, पोळ्‍द दींचतप लेह्‌का, देवुळता संगे मांजसोर मनदनुर.बोरिह्‌कु पुनदलाह गिर्दा मन्ह्‌ता, ओर नावा पोल्‍लोतुन बेस केंजिर! ");
INSERT INTO mrr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“देवुळता राजेम कीयनव अडोङ इहलेह्‌का मन्ह्‌ताङ. बोग़ो ओर्वोग़ दुस्रोना पोलमते, बोंदालोप्पा मकिह कीस तासताङ कल्दर्किन नसिबलेह्‌काने ऊळतोग़. पया अविन अगान मिसिसि, पका गिर्दा आसि, लोन अतोग़. अन्जि ओग़ तना पूरा मालसोमतुन वमिसि, अव कोताने अदे पोलमतुन असतोग़, बह इतेके अव कल्दर्कु अद पोलमतगा मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“देवुळता राजेम कीयनव पोल्‍लोङ इहलेह्‌का ओसो मन्ह्‌ताङ. बोग़ो वीकुरतोग़ बेसताङ मोतिङ पर्ह्‌कलाह बजरते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ओन्क उंदि पका दाराता मोति दोर्कतस्के, ओग़ अन्जि तना पूरा मालसोमतुन वमिसि, अव कोताने इदे मोतितुन असतोग़. (इद्रमलेह्‌का देवुळता राजेमतगा वायना इतेके, दुनियाता सबे मालसोमतुन पेग़्के कीसि, देवुळतुन पर्ह्‌काटु.) ");
INSERT INTO mrr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“देवुळता राजेम कीयनव अडोङ ओसो इहलेह्‌का मन्ह्‌ताङ. मीन्क पोयवालोर गुंजना वदतुन एतगा आहतह्‌तोर, अस्के नेह्‌नाङ-लाग्वाङ सबे रीतिनाङ मीन्क वदते लोप्पा अरयह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अद वदमेंडु मीन्क आस्ताङ, अस्के पोयवालोर तान दडकचुल गुंजिह्‌तोर. पया वेरु उदिस मन्जि, बेव बेसताङ, अविनु आचिसि कोंड्राते तासिह्‌तोर, अहे लाग्वान बारा पोहचीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","अद्रमि इद बूमता आक्रि वेलातस्के आयग़ा. देवतुल्क वासि, लाग्वोरिनु सेतेमतोराहि एग़्‍पिह कीयनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","एग़्‍पिह कीसि, ओर लाग्वोरिनु पिववद किसबटटा सिक्सातगा वाटिसीयनुङ. अगा अमेसा केयना-अळयना, मुडुर-मुडुर पल्क कोग़्कना आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“इव सबे पोल्‍लोङ मीक तेळियताङा?” इन्जि येसु कग़यवालोरिन ताल्ह्‌कतोग़. “इंगो गूरु, माक तेळियताङ,” इन्जि ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“अह इतेके, बेद्रम लोता माल्काल तना विजाबडटाहि पाळ्नाङ, पूनाङ इद्रमताङ मालसोमतुन पेहतह्‌तोग़, अद्रमलेह्‌काने मीट वने देवुळ राजेम कीयनाङ अडोङ कग़यतोरिर, दुस्रोरिन काग़्हतकिर. (अस्के मीटु पाळ्ना काग़्हमुळ ओसो नावा पूना काग़्हमुळ, मीवा पोटाताहि पेहच काग़्हतकिर,)” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","पया इव पुन्पिह कीयनव पीटोङ वेहच मारतस्के, येसु अग्डाहि पेसिस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","तमा नाग़ नासरेतते वासि, ओरा पार्तनाता लोतगा, ओरिह्‌कु देवुळताङ पोल्‍लोङ वारमता पोल्वादियाते काग़्हन्दोग़. अव पोल्‍लोन केंजिसि, ओरु सबेटोर बयल आतोर. “वेन्क अचोटा बुदि, अचोटाङ बेराङ कबस्क कीयना लाव, बेग्डाहि दोर्कता, रा? ");
INSERT INTO mrr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","बह वेन इसि माट पुनोम, वेग़ वड्लाना मग़ि आयोग़ा? वेना तलोग़ मरियालि आयोया? ओसो वेनाङ तमोर वने याकुबि,योसेपि, सिमोनि, यहुदाल वेरे इन्जि माट पुनोमा? ");
INSERT INTO mrr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ओसो वेनाङ सबे एलास्क इगाने मन्ह्‌ताङ इसि. पया वेन्कु अचोटा बुदि, लावु बोग़ ईतोग़?” इन्जि नाटेनोर येसुन नमोर आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","अद्रम आसि ओर येसुन नमोम इतोर. अस्के येसु ओरिन इतोग़, “देवुळता कबुरतोन्क दुनियामेंड मान दोर्किह्‌ता, मति कुदता नाटे अहे लोते मात्रमि, मान दोर्को.(अद्रमे नाक इंका मीट अहे ऊळिह्‌निर,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ओर येसुन नमवाह्‌कु, अगा ओग़ु बेरा लावताङ कबस्क वेल्‍लाङ केवोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","अद तूकने गालिल पटटा राजाल, एरोद अंतिपस इनवाल, येसु कीताङ कबस्किन केंजतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","(वेग़ राजाल मुने देवुळता पेदिरते एतेमीहवाल योहनिनहव्किस मतोग़, अदिह्‌के) वेग़ येसुना लोप्पा इह इतोग़, “ओग़ कोनि निटमे योहन मनदनोग़! ओग़ हासि ओसो तेग़्कतोग़ बहे, अदिह्‌के ओग़ अचोटाङ डीसाताङ कबस्क कीया पग़यह्‌तोग़,” इन्जि तनाङ सेवकिरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","(योहनि, एरोद राजाल, वेरा नडुम कट्लाङ इह आताङ.) राजाना दादाल पिलिप, वेग़ जीवात मनेकेने, वेना मुते, एरोदियसि इनदनदिनु, राजाल तना लोन ओतोग़. अस्के योहन राजानगा वास इतोग़, “नीवा कीतद कबळ मोसानाङ अडोङ वेहतपु पोलो, महरज,” इन्जि वेहतोग़. इद पोल्‍लोतुह्‌क एरोद राजाल ओङ आसि, योहनिन दोहचि जेलते वाटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","अचोटग्डाहि योहनिन राजाल हव्कलाह ऊळिंदोग़, मति वेग़ देवुळता कबुरतोग़ मन्ह्‌तोग़ इन्जि, लोकुर योहनिन मान ईंदुर, अदिह्‌क राजाल लोकुरिह्‌क रेयिसि, योहनिन हव्कोग़ आसि. ");
INSERT INTO mrr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पया एरोद राजाल पुटटा दिया एवता, अद दिया राजाल कुळ्पि ईतोग़. अस्के राजाल ततदु तमदादाना मुते एरोदियसि, तेना मयाळि लोकुरा मुनेह एंदिसि, राजान गिर्दा कीता. ");
INSERT INTO mrr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","गिर्दा आसि, राजाल तान इतोग़, “निमा बाताल ताल्ह्‌ककिन, अदिन नना नीक ईकन,” इन्जि राजाल किरिया कीस वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ताना तलोग़ काग़्हच मतपु, अदु राजान इता, “काका, देवुळता पेदिरते एग़ मीहवाल योहनना तला, उंदि दळ्याते कीसि नाक तायु,” इनजोरे पिला ताल्ह्‌कता. ");
INSERT INTO mrr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","इदिन केंजिस राजाह्‌कु बेस दल्गो, मति कुळ्पतगा वाता मुडा मुनेह, किरिया कीस वेहतद पोल्‍लोतुन मिळ्हता वावो आंदु. ");
INSERT INTO mrr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अदिह्‌के राजाल जेलतगा योहनिन हव्किस, ओना तला ततलाह, तनाङ सीपय्किन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","दळ्यात कीसि तला ततस्के पया, एंदता पिलातुह्‌क ईतोर, अदु पया तना तलिनगा ओसीता. ");
INSERT INTO mrr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","पया योहननाङ कग़यवालोर ओना सेत्तातुन ओयलाह वातोर, अह कीसि ओन पोहतोर. पया इद पोल्‍लोतुन, ओरु येसुनगा अन्जि वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","इद पोल्‍लो केंजिसि, येसु तनाङ कग़यवालोर बार, उंद ओडाते उदिस पेसतोर. पया बेदो पेळ्ह्‌कल जागातके केमेन अतोर. ओग़ अतदिन पुन्जि, लोकुर ओना पेग़्के-पेग़्के तमाङ नाह्‌कनाहि ताकसोर वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","पया येसु ओडाताहि पेसिस ऊळतोग़ अस्के, वेल्‍लाय मुल नावा अग़ ऊळिह्‌तोर इन्ज पुतोग़. ओरिन ऊळिसि, वेन्कु ओरा मान वसता, अस्के ओर ततोर रोगमतोरिनु वेग़ सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","पोळ्‍द अरनेके, कग़यवालोर येसुनगा वास इतोर, “गूरु, इद पेळ्ह्‌कल जागा मन्ह्‌ता, इगा इतेके तिनदलाह बातय दोर्को, ओसो पोळ्‍द इतेक अनजोर मन्ह्‌ता. वेर मात्रमि एरेगूरेताङ नाह्‌कनगा अन्जि, तम्क तिनदलाह असिस तयिर, वेरिन लोहा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“आयो, असलाह ओरिह्‌क दाया पोयो. मीटे ओरिह्‌क तिनदलाह ईम्ह्‌टु,” इनजोर येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“आं माटु! मयगा बेचोकु, सिरप एयुङ आरिङ, रेंडे अटटव मीन्क, अचोके मन्ह्‌ताङ,” इन्जि ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“अले, अविन नयके ताटु,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","पया ऊळाटु, येसु मुडुन इळ्न रोंडातगा उद वेहतोग़, पया अव एयुङ आरिन ओसो रेंड मीन्किन पोसि, पोग़ोन ऊळिसि, देवुळतुन जोहर कीसि आरिन किळ्हतोग़. अह कीसि, वांटाट इन्जि येसु आरिङ, मीन्कु, कग़यवालोरा कयदे ईतोग़, ओर पया मुडुह्‌क वांटटोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","पया वेर सबेटोर पका पंजनाह तितोर. तिन्ज-उन्ज पिसतव किळ्केङ ओर गुम कीनेके, बारा डालाङ पेसताङ. ");
INSERT INTO mrr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","तिनवालोर मुलु एयुङ अजर्क (5000) कोय्तोरे मतोर, ओसो आस्कु, पिलाङ-पेकोर, वेरा इतेके लेकाय इले मति! ");
INSERT INTO mrr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","पया तिन्ज-उन्ज मारतस्केने, येसु तनाङ कग़यवालोरिन इतोग़, “नना लोकुरिन मल्स लोहतलाह पयाह मह्‌नन, मीट मात्रम ओडाते उदिसि, सम्दुरता अबर बाजे वेंडिस अन्ह्‌ट.” अस्के ओर अहे कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","पया लोकुरिन लोहचि, बार कीसि, येसु वग़ोग़े गुड्रापोग़ोन पार्तना कीयलाह अतोग़. नग़्का आस मता, मति ओग़ अगान मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","अद वेलाते ओरा ओडा सम्दुरता नडुमकसाते, दडटग्डाह जेक मता. अस्के वळ्यते एताङ लच्काङ ओडातुन इळ्सोह-ओळ्सोह कींदुङ. ");
INSERT INTO mrr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","अस्के पया येसु नग़्काडाङ मूंड-नालुङ एगसोरे (इतेके तलाकोग़ कूसना जोक-जोक), सम्दुरता एता पोग़ोट्क कग़यवालोरेके ताकसोरेन वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","एता पोग़ोट्क येसु ताकसोर वानेके ओर ऊळिसि, “एता मसमि वास्ता, रा!,” इनजोर रेयिस केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","अस्के तोप्नेन येसु ओरिन केयतोग़, “नना रा, रेयमाटु, दीरा कीम्ह्‌टु!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","अस्के सिमोन पत्रु येसुन इतोग़, “बोग़, निमा गूरुनिना? अह इतेके नाकु नियके एता पोग़ोट्क वायलाह वेहा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“अले अह इतेक वाय!” इनजोर पत्रुन येसु इतोग़. पया पत्रु ओडाताहि पेसिसि, एता पोग़ोट्क ताकसोर, येसुनके दायलाह बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","मति दूंदते वायनाङ बेराङ लच्कान ऊळिसि, पत्रु रेयिसि मुळ्न्दसोर मतोग़. अस्केने, “नाक पिसिह कीम सामि, नना मुळ्न्दिह्‌नन,” इनजोर ओग़ केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","तोप्नेन पया येसु ओन पोयतोग़. पोसि “बह रा, निमा विस्वसलेवपु! नना नीक पिसिह कीकन इन्जि निमा नमविना?” इन्जि येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","पया इसि ओर इर्वुर ओडातगा वास उदतस्के, अद वळ्यु बेके मायतायो, बेके मायोयो! ");
INSERT INTO mrr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","अस्के ओडातगा मतोरु “निमा निटमे देवुळता मग़निन,” इनजोर येसुनाङ काल्क मोळ्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ताना पया ओर सम्दुरतुन वेंडिसि, गनेसरत एरियाते एवतोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","अग्डोरु येसुन पुताह्‌कु, एरेगूरेताङ सबे नाह्‌कने कबुर लोहतोर. अस्के ओर सबेटोर दुकिनोरिन येसुनके पोस वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“गूरु, नीवा गेंदे कोङतुन मात्रम माक बोय ईम, अस्के माट बेस आयकोम,” इनजोर ओर दुकिनोर येसुन कालगडेम अरतोर. अहे बेच्वुर कोङतुन बोयतोर, ओर सबेटोर सव्रेम आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","पया उय्तुर परुसिर ओसो सास्त्रमगूरुर, येरुसलेम सहरताहि वासि येसुन इतोर, “नीवाङ कग़यवालोर मावाङ पेदल्कना मतद रीत-रिवजतुन बह माळोर? वेरु तिनदनामुने कळ्‍वोग़ आतदिन एडलाह, तमाङ कय्क बाताङ बाराह्‌क नोग़वोर?” इन्जि येसुन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","अस्के येसु ओरिन इतोग़, “मीट पया मीवाङ मुनेताङ रीत-रिवजतुन नोमसोरे, देवुळताङ अडोन माळवालेवा बह तपतिर? ");
INSERT INTO mrr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","(इद केंजाटु, मीवा उंद तप नना वेहतह्‌नन.)‘निमा नीवा तलोग़-तपेह्‌क मान ईम,’ इद्रम सास्त्रमते देवुळता उकुम वेहतद मन्ह्‌ता. ओसो ‘बोग़ तना तलोग़-तपेह्‌क मान एवा, ओरा कदर रेहतह्‌तोग़, ओन्क हव्कना सिक्सा ईयना,’ इह वने रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","मति मीट मात्रम इह्‌निर इतेके, बोग़ाय तना तलोग़-तपेना पिसवग़तुह्‌क ईयनविस्किनु, देवुळतुह्‌क वाटटेक बार आयो, ओग़ तलोग़-तपेह्‌कु मान एमाकेग़, इद्रम मीट काग़्हतह्‌निर. इद्रमे मीट मीवाङे रीत-रिवज्क पुटिह कीसोरे, देवुळता पोल्‍लोतुन देहतिर. ");
INSERT INTO mrr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","एय सोङ केवालोरिर, देवुळि मुने तना कबुरतोग़ यसयाल इनवाल, वेना संगे सास्त्रमते मीवा लोप्पा बराबर वेहच मता: ");
INSERT INTO mrr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","वेर लोकुर तमा तोडटेने, नाक मान ईस्तोर, मति वेर नावा पोग़ोन जीवा वाटोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","वेरा मोळ्कनद वने जोलिय मन्ह्‌ता; नावा सास्त्रम काग़्हतनदिन विळ्सिसि, तमाङे अडोङ काग़्हतह्‌तोर. इनजोर वेहता.” ");
INSERT INTO mrr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","अस्के येसु लोकुरिन तनके केयिसि ओरिन इतोग़, “नना इंजेके बार इह्‌नन, तेन केंजिसि कग़याटु. ");
INSERT INTO mrr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","(कय्क नोग़तेकाय, नोग़वेकाय,) बेद मन्कना कुमतगा दास्ता, अद ओनु करब केवो. मति पोटाताहि बेव पोल्‍लोङ तोडटुह्‌क पलते पेसिह्‌ताङ, अवे कोनि मन्कन करब कीस्ताङ,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","गय्क मनेके, कग़यवालोर येसुनगा वासि इतोर, “नांगा वेहन्दिन अद पोल्‍लोतुह्‌क परुसिर पकाय नारज आतोर, तेन निमा पुतिना, गूरु?” इन्जि वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","“नावा देवुळदीपतोग़ बाबाल बेव पोर्ह्‌कान ओग़्सोग़, अविन ओग़ु कतमे कुळ्ह-कुळ्ह तह्‌किसीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","वेर परुसिरक्‍के सीता केमाटु, वेर अहे मनिर. गुडिरिह्‌क अग़ तोहवालोर वेर गुडिरे! गुडिह्‌क गुडि अग़ तोहनेके, ओर इर्वुर आसि बोंदातगा अरयनुर!” इद्रमि ओरिन येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","पया सिमोन पत्रु ओन ताल्ह्‌कतोग़, “इद कळ्‍वोग़ता पुन्पिह कीयनद पोल्‍लोतुन, माक तेळियिह कीस वेहा, गूरु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“मीकाय इंका तेळियोया? ");
INSERT INTO mrr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","बेदिन माट तिह्‌नल, अदे कुमतगा दास्ता, पया माट पेल्किस पोहतह्‌नल. (इतेके अद करब कीयनव लाग्वाङ विचर्किन पुटिह केवो,) इद वने मीक तेळियो? ");
INSERT INTO mrr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","मति माट लाग्वा वळ्ह्‌कनदु तोडटुह्‌क पलत पेसिह्‌ता, अदु पोटालोप्पाडाहि वास्ता. तानेनाह्‌के मन्कनु देवुळि जेक तासिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","बाराह्‌क इतेके, वायनवु लाग्वाङ विचर्कु, हव्कनदु, सिंड्रि-पोह्‌डेङ कीयनदु, कले कबळ, जोल बयन ईयनदु, वह्‌चळि, इवे पोटालोप्पाडाहि पलत पेसनव आंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","मन्कनु इद्रमताङ गोटिङ कोनि करब कीस्ताङ. मति कय्क नोग़वाये तिनदना, इदु मन्कनु करब केवो आस्ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","गालिल पटटाहि पेसिस पया, येसु तनाङ कग़यवालोरा संगे सोर-सिदोन एरियाते वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","पया ऊळाटु, अद पटटा उंद यहुदि आयवदु कनान जातता आंचाळि येसुनगा वासि केयसोर इता, “ए सामि, दाविद राजाना कूळतोनिन पिसिह केवानिन, नयगा जीवा लोपा. नावा मयानु देयम पोसि, तान पट्पट अह्‌चिह्‌ता,” इनजोर ओन कालगडेम अरता. ");
INSERT INTO mrr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","मति येसु केमेन मन्जि, तान उंद पोल्‍लो तेला मल्होग़. अस्के कग़यवालोर येसुन इतोर, “मावा पेंडेस वासोर अद कयर कीस्ता, अद अनि,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","अस्के येसु तान इतोग़, “नावा बाबाल नाकु इस्रयेल देसेमतोराङ लेसताङ गोरेना लेह्‌काडोरिन विळ्सिसि, दुस्राङ जातिनोरिन साय्ता कीयलाह लोहोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","अस्के कंद्रेम आसोर वासि, येसुनाङ काल्क मोळ्कसोरे, अद इता, “नाक साय्ता कीम, सामि!” ");
INSERT INTO mrr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","अस्के येसु तान इतोग़, “पेकोराङ आरिनु लोताङ नय्किह्‌क वाटिसीयना बेस आयो,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“नीवा पोल्‍लो निटमे मन्ह्‌ता, सामि, मति लोतोर तिनदनाङ दळ्यानाहि पोवताङ पेसावार्किन वने, लोताङे नय्क तिन्ह्‌ताङ,” इनजोर अद येसुन इता. ");
INSERT INTO mrr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","“इंगो बायि, नयगा नीवा विस्वस बेचोटा बेह्‌रा मन्ह्‌ता! निमा ताल्ह्‌कतपे नीक आयि,” इन्जि येसु तान देय्वाताङ पोल्‍लोङ वेहचीतोग़. पया अदे गट्काते ताना मयाळि सव्रेम आता. ");
INSERT INTO mrr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","येसु पया अग्डाहि पेसिस मन्जि, गालिल सम्दुरकचुल मल्स वासि एवतोग़. पया बेदो उंद गुड्रापोग़ोन अन्जि, ओग़ काग़्हतलाह उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","अस्के लोकुर इतेके, गोह्‌डिनाङ गोह्‌डिङ ओनगा वातोर. वासि वेरु कूटालोर, पङ्ळालोर, गुडिर, मूकालोर, इद्रमतोर वेल्‍लाटोरिन पोस वासि, येसुनाङ काल्कनगाने ततोर. ओर सबेटोरिन येसु सव्रे कीसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","मूकालोर वळ्ह्‌किह्‌तोर, कूटालोर ताकिह्‌तोर, पङ्ळालोर सव्रेम आस्तोर, गुडिर तोवयह्‌तोर, तेन ऊळिसि जमा आता मुलु पकाय बामतोर, बामिसि इस्रयेलतोरा देवुळतुन वेर जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","तेना पया तनाङ कग़यवालोरिन केयिस येसु इतोग़, “वेर नयगान मन्जि, नेटुह्‌क मूंड दियाङ आतोर. वेरगा तिनदलाह बातय इले, वेरिन नना उपस लोहतेके बेस आयो. अहे लोहतेके, वेरु अग़दे कग़्विह्‌क ऊंगेङ-वेळ्केङ आयनुर. अदिह्‌के नाक वेरा मान वसिह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“अलाले, इचो वेल्‍ला मुडुह्‌क पंजिह कीयलाह, इद पेळ्ह्‌कल जागाते तिंड माक बेगा दोर्कग़ा?” इन्जि ओर कग़यवालोर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“मियगा बेचोक आरिङ मन्ह्‌ताङ कोनि?” इन्जि येसु ओरिन ताल्ह्‌कतोग़. “(बोरगा, मयगाया? अविय,) मयगा एळुङे आरिङ, इचुटाङ उड्लाङ मीन्क मन्ह्‌ताङ, अचोने,” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","पया मुडुन उद वेहचि, अव एळुङ आरिन, उड्लाङ मीन्किन पोसि, देवुळतुन जोहर कीसि, येसु अविनु किळ्हतोग़. किळ्हचि कग़यवालोरिह्‌क ईतोग़, ओर पया मुडुह्‌क वांटिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","पया लोकुर पंजनाह तितोर. तिन्जि बार कीसि, पिसतव किळ्केने एळुङ बेराङ डालाङ निंदताङ. ");
INSERT INTO mrr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","अगा तिनवालोरु कोय्तोरे कोनि नालुङ अजर्क (4000) मतोर, वेराङ आस्कु, पिलाङ-पेकोर ओसो मतोरे. ");
INSERT INTO mrr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","पया “मीट इंजेके लोन अन्ह्‌टु,” इनजोर मुडुन वेहच, बार कीसि, येसु ओडाते उदिसि, मगदान इनदनद एरियाते, कग़यवालोरा संगे वेंडिस वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","पया पेग़्के “देवुळ नीक लोहता इन्जि, माक उंदि सीना तोहा,” इनजोरे सदुकिर, परुसिर, वेर रेंड तुंगानोर उय्तुर, येसुना पट ऊळलाहि, ओनगा वासि ओन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","अस्के येसु वेरिन इतोग़, “मीटु पोग़ोन मोयुलतके ऊळिसि नेह्‌ना, लाग्वा दिया पुनदलाह उसर मह्‌निर. नुल्पे इह्‌निर, ‘कम्कल मोयुल मन्ह्‌ता अस्के, नाळताह पेग़ वावो, पङ्ने आयग़ा.’ ");
INSERT INTO mrr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ओसो नग़्कम कार्यल मोयुलताङ कोकिन ऊळिसि मीट इह्‌निर, ‘नेंड गंगा पोयता, दूंद-मुर्गम आयग़ा.’ मीटु पोग़ोटा मोयुलतुन गंता कीस पुह्‌निर, मति इद कालमते देवुळ बाताल कीस्ता, ताना अर्तम मीट पुनदा पग़विर! ");
INSERT INTO mrr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","लाग्वोरु, देवुळतुन केंजवोरु, नावाङ बेरा डीसाताङ कबस्किन ऊळतोरु, इद पीळतोरु सीना ताल्ह्‌किह्‌तोर. मति योनाल इनवाल देवुळता कबुरतोन्क बह बह आता, सिरप अदे सीना नना ओरिह्‌क तोहतकन, तान विळ्सिस दुस्रा सीना तोहोन,” इन्जि येसु ओरिन वेहतोग़. पया ओग़ तनाङ कग़यवालोर बार ओरिन विळ्सिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","सम्दुरतुन वेंडिसि अबर बाजे अतस्के, “अरे! माट आरिङ ततलाह माग़्ङतल, रा,” इन्जि कग़यवालोर सीता कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","अस्के येसु ओरिन वेहतोग़, “परुसिर, सदुकिर, वेरा ओयता पिंडटा लोप्पा उसरते मन्ह्‌टु, ताना अग़दुह्‌क आयमाट,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","“माट आरिङ तवाह्‌के बहे, (गूरु माक इह वळ्ह्‌किह्‌तोग़,)” इन्जि कग़यवालोर तमा-तमाय वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","तेन पुन्जि येसु इतोग़, “एय विस्वसलेवोरिर, आरिङ इलवाह्‌कु, मीट बाराह्‌क इचोन आलिह कीय्ह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","नाकु आरिना पर्वा इले इन्जि मीट इंका पुनविरा? मुने नना वेट एयुङ आरिने एयुङ अजर्क (5000) मन्कलोरिह्‌क तीहतन, अस्के तिनदलाह अचोन मयतप मता इतेके, वेल्‍लाङ डालाने पिसतविन गुम कीतिर, तेना सीता मन्ह्‌ताया? ");
INSERT INTO mrr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अद्रमे नना वेट एळुङ आरिने नालुङ अजर्क (4000) मन्कलोरिह्‌क तीहतन, अस्के बेचोक डालाङ आरिङ पिसिसि, तेना तेला सीता मीक इले? ");
INSERT INTO mrr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","नना आरिना लोप्पा वळ्ह्‌कोन आंदन, इदिन मीट बह पुनविर? मति नना ओसो वेहतह्‌नन, परुसिर, सदुकिर, वेरा पिंडटा लोप्पा उसरते मन्ह्‌टु,” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","अस्के गूरु आरिङ पंडनद ओयतद पिंडटा लोप्पा वळ्ह्‌कोग़ आंदोग़; मति परुसिर, सदुकिर, वेराङ गलत काग़्हमुळता लोप्पा नमनायो इन्जि गूरु वेहतह्‌तोग़, इद्रम ओर पुतोर. ");
INSERT INTO mrr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","येसु तनाङ कग़यवालोरा संगे केसरिया-पिलिपि इनदनद सहरता एरे वातस्के, “लोकुर माने-मन्कना नडुम पुटटोनु, बोग़ इनजोर मनदनुर कोनि?” इन्जि येसु ओरिन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","अस्के ओर इतोर, “गूरु, निमा मुनेतोग़ बोग़ो कबुरतोग़ जीवा अर्स मनदनोग़ इन्जि, लोकुरा विचर मन्ह्‌ता. अहे नीक वेल्‍लाटोरे इन्ह्‌तोर, ‘एते मीहवाल योहन मनदनोग़.’ ओसो उय्तुर इन्ह्‌तोर, ‘एलियाल कबुरतोग़ मनदनोग़.’ ओसो इन्ह्‌तोर, ‘यिर्मयाल कबुरतोग़ मनदनोग़,’ अद्रमे ओसो ‘बोग़ ओर्वोग़ देवुळता कबुरतोग़ मुनेतोग़ मनदनोग़,’ इद्रम इन्ह्‌तोर,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“इंगो, मति मीट पया नाक बोग़ इनजोर इह्‌निर?” इन्जि येसु ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","अस्के सिमोन पत्रु इतोग़, “सामि, निमा इतेके जीवात मनदनद देवुळता मग़निन, अहे अद लोहतोग़ पिसिह केवानिन किर्स्तुनिन,” इह इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","येसु सिमोनिन इतोग़, “सिमोन, योनाना मग़निन, निमा देय्वातोनिन, बाराह्‌क इतेके मन्कना बुदते इद पोल्‍लोतुन निमा पुनविन, मति नावा देवुळदीपतोग़ बाबाल, ओग़े नीक पुनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","नीवा पेदिर पत्रु (इतेके ‘बंडाये’) नना तासिह्‌नन. बेद्रम आदतगा दोहतद लोन डिङ इनाह मन्ह्‌ता, अद्रमलेह्‌काने नना इदे आदतगा नावा मुडुन निल्पिह कीकन, अस्के हामुर वने नावा मुडुन आरे कीया पग़वो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","अहे नना नीवा कयदे देवुळता राजेमताङ तालम कय्क ईतपु, नीक अदिकर ईकन. इतेके निमा ‘इद पोलिह्‌ता,’ ‘अद पोलो’ इन्जि वेहतेके, नीवा वेहतद पोल्‍लोतगा देवुळता अदिकर वने मनदग़ा.” ");
INSERT INTO mrr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","पया “बोग़ देवुळ लोहवाल पिसिह केवाल वावाल मतोग़, ओग़ ननाने, इदिन बार इंजेके बोने वेहमाट बहा,” इन्जि येसु तनाङ कग़यवालोरिन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","अस्केडाहि येसु तनाङ कग़यवालोरिह्‌कु वेहता बोटटोग़, “नाकु येरुसलेम सहरते दायाय पोयह्‌ता. अग्डोर पेदल्कु, पेर्मालोर, सास्त्रमगूरुर, नाकु वेल्‍लाय तिपल कीयनुर, हव्कनुर, ताना पया मूंड दियाने नना तेग़्ककन, इव करलि, अद्रम आयनुङे!” इन्ज वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","अस्के पत्रु येसुन बाजेते अबर ओसि इतोग़, “सामि, अद विचरे केमा निमा! अह मुर्तिय आयमाकि,” इन्जि येसुना वेहतद पोल्‍लोता अडम वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","अस्के येसु पत्रुनके मल्स ऊळिस इतोग़, “एय देयमदीपता बुदते वळ्ह्‌कवानिन, अद्रमता बुदतुन पोहचीम! निमा नाकु कटळ वाटटप एग़्कुळ आय्ह्‌निन. नीवा विचरि मन्कना विचरतेह मन्ह्‌ता, मति देवुळता विचरतके इले,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","पया कग़यवालोरिन येसु इतोग़, “बोर नावाङ कग़यलाह वायना विचर कीस्तोर, ओर तमा हव्कनागुटा कांजतप, नयेनाह्‌क वायनव तिपल्किन आपिर. ओसो तमाये गिर्दातुन पोहचि, नावा अग़दे ताकिर. ");
INSERT INTO mrr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","बोर इद बूमते तमा कुदता जीवातुन पिसिह कीयलाह ऊळिह्‌तोर, ओर आक्रिते बूळेम आयनुर. मति बोर नयेनाह्‌कु सबे पोहतह्‌तोर, ओरिह्‌क देवुळि पूना जीवा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","मन्कल पूरा दुनियातुन गेल्सतोग़ तेला मति, तना कुदता जीवातुन पिववद किसबटटगा लेसिह कीतोग़ इतेके, ओन्क बाताल पाय्दा आयग़ा? नीवा जीवा लेसता इतेके, ताना बद्लातुह्‌क बातय ईया पग़विन! ");
INSERT INTO mrr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","केंजाटु, माने-मन्कना नडुम पुटटोनन, नना नावा बाबाना डीसाते, नावाङ देवतुल्कना संगे वायकन. अद तूकने नना सबेटोराङ, बोना ओना कबळतुन ऊळिसि, नेयह्‌क कीकन; ");
INSERT INTO mrr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","इह केंजाट, नना सेतेम वेहतह्‌नन, माने-मन्कना नडुम पुटटोनन इद दुनियाते राजेम कीयलाह वायकन अस्के, मियग्डाहि उय्तुर नावा संगे मनवालोरिर, हायनामुनेन नाक ऊळकिर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","आरुङ दियाङ आतापया, याकुबि, योहनि, वेर तमोग़ इर्वुर ओसो पत्रु, वेर मुवुरिन पोसि, येसु तना संगे अलग उंद बेरा मेटापोग़ोन ओतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","अस्के वेर ऊळनेके, ओना रूप मिळ्न्दता. ओना मोकमि पोळ्‍दलेह्‌का मांजिंदु, ओसो ओनाङ गेंदेङ वेह्‌चता लेह्‌का तिर्मिळ्स्किंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अस्के ऊळाटु, एलिया मुय्तोग़, मोसा मुय्तोग़, वेर इर्वुर मुनेतोर देवुळता कबुरतोर, येसुना संगे वळ्ह्‌कनदिन वेर मुवुर कग़यवालोर ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","तेन ऊळिसि पत्रु पया इतोग़, “सामि, माट इगा मनदना, इद बेसु! नीवा विचर मतेके, नना इगा मूंड मंडाङ कीसीकन: उंदि नियेनाह्‌कु, उंदि मोसा मुय्तोनेनाह्‌कु, उंदि एलिया मुय्तोनेनाह्‌कु,” इनजोर येसुन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पत्रु इद्रम वळ्ह्‌कनेकेने, पांड्रि मोयुलि ओर सबेटोरिन मुळ्हता, मुळ्हतापया पोग़ोटा मोयुलताहि उंद आल्का वेनदा वाता: “वेग़ नावा जीवा कीतोग़ मग़ि, वेना लोप्पा नना पका गिर्दाते मह्‌नन; वेनाङे मीट केंजसोर मन्ह्‌टु,” इद्रम वेनदा वाता. ");
INSERT INTO mrr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","इद आल्कातुन केंजिसि, वेर मुवुर कग़यवालोर रेयिह्‌कु साङसोर, कप मुळ्न्दिस अरतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","अस्के पया, वेरा एरे वासि, येसु वेरिन बोयिसि, “रेयमाट रा, तेदाटु!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","पया तेदिस ऊळिह्‌तोर इतेके, येसुन विळ्सिस अगा बोग़े बह इलेग़ आसि, येसुये मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","मेटाताहि रेगनेके, वेर मुवुर कग़यवालोरिन येसु उकुम ईस वेहतोग़, “माने-मन्कना नडुम पुटटोनन नना डोलिस मन्जि ओसो तेग़्कनाह्‌जोम, मीट नेंड बेद ऊळतिर, तेनु बोन्के बह वेहमाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","“इंगो गूरु! मति देवुळ लोहवाल राजाल वायनामुनेने, (ओना अग़दुन ओप्पे कीयलाह,) एलिया मुय्तोग़ मल्स वायनोग़ इनजोरे सास्त्रमगूरुर इन्ह्‌तोर. अद्रम बाराह्‌क इन्ह्‌तोर?” इन्जि वेर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","अस्के येसु इतोग़, “एलियाल निटमे सबेटविन बेस ओप्पे कीयलाह वास्तोग़े. ");
INSERT INTO mrr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","मति नना मीक वेहतह्‌नन, एलियाल इतेके वातोग़े, तेला मति लोकुर ओन पुनोर. तम्क विचर वातपु, अहे ओर ओनु तिपल कीतोर. अद्रमे माने-मन्कना नडुम पुटटोनन, नना वने ओरा कयदाहि तिपल एतकन,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","वेग़ एलियाना पोल्‍लो वळ्ह्‌कनस्के, एग़ मीहवाल योहननाय लोप्पा माक वेहतह्‌तोग़, इनजोरे वेर मुवुर अस्के पुतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","पया वेरु मेटाकचुल मता मुडगा वातस्के, ओर्वोग़ मन्कल येसुनगा वासि, मिंडाङ कोटिस, जोहर कीसोर इतोग़, “गूरु, नावा मग़िन पिसिह कीमु! ओन्क कुळ्न्दिल रोगम मन्ह्‌ता, अदिह्‌क ओन्क पकाय तिपल आस्ता. ओग़ु ऊक-ऊके किसतगा, एतगा अरयह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","नना वेनु नीवाङ कग़यवालोरक्‍के तच मतन, मति ओरु वेन बेस कीया पग़वोर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","अस्के येसु इतोग़, “ए विस्वसलेवोरिर, गलत विचर केवालोरिर, मीवा संगे बेचानाह नना मनदकन? बेचानाह मीट देवुळता लावतुन पुनवाये मनदकिर? मियेनाह्‌क नाक वेल्‍लाय कयर वास्ता! अले अह इतेके, ओग़ पेकान नयके ताट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","अस्के वेन पेकानु देयमि पोयता इन्जि येसु पुतोग़, पुन्जि देयमतुन दगा ईतोग़, ईतस्के अद देयम ओनग्डाहि पटादुळ पेसिस वितता. पया अदे वेलाते पेकाल सव्रेम आतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","कतमतोर लोकुर पेसिस अतापया, येसुनाङ कग़यवालोर ओनगा वास ताल्ह्‌कतोर, “अदिन माट बह पूंड पग़वोम, गूरु?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","येसु ओरिन इतोग़, “देवुळतगा मीवा विस्वस कमि मन्ह्‌ता, अदिह्‌कु अद देयमतुन मीट पूंड पग़विर. नना मीक सेतेम वेहतह्‌नन, मीवा विस्वस नूङमेटा मतेके, इद मेटातुनु मीटु ‘इग्डाहि ओके जर्गा!’ इनजोर इतेके, अद जर्गग़ा. मीट बेदाय कीया पग़यकिर. ");
INSERT INTO mrr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","मति मीटु देवुळतुन पार्तना कीसोर, उपस कीसोर मतेकेने, इद्रमता देयमतुन पूंड पग़यकिर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ओर कग़यवालोर गालिल पटटे उंदि जागाते जमा आतोर अस्के, येसु ओरिन इतोग़, “माने-मन्कना नडुम पुटटोनन, नाकु कोंटेतोरा कयदे पोस ईयना मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ओरु नाक हव्कनुर, मति नना मूंड दियाने ओसो जीवा अरयकन,” इतोग़. तेन केंजताह्‌कु, ओर पकाय दुकम आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","पया येसु तनाङ कग़यवालोर बार कापेर्नाग़ एवतोर. ओर अगा मनेके, मंदिरता सारा एनवालोर पत्रुनके वास ताल्ह्‌कतोर, “मीवा गूरु येरुसलेमता मंदिरता सारा दोहोग़ा?” ");
INSERT INTO mrr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“इंगो, दोहतह्‌तोग़े!” अह इन्जि, पत्रु येसुन वेहतलाह लोनलोप्पा ओळियतोग़. पत्रु इदिनलोप्पा ताल्ह्‌कनामुनेने, येसु ओन इतोग़, “सिमोनि, तेना लोप्पा नीवा विचर बाताल मन्ह्‌ता, रा? इद बूमता राजालोर सिद्‌वा-सारा बोरग्डाह एतह्‌तोर? तनाय लोतोरग्डाहि, बारा दुस्रोरग्डाहि?” ");
INSERT INTO mrr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“आयो, दुस्रोरग्डाहि, गूरु,” इन्जि पत्रु इतस्के, येसु इतोग़, “अह इतेके, लोतोरिह्‌क सारा दल्गो. ");
INSERT INTO mrr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","अद्रमे माट देवुळता मन्कलोरल इनजोरे, माक वने ताना मंदिरता सारा दल्गो. तेला मति ओर कोंटे कीयना आयो इन्जि, माट ओरिह्‌क ईकले. निमा सम्दुरकचुल अन्जि मीन्क कूसा. बेद मीन मुने दोर्कग़ा, अद मीनता तोडटुनु पळ्ह्‌किस ऊळा, अगा नीकु नीवा-नावा सारातुह्‌क आलनाहि, उंदि कल्दर बंडि दोर्कग़ा. अदिन ओसि दोह्‌चीम,” इतोग़. (पया पत्रु अहे कीतोग़.) ");
INSERT INTO mrr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","अद तूकने येसुनाङ कग़यवालोर ओनगा वास ताल्ह्‌कतोर, “देवुळ राजेम कीयना लोकुरगा, मयग्डाहि सबेट्क बेरोग़ बोग़ मन्ह्‌तोग़, गूरु?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","अस्के ओग़ु ओर्विन उड्लोग़ पेकान केयिसि, ओरा नडुम निल्पिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","अह कीस इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मीटु बुदते मिळ्न्दिसि, उड्लोरा लेह्‌का जीवाते कुलुल आयवालेवा, मीकु देवुळ राजेम कीयना लोकुरगा जागा दोर्को आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","अदिह्‌के बोग़ु वेग़ उड्लोग़ पेकाना लेह्‌का बुदते उड्ला आस्तोग़, ओग़े देवुळ राजेम कीयना लोकुरगा सबेट्क बेरोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","इद्रम उड्लोग़ पेकाना लेह्‌काडोनु, ओग़ नाक नमवाल इन्जि, बोर एरे कीस्तोर, ओरु नाक वने एरे कीतप आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","उड्लोर पेकोरा लेह्‌का नाक नमवालोरग्डाहि बोनाय वग़ोनु, ओना नयगा मतद विस्वसतुन विळ्सलाहि, बोग़ कटळ वाटटप आस्तोग़, (वेग़ कटळ वाटवाल देवुळता बेरा सिक्सातुह्‌कु ओजनोग़). वेना वेळेटगा पका पूहतद जेता बंडातुन दोहचि, वेन सम्दुरते वेल्‍लाह आता कसातगा मुळ्हतना, (इद बेरा सिक्सा आंदु; मति) तान्काय वीळिस बेरा सिक्सा, देवुळि अद्रम कटळ वाटवाह्‌क ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","विस्वसतुन विळ्सलाह एग़्कुळ कीयनव पोल्‍लोनेनाह्‌कु, दुनियातोरिह्‌कु पका गोसा आयग़ा. इद्रमताङ पोल्‍लोङ कोनि आयनुङे, निटमे! मति बोर दुस्रोरिन नाक विळ्सनाह एग़्कुळ आस्तोर, ओरिह्‌क देवुळ पका सिक्सा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“केंजाटु, नीवा कय आयि, काल आयि, नीवा विस्वसतुन विळ्सनाह कीतप कीता बार इतेके, कयदुन-कादुन बोग़ाय डायिस पोहचीतेक बेस आवालि, (इद्रम निमा येसुनगा तासतद विस्वसतुन विळ्सोन इन्जि जिद कीमु). बाराह्‌क इतेके नीवा बोतिगा मेंदुलि पिववद किसबटटा सिक्सातगा दायना वाटो, कोलाल आसि, कूटाल आसि, अमेसाता पिसमुळते दायना, इदे नीक पाय्दाता. ");
INSERT INTO mrr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अहे नीवा कोंडा नीवा विस्वसतुन विळ्सनाह कीतप कीता बार इतेके, कोंडातुन बोग़ाय पेग़्हचीतेक बेस आवालि, (इद्रम निमा येसुनगा विस्वसतुन विळ्सोन इन्जि जिद कीमु). बाराह्‌क इतेके नीवाङ रेंड कोंडाङ मन्जि निमा पिववद किसबटटा सिक्सातगा दायना वाटो, उंदिय कोंडा मन्जि अमेसाता पिसमुळते दायना, इदे नीक पाय्दाता! ");
INSERT INTO mrr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“उसरते मन्ह्‌ट, नाक नमवालोर उड्लोरिनु बोने बार मीट पोहचीतप ऊळमाटु. बाराह्‌क इतेके वेरिन ऊळनव देवतुल्कु देवुळदीपते मन्ह्‌ताङ, अविस्किह्‌क अमेसा नावा बाबाना मुनेह अन्जि वेहतलाह अदिकर मन्ह्‌ता, इदिन मीट सीताते तासाटु. ");
INSERT INTO mrr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“लेसतोरिनु पिसिह कीयलाहे, माने-मन्कना नडुम पुटटोनन, नना वातन. ");
INSERT INTO mrr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","मीट बह इह्‌निर, रा? बोग़ो ओर्विनगा नूर गोरेङ मताङ. पया अग्डाहि उंद गोरे वेलियनेक-वेलियनेक लेसता. पया अव पिसतवु उंद कमि नूर (99) गोरेनु, मेटातगा विळ्सिसि, अद उंद लेसतद गोरेतुन पर्ह्‌कलाहि ओग़ दायनोग़ा, अनोग़ा? ");
INSERT INTO mrr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","इह केंजाट, नना सेतेम वेहतह्‌नन, ओकावेला अद लेसतद गोरे ओन्क दोर्कतेके, लेसववु उंद कमि नूर गोरेह्‌काय एक्‍वा, इद दोर्कतद गोरेतेनाह्‌कु, पका गिर्दा कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","अद्रमलेह्‌काने, वेर उड्लोर विस्वसिर, ओर्वोग़ तेला अमेसातुह्‌कु लेसनदायो, इद्रम देवुळदीपतोग़ मीवा बाबाना विचर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“नीवा ऐंगेटोग़ विस्वसि नीवा विरुद पापम कीतेके, ओनगा निमा अन. अन्जि मीट इर्विर नाटेनोरगा अनवाये, ओना तपतुन ओन्क तोहा. ओग़ नीवाङ केंजतोग़ इतेके, मीट इर्विर गूनम आतिर, कलियतिर इतप आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","मति ओकावेला ओग़ नीवाङ केंजवेके, निमा नीवा तोळ इर्वुर-मुवुर विस्वसिरिन पोसि, ओसो उंद मल्का ओनगा अन्ज ऊळा. बाराह्‌क इतेके कमसेकम इर्वुर-मुवुर मन्कलोरा साक्सिते, नीवा पोल्‍लो करल आयि.सास्त्रम वने इहे वेहतह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ओसो ओकावेला ओग़ कैंगम आसि ओराङ वन केंजवेके, विस्वसिरा मुडगा इद पोल्‍लोतुन वेहा. मुडा गोटटुन वन ओग़ केंजवेके, देवुळतुन पुनवोर पर्गेर, सिद्‌वा एनवालोर वेरिन ऊळतपु, ओन तपतोन वने वेग़ मावोग़ आयोग़ इन्जि, अहे ऊळा. ");
INSERT INTO mrr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“इह केंजाट, नना सेतेम वेहतह्‌नन, इद्रमतोरगा मीट नेयम कीनेके, मीटु इद पोलिह्‌ता, अद पोलो, इह वेहतेके, मीवा नेयमतगा देवुळता अदिकर वने मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","नना ओसो उंद पोल्‍लो मीक सेतेम वेहतह्‌नन. मियग्डोर कमसेकम बोराय इर्वुर विस्वसिर, बेदाय पोल्‍लोतेनाह्‌कु इद बूमतगा उंद पट आसि, देवुळतुन ताल्ह्‌कनुर अस्के, अद पोल्‍लोतुन नावा देवुळदीपतोग़ बाबाल कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","बाराह्‌क इतेके बेगा इर्वुर-मुवुर नावा पेदिरते जमा आस्तोर, अगा नना दिसवालेवा ओरा नडुम मह्‌नन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","पया पत्रु येसुनगा वास इतोग़, “सामि, नावा ऐंगेटोग़ विस्वसि तपिसि नाक नारज कीसोर मतेके, नाक बेचोक मल्काङ ओन मापि कीया पोयतग़ा? एळुङ मल्काङ मापि कीकना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","येसु ओन इतोग़, “आयो, सिरप एळुङे मल्काङ आयो, मति ओसो एळुङ मल्काङ, ओसो एळुङ मल्काङ, इद्रम लेकालेवा बेचोको मल्काङ मापि कीसोरेन मन. ");
INSERT INTO mrr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“नना नीकु बाराह्‌क इद्रम इह्‌नन इतेके, देवुळ राजेम कीयनस्के, (ताना बुद बेद्रम मनदग़ा, इदिन काग़्हतलाह नना मीक उंद पीटो वेहतह्‌नन.) वग़ोग़ राजाल मतोग़. ओग़ तनाङ सेवकिराहि करा ईतव कोताङ ताल्ह्‌कना इन्जि विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","अह कीस ओग़ु इसब एतलाह आतोग़, अस्के बेचोको कोटिङ कल्दर रुप्याना करा एतोनु, राजानके पोस ततोर. ");
INSERT INTO mrr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","मति वेग़ करा एनवानगा करा देहतलाह बातय लेवाह्‌कु, ‘वेनु, वेना मुतेनु, वेनाङ पिलाङ-पेकोरिनु, ओर्युल आयलाह वमिसि, ओसो वेना मतद-लेवद सम्सरमतुनु कतमे वमिसि, वेग़ नावा करा देहेग़,’ इन्जि राजाल उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“अस्के वेग़ सेवकि राजानाङ काल्क अर्सि, ‘ओसो उचुक दियाङ रोमिस मनु, महरज! नना पया नीवा कतमे करा देहतकन,’ इन्जि कालगडेम अरतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","इदिन ऊळिसि, वेग़ सेवकिना राजाह्‌कु मान वसता. वेनु विळ्सिसीसि, वेना कतम करातुन मापि कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“मति वेग़ सेवक पया बार कीतोग़? अग्डाह पेसिस वानेके, वेन्क तना ऐंगेटोग़ सेवक कलियतोग़. वेनाङ ओग़ सिरपि नूर दियाना कूलि, अचोके कोताङ वेन्क करा देहतना मता. अस्के वेग़ु ओना तोसातुन पोसि, दोबेङ-नूकेङ कीसोर इतोग़, ‘निमा नाक ईयना मन्ह्‌ता, नावा करातुन चट्पिट देहचीम,’ इन्जि पळ्मिङ ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ईतस्के वेना ऐंगेटोग़ सेवक वेनाङ काल्कनगा गप अर्स इतोग़, ‘निमा उचुक दियाङ रोमिस मनु, पया नना नीवा करातुन देहतकन,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","तेला मति वेग़ ओनाङ केंजवालेवा, ओन ओसि तना पूरा करातुन देहनाह्‌जोमु, जेलते ओळ्हचीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“इदिन ऊळिसि वेना ऐंगेटोर सेवकिर पकाय नारज आतोर, नारज आसि इव कतम गोटिङ राजानगा अन्जि वेहचीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","अस्के ओग़ राजाल, वेन सेवकिन तनगा केयिसि इतोग़, ‘ए जीवा लोपवोनिन, निमा ऊळा, नावाङ काल्क मोळ्कताह्‌कु, नाक ईयनद नीवा बेह्‌रा करातुन, नना विळ्सिसि मापि कीसीतन. ");
INSERT INTO mrr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","नना नीकु बेद्रम जीवा लोपिसि विळ्सिसीतन, अद्रम निमा वने नीवा तोळतोनु जीवा लोपिस विळ्सनद आयोया?’ ");
INSERT INTO mrr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","पया राजाल वेना पोग़ोन पका ओङ आसि, वेग़ कतम करा देहनाह्‌जोमु, वेनु सिक्सा केवालोर दरोगालोरा कयदे ईसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“अदिनेनाह्‌क मीट सबेटोरिर मीवा ऐंगेटोर विस्वसिरिन, मीवा जीवाताहि मापि केविर इतेके, नावा देवुळदीपतोग़ बाबाल मीक वने इहे सिक्सा कीयनोग़,” इन्जि येसु तनाङ कग़यवालोरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","येसु तनाङ इव वळ्ह्‌कनाङ गोटिङ मारिह कीसि, कग़यवालोर बार, गालिल पटटाह पेसिसि, यहुदा पटटे योर्दन बेरेटा अबरि, पोळ्‍द पेसना बाजे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","अस्के ओना पेग़्के गोह्‌डिनाङ गोह्‌डिङ वेल्‍लाय मुल वातोर. मुडा लोप्पा मतोर दुकह्‌लोरिन येसु सबेटोरिन सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","पया उय्तुर परुसिर येसुनके वासि, ओन एग़्किह कीयलाह इतोर, “मन्कल बेदे आयि उंद कट्लातुह्‌कु मुतेन देहचीयना, इद पोलिह्‌ताया?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","अस्के येसु इतोग़, “माने-मन्कन पुटिह कीयनद देवुळि सुरुमुनेताहि ओरिन आंचाळ-कोय्तोग़ इन्जि कीसीता. ");
INSERT INTO mrr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ओसो इदिनेनाह्‌कु मुतेन ततस्के, कोय्तोग़ तनाङ तलोग़-तपेना अदिकरते मनवा, वेर आळ इर्वुर जोळेम आसि, उंदिय आस मनदनुर, इह इनजोर मीट सास्त्रमते अर्विसि, ताना अर्तम पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अदिह्‌के इंजेक ओरु इर्वुर अलग-अलग आयोर, मति उंदिय आस मन्ह्‌तोर. देवुळिये ओरिन जोळे कीता, ओसो ओर अमेसा ऐंगेन मनदनुर इन्जि, ताना विचर मन्ह्‌ता इतेके, ओरा जोळतुन मन्कलोर देहमाकिर,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“अह इतेके मुतेन देहचीयनद वेलाते, कळ्पाकग़ देहतना सीटि रासिसि देहचीयनद अडोतुन, मोसा मुय्तोग़ बाराह्‌कु वेहतोग़?” इन्जि परुसिर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ओरिन येसु इतोग़, “आयो, सुरुमुनेताहि देवुळता विचर इद्रम इले, मति मीवा कैंगम ऊळिसि, मोसा मुय्तोग़ मीवाङ आस्किन देहचीयलाह इद्रमता अडो वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अदिह्‌क नना मीक वेहतह्‌नन, मुते दुस्रोन कववालेवा, बोग़ाय तना मुतेनु देहचीस्तोग़, ओसो दुस्रदिन ततह्‌तोग़, ओग़ सिंड्रि-साट्यालता पापम कीस्तोग़; (बाराह्‌क इतेके देवुळता विचरते, ओग़ु देहचीता आंचाना मुजो इंका मन्ह्‌तोग़े),” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","तेन केंजिसि, कग़यवालोर येसुन इतोर, “अलाले, मुजो-मुतेना अडो इह मतेके, कोय्तोग़ मुतेलेवा कुव्राय मनदनद बेस, अह इतेके!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","येसु पया ओरिन इतोग़, “बेसे वेहतिर, मति इद पोल्‍लोतुन सबेटोर कीया पग़वोर. बोरिह्‌कु देवुळि अद्रमता देय्वा ईता, ओरे कुव्रा मनदा पग़यह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","उच्वुर बार पुटटग्डाहि बाय्लालोर मन्ह्‌तोर, उय्तुर बारा मन्कलोरा कयदे बाय्लालोर आतोर, ओसो उय्तुर बारा देवुळता राजेमता सेवा बेस-नेह्‌ना कीकन इन्जि, हानाह्‌जोम कुव्राय मन्ह्‌तोर. “बोर इद पोल्‍लोतुन माळ पग़यह्‌तोर, ओरे माळिर,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","मावाङ पिलाङ-पेकोराङ तलानगा येसु कय तासिसि, ओरेनाह्‌क देवुळताह बर्कत ताल्ह्‌कनोग़ इन्जि, उय्तुर लोकुर तमाङ पिलाङ-पेकोरिन ओनगा ततोर. मति कग़यवालोर “इके वेरिन तमाटु!” इनजोर ओरिन दगाङ ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","मति येसु तनाङ कग़यवालोरिन इतोग़, “वेर उड्लोरिन रोमिह केमाटु, वेर नयगा वायिर. बाराह्‌क इतेके देवुळबाबाल वेरा लेह्‌काडोर कुलुल बुदतोरिह्‌के राजाल आस्तोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अह इन्जि, येसु पिलाङ-पेकोराङ तलानगा कय तासिसि, देवुळताह बर्कत ताल्ह्‌किसि, अग्डाह येसु तनाङ कग़यवालोर बारा पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","उंद दिया पया बोग़कोटे येसुनगा वास ताल्ह्‌कतोग़, “गूरु, नना देवुळता संगे अमेसातुह्‌क पिसलाहि, बेद नेह्‌नल कबळ कीकन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“नाकु नेह्‌ना कबळता लोप्पा बाराह्‌क ताल्ह्‌किह्‌निन? नेह्‌नोग़ इतेके ओर्वोग़े मन्ह्‌तोग़, देवुळबाबाले; ओग़े नेह्‌नाता लोप्पा पुन्ह्‌तोग़! ओना संगे निमा अमेसातुह्‌क पिसकन इतेके, मोसा मुय्तोना संगे ईतव अडोन माळसोर मन,” इन्जि येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“बेव अडोङ, गूरु?” “बेव ओसो? निमा बोने हव्कमा, साट्याल कबळ केमा, बोनाङ कलमा, जोल साक्सि एमा, ");
INSERT INTO mrr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","नीवा तलोग़-तपेह्‌क मान ईम,निमा कुदतुन जीवा कीतपु, दुस्रोरिन वने जीवा कीम.” इद्रम येसु ओन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“इव अडोन नना कतमे माळतन, गूरु. नना ओसो बाताल कीकन?” इन्जि वेग़ लेयोग़ येसुन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","“निमा पूराय तपवालेवा नेह्‌ना मनदकन इतेके अन, अन्जि नीवा मनदनद सबे मालसोमतुन वमिसि, लेवोरिह्‌क ईम. अद्रम कीसि, निमा नावा संगे मन्जि नावाङ कग़या. अद्रम कीतिन इतेके, पोग़ोन देवुळता जागातगा, नियेनाह्‌क निटमता मालसोम दोर्कग़ा,” इन्जि येसु ओन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","इव पोल्‍लोन केंजिसि, वेग़ लेयोग़ पकाय आल्सुळते अरतोग़, पया अग्डाह पेसिस अतोग़. बाराह्‌क इतेके वेना मालसोम वेल्‍लाय मताह्‌कु, (अदिन पोहतलाह वेन्क जीवा वावो). ");
INSERT INTO mrr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","अस्के येसु तनाङ कग़यवालोरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मता मन्कलोर देवुळता राजेमतोर आयना इतेके, पकाय मुस्किल आस्ता! ");
INSERT INTO mrr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ओसो उंद पोल्‍लो वेहतकन, केंजाट! ऊज-बूकातुह्‌क रूटुम पेसिस दाया पग़यह्‌ताया? अद्रमे, मता मन्कल देवुळता राजेमतोग़ आयना इतेके, तान्काय मुस्किलता पोल्‍लो!” ");
INSERT INTO mrr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","(पका मालसोम इतेके देवुळता देय्वाता सीना आंदु इन्जि ओरा विचर मता.) अदिनेनाह्‌क येसुना इद पोल्‍लो केंजिसि, ओर पकाय बयल आतोर, बयल आसि इतोर, “अह इतेके अमेसाता पिसमुळ पया बोन्क दोर्कग़ा गूरु?” ");
INSERT INTO mrr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","येसु ओरक्‍के कोंडा मिळ्हवा ऊळिस इतोग़, “इद पोल्‍लो मन्कना कयदे आया पग़वो, मति देवुळताये कयदे, सबे आया पग़यह्‌ताङ,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","इदिनलोप्पा पत्रु येसुन इतोग़, “ऊळा गूरु, माट इतेके कतमे विळ्सिसि, नीवा पेग़्के वातोम. तेना माकु बाताल पाय्दा दोर्कग़ा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","अस्के कग़यवालोरिन येसु इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, देवुळि सबेटविन पूना पंडिसीयग़ा. अद वेलाते माने-मन्कना नडुम पुटटोग़ु, तना राजकुर्सतगा पका डीसाते उदनोग़. अस्के मीट नावा पेग़्के वातोरिर बारा मन्कलोरिर, बारा राजकुर्सिनगा उदकिर. उदिसि, मीटु इस्रयेलतोर बारा कूळिनोरा नेयम कीकिर. ");
INSERT INTO mrr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ओसो बोर नयेनाह्‌क तमा लोन-दुवरतुन, दादाल-तमोनु, एलाळ-बायिनु, तलोग़-तपेनु, पिलाङ-पेकोरिन, जागा-बूमतुन, कतम विळ्सिह्‌तोर, ओरिह्‌कु देवुळि लेकालेवा सम्सरम ईयग़ा, अचोने आयो मति ओसो अमेसाता पिसमुळ वने ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","मति इंजेक बोर मुनेतोर मन्ह्‌तोर, वायनद कालमते आक्रितोर आयनुर; ओसो बोर इंजेके आक्रितोर मन्ह्‌तोर, ओरु अस्के मुनेतोर आयनुर, इद्रम वेल्‍लाटोरे आयनुर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","येसु ओसो इतोग़, “इदिनलोप्पा मीकु तेळियिह कीयलाह, नना उंद पीटो वेहतह्‌नन, केंजाट. देवुळता राजेम कीयनाङ अडोङ इहलेह्‌का आंदुङ. वग़ोग़ पोलम केवाल माल्काल मतोग़, ओग़ कोग़ कूसेङ तेदिसि, तना अंगुर वाळुमतगा कबळ कीयलाहि, बूततोरिन वेहतलाह पलत पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","पया ओरिह्‌कु दिनमता बूति, उंद दियाता कूल ईकन इन्जि करल आसि, अंगुर वाळुमते ओरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“पया ओग़ु जावा पोळ्‍द आतस्के, पलत अन्जि ऊळतोग़ अस्के, रिकम मनवालोर बेचोनो मांदि बजरते उगस निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘मीट वने नावा अंगुर वाळुमतगा कबळ कीयलाह अन्ह्‌ट रा! नना मीकु बेद बूत ओप्पिह्‌ता, अद ईकन,’ इन्जि माल्काल इतोग़. अह इताहे पया ओर वाळुमतगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“ओसोवने नेक नितस्के, अहे बह्‌ट अरनेके, ओग़ बजरते अन्जि, मुने कीतपे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","पया पोळ्‍द अरयलाह गंटामेंड पिसिस मतस्के, ओग़ बजरते ओसोवने पेसतोग़, अस्के वन बेचोनो मांदि रिकम उगस निच मतदिन ओग़ ऊळतोग़. ‘मीट इगा पोळ्‍दमेंड उगसे बह निच मह्‌निर, रा?’ इन्जि माल्काल ओरिन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘माक बोग़े बूततुह्‌क केयोग़, अदिह्‌के माट नितोम, दादा!’ इनजोर इतोर. पया ओग़ इतोग़, ‘अह इतेक, मीट वने नावा अंगुर वाळुमते अन्ह्‌ट.’ इतस्के ओर अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“पया पोळ्‍द अरतस्के, ‘सबेटोर बूततोरिन केयिसि, कतमतोरिह्‌क बूत ईम, आक्रि वातोरिह्‌क मुने ईमु, मुने वातोरिह्‌क आक्रिते ईमु,’ इनजोर माल्काल तना मेटिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","अस्के पोळ्‍द अरयलाह गंटामेंड पिसिस मतस्के वातोरु, अगा बूत एतलाह अतोर अस्के, ओरिह्‌कु पोळ्‍दमेटा बूति दोर्कता. ");
INSERT INTO mrr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","अदिन ऊळिसि, नग़्कमि वातोर बूततोरु, माक वेल्‍लाङ कोताङ दोर्कनुङ बहे इन्जि विचर कीतोर. मति ओरिह्‌क वने उंद दियाता कूल, अचोने दोर्कता. ");
INSERT INTO mrr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","इद बूति ओर एतस्के, माल्कान इतोर, ‘वेर पयाडोर उंदिय गंटा कबळ कीतोर, माट इसि पकाय कह्‌टेमते, एदते वाग़सोरे कबळ कीतोम. तेला मति निमा माकु ओराय बराबर बूत ईतिन, इद ओप्पो, दादा!’ इद्रम इन्जि मुयोग़-मुयोग़ आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","अस्के ओरग्डाहि वग़ोनु माल्काल इतोग़, ‘नना मीक नाळेह केवोन, तमो. नना नीकु उंद दियाता कूल ईकन इताह्‌कु, इंगो इनविना? ");
INSERT INTO mrr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","निमा मुयोग़ आयवा, नीवा बूत पोसि अन. नीक नना बेचोन बूत ईतन, अचोने बूति वेर आक्रिते वातोरिह्‌क वने ईयना, इद्रम नावा विचर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","नावा विचर मतपु, नावाङ कोताङ नाक काळ्ङनद अदिकर इलेया? नना गळ्क कबळ कीतोरिह्‌कु पोळ्‍दमेटा बूत ईताह्‌कु, निमा नाक कोंडा कीस बह वळ्ह्‌किह्‌निन?’ ");
INSERT INTO mrr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","इद्रमलेह्‌का इंजेक बोर मुनेतोर मन्ह्‌तोर, ओरु वायनद कालमते आक्रितोर आयनुर; ओसो बोर आक्रितोर मन्ह्‌तोर, ओरु अद तूकने मुनेतोर आयनुर, इद्रम वेल्‍लाटोरे आयनुर,” अह इन्जि येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","19","येसु पया येरुसलेम सहरता अग़ पोस अनेके, ओर बारा बळयिरिनु उंद बाजे ओर्के ओसि, ओरिन इतोग़, “केंजाटु, माट येरुसलेमते दाय्ह्‌नल, अगा अतापया नना माने-मन्कना नडुम पुटटोनन मन्ज तेला, नाक लोकुर पेर्मालोरा ओसो सास्त्रमगूरुरा कयदे पोसीयनुर. नाक पया वेर पेर्मालोर ओसो सास्त्रमगूरुर हव्कनद सिक्सा कीयलाह वेहचि, देवुळतुन पुनवोर रोम सर्करतोरा कयदे ओसीयनुर. ओर नाक उस्कनुर-पास्कनुर, जेट्लाते नल्हतनुर, ताना पया नाक हव्कनागुटातगा वेळ्हतनुर. तेला मति मूंड दियाने देवुळि नाकु हामुरताहि तेग़्किह कीयग़ा,” इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","तेना पया, जेबेदिना मुते तनाङ मग़्कु याकुबि, योहनि, वेरिन पोसि, येसुन बेदाय ताल्ह्‌ककन इन्जि, ओनगा वासि दंडुम अरता. ");
INSERT INTO mrr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“नीक बाताल गावले, अका?” इन्जि येसु तान ताल्ह्‌कतोग़. अद इता, “आयो गूरु, निमा नीवा राजगादेतगा उदकिन अस्के, नावाङ इर्वुर पेकोरिनु, ओर्विन नीवा तिनळ बाजे, ओसो ओर्विन नीवा दावळ बाजे उदिह कीसि, नीवा संगे राजेम कीयलाहि, ओरिह्‌क निमा अदिकर ईम.” ");
INSERT INTO mrr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","अस्के येसु वेर इर्वुर तानाङ मग़्किरिन इतोग़, “मीट बाताल ताल्ह्‌किह्‌निर, अद मीक तेळियिह्‌ताया? नना बेद तिपलते अरयकन, अद तिपलते मीट अरया पग़यकिरा?” इतोग़. “एय, माट वने अद तिपलते अरयलाह तयर मह्‌नोम, गूरु,” इन्जि वेर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“नना अरयनद तिपलते मीट अरयकिर, निटमे! मति राजेम कीनेके, नावा तिनळतके-दावळतके उदिह कीयलाह अदिकर नयगा इले. अद जागा बोरेनाह्‌क नावा बाबाल ओप्पे कीस तासतोग़, ओरे अगा उद पग़यनुर,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","वेर तमोग़ इर्वुर ताल्ह्‌कतदिन केंजिसि, पिसतोर दहा मुल कग़यवालोर, वेर इर्वुरा पोग़ोन ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","येसु पया तनाङ कग़यवालोर सबेटोरिन उंदिय जागा केयिसि इतोग़, “इद दुनियातोर राजालोर, तमा रय्ततुन कय इळ्न तासिह्‌तोर, अहे दुनियातोर बेरा मन्कलोर उड्ला मन्कलोरगा तमा अदिकरते ताकिह कीस्तोर, इद इतेक मीक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","मीट मात्रम इद्रम आयनद आयो. मियग्डाहि बोग़ देवुळता मुनेह बेरोग़ आयलाह ऊळिह्‌तोग़, ओग़ मीवा सेवा केवाल आयेग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अहे बोग़ मियग्डाहि देवुळता मुनेह सबेटोरिह्‌क बेरोग़ आयलाह ऊळिह्‌तोग़, ओग़ मीवा ओर्युलतोग़ आयेग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","माने-मन्कना नडुम पुटटोनन, नना वने दुस्रोरिन नावा सेवा कीया वेहतलाह, इद बूमते वावोन. मति दुस्रोरा सेवा कीयलाहि, ओसो वेल्‍लाटोरा पापमता दांड निहतलाह, नना नावा जीवा ईयलाह वातन.(अहलेह्‌का मीट वने दुस्रोरा सेवा कीम्ह्‌टु,)” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","पया येसु तनाङ कग़यवालोर बार, यरिग़ो नाटेनाहि पेसिस अनेके, ओना पयाह पयाह वेल्‍लाय मांदि अंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अनेक पया ऊळाट, अद अग़दगा इर्वुर गुडिर उदिस मतोर. मावा मुनेह येसु दास्तोग़ इन्जि, पता अरताह्‌कु, ओर केयिस-केयिस इनदलातोर, “ए सामि, दाविद राजाना कूळतोनिन पिसिह केवानिन, मावा पोग़ोन दया कीमु,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","गुडिरिनु केमेन मनिर इनजोरे लोकुर पळ्मिङ ईतोर. मति ओर गुडिर, “ए सामि, दाविद राजाना कूळतोनिन, मावा पोग़ोन दया कीम,” इनजोर ओसो जोरतेने केयिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","येसु अगा रोमिसि, ओरिन केयिस ताल्ह्‌कतोग़, “नना मियेनाह्‌क बाताङ कीकन?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“माट तोवयना इन्जि, मावाङ कोंडान बेस कीसीम, सामि,” इनजोर ओर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","येसुह्‌क ओरा मान वसताह्‌कु, ओग़ ओराङ कोंडान बोयतोग़. ओग़ बोयताहे, ओर तोप्नेन तोवतोर. पया ओर येसुना संगे वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","येसु तनाङ कग़यवालोर बार, येरुसलेम सहरता एरे एवयलाह आतोर. पया जय्तुन मराना मेटातगा, बेत्पागे नाटे वातोर अस्के, येसु इर्वुर कग़यवालोरिन नाटे लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“मुनेह दिसनद नाटेनगा अन्ह्‌ट, अगा एवयकिर अस्के, मीक उंदि दोहच तासतद गाळ्‍दि ओसो ताना पियो दिसनुङ. अविस्किन लेहच, नयगा पोस वाटु. ");
INSERT INTO mrr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","बोग़ाय मीक इविन बाराह्‌कु ओय्ह्‌निर इतेके, सामिह्‌क इविना गर्ज अरता, इद्रम इन्ह्‌ट. अस्के ओग़ चट्पिट अविन ततलाह ईयनोग़,” इन्जि येसु ओर इर्वुर कग़यवालोरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","इव गोटिङ आताङ अस्के, सास्त्रमते मुने देवुळता कबुरतोग़ वेहतद पोल्‍लो करल आता, अद पोल्‍लो इह मन्ह्‌ता: ");
INSERT INTO mrr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","येरुसलेम सहरतोरिह्‌क वेहाट, “ऊळाट, मीवा राजाल मियके वास्तोग़, कुलुल बुद आसि, गाळ्‍दतगा उदसोरे, इतेके गाळ्‍द-पियोतगा उदिस वास्तोग़!” ");
INSERT INTO mrr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","अस्के पया ओर इर्वुर कग़यवालोर नाटे अन्जि, येसु वेहतप, अहे कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","गाळ्‍दि ओसो गाळ्‍द-पियो तचि, अविस्कना पोग़ोन तमाङ कोटजगाङ ताग़तोर. अस्के येसु अगा उदतोग़, उदिसि येरुसलेमते वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","मुडग्डाहि वेल्‍लाटोरे लोकुर येसुह्‌कु मान ईयलाह, तमाङ कोटजगाङ तेंडिसि, अग़दे ओना मुनेह ताग़िन्दुर. ओसो उच्वुर बार मरानाङ कोमान डायिसि, अग़दे ताग़िन्दुर. ");
INSERT INTO mrr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","येसुना पेग़्के-मुनेह अनवालोर लोकुर रोदा कीसोरे, केयसोरे इनदलाह आतोर, “दाविद राजानापुळ्गतोग़ पिसिह केवाह्‌क जोहर! देवुळबाबाना अदिकर पोस वास्तोग़, ओन्कु देवुळता देय्वा आयि! पोग़ोटा देवुळतुह्‌क जोहर!” ");
INSERT INTO mrr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","येसु येरुसलेम सहरतगा वातोग़ अस्के, सहरमेटोर रोदा आसोर ताल्ह्‌किंदुर, “वेग़ बोग़ आंदोग़, रा?” ");
INSERT INTO mrr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“वेग़ गालिल पटटा नासरेत नाटे मनवाल, देवुळता कबुरतोग़ येसु आंदोग़,” इनजोर लोकुर वेहन्दुर. ");
INSERT INTO mrr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","येसु पया मंदिरलोप्पा ओळियतोग़, अह कीसि अगा वमवालोर-असवालोर कतमतोरिन पलत पूंडटोग़. ओसो कोताङ बद्ले केवालोराङ बलानु, ओसो मोकतुह्‌क अरयनव परेवाङ वमवालोराङ कुतुस्किन, कप मुळ्हतोग़.(सर्करताङ कोताङ मंदिरतगा वाटलाह ताकोङ आंदुङ, अदिह्‌कु अव कोताङ बद्ले कीसि यहुदिराङ कोताङ एवालोर अगा उदिस मंदुर.) ");
INSERT INTO mrr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अह कीसि येसु ओरिन इतोग़, “ ‘नावा लोतुन मोळ्कनद जागा इनदनुर,’ इन्जि देवुळ इन्ह्‌ता, इद्रम सास्त्रमते रासतद मन्ह्‌ता. मति मीट देवुळता लोतुन डाकुरा डेरा कीतिर!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","पया मंदिरतगा गुडिर-कूटालोर येसुनके वातोर अस्के, ओग़ ओरिन सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","अस्के मंदिरते मनवालोर पेर्मालोर ओसो सास्त्रमगूरुर, वेर येसु कीताङ बेराङ कबस्किन ऊळिसि. ओसो मंदिरतगा पिलाङ-पेकोर “दाविदना कुट्मळतोग़ पिसिह केवाह्‌क जोहर आयि!” इन्जि केयसोर इंदुर, इदिन वने वेर ऊळतोर. ऊळिसि, वेर ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“पिलाङ-पेकोर नीकु बार इन्ह्‌तोर, तेन निमा केंजतिना?” इन्जि वेर येसुन कट्ला कीतोर. पया येसु इतोग़, “इंगो रा, ओर सेतेमे इन्ह्‌तोर! मति मीटु बेस्काय सास्त्रमते इद्रम अर्विसि ऊळतिरा: निमा उड्लोर पेकोराङ, बाला पेकोराङ तोडिनाहि, नीक जोहर कीयनव पाटाङ पेसनाह कीतिन”? ");
INSERT INTO mrr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","इचोन वळ्ह्‌किसि, येसु ओरिन विळ्सतोग़. सहरताहि कग़यवालोरा संगे पेसिस पया, बेतनि नाटे अन्जि, अगान निद्र कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","नग़्कमि येसु ओसो तनाङ कग़यवालोर येरुसलेमतके अनेके, येसुह्‌क कग़्व वसता. ");
INSERT INTO mrr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","अग़दगा उंदि अंजिर मरा दिसताह्‌कु, अगा तिनदलाह अंजिर पंडिङ मनदनुङ बहे, इन्जि येसु मराता एरे अन्जि ऊळतोग़. मति ऊळतेके उंद वने पंड अगा इले, वेट आकिङे मताङ. अस्के ओग़ मरातुन इतोग़, “ए मरातिन, नियगा बेस्केन कायाङ आदमाकिङ!” इनजोर सरप ईतोग़. अह इताहे चट्‌नेन मरा वतिस अता. ");
INSERT INTO mrr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","तेन ऊळिस कग़यवालोर बयल आतोर, आसि इतोर, “गूरु, अंजिर मरा इचोन चट्‌नेन बह वाग़िस अता?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मीट बेदे उन्क-मन्क आयवा, देवुळता लावतगा विस्वस तासतेके, मीट इदिने आयो, मति तेन्काय बेराङ कबस्क कीया पग़यकिर. इद मेटातुनु निमा ‘डग वासि सम्दुरतगा अन्ज अर्म!’ इनजोर इतेके, अद अद्रमे आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","बेदिनाय मीट उन्क-मन्क आयवा, विस्वसते पार्तना कीस तान ताल्ह्‌कतेके, देवुळि मियेनाह्‌क अह कीयग़ाये,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","येसु पया ओसोवने येरुसलेम मंदिरतगा नेङतोग़. अगा ओग़ काग़्हनेके, पेर्मालोर ओसो दुस्रोर यहुदिराङ पेदल्क, वेर येसुन इनदलाह आतोर, “नियगा मंदिरताहि वीकुरतोरिन पूंडलाह अदिकर मन्ह्‌ताया? मतेके बेद्रमता अदिकर मन्ह्‌ता, ओसो इद अदिकर बोग़ नीक ईतोग़?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","अस्के येसु ओरिन इतोग़, “नना वने मीक उंद पोल्‍लो ताल्ह्‌किह्‌नन. मीट इदिन वेहतेके, नना वने बेद अदिकरते कीय्ह्‌नन, अदिन वेहतकन. ");
INSERT INTO mrr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","योहनिह्‌क लोकुरिन देवुळता पेदिरते एग़ मीहतलाह, बोग़ अदिकर ईतोग़? देवुळ ईताया, बारा मन्कलोर ईतोरा?” इन्जि ताल्ह्‌कतोग़. अस्के ओर तमतमाय इह वळ्ह्‌किंदुर, “माट देवुळ ईता इनदकल अस्के, वेग़ इनदनोग़, ‘अह इतेक मीट बाराह्‌क योहनिन नमविर?’ इनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","मति माट मन्कलोर ईतोर इनदकल इतेक, लोकुर माक अडम आयनुर; योहन देवुळता कबुरतोग़ आंदोग़ इनजोर वेर नमिह्‌तोर कोनि.” ");
INSERT INTO mrr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","अदिह्‌क पया ओर पेदल्क “माट पुनोम,” इनजोर इतोर. अस्के पया येसु इतोग़, “अह इतेके, नना वने इव कबस्किन बेद अदिकरते कीय्ह्‌नन, अदिन मीक वेहोन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","येसु ओसो इतोग़, “नना उंद पुन्पिह कीयनद पीटो वेहतह्‌नन, केंजाट. वग़ोग़ मन्कह्‌क इर्वुर पेकोर मतोर. तपे माळा मग़नगा अन्जि, ‘निमा नेंड अंगुर वाळुमतगा अन्जि कबळ कीम डा,’ इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘नाक दाया वसो, रा!’ इन्जि, वेग़ पेकाल इतोग़, मति पया बहो आलिह कीसि, वेना विचर मिळ्न्दताह्‌कु, वेग़ कबळतुह्‌क अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“पया तपे उड्लोग़ पेकानगा अन्जि अहे वेहतोग़. ओग़ उड्लोग़ पेकाल पया, ‘एय, दाय्ह्‌नन बाबा!’ इतोग़, मति अनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“इदिनलोप्पा मीवा बाताल विचर मन्ह्‌ता? इर्वुरग्डाहि बोग़ तपेना पोल्‍लो केंजतोग़?” इन्जि येसु ओरिन ताल्ह्‌कतोग़. “माळा मग़िय केंजतोग़,” इनजोर इतोर. येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मीकाय मुने सिद्‌वा एनवालोर ओसो बोगेस्कु, इद्रमतोर देवुळता राजेमते जागा पोयह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","योहन मीकु सेतेमता अग़ तोहतलाह वातोग़, मति मीट लोकुरिर ओन नमविर. सिद्‌वा एनवालोर ओसो बोगेस्कु मात्रम ओन नमतोर. ओर तमा पापमताहि मिळ्न्दतदिन ऊळिस तेला मीटु मिळ्न्दविर, योहनिन नमवाये मतिर. ");
INSERT INTO mrr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ओसो उंद पुन्पिह कीयनद पीटो वेहतह्‌नन, केंजाटु. ओर्वोग़ लोता माल्काल साव्कर मतोग़, ओग़ु अंगुर वाळुम ओग़्सतोग़. अंगुर सोपता वाळुम ओग़्सिस, ताना सर्ने वेटळ दोहतोग़. पया वाळुमता लोप्पा अंगुर जोमा पेग़लाहि, उंदि बोंदा तर्वतोग़, ओसो ताना एरे वाळुम केपलाह उंद मंडा पंडटोग़. पया ओग़ दुस्रोरिह्‌क कूलते तासिसि, जेक देसेमते पय्नम अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","पया अंगुर पंडिना पंटा वातस्के, ओग़ तना पंटाता तूस ओयनेनाह्‌कु, उय्तुर ओर्युलतोरिनु, ऊळेवाळे केवालोरक्‍के लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“पया ओर्युलतोर वाळुमतगा वातस्के, वेर ऊळेवाळे केवालोर ओरिन पोसि, बोन नल्हतोर, बोन हव्कतोर, बोन बंडाङ उकतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","इदिन केंजिसि पया, ओग़ माल्काल ओसोवन मर्ला, मुने लोहतोरिह्‌काय एक्‍वा ओर्युलतोरिनु ओसो लोहतोग़. वेरा संगे वने ओर ऊळेवाळे केवालोर अहे कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","आक्रिते नावा पेकान मान तासनुर इन्जि, ओग़ु तना मग़िनु ओरक्‍के लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","मति ऊळेवाळे केवालोर मग़ि वायनदिन ऊळिसि, तमतमाय वळ्ह्‌किंदुर, ‘इद तपेना सम्सरम इतेके वेन्के आयग़ा. दट, वेने माट हव्किङ, अस्के वेना तूस माक आयग़ा.’ ");
INSERT INTO mrr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","इद्रम इन्जि ओन पोसि, वाळुमता पलतेह ओसि हव्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“अह इतेके वाळुमता माल्काल मल्स वायनोग़ अस्के, ओग़ वेर ऊळेवाळे केवालोरिनु बह कीयनोग़ इह्‌निर मीटु?” इन्जि येसु ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","अस्के ओर पेदल्क येसुन इतोर, “अद्रमतोर लाग्वोरिन ओग़ देबाङ-गूटेङ कीसोर-कीसोरे हव्कनोग़, अह कीसि बराबर पंटातुह्‌क पंटाता ओना तूस एवालोरिह्‌कु, ओग़ अद वाळुमतुन कूलते ईयनोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","येसु इतोग़, “केंजाट, मीट सेतेमे इतिर, ताना अर्तम इह मन्ह्‌ता. देवुळि तना राजेमते मीक यहुदिरिह्‌क दोर्कनद तूसतुनु, मीवा जागाते ताना पोल्‍लोते तिरियवालोर (दुस्राङ जातिनोरिह्‌क) ईयग़ा. “नना मीक ओसो उंद पोल्‍लो वेहतह्‌नन. मीटु (देवुळ लोहवाल राजाना लोप्पा) सास्त्रमते इदिन अर्वविरा? बेद बंडातुन मुने बेल्दर्कु (लोन दोहवालोर) पोहचीतोर, अदे बंडा इंजेके मूलाता आदर बंडा आता. इद देवुळबाबानाये कबळ आंदु, इद माक पकाय बामतप दिसिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","अद बंडातगा बोग़ अरयनोग़, ओग़ ईंदेग़-पोदोग़ आयनोग़, मति अद बार बोनगा अरता इतेके, ओग़ गुंडा-गुंडा आयनोग़,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","येसुनाङ पुन्पिह कीयनाङ पीटोङ केंजिसि, ओर लाग्वोर कोरातोरा लोप्पा वळ्ह्‌कनस्के, मावाय लोप्पा वळ्ह्‌किह्‌तोग़ इन्जि, पेर्मालोर ओसो परुसिर पुतोर. ");
INSERT INTO mrr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अदिह्‌क येसुन ओर पोयतलाहि अग़िङ पर्ह्‌किंदुर. मति लोकुर ओनु देवुळता कबुरतोग़ आंदोग़ इन्जि नमताह्‌कु, वेर लोकुरिह्‌क रेयिसि, येसुन पोयतलाह ऊळोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","येसु ओसोवने लोकुरिह्‌कु पुन्पिह कीयनाङ पीटोङ वेहता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ओग़ इतोग़, “देवुळताङ राजेम कीयनव अडोङ इहलेह्‌का आंदुङ. वग़ोग़ राजाल मतोग़, तना मग़ना मर्मिह्‌कु उंद कुळ्प तासतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ओग़ु मर्म-कुळ्पतुह्‌क वायलाह, बोन-बोन मुने वेहच मतोग़, ओन-ओन केयिस ततलाह इन्जि, तनाङ ओर्युलतोरिन लोहतोग़. मति ओर केयता मुलु ‘माट वावोम!’ इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“वावोम इनजोर इताह्‌कु, पया ओसो उय्तुर ओर्युलतोरिन राजाल इह इन्ज लोहतोग़, ‘ऊळाट, मियेनाह्‌कु नना कुळ्प तयर कीतन. नावाङ असलताङ कुरा-पियोङ ओसो कोंदाङ हव्कतन, पुला बाताल वेस तयरे मन्ह्‌ता. जावा उनडलाह मीट मात्रम दटु इन्जि, केयता मुडुन वेहाटु,’ इनजोरे राजाल ओर्युलतोरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","6","मति वेर इचोन वेहचाय, राजाना पोल्‍लोतुन पर्वा केवालेवा, उय्तुर तमाङ पोलह्‌कनके अतोर, उय्तुर बारा दंदातुह्‌क अतोर, ओसो उय्तुर बारा राजाना ओर्युलतोरिन पोसि, ओरिन उस्किस-पास्किस, नल्हचि हव्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","इदिन ऊळिसि राजाह्‌क पका ओङ वाता, पया तनाङ सीपय्किन लोहचि, ओर हव्कतोरिनु कतम बूळे कीसि, ओरा नाटुन ओग़िसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“अस्के राजाल तनाङ ओर्युलतोरिन इतोग़, ‘मर्म-कुळ्प इतेक तयरे मन्ह्‌ता, मति केयता मुल कोनि इद कुळ्पतुह्‌क ओप्पोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","अदिह्‌क मीटु अग़िनगा, गोटुस्कनगा, बजर्कनगा अन्जि, बेच्वुर दोर्किह्‌तोर, अच्वुरिन मर्म-कुळ्प तिनदलाहि केयिस ताट.’ ");
INSERT INTO mrr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","पया ओर्युलतोर अहे कीतोर; अग़िनगा अन्जि, नेह्‌नोर-लाग्वोर बेच्वुर ओरिह्‌क दोर्कतोर, अच्वुरिन सबेटोरिन जमा कीसि ततोर. अस्के तिनवालोर मर्म-मंडामेंड तुत्‍ने आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“पया राजाल वेर वाता मुडुन ऊळ वातोग़, अस्के मर्मतेनाह्‌क बेसताङ गेंदेङ केग़वोग़, वग़ोग़ मन्कल ओन्क दिसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘इंगो रा तमो, मर्मिह्‌क बेसताङ गेंदेङ केग़वा, निमा मर्म-मंडातगा बह नेङतिन, डा?’ इन्जि राजाल वेन ताल्ह्‌कतोग़. अह इतस्के वेना मोकम एग़ रेगता. ");
INSERT INTO mrr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","राजाल पया तनाङ आजोङ आयवालोरिन केयिस इतोग़, ‘वेनाङ कय्किन-काल्किन दोहचि, वेन पलत मुर्गंगाते पोहचीम्ह्‌ट. अगा मनवालोर अळयना-केयना, मुडुर-मुडुर पल्क कोग़्कना, इह कीसोर मनदनुर,’ इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“इद पुन्पिह कीयनद पीटोता अर्तम इह मन्ह्‌ता. देवुळि तना राजेमता बर्कत ईयलाह केयतोरु वेल्‍लाटोरे मन्ह्‌तोर. मति (तानाङ पोल्‍लोङ केंजिसि तानक्‍के वावालोरु इतेके) देवुळि आचतोरु उय्तुरे मन्ह्‌तोर.” ");
INSERT INTO mrr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","पया परुसिर अग्डाह पेसिसि, कतमतोर उंद जागाते कलियिसि, येसुन बह कीस तेला, ओना वळ्ह्‌कनद पोल्‍लोते, ओन एग़्किह कीसि तप तोहतकल इन्जि, आय्डा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","अह कीसि, ओर तमाङ कग़यवालोर ओसो एरोद राजाना तुंगातोर उय्तुरिन येसुन ताल्ह्‌कलाह लोहतोर. “गूरु, निमा सेतेम मन्कनिन आसि, देवुळता अग़ सेतेमते तोहतह्‌निन इनजोर, माट पुह्‌नोम. निमा बोर बाताल इनदनुर इनजोर आल्सविन, लोकुरा मोकम ऊळिस वळ्ह्‌कविन, इद माक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","अह इतेक माक उंद पोल्‍लो वेहा. रोम सर्करतुह्‌क सिद्‌वा दोहतनद मावाङ अडोना अडम मन्ह्‌ताया, इलेया? नीवा विचर बह मन्ह्‌ता?” इन्जि येसुन वेर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","वेरा कोंटेतनमतुन पुन्जि, येसु वेरिन इतोग़, “ए सोङ केवालोरिर, नाक बाराह्‌क एग़्किह कीयलाह ऊळिह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","नाक सिद्‌वा दोहतनद उंद रुप्या-बंडि तोहाट.” अस्के वेर उंदि रुप्या-बंडि तोहतलाह ततोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","तचीतस्के येसु वेरिन ताल्ह्‌कतोग़, “इद बंडटगा बोना पोटो ओसो पेदिर रासतद मन्ह्‌ता?” ");
INSERT INTO mrr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ओर इतोर, “कय्सर राजानाये!” इदिन केंजिसि येसु इतोग़, “अह इतेके, बेद रोम राजेमता कय्सर राजाना मन्ह्‌ता, अद ओन्के दोहचीम्ह्‌टु. मति बेदिन देवुळ ताल्ह्‌किह्‌ता, अदिन देवुळतुह्‌क दोहचीम्ह्‌टु.” ");
INSERT INTO mrr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","येसु वळ्ह्‌कतद इद पोल्‍लोतुन केंजिसि, वेर बयल आतोर. अह कीसि येसुनग्डाह पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","(यहुदिरगा सदुकिर इनवालोर उंद तुंगातोर मतोर; मन्कलोर हासि मल्स जीवा अरवोर इन्जि वेर इंदुर). अदे दिया उय्तुर सदुकिर येसुन एग़्किह कीयलाह, ओनगा वासि ताल्ह्‌कतोर, “गूरु, मोसानाङ अडोङ वेहतपु, बोग़ाय मग़मियाळ लेवाय हातोग़ इतेके, ओना रांडे मुतेना संगे ओना तमोग़ जोळेम आसि, तमदादाना लोता लोन निल्पिह कीयना. ");
INSERT INTO mrr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ऊळा, मयगा तमोग़ एळवुर मतोर. मुनेतोग़ उंद मुते ततोग़, मति मग़मियाळ आयवाये हातोग़, पया ओना मुते ओना तमिह्‌क आता. ");
INSERT INTO mrr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","इद्रमलेह्‌का मनेक मनेक वेग़ वन तमोग़ मग़मियाळ आयवाये हातोग़, हातस्के ओसो ओर्वोग़ तमोग़ तान जोळेम आतोग़. ओग़ वने हातोग़, इद्रमलेह्‌का तमोग़ एळवुर आसि, ताना संगे जोळेम आसि हातोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","कतमतोर हातापया, अद आंचाळ वने हाता. ");
INSERT INTO mrr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","इंजेक माक वेहा, हातोर मल्स जीवा अरयनद वेलाते, ओर जीवा अरतस्के, तमोग़ एळवुरग्डाहि अद आंचाळि बोना मुते आयग़ा? अद इतेके कतमतोराय मुते आस मता कोनि!” इन्जि सदुकिर इतोर. (हामुरताहि जीवा अरयनदिन बय्तळ लोकुरे नमिह्‌तोर इन्जि तोहतलाह, वेर इह ताल्ह्‌कतोर.) ");
INSERT INTO mrr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","अस्के येसु ओरिन इतोग़, “हामुरताहि जीवा अरयना लोप्पा, देवुळता सास्त्रम बाताङ वेहतह्‌ता, अविन मीट पुनविर, ओसो हामुरताहि तेग़्किह कीयलाह देवुळता लावतुन वने पुनविर, अदिह्‌क मीटु गंगाते लेसतप मह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","हातोर मल्स जीवा अरयनुर अस्के, ओरु जोळजंतुर आयोर वने, ओसो जोळजंतुर कीस एवोर वने. ओर मात्रम देवुळदीपताङ देवतुल्कना लेह्‌का मर्मिङ आयवाय मनदनुर. ");
INSERT INTO mrr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","मति हातोर मल्स जीवा अरयनुर, ताना लोप्पा देवुळि सास्त्रमते वेहच मता, अदिन मीट अर्विसि, ताना अर्तम बेस्केन पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","(मावोर मुनेतोर पेदल्क अब्रहममुय्तोग़, इसकमुय्तोग़, याकुबमुय्तोग़, वेर हातापया वेल्‍लाङे दियाने) देवुळि इह वेहच मता, ‘अब्रहम, इसक, याकुब वेर मोळ्कनद देवुळतन ननान आंदन!’ देवुळतुन हातोर मोळ्कोर, मति जीवात मनवालोरे मोळ्किह्‌तोर, (इतेके देवुळि अह इनदनस्के, ओर मुवुर हातोराङ जीवाङ मंदुङे,) इद मीक तेळियोया?” इन्जि येसु सदुकिरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","येसु इचोन वळ्ह्‌कतस्के, अगा सर्ने मता लोकुर ओनाङ काग़्हतनाङ पोल्‍लोन केंजिसि बामतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","येसु सदुकिरिन मेसेह्‌ने कीस मतोग़ इन्जि, वेर परुसिरिह्‌क तेळियताह्‌कु, जमा आसि येसुनके अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","ओरग्डोग़ ओर्वोग़ सास्त्रमगूरु येसुना पट ऊळलाहि ओन ताल्ह्‌कतोग़, “मोसानाङ अडोना सास्त्रमतगा सबेट्क बेरा अडो बेद आंदु, गूरु?” ");
INSERT INTO mrr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","येसु इतोग़, “देवुळि नीवा सामि इनजोर, तान निमा पूरा बुदताहि, पूरा जीवाताहि, पूरा विचरताहि जीवा कीमु. ");
INSERT INTO mrr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","इदे अडो सबेट्क बेरा ओसो मोदुल अडो आंदु. ");
INSERT INTO mrr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ओसो तेनाय लेह्‌का दुस्रा अडो इदु: निमा कुदतुन जीवा कीतपु, दुस्रोरिन वने जीवा कीम. ");
INSERT INTO mrr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","इव रेंड अडोङ इतेके, मोसानाङ सबे अडोना ओसो देवुळता कबुरतोरा पूरा काग़्हमुळता मोदुल आस्ता,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","पया परुसिर येसुना सर्ने जमा आतस्के, येसु ओरिन ताल्ह्‌कतोग़, “देवुळ लोहवाल किर्स्तु इनवाल पिसिह केवाल, वेना लोप्पा मीवा विचर बह मन्ह्‌ता? वेग़ बोना पुळ्गतोग़, रा?” “दाविद राजाना पुळ्गतोग़,” इन्जि वेर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“अह इतेके दाविदिह्‌क देवुळता जीवा दळ्म अर्स वेहताह्‌कु, वेग़ पिसिह केवानु ‘सामि’ इनजोर ओग़ इह बह इतोग़? ");
INSERT INTO mrr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","दाविद सास्त्रमते इह रासिस तासतोग़, सीता मन्ह्‌ताया? देवुळि नावा सामिन इता, ‘बेचानाह नना नीवा कोटुलतोरिन, नीवाङ काल्कना इळ्न तच एवोन, अचानाह नावा तिनळ बाजेता राजगादेतगा उदिस मन,’ इता ");
INSERT INTO mrr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","दाविद कुदि ओनु ‘सामि’ इन्ह्‌तोग़ इतेके, ओग़ सिरप दाविदना पुळ्गतोग़ बह आया पग़यनोग़?” इन्जि येसु ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","अस्के ओनु यहुदिरा पेदल्कनाहि बोन्के, उंद पोल्‍लो वने मल्हतलाह वावो. अद दियाताहि येसुन इंका ओसोवने बाताङाय ताल्ह्‌किसि एग़्किह कीयलाहि, बोग़े बह दीरा केवोग़. ");
INSERT INTO mrr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","अस्के पया येसु तनाङ कग़यवालोरिन ओसो मुडुन इतोग़, “सास्त्रमगूरुर ओसो परुसिर, वेरिह्‌कु मोसानाङ अडोङ काग़्हतनद अदिकर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","अदिनेनाह्‌क ओरु मीक बाताङ बाताङ वेहतनुर, अव सबे पोल्‍लोनु मीट माळाटु, नोमाटु; मति ओर कीतप मीट बह केमाटु. बह इतेके ओर सिरप लोकुरिह्‌के वेहतह्‌तोर, मति तमा इतेके अह केवोर आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","वेर वेहतव अडोङ, मीक पका बेरा मोतालेह्‌का आस्ताङ. मति अद मोतातुन तमा इतेके, कयतेला बोयिस ऊळोर. ");
INSERT INTO mrr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“वेर तमाङ कतम कबस्किन लोकुर ऊळना इन्जि कीस्तोर. देवुळता पोल्‍लो रासिसि निहच तासतव ताय्तिङ बेराङ-बेराङ पंडिसि, वेरु तमाङ डंडाकय्कनगा ओसो कपरातगा दोहतह्‌तोर. ओसो तमाङ गेंदे-कोङिह्‌कु लाट-लाट लासाङ वेळ्हतह्‌तोर. लोकुर वेरिन पका कर्तुळ इनदना इन्जि वेर इह कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","वेरिह्‌क कुळ्पिनगा ओसो पार्तनाताङ लोह्‌कनगा, बेरोर उदवालोराङ जागाङ गावले. ");
INSERT INTO mrr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","लोकुर वेरिन गोटुस्कनगा जोहर कीयना ओसो ‘गूरु’ इनदना, इद्रमताङ वेरिह्‌क बेसु. ");
INSERT INTO mrr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“मति मीकु बोग़े ‘गूरु’ इनमाकेग़. बाराह्‌क इतेके नना ओर्वोनन मीवा गूरुनन, मीट मात्रम कतमतोरिर तमोग़-दादालोरिर मह्‌निर, मियगा उड्लोग़-बेरोग़ इलविर. ");
INSERT INTO mrr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","अद्रमे इद बूमते बोने मीटु ‘बाबा’ इन्जि मान एमाटु, बाराह्‌क इतेके देवुळदीपते मनवाल मीवा बाबाल, ओन्के इद्रमता मान ईयनद ओप्पिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ओसो मीकु बोग़े ‘माल्का’ इन्जि इनमाकेग़. बाराह्‌क इतेके देवुळ लोहतोग़ पिसिह केवानन, ननाने मीवा माल्कानन आंदन. ");
INSERT INTO mrr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","मति देवुळता मुनेह मियगा सबेट्क बेरोग़ बोग़ आयलाह ऊळिह्‌तोग़, ओग़ मीवा सेवा केवाल आयेग़. ");
INSERT INTO mrr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","बोग़ तन्क बेरोग़ कीयनोग़, देवुळि ओन उड्लोग़ कीयग़ा. अहे बोग़ कुलुल बुदते ताकिह्‌तोग़, ओन देवुळ बेरोग़ कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! देवुळि मीक पका सिक्सा ईयग़ा! बाराह्‌क इतेके देवुळता राजेमतके वावालोरा अग़ मीट केहतह्‌निर. मीट कुद वने ओळियविर, ओसो ओळियवालोरिन वने दाया एविर. ");
INSERT INTO mrr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेके मीटु रांडे आस्कना सम्सरम तिन्ज मुळ्हतह्‌निर. ओसो सोङ कीतपु, वेल्‍लाय जोम रोमवा पार्तना कीय्ह्‌निर. इदिनेनाह्‌क मीकु ओसो एक्‍वा सिक्सा आयग़ा! ");
INSERT INTO mrr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेक मीट दुस्राङ-दुस्राङ देसेह्‌कनगा, यहुदि दर्मते ओळियवाल वग़ोग़े कग़यवान दोर्किह कीयलाह, बूमतुन मारिह कीय्ह्‌निर! ओग़ दोर्कतस्के पया मीट ओनु मीकाय एक्‍वा, पिववद किसबटटा सिक्सातुह्‌कु ओप्पनाह कीय्ह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ए अग़ तोहतह्‌नोम इनवालोर गुडिरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेके ‘बोग़ाय मंदिरता गूडटा किरिया कीतेके, ओन अद किरिया पोयो. मति बोग़ गूडटा बंगरता किरिया कीस्तोग़, ओन मात्रमि अद किरिया पोयह्‌ता,’ इन्जि मीट काग़्हतह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ए बय्तळ गुडिरिर! गूडटगा मनाह्‌के अद बंगर पवित्र आस्ता, इतेके बेरा बेद, बंगरा, गूडिया? ");
INSERT INTO mrr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ओसो ‘बोग़ मंदिरतगा गर्याता किरिया कीस्तोग़, ओन अद किरिया पोयो. मति गर्याता पोग़ोन वाटटदिना बोग़ किरिया कीस्तोग़, ओन अद किरिया पोयह्‌ता,’ इन्जि मीट काग़्हतह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ए गुडिरिर! गर्यातगा मनाह्‌के, वाटटद मोक आयि, कोड आयि, पवित्र आस्ता, इतेके बेरा बेदु, गर्याया, बार कोडिया? ");
INSERT INTO mrr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","अदिह्‌क बोग़ गर्याता किरिया कीस्तोग़, ओग़ु गर्याता ओसो गर्यातगा वाटटदिना किरिया कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ओसो बोग़ु मंदिरता गूडटा किरिया कीस्तोग़, ओग़ु अगा मोळ्कनद देवुळता किरिया कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ओसो बोग़ु देवुळदीपता किरिया कीस्तोग़, ओग़ु देवुळता राजगादेता ओसो ताना पोग़ोन उदनदिना किरिया कीस्तोग़. (अदिनेनाह्‌कु बेगाय बेगा अद किरिया पोयतह्‌ताये!) ");
INSERT INTO mrr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेके मीटु जीरा, सोप, इद्रमता पंटाता वने, दहा तूस्कनग्डाहि उंद तूस देवुळतुह्‌क कोड ईय्ह्‌निर. मति सेतेमते नेयम कीयना, जीवा लोपना, देवुळतगा बर्वस तासना, अडोना सास्त्रमते रासतव इद्रमताङ मोदुल पोल्‍लोन मीट विळ्सतिर. मति अव उड्लाङ पोल्‍लोन वने माळनाय मता, ओसो इव मोदुल पोल्‍लोन वने माळनाय मता. ");
INSERT INTO mrr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ए अग़ तोहतह्‌नोम इनवालोर गुडिरिर! बोग़ बुसिन बार वाळा पोस पोहतह्‌तोग़, मति रूटुमतुन बार ऊळवा, गुस्क्ने लोपिह्‌तोग़, (अद्रमलेह्‌का मीट उड्लाङ-उड्लाङ पोल्‍लोन पका नोमिह्‌निर, मोदुल पोल्‍लोन बार मुर्तिय सीता केविर.) ");
INSERT INTO mrr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेके मीटु गिनेङ-बट्किन सिरप पलतेनाह तोमिह्‌निर, मति लोप्पाडेके इतेके, उळ्बेते लोकुरिन जाळ्पिसि दोर्किह कीतद मादे निंदिस मन्ह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ए बुदते गुडि मनवालोर परुसिरिर! मुने बट्कितुन लोप्पा तोमना, अस्के अद पलत वने वेडग़ा. (अद्रमे मुने मीवा पोटालोप्पाडाङ विचर्क नेह्‌नाङ आयिङ, अस्के पया मीवाङ कबस्क वने नेह्‌नाङ मनदनुङ.) ");
INSERT INTO mrr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक बेचोटा गोसा आयग़ा! बाराह्‌क इतेके मीटु पांड्रि चुना ओकताङ गुमयानलेह्‌का मह्‌निर. अव पलतेनाह इतेक पका सोबा दिसिह्‌ताङ, मति लोप्पाडेके ऊळतेके, सेत्तानाङ बोकाङ, कळियताङ-कळियताङ एग़्स्किसि किडुम पोस मन्ह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","अहे मीट वने पलताहि लोकुरिह्‌क पका सेतेमतोरा लेह्‌का दिसिह्‌निर. मति मीवा पोटालोप्पा नाळेह कीयनद बुद, पापम बुदि निंदिस मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ए सास्त्रमगूरुरिर ओसो परुसिरिर, मीट सोङ केवालोरिर! मीक पका सिक्सा आयग़ा! बाराह्‌क इतेके मीटु मुनेतोर देवुळता कबुरतोरिन ओसो सेतेमतोरिन मान ईयलाह, ओराङ गुमयान सिंग्रम कीय्ह्‌निर, बंडाङ ओग़्सिह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अह कीसि मीट इह्‌निर, ‘माट मावाङ तादोर-बाबोरा कालमते मन्ज मतेके, देवुळता कबुरतोरिन हव्कवालोरा तोळ आयोम आवेरोम.’ ");
INSERT INTO mrr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","इद्रम इन्जिये माट मुनेतोर कबुरतोरिन हव्कतोरा जालपिल आंदोम इनजोर, मीट कबुल आय्ह्‌निर.(ओसो नावाङ केंजवोरिर आसि, मीवा तादोर-बाबोरा लाग्वा बुदतुन मीट विळ्सविर इन्जि तोहतह्‌निर.) ");
INSERT INTO mrr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","33","ए वीसमतरसलेह्‌काडोरिर! माट नेह्‌नाङ कीय्ह्‌नोम इह्‌निर इतेके कीम्ह्‌टु! कीम्ह्‌ट, मीवाङ तादोर-बाबोरा लेह्‌का! ओरा सुरु कीतद पापमतुन मीट मारिह कीम्ह्‌ट! मति मीटु बगबग मळ्गनद किसबटटा सिक्साताहि बह पिह्‌ट अरयकिर? ");
INSERT INTO mrr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","केंजाट, नना मियके कबुरतोरिनु, सेहनालोरिनु, सास्त्रमगूरुरिनु लोहतकन. मीटु ओरिन उच्वुरिन हव्कनागुटातगा वेळ्हतकिर, हव्ककिर, ओसो उच्वुरिन मीवाङ पार्तनाताङ लोह्‌कने सोग़्‍पा-जूटटे नल्हतकिर, नल्हचि ओरिनु नाह्‌क-नाह्‌क कोहतकिर. ");
INSERT INTO mrr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","नना ओरिन बाराह्‌क लोहतकन इतेके, बोर मुनेतोर सेतेमतोर लोकुरिन हव्कतोरु, ओरिन हव्कतद पापमता सिक्सा, कतम मीवा पोग़ोन अरयना इन्जि. ओर सेतेमतोर लोकुर बोर इतेके, सुरुमुने सेतेमते मतोग़ हाबेल वेनग्डाह बर्काना मग़ि जकरिया बूमयानगा एवनाह (वेने कोनि मंदिरता गर्या ओसो गूडटा नडुम हव्किस मतोर). ");
INSERT INTO mrr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","इह केंजाट, नना सेतेम वेहतह्‌नन, इव हव्कनाङ कबस्कना पूरा सिक्सा मीट नावाङ केंजवोरिर, इद पीळतोरगा अरयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ए येरुसलेमतोरिर, ए येरुसलेमतोरिर देवुळता कबुरतोरिन हव्कवालोरिर, मियके देवुळ लोहतोर बळयिरिनु बंडाङ उकवालोरिर! बेद्रम तलोग़ कोग़ु तनाङ पीसेन काग़ोलिह्‌ता, अद्रमलेह्‌काने मीकु नयगा गुम कीयना इन्जि, बेचोको मल्काङ नावा विचर आंदु! मति मीट नाकु अह कीयलाह एविर. ");
INSERT INTO mrr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","केंजाट, मीवा मंदिर इम्ने आनाह, देवुळि मीक विळ्सिस दायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","नना मीक वेहतह्‌नन, नना मल्स वायनस्के ‘देवुळबाबाना अदिकर पोस वावाह्‌कु देवुळता देय्वा दोर्कि!’ इनजोर मीट इनदकिर, अचानाह नना मीवाङ कोंडाह्‌क मुर्तिय दिसोन आयकन,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","पया येसु मंदिरताहि पेसिसि पलत अनेके, मंदिरताङ बंग्‍लाङ तोहतलाहि कग़यवालोर ओनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","अस्के येसु ओरिन इतोग़, “मीट इव सबेटविन बेस ऊळाटु. इह केंजाट, नना सेतेम वेहतह्‌नन, इव इचोन बूळेम आयनुङ इतेके, इविस्कनगा बंडाता पोग़ोन बंडा वने मनो आयग़ा, बूळे केवालोरु कतम अर्हतनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","पया येसु जय्तुन मराना मेटातगा वग़ोग़े उदिस मनेके, कग़यवालोर ओनगा वासि ताल्ह्‌कतोर, “इव पोल्‍लोङ बेस्के बह आयनुङ, गूरु? नीवा वायनद वेला ओसो इद बूम मारनद वेला एवयनामुने, बेद्रमताङ सीनाङ आयनुङ?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","येसु ओरिन इतोग़, “मीक बोग़ाय नाळेह कीयनायो इन्जि, उसरते मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","बाराह्‌क इतेके वेल्‍लाटोरे नावा पेदिर पोस वासि, नना देवुळ लोहतोग़ राजानन आंदन इनजोर, वेल्‍लाटोरिन नाळेह कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ईनाह-आनाह नालुङ मूलाङ आसि, लळय्क आस्ताङ इन्जि, मीक एर्का आयग़ा. अस्के मीट रेयमाटु. इव पोल्‍लोङ निटम इह आयनुङे, मति इचोट्के बूम मारो. ");
INSERT INTO mrr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","जातता पोग़ोन जाति तेदग़ा, राजेमता पोग़ोन राजेमि तेदग़ा. बेगा इतेक अगा दुकळ अरयग़ा, जागाङ-बूमिङ मेलियनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","मति इव सबे पोल्‍लोङ, वायनाङ पीळाना सिरप मुर्ङुल आयग़ा, ओसो इंका पका बेरा गोसा वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“अद तूकने मीवाङ कोंटेतोर मीक जेलते वाटनुर, तिपल कीयनुर, हव्कनुर वने. मीट नाक नमवालोरिर आताह्‌कु, सबे जातिनोर मीक कोंटेङ कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","अस्के नाक नमवालोर वेल्‍लाटोर तमा विस्वसतुन विळ्सिसि, ओर्विह्‌क-ओर्वोग़ कोंटेतोरा कयदे पोसीयनुर, ओसो ओर्विह्‌क-ओर्वोग़ कोंटेङ कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ओसो वेल्‍लाटोर जोलहालोरु, जोल कबुर वेहचि, लोकुरिन लेसिह कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ओसो पापम पकाय वीळताह्‌कु, वेल्‍लाटोर लोकुर मुनेतलेह्‌का ओर्विह्‌क-ओर्वोग़ जीवा केवोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","मति आक्रि एवनाह बोर दीरा पोस मन्ह्‌तोर, देवुळि ओरिने पिसिह कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ओसो देवुळता राजेम कीयनदिना लोप्पा, बेसता कबुरतुन सबे जातिनोर केंजना इन्जि, इद कबुर बूममेंड आबुर आयग़ा. अस्के कोनि पया बूम मारनद वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“दानियेल इनवाल मुनेतोग़ देवुळता कबुरतोग़ वेहच मतपु, देवुळतुह्‌क मंदिरतुन कळ्‍वोग़ कीयनदु, एग़्ङ वायनदु, मंदिरता पवित्र गूडटे निच मनदनदिन मीट ऊळकिर. (मीट अर्ववालोरिर इदिन सीताते तासाटु.) ");
INSERT INTO mrr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","अस्के यहुदा पटटे मनवालोर लोकुर, (कोंटेतोरग्डाह पिह्‌ट अरयलाह,) मेटानके रोमवा वितिर. ");
INSERT INTO mrr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","बोग़ाय लोता पोग़ोन मतेके, ओग़ तना लोता सामन ओयलाह, लोनलोप्पा नेङमाकेग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ओसो बोग़ाय मन्कल पोलमते मतेके, ओग़ तना कोटजगातुन ओयलाह, लोन मलमाकेग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","अव दियाने नेलाङ हव्कतव आस्किह्‌क ओसो पाल ऊहतनव तलिस्किह्‌क, बेचोटा गोसा आयग़ा! ");
INSERT INTO mrr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","माट मुसुर पेग़दस्के ओसो वारमता पोल्वादियाते वितनायो इन्जि, मीट देवुळतुन पार्तना कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","बाराह्‌क इतेके, अद वेलाते पका बेरा गोसा आयग़ा. अचोटा गोसा बूम पुटिह कीतग्डाह, बेस्केन आयो वने, ओसो बेस्केन आयो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अव वायनव गोसाताङ दियान देवुळि कमि केवेके, बोग़े मन्कल पिस पग़वोग़ आयनोग़. मति तनाङ आचतोर लोकुरिन पिसिह कीयनेनाह्‌कु, देवुळि अव दियान कमि कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“अद वेलाते बोग़ाय मीक इनदनोग़, ‘ऊळाट, देवुळ लोहतोग़ राजाल इगाडोग़!’, ‘देवुळ लोहतोग़ राजाल अगाडोग़!’, अस्के ओनाङ सेतेम पोयमाट. ");
INSERT INTO mrr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","बाराह्‌क इतेके, नना देवुळ लोहतोग़ राजानन इनवालोर जोलहालोरु, ओसो देवुळता कबुरतोनन इनवालोर जोलहालोरु, इद्रमतोर पुटनुर. ओर बेराङ-बेराङ बामिह कीयनाङ सीनाङ तोहचि, देवुळ आचतोर लोकुरिन वने लेसिह कीयलाह ऊळनुर. मति ओर अह कीया पग़वोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ऊळाट, नना इतेके मीक मुनेन वेहतन, उसरते मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“अदिह्‌क मीकु बोराय इनदनुर बारा, ‘ऊळाट, देवुळ लोहतोग़ राजाल पेळ्ह्‌कल बूमते मन्ह्‌तोग़’ इतेक, अगा मीट ओन पर्ह्‌कलाह अनमाटु. ओसो मीकु ‘देवुळ लोहतोग़ राजाल लोप्पाडाङ अरानगा मन्ह्‌तोग़,’ इनजोर इनदनुर बारा, मीट अदिन वने सेतेम पोयमाटु. ");
INSERT INTO mrr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","बाराह्‌क इतेके, बेद्रमि किस-उळ्म मिळ्स्कसोरे, उंद बाजेताहि दुस्रा बाजेवनाह मिळ्स्किह्‌ता, अद्रमि माने-मन्कना नडुम पुटटोनन वायनस्के कतमतोर नाक ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","बेगा हातद सेत्ता मनदग़ा, अगा गीदस्क निटमे जमा आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“अव दियानाङ तिपल्क मारताहे, पोळ्‍द मांजो आयग़ा, नेला दींचो आयग़ा, उकाङ पोग़ोटाह इळ्न रालनुङ, इद्रम पोग़ोटा बूमतगा सबे मेलियनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","अस्के माने-मन्कना नडुम पुटटोनन, नना मोयुदगा सीना तोहतकन. पया दुनियाताङ सबे जातिनोर मन्कलोर, अर्युल पासोर हामुर-रेगाङ अळयनुर. नना बेरा डीसाते मोयुलपोग़ोन वायनदिन ओर ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","अस्के पया नना नावाङ देवतुल्किन, अकुमता बेह्‌रा आल्काते, दुनियाता मूलाह्‌क-मूलाह्‌क लोहतकन. पया अवु इद बूमतगा सर्ने मनवालोर नावाङ आचतोर लोकुरिन जमा कीयनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“गेळाताङ मरान ऊळिसि इद पोल्‍लो कग़याटु. आकिङ रालिह्‌ताङ अस्के डोय एरे एवता इनजोर मीट पुह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","इद्रमलेह्‌का मीट वने इव पोल्‍लोङ आयनदिन ऊळकिर अस्के, सामि गट्‌नेन एवतप लेह्‌कान इनजोर पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","इह केंजाट, नना सेतेम वेहतह्‌नन, मीट सबेटोरिर हायनामुनेन, इव नना वेहतव गोटिङ करल आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","पोग़ोटा बूमि, इळ्ता बूमि मायनुङ, मति नावा पोल्‍लो मात्रमि बेस्केन मायो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“मति देवुळ लोहतोग़ राजाल मल्स वायनद दियातुन, वेलातुन बोग़े पुनोग़. देवुळदीपताङ देवतुल्क वने पुनोङ, नना इंका पुनोन, सिरपि नावा बाबाले पुन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","मुनेतोग़ पेदामुय्तोग़ नोहानस्केडाङ दियाने बेद्रम आता, अद्रमलेह्‌का माने-मन्कना नडुम पुटटोनन वायनस्के वने आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","अस्के बेद्रम नोहा मुय्तोग़ तना लोतोर बार ओडातगा नेङनाह्‌जोम, लोकुर तिनजोर-उनजोर मतोर, मर्मिङ आंदुर, मर्मिङ कीसींदुर, ");
INSERT INTO mrr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ओसो ओरिनु बेरा उड्रा वासि सबेटोरिन पोळ्‍ह्‌च ओनाह्‌जोम, ओरिह्‌क मुर्तिय तेळियो आसि; अद्रमि माने-मन्कना नडुम पुटटोनन वायनस्के वने आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","अद तूकने, पोलमते इर्वुर मन्कलोर (ओर्वोग़ विस्वसि, ओर्वोग़ विस्वसलेवोग़) मनदनुर. नना वग़ोन (नयके पोस) ओयकन, दुस्रोन बारा (बूळेम आयलाह) अगान विळ्सकन. ");
INSERT INTO mrr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","अहे रेंड आस्कु (उंदि विस्वसि, उंदि विस्वसलेवदु) जेताते पिंड नोग़सोर मनेके, नना उंदतुन (नयके पोस) ओयकन, दुस्रदिन बारा (बूळेम आयलाह) अगान विळ्सकन. ");
INSERT INTO mrr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“अद्रमलेह्‌का सामि वायनद दिया बेदु, इद मीक तेळियो, अदिह्‌कु मीटु उसर आसोर मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","इद उंद पोल्‍लो केंजाटु. नग़्का बेदो उंद वेलाते, कले वायना मन्ह्‌ता इन्जि, लोता माल्काल पुन्ज मतेके, ओग़ु उंजवा उसरते मन्जि, तना लोतुन कलेनु विर्हता एवोग़ आवेग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","अद्रम मीट वने तयर मन्ह्‌टु, बाराह्‌क इतेके मीट नावा अग़ ऊळवा वेलाते नना, माने-मन्कना नडुम पुटटोनन वायकन. ");
INSERT INTO mrr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“केंजाट, बोग़ मेटि लोता माल्काना ओर्युलतोरिह्‌क कगोत्क-कगो अडिया ईस्तोग़, ओग़े बेसता बुदतोग़ सेतेमते कबळ केवाल मेटि. मीट वने अहे मनदना. ");
INSERT INTO mrr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","पया माल्काल वानेके, इद्रमे बेस कबळ कीसोर मनवाल मेटि, पका देय्वातोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","इह केंजाट, नना सेतेम वेहतह्‌नन, ओग़ माल्काल ओन मेटिनु, तना कतम सम्सरमतुन ऊळलाह तासनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“मति ओग़ मेटि लाग्वोग़ आस मतेके, ‘नावा माल्काल वायलाह आल्सेम आयनोग़ इन्जि, नना विचर वातप कीकन,’ इनजोर इनेग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","50","ओसो तना ऐंगेटोर सेवकिरिन नल्हतना-कोह्‌कना, ओसो कल लोटिरा संगे तिनदना-उनडना, इद्रम कीसोर मनेके, ओग़ु माल्काना अग़ ऊळवस्के, माल्काल वायनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","मेटि इद्रम कीयह्‌पा कलियतेके, तना माल्काल ओन पका सिक्सा कीयनोग़. पया अळयना, केयना, मुडुर-मुडुर पल्क कोग़्कना जागातगा, ओन मेटिन सोङ केवालोरा संगे वाटिसीयनोग़,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“नना बेस्के राजाल आस वायकन अस्के, इहलेह्‌का मनदनुङ. बोराङो मर्मिनगा दहा लेयास्कु, तमाङ पोतिह केवाङ कंदिस्क पोसि, मर्मपिलाता लोनु, मर्मपेकान केपलाह अताङ. (मर्मपेकाल वायनोग़ अस्के माट पलत पेसिसि, ओनु कंदिस्कना वेह्‌चते मर्मपिलाता संगे काल्ह्‌पिसीकोम इनजोर, अव अग़ ऊळिंदुङ.) ");
INSERT INTO mrr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","अविस्कनग्डाहि एयुङ बार बैरिस्क मताङ, पिसतव एयुङ बार तेल्वताङ मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","बैरिस्क इतेके, तमाङ कंदिस्कना संगे नेय पोयवाय वास मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","उसरताङ बारा, तमाङ कंदिस्कना संगे, तीसाने नेय पोस मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","पया मर्मपेकाल वायलाह आल्सेम आताह्‌कु, अव ऊळिस-ऊळिस कतमताङ कूर्ह्‌क बोटटाङ, कूर्ह्‌कसोर उंजताङ वने. ");
INSERT INTO mrr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“पया नडुमनग़्का इद्रम आळो वाता, ‘मर्मपेकाल वातोग़, अले रि! ओन कलियलाह दट.’ ");
INSERT INTO mrr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","अव दहा लेयास्क पया तेदिसि, तमाङ कंदिस्किनु ओर्कुल कीया बोटटाङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","अस्के अव बैरिस्कु उसरतविन इन्ह्‌ताङ, ‘अल रि, मीवा नेय उचुन माक ईम्ह्‌टु, मावाङ कंदिस्क पिवयलाह आताङ,’ इनजोर इताङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","मति उसरताङ इन्ह्‌ताङ, ‘अलो, इद नेय बोन्क इन्ज बोन्क आलग़ा, रि? ईतेके माक वन आलो, मीक वन आलो. अह आयो मति, मीट दूकनतगा अन्जि, मियेनाह्‌क नेय असिस ताट,’ इनजोर इताङ. ");
INSERT INTO mrr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","अव बैरिस्कु नेय असलाह अताङ अस्के बार आता, मर्मपेकाल एवतोग़. एवतस्के, उसरताङ एयुङ लेयास्कु, कंदिस्किन पोतिह कीस तयर आस मताह्‌कु, मर्मपेकाना संगे मर्म-कुळ्प मनदनद लोते अताङ. पया तेल्पतुन गोल्स वाटिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“गळ्क मनेके अव बैरिस्कु एयुङ लेयास्कु, मर्म-लोतगा वासि केयलाह आताङ, ‘दादा, दादा, माट वातोम, मयेनाह्‌क तेल्प तेग़या!’ ");
INSERT INTO mrr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","अस्के मर्मपेकाल अविस्किन लोप्पाडाहि पळ्मिङ ईतोग़, ‘मीट बेविस्कनिरो? नना सेतेम वेहतह्‌नन, मीक मुर्तिय पुनोन!’” इन्जि येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","पया येसु तनाङ कग़यवालोरिन इतोग़, “अदिह्‌क मीट वने उसरते मन्ह्‌टु, बाराह्‌क इतेके माने-मन्कना नडुम पुटटोना वायनद इहलेह्‌काने मन्ह्‌ता. ताना दियातुनु, वेलातुनु मीट मुर्तिय पुनविर. ");
INSERT INTO mrr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“नना बेस्के राजाल आस वायकन अस्के, इद्रमलेह्‌का ओसो आयनुङ. ओर्वोग़ माल्काल दुस्रा देसेम दायना मताह्‌कु, तनाङ सेवकिरिन केयिसि, तना मालसोमतुन ऊळलाह ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ओर्विह्‌क ओग़ु बंगरताङ कल्दर्कनाङ एयुङ मोटाङ ईतोग़, ओसो ओर्विह्‌क बार रेंड मोटाङ ईतोग़, ओसो ओर्विह्‌क बार उंदिय मोटा ईतोग़. इद्रम ओर्विना-ओर्विना बुद ऊळिसि, माल्काल ईतोग़. ईसि, तना पय्नमते पेसिस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“ओग़ अतस्के, बोन्क एयुङ मोटाङ दोर्किस मताङ, ओग़ु चट्‌ने अव मोटानाङ रुप्यानु दंदा कीया बोटटोग़, दंदा कीसि, कल्दर्कनाङ ओसो एयुङ मोटाङ एक्‍वा दोर्किह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","अद्रमे बोन्क रेंड मोटाङ दोर्किस मताङ, ओग़ वने दंदा कीसि, ओसो रेंड मोटाङ एक्‍वा दोर्किह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","मति बोन्क उंद मोटा दोर्किस मता, ओग़ अन्जि बूमतुन काचि, माल्काल ईतद मोटातुनु बोंदातगा मिसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“पया वेल्‍लाङे दियाना पेग़्के, ओर सेवकिरा माल्काल मल्स वातोग़. वासि, ‘नना मीक ईतव मालसोमता इसब ईम्ह्‌ट रा,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","अस्के बोन्क एयुङ मोटाङ दोर्किस मताङ, ओग़ु एक्‍वा दोर्किह कीतव एयुङ मोटान तचि, माल्काह्‌क इतोग़, ‘महरज, निमा नयगा कल्दर्कनाङ एयुङ मोटाङ ईस मतिन. ऊळा, अव कोताना दंदा कीस नना ओसो एक्‍वा एयुङ मोटाङ दोर्किह कीतन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओग़ सेवकनेनाह्‌क माल्काल गिर्दा आस इतोग़, ‘बेस-नेह्‌ना कीतिन, निमा बेस सेतेमतोग़ सेवकनिन. इचुटा पोल्‍लोतगा निमा सेतेम दिसतिन, अदिह्‌क नना नीकु वेल्‍ला मालसोमतगा अदिकर ईकन. वाय, माट कलियिसि गिर्दा आयकल,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“पया बोन्क रेंड मोटाङ दोर्किस मताङ, ओग़ वने माल्कानगा वास इतोग़, ‘महरज, निमा नयगा कल्दर्कनाङ रेंड मोटाङ ईस मतिन. ऊळा, अव कोताना दंदा कीस, नना ओसो एक्‍वा रेंड मोटाङ दोर्किह कीतन,’ इतोग़ ");
INSERT INTO mrr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओग़ सेवकिन वने माल्काल गिर्दा आस इतोग़, ‘सबस, बेस सेतेमतोनिन सेवकनिन. इचुटा पोल्‍लोतगा निमा सेतेम दिसतिन, अदिह्‌क नना नीकु वेल्‍ला मालसोमतगा अदिकर ईकन. वाय, माट कलियिसि गिर्दा आयकल,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“पया उंद मोटा दोर्कतोग़, ओना एरे वासि इतोग़, ‘महरज, निमा कळक मन्कनिन इन्जि नना पुतन. वीतवालेवा कोयवाल, तूळ्हवालेवा गुम केवाल, अद्रमतोनिन इनजोर पुतन. ");
INSERT INTO mrr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","अव कोताङ लेसतेके, निमा ओङ आयकिन इन्जि नना रेयतन, रेयिह्‌कु नीवा मोटातुन गट कीस तासिस मतन. ऊळा, इद मोटा नना नीवा नीके मल्स ईय्ह्‌नन,’ इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","अस्के ओना माल्काल ओन इतोग़, ‘एय लाग्वोग़, लंडा सेवकनिन, वीतवालेवा कोयवाल, तूळ्हवालेवा गुम केवाल, नाक अद्रमतोग़ इह्‌निना? कळक मन्कल इन्जि, निमा नाक इह्‌निना? ");
INSERT INTO mrr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","अह इतेके नावा माल कमसेकम साव्करनगा तासना मता. अह कीतेके नना वासि नावा मादुन सवयते तेंडिस मनेनन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","अह इन्जि, (माल्काल उय्तुर तनाङ सेवकिरिन केयिस वेहतोग़,) ‘मीटु वेनग्डाहि कल्दर्कना मोटा ऊंदिसि, दहा मोटाङ मनवाह्‌क ईम्ह्‌ट. ");
INSERT INTO mrr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","बाराह्‌क इतेके बोग़ सेतेमते मन्जि, तन्क ईतद मादुन असल काळ्ङिह्‌तोग़, ओन्कु नना ओसो इंका ईकन, ओन्कु वेल्‍लाय दोर्कग़ा. मति बोग़ सेतेमते मनवा, तन्क ईतद मादुन बेस काळ्ङोग़, ओनगा उचुक मतविन वने नना तेंडकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","वेग़ सेवकि बेदे कबळतुह्‌क ओजोग़! वेन पलत मुर्गंगाते पोहचीम्ह्‌ट. अगा मनवालोर अळयना-केयना, मुडुर-मुडुर पल्क कोग़्कना कीसोर मनदनुर,’ इन्जि माल्काल वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“माने-मन्कना नडुम पुटटोनन, नना राजाल आसि, सबे देवतुल्कना संगे नावा डीसाते वायकन अस्के, नना नावा राजगादेतगा डीसाते उदकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अस्के नावा मुनेह सबे जातिना मुल जमा आयनुर. अस्के बहलेह्‌का कोपाल एर्रेनग्डाहि गोरेन एग़्‍पिह कीस्तोग़, अहलेह्‌का नना ओर लोकुरिन ओर्विनग्डाह-ओर्विन एग़्‍पिह कीकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","अह कीसि, (बेद्रम कोपाल तना तिनळ बाजे गोरेन तासिह्‌तोग़, तना दावळ बाजे बार एर्रेन तासिह्‌तोग़, अद्रमे) नना सेतेमतोरिन बारा नावा तिनळ बाजे तासकन, लाग्वोरिन बारा नावा दावळ बाजे तासकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“अस्के नना नावा तिनळतोर सेतेमतोरिन इनदकन, ‘ओ नावा बाबाल देय्वा ईता लोकुरिर, बूम पुटटग्डाहि ओग़ मियेनाह्‌क इन्जि, बेद राजेमतुन ओप्पे कीस तासतोग़, अद राजेमता अदिकर मीट वासि एनाटु. ");
INSERT INTO mrr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","बाराह्‌क इतेके, नना कग़्वते मतन अस्के, मीट नाक तिनदलाह तिंडि ईतिर; ओसो नाक एग़ उनडा वसिस मतस्के, नाक उनडलाह एग़ ईतिर; ओसो नना पर्गेनलेह्‌का मतन अस्के, नाक मीवाङ लोह्‌कने जागा ईतिर; ");
INSERT INTO mrr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ओसो नना गेंदेङलेवा मतन अस्के, मीट नाकु केग़यलाह गेंदेङ ईतिर; ओसो नना दुकते मतन अस्के, मीट नाक तोळ आयलाह वातिर; ओसो नना जेलते मतन अस्के, मीट नाक कलियलाह वातिर,’ इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“अस्के तिनळ बाजे मनवालोर सेतेमतोर नाक इनदनुर, ‘सामि, माट नीकु कग़्वते अरतदिन ऊळिसि, बेस्के तिनदलाह ईतोम? नीक एग़ उनडा वसतदिन ऊळिसि, बेस्के एग़ उनडलाह ईतोम? ");
INSERT INTO mrr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","माट नीकु पर्गेनलेह्‌का आतदिन ऊळिसि, बेस्के केयिस लोन-जागा ईतोम? नीक गेंदेङलेवा ऊळिसि, बेस्के गेंदेङ केग़यलाह ईतोम? ");
INSERT INTO mrr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ओसो निमा दुकते अरतदिन, जेलते मतदिन ऊळिसि, बेस्के माट नियके कलियलाह वातोम?’ इन्जि ताल्ह्‌कनुर. ");
INSERT INTO mrr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","अस्के नना ओर सेतेमतोरिन इनदकन, ‘आयो रा, इह केंजाट, नना सेतेम वेहतह्‌नन, नावा लोकुर ओसोय पोहचीतप उड्लोर मतेकाय, ओरग्डाहि बोनाय वग़ोन इह बेस कीतिर इतेके, नाके कीतप आस्ता,’ इन्जि इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“पया दावळ बाजेतोर लाग्वोरिन नना इनदकन, ‘ए सरपते मनवालोरिर, नयग्डाहि पेसिस अन्ह्‌टु. देयह्‌किह्‌कु ओसो अविस्कना मुक्याह्‌कु तयर कीतदु, बेस्केन पिववद किसबटटगा अन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","बाराह्‌क इतेके नना कग़्वते मतन अस्के, मीट नाक तिनदलाह तिंडि एविर; ओसो नाक एग़ उनडा वसिस मतस्के, नाक उनडलाह एग़ एविर; ");
INSERT INTO mrr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ओसो नना पर्गेना लेह्‌का मतन अस्के, नाक मीवाङ लोह्‌कने जागा एविर; ओसो नना गेंदेङलेवा मतन अस्के, मीट नाकु केग़यलाह गेंदेङ एविर; ओसो नना दुकते, जेलते मतन अस्के, मीट नाक कलियलाह वाविर,’ इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“अस्के ओर वने नाक ताल्ह्‌कनुर, ‘सामि, नीक माटु बेस्के कग़्वते मतस्के, एग़ उनडा वसतस्के, पर्गेना लेह्‌का मतस्के, गेंदेङलेवा मतिन अस्के, दुकते ओसो जेलते मतस्के, बेस्के माट ऊळिसि, नीक साय्ता केवोम?’ ");
INSERT INTO mrr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","अस्के नना ओरिन इनदकन, ‘इह केंजाट, नना सेतेम वेहतह्‌नन, वेर नावा लोकुर ओसोय पोहचीतप उड्लोर मतेकाय, ओरग्डाहि बोनाय वग़ोन इह बेस केविर इतेके, नाक वने बेस केवप आस्ता,’ इन्जि इनदकन. ");
INSERT INTO mrr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“ओर इतेके अमेसाता सिक्सा आयलाह दायनुर, सेतेमतोरिह्‌क बारा अमेसा पिसलाह दोर्कग़ा,” इन्जि, येसु तनाङ कग़यवालोरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","इव कतम काग़्हतनाङ पोल्‍लोङ मारतस्के, येसु तनाङ कग़यवालोरिन इतोग़, “रेंड दियाना पया आवना पंडुम मन्ह्‌ता इनजोर मीट पुह्‌निरे. अस्के माने-मन्कना नडुम पुटटोनु, हव्कनागुटातगा वेळ्हच हव्कलाहि पोसीयनुर,” इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","अद तूकने कयपाल इनवाल मोदुल पेर्माना मिदेतगा, पेर्मालोर ओसो यहुदिराङ पेदल्क मीटिङ कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","मीटिङ कीसि, ओरु तमतमाय येसुन कुस्क्ने पोसि हव्ककल इनजोर, आय्डा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","मति पंडुमतुह्‌क वाता मुलु कियोग़-मुयोग़ बार आयनुर इन्जि, पंडुमतस्के ओन अह केवल आयकल इन्जि, विचर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","अदे दिया बेतनि नाटे, मुने मोंडरोगमते मतोग़ सिमोन इनवाना लोते, येसु तनाङ कग़यवालोर बार तिनदलाह उदिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ओर अगा उदिस मतस्के, बेदो उंद आंचाळि बंडा-तीसाते वेल्‍ला दाराता अतर्नेय पोसि, येसुनगा वाता. अह कीसि ओन मान ईयलाह, अद नेयदुनु ओना तलापोग़ोट्क दोसिसीता. ");
INSERT INTO mrr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","इदिन ऊळिस, उय्तुर कग़यवालोर ओङ आस इतोर, “इदिन बाराह्‌कु उगस पोहता? ");
INSERT INTO mrr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","इद अतर्नेयदुन वमतेके, वेल्‍लाङे कोताङ दोर्केस्कु, अव कोतानु गरिब-सरिबतोरिह्‌कु ईयनाह आवालि,” इनजोर कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","वेरा वळ्ह्‌कनदिन केंजिसि, येसु वेरिन इतोग़, “तान बाराह्‌कु कट्ला कीय्ह्‌निर, रा? अद नयेनाह्‌कु बेसतले कबळ कीता! ");
INSERT INTO mrr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरिब-सरिबतोर इतेके अमेसाय मियगान मनदनुर, (ओरिह्‌कु बेस्के तेला दर्मम ईया पग़यकिर). मति नना इसि मियगा अमेसा मनोन आयकन. ");
INSERT INTO mrr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","नावा हायनद कगो एवता इन्जि, नावा सेत्तातुन अतर्नेय ओकतपे, अद अह कीता. ");
INSERT INTO mrr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","इह केंजाट, नना सेतेम वेहतह्‌नन, कतम दुनियामेंडु, बेगा-बेगा लोकुर देवुळता राजेमता बेसता कबुर वेहतनुर, अव जागाने इद आंचाळ कीतद कबळतुन वेहतनस्के, तेन सीता कीयनुर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ताना पया बार आता? यहुदा इस्केर्योत इनवाल, वेग़ ओर बारा बळयिरग्डाहि ओर्वोग़ मन्ज तेला, पेर्मालोरगा अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अन्जि इतोग़, “नना येसुन मीवा कयदे पोसीतन इतेके, नाक मीटु बाताङ ईकिर?” अस्के ओरु ओन्क डेडा वीसा वेंडटाङ कल्दर बंडिङ लेकिस ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","पया अस्केडाहि यहुदाल येसुन पोस ईयलाहि अग़ ऊळसोर मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ओय्‍पिह केवद पिंडटाङ आरिङ तिनदनद पंडुमता मुनेता दिया, येसुनाङ कग़यवालोर ओनक्‍के वास ताल्ह्‌कतोर, “गूरु, इद आवना पंडुमता कुळ्प माट बेगा तयर कीकोम? बेगा नीक तिनदलाह विचर वायग़ा?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","अस्के “येरुसलेम सहरते अन्जि पलानोग़ ओर्वोग़ मन्कन कलियिस, ओन इह वेहाटु, ‘गूरु नीक ताल्ह्‌किह्‌तोग़, “नावा कगो एरे एवता. नावाङ कग़यवालोरा संगे आवना पंडुमतुन माळलाहि मियके वायकोम,”’ इन्ज वेहाटु,” इन्जि येसु उय्तुर कग़यवालोरिन वेहच लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","पया ओर लोहतोर कग़यवालोरु येसु वेहतपु अन्जि, अद जागा दोर्किह कीतोर, पया अगा आवना पंडुमता कुळ्प तयर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","पया मुलतस्के, येसु तनाङ बळयिर बारा मुडा संगे कुळ्प तिनदलाह उदतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","तिनदह्‌पा येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मियग्डाहि ओर्वोग़ नाक कोंटेतोरा कयदे पोसीयनोग़.” ");
INSERT INTO mrr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","इदिन केंजिसि ओर मेसेह्‌ने आतोर, अदिह्‌क ओर्विना पया ओर्वोग़ येसुन ताल्ह्‌क बोटटोर, “सामि, ओनन नना बह आयोना?” ");
INSERT INTO mrr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","येसु इतोग़, “नावा संगे बट्किता पुलातगा आरिङ अह्‌चिस तिनवालोरग्डाहि, ओर्वोग़ नाक पोसीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","सास्त्रमते रासिस मतपु, माने-मन्कना नडुम पुटटोनन, नना इद दुनियाताहि पेसिस दाकन, निटमे! मति बोग़ नाक पोसीस्तोग़, ओना बेचोटा गोसा आयग़ा! ओग़ मन्कल पुटवेकेन बेस आस मनालि,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","अस्के बोग़ ओन पोस एवाल मतोग़, ओग़ यहुदाल ओन ताल्ह्‌कतोग़, “गूरु, ओनन नना बह आयोना?” “निम इतिन, अहे!” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","अस्के पया ओर तिनदह्‌पा, येसु आरतुन पोसि, देवुळतुन जोहर कीसि, आरतुन किळ्हतोग़. अह कीसि ओरेके आहचोर इतोग़, “इद किळ्हतद आरतुन एनाटु, तिन्ह्‌टु, इद नावा मेंदुलता सीना आंदु. (ताने नना मियेनाह्‌कु मोकि ईय्ह्‌नन.)” ");
INSERT INTO mrr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ओसो ओग़ु बट्किता अंगुर जोमा पोसि वने, देवुळतुन जोहर कीतोग़, कीसि ओरेके आहचोर इतोग़, “मीट सबेटोरिर इग्डाह उन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","इद अंगुर जोमा नावा नेतुरता सीना आंदु. देवुळ लोकुरा संगे कीयनद करलतुन, इद नेतुर निल्पिह कीस्ता. नावा नेतुरि वेल्‍लाटोरा पापम मापि आयनेनाह्‌कु, नेल वाङग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","नना मीक निटम वेहतह्‌नन, नावा बाबाना राजेमते मीट बारा, ऐंगे पया पूना रीतते अंगुर जोमा उनाह्‌जोमु, नेटाहि नना तेन उनोन आयकन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ओर पया देवुळतुन जोहर कीयनद पाटा ओसि, जय्तुन मराना मेटातगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","अस्के येसु ओरिन इतोग़, “केंजाट, सास्त्रमते देवुळि इहे इन्जि रासतद मन्ह्‌ता: नना कोपानु हव्ककन, अस्के गोह्‌डटाङ गोरेङ बिरोबटो आयनुङ. नेंड नग़्का नाकु मीट सबेटोरिर विळ्सिस वितकिर, अस्के अद सास्त्रम करल आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","मति नना हासि जीवा अरतापया, मीकाय मुने गालिल पटटे अन्ज मनदकन, अगाने नना मीक कलियकन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","अस्के पत्रु येसुन इतोग़, “सबेटोर नीक विळ्सिस अतेकाय, नना इतेक नीक बेस्केन विळ्सिस वितोन आयकन, गूरु.” ");
INSERT INTO mrr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“इह केंजा, नना नीक सेतेम वेहतह्‌नन डा, नेंड नग़्का तलाकोग़ कूसनामुने, बोराय ताल्ह्‌कतस्के, निमा येसुन पुनोन इनजोर मूंड मल्काङ इनदकिन,” इन्जि येसु पत्रुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","“आयो, नाक नीवाय संगे हामुर वातेक तेला बेसे, मति नीक पुनोन इन्जि, नना मुर्तिय इनोन आयकन,” इन्जि पत्रु इतोग़. इतस्के कतमतोर कग़यवालोर वने वेनाङ केंजिस अहे इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","येसु तनाङ कग़यवालोरा संगे गेत्‍सेमनि इनदनद जागातगा एवतस्के, ओरिन इतोग़, “नना ओके पार्तना कीयलाह दाय्ह्‌नन, अचानाह मीटु इगान उदिस मन्ह्‌टु,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","अह इन्जि, ओग़ु पत्रुनु ओसो जेबेदिनाङ इर्वुर मग़्किरिन (इतेके याकुबिन, योहनिन) पोसि, पेंडेस ओतोग़. अस्के ओग़ पका दुकम आतोग़, ओसो ओना जीवा वने चुहेम आयो. ");
INSERT INTO mrr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","अस्के ओर मुवुरिन इतोग़, “नावा जीवातगा पका बेह्‌रा मोतालेह्‌का मन्ह्‌ता रा, अदिह्‌क नावा जीवा हायेङ-पिसेङ आसोर मन्ह्‌ता. मीट इगान मन्ह्‌टु, उंजवालेवा नावा संगे सीतात मन्ह्‌टु,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","पया ओग़ु उचुन मुनेह अन्जि, कप मुळ्न्दिसि दंडुम अरतोग़, अह कीस पार्तना कीतोग़, “ए बाबा, निमा इह कीकन तेला इन्ज इतेके, नाक इद गोसा आयमाकि. तेला मति इद नावा विचरते आयो, नीवाय विचर मतपु आयि.” ");
INSERT INTO mrr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","इह इन्जि देवुळतुन वेहचि, तनाङ मुवुर तोळतोरगा मल्स वास ऊळनेके, ओर कोनि उंजिस मतोर! ओर उंजतदिन ऊळिसि, येसु पत्रुन तेहच इतोग़, “ए पत्रु, मीटु गंटामेंडाय नावा संगे सीतात मनदा पग़विरा? ");
INSERT INTO mrr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","नना वेहतप कीयलाह मीवा जीवा तयरे मन्ह्‌ता, मति मीवाङ मेंदुस्क इतेके, दीरालेवप बागतप मन्ह्‌ताङ. अदिह्‌के मीट सीताते मन्ह्‌टु. देयह्‌कना मुक्याल मीवा पट ऊळनस्के, मीट पापमते अरयनायो इन्जि, देवुळतुन पार्तना कीसोर मन्ह्‌टु.” ");
INSERT INTO mrr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","पया ओग़ ओसो उंद मल्का अन्जि, देवुळतुन पार्तना कीतोग़, “ए बाबा, इद गोसा नाक एताय पोयतग़ा इतेके, नीवाय विचर मतपु पूरा आयि,” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ताल्ह्‌किसि ओसो ओर मुवुरक्‍के वास ऊळनेके, ओराङ कोंडाङ पकाय पूहतप आस मताह्‌कु, ओर उंजिसिय मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ओरिन अगान विळ्सिसि, ओसोवने येसु मुचा केपा आनाहि, कोळ्‍व कीयलाह अतोग़. अस्के वने मुनेता लेह्‌काने वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","पया ओग़ तनाङ मुवुर तोळतोरक्‍के मल्स वास इतोग़, “इंका उंजिसिय मह्‌निरा? इंका आरम कीसोरेन मह्‌निरा? ऊळाट, माने-मन्कना नडुम पुटटोनु, पाप्यहलोरा कयदे पोसीयनद कगो एवता. ");
INSERT INTO mrr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","तेदाट, माट ओरिन कलियलाह दाकल! नाक पोस एवाल इगा एरेन एवतोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","इव पोल्‍लोङ येसु वेहचोरेन मतोग़, अचोटेने यहुदाल अगा वातोग़. ओर बळयिर बारा मुडग्डाहि ओर्वोग़ मन्ज तेला, ओग़ु येसुन पोयवालोरा संगे वातोग़. पेर्मालोर ओसो यहुदिराङ पेदल्क लोहतोर वेल्‍लाटोर, यहुदाना संगे तल्वर्क, गूटेङ-बळ्गाङ पोस वातोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","येसुन पोस एवाल ओरिह्‌क इद सीना वेहच मतोग़, “नना बोन जोहर कीस लोंडकन, ओग़े आंदोग़, ओने पोय्म्ह्‌टु,” इन्जि वेहचि. ");
INSERT INTO mrr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","पया यहुदाल टीवा येसुनगा वास इतोग़, “जोहर गूरु!” इन्जि, ओन गोत ओग़्ङिस लोंडटोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","“मावोनिन, निमा बेद कबळतुह्‌क वातिन, तान कीमु,” इनजोर येसु ओन इतोग़. इतस्के येसुना मुनेह मुल सर्ने आसि, ओन पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","अचोटेने येसुना संगे मनवाल ओर्विनगा दाळो कसेग़ मता, ओग़ अदिन तेंडिसि मोदुल पेर्माना ओर्युलतोन वग़ोन नळ्कलाह तना कसेटुन रेहतोग़; अद कसेग़ि ओग़ ओर्युलतोना उंद केवदुन पोडोह देगनाह दल्गता. ");
INSERT INTO mrr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","अस्के येसु कसेग़ पोयवान इतोग़, “नीवा कसेटुन दाळोतगा तोग़्का, रा! कसेग़ पोयवाल कसेटेन हायनोग़, इदिन सीता कीमु. ");
INSERT INTO mrr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","नना नावा बाबान ताल्ह्‌कतेके, इंजेकेने ओग़ नाकु बेचोको अजर्क देवतुल्किन, नाक पिसिह कीयलाह लोहच मनेग़, बह इदिन निमा पुनविना? ");
INSERT INTO mrr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","मति इह आतेके, सास्त्रमतगा नावा लोप्पा रासतव पोल्‍लोङ बह करल आयनुङ? अवटे इतेके इद्रम आयनाय गावले इन्जि, रासतद मन्ह्‌ता,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","अद वेलाते येसु तन्क पोयवालोरिन इतोग़, “ओर्विन डाकुन पोयतप, मीटु तल्वर कसेह्‌कु, टेंगाङ पोस नाक पोयतलाह वातिर अय? नना इतेके दिनम मंदिरतगा उदिसि काग़्हन्दन, तेला मति मीट नाक अस्के बाराह्‌क पोयविर? ");
INSERT INTO mrr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","मति मुनेतोर देवुळता कबुरतोर सास्त्रमते नावा लोप्पा रासतव पोल्‍लोङ करल आयना इन्जि, नेंड इव गोटिङ आस्ताङ,” इन्जि येसु इतोग़. अचोटेने कग़यवालोर कतमतोर ओन विळ्सिस पटादुळ विततोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","पया येसुन पोयवालोर लोकुर ओन पोसि, मोदुल पेर्माल कयपानगा ओतोर. ओना लोतगा सास्त्रमगूरुर ओसो उय्तुर पेदल्कु, जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","मति पत्रु इतेके, मोदुल पेर्माना रेसातग एवनाहि, मुडा पयाह पयाह ओर्ङसोर अतोग़. पया बह बह आयग़ा इन्जि ऊळलाह, रेसालोप्पा अन्जि पह्‌रातोरा संगे उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","अगा मतोर पेर्मालोर, यहुदिराङ तग्वाङ केवालोर, कतमतोर उदिसि, येसुह्‌कु हामुरता सिक्सा ईयनेनाह्‌कु, ओना अडमि बेदाय उंद जोल साक्सि दोर्कना इन्जि, ओरु अद्रमतोरिनु जोल साक्सि एवालोरिन अगा पर्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","वेल्‍लाटोरे जोल साक्सितोर वास मतोर, मति ओरा साक्सि उंदिय रीतलेह्‌का इले आसि. आक्रिते इर्वुर वास इतोर, “देवुळता मंदिरतुन विर्हचि, तान मूंड दियाने ओसो दोहतकन इन्जि, वेग़ वेहतोग़,” इद्रमता साक्सि ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","अस्के मोदुल पेर्माल तेदिस येसुन इतोग़, “वेर नीवा अडम बेद्रम साक्सि ईस्तोर, ऊळा! निमा बातय बाराह्‌क वळ्ह्‌कविन?” ");
INSERT INTO mrr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","मति येसु बुस पोल्‍लो वन वळ्ह्‌कोग़. पया मोदुल पेर्माल ओन इतोग़, “जीवात मनदनद देवुळता किरिया पोय्‍पिह कीस नीक ताल्ह्‌किह्‌नन, निमा देवुळता मग़ि किर्स्तुनिन मतेके, माक वेहा!” ");
INSERT INTO mrr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“निमा इतिन, अहे! मति नना मीक सबेटोरिह्‌क वेहतह्‌नन, नना माने-मन्कना नडुम पुटटोनन मताह्‌कु, नेटाहि बेरा डीसातद देवुळता तिनळ बाजे नना अन्ज उदतदिन, ओसो नना मोयुलपोग़ोन मन्जि वायह्‌पा मीट ऊळकिर,” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","इदिन केंजिसि, मोदुल पेर्माल (पका दुकम आतदिन तोहतलाह,) तना कोटजगातुन अग़्हचि इतोग़, “वेग़ देवुळतन इतपु, देवुळतुन उस्किस-पास्किस वळ्ह्‌कतोग़, ऊळाट! इंजेक माक ओसो बातातुह्‌क साक्सि गावले? मीट इतेक कतमतोरिर वेनाङ केंजतिरे! ");
INSERT INTO mrr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","मीवा बाताल विचर मन्ह्‌ता, वेहाट!” इन्जि कयपाल इतोग़. वेग़ु हामुरता सिक्सातुह्‌क ओजनोग़ इन्जि, ओर पेदल्क नेयम कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","अस्के अगा उय्तुर लोकुर येसुना तोडटगा उस्कतोर, उय्तुर बारा ओन नल्हतोर, ओसो उय्तुर ओनाङ कोंडान दोहचि, ओन सापुस्क ईस इतोर, “निमा देवुळ लोहतोग़ राजानन, देवुळता कबुरतोनन इह्‌निन इतेके, नीक बोग़ नल्हतोग़, अदिन देवुळता जीवाते वेहा, रा!” इन्जि ओन पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","इके पत्रु लोता रेसातगा उदिस मतोग़ अस्के, उंद ओर्युल आंचाळ ओनगा वासि इता, “गालिल पटटोग़ येसुना संगे निमा वन मतिन, अय?” इता. ");
INSERT INTO mrr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","मति ओग़ु अगा मतोर सबेटोरा मुनेह इतोग़, “निमा बार इह्‌निन, नाक बातय तेळियो!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","पया ओग़ु रेसाता अग़दगा अतोग़ अस्के, ओसो उंद ओर्युलतदु ओन ऊळिसि, अगा मतोरिन वेहता, “ए वेग़ वन नासरेत नाटेनोग़ येसुना संगे मतोग़े!” ");
INSERT INTO mrr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","अस्के ओग़ु ओरिनु ओसोवने इतोग़, “किरिया रा, नना ओन मुर्तिय पुनोन!” ");
INSERT INTO mrr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","गळ्क मनेके, अगा निच मनवालोर उय्तुर लोकुर ओनगा वास इतोर, “निमा कोन निटमे ओनाय संगेतोनिन! निमा गालिल पटटोना लेह्‌का वळ्ह्‌किह्‌निन, अदिह्‌क ओना संगेतोनिन इनजोर माट पुह्‌नोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","अस्के पत्रु इतोग़, “नना किरिया कीस वेहतह्‌नन, नावा पोल्‍लो जोल आतेके देवुळ नाक तिनि! ओन मन्कन नना मुर्तिय पुनोन!” इनजोर इनेकेने तलाकोग़ कूसता. ");
INSERT INTO mrr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","अस्के येसु पत्रुनु मुनेन इह वेहच मतोग़, “नना नीक करल वेहतह्‌नन डा, नेंड नग़्का तलाकोग़ कूसनामुने, निमा नाक मूंड मल्काङ ओन पुनोन इन्जि कैंगम आयकिन,” इनजोर इतद पोल्‍लो पत्रुह्‌कु इंजेक सीता वाता. सीता वातस्के, ओग़ पलतेक पेसिसि, वेल्‍ला दुकमते पका अळतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","पिङपङ आयनामुने, कतमतोर पेर्मालोर ओसो यहुदिराङ पेदल्कु, वेर सबेटोर येसुन हव्कलाहि पट आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","अह कीस ओनु दोहचि, पिलाति इनवाल गुमसिनगा ओसीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","अस्के येसुह्‌कु हामुरता सिक्सा दोर्कता इन्जि, ओन पोस एवाल यहुदाह्‌कु एर्का आता. आताह्‌कु ओग़ पका आलिह कीतोग़: “चेह, नना ओन उगसे पोस ईतन डा,” इन्जि मुने एतव डेडा वीसा वेंडटाङ कल्दर बंडिङ, पेर्मालोरगा ओसो पेदल्कनगा मल्हच तचि, ओरिन इतोग़, “नना कसुरलेवोग़ मन्कन हामुरता सिक्सातुह्‌क पोस ईसि पापम कीतन,” इतोग़. अस्के ओर इतोर, “ताना माक बाताल, रा! निमा पोसीतिन, नीवा निमान ऊळा!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","अदिह्‌क पया यहुदाल कल्दर्किन मंदिरलोप्पा अग़्सिसीतोग़, अह कीस पलत अन्जि एग़्स हातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","पेर्मालोर पया अव कल्दर्किन पेह्‌किस इतोर, “इव कोताङ ओर्विन हामुरतुह्‌क ओसीयनव कोताङ आंदुङ, अदिह्‌क अवु देवुळतुह्‌क वाटटव कोडटाङ कोतानगा काल्ह्‌पलाह पोलो.” ");
INSERT INTO mrr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","इद्रम इनजोर पया, ओरु कतमतोर विचर कीसि, यहुदि आयवोराङ सेत्तान पोहतनद जागा इन्जि, इव पोहतव कोताङ ईसि, अळ्काङ पंडवाल कुमाना पोलमतुन असतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","अदिनेनाह्‌क अद पोलमतुनु नेतुरता पोलमि इनजोर, नेंड एवनाह इन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","अस्के यिर्मयाल इनवाल मुनेतोग़ देवुळता कबुरतोग़ सास्त्रमते रासतद पोल्‍लो करल आता, अद पोल्‍लो इह मन्ह्‌ता: ओना बेद दारा इस्रयेलतोरलोकुर तासतोर, अद दारा इतेके वेंडटाङ डेडा वीसा कल्दर बंडिङ अविन ओर एतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","एचि देवुळ नाकु उकुम ईतपु, ओरु कुमाना पोलमतुन असतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","पया येसु गुमसिना मुनेह नितोग़. नितस्के, गुमसि ओन ताल्ह्‌कतोग़, “निमा यहुदिरा राजानिना?” “निमा इह्‌निन, अहे!” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","पेर्मालोर ओसो पेदल्क वेरु येसुना पोग़ोन कसुर्क ओपनेके, ओग़ बोन्के उंद पोल्‍लो वन मल्होग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","अस्के पिलाति इनवाल गुमसि ओन इतोग़, “वेर लोकुर नीवा अडमि बेचोक गोटिङ वळ्ह्‌किह्‌तोर, इदिन निमा केंजविना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","मति येसु ओनु बुस पोल्‍लो वन वळ्ह्‌कोग़. अदिह्‌क गुमसि पका बयल आतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","वर्सामेटे आवना पंडुमतस्के, जेलतगा मनवाल बोनाय वग़ोन विळ्सना, इद्रम गुमसि लोकुरेनाह्‌क कींदोग़. इतेके यहुदि लोकुर बोन विळ्सा इनजोर वेहन्दुर, ओन वेग़ गुमसि वर्सामेटुह्‌क पंडुमता दियाते विळ्सिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","अद वेलाते पेदिर अतोग़ लाग्वोग़ ओर्वोग़ बरबसि इनवाल जेलते मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","अदिह्‌कु ओर जमा आतस्के पिलाति ओरिन इतोग़, “मियेनाह्‌कु नना बोन विळ्सकन इन्जि, मीवा विचर मन्ह्‌ता? बरबसिन विळ्सकना? आयवेके किर्स्तु इनवाल येसुन विळ्सकना?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(येसुना पयाह अनवालोर बोल्गसोर दास्तोर इन्जि, ओर पेदल्कना जीवा कर्वताह्‌के, ओर येसुन नयगा पोसीतोर इन्जि, गुमसि पुन्ज मतोग़. अदिह्‌क ओग़ु येसुन विळ्सलाह ऊळिंदोग़.) ");
INSERT INTO mrr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पिलाति पया नेयम कीयलाह उदतोग़ अस्के, ओना मुते ओन्कु इह कबुर लोहता, “ओग़ सेतेम मन्कना लोप्पा, नना नग़्का पका रेय वसनाह कला कळ्स्कतन, डा. अदिह्‌क निमा ओना अग़दुह्‌क अनमा,” इता. ");
INSERT INTO mrr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","वेर इके पेर्मालोर ओसो यहुदिराङ पेदल्कु “‘मयेनाह्‌कु बरबसिन बारा विळ्सिसीम, येसुन बारा हव्का,’ इह इनजोर माट गुमसिन इनदकल,” इन्जि लोकुरिन वेरु पका तग़्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","अस्के गुमसि लोकुरिन ताल्ह्‌कतोग़, “मियेनाह्‌कु ओर इर्वुरग्डाहि नना बोन विळ्सना इन्जि, मीवा विचर मन्ह्‌ता, वेहाट!” अस्के ओर “बरबसिन विळ्सा!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“अह इतेक येसुना बह आयग़ा पया? ओने कोनि लोकुर देवुळ लोहतोग़ राजाल इन्ह्‌तोर. नना ओन बाताल कीकन?” इतस्के सबेटोर इतोर, “ओन हव्कनागुटातगा वेळ्हा!” ");
INSERT INTO mrr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“बाराह्‌कु? ओग़ बाताल कसुर कीतोग़?” इद्रम गुमसि इतस्के, ओर इंका एक्‍वाये कुरेङ-वरेङ केयसोरे, “ओन हव्कनागुटातगा वेळ्हा!” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","इंजेक वेरगा नावा बातय ताको, मति रोदा कोन आस्तोर इन्जि, पिलाति इचुन एतुन कयदे पोसि, लोकुरा मुनेहु तनाङ कय्किन नोग़तोग़, नोग़्स इतोग़, “वेग़ मन्कन हव्कनद पापमि नाक दल्गमाकि, मति मीके दल्गि,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","अस्के सबेटोर लोकुर इतोर, “ओना हामुरता जबब्दर माट नितकोम, ओसो मावा जालपिल नितनुर,” इह इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","अस्के पया यहुदि लोकुरेनाह्‌कु, गुमसि बरबसिन विळ्सतोग़. येसुन मात्रमि ओग़ जूताते नल्हता वेहचि, हव्कनागुटातगा वेळ्हतलाहि, सीपय्कना कयदे ईसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","पया गुमसिनाङ सीपय्कु येसुनु तमा वाळातगा ओतोर. अगा ओतस्के, पूरा पल्टन येसुना सर्ने जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ओनाङ केग़ताङ गेंदेङ तेंडिसि, ओन राजान कीतपु नेत्रल जगा केग़्‍पिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","पया कोयेना गीळ पंडिसि, ओना तलातगा गळ्म कीतोर. ओसो ओना तिनळ कयदे डुड ईसि, ओना मुनेह मिंडाङ कोटिसि, “ओ यहुदिरा राजानिन, नीक जोहर आयि!” इन्जि पकाय पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ओना पोग़ोन ओर उस्कतोर, अह कीसि अदे डुडटे ओना तलातुन ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","पया ओन उस्किस-पास्किस मारतस्के, वेर केग़्‍पिह कीतद नेत्रल जगातुन तेंडटोर, तेंडिसि ओना जगा ओन्क ओसो केग़्‍पिह कीतोर. अह कीस ओनु हव्कनागुटातगा वेळ्हतलाह ओतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","पया ओरु सहरताह पलत पेसिह्‌पा, कुरेने सहरतोग़ ओर्वोग़, सिमोनि इनवाल ओरिह्‌क कलियतोग़. येसुह्‌कु गुटातुन कांजलाह दीरा वावाह्‌कु, वेर सीपय्कु येसुना हव्कनागुटातुनु कांजलाह, सिमोनिन पोसि बीगर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","पया ओरु गुल्गुता इनदनद जागातगा एवतोर (“गुल्गुता” इद पेदिर इतेके “तला-टाप्राता जागा” आंदु). ");
INSERT INTO mrr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","अस्के ओरु येसुना मेंदुदुह्‌कु नोयनद पुनदनायो इन्जि, येसुह्‌कु अंगुर जोमाते कयमुल जबाता जोमा काल्ह्‌पिसि, उनडलाह ईतोर. मति ओग़ु अदिन वडिस ऊळतस्के, उनोन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","पया येसुन हव्कनागुटातगा कय्किन-काल्किन मोल्‍लाङ कोटिस वेळ्हतस्के, ओनाङ गेंदेङ सीटिङ वाटिसि तूसतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","पया ओर ओन्क पह्‌रा कीसोर अगान उदतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“वेग़ येसु, यहुदिरा राजाल आंदोग़” इन्जि, इद्रम कसुर बलाते रासिसि, ओना तलापोग़ोटके वेळ्हचीतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","पया ओरु येसुना संगे इर्वुर डाकुरिन, वग़ोन ओना तिनळ बाजे, वग़ोन बार दावळ बाजे, इद्रम हव्कनागुटानगा वेळ्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","पया ओना एरेटुह्‌क अग़ पोस अनवालोर, तलाङ ओलिह कीसोरे माग़सोरे, ओन इहलेह्‌का उस्किस-पास्किस वळ्ह्‌किंदुर, “मंदिरतुन विर्हचि ओसो मूंड दियाने दोहवानिन निमानेया? अह इतेके निमा नीवाय जीवातुन पिसिह कीमे! निमा देवुळता मग़निन इतेके, इद हव्कनागुटातग्डाहि नेल रेगा!” इनजोर ओन पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","अहे पेर्मालोर, सास्त्रमगूरुर, यहुदिराङ पेदल्कु, वेर वन पास्कसोर इद्रम इतोर, “वेग़ दुस्रोरिन विळ्सिह कीतोग़, मति तन्क विळ्सिह कीया पग़वोग़. वेग़ इस्रयेलतोरा राजाल इतेके, हव्कनागुटातग्डाहि इळ्न रेगेग़. अस्के माट वेन नमकोम! ");
INSERT INTO mrr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ओग़ देवुळता पोग़ोन बर्वस तासवानन इन्ह्‌तोग़, ओसो नना देवुळता मग़नन, इद्रम इतोग़. इंजेके देवुळिये ओन पिसिह कीयना इतेके कीयि!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","बोर डाकुर ओना संगे हव्कनागुटानगा वेळ्हच मतोर, ओर वने अहे इनजोर ओन पास्किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","पया नेक नितग्डाह इतेके, पियलि मूंड एगनाह्‌जोम, देसेममेंड कतम ईकळ पोयता. ");
INSERT INTO mrr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","पियलि मूंड एगनेके, येसु बेरा आल्काते इह इनजोर केयतोग़, “एलि, एलि, लमा सबग़्‍तनि!” (तेना अर्तम इह मन्ह्‌ता: नावा देवुळतिन, नावा देवुळतिन, निमा नाक बाराह्‌क विळ्सिसीतिन?) ");
INSERT INTO mrr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","अगा निच मतोरग्डाहि उय्तुरिह्‌क, (येसु केयतद पोल्‍लो तेळियवाह्‌कु,) “ओग़ एलियाल इनवाल मुनेता कबुरतोनु केयलाह आतोग़!” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","येसुह्‌क एग़ उनडा वसता बहे इन्जि, चट्‌ने ओरग्डोग़ ओर्वोग़ वितिस अन्जि, बूबिलतुन ओयतद अंगुर जोमातगा मुळ्हचि, लाटटे कोडटगा तासिसि, ओन्क उनडलाह ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","मति उय्तुर इनदलातोर, “मनि रा! एलियाल ओन पिसिह कीयलाह वास्तोग़ा, वायोग़ा, इदिन माट ऊळकल,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","पया येसु ओसो उंद देबा जोरते केयिसि हातोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","इंजेके येरुसलेमता मंदिरतग्डा पवित्र गूडटा अग़दगा, गेंदे अडह कीस मता; (अद गेंदे अडम मताह्‌कु, लोकुर देवुळतुन गट्ने कलिय पग़वोर आंदुर.) पया येसु हातस्के ऊळाट, अद गेंदे पोग़ोटाहि इळ्न एवनाहि, पग़्क वितिसि रेंड तुक्ळेङ आताङ. ओसो जागा-बूमि मेलियता, आदिङ पेग़्क-पग़्क पवताङ, गुमयाङ पङ्ने आताङ. ");
INSERT INTO mrr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","(मूंड दियाना पया येसु जीवा अरतस्के, हातोर देवुळता लोकुर वेल्‍लाटोरे जीवा अरतोर. जीवा अर्सि ओर पङ्ने आताङ गुमयानग्डाह पेसतोर. पेसिसि, ओरु यहुदिरा पवित्र सहर येरुसलेमते अन्जि वेल्‍लाटोरिह्‌के दिसतोर.) ");
INSERT INTO mrr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","अस्के कोन पया सीपय्कना साय्बाल ओसो ओना संगे मतोर येसुन पह्‌रा मनवालोर सीपय्कु इद बूम गल्जनदिन ओसो अगा बह आता, तान ऊळिसि पकाय रेयतोर. “वेग़ निटमे देवुळता मग़ आंदोग़!” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","गालिलताहि येसुना सेवा कीसोरे पेंडेस वातवु वेल्‍लाङे आस्कु, जेकताहि इद सबे आयनदिन ऊळसोर मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","अव अचोक आस्कनग्डाहि, मग्डला नाटेनद मरियालि, जेबेदिना मुते, ओसो मरियालि इनदनदु याकुब, योसेप, वेरा तलोग़ि, इव इचोक आस्क अगा मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","पया मुलयनामुने, अरिमतेया नाटेनोग़ ओर्वोग़ मता मन्कल, योसेपि इनवाल, अगा वातोग़. वेग़ वने येसुनाङ कग़यवाल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ओग़ पिलाति गुमसिनगा अन्जि, “येसुना सेत्तातुन पोहतलाह ओयकोम,” इनजोर ताल्ह्‌कतोग़. अस्के पिलाति “ओरिह्‌क सेत्तातुन ईम्ह्‌ट,” इनजोर सीपय्किन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ओर पया सेत्तातुन ओसि, पूना, वेल्‍ला दाराता हामुर-गेंदेते ऊर्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","इंजेके योसेपि तनेनाह्‌क उंद बेरा आदतगा, पूना गुमया तर्व वेहचि तासिस मतोग़; अदे गुमयातगा येसुना सेत्तातुन ओर तासतोर. अह कीसि, बेरा आद बंडातुन गूळ्हचोर तचि, गुमयाता अग़दगा तिळ्ह्‌पने तासतोर, अह कीस पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","अगा गुमयामुनेह, मग्डला नाटेनद मरियालि ओसो उंद दुस्रा मरियालि, इव उदिस ऊळसोर मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","इमा दिया (इतेके वारमता पोल्वादियाते), पेर्मालोर ओसो परुसिर पिलातिनके वासि जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","जमा आसि इतोर, “महरज, ओग़ नाळेह केवाल जीवात मनदह्‌पा, ‘नना हासि मूंड दियाने ओसो जीवा अरयकन,’ इनजोर इन्ज मतोग़, इद पोल्‍लो माक सीता मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","अदिनेनाह्‌क मूंड दियाङ आनाह्‌जोमु, गुमयातगा पह्‌रा कीया वेहा. अह केवेके, ओनाङ कग़यवालोर वासि, सेत्तातुन कलिस ओयनुर बारा, अह कीस, वेग़ हासि ओसो जीवा अरतोग़ इनजोर, लोकुरिह्‌क नाळेह कीस वेहतनुर. अस्के वेग़ मुने लोकुरिन बह नाळेह कींदोग़, तान्काय एक्‍वा इंजेक लोकुर नाळेम आयनुर,” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“नना मीकु पह्‌रा केवालोरिन ईय्ह्‌नन, ओम्ह्‌टु. मीक बेद्रम विचर वास्ता, अद्रम मीटु पह्‌रा तासाटु,” इनजोर पिलाति ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","अस्के पया ओर पह्‌रातोरिन पोसि अतोर. अह कीसि, तिळ्ह्‌प कीस तासतद आदतुन, बोग़े जर्गिह कीयनायो इन्जि सीना वर्सतोर. ओसो पह्‌रा केवालोरिन तासतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","पोल्वादिया मारतस्के, वारमता मुनेता दिया (इतेके ऐतारम दियाते), पंङवियतस्के मग्डला नाटेनद मरियालि, ओसो ताना ऐंगेतद दुस्रा मरियालि, इवु गुमयातुन ऊळलाह अताङ. ");
INSERT INTO mrr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","अस्के ऊळाट, इळ्ता बूम पका मेलियता, बाराह्‌क इतेके देवतुलि देवुळदीपताहि रेगिसि, अद तिळ्ह्‌प कीस मतद बंडातुन ओर्केडके दोबिसीता, अह कीस ताना पेटळ उदता. ");
INSERT INTO mrr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","अद देवतुलि किस-उळ्मलेह्‌का मांजिंदु, ओसो तानाङ गेंदेङ कोंगा-बूलालेह्‌का पका पांड्रि मताङ. ");
INSERT INTO mrr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","तान रेयिसि, पह्‌रा मनवालोर दिरदिर साङतोर, कुस्क मेग़्यतप आतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","अस्के देवतुलि अव आस्किन इता, “मीट रेयमाटु! हव्कनागुटातगा वेळ्हतोग़ येसुन मीट पर्ह्‌किह्‌निर, इद नाक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ओग़ इगा इलेग़. ओग़ मुने वेहच मतपु, मल्स जीवा अरतोग़. वाट, ओना सेत्तातुन तासिस मतद जागातुन ऊळाटु. ");
INSERT INTO mrr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अह कीसि चट्पिट अन्जि ओनाङ कग़यवालोरिनु इह वेहाटु: ‘ओग़ हासि मल्स जीवा अरतोग़. ओसो केंजाटु, ओग़ मीकाय मुने गालिल पटटे दास्तोग़. अगा मीट ओन ऊळकिर,’ इन्जि वेहाटु. नावा वेहतद कबुरतुन सेतेम पोय्म्ह्‌टु,” इनजोर देवतुल इता. ");
INSERT INTO mrr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","पया अव आस्कु रेयिस मताङ, मति पका गिर्दा आसोरे, गुमयातग्डाह चट्पिट पेसिसि, येसुनाङ कग़यवालोरिह्‌कु इद कबुर वेहतलाहि वित वाताङ. ");
INSERT INTO mrr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","अस्के दोम्‍क्‍नेन येसु अविस्किन कलियिस “बेस पिसाटु!” इनजोर इतोग़. कलियतस्के अव ओना एरे अन्जि, ओनाङ काल्क मोळ्कताङ. ");
INSERT INTO mrr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","अस्के अविस्किन येसु इतोग़, “मीट रेयमाटु. मति मावोर कग़यवालोरक्‍के अन्जि ‘गालिलते अन्ह्‌ट अले, मीक येसुसामि अगान कलियनोग़,’ इनजोर ओरिह्‌क वेहाटु.” ");
INSERT INTO mrr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","अव अनजोर मताङ अस्के, गुमयातगा पह्‌रा मनवालोर वेल्‍लाटोरे इव आतव गोटिनु, सहरते अन्जि पेर्मालोरिह्‌क कतम वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","अस्के पेर्मालोर ओसो यहुदिराङ पेदल्क कलियिसि विचर कीतोर, अह कीस पया पह्‌रातोरिह्‌कु वेल्‍लाङे कोताङ ईसि इह वेहतोर: “‘माटु गोडनिद्रते मतोम अस्के, येसुनाङ कग़यवालोर नग़्का वासि, ओना सेत्तातुन कलिस ओतोर,’ इद्रम इनजोर पोल्‍लोतुन मिळ्हचि वेहाटु. ");
INSERT INTO mrr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ओसो इद पोल्‍लो गुमसिना केवदगा अरता इतेके, माट ओन मानेह कीसि, मीवा पेटळ वाया एवोम,” इन्जि पेदल्क इतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","अदिह्‌क ओर पह्‌रातोरु कोताङ एचि, पेदल्क काग़्हतपु अहे कीतोर. अद्रम आस पया, इद पोल्‍लो यहुदि लोकुरगा आबुर आता, नेंड वने ओर अहे इन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","पया इके कग़यवालोर अक्रा मांदि गालिल पटटे, येसु बेद मेटातगा वाट इनजोर वेहच मतोग़, अगा ओर अतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","अतस्के, ओर ओन अगा ऊळिसि दंडुम अरतोर, तेला मति (ओग़ येसुये आंदोग़ा, आयोग़ा इन्जि,) ओरग्डाह उय्तुर उन्क-मन्क मतोर. ");
INSERT INTO mrr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","अस्के येसु ओरा एरे वास इतोग़, “देवुळदीपते ओसो नेदे मनवालोर कतमतोरा पोग़ोन, देवुळि नाक पूरा अदिकर ईता. ");
INSERT INTO mrr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","अदिनेनाह्‌क मीटु अन्जि, सबे जातिनोर लोकुरगा, नावाङ कग़यवालोर आयिर इन्जि, ओरिह्‌कु नावाङ पोल्‍लोङ वेहचि, देवुळबाबाना, ओसो देवुळता मग़ना, ओसो देवुळता पवित्र जीवाता पेदिरते, एग़ मीहाटु. ");
INSERT INTO mrr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अह कीसि, बेव अडोङ मीक नना माळलाह वेहतन, अव कतम अडोनु ओरिह्‌कु माळलाह काग़्हाटु. ओसो ऊळाटु, इद बूमता आक्रि एवनाह, नना अमेसा मीवा तोळ मह्‌नने!” इन्जि इतोग़.");
INSERT INTO mrr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","देवुळता मग़ि येसु किर्स्तुना लोप्पाडा बेसता कबुरता पोल्‍लो, इद्रम सुरु आस्ता: ");
INSERT INTO mrr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","(किर्स्तु वायनेनाह्‌कु, लोकुरिन ओप्पे कीयलाह, देवुळि ओर्विन लोहता. वेग़ लोहतोना लोप्पा,) मुनेने देवुळता सास्त्रमते, इद्रम रासतद मन्ह्‌ता इतेके, केंजाटु! सामि वायनामुनेन, नना देवुळतन, नावा बळयिन लोहतलाह आतन. ओग़ सामिनेनाह्‌क अग़ि तीर्ह्‌कनोग़. पेळ्ह्‌कल बूमते नावा बळयि केयलाह आतोग़: “सामि मीवा जीवातगा वायना इन्जि, ओना अग़दुन तीर्ह्‌काटु, ओना वायनद अग़दुन कसुम कीम्ह्‌टु,” इनजोर वेल्‍लाय मुनेतोग़ देवुळता कबुरतोग़ यसयाल इनवाल रासिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","(रासतद पोल्‍लो निटम आनाह,) पेळ्ह्‌कल बूमतगा देवुळता पेदिरते एग़ मीहवाल योहनि वातोग़. ओग़ इद्रम पोकुर कींदोग़: “पापमता अग़दुन विळ्सिसि, देवुळतके मल्म्ह्‌टु. मलतोम इनजोर तोहतलाह, देवुळता पेदिरते एग़ मीम्ह्‌टु, अस्के देवुळि मीवा पापमतुन मापि कीयग़ा,” इंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","पया येरुसलेम सहरताहि, ओसो यहुदा पटटाङ दुस्राङ नाह्‌कनाहि, वेल्‍लाटोर लोकुर ओनगा अंदुर. लोकुर तमा कीता पापमतुन कबुल आसि, योर्दन बेरेटगा योहनना कयदे देवुळता पेदिरते एग़ मींदुर. ");
INSERT INTO mrr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","योहनि इतेके (देवुळता कबुरतोनन इन्जि तोहतलाह,) रूटुह्‌कनाङ केल्कने कोटटद गेंदे उहन्दोग़, नंडटुह्‌कु तोलाता पेटा दोहन्दोग़. ओसो ओग़ पापेङ, ओग़्वेनेय तिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ओग़ इद्रम पोकुर कींदोग़: “नावा पेग़्के ओर्वोग़ वायलाह आतोग़, ओग़ नाकाय पका लावतोग़ आंदोग़. ओना कादुन इटलाह वने, नना ओप्पोन. ");
INSERT INTO mrr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","नना मीकु देवुळता पेदिरते सिरप एतेन मीहतन, मति ओग़ मीकु देवुळता पवित्र जीवाते मीहतनोग़,” इनजोर पोकुर कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","अद्रमे योहनि देवुळता पेदिरते एग़ मीहचोर मनेके, उंद दिया येसु गालिल पटटा नासरेत नाटेनाहि वासि, योर्दन बेरेटगा योहनना कयदे, देवुळता पेदिरते एग़ मीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","येसु एतगा मुळ्न्दिस पोग़ोन तेदतस्के, अस्केडस्केन पोग़ोटा बूमि पङ्ने आसि,देवुळता पवित्र जीवा परेवा पिटेलेह्‌का, तना पोग़ोन रेगनदिन येसु ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अचोटेन पोग़ोटाहि देवुळता आल्का केंज वाता, “निमा नावा जीवा कीतोग़ मग़निन, नीवा लोप्पा नना पका गिर्दा आतन,” इनजोर केंज वाता. ");
INSERT INTO mrr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","पया चट्‌ने देवुळता जीवा अग्डाहि येसुन, वेल्‍लाय जेक पेळ्ह्‌कल बूमते ओसीता. ");
INSERT INTO mrr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","अगा रेंड वीसाङ दियाङ, देयह्‌कना मुक्याल येसुना पट ऊळता, मति येसु तानाङ केंजोग़. ओसो येसु अगा गेळा जन्वर्कना संगे मतोग़. अगा मतस्केने, देवतुल्कु ओना सेवा कीसोर मंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","पया बह आता इतेके, अग्डोग़ राजाल योहनिन जेलते वाट वेहतोग़. ताना पया, येसु गालिल पटटे वासि, देवुळता राजेमता बेसता कबुरतुन पोकुर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","येसु इद्रम इंदोग़, “देवुळ वेहतद कगो एरे एवता; इंजेके देवुळि मन्कलोरगा राजेम कीयनद दिया एवयलाह आता. मीट पापमता अग़दाहि मल्सि, बेसता कबुरतुन विस्वस कीम्ह्‌टु,” इनजोर इंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","उंद दिया येसु गालिल सम्दुरता दडिय अनेके, ओग़ु सिमोनि, आंद्रेयाल, वेर तमोग़ इर्वुरिन ऊळतोग़. वेर मीन्क पोयवालोर मताह्‌कु, सम्दुरतगा वदिङ आहचोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","अस्के येसु ओरिन इतोग़, “नावा संगे दटु. मीट इचानाह मीन्क पोयंदिर; मति इंजेके मीटु मन्कलोरिन नयगा तवालोरिर आयकिर, अद्रम नना मीक कीकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","इदिन केंजताहे, वदिन अगान विळ्सिसि, वेर तमोग़ इर्वुर आसि, येसुना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","पया येसु उचुन मुनेह अनेके, जेबेदि इनवानाङ मग़्कु याकुबि ओसो योहनि, वेरिन ऊळतोग़. वेर तमोग़ इर्वुर आसि, ओडातगा वदिन ओर्कुल कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","येसु ओरिन ऊळतस्के, चट्‌ने तना संगे वायलाह केयतोग़. केयतस्के ओर इर्वुर आसि, तमा तपे जेबेदिन, कूलतोरा संगे ओडातगान विळ्सिसि, येसुना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","अद्रमे पया येसु ओसो ओनाङ कग़यवालोर कापेर्नाग़ अतोर. अन्जि वारमता पोल्वादियाते पार्तनाता लोतगा येसु काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ओग़ काग़्हतनदिन केंजिसि, लोकुर बयल आतोर. बह इतेके येसु ओरिन सास्त्रमगूरुरा लेह्‌का काग़्होग़, मति तन्क अदिकर मतपु काग़्हन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","अचोटेन दोम्ह्‌क्ने अद लोतगा ओर्वोग़ मन्कल ओळियतोग़. ओन देयम पोस मता. ");
INSERT INTO mrr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","अद देयम जोरते केयिस इद्रम इता, “ए नासरेत नाटेनोग़ येसुनिन, मावा संगे नीवा बाताल कबळि? निमा बह माक बूळे कीयलाह वातिना? निमा बोनिन इनजोर पुनोना? निमा देवुळ लोहतोग़ पवित्र मन्कनिन आंदिन!” इता. ");
INSERT INTO mrr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","मति येसु अद देयमतुन, “केमेन मन! वेनग्डाहि पेसिस अन!” इनजोर दगा ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","अस्के अद देयमि ओग़ मन्कन तेल्हच मन्जि, जोरते केयिसि, ओनग्डाहि पेसिस वितता. ");
INSERT INTO mrr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","इदिन ऊळिस अगा मतोर लोकुर बामिसि, ओर्विह्‌क-ओर्वोग़ वळ्ह्‌कसोर, “इद बेद्रमता पूना पोल्‍लो रा? वेग़ अदिकरते देयह्‌किन वने उकुम ईस्तोग़, अव वेना पोल्‍लोतुन केंजिह्‌ताङ वने,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","पया येसुना इद पोल्‍लो चट्पिटे गालिल पटटाङ एरे-गूरेताङ नाह्‌कनगा आबुर आता. ");
INSERT INTO mrr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","अद्रमे पया येसु तनाङ कग़यवालोर याकुबिन, योहनिन पोसि, पार्तनाता लोताहि पेसिस सिमोन, आंद्रेयाल, वेर तमोग़ इर्वुरा लोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","अद वेलाते सिमोनना आतोह्‌क दंड पोस मता, इद पोल्‍लो बोरो येसुह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","पया येसु तानगा अन्जि, ताना कयदुन पोस तेहतोग़, तेहतस्केन ताना दंड रेगता. पया अद ओरिह्‌क जावा-एग़ कीसीता. ");
INSERT INTO mrr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","अदे दिया मुलतस्के, वारमता पोल्वादिया मारता. अस्के लोकुर सबे दुकिनोरिन ओसो देयह्‌क पोयतोरिन येसुनगा ततोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","पूरा नाग़मेटोर इतपे मुलु, अद लोता मुनेह जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","पया अलग-अलग रीतताङ दुकिने तिपल आसोर मतोरिन, येसु सव्रे कीतोग़. अहे ओसो वेल्‍लाटोरिन देयह्‌क पोस मताङ, अविस्किन वने ओरग्डाहि पेसिह कीतोग़. देयह्‌कु येसु बोग़ आंदोग़ इनजोर पुंदुङ. मति (अद तूकने, नना बोनन इन्जि, सबेटोरिह्‌क एर्का आयनद आयो इनजोर,) येसु अव देयह्‌किन वळ्ह्‌कलाह एवोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","पया सकरताङ कोग़्क कूसिह्‌पान येसु तेदिसि, बोरे लेवगा अन्ज पार्तना कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","अस्के पया सिमोन तना तोळतोर बार, येसुन पर्ह्‌कलाह अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","अन्जि येसुन ओर दोर्किह कीतोर, अस्के ओन इतोर, “नाटेनोर वेल्‍लाटोर लोकुर नीक पर्ह्‌कलाह आतोर, गूरु,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","मति येसु ओरिन इतोग़, “आयो! माट इकेडाङ एरे-गूरेताङ नाह्‌कने दाकल. अगा वने नाक देवुळता पोल्‍लोतुन पोकुर कीया पोयह्‌ता, इदे कबळतुह्‌क नना वातन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अद्रम पया येसु तनाङ कग़यवालोर बारा, पूरा गालिल पटटे तिरियतोर. नाग़-नाग़ अन्जि, येसु यहुदिराङ पार्तनाताङ लोह्‌कनगा पोकुर कींदोग़. अहे देयह्‌क पोस मतोरग्डाह देयह्‌किन पेसिह कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","उंद दिया ओर्वोग़ मोंडरोगमतोग़ मन्कल येसुनगा वातोग़. (अद्रमतोरिन यहुदिर कळ्‍वोग़तासिंदुर.) ओग़ येसुनगा वासि, मिंडाङ कोटिसि इद्रम अर्जि कीतोग़, “नीवा विचर मतेके, नाक सव्रे कीसि नावा कळ्‍वोग़तुन तेंड पग़यकिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","इतस्के येसुह्‌क मान वसता. अदिनेनाह्‌क पया “अह इतेक अले, नावा विचर मन्ह्‌ताये! निमा बेस आम,” इनजोर इतोग़. इनदह्‌पा, (यहुदिरा मोळतोन इटवद नोमळता अडोतुन नोमवा,) येसु कय आहच ओन बोयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अस्के चट्‌नेन ओना मोंडरोगम मायता, ओग़ बेस आतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","पया येसु ओन इद्रम उकुम ईतोग़ इतेके, “इके केंजा! इद पोल्‍लोतुन बोन्के बार वेहमा. इंजेके निमा कुदि अन्जि, बेस आतन इन्जि, बूमयाह्‌क मात्रम तोहा. मोसानाङ अडोङ मतपु, मोंडरोगमता कळ्‍वोग़तुन तेंडनद मोक ईमु. सव्रेम आताह्‌कु मोक ईतोग़ इन्जि, बूमयाल सबेटोरिन वेहतनोग़, अस्के नियगा मोंडरोगमता कळ्‍वोग़ मनो आयग़ा,” इनजोरे मोळतोन येसु वेहच लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","(निमा बोन्के वेहमा इनजोर वेहचाय) मति, ओग़ मन्कल अद पोल्‍लोतुन पका आबुर कीतोग़. आबुर कीताह्‌कु, गोह्‌डिनाङ गोह्‌डिङ लोकुर नाक कलियलाह वायनुर इन्जि, येसु बेदे नाटेनगा पिङम-पङम दाया पग़वोग़. ओग़ पलते लोकुर लेवगान मंदोग़. तेला मति लोकुर ईनाह-आनाह ओनगा वांदुरे. ");
INSERT INTO mrr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","उचुक दियाना पया, येसु तनाङ कग़यवालोर बारा, ओसोवने कापेर्नाग़ मल्स वातोर. वातस्के ओग़ लोन मन्ह्‌तोग़ इनजोर, इद पोल्‍लो लोकुर केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","पया वेल्‍लाटोर लोकुर अद लोतगा जमा आतोर, काल ओगलाह जागा इले आसि, अग़दगा वने पूरा तिळ्ह्‌प अर्स मतोर. येसु ओरिन देवुळता पोल्‍लो वेहचोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अचोटेन नालवुर मन्कलोर, ओर्वोग़ कय्क-काल्क वाग़तोग़ मन्कन कांजिसि, येसुनगा ततोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","मति लोकुर अग़दुह्‌क तिळ्ह्‌प अरनाह निंदिस मतोर, वेरिह्‌क येसुनगा एवयलाह अग़ दोर्को. पया वेर लोता वेसळतगा तग़्ङिसि, येसु मतद अरातगाह्‌क कटुल पोदनाह, बेरा बूका कीतोर. बूका आतस्के, अद बूकाताहि ओग़ तेद पग़वोग़ मन्कन, कटुल अग़्के येसुना मुनेह रेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ओरा विस्वसतुन ऊळिसि, कय्क-काल्क वाग़तोन, येसु इद्रम इतोग़, “अल बाबा! नना नीवाङ कसुर्किन मापि कीय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","अस्के अगा उच्वुर सास्त्रमगूरुर उदिस मतोर. ओर येसु इतद पोल्‍लोतुन केंजिसि, आपुना-आपोग़े इद्रम विचर कीया बोटटोर इतेके, ");
INSERT INTO mrr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ऊळा वेग़ मन्कल उगसे, देवुळतन इतपे बह पोग़यिह्‌तोग़! देवुळतुन विळ्सिस इतेके, बोग़े पापमतुन मापि कीया पग़वोग़,” इनजोर विचर कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","पया येसु चट्‌ने ओराङ विचर्किन पुन्जि, ओरिन इद्रम इतोग़, “मीट नावा लोप्पा, बाराह्‌क कुळ्सा विचर कीय्ह्‌निर रा? ");
INSERT INTO mrr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","वेग़ कय्क-काल्क वाग़तोन ‘नीवाङ कसुर्कना मापि आता,’ इह इतेके अल्कोया? बार वेनु ‘तेदिस नीवा कटुल पोस अन,’ इनदनद अल्कोया? ");
INSERT INTO mrr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","इंजेके नना माने-मन्कना नडुम पुटटोनन मन्जि, देवुळतेनाह नयगा इद बूमते, पापमतुन मापि कीयनद अदिकर इंका मन्ह्‌ता इन्जि, मीक तोहतकन,” इतोग़. इन्जि कय्क-काल्क वाग़तोग़ मन्कन इद्रम इतोग़, ");
INSERT INTO mrr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“नना नीक वेहतलाह आतन, अले, तेदा! नीवा कटुल पोस लोन अन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","इताहे ओग़ मन्कल तेदतोग़, तेदिसि तना कटुलतुन पोस, सबेटोरा मुनेहतुह्‌क पेसिस अतोग़. इदिन ऊळिसि अगा जमा आतोर लोकुर पका बामतोर. बामिसि देवुळतुन जोहर कीसोरे, “माट इद्रमता कबळ बेस्केन ऊळवल अयो!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","पया येसु अद लोताहि पेसिसि, गालिल सम्दुरता दड कचुलिये अतोग़, अस्के वेल्‍लाटोर लोकुर ओना पयाह वातोर. पया येसु ओरिन काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","पया अग्डाह अनेके, सिद्‌वा एतना नाकातगा, अल्पुना मग़ि लेवि पेदिरतोन सिद्‌वा एतह्‌पा, येसु ऊळतोग़. ऊळिसि “नावाङ कग़यवानिन आयकिन दय!” इतोग़. इतस्के लेवि तेदिसि, येसुना संगे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","पया येसु तनाङ कग़यवालोरा संगे, लेविना लोतगा गाटो तिनदलाह उदिस मतोग़. अस्के येसुना पयाह वास मतोर, वेल्‍लाटोर सिद्‌वा एनवालोर मुळ्हेर ओसो पापिर वने, तिनदलाह उदतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","येसु सिद्‌वा एनवालोरा संगे, पापिरा संगे, गाटो तिनदनदिन परुसिर ओसो सास्त्रमगूरुर ऊळतोर. ऊळिसि “एग़्ङ वानाहि, येसु बेद्रम वेरा संगे, तिनदना-उनडना कीस्तोग़ रा?” इनजोर ओनाङ कग़यवालोरिन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","येसु ओरा वळ्ह्‌कनदिन केंजिसि ओरिन इतोग़, “रोगमलेवोरु डाक्‍टरनके अनोर, मति रोगम मतोरे तमा दुकतुन पोहतलाह दास्तोर, पुनविरा? अद्रमलेह्‌काने माट नेह्‌नोरोम इनवालोरिन आयो, मति पापिरिन केयलाह नना वातन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","देवुळता पेदिरते एग़ मीहवाल योहननाङ कग़यवालोर ओसो परुसिर उपस कींदुर. मति येसुनाङ कग़यवालोर उपस केवोर. अदिनेनाह्‌क ओरग्डाह उय्तुर येसुनगा वासि इद्रम इतोर, “योहननाङ कग़यवालोर ओसो परुसिराङ कग़यवालोर उपस कीस्तोर; मति नीवाङ कग़यवालोर बेद्रम उपस केवोर?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","अस्के येसु ओरिन इतोग़, “मर्म-पेकाल तमा संगे मनदह्‌पा, मर्मिङ अतोर उपस कीया पग़यह्‌तोरा? मर्म-पेकाल ओरा संगे मनाह्‌जोम, ओर उपस कीया पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","मति कोटुलतोर वासि, मर्मपेकान ओरग्डाहि एग़्‍पिह कीसि पोस ओयनुर, इद्रमता वेला वायग़ा, अद तूकने ओर दुकम आसि तिनोर आयनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","(इतापया, तना काग़्हतव पूनाङ पोल्‍लोनगा, पाळ्ना रिवजताङ पोल्‍लोङ कलिय पग़वोङ इनजोर तोहतलाहि, रेंड पुन्पिह कीयनव पीटोने इद्रम इतोग़,) “पाळ्ना गेंदेता अग़ता बूकातगा मेतलाह, पूना गेंदे बोग़े ओल्सोग़. ओल्सतेके पूना गेंदे पाळ्ना गेंदेतुन अग़्हचि, इंका ओसो बेरा बूका कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","अद्रमे ओयवदु पूना अंगुर जोमातुन, पाळ्ना तोलाजोर्काते बोग़े एन्दोग़. एन्दतेक इसि मिङतद जोमा ओयिसि बोल्गिह्‌ता. बोल्गताह्‌कु, जोर्का ओसो आङिसि अग़यह्‌ता. अग़्स पया अंगुर जोमा ओसो जोर्का रेंड आसि बूळेम आस्ताङ. अदिह्‌क पूना मिङतद अंगुर जोमातुन पूना जोर्काते एन्दिह्‌तोर.” (नना पूनाङ-पूनाङ पोल्‍लोङ काग़्हतह्‌नन, अविस्कनगा पाळ्ना रिवजताङ पोल्‍लोङ काल्ह्‌पनायो इन्जि, येसु इव पुन्पिह कीयनाङ पीटोङ वेहतोग़.) ");
INSERT INTO mrr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","उंद दिया इद्रम आता इतेके, येसु वारमता पोल्वादियाते, गोह्‌क अय्स मतव, बोराङो पोलह्‌कना नडुमतुह्‌क अनजोर मतोग़. अनेके येसुनाङ कग़यवालोर गोह्‌कनाङ एन्किन ऊचिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तेन ऊळिसि अगा मतोर परुसिर येसुन इतोर, “पोल्वादियाते बेदे कबळ कीयलाह पोलो, तान नीवाङ कग़यवालोर बह नोमोर?” इनजोर कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","अस्के येसु ओरिन इद्रम इतोग़, “मुनेटा कालमते दाविद राजाल तनाङ ऐंगेटोर बार, ओरिह्‌क कग़्व वसतस्के बह कीतोर, तेन मीट देवुळता सास्त्रमते बेस्केन अर्वविरा? ");
INSERT INTO mrr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","अस्के ओरु देवुळता रावुळतगा बह अतोर; अगा देवुळतुह्‌क वाटटाङ बेव आरिङ, बूमयालोरिह्‌के तिनदलाह पोलिंदुङ; दाविदिह्‌क पोलवेकाय, अवे आरिन अबियातार इनवाल पेर्माल ओन्क तिनदलाह ईतोग़, दाविद पया तना तोळतोरिह्‌क तूसिसीतोग़.(अस्के देवुळि दाविद राजानु तपतिन इनो अले,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ओसो येसु ओरिन इतोग़, “देवुळि वारमता पोल्वादियातेनाह्‌क मन्कन पुटिह केवो, मति मन्कनेनाह्‌के पोल्वादियातुन पुटिह कीता. ");
INSERT INTO mrr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","अदिनेनाह्‌क नना माने-मन्कना नडुम पुटटोनन मन्जि, पोल्वादियाते पोलनदिन, पोलवदिन वेहतनद अदिकर नाक मन्ह्‌ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","अद्रमे ओसो उंद देबा, येसु पोल्वादियाते यहुदिरा पार्तनाता लोन अतोग़. अगा ओर्वोग़ वाग़ता कयदोग़ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","(अगा उच्वुर परुसिर वने मतोर.)पोल्वादियाते ओग़ मन्कना कयदुन येसु सव्रे कीस्तोग़ा, बार केवोग़ा, इनजोर ऊळसोर मतोर. पोल्वादियाते सव्रे कीतेके, येसुना पोग़ोन (अद दिया कबळ कीयनद) तप तोहतकोम इनजोर, पट ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","येसु वाग़ता कयदोनु, “तेदिसि नडुम वास निल्म,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","पया येसु अगा मतोर मन्कलोरिन इद्रम ताल्ह्‌कतोग़, “पोल्वादियाते बाताल पोलिह्‌ता? बेसता कबळ कीयनदा, बार लाग्वा कबळ कीयनदु? जीवातुन पिसिह कीयनदा, बार बूळे कीयनदु, वेहाट!” इतोग़. मति बोरे बह वळ्ह्‌कोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","येसु ओङते सबेटोरिन ऊळतोग़, मति ओर कैंगम बुदते मतदिन ऊळिसि, येसु दुकम आतोग़. आसि वाग़ता कयदोन “नीवा कय आहा!” इतोग़, अस्के ओग़ कय आहतोग़. आहतस्के ओना कय सव्रेम आता. ");
INSERT INTO mrr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","पया परुसिर अग्डाह पलत पेसिसि, येसुन बह कीस हव्ककल इनजोर, एरोद राजाना तुंगातोरा संगे कलियिसि वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","अद्रमे पया येसु तनाङ कग़यवालोरिन पोसि, सम्दुरतेके अतोग़. गालिल पटटोर वेल्‍लाटोर लोकुरा गोह्‌डि, येसुना पेग़्के अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","येसु कीतद बामिह कीयनद कबळतुन केंजिसि, येरुसलेम सहरताहि, अहे यहुदा पटटाङ दुस्राङ नाह्‌कनाहि, इदुमिया पटटाहि, योर्दन बेरेटा अबरताङ नाह्‌कनाहि, सोर-सिदोन सहर्कनाहि, अव सहर्कना एरे-गूरे मनदनव नाह्‌कनाहि, वेल्‍लाटोर लोकुर येसुनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","वेल्‍लाटोर लोकुर मताह्‌कु, लोकुर तना पोग़ोन अरमाकिर इनजोर, येसु तनाङ कग़यवालोरिन, “उदिस काग़्हतलाह, नाक उंदि ओडा तयर कीम्ह्‌टु,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","येसु वेल्‍लाटोरिन सव्रे कीस मतोग़, अदिह्‌क बेमरतोर ओन बोयलाह दोबेङ-नूकेङ आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","देयह्‌क पोयतोर वने, लोकुरा नडुम मतोर. अव देयह्‌क येसुन ऊळतेक अचोन, ओना मुनेह अर्सि, “निमा देवुळता मग़निन!” इनजोर, जोरते केयिंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","मति येसु, “नना बोनन इन्जि, बोन्के बह वेहमाटु!” इनजोर अविस्किन उकुम ईंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","अद्रमे उंद दिया येसु गुड्रातगा पोग़ोन तग़्ङतोग़. तग़्ङिसि तन्क विचर वातोरिन, तनगा केयतोग़. केयतस्के ओर ओनगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","अतस्के तना संगे मन्जि कग़यलाहि, देवुळता पोल्‍लोतुन पोकुर कीयलाह लोहतलाहि, मन्कलोरग्डाह देयह्‌किन पेसिह कीयनद अदिकर ईयलाहि, बारा बळयिरिन निल्पिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ओर बारा मन्कलोराङ पेदिर्क इद्रम मन्ह्‌ताङ: सिमोन (वेन पत्रु इनजोर येसु दुस्रा पेदिर तासतोग़); ");
INSERT INTO mrr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जेबेदिनाङ मग़्कु याकुब ओसो योहन, वेर तमोग़ इर्वुर (बुवनरगिस इतेके गुळ्न्जना लेह्‌काडोर इनजोर, येसु वेरिन दुस्रा पेदिर तासतोग़); ");
INSERT INTO mrr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","आंद्रेयाल, पिलिप, बार्तोलोम, मत्याल, तोमाल, अल्पुना मग़ि याकुब, तदु इनवाल यहुदाल, सिमोन (वेग़ रोम सर्करता अडम पार्टितोग़ मतोग़). ");
INSERT INTO mrr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ओसो यहुदा इस्केर्योत, वेग़े आक्रिते येसुन कोंटेतोरा कयदे पोसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","पया येसु कापेर्नाटे तना मतद लोतगा वातोग़. अस्के ओसोवने इचोन लोकुर जमा आतोर इतेके, येसुह्‌क ओसो ओनाङ कग़यवालोरिह्‌क, गाटो तिनदलाह वने अग़ दोर्को. ");
INSERT INTO mrr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","येसुना लोतोर इद पोल्‍लोतुन केंजिसि, ओन ततलाह अतोर. बाराह्‌क इतेके, येसु बय्माङ आतोग़ इनजोर, लोकुर वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","उच्वुर सास्त्रमगूरुर येरुसलेम सहरताहि वास मतोर. ओर इद्रम इतोर, “वेन बेल्जेबुब इनदनद देयह्‌कना मुक्याल पोयता, तानाय साय्ताते, देयह्‌किन मन्कलोरग्डाहि पेसिह कीस्तोग़ रा!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","अदिह्‌क येसु ओरिन तनगा केयिसि, पुन्पिह कीयनव पीटोने इद्रम वेहतोग़, “देयह्‌कना मुक्याल बाराह्‌क तनाङ देयह्‌किन पेसिह कीयग़ा? ");
INSERT INTO mrr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","बेदाय राजेमते तमाय नडुमि कोंटेङ पुटटेके, अद राजेम निच मनो. ");
INSERT INTO mrr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अहे बेदाय लोतगा कोंटेङ पुटटेके, अद लोन निच मनो. ");
INSERT INTO mrr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","अद्रमे देयह्‌कना मुक्याल ओसो ताना तोळताङ देयह्‌क, तमतमा विरुद आतेके, अविस्कना लाव मनो आवालि. ");
INSERT INTO mrr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","मति उंद लोतगा नेङिस, लूटे केवाल मुने अग्डोग़ पळ्योन दोहवालेवा, अग्डा मादुन लूटे कीसि पेहता पग़वोग़. मुने पळ्योन दोहतेकेने, ओना लोतुन वेग़ लूटे कीस ओयनोग़. (अद्रमलेह्‌का देयह्‌कना पळ्योन दोहतेकेने, नना देयह्‌किन पूंड पग़यकन,)” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","ओर सास्त्रमगूरुर येसुन देयम पोयता इनजोर इंदुर. अदिनेनाह्‌क (इद्रम तप तोहतनद, देवुळता जीवातुनपास्कतप आस्ता, इदिन तोहतलाह) येसु ओसो इतोग़, “इह केंजाट, मीक सेतेम वेहतह्‌नन, मन्कना सबे पापमतुनु, अहे देवुळता अडम वळ्ह्‌कतदिनु, देवुळि मापि कीया पग़यग़ा. मति बोग़ देवुळता पवित्र जीवातुन पास्किह्‌तोग़, ओन देवुळि बेस्केन मापि केवो आयग़ा. ओग़ हातेकाय, अद पापम मापि आयवा ओनगा मन्ह्‌ताये,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","पया अस्केन येसुना तलोग़ि, ओनाङ तमोर वातोर. ओर अग़दगा निचि, येसु पलत पेसेग़ इनजोर, केय लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","अस्के ओना सर्ने उदिस मतोर लोकुर इतोर, “गूरु, नीवा यायालि, नीवाङ तमोर पलते नीक पर्ह्‌कलाह आतोर,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","इदिन केंजिसि येसु इतोग़, “नावा यायालि, नावाङ तमोर, नावा लोतोर बोर आंदुर?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","पया ओना सर्ने उदिस मतोरिन ऊळिसि इतोग़, “ऊळाट! नावा लोतोर इतेके वेरे आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","बोर देवुळ वेहतप ताकिह्‌तोर, ओरे निटमे नावाङ दादालोर-तमोर, एलास्क-बायिस्कु, तलिस्क आंदुर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","येसु ओसो उंद देबा गालिल सम्दुरकचुल, लोकुरिन काग़्हता बोटटोग़. वेल्‍लाय मुलु ओना सर्ने जमा आस मतोर. अदिनेनाह्‌क येसु एग़कचुल मतद ओडातगा उदतोग़. सबेटोर बार ओनाङ केंजलाह, दडकचुल निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","येसु मुडा लोकुरिन पुन्पिह कीयनव पीटोने, वेल्‍लाङे पोल्‍लोङ काग़्हतोग़. उंद पीटो इद्रम मता: ");
INSERT INTO mrr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“केंजाट, उंद दिया ओर्वोग़ मन्कल विजा वीतलाह पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ओग़ वीतनेके, उडुन विजा अग़दा कचुल अरता, अदिनु पिटेङ वासि कतम तिताङ. ");
INSERT INTO mrr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","उडुन विजा आद बंडाना जागाते अरता, अगा आदता पोग़ोन बर्बर तोळ्यो मताह्‌क, विजा चट्पिटे मोन्ह्‌टटा. ");
INSERT INTO mrr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","मति ईर्क लोपा अनवाह्‌कु, एद तेग़तस्के पोर्ह्‌काङ वाग़िस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ओसो उडुन विजा कोये-जपिना जागाते अरता, पया कोये-जपिङ वने बेर्सिसि पेसनद वंज-सोपतुन हव्कताङ, बेर्स एवोङ. अदिनेनाह्‌क अव एन्क पेसोङ. ");
INSERT INTO mrr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","मति उडुन विजा इसि, राब जागाते अरता. पया अद मोन्ह्‌टिसि, उंद-उंद मोदुदुह्‌क बेगा डेडा वीसा (30), बेगा मूंड वीसाङ (60), बेगा नूरु (100), इद्रमलेह्‌का तेना पंटा वाता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","वेहचि, “मियग्डाहि बोरिह्‌क पुनदलाह गिर्दा मन्ह्‌ता, नावा पोल्‍लोतुन बेस केंजाटु!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","पया येसु वग़ोग़े मतोग़ अस्के, तनाङ बळयिर बारा मन्कलोर, ओसो दुस्रोर उच्वुर ओना संगे मनवालोर ओनगा वासि, “गूरु, इद पीटोता अर्तम माक वेहा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","येसु ओरिन इतोग़, “मीक इतेके, देवुळि तना राजेमताङ मकतव पोल्‍लोन पुनदलाह बुद ईता, मति तानाङ पोल्‍लोन नमवोरिह्‌क बार, इव पोल्‍लोन नना पुन्पिह कीयनव पीटोने वेहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","बह इतेके: ओर नावाङ कबस्किन ऊळलाह कोनि ऊळनुर, मति अविस्कना अर्तम ओर पुनोर आयनुर, ओसो नावाङ केंजलाह कोनि केंजनुर, मति ओरिह्‌क तेळियो आयग़ा. अद्रम पुतेके, तेळियतेके, ओर देवुळतके मलवेर, अस्के देवुळि ओरा पापमतुन मापि केवालि,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","पया ओसो ओरिन इतोग़, “मीट इद पीटोता अर्तम पुनवेके, इंका ओसो वेहतनव सबे पीटोना अर्तम बेद्रम पुनदकिर? ");
INSERT INTO mrr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","वीतवाल इतेके, देवुळता पोल्‍लोतुन पोकुर केवाल आंदोग़, (विजा इतेके देवुळता पोल्‍लो आंदु). ");
INSERT INTO mrr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","अग़दगा अरतद विजाता जागा इहलेह्‌का मन्ह्‌ता. उच्वुर मन्कलोर देवुळता पोल्‍लोतुन केंजिह्‌तोर, मति देयह्‌कना मुक्याल चट्‌ने वासि, ओरा जीवातगा वीततद पोल्‍लोतुन माग़्ङनाह कीस्ता. ");
INSERT INTO mrr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","अद्रमे आद बंडातगा अरतद विजाता जागा इहलेह्‌का मन्ह्‌ता: उच्वुर मन्कलोर देवुळता पोल्‍लोतुन, गिर्दाते चट्‌नेन केंजिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","मति अद पोल्‍लो ओरा जीवातगा गडवाह्‌कु, गळ्के विस्वस कीस्तोर. पया देवुळता पोल्‍लोतुन नमताह्‌क, ओरिह्‌क अड्सन्काय, तिपल्काय वातेके, चट्‌नेन विस्वसतुन विळ्सिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","कोये-जपिनगा अरतद विजाता जागा इहलेह्‌का मन्ह्‌ता, उच्वुर मन्कलोर देवुळता पोल्‍लोतुन केंजिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","मति पिसवग़ताङ आल्सुळ्कु ओसो अनम-दनमता उळ्बे, सम्सरमता लालुस, इव ओरा जीवातगा देवुळता पोल्‍लोतुन बेर्स एवोङ, पया अद पोल्‍लो बातय पाय्दाता आयो. ");
INSERT INTO mrr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","मति राब जागा इहलेह्‌का मन्ह्‌ता, बोर मन्कलोर देवुळता पोल्‍लोतुन केंजिसि, तमा जीवातगा तासिह्‌तोर. (राब जागातगा अरतद विजा) बेद्रम उंद-उंद मोदुदुह्‌क बेगा डेडा वीसा (30), बेगा मूंड वीसाङ (60), बेगा नूरु (100), इद्रम पंटा वास्ता, अद्रमता पंटालेह्‌का, ओर बेसताङ कबस्क कीस तोहतह्‌तोर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","येसु ओसोवने ओरिन इतोग़, “बोग़ाय चिमलि नीर्विह कीसि, डूटलोप्पा मुळ्हच तासनोग़ा? इलवेके कटुलता इळ्न तासनोग़ा? आयो, वेह्‌च आयि इनजोर, बोव्लापोग़ोन तासिह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","अद्रमे देवुळताङ सबे मकिह कीतव पोल्‍लोङ पङ्ने आयनुङे, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","मियग्डाहि बोरिह्‌क पुनदलाह गिर्दा मन्ह्‌ता, ओर नावा पोल्‍लोतुन बेस केंजाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ओसोवने ओरिन इतोग़, “इव पोल्‍लोनु मीट उसरते केंजाटु. बेद गोट्‍टाते मीट दुस्रोरिह्‌क कहच ईय्ह्‌निर, अदे गोट्‍टाते देवुळि मीक कहच ईयग़ा, तान्काय एक्‍वा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","बाराह्‌क इतेके, बोनगा पुनदनद बुद मन्ह्‌ता, ओन्कु देवुळि ओसो इंका ईयग़ा. मति बोनगा पुनदनद बुद इले, ओनगा बेचोन दिसिह्‌ता, तान वने देवुळि तेंडिस ओयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","अद्रमे ओसो येसु वेहतोग़, “देवुळता राजेमता पोल्‍लो इद्रमलेह्‌का मन्ह्‌ता: ओर्वोग़ मन्कल तना पोलमतगा पेनेह्‌क वीतिह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","वीतिसि ओग़ नग़्का उंजना, सकर तेदिस कबळ कीयना कीस्तोग़. पया पेनेह्‌क मोन्ह्‌टिसि बेर्सिह्‌ताङ. इव इद्रम बह आस्ताङ इनजोर, ओग़ मन्कल पुनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ओग़ मन्कल बातय केवालेवा, बूमि तनाय अनम पुटिह कीस्ता. मुने ऊयुम बेर्सिह्‌ता, बेर्सिसि एन पेसिस पूयिह्‌ता, पया एन्कनगा पेनेम पोयह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","अहे पया पेनेह्‌क अयताहे, चट्पिट एटळते कोयह्‌तोर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","येसु ओसो वेहतोग़, “देवुळता राजेमता पोल्‍लो बेद्रम बेर्सग़ा? इद पोल्‍लोतुन तेळियिह कीयलाह, उंद पीटो वेहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","देवुळता राजेमता पोल्‍लो, उंद पुलुळ पेनेमता लेह्‌का मन्ह्‌ता. पुलुळ पेनेम इतेके, पकाय उड्ला पेनेम मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","मति नेल अर्सि मोन्ह्‌टटापया, अद बेर्सिसि बेरा मरा आस्ता. अस्के पिटेङ वने, तानाङ कांदाना दळ्मतगा वासि, गूडाङ पंडिह्‌ताङ,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ओसो इद्रमताङ वेल्‍लाङे पीटोने, येसु लोकुरिन देवुळता पोल्‍लो वेहन्दोग़. ओर बेचोन पुनदा पग़्न्दुर, अचोन ओरिह्‌क वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","मुडा लोकुरिन पुन्पिह कीयनाङ पीटोङलेवा बातय वेहोग़ आंदोग़, मति मुल लेवस्के, तना संगे मन्जि, कग़यवालोरिह्‌क सबे पीटोना अर्तम तेळियिह कीस वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","पया अद दिया मुलपोळ्‍द, येसु तनाङ कग़यवालोरिन इतोग़, “अलेट! माट सम्दुरता अबर दडटेके दाकल,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","इतस्के मुडा लोकुरिन अगान विळ्सिसि, तना उदिस मतद ओडातेने, ओनाङ कग़यवालोर उदतोर. दुस्राङ ओडाङ वने ओरा संगे मताङ. ");
INSERT INTO mrr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","अस्के सम्दुरतगा बेरा दूंदि वाता. पया लच्काङ ओडातगा वास दल्गिंदुङ, ओडा पूरा एग़ निंदलाह आस मता. ");
INSERT INTO mrr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","येसु बार पेग़्केडेके, तला ऊसि वाटिसि, उंजिस मतोग़. पया कग़यवालोर ओनगा अन्जि तेहतोर, तेहचि इतोर, “ए गूरु, तेदा, माट मुळ्न्दिह्‌नल, बह निमा सीता केविना?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","इतस्के येसु तेदिसि, दूंदतुन दगाङ ईतोग़, ओसो एताङ लच्कान, “रोमा, मेर्क्ने आम!” इतोग़. इतस्के दूंद-मुर्गम मायिसि, बेस मेर्क्ने आता. ");
INSERT INTO mrr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","पया येसु कग़यवालोरिन इतोग़, “बाराह्‌क रेयिह्‌निर? (नना मीक पिसिह कीकन इनजोर,) नावा पोग़ोन विस्वस इलेया?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","मति ओर पका रेयतोर. रेयिसि तमतमाय, “अलाले! वळ्यु ओसो एग़ वने, वेना उकुमतुन केंजिह्‌ताङ अयो! इतेके वेग़ बेद्रमतोग़ मन्कल मनदनोग़ रा!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","पया ओर सम्दुरतुन वेंडिसि, गिरासेनिर इनवालोर दुस्रा जाततोरा एरियातगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येसु तनाङ कग़यवालोरा संगे ओडाताहि रेगताहे, देयह्‌क पोयतोग़ ओर्वोग़ मन्कल, डोलतोरिन पोहतनाङ पांजानग्डाहि पेसिसि, ओरिन कलियतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ओग़ मन्कन बोरे गोल्स्कने दोहता पग़वोर आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ओनाङ कय्किन-काल्किन गोल्स्कने दोहच मतोर, मति अविस्किन ओग़ देहचि, तुक्ळेङ-तुक्ळेङ कींदोग़. बोग़े ओन आव्रे कीया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ओग़ नग़्का-पियलि बेस्के इतेक अस्केने, गुमयानगा, गुड्रानगा केयसोर तिरियिंदोग़; ओसो तना मेंदुलतुन बंडाने कोह्‌किंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","पया ओग़ येसुन जेकनाहिये ऊळिसि, वित वातोग़. वासि येसुनाङ काल्क अरतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","पया येसु ओग़ मन्कन पोयतद देयमतुन “वेग़ मन्कनग्डाह पेसिस अन!” इनजोर इतोग़. अस्के “एय येसु, सबेट्क बेरा देवुळता मग़निन, निमा नाक बाराह्‌क अडम आय्ह्‌निन? निमा नाक सिक्सा एवोन इनजोर, देवुळता मुनेह किरिया कीम!” इनजोर देयम पोयतोग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","येसु ओन, “नीवा पेदिर बाताल?” इनजोर ताल्ह्‌कतोग़. अस्के ओग़, “नावा पेदिर वेल्‍लाटोरोम, बह इतेके माट वेल्‍लाटोरोम मह्‌नोम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","अव देयह्‌क येसुन, “माक इद एरियाताहि पूंडमा,” इनजोर पकाय अर्जि कींदुङ. ");
INSERT INTO mrr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","अगा मेटातगा वेल्‍लाङे गोह्‌ड पदिङ मेयसोर मताङ. ");
INSERT INTO mrr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","अदिनेनाह्‌क अव देयह्‌क, “माक अव पदिनगा लोहचीम, माट अव पदिनगा दाय्ह्‌नोम,” इताङ. ");
INSERT INTO mrr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","इतस्के येसु अविस्किन दायलाह ईतोग़, ईताहे देयह्‌क ओग़ मन्कनग्डाह पेसिस, पदिनगा नेङताङ. अगा जोक-जोक रेंड अजर्क पदिङ मताङ, अव गोह्‌ड पदिङ पया मेटा ओळ्सिये, मुटेङ-मुळ्गेङ आसोर वितिसि, सम्दुरता एतगा अर्सि, कतमे मुळ्न्दिस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","पया अव पदिङ मेहवालोर विततोर. वितिसि इद पोल्‍लोतुन सहरतगा ओसो एरे-गूरेताङ नाह्‌कनगा वेहतोर. वेहतस्के बाताल बाताल आता, तान ऊळलाहि अग्डा लोकुर येसुनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","वासि देयह्‌क पोस मतोग़ मन्कल बेस गेंदेङ केग़्सि, बेस बुदते मन्जि, येसुनगा उदिस मतोग़. इदिन ऊळिसि नाटेनोर येसुन रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","अगा येसु कीतद कबळतुन ऊळतोर मन्कलोर, ओग़ देयह्‌क पोयतोग़ु बेद्रम बेस आतोग़, ओसो पदिह्‌क बह आता, अद कतमे लोकुरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","अस्के, “निमा मयगा मनमा, मावा सिवातग्डाहि पेसिस अन” इनजोर, अग्डोर येसुन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","पया येसु अग्डाह दायलाह ओडातगा उदिह्‌पा, मुने देयह्‌क पोस मतोग़ मन्कल, “नाक नीवा संगे वायलाह ईम गूरु!” इनजोर अर्जि कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","मति येसु ओन तना संगे वायलाह एवोग़, मति इद्रम इतोग़ इतेके, “आयो, निमा नीवा लोन अन्जि, देवुळि नीवा पोग़ोन दया कीसि, नियेनाह्‌क बेद्रमता कबळ कीता, तान मियग्डोरिन वेहा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","अदिनेनाह्‌क ओग़ मन्कल अग्डाहि तना लोता एरियाते अन्जि, येसु तनेनाह्‌क कीतद बेरा कबळतुन, दाकपालिस पटटे पोकुर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","पया येसु तनाङ कग़यवालोरा संगे, ओडाते उदिस, सम्दुरतुन वेंडटापया, (गालिल पटटे मल्स वातोग़). येसु सम्दुर दडटगा एवतस्के, वेल्‍लाय मुल अगा ओनगा जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","अचोटेन ओर्वोग़ यारोस पेदिरतोग़ मन्कल येसुनगा वातोग़. ओग़ अग्डा यहुदिरा पार्तना कीयनद लोता ओर्वोग़ पेदामन्कल मतोग़. ओग़ येसुन ऊळिसि, ओनाङ काल्क अरतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अर्सि इद्रम इतोग़, “नावा उड्ला मयाळि डोललाह आता गूरु! अद सव्रेम आसि पिसि इनजोर, निमा वासि ताना पोग़ोन कय तासा,” इनजोर येसुन अर्जि कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","अदिनेनाह्‌क येसु ओग़ मुक्याना संगे दायलाह पेसतोग़. अनेके वेल्‍लाय मुलु येसुना पयाह अनजोर, गर्दि आसि ओनगा दोबेङ-नूकेङ कींदुर. ");
INSERT INTO mrr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","अस्के अद मुडगा उंद आंचाळ मता. अद बारा वर्सानाहि कुर्माते बादा आंदु. ");
INSERT INTO mrr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","अद मत एवालोरा कयदे पका तिपल आस मता, तनाङ पूरा कोताङ मत एवालोरिह्‌क ईसि, मारिह कीता. मति ताना बेमर मायो, इंका ओसो वीळसोर अंदु. ");
INSERT INTO mrr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","पया अद आंचाळि येसुना लोप्पा केंजिसि, नना मात्रम येसुना गेंदेतुन बोयतेक अचोन, सव्रेम आयकन इनजोर, आलिह कीता. कीसि, मुडा नडुम ओना पयाह वाता, वासि (अद पलते आस मताह्‌कु, सिरप) येसुना गेंदेतुन कुस्क्ने बोयता. ");
INSERT INTO mrr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","बोयताहे ताना कुर्माता बादा मायता, अद तना कुदि, नना सव्रेम आतन इनजोर पुता. ");
INSERT INTO mrr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","अस्के चट्‌नेन तना लावते बोग़ो मति सव्रेम आतोग़ इनजोर, येसु पुतोग़. पुन्जि, मुडेके चेट मिळ्न्दिसि, “नावा गेंदेतुन बोग़ बोयतोग़ रा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ओनाङ कग़यवालोर इतोर, “इद मुलु नीवा सर्ने मन्जि, नियके दोबेङ-नूकेङ कीयनदिन ऊळिह्‌निन! मति ‘नाक बोग़ बोयतोग़?’ इनजोर, बह इह्‌निन गूरु! (वेल्‍लाटोर नीक बोयिस मनदनुर,)” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","मति येसु तन्क बोयतदिन ऊळलाह, मुडगा सर्ने ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","अस्के अद आंचाळि, सव्रेम आतन इनजोर पुन्जि, येसुनगा वाता. वासि रेयते साङसोर येसुनाङ काल्क अरता. अर्सि पया तन्क बह बह आता, अद सबे ओन सेतेम-सेतेम वेहता. ");
INSERT INTO mrr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","वेहतस्के येसु तान इतोग़, “बायि! नना नीक सव्रे कीकन इन्जि, निमा विस्वस कीताह्‌के बेस आतिन, सुकमते अन. इंजेके इद बादा आयवालेवा पिसकिन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येसु इद्रम वेहनेकेन, यारोस पेदिरतोग़ मुक्याना लोताहि उच्वुर वासि, इद्रम ओन वेहतोर, “नीवा मयाळ हाता रा! इंजेके गूरु लोन वासाय बाताल पाय्दा, ओन मल्स लोहा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ओर मन्कलोर अद्रम इतदिन केंजवप लेह्‌का आसि, येसु यारोसिन इतोग़, “निमा रेयमा! नावा पोग़ोन विस्वस तासा!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","पया येसु मुडुन लेहचि, सिरप याकुब, योहन, वेर तमोग़ इर्वुर ओसो पत्रु, वेरिने पोसि, यारोसना लोतेके अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","अगा एवतस्के, अगा लोकुर अळयना, केयना कीसोर मतदिन, येसु ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","पया येसु लोप्पा ओळियिसि, ओरिन इतोग़, “बाराह्‌क रोदा पोस अळयह्‌निर? पिला हायो, अद निद्रते मन्ह्‌ता!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","अस्के पोहता वाता मुलु, येसु इतद पोल्‍लोतेनाह्‌क कवतोर. मति येसु सबेटोरिन पलते पेहचि, पिलाता तलोग़-तपेन ओसो तनाङ कग़यवालोर मुवुरिन पोसि, लोप्पा पिलातुन तासतगा अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अन्जि हाता पिलाता कयदुन पोसि, तमा पोल्‍लोते, “तलीता कूमि” (इतेके “अले पिला! नना नीक इह्‌नन, तेदा!” इनजोर अर्तम आस्ता) इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अद्रम इताहे, अद पिला चट्‌ने तेदता. अहे अद बारा वय्सता मताह्‌कु, इके-अके वेलिय बोटटा. इदिन ऊळिसि, अग्डा लोकुर पका बामतोर. ");
INSERT INTO mrr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","पया “इद पोल्‍लो बोन्के एर्का आयमाकि” इनजोर, येसु ओरिन उकुम इतोग़. अहे ओसो “तेन्क बातालाय तिनदलाह ईम्ह्‌टु,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","पया येसु अग्डाहि तना नासरेत नाग़ अतोग़, ओनाङ कग़यवालोर वने, ओना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","अन्जि वारमता पोल्वादियाते अग्डा पार्तनाता लोते काग़्हता बोटटोग़. वेल्‍लाटोर लोकुर ओनाङ पोल्‍लोन केंजिसि बयल आतोर, आसि इद्रम इतोर, “वेन्क इव पोल्‍लोङ, इचोटा बुदि, बेग्डाह दोर्कता रा? अचोटाङ बेराङ कबस्क कीयनद डीसा वेन्क बेग्डाह दोर्कता रा? बह वेग़ मरियाना मग़ि वड्लाल आयोग़ा? वेनाङ तमोर याकुबि,योसेपि, सिमोनि, यहुदाल वेर आयोर रा? वेनाङ सबे एलास्क बह इगाने इलेङ?” इन्जि नाटेनोर लोकुर येसुन नमोर आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","अस्के येसु ओरिन इतोग़, “देवुळता कबुरतोन्क दुनियामेंड मान दोर्किह्‌ता, मति कुदता नाटे, कुटुमते अहे लोते मात्रमि, मान दोर्को.(अद्रमलेह्‌काने नाक इंका मीट पास्कतिर,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ओर येसुन नमवाह्‌कु, अगा ओग़ वेल्‍लाङ डीसाताङ कबस्क कीया पग़वोग़. सिरप इच्वुरे बेमरतोरा पोग़ोन कय तासिसि, ओरिन सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","पया नाटेनोर येसुन नमवाह्‌कु, ओग़ बयल आतोग़. अहे पया येसु काग़्हचोरे, सबे एरे-गूरेताङ नाह्‌कने तिरियतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","उंद दिया येसु तनाङ बारा बळयिरिन केयतोग़, केयिसि इर्वुर-इर्वुरिन कीसि, ओरिन सेवातुह्‌क लोहतलाह तयर कीतोग़. कीसि मन्कलोरग्डाह देयह्‌किन पेसिह कीयलाह, ओरिह्‌क अदिकर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","पया ओरिन इद्रम उकुम ईतोग़, “मीट सेवाते दायह्‌पा, सिरप डुडटुन विळ्सिसि, गाटो, जोर्का, कोताङ इद्रम बाताङे ओयमाटु. ");
INSERT INTO mrr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","अहे ओसो एल्पुस्क केग़्स अन्ह्‌टु, मति रेंड-रेंड जगाङ-गेंदेङ ओयमाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ओसोवने इतोग़, “बेद लोतगा मीट दाकिर, अदे लोतगा मीट अद नाटे मनाह्‌जोम मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ओसो बेद नाटेनोर लोकुर मीक रोमलाह एवोर, मीवाङ केंजोर, अग्डाहि पेसना वेलाते, ओर देवुळता सिक्सातुह्‌क ओजिह्‌तोर इनजोर तोहतलाहि, मीवाङ काल्कना दुरातुन, अगाने दुल्पिसि पेसाटु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","अद्रमलेह्‌काने पया ओर सेवातुह्‌क अन्जि, पापमता अग़दाहि मल्सि, देवुळतके वाटु इनजोर, पोकुर कीसोर तिरियतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","अद्रम तिरियिह्‌पा, देयह्‌क पोस मतोर मन्कलोरग्डाह वेल्‍लाङे देयह्‌किन पेहतोर, अहे वेल्‍लाटोर बेमरतोरिन नेय ओकिसि पार्तना कीतोर, कीतस्के ओर सव्रेम आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","पया येसुना पेदिर वेल्‍लाय पोकुर आता, अस्के एरोद अंतिपस राजाल वने इद पोल्‍लोतुन केंजतोग़. उय्तुर “वेग़ येसु इतेके, देवुळता पेदिरते एग़ मीहवाल योहन आंदोग़, डोलिस जीवा अरतोग़. अदिनेनाह्‌क डीसाताङ कबस्क कीस्तोग़,” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","उय्तुर बार, “देवुळता कबुरतोग़ एलिया मुय्तोग़ ओसोवने वातोग़,” इंदुर. ओसो उय्तुर बार, “वेल्‍लाय मुने देवुळता कबुरतोर बोर मतोर, वेग़ अद्रमतोग़े,” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","मति एरोद राजाल वने येसु कीतव कबस्किन केंजिसि, इद्रम इतोग़, “योहनना तलातुन नना डाय वेहच मतन, ओग़े ओसो जीवा अरतोग़!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","बाराह्‌क इतेके, (योहनि, एरोद राजाल, वेरा नडुम कट्लाङ इह आस मताङ.) राजाना दादाल पिलिप इनवाल जीवात मनेकेने, वेना मुते, एरोदियसि इनदनदिन, राजाल तना लोन तच मतोग़. अदिनेनाह्‌क योहनि राजानगा अन्जि इतोग़, “नीवा दादाना मुतेन तासना, इद नीवा कीतद कबळ इतेके, मोसानाङ अडोङ वेहतपु पोलो, महरज,” इनजोर वेहच मतोग़. वेहताह्‌कु, राजाल ओङ आसि, योहनिन पोसि, जेलते वाटलाह वेहच मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","एरोदियसि इतेके, योहनना विरुद आसि, ओन हव्कलाह ऊळिंदु, मति हव्क पग़वो. ");
INSERT INTO mrr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","बाराह्‌क इतेके, योहनि सेतेमतोग़ ओसो देवुळता पवित्र मन्कल इनजोर, एरोद अंतिपस पुन्ज मतोग़. अदिनेनाह्‌क ओन रेयिंदोग़. योहनि राजाह्‌क वेहन्दोग़, अस्के राजाना जीवा चुहेम आयवेक तेला, योहनना पोल्‍लो केंजलाह गिर्दा आंदोग़. अदिह्‌क ओन एरोदियस रानिनग्डाहि पिसिह कीसि तासिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","पया एरोद राजाना पुटटा दिया एवता. अद दिया राजाल बेरोर मुक्यालोरिन, सीपय्किरा मुक्यालोरिन, गालिल पटटा बेरोर पेदल्किन केयिसि, कुळ्प कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","पया राजाल केयिस मता मुडा मुनेह, एरोदियसिना मयाळि एंदता. एंदतदिन ऊळिसि, राजाल ओसो कुळ्पतुह्‌क वाता मुलु, पका गिर्दा आतोर. पया राजाल गिर्दा आसि, अद पिलातुन इतोग़, “नीक बाताल गावले अद ताल्ह्‌का, अदिन नना ईकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अहे ओसो “नावा वळ्गा राजेम वने ताल्ह्‌कतेके, तान नना नीक ईकन” इन्जि, राजाल किरिया कीस वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","किरिया कीतस्के, अद पिला पलते अन्जि, “नना बाताल ताल्ह्‌ककन, अवा?” इनजोर तलिन ताल्ह्‌कता. अस्के ताना तलोग़ इता, “देवुळता पेदिरते एग़ मीहवाल योहनना तला ताल्ह्‌का,” इता. ");
INSERT INTO mrr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","इताहे अद पिला ओसो राजानगा वासि, “काका, योहनना तला उंदि दळ्याते कीसि, नाक इंजेकेन तच ईया वेहा,” इनजोर ताल्ह्‌कता. ");
INSERT INTO mrr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ताल्ह्‌कतस्के राजाल पका नारज आतोग़, मति राजाल केयिस मता मुडा मुनेह, किरिया कीस वेहताह्‌कु, अद पोल्‍लोतुन मिळ्हता पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","अदिनेनाह्‌क पया राजाल ओर्वोग़ सीपयिन, योहनना तला डायिस ततलाह, उकुम ईतोग़. ईतस्के ओग़ जेलतगा अन्जि, योहनना तलातुन डायतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","डायिसि उंद दळ्याते कीसि, अद पिलातुह्‌क तच ईतोर. अद पिला पया तना तलिनगा ओसीता. ");
INSERT INTO mrr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","पया इद कबुर केंजिसि, योहननाङ कग़यवालोर वातोर. वासि ओना सेत्तातुन ओस पोहतोर. अदिनेनाह्‌क राजाल येसुनु, योहनि मल्स जीवा अरतोग़ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","(पया येसुनाङ बळयिरनाग़-नाग़ तिरियसोर, सेवा कीसोर मलतोर.) मल्सि, येसुनगा जमा आतोर. आसि तमा बाताल बाताल कीतोर, ओसो काग़्हतोर, अदिन ओन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","अस्के वेल्‍लाटोर लोकुर ओरगा अनजोर वासोर मंदुर, अदिह्‌क ओरिह्‌क गाटो तिनदलाह वने अग़ दोर्को. अदिनेनाह्‌क येसु ओरिन इतोग़, “अलेट! माट बोरे लेवद जागातगा अन्जि, गळ्क रोमकल,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","पया ओर ओडाते उदिस, बोरे लेवद जागातगा तमाय आरम कीयलाह अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","मति ओर दायनदिन लोकुर ऊळतोर, ऊळिसि ओरिन पुतोर. पया सबे नाह्‌कनाहि, आस्क-कोय्तोर दडकचुलिय ताकसोरे, ओरिह्‌काय मुने सम्दुरता अबर बाजे एवतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","अस्के येसु ओसो ओनाङ कग़यवालोर वने एवतोर. एव्सि येसु ओडाताह रेगिसि, अगा वेल्‍लाय मुल जमा आतदिन ऊळतोग़. ओरु कोपाललेववु गोरेनलेह्‌का मतोर, तेन ऊळिसि येसुह्‌क ओरा मान वसता. पया येसु ओरिन वेल्‍लाङे पोल्‍लोङ काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","इद्रम काग़्हनेके, बह्‌ट अरता. पया कग़यवालोर येसुनगा वासि इतोर, “गूरु, इद पेळ्ह्‌कल जागा मन्ह्‌ता, इंजेक बह्‌ट अरता वने. ");
INSERT INTO mrr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","वेर मात्रमि एरे-गूरेताङ नाह्‌कनगा अन्जि, तम्क तिनदलाह बाताङाय असिर, वेरिन लोहा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","इतस्के येसु मर्ला ओरिन, “अले मीटे वेरिह्‌क तिंडटा बह कोट कीम्ह्‌ट रा!” इतोग़. इतस्के ओर इतोर, “गूरु, इचोन मुडुह्‌क तीहतलाह, आट नेलाना कूलताङ कोताङ आस्ताङ. अचोक कोतानाङ आरिङ असिस तीहतकोमा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","येसु इतोग़, “मियगा बेचोक आरिङ मन्ह्‌ताङ? अन्जि ऊळाट अले,” इतोग़. अन्ज ऊळतोर अस्के “एयुङ आरिङ, रेंड मीन्क मन्ह्‌ताङ,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","अस्के “अलेट! सबेटोरिन रोंडातगा गुमिङ-गुमिङ उदिह कीम्ह्‌ट,” इनजोर ओरिन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","अद्रमे लोकुर उंद-उंद गुमतगा, बेगा पनस, बेगा नूरु, इद्रम उदतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","पया लोकुर उदतस्के, अव एयुङ आरिन ओसो रेंड मीन्किन पोसि, पोग़ोन ऊळिसि, देवुळतुन जोहर कीसि, आरिन किळ्हतोग़. अह कीसि “मुडा लोकुरिह्‌क तूसिसीम्ह्‌ट,” इनजोर कग़यवालोरिन वेहतोग़. अद्रमे मीन्किन वने सबेटोरिह्‌क तूसिसीयलाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","पया वेर सबेटोर पका पंजनाह तितोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","तिन्ज-उन्ज पिसतव आर किळ्केङ, ओसो मीन्क जमा कीनेके, बारा डालाङ पेसताङ. ");
INSERT INTO mrr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","तिनवालोरगा सिरप कोय्तोरे एयुङ अजर्क (5000) मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","पया तिन्ज-उन्ज मारतस्के, येसु कग़यवालोरिन इतोग़, “नना लोकुरिन मल्स लोहतलाह पयाह मह्‌नन, मीट मात्रम ओडाते उदिसि, सम्दुरता अबर बाजे वेंडिसि, बेत्‍सेदा नाग़ अन्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","पया येसु लोकुरिन लोहचि, तना गुड्रापोग़ोन पार्तना कीयलाह अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","नुल्पेडुह्‌क ओडा सम्दुरता नडुमकसाते मता. येसु बार, वग़ोग़े दडटा अबरि गुड्रापोग़ोन मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","पया वळ्य मुनेहतेनाह वांदु, अदिनेनाह्‌क कग़यवालोर ओडातुन वग़्हचोर-वग़्हचोर बागिस मतोर, इदिन येसु गुड्राताहि ऊळतोग़. पया येसु नग़्काडाङ मूंड-नालुङ एगसोरे (इतेके तलाकोग़ कूसना जोक-जोक) सम्दुरता एता पोग़ोट्क ताकसोरे, ओरगा वातोग़. येसु ओरिन वीळिस दायना मता. ");
INSERT INTO mrr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","मति कग़यवालोर येसु एता पोग़ोट्क ताकनदिन ऊळिसि, “एता मसमि वास्ता, रा!” इनजोर सबेटोर रेयिसि केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","अस्के तोप्नेन येसु ओरिन आळो कीतोग़, “नना रा, रेयमाटु, दीरा कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","पया येसु ओरा संगे ओडातगा तग़्ङतोग़, तग़्ङतस्के वळ्यु बेके मायतायो, बेके मायोयो! इदिन ऊळिसि कग़यवालोर पका बामतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","बह इतेके येसु आरिङ तीहतदिन ऊळिस तेला, ओर ओना लावतुन पुनोर. तान पुनवाह, ओरा बुदि गळ्स आस मता. ");
INSERT INTO mrr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","पया ओर सम्दुरतुन वेंडिसि, गनेसरत एरियाते एवतोर. एव्सि ओडातुन दडटगा दोहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","येसु ओडातग्डाहि रेगताहे, अग्डोर ओन पुतोर. ");
INSERT INTO mrr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","पुताह्‌कु एरे-गूरेताङ सबे नाह्‌कने, कबुर वेहतलाह विततोर. पया मन्कलोर दुकिनोरिन कटुस्कने कांजिसि, येसु बेगा मन्ह्‌तोग़ इनजोर कबुर दोर्किंदु, अगा ओंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","येसु वेलियतोग़ अव सबे सहर्कनाङ, नाह्‌कनाङ, गूळानाङ बजर्कनगा दुकिनोरिन तासिसि, “गूरु, सिरप नीवा गेंदे कोङतुन मात्रम बोय ईम, अस्के बेस आयनुर,” इनजोर अर्जि कींदुर. बोर बोर ओना गेंदे कोङतुन बोयिंदुर, ओर सबेटोर सव्रेम आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","उंद दिया उच्वुर परुसिर ओसो सास्त्रमगूरुर येरुसलेम सहरताहि वातोर. वासि येसुनगा जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","अस्के येसुनाङ उच्वुर कग़यवालोर, कय्क नोग़वाये गाटो तिनदनदिन, वेर ऊळतोर.(वेरा विचरते, येसुनाङ कग़यवालोर कळ्‍वोग़कय्किन एडिह केवाये तिंदुर). ( ");
INSERT INTO mrr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","परुसिर ओसो सबेटोर यहुदिर, तमाङ तादोर-बाबोर कीतव रीत-रिवज्कना इसबते, बेस कय्क नोग़वा, मुर्तिय गाटो तिनोर आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","आटुमताहि वातस्के, एग़ मीवालेवा गाटो तिनोर आंदुर. मुनेतोर कीतव रीत-रिवज्कना इसबते, दळ्यान, एग़ उनडनाङ कस्लान, इतुळताङ गंजिन तोमिंदुर. इद्रमलेह्‌का वेल्‍लाङे रीत-रिवज्किन नोमिंदुर.) ");
INSERT INTO mrr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","अदिनेनाह्‌क परुसिर ओसो सास्त्रमगूरुर येसुनगा वासि इतोर, “नीवाङ कग़यवालोर मावाङ पेदल्कना मतद रीत-रिवजतुन बह माळोर? वेर तिनदनामुने, कळ्‍वोग़ आतदिन एडलाह, तमाङ कय्क बाराह्‌क नोग़वोर?” इन्जि कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","पया येसु ओरिन इतोग़, “मीट सोङ केवालोरा लोप्पा, देवुळि मुने तना कबुरतोग़ यसयाल इनवाना मेटे, सास्त्रमते मीवा लोप्पा बराबर वेहच मता: ‘वेर लोकुर तमा तोडटेने, नाक मान ईस्तोर, मति वेर नावा पोग़ोन जीवा वाटोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","वेरा मोळ्कनद वने जोलिय मन्ह्‌ता, नावा सास्त्रम काग़्हतनदिन विळ्सिसि, तमाङे अडोङ काग़्हतह्‌तोर,’ इनजोर वेहता. ");
INSERT INTO mrr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","मीट देवुळताङ अडोन माळना विळ्सिसि, मन्कलोर कीतव अडोन माळिह्‌निर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ओसो इतोग़, “मीट मीवाङ मुनेताङ रीत-रिवजतुन नोमसोरे, देवुळताङ अडोन माळवा, बह तपतिर? ");
INSERT INTO mrr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","इद केंजाटु, मीवा उंद तप नना वेहतह्‌नन. निमा नीवा तलोग़-तपेह्‌क मान ईम, इद्रम सास्त्रमते देवुळता कबुरतोग़ मोसाल वेहतोग़. ओसो बोग़ तना तलोग़-तपेह्‌क मान एवा, ओरा कदर रेहतह्‌तोग़, ओन हव्कना सिक्सा ईयना, इह वने वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","मति मीट मात्रम इद्रम इह्‌निर इतेके, बोग़ाय तना तलोग़-तपेना पिसवग़तुह्‌क एवालेवा, देवुळतुह्‌क वाटटेके बेसु, इह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","इद्रमलेह्‌का मन्कल तना तलोग़-तपेन अय केवोग़ आस्तोग़. मीट इद्रम काग़्हचि, ओरिन अय कीयलाह एविर. ");
INSERT INTO mrr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","इद्रम मीट मीवाङे रीत-रिवज्क पुटिह कीसोरे, देवुळता पोल्‍लोतुन माय्‍पिह कीतिर. इद्रमताङ वेल्‍लाङे कबस्क कीय्ह्‌निर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","अस्के येसु लोकुरिन तनके केयिसि ओरिन इतोग़, “नना इंजेके बार इह्‌नन, तेन सबेटोरिर केंजिसि कग़याटु. ");
INSERT INTO mrr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","(कय्क नोग़तेकाय, नोग़वेकाय,) बेद मन्कना कुमतगा दास्ता, अद ओन देवुळता मुनेह कळ्‍वोग़ केवो. मति मन्कना पोटाताहि, बेव पोल्‍लोङ तोडटुह्‌क पलते पेसिह्‌ताङ, अवे ओन कळ्‍वोग़ कीस्ताङ.  ");
INSERT INTO mrr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","बोन्क पुनदलाह गिर्दा मन्ह्‌ता, ओग़ बेस केंजेग़.” ");
INSERT INTO mrr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","पया येसु मुडुन लोहचि, तना मतद लोन अतोग़. अतस्के ओनाङ कग़यवालोर ओनगा वासि, “कळ्‍वोग़ता पुन्पिह कीयनद पोल्‍लोतुन, माक तेळियिह कीस वेहा, गूरु,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","येसु ओरिन इतोग़, “मीकाय इंका तेळियोया? बेद मन्कना कुमतगा दास्ता, अद ओन कळ्‍वोग़ केवो. ");
INSERT INTO mrr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","बाराह्‌क इतेके, मन्कल तिनदनद ओना जीवातगा अनो, मति कुमतगा दास्ता, पया पेल्कतेके पेसिह्‌ता, पुनविर?” इतोग़. (इद्रम इन्जि, सबे तिंडि तिनदलाह पोलिह्‌ता इतोग़.) ");
INSERT INTO mrr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","इन्जि ओसो इतोग़, “मति मन्कनाहि पलत पेसनव सबे लाग्वाङ पोल्‍लोङ, अवु पोटालोप्पाडाहि वास्ताङ. अविनेनाह्‌के मन्कन देवुळि जेक तासिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","बाराह्‌क इतेके लाग्वाङ विचर्कु, साट्याल कबळ, कले कबळ, हव्कनदु, सिंड्रि-पोह्‌डेङ कीयनदु, लालुस कीयनदु, कोंटे बुदि, नाळेह कीयनद बुदि, लजालेवव करब कबस्क, कुळ्सा बुदि, वह्‌चळि, पोमाडेङ कीयनदु, तेल्वलेवव कबस्क, इव सबे मन्कना पोटालोप्पाडाहिये पलत पेसिह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","इद्रमताङ सबे लाग्वव पोल्‍लोङ कोनि, लोप्पाडाहि पेसिसि, मन्कनु कळ्‍वोग़ कीस्ताङ,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","गालिल पटटाहि पेसिस पया, येसु तनाङ कग़यवालोरा संगे सोर-सिदोन एरियाते वातोग़. वासि उंद लोतगा मतोग़. नाक बोरे पुनमाकिर इनजोर, ओग़ विचर कीस मतोग़, मति इद पोल्‍लो आबुर आता. ");
INSERT INTO mrr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","अद नाटे उंद सुरिया पटटा पिनिके एरियाता आंचाळ मता, अद यहुदि आयवद आंदु. ताना उड्ला मयानु, देयम पोस मता. पया अद आंचाळि येसु वातोग़ इनजोर केंजिसि, ओनगा वाता. वासि ओनाङ काल्क मोळ्कता. अह कीसि, “नावा मयानग्डाह देयमतुन पेसिह कीम, सामि!” इनजोर येसुन अर्जि कीता. ");
INSERT INTO mrr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","अस्के (इस्रयेलतोरिन सव्रे कीयलाह येसुनगा बेद लाव मता, अदु दुस्राङ जातिनोरिह्‌कओजो, इदिन तोहतलाह) येसु तान इतोग़, “मुने पेकोर पंजिर, बाराह्‌क इतेके पेकोराङ आरिनु, लोताङ नय्किह्‌क वाटिसीयनद बेस आयो,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","इतस्के अद येसुन इता, “नीवा पोल्‍लो निटमे मन्ह्‌ता, सामि. मति पेकोर तिनदनाङ दळ्यानाहि पोवताङ पेसावार्किनु, लोताङ नय्के तिन्ह्‌ताङ,” इता. ");
INSERT INTO mrr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","पया येसु तान इतोग़, “निमा नावा पोग़ोन विस्वस कीतिन इनजोर, निमा इतद पोल्‍लोतुन केंजिस पुतन. अदिह्‌क लोन अन! देयमि नीवा मयान विळ्सिस वितता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","अस्के अद आंचाळि लोन वासि, पिला कटुदगा उंजिस मतदिन, ओसो देयम वने विळ्सिस मतदिन ऊळता. ");
INSERT INTO mrr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","पया येसु तनाङ कग़यवालोरा संगे सोर-सिदोन एरियाताहि पेसतोग़. पेसिसि दाकपालिस पटटगाह्‌क वासि, गालिल सम्दुरकचुल एवतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","अचोटेन उच्वुर मन्कलोर ओर्वोग़ एव्डान येसुनगा ततोर, ओग़ बोब्‍ळे वने मतोग़े. तचि “नीवा कयदुन वेना पोग़ोन तासिसि, वेन सव्रे कीम, गूरु!” इनजोर येसुन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","कीतस्के, येसु ओग़ मन्कन मुडग्डाहि उचुन अबर केयतोग़. केयिसि, तनाङ वळ्स्किन ओनाङ केव्कनगा तोग़्किस तेंडटोग़. ओसो तनाङ वळ्स्कनगा उस्किसि, ओना वेंजेटुन बोयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अह कीसि पोग़ोन ऊळिसि अंजिस नेस्कतोग़, नेस्किसि ओग़ मन्कन तमा पोल्‍लोते “इप्पता!” इतोग़. (इप्पता इतेके “पङ्ने आम” इद्रम अर्तम आस्ता.) ");
INSERT INTO mrr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","पया येसु अद्रम इताहे, ओग़ मन्कनाङ केव्क पङ्ने आताङ, ओसो ओना वेंजेग़ वने बेस आता, ओग़ पया पङ्ने वळ्ह्‌क बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","अगा मतोरिन इद पोल्‍लोतुन बोरिह्‌के वेहमाट इनजोर, येसु ओरिन उकुम ईतोग़. मति ओग़ बेचोन वेहमाट इनजोर वेहतोग़, अचोन ओर मन्कलोर अद पोल्‍लोतुन पोकुर कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","पया लोकुर पका बामिसि इद्रम इंदुर, “येसु बेद कीतोग़, अद सबे बेस-नेह्‌ना कीतोग़; एव्डालोरिह्‌क वेनदनदु, मूकालोरिह्‌क वळ्ह्‌कनद लाव ईस्तोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","अद्रमे पया उंद दिया ओसोवने येसुनगा वेल्‍लाय मुल जमा आतोर. ओरगा तिनदलाह बाताले इलवा मता. अस्के येसु तनाङ कग़यवालोरिन केयिसि इद्रम इतोग़, ");
INSERT INTO mrr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“वेर नयगान मन्जि, नेटुह्‌क मूंड दियाङ आतोर, वेरगा तिनदलाह बातय इले. अदिह्‌क नाक वेरा मान वसिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","वेरग्डाह बोर बोर वेल्‍ला जेकनाहि वातोर मन्ह्‌तोर. नना वेरिन अहे तमाङ लोह्‌कने लोहतेके, वेर अग़दे अनेके, कग़्विह्‌क ऊंगेङ-वेळ्केङ आयनुर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","पया कग़यवालोर येसुन इतोर, “अलाले, वेर लोकुर पंजलाहि, इद पेळ्ह्‌कल जागाते तिंडि बेग्डाह बोग़ तचीयनोग़?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","अस्के “मियगा बेचोक आरिङ मन्ह्‌ताङ?” इन्जि येसु ओरिन ताल्ह्‌कतोग़. “अविय! मयगा इतेके एळुङे आरिङ मन्ह्‌ताङ,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","पया येसु मुडुन उद वेहचि, अव एळुङ आरिन पोसि, देवुळतुन जोहर कीसि, आरिन किळ्हतोग़. किळ्हचि, मुडुह्‌क तूसिसीयलाह तनाङ कग़यवालोरिह्‌क ईतोग़, ओर पया मुडुह्‌क तूसतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ओरगा उचुक उड्लाङ मीन्क वने मताङ. अविस्कनेनाह वने देवुळतुन येसु जोहर कीसि, लोकुरिह्‌क तूसिसीयलाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","पया लोकुर पंजनाह तितोर. तिन्जि पिसतव आर किळ्केने, एळुङ बेराङ डालाङ निंदताङ. ");
INSERT INTO mrr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अगा तितोर लोकुर जोक-जोक नालुङ अजर्क (4000) लेह्‌का मतोर. पया येसु सबेटोरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","लोहचि येसु तनाङ कग़यवालोरा संगे ओडाते उदिसि, दलमनुता इनदनद एरियाते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","पया अगा उच्वुर परुसिर वातोर, वासि येसुना संगे पोल्‍लोने गिटोगटो कीसोरे, “देवुळ नीक लोहता इन्जि, माक उंदि सीना तोहा,” इनजोरे येसुना पट ऊळलाहि ओन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","इद पोल्‍लोतुह्‌क येसु नारज आसि अंजिस नेस्कतोग़, पया “इद पीळतोरु बाराह्‌क सीना ताल्ह्‌किह्‌तोर? केंजाट, नना सेतेम वेहतह्‌नन, इद पीळतोर लोकुरिह्‌कु बेदे सीना तोहोन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","पया येसु परुसिरिन विळ्सिसि, तनाङ कग़यवालोरा संगे ओडातगा उदिसि, सम्दुरतुन वेंडलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","वेंडनेके कग़यवालोर आरिङ ततलाह माग़्ङतोर. ओडाते दायह्‌पा, ओरगा उंदिय आरि मता. ");
INSERT INTO mrr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","अस्के येसु ओरिन इतोग़, “केंजाट! परुसिर ओसो एरोद अंतिपस, वेरा ओयता पिंडटा लोप्पा उसरते मन्ह्‌टु, ताना अग़दुह्‌क आयमाट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","इतस्के “मयगा आरिङ लेवाह्‌के बहे, गूरु माक वेहतह्‌तोग़,” इन्जि तमतमाय वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","तेन पुन्जि येसु इतोग़, “मीट आरिङ इलवाह्‌कु, बाराह्‌क इचोन आलिह कीय्ह्‌निर? नाकु आरिना पर्वा इले इन्जि, मीक इंका तेळियोया? बह मीवा बुदि अचोन गळ्स आताया, नावा लोप्पा इंका पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","(नना कीतव कबस्किन ऊळतिर;)कोंडाङ मन्ज वने मीक दिसो? केव्क मन्ज वने केंजविर? बह मीक सीता इलेया? ");
INSERT INTO mrr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","मुने नना एयुङ आरिने एयुङ अजर्क (5000) लोकुरिह्‌क तीहतन, अस्के पिसतव बेचोक डालाङ गुम कीतिर?” इतोग़. ओर इतोर, “बारा डालाङ गुम कीतोम गूरु,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","येसु ओसो इतोग़, “अहे ओसो एळुङ आरिने नालुङ अजर्क (4000) लोकुरिह्‌क तीहतन. अस्के मीट बेचोक डालाङ आरिङ गुम कीस मतिर?” इतोग़. ओर येसुन इतोर, “एळुङ डालाङ गुम कीस मतोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","इतस्के येसु ओरिन इतोग़, “बह इंजेक वने नना बोनन इन्जि मीक तेळियोया? (इंका वन नाक विस्वस केविरा?)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","अद्रमे पया येसु बेत्‍सेदा नाटेनगा वातोग़. वातस्के नाटेनोर ओर्वोग़ गुडिनु येसुनगा ततोर. तचि “वेग़ तोवनाह, वेनाङ कोंडान इटा गूरु,” इनजोर अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","इतस्के येसु ओग़ तोववोना कयदुन पोसि, लोह्‌क लेवगा ओतोग़. ओसि ओनाङ कोंडानगा उस्किसि, ओना पोग़ोन कय तासतोग़. तासिसि “बातालाय दिसिह्‌ताया?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","अस्के ओग़ केनकेने तोव्सि इतोग़, “नाक मन्कलोर मराना लेह्‌का बग़ाङ-बग़ाङ दिसिह्‌तोर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","इतस्के येसु ओसोवने तना कय, ओनाङ कोंडानगा तासतोग़. तासतस्के ओग़ ओसो नाह्‌किस ऊळतोग़. अस्के पूरा सव्रेम आसि, ओग़ मुनेता लेह्‌काने सबे पोळ्क्ने तोवया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","पया येसु ओन इतोग़, “इंजेके निमा लोन अन! मति इद नाटेना लोप्पाड्‌क अनमा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","पया येसु तनाङ कग़यवालोरा संगे, केसरिया-पिलिपि इनदनद सहरता एरेताङ नाह्‌कने अतोग़. दायह्‌पा तनाङ कग़यवालोरिन “नना बोनन आंदन इनजोर, लोकुर इन्ह्‌तोर?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","अस्के “उय्तुर बार नीक एग़ मीहवाल योहन इन्ह्‌तोर; उय्तुर बार देवुळता कबुरतोग़ एलियाल आंदोग़; उय्तुर बार मुनेतोग़ बोग़ो देवुळता कबुरतोग़ मनदनोग़ इन्ह्‌तोर” इनजोर कग़यवालोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","इतस्के येसु ओरिन, “अले पया मीट वेहाट, नाक बोग़ इनजोर मीट इह्‌निर?” इनजोर ताल्ह्‌कतोग़. ताल्ह्‌कतस्के “सामि, निमा देवुळ लोहतोग़ पिसिह केवाल किर्स्तुनिन आंदिन,” इनजोर पत्रु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","इदिन केंजिसि, “नना किर्स्तुनन इनजोर, मीट इंजेके बोने वेहमाट बहा,” इनजोर ओरिन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","पया येसु तनाङ कग़यवालोरिन इद्रम काग़्हता बोटटोग़, “मान्वना नडुम पुटटोन्कु, इतेके नाकु, पका तिपल आयनद मन्ह्‌ता. यहुदिराङ पेदल्कु, पेर्मालोर, सास्त्रमगूरुर नाक पास्कनुर, हव्कनुर, ताना पया मूंड दियाने नना तेग़्ककन, इव करल अद्रम आयनुङे!” ");
INSERT INTO mrr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","इनजोरे येसु इद पोल्‍लोतुन, ओरिह्‌क बेस तेळियनाह वेहतोग़. इद्रम वेहतस्के, पत्रु येसुन बाजेते अबर ओसि, (“गूरु, निमा अद्रम विचरे केमा” इन्जि,) येसुना वेहतद पोल्‍लोता अडम वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","अस्के येसु पेग़्के मिळ्न्दिस कग़यवालोरिन ऊळतोग़, ऊळिसि पत्रुन इद्रम तेर्हतोग़, “एय देयमदीपता बुदते वळ्ह्‌कवानिन, अद्रमता बुदतुन पोहचीम! नीवा विचरि मन्कना विचरतेह मन्ह्‌ता, मति देवुळता विचरतके इले,” इनजोर तेर्हतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","पया येसु तनाङ कग़यवालोरिन, ओसो अगा जमा आता मुडुन, तना एरे केयिसि इद्रम इतोग़, “बोग़ाय नावाङ कग़यलाह वायना विचर कीतेके, ओग़ तना हव्कनागुटा कांजतप, नयेनाह्‌क वायनव तिपल्किन आपेग़. ओसो तनाय कुसितुन पोहचि, नावा अग़दे ताकेग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","बोग़ इद बूमते तना कुदता जीवातुन पिसिह कीयलाह ऊळिह्‌तोग़, ओग़ आक्रिते बूळेम आयनोग़. मति बोग़ नावा बेसता कबुरतुन पोकुर कीयलाह सबे पोहतह्‌तोग़, ओन्क देवुळि पूना जीवा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","मन्कल पूरा दुनियातुन गेल्सतेक तेला मति, तना कुदता जीवातुन पिववद किसबटटगा लेसिह कीतोग़ इतेके, ओन्क बाताल पाय्दा आयग़ा? ");
INSERT INTO mrr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","मन्कल तना जीवातुन लेसिह कीतोग़ इतेके, ताना बद्लातुह्‌क ओग़ बातय ईया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","सिंड्रि आंचाळ तना मुजोन नाळेह कीयना लेह्‌कान, इद पीळतोर मन्कलोर देवुळतुन नाळेह कीसि, पापमते ताकिह्‌तोर. अद्रमतोरा नडुमि बोग़ु नना येसुनाङ कग़यवानन इनदलाह, पेग़्के-मुनेह आस्तोग़, ओनु नना मान्वना नडुम पुटटोनन वने जेक तासकन. ओसो बेद दिया नना नावा बाबाना डीसाते, पवित्र देवतुल्कना संगे वायकन, अस्के अद्रमतोग़ मन्कन मावोग़ इनदलाहि, पेग़्के-मुनेह आयकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","येसु ओसो ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मियग्डाहि उय्तुर नावा संगे मनवालोरिर, हायनामुनेन देवुळि तना लावते राजेम निल्पिह कीयनदिन मीट ऊळकिर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","आरुङ दियाङ आतापया, पत्रु, याकुबि, योहनि, वेर मुवुरिन येसु तना संगे पोसि अलग उंद बेरा मेटापोग़ोन ओतोग़. अगा अतस्के ओर ऊळनेके, ओना रूप मिळ्न्दता. ");
INSERT INTO mrr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ओनाङ गेंदेङ इचोन वेडिसि तिर्मिळ्स्किंदुङ इतेके, इद दुनियाते बोग़े गेंदेङ उकवाल वने अचोन वेडिह कीया पग़वोग़, अचोन वेडिस मताङ. ");
INSERT INTO mrr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","अस्के मोसा मुय्तोग़, एलिया मुय्तोग़, वेर इर्वुर मुनेतोर देवुळता कबुरतोर, येसुना संगे वळ्ह्‌कनदिन ओर ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","ऊळिसि पत्रु, याकुबि, योहनि, वेर पका रेयतोर, पया पत्रु, “सामि, माट इगा मह्‌नल इतेके बेस आता, माट इगा मूंड मंडाङ पंडकोम: उंदि नियेनाह्‌कु, उंदि मोसा मुय्तोनेनाह्‌कु, उंदि एलिया मुय्तोनेनाह्‌कु,” इतोग़. इव पोल्‍लोङ पत्रु बाताल वळ्ह्‌किंदोग़, अद तना तन्के तेळियो. ");
INSERT INTO mrr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","अद्रम इनेकेने, ओरा पोग़ोन मोयुल वासि ओरिन मुचता, मुचतस्के अद मोयुलताहि उंदि इद्रमता लेङ केंज वाता, “वेग़ नावा जीवा कीतोग़ मग़ि आंदोग़, वेनाङे मीट केंजसोर मन्ह्‌टु,” इता. ");
INSERT INTO mrr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","पया चट्‌नेन वेर मुवुर इके-अके ऊळतोर, मति अगा तमा संगे येसुन विळ्सिस बोग़े बह दिसोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","पया मेटाताहि रेगनेके, वेर मुवुरिन येसु उकुम ईस वेहतोग़, “माने-मन्कना नडुम पुटटोनन डोलिस मन्जि ओसो तेग़्कनाह्‌जोम, मीट नेंड बेद ऊळतिर, तान बोन्के बह वेहमाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","इतस्के ओर अद पोल्‍लोतुन सीतात तासतोर, मति डोलिस मन्जि ओसो तेग़्कनदिना अर्तम बाताल आस्ता इनजोर, तमतमाय वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","पया ओर येसुन ताल्ह्‌कतोर, “गूरु! देवुळ लोहवाल पिसिह केवाल वायनामुनेने, इद बूमते एलिया मुय्तोग़ मल्स वायनोग़ इनजोर,सास्त्रमगूरुर इन्ह्‌तोर. अद्रम बाराह्‌क इन्ह्‌तोर?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","येसु ओरिन इतोग़, “देवुळ लोहवाल पिसिह केवाल वायनामुने, एलियाल वासि सबेटविन बेस ओप्पे कीयलाह वास्तोग़ निटमे! अद्रम आस पया, ‘माने-मन्कना नडुम पुटटोनु लोकुर पास्कनुर, ओन्कु पका तिपल एताय पोयग़ा,’ इनजोर वने रासतद मन्ह्‌ता, इद बेद्रमि? ");
INSERT INTO mrr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","मति नना मीक वेहतह्‌नन, एलियाल इतेके वातोग़े, तेला मति सास्त्रमतगा ओना लोप्पा रासतप लेह्‌कान, तम्क बह विचर वाता, अहे लोकुर ओनु तिपल कीतोर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","अद्रमे ओर नालवुर आसि मेटाताहि रेगिसि, दुस्रोर कग़यवालोरगा वातोर. वासि ऊळनेके, ओरगा वेल्‍लाय मुल जमा आस मतोर, ओसो सास्त्रमगूरुर ओरा संगे गिटोगटो आंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","अस्के येसु वायनदिन ऊळिसि, सबेटोर बामतोर. बामिसि ओनगा वितिस मन्जि जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","पया येसु तनाङ कग़यवालोरिन ताल्ह्‌कतोग़, “ओरा संगे मीट बेदिनेनाह्‌क गिटोगटो आतिर?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","अस्के मुडाहि ओर्वोग़ मन्कल इद्रम इतोग़, “गूरु! निमा नावा मग़िन सव्रे कीकिन इनजोर, नना नियगा ओन ततन. ओन देयम पोयता, अदिह्‌क ओग़ वळ्ह्‌क पुनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","अद ओन पोयतेक अचोन नेल उकिह्‌ता. अस्के ओना तोडटुह्‌क बोमुल पेसिह्‌ता, पल्क वने कोग़्किह्‌तोग़ ओसो मेग़्किह्‌तोग़. इद देयमतुन पेहतलाह, नीवाङ कग़यवालोरिन वेहतन, मति ओरा संगे आया पग़वो,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","अस्के येसु इतोग़, “ए विस्वसलेवोरिर, मीवा संगे बेचानाह नना मनदकन! मियेनाह्‌क नाक कयर वास्ता. अले ओग़ पेकान नयके ताट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","इतस्के ओग़ पेकान ओनगा ततोर, ततस्के देयम येसुन ऊळताहे, ओग़ पेकान तेल्हचि नेल अर्हचीता. पया ओग़ तोडटुह्‌क बोमुल पेहचोरे दोळ्गिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","येसु पेकाना तपेन ताल्ह्‌कतोग़, “वेग़ बेस्केडाह इद्रम आस्तोग़?” इतोग़. इतस्के पेकाना तपे इतोग़, “उड्लस्केडाहिये पोयता गूरु. ");
INSERT INTO mrr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","इद देयम वेना जीवा तिनदलाह, बेस्के किसतगा, बेस्के एतगा अर्हचीस्ता. मति निमा बेदाय कीया पग़तेके, माक जीवा लोपिसि, मावा पोग़ोन दया कीम,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","येसु ओन इतोग़, “‘निमा बेदाय कीया पग़तेके कीम’ इनजोर बाराह्‌क इह्‌निन? देवुळतुन विस्वस केवाल मन्कह्‌क, सबे आया पग़यह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","अस्केने ओग़ पेकाना तपे, “सामि, नना विस्वस कीय्ह्‌नने, मति इंका पका विस्वस कीयनाह, नाक तोळ ईम,” इनजोर केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","पया लोकुर वित वासि, अगा जमा आयनदिन येसु ऊळतोग़. ऊळिसि “एय वेग़ पेकान एव्डाल, मूकाल कीतद देयमतिन, नना नीक उकुम ईय्ह्‌नन, वेग़ पेकानाहि पेसिस अन. ओसो वेनगा बेस्केन मल्स वामा,” इनजोर दगा ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ईतस्के देयम केयिसि, ओग़ पेकान पका तेल्हचि पेसता. पेसतस्के पेकाल डोलतप लेह्‌का आतोग़, वेल्‍लाटोर लोकुर डोलतोग़ इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","मति येसु ओना कयदुन पोसि तेहच निल्पिह कीतोग़. अस्के ओग़ पेकाल नितोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","पया येसु तनाङ कग़यवालोरा संगे तमा मनदनद जागातगा वातोग़, वातस्के बोरे लेवस्के कग़यवालोर येसुनगा वासि ताल्ह्‌कतोर, “माट अद देयमतुन बह पूंड पग़वोम गूरु?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","इतस्के येसु ओरिन इतोग़, “देवुळतुन पार्तना कीतेकेने, इद्रमताङ देयह्‌किन पूंड पग़मुळ आस्ता, केवेके पूंड पग़मुळ आयो,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","अद्रमे पया येसु ओसो ओनाङ कग़यवालोर, अद जागातुन विळ्सिसि अतोर. अनेके ओर गालिल पटटुह्‌क अतोर. दायह्‌पा, (तनाङ कग़यवालोरिन अलग काग़्हतना मताह्‌कु,) तमा दायनद पोल्‍लो बोरिह्‌के तेळियना आयो, इद्रम येसुना विचर मता. पया येसु तनाङ कग़यवालोरिन इतोग़, “माने-मन्कना नडुम पुटटोनन, नाकु कोंटेतोरा कयदे पोसीयना मन्ह्‌ता. ओर नाक हव्कनुर, मति नना मूंड दियाने ओसो जीवा अरयकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","मति येसु वेहतद पोल्‍लो ओरिह्‌क तेळियो. अद पोल्‍लोतेनाह्‌क ओन ताल्ह्‌कलाह वने ओर रेयिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","अद्रमे पया ओर कापेर्नाग़ वातोर, वासि तमा जागातगा अतोर. अतस्के येसु ओरिन ताल्ह्‌कतोग़, “अग़दे वानेके बाताङ कट्लाङ आंदिर?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","मति “माट बारा मन्कलोरग्डाहि सबेटोरिह्‌क बेरोग़ बोग़,” इनजोर, ओर अग़दे वानेके कट्लाङ आस मतोर; अदिनेनाह्‌क ओर बाताले वळ्ह्‌कवा, केमेन आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","पया येसु उदतोग़, उदिसि बारा बळयिरिन तना एरे केयिसि, इद्रम इतोग़, “बोग़ाय सबेटोरिह्‌क बेरोग़ आयलाह ऊळिह्‌तोग़, ओग़ बुदते सबेटोरिह्‌क उड्लोग़ आयेग़, ओसो सबेटोरा सेवा केवाल आयेग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","इन्जि ओर्वोग़ उड्लोग़ पेकान तचि, ओरा नडुम निल्पिह कीतोग़. पया ओन ओग़्ङिसि, ओरिन इतोग़, ");
INSERT INTO mrr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“बोग़ु इद्रमतोग़ ओर्वोग़ उड्लोग़ पेकानाय, नावा पेदिरते एरे कीस्तोग़, ओग़ नाके एरे कीतपे. ओसो बोग़ु नाक एरे कीस्तोग़, ओग़ सिरप नाके आयो, मति नाक लोहतोन वने एरे कीस्तोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","इतस्के योहन येसुन इतोग़, “गूरु, नीवा पेदिरते ओर्वोग़ मन्कल, देयह्‌किन पेसिह कीयह्‌पा माटु ऊळतोम. ओग़ मावा तोळतोग़ आयवाह्‌कु, माट ओन रोमिह कीतोम,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","इतस्के येसु इतोग़, “बोग़े देवुळता लावताङ कबस्क नावा पेदिरते कीतस्के, नावा अडम वळ्ह्‌क पग़वोग़. ओन मीट रोमिह केमाटु. ");
INSERT INTO mrr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","बह इतेके बोग़ माक विरुद केवोग़, ओग़ मावोग़े आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","इह केंजाट, नना सेतेम वेहतह्‌नन, मीट किर्स्तुनाङ कग़यवालोरिर इन्जि, उंद गिलसमेंड एग़तेला उनडलाह बोर ईयनुर, ओरिह्‌क इद दर्ममता पाय्दा देवुळताहि निटमे दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“उड्लोर पेकोरा लेह्‌का नाक नमवालोरग्डाहि बोनाय वग़ोनु, ओना नयगा मतद विस्वसतुन विळ्सलाहि, बोग़ कटळ वाटटप आस्तोग़, (वेग़ कटळ वाटवाल देवुळता बेरा सिक्सातुह्‌कु ओजनोग़). वेना वेळेटगा पका पूहतद जेता बंडातुन दोहचि, वेन सम्दुरते वेल्‍लाह आता कसातगा मुळ्हतना, (इद बेरा सिक्सा आंदु; मति) तान्काय वीळिस बेरा सिक्सा देवुळि अद्रम कटळ वाटवाह्‌क ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","केंजाट, निमा नीवा कयदे पापम कीयलाह ऊळिह्‌निन इतेके, कयदुन बोग़ाय डायिस पोहचीतेक बेस आवालि, (इद्रम निमा पापमतुन पोहतलाह जिद कीमु). बाराह्‌क इतेके नीवाङ रेंड कय्क मन्जि, देयमदीपता बेस्केन पिववद किसबटटा अमेसाता सिक्सातगा दायना वाटो, कोलाल आसि अमेसाता पिसमुळते दायना, इदे नीक पाय्दाता. ");
INSERT INTO mrr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","देयमदीपतग्डाङ पुळ्क बेस्केन डोलोङ, ओसो अग्डा किसु बेस्केन पिववो. ");
INSERT INTO mrr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अहे निमा नीवा कादे पापम कीयलाह ऊळिह्‌निन इतेके, कादुन बोग़ाय डायिस पोहचीतेक बेस आवालि, (इद्रम निमा पापमतुन पोहतलाह जिद कीमु). ");
INSERT INTO mrr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","बाराह्‌क इतेके नीवाङ रेंड काल्क मन्जि, देयमदीपता अमेसाता सिक्सातगा दायना वाटो, कूटाल आसि अमेसाता पिसमुळते दायना, इदे नीक पाय्दाता. देयमदीपतग्डाङ पुळ्क बेस्केन डोलोङ, ओसो अग्डा किसु बेस्केन पिववो. ");
INSERT INTO mrr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ओसो निमा नीवा कोंडाते पापम कीयलाह ऊळिह्‌निन इतेके, कोंडातुन बोग़ाय पेग़्हचीतेक बेस आवालि, (इद्रम निमा पापमतुन पोहतलाह जिद कीमु). बाराह्‌क इतेके नीवाङ रेंड कोंडाङ मन्जि, निमा देयमदीपता अमेसाता सिक्सातगा दायना वाटो, उंदिय कोंडा मन्जि देवुळता राजेमते ओळियना, इदे नीक पाय्दाता. ");
INSERT INTO mrr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","देयमदीपतग्डाङ पुळ्क बेस्केन डोलोङ, ओसो अग्डा किस बेस्केन पिववो. ");
INSERT INTO mrr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“अडोना सास्त्रम वेहतपु, देवुळतुह्‌क वाटटव सबे कोडिनगा, मीट ओवुर काल्पिह्‌निर. अहलेह्‌काने मीट सबेटोरिर, (किसलेह्‌काडाङ तिपल्कनाहि पेससोरे, गर्यातगा वाटटदु, देवुळतुह्‌क विचर वायनद कोडलेह्‌का आयकिर). ");
INSERT INTO mrr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ओवुर बेसे मन्ह्‌ता, मति ओवुरता मिटस बार अता इतेके, तान बेद्रम मिटस कीकिर? मीट ओवुरता लेह्‌का मिटस केवालोरिर मन्ह्‌टु, ओर्विह्‌क-ओर्वोग़ कलियिस गूनमते मन्ह्‌टु,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","पया येसु तनाङ कग़यवालोरा संगे अग्डाहि यहुदा पटटा एरियाते वातोग़. वासि अग्डाह योर्दन बेरेटा अबर बाजे अतोग़. अस्के ओसोवने गोह्‌डिनाङ गोह्‌डिङ लोकुर ओनगा जमा आतोर. आतस्के येसु तना अल्वट मतपु, ओरिन काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","पया उच्वुर परुसिर येसुनगा वासि, ओन एग़्किह कीयलाह इतोर, “मन्कल तना मुतेन देहचीयना, इद पोलिह्‌ताया?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ताल्ह्‌कतस्के येसु ओरिन, “मोसानाङ अडोनगा, इदिना लोप्पा बाताल उकुम मन्ह्‌ता?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ओर इतोर, “मुतेन विळ्सना इतेके, मुतेन विळ्सिसीय्ह्‌नन इनजोर, पंचता मुनेह कळ्पाकग़ देहतनद सीटि रासिस, तान विळ्सिसीयना इनजोर, मोसा मुय्तोग़ उकुम ईतोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","येसु ओरिन इतोग़, “मीट देवुळता पोल्‍लो केंजवाह्‌कु, मीवा कैंगम ऊळिसि, मोसा मुय्तोग़ मीवाङ आस्किन देहचीयलाह अडो रासतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","मति देवुळि इद बूमतुन पुटिह कीतग्डाहिये, ओरिन आंचाळ-कोय्तोग़ इन्जि पंडटा. ");
INSERT INTO mrr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘अदिनेनाह्‌क मुतेन ततस्के, कोय्तोग़ तनाङ तलोग़-तपेना अदिकरते मनवा, वेर आळ इर्वुर जोळेम आसि, ");
INSERT INTO mrr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","उंदिय आस मनदनुर,’(इनजोर सास्त्रमवेहतह्‌ता). इतेके ओर इर्वुर अलग-अलग आयोर, मति उंदियलेह्‌का आस मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","अदिनेनाह्‌क बोरिन देवुळि जोळे कीता, (ओसो ओर अमेसा ऐंगेन मनदना इन्जि ताना विचर मन्ह्‌ता,) ओरा जोळतुन मन्कलोर देहमाकिर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","पया ओर तमा जागातगा अतस्के, मुतेन विळ्सनद पोल्‍लोता लोप्पा, ओसो कग़यवालोर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ताल्ह्‌कतस्के येसु इतोग़, “बोग़ाय तना मुतेन विळ्सिसि, ओसो उंदि दुस्रा मुतेन ततोग़ इतेके, ओग़ तना मुनेता मुतेना अडम, सिंड्रि-साट्यालता पापम कीस्तोग़. (बाराह्‌क इतेके देवुळता विचरते ओग़ु देहचीता आंचाना मुजो इंका मन्ह्‌तोग़े). ");
INSERT INTO mrr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अद्रमलेह्‌काने मुते वने तना मुजोन विळ्सिसि, ओसो दुस्रोन्क अता इतेके, अद सिंड्रि-साट्यालता पापम कीस्ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","उंद दिया तमाङ पिलाङ-पेकोरा पोग़ोन कय तासिसि, ओरिह्‌क बर्कत ईयेग़ इनजोर, लोकुर तमाङ बाला पेकोरिन येसुनगा तचोर मतोर. मति (इके येसुना एरे पेकोरिन तमाट इनजोर,) कग़यवालोर ओराङ तलिस्क-तपेरिन तेर्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","अस्के येसु ऊळतोग़, ऊळिसि ओङ आसि, तनाङ कग़यवालोरिन इतोग़, “पिलाङ-पेकोरिन नयगा वायलाह ईम्ह्‌टु, ओरिन रोमिह केमाटु. बाराह्‌क इतेके देवुळबाबाल वेरा लेह्‌काडोर कुलुल बुदतोरिह्‌के राजाल आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","इह केंजाट, नना मीक सेतेम वेहतलाह आतन, बोरु वेर उड्लोर पेकोर कीतपु, तमा बुदतुन कुलुल कीसि, देवुळतुन तमा जीवातगा राजेम कीयलाह एवोर; ओरिह्‌क देवुळ राजेम केवालोर लोकुरगा जागा दोर्को आयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","वेहचि ओर पिलाङ-पेकोरिन ओग़्ङतोग़, ओग़्ङिसि ओरा पोग़ोन तना कय तासिसि, ओरिह्‌क बर्कत ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","पया तनाङ कग़यवालोरा संगे येसु अग़दे अनजोर मतोग़, अस्के ओर्वोग़ मन्कल वित वासि, येसुना मुनेह मिंडाङ कोटिसि, इद्रम ताल्ह्‌कतोग़, “गूरु! निमा पका सेतेमतोनिन आंदिन. नाक वेहा, देवुळता संगे अमेसाता पिसमुळ दोर्किह कीयलाहि, नना बाताल कीकन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","इतस्के येसु ओन इतोग़, “निमा नाक सेतेमतोनिन इनजोर, बाराह्‌क इह्‌निन? देवुळतुन विळ्सिसि, बोग़े सेतेमतोग़ इलेग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","निमा मोसानाङ अडोङ इतेके पुह्‌निने: बोने हव्कमा, साट्याल कबळ केमा, बोनाङ कलमा, जोलता साक्सि एमा, बोन नाळेह केमा, आपुना तलोग़-तपेह्‌क मान ईम,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","वेहतस्के ओग़ येसुन इतोग़, “इव सबे पोल्‍लोन, उड्लस्केडाहिये माळसोर वायलाह आतन गूरु!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ओना पोल्‍लोतुन केंजिसि, येसु ओन जीवा कीस ऊळतोग़, ऊळिस इतोग़, “इंगो निटमे, मति नियगा उंदिय पोल्‍लोता कमि मन्ह्‌ता. अन! नियगा मनदनद सबे मालसोमतुन वमिसि, लेवोरिह्‌क ईम. अद्रम कीसि, निमा नावा संगे मन्जि, नावाङ कग़या. अद्रम कीतिन इतेके, पोग़ोन देवुळता जागातगा, नियेनाह्‌क निटमता मालसोम दोर्कग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","येसुना इद पोल्‍लोतुन केंजिसि, ओग़ मन्कना मोकम एग़ रेगता; पया ओग़ ओसोय मेसेह्‌ने आसि अतोग़. बाराह्‌क इतेके, ओग़ पका मालसोम मता मन्कल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","पया येसु सर्ने ऊळिसि, तनाङ कग़यवालोरिन इतोग़, “पका मालसोम मता लोकुर, देवुळता राजेमतोर आयना इतेके, पका मुस्किल आस्ता.” ");
INSERT INTO mrr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","(पका मालसोम इतेके, देवुळता देय्वाता सीना आंदु इन्जि, यहुदिरा विचर मता.) अदिनेनाह्‌क इदिन केंजिसि, कग़यवालोर बयल आतोर; मति येसु ओसो ओरिन इतोग़, “पेकोरिर! मालसोमतगा बर्वस केवालोर मन्कलोरिह्‌क, देवुळतुन तमगा राजेम कीयलाह ईयना इतेके, ओरिह्‌क पका मुस्किल आस्ता. ");
INSERT INTO mrr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ऊज-बूकातुह्‌क रूटुम पेसिस दाया पग़यह्‌ताया? अद्रमे, मता मन्कल देवुळता राजेमतोग़ आयना इतेके, तान्काय मुस्किलता पोल्‍लो!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","वेहतस्के, कग़यवालोर बयल आसि, तमतमाय इद्रम इतोर, “अह इतेके अमेसाता पिसमुळ पया बोन्क दोर्कग़ा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","इतस्के येसु ओरिन ऊळिस इतोग़, “इव पोल्‍लोङ मन्कना कयदे आया पग़वोङ, मति देवुळताये कयदे इव सबे आया पग़यह्‌ताङ,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","इनजोर इतस्के, पत्रु येसुन इतोग़, “ऊळा गूरु, माट इतेके कतमे विळ्सिसि नीवा पेग़्के वातोम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","अस्के येसु इतोग़, “केंजाट, नना मीकु सेतेम वेहतह्‌नन, बोग़ाय नयेनाह्‌क, नावा बेसता कबुरतुन पोकुर कीयनेनाह्‌क, तना लोन-दुवरतुन, दादाल-तमोनु, एलाळ-बायिनु, तलोग़-तपेनु, पिलाङ-पेकोरिन, जागा-बूमतुन विळ्सनोग़, ");
INSERT INTO mrr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ओन्क इद कालमते लेकालेवा सम्सरम ओसो एळ्म-दळ्मतोर दोर्कनुर. अहे नावा मन्कल आताह्‌कु, लोकुर ओन तिपल वने कीयनुर. मति वायना कालमते, ओन्क अमेसाता पिसमुळ वने दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","मति इद दुनियाते बोर बेरोर मन्ह्‌तोर, वायनद कालमते उड्लोर आयनुर; ओसो बोर इद दुनियाते उड्लोर मन्ह्‌तोर, ओरु अस्के बेरोर आयनुर, इद्रम वेल्‍लाटोरे आयनुर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","पया ओर येरुसलेम सहरता अग़ पोस अनेके, येसु ओर सबेटोरिह्‌काय मुनेह-मुनेह ताकिंदोग़. (मावा गूरु पका दोकाता जागाते बाराह्‌क दास्तोग़ इनजोर) कग़यवालोर बयल आतोर. ओरा पयाह पयाह अनवालोर मन्कलोर बह बह आयग़ा इनजोर रेयिस मंदुर. अस्के बारा बळयिरिन येसु केयिसि, येरुसलेम अतस्के मन्कलोर तन्क बह कीयनुर इनजोर वेहता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","येसु ओरिन इतोग़, “केंजाटु, माट येरुसलेम दाय्ह्‌नल, अगा अतापया नना माने-मन्कना नडुम पुटटोनन मन्ज तेला, नाक लोकुर पेर्मालोरा ओसो सास्त्रमगूरुरा कयदे पोस ईयनुर. नाक पया वेर पेर्मालोर ओसो सास्त्रमगूरुर हव्कनद सिक्सा कीयलाह वेहचि, देवुळतुन पुनवोर रोम सर्करतोरा कयदे ओसीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ओर नाक उस्कनुर-पास्कनुर, जेट्लाते नल्हतनुर, अह कीसि नाक हव्कनुर. मति नना मूंड दियाने जीवा अरयकन,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","तेना पया जेबेदिनाङ मग़्कु याकुबि, योहनि वेर ओनगा वासि, “गूरु, माट बेद नीक ताल्ह्‌ककोम, अद निमा मयेनाह्‌क कीकिन इनजोर मावा विचर मन्ह्‌ता,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","येसु ओरिन इतोग़, “नना मियेनाह्‌क बाताल कीकन इनजोर, मीवा विचर मन्ह्‌ता?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ओर इतोर, “निमा नीवा राजगादेतगा उदकिन अस्के, माक तमोग़ इर्वुरिन, ओर्विन नीवा तिनळ बाजे, ओसो ओर्विन नीवा दावळ बाजे उदलाह ईम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","इतस्के येसु ओरिन इतोग़, “मीट बाताल ताल्ह्‌किह्‌निर, अद मीक तेळियिह्‌ताया? नना बेद तिपलते अरयकन, अद तिपलते मीट अरया पग़यकिरा? नना बेद सिक्सा एतकन, अद सिक्सा मीट एता पग़यकिरा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ओर इतोर, “इंगो! माट तिपल आयलाह तयर मह्‌नोम,” इतस्के येसु इतोग़, “नना अरयनद तिपलते मीट अरयकिरे, नना एतनद सिक्सा मीट एतकिरे. ");
INSERT INTO mrr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","मति नावा तिनळ बाजे ओसो दावळ बाजे उदिह कीयनद, नावा कबळ आयो. देवुळि अद जागा बोरेनाह्‌क ओप्पे कीस तासता, ओरे अगा उदनुर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","इदिन केंजिसि दहा मुल बळयिर, वेर इर्वुरा पोग़ोन ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","पया येसु सबेटोर बळयिरिन, तना एरे केयिस इद्रम इतोग़, “इद दुनियातोर राजालोर तमा राजेमतोरिन कय इळ्न तासिह्‌तोर, अहे दुनियातोरा बेरोर मन्कलोर उड्लोर मन्कलोरगा, तमा अदिकर ताकिह कीस्तोर, इद इतेक मीक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","मति मीट मात्रम अद्रम कीयनद आयो. मियग्डाहि बोग़ देवुळता मुनेह बेरोग़ आयलाह ऊळिह्‌तोग़, ओग़ मीवा सेवा केवाल आयेग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अहे बोग़ मियग्डाहि देवुळता मुनेह सबेटोरिह्‌क बेरोग़ आयलाह ऊळिह्‌तोग़, ओग़ मीवा ओर्युलतोग़ आयेग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","माने-मन्कना नडुम पुटटोनन, नना वने दुस्रोरिन नावा सेवा कीया वेहतलाह, इद बूमते वावोन. मति दुस्रोरा सेवा कीयलाहि, ओसो वेल्‍लाटोरा पापमता दांड निहतलाह, नना नावा जीवा ईयलाह वातन. अहलेह्‌का मीट वने दुस्रोरा सेवा कीम्ह्‌टु,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","अद्रमे पया येसु ओसो ओनाङ कग़यवालोर यरिग़ो नाटे वातोर, वासि नाटेनाहि पेसिस अनेके, ओरा पयाह वेल्‍लाय मुल मतोर. अस्के तिमाय इनवाना मग़ि बरतिमाय इनवाल गुडि मतोग़, ओग़ गुडि अग़दा कचुल उदिसि, बिचेम ताल्ह्‌किंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","पया ओग़ु नासरेत नाटेनोग़ येसु इद अग़दुह्‌क दायलाह आतोग़ इनजोर केंजिसि, “ए येसु! दाविद राजाना कूळतोनिन पिसिह केवानिन! नावा पोग़ोन दया कीमु,” इनजोर केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","केयतस्के अगा मतोर वेल्‍लाटोर मन्कलोरु, “निमा केमेन मन रा,” इनजोर ओन तेर्हतोर. तेला मति ओग़ इंका ओसो पका केयलाह आतोग़. “ए दाविद राजाना कूळतोनिन! नावा पोग़ोन दया कीम!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","इतस्के येसु ओना लेङतुन केंजिसि, अगान नितोग़. निचि, “अले ओन केयाट” इतोग़. इतस्के अग्डोर ओन, “तेदा! दीरा पोय्म! येसु नीक केयलाह आतोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","इतस्के ओग़ तना मुचिस मतद गेंदेतुन जेग़्कतोग़, जेग़्किसि पोर्क तेदिसि येसुनगा वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","पया येसु ओन इतोग़, “नना नियेनाह्‌क बाताल कीकन इन्जि नीवा विचर मन्ह्‌ता?” इतस्के ओग़ गुडि, “नाक तोवनाह कीसीम गूरु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","इतस्के येसु इतोग़, “अले! अह इतेके नावा पोग़ोन विस्वस कीतिन, अदिह्‌क तोवयकिन,” इतोग़. इताहे ओग़ तोप्नेन तोवतोग़. तोवतस्के अदे अग़दगा येसुना पयाह अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","पया येसु ओसो ओनाङ कग़यवालोर, येरुसलेम सहरता एरे एवयलाह आतोर. पया जय्तुन मेटाता कचुल मतव, बेत्पागे ओसो बेतनि, इव नाह्‌कना एरे एवतोर. अस्के येसु तनाङ कग़यवालोरग्डाह, इर्वुरिन इद्रम वेहतोग़: ");
INSERT INTO mrr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“मावा मुनेह दिसनद नाटेनगा अन्ह्‌ट. अगा ओळियताहे, बोग़े बेस्केन उदवद गाळ्‍द पियोतुन दोहच तासतद ऊळकिर. अस्के तान लेहच ताट. ");
INSERT INTO mrr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","बोग़ाय ‘बाराह्‌क अह कीय्ह्‌निर रा?’ इनजोर ताल्ह्‌कतेके, ‘सामिह्‌क तेना गर्ज अरता, ओसो चट्पिट मल्हच ओग़ लोहचीयनोग़,’ इनजोर वेहाट,” इन्जि ओरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","पया ओर अन्जि अग़दा कचुल, उंदि लोता मुनेह दोहतद गाळ्‍द पियोतुन ऊळतोर, ऊळिसि तान लेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","अस्के अगा निच मतोर मन्कलोर ओरिन इतोर, “मीट बह कीयलाह आतिर रा? तान बाराह्‌क लेहतह्‌निर?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ताल्ह्‌कतस्के येसु तम्क वेहतपे, ओरिन वेहतोर. वेहतस्के पया, ओर मन्कलोर गाळ्‍द पियोतुन ओयलाह ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","पया ओर अद गाळ्‍द पियोतुन येसुनगा ततोर, तचि येसु ताना पोग़ोन उदलाहि, तमाङ कोटजगाङ ताना पोग़ोन ताग़तोर. अस्के येसु गाळ्‍द पियोता पोग़ोन उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","उदिसि येरुसलेमतके अनेके, मुडग्डाहि वेल्‍लाटोर लोकुर येसुह्‌कु मान ईयलाह, तमाङ कोटजगाङ तेंडिसि, अग़दे ओना मुनेह ताग़िन्दुर. ओसो उच्वुर बार, पोलमताङ मरानाङ कोमान डायिसि, अग़दगा ताग़िन्दुर. ");
INSERT INTO mrr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","पया येसुना पेग़्के-मुनेह अनवालोर लोकुर, केयसोर-केयसोर इनदलाह आतोर, “जोहर! देवुळबाबाना अदिकर पोस वास्तोग़, ओन्कु देवुळता देय्वा आयि! ");
INSERT INTO mrr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","दाविद राजाना लेह्‌कान राजेम कीयलाह वास्तोग़, ओन्क देवुळता देय्वा आयि! पोग़ोटा देवुळतुह्‌क जोहर!” इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","अद्रमे पया येसु येरुसलेम सहरतगा वासि मंदिरतगा अतोग़. अन्जि अगा तिरियिसि, सबेटविन बेस-नेह्‌ना ऊळतोग़. पया पोळ्‍द अन्ज मताह्‌कु, येसु तनाङ बारा बळयिरिन पोसि, बेतनि नाटे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","इमा दिया नग़्कमि, बेतनि नाटेनाहि येसु पेसतोग़ अस्के, ओन्क कग़्व वसता. ");
INSERT INTO mrr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","पया जेकताहि उंदि अंजिर मरा दिसता. अद मरा बेस लह-लह आस मता. अस्के अगा तिनदलाह अंजिर पंडिङ मनदनुङ बहे इन्जि, येसु मराता एरे अतोग़. मति अगा वेट आकिङे मताङ! बह इतेके अद पंडिङ आदनद वेला आयो. ");
INSERT INTO mrr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","पया येसु अद मरातुन इद्रम इतोग़, “इंजेके नियगा बेस्केन पंडिङ आदमाकिङ!” इतोग़. ओग़ अद्रम इतदिन, ओनाङ कग़यवालोर केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","पया ओर येरुसलेम एवतोर, अस्के येसु मंदिरतगा अतोग़. अह कीसि अगा वमवालोरिन, असवालोरिन पलते पूंडटोग़. ओसो कोताङ बद्ले केवालोराङ बलानु, ओसो मोकतुह्‌क अरयनव परेवा पिटेङ वमवालोराङ कुतुस्किन, कप मुळ्हतोग़. (सर्करताङ कोताङ मंदिरतगा वाटलाह ताकोङ आंदुङ, अदिह्‌कु अव कोताङ बद्ले कीसि यहुदिराङ कोताङ एवालोर अगा उदिस मंदुर.) ");
INSERT INTO mrr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","येसु अह कीसि मंदिरतगाह्‌क बोने सामन पोसि दाया-वाया कीयलाह एवोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","पया तना काग़्हतह्‌पा, ओरिन इद्रम इतोग़, “ ‘नावा लोतुन सबे जातिनोर मोळ्कनद जागा इनदनुर,’ इन्जि देवुळ इन्ह्‌ता, इद्रम देवुळता कबुरतोग़ रासतोग़, पुनविरा? मति मीट देवुळता लोतुन डाकुरा डेरा कीतिर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","इद पोल्‍लोतुन केंजिसि, पेर्मालोर ओसो सास्त्रमगूरुर, येसुन हव्कलाह पट ऊळिन्दुर. सबेटोर लोकुर येसु काग़्हतनदिन केंजिसि बामिंदुर, अदिनेनाह्‌क ओर ओन बह आयि कीयलाह रेयिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","पया पोळ्‍द अतस्के, येसु ओनाङ कग़यवालोर बारा, येरुसलेम सहरताहि पेसतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","इमा दिया नग़्कमि, ओर ओसोवने येरुसलेमतके वानेके, ओर अद अंजिर मरातुन ऊळतोर. अस्के अद मरा पूरा डोलिस मता. ");
INSERT INTO mrr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पया येसु मुने अद मरातुन इतद पोल्‍लो, पत्रुह्‌क सीता वाता. अस्के ओग़ येसुन इतोग़, “गूरु, ओद ऊळा! निमा सरप ईतद अंजिर मरा वाग़ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","इतस्के येसु इतोग़, “मीट देवुळता पोग़ोन विस्वस तासाटु. ");
INSERT INTO mrr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","केंजाट, नना मीक सेतेम वेहतह्‌नन, बोग़ाय इद मेटातुन ‘डग वासि सम्दुरतगा अन्ज अर्म’ इन्जि, बेदे उन्क-मन्क आयवा विस्वस कीतेके, अद अद्रमे आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","नना मीक वेहतह्‌नन, बेदाय मीट देवुळतुन पार्तना कीस ताल्ह्‌कतेके, अद मीक दोर्कता इन्जि विस्वस कीम्ह्‌टु, अद मीक दोर्कग़ाये. ");
INSERT INTO mrr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ओसो बोग़ाय मीवा अडम कसुर कीताह्‌कु, ओना पोग़ोन मीवा जीवातगा विरुद मतेके, मीट पार्तना कीयलाह निच मनदह्‌पा, मुने ओन मापि कीम्ह्‌टु. अस्के मीवा देवुळदीपतोग़ बाबाल वने मीवा कसुरतुन मापि कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","मीट दुस्रोना कसुरतुन मापि केवेके, देवुळदीपतोग़ मीवा बाबाल वने मीवा कसुरतुन मापि केवोग़,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","पया ओर येरुसलेम सहरते मल्स वातोर. वासि येसु मंदिरतगा तिरियसोर मतोग़, अस्के पेर्मालोर, सास्त्रमगूरुर, यहुदिराङ पेदल्क ओनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","वासि इद्रम ताल्ह्‌कतोर, “निमा बेद अदिकरते इव कबस्क कीय्ह्‌निन? इव कबस्क कीयलाह नीक बोग़ अदिकर ईतोग़?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","येसु ओरिन इतोग़, “नना वने उंद पोल्‍लो मीक ताल्ह्‌किह्‌नन. मीट अदिन वेहतेके, नना वने बेद अदिकरते कीय्ह्‌नन, अदिन वेहतकन. ");
INSERT INTO mrr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","अले वेहाट, योहनिह्‌क लोकुरिन देवुळता पेदिरते एग़ मीहतलाह बह देवुळ अदिकर ईताया, बार मन्कलोर ईतोरा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","अस्के ओर तमतमाये इह वळ्ह्‌किंदुर, “माट देवुळ ईता इतेके, वेग़ इनदनोग़, ‘अह इतेके मीट योहनिन बाराह्‌क नमविर?’ इनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ओसो माट मन्कलोर ईतोर इतेके, लोकुर मावा अडम आयनुर, बाराह्‌क इतेके योहनि निटम देवुळता कबुरतोग़ आंदोग़ इनजोर सबेटोर नमिह्‌तोर,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","अदिह्‌क पया ओर येसुन “माट पुनोम,” इनजोर इतोर. अस्के पया येसु इतोग़, “अह इतेके, नना वने इव कबस्किन बेद अदिकरते कीय्ह्‌नन, अदिन मीक वेहोन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","पया ओरिन येसु पुन्पिह कीयनद पीटोते, इद्रम वेहता बोटटोग़ इतेके, “ओर्वोग़ मन्कल तना जागातगा अंगुर सोपता वाळुम ओग़्सतोग़. ओग़्सिसि, ताना सर्ने वेटळ दोहतोग़. पया वाळुमता लोप्पा अंगुर जोमा पेग़लाहि उंदि बोंदा तर्वतोग़. ओसो ताना एरे वाळुमतुन केपलाह, उंद मंडा पंडटोग़. पया ओग़ दुस्रोरिह्‌क कूलते तासिसि, जेक देसेमते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","पया अंगुर पंडिना पंटा वातस्के, ऊळेवाळे केवालोरग्डाहि, पंडिना तना तूस एतलाहि, ओग़ तना ओर्वोग़ ओर्युलतोन ऊळेवाळे केवालोरक्‍के लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","मति ओरु ओन पोसि पका नल्हतोर, अह कीसि वेट्‍टाङ कय्क पूंडिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","पूंडटस्के पया, माल्काल ओसो ओर्वोग़ ओर्युलतोन लोहतोग़. ओर ऊळेवाळे केवालोर ओना तलातुह्‌क ईतोर. ईसि लजा वानाह ओना कदर रेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","पया ओसो ओर्वोग़ ओर्युलतोन लोहतोग़, ओन ओर हव्कतोर. अस्के इद्रमे ओग़ माल्काल, ओसो वेल्‍लाटोरे ओर्युलतोरिन लोहतोग़. मति ऊळेवाळे केवालोर ओरग्डाह उच्वुरिन बार नल्हतोर, उच्वुरिन बार हव्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","इंजेके ओग़ माल्कानगा तना जीवा कीतोग़ मग़िये पिसिस मतोग़. पया आक्रिते नावा मग़िन मान तासनुर इनजोर विचर कीसि, ओग़ तना मग़िनु ओरक्‍के लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","लोहतस्के ओग़ वायनदिन ऊळेवाळे केवालोर ऊळिसि, तमतमाय इतोर, ‘अरे वेग़ इतेके माल्काना मग़ि आंदोग़ रा. दट, वेने माट हव्किङ, अस्के इद वाळुम माके आयग़ा,’ इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","इन्जि ओर ओन पोस हव्कतोर, अह कीसि अंगुर वाळुमता पलते जेग़्किसीतोर,” इनजोर येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","कीसि इद्रम इतोग़, “अंगुर वाळुमता माल्काल इंजेके ओरिन बह कीयनोग़? ओग़ वासि अद वाळुमतुन कयदे कीतोर, सबेटोर ऊळेवाळे केवालोरिन हव्कनोग़. अह कीसि, अद वाळुमतुन दुस्रोरा कयदे ईयनोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","ओसो इतोग़, “बेद बंडातुन मुने बेल्दर्क पोहचीतोर, अदे बंडा इंजेके आदरता मूला-बंडा आता. इद देवुळबाबानाये कबळ आंदु, इद माक पकाय बामतप दिसिह्‌ता, इद्रम देवुळता सास्त्रमतगा रासतदिन अर्वविरा?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","येसु वेहतद पुन्पिह कीयनद पीटोतुन केंजिसि, मावाय लोप्पा इद पीटो वेहतोग़ इनजोर, पेर्मालोर, सास्त्रमगूरुर पुतोर. अदिह्‌क येसुन ओर पोयतलाहि अग़ पर्ह्‌किंदुर. मति लोकुरा रेयतुह्‌कु ओन पोयवाये अहे अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","पया ओर बह कीतोर इतेके, “येसु वळ्ह्‌कनद पोल्‍लोते, ओन एग़्किह कीम्ह्‌टु,” इनजोर उच्वुर परुसिरिन ओसो उच्वुर एरोद राजाना तुंगातोरिन येसुनगा लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","लोहतस्के, ओर येसुनगा वासि, “गूरु, निमा सेतेम मन्कनिन मह्‌निन, बोर बाताल इनदनुर इनजोर आल्सविन, निमा लोकुरा मोकम ऊळिस वळ्ह्‌कविन, देवुळता अग़दुन सेतेमते तोहतह्‌निन, इद माट पुह्‌नोम. इंजेक माक वेहा, रोम सर्करतुह्‌क सिद्‌वा दोहतनद, मावाङ अडोना अडम मन्ह्‌ताया, इलेया? ");
INSERT INTO mrr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","माट सिद्‌वा दोहतकोमा, दोहोमा?” इनजोर ओर येसुन ताल्ह्‌कतोर. मति येसु ओरा सोङतुन पुन्जि, ओरिन इतोग़, “नाक बाराह्‌क एग़्किह कीयलाह ऊळिह्‌निर? नाक ऊळलाह उंदि रुप्या-बंडि ताट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ओर ततस्के येसु ओरिन, “इद बंडटगा बोना पोटो ओसो पेदिर रासतद मन्ह्‌ता?” इनजोर ताल्ह्‌कतोग़. “कय्सर राजाना!” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","इतस्के येसु ओरिन इतोग़, “अह इतेके बेद रोम राजेमता कय्सर राजाना मन्ह्‌ता, अद ओन्के ईम्ह्‌टु! ओसो बेद देवुळ ताल्ह्‌किह्‌ता, अदिन देवुळतुह्‌क ईम्ह्‌टु,” इनजोर इतोग़. पया इद्रम केंजिसि, ओर पका बयल आतोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","पया सदुकिरा तुंगातोर उय्तुर, येसुनगा वासि ताल्ह्‌कतोर. (वेर सदुकिरा तुंगातोर इतेके मन्कलोर डोलतापया, बोरे जीवा अरवोर इनजोर इंदुर.) ");
INSERT INTO mrr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गूरु! मोसा मुय्तोग़ मावासाटि इद्रम रासिस तासतोग़ इतेके, बोग़ाय मग़मियाळ लेवाये डोलतोग़ इतेके, ओना रांडे मुतेना संगे ओना तमोग़ जोळेम आसि, तमदादाना लोता लोन निल्पिह कीयना, इनजोर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","इंजेके तमोग़ एळवुर मतोर. ओरग्डाहि मुनेतोग़ तमदादाल मुते ततोग़. मति मग़मियाळ आयवाये डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","डोलतस्के ओना पेग़्केडोग़, अद रांडे मुतेन तासतोग़. ओग़ वने मग़मियाळ आयवाये डोलतोग़. ओसो ओर्वोग़ ओना पेग़्केडोग़ वने अद्रमे डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","इद्रमलेह्‌का तमोग़ एळवुर आसि ओर्वोग़-ओर्वोग़, (ताना संगे जोळेम आस मतोर, मति) मग़मियाळ आयवाये डोलतोर. ओर सबेटोर डोलतापया, अद रांडे आंचाळ वने डोलता. ");
INSERT INTO mrr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","मति इंजेके ओर ओसोवने जीवा अरतस्के, एळवुरग्डाहि अद आंचाळि बोना मुते आयग़ा? बाराह्‌क इतेके, ओर एळवुर आसि ताना संगे जोळेम आस मतोर कोनि,” इतोर. (हामुरताहि जीवा अरयनदिन बय्तळ लोकुरे नमिह्‌तोर इन्जि तोहतलाह, वेर इह ताल्ह्‌कतोर.) ");
INSERT INTO mrr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","इतस्के येसु ओरिन इतोग़, “हामुरताहि जीवा अरयना लोप्पा, देवुळता सास्त्रम बाताङ वेहतह्‌ता, अविन मीट पुनविर. ओसो हामुरताहि तेग़्किह कीयनद देवुळता लावतुन वने पुनविर. अदिह्‌क मीटु गंगाते लेसतप मह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","वेर डोलतोर मल्स जीवा अरयनुर अस्के, ओरु जोळजंतुर आयोर वने, ओसो जोळजंतुर कीस एवोर वने. मति ओरु देवुळदीपतगा देवतुल्कना लेह्‌का, मर्मिङ आयवाय मनदनुर. ");
INSERT INTO mrr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","मति डोलतोर मल्स जीवा अरयनुर, ताना लोप्पा मोसाल रासतद सास्त्रमतगा, किस पोतिस मतद मरा जपता लोप्पा मीट अर्विसि पुनविरा? (मावा पेदामुय्तोर अब्रहम, इसक, याकुब, वेर हातस्के, वेल्‍लाङे वर्साना पया,) देवुळि मोसान इता, ‘अब्रहम, इसक, याकुब, वेर मोळ्कनद देवुळतन ननान आंदन,’ इता. ");
INSERT INTO mrr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","इतेके इद हातोरा देवुळ आयो, मति जीवात मनवालोरा देवुळ आंदु. मीट इद पोल्‍लोते पकाय लेसतिर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","पया येसु ओसो सदुकिर वळ्ह्‌किह्‌पा, ओर्वोग़ सास्त्रमगूरु केंजतोग़. केंजिसि येसु ओरिन बेस पोल्‍लो मल्हतोग़ इन्जि, ओग़ येसुन इद्रम ताल्ह्‌कतोग़, “गूरु! सबेट्क बेरा अडो बेद आंदु?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","इतस्के येसु इतोग़, “सबेट्क बेरा अडो इद आंदु: ए इस्रयेललोकुरिर, केंजाट! सिरप मावा देवुळिये सामि आंदु. ");
INSERT INTO mrr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","देवुळि नीवा सामि इनजोर, तान निमा पूरा बुदताहि, पूरा जीवाताहि, पूरा विचरताहि, पूरा लावताहि जीवा कीमु. ");
INSERT INTO mrr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ओसो तेना लेह्‌का दुस्रा अडो इद्रम मन्ह्‌ता: निमा कुदतुन जीवा कीतपु, दुस्रोरिन वने जीवा कीमु. इव रेंड अडोन वीळिसि बेदे बेरा अडो इले,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","पया सास्त्रमगूरु येसुन इतोग़, “गूरु, बेस-नेह्‌ना वेहतिन! देवुळि उंदिये मन्ह्‌ता, तान विळ्सिसि बेदे देवुळि इले इनजोर सेतेम वेहतिन. ");
INSERT INTO mrr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ओसो देवुळतुन पूरा विचरताहि, पूरा जीवाताहि, पूरा लावताहि जीवा कीयना, अहे कुदतुन जीवा कीयना लेह्‌का दुस्रोरिन जीवा कीयना, इदु देवुळतुह्‌क ईयनद सबे मोकतुह्‌काय, कोडटुह्‌काय वीळिसि बेरा पोल्‍लो आंदु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","पया ओग़ मन्कल तेल्वते वळ्ह्‌कतोग़ इनजोर येसु पुतोग़. पुन्जि ओन इतोग़, “निमा इंजेके देवुळ राजेम केवालोरगा कलियलाह, वेल्‍ला जेक इलविन,” इनजोर इतोग़. तेना पया ओसोवने बाताङाय ताल्ह्‌कलाह, बोन्के बह दीरा वावो. ");
INSERT INTO mrr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","पया येसु मंदिरतगा काग़्हचोरे, ओरिन इद्रम ताल्ह्‌कतोग़, “देवुळ लोहवाल पिसिह केवाल किर्स्तुनु, दाविद राजाना पुळ्गतोग़ इनजोर, सास्त्रमगूरुर बाराह्‌क इन्ह्‌तोर? ");
INSERT INTO mrr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाविद राजानगा देवुळता पवित्र जीवा रेगता अस्के, ओग़ कुदि इद्रम इतोग़: देवुळि नावा सामिन इता, ‘बेचानाह नना नीवा कोटुलतोरिन, नीवाङ काल्कना इळ्न तच एवोन, अचानाह नावा तिनळ बाजेता राजगादेतगा उदिस मन,’ इता. इन्जि दाविद राजाल इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाविद राजाल कुदि पिसिह केवाल किर्स्तुन ‘सामि’ इन्ह्‌तोग़. इतेके ओग़ किर्स्तु, दाविद राजाना पुळ्गतोग़े बेद्रम आया पग़यह्‌तोग़?” इनजोर इतोग़. येसु काग़्हतह्‌पा, अगा मता मुडा लोकुर गिर्दाते ओनाङ केंजिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","अद्रमे येसु काग़्हनेके ओरिन इतोग़, “सास्त्रमगूरुरग्डाहि उसरते मन्ह्‌टु. ओर तमा बेरातनम तोहतलाहि लाट गेंदेङ केग़्स तिरियलाह विचर कीस्तोर. ओसो बजरतगा मनवालोर तम्क जोहर कीयिर इनजोर, विचर कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","अहे पार्तनाताङ लोह्‌कनगा ओसो कुळ्पिनगा, मुनेहतेह कुर्सिनगा उदलाह विचर कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ओसो वेर रांडे आस्किन नाळेह कीसि, लूटे कीस्तोर. ओसो लोकुरिह्‌क दिसना इन्जि, वेल्‍लाय जोम पार्तना कीस्तोर. वेर लोकुरिह्‌क मात्रम, दुस्रोरिह्‌काय एक्‍वा सिक्सा देवुळि ईयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","पया लोकुर मंदिरता संदुकतगा देवुळतुह्‌क कोताङ बेद्रम वाटिह्‌तोर इनजोर, येसु संदुकता मुनेह उदिस ऊळसोर मतोग़. अस्के वेल्‍लाटोर मता मन्कलोर वेल्‍लाय दान वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","अचोटेन ओसोय गरिब रांडे आंचाळ वन वासि, इतुळताङ रेंड इचुटाङ कोताङ वाटटा. ");
INSERT INTO mrr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","वाटटस्के येसु तनाङ कग़यवालोरिन केयिसि, ओरिन इतोग़, “इह केंजाट, नना मीकु सेतेम वेहतह्‌नन, संदुकतगा दान वाटटोर सबेटोरगा वेल्‍लाङे कोताङ मन्ह्‌ताङ. ओसो दान वाटटापया वने, ओरगा कोताङ पिसिह्‌ताङ. मति इद आंचानगा बाताङे इलेङ, तेला मति तना पिसवग़तुह्‌क तासिस मतव, पूरा कोतान दान वाटटा. अदिनेनाह्‌क देवुळता नद्रते इद गरिब रांडे आंचाळिये, सबेटोरिह्‌काय एक्‍वा कोताङ वाटटा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","पया यहुदिरा मंदिरताहि येसु पेसिस अनेके, ओर्वोग़ कग़यवाल येसुन इतोग़, “गूरु, इद ऊळा! इद मंदिर बेचोन सोबा दिसिह्‌ता. तेन बेचोन सोबाताङ बंडाने दोहतोर!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","इतस्के येसु ओन इतोग़, “निमा इद मंदिरताङ बेराङ-बेराङ लोह्‌किन ऊळिह्‌निन इसि. (इव इचोन बूळेम आयनुङ इतेके,) इविस्कनगा बंडाता पोग़ोन बंडा वने मनो आयग़ा, बूळे केवालोर कतम अर्हतनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","पया येसु मंदिरतग्डाह पेसिसि, जय्तुन मराना गुड्रातगा अन्जि, मंदिरता मुनेहतेके उदिस मतोग़. ओग़ वग़ोग़े मतस्के, पत्रु, याकुबि, योहनि, आंद्रेयाल वेर ओनगा अन्जि, इद्रम ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“गूरु, इव पोल्‍लोङ बेस्के बह आयनुङ? इव पोल्‍लोङ आयनुङ इनजोर, तेना बाताल सीना दिसग़ा?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ताल्ह्‌कतस्के येसु ओरिन इतोग़, “मीक बोग़ाय नाळेह कीयना आयो इन्जि, उसरते मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","वेल्‍लाटोर नावा पेदिर पोस वासि, ‘नना देवुळ लोहतोनन,’ इनजोर वेल्‍लाटोरिन नाळेह कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ईनाह-आनाह बेके ऊळतेकाय, लळय्क आस्ताङ इन्जि, मीक एर्का आयग़ा. अस्के मीट रेयमाटु. इव पोल्‍लोङ निटम इह आयनुङे, मति इचोट्के बूम मारो. ");
INSERT INTO mrr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","जातता पोग़ोन जाति तेदग़ा, राजेमता पोग़ोन राजेमि तेदग़ा. बेगा इतेक अगा जागाङ-बूमिङ मेलियनुङ, दुकळ अरयग़ा. मति इव सबे वायनाङ पीळाना सिरप मुर्ङुल आयग़ा, ओसो इंका पका बेरा गोसा वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","मीट उसरते मन्ह्‌टु. बह इतेके लोकुर मीक कोरोट-कचिर्कनगा ओसीयनुर, तमाङ पार्तनाताङ लोह्‌कने मीक नल्हतनुर. ओसो मीट नाक विस्वस कीतेनाह्‌क, मीकु गुमसिरगा, राजालोरगा ओयनुर. अस्के मीट ओरा मुनेह नावा पोल्‍लोता साक्सि वेहतकिर. ");
INSERT INTO mrr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","(इद्रमलेह्‌का बूम मुळ्न्दनामुने, नावा बेसता कबुर सबे जातिनोरगा पोकुर आयना गावले.) ");
INSERT INTO mrr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","मीवा नेयम आयलाह पोस ईयनुर अस्के, माट बाताल वळ्ह्‌ककोम इनजोर, मुनेन आलिह केमाटु. देवुळता पवित्र जीवा मीकु वळ्ह्‌कलाह बुदि ईयग़ा. अद ईतस्के बेद बह वळ्ह्‌कना, अहे वळ्ह्‌काटु. ");
INSERT INTO mrr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“विस्वस केवोग़ तमोग़ तना विस्वस कीतोग़ दादानु, ओसो विस्वस केवोग़ तपे बार तना विस्वस कीतोग़ मग़िनु, हव्कलाहि पोस ईयनुर. विस्वस केवोर मग़्क-मयास्कु विस्वस कीतोर तलोग़-तपेरा पेटळ तेदिसि, ओरिन हव्कलाह वेहतनुर. ");
INSERT INTO mrr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ओसो मीट नाक नमवालोरिर आताह्‌कु, दुनियातोर मीक कोटुल कीयनुर. मति आक्रि एवनाह बोर दीरा पोस मन्ह्‌तोर, देवुळि ओरिने पिसिह कीयग़ा.” ");
INSERT INTO mrr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ओसो उंद इद्रमता दिया वायग़ा, मंदिरतुन कळ्‍वोग़ कीयनदु बातालो उंदि, एग़्ङ वायनदिन, पोलवद जागातगा निल्पिह कीतदिन मीट ऊळकिर. (मीट अर्ववालोरिर इदिन सीताते तासाटु.) अस्के यहुदा पटटे मनवालोर लोकुर, कोंटेतोरग्डाह पिह्‌ट अरयलाह, मेटानके वितिर. ");
INSERT INTO mrr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","बोग़ाय लोता पोग़ोन मतेके, ओग़ तना लोता बातालाय ओयलाह लोनलोप्पा नेङमाकेग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ओसो बोग़ाय मन्कल पोलमते मतेके, ओग़ तना कोटजगातुन ओयलाह लोन मलमाकेग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","अव दियाने नेलाङ हव्कतव आस्किह्‌क, ओसो पाल ऊहतनव तलिस्किह्‌क, बेचोटा गोसा आयग़ा! ");
INSERT INTO mrr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अदिह्‌क मुसुर पेग़दस्के इद गोसा वामाकि इनजोर, देवुळतुन पार्तना कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","बाराह्‌क इतेके अव दियाने पका बेरा गोसा आयग़ा. अचोटा गोसा देवुळि बूम पुटिह कीतग्डाहि बेस्केन आयो वने, ओसो मुनेह बेस्केन वने आयो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","अव वायनव गोसाताङ दियान, देवुळि कमि केवेक अचोन, बोग़े मन्कल पिसोग़ आयनोग़. मति तनाङ आचतोर लोकुरिन अद गोसाताहि पिसिह कीयनेनाह्‌कु, देवुळि अव दियान कमि कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“अद वेलाते बोग़ाय मीक इनदनोग़, ‘ऊळाट, देवुळ लोहतोग़ राजाल इगाडोग़! देवुळ लोहतोग़ राजाल अगाडोग़!’ अस्के ओनाङ सेतेम पोयमाटु. ");
INSERT INTO mrr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","बाराह्‌क इतेके नना देवुळ लोहतोग़ राजानन इनवालोर जोलहालोरु, ओसो देवुळता कबुरतोनन इनवालोर जोलहालोरु, इद्रमतोर पुटनुर. ओर बामिह कीयनाङ कबस्कु ओसो सीनाङ तोहचि, देवुळ आचतोर लोकुरिन वने, लेसिह कीयलाह ऊळनुर. मति ओर अह कीया पग़वोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ऊळाट, नना इतेके सबे पोल्‍लोङ मीक मुनेन वेहतन, उसरते मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“अव दियानाङ तिपल्क मारताहे, पोळ्‍द मांजो आयग़ा, नेला दींचो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","उकाङ पोग़ोटाह इळ्न रालनुङ, पोग़ोटा बूमतगा सबे मेलियनुङ. ");
INSERT INTO mrr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","अस्के माने-मन्कना नडुम पुटटोनन, नना बेरा लावते ओसो डीसाते मोयुलपोग़ोन वायनदिन, लोकुर ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","अद वेलाते नना नावाङ देवतुल्किन दुनियाता मूलाह्‌क-मूलाह्‌क लोहतकन. पया अवु इद बूमतगा सर्ने मनवालोर, नावाङ आचतोर लोकुरिन जमा कीयनुङ.” ");
INSERT INTO mrr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“गेळाताङ मरान ऊळिसि, इद पोल्‍लो कग़याटु. आकिङ रालिह्‌ताङ अस्के, डोय एरे एवता इनजोर मीट पुह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","इद्रमलेह्‌का मीट वने इव पोल्‍लोङ आयनदिन ऊळकिर अस्के, सामि गट्‌नेन एवतप लेह्‌कान इनजोर पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","इह केंजाट, नना मीक सेतेम वेहतह्‌नन, इव सबे पोल्‍लोङ बेचानाह करल आयोङ आयनुङ, अचानाह इद पीळतोर बूळेम आयोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","पोग़ोटा बूमि, इळ्ता बूमि मायनुङ, मति नावा पोल्‍लो मात्रम बेस्केन मायो आयग़ा.” ");
INSERT INTO mrr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“मति नना मल्स वायनद दियातुन, वेलातुन बोग़े पुनोग़. देवुळदीपताङ देवतुल्क वने पुनोङ, नना इंका पुनोन, सिरपि नावा बाबाल पुन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","नना मल्स वायनद दिया बेस्के एवयह्‌ता इनजोर मीट पुनविर. अदिह्‌क मीट वने उसरते मन्ह्‌टु, केपसोर मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","इद बेद्रमलेह्‌का इतेके, ओर्वोग़ माल्काल दुस्रा देसेम दायना मताह्‌कु, तनाङ ओर्युलतोरा कयदे लोतुन विळ्सेग़. पया ओर्विह्‌क-ओर्विह्‌क उंद-उंद कबळ वेहेग़, ओसो अनेके लोता पह्‌रा केवान उसरते मन इनजोर, उकुम ईस अनेग़. ");
INSERT INTO mrr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","अद्रमलेह्‌का सामि वायनद दिया बेदु, इद मीक तेळियो. पोळ्‍द अनजोर वायनोग़ा, नडुमनग़्का वायनोग़ा, मुनेताङ कोग़्क कूसेङ वायनोग़ा, पङ आसोर वायनोग़ा, इदिन मीट पुनविर. ");
INSERT INTO mrr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","अदिनेनाह्‌क अग़ ऊळसोर मन्ह्‌टु. नना दोम्ह्‌क्ने वातस्के, मीट उंजवालेवा मनदनद दिसतेके बेसु! ");
INSERT INTO mrr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","नना मीक वेहतनद पोल्‍लोतुन, नाक नमवालोर सबेटोरिह्‌क वेहतह्‌नन, उसरते मन्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","आवना पंडुम ओसो ओय्‍पिह केवद पिंडटाङ आरिना पंडुम एवयना रेंड दियाङ मुनेता पोल्‍लो: पेर्मालोरु, सास्त्रमगूरुर, वेर येसुन कुस्क्ने पोसि हव्कलाह अग़ ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","मति पंडुमतुह्‌क वातोर मुलु कियोग़-मुयोग़ बार आयनुर इन्जि, ओन अह केवल आयकल इन्जि, विचर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","अदे दिया बेतनि नाटे मुने मोंडरोगमते मतोग़ सिमोन इनवाना लोते, येसु गाटो तिनदलाह उदिस मतोग़. अस्के उंद आंचाळि, तीसाते जटामासि इनदनद पोर्ह्‌काता, वेल्‍ला दाराता बेसता अतर्नेय पोस वाता. वासि येसुह्‌क मान ईयलाह, अद तीसातुन विर्हचि, नेयदुनु ओना तलापोग़ोन दोसिसीता. ");
INSERT INTO mrr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","इदिन ऊळिसि, अगा मतोर उय्तुर, तमा जीवाते लोप्प-लोप्पान ओङ आसि इतोर, “इदिन बाराह्‌क उगस पोहता? ");
INSERT INTO mrr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","इद अतर्नेयदुन वमिस मतेके, वर्सामेटा कूलतुह्‌काय एक्‍वा कोताङ दोर्केस्कु. पया अव कोतान गरिब-सरिबतोरिह्‌क ईयनाह आवालि,” इनजोर ओर तान कट्ला कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","अस्के येसु ओरिन इतोग़, “तेन बाराह्‌क कट्ला कीय्ह्‌निर रा? तेन विळ्साट! इद नयेनाह्‌कु पका बेसतले कबळ कीता. ");
INSERT INTO mrr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","गरिब-सरिबतोर इतेके, अमेसा मियगान मन्ह्‌तोर. मीट बेस्के इतेक अस्के, ओरिह्‌क दर्मम ईया पग़यकिर. मति नना इसि, मियगा अमेसा मनोन आयकन. ");
INSERT INTO mrr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","इद आंचाळि बेचोन कीया पग़ता, अचोन कीता. नावा मेंदुलपोग़ोन बेस एग़्स्कतद अतर्नेयदुन वाटिसि, नावा मेंदुलतुन गुमयातगा मिसलाह, मुनेन तयर कीतप लेह्‌का कीता. ");
INSERT INTO mrr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","इह केंजाट, नना मीक सेतेम वेहतह्‌नन, पूरा दुनियामेंडु, बेगा-बेगा लोकुर देवुळता राजेमता बेसता कबुरतुन वेहतनुर, अगा इद आंचाळ कीतद कबळतुन वेहतनस्के, इद आंचान सीता कीयनुर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ताना पया बार आता इतेके, यहुदा इस्केर्योत इनवाल, बारा बळयिरग्डाहि ओर्वोग़ मन्जि, पेर्मालोरगा अतोग़. अन्जि येसुनु मीवा कयदे पोसीकन इन्जि ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ओर इदिन केंजिसि गिर्दा आतोर. आसि “इद कबळतेनाह्‌क माट नीक कोताङ ईकोम,” इनजोर पोल्‍लो विळ्सतोर. अदिनेनाह्‌क पया येसुन पोस ईयलाहि, यहुदाल अग़ ऊळसोर मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","पया ओय्‍पिह केवद पिंडटाङ आरिङ तिनदनद पंडुमता मुनेता दिया, यहुदिर आवना पंडुमता गोरेपिलाता मोक ईंदुर. पया कग़यवालोर येसुनगा वासि ताल्ह्‌कतोर, “गूरु, इद आवना पंडुमता कुळ्पि, माट बेगा तयर कीकोम? बेगा नीक तिनदलाह विचर वायग़ा?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","अस्के येसु इर्वुर कग़यवालोरिन इद्रम वेहच लोहतोग़: “मीट येरुसलेम सहरते अन्ह्‌टु. अगा बेरा अळ्काते एग़ तवाल ओर्वोग़ मीक कलियनोग़, ओना पयाह अन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ओग़ बेद लोतगा दायनोग़, अद लोता माल्कान इद्रम वेहाटु, ‘नना कग़यवालोरा संगे आवना पंडुमता कुळ्प तिनदलाहि, उंद नाटोर रोमनद अरा बेगा मन्ह्‌ता इनजोर, गूरु नीक ताल्ह्‌किह्‌तोग़,’ इनजोर वेहाट. ");
INSERT INTO mrr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","अस्के ओग़ मीकु उंद लोता पोग़ोटा मद्लिते पूरा तयर कीस तासतद बेरा अरातुन तोहतनोग़. अगान माक पंडुमता कुळ्प तयर कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","पया वेर इर्वुर सहरते अतोर, अतस्के बेद्रम येसु ओरिन वेहच मतोग़, अद्रमलेह्‌काने सबे मता. मताह्‌कु वेर अगान पया आवना पंडुमता कुळ्पि तयर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","पया मुलतस्के, बारा बळयिरा संगे, येसु अद लोतगा वातोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","वासि ओर गाटो तिनदलाहि उदतस्के, येसु इतोग़, “इह केंजाट, नना मीक सेतेम वेहतह्‌नन, मियग्डाहि ओर्वोग़ नाक कोंटेतोरा कयदे पोस ईयनोग़. ओग़ इंजेके नावा संगे उदिसि, गाटो तिनदलाह आतोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","इदिन केंजिसि ओर नारज आतोर. पया ओर ओर्वोग़-ओर्वोग़ येसुन ताल्ह्‌क बोटटोर, “गूरु, ओनन नना बह आयोना?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","अस्के येसु ओरिन इतोग़, “मीट बारा मन्कलोरग्डाहिये, ओर्वोग़ इंजेक नावा संगे इद बट्किता पुलातगा आरिङ अह्‌चिस तिनवाल, नाक पोस ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","सास्त्रमते रासिस मतपु, माने-मन्कना नडुम पुटटोनन, नना इद दुनियाताहि पेसिस दाकन, निटमे! मति बोग़ नाक पोसीस्तोग़, ओना बेचोटा गोसा आयग़ा! ओग़ मन्कल पुटवेकेन बेस आस मनालि,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","पया ओर तिनजोरेन मतोर अस्के, येसु आरतुन पोसि, देवुळतुन जोहर कीसि किळ्हतोग़. अह कीसि ओरिह्‌क ईसोरे, “इद किळ्हतद आरतुन एनाटु, इद नावा मेंदुलता सीना आंदु. ताने नना मियेनाह्‌क मोकि ईय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ओसो ओग़ु बट्किता अंगुर जोमातुन पोसि देवुळतुन जोहर कीतोग़, कीसि ओरिह्‌क ईतोग़. ईतस्के ओर सबेटोर अद बट्किता जोमातुन उटोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","उटस्के येसु ओरिन इतोग़, “इद अंगुर जोमा नावा नेतुरता सीना आंदु. (देवुळ लोकुरा संगे कीयनद)करलतुन, इद नेतुरि निल्पिह कीस्ता. नावा नेतुरि वेल्‍लाटोरेनाह्‌क नेल वाङग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","इह केंजाट, नना मीक सेतेम वेहतह्‌नन, देवुळता राजेमते पूना रीतते अंगुर जोमा उनाह्‌जोमु, नेटाहि नना तेन बेस्केन उनोन आयकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","पया ओर देवुळतुन जोहर कीयनद पाटा ओसि, पलते जय्तुन मराना मेटातगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","अस्के येसु ओरिन इतोग़, “केंजाट, देवुळि इतदु सास्त्रमते इह रासतद मन्ह्‌ता: ‘नना कोपानु हव्ककन, अस्के गोरेङ बिरोबटो आयनुङ.’ मीट सबेटोरिर नाक विळ्सिस वितकिर, अस्के अद सास्त्रमता पोल्‍लो करल आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","मति नना हासि जीवा अरतापया, मीकाय मुने गालिल पटटे अन्ज मनदकन, (अगाने नना मीक कलियकन,)” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","इतस्के पत्रु इतोग़, “सबेटोर नीक विळ्सिस विततेकाय, नना इतेक नीक विळ्सिस वितोन आयकन गूरु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","येसु ओन इतोग़, “इह केंजा, नना सेतेम वेहतह्‌नन, नेंडे नग़्का रेंड मल्काङ तलाकोग़ कूसनामुने, बोराय ताल्ह्‌कतस्के, निमा येसुन पुनोन इनजोर मूंड मल्काङ इनदकिन,” इनजोर येसु पत्रुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","इतस्के पत्रु इंका ओसो जोरते इतोग़, “नाक नीवा संगे हामुर वातेकाय मति, नीक पुनोन इन्जि, नना मुर्तिय इनोन आयकन,” इनजोर इतोग़. सबेटोर वने वेनाङ केंजिसि अहे इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","पया येसु तनाङ कग़यवालोरा संगे, गेत्‍सेमनि इनदनद जागातगा अतोग़. अतस्के ओरिन इतोग़, “नना पार्तना कीयलाह दाय्ह्‌नन, अचानाह मीटु इगान उदिस मन्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अह इन्जि पत्रुन, याकुबिन, योहनिन, तना संगे ओतोग़. अस्के ओग़ पका दुकम आतोग़, ओना जीवा चुहेम आयो. ");
INSERT INTO mrr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","पया ओर मुवुरिन इतोग़, “नयगा पका बेरा मोता मन्ह्‌ता रा, अदिह्‌क नावा जीवा हायेङ-पिसेङ आसोर मन्ह्‌ता. मीट इगान मन्ह्‌टु, उंजवालेवा सीताते मन्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","इन्जि ओग़ु उचुन अबर अन्जि, नेल कप मुळ्न्दिसि, देवुळतुन इद्रम पार्तना कीतोग़, “निमा ‘इह कीकन तेला’ इन्ज इतेके, नाक इद गोसा आयमाकि,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ओसो इतोग़, “ए नावा बाबानिन! नीक सबे आया पग़यह्‌ता, इद गोसाताहि नाक पिसिह कीमु. तेला मति इद नावा विचरते आयो, नीवा विचर मतपे आयि,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","इन्जि कग़यवालोरगा वातोग़, अस्के ओर उंजिस मतोर. पया सिमोन पत्रुन तेहचि, इद्रम इतोग़, “ए सिमोन, निमा उंजिह्‌निना? गंटामेंड वने सीताते मनदा पग़विना? ");
INSERT INTO mrr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","नना वेहतप कीयलाह, मीवा जीवा तयरे मन्ह्‌ता, मति मीवाङ मेंदुस्कु इतेके, दीरालेवप बागतप मन्ह्‌ताङ. अदिह्‌के मीट सीताते मन्ह्‌टु, देयम मीवा पट ऊळनस्के, मीट पापमते अरयनायो इन्जि, देवुळतुन पार्तना कीसोर मन्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","पया ओग़ ओसोवने अन्जि, मुनेतलेह्‌काने पार्तना कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","कीसि ओसो ओरगा वास ऊळनेके, ओराङ कोंडाङ पकाय पूहतप आस मताह्‌कु, ओर गोडनिद्रते मतोर. अदिह्‌क येसु ओरिन तेहतह्‌पा, ओर ओन बाताले वेहता पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","पया ओसो मुचा केपाते ओरगा वासि इतोग़, “इंका उंजिसिय मह्‌निरा? इंका आरम कीसोरेन मह्‌निरा? इंजेक आता, ऊळाट, माने-मन्कना नडुम पुटटोनु, पाप्यहलोरा कयदे पोसीयनद कगो एवता. ");
INSERT INTO mrr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","तेदाट, माट ओरिन कलियलाह दाकल! नाक पोस एवाल इगा एरेन एवतोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","इव पोल्‍लोङ येसु वेहचोरेन मतोग़, अचोटेन यहुदाल (बळयिर बारा मुडग्डाहि ओर्वोग़ मन्ज तेला), पेर्मालोर, सास्त्रमगूरुर, यहुदिराङ पेदल्कु लोहता मुडुन पोसि वातोग़. ओरु तल्वर्क, गूटेङ-बळ्गाङ पोस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","येसुन पोस एवाल ओरिह्‌क इद सीना वेहच मतोग़, “नना बोन जोहर कीस लोंडकन, ओग़े आंदोग़, ओने पोसि उसरते ओम्ह्‌टु.” ");
INSERT INTO mrr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","पया यहुदाल अगा वाताहे, येसुनगा अन्जि इतोग़, “ए गूरु!” इन्जि ओन गोत ओग़्ङिस लोंडटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","अस्के ओर येसुना सर्ने आसि, ओन पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","अचोटेन येसुना एरे निच मनवाल, कग़यवाल ओर्वोग़ बाताल कीतोग़: ओग़ तना कसेटुन तेंडिसि, मोदुल पेर्माना ओर्युलतोन वग़ोन, केव पोडोह देगनाह ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","येसु पोयवालोरिन इतोग़, “बह मीट नाकु डाकु इनजोर तल्वर कसेह्‌कु, टेंगाङ पोस नाक पोयतलाह वातिरा? ");
INSERT INTO mrr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","नना इतेके दिनम मीवा संगे मन्जि, मंदिरतगा काग़्हचोर मंदन, अस्के मीट नाक पोयविर. मति देवुळता पवित्र सास्त्रमते नावा लोप्पा रासतव पोल्‍लोङ करल आयना इन्जि, नेंड इव गोटिङ आस्ताङ,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","पया सबेटोर कग़यवालोर येसुन विळ्सिस, पटादुळ विततोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","अस्के ओर्वोग़ लेयोग़ मन्कल गेंदे मुचिसि येसुना पयाह अनजोर मतोग़. अनेके लोकुर ओन पोयसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","मति ओग़ तना गेंदेतुन विळ्सिस, कूळलिय विततोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","पया ओर लोकुर येसुन मोदुल पेर्माना लोन ओतोर. अगा सबेटोर पेर्मालोरु, यहुदिराङ पेदल्कु, सास्त्रमगूरुर जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","मति पत्रु मोदुल पेर्माना रेसातगा एवनाहि, येसुनग्डाहि जेक मन्जि, पयाह पयाह अंदोग़. अन्जि पह्‌रातोरा संगे उदिसि, किस आग़सोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","अगा मतोर यहुदिराङ पेर्मालोर ओसो तग्वाङ केवालोर कतमतोर, येसुह्‌क बह कीसि हामुरता सिक्सा ईयलाह ऊळिंदुर. ओना अडमि कसुर पुटिह कीयलाहि, जोल साक्सि एवालोरिन ओर पर्ह्‌किस ऊळतोर, मति बोरे दोर्कोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","वेल्‍लाटोर येसुना अडम जोल साक्सि ईतोर, मति ओरा साक्सि उंदिय रीतलेह्‌का इले आसि. ");
INSERT INTO mrr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","पया उच्वुर मन्कलोर निचि, येसुना अडम इद्रम जोल साक्सि ईया बोटटोर इतेके, ");
INSERT INTO mrr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“‘नना मन्कलोर दोहतद देवुळता मंदिरतुन विर्हचि, तान मूंड दियाने मन्कलोर दोहवद, दुस्रा मंदिरतुन दोहतकन,’ इनजोर वेग़ वेहतह्‌पा माट केंजतोम,” इद्रम साक्सि ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","तेला मति ओरा साक्सि उंदिय रीतलेह्‌का इले आसि. ");
INSERT INTO mrr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","पया मोदुल पेर्माल नडुम निचि, येसुन इद्रम ताल्ह्‌कतोग़, “वेर नीवा अडम बेद्रम साक्सि ईस्तोर, ऊळा! निमा बातय बाराह्‌क वळ्ह्‌कविन?” ");
INSERT INTO mrr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","मति येसु उंदाय पोल्‍लो वळ्ह्‌कवा, केमेन मतोग़. पया ओसो मोदुल पेर्माल इद्रम ताल्ह्‌कतोग़, “निमा देवुळता मग़ि किर्स्तुनिना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","इतस्के येसु इतोग़, “इंगो, ननाने! इद वने पोल्‍लो केंजाट, नना माने-मन्कना नडुम पुटटोनन मताह्‌कु, बेरा डीसातद देवुळता तिनळ बाजे अन्ज उदतदिन, ओसो नना मोयुलपोग़ोन वायनदिन मीट ऊळकिर,” इनजोर येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","इदिन केंजिसि, मोदुल पेर्माल (पका नारज आतन इन्जि तोहतलाह,) तना कोटजगातुन ओङिह्‌क अग़्हचि इतोग़, “इंजेके माक ओसोवने बाराह्‌क साक्सिङ गावले? ");
INSERT INTO mrr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","वेग़ देवुळतन इतपु, देवुळतुन पास्कतदिन, मीट इतेक इंजेके केंजतिरे. मीवा इंजेक बाताल विचर मन्ह्‌ता?” इनजोर पेर्माल इतोग़. “वेग़ हामुरता सिक्सातुह्‌क ओजनोग़!” इन्जि, ओर पेदल्क नेयम देहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","पया उच्वुर मन्कलोर बार, येसुना पोग़ोन उस्कतोर, उच्वुर बार कोंडान दोहचि ओन नल्हतोर, ओसो “इंजेक देवुळता जीवाते वेहा रा! नीक बोग़ नल्हतोग़?” इतोर. पह्‌रातोर वने येसुन पोसि चापुळ ईतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","पया इद्रम आनेके, पत्रु इळ्न रेसातगान उदिस मतोग़. अस्के मोदुल पेर्मानाङ ओर्युल आस्कनग्डाहि, उंद ओर्युलतदु अगा वाता. ");
INSERT INTO mrr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","वासि पत्रु किस आग़नद ऊळता. पया ओन बेस ऊळिसि, “निमा वने ओग़ नासरेत नाटेनोग़ येसुना संगे मतिन, अय?” इता. ");
INSERT INTO mrr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","इतस्के पत्रु तान इतोग़, “निमा बार इह्‌निन, नाक तेळियो, नना पुनोन,” इतोग़. पया ओग़ु रेसाता अग़दगा अतोग़, अस्के कोग़ कूसता. ");
INSERT INTO mrr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","अद ओर्युलतद ओन ऊळिसि, अगा निच मतोरिन ओसो, “वेग़ वने ओनाय संगतोग़ आंदोग़,” इता. ");
INSERT INTO mrr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","इतस्के पत्रु “नना आयोन” इतोग़. पया गळ्क मनेके, अगा निच मतोरु ओसो पत्रुन इतोर, “निमा कोन निटमे ओनाय संगेतोनिन! निमा गालिल पटटोना लेह्‌का वळ्ह्‌किह्‌निन, (अदिह्‌क माट पुह्‌नोम,)” इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","अस्के पत्रु इतोग़, “नना किरिया कीस वेहतह्‌नन, नावा पोल्‍लो जोल आतेके, देवुळ नाक तिनि! मीट वळ्ह्‌किह्‌निर ओग़ मन्कन, नना मुर्तिय पुनोन!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","अचोटेन दुस्रा मल्का तलाकोग़ कूसता. अस्के येसु पत्रुन मुनेन इह वेहच मतोग़, “नेंडे नग़्का रेंड मल्काङ तलाकोग़ कूसनामुने, बोराय ताल्ह्‌कतस्के, निमा मूंड मल्काङ येसुन पुनोन इनजोर कैंगम आयकिन,” इनजोर वेहच मतद पोल्‍लो पत्रुह्‌क सीता वाता. पया पत्रु इद पोल्‍लोतुन आलिह कीसि, अळया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","पया पिङपङ आनेकेने, पेर्मालोरु यहुदिराङ पेदल्कु, सास्त्रमगूरुर ओसो पंच उदवालोर सबेटोर उदिस वळ्ह्‌कतोर. अह कीसि, येसुन दोहता वेहतोर, दोहचि पिलाति इनवाल गुमसिनगा ओसीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पया पिलाति येसुन, “बह निमा यहुदिरा राजानिना?” इनजोर ताल्ह्‌कतोग़. पया येसु ओनु, “निमा इह्‌निन अहे,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","अस्के पेर्मालोर येसुना पोग़ोन वेल्‍लाङे पोल्‍लोना कसुर्क वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","अदिह्‌क पिलाति येसुन ओसो ताल्ह्‌कतोग़, “ऊळा, वेर नीवा पोग़ोन इचोक पोल्‍लोनाङ कसुर्क वाटलाह आतोर, निमा बाताले पोल्‍लो वळ्ह्‌कविना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","मति येसु बाताले वळ्ह्‌कोग़. इदिन ऊळिसि पिलाति बयल आतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","वर्सामेटा आवना पंडुमतस्के, जेलतगा मनवाल बोनाय वग़ोनु, यहुदि लोकुर बोन विळ्सा इनजोर वेहन्दुर, ओन गुमसि पंडुमता दियाते विळ्सिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","बरबसि इनवाल मन्कल, तना तोळतोरा संगे जेलते मतोग़. ओग़ तना तोळतोरिन पोसि, रोम सर्करतोरा संगे विरुद आसि, मन्कलोरिन हव्किस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","पया लोकुर पिलाति गुमसिनगा वासि, “वर्सामेटा पंडुमतस्के जेलते मनवाल ओर्वोग़ मन्कन, मयेनाह्‌क विळ्सना लेह्‌का, इयेंड वने विळ्सिसीम,” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलाति ओरिन इतोग़, “मीट इह्‌निर इतेके, मियेनाह्‌कु यहुदिरा राजान विळ्सकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ओग़ अद्रम बाराह्‌क इतोग़ इतेके, (येसुना पयाह अनवालोर बोल्गसोर दास्तोर इन्जि,) वेर पेर्मालोरा जीवा कर्वताह्‌के, येसुन नयगा पोस ततोर इनजोर, पिलाति पुन्ज मतोग़. अदिह्‌क ओग़ अद्रम इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","मति पेर्मालोरु, “मयेनाह्‌क बरबसिन विळ्सा इनजोर, माट गुमसिन इनदकल,” इन्जि लोकुरिन पका तग़्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","इदिन केंजिसि गुमसि ओसो ताल्ह्‌कतोग़, “अह इतेके यहुदिरा राजाल इनजोर, मीट वेन ततिर, वेन नना बाताल कीकन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“वेन हव्कनागुटातगा वेळ्हा!” इनजोर लोकुर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","अस्के “बाराह्‌कु? वेग़ बाताल कसुर कीतोग़?” इनजोर गुमसि इतोग़. मति ओर इंका एक्‍वाये, “वेन हव्कनागुटातगा वेळ्हा!” इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पया लोकुरिन गिर्दा कीयना विचरतेनाह्‌क, गुमसि बरबसिन ओरेनाह्‌क विळ्सिसीतोग़. येसुन बार ओग़ जेट्लाते नल्‍हता वेहचि, हव्कनागुटातगा वेळ्हतलाहि, सीपय्कना कयदे ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","पया सीपय्कु येसुन गुमसिना लोता लोप्पाडा रेसाते ओतोर. अगा ओतस्के, पूरा पल्टनतुन केयिसि जमा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","कीसि येसुन राजाल इनजोर पास्कलाहि, ओन डुंगा पंड रंगता जगा केग़्‍पिह कीतोर, ओसो कोयेना गीळ पंडिसि, ओना तलातगा गळ्म कीतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","पया “ए यहुदिरा राजानिन, नीक जोहर आयि!” इन्जि पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ओसो ओरु येसुना तलातुन डुडटे नल्हतोर, ओना पोग़ोन उस्कतोर, ओना मुनेह मिंडाङ कोटिस जोहर कीसोर पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","पया ओन उस्किस-पास्किस मारतस्के, तमा केग़्‍पिह कीतद डुंगा पंड रंगता जगातुन तेंडिसि, ओनाये जगा केग़्‍पिह कीतोर. अह कीसि, ओनु हव्कनागुटातगा वेळ्हतलाह पलते ओतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","पया येसुन सीपय्क सहरता पलते ओसोर मतोर, अस्के सिकंदर ओसो रूपुसि, वेरा तपे सिमोन इनवाल, तना कुरेने नाटेनाहि मल्स वासोर मतोग़. येसुह्‌कु गुटातुन कांजलाह दीरा वावाह्‌कु, वेर सीपय्कु येसुना हव्कनागुटातुनु कांजलाह, सिमोनिन पोसि बीगर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","पया ओरु येसुन गुल्गुता इनदनद जागातगा ओतोर. (गुल्गुता इद पेदिरता अर्तम इतेके “तला-टाप्राता जागा” इद्रम आस्ता). ");
INSERT INTO mrr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","अस्के (येसुना मेंदुदुह्‌क नोयनद पुनदनायो इन्जि,) ओरु अंगुर जोमातगा मत काल्ह्‌पिसि, येसुह्‌क ईस ऊळतोर, मति ओग़ तान उनोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","पया सीपय्क येसुन हव्कनागुटातगा कय्किन-काल्किन मोल्‍लाङ कोटटोर, ओसो ओनाङ गेंदेनु, बोन्कु बाताल गावले, अदिन ओयना इनजोर, सीटिङ वाटिसि तूसतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","येसुन हव्कनागुटातगा वेळ्हतोर, अस्के सकरताङ नव एगिस मता. ");
INSERT INTO mrr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“वेग़ यहुदिरा राजाल आंदोग़” इन्जि, इद्रमता कसुर बलाते रासिसि, ओना तलापोग़ोन वेळ्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ओसो येसुना संगे इर्वुर डाकुरिन, वग़ोन ओना तिनळ बाजे, वग़ोन बार दावळ बाजे, इद्रम हव्कनागुटातगा वेळ्हतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","अस्के देवुळता सास्त्रमतगा “लोकुर ओनु अडोङ देहतोग़ु इंदुर,” इनजोर रासतद पोल्‍लो करल आता. ");
INSERT INTO mrr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","पया अग़ पोस अनवालोर तलाङ ओलिह कीसोरे, ओन इहलेह्‌का उस्किस-पास्किस वळ्ह्‌किंदुर, “ओ! मंदिरतुन विर्हचि, मूंड दियाने दोहवानिन! ");
INSERT INTO mrr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","हव्कनागुटातग्डाहि रेगिसि, निमा नीवाय जीवातुन पिसिह कीम!” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","अहे पेर्मालोर, सास्त्रमगूरुर वने पास्कसोर इद्रम इतोर, “वेग़ दुस्रोरिन विळ्सिह कीतोग़, मति तन्क विळ्सिह कीया पग़वोग़. इस्रयेलतोरा पिसिह केवाल किर्स्तु राजाल मन्ह्‌तोग़ इतेके, हव्कनागुटातग्डाहि इळ्न रेगेग़. अस्के माट ओन ऊळिसि नमकोम!” इतोर. ओसो येसुना संगे हव्कनागुटानगा वेळ्हच मतोर डाकुर वने, ओन पास्किंदुर. ");
INSERT INTO mrr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","पया नेक नितग्डाह इतेके, पियलि मूंड एगनाह्‌जोम, देसेममेंड कतम ईकळ पोयता. ");
INSERT INTO mrr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","पियलि मूंड एगनेके, येसु बेरा आल्काते इह इतोग़, “एलि, एलि, लमा सबग़्‍तनि!” (तेना अर्तम इह मन्ह्‌ता: नावा देवुळतिन, नावा देवुळतिन, निमा नाक बाराह्‌क विळ्सिसीतिन?) ");
INSERT INTO mrr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","अगा निच मतोरग्डाहि उय्तुरिह्‌क, (येसु केयतद पोल्‍लो तेळियवाह्‌कु,) “ऊळाट! ओग़ एलियाल इनवाल मुनेतोग़ कबुरतोनु केयलाह आतोग़!” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","अस्के ओर्वोग़ वितिस अन्जि, बूबिलतुन कयतद अंगुर जोमातगा मुळ्हचि, लाटटे कोडटगा तासिसि, ओन्क उनडलाह ईतोग़. अचोटेन बोग़ो इतोग़, “मनि रा! एलियाल ओन पिसिह कीयलाह वास्तोग़ा, वायोग़ा, ऊळकल,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","अस्के येसु जोरते केयिसि हातोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","(इंजेके येरुसलेमता मंदिरतग्डा पवित्र गूडटा अग़दगा, गेंदे अडह कीस मता; अद गेंदे अडम मताह्‌कु, लोकुर देवुळतुन गट्ने कलिय पग़वोर आंदुर.) पया येसु हातस्के, मंदिरता अद गेंदे, पोग़ोटाहि इळ्न एवनाहि, पग़्क वितिसि रेंड तुक्ळेङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","अस्के येसुना मुनेह सीपय्कना दरोगाल निच मतोग़. येसु इद्रम केयिस हातदिन ऊळिसि, “वेग़ मन्कल निटमे देवुळता मग़ आंदोग़!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","उचुक आस्क वने, जेक निचि ऊळसोर मताङ. अव आस्कनग्डाहि मग्डला नाटेनद मरियालि, उड्लोग़ याकुब, योसेस, वेरा तलोग़ मरियालि, ओसो सलमि इव आस्क मताङ. ");
INSERT INTO mrr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","येसु गालिल पटटे मतस्के, इव आस्कु ओना पयाह अन्जि सेवा कींदुङ. ओसो अगा वेल्‍लाङे आस्कु, ओना संगे येरुसलेमते वास मतव मताङ. ");
INSERT INTO mrr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","वारमता पोल्वादियातेनाह्‌क तयर आयनद दियाते येसु हातोग़. अस्के बह्‌ट अर्स मता. पया बाताल आता, यहुदिराङ तग्वाङ केवालोरग्डाह ओर्वोग़ मतोग़, अरिमतेया नाटेनोग़ योसेपि पेदिरतोग़ु. लोकुर ओन मान ईंदुर. ओग़ु देवुळ राजेम कीयनद दिया बेस्के वास्ता इनजोर, अग़ ऊळसोर मंदोग़. गळ्क इतेके पोळ्‍द अरयनस्के वारमता पोल्वादिया सुरु आयग़ा इनजोर, ओग़ दीराते गुमसि पिलातिनगा अन्जि, “येसुना सेत्तातुन पोहतलाह ओयकन,” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","अस्के पिलाति, “अरे! इचोन जल्दि हातोग़ा?” इन्जि बयल आतोग़. पया सीपय्कना दरोगान केयिसि, “येसु हातोग़ा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","येसु हातोग़ इनजोर ओग़ दरोगाल वेहतस्के पया, पिलाति सेत्तातुन ओयलाह योसेपिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","वेहतस्के पया योसेपि उंद पूना पांड्रि हामुर-गेंदे असतोग़. असिसि येसुना सेत्तातुन इळ्न रेहचि, अद गेंदेते ऊर्हतोग़. पया बेरा आदतगा तर्वतद उंद गुमयातगा ओसि, गति कीतोग़. अह कीसि गुमयाता अग़दगा बेरा आद बंडातुन तिळ्ह्‌प कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मग्डला नाटेना मरियालि ओसो योसेसना तलोग़ मरियालि, सेत्तातुन गति कीतद जागातुन ऊळताङ. ");
INSERT INTO mrr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","वारमता पोल्वादिया मारता, अस्के मग्डला नाटेनद मरियालि, याकुबना तलोग़ मरियालि ओसो सलमि, इवु येसुना सेत्तातगा वाटलाहि अतर्नेय असताङ. ");
INSERT INTO mrr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","इमा दिया (इतेके ऐतारम दियाते), सकर पङपङ आसोरे, अव गुमयातगा वाताङ. ");
INSERT INTO mrr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","वानेके तमतमाय इंदुङ, “बोग़ माक गुमयातुन तिळ्ह्‌प कीतद बंडातुन तेंडिसीयनोग़ रि?” इंदुङ. ");
INSERT INTO mrr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","पया एरे एवनेके गुमयातुन ऊळताङ. ऊळनेके गुमयातगा तिळ्ह्‌प कीतद बंडा पका बेरा मता, मति अद बंडातुन अबर गूळ्हतद मता. ");
INSERT INTO mrr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","पया अव आस्कु लोप्पा ओळियताङ. अस्के ओर्वोग़ लेयोग़, पांड्रि जगा केग़्सि तिनळ बाजे उदिस मतदिन, अव ऊळताङ. ऊळिसि गाबरेम आताङ. ");
INSERT INTO mrr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","अस्के ओग़ अविस्किन इतोग़, “गाबरेम आयमाट! हव्कनागुटातगा वेळ्हतोनु, नासरेत नाटेनोग़ येसुन पर्ह्‌कलाह आतिर. ओग़ जीवा अरतोग़, इगा इलेग़. इद ऊळाट, ओना सेत्तातुन तासिस मतद जागा, ओन इगान तासिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","इंजेक मीट पत्रुनगा ओसो दुस्रोर ओनाङ कग़यवालोरगा अन्जि, ओरिन इद्रम वेहाट, ‘ओग़ मीक वेहतप लेह्‌का, इंजेक मीवा मुनेन गालिल पटटे दायलाह आतोग़, अगान ओन कलियकिर,’ इन्जि वेहाटु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","अव आस्क पया पका रेयिस मताङ. अविस्कनाङ जीवाङ दिरदिर साङिंदुङ. अदिह्‌क अव गुमयातग्डाह पेसिसि वितताङ. पका रेयिस मताह्‌कु, अग़दे बोने वेहोङ.  ");
INSERT INTO mrr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ऐतारम पङ वियतस्के, येसु हामुरताहि तेग़्कतोग़. तेग़्कतस्के सुरुमुने मग्डला नाटेना मरियालिह्‌क दिसतोग़. मुने येसु तानग्डाहि एळुङ देयह्‌किन पेसिह कीस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","दिसतस्के अद अन्जि, येसुना संगे मंदुर ओर मन्कलोरिन वेहता. ओर दुकम आसि अळसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","येसु जीवा अरतोग़, मरियालि ओन ऊळता इनजोर केंजतोर. मति अद पोल्‍लोतुन ओर सेतेम पोयोर. ");
INSERT INTO mrr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ताना पया, मुने येसुना संगे मतोर इर्वुर मन्कलोर, येरुसलेमताहि नाग़ अनजोर मतोर. अस्के येसु ओरिह्‌क दिसतोग़. इद मल्का येसुना रूप मिळ्न्दिस मता. ");
INSERT INTO mrr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","पया (ओग़ येसुये आंदोग़ इनजोर पुतस्के,) वेर इर्वुर मल्स अन्जि, येसुना संगे मतोर दुस्रोरिन वेहतोर. मति वेरा पोल्‍लोतुन वने, ओर सेतेम पोयोर. ");
INSERT INTO mrr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","पया अक्रा बळयिर उदिसि गाटो तिनजोर मतोर, अस्के येसु ओरिह्‌क दिसतोग़. दिसिसि इद्रम इतोग़, “नना तेग़्कतस्के नाक ऊळतोर मन्कलोरा पोल्‍लोतुन बाराह्‌क नमविर? नमोम इनजोर बाराह्‌क कैंगम आतिर?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","पया ओसो इतोग़, “मीट पूरा बूममेंड अन्जि, नावा बेसता कबुरतुन सबेटोरिह्‌क पोकुर कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","नावा पोल्‍लोतुन विस्वस कीसि, नावा पेदिरते एग़ मीतोरिन, देवुळि पिसिह कीयग़ा. मति विस्वस केवोरिन, ओरा पापमतेनाह्‌क सिक्सा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","नावा पोल्‍लोतुन विस्वस केवालोर मन्कलोरा कयदे, देवुळता लावताङ इव सीनाङ आयनुङ: नावा पेदिरते देयह्‌किन पेसिह कीयनुर, तमा पुनवव बासाङ वळ्ह्‌कनुर. ");
INSERT INTO mrr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","तरस्किन तमाङ कय्कने पोयनुर, ओसो हव्कनद वीसम उटेक वने, ओरिह्‌क बाताले आयो. ओसो ओर तमाङ कय्क बेमरतोरा पोग़ोन तासतेके, ओर सव्रेम आयनुर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","पया येसुसामि ओरिन इव पोल्‍लोङ वेहतापया, देवुळि ओन पोग़ोन तना जागातगा ओता. येसु पोग़ोन अतोग़ अस्के, देवुळता तिनळ बाजे उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","पया येसुनाङ कग़यवालोर सबेटोर सबे जागाने तिरियसोर, ओना पोल्‍लोतुन पोकुर कीतोर. सामि ओरा तोळ मताह्‌कु, ओरा कयदे देवुळता लावताङ सीनाङ आंदुङ. ओर वेहतव पोल्‍लोङ निटमे इनजोर अव सीनाङ तोहंदुङ.आमेन.");
INSERT INTO mrr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","तियुपिलु साय्ब! माटु येसुसामिना सेवकिरोम आंदोम; सास्त्रमते ओना लोप्पा मुनेन रासतपु, ओग़ मावा नडुम वेल्‍लाङे कबस्क कीतोग़. अव कबस्किन इंजेके वेल्‍लाटोर रासलाह आतोर. अव पोल्‍लोन मुनेटाहि ऊळतोरु, केंजतोरु, वेर पोकुर कीतोर, ओसो माक वने वेहतोर. येसुसामिनाङ सबे पोल्‍लोङ मुनेटाहि बेद्रम आताङ इनजोर, नना वने बेस पर्ह्‌किस ऊळतन. निमा ओना लोप्पा बाताल बाताल कग़यतिन, अव सबे पोल्‍लोङ सेतेम मन्ह्‌ताङ इन्जि निमा पुनदना, अदिनेनाह्‌क अविस्किन इंजेक ओर्कुलते नियेनाह्‌क रासलाह आतन. ");
INSERT INTO mrr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","बेरोग़ एरोद राजाल यहुदि जाततोरा बूमता राजाल मतोग़, अस्के अगा ओर्वोग़ जकरिया पेदिरतोग़ यहुदि जातता बूमयाल मतोग़, ओग़ अबिया मुय्तोना तुंगातोग़ आंदोग़. ओना मुतेना पेदिर इलीसिबा आंदु, अद वने ओना लेह्‌का आरुन पेर्माना कूळता मता. ");
INSERT INTO mrr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वेर आळ इर्वुर आसि देवुळता मुनेह कर्तुळते मतोर. देवुळताङ सबे अडोङ-उतुर्किन, तपवालेवा माळसोर ताकिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","मति इलीसिबाल वंजो मताह्‌कु, ओरिह्‌क पिलाङ-पेकोर इलेर. ओसो वेर आळ इर्वुर आसि, पका सेळो-मुय्तोग़ आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","मनेक मनेक पया उंद दिया इद्रम आता इतेके, (येरुसलेम सहरता मंदिरतगा) अबिया तुंगातोर बूमयालोरा कबळ कीयनद वारम मता. अस्के जकरिया मुय्तोग़ वने देवुळता मंदिरतगा अन्जि, बूमया कबळ कीसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","बेद्रम इतेके, बूमयालोरा रीतता लेह्‌का बोग़ मंदिरता पवित्र गूडटे अन्जि, बूमयाना कबळते दूपम बोळ्सनोग़ इनजोर, सीटिङ वाटिसि जकरिया मुय्तोन आचतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","पया ओग़ लोप्पा दूपम बोळ्सिह्‌पा, सबेटोर पलते मंदिरताङ मंडानगा पार्तना कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","अचोटेने मंदिरता लोप्पा देवुळता उंद देवतुलि, दूपम बोळ्सनद जागाता तिनळ बाजे नितद, जकरिया मुय्तोह्‌क दिसता. ");
INSERT INTO mrr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","अस्के ओग़ तान ऊळिस, एक्बेक आसि पका रेयतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पया देवतुल ओन इता, “जकरिया! रेयमा, निमा बेद पोल्‍लोतेनाह्‌क पार्तना कीसोर मतिन, अद पोल्‍लोतुन देवुळ केंजता. नीवा मुते इलीसिबा सेळो नेलाङ हव्कग़ा; तान्क ओर्वोग़ पेकाल पुटनोग़. ओग़ पेकाना पेदिर योहन(इतेके ‘देवुळि देय्वा ईस्ता’) इनजोर तासकिन. ");
INSERT INTO mrr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ओग़ पेकानेनाह्‌क निमा पका गिर्दा आयकिन, सुकम आयकिन. नीवा मग़ि पुटटोग़ इनजोर, वेल्‍लाटोरे गिर्दा आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","बाराह्‌क इतेके ओग़ देवुळता विचरते बेरोग़ मनदनोग़. ओग़ बेस्केन अंगुर जोमातुन ओसो बेदे ओचिह कीयनदिन वडोग़ आयनोग़. ओसो तना तलिना पोटालोप्पाडाहिये, देवुळता पवित्र जीवाते निंदनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ओग़ मीवा वेल्‍लाटोर इस्रयेल लोकुरिन तमा देवुळतके मल्हच ततनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","तपेर तमाङ पिलाङ-पेकोरिन बेस जीवा वाटनाह कीयनोग़, देवुळता पोल्‍लो केंजवोरिन सेतेम बुदतेके ओयनोग़. लोकुरिन सामि वायनदिनेनाह्‌क तयर कीयलाह, अद्रम कीयनोग़. एलिया मुय्तोह्‌क बुदि ओसो लाव ईतप लेह्‌का, ओन्क वने अदे लाव ईयग़ा. ओसो सामि वायनामुने, सामिना कबुरतुन मुनेह-मुनेह वेहचोर दायनोग़,” इनजोर देवतुल इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","अस्के जकरिया मुय्तोग़ इतोग़, “नीवा पोल्‍लो निटम आयग़ा इनजोर, निमा बेद्रम तोहतकिन? नना इतेके मुय्तोनन आतन, नावा मुते वने सेळो आसि, बेद्रम नेलाङ हव्कग़ा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","अस्के देवतुल इता, “(निमा नाक पुनविन बहे, मति) नावा पेदिर जिबरायिल आंदु, नना देवुळता मुनेह निच मनवानन आंदन. नीवा संगे वळ्ह्‌कलाह ओसो इद बेसता कबुरतुन वेहतलाह, अदे नाक लोहता. ");
INSERT INTO mrr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","नना वेहतद पोल्‍लो तना कगोते निटम आयग़ाये, मति निमा नावा पोल्‍लोतुन विस्वस केविन. अदिनेनाह्‌क नावा पोल्‍लो निटम आनाह्‌जोम, निमा वळ्ह्‌क पग़वाह मूकानिन आस मनदकिन,” इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","इद्रम आनेके, पलते निचि मोळ्कवालोर, जकरिया मुय्तोनेनाह्‌क केपिसि, “वेग़ बेलाह इचोन आल्सेम कीस्तोग़ रा!” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","पया जकरिया मुय्तोग़ मंदिरताहि पलते पेसतोग़, पेसतस्के ओग़ ओरा संगे वळ्ह्‌क पुनोग़. अस्के मंदिरता लोप्पा देवुळि वेन्क बेदो लेका तोहताह्‌कु वळ्ह्‌क पुनोग़ इनजोर, ओर पुतोर. जकरिया मुय्तोग़ मूकाल आस मताह्‌कु, कयदा साया कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","पया तनाङ सेवाताङ दियाङ मारतस्के, ओग़ तना लोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","अतस्के पया, तना मुते इलीसिबा सेळो नेलाङ हव्कता, नेलाङ हव्कतस्के एयुङ नेलाङ आनाहि, लोताह पलते पेसो आस मता. ");
INSERT INTO mrr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","अद इद्रम इता, “नाक वंजो इनजोर लोकुर पास्किंदुर, मति लोकुरा नडुमि नावा लजा पोवयनायो इनजोरे, देवुळि इंजेक नाक इद्रमलेह्‌का देय्वाते ऊळता; (ओसो पास्कनद पोल्‍लोतुन माय्‍पिह कीसीता,)” इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","अद्रमलेह्‌काने पया गालिल पटटा नासरेत नाटेनगा इद्रम आता इतेके, उंद मरियाल पेदिरता कुव्रा लेया पिला मता. ताना संगे मर्मिङ आयलाहि, योसेप पेदिरतोग़ पेकाल ताल्ह्‌किस पोल्‍लो करल कीस मतोग़, ओग़ दाविद राजाना कूळतोग़ मतोग़.(इलीसिबा सेळो नेलाङ हव्किस) आरुङ नेलाङ आतस्के, देवुळि तना देवतुल जिबरायिलिन नासरेत नाटेनगा लोहता. ");
INSERT INTO mrr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","लोहतस्के देवतुल अद पिलातगा अन्जि, “जोहर, देवुळता देय्वातदिनिन! देवुळ नीवा तोळ मन्ह्‌ता,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","इद पोल्‍लोतुन केंजिसि, मरियाल पका एक्बेक आता, आसि इद पोल्‍लो वेहच, बाराह्‌क नाक जोहर कीयलाह आता इन्जि, अद आलिह कीयलाह आता. ");
INSERT INTO mrr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","अद आलिह कीनेके, देवतुल इता, “मरिया, देवुळि नीक देय्वा ईसि नीक आचता, निमा रेयमा. ");
INSERT INTO mrr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","केंजा! निमा नेलाङ हव्ककिन अस्के, नीक पेकाल पुटनोग़, ओना पेदिर निमा येसु (इतेके ‘सामि पिसिह कीस्ता’) इनजोर तासकिन. ");
INSERT INTO mrr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ओन सबेटोर बेरा डीसाता देवुळता मग़ि इनदनुर, अचोन ओग़ बेरोग़ मन्कल आयनोग़. ओना कूळता मुनेतोग़ पेदामुय्तोग़ दाविद राजाना लेह्‌का, देवुळि ओन वने राजाल कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","(नीवा पोटाते पुट वावाल पेकाल,) इस्रयेल देसेमतोरगा राजेम कीयनोग़. ओना राजेम बेस्केन मारो आयग़ा,” इनजोर वेहता. ");
INSERT INTO mrr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","वेहतस्के मरियालि, “इद बेद्रम निटम आयग़ा? नना इतेके कोय्तोना मोकम वन ऊळोन, (कुव्रा पिलातन आंदन,)” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","इतस्के देवतुल इता, “देवुळता पवित्र जीवा नीवा पोग़ोन रेगग़ा, बेरा डीसाता देवुळता दळ्म नियगा अरताह्‌कु, निमा नेलाङ हव्ककिन. अदिनेनाह्‌क नियगा पुटवाल पवित्र पेकानु, देवुळता मग़ि इनदनुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ओसो ऊळा, नीवा जीवातद इलीसिबाल सेळो वने, इंजेक नेलाङ हव्कता. लोकुर तान वंजो इनजोर इंदुर, मति इंजेके अद नेलाङ हव्किस आरुङ नेलाङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","देवुळता कयदे आया पग़वद बाताल मन्ह्‌ता?” इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","इतस्के मरियाल इता, “ऊळा, सामिना सेवा कीयनदिनन आंदन, निमा वेहतपे नाक आयि,” इता. पया देवतुल तानग्डाहि पेसिस अता. ");
INSERT INTO mrr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","पया अवे दियाने मरियालि बाताल कीता इतेके, चट्पिटे यहुदा पटटा मेटा बूमतगा मनदनद इलीसिबा सेळोना नाग़ अता. ");
INSERT INTO mrr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","नाटेनगा एवतस्के जकरिया मुय्तोना लोन अन्जि, इलीसिबा सेळोन कलियिसि “देवुळ नीक सुकम ईयि!” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","मरियाल इतद पोल्‍लोतुन केंजताहे, इलीसिबाना पोटातगा मतद पेनेम पार्ह्‌कता. अस्के अद सेळो देवुळता जीवाते निंदता. ");
INSERT INTO mrr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","निंदतस्के अद मरियान ऊळिस जोरते केयसोर इता, “सबे आस्किह्‌काय निमाने एक्‍वा देय्वातदिनिन मरिया, नीवा पोटातगा मनदनद पेनेम वने पका देय्वाता. ");
INSERT INTO mrr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","अलो देवन, नावा सामिना तलोग़ नाक ऊळलाह वायना, इद्रमता देय्वा नाक बेग्डाह दोर्कता! ");
INSERT INTO mrr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ऊळा, नीवा लेङतुन केंजताहे, नावा पोटाता पेनेम गिर्दाते पार्ह्‌कता. ");
INSERT INTO mrr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","निमा बेरा देय्वातदिनिन मरिया, बह इतेके देवुळ नीक वेहतद पोल्‍लोतुन निटम आयग़ा इन्जि विस्वस कीतिन,” इनजोर इलीसिबा सेळो इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","अस्के मरियाल इद्रमता पाटा वाग़ता, “नना पूरा जीवाताहि देवुळतुन जोहर कीय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","नाक पिसिह कीयनद देवुळि नावा जीवात्क बेस गिर्दा ईस्ता. ");
INSERT INTO mrr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ऊळा, इंजेटाहि अमेसा लोकुर नाक देय्वातद इनदनुर, देवुळि तना उड्ला ओर्युलतदिन बेचोन बेस सीता कीता! ");
INSERT INTO mrr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","पका डीसाता देवुळि नयेनाह्‌क बेरा कबळ कीता, ताना पेदिर पवित्र आंदु. ");
INSERT INTO mrr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","बोर देवुळतुन रेयिस ताकिह्‌तोर, ओरा पोग़ोन ताना दया अमेसा मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","देवुळि तना लाव तोहता, ओसो माट बेरोरोम इनवालोर पोमाडेङेरिन बिरोबटो कीता. ");
INSERT INTO mrr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","बेरोर मुक्यालोरिन तमाङ कुर्सिनाहि इळ्न रेहता, पोहचीतप मतोरिह्‌क बार मान ईता. ");
INSERT INTO mrr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","लेवोरिह्‌क बार बेसतल-बेसतल माल ईता, मता मन्कलोरिन बारा वेट्‍टाङ कय्क लोहचीता. ");
INSERT INTO mrr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","मावाङ तादोर-बाबोरिह्‌क पोल्‍लो विळ्सतप लेह्‌काने, तना सेवकिर इस्रयेल मन्कलोरिह्‌क तोळ ईता. इतेके अब्रहम मुय्तोन ओसो ओना सबे जालपिलतुन ऊळिस, दया कीयनदिन सीता कीता,” इनजोर पाटा वाग़ता. ");
INSERT INTO mrr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","इद्रम मरियालि मूंड नेलाङ आनाह्‌जोम, इलीसिबा सेळोना लोन मता, ताना पया तना लोन मल्स अता. ");
INSERT INTO mrr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","पया इलीसिबा सेळोना रिकम आयनद कगो एवता. एवतस्के तान्क ओर्वोग़ पेकाल पुटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","अद रिकम आतस्के, ओरा एरे-गूरेतोर ओसो जीवातोर केंजतोर. केंजिसि देवुळि ताना पोग़ोन बेरा दया कीता इनजोर, ओर वने पका गिर्दा आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","पया पेकाल पुटिस आट दियाने, ओन देवुळता अडो मतपु डायना रिवज कीयलाहि वेर वातोर. वासि ओग़ पेकाना पेदिर जकरियाल इनजोर, तपेना पेदिरतुन तासना मता. ");
INSERT INTO mrr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","मति पेकाना तलोग़ि “आयो रा, वेग़ पेकाना पेदिर योहन मनदग़ा,” इता. ");
INSERT INTO mrr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","अस्के “इंगो मति मीवा कुट्मळते इतेके, इद पेदिरतोग़ बोग़े इलेग़ अले,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","पया कय सायाते पेकाना तपेन इद्रम ताल्ह्‌कतोर, “निमा वेग़ पेकाना पेदिर बाताल तासलाह ऊळिह्‌निन?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","अस्के पेकाना तपे रासलाह पाटि ताल्ह्‌किसि, “वेना पेदिर योहनिय मनि,” इनजोर अगा रासतोग़. (“ए! वेग़ वने अदे पेदिर रासतोग़ रा!” इनजोर) सबेटोर बयल आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","पया जकरिया मुय्तोग़ पेदिर रासताहे, तोप्नेन ओना आल्का पेसता. अस्के ओग़ वळ्ह्‌कसोर देवुळतुन जोहर कीयलाह बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","इव पोल्‍लोङ केंजिसि, अगा मनवालोर पका रेयतोर. ओसो यहुदा पटटा मेटा-बूमताङ नाह्‌कनोर इव सबे पोल्‍लोन वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","निटमे ओग़ पेकाना संगे देवुळ मता इन्जि, इव पोल्‍लोङ केंजतोर सबेटोर इविन बेस आलिह कीसि, “वेग़ पेकाल कोनि मोदुल मन्कल आयनोग़ बहे!” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","पेकाना तपे जकरिया मुय्तोना आल्का पेसतस्के, ओग़ देवुळता जीवाते निंदतोग़, निंदतस्के अद जीवा ओन इद्रम वेहनाह कीता: ");
INSERT INTO mrr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“मावा इस्रयेलतोरा बेरा डीसाता देवुळतुह्‌कु जोहर आयि, अद तना लोकुरा पोग़ोन जीवा वाटिस, ओरिन तमा कोंटेतोराहि पिसिह कीयलाह वाता. ");
INSERT INTO mrr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","वेल्‍लाय मुनेन अदु तना पवित्र कबुरतोरा संगे वेहतपु, माक पिसिह कीयलाह, तना सेवक दाविद राजाना जालपिलताहि, पका लावतोन निल्पिह कीता. ");
INSERT INTO mrr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","वेग़ पिसिह केवाल मावा विरुद केवालोर कोटुलतोरा कयदाहि माक पिसिह कीयनोग. ");
INSERT INTO mrr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","मावाङ तादोर-बाबोरिन गूनम तोहतकन इन्जि, देवुळि किरिया ईसि, अदे किरियाता सीता कीसि, नेंड इद्रम कीता. ");
INSERT INTO mrr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","अदे किरिया अब्रहम मुय्तोना संगे कीस मता. ");
INSERT INTO mrr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","इतेके ‘मीट जीवात मनाह बेदे रेयलेवा नाक माळना इन्जि, मीट नावा सेतेमता, पवित्र अग़दे ताकना इन्जि नना मीवा कोटुलतोरा कयदाहि मीक विळ्सिह कीकन.’ ");
INSERT INTO mrr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","79","ए नावा पेकानिन! नीक इंजेके बेरा डीसाता देवुळता कबुरतोग़ इनदनुर. बाराह्‌क इतेके, मावा देवुळि पका जीवा लोपिसि, तना लोकुरा पापमतुन मापि कीस पिसिह कीयग़ा इनजोरे, निमा सामिना अग़दुन मुनेह-मुनेह तीर्ह्‌कसोर दाकिन. पंङवियतस्के ईकळ मायिह्‌ता, अद्रमलेह्‌का माट पापमता ईकळते ताकवालोरगा, हामुरतुह्‌क रेयवालोरगा देवुळ लोहवाल पिसिह केवाना वेह्‌च दींचग़ा, ओग़ माक देवुळता संगे गूनम आनाह कीयनोग़.” इनजोर जकरिया मुय्तोग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","अद्रमे पया जकरिया मुय्तोना मग़ि बेर्ससोर अतोग़, ओसो ओना लोप्पा देवुळता बुद बोल्गसोर अता. ओग़ तना इस्रयेल लोकुरिह्‌क देवुळता पोल्‍लो वेहनाह्‌जोम, पेळ्ह्‌कल बूमते मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","योहन पुटटापया, रोम सर्करता ओगुस्तुस कय्सर राजानेनाह, तना ताकिह कीयनव सबे देसेह्‌कनोरिन, तमाङ-तमाङ पेदिर्क सर्करता पुस्तकतगा रास वेहतना (इतेके सिरगंचि कीयना) इनजोर उकुम वाता. ");
INSERT INTO mrr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(इद सुरुमुनेता सिरगंचि आंदु, अद तूकने सुरिया पटटा गुमसि किविरिनियुस मतोग़.) ");
INSERT INTO mrr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","अस्के सबेटोर लोकुर तमाङ पेदिर्क रास वेहतलाह, तमाङ तादोर-बाबोराङ नाह्‌कने अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","अद्रमे योसेपि दाविद राजाना पुळ्गतोग़ मताह्‌कु, गालिल पटटा नासरेत नाटेनाहि पेसिसि, दाविद पुटटद बेत्लेहेम नाग़ अतोग़, अद नाग़ यहुदा पटटे मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","योसेप तन्क मर्मिङ आयलाह ताल्ह्‌कतद मरियाल बारा, तमाङ पेदिर्क रासलाह अतोर, अस्के अद नेलाङ हव्किस मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","पया ओर अगा मनदह्‌पा, ताना रिकम आयनद कगो एवता. ");
INSERT INTO mrr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","एवतस्के तान्क माळा पेकाल पुटटोग़. अस्के ओग़ पेकान गेंदे मुर्वेने ऊर्हचि, कोळ्कातगा पीर डालाते तासता. बाराह्‌क इतेके गोटुदगा ओरेनाह्‌क जागा इले आस मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","पया अग्डोर उय्तुर कोपालोर, बटटगा तमाङ गोरेन मंदा कीसि, नग़्का पिळ्‍विळ ओर राका कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","अस्के अगा देवुळता देवतुल ओरिह्‌क दिसता. दिसतस्के देवुळता लावता वेह्‌च ओरगा अरता. अरतस्के कोपालोर वेह्‌चतुन ऊळिस पका रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","अचोटेने देवतुल ओरिन इता, “मीट रेयमाटु! इके केंजाट, नना मियेनाह्‌क बेसतल कबुर ततन. अद सबेटोर लोकुरिह्‌क पका गिर्दा ईयनद कबुर आंदु. ");
INSERT INTO mrr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","नेंडु दाविद राजाना नाटे, देवुळ लोहतोग़ु मीक पिसिह केवाल पुट वातोग़, ओग़े सामि किर्स्तु आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","तेना सीना इद मन्ह्‌ता इतेके, ओग़ कस्मुल बाला पेकान गेंदे मुर्वेने ऊर्हचि, कोंदा कोळ्कातगा पीर डालाते तासतदिन मीट ऊळकिर,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","इतस्के अस्केडा अस्केन, तानगा वेल्‍लाङे देवतुल्क वासि, देवुळतुन जोहर कीसोरे, ");
INSERT INTO mrr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“देवुळदीपतगा मनदनद देवुळतुह्‌क मान आयि. नेदगा तान्क विचर वातोर मन्कलोरिह्‌क सुकम आयि,” इनजोर इताङ. ");
INSERT INTO mrr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","पया देवतुल्क अग्डाह पेसिसि, देवुळदीपतगा मलताङ. अस्के कोपालोर तमतमाय इतोर, “अलेट रा दटु! बेत्लेहेम नाटे अन्जि, इगा बेद पोल्‍लो सामि मयेनाह्‌क कबुर लोहता, अदिन ऊळकल अयो!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","इतस्के ओर दरि-मरि आसोर अग्डाह पेसतोर. बेत्लेहेम एवतस्के मरियान, योसेपिन ओसो कोंदाह्‌क पीर ईयनद जागातगा टेटेम अर्स मतोग़ बाला पेकान ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ऊळतस्के, “वेग़ पेकाना लोप्पा देवतुल वासि माक इद्रम इद्रम वेहता” इनजोर, अद पोल्‍लोतुन सबेटोरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","कोपालोर वेहतद पोल्‍लोतुन केंजवालोर सबेटोर बामतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","पया देवतुल्क वेहतपु, ओर केंजतव, ऊळतव पोल्‍लोनेनाह्‌क, देवुळतुन जोहर कीसोर, मान ईसोरे, तमाङ गोरेनके मल्स अतोर. मति मरियाल मात्रम इव सबे आतव पोल्‍लोन तना पोटातगान तासिस, इविना बाताल अर्तम मनदग़ा इनजोर आलिह कींदु. ");
INSERT INTO mrr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","पया मरियाल, योसेप वेर बाताल कीतोर इतेके, पेकाल पुटिसि आट दियाने, ओना डायना रिवज कीतोर. कीतापया बेद्रम मरियानु नेलाङ हव्कनामुने देवतुल वेहच मता, अद्रमलेह्‌का पेकाना पेदिरि, ओर येसु इनजोर तासतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","मोसानाङ अडोङ वेहतपु, (पेकाल पुटिस रिकम आतद आंचाळि रेंड वीसाङ दियाङ आनाह्‌जोम कळ्‍वोग़आंदु). देवुळताङ अडोना सास्त्रमतगा रासतप लेह्‌का, मरियाल कळ्‍वोग़ आताह्‌कु, उंद जोळ परेवा पिटेङ, इलवेके उंद जोळ पोनळ पिटेङ बूमयानगा ईसि, मोक ईयना मता. ओसो देवुळताङ अडोना सास्त्रमतगा, माळा मग़िन देवुळतुह्‌क विळ्सिसीयना इनजोर रासतद मन्ह्‌ता. अदिह्‌क पेकानु देवुळतुह्‌क विळ्सिसीयलाहि, मरियानाङ कळ्‍वोग़ताङ दियाङ मारतापया, अदु ओसो योसेप येसुन येरुसलेम सहरता मंदिरतगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ओरु पेकान मंदिरतगा ओतोर अस्के, सिमियोन पेदिरतोग़ ओर्वोग़ सेतेमतोग़ मन्कल येरुसलेमतगा मतोग़. ओग़ कर्तुळते देवुळतुन मोळ्कवाल मतोग़. देवुळ लोहवाल पिसिह केवाना कयदे, इस्रयेलतोरिन सुद्रे कीयनद दिया बेस्के एवयग़ा इनजोर, ओग़ अग़ ऊळसोर मंदोग़. ओसो देवुळता जीवा ओनगा अमेसा मंदु. ");
INSERT INTO mrr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“बेचानाह देवुळ लोहवाल पिसिह केवाल किर्स्तुन निमा ऊळविन आयकिन, अचानाह डोलविन आयकिन” इनजोर, देवुळता जीवा ओन वेहच मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","पया देवुळता जीवा ओन वेहताह्‌कु, मरियाल ओसो योसेप मंदिरतगा वातद दिया, ओग़ वने मंदिरताङ मंडानगा वातोग़. मोसानाङ अडोनगा रासतप लेह्‌का, येसुन देवुळतुह्‌क विळ्सिसीयनद रिवज कीयलाहि तलोग़-तपे तच मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","अस्के सिमियोन मुय्तोग़ ओरग्डाह पेकान एतोग़, एचि देवुळतुन जोहर कीसोर इतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“जोहर सामि! इस्रयेल लोकुरिन पिसिह केवाल किर्स्तुन नावाङ कोंडाने नना ऊळतन! सबे देसेह्‌कनोर ऊळनाह, वेन निल्पिह कीस तासतिन. वेग़ पेकाल वेह्‌चलेह्‌का मनदनोग़, यहुदि आयवोरिननीक पुन्पिह कीयलाह ओसो इस्रयेलतोर यहुदिरिह्‌क मान दोर्किह कीयलाह. अदिह्‌क निमा मुने वेहतप लेह्‌का, नना नीवा सेवकनन इंजेक सुकमते डोल पग़यकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","सिमियोन मुय्तोग़ इतद पोल्‍लोतुन केंजिसि, येसुना तलोग़-तपे बामतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","पया सिमियोन मुय्तोग़ ओरिह्‌क बर्कतताङ पोल्‍लोङ वेहतोग़, वेहचि पेकाना तलिन इद्रम इतोग़ इतेके, “इगा वेल्‍लाटोर इस्रयेल लोकुर विस्वस केवोरु बूळेम आयिर, ओसो वेल्‍लाटोर विस्वस केवालोर पिसिर इनजोर, देवुळ वेन आचता. वेग़ देवुळतुन तोहतनद सीना मनदनोग़, मति लोकुर वेना पोग़ोन विस्वस केवालेवा वेन पास्कनुर. ");
INSERT INTO mrr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","इद्रम वेल्‍लाटोर लोकुरा पोटालोप्पाडाङ विचर्क एर्का आयनुङ. मति नीक इतेक, इद्रम आयग़ा पिला, नीवा जीवातुन तल्वर कसेग़ते कोटटप लेह्‌का, नीवा जीवा पका काल्सग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","अगा देवुळता कबुर वेहतनद हना पेदिरता उंदि रांडे मुते वने मता. अद रांडे मुते नालुङ वीसाङ नालुङ (84) वय्सता सेळो मता. अदु असेर पुळ्गतोग़ पनुयेल इनवाना मयाळ आंदु, मर्मिङ आस एळुङ वर्सानेन ताना मुजो डोलतोग़. अद सेळो जर्मिने मंदिरतगा अंदु. अन्जि अमेसा उपस-पार्तना कीसोर देवुळतुन मोळ्किंदु. ");
INSERT INTO mrr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","(सिमोन मुय्तोग़ येसुना तलोग़-तपेरा संगे वळ्ह्‌कसोर मतोग़,) अस्के, अद सेळो ओरगा वाता. वासि देवुळि इस्रयेल लोकुरिन तमा तिपलताहि बेस्के विळ्सिह कीयग़ा इनजोर केपवालोर लोकुरिन, येसुना लोप्पा वेहता. वेहचि येसुनेनाह्‌क देवुळतुन जोहर कीता. ");
INSERT INTO mrr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","अद्रमे पया मरियाल ओसो योसेप, देवुळताङ अडोना सास्त्रमते वेहतपु सबे उतुर्क मारिह कीतोर. कीसि गालिल पटटे मतद तमा नासरेत नाग़ मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","पया ओरा पेकाल बेस लावते बेर्ससोर अतोग़. ओन देवुळि बेस बुदते निहचीता, ओसो ताना देय्वा अमेसा ओनगा मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","येसुना तलोग़-तपे वर्सा-वर्सातुह्‌क आवना पंडुम कीयलाहि येरुसलेम सहरता मंदिरतके अंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","येसु बारा वय्सतोग़ आस मतोग़, अस्के वर्सातुह्‌क अतप, इद मल्का वने पंडुमतुह्‌क अतोर, ओरा संगे येसु वने अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","अतस्के पंडुम मारनाह्‌जोम, ओर अगान मतोर. मारतापया ओना तलोग़-तपे गालिल पटटके मल्स दायलाह पेसतोर, मति येसु मात्रम येरुसलेमतगान मतोग़, इदिन तपेर मुर्तिय पुनोर आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","मावा संगे मल्स वावालोर लोकुराङ तुंगाना संगे, ओग़ मनदनोग़ इनजोर विचर कीसि, उंद दियाता पय्नम ताकिस मतोर. ताना पया तमा जीवातोरगा, पुतोरगा ओन पर्ह्‌क बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","इके-अके पर्ह्‌किस ऊळतोर, मति येसु बेगान दोर्कोग़. दोर्कवाह्‌क ओसोवने येरुसलेमतेकेन पर्ह्‌कलाह मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","इमा दिया ओन मंदिरताङ मंडानगा दोर्किह कीतोर. अस्के ओग़ यहुदि गूरुरा संगे उदिस, ओराङ पोल्‍लोङ केंजसोर, ओरिन पोल्‍लोङ ताल्ह्‌कसोर, ओरा संगे वळ्ह्‌कसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ओना पोल्‍लो केंजसोर मतोर सबेटोर, “वेग़ पेकाल पका उसरतोग़ आंदोग़ रा! पका बुदते पोल्‍लो मल्हतह्‌तोग़,” इनजोर बामतोर. ");
INSERT INTO mrr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ओना तलोग़-तपे वने ओन ऊळिस पका बामतोर. पया ओना तलोग़ इता, “माक इद्रम बाराह्‌क तिपल कीतिन बाबा? मिय्माल, नना, पका आलिह कीसोर, नीक बेचोन पर्ह्‌कतोम, एर्काये!” ");
INSERT INTO mrr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","इतस्के ओग़ पेकाल ओरिन, “मीट नाक इके-अके ऊळसोर पर्ह्‌कनायो मता, बह नावा बाबाना लोतगा नना मनदना इनजोर मीट पुनविरा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","मति तलोग़-तपेरिह्‌क ओग़ इतद पोल्‍लो मुर्तिय तेळियो. ");
INSERT INTO mrr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","पया येसु तपेरा संगे तमा नासरेत नाग़ अतोग़. पेकाल ओरा पोल्‍लो केंजसोर ताकिंदोग़. ओना तलोग़ इव सबे पोल्‍लोन तना पोटातगा तासिस, आलिह कीसोर मता. ");
INSERT INTO mrr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अद्रमलेह्‌का येसु बेर्ससोर अतोग़. बेद्रम बेर्सिंदोग़, अद्रमे बुद पुनजोर अंदोग़. ओसो देवुळतुह्‌कु वने, मन्कलोरिह्‌क वने, विचर वातप ताकिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरिया कय्सर इनवाल पूरा रोम राजेमता बेरोग़ राजाल आसि, पंद्रा वर्साङ आस मतोग़. अस्के पुन्‍तियु पिलाति इनवाल, यहुदा पटटा गुमसि मतोग़.एरोद अंतिपस इनवाल राजाल गालिल पटटा गुमसि मतोग़. तना तमोग़ पिलिप इनवाल, इतुरेया ओसो तरकोनीतिस इव पटिना गुमसि मतोग़. लिसानिया इनवाल, अबिलेने पटटा गुमसि मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","अनाल ओसो तना अने कयपाल, वेरु देवुळता पेर्मालोर इन्जि मतोर. अद तूकने जकरियाना मग़ि योहनिह्‌क बाताल आता इतेके, ओग़ पेळ्ह्‌कल बूमतगा मनदह्‌पा देवुळता कबुर ओन्क दोर्कता. ");
INSERT INTO mrr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ओग़ अद पोल्‍लोतुन पोसि, योर्दन बेरेटा एरे-गूरेताङ सबे नाह्‌कनगा अन्जि, इद्रम पोकुर कीतोग़ इतेके, “पापमता अग़दुन विळ्सिसि, देवुळतके मल्म्ह्‌टु. माट मलतोम इनजोर तोहतलाह, देवुळता पेदिरते एग़ मीम्ह्‌टु! अस्के देवुळि मीवा पापमतुन मापि कीयग़ा,” इनजोर केयिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","इद्रमलेह्‌का देवुळता कबुरतोग़ यसयाना पुस्तकते, वेल्‍लाय मुने रासतद पोल्‍लो इंजेके करल आता: “पेळ्ह्‌कल बूमतगा केयनद आल्का केंज वायग़ा. ‘सामि मीवा जीवातगा वायना इन्जि, मीट ओना वायनद अग़दुन तीर्ह्‌काटु! ओसो अद अग़दुन कसुम कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","इतेके सबे लोवाङ निंदिस दायना गावले, सबे मेटाङ ओसो गुड्राङ बराबर आयना गावले. विकोङ-वकोङ आतव अग़िङ दिग्ने आयना गावले, बोंदाङ-बोग्ळाङ आतद अग़ि सम्ने आयना गावले. ");
INSERT INTO mrr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अस्के लोकुरिन पिसिह कीयलाहि, देवुळि आचतोनु सबेटोर ऊळनुर.’” इनजोर रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","देवुळता पेदिरते एग़ मीयलाह, गोह्‌डिनाङ गोह्‌डिङ वाता मुडुन, योहन इद्रम इतोग़, “एय वीसम तरस्कना लेह्‌काडोरिर! (पापमता अग़दाहि देवुळतके मलवालेवा, वेट देवुळता पेदिरते एग़ मीतेके,) देवुळि ईयनद सिक्साताहि माट पिन्ह्‌ट अरयकोम इनजोर बाराह्‌क इह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","पापमता अग़दाहि मलतोम इनजोर तोहतलाह, बेसताङ कबस्क कीम्ह्‌टु.(केवेक अचोन कायाङ आदवाङ मराना लेह्‌का आयकिर!) ओसो ‘माट इतेके अब्रहम मुय्तोना कूळतोरोम आंदोम, देवुळि माक सिक्सा एवो आयग़ा’ इनजोर, मीट बेस्केन इद्रम इनमाट बहा. नना मीकु वेहतह्‌नन, देवुळि अब्रहम मुय्तोह्‌क पेकोर, इव बंडानग्डाह वने पुटिह कीया पग़यह्‌ता, पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","इंजेके मरा मोदुदगा मग़्स तासिस तयरेन मन्ह्‌ता. बेद मरा बेस आदो, अद मरातुन नळ्किसि, किसतगा वाटमुळ आयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","अगा जमा आता मुलु योहनिन इद्रम ताल्ह्‌कतोर, “पापमताहि मलयना इतेके माट बाताल कीकोम?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","इतस्के, “बोनगा रेंड जगाङ मन्ह्‌ताङ, ओग़ उंद जगातुन जगालेवोन्क ईयेग़. बोनगा तिंड-बंड मन्ह्‌ता, ओग़ वने लेवोना संगे तूसिस तिनेग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","अगा देवुळता पेदिरते एग़ मीयलाह, सिद्‌वा एनवालोर वने वास मतोर, ओर पका लोकुराङ कोताङ तिंदुर. वेर वने “गूरु! माट बाताल कीकोम?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ताल्ह्‌कतस्के ओरिनु “मीक बेचोन सिद्‌वा एता वेहतोर, अचोने एनाटु! लोकुरिन मुळ्हमाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","उय्तुर सीपय्क वने ओनगा वासि, “माट बाताल कीकोम?” इनजोर ताल्ह्‌कतोर. ताल्ह्‌कतस्के ओरिन वने वेहतोग़, “मीकु बेचोन पगर दोर्किह्‌ता, अचोने पगरते मुयोग़ आयवा मन्ह्‌टु. बोरिने बह डारेह कीसि, इलवेके जोल कसुर वाटिसि, कोताङ एनमाटु.” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","इंजेके देवुळ लोहवाल पिसिह केवाल वायनोग़ इनजोर आसा कीस, लोकुर अग़ ऊळिंदुर. अदिनेनाह्‌क योहनिन ऊळिसि, सबेटोर “वेग़ ओग़े बह आयोग़?” इनजोर तमतमाय विचर कींदुर. ");
INSERT INTO mrr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","अदिन पुन्जि योहन सबेटोरिन इद्रम इतोग़, “नना इतेक लोकुरिह्‌क देवुळता पेदिरते एतेन मीहतलाह आतन. मति ओर्वोग़ बार वायलाह आतोग़, ओग़ नाकाय वीळिसि बेरा लावतोग़ आंदोग़, ओना कादुन इटलाह वने नना ओप्पोन, अचोन नना उड्लोनन! ओग़ देवुळता पवित्र जीवाते ओसो किसते मीक मीहवाल आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ओनाय कयदे एत मन्ह्‌ता. ओग़ तना कळातग्डाङ वंजिन बेस एहचिसि, डोमेते दोसनोग़, दोर्बेतुन बार बेस्केन पिववद किसते बोळ्सिसीयनोग़, अद्रमलेह्‌का ओग़ मीक वने कीयनोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","इद्रमलेह्‌का योहन ओसो वेल्‍लाङे पोल्‍लोने लोकुरिन बुदिङ काग़्हचोर, बेसता कबुरतुन पोकुर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","पया योर्दन बेरेटगा, योहन वेल्‍लाटोर लोकुरिन देवुळता पेदिरते एग़ मीहचोर मतोग़. अस्के येसु वने अगा वातोग़, ओन वने देवुळता पेदिरते योहन एग़ मीहतोग़. मीहतस्के बाताल आता, येसु पार्तना कीनेके, अस्केडा अस्केन पोग़ोटा बूमि पङ्ने आता. पङ्ने आता अस्के, देवुळता पवित्र जीवा परेवा पिटेलेह्‌का दिसिसि, ओना पोग़ोन रेगता. पया पोग़ोटाहि देवुळता आल्का इद्रम वाता इतेके, “निमा नावा मग़निन आंदिन, नीक पका जीवा कीय्ह्‌नन! नीवा लोप्पा नना पका गिर्दा आतन,” इता. पया मनेक मनेक बह आता इतेके, एरोद अंतिपस गुमसि, तना दादाल (पिलिप जीवात मनेकेन,) वेना मुते एरोदियसि इनदनदिनु तन्क ततोग़. ओग़ तना अंगेना संगे कीतद पापमतेनाह्‌कु ओसो वेल्‍लाङे दुस्राङ लाग्वाङ कबस्कनेनाह्‌क योहन ओन तेर्हन्दोग़. अदिनेनाह्‌क कोनि एरोद अंतिपस गुमसि, योहनिन जेलते वाटटोग़. वाटिसि तना मुने कीतव लाग्वाङ कबस्कना लेह्‌का, इद ओसो उंदि लाग्वा कबळ कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","अद्रमे पया येसु तना सेवा सुरु कीतोग़, अस्के जोक-जोक डेडा वीसा वर्सानोग़ मतोग़. लोकुरा विचरते येसु योसेपना मग़ आंदोग़. योसेप इतेके एलिना मग़ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एलि मतातना मग़ि, मतात लेविना मग़ि, लेवि मलकिना मग़ि, मलकि यनालना मग़ि, यनाल योसेपना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","योसेप मतिताना मग़ि, मतिताल आमोसना मग़ि, आमोस नहूमना मग़ि, नहूम असल्याना मग़ि, असल्याल नोगाना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नोगाल मतुसना मग़ि, मतुस मतिताना मग़ि, मतिताल सिमिना मग़ि, सिमि योसेकना मग़ि, योसेक योदाना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाल योनाना मग़ि, योनाल रेसाना मग़ि, रेसाल जरुबाबेलना मग़ि, जरुबाबेल साल्तियाना मग़ि, साल्तियाल नेरिना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरि मलकिना मग़ि, मलकि अद्दिना मग़ि, अद्दि कोसमना मग़ि, कोसम इलमोदमना मग़ि, इलमोदम एराना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एराल यहोसाना मग़ि, यहोसाल इलाजरना मग़ि, इलाजर योरिमना मग़ि, योरिम मतातना मग़ि, मतात लेविना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवि सिमियोनना मग़ि, सिमियोन यहुदाना मग़ि, यहुदाल योसेपना मग़ि, योसेप योनमना मग़ि, योनम एल्यकिमिना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एल्यकिमि मलेयाना मग़ि, मलेयाल मिनाना मग़ि, मिनाल मताताना मग़ि, मताताल नातानना मग़ि, नातान दाविद राजाना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाविद राजाल यीसाना मग़ि, यीसाल ओबेदना मग़ि, ओबेद बोहजिना मग़ि, बोहजि साल्मोनना मग़ि, साल्मोन नहसोनना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहसोन आमिनदाबना मग़ि, आमिनदाब अरनयना मग़ि, अरनय एस्रोनना मग़ि, एस्रोन पर्साना मग़ि, पर्साल यहुदाना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहुदाल याकुबना मग़ि, याकुब इसकना मग़ि, इसक अब्रहमना मग़ि, अब्रहम तेरहाना मग़ि, तेरहाल नाहोरना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर सरुगना मग़ि, सरुग रहुना मग़ि, रहु पेलेगना मग़ि, पेलेग एबेरना मग़ि, एबेर सेलाहना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","सेलाह केनानना मग़ि, केनान अर्पक्सदना मग़ि, अर्पक्सद सेमना मग़ि, सेम नोहाना मग़ि, नोहाल लामेकना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लामेक मतुसेलाना मग़ि, मतुसेलाल हनोकना मग़ि, हनोक यारेदना मग़ि, यारेद महललेलना मग़ि, महललेल केनानना मग़ि. ");
INSERT INTO mrr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान एनोसना मग़ि, एनोस सेतना मग़ि, सेत आदमना मग़ि, आदमिन देवुळि पंडटा. ");
INSERT INTO mrr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","पया येसु योर्दन बेरेटगा देवुळता पेदिरते एग़ मीसि, पवित्र जीवाते निंदतोग़. निंदतस्के देवुळता जीवा ओन पेळ्ह्‌कल बूमते ओसीता. ");
INSERT INTO mrr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","अगा रेंड वीसाङ दियाङ देयह्‌कना मुक्याल येसुना पट ऊळसोर मता. रेंड वीसाङ दियाङ येसु बातय तिनवा मतोग़, अदिनेनाह्‌क अव दियाङ मारतस्के, ओन्क पका कग़्व वसता. ");
INSERT INTO mrr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","कग़्व वसतस्के देयह्‌कना मुक्याल ओनगा वासि, “देवुळता मग़नन इनजोर इह्‌निन इतेके, इद बंडातुन आरि मारियिह कीम,” इता. ");
INSERT INTO mrr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","इतस्के येसु, “आयो, मन्कल तिनदनद तिंडटेन पिसोग़ आस्तोग़, इनजोर देवुळता सास्त्रमतगा रासतद मन्ह्‌ता, पुनविन!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","इतस्के पया देयह्‌कना मुक्याल बह कीता, येसुनु उंद पोग़ोटा जागातगा ओता. ओसि, उंदिय देबा इद दुनियाताङ सबे राजेह्‌क तोहता. ");
INSERT INTO mrr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","तोहचि इद्रम इता, “इव सबे राजेह्‌किन ताकिह कीयनद अदिकर, नाक ईतद मन्ह्‌ता. नना इद अदिकरतुन बोन्क इतेक ओन्क ईया पग़यह्‌नन. अदिनेनाह्‌क इंजेके निमा नावाङ काल्क अर्सि मोळ्कतिन इतेके, इव कतम राजेह्‌कु ओसो इविस्कना सोबा नीके आयनुङ,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","इतस्के येसु तान इतोग़, “आयो, देवुळतुने मोळ्कना, तानाये माळना कीयना, इनजोर देवुळता सास्त्रमतगा रासतद मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","पया देयह्‌कना मुक्याल ओन येरुसलेम सहरते ओता, ओसि मंदिरता कुपोटगा निल्पिह कीसि, इद्रम इता, “देवुळता मग़नन इनजोर इह्‌निन इतेके, इग्डाह इळ्न डेया! नीक बाताले आयो आयग़ा, बाराह्‌क इतेके नीक काप आडना इन्जि, देवुळि तनाङ देवतुल्किनलोहतग़ा. अस्के अवु, नीवाङ काल्क चेट पेह्‌चनायो इन्जि, नीकु तमाङ कय्कने पोग़ोने एतनुङ, इद्रम देवुळता सास्त्रमतगा रासतद मन्ह्‌ता,” इनजोर देयह्‌कना मुक्याल इता. ");
INSERT INTO mrr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","इतस्के येसु तान इतोग़, “आयो! (बय्तळ कबळ कीतेक तेला, देवुळ नाक पिसिह कीयग़ा, इद्रम इन्जि)बोग़े देवुळता पट ऊळनदायो, इह वने पवित्र सास्त्रम वेहतह्‌ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","अद्रमलेह्‌का देयह्‌कना मुक्याल येसुन सबे रीतिनाङ पट ऊळता, ऊळिसि ओसो पेग़्के बेसता मोका दोर्कि इनजोर, ओन विळ्सिस अता. ");
INSERT INTO mrr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","पया येसु अग्डाहि गालिल पटटे मल्स अतोग़. अस्के देवुळता जीवा ईतद लाव ओनगा मता. गालिल पटटाङ सबे नाह्‌कनोर मन्कलोर, ओनाय पोल्‍लोतुन वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","येसु यहुदिराङ पार्तनाताङ लोह्‌कनगा, देवुळता पोल्‍लोतुन काग़्हन्दोग़. इदिन केंजिसि सबेटोर “पका बेस काग़्हतह्‌तोग़ रा!” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","अद्रमे पया येसु तना नासरेत नाग़ अतोग़. अन्जि वारमता पोल्वादियाते तना अल्वट मतपु, अग्डा पार्तनाता लोन अतोग़. अन्जि देवुळता सास्त्रम अर्वलाह नितोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","अगा साकुर केवाल मन्कल, येसुनगा देवुळता सास्त्रमता उंद पुस्तक ईतोग़. अद सास्त्रमतगा देवुळता मुनेतोग़ कबुरतोग़ यसयाना पोल्‍लो रासतद मता. पुस्तकतुन तेग़यिसि, येसु अग्डाह उंद पोल्‍लो दोर्किह कीसि जोरते अर्वतोग़.(अद पोल्‍लो देवुळ लोहवाल पवित्र सेवकना तोडटाहि पेसतप आंदु.) अद इद्रम मता इतेके, ");
INSERT INTO mrr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“देवुळता पवित्र जीवाता दळ्म नयगा अरता. गरिबतोरिह्‌क बेसता कबुरतुन पोकुर कीयलाहि, देवुळि नाक निल्पिह कीता. मन्कलोरा कय इळ्नमनवालोरिन, देवुळ मीक विळ्सिह कीता इनजोर, पोकुर कीयलाहि, तोववोरिन मीट तोवयकिर इनजोर, पोकुर कीयलाहि, तिपलते मनवालोरिन विळ्सिह कीयलाह, देवुळि देय्वा ईयनद कगो एवता इनजोर पोकुर कीयलाहि, अद नाक लोहता.” इनजोर रासतदिन अर्वतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","अर्वतस्के पुस्तकतुन बंद कीसि, साकुर केवानगा ईसि, काग़्हतलाह उदतोग़. अद लोतगा मतोर सबेटोरु, ओनक्‍केन कोंडा मिळ्हवा ऊळसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","अस्के येसु ओरिन इनदलाह आतोग़, “नेंड मीट केंजतिर इव सास्त्रमताङ पोल्‍लोङ, नावा कयदे करल आताङ,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","सबेटोर, “वेग़ बेस वेहतह्‌तोग़ रा! सबे बेसताङ-बेसताङ पोल्‍लोङ वेना तोडटाहि पेसिह्‌ताङ गोतो!” इनजोर बामतोर. मति ओसोवने “बह वेग़ मावा योसेपना मग़ि आयोग़ा? अचोन बुद वेन्क बेग्डाह दोर्कता?” इनदा बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","अचोटेने येसु इतोग़, “‘मत एवानिन! नीके सव्रे कीस तोहा’ इनजोर लोकुर इन्ह्‌तोर. अद पोल्‍लोतुन मीट नाक इनदकिर निटमे. इतेके ‘कापेर्नाटे निमा कीतव बामिह कीयनाङ कबस्किन माट केंजतोम. अविस्किन इगा नीवाय नाटे वने कीस तोहा,’ इनजोर इनदकिर. ");
INSERT INTO mrr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","इह केंजाट, नना सेतेम वेहतह्‌नन, बोग़े देवुळता कबुरतोन्क, तनाय नाटेने मान दोर्को. ");
INSERT INTO mrr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“बेद्रम इतेके देवुळता कबुरतोग़ एलिया मुय्तोना वेलाते बाताल आता, पुनविरा? अस्के देसेममेंड मूंड वर्साङ आरुङ नेलाङ आनाह, मुर्तिय पेग़ वावो आस मता, बेरा दुकळ अर्स मता. अद तूकने मावा इस्रयेल देसेमतगा निटमे वेल्‍लाङे रांडे आस्क मताङ. ");
INSERT INTO mrr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","मति अविस्कनाहि बेदिनगान देवुळि एलिया मुय्तोन लोहो. सिरप सिदोन सहरता बाजेता सारपत नाटेना रांडे आंचाह्‌के, तोळ ईयलाहि लोहता.(अद आंचाळ इतेके मावा देसेमता, मावा जातता आयो.) ");
INSERT INTO mrr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अद्रमे देवुळता कबुरतोग़ एलिसा मुय्तोना वेलाते वने, मोंडरोगमतोर मावा इस्रयेल देसेमतगा वेल्‍लाटोर मतोर. मति वेरग्डाहि ओर्विन वने सव्रे कीयलाहि, देवुळि एलिसान वेहो. सिरप सुरिया देसेमतोग़ नामानिने, एलिसाल सव्रे कीतोग़.(अदिनेनाह्‌क वेहतन, बोग़े देवुळता कबुरतोन्क तनाय नाटे मान दोर्को,)” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","(इस्रयेल मन्कलोरिन विळ्सिस, दुस्राङ देसेह्‌कनोर मन्कलोरिह्‌क, देवुळ तोळ ईता इनजोर) येसु वेहतस्के, पार्तनाता लोतगा उदिस मतोर सबेटोर पका ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ओङ आतस्के तेदिसि, येसुन तमा नाटेना पलते गुंजिस ओतोर. ओरा नाग़ इतेके मेटापोग़ोन मता. अद मेटापोग़ोन कस्क्ने मनदनद जागाताहि ओन दोबिस ईयलाह अगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","मति येसु बाताल कीतोग़ इतेके, अग्डाहि मुडा नडुमतुह्‌क पेसिस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","पया येसु ओसो ओनाङ कग़यवालोर गालिल पटटा कापेर्नाग़ अतोर. अन्जि वारमता पोल्वादियाते, देवुळता पार्तनाता लोतगा, येसु लोकुरिन काग़्हन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ओग़ अचोन अदिकरते काग़्हतोग़ इतेके, लोकुर ओना पोल्‍लोतुन केंजिसि बयल आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","पार्तनाता लोतगा ओर्वोग़ देयम पोयतोग़ मन्कल मतोग़. येसुन ऊळिसि, ओग़ मन्कनगा मतद देयम पका जोरते इद्रम केयता, ");
INSERT INTO mrr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ए नासरेत नाटेनोग़ येसुनिन! मावा संगे नीवा बाताल कबळि? बह माक देयह्‌किन बूळे कीयलाह वातिना? निमा बोनिन इनजोर पुनोना? निमा देवुळ लोहतोग़ पवित्र मन्कनिन आंदिन!” इता. ");
INSERT INTO mrr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","अस्के येसु अद देयमतुन, “केमेन मन! वेनग्डाहि पेसिस अन!” इनजोर दगा ईतोग़. ईतस्के अदु ओग़ मन्कन नेल अर्हचि, ओन नोमुर केवालेवा, ओनग्डाहि पेसिस वितता. ");
INSERT INTO mrr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","अगा मतोर लोकुर बामिसि, ओर्विह्‌क-ओर्वोग़ वळ्ह्‌कसोर, “इद बेद्रमता पोल्‍लो रा? वेग़ अचोन अदिकरते, लावते देयह्‌किन उकुम ईस्तोग़! अव पेसिह्‌ताङ गोतो!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","पया येसुना इद पोल्‍लो एरे-गूरेताङ सबे नाह्‌कने आबुर आता. ");
INSERT INTO mrr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","पया येसु तनाङ कग़यवालोर बार, पार्तनाता लोताहि पेसिस, सिमोन पत्रु इनवाना लोन अतोग़. सिमोन पत्रुना आतोह्‌क पका दंड पोस मता. अदिनेनाह्‌क “तान सव्रे कीसीम” इनजोर येसुन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","कीतस्के येसु तानगा अन्जि, दंडटुन “पेसिस अन!” इन्जि उकुम ईतोग़, ईतस्के ताना दंड रेगता. पया अद अस्केडा अस्केन तेदिसि, ओरिह्‌क जावा-एग़ कीसीता. ");
INSERT INTO mrr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","अदे दिया मुलतस्के, (वारमता पोल्वादिया मारता. अदिनेनाह्‌क यहुदिरिह्‌क कबळ कीयलाह पोलिंदु.) अचोटेने बोर मन्कलोर अलग-अलग रीतताङ दुकिङ अर्स मतोर, ओर सबेटोरिन येसुनगा ततोर. पया येसु ओर्विन-ओर्विन कय बोयिस सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","वेल्‍लाटोरिन देयह्‌क पोस मताङ, अव देयह्‌किन ओग़ पूंडटोग़. अव देयह्‌क येसुन ऊळिसि, “निमा देवुळता मग़निन आंदिन” इनजोर, केयसोर-केयसोर पेसिंदुङ. येसुये देवुळ लोहतोग़ पिसिह केवाल किर्स्तु आंदोग़ इनजोर, अव पुन्ज मताङ. (मति इद तूकने इद पोल्‍लो सबेटोरिह्‌क पुन्पिह कीयनदायो इन्जि,) येसु देयह्‌किन दगाङ ईसि, अविस्किन वळ्ह्‌कलाह एवोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","पया पंङवियतस्के येसु पार्तना कीयलाहि, बोरे लेवगा अतोग़, मति नाटेनोर ओन पर्ह्‌कसोर-पर्ह्‌कसोर दोर्किह कीतोर. दोर्किह कीसि, “माक विळ्सिस अनमा!” इनजोर, ओन रोमिह कीयलाह ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","अस्के येसु ओरिन इतोग़, “देवुळि माने-मन्कनगा राजेम कीयनद बेसता कबुरतुन, दुस्राङ नाह्‌कने वने नाक वेहता पोयह्‌ता. इदे कबळतुह्‌क कोनि, देवुळि नाक लोहता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अद्रमे पया येसु यहुदिरा बूममेंड वेलियिसि, ओराङ पार्तनाताङ लोह्‌कनगा, बेसता कबुरतुन पोकुर कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","उंद दिया इद्रम आता इतेके, येसु गालिल सम्दुरकचुदा दडटगा निचि, लोकुरिन देवुळता पोल्‍लो काग़्हतलाह आस मतोग़. काग़्हनेके ओनाङ केंजलाहि, वेल्‍लाटोरे अगा येसुना सर्ने आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","अस्के येसु सम्दुरकचुदगा नितव रेंड ओडान ऊळतोग़. अग्डाह मीन्क पोयवालोर पेसिसि, एतगा तमाङ वदिङ नोग़यलाह आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","अव ओडान ऊळतस्के, नना इद ओडातगा उदतेके, वेरिह्‌क केंजलाह बेस आयग़ा इन्जि, ओग़ उंद ओडातगा तग़्ङतोग़. अद ओडा सिमोन पत्रुना आंदु. तग़्ङिसि “तमो, इद ओडातुन दडटाहि उचुन अबर, एतगा जर्गिह कीम डा,” इनजोर इतोग़. पया अद ओडातुन जर्गिह कीतस्के, ओडातगान उदिसि लोकुरिन देवुळता पोल्‍लो काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ओना काग़्हतनद मारतापया, “ओडातुन वेल्‍लाह कसा मनदनगा ओसि वदिङ वाटकिर, दट,” इनजोर सिमोनिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","इतस्के सिमोन इतोग़, “गूरु! माट नग़्का पिळ्‍विळ इद एतगा तिपल आतोम, माक उंद वने मीन दोर्को, इंजेक बेगा दोर्कनुङ? अले निमा इह्‌निन अदिह्‌क, ओडातुन मुनेह ओसि वदिङ वाटिस ऊळकोम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","पया (सिमोन ओसो तना तोळतोरु,) येसु वेहतप कीतोर, अस्के वेल्‍लाङे मीन्क वदिनगा एग़्कताङ. मीन्क वेल्‍लाङ आताह्‌कु, वदिङ अग़यलाह आस मताङ. ");
INSERT INTO mrr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","वदिङ अग़यनुङ बहा इनजोर, दुस्रा ओडातगा मतोर तमा तोळतोरिन कय सायाते केयतोर. केयतस्के ओर वासि, रेंड आस ओडानु मीन्कने बर्ति निहतोर. अव ओडाङ बर्ति निंदताह्‌कु, एतगा मुळ्न्देङ-मुळ्न्देङ आंदुङ. ");
INSERT INTO mrr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","अचो वेल्‍लाङ मीन्क पोयतदिन ऊळिसि, सिमोन पत्रु ओसो ओना तोळतोर पका बामतोर. बामिसि सिमोन येसुनाङ काल्क अर्सि, “सामि, नना पापि मन्कनन आंदन, नीवा एरे मनदलाह नना ओप्पोन!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अद्रमे दुस्रा ओडाते मनवालोर, सिमोनना संगे मीन्कना दंदा केवालोरु, जेबेदि इनवानाङ मग़्कु, याकुब ओसो योहन, वेर वने “इद बेद्रम आस मनदग़ा रा!” इनजोर बामतोर. अस्के येसु सिमोनिन, “निमा रेयमा रा, इचानाह मीन्क पोयंदिन, इंजेटाहि मन्कलोरिन नयगा तवानिन आयकिन,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","पया ओर तमाङ ओडान सम्दुरता कचुल दडटेके ततोर. ततापया तमाङ ओडान बातान, बेग्डाङ अगान विळ्सिसि, येसुना संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","अद्रमे उंद दिया, येसु उंद नाटेनगा मतोग़. अद नाटेनगा, पूरा मोंडरोगम आतोग़ ओर्वोग़ मन्कल मतोग़. (अद्रमतोरिन यहुदिर कळ्‍वोग़तासिंदुर.) ओग़ येसुन ऊळतस्के, ओना मुनेह वासि, नेदगा कप मुळ्न्दिस, ओन इद्रम अर्जि कीतोग़: “बाबा, नीवा विचर मतेके, नाक सव्रे कीसि, नावा कळ्‍वोग़तुन तेंड पग़यकिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","इतस्के, “अह इतेके अले, नावा विचर मन्ह्‌ताये! निमा सव्रेम आम,” इनजोर येसु इतोग़. पया (यहुदिरा मोंडरोगमतोन इटवद नोमळता अडोतुन नोमवा,) येसु ओन कय आहच बोयतोग़. अस्के चट्‌नेन ओना मोंडरोगम मायता. ");
INSERT INTO mrr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","पया येसु ओन इद्रम उकुम ईतोग़ इतेके, “इके केंजा! इद पोल्‍लोतुन बोन्के बार वेहमा. इंजेके निमा कुदि अन्जि, बेस आतन इन्जि बूमयाह्‌क मात्रम तोहा. मोसानाङ अडोङ मतपु, मोंडरोगमता कळ्‍वोग़तुन तेंडनद मोक ईमु. सव्रेम आताह्‌कु मोक ईतोग़ इन्जि, बूमयाल सबेटोरिन वेहतनोग़, (अस्के नियगा मोंडरोगमता कळ्‍वोग़ मनो आयग़ा,)” इनजोरे मोंडरोगमतोन येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","निमा बोने वेहमा बहा इनजोर वेहचाय मति, येसुना पोल्‍लो मुनेतदिह्‌काय एक्‍वा पोकुर आसोर अता. अदिनेनाह्‌क येसुना पेग़्के-पेग़्के गोह्‌डिनाङ गोह्‌डिङ, ओनाङ केंजलाह ओसो सबे रीतिना बेमरतग्डाहि बेस आयलाह, ओनगा वांदुर. ");
INSERT INTO mrr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","मति देवुळतुन पार्तना कीयह्‌पा, तना वग़ोग़े, बोग़े इलवा जागातगा अन्जि, देवुळबाबाना संगे येसु वळ्ह्‌किंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","अद्रमे उंद दिया बाताल आता इतेके, येसु बोनाय लोतगा देवुळता पोल्‍लो काग़्हचोर मतोग़. ओनाङ केंजवालोरगा उय्तुर परुसिरा तुंगातोर ओसो यहुदिरा सास्त्रमगूरुर उदिस मतोर. वेरु गालिल पटटाङ, यहुदा पटटाङ सबे नाह्‌कनाहि, अहे येरुसलेम सहरताहि, अगा वास मतोर. अद लोतगा येसु ओरिन काग़्हचोर मतोग़. अगा देवुळता लाव येसुसामिनगा मताह्‌कु, रोगमतोरिन बेस कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","अचोटेन ऊळाट, अगा उय्तुर बोरो, कय्क-काल्क वाग़तोग़ ओर्वोग़ मन्कन, कटुल अग़्के ततोर. तचि वेनु येसु सव्रे कीयनोग़ इनजोर, लोता लोप्पा ओसि, येसुना मुनेह तासलाह ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","मति लोकुर अग़दुह्‌क तिळ्ह्‌प अरनाह निंदिस मतोर. ओन लोप्पा ओयलाह, वेरिह्‌क अग़ दोर्को. अग़ दोर्कवाह्‌कु, वेर पायरिनग्डाह लोता पोग़ोन वेसळतगा तग़्ङतोर. तग़्ङिस वेसळतुन कटुल पोदनाह, बेरा बूका कीतोर. अद बूकातग्डाहि, ओग़ तेदवोग़ मन्कन कटुल अग़्के, मुडा नडुमि येसुना मुनेह रेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","येसु ओरा विस्वसतुन ऊळिसि, ओग़ कय्क-काल्क वाग़तोनु, “अल पेका, नना नीवाङ कसुर्कना मापि कीय्ह्‌नन,” इद्रम इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","इतस्के सास्त्रमगूरुर ओसो परुसिर येसु इतदिन केंजिसि, वेर तमतमाये, “ऊळाट वेग़ मन्कल उगसे, देवुळतन इतपे बह पोग़यिह्‌तोग़! देवुळतुन विळ्सिस इतेके बोग़े पापमतुन मापि कीया पग़वोग़,” इनजोर विचर कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ओरा पोटाताङ विचर्किन पुन्जि येसु इतोग़, “मीवा पोटाते नावा लोप्पा बाराह्‌क कुळ्सा वळ्ह्‌किह्‌निर रा? ");
INSERT INTO mrr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","वेग़ रोगमतोनु, ‘नीवाङ कसुर्कना मापि आता,’ इह इतेके अल्कोया? बार वेनु ‘तेदिस अन,’ इनदनद अल्कोया? ");
INSERT INTO mrr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","इंजेके नना माने-मन्कना नडुम पुटटोनन मन्जि, देवुळतेनाह नयगा इद बूमते पापमतुन मापि कीयनद अदिकर इंका मन्ह्‌ता इन्जि, मीक तोहतकन,” इतोग़. इन्जि कय्क-काल्क वाग़तोग़ मन्कनु, “नना नीक वेहतलाह आतन, अले! तेदा! नीवा कटुल पोस लोन अन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","इताहे ओग़ बेद कटुदगा अर्स मतोग़, अग्डाह सबेटोरा मुनेह पोर्क तेदिसि, देवुळतुन जोहर कीसोर, तना कटुल कांजिस लोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","अद लोतगा जमा आतोरु पका बामतोर, बामिसि सबेटोर देवुळतुन जोहर कीयलाह आतोर. ओसो ओर पका रेयिसि, “माट कोनि नेंड बामनद कबळ ऊळतल अयो!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","पया नाटेनाहि पेसनेके, सिद्‌वा एतना नाकातगा, सिद्‌वा एनवाल लेवि पेदिरतोनु येसु ऊळतोग़. ओनगा अन्जि, “नावाङ कग़यवानिन आयकिन दय!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","इतस्के लेवि तना नवकरतुन विळ्सिसि येसुना संगे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","पया लेवि येसुन ओसो ओना तोळतोरिन तना लोन केयतोग़, केयिसि ओरेनाह्‌क उंद बेरा कुळ्प ईतोग़. ओरा संगे वेल्‍लाटोर लोकुर, सिद्‌वा एनवालोर ओसो दुस्रोर, उदिस गाटो तिनजोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","तिनदनदिन ऊळिसि, “मीट एग़्ङ वानाहि, सिद्‌वा एनवालोर, पाप्यहलोर, इद्रमतोरा संगे उदिस, बह तिनदना-उनडना कीयलाह आतिर रा?” इनजोर परुसिर ओसो तमा सास्त्रमगूरुर, येसुनाङ कग़यवालोरगा वासि, कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ओरा वळ्ह्‌कनदिन केंजिसि, येसु ओरिन इद्रम इतोग़, “रोगमलेवोरु डाक्‍टरनके अनोर, मति रोगम मतोरे तमा दुकतुन पोहतलाह दास्तोर, पुनविरा? ");
INSERT INTO mrr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","अद्रमलेह्‌काने माट नेह्‌नोरोम इनवालोरिन आयो, मति पापिरिन, तमा पापमतुन विळ्सिसि नयके वाटु, इनजोरे केयलाह नना वातन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","पया अगा मतोर बोरो येसुन इद्रम ताल्ह्‌कलाह आतोर, “योहननाङ कग़यवालोर ऊक-ऊके उपस कीसोर पार्तना कीस्तोर. ओसो परुसिराङ कग़यवालोर वने अद्रमे कीस्तोर. नीवाङ कग़यवालोर बारा, ऊक-ऊके तिनदना-उनडना कीसोरेन मन्ह्‌तोर, इद बहु?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","अदिन केंजिसि, “मर्मिनस्के मर्म-पेकाल मनदह्‌पा, ओना गोततोरिन मीट उपस तासकिरा? ");
INSERT INTO mrr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","मति बेस्के कोटुलतोर वासि, मर्मपेकान ओरग्डाहि एग़्‍पिह कीसि पोस ओयनुर, इद्रमता वेला वायग़ा, अद तूकने ओर दुकम आसि तिनोर आयनुर. (अद्रमलेह्‌का नना वेरा संगे मनदह्‌पा, नावाङ कग़यवालोर उपस केवोर,)” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","(इतापया ओरिह्‌क ओसो पुन्पिह कीयनाङ पीटोनेइद्रम वेहतोग़.) “इदिन केंजाटु, पाळ्ना गेंदेता अग़ता बूकातगा मेतलाहि, पूना गेंदेतुन रीचिसि ताना तुक्ळेतुन बोग़े ओल्सोग़. ओल्सतेके पूना गेंदे वने करब आस्ता, ओसो अद पूना गेंदेतुक्ळा पाळ्ना गेंदेतगा बेस ओप्पो. ");
INSERT INTO mrr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अद्रमे ओयवदु पूना अंगुर जोमातुन पाळ्ना तोलाजोर्काते बोग़े एन्दोग़. एन्दतेक इसि, मिङतद जोमा ओयिसि बोल्गिह्‌ता, जोर्का इंका ओसो आङिसि अग़यह्‌ता, अग़तापया जोमा पूरा वाङिह्‌ता. ओसो जोर्का वने बूळेम आस्ता. ");
INSERT INTO mrr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","अदिनेनाह्‌क मिङतद अंगुर जोमातुन, पूना तोलाजोर्कातगान वळयना, पूना तोलाजोर्का आङतेके अग़वो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","बोग़े मन्कल पाळ्ना अंगुर जोमातुन उटापया, ओन्क पूना अंगुर जोमा विचरे वावो. ओग़ पाळ्नातुने बेसु इन्ह्‌तोग़,” इनजोर वेहतोग़. (नना पूनाङ-पूनाङ पोल्‍लोङ काग़्हतह्‌नन, अविस्कनगा पाळ्ना रिवजताङ पोल्‍लोङ काल्ह्‌पनायो इन्जि, येसु इव पुन्पिह कीयनाङ पीटोङ वेहतोग़.) ");
INSERT INTO mrr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","उंद देबा इद्रम आता इतेके, येसु वारमता पोल्वादियाते गोह्‌क अय्स मतव, बोराङो पोलह्‌कना नडुमतुह्‌क अनजोर मतोग़. दायह्‌पा येसुनाङ कग़यवालोर गोह्‌कनाङ एन्किन ऊचिसि, पोलेतुन तेंडलाहि कय्कने तुर्स्किसि पेनेह्‌क तिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","तेन ऊळिसि अगा मतोर उय्तुर परुसिर येसुन इतोर, “पोल्वादियाते बेदे कबळ कीयलाह पोलो, तान मीट बह नोमविर?” इनजोर ओरिन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","अस्के येसु इद्रम इतोग़, “मुनेटा कालमते दाविद राजाल तनाङ ऐंगेटोर बार, कग़्व वसतस्के बह कीतोर, इद पोल्‍लोतुन मीट देवुळता सास्त्रमते बेस्केन अर्वविरा? ");
INSERT INTO mrr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ओरु देवुळता रावुळतगा बह अतोर; अगा देवुळतुह्‌क वाटटाङ बेव आरिङ बूमयालोरिन विळ्सिस, दुस्रोरिह्‌क तिनदलाह पोलोङ आंदुङ; पोलवेकाय, अवे आरिन बूमयालोर दाविदिह्‌क ईतोर, ओग़ पया तनाङ ऐंगेटोरिह्‌क तूसिसीतोग़. (अस्के देवुळि दाविद राजानु तपतिन इनो अले,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ओरिन ओसो इतोग़, “नना माने-मन्कना नडुम पुटटोनन मन्जि, पोल्वादियाते पोलनदिन, पोलवदिन वेहतनद अदिकर नाक मन्ह्‌ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","अद्रमे ओसो उंद देबा, येसु पोल्वादियाते यहुदिरा उंद पार्तनाता लोन अन्जि, काग़्हतलाह आतोग़. अगा ओर्वोग़ वाग़ता कयदोग़ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","अद लोतगा उय्तुर सास्त्रमगूरुर ओसो परुसिर, पोल्वादियाते ओग़ मन्कना कयदुन येसु सव्रे कीस्तोग़ा, बार केवोग़ा, इनजोर ऊळसोर मंदुर. (सव्रे कीतोग़ इतेके, माट पोल्वादियाते येसुना कबळ कीयनद तप तोहतकोम इनजोर इंदुर.) ");
INSERT INTO mrr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","मति येसु मात्रम ओरा पोटालोप्पाडाङ पोल्‍लोन पुतोग़. पुन्जि ओग़ वाग़ता कयदोनु, “नडुम वास निल्म!” इतोग़, इतस्के ओग़ तेदिस नडुम नितोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ओग़ मन्कल तेदतस्के, येसु अगा मतोरिन इतोग़, “नना उंद पोल्‍लो मीक ताल्ह्‌किह्‌नन, पोल्वादियाते बाताल पोलिह्‌ता? बेसता कबळ कीयनदा, बार लाग्वा कबळ कीयनदु? जीवातुन पिसिह कीयनदा, बार बूळे कीयनदु? वेहाट!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","येसु सबेटोरक्‍के ऊळतोग़, मति बोग़े बह वळ्ह्‌कोग़. वळ्ह्‌कवाह्‌कु वाग़ता कयदोन इतोग़, “नीवा कय आहा!” इताहे ओग़ तना कयदुन आहतोग़. आहतस्के ओना कय पूरा सव्रेम आता. ");
INSERT INTO mrr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","मति सास्त्रमगूरुर ओसो परुसिर पका ओङ आसि, पलत पेसिस, येसुन बह कीस हव्ककल इनजोर, तमतमाय वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","पया उंद दिया पार्तना कीयलाह, येसु उंद गुड्रातगा अतोग़. अन्जि नग़्का पिळ्‍विळ देवुळतुन पार्तना कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","पंङवियतस्के कग़यवालोर सबेटोरिन तनगा केयतोग़. केयिसि ओरग्डाह बारा मन्कलोरिन आचतोग़, आचिसि ओरिन तनाङ बळयिर इनजोर पेदिर तासतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ओर बारा मन्कलोराङ पेदिर्क इह मन्ह्‌ताङ: सिमोन (वेन पत्रु इनजोर, येसु दुस्रा पेदिर तासिस मतोग़), सिमोनना तमोग़ आंद्रेयाल, जेबेदिनाङ मग़्कु याकुब ओसो योहन वेर तमोग़ इर्वुर, पिलिप, बार्तोलोम, ");
INSERT INTO mrr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्याल (सिद्‌वा एनवाल लेवि, ओन मत्याल वने इंदुर), तोमाल, अल्पुना मग़ि याकुब, सिमोन (वेग़ रोम सर्करता अडम पार्टितोग़ मतोग़). ");
INSERT INTO mrr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","तदु इनवाल यहुदाल, ओसो यहुदा इस्केर्योत (वेग़े आक्रिते येसुन कोंटेतोरा कयदे पोसीतोग़). ");
INSERT INTO mrr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","पया येसु ओरा संगे गुड्रापोग़ोटाहि रेगिसि, गुड्राकचुदा पलातगा नितोग़. अगा ओनाङ कग़यवालोर वेल्‍लाटोरे मतोर. ओसो येरुसलेम सहरताहि, यहुदिरा बूमताङ दुस्राङ नाह्‌कनाहि, सम्दुरकचुदा सोर-सिदोन एरियाताहि, वेल्‍लाटोर लोकुर ओनगा जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जमा आतोरग्डाहि उय्तुर ओग़ वेहतनाङ पोल्‍लोङ केंजलाह वास मतोर. उय्तुर बार तमाङ रोगह्‌कनग्डाह सव्रेम आयलाहि वास मतोर. देयह्‌क पोस मतोर वने वासि सव्रेम आंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","देवुळताहि सव्रे कीयनद लाव येसुनगा मताह्‌कु, ओग़ सबेटोरिन सव्रे कीसोर मतोग़. अदिनेनाह्‌क सबेटोर ओन बोयलाह ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","पया येसु तनाङ कग़यवालोरिन ऊळिस इद्रम इतोग़, “बोर लेवोरिर मह्‌निर, मीट देवुळता देय्वातोरिर. देवुळबाबाल मियद्रमतोरिह्‌के राजाल आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","बोर इंजेक कग़्विह्‌क तिपलते मह्‌निर, मीट देवुळता देय्वातोरिर. देवुळि मीक पंजिह कीयग़ा. बोर इंजेके अळसोर कनिर पोहतह्‌निर, मीट देवुळता देय्वातोरिर. पेग़्के मीट गिर्दाते कवयकिर. ");
INSERT INTO mrr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“माने-मन्कना नडुम पुटटोनाङ मीट कग़यवालोरिर मनाह्‌कु, लोकुर मीकु कोंटे कीयनुर, मीकु पूंडिस ईयनुर, मीकु पास्कनुर, मीक लागोर इनजोर मीवा कदर रेहतनुर, अस्के मीट देवुळता देय्वातोरिर. ");
INSERT INTO mrr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","बोर मीवा विरुद मन्ह्‌तोर, वेराङ तादोर-बाबोर वने अद्रमलेह्‌काने मुनेतोर देवुळता सेतेम कबुरतोरिन तिपल कीतोर, इदिन सीता कीम्ह्‌टु. केंजाट, ओर कबुरतोरा लेह्‌का, मीक वने देवुळदीपते बेरा इनम दोर्कग़ा. अदिह्‌क मीक तिपल कीयनस्के, मीट गिर्दाते एंदना-पाग़ना कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","येसु ओसो इद्रम इतोग़, “ए मता मन्कलोरिर! मीट देवुळता देय्वालेवोरिर! बाराह्‌क इतेके इद बूमतगा मीवा मालसोमता सुकम, अचोने मीक दोर्कग़ा! ");
INSERT INTO mrr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","इंजेके तिंड-बंड मनवालोरिर! मीट देवुळता देय्वालेवोरिर, पेग़्के मीट कग़्वते मनदकिर. इंजेके कवयलाह आतोरिर! मीट देवुळता देय्वालेवोरिर, पेग़्के मीट आलिह कीस अळयकिर. ");
INSERT INTO mrr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","इंजेके सबेटोरा कदर दोर्किह केवालोरिर! मीट देवुळता देय्वालेवोरिर. बोर मीक कदर ईस्तोर, वेराङ तादोर-बाबोर वने मुनेतोर जोल कबुरतोरिह्‌क अद्रमे कदर ईंदुर. (वेर जोल कबुरतोरा लेह्‌का, मीक वने सिक्सा दोर्कग़ा.) ");
INSERT INTO mrr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“इंजेके नावा पोल्‍लोतुन केंजिस ताकवालोरिर, मीक नना बाताल वेहतह्‌नन, बेस केंजाटु. मीवा विरुदतोरिन जीवा कीम्ह्‌टु. मीक कोटुल केवालोरिन बेस ऊळाटु. ");
INSERT INTO mrr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","बोर मीकु सरप ईस्तोर, ओर बेस पिसिर इनजोर, देवुळतुन कोळ्‍व कीसोर ताल्ह्‌काटु. बोर मीकु तिपल कीस्तोर, ओरेनाह्‌क देवुळतुन पार्तना कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","बोग़ाय नीवा उंद बुकातुन चापुळ ईतेके, दुस्रा बुकातुन वने चापुळ ईयलाह मुनेह कीमु. ओसो बोग़ाय अग़-ओङते निमा पोग़ोट्क केग़तद कोटजगातुन तेंडिस ओतेके, ओन्क नीवा आङतुन वने ओयलाह ईमु. ");
INSERT INTO mrr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","बोग़ाय नीक बातालाय ताल्ह्‌कतेके, ओन्क अद ईमु. ओसो बोग़ाय नीवा मालसोमतुन ओतेके, नावा नाक मल्हच ईम इनजोर ताल्ह्‌कमा. ");
INSERT INTO mrr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","लोकुर मीवा संगे बेद्रम ताकना इन्जि मीवा विचर मन्ह्‌ता, अद्रमे मीट ओरा संगे ताकाटु. ");
INSERT INTO mrr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“बोर मीक जीवा कीस्तोर, सिरप ओरिने मीट जीवा कीतिर इतेके, मीक देवुळि बाताल पाय्दा ईयग़ा? देवुळतुन पुनवोर पापिर वने अहे कीस्तोरा, केवोरा? ");
INSERT INTO mrr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अद्रमे मीक बेस ऊळवालोरिह्‌के मीट बेसताङ कबस्क कीस ईतेके, तानेनाह्‌क वने देवुळि मीक बाताल पाय्दा ईयग़ा? देवुळतुन पुनवोर पापिर वने अहे कीस्तोरा, केवोर? ");
INSERT INTO mrr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","मीटु करा ईयनस्के, ओसोवने मल्हच एवालोरिह्‌के करा ईतेके, तानेनाह्‌क देवुळि मीक बाताल पाय्दा ईयग़ा? देवुळतुन पुनवोर पापिर वने तमा ईतद करा, पूरा मल्स दोर्कग़ा इनजोर पुन्जि, ओर्विह्‌क-ओर्वोग़ करा ईस्तोर. ");
INSERT INTO mrr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","अद्रम केवा, मीवा विरुदतोरिन वने जीवा कीम्ह्‌टु, ओरिह्‌क बेसताङ कबस्क कीसीम्ह्‌टु. ओसो मल्स दोर्कग़ा इनजोर, सीता केवालेवा करा ईम्ह्‌टु. अस्के देवुळि मीकु बेरा इनम ईयग़ा, मीटु सबेट्काय बेरा देवुळताङ मग़्क-मयास्‍क आयकिर. बाराह्‌क इतेके देवुळता सीता केवोरा ओसो लाग्वोरा पोग़ोन वने, देवुळि गूनम तोहतह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","बेद्रम मीवा देवुळबाबाल लोकुरिन दया कीस्तोग़, अद्रम मीट वने दया केवालोरिर आम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“दुस्रोरा तप तोहमाटु, तोहतिर इतेके देवुळ वने मीवा तप तोहतग़ा. दुस्रोनु कसुरतोनिन इनजोर इनमाटु, इनवेके देवुळि मीक वने कसुरतोरिर इनो आयग़ा. दुस्रोरिन मापि कीम्ह्‌टु, कीतेके देवुळि मीक वने मापि कीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दुस्रोरा गर्ज मतेके, ओरिह्‌क चिव्टम आयवालेवा ईम्ह्‌टु, ईतेके देवुळि मीक वने ईयग़ा. बेसतल बुदतोर साव्कर्क, गोट्‍टातुन निहच कोग़िस-कोग़िसि, नेल पोवनाह मेल्हचि, मीवा जोर्कातगा वळयनुर, अद्रमलेह्‌का मीक ईयग़ा. अहे बेद गोट्‍टाते मीट दुस्रोरिह्‌क कहच ईय्ह्‌निर, अदे गोट्‍टाते देवुळि मीक कहच ईयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ओसो येसु इद्रमता पुन्पिह कीयनद पीटो वेहतोग़, “बोग़ाय गुडि, दुस्रोग़ गुडिन अग़ तोहचीया पग़यह्‌तोग़ा? बह वेर इर्वुर आसि बोंदातगा अरवोर आयनुरा? ");
INSERT INTO mrr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","बोग़ाय कग़यवाल तना गूरुह्‌क वीळिस बेस्केन बेरोग़ आयोग़, पुनविर? मति गूरुनाङ पूरा कग़यिसि, ओग़ कग़यवाल गूरुना लेह्‌कान आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“निमा नीवा कोंडाते मनदनद इळ्पेलेह्‌काडा बेरा तपतुन सीता केवा, नीवा गोतयाना कोंडाता पोडलेह्‌काडा इचीटा तपतुन बाराह्‌क ऊळिह्‌निन? ");
INSERT INTO mrr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","आपुना कोंडाता बेरा इळ्पेतुन ऊळवा, नीवा कोंडाता पोडि नाक तेंडलाह ईम इन्जि, निमा नीवा गोतयान बह इनदा पग़यकिन? एय सोङ केवानिन! मुने निमा नीवा कोंडाता इळ्पेतुन तेंडा. ताना पया नीवा गोतयाना कोंडाता पोडि तेंडलाह, बेस ऊळ पग़यकिन. ");
INSERT INTO mrr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“सबे मराङ तमाङ कायानग्डाहे पुनदा वास्ताङ. बेदे बेसतल मरा लाग्वाङ कायाङ आदो. अहे करबता मरा बेसताङ कायाङ आदो. लोकुर कोयेना जपताहि तोया पंडिङ कोयोर. अहे लिंगुळ आपाना जपताहि रेंगाबेद्रिङ कोयोर. ");
INSERT INTO mrr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","बेसतोग़ मन्कल तना पोटाताहि बेसताङ पोल्‍लोङ पेसिह कीस्तोग़. अद्रमे लाग्वोग़ मन्कल तना पोटाताहि लाग्वाङ पोल्‍लोङ पेसिह कीस्तोग़. बाराह्‌क इतेके मन्कना पोटातगा मुनेताहि बेव पोल्‍लोङ निंदिस मन्ह्‌ताङ, अवे पोल्‍लोङ ओना तोडटाहि पेसिह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“नना वेहतनव पोल्‍लोन केंजविर इतेके, नाक बाराह्‌क ‘सामि, सामि’ इह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","बोग़ नयगा वासि, नावाङ इव पोल्‍लोङ केंजिसि, अहे ताकिह्‌तोग़, ओग़ मन्कल बेद्रमतोग़ आंदोग़, इदिन नना मीक वेहतह्‌नन, केंजाटु. ");
INSERT INTO mrr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ओग़ मन्कल बेद्रमतोग़ इतेके, तना लोन दोहतह्‌पा, पर्पा जागातगा वेल्‍लाह नालिङ तर्विसि, पाय्वाङ दोहचि लोन तेहतोग़. तेहतापया उड्रा वाता, ओसो एताङ लच्काङ वने वासि, लोतुन दल्गताङ, तेला मति अद लोन मुटो. बाराह्‌क इतेके, तानाङ पाय्वाङ पर्पा जागाते दोहतव मताङ. ");
INSERT INTO mrr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","मति बोग़ नावा पोल्‍लोतुन केंजिसि, अह ताकोग़, ओग़ इद्रमतोग़ मन्कल आंदोग़ इतेके, तना लोन दोहतह्‌पा, पाय्वाङ दोहवाये, ओरेहे तोळ्योतगा लोन तेहतोग़. तेहतापया उड्रा वासि लोतुन दल्गता, अस्के अद लोन मुटिस, पूराय बूळेम आता,” इनजोर येसु अगा जमा आतोरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","येसु लोकुरिन वेहतना मतव पूरा पोल्‍लोन वेहतापया, कापेर्नाग़ मल्स अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","अद नाटेनगा ओर्वोग़ दुस्रा जाततोग़ सीपय्कना दरोगाल मतोग़. ओना साकुर केवाल ओर्वोग़ ओर्युलतोग़ मतोग़. वेग़ साय्बाल ओन पका जीवा कींदोग़. उंद दिया बाताल आता इतेके, ओग़ ओर्युलतोग़ दुक अर्सि, डोलनाह आस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","अस्के ओग़ साय्बाल येसुना लोप्पा केंजतोग़, केंजतस्के उय्तुर यहुदि पेदल्कना संगे, “येसु नावा लोन वासि, नावा ओर्युलतोन सव्रे कीयेग़,” इनजोर ओनगा कबुर लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ओर पेदल्क येसुनगा वासि, गोंडगोंड आसोर, इद्रम अर्जि कीतोर इतेके, “ओग़ दरोगान साय्ता कीम गूरु, ओग़ बेसतोग़ मन्कल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","मावोर यहुदिरिन जीवा कीस्तोग़. ओग़े मावा जाततोरेनाह्‌क पार्तनाता लोन वने पंडटोग़. अदिनेनाह्‌क ओना ओर्युलतोन सव्रे कीसीम गूरु,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","इतस्के येसु ओरा संगे दायलाह पेसतोग़. अनेक-अनेक ओना लोन एरे-एरे एवनेके, ओग़ साय्बाल तना गोततोरिन येसुनगा इद्रम कबुर लोहतोग़: “ए गूरु, निमा तिपल आयमा! निमा नावा लोनलोप्पा वायना इन्जि, नना लायक इलेन. ");
INSERT INTO mrr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","ओसो नना नियगा वायना, इचोन वने लायक इलेन. नना वने ओर्विना कय इळ्न मन्जि कबळ केवानन आंदन, नावा कय इळ्न वने उय्तुर सीपय्क मन्ह्‌तोर. नना बोनाय ‘अन!’ इनजोर वेहतेके ओग़ दास्तोग़, दुस्रोन ‘वाय!’ इनजोर केयतेके ओग़ वास्तोग़. अहे नावा साकुर केवानु ‘इद कीम, रा!’ इनजोर वेहतेके, अद कबळतुन ओग़ कीस्तोग़े. (अद्रमे इद रोगमता पोग़ोन वने नीवा अदिकर मन्ह्‌ता,) अदिनेनाह्‌क निमा मात्रम अग्डाहे उंद पोल्‍लो वळ्ह्‌कतिन इतेके, नावा ओर्युलतोग़ सव्रेम आयनोग़,” इनजोर कबुर लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","इद पोल्‍लोतुन केंजिसि, येसु पकाय बामतोग़. अस्के पेग़्के मिळ्न्दिस तना पयाह वावालोर मुडुन इतोग़, “इके केंजाट, नना वेहतह्‌नन, इचोटा बेरा विस्वस नाकु मावोर इस्रयेलतोर यहुदि जाततोरगा, बोनगान बह दिसो!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","पया साय्बाना गोततोर लोन मल्स अतोर, अस्के ओग़ ओर्युलतोग़ पूराय सव्रेम आतदिन ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","पया येसु नायिन इनदनद नाग़ अतोग़. ओना संगे ओनाङ कग़यवालोर ओसो वेल्‍लाटोरे लोकुर वने अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","येसु अद नाटेनगा ओळियनद अग़दगा एरे एव्स मतोग़. अचोटेने ओर्वोग़ हातोना सेत्तातुन गति कीयलाह, नाटेनोर कांजिस ओसोर मतोर. वेग़ हातोग़ लेयोग़ मन्कना तलोग़ रांडे आंचाह्‌कु, वेग़ वग़ोग़े मग़ि मतोग़. नाटेनोर वेल्‍लाटोर ताना संगे अनजोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","अद आंचान ऊळिसि, येसुसामिह्‌क पका मान वसता. अदिनेनाह्‌क तानु, “निमा अळमा बायि!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","इतापया, अन्जि सेत्ताता डोह्‌लातुन बोयतोग़, बोयतस्के कांजिस ओयवालोर अगान रोमतोर. अस्के येसु हातोन इतोग़, “पेका! तेदा!” ");
INSERT INTO mrr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","इतस्के ओग़ हातोग़ मन्कल जीवा अर्सि, वळ्ह्‌क बोटटोग़. पया येसु ओग़ मन्कन तलिनगा ओस ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","अस्के अगा ऊळतोर सबेटोर पका रेयतोर. रेयिस इद्रम इतोर, “देवुळि तना मन्कलोरिन तोळ ईयलाहि वाता रा! तना कबुरतोग़ पका बेरोग़ मन्कन मयगा लोहता,” इनजोर देवुळतुन जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","पया येसुना इद पोल्‍लो पूरा यहुदिरा बूमते, ओसो ताना सर्ने मनदनव नाह्‌कने, आबुर आता. ");
INSERT INTO mrr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","आबुर आतस्के, एग़ मीहवाल योहननाङ कग़यवालोर इव पूरा केंजतव पोल्‍लोन, जेलतगा अन्जि योहनिह्‌क वेहतोर. वेहतस्के ओग़ इर्वुर कग़यवालोरिन केयिसि, ओरिन येसुसामिनगा इद्रम ताल्ह्‌कलाह लोहतोग़ इतेके, “बोग़ देवुळ लोहवाल पिसिह केवाल राजाल वावाल मतोग़, ओग़ बह निमानेया? बार माटु दुस्रोना अग़ ऊळकोमा?” इनजोर येसुनगा लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","वेर कग़यवालोर येसुनगा वासि इद्रम इतोर, “गूरु, देवुळता पेदिरते एग़ मीहवाल योहन, ‘बोग़ देवुळ लोहवाल पिसिह केवाल राजाल वावाल मतोग़, ओग़ बह निमानेया? बार माटु दुस्रोना अग़ ऊळकोमा?’ इनजोर, माक नियगा ताल्ह्‌कलाह लोहतोग़,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","इतस्के येसु अगा मतोर वेल्‍लाटोर दुकतोरिन सव्रे कीतोग़, मुर्तिय तेद पुनवोरिन, देयह्‌क पोस मतोरिन, सव्रे कीतोग़; ओसो वेल्‍लाटोर तोववोरिन तोवनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","अह कीसि ओरिन इतोग़, “इंजेके मीट बाताङ केंजतिर, ऊळतिर, अविस्किन मल्स अन्जि योहनिह्‌क वेहाट: नाक देवुळ ईतद लावते, गुडिर तोवयलाह आतोर, कूटालोर ताकलाह आतोर, मोंडरोगमतोर सव्रेम आस्तोर, एव्डालोर वेनदलाह आतोर, हातोर बार तेग़्किह्‌तोर, गरिबतोरिह्‌क बेसता कबुर केंजलाह दोर्किह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","इव सबेटविन ऊळिसि, नना देवुळ लोहतोग़ पिसिह केवानन आंदन इन्जि, बोर उन्क-मन्क आयोर, ओर देय्वातोरु,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","पया योहननाङ कग़यवालोर अग्डाहि पेसिस अतोर. अस्के येसु मुडोरा संगे योहनना लोप्पा वेहता बोटटोग़, “पेळ्ह्‌कल बूमते मीटु योहननाङ केंजलाह अतिर, अस्के बेद्रमता मन्कन ऊळलाह अन्जि? वळ्यते विग़्कु-वग़्कु आयनद काग़रोंडालेह्‌का तना पोल्‍लोतुन मिळ्हच-मिळ्हच वेहवान ऊळलाह अन्जिया? ");
INSERT INTO mrr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","बार रेसेम गेंदेङ उहतोग़ मन्कन ऊळलाह अन्जिया? केंजाटु, रेसेम गेंदेङ उहतोर मन्कलोर, सबे रीतिना मालसोम मनवालोर, पेळ्ह्‌कल बूमतगा मनोर, ओर राजमिदेनगा मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","मति मीट बाताल ऊळलाह अन्ज मतिर, वेहाट? देवुळता कबुरतोन ऊळलाह, आयोया? मीक नना वेहतह्‌नन, मुनेतोर देवुळता कबुरतोरा सेवातुह्‌क वीळिस, योहनना सेवा मता, अद्रमतोने मीट ऊळलाह अन्जि. ");
INSERT INTO mrr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ओनाय लोप्पा देवुळि मुने तना लोहवाल पिसिह केवान वेहच मता, ‘ऊळा, नना नावा बळयिन नीवा मुने लोहतह्‌नन, निमा लोकुरा जीवातगा वायना इन्जि, नीवा अग़दुन ओग़ तीर्ह्‌कनोग़.’ इनजोर देवुळता सास्त्रमते रासतद मन्ह्‌ता. (ओग़ बळयि इतेके योहनिये.) ");
INSERT INTO mrr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","इह केंजाट, नना मीकु वेहतह्‌नन, देवुळताङ पाळ्नाङ अडोने ताकवालोरगा, देवुळता पेदिरते एग़ मीहवाल योहनिह्‌काय वीळिस, बोग़े बेरोग़ पुटोग़ आसि. मतिंगा बोरगा देवुळ राजेम कीस्ता, ओरग्डाहि सबेटोरिह्‌क उड्लोग़ वने योहनिह्‌काय बेरोग़!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(अगा मतोर वेल्‍लाटोर येसु वेहतद पोल्‍लोतुन केंजतोर. केंजिसि देवुळता अग़दुन सेतेमता अग़ि इतोर, लोकुर कोंटे केवालोरु सिद्‌वा एनवालोर इंका अहे इतोर. वेर सबेटोरिन योहन मुनेन देवुळता पेदिरते एग़ मीहच मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","मति परुसिर ओसो सास्त्रमगूरुर बार, योहन देवुळता पेदिरते एग़ मीहतह्‌पा मीवालेवा, देवुळि तम्क तोहतद अग़दे ताकोर.) ");
INSERT INTO mrr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","ओसोवन येसु इद्रम इतोग़, “(मीट योहननाङ केंजवोरिर, नावाङ इंका केंजवोरिर,) मीट बातोरिर इनदना, इके केंजाट. मीट बजरतगा कग़्सलाह उदवालोर पेकोरा लेह्‌काडोरिर! ओर पेकोर तमाङ गोतयालोरिन केयसोर इन्ह्‌तोर, ‘मीक इनजोर माट हामुर रेगाताङ पाटाङ ओतोम, तेला मति मीट अलो देवन इनजोरे, अळसोरे अर्युल पायविर. पया माटु तुर्स्कने रेला पाटाता रेगा ऊरतोम तेला मति मीट एंदविर.’ ");
INSERT INTO mrr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“अद्रमलेह्‌काने एग़ मीहवाल योहन पापेन तिंदोग़, अंगुर जोमा उनोग़, अदिह्‌क इसि, ‘ओनगा देयम मन्ह्‌ता,’ इद्रम मीट ओन इह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मति माने-मन्कना नडुम पुटटोनन बेस तिनजोर-उनजोर वाताह्‌क इसि, ‘ओन ऊळाट, ओग़ उळ्बे, ओचे, सिद्‌वा एनवालोरा, पाप्यहलोरा गोतयाल!’ इद्रम मीट नाक इह्‌निर. (बजरते मनवालोर वेर गळ्स पेकोरा लेह्‌काने, योहन अह मताह्‌कु वने मीक अरवोये, नना इह मताह्‌क वने मीक अरवोये.) ");
INSERT INTO mrr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","मति बोर देवुळता बुदते ताकिह्‌तोर, ओराङ कबस्क सेतेम दिसनुङ,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","पया उंद दिया सिमोन इनवाल परुसि मन्कल, येसुन तना लोन जावा उनडलाह केयतोग़. अस्के येसु ओना लोन अन्जि, जावा उनडलाह उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","अचोटेने बह आता इतेके, अद नाटे ओर्वोग़ परुसिना लोतगा येसु जावा उनडलाह वातोग़ इनजोर, उंद सिंड्रि आंचाह्‌क एर्का आता. अस्के अदु उंद बंडा-तीसाते अतर्नेय पोस अगा वाता. ");
INSERT INTO mrr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","वासि येसुना पेग़्के ओनाङ काल्कनगा उदिसि, अळसोरे तनाङ कनिर्कने येसुनाङ काल्किन नाहता. नाहचि तनाङ केल्कने ओनाङ काल्किन उम्चिंदु. पया ओनाङ काल्किन लोंडसोरे, अद अतर्नेयदुन ओनाङ काल्कनगा वळन्दु. ");
INSERT INTO mrr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","येसुन केयिस मतोग़ परुसि, अद आंचाळ अद्रम कीतदिन ऊळिसि, तनतनाय इद्रम विचर कीतोग़, “इद इतेके सिंड्रि आंचाळि! वेग़ मन्कल निटम देवुळता कबुरतोग़ मतेके, तन्क बोयनद आंचाळ बेद्रमता इनजोर पुनेग़, पुन्जि इद्रम कळ्‍वोग़ आयोग़ आवेग़,” इद्रम विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","अस्के येसु ओना पोटालोप्पाडा विचरतुन पुन्जि ओन इतोग़, “ए सिमोन, नीक उंद पोल्‍लो ताल्ह्‌किह्‌नन,” इतस्के ओग़ इतोग़, “बाताल पोल्‍लो गूरु?” ");
INSERT INTO mrr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","अस्के येसु इद पीटो वेहतोग़: “ओर्वोग़ साव्करनग्डाहि इर्वुर मन्कलोर करा तेंडिस मतोर. ओर्वोग़ एयुङ नूह्‌क वेंडटाङ बंडिङ, ओसो दुस्रोग़ बार पनस वेंडटाङ बंडिङ. ");
INSERT INTO mrr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","मति ओर इर्वुर आसि कोताङ मल्हच ईया पग़वोर, पग़वाह्‌कु वेग़ मन्कल ओर इर्वुरास करातुन मापि कीसीतोग़. अले! इंजेके ओर इर्वुरग्डाहि, बोग़ मन्कल करा ईस मतोन पका जीवा कीयनोग़, वेहा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","अस्के सिमोन इतोग़, “बोना वेल्‍ला करा मापि आता, ओग़े पका जीवा कीयनोग़ बहे,” इतोग़. इतस्के येसु ओन “निमा बराबर वेहतिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ओसो येसु अद आंचानके मिळ्न्दिसि, सिमोनिन इतोग़. “सिमोन! इद आंचान ऊळा. नीवाय लोन नना तिनदलाह वातन, मति नावाङ काल्क नोग़यलाह एग़ तता वेहविन, इद बार तनाङ कनिर्कने नावाङ काल्किन नाहचि, केल्कने उम्चता. ");
INSERT INTO mrr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","निमा इतेक नाक लोंडिस मन्जि जोहर केविन, इद बार नना लोप्पा ओळियतस्केडाह नावाङ काल्किन लोंडसोर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","नावा तलातगा नेय ओकिस नाक मान एविन, इद बार नावाङ काल्कनगा वेल्‍ला दाराता अतर्नेय ओकता. ");
INSERT INTO mrr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","अदिनेनाह्‌क नना नीक वेहतह्‌नन, इद आंचाना वेल्‍ला पापमता मापि आताह्‌कु, इद पका जीवा कीस्ता. मति बोना उचुने पापमता मापि आस्ता, ओग़ उचुने जीवा कीस्तोग़,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","पया येसु तान इतोग़, “नीवा पापि कबस्कना मापि कीसीतन.” ");
INSERT INTO mrr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","इतस्के ओना संगे जावा उनडलाह उदिस मतोरु, “वेग़ बेद्रमतोग़ मन्कल, देवुळतन इतपे पापमतुन मापि कीस्तोग़!” इनजोर बोनाङ ओग़े विचर कींदुर. ");
INSERT INTO mrr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पया येसु अद आंचान इतोग़, “नाक विस्वस कीताह्‌के, देवुळि नीक पापमताहि पिसिह कीता, गिर्दाते अन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","पया येसु सबे नाह्‌कने, देवुळि मन्कलोरगा राजेम कीयनद बेसता कबुरतुन पोकुर कीसोर तिरियलाह बोटटोग़. ओना संगे ओनाङ बळयिर बारा मुलु मंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ओसो उचुक आस्क वने ओरा संगे मंदुङ, अविस्कनग्डाहि मुने रोगह्‌किन, देयह्‌किन येसु पूंडिस मतोग़. उंदि मग्डला नाटेना मरिया पेदिरता आंचाळ अगा मता, येसु तानग्डाहि एळुङ देयह्‌किन पेसिह कीस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","दुस्रा आंचाळि इतेके योहना पेदिरतदु, अद कुजा इनवाल एरोद राजाना लोतुन ऊळेवाळे केवाना मुते मता. ओसो उंद सूसना पेदिरतद मता. इद्रम वेल्‍लाङे आस्क मताङ. इव आस्कु, तमाङ कोताङ येसुना सेवातुह्‌क कर्सा कींदुङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","अद्रमलेह्‌काने उंद दिया, येसुनगा नाह्‌क-नाह्‌कनाहि लोकुर वासोरेन मंदुर, वासि वेल्‍लामुलु अगा जमा आसोर मतोर. अस्के येसु ओरिन उंद पुन्पिह कीयनद पीटो इद्रम वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“उंद दिया ओर्वोग़ मन्कल विजा वीतलाह पेसतोग़. ओग़ वीतनेके उडुन विजा अग़दगा अरता, अदिनु अग़दुह्‌क अनवालोर ओय्ह्‌कतोर, ओसो पिटेङ वासि कतम तिताङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","उडुन विजा आद बंडाना जागाते अरता, (आदतगा पोग़ोन बर्बर तोळ्यो मताह्‌कु) मोन्ह्‌टटा. मति एद तेग़तस्के पदन लेवाह्‌कु, पोर्ह्‌काङ वाग़िस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","उडुन विजा कोये-जपिना जागाते अरता. पया कोये-जपिङ वने, वंज-सोपता संगे बेर्सिसि, वंज-सोपतुन हव्कताङ, बेर्स एवोङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","उडुन विजा इसि राब जागाते अरता. अरताह्‌कु अद उंद-उंद मोदुदुह्‌क नूटुह्‌काय (100) एक्‍वा पंटा वाता,” इनजोर येसु वेहतोग़. इव पोल्‍लोङ वेहचि, येसु जोरते केयिस इद्रम इतोग़, “मियग्डाहि बोरिह्‌क पुनदलाह गिर्दा मन्ह्‌ता, ओर नावा पोल्‍लोतुन बेस केंजिर!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","पया येसुनाङ कग़यवालोर ओनगा वासि ताल्ह्‌कतोर, “इद पुन्पिह कीयनद पीटोता बाताल अर्तम आस्ता गूरु?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","येसु ओरिन इतोग़, “मीक इतेके देवुळि तना राजेमताङ मकतव पोल्‍लोन पुनदलाह बुद ईता. दुस्रोरिह्‌क बार इव मकतव पोल्‍लोन, नना पुन्पिह कीयनव पीटोने वेहतह्‌नन. इतेके: ओर नावाङ कबस्किन ऊळलाह कोनि ऊळसोर मनदनुर, मति अविस्कना अर्तम ओरिह्‌क बेस्केन तेळियो आयग़ा, ओसो लोकुर नावाङ केंजलाह कोनि केंजसोर मनदनुर, मति ओरिह्‌क बेस्केन तेळियो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“इद पुन्पिह कीयनद पीटोता अर्तम इद्रम मन्ह्‌ता. अद विजा इतेके देवुळता पोल्‍लो आंदु. ");
INSERT INTO mrr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","विजा अरतद अग़ि इहलेह्‌का आस्ता. देवुळता पोल्‍लोतुन बोराय केंजिह्‌तोर, अस्के ओर विस्वस कीसि, देवुळ ईयनद पिसमुळतुन दोर्किह केमाकिर इनजोर, ओरा जीवातगा वीततद विजातुन, देयह्‌कना मुक्याल वासि माग़्ङनाह कीस्ता. ");
INSERT INTO mrr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","बेद आदतगा विजा अरता, अद इहलेह्‌का आस्ता. बोर पोल्‍लोतुन गिर्दाते चट्‌नेन केंजिह्‌तोर, मति अद पोल्‍लो ओरा जीवाते गडवाह्‌कु, गळ्के बहे विस्वस कीस्तोर. पया देवुळता पोल्‍लोतुन नमतेनाह्‌क अड्सनाय, तिपलाय वाता इतेके, चट्‌नेन ओर विस्वसताह जेक आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","कोये-जपिनगा अरतद विजाता जागा इहलेह्‌का आंदु. बोर पोल्‍लोतुन केंजिह्‌तोर, मति मनेक मनेके, सम्सरमताङ आल्सुळ्क, अनम-दनमता उळ्बे, इद दुनियाता गिर्दाता लालुस, इवु देवुळता पोल्‍लोतुन ओरा जीवातगा बेर्स एवोङ. पया अद पोल्‍लो बातय पाय्दाता आयो. ");
INSERT INTO mrr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","मति राब जागा इहलेह्‌का आंदु. बोर आपुना जीवातगा बेस-नेह्‌ना सेतेम बुदते पोल्‍लोतुन केंजिसि तासिह्‌तोर. पया ओर आरेम आयवालेवा, देवुळतुह्‌क विचर वातव कबस्क कीसोर दास्तोर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ओरिन ओसो येसु वेहतोग़, “बोग़ाय चिमलि नीर्विह कीसि, डूटलोप्पा मुळ्हच तासनोग़ा? इलवेके कटुल इळ्न तासनोग़ा? आयो, मति लोप्पा ओळियवालोरिह्‌क वेह्‌च दिसि इनजोर, तान बोव्लापोग़ोन तासिह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","अद्रमे सबे मकिह कीतव पोल्‍लोङ पङ्ने आयनुङ, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","अदिनेनाह्‌क देवुळता पोल्‍लोतुन बेस केंजाटु, बाराह्‌क इतेके, बोनगा पुनदनद बुद मन्ह्‌ता, ओन्कु देवुळि ओसो इंका ईयग़ा. मति बोनगा पुनदनद बुद इले, ओनगा बेचोन बुद दिसिह्‌ता, तान वने देवुळि ऊंदिस ओयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","पया अस्केन येसुना तलोग़ि, ओनाङ तमोर, ओनगा कलियलाह वातोर. मति वेल्‍लाय मुल सर्ने मताह्‌कु, ओना एरे दाया पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","अदिनेनाह्‌क बोरो येसुन वेहतोर, “गूरु, नीवा यायालि, नीवा तमोर नीक कलियलाहि पलते केपतोर,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","इतस्के येसु ओरिन इतोग़, “केंजाटु, देवुळता पोल्‍लोतुन केंजिसि अहलेह्‌का ताकवालोरे, नावा यायालि, नावाङ तमोर आंदुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","पया उंद दिया इद्रम आता इतेके, येसु तनाङ कग़यवालोरा संगे, गालिल सम्दुरते उंद ओडातगा तग़्ङतोग़. तग़्ङिसि ओरिन “अलेट! सम्दुरता अबर दडटेके दाकल,” इतोग़. इतस्के ओर दायलाह पेसतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ओर अनेक अनेके येसु उंजतोग़. अस्के सम्दुरतगा बेरा दूंदि वाता. वासि बेराङ-बेराङ लच्काने ओरा ओडातगा एग़ निंदलाह आता. अस्के ओर पका तिपलते अरतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","पया कग़यवालोर येसुनगा वासि, ओन तेहतोर. तेहचि इतोर “ए गूरु, तेदा! माट मुळ्न्दिह्‌नल,” इनजोर केयतोर. केयतस्के पया येसु तेदतोग़. तेदिसि दूंदतुन ओसो एताङ लच्काङ वायनविन दगाङ ईतोग़. अस्के तोप्नेन दूंद-मुर्गम मायता, ओसो लच्काङ वने मेर्क्ने आताङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","पया येसु कग़यवालोरिन इतोग़, “(नना मीकु पिसिह कीकन इनजोर,) नावा पोग़ोन विस्वस केविरा?” इतोग़. मति ओर पका रेयिसि, तमतमाय, “अलाले! वळ्‍दुन, एतुन उकुम ईस्तोग़, अव रेंड आसि वेना उकुमतुन केंजिह्‌ताङ अयो, इतेके वेग़ बेद्रमतोग़ मन्कल मनदनोग़ रा!” इनजोर ओर बामतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","पया ओर गालिल पटटाहि सम्दुरतुन वेंडिसि, गिरासेनिर इनवालोर दुस्रा जाततोरा एरियातगा एवतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","येसु तनाङ कग़यवालोर बार ओडाताहि रेगताहे, देयह्‌क पोयतोग़ गिरासा सहरतोग़ ओर्वोग़ मन्कल ओरगा वातोग़. ओग़ वेल्‍लाङे दियानाहि गेंदेङ केग़वा कूळलिय मंदोग़, ओसो लोन वने मनवा, डोलतोरिन पोहतनाङ पांजानगा मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","अद देयमि ओग़ मन्कन ऊक-ऊके पोय्न्दु. इद्रम पोयतस्के, लोकुर ओनाङ कय्किन-काल्किन गोल्स्कने दोहचि पह्‌रा मंदुर. मति ओग़ ऊक-ऊके गोल्स्किन देहन्दोग़, अस्के देयम ओन बोरे लेवा जागातेके पोस वितिंदु. पया येसु, अद देयमतुन ओनग्डाहि पेसिस दायलाह उकुम ईतोग़, अस्के ओग़ येसुना कालगडेम अर्सि “एय सबेट्क बेरा देवुळता मग़ि येसुनिन, निमा नाक बार्किया अडम आय्ह्‌निन? नना नीक अर्जि कीय्ह्‌नन, नाकु सिक्सा एमा,” इनजोर जोरते केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","येसु ओन, “नीवा पेदिर बाताल?” इनजोर ताल्ह्‌कतोग़. ताल्ह्‌कतस्के, ओन वेल्‍लाङे देयह्‌क पोस मताह्‌कु, “वेल्‍लाटोरोम” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","पया अव देयह्‌कु, येसुन इद्रम अर्जि कींदुङ इतेके, “माक देयमदीपता सिक्सा-बोंदातगा दायलाह उकुम एमा. ");
INSERT INTO mrr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ओके ऊळा, अगा मेटातगा वेल्‍लाङे गोह्‌ड पदिङ मेयसोर मन्ह्‌ताङ. माक अव पदिनगा लोहचीम,” इनजोर येसुन इताङ. अस्के अविस्किन येसु पदिनगा दायलाह ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ईताहे देयह्‌क चट्‌नेन ओग़ मन्कनग्डाह पेसिस, पदिना गोह्‌डटगा तुर्म्ने नेङताङ. अस्के गोह्‌ड पदिङ अद मेटा ओळ्सिये मुटेङ-मुळ्गेङ आसोर वितिस, सम्दुरता एतगा अर्सि कतमे मुळ्न्दिस डोलताङ. ");
INSERT INTO mrr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","पया पदिङ मेहवालोर इद्रम आतदिन ऊळिसि, रेयिस विततोर. वितिसि इद पोल्‍लोतुन गिरासा सहरतगा, ओसो एरे-गूरेताङ नाह्‌कनगा अन्जि वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","वेहतस्के बाताल बाताल आता, तान ऊळलाहि अग्डा लोकुर येसुनगा वातोर. वासि देयह्‌क पेसिस विततोग़ मन्कल येसुनाङ काल्कना एरे उदिस मतद ऊळतोर. ओसो ओग़ बेस गेंदेङ केग़्सि, बेस बुदते मतोग़. इदिन ऊळिसि, नाटेनोर येसुन रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","अगा येसु कीतद कबळतुन ऊळतोर मन्कलोर, ओग़ बेद्रम बेस आतोग़, अद कतमे लोकुरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","अस्के मावाङ कतम पदिङ बूळेम आताङ इन्जि, गिरासेनिरा एरियातोर सबेटोर पका रेयिसि, “निमा मयगा मनमा, इग्डाहि पेसिस अन,” इनजोर येसुन अर्जि कीतोर. अदिनेनाह्‌क येसु तनाङ कग़यवालोर बार, पेसिस दायलाह ओडातगा उदतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","येसु अग्डाहि दायह्‌पा, देयह्‌क पेसिस विततोग़ मन्कल, “नाक नीवा संगे वायलाह ईम, गूरु!” इनजोर अर्जि कीतोग़. मति येसु ओन इद्रम इनजोर मल्हच लोहतोग़ इतेके, ");
INSERT INTO mrr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“आयो निमा मल्स अन! देवुळि नियेनाह्‌क बेद्रमता कबळ कीता, तान मियग्डोरिन वेहा,” इनजोर इतोग़. इतस्के ओग़ मन्कल अग्डाहि मल्सि, तनेनाह्‌क येसु कीतद बेरा कबळतुन, कतम सहरमेटोरिह्‌क पूरा वेहचोर तिरियतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","पया येसु सम्दुरतुन वेंडिसि, गालिल पटटे मल्स वातोग़. अस्के ओग़ वायनदिन अग़ ऊळसोर मतोर सबेटोर लोकुर, ओन ऊळिसि पका गिर्दा आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","अचोटेने ओर्वोग़ यारोस पेदिरतोग़ पेदामन्कल येसुनगा वातोग़. ओग़ अग्डा यहुदिरा पार्तना कीयनद लोता मुक्याल मतोग़. ओग़ येसुनाङ काल्क अर्सि, “नावा लोन दय” इनजोर अर्जि कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","बाराह्‌क इतेके ओना बारा वय्सता मयाळि बेमरते डोललाह आस मता. पया येसु ओग़ मुक्याना संगे अनेके, मुडा लोकुर पका गर्दि आसि, दोबेङ-नूकेङ कींदुर. ");
INSERT INTO mrr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","अस्के अद मुडगा उंद आंचाळ मता. अद आंचाळ बारा वर्सानाहि कुर्माते बादा आंदु. अदु तनाङ पूरा कोताङ मत एवालोरिह्‌क ईसि मारिह कीता, मति तान बोग़े सव्रे कीया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","अद आंचाळ येसुन ऊळिसि, ओना पयाह वाता, वासि ओना गेंदे कोङतुन कुस्क्ने बोयता. बोयताहे ताना कुर्माता बादा मायता. ");
INSERT INTO mrr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","अस्के येसु “नाक बोग़ बोयतोग़ रा?” इनजोर ताल्ह्‌कतोग़. ताल्ह्‌कतस्के अगा मतोरु, “माट आयोम! माट आयोम!” इनजोर इतोर. पया पत्रु इतोग़, “गूरु! इद मुल नीवा सर्ने मन्जि, नियके दोबेङ-नूकेङ कीसोर, वेल्‍लाटोर बोयिस मनदनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","मति येसु इतोग़, “आयो, बोग़ो मति सव्रेम आयनेनाह्‌क नाक बोयतोग़, नयग्डा सव्रे कीयनद लावते ओग़ बेस आतदिन पुतन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","अद आंचाळ पया, नना बोयतदिन वेग़ पुतोग़ इनजोर, रेयते साङसोर वासि, येसुनाङ काल्क अरता. अर्सि ओन बाराह्‌क बोयता, ओसो बेद्रम चट्‌नेन सव्रेम आता, इद पोल्‍लोतुन सबेटोर लोकुरा मुनेह वेहता. ");
INSERT INTO mrr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","वेहतस्के येसु तान इतोग़, “बायि! नना नीक सव्रे कीकन इन्जि, निमा विस्वस कीताह्‌के बेस आतिन, गिर्दाते अन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","येसु इद्रम वेहनेकेन, यारोस पेदिरतोग़ मुक्याना लोताहि ओर्वोग़ मन्कल वासि, इद्रम ओन वेहतोग़, “नीवा मयाळ हाता रा! इंजेके गूरु लोन वासाय बाताल पाय्दा, ओग़ मल्स अनेग़!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","अस्के येसु इदिन केंजिसि, यारोसिन इतोग़, “निमा रेयमा! नावा पोग़ोन विस्वस तासा! अद पिसग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","पया येसु यारोसना लोन अतोग़, अन्जि पिला मतद अराता लोप्पा बोरिने ओळिय एवा, सिरप पत्रु, योहन, याकुब ओसो हाता पिलाता तलोग़-तपे, वेरिन पोसि लोप्पा ओळियतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","सबेटोर लोकुर अद पिलातेनाह्‌क अळसोर-केयसोर मतोर. अस्के येसु ओरिन “अळमाटु! पिला हायो, अद निद्रतेन मन्ह्‌ता!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","अस्के पोहता वाता मुलु, अद पिला हाता इनजोर पुन्ज मतोर. अदिनेनाह्‌क येसु इतद पोल्‍लोतेनाह्‌क ओर कवतोर. ");
INSERT INTO mrr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पया येसु अद पिलाता कयदुन पोसि, “अले पिला! तेदा!” इनजोर जोरते इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","इतस्के ताना जीवा मल्स वाता, अस्के अद चट्‌नेन तेदिस उदता. पया “तेन्क बातालाय तिनदलाह ईम्ह्‌ट,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","इदिन ऊळिसि, पिलाता तलोग़-तपे पका बामतोर. मति “इद पोल्‍लोतुन बोन्के वेहमाटु,” इनजोर येसु ओरिन उकुम इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","उंद दिया येसु तनाङ बारा बळयिरिन केयिसि, मन्कलोरग्डाहि सबे देयह्‌किन पेसिह कीयलाहि, ओसो रोगमतोरिन सव्रे कीयलाहि, ओरिह्‌क लावु ओसो अदिकर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","पया देवुळि मन्कलोरगा राजेम कीयनद पोल्‍लोतुन पोकुर कीयलाहि, ओसो रोगमतोरिन सव्रे कीयलाहि, ओरिन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","लोहतह्‌पा “मीट सेवाते दाकिर अस्के, मीवा कयदे डुडि, जोर्का, गाटो, कोताङ, जगाङ-गेंदेङ, इद्रम बाताङे ओयमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","बेद लोतगा मीट दाकिर, अदे लोतगा मन्ह्‌टु, अदे लोतग्डाह दुस्रा नाग़ अन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","बेद नाटेनोर लोकुर मीक रोमलाह एवोर, अग्डाहि पेसना वेलाते, ओर देवुळता सिक्सातुह्‌क ओजिह्‌तोर इनजोर तोहतलाहि, मीवाङ काल्कना दुरातुन अगाने दुल्पिसि पेसाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अद्रमलेह्‌काने पया, ओर अग़ पोस सेवाते दायह्‌पा, बेसता कबुरतुन पोकुर कीसोरे, ओसो रोगमतोरिन सव्रे कीसोरे, सबे नाह्‌किह्‌क अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","पया येसु कीतव ओसो वेहतव पोल्‍लोन, गालिल पटटा राजाल, एरोद अंतिपस केंजिसि, एक्बेक आतोग़. बाराह्‌क इतेके उय्तुर, “देवुळता कबुरतोग़ एलिया मुय्तोग़ ओसोवने वातोग़,” इंदुर. उय्तुर बार “आयो! वेल्‍लाय मुने बोर कबुरतोर मतोर, ओरग्डाहि जीवा अरतोग़ु, वेग़ ओर्वोग़ देवुळता कबुरतोग़ आंदोग़ बहे,” इंदुर. ओसो उय्तुर बार, “योहन डोलिस जीवा अरतोग़,” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","अस्के एरोद राजाल “योहनना तलातुन इतेके नना डाय वेहच मतन, मति इंजेके नना इद्रमताङ पोल्‍लोङ केंजलाह आतन, इतेके वेग़ बोग़ मनदनोग़?” इनजोर येसुन ऊळलाह विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","पया येसुनाङ बळयिर सेवाताहि मल्स वासि, तमा बाताल बाताल कीतोर, अव सबे कबस्किन येसुह्‌क वेहतोर. वेहतापया ओग़ ओरिन पोसि, बेत्‍सेदा नाटेनगा बोरिह्‌के एर्का आयवाह अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","मति इद पोल्‍लो लोकुरिह्‌क एर्का आतस्के, ओर वने ओरा पयाह अतोर. अस्के येसु मुडुन गूनमते केयिसि, देवुळि मन्कलोरगा राजेम कीयनद पोल्‍लोतुन ओरिह्‌क वेहतोग़. केंजवालोरग्डाहि बोर रोगमतोरिह्‌क सव्रेम आयना मता, ओरिन सव्रे कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","पया पोळ्‍द दायलाह आस मता, अस्के बारा बळयिर येसुनगा वासि, इद्रम इनदलाह आतोर, “गूरु, माट नाटेनग्डाह वेल्‍लाय जेक मह्‌नल, अदिह्‌क लोकुरिन इग्डाह लोहचीम, वेर सबेटोर एरे-गूरेताङ नाह्‌कनगा अन्जि, तम्क उंजलाह जागा ओसो तिनदलाह तिंडि पर्ह्‌किर.” ");
INSERT INTO mrr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","इतस्के येसु मर्ला ओरिने, “अले मीटे ओरिह्‌क तिंडटा बह कोट कीम्ह्‌टु रा!” इतोग़. इदिन केंजिस बळयिर “आं माटु! माट इचोन लोकुरिह्‌क गाटो असिस तच तीहनाह आतोमा? इंजेक मयगा इतेके सिरप एयुङ आरिङ, रेंड मीन्क, इवे मन्ह्‌ताङ, इविन विळ्सिसि इतेके बाताले इले,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","अगा (आस्किनु, पिलाङ-पेकोरिन विळ्सिसि,) कोय्तोरे जोक-जोक एयुङ अजर्क मतोर. (अच्वुर लोकुर मन्जाय मति,) “लोकुरिन पनास-पनासताङ गुमिङ कीसि, उदिह कीम्ह्‌टु,” इनजोर येसु ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ओग़ वेहतप लेह्‌का, बळयिर कतमतोरिन अद्रमे उदिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","पया येसु एयुङ आरिङ ओसो रेंड मीन्किन तेहतोग़, पया पोग़ोन ऊळिसि देवुळतुन जोहर कीतोग़. कीसि अविस्किन तुक्ळेङ कीतोग़, अह कीसि “लोकुरिह्‌क तूसिस ईम्ह्‌टु” इनजोर तनाङ कग़यवालोरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","तूसिस ईतस्के, कतमतोर लोकुर पोटामेंड तितोर. तितापया अव पिसतवु किळ्केङ, बारा डालाङ निंदतविन, ओर जमा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","पया अद्रम आनेके, येसु उंद मल्का तना वग़ोग़े देवुळता संगे पार्तना कीयह्‌पा, ओनाङ कग़यवालोर वने ओना संगे मतोर. ओरिन येसु इद्रम ताल्ह्‌कतोग़, “नना बोनन आंदन इनजोर, लोकुर नाक इन्ह्‌तोर?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","इतस्के “उय्तुर बार नीक एग़ मीहवाल योहन इन्ह्‌तोर, उय्तुर बार देवुळता कबुरतोग़ एलियाल आंदोग़, उय्तुर बार वेल्‍लाय मुनेटोर देवुळता कबुरतोरग्डाहि, ओर्वोग़ मन्कल जीवा अरतोग़ बहे, इन्ह्‌तोर,” इनजोर तनाङ कग़यवालोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","इतापया येसु ओरिन, “अले पया मीट वेहाट, नाक बोग़ इनजोर मीट इह्‌निर?” इनजोर ताल्ह्‌कतोग़. ताल्ह्‌कतस्के “सामि, निमा इतेके देवुळ लोहतोग़ पिसिह केवाल किर्स्तुनिन आंदिन,” इनजोर पत्रु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","पया पत्रुना पोल्‍लोतुन केंजिसि येसु, “नना किर्स्तुनन इनजोर, मीट बोने वेहमाट बहा,” इनजोर उकुम इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","पया तनाङ कग़यवालोरिन इद्रम काग़्हता बोटटोग़, “मान्वना नडुम पुटटोन्कु, इतेके नाकु, पका तिपल आयनद मन्ह्‌ता. यहुदिराङ पेदल्कु, पेर्मालोरु, सास्त्रमगूरुर नाक पास्कनुर, हव्कनुर, ताना पया मूंड दियाने नना तेग़्ककन, इव करल अद्रम आयनुङे!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ताना पया जमा आतोर सबेटोरिन इतोग़, “बोर नावाङ कग़यलाह वायना विचर कीस्तोर, ओरु दिनम तमा हव्कनागुटा कांजतप, नयेनाह्‌क वायनव तिपल्किन आपिर. ओसो तमाये गिर्दातुन पोहचि, नावा अग़दे ताकिर. ");
INSERT INTO mrr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","बोर इद बूमते तमा कुदता जीवातुन पिसिह कीयलाह ऊळिह्‌तोर, ओर आक्रिते बूळेम आयनुर. मति बोर बार नयेनाह्‌कु सबे पोहतह्‌तोर, ओरिह्‌क देवुळि पूना जीवा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","मन्कल इद दुनियाता सबे रीतिना सुकम दोर्किह कीसाय मति, तना कुदता जीवातुन अमेसातुह्‌क लेसिह कीतोग़ इतेके, ओन्क बाताल पाय्दा आयग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","बोग़ु नना येसुनाङ कग़यवानन इनदलाह पेग़्के-मुनेह आस्तोग़, ओनु नना मान्वना नडुम पुटटोनन वने जेक तासकन. ओसो बेद दिया नना नावा डीसाते, ओसो बाबाना डीसाते, ओसो नावा संगे मनदनव पवित्र देवतुल्कना डीसाते वायकन, अस्के अद्रमतोग़ मन्कन मावोग़ इनदलाहि पेग़्के-मुनेह आयकन. ");
INSERT INTO mrr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","इह केंजाट, सेतेमते नना वेहतह्‌नन, मियग्डाहि उय्तुर नावा संगे मनवालोरिर, हायनामुनेन देवुळि तना राजेम निल्पिह कीयनदिन मीट ऊळकिर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","इव पोल्‍लोङ वेहच आट दियाना पया, पत्रु, योहन, याकुब, वेरिन येसु तना संगे पोसि, पार्तना कीयलाहि, उंद मेटापोग़ोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","अगा ओग़ पार्तना कीयह्‌पा इद्रम आता इतेके, ओना मोकमता रूप मिळ्न्दता, ओनाङ गेंदेङ, कोंडाङ ऊळ पग़वाह तिर्मिळ्स्किंदुङ. ");
INSERT INTO mrr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","अस्के अगा बह आता इतेके, मोसा मुय्तोग़ ओसो एलिया मुय्तोग़, वेर इर्वुर मुनेतोर देवुळता कबुरतोरु, येसुनगा डीसाते वातोर. वासि, येरुसलेमतगा येसु बेद हायना हामुरता कबळतुन मारिह कीयना मता, अदिना लोप्पा ओना संगे वळ्ह्‌कलाह आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रु ओसो ओना संगतोर उंजिस मतोर. पया ओर तेदतोर अस्के येसुना डीसातुन ऊळतोर. ओसो ओना संगे ओर इर्वुर नितदिन ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","गळ्क मनेके मोसा मुय्तोग़ ओसो एलिया मुय्तोग़ येसुनग्डाह अनेके, पत्रु पया “सामि, माट इगा मह्‌नल इतेके बेस आता, माट इगा मूंड मंडाङ पंडकोम: उंदि नियेनाह्‌कु, उंदि मोसा मुय्तोनेनाह्‌कु, उंदि एलिया मुय्तोनेनाह्‌कु,” इतोग़. (इव पोल्‍लोङ पत्रु बाताल वळ्ह्‌किंदोग़, अद तना तन्के तेळियो.) ");
INSERT INTO mrr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ओग़ इव पोल्‍लोङ वळह्‌कनेके, ओरा पोग़ोन मोयुल वासि ओरिन मुचता, मुचतस्के वेर मुवुर कग़यवालोर पका रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ओरिन मुचतद मोयुलताहि उंद इद्रमता लेङ केंज वाता, “वेग़ नावा मग़ि आंदोग़, वेन नना आचतन, वेनाङे मीट केंजसोर मन्ह्‌टु,” इता. ");
INSERT INTO mrr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","अद लेङ केमेन आतापया, वेर मुवुरिह्‌क आसि, येसु वग़ोग़े अगा दिसतोग़. अदिह्‌क वेर केमेन आस मतोर, ओसो अगा ओर बाताल ऊळतोर, अदिन बोन्के बाताले बह वेहोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","इमा दिया बाताल आता इतेके, ओर मेटाताहि रेगतोर, अस्के लोकुरा बेरा गोह्‌डि, येसुन कलियलाह मेटाकचुल वातोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","अस्के लोकुरा नडुम ओर्वोग़ मन्कल पका जोरते केयिसि इतोग़, “गूरु! नना नीवाङ काल्क अरयह्‌नन, जीवा लोपिस नावा मग़नेके ऊळा, वेग़ नावा वग़ोग़े मग़ि आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","वेन तोप-तोप देयम अह्‌चिह्‌ता, अस्के वेग़ पका केयिह्‌तोग़. ओसो तोडटाहि बोमुल पेसनाह, वेन पका तेल्हतह्‌ता, अद वेन बेस्केन विळ्सो, तिपल कीसोरेन मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","इद देयमतुन पेहतलाह नना नीवाङ कग़यवालोरिन अर्जि कीतन, मति ओरा संगे आया पग़वो,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","अस्के येसु इतोग़, “ए विस्वसलेवोरिर, गलत विचर केवालोरिर, मीवा संगे बेचानाह नना मनदकन! मियेनाह्‌क नाक कयर वास्ता! अले नीवा मग़िन इगा तय,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","पया ओग़ पेकान येसुनगा तनेकेन, देयम ओन नेल अर्हचि पका तेल्हता. अस्के येसु अद देयमतुन दगा ईतोग़, ईतापया ओग़ पेकान सव्रे कीसि, ओना तपेनगा ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","अस्के इद देवुळता डीसातुन ऊळिसि, सबेटोर लोकुर बामतोर. येसु कीयनद कबळतुन लोकुर ऊळिसि बामिंदुर, अस्के येसु तनाङ कग़यवालोरिन इद्रम इतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“नना मीक बेव पोल्‍लोङ वेहतलाह आतन, अविस्किन बेस-नेह्‌ना केंजाटु. माने-मन्कना नडुम पुटटोनन, नाकु कोंटेतोरा कयदे पोस ईयना मन्ह्‌ता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","मति येसु वेहतद पोल्‍लो, ओरिह्‌क मुर्तिय तेळियो. अद पोल्‍लो ओरग्डाह मकिस मता. अदिह्‌क अदिन ओर पुनदा पग़वोर. ओसो अद पोल्‍लोतेनाह्‌क ओन ताल्ह्‌कलाह वने, ओर रेयिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","पया माट बारा मन्कलोरग्डाहि सबेटोरिह्‌क बेरोग़ बोग़ इनजोर, तमा बळयिरा नडुमिये कट्ला पुटटा. ");
INSERT INTO mrr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","अस्के ओरा विचर बाताल मन्ह्‌ता इनजोर येसु पुतोग़. पुन्जि ओर्वोग़ उड्लोग़ पेकान केयिसि, तनगा निल्पिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","कीसि “बोग़ु वेग़ उड्लोग़ पेकान नावा पेदिरते एरे कीस्तोग़, ओग़ नाक एरे कीतपे. ओसो बोग़ु नाक एरे कीस्तोग़, ओग़ नाक लोहतोन वने एरे कीस्तोग़. अदिनेनाह्‌क बोग़ मियग्डाह सबेटोरिह्‌क उड्लोग़ मन्ह्‌तोग़, ओग़े सबेटोरिह्‌क बेरोग़ आंदोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","इतस्के योहन इतोग़, “गूरु, नीवा पेदिरते ओर्वोग़ मन्कल, देयह्‌किन पेसिह कीतदिन, माटु ऊळतोम. ओग़ मावा तोळतोग़ आयवाह्‌कु, माट ओन रोमिह कीतोम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","इतस्के “बोग़ मीवा विरुदतोग़ आयोग़, ओग़ मीवोग़े आंदोग़, मीट ओन रोमिह केमाटु,” इनजोर येसु योहनिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","येसुह्‌क देवुळदीपतगा दायनद दिया एरे एवसोर मता. अदिनेनाह्‌क ओग़ येरुसलेम दायलाह अट कीस पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","येसु तना पेसनामुनेन, उय्तुरिन कबुर लोहचीतोग़. ओर ओन्क जागा तयर कीयलाह, सामरि जाततोर लोकुरा उंद नाग़ एवतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","मति येसु येरुसलेम दायलाह पेसतोग़ इन्जि, सामरि जाततोर लोकुर येसुन ओसो ओनाङ कग़यवालोरिन अगा रोमलाह एवोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ओरिन रोमलाह एवाह्‌कु, येसुनाङ कग़यवालोरु याकुब ओसो योहन, वेर इद्रम इतोर, “गूरु! इद नाटेनोरिन बूळे कीयलाह, पोग़ोटा बूमताहि किस अरयि इनजोर माट उकुम ईकोम, इद्रम नीवा विचर मन्ह्‌ताया?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","अस्के येसु ओरेके मिळ्न्दिस, ओरिन तेर्हतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","पया ओर अग्डाह दुस्रा नाग़ अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","पया अग़दे ताकसोर अनेके, बोग़ो ओर्वोग़ मन्कल येसुनगा वासि, “गूरु, निमा बेक अतेकाय, अकेन नना नीवा संगे वायकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","इतस्के, येसु ओन इतोग़, “कोय्लेस्किह्‌क मनदलाह बार गळ्‍दाङ, पिटेह्‌क मनदलाह बार गूडाङ मन्ह्‌ताङ. मति नना माने-मन्कना नडुम पुटिसाय मति, नाक तला रोयिह कीयलाह वने जागा इले. (निमा वने अद्रम मनदलाह तयर मह्‌निना?)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","पया येसु दुस्रोन ओर्विन “नावा पयाह पयाह वासि नावाङ कग़या,” इनजोर वेहतोग़. मति ओग़ मन्कल इतोग़, “गूरु, (नना नीवा संगे वायकन, निटमे. मति) मुने नाकु बाबाना लोन दायलाह ईमु. बाबाल हायनोग़ अस्के, नना ओन पोहचि नियके वायकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","इतस्के येसु इतोग़, “देवुळता जीवालेवोरु हातपे मन्ह्‌तोर, ओरे तमाङ हातोरिन पोहिर! निमा मात्रम देवुळता राजेमता कबुरतुन वेहा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ओसो ओर्वोग़ मन्कल येसुन इतोग़, “नना नीवा पयाह वासि कग़यकन गूरु! मति मुने नना लोन अन्जि, नावा लोतोरिन वेहच वाय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","इतस्के येसु इतोग़, “नांगिल पोसि पेग़्के ऊळसोर पूहवाल मन्कल, देवुळता राजेमता सेवातुह्‌क लायकतोग़ आयोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","पया येसुसामि मूंड वीसाङ बारा (72) तनाङ कग़यवालोरिन आचतोग़, आचिसि तन्क दायना मतव सबे नाह्‌कने, ओरिन इर्वुर-इर्वुरिन कीसि, मुनेह लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","लोहतह्‌पा इद्रम वेहतोग़, “वेर लोकुर पोलमते वेल्‍लाय पंडटद पंटालेह्‌का मन्ह्‌तोर, मति वेरिन देवुळतगा तवालोर बूतिनोर आलोर. अदिह्‌के पोलमता माल्काललेह्‌काडा देवुळि, लोकुरिन बेसता कबुर वेहचि तनगा तवालोर बूतिनोरिन लोहि इन्जि, मीटु तान अर्ज कीसोर मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","इह केंजाट! लोळ्ङानगा गोरेपिलान लोहतपु, नना मीक लोकुरगा लोहतह्‌नन, अन्ह्‌ट! ");
INSERT INTO mrr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","अनेके मीवा संगे जोर्का आयि, गेंदेङ आयि, एल्पुस्क आयि, बेदिने पोस ओयमाटु. ओसो अग़दे बोग़ाय कलियतेके, जोहर वने केमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","बेदाय लोतगा अतेके सबेट्क मुने, ‘इद लोतोरिह्‌क सुकम दोर्कि,’ इनजोर बर्कत ईम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अद लोते मीक जागा-पग़्सा कीयलाह गिर्दातोग़ मन्कल मतेके, मीट ईतद बर्कत ओन्क दोर्कग़ा. मति ओग़ गिर्दा आयोग़ इतेके, मीट ईतद बर्कत ओन्क दोर्को आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ओसो बेदाय नाग़ अतेक अचोन, लोह्‌क-लोह्‌क अनमाटु. बेदाय उंदिय लोतगा मन्जि, ओर बाताल ईस्तोर, आताल तिनजोर-उनजोर मन्ह्‌टु. मीट बोरगा देवुळता पोल्‍लो वेहतलाह दाय्ह्‌निर, ओर मीकु इव पूरा ईयनदे. ");
INSERT INTO mrr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","मीट बेदाय उंद नाग़ अतस्के, अद नाटेनोर मीक बेस-नेह्‌ना केयिसि उदिह कीतेक अचोन, ओर मीकु बाताल तिनदलाह ईस्तोर, अदिने तिन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","अद नाटेनाङ बेमरतोरिन सव्रे कीम्ह्‌टु, ओसो देवुळि मन्कलोरगा राजेम कीयनद कगो मियगा एवयलाह आता इनजोर वेहाटु. ");
INSERT INTO mrr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","मति बेदाय नाग़ अतस्के, अद नाटेनोर मीक बेस-नेह्‌ना ऊळवेके, अद नाटेनाङ बजर्क-बजर्क अन्जि, इद्रम वेहाट इतेके, ");
INSERT INTO mrr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘मावाङ काल्कनगा तुंडटद मियग्डा दुरातुन इगान दुल्पिह्‌नोम, (मीट देवुळता पोल्‍लोतुन केंजविर इनजोर, इद दुरा साक्सि मनदग़ा.) मति देवुळि इतेके मन्कलोरगा राजेम कीयनद कगो एवयलाह आता, इदिन सीतात तासाटु,’ इनजोर वेहाटु. ");
INSERT INTO mrr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ओसो नना मीक वेहतह्‌नन, सोदोम नाटेनोरिन देवुळि (ओराङ लाग्वाङ कबस्कनेनाह्‌क मुने सिक्सा ईसि) बूळे कीता. तान्काय वीळिसि नेयमता आक्रि दियाते, अद नाटेनोर सिक्सा आयनुर,” इनजोर येसु ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","पया ओसोवने वेहतोग़, “ए कोराजिन नाटेनोरिर! बेत्‍सेदा नाटेनोरिर! देवुळि मीक सिक्सा ईयग़ा. बाराह्‌क इतेके, मियगा बेव बामिह कीयनाङ कबस्क कीतन, अव सोर, सिदोन, इव लाग्वाङ नाह्‌कने कीस मतेके, अग्डोर अस्केन बेस्कोटे केंजिसि, पोता-गेंदेङ उहचि, तलातगा नेग़ वाटिस, तमा पापमताहि मिळ्न्दिस मनेर, (मति मीट मीवा पापमताहि मिळ्न्दविर.) ");
INSERT INTO mrr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","बाताले आयि, सोर, सिदोन, इव नाह्‌िकह्‌काय वीळिसि, नेयमता आक्रि दियाते देवुळि मीक सिक्सा ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ए कापेर्नाटेनोरिर! मीट देवुळदीपतगा पोग़ोन एवयकोम इह्‌निरा? आयो, देवुळि मीक इळ्ने हानादीपतगा पोहचीयग़ा! ");
INSERT INTO mrr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“मीट कग़यवालोराङ पोल्‍लोङ बोर केंजिह्‌तोर, ओर नावाङ पोल्‍लोङ केंजिह्‌तोर, ओसो बोर मीवाङ पोल्‍लोङ केंजोर, ओर नावाङ पोल्‍लोङ केंजोर. अद्रमे बोर नावाङ केंजोर, ओर नाक लोहवानाङ वने केंजोर,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","पया येसु लोहतोर मूंड वीसाङ बारा (72) मन्कलोर पका गिर्दाते मल्स वातोर. वासि येसुन इद्रम इतोर, “सामि, (माट नीवा पेदिरते देयह्‌किन वने पूंडटोम,) अव देयह्‌क मावा पोल्‍लोतुन केंजताङ वने,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","इतस्के येसु इतोग़, “देयह्‌कना मुक्याल आरेम आसि, किस-उळ्मलेह्‌का पोग़ोटाह इळ्न अरतदिन नना ऊळतन. ");
INSERT INTO mrr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","केंजाट! तरस्किन, मिचोन ओय्ह्‌कलाहि, ओसो देयह्‌कना पूरा लावतुन गेल्सलाहि, नना मीक अदिकर ईतन. मीकु बेदे बाताले नुस्कन केवोङ आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","मति देयह्‌क मीवा पोल्‍लोतुन केंजिह्‌ताङ इनजोर, इचोन गिर्दा आयमाटु! मति मीवाङ पेदिर्किन, देवुळ तना पिसमुळता पुस्तकते रासिस तासता, तानेनाह्‌के पका गिर्दा आम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","अचोटेने देवुळता पवित्र जीवाते येसु गिर्दा आतोग़. आसि इद्रम इतोग़, “ए बाबा! इळ्ता, पोग़ोटा बूमता सामिनिन! नना नीक जोहर कीय्ह्‌नन बाबा, बाराह्‌क इतेके निमा इव सेतेम पोल्‍लोन ‘बुदतोरोम, पका तेळियतोरोम’ इनवालोरिह्‌क तोहवालेवा, ‘उड्लोरोम, बुदलेवोरोम’ इनवालोरिह्‌क तोहतिन. निटमे बाबा, नीवा विचर इद्रमे कीयनद मता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ओसो “नावा बाबाल नाकु सबे पुनदलाह ईतोग़. नावा देवुळबाबान विळ्सिसि, देवुळता मग़ि बोग़ आंदोग़ इनजोर बोग़े बह पुनोग़. अहे देवुळता मग़िन विळ्सिसि, देवुळबाबाल बोग़ आंदोग़ इनजोर बोग़े पुनोग़. अद्रमे नना बाबान तोहतलाह बोन-बोन आचिह्‌नन, ओरु बाबान पुनदनुर.” ");
INSERT INTO mrr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ओसो कग़यवालोरिन अलग ओसि, ओरिन इतोग़, “नना कीयनाङ कबस्किन ऊळिह्‌निर इतेके, मीट बेचोन देय्वातोरिर! ");
INSERT INTO mrr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","बाराह्‌क इतेके नना मीक वेहतह्‌नन, नावा मुने मतोर वेल्‍लाटोर देवुळता कबुरतोरु ओसो राजालोरु, मीट ऊळनव कबस्किन ऊळकोम इंदुर, मति ऊळ पग़वोर. मीट केंजिह्‌निर अव पोल्‍लोन केंजकोम इंदुर, मति ओरिह्‌क केंजलाह दोर्को,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","अचोटेने ओर्वोग़ सास्त्रमगूरु वासि, येसुना पट ऊळलाहि ओन इद्रम ताल्ह्‌कतोग़, “गूरु! अमेसाता पिसमुळ दोर्किह कीयलाहि, नना बाताल कीकन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","इतस्के येसु इतोग़, “मोसानाङ अडोना सास्त्रमतगा बाताल रासतद मन्ह्‌ता? अगा निमा बाताल अर्विह्‌निन?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ताल्ह्‌कतस्के ओग़ इतोग़, “देवुळि नीवा सामि इनजोर तान नीवा पूरा बुदताहि, पूरा जीवाताहि, पूरा लावताहि, पूरा विचरताहि जीवा कीमु. ओसो निमा कुदतुन जीवा कीतपु, नीवा एरे-गूरेतोरिन वने जीवा कीमु.” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","इतस्के येसु इतोग़, “निमा बराबर वेहतिन! अद्रमे निमा वने कीमु, अस्के अमेसाता पिसमुळ नीक दोर्कग़ा.” ");
INSERT INTO mrr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","इद्रम इतस्के, ओग़ गूरु नना तपलेवोनन इनजोर तोहतलाहि, “नावा एरे-गूरेतोर इतेके बोर आंदुर गूरु?” इनजोर येसुन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ताल्ह्‌कतस्के येसु इतोग़, “केंजा! ओर्वोग़ यहुदि मन्कल येरुसलेम सहरताहि यरिग़ो नाग़ अनजोर मतोग़, अस्के नडुम अग़दे ओन कलेर पोयतोर. पोसि ओना सबे सामनतुन ऊंदिसि, ओनाङ आङिङ-गेंदेङ कुय्ह कीतोर, कीसि ओन कुस्क मेग़्यनाह पका नल्हचि, विळ्सिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“ताना पया गळ्क मनेके, अदे अग़दुह्‌क ओर्वोग़ बूमयाल अनजोर मतोग़. अनेके एरे एव्सि, ओग़ नेल अरतोग़ मन्कन ऊळिस एग़िस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","अद्रमे पया ओर्वोग़ देवुळवडे अदे अग़दुह्‌क वातोग़. वासि ओग़ वने ओन ऊळिसि एग़िस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ताना पया बाताल आता इतेके, अदे अग़दुह्‌क ओर्वोग़ सामरि जाततोग़ वानेके, नेल अर्स मतोग़ मन्कनगा एवतोग़. एवतस्के ओन ऊळिसि, वेन्क पका जीवा नोता. ");
INSERT INTO mrr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","पया ओग़ ओनगा एरे वासि, ओनाङ नोमुर्कनगा नेयु ओसो पूला अंगुर जोमा ओकिसि, पटि दोहचीतोग़. दोहचि तना गाळ्‍दता पोग़ोन ओन वाटिस, रोमनद गोटुदगा ओसि, ओना बेस सेवा कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","पया इमा दिया, गोटुदोग़ मन्कह्‌क रेंड वेंडटाङ कोताङ ईसि, इद्रम इतोग़, ‘वेन बेस-नेह्‌ना ऊळा, वेनेनाह्‌क निमा एक्‍वा कोताङ कर्सा कीतेक अचोन, नना मलतस्के अव कोताङ नीक ईकन’ इतोग़,” इनजोर येसु पीटो वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","वेहचि येसु ओन इतोग़, “अले! कलेर नल्हच मतोर, ओग़ मन्कन मुवुर मन्कलोर कलियतोर, वेरग्डाहि बोग़ ओना एरे-गूरेतोग़ आतोग़? अले! नीवा विचरते बोग़ आंदोग़?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","इतस्के, ओग़ इतोग़, “ओना पोग़ोन दया कीतोग़े.” इतस्के येसु इतोग़, “अन! ओग़ कीतप लेह्‌का, निमा वने कीम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","अद्रमे पया येसुना संगे ओनाङ कग़यवालोर येरुसलेम अनेके, उंद नाटेनगा एवतोर. अगा उंद मार्ता पेदिरता आंचाळ मता. अदु येसुन तना लोन केयिसि, बेस-नेह्‌ना उदिह कीता. ");
INSERT INTO mrr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","तान्क उंदि मरिया पेदिरता एलाळ मता. अद येसुनाङ काल्कना एरे नेल उदिसि, ओग़ वेहतनाङ पोल्‍लोन बेस-नेह्‌ना केंजसोर मता. ");
INSERT INTO mrr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","मति मार्ताह्‌क अलग-अलग रीतताङ वेल्‍लाङे गाटोङ-पुलाङ अटना विचर मताह्‌कु, अद पूरा मोता तानाय पोग़ोन अरतप आता. अदिनेनाह्‌क अद येसुनगा वासि, “ए गूरु, नावा एलाळि पूरा कबळतुन नावाय पोग़ोन दोबिस ईता, इदिन ऊळविना? तान नावा तोळ आयलाह वेहा,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","अस्के येसु तान इतोग़, “मार्ता, निमा वेल्‍लाङे पोल्‍लोना आल्सुळ कीसि, गाबर आय्ह्‌निन. ");
INSERT INTO mrr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","मति इद उंदिय पोल्‍लो गर्जता मन्ह्‌ता, इतेके मरियाल तनेनाह्‌क बेसता तूसतुन आचता. अदिनेनाह्‌क तानग्डाहि अद तूसतुन बोग़े ऊन्द पग़वोग़,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","उंद दिया येसु पार्तना कीसोर मतोग़, ओग़ पार्तना कीयनद मारतापया, ओनाङ कग़यवाल ओर्वोग़ इद्रम इतोग़, “गूरु! देवुळता पेदिरते एग़ मीहवाल योहन, तनाङ कग़यवालोरिन काग़्हतप लेह्‌का, माक वने पार्तना बेद्रम कीयना इनजोर काग़्हच ईम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","अस्के येसु ओरिन इतोग़, “मीट पार्तना कीयह्‌पा, इद्रम वळ्ह्‌काटु: ‘जोहर सामि, देवुळबाबानिन, सबेटोर नीवा पेदिरतुन मान ईयिर. इद बूमते नीवा राजेम निल्पिह कीमु. ");
INSERT INTO mrr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","मावा दिनमता तिंडि दिनम ईसोर मनु. ");
INSERT INTO mrr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ओसो बेद्रम माटु मावा अडम मतोर कसुरतोरिन मापि कीतोम, अद्रम मावाङ कसुर्किन वने मापि कीमु. ओसो माकु बेरा कंदाता वेलाते पापमते अरयलाह एमा.’ इद्रम पार्तना कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","“इंजेके मियग्डाहि ओर्वोग़ मन्कल, नग़्का तना तोळतोनगा अन्जि, ‘ए गोतया उंजतिरा? नावा ओर्वोग़ गोतयाल इंजेकेन वातोग़ रा, ओन्क अटिस ईयलाहि नयगा बाताले इले. नियगा रेंड आरिङ मतेक नाक ईकिन रा?’ इनजोर ताल्ह्‌केग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","मति ओग़ लोप्पाडाहि ‘अग़दुन केहच नना टेटेम अरतन रा, इंजेक नाक कयर केमा! नावा संगे नावाङ पेकोर वने उंजतोर. अदिनेनाह्‌क इंजेक तेदिस बाताले नीक ईया पग़वोन,’ इनजोर इनेग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“नना मीक वेहतह्‌नन, नावा गोततोग़ ताल्ह्‌किह्‌तोग़ इनजोर तेद वसवेकाय, ओग़ गोंडगोंड आस्तोग़ इनजोर, निटम तेदिस ओन्क ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अदिनेनाह्‌क नना वेहतह्‌नन, ताल्ह्‌कसोर मन्ह्‌टु, देवुळ मीक ईयग़ा. पर्ह्‌कसोर मन्ह्‌टु, दोर्कग़ा. कोह्‌कसोर मन्ह्‌टु, तेल्पतुन तेग़यग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","बाराह्‌क इतेके बोग़ ताल्ह्‌किह्‌तोग़, ओन्क ईयग़ा. बोग़ पर्ह्‌किह्‌तोग़, ओन्क दोर्कग़ा. बोग़ कोह्‌किह्‌तोग़, ओन्क तेग़यिस ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","तपेनु तना मग़ि आरि ताल्ह्‌कतेके, ओन्क बंडातुन ईयनोग़ा? मीन ताल्ह्‌कतेके, ओन्क तरसतुन ईयनोग़ा? इलवेक इसि मेन्ज ताल्ह्‌कतेके, ओन्क मिचोतुन एवाल, इद्रमतोग़ बोग़ाय तपे मियगा मन्ह्‌तोग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","मीट पापमतोरिर मन्ज तेला, मीवाङ पिलाङ-पेकोरिह्‌क बेसता मादुन ईयलाह पुह्‌निर इतेके, देवुळदीपतोग़ बाबाल तन्क ताल्ह्‌कवालोरिह्‌क, तना पवित्र जीवा बह एवोग़?” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","पया ओर्वोग़ मन्कन देयम पोस मता, अदिनेनाह्‌क ओग़ मन्कल वळ्ह्‌क पुनवा मूकाल आस मतोग़. पया येसु अद देयमतुन ओनग्डाहि पेसिह कीतोग़. अस्के ओग़ मूकाल वळ्ह्‌क बोटटोग़. इदिन ऊळिसि, अगा मता मुलु पका बामतोर. ");
INSERT INTO mrr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","मति ओरग्डाहि उय्तुर बारा, “वेग़ बेल्जेबुब इनदनद देयह्‌कना मुक्याना साय्तातेने, देयह्‌किन मन्कलोरग्डाहि पेसिह कीस्तोग़ रा!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ओसो उय्तुर बार, (येसु निटम देवुळतग्डाह वातोग़ुया बहु इनजोर) सेतेम ऊळलाह, ओन इतोर, “अले! माक देवुळता लावता बेदाय सीना तोहचीम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","मति येसु ओरा बुदतुन पुन्जि, इद्रम इतोग़, “बेदाय राजेमते तमाय नडुमि कोंटेङ पुटटेके, अद राजेम लेङिह्‌ता, अहे बेदाय लोतगा वने कोंटेङ पुटटेके अद लोन निलो. ");
INSERT INTO mrr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","नाक देयह्‌कना मुक्याना साय्ताते देयह्‌किन पेसिह कीस्तोग़ इनजोर इह्‌निर. देयह्‌कना मुक्याल तनाय तोळताङ देयह्‌किन बाराह्‌क पेसिह केवालि? अद्रम देयह्‌कना मुक्याल ओसो ताना तोळताङ देयह्‌क, तमा तमा विरुद आतेके, अविस्कना राजेम बेद्रम नितग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अले नना देयह्‌कना मुक्याना साय्ताते देयह्‌किन पेसिह कीतेके, मीवोर पया बेदिना साय्ताते देयह्‌किन पेसिह कीस्तोर? इद्रम मीवाङ विचर्क चुकताङ इन्जि, ओर तमाय तोहतनुर! ");
INSERT INTO mrr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","मति नना देवुळता जीवाता लावते देयह्‌किन पेसिह कीय्ह्‌नन इतेके, मियगा देवुळता राजेम वाता, इदिन पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“(इदिन पुन्पिह कीयलाह, नना मीक उंद पोल्‍लो वेहतह्‌नन:) ओर्वोग़ पळ्योग़ कसेह्‌क-मग़्स्क पोसि, तना लोतुन राका कीसोर मतेक अचोन, ओना मालसोम बेस मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","मति ओन्काय एक्‍वा लावतोग़ पळ्योग़ वासि, ओन उकिस आरे कीस्तोग़. कीसि लोतुन राका केवाल मन्कल बर्वस तासतव कसेह्‌क-मग़्स्किन ओनग्डाहि ऊंदिह्‌तोग़, ओसो तना लूटे कीतद मालसोमतुन वने, तना गोततोरा संगे तूसिह्‌तोग़.(अद्रमलेह्‌का देयह्‌कना मुक्यान आरे कीताह्‌के, नना देयह्‌किन पूंड पग़यह्‌नन.) ");
INSERT INTO mrr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“बोग़ नावा संगे गोतते मनोग़, ओग़ नावा विरुद मन्ह्‌तोग़, ओसो बोग़ नावा संगे लोकुरिन जमा कीयलाह तोळ आयोग़, ओग़ ओरिन बिरोबटो कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“उंद देयमि बोग़ाय मन्कनग्डाहि पेसिस अतस्के, अद तन्क मनदलाह, इके-अके मेटाङ-मेटाङ वेलियिस, जागाङ पर्ह्‌किस ऊळिह्‌ता, मति अद्रमता जागा बेगान दोर्को. अस्के अद आलिह कीस्ता, ‘नना पेसिस वातन, अद नावा पाळ्ना लोतगान मल्स दाकन,’ इद्रम इन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","पया अन्ज ऊळिह्‌ता अस्के, अद मुनेता लोनु रिकम आतदु, सिरसिर नेहतदु, ऊसतदु, इद्रम तान्कु बेस दिसिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","अस्के पया अद मल्स अन्जि, तन्काय लाग्वव एळुङ देयह्‌किन तना संगे गोत कीस ततह्‌ता. अस्के अवु ओग़ मन्कना लोप्पा नेङिस जागा आस्ताङ. पया ओना इंजेटा गोसा, मुनेतदिह्‌काय वेल्‍ला करबता आस्ता,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","येसु इव पोल्‍लोङ वेहतस्के, मुडग्डाहि उंद आंचाळ जोरते केयिस इद्रम इता इतेके, “नीक पुटिह कीसि, पाल ऊहतद आंचाळ बेरा देय्वाता आंदु,” इता. ");
INSERT INTO mrr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","इतस्के येसु इतोग़, “आयो, देवुळता पोल्‍लोतुन केंजिसि, अद्रम ताकवालोरे बेरा देय्वातोर आंदुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","पया मुडा मन्कलोर उचुन जमा आनेके, येसु इद्रम वेहता बोटटोग़: “इद पीळतोर लाग्वोर मन्कलोरु, नावा कयदे सीना ऊळकोम इन्ह्‌तोर. मति देवुळता कबुरतोग़ योनाल इनवाह्‌क बह बह आता, अदे सीनातुन ओरिह्‌क तोहतकन. तान विळ्सिसि बेदे सीना नना तोहवानन आयोन. ");
INSERT INTO mrr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","बेद्रम निनवे सहरतोर लोकुरिह्‌क योनाल सीना आतोग़, अद्रमे इद पीळतोरेनाह्‌क वने, माने-मन्कना नडुम पुटटोनन सीना आयकन. ");
INSERT INTO mrr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","साल्मोन राजाना बुदताङ पोल्‍लोङ केंजलाहि, सीबा देसेमता रानि वेल्‍ला जेकताहि वाता; मति इंजेके इगा साल्मोनिह्‌काय वीळिस बेरा पोल्‍लो मियगा एवता; (तेला मति मन्कलोर अद पोल्‍लोतुन नमोर.) अदिनेनाह्‌क आक्रि नेयमता दियाते, अद रानि निचि इद पीळतोरा पोग़ोन तप तासग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","अद्रमलेह्‌काने योनाना कबुरतुन निनवे सहरतोर केंजिसि, तमा पापमताहि मिळ्न्दतोर. इंजेके इगा योनाह्‌काय वीळिस बेरा पोल्‍लो मियगा एवता. (मति मीट इतेके मीवा पापमताहि मलविर.) अदिनेनाह्‌क आक्रि नेयमता दियाते, निनवे सहरतोर निचि, इद पीळतोरिन तप तासनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","येसु ओरिन ओसो इद्रम वेहतोग़, “बोग़े चिमलि नीर्विह कीसि, तान वेह्‌च एवा जागाते तासनोग़ा? इलवेके डूटलोप्पा मुचिस तासनोग़ा? आयो, लोप्पा ओळियवालोरिह्‌क वेह्‌च दिसि इनजोर, बोव्लापोग़ोन तासनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","नीवा कोंडा नीवा मेंदुदा चिमलिलेह्‌का आंदु. नीवाङ कोंडाङ बेस मतेक अचोन, नीवा लोप्पा पूरा वेह्‌च मतप आयग़ा. मति नीवाङ कोंडाङ करब मतेक अचोन, नीवा लोप्पा पूरा ईकळ आतप आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","अदिनेनाह्‌क उसरते मन्ह्‌टु, देवुळ मीक ईयनद वेह्‌चि पिवमाकि. ");
INSERT INTO mrr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","मीवा लोप्पा इचुन वने ईकळलेवा, पूरा वेह्‌च मता इतेके, चिमलि नीक वेह्‌च ईयना लेह्‌का, नियगा मनदनद वेह्‌च बेस दींचग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","येसु इद्रम वेहच मारिह कीतस्के, ओर्वोग़ परुसि मन्कल येसुन जावा उनडलाह, तना लोन केयतोग़. केयताह्‌कु येसु ओना लोन अतोग़. अन्जि लोप्पा ओळियिसि, ओना संगे जावा उनडलाह उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","अस्के परुसिरा अडो माळवा, येसु कय नोग़वाये जावा उनडलाह उदतोग़. तान ऊळिस ओग़ परुसि पका बामतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","अदिन पुन्जि येसुसामि ओन इद्रम इतोग़, “इके केंजा, मीट परुसिरिर गिनेङ-बट्किन सिरप पलतेनाह तोमिह्‌निर. मति मीवा लोप्पाडेके इतेके, उळ्बेते लोकुरिन जाळ्पनद निंदिस मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","बुदलेवोरिर! बह पलता मेंदुदुन पंडटद देवुळि, लोप्पाडा जीवातुन वने पंडोया? ");
INSERT INTO mrr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","अदिनेनाह्‌क मीट लेवोरिह्‌क जीवा कीसि, दर्मम ईम्ह्‌टु. अस्के मियेनाह्‌क सबे पोलनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ओ परुसिरिर, मीक पका गोसा आयग़ा! बाराह्‌क इतेके मीट पुलातगा वाटनव आकिना ओसो दुस्रा पंटाता, दहा तूस्कनग्डाहि उंद तूस देवुळतुह्‌क कोड ईय्ह्‌निर. (इचोन उड्लाङ पोल्‍लोन सीता कीय्ह्‌निर,) मति सेतेमते नेयम कीयना ओसो देवुळतुन जीवा कीयना, इद्रमताङ पोल्‍लोन सीता केविर. इविस्किन वने माळनाय मता, अविस्किन वने माळनाय मता. ");
INSERT INTO mrr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ओ परुसिरिर! मीक पका गोसा आयग़ा! बाराह्‌क इतेके पार्तनाताङ लोह्‌कनगा, बेरोर उदवालोराङ जागाङ पर्ह्‌किह्‌निर. ओसो बजरतगा लोकुर मीक जोहर कीयना, इद्रमताङ बेसु. ");
INSERT INTO mrr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","मीक पका सिक्सा आयग़ा, बाराह्‌क इतेके मीटु सेत्तातुन गुमया केवाय मिसतद जागाता लेह्‌का मह्‌निर. अगा गुमया दिसवाह्‌कु, अगाह्‌क अनवालोर पोग़ोट्क दास्तोर, मति इगा इळ्न सेत्ता मिसिस मन्ह्‌ता इनजोर पुनोर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","अस्के ओर्वोग़ सास्त्रमगूरु येसुन इद्रम इतोग़, “गूरु, निमा इद्रमताङ पोल्‍लोङ वळ्ह्‌किस, माक वने लजा अरनाह कीय्ह्‌निन गोतो!” ");
INSERT INTO mrr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","इनजोर इतस्के येसु ओन इतोग़, “ओ सास्त्रमगूरुरिर! मीक पका गोसा आयग़ा! बाराह्‌क इतेके मीवाङ तेहता पुनवप मनदनाङ अडोङ-उतुर्कना मोतातुन, मीटु लोकुरा पोग़ोन वाटिह्‌निर, मति मीट इतेके अद मोतातुन कय तेला बोयिस ऊळविर. ");
INSERT INTO mrr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","मीक पका सिक्सा आयग़ा, बाराह्‌क इतेके मीवाङ तादोर-बाबोर मुनेतोर देवुळता कबुरतोरिन हव्कतोर. इंजेक इसि, मीट ओर कबुरतोराङ पेदिर्कने बंडाङ ओग़्सिह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","अह कीसि मीट वने मीवाङ तादोर-बाबोराङ कबस्किह्‌क तोळ आतिर. बाराह्‌क इतेके ओर बार कबुरतोरिन हव्कतोर, मीट बार ओराङ बंडाङ ओग़्सिह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“अदिनेनाह्‌क देवुळि तना बुदते इद्रम इता, ‘नना कबुरतोरिनु, ओसो बळयिरिन वने ओरगा लोहतकन. अस्के उय्तुरिन बार हव्कनुर, ओसो उय्तुरिन बार पका तिपल कीयनुर,’ इता. ");
INSERT INTO mrr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","अदिह्‌क बूम पुटटग्डाहि देवुळता कबुरतोरिन बेच्वुरिन हव्कतोर! ताना इसब इद पीळतोरिह्‌क ईया पोयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","मुने हाबेलिन हव्कतग्डाह इतेके, वेल्‍लाय पेग़्के मंदिरता पवित्र गूडि ओसो गर्या, इव रेंडिस्कना नडुम जकरिया बूमयान हव्कतोर. अगा एवनाह बेच्वुरिन हव्कतोर, ओर सबेटोरा इसब इद पीळतोरिह्‌क ईया पोयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","सास्त्रमगूरुरिर, देवुळि मीक पका सिक्सा ईयग़ा. बाराह्‌क इतेके बुदता अग़दुन केहचीतिर; मीट वने ओळियविर, ओसो ओळियवालोरिन वने ओळियलाह एविर. (इद्रम मीट मन्कलोरिन सेतेम पोल्‍लोतुन पुनदलाह एविर,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","पया येसु अग्डाहि अतस्के, परुसिर ओसो सास्त्रमगूरुर ओना पोग़ोन पका ओङ आतोर. आसि बेदाय पोल्‍लोते येसुन एग़्किह कीयना इनजोर विचर कीसि, ओन वेल्‍लाङे पोल्‍लोङ ताल्ह्‌क बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","अस्के अगा अजर्कनाङ अजर्क लोकुर जमा आतोर. वेल्‍ला गर्दितेनाह्‌क, तमतमाय ओर्विह्‌क-ओर्वोग़ दोबेङ-नूकेङ कीसोर, इके-अके दोबलाह आंदुर. ओरिन ऊळिसि, सबेट्क मुने येसु तनाङ कग़यवालोरिन इतोग़: “परुसिर इतेके ओय्‍पिह कीतद पिंडलेह्‌काडोरु, अदिनेनाह्‌क ओरा सोङतग्डाह उसरते मन्ह्‌टु, (ओरा सोङता बुदि सबेटोरिह्‌क दिसो). ");
INSERT INTO mrr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","सबे मकिह कीतव पोल्‍लोङ पङ्ने आयनुङ, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","अदिनेनाह्‌क मीट ईकळते वळ्ह्‌कतेक तेला, अद पोल्‍लो वेह्‌चते केंजमुळ आयग़ा. ओसो बेदे तेला पोल्‍लो कुस्क्ने बोना केवदे वेहतेके, अदिन लोता पोग़ोन निचि, लोकुरा नडुम पोकुर केमुळ आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“नावा गोततोरिर, नना मीक वेहतलाह आतन, बोर मेंदुदुन हव्क पग़यह्‌तोर मति जीवातुन इट पग़वोर, ओर लोकुरिह्‌क रेयमाटु. ओर तान विळ्सिसि, तान्क अबर बातय कीया पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मति नना मीक वेहतह्‌नन, जीवा ओसो मेंदुलि, इव रेंडिन आसि पिववद किसबटटा सिक्सातगा वाटिसि, बूळे कीयनद अदिकर मनदनद देवुळतुने रेयाटु. ");
INSERT INTO mrr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ऊळाटु, कोळ्का पिटेना बिसद मन्ह्‌ताया? इले, अव इतेके रेंड कोताह्‌क एयुङ पिटेङ वने दोर्क पग़यह्‌ताङ. तेला मति अविस्कनग्डाहि उंदतुन वने देवुळि माग़्ङो. ");
INSERT INTO mrr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","मीट इतेके अव कोळ्का पिटेह्‌काय वीळिसि, एक्‍वा मोलातोरिर आंदिर. अदिह्‌क मीक बाताल आयग़ा इन्जि रेयमाटु. मीवा तलातगा बेचोक केल्क मन्ह्‌ताङ, इदिन वने मीवा देवुळदीपतोग़ बाबाल पुन्ह्‌तोग़, (अचोन ओग़ मीवा सीता कीस्तोग़!) ");
INSERT INTO mrr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ओसो नना मीक वेहतह्‌नन, बोग़ु लोकुरा मुनेह, नना येसुनाङ कग़यवानन इन्जि कबुल आस्तोग़, ओन नना माने-मन्कना नडुम पुटटोनन, आक्रि नेयमता वेलाते, नावा देवुळता मुनेह ओसो देवतुल्कना मुनेह वेग़ मावोग़े इनदकन. ");
INSERT INTO mrr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","मति बोग़ु, लोकुरा मुनेह येसुन पुनोन इनदनोग़, ओन नना वने देवुळता मुनेह, ओसो देवतुल्कना मुनेह, वेग़ मावोग़ आयोग़ इनदकन. ");
INSERT INTO mrr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ओसो बोग़ाय माने-मन्कना नडुम पुटटोना विरुद वळ्ह्‌कतेके, ओना कसुरता मापि आयग़ा. मति देवुळता पवित्र जीवातुन पास्कतेक मात्रम, ओना कसुरता मापि दोर्को. ");
INSERT INTO mrr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ओसो बेस्के मीकु पार्तना कीयनाङ लोह्‌कनगाय, साय्बालोरगाय, मुक्यालोरगाय मीवा नेयम कीयलाह पोस ओयनुर, अस्के माट बाताल वळ्ह्‌ककोम इनजोर आलिह केमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","मति अगा बाताल मीक वळ्ह्‌कना मन्ह्‌ता, देवुळता पवित्र जीवा अदे गट्काते मीक वेहतग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","इतस्के मुडाहि ओर्वोग़ मन्कल येसुनगा वासि, “नावा बाबाना मालसोमतग्डाह उचुन नाक तूसिसीयलाह, नावा दादान निमा वेहचीम गूरु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","इतस्के येसु ओन इतोग़, “ए तमो! मीवा नेयम कीसीयलाहि, ओसो मालसोमतुन तूसिसीयलाहि, बोग़ नाक आचतोग़?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ओसो येसु ओरिन इतोग़, “इद उंद पोल्‍लो मीट बेस केंजाटु, सबे रीतिना लालुसतग्डाह मीटु जेक मन्ह्‌टु, बाराह्‌क इतेके बोनगाय वेल्‍ला मालसोम मतेकेन, ओग़ बेस पिसिह्‌तोग़ इन्जि इनमाटु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","इद पोल्‍लो वेहचि, येसु ओरिह्‌क उंद पीटो वेहतोग़, “ओर्वोग़ मता मन्कल मतोग़. ओन्क तना पोलमतगा पका पंटा वाता. ");
INSERT INTO mrr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","अदिनेनाह्‌क ‘नना इंजेके बह कीकन? अनम तासलाह नयगा इतेक जागा इले, लोन इंका पोयो’ इनजोर ओग़ तनतनाय इद्रम विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","कीसि तनतनाय इतोग़, ‘अले! नना इद्रम कीकन, इद डोमे बडटुन लेहचि, तेन्काय बेरा लोन पंडकन. ");
INSERT INTO mrr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अगा पया नावा सबे अनमतुन ओसो मालसोमतुन तासिसि, नावा जीवातुन इनदकन, “अले जीवातिन, इंजेक नीवासाटि वेल्‍लाङे वर्साङ एवनाह तिनदलाह मालसोम, अनम-दनम मन्ह्‌ता. निमा पका तिनु, उनु, बेस गिर्दा-वेळ्काते मनु,” इनदकन’ इन्जि, ओग़ विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","इद्रम विचर कीनेके, देवुळि ओनु, ‘ए! बुदलेवोनिन! नेंडे नग़्का नीवा जीवातुन नना ओतेके, निमा इचोन जमा कीस तासतद, सबे मालसोम बोन्क आयग़ा?’ इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","इद्रमलेह्‌काने बोग़ाय मन्कल, देवुळतुन पेग़्के कीसि, तनेनाह्‌क मालसोम जमा कीस्तोग़, ओन्क अद्रमलेह्‌काने आयग़ा,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","पया येसु तनाङ कग़यवालोरिन इद्रम इतोग़: “नना मीक वेहतलाह आतन, मीट मीवा जीवाता सीता केमाटु. बाताङ तिनदकोम, बाताङ उहतकोम इनजोर, मेंदुस्कनाङ इव पोल्‍लोनेनाह्‌क मीट आल्समाटु. ");
INSERT INTO mrr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","बाराह्‌क इतेके मीवा जीवा सिरप तिनदलाहे, ओसो मेंदुल सिरप गेंदेङ केग़यलाहे मन्ह्‌ताया? ");
INSERT INTO mrr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","काकास्किन ऊळाट अले! अव वीतोङ, कोयोङ, अहे डोमेने जमा वने केवोङ. तेला मति देवुळि अविस्किह्‌क तिंडि ईस्ता. देवुळता मुनेह अविस्किह्‌काय वीळिसि, मीट एक्‍वा मोलातोरिर आंदिर इतेके, (निटमे देवुळि मीवा पिसवग़तुन सीता कीयग़ाये). ");
INSERT INTO mrr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","तिनदना-उनडना, इविना लोप्पा आलिह कीस, मीवा पिसना-पिसवग़ता उंद पूटा वने, मीट वीळिह कीया पग़विर! पग़यकिरा? ");
INSERT INTO mrr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","इद्रमलेह्‌का मीट इचुटा कबळतुन कीया पग़विर, इतेके पया बाराह्‌क वेल्‍लाङे पोल्‍लोना लोप्पा आल्सिह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","इव सोबाताङ गेळापुंगेह्‌किन ऊळाट अले, इव बह वलियिह्‌ताङ! नना मीक वेहतह्‌नन, इव कह्‌टेम केवोङ, नूदे गेंदेङ अर्होङ. तेला मति साल्मोन राजाल पका सोबाता राजजगा मलियतस्के वने, इव पुंगेह्‌कना सोबाता बराबर बेस्केन एव्वोग़! ");
INSERT INTO mrr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","इंजेके गेळापुंगेह्‌क नेंड मन्ह्‌ताङ, नाळ बूळेम आस्ताङ. एय विस्वस इलवोरिर, इद्रमता रोंडातुन देवुळि इचोटा बेसताङ केग़यनाङ उहपिह कीसीस्ता, इतेके मीक अदु बेचोन कासा कीसि, गेंदे केग़्‍पिह कीसीयग़ा! ईयग़ाया, एवोया? ");
INSERT INTO mrr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अदिह्‌के ‘बाताङ तिनदकोम, उनडकोम, केग़यकोम?’ इविना लोप्पा मीट आलिह कीसोर मनमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","देवुळतुन पुनवोर इसि, इव कतमे दोर्किह कीयलाह वितापूंडा आस्तोर. मति इव सबेटव मीक गावले मन्ह्‌ताङ, तेन मीवा देवुळदीपतोग़ बाबाल पुन्जिये मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","देवुळि मीवा नडुमि राजेम कीयनदिन पर्ह्‌काटु. अह पर्ह्‌कतिर इतेके, मीक बाताङ गावले मन्ह्‌ताङ, अव कतमे देवुळि मीक ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“माट उड्ला गोह्‌डटाङ (गोरेना लेह्‌का कमजोर मह्‌नोम इन्जि) मीट रेयमाटु! बाराह्‌क इतेके देवुळदीपता राजेम मीवा कयदे ईयलाह, मीवा देवुळबाबाल तयरे मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","मीवा पूरा मालसोमतुन वमिसि, लेवोरिह्‌क ईसीम्ह्‌टु. ओसो बेस्केन पाळ्ना आयवद बट्वातुन दोर्किह कीम्ह्‌टु. अह कीतेके, बेस्केन मारवद मालसोम, देवुळदीपतगा जमा कीकिर. अगा कलेर एवया पग़वोर, ओसो एल्म वने बूळे कीया पग़वो. ");
INSERT INTO mrr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","बाराह्‌क इतेके बेगा मीवा मालसोम मनदग़ा, (देवुळदीपते मनि, इद बूमते मनि), अगा मीवा सीता वने मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“मीट अमेसा तयर मन्ह्‌टु. ओसो मीवा जीवातग्डा वेह्‌च वने अमेसा पोतसोर मनि. ");
INSERT INTO mrr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","मर्मिह्‌क अतोग़ माल्काल लोन मल्स वासि, आळो कीस तेल्पतुन कोह्‌कनेके, तोप्नेन तेग़यलाहि ओनाङ ओर्युलतोर अग़ ऊळसोर मन्ह्‌तोर. अद्रमलेह्‌का मीट वने अग़ ऊळसोर मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","केंजाट, नना मीकु सेतेम वेहतह्‌नन, अद्रम माल्काल मल्स वातस्के, ओर्युलतोर उंजवालेवा तयर मतोर इतेके, माल्काल कुदि दुपट नंडटुह्‌क दोहतनोग़. दोहचि मीट बेसतोरिर इनजोर ओरिन उदिह कीसि, तना कयदेन गाटो तीहतनोग़. ओसो ओरा एरे वासि, ओरा सेवा कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","नडुमनग़्का पका निद्रता वेलाते आयि, इलवेके वियतना वेलाते आयि, माल्काल मल्स वातस्के, ओर्युलतोरु उंजवालेवा केपसोरे मतोर इतेक, ओर पका देय्वातोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","मति मीट उंद पोल्‍लोता सीता कीम्ह्‌टु: कले नग़्का बेचोह्‌पा लोतगा कललाह वायनोग़ इनजोर, लोतोग़ माल्काह्‌क एर्का मन्ज मतेके, माल्काल नग़्का केपिस मनेग़; ओसो कलेन लोता लोप्पा ओळियलाह वने, एवोग़ आवेग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","अदिनेनाह्‌क मीट वने तयर मन्ह्‌टु, बाराह्‌क इतेके मीट नावा अग़ ऊळवद वेलाते, नना माने-मन्कना नडुम पुटटोनन वायकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","अस्के पत्रु ताल्ह्‌कतोग़, “सामि, निमा इद पीटोतुन माके वेहतलाह आतिना? बार इगा जमा आतोर सबेटोरिन वेहतलाह आतिन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","इतस्के येसुसामि इतोग़, “बेसता बुदतोग़ सेतेमते कबळ केवाल, इद्रम बोग़ मेटि मन्ह्‌तोग़, ओन लोता माल्काल ओर्युलतोरिह्‌क कगोत्क-कगो अडिया ईयलाहि आचिह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","पया माल्काल वानेके, इद्रम बेस कबळ कीसोर मनवाल मेटि, पका देय्वातोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","केंजाट, नना मीकु सेतेम वेहतह्‌नन, ओग़ माल्काल तना अनमतुन, बूमतुन ओसो पूरा मालसोमतुन ओग़े मेटिना कयदे विळ्सिसीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","मति ‘नावा माल्काल इंजेक बेद वेलाते वायनोग़ो, ओग़ वायलाह वेल्‍लाय तीरम कीस्तोग़,’ इद्रम विचर कीसि, तना पका तिनदना-उनडना, रिमाते ओचिस मनदना, ओसो अद लोतगा मनवालोर दुस्रोर ओर्युलतोरिन पका बह इतेके अहे, नल्हतना-कोह्‌कना केवेग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","इद्रम वेग़ मेटि कीतेके, वेग़ ओना अग़ ऊळवद वेलाते, तना माल्काल वायनोग़, वासि विस्वस केवोरिन कीयना लेह्‌का, वेन वने दूनेङ-दूनेङ कीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“अदिनेनाह्‌क बोग़ मेटिह्‌क तना माल्काल वेहतद कबळ पूरा एर्का मन्जि तेला, ओग़ मुर्तिय तयरते मनोग़, ओसो तना माल्काना विचरता लेह्‌का, ओग़ कबळ वने केवोग़ इतेक, ओग़ मन्कह्‌कु पका देबाङ अरयनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","मति बोग़ु पुनवालेवा, तना माल्काह्‌क विचर वावाङ कबस्क कीस मनदनोग़ इतेके, ओन्क कमि देबाङ अरयनुङ. अदिनेनाह्‌क बोन्क एक्‍वा ईतद मन्ह्‌ता, ओना जबब्दर एक्‍वा आयग़ा. ओसो बोनगा एक्‍वा तासतव मन्ह्‌ताङ, ओनग्डाह एक्‍वा इसब ताल्ह्‌कमुळ आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“केंजाट, नना इद बूमतगा किस ओग़िसीयलाह वातन. इद किसु इंजेक एवनाह पोतिस मन्ज मतेके, बेस आस मनालि. ");
INSERT INTO mrr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मति अद आयनामुने, नाक तिपल आस डोलना मन्ह्‌ता. अद कबळतुन मारिह केवालेवा, नावा जीवा चुहेम आयो. ");
INSERT INTO mrr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","नना वाताह्‌कु, इद बूमतोर सबेटोर गूनमते मनदनुर इनजोर मीवा विचर मन्ह्‌ताया? मति अद्रम आयो, लोकुरिन एग़्‍पिह कीयलाह नना वातन. ");
INSERT INTO mrr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","इंजेटाहि उंद लोतगा एयवुर मन्कलोर मतेके, ओरा नडुम कोंटे पुटग़ा. मुवुर इर्विरा संगे, ओसो इर्वुर मुविरा संगे, विरुद आस जग्ळम पुटग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","इतेके नयेनाह्‌के तपेना संगे पेकाल, तलिना संगे मयाळि, अहे तमातोना संगे कोयाळि, इद्रम वेर कोंटेङ आयनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","जमा आता मुडुन ओसो उंद पोल्‍लो येसु इतोग़, “पोळ्‍द अरयना बाजेतेनाह मोयुल तग़्ङनदिन ऊळिसि, इंजेक पेग़ वायग़ा इनजोर, मीट चट्पिटे पुह्‌निर. अद अद्रम आस्ता वने. ");
INSERT INTO mrr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","दक्सिन बाजेताहि वळ्य वायनदिन ऊळिसि, इंजेक एद वायग़ा इनजोर मीट इह्‌निर, अस्के अद अद्रम आस्ताये. ");
INSERT INTO mrr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","सोङ केवालोरिर! बूमतगा ओसो मोयुलतगा दिसनविन ऊळिसि, इद्रम इद्रम आस्ता इनजोर पुह्‌निर. इंजेके देवुळि इद तूकने बाताल कीयलाह आता, इदिना लोप्पा बह पुनदा पग़विर? ");
INSERT INTO mrr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“बेसतल बुदता अग़ बेदु, तान मीटे बह आच पग़विर? ");
INSERT INTO mrr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","मीकु मीवा विरुदतोर कोरोटटे बेरोग़ साय्बानगा ओनेके, नडुम अग़देन ओरिन गूनम कीम्ह्‌टु. अह केवेके, ओर कोरोटटा बेरा साय्बानगा मीक ओयनुर, कोरोटटा साय्बाल पया पोलिसिरा कयदे ईसि, मीक जेलते वाटिसीयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","अदिनेनाह्‌क मीक वेहतह्‌नन, बेचानाह मीटु दांडटाङ पूरा कोताङ चुका-चुका निहविर, अचानाह अग्डाहि मुर्तिय पेस पग़विर आयकिर,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","पया उय्तुर मन्कलोर येसुनगा वासि, इद्रम वेहतोर इतेके, “गालिल पटटोर उय्तुर मन्कलोर मंदिरतगा तमाङ मोकिङ ईसोर मतोर. (अस्के पिलातिइनवाल गुमसितनाङ सीपय्किन लोहचि, ओरिन हव्कनाह कीतोग़.) इद्रम पिलाति ओरा नेतुरतुनु, मोक ईतविना नेतुरता संगे काल्ह्‌पतोग़,” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","वेहतस्के येसु ओरिन इतोग़, “गालिल पटटा दुस्रोर लोकुरिह्‌काय, ओर डोलतोर वेल्‍ला पापिर मतोर, अदिह्‌क ओरिन हव्कतोर इनजोर, मीवा विचर मन्ह्‌ताया? ");
INSERT INTO mrr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","अद्रम आयो! नना मीक वेहतह्‌नन, मीट वने पापमता अग़दाहि मलवेक अचोन, बेद्रम ओर डोलतोर, अद्रमे डोलकिर. ");
INSERT INTO mrr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अद्रमे सीलो इनदनद वेच्‍चातगा बेरा मिदे मुटटस्के, अट्रा मन्कलोर डोलतोर. बह येरुसलेम सहरतगा मतोर दुस्रोर लोकुरिह्‌काय, वेर डोलतोरु वेल्‍ला कसुरतोर मतोर इनजोर, विचर कीय्ह्‌निरा? ");
INSERT INTO mrr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","अद्रम आयो! नना मीकु वेहतह्‌नन, मीट सबेटोरिर वने पापमता अग़दाहि मलवेके, अद्रमे डोलकिर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ओसो ओरिन तेळियिह कीयलाहि, उंद पुन्पिह कीयनद पीटो इद्रम वेहतोग़ इतेके, “ओर्वोग़ मन्कल तना अंगुर वाळुमतगा, उंद अंजिर मरा ओग़्सिस मतोग़. अद मरा आदताया, आदोया इनजोर ऊळलाह वातोग़, मति अद मरा आदो. ");
INSERT INTO mrr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","आदवाह्‌कु माल्काल वाळुमतुन ऊळेवाळे केवान इतोग़, ‘इद मरा आदग़ा बहे इनजोर, नना मूंड वर्सानाहि ऊळलाह आतन, मति आदतद उंद काया वने नाक दोर्को. इद उगसिय जागातुन आपिस तासता, तेन नळ्किस पोहचीम,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","अस्के ऊळेवाळे केवाल इतोग़, ‘माल्का! ओसो उंद वर्सामेंड केपिस ऊळा. नना मराता सर्ने बोंदा काचि, कतुम वाटिस ऊळकन. ");
INSERT INTO mrr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","पया पेग़ेन्‍ड आदता इतेक बेसे, आदो इतेक बार, तेन नळ्किस पोहचीकिन’ इतोग़,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","पया उंद पोल्वादियातेपार्तनाता लोतगा, येसु मुडुन काग़्हचोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","अस्के अगा उंद आंचाळ मता, तान अट्रा वर्सानाहि देयम पोस मता. अदिनेनाह्‌क ताना मोळ्कोटुह्‌क गूनि पेसिस मता, अद मुर्तिय दिग्ने निता पग़वो आंदु. ");
INSERT INTO mrr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","येसु तान ऊळिसि, तनगा एरे केयतोग़. केयिसि “बायि, नीवा दुकताहि निमा सव्रेम आतिन” इद्रम इनजोरे, ");
INSERT INTO mrr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ताना पोग़ोन तना कय तासतोग़. तासतस्के चट्‌नेन अद दिग निता, निचि देवुळतुन जोहर कीया बोटटा. ");
INSERT INTO mrr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","मति येसु पोल्वादियाते तान सव्रे कीतोग़ इनजोर, यहुदिरा पार्तनाता लोता मुक्याल ओङ आसि, अग्डा मुडुन इतोग़, “कबळ कीयलाहि इतेक, वारमतुह्‌क आरुङ दियाङ मन्ह्‌ताङ, नेटा दिया आयो. अदिनेनाह्‌क दुकताहि सव्रेम आयलाह, बेदाय दुस्रा दियाते वायना इतेक वाटु. मति पोल्वादियाते मात्रम, सव्रेम आयलाह वामाटु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","अस्के येसुसामि इतोग़, “एय सोङ केवालोरिर! पोल्वादियाते मीवा कोंदातुन, आयवेक गाळ्‍दतुन कोळ्काताहि विळ्सिसि, एग़ ऊहतलाह ओयविरा? ");
INSERT INTO mrr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","इद आंचाळ अब्रहमना कूळता आंदु, तेन अट्रा वर्सानाह देयह्‌कना मुक्याल दोहच तासिस मता. बह पोल्वादियाते तेन दुकताहि सव्रे कीयनद आयोया?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","येसु इद्रम इतस्के, ओना विरुद केवालोर लजा आतोर. मति दुस्रोर मन्कलोर “येसु पका बेसता कबळ कीस्तोग़,” इनजोर पका गिर्दा आंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","पया येसु पुन्पिह कीयनद उंद पीटो वेहतोग़, “देवुळता राजेमता पोल्‍लो बेद्रम बेर्सग़ा? अद पोल्‍लो बेदिना लेह्‌काडा इनजोर तेळियिह कीकन? अद इद्रमता इतेके: ");
INSERT INTO mrr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","बोग़ो ओर्वोग़ मन्कल तना लकातगा, पुलुळ पेनेम वीततोग़. अद इचुटा पेनेम मोन्ह्‌टिस, उंद बेरा मरा आता. अस्के पिटेङ तानाङ पंगानगा वासि, गूडाङ पंडटाङ,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","येसु ओसो उंद पीटो वेहतोग़, “देवुळता राजेमता पोल्‍लो इद्रमलेह्‌का मन्ह्‌ता इतेके, ");
INSERT INTO mrr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","बेदो उंद आंचाळि उचुन ओयता जावा पिंडटुन, मूंड तवाङ पिंडटगा काल्ह्‌पता. पया अद पूरा पिंडि ओयिसि बोल्गता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","अद्रमे पया येसु येरुसलेमतेके अनेके, वेल्‍लाङे नाह्‌कनोरिह्‌क देवुळता पोल्‍लोतुन वेहचोर अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","अस्के ओर्वोग़ मन्कल ओन इद्रम ताल्ह्‌कतोग़, “गूरु! उय्तुरे मन्कलोरिन देवुळि पिसिह कीयग़ाया बहु?” इतोग़. अस्के येसु ओन इतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“नना मीक वेहतह्‌नन, वेल्‍ला पसलेवदु उड्ला अग़दुह्‌कु, देवुळता राजेमतगा नेङलाह ऊळाटु. बाराह्‌क इतेके वेल्‍लाटोर लोप्पा नेङलाह ऊळनुर, मति नेङ पग़वोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","पया लोता माल्कानन नना तेदिस अग़दुन केहतकन, अस्के मीट दारावंडटगा निचि ‘सामि! मयेनाह्‌क तेल्प तेग़या!’ इनजोर तेल्पतुन कोह्‌कसोर केयकिर. मति नना मीकु, ‘मीट बेग्डाह वातिरो, नना मीक पुनोन!’ इनदकन. ");
INSERT INTO mrr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","अस्के ‘मति माट ऐंगेन तितल, उटल, निमा मावाङ अग़िनगा माक देवुळता पोल्‍लोतुन वेहतिन,’ इनजोर मीट इनदकिर. ");
INSERT INTO mrr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","मति नना, ‘एय देवुळता पोल्‍लोतुन केंजवोरिर! नना मीक मुर्तिय पुनोन, नयग्डाह विताट!’ इनदकन. ");
INSERT INTO mrr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“मीटु देवुळ राजेम कीयनगा अब्रहम, इसक, याकुब ओसो सबेटोर देवुळता कबुरतोरिन ऊळकिर. मति मीक इतेके, अग्डाहि पलते सिरप अळयना, पल्क कोग़्कना, इद्रमता जागाते दोबिस ईयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","अस्के ईनाह-आनाह, पूरा बूममेटोर लोकुर देवुळता राजेमतगा वासि, कुळ्प तिनदना बतते उदनुर. ");
INSERT INTO mrr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","इद्रमलेह्‌का इद बूमते बोरिन-बोरिन उड्लोर इह्‌निर, अस्के ओर बेरोर आयनुर. ओसो बोरिन-बोरिन बेरोर इह्‌निर, ओर अस्के उड्लोर आयनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","अचोटेन उय्तुर परुसिर ओनगा वासि इतोर, “एरोद अंतिपस राजाल नीक हव्कलाह ऊळिह्‌तोग़. निमा इग्डाह बेगातेल दुस्रा जागाते अनु.” ");
INSERT INTO mrr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","इनजोर इतस्के येसु ओरिन इतोग़, “अले, अन्जि ओग़ कोय्लेलेह्‌काडोग़ एरोद अंतिपसिन वेहाट, ‘नेंडु नाळि नना मन्कलोरग्डाहि देयह्‌किन पेसिह कीकन, ओसो दुकतोरिन सव्रे कीकन. पया मने नावा कबळतुन मारिह कीकन. ");
INSERT INTO mrr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","मतिंगा देवुळता कबुरतोन्क येरुसलेम सहरता पलते डोलनद बेस आयो. अदिनेनाह्‌क नेंडु, नाळि, मने नना येरुसलेमतके अनजोर मनदना गावले,’ इनजोर वेहचीम्ह्‌ट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ओसो (येरुसलेमतोर मन्कलोरिन सीता कीस) इद्रम इतोग़: “ए येरुसलेमतोरिर, ए येरुसलेमतोरिर, देवुळता कबुरतोरिन हव्कवालोरिर, देवुळि मियगा लोहतोरिन बंडाङ उकवालोरिर! बेद्रम तलोग़ कोग़ु तनाङ पीसेन काग़ोलिह्‌ता, अद्रमलेह्‌काने मीकु नयगा गुम कीयना इन्जि, बेचोको मल्काङ नावा विचर आंदु! मति मीट नाकु अह कीयलाह एविर. ");
INSERT INTO mrr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","केंजाट, मीवा मंदिर इम्ने आनाह, देवुळि मीक विळ्सिस दायग़ा. नना मीक वेहतह्‌नन, नना मल्स वायह्‌पा ‘देवुळबाबाना अदिकर पोस वावाह्‌कु, देवुळता देय्वा दोर्कि!’ इनजोर मीट इनदकिर, अचानाह नना मीवाङ कोंडाह्‌क मुर्तिय दिसोन आयकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","परुसिरा तुंगातग्डाहि ओर्वोग़ मुक्याना लोतगा, जावा उनडलाहि केयताह्‌कु, येसु अद लोतगा अतोग़. अद दिया वारमता पोल्वादिया मता. अस्के अग्डोर लोकुर (ओन बेदाय पोल्‍लोते एग़्किह कीयलाह,) ऊळा-वेचाते मंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","अगा येसुना मुनेह ओर्वोग़ कय्क-काल्क तोयनद बेमरतोग़ मन्कल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","अगा मतोर सास्त्रमगूरुरिन ओसो परुसिरिन, येसु इद्रम ताल्ह्‌कतोग़, “मावाङ अडोना लेकाते, पोल्वादियाते रोगमतोरिन बेस कीयनद पोलिह्‌ताया? पोलोया?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","मति ओर बाताले वळ्ह्‌कवा केमेन मतोर. अस्के येसु, ओग़ तोयले मन्कन बोयिसि बेस कीतोग़. बेस आतापया, ओन लोहचीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ओग़ अतस्के, अगा उदतोरिन येसु इद्रम ताल्ह्‌कतोग़: “मियग्डाहि बोनाय गाळ्‍द तेला, इलवेके कोंदा तेला, चुवातगा अरतेके, तान पोल्वादियाते तेंडविर आयकिर रा?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ओना ताल्ह्‌कमुळता लोप्पा, वेर बाताले ओन पोल्‍लो मल्हता पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","अगा गाटो तिनदलाह वातोरु, बेरोर मन्कलोर उदनव जागानगा, उदलाहि जागाङ ऊळिंदुर. अस्के ओरिन ऊळिसि, येसु उंद पोल्‍लो वेहतोग़: ");
INSERT INTO mrr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“बेस्के बोग़ाय मीकु बेद मर्मतगा गाटो तिनदलाह केयनोग़, अस्के बेरोर मन्कलोर उदनद जागातगा अन्जि, मीट उदमाट बहा, बाराह्‌क इतेके लोतोग़ माल्काल, मीकाय एक्‍वा कदरतोग़ मन्कन केयिस मनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अस्के ओग़ वातापया, मीक इर्वुरिन आस केयतोग़ु, मियगा वासि, ‘नियद जागा वेन्क ईम रा’ इन्जि मीक उदता जागाताह तेहतनोग़. अस्के मीट लजा आसि, कतमतोरा मुनेह नेल अन्जि उदकिर. ");
INSERT INTO mrr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“अदिनेनाह्‌क बेस्के मीक गाटो तिनदलाह केयनोग़, अस्के मीट नेल अन्जि उदाट. मीक केयतोग़ु बेस्के मियगा वासि, ‘वय रा दादा! इगा मुनेह वास उदा’ इनजोर इनदनोग़, अस्के मीवा संगे गाटो तिनवालोर सबेटोरा मुनेह मीक कदर दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","बोग़े मनेग़, तना कुद नना बेरोनन इनदनोग़, ओन देवुळ उड्लोग़ कीयग़ा. मति तना कुद नना उड्लोनन इनदनोग़, ओन मात्रम देवुळ बेरोग़ कीयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","पया बोग़ येसुन लोन केयिस मतोग़, ओन वने येसु उंद पोल्‍लो इतोग़, “निमा पियल आयि, नग़्का आयि, गाटो तिनदलाह केयतेके, नीवा गोततोरिन, दादालोरिन, जीवा-तलातोरिन, ओसो नीवा एरे-गूरेतोर साव्कर्किन बह केयमा. बाराह्‌क इतेके ओर ओसो तमा लोन नीक केयनुर, इद्रम कीसि निमा केयतदिना बद्ला, नीकु ओर वने केयिसि देहचीयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","मति निमा बेस्के गाटो तिनदलाह लोकुरिन केयकिन, अस्के लेवोरिन, कय्क-काल्क वावोरिन, ताक पग़वोरिन, तोववोरिन केया. ");
INSERT INTO mrr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","अह कीतेके देवुळता देय्वा नीक दोर्कग़ा. इद्रमतोरिह्‌क ईतेके, ओर नीक मल्हच ईया पग़वोर. मति देवुळता मुनेह सेतेमते मन्जि डोलतोरु, बेस्के ओसोवन जीवा अरयनुर, अस्के नीवा बूति नीक दोर्कग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","इद पोल्‍लो केंजिसि, गाटो तिनदा वातोग़ ओर्वोग़ मन्कल येसुनु, “बोर देवुळता राजेमते गाटो तिन्ह्‌तोर, ओर देय्वातोर आंदुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","इतस्के येसु उंद पीटोते पोल्‍लो मल्हतोग़. “ओर्वोग़ मन्कल बेरा कुळ्प तयर कीतोग़, कीसि वेल्‍लाटोर लोकुरिन कबुर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","कुळ्प गाटो तयर आतस्के ‘अले इंजेके कुळ्प गाटो तयर मन्ह्‌ता, कबुर वेहच मतोरिन केयलाह अन्ह्‌ट’ इन्जि माल्काल तनाङ ओर्युलतोरिन ओसोवने केयलाह लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","मति सबेटोर नाळेह कीया बोटटोर. ओर्वोग़ इतोग़, ‘नना पूना पोलम तेंडटन, अदिह्‌क तान ऊळलाह दाय्ह्‌नन, मति माल्काल ओङ बह आयमाकेग़ गोतो, नना मापि ताल्ह्‌किह्‌नन,’ इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ओर्वोग़ बार इतोग़, ‘नना एयुङ जोळिङ कोंदाङ असतन. अव बेद्रम मन्ह्‌ताङ, अविस्किन ऊळ दाय्ह्‌नन. मति माल्काल ओङ बह आयमाकेग़ गोतो, नना मापि ताल्ह्‌किह्‌नन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ओसो ओर्वोग़ बह इतोग़ इतेके, ‘नावाङ मर्मिङ आताङ, अदिनेनाह्‌क नना वाया पग़वोन’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ओग़ ओर्युलतोग़ मल्स वातोग़. वासि, तना माल्कानगा लोकुर बह इतोर, अव सबे पोल्‍लोङ वेहतोग़. अस्के अद पोल्‍लोतुन केंजिसि, लोता माल्काल पका ओङ आतोग़. ओङ आसि तना ओर्युलतोन इतोग़, ‘निमा नाटेनाङ अग़िनगा अन्जि, गतलेवोरिन, कय्क-काल्क वावोरिन, तोववोरिन, कूटालोरिन केयिस तय,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","इतस्के ओर्युलतोग़ अतोग़, अन्जि अद्रमे कीतोग़. पया मल्स वासि तना माल्कान वेहतोग़, ‘साय्ब! निमा बह उकुम ईतिन, अद्रमे ओरिन केयिस ततन. मति ओसोवने जागा पिसताये,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","इतस्के ओना माल्काल इतोग़, ‘निमा ओसोवन अन, अन्जि नाह्‌कनाङ अग़िना कचुल, ओसो पोलह्‌कने अन्जि, ओर लोकुरिन अर्जि कीसि, ओरिन पोस वायु. नावा लोन पूरा निंदिस मनि. ");
INSERT INTO mrr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","नना मीक निटम वेहतह्‌नन, बोर लोकुरिन मुने गाटो तिनदलाह केयिस मतन, ओर लोकुरग्डाहि ओर्वोग़ वने नावा गाटोतुन तिनोग़ आयनोग़,’ इतोग़.” इद्रम वेहचि येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","पया लोकुर गोह्‌डमेंड येसुना पयाह पयाह अनजोर मतोर. अस्के येसु ओरेके मिळ्न्दिस, ओरिन इतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“बोग़ाय येसुनाङ कग़यकन इनवाल, ओग़ तना तलोग़-तपेनु, तना मुतेनु, पिलाङ-पेकोरिनु, तना तमोग़-दादानु, एलाळ-अकानु, इचोने आयो मति तना जीवातुन वने, नाकाय वीळिस जीवा कीतोग़ इतेके, ओग़ नावाङ कग़यवाल आया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ओसो बोग़ तना हव्कनागुटा कांजतप नावा पयाह वाताह्‌कु, तन्क वायनव तिपल्किन आपलाह तयर आयोग़ इतेके, ओग़ मन्कल वने नावाङ कग़यवाल आया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“इंजेके मियग्डाह बोग़ाय उंद बेरा लोन पंडना विचर कीतेके, ओग़ मन्कल, ‘नना कोनि इचोन बेरा लोन पंडना विचर कीय्ह्‌नन, मति इद लोतुन मारिह कीयलाह नयगा इचोवेल्‍लाङ कोताङ मन्ह्‌ताङा, इलेङा?’ इन्जि, बह तेना लोप्पा ओग़ इचुनाय गंता कीस ऊळोग़ आवेग़? ");
INSERT INTO mrr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","ओग़ पाय्वाङ वाटिस, तान बार मारिह केवोग़ इतेके, पाय्वाङ वाटिह्‌पा ओन बोर बोर ऊळिस मतोर, ओर मन्कलोर मात्रम ‘वेन ऊळाटे! वेग़ मन्कल पाय्वाङ वाटलाह वाटटोग़, मति तान मारिह कीया पग़वोग़’ इनजोर वेन ऊळिसि पास्कनुर, कवयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“आयवेके इद्रमतोग़ बोग़ राजाल मन्ह्‌तोग़ा? दुस्रा देसेमता संगे लळय कीयलाह दायनामुने, बह उचुनाय विचर केवोग़ आवेग़? ‘नना सिरप दहा अजर्क सीपय्कना संगे, ओर वीसा अजर्क सीपय्किन गेल्स पग़यकना? पग़वोना?’ ");
INSERT INTO mrr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","वेग़ तना लळेम आया पग़वेके, विरुदतोर लळय कीयलाह एवयनामुनेने, तनाङ सीपय्कना संगे कबुर लोहचि, गूनम आयलाह विचर केवेग़. ");
INSERT INTO mrr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“अद्रमलेह्‌काने मियग्डाह वने बोरे मनिर, आपुना सबे मालसोम, अनम-दनम, ओसो मियगा मनदनव सबेटविन विळ्स पग़विर इतेके, नावाङ कग़यवालोरिर आया पग़विर. ");
INSERT INTO mrr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ओवुरि बेसतले, मति ताना मिटस बार अता इतेके, अद मिटस बेद्रम मल्स वायग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","अद पया पोलमते वाटलाह, बेद तोळ्योतगा काल्ह्‌पलाह वने अरवो, बेद कतुमतगा काल्ह्‌पलाह वने अरवो. तान आक्रिते पोहचीयनुर. अदिनेनाह्‌क मियग्डाहि बोरिह्‌क पुनदलाह गिर्दा मन्ह्‌ता, ओर नावा पोल्‍लोतुन बेस केंजिर!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","उंद दिया सिद्‌वा एनवालोर ओसो यहुदिराङ अडोन नोमवोर पापिर, येसुनाङ पोल्‍लोङ केंजलाहि, ओनगा जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","इदिन ऊळिस परुसिर ओसो सास्त्रमगूरुर येसुन मुयोग़ आसोरे, “वेग़ मन्कल पापिरिन बेस-नेह्‌ना तनगा केयिस उदिह कीस्तोग़. ओसो ओरा संगे तिनदना-उनडना कीस्तोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ओर इनदनदिन केंजिसि, येसु ओरिन उंद पुन्पिह कीयनद पीटो वेहतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ओर्वोग़ मन्कनगा नूर गोरेङ मताङ, अविस्किन मेहनेक-मेहनेके, अग्डाहि उंद गोरे लेसता. पया अव पिसतवु उंद कमि नूर (99) गोरेनु, बटटगा मंदा कीसि, अद उंद लेसतद गोरेतुन दोर्कनाह्‌जोम, पर्ह्‌कलाहि ओग़ दास्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","पया अद गोरे दोर्कतस्के, तान गिर्दाते तना अटाते कांजिस पोस वास्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","पया लोन वासि, तना गोततोरिनु ओसो एरे-गूरेतोरिन केयिसि, ‘नावा लेसिस मतद गोरे नाक दोर्कता. नावा संगे गिर्दा कीम्ह्‌टु,’ इनजोर इन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","नना मीक वेहतह्‌नन, अद्रमे देवुळतुन माळवालोर उंद कमि नूर (99) मन्कलोरु ‘माकु पापमता अग़दाहि मलयलाह गर्ज इले’ इनदनुर. मति ओरिह्‌काय, ओर्वोग़ पापि मन्कल तना पापमता अग़दाहि मलतेक अचोन, ओनेनाह्‌के देवुळदीपतगा पका गिर्दा आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ओसो उंद पीटो वेहतह्‌नन, केंजाट. उंद आंचानगा वेंडटाङ दहा कोताङ मताङ. अग्डाहि उंद कोता लोने बेगायो अर्स मायता. अस्के अद आंचाळ चिमलि पोतिह कीसि, दोर्कनाह्‌जोम बेस-नेह्‌ना वियेग़ नेहचि पर्ह्‌किह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","पया कोतातुन दोर्किह कीसि, तना गोतताङ आस्किनु, एरे-गूरेताङ आस्किनु केयिसि, ‘नावा पोव्स मतद वेंडटा कोता दोर्कता रि, नावा संगे गिर्दा कीम्ह्‌टु!’ इनजोर इन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","नना मीक वेहतह्‌नन, अद्रमे पापमता अग़दाहि मलवाल ओर्वोग़ पापि मन्कनेनाह्‌कु, देवुळदीपतगा देवुळि, तनाङ देवतुल्कना संगे गिर्दा कीयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","पया येसु ओसो उंद पुन्पिह कीयनद पीटो वेहतोग़, “ओर्वोग़ मन्कल मतोग़, ओन्क इर्वुर मग़्क मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उंद दिया उड्लोग़ मग़ि तना तपेनगा वासि, ‘बाबा! मालसोमतग्डाहि बेचोन नावा तूस मन्ह्‌ता, अद नाक तूसिस ईम,’ इतोग़. इतस्के तपे तना मालसोमतुन, इर्वुर मग़्किरिह्‌क तूसिस ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","पया वेल्‍ला दिया आयवाय मता, ओग़ उड्लोग़ मग़ि तना मालसोमतुन पूरा ओप्पे कीसि, लोतोरग्डाह एग़िस वेल्‍ला जेकता देसेमते अतोग़. अन्जि अगा तना मालसोमतुन बेदे कबळतुह्‌क अरवाहु, लाग्वाङ कबस्कने इके-अके उगसिन पोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","इद्रम ओग़ पूरा मालसोम मारिह कीतोग़. पया अद देसेमतगा बेरा दुकळ अरता. अस्के ओनगा बाताले इले आस मता. ");
INSERT INTO mrr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","अदिनेनाह्‌क पया ओग़ अद देसेमतोग़ ओर्वोग़ मन्कनगा, कबळ कीयलाह अतोग़. अतस्के ओग़ मन्कल ओन तना पोलमते पदिङ मेहतलाह लोहचीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","पया अगा ओग़ पेकाल, अव पदिङ तिनदनद कोग़्मतुनाय तिन्ज, पोटा निहेनन इनजोर विचर कींदोग़. मति अद कोग़्मि वने, ओन्क बोग़े एवोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“अद्रम आनेके पया, ओग़ पेकाल सीता अरतोग़. अस्के तनतनाय इद्रम विचर कीतोग़: ‘नावा बाबानगा इतेके, बेच्वुरो ओर्युलतोर मन्ह्‌तोर, ओरिह्‌क तितेक वने मारो. मति नना इसि इगा कग़्विह्‌क हासोर मह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","आयो, नना इंजेके इग्डाह बाबानगा अन्जि इनदकन, “बाबा नना देवुळता अडम ओसो नीवा अडम पापम कीतन. ");
INSERT INTO mrr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","इंजेके नीवा मग़ि इनदलाह वने ओप्पोन. मति नाक ओर्वोग़ नीवा ओर्युलतोना लेह्‌का, नियगा तासा,” इनदकन,’ इनजोर विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","कीसि ओग़ पेकाल अग्डाहि तपेनके दायलाह पेसतोग़. पया लोता एरे एवनेके, तपे ओन ऊळतोग़. ओन ऊळिसि, तपेह्‌क पका मान वसता. पया तपे वितिस, ओन गळ्म ओग़्ङिस लोंडटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","अस्के ओग़ पेकाल, ‘बाबा! नना देवुळता अडम ओसो नीवा अडम पापम कीतन. इंजेके नीवा मग़ि इनदलाह ओप्पोन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“मति तपे ओन लोन तचि, तनाङ ओर्युलतोरिन ‘अलेट रा! पका बेसता जगा तचि, वेन्क केग़्‍पिह कीम्ह्‌टु. वेळ्न्जतगा उंद मुदा केग़्‍पिह कीम्ह्‌टु, ओसो एल्पुस्क केग़्‍पिह कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ओसो बेस मेंदुल आतद कुरा पियो हव्काट! अदिन तिन्जि माट गिर्दा कीकल. ");
INSERT INTO mrr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","वेग़ नावा मग़ि डोलिस मतोग़, इंजेक जीवा अरतोग़. लेसिस मतोग़, मति वेग़ दोर्कतोग़,’ इनजोर वेहतोग़. इद्रमलेह्‌का ओर गिर्दा कीयलाह बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“पया बह आता इतेके, गळ्क मनेके माळा मग़ि पोलमतेनाह लोन वातस्के, पाटाङ ओयनदु, एंदनदु आल्का ओग़ केंजतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","केंजतस्के ओर्वोग़ तमा ओर्युलतोन केयिसि, ‘लोन बाताल आयलाह आता रा?’ इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","अस्के ओग़ु, ‘नीवा तमोग़ सुकमते बेस-नेह्‌ना लोन मल्स वातोग़. अदिनेनाह्‌क मिय्माल पका बेस मेंदुल आतद पियोतुन अस्कलाह वेहतोग़!’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“इदिन केंजिस, बेरोग़ मग़ि पका ओङ आतोग़. लोनलोप्पा ओळियोग़. अस्के तपे पलते वासि, ओन गूनम कीयलाह ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","मति मग़ि तपेन इद्रम इतोग़, ‘इचोक वर्साङ ओर्युलतोना लेह्‌का मन्जि, नना नीवा सेवा-साकुर कीयलाह आतन. ओसो नीवाङ सबे पोल्‍लोन केंजिस ताकतन. मतिंगा नावा गोततोरा संगे कलियिस गिर्दा कीयलाह, बेस्के उड्ला बोक्ळा पियो वने एविन. ");
INSERT INTO mrr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","मति वेग़ नीवा मग़ि, पूरा मालसोमतुन साट्याल कबळते बूळे कीतोग़. ओनेनाह्‌क कोनि बेस पका मेंदुल आतद कुरा पियोतुन अस्कलाह वेहतिन अय!’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","इतस्के तपे ओन इतोग़, ‘बाबा! निमा इतेके अमेसा नावा संगे मह्‌निन, नयगा बाताल बाताल मन्ह्‌ता, अद सबे नीवाय आंदु. ");
INSERT INTO mrr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","मति वेग़ नीवा तमोग़ डोलिस मतोग़, इंजेक जीवा अरतोग़. लेसिस मतोग़, ओसोवने दोर्कतोग़. अदिनेनाह्‌क माट गिर्दा आयना गावले’ इतोग़,” इनजोर येसु इद्रम पीटो वेहच मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","पया येसु कग़यवालोरिन ओसो इतोग़, “बोग़ो ओर्वोग़ साव्कर मन्कल मतोग़. ओनगा ओर्वोग़ मेटि मतोग़. वेग़ मेटि ‘नीवाङ कोतान बेदे कबळतुह्‌क अरवाह, मारिह कीयलाह आतोग़’ इनजोर, बोरो साव्करिन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","अस्के साव्कर मेटिन केयिस, इद्रम इतोग़, ‘नीवा लोप्पा नना बाताल केंजलाह आतन रा? इंजेक नीक इद कबळते, नना तास पग़वोन आयकन. निमा नयेनाह्‌क कीसोर मतिन, अद कबळता पूरा लेका कीस, नाक ईम!’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","इतस्के पया, ओग़ मेटि तनतनाय आल्स बोटटोग़, ‘नना इंजेके बाताल कीकन? माल्काल इतेके नाक कबळताह पेहचीयनोग़. नाक इतेक इंजेक, पोलमते कबळ कीयलाह कयदेन आयो. ओसो बेगा ताल्ह्‌किस तिनदलाह वने लजा वास्ता,’ इनजोर आलिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","आलिह कीस पया, ‘नना इंजेक बह कीकन, अद नाक सबे तेळियता. इद कबळतग्डाह नाक पेहतापया, दुस्रोर लोकुर नाक तमा लोन केयना गावले.’ ");
INSERT INTO mrr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","इन्जि तना माल्कानग्डाहि बोर करा इनजोर सामन तेंडिस मतोर, ओरग्डाह ओर्विन-ओर्विन केयिस ताल्ह्‌कतोग़, ‘निमा साव्करिह्‌क बेचोन करा मल्हच ईयनद मन्ह्‌ता रा?’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","इतस्के ओर्वोग़ इतोग़, ‘नालुङ अजर्क लिटर्क जय्तुन पंडिना नेयु’ इतस्के, मेटि ओनु ‘इद ऊळा, नीवा पेदिरता कागिद मन्ह्‌ता, तेनगा रेंड अजर्क लिटर्क इनजोर चट्पिट रासा,’ इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","पया ओसो दुस्रोन ताल्ह्‌कतोग़, ‘निमा साव्करिह्‌क बेचोन करा मल्हच ईयनद मन्ह्‌ता रा?’ इनजोर ताल्ह्‌कतस्के, ‘नूर कंडिङ गोह्‌क मल्हचीयनद मन्ह्‌ता’ इतोग़. इतस्के ओन वने ‘इद नीवा पेदिरता कागिद मन्ह्‌ता, तेनगा नालुङ वीसाङ कंडिङ इनजोर रासा,’ इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“पया ओग़ मुळ्हे मेटि, पका सत्रलते कबळ कीतदिन माल्काल ऊळिसि, ओन ‘पका उसर मह्‌निन रा!’ इन्जि इतोग़. इद्रमलेह्‌का देवुळतुन पुतोर लोकुरिह्‌काय एक्‍वा, देवुळतुन पुनवोर लोकुर, ओर्विह्‌क-ओर्वोग़ ईयना-एतनदिना लोप्पा, पका सत्रल मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","नना मीकु वेहतलाह आतन, इद दुनियाता मालसोमते, आपुह्‌क गोततोर दोर्किह कीम्ह्‌टु. बाराह्‌क इतेके अद मालसोम बेस्के मायग़ा, अस्के बेस्केन मायवव लोह्‌कने मीक जागा दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“बोग़ उडीला पोल्‍लोते सेतेम मन्ह्‌तोग़, ओग़ बेरा पोल्‍लोते वने सेतेमे मन्ह्‌तोग़. मति बोग़ उडीला पोल्‍लोते सेतेम इलेग़, ओग़ बेरा पोल्‍लोतगा वने सेतेम इलेग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","अदिनेनाह्‌क इद बूमतग्डा मालसोमतेने मीट सेतेमते इलवेके, देवुळि तना राजेमता मालसोमतुन मीवा कयदे बेद्रम ईयग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","दुस्रोना मालसोमतुन मीट सेतेमते काळ्ङविर इतेके, देवुळ ईयनद तूस मीक बेद्रम दोर्कग़ा? ");
INSERT INTO mrr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“अदिनेनाह्‌क ओर्वोग़े ओर्युलतोग़ु, इर्वुर माल्कालोरा सेवा-साकुर कीया पग़वोग़. बाराह्‌क इतेके ओग़ ओर्विन बार कोटुल कीयनोग़, ओसो ओर्विन बार जीवा कीयनोग़. इलवेके ओर्विना पोल्‍लो केंजनोग़, ओर्विना पोल्‍लो बार केंजोग़ आयनोग़. अद्रमे मीट वने मालसोमु ओसो देवुळि, इव रेंडिना सेवा मुर्तिय कीया पग़विर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","येसु इव पोल्‍लोङ वेहनेके, अगा उय्तुर परुसिर मतोर. ओरु कोताना पोग़ोन पका जीवा कींदुर. अदिह्‌क येसु इतव पोल्‍लोन केंजिसि, ओन पास्किंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","पया येसु ओरिन इतोग़, “मीटु लोकुरा मुनेह माट सेतेमतोरोम इह्‌निर, मति मीवा पोटातगा बाताल मन्ह्‌ता, तान देवुळ पुन्ह्‌ता. बेव-बेव पोल्‍लोङ मन्कना विचरते पाय्दाताङ मन्ह्‌ताङ, अव देवुळतुह्‌क एग़्ङ वास्ताङ. ");
INSERT INTO mrr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“एग़ मीहवाल योहन वानाह्‌जोम, मोसानाङ अडोङ ओसो देवुळता कबुरतोरा सास्त्रम, इव लोकुरिन ताकिह कीसोर मंदुङ, ताना पया देवुळता राजेमता बेसता कबुर पोकुर आयलाह आता. ओसो सबेटोरिन ताना राजेमतगा ओळ्हतलाहि, पोकुर केवालोर गोंडगोंड आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ओकावेला पोग़ोटा बूमि ओसो इळ्ता बूमि बूळेम आयनुङ, मति देवुळताङ अडोना सास्त्रमतग्डा उंद गीता वन मायो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“बोग़ाय मुने ततद मुतेन विळ्सिसि, ओसो उंदि दुस्रा मुतेन ततोग़ इतेके, ओग़ साट्याल कबळ कीस्तोग़. ओसो बोग़ाय अद्रम विळ्सिसीतद आंचान बार, तन्क मुते कीतोग़ इतेके, ओग़ वने साट्याल कबळ कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ओसो उंद पोल्‍लो केंजाटु. ओर्वोग़ पका साव्कर मन्कल मतोग़. ओग़ डुंगा पंडलेह्‌काडा रंगताङ, पका दाराताङ गेंदेङ केग़्न्दोग़. ओसो दिनमे बेस सुकमते, गिर्दा-वेळ्काते ओसो बेरा गिजुरते मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","मति ओर्वोग़ बार ओसोय गरिब मन्कल मतोग़. ओना पेदिर लाजर मता. ओग़ मेंदुलमेंड बोटाङ आस मतोग़. ओन दिनमे साव्करना लोता अग़दगा, बोरो तचि तासिस अंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","साव्कर तिनदह्‌पा, इळ्न अरतव पेसावार्किन तेला तिन्जि, पोटातुन निहेनन इन्जि, ओग़ विचर कींदोग़. ओसो ओना मेंदुदाङ बोटान नय्क बार वासि नाकिन्दुङ. ");
INSERT INTO mrr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“मनेक मनेके उंद दिया, गरिब मन्कल डोलतोग़. अस्के देवतुल्क वासि, ओना जीवातुन पोग़ोन सिंगर्दीपतगा अब्रहम मुय्तोना कचुल ओस तासताङ. पया उचुक दियाने, ओग़ साव्कर मन्कल वने डोलतोग़. लोकुर ओना सति-गति कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ओग़ साव्करना जीवा हानादीपता किसबटटा जागातगा तिपलते मनदह्‌पा, पोग़ोन ऊळतोग़; ऊळनेके, ओन्क जेकु अब्रहमना कचुल, लाजर उदिस मनदनदिन ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","अस्के पया ओग़ अब्रहमिन आळो कीस इद्रम इतोग़, ‘ए अब्रहम तादोनिन! नाक ऊळिस जीवा लोपा रा! नना किसबटटगा कर्वलाह आतन. निमा मुर्बत कीसि लाजरिन लोहचीम, ओग़ वासि तना वेळ्न्जतुन एतगा मुळ्हचि, नावा वेंजेटुन सितुर कीयेग़,’ इनजोर केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","अस्के अब्रहम इतोग़, ‘ऊळा पेका! निमा सीता कीम, जीवात मनदह्‌पा, नीवा पिसमुळते बाताल गावले मता, अद सबे नीक दोर्कता. मति वेग़ लाजरिह्‌क इतेके, अद्रमता सुकमता पिसमुळ दोर्को. इंजेके इगा वेन्क बाताले तिपल इले. मति निमा मात्रम अगा कर्वलाह आतिन. ");
INSERT INTO mrr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ओसो उंद पोल्‍लो केंजा, मीवा-मावा नडुम, उंद बेरा कस्क्ने मनदनद किंडि मन्ह्‌ता. अदिनेनाह्‌क मियग्डाह बोर इके वेंडकोम इतेक तेला वेंड पग़वोर, ओसो मयेकेडेनाह मियेके बोर वेंडकोम इतेक तेला वेंड पग़वोर,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","अस्के साव्कर इतोग़, ‘अल अह इतेक तादो, नना नीक अर्जि कीय्ह्‌नन. नियोग़ लाजरिन नावा बाबाना लोन लोहचीम. ");
INSERT INTO mrr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","बाराह्‌क इतेके नाक एयवुर तमोर मन्ह्‌तोर, (ओर नावा लेह्‌का पापि बुदते मनमाकिर इनजोर,) ओरिन अन्ज वेहतेके, नना पका तिपल आय्ह्‌नन इद जागातगा, ओर वावोर आयनुर,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","इतस्के अब्रहम इतोग़, ‘ओरगा इतेके मोसाल रासतव अडोङ, ओसो दुस्रोर देवुळता कबुरतोर रासतव पुस्तकिङ मन्ह्‌ताङ. अविस्किन अर्विसि, अग्डा पोल्‍लोतुन केंजिर, अद्रमलेह्‌का ताकिर,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","इतस्के साव्कर मन्कल इतोग़, ‘अद्रम आयो अब्रहम तादो! डोलतोरग्डाह बोग़ाय अन्जि ओरिन वेहतेके, ओर पापमता अग़दाहि मिळ्न्दिसि, देवुळतके मलयनुर,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अस्के अब्रहम ओन इतोग़, ‘मोसाल रासतव अडोना, ओसो दुस्रोर देवुळता कबुरतोराङ पुस्तकिना पोल्‍लोतुन केंजोर इतेके, डोलतोग़ मन्कल जीवा अर्सि, ओरिन वेहतलाह अतेक वने, ओर केंजोर आयनुर,’ इनजोर इतोग़.” ");
INSERT INTO mrr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","उंद दिया येसु तनाङ कग़यवालोरिन वेहतोग़, “पापम कीयनाह तग़्हतनव पोल्‍लोङ मनदनुङे! मति बोग़ मीकु पापमतेके ओसीस्तोग़, ओना पका गोसा आयग़ा! ");
INSERT INTO mrr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","उड्लोर पेकोरा लेह्‌का नाक नमवालोरग्डाहि बोनाय वग़ोनु, ओना नयगा मतद विस्वसतुन विळ्सलाहि, बोग़ कटळ वाटटप आस्तोग़, (वेग़ कटळ वाटवाल देवुळता बेरा सिक्सातुह्‌कु ओजनोग़). वेना वेळेटगा पका पूहतद जेता बंडातुन दोहचि, वेन सम्दुरते वेल्‍लाह आता कसातगा मुळ्हतना, (इद बेरा सिक्सा आंदु; मति) तान्काय वीळिस बेरा सिक्सा, देवुळि अद्रम कटळ वाटवाह्‌क ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","अदिनेनाह्‌क मीवा ताकमुळते उसर मन्ह्‌टु. “मीवा तोळतोग़ गल्ति कीतेके, ओन तेर्हाटु. ओग़ तना कीता गल्तिताह मलतेके, ओना गल्तितुन मापि कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ओग़ उंदिय दिया एळुङ मल्काङ मीवा विरुदते पापम कीसि, ओसोवने एळुङ मल्काङ मियगा वासि, नना चुकतन, इंजेक अद्रम केवोन इनजोर इतेके, ओन मापि कीम्ह्‌टु,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","इदिन पया केंजिस, “मावा विस्वसतुन बेर्सिह कीसीम गूरु,” इनजोर बळयिर येसुसामिन इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","इतस्के येसुसामि इतोग़, “मीवा विस्वस नूङमेटा मतेक वने, मीट इद बेरा ताळ मरातुन, ‘कुळ्ह वासि, सम्दुरतगा निल्म’ इनजोर वेहतेके, अद मीवा पोल्‍लोतुन केंजग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“इंजेके मियग्डाहि बोना तेला लोतगा ओर्युलतोग़ मनदनोग़, ओग़ पूहतलाह आयि, इलवेक इसि कोंदानके आयि, अनेग़. अन्जि तना कबळतेनाह लोन मल्स वातस्के, ‘वाता वावाय गाटो तिनदलाह उदा रा’ इनजोर, माल्काल ओन इनोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","मति ‘नयेनाह्‌क गाटो अटा, जगा केग़्स नना तिनाह्‌जोम, नाक वांटिस ईम. ताना पया निमा तिन’ इनजोर इनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ओसो नना वेहतद कबळतुन कीतोग़ इनजोर, ओर्युलतोन ‘बेस कीतिन!’ इनजोर इनोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","अद्रमे मीट वने देवुळ वेहतद पूरा कबळतुन मारिह कीतस्के, ‘माटु ओर्युलतोरोम मान दोर्कना मुर्तिय लायक आयोम! माक बेद कबळ कीयनद मता, अदे कबळतुन कीतोम,’ इनजोर इन्ह्‌टु,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","पया येसु येरुसलेमतके दायह्‌पा, सामरिया ओसो गालिल, इव पटिना नडुमतुह्‌क अनजोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","अस्के येसु बेदो उंद नाटेनगा दायह्‌पा, अग़दुह्‌क उचुन अबर, मोंडरोगमतोर दहा मन्कलोर निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ओर येसुन ऊळिस जोरते केयतोर, “ए येसु! गूरु! माक ऊळिस जीवा लोपा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","येसु ओरिन ऊळिस इतोग़, “अले मीट इंजेक इग्डाह अन्जि, मीवाङ मेंदुस्किन बूमयालोरिह्‌क तोहाट,” इनजोर इतोग़. इतस्के ओर अतोर. अनेक-अनेकेन ओरा मोंडरोगम मायता. ");
INSERT INTO mrr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","पया ओर दहा मन्कलोरग्डाहि ओर्वोग़ मन्कल, तना सव्रेम आतदिन ऊळतोग़. अस्के ओसोवने येसुनगा मल्स वासि, जोर-जोरते केयिस, देवुळतुन जोहर कीया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ओसो ओग़ येसुनाङ काल्क अर्सि, ओन जोहर कीतोग़. ओग़ मन्कल सामरि जाततोग़ु, (इतेके उड्ला जाततोग़) मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","अस्के येसु इतोग़, “कतमतोर सव्रेम आतोर इसि. पया इंका नव मन्कलोर बेगाडुर? ");
INSERT INTO mrr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","वेग़ यहुदि आयवोग़ दुस्रा जाततोन विळ्सिसि, ओरग्डाह बोग़े बह देवुळतुन जोहर कीयलाहि, मल्स वावोग़ गोतो!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ओसो ओन, “तेदिस अन! निमा नाक विस्वस कीतिन, अदिनेनाह्‌क सव्रेम आतिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","उंद दिया परुसिर येसुनु, “देवुळि तना राजेमतुन माक बेस्के दिसिह कीयग़ा?” इनजोर ताल्ह्‌कतोर. ताल्ह्‌कतस्के येसु वेहतोग़, “देवुळ राजेम कीयनद कोंडाह्‌क दिसो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","देवुळि मीवा नडुम राजेम कीस्ता. अदिनेनाह्‌क ‘इदु! देवुळि इगा राजेम कीस्ता. अदु! अगा राजेम कीस्ता,’ इनजोर लोकुर वळ्ह्‌कोर आयनुर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ओसोवने कग़यवालोरिन इद्रम इतोग़: “माने-मन्कना नडुम पुटटोनन, नना राजाल आसि वायनद दियातुन ऊळलाह विचर कीकिर, मति मीट ऊळ पग़विर आयकिर, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","अस्के इगा मन्ह्‌तोग़, अगा मन्ह्‌तोग़, इनजोर लोकुर मीकु इनदनुर, अगा मीट अनमाटु, ओरा संगे कलियमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","पोग़ोन उंद बाजेतके मिळ्स्कतेके, दुस्रा बाजेतके वेह्‌च आस्ता. अद्रमलेह्‌काने माने-मन्कना नडुम पुटटोनन नना, आक्रि दियाते वायकन अस्के, कतमतोर नाक ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","मति ताना मुने नना पका तिपल आयकन. इद पीळतोर मन्कलोर नाक पास्कनुर. ");
INSERT INTO mrr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“नोहा मुय्तोना वेलाते बेद्रम आता, अद्रमे माने-मन्कना नडुम पुटटोनन नना वायह्‌पा आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोहा मुय्तोग़ ओडातगा नेङनाह्‌जोम, लोकुर तिनदना-उनडना कींदुर, मुतेस्क तन्दुर, मुजोह्‌क अन्दुङ. पया बेरा उड्रा वासि, ओर कतमतोरिन बूळे कीता. ");
INSERT INTO mrr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“ओसो लोटना वेलाते वने अद्रमे आता. लोकुर तिनदना-उनडना, असना, वमना, वीतना, लोह्‌क पंडना कींदुर. ");
INSERT INTO mrr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","मति लोट सोदोम सहरताहि पेसतस्के, पोग़ोटा बूमताहि मळ्गनव किसतळ्मिङ अरताङ, अस्के नाग़मेटोर कतम बूळेम आतोर. ");
INSERT INTO mrr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","माने-मन्कना नडुम पुटटोनन नना दिसनद दिया वने, अद्रमलेह्‌काने आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","अदिनेनाह्‌क अद दिया बोग़ाय लोता पोग़ोन मतेके, लोतगा मनदनद सामनतुन ततलाह, इळ्न रेगनद आयो. अद्रमे बोग़ाय मन्कल पोलमते मतेक वने, ओग़ मल्स वायनद आयो. ");
INSERT INTO mrr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोटना मुते (देवुळता पोल्‍लोतुन केंजवा, सोदोम सहरतुन मिळ्न्दिस ऊळतस्के), तान्क बह आता, अदिन सीता कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“ओसो बोग़ इद बूमतगा आपुना जीवातुन पिसिह कीयलाह ऊळिह्‌तोग़, ओग़ आक्रिते बूळेम आयनोग़. बोग़ बारा नयेनाह्‌क सबे पोहतह्‌तोग़, ओन्क देवुळताहि पूना जीवा दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","नना मीक वेहतह्‌नन, नना वायह्‌पा, नग़्का इर्वुर मन्कलोर उंदिय जागाते उंजिस मनदनुर. मति नना ओर्विन बार नावा संगे मनदलाह ओयकन, ओर्विन बार सिक्सा आयलाह अगान विळ्सिसीकन. ");
INSERT INTO mrr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ओसो रेंड आस्कु जेताते पिंड नोग़सोर मतेके, नना उंदतुन बार नावा संगे ओयकन, उंदतुन बार अगान विळ्सिसीकन.  ");
INSERT INTO mrr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","इर्वुर मन्कलोर पोलमतगा मतेके, नना ओर्विन बार नावा संगे ओयकन, ओर्विन बार अगान विळ्सिसीकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","अस्के कग़यवालोर येसुन, “इव पोल्‍लोङ बेगा आयनुङ सामि?” इनजोर ताल्ह्‌कतोर. अस्के, “बेगा हातद सेत्ता मनदग़ा, अगा गीदस्क जमा आयनुङ,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","पया येसु तनाङ कग़यवालोरिन दिनम पार्तना कीसोर मनदना, ओसो अमेसा पार्तना कीयलाह बेस्केन आरेम आयना आयो इनजोर, उंद पीटो इद्रम वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“उंद नाटेनगा ओर्वोग़ गाय्ताल मतोग़. ओग़ लोकुरा नेयम कीसींदोग़. मति ओग़ मन्कल मात्रम देवुळतुन बह रेयवाल आयोग़, ओसो लोकुरा पर्वा वन केवाल आयोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","अदे नाटेनगा उंदि रांडे आंचाळ मता. अद ओनगा दिनमे वासि, ‘गाय्ता, नावा विरुदतोना संगे मनदनद कट्लातुन, नेयम कीसि देहचीम,’ इनजोर वेहन्दु. ");
INSERT INTO mrr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","वेल्‍लाङे दियाङ आनाह, ओग़ ताना नेयमतुन पर्वा केवालेवा केमेन मतोग़. मति उंद दिया ओग़ तनतनाय विचर कीतोग़, ‘नना देवुळतुह्‌के बह रेयोन, ओसो मन्कह्‌के बह रेयवानन आयोन. ");
INSERT INTO mrr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","तेला मति इद रांडे आंचाळि दिनमे नयगा वासि, कयर कीस्ता. अदिह्‌क इंजेक तेना नेयम कीसि देहचीतेकेन बेस आयग़ा. इलवेके इद दिनमे कयर कीसोरेन मनदग़ा,’ इतोग़.” ");
INSERT INTO mrr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","पया ओसो येसुसामि इतोग़, “नेयम कीसेवाल लाग्वोग़ मन्कल बाताल इतोग़, अद पोल्‍लोतुन सीता कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","देवुळ आचतोर लोकुर, देवुळतुन नग़्का-पियलि कोळ्‍व कीसोर मन्ह्‌तोर, ओरा नेयम आयना इन्जि, ओरिह्‌क तोळ ईयलाहि, देवुळि आल्सेम कीयग़ाया? ");
INSERT INTO mrr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","नना मीक वेहतह्‌नन, देवुळि ओरा नेयम चट्पिट कीसीयग़ा. तेला मति माने-मन्कना नडुम पुटटोनन, नना बेस्के मल्स वायकन, अस्के इद बूमतगा विस्वसतुन विळ्सवा, पार्तना केवालोर दोर्कनुरा?” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ओसो उय्तुर मन्कलोरु, माटे देवुळतुह्‌क विचर वानाह पिसिह्‌नोम इनजोर, दुस्रोरिन पास्किंदुर. ओरेनाह्‌क वने येसु उंद पीटो वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“इर्वुर मन्कलोर देवुळतुन पार्तना कीयलाहि, मंदिरतगा अतोर. ओरग्डाह ओर्वोग़ बार परुसि, ओर्वोग़ बार नाकातगा सिद्‌वा एनवाल. ");
INSERT INTO mrr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","परुसि बाताल कीतोग़ इतेके, ओग़ सिद्‌वा एनवानग्डाह जेक निचि, इद्रम पार्तना कीतोग़, ‘ए देवुळतिन! नना दुस्रोरा लेह्‌का कलेनन आयोन, ओसो नाळेह केवानन वने आयोन, साट्याल कबळ केवोन. ओसो नियोग़ सिद्‌वा एनवाना लेह्‌का वने, नना लोकुरिन मुळ्हवानन आयोन. अदिनेनाह्‌कु नना नीक जोहर कीय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","वारममेटुह्‌क रेंड मल्काङ उपस कीय्ह्‌नन. नावा कमयता दहा तूस्कनग्डाहि, उंद तूस नियेनाह्‌क दान वने ईय्ह्‌नन,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“मति सिद्‌वा एनवाल मन्कल जेक नितोग़. ओन्क पोग़ोन ऊळलाह वने दीरा वावो. ओग़ तना पापमतुन आलिह कीसि, अर्युल पासोर इद्रम पार्तना कीतोग़, ‘ए देवुळबाबा! नना बेरा पापि मन्कनन आंदन. नावा पोग़ोन जीवा लोपा,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","पया ओर इर्वुरग्डाहि, सिद्‌वा एनवाले देवुळता मुनेह सेतेमतोग़ आसि लोन अतोग़. मति परुसि सेतेमतोग़ आयोग़. बाराह्‌क इतेके, बोग़ तन्क बेरोनन इन्ह्‌तोग़, देवुळि ओन उड्लोग़ कीस्ता. मति बोग़ तन्क उड्लोनन इन्ह्‌तोग़, देवुळि ओन बेरोग़ कीस्ता,” इद्रम वेहचि पीटोतुन येसुसामि मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","उंद दिया तमाङ पेकोरा पोग़ोन कय तासिसि, ओरिह्‌क बर्कत ईयेग़ इनजोर, लोकुर येसुनगा बाला पेकोरिन तचोर मतोर. मति इके येसुना एरे पेकोरिन तमाट इनजोर, कग़यवालोर ओराङ तलिस्क-तपेरिन तेर्हतोर. ");
INSERT INTO mrr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","मति येसु पेकोरिन तनगा केयिसि, कग़यवालोरिन इतोग़, “पिलाङ-पेकोरिन नयगा वायलाह ईम्ह्‌टु, ओरिन रोमिह केमाट. बाराह्‌क इतेके देवुळबाबाल वेरा लेह्‌काडोर कुलुल बुदतोरिह्‌के राजाल आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","इह केंजाट, नना मीक सेतेम वेहतलाह आतन, बोरु वेर उड्लोर पेकोरा बुदता लेह्‌का आसि, देवुळतुन तमा जीवातगा राजेम कीयलाह एवोर, देवुळ राजेम केवालोर लोकुरगा, ओरिह्‌क बेस्केन जागा दोर्को आयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","पया ओर्वोग़ यहुदि मुक्याल येसुन इद्रम ताल्ह्‌कतोग़, “गूरु! निमा पका सेतेमतोनिन आंदिन. नाक वेहा, देवुळता संगे अमेसाता पिसमुळ दोर्किह कीयलाहि, नना बाताल कीकन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","इतस्के येसु ओन इतोग़, “निमा नाक सेतेमतोनिन इनजोर बाराह्‌क इह्‌निन? देवुळतुन विळ्सिस बोग़े सेतेमतोग़ इलेग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","निमा मोसानाङ अडोङ इतेके पुह्‌निने: साट्याल कबळ केमा, बोने हव्कमा, बोनाङ कलमा, जोल साक्सि एमा, आपुना तलोग़-तपेह्‌क मान ईम,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ओग़ मुक्याल, “इव सबे पोल्‍लोनु, उड्लस्केडाहिये माळसोर वायलाह आतन गूरु!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ओना पोल्‍लोतुन केंजिसि येसु इतोग़, “(इंगो निटमे निमा उड्लग्डाहि अव अडोन माळसोर वातिन, मति) नियगा इंका ओसो उंद पोल्‍लोता कमि मन्ह्‌ता. अन! नियगा मनदनद सबे मालसोमतुन वमिसि, लेवोरिह्‌क तूसिसीम. अद्रम कीसि, निमा नावा संगे मन्जि नावाङ कग़या. अद्रम कीतिन इतेके, पोग़ोन देवुळता जागातगा नियेनाह्‌क निटमता मालसोम दोर्कग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","येसुना इद पोल्‍लोतुन केंजिसि, ओग़ मुक्याल ओसोय मेसेह्‌ने आतोग़. बाराह्‌क इतेके, ओग़ पका साव्कर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ओग़ मेसेह्‌ने आतदिन ऊळिसि येसु इतोग़, “साव्कर लोकुर देवुळता राजेमतोर आयना इतेके, पका मुस्किल आस्ता. ");
INSERT INTO mrr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ऊज-बूकातुह्‌क रूटुम पेसिस दाया पग़यह्‌ताया? अद्रमे, मता मन्कल देवुळता राजेमतोग़ आयना इतेके, तान्काय मुस्किलता पोल्‍लो!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","अस्के येसुना पोल्‍लोतुन केंजवालोर ताल्ह्‌कतोर, “अह इतेके अमेसाता पिसमुळ पया बोन्क दोर्कग़ा गूरु?” (पका मालसोम इतेके देवुळता देय्वाता सीना आंदु इनजोर विचर कीताह्‌कु, ओर इद्रम इतोर.) ");
INSERT INTO mrr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","इतस्के येसु इतोग़, “इव पोल्‍लोङ मन्कना कयदे आया पग़वोङ, मति देवुळताये कयदे इव सबे आया पग़यह्‌ताङ.” ");
INSERT INTO mrr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","इनजोर इतस्के पत्रु इतोग़, “ऊळा गूरु, माट इतेके मावा लोन-दुवर विळ्सिस, नीवा पेग़्के वातोम.” ");
INSERT INTO mrr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","इतस्के येसु इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, बोग़ाय देवुळि नावा राजाल इनजोर तान माळलाह, तना लोन-दुवरतुन, मुतेनु, पिलाङ-पेकोरिन, तलोग़-तपेनु, दादाल-तमोनु विळ्सनोग़, ");
INSERT INTO mrr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ओन्क इद कालमते लेकालेवा सम्सरम ओसो एळ्म-दळ्मतोर दोर्कनुर, अचोने आयो मति ओसो वायना कालमते अमेसाता पिसमुळ वने दोर्कग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","पया येसु तनाङ बारा बळयिरिन, बेदो उंद जागातगा केयिस इतोग़, “इद ऊळाट! माट येरुसलेम दायलाह आतल. माने-मन्कना नडुम पुटटोनन, नावा लोप्पा वेल्‍लाय मुने देवुळता कबुरतोर बाताल रासिस तासतोर, अद सबे करल आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","रासतप लेह्‌का नाकु यहुदि आयवोरा कयदे पोस ईयनुर. नावा पोग़ोन उस्कनुर, पास्कनुर, नावा कदर रेहतनुर. ");
INSERT INTO mrr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","जेट्लाते नल्हतनुर, अह कीसि नाक हव्कनुर. मति नना मूंड दियाने जीवा अरयकन,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","मति ओग़ वेहतव पोल्‍लोनग्डाहि कग़यवालोरिह्‌क उंद पोल्‍लो वन तेळियो. अव पोल्‍लोना अर्तम ओरग्डाह मकिह कीतद मता. अदिह्‌क ओग़ वेहतव पोल्‍लोङ, कग़ियवालोरिह्‌क मुर्तिय तेळियोङ. ");
INSERT INTO mrr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","पया येसु यरिग़ो नाटेना एरे एवतोग़. अस्के नाटेना लोप्पा ओळियिह्‌पा अग़दा कचुल ओर्वोग़ तोववोग़ गुडि उदिस बिचेम ताल्ह्‌कसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","अस्के लोकुरा लेङतुन केंजिसि, “(अले बोराय नाक वेहाट रा!) इगा बाताल आस्ता?” इनजोर ताल्ह्‌क बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","पया बोरो ओनु, “नासरेत नाटेनोग़ येसु दायलाह आतोग़ रा,” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","वेहतस्के ओग़ गुडि, “ए येसु! दाविद राजाना कूळतोनिन पिसिह केवानिन! नावा पोग़ोन दया कीमु,” इनजोर केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","केयतस्के मुडा मुनेह मतोरु, “निमा केयमा रा, केमेन मन!” इनजोर ओन तेर्हतोर. तेला मति ओग़ ओसोवन पका जोरते केयलाह आतोग़. “ए दाविद राजाना कूळतोनिन! नावा पोग़ोन दया कीम!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","इतस्के येसु ओना लेङतुन केंजिसि नितोग़. निचि “अले ओन नयगा ताट रा,” इतोग़. पया ओन येसुनगा ततोर. ततस्के येसु ओन ताल्ह्‌कतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“नयग्डासि नीक बाताल गावले?” इतस्के ओग़ु, “नाक तोवनाह कीसीम सामि,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","पया येसु, “अले! अह इतेके नावा पोग़ोन विस्वस कीतिन, अदिह्‌क तोव्‍म,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","अस्के ओग़ तोप्नेन तोवतोग़. तोवतस्के देवुळतुन जोहर कीसोर-कीसोर येसुना संगे अतोग़. अगा मतोर सबेटोर ओग़ गुडि सव्रेम आतदिन ऊळिसि, देवुळतुन जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","पया येसु यरिग़ो नाटेनगाह्‌क अनजोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","अद नाटेनगा ओर्वोग़ जकय पेदिरतोग़ मन्कल मतोग़. ओग़ रोम सर्करतोरिह्‌क, सिद्‌वा एनवालोरा मुक्याल मतोग़. ओसो पका साव्कर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","येसु बोग़ आंदोग़ इनजोर, ओग़ ऊळलाह अग़िङ पर्ह्‌किंदोग़. मति येसुना सर्ने वेल्‍लाय मुल मताह्‌कु, ओन ऊळ पग़वोग़. बाराह्‌क इतेके ओग़ ओसोय गुटिल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","पया येसुन ऊळकन इन्जि, ओग़ जकय येसु दायनद अग़देके मुनेह वितिसि, उंद तोया मरातगा तग़्ङतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","येसु अद मरातगा एवतोग़, अस्के पोग़ोन ऊळिस ओन इद्रम इतोग़, “अले जकय! चट्पिट इळ्न रेगा! नाक नेंड नीवा लोन रोमना मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","इतस्के जकय चट्पिट रेगिसि, येसुन तना लोन ओतोग़. ओसि बेस-नेह्‌ना गिर्दाते उदिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","येसु जकयिना लोन अतदिन ऊळिसि, “वेग़ पापि मन्कना लोन मनदलाह अतोग़,” इनजोर मुडा मन्कलोर मुयोग़ आया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","पया जकय निचि येसुसामिन इद्रम इतोग़, “गूरु! इंजेके नावा मालसोमतग्डाहि वळ्गा तूस लेवोरिह्‌क ईय्ह्‌नन. ओसो नना बोनग्डाह आयि नाळेह कीस ततद मतेके, ओन्क नालुङ पटिङ मल्हच ईय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","अस्के येसु ओन इतोग़, “नेंडु इद लोतगा अमेसाता पिसमुळ वाता. वेग़ सिद्‌वा एनवाल वने, अब्रहमना जालपिलतोग़े आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","माने-मन्कना नडुम पुटटोनन नना लेसतोरिन पर्ह्‌कलाह, ओसो ओरिन पिसिह कीयलाहि वातन, इदिन सीता कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","पया (ओर बेद नाटेनगा मतोर, अद नाटेनग्डाह)येरुसलेम एरेन मता, अदिनेनाह्‌क इंजेके येसु येरुसलेम एवयनोग़ अस्के, सबेटोर लोकुर ऊळनाह, देवुळि मयगा राजेम कीयग़ा इनजोर, मुडा मन्कलोरु विचर कींदुर. अदिनेनाह्‌क येसु ओरिह्‌क उंदि पुन्पिह कीयनद पीटो इद्रम वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“ओर्वोग़ राजालोरा कुट्मळतोग़ मन्कल मतोग़, ओग़ राजाल आसि वायलाह, जेकता देसेमते सबेट्क बेरोग़ राजान कलियलाह अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","दायनामुने ओग़ तनाङ ओर्युलतोरग्डाहि दहा ओर्युलतोरिन केयतोग़, केयिसि ओरिह्‌क दहा बंगरताङ कल्दर्क ईतोग़. ईसि, नना मल्स वानाह्‌जोम इव कल्दर्कने मीट दंदा कीम्ह्‌टु इनजोर, वेहच अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“मति नाटेना दुस्रोर लोकुर ओन विरुद कींदुर. अदिह्‌क वेग़ मावा नडुम राजेम केमाकेग़ इनजोर, सबेट्क बेरोग़ राजानगा, कबुरतोरिन ओना पयाह लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","पया ओग़ राजाल आसि मल्स वातोग़. वासि, नना बंगरताङ कल्दर्क ईस मतन, ओरु दंदा कीसि, बेचोक कमय कीतोर इनजोर ऊळलाहि, ओरिन केय वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","पया मुनेतोग़ ओर्युलतोग़ वातोग़, वासि, ‘महरज! निमा ईस मतिन अद बंगरता कोताते, नना दहा बंगरताङ कल्दर्क कमय कीतन,’ इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","वेहतस्के माल्काल इतोग़, ‘बेस-नेह्‌ना कीतिन. निमा बेसतोग़ ओर्युलतोनिन! उड्ला कबळतुन नाळेह केवालेवा कीतिन. अदिनेनाह्‌क नीक दहा नाह्‌किन ताकिह कीयलाहि अदिकर ईकन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","अद्रमलेह्‌काने दुस्रोग़ ओर्युलतोग़ वने वासि, ‘महरज! निमा ईस मतिन अद नीवा बंगरता कोतातग्डाहि, नना एयुङ बंगरताङ कल्दर्क कमय कीतन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","इतस्के माल्काल वेन वने, ‘नीक एयुङ नाह्‌कना मुक्याल कीकन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","पया ओसो ओर्वोग़ ओर्युलतोग़ वासि, ‘महरज! इद नीवा बंगरता कल्दर देस्तितगा गट कीस तासिस मतन. ");
INSERT INTO mrr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","निमा कळक मन्कनिन आंदिन, अदिह्‌क नना नीक रेयतन. नीवा कयदे तासवदिन पेह्‌किह्‌निन, ओसो नीवा कयदे वीतवग्डाङ कोयह्‌निन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","इतस्के माल्काल इतोग़, ‘लाग्वोग़ ओर्युलतोनिन! नीवा तोडटा वळ्ह्‌कतद पोल्‍लोतेने, नीक नेयम कीकन. नना कळक मन्कनन, नावा कयदे तासवदिन पेह्‌किह्‌नन, ओसो नावा कयदे वीतवग्डाङ कोयह्‌नन इनजोर, नीवा विचर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","इतेके अद कल्दरतुन साव्करनगा बाराह्‌क तासविन? अस्के नना वासि सवयते तेंडिस मनेनन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ओसो एरे निच मतोरिन इतोग़, ‘अद कल्दरतुन वेनग्डाहि ऊंदिसि, दहा बंगरताङ कल्दर्कनोग़ मन्कह्‌क ईम्ह्‌ट,’ इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","वेहतस्के ओरु, ‘महरज! ओनगा दहा कल्दर्क मन्ह्‌ताङ इसि!’ इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","माल्काल इतोग़, ‘नना मीक वेहतह्‌नन, बोर-बोरु तम्क दोर्कतद सोमतुन बेस काळ्ङिह्‌तोर, ओरिह्‌क इंका ओसो दोर्कग़ा. मति बोर-बोरु अद्रम केवोर, ओरगा मनदनदिन वने, देवुळि ओयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","मति इंजेके इगा वेग़ राजेम कीयना आयो इनजोर, बोर नाक विरुद कीतोर, ओरिन नावा मुनेह तचि हव्काट,’ इनजोर माल्काल इतोग़,” इनजोर वेहचि, येसु पीटोतुन मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","इव पोल्‍लोङ वेहतापया, येसु येरुसलेम दायनद अग़दे, लोकुरा मुनेह-मुनेह ताक बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","अनेके जय्तुन मेटाता कचुल मतव बेत्पागे ओसो बेतनि, इव नाह्‌कना एरे एवतोर. अस्के कग़यवालोरग्डाह इर्वुरिन इद्रम वेहतोग़: ");
INSERT INTO mrr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“मुनेह दिसनद नाटेनगा अन्ह्‌ट. अगा ओळियताहे, बोग़े बेस्केन उदिस अनवद गाळ्‍द पियोतुन दोहच तासतदिन ऊळकिर. अस्के तान लेहच पोस ताट. ");
INSERT INTO mrr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","बोग़ाय बाराह्‌क लेहतलाह आतिर इनजोर ताल्ह्‌कतेके, ‘सामिह्‌क तेना गर्ज अरता’ इनजोर वेहाट,” इनजोर वेहच लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","अस्के ओर अतोर, अतस्के येसु ओरिन बेद्रम वेहच मतोग़, अद्रमे तान दोर्किह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","पया अद गाळ्‍द पियोतुन लेहचोर मतोर, अस्के गाळ्‍दताङ माल्कालोर, “मीट तान बाराह्‌क लेहतलाह आतिर रा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","अस्के ओरु, “सामिह्‌क तेना गर्ज अरता दादा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","पया तान येसुनगा ततोर. तचि तमा मुचिस मतव गेंदेङ, गाळ्‍द पियोता पोग़ोन वाटटोर. वाटिसि ताना पोग़ोन येसुन उदिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","येसु ताना पोग़ोन उदिस पेसतोग़, अस्के (राजाल अनेके बेद्रम कीस्तोर, अद्रमलेह्‌का ओना मुनेह-मुनेह,) लोकुर अग़दगा तमा मुचिस मतव गेंदेन ताग़सोर, (ओन मान ईंदुर). ");
INSERT INTO mrr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अद्रमे पया जय्तुन मेटातग्डाह रेगतोग़. अस्के अग़दुह्‌क अनवालोर सबेटोर कग़यवालोरु, तमा ऊळतव बामिह कीयनव कबस्किन सीता कीसि, पका जोरते केयसोर, गिर्दाते देवुळता जोहर कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ओर इद्रम केयतोर इतेके, “देवुळबाबाना अदिकर पोस वावाल राजाह्‌कु देय्वा आयि! देवुळता संगे गूनम मन्ह्‌ता! पोग़ोटा बेरा देवुळतुह्‌क मान आयि,” इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","अस्के मुडगा मतोर उय्तुर परुसिर येसुनगा वासि, “गूरु! नीवाङ कग़यवालोरिन केयमाट इनजोर केमेन कीम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","पया येसु ओरिनु, “नना मीक वेहतह्‌नन, ओकावेला वेर बार केमेन आतोर इतेके, इव अग़दग्डाङ बंडाङे केयनुङ,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","पया येसु येरुसलेम सहरता एरे एवतोग़. अस्के अद सहरतुन ऊळिस अळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ओसो इद्रम इतोग़, “मीकु सुकम ईयनव पोल्‍लोन नेंडे मीट पुन्ज मतेके, बेस आस मनालि. मति इंजेके इसि, अव पोल्‍लोङ मीवाङ कोंडाह्‌क दिसोङ. ");
INSERT INTO mrr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","मीवा कोटुलतोर इद सहरतुन सर्ने कीस, मीक तिपल कीयनुर, अस्के मीक मकलाहि जागा वने दोर्को आयग़ा, इद्रमता वेला वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","मीवा देवुळि पिसिह कीयलाहि वातद कगोतुन मीट पुनविर. अदिनेनाह्‌क मीवा कोटुलतोरु मीकु, मीवा सहरतुन, दुराते काल्ह्‌पनुर. ओसो गूरेतगा बंडाता पोग़ोन बंडा मनवाह पिळ्हपळ कीयनुर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","पया येसु मंदिरतगा अतोग़, अन्जि अगा रेसातग आटुम उदतोरिन पलते पूंडलाह बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","येसु ओरिन इतोग़, “देवुळता कबुरतोग़ इद्रम रासतोग़: देवुळ इह इन्ह्‌ता: ‘नावा लोतुन मोळ्कनद जागा इनदनुर, मति मीट देवुळता लोतुन डाकुरा डेरा कीतिर,’” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","अद्रमे पया येसु दिनम मंदिरतगा अन्जि काग़्हन्दोग़. पेर्मालोरु, सास्त्रमगूरुर, मुक्या मन्कलोर, वेर ओन हव्कलाह अग़ ऊळिन्दुर. ");
INSERT INTO mrr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","मति सबेटोर लोकुर पका गिर्दाते, येसु वेहतनव पोल्‍लोन केंजिंदुर. अदिनेनाह्‌क ओन हव्कलाह, ओरिह्‌क अग़ दोर्को. ");
INSERT INTO mrr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","उंद दिया येसु मंदिरतगा लोकुरिन काग़्हनेके, बेसता कबुरतुन वेहचोर मतोग़. अस्के पेर्मालोर, सास्त्रमगूरुर, वेरु यहुदिराङ पेदल्कना संगे ओनगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","वासि “निमा बोना अदिकरते इग्डाह लोकुरिन पूंडलाह आतिन? नीक इद अदिकर ईतोग़ बोग़ आंदोग़, अले माक वेहा?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ताल्ह्‌कतस्के येसु इतोग़, “अले अह इतेके नना वने मीक उंद पोल्‍लो ताल्ह्‌किह्‌नन! ");
INSERT INTO mrr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","देवुळता पेदिरते एग़ मीहतनद अदिकर, योहनिह्‌क बेग्डाह दोर्कता? देवुळतेनाहुया बार मन्कनेनाहु? अले वेहाट,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","अस्के ओर तमतमाये, कुस्क-कुस्क आसोर वळ्ह्‌कलाह आतोर, “वेन माट बाताल वेहतकल रा? देवुळतेनाहे ओन्क एग़ मीहतलाह अदिकर दोर्कता इनजोर वेहतेक अचोन, ‘मीट पया बाराह्‌क योहननाङ केंजविर?’ इनजोर माक इनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ओसो मन्कनेनाहे ओन्क एग़ मीहतलाह अदिकर दोर्कता इनजोर इतेके, सबेटोर मावा पोग़ोन बंडाङ उकनुर, बाराह्‌क इतेके लोकुर योहनिन देवुळता कबुरतोग़ मतोग़ इनजोर इन्ह्‌तोर,” इन्जि विचर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","अदिनेनाह्‌क ओरु, “माट पुनोम योहनिह्‌क बेग्डाह एग़ मीहतलाह अदिकर दोर्कतायो,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","इतस्के येसु वने ओरिन “अह इतेके नना वने इव कबस्किन बोना अदिकरते कीयलाह आतन, अदिन मीक वेहोन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","पया अगा मता मुडुह्‌क, येसु उंद पुन्पिह कीयनद पीटो इद्रम वेहता बोटटोग़ इतेके, “ओर्वोग़ मन्कल तना जागातगा अंगुर सोपता वाळुम ओग़्सतोग़. ओग़्सिसि उय्तुर मन्कलोरिन कूलते ऊळेवाळे कीयलाह तासतोग़. तासिसि वेल्‍लाङे दियाङ मनदलाहि, दुस्रा देसेमते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“पया मनेक मनेके, पंडिङ कोयनद वेला एवता. अस्के वाळुमतुन ऊळेवाळे केवालोर माल्काना तूस ईयनुर इन्जि, अंगुर वाळुमतोग़ माल्काल तना ओर्वोग़ ओर्युलतोन लोहतोग़. मति वाळुमतुन ऊळेवाळे केवालोर ओन पोसि पका नल्हतोर, अह कीसि वेट्‍टाङ कय्क पूंडिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","पूंडटस्के पया, माल्काल ओसो ओर्वोग़ ओर्युलतोन लोहतोग़. ओर ऊळेवाळे केवालोर ओन वने पोसि पका नल्हतोर. ओसो लजा वानाह ओना कदर रेहचि, वेट्‍टाङ कय्क पूंडिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","मुचाकेपाते माल्काल ओसोवने ओर्वोग़ ओर्युलतोन लोहतोग़. ओन वने नोमुर्क आनाह पका नल्हचि, वाळुमता पलते वाटिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“पया इद्रम आनेके, अद वाळुमता माल्काल तनतनाय विचर कीतोग़, ‘इंजेके नना बह कीकन? अले इंजेक नना जीवा कीतोग़ नावा मग़िन लोहतकन, अस्के ओन ऊळिस बह कदर एवोरा?’ इनजोर मग़िन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","मति ओर मन्कलोर ओग़ वायनदिन ऊळिसि, तमतमाय इद्रम विचर कीतोर, ‘अरे वेग़ इतेक माल्काना मग़ि आंदोग़ रा! वेन हव्कतेक अचोन, पया इद वाळुम मावा आयग़ा,’ इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","पया ओग़ पेकाल अगा वातस्के, ओन वाळुमता पलतेह ओसि हव्कतोर. “अंगुर वाळुमता माल्काल इंजेके ओरिन बह कीयनोग़? ");
INSERT INTO mrr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ओग़ वासि ओर अद वाळुमतुन कयदे कीतोर सबेटोरिन हव्कनोग़. अह कीसि अद वाळुमतुन दुस्रोरा कयदे ईयनोग़,” इनजोर वेहतोग़. इद पोल्‍लो केंजिसि, अगा मतोर केंजवालोर “अद्रम बेस्केन आयमाकि!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","अस्के ओरेकेन ऊळिसि, येसु इतोग़, “बेद बंडातुन मुने बेल्दर्क पोहचीतोर, अदे बंडा इंजेके आदरता मूला-बंडा आता. इद्रम देवुळता सास्त्रमतगा रासतदिना अर्तम पया बाताल आस्ता? ");
INSERT INTO mrr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","बोग़ अद बंडातगा अरयनोग़, ओग़ ईंदेग़-पोदोग़ आयनोग़. मति अद बंडा बार बोनगा अरता इतेके, ओग़ गुंडा-गुंडा आयनोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","इद पोल्‍लोतुन वेहनेके, वेग़ मावा लोप्पाने इव पोल्‍लोङ वेहतलाह आतोग़ इन्जि, अदे वेलाते सास्त्रमगूरुर ओसो पेर्मालोर, येसुन बहाय कीस पोयतलाह ऊळिंदुर. मति लोकुर माक विरुद कीयनुर इनजोर रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","वेर पया येसुन पोयतलाह इद्रम पट कीतोर इतेके, येसु बेदाय तपिस पोल्‍लो वळ्ह्‌कतेके, ओन पोसि रोम सर्करतागुमसिनगा ओयकल इनजोरे, सेतेमतोरोम इन्जि नाळेह केवालोरु, आय्डाङ गुंजवालोरिन येसुनगा लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","अस्के वेर ओनगा अन्जि इद्रम ताल्ह्‌कतोर, “गूरु! निमा सेतेमतोनिन आंदिन, ओसो अद्रम काग़्हतह्‌निने वने. बेस्केन उड्लोर-बेरोर इनजोर ऊळविन. ओसो देवुळता अग़दुन सेतेमते तोहतह्‌निन इनजोर माट पुह्‌नोम. ");
INSERT INTO mrr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","मति इंजेके माक वेहा, रोम सर्करतुह्‌क सिद्‌वा दोहतनद मावाङ अडोना अडम मन्ह्‌ताया, इलेया?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","मति ओरा सत्रल बुदतुन पुन्जि, येसु इद्रम इतोग़, ");
INSERT INTO mrr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“अले नाक उंद वेंडटा कोता ईम्ह्‌ट,” इतोग़. ओर ईतस्के “इद कोतातगा बोना पोटो ओसो पेदिर रासतद मन्ह्‌ता?” इनजोर येसु ताल्ह्‌कतोग़. अस्के “कय्सर राजानाये” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","इतस्के “अह इतेके, बेद रोम राजेमता कय्सर राजाना मन्ह्‌ता, अद ओन्के ईम्ह्‌टु! ओसो बेद देवुळ ताल्ह्‌किह्‌ता, अदिन देवुळतुह्‌क ईम्ह्‌टु,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","येसुना वेहतद पोल्‍लोतुन केंजताह्‌कु, ओर बयल आसि केमेन आतोर. ओरु लोकुरा मुनेह, अद पोल्‍लोतेनाह्‌क येसुन पोयता पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","पया ओसो सदुकिरा तुंगातोर उच्वुर वासि, येसुन ताल्ह्‌कतोर. (वेर सदुकिरा तुंगातोर इतेके, मन्कलोर डोलतापया, बोरे जीवा अरवोर इनजोर इंदुर.) ");
INSERT INTO mrr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“गूरु! मोसाल मावासाटि इद्रम रासिस तासतोग़ इतेके, ‘मग़मियाळ लेवाय हातोग़ इतेके, ओना रांडे मुतेना संगे ओना तमोग़ जोळेम आसि, तमदादाना लोता लोन निल्पिह कीयना,’ इनजोर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“इंजेके तमोग़ एळवुर मतोर. ओरग्डाह मुनेतोग़ तमदादाल मुते ततोग़. मति मग़मियाळ आयवाये ओग़ डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","डोलतस्के ओना पेग़्केडोग़, अद रांडे मुतेना संगे जोळेम आतोग़. ओग़ वने मग़मियाळ आयवाये डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ओसो ओर्वोग़ ओना पेग़्केडोग़ वने, अद्रमे तान ततापया डोलतोग़. इद्रमलेह्‌का तमोग़ एळवुर आसि, मग़मियाळ आयवाये डोलतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","वेर सबेटोरा पया अद रांडे आंचाळ वने डोलता. ");
INSERT INTO mrr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","मति इंजेक ओर ओसोवन जीवा अरतस्के, एळवुरग्डाहि अद आंचाळि बोना मुते आयग़ा? बाराह्‌क इतेके ओर एळवुर आसि, ताना संगे जोळेम आस मतोर,” इतोर. (हामुरताहि जीवा अरयनदिन बय्तळ लोकुरे नमिह्‌तोर इन्जि तोहतलाह, वेर इह ताल्ह्‌कतोर.) ");
INSERT INTO mrr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","इतस्के येसु ओरिन इतोग़, “इद कालमतोर लोकुर मुतेस्क ततह्‌तोर, ओसो मुजोह्‌क वने दास्ताङ. ");
INSERT INTO mrr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","मति बोर लोकुर हामुरतग्डाहि ओसोवने जीवा अरयना लायक मनदनुर, ओर वायना कालमते बेस्केन मुतेस्क तवोर आयनुर, मुजोह्‌क अनोङ आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ओसो ओर देवुळताङ देवतुल्कना लेह्‌का मन्जि, बेस्केन डोलोर आयनुर. ओसोवने जीवा अरतेनाह्‌क, ओर देवुळताङ पिलाङ-पेकोर वने आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","केंजाट, (मावा पेदामुय्तोर अब्रहम, इसक, याकुब, वेर हातस्के, वेल्‍लाङे वर्साना पया मोसाल मतोग़. अस्के) किस पोतिस मतद मरा जपता लोप्पा मोसाल रासनेके, ‘अब्रहम, इसक, याकुब वेर मोळ्कनद देवुळतन ननान आंदन!’ इन्जि सामि इतद पोल्‍लोतुन रासतोग़. इद्रम इन्जि डोलतोर वने जीवा अरयह्‌तोर इनजोर तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","बह इतेके देवुळतुन हातोर मोळ्कोर, मति जीवात मनवालोरे मोळ्किह्‌तोर; (इतेके देवुळि अह इनदनस्के, ओर मुवुर हातोराङ जीवाङ मंदुङे.) अद देवुळता सबेटोर लोकुराङ जीवाङ नेंड वने पिसिह्‌ताङे,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","येसु वेहतद पोल्‍लोतुन केंजिसि, “गूरु! निमा बेस वेहतिन,” इनजोर उय्तुर सास्त्रमगूरुर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ताना पया येसुन ओसोवने पोल्‍लोङ ताल्ह्‌कलाहि, बोन्के बह दीरा वावो. ");
INSERT INTO mrr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","पया येसु ओरिन ताल्ह्‌कतोग़, “देवुळ लोहवाल पिसिह केवाल किर्स्तुनुदाविद राजाना पुळ्गतोग़ इनजोर इन्ह्‌तोर, इद बेद्रम आया पग़यह्‌ता? ");
INSERT INTO mrr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","दाविद राजाल कुदि देवुळताङ पाटाना सास्त्रमतगा इद्रम वेहतोग़: देवुळि नावा सामिन इता, ‘बेचानाह नना नीवा कोटुलतोरिन, नीवाङ काल्कना इळ्न तच एवोन, अचानाह नावा तिनळ बाजेता राजगादेतगा उदिस मन,’ इता इन्जि दाविद वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","इद्रम दाविद राजाल तना कुदि पिसिह केवाल किर्स्तुन ‘सामि’ इन्ह्‌तोग़. इतेके ओग़ दाविद राजाना पुळ्गतोग़ बेद्रम आया पग़यह्‌तोग़?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","सबेटोर लोकुर ओना पोल्‍लोतुन केंजसोर मतोर, अस्के येसु तनाङ कग़यवालोरिन इद्रम इनदा बोटटोग़: ");
INSERT INTO mrr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“सास्त्रमगूरुरग्डाहि उसरते मन्ह्‌टु. ओर तमा बेरातनम तोहतलाहि, लाट गेंदेङ केग़्सि तिरियलाह ऊळिह्‌तोर. बजरतगा मनवालोरु तम्क जोहर कीयिर इनजोर विचर कीस्तोर. मावाङ पार्तना कीयनव लोह्‌कनगा वेरिह्‌क उदलाह, मुनेहतेह कुर्सिङ गावले, कुळ्पिङ तिनदनाङ जागानगा उदलाह, वेर कदरताङ जागाङ पर्ह्‌किह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ओसो वेर रांडे आस्किन नाळेह कीसि लूटे कीस्तोर. ओसो लोकुरिह्‌क दिसना इन्जि, वेल्‍लाय जोम पार्तना कीस्तोर. इद्रमतोर लोकुरिह्‌क मात्रम दुस्रोरिह्‌काय एक्‍वा सिक्सा देवुळि ईयग़ा,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","पया साव्कर मन्कलोरु मंदिरता लोप्पा संदुकतगा, देवुळतुह्‌क कोताङ वाटनदिन येसु ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","अस्के ओसोय गरिब रांडे आंचाळ वने, इतुळताङ रेंड इचुटाङ कोताङ अद संदुकतगा वाटनदिन ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","पया सबेटोरिन आळो कीसि, “इह केंजाट, नना मीकु सेतेम वेहतह्‌नन, संदुकतगा दान वाटटोर सबेटोरगा, वेल्‍लाङे कोताङ मन्ह्‌ताङ. (ओसो दान वाटटापया वने, ओरगा कोताङ पिसिह्‌ताङ.) मति इद रांडे आंचानगा बाताले इले, तेला मति तना पिसवग़तुह्‌क तासिस मतव, पूरा कोतान दान वाटटा. अदिनेनाह्‌क देवुळता नद्रते, इद रांडे आंचाळिये, सबेटोरिह्‌काय एक्‍वा कोताङ वाटटा!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","अस्के उय्तुर मन्कलोर मंदिरतुन ऊळिसि, इद्रम वळ्ह्‌कसोर मतोर, “इद मंदिरतुन पकाय सोबाताङ बंडाने, देवुळतुह्‌क ईतद कोडटा सामनते सोबा कीतोर,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","अस्के येसु इतोग़, “इंजेके मीट ऊळिह्‌निर, इविस्कनगा बंडाता पोग़ोन बंडा वने मनो आयग़ा. पूरा अर्हचीयनुर, अद्रमता वेला वायग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","पया ओरु, “गूरु! निमा वेहतव पोल्‍लोङ बेस्के आयनुङ? इव पोल्‍लोङ आयनुङ इनजोर, तेना बाताल सीना दिसग़ा?” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","येसु ओरिन इतोग़, “मीक बोग़ाय नाळेह कीयना आयो इनजोर उसरते मन्ह्‌टु. वेल्‍लाटोर नावा पेदिर पोस वासि, नना देवुळ लोहतोनन, इंजेकेन कगो एवता इनजोर इनदनुर. ओरा पेग़्के बह अनमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ईनाह-आनाह नालुङ मूलाङ आस लळय्क आस्ताङ इन्जि, मीक एर्का आयग़ा. अस्के मीट रेयमाट बहा. इव पोल्‍लोङ निटम अद्रम आयनुङे, मति अचोट्के बूम मारो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“ओसो जातता पोग़ोन जाति तेदग़ा, राजेमता पोग़ोन राजेमि तेदग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","बेगा बेगा बूमि मेलियिस गुळ्ह दायग़ा. बेगा इतेक अगा दुकळ आयग़ा. रोगह्‌क पुटनुङ. मोयुदगा रेय वेसनाह पोल्‍लोङ आयनुङ, ओसो बेराङ-बेराङ सीनाङ दिसनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“इव पूरा पोल्‍लोङ आयनामुने, मीट नाक विस्वस कीतेनाह्‌क, लोकुर मीकु पोस पका तिपल कीयनुर. यहुदिराङ पार्तना कीयनव लोह्‌कनगा पोस ओयनुर, जेलते वाटनुर. ओसो बोर बोर मीकु राजालोरगा, गुमसिरगा ओयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","अस्के नावा पोल्‍लोता साक्सि ईयलाह, मीक अग़ दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","मीवा नेयम कीयह्‌पा, मीट अगा बाताल वळ्ह्‌ककोम इनजोर, मुनेन आलिह केमाटु. ");
INSERT INTO mrr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","मीक बाताल वळ्ह्‌कना मन्ह्‌ता, ताना बुदि नना मीक ईकन. मीवा कोटुलतोर मीवा पोल्‍लोतुन केंजतस्के, पोल्‍लो मल्हता पग़वोर आयनुर. मीवा पोल्‍लोतुन जोल वने तोहता पग़वोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“ओसो मीवा तलोग़-तपे, दादाल-तमोग़, जीवातोरु, मीवा गोततोर वने, मीकु विरुदतोरा कयदे पोस ईयनुर, ओसो मियग्डाह उय्तुरिन हव्कनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","मीट नाक विस्वस कीतिर, अदिनेनाह्‌क सबेटोर मीक विरुद कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","मति इद्रम आतेक तेला, मीक बोग़े बूळे कीया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","आक्रि एवनाह दीरा पोस मतेकेन, देवुळ ईयनद पिसमुळ मीक दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ऊळाट, बेस्के सीपय्क येरुसलेम सहरतुन सर्ने कीयनुर, अस्के सहर बूळेम आयना कगो एवता इनजोर पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","अस्के यहुदा पटटे मनवालोर लोकुर पिसकोम इन्जि, मेटानके मकलाह वितिर. सहरता लोप्पा मनवालोर लोकुर, पलते पेसिस वितिर. ओसो नाह्‌कनेके मनवालोर लोकुर, सहरता लोप्पा ओळियमाकिर. ");
INSERT INTO mrr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","बह इतेके देवुळि लोकुरिह्‌क सिक्सा ईयग़ा इनजोर, मुनेन सास्त्रमतगा रासतद मन्ह्‌ता. अव सबे पोल्‍लोङ निटम आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","अव दियाने नेलाङ हव्कतव आस्किह्‌क, ओसो पाल ऊहतनव तलिस्किह्‌क, बेचोटा गोसा आयग़ा. इद देसेमतोर लोकुर पका तिपल आयनुर. देवुळता ओङ ओरा पोग़ोन अरयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","उय्तुर मन्कलोर तल्वर्कने डोलनुर. उय्तुर मन्कलोरिन बार, दुस्राङ देसेह्‌कनगा दोहच ओयनुर. ओसि यहुदि आयवोरा कालम मारनाह्‌जोम, ओरु येरुसलेमतोरिन काल इळ्न तासनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ओसो पोळ्‍दु, नेला, उकाङ, इविस्कनगा सीनाङ दिसनुङ. ओसो इद बूमतगा सम्दुरताङ लच्काङ वायनुङ, अव लच्काङ नेकनदिन केंजिसि, जातिङ-जातिनोर लोकुर पका रेयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","पोग़ोटा बूमतगा मनदनव सबे मेलियनुङ. इद दुनियाते वायनाङ पीळानेनाह्‌क रेयिसि, लोकुरा जीवा पेसिस अतप आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","अस्के कोनि माने-मन्कना नडुम पुटटोनन नना बेरा डीसाते, लावते, मोयुलता संगे वायनदिन, लोकुर ऊळनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","इव पोल्‍लोङ आयलाह बोटनुङ, अस्के मीट निचि, तलाङ तेहच पोग़ोन ऊळाट. बाराह्‌क इतेके देवुळि मीक विळ्सिह कीयनद दिया एरे एवयग़ा,” इनजोर येसु ओरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ओसो येसु ओरिन उंद पोल्‍लो इद्रम वेहतोग़, “गेळाताङ मरान ऊळाटु. ");
INSERT INTO mrr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","अव मरानाङ आकिङ रालिह्‌ताङ अस्के, डोय एरे एवयलाह आता इनजोर मीट पुह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","अद्रमे इंजेक नना वेहतनव पोल्‍लोङ आयनदिन मीट ऊळकिर, अस्के देवुळता राजेम एवयलाह आता इनजोर पुन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","इह केंजाट, नना सेतेम वेहतह्‌नन, इव सबे पोल्‍लोङ बेचानाह करल आयोङ आयनुङ, अचानाह इद पीळतोर बूळेम आयोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","पोग़ोटा बूमि, इळ्ता बूमि मायनुङ, मति नावा पोल्‍लो बेस्केन मायो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“अदिनेनाह्‌क मीटु कल्क उनडना, रिमाते विचर वातप कीयना, ओसो इद दुनियाताङ कबस्कना सीताते मुळ्न्दिस मनमाटु. बह इतेके नना वायनद दियाते, मीक दोम्ह्‌क्ने वदतगा एग़्कतप आयमाकि इनजोर, उसरते मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","अद दिया इद पूरा दुनियाता लोकुरगा, अद्रमलेह्‌काने दोम्ह्‌क्नेन वास अरयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","अदिनेनाह्‌क उसरते मन्जि, इव पूरा आयनव पीळाङ-दोकानाहि पिसकोम इन्जि, अमेसा दीरा पोसि पार्तना कीसोर मन्ह्‌टु. अह कीतेके नना माने-मन्कना नडुम पुटटोनन वायकन अस्के, मीट नावा मुनेह बेदे रेयलेवा नितकिर,” इनजोर येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","पया येसु दिनमे मंदिरतगा काग़्हन्दोग़. अह कीस नुल्पेडुह्‌क बार, सहरताह पेसिस जय्तुन इनदनद मेटातगा अन्जि मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अद्रमे वेल्‍लाटोर लोकुर ओना पोल्‍लोतुन केंजलाहि, सकरिय मंदिरतगा अंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अद्रमे पया ओय्‍पिह केवद पिंडटाङ आरिङ तिनदनद पंडुम एवसोर मता, तान आवना पंडुम वने इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","अद वेलाते पेर्मालोर, सास्त्रमगूरुर, येसुन हव्कलाह विचर कींदुर, मति लोकुरा रेयतेनाह्‌क, बह कीस वेन हव्कना इन्जि, अग़ ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","पया बारा बळयिरग्डाहि ओर्वोग़ यहुदा इस्केर्योत इनवानु, देयह्‌कना मुक्याल आव्रे कीता. ");
INSERT INTO mrr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","अस्के ओग़ु पेर्मालोरिन ओसो मंदिरताङ पह्‌रातोराङ साय्बालोरिन कलियतोग़. कलियिसि बेद्रम येसुन ओरा कयदे पोस ईयना, तेना लोप्पा ओरिन वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","पया ओना पोल्‍लोतुन केंजिसि, ओर गिर्दा आतोर, आसि “इद कबळतेनाह्‌क माट नीक कोताङ ईकोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","अदिनेनाह्‌क ओग़ यहुदाल बोग़े लेवद जागाते, येसुन ओरा कयदे पोस ईयलाहि, अग़ ऊळसोर मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","पया ओय्‍पिह केवद पिंडटाङ आरिङ तिनदनद पंडुमता मुनेता दिया वाता. अस्के (मोसानाङ अडोङवेहतपु,) अद आवना पंडुमते, उंद-उंद लोतुह्‌क उंद-उंद गोरेपियोतुन मोक ईयनद मता. ");
INSERT INTO mrr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","अदिनेनाह्‌क पत्रुनु ओसो योहनिन “मीट अन्ह्‌ट! अन्जि आवना पंडुमता गाटो तयर कीम्ह्‌टु, माट तिनदकल,” इनजोर येसु लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","अस्के पया “माट पंडुमता गाटो बेगा तयर कीकोम गूरु?” इनजोर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ताल्ह्‌कतस्के येसु वेहतोग़, “मीट येरुसलेम सहरते ओळियनेके, बेरा अळ्काते एग़ तवाल ओर्वोग़ मीक कलियनोग़, ओग़ बेद लोतगा दायनोग़, अदे लोतगा मीट वने अन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अतस्के अद लोतोग़ मन्कन इद्रम वेहाटु, ‘नावाङ कग़यवालोरा संगे, आवना पंडुमता गाटो तिनदलाहि, उंद नाटोर रोमनद अरा बेगा मन्ह्‌ता इनजोर, गूरु नीक ताल्ह्‌किह्‌तोग़,’ इनजोर वेहाट. ");
INSERT INTO mrr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","अस्के ओग़ मीकु उंद लोता पोग़ोटा मद्लिते, पूरा तयर कीस तासतद बेरा अरातुन तोहतनोग़. अगान मीट पंडुमता गाटो तयर कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","पया पत्रु ओसो योहन वेर अग्डाह अतस्के, येसु बेद्रम वेहच मतोग़, अद्रमलेह्‌काने सबे मता. मताह्‌कु वेर अगान पया, आवना पंडुमता कुळ्प तयर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","पया पंडुमता गाटो तिनदनद वेला एवतस्के, बळयिरा संगे गाटो तिनदलाह, येसु उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","उदतस्के ओग़ ओरिन इतोग़, “नना तिपल आयनामुने, मीवा संगे इद आवना पंडुमता गाटो तिनदना इनजोर, नावा पका विचर मता. ");
INSERT INTO mrr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","इंजेक नना मीक वेहतह्‌नन, इद पंडुम बेद पोल्‍लोतुन तोहतह्‌ता, अद पोल्‍लो देवुळता राजेमते करल आनाह्‌जोम, इदिन नना वडोन वन आयकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","पया अंगुर जोमा मतद बट्कितुन तेहचि, देवुळतुन जोहर कीतोग़. कीसि, “इदिन तूसिस उन्ह्‌टु” इन्जि कग़यवालोरिह्‌क ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“नना मीक वेहतह्‌नन, नेटग्डाहि बेचानाह देवुळि राजेम कीयनद दिया एव्वो, अचानाह बेदे अंगुर जोमातुन उनोन आयकन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","अद्रमलेह्‌काने येसु आरतुन पोसि, देवुळतुन जोहर कीतोग़. पया तान किळ्हचि, ओरिह्‌क तूसिस ईयह्‌पा, “इद आरि नना मियेनाह्‌क मोक ईयनद नावा मेंदुदा सीना आंदु. नाक सीता कीयलाह, मीट वने आरतुन किळ्हचि तिनदनद कीसोर मन्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","इद्रमलेह्‌का ओर सबेटोर तितापया बट्कितुन तेहचि, “इद बट्किता अंगुर जोमा, नावा नेतुरता सीना आंदु. लोकुरा संगे देवुळ कीयनदु पूना करलतुन, इद नेतुर निल्पिह कीस्ता. मियेनाह्‌क नावा नेतुर नेल पोङग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“इके केंजाट, नाक पोस एवाल मन्कल इंजेक, इगा नावा संगे उदिस तिनदलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","बाराह्‌क इतेके देवुळि मुनेन पोल्‍लो दोहतप लेह्‌का, माने-मन्कना नडुम पुटटोनन नावा हामुर इतेके निटमे मनदग़ा. मति नाक पोस एवाल मन्कह्‌क मात्रम, बेचोटा गोसा आयग़ा!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ओना पोल्‍लोतुन केंजतस्के, “मावा नडुम अद्रम केवाल बोग़ मनदनोग़ रा!” इनजोर कग़यवालोर तमतमाय वळ्ह्‌क बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","पया कग़यवालोरु “मयग्डाहि इंजेक बोग़ बेरोग़ आयनोग़?” इनजोर ओरा नडुमि कट्ला पुटटा. ");
INSERT INTO mrr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","अस्के येसु ओरिन इतोग़, “देवुळतुन पुनवोरा राजालोरु लोकुरा पोग़ोन तमा अदिकर ताकिह कीस्तोर, तेला मति ‘माट ओरा बेस साय्ता केवालोरोम’ इनजोर इद्रम इन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","मति मीटु ओरा लेह्‌का कीयनद आयो. मियग्डाहि बोग़ बेरोग़ मन्ह्‌तोग़, ओग़ सबेटोरिह्‌क उड्लोना लेह्‌का आयना गावले. ओसो बोग़ मुक्याल मन्ह्‌तोग़, ओग़ु साकुर केवाना लेह्‌का आयना गावले. ");
INSERT INTO mrr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","बेरोग़ बोग़ आंदोग़, गाटो तिनदलाह उदतोग़ुया? बार गाटो तूसवाला? आयो! गाटो तिनदलाह उदतोग़े बेरोग़ आंदोग़. मति नना इंजेके मीवा नडुम सेवा केवानन मह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","मीट इतेके नावा तिपलते वने, नावा तोळ मतोरिर आंदिर. ");
INSERT INTO mrr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","बेद्रम नावा बाबाल राजेम कीयलाह अदिकर नाक ईतोग़, अद्रमे नना वने मीकु अद्रमता अदिकर ईय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","इतेके मीट वने नावा राजेमता मेजातगा उदिस तिनदकिर-उनडकिर, ओसो राजकुर्सिनगा उदिसि, इस्रयेलतोर बारा कूळिनोरा नेयम कीकिर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ओसो येसुसामि सिमोन पत्रुन इतोग़, “सिमोन! सिमोन! इके केंजा रा! वंजिनाङ पिंडयान अल्सतप लेह्‌का, देयह्‌कना मुक्याल मीक सबेटोरिन पट ऊळलाह, देवुळतुन ताल्ह्‌कता. ");
INSERT INTO mrr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","अदिह्‌क निमा विस्वसतुन विळ्सना आयो इनजोर, नना नियेनाह्‌क पार्तना कीतन. मति निमा ओसोवने विस्वसते मलतस्के, नीवा गोततोरा विस्वसतुन बेर्सिह कीसीम,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","अस्के सिमोन पत्रु, “सामि! नना नीवा संगे जेल दायलाह, ओसो डोललाह वने तयर मह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","येसु ओन इतोग़, “पत्रु! नना नीक वेहतह्‌नन, नेंड नग़्का तलाकोग़ कूसनामुने, निमा येसुन पुनोन इनजोर, मूंड मल्काङ इनदकिन डा!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","पया येसु तनाङ कग़यवालोरिन इतोग़, “नना उंद मल्का मीकु कोताङ पोयवा, जोर्का पोयवा, एल्पुस्क पोयवा, लोहच मतन. अस्के मीकु बातालाय कमि अर्स मताया?” इनजोर ताल्ह्‌कतोग़. अस्के ओरु, “आयो गूरु! माक बाताले कमि अरवो,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","पया ओरिन इतोग़, “(अस्के लोकुर नाक बेस ऊळिंदुर, मति इंजेक नाक विरुद कीस्तोर.) अदिह्‌क इंजेके बोनगा कोताङ मन्ह्‌ताङ ओग़ पोयेग़, ओसो जोर्का वने पोयेग़. ओसो बोनगा तल्वर कसेग़ इले, ओग़ तनाङ गेंदङ वमिसाय मति, अद तल्वर कसेटुन असेग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","बाराह्‌क इतेके नना मीक वेहतह्‌नन, देवुळता सास्त्रमतगा रासतद पोल्‍लो नाक आयग़ाये. इतेके, ओग़ कसुरतोरा संगे कलियतोग़. इद नावा लोप्पा रासतद पोल्‍लो करल आयनदे. सास्त्रमते नावा लोप्पा रासतव कतम पोल्‍लोङ इंजेके करल आयलाह आताङ,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","अस्के ओरु, “सामि! ऊळा, इव इगा रेंड तल्वर कसेह्‌क मन्ह्‌ताङ,” इतोर. इतस्के येसु, “आयग़ा, मनि,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","पया अद लोतग्डाह ओग़ पेसिसि, तना अल्वट मतपु, जय्तुन मरानाङ मेटातगा अतोग़. ओना संगे कग़यवालोर वने अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","अद जागातगा एवतस्के येसु ओरिनु, “देयह्‌कना मुक्याल मीक पट ऊळमाकि इनजोर पार्तना कीम्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","पया ओरग्डाह उचुन जेक अन्जि, मिंडाङ कोटिस देवुळतुन इद्रम पार्तना कीयलाह आतोग़: ");
INSERT INTO mrr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ए बाबा! नीवा विचर मतेके, इद नावा पोग़ोन वायनद गोसातुन जेक कीमु. मति इद नावा विचर मतप आयो, नीवा विचर बह मन्ह्‌ता, अद्रमे आयि,” इतोग़.  ");
INSERT INTO mrr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","अस्के पोग़ोटाहि उंद देवतुल अगा वासि ओन्क लाव ईंदु. ");
INSERT INTO mrr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","येसु पका दुकमते निंदिसि, जीवा काल्सतप आसि, पार्तना कींदोग़. अद्रम पार्तना कीनेके, ओना एपुरि नेतुरताङ डोंगेना लेह्‌का नेल अर्न्दु. ");
INSERT INTO mrr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ओना पार्तना मारतस्के, तेदिस कग़यवालोरेके वास ऊळतोग़. ऊळनेके ओर वने आलिह कीस आलिह कीस, बागिसि उंजिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अस्के ओरिन इतोग़, “मीट बाराह्‌क उंजलाह आतिर? अले तेदाट! देयह्‌कना मुक्याल मीक पट ऊळनद आयो इन्जि पार्तना कीम्ह्‌टु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","इद्रम कग़यवालोरिन येसु वेहचोरेन मतोग़, अचोटेने अगा गोह्‌डमेंड लोकुर वातोर. ओर गोह्‌डमेंड लोकुरिन यहुदाल ततोग़ (वेग़ येसुना बारा बळयिरग्डाहि ओर्वोग़ मतोग़). तचि येसुन लोंडलाहि यहुदाल अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","अस्के “यहुदा, बह निमा माने-मन्कना नडुम पुटटोनन नाकु, इद्रम लोंडिसनेह्‌क पोस ईयलाह आतिना?” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","पया येसुन पोयतनदिन ऊळिसि, कग़यवालोरु “सामि, बह माट तल्वर कसेह्‌कने लळय कीकोमा?” इनजोर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अह कीसि कग़यवालोरग्डाहि ओर्वोग़, तना तल्वर कसेटुन तेंडिसि, मोदुल पेर्माना ओर्युलतोना तिनळ बाजेता केवदुन पोडोह देगनाह ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","अस्के येसु “इंजेके अचोने आयग़ा, मनि!” इनजोर इतोग़. इन्जि ओना देगता केवदुन तुंडिह कीसि, ओन बेस कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","पया अगा येसुन पोयतकोम इन्जि वास मतोर पेर्मालोरिन, मंदिरता साय्बालोरिन ओसो यहुदिराङ पेदल्किन येसु इद्रम इतोग़, “मीटु कलेन पोयतलाह वातप लेह्‌का, तल्वर कसेह्‌कु, टेंगाङ पोस नाक पोयतलाह वातिर अयो! ");
INSERT INTO mrr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","दिनम मीवा संगे नना मंदिरतगान मंदन अस्के, नाक पोयविर. मति इद मीवा कगो आंदु, इंजेक ईकळता राजेम ताकिह्‌ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","पया ओरु येसुन पोसि अग्डाह अतोर, अन्जि मोदुल पेर्माना लोन ओतोर. अस्के पत्रु वने उचुन जेक मन्जि, ओरा पयाह पयाह वायलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","मोदुल पेर्माना लोता मुनेह, रेसातगा किस मासिस, ओर अगान उदिस मतोर. अस्के पत्रु वने ओरगान अन्जि उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","अद किसता कचुल उदताह्‌कु, किस वेह्‌चते उंद ओर्युल पिलातुह्‌क पत्रु दिसतोग़. अस्के अद पिला पत्रुनेके ऊळिसि, “वेग़ मन्कल वने येसुनाय संगे मतोग़,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","मति पत्रु “नना ओन पुनोन एलो,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","गळ्क मनेके, ओसो ओर्वोग़ मन्कल पत्रुन ऊळतोग़. ऊळिसि “निमा वने ओनाय मन्कनिन अय रा!” इतोग़. मति पत्रु, “आयो दादा! नना ओना मन्कनन आयोन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ओसोवने जोक-जोक गंटामेटा पया, “वेग़ इतेके निटमे रा, ओनाय संग मतोग़! गालिल पटटोना लेह्‌का वळ्ह्‌किह्‌तोग़,” इनजोर ओसो ओर्वोग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","अस्के वने पत्रु इतोग़, “निमा बाताल वेहतलाह आतिनो दादा, नना इतेके ओन मुर्तिय पुनोन,” इनजोर वळ्ह्‌कनेकेन तलाकोग़ कूसता. ");
INSERT INTO mrr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","पया येसुसामि पत्रुनेके मिळ्न्दिस ऊळतोग़. अस्के कोनि “नेंडे नग़्का तलाकोग़ कूसनामुने, निमा मूंड मल्काङ येसुन पुनोन, इद्रम इनदकिन,” इनजोर येसुसामि मुने वेहच मतद पोल्‍लोतुन पत्रु सीता कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अस्के पत्रु पलतेक पेसिसि पका अळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","येसुन पोस तासतोर मन्कलोर, ओना कदर रेहतना ओसो पका नल्हतना कींदुर. ");
INSERT INTO mrr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ओनाङ कोंडान गेंदे मुर्वेते दोहचि, नल्हचोरेन “अले! इंजेक देवुळता जीवाते वेहा रा! नीक बोग़ नल्हतोग़?” इनजोर पास्किंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ओसोवन ओरु येसुना कदर रेहतलाहि वेल्‍लाङे पोल्‍लोङ इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","पया इमा दिया सकरि यहुदिराङ पेदल्कु कलियिसि पंच उदतोर; ओरगा पेर्मालोर ओसो सास्त्रमगूरुर मतोर. पंच उदतस्के, येसुन ओरा मुनेह ओतोर. ");
INSERT INTO mrr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","अगा ओतस्के, तग्वाङ केवालोर येसुन ताल्ह्‌कतोर, “अल रा! इंजेक माक वेहा, निमान देवुळ लोहतोग़ पिसिह केवाल किर्स्तुनिना?” इनजोर इतोर. अस्के ओग़ ओरिन इतोग़, “नना मीक वेहतेक वने, मीट मुर्तिय विस्वस केविर आयकिर. ");
INSERT INTO mrr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ओसो नना मीक ताल्ह्‌कतेक वने, अद पोल्‍लो मीट मल्हविर आयकिर. ");
INSERT INTO mrr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","मति इंजेके गळ्क मनेके, माने-मन्कना नडुम पुटटोनन नना डीसाता देवुळता तिनळ बाजे उदकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","अस्के पंचता सबेटोर लोकुर “अह इतेक पया निमा देवुळता मग़निना?” इनजोर ताल्ह्‌कतोर. ताल्ह्‌कतस्के “मीट इह्‌निर अद निटमे,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","पया पंचता लोकुर इतोर, “इंजेके माक साक्सिङ-गवय्क बाराह्‌क गावले रा? वेग़ तनाय तोडटे वेहतदिन, माट केंजतल इसि!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","पया सबेटोर लोकुर पंचतग्डाह येसुन पिलाति इनवाल गुमसिनगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ओसि येसुना पोग़ोन इद्रम तप तोहता बोटटोर इतेके, “वेग़ मावा यहुदि जाततोरिन लेवाङ-मताङ काग़्हचि, लेसिह कीस्तोग़. ओसो कय्सर राजाह्‌क सिद्‌वा एमाटु इनजोर, लोकुरिन तग़्हतह्‌तोग़. वेग़ तन्के देवुळ लोहतोग़ पिसिह केवाल राजानन इनजोर वेहतह्‌तोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पया पिलाति येसुन, “बह निमा यहुदिरा राजानिना?” इनजोर ताल्ह्‌कतोग़. पया येसु ओनु, “निमा इह्‌निन अहे” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","अस्के पिलाति पेर्मालोरिन ओसो लोकुरिन, “वेग़ मन्कनगा बाताले कसुर नाक दिसो,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","मति मुडा लोकुर पका कैंगम आसोर कयर कींदुर, “वेग़ु गालिल पटटग्डाह इतेके, मावोर यहुदिर मनदनद सबे बूमतगा, लोकुरिन तनाङ काग़्हच लेसिह कीसोर, इगा एवनाह वातोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","पया पिलाति इदिन केंजिसि, “वेग़ मन्कल गालिल पटटोग़ा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","इंजेके गालिल पटटुन ताकिह केवाल एरोद अंतिपस राजाल, अव दियाने येरुसलेम सहरतगान वास मतोग़. येसु गालिल पटटोग़ आंदोग़ इनजोर पिलाति पुतस्के, येसुन ओनगा ओयलाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","एरोद अंतिपस येसुना लोप्पा मुनेन केंजिस मतोग़. अदिनेनाह्‌क ओग़ वेल्‍लाङे दियानाहि, येसुन ऊळलाह विचर कीस मतोग़. ओसो येसुना कयदे बेदाय बामिह कीयनद सीना ऊळलाह, आसा कीसोर मतोग़. अदिह्‌क ओग़ येसुन ऊळिस, पका गिर्दा आतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","पया ओग़ु येसुन वेल्‍लाङे पोल्‍लोङ ताल्ह्‌कतोग़, मति येसु तनेनाह ओन बाताले पोल्‍लो मल्होग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","पेर्मालोर ओसो सास्त्रमगूरुर अगा निचि, तम्क विचर वातप येसुना पोग़ोन कसुर्क वाटिंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","पया एरोद अंतिपस वने तनाङ सीपय्कना संगे, येसुन पास्किस कवतोग़. ओन राजान कीतपु, मिळ्स्कनद जगा केग़्‍पिह कीसि, पिलाति गुमसिनेकेन मल्हच ओया वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","अदे दिया कोनि एरोद अंतिपस ओसो पिलाति, वेर इर्वुर गूनम आतोर. ताना मुने इतेके ओर ओर्विह्‌क-ओर्वोग़ विरुदतेन मंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पया पिलाति पेर्मालोरिन, यहुदिराङ मुक्यालोरिन ओसो लोकुरिन केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","केयिसि इद्रम इतोग़, “लोकुरिन लेवाङ-मताङ पोल्‍लोङ काग़्हचि, लेसिह केवाल आंदोग़ इनजोर, मीट वेग़ येसुन इगा ततिर. इंजेक नना मीवा मुनेह वेन पर्ह्‌किस ऊळतन. मीट वेना पोग़ोन बेव पोल्‍लोना कसुर्क वाटटिर, अव पोल्‍लोनाङ कसुर्क इतेके, वेना लोप्पा नाक बाताङे दिसोङ. ");
INSERT INTO mrr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ओसो एरोद अंतिपसिह्‌क वने, वेना बाताले कसुर दिसो, अदिनेनाह्‌क ओग़ु वेन ओसोवने मयगा मल्स लोहचीतोग़. वेन्क हामुरता सिक्सा दोर्कना, इद्रम वेग़ बाताले कसुर केवोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","अदिनेनाह्‌क वेन जूताते नल्हता वेहचि विळ्सिस ईय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","अस्के सबेटोर लोकुर कलियिसि, “वेग़ येसुन हव्कलाह वेहा! मयेनाह्‌क बरबसिन विळ्सा,” इनजोर रोदा पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(बरबसि इनवाल इतेके सहरता मन्कलोरिन सर्करता विरुदते ओङ तग़्हच मतोग़, ओसो उय्तुरिन हव्किस वने मतोग़. अदिनेनाह्‌क ओन जेलते वाटिस मतोर.) ");
INSERT INTO mrr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","येसुन विळ्सिस ईयलाह, पिलाति ओसो उंद मल्का मुडा लोकुरिन वेहच ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","मति ओरु, “ओन हव्कनागुटातगा मोल्‍लाङ कोटिस हव्काट, हव्कनागुटातगा हव्काट!” इनजोर पका रोदा पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","अस्के पिलाति मुचा केपा ओसोवने लोकुरिन इतोग़, “बाराह्‌कु? वेग़ बाताल कसुर कीतोग़? वेन्क हामुरता सिक्सा ईयना लेह्‌का, वेनगा नाक बाताले कसुर दोर्को. अदिनेनाह्‌क वेन जूताते नल्हता वेहच विळ्सिस ईय्ह्‌नन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","मति मुडा लोकुर, “येसुन हव्कनागुटातगा वेळ्हा,” इनजोर पका केयसोर रोदा पोयतोर. अद्रमे ओरा केयनद पका वीळता. ");
INSERT INTO mrr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","अदिनेनाह्‌क पिलाति पया, मुडा लोकुर ताल्ह्‌कतपे आयि इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","पया जेलते मतोग़ सर्करता विरुद मनवाल हव्के मन्कनु, लोकुर ताल्ह्‌कताह्‌क, ओन विळ्सिस ईया वेहतोग़. मति इंजेक तम्क विचर वातप बहे कीयिर इनजोर, लोकुरा कयदे येसुन ईसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","अस्के पया सीपय्क येसुन तना हव्कनागुटा कांजिह कीसि, (पिलातिना लोताहि मोल्‍लाङ कोटना जागातगा) ओयलाह आतोर. नडुम अग़दे येसुह्‌कु हव्कनागुटा कांजलाह दीरा वावो. अचोटेने कुरेने सहरतोग़ सिमोन इनवाल, येरुसलेम सहरते ओळियलाह आस मतोग़. अस्के सीपय्क ओन पोसि, हव्कनागुटा कांजिस, येसुना पेग़्के-पेग़्के दायलाह बीगर पोग़्सिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","अस्के वेल्‍लाय गोह्‌डमेंड लोकुर येसुना पेग़्के अनजोर मतोर. अद वेलाते अगा उचुक आस्कु ओनेनाह अर्युल पासोर अळ्न्दुङ. ");
INSERT INTO mrr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","अस्के येसु अव आस्कनके मिळ्न्दिसि, “ए येरुसलेमताङ आस्कनिर! नयेनाह्‌क अळमाटु, मति मियेनाह्‌क ओसो मीवाङ पिलाङ-पेकोरेनाह्‌क अळ्म्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","बाराह्‌क इतेके इद्रमताङ तिपलताङ दियाङ वायना मन्ह्‌ताङ, अव दियाने ‘वंजो मनदनद आंचाळ देय्वाता, बेस्केने नेलाङ हव्कवद आंचाळ देय्वाता, बेस्केन पाल ऊहवद आंचाळ देय्वाता,’ इनजोर लोकुर इनदनुर. ");
INSERT INTO mrr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ओसो ‘मावा पोग़ोन अर्ह्‌म्टु’ इनजोर मेटान इनदनुर, ‘माक मिसाटु’ इनजोर गुड्रान इनदनुर. ");
INSERT INTO mrr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","वेरु नावा लेह्‌काडोग़ कसुरलेवोन इद्रम कीस्तोर इतेके, मीट कसुर मनवालोरिन बेद्रम केमुळ आयग़ा!” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","अद्रमे येसुना संगे इर्वुर डाकुरिन वने, हामुरता सिक्सा ईयलाह ओतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","पया ओर, “तला-टाप्रा” इनदनद जागातगा एवतोर. एव्सि येसुन हव्कनागुटातगा मोल्‍लाङ कोटिसि वेळ्हतोर. ओना संगे इर्वुर डाकुरिन वने ओर्विन तिनळ बाजे, ओर्विन बार ओना दावळ बाजे वेळ्हतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","अस्के “ए बाबा! वेर नाक हव्कवालोर लोकुर बाताल कीस्तोर, अदिन पुनोर, वेरिन मापि कीमु!” इनजोर देवुळतुन येसु पार्तना कीतोग़. पया सीपय्कु सीटिङ वाटिसि, येसुनाङ गेंदेङ तूसतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","अगा मुडा लोकुर निचि मोल्‍लाङ कोटनदिन ऊळसोर मतोर. यहुदिराङ मुक्यालोर येसुन पास्कसोर इद्रम इतोर, “वेग़ दुस्रोरिन विळ्सिह कीतोग़, वेग़ देवुळ आचतोग़ पिसिह केवाल किर्स्तु आंदोग़ इतेके, तनाय तन्क विळ्सिह कीयेग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","सीपय्क वने वासि, ओयतद जोमा ओन्क ऊहचि, “निमा यहुदिरा राजानिन आंदिन इतेके, नीवा जीवातुन निमान पिसिह कीम!” इनजोर पास्कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ओसो “वेग़ यहुदिरा राजाल आंदोग़” इनजोर बलाते रासिसि, ओना तलापोग़ोन गुटातगा वेळ्हच मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","येसुना संगे मोल्‍लाङ कोटिस वेळ्हच मतोरग्डाह, ओर्वोग़ डाकु वने, “निमा देवुळ लोहतोग़ पिसिह केवाल किर्स्तुनिन इतेके, नीक ओसो माक वने पिसिह कीम,” इनजोर येसुन पास्कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","मति दुस्रोग़ डाकु बार अद्रम इतोन दगा ईसि, “वेन्क दोर्कतद सिक्सा नीक वने दोर्कता. मति निमा देवुळतुह्‌क वने बह रेयविन रा? ");
INSERT INTO mrr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","माट इतेक लाग्वा कबळ कीताह्‌कु, माक काय्दा मतपु, बराबर सिक्सा दोर्कता. मति वेग़ इतेके बाताले कसुर केवोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ओसो येसुन इतोग़, “ए येसु! निमा राजाल आतस्के, नाक सीता कीमु.” ");
INSERT INTO mrr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","इतस्के येसु ओनु, “केंजा, नना नीक सेतेम वेहतह्‌नन, नेंडे निमा नावा संगे सिंगर्दीपतगा मनदकिन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","अस्के पियलि नेक नितग्डाह इतेके, मूंड एगनाह्‌जोम पूरा बूममेंड ईकळ आता. ");
INSERT INTO mrr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","पोळ्‍दता वेह्‌च वने दिसो. अस्के येरुसलेमतग्डा मंदिरता लोप्पा मतद, सबेट्क पवित्र गूडटा अग़दगा, अडह कीस मतद गेंदे रेंड तुक्ळेङ आनाह पग़्क वितता. ");
INSERT INTO mrr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अस्के येसु, “ए बाबा! नावा जीवातुन नीवा कयदे ईय्ह्‌नन,” इनजोर जोरते केयिसि हातोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","पया सीपय्कना दरोगाल अगा बह आता, तान ऊळिसि, “वेग़ मन्कल निटमे सेतेमतोग़ मतोग़!” इनजोर देवुळतुन जोहर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ओसो अगा ऊळलाह वातोर लोकुर, बाताल बाताल आता, अदिन पूरा ऊळिसि, अर्युल पासोर मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","मति येसुन पुतोरु, ओसो ओना संगे गालिल पटटाह वातव आस्कु जेक निचि, अगा बह आंदु, अदिन सबे ऊळसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","पया अगा यहुदा पटटा अरिमतेया नाटेनोग़, योसेप इनवाल ओर्वोग़ मन्कल मतोग़; ओग़ु यहुदिराङ तग्वाङ केवालोरग्डाह ओर्वोग़ मतोग़. ओसो तग्वाङ केवालोर येसुना नेयम कीतस्के, अगा तोळ आयोग़. बह इतेके ओग़ बेसतोग़ सेतेम मन्कल मतोग़. देवुळि बेस्के मावा इस्रयेल देसेमते तना राजेम निल्पिह कीयग़ा इनजोर केपिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ओग़े योसेप पिलातिनगा अन्जि, येसुना सेत्तातुन गति कीय्ह्‌नन इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ताल्ह्‌किस सेत्तातुन हव्कनागुटातग्डाह रेहतोर. पया वेल्‍ला दाराता हामुर-गेंदेते सेत्तातुन ऊर्हतोर. अह कीसि बेरा आद बंडातगा तर्विस मतदु, मुने बोने पोहवद पूना गुमयातगा, येसुना सेत्तातुन तासतोर. ");
INSERT INTO mrr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","अद दिया वारमता पोल्वादियातेनाह्‌क(इतेके सनारमतेनाह्‌क) तयर आयनद दिया मता. ओसो गय्क इतेके पोळ्‍द अनजोरे, पोल्वादिया सुरु आयना मता. ");
INSERT INTO mrr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","पया गालिल पटटाहि येसुना संगे वातव आस्कु, योसेप सेत्तातुन ओयह्‌पा, गुमयातुन ऊळलाह अताङ. ओसो सेत्तातुन बेद्रम तासतोर, अदिन वने ऊळताङ. ");
INSERT INTO mrr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","पया अव आस्कु अग्डाह मल्स अन्जि, बेस गब एग़्स्कनव मराना पिंडि ओसो अतर्नेय सेत्तातगा वाटलाह, पर्ह्‌किस तयर कीताङ. पया पोळ्‍द अताह्‌कु, वारमता पोल्वादिया इनजोरे, मोसानाङ अडोङ वेहतपु, लोने रोमताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पया वारमता मुनेता दिया (इतेके ऐतारम दियाते), सकर पिङपङ आयह्‌पा, येसुन गति कीयह्‌पा अन्ज मतव आस्कु, तमाय पर्ह्‌किस तयर कीस मतद अतर्नेय पोसि, येसुन तासतद गुमयातगा अताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","अगा एवतस्के, गुमयाता अग़दगा तिळ्ह्‌प कीस मतद बंडा, अबर गूळिस मतदिन ऊळताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","पया अव आस्कु लोप्पा ओळियिस ऊळताङ, अस्के अविस्किह्‌क अगा येसुसामिना सेत्ता दिसो. ");
INSERT INTO mrr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","दिसवाह्‌कु अव आस्कु एक्बेक आताङ. अस्के दोम्ह्‌क्नेन तिर्मिळ्स्कनाङ जगाङ केग़तोर इर्वुर मन्कलोर, अविस्कनगा वास नितोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","अस्के अव आस्कु पका रेयिसि, ओरा मुनेह तला वग़्हताङ. पया ओरु, “जीवात मनवाल मन्कन, डोलतोरगा मीट बाराह्‌क पर्ह्‌कलाह आतिर? ");
INSERT INTO mrr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","ओग़ इगा इलेग़, ओग़ जीवा अरतोग़! मीवा संगे गालिल पटटगा मतस्के, ‘माने-मन्कना नडुम पुटटोनन नाकु, पापि मन्कलोरा कयदे पोस ईयनुर. पया ओर नाकु हव्कनागुटातगा मोल्‍लाङ कोटिस हव्कनुर, मति नना मूंड दियाने जीवा अरयकन, इव सबे करल आयनुङे,’ इनजोर मीक वेहच मतोग़, सीता मन्ह्‌ताया?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","अस्के अव आस्किह्‌कु, येसु मुने वेहतव पोल्‍लोङ सीता वाताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","पया अव आस्कु गुमयातग्डाह मल्स अन्जि, अक्रा बळयिरिन ओसो दुस्रोर कग़यवालोरिन इव पूरा पोल्‍लोन वेहताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","वेहतनव आस्क बेव इतेके, मग्डला नाटेना मरियाल, योहना, याकुबना तलोग़ मरियाल, ओसो उचुक दुस्राङ आस्क मताङ. इवे बळयिरिन इव पोल्‍लोङ वेहताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","मति अविस्कना पोल्‍लोतुन, बळयिर विस्वस केवोर. “इव आस्क उगसे वेहतह्‌ताङ रा!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","मति पत्रु अग्डाह तेदिस, गुमयातगा एवनाह वित वातोग़. पया लोप्पा ओल्‍लिस ऊळनेके, अगा सिरप (येसुना सेत्तातुन ऊर्हच मतव) गेंदेङ बहता अहे मताङ. अदिन ऊळिस इगा बह आता इनजोर एक्बेक आसि, ओग़ लोन मल्स अतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","अदे दिया येसुनाङ कग़यवालोरग्डाह इर्वुर, इमावुस इनदनद नाटे अनजोर मतोर. अद नाग़ येरुसलेम सहरतग्डाहि जोक-जोक अक्रा किलोमिटर मता. ");
INSERT INTO mrr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","अस्के येरुसलेमतगा आतव सबे पोल्‍लोन ओर इर्वुर वळ्ह्‌कसोर-वळ्ह्‌कसोर अनजोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ओर इद्रम तमतमाय वळ्ह्‌कसोर दायह्‌पा, येसु कुदि दोम्ह्‌क्नेन ओरगा वासि, ओरा संगे ताकलाह बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ताकनेके येसुन वेर पुनदना आयो इन्जि, ओर इर्वुरिन आसि मुर्तिय पुनवाह कीतद मता. ");
INSERT INTO mrr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","पया येसु ओरिनु, “मीट इर्विर अनजोर-अनजोर बेद पोल्‍लोतुन वळ्ह्‌कलाह आतिर रा?” इनजोर ताल्ह्‌कतोग़. अस्के ओर दुकमते निंदिस अगान नितोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","निचि “निने, अने येरुसलेमतगा आतव पोल्‍लोन पंडुमतुह्‌क वातोरु सबेटोर पुतोर इतेके, निमा वग़ोनिने बह पुनविन रा?” इनजोर ओर इर्वुरग्डाह किलियुपा इनवाल इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","अस्के येसु “बेव पोल्‍लोङ रा?” इनजोर ताल्ह्‌कतोग़. ताल्ह्‌कतस्के ओर इद्रम वेहता बोटटोर, “नासरेत नाटेनोग़ येसुना पोल्‍लो आंदु रा! ओग़ बाताल कींदोग़, बाताल वेहन्दोग़, अव पूरा देवुळता लावताङ मताङ. ओग़ देवुळता कबुरतोग़ मतोग़. लोकुर वने ओन बेसतोग़ इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","मति मावाङ पेर्मालोरु, ओन्क हामुरता सिक्सा ईयेग़ इनजोर, पिलाति गुमसिना कयदे पोस ईतोर. इद्रम कीस लोकुर ओन हव्कनागुटातगा मोल्‍लाङ कोटिस हव्कतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","मति ओग़े मावा इस्रयेल जाततोरिन कोंटेतोरा कयदाहि विळ्सिह कीयनोग़ इनजोर, माट आसा कीस मतोम. “इंजेके इव सबे पोल्‍लोङ अनेटस्केन आताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ओसो नेंडु मयग्डाङ उचुक आस्क वने, माक बामनाह कीताङ. अव नेंड सकरिय सेत्ता तासतद गुमयातगा अन्ज मताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","मति अगा येसुना सेत्ता अविस्किह्‌क दोर्को. दोर्कवाह्‌क अव मल्स वासि, ‘माट देवतुल्किन ऊळतोम. येसु जीवा अरतोग़ इनजोर, अव माक वेहताङ,’ इनजोर मयग्डाङ आस्क माक वेहताङ. ");
INSERT INTO mrr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","अविस्कना पोल्‍लो केंजिसि, मावा तोळतोर उय्तुर गुमयातगा अन्ज ऊळतोर. अस्के अव आस्क बेद्रम वेहच मताङ, अद्रमे मता, येसु इतेक ओरिह्‌क दिसोग़!” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","पया येसु इतोग़, “मीट मुर्तिय बुदलेवोरिर आंदिर! देवुळता कबुरतोर वेल्‍लाय मुने वेहतव पोल्‍लोन विस्वस कीयलाह, बह विचर केविर? ");
INSERT INTO mrr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","देवुळ लोहवाल पिसिह केवाल किर्स्तुह्‌कु पका तिपल आसि पया, बेरा डीसाते देवुळतगा दाया पोयोया?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","इद्रमलेह्‌का मोसानाङ अडोनगा, देवुळता कबुरतोराङ पुस्तकिनगा, अहे पूरा देवुळता सास्त्रमते बेगा बेगा तना लोप्पा रासतव पोल्‍लोङ मताङ, अव सबे पोल्‍लोन ओरिह्‌क तेळियिह कीस वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","अद्रमे पया ओर तम्क दायना मतद नाटेनगा एवतोर. अस्के येसु अद नाटे रोमवप लेह्‌का ओरिह्‌क दल्गता. ");
INSERT INTO mrr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","अदिनेनाह्‌क ओरु, “इंजेके पोळ्‍द अता, नेटुह्‌क मयगान रोमा दादा” इनजोर, ओन गोंडगोंड आतोर. अस्के येसु ओरगान रोमतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","पया ओग़ ओरा संगे जावा उनडलाह उदतोग़. अस्के ओग़ आरतुन तेहचि, देवुळतुन जोहर कीतोग़. कीसि तान किळ्हच ओरिह्‌क ईयलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ईनेकेन ओर इर्वुराङ कोंडाङ पङ्ने आतप लेह्‌का आताङ, अस्के वेग़ येसु आंदोग़ इनजोर पुतोर. मति येसु ओरिह्‌क दिसवाह, चट्‌ने मायतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","पया ओर तमतमाय, “ओग़ मावा संगे वासोर अग़दे गोटिङ कीतोग़, ओसो देवुळता सास्त्रमताङ पोल्‍लोन तेळियिह कीतोग़. अस्के ओना पोल्‍लो मावा जीवातुह्‌क बेचोन मिटस दल्गता, आयोया?” इनजोर ओर्विह्‌क-ओर्वोग़ इतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","पया ओर अग्डाह पोर्क तेदिस, ओसोवने येरुसलेमते मल्स अतोर. अतस्के अगा अक्रा बळयिर ओसो कग़यवालोर जमा आसि, “निटमे रा! येसुसामि जीवा अरतोग़. ओग़ सिमोन पत्रुह्‌क दिसतोग़!” इनजोर वळ्ह्‌कनेकेन, ओर इर्वुर अगा एवतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","अस्के ओर इर्वुर वने अग़दे अनेके बह आता, ओसो येसु आरतुन किळ्हचि ओरिह्‌क ईयह्‌पा, ओन बह पुतोर, अदिन ओर सबेटोरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ओर इर्वुर इव पोल्‍लोङ सबेटोरिन वेहनेकेन, येसु कुदि ओरा नडुम वास नितोग़. निचि “मीक सुकम दोर्कि, रेयमाटु!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","अस्के ओर दिर मिळ्ह्‌किसि, माट येसुना मिळ्सुमतुन ऊळिह्‌नला बहु, इनजोर बामिस रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","अस्के येसु ओरिन इतोग़, “मीट इचोन बाराह्‌क रेयतिर? नावा लोप्पा बाराह्‌क उन्क-मन्क आय्ह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","नावाङ कय्किन-काल्किन ऊळाट! नाक बोयाटु! इद ऊळाटु नना येसुनने, मिळ्सुमतुह्‌क इद्रम अविङ-बोकाङ इलेङ, मति नाक मन्ह्‌ताङ!” ");
INSERT INTO mrr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","इनजोर वेहचि येसु तनाङ कय्किन-काल्किन ओरिह्‌क तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","अस्के ओर अचोन गिर्दा आसि बामतोर इतेके, मावा मुनेह येसुये निच मन्ह्‌तोग़ इन्जि, इंका सेतेम पोयोर. अद्रम आनेके येसु ओरिनु, “मियगा बातालाय तिनदलाह मन्ह्‌ताया?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","अस्के ओरु बोळ्सतद मीन-मुका ओन्क ईतोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ईतस्के ओर ऊळनाहे, अद मुकातुन येसु तितोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","तिन्जि ओरिन इद्रम इतोग़, “इव पोल्‍लोङ बेव इतेके नाक हव्कनामुने मीवा संगे मतन, अस्के मीक वेहतव आंदुङ. मोसानाङ अडोना सास्त्रमतगा, देवुळता कबुरतोराङ पुस्तकिनगा, ओसो देवुळताङ पाटानगा, नावा लोप्पा रासतव सबे पोल्‍लोङ करल आयनद मता. अदिनेनाह्‌क इद्रम आता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","पया देवुळता पवित्र सास्त्रमताङ पोल्‍लोन पुनदलाह, येसु ओरिह्‌क बुद ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ओसो इद्रम इतोग़, “सास्त्रमतगा इद्रम रासतद मन्ह्‌ता इतेके: देवुळ लोहवाल पिसिह केवाल किर्स्तु, तिपल आस डोलनोग़. ओसो मूंड दियाने ओसोवन जीवा अरयनोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अदिनेनाह्‌क पापमता मापि दोर्कना इतेके, पापमता अग़दाहि मलयना. इद कबुरतुन किर्स्तुना अदिकरते येरुसलेमतग्डाह सुरु कीसि, पूरा बूममेंड पोकुर केमुळ आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","इव सबे पोल्‍लोना मीट साक्सितोरिर मह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ओसो नावा देवुळबाबाल बाताल ईकन इन्जि पोल्‍लो विळ्सिस मतोग़, अद पवित्र जीवातुन नना मियगा लोहतकन. बेचानाह देवुळतग्डा लाव मीवा पोग़ोन रेगो, अचानाह मीट इदे येरुसलेम सहरतगान मन्ह्‌टु,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","पया येसु ओरिन येरुसलेमता एरे मनदनद बेतनि नाटेनेके ओतोग़. ओसि तना कय तेहचि, ओरिह्‌क बर्कतताङ पोल्‍लोङ वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","बर्कतताङ पोल्‍लोङ वेहतह्‌पा, ओग़ ओरग्डाहि एग़तोग़. पया देवुळि ओन पोग़ोन देवुळदीपतगा ओता. ");
INSERT INTO mrr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","अस्के कग़यवालोर येसुन दंडुम अर्सि, अग्डाह पका गिर्दाते येरुसलेम सहरते मल्स वातोर. ");
INSERT INTO mrr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","पया अद्रमे वेर अमेसा मंदिरतगा अन्जि देवुळतुन जोहर कींदुर.");
INSERT INTO mrr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","देवुळता जीवात मनदनद पोल्‍लो बोग़ आंदोग़, ओग़ सुरुमुनेताह मंदोग़, ओग़ देवुळता ऐंगे मंदोग़, ओग़ देवुळिये आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ओग़ सुरुमुनेताह देवुळता ऐंगे मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","इळ्ता, पोग़ोटा बूमते मनदनव कतमतविन, देवुळि ओनाये मेटे पुटिह कीता. ओना मेटे पुटो इनाह बेदे इले. ");
INSERT INTO mrr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ओनग्डाहे माकु देवुळ ईयनद जीवा दोर्किह्‌ता. बेद्रम ईकळते मनदनदिन वेह्‌च पुनाह कीस्ता, अद्रमे ओग़ माकु देवुळता सेतेमतुन पुनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","अदे ईकळते मांजिह्‌ता. बेद्रम ईकळि वेह्‌चतुन पिहता पग़वो, अद्रमे ईकळलेह्‌काडोर लाग्वोरु, ओग़ वेह्‌चलेह्‌काडोनु आरे कीया पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","योहन इनवाल ओर्वोग़ मतोग़, ओन देवुळ लोहता. ");
INSERT INTO mrr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","सबेटोर ओना कबुरतुन विस्वस कीयना इन्जि, ओग़ु अद वेह्‌चलेह्‌का मनवानु पिङम-पङम वेहतलाहि वातोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","योहन इतेके वेह्‌चलेह्‌का मनवाल आयोग़, मति अदे वेह्‌चता लोप्पा वेहतलाह वास मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","बोन सेतेमता वेह्‌च इन्ह्‌तोर, ओग़े सबेटोरिह्‌क वेह्‌च एवाल, ओग़ इद दुनियाते वावाल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ओग़ इद दुनियातेन वातोग़, ओनाय मेटे देवुळि दुनियातुन पुटिह कीता, मति ओग़ बोग़ आंदोग़ इन्जि, दुनियातोर पुनोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ओग़ु तनाय पुटिह कीता बूमतगा वातोग़, मति तनाय लोकुर (यहुदि लोकुर) वेल्‍लाटोर ओनाङ केंजोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","मति बोर ओन नमतोर, विस्वस कीतोर, ओर सबेटोरिह्‌क देवुळताङ मग़्क-मयास्‍क आयलाह, ओग़ अदिकर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","देवुळताङ मग़्क-मयास्‍क आयना इतेके, मन्कना पोटाते, मन्कना विचर मतप पुटना लेह्‌का आयो, मति विस्वस केवालोरिह्‌कु पूना पुटमुळि देवुळिये ईस्ता. ");
INSERT INTO mrr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","देवुळता जीवात मनदनद पोल्‍लो, मावा लेह्‌का कय-कादोग़ आसि, मन्कना रूपते मावा बूमतगा वाता. ओग़ु देवुळता पूरा देय्वातुनु, पूरा सेतेमतुनु पोसि, मावा नडुम जागा आतोग़. ओग़ देवुळबाबाना वग़ोग़ मग़ आंदोग़; माट ओना डीसातुन ऊळतोम.(ओग़े येसु किर्स्तु आंदोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","योहन ओना लोप्पा इद्रमता कबुर वेहन्दोग़, “ओग़ु नाकाय बेरोग़, बाराह्‌क इतेके ओग़ नाकाय वेल्‍ला सुरुमुनेताहि मतोग़ इन्जि, बोना लोप्पा नना वेहच मतन, ओग़े नावा पया वावाल मन्ह्‌तोग़,” इनजोर लोकुरिन केयसोर वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","देवुळता मग़ि देवुळता देय्वाते निंदिस मताह्‌कु, ओनग्डाहि माकु देय्वा दोर्कसोरेन मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","इतेके मोसाल इनवाल देवुळता कबुरतोना मेटे, देवुळताङ अडोङ माक अस्के दोर्किस मताङ; येसु किर्स्तुना मेटे बार देवुळता सेतेमि, ओसो ताना दया मयगा एवता. ");
INSERT INTO mrr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","देवुळतुन बोग़े बेस्केन ऊळोग़. मति देवुळबाबाना संगे गट्ने मनवाल तना वग़ोग़ मग़ि, ओग़े माक बाबानु पुन्पिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","अस्के पया यहुदिराङ पेदल्क बाताल कीतोर,येरुसलेम सहरताहि देवुळता मंदिरतगा माळवालोर बूमयालोर, देवुळवडेर, वेरिनु योहनिन ऊळिस वाटु इन्जि लोहतोर. वेर योहननगा वासि “देवुळ लोहवाल पिसिह केवाल राजाल वावाल मतोग़, ओग़ बह निमानेया?” इनजोर योहनिन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","“आयो, नना देवुळ लोहवाल पिसिह केवानन आयोन,” इनजोर योहन मकिह केवालेवा कबुल आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","अस्के वेर ओन ताल्ह्‌कतोर, “निमा बोनिन पया, पिसिह केवाल वायनामुने, देवुळता कबुरतोग़ एलियाल वायना मन्ह्‌ता, निमा ओनिना?” “आयो, नना एलियानन आयोन.” “पया मोसानलेह्‌का देवुळता कबुरतोग़ वायना मन्ह्‌ता, बह ओनिना?” “आयो, नना ओनन आयोन!” इनजोर योहन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","अस्के ओसो वेर ओन ताल्ह्‌कतोर, “निमा पया बोनिन आंदिन? माक वेहा! माक लोहतोरिन माट अन्जि बाताल वेहतकोम? निमा नीवा सेवाता लोप्पा बाताल इह्‌निन?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","योहन इतोग़, “नना पेळ्ह्‌कल बूमते केयवाना आल्कालेह्‌काडोनन, सामि मीवा जीवातगा वायना इन्जि, ओना अग़दुन तीर्ह्‌काटु,” इनजोर यसयाल इनवाल देवुळता मुनेतोग़ कबुरतोग़ रासतदिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","पया परुसिर इनवालोर लोकुर योहनिन कबुर लोहच ताल्ह्‌कतोर, “निमा देवुळ लोहवाल पिसिह केवानिन वने आयविन, कबुरतोग़ एलियानिन वने आयविन, मोसानलेह्‌का देवुळता कबुरतोग़ वायना मता, ओनिन वने निमा आयविन इतेके, लोकुरिन देवुळता पेदिरते एग़ मीहतलाह नियगा बेद्रमता अदिकर मन्ह्‌ता?” ");
INSERT INTO mrr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","योहन ओरिन इतोग़, “नना लोकुरिन पापमताहि मिळ्न्दनद सीना इनजोरे, देवुळता पेदिरते एग़ मीहतह्‌नन, मति मीट पुनवोग़ ओर्वोग़, मीवा नडुम निच मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ओग़ु नावा पया वायना मन्ह्‌ता, ओना कादुन इटलाह वने नना ओप्पोन, अचोन नना उड्लोनन!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","योर्दन बेरेटा अबरि, बेतनि इनदनद नाटे, योहन देवुळता पेदिरते एग़ मीहन्दोग़, अगा इव गोटिङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","इमा दिया, योहन तनके येसु वायनदिन ऊळिसि, लोकुरिन इतोग़, “वेन ऊळाटु, मोक आयवाल देवुळता गोरेपिलालेह्‌काडोग़, दुनियातोरा पापमतुन एडिह केवाल! ");
INSERT INTO mrr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","वेनाय लोप्पा मीकु वेहच मतन, ‘नावा पया ओर्वोग़ वास्तोग़, ओग़ु नाकाय बेह्‌रोग़; बाराह्‌क इतेके ओग़ नाकाय वेल्‍ला सुरुमुनेताह मतोग़.’ ");
INSERT INTO mrr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ओग़ देवुळ लोहवाल पिसिह केवाल इन्जि, नना पुनोन आसि, मति मीक इस्रयेलतोरिह्‌कु वेन पुन्पिह कीयना इन्जि, नना देवुळता पेदिरते एतगा मीहतलाह वातन,” इन्जि योहन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","ओसो योहन येसुना लोप्पा इद्रमता साक्सि ईतोग़, “ओग़ देवुळ लोहवाल पिसिह केवाल इन्जि, नना पुनोन आसि, मति नाकु एते मीहतलाह लोहतनद देवुळि, अदे नाकु वेहच मता, ‘बोना पोग़ोन पवित्र जीवा वासि, दळ्म अरतदिन ऊळकिन, ओग़े लोकुरिन पवित्र जीवाते मीहवाल आंदोग़.’ निटमे नना पवित्र जीवातुन परेवा पिटेलेह्‌का देवुळदीपताहि दळ्म अर्सि, वेना पोग़ोन उदतदिन ऊळतन. ");
INSERT INTO mrr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","अह आतदिन नना कोंडामेंड ऊळतन, ऊळिसि वेग़ देवुळताय पेकाल आंदोग़ इन्जि, मीक साक्सि ईय्ह्‌नन,” इन्जि योहन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","इमा दिया, योहन तनाङ कग़यवालोरग्डाहि इर्वुरा संगे, अदे जागाते वासि निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","अस्के ओग़ येसुनु तना एरेटाहि दायह्‌पा ऊळिस इतोग़, “वेग़ ऊळाटु, (मोक आयवाल) देवुळता गोरेपिलालेह्‌काडोग़!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","योहन इद्रम इताह्‌कु, वेर इर्वुर कग़यवालोर केंजिसि, येसुना पयाह अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","येसु पेग़्के मिळ्न्दिस ऊळतोग़ अस्के, वेर इर्वुर ओना पयाह पयाह वासोर मतोर. “मीकु बाताल गावले?” इन्जि येसु वेरिन ताल्ह्‌कतोग़. “गूरु, नीवा मनदनद जागा बेगाडु?” इन्जि वेर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","अस्के येसु वेरिन इतोग़, “नावा संग दट.” वेर पया वासि, ओना मनदनद जागातुन ऊळतोर. मुल्पेडा वेलाते नालुङ एगिस मताह्‌कु, वेर अगाने येसुना संगे निद्र कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","योहननाङ केंजिस येसुना पयाह वावालोर इर्वुरग्डाहि, ओर्वोग़ आंद्रेयाल इनवाल मतोग़, ओग़े सिमोन पत्रु इनवाना तमोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","अग्डाहि ओग़ मुने तमदादाल सिमोनिन वास कलियतोग़, कलियिस इतोग़, “माक देवुळ लोहतोग़ पिसिह केवाल दोर्कतोग़, रा!” (ओग़ पिसिह केवान युनानि पोल्‍लोते “किर्स्तु” इन्ह्‌तोर.) ");
INSERT INTO mrr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","पया आंद्रेयाल तमदादान येसुनगा पोस वातोग़. येसु ओन ऊळिस इतोग़, “निमा योनाना मग़ि सिमोननिन, मति इंजेटाहि नीकु पत्रु (इतेके ‘आद बंडा’) इद पेदिर उदग़ा,” इन्ज वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","इमा दिया येसु गालिल पटटे दायलाह तयर आतोग़. आतस्के पिलिप इनवान कलियिसि ओन इतोग़, “नावा संग वय, नावाङ कग़या,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","वेग़ पिलिप इतेके, गालिल पटटा बेत्‍सेदा नाटेनोग़, इतेके आंद्रेयाल, पत्रु, वेर तमोग़ इर्वुरा नाटेनोग़ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","पिलिप पया अन्जि नतन्याल इनवान कलियतोग़, कलियिस ओन इतोग़, “बोना लोप्पा मोसा मुय्तोग़ ओसो देवुळता कबुरतोर मुने सास्त्रमते रासिस मतोर, ओग़ माक दोर्कतोग़, रा! ओग़ नासरेत नाटेनोग़ योसेपना मग़ि येसु आंदोग़,” इन्जि पिलिप नतन्यान वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“बह नासरेत नाटेनग्डाहि बेसताङ गोटिङ पुट पग़यनुङा?” इनजोर नतन्याल पिलिपिन इतोग़. “वास बह ऊळा रा!” इन्जि पिलिप इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","नतन्याल पया येसुनगा वातोग़, ओग़ वातदिन ऊळिसि येसु इतोग़, “वेग़ करल इस्रयेलतोग़, वेना पोटालोप्पा नाळेह कीयनद बुद इले.” ");
INSERT INTO mrr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“नना बेद्रमतोनन इन्जि, निमा बह पुह्‌निन?” इन्जि नतन्याल येसुन इतोग़. “पिलिप नीक केयनामुनेन, निमा अंजिर मराता इळ्न मतिन अस्के, नना नीक ऊळतन,” इन्जि येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","इद केंजिसि, (देवुळिये तोहताह्‌कु येसु नाक ऊळतोग़ इन्जि) नतन्याल येसुन इतोग़, “ए गूरु, निमा देवुळता मग़निन, इस्रयेल देसेमतुन पिसिह केवाल राजानिन आंदिन!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","“(बोग़े ऊळवाय मतोग़ अस्के,) नीकु नना अंजिर मराता इळ्न ऊळतन, इद्रम इताह्‌कु नाक निमा विस्वस कीय्ह्‌निना? निमा तेन्काय ओसो बेह्‌रा डीसाताङ पोल्‍लोङ ऊळकिन. ");
INSERT INTO mrr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","इह केंजाट, नना सेतेम वेहतह्‌नन, मीटु पोग़ोटा बूमि पङ्ने आसि, अगाह्‌कु देवतुल्कु माने-मन्कना नडुम पुटटोना पोग़ोन तग़्ङनदिन-रेगनदिन ऊळकिर,” इनजोर येसु तनाय लोप्पा वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","पया मूंड दियाने, गालिल पटटा काना नाटेनगा बोनाङो मर्मिङ मताङ, अगा येसुना तलोग़ वने मता. ");
INSERT INTO mrr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","मर्मिह्‌कु येसुनु ओसो ओनाङ कग़यवालोरिन वने केयिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","पया अगा अंगुर जोमा मारताह्‌कु, येसुना तलोग़ ओनगा वासि “इंजेके ओरगा अंगुर जोमा मारता, बाबा! बेदाय कीमु,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","अस्के येसु तान इतोग़, “बायि, निमा नाक बाराह्‌कु वेहतह्‌निन? नावा डीसा तोहतनद कगो इंका एवोये,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","पया अदु मर्मिनगा सेवा-साकुर केवालोरिन इता, “वेग़ मीकु बाताङ वेहतनोग़, अहे कीम्ह्‌टु,” इता. ");
INSERT INTO mrr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","यहुदि लोकुर तिनदनामुने, तमाङ कय्क-काल्क नोग़यना रिवज ओरा मता. इद रिवजतेनाह्‌कु, अगा उंद-उंद रेंड-मूंड कुळाङ पोयतवु, बंडानाङ आरुङ गोलेह्‌क तासतव मताङ. ");
INSERT INTO mrr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","“अव गोलेह्‌कनगा एग़ निहाटु,” इनजोरे येसु सेवा-साकुर केवालोरिन वेहतोग़. अस्के ओरु अव गोलेह्‌किन सीग निहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","पया येसु ओरिन वेहतोग़, “इंजेके उचुन तेंडिसि, कुळ्प ऊळवाल मुक्यानगा ओम्ह्‌टु.” अस्के ओर ओतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","पया ओग़ मुक्याल अद एतुनु उचुन ऊतिस ऊळतस्के, अद एग़ पूरा अंगुर जोमा मारियिस मता. इद बोग़ ततोग़ इनजोर, ओन्क मुर्तिय तेळियो; एग़ निहवालोरिह्‌क बारा, इद पोल्‍लो एर्का मता. अस्के कुळ्पता मुक्याल मर्मपेकान केयिस इतोग़, “बोराय बेसतल अंगुर जोमा मुने ईस्तोर, तान लोकुर उन्जि मिटस कीस्तोर, पया केनकेनेता जोमा ईस्तोर. निमा मात्रमि बेसतल अंगुर जोमा, इंजेक एवनाह पिसिह कीस तासतिन,” इन्जि मुक्याल इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","इद्रमि येसु गालिल पटटा काना नाटे, इद मुनेटा बामिह कीयना सीना कीसि, तना डीसा तोहतोग़. अदिह्‌कु ओनाङ कग़यवालोर, (ओग़ देवुळ लोहतोग़ राजाल मनदनोग़ इन्जि,) ओन नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","मर्मिङ मारतस्के येसु तना तलोग़ि, तनतमोर, ओसो तनाङ कग़यवालोरा संगे कापेर्नाग़ वातोग़, अगा ओर उचुके दियाङ रोमिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहुदि लोकुरा आवना पंडुम एरे एव्स मताह्‌कु, येसु येरुसलेम सहरतके पंडुमतगा अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","अगा यहुदिरा मंदिरतगा येसु अतस्के, लोकुर देवुळता मोकतुह्‌क अरयनव कुराङ, गोरेङ, परेवा पिटेङ वमिंदुर. ओसो कोताङ बद्ले कीसि यहुदिराङ कोताङ एवालोर अगा उदिस मंदुर. (सर्करताङ कोताङ मंदिरतगा वाटलाह ताकोङ आंदुङ.) वेर कतमतोरिन येसु ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ऊळिसि, ओग़ नोंडेना उंद जेट्ला एन्‍डटोग़, अह कीसि सबेटोर वीकुरतोरिनु मंदिरताहि पूंडटोग़. गोरेङ, कुराङ, इविन वन पूंडिसि, कोताङ बद्ले केवालोराङ बलानु कप मुळ्‍ह्‌चि कोतान लीकिसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","परेवाङ वमवालोरिन ओग़ इतोग़, “इविस्किन इग्डाहि पलत ओम्ह्‌ट! नावा बाबाना लोतुन आटुम पंडमाट!” इन्जि वेग़्हतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","पया “नावा जीवातुह्‌काय वीळिसि, नीवा लोतुन पवित्र तासलाह ऊळिह्‌नन,” इद सास्त्रमते दाविद राजाल रासतद पोल्‍लो ओनाङ कग़यवालोरिह्‌क सीता वाता. ");
INSERT INTO mrr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","येसु इद्रम कीताह्‌कु, यहुदि लोकुराङ पेदल्क ओनगा वासि इतोर, “नियगा इद्रम कीयलाह अदिकर मन्ह्‌ता इन्जि, माकु बेद सीना तोहतकिन?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","येसु ओरिन इतोग़, “इद मंदिरतुनु अर्ह्‌चीम्ह्‌ट, तेन नना मूंड दियाने ओसोवने दोहतकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“अलाले, इद मंदिरतुन दोहतलाह रेंड वीसाङ आरुङ (46) वर्साङ आताङ, इतेके निमा तेन मूंड दियाने बह दोहतकिन?” इन्जि ओर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","मति येसु यहुदिरा मंदिरता लोप्पा वळ्ह्‌कोग़ आसि, तनाय मेंदुदा लोप्पा वळ्ह्‌किस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","मनेक मनेके येसु हासि ओसो तेग़्कतस्के, ओनाङ कग़यवालोरिह्‌कु इद पोल्‍लोता सीता वाता. सीता वातस्के सास्त्रमते रासतदिन ओसो येसु वळ्ह्‌कनदिन, ओर नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","येसु आवना पंडुमता वेलाते, येरुसलेम सहरते मनदह्‌पा, वेल्‍लाटोर ओनाङ बामिह कीयनाङ सीनान ऊळतोर. ऊळिसि येसुये देवुळ लोहतोग़ पिसिह केवाल आंदोग़ इन्जि ओर नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","मति येसु बारा ओराङ पोल्‍लोनगा बर्वस तासोग़ आंदोग़, बाराह्‌क इतेके ओग़ सबेटोराङ विचर्किन पुन्जिय मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","मन्कलोरा बुदि बेद्रमता इन्जि, बोग़े येसुन वासि वेहतना गर्ज इले; मन्कना पोटालोप्पाडाङ गोटिङ ओग़ पूरा पुन्जिय मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","परुसिरा तुंगाताहि ओर्वोग़ मन्कल निकोदेमि इनवाल मतोग़, ओग़ यहुदिरा ओर्वोग़ बेरोग़ सेह्‌ना मन्कल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ओग़ उंद दिया नग़्का येसुन कलियलाह वातोग़, वासि, “गूरु, इव निमा कीयनव सीनाङ, देवुळता तोळलेवा बोग़े कीया पग़वोग़. अदिह्‌के निमा देवुळताहे वातोनिन गूरुनिन इन्जि, माक एर्का आता,” इनजोर ओग़ येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","अस्के येसु ओन इतोग़, “इह केंजा, नना सेतेम वेहतह्‌नन, बोन्काय देवुळताहि पूना पुटमुळ दोर्कवालेवा, देवुळ राजेम कीयनदु ओन्क मुर्तिय दिसो!” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","इतस्के निकोदेमि बयल आसि ओन इतोग़, “बातालि? पूना पुटमुळ इतेके बाताल? मन्कल मुय्तोग़ आतस्के, तना तलिना पोटातग्डाहि ओसो बह पुट पग़यनोग़?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","इतस्के “इह केंजा, नना सेतेम वेहतह्‌नन, बोग़े एताहि ओसो देवुळता जीवाताहि पुटवालेवा, देवुळ राजेम केवालोर लोकुरगा ओन्कु जागा दोर्को आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","मेंदुदा जीवा इसि, तलोग़-तपेरा मेंदुस्कनाहि पुटिह्‌ता, इद पूना जीवा बारा दिसवेकाय, देवुळता जीवाताहे पुटिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","अदिह्‌क मीक ओसोवने पुट पोयतग़ा इनजोर वेहताह्‌कु, निमा बयल आयमा. ");
INSERT INTO mrr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","इद केंजा, पूना पुटमुळ इह मन्ह्‌ता. वळ्यु बेक इतेक अके वास्ता. ताना नेकनदिन निमा केंजिह्‌निन, मति अद बेनाह वास्ता, बेके दास्ता, अद नीक तेळियो. अद्रमलेह्‌काने इद पूना पुटमुळि देवुळता जीवाताहि वास्ता इनजोर दिसो मति, पूना पुटमुळ आताह्‌कु परक दिसिह्‌ता,” इन्जि येसु निकोदेमिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“मति इद बेद्रम आया पग़यग़ा, गूरु?” इन्जि निकोदेमि येसुन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","अस्के येसु ओन इतोग़, “निमा इस्रयेलतोरिन काग़्हवानिन बेरोग़ गूरुनिन आस तेला मति, इव गोटिङ नीक तेळियोङा? ");
INSERT INTO mrr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","इह केंजा, नना सेतेम वेहतह्‌नन, माक एर्का मनदनदु, ओसो माटु कोंडामेंड ऊळतदु, इदिनलोप्पा साक्सि ईय्ह्‌नोम, मति मीट इतेके मावा साक्सितुन बर्वस केविर आय्ह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","नना मीकु इद बूमताङ गोटिङ वेहतन, तेला मति मीट बर्वस केविर इतेके, देवुळदीपताङ गोटिङ वेहतेके, अविन बह नमकिर? ");
INSERT INTO mrr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","माने-मन्कना नडुम पुटटोनन, नना देवुळदीपताहि रेगतन; नाक विळ्सिसि, देवुळदीपतगा अतोग़ु बोग़े इलेग़.(अदिह्‌के देवुळदीपताङ गोटिङ वेहतलाह अदिकर नयगा मन्ह्‌ता.) ");
INSERT INTO mrr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","बहलेह्‌का मोसा मुय्तोग़ पेळ्ह्‌कल बूमते इतुळता तरसतुनु, लाटगुटातगा पोग़ोन वेळ्हच मतोग़, अद्रमलेह्‌का माने-मन्कना नडुम पुटटोन्कु, इतेके नाकु, लोकुर गुटातगा पोग़ोन वेळ्ह्‌तनुर. ");
INSERT INTO mrr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","बहलेह्‌का मोसा मुय्तोना कालमते, तरस्क कस्कतोर लोकुर इतुळता तरसतुन ऊळिंदुर अस्के पिसिंदुर, अहलेह्‌का बोग़ नाकु नमनोग़, ओन्कु अमेसाता पिसमुळ दोर्कग़ा,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","देवुळि दुनियातोरिन बेद्रम जीवा कीता इतेके, तना वग़ोग़ मग़िन इद दुनियातोरेनाह्‌क मोक आयलाह ईता. बोर ओन नमनुर, ओर बूळेम आयोर, मति अमेसाता पिसमुळ ओरिह्‌क दोर्कग़ा. अदिनेनाह्‌कु देवुळि तना वग़ोग़ मग़िन दुनियाते लोहता. ");
INSERT INTO mrr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","देवुळि तना मग़िनु इद दुनियातोरिन सिक्सा ईयलाह लोहो, मति दुनियातोर ओना मेटे पिसना इन्जि, देवुळता विचर मता. ");
INSERT INTO mrr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","बोर ओन नमिह्‌तोर, देवुळि ओरिनु कसुर ओपो. मति ओन नमवोरा पोग़ोन बारा, कसुर ओपतदे मन्ह्‌ता. देवुळता वग़ोग़ मग़िन ओर नमवाह्‌कु, ओरा कसुर ओपतदे मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","देवुळता नेयमि इह मन्ह्‌ता. वेह्‌चलेह्‌काडोग़ देवुळदीपताहि इद बूमते वातोग़; मति मन्कलोर तमाङ कबस्क लाग्वाङ मन्ह्‌ताङ इनजोरे, वेह्‌चतुह्‌काय एक्‍वा, ईकळतेनाह्‌क गिर्दा आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","लाग्वाङ कबस्क केवालोर सबेटोर, वेह्‌चतुनु गिर्दा आयवा, ओराङ कबस्क दिसनदायो इनजोरे, वेह्‌चलेह्‌काडोना एरे वावोर. ");
INSERT INTO mrr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","मति सेतेमते ताकवालोर मन्कलोर वेह्‌चलेह्‌काडोना एरे वास्तोर; वानाह्‌कु, देवुळ वेहतपु ओर ताकनदु, सबेटोरिह्‌क दिसिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","इव गोटिङ मारतस्के, येसु ओसो तनाङ कग़यवालोर येरुसलेम सहरतुन विळ्सिसि, यहुदा पटटा दुस्रा जागाते अतोर. अगा ओना संगे मन्जि, ओर लोकुरिन देवुळता पेदिरते एग़ मीहन्दुर. ");
INSERT INTO mrr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","सालेम नाटेना कचुल, अय्नोन इनदनद जागातगा, वेल्‍लाय एग़ मताह्‌कु, योहन वने अगान लोकुरिन देवुळता पेदिरते मीहन्दोग़. अगा लोकुर वने ओना कयदे मीयलाहि वासोरेन मंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(योहनिन जेलतगा वाटनामुनेने, इव गोटिङ आताङ.) ");
INSERT INTO mrr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","अस्के यहुदिरा बोग़ो पेदा मन्कना संगे, योहननाङ कग़यवालोर बार, एडनद रिवजता लोप्पा, रेंड-रेंड पोल्‍लोङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ओर कग़यवालोर योहननगा वासि इतोर, “गूरु, योर्दन बेरेटा अबरि नीवा संग मतोग़ु, ओग़े देवुळ लोहतोग़ पिसिह केवाल इन्जि निमा साक्सि वेहतिन, ओग़ मन्कल इंजेके लोकुरिन देवुळता पेदिरते एग़ मीहतह्‌तोग़. सबेटोर (मयके वावा), ओनक्‍केन दायलाह आतोर,” इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","योहन ओरिन इतोग़, “देवुळि देय्वा एवालेवा, बोन्काय बातय दोर्को.(अदिह्‌के सबेटोर ओनक्‍केन दास्तोर इन्जि, मीवा जीवा कर्वतप आयमाकि.) ");
INSERT INTO mrr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","नना देवुळ लोहतोग़ पिसिह केवानन आयोन मति, लोकुराङ जीवानगा ओना अग़ि तयर कीयलाह, देवुळि नाक लोहता, इह इनजोर नना वेहतन, इदिन मीट केंजतिरे! ");
INSERT INTO mrr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","बेद्रम मर्मपिला मर्मपेकानकेन दास्ता, अद्रमे लोकुर ओनक्‍केन दास्तोर. नना इतेके मर्मपेकाना कचुल निच मनवाल, ओना गोततोनन. ओना वळ्ह्‌कनदिन नना केंजिह्‌नन, केंजिसि गिर्दाते मह्‌नन. लोकुर ओनक्‍केन दास्तोर, इदिन ऊळिसि नावा गिर्दा पूरा निंदता. ");
INSERT INTO mrr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ओना कदर बार वीळना, नावा कदर बार इळ्न अरयना, इह आयनाय गावले,” इन्जि योहन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","देवुळ लोहतोग़ राजाल पोग़ोटाह वास्तोग़ इतेके, ओग़ु सबेटोरिह्‌काय बेरोग़. बोर नेदाह वास्तोर, ओरु इद बूमतोरे मन्जि, इद बूमताङे गोटिङ वळ्ह्‌किह्‌तोर. बोग़ बार देवुळदीपताहि वास्तोग़, ओग़ सबेटोरिह्‌काय बेरोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ओग़ु बेद-बेद गोटटुन देवुळताहि केंजतोग़, ऊळतोग़, अदिने वेहतह्‌तोग़. मति ओग़ वेहतदिन, वेल्‍लाटोर सेतेम पोस नमिह्‌तोरा? ");
INSERT INTO mrr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","बोर ओन नमिह्‌तोर, देवुळबाबाल सेतेमतोग़ मन्ह्‌तोग़ इनजोर, ओरु कबुल कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","बोनु देवुळि लोहता, ओग़ु देवुळताङे पोल्‍लोङ वेहतह्‌तोग़. बाराह्‌क इतेके देवुळि तना जीवाते ओन पूरा निहता इनजोरे. ");
INSERT INTO mrr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","देवुळबाबाल तनमग़िन जीवा कीसि, ओना कयदे कतमे ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","बोरु मग़िन नमिह्‌तोर, ओरिह्‌क अमेसाता पिसमुळ दोर्किह्‌ता. बोर बारा मग़ना पोल्‍लोतुन केंजोर, ओरु अमेसाता पिसमुळतुन ऊळोर आयनुर, मति देवुळता ओङ ओरा पोग़ोन मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","मनेक मनेक पया, येसु योहनिह्‌काय एक्‍वा लोकुरिन देवुळता पेदिरते एग़ मीहतह्‌तोग़, अह आसि ओनाङ कग़यवालोर वीळिह्‌तोर इनजोर, परुसिर केंजतोर. (येसु तनाय एग़ मीहोग़, मति ओनाङ कग़यवालोर अह कींदुर). इद पोल्‍लो परुसिरिह्‌कु आबुर आता इनजोरे येसु पुतोग़. पुताह्‌कु, (माट इग्डाहि पेसकल इन्जि,)यहुदा पटटुन विळ्सिसि, ओसो उंद मल्का गालिल पटटे दायलाह पेसतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","दायह्‌पा नाकु सामरिया पटटुह्‌क दायनद अग़दुने पोयतना गावले इन्जि, येसु विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","सामरिया पटटा सूकर नाटेना कचुलि, यहुदिरा मुनेतोग़ पेदामुय्तोग़, याकुब इनवाल, तनमग़ि योसेपिह्‌क ईतद जागा मता. अदे जागातगा येसु एवतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","अगा कनिर अरतद याकुब मुय्तोना चुवा मता. येसु ताकिस वाताह्‌कु बागिस मतोग़, अदिह्‌क ओग़ु अद चुवातगा उदतोग़. अस्के नेक निच मता. ");
INSERT INTO mrr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","अद वेलाते उंदि सामरि जातता आंचाळि एतुह्‌क वाता. अस्के “बायि, नाक उचुन एग़ ईम,” इन्जि येसु तान ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(ओनाङ कग़यवालोर इतेके, तम्क तिनदलाह तिंडि असलाह नाटे अन्ज मतोर. अदिह्‌के ओन्क एग़ तोग़लाह बोग़े इलेग़.) ");
INSERT INTO mrr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","पया अद इता, “एंह-एंह, निमा यहुदि जाततोनिन आसि, नाक सामरि जातता आंचानु एग़ उनडलाह ईम इनजोर, बेद्रम ताल्ह्‌किह्‌निन?” (अद इद्रम इता, बाराह्‌क इतेके यहुदि लोकुर सामरितोरिन विटळ तासिंदुर). ");
INSERT INTO mrr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","येसु तान इतोग़, “देवुळ बेद देय्वा नीक ईकन इन्ह्‌ता, ओसो उनडलाह ईम इनजोर नीक ताल्ह्‌कवाल बोग़ु, इदिन निमा पुतेके, नाक निमा अद देय्वातुन ताल्ह्‌केनिन. अस्के नना नीक जीवात मनदनद एग़ एवेनन.” ");
INSERT INTO mrr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","(ओग़ वळ्ह्‌कतद पोल्‍लो तान्क पङ्ने तेळियवाह्‌कु,) अद इता, “दादा, नियगा एग़ तोग़लाहि जेरना वने इले, ओसो चुवातगा एग़ वने पकाय इळ्न मन्ह्‌ता. इतेके इद जीवात मनदनद एग़ु बेग्डाह वायग़ा? ");
INSERT INTO mrr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","मावा मुनेतोग़ पेदामुय्तोग़ याकुबि इद चुवातुन माक ईतोग़; ओग़ कुदि, तनाङ पेकोर ओसो कोंदाङ, गोरेङ, इग्डा एतुन उंडुर. बह निमा ओन्काय बेरोनिन आसि, माक इदिह्‌काय बेसतल एग़ ईकिना?” इन्जि अद येसुन इता. ");
INSERT INTO mrr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","पया येसु तान इतोग़, “बोग़ाय इग्डा एतुन उटोग़ इतेके, ओन्क ओसो एग़ उनडा वसग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","मति नना ईयनद एतुन बोर उनडनुर, ओरिह्‌क पया मुर्तिय एग़ उनडा वसो आयग़ा. नना ईयनद एग़ मात्रम, ओरा लोप्पा अमेसा पिसलाह ईयनदु, ऊता एग़लेह्‌का पोङग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“अह इतेक दादा, नाक बेस्केन एग़ उनडा वसनायो, ओसो इगा एवनाह एतुह्‌क वायनायो इनजोरे, नाक अद्रमता एग़ ईमु,” इन्जि अद ओन ताल्ह्‌कता. ");
INSERT INTO mrr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","अस्के येसु तान इतोग़, “निमा अन, अन्जि नीवा मुजोन इके केयिस तय.” ");
INSERT INTO mrr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","अस्के “दादा, नाक मुजो इलेग़.” इनजोर इता. “नाक मुजो इलेग़ इनजोर, निमा सेतेम वेहतिन, बायि! ");
INSERT INTO mrr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","बाराह्‌क इतेके निमा एयुङ मल्काङ जोळेम आसि, नीक एयवुर मुजोर मतोर; इंजेक मनवाल वने नीवा मुजो आयोग़. निमा सेतेमे वेहतिन,” इन्जि येसु तान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“अललेयो, दादा, निमा देवुळता कबुरतोनिन मनदकिन बहे. ");
INSERT INTO mrr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","मावा मुनेतोर पेदल्क इतेके, इदे गेरजिम इनदनद मेटातगा मोळ्किंदुर. मीट यहुदिरिर मात्रम इह्‌निर, ‘मोळ्कना जागा इगा इले, मति येरुसलेम सहरते मन्ह्‌ता,’ इनजोर इह्‌निर, (बोराङ सेतेम पोयतना?)” इन्जि अद येसुन इता. ");
INSERT INTO mrr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","अस्के येसु तान इतोग़, “ए बायि, नावा गोटटुन बर्वस तासा! मीटु इद मेटातगा आयि, येरुसलेमते आयि, ओसो बेगान आयि, देवुळबाबान मोळ्क पग़यकिर, इद्रमताङ दियाङ वायनुङ. ");
INSERT INTO mrr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","मीट सामरिया जाततोरिर पुनवदिन मोळ्किह्‌निर, मति माट यहुदिरोम बारा पुतदिन मोळ्किह्‌नोम. बाराह्‌क इतेके, यहुदिरगाने नना लोहवाल पिसिह केवाल पुट वायनोग़ इन्जि, देवुळि माक पुन्पिह कीता. ");
INSERT INTO mrr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","तेला मति सेतेम मोळ्कवालोर, देवुळता सेतेम पोल्‍लोतुन पुन्जि, तमा जीवाते मोळ्कनुर, इद्रमताङ दियाङ एवयनुङ, ओसो एवतपे मन्ह्‌ताङ. बाराह्‌क इतेके इद्रम मोळ्कवालोरिने देवुळबाबाल पर्ह्‌किह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","देवुळ इतेके दिसवद जीवा आंदु. अदिह्‌के तान मोळ्कवालोरिह्‌क, देवुळता सेतेम पोल्‍लोतुन पुन्जि, जीवाते मोळ्क पोयह्‌ता,” इन्जि येसु सामरि आंचान वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","अस्के अद ओन इता, “देवुळ लोहवाल पिसिह केवाल (इतेके किर्स्तु) वायना मन्ह्‌ता इन्जि नना पुह्‌नन. ओग़ वातस्के, माकु इद्रमताङ कतम गोटिङ तेळियिह कीस काग़्हतनोग़,” इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“ओनन ननाने, नीवा संगे वळ्ह्‌कवानन,” इनजोर येसु तान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","अचोटेने ओनाङ कग़यवालोर तिंड पोसि अगा वातोर. अस्के वेग़ उंद आंचाना संगे बाराह्‌क वळ्ह्‌किह्‌तोग़ इनजोर, बयल आतोर (बाराह्‌क इतेके ओरा रिवजते गूरुर आस्कना संगे वळ्ह्‌कोर आस्तोर). तेला मति, “तानेनाह नीक बाताल गावले? ताना संग बाताङ वळ्ह्‌कतिन?” इनजोर, ओरग्डाहि बोग़े ओन ताल्ह्‌कोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","अस्के अद आंचाळि अळ्कातुन अगान पोहचि नाटे अता, अन्जि इनदलाता, “नना बाताङ बाताङ कीतनो, अव कतमे पुतोग़ु वग़ोग़, नाक कलियिस वेहतोग़. ओन मन्कन ऊळकिर, दटे! ओग़ देवुळ लोहतोग़ पिसिह केवाल बह आयोग़?” इन्जि नाटेनोरिन इता. ");
INSERT INTO mrr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","अस्के वेर नाटेनाहि पेसिसि, ओनक्‍के वायलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","अद आंचाळि नाटे अन्ज मतस्के, कग़यवालोर येसुनु “अले गूरु, इव नीक तिनदलाह ततोम, तिन,” इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","मति ओग़ु ओरिन इतोग़, “मीट पुनविर, अद्रमता तिंडि नयगा तिनदलाह मन्ह्‌ता.” ");
INSERT INTO mrr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","अस्के कग़यवालोर तमतमाय “वेन्क तिनदलाह बोग़ाय ततोग़ा?” इनजोर वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","मति येसु ओरिन इतोग़, “बोग़ नाक लोहतोग़, ओना विचर मतप कीयना, ओसो ओना कबळतुन पूरा मारिह कीयना, इदे नावा तिंड आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","इद तूकने ‘नालुङ नेलाङ पिसताङ, पया कोयना आयग़ा,’ इनजोर मीट इह्‌निर बहे? केंजाट, नना मीक वेहतह्‌नन, मीवाङ कोंडाङ नाह्‌किस सर्ने ऊळाटु. (बोर लोकुर नावाङ पोल्‍लोङ केंजलाह तयर आस्तोर,) ओरु पका अयतद पंटालेह्‌काडोरु. ");
INSERT INTO mrr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","कोयवाल तना बूत दोर्किह कीस्तोग़, ओसो अमेसाता पिसमुळतेनाह्‌कु, लोकुरिन जमा कीस्तोग़. बाराह्‌क इतेके वीतवाल (इतेके देवुळता पोल्‍लो वेहवाल) ओसो कोयवाल (इतेके पोल्‍लोतुन नमवालोरिन जमा केवाल) वेर इर्वुर कलियिस गिर्दा कीयना इन्जि. ");
INSERT INTO mrr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘ओर्वोग़ वीतिह्‌तोग़, दुस्रोग़ बारा कोयह्‌तोग़,’ इद्रम इनदनद उंद गोटि मन्ह्‌ता, इद गोटि मीवा लोप्पा करल अरयह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","बेदिनेनाह्‌क मीट मुने कह्‌टेम केविर, अदिन कोयलाह नना मीक लोहतन. नना कह्‌टेम कीसि देवुळता पोल्‍लो वेहतह्‌नन, दुस्रोर वने मुने वेहच मतोर, मति मावा कह्‌टेमता पंटा कोयलाह मीट वने कलियतिर,” इन्जि येसु तनाङ कग़यवालोरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","पया बार आता इतेके “नना बाताङ बाताङ कीतनो, अविन कतम पुतोग़ु वग़ोग़ नाक वेहतोग़,” इन्जि वेहतनद अद आंचाना गोटटुन केंजिसि, अद नाटेनोर सामरि जाततोर वेल्‍लाय मुल, देवुळ लोहतोग़ राजाल येसुये आंदोग़ इन्जि नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ओर सामरियातोर येसुनगा वातोर, वासि ओन इनदलातोर, “ए गूरु, मयगान निद्र कीम,” इनजोर इताह्‌कु पया, ओर अद नाटे रेंड दियाङ आनाह मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","येसुनाङ पोल्‍लोङ केंजिस, ओसोवन वेल्‍लाय मुल ओन नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ओर नाटेनोर अद आंचान इतोर, “सिरप निमा वेहताह्‌के माट नमोम, मति इंजेके माट कुदि ओनाङ केंजतोम. केंजिसि दुनियातोरिन पिसिह केवाल निटम वेग़े आंदोग़ इनजोर, माट पुह्‌नोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","अव रेंड दियाङ आतस्के, ओर अग्डाहि पेसिसि, तमा गालिल पटटे वातोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","देवुळता कबुरतोन्क तनाय देसेमते बेस्केन कदर दोर्को इनजोर, येसु कुद वेहच मतोग़.(ओग़ वेहतपु अहे आता.) ");
INSERT INTO mrr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","इंजेके गालिल पटटोर वेल्‍लाटोर, पंडुम मतस्के येरुसलेमतके अन्ज मतोर. येसु अगा बेचोक बामिह कीयनाङ कबस्क कीस मतोग़, अव कतम वेर अस्के ऊळिस मतोर. अदिह्‌के नेंड वने अद्रमताङे ऊळलाहि, येसु गालिल पटटे वातस्के, वेरु गिर्दाते ओन कलियतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","पया येसु ओसोवने गालिल पटटा काना इनदनद नाटे वातोग़. इदे नाटे कोनि, ओग़ मुने एतुनु अंगुर जोमा मारियिह कीस मतोग़. गालिलता कापेर्नाटे, सर्करता ओर्वोग़ साय्बाल मतोग़, ओना पेकाल पका दुक अर्स मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","येसु यहुदा पटटाहि गालिल पटटे वातोग़ इनजोरे, ओग़ साय्बाह्‌क कबुर दोर्कता. दोर्कताह्‌कु, ओग़ येसुन कलियलाह काना नाटे अतोग़. येसुन कालगडेम अर्सि इतोग़, “दादा, नावा मग़ि गय्क इतेक हायनोग़, ओन सव्रे कीसीकिन, दय!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","(आपुना गालिल पटटोरा बुद पुन्जि,) येसु ओन इतोग़, “बामिह कीयनाङ सीनाङ ऊळवालेवा, मीटु मुर्तिय विस्वस केविर आयकिर!” ");
INSERT INTO mrr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","वेग़ साय्बाल येसुन इतोग़, “ए दादा, नावा पेकाल डोलनामुनेन दय!” ");
INSERT INTO mrr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“अन, नीवा पेकाल पिसतोग़,” इन्जि येसु ओन इतोग़. येसु अह इताह्‌कु, ओना पोल्‍लोतुन नमिसि, ओग़ मल्स अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","इमा दिया, ओग़ तना नाटे अनजोरेन मतोग़, अचोटेने ओना ओर्युलतोर कलियतोर, कलियिस पया “नीवा पेकाल डोलोग़, बेसे मन्ह्‌तोग़, महरज!” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","अस्के “बेद वेलाते ओग़ सव्रेम आयलाह बोटटोग़?” इन्जि, ओग़ साय्बाल ओरिन ताल्ह्‌कतोग़. अस्के “निने, नेक निचि बह्‌ट अरतस्के, ओना दंड विळ्सता, महरज” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","इदिन केंजिसि, बेद वेलाते येसु नाकु “नीवा पेकाल पिसतोग़,” इनजोर इतोग़, अदे वेलाते नावा पेकाल सव्रेम आतोग़ इनजोर, ओग़ पुतोग़. अदिनेनाह्‌कु ओग़ु ओसो ओना लोतोरु, कतमतोर येसुन नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","इद्रमि ओसो उंद मल्का येसु यहुदा पटटाहि गालिल पटटे वासि, सीना तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","गळ्क मनेके, येसु गालिल पटटाहि पेसिसि, येरुसलेम सहरते यहुदिरा उंद पंडुमतगा अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","येरुसलेम सहरते गोरे-दर्वजा इनदनद अग़दगा उंदि वेच्‍चा मन्ह्‌ता, तेना पेदिर इब्रि पोल्‍लोते बेतेस्‍दा इनजोर तासतोर. ताना कचुलि एयुङ मंडाङ पंडटव मताङ. ");
INSERT INTO mrr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","अवटे गुडिर, कूटालोर, कय्क-काल्क वाग़तोरु, इद्रमतोर दुकिनोर वेल्‍लाटोरे अगा जागा आस मंदुर एतुन मेल्हतनदिन केपसोरे. बाराह्‌क इतेके बेस्के-बेस्के देवतुलि अद वेच्‍चातगा रेगिसि, एतुन गोकिह कींदु, इद्रम कीतस्के अद जागातगा बोग़ मुने अर्न्दोग़, ओग़ तना दुकताहि सव्रेम आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ओर दुकिनोरगा डेडा वीसा आट (38) वर्सानाहि दुक अरतोग़ ओर्वोग़ मतोग़, ओग़ मुर्तिय ताक पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ओग़ अगा वळ्ह्‌क अरतदिन येसु ऊळतोग़. वेग़ वेल्‍लाङे दियानाहि इहे मन्ह्‌तोग़ इनजोर येसु पुतोग़, पुताह्‌कु ओनगा अन्जि इतोग़, “दादा, निमा नीवा दुकताहि सव्रेम आयना विचर मन्ह्‌ताया?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“इंगो साय्ब, मति इद एतुन मेल्हतनस्के, नाकु अद एतगा ओयलाह, मावोर बोरे नाक तोळ इलेर. अदिनेनाह्‌क एग़ मेलियनेके दाय्ह्‌नन मति, नाकाय मुनेन बोग़ाय रेगिह्‌तोग़,” इन्जि वेग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","“असि, तेदा, नीवा माग़ि उळ्हच पोय्म, अह कीस अग़ पोस ताकसोर अन,” इनजोर येसु ओन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","अस्के ओग़ मन्कल तोप्नेन सव्रेम आतोग़, आसि तना माग़ि उळ्हच पोसि, दिगदिग ताकसोर अतोग़. अद दिया इतेके वारमता पोल्वादिया मता. ");
INSERT INTO mrr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","11","अदिह्‌कु दुकताहि सव्रेम आतोन, यहुदिराङ पेदल्क इतोर, “नेंड पोल्वादिया इनजोरे पुनविना? नीकु माग़ कांजना कबळ पोलो,” इनजोर इतस्के ओग़ इतोग़, “बोग़ नाकु सव्रे कीतोग़, ओग़े नाक वेहतोग़ ‘नीवा माग़ उळ्हच अन,’ इनजोरे.” ");
INSERT INTO mrr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“अद्रम इनजोर इनवाल बोग़ मन्कल आंदोग़, रा?” इन्जि ओन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","मति ओग़ बोग़ आंदोग़ इनजोर, वेग़ सव्रेम आतोग़ मन्कल पुनोग़. बाराह्‌क इतेके अगा वेल्‍लाय मुल मताह्‌कु, येसु तना पेदिर वेहवाये, अद मुडग्डाहि पेसिस अन्ज मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","अस्के पया मंदिरते येसु वेन कलियतोग़, कलियिस इतोग़, “ऊळा, निमा दुकताहि तेग़्कतिन! मुनेटलेह्‌का इंजेक पापम केमा बहा, कीतेके मुनेट्काय एक्‍वा तिपलते अरयकिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","अग्डाह पया वेग़ अन्जि “नाक दुकतग्डाहि तेग़्किह कीतोग़, ओग़ येसुये आंदोग़,” इनजोरे यहुदिराङ पेदल्किन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","अदिनेनाह्‌कु यहुदिराङ पेदल्क येसुन कट्ला कीयलाह आतोर, बाराह्‌क इतेके पोल्वादियाते ओग़ इद्रमताङ कबस्क कीस्तोग़ इनजोरे. ");
INSERT INTO mrr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","अस्के येसु ओरिन इतोग़, “नावा बाबाल नेंड एवनाहि कबळ कीसोरेन मन्ह्‌तोग़, (पोल्वादियाते वने कीस्तोग़े). अद्रमे नना वने कबळ कीय्ह्‌नन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","येसु इह इताह्‌कु, यहुदिराङ पेदल्क ओसो ओन हव्कलाह कोहन्दुर, बाराह्‌क इतेके ओरा विचरते येसु रेंड कसुर्क कीतोग़. उंदि इतेके पोल्वादियाते कबळ कीयना, ओसो दुस्रा इतेके देवुळतुन नावाय बाबाल इनजोर, नना देवुळता बराबरतोनन इतप वळ्ह्‌कना, इव रेंडु. ");
INSERT INTO mrr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","अस्के येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, नना नावाय विचरते बेदाय कबळ कीया पग़वोन. मति नावा बाबाल कीयनव कबस्किन ऊळिसिये, नना ओना मग़नन इन्जि, अद्रमे कीय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","नावा बाबाल नाक जीवा कीसि, तनाङ कीयनव सबे कबस्किन नाक तोहतह्‌तोग़. मीट बामना इनजोरे, नना कीतव इविस्किह्‌काय बेह्‌राङ कबस्क कीसि नाक तोहतनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","बहलेह्‌का नावा बाबाल हातोरिन तेग़्किह कीसि जीवा अर्हतह्‌तोग़, अहलेह्‌का नना वने बोन इतेक ओनु, जीवा अर्हतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","बेद्रम नावा बाबाह्‌कु सबेटोर मान ईस्तोर, नना ओना मग़नन मनाह्‌कु, नाक वने सबेटोर मान ईयना इनजोरे, बाबाल बोनाय नेयम केवोग़; मति नेयम कीयनद पूरा कबळि नाक ईतद मन्ह्‌ता. बोग़ मग़िह्‌क मान एवोग़, ओग़ु मग़िन लोहतोग़ बाबाह्‌क वने मान एवपे मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","इह केंजाट, नना सेतेम वेहतह्‌नन, इद दुनियाते सबेटोर (तमा पापमते) डोलतप लेह्‌का मन्ह्‌तोर. मति बोर नावाङ पोल्‍लोङ केंजिसि, नाक लोहतोना पोग़ोन बर्वस तासिह्‌तोर, ओरिह्‌क अमेसाता पिसमुळ दोर्कताये. देवुळ ओरिन तमा पापमता सिक्सा एवो; मति ओरिन अमेसाता पिसमुळतगा एव्सिह कीसीता. ");
INSERT INTO mrr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","इह केंजाट, इद ओसो वेहतह्‌नन, नना देवुळबाबाना मग़नन, हातोर मन्कलोर नावा आल्का वेनदनुर, इद्रमताङ दियाङ एवयनुङ, आयो एवतपे मन्ह्‌ताङ वने. बोर वेनदनुर, ओर जीवा अरयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","बहलेह्‌का नावा बाबाल लोकुरिह्‌क जीवा ईया पग़यह्‌तोग़, अद्रमे ओग़ु नाक ओना मग़िह्‌क वने इद्रमे जीवा ईयलाह अदिकर ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","बाबाल नाकु नेयम कीयनद अदिकर वने ईतोग़, बाराह्‌क इतेके नना माने-मन्कना नडुम पुटटोनन इनजोर. ");
INSERT INTO mrr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","मीटु इदिन केंजिस बयल आयमाटु. बाराह्‌क इतेके गुमयाना लोप्पा मनवालोर नावा आल्कातुन वेनदनुर, ओसो पलत पेसनुर, इद्रमता वेला वायग़ा. बोर सेतेमताङ कबस्क कीतोर, ओर कतमतोरे अमेसाता पिसमुळतेनाह्‌क जीवा अरयनुर. मति बोर बारा लाग्वाङ कबस्क कीसोर मतोर, ओरु सिक्सा आयलाह जीवा अरयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“नना नावाय अदिकरते बातय कीया पग़वोन. बेद्रम बाबाल नाक वेहतह्‌तोग़, अद्रमे नना नेयम कीय्ह्‌नन. नना नावाय कुदता विचरते आयो, मति नाक लोहतोग़ बाबाना विचर मतप कीय्ह्‌नन, अदिह्‌क नावा नेयम सेतेम अरयह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","नावा लोप्पा ननाने साक्सि ईतेके, अद साक्सितुन बोग़े सेतेम पोयोग़ आवेग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","नावा लोप्पा ओसो ओर्वोग़ साक्सि एवाल मन्ह्‌तोग़, ओग़ नावा बाबाल. ओग़ नावा लोप्पा बाताल वेहतनोग़, अद सेतेमताये इनजोर नना पुह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“ओसो ओर्वोग़ साक्सि एवाल मन्ह्‌तोग़. मीटु देवुळता पेदिरते एग़ मीहवाल योहनिन ताल्ह्‌क वेहतिर, अस्के ओग़ु सेतेमतुने वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","मन्कना साक्सितुन इतेक नना बर्वस केवोन, मति योहनना पोल्‍लोतुन नमिसि, मीक अमेसाता पिसमुळ दोर्कना इन्जि, इव गोटिङ मीक सीता कीसीतन. ");
INSERT INTO mrr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","नावा लोप्पा वेहतनस्के, योहन पोतना चिमलिलेह्‌का वेह्‌च तोहवाल मतोग़. मियगा ओना वेह्‌च मताह्‌कु, मीक गय्क गिर्दा आयलाह बेस आता. ");
INSERT INTO mrr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“मति योहनना साक्सितुह्‌काय नयगा ओसो बेह्‌रा साक्सि मन्ह्‌ता. बेव कबस्किन मारिह कीयलाह, नावा बाबाल नाक लोहतोग़, बेव कबस्किन नना कीय्ह्‌नन, नाक बाबाल लोहतोग़ इनजोरे, अवे कबस्क मीक तोहतह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","नाक लोहतोग़ नावा बाबाल, ओग़ वने नावा लोप्पा साक्सि ईतोग़. मीट इतेक बेस्केन ओना आल्कातुन वेनविर, बेस्केन ओना रूपतुन ऊळविर. ");
INSERT INTO mrr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ओसो मीट ओना पोल्‍लोतुन, मीवा जीवाते गडिह कीस तासविर; तासिस मतेके ओग़ लोहतोन मग़िन मीट नमेरिर. ");
INSERT INTO mrr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","पवित्र सास्त्रम पुन्जि, माकु अमेसाता पिसमुळ दोर्कग़ा इन्जि, मीटु अग्डाङे कग़यसोर मह्‌निर. केंजाटु, इदे सास्त्रम नावाय लोप्पा वेहतह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","तेला मति अमेसाता पिसमुळतेनाह्‌क, नयगा मीकु वाया वसो. ");
INSERT INTO mrr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“मन्कलोर नाकु कदर ईतेकाय, एवेकाय, नाक पर्वा इले. ");
INSERT INTO mrr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","मति मीट बेद्रमतोरिर इन्जि नना पुह्‌नन. मीटु देवुळतुन मुर्तिय जीवा केविर. ");
INSERT INTO mrr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","नना नावा बाबाना अदिकर पोस वातन, मति मीट नावाङ केंजविर. बोग़ाय दुस्रोग़ मन्कल, तनाय अदिकरते वायनोग़ अस्के, ओनाङ बार केंजकिर. ");
INSERT INTO mrr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","मीट ओर्विनेनाह ओर्वोग़ कदर पर्ह्‌किह्‌निर, मति वग़य देवुळतेनाह दोर्कनद कदरतुन बार पर्ह्‌कविर इतेके, मीट बेद्रम विस्वस कीया पग़यकिर! ");
INSERT INTO mrr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","नना बाबाना मुनेह मीवा पेटळ तप तासकन, इद्रम इह्‌निर बहे, मति नना तप तासोन. केंजाट, मीटु मोसानाङ अडोन नोमिह्‌नोम इन्जि, आसा तासिस मह्‌निर, ओग़ मोसाले मीवा पेटळ तप तासनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","सास्त्रमते मोसा मुय्तोग़ नावाय लोप्पा रासिस तासतोग़, अद सास्त्रम नाके तोहतह्‌ता. इतेके मोसाल रासतदिना पोग़ोन, मीटु विस्वस तासिस मतेके, नावा पोग़ोन वने विस्वस तासेरिर. ");
INSERT INTO mrr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","मति मोसा मुय्तोग़ रासतद गोटटुने सेतेम पोयविर इतेके, नावाङ गोटिन मीट बह नमकिर?” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ताना पया येसु गालिल सम्दुरता (इतेके तिबिरिया सम्दुरता) अबर दडटेके तनाङ कग़यवालोरा संगे वेंडिस वातोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ओग़ वेल्‍लाङे रोगह्‌किन सव्रे कीयनव सीनान ऊळसोर मताह्‌कु, वेल्‍लाय मुल ओना पयाह पयाह अंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","पया येसु ओसो ओनाङ कग़यवालोर, ओना संगे गुड्रापोग़ोन अतोर. अगा ओग़ु ओरिन काग़्हतलाह उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","अद तूकने यहुदि लोकुरा आवना पंडुम एरे एव्स मता. ");
INSERT INTO mrr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","पया येसु अग्डाहि ऊळनेके, ओना पयाह वावालोर वेल्‍लाय मुडुन ओग़ ऊळतोग़. अस्के येसु तनाङ कग़यवाल पिलिप इनवान ताल्ह्‌कतोग़, “वेर कतमतोरिह्‌क तिनदलाह आरिङ बेगा असलाह दोर्कनुङ, डा?” (नावा डीसातगा पिलिपना विस्वस मन्ह्‌ताया, इलेया,) इदिन ऊळलाह, येसु ओन इह ताल्ह्‌कतोग़. बाराह्‌क इतेके तना बाताल कीयना मता, अद येसुह्‌कु एर्काये. ");
INSERT INTO mrr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","“गूरु, आट नेलाना कूलताङ कोताने, आरिङ असिस ईतेकाय, वेर सबेटोरिह्‌क किळ्केङ वने आलोङ आयनुङ,” इन्जि पिलिप येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","अस्के दुस्रोग़ ओर्वोग़ कग़यवाल, सिमोन पत्रुना तमोग़, आंद्रेयाल इनवाल इतोग़, “इगा ओर्वोग़ उड्लोग़ पेकानगा, सेन जोनानाङ एयुङ आरिङ ओसो रेंड मीन्क मन्ह्‌ताङ, मति इचोन मुडुह्‌क अव बेगा आलनुङ?” इन्जि येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","पया येसु “लोकुरिन उदिह कीम्ह्‌टु” इनजोरे ओरिन इतोग़. अगा बेसतल रोंडा मताह्‌कु, अगा मतोरु जोक-जोक एयुङ अजर्क कोय्तोर तमा लोतोरा संगे उदतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","येसु पया कयदे आरिन, मीन्किन एचि, देवुळतुन जोहर कीतोग़. जोहर कीसि तनाङ कग़यवालोरिह्‌क आरिङ वांटलाह ईतोग़, ओर पया सबेटोर उदतोरिह्‌क वांटटोर. अद्रमे ओर बेचोक इतेक अचोक मीन्क वने तूसिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ओर कतमतोर पंजनाह तितोर, पया “इंजेक बातय उगस पोवयनायो इन्जि, पिसताङ-मयताङ किळ्केङ जमा कीम्ह्‌ट,” इन्जि येसु तनाङ कग़यवालोरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","पया कतम मुल तिन्जि तेदतस्के, सेन जोनानाङ एयुङ आरिनग्डाहि पिसताङ-मयताङ किळ्केङ जमा कीतस्के, अव बारा डालाङ निंदताङ. ");
INSERT INTO mrr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","येसु कीतद इचोटा बेरा सीनातुन ऊळिसि, लोकुर इनदलातोर, “बोग़ मोसानलेह्‌का देवुळता कबुरतोग़ इद दुनियाते वावाल मतोग़, ओग़ निटमे वेग़े आंदोग़ रो!” ");
INSERT INTO mrr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","लोकुर नाक पोसि राजाल कीयलाहि ऊळिह्‌तोर इन्जि येसु पुताह्‌कु, ओग़ वग़ोग़े पेसिस गुड्रापोग़ोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","मुलतस्के येसुनाङ कग़यवालोर सम्दुरतेके ओळ्सिये अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ईकळ आस मता, मति येसु ओरगा वावाय मतोग़. अदिह्‌कु ओर कापेर्नाग़ दायलाह ओडाते उदिसि, सम्दुरतुन वेंडसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","अस्के बेरा दूंद वाताह्‌कु, सम्दुरता एग़ पकाय गोकिंदु. ");
INSERT INTO mrr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ओर रेंड कोस्क बार जागा ओडा वग़्हचोर अतापया, ऊळाटु, येसु एता पोग़ोट्क ताकसोरे, ओडाता एरे वायनदिन ऊळिसि, ओर पकाय रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","मति येसु ओरिन आळो कीस इतोग़, “ननाय आंदन, रा! रेयमाटु.” ");
INSERT INTO mrr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ओन ओडातगा उदिह कीयलाह, ओरा गिर्दा मता. अस्के दोम्‍क्‍नेन ओडा ओरा दायनद जागाते, अबर बाजे दडकचुल एवता! ");
INSERT INTO mrr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","येसुसामि देवुळतुन जोहर कीसि, लोकुरिह्‌कु आरिङ तूसतोग़, अद जागातेने तितोर मुलु रोमिस मतोर. इमा दिया नग़्कमि, ओर येसुन कलियलाह जमा आस मतोर. येसुनाङ कग़यवालोर उदिस अतदु उंदिय ओडा मता, अद ओडाते इतेके येसु अनोग़, सिरप ओनाङ कग़यवालोरे अन्ज मतोर इन्जि, लोकुर पुन्जिये मतोर. (मति इंजेके तिबिरिया नाटेनाहि दुस्राङ ओडाङ अद जागाते वातव मताङ.) ");
INSERT INTO mrr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","अदिह्‌कु इगा येसु इलेग़, ओनाङ कग़यवालोर वने इलेर इतेके, ओग़ु कापेर्नाग़ सम्दुरकचुल ताकसोरे अन्ज मनदनोग़ बहे, इन्जि वेर लोकुर विचर कीतोर. विचर कीसि वेर वने पया येसुन पर्ह्‌कलाह ओडाने उदिसि, अबर दडटा कापेर्नाटे एवतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","पया येसु अबर दडटगा कलियतस्के, “इचोन चट्पिट बह वातिन, गूरु?” इनजोर लोकुर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","अस्के येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मीटु नावाङ बामिह कीयनाङ सीनाङ ऊळताह्‌कु आयो, मति पंजनाह आरिङ तिताह्‌कु, ओसोवन दोर्कनुङ बहे इनजोर नाक पर्ह्‌किह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","अवयनद तिंडटा पेग़्के अनमाट, मति अमेसाता पिसमुळ ईयनद, बेस्केन अववदु तिंडटुन पर्ह्‌काटु. इद्रमता तिंडि माने-मन्कना नडुम पुटटोनन, नना मीक ईकन. बाराह्‌क इतेके अदिन ईयनद अदिकर नावा देवुळबाबाल नाक ईतोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","“माट बह कीकोम इन्जि देवुळता विचर मन्ह्‌ता, गूरु?” इनजोर ओर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","अस्के येसु ओरिन इतोग़, “मीट बहे केमाटु, मति देवुळ लोहतोना पोग़ोन, इतेके नावा पोग़ोन मीट बर्वस तासना, इदे मीट कीयना इन्जि, देवुळता विचर मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","अग्डोर नाटेनोर ओन ताल्ह्‌कतोर, “अह इतेके माट नीक नमना इन्जि, माक बेद्रमता सीना तोहतकिन? निमा बाताल कीकिन? ");
INSERT INTO mrr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","मावोर मुनेतोर पेदल्कु पेळ्ह्‌कल बूमते देवुळदीपताहि अर्हतदु ‘मना’ इनदनद तिंडि तितोर.सास्त्रमते वने मोसा मुय्तोना लोप्पा रासतद मन्ह्‌ता: ओग़ ओरिह्‌क तिनदलाहि पोग़ोटा बूमताहि तिंडि ईतोग़, इनजोर रासतद मन्ह्‌ता.” ");
INSERT INTO mrr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","येसु पया ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, पोग़ोटाहि तिंड अर्हतोग़ मोसा मुय्तोग़ आयोग़, नावा बाबाले मतोग़. ओसो इंजेके ओग़े पोग़ोटाहि वायनद करलता तिंडि मीक ईय्ह्‌नन इन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","बाराह्‌क इतेके देवुळदीपताहि रेगिसि, इद दुनियातोरिह्‌क अमेसाता पिसमुळ एवाल, ओग़े देवुळ ईयनद तिंडि आंदोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“ए गूरु, इद्रमता तिंडि माकु अमेसा ईसोर मनु,” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","येसु पया ओरिन इतोग़, “अमेसाता पिसमुळ ईयनद तिंडि ननान आंदन. बोर नयगा वायनुर, ओरिह्‌क बेस्केने कग़्व वसो आयग़ा. बोर नाक नमनुर, ओरिह्‌क बेस्केने एग़ उनडा वसो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","मति मीट नावाङ डीसाताङ कबस्किन ऊळिस तेला, नना बोनन इन्जि मीट पुनवाह्‌कु, नाक नमविर इनजोर, मीक नना वेहच मतन. ");
INSERT INTO mrr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","बोन-बोन नाक बाबाल ईस्तोग़, ओर कतमतोर नयगा वास्तोर. ओसो बोर नयगा वायनुर, ओरिन नना बेस्केन मल्हच लोहोन आयकन. ");
INSERT INTO mrr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","बाराह्‌क इतेके नना नावा विचरते कीयलाह आयो, मति नाक लोहतोना विचर मतप कीयलाह, देवुळदीपताहि रेगतन. ");
INSERT INTO mrr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","बोर मन्कलोरिन बाबाल नाक ईतोग़, ओरग्डाहि वग़ोग़ वने लेसनायो, मति ओर कतमतोरिन आक्रिता दियाते नना जीवा अर्हतना, इदे नाक लोहतोना विचर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","बोर देवुळता मग़िन पुन्जि नाक नमनुर, ओरिह्‌क अमेसाता पिसमुळ दोर्कग़ा, ओसो नना ओरिन आक्रिता दियाते मल्स जीवा अर्हतना, इद्रम नावा बाबाना विचर मन्ह्‌ता,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","देवुळदीपताहि रेगतद तिंडि ननान आंदन इनजोर येसु इताह्‌कु, यहुदिर तमतमाय येसुना लोप्पा मुयोग़ आंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","मुयोग़ आसोर ओर इतोर, “वेग़ इतेके योसेपना मग़ि येसु आयोया? वेना तलोग़-तपेन बह माट पुनोम? पया वेग़ नना देवुळदीपताह रेगतन इनजोर, बेद्रम इन्ह्‌तोग़?” ");
INSERT INTO mrr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","अस्के येसु ओरिन इतोग़, “मीट-मीटे मुयोग़ आयमाट! ");
INSERT INTO mrr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","केंजाटु, नाक लोहतोग़ बाबाल ओस एवालेवा, बोग़े नयगा वाया पग़वोग़. ओसो ननाये ओन आक्रिता दियाते मल्स जीवा अर्हतकन. ");
INSERT INTO mrr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","मुनेतोर देवुळता कबुरतोरा सास्त्रमते बह रासतद मन्ह्‌ता इतेके, ओर कतमतोरिन देवुळि काग़्हतग़ा, इद नाक नमवालोरा लोप्पा रासतदु. बोर बाबानग्डाहि केंजिसि कग़यिह्‌तोर, ओर नावाङ पोल्‍लोङ केंजलाह नयगा वास्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ननान देवुळतेनाह वातन, नाक विळ्सिसि बोग़े देवुळबाबान ऊळोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","इह केंजाट, नना सेतेम वेहतह्‌नन, नाक नमवालोरिह्‌क अमेसाता पिसमुळ दोर्कताये. ");
INSERT INTO mrr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","अमेसाता पिसमुळ ईयनद तिंडि ननान आंदन. ");
INSERT INTO mrr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","मीवोर मुनेतोर पेदल्क पेळ्ह्‌कल बूमते देवुळ अर्हतद ‘मना’ इनदनद तिंडि तिन्ज तेला, ओर डोलतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","मति देवुळदीपताहि इळ्न रेगनद बेद तिंडटुन नना वेहतन, अदिन तिनवालोर अमेसा जीवात मनदनुर. ");
INSERT INTO mrr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","देवुळदीपताह रेगतद जीवात मनदनद तिंडि ननान आंदन. बोर इद तिंडटुन तिनदनुर, ओर अमेसा जीवात मनदनुर. इद तिंडि नावा मेंदुल आंदु, इदिन नना दुनियातोरा पिसमुळतेनाह्‌कु ईकन,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","इदिन केंजिसि यहुदिर तमतमाय जेटामारा आतोर, “वेग़ मन्कल माक तना मेंदुल तिनदलाह, बेद्रम ईयनोग़, अय?” ");
INSERT INTO mrr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","अस्के (नना दुनियातोर कतमतोरा पापमतेनाह्‌कु मोक आयकन, एनवालोरिह्‌के अद मोकता पाय्दा दोर्किह्‌ता, इदिन पुन्पिह कीयलाह) येसु इह वळ्ह्‌कतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, नना माने-मन्कना नडुम पुटटोनन, नावा मेंदुदुन तिनवालेवा, ओसो नावा नेतुरतुन उनवालेवा, मीवा लोप्पा देवुळ ईयनद जीवा मनो आयग़ा, गोतो. ");
INSERT INTO mrr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","मति बोर नावा मेंदुदुन तिन्ह्‌तोर, नावा नेतुरतुन उन्ह्‌टोर, ओरिह्‌क अमेसाता पिसमुळ दोर्किह्‌ता. ओसो आक्रिता दियाते नना ओरिन जीवा अर्हतकन. ");
INSERT INTO mrr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","बाराह्‌क इतेके नावा मेंदुलि करलता तिंडि आंदु; ओसो नावा नेतुरि करलता उंदि उनडनद आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","बोर नावा मेंदुदुन तिनदनुर ओसो नावा नेतुरतुन उनडनुर, ओर नयगा जोळेम आस मनदनुर, ओसो नना ओरगा जोळेम आस मनदकन. ");
INSERT INTO mrr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","नाक लोहतोग़ जीवात मनवाल बाबाल, ओनाय मेटे नना वने जीवात मह्‌नन. अहलेह्‌का बोर नावा मेंदुदुन तिनदनुर, ओर वने नावा मेटे जीवात मनदनुर. ");
INSERT INTO mrr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","देवुळदीपताहि रेगतद करलता तिंडि ननान आंदन. मीवोर मुनेतोर पेदल्क मना तिन्ज तेला ओर डोलतोर, अद्रमलेह्‌का इद तिंड आयो. मति बोर इद तिंडटुन तिनदनुर, ओर अमेसा जीवात मनदनुर,” इन्जि येसु काग़्हतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","कापेर्नाटे मनदनद पार्तनाता लोते येसु काग़्हनेके, इव इचोक गोटिङ वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","इव गोटिङ केंजिसि, येसुनाङ कग़यवालोर वेल्‍लाटोर इतोर, “माकु एग़्ङ वास्ता, रा! इविन बोग़ केंजनोग़?” ");
INSERT INTO mrr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","नावाङ कग़यवालोर तमतमाय मुयोग़ आस्तोर इन्जि, येसु तना पोटालोप्पा पुतोग़. पुन्जि इतोग़, “मीक इव गोटिङ केंजिस, एग़्कुळलेह्‌का आस्ताया? ");
INSERT INTO mrr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","माने-मन्कना नडुम पुटटोनन, नना बेगा मुने मतन, अगा पोग़ोन मल्स दायनस्के, मीट नाक ऊळकिर अस्के, मीट बह इनदकिर? ");
INSERT INTO mrr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","मन्कना बुदते विचर केमाटु, ताना पाय्दा बातय इले. मति देवुळता जीवाताहि दोर्कनद बुदते ताकतेकेने, मीकु तानग्डाहि करलता पिसमुळ दोर्कग़ा. बेव गोटिङ नना मीक वेहतन, अव देवुळता जीवाताङ गोटिङ आंदुङ, अविन नमतेके मीकु करलता पिसमुळ दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","मति मियग्डाहि उय्तुर नावाङ पोल्‍लोन नमवोरिर मह्‌निर,” इनजोर येसु इतोग़. बाराह्‌क इतेके नमवोर बोरु, ओसो बोग़ नाक कोंटेतोरा कयदे पोसीयनोग़ इनजोर, येसु मुनेन पुन्ज मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","पया येसु इतोग़, “अदिह्‌क मीक नना वेहच मतन इसि, बाबाल देय्वा एवालेवा, बोग़े नयके वाया पग़वोग़ इनजोरे.” ");
INSERT INTO mrr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","अस्केडाहि येसुनाङ कग़यवालोर वेल्‍लाटोर, इंजेटाहि ओना संगे मनवल इनजोर, येसुन विळ्सिस मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","अस्के येसु तनाङ बळयिर बारा मांदतुन इतोग़, “मीट वने मल्स दायना कीय्ह्‌निरा?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","अस्के सिमोन पत्रु इतोग़, “आयो सामि, नीक विळ्सिसि माट बोनगा दाकोम? अमेसाता पिसमुळताङ पोल्‍लोङ नियगाने दोर्किह्‌ताङ! ");
INSERT INTO mrr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","निमाने देवुळ लोहतोग़ पवित्र मन्कनिन आंदिन इनजोर, माट विस्वस कीसि पुतोरोमे,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","“सिमोन, मीट बारा मन्कलोरिन ननान आचतन, निटमे! तेला मति मियग्डाहि वग़ोग़, देयमता बुदतोग़ु मन्ह्‌तोग़,” इनजोर येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(येसु इद पोल्‍लो सिमोन इनवाना मग़ि यहुदा इस्केर्योतना लोप्पा वळ्ह्‌कतोग़. ओर बळयिर बारा मुडग्डाहि वेग़ ओर्वोग़ मन्ज तेला, येसुन कोंटेतोरा कयदे पोस एवाल मतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","इव गोटिना पेग़्के, गालिल पटटाङ नाह्‌कने, येसु लोकुरिन काग़्हचोरे वेलियिंदोग़. यहुदिराङ पेदल्क ओन हव्कलाह ऊळिंदुर, अदिह्‌कु ओन्क यहुदा पटटे वेलिय वसो. ");
INSERT INTO mrr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","(अद तूकने यहुदा पटटा येरुसलेम सहरते, यहुदिरा पंडुम इतेके मंडाना पंडुम एरे एव्स मता.) ");
INSERT INTO mrr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","अस्के येसुनाङ तमोर येसुन इतोर, “दादा, नीवाङ कीयनव कबस्किन, नीवाङ कग़यवालोर ऊळना इन्जि, निमा इग्डाहि पेसिसि, यहुदा पटटे अन. ");
INSERT INTO mrr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","बोर सबेटोरगा तमा पेदिर दायना इनजोर ऊळिह्‌तोर, ओर कुस्क्ने मकिस बातय केवोर आस्तोर. अद्रमे निमा वने इद्रमताङ डीसाताङ कबस्क कीय्ह्‌निन इतेके, निमा दुनियातोरिह्‌क दिसा वने, ओर नीक पुनिर वने,” इन्जि ओनाङ तमोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","बह इतेके तनतमोर वने ओन नमोर आंदुर, अदिह्‌के ओर इद्रम इंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","अस्के येसु ओरिन इतोग़, “मीक इतेके बेदाय वेला बेसे, (हव्कवाल इलेग़, कोह्‌कवाल इलेग़). मति नावा अगा दायनद वेला इंका एवोये. ");
INSERT INTO mrr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","दुनियातोर मीक इतेक कोंटे कीया पग़वोर. मति ओराङ कबस्क लाग्वाङ मन्ह्‌ताङ इनजोर इह्‌नन, अदिनेनाह्‌क नाकु ओर कोंटे कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","9","मीट इद पंडुमते दायना इतेक अन्ह्‌टु, नना इसि इंजेके वावोन. बाराह्‌क इतेके नावा अगा दायनद वेला इंका एवोये,” इन्जि येसु गालिलतेन मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पया तनतमोर येरुसलेमते अतापया, येसु वने वेल्‍लाय पया, बोन्के दिसवाह पंडुमते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","अस्के यहुदिरा पेदा मन्कलोर पंडुमतगा ओन पर्ह्‌किंदुर. “ओग़ बेगा मन्ह्‌तोग़, रा?” इनजोर ताल्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","लोकुरा मुलु येसुना लोप्पा तमतमाय कुस्क-कुस्क वळ्ह्‌किंदुर. “आयो रा, ओग़ नेह्‌नोग़ मन्कल,” इन्जि उय्तुर इंदुर. उय्तुर बार इंदुर, “आयो रा, ओग़ लोकुरिन लेसिह कीस्तोग़ गोतो,” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","मति यहुदिराङ पेदल्किन रेयिसि, बोग़े येसुना लोप्पा पिङम-पङम वळ्ह्‌कोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","पया वळ्गा पंडुम मारतस्के, येसु मंदिरते अन्जि काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ओना काग़्हतनदिन केंजिसि, अग्डोर यहुदिराङ पेदल्क बयल आतोर, आसि इनदलातोर, “वेन्क बोग़े गूरु काग़्हवालेवा, पूरा सास्त्रमतुन पुनदलाह विदे बेग्डाह दोर्कता, रा?” ");
INSERT INTO mrr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","पया येसु ओरिन इतोग़, “केंजाटु, नावा काग़्हमुळि नावा बुदता आयो, मति नाक बोग़ लोहतोग़, ओनाय विचरता आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","मियग्डाहि बोग़ाय देवुळ वेहतप ताकनद विचर कीयनोग़, ओन्कु इव नना काग़्हतनव गोटिङ बारा नावाङो, आयवेक देवुळताङो इनजोर तेळियग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","तमाङे विचर्किन वळ्ह्‌कवालोर, तमाये पेदिरतुन बेरा कीयलाह ऊळिह्‌तोर. मति नाक बोग़ लोहतोग़, ओनाये पेदिरतुन बेरा कीकन इन्जि, बोग़ ऊळिह्‌तोग़, ओग़े सेतेमतोग़ मन्ह्‌तोग़, ओनगा बातय जोल मनो आस्ता. ");
INSERT INTO mrr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मोसा मुय्तोग़ इतेक मीकु अडोना सास्त्रम ईतोग़, तेन सीता कीम्ह्‌ट. मति मियग्डाहि वग़ोग़ वने अव अडोन माळोग़. मीटे बराबर माळविर इतेके, नाक बाराह्‌कु हव्कलाह ऊळिह्‌निर?” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","लोकुर पया येसुन इतोर, “नीक देयम पोयता रा, (पिसानलेह्‌का वळ्ह्‌किह्‌निन)! नीक बोग़ हव्कलाह ऊळिह्‌तोग़?” ");
INSERT INTO mrr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","येसु ओरिन इतोग़, “नना पोल्वादियाते उंद कबळ कीताह्‌कु, मीट सबेटोरिर बयल आसि, नाक कट्ला कीय्ह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","सास्त्रमते मोसा मुय्तोग़ मीकु डायना रिवज कीयलाह वेहच मतोग़. (ओग़ वेहतपु, पेकाल पुटिसि आट दियाने डायना रिवज कीया पोयह्‌ता.) (इद रिवज इतेके मोसा मुय्तोनग्डाह आयो, मति मोसाह्‌काय वेल्‍ला मुनेतोर पेदामुय्तोरग्डाहि ताकसोर वातद, अद रिवज आंदु). वारमता पोल्वादिया मतेक वने, अद कगो एवतेके, मीवाङ पेकोराङ डायना कबळ कीय्ह्‌निरे. ");
INSERT INTO mrr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","मोसा मुय्तोग़ वेहतद अडोतुन अदे कगोते नोमना इन्जि, मीट पोल्वादियाते वने मन्कन डायना कबळ कीय्ह्‌निर इतेके, नना पोल्वादियाते वग़ोग़ मन्कना पूरा मेंदुदुन सव्रे कीताह्‌कु, मीटु बाराह्‌कु पया नाक ओङ कीय्ह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","विचर केवालेवा पोग़-पोग़ोन नाक कसुर तासमाटु, मति सेतेमताङ गोटिङ ऊळिसि, कसुर तासना इतेक तासाटु,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","अस्के येरुसलेमतोर उय्तुर इतोर, “बोन हव्कलाह ऊळिंदुर, ओग़ वेग़ेया? ");
INSERT INTO mrr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ऊळाट, वेग़ बेद्रम पिङम-पङम वळ्ह्‌किह्‌तोग़, मति ओर इसि वेन रोमिह केवोर. वेग़ देवुळ लोहवाल पिसिह केवाल आंदोग़ इनजोरे, मावोर पेदल्क सेतेम पोयतोरा? ");
INSERT INTO mrr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","मावा विचरते देवुळ लोहवाल पिसिह केवाल वायनोग़ अस्के, ओग़ बेग्डोग़ इनजोर, बोग़े पुनोग़ आयनोग़. मति वेग़ बेग्डोग़ इनजोर माट पुह्‌नल. (इतेके वेग़ देवुळ लोहवाल पिसिह केवाल बह आंदोग़?)” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","अस्के येसु मंदिरते काग़्हनेके बेह्‌राङ वळ्ह्‌कतोग़, “‘माट नीक पुह्‌नोम, ओसो निमा बेग्डोनिन इन्जि माक एर्काय,’ इनजोर इह्‌निर. नना नावाय विचरते वावोन. मति नाक लोहतोग़ ओग़ सेतेमतोग़ आंदोग़, ओन मीट पुनविर. ");
INSERT INTO mrr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","नना मात्रम ओन पुह्‌नन, बाराह्‌क इतेके नना ओनग्डाह वातन, ओग़े नाक लोहतोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","इद पोल्‍लोतेनाह्‌क, बोरो उय्तुर यहुदिराङ पेदल्क, येसुन पोयतलाह ऊळिंदुर. मति ओना हायना कगो एववाय मताह्‌कु, ओन बोग़े बोय पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","तेला मति अग्डा मुडग्डाहि वेल्‍लाटोरे येसुन नमतोर. “देवुळ लोहवाल पिसिह केवाल वायनोग़ अस्के, वेन्काय एक्‍वा बामिह कीयनाङ सीनाङ तोहतनोग़ा?” इन्जि ओर इनदलातोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","इव गोटिङ वेर लोकुर येसुना लोप्पा कुस्क-कुस्क वळ्ह्‌किंदुर. वेर बाताङ वेहतह्‌तोर, इदिन पुन्जि पेर्मालोर ओसो परुसिर येसुन पोयतलाह, मंदिरतगा पह्‌रा मनवालोरिन लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","अस्के येसु इतोग़, “नना ओसो गय्क मीवा संगे मह्‌नन, पया नना नाक लोहतोनगा पेसिस दाकन. ");
INSERT INTO mrr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","मीट नाक पर्ह्‌ककिर, मति नना मीक दोर्कोन आयकन. ओसो बेगा नना मनदकन, अगा मीट वाया पग़विर आयकिर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहुदिराङ पेदल्क तमतमाय वळ्‍ह्‌कलातोर, “माट पर्ह्‌कतेकाय दोर्कवाह, वेग़ बेगा दायनोग़, रा? दुस्राङ देसेह्‌कने बिरोबटो आस मनवालोर मावा लोकुरिन, काग़्हतनोग़ा, दुस्रा जाततोरिन वने काग़्हतनोग़ा? ");
INSERT INTO mrr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘मीट नाक पर्ह्‌ककिर, मति नना मीक दोर्कोन आयकन. ओसो बेगा नना मनदकन, अगा मीट वाया पग़विर आयकिर,’ इन्ह्‌तोग़. इद बेद्रमता पोल्‍लो आंदु?” इनजोर पेदल्क इंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","पंडुमता मारेंगा बेरा दियाते, येसु तेदिसि बेह्‌राङ वळ्ह्‌कतोग़, “बोरिह्‌क एग़ उनडा वसता, ओर नयगा वास उनिर. ");
INSERT INTO mrr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","सास्त्रमते रासतपु, बोर नाक नमनुर, ओरग्डाहि जीवात मनदनद एताङ बेरेह्‌क पोङनुङ,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","येसुन नमवालोरिह्‌क देवुळता जीवा दोर्कना मता, अदे जीवाता लोप्पा येसु इद पोल्‍लो वळ्ह्‌कतोग़. (येसु हातोग़, तेग़्कतोग़, पया देवुळतके मल्स अतोग़, अस्के) ओन्क देवुळताहि मान दोर्कता.(दोर्कतस्के ओग़ पवित्र जीवातुन बूमते लोहचीतोग़.) मति अद कगो इंका एववाय मता, अदिह्‌के पवित्र जीवा बोनगान रेगवाय मता, इनजोर इह वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","अस्के अगा मता मुडग्डाहि उय्तुर, इव गोटिङ केंजिसि, “निटमे रा, मोसानलेह्‌का देवुळता कबुरतोग़ वायना मता, ओग़ वेग़े आंदोग़!” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ओसो उय्तुर बारा, “आयो, वेग़ देवुळ लोहवाल पिसिह केवाल आंदोग़,” इनजोर इतोर. ओसो दुस्रोर इतोर, “देवुळ लोहवाल पिसिह केवाल गालिलताह बह वाया पग़यनोग़? ");
INSERT INTO mrr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ओग़ इतेके दाविद राजाना कूळतोग़ आयनोग़, ओसो दाविद राजाल बेद बेत्लेहेम नाटे मतोग़, अग्डाहि वायनोग़, इनजोर सास्त्रमते बह रासतद इलेया?”(येसु गालिल पटटे पुटिस मनदनोग़ इनजोरे, ओर अह इंदुर.) ");
INSERT INTO mrr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","इद्रम आसि येसुनेनाह्‌कु वेर तमतमाय वह्‌चिसि, वेरा बोना-बोन्क अरवाह्‌कु, जेटामारा आतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","अस्के पया ओरग्डोर उय्तुर येसुन पोयतलाह ऊळिंदुर, मति बोग़े ओन कय बोयोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","पया ओर मंदिरताङ पह्‌रातोर पेर्मालोरक्‍के ओसो परुसिरक्‍के मल्स वातोर. अस्के वेर पह्‌रातोरिन ताल्ह्‌कतोर, “ओन मीट बाराह्‌क पोस तविर रा?” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“ओग़ मन्कल वळ्ह्‌कतपु, बोग़े दुस्रोग़ बेस्केन वळ्ह्‌कोग़!” इन्जि मंदिरताङ पह्‌रातोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","पया परुसिर ओरिन इतोर, “बह, मीट वने नाळेम आतिरा? ");
INSERT INTO mrr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","माट यहुदिराङ पेदल्कनोम आयि, परुसिरोम आयि, वेर बोराय ओन नमिह्‌तोरा? ");
INSERT INTO mrr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","मति वेर येसुना पयाह अनवालोरु, मोसानाङ अडोन पुनोर, बातान पुनोर, वेरिन देवुळि एळतग़ाये!” इनजोर परुसिर वेग़्हतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","मुने येसुनके कुस्क्ने वास मतोग़, निकोदेमि इनवाल, वेग़ वने परुसिराय संगतोग़ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“मावाङ अडोङ मतपु, मुने मन्कना पोल्‍लो केंजना, ओग़ बाताल कीस्तोग़ अदिन ऊळना, पया ओन तपतिन इतेके ओजग़ा. मन्ह्‌ताया, इले?” इनजोर वेग़ पेदल्किन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ओर पया वेन इतोर, “बह, निमा वने गालिल पटटोनिना? अन, सास्त्रमते पर्ह्‌किस ऊळा, गालिलताहि बोग़े देवुळता कबुरतोग़ वावोग़!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","पया ओर कतमतोर तमाङ-तमाङ लोह्‌क अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ओर अतस्के येसु जय्तुन मराना मेटातेके अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","पया पंङवियतस्के, ओग़ ओसो मंदिरतगा वातोग़, अस्के वेल्‍लाटोर लोकुर ओनगा वातोर. अस्के येसु उदिसि ओरिन काग़्हता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","ओग़ काग़्हनेके, सास्त्रमगूरुर ओसो परुसिर, वेरु सिंड्रि कबळ कीयह्‌पा दोर्किह कीतदु उंद आंचानु, ओनगा पोस ततोर. तान पया लोकुरा नडुम निल्पिह कीसि, येसुन इतोर, “गूरु, इद आंचाळि ओर्विन कवयह्‌पा, माट तेन पोयतोम. ");
INSERT INTO mrr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","इद्रमता आंचानु बंडाङ उकिस हव्कना इनजोरे, मोसा मुय्तोग़ माकु अडोना सास्त्रमते वेहच मतोग़. इतेके इदिनलोप्पा माक निमा बाताल वेहतह्‌निन?” इनजोर येसुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","येसुन कसुरते पोयतलाह माक अग़ दोर्कना इन्जि, ओन एग़्किह कीयलाह इद्रम इतोर. मति येसु इतेके इळ्न ओल्‍लिसि, नेदगा वेळ्न्जते बाताङो रासलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","8","मति ओर उंदि अट पोसि ओन ताल्ह्‌किंदुर, अदिह्‌कु ओग़ तेदिसि ओरिन इतोग़, “अले, अह इतेके मियग्डाह बोग़ पापमलेवोग़ मन्ह्‌तोग़, ओग़े तेन मुने बंडा उकेग़,” इन्जि ओग़ ओसो ओल्‍लिसि, नेदगा रासलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ओना पोल्‍लो केंजिसि, आंचान पोस ततोरु, वेर कतमतोरु, मुने मुय्तोर, पया लेयोर, इद्रम वग़ोग़-वग़ोग़ पेसिस अतोर. ओर अतस्के येसु अगा वग़ोग़े मतोग़, ओसो अद आंचाळि अगान नडुम निच मता. ");
INSERT INTO mrr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","पया येसु तेदिस ऊळतस्के, (अद आंचान विळ्सिस अगा बोग़े इलोग़). अस्के तान इतोग़, “पेडि, नीक तप तोहवालोर बेक अतोर? नीक बोग़े सिक्सा ईयलाह तयर इलोग़ा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“गूरु, नाक बोग़े बातय इनोग़,” इन्जि इता. “नना वने नीकु सिक्सा ईयलाह तयर इलेन. अन, इंजेटाहि निमा नीवा पापमतुन विळ्सिस मन,” इनजोर येसु तान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","अस्के मंदिरते, येसु ओसो ओरिन काग़्हता बोटटोग़. “ननाने दुनियाता वेह्‌चतन आंदन. बोर नावा संगे वास्तोर, ओर ईकळते बेस्केन ताकोर आयनुर, मति ओरगा देवुळ ईतद जीवातेके ओसीयनद वेह्‌च मनदग़ा.” ");
INSERT INTO mrr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","अस्के परुसिर येसुन इतोर, “निमा वग़ोनिन नीवाय लोप्पा साक्सि ईय्ह्‌निन इतेके, नीवा साक्सि ताको,” इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","येसु पया ओरिन इतोग़, “नना वग़ोनन कुदि नावाय लोप्पा साक्सि ईतेकाय, नावा साक्सि ताकिह्‌ताये, बह इतेके नना बेग्डाह वातन, ओसो बेगा दाय्ह्‌नन, इद नाक एर्काय मन्ह्‌ता. मति नना बेग्डाह वातन ओसो बेगा दाय्ह्‌नन, इदिन मीट पुनविर. ");
INSERT INTO mrr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","मीट इतेके मन्कना बुदते नेयम कीय्ह्‌निर; मति नना बारा बोनाय नेयम केवोन. ");
INSERT INTO mrr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","कीतेक तेला, नावा नेयम सेतेमता मन्ह्‌ता; बाराह्‌क इतेके नना वग़ोनन आयोन, मति नाक लोहतोग़ बाबाल नाक तोळ मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","केंजाटु, कमसेकम इर्वुरा साक्सि सेतेम ताकिह्‌ता इन्जि, मीवाङ अडोना सास्त्रमते रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","अद्रमे नना नावाय लोप्पा साक्सि वेहवानन, ओसो नाक लोहतोग़ बाबाल वने नावा लोप्पा साक्सि ईस्तोग़,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","तेन केंजिस ओर ताल्ह्‌कतोर, “अह इतेक नीवा बाबाल बेगाडोग़?” ताल्ह्‌कतस्के, “नना निटम बोनन आंदन, इदिन मीट पुनविर, ओसो नावा बाबान वने पुनविर. मीटु नाक पुन्ज मतेके, नावा बाबान वने पुनेरिर,” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","मंदिरतगा दान वाटनद संदुककचुल काग़्हनेके, येसु इव गोटिङ वळ्ह्‌कतोग़. तेला मति ओन बोरे पोयोर, बाराह्‌क इतेके ओना हायना कगो एववाय मता. ");
INSERT INTO mrr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ओसो उंद देबा येसु ओरिन इतोग़, “नना पेसिस दाकन, अस्के मीट नाक पर्ह्‌ककिर. मीट मात्रम मीवा पापम मापि आयवाये हायकिर. बेगा नना दाकन, अगा मीट वाया पग़विर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","अस्के यहुदिराङ पेदल्कु तमतमाय वळ्ह्‌किंदुर, “‘बेगा नना दाकन, अगा मीट वाया पग़विर,’ इद्रम वेग़ बह इन्ह्‌तोग़? तना जीवातुन तनाय पोहतनोग़, बहे,” इद्रम इंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ओग़ पया ओरिन इतोग़, “मीट इळ्ता बूमताहि, मति नना पोग़ोटा बूमताहि. मीट इद दुनियातोरिर, मति नना इद दुनियातोनन आयोन. ");
INSERT INTO mrr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","अदिह्‌कु पापम मापि आयवाये हायकिर इन्जि, नना मीक वेहतन. बाराह्‌क इतेके नना बोनन आंदन इनजोर नना वेहतनद पोल्‍लोतुन, मीट विस्वस केवेके, मीटु मीवा पापम मापि आयवाये हायकिर,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“अह इतेक निमा बोनिन?” इन्जि ओर ओन ताल्ह्‌कतोर. येसु ओरिन वेहतोग़, “मीक मुनेताहि वेहचोर वातन, ओनन आयोना? ");
INSERT INTO mrr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","मीवा लोप्पा वळ्ह्‌कलाह, ओसो मीवा नेयम कीयलाह, नयगा वेल्‍लाङे गोटिङ मन्ह्‌ताङ. मति नाक बोग़ लोहतोग़, ओग़े सेतेम वळ्ह्‌किह्‌तोग़, ओनग्डाहि केंजताङ गोटिने, नना दुनियातोरिह्‌क वेहतह्‌नन,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","मावा संगे वेग़ु देवुळबाबानाये लोप्पा वळ्ह्‌किह्‌तोग़ इनजोर, ओरिह्‌क तेळियो आसि. ");
INSERT INTO mrr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","अदिह्‌के येसु ओरिन इतोग़, “मीट माने-मन्कना नडुम पुटटोन्कु गुटातगा पोग़ोन वेळ्ह्‌तकिर, अस्केने नना बोनन आंदन इनजोर मीक तेळियग़ा. ओसो नना कुद आसि बातय केवोन, मति बाबाल नाक काग़्हतपु, नना इव पोल्‍लोङ वळ्ह्‌किह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","बोग़ नाक लोहतोग़, ओग़ नाक तोळ मन्ह्‌तोग़. बेव कबस्क ओन्कु गिर्दा वास्ताङ, अवे कबस्क नना अमेसा कीसोर मह्‌नन, अदिह्‌के ओग़ नाक वग़ोने विळ्सिस एवोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","इव गोटिङ ओग़ वळ्ह्‌किह्‌पा, वेल्‍लाटोरे ओग़ देवुळ लोहतोग़ राजाल आंदोग़ इन्जि नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","बोर यहुदिर येसुन नमिह्‌नोम इतोर, ओरिन ओग़ इतोग़, “मीट निटमे नावाङ कग़यवालोरिर आय्ह्‌निर इतेके, मीट नावा पोल्‍लोते तिरियकिर. ");
INSERT INTO mrr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","अस्के मीट सेतेमतुन पुनदकिर, अद सेतेम मीकु विळ्सिह कीयग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“माटु अब्रहम मुय्तोना कूळतोरोम आंदोम, बोनाय बेस्केने कय इळ्न दोहतप मनोम. इतेके अद सेतेम मीकु विळ्सिह कीयग़ा इनजोर, निमा बह इह्‌निन?” इन्जि वेर कोंटेतोर यहुदिर येसुन कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, बोर मन्कलोर पापम कीसोर मन्ह्‌तोर, पापमताङ विचर्क ओरिन आव्रे कीस्ताङ. ");
INSERT INTO mrr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","केंजाटु, माल्काना लोते ओर्युदोन्क अमेसा मनदनद अदिकर इले, मति मग़िह्‌क इसि मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","अदिनेनाह्‌क नना देवुळता मग़नन मीकु विळ्सिह कीतेके, मीट निटमे पापमताङ विचर्कनाह पिह्‌ट अरयकिर. ");
INSERT INTO mrr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मीटु अब्रहम मुय्तोना कुट्मळतोरिर इनजोर, नाक एर्काये. तेला मति मीवा जीवाते नावाङ पोल्‍लोङ गडोङ इनजोर, मीटु नाकु हव्कलाह कोहतह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","बेव गोटिङ नना नावा बाबानगा मतस्के ऊळतन, अविने नना वेहतह्‌नन. अद्रमे मीट वने मीवा बाबानाहि केंजतव गोटिने मीट कीय्ह्‌निर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“मावा बाबाल अब्रहमिये आंदोग़!” इनजोर वेर इतोर. अस्के पया येसु इतोग़, “मीट अब्रहम मुय्तोनाङ मग़्कनिर मतेके, अब्रहमना लेह्‌का, बेसताङ कबस्क केवेरिर. ");
INSERT INTO mrr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","मति इंजेके नना देवुळताहि केंजतद सेतेमता पोल्‍लोतुन मीक वेहतन, तेला मति नाके मीट हव्कलाह कोहतह्‌निर. अब्रहम इतेके इद्रमताङ कबस्क केवोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","बोग़ मीवा बाबाल करले मन्ह्‌तोग़, ओनाङे कबस्क मीट कीय्ह्‌निर.” अस्के पया वेर इतोर, “माट इतेके पोर्ह्‌का पेकोरलेह्‌का पुट वावोम! मति माक वग़ोग़े बाबाल मन्ह्‌तोग़, इतेके देवुळबाबाले!” ");
INSERT INTO mrr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","अस्के येसु ओरिन इतोग़, “देवुळबाबाल मीवा बाबाल आस मतेके, मीट नाक जीवा केवेरिर; बाराह्‌क इतेके नना देवुळताहि पेसिस वातोनन आंदन. नना नावाय गिर्दाते इद बूमतगा वावोन, मति नावा बाबाल लोहताह्‌के, नना वातन. ");
INSERT INTO mrr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","नावाङ पोल्‍लोङ मीक बह केंज वसो. अदिह्‌के नना वेहतनव गोटिङ मीक तेळियोङ. ");
INSERT INTO mrr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","मीट देयह्‌कना मुक्यानाङे मग़्कनिर! अदिह्‌के तानाङे लाग्वाङ कबस्क मीट कीयलाह ऊळिह्‌निर. अद मुनेताहि मन्कन हव्के आंदु. ओसो तानगा बातय सेतेम इले, अदिह्‌क अद बेस्केन सेतेमतुन पोस मनो. ताना बुदिय जोल वळ्ह्‌कनद आंदु, बाराह्‌क इतेके अद जोलहाल ओसो जोलतुन पुटिह कीयनद आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","मति नना मीक सेतेम वेहताह्‌कु, मीट नाक नमविर. ");
INSERT INTO mrr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","नना पापम कीतन इन्जि, मियग्डाहि बोग़ाय तोहता पग़यनोग़ा? नना सेतेम वेहतेकाय, मीट नाक बाराह्‌कु नमविर? ");
INSERT INTO mrr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","बोर देवुळता लोकुर मन्ह्‌तोर, ओरु देवुळताङ गोटिङ केंजिह्‌तोर. मीट मात्रमि देवुळता लोकुरिर आयविर, अदिह्‌के मीट केंजविर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","अस्के यहुदिराङ पेदल्क येसुन इतोर, “निमा सामरितोनिन पर्गेनिन, नीक देयम पोयता इनजोर माट इह्‌नोम, अद बह जोलिया?” ");
INSERT INTO mrr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","येसु ओरिन इतोग़, “आयो, नाक देयम पोयो. मति नना नावा बाबाना कदर कीय्ह्‌नन; मीट इतेक नावा कदर रेहतह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","नना नावा मानतुन ऊळोन. नावा मान ऊळवाल ओर्वोग़ मन्ह्‌तोग़, नावा बाबाल. बोग़ सेतेम, बोग़ जोल, ओन्के नेयम कीयलाह अदिकर मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","इह केंजाट, नना सेतेम वेहतह्‌नन, बोर नावाङ पोल्‍लोङ केंजिस, अहलेह्‌का तिरियनुर, ओर बेस्केन हायोर आयनुर.” ");
INSERT INTO mrr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","(ओग़ु मेंदुदा हामुरता लोप्पा वळ्ह्‌किह्‌तोग़ बहे इनजोर,) यहुदिर ओन इतोर, “नीक देयम पोयता ऊळा, इंजेक माट पुतोम. अब्रहम वने डोलतोग़, देवुळता कबुरतोर वने डोलतोर. निमा मात्रम इह्‌निन, ‘बोर नावाङ पोल्‍लोङ केंजिस अहलेह्‌का तिरियनुर, ओर बेस्केन हायोर आयनुर,’ इह्‌निन. ");
INSERT INTO mrr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","मावा मुनेतोग़ पेदामुय्तोग़ अब्रहमि डोलतोग़, ओन्काय निमा बेरोनिना? देवुळता कबुरतोर वने डोलतोर. इतेक निमा बोनिन आंदिन, बाताङ वेहतह्‌निन?” इन्जि वेर ओन पळ्मिङ ईतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","येसु ओरिन इतोग़, “नना नाके कदर ईतेके, अद कदरता बातय पाय्दा इले. मति बोन मीट ‘मावा देवुळबाबाल आंदोग़,’ इनजोर इह्‌निर, ओग़े नावा बाबाल नाक कदर ईस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","मीट ओन पुनविर, मति नना ओन पुह्‌नन. ओसो नना ओन पुनोन इनजोर इनदकन इतेक, नना मीवा लेह्‌का जोलतोनन आयकन. मति नना इतेक ओन पुह्‌नन, ओसो ओनाङ पोल्‍लोङ केंजिस, अह तिरियिह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","मीवा मुनेतोग़ पेदामुय्तोग़ अब्रहमि, नावा वायनद वेलातुन ऊळसोर, पका गिर्दा आतोग़. ऊळिंदोग़ वने, ओसो गिर्दा आंदोग़ वने,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“नीक इंका वळ्गा वय्स तेला आयोये, इतेके निमा अब्रहम मुय्तोन बह ऊळतिन?” इनजोर यहुदिर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","येसु ओरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, अब्रहम मुय्तोह्‌काय सुरुमुनेतोनन नना मतन, इंजेक ओसो मह्‌नन!” ");
INSERT INTO mrr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तेन केंजिस, (येसु ननान देवुळतन इतप वळ्ह्‌किह्‌तोग़ इन्जि, वेर पुतोर.) पया ओङ आसि, येसुन उकलाहि बंडाङ पेह्‌कतोर. मति येसु ओरग्डाहि कुस्क्ने मंदिरताहि पेसिस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","अग्डाहि पेसिस दायह्‌पा, येसुह्‌कु वग़ोग़ पुटगुडि कलियतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","अस्के येसुनाङ कग़यवालोर ओन ताल्ह्‌कतोर, “गूरु, वेग़ निटम बोनायो पापमतेनाह्‌के गुड पुट वातोग़. इतेके वेनाये पापमतुह्‌क, बारा वेनाङ तलोग़-तपेर कीतद पापमतुह्‌क वेग़ गुड पुट वातोग़ा?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","अस्के येसु ओरिन इतोग़ “वेग़ पापम कीताह्‌कु आयो, ओसो वेनाङ तलोग़-तपेर पापम कीतोर इन्ज गुड पुट वावोग़, मति वेना मेंदुदगा देवुळता बेरा लाव दिसना इन्जि, वेग़ इद्रम पुट वातोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","नावा बाबाल बेव कबस्क कीयलाह नाक लोहतोग़, अविन नाकु वेह्‌च मनेकेने, इतेके इद बूमते मनेकेने, कीया पोयह्‌ता. बह इतेके उचुके दियाना पया ईकळ वायनद मन्ह्‌ता, अस्के बोन्के कबळ कीया वावो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","नना इद दुनियाते मनाह्‌जोम, इद दुनियाता वेह्‌चतन आंदन.(इद्रमता गुडलेह्‌काडोरिन वेह्‌च ईया पग़यह्‌नन.)” ");
INSERT INTO mrr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","इचोन इन्जि, ओग़ नेदगा उस्कतोग़, उस्कुलते तोळ्यो पिस्कतोग़. अह कीसि ओग़ पुटगुडिनाङ कोंडानगा अद तोळ्योतुन ओकिसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","पया येसु ओन इतोग़, “अन, सीलो इनदनद वेच्‍चातगा अन्जि मोकम नोग़्म,” इन्जि ओन लोहतोग़ (“सीलो” इद पेदिर इतेके लोहतोग़ु). पया ओग़ गुडि अन्जि कन्क ऊरतस्के, ओग़ तोवयलाह आतोग़, आसि लोन अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","मुने बिचेम ताल्ह्‌किह्‌पा बोर ओन ऊळिस मतोर, ओसो ओनाङ एरेगूरेतोर ओन ऊळिस इंदुर, “उदिस बिचेम ताल्ह्‌किंदोग़, ओग़ वेग़ेया?” ");
INSERT INTO mrr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","बोर बोर इतोर, “इंगो, वेग़ बिचेम ताल्ह्‌कवाले!” ओसो उय्तुर इतोर, “आयो रा, वेग़ बिचेम ताल्ह्‌कवाल आयोग़, ओनाय लेह्‌का दिसवाल बोग़कोटे मनदनोग़, रा!” इनजोर इंदुर. अस्के वेग़ गुडि इनदलातोग़, “ननान रा, बिचेम ताल्ह्‌कवानन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“नीवाङ कोंडाङ पया बह बेस आताङ, डा?” इन्जि लोकुर ओन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ओग़ इतोग़, “येसु पेदिरतोग़ वग़ोग़ मन्कल तोळ्यो पिस्किसि, नावाङ कोंडाह्‌कु ओकिसि, ‘सीलो वेच्‍चातगा अन्जि कन्क ऊरा,’ इतोग़. अस्के पया नना अन्जि कन्क ऊरतन, कन्क ऊरताहे नना इंजेके तोवयह्‌नन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","लोकुर ओन ओसो ताल्ह्‌कतोर, “अह इतेके ओग़ येसु बेगाडोग़?” “बारायो, नना पुनोन,” इन्जि ओग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","पया ओर लोकुर गुडि आस मतोनु परुसिरक्‍के पोस ततोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(बेद दिया येसु तोळ्यो पिस्किसि, ओकिसि, पुटगुडिन बेस कीतोग़, अद दिया वारमता पोल्वादिया आंदु.) ");
INSERT INTO mrr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","पोस ततापया, परुसिर वने “निमा बह तोवयह्‌निन?” इन्जि ओन ताल्ह्‌कतोर. ओग़ इतोग़, “नावाङ कोंडाह्‌कु ओग़ तोळ्यो ओकतोग़, अस्के नना अन्जि कन्क ऊरतन, कन्क ऊरताहे नना इंजेके तोवयह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","तेन केंजिस उय्तुर परुसिर इतोर, “ओग़ मन्कल देवुळताह इलेग़, मतेके ओग़ पोल्वादियाते इद सव्रे कीयना कबळ केवोग़ आवेग़.” ओसो उय्तुर इतोर, “इंगो मति बोग़ाय पापि मन्कल, इद्रमताङ बेह्‌राङ सीनान बह तोहता पग़यनोग़?” इद्रम तमतमाय वह्‌चिसि, ओर रेंड तुंगाङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","अदिह्‌कु ओर ओसो उंद देबा ओन पुटगुडिन ताल्ह्‌कतोर, “ओग़ नीवाङे कोंडान बेस कीतोग़ इन्जि, ओग़ बेद्रमतोग़ मन्कल इनजोर निमा इह्‌निन?” इतोर. “एय, ओग़ देवुळता कबुरतोग़ मनदनोग़ इह्‌नन,” इन्जि ओग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","ओग़ गुडि मतोग़, मति इंजेके तोवयलाह आतोग़ इनजोर, यहुदिराङ पेदल्क नम्का पोयवाये मतोर. अदिह्‌कु तोवयलाह आतोग़ गुडिना तलोग़-तपेन ओर केयतोर, केयिसि ताल्ह्‌कतोर, “बह, वेग़ मीवाये पेकाला? मीवाये पेकाल इनजोर इतेके, निटमे वेग़ गुड पुट वातोग़ा? अह इतेक पया वेग़ बह तोवयलाह आतोग़?” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","पया वेना तलोग़-तपेर इतोर, “एय, वेग़ मावाय पेकाल आंदोग़, ओसो वेग़ पुटिय तोववोग़ आस मतोग़, इद माक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","मति इंजेके वेग़ बह तोवयह्‌तोग़ो, इदिन माट पुनोम. ओसो वेनाङ कोंडान बोग़ पङ्ने कीतोग़, अदिन वने माट पुनोम. वेने ताल्ह्‌काटे, वेग़ इंजेके लेयोग़े आतोग़. बह आतदिन तनाय वेहतनोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","यहुदिराङ पेदल्किन रेयिसि, वेना तलोग़-तपेर अह इतोर. बाराह्‌क इतेके देवुळ लोहवाल पिसिह केवाल येसु आंदोग़ इनजोर, बोग़ कबुल कीयनोग़, ओग़ मावा मोळ्कनगा वायनायो इन्जि, यहुदिराङ पेदल्क कतमतोर उकुम ईस मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","अदे रेयतुह्‌कु गुडिना तलोग़-तपेर “वेग़ इंजेके लेयोग़े आतोग़, वेने ताल्ह्‌काट!” इनजोर इन्ज मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","अदिह्‌क पुटगुडिन ओर परुसिर ओसो उंद मल्का केयिस इतोर, “देवुळता मुनेह किरिया कीसि, नीक बह आतदिन सेतेमते वेहा. बाराह्‌क इतेके वेग़ मन्कल पापमतोग़ इनजोर माट पुह्‌नोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“ओग़ पापमतोग़ो, बेद्रमतोग़ो, नना पुनोन. मति सिरप उंदिय पोल्‍लो नना पुह्‌नन, मुने नना तोवोन आसि, इंजेके नना तोवयह्‌नन,” इन्जि ओग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“अह इतेक ओग़ नीक बाताङ कीतोग़, नीक बह तोवनाह कीतोग़?” इन्जि परुसिर ओन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“इंजेकेन मीक वेहन्दन बहे, तेला मति मीट केंजविरा? मीक ओसो उंद मल्का बाराह्‌क केंजना मन्ह्‌ता? बह मीट वने ओनाङे कग़यवालोर आयना मन्ह्‌ताया?” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","अस्के ओर ओन सेरसेर वळ्ह्‌कतोर, “निमाने ओनाङ कग़यवानिन! माट इतेके मोसानाङ अडोङ नोमवालोरोम आंदोम, पुतिन! ");
INSERT INTO mrr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","देवुळि मोसा मुय्तोनु वळ्ह्‌कता इन्जि, माक एर्काये. मति वेग़ मन्कल बेग्डोग़ो, इदिन माट पुनोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","अस्के पया पुटगुडि ओरिन इतोग़, “इदे कोनि बेरा बामनद पोल्‍लो! ओग़ बेग्डोग़, इदिन मीट पुनविर, मति ओग़ इतेके नाक तोवनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","देवुळि पापि मन्कलोरा ताल्ह्‌कनदिन केंजो इनजोर, माक एर्काये. मति बोर देवुळतुन मोळ्किसि ताना पोल्‍लोते तिरियिह्‌तोर, ओरा ताल्ह्‌कनदिन देवुळ केंजिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","केंजाटु, पुटगुडिनु तोवनाह कीतोग़, इद्रमता गोटि बूम पटटग्डाह बेस्केन आयो! ");
INSERT INTO mrr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ओग़ मन्कल देवुळतग्डाह वावेके, वेन्क इद्रमलेह्‌का बातय कीया वावो आवालि,” इन्जि परुसिरिन पुटगुडि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","अस्के ओर ओन गुडिन इतोर, “नीक इतेके पुटटाहे पापमता सिक्सा दल्गता, माक निमा काग़्हतह्‌निन?” अह इनजोर ओन पलत पेहचीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","परुसिर पुटगुडिन पलत पेहचीतोर इनजोरे, येसुह्‌क इद पोल्‍लो एर्का आता. अस्के ओन पर्ह्‌किसि कलियतस्के, येसु इतोग़, “बह निमा माने-मन्कना नडुम पुटटोन नमिह्‌निना?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“ए गूरु, नना ओन नमना इन्जि, ओग़ बोग़ आंदोग़, नाक वेहा,” इन्जि ओग़ येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","अस्के येसु ओन इतोग़, “निमा इतेक ओन ऊळतिन, नीवा संगे इंजेक वळ्ह्‌कवानन, ओनन ननाने,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“ए सामि, नना नमिह्‌नन,” इह इन्जि ओग़ येसुन दंडुम अरतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","“नना लोकुरा पापम तोहतलाहि इद बूमते वातन. बोर लोकुर माट गुडिरा लेह्‌का ईकळते ताकिह्‌नोम इनजोर पुन्ह्‌तोर, ओरिह्‌क देवुळता वेह्‌च दिसग़ा, इदिनेनाह्‌क इद बूमते वातन. ओसो बोर तोवयह्‌नोम इन्ह्‌तोर, ओर निटमे तमा बुदते गुडिर इन्जि नना तोहतकन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","अस्के अगा मतोर उय्तुर परुसिर इदिन केंजिसि, “बह माट वने बुदते गुडिरोम इनजोर इह्‌निरा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","अस्के येसु ओरिन इतोग़, “‘माट गुडिरा लेह्‌का ईकळते ताकिह्‌नोम, (मति तोवयलाह, देवुळताहि कग़यलाह माक गिर्दा मन्ह्‌ता,’) इद्रम मीट इन्ज मतेके, मीवा कसुर मनो आवालि, (देवुळि मीक मापि केवालि). मति माट तोवयह्‌नोम, (पूरा पुतोरोम) इनजोर इह्‌निर. अदिह्‌के मीवा पापम अहे मन्ह्‌ता, (देवुळि मीक मापि केवो,)” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","येसु पया लोकुरिन इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, बोग़ गोरे गोवुळतगा अग़देनाहि लोप्पा नेङवा, दुस्रा बाजेताह तग़्ङिस दास्तोग़, ओग़ु कले, बेरा डाकु आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","मति बोग़ अग़देनाहि लोप्पा नेङिह्‌तोग़, ओग़े गोरे कोपाल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ओनेनाह्‌के राका केवाल अग़दुन तेग़यिह्‌तोग़. ओनाय आल्कातुन गोरेङ केंजिह्‌ताङ. ओग़ तनाङ गोरेनु उंद-उंदता पेदिर पोस केयिह्‌तोग़, केयिसि अविन पलत पेहच ओस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","तनाङ कतम गोरेङ पलत पेहतस्के, ओग़ अविस्कना मुनेह दास्तोग़. ओना पयाह पयाह गोरेङ वने दास्ताङ, बाराह्‌क इतेके अवु ओना आल्कातुन पुन्ह्‌ताङ इनजोरे. ");
INSERT INTO mrr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पुनवोना पेग़्के अव बेस्केन अनोङ आयनुङ, मति ओनग्डाहि वितनुङ, बाराह्‌क इतेके अवु पुनवोराङ आल्कान मर्सोेङ इनजोरे.” ");
INSERT INTO mrr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","इद्रमता पुन्पिह कीयनद पोल्‍लोतुन, येसु अगा केंजवालोरिह्‌क वेहतोग़. मति ताना अर्तम ओरिह्‌क तेळियो. ");
INSERT INTO mrr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","अस्के येसु ओरिन ओसो इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, गोरेना अग़दन ननाने आंदन. ");
INSERT INTO mrr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","नाकाय मुने वातोर जोल काग़्हवालोर कतमतोर कलेर, डाकुर आंदुर. मति नावाङ गोरेङ ओराङ केंजोङ आंदुङ. ");
INSERT INTO mrr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","देवुळतके दायनद गोरेना अग़दन ननान आंदन. नयेनाहि बोर लोप्पा नेङनुर, ओरिन नना पिसिह कीकन. ओरु लोप्पा-पलत ओळियाङ-पेसाङ कीयनुर, ओरिह्‌क तिंड-बंड वने दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","कलेर वास्तोर, सिरपि कललाह, हव्कलाह, बूळे कीयलाह, इदे विचरते ओर वास्तोर. मति नना बाराह्‌क वातन इतेके नावा लोकुरिह्‌कु लद्बदता जीवा दोर्कना इन्जि. ");
INSERT INTO mrr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","नेह्‌नोग़ गोरे कोपानन ननान आंदन. नेह्‌नोग़ कोपाल तनाङ गोरेनेनाह्‌कु तना जीवा ईयलाह तयर आस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मति कूलतोग़ इतेके, कोपाल वने आयोग़ ओसो माल्काल वने आयोग़, अदिह्‌कु लोळ्ङाङ वायनदिन ऊळिसि, गोरेन अगान विळ्सिस वितिह्‌तोग़. बाराह्‌क इतेके गोरेङ ओनाङ आयोङ इनजोरे. पया लोळ्ङाङ वासि उचुकिन पोयह्‌पा, गोरेङ कतम बिरोबटो आस्ताङ. ");
INSERT INTO mrr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ओग़ कूलतोग़ आंदोग़, अदिह्‌क गोरेना पर्वा केवोग़, ओग़ वितिह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","मति नना नेह्‌ना कोपानन. बहलेह्‌का बाबाल नाक पुन्ह्‌तोग़ ओसो नना बाबान पुह्‌नन, अद्रमे नावाङ गोरेन नना पुह्‌नन, अहे अव वने नाक पुन्ह्‌ताङ. ओसो गोरेनेनाह्‌क नना नावा जीवातुन ईयलाह तयर मह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ओसो बेव गोरेङ मन्ह्‌ताङ, अव इद गोह्‌डटग्डाङ (इतेके यहुदि जातता गोह्‌डटग्डाङ) आयोङ. अविस्किन वने नाक नावा गोह्‌डटे काल्ह्‌प पोयतग़ा, अस्के अव नावा आल्कातुन केंजनुङ. पया उंदिय गोह्‌डि आयग़ा, अस्के नना ओरा वग़ोनन मेहवाल कोपानन आयकन. ");
INSERT INTO mrr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","नना ओसो जीवा अरयकन इनजोरे, नावा जीवातुन नना ईय्ह्‌नन, अदिह्‌क बाबाल नाक जीवा कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","अद जीवातुन नयग्डाहि बोग़े ओया पग़वोग़, मति नावाय विचरते नना तान ईय्ह्‌नन. नाक अदिन ईयनद अदिकर मन्ह्‌ता, ओसो मल्स जीवा अरयनद वने अदिकर मन्ह्‌ता. इहे कीयनद उकुमि, नावा बाबाल नाक ईतोग़,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","इव गोटिनेनाह्‌क यहुदिर ओसो उंद देबा पका जेटामारा आसि, रेंड तुंगाङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ओरग्डाहि वेल्‍लाटोर इतोर, “वेग़ पिसाङ आतोग़, रा! वेन देयम पोयता. वेनाङ मीट बाराह्‌क केंजिह्‌निर?” इह इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","मति उय्तुर इतोर, “इव इद्रमताङ गोटिङ देयम पोयतोनाङ आयोङ, डा! वेग़ गुडिन तोवनाह कीतोग़, देयमतुह्‌क बह अह कीया वास्ताया?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","येरुसलेम सहरते इर्ङमतस्के, मंदिरतुन सिर्तम ईतदिन सीता कीयनद पंडुम वाता. ");
INSERT INTO mrr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","अस्के मंदिरतगा बेद मंडातुन साल्मोन राजाना मंडा इंदुर, अदे मंडातगा येसु तिरियलाह आस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","अस्के यहुदिर कोंटेतोर ओन सर्ने आस इतोर, “निमा मावा जीवातुन बेचानाह तेळियवाह कीस तासकिन? निमा देवुळ लोहवाल पिसिह केवानिन इतेके, माक पङ्ने वेहा!” ");
INSERT INTO mrr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","येसु ओरिन इतोग़, “नना मीकु मुनेताहि वेहतेकाय, मीट नमविर! बेव डीसाताङ कबस्क नना नावा बाबाना अदिकरते कीय्ह्‌नन, अवे नावा लोप्पा वेहतह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","तेला मति मीट नावाङ गोरेना गोह्‌डटग्डोरिर आयवाह्‌कु, मीट नमविर. ");
INSERT INTO mrr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","(बेद्रम गोरेङ कोपाना आल्कातुन केंजिह्‌ताङ, अद्रमे) नाक नमवालोर नावा आल्कातुन केंजिह्‌तोर, ओसो नाक पुन्ह्‌तोर. ओरिन नना पुह्‌नन ओसो ओरु नावाङ कग़यलाह वास्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","नना ओरिह्‌कु अमेसाता पिसमुळि ईय्ह्‌नन. ओर बेस्केन बूळेम आयोर आयनुर, ओसो ओरिन नयग्डाहि बोरे ऊंदोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","बोग़ नाक ओरिन ईतोग़, ओग़ नावा बाबाल सबेटोरिह्‌काय बेह्‌रोग़ मन्ह्‌तोग़, मनाह्‌कु ओना कयदाहि बोग़े ओरिन मुर्तिय ऊंद पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","बाबाल, नना, माट उंदिये मह्‌नोम,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","येसु अह इतस्के, यहुदिराङ पेदल्क बंडाङ उकिस, ओन हव्कलाह ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","अस्के “नाक बाबाल वेहतवु वेल्‍लाङे बेसताङ कबस्क, नना मीक कीस तोहतन इतेके, अग्डाहि बेद कबळतेनाह्‌क, नाकु बंडाङ उकिस हव्कलाहि ऊळिह्‌निर?” इन्जि येसु ओरिन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“आयो, बेसता कबळतेनाह्‌क नीक माटु बंडाङ उकिस हव्कोम. मति निमा मन्कल आसि, ननान देवुळतन इतपु, देवुळतुन उस्किस-पास्किस वळ्ह्‌कतिन; अदिह्‌क नीकु माट हव्ककोम,” इनजोर यहुदिराङ पेदल्क इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","अस्के येसु ओरिन इतोग़, “मीट देवुळ्कनिर आंदिर इनजोर, देवुळबाबाल अस्केडोर राजेम केवालोरिन इन्जि, इद्रम मीवाङ अडोना सास्त्रमते रासतद इलेया? ");
INSERT INTO mrr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","ओसो देवुळता सास्त्रम बेस्केन जोल आयो इन्जि माट पुह्‌नल. अद कालमते नेयम कीयलाह, बोरिह्‌क देवुळताङ पोल्‍लोङ दोर्कताङ, ओरिन देवुळबाबाल ‘देवुळ्कनिर’ इनजोर इतोग़. इतेके बोनु बाबाल पवित्र कबळतेनाह्‌क आचिस, इद दुनियाते लोहतोग़, ओनन ननाने देवुळता मग़नन इन्जि इतेके, अद बाता गल्ति? पया मीट नाकु देवुळतुन पास्किह्‌निन इनजोर, बाराह्‌कु कसुर तोहतह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","नना नावा बाबाल वेहतनव कबस्क केवेके, नाक नममाट. ");
INSERT INTO mrr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","मति नना अव कबस्किन कीय्ह्‌नन इतेके, नाक नमवेकाय, अव कबस्किन ऊळिस तेला, देवुळ नाक लोहता इन्जि नमाटु. इद्रमलेह्‌का मीट नमतेके, बाबाल नयगा जोळेम आस मन्ह्‌तोग़, ओसो नना बाबानगा जोळेम आस मह्‌नन इन्जि, मीक तेळियग़ा, ओसो मीट पुनजोर मनदकिर,” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ओर ओन ओसो पोयतलाह ऊळिंदुर, मति ओग़ु ओरा कयदाहि बुस्कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","योर्दन बेरेटा अबरि मुने योहनदेवुळता पेदिरते एग़ मीहन्दोग़, अगा येसु अतोग़, अन्जि अगान मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","अस्के ओनक्‍के वेल्‍लाय मुल वातोर, वासि इतोर, “योहन वेना लेह्‌का बातय बामिह कीयना सीना तोहोग़, निटमे! तेला मति योहन वेना लोप्पा बेव गोटिङ वेहच मतोग़, अव सबे करलताङे आंदुङ इनजोर, वेग़ु देवुळ लोहतोग़ पिसिह केवाल राजाले मनदनोग़!” इन्जि, अग्डोर वेल्‍लाटोरे येसुन नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियाल इनदनदु ओसो ताना अकालि मार्ताल, इव बेतनि इनदनद नाटे मंदुङ; अविस्कनाये तमोग़ लाजर पेदिरतोग़ दुक अर्स मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(येसुसामिनाङ काल्किनु अतर्नेयदे ऊसता, तनाङ केल्कने ओनाङ काल्किन उम्चता, अद इदे मरियालि.) ");
INSERT INTO mrr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","“सामि, नीवा गोतयाल लाजर पकाय दुक अरतोग़” इन्जि, ओनाङ अकास्कु येसुह्‌क कबुर लोहताङ. ");
INSERT INTO mrr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","इद कबुर केंजिसि येसु इतोग़, “इद दुकि ओना जीवा तिनदलाह वावो, मति देवुळता डीसा तोहतलाह, अहे इवटे देवुळता मग़िह्‌कु मान दोर्कना इन्जि, अद दुक पुटटा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","मार्तालि, मरियालि ओसो लाजर, वेरिन येसु जीवा कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","तेला मति लाजरना दुकता कबुर केंजिसाय, येसु बेद नाटे मतोग़, अगाने ओसो रेंड दियाङ आनाह मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ताना पया ओग़ु तनाङ कग़यवालोरिन इतोग़, “दट, माटु ओसो यहुदा पटटे दाकल,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“गूरु, अग्डोर यहुदिराङ पेदल्कु इसलिय नीक बंडाङ उकिस हव्कलाह ऊळिंदुर, ओसो निमा अगा बाराह्‌क दायना कीय्ह्‌निन?” इन्जि ओर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","पया (देवुळ तासतद कगो एववालेवा, ओर नाकु बातय कीया पग़वोर आयनुर, इदिन वेहतलाह) येसु ओरिन इतोग़, “केंजाटु, पोळ्‍दमेटाङ पूरा बारा गंटाङ मन्ह्‌ताङ. बोग़ाय पोळ्‍द मनेक ताकतेके, ओग़ कोदुर एवोग़ आस्तोग़, बाराह्‌क इतेके इद दुनियाता वेह्‌चि ओनगा मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","मति बोग़ु ईकळते ताकिह्‌तोग़, ओग़ु कोदुर ईयनोग़, बाराह्‌क इतेके ओनगा वेह्‌च मनो आस्ता इनजोरे.” ");
INSERT INTO mrr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","इचोन वळ्ह्‌किसि, येसु ओरिन इतोग़, “मावा गोतयाल लाजर उंजिस मन्ह्‌तोग़; ओन नना तेहता दाय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","“सामि, ओन्क निद्र वातेके, (निमा अनवेकाय) ओग़ तनाय तेदनोग़,” इन्जि ओर येसुन इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","लाजरना हामुरताय लोप्पा येसु वळ्ह्‌किस मतोग़; मति निद्रते दोर्कनद आरमता लोप्पा ओग़ वळ्ह्‌किह्‌तोग़ बहे इनजोर, ओर कग़यवालोर येसुन अह इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","अदिह्‌क येसु ओरिन पङ्ने वेहतोग़, “लाजर डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ओसो मीवा विस्वस बोल्गग़ा इन्जि, ओग़ डोलतस्के नना ओनगा इलेन आसि, इदे नाक बेसु. मति बार आयो, दट, माट ओनक्‍के दाकल,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","कग़यवालोरग्डाहि ओर्वोग़ तोमाल इनवाल मतोग़, ओन दिदुमि (इतेके “एमोह पेकाल”) वने इंदुर. ओग़ु कग़यवालोरिन इतोग़, “दट, माट वने गूरुना ऐंगे दाकल, वेग़ हातेके, माट वने वेनाय संगे हायकल, (पिसतेके वेनाय संगे पिसकल,)” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","येसु तनाङ कग़यवालोरा संगे बेतनि नाटे एवतस्के, लाजरिन गुमयातगा तासिसि नालुङ दियाङ आताङ इनजोर, ओरिह्‌क तेळियता. ");
INSERT INTO mrr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","इद नाग़ येरुसलेम सहरताहि जोक-जोक कोसमेंड जेक मताह्‌कु, वेल्‍लाटोरे यहुदिर येरुसलेमताहि लाजरनाङ अकास्किन अळनेके, मानेह कीयलाह वास मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","येसु वास्तोग़ इन्जि मार्तालि कबुर केंजताह्‌कु, ओनगा अन्जि कलियता, मति तनेलाळ मरियालि लोने उदिस मता. ");
INSERT INTO mrr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्तालि येसुन कलियतस्के, ओन इता, “सामि, निमा इगा मन्ज मतेके, नावा तमोग़ डोलोग़ आवेग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","तेला मति इंजेकाय निमा देवुळतुन बेद ताल्ह्‌ककिन, अद नीक ईयग़ा इनजोर नाक एर्काये,” इन्जि इता. ");
INSERT INTO mrr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","अस्के पया येसु तान इतोग़, “नीवा तमोग़ जीवा अरयनोग़, मार्ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“इंगो गूरु, आक्रिते हातोर जीवा अरयना वेलाते, वेग़ वने जीवा अरयनोग़ इन्जि, नाक एर्काय मन्ह्‌ता,” इनजोर अद इता. ");
INSERT INTO mrr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","येसु तान इतोग़, “हातोरिन तेग़्किह केवानन, ओसो ओरिह्‌क जीवा एवानन, ननान आंदन. बोर नाक नमिह्‌तोर, ओरु हास मतेकाय, ओसो जीवा अरयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","बोर नाक नमसोर मन्ह्‌तोर, ओरिह्‌क अमेसाता पिसमुळ दोर्कग़ा, ओराङ जीवाङ देवुळताहि बेस्केन एग़ोङ आयनुङ इन्जि, इद पोल्‍लोतुन निमा सेतेम पोयतह्‌निना, मार्ता?” इन्जि तान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“इंगो सामि, इद बूमते देवुळ किरिया कीस वेहतपु, तना मग़ वावाल मतोग़, ओग़ किर्स्तु इतेके निमान आंदिन इनजोर, नना नमतन,” इन्जि मार्तालि इता. ");
INSERT INTO mrr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","इचोन वळ्ह्‌किस अद पेसिस अता, अन्जि मरियान कुस्क्ने केयिसि, “गूरु वातोग़ रि, ओग़ नीक केयिह्‌तोग़,” इन्जि वेहता. ");
INSERT INTO mrr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","इद पोल्‍लो केंजताहे, मरियाल पोर्क तेदिसि दरिमरिते ओनगा अता. ");
INSERT INTO mrr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(येसु इंका नाटे ओळियवाय मतोग़, मति मार्तालि बेद जागातगा ओन कलियिसि, अदे जागाते ओग़ मतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","बोर यहुदिर एलाग़ रेंडिन मानेह कीयलाह वासि, ओर मरियाना संगे लोप्पाडेकेन मतोर. अद चट्‌ने तेदिस दायनदिन ऊळिसि, अद गुमयातके अळयलाह दास्ता बहे इन्जि, ओर वने तानाय पयाह पेसतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","येसु रोमिस मतोग़ अद जागाते मरियाल एवतस्के, ओन ऊळिसि ओनाङ काल्क अरता, अर्सि इता, “सामि, निमा इगा मन्ज मतेके, नावा तमोग़ हायोग़ आवेग़.” ");
INSERT INTO mrr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","मरियाल ओसो ताना संगे वातोर यहुदिर, सबेटोरा अळयनदिन-केयनदिन ऊळिसि, लाजरना हामुरतुह्‌कु येसु तना जीवाते पका नारज आसि, ओना जीवा चुहेम आयो. ");
INSERT INTO mrr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","पया ओग़ ताल्ह्‌कतोग़, “ओना सेत्तातुन मीट बेगा तासतिर?” अस्के ओर इतोर, “वास ऊळा, गूरु.” ");
INSERT INTO mrr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","अस्के येसु अळतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तेन ऊळिस, यहुदिर तमतमाय इतोर, “अलाले, वेग़ लाजरिन अचोन जीवा कींदोग़ बपोम!” ");
INSERT INTO mrr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","अग्डोर उय्तुर इसि इंदुर, “वेग़ पुटगुडिन वने तोवनाह कीतोग़. इतेके लाजरिन हायना-हामुरताहि बह पिसिह कीया पग़वोग़ा?” ");
INSERT INTO mrr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","पया येसु ओसो उंद मल्का लाजरना हामुरतेनाह्‌कु, तना जीवाते पकाय नारजते मन्जि, गुमयातगा एवतोग़. लाजरिन पांजातगा तासिसि, अग़दगा बेरा आद बंडा तिळ्ह्‌प कीसि तासिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“तिळ्ह्‌प कीतद आदतुन तेंडाटु,” इनजोर येसु अग्डोरिन वेहतोग़. “आयो गूरु, ओन तासिसि, नेटुह्‌क नालुङ दियाङ बार आस्ताङ. अदिह्‌क ओना सेत्ता पकाय एग़्स्किस मनदग़ा!” इनजोरे हातोना अकालि मार्ताल इता. ");
INSERT INTO mrr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","अस्के येसु तान इतोग़, “निमा नमतेके देवुळता डीसातुन ऊळकिन, इद्रम नीक वेहन्दन बहे, केंजविन निमा?” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","अदिह्‌क पया ओर अद आदतुन तेंडटोर. अस्के येसु पोग़ोन ऊळसोर इतोग़, “ए बाबा, निमा नावा ताल्ह्‌कनदिन केंजतिन इनजोर, नना नीक जोहर कीय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","निमा नावाङ अमेसाये केंजिह्‌निन इनजोर, नाक एर्काय मन्ह्‌ता. तेला मति निमा नाक लोहतिन इनजोर, सर्ने निच मनवालोर लोकुर पुनदना इन्जि नमनेनाह्‌कु, नना इद्रम वळ्ह्‌कतन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","इद्रम वळ्ह्‌किस येसु बेरा आल्काते आळो कीतोग़, “ए लाजर, पलते पेसिस वाय!” ");
INSERT INTO mrr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","अस्के ओग़ पांजालोप्पा मतोग़ु हातोग़ मन्कल, पलत पेसिस वातोग़. तेला मति ओनाङ कय्क-काल्कु हामुर-गेंदेने ऊर्सताङ मताङ, ओना मोकमतुन इंका सर्ने दुपटटे ऊर्हच मतोर. “वेन लेहचीम्ह्‌ट, अनेग़!” इनजोर, येसु ओरिन वेहतोग़. अस्के ओर अहे कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","मरियान कलियलाह वातोर यहुदिर, येसु बह बह कीतोग़, अदिन ओर कतम ऊळतोर. ऊळिसि अग्डोर वेल्‍लाटोरे ओन नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","मति अग्डोर उय्तुर बार कीतोर, परुसिरक्‍के अन्जि, येसु बह बह कीतोग़, अदिन कतम ओर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","अदिनेनाह्‌क पेर्मालोर ओसो परुसिर वेरु, यहुदिराङ सेह्‌नालोरिन केयिसि, मीटिङ उदिह कीतोर. अस्के पया इतोर, “ओग़ इतेके वेल्‍लाङे बामिह कीयनाङ सीनाङ तोहतह्‌तोग़. माट बह केमेन मनदनाया? ");
INSERT INTO mrr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","माट ओन अहे विळ्सतेके, कतमतोर ओन नमिसि ओन राजाल कीयनुर. अस्के रोम सर्करताङ सीपय्कु वासि, मावा मंदिरतुनु, मावा देसेमतुनु बूळे कीयनुर” इन्जि, इद्रमताङ पोल्‍लोङ पट आसि वळ्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ओरग्डाहि वग़ोग़ कयपाल इनवाल, अद वर्सा मोदुल पेर्माल मतोग़, ओग़ पया ओरिन इतोग़, “मीक बातय तेळियवालेवा वळ्ह्‌किह्‌निर! ");
INSERT INTO mrr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","पूरा देसेम बूळेम आयना वाटो, वग़ोग़ मन्कल लोकुरेनाह्‌क हायना, इद मीवाये पाय्दाता मन्ह्‌ता, इचोन तेला मीक तेळियो!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","इद गोटि ओग़ तनाय बुदते वळ्ह्‌कोग़, मति अद वर्सा ओग़ मोदुल पेर्माल मताह्‌कु, यहुदिरा देसेमतेनाह्‌क येसुना हामुर आयना मन्ह्‌ता इन्जि, देवुळि ओना मेटे कबुर वेहच मता. अदिह्‌क ओग़ अह वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","सिरप अदे देसेमतेनाह्‌क आयो मति, सबे देसेह्‌कने मनवालोर देवुळताङ मग़्क-मयास्किन, उंदिय कुटुमते ओंडे कीयना इन्जि, येसु हायवाल मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","अदिह्‌क ओर अद दियाताहि येसुन हव्कलाह कोहन्दुर. ");
INSERT INTO mrr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","अदिनेनाह्‌क येसु अस्केडाहि, येरुसलेमते मनवालोर यहुदि लोकुरगा, सबेटोरिह्‌क दिसनाह वेलियोग़ आंदोग़. मति पेळ्ह्‌कल बूम एरेटा एप्रायिम इनदनद नाटे, तनाङ कग़यवालोरा संगे पेसिस वातोग़, वातापया ओर अगाने मंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","अस्के यहुदिरा आवना पंडुम एरे एव्स मता. पंडुमता मुनेन सोक आयनद रिवजतुन माळना इनजोरे, तमतमा नाटेनाहि वेल्‍लाय मुलु येरुसलेमतके अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ओर अगा येसुन पर्ह्‌कसोरे, मंदिरतगा निच मन्जि, तमतमाय वळ्ह्‌कलाह आतोर, “मीट बह इह्‌निर रा? ओग़ पंडुमतगा वायनोग़ा, वावोग़ा?” इह वळ्ह्‌किंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","मति पेर्मालोर ओसो परुसिर ओन पोयतना इनजोर, “ओग़ बेगा मन्ह्‌तोग़ इन्जि, बोन्काय एर्का आतेके, माक कबुर ईम्ह्‌ट, ऊळाट!” इनजोर वेर अगा वातोर कतमतोरिह्‌क उकुम ईसि. ");
INSERT INTO mrr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","पया आवना पंडुमता आरुङ दियाङ मुनेने, येसु तनाङ कग़यवालोरा संगे बेतनि नाटे वासि, अगान मतोर. लाजर पेदिरतोन ओग़ हामुरताहि तेग़्किह कीस मतोग़, ओनगाने ओर मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","अगा कग़यवालोरेनाह्‌कु ओर जावा एहच मतोर, अस्के मार्ताल वांटिसींदु. ओसो लाजर येसुनाये बतते उदिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","अस्के मरियाल तनगा तीसामेंड लेह्‌का मतदु अतर्नेय तचि, येसुनाङ काल्कनगा वळता. (इद अतर्नेयु जटामासि इनदनद पोर्ह्‌काताहि पंडटदु, अद वेल्‍ला दाराता आंदु.) वळसि, तनाङ केल्कने ओनाङ काल्किन उम्चता, अस्के अद नेय लोनमेंड गमरेम पोस मता. ");
INSERT INTO mrr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","ओर कग़यवालोरग्डाहि यहुदा इस्केर्योत इनवाल मतोग़ (ओग़े ओन कोंटेतोरा कयदे पोस एवाल मतोग़), ओग़ इतोग़, “इद अतर्नेयदुन वमतेके, वग़ोना वर्सामेटा पिसवग़ आवाल कोनि! तान वमिस, अव कोताङ गरिबतोरिह्‌क बाराह्‌कु एविर?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(ओन्क गरिब लोकुरा पर्वा मन्ह्‌ता इन्जि, अह वळ्ह्‌कतोग़ इनदनद इले; मति ओग़ कले आंदोग़. ओनगा कोताना बट्वा मंदु, अद बट्वाते येसुना सेवातुह्‌क वाटटद दान-दर्ममतुन ओग़ कलिंदोग़, अदिह्‌क इह वळ्ह्‌कतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","पया येसु इतोग़, “मनि यहुदा, निमा तान वळ्ह्‌कमा. नावा हायनद कगो एवता इन्जि, नावा सेत्तातुन अतर्नेय ओकतपे, अद अह कीता. ");
INSERT INTO mrr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","केंजाट, गरिब लोकुर अमेसा मियगा मन्ह्‌तोर,(ओरिह्‌कु बेस्के तेला मीट दर्मम ईया पग़यकिर). मति नना अमेसा मियगा मनोन आयकन,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","येसु अगा मन्ह्‌तोग़ इन्जि, वेल्‍लाटोर यहुदि लोकुरिह्‌क एर्का आता, एर्का आताह्‌कु ओर अगा वातोर. सिरप येसु अगा मन्ह्‌तोग़ इन्जि वावोर, मति हामुरताहि जीवा अरतोग़ लाजरिन वने, ओर ऊळलाह वातोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","मति पेर्मालोर पट आसि, लाजरिन वने हव्कलाह ऊळिंदुर. बाराह्‌क इतेके येसुना लोप्पा ओनाय साक्सितेनाह्‌क, वेल्‍लाटोर यहुदिर ओरिन विळ्सिसि येसुन नमिंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","इमा दिया पया येरुसलेम सहरते पंडुमतुह्‌कु वाता मुलु, येसु येरुसलेमते वास्तोग़ इनजोर केंजताह्‌कु, गजर मराताङ कोमाङ पोसि, ओन्क कदर ईयलाह सहरताह पलत पेसतोर. अह कीस केयसोर इतोर, “जोहर! देवुळबाबाना अदिकर पोस वावाल,इस्रयेलतोग़ राजाह्‌कु जोहर आयि!” ");
INSERT INTO mrr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","येसुह्‌क उंद गाळ्‍द दोर्कतस्के, ओग़ ताना पोग़ोन उदतोग़, उदिसि सहरतके वायलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","इद्रमि सास्त्रमते मुने रासिस मतद पोल्‍लो इंजेके करल आता, अद इह मन्ह्‌ता: “ए येरुसलेमता लोकुरिर, मीट रेयमाटु! ऊळाट, मीवा राजाल गाळ्‍द पियोता पोग़ोन उदिस गूनमते वास्तोग़.” ");
INSERT INTO mrr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","इव गोटिङ येसुनाङ कग़यवालोरिह्‌क अद तूकने तेळियोङ आसि. मति इव गोटिङ येसुना लोप्पा सास्त्रमते मुने रासतव मताङ, ओसो अहे लोकुर ओन कीतोर, ओग़ पया डीसाते जीवा अरतस्के, कग़यवालोरिह्‌क तेना सीता वाता. ");
INSERT INTO mrr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","येसु लाजरिन गुमयाताहि केयिसि जीवा अर्हतह्‌पा बोर लोकुर ऊळतोर, ओरु अह आतदिना लोप्पा साक्सि ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","येसु इद सीना तोहतोग़ इन्जि, तेना साक्सि केंजताह्‌कु, लोकुर ओन कलियलाह वातोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","अदिनेनाह्‌क परुसिर तमतमाय इतोर, “ऊळाटु, मावा ताको रो, माट आरेम आतल गोतो. कतमतोर ओनाय पयाह दायलाह आतोर!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","पंडुमते मोळ्कलाह वातोर लोकुरग्डाह उय्तुर युनानि जाततोर वने मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ओरु गालिल पटटा बेत्‍सेदा नाटेनोग़ पिलिप, वेनगा वासि इतोर, “दादा, येसुन माट कलियलाह वातोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","इद पोल्‍लो पिलिप वासि, पत्रुना तमोग़ आंद्रेयान वेहतोग़. पया इर्वुर कलियिस वासि, येसुन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","अस्के येसु तनाङ कग़यवालोरिन इतोग़, “इंजेके मान्वना नडुम पुटटोना डीसा तोहतनद कगो एवता. ");
INSERT INTO mrr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","इह केंजाट, नना सेतेम वेहतह्‌नन, (नावा जीवा) गोह्‌कना विजालेह्‌काडा. विजा नेदगा अरयह्‌ता, मिंजिह्‌ता, अस्के अद मोन्ह्‌टिसि वेल्‍ला पंटा ईस्ता. मति विजा नेदगा अरवेके, अद वग़ये मन्ह्‌ता, पंटा वावो. ");
INSERT INTO mrr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","अद्रमलेह्‌काने बोर इद दुनियाते तमा जीवातुन पिसिह कीयलाह ऊळिह्‌तोर, ओर अमेसाता जीवातुन पोहतह्‌तोर. मति बोर बारा इद दुनियाते तमा जीवातुन पर्वा केवोर, ओरा जीवा अमेसातुह्‌क पिसग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","बोर नावा सेवा कीयलाह ऊळिह्‌तोर, ओर नावाङ कग़यिर. बेगा नना मनदकन, अगा नावा सेवा केवालोर वने मनदनुर. बोर नावा सेवा कीयनुर, ओरिन नावा बाबाल कदर ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","इंजेके नावा जीवा चुहेम आयो. नना बाताल इनदकन? ‘नावा तिपल आयनद कगो वामाकि, तेनग्डाह नाक पिसिह कीम, बाबा,’ इद्रम इनदकना? आयो, इद्रम इनोन, मति इद कगोतेनाह्‌के, नना इद बूमतगा वातन. ");
INSERT INTO mrr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","बाबा, नीवा डीसातुन निमा तोहा!” इन्जि येसु इतोग़. अह इतस्के, पोग़ोटा बूमताहि आल्का केंज वाता, “नना नावा डीसातुन तोहतन, ओसोवने तोहतकन.” ");
INSERT INTO mrr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","आल्कातुन केंजिसि, अगा निच मतोर लोकुर उय्तुर इतोर, “बूम गुळ्न्जता, रा!” उय्तुर बारा इतोर, “आयो, देवतुले ओना संगे वळ्ह्‌कता.” ");
INSERT INTO mrr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","अस्के येसु ओरिन इतोग़, “इद आल्का नयेनाह्‌क आयो, मति मियेनाह्‌क आता. ");
INSERT INTO mrr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","दुनियातुन नेयम कीयनद वेला इदे मन्ह्‌ता. इदे वेला दुनियातुन राजेम कीयनदु (देयह्‌कना मुक्याल) आरेम आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","नाक नेदाहि गुटातगा पोग़ोन तेहतस्के, नना नयके सबेटोरिन ओंडे कीकन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","तना बेद हामुरते हायना मतोग़, अदिन वेहतलाह ओग़ अह वळ्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","अदिह्‌क पया लोकुर ओन ताल्ह्‌कतोर, “देवुळ लोहवाल पिसिह केवाल अमेसा मनदनोग़, इद्रम इनजोर अडोना सास्त्रमताह माट केंजतोम. इतेके निमा माक माने-मन्कना नडुम पुटटोनु, गुटातगा पोग़ोन तेहतना इन्जि, बह इह्‌निन? वेग़ ‘माने-मन्कना नडुम पुटटोग़’ बेद्रमतोग़ आंदोग़?” इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","अस्के येसु ओरिन इतोग़, “ओसो गय्के नावा वेह्‌च मियगा मनदग़ा. ईकळ आयनामुनेने, वेह्‌च मनेकेने वेह्‌चते ताकाटु. बाराह्‌क इतेके बोग़ ईकळते ताकिह्‌तोग़, ओग़ बेगा दास्तोग़, अद ओन्क तेळियो. ");
INSERT INTO mrr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","मीट नावा वेह्‌चते ताकवालोरिर आयना इन्जि, मियगा नावा वेह्‌च मनेकेने, अद वेह्‌चतुन नमतपु, (नावाङ पोल्‍लोङ केंजिसि, अहलेह्‌का ताकाटु.)” येसु इचोक गोटिङ वळ्ह्‌किसि, ओरग्डाह पेसिस अतोग़, अन्जि ओरिह्‌क पता अरवाहि कुस्क्ने मकिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ओरा मुनेह इचोटाङ बामिह कीयनाङ सीनाङ येसु तोहतोग़; तेला मति ओग़ देवुळ लोहतोग़ पिसिह केवाल आंदोग़ इन्जि ओर नमोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ओर नमवाह्‌कु, यसयाल इनवाल मुने रासतदु देवुळता कबुर करल आता. अद रासतद कबुर इह मन्ह्‌ता: ए सामि, माट वेहतद कबुरतुन बोग़ाय विस्वस कीतोग़ा? ओसो बोग़ाय देवुळबाबाना लावतुन ऊळतोग़ा? ");
INSERT INTO mrr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ओर बाराह्‌कु नम पग़वोर, अदिन वने यसयाल रासिस तासतोग़, अद इह मन्ह्‌ता: ");
INSERT INTO mrr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ओर तमाङ कोंडाने ऊळनायो, ओरिह्‌क तमा बुदते नावा पोल्‍लो तेळियनायो ओर नयके सव्रेम आयलाह मल्स वायनायो इन्जि, नना ओराङ कोंडान तोववाह कीतन, ओरा बुदतुन गळ्स कीतन. इन्जि देवुळ इन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","(देवुळता दळ्मि ओना पोग़ोन अरताह्‌कु,) यसयाह्‌कु येसुना डीसा दिसता, अदिह्‌क ओग़ु येसुना लोप्पा इद्रम आयना मन्ह्‌ता इन्जि, मुने वळ्ह्‌किस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","इद्रम मन्ज तेला, पेदा मन्कलोर वने वेल्‍लाटोरे, येसुन (तमा जीवाते) नमतोर. मति माकु मोळ्कनगा कलियलाह एवोर आयनुर इन्जि, परुसिरिन रेयिसि, देवुळ लोहतोग़ पिसिह केवाल येसुये आंदोग़ इनजोर, कबुल केवोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","बाराह्‌क इतेके, देवुळतेनाह दोर्कनद कदरतुह्‌काय एक्‍वा, ओरिह्‌कु मन्कलोरेनाह दोर्कनद कदर बेस आता. ");
INSERT INTO mrr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","अस्के येसु बेरा आल्काते केयिस इतोग़, “बोर नाक नमिह्‌तोर, ओर नाक वग़ोने नमोर मति, करलते नाक लोहतोग़ बाबान वने नमतप आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अहे बोर नाक ऊळिह्‌तोर, ओरु नाक लोहतोग़ बाबान ऊळतप मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","नाक नमसोर मनवाल बोग़े आयि, ईकळते मनदनदायो इन्जि, नना वेह्‌चता लेह्‌का दुनियाते वातन. ");
INSERT INTO mrr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“बोर नावाङ गोटिङ केंजिस अहलेह्‌का तिरियोर, ओरा नेयम नना केवोन. नना इतेके दुनियातोरा नेयम कीयलाह वावोन, मति दुनियातोरिन पिसिह कीयलाह इद बूमते वातन. ");
INSERT INTO mrr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","बोर नाक कोंटे कीसि, नावाङ पोल्‍लोङ केंजोर, ओरा नेयम कीयनद उंद मन्ह्‌ता: बेद पोल्‍लो नना वेहतन, अद पोल्‍लोते ओर तिरियतोरो, तिरियोरो, अद इसबते ओरा नेयम आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","नना इद्रम बाराह्‌क वेहतह्‌नन इतेके, नना नावाय विचरताङ पोल्‍लोङ वळ्ह्‌कोन; मति नना बाताल इनदना मन्ह्‌ता, ओसो बाताल वळ्ह्‌कना मन्ह्‌ता, अदिन नाक लोहतोग़ बाबाल, ओग़े नाक उकुम ईस वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ओना उकुम अमेसाता पिसमुळतके ओसीस्ता, इद नाक एर्काय मन्ह्‌ता. अदिनेनाह्‌क बाबाल नाक बह वळ्ह्‌कलाह वेहतोग़, अद्रमे नना वळ्ह्‌किह्‌नन,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","आवना पंडुम इंजेके एरे एव्स मता. मुल्पेडा जावा उनडलाह, येसुनाङ कग़यवालोर ओना संगे ऐंगे उदिस मतोर. नना इद दुनियातुन विळ्सिसि, पोग़ोटोग़ बाबानेके दायनद कगो एवता इनजोर, येसु पुतोग़. इद दुनियाते मतोर तना लोकुरिन ओग़ जीवा कींदोग़, अहे हानाह्‌जोम ओग़ ओरिन जीवा कीसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","अस्के सिमोन इस्केर्योतना मग़ि यहुदाल, वेना जीवातगा देयह्‌कना मुक्याल येसुन कोंटेतोरिह्‌क पोस ईयना, इद्रमता आय्डा पुटिह कीस मता. ");
INSERT INTO mrr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","येसु इतेके, नावा बाबाल नाकु पूरा अदिकर ईतोग़; नना देवुळतग्डाहि वातन, ओसो अगाने मल्स दाय्ह्‌नन इनजोर पुतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","इदिन पुन्जि, ओग़ु तिनदह्‌पा तेदतोग़, अह कीसि पोग़ोटा जगातुन तेंडिसि, साकुर केवाना लेह्‌का उंद दुपटटुन नंडटगा दोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तेदिसि ओग़ु गमेलातगा एग़ पोसि, कग़यवालोराङ काल्क नोग़या बोटटोग़, नोग़्सि नंडटुह्‌क दोहतदु दुपटटे काल्किन उम्चिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","अह कीसोर येसु सिमोन पत्रुनगा एवतोग़. अस्के पत्रु येसुन इतोग़, “अलो सामि, निमा नावाङ काल्किन बाराह्‌कु नोग़यह्‌निन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","“नना बाताल कीय्ह्‌नन, अदिन निमा इंजेक पुनविन सिमोन, मति पया पुनदकिन,” इन्जि येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“आयो, आयो, निमा नावाङ काल्किन मुर्तिये बेस्केन नोग़मा!” इन्जि पत्रु इतोग़. अस्के येसु इतोग़, “नना नीवाङ काल्किन नोग़वेके, नीक नयगा जागा दोर्को आयग़, रा!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“अह इतेके नावाङ वेट काल्किन नोग़मा, मति नावाङ कय्किनु, तलातुनु वने नोग़्म,” इनजोर पत्रु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","“आयो, बोग़ एग़ मीस पूरा एडटोग़, ओन्क काल्किन विळ्सिस, दुस्रा बेदिन नोग़यलाह गर्ज इले. अद्रमे मीट जीवाते एडटिर, तेला मति कतमतोरिर एडविर,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(तन्क पोस एवान मन्कन येसु पुन्जिये मतोग़. अदिनेनाह्‌क कोनि कतमतोरिर एडविर इनजोर इतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","पया येसु ओर कतमतोराङ काल्क नोग़यनद मारतस्के, जगा केग़्सि, ओसो तिनदलाह उदतस्के, ओरिन इतोग़, “नना मीक बाताल कीतन, इद मीक तेळियिह्‌ताया? ");
INSERT INTO mrr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","16","इह केंजाट, नना सेतेम वेहतह्‌नन, ओर्युल मन्कल तना माल्काह्‌क बेरोग़ आयोग़. अद्रमे बळयि वने, तन्क लोहवाह्‌क वीळिस बेरोग़ आयोग़. मीट नाकु ‘गूरु, सामि’ इनजोर केयिह्‌निर, इतेक मीट बराबर इह्‌निर, बह इतेके नना अद्रमतोनने. अदिनेनाह्‌कु नना गूरुनन ओसो सामिनन आस तेला, मीवाङ काल्किन नोग़तन इतेके, मीट वने इद्रमे काल्किन नोग़तपु, (ओर्वोग़-ओर्विना सेवा कीसोर मन्ह्‌टु). बहलेह्‌का नना कीतन, अहलेह्‌का मीट वने ओर्वोग़-ओर्विना सेवा कीयना इनजोरे, मीक उंद अग़ कीस तोहतन. ");
INSERT INTO mrr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","इव गोटिङ मीक तेळियिह्‌ताङ निटमे, इविन सीता कीसि ताकतेके, मीट देय्वातोरिर. ");
INSERT INTO mrr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“नना मीट कतमतोरा लोप्पा वळ्ह्‌कोन. मति नना बोरिन आचतन, ओर बेद्रमतोर इन्जि नना पुतन. तेला मति नावा ऐंगे तिनवाल, नाके लाता वाटटोग़ इद्रम सास्त्रमते रासतद मन्ह्‌ता, अद करल आयनाय गावले. ");
INSERT INTO mrr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","इव गोटिङ बेस्के आयनुङ अस्के, नना बोनन आंदन इनजोर नना वेहतनद पोल्‍लोतुन, मीट नमना इन्जि, इव आयनामुनेने मीक नेंड नना वेहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","इह केंजाट, नना सेतेम वेहतह्‌नन, बोर मीक एरे कीस्तोर, ओर नाक वने एरे कीतप मन्ह्‌तोर; ओसो बोर नाक एरे कीस्तोर, ओरु नाक लोहतोग़ बाबान वने, एरे कीतप मन्ह्‌तोर,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","इचोन वळ्ह्‌कतस्के, येसुना जीवा चुहेम आयो आंदु. अदिह्‌क ओग़ इतोग़, “इह केंजाट, नना सेतेम वेहतह्‌नन, मियग्डोग़ वग़ोग़ कोंटेतोरा कयदे नाक पोसीयनोग़,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ओग़ बोना लोप्पा वळ्ह्‌किह्‌तोग़ इनजोर, ओर कग़यवालोर एक्बेक आसि, ओर्विन-ओर्वोग़ ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तिननेके ओर्वोग़ कग़यवाल येसुनगा रोयिसि उदिस मतोग़ (ओग़े येसु पका जीवा कीतोग़ कग़यवाल इनवाल आंदोग़). ");
INSERT INTO mrr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","येसुन पोस एवाल बोग़ आंदोग़ इनजोर पुनदलाह, ओन सिमोन पत्रु कोंडा चिम्चिह कीसि, “सामिन ताल्ह्‌का, रा!” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","अस्के येसुनगा रोयिसि उदतोग़ कग़यवाल, “ए सामि, ओग़ बोग़ आंदोग़?” इन्जि ओन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","“बोन्क नना आरतुन किळ्हचि पुलातगा अह्‌चिस तीहतकन, ओग़े ओग़ आंदोग़,” इन्जि येसु इतोग़. अह इन्जि ओग़ आरतुन पोस, पुलातगा अह्‌चतोग़, अह कीसि सिमोन इनवाना मग़ि यहुदा इस्केर्योतिह्‌कु तीहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","यहुदाल आरतुन तितस्के, देयह्‌कना मुक्याल ओन आव्रे कीता. अस्के येसु ओन इतोग़, “नीवा बाताल कीयना विचर मन्ह्‌ता, अद चट्पिट मारि,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ओन अद्रम कीम इनजोर येसु बाराह्‌क वेहतोग़, अद पोल्‍लो कग़यवालोरग्डाहि बोन्के तेळियो. ");
INSERT INTO mrr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहुदानगा कोताना बट्वा मंदु, अदिह्‌क पंडुमतेनाह्‌कु गावल आयनद सामन असलाहि, लोहचोर मनदनोग़ बहे, आयवेके गरिब लोकुरिह्‌क दर्मम ईयलाह लोहचोर मनदनोग़ इन्जि, उय्तुर विचर कींदुर. ");
INSERT INTO mrr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","आर तितस्के, यहुदाल चट्‌ने पलत पेसतोग़. अस्के मुर्गंगा ईकळ आस मता. ");
INSERT INTO mrr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहुदाल पलत पेसतस्के, येसु इतोग़, “इंजेके माने-मन्कना नडुम पुटटोना डीसा दिसनद कगो एवता, ओसो नाक बेव-बेव आयनुङ, अवटे देवुळता डीसा दिसग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अवटे देवुळता डीसा दिसग़ा इतेके, नावा बेचोटा डीसा मन्ह्‌ता इन्जि, देवुळ वने कुदि तोहतग़ा, अद इंजेकेने तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“ए पेकोरिर, नना ओसो गेळ्के मीवा ऐंगे मह्‌नन. पया मीट नाक पर्ह्‌ककिर, मति बहलेह्‌का नना यहुदिराङ पेदल्किह्‌क वेहतन, अहलेह्‌का नना मीक वने इंजेके वेहतह्‌नन: नना बेगा दाय्ह्‌नन, अगा मीट वाया पग़विर आयकिर. ");
INSERT INTO mrr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“अदिह्‌क नना मीक उंदि पूना उकुम ईय्ह्‌नन: मीटु ओर्विह्‌क-ओर्वोग़ जीवा कीम्ह्‌टु. बेद्रम नना मीक जीवा कीतन, अहे मीट वने ओर्विह्‌क-ओर्वोग़ जीवा कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","मीट ओर्विह्‌क-ओर्वोग़ जीवा कीतिर इतेके, मीट नावाङे कग़यवालोरिर इनजोरे सबेटोर पुनदनुर,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमोन पत्रु पया येसुन इतोग़, “सामि, निमा बेके पेसिस दाय्ह्‌निन?” इन्जि ताल्ह्‌कतोग़. “नना बेगा दाय्ह्‌नन, अगा निमा इंजेके वाया पग़विन. मति पया पेग़्के वायकिन,” इनजोर येसु ओन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“सामि, इंजेकेने नना नीवा पयाह बाराह्‌क वाया पग़वोन? नना डोलतेक तेला नीक विळ्सोन!” इनजोर पत्रु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","अस्के येसु ओन इतोग़, “बातालि, निमा डोलतेक तेला नाक विळ्सविना? नीक सेतेम वेहतह्‌नन सिमोन, बेस केंजा, तलाकोग़ कूसनामुने, निमा येसुन पुनोन इनजोर, मूंड मल्काङ इनदकिन, इद निटमे!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","येसु पया ओर सबेटोरिन इतोग़, “मीवाङ जीवाङ कंद्रेम आयमाकिङ. मति देवुळतुन नमिस मन्ह्‌टु, ओसो नाक वने नमिस मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","नावा बाबाना लोतगा मनदलाह, वेल्‍लाङे अराङ मन्ह्‌ताङ. अद्रम इलवेके, नना मियेनाह्‌कु मनदलाहि जागा तयर कीयलाह दाय्ह्‌नन इनजोर वेहेनना? ");
INSERT INTO mrr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","नना अन्जि मियेनाह्‌क जागा तयर कीतन इतेके, मल्स वासि मीक नयगा ओयकन. बाराह्‌क इतेके बेगा नना मह्‌नन, अगा मीट वने मनदना इन्जि. ");
INSERT INTO mrr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","नावा दायनद अग़ि मीक इतेक एर्काय मन्ह्‌ता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","अस्के तोमाल इनवाल कग़यवाल ओर्वोग़ येसुन इतोग़, “सामि, निमा बेगा दाय्ह्‌निन, अदिन वने माट पुनोम. इतेके पया, नीवा दायनद अग़ि माक बह एर्का आयग़ा?” ");
INSERT INTO mrr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","अस्के येसु ओन इतोग़, “अग़दन ननाने, सेतेमतन ननाने, जीवातन वने ननाने आंदन, तोमा. नावा संगे वावालेवा, बाबानेके बोग़े एवया पग़वोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","नना बोनन आंदन इन्जि, मीट इंजेके पुतिर इतेके, बाबान वने मीट पुनदकिर. इंजेटाहि मीट ओन पुह्‌निर, ओसो ऊळतिर वने.” ");
INSERT INTO mrr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","अस्के पिलिप इनवाल ओन इतोग़, “सामि, बाबान माक तोहा, तोहतेके अदे माक बेचोनो आयग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","अस्के येसु ओन इतोग़, “पिलिप, नना इचोक दियाङ मीवा ऐंगे मन्ज तेला, निमा नाक पुनविना? बोग़ नाक ऊळतोग़, ओग़ बाबान ऊळतपे मन्ह्‌तोग़. इतेके निमा बाबान माक तोहा इनजोर, बेद्रम इह्‌निन? ");
INSERT INTO mrr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","बाबाल, नना, माट इर्वोम जोळेम आस मह्‌नोम इनजोर, निमा विस्वस केविना? मीक वेहतनाङ गोटिङ, नना नावा विचरते वेहोन मति, नयगा मनवाल बाबाल, ओग़े नावा मेटे तनाङ कबस्क कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","बाबाल, नना, माट इर्वोम जोळेम आस मह्‌नोम, इद नावा गोटटुन सेतेम पोय्म्ह्‌टु. अह आयवेके, नावाङ कबस्किन तेला ऊळिसि सेतेम पोय्म्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","इह केंजाट, नना सेतेम वेहतह्‌नन, नना कीयनव बेरा डीसाताङ कबस्किन, नाक नमवालोर वने कीयनुर, ओसो अविस्किह्‌काय वीळिस बेह्‌राङ कबस्क कीयनुर. बाराह्‌क इतेके नना बाबानेके दाय्ह्‌नन इनजोरे. ");
INSERT INTO mrr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ओसो मग़ना लोप्पा बाबाना डीसा दिसना इन्जि, मीट बेव गोटिनु, माट नीवाङे लोकुरोम इन्जि ताल्ह्‌ककिर, अविन नना कीकन. ");
INSERT INTO mrr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","माट नीवाङे लोकुरोम इन्जि, मीटु बातालाय ताल्ह्‌कतिर इतेके, अदिन नना कीकन. ");
INSERT INTO mrr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“मीट नाक जीवा कीतेके, नावा पोल्‍लोतुन माळकिर. ");
INSERT INTO mrr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","अस्के नना बाबान ताल्ह्‌ककन, पया ओग़ मीकु दुस्रा तोळ आयनद ईयनोग़, अद अमेसा मीवा संगे मनदग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","अद देवुळता सेतेम तोहतनद जीवा आंदु. दुनियातोर तान पोयोर आयनुर, बाराह्‌क इतेके ओर तान ऊळोर, तान पुनोर वने. मति मीट इतेक तान पुह्‌निर, बह इतेके अद मीवा तोळ मन्ह्‌ता इनजोरे. ओसो मीवा लोप्पा पया जागा आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","दायनस्के, नना मीक पोरावेकोरा लेह्‌का विळ्सोन आयकन, मति (देवुळता पवित्र जीवातामेटे), मियके मल्स वायकन. ");
INSERT INTO mrr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","उचुके दियाङ पिसताङ, दुनियातोर पया नाक ऊळोर आयनुर, मति मीट नाक ओसो ऊळकिर. नना अमेसा जीवात मनदकन, अहे नावा लेह्‌का मीट वने अमेसा जीवात मनदकिर. ");
INSERT INTO mrr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","अह आतस्के बाबाल, नना, माट इर्वोम जोळेम आस मह्‌नोम, ओसो मीट नयगा जोळेम आस मह्‌निर, ओसो नना मियगा जोळेम आस मह्‌नन इनजोरे, मीट पुनदकिर. ");
INSERT INTO mrr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","बोर नावा पोल्‍लोतुन माळिह्‌तोर, ओरे नाक जीवा केवालोर आंदुर. ओसो बोर नाक जीवा कीस्तोर, ओरिन नावा बाबाल जीवा कीस्तोग़. नना वने ओरिन जीवा कीकन, अस्के नाक ननाने ओरिह्‌क पुनाह कीकन,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","पया दुस्रोग़ यहुदाल (इस्केर्योत आयोग़) इतोग़, “सामि, माक बार निमा दिसकिन, दुनियातोरिह्‌क बार निमा दिसविन आयकिन, इतेके इद बहु?” इन्जि ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","येसु ओन इतोग़, “बोर नाक जीवा कीयनुर, ओर नावा पोल्‍लोतुन माळनुर. बाबाल ओरिन जीवा कीयनोग़, पया माट इर्वोम ओरगा वासि, जागा पोयतकोम. ");
INSERT INTO mrr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","बोर नाक जीवा केवोर, ओर नावा पोल्‍लोतुन माळोर. बेव पोल्‍लोङ मीट केंजिह्‌निर, अव नावाङ आयोङ, मति नाक लोहतोग़ बाबानाङ आंदुङ. ");
INSERT INTO mrr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“नना मियगा मनेके, इव गोटिङ मीक वेहतन. ");
INSERT INTO mrr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","तेला मति बाबाल तना पवित्र जीवातुन मीक तोळ मनदलाह लोहतनोग़, अद जीवा नावा अदिकर पोसि मीक कतम काग़्हतग़ा. ओसो बेव गोटिङ नना मीक वेहतन, अविस्किन कतमे अदु सीता कीसि वेहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","नना मीवा जीवातुह्‌क सुकम ईसि तासिह्‌नन. बेद्रम इद दुनिया सुकम ईस्ता, अद्रम नना एवोन. मति बेद्रम नावा जीवाते सुकम आस्ता, अद्रमे मीवा वने जीवाते सुकम आयग़ा. अदिह्‌कु मीवा जीवा आल्सुळते मनमाकि, मति मीटु दीरा पोस मन्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘नना पेसिस दाय्ह्‌नन, पया पेग़्के मियके मल्स वायकन,’ इह इनजोरे मीक वेह्‌च मतन, अदिन मीट केंजतिर. नाक मीट पूरा जीवा कीतेके, नना बाबानेके दाय्ह्‌नन इतस्के, मीट गिर्दा आवेरिर, बाराह्‌क इतेके बाबाल नाकाय बेरोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","इव गोटिङ करल आयनुङ अस्के, मीट विस्वस कीयना इन्जि, इव आयनामुनेन नना मीक वेहतन. ");
INSERT INTO mrr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","इंजेटाहि नना मीवा संगे वेल्‍लाङ वळ्ह्‌कोन आयकन, बाराह्‌क इतेके दुनियातुन राजेम कीयनद वायलाह आता. वास तेला, नावा पोग़ोन ताना बातय अदिकर इले. ");
INSERT INTO mrr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","मति नना बाबान जीवा कीय्ह्‌नन इन्जि, दुनियातोर पुनदनेनाह्‌क, बाबाल नाक वेहतपु, अहे नना कीय्ह्‌नन. “तेदाट, माट इग्डाह दाकल.” ");
INSERT INTO mrr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","कग़यवालोर ओना संगे ताकनेके, येसु इद्रम काग़्हतलाह आतोग़: “ननान करलता अंगुर-तोंडालेह्‌काडोनन आंदन. नावा बाबाल इतेके, अंगुर वाळुमतुन सोय केवाना लेह्‌काडोग़ आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","नना तोंडालेह्‌काडोनन, (मीट नावाङ कांदानिर आंदिर). नयगा आदवाङ कांदानु, बाबाल डायिस पोहचीस्तोग़. मति आदनाङ कांदानु, पका आदना इन्जि, ओग़ एळ्पिसि जूत कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","नना वळ्ह्‌कतद पोल्‍लोतुन नमताह्‌कु, मीट मुनेन जूत आतिर. ");
INSERT INTO mrr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","मीट नयगा जोळेम आस मन्ह्‌टु, अस्के नना मियगा जोळेम आस मनदकन. बहलेह्‌का कांदा तोंडातगा जोळेम आस मनवालेवा, तनाय कुद आद पग़वो, अहलेह्‌का मीट वने नयगा जोळेम आस मनवालेवा, देवुळता अग़दे ताक पग़विर. ");
INSERT INTO mrr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","नना तोंडालेह्‌काडोनन; मीट नावाङ कांदानिर आंदिर. बोर नयगा जोळेम आस मन्ह्‌तोर, नना ओरगा जोळेम आस मह्‌नन, अस्के अव कांदाङ वलियिसि पका आदिह्‌ताङ. बाराह्‌क इतेके नयग्डाहि एग़िस मतेके, मीक देवुळतेनाह्‌क बातय कीया वावो. ");
INSERT INTO mrr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","बोर नयगा जोळेम आस मनोर आयनुर, ओरिन नावा बाबाल कांदान डायतप लेह्‌का, डायिस पोहचीयनोग़. इद्रमताङ कांदाङ वततस्के, अविस्किन गुम कीसि किसतगा वाटिह्‌तोर, पया अव पूरा कर्विस दास्ताङ. ");
INSERT INTO mrr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","मीटु नयगा जोळेम आस मतिर, ओसो नावाङ पोल्‍लोङ मीवा जीवातगा गडिस मतुङ इतेके, बाताल मीक गावले, अदिन ताल्ह्‌काटु, अस्के अद मीक दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मीट पका आदिसि, येसुनाङ कग़यवालोरोम इन्जि तोहतकिर अस्के, इवटे नावा बाबाना मान आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","“बेद्रम बाबाल नाक जीवा कीतोग़, अद्रमे नना वने मीक जीवा कीतन. नना बाबानाङ केंजिसि ओना पोल्‍लोतुन माळिह्‌नन, अदिह्‌क ओग़ नाक जीवा कीयनदिन पुनजोरेन मह्‌नन. अद्रमलेह्‌काने मीट वने नावाङ केंजिसि नावा पोल्‍लोतुन माळाटु; अस्के मीट वने नना मीक जीवा कीयनदिन पुनजोरेन मनदकिर. ");
INSERT INTO mrr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","नावा लेह्‌का मीट गिर्दाते मनदना, ओसो मीवा गिर्दा पूरा निंदना इन्जि, मीक इव गोटिङ नना वेहतन. ");
INSERT INTO mrr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","बेद्रम नना मीकु जीवा कीतन, अद्रमे मीट ओर्विह्‌क-ओर्वोग़ जीवा कीयना, इदे नावा उकुम आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","बोग़ाय तनाङ गोततोरेनाह्‌क तना जीवा ईयनद, तेन्क वीळिस बेदे गूनम बेरा इले. ");
INSERT INTO mrr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","मीक नना बेद-बेद वेहतह्‌नन, अदिन मीट कीतेके, मीट नावाङ गोततोरिर आयकिर. ");
INSERT INTO mrr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","नना इंजेटाह मीकु ओर्युलतोर इनोन आयकन, बाराह्‌क इतेके माल्काना पोटालोप्पाडाङ गोटिङ, ओर्युलतोग़ पुनोग़ आस्तोग़. मति नना इतेक मीकु गोततोरिर इतन, बह इतेके बेव पोल्‍लोङ नना नावा बाबानग्डाहि केंजतन, अव कतमे मीक तेळियिह कीस वेहतन. ");
INSERT INTO mrr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","मीट नाक आचविर, मति ननाने मीक आचतन, आचिसि मीट नयगा जोळेम आस मन्जि, बेसताङ पुळ्यवाङ कायाङ कटना इन्जि, मीक तासतन. अदिह्‌क मीट बेदाय गोटटुनु नावा पेदिर वेहच बाबान ताल्ह्‌कतेके, अदिन ओग़ मीक ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","मीट ओर्विह्‌क-ओर्वोग़ जीवा कीम्ह्‌टु, इदे मीकु नावा उकुम आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“दुनियातोर बेस्के मीकु कोंटे कीयनुर, अस्के इद गोटटुन सीताते तासाटु: मीकाय मुने ओर नाक इंका कोंटे कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","मीटु दुनियातोरिर आस मतेके, दुनियातोर मीक मावोर इनजोरे, जीवा केवेर. मति नना मीक दुनियातोरग्डाहि आचिसि, एग़्‍पिह कीतन इन्जि, मीट दुनियातोरिर आयविर. अदिह्‌क दुनियातोर मीक कोंटे कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ओर्युल मन्कल तना माल्काह्‌क बेरोग़ आयोग़ इन्जि, मीक उंद पोल्‍लो वेहच मतन, तान सीता कीम्ह्‌टु. ओर नावा पेग़्के दल्गतोर इतेके, मीवा पेग़्के वने दल्गनुर. ओर नावा पोल्‍लोतुन माळतोर इतेके, मीवा पोल्‍लोतुन वने माळनुर. ");
INSERT INTO mrr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","नाक लोहतोग़ बाबान वेर पुनवाह्‌कु, मीट नावाङ कग़यवालोरिर इन्जि, मीकु इद्रमताङ तिपल्क ईयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","नना वासि ओरा संगे वळ्ह्‌कवेके, (ओरिह्‌कु नीवाङ केंजोम इनदलाह दोर्को आवालि, इतेके) ओरगा कसुर मनो आवालि. मति इंजेके नना ओरा संगे वळ्ह्‌कताह्‌कु, ओरिह्‌कु तमा कसुरतुनु मकिह कीयलाह जागाय इले. ");
INSERT INTO mrr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","बोर नाक कोंटे कीस्तोर, ओर नावा बाबान वने कोंटे कीतप आस्तोर. ");
INSERT INTO mrr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","बेव डीसाताङ कबस्किन दुस्रोर बोरे केवोर, अव कबस्किन नना ओरगा केवेके, ओरगा कसुर मनो आवालि. मति ओर इतेक, इंजेके नावाङ कबस्किन ऊळिस तेला, नाकु अहे नावा बाबान कोंटे कीस्तोर. अदिह्‌क ओर कसुरते अरयह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","उगसतुह्‌के ओर नाकु कोंटे कीतोर, इद्रम इनजोर ओराङ अडोना सास्त्रमते रासतद मन्ह्‌ता, अद करल आयनेनाह्‌कु इव गोटिङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“तोळ आयनद सेतेम तोहतनद देवुळता जीवा, तान नना बाबानग्डाहि मियके लोहतकन. अद पेसिस वातस्के, नना बोनन आंदन इन्जि वेहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ओसो मीट वने नना बोनन आंदन इन्जि वेहतकिर. बाराह्‌क इतेके बेस्के नना काग़्हता बोटटन, अस्केडाहि मीट नावा संगे मंदिर. ");
INSERT INTO mrr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“मीट विस्वसताहि अरयनायो इन्जि, मीक इव गोटिङ नना वेहतन. ");
INSERT INTO mrr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ओरु मीकु तमाङ पार्तनाताङ लोह्‌कनगा वाया एवोर आयनुर. इचोने आयो मति, मीक हव्कवालोर सबेटोरु मीक हव्किसि, माट देवुळतुने माळिह्‌नोम इनजोर इनदनुर, इद्रमता वेला वायना मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ओर बाबान पुनोर, नाक वने पुनोर इन्जि, इद्रम मीक तिपल कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","इव गोटिङ करल आयना वेलाते, नना मुने वेहताङ पोल्‍लोङ मीक सीता वायना इनजोरे, नना इव गोटिङ मीक इतेक वेहतने. नना मीवा ऐंगे मतन इनजोरे, इव पोल्‍लोङ मुनेताहि मीक वेहोन आसि. ");
INSERT INTO mrr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“मति इंजेके नाक लोहतोनके नना पेसिस दाय्ह्‌नन. ओसो ‘निमा बेगा पेसिस दाय्ह्‌निन, गूरु?’ इनजोर, मियग्डाहि बोग़े नाक ताल्ह्‌कोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","मति इव गोटिङ नना मीक वेहतन इनजोरे, मीवा जीवा पूरा आल्सुळते अरता. ");
INSERT INTO mrr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","तेला मति मीक सेतेम वेहतह्‌नन, नना अतेके मीवा पाय्दाये आयग़ा. नना अनवेके, तोळ मनदनद देवुळता जीवा मियके वावो आयग़ा. मति नना अतन इतेके, तान मियके लोहतकन. ");
INSERT INTO mrr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","अद वासि दुनियातोरिह्‌कु तमा पापमता लोप्पा, ओराये विचरते सेतेमतोरोम इन्ह्‌तोर, तेना लोप्पा, ओसो ओरा चुकनद नेयमता लोप्पा पुन्पिह कीसि, ओरा तप तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ओर नाक नमोर इन्जि, देवुळता जीवा ओरा पापमता लोप्पा तप तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","नना बाबानेके पेसिस दाय्ह्‌नन, पया इद बूमते मीक नना बेस्केन दिसोन आयकन. अदिनेनाह्‌क दुनियातोरा सेतेमि निटम जोलिय आस्ता इन्जि, देवुळता जीवा (नावा जागाते वासि,) ओरा तप तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ओसो इद दुनियातुन राजेम कीयनदु, (देयह्‌कना मुक्याना, इतेके जोलहालोरा मुक्याना,) सिक्सा आतद मन्ह्‌ता इन्जि, पवित्र जीवा दुनियातोरा जोल नेयमता लोप्पा तप तोहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","नाक ओसो वेल्‍लाङे गोटिङ मीक वेहतनव मन्ह्‌ताङ, मति अव मीक इंजेके तेळियलाह वेल्‍लाय मुस्किल आयनुङ. ");
INSERT INTO mrr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","मति अद देवुळता सेतेमता जीवा वायग़ा अस्के, अद मीकु पूरा सेतेमता अग़ तोहचि ताकिह कीयग़ा. बाराह्‌क इतेके अद कुदताङ तनाङ गोटिङ वेहो आयग़ा, मति अद बेदिन केंजिह्‌ता, अद केंजतदिने वेहतग़ा. ओसो बेव गोटिङ आयना मन्ह्‌ताङ, अविस्किन वेहतग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","इव गोटिङ अद नयग्डाहि केंजिह्‌ता, अहे केंजिसि मीक वेहतग़ा, अह कीसि नाक मान ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","बेव पोल्‍लोङ बाबानाङ आंदुङ, अव कतम नावाङ आंदुङ. अदिनेनाह्‌कु पवित्र जीवा नयग्डाहि केंजिह्‌ता, अहे केंजिसि नावाङ पोल्‍लोनु मीक वेहतग़ा इनजोर, नना मीक वेहच मतन. ");
INSERT INTO mrr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“गय्क मनेके मीक नना दिसोन आयकन, पया पेग़्के गय्क मनेके, मीट नाक ओसो ऊळकिर,” इनजोर येसु तनाङ कग़यवालोरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","इद पोल्‍लो केंजिसि, ओर कग़यवालोरग्डाहि उय्तुर तमतमाय इंदुर, “‘गय्क मनेके मीक नना दिसोन आयकन, पया पेग़्के गय्क मनेके, मीट नाक ओसो ऊळकिर,’ इद्रम माक बाराह्‌क इन्ह्‌तोग़ कोनि? ओसो ‘नना बाबानेके दाकन, अदिह्‌क इह आयग़ा,’ इद्रम वेग़ इन्ह्‌तोग़, इद बहु? ");
INSERT INTO mrr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘गय्क मनेके,’ इनजोर वेग़ इन्ह्‌तोग़, इद बेद्रमता गोटि? वेग़ बाताङ वेहतह्‌तोग़, अव माक मुर्तिय तेळियोङ!” इंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ओर इद गोटटुन येसुन ताल्ह्‌कना गावले इनजोर, तमाय पोटालोप्पा तासिस मतोर, तान येसु पुन्जि ओरिन इतोग़, “‘गय्क मनेके मीक नना दिसोन आयकन, पया पेग़्के गय्क मनेके, मीट नाक ओसो ऊळकिर,’ इनजोर इतन, अदे गोटटुन मीट ओर्विह्‌क-ओर्वोग़ ताल्ह्‌किंदिरा? ");
INSERT INTO mrr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","इह केंजाट, नना सेतेम वेहतह्‌नन, मीट बार हामुर-रेगाङ अळयकिर, दुनियातोर बार गिर्दा कीयनुर. मीक दुकम आयग़ा, आतेक तेला मीवा दुकम पया मायिसि गिर्दा वायग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","रिकम आयनद आंचाळि गट्ने एवतस्के, तान्क पकाय नोयना तेदिह्‌ता. मति रिकम आतस्के, पूना मन्कल दुनियाते पुट वातोग़ इनजोरे, गिर्दा आस्ता. गिर्दा आसि ताना मुनेता तिपलतुन माग़्ङिह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","अद्रमलेह्‌का मीक वने इंजेके दुकम वाता, मति नना मीक ओसो कलियकन, अस्के मीट मीवा जीवाते गिर्दा आयकिर. अद गिर्दातुन बोग़े ऊंदोग़ आयनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","अद वेलाते मीट नाकु बेदे पोल्‍लो ताल्ह्‌कविर आयकिर. इह केंजाट, नना सेतेम वेहतह्‌नन, मीटु नावा पेदिर वेहच, बाबान बेदे आयि ताल्ह्‌ककिर, अस्के ओग़े कुदि मीकु अदिन ईयनोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","मीट इंजेक आनाहि नावा पेदिर वेहचि बातय ताल्ह्‌कविर. ताल्ह्‌काटु, अस्के मीक दोर्कग़ा, दोर्किसि मीवा गिर्दा पूरा निंदग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“इव गोटिङ मीकु पुन्पिह कीयनव पीटोने वेहतन. मति बाबाना लोप्पा पिङम-पङम वेहतनद वेला वासोर मन्ह्‌ता. अद वेला वातस्के, नना ओसो पुन्पिह कीयनव पीटोङ मीकु बेस्केन वेहोन आयकन. ");
INSERT INTO mrr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","अद वेलाते नावा पेदिर वेहच, सीदा मीटु ओन ताल्ह्‌ककिर, अस्के मियेनाह्‌क नना बाबान ताल्ह्‌कलाह, बातय गर्ज मनो आयग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","बाराह्‌क इतेके बाबाल कुदि मीक जीवा कीस्तोग़. मीट नाक जीवा कीयलाह आतिर, ओसो नना देवुळताहि वातन इनजोर नमलाह आतिर, अदिह्‌क बाबाल मीक जीवा कीस्तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","बाबाल इद बूमतगा नाक लोहतोग़. इंजेक ओसो नना इद बूमतुन विळ्सिसि बाबानेकेन दाय्ह्‌नन,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","अस्के ओनाङ कग़यवालोर इतोर, “ऊळा, बेद्रम निमा इंजेक पिङम-पङम वळ्ह्‌किह्‌निन, पुन्पिह कीयनव पीटोङ वेहविन! ");
INSERT INTO mrr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","इंजेक निमा कतमतविनु पुह्‌निन इनजोरे माक तेळियता. इनजोर कोनि बोग़ाय नीक ताल्ह्‌कनद गर्ज इले. अदिह्‌क इंजेक माटु निमा देवुळताहि वातिन इनजोर, सेतेम पोयह्‌नोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","येसु ओरिन इतोग़, “इंजेक मीट नमिह्‌निरा? ");
INSERT INTO mrr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ऊळाट, इंजेक इद्रमता कगो वायग़ा, ओसो वातपे मन्ह्‌ता, अस्के मीट बिरोबटो आयकिर, बोनाङ अग़िङ ओग़ आयकिर, नाक वग़ोने विळ्सकिर. तेला मति नना वग़ोनन आयोन, बाबाल मात्रम नावा तोळ मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","नाक नमिसि मीट सुकमते मनदना इन्जि, इव गोटिङ मीक वेहतन. दुनियातोर मीक तिपल कीयनुर निटमे, मति दीरा पोय्म्ह्‌टु, नना दुनियातुन गेल्सतन,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","2","इव गोटिङ वळ्ह्‌कतस्के, येसु पोग़ोटा बूमतेके ऊळतोग़, अह कीस देवुळबाबान वळ्ह्‌कतोग़, “ए बाबा, नावा हायना कगो एवता. बोरिन निमा नाक ईतिन, ओर सबेटोरिह्‌क नना अमेसाता पिसमुळ ईयना इन्जि, निमा नाक माने-मन्कना पोग़ोन अदिकर ईतदे मन्ह्‌ता. अहलेह्‌का बाबा, नना नीक मान ईयना इन्जि, निमा नाक मान ईमु. ");
INSERT INTO mrr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","निमा वग़ोनिन सेतेम देवुळतिन इन्जि नीक पुनदना, ओसो निमा लोहतोग़ पिसिह केवाल येसु किर्स्तुन पुनदना, इदे अमेसाता पिसमुळ आंदु. ");
INSERT INTO mrr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","बेद कबळ निमा नाक कीयलाह ईतिन, अदिन मारिह कीसि, नना इद बूमतगा नीक मान ईतन. ");
INSERT INTO mrr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ए बाबा, इद दुनिया पुटनामुने, बेद्रम माट इर्वल ऐंगे डीसातोरल मतल, अद्रमे इंजेके नीवा संगे नाक डीसातोग़ आयलाह ईमु. ");
INSERT INTO mrr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“बोर मन्कलोरिन निमा इद दुनियातोरग्डाहि नाक ईतिन, वेरिह्‌क निमा बेद्रमतोनिन इन्जि, नना पुन्पिह कीतन. वेर नीवा मन्कलोर आसि, वेरिन निमा नाक ईतिन. ओसो वेर नीवा पोल्‍लोतुन केंजिस, अहलेह्‌का कीतोरु. ");
INSERT INTO mrr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","बेद डीसा, बेद बुदि, बेव पोल्‍लोङ निमा नाक ईतिन, अव कतमे निटम नियग्डाहि वातव आंदुङ इनजोर, वेरिह्‌क इंजेक तेळियता. ");
INSERT INTO mrr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","बाराह्‌क इतेके बेव गोटिङ निमा नाक वेहतिन, अविस्किन नना वेरिह्‌क वेहतन. नना वेहतस्के वेर अविस्किन पोयतोर, पोसि नना नियग्डाहि पेसिस वातन इनजोर, वेर करले पुतोर, ओसो निमाने नाक लोहतिन इन्जि वेर नमतोर. ");
INSERT INTO mrr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","वेरेनाह्‌क नना इंजेके नीक ताल्ह्‌किह्‌नन. नना दुनियातोरेनाह्‌क ताल्ह्‌कोन, मति बोरिन निमा नाक ईतिन, सिरपि ओरेनाह्‌के ताल्ह्‌किह्‌नन, बाराह्‌क इतेके वेर नीवाये लोकुर आंदुर इनजोरे. ");
INSERT INTO mrr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","बोर बोर नावा लोकुर आंदुर, ओर कतमतोर नीवा वने लोकुर आंदुर. ओसो बोर नीवा लोकुर, ओर नावा वने लोकुर. ओसो वेरा नडुमि नावा डीसा तोहतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","नेटाहि नना इद बूमते ओसो मनोन आयकन. नना नियके वाय्ह्‌नन, मति वेर इतेके इद बूमतेन मनदनुर. ए पवित्र बाबानिन, बहलेह्‌का माट इर्वल उंद आस मह्‌नल, अहलेह्‌का वेर वने उंद पट आयना इन्जि, वेरिन काप आडा. ओसो निमा नाक नीवा पेदिरता लाव ईतिन, अद लावते वेरिन काप आडा. ");
INSERT INTO mrr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","नना वेरा संगे इद दुनियाते मनेके, नाक ईतद नीवा पेदिरता लावते, वेरिन राका कींदन. बोग़ बूळेम आयवाल मन्ह्‌तोग़, ओग़ यहुदान विळ्सिसि, वेरग्डाहि बोग़े बूळेम आयोग़. ओग़ बूळेम आयवाना लोप्पा, सास्त्रमते रासतद पोल्‍लो करल आयना इन्जि, इव गोटिङ आयनाय गावले. ");
INSERT INTO mrr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“नना इंजेके नियके वाय्ह्‌नन, बाबा. मति वेरा जीवाते नावा गिर्दा पूरा निंदना इन्जि, नना इद बूमते मनेकेने, इव गोटिङ वेहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","नना नीवाङ पोल्‍लोङ वेरिह्‌क काग़्हतन. दुनियातोर इतेक, वेरिन कोंटे कीसोर मन्ह्‌तोर; बाराह्‌क इतेके, बहलेह्‌का नना इद दुनियातोनन आयोन, अहलेह्‌का वेर वने इद दुनियातोर आयोर. ");
INSERT INTO mrr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","निमा वेरिन इद बूमताहि पेहचीम इनजोर ताल्ह्‌कोन. मति वेर इद बूमते मनेके, देयह्‌कना मुक्यानग्डाहि वेरिन पिसिह कीम इन्जि, नना नीक ताल्ह्‌किह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","बहलेह्‌का नना इद दुनियातोनन आयोन, अहलेह्‌का वेर वने इद दुनियातोर आयोर. ");
INSERT INTO mrr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","नीवा सेतेम पोल्‍लोता मेटे, नीके माळना इन्जि, वेरिन अलग कीस तासा. ");
INSERT INTO mrr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","बहलेह्‌का निमा नाकु दुनियातोरगा लोहतिन, अद्रमे नना वने वेरिन इद दुनियातोरगा लोहतन. ");
INSERT INTO mrr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ओर सेतेम पुन्जि, दुनियाताहि अलग ताकना इन्जि, नना वने इद दुनियाताहि अलग आस ताकिह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“नना सिरप वेरेनाह्‌के आयो, मति बोर वेरा पोल्‍लोतुन केंजिसि नाक नमनुर, ओरेनाह्‌क वने नना नीक ताल्ह्‌किह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ए बाबा, बेद्रम निमा, नना, ऐंगे जोळेम आस मह्‌नल, अहे ओर सबेटोर उंद आसि मयगा जोळेम आस मनिर. अस्के निमा नाक लोहतिन इनजोरे, दुनियातोर पुनदनुर. ");
INSERT INTO mrr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","निमा नाक लोहतिन, ओसो बेचोन निमा नाक जीवा कीतिन, अचोने ओरिन वने निमा जीवा कीतिन इनजोर, दुनियातोर पुनदनेनाह्‌क, ओर कतमतोर उंद एका आयिर. बहलेह्‌का माट इर्वल उंद आस मह्‌नल, अहलेह्‌का ओर वने उंद एका आयिर: नना ओरगा जोळेम आस मह्‌नन, ओसो निमा नयगा. इदिनेनाह्‌क बेद्रम निमा नावा संगे उंद आसि, नाक मान ईतिन, अद्रमे नना ओरा संगे उंद आसि, अदे मान ओरिह्‌क ईतन. ");
INSERT INTO mrr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“बाबा, ओरिन निमाने नाक ईतिन. ओर नावा डीसातुन ऊळनेनाह्‌क, बेगा नना दाय्ह्‌नन, अगाने ओर वने नावा संगे मनदना, इदे नावा विचर आंदु. अद डीसा निमा नाक ईतिन बाराह्‌क इतेके, दुनिया पुटनामुनेने नाक जीवा कीतिन. ");
INSERT INTO mrr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“ए सेतेमतोग़ बाबानिन, नीक दुनियातोर पुनोर; मति नना नीक पुह्‌नन. ओसो निमा नाक लोहतिन इनजोरे, नाक नमवालोर वने पुन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","बेद्रम निमा नाक जीवा कीय्ह्‌निन, अद्रमे वेर वने जीवा केवालोर आयना. ओसो नना वने वेरगा जोळेम आस मनदना इन्जि, नना नीक ओरिन पुन्पिह कीसीतन, ओसो कीसोर मनदकने,” अह इन्जि येसुना पार्तना मारता. ");
INSERT INTO mrr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","इचोन वळ्ह्‌किसि, येसु तनाङ कग़यवालोरा संगे पेसतोग़, पेसिसि किद्रोन इनदनद लपातुन वेंडिसि, अबर बाजे अतोर. अगा जय्तुन मराङ ओग़्सतद उंद वाळुम मता, अगान ओर नेङतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","येसु ऊक-ऊके तनाङ कग़यवालोरा संगे अद जागाते कलियिंदोग़, अदिह्‌क ओन कोंटेतोरा कयदे पोस एवाल यहुदाह्‌क वने, इद जागा एर्का मता. (येसु अदे जागातगा दोर्कनोग़ बहे इन्जि यहुदाल पुतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","अदिह्‌कु पेर्मालोर ओसो परुसिर, वेर लोहतोर पह्‌रातोर, ओसो रोम राजेमतोर सीपय्कना उंदि पल्टन, वेर सबेटोरिन यहुदाल अग़ तोहचोर ततोग़. वेर सोह्‌ळाङ, कंदिस्क ओसो वीस्राङ पोसि अगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","नाक बाताल आयनद मन्ह्‌ता इन्जि, येसु कतम पुन्जिये मतोग़. पया ओग़ ओरा मुनेह वासि, “मीट बोन पर्ह्‌किह्‌निर?” इनजोर ओरिन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","अस्के ओर “नासरेत नाटेनोग़ येसुन पर्ह्‌किह्‌नोम,” इनजोर इतोर. अस्के येसु ओरिन इतोग़, “ओनन ननान आंदन!” (अस्के ओन नाळेह कीस पोस एवाल यहुदाल वने, ओरा संगे अगान निच मतोर.) ");
INSERT INTO mrr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","येसु ओरिन ओनन ननान आंदन इनजोर इतस्के, ओर पेग़्के गुचिसि, पेत वेळ्किस अरतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","पया येसु ओसो ओरिन ताल्ह्‌कतोग़, “मीट बोन पर्ह्‌किह्‌निर?” ताल्ह्‌कतस्के “नासरेततोग़ येसुन पर्ह्‌किह्‌नोम,” इन्जि ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“नना मीक ओनन आंदन इनजोर वेहतन अले! नाक पर्ह्‌किह्‌निर इतेके, वेर नावा संगे मनवालोरिन विळ्साटु,” इन्जि येसु ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“बोरिन निमा नाक ईतिन, ओरग्डाहि वग़ोग़ वने लेसोग़ आयनोग़,” इद्रम येसु मुने देवुळबाबान वळ्ह्‌किस मतोग़, अद पोल्‍लो करल आयलाहि, वेरिन विळ्साटु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","सिमोन पत्रुनगा उंद दाळो कसेग़ मता, ओग़ अदिन तेंडिसि, मोदुल पेर्माना ओर्युलतोन वग़ोन कोटलाह, अद कसेटे ईतोग़; अद कसेग़ि ओग़ ओर्युलतोना तिनळ केवदुन पोडोह देगनाह दल्गता. (ओग़ ओर्युलतोना पेदिरि माल्कोसि आंदु). ");
INSERT INTO mrr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","अस्के येसु पत्रुन इतोग़, “नीवा कसेटुन दाळोतगा तोग़्का, रा! बाबाल नयेनाह्‌क तासतद तिपलतुन, नना मुर्तिय एनोन आयकना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","पया अगा वातोर सीपय्क, ओरा मुक्याल, ओसो मंदिरता पह्‌रातोर, वेर सबेटोर येसुन पोस दोहचि, ओन मुने अनाल इनवानगा ओतोर. बाराह्‌क इतेके अद वर्सा मोदुल पेर्माल कयपाल इनवाल मतोग़, वेनाय मामाल अनाल आंदोग़, (ओग़ मुनेतोग़ मोदुल पेर्माल आंदोग़). ");
INSERT INTO mrr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“वग़ोग़ मन्कल लोकुरेनाह्‌क हायना, इवटेन मावा पाय्दा आयग़ा,” इद्रम इन्जि, यहुदिराङ पेदल्किन मुने वेहच मतोग़, ओग़ वेग़े कयपाल इनवाल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","पया सिमोन पत्रु ओसो दुस्रोग़ कग़यवाल, वेर इर्वुर येसुना पयाह पयाह दायलाह आतोर. दुस्रोग़ कग़यवान मोदुल पेर्माल पुताह्‌कु, येसुना संगे ओर ओनु पेर्माना रेसातगा नेङलाह ईतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","मति पत्रु इसि, पलत अग़दगा निच मतोग़. अदिह्‌कु पत्रुना संगतोग़ मोदुल पेर्माना पुतोग़ मताह्‌कु, मल्स पलत वासि अग़दगा राका मनदनद पिलातुन वेहतोग़, अद पया ओर पत्रुह्‌क लोप्पा ओळियलाह ईता. ");
INSERT INTO mrr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","अस्के अद राकातद ओर्युल लेया पत्रुन इता, “निमा इंका ओग़ मन्कना कग़यवानिने बहे, एय?” इनजोर ताल्ह्‌कता. अस्के “एंह-एंह, नना आयोन!” इन्जि पत्रु तान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","अद तूकने इर्ङम मता, अदिह्‌कु ओर्युलतोर ओसो मंदिरता पह्‌रातोर, इर्किना किस नीर्विह कीसि, आग़सोर निच मतोर. अस्के ओरा नडुम पत्रु वने निचि, किस आग़सोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","इद्रम आनेके, मोदुल पेर्माल येसुनु तनाङ कग़यवालोरा लोप्पा, ओसो तना काग़्हमुळता लोप्पा ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","येसु ओन इतोग़, “नना कतमतोरा मुनेह पिङम-पङमे वळ्ह्‌कतन. नना कुस्क्ने बातय वळ्ह्‌कोन, मति बेगा सबेटोर यहुदिर कलियिंदुर अगा, इतेके पार्तनाताङ लोह्‌कने आयि, मंदिरते आयि, इद्रमताङ जागाने नना अमेसा काग़्हन्दन. ");
INSERT INTO mrr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","अह आसि, नाक बार्किया ताल्ह्‌किह्‌निन? नना बाताङ काग़्हतन, अदिन बोर केंजतोर, ओरिह्‌क एर्काय मन्ह्‌ता. ओरिने ताल्ह्‌किस ऊळा,” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","येसु अह इतस्के, अगा निच मनवाल मंदिरता पह्‌रातोग़ ओर्वोग़, येसुन चेट इनाह चापुळ ईतोग़, ईसि इतोग़, “निमा मोदुल पेर्मान इह बह इह्‌निन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","“नना बेदाय गल्ति पोल्‍लो वळ्ह्‌कतन इतेके, बाताल गल्ति वळ्ह्‌कतनो, अदिन वेहा. मति करल वळ्ह्‌कतन इतेके, निमा नाक बाराह्‌क नल्हतह्‌निन?” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","अस्के अनाल इनवाल पेर्माल तना अने, मोदुल पेर्माल कयपानके, येसुन दोहतदिन लेहवाये, अहे लोहचीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","पया सिमोन पत्रु किस आग़सोर निच मतस्के, ओर ओन ताल्ह्‌कतोर, “बह, निमा वने ओनाङे कग़यवानिना?” इतस्के, “एंह-एंह, नना आयोन,” इनजोर पत्रु कैंगम आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","अगा निच मनवालोरगा मोदुल पेर्माना ओर्वोग़ ओर्युलतोग़ मतोग़, पत्रु मुने बोना केवदुन डायिस मतोग़, ओनाय जीवातोग़ वेग़ आंदोग़. पया ओग़ पत्रुन इतोग़, “नीक बह नना ओना संगे जय्तुन मराना जागातगा मतिन अस्के ऊळोन, डा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","तेला मति पत्रु “एंह-एंह, नना आयोन,” इनजोर पका कैंगम आतोग़. अदे गट्काते तलाकोग़ कूसता. ");
INSERT INTO mrr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","पया यहुदिराङ पेदल्क पङवियनामुनेने, येसुनु कयपानग्डाहि रोम सर्करतोग़ गुमसि, पिलाति इनवानगा ओतोर. माकु आवना पंडुमता पोल्वाते, लोह्‌कने कुळ्प तिनदना मन्ह्‌ता, (अगा दुस्रा जाततोनालोन अतेके,) माट कळ्‍वोग़ आयकल इन्जि, ओर गुमसिना लोता लोप्पा नेङोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","अदिह्‌क पिलाति लोता पलत पेसिस ओरिन इतोग़, “मीट वेग़ मन्कना बेद कसुर तासिह्‌निर?” ");
INSERT INTO mrr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ओर पिलातिन इतोर, “वेग़ कसुरतोग़ आयवेके, माट वेन नियके पोस तवोम आवेरोम, महरज,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","“अह इतेके मीटे वेन ओसि, मीवाङ अडोङ मतपु, वेना नेयम कीम्ह्‌टु,” इन्जि पिलाति इतोग़. अस्के यहुदिराङ पेदल्क इतोर, “(मावा अडोना उतुरते, ओन हव्कना गावले; मति) मीट रोम सर्करतोरिरे माकु बोनाय हव्कनद नेयम कीयलाह अदिकर एविर!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(येसु तना बेद हामुरते हायवाल मतोग़, अदिन वेहतह्‌पा बेव पोल्‍लोङ वळ्ह्‌किस मतोग़, अव करल आयनेनाह्‌क, इह आता.) (बाराह्‌क इतेके सिरप रोम सर्करतोरे हव्कनागुटातगासिक्सा कीस हव्किंदुर.) ");
INSERT INTO mrr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","अस्के पिलाति लोता लोप्पा अन्जि, येसुन तनगा केयिस ताल्ह्‌कतोग़, “बह, निमा यहुदिरा राजानिना?” ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","“इद पोल्‍लो नीवाय विचरते ताल्ह्‌किह्‌निना, आयवेके यहुदिर नीक वेहताह्‌कु ताल्ह्‌किह्‌निन?” इन्जि येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","“निमा नाक यहुदिरा लोप्पा बाराह्‌क ताल्ह्‌किह्‌निन? नना यहुदि जाततोनना? नीवाय लोकुर, नीवाङे पेर्मालोर कोनि, नीक नयके पोस ततोर. निमा बेद कसुर कीतिन?” इनजोर पिलाति येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","येसु इतोग़, “इद दुनियातोर नाक राजाल केवोर. नावा राजेम इद दुनियाता मन्ज मतेके, नना यहुदिराङ पेदल्कना कयदे अरयनायो इनजोर, नावा सेवा केवालोर लळय कीस मनेर. मति नावा राजेम इद बूमता आयो,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","अस्के पिलाति ओन इतोग़, “अह इतेक निमा राजानिना?” येसु ओन इतोग़, “निमा इह्‌निन, अहे. सेतेमता लोप्पा वेहतलाहे, नना इद बूमते पुट वातन. बोर सेतेमते ताकिह्‌तोर, ओर नावाङ पोल्‍लोङ केंजिह्‌तोर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“सेतेम इतेक बातालि, बोर पुन्ह्‌तोर?” अह इनजोर पिलाति लोताहि ओसो पलत पेसिसि, यहुदिराङ पेदल्किन इतोग़, “नाक वेनगा बातय कसुर दिसो. ");
INSERT INTO mrr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","मति आवना पंडुमता दियाते, जेलते मनवाल वग़ोन नना विळ्सना, इद्रम मीवा रीत मन्ह्‌ता. अदिह्‌क मीट इह्‌निर इतेके, नना मियेनाह्‌कु यहुदिरा राजान विळ्सकन,” इन्जि ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","अस्के ओर पका केयिस-केयिस इतोर, “वेन विळ्समा, मति मयेनाह्‌क बरबसिन विळ्सा!” (बरबसि इनवाल बेरा डाकु आंदोग़, ओग़ जेलते मतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","पया पिलाति येसुन जूताते नल्हता वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","पया सीपय्कु कोयेना गीळ पंडिसि, ओना तलातगा गळ्म कीतोर, कीसि डुंगा पंड रंगता जगा (राजाल केग़तपु) ओन केग़्‍पिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","अह कीसि ओर पास्कलाह आतोर, “जोहर यहुदिरा राजानिन!” इन्जि, ओन चापुळ वने ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पया पिलाति ओसो पलत पेसिसि लोकुरिन इतोग़, “ऊळाट, ओनगा नाक बातय कसुर दोर्को, इद मीक तेळियना इन्जि, नना ओन मियके पलत पेहच ततह्‌नन.” ");
INSERT INTO mrr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","अस्के येसु कोयेना गीळ ओसो डुंगा पंडलेह्‌काडा जगा केग़्सि, पलत पेसतोग़. अस्के “इंजेके वेग़ मन्कन ऊळाट!” इन्जि, पिलाति ओरिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ओन ऊळिस पेर्मालोर ओसो मंदिरताङ पह्‌रातोर “ओन हव्कनागुटातगा वेळ्हा, हव्कनागुटातगा वेळ्हा!” इनजोर केयतोर. अस्के पिलाति ओरिन इतोग़, “आयो, मीटे ओसि ओन वेळ्हाटु! नाक इतेके, ओनगा बेदे कसुर दोर्को,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","अस्के (माक ओन हव्कलाह अदिकर इले इनजोर पुन्जि) यहुदिर ओन इतोर, “मावा सास्त्रमताङ अडोङ मन्ह्‌ताङ, अव अडोङ वेहतपु, वेग़ु नना देवुळता मग़नन इनजोर इताह्‌कु, वेग़ हायनाय गावले.” ");
INSERT INTO mrr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","इद पोल्‍लोतुन केंजिसि, पिलाति पकाय रेयतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अस्के पिलाति ओसो तना लोता लोप्पा, येसुन ओसि ओन इतोग़, “निमा बेग्डाहि रेगतिन, बह पुटटिन, डा?” इन्जि ताल्ह्‌कतोग़. मति येसु इतेक बातय वळ्ह्‌कोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“निमा नावा संगे वळ्ह्‌कविना? नीक विळ्सनद अदिकर नाके मन्ह्‌ता, ओसो हव्कनागुटातगा वेळ्हतनद अदिकर नाके मन्ह्‌ता इनजोर, बह निमा पुनविना?” इन्जि पिलाति येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","येसु ओन इतोग़, “नीकु देवुळताहि ईतद अदिकर लेवेके, नावा पोग़ोन नीवा बेदे अदिकर इले आस मनालि. अदिनेनाह्‌कु बोग़ (पेर्माल पुन्जि-वेन्जि) नाक नीवा कयदे ईतोग़, ओग़े नीकाय वीळिसि वेल्‍ला पापम कीतोग़.” ");
INSERT INTO mrr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","इदिन केंजिसि, पिलाति येसुनु विळ्सलाह ऊळसोरेन मतोग़. मति यहुदिर इतेके, कियोग़-मुयोग़ केय बोटटोर, “निमा वेन विळ्सतिन इतेके, रोम राजेमता कय्सर राजाना अडम आतिन; (ओनगा माट नीवा रिपोट कीकोम). बोग़ नना राजानन इन्ह्‌तोग़, ओग़ कय्सरना अडमतोग़ु,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","इव पोल्‍लोन केंजिसि, पिलाति येसुन पलत पेहच ततोग़, तचि नेयम कीयनद कुर्सते ओग़ उदतोग़. इद कुर्स गोळा इनदनद जागातगा मता (तान इब्रि पोल्‍लोते “गब्‍बता” इन्ह्‌तोर). ");
INSERT INTO mrr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","अद दिया आवना पंडुमतेनाह्‌क तयर आयनद दिया मता, जोक-जोक नेक निच मता. अस्के पिलाति यहुदिरिन पास्कतप इतोग़, “ऊळाट, वेग़ मीवा राजाल!” ");
INSERT INTO mrr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","अस्के ओर केयतोर, “वेन ओम! वेन ओम! हव्कनागुटातगा वेळ्हा!” इनजोर इतोर. अस्के पिलाति ओरिन इतोग़, “नना मीवा राजानु हव्कनागुटातगा वेळ्हतलाह उकुम ईकना?” अस्के पेर्मालोर इतोर, “कय्सर राजान विळ्सिसि, माक बोग़े राजाल इलेग़!” ");
INSERT INTO mrr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","(ओरा पोल्‍लो केंज पग़वाह्‌कु,) आक्रिते पिलाति येसुन हव्कनागुटातगा वेळ्हतलाह, ओरा कयदे विळ्सिसीतोग़. सीपय्क पया येसुन पोसि ओतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","येसु तना हव्कनागुटातुन कांजिसि, तला-टाप्रा इनदनद जागातगा एवतोग़ (इब्रि पोल्‍लोते अद जागातुन “गुल्गुता” इन्ह्‌तोर). ");
INSERT INTO mrr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","अगा (ओर ओनाङ केग़ताङ गेंदेङ कुळ्हचि,) ओन हव्कनागुटातगा दोहचि, मोल्‍लाङ कोह्‌किसि वेळ्हतोर. ओसो येसुन वेळ्हतस्के, इर्वुर कसुरतोरिनु, येसुन नडुम कीसि, इके ओर्विन, अके ओर्विन, हव्कनागुटानगा वेळ्हतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पया पिलाति, “वेग़ नासरेततोग़ येसु यहुदिरा राजाल” इन्जि, इद्रमता कसुर तोहतनद बलाते रासिसि, येसुन वेळ्हतद गुटातगा कोटलाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","येसुन वेळ्हतद जागा सहरता एरे मताह्‌कु, पंडुमतुह्‌क वातोरु वेल्‍लाटोर यहुदिर अद बलातुन अर्विंदुर. अदु इब्रि, युनानि ओसो रोमि, इव मूंड बासाने रासतद मता. ");
INSERT INTO mrr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","अदिह्‌के यहुदिराङ पेर्मालोर पिलातिन इतोर, “‘यहुदिरा राजाल,’ इनजोर रासमा, मति ‘नना यहुदिरा राजानन, इद्रम इतोग़,’ इनजोर रासा,” इन्जि पेर्मालोर कट्ला कीतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","अस्के पिलाति इतोग़, “इंजेके नना रासतने, रासतन. अहे मनि!” ");
INSERT INTO mrr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","सीपय्क येसुनु हव्कनागुटातगा वेळ्हतोर अस्के, ओनाङ गेंदेङ पोयतोर, अह कीसि वग़ोह्‌क-वग़ोह्‌क उंद-उंदि, इद्रम नालुङ बाटाङ कीतोर. ओर ओना लोप्पाडा आङतुन वने पोयतोर. अद आङि कोटटद इले, मति पोग़ोटाहि काल्कनगा एवनाहि, पूरा अर्हतद मता. ");
INSERT INTO mrr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","अदिह्‌क ओर सीपय्क तमतमाय इतोर, “तेन माटु अग़्हवल, मति इद आङि बोना नसिबते मन्ह्‌तायो, तेन माट सीटिङ वाटिस ऊळकल, रा!” इतोर. इन्जि ओर अहे कीतोर. ओर अह कीतस्के, सास्त्रमते मुने रासतद पोल्‍लो करल आता, अद सास्त्रम इह मन्ह्‌ता: ओर नावाङ गेंदेङ तमाय तूसतोर, ओसो नावा आङतेनाह्‌कु सीटिङ वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","हव्कनागुटाता एरे येसुना तलोग़ि, ओसो तमकूचि, ओसो कोल्पाना मुते मरियालि, ओसो मग्डला नाटेनद मरियालि, इव अगान निच मताङ. ");
INSERT INTO mrr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","अस्के बोन येसु पका जीवा कीतोग़ कग़यवाल इन्ह्‌तोर, ओग़ु येसुना तलिना बाजे निच मतोग़. ओर इर्विरिन ऊळिसि, येसु तना तलिन इतोग़, “वेग़ ऊळा बायि, इंजेटाह नीवा मग़ि!” ");
INSERT INTO mrr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","पया ओग़ कग़यवान इतोग़, “ऊळा, इंजेटाहि इद नीवा यायाल आंदु.” अस्केडाह पया येसुना तलिनु, ओग़ु तना लोन ओसि अय कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","अस्के पया, नावा कबळतुन नना कतम मारिह कीतन इन्जि, येसु पुतोग़. अस्के, सास्त्रमते रासतद पोल्‍लो करल आयना इन्जि, “नाक एग़ उनडा वसता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","अगा ओयतद अंगुर जोमाते निहच मतद उंदि अळ्का मता. इनजोर ओरु अद अळ्कातगा बूबिलतुन मुळ्हचि, बळ्गातगा तासिसि, येसुना तोड एरे ओसि, ओन ओयतद अंगुर जोमा ऊहतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","अस्के येसु तानु ऊतिसि, “नना नावा कबळतुन कतम मारिह कीतन!” इनजोर इतोग़. अह इतस्के, इळ्न तला वग़्हचि, ओग़ हातोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","इमा दिया वारमता पोल्वादिया मता (अद पोल्वादिया इतेके, आवना पंडुमता बेह्‌रा पोल्वादिया आंदु). (यहुदिराङ अडोङ वेहतपु,) पोल्वादियाते हव्कनागुटानगा सेत्ताङ मनदलाह पोलोङ, अदिनेनाह्‌कु ओराङ पेदल्कु पिलाति गुमसिनगा वासि, “(ओर मुवुरा जीवा चट्पिट अनि इनजोरे,) ओराङ काल्किन ओग़्हचि, सेत्तान रेहता वेहा,” इन्जि ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","अस्के गुमसि वेहताह्‌कु, सीपय्क वासि, येसुना संगे वेळ्हच मतोर इर्वुराङ आसि काल्किन ओग़्हतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","मति येसुनगा एवतोर अस्के, वेग़ हातदिन ऊळिसि, वेनाङ काल्किन ओग़्होर. ");
INSERT INTO mrr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","मति येसु निटम हातोग़ इनदलाहि, ओर्वोग़ सीपय येसुना सेंकातुह्‌कु गोग़्काते कोटटोग़, अस्के चट्‌ने नेतुरि ओसो एग़ वाङता. ");
INSERT INTO mrr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","इद पुस्तकतुन रासवाल कुदि अदिन ऊळतोग़, ऊळिसि मीट येसुन नमना इन्जि वेहतह्‌तोग़.(देवुळ लोहतोग़ राजाल येसुना लोप्पा) इद ओना साक्सि करलताये आंदु इन्जि, ओन्क एर्काये. ");
INSERT INTO mrr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","ओना उंदाय बोकातुन ओग़्होर आयनुर, ओसो ओन कोटटोरु ओन ऊळनुर इनजोर, देवुळ लोहवाल पिसिह केवाना लोप्पा, सास्त्रमते रासिस मनदनव इव पोल्‍लोङ करल आयना इन्जि, येसुह्‌क इह आता. ");
INSERT INTO mrr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","इव गोटिङ आतापया, अरिमतेया नाटेनोग़ ओर्वोग़, योसेपि इनवाल, पिलातिनगा अन्जि, “येसुना सेत्तातुन पोहतलाह ओयकन,” इनजोर ताल्ह्‌कतोग़. (वेग़ योसेपि इतेके यहुदिराङ पेदल्किन रेयिसि, येसुनु कुस्क्ने नमिंदोग़.) अस्के गुमसि पिलाति ओम्ह्‌ट इनजोर इताह्‌कु, ओर पया येसुना सेत्तातुन रेहचि ओतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","योसेपना संगे निकोदेमि इनवाल वने, येसुन पोहतलाह वातोग़. (वेग़े कोनि मुने उंद दिया नग़्का, येसुन कलियलाह वास मतोग़.) वेग़ु सेत्तातुन ओकलाह डेडा वीसा मूंडु (33) किलोङ, गब एग़्स्कनद मराता पिंडि ओसो अतर्नेय, काल्वा कीसि तच मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","यहुदिरा पोहतना उतुरते, हामुर-गेंदेनगा इद काल्वा कीतद अतर्नेयदुनु सलिसि, येसुना सेत्तातुन ऊर्हतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","येसुन वेळ्हच मतद जागातगा, मराना पेंदाता उंद वाळुम मता. अगाने उंदि बेरा आदतगा, मन्कन पोहतलाह पूना पांजा तर्वतद मता. अद गुमयाते मुने बोने पोहवाय मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","अद गुमया एरे मताह्‌कु, येसुन अगान पोहतोर, बाराह्‌क इतेके यहुदिरा पोल्वादिया गय्क इतेके सुरु आयना मता, (दुस्रा जागा पर्ह्‌कलाह मोका इले आसि). ");
INSERT INTO mrr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","मूंड दियाने, इतेके वारमता मुनेता दिया ऐतारम, कोग़ कूसेङ पिङपङ आयनामुनेने, मग्डला नाटेनद मरियाल इनदनदु, गुमयातगा वाता. अस्के गुमयाता अग़दुह्‌क तिळ्ह्‌प कीस मतद बंडा, ओर्के तेंडिस मतद तान्क दिसता. ");
INSERT INTO mrr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","अस्के सिमोन पत्रुनके ओसो येसु पका जीवा कीतोग़ कग़यवानके, अद वित वाता, वासि इता, “ओरु सामिना सेत्तातुन गुमयातग्डाह ओतोर, ओसो अदिन बेगा तासतोरो, अद माक तेळियो” इता. ");
INSERT INTO mrr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","इदिन केंजिसि, ओर इर्वुर गुमयातके दायलाह पेसतोर. ");
INSERT INTO mrr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","अस्के ओर इर्वुर आसि ऐंगे वित बोटटोर. इह वितेङ, अह वितेङ, पत्रुना तोळतोग़ गुमयातगा मुने एवतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","एव्सि, ओल्‍लिस ऊळनेके, ओन्क सिरपि हामुर-गेंदेङ अर्स मतव दिसताङ, मति ओग़ लोप्पा नेङोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","गळ्क मनेके, सिमोन पत्रु वने ओना पयाह एवतोग़. एव्सि तुर्म्ने लोप्पा नेङतोग़, नेङिसि हामुर-गेंदेङ अरतविन ऊळतोग़. ओसो सेत्ताता तलातगा ऊर्हच मतद दुपटि, हामुर-गेंदेना एरे इले, मति ओर्केडा बाजे गीळ आसि अर्स मतदिन ओग़ ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","पया दुस्रोग़ कग़यवाल वने लोप्पा नेङिसि अविन ऊळतोग़, ऊळिसिये येसु जीवा अरतोग़ इन्जि, विस्वस कीयलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","बाराह्‌क इतेके येसु हामुरताहि ओसो जीवा अरयनद गावले, इद्रम सास्त्रमते रासिस मतद पोल्‍लो, ओरिह्‌क अचानाहि तेळियवाय मता. ");
INSERT INTO mrr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","पया ओर इर्वुर मल्सि, तमाङ लोह्‌क अतोर. ");
INSERT INTO mrr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","अचोटेने मरियालि (गुमयातेहु मल्स वाता,) अगाने अळसोरे पलते निच मता. पया अळसोर-अळसोर, अद गुमयातेह माळ्किस ऊळता. ");
INSERT INTO mrr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ऊळतस्के, येसुना सेत्तातुन तासिस मतद जागाते, पोळ्‍दलेह्‌का मांजतप पांड्रि गेंदेङ केग़तवु रेंड देवतुल्कु उंद बारा तलावडातेके, उंद बारा कालवडातेके, उदिस मतव तान्क दिसताङ. ");
INSERT INTO mrr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","अव पया तान इताङ, “बाराह्‌क अळयह्‌निन बायि?” इताङ. “ओरु नावा सामिना सेत्तातुन ओतोर, ओस अदिन बेगा तासतोरो, पुनोन इनजोर अळयह्‌नन,” इन्जि मरियालि अविस्किन इता. ");
INSERT INTO mrr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","अह इन्जि अद पेग़्के मल्स ऊळता, मल्स ऊळनेके, अगा येसु निच मतद तान्क दिसतोग़. मति ओग़ येसुये इनजोर अद पुनो. ");
INSERT INTO mrr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","अस्के येसु तान इतोग़, “बाराह्‌क अळयह्‌निन? बोन पर्ह्‌किह्‌निन?” ओग़ वाळुमतुन ऊळेवाळे केवाल मनदनोग़ बहे इन्जि, ओन इता, “दादा, निमा ओना सेत्तातुन इग्डाह ओतेके, तान बेगा तासतिन, इद नाक वेहा. अस्के नना अदिन ओसि, (ओसो बेस पोहतकन),” इता. ");
INSERT INTO mrr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","येसु पया तान “मरिया!” इनजोर केयतोग़, अस्के अद पेग़्के मिळ्न्दिस येसुन पुता, पुन्जि ओन इब्रि पोल्‍लोते “रबोनि!” (इतेके “नावा गूरु”) इनजोर इता. ");
INSERT INTO mrr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","अस्के (मरियालि ओनाङ काल्क अरताह्‌कु,) येसु इतोग़ “नावाङ काल्किन ओग़्ङिस मनमा मरिया, बाराह्‌क इतेके नना इंका वने बाबानेके पोग़ोन अनोने. मति निमा मावोर कग़यवालोरेके अन्जि ओरिन वेहा, ‘मीवा-नावा बाबानेके, मीवा-नावा देवुळतके नना पोग़ोन दाय्ह्‌नन,’” इन्जि येसु तान वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","अस्के मग्डला नाटेना मरियाल अन्जि, “नना येसुसामिन ऊळतन, ओग़ नाक इद्रम-इद्रमताङ गोटिङ वेहतोग़,” इनजोर अद ओर कग़यवालोरिह्‌क वेहता. ");
INSERT INTO mrr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","अदे ऐतारमता दिया मुलतस्के, यहुदिराङ पेदल्किन रेयिसि, ओर कग़यवालोर अरातगा तेल्प केहच तालम ईसि मकिस मनदह्‌पा, येसु अगा वासि लोप्पा नेङतोग़. नेङिसि, ओरगा नडुम निचि, ओरिन इतोग़, “मीक सुकम दोर्कि, रेयमाटु!” ");
INSERT INTO mrr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","इनजोर वेहचि, ओरिन तनाङ कय्कनाङ ओसो सेंकाता देबान तोहतोग़. सामिन ऊळिसि ओरिह्‌क गिर्दा वाता. ");
INSERT INTO mrr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ओसो उंद मल्का येसु ओरिन इतोग़, “मीक सुकम दोर्कि, रेयमाटु! बहलेह्‌का बाबाल नाक इद दुनियाते लोहतोग़, अहलेह्‌का नना वने मीक दुनियाते लोहतह्‌नन.” ");
INSERT INTO mrr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","इद्रम वळ्ह्‌किसि ओग़ ओरिन ऊकुर ऊरतोग़, अह कीस इतोग़, “नना मीकु देवुळता पवित्र जीवा ईय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","तेना अदिकरते मीटु बोनाय पापमतुन मापि कीतिर इतेके, देवुळ वने ओना पापमतुन मापि कीताये. ओसो पवित्र जीवाता अदिकरते बोना पापमतुन मीट मापि केविर इतेके, ओग़ मापि आयवाय मनदनोग़,” इन्जि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ओर बळयिर बारा मन्कलोरग्डाहि, ओर्वोग़ तोमाल इनवाल मतोग़, ओन दिदुमि (इतेके एमोह पेकाल) वने इंदुर. येसु वातोग़ अस्के, ओग़ तोमाल ओरा संगे इलेग़ आसि. ");
INSERT INTO mrr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","अदिह्‌क ओग़ वातस्के, “माट सामिन ऊळतोम, रा!” इनजोर ओन ओर वेहतोर. तेला मति ओग़ सेतेम पोयोग़, ओग़ इतोग़, “ओनाङ कय्कनगा मोल्‍लाना देबानु ऊळवालेवा, अगा वेळ्न्ज तोग़्किसि ऊळवालेवा, ओसो ओना सेंकाता देबातुन कय बोयिस ऊळवालेवा, ओग़ येसुसामिये आंदोग़ इन्जि, नना मुर्तिय नमोन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","पया वारममेटा पेग़्के, ओर कग़यवालोर ओसो लोनलोप्पा मनेके, तोमाल वने ओराय संगे मतोग़. अस्के तेल्पिङ केहच तालम ईसाय मति, येसु ओरा नडुम वास निच इतोग़, “मीक सुकम दोर्कि, रेयमाटु!” ");
INSERT INTO mrr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","पया ओग़ तोमान इतोग़, “निमा नीवा वेळ्न्जतुन नावा कयदा देबातगा तोग़्किस ऊळा. ओसो नीवा कय इके मुनेह कीसि, नावा सेंकातगा बोयिस ऊळा. अह कीसि, निमा नमवोना लेह्‌का मनमा, मति उन्क-मन्क आयवा, विस्वस कीमु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","इतस्के “ओ नावा सामिनिन, नावा देवुळतिन!” इन्जि तोमाल येसुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","“निमा नाकु ऊळताह्‌कु विस्वस कीतिन, तोमा. मति बोर नाक ऊळवाय विस्वस कीस्तोर, ओर देय्वातोरु!” इन्जि येसु तोमान इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","इद पुस्तकते रासववु, ओसो वेल्‍लाङे बामिह कीयनाङ सीनाङ, येसु तनाङ कग़यवालोरा मुनेह कीस तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","मति इव पोल्‍लोङ बाराह्‌क रासिस मन्ह्‌ताङ इतेके, देवुळ लोहतोग़ पिसिह केवाल राजाल येसुये आंदोग़, ओसो ओग़े देवुळता मग़ आंदोग़ इन्जि मीट नमना. इद्रम नमतेके, मीक येसुना संगे अमेसाता पिसमुळ दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","इव इचोक गोटिङ आतापया, येसु गालिल सम्दुरतगा (इतेके तिबिरिया सम्दुरतगा) कग़यवालोरिन कलियतोग़, अद इह आता. ");
INSERT INTO mrr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","अगा सिमोन पत्रु, दिदुमि इनवाल तोमाल, गालिल पटटा काना नाटेनोग़ नतन्याल, योहन, याकुबि, वेर तमोग़ इर्वुर ओसो उय्तुर इर्वुर येसुनाङ कग़यवालोर उंदिय जागा मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","अस्के सिमोन पत्रु ओरिन इतोग़, “नना मीन्क पोयतलाह दाय्ह्‌नन, डा,” इतोग़. “माट वने नीवाय संगे वाय्ह्‌नोम, डा,” इन्जि ओर ओडाते पेसतोर. मति अद नग़्का ओरिह्‌क उंद मीन वन दोर्को! ");
INSERT INTO mrr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","पया पंङवियतस्के येसु वासि, सम्दुर दडटगा निच मतोग़. तेला मति ओग़ येसु आंदोग़ इन्जि, कग़यवालोर पुनोर. ");
INSERT INTO mrr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","अस्के येसु आळो कीतोग़, “उचुक तेला मीन्क पोयविर रा, पेकोरिर?” “एंह-एंह, माकु उंदाय मीन दोर्को,” इनजोर ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“मीटु ओडाता तिनळ बाजे वद वाटाट अले, अस्के मीन्क दोर्कनुङ,” इन्जि येसु ओरिन वेहतोग़. ओर पया अहे कीतोर, अस्के ऊळाट, वदमेंड मीन्क एग़्कताह्‌कु, ओरिह्‌क वद पिळ्ङलाह एल्‍लो! ");
INSERT INTO mrr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","अस्के ओग़ येसुसामिये आंदोग़ इन्जि, येसु जीवा कीतोग़ कग़यवाल पुतोग़, पुन्जि पत्रुन इतोग़, “ओग़ सामिये, रा!” इतोग़. ओग़ येसुसामि इनजोर केंजताह्‌कु, सिमोन पत्रु तना जगातुन नंडटुह्‌क मळ्हतोग़ (कबळते मताह्‌कु, दुस्रा बेदे जगा केग़वाय मतोग़), अह कीसि सम्दुरलोप्पा एतगा बुर डेयिसि, दडटेके नारसोर अतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ओर पिसतोर बारा, अद वदते एग़्कतव मीन्किन पिळ्ङसोर-पिळ्ङसोर ओडात वातोर, बाराह्‌क इतेके ओर वेल्‍ला जेक इलोर आसि, दडटाहि जोक-जोक रेंड नूह्‌क कुटाङ जेक मतोर. ");
INSERT INTO mrr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","पया ओर दडटेके पेसिस ऊळतस्के, अगा तळ्मिना किस मता, किसतगा बोळ्सतव मीन्क ओसो आरिङ, इव दिसताङ. ");
INSERT INTO mrr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","अस्के येसु ओरिन इतोग़, “मीट इंजेक पोयतव मीन्कनग्डाह उचुक इके ताट.” ");
INSERT INTO mrr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","अदिह्‌क पया सिमोन पत्रु ओडाते तग़्ङिसि, वदतुन दडटेके पिळ्ङिस ततोग़. अवटे नूटा पनस मूंडु (153) बेराङ-बेराङ मीन्क मताङ. इचोक मीन्क मन्जाय, वद इतेक अग़वो. ");
INSERT INTO mrr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","पया येसु ओरिन इतोग़, “इव मीन्कु, आरिङ तिनदकल, वाट रा!” इतोग़. वेग़ सामिय इनजोर, कग़यवालोर पुन्ज मताह्‌कु, निमा बोनिन आंदिन इनजोर ताल्ह्‌कलाहि, ओरग्डाहि बोन्के दीरा वावो. ");
INSERT INTO mrr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","पया येसु वासि आरिनु, मीन्किनु ओरिह्‌क वांटिसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","इद्रमलेह्‌का येसु हासि जीवा अरतोग़ अस्केडाहि, इद मुचा केपा कग़यवालोरिह्‌क दिसलाहि आतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ओर कग़यवालोर कतम तितस्के, येसु सिमोन पत्रुन ताल्ह्‌कतोग़, “योनाना मग़निन, सिमोनि, वेर पिसतोर कग़यवालोर बेचोन नाक जीवा कीस्तोर, तान्काय वीळिस निमा नाक जीवा कीय्ह्‌निना?” इन्जि ताल्ह्‌कतोग़. “इंगो सामि, नना नीक जीवा कीय्ह्‌नन इन्जि, नीक इतेक एर्काये,” इनजोर पत्रु इतोग़. “अह इतेके नावाङ गोरेपिलाना लेह्‌काडोरिन मेहा,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ओसो उंद मल्का, येसु पत्रुन ताल्ह्‌कतोग़, “योनाना मग़निन, सिमोनि, निमा नाक जीवा कीय्ह्‌निना?” “इंगो सामि, नना नीक जीवा कीय्ह्‌नन, इदिन इतेक निमा पुह्‌निने!” इन्जि पत्रु इतोग़. “अह इतेक, नावाङ गोरेना लेह्‌काडोरिन बेस रोसा,” इन्जि येसु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","पया मुचा केपा येसु पत्रुन ताल्ह्‌कतोग़, “योनाना मग़निन, सिमोनि, निमा नाक जीवा कीय्ह्‌निना?” इद्रम येसु मुचा केपा ताल्ह्‌कताह्‌कु, पत्रु पका जीवा नोतप आतोग़. “सामि, नीक इतेक कतम एर्काय मन्ह्‌ता. नना नीक जीवा कीय्ह्‌नन इन्जि, निमा इतेक पुतिन,” इन्जि पत्रु इतोग़. येसु ओन इतोग़, “अह इतेक, नावाङ गोरेना लेह्‌काडोरिन मेहा. ");
INSERT INTO mrr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","इह केंजा, नना सेतेम वेहतह्‌नन, निमा लेयोग़ मतिन अस्के, निमा तयर आसि, बेगा विचर वांदु, अगा अंदिन. मति निमा मुय्तोग़ आयकिन अस्के, निमा नीवाङ कय्किन आहतकिन, आहनेके दुस्रोग़ मन्कल नीकु दोहचि, नीक विचर वावा जागाते पोस ओयनोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(पत्रु बेद्रमता हामुरते हासि देवुळतुन मान ईयनोग़, इदिन मुनेन वेहतलाह, येसु इह वळ्ह्‌कतोग़.) इचोन वळ्ह्‌कतस्के, येसु पत्रुन इतोग़, “नावा सेवा कीसोर वय!” ");
INSERT INTO mrr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पया पत्रु पेग़्के मल्स ऊळतोग़ अस्के, येसु जीवा कीतोग़ कग़यवाल, ओरा पेंडेस वातदिन ओग़ ऊळतोग़. (वेग़े कग़यवान कोनि येसु हायनामुने, कग़यवालोर ऐंगेन तिनदह्‌पा, सामिन पोस एवाल बोग़ आंदोग़, इदिन पुनदलाह, पत्रु कोंडा चिम्चिह कीसि, येसुन ताल्ह्‌कलाह वेहच मतोग़.) ");
INSERT INTO mrr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","वेन पयाह पयाह वायनदिन ऊळिसि, पत्रु येसुन ताल्ह्‌कतोग़, “सामि, वेना बह आयग़ा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","“नना इद बूमते मल्स वानाह्‌जोमु, ओग़ पिसिस मनदना इन्जि, नावा विचर मतेकाय, तेना नीकु बाताल वास अरता? निमा नावा सेवा कीसोर वय!” इन्जि येसु पत्रुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","येसु इह इताह्‌कु, वेग़ कग़यवाल बेस्केन हायोग़ आयनोग़, इद्रमता पोल्‍लो विस्वसिरा नडुम आबुर आता. मति ओग़ हायोग़ आयनोग़ इन्जि येसु इनोग़, सिरप “नना मल्स वानाह्‌जोमु, ओग़ पिसिस मनदना इन्जि, नावा विचर मतेकाय, तेना नीकु बाताल वास अरता?” इचोने वळ्ह्‌किस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","बोन कग़यवान येसु जीवा कीतोग़ कग़यवाल इन्ह्‌तोर, ओनन ननान आंदन; ननाने इव पोल्‍लोङ वेहतह्‌नन, ओसो रासिस तासतन. इव नना रासतव पोल्‍लोङ करलताङे इन्जि, माक विस्वसिरिह्‌क एर्काय मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","येसु कीतवु ओसो वेल्‍लाङे कबस्क मन्ह्‌ताङ. नावा विचरते अव कतम उंद-उंद रासतेके, अव रासतव पुस्तकिङ तासलाह, इद दुनियाते जागा आलो आवाल बहे!");
INSERT INTO mrr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","तियुपिलु साय्ब! नावा मुनेता कागिदते येसुसामिनाङ कबस्किन रासिस तासतन, (तान निमा अर्वतिने). येसुसामिन देवुळि (हामुरताहि तेग़्किह कीसि) पोग़ोन देवुळदीपतगा ओतद दिया एवनाह, इद बूमते मनदनस्के ओग़ बाताल बाताल कीतोग़, बाताल बाताल काग़्हतोग़, इव सबेटविन अगा रासतन. देवुळि येसुन पोग़ोन ओयनामुने, ओग़ आचतोरु तनाङ बळयिरिन, इद्रम इद्रम कीम्ह्‌टु इनजोर, देवुळता पवित्र जीवा वेहतपु उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ओग़ तिपल आस डोलिसि, ओसो जीवा अरतोग़, अस्केडाहि रेंड वीसाङ दियाङ आनाहि, ओरिह्‌क ऊक-ऊके नना जीवा अरतन, इंजेके जीवात मह्‌नन इन्जि, बेस नेह्‌ना तोहतोग़. ओसो देवुळि लोकुरगा तना राजेम ताकिह कीयनद पोल्‍लोतुन ओरा संगे वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","उंद दिया ओग़ ओरा संगे मतस्के, ओरिन जमा कीसि, इद्रम उकुम ईतोग़, “देवुळता पेदिरते मीहवाल योहन, लोकुरिन एते मीहन्दोग़. मति वेल्‍ला दिया आयो, देवुळि तना पवित्र जीवाते मीक मीहतग़ा. इदिन कीकन इन्जि, बाबाल पोल्‍लो विळ्सिस मतोग़ इनजोर, नना मुनेन मीक वेहच मतन. अदिह्‌क मीट येरुसलेम सहरतुन विळ्समाट मति, अद जीवातेनाह्‌कु केपाट,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","पया येसुनाङ बळयिर ओनगा (जय्तुन इनदनद मेटातगा जमा आसि,) इद्रम ताल्ह्‌कतोर, “सामि! बह निमा इदे तूकने (रोम राजेमतुनआरे कीसि,) मावा इस्रयेल जाततोर लोकुरिह्‌कु, मावा राजेमतुन मल्स निल्पिह कीकिना?” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","येसु इतोग़, “इव सबे पोल्‍लोङ आयना वेलातुन, कालमतुन, नावा बाबाले तना अदिकरते तासतोग़. तान मीक पुनदा एवोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","मति मियगा देवुळता जीवाता दळ्म अरतापया, मीक लाव दोर्कग़ा. अद लावते येरुसलेम सहरतगा, पूरा यहुदा पटटगा, सामरिया पटटगा, ओसो बूम मारेंगा एवनाह, नावा पोल्‍लोता साक्सितोरिर मनदकिर,” इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ओग़ इद्रम वेहतापया, ओर ऊळनेक-ऊळनेके, देवुळि येसुन पोग़ोन देवुळदीपतगा ओता, ओतस्के मोयुल अडम आसि, ओनु ओरिह्‌क दिसवाह मुचता. ");
INSERT INTO mrr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ओग़ पोग़ोन दायह्‌पा, ओरु कोंडा मिळ्हवा ऊळसोर मनेके, पांड्रि गेंदेङ उहतोरु इर्वुर मन्कलोर दोम्ह्‌क्ने ओरगा नितोर. ");
INSERT INTO mrr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","निचि ओरिन इद्रम इतोर: “ए गालिल पटटोरिर! बाराह्‌क पोग़ोन ऊळसोर नितिर? देवुळि येसुन पोग़ोन देवुळता जागातगा ओता. मीट ऊळनाह बेद्रम ओग़ पोग़ोन अतोग़, अद्रमे उंद दिया ओसोवन मल्स वायनोग़,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","पया येसुनाङ बळयिर जय्तुन इनदनद मेटाताहि, येरुसलेम सहरते मलतोर. (अद मेटा येरुसलेम सहरताहि वळ्गा कोस जेक मता.) ");
INSERT INTO mrr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ओर सहरते मल्सि, तमा रोमनद लोते, पोग़ोटा मिदेता अरातगा अतोर. (ओर बळयिर अक्रा मुलु बोर आंदुर इतेके,) पत्रु, आंद्रेयाल वेर तमोग़ इर्वुर, योहनि, याकुब वेर तमोग़ इर्वुर, पिलिप, तोमाल, बार्तोलोमि, मत्याल, अल्पुना मग़ि याकुबि, सिमोनि (ओग़ रोम सर्करता अडम पार्टितोग़), दुस्रोग़ याकुबना मग़ि यहुदाल, (इच्वुर बळयिर अगा मतोर). ");
INSERT INTO mrr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","वेर सबेटोर बळयिर उंदिय विचरते, देवुळतुन पार्तना कीसोरेन मंदुर. ओसो वेरा संगे उचुक आस्कु, येसुना तलोग़ मरियाल, ओसो ओनाङ तमोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","अवे दियाने, उंद दिया येसुन विस्वस कीतोरु, सबेटोर जोक-जोक आरुङ वीसाङ मन्कलोर, अगा जमा आस मतोर. अस्के पत्रु ओरा नडुम निच वेहतलाह आतोग़: ");
INSERT INTO mrr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“मावोरिर, यहुदा इस्केर्योति बार, माट ऐंगेन कलियिस सेवा कींदोम इन्जि, मीट पुतिर. तेला मति ओग़े येसुन दोहच ओयलाह वातोरिह्‌क तोळ ईतोग़. अदिह्‌के देवुळता पवित्र जीवा वेहतपु, दाविद राजाल मुनेन सास्त्रमते यहुदाना लोप्पा बेद पोल्‍लो रासिस तासतोग़, अद पोल्‍लो करल आयनदे मता.” ");
INSERT INTO mrr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(यहुदाल तना कीतद लाग्वा कबळताङ कोताङ एतोग़. अव कोताने उंद पोलम असिस मतोग़. मति अदे पोलमतगा, ओग़ पोग़ोटाहि कप मुळ्न्दिस अरतोग़, अरतस्के ओना पोटा पग़्क विरियिस, पोर्ह्‌क पेसताङ. ");
INSERT INTO mrr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","येरुसलेम सहरतोर सबेटोर लोकुरिह्‌क इद पोल्‍लो एर्का आता. अदिह्‌के अद पोलमतुन ओरा पोल्‍लोते “हकलदमा” इतेके “नेतुरता पोलम” इन्जि, पेदिर तासतोर.) ");
INSERT INTO mrr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","(पत्रु ओसो इतोग़, “बेद पोल्‍लो दाविद राजाल यहुदाना लोप्पा) देवुळताङ पाटानगा रासतोग़ अद इह मन्ह्‌ता: ओना लोन पग़लोन आयि! अगा बोग़े मनमाकेग़ इन्जि रासतद मन्ह्‌ता. ओसो दुस्रा पाटातगा: ओग़ कीयना सेवातुन दुस्रोग़ कीयेग़ इनजोर रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","अदिह्‌क येसुसामि हामुरताहि जीवा अरतोग़ इन्जि, मावा संगे साक्सि मनवाल बळयि आयलाहि,(डोलतोग़ यहुदाना जागातगा) ओर्वोग़ मन्कन आचनदु. योहन लोकुरिन देवुळता पेदिरते एग़ मीहतस्केडाहि, देवुळि येसुन मयग्डाहि पोग़ोन ओनाह्‌जोम, माट ओना संगे वेलियसोर मतोम. बेचोक दियाङ माट वेलियसोर मतोम, अचोक दियाङ मावा संगे मतोर मन्कलोरग्डाहि, ओर्वोग़ मन्कन आचनदु,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","पया जमा आतोर विस्वसिर इर्वुर मन्कलोराङ पेदिर्क वेहतोर. ओर्विना पेदिर योसेपि बार्सबा आंदु, ओन युसतुस वने इंदुर. दुस्रोना पेदिर मतियाल आंदु. ");
INSERT INTO mrr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","ओराङ पेदिर्क वेहचि, येसुसामिन इद्रम ताल्ह्‌कतोर, “सामि! यहुदाल बेसतल अग़दुन विळ्सिसि, लाग्वद अग़दुन पोयतोग़, अह आसि डोलतोग़; डोलिसि तना दायना मतद सिक्साता जागातगा अतोग़. सबे मन्कलोरा पोटालोप्पाडाङ गोटिङ निमा पुतिने. अदिनेनाह्‌क ओना जागातगा इद सेवा कीयलाहि, नीवा बळयि आयलाहि, वेर इर्वुरग्डाहि निमा बोन आचतिन, तेन माक तोहचीम,” इनजोर ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","पया ओर इर्वुराङ पेदिर्क रासिसि सीटिङ वाटटोर. बेद सीटि पेसता, अद सीटटगा मतियाना पेदिर मता. अदिह्‌क मतियाल येसु किर्स्तुना अक्रा बळयिरगा कलियतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","(येसु हातापया 50 दियाने,) यहुदिरा पंटाता पंडुमतस्के, सबेटोर विस्वसिर उंद लोतगा जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अचोटेन, पकाय दूंद वातप लेह्‌का पोग़ोटा बूमताहि नेकनद केंज वाता. ओर उदिस मतद लोन पूरा नेकता. ");
INSERT INTO mrr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","पया किसताङ वेंजेह्‌कना लेह्‌काडाङ ओरिह्‌क दिसताङ. पया बाताल आता, अवु ओर्वोग़-ओर्वोग़ मन्कना पोग़ोन उंद-उंद वास उदताङ. ");
INSERT INTO mrr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","वास उदतस्के ओर कतमतोर देवुळता पवित्र जीवाते निंदतोर. अस्के देवुळता जीवा ओरिह्‌क (तमा पुनवव दुस्राङ-दुस्राङ देसेह्‌कनाङ पोल्‍लोने वळ्ह्‌कनद) बुद ईता. बुद ईतस्के ओर सबेटोर दुस्राङ-दुस्राङ देसेह्‌कनाङ पोल्‍लोने वळ्ह्‌क बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","अस्के अगा देवुळताङ अडोङ माळवालोर यहुदि जाततोर, पंडुम इनजोर, ईनाह-आनाह सबे देसेह्‌कनाहि येरुसलेमते वास मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ओर मन्कलोर विस्वसिरा वळ्ह्‌कनद लेङतुन केंजतोर, अस्के ईनाह-आनाह वेल्‍लाय मुल जमा आतोर. जमा आता मुडग्डाहि, ओर्वोग़-ओर्वोग़ मन्कल तना-तना देसेमता पोल्‍लोते, विस्वसिर वळ्ह्‌कनदिन केंजिसि, मुडा मन्कलोर एक्बेक आतोर! ");
INSERT INTO mrr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","एक्बेक आसि, ओर पका बामिस इतोर; “वेर इतेक गालिल पटटोरु! ");
INSERT INTO mrr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","मति माट इतेके ओर्वोग़-ओर्वोग़, बेद देसेम पुटटल, अदे देसेमता पोल्‍लोते वेर वळ्ह्‌कनद केंजिह्‌नल! इद बहु! ");
INSERT INTO mrr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","माट इतेके पारति, मेदि, एलामि, मेसोपोटामिया, यहुदा, कपदुकिया, पुंतुस,आसिया, पुरुगिया, पंपूलिया, मिसर देसेम, लिबुवा देसेमता कुरेनि सहरतकेडा एरिया, ओसो रोम सहरतोर यहुदिर वने ओसो दुस्राङ जातिनोर मावा दर्मते ओळियतोर वने, ओसो केरति, अरब, इव सबे देसेह्‌कने मनवालोरल यहुदिरल मह्‌नल. मति आपुना-आपुना पोल्‍लोते, देवुळताङ बामिह कीयनाङ कबस्किन, वेर मन्कलोर वेहतनदिन केंजिह्‌नल अयो,” इन्जि इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ओर बामिसि, एक्बेक आतोर, ओर्विह्‌क-ओर्वोग़ “इद बह बह आता?” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","मति उय्तुर बार, विस्वसिरिन ऊळिसि, “वेर अंगुर कल उन्जि ओचतोर, अदिह्‌क अह आस्तोर,” इनजोर कवतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","अचोटेन पत्रु, किर्स्तुना अक्रा बळयिरा संगे निचि, जोरते इद्रम इतोग़: “मावोर यहुदिरिर ओसो येरुसलेमते मनवालोरिर, मीट ऊळतदिन पुनदलाह, मियेनाह्‌क पोल्‍लो वेहचोर मह्‌नन, नावा पोल्‍लो केंजाट! ");
INSERT INTO mrr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","मीट बेद्रम विचर कीय्ह्‌निर, अद्रम वेर मन्कलोर कल ओचोर, इंजेके सकरताङ नोव एगलाह आताङ; इद वेलाते बोग़ाय बह ओचनोग़? ");
INSERT INTO mrr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","अह आयो रा, (वेर मन्कलोर मीवाङ देसेह्‌कनाङ पोल्‍लोने वेहतनदिन केंजतिर). इदिना लोप्पा देवुळता कबुरतोग़ योवेल, मुनेन कबुर वेहच मतोग़, (अद मीवा मुनेह करल आता). ");
INSERT INTO mrr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ओग़ इद्रम रासतोग़: देवुळि इन्ह्‌ता, ‘आक्रिताङ दियाने नना नावा जीवातुन कतमतोरा पोग़ोन उदिह कीकन. अस्के मीवाङ मग़्क-मयास्‍क वने नावा कबुर वेहतनुर. मियग्डोर लेया मन्कलोर नना तोहतनद लेकातुन ऊळनुर. मुय्तो मन्कलोर बार नना ईतव कलाङ कळ्स्कनुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","नाक मोळ्कवालोर ओर्युलतोरा, ओर्युलतविस्कना पोग़ोन इंका, नना नावा जीवातुन उदिह कीकन; ओर वने नावा कबुरतोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","दुनियातुन नेयम कीयनद देवुळता बेरा दिया वायग़ाये. अद दिया वायनामुने, पोग़ोटा बूमतगा बामनाह लेह्‌काडाङ कबस्क कीकन. पोळ्‍द ईकळ आयग़ा, नेला नेतुरता लेह्‌का गंजग़ा. ओसो इळ्ता बूमतगा बेराङ सीनाङ तोहतकन. नेतुरि, किस उंडुलता मोयुलि, इविनाङ सीनाङ तोहतकन. ");
INSERT INTO mrr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अस्के बोर सामिना पेदिरतुन पोस केयनुर, ओर सबेटोर पिसनुर.’ ");
INSERT INTO mrr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“मावोर इस्रयेलतोरिर, नावा पोल्‍लो केंजाट. नासरेत नाटेनोग़ येसुना मेटे, देवुळि मीक रीतरीतिनाङ बामनाह लेह्‌काडाङ कबस्क कीस तोहता इनजोर, मीट बेस-नेह्‌ना पुतिर. ");
INSERT INTO mrr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ओग़ येसुनु यहुदाल मीवा कयदगा पोस ईतापया, मीट देवुळताङ अडोङ पुनवोरा संगे, हव्कनागुटातगा मोल्‍लाङ कोटिस हामुरता सिक्सा ईतिर. इद देवुळता मुनेताहि विचर मता,(अद्रमे पनस दियाङ मुने करल आता). ");
INSERT INTO mrr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","मति हामुर ओन मुर्तिय पोस तास पग़वो, अदिह्‌क हामुरता तिपलताहि, देवुळि ओन पिसिह कीसि, जीवा अर्हचीता. ");
INSERT INTO mrr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ओना लोप्पा दाविद राजाल मुनेन देवुळताङ पाटाने रासिस मतोग़, ‘देवुळि अमेसा नावा ऐंगे मन्ह्‌ता इन्जि नना पुह्‌नन, अद नावा पकाते मन्ह्‌ता, नना बेस्केन पेग़्के गुचोन आयकन. ");
INSERT INTO mrr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","अदिनेनाह्‌क नावा जीवा सितुर आस्ता, नना गिर्दाते मह्‌नन, नावा मेंदुल वने सुकमते मन्ह्‌ता. बाराह्‌क इतेके निमा नावा जीवातुन हानादीपतगा विळ्सविन आयकिन. नीवा पवित्र सेवकिना सेत्तातुन कळिय एविन आयकिन. ");
INSERT INTO mrr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","मति निमा नाकु पिसमुळता अग़ तोहचीतिन. नीवा संगे मनदह्‌पा नना पूरा गिर्दाते मह्‌नन,’ इनजोर दाविद रासतोग़.” ");
INSERT INTO mrr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","पत्रु ओसो इतोग़, “मावोरिर! इद पोल्‍लोतुन रासवाल मावा पेदामुय्तोग़ दाविद मुनेन हातोग़. ओनु गुमयातगा मिसतोर, ओन मिसतद गुमया नेंड वने मयगा मन्ह्‌ता इन्जि, नना सेतेम पोल्‍लोते वेहतह्‌नन.(इतेके दाविद इद पाटाते कुद तना लोप्पा वेहोग़). ");
INSERT INTO mrr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","मति ‘नीवा कूळता मन्कन, नीवा लेह्‌का नावा लोकुरगा राजाल कीकन’ इन्जि, देवुळि ओन किरिया कीस मता. दाविद देवुळता कबुरतोग़ मन्जि, पेग़्के वावाल राजानु, इतेके किर्स्तुनु, देवुळि जीवा अर्हचीयग़ा इन्जि मुनेन ऊळिसि, ‘ओना जीवातुन हानादीपतगा विळ्सिस एवो, ओना सेत्ता कळियो,’ इनजोर रासतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“वेग़े येसुन देवुळि जीवा अर्हचीता इनजोर, माट सबेटोर विस्वसिरोम इद पोल्‍लोता साक्सि मह्‌नोम. ");
INSERT INTO mrr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","देवुळि (ओन पोग़ोन ओसि,) तना तिनळ बाजे उदिह कीस, ओन्क पका कदर ईता. देवुळबाबाल मुनेन पोल्‍लो विळ्सिस मतपु, पवित्र जीवातुन ओन्क इद बूमतगा लोहतलाह ईता. अद जीवातुन येसु माक ईतोग़. ईतस्के बाताल बाताल आता, इदिन मीट इंजेके ऊळतिर, केंजतिर. ");
INSERT INTO mrr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","(नना येसुना लोप्पा इव सबे पोल्‍लोन बाराह्‌क इह्‌नन) इतेके, मेंदुल अग़्के देवुळदीपते पोग़ोन अनवाल दाविद आयोग़, बह इतेके ओग़ कुदि पोग़ोन अनवाना लोप्पा मुनेन कबुर वेहतोग़: देवुळि नावा सामिन इता, ‘बेचानाह नना नीवा कोटुलतोरिन, नीवाङ काल्कना इळ्न तच एवोन, अचानाह नावा तिनळ बाजेता राजगादेतगा उदिस मन,’ इता, इद्रम दाविद सास्त्रमते रासतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","मीट बोन हव्कनागुटातगा मोल्‍लाङ कोटिस हव्कतिर, ओग़े येसुन, देवुळि कतमतोरा माल्काल कीता, ओसो मीवा पिसिह केवाल राजाल कीताये. इद पोल्‍लोतुन सबेटोर इस्रयेलतोर बेस-नेह्‌ना पुनिर,” इनजोर पत्रु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","इदिन केंजिसि ओर मन्कलोरा जीवा काल्सता, अद्रम आतस्के पत्रुनु ओसो दुस्रोर बळयिरिन ताल्ह्‌कतोर, “मावोरिर! इंजेके मावा पापम एडलाहि बाताल कीकोम? माक वेहाटु,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","इतस्के पत्रु इतोग़, “मीट ओर्वोग़-ओर्वोग़ मन्कल पापमता अग़दाहि जर मल्सि, देवुळ लोहतोग़ किर्स्तु इनवाल येसुराजाना पेदिरते एग़ मीम्ह्‌टु. अस्के देवुळि मीवा पापमतुन मापि कीसि, तना पवित्र जीवाता बर्कत ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","बाराह्‌क इतेके तना जीवातुन ईकन इन्जि, देवुळि मुनेन पोल्‍लो विळ्सता. अद पोल्‍लो मियेनाह्‌के ओसो मीवा जालपिलतेनाह्‌क, जेक-जेकताङ देसेह्‌कनोरेनाह्‌क, बेच्वुरिन देवुळि तनगा केयिह्‌ता, अच्वुरिह्‌क,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ओरिन तेळियिह कीयलाहि, ओसो वेल्‍लाङे पोल्‍लोङ बुदिङ-एदिङ वेहतोग़. देवुळि येसुन नमवोरिह्‌क सिक्सा ईयना मन्ह्‌ता, अद सिक्साताहि पिह्‌ट अर्म्ह्‌टु इनजोर, बुद काग़्हचोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","पत्रुना कबुरतुन केंजिस वेल्‍लाटोर विस्वस कीतोर, विस्वस कीसि, येसुना पेदिरते एग़ मीतोर. अद दिया जोक-जोक मूंड अजर्क मन्कलोर विस्वसिरा मुडगा कलियतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","विस्वसिर किर्स्तुनाङ बळयिर काग़्हतनाङ पोल्‍लोन केंजसोरे, ऐंगेन कलियसोरे, किर्स्तुना मोकता सीता कीसि ऐंगेन आरिङ तिनजोरे, पार्तना कीसोरे, इद्रम मंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","किर्स्तुनाङ बळयिर रीतरीतिनाङ बामिह कीयनाङ वेल्‍लाङे कबस्क कींदुर. अविन ऊळिसि, येरुसलेमतोर मन्कलोर पका रेयिस मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","येसुन विस्वस कीतोर सबेटोर ऐंगेन कलियिंदुर, ओसो तमा सामनतुन ओर्विना-ओर्वोग़ काळ्ङसोर पिसिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","इतेके तमा जागा-बूमतुन, मालसोमतुन वमिसि, बोन्काय गर्ज अरतेके, अवे कोतान तूसिस ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","दिनम उंदिय एकाते मंदिरताङ मंडानगा कलियिंदुर. ओसो गिर्दाते, बेसतल बुदते, लोह्‌क-लोह्‌क जमा आसि, ऐंगेन जावा उंडुर, अहे (किर्स्तुना मोकता सीता कीसि) आरिङ तिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","देवुळतुन जोहर कीसोर मंदुर. सबेटोर मन्कलोर विस्वसिरिह्‌क मान ईंदुर. दिनम येसुसामि वेल्‍लाटोर मन्कलोरिन पापमताहि पिसिह कींदोग़. ओर मन्कलोर विस्वसिरा मुडगा कलियिस मंदुर. (इद्रमलेह्‌का विस्वसिरा मुडुन देवुळि बोल्गिह कींदु.) ");
INSERT INTO mrr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","अद्रमे उंद दिया बाताल आता इतेके, पत्रु, योहन, वेर इर्वुर बह्‌ट अर्स मतस्के, देवुळता मंदिरतगा अनजोर मतोर. (दिनम अद तूकने यहुदि लोकुर मंदिरतगा मोळ्किंदुर.) ");
INSERT INTO mrr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","मंदिरतगा एवतस्के ओर्वोग़ पुटिय ताक पग़वोग़ मन्कल ओरिह्‌क दिसतोग़. ओग़ मंदिरतगा अनवालोर वावालोरिन ताल्ह्‌किस तिनेग़ इन्जि, दिनम उय्तुर ओन मंदिरतगा एवनाह कांजिस तंदुर. तचि वेल्‍लाय सोबाता अग़ इनदनद अग़दगा उदिह कीस अंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पत्रु, योहन मंदिरताङ मंडानगा ओळियनदिन ऊळिसि, ओग़ ओरिन बिचेम ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","अस्के पत्रु, योहनि, इर्वुर आसि ओनेके बेट-बेट ऊळसोरेने, पत्रु इतोग़ “मयेक ऊळा!” ");
INSERT INTO mrr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","इतस्के, बातालाय ईयनुर इनजोर आसा कीस, ओग़ ओरेकेन ऊळलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","अस्के पत्रु इतोग़, “नयगा बंगर-वेंडिङ इतेक इलेङ, मति बाताल मन्ह्‌ता, अद नीक ईय्ह्‌नन: अले नासरेत नाटेनोग़ येसु किर्स्तुना अदिकरते तेदिसनेह्‌क ताका,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","इन्जि कूटाना तिनळ कयदुन पोस तेहतोग़. अस्केन ओनाङ काल्किह्‌क, मेसबुटिह्‌क लाव वाता. ");
INSERT INTO mrr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","लाव वातस्के, ओग़ु तेदिस दिग नितोग़, निचि ताक बोटटोग़. ताकसोरे, डेह्‌कसोरे, देवुळतुन जोहर कीसोरे, ओराय संगे मंदिरते ओळियतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","अगा मतोर सबेटोर मन्कलोर ओग़ ताकनदिन, ओसो देवुळतुन जोहर कीयनदिन ऊळतोर. ");
INSERT INTO mrr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ऊळतस्के, मंदिरता सोबातद अग़दगा उदिस मन्जि बिचेम ताल्ह्‌कवाल वेग़े आंदोग़ इनजोर पुतोर. पुतस्के कूटाल सव्रेम आतोग़ अयो इन्जि, पका बामिस ओर एक्बेक आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","सव्रेम आतोग़ मन्कल पत्रुन, योहनिन पोस मतोग़. मंदिरता बेद जागातुन साल्मोन राजाना मंडा इंदुर, अदे मंडातगा वेर निच मतोर. अद मंडातगा सबेटोर वित वासि, ऊळिस बामतोर. ");
INSERT INTO mrr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","पत्रु ओर सबेटोरिन ऊळिस इतोग़, “ए मावोर इस्रयेलतोरिर! बह आता, मीट इद्रम बाराह्‌क बामलाह आतिर? मावाय लावतुह्‌के, मावाय कोळ्‍वतुह्‌के, वेग़ मन्कल ताकतोग़ इतपे, मयेकेन बेट-बेट बाराह्‌क ऊळिह्‌निर? ");
INSERT INTO mrr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्रहम मुय्तोना, इसक मुय्तोना, याकुब मुय्तोना देवुळि, मावाङ तादोर-बाबोरा देवुळि, इदु तना सेवा केवाल येसुह्‌क मान ईता. मति मीट इतेके, ओन पिलाति गुमसिना कयदगा पोस ईतिर. पिलाति ओन विळ्सकन इनदह्‌पा, ‘वेग़ मावा राजाल आयोग़’ इनजोर, मीट पिलातिना मुनेह ओन पास्कतिर. ");
INSERT INTO mrr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","देवुळता पवित्र, सेतेमते ताकवाल मग़ि येसुन पास्किसि, ओर्वोग़ हव्के मन्कन विळ्सिस ईम इनजोर, पिलातिन इतिर. ");
INSERT INTO mrr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","अमेसाता पिसमुळ एवाल माल्कान मीट हव्कलाह ईतिर, तेला मति हामुरताहि देवुळि ओन जीवा अर्हता. इद पोल्‍लोता माट इर्वोम साक्सि मह्‌नोम. ");
INSERT INTO mrr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","मीवा मुनेह निच मनवाल मन्कन मीट पुतिरे. वेग़ बह बेस आतोग़ इतेके, माट येसुन विस्वस कीताह्‌के, ओना लाव वेनगा वाता. येसुनगा अदिकर मन्ह्‌ता इन्जि, विस्वस कीताह्‌के वेग़ पूरा सव्रेम आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“मावोरिर! मीटु, मीवा मुक्यालोर बार कलियिस, (येसुन हव्कनाह कीतिर. मति ओग़ बोग़ आंदोग़ इनजोर) पुनवालेवा अह कीतिर, इद नाक एर्काये. ");
INSERT INTO mrr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","किर्स्तु राजाल सिक्सा आयनोग़ इन्जि, देवुळि तना कबुरतोर कतमतोरा संगे, मुनेन वेहच मता. देवुळि ओन अद्रमे कीसि, अद पोल्‍लोतुन इद्रम करल कीता. ");
INSERT INTO mrr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","अदिह्‌क इंजेके मीट पापमता अग़दाहि मिळ्न्दिसि देवुळतके मल्म्ह्‌टु, अस्के देवुळि मीवा पापमतुन एडिह कीयग़ा. एडिह कीसि अद मीवा जीवातुह्‌क आरम ईयग़ा. ");
INSERT INTO mrr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ओसो देवुळि मयेनाह्‌के निल्पिह कीतोग़ पिसिह केवानु (इतेके येसुन) ओसोवने लोहचीयग़ा. ");
INSERT INTO mrr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","पूरा दुनियातुन पूना कीकन इन्जि, देवुळि वेल्‍लाय मुने तना पवित्र कबुरतोरा संगे वेहच मता. पूना कीयनद कालम एवनाह, किर्स्तु पोग़ोन देवुळदीपते मनदनोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“मोसा मुय्तोग़ (मावाङ तादोर-बाबोरिन किर्स्तुना लोप्पा) इद्रम वेहच मतोग़, ‘नावा लेह्‌काडोग़ ओर्वोग़ कबुरतोन, देवुळि मीवा कूळतोरग्डाहि मियेनाह्‌क लोहचीयग़ा. ओग़ मीकु बाताङ वेहतनोग़, अव सबे पोल्‍लोन केंजाट. ");
INSERT INTO mrr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ओना पोल्‍लो केंजवोरिन, देवुळि तना मुडग्डाहि एग़िह कीसि ओरिन बूळे कीसीयग़ा,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","अद्रमे सामुवेल मुय्तोग़ ओसो ओना पया वातोर देवुळता कबुरतोर सबेटोर, मुनेन इव दियाना लोप्पा पोकुर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","इंजेके ‘नीवा कूळतोरा मेटे इद बूमता सबे जातिनोरिह्‌क बर्कत दोर्कग़ा’ इन्जि, देवुळि अब्रहम मुय्तोन वेहच मता, इद्रम मावाङ तादोर-बाबोरा संगे मुनेन इद पोल्‍लोतुन करल कीस मता. बेव पोल्‍लोङ कबुरतोर पोकुर कीस मतोर, बेद बर्कत देवुळि ईकन इन्जि वेहच मता, अव सबे मियेनाह्‌के मन्ह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","अदिह्‌क मीट सबेटोरा लाग्वद अग़दाहि मीक मल्हचि बर्कत ईयलाह, देवुळि तना सेवक येसुन आचिसि, मावाय यहुदि जाततोरिह्‌क मुनेन लोहचीस मता,” इनजोर पत्रु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रु, योहन, वेरु लोकुरा संगे वळ्ह्‌कसोर मतोर अस्के, बूमयालोर, मंदिरता दरोगाल ओसो सदुकिरा तुंगातोर उय्तुर ओरगा वातोर. (सदुकिर इतेके यहुदिराङ पेदल्कना उंद तुंगातोर आंदुर, वेर हामुरताहि जीवा अरयह्‌तोर इन्जि नमोर आंदुर.) ");
INSERT INTO mrr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ओर इर्वुर लोकुरिन येसुनाङ पोल्‍लोङ काग़्हचोर मतोर, लोकुर येसुना लेह्‌का डोलिसि जीवा अरयनुर इनजोर, पोकुर कीसोर मतोर. इद पोल्‍लोतेनाह्‌क यहुदिराङ पेदल्क पकाय ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ओङ आसि पत्रुन, योहनिन पोयतोर. पोळ्‍द अन्ज मता अदिह्‌क, इमा दिया नेयम कीकल इनजोर, ओरिन जेलते वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","मति पत्रुनाङ पोल्‍लोङ केंजतोर वेल्‍लाटोर लोकुर येसुन विस्वस कीतोर. अद्रम विस्वस कीतोरु, वेट कोय्तोरे कोनि एयुङ अजर्क मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","इमा दिया यहुदिराङ पेर्मालोर, सास्त्रमगूरुर, ओसो दुस्रोर पेदल्क येरुसलेम सहरते पंच उदतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ओसो ओरा संगे मोदुल पेर्माल अनाल, तना अने कयपाल ओसो पेर्माना सटमतोर, ओरगा योहन ओसो सिकंदर, वेर इर्वुर वने मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","पया ओर पत्रुन, योहनिन, नडुम निल्पिह कीस ताल्ह्‌कतोर, “मीट वेग़ कूटानु बेद लावते, बोना अदिकरते ताकनाह कीतिर रा?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","पया पत्रु देवुळता पवित्र जीवाते निंदतोग़, निंदतस्के इद्रम वेहतोग़, “ए मावोर पेर्मालोरिर, पेदल्कनिर! ");
INSERT INTO mrr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","रोगमतोनेनाह्‌क माट बेसता कबळ कीतोम, अदिन वेग़ बह आस बेस आतोग़ इन्जि, मीट नेंड माक पर्ह्‌किस ऊळिह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","मीट ओसो मावोर सबेटोर इस्रयेलतोर बेस पुन्ह्‌टु, नासरेत नाटेनोग़ येसु किर्स्तुन हव्कनागुटातगा हव्कनाह कीतिर, मति देवुळि ओन जीवा अर्हचीता. ओग़े येसु किर्स्तुना अदिकरते, वेग़ मन्कल सव्रेम आसि, मीवा मुनेह नितोग़. ");
INSERT INTO mrr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘बेद बंडातुन मुने बेल्दर्कु पोहचीतुर, अदे बंडा इंजेके आदरता मूला बंडा आता’ इन्जि, देवुळताङ पाटानगा वेहतद मन्ह्‌ता. अद बंडा इतेके येसुये, बेल्दर्क इतेके मीटे, ओन पोहचीतप ऊळतोरिर. ");
INSERT INTO mrr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","वेग़ येसुन विळ्सिस बोग़े, मावा पापमता सिक्साताहि पिसिह कीया पग़वोग़. बाराह्‌क इतेके माट पापमताह पिसलाहि, इद बूमतगा ओन विळ्सिस, दुस्रोग़ पिसिह केवान देवुळि मन्कलोरिह्‌क एवो!” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","पत्रु, योहन, वेर इर्वुर कग़यवोर केनकेनेतोर मन्ज तेला, दीराते वळ्ह्‌किंदुर. वेरा दीरातुन ऊळिसि, तग्वाङ केवालोर बयल आतोर. पया वेर इर्वुर येसुना संगतोर, (अदिह्‌क इद्रमता दीरा वेरिह्‌क वाता) इनजोर पुतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","मति सव्रेम आतोग़ मन्कल वेरा संगे नितदिन ऊळिसि, वेरा अडम बातय वळ्ह्‌क पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पया बाताल कीतोर इतेके, पत्रुन, योहनिन, सव्रेम आतोग़ कूटान, पंचताहि पलते ओम्ह्‌टु इनजोर इतोर, इन्जि तमतमाय विचर कीयलाह बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“इंजेके वेरिन माट बाताल कीकल? वेर इद्रमता बेरा सीना तोहतोर इनजोर, पूरा येरुसलेम सहरतोर पुतोरे. अदिन वेर केवोर इनजोर, माट बह इनदा पग़यकल? ");
INSERT INTO mrr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","आयो रा! इद्रम कीकल, (ओरिह्‌क सिक्सा एवल); मति इद पोल्‍लो आबुर आयना आयो इनजोर, इंजेटग्डाहि वेग़ येसुना पोल्‍लोतुन बेगान वेहमाट इनजोर, ओरिन रेय्‍पिह कीसि विळ्सिसीकल,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","पया ओर इर्वुरिन लोप्पा केयिसि, “मीट इंजेके येसुना पोल्‍लोतुन बेगान वेहमाट, बेगान काग़्हमाट,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","मति पत्रु, योहन, वेर इद्रम इतोर, “देवुळता पोल्‍लोतुन विळ्सिस, मीवा पोल्‍लोतुन केंजना देवुळतुह्‌क ओप्पग़ाया? मीटे विचर कीस ऊळाट! ");
INSERT INTO mrr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","माट ऊळतव, केंजतव पोल्‍लोन वेहवालेवा, केमेन मनदा पग़वोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","इंजेके देवुळता लावते सव्रेम आतोग़ पुटकूटाल, रेंड वीसाङ वर्साह्‌काय एक्‍वा वय्सतोग़ आंदोग़ इनजोरे, सबेटोर लोकुर देवुळतुन जोहर कींदुर. अदिह्‌के लोकुर माक विरुद आयनुर इन्जि, लोकुरिह्‌क रेयिस तग्वाङ केवालोर ओरिन पका रेय्‍पिह कीस, विळ्सिस ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","पया पंचताहि पत्रु, योहन पेसिसि, ओर तमा तोळतोरगा अतोर. अस्के पेर्मालोर ओसो दुस्रोर पेदल्क बाताङ बाताङ इतोर, अव सबे पोल्‍लोङ विस्वसिरिह्‌क वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","अदिन केंजिसि, विस्वसिर उंदिय एकाते जोरते, देवुळतुन इद्रम वळ्ह्‌कतोर, “जोहर सामि! पोग़ोटा बूमतुन, इळ्ता बूमतुन, सम्दुरतुन, ओसो अविस्कनगा मनदनव सबेटविन निमान पुटिह कीतिन. ");
INSERT INTO mrr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","नीवा सेवक मावा पेदामुय्तोग़ दाविद राजाल, नीवा पवित्र जीवाता बुदते इद्रम वेहतोग़ इतेके ‘यहुदि आयवोरइचोन रोदा पोयह्‌तोर, मति बार्किया? यहुदिर, जमा आसि उगसताङ आय्डाङ पंडिह्‌तोर, मति बार्किया? ");
INSERT INTO mrr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ओराङ राजालोर लळयतुह्‌क तेदतोर, ओराङ मुक्यालोर वने जमा आसि, आय्डाङ पंडिह्‌तोर, देवुळता अहे अद आचिस तासतोग़ राजाना वने अडम आस्तोर,’ इन्जि वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","28","ओग़ वेहतद पोल्‍लो निटम करल आता. एरोद अंतिपस राजाल, पिलाति गुमसि, वेरु इदे येरुसलेम सहरतगा, यहुदि आयवोरा संगे यहुदिर कलियिसि, निमा निल्पिह कीतिन ओग़ पवित्र सेवक येसुन अडम आतोर. मति निमा अचोन लावतोनिन इतेके, बेद नीवा मुनेताहि विचर मता, अचोने ओर कीया पग़तोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","इंजेके देवुळबाबानिन, तग्वाङ केवालोर माक रेय्‍पिह कीयनदिन सीता कीम, कीसि माट नीवा सेवकिरोम पका दीराते नीवा पोल्‍लोतुन वेहतलाह ईम, ");
INSERT INTO mrr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","माट वेहतह्‌पा, दुकतोरिन सव्रे कीसि, नीवा पवित्र सेवक येसुना पेदिरते, नीवाङ बामनाह लेह्‌काडाङ सीनाङ तोहचीम,” इन्जि देवुळतुन ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ताल्ह्‌कतस्के, ओर जमा आस मतद लोन मेलियता. ओर कतमतोर पवित्र जीवाते निंदिसि, देवुळता पोल्‍लोतुन रेयवालेवा, कतमतोरिह्‌क वेहता बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","सबेटोर विस्वसिर उंदिय एकाते मतोर. आपुना-आपुना मादुन बोरे नावा इनजोर इनोर आंदुर; मति सबेटोर मन्कलोर तमा सामनतुन, ओर्विना-ओर्वोग़ काळ्ङसोर पिसिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","किर्स्तु येसु जीवा अरतोग़ इन्जि, बळयिर साक्सि वेहन्दुर, वेहतनस्के देवुळता लाव ओरगा दिसिंदु. देवुळता दया सबेटोर विस्वसिरगा बेस मता. ");
INSERT INTO mrr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","बोन्के बातय कमि इलवा मता. जागा-बूमि बोरगा मता, ओर बेस्के-बेस्के वमिसि, ");
INSERT INTO mrr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","अव कोताङ तचि बळयिरा कयदे तूसलाह ईंदुर. बोन्काय गर्ज अरतेके, अव कोताङ पया तूसिस ईंदुर. अदिह्‌के बोन्के बातय कमि इलवा मता. ");
INSERT INTO mrr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","अद्रमे योसेप पेदिरतोग़ ओर्वोग़ मतोग़. ओग़ कुपरुस इनदनद देसेमतोग़लेविना पुळ्गतोग़ (इतेके देवुळवडे) आंदोग़. ओग़ बाताल कीतोग़ इतेके, तना बूमतुन वमिसि, कतम कोताङ बळयिरगा तचि ईतोग़. किर्स्तुनाङ बळयिर ओन बार्नबस (इतेके दीरा एवाल) इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","अद्रमे विस्वसिरा मुडगा अनन्याल पेदिरतोग़ मन्कल मतोग़, ओना मुतेना पेदिर सपिराल आंदु. आळ इर्वुर आसि तमा उचुन जागातुन वमतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","पया अनन्याल बाताल कीतोग़ इतेके, वमतव कोतानग्डाहि, वळ्गा कोताङ तमेनाह्‌क लोन तासतोग़. इद पोल्‍लोतेनाह्‌क तना मुते वने ओन्क तोळ आता. पया पिसतव कोतान बळयिरगा तचि ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","मति पत्रु ओन इतोग़, “अनन्या! देयमदीपता विचरतुन नीवा बुदतगा बाराह्‌क वाया ईतिन? जागातुन वमतव वळ्गा कोताङ मियेनाह्‌क तासतिन, वळ्गा कोताङ ततिन, (पूराय कोताङ ततप लेह्‌का, अविस्किन मयगा तचि ईतिन). इद्रम निमा देवुळता पवित्र जीवाता मुनेह जोल आतिन. ");
INSERT INTO mrr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","तान वमनामुने वने, अद नीवा कयदे मता, वमतापया वने अव कोतानगा पूरा नीवाय अदिकर मता. देवुळतुह्‌क ओप्पवद कबळ कीयलाहि, बाराह्‌क विचर कीतिन? निमा सिरप मन्कलोरिन आयो, मति देवुळतुने जोल वळ्ह्‌कतिन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","पत्रु इतद पोल्‍लोतुन अनन्याल केंजताहे, नेल अर्सि अगान हातोग़. इद पोल्‍लोतुन केंजतोर सबेटोर पका रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","अगा मतोर लेयोर वासि, ओना सेत्तातुन गेंदेते ऊर्हतोर, ऊर्हचि पलते ओस गति कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","इद पोल्‍लो आस मूंड गंटाना पया, हातोना मुते सपिराल वाता. तना मुजो हातोग़ इन्जि, अद मुर्तिय पुनो आसि! ");
INSERT INTO mrr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पया पत्रु तान इतोग़, “अले! वेहा! मीवा बूमतुन इचोके कोताने वमतिरा?” “इंगो दादा! इचोके” इता. ");
INSERT INTO mrr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पत्रु इतोग़, “जोल वळ्ह्‌कतेके देवुळता जीवा पुनदग़ाया इन्जि, आळ इर्विर आस बाराह्‌क इद्रम पट ऊळतिर? ऊळा! नीवा मुजोना सेत्तातुन पोहतोरु अग़दगा एवतोर, नीक वने अहे ओयनुर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","पत्रु इद्रम इताहे, अद वने ओना मुनेह अर्सि हाता. अस्के ताना मुजोन पोहता मन्कलोर लोप्पा ओळियतोर. अद हातदिन ऊळिसि, ताना सेत्तातुन, ताना मुजोन पोहता जागातगा, कचुल ओस मिसतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","विस्वसिरा पूरा मुलु, ओसो इद पोल्‍लोतुन केंजतोर सबेटोर पका रेयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","अद्रमे पया बळयिरा कयदे, देवुळताङ बामनाह लेह्‌काडाङ वेल्‍लाङे सीनाङ, लोकुरा मुनेह आंदुङ. (विस्वसिरा मुलु मंदिरता साल्मोन राजाना मंडातगा, उंदिय एकाते जमा आंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","विस्वस केवोर ओरगा कलियलाह रेयिंदुर, मति सबेटोर लोकुर विस्वसिरिन पका मान ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","वेल्‍लाटोर आस्क-कोय्तोर किर्स्तुन विस्वस कीसि, ओरगा वास कलियिंदुर. अह आसि विस्वसिरा मुल बोल्गिंदुर.) ");
INSERT INTO mrr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","बामनाह लेह्‌काडाङ सीनाङ ऊळिसि, पत्रु दायनद अग़दे दुक अरतोर मन्कलोरिन कटुस्क अग़्के, माग़िङ अग़्के, अग़दगा पेसिह कीस तासिंदुर. पत्रुना दळ्मतेला उय्तुरगा अर्सि, ओर सव्रेम आयनुर इनजोर लोकुरा आसा मंदु. ");
INSERT INTO mrr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","येरुसलेम सहरता एरे मतव नाह्‌कनाहि, वेल्‍लाटोर दुक अरतोरिन, देयह्‌क पोस मतोरिन, अगा पोस वांदुर. ओर सबेटोर बळयिरा कयदे बेस आंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","अस्के लोकुर किर्स्तुनाङ बळयिरिह्‌क मान ईयनदिन ऊळिसि, मोदुल पेर्माल ओसो ओना तोळतोर सदुकिरा जीवा कर्विंदु. ");
INSERT INTO mrr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","जीवा कर्विसि, बळयिरिन पोस जेलतगा वाटलाहि वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पया ओर जेलते मनदह्‌पा, नग़्काडा वेलाते बाताल आता इतेके, देवुळता देवतुल वासि, जेलता अग़दुन तेग़यता, तेग़यिस (बोन्के दिसवाह,) ओरिन पेसिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","पेसिह कीसि ओरिन वेहता, “मंदिरताङ मंडानगा अन्ह्‌टु, अगा निचि देवुळता पिसमुळता इद पूरा कबुरतुन, अगा मनवालोर सबेटोर लोकुरिह्‌क वेहचीम्ह्‌ट,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","अस्के बळयिर देवतुल वेहतपु, पंङवियतस्के मंदिरतगा अतोर, अन्जि मंडानगा निचि, लोकुरिन काग़्हता बोटटोर. ओर काग़्हतह्‌पा, मोदुल पेर्माल, ओना तोळतोर बार बाताल कीतोर इतेके, यहुदिराङ तग्वाङ केवालोरिन, सबेटोर पेदल्किन केयिसि, बळयिरिन जेलताहि तता वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","मति मंदिरता पोलिसिर अन्ज ऊळतापया, बळयिर अगा इलोर! अदिह्‌क ओर पंचतगा मल्स वासि इद्रम वेहतोर, ");
INSERT INTO mrr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“जेलता अग़दगा बेस तालम वाटिस मता, सीपय्क वने अग़दगा राकातुह्‌क मतोर; मति लोप्पा तेग़यिस ऊळतापया बोरे इलोर,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","मंदिरता दरोगाल ओसो पेर्मालोर इद पोल्‍लोतुन केंजिसि, इंजेके बह आयग़ा इनजोर, बळयिरेनाह्‌क एक्बेक आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","अचोटेन ओर्वोग़ मन्कल वासि, “मीट जेल वाटिस मतिर, ओर मन्कलोर मंदिरताङ मंडानगा निचि, लोकुरिन येसुना पोल्‍लो काग़्हतलाह आतोर,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","अस्के मंदिरता दरोगाल तनाङ पोलिसिरिन पोस, मंदिरताङ मंडानगा अतोग़, अन्जि बळयिरिन पंचते ततोग़. लोकुर माक बंडाङ उकिस हव्कना आयो इन्जि, जबरदस्ति केवा बळयिरिन ततोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","पया ओरिन तचि तग्वाङ केवालोरा मुनेह निल्पिह कीतोर. कीतस्के मोदुल पेर्माल ओरिन इद्रम इतोग़, ");
INSERT INTO mrr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“येसुना पोल्‍लोतुन काग़्हतनद आयो इनजोर मीक वेहोमा? मति मीट इतेके, येरुसलेमतगा कतमतोरिने ओना पोल्‍लोतुन काग़्हचीतिर. अचोने आयो मति, ओन माटे हव्कनाह कीतोम इनजोर, मावा पोग़ोन कसुर वाटलाह ऊळिह्‌निर?” इनजोर तप तोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","मति पत्रु ओसो दुस्रोर बळयिर इद्रम इतोर, “मन्कना पोल्‍लोतुन आयो, मति देवुळताये पोल्‍लोतुन माक केंज पोयह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","येसुन मीट मराता हव्कनागुटातगा वेळ्हच हव्कनाह कीतिर, मति मावाङ तादोर-बाबोरा देवुळि ओन जीवा अर्हता. ");
INSERT INTO mrr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","जीवा अर्हचि, ओने सामि, पिसिह केवाल इन्जि, देवुळि निल्पिह कीता. मावा इस्रयेलतोरिन पापमता अग़दाहि मल्हतलाहि, मावा पापमतुन मापि कीयलाहि, ओने निल्पिह कीसि, तना तिनळ बाजे पका कदर ईसि उदिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","इव पोल्‍लोना माट साक्सितोरोम मह्‌नोम. तानाङ पोल्‍लोङ केंजिसि ताकवालोरा पोग़ोन, देवुळि उदिह कीतद पवित्र जीवा वने, इव मावाङ पोल्‍लोना साक्सि ईस्ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","पत्रुना पोल्‍लोतुन केंजिसि, तग्वाङ केवालोर पका ओङ आतोर. ओङ आतस्के, बळयिरिन हव्कलाह तयर आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","मति ओरगा गमलियेल पेदिरतोग़ वग़ोग़ मतोग़, ओन यहुदिर पका कदर ईंदुर. ओग़ परुसिरा तुंगातग्डाहि देवुळता सास्त्रम काग़्हवाल गूरु मतोग़. ओग़ तेदिसि बळयिरिन अग्डाहि गळ्क पलते पेसिह कीयलाहि, सीपय्किन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ओर अतस्के, तग्वाङ केवालोरिन इद्रम इतोग़, “मावोर इस्रयेलतोरिर! मीट वेरिन बाताल कीयलाहि ऊळिह्‌निर, तान बेस आलिह कीम्ह्‌टु. ");
INSERT INTO mrr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","बाराह्‌क इतेके, बेचोको वर्साना मुने, तियुदास पेदिरतोग़ ओर्वोग़, नना बेरोनन इनजोर नडुमिय पुटिस मतोग़. अस्के नालुङ नूह्‌क मन्कलोर ओनेके आस मतोर, मति बाताल आता, रोम सर्करतोर सीपय्क ओन हव्कतोर. ओनेके आस मतोर सबेटोर बिरोबटो आतोर, ओना कबळ मायता. ");
INSERT INTO mrr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“इद पोल्‍लो आतापया, रोम सर्करतोर सिरगंचि कीयलाह वेहच मतोर, अस्के गालिल पटटोग़ यहुदाल इनवाल सर्करता विरुद आतोग़. ओनाङ केंजिसि उय्तुर ओना पेग़्के अतोर, पया ओन वने हव्कतोर. ओना पेग़्के अनवालोर सबेटोर बिरोबटो आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","अदिह्‌क इंजेक वने, नना मीकु वेहतलाह आतन. मीट पोयतोरिन बाताले केमाटु, ओरिन विळ्सिस ईम्ह्‌टु. वेराङ विचर्क, वेराङ कबस्क, मन्कना बुदताङ मतेके, तमाय मायनुङ. ");
INSERT INTO mrr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","मति देवुळतग्डाह मतेके, मीट तान माय्‍पिह कीया पग़विर. माय्‍पिह कीयलाहि ऊळतिर इतेके, देवुळताये अडम लळेम आयवालोरिर आयकिर, अद्रम आयमाट,” इनजोर बुदिङ वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","इतस्के, तग्वाङ केवालोर गमलियेलना पोल्‍लोतुन केंजतोर. पया बळयिरिन लोप्पा तता वेहतोर. ततापया ओरिन तोला जूताते नल्हता वेहचि, येसुना पोल्‍लोतुन ओसो बोन्के वेहमाट इनजोर वेहचि, विळ्सिस ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","विळ्सिस ईतस्के बळयिर, येसुना पेदिरतेनाह्‌क माक देबाङ अरताङ इनजोर, बेस गिर्दाते पंचताहि पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ताना पया दिनम मंदिरताङ मंडानगा, लोह्‌क-लोह्‌क वने देवुळ आचतोग़ पिसिह केवाल किर्स्तु राजाल येसुये आंदोग़ इनजोर, रोमवालेवा काग़्हचोरे, बेसतल कबुर वेहचोरे मंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","अद्रमे पया, येसुन विस्वस कीतोर लोकुर वेल्‍लाय बोल्गसोर अंदुर अस्के, ओरा नडुम इद्रमता कट्ला पुटटा. युनानि पोल्‍लो वळ्ह्‌कवालोर यहुदि विस्वसिर इद्रम इतोर इतेके, दिनम गाटो तूसिह्‌पा मावाङ रांडे आस्किह्‌क बराबर एवोर इन्जि, इब्रि पोल्‍लो वळ्ह्‌कवालोर यहुदि विस्वसिरिन मुयोग़ आंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","अदिनेनाह्‌कु, बारा बळयिर बाताल कीतोर इतेके, सबेटोर विस्वसिरिन केयिस इद्रम इतोर, “माट देवुळता पोल्‍लोतुन पोकुर कीयनद विळ्सिसि, गाटो तूसनद सेवा कीतेके, अद माक ओप्पो आयग़ा गोतो. ");
INSERT INTO mrr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","अदिनेनाह्‌क मावोरिर! मियग्डाह मीक विचर वातोरु, पका तेल्वतोरु, पवित्र जीवाते निंदतोरु, लोकुर कदर एवालोरु, एळवुर मन्कलोरिन आचाटु. ओरिन माटु गाटो तूसनद सेवातुह्‌क निल्पिह कीकोम. ");
INSERT INTO mrr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","मति माट बळयिरोम इतेके, पार्तना कीयनद ओसो देवुळता पोल्‍लोतुन पोकुर कीयनदे सेवाते मनदकोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","बळयिर इतद पोल्‍लो सबेटोर विस्वसिरिह्‌क विचर वाता. अदिह्‌क ओर इस्तिपन पेदिरतोन आचतोर, ओग़ पका विस्वस केवाल, ओसो पवित्र जीवाते निंदिस मनवाल. ओना संगे पिलिप, परुकुरुस, नीकानोर, तीमोन, परमिनाल, निकुलावुस, वेरिन आचतोर. (निकुलावुस इतेके अंताकिया इनदनद सहरतोग़ आंदोग़. ओग़ मुनेटाहि यहुदि दर्मतोग़ आयोग़ मति, पया यहुदि दर्मते ओळियतोग़. ताना पया येसुन विस्वस कीतोग़.) ");
INSERT INTO mrr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","विस्वसिरा मुडग्डाहि वेरिन आचिसि, बळयिरा मुनेह निल्पिह कीतोर. ओर नितस्के, बळयिर तमाङ कय्किन ओरा पोग़ोन तासिसि, देवुळता देय्वा ताल्ह्‌कतोर, (ताल्ह्‌किसि ओरिन गाटो तूसनद सेवातेनाह्‌क निल्पिह कीतोर). ");
INSERT INTO mrr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","अद्रमे पया, देवुळता पोल्‍लो वेल्‍लाय पोकुर आसोर अता.येरुसलेम सहरतगा विस्वसिर वेल्‍लाय बोल्गतोर. अहे यहुदि बूमयालोर वेल्‍लाटोर, येसुन विस्वस कीसि, ओना कबुर केंजलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","इस्तिपननगा इतेके देवुळता तोळ, ताना लाव मता. अदे लावते ओग़ु लोकुरा मुनेह, बामनाह लेह्‌काडाङ कबस्क कींदोग़. देवुळता लावताङ सीनाङ वने तोहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","अस्के पया इद्रम आता इतेके, उय्तुर कुरेने सहरतोर, सिकंदरिया सहरतोर, किलिकिया पटटोर,आसिया पटटोर मन्कलोर मतोर, वेर रोम सर्करतोर विळ्सिसीतोर यहुदिरा पार्तनाता लोतगा जमा आस मतोर. ओरग्डाहि उय्तुर इस्तिपननगा वास तेल्वेङ कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","मति इस्तिपन देवुळता जीवा ईतद बुदते वळ्ह्‌कनदिन ऊळिसि, ओरु ओन तेल्वेने गेल्स पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","पया ओर बाताल कीतोर इतेके, दुस्रोरगा अन्जि, “वेग़ इस्तिपन मोसानाङ अडोनु ओसो देवुळताङ पोल्‍लोनु, पास्कसोर मनदनदिन केंजतोम इन्जि वेहाट रो!” इनजोर कुस्क्नेन काग़्हतोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","काग़्हतस्के ओर इद्रम कीतोर इतेके, लोकुरगा, पेदल्कनगा, सास्त्रमगूरुरगा अन्जि, अद्रमे वेहचि ओरिन ओङ तग़्हचीतोर. ओङ तग़्हतस्के, ओर इस्तिपनिन अग़-ओङतेन पोस, यहुदिराङ तग्वाङ केवालोरगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अहे जोल साक्सि एवालोरिन वने तचि, यहुदिराङ तग्वाङ केवालोरा मुनेह निल्पिह कीतोर. कीतस्के, “वेग़ इस्तिपन इद पवित्र गूडटुन, मोसानाङ अडोनु, रोमवालेवा पास्कसोरेन मन्ह्‌तोग़. ");
INSERT INTO mrr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ओसो ‘नासरेत नाटेनोग़ येसु इद मंदिरतुन बूळे कीयनोग़, ओसो मोसा मुय्तोग़ माक ईतव रीतरिवज्किन मिळ्हचीयनोग़,’ इनजोर वेग़ वेहतनदिन माट केंजतोम,” इन्जि ओर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","पया अद पंचतगा उदिस मतोर सबेटोर इस्तिपननके ऊळतोर, अस्के ओना मोकम देवतुलता मोकमलेह्‌का मांजतप दिसता. ");
INSERT INTO mrr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","अस्के, “वेर वेहतनाङ पोल्‍लोङ सेतेमा? जोलिया?” इनजोर मोदुल पेर्माल इस्तिपनिन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","इस्तिपन इतोग़, “मावोरिर, पेदल्कनिर, नावा पोल्‍लो केंजाट. मावा पेदामुय्तोग़ अब्रहमना पोल्‍लो वेहतकन. ओग़ हारान सहरतगा अनवाय मतोग़, अस्के कसदि जाततोर मनदनद मेसोपोटामिया इनदनद देसेमतगा मतोग़. अगा मनदह्‌पा तना डीसाते मांजनद देवुळि ओनगा वाता. ");
INSERT INTO mrr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","वासि इता, ‘निमा नीवा देसेमतुन, नीवा जीवा-तलातोरिन विळ्सिसि, नना तोहतकन अदु देसेमते दाकिन,’ इनजोर देवुळि वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","अस्के अब्रहम कसदि जाततोर मनदनद मेसोपोटामिया देसेमताहि पेसिसि, हारान इनदनद सहरतगा अतोग़. अगा ओना तपे हातापया, देवुळि अब्रहमिन अद सहरताहि पेहचि, इंजेके माट मह्‌नल इद देसेमतगा तच उदिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","इद्रमलेह्‌का ओग़ मग़-मियाळलेवा, इद देसेमतगा वातोग़. मति इद देसेमतगा इद नावा बूमि इन्जि वेहतलाहि, अब्रहमिह्‌क इचुन वने बूम इलवा मता. देवुळि ओन्क उंद कुटामेंड वने बूम एवो आस मता, मति ‘नीकु अहे नीवा जालपिलतुह्‌क इद देसेमता बूम ईकन,’ इनजोर पोल्‍लो विळ्सिस मता. ");
INSERT INTO mrr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","मति ‘नीवा जालपिल दुस्रा देसेमते पर्गेरा लेह्‌का आसि मनदनुर. अगा ओरु नालुङ नूह्‌क वर्साङ, अग्डोरा कय इळ्नबेरा तिपलते मनदनुर. ");
INSERT INTO mrr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","मति, बेद देसेमतोर ओरिन कय इळ्न तासिस तिपल कीयनुर, ओरिह्‌क नना सिक्सा ईकन. पया नीवा जालपिल अद देसेमताहि पेसिस वायनुर, पेसिस वातापया इदे बूमतगा नाक मोळ्कनुर,’ इनजोर वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","पया इद कीतद करलता सीना तोहतलाहि, ओन डायना रिवज कीया वेहता. पया अब्रहमिह्‌क ओर्वोग़ पेकाल पुटटोग़, ओना पेदिर इसक मता. ओग़ पुटटापया आट दियाने, अब्रहम ओना डायना रिवज कीतोग़. पया इसकिह्‌क याकुब इनवाल पेकाल पुटटोग़,(वेग़े याकुबना दुस्रा पेदिर इस्रयेल आंदु.) वेनग्डाहे बारा मग़्क पुटटोर. ओर मावा बारा कूळिनोर पेदामुय्तोर आंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“वेर बारा मग़्किरग्डाहि उय्तुर बाताल कीतोर इतेके, तमा तमोग़ योसेपिन कुळ्सातुह्‌क, मिसर देसेमते अनवालोर वीकुरतोरिह्‌क अमेसातुह्‌क ओर्युल आयलाह वमतोर. मति देवुळि योसेपना तोळ मता. ");
INSERT INTO mrr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","अदिनेनाह्‌क ओन सबे तिपल्कनग्डाहि पिसिह कीता. ओसो योसेपिह्‌क वेल्‍लाय बुद ईता. वेना बुदतुन ऊळिसि, मिसर देसेमतोग़ पिरोन इनवाल राजाल वेनु मान ईसि, पूरा देसेमतुन, ओसो तना लोतुन वने, ताकिह कीयनद अदिकर योसेपना कयदगा ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“अद तूकने मिसर देसेमतगा, ओसो योसेपना दादालोर मतद कनान देसेमतगा, दुकळ अर्स मता. अदिह्‌क सबेटोर लोकुर वेल्‍लाय तिपलते अरतोर. मावाङ तादोर-बाबोरिह्‌क तिनदलाह अनम दोर्को आस मता. ");
INSERT INTO mrr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","मति मिसर देसेमतगा अनम दोर्किह्‌ता इन्जि, याकुब मुय्तोग़ केंजतोग़, केंजिसि मावाङ तादोरिन अगा अनम असिस ततलाह लोहतोग़. अस्के अतोर, (मति इद देसेमतुन ताकिह केवाल मावाय तमोग़ इन्जि, पुनोर आस मतोर). ");
INSERT INTO mrr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ततद अनम मारतापया, ओसो उंद मल्का ओर मिसर देसेमते अतोर. अस्के योसेपि नना मीवाय तमोनन इनजोर ओरिन वेहतोग़. अस्के पिरोन राजाल वने योसेपना लोतोरिन पुतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","पया योसेपि तना तपे याकुब मुय्तोन ओसो ओना लोतोर सबेटोरिन, मिसर देसेमते वासि मनदकिर इनजोर, कबुर लोहच केयतोग़. ओर सबेटोर मूंड वीसाङ पंद्रा (75) इच्वुर मन्कलोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","पया याकुब मुय्तोग़ मिसर देसेमतगा अतोग़, अन्जि अगा वेल्‍लाङे वर्साङ मन्जि डोलतोग़; ओसो मावोर बारा तादोर वने डोलतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ओराङ सेत्तानु सेकेम इनदनद नाग़ ओसि, अगान गति कीतोर. गति कीतद जागातुन, अब्रहम मुय्तोग़ सेकेम नाटेनोग़ अमोर पेदिरतोनाङ मग़्किरग्डाहि, वेंडिङ ईसि असिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“(तिपल कीयनद देसेमताहि, नीवा जालपिलतुन पेसिह कीसि, कनान देसेमते ततकन इन्जि,) अब्रहम मुय्तोह्‌कु देवुळि मुनेन पोल्‍लो विळ्सिस मता. अद पोल्‍लो करल आयनद वेला एवसोर मता. मिसर देसेमतगा मावा लोकुर वेल्‍लाटोर तेग़ आसोर अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","अद तूकने योसेप हातापया वेल्‍लाङे वर्साने, ओन मुर्तिय पुनवोग़ ओर्वोग़ मन्कल मिसर देसेमते राजाल आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ओग़ राजाल इतेके, पका सत्रल बुदतोग़ मतोग़. अदिह्‌क मावा जाततोर लोकुरिन इचोन तिपल कीतोग़ इतेके, आपुनाङ बाला पेकोर डोलिर इनजोर, तलिस्क-तपेर ओरिन लोतग्डाह पेसिह कीस विळ्सिस ईयनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","अद तूकने मोसाल पुटटोग़, ओग़ पका बेस सोबातोग़ पेकाल मतोग़. ओग़ पुटिस मूंड नेलाङ आनाह्‌जोम, राजानाङ केंजवालेवा, ओना तलोग़-तपे ओन लोने अय कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","मति ताना पया ओन लोताहि पेसिह कीसि, बेरेटगा ओसि विळ्सिस ईया पोयता. अस्के पिरोन राजाना मयाळि ओन पेह्‌किस ओसि, नावा मग़ आयनोग़ इनजोर, ओन अय कीता. ");
INSERT INTO mrr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मोसाल बेरोग़ आसि, मिसर देसेमताङ सबे बुदिङ-एदिङ कग़यतोग़; तनाङ वळ्ह्‌कनाङ पोल्‍लोने, कीयनाङ कबस्कने वने, पका उसर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“पया मोसा मुय्तोग़ रेंड वीसाङ वय्सतोग़ आतोग़, अस्के ओर्युल मन्जि कूल केवालोर नावा इस्रयेल जाततोरिन, कलियकन इन्जि विचर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","कीसि अगा अतस्के, ओर्वोग़ मिसरि मन्कल इस्रयेल मन्कन उगसिन नल्हतनदिन मोसाल ऊळतोग़. ऊळिसि इस्रयेल मन्कन पिसिह कीसि, मिसर देसेमतोग़ मन्कन हव्किसि, देबाङ तितोना बद्ला एतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","नावाय कयदे देवुळि मावा लोकुरिन पिसिह कीयग़ा इनजोर, नावा लोकुर पुनदनुर इन्जि, मोसाल विचर कीतोग़. मति अद्रमता विचर वेर ओर्युलतोरा जीवातगा मुर्तिय वावो. ");
INSERT INTO mrr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","पया इमा दिया इर्वुर इस्रयेल मन्कलोर जग्ळा आयनदिन मोसाल ऊळतोग़. ऊळिसि ‘मीट इतेके उंदिय जाततोरिर, दादाल-तमोग़ आयवालोरिर, बाराह्‌क जग्ळा आय्ह्‌निर रा?’ इद्रम इन्जि, ओरिन गूनम कीयलाहि तेळियिह कीसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","मति जग्ळा आयवालोरग्डाहि, तना तोळतोग़ नल्हवाल मोसा मुय्तोन दोबिस इतोग़, ‘मावा नेयम कीसि, मावा पोग़ोन अदिकर ताकिह कीयलाहि, नीक बोग़ निल्पिह कीतोग़ रा? ");
INSERT INTO mrr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","निने मिसर देसमतोन बेद्रम हव्कतिन, अद्रमे नाक वने हव्कलाह ऊळिह्‌निन अय?’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","निने आतद पोल्‍लो इंजेक सबेटोरिह्‌क एर्का आता इन्जि, मोसा मुय्तोग़ रेयतोग़. रेयिसि मिसर देसेमताहि पेसिस विततोग़, वितिसि मिदियन इनदनद देसेमतगा अन्जि, मनदलाह आतोग़. पया अगान मुतेन ततोग़, ओन्क इर्वुर पेकोर पुटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“इद्रम मोसा मुय्तोह्‌क मिदियन देसेमतगा अन्जि, रेंड वीसाङ वर्साङ आताङ. उंद दिया सीनयइनदनद मेटाकचुदा पेळ्ह्‌कल बूमतगा बाताल आता इतेके, किस पोतसोर मतद मरा जपताहि, देवुळता देवतुलिओन्क दिसता. ");
INSERT INTO mrr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","(अद मरा जपतगा किस पोतलाह पोतिंदु, मति अद जप मुर्तिय कर्वो आंदु.) तान ऊळिस मोसा मुय्तोग़ बामतोग़, पया तान बेस ऊळलाहि अद जपता एरे अतोग़. अगा अतस्के देवुळता आल्का ओन्क इद्रम केंज वाता इतेके, ");
INSERT INTO mrr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘मोसा, नना नीवा तादोर-बाबोरा देवुळतन; अब्रहम, इसक, याकुब, वेर मोळ्कनद देवुळतन ननान आंदन,’ इनजोर इता. अदिन केंजिसि मोसा मुय्तोग़ दिरदिर साङतोग़, अगा ऊळलाह वने रेयतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","अस्के देवुळि ओन इद्रम इता, ‘इंजेक इद जागाते नना मह्‌नन. अदिह्‌क निमा नीवाङ एल्पुस्क तेंडा. ");
INSERT INTO mrr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","केंजा, मिसर देसेमतोर लोकुर नावा लोकुरिन बेद्रम तिपल कीस्तोर, अदिन नना बेस-नेह्‌ना ऊळतन. नावा लोकुर ओरा कय इळ्न मन्जि अळयनदिन, केयनदिन केंजतन. ओरिन विळ्सिह कीयलाहि नना रेगतन. अदिनेनाह्‌क निमा नावा इद कबळ कीयलाहि अन, नीक मिसर देसेमते लोहतकन,’ इनजोर देवळ इता. ");
INSERT INTO mrr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“अद्रमे ‘मावा नेयम कीसि, मावा पोग़ोन अदिकर ताकिह कीयलाहि, नीक बोग़ निल्पिह कीतोग़?’ इनजोर, वेग़ मोसा मुय्तोन इस्रयेल मन्कलोर मुनेन पास्किस मतोर, इदिन सीता कीम्ह्‌टु. मति इंजेके वेग़े मोसा मुय्तोह्‌क देवुळि अदिकर ईसि, तना मन्कलोरिन मिसरतोरा कयदाहि विळ्सिह कीस ततनोग़ इनजोर निल्पिह कीसि, किस पोतसोर मतद मरा जपतगा दिसतद देवतुलता मेटे, ओन मिसर देसेमतगा लोहता. ");
INSERT INTO mrr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","वेग़ मोसा मुय्तोग़ इस्रयेल मन्कलोरिन मिसर देसेमताहि पेसिह कीस ततोग़. अद देसेमतगा, एरल सम्दुरतगा, ओसो पेळ्ह्‌कल बूमतगा, रेंड वीसाङ वर्साङ आनाह, बामनाह लेह्‌काडाङ सीनाङ तोहचोर-तोहचोर, ओरिन ताकिह कीसोर ओतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","वेग़े मोसा मुय्तोग़ ‘नावा लेह्‌काडोग़ कबुरतोग़ मन्कन, मीवा जालपिलताहि निल्पिह कीसि, देवुळि तना लोकुरगा लोहचीयग़ा,’ इनजोर इस्रयेल मन्कलोरिन वेहच मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","पेळ्ह्‌कल बूमतगा मावाङ तादोर-बाबोरा संगे मतोग़ु, वेग़े मोसा मुय्तोग़. ओसो सीनय मेटातगा देवुळता देवतुलि ओना संगे मता. अद देवतुलता मेटे मयगा एव्सिह कीयना इनजोरे, ओन्के देवुळताङ पोल्‍लोङ दोर्कताङ. देवुळता मन्कलोर बेद्रम पिसना इन्जि, अव पोल्‍लोङ तोहतह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“मति मावाङ तादोर-बाबोर ओना पोल्‍लोतुन केंजवालेवा, ओन विळ्सिसि मिसर देसेमतेकेन मल्स अतेक तेला बेस आवालि इनजोर, सीता कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","अदिह्‌क मोसा मुय्तोग़ सीनय मेटातगा मतोग़ अस्के, ओना दादाल आरुननगावासि, ‘माक मिसर देसेमताहि ततोग़ मोसाल, बेके बह आतोग़ो, इदिन माट पुनवल. अदिनेनाह्‌क इंजेके माक पेन बोमाङ पंडिस ईम, अवे पेन्क माक मुनेह अग़ तोहतनुङ,’ इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","अद्रमे पया ओर बंगरता पियो पंडिसि, अद पियोतुन पेन इन्जि, तान्क मोक ईसि मोळ्कतोर. मोळ्किस तमा कयदे पंडटद बोमातेनाह्‌क, कव्स-गोग़िस तिन्जि-उन्जि गिर्दा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","अदिह्‌क पोग़ोटा पोळ्‍दतुन, नेलातुन, उकान मोळ्किर इन्जि, देवुळि ओरिन विळ्सिस ईता. इद पोल्‍लो देवुळता कबुरतोरा सास्त्रमतगा, इद्रम रासतद मन्ह्‌ता इतेके, ‘ए इस्रयेल मन्कलोरिर, मीट रेंड वीसाङ वर्साङ पेळ्ह्‌कल बूमते जन्वर्कनाङ मोकिङ ईतिर, अविस्किन नयेनाह्‌क ईतिरा? बार दुस्राङ-दुस्राङ पेन्कनेनाह्‌क ईतिर? ");
INSERT INTO mrr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","मोलेक पेदिरता पेनता रावुळतुन, ओसो रिपान पेदिरता उका बोमातुन कांजिस वेलियतिर, मोळ्कलाह अविस्किन पंडटिर, अदिह्‌क मीवा कोंटेतोरा कयदे मीक विळ्सिस ईकन, ओर मीक पोसि बेबिलोन देसेमता अबर ओयनुर,’ इनजोर देवुळ इता, इद्रमलेह्‌का रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“पेळ्ह्‌कल बूमतगा मावाङ तादोर-बाबोर मनदह्‌पा, देवुळि तना लोकुरा नडुम मनदनदिना साक्सि तोहतनद रावुळि, ओरा संगे मता. मोसा मुय्तोना संगे देवुळि अद रावुळतुन इद्रम इद्रम पंडा इनजोर तोहच मता, अद्रमे मोसाल तान पंड वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","मोसा मुय्तोग़ हातापया, अद रावुळि पयाडोरा पीळता कयदे वाता. मोसाल हातस्के, ओना तोळतोग़ यहोसाल, इस्रयेलतोरा मुक्याल आतोग़. वेग़े यहोसाल मावाङ तादोर-बाबोरिन इद देसेमते तचीतोग़. ओरा मुनेह देवुळि दुस्राङ जातिनोरिन इद बूमतग्डाह पूंडटा, पूंडटस्के इस्रयेलतोर इगा जागा आतोर. अस्के अद रावुळतुन इगा तासतोर, पया अद दाविद राजाना कालम एवनाह इगान मता. ");
INSERT INTO mrr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाविद राजाना पोग़ोन देवुळता गूनम मताह्‌कु, सबेटोर इस्रयेल मन्कलोर नीक मोळ्कना इन्जि, नियेनाह्‌क उंद मंदिर पंडकन इन्जि, दाविद राजाल देवुळतुन ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पया देवुळतेनाह्‌क मंदिर पंडटोग़ मन्कल दाविद राजाल आयोग़, ओना मग़ि साल्मोन राजाल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","मति मन्कना कयदे पंडटा मंदिरतगा देवुळि मनो, इद पोल्‍लोतुन देवुळता कबुरतोग़ ओर्वोग़ मुनेन रासतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","देवुळि इद्रम इन्ह्‌ता, ‘पोग़ोटा बूमि नावा उदनद राजकुर्सि, इळ्ता बूमि नावाङ काल्क तासनद कुतुलि. नयेनाह्‌क बेद्रमता लोन पंडकिर? नना रोमनद बेद्रमता जागा मनदग़ा? ");
INSERT INTO mrr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","इव सबेटविन ननान पुटिह कीतोनन आयोना?’ इता. ");
INSERT INTO mrr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“मीट कैंगम मन्कलोरिर! डायना रिवज कीतेक तेला, मीट देवुळतुन पुनवोरा लेह्‌का, तान जीवा केवोरिर, तानाङ पोल्‍लोङ केंजवोरिर! बेद्रम मीवाङ तादोर-बाबोर कींदुर, अद्रमलेह्‌कान मीट वने देवुळता पवित्र जीवातुन अडम आय्ह्‌निर. ");
INSERT INTO mrr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","देवुळता कबुरतोरग्डाहि मीवा तादोर-बाबोर ओर्विन वने तिपल केवोरा, अले वेहाट? देवुळ लोहवाल सेतेमतोग़ किर्स्तु वायनोग़ इनजोर, अद कबुरतुन मुनेन पोकुर कीतोरिन, मीवा तादोर-बाबोर हव्कतोर. अद्रमलेह्‌का ओग़ किर्स्तु वातस्के, मीट ओना पोग़ोन उगसिन तप तोहचि, हव्कनाह कीतिर. ");
INSERT INTO mrr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","देवतुल्कना कयदग्डाहि मोसानाङ अडोङ मीक दोर्कताङ, मति अव अडोन मीटे माळविर,” इन्जि इस्तिपन वेहच रोमतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","इस्तिपन वळ्ह्‌कतद पोल्‍लोतुन केंजिसि, तग्वाङ केवालोरिह्‌क इचोन ओङ वाता इतेके, ओन ऊळिस तमाङ पल्क कोग़्कलाह बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","मति इस्तिपन देवुळता जीवाते पूरा निंदिसि, पोग़ोन कोंडा मिळ्हवा ऊळतोग़. ऊळतस्के देवुळदीपते देवुळता जग-मळ्गना वेह्‌चतुन, ओसो येसुन देवुळता तिनळ बाजे नितदिन ऊळिसि इतोग़, ");
INSERT INTO mrr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“ओद ऊळाट! पोग़ोन देवुळदीप पङ्ने आतदिन, ओसो मान्वना नडुम पुटटोग़ु, देवुळता तिनळ बाजे नितदिन नना ऊळलाह आतन!” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","इतस्के तग्वाङ केवालोर लोकुर, (वेग़ देवुळतुन पास्किह्‌तोग़ इनजोरे,) पकाय जोरते केयिसि तमाङ केव्किन मुचतोर, मुचिस उंदि विचरते वित वासि ओन पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","पोसि सहरता पलते गुंजिस ओतोर. अगा सोलु पेदिरतोग़ लेयोग़ निच मतोग़, ओनगाने जोल साक्सि एवालोर तमाङ पोग़ोट्क केग़तव जगाङ तेंडिस ईतोर. पया इस्तिपनना पोग़ोन बंडाङ उकलाह बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ओर बंडाङ उकलाह आंदुर अस्के इस्तिपन, “ए येसुसामि नावा जीवातुन एना,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","पया मिंडाङ कोटिसि बेरा लेङते “ए सामि, वेर मन्कलोर कीतद इद पापमता बद्ला ओरिह्‌क एमा,” इनजोर वळ्ह्‌किसि डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","इस्तिपनिन हव्कतोर अस्के सोलु वने पूरा संग आतोग़. इस्तिपनिन हव्कतापया अदे दिया, येरुसलेम सहरतगा येसुना विस्वसिरा मुडुन पकाय तिपल कीया बोटटोर. अदिह्‌क बळयिरिन विळ्सिसि, सबेटोर विस्वसिर येरुसलेम सहरताहि वितिसि पूरा यहुदा पटटे, सामरिया पटटे, बिरोबटो आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","देवुळतुन पकाय माळवालोर बोर मतोर, ओरु इस्तिपनना सेत्तातुन गुमयातगा ओस गति कीतोर, अस्के ओर पकाय जोरते अळतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","अद तूकने सोलु बाताल कींदोग़ इतेके, विस्वसिरा मुडुन बूळे कीयलाहि, लोह्‌क-लोह्‌क ओळियिसि, विस्वस केवालोर आस्क-कोय्तोरिन पोसि, जेलतगा वाट वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","पया बिरोबटो आतोर मन्कलोर, येसुना बेसता कबुरतुन वेल्‍लाय पोकुर कीसोर तिरियतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","अद्रमे (मुने आचतोर एळवुर सेवकिरग्डाहि) पिलिप इनवाल मतोग़, वेग़ वने सामरिया पटटा उंद सहरतगा अन्जि, येसुये देवुळ लोहतोग़ किर्स्तु आंदोग़ इन्जि, ओना कबुरतुन पोकुर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","8","पोकुर कीसोरे, देवुळताङ बामनाह लेह्‌काडाङ सीनाङ तोहन्दोग़. देयह्‌क पोस मतोर वेल्‍लाटोर लोकुरिनु, देवुळि पिलिपना कयदे बेस कीता. अव देयह्‌क पकाय जोरते केयसोर ओरग्डाह पेसताङ, अद्रमे कय्क-काल्क वावोर, ताक पग़वोर वेल्‍लाटोर मन्कलोर वने बेस आतोर. अविस्किन ऊळिसि, अद सहरतोर लोकुर पकाय गिर्दा आसि, पिलिप वेहतनाङ पोल्‍लोङ बेस केंजिदुर. ");
INSERT INTO mrr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","इंजेके अदे सहरतगा, पूजर-गूनिङ केवाल सिमोन पेदिरतोग़ मन्कल मतोग़. ओग़ तनाङ गूनिने सामरिया जाततोरिन पकाय बामिह कीसि, ननाय बेरोग़ गूनयानन इनजोर वेहचोर तिरियिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","वेल्‍लाटोरे उड्लोर-बेरोर ओग़ वेहतनव पोल्‍लोन बेस केंजिंदुर, ओसो देवुळता बेरा लावतोग़ इतेक वेग़े इनजोर, सबेटोर ओन इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ओग़ वेल्‍लाङे वर्साङ आनाहि तनाङ गूनिने, मन्कलोर बामनाह लेह्‌काडाङ कबस्क कींदोग़. अदिनेनाह्‌क कतमतोर लोकुर ओना पोल्‍लो बेस केंजिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","मति पिलिप अगा अन्जि, देवुळि मन्कलोरगा राजेम कीयनद बेसता कबुरतुन, ओसो येसुये देवुळ लोहतोग़ पिसिह केवाल किर्स्तु आंदोग़ इनजोर, वेहता बोटटोग़. अद पोल्‍लोतुन केंजिस विस्वस कीतोरु, आस्क-कोय्तोर येसुना पेदिरते एग़ मीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","पया सिमोन वने विस्वस कीसि, येसुना पेदिरते एग़ मीतोग़. पिलिप, देवुळता लावते बेराङ-बेराङ डीसाताङ कबस्क कींदोग़. अव कबस्किन ऊळिसि, सिमोन बामिंदोग़. अदिनेनाह्‌क ओग़ पिलिपनाय संगे मंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","सामरिया पटटोर मन्कलोर देवुळता पोल्‍लोतुन विस्वस कीतोर इनजोर, येरुसलेमते मतोर बळयिर केंजतोर. केंजिसि पत्रु, योहन, वेर इर्वुर बळयिरिन सामरिया पटटे लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","अग्डोर विस्वसिर येसुसामिना पेदिरते एग़ मीस मतोर, मति देवुळता पवित्र जीवा ओरा पोग़ोन उदवाय मता. अदिह्‌क पत्रु, योहन, वेरु ओरगा अन्जि सबेटोर विस्वसिरा पोग़ोन पवित्र जीवा उदि इनजोर, ओरेनाह्‌क देवुळतुन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","पया ओर विस्वसिरा पोग़ोन तमाङ कय्क तासिंदुर, अस्के पवित्र जीवा विस्वसिरा पोग़ोन उदिंदु. ");
INSERT INTO mrr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","वेर बळयिर विस्वसिरा पोग़ोन तमाङ कय्किन तासतस्के, पवित्र जीवा ओरा पोग़ोन उदनदिन सिमोन ऊळतोग़. ऊळिसि ओरगा कोताङ तचि, ");
INSERT INTO mrr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“नना वने बोनाय पोग़ोन नावा कय तासतेके, ओना पोग़ोन पवित्र जीवा उदना इनजोर, इद नाक अदिकर ईम्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","अस्के पत्रु ओन इतोग़, “नीवाङ कोताङ नीवाय संगे बूळेम आयिङ! देवुळि पुनेम ईयनदिनु, कोताने असकन इनजोर, विचर कीतिन अय? ");
INSERT INTO mrr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","नीवा बुदि बेस इले इनजोर देवुळि ऊळता. अदिनेनाह्‌क ताना सेवाते निमा मावा तोळ आया पग़विन, मयगा कलिय पग़विन. ");
INSERT INTO mrr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","नीवा जीवा कर्वनदिन, ओसो निमा पापमतगा एग़्किस मनदनदिन ऊळिह्‌नन, अदिह्‌क देवुळतुह्‌क विचर वावद अग़दाहि मल्सि, तान पार्तना कीम; अस्के इद्रमता नीवा पापि विचरतुन, देवुळि मापि कीतेके कीयग़ा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","इतस्के, “मीट इतद गोसा नावा पोग़ोन वामाकि इनजोर, नयेनाह्‌क देवुळतुन मीटे पार्तना कीम्ह्‌टु,” इनजोर वेग़ पत्रुनु, योहनिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","अद्रमे पत्रु, योहन अगा किर्स्तुना पोल्‍लोतुन पोकुर कीसि, ओग़ बाताल बाताल कीतोग़, अव कबस्कना साक्सि ईतोर. साक्सि ईसि, येरुसलेम सहरते मल्स दायलाह आतोर. अनेके सामरियातोराङ वेल्‍लाङे नाह्‌कनगा, येसुना बेसता कबुरतुन पोकुर कीसोर-कीसोर अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","पया बेद्रम आता इतेके, देवुळता देवतुलि पिलिपनगा वासि इद्रम इता, “निमा दक्सिन बाजेतेके पेसिसि, येरुसलेम सहरताहि गाजा इनदनद सहरतेक दायनद अग़ पोस अन,” इता. (अद अग़ि पेळ्ह्‌कल बूमतुह्‌क दास्ता.) ");
INSERT INTO mrr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","इतस्के पिलिप दायह्‌पा, ऊळाट कूस इनदनद देसेमतोग़ ओर्वोग़ मन्कल वने, अदे अग़दुह्‌क अनजोर मतोग़. ओग़ मन्कल बाय्लाल मन्जि, कूस देसेमता कन्दाके पेदिरतद रानिना मंत्रि आंदोग़. ताना राजेमताङ कोतान ऊळेवाळे केवाल आंदोग़. ओग़ देवुळतुन मोळ्कलाहि येरुसलेम अन्जि, ");
INSERT INTO mrr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","तना देसेम मल्स अनजोर मतोग़. ओग़ तना कोडागाडातगा उदिसि, देवुळता कबुरतोग़ यसयाल इनवाल रासतद पुस्तकतुन अर्वसोर, अनजोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","अस्के देवुळता जीवा पिलिपिन, “निमा अगा अन्जि, अद कोडागाडाता संगे अन,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","अस्के ओग़ अद कोडागाडातगा एवनाह विततोग़, वितिसि कूस देसेमतोग़ मन्कल देवुळता कबुरतोग़ यसयाना पुस्तकतुन अर्वनदिन केंजतोग़. केंजिसि, “निमा अर्विह्‌निन अद तेळियिह्‌ताया, तेळियोया?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","अस्के मंत्रि, “बोग़ाय तेळियिह कीस वेहवालेवा, नाक बेद्रम तेळियग़ा? वाय निमा वने नावा संगे कोडागाडातगा उदा,” इनजोर पिलिपिन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ओग़ मंत्रि देवुळता सास्त्रमतगा इद वचन अर्विंदोग़ इतेके, अस्कलाह ओयनद गोरेता लेह्‌का, अहे केल्क कोग़ियवाल कोग़ियिह्‌पा, केमेन निच मनदनद गोरेपियोता लेह्‌का, देवुळता सेवक केमेन मतोग़, बाताले इनोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ओना कदर रेहनेके, बोग़े ओनेनाह्‌क नेयम कीस एवोग़. ओर ओना जीवा तिताह्‌कु, ओना जालपिलता पोल्‍लोय इले. इनजोर रासिस मता. ");
INSERT INTO mrr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","पया ओग़ मंत्रि इद पोल्‍लोतुन अर्विसि पिलिपिन ताल्ह्‌कतोग़, “देवुळता कबुरतोग़ बोना पोल्‍लोतुन इगा रासतोग़? तनाय पोल्‍लोतुना? बार बोग़ दुस्रोना पोल्‍लोतुना? अले नाक वेहा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","अस्के पिलिप, मंत्रि अर्वसोर मतद वचनतेनाह सुरु कीसि, येसुना बेसतल कबुरतुन तेळियिह कीस वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","पया वेहचोर वेहचोर उंद वेच्‍चातगा एवतोर, एवतस्के मंत्रि इतोग़, “इद ऊळा, एग़ मन्ह्‌ता, इगा नाक येसुना पेदिरते एग़ मीयलाह बेस आयो आयग़ाया?” इनजोर इतोग़.  ");
INSERT INTO mrr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","इतस्के पिलिप, “निमा पूरा जीवाताहि येसु किर्स्तुन विस्वस कीतेके, नना नीक एग़ मीहतकन,” इतोग़. पया मंत्रि, “इंगो, येसु किर्स्तु देवुळता मग़ि इनजोर, विस्वस कीय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","पया कोडागाडातुन अगान निल्पिह कीया वेहतोग़. निल्पिह कीसि पिलिप, ओग़ मंत्रि, इर्वुर आसि एतगा नेङतोर. अस्के पिलिप ओन येसुना पेदिरते एग़ मीहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","पया ओर एतग्डाहि पेसतस्के, देवुळता जीवा पिलिपिन माय्‍पिह कीस, अग्डाहि ओता. पया मंत्रिह्‌क ओग़ दिसोग़, अस्के देवुळि नाक पिसिह कीता इनजोर, बेस गिर्दा आसि ओग़ मंत्रि अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","पया देवुळता जीवा पिलिपिन असदोद इनदनद सहरतगा एव्सिह कीसीता. ओग़ अग्डाहि केसरिया इनदनद सहरतके दायह्‌पा, अग़कचुल मनदनव सबे नाह्‌कने, येसुना बेसता कबुरतुन पोकुर कीसोर अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","इद्रम आनेके, सोलु येसुना विस्वसिरिन हव्किह्‌नन इनजोर, रेय्‍पिह कींदोग़. रेय्‍पिह कीसोर, उंद दिया मोदुल पेर्मानगा अन्जि, इद्रम इतोग़: ");
INSERT INTO mrr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“इंजेके नना दमिस्क सहरते दाय्ह्‌नन. येसुना अग़दे ताकवालोर आस्क-कोय्तोरिन दोहचि, येरुसलेम ततलाहि सोलुनगा अदिकर मन्ह्‌ता इनजोर, सीटि रासिस ईम. नना अद सीटटुन पोस अन्जि, अग्डोर यहुदिरा पार्तनाताङ लोह्‌कनाङ मुक्यालोरिह्‌क तोहतकन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","पया सोलु अद सीटटुन पोसि, दमिस्क सहरते दायलाह आतोग़. अद सहरता एरे-एरे एव्स मतोग़, अस्के पोग़ोटाहि दोम्ह्‌क्ने ओना सर्ने वेह्‌च अरता. ");
INSERT INTO mrr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","वेह्‌च अरतस्के सोलु नेल अरतोग़. अस्के “ए सोलु, निमा नाक बाराह्‌क तिपल कीयलाह आतिन?” इनजोर ओन्क उंद आल्का केंज वाता. ");
INSERT INTO mrr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","अस्के सोलु इतोग़, “सामि, निमा बोनिन आंदिन?” इतस्के, येसु इतोग़, “निमा बोन तिपल कीयलाह आतिन, ओग़े येसुनन आंदन. ");
INSERT INTO mrr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","निमा इंजेक इग्डाह तेदिस सहरते अन, बाताल कीयनद अद नीक अगान बोग़ाय वेहतनोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","सोलुना संगे अनवालोरिह्‌क सिरप आल्का केंज वाता, मति ओरिह्‌क बोग़े बह दिसोग़. अदिह्‌क ओर रेयिस केमेन निच मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","पया सोलु तेदिस कोंडाङ नाह्‌किस ऊळनेके, ओग़ मुर्तिय तोवोग़. अदिनेनाह्‌क ओना तोळतोर ओनाङ कय्किन पोसि, दमिस्क सहरतगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","अगा ओग़ मूंड दियाङ आनाहि तोववालेवा, ओसो बाताले तिनवा-उनवालेवा मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","पया इद्रम आता, दमिस्क सहरतगा ओर्वोग़ विस्वसि मतोग़. ओग़ अनन्याल पेदिरतोग़ आंदोग़. येसुसामि तना तोहतनद लेकाते, ओनगा वासि इद्रम इतोग़, “ए अनन्या!” इतस्के “बाताल सामि?” इनजोर अनन्याल इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","येसुसामि इतोग़, “इंजेके तेदिसि, सीदा इनदनद अग़दे अन्जि, यहुदा पेदिरतोना लोन अन. अन्जि तरसुस सहरतोग़ सोलु बेगा मन्ह्‌तोग़ इनजोर ताल्ह्‌का. ओग़ सोलु इंजेके पार्तना कीयलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","पार्तना कीनेके ओग़ु देवुळ तोहतनद लेका ऊळतोग़. ‘अनन्याल पेदिरतोग़ मन्कल वासि, नना तोवयना इन्जि, नावा पोग़ोन कय तासिह्‌तोग़,’ इद्रम सोलु लेका ऊळतोग़,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","इतस्के अनन्याल इतोग़, “अलो सामि, ओग़ मन्कल येरुसलेम सहरतगा बेद्रम नीवा मन्कलोरिन पकाय तिपल कीतोग़ इनजोर, वेल्‍लाटोर लोकुर नाक वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","इगा वने नीक मोळ्कवालोर सबेटोरिन दोहच ओयलाह, पेर्मालोर ओन्क अदिकर ईतोर इन्जि वने केंजतन,” इनजोर ओग़ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","इतस्के येसु इतोग़, “आयो, निमा ओनगा अन. बाराह्‌क इतेके, नावा पोल्‍लोतुन यहुदि आयवोर दुस्राङ जातिनोरगा, ओरा राजालोरगा, ओसो इस्रयेल लोकुरगा इतेके यहुदिरगा एव्सिह कीयलाहि, ओग़ नावा आचतोग़ सेवक आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","नयेनाह्‌क ओन्क बेचोन तिपल एता पोयग़ा इन्जि, नना ओन तोहतकन,” इनजोर येसु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ताना पया अनन्याल येसु वेहतद लोतगा अन्जि, सोलुना पोग़ोन कय तासिस, इद्रम इतोग़, “ए सोलु तमो, निमा इगा वायह्‌पा, अग़दे नीक दिसिस मतोग़, ओग़े येसुसामि, निमा तोवयना ओसो देवुळता पवित्र जीवाते पूरा निंदना इन्जि, नाक लोहतोग़,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","अस्केडा अस्केन सोलुनाङ कोंडानाहि, उय्का अरतप लेह्‌का बातालो अरता. अस्के ओनाङ कोडाङ पङ्ने आसि, ओग़ तोवयलाह आतोग़. ताना पया येसुना पेदिरते एग़ मीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","पया गाटो तितोग़ अस्के, ओन्क लाव वाता. अद्रमे पया सोलु दमिस्क सहरतोर विस्वसिरा संगे, वेल्‍लाङे दियाङ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अगा मनेके, सोलु यहुदिरा पार्तनाताङ लोह्‌कनगा अन्जि, येसुये देवुळता मग़ि इन्जि, पोकुर कीया बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ओना पोल्‍लोतुन केंजतोर सबेटोर पका बामिसि, “वेग़े आयोया, येरुसलेम सहरतगा येसुन मोळ्कवालोरिन बूळे कींदोग़? इगा वने येसुन मोळ्कवालोरिन पेर्मालोरगा दोहच ओयलाह वास मतोग़!” इनजोर तमतमाय इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","मति सोलुना दीरा वेल्‍लाय वीळसोर अता. येसुना पोल्‍लोतुन ओग़ वेहचोरे अंदोग़. दमिस्क सहरतोर यहुदिरिन येसुये देवुळ लोहतोग़ पिसिह केवाल किर्स्तु आंदोग़ इन्जि, बेस-नेह्‌ना सास्त्रमताहि वेहतोग़, अदिह्‌क ओर पकाय एक्बेक आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","अद्रमे वेल्‍लाङे दियाङ आतापया, यहुदि मुक्यालोर सोलुन हव्कलाह कोहन्दुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","मति अद आय्डा सोलुह्‌क एर्का आता. ओरु ओग़ सहरताहि पेसतस्के, ओन हव्ककल इनजोर, सहरता अग़दगा नग़्का पिळ्‍विळ, पियल-पोळ्‍द केपिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ओनाङ कग़यवालोर बाताल कीतोर इतेके, नग़्का सोलुन ओसि उंद कुचातगा उदिह कीसि, सहरता सर्ने दोहतद किलेता किळ्कि-बूकातग्डाहि, ओन पलते नेल रेहचीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","अस्के पया सोलु येरुसलेम मल्स वातोग़, वासि अगा विस्वसिरिन कलियलाह ऊळतोग़. मति वेग़ सोलु वने येसुन विस्वस कीतोग़ इन्जि, वेन बोरे नमोर आंदुर; अदिह्‌क सबेटोर वेन रेयिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","मति बार्नबस सोलुन पोसि, बळयिरगा ओतोग़. ओसि दमिस्क सहर दायनद अग़दे सोलु येसुन बेद्रम ऊळतोग़, येसु ओना संगे बेद्रम वळ्ह्‌कतोग़, ओसो दमिस्क सहरतगा बेद्रम सोलु मुर्तिय रेयवालेवा, येसुना पोल्‍लोतुन पोकुर कीतोग़, इव सबे पोल्‍लोन ओरिह्‌क वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","अस्के पया सोलु विस्वसिरा संगे कलियसोरेन मंदोग़. कलियिसि येसुना पोल्‍लोतुन, रेयवालेवा पोकुर कीसोरे, पूरा येरुसलेम सहरते तिरियिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","पया सोलु युनानि पोल्‍लो वळ्ह्‌कवालोर विस्वस केवोर यहुदिरिह्‌क वने, येसुना पोल्‍लोतुन वेहचोरेन मंदोग़. वेहनेके, युनानि पोल्‍लो वळ्ह्‌कवालोर यहुदिर वेना संगे ईनाह-आनाह पोल्‍लोने गिटोगटो आंदुर. अदिनेनाह्‌क ओर ओन हव्कलाह अग़ ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","मति विस्वसिर इद पोल्‍लोतुन केंजिसि, सोलुन सम्दुरकचुल केसरिया सहर एवनाह ओसीतोर, पया (अग्डाहि ओन ओडाते उदिह कीसि,) ओना नाग़ तरसुस सहरते लोहचीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","अस्के पया, यहुदा पटटे, गालिल पटटे, सामरिया पटटे, विस्वसिरा मुडुन बोरे तिपल केवोर. अदिनेनाह्‌क ओरिह्‌क सुकम दोर्कता, ओर विस्वसते बेर्ससोर अंदुर. येसुसामिन रेयिस ताकिंदुर. पवित्र जीवा ईतद तोळते ताकिंदुर. वेल्‍लाटोर येसुन विस्वस कीसि, ओरा मुडा संगे कलियिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पया इद्रम आता इतेके, पत्रु इके-अके वेलियसोर, सारोन एरियाता लुदा नाटे येसुना लोकुरगा अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","अतस्के अगा एनियाल पेदिरतोग़ कय्क-काल्क वावोग़ मन्कल कलियतोग़, ओग़ आट वर्साङ कटुदग्डाहि मुर्तिय तेदोग़ आसि. ");
INSERT INTO mrr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पया पत्रु ओन इतोग़, “ए एनिया, येसु किर्स्तु नीक सव्रे कीस्तोग़. अले तेदिसि, नीवा कटुदुन उळ्हा,” इनजोर इतोग़. इताहे एनियाल अस्केडा अस्केन तेदिस नितोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","लुदा नाटेनोर, सारोन एरियातोर वेल्‍लाटोरु, एनियाल सव्रेम आतदिन ऊळिसि, येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","अद्रमे पया सारोन एरियाता यापा नाटेनगा, उंदि विस्वसि आंचाळ मता. ताना पेदिर तबिताल आंदु, तान दोरकास वने इंदुर. अद आंचाळि नाटेनगा आस्क-कोय्तोरिह्‌क अमेसा बेसताङ कबस्क कीसि ईंदु, लेवोरिह्‌क दर्मम कींदु. ");
INSERT INTO mrr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","अद तूकने अद आंचाळि उंद दिया दुक अर्स डोलता. डोलतस्के नाटेनाङ आस्कु ताना सेत्तातुन एग़ मीहचि, पोग़ोटा मिदेता अरातगा तासताङ. ");
INSERT INTO mrr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","इंजेके लुदा नाग़ इतेके, यापा नाटेनाहि एरेन मता. पत्रु लुदा नाटेनगान मन्ह्‌तोग़ इन्जि, अग्डोर विस्वसिरिह्‌क एर्का आता. इद पोल्‍लोतुन केंजिसि, इर्वुर मन्कलोरिन पत्रु चट्पिट वायेग़ इन्जि, ओनेके कबुर लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","अस्के पत्रु ओरा संगे अतोग़. यापा नाटेनगा एवतस्के, ओन पोग़ोटा मिदेता अरातगा ओतोर. अगा मताङ सबे रांडे आस्कु ओनगा जमा आसि, तबितालि जीवात मनदह्‌पा, अविस्किह्‌क कोटटव सबे जगाङ, गेंदेनु तोहचोर अळ्न्दुङ. ");
INSERT INTO mrr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","पया पत्रु सबेटोरिन पलते पेहचि, मिंडाङ कोटिस देवुळतुन अर्जि कीतोग़. कीसि पया सेत्तातके ऊळिस, “ए तबिता, तेदा,” इतस्के, अद आंचाळि कोंडाङ नाह्‌किस पत्रुन ऊळता, ऊळिसि तेदिस उदता. ");
INSERT INTO mrr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","पया पत्रु ताना कयदुन पोस तान निल्पिह कीतोग़, कीसि रांडे आस्किनु, दुस्रोर विस्वसिरिन केयिसि, तबिताल इंजेक जीवा अर्सि निता इन्जि तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","इद पोल्‍लो यापा नाटेनगा पूरा पोकुर आता. आताह्‌कु अग्डोर वेल्‍लाटोर लोकुर येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ताना पया पत्रु यापा नाटेनगान, तोलाङ ओळ्हवाल ओर्वोग़ सिमोन पेदिरतोनगा, वेल्‍लाङे दियाङ रोमिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","सारोन एरियाता केसरिया सहरतगा(ओर्वोग़ रोमिमन्कल मतोग़,) ओना पेदिर कुरनेलि आंदु. ओग़ नूर सीपय्कना दरोगाल मतोग़. ओना तुंगाता पेदिर इतालिया पटटा लळयमुल इनजोर मता. ");
INSERT INTO mrr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ओग़ (यहुदि जाततोग़ आयोग़, मति) यहुदिरा देवुळतुन दिनम मोळ्किंदोग़, ओना लोते मनवालोर सबेटोर देवुळतुह्‌क रेयिस ताकिंदुर. लेवोरिह्‌क दर्मम कींदोग़, दिनम देवुळतुन पार्तना कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","अद्रमे उंद दिया पियल बह्‌ट अर्स मता. अस्के उंद देवतुलि ओनगा वासि नितदिन, देवुळ तोहतनद लेकाते पोळ्क्नेन कुरनेलि ऊळतोग़. अस्के अदु “ए कुरनेलि!” इता. ");
INSERT INTO mrr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","इतस्के कुरनेलि तान ऊळिसि पका रेयतोग़, रेयिसि “बाताल सामि?” इतोग़. अस्के अद इता, “निमा पार्तना कीय्ह्‌निन, लेवोरिह्‌क दर्मम कीय्ह्‌निन, इद देवुळतुह्‌क बेसता कोड वाटटप लेह्‌का गिर्दा वास्ता. ");
INSERT INTO mrr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","इंजेके यापा नाटेनगा सिमोन पत्रु पेदिरतोग़ ओर्वोग़ मन्ह्‌तोग़; उय्तुर मन्कलोरिन लोहचि ओन नियगा केया. ");
INSERT INTO mrr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ओग़ु ओर्वोग़ तोलाना कबळ केवानगा मन्ह्‌तोग़, ओना पेदिर वने सिमोने आंदु. ओना लोन सम्दुरकचुल मन्ह्‌ता,” इनजोर वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","इद्रम वेहचि देवतुल अता. अतापया कुरनेलि बाताल कीतोग़ इतेके, तनाङ इर्वुर ओर्युलतोरिन केयतोग़, ओसो तना संगे मनवालोर सीपय्कनग्डाहि ओर्वोग़ देवुळतुन मोळ्कवाल सीपयिन केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","केयिसि ओरिन सबे पोल्‍लोङ वेहचि, यापा नाटे पत्रुन ततलाह लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","इमा दिया ओर यापा नाग़ एरे-एरे एव्स मतोर, अस्के पियलि पत्रु पार्तना कीयलाहि लोता पोग़ोन वेसळतगा तग़्ङतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","अस्के ओन्क बातालाय दोर्कतेक तिनेननाय इनाह, पका कग़्व वसिस मता. अद लोतोर गाटो अटसोर मतोर, अचोटेन ओग़ इद्रम देवुळ तोहतनद लेकातुन ऊळतोग़ इतेके, ");
INSERT INTO mrr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","पोग़ोटा बूमि पग़्क विरियिस, अग्डाहि बेरा गेंदेता लेह्‌का, तानाङ नालुङ कोङिन बातालो पोस नेल रेहतलाह आता. ");
INSERT INTO mrr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","अद गेंदेतगा, इद बूमतगा मनदनव तिनदलाह पोलनव, पोलवव, सबे जातिनाङ नालुङ काल्कनाङ जन्वर्क, कोरियनाङ-बेङनाङ जन्वर्क, ओसो पिटेङ वने मताङ. ");
INSERT INTO mrr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","अस्के पत्रुह्‌क उंद आल्का इद्रम केंज वाता, “अले पत्रु, इविस्किन हव्किस तिन,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","मति पत्रु, “आयो सामि, मोसानाङ अडोङ वेहतपु पोल्वविन, कळ्‍वोग़ कीयनविन, बेस्केन नना तिनोन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","इतस्के दुस्रा मल्काता आल्का इद्रम केंज वाता इतेके, “नना देवुळतन पोलनाह कीतविन, निमा पोलोङ इनजोर इनमा,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","इद्रम मूंड मल्काङ आता, अस्के अद गेंदेतुन बातालो चट्‌नेन पोग़ोन ओता. ");
INSERT INTO mrr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","पया देवुळि नाक बेद्रमता लेका तोहता इन्जि, पत्रु पकाय एक्बेक आतोग़. अस्केने कुरनेलि लोहतोर मन्कलोर, तोलाना कबळ केवाल सिमोनना लोन बेगा मन्ह्‌ता इनजोर, पर्ह्‌कसोर-पर्ह्‌कसोर ओना लोता रेसातगा वासि नितोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","निचि “इगा बोग़ाय सिमोन पत्रु इनवाल मन्कल मन्ह्‌तोग़ा?” इनजोर आळो कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","अदे तूकने पत्रु देवुळ तोहतद लेकातुन विचर कीयलाह आस मतोग़; अस्केन देवुळता जीवा ओन वेहता, “पत्रु इके केंजा, मुवुर मन्कलोर नीक पर्ह्‌कसोर वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","निमा तेदिस इळ्न रेगा, रेगिसि उन्क-मन्क आयवालेवा ओरा संगे अनु. ननाय ओरिन लोहतन,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","अस्के पत्रु इळ्न रेगिसि ओरगा अतोग़, अन्जि (ओरिन जोहर कीसि), “मीट बोग़ पत्रुन पर्ह्‌कलाह आतिर, ओग़ ननाय आंदन. अले वेहाट, बाताल कबळतुह्‌क वातिर?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","पया ओर इतोर, “मावा माल्काल कुरनेलि इनवाल नूर सीपय्कना दरोगाल मन्ह्‌तोग़. ओग़ मीवा देवुळता पोल्‍लोतुन केंजिसि, तान्क रेयिसि ताकिह्‌तोग़. सबेटोर यहुदिर ओन्क पका कदर ईस्तोर. ओनगा उंद दिया देवुळता देवतुल वासि, ‘सिमोन इनवाल पत्रुनगा कबुर लोहचि, ओन नीवा लोन केया. केयिसि ओग़ वेहतनाङ सबे पोल्‍लोन बेस केंजा’ इता,” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","पया पत्रु ओरिन लोप्पा ओसि, ओरिह्‌क मनदलाह जागा कीतोग़. पया इमा दिया पत्रु ओसो यापा नाटेनोर उय्तुर विस्वसिर, कुरनेलि लोहतोरा संगे अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","वेर दुस्रा दिया केसरिया सहरतगा एवतोर, अस्के कुरनेलि जीवातोरिन, गोततोरिन तना लोतगा जमा कीसि, पत्रु वायनदिन अग़ ऊळसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","पया पत्रु ओना लोन एवतस्के, कुरनेलि ओन कलियिसि, ओनाङ काल्क मोळ्किसि जोहर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","अस्के पत्रु ओन तेहचि “निमा इद्रम केमा, नना वने नीवा लेह्‌का मन्कनने,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","पया ओर वळ्ह्‌कसोर-वळ्ह्‌कसोर लोप्पा नेङतोर, नेङतस्के पत्रु अगा वेल्‍लाटोर जमा आतदिन ऊळतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ऊळिसि ओरिन इतोग़, “यहुदि लोकुरिह्‌कु, मीट दुस्राङ जातिनोरगा दायनदु, मीवा संगे गोत आयनदु, पोलो इनजोर मीट पुतिरे. मति बोग़े मन्कन विटळ इनजोर इनदना आयो इन्जि, देवुळि नाक तोहता. ");
INSERT INTO mrr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","अदिनेनाह्‌के मीट नाक केय लोहतिर अस्के, पेग़्के-मुनेह बाताले विचर केवालेवा नना वातन. मति बाराह्‌क केयतिरो, अले वेहाट?” इनजोर पत्रु ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","अस्के कुरनेलि इतोग़, “मूंड दियाङ मुने, बह्‌ट अर्स मतस्के, नावा लोतगा पार्तना कीसोर मतन. अस्के ऊळा, तिर्मिळ्स्कना जगा केग़तोग़ ओर्वोग़ मन्कल, नावा मुनेह वास नितोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","निचि इद्रम इतोग़, ‘ए कुरनेलि, निमा पार्तना कीयनदिन देवुळ केंजता, लेवोरिह्‌क दर्मम कीयनदिन ऊळता. ");
INSERT INTO mrr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","अदिनेनाह्‌क यापा नाटेनगा कबुर लोहचि, सिमोन पत्रु पेदिरतोग़ मन्कन नियगा केया. ओग़ु दुस्रोग़ सिमोन इनवाल तोलाना कबळ केवाना लोतगा मन्ह्‌तोग़, अद लोन सम्दुरकचुल मन्ह्‌ता,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","अदिनेनाह्‌क नना तोप्नेन नियेके कबुर लोहतन. निमा एवतिन अदिह्‌क पकाय बेस कीतिन. इंजेके देवुळि नीक वेहतव सबे पोल्‍लोन केंजलाहि, माट देवुळता मुनेह जमा आतोम,” इनजोर कुरनेलि इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","अस्के पत्रु इद्रम वेहता बोटटोग़ इतेके, “देवुळि बेस्केन मन्कना मोकम ऊळिसि एरे केवो, ");
INSERT INTO mrr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","मति बेदाय जाततोग़ मतेक तेला, तान्क रेयिसि, सेतेमते ताकवाल मन्कल, देवुळतुह्‌क विचर वास्तोग़ इनजोरे, इंजेके नाक बेस तेळियता. ");
INSERT INTO mrr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","(देवुळि आचतोग़) येसु किर्स्तु, पापि मन्कलोरिन देवुळता संगे कलियिह कीतोग़ (ओग़े येसु कतमतोरा माल्काल). इदे बेसता कबुरतुन देवुळि तना इस्रयेल लोकुरिह्‌क लोहता, इदिन मीट पुतिर. ");
INSERT INTO mrr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","एते मीहवाल योहन इस्रयेल लोकुरिन तमा पापमता अग़दाहि मल्सि, देवुळता पेदिरते एग़ मीयलाहि पोकुर कींदोग़. ताना पया यहुदिरा बूमते बाताल बाताल आता, अदिन मीट पुतिरे. इतेके देवुळि नासरेत नाटेनोग़ येसुन निल्पिह कीसि, ओना तोळ मन्जि, तना पवित्र जीवाते, तना लावते ओन निहता. ओग़ गालिल पटटाहि सुरु कीसि, सबेटोर इस्रयेल मन्कलोरेनाह्‌क, बेसताङ कबस्क कीसोरे, देयह्‌कना मुक्यानाकय इळ्न मतोरग्डाहि, देयह्‌किन पूंडसोरे तिरियतोग़. इद पोल्‍लोतुन वने मीट पुतिरे. ");
INSERT INTO mrr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","मावा यहुदिर मनदनद देसेमतगा, अहे येरुसलेम सहरतगा, येसु कीतव सबे कबस्किन माटु ओनाङ बळयिरोम मावाङ कोंडाने ऊळतोम. पया ओन मराता गुटातगा मोल्‍लाङ कोटिस हव्कतोर. ");
INSERT INTO mrr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","मति मूंड दियाने देवुळि ओन जीवा अर्हचि, लोकुरा मुनेह दिसिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","येसु दिसनेके सबेटोर लोकुरिह्‌क दिसोग़ मति, सिरप माके दिसतोग़. इतेके ओग़ जीवा अरतापया, ओना संगे कलियिस तितोम-उटोम. बाराह्‌क इतेके इद पोल्‍लोता साक्सि मनदलाहि, देवुळि मुनेन माक आचिस मता. ");
INSERT INTO mrr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","अद्रमे हातोरा-पिसतोरा नेयम कीयलाहि, देवुळि येसुने निल्पिह कीता इनजोर, साक्सि ईसोर पोकुर कीयलाहि, येसु माक उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","येसुना मोकतेनाह्‌कु, येसुन विस्वस कीतोर कतमतोरा पापमतुन देवुळि मापि कीस्ता इन्जि, मुनेतोर देवुळताङ सबेटोर कबुरतोरा सास्त्रम वेहतह्‌ता,” इनजोर पत्रु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रु इव पोल्‍लोङ वेहतह्‌पा, ओनाङ पोल्‍लोन केंजवालोर सबेटोरा पोग़ोन पवित्र जीवा रेगता. ");
INSERT INTO mrr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","रेगतस्के कुरनेलिना लोतगा मनवालोर, तमा मुर्तिय पुनवव बासाने वळ्ह्‌कलाह, ओसो देवुळि बेरा डीसाता इनजोर जोहर कीयलाह आतोर. पत्रुना संगे यापा नाटेनाहि वास मतोर यहुदि विस्वसिर इव सबे ऊळतोर, केंजतोर. केंजिसि, डायना रिवज केवोर दुस्राङ जातिनोरा पोग़ोन वने, पवित्र जीवा रेगिह्‌ता इन्जि, ऊळिस बामतोर. पया पत्रु तना तोळतोरिन इतोग़, ");
INSERT INTO mrr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“इंजेके वेर वने मावा लेह्‌का पवित्र जीवाते निंदतोर. अदिह्‌क वेरिन येसुना पेदिरते एग़ मीमाकिर इनजोर, बोग़ाय रोमिह कीया पग़यनोग़ा?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","पया ओर पूना विस्वसिरिन, “येसु किर्स्तुना पेदिरते एग़ मीयिर,” इनजोर वेहतोग़. एग़ मीतापया कुरनेलिना लोतोर पत्रुन “रेंड दियाङ रोमिस दाकिन,” इनजोर इतोर, इताह्‌कु ओग़ तना तोळतोरा संगे, अगान उचुक दियाङ रोमतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","अद्रमे पया, यहुदि आयवोर वने देवुळता पोल्‍लोतुन विस्वस कीतोर इन्जि, येसुनाङ बळयिर ओसो पूरा यहुदा पटटा विस्वसिर केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","पत्रु केसरिया सहरताहि येरुसलेम अतस्के, उय्तुर यहुदि विस्वसिर ओना संगे, पोल्‍लोने उचुन गिटोगटो आसि. ");
INSERT INTO mrr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","देवुळ माक ईतव अडोन वेग़ माळोग़ इन्जि, “निमा डायना रिवज केवोरगा अन्ज मतिन, ओसो ओरा संगे तिनदना-उनडना वने कीतिन अय?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","अस्के पत्रु मुनेताहि सुरु कीसि, मारनाहि बाताल बाताल आता, अदिन ओरिह्‌क तेळियिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","कीसि ओग़ इद्रम इतोग़, “नना यापा नाटे मतन अस्के, उंद दिया पार्तना कीसोर मतन. अस्के नना इद्रम देवुळ तोहतनद लेकातुन ऊळतन इतेके, बेरा गेंदेता लेह्‌का बातालो मता. बोग़ो तानाङ नालुङ कोङिन पोसि, पोग़ोटा बूमतग्डाहि दोम्ह्‌क्ने नावा मुनेह रेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","अस्के तान नना बेस ऊळतन, ऊळतस्के अगा नाटेनाङ जन्वर्क, गेळाताङ जन्वर्क, बूमतगा कोरियनाङ-बेङनाङ जन्वर्क, ओसो पिटेङ इंका मताङ. ");
INSERT INTO mrr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अस्के उंद आल्का इद्रम नाक केंज वाता इतेके, ‘अले पत्रु तेदा, इविस्किन हव्किस तिन,’ इता. ");
INSERT INTO mrr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मति नना इतन, ‘आयो सामि, मोसानाङ अडोङ वेहतपु पोल्वविन, कळ्‍वोग़ कीयनविन, बेस्केन तिनोन,’ इतन. ");
INSERT INTO mrr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","इतस्के दुस्रा मल्का पोग़ोटाहि ओसो आल्का केंज वाता इतेके, ‘देवुळि पोलनाह कीतविन, निमा पोलोङ इनजोर इनमा,’ इता. ");
INSERT INTO mrr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","इद्रम मूंड मल्काङ आता अस्के, अद गेंदेतुन बातालो चट्‌ने पोग़ोन ओता. ");
INSERT INTO mrr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“अस्केने मुवुर मन्कलोर माट मतद लोतगा वासि नितोर. ओरिन केसरिया सहरतग्डाहि नयगा लोहच मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","पया देवुळता जीवा नाक इता, ‘ओर यहुदिर आयोर इन्जि, उन्क-मन्क आयवा, ओरा संगे अन,’ इनजोर इता. पया नावा संगे वेर आग़वुर यापा नाटेनोर विस्वसिर वने, केसरिया सहरते वातोर. पया माट कुरनेलिना लोन अतोम. ");
INSERT INTO mrr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","अतस्के कुरनेलि इतोग़, ‘उंद देवतुलि नावा लोतगा वासि, नाक इद्रम वेहता इतेके, “यापा नाटे कबुर लोहचि, सिमोन पत्रु पेदिरतोग़ मन्कन मियगा केया. ");
INSERT INTO mrr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ओग़ वासि मीक देवुळता पोल्‍लोतुन वेहतनोग़, अद पोल्‍लोते देवुळि नीकु, नीवा लोते मनवालोर सबेटोरिन पिसिह कीयग़ा,” इनजोर वेहता,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","अद्रमे पया नना वेहता बोटटन अस्के, देवुळता पवित्र जीवा मुने मावा पोग़ोन बेद्रम रेगता, अद्रमे ओरा पोग़ोन वने रेगता. ");
INSERT INTO mrr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","रेगतस्के, येसु इतद इद पोल्‍लो नाक सीता वाता, ‘देवुळता पेदिरते मीहवाल योहन लोकुरिन एते मीहन्दोग़. मति देवुळि मीकु पवित्र जीवाते मीहतग़ा,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","माट किर्स्तु येसुसामिन विस्वस कीतस्के, बेद्रम देवुळि पवित्र जीवातुन मावा पोग़ोन उदिह कीता, अद्रमे ओरा पोग़ोन वने उदिह कीता. कीताह्‌कु इंजेक नना बोनन आंदन, देवुळतुन रोमिह केवानन?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","पया पत्रुना संगे गिटोगटो आसोर मतोर मन्कलोर, इद पोल्‍लोतुन केंजिसि, केमेन आतोर. आसि ओर इतोर, “पापमता अग़दाहि मल्सि, तना पिसमुळ दोर्किह कीयलाहि, यहुदि आयवोरिह्‌क इंका, देवुळि अग़ ईता,” इनजोर देवुळतुन जोहर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","इद्रम आनेके इस्तिपनिन हव्कतापया, विस्वसिरिन तिपल कीतस्के, बिरोबटो आतोरु, उय्तुर पिनिके पटटे, उय्तुर कुपरुस देसेम, उय्तुर सुरिया पटटा अंताकिया सहर एवनाह वितिस, बिरोबटो आतोर. ओर येसु किर्स्तुना पोल्‍लोतुन, यहुदिरिन विळ्सिस बोरिह्‌के वेहोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","मति ओरा संगे उय्तुर कुपरुस देसेमतोर विस्वसिर मतोर, उय्तुर कुरेने सहरतोर मतोर, ओर अंताकिया सहरते वासि, यहुदि आयवोरिह्‌क वने येसुसामिना बेसता कबुरतुन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","देवुळता लाव बेसता कबुरतुन वेहवालोरगा मता. अदिह्‌क वेल्‍लाटोर यहुदि आयवोर, येसुसामिन विस्वस कीसि, येसुना अग़दे ताकलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","पया इद पोल्‍लो येरुसलेमता विस्वसिरा मुडुह्‌क एर्का आता, आतस्के ओर बार्नबसिन अंताकिया सहरते लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","बार्नबस अगा एवतोग़ अस्के, देवुळि अग्डोर विस्वसिरिह्‌क बेद्रम देय्वा ईता इनजोर, ओग़ ऊळिसि, पका गिर्दा आतोग़. ओग़ इतेके सेतेमतोग़ मन्कल, पका विस्वस केवाल, ओसो देवुळता जीवाते निंदिस मनवाल. “मीवा पूरा जीवाताहि येसुन विळ्सवालेवा निच मन्ह्‌टु” इन्जि, ओर विस्वसिरिन वेहतोग़. पया बार्नबस अगा मनदह्‌पा, वेल्‍लाटोर येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","पया बार्नबस सोलुन पर्ह्‌कलाहि, तरसुस सहरते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","अस्के ओन अगा दोर्किह कीसि, (येसुना सेवाते तना तोळ आयलाह,) ओन अंताकिया सहरते ततोग़. पया वर्सामेंड ओर इर्वुर, विस्वसिरा मुडा संगे मन्जि, वेल्‍लाटोरिन येसुना पोल्‍लोतुन काग़्हन्दुर. अस्के मुने-मुने अंताकिया सहरतगान, विस्वसिरिन किर्स्तुनोर इन्जि, लोकुर पेदिर तासतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","अवे दियाने देवुळता कबुरतोर उय्तुर, येरुसलेमताहि अंताकिया सहरते वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ओरग्डाहि अगबुस इनवाल मन्कल मतोग़.(उंद दिया विस्वसिर जमा आतस्के,) ओग़ तेदिसि “रोम राजाल ताकिह कीयनव सबे देसेह्‌कनगा, पका दुकळ अरयग़ा” इनजोर, ओग़ देवुळता जीवाता बुदते वेहतलाह आतोग़. (पया अद दुकळ कलोदियुस इनवाल रोम राजगादेतगा उदतस्के आता.) ");
INSERT INTO mrr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","इदिन केंजिसि, अंताकिया सहरतोर विस्वसिर, वग़ोग़-वग़ोग़ मन्कल बेचोक कोताङ ईया पग़यह्‌तोग़, अचोक अर्हचि, यहुदा पटटोर विस्वसिरिह्‌क लोहतकल इनजोर, विचर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","पया अद्रमे कोताङ अर्हचि, अव कोतानु बार्नबसना, सोलुना कयदे ईसि, येरुसलेम मतोर विस्वसिराङ पेदल्कनगा लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","अद वेलाते येरुसलेमतगा बाताल आता इतेके, एरोद अग्रिपा राजालविस्वसिरा मुडग्डाहि, उय्तुरिन तिपल कीयलाहि, ओरिन पोयतलाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","वेग़ राजाल येसुना बळयि योहनना दादाल याकुबिन, तल्वर कसेग़ते हव्कनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","इदिन ऊळिस, येसुन मोळ्कवोर यहुदिर पकाय गिर्दा आतोर. ओर गिर्दा आतदिन राजाल ऊळिसि, पत्रुन वने पोयतलाह वेहतोग़. (इद पोल्‍लो आवना पंडुमतस्केडा आंदु, तान ओय्‍पिह केवद पिंडटाङ आरिङ तिनदनद पंडुम वने इंदुर.) ");
INSERT INTO mrr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","पत्रुन पोसि, आवना पंडुम मारतापया, वेल्‍लाटोर लोकुरा मुनेह नेयम कीयना विचरतेनाह्‌क, ओन जेल वाट वेहतोर. वेहचि, ओना पह्‌रातुह्‌क, नालुङ तुंगानोर सीपय्किन पह्‌रा तासतोर. उंद-उंद तुंगातगा नाल्वुर-नाल्वुर सीपय्क मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","इद्रमलेह्‌का पत्रुन उचुक दियाङ जेलते तासतोर, अस्के विस्वसिरा मुलु ओनेनाह्‌क, अमेसा रोमवालेवा, देवुळतुन पार्तना कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","(पया पंडुम मारिस इमा दिया,) एरोद राजाल पत्रुन जेलताहि पेसिह कीसि, लोकुरा मुनेह नेयम कीयना मता. अद नग़्का, पत्रुन नडुम कीसि, पत्रुनाङ कय्किन तमाङ कय्कना संगे इके-अके रेंड गोल्स्कने दोहचि, इर्वुर सीपय्क उंजिस मतोर. ओसो जेलता अग़दगा, उय्तुर सीपय्क वने ओना पह्‌रातुह्‌क मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","अस्के बाताल आता इतेके, दोम्ह्‌क्नेन देवुळता देवतुलि पत्रुन दोहच मतद अरातगा वासि निता. नितस्के अद अरातगा वेह्‌च आता. अस्के अद बाताल कीता इतेके, पत्रुना मेंदुदुन मेल्हचि, “अले पत्रु चट्पिट तेदा!” इनजोर इता. इतस्के पया, (सीपय्क तेदवाय,) पत्रुन दोहच मतव गोल्स्क ओनाङ कय्कनाहि तमतमाय कुसताङ. ");
INSERT INTO mrr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","अस्के देवतुलि, “नळ्ह्‌कोटुह्‌क पटा दोहा, एल्पुस्क केग़्म” इता, इतस्के ओग़ अद्रमे कीतोग़. ओसो “पोग़ोटा जगा केग़्स, नावा पयाह पयाह वाय,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","इतस्के ओग़ ताना पयाह पयाह अनजोर, जेलताहि पेसतोग़. देवतुल कीयनद निटमे इनजोर, ओन्क मुर्तिय एर्का इले आसि. “देवुळता देवतुल बाताल कीयलाह आता, इद सबे निटम आयो मति, नना कला कळ्स्किह्‌नन बहे,” इंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ओर इर्वुर अह आस पेसिस अनेके, मुनेह उंद जागातगा पह्‌रातोर मतोर, ओरिन वीळतोर. ओसो इबर दुस्रा अग़दगा उच्वुर पह्‌रातोर मतोर, ओरिन वने वीळतोर. (मति पह्‌रातोरिह्‌क इतेक, ओर इर्वुर दिसोर.) अद्रमे जेलता कच-तेल्पता अग़दगा एवतोर, अद अग़ि सहरतेके पेसिंदु, अद वने तेल्पि ओरेनाह्‌क तनतनाय पङळ्क आता. पया ओर पेसिस उचुन अबर अनेके, देवतुलि पत्रुन विळ्सिस बेकेयो मायता. ");
INSERT INTO mrr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","पया “हां इद सबे निटमे इन्जि, इंजेक कोन नना पुतन, देवुळि तना उंद देवतुलतुन लोहचि, एरोद अग्रिपाना कयदाहि नाक विळ्सिह कीता.(नाक राजाल हव्कलाह ऊळिस मतोग़,) अद्रमे यहुदिरा आसा वने मता. मति अद्रम आयवाह, देवुळ नाक पिसिह कीता,” इनजोर पत्रु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","इद्रम एर्का आतापया, पत्रु बाताल कीतोग़ इतेके, मार्कल इनवाल योहनना तलोग़ मरियाना लोन अतोग़. अगा वेल्‍लाटोरे विस्वसिर जमा आसि, पत्रुनेनाह्‌क पार्तना कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","पत्रु अगा अतोग़ अस्के, अग़ केहतद मता. अग़दगा निचि, (“बेह अतिर दादा?” इन्जि,) तेल्पतुन कोह्‌कतोग़. कोह्‌कतस्के रूदे पेदिरता उंद ओर्युल पिला वित वाता. ");
INSERT INTO mrr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","अद पिला पत्रुना लेङतुन पुनदलाह पुता, मति अग़दुन तेग़यवाय, पका गिर्दाते लोप्पा वितता. वितिसि “अग़दगा पत्रु वास नितोग़,” इन्जि वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","मति ओर (ताना पोल्‍लोतुन विस्वस केवालेवा,) तान “निमा कोन पिसाङ आतिन रि?” इंदुर. मति अदु “आयो! पत्रुये आंदोग़” इनजोर इंदु. पया ओरु, “अह इतेके अद पत्रुन राका कीयनद देवतुल मनदग़ा,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","मति पत्रु इतेके अग़दगा निचि, तेल्पतुन कोह्‌कसोरेन मतोग़. अस्के ओर मन्कलोर वासि, अग़दुन तेग़यिस ऊळतोर अस्के, (अगा निटमे पत्रुय मतोग़). पया ओन ऊळिस वेर बामतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","अस्के पत्रु, केमेन मन्ह्‌टु इनदलाह कय अहतोग़. अह कीसि, देवुळि नाक बह कीस जेलताहि पलत पेसिह कीता इनजोर, अव सबे पोल्‍लोन ओरिह्‌क वेहतोग़. वेहचि, “याकुबिह्‌क ओसो दुस्रोर विस्वसिरिह्‌क इव पोल्‍लोन वेहचीम्ह्‌टु,” इनजोर वेहचि, अग्डाहि दुस्रा नाटे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","पया सकर पंङवियतस्के, जेलतगा पत्रुह्‌क बाताल आता इनजोर, पह्‌रातोर पकाय एक्बेक आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","अस्के एरोद अग्रिपाल पत्रुन पर्ह्‌कलाह, सीपय्किन वेहतोग़. मति ओग़ दोर्कोग़. दोर्कवाह्‌कु, पह्‌रा कीसोर मतोर सीपय्किन राजाल ताल्ह्‌क वेहचि, (“पत्रुन वितलाह ईतिर अय,” इनजोर,) ओरिन हव्कलाह वेहतोग़. पया राजाल यहुदा एरियाताहि, केसरिया सहरते अन्जि मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ताना पया इद्रम आता इतेके, एरोद अग्रिपाल सोर-सिदोन सहर्कनोर मन्कलोरा पोग़ोन, पका ओङ आस मतोग़. अदिनेनाह्‌कु ओर जमा आसि, राजान कलियलाहि केसरियाते अतोर. बाराह्‌क इतेके, ओरा एरियाता अनम राजाना देसेमताहि वांदु.(ओग़ राजाल माक कलियलाह एवोग़ आयनोग़ इन्जि,) ओर बलास्तुस इनवाल राजाना लोतुन ऊळवाल ओर्वोग़ अदिकरतोनगा अतोर. माक राजाना संगे कलियलाह ओम इनजोर, ओग़ अदिकरतोन गूनम कीसि, (पया ओना संगे राजानगा अतोर). ");
INSERT INTO mrr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","अस्के “पलाना दिया मीवा संगे कलियकन” इनजोर, एरोद राजाल वेहच मतोग़. पया अद दिया एरोद राजाल तना सोबाता राजमलयळि केग़्सि, नेयम कीयनद कुर्सतगा उदतोग़. उदिसि जमा आस मतोर लोकुरिन, पोल्‍लोङ वेहता बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","अस्के ओग़ वेहतदिन केंजिसि मन्कलोर, “इद कोनि मन्कना आल्का आयो, मति उंद देवुळता आंदु,” इनजोर केयसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","मति, राजाल (“आयो, नना मन्कनने,” इन्जि वेहोग़,) देवुळतुह्‌क मान एवोग़. एवाह्‌कु देवुळता देवतुल ओनगा पीळा लोहता. अदिनेनाह्‌क ओग़ बेमर आसि, पोटालोप्पा पुळ्क अर्सि डोलतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","इद्रम आनेके देवुळता पोल्‍लो आङसोर अता, वेल्‍लाटोर मन्कलोर येसुन विस्वस कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","पया बार्नबस, सोलु, वेरु (यहुदा पटटोर विस्वसिरिह्‌क दुकळतेनाह्‌क दान ईतव कोताङ तचीतद) तमा सेवा मारिह कीतोर. कीसि योहन-मार्कन पोसि, येरुसलेमताहि अंताकिया सहरते मलतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","सुरिया पटटा अंताकिया सहरतोरविस्वसिरा मुडगा, उय्तुर देवुळता कबुरतोर, ताना पोल्‍लोतुन काग़्हवालोर मंदुर. ओर बोर आंदुर इतेके, बार्नबस, सिमियोन (ओन निगर इतेके कार्यल मन्कल वने इंदुर), कुरेने सहरतोग़ लुकियुस,एरोद अंतिपस राजाना संगे उड्लग्डाह ऐंगेन बेर्सतोग़ ओग़ मनाहेम, ओसो सोलु. ");
INSERT INTO mrr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","उंद दिया ओर देवुळतुन मोळ्कसोरे, उपस-पार्तना कीसोर मतोर. अस्के देवुळता जीवा ओरिन इद्रम वेहता इतेके, “नना बार्नबसिन, सोलुन बेद कबळतेनाह्‌क आचतन, अद कबळतेनाह्‌क ओरिन मियग्डाह निल्पिह कीम्ह्‌टु,” इता. ");
INSERT INTO mrr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","इतस्के ओर उपस कीसि, तमाङ कय्किन वेर इर्वुरा पोग़ोन तासिसि,पार्तना कीतोर. कीसि देवुळता कबळतेनाह्‌क ओरिन लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","पया देवुळता जीवा ओरिन ओसीतस्के, इर्वुर आसि अंताकियाताहि सम्दुरकचुदा सिलुकिया इनदनद नाग़ अतोर, अन्जि अग्डाहि ओडातगा उदिसि, कुपरुस देसेमते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","अन्जि अग्डा सलमिस इनदना सहरते एवतोर. पया यहुदिरापार्तनाताङ लोह्‌कनगा अन्जि, देवुळता पोल्‍लोतुन पोकुर कीतोर. अस्के योहन-मार्कल वने ओरिह्‌क तोळ ईंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","अद्रमे पया कुपरुस देसेमता उंद दुस्रा बाजेतके अन्जि, पापुस इनदनद सहरतगा एवतोर. अगा ओर्वोग़ पूजर-गूनिङ केवाल, बार-येसु पेदिरतोग़ यहुदि मन्कल ओरिह्‌क कलियतोग़. (बार-येसुनु इलिमाल वने इंदुर, युनानि पोल्‍लोते बार-येसुना पेदिर इलिमाल मता.) ओग़ु “नना देवुळता कबुरतोनन” इन्जि, लोकुरिन नाळेह कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","अद देसेमतगा सिरगियु-पोलु पेदिरतोग़ पका तेल्वतोग़ गुमसि मतोग़; ओनाय संगे वेग़ इलिमाल वने मंदोग़. ओग़ गुमसि, देवुळता पोल्‍लोतुन केंजकन इनजोर, बार्नबसिन, सोलुन तनगा केयतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","मति ओग़ गूनयाल बाताल कीतोग़ इतेके, बार्नबस, सोलु, वेर इर्वुरा अडम आसि, वेग़ गुमसि येसुन विस्वस कीयनायो इनजोर, ओन रोमिह कीसोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","अस्के सोलु (ओन पोलु वने इंदुर), देवुळता पवित्र जीवाते निंदिसि, इलिमान कोंडा मिळ्हवा ऊळिस, इद्रम तेर्हतोग़, ");
INSERT INTO mrr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ए सत्रल मन्कनिन, पका नाळेमता कबळते निंदतद देयमतिन, निमा सेतेमता अडम मह्‌निन. बह निमा देवुळता सेतेमता पोल्‍लोतुन मिळ्हतनदिन विळ्सविना? ");
INSERT INTO mrr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","इद ऊळा, देवुळ तना लावते नीक इंजेके सिक्सा ईयना मन्ह्‌ता, निमा गळ्किह्‌क तोवविन आयकिन. पोळ्‍द दींचनद वने नीक दिसो आयग़ा,” इतोग़. पोलु इद्रम इताहे, इलिमानाङ कोंडाह्‌क गंगा पोसि, ईकळ आयलाह आता, ओनाङ कोंडाह्‌क मुर्तिय दिसो. दिसवाह्‌क बोग़ाय नावा कयदुन पोस ओयनोग़ इनजोर, इके-अके पर्ह्‌कसोर तिरियिंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","पया इलिमाह्‌क अद्रम आतदिन गुमसि ऊळिसि, येसुन विस्वस कीतोग़, कीसि बार्नबस, पोलु, वेर येसुना पोल्‍लोतुन काग़्हतदिन केंजिसि बामतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पया पोलु तना तोळतोरा संगे पापुस सहरताहि ओडाते उदिसि, पंपूलिया पटटा पिरगा इनदनद सहरते अतोर. (अगा एवनाह, योहन-मार्कल ओरा संगे मतोग़.) मति पिरगा सहरते एवतस्के, ओग़ ओरिन विळ्सिसि, येरुसलेमते मल्स अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पया पोलु, बार्नबस, पिरगा सहरताहि पिसिदिया एरियाता उंद सहरते एवतोर; अद सहरता पेदिर वने अंताकिया आंदु. वारमता पोल्वादियाते, देवुळता पार्तनाता लोतगा अन्जि, अग्डोरा संगे मोळ्कलाह उदतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","अगा बोरो मोसानाङ अडोना सास्त्रमताहि, ओसो देवुळता कबुरतोरा सास्त्रमताहि अर्वतोर. अर्वतापया पार्तनाता लोतुन ताकिह केवालोर मन्कलोर, “दादालोरिर, इगा जमा आतोरेनाह्‌कु, बातालाय पोल्‍लो काग़्हतना मतेके काग़्हचीम्ह्‌टु,” इनजोर पोलुन, बार्नबसिन ताल्ह्‌कलाहि लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","अस्के पोलु तेदिसि, जमा आतोर मन्कलोरिन, केमेन मन्ह्‌टु इनजोर, कय तेहतोग़. पया इद्रम इतोग़, “मावोर इस्रयेलतोर यहुदिरिर, ओसो यहुदिरा देवुळतुन मोळ्कवालोर दुस्राङ जातिनोरिर, केंजाटु. ");
INSERT INTO mrr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","माटु इस्रयेल मन्कलोरल मोळ्कनद देवुळि, मावा पेदामुय्तोरिन आचता. ओर मिसर देसेमतगा, दुस्रोरा कय इळ्न मनदह्‌पा, ओरा बेरा उंदि तेग़मुल कीता. कीसि तना बेरा लावते, ओरिन मिसर देसेमताहि पेसिह कीस तता. ");
INSERT INTO mrr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","मावाङ तादोर-बाबोर देवुळता पोल्‍लोतुन केंजोर आंदुर, तेला मति जोक-जोक रेंड वीसाङ वर्साङ पेळ्ह्‌कल बूमतगा ओरिन अय कीता. ");
INSERT INTO mrr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","पया कनान देसेमते मतोर एळुङ जातिनोरिन देवुळि बूळे कीसि, ओरा बूमतुनु इद इंजेके मीवा बूमि इनजोर, मावा लोकुरिह्‌क ईता.(मावा पेदामुय्तोर मिसर देसेमते जागा आतग्डाह, मावा लोकुरिह्‌क तमा) बूमि दोर्कनाह्‌जोम, जोक-जोक नालुङ नूह्‌क पनस (450) वर्साङ आताङ. “ताना पया देवुळि ओरिन ताकिह कीयलाहि, तग्वाङ केवालोरिन निल्पिह कीता. आक्रितोग़ तग्वाङ केवाल सामुवेल पेर्माल आंदोग़, ओग़ देवुळता कबुरतोग़ वने आंदोग़. ओना वेला एवनाह, तग्वाङ केवालोर ओरिन ताकिह कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","सामुवेलना वेलातस्के, माक इंजेक राजाल गावले इनजोर, मावाङ तादोर-बाबोर देवुळतुन ताल्ह्‌कतोर. अदिह्‌क देवुळि, बिन्यमिनना कूळतोग़ कीस पेदिरतोना मग़ि सोलुनु, ओरेनाह्‌क निल्पिह कीसीता. ओग़ रेंड वीसाङ वर्साङ राजेम ताकिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","“पया देवुळि सोलुनग्डाहि राजेम गुंजिसि, दाविदिह्‌क ईता. देवुळि दाविदना लोप्पा बेस-नेह्‌ना वेहता, ‘यीसाना मग़ि दाविद नाक विचर वातोन नना ऊळतन. नना बाताल बाताल वेहतकन, ओग़ अव सबे कबस्क कीयनोग़,’ इन्जि वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“अद्रमे वेल्‍लाङे वर्साना पया, देवुळि (मावाङ तादोर-बाबोरिह्‌क मुनेन) पोल्‍लो विळ्सतपु, दाविदिनाये सटमते पुट वातोग़ मन्कल येसुनु, इस्रयेल मन्कलोरिन पिसिह केवाल इनजोर लोहता. ");
INSERT INTO mrr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","येसु तना कबळ सुरु केवाय, एते मीहवाल योहन सबेटोर इस्रयेल मन्कलोरिन, पापमता अग़दाहि मल्सि देवुळता पेदिरते एग़ मीम्ह्‌टु इनजोर, पोकुर कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","योहन तना कबळतुन मारिह कीयनद वेला एवयह्‌पा, मन्कलोरिन इद्रम इंदोग़, ‘नना बोनन इन्जि मीट विचर कीतिर? (मीट बोन केपतिर,) ओग़ नना आयोन, ओग़ पया वायनोग़. नना ओना कादुन इटलाह वने ओप्पोन,’ इंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“मावोर इस्रयेलतोरिर, अब्रहम मुय्तोना पुळ्गतोरिर, यहुदिरा देवुळतुन मोळ्कवालोरिर, येसुसामि लोकुरिन पिसिह कीयनद कबुरतुनु, मयगाने देवुळि लोहचीता. ");
INSERT INTO mrr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","येरुसलेमते मनवालोर यहुदिर, ओसो ओरा मुक्यालोर, येसुये पिसिह केवाल इनजोर पुनोर आस मतोर. वारम-वारमता पोल्वादियाते, देवुळता कबुरतोरा सास्त्रमतुन अर्विंदुर, मति तान ओर पुनोर. पुनवालेवा येसुन हव्कनाह कीसि, अदे सास्त्रम करल आता. ");
INSERT INTO mrr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","येसुन हव्कना सिक्सा ईयना इद्रम, ओना पोग़ोन बातय कसुर दोर्किह कीया पग़वोर. मति पिलाति इनवाल गुमसिनगा अन्जि, वेन हव्कनागुटातगा वेळ्हा इनजोर, अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","अस्के वेल्‍लाय मुनेन, मन्कलोर देवुळ लोहवाल पिसिह केवान इद्रम इद्रम कीयनुर इनजोर, देवुळता कबुरतोर रासिस मतोर, अव सबे पोल्‍लोङ करल आताङ. अस्के पया हव्कनागुटाताहि येसुना सेत्तातुन रेहचि, गुमयातगा मिसतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","मति देवुळि ओन हामुरताहि तेग़्किह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","येसु हामुरताहि तेग़्कतापया, ओना संगे गालिल पटटाहि येरुसलेम सहरते अन्ज मतोरिह्‌क, वेल्‍लाङे दियाङ दिससोर मतोग़. इंजेके ओरे मन्कलोर मावा यहुदि लोकुरा मुनेह, येसुना साक्सितोर मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","देवुळि मावाङ तादोर-बाबोरा संगे वेल्‍लाय मुनेन करल कीस मता. अदे करलता बेसता कबुरतुन इंजेके, माट वने मीकु वेहतलाह आतोम. ");
INSERT INTO mrr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","इद्रमे देवुळि येसुन जीवा अरयनाह कीसि, मावाङ तादोर-बाबोरा संगे मुनेन विळ्सतद पोल्‍लोतुन, मयेनाह्‌क इंजेके निटम आनाहि कीता. इदु, देवुळताङ पाटाना पुस्तकता पाटा 2तगा इद्रम रासतद मन्ह्‌ता इतेके, निमा नावा मग़निन, नेंडे नना नीवा तपेनन आतन इनजोर रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","डोलिस मतोग़ किर्स्तुन, देवुळि जीवा अर्हचीता; ताना पया ओग़ बेस्केन डोलोग़. इद पोल्‍लोतुन देवुळि मावाङ तादोर-बाबोरिन मुनेन वेहच मता. (देवुळि ओरिन वेहतद पोल्‍लो इद्रम रासतद मन्ह्‌ता) इतेके, ‘(नना मीक बर्कत ईकन इन्जि,)दाविदिन करल कीस मतन; अद करल सेतेम मन्ह्‌ता, मियेनाह्‌क मन्ह्‌ता,’ इनजोर वेहता. ");
INSERT INTO mrr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","अदिह्‌क देवुळताङ पाटाना पुस्तकतग्डा ओसो उंद पाटाते, दाविद राजाल देवुळतुन इद्रम इतोग़, ‘नीवा पवित्र सेवकिना सेत्तातुन, कळिय एविन आयकिन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","(पवित्र सेवकनन इनजोर, दाविद तन्क इनोग़ इन्जि माट पुतल. बाराह्‌क इतेके,) दाविद तना वेलाते, देवुळि ओन्क ईतद कबळतुन, मारिह कीसि डोलतोग़. डोलतस्के ओनाङ तादोर-बाबोराङ सेत्तानु बेगा मिसतोर, अगान ओना सेत्तातुन वने मिसतोर, अस्के ओना सेत्ता कळियता. ");
INSERT INTO mrr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","मति देवुळि जीवा अर्हचीतोग़ येसुना सेत्ता कळियो. ");
INSERT INTO mrr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“अदिह्‌क मावोरिर, इद पोल्‍लोतुन पुन्ज मन्ह्‌टु. इद्रम देवुळि येसुना मेटे, मीवा पापमतुन मापि कीयग़ा इन्जि, माट मीकु वेहतलाह आतोम. ");
INSERT INTO mrr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","मोसानाङ अडोङ माळतेके, मीकु पापमताहि मापि दोर्को आयग़ा. मति सबेटोर येसुन विस्वस केवालोरिह्‌के, तमा पापमताहि मापि दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","देवुळता कबुरतोर मुनेन (ताना पोल्‍लोतुन केंजवोरिह्‌क) इद्रम रासतोर इतेके, देवुळ इन्ह्‌ता, ‘इद ऊळाट, नावा पोल्‍लोतुन पास्कवालोरिर, नावा नेयमतस्के मीट बामिस डोलकिर, बाराह्‌क इतेके, मीवा वेलाते नना इद्रमता कबळ कीकन इतेके, बोग़ाय वासि मीकु तेळियिह कीतेके, नना इद्रम कीकन इन्जि, मीट मुर्तिय विस्वस केविर आयकिर,’ इनजोर देवुळि वेहता, इन्जि रासतद मन्ह्‌ता. ओर रासतद सिक्साता लेह्‌का मीक आयमाकि इन्जि, पुन्ज मन्ह्‌टु,” इनजोर वेहचि पोलु रोमतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पया पोलु, बार्नबस पार्तनाता लोताहि पेसिस वातस्के, “इव पोल्‍लोङ वायना वारमता पोल्वादिया वने माक वेहाटु,” इनजोर अगा जमा आस मतोर, ओरिन अर्जि कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","मोळ्कनग्डाह लेङतस्के, वेल्‍लाटोर यहुदिर, ओसो यहुदि दर्मते ओळियतोर दुस्राङ जातिनोरु, पोलुना, बार्नबसिना पयाह पयाह अतोर. अतस्के वेर इर्वुर ओरा संगे गोटिङ कीसोर, ओरिन “देवुळि मीकु ईयनद दयातुन नमसोर मन्ह्‌टु,” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","पया दुस्रा वारमता पोल्वादियाते देवुळताङ पोल्‍लोङ केंजलाहि, पार्तनाता लोतगा, जोक-जोक पूरा नाटेनोर इतपे, जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","मति वेल्‍ला मुडुन ऊळिसि, यहुदि मुक्यालोरा जीवा कर्वता. कर्वतस्के, पोलुन पास्किस, ओग़ इतव पोल्‍लोना विरुद वळ्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","मति पोलु, बार्नबस मुर्तिय रेयवालेवा इतोर, “मावोरिर, मीक यहुदिरिह्‌के, देवुळता पोल्‍लोतुन मुने वेहतना मता. मति मीट कोनि तान पास्किसि, अमेसाता पिसमुळतुन दोर्किह कीयना लेह्‌काडोर आयविर इन्जि तोहतिर. अदिह्‌क इंजेके माट इगा यहुदि आयवोरगा दाय्ह्‌नोम. ");
INSERT INTO mrr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","देवुळि माक इद्रम उकुम ईता इतेके, ‘नना लोकुरिन बेद्रम पिसिह कीय्ह्‌नन इनजोर, निमा दुनियामेटोरिन वेहतकिन इन्जि, नना नीक दुस्राङ जातिनोरेनाह्‌क, वेह्‌च तोहवानिन आयकिन इनजोर निल्पिह कीतन’ इनजोर उकुम ईता,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","इदिन केंजिसि, अग्डोर यहुदि आयवोर पका गिर्दा आसि, देवुळता कबुर बेसता इनजोर इंदुर. अमेसाता पिसमुळतुन दोर्किह कीयिर इनजोर, बय्तुरिन देवुळि मुनेन आचिस मता, अय्तुर येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","अद्रमे पया लोकुर येसुना पोल्‍लोतुन, पिसिदिया एरियाताङ वेल्‍लाङे नाह्‌कनगा पोकुर कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","मति सहरतगा, यहुदिरा देवुळतुन मोळ्कनव मोदुल आस्क मताङ. अविनु ओसो सहरतोर पेदल्किनु, यहुदिर ओङ तग़्हचीतोर. तग़्हचीतस्के सबेटोर कलियिसि, पोलुन, बार्नबसिन तिपल कीसि तमा एरियाताहि ओरिन पूंडटोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","अस्के (मीट देवुळता सिक्सातुह्‌क ओजिह्‌निर इदिन तोहतलाहि,) पोलु, बार्नबस, तमाङ काल्कनगा तुंडिस मतद दुरातुन, ओरा मुनेह दुल्पतोर; दुल्पिसि इकुनियुम इनदनद सहरते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","मति पिसिदिया एरियाता अंताकिया सहरतोर विस्वसिर, देवुळता पवित्र जीवाते निंदिसि, दिनम बेस गिर्दाते मंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनियुम सहरतगा इद्रम आता इतेके, पोलु, बार्नबस, मुनेता लेह्‌का यहुदिरा पार्तनाता लोन अतोर. अगा वेल्‍लाटोरा जीवातगा गडनाह, येसुना बेसता कबुरतुन वेहतोर. अदिह्‌क यहुदिर ओसो दुस्राङ जातिनोर वेल्‍लाटोरे लोकुर, येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","मति येसुन विस्वस केवोर यहुदिर बाताल कीतोर इतेके, विस्वसिरिन जग्ळम कीयलाहि, यहुदि आयवोरगा अन्जि, ओरिन ओङ तग़्हचीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","अस्के पोलु, बार्नबस, वेर इर्वुर बळयिर वेल्‍लाङे दियाङ अगान मतोर. येसुसामिना पोग़ोन विस्वस कीसि रेयवालेवा, ओना दयाता पोल्‍लोतुन पोकुर कीसोर मतोर. पोकुर कीनेके, येसु ओरा कयदे तना लावताङ वेल्‍लाङे बामिह कीयनाङ सीनाङ तोहचि, ओर वेहतनाङ पोल्‍लोङ सेतेमे इनजोर तोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","मति सहरतोर लोकुर रेंड तुंगाङ आसि, उय्तुर बार बळयिरक्‍के आतोर, उय्तुर बार यहुदिरक्‍के आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","पया यहुदि आयवोर ओसो उय्तुर यहुदिर, तमा मुक्यालोरा संगे कलियिसि, पोलुना, बार्नबसिना कदर रेहचि, बंडाङ उकिस हव्कलाह तयर आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","इद पोल्‍लो पोलुह्‌क, बार्नबसिह्‌कु, एर्का आता. अदिनेनाह्‌क ओर इकुनियुमताहि पेसिस, गलाति पटटा लुकावनिया जिलाते विततोर. अद जिलाता लुस्त्रा सहरते, दिरबे सहरते, ओसो एरे-गूरेताङ नाह्‌कनगा अन्जि, बेसता कबुरतुन पोकुर कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","अद्रमे लुस्त्रा सहरतगा ओर्वोग़ काल्क वावोग़ पुटकूटाल मतोग़, ओग़ पुटटग्डाहि बेस्केन ताकवाय मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","उंद दिया पोलु वेहतनाङ पोल्‍लोङ, ओग़ कूटाल उदिसि बेस केंजलाह आस मतोग़. अस्के पोलु ओन कोंडा मिळ्हवा ऊळतोग़, ऊळिसि वेग़ कूटाल सव्रेम आयलाह, येसुन विस्वस कीस्तोग़ इन्जि पुतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अदिनेनाह्‌क जोरते इतोग़, “अले कूटा, तेदिस दिग निल्म!” इतोग़. इतस्के ओग़ कूटाल डेह्‌किस ताक बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","लोकुर पोलु कीतदिन ऊळिसि, तमा लुकावनिया पोल्‍लोते, “पेन्के मन्कल मारियिस, मावा नडुम वाताङ रा!” इनजोर जोरते केयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","पया बार्नबसिन तमा मोदुल पेन जेयुस आंदोग़ इनजोर इंदुर, पोलु पका वळ्ह्‌किंदोग़, अदिह्‌क ओन तमाङ पेन्कना कबुर वेहवाल इरमेस आंदोग़ इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","जेयुस पेनता मंदिर सहरता पलते मता. अद मंदिरतगा मोळ्कवाल बूमयाल बाताल कीतोग़ इतेके, सहरतगा नेङनद अग़दगा, कोंदाङ ओसो नूदे काचताङ पुंगेह्‌किन तचि, सहरता लोकुरा संगे कलियिसि, बळयिरिह्‌क मोक ईयलाह तयर कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ओर इद्रम कीस्तोर इनजोर बार्नबस, पोलु केंजतोर, केंजतस्के पकाय नारज आसि, तमाङ जगान अग़्हचि, लोकुरा नडुम वितिसि इद्रम इतोर, ");
INSERT INTO mrr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ए लुस्त्रा सहरतोरिर, मीट इद्रम बह कीय्ह्‌निर? अद्रम केमाटु! माटु बेवे पेन्कनोम आयोम, माट वने मीवाय लेह्‌कान मन्कलोरोमे. मीट इव अङ्ळमताङ पोल्‍लोन विळ्सिसि, जीवात मनदनद देवुळतके मलयना इन्जि, मीक बेसता कबुर वेहतह्‌नोम. अदे देवुळि पोग़ोटा बूमतुन, इळ्ता बूमतुन, सम्दुरतुन, ओसो अविस्कनगा मनदनव सबेटविन पुटिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","देवुळि मुने, मीट यहुदि आयवोर दुस्राङ जातिनोरिह्‌क, विचर वातविन मोळ्कलाह ईस मता. ");
INSERT INTO mrr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ईसाय मति, नना सेतेम देवुळतन आंदन इनजोर, देवुळि अमेसा तनाङ बेसताङ कबस्कने, लोकुरिह्‌क तोहचीता. मीकु पोग़ोटाहि पेग़ु अर्हचीता, अद्रमे बराबर कगोते अनम पुटिह कीसि, तिनदलाह गाटो ईसि, मीकु गिर्दाते तासता,” इनजोर वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","अचोन वेहतोर तेला मति, लोकुर ओरेनाह्‌क मोकिङ ईयलाह वातोरे. मति पोलु, बार्नबस, पकाय मुस्किलते ओरिन रोमिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","(उचुक दियाना पया) पिसिदियाता अंताकिया सहरताहि उय्तुर यहुदिर, इकुनियुम सहरताहि उय्तुर यहुदिर, लुस्त्रा सहरते वातोर. वासि लुस्त्रातोर मन्कलोरगा कलियिसि, ओरिन तमा बाजेतेके कीतोर. कीसि पोलुना विरुद आसि, ओन बंडाङ उकतोर. उकतस्के वेग़ इंजेके डोलतोग़ इन्जि, ओन सहरता पलते ईळ्सिस ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पया लुस्त्रातोर पूनोर विस्वसिर, ओनगा वासि सर्ने नितोर. अस्के पोलु तेदिसि, ओरा संगे सहरतगा अतोग़. पया इमा दिया बार्नबस बार, दिरबे सहरते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","पया पोलु, बार्नबस, वेर दिरबे सहरतोर लोकुरिह्‌क, येसुना बेसता कबुरतुन वेहतोर. वेरा पोल्‍लोतुन केंजिस, वेल्‍लाटोर येसुन विस्वस कीतोर. ताना पया वेर दिरबे सहरताहि लुस्त्रा सहरते मलतोर, अग्डाहि पया इकुनियुम सहरते वातोर, इकुनियुमताहि पिसिदिया एरियाता अंताकिया सहरते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","(ओर बेद-बेद सहरते मलतोर,) अग्डोर विस्वसिरिन “बेचोन तिपल वातेक तेला, येसुन विळ्सवा विस्वसते मन्ह्‌टु. देवुळदीपता राजेमते दायनामुने, माकु ऊक-ऊके विरुदतुन आप पोयग़ाये” इनजोर, पका विस्वस कीयलाह वेहचि, ओरिह्‌क दीरा ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ओसो अव मूंड सहर्कनगा, अग्डा विस्वसिरा मुडुन ताकिह कीयलाहि, मुक्यालोरिन निल्पिह कीतोर. उपस-पार्तना कीसि, विस्वसिर बोन नमिस मतोर, ओग़े येसुसामिना कयदे, सबेटोर विस्वसिरिन विळ्सिस ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","पया पिसिदिया एरियाताहि पंपूलिया पटटे अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","अन्जि अग्डा पिरगा सहरतगा येसुना पोल्‍लोतुन वेहचि, सम्दुरकचुल मतद अतलिया सहरते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अग्डाहि ओडातगा उदिसि, सुरिया पटटा अंताकिया सहरते मल्स वातोर. अद सहरता विस्वसि लोकुर, पोलुन, बार्नबसिन, देवुळता कबुरतुन पोकुर कीयलाह, देवुळता देय्वा ओरगा मनि इनजोर, पार्तना कीसि लोहच मतोर. अदे कबळतुन मारिह कीस, ओर इर्वुर मल्स वास मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","वातस्के विस्वसिरा मुडुन जमा कीतोर. जमा कीसि, देवुळि ओरा कयदे कीतव बेराङ-बेराङ कबस्किन वेहतोर. ओसो यहुदि आयवोरेनाह्‌क वने, येसुन विस्वस कीयलाहि, देवुळि बेद्रम अग़दुन तेग़यिस ईता, इन्जि वने वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","अद्रमे पया पोलु, बार्नबस, विस्वसिरा संगे वेल्‍लाङे दियाङ अगान मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","अद्रमे पया उंद दिया, उय्तुर यहुदि विस्वसिर, यहुदा पटटाहि(सुरिया पटटकेडा अंताकिया सहरते) वासि, अग्डोर विस्वसिरिन कलियतोर. कलियिसि “मीट मोसानाङ अडोङ वेहतपु डायना रिवज केवेके, देवुळ मीकु पिसिह केवो आयग़ा,” इनजोर काग़्हता बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","इदिन केंजिसि पोलु, बार्नबस, वेर अद्रम काग़्हवालोरा संगे पका जग्ळम आतपे, पोल्‍लोने गिटोगटो आतोर. पया अंताकियातोर विस्वसिर बाताल इतोर, “पोलु, बार्नबस ओसो उय्तुर विस्वसिर येरुसलेम अन्जि, बळयिरिन ओसो विस्वसिराङ पेदल्किन इद पोल्‍लोतुन देहतलाहि, ताल्ह्‌किस वायिर,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ताना पया अंताकियातोर विस्वसिरा मुलु ओरिन येरुसलेम लोहतोर. लोहतस्के पोलु ओना तोळतोर बार, पिनिके ओसो सामरिया पटिह्‌क अनेके, यहुदि आयवोर बेद्रम देवुळतके वातोर, अदिन अग्डोर विस्वसिरिह्‌क पूरा वेहचोर अतोर. तान केंजिसि सबेटोर विस्वसिर पका गिर्दा आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","अद्रमे पया येरुसलेम एवतोर, एवतस्के विस्वसिरा मुलु, बळयिर, विस्वसिराङ पेदल्कु, ओरिन गिर्दाते कलियतोर. कलियतस्के पोलु, बार्नबस, तमा कयदे यहुदि आयवोरगा, देवुळि बाताल बाताल कबळ कीता इनजोर, कतम पोल्‍लोन ओरिह्‌क वेहचीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","मति परुसिरा तुंगातग्डाहि, येसुन विस्वस कीतोर अगा मतोर. ओर तेदिस इद्रम इतोर, “यहुदि आयवोरिन डायना रिवज कीया वेहचि, ओरिन मोसानाङ अडोने ताकलाह, उकुम ईयना गावले,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","इतस्के बळयिर, विस्वसिराङ पेदल्कु, इद पोल्‍लोतुन विचर कीयलाह, जमा आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","अस्के वेल्‍लाय जोम, पोल्‍लोने ईनाह-आनाह गिटोगटो आतोर. पया पत्रु तेदिसि इद्रम इतोग़, “मावोरिर वेल्‍लाङे दियाङ मुने, देवुळि नावा तोडटे यहुदि आयवोर बेसता कबुरतुन केंजिसि, येसुन विस्वस कीयिर इनजोर, मयग्डाहि नाक आचता, इदिन मीट पुतिरे. ");
INSERT INTO mrr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","सबेटोर लोकुरा पोटालोप्पाडाङ पोल्‍लोन पुनदनद देवुळि, माट यहुदि विस्वसिरा पोग़ोन तना पवित्र जीवातुन बेद्रम उदिह कीता, अद्रमे ओर यहुदि आयवोरा पोग़ोन वने तना पवित्र जीवातुन उदिह कीसि, ओरिन वने आचता इनजोर तोहता. ");
INSERT INTO mrr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ओर विस्वस कीतोर, देवुळि ओरा पापमतुन मापि कीस ईता. अह कीसि माट यहुदिर आयि, दुस्राङ जातिनोर आयि, सबेटोर विस्वसिरिन देवुळि उंदिय रीतते पिसिह कीता इनजोर तोहता. ");
INSERT INTO mrr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","इचोन तोहचाय मति, मीट इंजेके मोसानाङ अडोने ताकाट इनजोर वेहचि, ओरा पोग़ोन पूहतद मोतातुन वाटलाह, बाराह्‌क देवुळता पट ऊळिह्‌निर? मावाङ तादोर-बाबोर ओसो माट वने, मोसानाङ पूरा अडोने ताक पग़वल. ");
INSERT INTO mrr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","बेद्रमलेह्‌का येसुसामि यहुदि आयवोरिह्‌क ईतद दयातेनाह्‌के, ओर ओन नमिस पिसिह्‌तोर, अद्रमलेह्‌काने माट यहुदिरल वने पिसिह्‌नल; (मति अडोङ नोमताह्‌कु पिसवल,)” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","पत्रु इद्रम इतापया, पोलु, बार्नबस वने, तमा कयदे यहुदि आयवोरगा देवुळि बेव-बेव बामनव सीनाङ तोहता, इनजोर वेहतोर. वेहतह्‌पा, सबेटोर केमेन आसि ओरा पोल्‍लो केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","पोलु, बार्नबस, वेहतनद मारिह कीतोर अस्के, अग्डा मुक्याल याकुब इद्रम इतोग़, “मावोरिर, नावा पोल्‍लो केंजाटु. ");
INSERT INTO mrr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","देवुळि यहुदि आयवोरिन मुने सीता कीसि, ओरग्डाहि उय्तुर मन्कलोरिन तना मन्कलोर आयलाह आचता. अदु बेद्रम ओरिन सीता कीता, इनजोर सिमोन पत्रु इंजेके माक तेळियिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","इद पोल्‍लोतुन देवुळता कबुरतोर वने वेल्‍लाय मुने वेहच मतोर, अद इद्रम रासतद मन्ह्‌ता, ");
INSERT INTO mrr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","देवुळि इद्रम वेहता, ‘दाविदनाराजेम बूळेम आतेक तेला, नना पया वासि तान ओसो निल्पिह कीकन, पिळ्हपळ आतदिन पूना पंडकन. ");
INSERT INTO mrr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","अह आसि दुस्राङ वेल्‍लाङे जातिनोर नाक पर्ह्‌कनुर, इतेके नयेनाह्‌क नना आचतोरु यहुदि आयवोरु,’ इनजोर देवुळि वेहता. इदिन वेल्‍लाय मुनेताहि तना मन्कलोरिन पुन्पिह कीसोर वाता, इनजोर रासिस मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","अदिह्‌क नना बह इह्‌नन इतेके, यहुदि आयवोरग्डाहि, देवुळतगा वावालोरिन माट तिपल केवल. ");
INSERT INTO mrr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","मति ओरगा इद्रम रासिस लोहतकल, ‘पेन्किह्‌क वाटटव कळ्‍वोग़ आस्ताङ, अविस्किन तिनदनद आयो; साट्याल कबस्क कीयनद आयो; नेतुर पोववालेवा हव्कतविनाङ अविङ तिनदनद आयो, अस्कतापया नेतुरतुन एच तिनदनद आयो,’ इनजोर रासकल. ");
INSERT INTO mrr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","बाराह्‌क इतेके वेल्‍लाय मुनेताहि सबे सहर्कनगा, देवुळताङ पार्तनाताङ लोह्‌कनगा, वारमता पोल्वादियाते मोसानाङ अडोन अर्विसि पोकुर कीस्तोर;(अद्रमे मावा यहुदि विस्वसिर माळिह्‌तोर वने. अदिह्‌क इंजेक वेहतनव पोल्‍लोन यहुदि आयवोर विस्वसिर केंजिसि ताकिर, आयवेक अचोन यहुदिरिह्‌क ओङ वायग़ा,)” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","पया बळयिर, विस्वसिराङ पेदल्कु, येरुसलेमतोर विस्वसिरा पूरा मुलु, बाताल इतोर इतेके, “इंजेके याकुब इतव पोल्‍लोन रासिसि, मयग्डोर विस्वसिरा कयदे अंताकिया सहरते लोहतकल. ओरु पोलुना, बार्नबसिना संगे दायनुर,” इतोर. पया यहुदा बार्सबा इनवान आचतोर, ओसो सीलास इनवान वने आचतोर. वेर इर्वुर आसि विस्वसिरगा पेदा मन्कलोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","वेरा कयदे विस्वसिरिह्‌क सीटि लोहतोर, अद सीटटगा इद्रम रासिस मता. “अंताकिया सहरतगा, सुरिया पटटगा, किलिकिया पटटगा मनवालोर यहुदि आयवोर विस्वसिरिह्‌क: “माट मीवा ऐंगेटोर विस्वसिरोम, इतेके येसुसामिनाङ बळयिरोम, ओसो विस्वसिराङ पेदल्कनोम, सीटि रासलाह आतोम, मयेनाह मीक जोहर. ");
INSERT INTO mrr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","मयग्डोर उय्तुर विस्वसिर मियगा वासि, बाताङ-बाताङो वेहचि, मीक लेसिह कीतप कीतोर, मीक पका तिपल ईतोर इनजोर, माट केंजतोम. मति माट इतेके ओरिन लोहोम आसि. ");
INSERT INTO mrr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","अदिह्‌क माट सबेटोरोम कलियिसि, इर्वुर मन्कलोरिन आचिसि, मियगा कबुर लोहतकल इनजोर, विचर कीतोम. ओर आचतोरु, (यहुदाल ओसो सीलास,) मावा गोततोर बार्नबसना, पोलुना संगे मियगा वास्तोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","वेर बार्नबस, पोलु इतेके, तमा जीवातुन सीता केवा, मावा किर्स्तु येसुसामिना सेवा कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","माट रासतदिन यहुदाल ओसो सीलास, वेर मीकु वेहतनुर. ");
INSERT INTO mrr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","अव पोल्‍लोन मीट केंजिसि ताकाटु. अविस्किन विळ्सिस दुस्रा मोतातुन, मीवा पोग़ोन वाटोम इनजोर,देवुळता पवित्र जीवा ओसो माटु कलियिस विचर कीतोम. अव पोल्‍लोङ इद्रम मन्ह्‌ताङ. ");
INSERT INTO mrr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“पेन्किह्‌क वाटटव अविङ तिनमाटु, अस्कतापया नेतुरतुन एच तिनमाटु, नेतुर पोववालेवा हव्कतविनाङ अविङ तिनमाटु, साट्याल कबस्क केमाटु. मीट इव पोल्‍लोन बेस पोस ताकतेक अचोन, बेस-नेह्‌ना मनदकिर. अचोने, मारता,” इनजोर रासतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","अद्रमे पया यहुदाल, सीलास, पोलु, बार्नबस, वेर अंताकिया सहरते अतोर, अन्जि सबेटोर विस्वसिरिन जमा कीसि, सीटटुन ओरा कयदे ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ईतस्के तान विस्वसिर अर्विसि, इद सीटटा पोल्‍लोतुन केंजिस कोनि, मावा जीवा सुकम आता इनजोर, पका गिर्दा आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहुदाल, सीलासि देवुळता कबुरतोर मताह्‌कु, ओर वने विस्वसिरिन वेल्‍लाङे पोल्‍लोङ वेहतोर. वेहचि ओरा जीवातुह्‌क दीरा ईसि, ओरा विस्वसतुन बेर्सिह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","अद्रमे पया ओर इर्वुर अगान उचुक दियाङ मतोर. पया अग्डोर विस्वसिर ओरिन बेस अन्ह्‌टु इन्जि, येरुसलेमतके मल्स दायलाह लोहतोर. अस्के ओर इर्वुर मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","मति पोलु, बार्नबस, वेर उचुक दियाङ अंताकिया सहरते मतोर. मन्जि दुस्रोर वेल्‍लाटोरा संगे, येसुसामिना पोल्‍लोतुन काग़्हचोरे ओसो पोकुर कीसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","अद्रमे पया उंद दिया पोलु बार्नबसिन इतोग़, “माट येसुसामिना पोल्‍लोतुन, बेव-बेव सहर्कना लोकुरिह्‌क वेहतल, अव सबे सहर्कनगा अन्जि, ओर सबेटोर विस्वसते बेद्रम मन्ह्‌तोर इन्जि ऊळकल अय?” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","इतस्के बार्नबस केंजतोग़, केंजिसि “इंगो मति, योहन-मार्कन वने मावा संगे ओयकल,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","मति पोलु, बार्नबस, वेर येसुना सेवातुन मारिह कीयनाह्‌जोम, मार्कल ओरा संगे मनोग़. पंपूलिया पटटाहि ओरिन विळ्सिस वास मतोग़. अदिह्‌क “आयो, ओन ओयवल!” इनजोर पोलु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","अदिनेनाह्‌क पोलु, बार्नबस, पका जग्ळम आतप लेह्‌का, पोल्‍लोने गिटोगटो आसि एग़तोर. पया बार्नबस मार्कन पोसि, ओडाते उदिसि, तना देसेम इतेके कुपरुस देसेमते ओतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ओसो पोलु बार, तना संगे दायलाह, सीलासिन आचतोग़. पया अंताकियातोर विस्वसिर “देवुळता देय्वा मियगा मनि” इनजोर, ओरिन देवुळता कयदे विळ्सिसीतोर, अस्के ओर इर्वुर पेसतोर. ");
INSERT INTO mrr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","पया पोलु, सीलासिना संगे पूरा सुरिया पटटे, किलिकिया पटटे तिरियतोग़. बेद-बेद नाग़ अंदुर, अग्डोर विस्वसिरा मुडा विस्वसतुन मेग़्किह कीसोर अंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पया पोलु, (सीलास, गलाति पटटा) दिरबे ओसो लुस्त्रा, इव सहर्कने अतोर. लुस्त्रा सहरतगा तिमोति पेदिरतोग़ ओर्वोग़ विस्वसि मतोग़, ओना तपे युनानि जाततोग़ु, मति तलोग़ि यहुदि आंचाळ आंदु, अद विस्वस वने कींदु. ");
INSERT INTO mrr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्त्रा, इकुनियुम, इव सहर्कनोर विस्वसिर, तिमोतिन पका बेसतोग़ इनजोर, कदर ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पया पोलु बाताल कीतोग़ इतेके, तिमोतिन तना संगे सेवातुह्‌क ओयलाह विचर कीतोग़. मति तिमोतिना तपे यहुदि आयोग़ इनजोर, अग्डोर वेल्‍लाटोर यहुदिर पुन्ज मतोर. अदिह्‌क (तिमोतिन डायना रिवजकेवेक, ओना पोल्‍लोतुन यहुदिर केंजोर आयनुर इनजोर,) पोलु ओन ओस ओना डायना रिवज कीसीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","अद्रमे पया पोलु, सीलास, तिमोति, वेर मुवुर अग्डाङ सहर्कनाङ विस्वसिरिन कलियसोर, येरुसलेमताङबळयिर ओसो विस्वसिराङ पेदल्क ईतव अडोन ओरिह्‌क ईसोर, अव अडोने ताकलाह वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","अदिह्‌क वेल्‍लाटोर विस्वसिरा विस्वस बेर्सिंदु. दिनम उय्तुर विस्वस कीसोर अंदुर, इद्रमलेह्‌का ओरा मुलु बेर्ससोर अता. ");
INSERT INTO mrr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","पया वेर मुवुर सेवकिर, देवुळता पोल्‍लोतुन पोकुर कीयलाह, आसिया पटटे दायलाह ऊळतोर. मति देवुळता पवित्र जीवा ओरिन अगा दाया एवो. अदिह्‌क ओर अके अनवा, गलाति पटटा पुरुगिया एरियाते अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","पया मूसिया एरियाते एव्सि, बितुन्या पटटे दायलाह विचर कीतोर. मति येसुना जीवा ओरिन अगा दायलाह एवो. ");
INSERT INTO mrr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","अदिह्‌क मूसिया एरियाताहि, सम्दुरकचुल मतद तरोवस सहरतगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ओर अगा मनदह्‌पा, पोलु नग़्का देवुळ तोहतना लेकातुन ऊळतोग़. अद लेकाते मकिदुनिया पटटोग़ ओर्वोग़ मन्कल ओन्क दिसतोग़. ओग़ मन्कल निचि, “इबर दडटेके वासि, मावा मकिदुनिया पटटोर मन्कलोरिन काग़्हा,” इनजोर अर्जि कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","कीतस्के, पोलु अद देवुळ तोहतद लेकातुनु, (सीलासिन, तिमोतिन ओसो नाक वने) वेहतोग़ (अगा नना लूकानन ओरा संगे मतन); वेहतस्के येसुना बेसता कबुरतुन पोकुर कीयलाहि, देवुळि माक मकिदुनिया पटटे लोहतलाह आता इनजोर, उंदिय विचर कीसि चट्पिट अगा दायलाह पेसतोम. ");
INSERT INTO mrr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","पया तरोवस सहरतग्डाहि ओडा उदिसि, सीदा सुमात्राके इनदनद तोग़दगा अतोम. अग्डाह इमा दिया, मकिदुनिया पटटा नियापोलिस इनदनद सहरते एवतोम. ");
INSERT INTO mrr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","पया अग्डाहि ताकसोर अन्जि, पिलिपि सहरते एवतोम. अदु मकिदुनिया पटटा मुनेटा जिलाता सहर मता; अगा रोम सहरतोरेनाह्‌क गूळा कीतद आंदु. अद सहरतगा माट उचुक दियाङ मतोम. ");
INSERT INTO mrr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","पया वारमता पोल्वादियाते, सहरता अग़दा पलते, यहुदिरा देवुळतुन पार्तना कीयनद जागा बेगा मनदग़ा इनजोर, बेरेग़ दडिय अतोम. अन्जि अद जागातुन दोर्किह कीसि, अगा जमा आस मतव आस्कना संगे, येसुसामिना पोल्‍लोतुन वेहतलाह आतोम. ");
INSERT INTO mrr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","अस्के अगा उंद यहुदि आयवदु लुदिया पेदिरता आंचाळ मता. अद आसिया पटटा तुवातिरा इनदनद सहरता आंदु. पका दाराताङ, डुंगा पंडटा रंगलेह्‌काडाङ गेंदेना वीकुर कींदु. अदु यहुदिरा देवुळतुन मोळ्किंदु. पोलु वेहतनव पोल्‍लोन, अद बेस केंजसोर मता. अस्के ओग़ वेहतनव पोल्‍लोन विस्वस कीयनाह, देवुळि तान्क तेळियिह कीसीता. ");
INSERT INTO mrr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","पया अद आंचाळि, ओसो ताना लोते मनवालोरु, येसुना पेदिरते एग़ मीतोर. एग़ मीतापया, अद माक इता, “नाक येसुना सेतेम विस्वसि आंचाळि इनजोर मीट इतेके, मीट सबेटोरिर नावा लोन वास मन्ह्‌टु,” इनजोर इता. माट केंजनाह्‌जोम अद पका गोंडगोंड आता, अस्के माट ताना लोन अतोम. ");
INSERT INTO mrr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","अद्रमे उंद दिया, माट पार्तना कीयनद जागातगा अनजोर मतोम. अस्के उंद ओर्युल मनदनद पिला माक कलियता. तानु पोत ऊळनद देयम पोस मता, अदिह्‌क लोकुर तानगा पोत ऊळलाह वांदुर. इद्रमि तानाङ माल्कालोर ताना मेटे, पका कोताङ कमय कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","अद पिला बेद्रम कींदु इतेके, “वेर सबेट्क बेरा देवुळताङ सेवकिर आंदुर. देवुळ लोकुरिन बेद्रम पिसिह कीस्ता, अदिन मीक पोकुर कीस्तोर” इनजोर, केयसोर-केयसोर मावा पयाह पयाह वांदु. ");
INSERT INTO mrr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","वेल्‍लाङे दियाङ अद अद्रमे कीसोर मता. पया उंद दिया पोलु पका नारज आतोग़. आसि पेग़्के मिळ्न्दिस तानगा मतद देयमतुन इतोग़, “येसु किर्स्तुना पेदिरते नीक उकुम ईय्ह्‌नन, इद पिलाताहि पेसिस अन!” इनजोर, देयमतुन दगाङ ईतोग़. इताहे अद देयम पेसिस अता. ");
INSERT INTO mrr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","अस्के अद पिलातुन तासिस मतोर माल्कालोर, इंजेके माक कमय कीयलाहि अग़ दोर्को इनजोर, बेद्रम कीतोर इतेके, पोलुन, सीलासिन पोसि, बजरतगा गुंजिस ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","पया ओरिन सहरता बेरोर तग्वाङ केवालोरगा ओसि, इद्रम वेहतोर, “वेर यहुदिर मावा सहरतगा पकाय गळ्बळ कीस्तोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","मावा रोमि मन्कलोरिह्‌क पोलवव रीत-रिवज्किन काग़्हतलाह बोटटोर. वेर काग़्हतनव पोल्‍लोन माट नम पग़वल, माळ पग़वल!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","इतस्के अगा जमा आस मतोर लोकुर वने ओरिह्‌क तोळ आसि, इर्वुर सेवकिरा विरुद आतोर. आतस्के तग्वाङ केवालोर पोलुनाङ, सीलासनाङ जगान एग़्हच, डुडिने नल्हतलाह उकुम ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ईतस्के ओरिन पका नल्हतोर, नल्हचि जेलते वाटिसीतोर. पया वेरिन बेस दोहच राका कीमु इनजोर, जेलता दरोगान उकुम ईतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","उकुम ईतस्के ओग़ पोलुन, सीलासिन लोप्पाडा अरातगा ओसि, ओराङ काल्किन पूहतव बलाना संगे दोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","पया नडुमनग़्का पोलु, सीलास, वेरु पार्तना कीसोर देवुळताङ पाटाङ ओसोर मतोर. अस्के अद जेलतगा दोहच मतोर मन्कलोर वने केंजसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","अचोटेन उंदियदेबा बूम गल्जता, गल्जतस्के जेलताङ पाय्वाङ पका जोरते मेलियताङ. अस्के चट्‌नेन जेलताङ तेल्पिनाङ तालह्‌क, तमतमाय कुय्ह वाताङ; ओसो जेलते मतोर मन्कलोरिन दोहच मतव गोल्स्क, ओराङ कय्कनाहि पिह्‌ट अरताङ. ");
INSERT INTO mrr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","अस्के दरोगाल तेदिस ऊळनेके, जेलताङ तेल्पिङ पिङम-पङम आस मताङ! (जेलतगा मतोर मन्कलोर विततोर, इंजेके नाक तग्वाङ केवालोर निटम हव्कनुर, इद्रम आलिह कीसि) दरोगाल तन्के तल्वर कसेग़ते कोटलाह आस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","अस्केन पोलु जोरते केयिसि, “निमा अह केमा, साय्ब! माट सबेटोरोम इगान मह्‌नोम,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","इतस्के दरोगाल चिमलिङ तता वेहचि, लोप्पा अतोग़. अन्जि पका रेयतुह्‌क साङसोरेन पोलुना, सीलासना मुनेह अर्सि, काल्क मोळ्कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","पया ओरिन पलते तचि, “दादालोरिर! देवुळि नाक पिसिह कीयना इन्जि, नना बाताल कीकन?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ताल्ह्‌कतस्के ओर वेहतोर “येसुसामिन विस्वस कीम, अस्के नीकु, नीवा लोतोरिह्‌क, अमेसाता पिसमुळ दोर्कग़ा,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","पया ओर ओन्क ओसो ओना लोतोर सबेटोरिह्‌क, देवुळता पोल्‍लोतुन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","पया नग़्काडा नग़्कान दरोगाल ओरिन ओसि, ओराङ देबान नोग़तोर. नोग़तस्के ओग़ु ओसो ओना लोतोर सबेटोर, येसुना पेदिरते एग़ मीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","पया दरोगाल ओरिन तना लोन ओसि, ओरिह्‌क गाटो ईतोग़. ओग़ तना लोतोरा संगे, देवुळतुन विस्वस कीसि, पका गिर्दा आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","पया इमा दिया तग्वाङ केवालोर “ओर इर्वुरिन विळ्सिस ईम्ह्‌ट” इनजोर, दरोगानगा तमा पोलिसिरा मेटे, कबुर लोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","अस्के जेलता दरोगाल पोलुन वेहतोग़, “तग्वाङ केवालोर मीकु विळ्सिस ईयलाह कबुर लोहतोर, इंजेके गिर्दाते लोन अन्ह्‌टु,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","मति पोलु पोलिसिरिन इतोग़, “माट रोमि मन्कलोरोम मन्ज तेला, मावा तपतुन तोहवालेवा, वेल्‍लाटोरा मुनेह नल्हता वेहचि, जेलते वाटटोर. इद तग्वाङ केवालोर कीतद कबळ मुर्तिय ओप्पो! इंजेक इसि कुस्क्नेन माक विळ्सिस ईस्तोरा? अद्रम आयो! ओर तमाय माक पेहता वायिर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","पया पोलिसिर अन्जि, पोलुना पोल्‍लोतुन तग्वाङ केवालोरिह्‌क वेहतोर. पोलु, सीलास, वेर रोमि मन्कलोर इनजोर पुतापया, तग्वाङ केवालोर पका रेयतोर.(बह इतेके रोमि मन्कलोरिन नल्हतना पोलो आंदु.) ");
INSERT INTO mrr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","अदिह्‌क ओर तमाय वासि, “माक मापि कीम्ह्‌टु” इनजोर इतोर; पया पोलुन, सीलासिन जेलताहि पेहतोर. पेहचि, “मीट इंजेके इद सहरताहि पेसिस अन्ह्‌टु, माट मीवाङ काल्काय मोळ्किह्‌नोम,” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","पया पोलु, सीलास लुदियाना लोन अतोर. अन्जि अगा विस्वसिरिन कलियतोर. येसुसामिन विळ्सवालेवा विस्वस कीसोर मन्ह्‌टु इनजोर, ओरिह्‌क दीरा ईसि, पिलिपि सहरताहि पेसिस अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पोलु, सीलास, वेरु (पिलिपि सहरताहि पेसिस,) अंपिपोलिस ओसो अपुलोनिया इव सहर्किह्‌क अतापया, तिसलुनि सहरते एवतोर. अगा यहुदिरापार्तनाता लोन मता. ");
INSERT INTO mrr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पोलु तना अल्वट मतपु, अद लोन अन्जि, वारमता पोल्वादियाते अगा देवुळता सास्त्रमताङ पोल्‍लोनु, जमा आस मतोरिह्‌क काग़्हतोग़. अद्रमे मूंड वारस्क एवनाह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","देवुळ लोहतोग़ पिसिह केवाल किर्स्तु तिपल आसि डोलनाये मता, डोलिस ओसोवने जीवा अरयना मता इनजोर, देवुळता सास्त्रमतग्डाङ पोल्‍लोन उंद-उंद वचन तोहचि, तेळियिह कीस वेहतोग़. ओसो “बोग़ येसुना लोप्पा मीक वेहतन ओग़े येसु, पिसिह केवाल किर्स्तु आंदोग़,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","अद्रम वेहतस्के उय्तुर यहुदिर, पोलु वेहतद कबुरतुन नमतोर. नमिसि पोलुना, सीलासिना संगे कलियतोर. यहुदिरा देवुळतुन मोळ्कवालोर युनानि जाततोर वेल्‍लाटोर, ओसो बेचोको मोदुल आस्क वने, येसुन विस्वस कीयलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","मति वेल्‍लाटोर लोकुर पोलुना पेग़्के दायलाह आतोर इन्जि, अग्डोर यहुदिरा पका जीवा कर्वता. अस्के अग़-ओङतेन, बजरते वेलियवालोर करब बुदतोर मन्कलोरिन जमा कीसि, पूरा सहरमेंड रोदा पोयतोर. रोदा पोसि पोलु, सीलास, वेर यासोन इनवाना लोतगा मनदनुर बहे इनजोर विचर कीसि, ओरिन लोकुरा पंचता मुनेह ततलाहि, यासोनना लोतुन पिळ्हपळ कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","मति ओरिह्‌क वेर दोर्कोर, दोर्कवाह्‌कु यासोनिन ओसो उय्तुर विस्वसिरिन, सहरतोर मुक्यालोरा मुनेह ईळ्ससोर ततोर. तचि, “वेरु दुनियामेटोरिन लेसिह केवालोर आंदुर, मावा सहरते वने वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ओरिह्‌क वेग़ यासोन तना लोतगा जागा ईतोग़. ओर येसु इनवाल दुस्रोग़ राजाल मन्ह्‌तोग़ इनजोर, कय्सर राजानाङ अडोना अडम वेहतलाह आतोर,” इनजोर रोदा पोयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","अस्के वेरा पोल्‍लोतुन केंजिसि, जमा आतोर लोकुर ओसो सहरताङ मुक्यालोर पकाय ओङ आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","अदिह्‌क सहरतोर मुक्यालोरु, यासोननग्डाह ओसो दुस्रोर विस्वसिरग्डाह, जमानत एचि ओरिन विळ्सिसीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","पया अदे नग़्का विस्वसिर पोलुन, सीलासिन, तिसलुनि सहरताहि बिरिया सहरते लोहतोर. बिरिया सहरते एवतस्के, ओर इर्वुर यहुदिरा पार्तनाता लोतगा अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","बिरिया सहरतोर यहुदिर, तिसलुनि सहरतोर यहुदिरा लेह्‌काडोर कैंगम बुदतोर आयोर. अदिनेनाह्‌क पोलु वेहतद पोल्‍लोतुन, बेस केव वाटिस केंजिदुर. ओसो इव पोल्‍लोङ निटमेया-जोलिया इनजोर, दिनमे पोलु वेहतदिन, सास्त्रमतगा पर्ह्‌किस ऊळिंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","पया वेल्‍लाटोर येसुन विस्वस कीतोर: यहुदिर ओसो युनानिरगा मोदुल आस्कु ओसो कोय्तोर वेल्‍लाटोर, येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पया बिरिया सहरते वने, पोलु देवुळता पोल्‍लोतुन पोकुर कीयलाह आतोग़ इनजोर, तिसलुनितोर यहुदिरिह्‌क केंज वाता. अस्के ओर बिरिया सहरते अतोर, अग्डोर मन्कलोरिन वने, ओङ तग़्हचि कट्ला कीया बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","अदिह्‌क बिरियातोर विस्वसिर बाताल कीतोर इतेके, उय्तुर विस्वसिरा संगे पोलुन ओडाते उदिस दायलाहि, सम्दुरकचुल लोहतोर. मति सीलास, तिमोति, वेर इर्वुर बिरिया सहरतगान मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पोलुन ओसीतोर मन्कलोर, अकाया पटटा एतेंस सहरतगा एवनाह ओतोर. पया ओर अग्डाह बिरिया सहरतके मल्स दायह्‌पा, “सीलास ओसो तिमोति, वेर इर्वुर आसि, चट्पिट एतेंस सहरते नयगा वायिर,” इनजोर पोलु ओरा संगे कबुर लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पोलु एतेंस सहरतगा सीलास, तिमोति, वेरेनाह्‌क केपिस मतोग़. पया अद सहरतगा तिरियनेके, ओग़ बेक ऊळतेकाय ओन्क पेन्कनाङ बोमाङे दिसिंदुङ. अविस्किन ऊळिसि, ओना जीवा चुहेम आयो. ");
INSERT INTO mrr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","अदिह्‌क यहुदिरा पार्तनाता लोन अन्जि, अगा यहुदिर ओसो देवुळतुन मोळ्कवालोर युनानिरा संगे, देवुळता पोल्‍लोतुन वेहतलाह आतोग़. ओसो दिनम बजरतगा अन्जि, ओन्क कलियवालोरा संगे, देवुळता पोल्‍लोतुन वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","अस्के इपिकुरि तुंगाता ओसो इस्तोयिकि तुंगाता गूरुर वने, ओना संगे वेल्‍लाङे पोल्‍लोङ वळ्ह्‌कतोर. ओसो उय्तुर “वेग़ पोमाडेङि बाताङ वेहतलाह आतोग़ रा?” इतोर. येसुना लोप्पा, ओसो ओग़ डोलिस जीवा अरतद बेसतल कबुरतुन वेहतह्‌पा केंजिसि, “वेग़ु, माट पुनवाङ पेन्कनाङ पोल्‍लोन पोकुर कीस्तोग़ बहे,” इनजोर उय्तुर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","अदिह्‌क ओर ओन अरियुपगुस पेदिरता गुड्रातगा ओतोर. अगा एतेंस सहरतोर पंच उदिंदुर. पया पोलुन अगा निल्पिह कीसि, “निमा पोकुर कीयनद पूना पोल्‍लोतुन, माक तेळियिह कीम. ");
INSERT INTO mrr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","माक इचानाह पुनवव पोल्‍लोन वेहता बोटटिन. अदिह्‌क इव पोल्‍लोङ बाताङ आंदुङ इनजोर, अविस्किन पुनदकोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(इंजेके एतेंस सहरतोर, ओसो पलतेनाह अगा वासि पिसवालोर लोकुर, पूनाङ-पूनाङ पोल्‍लोङ वेहतना ओसो केंजना, इदे कबळते अमेसा मंदुर.) ");
INSERT INTO mrr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","अदिनेनाह्‌क पोलु तेदिस अरियुपगुस पंचता मन्कलोरा मुनेह निचि इद्रम इतोग़, “एतेंस सहरतोर लोकुरिर, मीट मीवाङ पेन्किन पका माळवालोरिर इनजोर नना पुह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","इद्रम बाराह्‌क इह्‌नन इतेके, मीवाङ रावुळ्किन ऊळसोर तिरियनेके, उंद गर्यातुन ऊळतन. अगा ‘माट पुनवद पेनतेनाह्‌क’ इनजोर रासिस मता. मीट पुनवालेवा मोळ्किह्‌निर, अदे देवुळता पोल्‍लोतुन नना इंजेके मीक वेहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“इद पूरा बूमि, बूमतगा मनदनव सबेटविन पंडटद देवुळि, पोग़ोटा बूमता, इळ्ता बूमता, माल्काल आंदु. अदिह्‌क अद मन्कलोर पंडटव रावुळ्कनगा मनो. ");
INSERT INTO mrr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","मन्कलोरेनाहि तान्क बातय गावल आयो, बह इतेके देवुळिये सबेटोरिह्‌क पिसमुळ ईस्ता, जीवा ईस्ता, ओसो पिसवग़तुह्‌क सबे ईस्ता. ");
INSERT INTO mrr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ओर्वोग़े मन्कनाहि सबे जातिनोरिन पुटिह कीसि, ओरिन पूरा बूममेंड आनाह कीता. ओसो उंद-उंद जातता लोकुर बेद कालमते इद बूमते मनदनुर, वेरा देसेमता अंद बेगा मनदग़ा इन्जि, मुनेन निल्पिह कीता. ");
INSERT INTO mrr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","लोकुर नाक पर्ह्‌किर, नाक पर्ह्‌कनेके दोर्किह कीया वने पग़यनुर इनजोर, देवुळ इद्रम कीता. तेला मति निटमे अद देवुळि मयग्डाहि जेक इले. ");
INSERT INTO mrr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘बह इतेके अदे माक पिसनाह कीता, जीवात मनाह कीता’ इद्रम इनजोर, मीवाय मन्कलोर वने ‘निटम माट देवुळताङ पिलाङ-पेकोरल’ इनजोर, मीवाय सास्त्रमते रासतद मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","मन्कलोर आपुना विचरते, आपुना बुदते बंगरताङ, वेंडटाङ, बंडानाङ बोमान पंडिह्‌तोर. माट देवुळताङ पेकोरल, अदिनेनाह्‌क देवुळि अव बोमाना लेह्‌काडा इनजोर, विचर कीयना आयो. ");
INSERT INTO mrr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","लोकुर देवुळतुन पुनवालेवा मताह्‌कु, अद कालमतस्के देवुळि ओरा पापमता नेयम केवो. मति इंजेके दुनियामेटोर कतमतोर पापमता अग़दुन विळ्सिसि तानक्‍के वायना इनजोर, उकुम ईता. ");
INSERT INTO mrr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","बाराह्‌क इतेके, बूममेटोरिन ओर्वोग़े मन्कना कयदे, तपवालेवा नेयम कीयग़ा. अद नेयमता दियातुन मुनेन निल्पिह कीसि, ओग़ मन्कन वने मुनेन निल्पिह कीता. ओग़ डोलिस मतोग़ मति, ओन जीवा अर्हचि, ओना नेयम कीयनद अदिकर कतमतोरिह्‌क कीस तोहता,” इनजोर पोलु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","हामुरताहि जीवा अरयना पोल्‍लोतुन केंजतापया, उय्तुर बार ओन कवतोर. ओसो उय्तुर बार “अले बेस्काय इद नीवा पोल्‍लोतुन, माट ओसो केंजकोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","अदिह्‌क पोलु अग्डाहि अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","मति दियनुसियुस पेदिरतोग़ पंच उदवाल मन्कल, दमरि पेदिरता आंचाळि, ओसो उय्तुर बोर-बोरु, पोलुना संगे वासि, येसुन विस्वस कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","पया पोलु एतेंस सहरताहि अकाया पटटा कुरिंत सहरते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","अतस्के अगा ओर्वोग़ अक्‍विला पेदिरतोग़ यहुदि मन्कल कलियतोग़. ओना मुतेना पेदिर पिरिस्किलाल आंदु. ओग़ पुंतुस पटटोग़ आंदोग़. रोम राजेमता कलोदियुस राजाल बाताल कीतोग़ इतेके, ओग़ु सबेटोर यहुदिरिन इतालिया पटटारोम सहरताहि, पेसिस दायलाह उकुम ईस मतोग़. अदिह्‌क ओर आळ इर्वुर इतालिया पटटाहि पेसिसि, कुरिंत सहरतगा वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ओर आळ इर्वुर टमिङ पंडिस वमना दंदा कींदुर. पोलु वने टमिङ पंडिंदोग़, अदिह्‌क ओग़ वने ओरगा मन्जि, अद कबळ कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ओसो वारम-वारमता पोल्वादियाते देवुळता पार्तनाता लोन अंदोग़. अगा यहुदिरिह्‌क, युनानिरिह्‌क, यहुदिरा सास्त्रमतुन अर्विसि, येसुना पोल्‍लोतुन तेळियिह कीस वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","पया सीलासि, तिमोति, मकिदुनिया पटटाहि कुरिंत सहरते वातोर. ओर वातापया, पोलु (तना टमिना कबळतुन विळ्सिस,) देवुळता पोल्‍लोतुन दिनमे पोकुर कींदोग़. सास्त्रम वेहतपु, देवुळि बोग़ पिसिह केवान लोहतना मता, ओग़ येसुये आंदोग़ इनजोर, यहुदिरगा साक्सि वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","मति यहुदिर ओनाङ केंजवा, ओन पास्किस विरुद कींदुर. अदिह्‌क (देवुळि ओङ आता इनजोर तोहतलाहि,) पोलु तना जगातुन सायिसि, “येसुन विस्वस केवेके, देवुळि मीकु सिक्सा ईयग़ा, ताना जबब्दर नना आयोन, मीटे आयकिर! इंजेटाहि नना यहुदि आयवोरिह्‌क वेहतलाह दाय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","इन्जि पया पार्तनाता लोताहि पेसिस, तीतुस युसतुस पेदिरतोना लोन अतोग़. ओग़ यहुदि आयोग़ मति यहुदिरा देवुळतुन मोळ्किंदोग़. ओना लोन पार्तनाता लोता कचुल मता. ");
INSERT INTO mrr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","पया पार्तनाता लोतुन ताकिह केवाल, किरिस्पुस पेदिरतोग़ मुक्याना पूरा लोतोर येसुन विस्वस कीतोर. ओसो कुरिंत सहरतोर वेल्‍लाटोर पोलुना पोल्‍लोतुन केंजिसि, येसुन विस्वस कीतोर, कीसि येसुना पेदिरते एग़ मीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","उंद दिया नग़्का देवुळ तोहतना लेकाते, येसुसामि पोलुह्‌क दिसिस, “नना नीवा तोळ मह्‌नन पोलु. नीक बोरे कय बोयोर आयनुर. इद सहरतगा वेल्‍लाटोरिन नना आचतन. अदिह्‌क केमेन मनमा, रेयवालेवा पोकुर कीसोर अन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","पया डेडा वर्सा आनाहि, पोलु कुरिंत सहरते मन्जि, देवुळता पोल्‍लोतुन वेहचोर मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","पया गलियो पेदिरतोग़ मन्कल अकाया पटटागुमसि आतोग़. अस्के यहुदिर कलियिस पोलुन जग्ळा कीतोर, कीसि ओन नेयम कीयनद जागातगा ओसि, गुमसिन इद्रम वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“वेग़ मन्कल देवुळतुन बेद्रम मोळ्कना इनजोर, मन्कलोरिन काग़्हता बोटटोग़, मति वेग़ वेहतनाङ पोल्‍लोङ काय्दाता अडम मन्ह्‌ताङ,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","पया पोलु वळ्ह्‌कलाह आसोर मतोग़, अस्केन गलियो यहुदिरिन इतोग़, “ए यहुदिरिर! वेग़ मन्कल बेदाय कसुर कीतेके, इलवेके बेद लाग्वा कबळ कीतेक, नना मीवा पोल्‍लोतुन केंजेनन. ");
INSERT INTO mrr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","मति इव सबे मीवाङे अडोनाङ पोल्‍लोङ काग़्हतना, पेदिर्क वेहतना आंदुङ. इदिन मीटे ऊळाट, इद्रमताङ पोल्‍लोन नना नेयम केवोन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","इन्जि ओरिन नेयम कीयनद जागाताहि पूंडटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","पया अगा मतोर युनानिर बाताल कीतोर इतेके, देवुळता पार्तनाता लोता मुक्याल सोस्तिनेस इनवान पोसि, नेयम कीयना जागाता मुनेह नल्हतोर. मति गलियो मुर्तिय पर्वा केवोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","अद्रमे पया पोलु कुरिंत सहरतोर विस्वसिरा संगे, वेल्‍लाङे दियाङ मतोग़. पया दाय्ह्‌नन इनजोर वेहचि, मुने देवुळतुन किरिया कीस मताह्‌कु, किंक्रिया नाटे अन्जि, तला कोग़ियतोग़. पया पोलुना संगे पिरिस्किलालि ओसो अक्‍विलाल वनेसुरिया पटटे दायलाह, ओडातगा उदतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","उदिसि आसिया पटटा इपिसुस सहरते रेगतोर. रेगतापया ओर आळ इर्वुर उंद अग़दे अतोर. पोलु बार देवुळता पार्तनाता लोन अतोग़, अन्जि यहुदिरिह्‌क येसुनाङ पोल्‍लोङ वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","पया ओर ओन रेंड दियाङ मन्जि दायलाह अर्जि कीतोर, मति पोलु केंजोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","“देवुळता विचर मतेके, नना ओसो मियगा वायकन” इनजोर वेहचि, इपिसुस सहरताहि (केसरिया सहरते दायलाह,) ओडातगा उदतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","उदिस यहुदा पटटा केसरिया सहरतगा रेगतोग़. रेगिसि येरुसलेम अन्जि, अग्डोर विस्वसिरा मुडुन कलियतोग़. कलियिस पया, अग्डाहि सुरिया पटटा अंताकिया सहरते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","अगा उचुक दियाङ मन्जि, ओसोवने पेसिस, गलाति पटटा पुरुगिया एरियातोर विस्वसिरिह्‌क दीरा ईसोर तिरियतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","पया उंद दिया ओर्वोग़ मिसर देसेमता सिकंदरिया सहरते पुटटोग़ु, अपुलोस पेदिरतोग़ यहुदि मन्कल, इपिसुस सहरते वातोग़. ओग़ पका कग़यिस मतोग़, ओसो देवुळता सास्त्रमताङ पोल्‍लोन बेस पुन्ज मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","बोग़ो ओन येसुसामिना कबुरतुन काग़्हच मतोग़. अदिह्‌क ओग़ पका जिदते, येसुनाङ पोल्‍लोन चुकवालेवा वेहचोर, काग़्हचोर मतोग़. मति देवुळता पेदिरते एते मीहवाल योहन मुने काग़्हतव पोल्‍लोङ, अचोने ओग़ पुन्ज मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","पया ओग़ इपिसुस सहरतगा देवुळता पार्तनाता लोन अतोग़, अन्जि अगा पका दीराते पोल्‍लोङ वेहन्दोग़. उंद दिया पिरिस्किलालि, अक्‍विलाल, वेरु ओग़ वेहतनाङ पोल्‍लोन केंजतोर. केंजिसि ओन तमा लोन ओसि, देवुळताङ पोल्‍लोन ओसो बेस-नेह्‌ना तेळियिह कीसीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","पया अपुलोस अकाया पटटे दायलाह विचर कीतोग़. विचर कीतस्के, इपिसुसतोर विस्वसिर ओन गिर्दाते अगा लोहतोर. अकायातोर विस्वसिरिह्‌क सीटि रासिस, अपुलोसिन बेस ऊळलाह वेहतोर. पया ओग़ अकायाते अतोग़. अगा अतस्के, देवुळि देय्वा ईताह्‌कु, येसुन विस्वस कीतोर मन्कलोरिह्‌क पका तोळ ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","बेद्रम इतेके, अग्डोर यहुदिरिन येसुये पिसिह केवाल किर्स्तु आंदोग़ इनजोर, देवुळता सास्त्रमतग्डाहि ओरिन बेस-नेह्‌ना तोहतोग़. ओर वळ्ह्‌कवाह, सबेटोरा मुनेह देवुळताङ पोल्‍लोङ वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अद्रमे अपुलोस अकाया पटटा कुरिंत सहरतगा मनदह्‌पा, पोलु गलाति पटटाहि पेसिस वानेके, इपिसुस सहरते एवतोग़. एवतस्के अगा ओन्क उच्वुर विस्वसिर कलियतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","कलियतस्के ओरिन ताल्ह्‌कतोग़, “मीट येसुन विस्वस कीतिर अस्के, मीवा पोग़ोन देवुळता पवित्र जीवा रेगताया?” इतोग़. इतस्के ओर इतोर, “पवित्र जीवा इतेके बातालि, इद पोल्‍लो माट बेस्कन केंजोम!” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","इतस्के पोलु ओसो ताल्ह्‌कतोग़, “पया मीटु बोनाङ कग़यिस एग़ मीयना रिवज कीतिर?” इतोग़. इतस्के ओर इतोर, “एते मीहवाल योहन वेहतपे माट कीतोम,” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","अस्के पोलु ओरिन बेस तेळियिह कीस वेहतोग़: “पापमता अग़दाहि मलतोरिनु, योहन देवुळता पेदिरते एग़ मीहन्दोग़. मति ‘नावा पेग़्के ओर्वोग़ येसु वावाल मन्ह्‌तोग़, ओना पोग़ोन मीट विस्वस कीम्ह्‌टु,’ इद्रम योहन काग़्हच मतोग़” इनजोर ओर विस्वसिरिन पोलु वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","वेहतस्के पया, ओर येसु किर्स्तुना पेदिरते एग़ मीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","मीतापया, पोलु तनाङ कय्किन ओरा पोग़ोन तासतस्के,देवुळता जीवा ओरा पोग़ोन रेगता. रेगतस्के ओर तमा कग़यवव बासाने वळ्ह्‌क बोटटोर. ओसो देवुळता कबुर वेहता बोटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","अगा ओर जोक-जोक बारा मन्कलोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","अद्रमे पया मूंड नेलाङ आनाहि, पोलु देवुळता पार्तनाता लोन अंदोग़. अन्जि, अग्डोर यहुदिरा संगे, देवुळि मन्कलोरगा राजेम कीयनद पोल्‍लोतुन, रेयवालेवा दीराते तेळियिह कीसि वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","मति उय्तुर मन्कलोर कैंगम आसि, पोलुनाङ पोल्‍लोङ केंजोर. ओसो येसुना अग़ मुर्तिय लागो इनजोर, जमा आता मुडा मुनेह पास्क बोटटोर. अदिनेनाह्‌क अद पार्तनाता लोतुन विळ्सिस, विस्वसिरिन पोसि पोलु पेसिस अतोग़. अन्जि तुरनुस इनवाल गूरु काग़्हतनद लोतगा, लोकुरिन येसुनाङ पोल्‍लोङ दिनमे वेहन्दोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","अद्रमे रेंड वर्साङ आनाहि कीसोर मतोग़. इद्रमि आसिया पटटोर वेल्‍लाटोर यहुदिर ओसो युनानिर, येसुना पोल्‍लोतुन केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","(पोलु इपिसुस सहरते मनदह्‌पा,) लोकुर मुने बेस्केन ऊळवा-केंजवा मतोर, अद्रमताङ देवुळि तना लावताङ कबस्किन पोलुना कयदे तोहता. ");
INSERT INTO mrr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","अदिह्‌कु लोकुर पोलुना मेंदुदगा दुपटिन ओसो गेंदेन बोय्‍पिह कीसि, दुक अरतोरा पोग़ोन ओस तासिन्दुर. अस्के दुकिनोर सव्रेम आंदुर. ओसो बोरिन देयह्‌क पोस मंदुङ, ओरग्डाह वने देयह्‌क पेसिस वितिंदुङ. ");
INSERT INTO mrr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","उय्तुर यहुदिर मतोर, ओर नाह्‌क-नाह्‌क तिरियसोर, गूनिने देयह्‌किन पेसिह केवालोर मतोर. ओर वने येसुसामिना पेदिरतुन पोसि, देयह्‌किन पेसिह कीयलाह ऊळिंदुर. ओर देयह्‌किन इद्रम इंदुर, “पोलु पोकुर कीस्तोग़, ओग़ येसुना पेदिरते मीकु उकुम ईय्ह्‌नोम, पेसिस अन्ह्‌ट!” इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","इस्किवा पेदिरतोग़ ओर्वोग़ यहुदि मन्कल, पेर्माल मतोग़. ओनाङ एळवुर मग़्कु इद्रम कींदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","(मति उंद दिया बाताल आता इतेके,) देयम ओरिन इता, “नना येसुन पुतन, ओसो पोलुन वने पुतन, मति मीट बोरिर आंदिर?” इता. ");
INSERT INTO mrr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","इतस्के देयम पोस मतोग़ मन्कल, ओग़ इस्किवानाङ मग़्किरिन पोसि, ओराङ गेंदेङ अग़नाह, ओरिन पका नल्हचि आरे कीतोग़. अवे देबाने ओर पूरा नोमुर्क आसि, अद लोताहि पेसिस विततोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","इपिसुस सहरतगा मनवालोर, वेल्‍लाटोर यहुदिरिह्‌क ओसो युनानिरिह्‌क वने, इद पोल्‍लो एर्का आता. ओर केंजिस पका रेयतोर. रेयिसि येसुसामिना पेदिरतुह्‌क पकाय कदर ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","वेल्‍लाटोर विस्वसिर बाताल कींदुर इतेके, ओरु (इद्रमताङ पूजर-गूनिङ माट कींदोम इनजोर,) तमाङ लाग्वाङ कबस्किन सबेटोरा मुनेह कबुल आंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","मुनेन पूजर-गूनिङ कीसोर मतोर मन्कलोरु, तमाङ पुस्तकिन जमा कीसि, जमा आतोरा मुनेह बोळ्सिस ईतोर. ओराङ पुस्तकिना दारातुन लेका कीतोर, अस्के अविस्कना दारा पनस अजर्क वेंडटाङ कोताङ आताङ. ");
INSERT INTO mrr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","इद्रमि येसुना पोल्‍लो पकाय आबुर आसोर अंदु. वेल्‍लाटोरे लोकुर अद पोल्‍लोता पोग़ोन विस्वस कीसोर अंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","इव पोल्‍लोङ आतापया, पोलु मकिदुनिया पटटे, अकाया पटटे अन्जि, अग्डाह येरुसलेम दाय्ह्‌नन इनजोर, तना विचर कीतोग़. “येरुसलेम अतापया, अग्डाहि रोम सहरते वने नाक दाया पोयग़ा,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","पया तना तोळतोर तिमोतिन ओसो इरास्तुसिन मुनेन मकिदुनिया पटटे लोहचि, आसिया पटटगान तना उचुक दियाङ मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","अद तूकने इपिसुस सहरतगा, येसुसामिना कबुर आबुर आताह्‌कु, बेरा गळ्बळ आता. ");
INSERT INTO mrr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","इद्रम आता इतेके, देमेतिरियुस पेदिरतोग़ ओर्वोग़ मन्कल मतोग़, ओग़ वेंडिना कबळ कींदोग़. ओग़ वेंडिने अरतिमिस पेदिरता पेनताङ गूडिङ पंडिसि, ओना संगे कबळ केवालोरिह्‌क बेसता कमय दोर्किंदु. ");
INSERT INTO mrr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ओग़ तनगा कबळ केवालोरिन, ओसो वेल्‍लाटोरे अद्रमताङ गूडिङ पंडवालोर दुस्रोरिन वने, जमा कीसि इद्रम इतोग़, “केंजाट रा! इद दंदा केवालोरल माटु पका कमय कीय्ह्‌नल इनजोर पुतले. ");
INSERT INTO mrr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","मति इंजेके वेग़ पोलु बाताल कीयलाह आतोग़, अदिन मीट इतेके ऊळसोरेन-केंजसोरेन मह्‌निर. कयदे पंडटव पेन्कु बाताङ इलेङ, उगसताङे मन्ह्‌ताङ इनजोर, लोकुरिन वेहता बोटटोग़. अह इनजोर सिरप इपिसुस सहरतगान आयो, मति मावा आसिया पटटोर वेल्‍लाटोर मन्कलोरिन, तना पोल्‍लोतुन विस्वस कीयनाह वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","मति इंजेक वेग़ मावा दंदातुन बंद कीयनोग़. ओसो इद इचोन बेरा अरतिमिस पेनता मंदिरतुन बोरे सीता केवोर आयनुर इन्जि, रेय मन्ह्‌ता. इंजेके आसिया पटटोर ओसो दुनियातोर लोकुर तान मोळ्किह्‌तोर, मति पया तान्क अचोन मान एवोर आयनुर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","इद पोल्‍लो केंजिसि, ओर मन्कलोरिह्‌क पका ओङ वाता. ओर अग़-ओङतेन, “इपिसुसता अरतिमिस पेनतुह्‌क जोहर!” इनजोर केयलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","अद्रमे ओरा सहरतगा पका रोदा पोसि, सहरता मुल बाताल कीतोर, पोलुना संगे नाह्‌क-नाह्‌क तिरियवालोर गयुस ओसो अरिस्तरकुस, वेर मकिदुनियातोर मन्कलोरिन पोयतोर. वेरिन पोसि कतमतोर गोटुदगा ओळियतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","अस्के पोलुना वने, अगा ओळियिसि ओरा मुनेह वळ्ह्‌कना विचर मता. मति विस्वसिर ओन अगा दायलाह एवोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","पोलुना गोत मनवालोर, बोर आसिया पटटाङ साय्बालोर वने ओनु, “निमा उगसलेवा अद गोटुदगा ओळियमा. (ओळियतिन इतेके नीवा पोग़ोन तिपल वायग़ बहा,)” इनजोर कबुर लोहतोर. अदिह्‌क पोलु ओळियोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","अद गोटुदगा जमा आतोरा नडुम, पकाय गळ्बळ आता. ओसो माट इगा बाराह्‌क जमा आतल इनजोर, मुडगा वेल्‍लाटोरिह्‌क मुर्तिय एर्का बार इले आसि. अदिह्‌क अगा जमा आतोर लोकुर, तम्क विचर वाताङ पोल्‍लोने रोदा पोस मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","उय्तुर यहुदिर सिकंदर इनवाल मन्कनु निल्पिह कीसि, लोकुरिन वेहतलाह मुडा मुनेह लोहतोर. (अदिह्‌क ओग़े इद कट्ला पुटिह कीस मनदनोग़ इनजोर लोकुर इंदुर.) अस्के जमा आता मुडुन केमेन आयनुर इनजोर, सिकंदर कय तोहतोग़. तोहचि माट यहुदिरोम मीक कट्ला केवोम इनजोर वेहतलाह आतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","अस्के ओग़ यहुदि मन्कल इनजोर, मुडा मन्कलोरिह्‌क एर्का आता. अदिनेनाह्‌क ओसो रेंड गंटाङ आनाहि “इपिसुसता अरतिमिस पेनतुह्‌क जोहर!” इनजोर, बेरा लेङते केयसोर रोदा पोयंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","अस्के बाताल आता, सहरतोग़ बाबु ओरिन केमेन कीस इतोग़, “इपिसुस सहरतोर मन्कलोरिर, बेस केंजाटु! बेरा अरतिमिस पेनता मंदिरतुन, ओसो ताना पोग़ोटाहि अरतद बंडातुनु, राका कीयनद जबब्दर मावा सहरतुह्‌क अरता इनजोर, सबेटोरिह्‌क एर्काये. ");
INSERT INTO mrr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","इव पोल्‍लोङ जोलताङ इनजोर, बोग़े वेहता पग़वोग़. अदिह्‌क मीट इंजेके केमेन आसि, बेस विचर केवालेवा, बातय केमाटु. ");
INSERT INTO mrr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","मीट इंजेक वेर इर्वुरिन इगा ततिर. मति वेर मावा मंदिरता सामनतुन कलवालोर आयोर. ओसो मावा पेनतुन पास्कवालोर वने आयोर. ");
INSERT INTO mrr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अदिह्‌क देमेतिरियुस ओना तोळतोर बार, बोनातेल पोग़ोन कसुर वाटनद इतेके, कोरोट्क चालु मन्ह्‌ताङ. ओसो नेयम केवालोर मुक्यालोर वने मन्ह्‌तोरे. ओरगा अन्जि ओर्विह्‌क-ओर्वोग़ कसुर तोहता पग़यकिर. ");
INSERT INTO mrr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","मति तान्काय वीळिस पोल्‍लोङ कीयना इतेके, सर्करता काय्दा मतपु, माट नाग़मेटोरोम मीवा पोल्‍लोतुन मीटिङ कीस देहतकोम. ");
INSERT INTO mrr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","नेंडु उगसताङ पोल्‍लोनेनाह्‌क, अचोन गळ्बळ कीतिर! इद कट्लातेनाह्‌कु मावा पोग़ोन रोदा पोयतनद कसुर वाटनुर बह इनजोर रेय मन्ह्‌ता; अस्के ताना इसब माट बेद्रम ईकल?” ");
INSERT INTO mrr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","इनजोर वेहच जमा आता मुडुन लेङ वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","अद्रमे विरुद कीयनद कट्ला रोमता. पया पोलु विस्वसिरिन तनगा केयतोग़. ओर ओनगा वातस्के, ओरिह्‌क दीरा वानाह वेहतोग़. वेहचि, दाय्ह्‌नन इनजोर ओरिन कलियिस, इपिसुस सहरताहि मकिदुनिया पटटे दायलाह बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","अगा पूरा वेलियतोग़, वेलियसोर अग्डोर विस्वसिरिन, ओरा विस्वस बेर्सलाह वेल्‍लाङे पोल्‍लोङ वेहतोग़. पया अग्डाहि अकाया पटटे अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","अन्जि अगा मूंड नेलाङ मतोग़. पया सुरिया पटटे दायलाह ओडातगा उदसोर मनेके, यहुदिर ओन हव्कलाह अग़ ऊळिह्‌तोर इनजोर केंजतोग़. केंजतस्के, (सम्दुरता अग़दुन विळ्सिस,) नना मकिदुनिया पटटुह्‌क अन्जि, बूमता अग़दुन पोयतकन इन्जि, विचर कीतोग़.(अस्के मकिदुनियाते नना लूकानन, ओना तोळ मतन.) ");
INSERT INTO mrr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरिया सहरतोग़ पुरुस पेदिरतोना मग़ि सोपतरु, तिसलुनि सहरतोर अरिस्तरकुस ओसो सिकुन्दुस, दिरबे सहरतोर गयुस ओसो तिमोति, आसिया पटटोर तुकिकुस ओसो तुरपिमुस, इच्वुर मावा संगे वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ओरग्डाहि बोरो बाताल कीतोर इतेके, मकिदुनियाताहि मुनेन तरोवस सहरते अन्जि, अगा माक केपतोर. ");
INSERT INTO mrr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","माट ओय्‍पिह केवव आरिना पंडुम आनाहि, मकिदुनिया पटटा पिलिपि सहरते मतोम. पया पंडुम मारतस्के, अग्डाहि ओडातगा उदतोम. उदिसि एयुङ दियाने तरोवस सहरते एव्सि, माक केपतोरिन कलियतोम, पया माट वारममेंड तरोवस सहरतेन मतोम. ");
INSERT INTO mrr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","पया ऐतारम दिया, किर्स्तुना मोकता सीता कीसि आरिङ तिनदलाह, विस्वसिरा संगे जमा आस मतोम. अस्के पोलु इमा दिया अग्डाहि दायना मताह्‌कु, ओरिह्‌क नडुमनग़्का एवनाह पोल्‍लोङ वेहचोरेन मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","माट जमा आस मतोम अद पोग़ोटा मदलितगा, वेल्‍लाङे चिमलिङ (पोतिह कीस मताह्‌कु, कांका वीळिस मता). ");
INSERT INTO mrr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","पोलु पोल्‍लोङ वेहचोर मनेके, अगा ओर्वोग़ युतुकुस पेदिरतोग़ पेकाल, किळ्कितगा उदिस कूर्ह्‌कसोर मतोग़. कूर्ह्‌कनेके उंदियदेबा, मूंड मदलिना लोताहि इळ्न अरतोग़. पया वेर रेगिस ऊळनेके, ओग़ डोलिस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","मति पोलु इळ्न रेगतोग़, रेगिस ओन गळ्म ओग़्ङिस ओरिन इतोग़, “बहे आयो रेयमाट! वेना जीवा वेनगान मन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","पया ओर पोग़ोन अतोर, अन्जि किर्स्तुना मोकता सीता कीसि, आरिङ किळ्हचि तितोर. पया पोलु विस्वसिरा संगे पङवियनाह वळ्ह्‌कसोर मतोग़. पया अग्डाहि अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","अद्रमे पया ओग़ पेकाना लोतोर ओन लोन ओतोर. ओग़ जीवा अरताह्‌कु, ओर पका गिर्दा आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","दायनामुने पोलु माक इद्रम इन्ज मतोग़, “मीट ओडाते मुनेह पेसिस, मूसिया एरियाता असुस सहरते अन्जि मन्ह्‌टु, नना इद तरोवसताहि बूमता अग़दुन पोसि, अगा एवयह्‌नन, पया अग्डाहि मीवा संगे ओडातगा उदकन,” इनजोर वेहच मतोग़. अदिह्‌क माट मुनेन पेसिस, ओडातगा उदतोम. ");
INSERT INTO mrr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","अद्रमे पया पोलु माक असुस सहरतगा कलियतोग़, कलियिस मावा संगे ओडातगा उदतोग़. पया माट लेसबोस तोग़दा मितुलेने सहरते एवतोम. ");
INSERT INTO mrr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","पया मावा ओडा अग्डाहि पेसता, इमा दिया कियुस इनदना तोग़दा एरे एवता. पया इमा दिया अग्डाहि सामुस इनदना तोग़दगा वने एवता. ओसो इमा दिया आसिया पटटा मिलेतुस सहरते एवतोम, (अदु इपिसुस सहरता एरे मता). ");
INSERT INTO mrr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पंटाता पंडुमतुह्‌कयेरुसलेम सहरते एवयलाह, पोलु कंद्रेम आंदोग़. अदिह्‌क इपिसुस सहरते रोमतेक अचोन, इदे आसिया पटटगा पका आल्सेम आयग़ा इन्जि, इपिसुस सहरतुन एग़िस दायनद ओडा पोयतकन इनजोर, मुने विचर कीस मतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","पया इपिसुस सहरतोर विस्वसिराङ मुक्यालोरिह्‌क “मीट मिलेतुस सहरते वासि नाक कलियाट,” इनजोर कबुर लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ओर वातस्के ओरिन इद्रम इतोग़, “नना मुने आसिया पटटे वासि, इग्डाह पेसिस अनाह्‌जोम, मीवा संगे बेद्रम मतन इनजोर, मीट पुतिरे. ");
INSERT INTO mrr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यहुदिर नाक हव्कलाह कोहन्दुर, अस्के नाक पका तिपल वाता. मति नना उड्ला बुदते ताकसोरे, कनिर पोहचोरे, येसुना सेवा कीसोर मतन. ");
INSERT INTO mrr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","नना रेयवालेवा मीवा पाय्दाताङ पोल्‍लोन बेविने, मीक वेहतलाह तपोन. लोकुरा मुनेह काग़्हतन, ओसो लोह्‌क-लोह्‌क अन्जि वने काग़्हतन इनजोर, मीट पुतिर. ");
INSERT INTO mrr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","पापमता अग़दाहि जर मल्सि, देवुळता पोल्‍लो केंजिसि, मावा येसुसामिन विस्वस कीयना इनजोर, यहुदिरिह्‌क ओसो युनानिरिह्‌क वेहतन. ");
INSERT INTO mrr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“इंजेके देवुळता जीवा नाक येरुसलेम ओयलाह आता. अगा नाक बाताल आयग़ इनजोर पुनोन. ");
INSERT INTO mrr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","मति इचोने पुतन: ‘मन्कलोर नीक तिपल कीयनुर ओसो जेलते वाटनुर’ इनजोर, नना तिरियनव सबे सहर्कने, देवुळता जीवा नाक मुनेन वेहचोरेन मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","मति हातेकाय, पिसतेकाय, नावा जीवाता नना पर्वा केवोन. देवुळता दयाता बेसता कबुरतुन पोकुर कीम इनजोर, येसुसामि नाक ईतद सेवातुन मारिह कीयनद, इदे नाक बेसु. ");
INSERT INTO mrr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“इंजेके नावा पोल्‍लोतुन केंजाट. देवुळि मन्कलोरगा राजेम कीयनद पोल्‍लोतुन पोकुर कीसोर, नना मियगा तिरियसोर मतन. मति इंजेटाहि मीट इपिसुसतोरिर, नावा मोकमतुन बेस्केन ऊळविर आयकिर इनजोर पुतन. ");
INSERT INTO mrr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","देवुळि मियेनाह्‌क तासिस मतद बेदे पोल्‍लोतुन मकिह केवालेवा, पूराय वेहतन. अदिनेनाह्‌क नेंड मीकु बेस वेहतलाह वातन, मियग्डाह बोग़ाय देवुळता अग़दाहि लेसतेके, ताना जबब्दर नना आयोन. ");
INSERT INTO mrr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ओसो आपुना, अहे मियग्डोर विस्वसिरा मुडा, बेस राका कीसोर मन्ह्‌टु. बह इतेके ओराङ मुक्यालोर आयना इन्जि, देवुळता जीवाये मीक निल्पिह कीता. देवुळि तना मग़ना नेतुरता कर्सा कीसि ओरिन असता, इदिन सीताते तासाटु. अदिह्‌क मीवा नडुम मनदनदु देवुळता गोह्‌डटुन, कोपालोरा लेह्‌का मन्जि, ओरिन बेस ऊळाटु. ");
INSERT INTO mrr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","नना अतस्के, लोळ्ङास्क एर्रेन पोस ओयना लेह्‌का, जोल काग़्हवालोर मियगा वायनुर इनजोर, नना पुतन. ओर विस्वसिरिन विळ्सोर आयनुर. ");
INSERT INTO mrr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ओसो मीवाय विस्वसिरग्डाहि, उय्तुर बाताल कीयनुर, विस्वसिरिन तमेह ओयलाह, देवुळता सेतेम पोल्‍लोतुन मिळ्हच-मिळ्हच काग़्हतनुर इनजोर, नना पुतन. ");
INSERT INTO mrr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","अदिह्‌क उसरते मन्ह्‌टु! नना मूंड वर्साङ मीकु नग़्का पिळ्‍विळ पियल-पोळ्‍दु, वग़ोग़-वग़ोग़ मन्कन, कनिर पोहच बुद काग़्हचोर मतदिन सीताते तासाटु. ");
INSERT INTO mrr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“इंजेके नना मीकु देवुळता कयदे विळ्सिस ईय्ह्‌नन. ताना दयाता पोल्‍लोतुन सीता कीसोर मन्ह्‌टु. अद्रम सीता कीतेके, अद मीवा विस्वसतुन बेर्सिह कीसोर दायग़ा. ओसो बेद बर्कत देवुळि तना पवित्र लोकुरेनाह्‌क तासतद मन्ह्‌ता, अद बर्कत मीक दोर्कग़ा. ");
INSERT INTO mrr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ओसो नना बोनाङ वेंडिना, बंगर्कना, गेंदेना बेस्केन लालुस केवोन. ");
INSERT INTO mrr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","इव नावाङ कय्किन ऊळाट, इवे कय्कने कबळ कीसि, नावा ओसो नावा तोळतोर मन्कलोरा पिसवग़ आता, इदिन मीट पुतिरे. ");
INSERT INTO mrr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","इद्रम एपुर पेसनाह कबळ कीसि, कबळ कीया पग़वोरिन साय्ता कीयनदु इनजोर, नना नावाङ सबे कबस्कने कीस तोहतन. अह कीनेके, येसुसामि कुदि वेहतद इद पोल्‍लोतुन सीता कीयनदु: ‘दुस्रोनग्डाहि एतनदिह्‌काय, ओन्क ईतेकेने एक्‍वा गिर्दा वास्ता,’” इनजोर पोलु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","इव पोल्‍लोङ वेहचि, मिंडाङ कोटिस, ओरा संगे पार्तना कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","पया इंजेके नावा मोकमतुन बेस्केन ऊळविर आयकिर इनजोर, पोलु वेहतद पोल्‍लोतुन सीता कीस, ओर मुक्यालोर पका अळतोर. अळसोरे, ओरु पोलुन गळ्म ओग़्ङिस लोंडटोर. ताना पया ओर ओन ओडातगा एवनाह ओसीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","पया अगा माट इपिसुसता विस्वसिरा मुक्यालोरिन दाय्ह्‌नोम इन्जि, ओडातगा उदतोम. ओडातगा उदिसि, सीदा अनेके कोस इनदनद तोग़दगा एवतोम. ताना पया इमा दिया रूदुस इनदनद तोग़दगा एवतोम, अग्डाहि पया पतरा सहरते एवतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","अगा अतस्के सुरिया पटटा पिनिके एरियाते दायनद ओडा माक दोर्कता. तानगा उदिस माट पेसतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","अनेक अनेके मावा दावळ बाजे, माकु कुपरुस देसेम दिसता. तान वीळिसि, सुरिया पटटेके मावा ओडातुन पेहतोम, अनेक अनेके अद पटटा सोर सहरते एव्सि, अगा रेगतोम. अगा ओडातोरिह्‌क ओडातगा मतद मादुन रेहतना मता. ");
INSERT INTO mrr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","अगा रेगतस्के, अग्डोर विस्वसिरिन माट पर्ह्‌कतोम अस्के, ओर माक दोर्कतोर, ओरगान माट वारममेंड रोमतोम. अस्के येरुसलेम सहरतगा पोलु पकाय तिपल आयनोग़ इनजोर, अग्डोर विस्वसिर देवुळता पवित्र जीवाता बुदते पुतोर. अदिनेनाह्‌क निमा अगा अनमा इनजोर, पोलुनगा वासि इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","इन्जाय वारममेटा पया, माट मावा अग़दे दायलाह ओडाङ नितनद जागातेके पेसतोम. पेसनेके सबेटोर विस्वसिर तमाङ लोह्‌कनोर कतमतोरा संगे, माक सहरता पलत एवनाह ओतोर. अस्के माट सबेटोरोम अदे सम्दुरता उस्कोतगा, मिंडाङ कोटिस पार्तना कीतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","पार्तना मारतापया, माट अनेके सबेटोरिन माट दाय्ह्‌नोम इन्जि, ओडातगा उदतोम. अस्के बेस अन्ह्‌टु इन्जि, ओर तमाङ लोह्‌क मल्स अतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","सोर सहरताहि ओडाते अन्जि, पतुलिमयिस सहरतगा एवतोम. अग्डोर विस्वसिरिन कलियिस, अगान उंद उस्कंड उंजतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","पया इमा दिया अग्डाह पेसिसि, केसरिया सहरते अन्जि, बेसता कबुरतुन पोकुर केवाल पिलिपना लोन रोमतोम. (येरुसलेमतगा मुने आचतोर एळवुर सेवकिरग्डाहि वेग़ ओर्वोग़ मतोग़.) माट ओना लोन अन्जि अगा मतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","पिलिपनाङ नालुङ कुव्रा मयास्क मताङ, अविनगा देवुळता कबुर वेहतनद बुद मता. ");
INSERT INTO mrr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","माट उचुक दियाङ पिलिपना लोन रोमतोम. अगा मनदह्‌पा, यहुदा पटटाहि देवुळता कबुरतोग़ अगबुस इनवाल वातोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ओग़ मयगा वासि, पोलुना पेटातुन लेहचि, तनाङ कय्किन-काल्किन तनाय दोहतोग़. दोहचि, “बोना इद पेटा आंदु, ओग़ मन्कन येरुसलेमतोर यहुदिर इद्रमे दोहचि,यहुदि आयवोरा कयदगा पोस ईयनुर इनजोर, देवुळता पवित्र जीवा इद्रम इन्ह्‌ता,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","इद पोल्‍लोतुन केंजिसि, माटु ओसो अग्डोर लोकुर, “निमा इंजेक येरुसलेम अनमा, (माट नीवाङ काल्काय मोळ्किह्‌नोम,)” इनजोर पोलुन अर्जि कीतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","मति पोलु इतोग़, “मीट इद्रम बाराह्‌क इह्‌निर? मीट सबेटोरिर अळसि, नावा जीवातुन उड्ला केमाटु. नना येसु किर्स्तुनेनाह्‌कु येरुसलेमतगा जेलते मनदकन, अचोने आयो, मति ओनेनाह्‌क डोललाह वने तयरे मह्‌नन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","माट वेहतनव पोल्‍लोन पोलु मुर्तिय केंजोग़, अदिनेनाह्‌क देवुळताये विचर मतप आयि इनजोरे, अचोके पोल्‍लोङ इन्जि, माट केमेन आतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","अव दियाना पया माट मावा सबे सामनता संगे तयर आसि, येरुसलेम दायलाह पेसतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","केसरिया सहरतग्डाहि उय्तुर विस्वसिर वने, मावा संगे वातोर. येरुसलेमते एवतस्के, वेर माकु कुपरुस देसेमतोग़ ओर्वोग़ मनासोन पेदिरतोना लोन ओसीतोर. ओग़ पाळ्नोग़ विस्वसि मतोग़, ओनाय लोतगा माट रोमतोम. ");
INSERT INTO mrr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","पया येरुसलेमतोर विस्वसिरा मुलु, गिर्दाते माक कलियतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","इमा दिया पोलु माक पोसि, वेरा मुक्याल याकुबनगा ओतोग़. अगा दुस्रोर सबेटोर मुक्यालोर वने, जमा आस मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","अस्के पोलु ओर सबेटोरिन जोहर कीसि, देवुळि पोलुना सेवाते यहुदि आयवोरगा बाताङ बाताङ कबस्क कीस मता, अव सबेटविन मुर्तिय तपवालेवा वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ओरु अद पोल्‍लोतुन केंजिसि, देवुळतुह्‌क मान ईसि, जोहर कीतोर. कीस पोलुन इतोर, “तमो, मावा पोल्‍लो केंजा. इगा बेचोको अजर्क विस्वसते वातोर यहुदिर मन्ह्‌तोर इनजोर पुतिन. ओर सबेटोर मोसानाङ अडोन पका माळिह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","मति नीवा लोप्पा ओर इद्रम केंजतोर इतेके, निमा दुस्राङ जातिनोरगा मनवालोर यहुदिरिन, मोसानाङ अडोन विळ्साट, मीवा पेकोरेनाह्‌क डायना रिवज केमाट, यहुदिराङ उतुर्किन माग़्ङाट इनजोर काग़्हतिन अले; इद्रम ओर इग्डोर यहुदि विस्वसिर केंजतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","निमा इगा वातिन इनजोर, लोकुर निटमे केंजनुर, इंजेके बह कीयना? ");
INSERT INTO mrr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“अदिनेनाह्‌क इंजेक माट बाताल वेहतह्‌नोम, अद्रमे कीमु. मयगा इंजेक नालवुर देवुळतुन किरिया कीतोर मन्ह्‌तोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ओराय संगे निमा वने एडना रिवजतुन मारिह कीम. मारिह कीसि, मंदिरतगा ईयनव ओराङ पूरा मोकिना कर्सा निमाने कीसीम. अस्के ओर तमाङ तलाङ कोग़ियनुर. निमा इद्रम कीतिन इतेके, ‘माट पोलुना लोप्पा केंजतव पोल्‍लोङ उगसताङे, ओग़ वने मोसानाङ अडोन माळिह्‌तोग़,’ इनजोर सबेटोर यहुदिर पुनदनुर. ");
INSERT INTO mrr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","मति यहुदि आयवोर विस्वसिरिह्‌क बार, इव अडोन नोम पोयो. ओरगा मुने लोहतद सीटटगा वेहतप लेह्‌का, पेन्किह्‌क वाटटव अविङ ओसो नेतुरतुन एच तिनमाकिर, नेतुर पोववालेवा हव्कतविनाङ अविङ तिनमाकिर. साट्याल कबस्क केमाकिर इनजोर रासिस मतोम,” इन्जि विस्वसिराङ मुक्यालोर पोलुन वेहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","पया इमा दिया पोलु, ओर नालवुरा संगे मुनेटा दियाता एडना रिवजतुन कीसि, मंदिरतगा अतोग़. अन्जि एडनाङ दियाङ बेस्के मारनुङ, अस्के आक्रि दियाते ओर नालवुरेनाहि मोकि ईया पोयग़ा इनजोर, बूमयालोरिन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","28","बूमयालोरिन वेहतपु, अव एळुङ एडनाङ दियाङ मारतापया, पोलु मंदिरतगा ओसो अतोग़. अस्के आसिया पटटोर उय्तुर यहुदिर, पोलुन मंदिरता लोप्पा ऊळतोर. ऊळिसि मंदिरतगा मतोर कतमतोर लोकुरिन, ओना पोग़ोन ओङ तग़्हचि, ओन पोयतोर. पोयनेके इद्रम केयतोर, “ए इस्रयेलतोरिर, मावा तोळ आम्ह्‌टु. मावा जाततोरिनु, मोसानाङ अडोनु, ओसो इद मंदिरतुन विरुद कीसोरे, बेक अतेकाय मन्कलोरिन काग़्हचोरेन मनवाल, वेग़ ओग़े मन्कल आंदोग़. युनानि जाततोरिन वने मावा मंदिरता लोप्पा तचि, इद मंदिरतुन कळ्‍वोग़ कीतोग़,” इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ओर मन्कलोर इपिसुस सहरतोग़ युनानि जाततोग़ तुरुपिमुसिन, पोलुना संगे येरुसलेमते तिरियनेके, ऊळिस मतोर. अदिह्‌क वेन वने पोलु मंदिरता लोप्पा तच मनदनोग़ बहे, इनजोर विचर कीतोर. (मति पोलु इतेके अद्रम केवोग़). ");
INSERT INTO mrr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","अस्केन पया पूरा सहरमेंड लोकुरिह्‌क एर्का आता. अदिनेनाह्‌क लोकुर वित वासि, अगा रोदा पोयलाह आतोर. आसि पोलुन पोसि ओन ईळ्ससोर मंदिरतग्डाहि पलते पेहचि, मंदिरता अग़दुन केहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","लोकुर ओन हव्कलाह नल्हचोर मनेके, पूरा येरुसलेमतगा गळ्बळ आयलाह आता इनजोर, रोमि लळयमुडा मुक्याह्‌क कबुर दोर्कता. ");
INSERT INTO mrr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ओग़ मुक्याल बाताल कीतोग़, उय्तुर सीपय्किन ओसो दरोगालोरिन पोसि, चट्पिट विततोग़. अस्के मुक्याना संगे सीपय्क वातदिन ऊळिस, लोकुर पोलुन नल्हतलाह रोमतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","पया मुक्याल वासि पोलुन पोयतोग़. पोसि ओन रेंड गोल्स्कने दोहता वेहतोग़. दोहचि वेग़ बोग़ु, बाताल कीतोग़ इनजोर, लोकुरिन ताल्ह्‌क बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","मति लोकुर विचर वाताङ पोल्‍लोने रोदा पोस मतोर. अदिनेनाह्‌क सेतेम बाताल, इदिन बोरे बह बराबर पुनोर. अदिह्‌क ओग़ मुक्याल पोलुन सीपय्कना किलेतगा ओया वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","लोकुर पोलुना पोग़ोन पकाय ओङ आसि, ओना पयाह पयाह वासोर, “ओन हव्ककल रा!” इनजोर केयसोर, ओरा पयाह पयाह वांदुर. अदिह्‌क किलेताङ पायरिङ तग़्ङनेके, सीपय्क पोलुनु कांजिस ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","सीपय्क पोलुन ओसोर मतोर अस्के, पोलु मुक्यान युनानि पोल्‍लोते इतोग़, “निमा उकुम ईतेके, नना उंद पोल्‍लो नीक ताल्ह्‌केनन?” इतोग़. इतस्के मुक्याल इतोग़, “अरे निमा युनानि पोल्‍लो पुतिना? ");
INSERT INTO mrr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","अस्के उंद देबा ओर्वोग़ मिसर देसेमतोग़ मन्कल, रोम सर्करता विरुदतोर नालुङ अजर्क लोकुरिन, पेळ्ह्‌कल बूमते जमा कीतोग़, ओग़े मिसरि मन्कनिन बह आयविन?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","इतस्के पोलु इतोग़, “आयो साय्ब, आयो, नना यहुदि मन्कनन, किलिकिया पटटा पका पोकुर आतद तरसुस सहरतोनन आंदन. इंजेके वेर मन्कलोरा संगे नाक वळ्ह्‌कलाह ईम इनजोर, नना नीक अर्जि कीय्ह्‌नन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","इतस्के मुक्याल ओना अर्जतुन कबुल आतोग़. पोलु पायरिनगा निचि, केमेन आयलाह ओर लोकुरिन कय तोहतोग़. लोकुर केमेन आतापया, ओग़ ओरा इब्रि पोल्‍लोते वळ्ह्‌क बोटटोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","पोलु इद्रम वेहतोग़, “मावोरिर, पेदल्कनिर! नावा साक्सितुन मीवा मुनेह नना इंजेक वेहतह्‌नन, इदिन केंजाटु.” ");
INSERT INTO mrr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","इनजोर तमाये इब्रि पोल्‍लोते पोलु वळ्ह्‌कतस्के, लोकुर पूराय मेर्क्ने आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","अस्के पोलु वेहता बोटटोग़, “नना यहुदि मन्कनन, किलिकिया पटटा तरसुस सहरते पुटटोनन, मति इदे येरुसलेम सहरतगान बेर्सतन. इगा गमलियेल गूरुनगा मन्जि कग़यतन. मावाङ तादोर-बाबोराङ अडोङ-उतुर्कना उंद पोल्‍लो वने तपवा, ओग़ नाक काग़्हतोग़. इंजेके मीट सबेटोरिर कीयना लेह्‌का, नना वने देवुळतुन माळलाह पका जिदतोनन मतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","अदिह्‌क येसुसामिना अग़दे ताकवालोर आस्क-कोय्तोरिन दोहच, जेलतगा वाटिंदन. ओरिन हव्कनाह तिपल कीसोर मतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","नना इद्रम कींदन इनजोर, मोदुल पेर्माल ओसो तग्वाङ केवालोर मीवा मुनेह साक्सि मन्ह्‌तोर. वेरग्डाहे नना दमिस्क सहरतोर, मावोर यहुदिरिह्‌क रासतद सीटि ताल्ह्‌किस, अगा दायलाह पेसिस मतन. अगा येसुना अग़दे अतोर यहुदिरिह्‌क सिक्सा ईयलाहि, ओरिन दोहचि येरुसलेम ततलाह अनजोर मतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“अनेक अनेके नेक निच मता, अस्के नना दमिस्क सहरता एरे एव्स मतन. अचोटेन दोम्ह्‌क्नेन कोंडाङ नाह्‌क पग़वाह, पोग़ोटाहि नावा सर्ने बेरा उंद वेह्‌च अरता. ");
INSERT INTO mrr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अस्के नना नेल अरतन, नेल अरतस्के ‘ए सोलु, ए सोलु, नाक बाराह्‌क तिपल कीया बोटटिन?’ इनजोर इतद आल्का केंजतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","केंजतस्के ‘निमा बोनिन आंदिन, सामि?’ इनजोर इतन. अस्के ‘निमा बोन तिपल कीयलाह आतिन, ओग़ नासरेत नाटेनोग़ येसुनन आंदन,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","नावा तोळतोर सिरप वेह्‌चतुन ऊळतोर, मति नावा संगे वळ्ह्‌कतद पोल्‍लो ओरिह्‌क तेळियो. ");
INSERT INTO mrr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","पया नना ‘बाताल कीकन सामि?’ इन्जि ताल्ह्‌कतन. अस्के ओग़ नाक, ‘इंजेके तेदिस दमिस्क सहरते अन, देवुळि नीक बेद सेवातेनाह्‌क निल्पिह कीता, अव सबे कबस्कना कबुर नीक अगा दोर्कग़ा,’ इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","पका वेह्‌च आस मताह्‌कु, नना तोवोन आस मतन. पया नावा तोळतोर नावा कयदुन पोसि, दमिस्क सहरतगा ओतोर. ");
INSERT INTO mrr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“अद सहरतगा ओर्वोग़ अनन्याल पेदिरतोग़ मन्कल मतोग़. ओग़ मोसानाङ अडोने ताकसोर, देवुळतुन बेस मोळ्कवाल मन्कल मतोग़. दमिस्क सहरतोर सबेटोर यहुदिर ओन्क पका कदर ईंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ओग़ नयगा वास निचि ‘सोलु तमो, निमा तोव्‍म,’ इनजोर इतोग़. ओग़ अह इताहे, नना तोव्स ओन ऊळतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","अस्के ओग़ नाक इद्रम इतोग़, ‘मावाङ तादोर-बाबोरा देवुळता विचर बाताल मन्ह्‌ता, अद नीक एर्का आयना, ताना सेतेमतोग़ मग़िन ऊळना, ओसो ओग़े मग़ना तोडटे वेहतनद पोल्‍लो नीक केंजलाह दोर्कना, इदिनेनाह्‌के देवुळ नीक आचता. ");
INSERT INTO mrr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","इतेके निमा अनेटस्के ऊळतद, केंजतद पोल्‍लोता, वेल्‍लाटोर लोकुरिह्‌क देवुळतेनाह्‌क साक्सि ईकिन. ");
INSERT INTO mrr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","इंजेके निमा आल्सेम केमा. अले तेदिसि, येसुना पेदिरते एग़ मीयना रिवज कीम; ओना पेदिर पोस केयिस, पार्तना कीम. अस्के ओग़ नीवा पापमतुन नोग़यनोग़,’ इनजोर इतोग़. (अस्के नना येसुना पेदिरते एग़ मीतन.) ");
INSERT INTO mrr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“पया नना येरुसलेम सहरतगा मल्सि,मंदिरतगापार्तना कीसोर मतन, अस्के देवुळ तोहतद लेकातुन ऊळतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","अद लेकाते येसु नावा मुनेह निचि, ‘अले आल्सेम केवा, चट्पिट येरुसलेमताहि पेसिस अन. ऊळा, निमा नावा लोप्पा बेद साक्सि ईय्ह्‌निन अदिन वेर यहुदिर नमोर आयनुर,’ इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","अस्के नना इतन, ‘केंजनुर बहे सामि, बाराह्‌क इतेके नना यहुदिराङ वेल्‍लाङे पार्तनाताङ लोह्‌कनगा अन्जि, नीक विस्वस कीतोरिन, जेलतगा वाटिस नल्हता वेहन्दन. ");
INSERT INTO mrr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ओसो नीवा लोप्पा साक्सि ईतोग़ु, इस्तिपनिन लोकुर बंडाङ उकिस हव्किह्‌पा, नना वने ओरा तोळ आसि, ओन हव्कवालोराङ जगाना राका कीसोर मतन इनजोर, वेर यहुदिर बेस पुतोर,’ इतन. ");
INSERT INTO mrr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","मति येसु इतोग़, ‘आयो, यहुदि आयवोरिन नावा पोल्‍लोतुन वेहतलाह नना नीक जेक-जेक लोहतह्‌नन, इग्डाहि अन!’ इतोग़.” ");
INSERT INTO mrr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","इद पोल्‍लो एवनाह लोकुर ओनाङ केंजतोर. मति यहुदि आयवोरा पोल्‍लो इताह्‌कु, “इद्रमतोग़ मन्कल जीवाते मनमाकेग़, वेन हव्काट!” इनजोर पका केयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","पका केयसोर तमा केग़्स मतव जगान तेंडिस अग़्सिसींदुर, ओसो दुरातुन पोग़ोन तूळ्हन्दुर. ");
INSERT INTO mrr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","इदिन ऊळिस, लळयमुडा मुक्याल पोलुन सीपय्कना किलेता लोप्पा तता वेहतोग़. वेहचि “वेन जूताते पका नल्हचि ताल्ह्‌काटु, बाराह्‌क लोकुर इद्रम ओना अडम केयिह्‌तोर,” इनजोर उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","पया सीपय्क ओन जूताते नल्हतलाह दोहच मतोर, अस्के पोलु तना एरे निच मतोग़ दरोगान इतोग़, “साय्ब, नना रोमि मन्कनन आंदन, नावा नेयमता पय्सल आयवा, इद्रम जूताते नल्हतनद बेसेया?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","इदिन केंजिसि, ओग़ दरोगाल सीपय्कना मुक्यानगा अन्जि, “निमा बह कीयलाहि आय्ह्‌निन? वेग़ इतेक रोमि मन्कल आंदोग़,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","पया सीपय्कना मुक्याल पोलुनगा वासि, “बह निमा रोमि मन्कनिन रा?” इनजोर इतस्के, “इंगो साय्ब” इनजोर पोलु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","इतस्के सीपय्कना मुक्याल इतोग़, “नना रोमि मन्कल आयलाह, वेल्‍लाङे कोताङ ईतन,” इतोग़. इतस्के पोलु इतोग़, “मति नना इतेके पुटटग्डाहि रोमि मन्कनन आंदन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","इदिन केंजिसि, ओन ताल्ह्‌कवालोर सीपय्क, चट्‌ने जूतान नेल विळ्सिसीतोर, पया पोलुन इटोर. ओर्वोग़ रोमि मन्कन नना दोहता वेहतन इनजोर, सीपय्कना मुक्याल रेयतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","पया इमा दिया यहुदिर पोलुन बाराह्‌क कसुर ओपतोर इनजोर, निटम पुनदलाह, सीपय्कना मुक्याल पेर्मालोरिन, यहुदिराङ तग्वाङ केवालोरिन, जमा आयलाह कबुर लोहतोग़. ओर जमा आतस्के, पोलुन तचि पंचता मुनेह निल्पिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पोलु पंचतगा जमा आतोर तग्वाङ केवालोरिन, कोंडा मिळ्हवा ऊळतोग़, ऊळिसि “मावोरिर, इद ऊळाट, नेंड एवनाहि नना जीवाताहि कसुरलेवप मन्जि, देवुळता मुनेह ताकसोर वायलाह आतन,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","इतस्के अनन्याल पेदिरतोग़ मोदुल पेर्माल, पोलुना एरे निच मतोरिन, “ओन चापुळ ईम्ह्‌ट रा!” इनजोर उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","उकुम ईतस्के पोलु इतोग़, “निमा चुना ओकतद गूरेता लेह्‌काडोनिन सोङ केवानिन, देवुळि नीके सिक्सा ईयग़ा. बाराह्‌क इतेके देवुळता सास्त्रमताङ अडोङ वेहतपु, नावा नेयम कीयलाहि, निमा उदिसाय मति, सास्त्रमता विरुदते नाक नल्हतलाहि, उकुम ईयलाह आतिन अय?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","पया अगा निच मतोर पोलुन इतोर, “उल्टा देवुळता मोदुल पेर्माने मर्लबडिह्‌निन अय?” इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","इतस्के पोलु इतोग़, “दादालोरिर, वेग़ मोदुल पेर्माल इनजोर नना पुन्ज मतेके, अह वळ्ह्‌कोन आवेनन. मीवा मुक्यालोरा इद्रम कदर रेहतनद आयो इनजोर, देवुळता सास्त्रमतगा रासतद मन्ह्‌ताये,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","अस्के पया इगा जमा आतोरगा, वळ्गा सदुकिरा तुंगातोर, ओसो वळ्गा परुसिरा तुंगातोर मन्ह्‌तोर इनजोर, पोलुह्‌क एर्का आता. सदुकिरा विचर इद्रम मन्ह्‌ता, डोलतोर बेस्केन जीवा अरवोर, ओसो देवतुल्क इलेङ, ओसो हानस्क वने इलेङ इनजोर इन्ह्‌तोर. मति परुसिर बार, इव सबे पोल्‍लोना पोग़ोन आसा कीस्तोर. अदिनेनाह्‌क पोलु बेसे मेग़्किस केयलाह बोटटोग़, “दादालोरिर, नना परुसि मन्कनन! नावा तादोर-बाबोर वने परुसिरे मतोर. मन्जाय, नना डोलतोर वने जीवा अरयह्‌तोर इनजोर, विस्वस कीयनेनाह्‌के, वेर नाक पर्ह्‌किस ऊळिह्‌तोर,” इनजोर इतोग़. पोलु इव पोल्‍लोङ इतस्के, उदतोर तग्वाङ केवालोर रेंड तूस्क आसि, परुसिरा, सदुकिरा नडुम वह्‌चळ पुटटा. ");
INSERT INTO mrr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","वह्‌चळ पुटटस्के, ओरा नडुम पकाय रोदा आता. अगा उदतोर परुसिरा तुंगाताहि उय्तुर सास्त्रमगूरुर तेदिसि, “माक इतेके वेग़ पोलुनगा बाताले तप दिसो. देवुळदीपताहि ओना संगे बेदाय हानाल तेला, इलवेके देवुळता देवतुलि, वेना संगे वळ्ह्‌किस मनदग़ा, अद बेद्रमि?” इनजोर बेरा आल्काते इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ओरगा इचोटा जग्ळम आता इतेके, वेन हव्किह्‌तोर तेला इनजोर, सीपय्कना मुक्याल रेयतोग़. पया “पोलुन ओरग्डाहि पेसिह कीसि, सीपय्कना किलेतगा ओम्ह्‌टु,” इनजोर सीपय्किन उकुम ईतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","पया अदे नग़्का, येसुसामि पोलुनगा लेकाते वासि, “पोलु निमा रेयमा! बेद्रम इद येरुसलेम सहरतगा, नावा पोल्‍लोता साक्सि ईतिन, अद्रमे रोम सहरतगा वने, नावा पोल्‍लोता साक्सि नीक ईयना मन्ह्‌ता,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","इमा दिया सकरि, पोलुन हव्कलाह, उय्तुर यहुदिर जमा आस विचर कीतोर. विचर कीसि, “इंजेक पोलुन हव्कवालेवा, माट गाटो-जावा तिनवल-उनवल. माट अद्रम केवेके, देवुळ माक उंदियदेबा लेट्‌नेन ईयि तेला,” इनजोर किरिया कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","इद्रम किरिया कीतोरु, रेंड वीसाह्‌काय एक्‍वाय मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ओर मन्कलोर पेर्मालोरगा ओसो यहुदिराङ पेदल्कनगा अन्जि, “माट पोलुन हव्कवालेवा, बाताले तिनोम-उनोम आयकोम, ओन हव्कवेके देवुळि माक उंदियदेबा लेट्‌नेन ईयि तेला इनजोर, किरिया कीतोम. ");
INSERT INTO mrr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","अदिह्‌क मीट इद्रम कीम्ह्‌टु, इंजेक तग्वाङ केवालोरा संगे, सीपय्कना मुक्यान बेस तेळियिह कीसि, इद्रम कबुर लोहाट. ‘माट पोलुन ओसोवने बेस ताल्ह्‌कना मन्ह्‌ता. अदिह्‌क ओन ओसो मयगा लोहचीम,’ इनजोर कबुर लोहाट. ओग़ मियगा एवयनामुनेन, ओन हव्कलाह माट नडुम अग़दे मकिस, तयर आस मनदकोम,” इनजोर इतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","पया इद्रम अग़दे केपिसि, पोलुन हव्कलाह आय्डाङ कीयह्‌पा, पोलुना अनेमग़ केंजतोग़. केंजिसि ओग़ सीपय्कना किलेतगा अन्जि, पोलुन वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","अस्के पोलु दरोगा साय्बान केयिसि, “वेग़ पेकान सीपय्कना मुक्यानगा ओम साय्ब, वेग़ बातालो मति कबुर ततोग़ अले,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","अस्के ओग़ दरोगाल, सीपय्कना मुक्यानगा वेग़ पेकान ओतोग़. ओसि “माट दोहच तासतल ओग़ पोलु नाक केयिसि, वेग़ पेकान नियगा तता वेहतोग़, वेग़ नियगा बातालो मति कबुर ततोग़ अले,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पया सीपय्कना मुक्याल ओग़ पेकाना कयदुन पोसि, बोरे इलवा जागातगा ओसि, “बाताल पोल्‍लो मन्ह्‌ता अले, वेहा?” इनजोर ताल्ह्‌कतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","अस्के ओग़ पेकाल इतोग़, “यहुदिराङ पेदल्क जमा आसि, इद्रम विचर कींदुर: नाळि पोलु मामान ओसोवने तग्वाङ केवालोरगा तचि, ओसोवने ओन बेस ताल्ह्‌कना मन्ह्‌ता इनजोर, नियगा अर्जि कीयनुर. ");
INSERT INTO mrr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","मति निमा ओरा पोल्‍लोतुन विस्वस कीस, मामान ओरगा लोहमा साय्ब. रेंड वीसाह्‌काय एक्‍वा मन्कलोर, पोलुन हव्कवालेवा, गाटो-जावा तिनवल-उनवल, ओन हव्कवालेवा तितेके, देवुळि माक लेट्‌नेन ईयि तेला इनजोर, किरिया कीतोर. अदिनेनाह्‌क ओर मकिस केपिह्‌तोर, इंजेक ओन हव्कलाह तयरे मन्ह्‌तोर. ओन पंचतगा ओम्ह्‌टु इनजोर, निमा उकुम ईयनदिने केपिह्‌तोर,” इनजोर ओग़ पेकाल ओरा पोल्‍लोतुन सीपय्कना मुक्यान वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","वेहतस्के सीपय्कना मुक्याल इतोग़, “निमा नाक मुनेन इव पोल्‍लोङ वेहतिन, मति ओन वेहतन इनजोर बोने वेहमा बहा” इन्जि, ओग़ पेकान अग्डाह लोहचीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","पया वेग़ मुक्याल इर्वुर दरोगालोरिन केयिस इतोग़. “पोलुना संगे दायलाह, रेंड नूह्‌क सीपय्कु, कोडाने उदिस अनवालोर मूंड वीसाङ दहा (70) मुल, ओसो रेंड नूह्‌क गोग़्काङ पोयवालोरिन तयर तासाटु. ओर नग़्का नव एगनेके केसरिया सहरते अनिर. ");
INSERT INTO mrr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ओसो पोलुह्‌क दायलाह, कोडाङ तयर कीस तासाटु. अविस्कने पेलिक्स गुमसिनगा पोलुन सुकमते एव्सिह कीयिर,” इनजोर वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","वेहचि गुमसिह्‌क सीटि वने रासतोग़. अद सीटटगा इद पोल्‍लो रासतद मता. ");
INSERT INTO mrr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“नना कलोदियुस लूसियानन, गुमसि पेलिक्स महरज साय्बाह्‌क सीटि रासलाह आतन, नीक जोहर. ");
INSERT INTO mrr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","नना पोलु इनवाल मन्कन नियगा लोहतलाह आतन. यहुदिर वेग़ मन्कन पोसि हव्कसोर मतोर, मति वेग़ रोमि मन्कल इनजोर नना केंजतस्के, सीपय्कना संगे अगा अन्जि, ओरग्डाहि वेन एहतन. ");
INSERT INTO mrr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","एहचि, वेना पोग़ोन ओर बेद पोल्‍लोता कसुर ओपतोर इनजोर पुनदलाह, ओराङ तग्वाङ केवालोरगा ओतन. ");
INSERT INTO mrr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","मति मावा रोमि काय्दाता लेह्‌का, जेलतगा तासना तेला, आयवेके हव्कना सिक्सा तेला, इद्रमता लायकता वेना लोप्पा बाताले कसुर दिसो. इव सबे ओराङ अडोङ-उतुर्कनाङ कसुर्क तासतोर इनजोर, नना पुतन. ");
INSERT INTO mrr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","वेन बोरो यहुदिर हव्कलाह डाव तेंडटोर इनजोर, नाक एर्का आताह्‌कु, वेन चट्पिट नियगा लोहतन. पेलिक्स गुमसिना मुनेह वेनगा मनदनव कसुर्किन तोहाट इनजोर, वेना पोग़ोन कसुर ओपवालोरिन वेहतन,” इन्जि अद सीटटगा रासतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","अद्रमे पया नग़्का, सीपय्क तमा मुक्याल वेहतप लेह्‌का, पोलुन नग़्काडा-नग़्काने ओतोर. अनेक अनेके अंतिपत्रि सहरते एवतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","पया इमा दिया “पोलुन, माट केसरिया सहरतगा ओयकोम” इनजोर, कोडानोर सीपय्क वेहतोर. ओर इद्रम वेहतस्के, पिसतोर सीपय्क येरुसलेमता किलेतगा मलतोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","कोडानोर सीपय्क केसरिया सहरते एवतोर, एवताहे गुमसिनगा सीटटुन ईसि, पोलुन ओना मुनेह ततोर. ");
INSERT INTO mrr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","गुमसि सीटटुन अर्वताहे “निमा बेद पटटोनिन” इनजोर पोलुन ताल्ह्‌कतोग़. ताल्ह्‌कतस्के ओग़ किलिकिया पटटोग़ इनजोर एर्का आता. ");
INSERT INTO mrr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","एर्का आतस्के, “नीवा पोग़ोन कसुर वाटवालोर वातस्के, नीवा नेयम कीकन,” इनजोर इतोग़. पया पोलुन बेरोग़ एरोद राजाल पंडटद सर्करि लोतगा तास वेहचि, “वेना राका मन्ह्‌टु,” इनजोर गुमसि सीपय्किन उकुम इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पया एयुङ दियाङ आनेके, अनन्या पेर्माल ओसो यहुदिराङ उय्तुर पेदल्कु, वेरु तिरतुलु पेदिरतोग़ वकिलिन पोसि, केसरिया सहरते वातोर. वासि पेलिक्स गुमसिना मुनेह, पोलुना पोग़ोन कसुर तोहतोर. ");
INSERT INTO mrr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","पया पेलिक्स पोलुन तता वेहतोग़. ततस्के तिरतुलु वकिल ओना पोग़ोन इद्रम कसुर वाट बोटटोग़ इतेके, “ओ पेलिक्स महरज, निमा राजेम ताकिह कीयनस्केडाह, माट यहुदा पटटोरोम मुर्तिय लळय आयवा मतोम. नीवाय तेल्वतेनाह्‌कु, मावा जाततोर सुद्रेम आसोर दास्तोर, तानेनाह्‌कु नीक जोहर आयि. माट बेक अतेकाय, नीवा मयगा मनदनद इद गूनमता अमेसा सीता कीय्ह्‌नोम. ");
INSERT INTO mrr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","नना नीक वेल्‍लाङे पोल्‍लोङ वेहच तिपल केवोन मति, नीवा गूनमते मावाङ रेंड पोल्‍लोना अर्जतुन केंजा. ");
INSERT INTO mrr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","वेग़ मन्कल जग्ळा पुटिह केवाल, बूममेंड मनवालोर सबेटोर यहुदिरा नडुम कोंटेङ पुटिह केवाल. ओसो वेग़ नासरिरा लाग्वद तुंगाता पेदामन्कल आंदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","मावा मंदिरतुनकळ्‍वोग़ कीयलाह आसोर मतोग़, मति अद्रम केवाह माट वेन पोयतोम. अस्के माट मावाङ अडोना लेकाते वेन सिक्सा ईस मनेरोम. ");
INSERT INTO mrr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","मति सीपय्कना मुक्याल लूसियाल वासि, मयग्डाहि वेन ऊंदिस ओतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ओसि वेना पोग़ोन कसुर वाटटोरिन, नियगा वायलाह वेहतोग़. इंजेके निमान वेन ताल्ह्‌किस ऊळा, अस्के माट कसुर्क वाटटव सबे पोल्‍लोन निमा पुनदकिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","अस्के अगा वास मतोर यहुदिर वने वकिलनेह आसि, इव पोल्‍लोङ निटमे इनजोर इंदुर. ");
INSERT INTO mrr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","पया गुमसि पोलुन निमा वेहा इनजोर कय तोहतोग़. अस्के पोलु इद्रम वेहतलाह बोटटोग़ इतेके, “महरज, निमा वेल्‍लाङे वर्साङ, मावा यहुदा पटटगा नेयम कीसोर मतिन इनजोर पुतन. अदिनेनाह्‌क गिर्दाते नना कसुरलेवोनन इन्जि तोहतह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","बारा दियाना मुने, नना देवुळतुन मोळ्कलाह येरुसलेमतगा अन्ज मतन. इद पोल्‍लो निटम इनजोर, निमा वने ताल्ह्‌किस पुनदा पग़यकिन. ");
INSERT INTO mrr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","देवुळता पार्तनाताङ लोह्‌कनगा आयि, मंदिरतगा आयि, सहरतगा आयि, नना बोनाय संगे गिटोगटो आयनदिन वेर ऊळोर. ओसो लोकुरिन जमा कीसि, रोदा पोय्‍पिह कीयनदिन वने ऊळोर. ");
INSERT INTO mrr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","नावा पोग़ोन वेर वाटटोर अव कसुर्कनाङ पोल्‍लोङ निटमे इनजोर तोहतलाह, वेरगा साक्सि वने इले. ");
INSERT INTO mrr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“मति इद उंद पोल्‍लो नना कबुल आय्ह्‌नन. बेद अग़दुन वेर लाग्वा अग़दा तुंगा इन्ह्‌तोर, अदे येसुसामिन विस्वस कीयनद अग़दे नना ताकिस, मावाङ तादोर-बाबोरा देवुळतुन माळिह्‌नन. मोसानाङ अडोनगा, ओसो देवुळता कबुरतोरा सास्त्रमतगा रासतव सबे पोल्‍लोन माळिह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","देवुळि उंद दिया हातोरग्डाहि सेतेमतोरिन, लाग्वोरिन तेग़्किह कीयग़ा इनजोर, वेर देवुळता पोग़ोन आसा तासतप लेह्‌का, नना वने आसा तासिह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","अदिह्‌क देवुळता मुनेह आयि, लोकुरा मुनेह आयि, अमेसा जीवाताहि कसुरलेवप मन्जि, ताकलाह ऊळिह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“नना वेल्‍लाङे वर्साङ येरुसलेम इलवा मतन, मति इंजेके मावा गरिब यहुदि जाततोरेनाह्‌क, जमा कीतद दर्मम एव्सिह कीयलाह, ओसो मंदिरतगा देवुळतुह्‌क मोक ईयलाहि, येरुसलेम वास मतन. ");
INSERT INTO mrr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","मंदिरतगा एडना रिवजतुन मारिह कीतापया, ओर नाक मंदिरतगा ऊळतोर. अस्के अगा नावा संगे वेल्‍लाय मुल इलोर आसि, बातय रोदा वने इलो. ");
INSERT INTO mrr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","मति आसिया पटटोर उय्तुर यहुदिर अगा वास मतोर, ओरे रोदा पोयलाह बोटटोर. नावा बातालाय तप मतेक अचोन, नयगा कसुर वाटलाहि ओर इगा वास मनेर. ");
INSERT INTO mrr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","अले वेर इगा नितोरे वेहिर, येरुसलेमते तग्वाङ केवालोर अद दिया नावा बाताल कसुर दोर्किह कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","आं ‘डोलतोर वने जीवा अरयह्‌तोर इनजोर, नना विस्वस कीताह्‌कु, नाक पर्ह्‌किस ऊळिह्‌निर अय!’ इनजोर इद उंद पोल्‍लोतुन मात्रम, निटमे ओरा मुनेह जोरते केयिस वेहतन,” इनजोर पोलु इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","पेलिक्स इतेके येसुसामिन विस्वस कीयनद पोल्‍लोतुन बेस केंजिस मतोग़, अदिह्‌क “सीपय्कना मुक्याल लूसियाल वातापया, नीवा पोल्‍लोता पय्सल कीकन,” इनजोर वेहच मारिह कीतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","पया दरोगान इद्रम उकुम ईतोग़, “पोलुन दोहवालेवा जेलतगा तासा. ओसो ओना तोळतोर बातालाय ईयलाह वातेके, ओरिन रोमिह केमा,” इनजोर इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","उचुक दियाना पया, पेलिक्स तना मुते, यहुदि आंचाळ दुरुसिलान पोस वातोग़. पया पोलुन केय लोहतोग़, पोलु वातस्के येसु किर्स्तुन विस्वस कीयनद पोल्‍लोतुन, आळ इर्वुर केंजसोर मतोर. ");
INSERT INTO mrr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","अस्के देवुळता सेतेमते बेद्रम ताकना, मेंदुदा उळ्बेतुन बेद्रम आव्रे कीयना, देवुळ आक्रिते दुनियामेटोरा नेयम बेद्रम कीयग़ा, इव पोल्‍लोन पोलु वेहतोग़. पया इव पोल्‍लोङ केंजिस, पेलिक्स पकाय रेयिस पोलुन इतोग़, “इंजेके आस्ता, निमा अन, नाक पुर्सत दोर्कतेक, अचोन नीक केयकन” इनजोर, ओन लोहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","पोलु जेलतग्डाह पेसलाह, कुस्क्ने नावा कयदे कोताङ ईयनोग़, इद्रम गुमसिना आसा वने मंदु. अदिह्‌क ऊक-ऊके ओन केयिस गोटिङ कींदोग़. ");
INSERT INTO mrr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","मति रेंड वर्साङ आनेके, पुर्कियुस पेस्तुस पेदिरतोग़, पेलिक्सना जागातगा गुमसि आतोग़. पया पेलिक्स दायह्‌पा, पोलु कसुरलेवोग़ इनजोर पुन्ज तेला, यहुदिरिन गिर्दा कीयलाह, पोलुन जेलतग्डाह विळ्सवाय अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","पेस्तुस गुमसि यहुदा पटटा केसरिया सहरते एव्सि, मूंड दियाना पया, अग्डाह येरुसलेम सहरते अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","अगा पेर्मालोर ओसो यहुदिराङ पेदल्कु ओनगा वासि, पोलुना पोग़ोन कसुर तासलाह आतोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","पोलुन नडुम अग़दगान हव्कना मता, अदिनेनाह्‌क “मुर्बत कीसि पोलुन केसरियाताहि येरुसलेम लोहचीम, साय्ब” इनजोर, पेस्तुस गुमसिन अर्जि कीतोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","अस्के गुमसि इतोग़, “पोलु इंजेके केसरिया सहरता जेलते मन्ह्‌तोग़. इंजेक उचुक दियाने, नना वने अगा दाकन. ");
INSERT INTO mrr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","अदिह्‌क मियग्डाह मुक्या मन्कलोर नावा संगे वायिर! ओग़ मन्कना पोग़ोन बाताल कसुर मतेके, ओना कसुरतुन मीटे तोहतकिर,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","अद्रमे पया पेस्तुस गुमसि आट-दहा दियाना लेह्‌का ओरा संगे मन्जि, येरुसलेमताहि केसरिया सहरते मलतोग़. अस्के ओना संगे, यहुदिरा मुक्या मन्कालोर वने वातोर. इमा दिया नेयम कीयनद जागातगा उदिसि, पोलुन तता वेहतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","पोलु वातस्के, येरुसलेमताहि वातोर यहुदिर पोलुना सर्ने निचि, ओना पोग़ोन वेल्‍लाङे बेराङ कसुर्क वाटटोर. मति अव कसुर्किन ओर करल कीया पग़वोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","अस्के पोलु इतोग़, “नना यहुदिराङ अडोन बूळे केवोन, मंदिरतगा बाताले तप कबळ केवोन, ओसो रोम राजेमताकय्सर राजाना अडम वने, बाताले पोल्‍लो वळ्ह्‌कोन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","पोलु अद्रम इतापया, यहुदिर गिर्दा आयिर इनजोर, पेस्तुस पोलुन इतोग़, “इव पोल्‍लोना नेयम, येरुसलेमतगा नावा मुनेह आयि इनजोर, निमा तयर मह्‌निना?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","मति पोलु इतोग़, “निमा कय्सर राजाना रोमि सर्करता अदिकरते नेयम कीय्ह्‌निन. इंजेक रोम सर्करता कोरोटटे नना नितन, अदिनेनाह्‌क इगाने नावा नेयम आयना गावले. यहुदिराङ अडोना बातालतुने बूळे केवोन इनजोर, निमा बेस पुतिन. ");
INSERT INTO mrr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","नना हव्कना सिक्सा लायकता कसुर कीतेके, डोललाह तयरे मह्‌नन. मति बेव पोल्‍लोना लोप्पा, वेर यहुदिर नावा पोग़ोन कसुर वाटलाह आतोर, अव पोल्‍लोङ जोल मतेक, बोग़े नाक वेरा कयदे पोस ईया पग़वोग़. (इंजेके इगा केसरियाते नावा नेयम आयवेके, नाकु रोम सहरतगालोहचीम.) अगाने कय्सर राजाना मुनेह, नावा नेयम आयि इनजोर अर्जि कीय्ह्‌नन, साय्ब,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","पया पेस्तुस तनाङ मंत्रिरा संगे वळ्ह्‌किस “निमा कय्सर राजाना मुनेह नावा नेयम आयि इनजोर अर्जि कीतिन, ओनगान निमा दाकिन,” इनजोर पोलुन इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","बेचोको दियाना पया बाताल आता इतेके, एरेटा पटटा गुमसि अग्रिपा राजाल, तना एलाळि बेर्निके बार अगा वातोर. वेर केसरिया सहरतगा, पूनोग़ गुमसि पेस्तुसिन कलियलाहि वातोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","एलाग़ इर्वुर अगा वेल्‍लाङे दियाङ मतोर. अद तूकने पेस्तुस पोलुना नेयमता लोप्पा, अग्रिपा राजानु वेहतोग़. “मुनेतोग़ गुमसि पेलिक्स बाताल कीतोग़, ओर्वोग़ मन्कन इगान जेलते वाटिस अतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","बेस्के नना येरुसलेमतगा मतन, अस्के अग्डोर पेर्मालोर ओसो यहुदिराङ पेदल्कु, ओना पोग़ोन कसुर वाटिसि, ‘वेग़ कसुर कीतोग़, वेन्क हामुरता सिक्सा ईम’ इनजोर, नाक ताल्ह्‌कतोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ताल्ह्‌कतस्के नना ओरिन इतन, ‘बेचानाह कसुर तोहवालोरा मुनेह, कसुरतोग़ मन्कल निचि, तना कसुरता लोप्पा बयन एवोग़, अचानाह ओन्क सिक्सा ईयना, अद्रमता रोम सर्करता उतुर इले,’ इतन. ");
INSERT INTO mrr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","अद्रम इतस्के, ओर यहुदिर इगा वातोर, वातस्के नना आल्सेम केवालेवा, इमा दिया नेयम कीयनद जागातगा उदतन. उदिसि, ओग़ पोलु इनवाल मन्कन, नावा मुनेह तता वेहतन. ");
INSERT INTO mrr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ओना पोग़ोन कसुर वाटवालोर निचि, कसुरताङ पोल्‍लोङ वेहतोर. मति बेद्रम नना विचर कीस मतन, अद्रमता कसुरताङ पोल्‍लोङ वेर वेहोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","मति ओर तमाय दर्मताङ पोल्‍लोना लोप्पा, ओसो बोग़ो येसु पेदिरतोग़ मन्कना लोप्पा, वेर यहुदिर पोलुन कट्ला कींदुर. वेग़ येसु डोलिसाय मति जीवात मन्ह्‌तोग़, इद्रम पोलुना इनमुळ मन्ह्‌ता. ");
INSERT INTO mrr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","इद्रमताङ पोल्‍लोन बेद्रम नेयम कीयनद इनजोर, नना एक्बेक आस मतन. अस्के ‘इव पोल्‍लोना नेयम येरुसलेमतगा बेस आयना इन्जि, निमा अगा दाकिना?’ इनजोर पोलुन इतन. ");
INSERT INTO mrr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","इतस्के पोलु इतोग़, ‘आयो, कय्सर राजानाये मुनेह, नावा नेयम आयि. ओग़ नाक नेयम कीसीयनाह, नना जेलतगान मनदकन,’ इनजोर इतोग़. अदिह्‌क नना ओन कय्सर राजानगा लोहनाह्‌जोम, जेलतगान मनेग़ इनजोर उकुम ईतन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","अस्के अग्रिपा राजाल पेस्तुसिन इतोग़, “अले, ओग़ मन्कल वेहतनदिन, नना वने केंजकन,” इतोग़. इतस्के पेस्तुस इतोग़, “अले, अह इतेके नाळिय केंजकिन,” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","अद्रमे पया इमा दिया, अग्रिपा राजाल, बेर्निके, वेर एलाग़ इर्वुर, बेरा गिजुरते वातोर. वासि मीटिङ कीयनद बेरा अराते ओळियतोर. सीपय्कना मुक्यालोर ओसो सहरतोर साव्कर मन्कलोर अगा वातोर. अस्के “पोलुन पोस वाट” इनजोर, पेस्तुस उकुम ईतस्के, पोलुन ततोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ततस्के पेस्तुस इतोग़, “ओ अग्रिपा राजा ओसो इगा जमा आतोर लोकुरिर, वेग़ मन्कन ऊळलाह आतिर. येरुसलेमतगा वने, इगा वने, वेल्‍लाटोर यहुदिर नयगा वासि, वेना पोग़ोन कसुर वाटटोर. वेन जीवात तासनायो इनजोर केयतोर. ");
INSERT INTO mrr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","नना इसि वेन हव्कना लेह्‌काडा, वेग़ बाताले कसुर केवोग़ इनजोर पुतन. मति कय्सर राजाना मुनेह, नावा नेयम आयि इनजोर, वेग़ तनाय अर्जि कीतोग़. अदिह्‌क नना वेन रोम सहरते कय्सर राजानगा लोहतलाह विचर कीतन. ");
INSERT INTO mrr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","मति वेन लोहनेके, नावा कय्सरसामिह्‌क वेना कसुरता लोप्पा बाताल रासिस लोहतकन इनजोर, नना पुनोन. अदिह्‌क मीट वेनाङ केंजतापया, बेदाय पोल्‍लो नाक रासलाह दोर्कग़ा बहा इनजोर, इगा मीवा मुनेह वेन ततन. कासा इतेके नीवाङ बुदिङ ताल्ह्‌किह्‌नन, अग्रिपा राजानिन. ");
INSERT INTO mrr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","जेलते मतोग़ मन्कन, कय्सर राजानगा लोहनेके, ओग़ बाताल तप कीतोग़ इनजोर रासवालेवा, उंदियदेबा लोहतनद ओप्पग़ाया?” इतोग़. ");
INSERT INTO mrr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","पया अग्रिपा राजाल पोलुन इतोग़, “इंजेके नीवाङ पोल्‍लोङ वेहता पग़यह्‌निन.” इतस्के पोलु (नना वळ्ह्‌कलाह आतन इन्जि तोहतलाह,) तना कय अहचि, इद्रम पोल्‍लोङ वेहता बोटटोग़ इतेके, ");
INSERT INTO mrr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","“ए अग्रिपा राजानिन, यहुदिर नावा पोग़ोन वाटटव कसुरताङ पोल्‍लोना लोप्पा, नाक नीवा लेह्‌काडोग़ मन्कना मुनेह वेहतलाह अग़ दोर्कता इतेके, नना नेंड पका गिर्दा आतन. बह इतेके मावा यहुदिरा मनमुळतुन, ओसो मावाङ अलग-अलग विचर्किन, निमा बेस पुतिन. इंजेके नना वेहतनाङ पोल्‍लोन, दया कीसि केंजा इनजोर, नीक जोहर कीय्ह्‌नन. ");
INSERT INTO mrr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“मुने नावाय जाततोरा नडुम मन्जि, अहे पया येरुसलेमते वने, उड्लस्केडाहि नावा मनमुळ बेद्रम मता, इदिन वेल्‍लाटोर यहुदिर पुतोर. ");
INSERT INTO mrr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","मावा यहुदि दर्मताङ अडोन, सबेट्काय पका नोमनद तुंगातोनन आंदन, इतेके परुसिरा तुंगातोनन, इदिन यहुदिर बेस पुतोर. इद पोल्‍लो निटम इनजोर तमा विचर मतेके, साक्सि ईयिर. ");
INSERT INTO mrr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","इंजेक इसि इद्रम आता इतेके, देवुळि मावाङ तादोर-बाबोरिह्‌क मुनेन बेद पोल्‍लो विळ्सिस मता, अदे पोल्‍लो निटम आयग़ा इन्जि, नना आसा तासतन. तासताह्‌के नावा नेयम आस्ता. ");
INSERT INTO mrr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","देवुळ इदे पोल्‍लोतुन निटम कीयनद आसाते, मावाङ बारा कूळिनोर इस्रयेल लोकुर, देवुळतुन नग़्का पिळ्‍विळ, पियल-पोळ्‍द मोळ्कसोरे, पोल्‍लो विळ्सतदिन अद निटम कीयग़ाये इनजोर, माळसोरेन केपिह्‌तोर. ओ राजा, नना वने अद्रमे आसा तासतन, इदिना लोप्पा यहुदिर नावा पोग़ोन कसुर वाटटोर. ");
INSERT INTO mrr_vpl VALUES ("AC