﻿USE sofia;
DROP TABLE IF EXISTS sofia.mqjNT_vpl;
CREATE TABLE mqjNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mqjNT_vpl WRITE;
INSERT INTO mqjNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kabuttuanna Yesus Kristus peampoanna tomaraya Daud, peampoanna Abraham, susi inde laoannae: ");
INSERT INTO mqjNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Keanak Abraham dadi Ishak, keanak Ishak dadi Yakub, keanak Yakub dadi Yehuda anna angganna sirondongna. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Keanak Yehuda dadi Peres anna Zerah nasibalii Tamar, keanak Peres dadi Hezron, keanak Hezron dadi Ram, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","keanak Ram dadi Aminadab, keanak Aminadab dadi Nahason, keanak Nahason dadi Salmon, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","keanak Salmon dadi Boas nasibalii Rahab, keanak Boas dadi Obed nasibalii Rut, keanak Obed dadi Isai, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","keanak Isai dadi tomaraya Daud, keanak Daud dadi Salomo nasibalii ambo' bainena Uria, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","keanak Salomo dadi Rehabeam, keanak Rehabeam dadi Abia, keanak Abia dadi Asa, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","keanak Asa dadi Yosafat, keanak Yosafat dadi Yoram, keanak Yoram dadi Uzia, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","keanak Uzia dadi Yotam, keanak Yotam dadi Ahas, keanak Ahas dadi Hizkia, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","keanak Hizkia dadi Manasye, keanak Manasye dadi Amon, keanak Amon dadi Yosia, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","keanak Yosia dadi Yekhonya anna angganna sirondongna. Attu iatoo dipali' to Israel lako Babel. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mangkai pampalisan lako Babel, keanak Yekhonya dadi Sealtiel, keanak Sealtiel dadi Zerubabel, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","keanak Zerubabel dadi Abihud, keanak Abihud dadi Elyakim, keanak Elyakim dadi Azor, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","keanak Azor dadi Zadok, keanak Zadok dadi Akhim, keanak Akhim dadi Eliud, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","keanak Eliud dadi Eleazar, keanak Eleazar dadi Matan, keanak Matan dadi Yakub, ");
INSERT INTO mqjNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","keanak Yakub dadi Yusuf muanena Maria to undadian Puang Yesus to digente' Kristus battu' dikua To dibassei bayu-bayu la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadi, mengkalao dio Abraham sae lako tomaraya Daud, sapulo appa' lapikna. Mengkalao dio Daud sae lako attunna pampalisan lako Babel, sapulo appa' lapikna. Anna mengkalao dio attunna pampalisan sae lako kadadianna Kristus sapulo appa' duka' lapikna. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kadadianna Yesus Kristus, susi inde uleleannae: Maria indona, situmai Yusuf. Sapo ta'pa sidapo' anna manambukmo ura'na kakuasaanna Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Inde Yusuf-e mesa to malolo, iamo nangei morai la kumassoro'. Sapo la napomatimmin annu moka la umpakasiri' tumainna lako tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Inde anna penawa-nawaan liumi Yusuf la kumassoro'e, mangngimpi napellambi'i malaeka' nasua Dewata, ma'kada lako nakua: “O Yusuf peampoanna tomaraya Daud, dau marea' umpobaine Maria, annu itin anak natambukko ura'na kakuasaanna Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","La muane anakna anna la musangai Yesus annu la umpasalama' petauanna dio mai kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ia nangei dadi susi anna malara lemba' battakadanna Puang Allata'alla napalanda' nabinna nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Patanannia' talinga, itin anak darao la manambuk, la muane anakna anna la disangai Imanuel.” Imanuel kalembasanna “Nasolaangkia' Puang Allata'alla”. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Millikki Yusuf, napogau' tongammi susi mangka natulasanni malaeka'na Dewata napolalan umpobaine Maria. ");
INSERT INTO mqjNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sapo tae' dengan siballa'i sambu' sae lako dadi anakna, muane. Yusufmo ussangaii Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Inde anna dadimo Puang Yesus dio Betlehem dio lembangna Yudeae, attu iatoo tomaraya Herodes ma'parenta dio. Saemi dio Yerusalem pira-pira to untarru' penono'na bentoen lu yaya mai tandai kabuttuan allo. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mekutanami nakua: “Umba nangei anak mane dadi, tomarayanna to Yahudi? Mangka kiita bentoenna yaya tandai kabuttuan allo, iamo kingei saemo la umpenombaii.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Naissananna tomaraya Herodes tula' iatoo, tikkedu'mi sola angganna issinna Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Urrempummi angganna kapala imam anna angganna to untarru' issinna sura'na Musa anna kutanaii kumua umba la nangei dadi To dibassei bayu-bayu la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Natimba'mi nakua: “Dio tondok Betlehem illalan lembangna Yudea annu innang dengan battakadanna Puang Allata'alla nauki' mesa nabi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘O tondok Betlehem illalan lembangna Yehuda, tae'ko la mala dipa'barinni'i illalan alla'-alla'na tondok kamai illalan lembangna Yehuda. Annu iko la nangei buttu perepi' to la ungkambi' petauangku to Israel.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mangkaii, untambai bunimi to untarru' penono'na bentoen Herodes anna kutanai manappai piran anna buttu itin bentoenno. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mangkai nakutanai, nasuami lako Betlehem anna pakari'di'i nakua: “Laomokoa' umpeang manappa itin anakko, ianna mulambi'mo pakarebainakkao angku lao kao duka' umpenombaii.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mangkanna mantula' tomaraya mengkalaomi. Ummita omi bentoen mangka naita yaya tandai kabuttuan allo napolalan dore'. Nayoloanammi inde bentoenne anna torro yao sipatunna angngenan nangei inde anakke. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tamami banua, ummitami inde anakke sola Maria indona. Malimuntu' asammi umpenombaii. Umbukaimi pa'pengngeanna anna umpebeen pa'petandona lako inde anakke iamo bulawan, lite kayu bumanangnga' disanga kemenyan, anna lite kayu senga' disanga mur. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lalan senga'mo naola anna ma'pasulemo lako tondokna annu mangka napangngimpi napakari'di' Puang Allata'alla tae' la ma'pasule lako Herodes. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Le'bai to untarru' penono'na bentoen, mangngimpimi Yusuf napellambi'i malaeka'na Dewata anna ma'kada nakua: “O Yusuf, millikko alai itin anak sola indonao ammu kondonganni lako Mesir annu la napeang Herodes napatei. La torrokoa' dio sae lako nalambi' attunna kupantula'i pole oko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Millik siami Yusuf anna ummala inde anak sola indonae anna mengkalao lako Mesir bongi ia siamo too. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Torromi dio sae lako bonno' Herodes. Kara-kara iatoo dadi anna malara lemba' battakadanna Puang Allata'alla napalanda' nabinna nakua: “Kutambai dio mai Mesir anakku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Naissananna Herodes kumua napakenamia to untarru' penono'na bentoen, keara' siami. Napolalan umpopepatei angganna ana'-ana' muane illalan tondok Betlehem anna lako tondok sikadappi'na, mengkalao dio mane dadinna sae lako anak dua taun, napasipolean attu mangka narangngi napokada to untarru' penono'na bentoen. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Susimi tee napolalan lemba' battakadanna Dewata napalanda' nabi Yeremia nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dirangngimi to umbating dio tondok Rama, Rahel umbatingngi anakna anna moka dipakaranga annu pa'de asammi anakna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mangkai bonno' Herodes, mangngimpimi Yusuf dio Mesir napellambi'i malaeka'na Dewata anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Millikko, baai itin anak sola Maria indonao ammu ma'pasulea' lako Israel, annu mangkami bonno' to la umpatei itin anakko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Millik siami Yusuf anna mengkalao lako Israel umbaa inde anak sola indonae. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sapo marea' ma'pasule lako lembangna Yudea annu napelele kumua Arkhelaus ussonda Herodes ambena mentomaraya dio. Lu lakomi lembangna Galilea annu mangka napangngimpi napaturoi lalan Dewata. ");
INSERT INTO mqjNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Saei lako, matana diomi mesa tondok disanga Nazaret. Ia nangei dadi susi anna malara lemba' battakadanna Dewata untula' Anakna napalanda' nabinna nakua: “La digente' to Nazaret.” ");
INSERT INTO mqjNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Masaei mangkanna, saemi Yohanes to simantedok dio padang alla' illalan lembangna Yudea anna parandukki umpalanda' kadanna Puang Allata'alla nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mengkatoba'mokoa' annu madappi'mi kasaeanna kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanesmo napatu kadanna nabi Yesaya anna ma'kada nakua: “Dengan tau dio padang alla' metamba-tamba nakua: ‘Patokanni lalan Dewata, maloloananni lalan la naola.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Inde Yohanes to simantedokke bulu unta napa'bayu anna balulang napa'beke', bando' sola duro naponande. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Sasaeammi tau lu dio mai Yerusalem, anna dio mai lembangna Yudea anna angganna tondok dio sikadappi'na Salu Yordan umpellambi'i Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ummakui asammi kasalaanna anna tedokki dio Salu Yordan. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Buda duka' to Farisi sola to Saduki sae umpellambi'i annu morai la ditedok. Sapo naitanna Yohanes, ma'kadami lako nakua: “O anggammua' to kadake gau', musangarika la malakoa' nasala ara'na Puang Allata'alla? ");
INSERT INTO mqjNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pakawananni kumua mengkatoba' tongammokoa' ummolai panggauammua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Daua' anna kendek illalan penawammu kumua tae'koa' la napabambanni sangka' Puang Allata'alla annu peampoannakoa' Abraham. Annu kutulasangkoa' sitonganna, inde mai batue la mala napopendadi peampoanna Abraham Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tokami wase dio to' kayu la dilellengan kayu tae' kembua mapia anna ditibe tama api. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wai kao kutedokangkoa' la tandana kumua mengkatoba'mokoa'. Sapo dengan la sae windingku marru untondon kakuasaangku annu moi angga palopakna la kualaianni, tae'na' la sipato'. Inde taue Penawa Masero sola api la natedokangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tokami petappi dio limanna la natappian gandum. Angganna gandum malapu' naanna tama talukun, anna tappianna la ditibe tama api tae' la nabela pi'de.” ");
INSERT INTO mqjNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Attu iatoo, saemi Puang Yesus dio mai Galilea umpellambi'i Yohanes dio Salu Yordan la natedok. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sapo nasandak Yohanes nadapai nakua: “Sitonganna kao la sipato' mutedok. Maakari anna Ikora sae umpellambi'ina' la kutedok?” ");
INSERT INTO mqjNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sapo natimba' Puang Yesus nakua: “Pabeaina' mutedok temo annu la taola ungganna'i angganna pa'kuanna Puang Allata'alla.” Naturu'mi Yohanes pelaunna napolalan natedok. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mangkai ditedok, kendekmi dio mai wai Puang Yesus. Ummitami langi' titungka' anna turun Penawanna Puang Allata'alla susi dangan-dangan urrampoii. ");
INSERT INTO mqjNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dirangngi siami kamara yao mai suruga nakua: “Iamo te Anakku to kukamaseie anna to umpomasannang penawangku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mangkai too, natettemi Penawa Masero Puang Yesus lako padang alla' annu la nasudi ponggawana setang. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma'puasami Puang Yesus appa' tapulo allona appa' tapulo bonginna napolalan tadea'. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Saemi ponggawana setang ussudii nakua: “Ianna Anakna tongangko Puang Allata'alla, popendadi rotii inde mai batue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Sapo natimba' Puang Yesus nakua: “Dengan tiuki' illalan Buku Masero nakua: ‘Tangngia angga roti la napotuo ma'rupa tau, sapo angganna battakadanna Puang Allata'alla.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mangkaii, ussolammi Puang Yesus lako Yerusalem, kota masero, anna payaoi bubungan Banua Ada'na Puang Allata'alla ");
INSERT INTO mqjNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","anna ma'kada lako nakua: “Ianna Anakna tongangko Puang Allata'alla, dondonangko kalemu rokko annu dengan tiuki' illalan Buku Masero nakua: ‘La ussua malaeka'na Puang Allata'alla umpesangkaiko, anna timangko indana titumbu lentekmu lako batu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Natimba' Puang Yesus nakua: “Dengan duka' tiuki' illalan Buku Masero nakua: ‘Dau ussandak-sandak Puang Allata'alla Dewatammu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ussolaan pole omi Puang Yesus langngan tanete malangka' anna paitaii angganna kaparentaan illalan lino sitonda kamalekeanna ");
INSERT INTO mqjNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","anna ma'kada nakua: “Angganna tende lakoe la kupalulako asan kalemu ke malimuntu'ko dio oloku umpenombaina'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma'kada Puang Yesus lako nakua: “Pallaiko lao Setang! Annu dengan tiuki' illalan Buku Masero nakua: ‘Penombaiko Puang Allata'alla Dewatammu, anna angga lako kalena la muola memala'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Le'ba siami ponggawana setang umpellei Puang Yesus. Saemi malaeka'na Puang Allata'alla ussaraii. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tappana naissanan Puang Yesus kumua ditarungkun Yohanes to simantedok, mengkalaomi dio Yudea lu lako lembangna Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Untampemi Nazaret lu lako tondok Kapernaum anna torro dio. Inde Kapernaum-e dio biring Tasik Galilea illalan lili'na litak katawaanna Zebulon anna Naftali. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ia nangei lu lako Kapernaum Puang Yesus anna malara lemba' battakadanna Dewata napalanda' nabi Yesaya nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Litak katawaanna Zebulon anna Naftali, lalan lako Tasik Galilea, tandai lianna Salu Yordan illalan lembangna Galilea, litakna tau senga' salianna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ummitami kamasiangan passassang to nakala' kamalillinan, anna to illalan lembangna kamatean, naarrangmi kamasiangan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Saena Puang Yesus dio Kapernaum, naparandukmi napa'peassakan lako tau buda kumua: “Mengkatoba'mokoa' annu madappi'mi kasaeanna kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pissan attu ummundu' biring Tasik Galilea Puang Yesus. Ummitami dua to sirondong disanga Simon (sidikuaan toi Petrus) anna disanga Andreas marassan madala, annu innang to simadala. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Napa'kadaimi Puang Yesus nakua: “Maikoa' ammu turu'na' annu la kupatudukoa' undala ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mengkalao siami untampe dalana anna le'ba unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Umpatarru'mi penonosanna, ummita pole omi to sirondong disanga Yakobus anna Yohanes, anakna Zebedeus, marassan umpapia dalana sola ambena illalan lopinna. Natambaimi duka' Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","napolalan bassi umpellei lopinna sola ambena, anna le'ba unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ulleleammi banua pa'sambayanganna to Yahudi Puang Yesus illalan lili'na Galilea ma'patudu anna umpalanda' Kareba Kadoresan kumua madappi'mi kasaeanna kaparentaanna Puang Allata'alla. Anna umpomalapu' to masaki dio mai ma'rupa-rupa saki anna rammun. ");
INSERT INTO mqjNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tappa silelemi karebana Puang Yesus dio lembangna Siria, napolalan buda tau sae umpellambi'i pantan umbaa to masakinna. Inde mai to masakie narua ma'rupa-rupa saki, to ussa'dingan kamapa'disan, to natamai setang, to lintu manukan, anna to balimbingan. Napomalapu' asammi Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","napolalan buda tau ma'karompo' ummula'i, dengan to lu dio mai lembangna Galilea, dengan to lu dio mai lembangna Dekapolis, dengan to lu dio mai Yerusalem, dengan to lu dio mai lembangna Yudea, anna dengan to lu sambali' mai lamban lianna Salu Yordan. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Inde anna ummitamo tau buda Puang Yesus-e, lu langngammi tanete anna ma'loko. Saemi passikolana umpellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Naparandukmi Puang Yesus ma'patudu nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kerongko' angganna to ussanga kalena to tapalambi', to anggamo Puang Allata'alla narannuan, annu la tama kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kerongko' angganna to masussa penawanna, annu la napakaranga Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kerongko' angganna to malenna' penawa, annu la untarima pa'dandinna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kerongko' angganna to morai liu la umpogau' pa'kuanna Puang Allata'alla, annu la napalosso' inawanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kerongko' angganna to pa'rantangan bua, annu la narantangan bua Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kerongko' angganna to ma'penawa mapatting, annu la silambi' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kerongko' angganna to umpaombo' kasikalinoan, annu la digente' anakna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kerongko' angganna to didarra annu unturu' pa'kuanna Puang Allata'alla, annu la tama kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kerongko'koa' ke ditellekoa' anna dipakario-rio sola dipatampoi angganna kakadakean ura'na kapangngoreanammua' lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Susimi duka' nabi yolona buda didarra. Dadi la dore'koa' ke nalambi'koa' kara-kara iatoo annu tokami pa'tamba' yao suruga la nabengangkoa' Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ikomoa' dipasirapan sianna lino. Ianna matammangmo sia ta'mo diissan dipamassin sule. Ta'mo dengan gunana, ditibe babangmi lao nasilullu'-lullu'i tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ikomoa' dipasirapan kamasiangan la ummarrang ma'rupa tau illalan lino. Ianna dengan tondok yao tanete tae' dengan leleanna tae' la naita tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tae' dengan tau la umpau' ballo anna mane palumbangngi busso. Sangngadinna la napayao innang angngenanna anna malara ummarrang angganna tau illalan banua. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","La susimi duka' pangngarrangmu la nakawanan angganna tau anna malara ummita gau' mapiammu napolalan umpakasalle Ambemu yao suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Daua' anna kendek illalan penawammu kumua kasaeangku tama lino la umpa'dean issinna sura'na Musa anna pepatudu illalan sura'na nabi. Tae'nakkao la sae umpa'deanni sapo sae kuganna'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kutulasangkoa' sitonganna, ianna ta'pa pa'de langi' anna lino, tae' duka' dengan la dipa'dean issinna sura'na Musa moi podo sangkanuku malotongmo ke ta'pa lemba' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iamo too benna-benna umpa'dean issinna sura'na Musa moi mesamo randan barinni'na anna pa'patuduanni lako tau senga', innang la to takeangga' illalan kaparentaanna Puang Allata'alla. Sapo benna-benna umpalakoi anna pa'patuduanni lako tau senga', innang to la keangga' illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dadi paillalan penawai inde tula'kue: Tae' dengan leleammua' la tama kaparentaanna Puang Allata'alla, ke tae'koa' untondon to untarru' issinna sura'na Musa anna to Farisi umpogau' pa'kuanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muissanammia' pepatudu mangka dipalanda' lako neneta nakua: ‘Daua' papatean; benna-benna papatean, la dipabambanni sangka'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sapo kukua Kao temo lako kalemua' benna-benna keara' lako padanna, la dipabambanni sangka'. Benna-benna ma'kada lako solana nakua: ‘Tae' dengan gunamu,’ la dibaa lako pa'bisara aluk. Anna benna-benna ma'kada lako solana nakua: ‘Oma'ko,’ la sipato' dipatama api naraka. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dadi, ianna marassangkoa' memala' langngan Puang Allata'alla anna mukilalai kumua dengan tau mangka mupa'di' penawa, ");
INSERT INTO mqjNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","patorro salapi kapemalasammu ammu lao sikapia itin solamuo. Mangkai too malamoko pole' umpatarru' kapemalasammu langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Pa'rapanan dengan tau umparapa'ko lako pa'bisara aluk, peangko lalan ammu sikapiaa' ummola lalan, bayuammu ta'pa ullambi' angngenan pa'bisara. Annu' ianna tae' mupateen, la nasorongko balimmu rokko lisu pala'na pa'bisara anna mane patarru'ko lako polisi pa'bisara, anna mane pole' patamako tarungkun polisi. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kutulasangkoa' sitonganna, tae' dengan leleammu la dipasuun illalan mai tarungkun ke tae' kebaya' asan indammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muissanammia' pepatudu kumua: ‘Dau ullullu' pa'bannetauan.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sapo kukua Kao temo: benna-benna unnenne'i baine anna kendek kamailuanna, tau iatoo ullullu' pa'bannetauan illalan penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ianna mata kanammu untumangko kasalaan, lessu'i lao ammu tibei. Annu dotamia ungkapa'deiko matammu sabali, anna la sangkalebu kalemu dipa'tibean tama naraka. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ianna lima kanammu la untumangko kasalaan, poloi lao ammu tibei. Annu dotamia ungkapa'deiko limammu sabali, anna la sangkalebu kalemu dipa'tibean tama naraka.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Dengan duka' mesa pepa'guruan nakua: Benna-benna ussisarakan bainena, la umbeen sura' kasisarakan bainena. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sapo kukua Kao temo: benna-benna ussisarakan bainena salianna ke ullullu'i pa'bannetauan bainena, tau iatoo untumang bainena ullullu' pa'bannetauan ke kemuane polei. Anna benna-benna umpobaine inde baine nasisarakan muanenae, tau iatoo ullullu' pa'bannetauan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Muissanammia' pepatudu mangka dibeen neneta nakua: ‘Daua' tokke' ma'pinda-pinda babang, sapo pengnganda' tonganni ke dengan aka mangka mupa'pindai dio olona Dewata.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sapo kukua Kao temo lako kalemua': Tae'koa' mala ma'pinda-pinda, susi la umpa'pindai suruga annu iamo tongkonan layukna Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","tenni la umpa'pindai lino annu iamo pente'dakanna Puang Allata'alla. Tae'koa' duka' mala umpa'pindai Yerusalem annu iamo nangei Tomarayanna angganna tomaraya. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tae'koa' mala umpa'pindai ulummu annu tae' dengan kakuasaammua' la umpomabusa beluakmu battu' la mupomalotong, moi la salamba'mo. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sapo anggamia' la mukua ‘Io’ battu la mukua ‘Tae'.’ Ianna dengampa murangnganni, pa'damanamo ponggawana setang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mangkamia' murangngi pepatudu nakua: ‘Dialai matanna to ummalai matanna solana anna diressuian isinna to ummalai isinna solana.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sapo kukua Kao temo lako kalemua': Daua' umbala'i to umpogau' kakadakean lako kalemu. Sapo ianna dengan untampiling papo kanammu, tananan polei papo kairimmu. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ianna dengan umparapa'ko lako pa'bisara aluk annu morai la ummala bayummu, bengan polei bayu rui'mu. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ianna dengan tau umpassako umbaanni porewana sangkilo mambelanna, paduai kilo muola umbaanni. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ianna dengan aka-akammu napelau tau, beenni. Ammu dau tutu'ian lalan to la mangngindan lako kalemu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mangkamia' murangngi pepatudu kumua: ‘Kamaseikoa' solamu ammu kabassi ewalimmu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sapo kukuangkoa' temo: Kamaseikoa' ewalimmu ammu pa'sambayanganni to undarrakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ianna mupasusi tee, la kawanan kumua anakna tongammokoa' Ambemu yao suruga. Annu Puang Allata'alla umpadellek mata allo susi lako to umpogau' kamapiaan tenni lako to umpogau' kakadakean anna umpadengan uran lako to umpogau' kamaloloan tenni lako to umpogau' kakadakean. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Annu akamo la saromua' ke anggami to ungkamaseiko mukamasei? Annu tuang passima duka', to musangaia' to kasalaan, anna siungkamasei to ungkamaseii. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ianna anggamo sangkalamma'mu mupa'kadai, tae' dengan alla'na panggauammua' tau senga'. Annu to tama'dewata duka' anna ma'gau' susi. ");
INSERT INTO mqjNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iamo too kenamala angganna panggauammu tae' dengan sassana susi Ambemu yao suruga tae' dengan sassana.” ");
INSERT INTO mqjNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pengkilalaii, daua' umpalako sara'na alukmu ke anggari la mupa'paitaan lako tau kamban. Annu ianna susi too, ta'mo la dengan saromua' yao mai Ambemu yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ianna ma'petandokoa' lako to mase-mase, daua' pa'peassakanni susi sinapalako to ma'dua tambuk illalan banua pa'sambayangan sola lako tangnga lalan annu morai la natede tau buda. Sitonganna itin matin tau susio untarimamia sarona ke natedei tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sapo ianna dengan aka-akammua' la mutandoian to mase-mase, pomatimminni indana issananni tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Angga iko la ummissananni anna Ambemu yao suruga to ullosa angga maritik sae lako kara-kara membuni, la umbengangko saromu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ianna ma'sambayangkoa', tae'koa' la susi to ma'dua tambuk sinaporai ke'de' ma'sambayang illalan banua pa'sambayangan, battu lako lalan maroa' anna malara naita tau buda. Sitonganna, tau susi too untarimamia sarona ke natedemi tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sapo ianna ikoa' ma'sambayang, tamakoa' tambingmu ammu tutu'i ammu mane ma'sambayang langngan Ambemu to tadiita. Anna Ambemu to ullosa angganna membuninna, la umbengangkoa' saromu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ianna ma'sambayangkoa', tae'koa' la susi to tangngummissanan Dewata umpa'sule-sulei tula'na. Annu nasanga la naperangngii Dewata ke kalandoi sambayangna. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dau pa'pasusii, annu naissanan asan Ambemu kaparalluammua' moika anna ta'pa lemba' dio pudukmu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sapo ianna ma'sambayangkoa' la mukua: ‘Ambeki yao suruga, dipomasero sangammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Paombo'mi kaparentaammu, anna dituru' pa'kuammu illalan lino susi yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Beengkan nande la siruanna kiande allo temo. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ammu garri'iangkan kasalaangki, susi kami unggarri'imo to kasalaan lako kaleki. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dau pabeaikan disudi la umpogau' kasalaan, sapo la mupasikambelakan kakuasaanna kakadakean. Annu Ikomo to ummampui kaparentaan, kakuasaan, anna kamatandean sae lako-lakona. Amin.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Annu ianna unggarri'iko kasalaanna padammu ma'rupa tau, la nagarri'iangkoa' duka' kasalaammu Ambemu yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sapo ianna tae'koa' unggarri'i kasalaanna padammu, tae'koa' duka' nagarri'ian kasalaammu Ambemu yao suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ianna ma'puasakoa', daua' ma'patingkurrung leen susi to ma'dua tambuk annu sinaangga'i umpalumalin rupanna anna malara naita tau kumua marassan ma'puasa. Kupokadangkoa' sitonganna, itin matin tau susio untarimamia sarona ke natedemi tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sapo ianna ikoa' ma'puasa, mendau'koa' ammu meselak manappa, ");
INSERT INTO mqjNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","anna malara tae' naissanan tau senga' kumua marassangko ma'puasa. Sapo angga Ambemu to tadiita ummissananni. Annu Ambemu yao suruga to ullosa angga maritik sae lako kara-kara membuninna la umbengangko saromu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Daua' urrempun ewanan illalan lino, annu la naande panattak, ta'gasan, anna la naboko tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sapo rempun yaori suruga ewanammu annu tala naande panattak, tala ta'gasan, dapakaia la naboko tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Annu umba-umba angngenan nangei ewanammu, iamo duka' nangei penawammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mata sirapan ballona batang kaleta. Ianna masiang matammu, masiang asan duka' sangkalebu kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sapo ianna mapa'di' matammu, manassa anna tae' dengan aka muita susi to illalan kamalillinan. Dadi ianna pi'de kamasiangan illalan kalemu, manassa anna kali'likangko. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tae' dengan tau la nabela umpengkarangan dua puang annu la naturu' manappa mesa, anna la napaboko'i penawa mesa. Battu' dikua marru la napakalando mesa anna tae' la naperangngii mesa. Susimokoa' duka', tae' la mubela umpalulangngan Puang Allata'alla penawammu ke mupasiolanni untombon ewanan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iamo too kupokadangkoa' matin temo: Daua' malallan umpikki' salu katuoammu kumua akamo la diande sola diiru'. Tae'koa' duka' la malallan umpikki' batang kalemu kumua akamo la dipake. Annu katuoanna ma'rupa tau tae' angga la ummande anna batang kalena tae' angga la ma'pake. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pikki'pia' katuoanna dassi langngan loa, tala mangngambo', tala mepare, dapakaia la mallika'. Sapo moika anna susimo too, tontong liu duka' nabengan nande Ambemu yao suruga. Tae'ka marru keangga'koa' iko anna la itin lako dassio? ");
INSERT INTO mqjNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tae' dengan tau mala ullombungngi sunga'na moi titti'mo annu malallan umpikki' salu katuoanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Maakari ammu malallan umpikki' la mupakena? Petua'pi bunga-bunga lako pasang, tala mengkarang, tala ma'tannun. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sapo marru untondon kamalekeanna pakeanna tomaraya Salomo yolona, moika anna iamo randan tomakaka. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Inde lako reue tuo temo disumpunni makale', sapo napomaleke Puang Allata'alla. Senga'mia' iko too, sapo tangkaangkoa' mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iamo too daua' malallan umpikki' salu katuoammu kumua: ‘Akamo la kiande? Akamo la kiiru'? Anna akamo la kipake?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Itin matin kara-kara susio napeang to tae' ummissanan Puang Allata'alla. Sapo tae'koa' iko la susi, annu innang naissanan iko Ambemu yao suruga angganna kaparalluammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sapo pasaluikoa' penawa kaparentaanna Puang Allata'alla ammu pogau'i pa'kuanna, anna pagannasangkoa' duka' kaparalluan senga'mu. ");
INSERT INTO mqjNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iamo too ta'mokoa' la malallan umpikki' allo makale' annu allo makale' ummampui duka' kamalallanan. Pasiruaimia' duka' kamalallananna allo temo, daumo rangnganni polei.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dau umpasala padammu ma'rupa tau indana pasalako duka' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Annu umba mupasusi umpasala padammu, la nakuamo duka' Puang Allata'alla umpasalako. Annu sukasan mupake lako padammu la napake duka' Puang Allata'alla lako kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Maakari ammu ummita polinna solamu pada nennu' anna tae'ko ussa'ding talakayu illalan matammu? ");
INSERT INTO mqjNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Umbamo la mukua ma'kada lako solamu: ‘Maiko angku alaiangko polimmu pada nennu',’ anna talakayu iko illalan matammu tae' musa'ding? ");
INSERT INTO mqjNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O anggammua' to ma'dua tambuk, alaia' yolo talakayu illalan mai matammu anna malara masiang matammu ummalaian polinna solamu pada nennu'. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Daua' ammu been asu angganna maserona indana ma'pasule ungkela'ko. Ammu dau tibean lako bai mutiarammu indana lullu'i babangngi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Melauko ammu dibeen, peangngi ammu lolonganni, dedekko ba'ba ammu ditungka'ian. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Annu benna-benna melau la dibeen, benna-benna mameang la nalolongan anna benna-benna undedek ba'ba la ditungka'ianni. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tae' dengan tau la untandoi batu anakna ke umpelaui roti, ");
INSERT INTO mqjNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","battu umbeen ula' anakna ke umpelaui be'dok. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Dadi ikoa' to kasalaan anna muissan untandoi anakmua' mapianna, la Ambemupa yao suruga innang la umpa'petandoan mapianna lako to melau langngan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pogau'i lako padammu la muporainna napogau' lako kalemu. Iamo te pungngu' tannunna issinna sura'na Musae anna sura'na nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ummola tamakoa' ba'ba basikki', annu ba'ba anna lalan tama naraka marru kalua' anna buda tau ummolai. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sapo ba'ba anna lalan lu lako katuoan sae lako-lakona marru basikki', anna angga titti' tau ummolai.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Matangkingkoa' lako to unggente' kalena nabi sapo sitonganna to ma'papusa. Annu susi tappa' domba madota'na ke saekoa' napellambi'i, sapo sitonganna tae' dengan alla'na serigala makarra'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sapo la muissanammia' ke muitami pa'palakona. Annu tae' dengan leleanna bua anggur la dipuppu' dio mai to' duri, battu bua ara la diala dio mai to' kurra ma'duri. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Susi toi duka' to' kayu lobo', la mapia buana anna to' kayu korrean, la kadake buana. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tae' dengan to' kayu lobo' la kadake buana, tae' toi dengan to' kayu korrean la mapia buana. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Angganna to' kayu tae' kembua mapia, la dilellengngi lao anna disumpunni. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Susimi duka' to unggente' kalena nabi la muissanan ke muitamia' pa'palakona.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tae' sangngiaan to mekapuang lako kaleku la tama kaparentaanna Puang Allata'alla, sapo angga to umpogau' pa'kuanna Ambeku yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Annu illalan allo ma'katampakanna la buda tau sae dio oloku anna ma'kada nakua: ‘O Puang, mangkamokan umpalanda' battakadanna Puang Allata'alla ummolai sangammu. Mangkamokan urrambai setang ummolai sangammu anna umpogau' tanda memangnga-mangnga ummolai sangammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Attu iatoo la kubatotongngiammi lako kukua: ‘Tae'koa' kuissanan. Pallaikoa' lao anggammua' to angga umpogau' kakadakean.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Angganna to umperangngii manappa battakadangku anna pogau'i, sirapan to keaka' umpake'de' banuanna yao batu. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ianna urammo anna sae wai ma'salu-salu siolaan bara' urrua inde banuae tae' nabela naroppokan annu manda' a'dirinna yao batu. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sapo benna-benna urrangngi battakadangku anna tae' napaillalan tambuk dapakaia la napalako, tau iatoo dipasirapan to tama'rori' umpake'de' banuanna yao bungin. ");
INSERT INTO mqjNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ianna urammo anna sae wai ma'salu-salu siolaan bara' urrua inde banuae roppokmi napolalan tae' dengan dialaan tampaan darun.” ");
INSERT INTO mqjNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Mangkai mantula' Puang Yesus, mangnga-mangnga asammi tau annu sitonda kakuasaan umpalanda' pepatudunna, sisala to untarru' issinna sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Turunni Puang Yesus yao mai tanete, budami tau ma'karompo' unturu'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Saemi duka' mesa to dolengan umpellambi'i anna malimuntu' dio tingngayona napasiolaan ma'kada nakua: “O Tuang, kuissanan kumua malana' mupomalapu' ke moraiko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ummette' siami limanna Puang Yesus anna urrumbu inde taue anna ma'kada nakua: “Moraina', malapu'moko.” Monda siami sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Napakari'di'mi Puang Yesus nakua: “Pengkilalaii, tae' la mupokada lako tau senga' inde kara-karae. Sapo laomoko umpa'paitaan kalemu lako imam ammu baa bua pemala'mu, situru' parentana Musa annu la mendadi tanda lako tau buda kumua malapu'moko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tamai kota Kapernaum Puang Yesus, saemi mesa ponggawana tantara Roma untammuii anna ma'kada lako nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Tuang, dengan sabua'ku dio banua mamma' liu annu tae' nabela ke'de' anna marru mapa'di' nasa'ding.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Natimba' Puang Yesus nakua: “Angku laomora umpomalapu'i.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sapo nakua inde ponggawana tantarae: “O Tuang, tae' sigalina' la sipato' mupellambi'i lako banuangku. Pokadami sabatta kada, tae' mala tamalapu' sabua'ku. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Annu to diparentana' duka' anna dengan toi tantara kupatandarokkoan. Ianna kukua lako mesa tantara: ‘Mengkalaoko,’ mengkalao siami. Anna lako senga'na kukua: ‘Maiko,’ sae siami, battu lako sabua'ku ke kukua: ‘Karangngi indee,’ nakarang siami.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mangnga-mangngami Puang Yesus urrangngi tula'na inde ponggawana tantarae napolalan ma'kada lako to unturu'i nakua: “Kupokadangkoa' sitonganna, ta'pa dengan kulambi' to Israel nasusian kapangngoreananna inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kutulasangkoa' kumua buda to salianna to Yahudi la sae dio mai angganna angngenan illalan lino anna ummande sola Abraham, Ishak, anna Yakub illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Anna inde to sidikuan petauanna Puang Allata'allae la ditibe tama angngenan randan malillin, iamo la nangei sikatangi' anna tikarasissik isinna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nakuamo Puang Yesus lako inde ponggawana tantarae: “Laomoko annu la dadimi lako kalemu situru' kapangngoreanammu.” Tappa malapu' siami sabua'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lu lakomi banuanna Petrus Puang Yesus. Saei lako ummitami matukanna Petrus baine, mamma' annu makula'. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naanda'imi limanna, tappa monda siami sakinna napolalan millik anna untarakanni Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lendu'i allo, budami to natamai setang sae nabaa tau lako Puang Yesus. Anggami sabatta tula'na urrambai lao inde setangnge anna umpomalapu' angganna to masaki dio. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kara-kara iatee napogau' Puang Yesus anna malara lemba' battakadanna Dewata napalanda' nabi Yesaya nakua: “Iamo umpassanangki' rammunta anna undudungangki' sakinta.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Inde anna itami Puang Yesus buda tau sae ungkarompo'ie, ussuami passikolana lamban lian biring tasik tandai lian. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Saemi mesa to untarru' issinna sura'na Musa umpellambi'i Puang Yesus anna ma'kada nakua: “O Tuangguru, la lao liuko kuula', moi umba la muola.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Natimba' Puang Yesus nakua: “Ummampui ia bumbun serigala anna angganna dassi ummampui serang, sapo Anak Mentolino tae' ma'tutu angngenan nangei mamma'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dengan duka' mesa passikolana ma'kada nakua: “O Tuang, tangga' salapa' angku laopa ullamun ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sapo natimba' Puang Yesus nakua: “Maimoko ammu turu'na'. Pabeaimia duka' to mate ullamun to matena.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mangkai too, langngammi lopi Puang Yesus sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ummolai lalan, tokke'mi sae talimpuru' illalan tasik, lambisan natamai wai lopinna napobua' bombang kamai napolalan ambo' titti' maran. Sapo attu iatoo mamma'ria Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Natundammi passikolana nakua: “O Puang, pesangkaikan, la tallammikia'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Natimba'mi Puang Yesus nakua: “Maakaria' ammu marea'? Tae'koa' mangngorean tongan.” Anna mane ke'de' ussadangngi bombang sola talimpuru'. Tappa mattan siami tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mangnga-mangngami passikolana anna sipantula'-tula' nakua: “Benna tappa'ra inde taue anna saera lako tasik sola talimpuru' mengkaola lako kalena?” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lambanni Puang Yesus sola passikolana lian lembangna to Gadara, natammuimi dua to natamai setang lu dio mai liang. Inde taue makarrak, napolalan ta'mo dengan tau barani ummola lalan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ummitanna Puang Yesus, mealo'-alo'mi nakua: “O Anakna Puang Allata'alla, aka la mupogau' lako kaleki? Moraimokoka la undarrakan moi anna ta'pa nalambi' attunna?” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sikadappi' angngenan iatoo buda bai marassan menduruk. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Napelaumi lako Puang Yesus nakua: “Ianna la mupassakan mallai illalan mai kalena inde taue, kipelau la musua tamakan kalena inde lako baie.” ");
INSERT INTO mqjNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nakuamo Puang Yesus: “Mallaikoa' lao.” Mallai siami illalan mai kalena inde taue anna lu tama kalena bai buda. Napolalan sikakondong untibe kalena rokko palimping tarru' rokko tasik, lambisan bonno' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sikakondong siami tama tondok to undagai inde baie anna untetteran kara-kara iatoo, anna to natamai setang natula' duka'. ");
INSERT INTO mqjNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Turun tondokmi tau lao umpellambi'i Puang Yesus anna sasunanni umpellei lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mangkai too, langngammi lopi Puang Yesus sola passikolana anna ma'pasule lian tondok sinangei torro. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tapakala saemo tau umbulle to balimbingan mamma' dio ampa'na. Tappana ummita kapangngoreananna inde mai taue, ma'kadami Puang Yesus lako to balimbingan nakua: “O anakku, pomatoroi penawammu annu digarri'iammoko kasalaammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Attu iatoo dio duka' reen pira-pira to untarru' issinna sura'na Musa urrangngi tula'na Puang Yesus. Nakuamo illalan penawanna: “Inde taue untelle Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sapo nalosa Puang Yesus penawanna napolalan nakua: “Maakari anna kendek pikki' kadake illalan penawammua'? ");
INSERT INTO mqjNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Umbanna la madommi' dadi lako inde taue, la kukuaraka: ‘Digarri'iammoko kasalaammu,’ la kukuaraka: ‘Millikko ammu menono'?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sapo la kupakawanan temo anna malara mukalesoa' kumua Anak Mentolino ma'kuasa unggarri'i kasalaan inde lino.” Anna mane ma'kada lako inde to balimbinganne nakua: “Millikko, alai ampa'mu ammu sule lako banuammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Millik siami anna menono' sule lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Marea' asammi to ummita inde kara-karae napolalan umpakasalle Puang Allata'alla to umbeen inde kakuasaan susi lako ma'rupa taue. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mangkai too, mengkalaomi Puang Yesus umpellei angngenan iatoo. Ummolai lalan, ummitami mesa tuang passima disanga Matius ma'loko-loko illalan kantoro'na. Napantula'imi Puang Yesus nakua: “Maiko ammu turu'na'.” Ke'de' siami anna le'ba unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Marassanni ummande Puang Yesus sola passikolana dio banuanna Matius, saemi pira-pira tuang passima sola to sinasangai to Yahudi to kasalaan anna ummokko' ummande sola Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dengan to Farisi ummitai, napolalan ma'kada lako passikolana Puang Yesus nakua: “Maakari tuanggurummua' anna ummande sola tuang passima anna to kasalaan?” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sapo narangngi Puang Yesus napolalan natimba' nakua: “Tangngia to malapu' umparallui tuandotto', sapo to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pikki' manappai kalembasanna battakadanna Puang Allata'alla nakua: ‘Pa'kamase Kao randan kuporai, tangngia olo'-olo' pemalasan.’ Annu tangngia Kao to ussanga kalena malolo sae kutambai, sapo to kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tapakala saemo passikolana Yohanes to simantedok mekutana lako Puang Yesus nakua: “Maakari anna tae' ma'puasa passikolamu anna ma'puasakan kami sola to Farisi?” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Natimba' Puang Yesus ummala mesa tandengan nakua: “Dengangka leleanna la masussa penawanna to ullomba pa'sombaan ke diopi reen to mane dipakebaine? Manassa anna tae'. Sapo la dengan attunna to mane dipakebaine dialai illalan mai alla'-alla'na to ullombai, mane ma'puasari pole'. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tae' dengan tau la umpopetampi' sampin bakaru lako pakean malusa, annu ianna timpo'do'mo sampin bakaru, tuttuan kalua'mi sesse'na pakean malusa. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Susi duka' anggur bakaru, tae' dengan tau umpatamai pa'pengngean malusa annu la natessean napolalan masala babang anggur anna tesse duka' pa'pengngean anggur. Dadi anggur bakaru manggi' dipalutama pa'pengngean bakaru anna malara bassi mapia.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Marassampi mantula' Puang Yesus, saemi mesa perepi' illalan banua pa'sambayanganna to Yahudi umpellambi'i anna malimuntu' dio tingngayona napasiolaan ma'kada nakua: “Dengan anakku baine mane bonno' tappa'. Sapo lao siapoko urrumbui anna malara tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ke'de' siami Puang Yesus sola passikolana anna le'ba sola inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ummolai lalan, dengammi mesa baine sapulo duami taunna ussa'dingan saki baine undendei Puang Yesus lu dio mai boko'na anna rumbui tampak bayu rui'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Annu nakua illalan penawanna: “Moi podo kurumbumo bayunna la malapu'mo'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Menggirikmi Puang Yesus lako boko'na anna ma'kada nakua: “O anakku, pomatoroi penawammu. Malapu'moko annu muoreanna'.” Malapu' siami inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tapakala saemo Puang Yesus lako banuanna inde perepi'e. Tappana ummita to ma'tulali bonde' sola buda tau marimoka, ");
INSERT INTO mqjNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ma'kadami nakua: “Mallai asangkoa' lao, annu itin anakko tae' bonno' sapo mamma'.” Sapo napetawai asan tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Le'ba asanni tau disua suun, tamami Puang Yesus anna ummanda'i limanna inde anakke, tuo siami sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kara-kara iatoo napelele asan tau illalan lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mangkai too, umpatarru'mi penonosan Puang Yesus. Naula'mi dua to buta metamba-tamba nakua: “O peampoanna tomaraya Daud, kamaseikan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tamai banua Puang Yesus, saemi napellambi'i inde dua to butae. Nakutanaimi nakua: “Muoreangka kumua la malakoa' kupomalapu'?” Natimba' nakua: “Io, kiorean, Tuang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Narumbumi Puang Yesus matanna anna kuanni: “Malapu'mokoa', situru' kapangngoreanammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tappa masiang siami pennenne'na. Napakari'di'mi Puang Yesus nakua: “Daua' lao untula'i lako tau senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sapo laoria natetteran napasambai padang. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Le'banna inde dua to butae, sae pole omi tau umbaa mesa to oma' annu natamai setang. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mangkai narambai lao Puang Yesus setang illalan kalena, naissan siami mantula'. Napolalan mangnga-mangnga asan to ummitai, anna sipantula'-tula' nakua: “Ta'pa dengan leleanna diita dio Israel kadadian susi tee.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sapo nakua to Farisi: “Kuasanna ponggawana setang illalan kalena napolalan mala urrambai lao setang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ulleleammi tondok-ma'tondok Puang Yesus, sima'patudu illalan pa'sambayanganna to Yahudi anna umpalanda' Kareba Kadoresan diona kaparentaanna Puang Allata'alla. Anna umpomalapu' to masaki dio mai ma'rupa-rupa saki anna rammun. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Rantangmi buana Puang Yesus anna ummitamo tau buda masussa penawa anna dipa'sarantanan sirapan domba tae' dengan to ma'kambi'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nakuamo lako passikolana: “Sitonganna budami gandum matua sapo angga titti' to la ussae'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iamo too pelauia' langngan puangna gandum anna ussua tau sae ussaesanni gandumna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Umpopa'mesami sapulo dua passikolana Puang Yesus anna beenni kakuasaan la urrambai setang, umpomalapu' tau dio mai ma'rupa-rupa saki anna rammun. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Indemi sapulo dua rasulnae: Bunga'na disanga Simon, sidikuaan duka' Petrus; anna sirondongna disanga Andreas; Yakobus anna sirondongna disanga Yohanes anakna Zebedeus; Filipus; Bartolomeus; Tomas; Matius tuang passima; Yakobus anakna Alfeus; Tadeus; Simon to nakala' kombongan Zelot; anna Yudas Iskariot to la umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ussuami inde sapulo dua rasulna Puang Yesus-e, anna pakari'di'i nakua: “Daua' lu lako tondokna to tangngia to Yahudi, battu lako mesa tondokna to Samaria. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sapo la laokoa' umpellambi'i to Israel, to umpemboko'imo Puang Allata'alla sirapan domba pa'de. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Palandasanni lako kumua madappi'mi kasaeanna kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pomalapu'koa' to masaki, patuokoa' sule to mate, pomalapu'koa' to dolengan, ammu rambaia' lao setang illalan mai kalena tau. Inde kakuasaanne dibeen babangkoa', iamo too la mupebeen babang duka'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Daua' umbaa doi', susi doi' bulawan, doi' pera', battu' doi' gallang. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Daua' umbaa kinallo illalan penonosammu, tae'koa' la umbaa bayu pessondaan, sandala', anna tekken. Annu angganna to mengkarang innang la sipato' diitaan kaparalluanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ianna saekoa' lako mesa tondok, peangngia' to la ungkarimbai manappakoa', ammu pamesa angngenammu dio sae lako attunna la untampekoa' tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ianna la tamakoa' mesa banua, la mukuaa': ‘Anna tamba'morokoa' Dewata.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ianna nakarimbai manappakoa' to ma'banua, la ullolongan pa'tamba'mua'. Sapo ianna tae'koa' nakarimbai, la sule lako kalemua' pa'tamba'mu. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Anggaria, ke dengan to ma'banua battu mesa tondok tae' untarimakoa', pelleia' lao ammu tambakkia' soyokna dio mai lentekmu, la tandana kumua mutumpu pala'mia'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Annu kutulasangkoa' sitonganna, ianna nalambi'mo allo nangei umbisara ma'rupa tau Puang Allata'alla, marru la mabanda' ia perambinna Puang Allata'alla lako to illalan itin tondokko anna la to dio kota Sodom anna Gomora.” ");
INSERT INTO mqjNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Pengkilalai manappaia', la sirapangkoa' domba la kusua tama alla'-alla'na serigala. La matangkingkoa' susi ula' anna la malenna' penawakoa' sirapan dangan-dangan. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Matangkingkoa' lako angganna tau annu la dengan umpopengngolokoa' lako pa'bisara aluk, anna la nakambeikoa' illalan banua pa'sambayanganna. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","La dibaakoa' lako tingngayona to ma'parenta anna tomaraya annu muturu'na'. Attu iamo too la mungeia' umpa'pesa'bianna' lako to ma'parenta sola tomaraya anna lako to salianna to Yahudi battu dikua to tangngummissanan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ianna la dibisaramokoa', daua' pomasussa penawammu umpikki' aka la mutula' annu angganna la mupokadanna la nabengangkoa' Puang Allata'alla ke diomokoa' olona pa'bisara. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Annu sitonganna tangngikoa' la mantula', sapo Penawa Maserona Ambemu yao suruga illalan kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","La dengan attunna dengan tau la umpopepatei sirondongna. Susi toi duka' ambe lako anakna anna anak la umbali to matuanna lambisan napopepatei. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","La nakabassikoa' angganna tau annu muturu'na'. Sapo benna-benna ke'de' matoto' illalan kapangngoreananna sae lako kasuppikanna kamasussaan, tau iatoo la dipasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ianna didarrakoa' dio mesa tondok, alaikoa' kalemu ammu lu lako tondok senga'. Kutulasangkoa' sitonganna, ta'pa la suppik tondok illalan lembangna Israel mulelean, anna saemo sule Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tae' dengan leleanna mesa passikola la untanda langnganni tuanggurunna, battu mesa sabua' la untondon kamatandeanna puangna. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kalandomia ke susimi manarangna tuanggurunna passikola, anna pada angga' puangna sabua'. Ianna to titanan ambemo illalan banua nagente' tau ponggawana setang, la dapakaia issinna banua. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sapo daua' marea' lako itin matin tauo, annu tae' dengan kara-kara membuni tae' la dipa'peissanan anna tae' dengan kara-kara disamboi tae' la dipakawanan. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Angganna tula'ku lako kalemua' tae'na kupa'perangngian lako tau senga', la mutetteran illalan alla'-alla'na tau kamban, anna mentu'na tula' kubisikkiangkoa' la mupa'peassakan lako angganna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Daua' marea' lako to angga batang kale naissan napatei sapo tae' ummampui kakuasaan umpatei batang sunga'. Sapo mengkarea' langngangkoa' Puang Allata'alla to ma'kuasa undarra batang sunga' anna batang kale illalan naraka. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Taissanan kumua dua dena' angga mesa doi' bassi randan barinni' allinna. Sapo moika anna susi too, tae' dengan moi mesamo tokke' la bonno' babang ke tangngia pa'kuanna Ambemu yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","La dapakaia ikoa' annu sae lako lamba' beluakmua' mangka nareken. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iamo too daua' marea', annu marru keangga'koa' iko anna la messa'bu dena'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Benna-benna ummakuina' dio tingngayona ma'rupa tau, la kuakui duka' dio olona Ambeku yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sapo benna-benna untelangna' dio tingngayona ma'rupa tau, la kutelang duka' dio olona Ambeku yao suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Daua' anna kendek illalan penawammu kumua kasaeangku tama lino la umpakendek kasikalinoan. Tae'nakkao sae la umpakendek kasikalinoan sapo kasisala-salaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Annu kasaeangku tama lino la umpasibokosan ambe anna anakna muane, baine la sibokosan indona, anna manintu baine la sibokosan matukanna baine, ");
INSERT INTO mqjNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","battu' dikua to ma'rapu la sisala-sala. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Benna-benna marru umpakalando to matuanna anna la kaleku, tau iatoo tae' la sipato' mendadi petauangku. Susi duka' to marru umpakalando anakna anna la kaleku tae' la sipato' mendadi petauangku. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Benna-benna tae' umpassan kayu pantokesanna anna turu'na', tau iatoo tae' la sipato' mendadi petauangku. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Benna-benna umpa'kadua-duai katuoan illalan lino, tau iatoo la ungkasayu'i katuoan sae lako-lakona. Sapo benna-benna nadotaan mate annu naturu'na', la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Benna-benna untarimakoa', sirapammi kaleku melolo natarima. Anna benna-benna untarimana', untarima duka' to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Benna-benna untarima manappa mesa nabi annu naissanan kumua nabi, tau iatoo la untarima sarona nabi. Anna benna-benna untarima manappa mesa to malolo annu naissanan kumua to malolo, tau iatoo la untarima sarona to malolo. ");
INSERT INTO mqjNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Anna benna-benna untandoi moi wai kula' babangmo inde to randan wiring rokko annu naissanan kumua passikolakue, manassa anna la untarima sarona.” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mangkai umparunduk sapulo dua rasulna, mengkalaomi Puang Yesus ullelean tondok illalan lembangna Galilea ma'pa'tudu anna umpalanda' Kareba Kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Attu iatoo illalan tarungkun Yohanes to simantedok. Sapo umpekareba duka' pengkaranganna Kristus, napolalan ussua pira-pira passikolana lao mekutana lako Puang Yesus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ikomoka to nadandi Puang Allata'alla la sae, dengampika tau senga' la kiampai?” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Natimba' Puang Yesus nakua: “Sulemokoa' ammu tulasanni Yohanes angga murangnginna sola muitanna, ");
INSERT INTO mqjNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","susinna to buta mala paita, to balimbingan mala menono', to dolengan monda dolengna, to taru mala parangngi, to mate tuo sule, anna Kareba Kadoresan dipalanda' lako to mase-mase. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kerongko' angganna to tae' tikanna penawanna ummitana'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Le'bai passikolana Yohanes, mantula'mi Puang Yesus lako tau buda untetteran Yohanes nakua: “Aka lao mutungkaa' lako padang alla'? Laorokoka umpetua' tille napalurekke lu sau' bara'? ");
INSERT INTO mqjNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akara lao mutungka lakoa'i? Laorokoka umpetua' to ma'pakean maleke? Sapo dio ia banuanna tomaraya to ma'pakean maleke. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dadi akara lao mutungka lakoa'? Laorokoka umpetua' nabi? Tonganna. Anna nasanga Kao kadangku tanda langnganna nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Annu Yohanesmo napatu battakadanna Puang Allata'alla nakua: ‘Indemi pesuangkue, kusuami uyyoloanangko annu la napatokangko lalan la muola.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kutulasangkoa' sitonganna, tae' dengan tau illalan lino la untondon Yohanes to simantedok. Sapo marru natondon to randan barinni' illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mengkalao dio mane naparanduk Yohanes to simantedok umpalanda' Kareba Kadoresan sae lako temo, dengan liumi to kadake gau' umbali kaparentaanna Puang Allata'alla anna umpeang liu lalan la naola urrappai. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mengkalao dio sura'na Musa anna angganna nabi sae lako Yohanes untetteran asan kara-kara la dadi. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ianna moraikoa' la ummorean tula'ku, kupokadangkoa' kumua Yohanesmo napatu battakadanna nabi yolona kumua la sae sule Elia. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","La napatananni manappa talinga ma'rupa tau inde tula'kue. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Akamo la kupasirapanan inde ma'rupa tau lapik temoe? La kupasirapan anak sipa'loko-lokoan lako pasa' anna ummalo'-alo' solana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kipa'tulaliangkoa' sapo mokakoa' sumayo. Kioyongangkoa' penanian pa'barataan sapo mokakoa' umbating.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Annu sae Yohanes sima'puasa anna tae' siummiru' anggur, sapo nakua tau: ‘To natamai setang.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tapakala sae duka' Anak Mentolino, siummande anna ummiru' anggur, nakuaomo tau: ‘Petua'ria' to poppokan, pangngiru', solana tuang passima anna to kadake.’ Sapo moika anna susi too, kakeakasannaria Puang Allata'alla napakawanan illalan angganna pa'palakona.” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mangkai too, naparandukmi Puang Yesus ussassai issinna tondok randan pembuda nangei umpadadi tanda memangnga-mangnga annu moka mengkatoba', nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“La sanggangkoa' to Khorazim anna kota Betsaida annu kela dadi dioi Tirus anna Sidon tanda memangnga-mangnga mangka dadi illalan alla'-alla'mua' masaemo anna mengkatoba' tau dio, lambisan ma'pakean barata annu umpenassanni gau'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dadi kupokadangkoa' temo: ianna nalambi'mo allo la dingei umbisara ma'rupa tau, la maringngan ia perambinna Puang Allata'alla lako issinna kota Tirus sola Sidon anna la ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Anna ikoa' to dio Kapernaum, musangarika la diangka'koa' langngan suruga? Tae', sapo la ditibe tamakoa' naraka. Annu kela dadi dioi Sodom tanda memangnga-mangnga kupadadi illalan alla'-alla'mua', tae' la natallanni Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dadi kupokadangkoa' temo: ianna nalambi'mo allo dingei umbisara ma'rupa tau, la maringngan ia perambinna Puang Allata'alla lako issinna kota Sodom anna la ikoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Attu iatoo ma'sambayang Puang Yesus nakua: “O Ambe', Dewatanna langi' anna lino. Ma'kurru' sumanga'na' matin, annu angganna tula' dibuni mengkalao dio mai mupakawanammi lako to naangga' barinni' ma'rupa tau, sapo tontong mubuni lako to naangga' manarang anna to nagente' keaka' ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Ambeku iamo te pa'kuammue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mangkai ma'sambayang, nakuamo: “Angganna kara-kara mangka asammi napalessu' rokko lisu pala'ku Ambeku. Tae' dengan moi mesamo ma'rupa tau ummissanan Anakna Puang Allata'alla salianna Ambeku, tae' toi dengan moi mesamo ma'rupa tau la ummissanan Ambeku salianna Anakna, anna to naporai Anakna napaissanni. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maikoa' umpellambi'ina' anggammu to malupu' anna to mabanda' passanammu angku patialangkoa' penawammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Turu'i parentaku ammu melaya' lako kaleku annu malenna' penawana' anna marampan penawa napolalan tiala penawammua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Annu mentu'na parentaku mepomasannang, anna bawaan kupapassanniangkoa' maringngan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pissan attu sirupang allo katorroan ummola bela' gandum Puang Yesus sola passikolana. Ummolai lalan napasiolaan siami passikolana ummala gandum anna andei annu tadea'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dengan to Farisi ummitai, napolalan ma'kada lako Puang Yesus nakua: “Petua'ri passikolamu umpogau'mi tala malanna dikarang ke allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Natimba' Puang Yesus nakua: “Ta'raka dengan mubaca pa'palakona Daud sola to unturu'i anna tadea'? ");
INSERT INTO mqjNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Attu iatoo lu tama angngenan kapemalasan Daud anna ummala roti mangka dipemalasan anna andei sola to turu'i, moika anna angga imam mala ummandei. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ta'paka liu dengan mubaca illalan sura'na Musa kumua ullenda duka' sangka'na allo katorroan imam illalan Banua Ada'na Puang Allata'alla, sapo tae' dipasala? ");
INSERT INTO mqjNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Paillalan penawaia' inde tula'kue: Dengan tau inde rokko temoe marru untondon Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dengan tiuki' illalan Buku Masero nakua: ‘Pa'kamase randan kupemulu, tangngia olo'-olo' dipopemala'.’ Ianna muissanan manappa te kalembasanna battakadae, manassa anna tae'koa' la umpasala to tangkasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Annu Anak Mentolinomo puangna allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mengkalaomi Puang Yesus untampe angngenan iatoo, anna lu tama mesa banua pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Illalan inde pa'sambayanganne, dengan mesa tau mate limanna sabali. Dengan pira-pira to morai la umpeangan kasalaan Puang Yesus napolalan mekutana nakua: “Malarika tau umpomalapu' to masaki ke allo katorroan?” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Natimba' Puang Yesus nakua: “Pa'rapanan dengangkoa' ummampui mesa domba anna melontin rokko garotin sapo sirupang allo katorroan, tae'ka la lao naangkaran dio mai? ");
INSERT INTO mqjNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tae'ka marru keangga' ia ma'rupa tau anna la domba? Dadi sitonganna tae' la didapai tau umpogau' kamapiaan ke allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mangkai too, nakuamo Puang Yesus lako inde to mate limannae: “Ette'i limammu!” Naette'mi, monda siami anna matoro susi lima sabalinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Umpelleimi banua pa'sambayangan inde mai to Farisie anna umpamesa kada la umpatei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sapo naissanan Puang Yesus kumua marassan nalilingan tangnga' to Farisi, napolalan le'ba umpellei angngenan iatoo anna buda tau ummula'i. Angganna to masaki to ummula' Puang Yesus napomalapu' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sapo ma'pakari'di' Puang Yesus kenamala inde mai taue tae' umpa'peissanan Puang Yesus lako tau senga', ");
INSERT INTO mqjNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","anna malara lemba' battakadanna Puang Allata'alla mangka napalanda' nabi Yesaya nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Petua'i, iamo te Pesuangkue to mangka kupile, to kukamasei anna to umpomasannang penawangku; la kupatama kalena Penawangku, anna la ussewangan kamaloloangku lako mentu'na ma'rupa tau botto-ma'botto. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tae' la sipekka tau, tae' la metamba-tamba, tae' toi la mealo'-alo' mantula' dio tingngayona tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","La malenna' penawa lako to malamma, sirapan tallang polo tangnga tae' la natattakki pissan lao, anna sirapan ballo ma'mio'-mio' tae' la napi'dean pissan. La tontong nakarang sae lako attunna umpopatalo kamaloloan. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mentu'na ma'rupa tau botto-ma'botto la parannu lako kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mangkai too, saemi pira-pira tau umbaa mesa to buta sola tae' naissan mantula' annu natamai setang. Napomalapu'mi Puang Yesus napolalan mala paita anna naissammo mantula'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mangnga-mangnga asammi to ummitai anna ma'kada nakua: “Umbai iamo inde peampoanna tomaraya Daud masaemo diampaie.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tappana narangngi to Farisi, nakuamo: “Kuasanna Beelzebul battu' dikua ponggawana setang illalan kalena napolalan mala urrambai lao setang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sapo nalosa penawanna Puang Yesus napolalan ma'kada lako to Farisi nakua: “Ianna dengan mesa kaparentaan tae' mesa penawa rupa taunna, manassa anna la sanggang. Susi toi duka' ke denganni mesa tondok battu' mesa pendaposan tae' mesa penawa tau illalan, manassa anna la tae' matoto'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Susimi duka' kaparentaanna setang. Ianna la urrambaimo lao setang ponggawana setang, manassa anna tae' mesa penawa napolalan sisarak-sarak. Umbamo la nakua ke'de' matoto' kaparentaanna? ");
INSERT INTO mqjNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mukuaa' kakuasaanna Beelzebul kupake urrambai lao setang. Ianna susi too, kakuasaan aka napake to unturu'koa' urrambai lao setang? Iamo tu matin to unturu'koa'o la umpakawananni kumua sala pikki'koa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sapo sitonganna kakuasaanna Penawanna Puang Allata'alla kupolalan mala urrambai lao setang. Kalembasanna umpalakomi kaparentaanna Puang Allata'alla illalan alla'-alla'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Umbamo la nakua to maboko untamai banuanna mesa to matoro anna alai ewananna ke tae' napungo yolo? Mangkapi napungo anna mane mala ummala ewananna inde to matoroe. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Angganna to tae' unturu'na', nabalina' anna angganna to tae' ussolanna' marrempun, tau iatoo ma'pasisarak-sarak. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iamo too kupokadangkoa' matin kumua: Angganna kasalaan anna pa'telle mala asan nagarri'i Puang Allata'alla, sapo benna-benna untelle Penawa Masero tae' tongan-tongan mala digarri'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ianna dengan tau untelle Anak Mentolino mala digarri'i. Sapo ianna Penawa Maseromo natelle tae' dengan leleanna la digarri'i la susi illalampi lino tenni dio lino tanda lako. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ianna mapia tuona mesa to' kayu, mapia duka' buana. Sapo ianna mapakko', kadake duka' buana. Simesa-mesa to' kayu mala diissanan ke diitami buana. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","To kadakekoa'! Tae' dengan leleanna la mapia pessuunan pudukmua' annu innang to kadakekoa'. Annu angganna battakada mengkalao illalan asan unak penawa. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Angganna to mapia penawa, manassa anna mapia duka' pessuunan pudukna annu mapia illalan unak penawanna. Sapo lako to kadake, manassa anna kadake pessuunan pudukna annu innang kadake illalan unak penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dadi kupokadangkoa' temo: Angganna battakada umpa'di' padanna, pantan la napa'timpasan tau dio olona Puang Allata'alla ke nalambi'mi allo dingei umbisara ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Annu pessuunan pudukmumoa' la dipolalan ummangga' malolokoa', anna pessuunan pudukmu siamoa' duka' la dipolalan umpabambannikoa' sangka'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Attu iatoo dengan pira-pira to untarru' issinna sura'na Musa anna to Farisi ma'kada lako Puang Yesus nakua: “O tuangguru, moraikan la ummita tanda memangnga-mangnga mupadadi anna malara kiissanan kumua lu yao tongangko mai Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sapo natimba' Puang Yesus nakua: “Marru kadake gau' tongan inde ma'rupa tau lapik temoe anna tae' matutu langngan Puang Allata'alla annu morai la kupadadian tanda. Sapo tae'koa' la dipadadian tanda senga' salianna tanda susi dadi lako nabi Yunus. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Annu susi Yunus yolona tallungngallo tallu bongi illalan tambuk be'dok, la nakuamo duka' Anak Mentolino la tallungngallo tallu bongi illalan liang. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ianna tallammo lino, la dipatuomi sule to Niniwe sola ikoa' to tuo lapik temo anna la napasalakoa'. Annu tappana urrangngi kadanna Puang Allata'alla napalanda' Yunus mengkatoba'mi to Niniwe. Sapo mokakoa' iko mengkatoba', moi kenada marru untondon Yunus to umpantula'ikoa' temo. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anna ianna tallammo lino, la dipatuomi sule tomaraya baine to umparenta lembangna Syeba yolona sola ikoa' to tuo lapik temo. La napasalakoa' annu mambela ia naola lao umperangngii kakeakasanna tomaraya Salomo, sapo temo dengan inde to marru untondon tomaraya Salomo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ianna mallaimo setang illalan mai kalena mesa tau, lu rekke lu sau'mi dio padang alla' umpeang angngenan la nangei torro. Sapo tae' dengan angngenan nalambi'. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nakuamo: ‘La ma'pasulena' lako angngenan kutampe.’ Sule tongammi, lo'bang liupi inde angngenan nalambi'e, sirapan banua mapatting mangka disapui anna mangka direpi' manappa issinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Le'ba siami lao untambai pitu setang marru kadake, anna torro asan illalan kalena inde taue. Katampakan tuttuan mabanda' kamaparrisan ullambi' inde taue. La susimi duka' ullambi' to kadake lapik temo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Marassampi mantula' Puang Yesus lako tau buda, saemi indona sola sirondongna ke'de' dio salian morai la umpellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dengammi tau ma'kada lako Puang Yesus nakua: “O Tuangguru, illalan salian indomu sola sirondongmu, morai la umpellambi'iko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Natimba' Puang Yesus nakua: “Bennara Kao indoku sola sirondongku?” ");
INSERT INTO mqjNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Anna mane unturo passikolana napasiolaan ma'kada nakua: “Iamo te mai indoku anna sirondongkue. ");
INSERT INTO mqjNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Annu benna-benna umpogau' pa'kuanna Ambeku yao suruga, iamo sirondongku muane anna sirondongku baine sola indoku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Allo ia siamo too anna mengkalao Puang Yesus umpellei inde banuae lu lako biring Tasik Galilea anna ma'loko dio la ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Saemi buda tau ma'silullu' umpellambi'i napolalan lu langngan lopi illalan tasik anna ummokko' yao, anna inde tau budae sikake'de' dio biring tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Umpalanda'mi buda pepa'guruan Puang Yesus sapo ummolai tandengan nakua: “Dengan mesa tau lao mangngambo'. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Marassanni mangngambo', dengammi bannena tappa lako lalan. Saemi dassi ummandei sapuranna. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dengan duka' bannena tappa lako litak mabatu, napolalan masimpan tuo annu manippi' litakna. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sapo tappana nadellekki allo, malayumi napolalan marekko' annu tae' mandalan waka'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dengan toi bannena tappa tama to' duri. Tuttuan marumbomi to' duri ungkessu' inde tanananne samatena. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sapo dengan duka' bannena tappa rokko litak malunak napolalan kembua barri'. Dengan tiluppi' pessaratu', dengan tiluppi' pennannan pulona anna dengan tiluppi' pentallu pulo. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","La napatananni manappa talinga ma'rupa tau inde tula'kue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mangkai too, nadendeimi passikolana anna kutanaii nakua: “O Tuangguru, maakari anna tandengan mupake ma'patudu lako tau buda?” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Natimba' nakua: “Annu angga ikoa' dipabeai ummissanan tula' dibuni mengkalao dio mai, iamo tula' untetteran kaparentaanna Puang Allata'alla, sapo tae' ia dipaissanni inde lako taue. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Annu benna-benna ummampui kapaissanan, la dirangngannian polei, napolalan tuttuan buda kapaissananna. Sapo benna-benna tae' ummampui kapaissanan, la dialai pissan kapaissanan nasanga dengammo illalan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iamo nangei tandengammo sikutula' lako tau buda sullena naita sapo tae' la tamai akkalanna, anna sullena umpalempe pa'perangnginna sapo tae' la natamai pikki'na anna tae' la naissan napekalembasan. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Napolalan lemba' battakadanna Puang Allata'alla mangka napalanda' nabi Yesaya nakua: ‘La narangngi liu, sapo tae' la natamai pikki'na, anna la naita liu, sapo tae' la natamai akkalanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Annu inde mai taue makarra'mi penawanna, ta'mo parangngi talinganna, anna ta'mo paita matanna. Ianna tae' susi la paita matanna, parangngi talinganna, anna la naissan napekalembasan napolalan ma'pasule lako kaleku lambisan kupomalapu'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sapo kerongko'koa' iko annu paita matammua' anna parangngi talingammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Annu kupokadangkoa' sitonganna, buda nabi anna to malolo yolona morai la ummita kara-kara muita temoa' sapo tae' naita, anna morai la urrangngi battakada murangngia' temo sapo tae' narangngi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Patananni manappaia' talinga kalembasanna inde tandengan to mangngambo'e. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Banne tappa lako lalan, kalembasanna to urrangngi battakada untetteran kaparentaanna Puang Allata'alla, sapo tae' naissan napekalembasan. Saemi ponggawana setang urrappa inde banne mangka diambo' illalan penawannae. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Banne tappa lako litak mabatu, kalembasanna to urrangngi battakadanna Puang Allata'alla anna tappa masannang untarimai. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sapo tae' kenwaka' illalan penawanna napolalan tae' masae anna pa'demo. Ianna unduppamo kamaparrisan battu pandarraan ura'na battakada iatoo tappa ma'sorong boko'mi. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Banne tappa tama to' duri kalembasanna to urrangngi battakadanna Puang Allata'alla, sapo malallan umpikki' katuoanna illalan lino anna anggamo kamoraian la untombon ewanan illalan penawanna ungkessu' battakada mangka narangngi napolalan tae' kembua. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anna banne tappa rokko litak malunak, kalembasanna to urrangngi battakadanna Puang Allata'alla anna napekalembasan manappa, napolalan kembua barri'. Dengan tiluppi' pessaratu', dengan tiluppi' pennannan pulona, anna dengan tiluppi' pentallu pulo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dengan polepi tandengan senga' naulelean Puang Yesus lako tau kamban nakua: “Kaparentaanna Puang Allata'alla dipasirapan to ummambo' banne mapia dio bela'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sapo mamma' asanni tau, saemi ewalinna untantan bungan rea tama alla'na gandum, anna mane le'ba sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tuoi gandum anna naparandukmo suun buana, tandaammi duka' rea. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Saemi to mengkarangna umpellambi'i puangna bela' anna kuanni: ‘O tuang, kusanga banne mapia muambo' rokko bela'mu. Maakaria anna dengan rea tuo dio mai?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Natimba' puangna bela' nakua: ‘Pa'palakona ewalinta.’ Nakuamo to mengkarangna: ‘Umba nakua ke laoi kirebu'i reana?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Natimba' puangna bela' nakua: ‘Tae', annu ianna murebu'i itin reao la tirebu' duka' gandum napa'toang. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabeai mammi tuo sola sae lako attunna la disae' gandum. Attu iatoo la kukua lako to massae': Rempunnia' yolo itin reao, pantan uyunni anna mane disumpunni. Ammu mane rempunanna' gandumku ammu annanna' langngan alangku.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Untetteran pole omi mesa tandengan senga' Puang Yesus lako tau kamban nakua: “Kaparentaanna Puang Allata'alla sirapan lise' sawi natanan tau dio bela' utanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Angganna tananan ma'lise', lise' sawimo randan barinni'. Sapo ianna tuomo, marru kamai ia anna utan senga' lambisan pada to' kayu, napolalan mala nangei kesserang dassi tangkena.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anna mane ummala pole mesa tandengan senga' nakua: “Kaparentaanna Puang Allata'alla mala duka' dipasirapan ragi naala baine anna boloianni tappung pennappa' tapulo lite' napolalan kembea'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Angganna te maie natula' Puang Yesus lako tau buda umpake tandengan. Anna tae' dengan simantula' lako tau buda ke tae' umpake tandengan, ");
INSERT INTO mqjNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","anna malara lemba' battakadanna Puang Allata'alla napalanda' mesa nabi nakua: “La ummoyongna' tandengan ke ma'pa'guruna'. La untetteranna' kara-kara membuni mengkalao dio mai pa'parandukanna lino.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mangkai mantula' Puang Yesus lako tau buda, napelleimi anna lu tama mesa banua. Napellambi'imi passikolana anna kuanni: “Kenamala mutetteranangkan kalembasanna tandengan rea illalan alla' gandum.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Natetteranammi nakua: “Inde to ummambo' gandum-e iamo Anak Mentolino, ");
INSERT INTO mqjNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","anna linomo sirapan bela'na. Gandum, iamo petauanna Puang Allata'alla, anna rea, iamo to unturu' ponggawana setang. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ewali to sae untantan bungan rea, iamo ponggawana setang. Attunna disae' gandum, iamo allo katallananna lino. Anna to massae' iamo malaeka'. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Susi rea dirempun anna mane ditibe tama api, la nakuamo duka' ullambi' to unturu' ponggawana setang ke tallammi lino. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Annu la ussua malaeka'na Anak Mentolino urrempun angganna to untumang tau kasalaan sola angganna to siumpogau' kakadakean naalai illalan mai kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Anna ditibe asan tama api ma'lana-lana. Sikatangi' pole' napobua' kamaparrisan anna tikarasissik isinna illalan angngenan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sapo mentu'na to umpogau' pa'kuanna Puang Allata'alla pasilong susi mata allo illalan kaparentaanna Ambena yao suruga. La napatananni manappa talinga ma'rupa tau inde tula'kue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kaparentaanna Puang Allata'alla sirapan ewanan dilamun illalan bela' nakabuttui mesa tau. Natambunnimi sule anna mane lao umbaluk angganna ewananna annu dore' sigalimi anna sule ummalli inde bela'e. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kaparentaanna Puang Allata'alla sirapan duka' mesa pa'baluk umpeang mutiara randan maleke. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nalambi'i, laomi umbaluk angganna ewananna anna mane ma'pasule ummalli inde mutiarae.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kaparentaanna Puang Allata'alla sirapan dala natibe tau tama tasik lambisan ummala sangga' rupanna be'dok. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ponnoi inde dalae, narui'mi langngan gantanan anna ma'loko umpilei be'dok mapia napatama pa'pengngeanna, anna be'dok kadake natibe lao. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","La susimi duka' ke tallammi lino, annu la sae malaeka' tama lino pantan umpopa'mesa to kadake anna to unturu' pa'kuanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","To kadake la ditibe tama api ma'lana-lana napolalan sikatangi' napobua' kamaparrisan anna tikarasissik isinna illalan angngenan iatoo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mekutanami Puang Yesus lako passikolana nakua: “Muissanangka kalembasanna inde tula'kue?” Natimba' passikolana nakua: “Io, kiissanan kalembasanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nakuamo Puang Yesus: “Iamo nangei angganna to untarru' issinna sura'na Musa to untarimamo kaparentaan suruga mala dipasirapan mesa to ma'banua ummaroi ewananna illalan mai pa'pengngeanna susi malusanna tenni bakarunna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mangka asanni untula' tandengan Puang Yesus, mengkalaomi untampe angngenan iatoo ");
INSERT INTO mqjNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma'pasule lako tondokna. Saei lako, ma'patudumi illalan pa'sambayanganna to Yahudi. Mangnga-mangnga asan to urrangngii lambisan sipantula'-tula' nakua: “Umbamo nangei ummala kakeakasan inde taue anna bennamo umbenganni kakuasaan umpogau' tanda memangnga-mangnga? ");
INSERT INTO mqjNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Anna umbai anakna te tukan kayue? Disanga Maria indona anna sirondongna disanga Yakobus, Yusuf, Simon anna Yudas. ");
INSERT INTO mqjNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Anna umbai sisola siamikia' inde angganna anak daranna? Umbamo nangei ummala kakeakasan sola kakuasaan?” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Katampakanna untumpu pala' Puang Yesus. Ma'kadami Puang Yesus nakua: “Mesa nabi diangga' dio angngenan senga', sapo tae' diangga' dio tondokna anna illalan banuanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iamo nangei tae' sirua tanda memangnga-mangnga napadadi Puang Yesus dio tondokna annu tae' naorean tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Attu iatoo napelele duka' Herodes tomaraya dio lembangna Galilea diona pengkaranganna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nakuamo lako to mengkarangna: “Itin nakuan tau Yesus-o, Yohanes to simantedokmo tuo sule dio mai alla'na to mate napolalan ummampuimo kakuasaan umpogau' tanda memangnga-mangnga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ia nangei ma'pikki' susi Herodes annu kalena umpopepealai Yohanes anna pungoi anna mane popetarungkunni natumang Herodias bainena sirondongna Herodes disanga Filipus. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Annu nakambaroan Yohanes nakua: “Pemali tongan-tongan la umpobaineko Herodias.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sitonganna morai Herodes la umpatei Yohanes attu iatoo, sapo marea' lako to Yahudi annu buda tau ummangga'i nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tapakala umpakaraya allo kadadianna Herodes, sumayo anakna Herodias baine dio tingngayona Herodes sola to saena anna tiala penawanna Herodes ummitai, ");
INSERT INTO mqjNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","napolalan ma'pinda lako kumua iamo napelau iamo nabenganni. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mangkai naparunduk indona, nakuamo lako tomaraya: “La mubeenna' ulunna Yohanes to simantedok dipadio pappalan temo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tila'bak siami buana Herodes, sapo ta'mo naissan nasumbala annu mangkami ma'pinda narangngi to saena, napolalan ussuamo tantarana umpaolaanni pelaunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ussuami tau lao ullempo'i ulunna Yohanes tama pa'tarungkunan. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tae' masae, saemi dibaa ulunna Yohanes dipadio pappalan anna dibeen lako inde bainee. Naalami anna baanni lako indona. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mangkaii, saemi passikolana Yohanes to simantedok ummalai batang rabukna anna lamunni. Anna mane lao untetteranni lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Urrangnginna kareba kamateanna Yohanes Puang Yesus, langngan siami lopi anna mengkalao umpellei angngenan iatoo lu lako angngenan maitu-itu la ungkambela tau buda. Sapo naissanan tau buda kumua le'ba napolalan mengkalao untampe tondokna mangngola gantanan ummula'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Turunni Puang Yesus yao mai lopi, ummitami tau buda lambisan rantang buana anna umpomalapu' angganna to masaki illalan alla'-alla'na inde tau budae. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Karuenni, napellambi'imi passikolana anna kuanni: “La bongimi anna indekia' ala' padang. Umbai mapia ke musuami le'ba inde lako taue anna lao ummalli nande lako tondok sikadappi'ta.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sapo natimba' Puang Yesus nakua: “Tae' manggi' lao annu ikoa' la umpandei.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nakuamo passikolana: “Angga lima roti anna dua be'dok kiampui.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Natimba' Puang Yesus nakua: “Baanna' mai.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ussuami tau ma'loko lako pasang, anna ummala lima roti anna dua be'dok, anna mane mentungngu langngan langi' ma'kurru' sumanga'. Mangkai, umpiak-piakmi roti anna beenni passikolana natawaan lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ummande asammi tau buda sadea'na. Mangkai ummande, narempummi passikolana ra'dakna tau buda, ponnopi sapulo dua baka. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Inde to ummandee umbai lima sa'bu muane, ta'pa ia direken baine sola anak. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mangkai too, ussuami passikolana Puang Yesus langngan lopi anna yolo lamban lian, anna ussua duka' tau buda ma'pasule. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Le'ba asanni tau lu langngammi tanete Puang Yesus mesai la lao ma'sambayang. Yao liumi tanete sae lako bongi. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Attu iatoo mambelami naola lopinna passikolana umpellei biring tasik. Inde lopie napalurekke lu sau' bombang annu natammui bara' kamai. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nannarii, saemi Puang Yesus umpellambi'i passikolana menono' yao lolok wai. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Naitanna passikolana menono' yao lolok wai, marea' asammi anna sikakillong nakua: “Dio mai anitu!” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sapo tappa ma'kada Puang Yesus nakua: “Pamattannia' penawammu, dau marea', Kaori Kao tee.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nakuamo Petrus: “O Puang, ianna Iko tongan, popenono'na' duka' yao lolok wai angku matin umpellambi'iko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Natimba' Puang Yesus nakua: “Maimoko.” Turun siami Petrus yao mai lopi anna menono' yao lolok wai lao umpellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sapo tappana ussa'ding bara' kamai, marea' siami napolalan la limmi'. Mealo'-alo'mi nakua: “O Puang, kamaseina'!” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Natandoimi limanna Puang Yesus anna kuanni: “Tae' lantuk kapangngoreanammu. Maakari anna selang penawammu?” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kendekmi langngan lopi duai, mattan siami duka' bara'. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Angganna to yao lopi menomba lako Puang Yesus, napasiolaan ma'kada nakua: “Anakna tongangko Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lambanni lian sore sambali'mi Genesaret lopinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Naitanna tau kumua sae Puang Yesus, umpasilele siami kareba illalan lili'na tondok iatoo, napolalan angganna to masaki dibaa lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Napelaumi kenamala napabeai urrumbui moi tampak bayu rui'namo. Anna angganna to urrumbui malapu' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tapakala, saemo dio mai Yerusalem pira-pira to Farisi anna to untarru' issinna sura'na Musa umpellambi'i Puang Yesus anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Maakari anna ullenda kabeasaanna neneta passikolamu? Tae' umbasei limanna situru' kabeasaanta anna mane ummande.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Natimba' Puang Yesus nakua: “Maakari ammu lenda duka' parentana Puang Allata'alla umpalako kabeasaammua'? ");
INSERT INTO mqjNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Annu ma'kada Puang Allata'alla nakua: ‘Pakasalleko ambemu sola indomu.’ Anna nakua polepa: ‘Benna-benna untula' kadake ambena battu' indona, la dipatei.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sapo simukua ikoa': ‘Benna-benna ma'kada lako ambena battu indona nakua: Ambo' dengan la kutandoiangkoa', sapo' mangkami kupopemala' langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tau iatoo ta'mo parallu umpakasalle ambena battu indona.’ Dadi umpa'barinni'ikoa' iko battakadanna Puang Allata'alla napobua' kabeasaammua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sangngin to ma'dua tambukkoa'. Tonganna battakadanna Puang Allata'alla mangka napalanda' nabi Yesaya untula'koa' nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Itin matin tauo angga dio pudukna umpakasallena', sapo sitonganna illalan penawanna napemboko'ina'. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Alla'mo' napenombai annu angga pepa'guruan ma'rupa tau napa'patuduan.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mangkai too, untambaimi tau buda Puang Yesus anna pantula'i nakua: “Perangngi manappaia' tula'ku ammu pengkalesoii. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tangngia lu tamanna sadang ungkadakei ma'rupa tau dio olona Puang Allata'alla, sapo suunna dio pudukna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nadendeimi passikolana anna kuanni: “O Tuangguru, muissanangka kumua tula'mu angngena' umpatikanna penawanna to Farisi?” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Natimba' Puang Yesus nakua: “Angganna tananan tangngianna pantananna Ambeku yao suruga la direbu'i sae rokko waka'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Parandan mammi, annu itin lako tauo sirapan to buta untette to buta. Ianna to butamo untette to buta innang bassi la metobang rokko garotin.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nakuamo Petrus: “O Tuangguru, tetteranangkan kalembasanna itin tandenganno.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma'kada Puang Yesus nakua: “Ta'paka iko duka' mupekalembasan? ");
INSERT INTO mqjNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ta'raka muissanan kumua angganna lu tamanna sadang le'ba rokko tambuk anna tarru' ditibe lao. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sapo suunnaria dio puduk mengkalao illalan penawa ungkadakei ma'rupa tau dio olona Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Annu illalan penawa nangei kendek kakadakean susinna: pikki' kadake, papatean, ullullu' pa'bannetauan, gau' meko'do'-ko'do', maboko, sa'bi tatongan, anna pa'telle. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iamo te maie ungkadakei ma'rupa tau dio olona Puang Allata'alla, tangngia tokke' ummande tae' membase.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mangkai too, mengkalaomi Puang Yesus umpellei angngenan iatoo lu lako lembangna Tirus sola Sidon. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Saemi napellambi'i mesa baine to Kanaan anna metamba-tamba nakua: “O Puang, peampoanna tomaraya Daud, kamaseina'. Dengan anakku baine natamai setang anna marru mapa'di'mo nasa'ding.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sapo tae' dengan natimba'i Puang Yesus. Napengkadappi'imi passikolana anna kuanni: “O Tuangguru, suai lao inde dio bainee, annu dio liumi boko'ta mealo'-alo' meraru'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma'kadami Puang Yesus nakua: “Anggana' disua lako to Israel, to sirapan domba pusa.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sapo mengkadappi' inde bainee anna malimuntu' dio tingngayona Puang Yesus napasiolaan ma'kada nakua: “O Puang, kamasei siapa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Natimba' Puang Yesus nakua: “Tae' sipato' dibeen lako asu andean dipatokaan anak.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Natimba' inde baine nakua: “Tonganna tuang. Sapo mala duka' ummande nande ronno'na puangna asu dio wi' meja.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nakuamo Puang Yesus: “Mangngorean tongangko, indo'. La dadimi pelaummu.” Malapu' siami duka' anakna. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mengkalao omi Puang Yesus umpellei angngenan iatoo, anna ummundu' biring Tasik Galilea anna mane lu langngan tanete anna ummokko' yao. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Buda omi tau sae umpellambi'i pantan ussolaan to masakinna anna paokko'i dio tingngayona Puang Yesus. Inde mai to masakie, dengan to balimbingan, to buta, to kempo', oma', anna budapa to masaki senga', napomalapu' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mangnga-mangnga asammi tau buda ummita oma' naissan mantula', to kempo' malapu', to balimbingan naissan menono', anna to buta mala paita. Napolalan umpakasalle Puang Allata'alla Dewatanna to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mangkai too, urrempummi passikolana Puang Yesus anna ma'kada lako nakua: “Rantang buaku ummita inde lako tau budae, annu tallungngallomi naola ummula' leengkia' anna ta'mo dengan aka la naande. Sapo mokana' la untangga'i sule lako banuanna annu tadea'mi indana alami pali ummola lalan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Natimba' passikolana nakua: “Umbamo la dingei ummala nande la dipandean inde lako tau pada budannae annu indekia' alla' padang?” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nakuamo Puang Yesus: “Pirapi rotimmua'?” Natimba' nakua: “Pitu lise' mandami, anna pira-pirapa be'dok sibarinni'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ussuami tau buda Puang Yesus pantan ma'loko rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ummalami inde roti pitu sola be'dokke anna ma'kurru' sumanga' langngan Puang Allata'alla, anna mane piak-piakki nabeen passikolana natawa lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ummande asammi tau sadea'na. Narempummi passikolana sesanna tau, ponnopi pitu baka. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","To ummande attu iatoo anggapia muane anna appa' tasa'bumo, ta'pa ia direken baine sola anak. ");
INSERT INTO mqjNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mangkai too, ussuami tau buda Puang Yesus ma'pasule lako banuanna, anna mane langngan lopi la lu lako lembangna Magadan. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dengan pira-pira to Farisi sola to Saduki morai la umpeangan su'be' Puang Yesus. Saemi umpellambi'i Puang Yesus anna kuanni: “Paitaikan tanda memangnga-mangnga angki issananni kumua lu yao tongangko mai suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sapo natimba' Puang Yesus nakua: “Ianna la lendu'mo allo anna malea biring langi', mukuamoa': ‘La kulla' allo.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ianna mebongngi' anna makuppan padang siolaan malea biring langi', mukuamoa': ‘La uran allo.’ Dadi muissanan kumua la uran battu la kulla' allo ke ummitakoa' tanda yao langi', sapo tae'a' muissan umpekalembasan tanda dipadadi illalan alla'-alla'mua' temo. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Marru kadake gau' tongan inde ma'rupa tau lapik temoe anna tae' matutu langngan Puang Allata'alla annu morai la kupadadian tanda. Sapo tae'koa' la dipadadian tanda senga' salianna tanda susi dadi lako nabi Yunus.” Mangkai mantula' Puang Yesus, mengkalaomi umpellei inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Saei lian biring tasik tandai lian Puang Yesus sola passikolana, mane nakilalairi passikolana kumua tae' umbaa roti. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma'kadami Puang Yesus umpakainga' passikolana nakua: “La matangkingkoa' indana kadakeikoa' raginna to Farisi anna to Saduki.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sipantula'-tula'mi passikolana nakua: “Ia nangei mantula' susi annu tae'kia' umbaa roti.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sapo naissanan Puang Yesus aka marassan natula' passikolana, napolalan ma'kada nakua: “Ta' tongampa sangngaka kapangngoreanammua'. Maakari anna kataesanna dengan roti musitimba'-timba'ia'? ");
INSERT INTO mqjNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ta' liupaka natamai pikki'mua'? Ta'moka mukilalai lima roti kupandean tau la'bi lima sa'bu, anna pirapa baka la'binna murempun? ");
INSERT INTO mqjNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Susi toi duka' pitu roti dipandean tau la'bi appa' tasa'bu, pirapia' baka ra'dakna tau murempun? ");
INSERT INTO mqjNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Maakari anna tae' muissanan kumua tangngia Kao roti nakalembasanni tula'ku? Matangkingkoa' indana kadakeikoa' raginna to Farisi anna to Saduki.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Katampakanna naissanan pole' passikolana kumua tangngia ragi dipake umpakembea' roti nakalembasanni kadanna, sapo' pepa'guruanna to Farisi anna to Saduki. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tapakala, saemo Puang Yesus sola passikolana lako lembangna Kaisarea Filipi. Mekutanami lako passikolana nakua: “Situru' tula'na tau, benna ade' dikuaan Anak Mentolino?” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Natimba'mi nakua: “Dengan tau ungkuai: ‘Yohanes to simantedok tuo sule;’ dengan ungkuai: ‘Nabi Elia sae sule;’ dengan duka' ungkuai: ‘Nabi Yeremia tuo sule;’ anna pira ungkuai: ‘Sala' bennanna nabi tuo sule.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mekutana pole omi lako passikolana nakua: “Situru' pikki'mu bennarakkao tee?” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Natimba' Simon Petrus nakua: “Ikomo To dibassei bayu-bayu la ma'pasalama', Anakna Puang Allata'alla Dewata tuo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nakuamo Puang Yesus: “Kerongko'ko Simon, anakna Yunus, annu tangngia ma'rupa tau umpaissanniko, sapo melolo Ambeku yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Dadi temo kusangaimoko Petrus, kalembasanna batu. Anna yao inde batue la kungei umpake'de' kombonganna petauangku, anna tae' la nabela nataloi kamatean. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anna la kubengangko kakuasaan untungka'i anna untutu'i ba'ba tama kaparentaan suruga. Iamo muangga' kadake illalan lino, la naangga' kadake duka' Puang Allata'alla yao suruga. Anna iamo muangga' mapia illalan lino, la naangga' mapia duka' Puang Allata'alla yao suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Anna mane umpakari'di' passikolana indana tetteranni lako tau senga' kumua iamo To dibassei bayu-bayu la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Attu iatoo naparandukmi Puang Yesus umpaissanni passikolana kumua innang la lao lako Yerusalem anna la ussa'dingan buda kamaparrisan dio mai perepi'na to Yahudi anna kapala imam sola to untarru' issinna sura'na Musa lambisan dipatei. Sapo katallungngallona la tuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naruntu' siami Petrus illalan mai alla'-alla'na passikola anna parandukki napakilala nakua: “O Puang, la nakamaseiroko to Puang Allata'allao napolalan tae' la dadi lako kalemu itin kara-karao.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Menggirik siami Puang Yesus anna ma'kada lako Petrus nakua: “Pallaiko lao Setang! Ullawaiko pengkarangangku, annu tangngia pa'kuanna Puang Allata'alla mupikki' sapo pa'kuanna ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Anna mane mantula' lako passikolana nakua: “Benna-benna morai unturu'na' la untampean pa'kua penawanna, umpassan kayu pantokesanna, anna turu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Annu benna-benna umpa'kadua-duai katuoan illalan lino, la ungkasayu'i katuoan sae lako-lakona. Sapo benna-benna nadotaan mate annu naturu'na', la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tae' dengan gunana lako mesa tau moi la ummampui angganna issinna lino ke la sanggangri sunga'na, annu tae' dengan aka la mala dituka'ian sunga'na ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Annu la sae Anak Mentolino sitonda kamatandeanna Ambena, la naturu' angganna malaeka'na. Attu iamo too la nangei pantan umpabala'i ma'rupa tau situru' panggauanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kupokadangkoa' sitonganna, dengangkoa' to dio reen temo tae' la bonno' ke ta'pa ummita Anak Mentolino sae mendadi Tomaraya illalan kaparentaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Annanni allona mangkanna, mengkalaomi Puang Yesus umbawai Petrus, Yakobus, anna Yohanes sirondongna Yakobus langngan mesa tanete malangka', tae' dengan tau senga' nasolaan yao, angga appa'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Naitami inde tallu passikolae lumalin rupanna Puang Yesus. Pangngarrang lindona susi mata allo anna mabussang pakeanna pakkillo'-killo'. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pissananna, ummitamo duka' Musa sola Elia marassan sipantula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma'kadami Petrus lako Puang Yesus nakua: “O Puang, ta'mo dengan la nasusian masannangki inde rokko angngenanne. Ianna moraiko, la umpake'de'na' tallu lantang ammu sandaa' simesa: Iko, Musa, anna Elia.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Marassampi mantula' Petrus, turummi gaun mabussang ungkabu'i. Dirangngimi kamara illalan mai inde gaunne nakua: “Iamo te Anakku to kukamaseie anna umpomasannang penawangku. La muperangngia'i.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Urrangnginna kamara passikola, marea' asammi napolalan malimuntu' lumbang rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Saemi Puang Yesus umpellambi'i anna rumbui napasiolaan ma'kada nakua: “Ke'de'koa', dau marea'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inde anna umbangunammo ulunnae ta'mo dengan tau senga' naita, Puang Yesus mandami. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ummolai lalan anna lu yaomo mai tanete ma'pakari'di'mi Puang Yesus lako inde tallu passikolanae nakua: “Daua' tetteranni lako tau senga' kara-kara mangka muita, ke ta'pa dipatuo sule Anak Mentolino dio mai alla'na to mate.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mekutanami passikolana nakua: “Ianna susi too, akara nasanga to untarru' issinna sura'na Musa kumua: tae' mala tala sae yolo Elia anna mane sae To dibassei bayu-bayu ma'pasalama'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Natimba' Puang Yesus nakua: “Innang la sae ia yolo Elia umpatoka angga lako. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sapo kupokadangkoa' sitonganna kumua mangkami sae Elia, sapo tae' naissanan tau napolalan tae' dengan tanapogau' lako kalena. La susimi duka' Anak Mentolino la nadarra ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mane naissanarri pole' passikolana Puang Yesus kumua Yohanes to simantedok napatu kadanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Inde anna ma'pasulemo Puang Yesus sola tallu passikolana lako tau budae, napellambi'imi mesa tau anna malimuntu' dio tingngayona Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","napasiolaan ma'kada nakua: “O Tuang, kamaseianna' anakku annu lintu manukan anna nadarrai sigalimo. Bassa'mi sisongka tama api anna dengan toi lu rokko wai. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mangkami kubaa lako passikolamu, sapo' tae' nabela napomalapu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma'kadami Puang Yesus nakua: “O anggammua' rupa tau temo, to tamangngorean tongangkoa' anna to pusa. Umbapi la pada masaena la kungei torro illalan alla'-alla'mua'? Anna umba polepi la susi kasa'barasangku lako kalemua'? Baai mai itin anakko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ussuami setang Puang Yesus mallai illalan mai kalena inde anakke, tappa malapu' siami. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mangkaii, napellambi'imi passikolana sapo angga opi pakaia, anna kutanaii nakua: “Maakari anna tae' kibela urrambai iato setangngo?” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Natimba' Puang Yesus nakua: “Annu tae' sumpu kapangngoreanammua'. Annu kupokadangkoa' sitonganna, kela denganni kapangngoreanammua' moi padamo lise' sawi, tae' dengan aka la mukasumpuia'. Ianna ussuakoa' inde dio tanete membero lako angngenan senga'e, tae' mala tala membero.  ");
INSERT INTO mqjNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sapo inde setang susie, tae' dibela disua lao ke tae' tau ma'sambayang sola ma'puasa.” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Inde anna ma'mesamo Puang Yesus sola passikolana dio Galileae, nakuamo lako passikolana: “Anak Mentolino la disorong rokko lisu pala'na ma'rupa tau, ");
INSERT INTO mqjNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anna la napatei. Sapo katallungngallona la dipatuo sule dio mai alla'na to mate.” Rantang siami buana passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Saemi Puang Yesus sola passikolana lako tondok Kapernaum. Tapakala saemo to siurrempun simanna tau lako Banua Ada'na Puang Allata'alla umpellambi'i Petrus anna mekutana nakua: “Siumbaya'ka sima lako Banua Ada'na Puang Allata'alla tuanggurummua'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Natimba' Petrus nakua: “Sinabaya'.” Saei tama banua Petrus, tappa nakutanaimi Puang Yesus nakua: “O Simon, umba iko nakua pikki'mu, benna siumbaya' sima lako tomaraya illalan lino? Anaknaraka tomaraya, tau senga'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Natimba' Simon Petrus nakua: “Tau senga'.” Nakuamo Puang Yesus: “Dadi tae' ia umbaya' sima anakna. ");
INSERT INTO mqjNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sapo daumo anta patikanna penawanna itin matin tauo. Dadi laomoko rokko tasik madoa. Alai be'dok bunga' naala pekammu ammu billangngi sadangna, annu dengan doi' illalan la ganna' tapopebaya' sima duaki' lako Banua Ada'na Puang Allata'alla. Alai itin doi'o ammu lao umbayasangki' simanta.” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Attu ia siamo too anna mekutana passikolana Puang Yesus nakua: “O Tuangguru, benna randan la matande illalan kaparentaanna Puang Allata'alla?” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Untambaimi mesa anak Puang Yesus anna suai ke'de' illalan alla'-alla'na passikolana ");
INSERT INTO mqjNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","anna ma'kada nakua: “Kutulasangkoa' sitonganna, ianna tae'a' muangkaran pole lambisan ma'penawa susikoa' inde anakke, tae'koa' la mangngala tawa illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Benna-benna umpopengkareppe' kalena susi inde anakke, iamo randan la matande illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Benna-benna untarima inde anak susi ura'na kapangngoreananna lako kalekue, sirapammi Kao natarima.” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Sapo benna-benna untumang mesa inde mai to barinni' napolalan ta'mo mangngorean lako kalekue, malamia ke ditoke'i batu kamai kollongna anna ditibe rokko tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Innang la sanggang ma'rupa tau illalan lino annu dengan untumangngi umpogau' kasalaan. Innang la dengan to untumang tau umpogau' kasalaan, sapo la sanggang to umpogau'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ianna limammu battu lentekmu untumangko kasalaan, tattakkii ammu tibei lao. Annu malamoko ia ma'lima sabali battu ma'lentek sabali ullambi' katuoan sae lako-lakona, anna la tontong dua limammu battu' lentekmu sapo ditibe tamako api tanaissan pi'de. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ianna matammu untumangko kasalaan, lessu'i lao ammu tibei. Annu dotamoko ia ma'mata sabali ullambi' katuoan sae lako-lakona, anna la tontong dua matammu sapo ditibe tamako api naraka.” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Pengkilalaii, daua' ammu pa'barinni'i moi mesamo inde mai to barinni'e. Annu kutulasangkoa' sitonganna, dengan malaeka' yao suruga dio tingngayona Ambeku siundagaii.  ");
INSERT INTO mqjNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Annu Anak Mentolino sae la umpaitai lalan to pusa napolalan salama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Umba iko nakua pikki'mua', ke dengan mesa tau ummampui saratu' domba anna pa'de mesa, aka la napogau'? Manassa anna la untampe dombana kasera pulona kasera yao tanete anna lao umpeang domba pa'de. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anna kutulasangkoa' sitonganna, ianna nakabuttuimo, marru la undoresan inde domba ambo' pa'dee anna la kaseranna polona kasera tae'na nakapa'dei. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Susimi duka' Ambemu yao suruga, moka ke la denganni la pa'de moi mesamo inde mai to barinni'e.” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ianna dengan sa'do'dorammu to mangngorean kasalaan lako kalemu, laoko umpellambi'i ammu pakilalai sapo tae' dengan tau la urrangngikoa'. Ianna natarima pepakilalammu, iko napolalan sikadamakkoa' sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sapo ianna tae'ko naperangngii, bawaiko mesa battu duaraka tau ussolangko. Annu situru' Buku Masero, ianna duamo battu' tallu tau ussa'bii mesa kara-kara, ditonganammi. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ianna moka pole umperangngii to musolaan, palulakoi kombonganna to mangngorean. Ianna moka umperangngii pepakilalanna kombonganna to mangngorean, papada angga'ia' tuang passima battu tau senga' to tangngummissanan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Annu kutulasangkoa' sitonganna, iamo muangga' kadake illalan lino, la naangga' kadake duka' Puang Allata'alla yao suruga. Anna iamo muangga' mapia illalan lino, la naangga' mapia duka' Puang Allata'alla yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Anna mesa polepi la kutulasangkoa': ianna dengan dua to mangngorean illalan lino umpamesa penawa ma'sambayang, tae' mala tala nabenganni Ambeku yao suruga angganna pelaunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Annu umba-umba nangei dua battu tallu tau ma'rempun annu mangngorean lako kaleku, la diona' duka' reen.” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mangkai too, saemi Petrus umpellambi'i Puang Yesus anna kutanai nakua: “O Puang, la pempiranna' unggarri'i solaku ke denganni umpogau' kasalaan lako kaleku? La siruamika ke pempitui?” ");
INSERT INTO mqjNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Natimba' Puang Yesus nakua: “Ta'pa. Tae' angga la pempitu sapo la pempitu pulo sanda sipitu. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Annu ianna umpalakomo kaparentaanna Puang Allata'alla, la sirapan mesa tomaraya la urreken pa'peindanna lako to ma'dama illalan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Naparandukki marreken, dipopengngolomi mesa to ma'dama, to kaindanan sapulo sa'bu talenta. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sapo tae' la nabela nabaya', napolalan situru' parentana tomaraya la dibaluk inde taue sola bainena anna anakna anna angganna ewananna la dibayasan indanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Malimuntu' siami dio tingngayona tomaraya anna mengkarumase-mase nakua: ‘O tuang, sa'bara'poko annu angganna indangku innang la kubaya'na.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tappa rantangmi buana tomaraya urrangngii, napolalan napabeai le'ba anna napa'dean asan indanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Suunni illalan mai banuanna tomaraya inde taue, sitammumi solana ma'dama to napaindanni saratu' dinar. Naanda'i siami kollongna napasiolaan ma'kada nakua: ‘Baya'i indammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Malimuntu'mi inde solanae anna mengkarumase-mase nakua: ‘Sa'bara'poko innang la kubaya'na indangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sapo tae' naperangngii, sangngadinna napopetarungkun, anna tae' la dirappanan ke tae' lendu' asan indanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Inde anna issanammi solana ma'dama pa'palakonae, rantang asammi buana napolalan lao ma'parapa' lako tomaraya. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Napopetambaimi tomaraya inde taue anna kuanni: ‘Tau kadakeko. Mangkamoko kupa'deian indammu annu mengkarumase-maseko dio tingngayoku. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tae'ka la sipato'ko duka' ungkamasei solamu susi pa'kamaseku lako kalemu?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Keara' siami tomaraya, napolalan napopetarungkun, anna tae' narappanan ke tae' lendu' asan indanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","La napasusimokoa' duka' te Ambeku yao surugae, ke tae'koa' sae rokko unggarri'i padammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mangkanna mantula' Puang Yesus, mengkalaomi umpellei Galilea lu lako lembangna Yudea lamban lianna Salu Yordan. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Buda tau ummula'i anna buda to masaki napomalapu' dio angngenan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tapakala saemo pira-pira to Farisi morai la umpeangan su'be' Puang Yesus, anna mekutana nakua: “Malarika ussisarakan bainena tau moi angga titti' naposu'be'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Natimba' Puang Yesus nakua: “Ta'raka dengan mubaca illalan Buku Masero kumua mengkalao dio mai pa'parandukanna lino, Dewata To metampa umpadadi muane anna baine? ");
INSERT INTO mqjNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mangkai napadadi, nakuamo: ‘Iamo too, la umpellei indona sola ambena muane anna sidapo' bainena, napolalan inde dua taue la mesami.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dadi, ta'mo la dua sapo la mesami. Iamo too, iamo mangka napamesa Puang Allata'alla tae' mala napasisarak ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mekutana to Farisi nakua: “Ianna susi too, maakari anna pa'parentanni Musa kumua la umpebeen sura' kasisarakan muane lako bainena ke la nasisarakanni?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Natimba' Puang Yesus nakua: “Ia nangei umpabeaikoa' Musa ussisarakan bainemu annu natumang kamakarrasan penawammua'. Sapo sitonganna tae' susi mengkalao dio mai pa'parandukanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Perangngi manappaia' tula'ku: benna-benna ussisarakan bainena salianna ke ullullu'i pa'bannetauan bainena anna kebaine pole, tau iatoo ullullu' pa'bannetauan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nakuamo passikolana: “Ianna susi itin lalanna kasipobaineanno, mala pissammia tau tae' lako banuanta.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Natimba' Puang Yesus nakua: “Tae' sangngiaan tau mala umpalako itin tula'muo, sapo angga to innang napatantu Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dengan tau tae' kebaine annu innang didadian susi. Dengan tau tae' kebaine annu nakaleangngi tau senga'. Dengan duka' tau innang pa'kua penawanna tae' lako banuanna annu umpatutui pikki' kaparentaanna Puang Allata'alla. Benna-benna nabela umpalako inde tula'kue, mapia ke napalakoi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pissan attu saemi tau pantan umbaa anakna lako Puang Yesus anna malara naanda'i anna pa'sambayanganni, sapo nakeara'i passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma'kadami Puang Yesus lako passikolana nakua: “Pabeai itin matin anak umpellambi'ina'o. Dau lawaii, annu tau susimo tu matinno la mendadi petauanna Puang Allata'alla illalan kaparentaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pantan ummanda'imi inde anakke anna pa'sambayanganni, anna mane le'ba untampe angngenan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pissan attu dengan mesa tau sae umpellambi'i Puang Yesus anna mekutana nakua: “O Tuangguru, kamapiaan umba susi la kupogau' angku malara ullolongan katuoan sae lako-lakona?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Natimba' Puang Yesus nakua: “Maakari anna kamapiaan mupekutanaan lako kaleku? Tae' dengan senga'na mapia mesa-mesanna Puang Allata'alla. Ianna moraiko la ullolongan katuoan sae lako-lakona, turu' manappako parentana Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nakuamo inde taue: “Parenta umbannamo?” Natimba' Puang Yesus nakua: “Dau papatean, dau ullullu' pa'bannetauan, dau maboko, dau sa'bi tatongan, ");
INSERT INTO mqjNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pakasalleko indomu sola ambemu, kamaseiko padammu ma'rupa tau susi ungkamasei kalemu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nakuamo inde anak muanee: “Angganna tu matin parentao kuturu' asammi. Akapi la kupogau'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nakuamo Puang Yesus: “Ianna moraiko la sundun kamanurusammu, laoko umbaluk angganna ewanammu ammu tawaianni to mase-mase allinna, mupolalan la ullolongan ewanan yao suruga. Mangkaii saemoko ammu turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tappana urrangngi tula'na Puang Yesus, rosso siami buana anna le'ba annu buda ewananna. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nakuamo Puang Yesus lako passikolana: “Kutulasangkoa' sitonganna, marempang tongan-tongan mesa tomakaka la tama kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Anna la kupomakaleso pole kukua: la madommi' pole ia unta lu tama tottok darun, anna la mesa tomakaka la tama kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mangnga-mangnga asammi passikolana urrangngi tula'na Puang Yesus, anna sipantula'-tula' nakua: “Ianna susi too, bennara la mala dipasalama'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Unnenne'imi passikolana anna ma'kada nakua: “Nakasumpui ia ma'rupa tau, sapo' tae' ia Puang Allata'alla annu tae' dengan tanaissan nagaragai.” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nakuamo Petrus: “Untampe asammokangkami angga kiampuinna, angki turu'ko. Akamo la kilolongan?” ");
INSERT INTO mqjNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Natimba' Puang Yesus nakua: “Kutulasangkoa' sitonganna, attunna dipadadi pole angga lako, la ummokko' Anak Mentolino yao angngenan kamatandean. Attu iatoo ikoa' to sapulo dua to unturu'na' la ummokko'koa' duka' yao sapulo dua okkosan kaparentaan, la umparenta peampoanna to sapulo dua kabuttuanna to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Anna lako to untampe banuanna, sirondongnaraka, to matuannaraka, anaknaraka, bela'naraka annu naturu'na', la disondaianni tiluppi' pessaratu' anna la ullolongampa katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sapo' buda to disanga to kamai la mendadi to barinni', anna to disanga to barinni' la mendadi to kamai.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ma'kadami Puang Yesus nakua: “Kaparentaanna Puang Allata'alla mala dipasitinti inde tandenganne: Dengan mesa to ma'bela' mebongngi'-bongngi' mengkalao lao umpeang to la naposaro dio bela' anggurna. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mangkai nasituru'i mesa dinar la sarona sangngallo, nasuami lako bela'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Umbai tettek kaserai mebongngi', mengkalao pole omi lao umpeang saro, napolalan ummita pira-pira tau torro babang dio pasa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nakuammi: ‘Laokoa' umpengkaranganna' lako bela'ku angku saroikoa' la sipato'na.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lambisan lao tongan duka' mengkarang. Umbai la tettek sapulo duai, mengkalao pole omi lao umpeang to mengkarang. Susi toi duka' anna umbai la tettek tallumo karuen. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Umbai la tettek limai karuen, mengkalao pole omi, napolalan ummita tau ma'saleo-leo babang. Nakuammi: ‘Maakari ammu angga torro babang inde rokko sangngalloa'e?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Natimba' nakua: ‘Tae' dengan umposarokan.’ Nakuamo inde to ma'bela'e: ‘Laokoa' lako bela'ku umpengkaranganna'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","La lendu'i allo, nakuamo puangna bela' lako mando'na: ‘Tambai asammi to mengkarang ammu pantan beenni sarona. Popengkalao dioi to randan windi tama sae lako to randan yolo.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Saemi to tama tettek lima karuen, nabeemmi sarona sandai simesa dinar. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mangka asanni dibeen solana, saemi duka' to randan yolo tama. Kendek illalan penawanna kumua la buda ia sarona, sapo anggaria duka' sandai simesa dinar dibeenni. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inde anna untarimamo saronae, sipa'nuku-nukuammi lako puangna bela' nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Sangngallokangkami mengkarang nakaring allo, mupapadami kami saroki to angga satettek mengkarang.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sapo natimba' puangna bela' nakua: ‘Kusanga kukaloloikoa' tee. Tae'ka innang mangka tasituru'ia' la mesa dinar sangngallo? ");
INSERT INTO mqjNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alami saromu ammu laoa' annu innang la kupapada saromua' to windi tama. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tae'ka inawangku pawa ummato' ewanangku situru' pa'kuangku? Mangungngu' penawarokoka ummita pa'kamaseku lako to windi tama?’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Untampakkimi tula'na Puang Yesus nakua: “Susimi tee, to windi katampakan la yolo, anna to yolo katampakan la windi ke dako'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ummolai lalan Puang Yesus la lu langngan Yerusalem, untambaimi sapulo dua passikolana napopa'mesa pakaia anna pantula'i nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Temo la lu langngammikia' Yerusalem. Anna yaomo Yerusalem la dingei ussorongan Anak Mentolino lako kapala imam sola to untarru' issinna sura'na Musa anna la nasituru'-turu'i kumua la dipopepatei. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Anna mane palulakoi to tangngummissanan Puang Allata'alla annu la natelle anna nadarra lambisan napatei yao kayu pantokesan. Sapo' katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mangkai too, saemi bainena Zebedeus sola dua anakna umpellambi'i Puang Yesus anna malimuntu' dio tingngayona annu dengan aka la napelau. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nakutanaimi Puang Yesus nakua: “Akara la mupokada?” Natimba' nakua: “Kupelau kenamala inde dua anakkue la mupa'pengngei angngenan illalan kaparentaammu, mesa dio tandai kanammu mesa dio tandai kairimmu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sapo natimba' Puang Yesus nakua: “Sitonganna tae' muissanan aka mupelau. La mutaroka untingngayo kamaparrisan la kuolai?” Natimba' inde dua passikolae nakua: “La kitaro!” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nakuamo Puang Yesus: “Innang la unduppakoa' duka' kamaparrisan la kuolai. Sapo la ummokko' dio tandai kanangku battu' tandai kairingku, tangngia issangku. Annu angngenan iatoo dipatokaan to mangka napatantu Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tappana naissanan to sapulopa passikolana, keara' asammi lako inde to duae. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Napolalan natambai asammo Puang Yesus anna pantula'i nakua: “Muissanan kumua illalan lino angganna to ma'parenta ma'inawa pawa umparenta petauanna, anna angganna to kamainna umpalao pa'kua penawanna lako to nakuasai. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sapo tae'koa' iko la susi. Annu benna-benna morai la diangga' illalan alla'-alla'mua', la mengkareppe' ungkandapa padanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Anna benna-benna morai la mendadi to kamai, la mendadi sabua' illalan alla'-alla'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Susi duka' Anak Mentolino sae tama lino tae' anna la dikandapa, sapo la ma'kandapa anna la ussorongan sunga'na la ussulang buda tau dio mai kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mengkalaoi Puang Yesus sola passikolana umpellei tondok Yerikho, ma'silullu' omi tau buda unturu'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Attu iatoo dengan dua to buta ummokko' dio biring lalan. Tappana narangngi kumua liu Puang Yesus, metamba-tambami nakua: “O Puang, peampoanna tomaraya Daud, kamaseikangkami!” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sapo nasadangngi tau buda nakua: “Pengkamma'koa'!” Sapo tuttuan napemandui metamba nakua: “O Puang, peampoanna tomaraya Daud, kamaseikangkami!” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Torromi Puang Yesus anna tambaii anna ma'kada nakua: “Aka muporai la kupogau' lako kalemua'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Natimba' nakua: “O Puang, moraikan duka' la paita.” ");
INSERT INTO mqjNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Rantang siami buana Puang Yesus ummitai, napolalan nasapuanni matanna. Bassi paita siami napolalan le'ba duka' unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sikadappi'i Yerusalem Puang Yesus sola passikolana, ullambi'mi tondok Betfage mesa tondok yao Tanete Zaitun. Ussuami dua passikolana ");
INSERT INTO mqjNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nakua: “Laokoa' lian itin sambali' tondokko. Ianna saekoa' lian la ullambi'koa' keledai ditole' sola anakna. Bassi bukaia' balayanna ammu baa duai sambali' mai. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ianna dengan ungkambaroangkoa', la mukuanni: ‘Naparallui Puangna.’ Tappa la napabeaimokoa' umbaaii.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kara-kara iatee dadi anna malara lemba' battakadanna Puang Allata'alla napalanda' mesa nabi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Palanda'i lako issinna kota Sion kumua: ‘Petua'ia', saemi tomarayammu umpellambi'iko, marampan penawa, ussakei keledai, mesa keledai mangngura.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mengkalaomi dua passikolana anna untarunduk pa'pakari'di'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Umbaami sae keledai sola anakna anna ummalai bayu rui'na nalapikkianni, anna mane sakeii Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Buda tau umpakasalle Puang Yesus ummampa' bayu rui'na lako lalan, dengan toi ummala daun sitonda batang anna ampa'i lako lalan la naolanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Inde tau budae susi to uyyoloananni tenni to windi sipetamba-tambaan nakua: “Dipakasalle peampoanna tomaraya Daud. Ditamba' to sae umpotendan sanganna Dewata. Dipakasalle Puang Allata'alla to randan matande.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tamai kota Yerusalem Puang Yesus, karamba siami issinna kota anna sikutana-tanai nakua: “Bennara inde taue?” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Natimba' tau buda to unturu' Puang Yesus nakua: “Iamo te disanga Yesus-e, mesa nabi lu dio mai Nazaret lembangna Galilea.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lu lakomi Banua Ada'na Puang Allata'alla Puang Yesus. Urrambaimi lao to ma'baluk illalan pa'ranteanna Banua Ada'na Puang Allata'alla, umbalintan mejana to untuka' doi' sola ka'derana to umbaluk dangan-dangan. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Anna mane ma'kada lako nakua: “Dengan tiuki' illalan Buku Masero nakua: ‘Banuangku la nangei ma'rupa tau ma'sambayang,’ sapo mungeiria' iko ma'tengko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Saemi to buta sola to balimbingan umpellambi'i Puang Yesus illalan Banua Ada'na Puang Allata'alla lambisan napomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Keara'mi kapala imam sola to untarru' issinna sura'na Musa anna ummitamo tanda memangnga-mangnga napadadi Puang Yesus anna urrangngi anak sipetamba-tambaan nakua: “Dipakasalle peampoanna tomaraya Daud.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Napolalan ma'kada lako Puang Yesus nakua: “Ta'raka murangngi tula'na inde lako anakke?” Natimba' Puang Yesus nakua: “Kurangngi. Sapo ta'raka dengan mubaca illalan Buku Masero nakua: ‘Mangkamoko umparunduk anak maleapa sola anak sumusupa ummoyong pampudian lako kalemu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mangkai too, umpelleimi tau buda Puang Yesus lu lako mesa tondok disanga Betania, anna ma'bongi dio. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Masiangngi, mebongngi'mi Puang Yesus sola passikolana ma'pasule lako Yerusalem. Ummolai lalan tadea'mi Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ummitami to' ara dio biring lalan. Laomi lako, sapo tae' tappa' dengan buana, angga daunna nalambi'. Napolalan natado nakua: “Ta'moko dengan la kembua pole.” Marekko' siami. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mangnga-mangngami passikolana ummita kadadian iatoo, napolalan ma'kada nakua: “Maakaria anna tokke' marekko' inde to' kayu arae?” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nakuamo Puang Yesus: “Kutulasangkoa' sitonganna, ianna dengan kapangngoreanammua' anna tae'koa' sarubeba', malakoa' duka' umpogau' kara-kara susi kupogau' temo. Anna tae' te angga mala la mupogau'e, sapo la malapokoa' duka' ma'kada lako inde dio tanetee kumua: tiangka'ko tama tasik, tae' mala tadadi. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Annu iamo mupelau langngan Puang Allata'alla la mutarima ke ma'sambayangko sitonda kapangngoreanan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mangkai too, tarru'mi Puang Yesus sola passikolana tama Banua Ada'na Puang Allata'alla. Marassanni ma'pa'guru illalan, saemi pira-pira kapala imam sola perepi'na to Yahudi umpellambi'i anna mekutana nakua: “Kakuasaan aka mupake umpogau' inde mai kara-karae anna benna umbeengko?” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Natimba' Puang Yesus nakua: “La kukutanaikoa' duka' ianna mutimba' pekutanangku, kutulasangkoa' duka' benna umbenganna' kakuasaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Benna umbeen kakuasaan Yohanes napolalan simantedok? Puang Allata'allaraka ma'rupa tauraka?” Sipantula'-tula'mi nakua: “Ianna takua: ‘Kakuasaanna Puang Allata'alla,’ la nakuangkia': ‘Maakai anna tae' muorean?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sapo ianna takua: ‘Kakuasaanna ma'rupa tau,’ marea'ki' lako tau buda, annu inde Yohanes-e naangga' asan tau mesa nabi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Napolalan anggami nakua mentimba': “Tae' kiissanan.” Nakuamo Puang Yesus: “Ianna susi too, tae'koa' duka' la kutulasan benna umbeenna' kakuasaan kupolalan umpogau' inde mai kara-karae.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Umpatarru'mi tula'na Puang Yesus untetteran mesa tandengan nakua: “Umba iko nakua pikki'mua' inde kara-karae: Dengan mesa tau dua anakna bassi muane. Laomi umpellambi'i anak pa'bunga'na anna kuanni: ‘O anakku, laopoko umpengkarangangki' lako bela' anggurta temo.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Natimba' anakna nakua: ‘Tae' kuaku.’ Sapo' napikki' sule napolalan lao lako bela' anggur mengkarang. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mangkai ussua anak pa'bunga'na, lu lakomi anak tampakna anna kuanni duka' susi tula'na lako anak pa'bunga'na. Natimba' anak tampakna nakua: ‘Io ambe', angku laomora.’ Sapo tae' lao. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Situru' pikki'mua', umbanna inde dua anak umpalako pa'kuanna ambenae?” Natimba' kapala imam sola perepi'na to Yahudi nakua: “Anak pa'bunga'.” Nakuamo Puang Yesus: “Kutulasangkoa' sitonganna, innang la nayoloikoa' tuang passima sola baine passundala' mendadi petauanna Puang Allata'alla illalan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Annu sae Yohanes to simantedok umpaitaikoa' lalan kamaloloan, mokakoa' ummoreanni. Sapo naorean ia tuang passima sola baine passundala'. Moika anna muitamoa' kumua mangngorean, sapo mokakoa' iko mengkatoba' anna mokakoa' ummorean tula'na Yohanes.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Untetteran pole omi mesa tandengan Puang Yesus nakua: “Perangngi poleia' mesa tandengan. Dengan mesa tau ummampui kalua' litak. Pissan attu umpadadi bela' anna untanan anggur anna mane balai tiku lao. Mangkai, umbo'bokmi batu pallullusan anggur anna mane umpake'de' lempo batu la nangei to mangngampana. Mangka asanni, napa'petesanammi anna mane mengkalao lako tondok mambela. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nalambi'i attunna la dipuppu' bua anggur, ussuami pira-pira sabua'na lao umpellambi'i to mantesanna, annu la naalanni bareanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sapo saei lako, nasakkaria to mantesan. Dengan natumbui, dengan naleba'i batu, dengan duka' napatei. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ussua pole omi sabua'na inde puangna bela'e, buda ia anna to nasua yolo. Sapo' napakario-rio duka' to mantesan susi solana. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Katampakanna, anakna pole' nasua annu nakua illalan penawanna: ‘Innang la ungkalaya' anakku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sapo tappana ummita anakna puangna bela' inde mai to mantesanne, sipantula'mi nakua: ‘Iamo te to la ummala ewananna to matuannae, anta pateia' anna kita ummala asanni mana'na.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nasakkami anna pa'tibeanni lako salianna bela' anna mane pateii.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mekutanami Puang Yesus nakua: “Ianna saemo puangna bela', aka la napogau' lako to mantesanna?” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Natimba' kapala imam sola to perepi'na to Yahudi nakua: “Manassa anna la umpatei itin to kadake gau'o. Anna mane umpa'petesanan pole bela'na lako tau senga', to la umbeen manappai tawana ke nalambi' omi attunna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nakuamo Puang Yesus: “Ta'paka dengan mubaca illalan Buku Masero nakua: ‘Batu pantibeanna tukan, diala dipobatu lentong. Kara-kara iatoo dadi situru' pa'kuanna Dewata, anna mangnga-mangngaki' ummitai.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iamo too kutulasangkoa' temo kumua: La dialaikoa' patummu illalan kaparentaanna Puang Allata'alla anna dibengan lako tau senga', to umpogau' la sipato'na napogau' petauanna Puang Allata'alla.  ");
INSERT INTO mqjNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Anna benna-benna metobang untappai inde batue la polo-polo, anna benna-benna natappai la manisak.” ");
INSERT INTO mqjNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Urrangnginna tandengan natetteran Puang Yesus, tappa kalebu illalan penawanna kapala imam sola to Farisi kumua ia napatu tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Napolalan umpeang lalan la ussakka Puang Yesus, sapo marea' lako tau buda annu naangga' asan tau mesa nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Umpatarru'mi tula'na Puang Yesus untetteran tandengan lako perepi'na to Yahudi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kaparentaanna Puang Allata'alla dipasirapan mesa tomaraya umpa'sombai anakna. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ussuami pira-pira sabua'na lao untammui angganna to mangka ditambai, sapo moka asan sae. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ussua pole omi pira-pira sabua' senga'na nakua: ‘Kuanni angganna to mangka ditambai: tokami nande. Mangkami untunu saping sola anak saping napelompoi anna toka asammo. Maimokoa' anta lao lako pa'sombaan.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sapo napasalairia penawa to ditambai, dengan lao lako bela'na, dengan lu lako pengkarangan senga'na pira. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dengan duka' umpealai inde mai sabua'na tomarayae anna darrai anna pateii. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tappana naissanan tomaraya, keara' siami napolalan ussua tantarana lao umpatei to umpatei sabua'na anna mane sumpunni tondokna. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mangkai too, untambai pole omi pira-pira sabua' senga'na anna kuanni: ‘Toka asammi angga lako la dipakena illalan pa'sombaan, sapo ta'mo sipato' lako to mangka ditambai la sae ullombai. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dadi, lu lakomokoa' lalan maroa' ammu rembang angganna to musitammuan anna sae inde pa'sombaan.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mengkalao siami sabua'na ummundu' batattana anna urrembang angganna to nasitammuan susi to kadake tenni to malolo. Napolalan sippi' pole' tau dio angngenan pa'sombaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Saemi tomaraya umpa'lokoi to saena napolalan ummita mesa tau tae' ma'pakean pa'sombaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nakutanaimi tomaraya nakua: ‘Maakari ammu sae anna tae'ko ma'pakean pa'sombaan?’ Sapo mengkamma' babang. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ussuami sabua'na tomaraya nakua: ‘Pungoia' inde taue ammu tibei tama angngenan randan malillin. Illalan angngenan iatoo la dirangngi to tumangi' anna tikarasissik isinna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anna mane untampakki tula'na Puang Yesus nakua: “Buda tau ditambai sapo angga titti' naala pilean.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mangkai too, ummalaimi kalena to Farisi anna lao ussituru'-turu'i umba la nakua mekutana lako Puang Yesus anna malara dengan naola umpaalinni kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ussuami passikolana sola to unturu' tomaraya Herodes lao umpellambi'i Puang Yesus anna ma'kada lako nakua: “O Tuangguru, kiissanan kumua to maloloko anna simuundu' lollong umpa'patuduan pa'kuanna Puang Allata'alla lako ma'rupa tau. Tae' dengan tau mukarea' anna tae'ko ma'pebulu-bulu. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iamo too, la mutulasangkan diona penawammu: Situru' atoran alukta, malarika tau umbaya' sima lako tomaraya dio Roma, ta'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sapo nalosa Puang Yesus pikki' kadakena napolalan ma'kada nakua: “O anggammua' to ma'dua tambuk, maakari ammu lilinganna' tangnga'? ");
INSERT INTO mqjNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Baanni mai mesa doi' simupakea' umbaya' sima.” Nabengammi lako mesa dinar. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mekutanami Puang Yesus nakua: “Benna kerupa anna benna kesanga illalan inde doi'e?” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Natimba' nakua: “Rupanna tomaraya dio Roma anna sanganna.” Nakuamo Puang Yesus: “Ianna susi too, bengannia' tomaraya la sipato'na lu lako, ammu bengannia' duka' Puang Allata'alla la sipato'na lu lako.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Narangnginna to nasua to Farisi pentimba'na, mangnga-mangnga asammi anna le'ba umpellei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Allo ia siamo too anna sae duka' to Saduki umpellambi'i Puang Yesus. Inde to Sadukie tae' ummorean katuoanna sule to mate. Mekutanami nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“O Tuangguru, nakua pepa'guruanna Musa: ‘Ianna dengan muane bonno' anna tae' dengan anakna nasibalii bainena, inde bainenae la napobaine sirondongna, anna malara dengan pembatisanna.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pissan attu dengan pitu muane ma'sirondong. Kebainemi randan kakanna, sapo tae' dengan anak nasibalii bainena anna bonno'mo, napolalan adinna umpobainei bainena. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ta'pa duka' dengan anakna anna bonno' pole omo adinna. Napobaine polemi siruntunna sapo susi siami sae lako randan adinna tae' asan dengan anak nasibalii anna bonno'mo. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Katampakanna bonno' duka' inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dadi, ianna nalambi'mo attunna tuo sule to mate, benna tappa'mo inde pitu taue la napomuane inde bainee? Annu mangka asammi napomuane.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Natimba' Puang Yesus nakua: “Pusa tongan-tongangkoa' annu tae'koa' umpekalambanan issinna Buku Masero sola kakuasaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Annu' ianna tuomo sule to mate, ta'mo dengan to la kebaine anna ta'mo dengan to dipakemuane sapo la susimi malaeka' yao suruga katuoanna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Anna katuoanna sule to mate, ta'raka dengan mubaca battakadanna Puang Allata'alla lako kalemua' nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kaomo Dewatanna Abraham, Dewatanna Ishak, anna Dewatanna Yakub’? Tangngia Dewatanna to mate sapo Dewatanna to tuo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mangnga-mangngami tau buda urrangngi pepatudunna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tappana naissanan to Farisi kumua mangka to Saduki napasumpu Puang Yesus, ma'mesa omi anna lao umpellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dengammi mesa to illalan inde kombonganna to Farisie, iamo to untarru' issinna sura'na Musa, mekutana lako Puang Yesus annu la napaalinni kasalaan nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O Tuangguru, umbanna randan to'na parenta illalan sura'na Musa?” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Natimba' Puang Yesus nakua: “La sangkalebu penawammu ungkamasei Puang Allata'alla Dewatammu anna sangkalebu pikki'mu. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iamo te randan to'na anna bunga'na parentae. ");
INSERT INTO mqjNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Anna parenta kaduanna susi siami, nakua: ‘Kamaseiko padammu ma'rupa tau susi ungkamasei kalemu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iamo te dua parentae, pungngu' tannunna issinna sura'na Musa anna sura'na angganna nabi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ma'mesa liu siapi to Farisi dio angngenan iatoo anna mekutanamo Puang Yesus lako nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Umba nakua pikki'mua', benna To dibassei bayu-bayu la ma'pasalama' anna benna kepembatisan?” Natimba' to Farisi nakua: “Peampoanna tomaraya Daud.” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nakuamo Puang Yesus: “Ianna susi too, maakari anna mekapuang tomaraya Daud naparunduk Penawa Masero lako To dibassei bayu-bayu la ma'pasalama'? Annu nakua Daud: ");
INSERT INTO mqjNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ma'kada Puang Allata'alla lako Puangku nakua: “Okko'ko dio tandai kanangku lambisan kulukkoan asangko angganna ewalimmu dio tingngayomu.” ’ ");
INSERT INTO mqjNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dadi ianna mekapuang tomaraya Daud lako To dibassei bayu-bayu la ma'pasalama', umbamo nakua anna la dikua pole omo peampoanna tomaraya Daud?” ");
INSERT INTO mqjNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sapo tae' tappa' dengan tau untimba' Puang Yesus. Mengkalao attu iatoo ta'mo dengan tau barani mekutana lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mangkai too, ma'kadami Puang Yesus lako tau buda anna lako passikolana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Angganna to untarru' issinna sura'na Musa sola to Farisi ummampui kakuasaan ummulelean sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iamo too la muturu' angganna pepa'guruanna. Sapo daua' pampalapaii pa'palakona annu tae' situru' pepatudunna anna pa'palakona. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Annu umpadadi parenta mabanda' anna umpassa tau umpalakoi sapo tae' naaku umbillangan lalan tau moi padamo nennu' la umpalako parenta iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mentu'na kara-kara napogau' angga tappa' illalan penawanna kumua anna malara naita tau. Sinaangga'i umpakamai tali dipake ma'sambayang anna umpakalando ronggi-ronggi bayu rui'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anna siumpilei angngenan la dipakasallena ke dengan sara', anna manggi' la ma'loko dio tingngayo illalan pa'sambayangan. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Marru naporai napa'tabe'i tau lako pasa' anna nagente' tau tuangguru. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sapo daua' iko ma'din digente' tuangguru annu angga iko mesa Tuanggurummua', pada-padamokoa' sangngin passikola. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tae' dengan tau illalan lino la mala mupakasalle lambisan musa'bu' ambe annu angga mesa Ambemu, iamo Ambemu yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Daua' ma'din digente' perepi', annu angga mesa Perepi'mua', iamo To dibassei bayu-bayu la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Benna-benna morai la keangga' illalan alla'-alla'mua', la mengkareppe' dio tingngayomua' sirapan sabua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Benna-benna untandean kalena la dipa'barinni'i, anna benna-benna mengkareppe' la ditandean. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","La sanggangkoa' anggammu to untarru' issinna sura'na Musa sola to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu untutu'iangkoa' lalan ma'rupa tau tama kaparentaanna Puang Allata'alla. Mokakoa' iko tama, ullawai polepokoa' to morai la tama.  ");
INSERT INTO mqjNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","La sanggangkoa' anggammu to untarru' issinna sura'na Musa sola to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu siumpakenakoa' baine balu napolalan sae lako banuanna murappa. Simuangga'imia' umpakalando sambayangmu la muola umpamalin tau indana ummita gau' kadakemua'. Iamo nangei la nalambi'koa' kamaparrisan mabanda'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","La sanggangkoa' anggammu to untarru' issinna sura'na Musa anna to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu ullambangkoa' tasik ullewan pasapa' umpeang mesa tau la mupatama alukmua'. Ianna tamamo alukmua', mupopendadimi to la tama naraka annu marru kadake pole ia gau'na anna la gau'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","La sanggangkoa' anggammu perepi' to sirapan to buta untette solana. Annu simukuaa': ‘Tae'koa' naande pinda ke umpa'pindaikoa' Banua Ada'na Puang Allata'alla, sapo ianna umpa'pindaikoa' porewa bulawan illalan Banua Ada'na Puang Allata'alla, naandekoa' pindamu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oma' tongangkoa' anna buta penawa. Musangarika la marru keangga' porewa bulawan anna la Banua Ada'na Puang Allata'alla, anna Banua Ada'namo Puang Allata'alla umpomasero porewa bulawan illalan? ");
INSERT INTO mqjNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Anna simukuapaa' lako tau: ‘Tae'koa' naande pindamu ke umpa'pindaikoa' angngenan pemalasan. Sapo ianna umpa'pindaikoa' bua pemala' yao angngenan pemalasan, la naandekoa' pindamu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Buta penawa tongangkoa'. Musangarika la marru keangga' bua pemala' anna la angngenan pemalasan, anna angngenan pemalasammo umpomasero bua pemala' yao? ");
INSERT INTO mqjNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dadi, benna-benna umpa'pindai angngenan pemalasan, umpa'pindai duka' angganna bua pemala' yao. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Anna benna-benna umpa'pindai Banua Ada'na Puang Allata'alla, umpa'pindai duka' Puang Allata'alla to torro illalan. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Anna benna-benna umpa'pindai suruga, umpa'pindai duka' tongkonan layukna Puang Allata'alla anna umpa'pindai polepa Puang Allata'alla to ummokko' yao tongkonan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","La sanggangkoa' anggammu to untarru' issinna sura'na Musa anna to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu kara-kara barinni'moa' mupa'kadua-duai iamo umpopemala' bare sapulona rampa-rampa disanga selasih, adas magolla, anna jintan. Sapo mupasalaimia' penawa randan parallunna la dipalako illalan Pepa'guruanna Musa, susinna: ma'papada-pada, ma'kamase, anna matutu langngan Puang Allata'alla. Iamo te randan parallu mupogau'e, sapo tae' duka' la mukalembei senga'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","O anggammua' perepi' to sirapan to buta untette solana. Ummalaimokoa' dali' illalan mai irusammu, anna dengampa unta illalan muamma' kalebua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","La sanggangkoa' anggammu to untarru' issinna sura'na Musa anna to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu umpomabasei manappamokoa' salianna irusammu sola kandeammu moi kenada parappamua' simupatama napobua' poppokammua'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","O anggammua' to Farisi to buta penawa. Pomabaseiri yolo tandai tamanna irusammua' sola kandeammu anna malara makayo duka' salianna. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","La sanggangkoa' anggammu to untarru' issinna sura'na Musa anna to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu susi tappa'koa' liang mangka disado mabusa napolalan maleke diita salianna, sapo ponno buku rekko' sola angganna bosi illalan. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Susimokoa' too, ianna diitakoa', to malolokoa' sapo sitonganna to ma'dua tambukkoa' anna to umpogau' kakadakean. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","La sanggangkoa' anggammu to untarru' issinna sura'na Musa anna to Farisi, to ma'dua tambuk to ma'sampa siluang. Annu umpapiammokoa' tadanna nabi umpomapindangan liangna to unturu' pa'kuanna Puang Allata'alla yolona. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ammu manea' ma'kada mukua: ‘Kela diomokan reen anna tuopa neneki, innang tae' la kiaku nabawai umpatei nabi.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dadi, iko siamoa' melolo ummakuii kumua peampoannakoa' to umpatei nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tarrusammokoa' panggauanna nenemu yolona umpogau' kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","O anggammua' to ma'papusa, peampoanna to kadake gau'. Ta'mo dengan lalammua' tae' la dipabambanni sangka' dipatama naraka. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Perangngi manappaia' tula'ku: la kusua sae tama alla'-alla'mua' pira-pira nabi, to keaka', anna tuangguru. Sapo dengan la mupateia', dengan la mupasok lako kayu pantokesan, dengan toi la mutumbuia' illalan banua pa'sambayangammu, anna dengan pira la mudarra-darra musiula'-ula'i lako tondok-ma'tondok. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Napolalan la dipabambannikoa' sangka' annu umpateikoa' to tae' dengan kasalaanna, mengkalao dio Habel napatei nenemua' sae lako Zakharia anakna Berekhya to napatei illalan alla'na Banua Ada'na Puang Allata'alla anna angngenan pemalasan. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kutulasangkoa' sitonganna, angganna te maie la napengkolong to tuo lapik temo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O anggammua' issinna kota Yerusalem. Budami nabi mupateia', makambammi pesuanna musileba'-leba'ia' batu sabonno'na. Kuinawa-nawa liu la urrempungkoa' sirapan manuk ungkoko'i anakna, sapo mokakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Patanannia' talinga tula'ku ammu paillalan penawai: la natampemi Puang Allata'alla angngenammua' lambisan la maitu-itu. ");
INSERT INTO mqjNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kutulasangkoa' sitonganna, mengkalao temo, ta'mo' dengan la muita pole sae lako attunna mungeia' ma'kada kumua: ‘Ditamba' to sae umpotendan sanganna Dewata.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mangkai too, suummi Puang Yesus illalan mai Banua Ada'na Puang Allata'alla. Napellambi'imi passikolana anna turoanni Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nakuamo Puang Yesus: “Kutulasangkoa' sitonganna, itin lako banua maleke muitao, pissan attu la diroppokan napolalan ta'mo dengan batu la tipatodo' yao batu senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mangkai, lu langngammi Tanete Zaitun Puang Yesus anna ma'loko yao. Saemi passikolana umpentereii anna sipantula'-tula' pakaia. Nakuamo passikolana: “O Tuangguru, tulasampakan piran la lemba' tula'mu angngena'? Aka la tandana ke la saemoko anna la kasuppikanna lino?” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Natimba' Puang Yesus nakua: “Matangkingkoa' indana papusakoa' tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Annu la buda tau sae umposanga sangangku nakua: ‘Kaomo To dibassei bayu-bayu ma'pasalama',’ anna la buda tau napapusa. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","La urrangngikoa' maroa'na kasibundusan anna karebana to sibundu'. Daua' marea' annu innang la dadinna, sapo tangngiapi allo ma'katampakanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Annu la sibundu'-bundu' tau sipa'barean tondok-ma'tondok, anna kaparentaan la sibundu' kaparentaan senga'. Umba-umba angngenan la nangei kendek karorian anna lino'. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sapo angganna te maie mane pa'parandukanna kamaparrisan sirapan baine la keanak mane nasa'ding. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Attu iatoo, la disakkakoa' ammu disorongan lako to la undarrakoa' lambisan napateikoa'. Anna la nakabassikoa' angganna tau illalan lino annu muturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","La buda to unturu'na' kumassoro' lambisan sipa'perososan anna la sikabassi-bassi. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","La buda kendek to ussanga kalena nabi, anna la buda tau napapusa. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","La tuttuan kembea' gau' kadake napolalan buda tau moro' pa'kamasena. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sapo benna-benna mentoe manda' mengnganti matoto' sae lako kasuppikanna la dipasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Anna la ditale' ambumpa illalan lino Kareba Kadoresan untetteran kaparentaanna Puang Allata'alla napolalan narangngi asan angganna ma'rupa tau. Mangkai too, mane nalambi'ri allo ma'katampakanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“La ummitakoa' ‘To ungkarang kakadakean la mesanggangngi,’ ke'de' illalan angngenan masero, susi mangka napayolo lamban nabi Daniel. (Inde battakadae la napikki' manappa to umbacai aka kalembasanna.) ");
INSERT INTO mqjNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Attu iatoo angganna to dio Yudea innang la sirri' langngan tanete. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","To sirupang illalan salian ta'mo la tama banua ummala porewana, ");
INSERT INTO mqjNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","anna to sirupang dio bela'na ta'mo la sule lako banuanna ummala pakeanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Masussa tongan-tongan to manambuk anna to ma'pasusu attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pa'sambayangkoa' anna malara inde kadadianne tae' sipatu palauran battu' sirupang allo katorroan. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Annu attu iatoo la kendek kamaparrisan mekarea'-rea', ta'pa dengan dadi kamaparrisan susi mengkalao dio mai pa'parandukanna lino sae lako temo, anna ta'mo dengan la dadi pole susinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kela tae' napokon attunna Puang Allata'alla, ta'mo dengan la tuo ma'rupa tau. Sapo umpessaileipi to napile, napolalan napokon attunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ianna dengan tau ungkuangkoa': ‘Indemi To nabassei bayu-bayu Puang Allata'allae!’ battu' nakua: ‘Diomio!’ daua' perangngii. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Annu la buda kendek to ussanga kalena To nabassei bayu-bayu Puang Allata'alla sola to ussanga kalena nabi. La dengan kara-kara kamai napogau' anna la umpadadi tanda memangnga-mangnga, annu kela malai sae lako to napile Puang Allata'alla napapusa. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pengkilalai manappaia', annu kutimangmokoa' kupokadaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ianna dengan tau ungkuangkoa': ‘Petua'i, diomi padang alla' To nabassei bayu-bayu Puang Allata'alla,’ daua' lao lako. Battu nakua: ‘Illalan tambing,’ daua' perangngii. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Annu kasaeanna Anak Mentolino la susi kila' pangngarrang mengkalao yaya kabuttuan allo sae sau' karaunanna allo napolalan la naissanan angganna tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Umba-umba nangei bangke, iamo nangei ma'karompo' dassi ummandei.” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mangkanna te kamaparrisanne, ‘pi'demi mata allo, ta'mo la pangngarrang bulan, anna la sironno'-ronnosan bentoen yao mai langi' napolalan ta'mo menggalattuan issinna langi'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Anna mane diita yao langi' tanda kasaeanna Anak Mentolino napolalan la sikatangi' angganna ma'rupa tau. Attu iatoo la naita tau Anak Mentolino turun yao mai langi' illalan gaun sitonda kamatandean anna kakuasaan taditondon. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","La dipamoni tamboro' kamai anna la ussua malaeka'na lao urrempunanni to mangka napile illalan lino, mengkalao yaya kabuttuan allo sae sau' karaunanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mala diala tandengan kayu ara: ianna kentarukmo anna mukku'mo daunna muissanammia' kumua la kulla'mi allo. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","La susimi duka' ke muitamia' dadi angganna mangka kutulasangkoa', la muissanammia' kumua madappi'mi attunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kupokadangkoa' sitonganna, ta'pa la pa'de rupa tau lapik temo anna lemba'mo inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langi' anna lino la pa'de, sapo battakadangku la da'da' sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tae' dengan tau ummissananni attunna la dadi kara-kara iatoo. Moi malaeka' yao suruga, moi Anakna Puang Allata'alla, angga Ambeku ummissananni. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Annu kasaeanna Anak Mentolino, susi tappa' anna attunna Nuh yolona. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Inde anna ta'pa sae waie, angganna ma'rupa tau illalan lino masannang-sannang ummande sola mangngiru', kebaine, anna ma'pasipobaine sae lako attunna tama kappala' Nuh. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tae' dengan aka naissanan anna tokke'mo sae wai la untallannii mane kilalari pole'. La susimi duka' kasaeanna Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ianna dengan dua muane marassan mengkarang dio bela', la disolaan lao mesa anna la dipatorro mesa. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ianna dengan dua baine marassan manggiling, la disolaan lao mesa anna la dipatorro mesa. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iamo too, matangkingkoa' annu tae' muissanan attunna la nangei sae Dewatammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pikki'pia' too: kela naissananni to ma'banua kumua la maakai bongi la nangei sae to maboko, innang tae' la mamma' indana tama banuanna to maboko. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Iamo too la matangkin liukoa', annu kasaeanna Anak Mentolino tae' mubae-bae.” ");
INSERT INTO mqjNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“La sirapangkoa' sabua' matutu anna keaka' to naangka' puangna umponggawai solana anna malara untawa nande lako solana ke nalambi'i attunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kerongko' inde sabua'e ke tontongngi matutu umpalako manappa pengkaranganna nalambi' puangna ke saemi sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kutulasangkoa' sitonganna, tae' mala tala naangka' puangna ungkandapanni angganna ewananna. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sapo ianna kadake penawa inde sabua'e, la kendek illalan penawanna nakua: ‘Maela'pi sae puangku,’ ");
INSERT INTO mqjNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","lambisan ungkambeimo solana anna ummande anna mangngiru' sola to pangngiru'. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tapakala tokke'mo sae puangna tae' nabae-bae. ");
INSERT INTO mqjNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Inde sabua'e la nakambei puangna anna mane pa'tibeanni tama angngenanna to ma'dua tambuk. Diomo angngenan iatoo la dingei urrangngi bating sola isi sikekkok.” ");
INSERT INTO mqjNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ianna nalambi'mo attunna sae kaparentaanna Puang Allata'alla, mala dipasilio inde tandenganne: Dengan sapulo anak dara ummala ballo anna mengkalao lao untammui to la sae kebaine. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Inde sapulo anak darae lima ma'rori' anna lima oma'. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Inde baine oma'e umbaa ballo sapo tae' umbaa pole minnak. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mengke'de' baine ma'rori', umbaa ballo anna umpatokapa minnak illalan buli-buli. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sapo maela'ria sae to la kebaine, napolalan tikkaru'du' lambisan mamma' asan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tangngai bongi, metamba-tambami tau nakua: ‘Saemi to la kebaine! Maikoa' untammuii.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Millik siami inde sapulo anak darae anna pantan umpapia-pia ballona. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nakuamo baine oma': ‘Beengkan kami minnakmu titti' annu la pi'demi kami balloki.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Natimba' baine ma'rori' nakua: ‘Tae', annu la siela-elaikia'. La sipoleammia ke laoia' mualli lako to ma'baluk.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Le'bai lao ummalli minnak, saemi to la kebaine. Tamami angngenan karoasan lima anak dara ma'rori' sola to la kebaine. Lessu'i tama, ditutu'imi ba'ba. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tae' masae, saemi duka' lima anak dara oma' metamba-tamba nakua: ‘O tuang, tungka'ikangkami!’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sapo natimba' to la kebaine nakua: ‘Tae'koa' kuissanan.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Untampakkimi kadanna Puang Yesus nakua: “Iamo too la matangkin liukoa' annu tae' muissanan attu kasaeangku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ianna saemo kaparentaanna Puang Allata'alla mala dipasilio inde tandenganne: Pissan attu, dengan mesa tau la mengkalao lako lembang senga'. Untambaimi tallu sabua'na anna pantan pakambi'i doi'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sapo tae' pada-pada nabenganni sangngadinna pantan napapatui situru' pa'belanna. Napolalan dengan mesa sabua' nabeen lima sa'bu doi' bulawan, mesa nabeen dua sa'bu, anna mesanna pole nabeen sasa'bu. Mangkai umbeen doi' sabua'na, mengkalaomi. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mengkalao siami to dibeen doi' lima sa'bu lao mengkarang umpake inde doi'e napolalan kerangngan lima sa'bu doi' bulawan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Susi toi duka' to dibeen dua sa'bu, kerangngan doi'na dua sa'bu doi' bulawan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mengke'de' to dibeen sasa'bu, lao ia umbumbun litak anna ullamun doi' nabenganni puangna. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Masaei mangkanna, sulemi puangna. Untambaimi sabua'na annu la sireken. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Saemi to dibeen lima sa'bu doi' bulawan umpellambi'i puangna anna kuanni: ‘O tuang lima sa'bu doi' bulawan mubeenna', kupakemi mengkarang napolalan kerangngan lima sa'bu doi' bulawan.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Natimba' puangna nakua: ‘Mapia pengkarangammu, annu innang to madota'ko anna to matutu. La kubengangko passanan umpare' kara-kara kamai, annu' malamoko diorean umpare' kara-kara barinni'. Maimoko anta sola ussa'dingan kamasannangangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mangkai, saemi duka' to dibeen dua sa'bu doi' bulawan anna kuai: ‘Dua sa'bu doi' bulawan mubeenna' kupakemi mengkarang napolalan kerangngan dua sa'bu doi' bulawan.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Natimba' inde puangna nakua: ‘Mapia pengkarangammu, annu innang to madota'ko anna to matutu. La kubengangko passanan umpare' kara-kara kamai, annu' malamoko diorean umpare' kara-kara barinni'. Maimoko anta sola ussa'dingan kamasannangangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Katampakanna sae duka' to dibeen sasa'bu doi' bulawan anna kuai: ‘O tuang, kuissanan kumua to makarra'ko. Tokke'ko simepare moi tae'ko dengan mangngambo', anna tokke'ko sima'puppu' moi tae'ko dengan mantanan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Dadi marea'na', kupolalan lao ullamun doi'mu. Indemi doi'mue, alami matin sule.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Natimba' puangna nakua: ‘Sabua' kadakeko anna to makuttu. Muissanammi kumua tokke'na' simepare moi tae'na' dengan mangngambo', anna tokke'na' sima'puppu' moi tae'na' dengan mantanan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maakari anna tae' mubeen to siumpa'peanakan doi' itin doi'ku anna malara kutarima sitonda anakna ke saemo' suleo? ");
INSERT INTO mqjNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Alai itin doi'o ammu beenni lako to ummampui sapulo sa'bu doi' bulawan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Annu' benna-benna dengan aka naampui la dirangngannian polei anna malara tuttuan buda, sapo benna-benna tae' dengan aka naampui, aka-aka diona kalena la dialai pissan. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Anna itin sabua' tama'gunao pa'tibeannia' tama angngenan randan malillin. Illalan angngenan iatoo la dirangngi to tumangi' anna tikarasissik isinna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ianna saemo Anak Mentolino sitonda kamatandean sola angganna malaeka', la ummokko'mi yao tongkonan layukna tadisirantean. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Attu iatoo angganna ma'rupa tau illalan lino la tirempun dio tingngayona anna pasisarakki napa'dua sirapan to ma'kambi' umpasisarak domba anna beke. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Inde dombae la napalulako tandai kananna anna beke la napalulako tandai kairinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Anna la ma'kadami inde Tomaraya lako to dio tandai kanannae nakua: ‘O anggammua' to natamba' Ambeku, maikoa' ammu tama kaparentaan mangka dipatokangkoa' mengkalao dio anna mane dikombong lino. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Annu ianna tadea'na' mubeenna' nande, ianna marekko' kollongku mupairu'na'. Ianna tamana' tondokmua' mupalangnganna' banuammu. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ianna tae' dengan pakeangku, mubeenna' pakean. Ianna masakina', mukandapana'. Anna ianna illalanna' tarungkun, laona' muollongngi.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","La natimba' inde mai to maloloe nakua: ‘O Puang, piran angki itako tadea' kipolalan umbengangko nande, battu marekko' kollongmu kipolalan umbengangko wai iru'? ");
INSERT INTO mqjNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Piran angki itako sae tama tondokki kipolalan umpalangngangko banuangki? Piran angki itako tae' ma'bayu kipolalan umbengangko pakean? ");
INSERT INTO mqjNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Piran angki itako masaki battu illalan tarungkun kipolalan lao ummollongngiko?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","La natimba' itin Tomarayao nakua: ‘Kupokadangkoa' sitonganna, angganna mupogau' lako inde mai sa'do'dorangku to randan barinni'e, sirapammi mupogau' lako kaleku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Mangkai, la ma'kadami Tomaraya lako to dio tandai kairinna nakua: ‘O anggammua' to mangkamo natado Dewata. Pallaikoa' lao, lu tamakoa' api tanabela pi'de, angngenan mangka dipatokaan ponggawana setang sola angganna malaeka'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Annu inde angku tadea'e tae'na' mubeen nande, marekko' kollongku tae'na' mubeen wai iru'. ");
INSERT INTO mqjNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tamana' tondokmua' tae'na' mupalangngan banuammu, tae'na' ma'bayu mokakoa' umbenganna' pakean. Masakina' battu illalanna' tarungkun tae'na' dengan lao muollongngia'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","La natimba' to dio tandai kairinna nakua: ‘O Puang, piran angki itako tadea' sola marekko' kollongmu, battu sae tama tondokki sola tae' ma'bayu? Piran angki itako masaki sola illalan tarungkun anna tae'ko kikandapa?’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","La natimba' nakua: ‘Kutulasangkoa' sitonganna, panggauammua' tae' umpamoloi inde mai sa'do'dorangku to randan barinni'e, tae' duka' mupogau' lako kaleku.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Angganna tau iatoo la dipalutama angngenan pandarraan sae lako-lakona. Anna angganna to malolo la ullolongan katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mangka asanni umpalanda' pepa'guruanna Puang Yesus, ma'kadami lako passikolana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Muissanammia' kumua dua bongi mandami anna nalambi'mo allo Paskah anna la disorongan Anak Mentolino la dipatei yao kayu pantokesan.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Attu iatoo ma'mesa kapala imam anna perepi'na to Yahudi dio banuanna Pongkena Imam disanga Kayafas, ");
INSERT INTO mqjNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","la ussituru'-turu'i umba la nakua ussakka buni Puang Yesus anna popepateii. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sapo nakua: “Tae' la tapasipatui allo kamai, indana rukka tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Diomi tondok Betania Puang Yesus illalan banuanna Simon to dolengan yolona. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Marassanni ummande, dengammi baine sae umbaa buli-buli batu kaissi minna'-minna' simasulli' allinna anna bolloianni ulunna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Naitanna passikolana Puang Yesus, surrak siami buana anna ma'kada nakua: “Akamo gunana itin minna'-minna' masulli' dikaleang-leangngi babangngo? ");
INSERT INTO mqjNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Itin minna'-minna'o mala dibaluk annu masulli' anna ditawaian to mase-mase allinna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sapo nalosa Puang Yesus pikki'na passikolana napolalan ma'kada nakua: “Maakari ammu sussaia' inde bainee? Pabeai mammi, annu umpogau'mia kamapiaan lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Annu la sola liukoa' ia to mase-mase, sapo kaleku Kao tae'kia' la sola liu. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nabolloina' minna'-minna' temo, natimangmia napogau' la napogau'na ke la dilamummo'. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kupokadangkoa' sitonganna, umba-umba dingei umpalanda' Kareba Kadoresan, iamo duka' dingei umpokada panggauanna inde bainee la dipolalan umpengkilalaii.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mangkai too, mengkalaomi mesa to nakala' sapulo dua passikolana Puang Yesus disanga Yudas Iskariot lao umpellambi'i kapala imam, ");
INSERT INTO mqjNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","anna ma'kada lako nakua: “Aka la mubeenna' angku palessu' rokkoi lisu pala'mua' Puang Yesus?” Narekenammi tallu pulo doi' pera' anna beenni. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Naparanduk diomi too nangei umpeang liu lalan Yudas la umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Inde anna allo pa'parandukanna rame-rame umpakaroa' Allo Kamai disanga Roti Tae' Diboloi Ragie, saemi napellambi'i passikolana Puang Yesus anna ma'kada lako nakua: “Umbanna angngenan muporai la kingei umpatokangko nande Paskah?” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nakuamo Puang Yesus: “Laokoa' tama kota umpellambi'i mesa tau ammu kuanni: ‘Mepasan Tuanggurungki kumua, la nalambi' kalemi attu mangka napatantu Puang Allata'alla lako kalena, morai la ummande nande Paskah sola passikolana dio banuammu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mengkalao tongammi passikolana lao umpatoka nande Paskah situru' pesuanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bongii, ummandemi Puang Yesus sola sapulo dua passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Marassanni ummande, nakuamo Puang Yesus: “Kutulasangkoa' sitonganna, dengan mesa illalan alla'-alla'mua' la umpa'perososanna'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mapa'di' asammi penawanna passikolana anna sibala'-bala' mekutana lako Puang Yesus nakua: “Tangngia mammoka kao, Tuangguru?” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Natimba' Puang Yesus nakua: “To kusolaan ummoton roti rokko mesa pindan, iamo la umpa'perososanna'. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Innang la mate ia Anak Mentolino situru' issinna Buku Masero, sapo la sanggang to umpa'perososanni. Mala pissan ia kela ta'mo didadian.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nakuamo Yudas to la umpa'perososanni: “Tangngia mammoka kao, Tuangguru?” Natimba' Puang Yesus nakua: “Anna ikomo kumua.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Marassanni ummande, ummalami roti Puang Yesus anna ma'kurru' sumanga' anna mane piak-piakki, nabeen lako passikolana napasiolaan ma'kada nakua: “Alai ammu andei, iamo te batang kalekue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mangkai, ummalami irusan kaissi anggur anna ma'kurru' sumanga' anna mane beenni lako passikolana napasiolaan ma'kada nakua: “Pantan iru'mia' illalan mai inde irusanne, ");
INSERT INTO mqjNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","annu iamo te rarakue la umpomanassa pa'dandinna Puang Allata'alla, la dipato'do anna malara digarri'i kasalaanna buda tau. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sapo kutulasangkoa' temo, ta'mokkao dengan la ummiru' pole anggur sae lako nalambi' attunna sola-solakia' ke dako' ummiru' anggur bakaru illalan kaparentaanna Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mangkaii, ummoyongmi mesa penanian umpakasalle Puang Allata'alla, anna mane mengkalao sola passikolana langngan Tanete Zaitun. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma'kadami Puang Yesus lako passikolana nakua: “La le'ba asangkoa' mani bongi ussipelle-pelleina'. Annu dengan tiuki' illalan Buku Masero nakua: ‘La kupatei to ma'kambi'na anna angganna dombana la tisembu' lao.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sapo ianna tuomo' sule, la kuyoloanammokoa' lako Galilea.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Natimba' Petrus nakua: “Moi la le'ba asan solaku, innang tae' dengan leleangku la umpelleiko.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nakuamo Puang Yesus lako: “Kutulasangko sitonganna, ta'pa moni manuk mani bongi anna pentallummo' mutelang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nakuamo Petrus: “Moi la dipateiki' sola, innang tae'ko la kutelang.” Angganna solana Petrus susi asammi te tula'nae. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mangkai too, mengkalaomi Puang Yesus sola passikolana lu lako mesa angngenan disanga Getsemani. Saei lako, nakuamo lako passikolana: “Okko'mokoa' te indee angku laopa ma'sambayang.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Umbawaimi Petrus anna dua anakna Zebedeus ussolanni. Attu iatoo naparandukmi magara' Puang Yesus anna masussa penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nakuamo lako passikolana to nasolaan: “Masussa tongan-tongan penawangku temo, kupolalan susimo to la bonno' kusa'ding. Torromokoa' te indee, sapo la tontongkia' matangkin.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Mendendemi titti' anna malimuntu' lumbang rokko litak, anna ma'sambayang nakua: “O Ambeku ianna la dengampa leleanna, pomambelanna' inde parri' kutingngayoe, sapo tangngia pa'kuangku la dadi, sangngadinna pa'kuammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mangkai ma'sambayang, sulemi lao umpellambi'i inde tallu passikolanae sapo mamma' nalambi'. Nakuamo lako Petrus: “Ta' siamoka iko mutaroa' daga moi satettekmo ussolanna'? ");
INSERT INTO mqjNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Matangkingkoa' ammu ma'sambayang indana taloikoa' passudian umpogau' kasalaan. Innang morai ia penawa la ma'gau' mapia, sapo malamma batang kalemua'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mangkai umpantula'i passikolana, lao pole omi ma'sambayang kapenduanna nakua: “O Ambeku, ianna ta'mo dengan leleanna la kusala inde kamaparrisanne, pa'kuammumo dadi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mangkai ma'sambayang, sule omi lako passikolana, sapo mamma' asan nalambi' annu nataloimi matanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mengkalao pole omi lao ma'sambayang kapentallunna, susi siami sambayangna angngena'. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mangkai, sae omi umpellambi'i passikolana, anna ma'kada nakua: “Mamma' liupokoka ikoa'? Petua'i nalambi'mi attunna Anak Mentolino la dipalessu' rokko lisu pala'na to kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Millikmokoa' anta lao untammui to la umpa'perososanna' annu madappi'mi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Marassampi mantula' Puang Yesus, anna saemo Yudas, mesa to nakala' sapulo dua passikolana Puang Yesus. Buda tau nasolaan umbaa pa'dang sola bose, nasua kapala imam anna perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Innang mangkami napokada Yudas lako inde mai to nasolaanne, nakua: “Iamo kuudung, iamoa' la musakka.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Saena Yudas tappa umpellambi'imi Puang Yesus anna pantula'i nakua: “O Tuangguru.” Anna mane udungngi. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma'kadami Puang Yesus nakua: “Akamo mutungka sae?” Sae siami to nasolaan Yudas ussakka Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sapo dengan mesa passikolana Puang Yesus umbonok pa'dangna anna umbatta sabua'na Pongkena Imam napolalan mallai talinganna. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma'kadami Puang Yesus nakua: “Pasibanuai sule pa'dangmu. Annu benna-benna umpopaningoan pa'dang, la naande duka' pa'dang. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Musangarika tae'na' mala la melau langngan Ambeku yao suruga anna paturunanna' ma'pulo sa'bu malaeka' sae umpamoloina'? ");
INSERT INTO mqjNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sapo ianna la kupasusi, tae' la lemba' battakada mangka tiuki' illalan Buku Masero kumua innang la dadi susi tee.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anna mane ma'kada lako tau buda nakua: “Musangarakka to kadakea', ammu baa pa'dang sola bose sae ussakkana'? Kusanga siillalan liuna' Banua Ada'na Puang Allata'alla ke allo ma'loko ma'patudu. Maakari anna tae'na' musakka? ");
INSERT INTO mqjNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sapo innang la dadi susi anna malara lemba' battakada mangka nauki' nabi illalan Buku Masero.” Mangkaii le'ba asammi passikolana sikakondong umpellei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mangkai ussakka Puang Yesus nabaami lako banuanna Pongkena Imam disanga Kayafas. Dio angngenan iatoo, innang ma'rempummi to untarru' issinna sura'na Musa sola perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Naula' manarangmi Petrus sae lako luba'ba banuanna Pongkena Imam, anna ummokko' dio sola to daga, ma'pesa'ding battu umba nakua lemba'na. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Umpeangmi to la sa'bi tatongan kapala imam anna angganna solana to nakala' pa'bisara alukna to Yahudi la umpaalinni kasalaan Puang Yesus anna malara dipatei. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sapo tae' dengan lalan naita, moika anna budamo tau untula' kasa'bian tatongan. Tapakala, dengammo dua tau ke'de' ");
INSERT INTO mqjNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","anna ma'kada nakua: “Mangka kirangngi nakua: ‘Inde Banua Ada'na Puang Allata'allae mala kuroppokan, anna angga la tallungngallo la kuola umpake'de'i sule.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ke'de' siami Pongkena Imam anna ma'kada lako Puang Yesus nakua: “Ta'raka la mutimba' inde pa'tanda'na tau lako kalemue?” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sapo mengkamma' babang Puang Yesus. Ma'kada pole omi Pongkena Imam nakua: “Pa'pindaipoko Puang Allata'alla Dewata tuo ke sia Iko tongammo To dibassei bayu-bayu la ma'pasalama', Anakna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Natimba' Puang Yesus nakua: “Ikomo melolo ungkuai. Sapo kutulasangkoa': ta'mo masae ammu ummitamoa' Anak Mentolino ummokko' dio tandai kananna To randan kuasa anna la sae illalan gaun yao langi'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ussesse' siami pakeanna Pongkena Imam anna ma'kada nakua: “Tarangngimia' untelle Puang Allata'alla. Ta'mo manggi' dengan sa'bi annu murangngi asammia' kadanna untelle Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Umba iko nakua pikki'mua?” Pada-pada mentimba' nakua: “La dipatei.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dengammi tau untikkudui lindona, dengan undangguru'i, anna dengan toi untampilingngi ");
INSERT INTO mqjNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","anna kuanni: “O To dibassei bayu-bayu la ma'pasalama', benna untappa limaiko?” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Attu iatoo diopi duka' pa'rantean Petrus ma'loko. Saemi mesa sabua' baine anna ma'kada lako nakua: “Sisolako duka' inde Yesus to Galileae.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sapo mantelang Petrus narangngi tau dio nakua: “Tae' kuissanan aka mupokada.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Memberoi Petrus lako sa'de ba'ba bala pa'rantean, dengan pole omi mesa sabua' baine ummitai. Nakuamo lako to dio angngenan iatoo: “Inde taue innang solana Yesus iato to Nazaret-o.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mantelang pole omi Petrus lambisan ma'pinda. Anna mane nakua: “Tae' tongan-tongan kuissanan itin tauo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tae' masae, sasaeammi to ke'de' dio angngenan iatoo untalimbung Petrus anna ma'kada lako nakua: “Manassa anna solanako annu dirangngimi samparan kadammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma'pinda pole omi Petrus nakua: “Tae' tongan-tongan kuissanan itin tauo.” Lappa'na tula'na Petrus, moni siami manuk. ");
INSERT INTO mqjNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tappa ungkilalai siami tula'na Puang Yesus lako kalena nakua: “Ta'pa moni manuk anna pentallummo' mutelang.” Le'ba siami lako salian Petrus ma'pase'gok-se'gok tumangi'. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mane tibungka' masiang anna ma'mesamo angganna kapala imam sola perepi'na to Yahudi urrapa' kada la umpopepatei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Umpungomi Puang Yesus anna lao umpalessu' rokkoi lisu pala'na Pilatus, gubernur napatantu to ma'parenta Roma dio angngenan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tappana naissanan Yudas to umpa'perososan Puang Yesus kumua dipasala Puang Yesus lambisan la dipatei, menassan siami. Umpasulemi doi' pera' tallu pulo lako kapala imam sola perepi'na to Yahudi ");
INSERT INTO mqjNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","anna ma'kada nakua: “Kasalaan tongan-tonganna' annu umpa'perososanna' to tangkasalaan lambisan dipatei.” Sapo natimba' kapala imam sola perepi'na to Yahudi nakua: “Tangngia kami issangki. Issammu iko tuo.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Umpa'tibeammi doi' Yudas tama Banua Ada'na Puang Allata'alla anna lao mentuyo untoke' kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Naliumi kapala imam inde doi'e napasiolaan ma'kada nakua: “Inde doi'e tae' mala dipalutama pa'pengngean pemalasan illalan Banua Ada'na Puang Allata'alla, annu doi' alli rara.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nasituru'-turu'imi la naallian salaoan litak disanga Litak Pa'tampa Kurin. Inde litakke, napopelamunan to messae. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iamo nangei disangaimo “Litak Rara” sae lako temo. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lemba' pole' battakada mangka natula' nabi Yeremia nakua: “Nasituru'-turu'imi to Israel la tallu pulo doi' pera' allinna lambisan natarimamo anna ");
INSERT INTO mqjNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","allianni salaoan litakna pa'tampa kurin, susi parentana Dewata lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dibaami Puang Yesus lako gubernur Pilatus, nakutanaimi nakua: “Ikomoka tomarayanna to Yahudi?” Natimba' Puang Yesus nakua: “Ikomo melolo ungkuai.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sapo ta'mo dengan mentimba' Puang Yesus anna ummendekan pa'tanda'na kapala imam sola perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Napolalan mekutana pole Pilatus nakua: “Ta'raka murangngi angganna pa'tanda'na inde mai tau lako kalemue?” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sapo tae' dengan natimba' Puang Yesus moi la sabattamo kada, napolalan mangnga-mangnga babangmo Pilatus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ianna nalambi' omo Allo Paskah siurrappanan mesa to ditarungkun gubernur situru' pelaunna tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Attu iatoo dengan mesa to ditarungkun to kaleleammo kakadakeanna, disanga Yesus Barabas. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tirempun asanni tau buda, mekutanami Pilatus nakua: “Bennanna muporaia' la kurappanan temo, Yesus Barabasraka, inderaka Yesus to sidikuaan To dibassei bayu-bayu la ma'pasalama'e?” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Annu innang naissanammi Pilatus kumua ia sia nangei umbaa sae Yesus perepi'na to Yahudi annu mangungngu' lako. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma'loko liu siapi Pilatus yao okkosan sinangei ungkattu bisara anna saemo pepasanna bainena nakua: “Seroiko kalemu dio mai kara-karana itin to tangkasalanno, annu ura'na tau iatuo, napolalan megiri-giri pangngimpingku samai' bongi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sapo menge liumi urrasi tau buda kapala imam sola perepi'na to Yahudi melau lako Pilatus anna malara Barabas dirappanan, anna Puang Yesus dipatei. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mekutana pole omi Pilatus lako tau buda nakua: “Bennannamo inde to dua muporai la kurappanangkoa'e?” Natimba' nakua: “Barabas!” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nakuamo Pilatus: “Ianna susi too, aka la kupogau' lako inde Yesus sidikuaan To dibassei bayu-bayu la ma'pasalama'e?” Natimba' nakua: “Pasokki lako kayu pantokesan!” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mekutana pole omi Pilatus nakua: “Sapo aka kakadakean mangka napogau'?” Sapo tuttuan sipealo'-alosan nakua: “Pasokki lako kayu pantokesan!” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tapakala sumpumo Pilatus, ta'mo dengan lalan senga' naita la naola urrappanan Puang Yesus, anna marassammo duka' la rukka tau. Ummalami wai anna umbasei limanna naita tau buda napasiolaan ma'kada nakua: “Usseroinakkao kaleku dio mai kamateanna inde taue, ikomoa' ummissananni.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Natimba' tau buda nakua: “Yaoko tanarambui dioko tanato'doi kamateanna inde taue. Kamimora sola pembatisangki urrengnge'i kamateanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Urrappanammi Barabas Pilatus anna ussua tau ungkambei Puang Yesus anna mane pebenganni la dipasok lako kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mangkai too, umbaami Puang Yesus tantarana gubernur Pilatus lako banuanna gubernur, anna untambai asan solana anna liling tamai. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ummalaiammi pakeanna Puang Yesus anna mane papakeii bayu rui' malea rupanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Naananammi songko' susi songko' tomaraya sapo ma'duri anna pasongko'i anna mane patetangngi tekken lima kananna sirapan tomaraya. Mangkaii, malimuntu' asammi menomba kari' dio tingngayona Puang Yesus anna telle-tellei nakua: “Tabe', tomarayanna to Yahudi.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Anna mane tikkuduii anna ummala tekken dio limanna Puang Yesus anna lappakkianni ulunna. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mangkai natelle, naalaimi bayu rui'na anna papakeii sule innang pakeanna. Mangkaii, dibaami lao la dipasok yao kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ummolai lalan umpellei kota, sitammumi mesa tau disanga Simon to dio mai kota Kirene. Napassami tantara umpassan kayu pantokesanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ullambi'i mesa angngenan disanga Golgota, kalembasanna angngenan karorak ulu, ");
INSERT INTO mqjNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","dibeemmi anggur mangka dipasirau susi pa'du Puang Yesus. Sapo mangkanna nasandak Puang Yesus, mokami ummiru'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Napasokmi tantara lako kayu pantokesan, anna undii pakeanna la naola untawa-tawai. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Anna mane sikaloko dio undagaii. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dengammi pangnguki' dipalekke' yao tondonna la diola ummissananni ura'na dingei umpasokki lako kayu pantokesan nakua: Iamo Te Yesus Tomarayanna To Yahudie. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dengan duka' dua to kadake nasimbaraan Puang Yesus dipasok yao kayu pantokesan, mesa dio tandai kananna anna mesa dio tandai kairinna. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Angganna to liu lalan ummola angngenan iatoo, ummiling-iling asan anna untelle Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nakua: “Anna la urroppokangko para' Banua Ada'na Puang Allata'alla ammu pake'de'i sule tallungngallo. Ianna Anakna tongangko Puang Allata'alla, rappanangko kalemu ammu turun yao mai itin kayu pantokesanno!” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Susi toi duka' kapala imam anna to untarru' issinna sura'na Musa sola perepi'na to Yahudi untelle asan Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","nakua: “Maka' tau senga'mo la napasalama'mi, sapo ianna kalenamo ta'mo nabela napasalama'. Ianna tomarayanna tongan to Israel, la turun yao mai kayu pantokesan, angki oreanni pole'. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anna Puang Allata'alla para' nasissarei. La taitamia' temo battu' la naaku tongarri Puang Allata'alla umpasalama'i annu mangka nakua: ‘Anaknana' Puang Allata'alla.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sae lako inde dua to kadake to nasolaan ditoke'e untelle duka' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tangngai allo, malillimmi padang illalan lili'na lembang iatoo sae lako tettek tallu karuen. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tettek tallui karuen, metambami Puang Yesus nakua: “Eli, Eli, lama sabakhtani?” Kalembasanna: “O Dewatangku, O Dewatangku, maakari ammu tampena'?” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pira-pira to urrangngi petambana Puang Yesus to dio angngenan iatoo, sipantula'-tula' nakua: “Untambai nabi Elia.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Napasirra' siami mesa tau ummala bunga-bunga susi lumu' anna rammei rokko anggur maissuk, anna mane palekke'i lako roan anna padundui pudukna Puang Yesus la napairu'. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sapo dengan pira tau ungkuai: “Dako'pa, anta petua'i battu' la sae tongarri Elia umpasalama'i.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Napemandui polemi metamba anna mane kattu penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Attu iatoo, sampin pesapa' illalan Banua Ada'na Puang Allata'alla sesse' tipa'dua mengkalao yao sae rokko. Pandondan padang napobua' lino' kamai anna piak-piak batu. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Buda lokko' titungka', buda toi duka' petauanna Puang Allata'alla to mangkamo mate dipatuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mangkai tuo sule Puang Yesus dio mai alla'na to mate mane mallairi dio mai liang lu tama Yerusalem kota masero, lambisan naita tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Marea' asammi tantarana Roma sola ponggawana to marassan undagai Puang Yesus anna ussa'dingmo lino' kamai anna ummita angganna inde kadadianne, lambisan ma'kada nakua: “Manassa Anakna tongan Puang Allata'alla inde taue.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dengan duka' pira-pira baine umparandan mambelai, to siumpamoloii mengkalao dio Galilea, ");
INSERT INTO mqjNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","susinna Maria Magdalena, indona Yakobus anna Yusuf disanga duka' Maria, anna bainena Zebedeus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","La kuku'i bongi, saemi mesa tomakaka disanga Yusuf to Arimatea, mesa duka' passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Laomi umpellambi'i Pilatus anna umpelau batang rabukna Puang Yesus. Napa'parentammi Pilatus anna malara batang rabukna Puang Yesus dipalessu' lako Yusuf. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mengkalao siami Yusuf lao ummala batang rabukna Puang Yesus anna balunni sampin mabusa, ");
INSERT INTO mqjNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","anna mane patamai lokko'na mane mangka napapia dio mesa tanete batu. Ullenggannimi mesa batu kamai natutu'ianni anna mane le'ba. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Torropi Maria Magdalena sola mesa baine disanga duka' Maria dio mesa angngenan umparandan lokko'. ");
INSERT INTO mqjNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Masiangngi, sirupang allo katorroan saemi kapala imam sola to Farisi mengngolo lako Pilatus ");
INSERT INTO mqjNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","anna ma'kada nakua: “O tuang, kikilalai tula'na anna tuopa inde to ma'papusae, nakua: ‘Allo katallunna la tuona' sule.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dadi kenamala ussuako tau undagai lokko' sae lako allo katallunna. Annu ianna tae' la dipateen, la sae passikolana umbokoi batang rabukna anna mane pa'peassakanni lako tau buda kumua tuomi sule. Napolalan marru la buda tau napapusa ke dako' anna la lessu'na.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Natimba' Pilatus nakua: “Solanni pira-pira tantara ammu laoa' undagai manappai itin lokko'nao.” ");
INSERT INTO mqjNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lao tongammi lako liang daga anna umpalekke' mesa tanda dio batu ditutu'ianni anna malara naissanan ke dengan untungka'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lessu'i allo katorroan, la tibungka' kalemi masiang allo Minggu, mengkalaomi Maria Magdalena anna mesa solana disanga duka' Maria lao umpetua' liangna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tapakala tokke'mo dadi lino' kamai annu dengan mesa malaeka'na Dewata turun yao mai suruga ullenten lao batu ditutu'ian lokko' anna ma'loko yao. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Inde malaeka'e pakkillo' susi kila' lindona anna mabussang pakeanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lumalla' asammi to daga marea' lambisan susi babangmi to mate diita. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sapo ma'kada malaeka' lako inde bainee nakua: “Daua' marea'. Kuissanan kumua saekoa' umpeang Puang Yesus to mangka dipasok yao kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Sapo ta'mo dengan inde, annu mangkami dipatuo sule susi mangka natula'. Maikoa' umpetua'i angngenan dingei umpamamma'i. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma'sirra'mokoa' lao umpaissanni passikolana kumua tuomi sule Puang Yesus dio mai alla'na to mate anna le'bamo yolo lako Galilea. Anna diopa ammu mane silambi'. Pengkilalai manappaia' te tula'ku matinne.” ");
INSERT INTO mqjNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Mengkalao siami inde baine umpellei lokko'e, sikondongan sirau marea' anna dore' illalan penawanna lao umpaissanni passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ummolai lalan, tokke'mi napellambi'i Puang Yesus anna pa'kadaii. Naropangngi siami anna raka'i lentekna napasiolaan napenombai. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nakuamo Puang Yesus: “Dau marea', laomokoa' ammu kuanni angganna sa'do'dorangku anna lao lako Galilea, anna diopa angki mane silambi'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Le'bai inde dua bainee, mengkalao duka' pira to undagai lokko'na Puang Yesus tama kota Yerusalem anna tula'i lako kapala imam angganna kara-kara mangka dadi. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma'mesami kapala imam sola perepi'na to Yahudi. Nasituru'-turu'imi la umbeen buda doi' tantara to undagai lokko'na Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","anna kuanni: “La mukuaa': ‘Sae bongi passikolana ummalai batang rabukna, tae' kisa'ding angki mamma'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ianna tokke'ra naissanan gubernur inde kara-karae, angki pantula'imira indana sussaikoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ummalami doi' inde to dagae anna palakoi susi mangka dipakari'disanni. Napolalan iate tula'e kalelean illalan alla'-alla'na to Yahudi sae lako temo. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mangkai too, mengkalaomi sapulo mesa passikolana Puang Yesus lako Galilea lu langngan mesa tanete mangka natulasanni Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tappana ummita Puang Yesus, napenombai siami. Sapo dengampi pira-pira solana bata illalan penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nadendeimi Puang Yesus anna kuanni: “Angganna kakuasaan susi yao suruga tenni illalan lino mangka asammi dipalessu' rokko lisu pala'ku. ");
INSERT INTO mqjNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dadi la laokoa' umpellambi'i angganna ma'rupa tau sae lako lili'na lino ammu popendadii passikolaku. Tedokkia' ummolai sanganna Ambe', Anakna, anna Penawa Masero, ");
INSERT INTO mqjNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ammu patudui umpalako angganna mangkanna kupa'parentaan lako kalemua'. Anna la mupengkilalaia' kumua la tontongna' matutu ussolangkoa' sae lako allo ma'katampakanna.”");
INSERT INTO mqjNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pa'parandukanna Kareba Kadoresan untetteran Puang Yesus Kristus Anakna Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","susi mangka tiuki' illaan sura'na nabi Yesaya nakua: “Petua'i, iamo te pesuangkue to kusua la uyyoloanangko, to la umpatokangko lalan. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Anna la metamba-tamba dio padang alla' nakua: ‘Patokanni lalan Dewatanta ammu maloloananni.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Iamo nangei metamba-tambamo Yohanes to simantedok dio padang alla' nakua: “Mengkatoba'mokoa' ammu ditedok, anna garri'iangkoa' kasalaammu Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sasaeammi tau lu dio mai lembangna Yudea anna Yerusalem umperangngii. Ummakui asammi kasalaanna anna tedokki dio Salu Yordan. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Inde Yohanes to simantedokke umpa'bayu rui' bulu unta anna ma'beke' balulang. Bando' sinaponande sola duro. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Umpalanda'mi kareba nakua: “Ianna lessu'mo' tee, la dengan sae to marru untondon kakuasaangku, annu moi la anggana' malimuntu' umbukaianni pekapu' palopakna, tae' toina' la sipato'. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Annu wai kao kutedokangkoa' sapo' Penawa Masero ia la nabengangkoa' sirapan natedokangkoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Attu iatoo saemi Puang Yesus dio mai tondok Nazaret lembangna Galilea, anna tedokki Yohanes dio Salu Yordan. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kendekna dio mai wai, ummitami langi' titungka' anna turun Penawa Masero susi dangan-dangan urrampoii. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dirangngi siami kamaranna Puang Allata'alla yao mai suruga nakua: “Ikomo anakku to kukamasei anna kuporai.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mangkaii, natettemi Penawa Masero lako padang alla'. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Torromi dio appa' tapulo allona nasudi ponggawana setang. Dio angngenan iatoo buda olo'-olo' malaera nasolaan anna buda duka' malaeka' untarakannii. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mangkai disakka Yohanes, lu lakomi Galilea Puang Yesus umpalanda' Kareba Kadoresan yao mai Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nakua: “Nalambi'mi attunna la ma'parenta Puang Allata'alla. Mengkatoba'mokoa' ammu orean Kareba Kadoresan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Inde anna menono'mo Puang Yesus ummundu' biring Tasik Galileae ummitami to sirondong disanga Simon anna Andreas marassan madala aka innang to madala. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Napantula'imi nakua: “Maikoa' ammu turu'na' aka la kupopendadikoa' to la undala ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Untampe siami dalana anna le'ba' ummula'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Umpatarru' omi penonosanna, sapo' ta'pa mambela naola anna ummita pole omo to siulu' disanga Yakobus anna Yohanes anakna Zebedeus marassan umpapia dalana yao lopi. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Natambaimi Puang Yesus, napolalan tappa mengkalao umpellei ambena yao lopi sola angganna sarona anna le'ba' ummula'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Saemi Puang Yesus sola passikolana lako Kapernaum. Nalambi'i allo katorroan, tamami banua pa'sambayanganna to Yahudi anna ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mangnga-mangnga asan tau urrangngi pepa'guruanna, annu ma'pa'guru sitonda kakuasaan, sisala pa'pa'gurunna to untarru' issinna sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Illalan banua pa'sambayangan attu iatoo, dengan mesa to natamai setang. Inde taue meoli nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Yesus to Nazaret, dengandaka alla' tapoalla'? La saerokoka ussanggangngikan? Kuissanangko, To Masero lu yao mai Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sapo' tappa nasadangngi Puang Yesus nakua: “Kamma'ko! Mallaiko illalan mai kalena itin tauo.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Umpopa'kalumpiri'-piri'mi to natamai inde setangnge anna kumillong-killong siolaan mallai illalan mai kalena inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mangnga-mangnga asan tau, napolalan sipantula'-tula' nakua: “Akara indee? Mesa pepa'guruan bakaru sitonda kakuasaan. Mala umparenta setang, anna itin setangngo mengkaola lako kalena!” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tappa silele siami kareba illalan lili'na Galilea untetteran Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Umpelleimi banua pa'sambayangan Puang Yesus sola Yakobus anna Yohanes anna lu lako banuanna Simon anna Andreas. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saei lako, mamma'ria matukanna Simon baine annu makula'. Natula'mi tau lako Puang Yesus sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Le'ba' siami tama angngenanna inde bainee, naanda'i limanna anna bangunanni. Malapu' siami napolalan nabela mantarakanni. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lendu'i allo, marammomi, budami to masaki anna to natamai setang dibaa lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sasaeammi to ma'tondok ma'karompo' dio luba'ba. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Buda tau napomalapu' dio mai ma'rupa-rupa saki, anna urrambai buda setang. Inde mai setangnge tae' natangga' Puang Yesus mantula' annu ummissanan asammi Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Makale'na, nannaripi anna millikmo Puang Yesus anna mengkalao lako angngenan maitu-itu ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sapo' lao napelalan Simon sola solana. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nalambi'i nakuammi: “O Tuangguru nasipeang-peangngimoko tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sapo' natimba' nakua: “La lao opikia' ullelean tondok sikadappi'ta, angku malara umpalanda' Kareba Kadoresan, anu' iamo kutungkanan sae.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mengkalaomi ullelean pa'sambayanganna to Yahudi illalan lembangna Galilea umpalanda' Kareba Kadoresan anna buda setang narambai. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pissan attu, dengan mesa to dolengan sae umpellambi'i Puang Yesus anna malimuntu' dio tingngayona napasiolaan ma'kada nakua: “Ianna moraiko, malana' mupomalapu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tigara' siami penawanna annu rantang buana, napolalan ummangka' limanna ummanda'i inde taue anna ma'kada nakua: “Moraina', malapu'moko!” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Monda siami sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nasuami lao anna pakari'di'i ");
INSERT INTO mqjNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","nakua: “Pengkilalaii, dau tetteranni lako tau senga' kara-kara dadi lako kalemu. Sapo laomoko umpa'paitaan kalemu lako imam ammu buai pemala'mu ura'na kamalapusammu situru' parentana Musa annu la tandana kamalapusammu lako tau kamban.” ");
INSERT INTO mqjNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sapo laoria natetteran rekke sau' inde taue, napolalan ta'mo umpa'manta-mantaan kalena Puang Yesus ke tamai tondok. Torro lakomi salian dio angngenan maitu-itu. Sapo' moi susi too, napellambi'i liu tau lu dio mai angganna angngenan. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pira-pirangngalloi mangkanna, sae pole omi Puang Yesus lako Kapernaum. Tappa nasa'dingmi tau kumua sae dio mesa banua. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sasaeammi tau ma'karompo' umpellambi'i, napolalan ta'mo dengan lo'bang angngenan, ponno tau sae lako sa'de ba'ba. Marassanni Puang Yesus umpalanda' battakadanna Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","saemi pira-pira tau umbaa mesa to balimbingan nabulle appa' tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Sapo tae' naissan napasae lako tingngayona Puang Yesus annu nalawai tau buda. Lu langngammi papa anna so'boi patunna rokko Puang Yesus anna ullolloran to balimbingan sitonda ampa'na rokko. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tappana naita Puang Yesus kapangngoreananna ma'kadami lako to balimbingan nakua: “O anakku digarri'mi kasalaammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sapo dio duka' reen pira-pira to untarru' issinna sura'na Musa, mekutana illalan penawanna nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Maakari anna mantula' susi inde taue? Untelle Puang Allata'alla! Bennamo la mala unggarri'i kasalaan ke tangngia Puang Allata'alla? Angga mesa-mesanna Puang Allata'alla mala unggarri'i kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Sapo tappa illalan penawanna Puang Yesus ummissanan pikki'na to untarru' sura'na Musa napolalan ma'kada lako nakua: “Maakari anna kendek pikki' susi illalan penawammua'? ");
INSERT INTO mqjNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aka la kupogau' lako inde to balimbinganne kupolalan la umpa'paitaan kakuasaangku? La kukuaraka: ‘Digarri'iammoko kasalaammu;’ Iaraka anna la kukua: ‘Ke'de'ko, angka'i ampa'mu ammu menono'?’ ");
INSERT INTO mqjNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sapo la kupaitaikoa' temo kumua Anak Mentolino ma'kuasa unggarri'i kasalaan illalan lino.” Anna mane ma'kada lako inde to balimbinganne nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Millikko, angka'i ampa'mu ammu sule lako banuammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Membangun siami anna ummangka' ampa'na anna le'ba' lako salian naita tau buda. Mangnga-mangnga asan to ummitai anna umpakasalle Puang Allata'alla nakua: “Manianna te diita kara-kara susie.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mangkai too, lao omi lako biring Tasik Galilea Puang Yesus. Buda tau sae umpellambi'i anna pa'gurui. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Marassanni ma'pa'guru Puang Yesus ummola lalan, ummitami mesa tuang passima disanga Lewi anakna Alfeus ma'loko-loko illalan kantoro'na. Napa'kadaimi Puang Yesus nakua: “Maiko ammu turu'na'.” Ke'de' siami anna le'ba' sola. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Saturanni, ummandemi Puang Yesus sola passikolana dio banuanna Lewi sola buda tuang passima senga' anna to sinasangai solana to kadake, annu innang budami tau susi unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tappana naita to untarru' issinna sura'na Musa to nakala' kombonganna to Farisi, mekutanami lako passikolana Puang Yesus nakua: “Maakari Tuanggurummua' anna ummande sola tuang passima anna to kadake?” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sapo' narangngi Puang Yesus pekutananna napolalan natimba' nakua: “Tangngia to malapu' umparallui tuandotto' sapo' to masakiria. Tae'nakkao sae umpeang to ussanga kalena malolo sapo' la umpeangna' angganna to digente' to kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pissan attu, marassan ma'puasa passikolana Yohanes anna passikolana to Farisi. Saemi tau umpellambi'i Puang Yesus anna kutanaii nakua: “Maakari anna ma'puasa passikolana Yohanes sola passikolana to Farisi anna tae' Iko ma'puasa passikolamu?” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Natimba' Puang Yesus ummoyong mesa pa'rapanan nakua: “Tae' dengan to ullomba pa'sombaan tae' la ummande ke diopi reen to mane kebaine. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sapo' dengan attunna la dialai to mane kebaine illalan mai alla'-alla'na to ullombai. Attu iapi pole' too anna mane mala ma'puasa. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tae' dengan tau la umpopetampi' sampin bakaru lako pakean malusa annu ianna timpo'do'mo sampin bakaru satuttuan sesse'mi pakean malusa. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tae' toi duka' dengan tau la untua' anggur bakaru tama pa'pangngeian malusa, annu anggur bakaru mala untessean pa'pangngeian malusa. Katampakan bassi masala. Dadi anggur bakaru manggi' dipalutama pa'pangngeian bakaru.” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pissan attu sirupang allo katorroan ummola bela' gandum Puang Yesus sola passikolana. Ummolai lalan napasiolaan siami passikolana ummala gandum. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nakuamo to Farisi lako Puang Yesus: “Nenne'ipi passikolamu, maakari passikolamu anna ungkarang tala malanna dipogau' ke allo katorroan?” ");
INSERT INTO mqjNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Natimba'mi nakua: “Ta'paka iko dengan mubaca pa'pogau'na Daud attunna Abyatar mendadi Pongkena Imam? Attu iatoo tadea'mi Daud sola to unturu'i, annu tae' dengan kinallo nabaa. Lu tamami Banua Ada'na Puang Allata'alla anna ummande roti pemalasan, moika anna angga imam mala ummandei. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Annu allo katorroan dipadengan la napopa'guna ma'rupa tau, tangngia ma'rupa tau la napopa'guna allo katorroan. ");
INSERT INTO mqjNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sitonganna Anak Mentolino Puangna duka' allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pissan attu tama omi banua pa'sambayanganna to Yahudi Puang Yesus. Illalan inde pa'sambayanganne dengan mesa tau mate limanna sabali. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dio duka' reen pira-pira tau morai la umpeangan kasalaan Puang Yesus. Napalao mata liumi annu nakua illalan penawanna, umba ke tokke'i umpomalapu' to masaki illalan allo katorroan anna dipolalan umpaalinni kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma'kadami Puang Yesus lako inde to mate limanna sabalie, nakua: “Ke'de'ko illalan alla'-alla'na tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Anna mane mekutana lako tau buda nakua: “Umbanna la sipato' dipogau' ke allo katorroan, kamapiaarraka, kakadakearraka. La ungkamaseiriki'ka padanta, la dipateirika?” Sapo' tae' dengan tau mentimba'. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Keara' Puang Yesus anna rosso buana ummita to Farisi ura'na kamakarrasan penawanna. Umpalilingmi pennenne'na anna mane ma'kada lako to masaki nakua: “Angka'i limammu!” Ummangka'mi limanna, malapu' siami. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Suummi lako salian to Farisi anna lao umpamesa kada sola to unturu' tomaraya Herodes, umpeang lalan la umpatei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mangkai too ummalaimi kalena Puang Yesus sola passikolana lu lako biring Tasik Galilea. Buda tau ummula'i, to lu dio mai Galilea anna dio mai Yudea, ");
INSERT INTO mqjNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","to lu dio mai Yerusalem, Idumea, anna dio mai lamban lianna Salu Yordan tandai mata allo, dio mai lembangna Tirus anna Sidon. Ia nangei sasaean inde mai taue annu umpelelemi angganna kara-kara mangka napogau' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Buda tongan-tongan tau attu iatoo, napolalan ussua passikolana umpatokanni lopi la nangei indana sisippi'i tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Budami to masaki napomalapu', napolalan sipa'silullusan to masaki lako sa'dena morai la urrumbui. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ianna dengan to natamai setang ummita Puang Yesus, malimuntu'mi dio tingngayona anna mealo' nakua: “Anaknako Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sapo undapai tongan-tongan setang la umpokadai benna Puang Yesus sitonganna. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mangkaii, lu langngammi tanete Puang Yesus anna untambai to naporai, napolalan sae napellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Umpilemi sapulo dua tau to nagente' rasul la ussolanni anna la nasua lao umpalanda' Kareba Kadoresan, ");
INSERT INTO mqjNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","anna la nabenganni kakuasaan urrambai setang. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Inde to napile sapulo duae iamo: Simon to nasangai Petrus, Yakobus anna Yohanes anakna Zebedeus to nasangai Boanerges, kalembasanna “susi guntu' yao langi' annu' kamai oninna”. Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus anakna Alfeus, Tadeus, Simon to nakala' kombongan Zelot, Yudas Iskariot, to umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mangkai too sulemi Puang Yesus anna lu tama mesa banua. Sae omi tau buda ungkarompo'i napolalan ta'mo dengan attunna ummande sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Inde anna pelelemi sa'do'dorannae, mengkalaomi la lao ummalai, annu nasanga ta'mo montong penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Attu iatoo sae duka' pira-pira to untarru' issinna sura'na Musa dio mai Yerusalem, ma'kada nakua: “Kakuasaanna Beelzebul ponggawana setang illalan kalena napolalan mala urrambai setang.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Natambaimi Puang Yesus anna tulasanni pa'rapanan nakua: “La dengangka leleanna ponggawana setang la urrambai setang? ");
INSERT INTO mqjNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ianna pantan umpapia kombongan tau illalan mesa kaparentaan napolalan siassung-assung, tae' la mala ke'de' matoto'. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Susi toi duka' mesa pendaposan ke pantan laoi tau illalan, innang tae' la nabela ke'de' matoto'. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Susi siami duka' kaparentaanna ponggawana setang. Ianna tae' dengan kamesaanna anna anggamo sipoewali pakaia, kaparentaan iatoo tae' la masae anna pa'demo. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Sapo' tae' dengan tau la mala tama banuanna mesa to matoro anna alai ewananna ke tae' napungo yolo. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kupokadangkoa' sitonganna, angganna kasalaan anna pa'tellena ma'rupa tau mala digarri'i, ");
INSERT INTO mqjNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","sapo' to untelle Penawa Masero tae' dengan leleanna la digarri'i annu gau' susi too dipokasalaan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ia nangei mantula' susi Puang Yesus annu dengan tau untellei nakua: “Natamai setang.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mangkai too saemi indona sola sirondongna Puang Yesus. Naampaimi dio salian anna ussua tau untambai Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Attu iatoo buda tau ummokko' ulliling tamai. Nakuammi: “O Tuangguru, napeangko indomu sola sirondongmu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Natimba' nakua: “Bennara Kao indoku anna sirondongku?” ");
INSERT INTO mqjNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Umpalelemi matanna lako to ullilingngi anna ma'kada nakua: “Iamo te mai indoku anna sirondongkue! ");
INSERT INTO mqjNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Annu benna-benna umpogau' pa'kuanna Puang Allata'alla, iamo sirondongku anna indoku.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pissan attu ma'pa'guru omi Puang Yesus dio biring Tasik Galilea. Buda omi tau sae ungkarompo'i. Lu langngammi lopi dio biring tasik anna ummokko' yao, anna inde tau budae yao gantanan. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Umpalanda'mi buda pepa'guruan sapo' umpake pa'rapanan. Nakuamo: ");
INSERT INTO mqjNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Perangngia'i, dengan mesa tau lao mangngambo'. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Marassanni mangngambo' dengan bannena tappa lako lalan. Saemi dassi ummandei napolalan pura. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dengan banne tappa rokko litak mabatu, napolalan masimpan tuo annu manippi' litakna. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sapo' tappana nadellekki allo, malayumi napolalan marekko' annu tae' kalando waka'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dengan toi duka' banne tappa tama to' kurra ma'duri. Tuttuan marumbomi to' duri ungkabu'i napolalan tae' nabela kembua. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dengan duka' banne tappa rokko litak malunak. Tuo marumbomi napolalan kembua, dengan tiluppi' pentallu pulo, dengan tiluppi' pennannan pulona, anna dengan duka' tiluppi' pessaratu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nakuamo Puang Yesus: “La napatananni manappa talinga ma'rupa tau inde tula'kue.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Inde anna angga mandamo Puang Yesus sola to unturu'i anna sapulo dua passikolanae, umpekutanammi kalembasanna pa'rapanan mane mangka natula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Natimba' nakua: “Mangkamokoa' iko dipaissanni tula' dibuni untetteran kaparentaanna Puang Allata'alla. Sapo' ditula' pa'rapanan lako tau senga' ");
INSERT INTO mqjNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","anna malara: Natimba' nakua: ‘Moi la naita, tae' la naissanan. Moi la narangngi, tae' la napekalembasan annu ma'pasule manii anna garri'iammi kasalaanna Puang Allata'alla.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anna mane nakua: “Ta'raka ikoa' muissanan kalembasanna inde pa'rapananne? Ianna susi too, umbamo la mukua ummissanan pa'rapanan senga'? ");
INSERT INTO mqjNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","To mangngambo' dipasirapan to umpalanda' battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Banne tappa lako lalan sirapan to urrangngi battakadanna Puang Allata'alla sapo' narappai siami ponggawana setang. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Banne tappa rokko litak mabatu, sirapan to urrangngi battakadanna Puang Allata'alla anna tappa natarima sitonda kadoresan, ");
INSERT INTO mqjNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","sapo' tae' napaillan tambuk. Ianna saemo kamasussaan anna dipakario-rio ura'na unturu' battakadanna Puang Allata'alla tappa umpemboko'imi kapangngoreananna. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Banne tappa tama to' kurra ma'duri sirapan to untarima battakadanna Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sapo' malallan umpikki' salu katuoanna. Marru umpakalandomia ewanan lino, umpangngula' kamoraianna lako saianna, napolalan ungkalembei battakadanna Puang Allata'alla lambisan tae' nabela kembua ");
INSERT INTO mqjNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Anna banne tappa rokko litak malunak sirapan to urrangngi battakadanna Puang Allata'alla anna tarima mapiai napolalan kembua barri'. Dengan tiluppi' pentallu pulo, dengan tiluppi' pennannan pulona, anna dengan duka' tiluppi' pessaratu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mantula' omi Puang Yesus lako tau buda nakua: “Tae' dengan tau umpau' ballo anna palumbangngi baka battu napadiong wi' mammasan, sapo' napayao innang angngenanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Annu tae' dengan membuninna tae' la dipatandaan, anna tae' dengan disamboinna tae' la dipakawanan. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","La napatananni manappa talinga ma'rupa tau inde tula'kue.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma'kada omi Puang Yesus nakua: “Pasaluia' penawa inde tula'kue! La nabengangko kapaissanan Puang Allata'alla umpekalembasanni battakadanna situru' kamoraiammu la umpengngissananni, anna la narangngannian polepokoa'. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Annu benna-benna ummampui kapaissanan, la dirangngannian polei sapo' benna-benna tae' ummampui kapaissanan, la dialai pissan ke dengan aka dio kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Umpatarru'mi pepa'guruanna Puang Yesus nakua: “Kaparentaanna Puang Allata'alla sirapan to ummambo' banne rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mangkai naambo' napelleimi lao anna mamma' ke bongi millik ke allo. Tuomi inde bannee, kendaun, anna satuttuan malangka'. Sapo' tae' talambi' pikki'na to mangngambo' umba nakua tuo. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Annu innang litak umpatuoi, umpasuunni bulinna, anna mane sapena sola buana. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ianna matuamo buana, saemi puangna ussae'i annu nalambi'mi attunna dipeparei.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nakua pole omo Puang Yesus: “Akamo la dipasitintian battu dipasirapanan kaparentaanna Puang Allata'alla? ");
INSERT INTO mqjNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kaparentaanna Puang Allata'alla sirapan lise' sawi diambo' rokko litak, annu lise' tananan iamo tee randan barinni' illalan lino. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sapo' ianna diambo'mo, marumbomi tuona, napolalan iamo randan kamai angganna utan. Sikamai tangkena napolalan mala nangei kesserang dassi annu kationgan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Buda pa'rapanan natetteran Puang Yesus la naola umpalanda' battakadanna Puang Allata'alla situru' kapaissannanna tau buda la umpekalembasanni. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tae' dengan ma'pa'guru lako tau buda ke tae' ummolai pa'rapanan. Sapo ianna passikolana napa'guru, natetteran simesa-mesa lambisan makaleso asan. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Karuenni allo iatoo, ma'kadami Puang Yesus lako passikolana nakua: “Maikoa' anta ma'lopi lian lamban lianna tasik.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Langngammi lopi nangei ma'loko Puang Yesus passikolana anna mengkalao untampe tau buda. Dengan duka' pira-pira lopi nasolaan mengkalao. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tapakala tokke'mo sae talimpuru' umpakendek bombang kamai napolalan marassammo ponno wai lopinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Attu iatoo mamma' Puang Yesus ma'allonan illau' pollo'na lopi. Natundammi passikolana anna kuanni: “O Tuangguru, maakari ammu ma'lembe-lembe? La tallammikia'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Millikmi Puang Yesus umpamattan talimpuru' anna mane ma'kada lako tasik nakua: “Mattangko!” Monda siami talimpuru' sola bombang napolalan mattan tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Anna mane ma'kada lako passikolana nakua: “Maakari ammu marea' sigalia'? Maakaria' ammu tae' mangngorean?” ");
INSERT INTO mqjNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Marea' asammi passikolana napolalan sipantula'-tula' nakua: “Benna tappa'ra inde taua'e? Annu moi talimpuru' sola tasik mala mengkaola lako kalena!” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Attu iatoo, saemi Puang Yesus sola passikolana lian biring Tasik Galilea dio lembangna to Gerasa. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Turunna yao mai lopi, napellambi'imi mesa to natamai setang lu dio mai liang. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Inde taue sitorro lako liang, annu' ta'mo dibela dipungo, moi rante bassi nakattu-kattu toi. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Aka pempirammi disangkala anna mane dirante bassii, sapo' ungkattu-kattu liu rante bassi anna urrebong-rebong sangkala, napolalan nasoro'i asammo tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Allo bongi angga kakando-kando lako liang anna langngan tanete napasiolaan meoli-oli, anna undarra-darra kalena natuttukki batu. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mambela-belapi anna ummitamo Puang Yesus, kumondong siami umpellambi'i anna menomba dio tingngayona. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma'kadami Puang Yesus lako setang illalan kalena inde taue nakua: “O setang, mallaiko illalan mai kalena inde taue!” Napetonganni siami mealo' nakua: “O Yesus Anakna Puang Allata'alla to randan matande, la muakarakkao? Kupelau matin, pa'pindaiko Puang Allata'alla kumua tae'na' la mupakario-rio.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nakutanaimi nakua: “Aka sangammu?” Natimba' nakua: “Disangana' Legion annu budakan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mengkarumase-masemi lako Puang Yesus anna pelaui nakua: “Kenamala tae'kan la murambai lako lembang senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tae' mambela alla'na angngenan iatoo, buda bai marassan menduruk lako pili' tanete. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Napelaumi setang nakua: “Sua tamakan kalena inde lako baie.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mallaimi illalan mai kalena inde taue anna untamai bai buda napolalan sikakondong ullenten kalena rokko palimping, anna sipengkatibe-tibean tama tasik, napolalan bonno' asan. Inde baie umbai dengan la dua sa'bu budanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sikakondong siami to ma'pande bai lao untetteran kadadian iatoo tama kota anna lako tondok sikadappi'na. Turun tondokmi tau la lao umpetua' kadadian iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Saemi umpellambi'i Puang Yesus napolalan ummita to natamai setang ma'loko-loko, ma'pakemi, annu' malinomi. Marea' asammi tau ummita kakuasaanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Untetterammi to natamai setang sola bai to ungkamantang kadadian iatoo lako to ma'tondok. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Napelaumi to ma'tondok lako Puang Yesus kenamala untampe lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","La langnganni lopi sule Puang Yesus, napelaumi iato to natamai setangngo kenamala napabeai lao sola. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sapo tae' natangga' Puang Yesus sangngadinna nakuanni: “Sulemoko lako tondokmu ammu tetteranni lako rapummu sola lako satondokmu kara-kara mangka napogau' Puang Allata'alla lako kalemu anna umba nakua ungkamaseiko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mengkalao tongammi inde taue anna tetteranni illalan lili'na Dekapolis kara-kara mangka napogau' Puang Yesus lako kalena, napolalan mangnga-mangnga asan tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lambanni sule Puang Yesus sola passikolana ma'lopi, sasaean omi tau ungkarompo'i dio biring tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Saemi duka' mesa tau disanga Yairus, perepi' illalan pa'sambayangan dio lembang iatoo. Ummitanna Puang Yesus tappa malimuntu'mi dio tingngayona anna ");
INSERT INTO mqjNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","melau sitonda kaparannuan nakua: “O Tuangguru, dengan mesa anakku baine masaki, masanta', lao siapoko untoei anna malapu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Mengkalao siami Puang Yesus sola Yairus. Buda tau ummula'i sisippi'-sippi' lako sa'dena. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Illalan inde alla'na tau budae, dengan mesa baine sapulo duami taunna narua saki-baine tae' dengan la monda. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Budami tuandotto' umpakulii, napolalan puramo ewananna napopa'baya' sapo' tae' nabela malapu', sangngadinna tuttuan kerangngan sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Buda-budami tau narangngi untula' tanda memangnga-mangnga napadadi Puang Yesus, napolalan umpealla' tau umpengkadappi'i boko'na Puang Yesus anna rumbui bayu rui'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Annu nakua: “Moi podo kurumbumo bayu rui'na la malapu'mo'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Narumbunna bayunna tappa monda siami sakinna anna malapu' nasa'ding. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nasa'ding siami duka' Puang Yesus dengan kamataroan mallai illalan mai kalena. Menggirikmi lako boko'na anna mekutana nakua: “Bennakoa' urrumbu bayungku?” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Natimba'mi passikolana nakua: “Ta'raka Iko muita inde mai tau sisippi'-sippi' lako sa'demue, ammu mekutana pole oraiko kumua bennakoa' urrumbu bayungku?” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Umpalelemi pennenne'na tiku lao umpeang mata to urrumbui bayunna. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inde baine urrumbuie, naissananna kumua malapu', marea'mi lambisan lumalla'-malla'. Laomi lako tingngayona Puang Yesus malimuntu' anna akuii angga mangkanna napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma'kadami lako inde bainee nakua: “O anakku, kapangngoreanammu lako kaleku umpomalapu'ko. Laomoko sitonda kamasakkean annu' malapu'moko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Marassampi mantula' anna saemo to untambai Yairus nakua: “Bonno'mi anakmu, daumo ussussai Tuangguru.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sapo' napaboko'i penawa Puang Yesus tula'na anna ma'kada lako Yairus nakua: “Dau pomasussa penawammu, pomatoto'i kapangngoreanammu!” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mengkalao siamii sapo' anggami Petrus sola to sipoadi Yakobus anna Yohanes natangga' ummula'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Saei lako banuanna Yairus innang ropo'mi tau dio. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tamami banua anna ma'kada nakua: “Maakaria' anna mapa'di' penawammu sola tumangi'? Inde anakke tae' bonno' sapo' mamma'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sapo' napetawai asan tau. Ussuami tau suun lako salian anna mane le'ba' tama angngenanna to mate sola indona anna ambena inde anakke anna tallu passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Saena tama naanda'imi limanna anna ma'kada illalan basana nakua: “Talita kum,” kalembasanna: O odo', kukua matin millikmoko! ");
INSERT INTO mqjNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tappa membangun siami anna menono' leen. Inde anakke sapulo duami taunna. Mangnga-mangnga asan tau ummita kadadian iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma'pakari'di'mi Puang Yesus lako to ummitai nakua: “Pissan-pissannaia' mupokada lako tau inde kadadianne, indana issananni.” Anna mane ma'kada nakua: “Beennia' nande.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mengkalaomi Puang Yesus anna lu lako tondokna sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nalambi'i allo katorroan naparandukmi ma'pa'guru illalan banua pa'sambayanganna to Yahudi. Mangnga-mangnga asammi tau buda urrangngi pepa'guruanna annu sitonda kuasa napolalan sipantula'-tula' nakua: “Umbara nangei ummala kamanarangan? Kakeakasan akara illalan kalena? Maakari anna mala umpadadi tanda memangnga-mangnga? ");
INSERT INTO mqjNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Anna tukan kayu tee, anakna Maria, sirondong Yakobus, Yoses, Yudas, anna Simon. Anna sisola-sola liu siamikia' inde anak daranna.” Angganna to urrangngii surrak asan buana napolalan untumpu pala' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma'kadami Puang Yesus lako tau buda nakua: “Mesa nabi diangga' ke lakoi angngenan senga', sapo' tae' diangga' ke dioi tondokna, illalan alla'-alla'na kasarapuanna anna illalan banuanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Dadi ta'mo dengan umpadadi tanda memangnga-mangnga anggami umpomalapu' pira-pira to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mangnga-mangnga Puang Yesus aka tae' dengan kapangngoreananna satondokna. Mengkalaomi Puang Yesus ullelean tondok napasiolaan ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Untambaimi passikolana to sapulo dua anna beenni kakuasaan urrambai setang, anna mane suai lao sanda sidua. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Napakari'di'mi nakua: “Angga pakean illalan kalemua' la mubaa sola tekken anna sandala'mu. Tae'koa' la umbaa kinallo, bakku', anna doi'. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ianna saekoa' lako mesa tondok, pamesaia' angngenammu dio mesa banua, sae lako nalambi' attunna la mupelleia' sule. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anggaria ke dengan mesa tondok mulambi' anna natumpu pala'koa' tau illalan, pelleia' lao ammu pentambakan soyok dio lentekmu, annu la mendadi tanda lako tondok iatoo kumua mangka kasalaan dio olona Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mengkalaomi passikolana ullelean tondok anna ma'pakilala kumua la mengkatoba' ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Buda setang narambai, anna buda to masaki sinapasussui minnak napolalan malapu'. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Umpelelemi duka' Puang Yesus tomaraya Herodes annu' kaleleammi sanganna anna budamo tau untula'i nakua: “Tuo sule Yohanes to simantedok dio mai alla'na to mate, iamo nangei dengan kuasa illalan kalena napolalan mala umpogau' tanda memangnga-mangnga.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dengan pira tau ma'kada nakua: “Nabi Eliari teie.” Dengan toi duka' ma'kada nakua: “Mesa nabi susi mangka sae yolona.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Inde anna rangngimi Herodes-e, nakuamo: “Itin tauo Yohanes to simantedok, iato to mangka kupopelempo'i ulunnao sapo' tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Ia sia nangei ma'pikki' susi Herodes annu mangka tongan kadadian yolona, inde Herodes-e umpobaine Herodias, bainena Filipus, adinna. Attu iatoo ma'kada Yohanes lako Herodes nakua: “Pemali ke ummalaiko bainena sirondongmu.” Iamo nangei keara' Herodias lako Yohanes napolalan umpopesakka Yohanes Herodes anna patamai tarungkun. Sitonganna mapa'di' penawanna Herodias lako Yohanes anna morai la umpateii sapo tae' naola annu nadagaimi Herodes illalan tarungkun. Annu malaya' duka' Herodes lako Yahones annu naissanan kumua to malolo anna to masero. Ianna mangka omo urrangngi tula'na Yohanes, marumbaka' omi penawanna Herodes sapo silosso' inawanna umperangngii. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sapo' katampakanna, nalambi' pole' pa'kua penawanna Herodias attunna umpakaroa' allo kadadianna Herodes. Attu iatoo untambai asan to kamai illalan kaparentaanna, ponggawana tantara anna angganna perepi' illalan lembangna Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Illalan inde karoasanne, sumayo anakna Herodias baine napolalan losso' inawanna Herodes sola angganna to saena ummitai. Nakuamo tomaraya lako inde to sumayoe: “Iamo mupelau lako kaleku, iamo kubengangko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma'dandimi lako nakua: “Iamo mupelau lako kaleku iamo kubengangko, moi la sapiakna kaparentaangku.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Laomi ungkutanai indona inde anakke nakua: “Aka la kupelau lako tomaraya?” Natimba' indona nakua: “Ulunna Yohanes to simantedok.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma'sirra' siami lao umpellambi'i tomaraya anna pelaui nakua: “Kenamala mubeenna' ulunna Yohanes to simantedok dipadio pappalan temo.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rantang siami buana tomaraya, sapo' ta'mo naissan nasumbala annu mangkami ma'dandi lako narangngi to saena. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ussuami mesa pa'baraninna lao ullempo'i ulunna Yohanes. Mengkalao siami inde tau lako pa'tarungkunanne anna ullempo'i ulunna Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Umbaami sae inde ulue napadio pappalan anna beenni lako inde anak dara to sumayoe, naalami anna baanni lako indona. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tappana naissanan passikolana Yohanes kara-kara iatoo, saemi naala batang rabukna anna lamunni. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tapakala sule asammo rasul to mangka nasua Puang Yesus. Ma'mesami sola Puang Yesus anna tetterananni angganna mangka nakarang sola napa'patuduan. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Buda liumi tau sisonda-sonda sae, lambisan tae' dengan attunna ummande sola passikolana. Ma'kadami lako passikolana nakua: “Anta lao opa messala-sala lako angngenan maitu-itu anta melliwe sappalli'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mengkalaomi ma'lopi ussarakki kalena dio mai tau buda lu lako angngenan maitu-itu. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sapo buda tau ummitai mengkalao anna naissanan la naolanna, napolalan mengkalao duka' mangngola gantanan lambisan nayoloi sae lako. Inde mai taue lu dio mai pira-pira tondok dio lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Turunni Puang Yesus yao mai lopi, ummitami bu'dak tau napolalan rantang buana annu susi tappa' domba dilamba', tae' dengan to ungkambi'i. Naparandukmi umpalanda' ma'rupa-rupa pepa'guruan. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Karuenni, napellambi'imi passikolana anna ma'kada nakua: “La bongimi, indekia' alla' padang. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Umbai mapia ke musuami inde lako taue anna lao umpeang nande lako tondok sikadappi'na inde angngenanne.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sapo natimba' Puang Yesus nakua: “Ikoa' la umpandei.” Nakuamo passikolana: “Umbamo kami la kingei ummala doi' umbai la dua ratu' dinar anna mane la sirua diallian nande inde lako tau pada budannae?” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nakutanaimi nakua: “Pira roti muampuia'? Laokoa' umpetua'i!” Napetua'mi anna timba'i nakua: “Angga limangkalebu roti anna dua be'dok.” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Umpare'mi tau buda Puang Yesus nasua pantan ma'kombong-kombong ma'loko lako pasang. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pantan ma'lokomi, dengan sisaratu' dengan silima pulo mesa kombongan. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ummalami roti sola be'dok Puang Yesus anna mentungngu langngan langi' ma'sambayang. Mangkai too, umpiak-piakmi roti anna beenni passikolana natawa lako tau buda, napasitawa be'dok. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ummande asammi tau buda sadea'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mangkai ummande narempummi passikolana roti sola be'dok ra'dakna tau, ponnopi sapulo dua baka. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","To ummande attu iatoo anggapia muane anna lima sa'bu. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mangkai too ussuami passikolana Puang Yesus langngan lopi anna lamban yolo lian Betsaida. Anna mane ussua tau buda ma'pasule. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Le'ba' asanni passikolana sola tau buda, mengkalaomi langngan tanete anna ma'sambayang yao. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bongii, matangngami tama tasik lopi nangei passikolana sapo' torropia Puang Yesus mesai yao gantanan. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ummitami passikolana Puang Yesus sangngi' nabela umpatipalao lopinna. Umbai tettek tallui nannari saemi umpellambi'i passikolana menono' yao lolok wai sapo' susi to la tarru' uyyoloi passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Naitanna passikolana menono' yao lolok wai marea' asammi anna meoli-oli aka nasanga anitu. Sapo' tappa ma'kada lako nakua: “Pamattanni penawammu, daua' marea', Kaoriko tee!” ");
INSERT INTO mqjNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kendekmi langngan lopi umpellambi'i passikolana, mattan siami bara'. Mangnga-mangnga asammi passikolana ");
INSERT INTO mqjNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","annu ta' liupa umpekalembasan kakuasaanna Puang Yesus, moika anna mangkamo ummita tanda memangnga-mangnga limangkalebu roti napedea' tau, anna tontong liupa tae' nalambi' pikki'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Lambanni tasik sola passikolana ullambi'mi Genesaret. Turunni yao mai lopi tappa naissanan tau kumua Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sikakondong siami tau ussambai tondok ummala to masakinna anna bullei sitonda ampa'na lako Puang Yesus. Iamo nangei torro Puang Yesus iamo naola umbaa to masakinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Umba-umba angngenan nalambi', tondokraka, battu angngenan senga'raka, buda liu tau sae umbaa to masakinna narempun dio pasa' anna pelaui kumua kenamala moi podo narumbumo tampak bayunna. Aka' angganna to urrumbui napomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dengan pissan attu sae pira-pira to Farisi anna to untarru' issinna sura'na Musa dio mai Yerusalem umpellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ummitami pira-pira passikolana Puang Yesus ummande, tae' umbasei limanna situru' ada'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Annu mengkalao dio mai nenena to Farisi anna to Yahudi senga', tae' mala ummande ke tae' umbasei limanna situru' ada'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ianna sae dio mai pasa' tae' mala ummande ke tae' membase yolo. Anna budapi kabeasaan senga' nasiossoranni peampoanna susinna umbasei irusan, kurin gallang, anna porewa senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iamo too anna mekutanamo lako Puang Yesus nakua: “Maakari anna tae' unturu' ada'na neneta passikolamu, ummande tae' umbasei limanna situru' ada'ta?” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Natimba' Puang Yesus nakua: “To ma'dua tambukkoa'. Tonganna kadanna nabi Yesaya umpatukoa' nakua: Susi inde kadanna Puang Allata'allae: ‘Itin matin tauo dio babang pudukna umpakasallena' sapo' illalan penawanna napemboko'ina'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Alla'mo' napenombai annu sitonganna tangngiamo parentaku napa'patuduan sapo pepa'guruan ma'rupa taumo.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Anna mane nakua Puang Yesus: “Umpa'barinni'imokoa' parentana Puang Allata'alla anna ada' ma'rupa taumo mupengnganda'. Manarrukkoa' untampean parentana Puang Allata'alla ammu mane sondaia' kabeasaammu. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Susi mangka napokada Musa nakua: ‘Pakasallekoa' ambemu sola indomu,’ anna: ‘Benna-benna ungkondo-kondoan kada ambena sola indona la dipatei.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sapo' simupokadaria' iko kumua ianna dengan tau ma'kada lako ambena battu indona nakua: ‘Ambo' dengan la kutandoiangkoa', sapo' mangkami kupopemala' langngan Puang Allata'alla.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ianna susimo tee, umpabeaimokoa' tau tae' la ummita to matuanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Dadi kabeasaammua' tee umpa'dean parentana Puang Allata'alla. Anna budapa susinna simupogau'a'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Untambai polemi tau buda Puang Yesus anna ma'kada nakua: “Perangngi manappai ammu paillalan penawaia'! ");
INSERT INTO mqjNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Angganna lu tamanna kale tae' la ungkadakei tau, sapo suunnaria illalan mai kalena tau ungkadakeii.  ");
INSERT INTO mqjNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Perangngii ammu paillalan tambukkia' inde tula'kue!” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mangkai mantula' umpelleimi tau buda anna lu tama mesa banua. Nakutanaimi passikolana kalembasanna pa'rapanan natula' angngena'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Natimba' nakua: “Ta'paka iko duka' mupekalambanan? Angganna nande lu tama kalena ma'rupa tau tae' la nakadakei, ");
INSERT INTO mqjNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","annu tae' lu tama penawa sapo lu tama tambuk anna mane ditibe lao.” Ia nangei mantula' susi Puang Yesus, anna malara naissanan tau buda kumua tae' dengan nande pemali diande. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","22","Anna mane ma'kada pole Puang Yesus nakua: “Mengkalao illalannaria penawanna ma'rupa tau lemba' dio panggauanna ungkadakeii, susinna: pikki' kadake, ullullu' pa'bannetauan, maboko, papatean, ungkokoi buria'na solana, kamailuan la untombon ewanan, gau' kadake, ma'tengko, umpangngula' pa'kua penawanna, masusu', ma'telle, malangka' penawa, tae' naissan ma'pasise'la. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Angganna te mai kakadakean susie mengkalao illalan asan penawa anna ungkadakei ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Umpelleimi Galilea Puang Yesus anna lu lako lembangna Tirus. Saei lako tappa lu tamami mesa banua annu moka la naissanan tau kasaeanna. Sapo' tae' diissan dibuni kasaeanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Dengan mesa baine, tangngia to Yahudi sapo' to Siro-Fenisia, tappa ummissananni kasaeanna, sae umpellambi'i malimuntu' dio tingngayona anna pelaui kenamala napomalapusanni anakna baine, aka natamai setang. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sapo' natimba' Puang Yesus ummolai mesa pa'rapanan nakua: “Pabeai medea' yolo anak annu tae' dadi nande mangka dipatokaan anak la diala anna ditibean lako asu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Sapo natimba' duka' inde bainee nakua: “Tonganna tuang, sapo' mala duka' ummande nande ronno'na anak asu dio wi' meja.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nakuamo Puang Yesus: “Narua timba'mu, laomoko annu mallaimi setang illalan mai kalena anakmu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sulemi inde baine lako banuannae, ullambi'mi anakna masannang mamma', annu mallaimi setang illalan mai kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mengkalaomi Puang Yesus umpellei lembangna Tirus ummola lako Sidon tarru' lako Tasik Galilea illalan lili'na Dekapolis. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Attu iatoo dengan pira-pira tau sae ussolaan mesa to taru oma' polepi, anna pelaui kenamala natoe Puang Yesus anna malara malapu'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mangkai naberoi illalan mai alla'-alla'na tau buda napalao senga', umpentossokammi tarunona Puang Yesus tama talinganna inde taue anna ma'tikkudu anna mane rumbui lilana. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Membulangimi Puang Yesus anna umbussanan penawanna napasiolaan ma'kada nakua: “Efata,” kalembasanna: “Titungka'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tappa parangngi siami anna naissan mantula'. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma'pakari'di'mi Puang Yesus lako to dio reen attu iatoo kumua tae' la napokada lako tau senga' kadadian iatee. Sapo' moi naaka nadapai, nenne' tuttuan buda tau lu rekke lu sau' untetteranni. ");
INSERT INTO mqjNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mangnga-mangnga asan tau urrangngi kareba iatoo anna ma'kada nakua: “Tae' dengan aka tanaissan napogau'. To taru mala parangngi, anna oma' mala napopantula'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Attu iatoo bu'dak omi tau ma'rempun sola Puang Yesus anna pura asammo kinallona. Untambaimi passikolana anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Rantang tongan-tongan buaku ummita inde lako taue annu tallu bongimikia' sola napolalan puramo kinallona. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ianna tokke' la kusua sule tae' ummande, mareke' naala pali lako lalan annu dengan mambela naola sae.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Natimba' passikolana nakua: “Umbamo la dingei ummala nande la dipandean inde lako taue annu indekia' angngenan maitu-itu?” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mekutana Puang Yesus nakua: “Pirapi rotimmua'?” Natimba' passikolana nakua: “Pitupi.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ussuami tau buda Puang Yesus pantan ma'loko lako pasang. Ummalami pitu roti Puang Yesus anna ma'kurru' sumanga' langngan Puang Allata'alla, anna mane piak-piakki anna beenni passikolana natawa lako tau buda. Natawami passikola lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dengampi duka' pira-pira be'dokna, naalami Puang Yesus anna ma'kurru' sumanga' anna mane beenni passikolana natawa. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ummande asammi tau buda sadea'na. Narempummi passikola sesanna, ponnopi pitu baka. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Inde to ummandee umbai dengan appa' tasa'bu. Mangkai ummande nasuami Puang Yesus ma'pasule lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Le'bai tau buda langngammi lopi Puang Yesus sola passikolana anna mengkalao lako lembangna Dalmanuta. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Saemi pira-pira to Farisi umpellambi'i Puang Yesus anna sikuama. Umpelaumi mesa tanda lu yao mai suruga la naola ussudii battu la manassari lu yao mai Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Umbussanammi penawanna Puang Yesus anna ma'kada nakua: “Maakari ma'rupa tau temo anna umpelau tanda? Annu kupokadangkoa' sitonganna, inde ma'rupa tau temoe tae' la dipaitai tanda.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Langngammi lopi sule Puang Yesus umpellei inde taue, anna mengkalao lian biring tasik tandai lian. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Inde anna langngan lopie, ta'ra nakilalai passikolana umbaa roti. Anggami mesa roti naampui yao lopi. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma'pakilalami Puang Yesus lako nakua: “Dagaia' indana sanggangngiko raginna to Farisi anna Herodes.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sipantula'-tula'mi passikolana nakua: “Ia nangei mantula' susi annu tae'kia' umbaa roti.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sapo naissanan Puang Yesus pikki'na, napolalan ma'kada nakua: “Maakari anna kataesanna dengan roti mutula'a'? Maakari anna tae' liua' mupekalembasan? Butamika pikki'mua'? ");
INSERT INTO mqjNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ummampuikoa' mata, maakari anna tae' paita? Ummampuikoa' talinga, maakari anna tae' parangngi? Ta'raka mukilalai ");
INSERT INTO mqjNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","angku piak-piak lima roti dipandean lima sa'bu tau? Pirapi baka la'binna murempun?” Natimba' nakua: “Sapulo dua baka.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nakua pole omo: “Mukilalaika angku pande tau appa' tasa'bu angga pitu roti kupiak-piak, pirapi baka la'binna murempun?” Natimba' omi nakua: “Pitu baka.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nakua pole omo Puang Yesus: “Ta' liupaka ikoa' mupekalambanan?” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tapakala saemo lako Betsaida Puang Yesus sola passikolana. Saemi napellambi'i tau untette to buta anna pelaui kenamala narumbu napolalan napomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Naanda'imi Puang Yesus limanna anna tettei lako salian tondok. Natikkuduimi matanna napasiolaan narumbu anna kutanaii nakua: “Dengammika tibayan muita temo?” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mennenne'mi lako tingngayona anna ma'kada nakua: “Io, kuitami tau menono', sapo' susi babang to' kayu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Narumbu pole omi Puang Yesus matanna, napolalan marorrong pole' pennenne'na, lambisan makaleso angga lako naita. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nasuami ma'pasule lako banuanna anna kuanni: “Dau lu tama tondok.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mangkai too mengkalaomi Puang Yesus sola passikolana ullelean tondok dio Kaisarea Filipi. Ummolai lalan ungkutanaimi passikolana nakua: “Situru' tula'na tau, bennarakkao ade'?” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Natimba'mi nakua: “Dengan tau ungkuai Yohanes to simantedok tuo sule; dengan duka' ungkuai nabi Elia sae sule; dengan toi ungkuai sala' bennanna nabi yolona tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mekutana pole omi nakua: “Anna umba iko nakua pikki'mua', bennarakkao tee?” Natimba' Petrus nakua: “Ikomo To nabassei bayu-bayu Puang Allata'alla la ma'pasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma'pakari'di'mi lako passikolana kumua tae' la napokada lako tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mangkai too naparandukmi Puang Yesus umpa'guru passikolana kumua innang la ussa'dingan buda kamaparrisan Anak Mentolino anna la natumpu pala' perepi'na to Yahudi, kapala imam, sola to untarru' issinna sura'na Musa, lambisan dipatei. Sapo katallungngallona la tuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kara-kara ia tee napomakaleso natula' Puang Yesus sapo tappa naruntu' Petrus illalan mai alla'-alla'na passikola anna pakilalai. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Menggirikmi Puang Yesus unnenne'i passikolana napasiolaan ungkeara'i Petrus nakua: “Pallaiko lao Setang! Annu tangngia pa'kuanna Puang Allata'alla mupikki', sapo' pa'kuanna ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Urrempummi passikolana sola tau buda Puang Yesus anna mane ma'kada nakua: “Benna-benna morai unturu'na' la untampean pa'kua penawanna, umpassan kayu pantokesanna, anna turu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Annu benna-benna umpa'kadua-duai katuoan illalan lino, la ungkasayu'i katuoan sae lako-lakona. Sapo benna-benna nadotaan mate annu naturu'na' anna umpalanda' Kareba Kadoresan, la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tae' dengan gunana lako mesa tau moi la ummampui angganna issinna lino ke la sanggangri sunga'na, ");
INSERT INTO mqjNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","annu tae' dengan aka mala la dituka'ian sunga'na tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Benna-benna umpa'kasirisanna' sola umpa'kasirisan battakadangku illalan alla'na to kasalaan anna to umpopaningoan aluk, la napa'kasirisan duka' Anak Mentolino ke saemi. Annu la sae sitonda kakuasaanna anna kamatandeanna Ambena, naturu' angganna malaeka' masero.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Umpatarru' omi kadanna nakua: “Kupokadangkoa' sitonganna, dengangkoa' to dio reen temo tae' la bonno' ke ta'pa ummita Puang Allata'alla ma'parenta sitonda kakuasaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Annanni allona mangkanna, mengkalaomi Puang Yesus umbawai Petrus, Yakobus, anna Yohanes langngan mesa tanete malangka', tae' dengan tau senga' nasolaan yao, angga appa'i. Ummitami Puang Yesus lumalin rupanna, ");
INSERT INTO mqjNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","mabussang pakeanna pakkillo'-killo', tae' dengan to mambusuk illalan lino la mala umpomabusa susii. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Saturanni, ummitami nabi Elia anna Musa marassan sipantula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma'kadami Petrus lako nakua: “O Tuangguru, ta'mo dengan la nasusian masannangki inde rokko angngenanne. Mapia ke kipake'de'i tallu lantang angki pasandaikoa' simesa: Iko, Musa, anna Elia.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ia nangei ma'kada susi Petrus annu ta'mo naissanan aka la napokada annu marea' asammi. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tapakala tokke'mo rembon gaun ummongannii. Dirangngimi kamara illalan mai gaun nakua: “Iamo te Anakku to kukamaseie, perangngii.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inde anna umpalelemo pennenne'na passikolanae angga mandami mesai Puang Yesus naita, pa'demi to nasolaan angngena'. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ummolai lalan anna lu yaomo mai tanete ma'pakari'di'mi Puang Yesus lako inde tallu passikolanae nakua: “Daua' tetteranni lako tau senga' kara-kara muita angngena' ke ta'pa tuo sule Anak Mentolino dio mai alla'na to mate.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Napaillalan penawami passikolana pepakari'di'na napasiolaan untula' battakadanna Puang Yesus angngena' kumua “la tuo sule dio mai alla'na to mate” annu tae' napekalembasan. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mekutanami lako Puang Yesus nakua: “Akara ia nasanga to untarru' issinna sura'na Musa kumua: tae' mala tala sae yolo Elia anna mane sae To dibassei bayu-bayu ma'pasalama'?” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Natimba'mi nakua: “Innang la sae ia yolo Elia umpatoka angga lako. Sapo' dengangka nalambi' pikki'mua' pangnguki' illalan Buku Masero untetteran Anak Mentolino kumua la ussa'dingan ma'rupa-rupa kamasussaan anna la dipakario-rio illalan lino? ");
INSERT INTO mqjNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kupokadangkoa' sitonganna kumua mangkami sae Elia anna tae' dengan tanapogau' ma'rupa tau lako kalena, susi mangka tiuki' illalan Buku Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sulei Puang Yesus sola Petrus, Yakobus anna Yohanes yao mai tanete, ullambi'mi passikola senga'na nakarompo' tau buda sola pira-pira to untarru' issinna sura'na Musa marassan sipekka. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ummitanna Puang Yesus inde tau budae mangnga-mangnga asammi anna mane sikakondong untammuii. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Mekutanami lako passikolana nakua: “Akara iko musipekkaia' inde lako taue?” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Natimba' mesa tau illalan mai alla'-alla'na tau buda nakua: “O Tuangguru, inde anakkue kubaa sae lako kalemu annu natamai setang napolalan ta'mo naissan mantula'. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ianna nalaoi omo inde setangnge, susi tappa'mi to dipessambakan rokko litak, pambura-bura sadangna, sikarakuku' isinna anna mato'do' kalena. Mangkami kupelau lako passikolamu anna rambai inde setangnge sapo' tae' nabela.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma'kadami Puang Yesus nakua: “O anggammua' rupa tau temo, to tamangngorean tongangkoa'! Umbapi la pada masaena la kungei torro illalan alla'-alla'mua'? Anna umba polepi la susi kasa'barasangku lako kalemua'?” Anna mane ma'kada nakua: “Baai mai itin anakko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dibaami lako tingngayona. Ummitanna Puang Yesus inde setangnge, umpopa'kalumpiri'-piri' siami inde anakke, napessambakan rokko litak anna tibalintan leen anna pambura-bura sadangna. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mekutanami Puang Yesus lako ambena inde anakke nakua: “Masaemika te masaki susie?” Natimba'mi nakua: “Mengkalao dio mai barinni'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pembuda-budami la nasanggangngi sinatobangan tama api battu rokko wai. Sapo' ianna la mubelara mupomalapu', kamaseikan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Natimba'mi nakua: “Maakari ammu kua: ‘Ianna la mubelara’? Kupokadangko sitonganna, tae' dengan tamala dadi lako to mangngorean.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tappa natimba' ambena inde anakke nakua: “Kuoreangko, sapo' la mupamoloina' anna malara tuttuan kerangngan kapangngoreanangku!” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Inde anna ummitamo tau Puang Yesus tuttuan buda sae ungkarompo'ie, ussadangngimi setang nakua: “O setang, to siumpaoma' sola siumpataru tau, mallaiko illalan mai kalena inde anakke, ammu daumo tama pole.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mallai siami inde setangnge napasiolaan kumillong-killong anna umpopa'kalumpiri'-piri' inde anakke, susimi to mate diita napolalan buda tau kumua: bonno'mi. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sapo' tappa naanda'i Puang Yesus limanna anna bangunanni, ke'de' siami. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Illalanni banua Puang Yesus sola passikolana tae' dengan tau senga' urraui, nakutanaimi passikolana nakua: “Maakaria anna tae' kami kibela urrambai lao iato setang angngena'o?” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Natimba' nakua: “Setang susi too tae' dibela dirambai ke tae' tau ma'sambayang.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mengkalaomi Puang Yesus sola passikolana umpatarru' penonosanna ummola lako Galilea. Attu iatoo moka umpa'peissanan angngenanna lako tau senga', ");
INSERT INTO mqjNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","annu angga opi passikolana marassan napa'guru. Ma'kadami lako passikolana nakua: “Anak Mentolino la disorong rokko lisu pala'na ma'rupa tau anna la dipatei, sapo' katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iate kadannae tae' natamai akkalanna passikolana, sapo' malaya' asan umpekutananni. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pissan attu sae omi Puang Yesus sola passikolana lako Kapernaum. Illalanni banua mekutanami lako passikolana nakua: “Akara iko musipekkaia' dio mai lalan angngena'?” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sapo' mengkamma' asan annu inde nasipekkaie iamo bennanna randan la matande. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ummokko'mi Puang Yesus anna untambai inde sapulo dua passikolanae anna kuanni: “Benna-benna morai la keangga', la mengkareppe' anna ungkandapa padanna ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Anna mane untette mesa anak tama alla'-alla'na passikolana anna mane raka'i anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Benna-benna untarima inde anak susi ura'na kapangngoreananna lako kalekue, sirapammi Kao natarima. Anna benna-benna untarimana' tae' angga Kao natarima sapo' untarima duka' to ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma'kadami Yohanes lako Puang Yesus nakua: “O Tuangguru, dengan kiita mesa tau urrambai setang umpotendan sangammu sapo' kidapai annu tangngia solata.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sapo' natimba' nakua: “Daua' dapaii annu tae' dengan tau umpogau' tanda memangnga-mangnga umpotendan sangangku, anna mane tappa la tellena'. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Annu benna-benna tae' umbaliki' iamo solata. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kupokadangkoa' sitonganna, benna-benna umbengangkoa' wai sangngirusan annu unturu'koa' Kristus, tae' la pa'de sarona.” ");
INSERT INTO mqjNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma'kada pole omi Puang Yesus nakua: “Benna-benna untumang mesa inde mai anak napolalan ta'mo mangngorean lako kalekue, malamia ke ditoke'i batu kamai illalan kollongna anna dipa'tibean tama tasik. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ianna sabali limammu untumangko kasalaan, poloi lao annu dotamoko ia ma'lima sabali tama angngenan katuoan, anna la tontong dua limammu ditibe tama naraka nangei api tala mala pi'de.  ");
INSERT INTO mqjNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Annu angngenan iatoo tala mate olli'na tala pi'de apinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ianna lentekmu untumangko kasalaan, poloi lao annu dotamoko ia ma'lentek sabali tama angngenan katuoan, anna la dua lentekmu sapo' ditibeko tama naraka.  ");
INSERT INTO mqjNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aka angngenan iatoo tala mate olli'na tala pi'de apinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ianna matammu untumangko kasalaan, lessu'i lao, aka dotamoko ia ma'mata sabali tama kaparentaanna Puang Allata'alla, anna la dua matammu sapo' dipa'tumbukangko tama naraka. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aka dio angngenan iatoo ‘tala mate olli'na tala pi'de apinna.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Simesa-mesa tau la diseroi ummolai kamaparrisan. ");
INSERT INTO mqjNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Itin siao mapia sapo' ianna matammangmo la malapika dipamassin sule? Kenamala la tontongkoa' sirapan sia, la sikamase-masekoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mengkalaomi Puang Yesus dio mai angngenan iatoo lu lako lembangna Yudea anna lamban lian Salu Yordan. Sae omi buda tau ungkarompo'i. Ma'pa'guru omi, susi beasa sinapogau'. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Saemi to Farisi umpellambi'i annu la nasudi, napolalan mekutana lako nakua: “Malarika mesa muane la ussisarakan bainena?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sapo' natimba' nakua: “Aka napatuduangkoa' Musa?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Natimba'mi nakua: “Natangga' ia Musa sisarak, sapo' manggi' dipapiaan sura' kasisarakan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nakuamo Puang Yesus: “Ia nangei umpatudu susikoa' Musa annu kamakarrasan penawammua'. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Aka mengkalao dio mai kadadianna inde linoe susi tiuki' illalan Buku Masero nakua, ‘napadadimi Puang Allata'alla muane anna baine. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iamo too, la untampe ambena sola indona muane anna mesa kappa' bainena. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Anna ta'mo la dikuan dua, sapo' la mesami.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iamo too, iamo mangka napamesa Puang Allata'alla tae' mala napasisarak ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Illalanni banua, mekutana omi passikolana lako Puang Yesus diona kalembasanna inde tula'na angngena'e. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Natimba'mi nakua: “Benna-benna ussisarakan bainena anna kebaine pole, tau iatoo ullullu' pa'bannetauan. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ianna baine ussisarakan muanena anna kemuane pole, inde bainee ullullu' toi pa'bannetauan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pantan saemi tau umbaa anakna lako Puang Yesus anna malara natamba', sapo nakeara'i passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Keara'mi Puang Yesus ummita pa'palakona passikolana napolalan ma'kada nakua: “Pabeaii itin matin anak sae umpellambi'ina'o. Dau lawaii annu tau susimo tu matinno la mendadi petauanna Puang Allata'alla illalan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Aka kupokadangkoa' sitonganna, benna-benna tae' mareppe' penawa susi ana'-ana' untarima kaparentaanna Puang Allata'alla, tae' la tama kaparentaan iatoo.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Urraka'mi inde mai anakke anna mane pantan naanda'i natamba'. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Inde anna mengkalaomo Puang Yesus la umpatarru' penonosannae, saemi mesa tau ma'sirra'-sirra', malimuntu' dio tingngayona anna mekutana nakua: “O Tuangguru to mapia penawa, aka la kupogau' angku malara ullolongan katuoan sae lako-lakona?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Natimba' nakua: “Maakari ammu kuanna' to mapia penawa? Tae' dengan to mapia penawa salianna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Manassa anna muissanan asammo parentana Puang Allata'alla kumua: Dau papatean, dau ullullu' pa'bannetauan, dau maboko, dau sa'bi tatongan, dau untengko solamu, pakasalleko indomu sola ambemu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Natimba' inde taue nakua: “O Tuangguru, mengkalao diomi mai, mangngurapa' angku pogau'mi te mai parentae.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nanenne'imi Puang Yesus siolaan rantang buana anna ma'kada lako nakua: “Mesapi tae' mupogau', laomoko ammu baluk angganna ewanammu, ammu tawaianni to mase-mase allinna mupolalan la ullolongan ewanan yao suruga. Mangkaii saemoko ammu turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sapo' urrangnginna tula'na Puang Yesus, rosso siami buana anna ma'pasule sitonda kamasussaan annu buda ewananna. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Unnenne'imi passikolana lako sa'dena anna ma'kada nakua: “Marempang tongan-tongan to buda ewananna la tama kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mangnga-mangnga asan passikolana urrangngii tula'na. Ullombungngi polemi tula'na Puang Yesus nakua: “O anakku, marempang tongan-tongan tama kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Annu madommi' pole ia unta lu tama tottok darun, anna la tomakaka tama kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tuttuan mangnga-mangngami passikolana urrangngii, napolalan sipantula'-tula' nakua: “Ianna susi too, bennara la mala dipasalama'?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Unnenne'imi passikolana anna kuanni: “Nakasumpui ia ma'rupa tau, sapo' tae' ia Puang Allata'alla annu tae' dengan tanaissan nagaragai.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma'kadami Petrus lako Puang Yesus nakua: “Untampe asammokangkami angga kiampuinna, angki turu'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Natimba'mi nakua: “Kupokadangkoa' sitonganna, benna-benna untampe banuanna, sirondongnaraka, to matuannaraka, anaknaraka, bela'naraka, annu naturu'na' anna umpalanda' Kareba Kadoresan, ");
INSERT INTO mqjNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tau iatoo attu temo la natarima siami sondana tiluppi' pessaratu': banuanna, sirondongna, to matuanna, anakna, anna bela'na, moika anna siolaan dipakario-rio. La'bi-la'binna attu la sae la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anna buda to disanga to kamai la mendadi to barinni', anna to disanga to barinni' la mendadi to kamai.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ummolai lalan la lu lako Yerusalem, uyyoloammi passikolana Puang Yesus. Mangnga-mangnga asammi passikolana, anna marea' asan angganna to unturu'i. Urrempummi sapulo dua passikolana anna tulasanni aka la dadi lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nakua: “Temo la laokia' lako Yerusalem anna la disorong Anak Mentolino rokko lisu pala'na kapala imam sola lako to untarru' issinna sura'na Musa, annu la napabambanni sangka' dipopepatei. Anna mane palessu' lakoi to tae' ummissanan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","La natelle, la nasitikkudu-kudui, nadarra, anna mane pateii, sapo' katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mangkai too saemi anakna Zebedeus iamo Yakobus anna Yohanes, ma'kada lako Puang Yesus nakua: “O Tuangguru, kenamala mutarima pelaungki.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Natimba'mi nakua: “Aka muporai la kupogau' lako kalemua'i?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma'kadami nakua: “Bengkan okkosan ke Ikomo ma'parenta, mesa dio tandai kanammu, mesa dio tandai kairimmu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sapo' natimba' Puang Yesus nakua: “Tae' muissanan aka mupelaua'! La mutaroka ummiru'i irusan la kuiru'i, anna ditedok susi pantedokan la kuolai?” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Natimba'mi nakua: “La kitaro.” Nakuamo Puang Yesus: “Innang la ummiru'ikoa' irusan la kuiru'i sola ditedok susi pantedokan la kuolai. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sapo' la ummokko' dio tandai kanangku battu tandai kairingku tangngia issangku, annu angngenan iatoo la nangei to mangka napile Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tappana urrangngi pelaunna Yakobus anna Yohanes, keara' asan passikola senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Natambaimi Puang Yesus anna ma'kada nakua: “Muissanan kumua to ma'parenta salianna to Yahudi ma'kada mesa umparenta rupa tau, anna angganna to kamainna umpalao pa'kua penawanna lako petauanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tae' iko la susi illalan alla'-alla'mua', annu benna-benna morai la keangga' la ungkandapa padanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Anna benna-bennakoa' morai la mendadi to kamai, la mendadi sabua'koa' illalan alla'-alla'na padammu. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Annu tae' duka' sae Anak Mentolino anna la dikandapa, sapo' la ma'kandapa, anna la ussorongan sunga'na annu la mendadi pesulangna tau buda.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tapakala saemo Puang Yesus sola passikolana lako tondok Yerikho. Suunni illalan mai tondok sola passikolana anna tau buda, dengammi mesa to buta, to sikapelau-lau disanga Bartimeus anakna Timeus ummokko' dio biring lalan. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Narangnginna kumua liu Puang Yesus to Nazaret, metamba-tambami nakua: “O Yesus peampoanna Daud, kamaseinakkao.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Buda tau ungkeara'i anna suai mengkamma'. Sapo' tuttuan napemandui metamba nakua: “O peampoanna Daud, kamaseinakkao.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Torromi Puang Yesus anna ma'kada nakua: “Tambaii.” Natambaimi nakua: “Pakamai penawammu ammu ke'de' annu natambaimoko!” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ummalai siami bayu rui'na anna ma'sirra' ke'de' le'ba' lao umpellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nakutanaimi Puang Yesus nakua: “Aka muporai la kupogau' lako kalemu?” Natimba' nakua: “Moraina' la paita, Tuangguru.” ");
INSERT INTO mqjNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nakuammi: “Kapangngoreanammu lako kaleku umpomalapu'ko. Laomoko sitonda kamasakkean.” Paita siami napolalan mengkalao sola Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","La sae kalei lako Yerusalem Puang Yesus sola passikolanae sikadappi'mi tondok Betfage anna Betania dio Tanete Zaitun, umpatontongmi dua passikolana ");
INSERT INTO mqjNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nakua: “Laokoa' lian itin sambali' tondokko. Saekoa' lian la ullambi'koa' mesa keledai lundara ditole', ta'pa dengan leleanna disakei. Bukai balayanna ammu baaia' sambali' mai. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ianna dengan tau ungkuangkoa': ‘Maakari ammu bukaii?’ kuanni: ‘Naparallui Puangna, anna la napasule kale.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mengkalao siami lian napolalan ullambi' keledai lundara ditole' dio luba'ba dio biring lalan. Nabukaimi balayanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dengan pira-pira tau dio mekutana nakua: “Maakari ammu bukai itin keledaio?” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Natimba'mi susi mangka napakari'disanni Puang Yesus, napolalan napabeai. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Umbaami keledai lako Puang Yesus, anna ummalai bayu rui'na nalapikkianni anna mane sakeii Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Buda tau umpakasalle Puang Yesus ummampa' bayu rui'na lako lalan, dengan toi ummala daun sitonda batang lako bela' anna ampa'i lako lalan la naolanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sipetamba-tambaammi to yolo anna to unturu'i nakua: “Dipakasalle sanganna Puang Allata'alla. Ditamba' to sae umpotendan sanganna Dewata, ");
INSERT INTO mqjNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","natamba' Puang Allata'alla kaparentaan la ombo' susi kaparentaanna neneta Daud. Dipakasalle sanganna Puang Allata'alla to yao angngenan matande.” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Saena Puang Yesus lako Yerusalem, tappa melolo tamami Banua Ada'na Puang Allata'alla anna paressa asanni tiku lao. Sapo la bongii, lu lakomi Betania sola sapulo dua passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Masiangngi, mengkalao omi Puang Yesus sola sapulo dua passikolana. Umpelleinna tondok Betania, tadea'mi Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mambelapi anna ummitamo to' ara marumbo daunna. Napengkadappi'imi anna petua'i battu la denganda buana. Sapo' saei lako, anggaria daunna nalambi', tae' dengan buana annu innang tangngia opi attunna la kembua. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nakuamo lako inde to' arae: “Ta'mo iko dengan la naande ma'rupa tau buamu sae lako-lakona.” Narangngi duka' passikolana tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Saei lako Yerusalem Puang Yesus sola passikolana, tarru' lakomi Banua Ada'na Puang Allata'alla. Ullambi'mi buda to sibaluk-baluk dio napasiolaan ma'tengko. Tappa narambaimi lao anna umbalintan mejana to untuka' doi' dio mai lembang senga' sola ka'derana to umbaluk dangan-dangan. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anna tae' untangga' to mambaa, ummola pa'rantean Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Anna mane ma'pa'guru lako tau buda nakua: “Dengan tiuki' illalan Buku Maserona Puang Allata'alla kumua: ‘Banuangku la nangei angganna ma'rupa tau ma'sambayang’. Sapo mungeiria' iko ma'tengko.” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tappana narangngi kapala imam sola to untarru' issinna sura'na Musa kadadian iatoo, ma'mesami anna umpeang lalan la umpatei Puang Yesus annu nakapui'i ummitanna buda tau mangnga-mangnga urrangngi pepa'guruanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Marammoi, mengkalao omi sola passikolana umpellei Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Masiangngi, mebongngi'-bongngi' omi Puang Yesus sola passikolana mengkalao la sule lako Yerusalem. Ullambi'mi to' ara naita samai' marekko'mi sae rokko waka'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nakilalai siami Petrus tula'na Puang Yesus samai' lako inde to' arae. Nakuamo: “O Tuangguru, petua'ri inde dio to' ara mutado samai'e marekko'mi.” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Natimba' Puang Yesus nakua: “Oreangkoa' Puang Allata'alla! ");
INSERT INTO mqjNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aka' kupokadangkoa' sitonganna, benna-benna ma'kada lako inde tanetee nakua: ‘Tiangka'ko ammu tappa illalan tasik’, la mala tongan tiangka' tama, ke dengan kapangngoreanammu, anna tae' bata illalan penawammu. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iamo too kupokadangkoa': aka mupelau ummolai sambayang siolaan kapangngoreanan, tae' mala tamutarima. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ianna la ma'sambayangko anna dengan pa'di' penawammu lako tau senga', garri'ianni yolo kasalaanna ammu mane ma'sambayang, anna malara nagarri'iangko duka' kasalaammu Ambemu yao suruga.”  ");
INSERT INTO mqjNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sapo' maka' tae'ko unggarri'i kasalaanna padammu, tae'ko duka' nagarri'ian kasalaammu Ambemu yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sae omi Puang Yesus sola passikolana lako Yerusalem. Inde anna menono'mo illalan pa'rantean Banua Ada'na Puang Allata'allae saemi pira-pira kapala imam anna to untarru' issinna sura'na Musa sola perepi'na to Yahudi umpellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mekutanami nakua: “Kakuasaan aka mupake umpogau' inde mai kara-karae anna benna umbeengko?” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Natimba' nakua: “La kukutanaikoa' duka' ianna mutimba' pekutanangku kutulasangkoa' duka' benna umbenganna' kakuasaan. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Benna umbengan kakuasaan Yohanes mantedok? Puang Allata'allaraka, ma'rupa tauraka? Timba'na'!” ");
INSERT INTO mqjNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sipantula'-tula'mi nakua: “Ianna takuaa': ‘Puang Allata'alla,’ la nakuangkia': ‘Maakari anna tae' muorean?’ ");
INSERT INTO mqjNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sapo' tae' dengan leleanna la takua: ‘Kakuasaanna ma'rupa tau.’ ” Ia nangei ma'pikki' susi annu marea' lako tau buda annu' inde Yohanes-e naangga' tau mesa nabi. ");
INSERT INTO mqjNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Napolalan anggami nakua mentimba': “Tae' kiissanan.” Nakuamo Puang Yesus: “Ianna susi too, tae'koa' duka' la kutulasan benna umbeenna' kakuasaan kupolalan umpogau' inde mai kara-karae.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mangkai too, umpalanda'mi pa'rapanan Puang Yesus lako kapala imam sola to untarru' issinna Musa anna perepi'na to Yahudi nakua: “Pissan attu dengan mesa tau ma'bela' anna tananni anggur anna mane balai tiku lao. Umbo'bokmi batu pallullusan bua anggur, anna mane umpake'de' lempo batu la nangei to mangngampa. Mangka asanni, napa'petesanammi anna mengkalao lako angngenan mambela. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nalambi'i attunna matua bua anggur, ussuami sabua'na lao ummalanni tawana lako to mantesanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sapo saei lako, nasakkaria, anna tambak pusoi, anna mane suai sule ma'pala' lo'bang. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ussua pole omi sabua' senga'na, sapo saei lako nakambei duka' to mantesan napolalan balala ulunna, anna mane pakasiri'-siri'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ussua pole omi sabua' senga'na, sapo' saei lako napateimia pole'. Anna budapa sabua' senga'na napasusi, dengan nakambei, dengan napatei. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lambisan anakna mandami torro, to napakamaya. Katampakanna ussua pissan inde anaknae, annu nakua: ‘Innang la ungkalaya' anakku.’ Sapo' saei lako inde anakke, ");
INSERT INTO mqjNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","sipantula'-tula'mi to mantesan nakua: ‘Iamo te to la ummala ewananna to matuannae, anta pateii anna kita ummampui inde bela'nae.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nasakkami anna pateii, anna mane tibei lako biring bela'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mangkai untetteran pa'rapanan Puang Yesus, nakuamo: “Akamo la napogau' inde puangna bela'e? La laomi umpatei to mantesanna anna umpa'petesanan pole bela'na lako tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ta'raka dengan mubaca illalan Buku Masero nakua: ‘Batu pantibeanna tukan, diala dipobatu lentong. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kara-kara iatoo dadi situru' pa'kuanna Dewata, anna mangnga-mangngaki' ummitai.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sapo' inde anna issanammi perepi'na to Yahudi kumua kalena napatu kadanna Puang Yesus ummolai pa'rapananne, umpeangmi lalan la ussakka Puang Yesus. Sapo' marea' lako tau buda napolalan napellei babangmo lao. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mangkai too, ussuami pira-pira to Farisi sola to unturu' Herodes inde mai perepi'na to Yahudie lao ungkutanai Puang Yesus, annu la napaalinni kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lao tongammi umpellambi'i Puang Yesus anna kuanni: “O Tuangguru, kiissanan kumua to maloloko anna tae' dengan tau mukarea', umpapada-padako tau, anna simuundu' lollong untetteran lalan-lalan situru'na pa'kuanna Puang Allata'alla.” Anna mane mekutana nakua: “Situru' atoran alukta, malarika tau umbaya' sima lako tomaraya dio Roma, ta'raka? Manggi'rika kibaya', ta'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sapo' naissanan Puang Yesus akkalanna napolalan ma'kada nakua: “Maakaria' ammu lilinganna' tangnga'? Beenna' mesa dinar angku petua'i!” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nabengammi. Mekutanami Puang Yesus nakua: “Benna kerupa anna kesanga dio?” Natimba'mi nakua: “Rupanna anna sanganna tomaraya Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nakuamo Puang Yesus: “Ianna susi too, bengannia' tomaraya la sipato'na lu lako, ammu bengannia' duka' Puang Allata'alla la sipato'na lu lako.” Mangnga-mangnga asan urrangngii. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mangkai too, saemi pira-pira to Saduki to tae' ummorean katuoanna sule to mate umpellambi'i Puang Yesus anna mekutana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“O Tuangguru, mangkamikia' naukisan Musa nakua: ‘Ianna dengan baine bonno' muanena anna tae' dengan anak nasibalii, la napobaine siami sirondongna muanena, indana puppu' pembatisanna.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Dadi umba ia nakua ke dengan susi indee: Pissan attu dengan pitu tau ma'sirondong. Kebainemi pa'bunga' sapo' tae' dengan anak nasibalii bainena anna bonno'mo. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Napobainemi siruntunna sapo' tae' duka' dengan anak nasibalii anna bonno'mo. Susi siami duka' sirondongna katallunna, tae' dengan anak nasibalii anna bonno'mo. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nakua liumo tee, lambisan inde pitu to ma'sirondongnge mangka asan umpobaine inde bainee sapo tae' asan dengan anak nasibalii. Katampakanna bonno' duka' inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Dadi ianna nalambi'mo attu katuoanna sule to mate anna tuo asammo sule, bennannamo inde pitu to ma'sirondong la tarru' napomuane inde bainee annu mangka asammi napomuane?” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Natimba' Puang Yesus nakua: “Pusa tongan-tongangkoa', annu tae'koa' umpekalambanan battakadanna sola kakuasaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Annu ianna tuomo sule to mate, ta'mo dengan to sipobaine battu to sipomuane sapo' susimi katuoanna malaeka' yao suruga katuoanna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Anna ianna katuoannara sule to mate mupekutanaan, ta'raka dengan mubaca illalan sura'na Musa tulasanna api ma'lana-lana illalan to' kurra ma'duri nangei ombo' battakadanna Puang Allata'alla lako Musa nakua: ‘Kaomo Dewatanna Abraham, Dewatanna Ishak, anna Dewatanna Yakub?’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dadi tangngia Dewatanna to mate sapo' Dewatanna to tuo. Pusa tongan-tongangkoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inde anna marassan sipantula' Puang Yesus anna to Sadukie, dengan to untarru' issinna sura'na Musa sae umpengkadappi'i napolalan narangngi anna naissanan kumua tonganna asan pentimba'na Puang Yesus lako. Mekutanami lako Puang Yesus nakua: “Mentu'na parenta, umbanna randan ma'tandalangnganan?” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Natimba'mi nakua: “Parenta randan ma'tandalangnganan iamo: ‘O to Israel, perangngia'i, angga mesa Dewatanta iamo Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","La sangkalebu penawammu ungkamasei Puang Allata'alla Dewatammu anna sangkalebu pikki'mu sola angganna kamatoroammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anna kaduanna iamo: ‘Kamaseikoa' padammu ma'rupa tau susi ungkamasei kalemu.’ Iamo te dua to'na parentae, ta'mo dengan tanda langnganna pole.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nakuamo inde to untarru' issinna sura'na Musae: “Manassa tula'mu Tuangguru, angga mesa Dewata anna ta'mo dengan senga'na. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Innang la sangkalebu ia penawanna ma'rupa tau ungkamasei Puang Allata'alla, anna sangkalebu pikki'na sola sangkalebu kamatoroanna, anna ungkamasei padanna susi ungkamasei kalena. Kara-kara ia tee marru untodon pantunuan sola angganna bua pemala' senga' langngan Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tappana narangngi Puang Yesus mapia pentimba'na, nakuammi: “La tama kalemoko kaparentaanna Puang Allata'alla.” Mangkanna too ta'mo dengan tau barani mekutana pole lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Marassanni ma'pa'guru Puang Yesus dio Banua Ada'na Puang Allata'alla, mekutanami lako tau buda nakua: “Maakari anna nakua to untarru' issinna sura'na Musa: ‘Peampoanna tomaraya Daud To dibassei bayu-bayu la ma'pasalama'?’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Annu melolo Daud ma'kada naparunduk Penawa Masero nakua: ‘Mangka ma'kada Puang Allata'alla lako Puangku nakua: Okko'ko dio tandai kanangku angku lukkoangko angganna ewalimmu dio tingngayomu.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dadi ianna mekapuang tomaraya Daud lako To dibassei bayu-bayu la ma'pasalama', umbamo nakua anna la dikua pole omo peampoanna tomaraya Daud?” Masannang asan tau buda urrangngi tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma'pa'gurumi Puang Yesus nakua: “Katangkinnikoa' to untarru' issinna sura'na Musa, to angga naporai ma'bayu rui' leen lako lalan anna naporai napa'tabe'i tau tama pasa'. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ianna tama pa'sambayangan manggi'mi ma'loko dio tingngayo, ianna ullomba sara' manggi'mi la ma'loko yaya pengnguluan. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Siumpakena baine balu napolalan sae lako banuanna naalai. Sinaangga'i umpakalando sambayangna la naola umbuni kakadakeanna lako tau. Tau susi too innang la untarima pandarraan mabanda'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Dengan pissan attu ummokko' Puang Yesus untingngayo patti pemalasan illalan Banua Ada'na Puang Allata'alla, umpetua' to umpatama bua pemala'na. Saemi pira-pira tomakaka umbaa buda doi' anna patamai. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Saemi duka' mesa baine balu, mase-mase polepi umbaa dua doi' bassi, randan wiring rokko anna patamai. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Untambaimi passikolana anna kuanni: “Kupokadangkoa' sitonganna, angganna to umpatama bua pemala'na, indemo dio baine balu mase-masee randan buda. ");
INSERT INTO mqjNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Annu napebeen asammi ia diona kalena, moika anna anggamo la napokatuoan. Sapo inde lako tomakakae sangngi' urrimbengngi ewananna napebeen.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Suunni Puang Yesus illalan mai Banua Ada'na Puang Allata'alla, ma'kadami mesa passikolana nakua: “O Tuangguru, petua'ri inde dio rinding batue, tae' dengan pada matoto', anna tae' dengan la nasusian malekena inde banuae.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Natimba' Puang Yesus nakua: “Itin lako banua maleke muitao, pissan attu la diroppokan napolalan ta'mo dengan batu la tipatodo' yao batu senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lu langngammi Tanete Zaitun Puang Yesus anna ummokko' mentungngu lian Banua Ada'na Puang Allata'alla. Saemi Petrus, Yakobus, Yohanes, sola Andreas anna mekutana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“O Tuangguru, pokadangkan piran attunna la dadi, anna aka la tandana ke nalambi'mi attunna la diroppokan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sapo' ma'kada Puang Yesus nakua: “Matangkingkoa' indana papusakoa' tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Annu la buda tau sae umposanga sangangku nakua: ‘Kaomo To dibassei bayu-bayu ma'pasalama'.’ Anna la buda tau ummoreanni. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ianna urrangngikoa' karebana to sibundu'-bundu', daua' marea' annu innang la dadi susi sapo' tangngiapi katallananna lino. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Annu la sibundu'-bundu' tau sipa'barean tondok-ma'tondok, anna kaparentaan la sibundu' kaparentaan senga'. Umba-umba angngenan la nangei dadi lino' kamai anna la kendek karorian. Sapo angganna te maie mane pa'parandukanna kamaparrisan sirapan baine la keanak mane nasa'ding. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Sapo' la matangkingkoa' annu la disorongangkoa' rokko lisu pala'na pa'bisara alukna to Yahudi anna la dikambeikoa' illalan banua pa'sambayangan. Ammu mane dibaa lako tingngayona to ma'parenta annu muturu'na'. Attu iamo too la nangei dengan palliwangammua' untetteranna' lako. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Annu innang la dipalanda' yolo Kareba Kadoresan sae lako lili'na lino anna mane tallan lino. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ianna disorongangkoa' rokko lisu pala'na pa'bisara, daua' mausa' kumua aka la mupokada, annu inde la mupokadannae tangngia situru' pikki'mu, sapo' la naparundukkoa' Penawa Masero attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Anna la dengan attunna, to ma'sirondong la umpopepatei sirondongna, susi siami duka' ambe lako anakna. La umbali to matuanna anak lambisan napatei. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","La nakabassikoa' angganna tau annu muturu'na'. Sapo benna-benna mentoe manda' mengnganti matoto' illalan kapangngoreananna sae lako kasuppikanna la dipasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“La ummitakoa' ‘to nakabassi Puang Allata'alla to la untumang Banua Ada'na Puang Allata'alla la disayangngi’ ke'de' illalan angngenan tasipato'na la nangei. (La napengkalesoi manappa angganna to umbacai aka kalembasanna.) Attu iatoo angganna to dio Yudea la sirri' langngan tanete annu' la dipatei. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","To sirupang illaan salian ta'mo la tama banua ummala porewana, ");
INSERT INTO mqjNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","anna to sirupang dio bela' ta'mo la sule lako banuanna ummala pakeanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Masussa tongan-tongan to manambuk anna to ma'pasusu attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pa'sambayangkoa' anna malara inde kadadianne tae' sipatu palauran. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Annu attu iatoo la kendek kamaparrisan, ta'pa dengan nasusian mengkalao dio mai ungkombong lino Puang Allata'alla sae lako temo, anna ta'mo dengan la dadi pole susinna. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kela tae' napokon attunna Puang Allata'alla, ta'mo dengan la tuo ma'rupa tau. Sapo' umpessaileipi to napile, napolalan napokon attunna. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Susi toi duka', ianna dengan tau ungkuangkoa': ‘Indemi To nabassei bayu-bayu Puang Allata'allae,’ battu nakua: ‘Diomio;’ Daua' perangngii! ");
INSERT INTO mqjNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Annu la dengan tau ussanga kalena To nabassei bayu-bayu Puang Allata'alla anna to ussanga kalena nabi. La dengan duka' tanda memangnga-mangnga napadadi, annu morai la umpapusa to napile Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dadi kutimangkoa' kupokadaan ammu issanni mukatangkinni.” ");
INSERT INTO mqjNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mangkanna kamaparrisan, ‘pi'demi mata allo, ta'mo la pangngarrang bulan, ");
INSERT INTO mqjNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","anna la sironno'-ronnosan bentoen yao mai langi', napolalan ta'mo menggalattuan issinna langi'.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Attu iatoo, la naita tau Anak Mentolino turun yao mai langi' illalan gaun sitonda kakuasaan anna kamatandeanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anna la ussua malaeka'na urrempun ma'rupa tau to mangka napile mengkalao illalan inde linoe sae lako randanna langi'. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mala diala tandengan kayu ara: ianna kentarukmo anna mukku'mo daunna muissanammia' kumua la kulla'mi allo. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ianna ummitamokoa' kamaparrisan kendek susi mangka kupokadangkoa', muissanammi kumua la sae kalemi Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kupokadangkoa' sitonganna, ta'pa la pa'de rupa tau lapik temo anna lemba'mo inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langi' anna lino la pa'de, sapo' battakadangku la da'da' sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sitonganna tae' dengan tau ummissananni attunna, moi malaeka' yao suruga, moi Anakna Puang Allata'alla, angga Ambeku ummissananni. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Matangkin tongan-tongangkoa' annu tae' muissanan attunna. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Annu sirapan mesa to ma'banua la mengkalao untampe banuanna. Pantan umbengammi passanan sabua'na anna tawanni karangan, anna mane ma'pakari'di' lako to undagai ba'ba kumua la matangkin tongan-tongan. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Iamo too la matangkingkoa' indana lambi'ko mamma' to ma'banua ke tokke'i sae. Annu tae' muissanan attu kasaeanna: marammorika, tangngarika bongi, monirika manuk, battu mebongngi'ri. ");
INSERT INTO mqjNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inde tula'ku lako kalemua'e kutula' duka' lako angganna tau kukua: ‘Matangkingkoa'!’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","La dua bongipi anna lambi'mo attunna dipakaroa' allo kamai disanga Paskah anna allo kamai disanga Roti Tae' Diboloi Ragi. Umpeangmi lalan kapala imam sola to untarru' issinna sura'na Musa la ussakka buni Puang Yesus la napatei. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Sapo' nakua: “Tae' la dipasipatui allo kamai indana marukka tau.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Diomi Betania Puang Yesus illalan banuanna Simon to dolengan yolona. Marassanni ummande, saemi mesa baine umbaa buli-buli batu kaissi minna'-minna' disanga minnak narwastu simasulli' allinna. Umpoloimi ulu buli-bulinna, anna umbolloi ulunna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dengan pira-pira tau surrak buana ummitai, napolalan sipantula'-tula' nakua: “Maakari anna dikaleang-leangngi itin minna'-minna' masulli'o? ");
INSERT INTO mqjNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Itin minna'-minna'o mala dibaluk umbai la la'bi tallu ratu' dinar anna ditawaian to mase-mase.” Anna mane ungkeara'i inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sapo' nakua Puang Yesus: “Pabeaii. Maakaria' ammu keara'i? Annu inde bainee umpogau' kamapiaan lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Annu sisola liukoa' ia to mase-mase, anna ikoa' pawa ungkamaseii ke sia dengan dio penawammu la umpamoloii. Sapo kaleku, tae'kia' la sola liu. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Inde bainee, nakarangmi ia la malanna napogau', annu umminnakkimi batang kaleku la pa'patokanna ke dilamummo'. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kupokadangkoa' sitonganna: umba-umba dingei umpalanda' Kareba Kadoresan, iamo duka' dingei untula'i gau'na annu la diola umpengkilalaii.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dengan mesa to nakala' bilanganna sapulo dua passikolana Puang Yesus disanga Yudas Iskariot lao umpellambi'i kapala imam la umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dore' asammi urrangngii anna ma'dandi la umbenganni doi'. Umpeang liumi attu maliwang Yudas la nangei umpa'perososanni. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Inde anna diparandukmo umpakaroa' allo kamai disanga Roti Tae' Diboloi Ragie iamo allo sidingei untunu domba Paskah, mekutanami passikolana Puang Yesus lako nakua: “Umbanna angngenan muporai la kingei umpatokangko nande Paskah?” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ussuami dua passikolana anna pakari'di'i nakua: “Laomokoa' lako Yerusalem, dengan muane la mulambi' umbaa busso kaissi wai. Ula'mia' too, ");
INSERT INTO mqjNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","sae lako banua nangei torro ammu kuanni to ma'banua dio, mepasan Tuanggurungki kumua umbanna salanta' banuammu mupatokanni la nangei ummande nande Paskah sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","La napaitaikoa' mesa angngenan kalua' tanda langngan annu mangkami napatoka. Iamo la mungeia' umpatokangki' nande Paskah.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mengkalaomi inde dua passikolae. Saei lako Yerusalem, nalambi' tongammi susi napokada Puang Yesus. Umpatokami nande Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bongii, saemi Puang Yesus sola sapulo dua passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Marassanni ummande, nakuamo Puang Yesus: “Kupokadangkoa' sitonganna, dengangkoa' mesa la umpa'perososanna', iamo to kusolaan ummande temo.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Masussa asammi penawanna anna mane sibala'-bala' mekutana nakua: “Tangngia mammoka kao, Tuangguru?” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Natimba' nakua: “Sala' bennammua' inde to sapulo duakoa'e, to kusolaan ummoton roti rokko mesa pindan. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Innang la mate ia Anak Mentolino situru' issinna Buku Masero, sapo la sanggang to umpa'perososanni. Mala pissan ia kela ta'mo didadian.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Marassanni ummande Puang Yesus sola passikolana ummalami roti anna ma'kurru' sumanga', anna mane piak-piakki nabeen lako passikolana napasiolaan ma'kada nakua: “Alai ammu andei, iamo te batang kalekue.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mangkaii, ummalami irusan anna ma'kurru' sumanga' anna mane beenni lako passikolana. Naalami anna sibala'-bala'i nairu'. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nakuamo Puang Yesus: “Iamo te rarakue la umpomanassa pa'dandinna Puang Allata'alla, la dipato'do umpasalama' buda tau. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Annu kupokadangkoa' sitonganna, ta'mo' dengan la ummiru' pole anggur sae lako nalambi' attungku ummiru' anggur bakaru illalan kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mangkai too, ummoyongmi mesa penanian umpakasalle Puang Allata'alla anna mane mengkalao langngan Tanete Zaitun. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma'kada Puang Yesus lako passikolana nakua: “Kutulasangkoa' sitonganna, la le'ba asangkoa' ussipelle-pelleina'. Annu dengan tiuki' illalan Buku Masero nakua: ‘La kupatei to ma'kambi' napolalan tisembu' dombana.’ ");
INSERT INTO mqjNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sapo' ianna tuomo' sule, la kuyoloanammokoa' lako Galilea.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tappa ma'kada Petrus nakua: “Moi la le'ba asan solaku, tae'nakkao la le'ba.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Natimba' Puang Yesus nakua: “Kupokadangko sitonganna, ta'pa moni manuk kapenduanna mani bongi anna pentallummo' mutelang.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sapo tuttuan napemandui Petrus nakua: “Moi la dipateiki' sola, innang tae' dengan leleangku la untelangko!” Susi asammi duka' tula'na solana Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Saei lako mesa angngenan disanga Getsemani, ma'kadami Puang Yesus lako passikolana nakua: “Okko'mokoa' te indee angku laopa ma'sambayang.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Umbawaimi Petrus sola Yakobus anna Yohanes ussolanni. Naparandukmi magara' Puang Yesus anna masussa penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nakuamo: “Masussa tongan-tongan penawangku temo, kupolalan susimo to la bonno' kusa'ding. Torromokoa' te indee, sapo la matangkingkoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Memberomi titti' anna malimuntu' dio litak anna ma'sambayang kumua kenamala tae' ummolai kamasussaan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nakua: “O Ambeku, tae' dengan aka tala mala dadi ke mukua. Pasikambelamo' kamasussaan kutingngayo temo, sapo' tangngia pa'kuangku la dadi, sangngadinna pa'kuammu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mangkai ma'sambayang, sulemi lako passikolana sapo mamma' asan tallui nalambi'. Nakuamo lako Petrus: “O Simon, mamma'rokoka ikoa'? Ta'raka mutaro daga moi satettekmo? ");
INSERT INTO mqjNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Matangkingkoa' ammu ma'sambayang indana taloikoa' passudian umpogau' kasalaan. Innang morai ia penawa la ma'gau' mapia, sapo malamma batang kalemua'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Anna mane mengkalao pole lao ma'sambayang, susi siami sambayangna angngena'. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sulei kapenduanna mamma' pole omi passikolana nalambi', annu nataloi sigalimi matanna. Ta' babangmo naissanan aka la nakua lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sulei kapentallunna lao ma'sambayang, nakuamo lako passikolana: “Mamma' liu siapokoka ikoa'? Siruamia'. Nalambi'mi attunna la ummitakoa' Anak Mentolino la dipalessu' rokko lisu pala'na to kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Millikmokoa' anta lao untammui to la umpa'perososanna' annu madappi'mi.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Marassampi mantula' Puang Yesus anna saemo Yudas, mesa to nakala' sapulo dua passikolana, ussolaan buda tau umbaa pa'dang sola bose nasua kapala imam sola to untarru' issinna sura'na Musa anna perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Innang mangkami napokada to umpa'perososanni lako to nasolaan sae nakua: “Iamo to kuudung, iamo too. Sakkamia' too ammu baai lao, sapo dagai manappai.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Saei lako tappa umpellambi'imi Puang Yesus anna ma'kada nakua: “O Tuangguru!” anna mane udungngi. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sasaean siami to nasolaan Yudas ussakkai. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dengan mesa passikolana umbonok pa'dangna anna umbatta sabua'na Pongkena Imam, napolalan mallai talinganna. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nakuamo Puang Yesus: “Musangarakka to kadakea', ammu umbaa pa'dang sola bose sae ussakkana'? ");
INSERT INTO mqjNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kusanga sidio liuna' Banua Ada'na Puang Allata'alla ke allo ma'pa'guru illalan alla'-alla'mua', maakari anna tae'na' musakka. Sapo innang la diganna'i battakada tiuki' illalan Buku Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sikakondong siami passikolana le'ba umpelleii. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dengan mesa anak muane to nasolaan Puang Yesus angga sambu' illalan kalena, ambo' la nasakka duka' tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sapo' ummalai sambu'na anna le'ba kumondong ma'kale-kale. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dibaami Puang Yesus lako Pongkena Imam. Ma'mesami dio angganna kapala imam anna perepi'na to Yahudi sola to untarru' issinna sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Naula' manarangmi Petrus sae lako luba'ba banuanna Pongkena Imam anna ummokko' mendarang sola to daga. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Umpeangmi lalan kapala imam anna angganna pa'bisara alukna to Yahudi la umpatei Puang Yesus, sapo' tae' dengan lalan naita. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Buda tau pantan untula' kasa'bian tatongan, sapo' tae' tappa dengan siundu' kasa'bianna. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pira-pira tau ke'de' umpokada kasa'bian tatongan nakua: ");
INSERT INTO mqjNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dengan kirangngi kadanna nakua: ‘La urroppokanna' Banua Ada'na Puang Allata'alla panggaraga ma'rupa tau angku pake'de' polei, angga la tallungngallo anna mangkamo, tangngia panggaraga ma'rupa tau.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sapo' tae' asan dengan siundu' kadanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ke'de' siami Pongkena Imam illalan alla'-alla'na tau kamban anna mekutana lako Puang Yesus nakua: “Ta'raka la mutimba' pa'tanda'na tau lako kalemu?” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sapo' tontong mengkamma' Puang Yesus, napolalan mekutana pole Pongkena Imam nakua: “Ikomoka To nabassei bayu-bayu Puang Allata'alla, anakna To randan dipakasalle?” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Natimba'mi nakua: “Kaomo tee. La ummitakoa' Anak Mentolino ummokko' dio tandai kananna To randan kuasa anna la sae yao mai langi' illalan gaun.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ussesse' siami pakeanna Pongkena Imam anna ma'kada nakua: “Ta'mo parallu sa'bi ");
INSERT INTO mqjNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","annu murangngimia' kadanna untelle Puang Allata'alla! Umba iko nakua diona penawammua'?” Nasituru'-turu'imi umpasala Puang Yesus anna la napabambanni sangka' dipatei. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dengan pira-pira tau untikkuduii anna balu-baluii anna mane dangguru'i napasiolaan ma'kada nakua: “O nabi, muissanangka to undangguru'ko?” Anna sae duka' lako to daga undangguru' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Attu iatoo diopi pa'rantean Petrus, saemi mesa baine sabua'na Pongkena Imam. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tappana ungkamata Petrus menge mendarang, napengkawanannimi lindona anna ma'kada lako nakua: “Solanako duka' Yesus, iatoo to Nazaret-o.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sapo mantelang Petrus nakua: “Tae' kuissanan aka mupokada.” Anna mane le'ba' lako salianna bala, moni siami manuk. ");
INSERT INTO mqjNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ummita polei Petrus inde bainee nakuamo lako to dio reen attu iatoo: “Inde taue manassa solana.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sapo' natelang pole Petrus. Tae' masae nakuamo to dio reen lako: “Manassa solanako, annu to Galileako duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Naparanduk pole' ma'pinda-pinda Petrus nakua: “Tae' tongan-tongan kuissanan itin to mutula'o.” ");
INSERT INTO mqjNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Moni siami manuk kapenduanna. Tappa ungkilalaimi tula'na Puang Yesus lako kalena Petrus nakua: “Ta'pa moni manuk kapenduanna, anna pentallummo' mutelang.” Ma'pase'gok-se'gok siami tumangi'. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mebongngi'-bongngi'pi anna urrapa'mo kada pa'bisara alukna to Yahudi, iamo kapala imam sola perepi'na to Yahudi anna to untarru' issinna sura'na Musa. Umpungomi Puang Yesus anna baaii lako Pilatus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Saei lako nakutanaimi nakua: “Ikomoka tomarayanna to Yahudi?” Natimba'mi nakua: “Ikomo melolo ungkuai.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Budami pa'tanda'na kapala imam lako Puang Yesus natula' la naola umpaalinnii kalasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Mekutana polemi Pilatus nakua: “Tae' tappa'rokoka Iko la mentimba'? Perangngii, budami kadanna tau umpatampoiko kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sapo' tae' dengan mentimba' Puang Yesus napolalan mangnga-mangnga babang Pilatus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ianna nalambi' omo allo kamai disanga Paskah, siurrappanan liu mesa to ditarungkun Pilatus situru' pelaunna tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Attu iatoo dengan mesa tau disanga Barabas ditarungkun sola pira-pira to papatean inde anna umbali to ma'parentae. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Saemi tau buda melau lako Pilatus kenamala urrappanan mesa to ditarungkun susi beasanna sinapalako. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mekutanami Pilatus nakua: “La muporaika ke kurappananni inde tomarayammua'e?” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Annu innang naissanammi kumua ia sia nangei umbaa sae Yesus perepi'na to Yahudi annu mangungngu' lako. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sapo' urrasi tau buda kapala imam anna pelaui kenamala Barabas dirappanan. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mekutana pole omi lako tau buda nakua: “Ianna susi too, aka la kupogau' lako inde to musanga tomarayanna to Yahudie?” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sipetamba-tambaammi nakua: “Pasokki lako kayu pantokesan!” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma'kadami Pilatus nakua: “Aka tappa' kasalaanna?” Sapo' tuttuan napemandui sipealo'-alosan nakua: “Pasokki lako kayu pantokesan!” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Urrappanammi Barabas la naola umpalosso' inawanna tau buda. Ussuami tantara undarra Puang Yesus anna mane pebenganni la dipasok lako kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mangkai too, umbaami Puang Yesus tantara lako pa'rantean sinangei illalan banuanna gubernur anna untambai asan solana ma'mesa. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Napapakeimi bayu rui' mellolo pao rupanna susi bayunna tomaraya anna anananni balayan ma'duri silio songko'na tomaraya anna mane pasongko'i. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mangkai napa'tabe'imi nakua: “Tabe' tomarayanna to Yahudi.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ummalami tangke kayu anna longa'i ulunna, anna mane tikkudui anna malimuntu' leen umpenombai kari'. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mangkai natelle, naalaimi sule bayu rui'na anna papakei sule pakeanna. Anna mane dibaa suun Puang Yesus, la lao dipasok lako kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ummolai lalan sitammumi mesa tau disanga Simon to Kirene, ambena Aleksander sola Rufus, mane sae dio mai tondok senga' la lu tama Yerusalem. Napassami la umpassan kayu pantokesanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Umbaami Puang Yesus lako mesa angngenan disanga Golgota kalembasanna angngenanna karorak ulu. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anna mane beenni anggur sirau mur sapo' tae' naaku. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Napasokmi lako kayu pantokesan anna undii pakeanna la naola untawa-tawai. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tettek kasera allo anna dipasok lako kayu pantokesan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Dengan pangnguki' yao tondonna la dingei ummissananni kasalaanna nakua: Tomarayanna To Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dengan duka' dua to kadake nasimbaraan Puang Yesus dipasok lako kayu pantokesan, mesa dio tandai kananna anna mesa dio tandai kairinna.  ");
INSERT INTO mqjNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ganna' illalan issinna Buku Masero nakua: “La diangga' to kadake duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Angganna to liu dio angngenan iatoo ummiling-iling asan anna untelle Puang Yesus nakua: “Kusanga la urroppokangko para' Banua Ada'na Puang Allata'alla ammu pake'de'i sule tallungngallo. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Turummoko yao mai kayu pantokesan, ammu rappanan kalemu.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Susi toi duka' kapala imam anna to untarru' issinna sura'na Musa sipantula'-tula' ma'telle nakua: “Ianna tau senga'mo napasalama'mi. Sapo' ianna kalenamo ta'mo nabela napasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ianna tonganna tomarayanna to Yahudi anna To nabassei bayu-bayu Puang Allata'alla, la turun yao mai kayu pantokesan temo anta itaia' sola taoreanni.” Sae duka' lako inde dua to nasimbaraan dipasok lako kayu pantokesanne untelle Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tettek sapulo duai allo malillimmi padang illalan lili'na lembang iatoo sae lako tettek tallu karuen. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tettek tallui karuen metambami Puang Yesus nakua: “Eloi eloi lama sabakhtani?” kalembasanna: O, Dewatangku, O, Dewatangku, maakari ammu tampena'? ");
INSERT INTO mqjNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pira-pira to ke'de' dio angngenan iatoo urrangngii metamba sipantula'-tula' nakua: “Untambai nabi Elia.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dengammi mesa tau kumondong lao ummala bunga-bunga susi lumu' naoton tama anggur maissuk anna palekke'i lako roan anna padundui pudukna Puang Yesus la napairu', napasiolaan ma'kada nakua: “Anta ampaia' anta itai battu la sae tongarri Elia umpaturunni.” ");
INSERT INTO mqjNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mealo'mi Puang Yesus anna mane kattu penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sesse' siami sampin pesapa' illalan Banua Ada'na Puang Allata'alla dio Yerusalem tipa'dua mengkalao yao sae rokko. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inde anna ummitamo kamateanna Puang Yesus ponggawana tantarae, ma'kadami nakua: “Manassa Anakna tongan Puang Allata'alla inde taue.” Nakawanan tongan-tongan annu ke'de' dio tingngayona Puang Yesus attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dengan duka' pira-pira baine umparandan mambelai, susinna Maria Magdalena, Salome, anna Maria indona Yakobus barinni' sola Yoses. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Inde mai bainee sangngin to unturu'mo Puang Yesus, anna to untarakannii anna sidiopa Galilea. Budapi baine senga' dio duka' reen, to ussolanni sae dio Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Attu iatoo allo pa'patokaan la ummampai allo katorroan anna la kuku' kalemo bongi. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Napengkabaranimi Yusuf to Arimatea, lao umpellambi'i Pilatus anna umpelau batang rabukna Puang Yesus. Inde Yusuf-e mesa to keangga' to nakala' duka' pa'bisara alukna to Yahudi anna masae allomo naola ummampai kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Mangnga-mangnga Pilatus anna urrangngimo kareba kumua bonno'mi Puang Yesus. Untambaimi ponggawana tantara anna kutanaii battu la bonno' tongarri. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Inde anna urrangngimo kadanna ponggawana tantarae, umpabeaimi Yusuf ummala batang rabukna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ummallimi sampin mabusa Yusuf, anna lao umpaturun batang rabukna Puang Yesus anna balunni. Mangkaii napatamami lokko' dio mesa tanete batu. Ullenggannimi mesa batu kamai natutu'ianni ba'bana. ");
INSERT INTO mqjNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Inde liangnge naita Maria Magdalena sola Maria indona Yoses. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lessu'i allo katorroan ummallimi minna'-minna' bumanangnga' Maria Magdalena anna Maria indona Yakobus anna Salome la lao napabonangngian batang rabukna Puang Yesus tama lokko'. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Allo Minggui, mebongngi'-bongngi'mi mengkalao lako liang. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ummolai lalan sipantula'-tula'mi nakua: “Bennamo la umberoiangki' batu tutu' lokko'?” ");
INSERT INTO mqjNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sapo' la sae kalei lako liang, naitami innang tiberomi inde batu kamaie. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tamami liang, ummitami mesa to mangngura ma'pakean mabusa ummokko' dio tandai kanan. Tikkedu' asammi anna mangnga-mangnga. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sapo' ma'kada inde to mangngurae nakua: “Daua' tikkedu'! Kuissanan kumua umpeangkoa' Yesus to Nazaret, to mangka dipasok lako kayu pantokesan, sapo' ta'mo inde annu tuomi sule. Petua'i, indemi angngenannae. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sapo laomokoa' ammu pokadanni Petrus sola passikola senga' kumua yolomi lako Galilea, la silambi' diokoa' susi mangka napokada lako kalemua'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Le'ba' siami sikakondong umpellei liang annu tikkedu' napolalan lumalla'-malla' marea' ummita kadadian iatoo. Tandana marea', tae' dengan napokada lako tau senga'.  ");
INSERT INTO mqjNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Allo Minggui mebongngi' tuomi sule Puang Yesus. Bunga'-bunga'na umpa'paitaan kalena lako Maria Magdalena to mangka narambaian pitu setang illalan mai kalena. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Laomi umpaissanni angganna to siunturu' Puang Yesus annu' nakala'pi pa'barataan anna tae' liupa tipoli' wai matanna attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sapo' tae' naorean kumua tuo sule Puang Yesus anna mangkamo umpa'paitaan kalena lako inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mangkai too, umpa'paitaan pole omi kalena ma'rupa senga' lako dua to unturu'i, attunna illalan kapenonosan la lu lako tondok senga'. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma'pasulemi inde dua taue anna lao untetteranni lako solana, sapo' tae' duka' naorean. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Katampakanna umpa'paitaan pole' kalena lako sapulo mesa passikolana anna marassan ummande. Ussassaimi passikolana annu tae' ummorean kadanna to mangka ummitai kumua tuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nakuamo lako passikolana: “Laokoa' umpalanda' Kareba Kadoresan lako angganna ma'rupa tau sae lako tampakna lino. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Benna-benna mangngorean anna ditedok, la dipasalama'. Sapo' benna-benna tae' mangngorean, la unduppa pandarraan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","La susi inde tandana to mangngoreanne: mala la urrambai setang ummolai sangangku, mala mantula' illalan ma'rupa-rupa basa senga', ");
INSERT INTO mqjNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","moi la ummanda'i ula' sola ummiru' rasun tae' la nasanggangngi, ianna urrumbu to masaki tae' mala tamalapu'.” ");
INSERT INTO mqjNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mangkai mantula' lako passikolana, tiangka'mi langngan suruga anna ummokko' dio tandai kananna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mengkalaomi passikolana umpalanda' Kareba Kadoresan lako angganna angngenan anna Puang Allata'alla umbenganni kuasa umpogau' tanda memangnga-mangnga napolalan nakawanan ma'rupa tau kumua angganna battakadanna Puang Allata'alla napalanda' tonganna asan.");
INSERT INTO mqjNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Teofilus to dipakasalle, budami tau umpeang lalan la ummuki' aka mangka dadi illalan alla'-alla'ta situru' rettenanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pantan nauki'mi situru' tula'na lako kaleta to melolo ummita inde kadadianne mengkalao dio pa'parandukanna. Inde mai to melolo ummitaie ia siamo to umpalanda' battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mangkanna kupengkalesoi manappa mengkalao dio pa'parandukanna, kendekmi illalan penawangku la ummukisangko situru' rettenanna ");
INSERT INTO mqjNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","anna malara muissanan kumua angganna mangka dipatuduangko, tonganna tongan. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Attunna tomaraya Herodes ma'parenta dio lembangna Yudea, dengan mesa imam disanga Zakharia, to nakala' kombonganna imam Abia. Disanga Elisabet bainena, peampoanna imam Harun. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Inde to sipobainee, bassi malolo dio olona Puang Allata'alla anna tae' dengan sassana unturu' angganna parentana Dewata. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sapo tae' keanak annu tamanang Elisabet anna bassi matuamo. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pissan attu, nalambi' attunna imam to nakala' kombonganna imam Abia la mengkarang, napolalan umpalako passananna Zakharia dio tingngayona Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Situru' kabeasaan, sinaundi angganna imam la naola umpatantu to la umpalako karangan imam illalan Banua Ada'na Puang Allata'alla untunu kemenyan. Attu iatoo Zakharia napatu. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Marassanni ditunu kemenyan, ma'sambayangmi tau buda dio salian. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Umpa'paitaammi kalena mesa malaeka'na Dewata lako Zakharia ke'de' dio tandai kananna angngenan pemalasan sidingei untunu kemenyan. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tikkedu'mi Zakharia ummitai siolaan marea'. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sapo ma'kada inde malaeka'e nakua: “O Zakharia, dau marea' annu narangngimi sambayangmu Puang Allata'alla. La keanak Elisabet bainemu, la muane anakna anna la musangai Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","La dore'ko ke dadimi inde anakke anna la buda tau dore'. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Inde anakke la keangga' dio olona Dewata. Tae' dengan leleanna la ummiru' anggur battu wai senga' la umpomalangona tau, anna la naluang Penawa Masero mengkalao dio mai dadinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","La buda to Israel napasule lako olona Puang Allata'alla, Dewatanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","La uyyoloanan Dewata sitonda kakuasaanna Penawa Masero susi nabi Elia. La umpasikapia ambe anna anak, anna lako to tae' manuru' la naparunduk sule lako lalan kamaloloan. Nakuamo te karangannae la naola umpatoka ma'rupa tau la mendadi petauanna Dewata.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mekutanami Zakharia lako inde malaeka'e nakua: “Umba la kukua ummissananni kumua la dadi tongan itin kara-karao, annu bassi matuamokan baineku?” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Natimba' inde malaeka'e nakua: “Kaomo Gabriel to sinasua Puang Allata'alla, nasuana' temo sae umpantula'iko anna umpalandasangko inde kareba mapiae. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Perangngi manappai kumua tae' la muissan mantula' sae lako attunna lemba' inde kara-karae annu tae'ko ummorean tula'ku. Annu innang la dadinna ke nalambi'mi attunna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Attu iatoo, mausa'mi tau buda ummampai Zakharia anna mangnga-mangnga asammo annu masae sigalimi Zakharia illalan Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Inde anna suummo Zakhariae, ta'mo naissan mantula' lako tau buda, anggami limanna napakagero'-gerok liu napolalan naissanan tau buda kumua dengan aka naita illalan Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Purai attu pengkaranganna Zakharia illalan Banua Ada'na Puang Allata'alla, sulemi lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tae' masae mangkanna, manambuk tongammi Elisabet, bainena. Lima bulan tae' umpa'paitaan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nakuamo Elisabet: “Iamo te kara-kara napogau' Dewata lako kalekue. Nakamaseina' anna napa'deimo pole' siri'ku temo dio mai tingngayona tau.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Annanni bulanna tambukna Elisabet, ussuami malaeka'na Puang Allata'alla disanga Gabriel lako Nazaret, mesa tondok dio lembangna Galilea, ");
INSERT INTO mqjNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","lao umpellambi'i mesa anak dara disanga Maria. Inde Mariae, situmai mesa anak muane disanga Yusuf, peampoanna tomaraya Daud. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Saei lako banuanna Maria, ma'kadami inde malaeka'e nakua: “Kerongko'ko, natamba'ko Dewata anna la tontongko nasolaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mangnga-mangnga Maria urrangngi tula'na inde malaeka'e lambisan kendek pekutana illalan penawanna diona kalembasanna inde tula'e. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nakua pole omo inde malaeka'e: “O Maria, dau marea' annu ikomo napile Puang Allata'alla la natamba'. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","La manambukko, la muane anakmu anna la musangai Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","La mendadi mesa to kamai anna la digente' Anakna Puang Allata'alla to randan matande. La napopendadi tomaraya Puang Allata'alla susi tomaraya Daud nenena. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","La umparenta peampoanna Yakub sae lako-lakona, anna inde kaparentaannae tae' dengan ma'meanggaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nakuamo Maria lako inde malaeka'e: “Umbamo la nakua dadi itin kadammuo annu ta'pa' kemuane?” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Natimba' inde malaeka'e nakua: “La turun Penawa Masero tama kalemu anna kakuasaanna To randan matande la ussolangko. Iamo too, itin anak la mudadianno la digente' To masero, Anakna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kupokadangko sitonganna, manambukmi Elisabet sa'do'dorammu moika anna matuamo anna sinakuanni tau to tamanang sapo annammi bulanna tambukna temo. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Annu tae' dengan aka tanaissan napadadi Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nakuamo Maria: “Sabua'nana' te Dewatae, iamo mukua iamo dadi lako kaleku situru' itin tula'muo.” Le'bami malaeka' umpellei Maria. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mangkai too, mengkalao siami Maria lako mesa kota yao mentanetena dio lembangna Yudea, ");
INSERT INTO mqjNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","lao umpellambi'i banuanna Zakharia. Saei lako, umpantula'imi Elisabet. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tappana urrangngi tula'na Maria Elisabet, kedo siami anakna illalan tambukna. Nakuasaimi Penawa Masero Elisabet ");
INSERT INTO mqjNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","lambisan metamba, nakua: “Angganna baine, ikomo randan ma'tandalangnganan tamba'mu, anna la ditamba' duka' anak la mudadian. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sitonganna tae'na' sipato' la napellambi'i indona Dewatangku. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Annu kurangnginna tula'mu, kedo siami anakku illalan tambukku dore'. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kerongko'ko annu muorean kumua angganna kadanna Dewata lako kalemu la dadi!” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nakuamo Maria: “Mengkalao illalan penawangku lemba' dio pudukku umpakasalle Dewata, ");
INSERT INTO mqjNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","anna sangkalebu penawangku dore' annu napasalama'na' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tontong umpaillalan penawa kamemase-maseanna inde sabua'nae. Mengkalao temo la nakuanna' angganna lapikna ma'rupa tau: ‘To kerongko'.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Annu umpogau' tanda memangnga-mangnga lako kaleku Puang Allata'alla To randan kuasa. Masero sanganna! ");
INSERT INTO mqjNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pa'kamasena Puang Allata'alla mellambi' lako to mengkarea' lako kalena sae lako peampoanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mangka umpogau' kara-kara kamai ummolai kakuasaanna, anna umpasisarak-sarak to malangka' penawa. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Buda tomaraya napaturun yao mai okkosan kaparentaan, anna untandean to tanda rokko. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Umpasonai kamapiaan angganna to tadea', anna angganna tomakaka narambai lao ma'pala' lo'bang. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Umpamoloi peampoanna Israel sabua'na, tae' dengan lembe ungkamaseii. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Annu tae' dengan ungkalembei pa'dandinna lako neneta anna lako Abraham sola lako angganna peampoanna sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Torropi Maria dio sola Elisabet umbai tallu bulan anna mane ma'pasule lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tapakala, nalambi'mo attunna la keanak Elisabet. Napolalan keanakmo, muaneria anakna. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Dore' asammi duka' sabanuanna anna angganna rapunna anna rangngimi kumua umba nakua pa'kamasena Dewata lako Elisabet. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Karuai allona dadinna sasaeammi sabanuanna anna angganna rapunna annu la disunna'mi. Morai asammi la ussangaii Zakharia susi sanganna ambena. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sapo ma'kada indona nakua: “Tae'! La disangai Yohanes.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nakuamo inde mai sabanuanna sola rapunnae: “Tae' dengan rapummua' disanga Yohanes.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Umpebeemmi tanda lako ambena kumua aka la disangaian inde ana'-ana'e. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Umpelaumi papan sidipangnguki'i anna uki'i nakua: “La disangai Yohanes.” Mangnga-mangnga asan inde mai taue. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Attu ia siamo too anna tibuka sule pudukna Zakharia lambisan mala mantula' anna umpudi Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Marea' asammi sabanuanna. Silelemi kareba diona inde kara-karae dio mentanetena Yudea. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Angganna to urrangngi kara-kara iatoo mekutana asan illalan penawanna nakua: “La mendadi akai inde anak ke dako'e?” Annu manassa anna napaloloanni Dewata. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nakuasaimi Penawa Masero Zakharia, ambena inde anakke, napolalan ullombungan tula'na Dewata nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dipomatande Puang Allata'alla Dewatanna to Israel, annu saemi umpellambi'i petauanna anna sulangngi. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nabengangkia' to la umpasalama'ki', tae' dengan untondonni, peampoanna tomaraya Daud sabua'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Susi mangka nadandi Puang Allata'alla ummolai nabi maserona yolona ");
INSERT INTO mqjNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","la napasalama'kia' dio mai angganna ewalinta anna kakuasaanna angganna to ungkabassikia'. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","La umpakawanan pa'kamasena lako neneta anna ungganna'i pa'dandi maserona. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Inde pa'dandinnae mangka napa'pindai lako Abraham kabuttuanta ");
INSERT INTO mqjNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kumua la naberoikia' dio mai kakuasaanna ewalinta, anta malara tae' marea' umpenombaii ");
INSERT INTO mqjNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","anna la maseroki' sola malolo dio olona illalan salolo salu katuoanta. ");
INSERT INTO mqjNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Anna iko anakku, la digente'ko nabinna Puang Allata'alla To randan matande. Annu ikomo disua yolo la umpatokaan lalan Dewata, ");
INSERT INTO mqjNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","anna la mupa'peassakan lako petauanna kumua la digarri'i kasalaanna ma'rupa tau napolalan dipasalama' ");
INSERT INTO mqjNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ura'na pa'kamasena tadiissan disangai lambisan sae tama lino umpellambi'ikia'. Sirapan birra'na allo mebongngi' ");
INSERT INTO mqjNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","la ummarrang angganna to nakala' kamalillinan anna to natondon kamatean, la natette lako kamasakkean anna kamalinoan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tuttuan kamaimi inde anakna Zakhariae anna tuttuan matoro penawanna. Torromi dio padang alla' sae lako nalambi' attunna la umpakawanan kalena lako to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Attu iatoo umpasuun parenta tomaraya Agustus la diteken angganna ma'rupa tau illalan lili'na kaparentaanna Roma. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iamo te bunga'-bunga'na dipalako pantekenanne attunna Kirenius mendadi gubernur dio Siria. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pantan laomi umpellambi'i tondok kadadianna tau anna malara diteken dio. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mengkalaomi duka' Yusuf dio kota Nazaret lembangna Galilea le'ba langngan tondok Betlehem lembangna Yudea, tondok kadadianna tomaraya Daud, annu innang peampoanna tomaraya Daud. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ussolammi Maria to la napobaine la lao diteken. Attu iatoo manambukmi Maria. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Inde anna diomo Betlehem-e, nalambi'mi attunna la keanak Maria ");
INSERT INTO mqjNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","napolalan dadimo anak pa'bunga'na, muane. Namomommi sampin anna lole'i rokko pa'pandean domba, annu tae' dengan banua nangei torro. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dio inde angngenanne dengan pira-pira to ma'kambi' torro dio pasang ma'bongi undagai pa'kambi'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pissananna tokke'mo umpa'paitaan kalena mesa malaeka'na Dewata lako inde to ma'kambi'e, anna naarrang kamatandeanna Dewata passassang yao mai langi', napolalan marea' asan. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sapo ma'kada inde malaeka'e nakua: “Daua' marea', annu saena' umpalandasangkoa' kareba mapia, kareba la umpadore' angganna tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bongi temo dio tondokna tomaraya Daud dadimi To la umpasalama'koa' iamo Kristus, Dewatammua'. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Anna la susi inde tandanae: La ullambi'koa' ana'-ana' dimomon sampin dilole' dio pa'pandean domba.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tokke'mi diita buda malaeka' senga' buttu yao mai suruga sola inde malaeka'e umpudi Puang Allata'alla nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dipakasalle Puang Allata'alla yao angngenan randan matande, anna la masakke ma'rupa tau illalan lino to naporai Dewata.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Le'bai malaeka' langngan suruga umpellei inde mai to ma'kambi'e, sipantula'-tula'mi nakua: “Anta laomoa' lako Betlehem umpetua' kara-kara dadi dio susi napokada Dewata lako kaleta.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mengkalao siami lako, ullambi'mi Maria sola Yusuf anna inde ana'-ana' dilole' dio pa'pandean dombae. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ummitanna inde ana'-ana'e, untetterammi tula'na malaeka' umpokada inde anakke. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mangnga-mangnga asammi to urrangngii tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sapo napaillalan penawa ia Maria inde kara-karae anna penawa-nawaanni. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma'pasulemi inde to ma'kambi' lako angngenannae napasiolaan umpudi anna umpakasalle Puang Allata'alla annu angga narangnginna anna naitanna tae' dengan sisalanna tula'na malaeka'. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Karuai allona dadinna inde ana'-ana'e, disunna'mi anna disangai Yesus situru' sanga napokada malaeka' anna ta'pa natambuk indona. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nalambi'i attunna la usseroi kalena Maria situru' Pepa'guruanna Musa, laomi sola Yusuf umbaa anakna langngan Yerusalem la nasorong langngan Dewata, ");
INSERT INTO mqjNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","susi tiuki' illalan Parentana Dewata nakua: “Angganna anak pa'bunga' muane la disorongan langngan Dewata.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Umbaami duka' bua pemala'na situru' Parentana Dewata, iamo dua bukku' battu dua anak dangan-dangan. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Attu iatoo dengan tau dio Yerusalem disanga Simeon, mesa to malolo anna mengkarea' langngan Puang Allata'alla anna nakuasai Penawa Masero, ummampai attunna dirappanan to Israel dio mai kamaparrisan. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anna innang mangkami napakawanan Penawa Masero lako kumua tae' la bonno' ke ta'pa ummita To nabassei bayu-bayu Puang Allata'alla la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nagara'mi Penawa Masero Simeon napolalan tama Banua Ada'na Puang Allata'alla. Attu iamo too anna sae tama Banua Ada'na Puang Allata'alla Puang Yesus nabaa to matuanna annu la dipogau'mi sara' lako kalena situru' Pepa'guruanna Musa. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ummalami inde ana'-ana' Simeon-e anna riwai, napasiolaan umpudi Puang Allata'alla nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Dewata, muganna'imi pa'dandimmu lako kaleku temo. Masannangmo' la umpellei lino ");
INSERT INTO mqjNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","annu melolomi matangku ummita To ma'pasalama' buttu dio mai kalemu, ");
INSERT INTO mqjNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mupatokaan angganna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Inde To ma'pasalama'e sirapan kamasiangan la napopaita to salianna to Yahudi sae lako olomu anna la umbaa kamatandean lako petauammu, to Israel.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bassi mangnga-mangngami ambena sola indona urrangngi Simeon untula' inde anaknae. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Napelauammi tamba' Simeon inde to sarapue anna mane ma'kada lako Maria, indona inde ana'-ana'e nakua: “Inde anakmue mangka naturo Puang Allata'alla la undondonan anna untandean buda to Israel. Anna la mendadi tanda pa'pakainga' yao mai Puang Allata'alla, la natumpu pala' ma'rupa tau ");
INSERT INTO mqjNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","anna malara kawanan issi penawanna ma'rupa tau. Anna iko Maria, la ussa'dingangko kamapa'disan sirapan to digayang pa'dang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Dengan duka' mesa nabi, baine disanga Hana, anakna Fanuel, peampoanna Asyer. Inde Hanae matuami annu karuami pulona appa' taunna. Masaemi balu annu angga pitu taun sola muanena anna matemo muanena. Tae' dengan leleanna umpellei Banua Ada'na Puang Allata'alla, allo bongi menomba langngan Puang Allata'alla, ma'puasa anna ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Attu iatoo saemi duka' ma'kurru' sumanga' langngan Puang Allata'alla anna untula' inde anakke lako tau buda to ummampai attunna Puang Allata'alla ussulang to Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mangka asanni umpalako sara' situru' Parentana Dewata, ma'pasulemi Yusuf sola Maria lako tondok Nazaret dio lembangna Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tuttuan kamaimi inde anakke anna matoro, keaka' anna natamba' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taun-taun, silao liu langngan Yerusalem to matuanna Puang Yesus umpakaroa' allo Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sapulo duai taunna Puang Yesus lao omi langngan Yerusalem situru' kabeasaan sinapogau' tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mangkai sara', ma'pasulemi Yusuf sola Maria sapo tae' naissanan kumua torropia Puang Yesus, anakna yao Yerusalem ");
INSERT INTO mqjNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","annu nasanga sola tau buda menono'. Sangngalloi menono' mane napeangri lako sa'do'doranna sola lako siissananna, ");
INSERT INTO mqjNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","sapo tae' dengan nalambi' napolalan ma'pasule langngan Yerusalem umpeangngi. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tallungngalloi napeang, mane nalambi'ri illalan Banua Ada'na Puang Allata'alla ma'loko illalan alla'-alla'na pebawa alukna to Yahudi ma'perangngi anna mekutana lako. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mangnga-mangnga asan to dio reen urrangngi kamanaranganna anna pentimba'na inde anakke. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mangnga-mangngami duka' to matuanna ummitai. Ma'kadami indona lako nakua: “O anakku, maakari ammu ma'pasusi lako kaleki? Tae' dengan ra'da penawangku sola ambemu umpeangko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Natimba' Puang Yesus nakua: “O ambe' sola indo', maakari ammu peangna'? Ta'raka muissanan kumua innang la illalanna' banuanna Ambeku?” ");
INSERT INTO mqjNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sapo tae' naissanan to matuanna kalembasanna inde tula'nae. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mangkai too, sola-solami ma'pasule lako Nazaret, anna tontong liu manuru' lako to matuanna. Angganna inde kara-karae napaillalan penawa liu indona. ");
INSERT INTO mqjNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tuttuan kamaimi Puang Yesus, tuttuan keaka' anna tuttuan umpomasannang Puang Allata'alla sola ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kasapulo limanna taunna ma'parenta tomaraya Tiberius, attunna Pontius Pilatus mendadi gubernur dio Yudea, anna Herodes ummanda'i kaparentaan dio Galilea, attunna Filipus sirondongna Herodes ma'parenta dio Iturea sola dio Trakhonitis, attunna duka' Lisanias ummanda'i kaparentaan dio Abilene ");
INSERT INTO mqjNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","anna attunna Hanas sola Kayafas mendadi Pongkena Imam ma'kadami Puang Allata'alla lako Yohanes anakna Zakharia dio padang alla'. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Napolalan laomo Yohanes ullelean angganna angngenan dio lembangna Salu Yordan umpalanda' Kadanna Puang Allata'alla nakua: “Mengkatoba'mokoa' ammu ditedok anna malara nagarri'iangkoa' kasalaammu Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Susi mangka napayolo lamban nabi Yesaya illalan sura'na nakua: “Dengan tau metamba-tamba dio padang alla' nakua: ‘Patokanni lalan Dewata, maloloananni lalan la naola. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","La ditambunni angga mellembangna, anna dirantean angga mentanetena sola ma'buntunna, la dimaloloan angga sengko'na anna dipomarante ma'kaleok-leokna. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Angganna ma'rupa tau illalan lino la ummita kasalamasan lu yao mai Puang Allata'alla.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma'kada Yohanes lako tau buda to la sae ditedok nakua: “O anggammua' to kadake gau', benna ungkuangkoa' kumua la malakoa' nasala ara'na Puang Allata'alla la sae? ");
INSERT INTO mqjNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kenamala kembua mapiakoa' sitinti pa'palakomu mengkatoba'. Dau anna kendek illalan penawammua' kumua peampoannakoa' Abraham. Kupokadangkoa' sitonganna, inde mai batue mala napopendadi peampoanna Abraham Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tokami wase la dilellengan kayu tae' kembua mapia anna ditibe tama api.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nakuamo inde mai taue: “Akamo la kipogau'?” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Natimba' Yohanes nakua: “Benna-benna ummampui dua bayu, la nabeen to tae' ummampui bayu mesa. Anna benna-benna ummampui andean la natawa duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dengan duka' sae pira-pira tuang passima morai la ditedok, mekutana nakua: “O tuangguru, aka kami la kipogau'?” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Natimba' Yohanes nakua: “Dau pala'bii musinga' anna mangkanna dipatantu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mekutana duka' pira-pira tantara nakua: “Anna kami, aka kami la kipogau'?” Natimba' Yohanes nakua: “Dau tokke' ummala babang ewananna tau ke tangngia lalanna anna tae'koa' la umpaalinni kasalaan tau annu la nabaya'koa'. Pasiruaimia' kalemu passaromu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Attu iatoo mangngampa liumi anna parannu tau buda lako kasaeanna To dibassei bayu-bayu la ma'pasalama', napolalan kendek pekutana illalan penawanna kumua umbai iamo. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iamo too anna ma'kadamo Yohanes lako inde mai taue nakua: “Wai kao kutedokangkoa', sapo dako' la sae to marru ma'kuasa anna kaleku annu angga la kubukaianni pekapu' palopakna anna tae'na' sipato'. Inde taue Penawa Masero sola api la natedokangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sirapan to ma'tappi, tokami petappinna la napake ungkayoi gandumna anna mane annai tama talukunna. Mengke'de' tappianna napatama api tae' dengan leleanna la pi'de.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Budapi kada pa'nanna' natula' Yohanes attunna anna umpalanda' Kareba Kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sapo ungkambaroarria to ma'parenta dio lembangna Galilea iamo Herodes diona kasipobaineanna Herodias bainena sirondongna, anna diona angganna kakadakeanna, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","napolalan urrangnganni pole omo kakadakeanna Herodes annu untarungkun Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Marassanni untedok tau buda Yohanes, saemi duka' Puang Yesus anna ditedok. Mengei ma'sambayang Puang Yesus, titungka'mi langi' ");
INSERT INTO mqjNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","anna turun Penawa Masero merrupa dangan-dangan sae urrampoii. Dirangngimi kamara yao mai langi' nakua: “Ikomo anakku to kukamasei, to umpomasannang penawangku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Inde anna umparanduk pengkaranganna Puang Yesus-e, umbai tallu pulomo taunna. Anna situru' tula'na tau, Puang Yesus anakna Yusuf. Yusuf anakna Eli, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli anakna Matat, Matat anakna Lewi, Lewi anakna Malkhi, Malkhi anakna Yanai, Yanai anakna Yusuf, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf anakna Matica, Matica anakna Amos, Amos anakna Nahum, Nahum anakna Hesli, Hesli anakna Nagai, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai anakna Maat, Maat anakna Matica, Matica anakna Simei, Simei anakna Yosekh, Yosekh anakna Yoda, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda anakna Yohanan, Yohanan anakna Resa, Resa anakna Zerubabel, Zerubabel anakna Sealtiel, Sealtiel anakna Neri, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri anakna Malkhi, Malkhi anakna Adi, Adi anakna Kosam, Kosam anakna Elmadam, Elmadam anakna Er, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er anakna Yesua, Yesua anakna Eliezer, Eliezer anakna Yorim, Yorim anakna Matat, Matat anakna Lewi, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi anakna Simeon, Simeon anakna Yehuda, Yehuda anakna Yusuf, Yusuf anakna Yonam, Yonam anakna Elyakim, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim anakna Melea, Melea anakna Mina, Mina anakna Matata, Matata anakna Natan, Natan anakna Daud, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud anakna Isai, Isai anakna Obed, Obed anakna Boas, Boas anakna Salmon, Salmon anakna Nahason, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason anakna Aminadab, Aminadab anakna Admin, Admin anakna Arni, Arni anakna Hezron, Hezron anakna Peres, Peres anakna Yehuda, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda anakna Yakub, Yakub anakna Ishak, Ishak anakna Abraham, Abraham anakna Terah, Terah anakna Nahor, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor anakna Serug, Serug anakna Rehu, Rehu anakna Peleg, Peleg anakna Eber, Eber anakna Salmon, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon anakna Kenan, Kenan anakna Arpakhsad, Arpakhsad anakna Sem, Sem anakna Nuh, Nuh anakna Lamekh, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh anakna Metusalah, Metusalah anakna Henokh, Henokh anakna Yared, Yared anakna Mahalaleel, Mahalaleel anakna Kenan, ");
INSERT INTO mqjNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan anakna Enos, Enos anakna Set, Set anakna Adam, Adam anakna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Naluangmi Penawa Masero Puang Yesus anna tettei umpellei Salu Yordan lu lako padang alla'. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Torromi dio appa' tapulo bonginna nasudi ponggawana setang. Pempon saena lako padang alla', ta'mo dengan ummande napolalan tadea'mo. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma'kadami ponggawana setang lako Puang Yesus nakua: “Ianna Anakna tongangko Puang Allata'alla, suai inde mai batue mendadi roti!” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Natimba' Puang Yesus nakua: “Dengan tiuki' illalan Buku Masero nakua: ‘Tangngia angga roti la napotuo ma'rupa tau.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Umbawaimi Puang Yesus ponggawana setang langngan angngenan malangka' anna paitaii sappalli' angganna kaparentaan illalan lino, ");
INSERT INTO mqjNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","anna kuanni: “Angganna te mai kakuasaan sitonda kamatandeannae mangka asammi dipalessu' rokko lisu pala'ku. La kupalulakomi kalemu annu kao pawa benna la kubengan. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ianna mupenombaina' Iko asammo la ummampuii.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Natimba' Puang Yesus nakua: “Dengan tiuki' illalan Buku Masero nakua: ‘Penombaiko Puang Allata'alla Dewatammu anna angga ia la mupengkaolai.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mangkai, ussolammi Puang Yesus lako Yerusalem anna payaoi bubungan Banua Ada'na Puang Allata'alla anna kuanni: “Ianna Anakna tongangko Puang Allata'alla, dondonangko kalemu rokko ");
INSERT INTO mqjNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","annu dengan tiuki' illalan Buku Masero nakua: ‘La ussua malaeka'na Puang Allata'alla undagai manappako, ");
INSERT INTO mqjNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","anna natimangko diong napolalan tae' titumbu lentekmu lako batu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Natimba' Puang Yesus nakua: “Dengan duka' tiuki' illalan Buku Masero nakua: ‘Dau ammu sandak-sandak Puang Allata'alla Dewatammu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mangka asanni umpalako passudianna ponggawana setang, umpelleimi Puang Yesus anna ummampai attu maliwang. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nakuasaimi Penawa Masero Puang Yesus anna ma'pasule lako Galilea. Silelemi kareba diona pengkaranganna Puang Yesus dio lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ulleleammi banua pa'sambayanganna to Yahudi ma'pa'guru anna naporai angganna tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Mangkai too, lu lakomi Nazaret Puang Yesus, angngenan dingei umpakamaii. Nalambi'i allo katorroan, tamami banua pa'sambayanganna to Yahudi, susi beasa sinapogau'. Ke'de'mi illalan la umbaca Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dibengammi sura'na nabi Yesaya. Nabillangmi, napolalan ullambisan battakada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naluangna' Penawa Maserona Dewata, annu mangkamo' nabassei bayu-bayu la umpalanda' Kareba Kadoresan lako to mase-mase. Anna nasuana' umpa'peassakan kadirappanananna to disakka, kamalapusanna to buta, anna urrappanan to dianda'i onggo'-onggo'na, ");
INSERT INTO mqjNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","anna umpa'peassakan kumua nalambi'mi attunna la umpakawanan pa'kamasena Dewata lako ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ullulummi sule inde sura'e anna beenni lako to simengkarang illalan banua pa'sambayangan anna mane ma'loko. Nasinenne'-nenne'imi tau illalan pa'sambayangan. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naparandukmi ma'pa'guru Puang Yesus nakua: “Allo temo murangnginna inde battakadae lemba'mi issinna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Natula' mapia asammi tau anna mangnga-mangnga urrangngii annu maleke sambakan kadanna. Nakuamo inde mai taue: “Tangngiaka te anakna Yusuf-e?” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nakuamo Puang Yesus: “Innang la mupokada inde samparan kada lako kalekua'e kumua: ‘O tuandotto' pomalapu'ko kalemu, kalembasanna pogau'i duka' inde tondokmu tanda memangnga-mangnga kirangngi mangka mupogau' dio Kapernaum.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma'kada pole omi Puang Yesus nakua: “Kupokadangkoa' sitonganna, tae' dengan nabi diangga' dio tondokna. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Innang manassa te tula'kue: Attunna nabi Elia, dengan pissan attu kulla' allo tallu taun annan bulanna lambisan kendek karorian salembang Israel. Buda baine balu dio Israel attu iatoo ");
INSERT INTO mqjNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","sapo ta'ra ia disua Elia lao umpellambi'i mesa baine balu dio Israel, sangngadinna disua lao umpellambi'i baine balu dio Sarfat, illalan lembangna Sidon. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Susi toi duka' anna attunna nabi Elisa, buda to dolengan dio Israel tae' duka' dengan moi mesamo napomalapu' salianna Naaman to lu dio mai Siria.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Urrangnginna tula'na Puang Yesus, keara' asammi tau illalan inde pa'sambayanganne. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ke'de' asammi anna urrambai Puang Yesus lako salian tondok anna baai lako palimping dio sa'de tondok la nasulunan rokko. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sapo umpa'tangngai tau buda Puang Yesus anna le'ba umpelleii. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mangkai too, le'bami Puang Yesus rokko kota Kapernaum dio Galilea anna umpa'guru tau ke nalambi' omi allo katorroan. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mangnga-mangnga asan tau urrangngi pepa'guruanna annu sitonda kakuasaan tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Illalan inde pa'sambayanganne dengan mesa to natamai setang. Inde taue meoli-oli nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesus to Nazaret, la muakakanni? La saerokoka untallannikan? Kuissanan kumua To Maseroko lu yao mai Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sapo tappa nasadangngi Puang Yesus nakua: “Kamma'ko, mallaiko illalan mai kalena itin tauo.” Umpessambakammi inde tau rokko litak illalan alla'-alla'na tau budae anna mane mallai sapo tae' sia nasanggangngi. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mangnga-mangnga asammi tau, napolalan sipantula'-tula' nakua: “Battakada akamoa' te sanganna anna mala ussua lao setangnge? Inde battakadae sitonda kakuasaan anna kamatoroan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Silelemi kareba diona pengkaranganna Puang Yesus dio lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mangkai too, suummi Puang Yesus illalan mai banua pa'sambayangan anna le'ba lako banuanna Simon. Attu iatoo makula' matukanna Simon baine. Napelaumi to dio reen lako Puang Yesus kenamala napomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Leba'mi lako sa'de mammasanna inde bainee ke'de' anna suai lao sakinna. Monda siami sakinna napolalan millik anna untarakanni to saena. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lendu'i allo, sasaeammi tau pantan ussolaan to masaki, ma'rupa-rupa sakinna. Narisimi Puang Yesus naanda'i lambisan malapu' asan. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Susi duka' to natamai setang, mallai asan setang illalan mai kalena napasiolaan kumillong-killong nakua: “Anakna tongangko Puang Allata'alla!” Sapo nasadangngi Puang Yesus anna tae' napabeai mantula' annu naissanan asammi kumua To dibassei bayu-bayu la ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Masiangna mengkalaomi Puang Yesus lako mesa angngenan maitu-itu. Sapo nasipeang-peangngi tau buda napolalan nalambi'. Umpeangmi lalan anna malara tae' napellei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sapo ma'kada Puang Yesus nakua: “Kareba Kadoresan diona kaparentaanna Puang Allata'alla innang la kupalanda' duka' lako tondok senga' annu iamo nangei ussuana' Puang Allata'alla tama lino.” ");
INSERT INTO mqjNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ulleleammi pa'sambayanganna to Yahudi Puang Yesus dio lembangna Yudea ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pissan attu ke'de' Puang Yesus dio biring Tasik Genesaret ma'pa'guru. Ma'silullu'mi tau sae la umperangngii battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ummitami dua lopi dio biring tasik lo'bang, annu marassan umbasei dalana puangna. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Langngammi mesa lopi, lopinna Simon anna ussua Simon umbussunni tama tasik titti'. Ma'lokomi yao inde lopie anna umpa'guru tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mangkai ma'pa'guru, ma'kadami lako Simon nakua: “Palutamai mandalanna tasik lopimmu ammu madala mupolalan ummala be'dok.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Natimba' Simon nakua: “Sabongimi kipetonganni mengkarang, tae' dengan aka kilolongan. Sapo Iko ussuana', dadi la lao polepa' madala.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Napalako tongammi, napolalan buda be'dok naala lambisan napollo'mo sesse' dalana. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ungka'bi'mi solana dio lopi senga' anna sae umpamoloii. Saei solana, ummissiimi inde dua lopi saponnonae napolalan ambo' titti' tallan. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tappana naita Simon Petrus, malimuntu' siami dio tingngayona Puang Yesus anna ma'kada nakua: “O Dewata, pelleina' lao annu to kasalaanna'!” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Annu mangnga-mangnga tongan Simon sola angganna to nasolaan ummita inde budanna be'dok naalae. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mangnga-mangnga duka' solana Simon disanga Yakobus anna Yohanes, bassi anakna Zebedeus. Nakuamo Puang Yesus lako Simon: “Dau marea'! Mengkalao temo rupa taumo la mudala.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Umpalangngammi gantanan lopinna sola solana anna untampe porewana le'ba unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pissan attu, illalan mesa kota Puang Yesus, saemi duka' mesa to nakabu' doleng kalena. Tappana ummita Puang Yesus, sae siami napellambi'i anna malimuntu' dio tingngayona anna mengkarumase-mase melau nakua: “O Tuang, kuissanan kumua malana' mupomalapu' ke moraiko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ummanda'imi inde taue napasiolaan ma'kada nakua: “Moraina', malapu'moko!” Monda siami sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Napakari'di'mi Puang Yesus kumua tae' la napokada lako tau inde kara-karae. Nakuammi Puang Yesus: “Laomoko umpa'paitaan kalemu lako imam ammu baa bua pemala'mu situru' pepa'guruanna Musa la napotanda lako tau buda kumua malapu'moko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sapo tuttuan sileleria kareba diona pengkaranganna Puang Yesus napolalan buda tau sae la umperangngii pepa'guruanna anna la dipomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Moi anna susimo too, sapo sibassa'pi ullessusan kalena Puang Yesus anna le'ba lako angngenan maitu-itu ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pissan attu anna marassan ma'pa'guru Puang Yesus, dio duka' reen pira-pira to Farisi anna to untarru' issinna sura'na Musa. Inde mai taue pantan sae dio mai Yerusalem, dio mai angganna tondok dio lembangna Galilea anna lembangna Yudea. Dengan kakuasaanna Puang Allata'alla illalan kalena Puang Yesus napolalan mala umpomalapu' to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Saemi pira-pira tau umbulle mesa to balimbingan mamma' dio ampa'na. Umpeangmi lalan la tama banua umbaa inde to masaki lako tingngayona Puang Yesus-e. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sapo tae' dengan naola annu nalawai tau buda napolalan lu langngammo papa anna so'boi rokko sipatunna Puang Yesus anna mane lolloranni sitonda ampa'na rokko tingngayona Puang Yesus illalan alla'-alla'na tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Inde anna itami Puang Yesus kapangngoreanannae, ma'kadami lako inde to balimbinganne nakua: “Digarri'imi kasalaammu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nakuamo illalan penawanna inde to Farisi anna to untarru' issinna sura'na Musae: “Bennara inde taue? Maakaria anna barani untelle Puang Allata'alla? Tae' dengan tau mala unggarri'i kasalaan, mesa-mesanna Puang Allata'alla!” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sapo nalosa Puang Yesus tama penawanna lambisan ma'kada nakua: “Maakari anna kendek pekutana susi illalan penawammua'? ");
INSERT INTO mqjNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Umbanna la madommi' dikua lako inde taue: ‘Digarri'iammoko kasalaammu,’ anna la dikuanni: ‘Millikko ammu menono'?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sapo la kupaitaikoa' temo kumua ma'kuasa Anak Mentolino unggarri'i kasalaan illalan inde linoe.” Anna mane ma'kada lako inde to balimbinganne nakua: “Millikko, alai ampa'mu ammu sule lako banuammu!” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Millik siami inde to masaki naita tau budae, anna ummala ampa'na anna mane le'ba sule lako banuanna napasiolaan umpakasalle Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mangnga-mangnga asammi tau anna umpakasalle Puang Allata'alla, sapo marea' toi duka' napolalan ma'kada nakua: “Memangnga-mangnga tongan inde kadadian taita allo temoa'e.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mangkai too, suummi Puang Yesus, ummitami mesa tuang passima disanga Lewi ma'loko-loko illalan kantoro'na. Napa'kadaimi Puang Yesus nakua: “Maiko ammu turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ke'de' siami Lewi anna umpellei angganna aka-akanna le'ba unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Umpadadimi mesa rame-rame Lewi dio banuanna la umpakasalle Puang Yesus. Sasaeammi tuang passima sola tau senga' nasolaan ummande. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sapo tae' masannang to Farisi sola to untarru' issinna sura'na Musa ummitai lambisan ma'kada lako passikolana Puang Yesus nakua: “Maakari ammu ummandea' sola tuang passima anna to kasalaan?” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Natimba' Puang Yesus nakua: “Tangngia to malapu' umparallui tuandotto', sapo to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tangngia Kao to malolo sae kutambai sapo to kasalaan anna malara mengkatoba'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mangkai too, ma'kadami pira-pira tau lako Puang Yesus nakua: “Sibassa' ia ma'puasa passikolana Yohanes anna ma'sambayang. Susi toi duka' passikolana to Farisi. Sapo passikolamu Iko siummande liu sola ummiru', tae' dengan ma'puasa.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Natimba' Puang Yesus ummala mesa pa'rapanan nakua: “La malarika disua ma'puasa to ullomba pa'sombaan ke diopi reen to mane dipakebaine? Manassa anna tae'! ");
INSERT INTO mqjNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sapo la dengan attunna inde to mane dipakebainee la dialai illalan mai alla'-alla'na to ullombai. Attu iamo too anna mane ma'puasa.” ");
INSERT INTO mqjNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ummala polemi mesa pa'rapanan senga' nakua: “Tae' dengan tau la ussesse'i bayu bakaru anna mane tampisanni bayu malusa. Annu la situmang babang, sesse' inde bayu bakarue, tae' toi duka' la mapia diita bayu malusa ditampi' sampin bakaru. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tae' toi duka' dengan tau ummala anggur bakaru anna patamai pa'pengngean malusa. Annu inde anggur bakarue la untessean pa'pengngean malusa. Katampakanna bassi masala susi anggurna tenni pa'pengngeanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dadi, anggur bakaru manggi' dipalutama pa'pengngean bakaru. ");
INSERT INTO mqjNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tae' dengan tau ma'din ummiru' anggur bakaru ke mangkai ummiru' anggur masaemo. Annu nakua: ‘Marru mammi' ia anggur masaemo.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pissan attu, sirupang allo katorroan umpa'tangngai bela' gandum Puang Yesus sola passikolana. Marassanni menono' napasiolaan siami ummala gandum passikolana anna kuli'i anna mane andei. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dengan pira-pira to Farisi mekutana nakua: “Maakari ammu pogau' tala malanna dikarang ke allo katorroan?” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Natimba' Puang Yesus nakua: “Ta'paka iko dengan mubaca diona pa'palakona Daud sola to unturu'i anna tadea'? ");
INSERT INTO mqjNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Attu iatoo lu tama angngenan kapemalasan Daud anna ummala roti mangka dipopemala' langngan Puang Allata'alla anna andei anna mane beenni lako to unturu'i, moika anna angga imam mala ummandei.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nakua pole omo Puang Yesus: “Anak Mentolinomo puangna allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pissan attu nalambi' omi allo katorroan. Tamami pa'sambayanganna to Yahudi Puang Yesus ma'pa'guru. Illalan inde pa'sambayanganne dengan mesa tau mate lima kananna. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dio duka' reen pira-pira to untarru' issinna sura'na Musa sola to Farisi. Umpalao mata liumi Puang Yesus annu nakua illalan penawanna umba ke tokke'i umpomalapu' to masaki ke allo katorroan anna malara dengan lalan umpaalinni kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sapo naissanan Puang Yesus pikki'na napolalan ma'kada lako inde to mate limanna sabalie, nakua: “Maiko ammu ke'de' illalan inde alla'-alla'e.” Le'ba siami tama alla'-alla'na tau buda anna ke'de' illalan. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma'kadami Puang Yesus lako tau buda nakua: “Dengan la kupekutanaan: Situru' atoran aluk, umbanna mala dipogau' ke allo katorroan, kamapiaarraka kakadakearraka? La umpesangkairiki'ka solata la dipateirika?” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Umpalelemi matanna Puang Yesus lako tau buda, anna mane ma'kada lako inde to mate limanna sabalie nakua: “Ette'i limammu!” Naette'mi, tappa malapu' siami. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Keara' asammi inde mai to untarru' issinna sura'na Musa sola to Farisie. Sipantula'-tula'mi umpokada aka la napogau' lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mangkai too, lu langngammi tanete Puang Yesus annu la ma'sambayang. Napesabongimi yao ma'sambayang langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Masiangngi, untambaimi angganna passikolana anna pileii sapulo dua to la mendadi rasulna. Inde to napilee iamo: ");
INSERT INTO mqjNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon sinasangai Petrus, Andreas sirondongna Simon, Yakobus, Yohanes, Filipus, Bartolomeus, ");
INSERT INTO mqjNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus anakna Alfeus, Simon to nakala' kombongan Zelot, ");
INSERT INTO mqjNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas anakna Yakobus, anna Yudas Iskariot to la umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mangkaii, ma'pasulemi Puang Yesus sola rasulna yao mai inde tanetee lu rokko merrantena. Saei rokko, ullambi'mi passikolana ma'rempun anna buda tau senga' nasolaan to lu dio mai lembangna Yudea anna to yao mai Yerusalem, anna to lu dio mai kota dio biring tasik iamo Tirus anna kota Sidon. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inde mai taue sae la umperangngii Puang Yesus anna morai la napomalapu'. Dengan duka' to natamai setang sae napomalapu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Morai asammi la urrumbu Puang Yesus annu dengan kakuasaan suun illalan mai kalena umpomalapu'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Unnenne'imi passikolana Puang Yesus anna ma'kada nakua: “Kerongko'koa' anggammu to mase-mase, annu ikomoa' petauanna Puang Allata'alla illalan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kerongko'koa' anggammu to tadea' temo, annu la dipedea'ikoa'. Kerongko'koa' anggammu to tumangi' temo annu la metawakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kerongko'koa' anggammu to dikabassi, to tae' ditarima, to ditula' kadake, anna to disumbala annu diangga' to kadake ura'na unturu'koa' Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Annu susimi duka' naduppa nabi yolona nadarra nenena to ungkabassikoa' temo. La dore'koa' ammu sumayo ke nalambi'koa' kara-kara iatoo annu kamai saromua' yao suruga. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sapo la sanggangkoa' anggammu tomakaka temo, annu ussa'dingammokoa' kamasannangan. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","La sanggangkoa' anggammu to dea'mo temo annu la tade'koa' ke dako'. La sanggangkoa' anggammu to metawa temo annu la ma'pote bolongkoa' sola tumangi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","La sanggangkoa' anggammu to natede tau annu susimi duka' napogau' nenena to untedekoa' lako to ussanga kalena nabi.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sapo lako ikoa' to urrangngi tula'ku temo, kupelau matin: Kamaseikoa' ewalimmu, ma'gau' mapiakoa' lako to ungkabassikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pelauanni tamba' to untadokoa', pa'sambayanganni to ma'gau' kadake lako kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ianna dengan tau untampiling papomu sabali, tananan polei sabalinna. Ianna dengan tau tokke' ummala bayu rui'mu, bengan polei bayummu. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ianna dengan tau umpelau aka-akammu, beenni. Ianna dengan tau urrappa aka-akammu dau pelaui sule. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iamo muporai la napogau' tau lako kalemu, iamo mupogau' lako. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ianna anggamo to ungkamaseiko mukamasei tae' dengan lalammu la disaroi. Annu to kadake gau' duka' anna ungkamasei to ungkamaseii. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ianna anggamo to ma'gau' mapia lako kalemu mungei ma'gau' mapia, tae' dengan lalammu la disaroi. Annu to kadake gau' duka' anna ma'gau' susi. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ianna anggamo to la nabela umpasule doi'mu mupaindanni, tae' dengan lalammu la disaroi. Annu to kadake gau' duka' anna sipaindan-indanni annu la nabela napasule. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sapo la ungkamaseikoa' iko ewalimmu ammu ma'gau' mapia lako. La umbengangkoa' pangngindanan tau anna tae' la murannuan sulena. Ianna susimo too, la kamai saromua' anna la manassamo kumua anaknamokoa' Puang Allata'alla to randan matande annu to mapia penawa lako to tanaissan ma'kurru' sumanga' sola lako to kadake. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Iamo too la mamasekoa' susi Ambemu sumpu mamase.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Daua' tokke' umpasala padammu, indana pasalakoa' duka' Puang Allata'alla. Daua' umpabambanni sangka' padammu indana pabambannikoa' duka' sangka' Puang Allata'alla. Garri'ikoa' kasalaanna padammu anna garri'iangkoa' duka' kasalaammu Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma'petandokoa' lako padammu anna tandoikoa' duka' Puang Allata'alla. Dengan sukasan randan mapia la dipassuka'iangkoa', la didodak anna mane dipede' saponnona lambisan lempan lao la dibengangkoa'. Annu inde sukasan mupake lako padammue iamo duka' dipassuka'iangko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Anna mane ummala mesa pa'rapanan Puang Yesus nakua: “Ianna to butamo untette to buta bassi la metobang rokko garotin. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tae' dengan leleanna la tanda langnganan passikola anna tuanggurunna. Sapo ianna tamma'mo passikola pada rantemi tuanggurunna. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Maakari ammu ummita polinna solamu pada nennu' anna tae'ko iko la ussa'ding bulissak illalan matammu? ");
INSERT INTO mqjNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Umbamo la mukua ma'kada lako solamu: ‘Maiko angku alaiangko polimmu pada nennu',’ anna bulissak iko illalan matammu tae' musa'ding? O to ma'dua tambuk, alai yolo bulissak illalan mai matammu anna malara muita ummalaian polinna solamu pada nennu'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Tae' dengan kayu mapia la ungkembuaan bua kadake, battu' kayu kadake la ungkembuaan bua mapia. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Annu' simesa-mesa to' kayu mala diissanan ke diitami buana. Ta'pa dengan tau ummala bua ara dio mai to' kayu ma'duri battu bua anggur naala dio mai to' duri. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Susimi duka' lako ma'rupa tau. Angganna to mapia penawa, angga mapianna suun dio pudukna annu mengkalao illalan penawanna mapia. Sapo lako to kadake, angga kadakena suun dio pudukna annu mengkalao illalan penawanna kadake. Annu iamo illalan penawa iamo lemba' dio puduk.” ");
INSERT INTO mqjNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Maakari ammu kua lako kalekua': ‘O Dewata, O Dewata’, moi kenada tae'koa' unturu' tula'ku? ");
INSERT INTO mqjNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aka la dipasiundusan to sae umperangngii tula'ku anna palakoi? Perangngii angku tulasangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Inde mai taue dipasirapan to la mebanua. Nakalimi rokko saullambi'na batu anna mane pa'pake'de'i banuanna. Tapakala sae wai buda unta'dulan inde banuae tae' nabela songka annu matoto'. ");
INSERT INTO mqjNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sapo lako to urrangngi tula'ku anna tae' napalako, dipasirapan to umpake'de' banua dio litak tae' nabatui. Saei wai unta'dulanni roppok siami anna pokak-pokak.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mangkai umpokada inde mai kara-kara Puang Yesus lako tau budae, lu lakomi Kapernaum. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dio inde tondokke, dengan ponggawana tantara Roma ummampui sabua' anna naangga' tongan-tongan. Attu iatoo masanta' inde sabua'nae lambisan ambo' titti' bonno'. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tappana urrangngi karebana Puang Yesus, ussuami perepi'na to Yahudi lao umpellambi'i anna pelaui kenamala sae umpomalapu' inde sabua'nae. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Silambi'i Puang Yesus, mengkarumase-masemi melau lako nakua: “La sipato' mukamasei inde ponggawana tantarae, ");
INSERT INTO mqjNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","annu ungkamasei tongan-tongan to Yahudi anna mangkamokan napake'desan banua pa'sambayangan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mengkalaomi Puang Yesus sola inde to sae untambaie. La ullambi' kalei banuanna ponggawana tantara Puang Yesus, ussuami solana inde ponggawana tantarae lao umpalandasanni tula'na lako Puang Yesus nakua: “O Tuang, daumo ussussai kalemu tarru' lako banuangku, annu tae'na' sipato' mupellambi'i dio banuangku, ");
INSERT INTO mqjNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","iamo too anna tae'na' duka' barani lao umpellambi'iko. Sapo pokada mammi sabatta kada, la malapu'mi to sabua'kuo. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Annu to diparentana' duka' tee anna pira-pira toi duka' tantara kupatandarokkoan. Ianna kukua lako mesa tantara: ‘Mengkalaoko,’ le'ba siami. Anna lako senga'na kukua: ‘Maiko,’ sae siami; battu lakoraka sabua'ku kukua: ‘Karangngi indee,’ nakarang siami.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mangnga-mangngami Puang Yesus urrangnginna tula'na inde taue. Menggirikmi unnenne'i tau buda ummula'i anna ma'kada nakua: “Kupokadangkoa', ta'pa dengan kulambi' nasusian kapangngoreananna inde taue moi to Israel.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sulei lako banua inde mai to disuae, malapu'mi inde sabua'e. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tae' masae mangkanna, le'bami Puang Yesus sola passikolana lako mesa kota disanga Nain, anna budapa tau senga' ma'karompo' ummula'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","La ullambi'i ba'ba kota, sitammumi to lao umbaa to mate. Inde to matee anak muanemi, anak mesa, balu polepi indona. Buda to ma'tondok unturu' inde baine balue. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Rantang siami buana Puang Yesus ummita inde baine balue. Nakuamo lako: “Dau tumangi'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Umpengkadappi'imi bullean anna anda'i. Torromi duka' to ma'bulle. Nakuamo Puang Yesus: “O anak muane, kukua matin, millikko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Membangun siami inde taue anna ma'loko mantula'. Anna mane palessu' rokkoi lisu pala'na indona. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Marea' asammi inde mai taue anna umpakasalle Puang Allata'alla nakua: “Mesa nabi kamai kendek illalan alla'-alla'ta! Saemi Puang Allata'alla umpasalama' petauanna!” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Silelemi kareba illalan lili'na Yudea anna lako angngenan sapanambena diona kara-kara napogau' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Urrangnginna kareba Yohanes to simantedok dio mai passikolana diona pengkaranganna Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","untambaimi dua passikolana anna suai lao mekutana lako Puang Yesus kumua: “Ikomoka to la sae situru' pa'dandinna Puang Allata'alla, dengampika tau senga' la kiampai?” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ullambi'i Puang Yesus inde dua passikolana Yohanes-e, nakuamo: “Nasuakan Yohanes to simantedok sae mekutana lako kalemu kumua: ‘Ikomoka to la sae situru' pa'dandinna Puang Allata'alla, dengampika tau senga' la kiampai?’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Attu iatoo buda to masaki napomalapu' Puang Yesus anna urrambai setang illalan mai kalena tau anna buda to buta napomalapu' lambisan mala paita. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Natimba'mi Puang Yesus nakua: “Sulemokoa' ammu tulasanni Yohanes angga muitanna anna murangnginna: To buta malami paita, to balimbingan malami menono', to dolengan monda dolengna, to taru mala parangngi, to mate mala tuo sule, anna to mase-mase urrangngi Kareba Kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kerongko' angganna to tae' tikanna penawanna ummitana'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Le'bai pesuanna Yohanes to simantedok, mantula' omi Puang Yesus lako tau buda untula' Yohanes nakua: “Aka lao mutungkaa' lako padang alla'? Laorokoka umpetua' to' tille napalurekke lu sau' bara'? ");
INSERT INTO mqjNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aka lao mupetua' lakoa'i? Laorokoka umpetua' to ma'pakean maleke? Dio ia banuanna tomaraya nangei to ma'pakean maleke anna to natambunni ewanan. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dadi aka lao mukarang lakoa'i? Laorokoka umpetua' nabi? Tonganna, anna nasanga Kao kadangku tanda langnganna nabi. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Annu Yohanesmo napatu battakadanna Puang Allata'alla nakua: ‘Indemi pesuangkue, kusuami uyyoloanangko, anna iamo la umpatokangko lalan la muola.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kupokadangkoa' sitonganna, mengkalao dio mai ta'pa dengan rupa tau illalan lino la untondon Yohanes to simantedok. Sapo natondon to nakala' kaparentaanna Puang Allata'alla moi randan wiring rokkonamo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Angganna to urrangngi tula'na Puang Yesus sae lako tuang passima untonganan asammi pa'kuanna Puang Allata'alla annu mangkami natedok Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sapo inde mai to Farisi sola to untarru' issinna sura'na Musae ussumbala asan pa'kuanna Puang Allata'alla lako kalena, annu moka natedok Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma'kada pole omi Puang Yesus nakua: “Akamo la kupasirapanan ma'rupa tau lapik temo anna akamo la kupasiundusanni? ");
INSERT INTO mqjNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inde mai taue la kupasirapan anak pantan ma'kombong-kombong ma'loko dio pasa' anna sialo'-alo' nakua: ‘Kipa'tulaliangkoa' sapo mokakoa' sumayo. Umbatingkan sapo mokakoa' tumangi'.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Annu sae Yohanes to simantedok bassa' sima'puasa anna tae' siummiru' anggur, musangaia': ‘To natamai setang.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tapakala sae duka' Anak Mentolino, siummande anna ummiru' anggur, mukuaa': ‘Petua'ria', poppokan, pangngiru', solana tuang passima anna to kasalaan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sapo moika anna susimo too kakeakasanna Puang Allata'alla innang la kawanan ummolai panggauanna angganna to unturu'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dengan mesa to Farisi disanga Simon, untambai Puang Yesus lako banuanna ummande. Saemi Puang Yesus dio banuanna anna ma'loko ummande. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dio inde kotae, dengan mesa baine, to kaissanan kumua to kasalaan. Narangnginna kumua marassan ummande Puang Yesus dio banuanna inde to Farisie, laomi napellambi'i umbaa mesa buli-buli batu kaissi minna'-minna'. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Lu lakomi boko'na Puang Yesus anna ke'de' dio sa'de lentekna napasiolaan tumangi' napolalan bossik lentekna Puang Yesus napobua' wai matanna. Napassimi beluakna anna udungngi anna mane bolloii minna'-minna'. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tappana naita inde to Farisi to untambai Puang Yesus-e, nakuamo illalan penawanna: “Ianna nabi tongan tee, la ummissanan inde baine urrumbuie anna la naissanan toi kumua to kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma'kadami Puang Yesus lako nakua: “O Simon, dengan la kukutanaiangko.” Natimba' Simon nakua: “Akamo la mukutanaianna', tuangguru?” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nakuamo Puang Yesus: “Dengan dua tau ma'indan lako mesa to siumpa'peindanan doi'na. Mesa ma'indan lima ratu' pera', mesa lima pulo pera'. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sapo bassi tae' nabela nabaya' napolalan napa'dean babangmo indanna to nangei ma'indan. Umbannamo randan la ungkamasei to ma'peindan?” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Natimba' Simon nakua: “Umbai inde to randan buda indannae.” Nakuamo Puang Yesus: “Narua petimba'mu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Unnenne'imi inde bainee napasiolaan ma'kada lako Simon nakua: “Muitaka inde bainee? Saenakkao inde banuammu, tae'na' mupatokaan wai la kupembase. Sapo inde bainee wai matannamo nabaseian lentekku anna mane passii beluakna. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tae'nakkao dengan muudung angku mane sae, sapo inde bainee saena inde banuammu ta'mo dengan urrappanan lentekku naudung. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tae'nakkao dengan muminnakkian ulungku, sapo inde ia bainee lentekku nabolloi minna'-minna'. ");
INSERT INTO mqjNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dadi kutulasangko sitonganna, buda pa'kamase napogau' inde bainee, iamo umpakawananni kumua budami kasalaanna digarri'i. Ianna titti' kasalaanna tau digarri'i, titti' duka' pa'kamase napogau'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Anna mane ma'kada lako inde bainee nakua: “Digarri'iammoko kasalaammu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sipantula'-tula'mi to nasolaan ummande Puang Yesus nakua: “Benna tappa'ra inde taue anna mala ia unggarri'i kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sapo ma'kada Puang Yesus lako inde bainee nakua: “Dipasalama'moko ura'na kapangngoreanammu. Laomoko anna la tontongko siayun kamasakkean.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tae' masae mangkanna, mengkalaomi Puang Yesus sola sapulo dua passikolana ullelean tondok umpalanda' Kareba Kadoresan diona kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dengan duka' pira-pira baine nasolaan, iamo to mangka narambaian setang illalan mai kalena anna to mangka napomalapu' dio mai ma'rupa-rupa saki, susinna: Maria sidisangai duka' Magdalena to mangka narambaian pitu setang illalan mai kalena, ");
INSERT INTO mqjNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana bainena to ummato' pengkarangan illalan banuanna Herodes disanga Khuza, Susana, anna budapa baine senga' nasolaan. Inde mai bainee ewananna napake umpamoloi Puang Yesus sola angganna passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Buda liumi tau sae dio mai tondok-ma'tondok umpellambi'i Puang Yesus. Mantula'mi Puang Yesus ummoyong mesa tandengan, nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dengan mesa tau lao mangngambo'. Inde banne naambo'e, dengan tappa lako lalan lambisan naressakki tau anna naande dassi sapuranna. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dengan tappa lako litak mabatu. Tuomi, sapo tae' masae anna malayumo annu marekko' litakna. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dengan tappa lako to' kurra ma'duri. Tuomi sola inde to' durie sapo tae' masae tuo annu tuttuan marumbo to' duri ungkabu'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Dengan toi duka' tappa lako litak malunak. Marumbomi tuona napolalan kembua tiluppi' pessaratu'.” Mangkai natetteran, nakuamo Puang Yesus: “Kenamala mupatananni manappa talinga inde tula'kua'e.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mekutanami passikolana nakua: “Aka kalembasanna inde tandenganne?” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Natimba' Puang Yesus nakua: “Iko mandia' dipabeai ummissanan tula' dibuni diona kaparentaanna Puang Allata'alla. Sapo ditula' tandengan lako tau senga' anna malara: ‘naita sapo tae' natamai akkalanna, narangngi sapo tae' napekalembasan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Susi inde kalembasanna tandengan angngena'e: Banne, iamo battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Banne tappa lako lalan, sirapan to urrangngi battakadanna Puang Allata'alla sapo narappai siami ponggawana setang illalan mai penawanna anna malara tae' mangngorean anna tae' dipasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Banne tappa lako litak mabatu, sirapan to urrangngi battakadanna Puang Allata'alla anna tappa natarima sitonda kadoresan, sapo tae' kenwaka' illalan penawanna. Tae' masae mangngorean, ianna nalambi'mo passudian memboko'mi. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Banne tappa lako to' kurra ma'duri, sirapan to urrangngi battakadanna Puang Allata'alla sapo malallan umpikki' katuoanna illalan lino anna anggamo ewanan anna kamasannangan illalan lino napasalui penawa napolalan tae' kembua mapia. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Banne tappa lako litak malunak, sirapan to mapia penawa anna to malolo urrangngi battakadanna Puang Allata'alla anna paillalan penawai, tontong matutu napolalan kembua mapia.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tae' dengan tau umpau' ballo anna mane samboii baka battu' napadiong wi' mammasan. Sapo napayao innang angngenanna anna malara naita pangngarrangna to tama banua. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tae' dengan tibuninna tae' la dipakawanan anna angganna dipomatimminna la dipa'peissanan anna dipa'peassakan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Iamo too, pengkalesoi manappaia' umba mukua umperangngii battakadanna Puang Allata'alla. Annu benna-benna umpaillan penawai la dirangngannian pole kapaissanan, sapo benna-benna tae' umpaillan penawai la dialai pissan kapaissanan nasanga dengammo illalan kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Saemi indona sola sirondongna Puang Yesus la umpellambi'i, sapo tae' naissan silambi' annu nalawai tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Natulasammi tau nakua: “O Tuangguru, illalan salian indomu sola sirondongmu umpeangko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sapo natimba' Puang Yesus nakua: “Benna-benna umperangngii battakadanna Puang Allata'alla anna pogau'i illalan salu katuoanna, iamo indoku anna sirondongku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pissan attu langngammi lopi Puang Yesus sola passikolana. Nakuamo lako passikolana: “La lu liangkia' biring tasik tandai lian.” Mengkalao siami. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Marassanni menono' lopinna, mamma'mi Puang Yesus. Tokke'mi sae talimpuru' kamai illalan inde tasikke lambisan natamai wai lopinna, napolalan titti' tallan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Untundammi Puang Yesus passikola nakua: “O Tuangguru, o Tuangguru, la tallammikia'!” Millikmi Puang Yesus anna ussadangngi talimpuru' sola bombang, tappa monda siami napolalan mattan duka' tasik. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma'kadami Puang Yesus lako passikolana nakua: “Maakari anna pa'demo kapangngoreanammua' lako kaleku?” Marea' asammi passikolana anna mangnga-mangnga napolalan sipantula'-tula' nakua: “Benna tappa'ra inde taue anna sae lako talimpuru' sola wai mala naparenta?” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tarru'mi lopinna Puang Yesus sola passikolana, napolalan sore sambali' Gerasa, lianna Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Saei langngan gantanan Puang Yesus, tappa natammuimi mesa muane to natamai setang, to lu dio mai inde tondokke. Inde taue masaemi tae' naaku ma'pake anna tae' naaku torro illalan banua sapo torro lakomi liang. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tappana ummita Puang Yesus, mealo' siami anna malimuntu' dio tingngayona, napasiolaan ma'kada nakua: “O Yesus, Anakna Puang Allata'alla to randan matande, aka la mupogau' lako kaleku? Kupelau matin kenamala tae'na' la mudarra.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ia nangei ma'kada susi annu ussuami setang Puang Yesus mallai illalan mai kalena. Inde setangnge sinagantan kendek illalan kalena inde taue napolalan sinapungomi rante bassi tau la naola undagaii sapo sinakattu-kattu liu anna mane bawaii setang lako padang alla'. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mekutanami Puang Yesus lako nakua: “Aka sangammu?” Natimba' nakua: “Disangana' Legion,” annu buda setang untamaii. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mengkarumase-masemi lako Puang Yesus melau, kenamala tae' nasua rokko garotin mandalan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dio sikadappi' inde angngenanne, buda bai marassan menduruk lako pili' tanete. Napelaumi lako Puang Yesus kenamala napabeai untamai inde lako baie. Naporanammi Puang Yesus pelaunna. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Suun siami illalan mai kalena inde taue anna untamai bai marassan menduruk. Sikakondong siami inde baie anna untibe kalena rokko palimping tappa dio tasik napolalan bonno' asan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Naitanna to undagai bai kadadian iatoo, tappa le'ba siami sikakondong umpa'paissananni lako to ma'tondok anna lako to ma'leanan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Sale'bammi tau lao umpetua'i. Ullambi'i Puang Yesus, ummitami inde to mangka natamai setangnge ummokko' dio sa'de lentekna Puang Yesus anna ma'pakemo pole' annu malinomi, napolalan marea' asan. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Natetterammi to melolo ummitai lako inde mai taue umba nakua dipomalapu' inde to natamai setangnge. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Napelaumi lako Puang Yesus to dio lembangna Gerasa kenamala untampe inde tondokke annu marea' asan tau dio. Langngammi lopi Puang Yesus anna ma'pasule. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Napelaumi duka' inde to mallaimo setang illalan mai kalenae kenamala napabeai ummula' Puang Yesus. Sapo nasua le'ba Puang Yesus, nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Sulemoko ammu tetteranni lako tau angga mangkanna napogau' Puang Allata'alla lako kalemu.” Le'bami duka' inde taue anna lao ullelean angngenan illalan tondok umpalanda' angga mangkanna napogau' Puang Yesus lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sulei Puang Yesus sambali' mai Gerasa, budami tau untammuii annu innang naampaimi. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Saemi duka' mesa perepi' illalan banua pa'sambayanganna to Yahudi dio tondok iatoo, disanga Yairus. Malimuntu'mi dio tingngayona Puang Yesus anna mengkarumase-mase melau kenamala lao siapa lako banuanna, ");
INSERT INTO mqjNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","annu masanta' anakna, baine umbai la sapulo duamo taunna, anak mesa polepi. Ummolai lalan Puang Yesus lako banuanna Yairus, nasisippi'imi tau buda unturu'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Illalan alla'-alla'na inde tau budae dengan mesa baine sapulo duami taunna ussa'dingan saki baine, anna tae' dengan tau mala umpomalapu'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Umpengkadappi'imi Puang Yesus lu dio mai boko'na anna rumbui tampak bayu rui'na, tappa monda siami sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma'kadami Puang Yesus nakua: “Bennakoa' urrumbuna'?” Sapo tae' dengan tau mangngaku. Nakuamo Petrus: “O tuangguru, buda tau ungkarompo'ko anna nasisippi'iko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sapo nakua Puang Yesus: “Dengan tau urrumbuna' annu kusa'ding dengan kamatoroan mallai illalan mai kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tappana naissanan inde baine kumua naissanarria Puang Yesus panggauannae sae siami lumalla'-malla' malimuntu' dio tingngayona Puang Yesus, anna tula'i narangngi tau buda lalanna nangei urrumbui anna natula' toi duka' kumua tappa malapu'. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma'kadami Puang Yesus lako inde bainee nakua: “O anakku, malapu'moko annu muoreanna'. Laomoko, anna la tontongko siayun kamasakkean.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Marassampi mantula' Puang Yesus anna saemo to untambai Yairus dio mai banuanna nakua: “Bonno'mi anakmu, daumo ussussai Tuangguru.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sapo narangngi Puang Yesus tula'na, napolalan ma'kada lako Yairus nakua: “Dau marea', tontongko mangngorean anna tuo anakmu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Saei lako banuanna Yairus, ta'mo untangga' tau Puang Yesus tarru' tama banua ussolannii anggami Petrus, Yohanes, Yakobus, anna ambena sola indona inde anakke. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tumangi' asammi tau umbatingngi inde anakke. Sapo ma'kada Puang Yesus nakua: “Daua' tumangi', annu inde anakke tae' bonno' sapo mamma'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Napetawai asammi tau annu naissanan kumua bonno'mi. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sapo ummanda'i limanna inde anak Puang Yesus-e anna ma'kada nakua: “O anakku, millikko!” ");
INSERT INTO mqjNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Menawa siami sule anna membangun ke'de'. Ussuami tau Puang Yesus umbenganni nande. ");
INSERT INTO mqjNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mangnga-mangngami to matuanna, sapo napakari'di' Puang Yesus kumua tae' la natula' lako tau inde kara-kara napadadie. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pissan attu, untambaimi iato sapulo dua passikolana Puang Yesus-o anna benganni kamatoroan sola kakuasaan untondon angganna setang anna umpomalapu' ma'rupa-rupa saki. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Anna mane suai lao umpalanda' kareba diona kaparentaanna Puang Allata'alla anna la umpomalapu' to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Napakari'di'mi nakua: “Tae' dengan aka la mubaa illalan kapenonosammua'. Tae'koa' la umbaa tekken, bakku', kinallo, doi', anna bayu pessondaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ianna dengan tau umpalangngangkoa' banuanna dio mesa tondok, dio liumokoa' too sae lako nalambi' attunna umpelleikoa' tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ianna tae' dengan tau illalan mesa tondok ma'din untarimakoa', pelleia' itin tondoknao ammu tambakkia' soyokna dio mai lentekmu annu la mendadi tanda lako tondok iatoo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mengkalaomi inde sapulo dua passikolae, lao ullelean tondok umpalanda' Kareba Kadoresan napasiolaan umpomalapu' to masaki lako angganna angngenan. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Napelelemi duka' Herodes, tomaraya dio lembangna Galilea diona pengkaranganna Puang Yesus, napolalan pusa' penawanna annu dengan tau kumua tuo sule Yohanes to simantedok. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dengan duka' tau kumua nabi Elia kendek sule. Dengan toi tau kumua mesa nabi yolona tuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sapo nakua Herodes: “Mangkami kulempo'i ulunna Yohanes to simantedok. Dadi benna tappa'mo inde taue, to sidipelele umpogau' inde mai kara-karae?” Umpeangmi lalan la silambi' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sulei inde mai rasulna Puang Yesus-e, natetteranammi angga mangkanna nakarang. Mangkaii, nabawaimi Puang Yesus ussarakki kalena lako mesa kota disanga Betsaida. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sapo naissanan tau kamban napolalan lao naula'. Napabeaimi Puang Yesus anna tetterananni kaparentaanna Puang Allata'alla anna umpomalapu' to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","La lendu'i allo, saemi passikolana umpellambi'i Puang Yesus anna kuanni: “Umbai mapia ke musuai inde lako taue anna lao umpeang nande sola angngenan nangei ma'bongi lako tondok battu lako leanan annu indekia' padang alla'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sapo natimba' Puang Yesus nakua: “Ikoa' la umpandei.” Nakuamo passikolana: “Angga limangkalebu roti anna dua be'dok kiampui. Anggami ke laokan ummalli nande kingei la mala umpande inde lako taue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Inde tau budae, anggapi muane anna umbai lima sa'bumo. Nakuamo Puang Yesus lako passikolana: “Suai itin lako tauo anna pantan ma'loko umbai silima pulo salaoan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Napalako tongammi passikola napolalan pantan ma'lokomo tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ummalami inde lima roti anna dua be'dok Puang Yesus-e, anna mentungngu langngan langi' ma'sambayang. Mangkai, umpiak-piakmi roti anna benganni lako passikolana natawa lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ummande asammi tau sadea'na. Mangkai ummande, narempummi passikola ra'dakna sapulo duapi baka. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pissan attu ma'sambayang Puang Yesus mesai. Mangkai ma'sambayang mekutanami lako passikolana nakua: “Situru' tula'na tau, bennarakkao ade'?” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Natimba' passikolana nakua: “Dengan tau ungkuai Yohanes to simantedok, dengan duka' ungkuai nabi Elia, dengan toi tau ungkuai mesa nabi yolona tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mekutana pole Puang Yesus nakua: “Anna ikoa'i, benna musangaianna'?” Natimba' Petrus nakua: “Ikomo To nabassei bayu-bayu Puang Allata'alla la ma'pasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Umpakari'di'mi passikolana nakua: “Daua' lao untula'i lako tau senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nakuamo lako passikolana: “Innang la ussa'dingan buda kamaparrisan Anak Mentolino anna la natumpu pala' perepi'na to Yahudi, kapala imam, anna to untarru' issinna sura'na Musa lambisan dipatei. Sapo katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mangkai too, nakuamo lako tau buda: “Benna-benna morai unturu'na', la untampean pa'kua penawanna, allo-allona la umpassan kayu pantokesanna, anna matutu unturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Annu benna-benna umpa'kadua-duai katuoan illalan lino, la ungkasayu'i katuoan sae lako-lakona. Sapo benna-benna nadotaan mate annu naturu'na', la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tae' dengan gunana moi la ummampui tau angganna issinna lino ke la sanggangri sunga'ta. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Benna-benna umpa'kasirisanna' sola umpa'kasirisan battakadangku, la napa'kasirisan duka' Anak Mentolino, ke saemi sitonda kamatandeanna anna kamatandeanna Ambena sola kamatandeanna angganna malaeka' masero. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kupokadangkoa' sitonganna, dengangkoa' to dio reen temo tae' la bonno' ke ta'pa ummita Puang Allata'alla ma'parenta.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Umbai karuai allona mangkanna untula' pepatudu iatoo, umbawaimi Petrus, Yohanes anna Yakobus Puang Yesus langngan tanete lao ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Marassanni ma'sambayang, lumalimmi rupanna Puang Yesus anna mabussang pakeanna pakkillo'-killo'. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tapakala tokke'mo lemba' dua tau nasipantulasan, iamo Musa anna nabi Elia. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Inde to duae, bassi pangngarrang diita anna untula' kamateanna Puang Yesus la dadi dio Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Attu iatoo, mamma' Petrus sola solana. Millikki, ummitami Puang Yesus pangngarrang sola inde to duae ke'de' dio sa'dena. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","La mengkalaoi inde to duae, nakuamo Petrus lako Puang Yesus: “O Tuangguru, ta'mo dengan la nasusian masannangki inde rokko angngenanne. Mapia ke kipake'de'i tallu lantang angki pasandaikoa' simesa: Iko, Musa, anna Elia.” Sapo tokke'mi samantula'na Petrus annu mangnga-mangnga napolalan tae' umpekalembasan inde tula'nae. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Marassampi mantula' anna saemo gaun ungkabu'i napolalan marea' inde passikolanae. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Urrangngimi kamara illalan mai gaun nakua: “Iamo te Anakku to kupilee, perangngia'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pa'dei inde kamarae, angga mandami Puang Yesus naita passikolana. Inde kara-kara naitae tae' tappa napokada passikola sapo masaepi mangkanna anna mane tula'i lako tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Makale'na ma'pasulemi Puang Yesus yao mai tanete sola inde tallu passikolanae. Ma'silullu' omi tau buda sae umpellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dengammi mesa tau mealo' illalan mai alla'-alla'na tau buda nakua: “O Tuangguru, petuasan siapa' anakku, annu anggami te anakkue. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sibassa' natamai setang napolalan simealo'-alo' anna lumalla' lambisan pambura-bura elo'na. Inde setangnge undarra liu anakku, kamala ta'mo naaku mallai illalan mai kalena. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mangkamo' mengkarumase-mase lako passikolamu kenamala narambai lao sapo' tae' nabela.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma'kadami Puang Yesus nakua: “O anggammua' rupa tau temo, to tamangngorean tongangkoa' anna to pusa. Umbapi la pada masaena la kungei torro illalan alla'-alla'mua'? Anna umba polepi la susi kasa'barasangku lako kalemua'? Solanni mai itin anakmuo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Inde anna menono'mo lao umpellambi'i Puang Yesus-e, napessambakan siami setang rokko litak anna lumalla'. Sapo nasadangngi Puang Yesus anna suai mallai illalan mai kalena inde anakke, napolalan malapu'. Napasulemi lako ambena. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mangnga-mangnga asammi tau buda ummita kakuasaanna Puang Allata'alla tadisirantean. Mangnga-mangngapi tau buda ummita kara-kara napogau' Puang Yesus, nakuamo lako passikolana: ");
INSERT INTO mqjNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Perangngi manappai ammu paillaan tambukkia' inde tula'kue: Anak Mentolino la disorong rokko lisu pala'na ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sapo tae' napekalembasan passikolana inde tula'nae annu ta'pa dipokadanni kalembasanna indana issananni. Sapo malaya' duka' passikolana umpekutananni lako. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pissan attu kendek kasipekkaan illalan alla'-alla'na passikolana Puang Yesus kumua bennanna randan la matande. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sapo naissanan Puang Yesus pikki'na napolalan ummala mesa anak anna pake'de'i dio sa'dena. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nakuamo lako passikolana: “Benna-benna untarima inde anak ura'na kapangngoreananna lako kalekue, sirapammi Kao natarima. Anna benna-benna untarimana' tae' angga Kao natarima sapo' untarima duka' to ussuana'. Annu iamo to ussanga kalena barinni' illalan alla'-alla'mua' iamo randan ma'tandalangnganan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma'kada Yohanes lako Puang Yesus nakua: “O Tuangguru, dengan tau kiita ussa'bu' sangammu urrambai setang, sapo kidapai annu tangngia solata.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nakuamo Puang Yesus: “Daua' dapaii, annu angganna to tae' umbalikoa' iamo solamu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","La nalambi' kalei attunna Puang Yesus diangka' langngan suruga, kalebumi illalan penawanna la lao langngan Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ussuami pira-pira tau yolo lako mesa tondok illalan lilli'na Samaria annu la umpatoka angga naparalluinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sapo moka to ma'tondok untarima Puang Yesus annu la lu langngan Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tappana naissanan dua passikolana disanga Yakobus anna Yohanes kumua tae' natarima to ma'tondok, nakuamo lako Puang Yesus: “O Puang, la muakurika ke kipaturunni api yao mai langi' ummapo'i inde lako taue?” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sapo menggirik Puang Yesus ungkeara'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umpatarru'mi penonosanna lako tondok senga'. ");
INSERT INTO mqjNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Inde anna umpatarru'mo penonosanna Puang Yesus sola passikolanae, dengammi mesa tau ma'kada nakua: “O Tuangguru, la kuula' liuko moi umba la muola.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Natimba' Puang Yesus nakua: “Ummampui ia bumbun serigala anna angganna dassi ummampui serang, sapo Anak Mentolino tae' dengan ma'tutu nangei mamma'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Anna mane ma'kada lako mesa tau senga' nakua: “Turu'na'.” Natimba' inde taue nakua: “Io, sapo pabeaipa' lao ullamun ambeku yolo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Sapo nakuanni Puang Yesus: “Pabeaimia duka' to mate ullamun to matena, sapo laomoko iko umpalanda' kareba diona kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dengan duka' mesa tau nakua: “La kuturu'ko sapo pabeaipa' lao ungkuan rapungku yolo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sapo natimba' Puang Yesus nakua: “Benna-benna sirapan to naparandukmo massalaga sapo messaile lako boko'na sule, tau iatoo tae' sipato' mengkarang illalan kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mangkai too, unturo pole omi pitu pulo tau senga' Puang Yesus anna pantan suai sanda sidua yolo lako simesa-mesa tondok anna angngenan la napellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nakuamo Puang Yesus lako: “Sitonganna budami gandum matua sapo angga titti' to la ussae'i. Iamo too pelauia' langngan puangna gandum anna ussua tau sae ussaesanni gandumna. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pengkalaomokoa', sapo pengkilalaii kumua sirapangkoa' domba kusua tama alla'-alla'na serigala. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tae'koa' la umbaa angngenan doi', bakku', anna sandala'. Daua' torro lako lalan sipantula' tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ianna la tamakoa' mesa banua, la mukuaa' yolo: ‘Anna tamba'morokoa' Dewata.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ianna mapia penawa to ma'banua anna natarima manappakoa' la ullolongan pa'tamba'mua'. Sapo ianna tae'koa' natarima tae' duka' la ullolongan pa'tamba'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pamesaia' angngenammu dio mesa banua. Daua' malaya' ummande sola ummiru' pa'petandona to ma'banua annu angganna to mengkarang sipato' disaroi. Dadi daua' membero-bero. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ianna tamakoa' mesa tondok anna natarimakoa' tau illaan, andei nande natandoiangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pomalapu'i to masaki dio itin tondokko ammu kuanni to ma'tondok: ‘Madappi'mi attunna la ma'parenta Puang Allata'alla illalan alla'-alla'mua'.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sapo ianna tamakoa' mesa tondok anna tae'koa' natarima to ma'tondok, laokoa' lako lalan maroa' ammu metamba-tamba kumua: ");
INSERT INTO mqjNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Sae lako soyokna tondokmua' la kitambakki dio mai lentekki la mendadi pepakilala lako kalemua'. Sapo kipokadangkoa' kumua: Madappi'mi attunna la ma'parenta Puang Allata'alla illalan alla'-alla'mua'.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kutulasangkoa' sitonganna, ianna nalambi'mo allo nangei umbisara ma'rupa tau Puang Allata'alla, la marru mabanda' ia perambinna Puang Allata'alla lako to illalan itin tondokko anna la to dio kota Sodom.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“La sanggangkoa' anggammu issinna kota Khorazim anna issinna kota Betsaida, annu kela dadi dioi kota Tirus anna Sidon tanda memangnga-mangnga kupogau' illalan alla'-alla'mua' pongngade'mo anna mengkatoba' tau dio lambisan la ma'pote bolong umpenassanni panggauanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sapo ianna nalambi'mo attunna umbisara ma'rupa tau Puang Allata'alla, la maringngannia perambinna Puang Allata'alla lako to dio kota Tirus anna Sidon anna la ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Anna ikoa' to dio Kapernaum, musangarika la diangka'koa' langngan suruga? Tae'! La ditibe tamakoa' naraka.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nakuamo Puang Yesus lako passikolana: “Benna-benna umperangngikoa', naperangngina' duka'. Benna-benna untumpu pala'koa', natumpu pala'na' duka' anna untumpu pala' to ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dore' asammi ma'pasule inde pitu pulo passikola to mangka nasuae, anna ma'kada lako Puang Yesus nakua: “O Puang, sae lako setang mengkaola lako kaleki ke ussa'bu'kan sangammu ussuai lao.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nakuamo Puang Yesus: “Kuita ponggawana setang dondon yao mai langi' susi kila'! ");
INSERT INTO mqjNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sitonganna mangkamokoa' kubengan kakuasaan ullullu'i ula' sola pakasiak anna kakuasaan untalo kamatoroanna ponggawana setang ewalimmua' napolalan ta'mo dengan la ussanggangngikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sapo daua' dore' ura'na kapataloammua' lako setang, sangngadinna la dore'koa' annu tiuki'mi sangammua' yao suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tappa kendek siami kadoresanna Puang Yesus napabuttu Penawa Masero illalan kalena, anna ma'kada nakua: “O Ambeku, Dewatanna langi' anna lino. Ma'kurru' sumanga'na' matin, annu angganna te maie tae' mupakawanan lako to ummangga' kalena manarang anna ma'rori' sapo mupakawanan lako to napa'barinni'i ma'rupa tau. O Ambeku, iamo te pa'kuammue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mangkaii, nakuamo Puang Yesus: “Angga lako, mangka asammi napalessu' rokko lisu pala'ku Ambeku. Tae' dengan tau la ummissananni benna Anakna Puang Allata'alla salianna Ambeku. Tae' toi dengan tau la ummissanan Ambeku salianna Anakna anna to naporai Anakna napokadaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mangkaii, menggirikmi untingngayo passikolana anna ma'kada lako nakua: “Kerongko'koa' annu ummitakoa' inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Annu kupokadangkoa'i, buda nabi anna tomaraya yolona morai la ummita inde kara-kara muitae, sapo tae' naita. Anna morai la urrangngi angga murangnginna temoa', sapo tae' narangngi.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ke'de'mi mesa to untarru' issinna sura'na Musa morai la ussandak-sandak Puang Yesus, ma'kada nakua: “O Tuangguru, akamo la kupogau' angku malara ullolongan katuoan sae lako-lakona?” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Natimba' Puang Yesus nakua: “Aka tiuki' illalan sura'na Musa? Aka nakua simubaca?” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nakuamo inde taue: “Nakua illalan: ‘La sangkalebu penawammu ungkamasei Puang Allata'alla Dewatammu anna sangkalebu pikki'mu anna angganna kamatoroammu,’ anna nakua polepa: ‘Kamaseiko padammu ma'rupa tau susi ungkamasei kalemu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nakuamo Puang Yesus: “Tonganna timba'mu, pogau'mi too ammu malara ullolongan katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sapo umpeang liupi lalan la ummaloloan kalena, napolalan mekutana pole nakua: “Bennamo padangku ma'rupa tau?” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Natimba' Puang Yesus ummolai mesa tandengan nakua: “Dengan mesa tau mengkalao yao Yerusalem la lu rokko Yerikho. Ummolai lalan, naadangmi to kadake anna tae' angga narappai angganna aka-akanna sapo natumbuipi lambisan la bonno' mandami anna mane le'ba umpelleii. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Attu iatoo, sirupang dengan mesa imam ummola lalan iatoo. Inde anna ummitamo inde taue napellia'imi anna umpatarru' penonosanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Susi siami duka' mesa to Lewi liu dio lalan iatoo. Ummitai inde taue napellia'imi anna umpatarru' penonosanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Liumi duka' mesa to Samaria dio inde angngenanne. Ummitanna inde taue, rantang siami buana. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nadendeimi, anna baseii anggur balalanna anna pakulianni minnak, anna mane balunanni. Mangkaii, napalangngammi keledainna anna solanni lako banua sidingei ma'bongi anna taranakki. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Masiangngi, umpebengammi doi'na dua dinar lako inde puangna banuae, napasiolaan ma'kada nakua: ‘Taranak manappai. Ianna ta'ra ganna' inde doi'e angku sondaimira ke ma'pasulena'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nakuamo Puang Yesus lako inde to untarru' issinna sura'na Musae: “Situru' pikki'mu, umbanna inde tallu taue mala digente' padanna ma'rupa tau inde to diadangnge?” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Natimba' nakua: “Inde to ungkamaseie.” Nakuamo Puang Yesus: “Laomoko ammu pogau'i susinna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Umpatarru'mi penonosanna Puang Yesus sola passikolana, napolalan ullambi' mesa tondok. Dio inde tondokke, dengan mesa baine disanga Marta umbawai Puang Yesus lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Inde bainee dengan sirondongna disanga Maria ma'loko liu dio tingngayona Puang Yesus umperangngii tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sapo tae' ia dengan torro Marta ussarai to saena, napolalan lao umpellambi'i Puang Yesus anna kuanni: “Maakari ammu pabeai Maria umpamesa-mesana' mengkarang? Kuanni anna pamoloina'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Natimba' Puang Yesus nakua: “O Marta, buda sigali iko kara-kara mupasalui penawa ");
INSERT INTO mqjNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kenada angga mesa randan parallu. Napileimia randan mapianna Maria, anna tae' dengan tau la ummalaii.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pissan attu ma'sambayang Puang Yesus dio mesa angngenan. Mangkai ma'sambayang, ma'kadami mesa passikolana nakua: “O Tuangguru, patudukan ma'sambayang susi Yohanes umpatudu passikolana ma'sambayang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Natimba' Puang Yesus nakua: “Ianna ma'sambayangkoa' la mukua: O Ambeki, dipomasero sangammu, paombo'mi kaparentaammu. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bengangkan nande la siruanna kiande allo-allona. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ammu garri'iangkan kasalaangki, annu unggarri'imokan duka' to kasalaan lako kaleki. Dau pabeaikan diereng umpogau' kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Anna mane ma'kada pole lako passikolana nakua: “Sirapan dengangkoa' mesa lao lako banuanna solamu tangnga bongi ammu kuanni: ‘Pasuka'ipakkao tallungkalebu rotimmu ");
INSERT INTO mqjNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","annu dengan siissanangku lempang dio banuangku anna ta'mo dengan aka la ditandoianni.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sapo nakua inde to ma'banuae: ‘Dau sussaina', mangkami kukado' ba'baku anna mamma'mokan sola anakku. Ta'mo kuaku la millik umbengangko roti.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kutulasangkoa' sitonganna, moika anna solanako, innang tae' sia la naaku millik umbengangko. Sapo tae'ko makadere' umpelau liui, la millik anna bengangko angga mupelaunna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Iamo too kupokadangkoa'i: pelaui ammu dibeen, peangngi ammu lolonganni, dedekkoa' ba'ba ammu ditungka'ian. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Annu angganna to melau la untarima pelaunna, angganna to mameang la nalolongan, anna angganna to undedek ba'ba la ditungka'ianni. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tae' dengan mesa ambe la untandoi ula' anakna ke umpelaui be'dok. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Battu natandoi pakasiak ke umpelaui tallu dassi. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ikoa' to kasalaan anna muissan untandoi anakmua' mapianna, la Ambemupa yao suruga. Innang la umpebeen Penawa Maserona lako angganna to melau langngan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pissan attu urrambai setang Puang Yesus illalan mai kalena mesa to oma'. Mallainna setang illalan mai kalena, naissan siami mantula' inde taue napolalan mangnga-mangnga tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sapo dengan ungkuai: “Kakuasaanna Beelzebul battu dikua ponggawana setang illalan kalena napolalan mala urrambai setang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dengan duka' morai la ussudii napolalan umpelau Puang Yesus la umpadadi tanda la umpakawananni kumua to lu yao tongan mai suruga. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sapo naissanan Puang Yesus pikki'na, napolalan ma'kada nakua: “Ianna sirarimo tau illalan mesa kaparentaan, inde kaparentaanne innang la pa'dena. Susi toi duka' mesa pendaposan, ianna sipekka-pekkamo tau illalan, innang la renggangna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Susimi duka' kaparentaanna ponggawana setang, ianna la sibali-balimo setang illalan innang la pa'dena. Annu mukuaa' kakuasaanna Beelzebul kupake urrambai setang. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ianna kakuasaanna Beelzebul kupake urrambai setang, kakuasaan aka ia napake to unturu'koa' urrambai setang? Manassa anna sala pikki'koa' annu tangngia duka' kakuasaanna setang napake to unturu'koa' urrambai lao setang! ");
INSERT INTO mqjNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sapo sitonganna kakuasaanna Puang Allata'alla kupake urrambai lao setang, anna iamo umpomanassai kumua umpaombo'mi kaparentaanna Puang Allata'alla illalan alla'-alla'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sirapan dengan mesa to matoro anna ganna' porewana undagai banuanna, la masakke angganna aka-akanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sapo ianna dengan to marru matoro ummewai anna taloii, la narappai asan porewa narannuan anna tawa-tawai ewananna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Angganna to tae' unturu'na', nabalina' anna angganna to tae' ussolanna' marrempun, tau iatoo ma'pasisarak-sarak.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ma'kada polemi Puang Yesus nakua: “Ianna dengan mesa setang mallai illalan mai kalena tau, la lu rekke lu sau' dio angngenan makorre umpeang la nangeinna torro. Sapo tae' dengan nalambi', nakuamo: ‘La sulena' lako angngenan kutampe.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma'pasule tongammi, lo'bangpi nalambi' mangka diato' manappa anna mapatting. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mengkalao siami lao untambai pitu setang untondonni kakadakeanna anna torro sola illalan inde angngenanne. Katampakan tuttuan mabanda' kamaparrisan ullambi' inde taue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Marassampi mantula' Puang Yesus, metambami mesa baine illalan mai alla'-alla'na tau buda nakua: “Kerongko' baine undadiangko anna umpasusuko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sapo natimba' Puang Yesus nakua: “Marru kerongko' to umperangngii battakadanna Puang Allata'alla anna pogau'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Marassanni nakarompo' tau buda, umpatarru'mi tula'na Puang Yesus nakua: “Marru kadake gau' inde rupa tau lapik temoe annu morai la dipadadian tanda memangnga-mangnga. Sapo tae' la dipadadian tanda senga' salianna tanda mangka dadi lako kalena nabi Yunus. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Annu umba nakua Yunus yolona dipotanda lako issinna kota Niniwe, la susimi duka' Anak Mentolino dipotanda lako ma'rupa tau lapik temo. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ianna nalambi'mo attunna la umbisara ma'rupa tau Puang Allata'alla, tuomi sule tomaraya baine, tomarayanna Syeba yolona sola ikoa' rupa tau temo. La napasalakoa'i annu mambela ia naola lao umperangngii kakeakasanna tomaraya Salomo. Sapo mokakoa' iko umperangngii tula'na to marru untondon tomaraya Salomo illalan alla'-alla'mua' temo. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ianna nalambi'mo attunna la umbisara ma'rupa tau Puang Allata'alla, la tuomi sule to Niniwe anna pasalakoa' to tuo temo. Annu mengkatoba' ia to Niniwe anna urrangngimo kadanna Dewata napalanda' nabi Yunus. Sapo tae'koa' iko mengkatoba' moi kenada marru ma'tandalangnganan ia to umpantula'ikoa' temo anna la Yunus.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mantula' pole omi Puang Yesus nakua: “Tae' dengan tau umpau' ballo anna mane bunii battu napasamboi baka. Sapo napayao innang angngenanna anna malara angganna to tama banua la naita pangngarrangna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matammu sirapan ballo illalan kalemu. Ianna masiang matammu, masiang asan sangkalebu batang kalemu. Sapo ianna mapa'di' matammu, malillin asan sangkalebu kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iamo too petua' manappai indana kamalillinammo musanga kamasiangan illalan kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ianna masiang asan sangkalebu kalemu anna tae' malillin pira, la masiang asammi susi ballo ummarrangko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mangkai ma'pa'guru Puang Yesus, natambaimi mesa to Farisi lao ummande lako banuanna. Tamami banua anna ummokko' ummande. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mangnga-mangngami inde to Farisi ummita Puang Yesus-e annu tokke' ummande tae' umbasei limanna yolo, situru' alukna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sapo ma'kada Puang Yesus nakua: “Ikoa' iko to Farisi, sirapangkoa' umbasei irusan sola kolak angga salianna mubasei, tae' mubasei tandai tamanna. Susimokoa' too angga saliammua' mabase sapo ponno kakadakean anna parrappamua' tandai tamanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oma' tongangkoa'. Annu Puang Allata'alla umpadadii salianna anna napadadi toi duka' tandai tamanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bengannia' lako to mase-mase itin issinna irusammu sola kolakmua'o, napolalan makayo asan lako kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Sapo la sanggangkoa' iko to Farisi annu ianna umpa'petandoammokoa' bare sapulona alan litakmu saemi lako rampa-rampa tokke' situo susinna selasih, inggu, anna rampa-rampa senga' mupatama. Sapo tae'koa' umposamelean kamaloloan lako padammu ma'rupa tau anna pa'kamasena Puang Allata'alla kenada iamo randan parallu mupalakoa'. Palako asannia', dau pa'lembei pira. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","La sanggangkoa' anggammu to Farisi, annu simuporaia' ma'loko dio tingngayo illalan banua pa'sambayangan anna simuporaia' napa'tabe'i tau lako pasa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","La sanggangkoa', annu mapiakoa' diita sapo sitonganna kadake penawakoa'. Sirapangkoa' liang tae' ditandai, napa'ola-ola babang tau annu tae' naissanan kumua to materia diong.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dengan mesa to untarru' issinna sura'na Musa mentimba' nakua: “O Tuangguru, tikanna duka' penawangki urrangngi itin tula'muo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sapo natimba' Puang Yesus nakua: “La ullambi'koa' duka' kasanggangan anggammua' to untarru' issinna sura'na Musa annu siumpapiakoa' atoran mabanda' ammu papassai tau umpalakoi sapo tae'a' iko muaku mupalako. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","La sanggangkoa' annu ikomoa' iko umpapiaan tadanna nabi anna nenemumoa' mangka umpateii. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dadi musituru'ia' angganna panggauanna nenemu annu umpateimi nabi anna ikomoa' umpapianni tadanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iamo nangei sitonda kakeakasanna Puang Allata'alla ma'kada nakua: ‘La kusua sae pira-pira nabi sola rasul umpellambi'i, sapo la napatei pira anna nadarra pira.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ia nangei umpatenni Puang Allata'alla anna malara dipabambanni sangka' inde rupa tau lapik temoe ura'na kadipateianna nabi mengkalao dio anna mane dikombong lino, ");
INSERT INTO mqjNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","battu dikua mengkalao dio Habel sae lako Zakharia to dipatei illalan alla'na angngenan pemalasan anna Banua Ada'na Puang Allata'alla. Kutulasangkoa': Anggannamo te maie la napolalan dipabambanni sangka' rupa tau lapik temo. ");
INSERT INTO mqjNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","La sanggangkoa' anggammu to untarru' issinna sura'na Musa annu tae'koa' umbengan lalan tau la umpengngissananni Puang Allata'alla. Mokakoa' iko umpengngissanannii anna ullawaipokoa' to morai la umpengngissanannii.” ");
INSERT INTO mqjNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Le'bami Puang Yesus umpellei inde angngenanne. Naparandukmi to Farisi sola to untarru' issinna sura'na Musa umbalii anna tae' dengan napakattui pekutana ");
INSERT INTO mqjNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","umba aka anna dengan petimba'na Puang Yesus la naposu'be' umpaalinni kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Attu iatoo, messa'bu tau ma'karompo' lambisan sisippi'-sippi' babangmi. Marassanni ma'silullu' tau, nakuamo Puang Yesus lako passikolana: “La madaga manappakoa' indana sanggangngiko raginna to Farisi. Kalembasanna tula'ku, panggauanna to ma'dua tambuk. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tae' dengan dipomatimminna tae' la diissanan anna tae' dengan dibuninna tae' la kawanan. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Angganna tula' bongimmua' la mupomatimminna innang la dipa'perangngian lako tau ke masiangmi, anna angganna bisikmua' illalan tambing dirapa' la dipetambaan narangngi tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Daua' marea' lako to angga batang kale naissan napatei annu ta'mo dengan senga'na la mala napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dengan mesa to la sipato' mukarea'a' iamo Puang Allata'alla to ma'kuasa umpatei anna mane pa'tibean tau tama naraka. Kupakilalakoa' kumua, mengkarea' langngangkoa' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Taissanan kumua lima dena' angga dua doi' randan barinni' allinna, sapo moi anna susi too, tae' dengan nakalembei Puang Allata'alla moi mesamo. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Senga'mia' iko too annu sae lako beluakmua' mangka nareken. Iamo too daua' marea' annu marru keangga'koa' iko anna la dena' moi umba pada budanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Pengkilalai manappaia' inde tula'kue: Benna-benna ummakuina' to digente' Anak Mentolino dio olona ma'rupa tau, la kuakui duka' dio olona malaeka'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sapo benna-benna untelangna' dio tingngayona ma'rupa tau, la kutelang duka' dio tingngayona malaeka'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mala ia digarri'i kasalaanna to untula' kadake Anak Mentolino, sapo to untelle Penawa Masero tae' dengan leleanna la digarri'i kasalaanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ianna dipopengngolokoa' lako pa'bisara aluk, battu lako to ma'parenta iaraka anna lako to ma'kuasa, daua' mausa' umba la mukua mentimba' umpa'timpasan kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Annu Penawa Maseromo la umpatudukoa' la sipato'na mutula' attu iatoo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dengan mesa tau illalan alla'-alla'na inde tau budae, ma'kada lako Puang Yesus nakua: “Sandakpi mukuan sirondongku anna bennakkao pira ewanan natampeangkan to matuangki.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sapo natimba' Puang Yesus nakua: “Bennamo mangka ummangka'na' la umbisarakoa' battu la untawangkoa' ewanammu?” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Anna mane mantula' lako tau buda nakua: “Madagakoa' ammu matangkin indana taloikoa' kamailuan la untombon ewanan. Annu tangngia ewanan to'na katuoanna ma'rupa tau moi nakuaan kada la kendek langngan langi' ewananna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mantula' pole omi Puang Yesus lako tau buda untetteran mesa tandengan, nakua: “Dengan mesa tomakaka simaka'da' alan litakna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mekutanami illalan penawanna nakua: ‘Akamo la kupogau' annu ta'mo dengan kupa'pengngei alan litakku?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nakuamo: ‘Kuissanammi. La kurondonni angganna alangku angku garaga polei kamainna angku pangngannai gandumku sola angganna ewanan senga'ku. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Angku mane ma'kada lako kaleku kukua: Kerongko'mokkao. Kuampui asammi angga mapianna moi la pira taun kupake tala purai. Ta'mo' la mengkarang, la melliwemo'. Anggamo' la ummande sola ummiru' anna umpalosso' inawangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sapo ma'kada Puang Allata'alla lako nakua: ‘To maro tongangko, bongi temo la kualaimi penawammu. Bennamo la ummampui itin ewanan mutombonno?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La susimi te to untombonan ewanan kalenae ke tae' urrempun ewanan dio olona Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma'kada pole omi Puang Yesus lako passikolana nakua: “Iamo too anna kukuamo lako kalemua'i: Daua' malallan umpikki' salu katuoammu, susi nande la muande, tenni sampin la mupake. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Annu marru kalando ia katuoan anna la nande, anna batang kale marru kalando anna la sampin. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pikki'pia' katuoanna kadoaya, tala mangngambo', tala mepare, iapaka la ummampui talukun battu alang. Sapo moika anna susimo too, tontong liu duka' nabengan nande Puang Allata'alla. Marru keangga'koa' iko anna la dassi. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tae' dengan tau mala ullombungngi sunga'na moi titti'mo annu malallan umpikki' salu katuoanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dadi ianna tae' muissan ungkarang inde kara-kara randan barinni'e, maakari ammu malallan diona kara-kara senga'? ");
INSERT INTO mqjNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Petua'pia' umba nakua tuo bunga-bunga lako pasang. Tala mengkarang, tala ma'tannun. Sapo kupokadangkoa'i: Moika anna matande tomaraya Salomo sapo tae' untondon kamalekeanna inde lako bunga-bunga pakeannae. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Inde lako reue tuo temo disumpunni makale', sapo napomaleke Puang Allata'alla. Senga'mia' iko too, sapo tae'koa' mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dadi, daua' malallan anna tae' angga la muandena sola la muiru'na mupasalui penawa. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Annu itin matin kara-kara susio napeang to tae' ummissanan Puang Allata'alla. Sapo naissanan ikoa' Ambemu kumua muparallui. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sapo pasaluikoa' penawa kaparentaanna Puang Allata'alla, anna pagannasangko angga kaparalluammu. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Daua' marea' mentu'ko to nakala' kombongan barinni' to unturu'na' annu naporanammi Ambemu umpatamakoa' kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Balukki ewanammua' ammu tawaianni to mase-mase allinna. Garagakoa' angngenan doi' tae' la naissan puru' la mupa'pengngei ewanan yao suruga, iamo ewanan tae' la pura, tae' diissan diboko, anna tae' la naande panattak. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Annu iamo nangei ewanammu iamo duka' nangei penawammu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Nakua pole omo Puang Yesus: “La tontongkoa' matangkin, susi sabua' ummampai puangna sule dio mai pa'sombaan. Inde sabua'e tontong liu mapia pakena anna mian ballona, anna malara saena puangna undedek ba'ba, tappa natungka'ianni. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kerongko' angganna sabua' nalambi' puangna tontong matangkin. Kutulasangkoa' sitonganna, la ma'kariri' inde puangnae anna ussua sabua'na ma'loko anna tarakannii. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kerongko' inde sabua'e ke tontong liui madaga nalambi' puangna, tangngarika bongi battu nannaririka anna sae. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pikki'pia' too, ianna naissanan puangna banua kumua tettek pira sae to maboko, innang tae' sia la umpabeai banuanna dibokoi. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iamo too, la tontong liukoa' duka' matangkin annu kasaeanna Anak Mentolino, tae' mubae-bae.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mekutana Petrus nakua: “O Puang, anggarika kami napatu itin tandenganno, anggannaraka tau?” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Natimba' Puang Yesus nakua: “Bennara to matutu anna keaka' ummato' pengkarangan illalan banuanna puangna? To matutu anna keaka' ummato' pengkarangan illalan banuanna puangna, iamo to naangka' puangna umponggawai solana, anna pandei ke nalambi' omi attunna ");
INSERT INTO mqjNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kerongko' sabua' to tontong matutu umpalako manappa karanganna nalambi' puangna ke sulemi. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kupokadangkoa' sitonganna, innang la naangka' puangna ummatosanni angganna ewananna. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sapo ianna nakua illalan penawanna inde sabua'e: ‘Maela'pi sae puangku’, napolalan ungkaka'i solana susi muane tenni baine, anna ummande sola mangngiru' lambisan malango. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tapakala tokkemo sae puangna tae' nabae-bae. Nakambeimi puangna anna mane pa'tibeanni tama angngenanna to tamangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Lako sabua' to ummissanan pa'kuanna puangna sapo tae' ma'patoka battu dikua tae' umpogau' pa'kuanna puangna, la dikambei. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sapo lako sabua' to tae' ummissanan pa'kuanna puangna anna umpalako karangan sapo sala napolalan la dikambei, dikambei ia duka' sapo gantanna. Annu benna-benna dibengan buda, la buda dipelau lako, anna to buda passanan dibenganni la buda duka' dirannuan lako kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ma'kada pole omi Puang Yesus nakua: “Kao-kao tee, saena' umpa'lebasan api tama lino. Anna la tialamo penawangku ke napollo'mi mian. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sapo dengampi kamapa'disan mabanda' la ullambi'na', anna masussa liupa penawangku ke ta'pa lessu'. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Umbai musangaa' kasikalinoan sae kubaa tama lino. Tae'! Tangngia kasikalinoan sapo kasisala-salaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Naparanduk temo la kendek kasisala-salaan illalan banua. Susinna ke limari tau illalan mesa banua tallu tau la unturu'na', dua tau tae' unturu'na', battu duaraka unturu'na' anna tallu tau tae' unturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ambe la sibali anakna muane, indo la sibali anakna baine, anna matuka baine la sibali manintunna baine.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma'kadami Puang Yesus lako tau buda nakua: “Ianna ummitamokoa' gaun makamban illau' karaunanna allo, mukuamoa': ‘La uran.’ Anna uran tongan. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ianna musa'dingmoa' kumua lu dio mai tandai kairinna mata allo bara', mukuamoa': ‘La kulla' allo.’ Kulla' tongan allo. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Innang to ma'dua tambuk tongangkoa', annu muissannia umpekalembasan tanda illalan lino sola yao langi', sapo tae'a' muissan umpekalembasan tanda dipadadi illalan alla'-alla'mua' temo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Maakari anna tangngiko siamo umpopa'tantui kumua indemi malolonae? ");
INSERT INTO mqjNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ianna nabaakoa' ewalimmu lako pa'bisara, peangko lalan ammu sikapiaa' ummola lalan indana popengngoloko lako pa'bisara anna mane sorongko pa'bisara rokko lisu pala'na polisi anna tarungkungko. ");
INSERT INTO mqjNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kutulasangko sitonganna, innang tae' siako mala suun illalan mai tarungkun ke tae' mangka mubaya' dandamu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Attu iatoo, dengan tau untulasan Puang Yesus kumua pira-pira to Galilea napatei Pilatus anna marassan untunu pemala'na langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Natimba' Puang Yesus nakua: “Nakuaka illalan penawammua' ia nangei mate susi inde to Galileae annu buda sigali kasalaanna anna angganna to Galilea senga'? ");
INSERT INTO mqjNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tae'! Sapo kupokadangkoa' sitonganna, ianna tae'koa' mengkatoba' dio mai gau' kadakemu innang la unduppakoa' duka' kasanggangan. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Susi duka' sapulo karua tau mate natappai banua malangka' dio Siloam. Nakuaka illalan penawammua' buda sigali ia kasalaanna anna la angganna tau dio Yerusalem? ");
INSERT INTO mqjNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tae'! Sapo kutulasangkoa' sitonganna, ianna tae'koa' mengkatoba' dio mai gau' kadakemu innang la unduppakoa' duka' kasanggangan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mangkai too, untetterammi mesa tandengan Puang Yesus nakua: “Dengan mesa tau ummampui to' ara illalan bela' anggurna. Pissan attu lao napetua' buana sapo tae' dengan. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nakuamo lako to simengkarang illalan inde bela' anggurnae: ‘Tallu taummi kuola umpeangngi buana ta'pa dengan la kulambisan. Lellengmi, annu angga umpurai babang lunakna litak.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sapo natimba' inde to mengkarangnge nakua: ‘O tuang, pabeaipi tuo inde illalan taunne, angku sandakpi kukumbang dio to'na tiku lao angku lompoii, ");
INSERT INTO mqjNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","umba aka anna kembua ke taun pole. Ianna tae' liu kembua, dilelleng pole'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pissan attu sirupang allo katorroan, ma'pa'guru omi Puang Yesus illalan banua pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Attu iatoo dengan mesa baine sapulo karuami taunna natamai setang napolalan masaki lambisan bungkukmi anna ta'mo naissan malolo ke'de'. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tappana naita Puang Yesus, natambaimi anna kuanni: “O indo', la malapu'moko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Anna mane urrumbu inde bainee, tappa malolo siami ke'de' anna umpakasalle Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sapo keara' to siurrepi' pengkarangan illalan banua pa'sambayangan annu allo katorroan nangei umpomalapu' to masaki Puang Yesus. Napolalan ma'kada lako tau buda nakua: “Annan allona dingei mengkarang, saemokoa' illalan allo iatoo ammu dipomalapu', sapo daua' papatuii allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Natimba' Puang Yesus nakua: “To ma'dua tambuk tongangkoa'. Tae'koka siurrappanan sapingmua' battu keledaimmu ke allo katorroan ammu lao umpairu'i? ");
INSERT INTO mqjNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inde bainee peampoanna Abraham sapulo karuami taunna natamai setang, sirapan nasangke'. Tae'ka la mala dirappanan duka' ke allo katorroan?” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Makadere' asan ewalinna Puang Yesus urrangngii tula'na, sapo inde mai tau budae dore' asan ummita kara-kara memangnga-mangnga napogau' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nakuamo Puang Yesus: “Akamo la nasusian kaparentaanna Puang Allata'alla anna akamo la kupasirapananni? ");
INSERT INTO mqjNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kaparentaanna Puang Allata'alla sirapan lise' tananan pada lise' sawi natanan tau dio bela'na. Tuomi inde lise'e lambisan kamai anna nangei kesserang dassi tangkena.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Anna mane mantula' pole Puang Yesus nakua: “Akapi la kupasirapanan kaparentaanna Puang Allata'alla? ");
INSERT INTO mqjNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kaparentaanna Puang Allata'alla mala duka' dipasirapan ragi, naala baine anna pasigerokki appa' tapulo lite' tappung lambisan kembea' asan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Umpatarru'mi penonosanna Puang Yesus langngan Yerusalem, ullelean tondok-ma'tondok napasiolaan ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dengammi mesa tau mekutana lako nakua: “O Tuang, anggarika titti' tau la dipasalama'?” Natimba' Puang Yesus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Peangko lalan ammu mala mangngola tama ba'ba basikki'! Annu kutulasangkoa' sitonganna, buda tau umpeang lalan la lu tama sapo tae' naola. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Annu ianna untutu'imo ba'ba to ma'banua, dio mandamokoa' salian ammu undedek ba'ba, mukua: ‘O Tuang, tungka'ikan!’ La natimba'ikoa' to ma'banua nakua: ‘Tae'koa' kuissanan battu lemba' umbakoa' ngei.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","La mukuaa' untimba'i: ‘Mangkamiki' sola ummande anna ummiru' anna mangkamoko ma'pa'guru lako lalan illalan tondokki.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sapo la nakuangkoa': ‘Tae'koa' kuissanan battu lemba' umbakoa' ngei. Pallaikoa' lao anggammua' to angga kakadakean mupogau'!’ ");
INSERT INTO mqjNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ianna ummitamokoa' Abraham anna Ishak sola Yakub anna angganna nabi illalan kaparentaanna Puang Allata'alla, la tumangi'mokoa' anna tikarasissik isimmu annu dirambaikoa' iko lao. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Anna la buda tau senga' salianna to Yahudi lu yaya mai, lu illau' mai, anna lu dio mai angganna angngenan illalan lino ummokko' ma'dore'-dore' illalan kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anna sitonganna, dengan to diangga' barinni' la mendadi to kamai, anna to diangga' to kamai la mendadi to barinni'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Attu iatoo, saemi pira-pira to Farisi ma'kada lako Puang Yesus nakua: “Pellei inde angngenanne annu morai tomaraya Herodes la umpateiko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Natimba' Puang Yesus nakua: “Laokoa' ungkuanni itin to manarru'o: ‘La urrambaipa' setang anna umpomalapu' to masaki allo temo anna makale', katallungngallona suppik pole' pengkarangangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sapo temo anna makale' sola dua bongi, innang la umpatarru'pa' penonosangku langngan Yerusalem annu angga yao Yerusalem nangei sipato' dipatei nabi. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O to Yerusalem! Budami nabi mupateia', makambammi pesuanna Puang Allata'alla musileba'-leba'ia' batu sabonno'na. Kuinawa-nawa liu la urrempungkoa' sirapan anak manuk nakoko'i indona sapo mokakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pengkilalaia'i, la natampemi Puang Allata'alla angngenammua'. Kupokadangkoa' sitonganna, ta'mo' dengan la muita pole sae lako attunna mungei ma'kada kumua: ‘Ditamba' to sae umpotendan sanganna Dewata.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pissan attu sirupang allo katorroan lao lako banuanna mesa to kamainna to Farisi Puang Yesus la ummande. Nasinenne'-nenne'imi to dio reen battu aka la napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tapakala saemo mesa tau kambang lentekna sola limanna, ke'de' dio tingngayona Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Mekutanami Puang Yesus lako to untarru' issinna sura'na Musa sola to Farisi nakua: “Situru' alukta, malarika tau umpomalapu' to masaki ke allo katorroan ta'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sapo tae' dengan sumu moi mesamo. Ummanda'imi limanna inde to masaki Puang Yesus-e anna pomalapu'i, anna mane suai le'ba. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mangkaii, ma'kadami Puang Yesus lako to dio reen nakua: “Pa'rapanan dengan anakmua' battu sapingmu tobang rokko garotin sirupang allo katorroan, tae'ka la muruntu'a' dio mai?” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tae' asan naissan natimba'. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Naitai Puang Yesus umpileiria angngenan keangga' la nangei ma'loko inde mai to saee. Untula'mi mesa tandengan nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ianna dengan to ma'somba untambaikoa', daua' tappa ma'loko dio angngenan keangga', annu dengan manii to kamai natambai. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Indana kuangko inde to untambaikoa'e: ‘Tabe', memberoko iko annu la nangei inde taue.’ Mupolalan la makadere' annu la memberoko lako angngenan randan wiring rokko. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sapo ianna natambaiko to ma'somba, ma'loko dioko angngenan wiring rokko anna saera to ma'tosae ungkuangko: ‘Ole, ma'loko yayako pengnguluan.’ Ianna susimo too, keangga'ko naita to sae senga'. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Benna-benna untandean kalena la dipa'barinni'i, anna benna-benna mengkareppe' la ditandean.” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mangkai too, nakuamo Puang Yesus lako to ma'tosae: “Ianna la ma'rame-rameko, susi allo tenni bongi, dau tambai solamu, battu sa'do'dorammu, battu rapummu, iaraka anna sabanuammu tomakaka, annu la natambaiko duka' ke ma'rame-ramei napolalan mulambi' siamo bala'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sapo ianna ma'rame-rameko, to mase-maseria la mutambai sola to kempo', anna to balimbingan sola to buta. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ianna susi too la natamba'ko Dewata. Annu moi anna tae' dengan akanna la nabala'iangko sapo la mutarima iko bala'na ke tuomi sule to malolo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Inde anna urrangngimo tula'na Puang Yesus-e, dengammi mesa to nasolaan ummande ma'kada nakua: “Kerongko' to la ullomba rame-rame illalan kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sapo ummala tandengan Puang Yesus untimba' inde taue nakua: “Dengan mesa tau umpadadi rame-rame maroa' anna untambai buda tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","La diparandukki sara', ussuami sabua'na lao pantan umpellambi'i to mangka natambai anna kuanni: ‘Maimokoa' annu toka asammi.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sapo moka asan untongkonni inde rame-ramee. Bunga'na nalambi' inde sabua'e, nakua: ‘Mane mangkana' ummalli bela' la laopi kupetua'. Dadi tae' kuissan la lao.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nakuamo mesa: ‘Tae' kuissan la lao annu la laopa' ussandak umpopassalaga sapingku sapulo mane mangka kualli.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Dengan duka' ungkuai: ‘Tae' kuissan la lao annu mane mangkana' kebaine.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ma'pasulemi inde sabua'e anna pokadai lako puangna. Keara' siami inde to umpadadi sara'e. Nakuamo lako sabua'na: ‘Laoko ussambai lalan kamai anna lalan barinni' illalan inde kotae ammu solaan asanni sae angganna to mase-mase, to kempo', to buta, anna to balimbingan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mangkai umpalako parentana puangna inde sabua'e laomi umpellambi'i puangna anna kuanni: ‘O tuang, mangkami kupalako parentamu, sapo dengampi lo'bang angngenan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nakuamo inde puangnae: ‘Laoko ussambai angganna lalan kamai anna lalan barinni' lako salianna kota, ammu sua angganna tau dio mai anna malara ponno banuangku. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Annu kupokadangko, tae' dengan to mangka kutambai la mala ummande illalan inde sara'kue.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Buda omi tau unturu' Puang Yesus illalan penonosanna. Menggirikmi anna ma'kada lako tau buda nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ianna dengan tau sae la unturu'na' sapo marru umpakalando ia ambena, indona, bainena, anakna, sirondongna, battu kalena, tae' mala la mendadi passikolaku. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Benna-benna tae' umpassan kayu pantokesanna anna turu'na', tae' la mala mendadi passikolaku. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pa'rapanan dengangkoa' morai la umpake'de' banua kamai, innang la nareken manappa yolo battu pira doi' la naparallui, anna malara naissanan kumua ganna'rika doi'na ta'raka. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Annu ianna tokke'mo naparanduk anna tae' nabela napamangka, la napetawai tau ");
INSERT INTO mqjNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nakua: ‘Tokke'mi duka' ma'pake'de' anna tae' nabela napamangka.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Susi toi duka', ianna dengan tomaraya la ummewa tomaraya senga', la napikki' manappa yolo kumua la nabelarika sapulo sa'bu tantarana ummewa dua pulo sa'bu tantarana balinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ianna tae' la nabela, la dengan tau nasua lao untammui balinna bayuanna mambelapa anna umpeang lalan la naola sikapia. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Susi siamokoa' duka' to dio reen temo, ianna tae'koa' untampeanan angga muampuinna, tae'koa' mala mendadi passikolaku. ");
INSERT INTO mqjNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Inde siae innang mapia sapo ianna matammangmo la malapika dipamassin sule? ");
INSERT INTO mqjNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ta'mo ma'guna, annu tala malapi dipake lako bela', tala malapi dipopa'lompoi, ditibe babangmi lao. Kenamala napatananni manappa talinga ma'rupa tau inde tula'kue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pissan attu buda omi tuang passima sola to naangga' to Yahudi to kasalaan, ma'rempun umperangngii tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sipa'mammang-mammangammi to Farisi sola to untarru' issinna sura'na Musa, nakua: “Naakuria sangkalamma' to kasalaan anna ummande sola.” ");
INSERT INTO mqjNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Untetterammi mesa tandengan Puang Yesus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pa'rapanan dengangkoa' ummampui saratu' domba sapo pa'de mesa, akamo la mupogau'? Innang la mutampe sia inde kaseranna pulona kasera dio padang alla'e ammu lao umpeangngi pa'dena samuitanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ianna muitamo la dore'ko ussompoi ");
INSERT INTO mqjNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma'pasule lako banuammu. Saeko lako untambaimoko solamu anna sabanuammu ammu kuanni: ‘La ma'dore'-dore'kia' annu iato dombaku pa'deo kuitami sule.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kutulasangkoa' sitonganna, susimi duka' yao suruga ke denganni mesa to kasalaan mengkatoba' marru didoresan ia anna la to kasera pulona kasera to malolo to ta'mo manggi' mengkatoba'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Susi toi duka', pa'rapanan dengan baine ummampui sapulo doi' pera' anna pa'de mesa, akamo la napogau'? La umpau' ballo anna ussapui banuanna umpeang manappa inde doi'e sanaitanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ianna naitamo, la untambaimi solana anna sabanuanna anna kuanni: ‘La ma'dore'-dore'ki' annu iato doi'ku pa'deo kuitami sule.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kutulasangkoa' sitonganna, susimi duka' kadoresanna malaeka'na Puang Allata'alla yao suruga ke denganni mesa to kasalaan mengkatoba'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mantula' pole omi Puang Yesus nakua: “Dengan mesa tau dua anakna bassi muane. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma'kada anak tampakna nakua: ‘O ambe' bengammokkao mana'ku temo.’ Natawammi ambena ewananna lako inde dua anaknae. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pira-pirangngalloi mangkanna, umbaluk asammi mana'na inde anak tampakke anna le'ba lako tondok mambela. Saei lako untappuru-purumi doi'na napake ma'masannang-sannang. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pura asanni doi'na, kendekmi karorian dio inde lembang nangeie napolalan naparanduk pole' masussa nasa'ding. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Laomi umpelau pengkarangan lako mesa tau illalan lembang iatoo, napolalan nasua lako bela' ma'pande bai. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Moraimi la ummande nande bai annu tadea' sigalimi. Sapo moi anna susimo tadea'na, tae' dengan tau umbenganni nande. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Katampakanna kilala pole' anna ma'kada nakua: ‘Buda to napopengkarang ambeku ummande tamampura-pura angku la bonno' mangngelomo kao inde rokkoe. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","La mengkalaona' lao umpellambi'i ambeku angku kuanni: O Ambe', kasalaanna' langngan Puang Allata'alla anna lako kalemu, ");
INSERT INTO mqjNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ta'mo' sipato' la mupoanak. Popengkarangmo' inde banuammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mengkalao siami lao umpellambi'i ambena. Mambelapi anna itami ambena, rantang siami buana napolalan tappa ke'de' anna kumondong lao untammui, naraka' anna udungngi. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nakuamo inde anakke: ‘O ambe', kasalaanna' langngan Puang Allata'alla anna lako kalemu. Ta'mo' sipato' la mupoanak.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sapo untambai sabua'na ambena anna kuanni: ‘Sirra'ko lao ummala pakean randan maleke ammu pabayuii, pasissinnii sola mupapalopakki. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ammu mane lao ummala iato saping dipelompoio ammu tunui annu la ma'dore'-dore'kia' ummande. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Annu inde anakkue sirapammi mangka bonno' sapo tuo sule, mangka pa'de sapo diitami sule.’ Naparanduk pole' ma'rame-rame. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Marassanni ma'rame-rame, saemi anak pa'bunga' dio mai bela'. Sikadappi'i banua, urrangngimi tulali anna gandangna to sumayo. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Untambaimi mesa sabua'na anna kutanaii nakua: ‘Maakaria tau?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nakuamo inde sabua'e: ‘Marassan tau ma'rame-rame annu saemi sule adimmu. Mangkami natunu ambemu saping dipelompoi annu mala mammi masakke anakna ma'pasule.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Keara' siami inde anak pa'bunga'e anna tae' naaku tama banua. Saemi ambena umpellambi'i anna bawaii tama banua. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sapo nakua lako ambena: ‘Ma'taummokkao umpengkarangangko anna tae'ko dengan kubali-bali. Sapo tae'nakkao dengan mubeen moi bekemo kupake ma'rame-rame sola solaku. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tapakala sae anakmu mangkanna ussembu'-sembu' ewanammu nabengan lako passundala', mutunuammi saping mangka dipelompoi.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Natimba' ambena nakua: ‘O anakku, sola liuki' kita lako. Angganna ewanan kuampui, iko siamo ummampuii. ");
INSERT INTO mqjNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sipato'ki' ma'dore'-dore' annu sirapammi mangka bonno' adimmu sapo tuo sule, pa'demi sapo diita sule.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mantula' omi Puang Yesus lako passikolana nakua: “Dengan mesa tomakaka, umpopengkarang mesa tau siummatosanni angganna ewananna. Sapo dengan sae tau untula'i kumua inde taue ussembu'-sembu' ewananna ponggawana. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Untambaimi inde to siummatosanni ewanannae anna kuanni: ‘Umba nakua pengkarangammu? Dengan kupekareba pa'palakomu. La muukisanna' angganna pa'palakomu ummato' ewanangku, annu ta'moko la kupopengkarang.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ma'pikki'mi inde to siummato' ewananne nakua: ‘Akamo la kupogau' temo annu ta'mo' la napopengkarang ponggawaku? La sumarona' tae' kubela, la kapelau-launa' makadere'na'. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Dengammi lalan kukabuttui anna malara dengan tau untarimana' dio banuanna ke ta'mo' napopengkarang ponggawaku.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pantan untambaimi to ma'indan lako ponggawana. Bunga'na sae, nakutanai nakua: ‘Pira indammu lako ponggawaku?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Natimba' nakua: ‘Saratu' busso minnak zaitun.’ Nakuammi: ‘Indemi sura' indammue, okko'moko ammu uki'i lima pulo busso.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nakuamo lako inde kaduannae: ‘Pira iko indammu?’ Natimba' nakua: ‘Sasa'bu karung gandum.’ Nakuammi: ‘Indemi sura' indammue, uki'mi karua ratu'na karung.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nasanga ori ponggawana keaka' moi anna tae' malolo pa'palakona sapo manarang ma'akkalan. Kutulasangkoa' inde tandenganne annu marru manarang ia ummakkalanni padanna to tamangngorean illalan lino anna la to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iamo too kupakari'di'koa' kumua: Popa'gunakoa' ewanammu illalan lino ungkamasei padammu. Annu ianna ta'mo ma'guna ewanammu la ditarima manappakoa' illalan angngenan la da'da' sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Benna-benna mala diorean ummato' kara-kara barinni', la diorean duka' ummato' kara-kara kamai. Sapo benna-benna tae' malolo ummato' kara-kara barinni', tae' duka' la malolo ummato' kara-kara kamai. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Dadi ianna tae'koa' mala diorean ummato' ewanan lino, bennamo la ummoreangkoa' ummato' ewanan tongan? ");
INSERT INTO mqjNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Anna ianna tae'koa' mala diorean ummato' ewananna tau senga', bennamo la umbengangkoa' ewanan la muampui? ");
INSERT INTO mqjNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tae' dengan sabua' la nabela umpengkarangan dua puang annu la naturu' manappa mesa, anna la napaboko'i penawa mesa. Battu' dikua marru la napakalando mesa anna tae' la naperangngii mesa. Susimokoa' duka', tae' la mubela umpalulangngan Puang Allata'alla penawammu ke mupasiolanni untombon ewanan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Angganna tula'na Puang Yesus narangngi asan to Farisi, sapo napetawai annu sangngin to kadoisan. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nakuamo Puang Yesus lako: “Ianna naitakoa' tau, siumpapiakoa' duka' panggauammu. Sapo nalosa penawammua' Puang Allata'alla. Annu iamo keangga' naita ma'rupa tau, meko'do'-ko'do' dio olona Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sura'na Musa anna sura'na angganna nabi dipake sae lako attunna ma'pa'guru Yohanes to simantedok. Naparandukmi attu iatoo dipalanda' Kareba Kadoresan diona kaparentaanna Puang Allata'alla, anna buda tau ma'kadua-dua la tama inde kaparentaannae. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sapo la madommi' pole ia pa'de langi' anna lino, anna la sabatta kada illalan sura'na Musa tokke' la dipa'dean. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Benna-benna ussisarakan bainena anna kebaine pole, tau iatoo ullullu' pa'bannetauan. Anna benna-benna umpobaine to mangka nasisarakan muanena, tau iatoo ullullu' duka' pa'bannetauan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mangkai too, mantula' pole omi Puang Yesus nakua: “Dengan mesa tomakaka, maleke liu pakeanna simasulli' allinna anna susi liu to ma'rame-rame allo bongi. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dio sa'de ba'ba balana, dipaokko' mesa to mase-mase disanga Lazarus, barubuan kalebu kalena, ");
INSERT INTO mqjNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","morai la ummande nande ronno'na inde tomakakae. Nakarompo' polepi asu nalepa'i mapa'di'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tapakala bonno'mo inde to mase-masee. Nabaami malaeka' langngan angngenan matande dio sa'dena Abraham yao suruga. Tae' masae bonno' duka' inde tomakakae napolalan dilamun. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Marassanni ussa'dingan kamaparrisan dio linona to mate, mentungngu langngammi napolalan ummita mambela Abraham ummokko' sitere Lazarus. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mealo'-alo'mi inde tomakakae nakua: ‘O ambeku Abraham, kamaseina'. Suai Lazarus ummoton tarunona rokko wai anna sae umpato'doianna' lilaku, annu mapa'di' sigali kusa'ding illalan api ma'lana-lana.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sapo natimba' Abraham nakua: ‘O anakku, pengkilalaii kumua mulambi' asammi iko angga mapianna ammu tuopa. Anna inde ia Lazarus-e angga kamaparrisan nasa'dingan. Temo ussa'dingammi kamasannangan anna ussa'dingmoko iko kamaparrisan. ");
INSERT INTO mqjNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Boko'pi garotin mandalan ummalla'ikia' anna malara tae' naissan tau lamban matin battu' lamban mai.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nakuamo inde tomakakae: ‘O ambe', ianna susi too, kupelau matin kenamala musuanna' Lazarus lao lako banuanna ambeku, ");
INSERT INTO mqjNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","annu limapi sirondongku la napakilala indana lu tama pole omo duka' inde angngenan kamaparrisanne.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sapo natimba' Abraham nakua: ‘Dengan sura'na Musa sola sura'na nabi naampui. Anna turu'mi too angga tiuki'na illalan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nakuamo inde tomakakae: ‘O ambeku Abraham, tae' la angga sura'. Sapo ianna dengammo to mate tuo sule lao umpakilalai mane mengkatoba'ri.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Natimba' Abraham nakua: ‘Ianna tae' naaku unturu' issinna sura'na Musa sola issinna sura'na nabi, moi la to mate tuo sule lao umpakilalai tala naoreanni.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ma'kadami Puang Yesus lako passikolana nakua: “Innang la dengan kara-kara untumang tau tobang tama kasalaan, sapo la sanggang to untumang tau umpogau' kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Malamia ke ditoke'i batu penulak illalan kollongna anna dipa'tibean tama tasik, anna la untumang mesa inde mai to malammae umpogau' kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Iamo too la madagakoa'. Kambaroangko sa'do'dorammu ke umpogau'i kasalaan lako kalemu. Ianna napenassanni, garri'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ianna pempitu umpogau' kasalaan lako kalemu sangngallo anna pempitu duka' sae mangngaku salana lako kalemu, la mugarri'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nakua asammo rasul lako Puang Yesus: “Pomatotosangkan kapangngoreanangki.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Natimba' Puang Yesus nakua: “Ianna dengan kapangngoreanammua' moi padamo lise' sawi, malakoa' ma'kada lako inde to' kayue: ‘Tirebu'ko ammu titanan illalan tasik.’ Tae' mala tala naturu'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nakua pole omo Puang Yesus: “Pa'rapanan dengangkoa' ummampui sabua' mupopariu battu mupopa'kambi'. Aka la mukuanni ke sulemi lako banua? La mukuaraka lako: ‘Sirra'ko mai ummande?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tae'. Sapo la mukuanni: ‘Patokanna' nandeku. Ma'kariri'ko ammu tarakannina'. Mangkapakkao ummande ammu mane iko mala ummande.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dengangkoka ma'kurru' sumanga' lako sabua'mu ke mangkami ungkarang angganna parentamu? ");
INSERT INTO mqjNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Susimokoa' duka' too. Ianna mangkamokoa' umpalako passanammu, la mukua: ‘Sabua' babangkan. Anggakan ungkarang passanan mangka dipalulako kaleki.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Illalan kapenonosanna langngan Yerusalem, ummundu'mi katonanna lembangna Samaria anna lembangna Galilea Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tamai mesa tondok, saemi sapulo to dolengan untammuii, ke'de' ungkambela Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","anna metamba-tamba nakua: “O Puang Yesus, Tuangguru, kamaseikan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nanenne'imi Puang Yesus anna ma'kada nakua: “Laomokoa' umpa'paitaan kalemu lako imam.” Ummolai lalan, mondami sakinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dengan mesa ummita kalena kumua mondami sakinna, tappa ma'pasule siami metamba-tamba umpakasalle Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","anna malimuntu' dio tingngayona Puang Yesus ma'kurru' sumanga' lako. Inde taue to Samaria. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma'kadami Puang Yesus nakua: “Anna kusanga sapulokoa' kupomalapu'? Umbami naola to kasera? ");
INSERT INTO mqjNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Maakari anna anggamo to salianna to Yahudi ma'pasule umpakasalle Puang Allata'alla?” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nakuamo Puang Yesus lako inde taue: “Ke'de'moko ammu lao, malapu'moko annu mangngoreangko lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pira-pira to Farisi umpekutanaan attu kasaeanna kaparentaanna Puang Allata'alla. Natimba' Puang Yesus nakua: “Tae' dengan tanda diita ke la naparandukmi ma'parenta Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","napolalan tae' dengan tau la ma'kada nakua: ‘Maikoa' umpetua'i, indemie’ battu nakua: ‘Illau'mio.’ Annu sitonganna illalammi alla'-alla'mua' kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mangkaii, ma'kadami Puang Yesus lako passikolana nakua: “La dengan attunna moraikoa' la ummita Anak Mentolino moi sangngallomo, sapo tae'a' la muita. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anna la nakuangkoa' tau: ‘Petua'ia', indemie’ battu nakua: ‘Illau'mio.’ Sapo daua' perangngii. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Annu kasaeanna Anak Mentolino la naita asan tau susi kila' pangngarrang mengkalao yaya tampakna langi' sae sau' tampak tandai sau'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sapo innang la ussa'dingampi kamaparrisan yolo sola natumpu pala' rupa tau lapik temo. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Inde attu kasaeanna Anak Mentolinoe susi anna tuopa Nuh. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Attu iatoo masannang ma'rupa tau, ummande, mangngiru', kebaine, kemuane sae lako anna tamamo kappala' Nuh. Tapakala sae wai untallanni asanni. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Susi siami duka' anna tuopa Lot. Ummande ma'rupa tau, mangngiru', mangngalli, ma'baluk, mantanan, ma'pake'de' banua. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sapo mallainna Lot illalan mai kota Sodom, saemi api sola belerang ussumpunni asanni. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La susimi duka' kasaeanna Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Allo iatoo, angganna to sirupang dio sali-sali ta'mo la tama banua ummala porewana. Susi duka' to sirupang dio bela', ta'mo la sule lako banua. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pengkilalaii aka dadi lako bainena Lot. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Benna-benna umpa'kadua-duai katuoanna illalan lino la ungkasayu'i katuoan sae lako-lakona. Sapo benna-benna untampean katuoanna illalan lino, la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kupokadangkoa' sitonganna, bongi iatoo, ianna dengan dua tau yao angngenan mammasan la dibaa lao mesa anna ditampe mesa. ");
INSERT INTO mqjNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ianna dengan dua baine marassan manggiling, la dibaa lao mesa, ditampe mesa.  ");
INSERT INTO mqjNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ianna dengan dua tau dio bela', la dibaa lao mesa, la dipatorro mesa.” ");
INSERT INTO mqjNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mekutana passikolana nakua: “O Puang, umba la nangei dadi itinno?” Natimba' Puang Yesus nakua: “Umba-umba angngenan nangei bangke, iamo nangei ma'karampo' kadoaya.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mangkai too, untetteran omi mesa tandengan Puang Yesus la naola umpa'guru passikolana kumua la tontong ma'sambayang anna tae' la kattu rannu. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nakua: “Illalan mesa tondok, dengan mesa pa'bisara to tae' mengkarea' langngan Puang Allata'alla anna tae' dengan tau nasanga. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dio tondok iatoo, dengan duka' mesa baine balu silao liu umpellambi'i inde pa'bisarae anna kuanni: ‘Popatalo siapa' dio mai balingku.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pempiran-piran ussumbala pelaunna inde baine balue, katampakanna ma'pikki' nakua: ‘Moika anna tae'na' mengkarea' langngan Puang Allata'alla anna tae' dengan tau kusanga, ");
INSERT INTO mqjNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sapo nasussai liuna' inde baine balue, dotami kupopatalo indana sae liu ussussaina'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mangkaii, nakuamo Puang Yesus: “Paillalan penawaia' tula'na inde pa'bisara tae' maloloe. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ta'raka la umpopatalo to napile Puang Allata'alla ke tontong liui melau langngan allo bongi? La ma'lembe-lemberika umpamoloii? ");
INSERT INTO mqjNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kutulasangkoa', la masimpan umpopatalo to napilei. Sapo ianna saemo Anak Mentolino la dengangka to ummoreanni nalambi' inde lino?” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mangkaii, untetteran pole omi tandengan Puang Yesus napalulako to ussanga kalena malolo anna umpa'barinni'i tau senga', ");
INSERT INTO mqjNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","nakua: “Dengan dua tau lao lako Banua Ada'na Puang Allata'alla ma'sambayang. Mesa to Farisi anna mesa tuang passima. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ke'de'mi inde to Farisie anna ma'sambayang illalan penawanna untede kalena nakua: ‘O Puang Allata'alla, ma'kurru' sumanga'na' matin annu tae'na' susi tau senga', tae'na' siuntengko tau, tae'na' ma'gau' kadake, tae'na' ullullu' pa'bannetauan, anna tae'na' susi inde dio tuang passimae. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sipenduanna' ma'puasa saminggunna anna siumpopemala'na' bare sapulona pallolongangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sapo ke'de' ia messala-sala inde tuang passimae lambisan marea' mentungngu langngan langi', anna ungkambei kalena umpenassanni gau'na nakua: ‘O Puang Allata'alla, kamaseina' annu to kasalaanna'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nakuamo Puang Yesus: “Kutulasangkoa' sitonganna, sulei lako banuanna, tuang passimaria naangga' malolo Puang Allata'alla, tanggia to Farisi. Benna-benna untandean kalena la dipa'barinni'i, anna benna-benna mengkareppe' la ditandean.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Saemi pira-pira tau umbaa ana'-ana' lako Puang Yesus annu la natamba'. Sapo naita passikolana napolalan nakeara'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sapo natambai Puang Yesus anna ma'kada lako passikolana nakua: “Pabeaii itin matin anak sae umpellambi'ina'o. Dau lawaii annu tau susimo tu matinno la mendadi petauanna Puang Allata'alla illalan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Annu kutulasangkoa' sitonganna, benna-benna tae' susi ana'-ana' untarima kaparentaanna Puang Allata'alla, tau iatoo tae' la tama.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dengan mesa perepi'na to Yahudi mekutana lako Puang Yesus nakua: “O Tuangguru to mapia penawa, aka la kupogau' angku malara ullolongan katuoan sae lako-lakona?” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Natimba' Puang Yesus nakua: “Maakari ammu kuanna' to mapia penawa? Tae' dengan to mapia penawa salianna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Manassa anna muissanammo angganna parentana Puang Allata'alla, susinna: ‘Dau ullullu' pa'bannetauan, dau papatean, dau maboko, dau sa'bi tatongan, pakasalleko indomu sola ambemu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nakuamo inde taue: “Mengkalao diopi mai barinni'ku angku turu' asammi tu matinno.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Narangnginna Puang Yesus tula'na, nakuammi: “Dengampi mesa tae' mupogau'. Baluk asanni ewanammu ammu tawanni to mase-mase allinna, ammu ullolongan ewanan yao suruga. Mangkaii saemoko ammu turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tappana urrangngi tula'na Puang Yesus, rosso siami buana annu tomakaka. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Naitanna Puang Yesus kumua rosso buana, ma'kadami nakua: “Marempang tongan-tongan to buda ewananna la tama kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Annu la madommi' pole ia unta lu tama tottok darun anna la mesa tomakaka tama kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nakuamo to urrangngi tula'na Puang Yesus: “Ianna susi too, bennara la mala dipasalama'?” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Natimba' Puang Yesus nakua: “Nakasumpui ia ma'rupa tau, sapo' tae' ia Puang Allata'alla annu tae' dengan tanaissan nagaragai.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nakuamo Petrus: “Untampe asammokangkami angga kiampuinna, angki turu'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma'kadami Puang Yesus nakua: “Kutulasangkoa' sitonganna, benna-benna untampe banuanna, battu bainena, sirondongnaraka, to matuannaraka battu anakna ura'na kaparentaanna Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","la nasondaianni Puang Allata'alla tiluppi'-luppi' illalan inde linoe. Anna illalan attu la sae la ullolongan katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Untambaimi inde sapulo dua passikolana Puang Yesus-e, anna pantula'i nakua: “La lu langngammikia' Yerusalem temo, anna angganna pangnguki'na nabi untetteran Anak Mentolino innang la lemba'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","La disorong rokko lisu pala'na to tae' ummissanan Puang Allata'alla la natelle sola napetawa-tawai anna tikkuduii. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","La nadarra-darra anna la napatei, sapo katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sapo tae' natamai akkalanna passikola inde tula'nae, annu ta'pa naissan napekalembasan. Tae' naissanan aka natula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","La ullambi' kalei tondok Yerikho Puang Yesus, dengammi mesa to buta ummokko' dio biring lalan kapelau-lau. ");
INSERT INTO mqjNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Urrangnginna buda tau liu, mekutanami nakua: “Maakaria tau?” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Natimba' inde mai to liu lalanne nakua: “Liu Puang Yesus to Nazaret.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mealo' siami nakua: “O Yesus peampoanna tomaraya Daud, kamasei siapakkao.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sapo nakeara'i to yolo, nasua mengkamma'. Sapo tuttuan napemandui mealo' nakua: “O peampoanna Daud, kamaseinakkao!” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Torromi Puang Yesus anna ussua tau umbaa inde to buta lako tingngayonae. Saei lako sa'dena nakutanaimi Puang Yesus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aka muporai la kupogau' lako kalemu?” Natimba' nakua: “O Tuang, moraina' la paita.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nakuamo Puang Yesus: “Paitamoko. Malapu'moko annu mangngoreangko lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Paita siami inde to butae. Unturu'mi Puang Yesus napasiolaan umpakasalle Puang Allata'alla. Inde kara-karae naita asan tau napolalan umpakasalle duka' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tamami tondok Yerikho Puang Yesus. Menono' liumi ummola inde tondokke. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Illalan inde tondokke, dengan mesa tomakaka, ponggawana tuang passima disanga Zakheus. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Morai duka' la ummita Puang Yesus sapo tae' dengan nalambi' annu to mareppe' anna buda tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kumondongmi yolo anna unteka'i to' ara anna malara ummita Puang Yesus ke liui. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Liui Puang Yesus dio inde sa'de to' kayue, mentungngu langngammi anna ma'kada nakua: “O Zakheus, ma'sirra'ko turun annu innang la lempangna' lako banuammu temo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tappa turun siami Zakheus anna dore' untarima Puang Yesus dio banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sapo sipa'nuku-nukuan to ummitai nakua: “Naakuria lao lako banuanna to kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ke'de'mi Zakheus anna ma'kada lako Puang Yesus nakua: “O Tuang, sapiakna ewanangku la kutawa-tawaan to mase-mase. Ianna dengan tau tokke' kuala aka-akanna, la kupasuleanni tiluppi' pennappa'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma'kadami Puang Yesus lako nakua: “Allo temo mellambi'mi kasalamasan lako issinna inde banuae, annu peampoanna duka' Abraham. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Annu kasaeanna Anak Mentolino la umpeang to pusa anna pasalama'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Untetterammi mesa tandengan Puang Yesus lako to marassan umperangngii annu nasanga tau la umpaombo'mi kaparentaanna Puang Allata'alla annu attu iatoo sikadappi'mi Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nakuamo Puang Yesus: “Dengan mesa turunan tau tongan la mendadi tomaraya dio tondokna, la lao dibassei bayu-bayu lako lembang senga' anna mane ma'pasule dio mai ke mangkami. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Untambaimi sapulo sabua'na anna benganni sandai simesa doi' bulawan anna kuanni: ‘Inde doi'e la mupakembea' ke le'bana'.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sapo budaria tau ungkabassii napolalan ussua tau ummula'i anna ma'kada lako to la umbasseii bayu-bayu nakua: ‘Tae' kiporai la kipotomaraya inde taue.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sapo diangka'ria mendadi tomaraya. Mangkaii ma'pasulemi lako tondokna. Ussuami tau untambai inde mai sabua'na to natampean doi'e annu la sireken battu pira nalolongan. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Saemi mesa inde sabua'e nakua: ‘O puang, mesa doi' bulawan mutampeanna' kupakembea' napolalan kulolongan sapulo doi' bulawan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Natimba' inde puangna nakua: ‘Mapia! Annu innang sabua' mapia tongangko. Malako diorean umpare' kara-kara barinni' napolalan temo la kuangka'ko umparenta sapulo kota.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Saemi duka' sabua' kaduanna anna ma'kada lako puangna nakua: ‘O puang, mesa doi' bulawan mutampeanna' kupakembea' napolalan kulolongan lima doi' bulawan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nakuamo puangna: ‘La kuangka'ko umparenta lima kota.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mangkaii, saemi sabua' katallunna ma'kada lako puangna nakua: ‘O puang, indemi doi'mue kuanna manappa kuputu' sapu'-sapu'. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Marea'na' matin annu kuissanan kumua to makarra'ko. Tokke'ko siummala tangngakammu anna tokke'ko sima'puppu' moi tangngia pantanammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nakuamo inde puangnae: ‘Sabua' kadake gau'ko. Tula'mu siamo la untumangko dipabambanni sangka'. Muissanammi kumua to makarra'na', tokke'na' siummala tangngakangku, tokke'na' sima'puppu' moi tangngia pantanangku. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Maakari anna tae' mubengan to umpa'peanakan doi' itin doi'ku anna malara kutarima sitonda anakna ke saemo' suleo?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Umpatarru'mi tula'na lako to sikake'de' dio inde angngenanne nakua: ‘Alaia' itin doi'o ammu benganni to ummampui sapulo doi' bulawan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Natimba' inde mai taue nakua: ‘O puang, sapulomia doi' bulawan naampui.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nakuamo inde tomarayae: ‘Kutulasangkoa' sitonganna, benna-benna mala diorean umpalako passanan dibeenni la dirangngannian polei. Sapo benna-benna tae' mala diorean umpalako passanan dibeenni, aka-aka dio kalena la dialai pissan. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Baa asannia' mai angganna ewalingku, to moka umpotomarayana' ammu pateii dio tingngayoku.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mangkai mantula' Puang Yesus, umpatarru'mi penonosanna langngan Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sikadappi'i tondok Betfage anna tondok Betania yao Tanete Zaitun, ussuami dua passikolana Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nakua: “Yolomokoa' lian itin sambali' tondokko. Ianna saekoa' lian, la ullambi'koa' mesa keledai mangngura ditole', ta'pa dengan leleanna disakei. Bukai balayanna ammu baaia' sambali' mai. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ianna dengan tau ungkuangkoa': ‘Maakari ammu bukaii?’ kuanni: ‘Naparallui Puangna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Le'bami inde to disuae, nalambi' tongammi susi tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Marassanni umbukai balayanna inde keledaie, nakuamo puangna: “Maakari ammu bukai itin keledaio?” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Natimba' nakua: “Naparallui Puangna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Umbaami keledai lako Puang Yesus, anna ummalai bayu rui'na nalapikkianni, anna mane umpalangngan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Menono'i inde keledai nasakei Puang Yesus-e, pantan ummalaimi bayu rui'na tau anna ampa'i dio lalan la naolanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","La ullambi' kalei Yerusalem diomi lalan yao mai Tanete Zaitun, naparandukmi ma'dore'-dore' anna metamba-tamba to unturu'i umpakasalle Puang Allata'alla ura'na tanda memangnga-mangnga mangka naita. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nakua: “Ditamba' tomaraya, to sae umpotendan sanganna Dewata. Malinomi suruga, dipakasalle Puang Allata'alla To ummokko' yao angngenan matande.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pira-pira to Farisi illalan alla'-alla'na tau buda ma'kada nakua: “O Tuangguru, popengkamma'i inde lako passikolamue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Natimba' Puang Yesus nakua: “Kutulasangko sitonganna, ianna mengkamma', inde mai batu la sipealo'-alosanne.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sikadappi'i Yerusalem Puang Yesus, ummitami inde kotae natangi'imi ");
INSERT INTO mqjNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","anna ma'kada nakua: “Kassi, tae' dengan pada maleke kela mupekalembasanni allo temo lalan la muola ullolongan kamasakkean. Sapo ta'pa mala muita temo annu tibunipi lako kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","La dengan attunna sae ewalimmu ungkarompo'koa', nabala batu tiku lao anna liling tamakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","La natallanni kotamu sola angganna issinna lambisan tae' dengan batu la tipatodo' yao batu senga', annu tae' muissanan kumua napellambi'imokoa' Puang Allata'alla la napasalama' temo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mangkai too, lu tamami pa'ranteanna Banua Ada'na Puang Allata'alla Puang Yesus anna urrambai to ma'baluk illalan mai. ");
INSERT INTO mqjNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma'kadami nakua: “Dengan tiuki' illalan Buku Masero nakua: ‘Banuangku la nangei ma'rupa tau ma'sambayang’, sapo mungeiria' iko ma'tengko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma'pa'guru liumi Puang Yesus ke allo illalan Banua Ada'na Puang Allata'alla. Morai asammi kapala imam sola to untarru' issinna sura'na Musa anna to naangga' to Yahudi la umpatei Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","sapo tae' naissanan umba la napasusi napatei annu lu lako asammi Puang Yesus penawanna tau anna morai liu la umperangngii tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pissan attu ma'pa'guru omi Puang Yesus illalan Banua Ada'na Puang Allata'alla anna umpalanda' Kareba Kadoresan lako tau buda. Saemi pira-pira kapala imam anna to untarru' issinna sura'na Musa sola perepi'na to Yahudi umpellambi'i ");
INSERT INTO mqjNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","anna ma'kada lako nakua: “Tulasangkan kakuasaan aka mupake umpogau' inde mai kara-karae anna benna umbeengko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Natimba' Puang Yesus nakua: “La kukutanaikoa' duka'. Pokadanna' ");
INSERT INTO mqjNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","lu umbai ngei kakuasaan napake Yohanes mantedok? Lu yaorika mai Puang Allata'alla, lu diorika mai ma'rupa tau?” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Sipantula'-tula'mi nakua: “Ianna tatimba' kumua kakuasaanna Puang Allata'alla, la nakuangkia': ‘Maakari anna tae' muorean?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sapo ianna tatimba' kumua kakuasaanna ma'rupa tau, la nasileba'-leba'ikia' batu tau annu naorean asan kumua Yohanes mesa nabi.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Mentimba'mi nakua: “Tae' kiissanan lu umbai ngei kakuasaan napake Yohanes.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nakuamo Puang Yesus: “Ianna susi too, tae'koa' duka' la kutulasan benna umbeenna' kakuasaan kupolalan umpogau' inde mai kara-karae.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mangkai too, untetterammi mesa tandengan Puang Yesus lako tau buda nakua: “Dengan mesa tau umpadadi bela' anna untanan anggur. Mangkai natananni, napa'petesanammi lako pira-pira tau anna mane mengkalao lako tondok mambela anna torro dio masae. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nalambi'i attunna matua bua anggur, ussuami sabua'na lao ummalanni tawana lako inde to mantesanne. Sapo saei lako, natumbuimi to mantesan anna mane suai sule ma'pala' lo'bang. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ussua pole omi sabua' senga'na inde puangna bela'e, sapo natumbui duka' to mantesan anna pakasiri'i anna mane suai sule ma'pala' lo'bang. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ussua pole omi sabua'na katallunna, sapo natumbui duka' lambisan nabalalai anna mane tibei lako salianna bela'. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nakuamo inde puangna bela'e: ‘Akamo pole' la kupogau'? La ussuamo' anak pa'kaboro'ku, annu innang la nakalaya'na.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sapo naitanna to mantesan, sipantu'-tula'mi nakua: ‘Iamo te la ummala ewananna ambenae. Anta pateia'i anna malara kita ummampui inde bela'e.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Narui'mi lako salianna bela' anna mane pateii.” Mekutanami Puang Yesus nakua: “Akamo la napogau' inde puangna bela' lako to mantesannae? ");
INSERT INTO mqjNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","La sae napatei anna mane pa'petesanan pole bela'na lako tau senga'.” Nakuamo to urrangngii: “Tae' dengan leleanna la dadi susi.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sapo nanenne'i Puang Yesus anna ma'kada nakua: “Ianna susi too, akamo kalembasanna battakada illalan Buku Masero nakua: ‘Batu pantibeanna tukan, diala dipobatu lentong.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Benna-benna metobang untappai inde batue la polo-polo, anna benna-benna natappai la manisak.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Umpeangmi lalan kapala imam sola to untarru' issinna sura'na Musa la ussakka Puang Yesus attu iatoo annu naissanan kumua kalena napatu tandengan natetteran Puang Yesus, sapo marea' lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Umpeang liumi lalan to untarru' issinna sura'na Musa sola kapala imam la umpaalinni kasalaan Puang Yesus. Ussuami pira-pira tau sirapan to malolo lao umpellambi'i Puang Yesus anna mekutana lako annu la napetidon tula'na anna malara napealai anna baai lako olona gubernur. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma'kadami inde mai taue nakua: “O Tuangguru, kiissanan kumua tonganna asan tula'mu sola pepa'guruammu. Kiissanan toi kumua tae'ko ma'pebulu-bulu, anna simuundu' lollong untetteran lalan-lalan situru'na pa'kuanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iamo too, la mekutanakan matin: Situru' atoran alukta, malarika tau umbaya' sima lako tomaraya dio Roma, ta'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sapo naissanan Puang Yesus pikki' kadakena, napolalan ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Paitaina' mesa dinar.” Mangkai napetua' mekutanami nakua: “Benna kerupa anna benna kesanga dio?” Natimba' nakua: “Rupanna anna sanganna tomaraya Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nakuamo Puang Yesus: “Ianna susi too, bengannia' tomaraya la sipato'na lu lako, ammu bengannia' duka' Puang Allata'alla la sipato'na lu lako.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tae' dengan tula'na Puang Yesus la mala napetidon dio tingngayona tau buda, sangngadinna kanonnong babangmi anna mangnga-mangnga urrangngii tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mangkai too, saemi umpellambi'i Puang Yesus pira-pira to Saduki, to tae' ummorean katuoanna sule to mate. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ma'kadami lako Puang Yesus nakua: “Dengan parenta naukisangkia' Musa illalan sura'na nakua: ‘Ianna dengan tau bonno' anna tae' dengan anakna, sirondongna siamo la umpobainei bainena anna malara dengan peampoanna.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pissan attu dengan pitu to ma'sirondong. Kebainemi pa'bunga', sapo ta'pa dengan anakna anna bonno'mo. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Napobainemi dampi' pa'bunga' bainena, sapo tae' duka' dengan anakna anna bonno'mo. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Napobaine pole omi duka' adinna, anak katallunna, sapo susi siami tae' dengan anakna anna bonno'mo. Nakua liumo tee sae lako anak tampak, tae' asan dengan anak nasibalii inde mesa bainee. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Katampakan bonno' duka' inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ianna tuo asammo sule to mate, benna tappa'mo te muanena inde bainee? Annu mangka asammi napobaine inde pitu to ma'sirondongnge.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Natimba' Puang Yesus nakua: “Inde to tuo illalan lino temoe, kebaine anna dipakemuane. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sapo angganna to sipato' dipatuo sule dio mai alla'na to mate anna tuo illalan lino bakaru ta'mo ia la kebaine tala dipakemuane. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Annu la susimi malaeka', ta'mo dengan leleanna la bonno'. Napoanakmi Puang Allata'alla annu mangkami dipatuo sule dio mai kamatean. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Katuoanna sule to mate, mangka duka' napa'peassakan Musa illalan sura'na untetteran to' duri ma'lana-lana. Illalan inde sura'nae napomaleso kumua Puang Allata'allamo Dewatanna Abraham, Dewatanna Ishak, anna Dewatanna Yakub. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dadi tangngia Dewatanna to mate, sangngadinna Dewatanna to tuo annu tuo liu ia tau dio olona Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma'kadami pira-pira to untarru' issinna sura'na Musa lako Puang Yesus nakua: “O Tuangguru, tonganna petimba'mu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ta'mo pole' dengan barani mekutana pole lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mekutanami Puang Yesus nakua: “Umba nakua lalanna anna nakua tau: ‘Peampoanna tomaraya Daud To dibassei bayu-bayu la ma'pasalama'?’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Annu melolo tomaraya Daud ma'kada illalan sura' Pampudian nakua: ‘Ma'kada Puang Allata'alla lako Puangku nakua: Okko'ko dio tandai kanangku ");
INSERT INTO mqjNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","angku lukkoangko angganna ewalimmu dio tingngayomu.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dadi ianna mekapuang tomaraya Daud lako To dibassei bayu-bayu la ma'pasalama', umbamo nakua anna la dikua pole omo peampoanna tomaraya Daud?” ");
INSERT INTO mqjNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Marassampi ma'perangngi tau buda, ma'kadami Puang Yesus lako passikolana nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Matangkingkoa' lako to untarru' issinna sura'na Musa. Annu anggami naporai lu rekke lu sau' ma'bayu rui' leen anna naporai napa'tabe'i tau tama pasa'. Sinaporai ma'loko dio tingngayo illalan banua pa'sambayangan, anna manggi'mo ma'loko yaya pengnguluan ke ullombai sara'. ");
INSERT INTO mqjNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anna ma'puduk mammi' maneko lila lako baine balu napolalan sae lako banuanna naala. Siumpakalandomi sambayangna la naola umbuni kakadakeanna lako tau. Tau susi too innang la untarima pandarraan mabanda'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Inde anna illalan Banua Ada'na Puang Allata'alla Puang Yesus-e, ummitami tomakaka umpatama patti pemalasan bua pemala'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ummitami duka' mesa baine balu mase-mase polepi umpatama patti pemalasan dua doi' gallang randan wiring rokko. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma'kadami Puang Yesus nakua: “Kupokadangkoa' sitonganna, marru buda ia bua pemala'na inde baine balue anna inde lako taue. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Annu la'binna ia napopemala' itin lako tomakakao, sapo inde ia baine balue napebengan asammia moi kenada anggamo la napotuo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Dengan pira-pira tau marassan untula' umba nakua malekena Banua Ada'na Puang Allata'alla annu dipalekke'i batu simaleke anna porewa napopemala' tau. Ma'kadami Puang Yesus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Itin lako banua maleke muitao, pissan attu la diroppokan napolalan ta'mo dengan batu la tipatodo' yao batu senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mekutanami inde lako taue nakua: “O Tuangguru, piran la lemba' itin tula'muo? Aka tandana kumua la nalambi'mi attunna?” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Natimba' Puang Yesus nakua: “Matangkingkoa' indana papusakoa' tau. Annu la buda tau sae umposanga sangangku nakua: ‘Kaomo To dibassei bayu-bayu ma'pasalama'.’ La nakua toi: ‘Madappi'mi attunna.’ Daua' perangngii. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ianna umpekarebakoa' to sibundu'-bundu' anna to siala-ala, daua' marea' annu innang la dadi yolo sapo tangngiapi allo ma'katampakanna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Umpatarru'mi tula'na Puang Yesus nakua: “La sibundu'-bundu' tau sipa'barean tondok-ma'tondok, anna kaparentaan la sibundu' kaparentaan senga'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Umba-umba angngenan la nangei dadi lino' kamai anna la kendek saki palelean anna karorian. La dengan duka' tanda ma'patikkedu' anna mekarea'-rea' yao langi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sapo la disakkakoa' sola didarra yolo anna mane dadi inde mai kara-karae. La dibaakoa' lako tingngayona pa'bisara aluk ammu mane dipatama tarungkun. La dibaakoa' duka' lako tingngayona to ma'parenta annu muturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Attu iamo too la nangei dengan palliwangammua' untetteranna' lako. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Iamo too daua' pomasussa penawammu umpikki' umba la mukua umpa'timpasan kalemu. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Annu Kao la melolo umbengangkoa' tula' sola kakeakasan napolalan tae' naissan natimba' balimmu. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","La napa'perososangkoa' to matuammu sola sirondongmu anna sa'do'dorammu anna angganna solamu anna la dengangkoa' napatei. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","La nakabassikoa' angganna tau annu' muturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sapo moi la salamba' beluakmua' tae' dengan la ronno'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ianna tontong liukoa' mentoe manda' mengnganti matoto' illalan kapangngoreanammu, la ullolongangkoa' katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ianna ummitamokoa' Yerusalem naliling tama tantara, muissanammia' kumua ta'mo masae anna pa'demo. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Attu iatoo angganna to dio Yudea la sikakondong langngan tanete anna angganna to illalan kota la sirri' anna angganna to torro lako salianna kota tae' la lu tama kota. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Annu attu iamo too la nangei Puang Allata'alla umpabala'i gau' kadakena to Israel anna malara lemba' battakada tiuki' illalan Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Masussa tongan-tongan to manambuk anna to ma'pasusu attu iatoo. Annu inde lembangnge la nalambi' kamasussaan kamai anna ara' kamainna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Buda tau la bonno' dibatta anna dengan duka' la nabaa tantara lako ma'rupa-rupa pellembangan. Anna inde Yerusalem-e la nasilullu'-lullu'i to tangngummissanan Puang Allata'alla sae lako attu mangka napatantu Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Umpatarru'mi tula'na Puang Yesus nakua: “La kendek tanda memangnga-mangnga lako mata allo, bulan, anna angganna bentoen anna la marea' sitonda mangnga-mangnga ma'rupa tau illalan lino ummita bombang anna urrangngi urrunna wai dio tasik. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","La sikalimpang tau marea' umpenawa-nawaan kara-kara la dadi illalan lino annu ta'mo la menggalattuan issinna langi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Attu iamo too la nangei ummita Anak Mentolino ma'rupa tau turun yao mai langi' illalan gaun sitonda kakuasaan anna kamatandeanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ianna naparandukmo te kadadianne, ke'de'mokoa' ammu mentungngu langngan annu la dipasalama' kalemokoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Untula'mi mesa tandengan Puang Yesus nakua: “Petua'ia' kayu ara battu kayu senga', ");
INSERT INTO mqjNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ianna kendaun randangmo muissanammia' kumua la kulla'mi allo. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Susimi duka' ke ummitamokoa' inde kara-kara la dadie, muissanammia' kumua la sae kalemi kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kutulasangkoa' sitonganna, ta'pa la pa'de to tuo lapik temo anna lemba' asammo inde mai kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langi' anna lino la pa'de, sapo battakadangku la da'da' sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ma'kada pole omi Puang Yesus nakua: “Daua' umpatutui penawa karoasan, sola mangngiru' anna umpikki' katuoammu illalan lino indana patikkedu'koa' kasaeangku ke tokke'mi lemba' susi poya lu'bi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Annu inde allo kasaeangkue la ummangka asan ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","La tontong liukoa' matangkin mupasiolaan ma'sambayang ammu malara ummampui kamatoroan untingngayo inde kara-kara la dadie anna la matoto'koa' duka' ke'de' dio tingngayona Anak Mentolino.” ");
INSERT INTO mqjNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sima'pa'guru liumi Puang Yesus illalan Banua Ada'na Puang Allata'alla ke allo, anna silulangngan Tanete Zaitun ma'bongi. ");
INSERT INTO mqjNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Simebongngi'mi tau buda sae umpellambi'i illalan Banua Ada'na Puang Allata'alla annu la naperangngii. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","La madappi'i allo kamai disanga Roti Tae' Diboloi Ragi battu dikua Allo Paskah, ");
INSERT INTO mqjNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","umpeangmi lalan kapala imam sola to untarru' issinna sura'na Musa la umpatei Puang Yesus annu marea' umpa'manta-mantanni lako tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naluangmi ponggawana setang penawanna Yudas Iskariot, to nakala' bilanganna sapulo dua passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Laomi umpellambi'i kapala imam sola kapalana to siundagai Banua Ada'na Puang Allata'alla anna sipantula' umba la nakua Yudas umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dore' asammi anna ma'dandi la umbengan doi' Yudas. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nasituru'imi Yudas, napolalan umpeangmo attu maliwang la nangei umpa'pesorongan Puang Yesus tae'na la naissanan tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tapakala nalambi'mo allo kamai disanga Roti Tae' Diboloi Ragi, iamo allo sinangei untunu domba to Yahudi la naande ke allo Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ussuami Petrus anna Yohanes Puang Yesus nakua: “Laomokoa' umpatokangki' nande Paskah.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mekutanami lako Puang Yesus nakua: “Umbanna angngenan muporai la kingei umpatokai?” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Natimba' Puang Yesus nakua: “Ianna tamamokoa' kota, la sitammukoa' muane umbaa busso kaissi wai. Ula'mi too sae lako banua nangei torro, ");
INSERT INTO mqjNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ammu kuanni to ma'banua, umbanna ade' salanta' banuammu la nangei ummande nande Paskah Tuangguru sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","La napaitaimokoa' to angngenan kalua' yao tanda langnganno toka asammi porewa illalan. Iamo la mungei umpatoka nande.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mengkalaomi Petrus sola Yohanes, nalambi' tongammi susi tula'na Puang Yesus. Umpatokami nande Paskah dio. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nalambi'i attunna, ummandemi nande Paskah Puang Yesus sola sapulo dua rasulna. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma'kadami nakua: “Innang kuinawa-nawa la ma'mesakia' ummande inde nande Paskah-e, angku mane didarra-darra. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Annu kupokadangkoa' sitonganna, ta'mo dengan la kuande pole ke ta'pa lemba' aka naitaan inde nandee illalan kaparentaanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ummalami irusan kaissi anggur Puang Yesus anna ma'kurru' sumanga', anna mane ma'kada nakua: “Alaia' indee ammu palelei muiru'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Annu kupokadangkoa'i, mengkalao temo ta'mo' dengan la ummiru' anggur sae lako attunna ma'parenta Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ummalami roti anna ma'kurru' sumanga' anna mane piak-piakki nabeen lako rasulna, napasiolaan ma'kada nakua: “Iamo te batang kalekue kupebeen la ussulangkoa'. Pogau'mia' tee la muola umpengkilalaina'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Susi siami duka' irusan, mangkanna ummande naalami anna ma'kada nakua: “Inde irusanne iamo pa'dandi bakaru nasa'bii raraku, la dipato'do la ussulangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sapo perangngi manappaia', solana' temo ummande to la umpa'perososanna'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Annu Anak Mentolino innang la mate susi mangka napatantu Puang Allata'alla. Sapo la sanggang to umpa'perososanni.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Naparanduk pole' sipantula'-tula' rasul kumua benna la umpogau' inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sipekka-pekkami passikolana Puang Yesus kumua benna to la sipato' diangga' randan matande illalan alla'-alla'na. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma'kadami Puang Yesus lako nakua: “Angganna tomaraya illalan lino ma'inawa pawa umparenta rupa taunna anna angganna to ma'kuasa ummangga' kalena umpa'kadua-duai ma'rupa taunna. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sapo tae'koa' iko la susi, sangngadinna inde to diangga' matande illalan alla'-alla'mua'e la mengkareppe' anna to diangga' perepi' la messabua'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Annu umbanna randan matande: to ma'lokoraka ummande, to mantarakanniraka? Manassa anna to ma'loko. Sapo illalannakkao alla'-alla'mua' temo untarakannikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ikomoa' tontong matutu ussolanna' illalan angganna kamasussaangku. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kubengangkoa' kakuasaan ma'parenta susi Ambeku umbenganna' kakuasaan ma'parenta, ");
INSERT INTO mqjNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","anta malara sola ma'loko ummande anna ummiru' illalan kaparentaangku. Anna la pantan ummokko'koa' yao tongkonan layuk annu la umparentakoa' peampoanna sapulo dua kabuttuanna to Israel.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma'kadami Puang Yesus lako Simon Petrus nakua: “O Simon perangngi manappai, dibengammi palliwangan ponggawana setang la ussudikoa' sirapan gandum ditappii. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sapo mangkamoko kupa'sambayangan anna malara tae' pa'de kapangngoreanammu. Ianna mengkatoba'moko la umpakatoto'ko sa'do'dorammu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Natimba' Petrus nakua: “O Puang, moi la ditarungkungki' lambisan dipateiki' sola innang tae'ko dengan leleanna la kupemboko'i.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Sapo nakua Puang Yesus lako: “O Petrus, paillalan penawai inde tula'kue: ta'pa moni manuk mani bongi anna pentallummo' mutelang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Anna mane mantula' pole lako passikolana nakua: “Iato angku suakoa' yolonao, tae'koa' kupabeai umbaa angngenan doi', bakku' anna sandala'. Dengangka tae' ganna' kaparalluammua'?” Natimba' passikola nakua: “Tae' dengan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nakuamo Puang Yesus: “Sapo temo baakoa' angngenan doi' iaraka anna bakku' ke dengan muampui. Ianna tae' dengan pa'dangmua', balukkoa' bayu rui'mu ammu allianni. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Annu kutulasangkoa' innang la lemba'mi lako kaleku battakada illalan Buku Masero nakua: ‘La diangga' to kadake gau'.’ Annu inde battakada illalan Buku Masero untetteranna'e, marassammi lemba'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nakuamo passikolana: “O Puang, dengammi dua pa'dang.” Natimba' Puang Yesus nakua: “Siruamia'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mangkai too, umpelleimi kota Yerusalem Puang Yesus sola passikolana le'ba langngan Tanete Zaitun susi sibassa' napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Saei langngan tanete, nakuamo Puang Yesus lako passikolana: “Ma'sambayangkoa' indana taloikoa' passudian umpogau' kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ussereammi kalena Puang Yesus ungkambela-bela passikolana, anna malimuntu' ma'sambayang ");
INSERT INTO mqjNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","nakua: “O Ambeku, ianna ma'dingko rappananna' dio mai kamasussaan kutingngayo temo. Sapo tangngia pa'kuangku la dadi sangngadinna pa'kuammu.”  ");
INSERT INTO mqjNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Saemi mesa malaeka' yao mai suruga umpakatoto'i. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Masussa tongan-tongan nasa'ding Puang Yesus napolalan tuttuan napetonganni ma'sambayang. To'do-to'domi appu'na rokko litak susi rara. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mangkai ma'sambayang, ke'de'mi anna ma'pasule lao umpellambi'i passikolana, sapo mamma' asan annu tikkaru'du'mi napobua' kamasussaanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nakuamo Puang Yesus: “Maakaria' ammu mamma'? Millikkoa' ammu ma'sambayang indana taloikoa' passudian umpogau' kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Marassampi mantula' Puang Yesus, anna saemo buda tau nayoloanan Yudas, to nakala' duka' sapulo dua passikolana Puang Yesus. Tarru'mi Yudas lao umpellambi'i Puang Yesus la naudung. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sapo ma'kada Puang Yesus lako nakua: “O Yudas, pangngudungmumoka la mupake ussorongan Anak Mentolino?” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tappana naissanan angganna passikolana aka la dadi lako Puang Yesus, nakuamo: “O Puang, la kibattamika?” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Umbonok siami pa'dangna mesa passikola anna umbatta sabua'na Pongkena Imam napolalan mallai talinga kananna. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sapo ma'kada Puang Yesus nakua: “Siruami.” Anna mane untoe talinganna inde taue tappa malapu' siami sule. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mangkaii, ma'kadami Puang Yesus lako kapala imam sola kapalana to siundagai Banua Ada'na Puang Allata'alla anna lako perepi'na to Yahudi to la sae ussakkai nakua: “Musanga to kadakerakka ammu sitonda pa'dang sola bose la sae ussakkana'? ");
INSERT INTO mqjNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kusanga sisola liukia' illalan Banua Ada'na Puang Allata'alla keallo. Maakari anna tae'na' muala illalan? Sapo temo nalambi'mi attummua' la ma'palako, attunnamo ma'kuasa kamalillinan battu dikua ponggawana setang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dialami Puang Yesus anna dibaa lako banuanna Pongkena Imam. Naula' manarangmi Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Untuemi api tau illalan tangnga pa'ranteanna banuanna Pongkena Imam anna ma'loko ullilingngi. Laomi duka' lako Petrus anna ma'loko sola. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dengan mesa sabua' baine ummita Petrus mendarang. Napetua'-tua'mi anna mane ma'kada nakua: “Inde taue sisola liu duka' Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sapo tappa mantelang Petrus nakua: “Tangkao, tae' kao kuissanan itin tauo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tae' masae, naita pole omi mesa tau. Nakuammi: “Solanako duka'.” Sapo natimba' Petrus nakua: “Tae', tangkao.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Umbai satettekki mangkanna, ma'kada pole omi mesa tau nakua: “Manassa anna solana Yesus inde taue, annu to Galilea duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sapo natimba' Petrus nakua: “Tangkao, tae' kupekalembasan itin tula'muo.” Ta'pa lappa' pudukna Petrus anna ma'tottoro'mo manuk. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Messailemi Puang Yesus unnenne'i Petrus. Ungkilalai siami tula'na Puang Yesus Petrus nakua: “Ta'pa moni manuk anna pentallummo' mutelang.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Le'ba siami lako salian Petrus anna ma'pase'gok-se'gok tumangi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Untelle-tellemi anna ungkaka' Puang Yesus inde mai to undagaie. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Natutu'iammi matanna anna kuanni: “Ianna nabinnako Puang Allata'alla, tula'i benna ungkaka'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anna budapa pa'telle senga' lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Masiangngi, ma'mesami pa'bisara aluk, susinna perepi'na to Yahudi, kapala imam, anna to untarru' issinna sura'na Musa. Dibaami Puang Yesus lako olona inde pa'bisarae. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mekutanami lako Puang Yesus nakua: “Tulasangkan sitonganna, Ikomoka To dibassei bayu-bayu la ma'pasalama'?” Natimba' Puang Yesus nakua: “Moi la kutulasangkoa' innang tae'a' la muorean. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ianna mekutanana' matin, innang tae'koa' duka' la mentimba'. ");
INSERT INTO mqjNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sapo mengkalao temo la ummokko'mi Anak Mentolino dio tandai kananna Puang Allata'alla to randan ma'kuasa.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nakuamo inde mai to ma'mesae: “Ianna susi too, Anaknako Puang Allata'alla?” Natimba' nakua: “Anna ikomoa' untula'i kumua Anaknana' Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nakua asammo inde to ma'mesae: “Ta'mo manggi' dengan sa'bi annu tarangngi asammia' tula'na.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mangkai too, ke'de' asammi inde to ma'mesae anna ussolaan Puang Yesus lako Pilatus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Saei lako, naparanduk pole' napatampoi kasalaan nakua: “Inde taue siumpapusa tau buda, tae' umpabeai tau umbaya' sima lako tomaraya, anna ummangga' kalena Kristus, battu dikua tomaraya.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mekutanami Pilatus lako Puang Yesus nakua: “Ikomoka tomarayanna to Yahudi?” Natimba' nakua: “Ikomo melolo ungkuai.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nakuamo Pilatus lako kapala imam sola lako tau buda: “Tae' dengan kulambi' kasalaanna inde taue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sapo napempassaan liu nakua: “Pepa'guruanna inde taue urrasi tau kamban illalan lembangna Yudea, mengkalao dio Galilea anna saemo inde.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tappana narangngi Pilatus tula'na, napekutanammi kumua to Galilearaka inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Naissananna Pilatus kumua to lu dio mai lembang naparenta Herodes, nasua lakomi annu sirupang duka' dio Yerusalem Herodes attu iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Dore'mi Herodes ummita Puang Yesus, annu masaemi napekareba anna morai la ummitai. Anna nainawa-nawa duka' kela dengan siapa naita umpogau' tanda memangnga-mangnga. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Buda pekutananna Herodes sapo tae' tappa' dengan natimba' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ke'de' asammi kapala imam sola to untarru' issinna sura'na Musa anna umpatampoi kasalaan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Umpetawa-tawaimi Puang Yesus Herodes sola tantarana sola natelle-telle. Napapakeimi bayu rui' susi bayunna tomaraya anna mane suai sule lako Pilatus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Allo ia siamo too anna sikapia Herodes anna Pilatus, annu ambo' sikabassi. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Urrempummi kapala imam sola perepi'na to Yahudi anna tau buda Pilatus, ");
INSERT INTO mqjNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","anna ma'kada lako nakua: “Mangkamia' mubaa sae inde taue annu mutanda' umpapusa tau. Muita siamia' kuparessa anna tae' dengan kulambi' kasalaan situru' pa'tanda'mua' lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tae' duka' dengan nalambi' kasalaanna Herodes annu napasulemi lako kaleta. Sitonganna tae' dengan kasalaan napogau' la dipolalan umpateii. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iamo too, la kuombangmi angku mane rappananni.”  ");
INSERT INTO mqjNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Siurrappanan mesa to ditarungkun Pilatus ke nalambi'i Allo Paskah situru' pelaunna tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sapo napissanni sipealo'-alosan nakua: “Pateii. Barabasmo rappananangkan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ia dingei untarungkun inde Barabas-e annu umbali to ma'parenta illalan kota anna papatean. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Umpantula'i polepi tau buda Pilatus pissan annu morai tappa' la urrappanan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sapo sipeolo'-alosan untimba'i nakua: “Pasokki lako kayu pantokesan! Pasokki lako kayu pantokesan!” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nakuamo Pilatus kapentallunna: “Aka tappa' kasalaanna inde taue? Tae' dengan kulambi' kasalaanna la dipolalan umpateii. La kuombangmi angku mane rappananni.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sapo sipealo'-alosan umpempassaan pa'kuanna kumua la dipasok lako kayu pantokesan napolalan dituru'. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Napopa'lesoammi Pilatus unturu' pa'kuanna inde mai taue. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Urrappanammi to ditarungkun annu umbali to ma'parenta illalan kota sola papatean situru' pelaunna tau buda anna ussorong Puang Yesus lako la napatei situru' pa'kuanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dibaami Puang Yesus lako salian kota. Ummolai lalan, sitammumi mesa to Kirene disanga Simon la lu tama kota Yerusalem. Napatorromi anna papassanni kayu pantokesan anna suai unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Buda tau unturu'i, dengan duka' baine marassan untangi'i sola umbatingngii. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nasailemi Puang Yesus anna ma'kada lako nakua: “O baine to Yerusalem, daua' tangi'ina' sapo tangi'ikoa' kalemu sola anakmu. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Annu la dengan attunna la nakua tau: ‘Kerongko' angganna baine tamanang anna to tae' dengan ma'pasusu.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Attu iatoo, la ma'kada tau lako tanete nakua: ‘Roppokkikan mai,’ anna lako buntu-buntu nakua: ‘Tambunnikan.’ ");
INSERT INTO mqjNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Annu ianna kayu tuomo dipasusi indee, la ondongpi ia lako kayu marekko'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dengan duka' dua to kadake dibaa la dipatei sola Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Saei lako mesa angngenan disanga Karorak Ulu, umpasokmi Puang Yesus lako kayu pantokesan sola inde dua to kadakee, mesa dio tandai kananna Puang Yesus mesa dio tandai kairinna. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma'sambayangmi Puang Yesus nakua: “O Ambeku, garri'ianni kasalaanna inde mai taue annu balan tanaissananna nangei ma'palako.” Naundimi tantara pakeanna la naola untawa-tawai. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ke'de'mi tau buda umpetua'i. Untelle-tellemi Puang Yesus perepi'na to Yahudi nakua: “Umpasalama' ade' tau senga'. Ianna to napile tongan Puang Allata'alla anna To dibassei bayu-bayu la ma'pasalama', la umpasalama'mi duka' kalena temo.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Natelle-tellemi duka' tantara anna benganni anggur maissuk, ");
INSERT INTO mqjNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","anna kuanni: “Ianna tomarayannako to Yahudi rappanangko kalemu.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dengan duka' pangnguki' yao tondonna nakua: Iamo Te Tomarayanna To Yahudie. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Natelle-tellemi duka' mesa to kadake nasolaan ditoke' nakua: “Anna to dibasseiko para' bayu-bayu la ma'pasalama'? Rappanammoko kalemu ammu rappanangkan duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sapo nakambaroan solana nakua: “Ta'rokoka marea' langngan Puang Allata'alla annu dipabambannimiki' sangka' dipatei sola? ");
INSERT INTO mqjNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sipato'ki' kita dipatei annu situru' panggauanta, sapo inde ia taue, tae' ia kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Anna mane ma'kada lako Puang Yesus nakua: “O Puang Yesus, kilalainakkao ke saemoko ma'parenta.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Natimba' Puang Yesus nakua: “Kupokadangko sitonganna, allo temo solamiki' illalan angngenan kamasannangan disanga Firdaus.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Attu iatoo umbai tettek sapulo duamo allo, malillimmi dio inde pellembanganne sae lako tettek tallu karuen ");
INSERT INTO mqjNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","annu tae' pangngarrang mata allo. Sampin pesapa' illalan Banua Ada'na Puang Allata'alla sesse' tipa'dua. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Metambami Puang Yesus nakua: “O Ambeku, kusorongmi penawangku rokko lisu pala'mu.” Mangkai mantula' kattumi penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Naitanna ponggawana tantara inde kara-karae, umpakasallemi Puang Allata'alla nakua: “To malolo tongan inde taue.” ");
INSERT INTO mqjNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Inde anna ummitamo kara-kara dadi tau buda to sae umpetua'ie, menassammi anna ma'pasule ungkambei kalena. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sapo angganna siissananna Puang Yesus sola pira-pira baine to ummula'i dio mai Galilea ke'de' mambela-bela umpetua' inde kara-kara dadie. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Dengan mesa tau disanga Yusuf to lu dio mai tondok Arimatea dio lembangna Yudea. Inde Yusuf-e mesa to mapia penawa anna to malolo anna ummampai duka' kaparentaanna Puang Allata'alla. Moi anna nakala' duka' kombonganna pa'bisara aluk, sapo tae' untarima kasiturusanna solana kumua la dipatei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Laomi umpellambi'i Pilatus anna umpelau batang rabukna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Umpaturummi batang rabukna Puang Yesus yao mai kayu pantokesan anna mane balunni sampin mabusa anna mane patamai lokko' mangka dipapia dio mesa tanete batu. Inde lokko'e ta'pa dengan to mate dipatama. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Attu iatoo, allo pa'patokaan annu la nalambi'mi allo katorroan. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Angganna baine to nasolaan Puang Yesus dio mai Galilea, ummula' manarang Yusuf napolalan naita liangna anna nakawanan umba nakua dipatodo' batang rabukna. ");
INSERT INTO mqjNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mangkaii, ma'pasulemi lako banua anna umpatoka minna'-minna' sola ma'rupa-rupa lite kayu bumanangnga' la lao napabonangngian batang rabukna Puang Yesus. Nalambi'i allo katorroan, ta'mo mengkarang situru' atoran illalan sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Allo Minggui, mebongngi'-bongngi'mi inde bainee lako liang umbaa minna'-minna' bumanangnga' pa'patokanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Saei lako tiberomi batu ditutu'ian lokko'. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tarru'mi tama lokko', sapo ta'mo dengan batang rabukna Puang Yesus nalambi'. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tontongpi ke'de' anna mangnga-mangnga umpenawa-nawaan inde kara-karae, anna tokke'mo ke'de' dua tau dio sa'dena, pakkillo'-killo' pakeanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Marea' asammi inde bainee napolalan lumbang rokko, sapo ma'kada inde dua taue nakua: “Maakaria' ammu sae umpeang to tuo inde angngenanna to mate? ");
INSERT INTO mqjNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ta'mo inde annu tuomi sule. Pengkilalaii tula'na lako kalemua' anna diopa Galilea, ");
INSERT INTO mqjNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kumua innang la disorong rokko lisu pala'na to kasalaan Anak Mentolino, anna la ditoke' yao kayu pantokesan, anna katallungngallona la tuo sule.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mane ungkilalairi tula'na Puang Yesus inde mai bainee. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sulei dio mai liang, untetterammi angganna kara-kara naita lako sapulo mesa rasul sola lako angganna to siunturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Inde mai bainee iamo Maria Magdalena, Yohana, Maria indona Yakobus, anna dengammpi pira-pira baine nasolaan lako liang untetteran inde kara-karae lako rasul. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sapo tae' naorean annu nasanga tokke' samantula'na babang. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sapo tappa ke'de' Petrus anna kumondong lako liang. Saei lako mengngollongmi tama lokko', anggami sampin pebalun naita illalan. Ma'pasulemi Petrus anna umpenawa-nawaan inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Allo iatoo dengan dua passikolana Puang Yesus lao lako mesa tondok disanga Emaus, umbai sapulo mesa kilo alla'na Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ummolai lalan ungkuamami kara-kara mane mangka dadi. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Marassanni sikuama, saemi Puang Yesus anna menono' sola ");
INSERT INTO mqjNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","sapo dipalumalin pennenne'na passikolana napolalan tae' naissanan. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma'kadami Puang Yesus nakua: “Aka menge mukuamaa' ummola lalan?” Bassi torromi anna masussa penawanna diita. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma'kadami mesa, disanga Kleopas nakua: “Angganna to lao langngan Yerusalem, umbai angga Iko tae' ummissanan kara-kara dadi yao mane pira-pirangngallo mangkanna.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nakuamo Puang Yesus: “Kara-kara aka?” Natimba' nakua: “Kara-kara dadi lako Puang Yesus to lu dio mai Nazaret, mesa nabi, to sitonda kakuasaan susi ummolai tula'na tenni pengkaranganna dio olona Puang Allata'alla anna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Napa'pesorongan kapala imam sola perepi'ta dipatei napolalan mangkamo ditoke' yao kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sitonganna kirannuammi kumua iamo to la urrappanan to Israel. Katallungngallonamo temo mangkanna dadi inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Sapo napatikkedu'kan pira-pira baine solaki, annu mebongngi'-bongngi' lao lako liang ");
INSERT INTO mqjNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","sapo ta'mo dengan naita batang rabukna. Ma'pasulemi anna tulasangkan kumua ummita malaeka' anna nakuanni tuomi sule. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pira-pirami solaki lao lako liang, anna naita situru' tula'na inde mai bainee, sapo tae' ummita Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma'kadami Puang Yesus nakua: “Innang oma' tongangkoa', annu ta' liupa muorean angga mangkanna natula' nabi. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tae'ka innang la ussa'dingan ia pandarraan yolo To dibassei bayu-bayu la ma'pasalama' anna mane ullambi' kamatandeanna?” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Napomakalesomi Puang Yesus lako inde dua passikolae angganna battakada untetteranni illalan Buku Masero susi illalan sura'na Musa tenni illalan sura'na nabi. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tapakala la ullambi' kalemo tondok la nakasaei lako. Naangga'imi Puang Yesus la umpatarru' kapenonosanna. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sapo tae' natangga', nakua: “Anta torromo annu la raummi allo anna la kuku'mi bongi.” Torro tongammi Puang Yesus sola inde dua passikolae. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Inde anna ma'lokomo sola la ummandee, ummalami roti Puang Yesus anna ma'kurru' sumanga' anna mane piak-piakki nabengan lako passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mane ummissanarri Puang Yesus inde passikolae, sapo tappa pa'de siami. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sipantula'mi inde passikolae nakua: “Posalai tiala tongan-tongan penawanta anta sipantula' ummola lalan, sola anna tetteranangki' issinna Buku Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tappa mengkalao siami sule lako Yerusalem. Saei lako ullambi'mi inde sapulo mesa rasul-e ma'rempun sola solana. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nakuamo inde mai taue: “Tuo tongammi sule Puang Yesus, mangkami umpa'paitaan kalena lako Simon.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Untetterammi duka' aka dadi lako kalena inde dua tau anna ummola lalanne, anna umba nakua ummissanan Puang Yesus anna umpiak-piak roti. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Marassampi sipantula'-tula', tokke'mi ke'de' Puang Yesus illalan alla'-alla'na anna ma'kada nakua: “La tontongkoa' siayun kamasakkean anna kamalinoan.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tikkedu' asammi sirau marea' annu nasanga anitu. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Sapo ma'kada Puang Yesus nakua: “Maakari ammu marea'a'? Maakari anna bata penawammua'? ");
INSERT INTO mqjNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Petua'pi limangku sola lentekku. Kao tongarri Kao tee. Rumbuna' ammu pengkalesoi manappana', annu tae' ia dengan balena sola bukunna anitu, susi muita lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Marassanni mantula' Puang Yesus napasiolammi umpa'paitaan limanna sola lentekna lako passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tangkaan liupi naorean passikola napobua' kadoresanna anna mangnga-mangnga liupa, nakuamo Puang Yesus: “Dengarrika nandemua' inde?” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nabengammi salontok be'dok tunu. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naalami anna andei naita passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mangkaii, mantula' pole omi nakua: “Kara-kara iamo te sikutulasangkoa' anta sola-solapae, kumua angganna battakada umpatuna' illalan sura'na Musa anna sura'na nabi sola sura' Pampudian innang la lemba'na.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nabukaiammi pikki'na Puang Yesus napolalan umpekalembasan issinna Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nakuamo Puang Yesus lako: “Dengan tiuki' illalan Buku Masero nakua: La ussa'dingan kamaparrisan To dibassei bayu-bayu la ma'pasalama' anna katallungngallona la tuo sule dio mai alla'na to mate. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ummolai sanganna la dipalanda' kareba lako angganna tau naparanduk inde Yerusalem kumua la mengkatoba' ma'rupa tau anna angganna kasalaan la nagarri'i Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikomoa' te la ussa'bii inde mai kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Anna la kusuangkoa' sae Penawa Masero situru' pa'dandinna Ambeku. Sapo la torro illalampokoa' inde kotae sae lako attunna naluangkoa' kakuasaan yao mai suruga.” ");
INSERT INTO mqjNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mangkai too, umbawaimi passikolana Puang Yesus lako salianna kota lu lako mesa angngenan sikadappi' tondok Betania. Saei lako ummangka'mi limanna untamba' passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Marassanni untamba' passikolana, natampemi anna tiangka' langngan suruga. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Menomba asammi anna mane ma'pasule lako Yerusalem sitonda kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Silao liumi tama Banua Ada'na Puang Allata'alla umpakasalle Puang Allata'alla.");
INSERT INTO mqjNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bunga'-bunga'na, ta'pa dikombong inde linoe, innang dengammi to digente' Battakada. Inde Battakadae sola Puang Allata'alla anna ia siamo Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Innang siba'ba'mi Puang Allata'alla mengkalao dio mai. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Angga lako napadadi Puang Allata'alla ummolai Battakada. Angganna dionamo reen, tae' la mala dadi ke tae' ummolai Battakada. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Inde Battakadae iamo to'na katuoan anna inde katuoanne iamo kamasiangan ummarrang ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kamasiangan iatoo pangngarrang illaan kamalillinan anna tae' nabela napi'dean kamalillinan. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tapakala saemo mesa tau nasua Puang Allata'alla disanga Yohanes, ");
INSERT INTO mqjNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","la umpalanda' kareba diona inde kamasianganne anna malara naorean rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Inde Yohanes-e tangngia to digente' kamasiangan sapo to umpalanda' kasa'bian diona inde kamasianganne. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Annu kamasiangan tongan la ummarrang ma'rupa tau mane la sae. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Inde Battakadae innang illalammi lino. Sapo tae' naissanan ma'rupa tau moika anna ummolai inde Battakadae Puang Allata'alla umpadadi lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Sae umpellambi'i lembangna sapo nasumbala satondokna. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sapo' dengan duka' tau untarimai anna ummoreanni. Inde mai taue napopendadi anakna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tae' nadadian ummolai kasipobainean susi kasipobaineanna ma'rupa tau, tangngia toi situru' pa'kuanna ma'rupa tau sapo situru' pa'kuanna Puang Allata'alla napolalan napopendadi anakna. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Inde Battakadae mangka mendadi rupa tau anna torro illaan alla'-alla'na ma'rupa tau anna kikawanammo kamatandeanna. Inde kamatandeanne nabenganni Ambena annu iamo Anak mesanna. Iamo tapolalan ungkaleso Puang Allata'alla sola pa'kamasena lako kaleta. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Umpalanda'mi kasa'bianna Yohanes diona inde Battakadae, nakua: “Iamo te to sikupokadae, kumua: ‘Dengan la sae windingku sapo marru matande ia anna kao, annu ta'pakkao dadi anna innang diomo ia reen.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tadiissan dianggai pa'kamasena napolalan tae' dengan kattu pa'tamba'na lako kaleta. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Musamo nasua Puang Allata'alla umpalandasangki' parentana, sapo kamatutuanna anna pa'kamasena Puang Allata'alla takawanan illaan kalena Yesus Kristus. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tae' dengan tau mangka ummita Puang Allata'alla salianna Anak mesanna, To nasirantean, To sisola liu Ambena. Iamo umpakawanan Puang Allata'alla lako kaleta. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Susi inde kasa'bianna Yohanes-e anna sae pira-pira imam sola peampoanna Lewi nasua perepi'na to Yahudi dio mai Yerusalem, mekutana lako nakua: “Bennaroko iko tee?” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mangngakumi Yohanes tala nagaraga-ragai nakua: “Tangngiana' To dibassei bayu-bayu la ma'pasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nakutanai pole omi nakua: “Bennaroko iko? Eliarokoka?” Natimba' nakua: “Tangngia.” Mekutana pole omi nakua: “Ikomoka nabi to diampai?” Natimba' nakua: “Tangngia.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nakutanai polemi nakua: “Bennanna tappa'roko iko, annu' la kiissan kipalanda' lako to ussuakan. Tulasangkan sitonganna benna tappa'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Natimba' Yohanes nakua: “Kaomo te to metamba-tamba dio padang alla'e kumua maloloananni lalan Dewatanta.” Situru' kadanna nabi Yesaya. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Inde to disuae dengan pira-pira to Farisi, ");
INSERT INTO mqjNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mekutana nakua: “Maakari ammu mantedok anna tangngiako para' To dibassei bayu-bayu la ma'pasalama', tangngiako Elia, anna tangngiako nabi to diampai?” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Natimba'mi Yohanes nakua: “Wai kao kupopantedok. Sapo dengan illaan alla'-alla'mua' to tamuissanan. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Windi ia sae anna kao sapo moi angga pepori palopakna la kubukaianni tae' tona' la sipato'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kara-kara iatee dadi dio Betania, tandai lianna Salu Yordan sinangei mantedok Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Masiangna polei, naitami Yohanes sae Puang Yesus umpellambi'i. Ma'kadami Yohanes nakua: “Petua'mia', iamo te Anak Dombana Puang Allata'allae To la umpa'dei kasalaanna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iamo napatu tula'ku kumua: ‘Dengan la sae windingku, sapo marru matande ia anna kao annu innang diomia reen angku mane kao dadi.’ ");
INSERT INTO mqjNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ambo' tae' kuissanan kumua iamo To dibassei bayu-bayu la ma'pasalama', moi kenada iamo kungei sae umpopantedok wai anna malara naissanan to Israel.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Sitarru'na kasa'bianna Yohanes nakua: “Attu iatoo ta'pa kuissanan kumua iamo To dibassei bayu-bayu la ma'pasalama'. Sapo mangka ma'kada lako kaleku Puang Allata'alla to ussuana' umpopantedok wai kumua: ‘Ianna ummitako mesa tau sae narampoi Penawa Maserona Puang Allata'alla, tau iamo too la umpopantedok Penawa Masero.’ Tapakala kuitamo Penawa Masero turun yao mai langi' susi dangan-dangan urrampoi Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Melolomo' ummitai anna kupa'pesa'biammo kumua iamo Anakna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Masiangna pole oi, dio omi angngenan iatoo Yohanes sola dua passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tappana ummita Puang Yesus liu, ma'kada siami Yohanes nakua: “Itamia' Anak Dombana Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Inde kadanna Yohanes-e narangngi dua passikolana napolalan mengkalao ummula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Messaile Puang Yesus lako boko'na, naitami naula' inde passikolae. Nakutanaimi nakua: “Akaraikoa' mupeang?” Natimba' nakua: “O Rabi, umbaraiko mungei torro?” (Rabi kalembasanna tuangguru). ");
INSERT INTO mqjNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Natimba' Puang Yesus nakua: “Maimokoa' ammu itaii.” Le'ba' tongammi sola napolalan naita angngenanna. Attu iatoo umbai la tettek appa'mo karuen, torropi sola Puang Yesus sae lako bongi. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inde passikola to urrangngi tula'na Yohanes anna unturu' Puang Yesus-e, disanga Andreas mesa, sirondongna Simon Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Le'ba siami lao umpeang Simon Petrus anna kuanni: “Silambi'mokangkami Mesias.” (Mesias, kalembasanna Kristus illaan basa Yunani.) ");
INSERT INTO mqjNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nasolaammi Andreas lao umpellambi'i Puang Yesus. Nanenne'imi Puang Yesus anna kuanni: “Iko Simon anakna Yohanes, la disangamoko Kefas.” (Kefas, illaan basa Yunani disanga Petrus.) ");
INSERT INTO mqjNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Makale'na, napatantumi Puang Yesus la lu lako Galilea. Umpellambi'imi Filipus anna kuanni: “Maiko ammu turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Inde Filipus-e to lu dio mai Betsaida tondok kadadianna Andreas sola Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Laomi Filipus umpellambi'i Natanael anna kuanni: “Silambi'mokangkami to sinatula' Musa illaan sura' pepa'guruanna anna sinapa'paissanan angganna nabi. Inde taue disanga Yesus, anakna Yusuf to Nazaret.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma'kada Natanael nakua: “Dengangka leleanna to mapia la buttu dio mai tondok Nazaret?” Natimba' Filipus nakua: “Maimoko ammu itai.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naitanna Puang Yesus sae Natanael umpellambi'i, ma'kadami untula' Natanael nakua: “Itamia' inde to Israel tonganne, to tama'dua tambuk.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma'kadami Natanael lako Puang Yesus nakua: “Umba nakua ammu issananna'?” Natimba' Puang Yesus nakua: “Ta'poko natambai Filipus angku itamoko dio to' ara.” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nakuamo Natanael: “O Tuangguru, Anaknako Puang Allata'alla! Tomarayanna tongammoko to Israel!” ");
INSERT INTO mqjNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Natimba' Puang Yesus nakua: “Muoreammi annu' mangkako kutulasan kumua kuitako dio to' ara. La dengan polepi kara-kara kamai la muita. ");
INSERT INTO mqjNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","La ummitako langi' titungka' anna malaeka'na Puang Allata'alla la ma'turun teka' umpellambi'i Anak Mentolino. Iate tula'kue tonganna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dua bongii mangkanna, dengammi pa'sombaan dio tondok Kana, dio lembangna Galilea. Attu iatoo dio duka' reen indona Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nalambi' duka' petamba Puang Yesus sola angganna passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tappana naita indona Puang Yesus kumua pura anggurna to kasara', ma'kadami lako Puang Yesus nakua: “Purami anggurna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Natimba' Puang Yesus nakua: “O Indo', daupa ammu sussaina' aka ta'pa nalambi' attunna la kungei umpakawanan kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sapo' ma'kada indona Puang Yesus lako to massorongan nakua: “Palako mammia' ke dengan aka nakuangko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Dio angngenan iatoo, dengan annan busso dipatoka la dipa'pengngei wai pembasean situru' ada'na to Yahudi. Inde mai bussoe umbai sisaratu' lite' wai tama. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma'kadami Puang Yesus lako to massorongan nakua: “Issi asannia' wai itin matin bussoo.” Naissii asammi saponnona. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mangkaii, nakuamo Puang Yesus: “Alami titti' ammu baanni lako to urrepi' sara'.” Naalami anna lao umbanni. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nasandakmi to urrepi' sara' inde wai mendadi anggur-e. (Sapo tae' naissanan umba nangei buttu, angga to massorongan to ummala inde waie ummissananni). Untambaimi muane marassan dipa'sombai inde to urrepi' sara'e, ");
INSERT INTO mqjNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","anna kuanni: “Beasanna sinapalako tau anggur randan mammi' nasorongan yolo, ianna nasanta' asammo to saena, mane disorongarri anggur beasa. Sapo muanna liupi iko anggur randan mammi' sae lako temo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iamo te bunga'na tanda memangnga-mangnga napogau' Puang Yesus-e. Kara-kara iatee napalako dio tondok Kana dio lembangna Galilea. Anna iamo umpakawananni kamatandeanna napolalan naorean passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mangkai too, mengkalaomi Puang Yesus rokko Kapernaum sola indona, angganna sa'do'doranna muane, anna passikolana. Torromi dio pira-pirangngallo. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Attunna la nalambi' kalemo allo kamainna to Yahudi disanga Paskah, mengkalaomi Puang Yesus langngan Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Saei langngan, ullambi'mi to ma'baluk illaan pa'ranteanna Banua Ada'na Puang Allata'alla. Dengan to ma'baluk saping, domba, anna to ma'baluk dangan-dangan. Dengan toi duka' to umpa'petukasan doi' pantan ma'loko dio. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ummala siami gondali Puang Yesus anna papiai peombang anna urrambai tau sola angganna domba anna saping illaan mai pa'ranteanna Banua Ada'na Puang Allata'alla. Umbalintammi liu mejana to umpa'petukasan doi' napolalan tisembu' doi'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Anna ma'kada lako to umbaluk dangan-dangan nakua: “Alai asannia' te maie, daua' ammu popasa'i banuanna Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nakilalaimi passikolana dengan battakadanna Puang Allata'alla tiuki' nakua: “O Puang Allata'alla, pa'kaboro'ku lako banuammu la untallananna'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Buda perepi'na to Yahudi umbali Puang Yesus nakua: “Paitaipakan mesa tanda memangnga-mangnga angki issananni kumua ummampui tongangko kakuasaan mupolalan ma'pasusi indee.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Natimba' Puang Yesus nakua: “Roppokampia' inde Banua Ada'na Puang Allata'allae angku pake'de'i sule angga tallungngallo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nakuamo inde perepi'na to Yahudie: “Appa' tapulo annan taunna diola unggaraga inde Banua Ada'na Puang Allata'allae anna angga Iko la tallungngallo muola umpake'de'i sule?” ");
INSERT INTO mqjNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sapo batang kalena ia Puang Yesus nakuan Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mangkapi tuo sule Puang Yesus dio mai alla'na to mate mane nakilalairi passikolana kumua innang mangka napokada. Ummorean asan pole' battakadanna Puang Allata'alla illaan Buku Masero anna tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Marassanni umpakaroa' allo Paskah Puang Yesus dio Yerusalem, budami tau ummoreanni annu ummita tanda memangnga-mangnga napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sapo tae' naorean Puang Yesus kumua mangngorean tongammi, annu nakawanan asan tama penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tae' parallu dipokadanni diona tananan penawanna mesa tau annu innang ullosami penawanna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dengan mesa perepi'na to Yahudi to nakala' kombonganna to Farisi disanga Nikodemus. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pissan attu, lao bongi umpellambi'i Puang Yesus anna ma'kada lako nakua: “O Rabi, kiissanan kumua Ikomo tuangguru pesuaanna Puang Allata'alla annu tae' tappa' dengan tau mala umpogau' tanda memangnga-mangnga susi simupogau' ke tae' nasolaan Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Natimba' Puang Yesus nakua: “Sitonganna, tae' dengan tau mala tama kaparentaanna Puang Allata'alla ke tae' didadian pole.” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nakuamo Nikodemus: “Umbamo la nakua didadian pole ke to matuamo? La malarika sule tama tambukna indona anna mane didadian pole?” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Natimba' Puang Yesus nakua: “Kupokadangko sitonganna, ianna tae' tau didadian ummolai wai anna Penawa Masero tae' mala mendadi petauanna Puang Allata'alla illaan kaparentaanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Batang kalena ma'rupa tau to matuanna undadianni, sapo penawanna nadadian Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tae'ko la tikkedu' ke kukuangko: la paralluko didadian pole. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sirapan bara', iamo pa'kuanna iamo naola mangngiri'. Tarangngi oninna sapo tae' taissanan umba nangei mengkalao anna umba la nangei sumpu. Susimi duka' lako to nadadian pole Penawa Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mekutana pole omi Nikodemus nakua: “Umba la nakua dadi susi?” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Natimba' Puang Yesus nakua: “Maakari anna tae' la muissanan anna tuangguru keangga'ko inde Israel? ");
INSERT INTO mqjNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kupokadangko sitonganna, angga kami kiissananna anna kiitanna kipokada sola kipa'pesa'bian, sapo tae'a' muorean. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kutulasangkoa' kara-kara mellinona tae'a' muorean, la dapakaia ke kara-kara yaomo suruga kutulasangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tae' dengan tau mangka lao langngan suruga salianna to innang buttu yao mai iamo to digente' Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Umba nakua ula' panggaraga mangka natandean Musa yao salontok kayu dio padang alla', la susimi duka' Anak Mentolino la ditandean, ");
INSERT INTO mqjNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","anna malara angganna to ummoreanni la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tae' dengan nasusian pa'kamasena Puang Allata'alla lako ma'rupa tau, napolalan napaturunanni Anak mesanna anna malara angganna to ummoreanni tae' la sanggang sapo' la ullolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Annu tae' ussua Anakna Puang Allata'alla tama lino la sae umpabambanni sangka' ma'rupa tau sapo la napasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Benna-benna mangngorean lako Anakna Puang Allata'alla tae' la dipabambanni sangka'. Anna benna-benna tae' mangngorean innang to la dipabambanni sangka' aka tae' ummorean Anak mesanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Saemi tama lino kamasiangan sapo marru umporairia kamalillinan ma'rupa tau annu kadake pa'palakona. Iamo napolalan umpabambanni sangka' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Angganna to umpogau' kakadakean la ungkabassi kamasiangan anna moka lao umpellambi'i indana kawanan pa'palako kadakena. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sapo angganna to umpogau' pa'kuanna Puang Allata'alla la umpellambi'i kamasiangan anna kawanarra pa'palakona kumua situru' pa'kuanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mangkai too, mengkalaomi Puang Yesus sola passikolana lako lembangna Yudea anna torro dio pira-pirangngallo mantedok. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Attu iatoo, ta'pa ditarungkun Yohanes to simantedok. Mantedok duka' dio Ainon, sikadappi' Salim annu buda wai dio. Sasaeammi tau anna tedokki. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tapakala sipekkamo passikolana Yohanes anna mesa to Yahudi diona pembasean situru' ada'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Laomi umpellambi'i Yohanes anna kuanni: “O tuangguru, mukilalaipika iato to musolaan sambali' lamban lianna Salu Yordan to mupa'pesa'bian lako kalekio? Marassan duka' mantedok anna budamo tau lao umpellambi'i.” ");
INSERT INTO mqjNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Natimba' Yohanes nakua: “Tae' dengan aka mala napalako ma'rupa tau ke tae' nabenganni kakuasaan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mangkamia' murangngi tula'ku kumua: ‘Tangngiana' To dibassei bayu-bayu la ma'pasalama' sapo to disuana' umpatokanni lalan.’ ");
INSERT INTO mqjNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sirapan to ma'somba: inde baine dipa'sombaie la muanena ummampuii. Mengke'de' samanena inde to la kebainee ke'de' ia dio sa'dena anna ma'perangngi. Anna la dore'mo ke urrangngii kamaranna samanena. Susimo' duka' tee, sumpumi kadoresangku temo annu sirapanna' samanena to la kebaine. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","La satuttuan keangga' anna la satuttuan pa'demokkao. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Marru matande ia anna angga lako To buttu yao mai suruga. Anna to buttu illaan mai lino digente' to lino anna anggamo kara-kara lino napokada. Puang Yesusmo to buttu yao mai suruga untondon angga lako. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Natula' asammi angga mangkanna naita sola narangngi sapo tae' tappa' dengan tau ummoreanni. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Benna-benna ummorean tula'na Puang Yesus untonganan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Annu inde Puang Yesus to nasua Puang Allata'allae, umpalanda' battakadanna Puang Allata'alla ura'na Penawa Masero mangka dipalessu' lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Puang Allata'alla Ambeta ungkamasei Anakna anna mangkamo napalessu' lako angganna kakuasaan. ");
INSERT INTO mqjNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Benna-benna mangngorean lako Anakna Puang Allata'alla, ullolongammi katuoan sae lako-lakona. Anna benna-benna tae' ummoreanni, tae' la ullambi' inde katuoanne, sapo la tontong narua ara'na Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Napekarebami to Farisi kumua tuttuan budami tau umpellambi'i Puang Yesus anna tedokki lambisan budamia passikolana anna la passikolana Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Sitonganna tae' ia dengan mantedok Puang Yesus sapo angga passikolana.) ");
INSERT INTO mqjNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tappana naissanan Puang Yesus kumua napekarebamia to Farisi diona kara-kara iatoo, umpelleimi lembangna Yudea anna ma'pasule lako lembangna Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Inde penonosanna Puang Yesus-e manggi' la ummola lembangna Samaria. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Saei lako Samaria ullambi'mi mesa tondok disanga Sikhar sikadappi' litak napa'manasan Yakub lako anakna disanga Yusuf. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dio angngenan iatoo dengan mesa timbu, disanga timbunna Yakub. Attu iatoo umbai tettek sapulo duamo allo, ma'lokomi Puang Yesus dio sa'de timbu aka boyo'mi menono'. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Tarru' ia passikolana tama tondok lao ummalli nande. Tapakala saemo mesa baine to Samaria la ummala wai. Ma'kadami Puang Yesus lako nakua: “O indo', bennakkao kuiru'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Natimba' inde bainee nakua: “O Tuang, to Yahudiko anna to Samarianakkao. Maakari ammu pelau wai iru' lako kaleku?” (Ia nangei ma'kada susi annu moka to Yahudi silambanan to Samaria.) ");
INSERT INTO mqjNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Natimba' Puang Yesus nakua: “Sitonganna kela ummissanangko pa'pebenganna Puang Allata'alla anna to umpelauiko wai, iko la umpelau wai lako kalena anna la nabengangko wai katuoan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Natimba' inde bainee nakua: “Inde timbue mandiong anna tae' dengan petimbamu. Umbamo la mungei ummala wai katuoan? ");
INSERT INTO mqjNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Inde timbue nabengangkan Yakub to kiponene. Simelolo ia duka' sae untimba wai susi la nairu'na sola anakna tenni la napairusan patuoanna. La tanda langngan polekoka Iko anna Yakub?” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Natimba' Puang Yesus nakua: “Angganna to ummiru' inde waie la marekko'pi kollongna. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sapo' benna-benna ummiru' wai la kubenganni ta'mo la marekko' kollongna sae lako-lakona. Annu inde wai la kubengannie la mendadi kalimbuang tamatti' illaan kalena la umbenganni katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nakuamo inde bainee: “O tuang, bengammo' itin wai mukuanno anna malara ta'mo la marekko' kollongku anna ta'mo' manggi' sae liu ummala wai inde.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Natimba' Puang Yesus nakua: “Laomoko untambai muanemu ammu saea' sola.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nakuamo inde bainee: “Tae'nakkao kemuane.” Natimba' Puang Yesus nakua: “Tonganna tula'mu, ");
INSERT INTO mqjNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","annu pellimamoko kemuane, anna muane simusolaan temo tangngia muanemu. Dadi manassa tongan tula'mu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nakuamo inde bainee: “O tuang, kuissanammi pole' kumua nabiko. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Neneki kami simenomba yao inde tanetee, anna mukuaa' Iko angga yao Yerusalem dingei menomba.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nakuammi Puang Yesus: “Oreanni inde tula'kue kumua la dengan attunna tae' angga yao inde tanete la dingei umpenombai Ambetae, tae' toi angga yao Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ikoa' iko to Samaria umpenombaikoa' Puang Allata'alla sapo tae'a' muissanan tongan. Anna kami-kami to Yahudi umpenombaikan Puang Allata'alla to kiissanan, annu buttu dio mai to Yahudi kasalamasan. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sapo la dengan attunna anna attunnamo temo, angganna to menomba tongan la umpenombai Ambeta situru' pa'parundukna Penawa Masero anna situru' katonganan. Annu to menomba susimo tee naporanan Puang Allata'alla Ambeta. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Annu merrupa penawa ia Puang Allata'alla. Dadi angganna to umpenombaii, innang la menomba situru' pa'parundukna Penawa Masero anna katonganan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nakuamo inde bainee: “Kuissanan duka' kumua la sae To dibassei bayu-bayu la ma'pasalama', to digente' Kristus. Maka' saemo, la napokadaan asangkia' angga lako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Natimba' Puang Yesus nakua: “Kaomo te To dibassei bayu-bayu la ma'pasalama'e, to musipantulasan temo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Marassampi sipantula' inde bainee anna saemo sule passikolana. Mangnga-mangnga asammi ummita Puang Yesus marassan sipantula' baine. Sapo' tae' tappa' dengan ungkutanai inde bainee kumua aka naparallui, battu ungkutanai Puang Yesus kumua maakaria anna sipantula' inde bainee. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Untampemi pa'pengngean wai sakkena inde bainee anna lao umpellambi'i tau tama tondok, anna kuanni: ");
INSERT INTO mqjNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dengan tau kusilambisan, napokadaan asanna' angga mangkanna kupogau'. Maikoa' ammu lao umpetua'i. Umbai iamo To dibassei bayu-bayu la ma'pasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sale'bammi to ma'tondok lao umpellambi'i Puang Yesus dio salian tondok. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Le'bai inde baine tama tondokke, nakuamo passikolana Puang Yesus: “O tuangguru, maimoko anta ummande.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sapo natimba' Puang Yesus nakua: “Dengan Kao nande kuampui sapo' tae'a' muissanan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sipantula'-tula'mi passikolana nakua: “Bennamo ia sae umbanni nande?” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nakua Puang Yesus: “Nandeku Kao iamo unturu' pa'kuanna Puang Allata'alla to ussuana' anna umpasuppik pengkarangan mangka napapassannianna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Simukuaa': ‘Appa' tabulampi anna meparemo tau!’ Sapo' kukua Kao: Parandarria' uma, sikaririmi pare rokko malami dipeparei. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Naparandukmi untarima sarona to mepare anna urrempun alan uma. Inde alan umae iamo to ullolongan katuoan sae lako-lakona. Napolalan susi to mangngambo' tenni to mepare masannang pada-pada. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tonganna inde sinapoparumbanan taue kumua: Senga' to mangngambo', senga' to mepare. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kusuakoa' lao umpeparei uma tangngia pengkarangmua'. Tau senga' mangka ungkarangngi sapo ikoa' la ummalai alanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Buda to Samaria, to illaan inde tondokke ummorean Puang Yesus annu urrangngi tula'na iato baineo kumua: “Natulasanna' angganna pa'palakoku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Napolalan inde anna silambi'mo Puang Yesus-e napelaumi kenamala torropa dio. Torro tongammi Puang Yesus dio tondok iatoo dua bongi. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tuttuan kerangngammi to mangngorean dio annu urrangngimi tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nakuamo tau buda lako inde bainee: “Tangngia angga tula'mu kirangngi kipolalan mangngoreammo temo, sapo melolomokan urrangngii pepa'guruanna, napolalan kiissanammo kumua iamo To la umpasalama' ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dua bongii torro dio Sikhar, tarru'mi Puang Yesus lako Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Annu innang dengammi napokada Puang Yesus kumua: “Tae' ia dengan nabi diangga' dio tondokna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Saei lako Galilea, dore' asammi tau untammuii annu lao asan duka' lako Yerusalem anna Allo Paskah anna ummita aka napogau' Puang Yesus dio. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Lu lakomi tondok Kana Puang Yesus dio lembangna Galilea, tondok nangei umpopembali anggur wai. Attu iatoo, dio tondok Kapernaum dengan to napake tomaraya masaki anakna. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tappana naissanan kumua saemi Puang Yesus dio mai Yudea, mengkalao siami lao umpellambi'i Puang Yesus anna kuanni: “O Tuang, masanta' anakku dio Kapernaum. Anta lao siapa lako ammu pomalapusanna'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Natimba' Puang Yesus nakua: “Kela tae'koa' ummita tanda memangnga-mangnga kupogau', tae'koa' la mangngorean.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nakuamo inde taue: “O Tuang, siruanna la diaka, anta laomo indana bonno'mo anakku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nakuammi Puang Yesus: “Laomoko, malapu'mi anakmu.” Le'ba' siami inde taue annu ummoreammi tula'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ummolai lalan sitammumi sabua'na la lao ungkuanni malapu'mi anakna. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ungkutanaimi sabua'na nakua: “Maakai allo anna malapu'?” Natimba' pobawanna nakua: “Umbai tipalempe allo samai' anna soro' kula'na.” ");
INSERT INTO mqjNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nakilalai siami ambena inde anakke kumua katenannamo too anna kuanni Puang Yesus: “Malapu'mi anakmu.” Napolalan inde taue mangngorean lako Puang Yesus sola angganna rapunna. ");
INSERT INTO mqjNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iamo te kapenduanna tanda memangnga-mangnga napogau' Puang Yesus dio Galileae sulenamo dio mai Yudea. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mangkai too mengkalaomi Puang Yesus langngan Yerusalem aka la untongkonni mesa allo kamainna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yao Yerusalem, dengan mesa limbong disanga Betesda illaan basa Ibrani sikadappi' Ba'ba Domba. Dio biringna inde limbongnge dengan lima sali-sali ");
INSERT INTO mqjNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","buda to masaki simamma' dio. Dengan to buta, to kempo', anna to balimbingan. Inde mai taue ummampai pangnge'ba'na wai ");
INSERT INTO mqjNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","annu tokke' sisae malaeka'na Puang Allata'alla umme'ba'i. Iamo randan yolo rokko limbong ke mangkai pangnge'ba' wai, iamo malapu' moi masaki aka. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Dio angngenan iatoo dengan mesa muane tallu pulomi karua taunna masaki. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Inde anna itami Puang Yesus mamma' dioe, anna naissanan toi kumua masaemi masaki, nakutanaimi nakua: “Moraikoka la malapu'?” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Natimba' inde to masakie nakua: “O Tuang, tae' kao dengan umparokkona' limbong ke pangnge'ba' omi. Aka mane la rokkonakkao anna yoloi omo' tau senga'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nakuammi Puang Yesus: “Millikko, alai ampa'mu ammu menono'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tappa malapu' siami inde taue. Ummalami ampa'na anna menono'. Kara-kara iatee sirupang allo katorroan anna dadi, ");
INSERT INTO mqjNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","napolalan ma'kada perepi'na to Yahudi lako inde to mane malapu'e nakua: “Tae'ko mala umbaa ampa'mu temo annu allo katorroan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sapo natimba' inde taue nakua: “Nakuanna' to umpomalapu'na': ‘Alai ampa'mu ammu menono'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nakutanaimi inde mai perepi'e nakua: “Benna ungkuangko: ‘Alai ampa'mu ammu menono'?’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sapo tae' naissanan benna umpomalapu'i annu tappa umpa'dean kalena Puang Yesus tama alla'-alla'na tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tae' masae siitami Puang Yesus anna inde to mane mangka napomalapu'e illaan Banua Ada'na Puang Allata'alla. Nakuamo Puang Yesus lako: “Temo malapu'moko. Daumo umpogau' liu kakadakean indana tappaiko kamaparrisan marru mabanda' polepia anna sakimmu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Le'ba siami lao umpokadaan perepi'na to Yahudi kumua Puang Yesus-ria umpomalapu'i. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iamo nangei naparandukmo to Yahudi ussussai Puang Yesus, annu attunna allo katorroan nangei umpogau' inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sapo ma'kada Puang Yesus nakua: “Mengkarang liupi Ambeku sae lako temo kupolalan mengkarang duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tula' iamo tee napolalan satuttuan umpeang lalan perepi'na to Yahudi la umpatei Puang Yesus. Anu' tae' angga ullenda kabeasaan diona allo katorroan, sapo nakua polepa: “Ambeku Puang Allata'alla,” kalembasanna umpapada angga' kalena Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma'kadami Puang Yesus lako perepi'na to Yahudi nakua: “Sitonganna tae' dengan aka la mala kupogau' kela kakuasaan kalekura. Anggami sikuitanna napogau' Ambeku mala kupogau'. Iamo napogau' Ambeku, iamo duka' kupogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Annu' nakamaseina' Ambeku anna napaitai asanna' angga napogau'na. Anna la kamai polepa pa'palakona napa'paitanna' mupolalan mangnga-mangngaa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","La umbenganna' katuoan lako to morai la kubengan katuoan, susi Ambeku umpatuo sule to mate anna benganni katuoan. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tangngia Ambeku la umbisara ma'rupa tau, sapo Kaomo nabengan kakuasaan la umbisara ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ia nangei umpasusii Ambeku angku malara napakasalle angganna tau susi ke umpakasallei Ambeku. Benna-benna tae' umpakasallena', tae' duka' umpakasalle Ambeku, to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kupokadangkoa' sitonganna, benna-benna umpaillaan tambuk inde tula'kue anna ummorean Puang Allata'alla to ussuana', ullolongammi katuoan sae lako-lakona. Ta'mo la dipabambanni sangka', mallaimi dio mai kamatean anna ullambi' katuoan. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sitonganna la dengan attunna, anna mala dikua attunnamo temo, la narangngi to mate kamaranna Anakna Puang Allata'alla. Anna angganna to urrangngii la ullolongan katuoan. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Napopendadina' Ambeku to'na katuoan susi kalena kabuttuanna katuoan. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mangkamo' nabengan kakuasaan la umbisara ma'rupa tau annu Kaomo Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tae'koa' la mangnga-mangnga urrangngi inde tula'kue, annu la dengan attunna angganna to mate la urrangngi kamarangku, ");
INSERT INTO mqjNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","napolalan la mallai asan illalan mai liang. Angganna to ma'gau' mapia la tuo sule untarima katuoan sae lako-lakona, anna angganna to kadake gau' la tuo sule sapo la dipabambanni sangka'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Tae' dengan aka mala kupogau' kela situru'ri kakuasaangku. Umbisarana' ma'rupa tau situru' parentana Puang Allata'alla. Anna angganna pa'parokkoku malolo aka tangngia pa'kuangku kuturu', sapo pa'kuanna to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kela Kao manda umbengangkoa' kasa'bian diona kaleku, mala tae' diorean. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sapo dengampi to umpa'pesa'bianna' iamo Ambeku, anna kuissanan kumua tonganna kasa'bianna. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mangkamokoa' ussua tau umpellambi'i Yohanes anna natulasammokoa' sitonganna kumua benna tappa'na'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sitonganna tangngia kasa'bianna ma'rupa tau kuparallui kungei untula' kasa'bianna Yohanes sapo ammu malara dipasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Inde Yohanes-e sirapan ballo pangngarrang. Masannangkoa' ummitai pangngarrangna sapo angga sappai' muporai. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sapo ummampuinakkao kasa'bian marru ma'tandalangnganan anna kasa'bianna Yohanes, iamo pengkarangan mangka napapassannianna' Ambeku la kupalako. Inde pengkaranganne marassammi kukarang anna iamo umpakawananni kumua nasuana' Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Napa'pesa'bianna' duka' Ambeku to ussuana'. Ta'pa dengan murangngia' kamaranna, anna ta'pa dengan muita rupanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Manassa anna tae' mupaillaan tambuk battakadanna, aka tae'na' muorean inde to nasuae. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Siumpelaya'ikoa' issinna Buku Masero annu musanga iamo la mupolalan ullolongan katuoan sae lako-lakona. Anna illaan inde Buku Maseroe tiuki' battakada umpa'pesa'bianna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sapo tae'a' muaku sae umpellambi'ina' ammu lolongan katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tangngia Kao pa'pakasallena ma'rupa tau kupeang. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sapo kuissanan asangkoa'i. Kuissanan kumua tae' dengan illaan penawammua' la ungkamasei Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Saenakkao sitonda kakuasaanna Ambeku, mutumpu pala'na'. Sapo ianna tau senga'mo sae sitonda kakuasaan kalena, mutarimamia'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tae'a' la muissan mangngorean annu anggami pa'pakasallena ma'rupa tau mupeang, anna tae' muaku umpeang pa'pakasallena Puang Allata'alla mesa-mesanna Dewata. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tae'a' la mukua la kupasalakoa' dio olona Ambeku, sapo Musaria to murannuanna' la umpasalakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kela ummorean tongangkoa' Musa, la muoreanna' duka' annu Kaomo mangka nauki'. ");
INSERT INTO mqjNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sapo' ianna tae'koa' ummorean aka mangka nauki' Musa, innang tae' siakoa' la ummorean battakadangku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Masae-saei mangkanna, le'ba'mi Puang Yesus sola passikolana lamban lian Tasik Galilea battu' sidikua duka' Tasik Tiberias. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bu'dak tau ummula'i lian aka ummita tanda memangnga-mangnga mangka napadadi Puang Yesus umpomalapu' to masaki. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lu langngammi buntu-buntu Puang Yesus sola passikolana anna ma'loko yao. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Attu iatoo madappi'mi attunna la dipakaroa' allo kamai disanga Paskah iamo allo kalappasanna to Yahudi dio mai kasabuasan. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Inde anna umpalilingmo pennenne'na Puang Yesus-e, ummitami tau buda ma'lengko-lengko sae umpellambi'i. Nakuamo lako Filipus: “Umbamoa' la tangei ummalli nande tapandean inde lako taue?” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Innang naissanan Puang Yesus aka la napogau', sapo' naangga'ipi mekutana annu la ussudi Filipus. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Natimba' Filipus nakua: “Moi la pa'dua ratusan dinar nande dialli, innang tae' la sanda inde lako tau pada budannae, moi la dipasipada nennu'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma'kada mesa passikolana Puang Yesus disanga Andreas, sirondongna Simon Petrus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Dengan mesa anak umbaa limangkalebu roti anna dua be'dok. Sapo tae' dengan kalembasanna la ditingngayoan inde tau padae.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nakuamo Puang Yesus: “Kuanni itin matin tauo anna pantan ma'loko.” Dio angngenan iatoo buda reu tuo, iamo nangei ma'loko tau. Umbai lima sa'bu ia muane. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ummalami roti Puang Yesus anna ma'sambayang ma'kurru' sumanga'. Mangkai natawami lako inde mai taue napasitawa be'dok. Ummandemi tau sadea'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mangka asanni tau ummande, nakuamo Puang Yesus lako passikolana: “Rempunnia' itin matin ra'daknao indana masala.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Narempummi passikola ra'dakna, sapulo duapi baka tanapuranna tau inde lima rotie. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Inde anna itami tau tanda memangnga-mangnga napalako Puang Yesus-e, nakuamo: “Ia tappa'mo inde nabi dirannuan la sae tama linoe.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sapo naissanarria Puang Yesus kumua inde lako taue la sae umpassai mendadi tomaraya, napolalan le'ba' langngan tanete mesai. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Inde anna la bongimoe, mengkalaomi rokko biring tasik passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","La kuku'mi bongi ta' liumo ia sae Puang Yesus umpellambi'i passikolana. Langngammi lopi passikolana anna mengkalao lian tondok Kapernaum. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Attu iatoo sikamai bombang napobua' bara' kamai. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Umbai limarika battu' annarrika kilo naola ma'lopi, ummitami Puang Yesus menono' yao lolok wai la sae umpellambi'i lopi napolalan marea' asan passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sapo ma'kada Puang Yesus nakua: “Daua' marea', Kaori Kao tee.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dore' asammi passikola umpalangngan lopi Puang Yesus. Sore siami duka' lopinna dio inde angngenan la nakasaei lakoe. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Masiangngii, nakilalaimi tau buda, to torropa sambali' lamban lianna tasik kumua angga mesa lopi samai' karuen, anna iamo napake passikolana Puang Yesus. Anna naissanan toi kumua tae' langngan lopi Puang Yesus sola passikolana samai' karuen. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tapakala sae pira-pira lopi lu dio mai tondok Tiberias, sore dio sikadappi'na angngenan nangei ummande roti tau buda mangkanna nakurru'i sumanga' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Inde anna kanassami tau buda kumua ta'mo dio reen Puang Yesus sola passikolanae, langngan asammi inde lopie anna mengkalao lian tondok Kapernaum lao umpeang Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Silambi'i Puang Yesus inde tau buda sambali' lamban lianna tasikke, mekutanami nakua: “O Tuangguru, piran Iko ammu sae inde?” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Natimba' Puang Yesus nakua: “Sitonganna tangngia ura'na umpekalembasammokoa' tanda memangnga-mangnga mangka kupadadi mupolalan mupeangna', sapo mangkakoa' kupande roti sadea'mu. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Daua' mengkarang umpeang nande la pura anna la bosi. Sapo pengkarangkoa' umpeang nande tae' la bosi anna la umbengangkoa' katuoan sae lako-lakona. Inde nande susie la nabengangkoa' Anak Mentolino, To nabassei bayu-bayu Puang Allata'alla, Ambeta.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mekutanami tau buda nakua: “Akamo la kipogau' la situru'na pa'kuanna Puang Allata'alla?” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Natimba' Puang Yesus nakua: “La mangngoreangkoa' lako kaleku, to nasua Puang Allata'alla. Iamo te pa'porainna Puang Allata'alla la mupogau'e.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nakuamo tau buda: “Tanda aka la mupaitaikan angki oreangko? Aka la mupogau'? ");
INSERT INTO mqjNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Neneki kami, mangka ummande andean disanga manna dio padang alla', susi dengan tiuki' illaan Buku Masero kumua, ‘Nabenganni nande lu yao mai suruga.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nakuamo Puang Yesus lako inde tau budae: “Sitonganna tangngia Musa umbengangkoa' nande lu yao mai suruga sapo Ambeku umbengangkoa' andean tongan lu yao mai suruga. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Annu inde andean napebeen Puang Allata'allae iamo to buttu yao mai suruga umpatuo ma'rupa tau illaan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Natimba' tau buda nakua: “La mubeen liukan itin nande susio.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma'kada Puang Yesus nakua: “Kaomo te nande katuoanne. Benna-benna sae umpellambi'ina' anna oreanna', ta'mo dengan la tadea' anna mawarrang sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sapo mangkamokoa' kukuan, moi anna muitamo' sapo ta' liu siapokoa' mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Angganna to mangka napalessu' lako kaleku Ambeku, la saena' napellambi'i. Angganna to sae umpellambi'ina' tae' dengan la kusumbala. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Annu' saena' yao mai suruga la umpalako pa'kuanna to ussuana', tangngia pa'kuangku la kupogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Anna indemi pa'kuanna to ussuana'e, kenamala angganna to dipalessu' lako kaleku tae' dengan pa'de, anna la kupatuo asan sule ke nalambi'mi allo katallananna lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Angganna to ummita Anakna Puang Allata'alla anna oreanni, la ullambi' katuoan sae lako-lakona, anna la kupatuo sule ke nalambi'mi allo katallananna lino. Iamo te pa'kuanna tappa' Ambekue.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sipa'mammang-mammangammi to Yahudi napobua' kadanna Puang Yesus kumua: “Kaomo te andean lu yao mai surugae.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nakuamo inde mai to Yahudie: “Anna Yesus indee, anakna Yusuf. Kiisanan indo ambena. Maakaria anna nakua: ‘Lu yaona' mai suruga?’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma'kada Puang Yesus nakua: “Daua' ma'mammang. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Innang tae' sia dengan tau sae umpellambi'ina' ke tae' napatette Ambeku to ussuana'. Anna benna-benna sae umpellambi'ina' la kupatuo sule dio mai kamatean ke nalambi'mi allo katallananna lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dengan tiuki' illaan sura'na nabi kumua: ‘La napatudu asan Puang Allata'alla.’ Iamo too angganna to umperangngii Ambeku anna turu'i pepa'guruanna, la saena' napellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tae' te kukuae dengammi tau mangka ummita Ambeku. Angga Kao mangka ummitai annu lu yaona' mai Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sitonganna angga to mangngorean ummampui katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kaomo te andean katuoanne. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mangka ummande andean disanga manna nenemua' dio padang alla' sapo bonno' asarri. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Sapo tae' ia la susi inde andean lu yao mai surugae. Aka angganna to ummandei ta'mo la mate. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kaomo te andean lu yao mai surugae, andean umbeen katuoan ma'rupa tau. Benna-benna ummandei la tuo sae lako-lakona. Inde andeanne iamo baleku, la kupebeen anna malara ullolongan katuoan ma'rupa tau illaan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tappana urrangngi tula'na Puang Yesus, sipekka-pekkami to Yahudi nakua: “Umbara nakua inde taue anna la nabeengkia' balena taande?” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma'kadami Puang Yesus lako nakua: “Sitonganna, ianna tae'koa' ummande baleku to digente' Anak Mentolino sola ummiru' raraku innang tae' tongangkoa' la ummampui katuoan. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Benna-benna ummande baleku anna ummiru' raraku ummampui katuoan sae lako-lakona anna la kupatuo sule dio mai alla'na to mate ke nalambi'mi allo katallananna lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Annu' inde balekue innang andean tongan anna raraku iru' tongan. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Angganna to ummande baleku anna ummiru' raraku la mesa kappa'mokan. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ambeku to ussuana' iamo to'na katuoan, iamo duka' kupolalan ummampui katuoan. Susimi duka' angganna to ummande baleku la ummampui katuoan lu dio mai kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kaomo te andean lu yao mai surugae, tangngia andean susi mangka naande nenemua'i. Annu moi anna ummande andean iatoo sapo bonno' asarri. Sapo benna-benna ummande inde andean lu yao mai surugae la tuo sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Angganna te maie natula' Puang Yesus anna ma'pa'guru illaan banua pa'sambayanganna to Yahudi dio Kapernaum. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tappana urrangngi kadanna Puang Yesus, budami passikolana ma'kada nakua: “Mabanda' inde pepatudue. Tae' dengan tau la untaroi untarimai.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Naissanan duka' Puang Yesus kumua sipa'mammang-mammangammi passikolana napobua' inde tula'nae, napolalan ma'kada nakua: “Tikannarika iko penawammua' urrangngi inde tula'kue? ");
INSERT INTO mqjNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","La maakamokoa' ke ummitako Anak Mentolino sule langngan angngenanna ke dako'? ");
INSERT INTO mqjNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Penawa Masero ia umpatuo ma'rupa tau. Tae' ia dengan gunana kamatoroanna ma'rupa tau. Inde tula'kua' matinne buttu dio mai Penawa Masero, battakada la umpatettekoa' lako katuoan tongan. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sapo dengampokoa' tae' mangngorean.” (Innang naissanammi Puang Yesus mengkalao dio mai benna tae' la mangngorean anna benna la umpa'perososanni.) ");
INSERT INTO mqjNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nakua pole omo Puang Yesus: “Iamo kungei umpokadangkoa' kumua tae' dengan tau la sae umpellambi'ina' ke tae' napatette Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naparanduk pole' buda passikolana kumassoro' anna ta'mo naaku unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mekutanami Puang Yesus lako sapulo dua passikolana nakua: “Morairokoka duka' la umpelleina'a'i?” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Natimba' Simon Petrus nakua: “O Puang, umbamo kami la kiola? Annu inde battakadammue la umpatette tau lako katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kiissanammi anna kioreammo kumua Ikomo to Masero lu yao mai Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma'kada pole omi Puang Yesus nakua: “Inde sapulo duakoa'e Kao umpilekoa', sapo dengarria mesa setang!” ");
INSERT INTO mqjNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Inde nasanga setang Puang Yesus-e iamo Yudas anakna Simon Iskariot, annu iamo la umpa'perososanni moi anna nakala' duka' sapulo dua passikolana Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mangkai too, ulleleammi tondok Puang Yesus illaan lili'na Galilea. Moka lu lako Yudea annu morai perepi'na to Yahudi dio la umpateii. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Attu iatoo la madappi'mi allo kamai sinapakaroa' to Yahudi disanga Allo Ma'lantang Daun. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ma'kadami sirondongna Puang Yesus lako nakua: “Pellei inde angngenanne ammu lu lako Yudea, anna malara naita passikolamu pengkarangammu. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Annu tae' dengan tau umbuni pa'palakona ke moraii la kaissanan. Ianna siumpogau'ko tanda memangnga-mangnga, pa'paitanni lako angganna tau!” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ia nangei mantula' susi sirondongna annu tae' duka' ummorean Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Natimba' Puang Yesus nakua: “Ta'pa Kao nalambi' attunna la kungei umpa'peissanan kaleku, sapo attunna liu ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tae' iko dengan lalanna la naola ungkabassikoa' lino, sapo innang la nakabassingku Kao annu sikutulasan liui gau' kadakena. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Laomokoa' iko ullomba allo dipakaroa' temo, tae'nakkao la lao annu ta'pa nalambi' attungku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Susimi te kadanna Puang Yesus lako sirondongnae. Torro tongampi Puang Yesus dio Galilea. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Le'ba asanni sirondongna la lao ullomba inde sara'e, mengkalao buni duka' Puang Yesus mesai tae' dengan tau ummissananni. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Marassanni tau masara' umpeang liumi Puang Yesus perepi'na to Yahudi, anna pantan mekutana nakua: “Umbara nangei?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Budami tau sibisik-bisik umpokada Puang Yesus. Dengammi ungkuai: “To madota'.” Dengan ungkuai: “Tae', buda tau napapusa.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sapo tae' dengan tau barani umpemandui untula'i annu marea' lako perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Inde anna matangngamo rame-ramee, tamami Banua Ada'na Puang Allata'alla Puang Yesus anna parandukki ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mangnga-mangngami angganna perepi'na to Yahudi anna ma'kada nakua: “Umbamo ia nakua inde tau anna mala susi kapaissanannae anna tae' dengan napassikolai?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Natimba' Puang Yesus nakua: “Inde kupa'patuduanne tangngia pepatudu dio mai kaleku, sapo pepatudunna to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Angganna to morai unturu' pa'kuanna Puang Allata'alla la naissanan umba nangei buttu inde pepatudungkue, lu yaorika mai Puang Allata'alla lu diorika mai kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Benna-benna umpalanda' pepa'guruan kalena, kamatandeanna ia napeang. Sapo ianna to umpeang kamatandeanna to ussuai, to malolo ia anna tae' dengan pa'pakena illaan penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mangkamokoa' napalandasan Musa parentana Puang Allata'alla. Sapo tae' tappa'koa' dengan unturu'i. Maakari ammu moraia' la umpateina'?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Natimba' tau buda nakua: “Tattasangko! Bennamo Iko morai la umpateiko?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Natimba' Puang Yesus nakua: “Angga sia mesa karangan kupalako anna allo katorroan ammu mangnga-mangngamoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sapo siumpalako siamokoa' duka' karangan ke allo katorroan ke ussunna'koa' tau, annu umpalakokoa' parenta nabengangkoa' Musa. Sapo sitonganna inde parenta sunna'e tae' lu dio mai Musa annu mengkalao diomi mai nene-nenemua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Umpalakokoa' pa'sunnasan ke allo katorroan annu marea'koa' la ullenda parenta sunna' nauki' Musa, maakari ammu keara' lako kaleku ke umpomalapu'na' sangkalebu batang kalena mesa tau ke allo katorroan? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Daua' tokke' umpasala tau situru' diitanna, sapo situru' kamaloloan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mangkai too, dengammi pira-pira to Yerusalem ma'kada nakua: “Anna umbai iamo para' te to marassan dipeangan lalan la dipateie? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Maakari anna tae' dengan tau ungkambaroanni anna loasamo mantula' illaan alla'-alla'na tau kamban? Umbai naissanammoka perepi'ta kumua To dibasseimo bayu-bayu la ma'pasalama'? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sapo taissanannia kabuttuanna inde taue, anna tae' ia dengan tau la ummissanan kabuttuanna To dibassei bayu-bayu la ma'pasalama' ke saemi.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Marassanni ma'pa'guru Puang Yesus illaan Banua Ada'na Puang Allata'alla, napemanduimi mantula' nakua: “Tongannaraka kumua muissananna' anna umba kungei buttu? Tangngia Kao pa'kuangku kupolalan sae, sapo pa'kuanna to ussuana' to sipato' diorean. Sapo tae'a' iko muissanan to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kuissanan Kao annu iamo kungei buttu anna iamo to ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Attu iatoo moraimi la umpealai Puang Yesus sapo tae' dengan tau mala ummanda'i annu ta'pa nalambi' attunna. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Budami to dio reen attu iatoo ummorean Puang Yesus, anna ma'kada nakua: “Manassami kumua To dibasseimo bayu-bayu la ma'pasalama' inde taue annu umbai ta'mo dengan la untondonni budanna tanda memangnga-mangnga napogau'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dengan pira-pira to Farisi urrangngi tau buda sikabisik untula' Puang Yesus. Ma'mesami sola angganna kapala imam anna ussua pira-pira to undagai Banua Ada'na Puang Allata'alla lao ussakka Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma'kadami Puang Yesus lako tau buda nakua: “La sappai' mandamikia' sola angku le'bamo sule langngan To ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","La mupeangna' sapo tae'na' dengan la mulambi', annu tae'koa' mala sae lako angngenan la kungei.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sipantula'-tula'mi perepi'na to Yahudi nakua: “Umbamo ia la naola napolalan tae' dengan la talambi'? La laorika umpellambi'i solata to Yahudi to torro dio lembang senga' sola to Yunani anna umpa'guru to Yunani? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Akamo kalembasanna tula'na kumua la tapeang sapo tae' dengan la talambi', anna tae'ki' mala lao lako angngenan la nangei?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Inde anna allo katampakannamo sara'e, iamo pole' nangei randan maroa'na. Ke'de'mi Puang Yesus illaan Banua Ada'na Puang Allata'alla anna metamba nakua: “Benna-benna marekko' kollongna la saena' napellambi'i anna ummiru'! ");
INSERT INTO mqjNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Anna lako to ummoreanna', nakua battakadanna Puang Allata'alla illaan Buku Masero: ‘Lolong wai katuoan illaan mai penawanna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kalembasanna wai katuoan natula' Puang Yesus iamo Penawa Masero la natarima to ummoreanni. Annu attu iatoo ta'pa dipebeen Penawa Masero annu ta'pa dipomatande Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Buda tau urrangngi tula'na Puang Yesus lambisan dengan ungkuai: “Inde tappa'mia nabi to masaemo diampaie.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nakuamo pira: “Iamo inde To dibassei bayu-bayu la ma'pasalama'e.” Sapo dengan duka' ungkuai: “La lu dioka mai Galilea To dibassei bayu-bayu la ma'pasalama'? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Annu innang tiuki' illaan Buku Masero kumua inde To dibassei bayu-bayu la ma'pasalama'e iamo peampoanna tomaraya Daud la buttu dio mai Betlehem, tondok kadadianna tomaraya Daud.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Napolalan sipekka-pekka tau untula' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dengammi tau morai la ussakkai sapo tae' tappa' dengan tau urrumbui. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sulei inde to siundagai Banua Ada'na Puang Allata'alla disua lao ussakka Puang Yesus-e, nakutanaimi kapala imam sola to Farisi nakua: “Maakaria' anna tae' mubaa sae?” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Natimba' inde to disuae nakua: “Ta'pa dengan kiita tau la nasusian manarangna mantula'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nakuamo inde to Farisie: “Napapusamokoa' duka'. ");
INSERT INTO mqjNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dengammoka duka' perepi'ta battu to Farisi ummoreanni? ");
INSERT INTO mqjNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sapo' inde tau kambanne la narua pantado aka tae' umpekalambanan pepa'guruanna Musa.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dengan mesa inde to Farisie disanga Nikodemus, to mangka lao umpellambi'i Puang Yesus. Ma'kada lako solana to Farisi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Situru' kabeasaan, tae' ia mala tokke' dipabambanni sangka' tau ke ta'pa diparessa pa'palakona sola dirangngi tula'na.” ");
INSERT INTO mqjNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Natimba' solana nakua: “To Galilearokoka duka'? Paressai Buku Masero ammu issananni kumua tae' dengan mesa nabi lu dio mai Galilea.”  ");
INSERT INTO mqjNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mangkai too sisarak-sarakmi tau pantan lao umpellambi'i banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Anggaria Puang Yesus, lu langngan ia Tanete Zaitun. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Masiangna, mebongngi'mi tama Banua Ada'na Puang Allata'alla. Buda omi tau sae umpellambi'i. Ma'lokomi Puang Yesus anna ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tapakala, saemo to untarru' issinna sura'na Musa anna to Farisi umbaa mesa baine to nalambi' ullullu' pa'bannetauan. Ussuami inde bainee ke'de' dio tingngayona tau buda ");
INSERT INTO mqjNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","anna ma'kada lako Puang Yesus nakua: “O tuangguru, inde bainee kilambi' ullullu' pa'bannetauan. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Situru' pepa'guruanna Musa, iate baine susie la disileba'-leba'i batu sabonno'na. Umba Iko nakua pikki'mu?” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iate nangei mekutana susie annu la ullilingan tangnga' Puang Yesus. Sapo angga lumbang Puang Yesus anna umpopangnguki' tarunona rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Inde anna menge liumo nasasunanne, ke'de'mi Puang Yesus anna ma'kada nakua: “Bennakoa' ussanga kalemu tae' kasalaan ikomoa' yolo ulleba' itin baineo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mangkai mantula' tadangkami Puang Yesus anna mangnguki' rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Urrangnginna tula'na Puang Yesus, le'ba simesami napollo' dio to matua. Lambisan angga mandami Puang Yesus torro sola inde bainee ke'de' liu dio angngenanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ke'de'mi Puang Yesus anna ma'kada nakua: “Umba asammo naola itin matin tauo? Tae'ka dengan umpasalako?” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Natimba' inde bainee nakua: “Tae' dengan, tuang.” Nakuamo Puang Yesus: “Tae'ko duka' la kupasala. Laomoko ammu dau umpogau' liu kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ma'kada omi Puang Yesus lako tau buda nakua: “Kaomo te kamasianganna linoe. Benna-benna unturu'na' ta'mo la nakala' kamalillinan, sapo la ummampuimi kamasiangan la napolalan ullolongan katuoan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Natimba' to Farisi nakua: “Itin kasa'biammuo tae' mala diorean annu kalemu siamo mutetteran.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Natimba' duka' Puang Yesus nakua: “Moi Kao siamo umpokada kaleku sapo tonganna annu kuissanan umba kungei buttu anna umba la kuola ke dako'. Tae' iko muissanan umba kungei buttu anna umba la kuola ke dako'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umbisarakoa' iko tau situru' pikki' rupa taummu, sapo tae' Kao dengan tau kubisara. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sapo la rapanni dengan tau kubisara innang la malolo sia pa'parokkoku annu tae'na' mesa sapo nasolaanna' Ambeku to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nakua illaan sura'na Musa simuturu'a': Ianna duamo tau siundu' kasa'bianna, malami diorean. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Anna duamo to ussa'biina', Kao siamo anna Ambeku to ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nakuamo inde mai taue: “Umbara Iko nangei Ambemu?” Natimba' Puang Yesus nakua: “Kao anna tae'na' muissanan la Ambekumo. Ia kela muissananna' la ummissanangkoa' duka' Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Angganna te maie natula' Puang Yesus anna ma'pa'guru illaan Banua Ada'na Puang Allata'alla dio sa'dena patti pemalasan. Sapo tae' dengan tau ussakkai annu ta'pa nalambi' attunna. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma'kada pole omi Puang Yesus lako nakua: “La mupeangna' annu la le'bana' sapo la tontong liukoa' iko umpogau' kasalaan lambisan dipasilamungkoa' kasalaammu. Tae'koa' mala sae lako angngenan la kuolanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nakuamo perepi'na to Yahudi: “Umbai la mentuyo, annu nakua: ‘Tae'koa' mala sae lako angngenan la kuolanna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma'kadami Puang Yesus lako nakua: “Lemba' diongkoa' iko mai anna lemba' yaonakkao mai. Lu illalangkoa' iko mai inde linoe anna lu yaonakkao mai suruga. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iamo kungei ma'kada lako kalemua' kumua la tontong liukoa' iko umpogau' kasalaan lambisan dipasilamungkoa' kasalaammu. Innang la dipasilamun tongangkoa' kasalaammu ke tae' muorean kumua: ‘Kaomo to digente' To innang dio reen’.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mekutanami inde mai taue nakua: “Benna tappa'roko Iko?” Natimba' Puang Yesus nakua: “Ta'mo dengan gunana la kutula' liu matin. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Budapi la mala kutula' anna kupasalangkoa'. Sapo anggami tula' kurangngi dio mai To ussuana' kupalanda' lako ma'rupa tau, annu' inde To ussuana'e iamo To sipato' diorean.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tae' naissanan inde mai taue kumua Ambenaria marassan natula'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mantula' pole omi Puang Yesus nakua: “Ianna untandeammokoa' Anak Mentolino ke dako', mane la muissanarria' pole' kumua Kaomo to digente' ‘To Innang Dio Reen.’ Anna la muissanammoa' duka' kumua tae' dengan aka kupalako situru' pa'kuangku. Anggami pa'patudunna Ambeku kutula'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Inde To ussuana'e sola liukan, tae'na' napamesa-mesa annu angga la napomasannangna kupalako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Marassanni te mai natula' Puang Yesus-e, budami duka' tau ummoreanni. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ma'kadami Puang Yesus lako to Yahudi to ummoreanni, nakua: “Ianna umpentoe tongangkoa' pepa'guruangku, to unturu' tongammokoa' boko'ku. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","La ummissanammokoa' pepa'guruan tongan anna iamoa' la mupolalan dilappasan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Natimba' inde mai taue nakua: “Kami te maie, peampoannakan Abraham. Ta'pakan dengan naposabua' tau. Akamo kalembasanna tula'mu kumua la dilappasangkoa'i?” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Natimba' Puang Yesus nakua: “Sitonganna benna-benna umpogau' kasalaan, naposabua' kasalaan. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Anna mesa sabua' tae' la tontong angngenanna illaan kasarapuanna to umposabua'i. Sapo ianna anak dadian innang la tontong angngenanna illaan kasarapuan. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Dadi ianna Anaknamo Puang Allata'alla ullappasangkoa', manassa lappa' tongan-tongammokoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kuissanan kumua peampoannakoa' Abraham, sapo moraikoa' la umpateina' annu' mokakoa' umperangngii pepatudungku. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iamo kuita lako Ambeku, iamo kutulasangkoa', sapo pepatudunnaria' iko ambemu mupalako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Natimba' inde mai taue nakua: “Abraham kami ambeki.” Nakuamo Puang Yesus: “Ia kela anakna tongangkoa' Abraham, innang la muturu'a' pa'palakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kutulasangkoa' pepa'guruan tongan kurangngi dio mai Puang Allata'alla, sapo moraikoa' la umpateina'. Sisala te pa'palakona Abraham-e! ");
INSERT INTO mqjNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pa'palakona siamo iko duka' ambemua' mupogau'.” Natimba' duka' inde to Yahudie nakua: “Tangngiakan kami anak bule. Angga mesa ambeki iamo Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma'kada Puang Yesus lako nakua: “Ia kela Puang Allata'alla tongan ambemua', la mukamaseina' annu to lu yaona' mai Puang Allata'alla. Tangngia pa'kuangku kupolalan sae, sapo nasuana' Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ia mungei tae' umpekalembasan tula'ku annu tae'a' mutaro urrangngi pepa'guruangku. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ponggawana iko setang ambemua', anna anggamo pa'porainna mupogau'. Mengkalao dio mai, innang to papatean ia ponggawana setang. Tae' ia dengan ke'de' dio katonganan annu innang tae' dengan katonganan illaan kalena. Sipato' ia umpokada tula' tatongan, annu innang sipa'namo susi. Tae' ia dengan sitonganna napokada annu iamo kabuttuanna angganna tula' tatongan. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sapo tula' tongan Kao kupokada, iamo mungei tae' ummoreanna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bennakoa' mala unturoanna' kasalaangku? Ianna kupokadangkoa' tula' tongan, maakari anna tae'na' muorean? ");
INSERT INTO mqjNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Angganna to napoanak Puang Allata'alla umperangngii battakadanna Puang Allata'alla. Sapo tangngiakoa' iko to napoanak Puang Allata'alla, iamo nangei tae' muaku muperangngii battakadanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma'kadami inde mai to Yahudi lako Puang Yesus-e nakua: “Tonganna tula'ki kumua to Samariako, to natamaiko setang.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Natimba' Puang Yesus nakua: “Tae'nakkao natamai setang. Umpomatanderakkao Ambeku sapo mutellena'. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tangngia Kao kamatandeangku kupeang, dengan Kao to umpeanganna' kamatandean anna iamo to ma'bisara. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sitonganna angganna to unturu' battakadangku, ta'mo la mate.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nakuamo inde mai to Yahudie: “Kiissanan tappa' pole' temo kumua natamaiko setang! Annu Abraham anna mangkamo bonno', susi toi duka' angganna nabi. Sapo mukua iko ‘Angganna to unturu' battakadangku ta'mo la mate.’ ");
INSERT INTO mqjNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","La marru ma'tandalangnganangkoka Iko anna ambeki Abraham? Annu mangkamia bonno' Abraham sola angganna nabi. Benna Iko musangaian kalemu?” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Natimba' Puang Yesus nakua: “Ianna Kao siamo la untandean kaleku, innang tae' la ma'guna. Sapo Ambekuri Kao untandeanna' to simukuanna' Dewatangki ");
INSERT INTO mqjNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","sapo' tae' muissanan. Kuissanan Kao, ianna kukua tae' kuissanan to tamantula' tonganna' susikoa'. Kuissanan Kao Ambeku anna kuturu' angganna battakadanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Masannang ia Abraham, ambemua' annu naissanan kumua la ummita allo kasaeangku, anna dore'mo temo annu naitamo'!” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma'kada inde mai to Yahudie nakua: “Umba mukua la ummita Abraham anna ta'pa ganna' lima pulo taummu temo?” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Natimba' Puang Yesus nakua: “Kupokadangkoa' sitonganna, ta'pa ia dadi Abraham innang diomokkao reen.” ");
INSERT INTO mqjNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tappana urrangngi tula'na Puang Yesus, ummala siami batu inde mai to Yahudie anna la ussileba'-leba'i Puang Yesus. Sapo membuni Puang Yesus anna le'ba umpellei Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ummolai lalan Puang Yesus, ummitami mesa to buta mengkalao dio mai dadinna. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mekutanami passikolana nakua: “O Tuangguru, bennanna te kasalaanne, to matuannaraka inderaka dio taue napolalan innang butamo dadi?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Natimba' Puang Yesus nakua: “Tangngia kasalaanna to matuanna napolalan buta dadi, tangngia toi kasalaanna. Sapo ia nangei buta annu la naola umpakawanan kakuasaanna Puang Allata'alla lako ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Parallukia' umpalako pengkaranganna to ussuana' bayuanna masiangpa, annu la sae bongi anna ta'mo dengan tau mala la mengkarang. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ianna illaan siapa' lino, Kaomo kamasianganna lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mangkai mantula' Puang Yesus, ma'tikkudumi rokko litak anna umpasigerok litak inde elo'nae, anna mane pasussuianni matanna inde to butae. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nakuammi: “Laomoko mendau' lako limbong Siloam.” (Siloam kalembasanna “Disua”.) Mengkalao siami lao mendau' napolalan inde anna ma'pasulemoe paitami. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Angganna sabanuanna sola to siummitai kapelau-lau ma'kada nakua: “Anna umbai iamo te to siummokko' kapelau-laue?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dengan ungkuai: “Ia tongan.” Sapo dengan duka' ungkuai: “Tangngia, sapo susi.” Sapo nakua inde taue: “Kaomo tee.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nakuammi tau: “Umbara iko mukua ammu mala paita?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Natimba' inde taue nakua: “Umpasigerok litak elo'na iato to disanga Yesus-o anna pasussuianni matangku. Mangkai nakuammo', ‘Laoko mendau' lako limbong Siloam.’ Le'bamo', mangkana' mendau' paita siamo'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mekutanami inde mai taue nakua: “Umba nangei itin tauo?” Natimba' nakua: “Tae' kuissanan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Inde anna umpasigerok litak elo'na Puang Yesus anna umpomalapu' to butae, sirupang allo katorroan. Iamo nangei dibaa lako to Farisi iato to buta to mane mangka dipomalapu'o. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nakutanaimi duka' to Farisi, nakua: “Umba nakua ammu mala paita?” Natimba' nakua: “Napasussui rura matangku angku mane lao umbaseii, mangkanna paita siamo'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nakuamo pira-pira to Farisi: “Manassa tae' buttu yao mai Puang Allata'alla itin tauo, annu tae' umpepairanan allo katorroan.” Nakuamo pira: “Tae' natamai akkalan la to kasalaan umpogau' inde tanda memangnga-mangnga susie!” Napolalan sipekka-pekka to Farisi. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mekutana pole omi to Farisi lako inde to buta angngena'e, nakua: “Umba iko nakua pikki'mu annu iko napomalapu'?” Natimba' nakua: “Mesa nabi.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sapo tae' naorean perepi'na to Yahudi kumua buta tongan inde tau angngena'e anna malamo paita temo. Napolalan napopetambai to matuanna, ");
INSERT INTO mqjNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","anna kutanaii nakua: “Anakmu tongarraka indee, iato mukuan innang butami dadio? Umba nakua anna malamo paita temo?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Natimba' to matuanna inde taue nakua: “Anakki tongarri kami tee, anna natimang tongan buta dadi. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sapo tae' kiissanan umba nakua anna malamo paita temo, tae' toi kiissanan benna umpomalapu'i. Kutanaimia' lako, la naissammia duka' natimba' kalena annu anak muanemi.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ia nangei mantula' susi to matuanna inde taue, annu marea' lako perepi'na to Yahudi. Annu mangkami ummala kada situru' perepi'na to Yahudi kumua angganna to mangngaku kumua Yesus iamo To dibassei bayu-bayu la ma'pasalama', ta'mo mala tama banua pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iamo nangei nakua to matuanna inde taue: “Kutanaimia' lako annu anak muanemi.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Untambai pole omi iato to ambo' butao anna kuanni: “Ma'pindako dio olona Puang Allata'alla kumua la mutula' sitonganna, annu kikua kami, itin to umpomalapu'koo to kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Natimba' nakua: “Tae' kao kuissanan kumua to kasalaarraka tangngiaraka. Anggami kao kuissanan ambo' butana' sapo paitamo' temo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nakutanai pole omi perepi'na to Yahudi nakua: “Akara iko napogau' lako kalemu? Naakaroko iko ammu mala paita?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Natimba' inde taue nakua: “Mangkamokoa' kutetteranan sapo tae'a' muperangngii. Maakari ammu morai pole la urrangngii? Morairokokaa' duka' la unturu'i?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Keara' siami perepi'na to Yahudi lako inde taue, nakuanni: “Iko iko to unturu'i, tae' kami kituru'. Musa kami kituru'. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kiissanan kumua mangka umpantula'i Musa Puang Allata'alla, sapo itin tauo sae lako kabuttuanna tae' kiissanan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Natimba' inde taue nakua: “Senga'-senga'koa' ke sia tae' muissanan umba nangei buttu itin tauo, annu mangkamokkao napomalapu' lambisan malamo' paita. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taissanan kumua tae' umperangngii pelaunna to kasalaan Puang Allata'alla sapo angga to mengkarea' langngan anna to umpogau'i pa'kuanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mengkalao dio mai pa'parandukanna lino ta'pa dengan tau mala umpomalapu' to natimang buta dadi. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dadi ianna tae' buttu yao mai Puang Allata'alla itin tauo innang tae' sia dengan aka mala napogau'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Natimba' perepi'na to Yahudi nakua: “Aka mukua? Ikoka itin to innang sitoang kasalaan dadi la umpatudukanno?” Mengkalao attu iatoo ta'mo ditangga' tama banua pa'sambayanganna to Yahudi inde to napomalapu' Puang Yesus-e. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nakarebanna Puang Yesus kumua ta'mo ia ditangga' tama banua pa'sambayanganna to Yahudi inde to napomalapu'e, mengkalao siami lao umpellambi'i anna kuanni: “Ummoreangkoka Anak Mentolino?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Natimba' inde taue nakua: “O Tuang, bennara dikuan. Pokadaan siapa' angku oreanni.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nakuamo Puang Yesus: “Mangkami muita anna marassangko sipantula' temo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nakuamo inde taue: “O Puang, kuorean.” Malimuntu' siami umpenombai Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma'kada pole omi Puang Yesus nakua: “Kasaeangku tama lino iamo la ma'bisara, anna malara paita to buta anna buta to ussanga kalena paita.” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Inde tula'na Puang Yesus-e narangngi pira-pira to Farisi, to dio reen attu iatoo. Nakuamo lako Puang Yesus: “Mukuaka butakangkami duka'?” ");
INSERT INTO mqjNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Natimba' Puang Yesus nakua: “Ia kela butakoa', tae'koa' kasalaan. Sapo mukuaa': Paitakan, dadi tontongkoa' kasalaan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Umpatarru'mi tula'na Puang Yesus nakua: “Sitonganna, ianna dengan tau unteka'i bala domba, tae' ummola tama ba'ba bala, tau iatoo to maboko anna to parappa. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sapo ianna to ummola tama ba'ba bala, tau iamo too to ma'kambi'na domba. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","La natungka'ianni ba'ba to undagai bala. La naula' angganna dombana annu narangngi kamaranna ke natambaimi sanganna simesa-mesa anna solaanni lako salian. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ianna dio asammo salian domba, nayoloanammi inde to ma'kambi'e naula'mi dombana annu naissanammi kamaranna. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tae' la naaku ummula' tau senga' ke natambaii sangngadinna la napellei lao annu tae' naissanan kamaranna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pa'rapanan iatee napokada Puang Yesus lako to Farisi sapo' tae' naissanan kalembasanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Napolalan mantula' pole Puang Yesus nakua: “Kupokadangkoa' sitonganna, Kaomo sirapan ba'ba la naola domba tama balana. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Angganna to uyyoloina' sae, to maboko ia anna to parappa, sapo tae' naperangngii kamaranna domba. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kaomo te ba'bae. Benna-benna tama bala anna ummolai kaleku, la salama'. La loasa lu tama lu illaan mai anna la ullambi' reu lobo'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Angga ia sae maboko sola papatean anna papokak to maboko. Sapo kasaeangku Kao anna malara ullolongan katuoan ma'rupa tau, masannang illaan katuoanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kaomo to ma'kambi' tongan. Ianna to ma'kambi' tongan nadotaan mate anna la sanggangmo dombana. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sapo ianna to disaroi, tangngia to ma'kambi' tongan tangngia toi puangna domba, la le'ba kumondong umpellei domba nakambi' ke ummitami sae serigala. Napolalan undokkok domba inde serigalae anna sembu'i lao pira. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ia nangei le'ba kumondong inde to disaroie annu angga ia pa'pesaro napolalan mengkarang, ta'mo umposamelean inde mai dombae. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kaomo to ma'kambi' tongan. Ummissananna' angganna dombaku anna naissanan asanna' duka', ");
INSERT INTO mqjNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","susi Ambeku ummissananna' anna kuissanan toi duka'. Ussoronganna' sunga'ku la napolalan tuo dombaku. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dengampi duka' domba senga' kuampui sapo tangngia satappaan lentekna inde mai dombae. La parallu duka' kubaa sae anna la umperangngii kamarangku lambisan angganna domba la ma'mesami nakambi' mesa to ma'kambi'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nakamaseina' Ambeku annu la ussoronganna' sunga'ku angku malara tuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tae' dengan tau mala umpateina' ke tangngia pa'kuangku. La umpebeenna' kaleku dipatei annu situru'mi pa'kuangku. Ma'kuasana' umpa'pesorongan kaleku dipatei, anna ma'kuasa toina' umpatuoi sule. Iamo te passanan nabenganna' Ambekue.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sipekka-pekka pole omi to Yahudi annu urrangngi inde tula'na Puang Yesus-e. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Buda tau ungkuai: “Natamai setang! To tattasan! Tae' dengan gunana muperangngia'i.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sapo dengan siami duka' ungkuai: “Tae' te susi battakadanna to natamai setangnge! Malarika umpomalapu' to buta setang?” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tae' masae mangkanna, dipakaroa'mi allo kamai umpengkilalai anna diseroi Banua Ada'na Puang Allata'alla dio Yerusalem. Attu iatoo attunna omo masakka' padang. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Marassanni menono'-nono' Puang Yesus yao sali-salinna Salomo illaan Banua Ada'na Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","saemi to Yahudi ullillingngi anna kutanaii, nakua: “Pirampi ammu mane monda umpabeaikan ma'sarubeba'? Paleangan manappamokan ke sia Ikomo To dibassei bayu-bayu la ma'pasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Natimba' Puang Yesus nakua: “Mangkamokoa' kupokadaan sapo' tae'a' muorean. Angganna pengkarangan kupalako umpotendan kakuasaanna Ambeku, iamo umpakawananni kumua benna tappa'na'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sapo tae'a' muorean annu tae'koa' nakala' bilanganna dombaku. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Angganna dombaku umperangngii tula'ku. Kuissanan dombaku anna naturu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kubenganni katuoan la da'da' anna ta'mo la mate sae lako-lakona. Tae' dengan tau mala urrappai dio mai lisu pala'ku. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Inde dombakue pa'pebenganna Ambeku to untanda langnganni angga lako, anna tae' dengan tau mala urrappai dio mai lisu pala'na Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kao anna Ambeku to mesakan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ummala pole omi batu to Yahudi anna la ulleba'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Sapo' nakuanni Puang Yesus: “Buda karangan mapia napapassannianna' Ambeku mangka kupalako muitaa'. Umbannamo mupolalan la ulleba'ina' batua'i?” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Natimba' inde to Yahudie nakua: “Tangngia pengkarangan mapia mupogau' kipolalan la ulleba'iko batu, sapo untelleko Puang Allata'alla. Ussangako kalemu Puang Allata'alla anna ma'rupa tauko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Natimba' Puang Yesus nakua: “Anna umbai dengan tiuki' tula'na Puang Allata'alla illaan Sura' Parentamua' nakua: ‘Sangngin dewatakoa'’. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Taissanan kumua angganna battakada tiuki' illaan Buku Masero la da'da' sae lako-lakona. Dadi ianna ussanga dewata to napatu battakadanna Puang Allata'alla ");
INSERT INTO mqjNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","maakari ammu kuanna' untelle Puang Allata'alla ke kukuai: ‘Anaknana' Puang Allata'alla?’ Kao To nabassei bayu-bayu Ambeku anna suana' tama lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ianna tae'na' umpalako karangan napapassannianna' Ambeku, daua' oreanna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sapo ianna kupalako, la muorean inde pengkarangkue moi anna tae' muaku ummoreanna' anna malara muissanan sola mupekalembasan kumua mesa kappa'na' Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nasandak omi la umpealai Puang Yesus sapo le'ba ullessusan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sulemi Puang Yesus lian lamban lianna Salu Yordan, angngenan nangei mantedok Yohanes yolona, anna torro sambali'. ");
INSERT INTO mqjNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Buda omi sae tau umpellambi'i, anna ma'kada nakua: “Tae' dengan tanda memangnga-mangnga napadadi Yohanes sapo angganna tula'na umpokada inde taue tonganna asan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Buda tau mangngorean dio angngenan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pissan attu dengan to masaki disanga Lazarus, sitorro dio tondok Betania sola sirondongna disanga Maria anna Marta. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Inde Mariae iamo to mangka umbolloi minna'-minna' bumanangnga' lentekna Puang Yesus anna mane napassii beluakna. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mepasammi inde dua baine lako Puang Yesus-e nakua: “O Tuang, masaki iato to mukamaseio.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Inde anna urrangngimo kareba Puang Yesus-e, nakuamo: “Itin sakinnao tae' la napobaa, sapo la naola umpakawanan kamatandeanna Puang Allata'alla anna malara dipomatande Anakna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Inde Marta sola Maria anna Lazarus-e nakamasei tongan-tongan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sapo ta'raia tappa mengkalao Puang Yesus anna urrangngi kareba kumua masaki Lazarus sapo duangngallopi torro dio angngenan nangei. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lessu'i tee, nakuamo Puang Yesus lako passikolana: “La ma'pasulekia' lako lembangna Yudea temo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Natimba'mi passikolana nakua: “O Tuangguru, mane mangka sigaliko la nasileba'-leba'i to Yahudi. Maakari ammu la ma'pasule lako?” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nakuamo Puang Yesus: “Dengan sapulo dua tettek illaan sangngallona. Benna-benna menono' ke allo tae' la titodo annu' masiang naita. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sapo benna-benna menono' bongi la titodo annu' tae' ummampui kamasiangan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Susimi te tula'na Puang Yesus-e. Nakua pole omo lako passikolana: “Mamma' temo sa'do'doranta Lazarus sapo la lao kutundan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nakuanni passikolana: “O Puang, ianna mamma' Lazarus, la malapu' sule.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sapo inde tula'na Puang Yesus kumua mamma'e, kalembasanna bonno'mi. Nasangamia passikola mamma' tongan. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Napolalan natulasan pissanni Puang Yesus, nakua: “Bonno'mi Lazarus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Sapo' mapiaria aka tae'na' dio reen anna bonno' annu inde kamateannae la ma'guna lako kalemua' ammu malara mangngorean lako kaleku. Anta laomoa' umpellambi'i Lazarus.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nakuamo Tomas to sidikuan to Rambung, lako pada passikolana: “Anta laoa' duka' ummula'i make bonno'kia' sola.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Saei lako Betania Puang Yesus, innang appa' tabongimi diona liang Lazarus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Inde tondok Betaniae sikadappi' Yerusalem, umbai angga tallu kilo alla'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Budami to Yahudi sae ullomba anna umpakatana Marta sola Maria diona kamateanna sirondongna. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Narangnginna Marta kumua saemi Puang Yesus, mengkalao siami lao untammuii. Sapo torro ia Maria illaan banua. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Nakuamo Marta lako Puang Yesus: “O Puang, kela indeko innang tae' sia la bonno' sirondongku. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sapo kuissanan kumua moi anna susimo inde temoe la nabengampoko Puang Allata'alla aka mupelau.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Natimba' Puang Yesus nakua: “La tuo sule sirondongmu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nakuamo Marta: “Kuissanan kumua la tuo sule Lazarus ke dipatuo asammi sule to mate ke la tallammi lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Natimba' Puang Yesus nakua: “Kaomo to umpatuo sule to mate anna to umpebengan katuoan. Benna-benna mangngorean lako kaleku, la tuo moika anna matemo. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Anna angganna to ullolongan katuoan ummolai kapangngoreananna lako kaleku ta'mo la mate sae lako-lakona. Muoreangka te tula'kue?” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Natimba' Marta nakua: “O Puang, kuorean kumua Ikomo Anakna Puang Allata'alla, To dibassei bayu-bayu la ma'pasalama', to la sae tama lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mangkai mantula' Marta, mengkalaomi lao untambai Maria, sirondongna anna bisikki nakua: “Sae Tuangguru, natambaiko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tappana urrangngi tula'na Marta, ke'de' siami Maria anna lao umpellambi'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Attu iatoo ta'pa sae tama tondok Puang Yesus, sapo torropi dio angngenan nangei untammuii Marta. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Inde mai to Yahudi to marassan umpakaranga Maria illaan banuae ummita Maria ke'de' anna ma'sirra'-sirra' le'ba'. Naula'mi annu nasanga la lao umbating lako liang. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Saei lako angngenan nangei torro Puang Yesus, malimuntu' siami Maria dio tingngayona anna kuanni: “O Puang, kela indeko innang tae' sia la bonno' sirondongku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ummitanna Maria sola angganna to Yahudi to ummula'i menge tumangi', rosso siami buana anna masussa penawanna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mekutanami nakua: “Umba mungei ullamunnia'i?” Natimba'mi nakua: “O Puang, maimoko ammu lao umpetua'i.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tumangi' siami Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nakuamo inde mai to Yahudie: “Tae' dengan pada ungkamasei Lazarus!” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sapo' dengan pira-pira tau ungkuai: “Naissan umpomalapu' to buta napolalan paita, maakari anna tae' la naissan umpeang lalan anna malara tae' bonno' Lazarus?” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Rosso pole omi buana Puang Yesus anna mengkalao lako liang. Inde liangnge dilokko' anna ditutu'i batu kamai. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nakuamo Puang Yesus: “Beroia' itin batuo.” Sapo natimba' Marta, sirondongna inde to matee nakua: “O Puang, appa' tabongimi mangkanna dilamun, ta'mo la disara bosinna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nakuamo Puang Yesus: “Mangkako kukuan: Ianna mangngoreangko, la ummitako kamatandeanna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Umberoimi batu inde mai taue. Membulangimi Puang Yesus anna ma'kada nakua: “O Ambeku, ma'kurru' sumanga'na' matin annu murangngimi pelaungku. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kuissanan kumua simuperangngii liuna', sapo ia kungei mantula' matin temo anna malara narangngi inde mai taue napolalan naorean kumua Iko ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mangkanna mantula' Puang Yesus, napasilombung siami metamba nakua: “O Lazarus, suungko illaan mai!” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lemba' siami illaan mai lokko' inde to mangka bonno'e. Montongpi naputu' pebalun lentekna sola limanna anna titutu'pa lindona. Nakuamo Puang Yesus: “Bukaia' balunna anna issanni menono'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Buda to Yahudi to sae ullomba Maria ummorean Puang Yesus aka ummita kara-kara napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sapo dengan duka' lao umpellambi'i to Farisi anna pokadanni aka mangka napogau' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Napolalan pira-pira to Farisi sola kapala imam urrempun solana to nakala' pa'bisara alukna to Yahudi, anna sipantula'-tula' nakua: “La maakamikia', annu budamia tanda memangnga-mangnga napogau' inde taue? ");
INSERT INTO mqjNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ianna tapabeaia', la naorean asammi tau, napolalan sae to Roma urrappaikia' Banua Ada'na Puang Allata'alla sola lembangta.” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sapo dengan mesa tau disanga Kayafas, Pongkena Imam illaan taun iatoo, ma'kada nakua: “Tae' tongan-tongan dengan aka muissanna'i. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ta'raka muissanan kumua malamia mesa tau bonno' ussonda tau buda anna la tallan asan tau illaan inde lembangtae?” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Inde tula'na Kayafas-e, sitonganna tae' buttu illaan penawanna, sapo naparunduk Puang Allata'alla umpokada diona la kamateanna Puang Yesus ussonda to Yahudi, annu ia Pongkena Imam taun iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Anna tangngia angga to Yahudi, sapo la napolalan tirempun anna ma'mesa angganna anakna Puang Allata'alla to tisembu' illaan lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mengkalao diomi tee nangei umpasarandan kada perepi'na to Yahudi la umpatei Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iamo nangei ta'mo dengan umpa'paitaan kalena Puang Yesus lako to Yahudi. Le'ba'mi umpellei Yudea anna lu lako mesa tondok disanga Efraim sikadappi' padang alla' anna torro dio sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Attu iatoo madappi'mi la napakaroa' to Yahudi allo kamai disanga Paskah. Budami tau mengkalao lako Yerusalem lu dio mai tondok-ma'tondok la lao umpepattingngi kalena situru' kabeasaanna to Yahudi anna mane lambi'i allo Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Umpeang matami Puang Yesus inde mai taue. Inde anna silambi'-lambi'mo illaan Banua Ada'na Puang Allata'allae, sipantula'-tula'mi nakua: “Umbaiko nakua pikki'mu, la saerika ullomba inde karoasanne?” ");
INSERT INTO mqjNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mangkami umpasuun parenta kapala imam sola to Farisi kumua benna-benna ummissanan nangeinna torro Puang Yesus, la sae napokada anna malara lao disakka. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Annampi bonginna anna mane nalambi' allo Paskah anna saemo Puang Yesus lako Betania tondokna Lazarus, to mangka napatuo sule. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ditosaemi dio natarakanni Marta. Dio duka' reen Lazarus ummande sola Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Saemi Maria umbaa minna'-minna' masulli' allinna, disanga minnak narwastu umbai sitangnga lite'. Umbolloimi lentekna Puang Yesus anna mane passii beluakna. Titumpan siami bumanangnga' ponno banua. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma'kadami mesa passikolana Puang Yesus disanga Yudas Iskariot (to la umpa'perososan Puang Yesus), nakua: ");
INSERT INTO mqjNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Maakari anna tae' dibaluk tallu ratu' pera' itin minna'-minna'o anna ditawaian to mase-mase allinna?” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sitonganna tangngia to mase-mase napikki' nangei ma'kada susi annu' inde Yudas-e mesa to maboko, tokke' siummala doi' dipada-padai illaan mai angngenan doi' annu ia siummannai. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nakuamo Puang Yesus: “Parandan mammia' annu napalakomia aka la dipogau' ke dilamunna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","La sola liukoa' ia to mase-mase sapo Kao-kao tae'kia' la sola liu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Buda to Yahudi umpekarebai kumua diomi Betania Puang Yesus, iamo nangei le'ba'mo lako. Tae' angga Puang Yesus la lao natungka, sapo morai duka' la ummita Lazarus, to napatuo sule Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ummalami kada situru' kapala imam la umpatei duka' Lazarus ");
INSERT INTO mqjNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","annu katuoannamo sule napolalan buda to Yahudi umpemboko'i perepi'na anna mangngorean lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Masiangna, nakarebami tau buda to sae umpakaroa' allo Paskah kumua ummola lalammi Puang Yesus la lu langngan Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pantan ummalami daun sitonda batang susi daun andulan anna lao untammui Puang Yesus napasiolaan sipetamba-tambaan nakua: “Dipakasalle sanganna Puang Allata'alla. Ditamba' to sae umpotendan sanganna Dewata. Ditamba' Tomarayanna to Israel.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ummalami mesa keledai mangngura Puang Yesus anna sakeii. Lemba' pole' battakadanna Puang Allata'alla tiuki' illalan Buku Masero nakua: ");
INSERT INTO mqjNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Daua' marea' anggammu issinna Sion! Itamia', saemi tomarayammu ussakei keledai mangngura.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Attu iatoo ta'pa napekalembasan passikolana Puang Yesus inde mai kara-karae sapo mangkanna tuo sule anna diangka' langngan angngenan kamatandean, mane nakilalairi kumua aka napogau' tau lako kalena innang mangkami diuki' illaan Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Angganna to dio reen anna untambai Lazarus Puang Yesus illaan mai liang napatuo sule, untula' liu inde kara-karae. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iamo nangei buda sigalimo tau lao untammui Puang Yesus annu narangngimi kumua Puang Yesus-ria umpogau' iato tanda memangnga-mangngao. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sipantula'-tula'mi to Farisi nakua: “Ta'mo diissan aka la dipogau'. Petua'mia' naturu' asammi tau illaan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Dengan duka' pira-pira to Yunani lao langngan Yerusalem umpenombai Puang Allata'alla attunna dipakaroa' allo Paskah nasolaan inde mai tau budae. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inde mai to Yunanie lao umpellambi'i Filipus anna kuanni: “O Tuang, moraikan la silambi' Puang Yesus, ke sia mala.” (Inde Filipus-e to lu dio mai tondok Betsaida dio lembangna Galilea.) ");
INSERT INTO mqjNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mengkalao siami Filipus lao umpellambi'i Andreas anna pokadanni anna mane lao sola umpellambi'i Puang Yesus anna tulasanni diona pelaunna to Yunani. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nakuamo Puang Yesus: “Nalambi'mi attunna la dipakasalle Anak Mentolino. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kupokadangkoa' sitonganna, ianna tae' ditanan rokko litak lise' gandum sirapan to mate la montong liu angga salise', sapo ianna dilamun la kembea'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Benna-benna umpakalando katuoanna illaan lino la ungkasayu'i katuoanna. Sapo benna-benna tae' umpakalando katuoan illaan lino, la da'da' ia katuoanna sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Benna-benna morai la kupopengkarang la naturu'na' anna malara umba-umba kungei la sola liukan. Benna-benna kupopengkarang la napakasalle Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Masussa penawangku temo. Akamo la kupokada? La kukuaraka: ‘O Ambe' lappasanna' dio mai kamaparrisan la ullambi'na' temo?’ Sapo iari kungei sae inde lino annu la ullambi'na' inde kamaparrisanne. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O Ambeku, pakawanammi kamatandeanna sangammu.” Dirangngi siami kamara yao mai langi' nakua: “Mangkami kupakawanan kamatandeangku anna la kupakawanan polepa.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Buda to dio reen attu iatoo urrangngi inde kamarae. Dengammi ungkuai: “Guntu'!” Sapo dengan duka' kumua: “Tangngia! Malaeka' umpantula'i!” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nakuamo Puang Yesus lako inde tau kambanne: “Inde kamara murangngia'e tangkao napatu, sapo ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Temo nalambi'mi attunna la dibisara issinna lino. Nalambi'mi attunna la dirambai lao ponggawana setang to ungkuasai lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Anna la urruntu'nakkao angganna ma'rupa tau lako kaleku ke mangkamo' ditandean illaan lino.” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia nangei mantula' susi Puang Yesus annu la naola umpa'peissanan umba la nakua kamateanna ke dako'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nakuamo inde tau budae: “Dengan tiuki' illaan Buku Masero kumua, To dibassei bayu-bayu la ma'pasalama' la tuo sae lako-lakona. Maakari anna mukua Anak Mentolino innang la ditandean illaan lino? Benna dikuan Anak Mentolino?” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Natimba' Puang Yesus nakua: “Ta'mo la masae torro kamasiangan illaan alla'-alla'mua'. Iamo too penono'mokoa' pakale pa'de kamasiangan indana lambi'koa' kamalillinan, aka benna menono' illaan kamalillinan tae' la naissanan naolanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Oreangkoa' inde kamasianganne bayuammu solapa lakoa' ammu malara digente' to nakala' kamasiangan.” Mangkanna mantula' Puang Yesus, le'ba'mi umpellei angngenan iatoo anna ta' opa naaku umpa'paitaan kalena lako tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Moika anna budamo tanda memangnga-mangnga napogau' Puang Yesus dio tingngayona to Yahudi, sapo tae' ummorean Puang Yesus ");
INSERT INTO mqjNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","anna malara lemba' kadanna nabi Yesaya nakua: “O Puang, bennamo la ummorean inde kareba kipalanda'e? Bennamo la dipaitai kakuasaammu?” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iamo nangei tae' nabela mangngorean annu mangka duka' napokada nabi Yesaya nakua: ");
INSERT INTO mqjNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ma'kada Puang Allata'alla nakua: ‘Kubutai matanna sola kupomakarrasan penawanna, anna malara tala paita matanna tala ma'paleang pikki'na, indana ma'pasulemo lako kaleku napolalan kupomalapu'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ia nangei mantula' susi Yesaya annu mangkami ummita kamatandeanna Puang Yesus anna napokada yolomo. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sapo buda siami duka' perepi'na to Yahudi mangngorean lako Puang Yesus. Sapo moka umpa'manta-mantanni annu marea' lako to Farisi indana ta'mo natangga' tama pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Annu umpakalando ia pantayukan dio mai ma'rupa tau anna la pantayukan yao mai Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mangkai too napemanduimi Puang Yesus ma'kada, nakua: “Benna-benna mangngorean lako kaleku ummorean duka' to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Anna benna-benna ummitana', ummitami to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Saena' tama lino sirapan kamasiangan anna malara angganna to mangngorean lako kaleku tae' la torro illaan kamalillinan. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ianna dengan tau umperangngii tula'ku sapo tae' napalako, tangkao la umpabambanni sangka'. Annu tae'nakkao la sae umpabambanni sangka' ma'rupa tau illaan lino sapo la kupasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Benna-benna untumpu pala'na' anna tae' umperangngii battakadangku, dengammi la umpabambanni sangka' ke tallanni lino, iamo battakada mangka kupalanda'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Annu inde mai tula' kupokadae, tangngia pa'kuangku sapo pa'kuanna Ambeku to ussuana'. Ambekumo umparentana' umpokadai la sipato'na kutula' anna kupalanda'. ");
INSERT INTO mqjNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Anna kuissanan kumua, inde parentanae la umpatettekoa' lako katuoan sae lako-lakona. Dadi angganna tula' kupalanda' situru' battakadanna Ambeku lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","La madappi'mi attunna umpakaroa' allo Paskah to Yahudi. Innang naissanammi Puang Yesus kumua nalambi'mi attunna la untampe lino ma'pasule langngan Ambena. Siungkamasei angganna to unturu'i anna tontong liu nakamasei sae lako katampakanna pengkaranganna. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Marassanni ummande Puang Yesus sola passikolana bongi iatoo, napatigara'mia ponggawana setang penawanna Yudas anakna Simon Iskariot la umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Innang naissanammi Puang Yesus kumua angga lako mangkami napalessu' rokko lisu pala'na Ambena. Naissanan toi kumua innang to buttu yao mai Puang Allata'alla anna la sule langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Napolalan ke'de' Puang Yesus ummalai bayu rui'na. Ummalami saserek sampin lenan anna pa'beke'i, ");
INSERT INTO mqjNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","anna mane untua' wai rokko loyang. Urrisimi passikolana nabaseian lentekna anna passii inde sampin napa'beke'e. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Inde anna Petrusmo nalambi'e, nakuamo: “O Puang, maakari anna Iko la umbaseianna' lentekku?” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Natimba' Puang Yesus nakua: “Inde kupogau' temoe ta'pa muissanan sapo la muissanan ke dako'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nakuamo Petrus: “O Puang, dau baseianna' lentekku.” Sapo natimba' Puang Yesus nakua: “Ianna tae'ko kubaseian lentekmu tae' kita dengan kasilombunganta.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nakuamo Petrus: “O Puang, ianna susira itinno, tangngia angga lentekku la mubasei sapo limangku duka' sola ulungku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Natimba' Puang Yesus nakua: “Makayo asammia kalena to mangkamo mendio' napolalan ta'mo manggi' dikayo pole taboko'na lentekna. Makayomokoa' sapo tae'koa' makayo asan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Naissanammi Puang Yesus benna la umpa'perososanni. Iamo nangei ma'kada kumua: “Makayomokoa' sapo tae'koa' makayo asan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mangkai umbaseian lentekna passikolana ma'bayumi sule Puang Yesus anna ma'loko. Ma'kadami lako passikolana nakua: “Mupekalembasangka inde kara-kara mane mangka kupogau' lako kalemua'e? ");
INSERT INTO mqjNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Simukuanna'a'i Tuangguru anna Puang. Tonganna tula'mua'i. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ianna Dewatammuna' anna tuanggurummu umbaseiangkoa' lentekmu la sipato'koa' duka' sibaseian lentekmu. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kubengangkoa' te tandenganne ammu palakori susi kupogau' lako kalemua'i. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kupokadangkoa' sitonganna, tae' ia dengan leleanna sabua' la untanda langnganni puangna, battu mesa to disua la untanda langnganni to ussuai. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ianna muissanan asammoa' te maie la kerongko'koa' ke mupalakoi. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Tae'koa' te napatu asan inde tula'kue annu kuissanan to mangka kupilei. Sapo innang la lemba'na battakada illaan Buku Masero kumua: ‘La nabalina' to kusolaan ummande.’ ");
INSERT INTO mqjNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kutimangkoa' te kutulasan temoe annu ianna lemba'mo la muoreammia' kumua Kaomo to digente' To innang dio reen. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kupokadangkoa' sitonganna, benna-benna untarima to kusua natarimana' duka'. Anna benna-benna untarimana' untarima duka' to ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mangkai te mantula' susi Puang Yesus-e, rossomi buana napolalan ma'kada nakua: “Kupokadangkoa' sitonganna, dengangkoa' mesa la umpa'perososanna'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sinenne'-nenne'imi passikola annu pusa' tae' naissanan benna nasanga. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Inde passikola to randan napakamaya Puang Yesus-e, ma'loko dio ia sa'dena Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nakini' matami Simon Petrus anna ungkutanai Puang Yesus bennanna nasanga. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Umbareammi kalena lako Puang Yesus anna kutanaii nakua: “O Puang, bennara Iko musanga?” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Natimba' Puang Yesus nakua: “Iamo kutandoi roti ke mangkai kuoton, iamo la umpa'perososanna'.” Ummalami roti anna otonni anna mane untandoi Yudas anakna Simon Iskariot. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mangkanna untarima roti Yudas, naluang siami ponggawana setang penawanna. Nakuammi Puang Yesus: “Palakomi ma'sirra' aka la mupogau'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tae' dengan to dio reen ummande attu iatoo ummissananni kalembasanna tula'na Puang Yesus lako Yudas. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dengan ussangai la nasua Puang Yesus lao ummalli kaparalluan la dipake illaan inde sara'e, dengan toi duka' ussangai la lao untawai doi' to mase-mase. Annu ia siummanna doi'. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mangkanna untarima roti Yudas, le'ba siami. Attu iatoo malillimmi. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Le'ba'i Yudas, ma'kadami Puang Yesus lako passikolana nakua: “Temo dipomatandemi Anak Mentolino anna la dipomatande Puang Allata'alla ummolai kara-kara la dadi lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ianna dipomatande Puang Allata'alla ummolai kara-kara la dadi lako kalena Anak Mentolino, la napomatande duka' Puang Allata'alla ummolai siami kara-kara la dadi lako kalena. Anna la masimpammo napomatande. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O anggammua' anakku, ta'mikia' la masae sola. La mupeangna'a'i sapo umba nakua tula'ku lako perepi'na to Yahudi susimi duka' kutulasangkoa' temo kumua: tae'a' la mubela ullambi' angngenan la kuolanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Temo la kubengangkoa' parenta bakaru, iamo: La sikamase-masekoa'. La sikamase-masekoa' umpotandengan pa'kamaseku lako kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ianna sikamase-masekoa' la naissanan tau kumua passikolakukoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Mekutanami Petrus lako Puang Yesus nakua: “O Puang, umbara Iko la muola?” Natimba' Puang Yesus nakua: “Ta'poko mala kusolaan lako angngenan la kuolanna temo. Sapo la windiko iko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mekutana pole omi Petrus nakua: “O Puang, maakari anna ta'poko mala kuula' temo? Annu kudotaan umbotoran sunga'ku la unturu'ko.” ");
INSERT INTO mqjNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Natimba' Puang Yesus nakua: “O Petrus, tongannaka tula'mu kumua mudotaan la umbotoran sunga'mu unturu'na'? Kupokadangko sitonganna, ta'pa moni manuk anna pentallummo' mutelang.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ma'kada pole omi Puang Yesus lako passikolana nakua: “Daua' pomasussa penawammu! Pangngoreangkoa' langngan Puang Allata'alla ammu oreanna' duka'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Buda angngenan yao banuanna Ambeku. La laomo' langngan umpatokangkoa' angngenan. Tae'koa' la kukuan kela tae' susi. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ianna mangkamokoa' kupatokaan angngenan, la saemo' sule ummalakoa' anna malara umba angngenan kungei iamoa' duka' la mungei. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Inde angngenan la kuolae, muitamia' lalan lako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nakuamo Tomas: “Tae' kiisanan angngenan la muolanna. Umbamo la kikua ummita lalan lako?” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Natimba' Puang Yesus nakua: “Kaomo lalan anna katonganan anna katuoan. Tae' dengan tau la mala sae langngan Ambeku ke tangkao naola. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kela muissananna', innang la ummissanangkoa' duka' Ambeku. Mengkalao temo muissanammia' Ambeku anna muitamoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma'kada duka' Filipus nakua: “O Puang, la tiala penawangki ke mupaitaimokan Ambemu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sapo' natimba' Puang Yesus nakua: “O Filipus, ta' liupakka la muissanan anna masaemiki' sola? Angganna to ummitana' ummitami Ambeku. Maakari ammu kua paitaikan Ambemu? ");
INSERT INTO mqjNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ta'raka iko muorean kumua mesa kappa'kan Ambeku? Angganna tula'ku lako kalemua', tangngia pa'kuangku, sapo Ambeku to torro illaan kaleku umpalako inde mai pengkarangannae. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Oreanni inde tula'kue kumua mesa kappa'kan Ambeku. Ianna ta'ra muorean angga kutula', oreanni ura'na tanda memangnga-mangnga kupogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kupokadangkoa' sitonganna, benna-benna ummoreanna', la umpogau' duka' angga mangkanna kupogau'. Anna marru la kamai polepa ia kara-kara napogau' annu la laomo' umpellambi'i Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iamo mupelau ke umpotendangko sangangku la kubengangkoa' situru' pelaummu anna malara dipomatande Ambeku ummolai pa'palakoku. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iamoa' mupelau umpotendan sangangku, iamo kupalako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ianna mukamaseina', la unturu'koa' angganna parentaku. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","La kupelau lako Ambeku anna bengkoa' senga'na To la umpamoloikoa' anna solangkoa' sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Inde To la umpamoloikoa'e, iamo Penawa Masero to la umpa'peissanan katonganan, anna tae' la natarima to lino, aka tae' naita anna tae' naissanan. Sapo muissanan ikoa' annu nasolaangkoa' anna la torro illaan penawammua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tae'koa' la kutampe to biung, sapo la saena' sule umpellambi'ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ta'mo masae angku pelleimo inde linoe, napolalan ta'mo' la naita to lino. Sapo la muitanakkaoa'i anna la tuokoa' annu tuona'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ianna nalambi'mo attu iatoo la muissanammia' kumua torro illaanna' Ambeku, torro illaangkoa' kaleku anna torro illaanna' kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Benna-benna umpaillan tambuk parentaku anna palakoi tau iamo too ungkamaseina'. Anna benna-benna ungkamaseina' la nakamasei duka' Ambeku, anna la kukamasei toi duka' anna la umpakawananna' kaleku lako kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mekutana Yudas (tangngia Iskariot) lako Puang Yesus nakua: “O Puang, maakari anna angga lako kaleki muola umpakawanan kalemu, tae' ia lako to lino?” ");
INSERT INTO mqjNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Natimba' Puang Yesus nakua: “Benna-benna ungkamaseina', la unturu' pepa'guruangku anna la nakamasei Ambeku. La saena' sola Ambeku umpellambi'i angki torro ussolanni. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Angganna to tae' ungkamasaina' tae' la unturu' pepa'guruangku. Anna inde pepa'guruangku simurangngia'e, tae' mengkalao illaan kaleku, sapo buttu yao mai Ambeku to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Angganna te maie kupokadangkoa' bayuanta solapa. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sapo Penawa Maseromo la umparundukkoa' anna umpakilalakoa' angga mangkanna kupokada lako kalemua'. Iamo te To la umpamoloikoa'e la nasua sae Puang Allata'alla la ussondana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","La kutampeangkoa' kamasakkean, iamo kamasakkean dio kaleku la kubengangkoa'. Tae' susi kamasakkean nabengangkoa' lino. Daua' pomasussa penawammu ammu daua' marea'. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mangkamia' murangngi tula'ku kumua: ‘La laona' sapo la saena' sule umpellambi'ikoa'.’ Ianna mukamaseina', la masannangkoa' ke laona' umpellambi'i Ambeku, annu marru matande ia Ambeku anna la Kao. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kutimangkoa' kupokadaan temo bayuanna ta'pa lemba' anna malara muorean ke lemba'mi. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ta'mo la kalando tula'kua' matin, annu nalambi'mi attunna la sae ponggawana setang to ungkuasai inde linoe, sapo tae'nakkao la nakuasai. ");
INSERT INTO mqjNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sapo tae' mala tala dadi lako kaleku anna malara naissanan ma'rupa tau kumua ungkamaseina' Ambeku anna kupalako asan parentana lako kaleku. Ke'de'mokoa' anta pellei inde angngenanne.” ");
INSERT INTO mqjNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ma'kada Puang Yesus nakua: “Kaomo te to'na anggur tonganne anna Ambeku to ungkarangngi. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Angganna tangkeku tae'na kembua, natattakki lao anna angganna tangke kembua nakayoi manappa anna malara satuttuan buda buana. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Makayomokoa' iko nakayo pepatudu mangka kubengangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tontongkoa' torro illaan kaleku angku torro duka' illaan kalemua'. Tae' dengan mesa tangke mala kembua ke sappekki lao. Angga nangei la mala kembua ke mellekke'i lako batangna. Susimokoa' too, angga la mungeia' mala kembua ke montongkoa' torro illaan kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kaomo to'na anggur anna ikomoa' tangkena. Angganna to montong torro illaan kaleku angku torro illaan kalena, la kembua barri'. Ianna tae'koa' torro illaan kaleku tae' dengan aka mala mupogau'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Benna-benna tae' torro illaan kaleku, sirapan tangke disappekki lao napolalan marekko'. Marekko'i, dirempummi anna ditibe tama api disumpunni. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ianna tontong liukoa' torro illaan kaleku, anna tontong liukoa' umpaillaan tambuk battakadangku, pelauia' langngan Puang Allata'alla muporainna innang la natandoi siakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ianna kembua barri'koa' la dipakasalle Ambeku anna kawanan kumua passikolaku tongangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kukamaseikoa' susi Ambeku ungkamaseina'. Tontongmokoa' torro illaan kaleku ammu sa'dingan liua' pa'kamaseku. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ianna tontongkoa' umpalako parentaku, la ussa'dingan liukoa' pa'kamaseku. Susi kaleku, ussa'dingan liu pa'kamasena Ambeku annu kupalako parentana. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kutulasangkoa' te maie anna malara torro illaan penawammua' kadoresangku napolalan sumpu kadoresammua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Indemia' parentakue: La sikamase-masekoa' susi pa'kamaseku lako kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta'mo dengan untanda langnganni pa'kamasena to ussorongan kalena dipatei annu la umpatuo solana. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ianna umpalakokoa' parentaku, solakukoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ta'mokoa' kusanga sabua', annu tae' ia naissanan sa'bua' aka nakarang puangna. Kusangamokoa' solaku annu angganna kurangnginna dio mai Ambeku, mangkamokoa' kupokadaan. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tangngikoa' umpilena', sapo Kao umpilekoa'. Kuponto bannangngikoa' lao kembua, anna itin buao la da'da'. Napolalan aka mupelau langngan Ambeku ke umpotendangkoa' sangangku, tae' mala tanabengkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Indemia' parentakue: Sikamase-masekoa'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ianna nakabassikoa' lino, pengkilalaii kumua innang yolo nakabassimokkao. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kela sangkalamma'koa' to tamangngorean illalan lino, la naporaikoa' lino annu solanakoa'. Sapo tangngiakoa' solana annu mangkamokoa' kusarakki dio mai lino, napolalan nakabassikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pengkilalaia' aka mangka kupokadangkoa': Tae' dengan leleanna sabua' la untanda langnganni puangna. Dadi ianna nadarrana' to tamangngorean illalan lino innang la nadarrakoa' duka', ianna unturu' pepa'guruangku la naturu' duka' pepa'guruammua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Angganna te maie la napogau' lako kalemua' ura'na kapangngoreanammua' lako kaleku annu tae' ummissanan Puang Allata'alla, to ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kela tae'na' sae anna tae' kutulasan asanni lako, tae' la napokasalaan. Sapo temo ta'mo dengan lalanna la ummaloloan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Angganna to ungkabassina', ungkabassi duka' Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kela tae'na' dengan naita umpogau' tanda memangnga-mangnga ta'pa dengan napogau' tau senga', tae' la napokasalaan. Sapo moika anna mangka asammo naita, nenne'pa' nakabassi sola Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sapo innang la susinna anna malara lemba' battakada tiuki' illaan Buku Masero kumua: ‘Nakabassina' moi anna tae' dengan lalanna.’ ");
INSERT INTO mqjNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ianna sae To la kusua umpamoloikoa', la napa'pesa'bianna'. Inde To la umpamoloikoa'e iamo Penawa Masero, To buttu yao mai Ambeku la umpakawanan katongananna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Sapo la parallukoa' duka' umpa'pesa'bianna' annu mengkalao diomikia' mai sola liu. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kupokadaan asangkoa' te maie ammu malara tae' ma'sorong boko' dio mai kapangngoreanammua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","La dipasuungkoa' illaan mai banua pa'sambayanganna to Yahudi, anna la dengan attunna nasanga umpengkarangan Puang Allata'alla to umpateikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","La napasusikoa' te taue annu tala Ambeku naissanan tala Kao. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sapo kutimangkoa' kukuan temo anna malara mukilalaia' ke lemba'mi, kumua innang mangkamokoa' kutulasan.” “Inde kara-karae tae'koa' innang kupokadaan mengkalao dio mai annu sola liupikia'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sapo temo la laomo' umpellambi'i to ussuana', anna ta'mokoa' dengan umpekutananni la kuolanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sapo masussaria' iko penawammu urrangngi inde tula'kue. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kupokadangkoa' sitonganna, marru mapia lako kalemua' ke le'bana' annu ianna tae'na' le'ba tae' dengan la sae To la umpamoloikoa'. Sapo ianna le'bana' la kusua sae umpellambi'ikoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ianna saemo, la napakawanammi lako ma'rupa tau diona kasalaanna, kamaloloangku, anna umba nakua Puang Allata'alla umpabambanni sangka' ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","La napakawanan kumua kasalaan ma'rupa tau annu tae' mangngorean lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","La napakawanan toi kumua to malolona' annu laona' umpellambi'i Ambeku anna ta'mo' dengan la muitaa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Anna la napakawanan toi duka' kumua Puang Allata'alla la umpabambanni sangka' ma'rupa tau annu mangkami dipabambanni sangka' ponggawana setang. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Budapi la parallu kutulasangkoa' sapo ta'pa la mubela mutarimaa' temo. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sapo ianna saemo Penawa Masero to la umpa'peissanan katonganan, la naparundukmokoa' ummissanan angganna katonganan buttu yao mai Puang Allata'alla. Inde tula'nae tae' la buttu dio mai kalena, sapo iamo narangnginna dio mai Ambeku iamo la natulasangkoa'. Anna la natimangmokoa' napokadaan kara-kara la lemba' ke dako'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","La napomatandena' annu angganna tula'ku lako la napalandasangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iamo naampui Ambeku, Kao duka' ummampuii. Iamo too anna kukuammokoa': La napalandasangkoa' Penawa Masero angganna tula'ku lako.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nakua pole omo Puang Yesus: “Ta'mo masae anna ta'mo' muita. Sapo ta' tomo masae ammu itamo' sule.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sikutana-tanaimi pira-pira passikolana nakua: “Akaraia kalembasanna tula'na lako kaleta kumua: ‘Ta'mo masae anna ta'mo' muita, anna ta' tomo masae ammu itamo' sule?’ Anna aka kalembasanna tula'na kumua: ‘La laona' umpellambi'i Ambeku?’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sikutana-tanai liumi passikola nakua: “Aka kalembasanna tula'na: ‘Ta'mo masae’? Tae' taissanan aka nasanga.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Naissanan Puang Yesus kumua morai passikolana la ungkutanaii napolalan ma'kada nakua: “Kukua angngena', ‘ta'mo masae anna ta'mo' muitaa', sapo ta' tomo masae ammu itamo' sule.’ Iaraka musitimba'-timba'ia'i? ");
INSERT INTO mqjNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kupokadangkoa' sitonganna, la tumangi'koa' sola umbating, sapo la dore' to tamangngorean. La masussa penawammua', sapo itin kamasussaanno la lumalin mendadi kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sirapan baine la keanak, masussa penawanna annu nalambi'mi attunna la mapa'di'. Sapo ianna dadimo anakna, ungkalembeimi kamapa'disanna napobua' kadoresanna annu tibussammi mesa anak tama lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Susimokoa' duka' temo masussa asan penawammua'. Sapo ianna silambi' polemikia' la tialami penawammua' anna tae' dengan tau mala umpa'dean kadoresammua'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Attu iatoo ta'mokoa' dengan la mekutana pole lako kaleku. Kupokadangkoa' sitonganna, aka mupelau langngan Ambeku umpotendan sangangku, la nabengangkoa'. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ta'pokoa' dengan melau langngan Ambeku umpotendan sangangku sae lako temo. Pelauia' ammu lolonganni, anna malara sumpu kadoresammua'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Angganna te mai kutulasangkoa'e kualangkoa' pa'rapanan. Sapo la dengan attunna ta'mokoa' kualaan pa'rapanan sapo la kubatotongngiammokoa' matin untetteran Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Attu iatoo la melaukoa' langngan Ambeku umpotendan sangangku. Tae'koa' kukuan: Kao la umpelauangkoa' lako Ambeku, ");
INSERT INTO mqjNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","annu nakamaseikoa' duka' Ambeku annu mukamaseina' anna muorean kumua lu yaona' mai Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Annu innang buttu yao tonganna' mai Ambeku sae tama lino. Temo la kupelleimi inde linoe ma'pasule langngan Ambeku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma'kadami passikolana nakua: “Mubatotongngiammokan temo, ta'mokan mualaan pa'rapanan. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kiissanammi pole' temo kumua Ikomo to ummissanan angga lako. Ta'mo parallu mekutana tau matin annu muissanammi aka la napekutanaan, iamo nangei kioreammo kumua: To buttu yaoko mai Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Natimba' Puang Yesus nakua: “Mangngorean tongammokoka temoa'i? ");
INSERT INTO mqjNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pengkilalaii! La dengan attunna, anna attunnamo temo la dipasisarak-sarakkoa'. La pantan sulekoa' umpellambi'i banuammu ammu tampena' mesa-mesangku. Sapo tae'na' mesa annu nasolaanna' Ambeku. ");
INSERT INTO mqjNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Angganna te maie kutulasangkoa' anna malara mattan penawammua' annu mesa kappa'mikia'. La masussakoa' illaan lino sapo pomatoroia' penawammu annu kutalomi angganna kakadakean inde lino!” ");
INSERT INTO mqjNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mangkanna ma'kada Puang Yesus, mentungngu langngammi langi' anna ma'kada nakua: “O Ambeku, nalambi'mi attunna temo. Pomatandemi Anakmu anna malara kawanan kamatandeammu. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Annu mangkamo' muturo la ungkuasai ma'rupa tau, anna malara angganna to mupalessu' rokko lisu pala'ku la kubeen duka' katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Indemi katuoan sae lako-lakonae, ke naissanammoko ma'rupa tau, mesa-mesanna Dewata tongan anna ummissanan Yesus Kristus to musua. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mangkamoko kupomatande inde lino annu suppikmi pengkarangan mangka mubeenna'. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Ambe', bengammo' kamatandean innang taampuimo mengkalao dio mai ta'pa dikombong lino la mupolalan umpomatandena' dio olomu. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mangkamoko kupa'peissanan lako to mangka mupalessu' rokko lisu pala'ku illaan inde linoe. Inde mai taue sangngin petauammu sapo mupalessu' rokkomi lisu pala'ku anna unturu' asammo battakadammu. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naissanan asammi temo kumua angganna pa'pebengammu lako kaleku lu dio asan mai kalemu, ");
INSERT INTO mqjNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","annu angganna battakadammu lako kaleku mangkami kupalanda' lako anna natarimamo. Naissanammi kumua buttu dio tonganna' mai kalemu anna naoreammo kumua Iko ussuana' tama lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Kupa'sambayangan inde mai taue. Sapo tae' kupa'sambayangan angganna tau illaan lino, anggami to mangka mupalessu' rokko lisu pala'ku annu petauammu asan. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Angganna petauangku, petauammu duka'; anna angganna petauammu, petauangku duka'. Iamo te mai taue umpakawanan kamatandeangku. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta'mo' la torro illaan inde linoe annu la matimmo' umpellambi'iko. Sapo inde mai taue la torropi inde lino. O Ambeku To masero pindan, dagai manappai inde mai taue ummolai kakuasaammu iamo kakuasaan mangka mubeenna'. Dagai manappai anna malara mesa kappa', susi Iko anna Kao to mesa kappa'mo. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Inde angku solapae, kudagai manappa ummolai kakuasaammu iamo kakuasaan mangka mubeenna'. Tae' dengan pa'de moi la mesamo salianna to innang dipatantu la pa'de anna malara lemba' battakada tiuki' illaan Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","La matimmo' umpellambi'iko temo, dadi kutulasan asampi te maie bayuangku illaampa lino anna malara ussa'dingan tongan kadoresangku. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mangkami kupalandasanni battakadammu lako, napolalan nakabassi to lino annu tangngia solana, susi Kao tangngiana' solana to lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tae' kukua la mualai illaan mai lino, sapo la mudagai indana kadakeii ponggawana setang. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Inde mai taue tangngia solana to lino susi kaleku tangngia solana to lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Palao senga'i ammu popendadii petauammu inde mai taue ummolai katonganan, annu battakadammu iamo to'na katonganan. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mangkami kusua lako ma'rupa tau illaan lino, susi kaleku mangka musua tama lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ussorongna' kaleku matin la napotendan passikolaku anna malara dipalao senga' mendadi petauammu annu ummissanan katonganan. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tangngia mandi te mai kupa'sambayanganne, sapo kupa'sambayangan duka' lako to la ummoreanna' ke dako' ura'na kasa'bian napalanda' inde mai taue. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Ambeku, kupa'sambayangan angganna to la ummoreanna' ke dako' kenamala mesa kappa', susi Iko torro illaan kaleku anna Kao torro illaan kalemu. Kenamala torro illaan kaleta anna malara naorean ma'rupa tau kumua Iko ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mangkami kubenganni kamatandean mangka mubeenna' anna malara mesa kappa' susi Iko anna Kao to mesa. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","La torrona' illaan kalena anna la torroko illaan kaleku, anna malara sundun kamesaanna napolalan naissanan to lino kumua Iko ussuana'. La naissanan toi duka' kumua ungkamaseiko to ummoreanna' susi pa'kamasemu lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Ambeku, moraina' kenamala inde mai to mupalessu' rokko lisu pala'kue la solakan illaan angngenan la kungei, anna malara nakawanan kamatandeangku iamo kamatandean mubeenna' annu innang mukamaseimo' mengkalao dio mai ta'pa dikombong lino. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Ambeku To malolo, tonganna tae'ko naissanan lino, sapo kuissanangko. Anna inde mai taue naissanan kumua Iko ussuana'. ");
INSERT INTO mqjNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mangkami kupa'peissanan sangammu lako, anna la tontong kupa'peissanan anna malara kamamaseammu lako kaleku la tontong illaan penawanna anna la torrona' illaan kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mangkai ma'sambayang Puang Yesus mengkalaomi sola passikolana umpellei kota Yerusalem ma'palulian lamban lianna Salu Kidron. Sambali' inde angngenanne dengan bela', iamo nangei Puang Yesus sola passikolana. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Inde angngenanne naissanan duka' Yudas to umpa'perososan Puang Yesus, annu bassa' sinangei Puang Yesus sola passikolana ma'mesa-mesa. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Saemi Yudas ussolaan salengkoan tantara Roma anna to siundagai Banua Ada'na Puang Allata'alla to nasua kapala imam anna to Farisi. Inde mai taue sanda ballo sola porewa mataran. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Naissanammi Puang Yesus aka la dadi lako kalena napolalan lao untammui inde mai taue, anna kutanaii nakua: “Bennara ikoa' mupeang?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Natimba' inde mai taue nakua: “Yesus to Nazaret.” Nakuanni Puang Yesus: “Kaomo tee.” Dio duka' reen Yudas to umpa'perososan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Inde anna ma'kada Puang Yesus nakua: “Kaomo tee,” ma'sorong boko' asammi anna songka rokko litak. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mekutana pole omi Puang Yesus nakua: “Bennara ikoa' mupeang?” Natimba' inde mai taue nakua: “Yesus to Nazaret.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nakuamo Puang Yesus: “Mangkamokoa' kukuan, ‘Kaomo tee.’ Ianna Kaora mupeang, pabeaii le'ba inde mai solakue.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ia nangei mantula' susi Puang Yesus anna malara lemba' battakada mangka natula', nakua: “Angganna to mangka mupalessu' rokko lisu pala'ku, tae' dengan pa'de moi la mesamo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Umbonok siami la'bo'na Simon Petrus anna umbatta sabua'na Pongkena Imam disanga Malkhus napolalan mallai talinga kananna. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nakua Puang Yesus lako Petrus: “Pasibanuai sule la'bo'mu, annu inde irusan pandarraan nabenganna' Ambekue innang la kuiru'na.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ussakkami Puang Yesus inde mai tantara Roma sola ponggawana anna to siundagai Banua Ada'na Puang Allata'allae, anna mane pungoi limanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bunga'na nabaa lako tingngayona Hanas matukanna Kayafas, Pongkena Imam illaan taun iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafasmo tee mangka umpakilala perepi'na to Yahudi, kumua: “Dotamia mesa tau mate anna la tau buda.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Windimi dua passikolana Puang Yesus ummula'i, iamo Simon Petrus anna mesapi solana. Inde solana Petrus-e siissanan Pongkena Imam, napolalan mala tama sa'de banuanna Pongkena Imam sola Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sapo torro illalan ia salian Petrus dio sa'de ba'ba bala. Inde solana Petrus-e sule lako salian anna sipantula' baine to siundagai ba'ba bala napolalan ussolaan Petrus tama sa'de banua. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nakuamo inde baine to undagai ba'ba lako Petrus-e: “Anna umbai passikolanako duka' iato tauo?” Natimba' Petrus nakua: “Tangngia.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Attu iatoo, attunna masakka' padang napolalan untue api pira-pira sabua' sola to daga anna ke'de' mendarang. Diomi duka' Petrus ke'de' mendarang. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mekutanami Pongkena Imam lako Puang Yesus diona passikolana anna pepa'guruanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Natimba' Puang Yesus nakua: “Simantula'na' dio olona tau kamban. Sima'patuduna' illaan banua pa'sambayanganna to Yahudi sola illaan Banua Ada'na Puang Allata'alla sinangei ma'mesa-mesa to Yahudi. Tae'na' dengan mantula' buni. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Maakari anna Kao mukutanai? Kutanaimi to mangka urrangngina' ma'pa'guru, innang la naissanammi angga mangkanna kupokada.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tappana lappa' tula'na Puang Yesus, natampiling siami mesa to daga anna kuanni: “Maakari ammu barani mantula' susi lako Pongkena Imam?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Natimba' Puang Yesus nakua: “Ianna salara tula'ku, pokadanna' salanna, sapo ianna tonganna maakari ammu tampilingna'?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ussuami tau Hanas umbaa Puang Yesus, tontong dipungo, lako Pongkena Imam disanga Kayafas. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Montongpi ke'de' Petrus mendarang, dengammi tau ungkutanaii nakua: “Tangngiakoka passikolana iato tauo?” Sapo tontong mantelang Petrus nakua: “Tangngia!” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dengan mesa sabua'na Pongkena Imam, sa'do'doranna to naalai talinganna Petrus, mekutana duka' lako Petrus nakua: “Anna umbai iko mesa kuita illaan bela' nasolaan?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tontong liu siami mantelang Petrus nakua: “Tangkao!” Ma'tottoro' siami manuk. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mebongngi'-bongngi'pi anna dibaamo Puang Yesus dio mai banuanna Kayafas dipalulako angngenanna gubernur. Inde mai perepi'na to Yahudie moka tama angngenanna gubernur indana ta'mo mapatting situru' alukna napolalan tae' mala ummande nande Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iamo nangei suummo Pilatus umpellambi'i anna kutanaii nakua: “Aka mutandasan inde taue?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Natimba' nakua: “Kela tangngia to kadake, tae'ko la kibaan sae.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nakuammi Pilatus: “Baamia' lao ammu pabambanni sangka' situru' alukmua'.” Sapo natimba' nakua: “Tae'kan kami mala umpatei tau.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kara-kara iatee dadi anna malara lemba' battakadanna Puang Yesus diona umba la nakua kamateanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tamami sule angngenanna Pilatus anna untambai Puang Yesus nakutanai nakua: “Ikomoka tomarayanna to Yahudi?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Natimba' Puang Yesus nakua: “Mengkalao illaarrika penawammu itin pekutanammuo, dengarrika tau umpokadangko?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Natimba' Pilatus nakua: “Tangngianakkao to Yahudi. Solamu siamo to Yahudi anna kapala imam umbaako sae. Akara mangka mupogau'?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Natimba' Puang Yesus nakua: “Tae' Kao buttu illaan mai lino kaparentaangku. Annu kela buttu illaan mai lino, innang la mangngewa petauangku indaku dibaa lako perepi'na to Yahudi. Sapo tae' buttu illaan mai lino kaparentaangku!” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mekutana polemi Pilatus lako nakua: “Ianna susi too, tomarayako?” Natimba' Puang Yesus nakua: “Iko siamo ussangaina' tomaraya. Ia kungei didadian illaan inde linoe annu la umpa'pesa'bianna' katonganan lako ma'rupa tau. Angganna to umpemulu katonganan, la umperangngii tula'ku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nakuamo Pilatus lako: “Aka disanga katonganan?” Mangkanna ma'kada susi Pilatus, le'ba' siami illaan mai angngenanna anna ma'kada lako to Yahudi nakua: “Tae' tappa' dengan kulambi' kasalaanna inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sapo situru' kabeasaammua' ke nalambi'i allo Paskah sikurappananangkoa' mesa to ditarungkun. La muporaika ke kurappananangkoa' tomarayanna to Yahudi?” ");
INSERT INTO mqjNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sipealo'-alosammi untimba' Pilatus nakua: “Tae', tangngia ia la murappanan, Barabasmo rappanan!” Inde Barabas-e siumbali to ma'parenta. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ussuami tantarana Pilatus ummombang Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mangkaii, umpapiami songko' inde mai tantarae sirapan songko' tomaraya sapo ma'duri anna pasongko'i Puang Yesus. Anna mane papakeii bayu rui' mellolo pao rupanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sibala'-bala'mi lako tingngayona anna ma'kada nakua: “Tabe' tomarayanna to Yahudi.” Anna mane tampilingngi. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mangkai too, suun pole omi Pilatus anna ma'kada lako tau kamban nakua: “Petua'mia'i, kubaammokoa' illaan mai ammu issananni kumua tae' tongan-tongan dengan kukabuttui kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Suummi Puang Yesus ma'songko' duri anna ma'bayu rui' mellolo pao rupanna. Nakuamo Pilatus: “Petua'mia' inde taue!” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Inde anna ummitamo Puang Yesus kapala imam sola to siundagai Banua Ada'na Puang Allata'allae, sipetamba-tambaammi nakua: “Pasokki lako kayu pantokesan! Pasokki lako kayu pantokesan!” Ma'kadami Pilatus lako inde tau kambanne, nakua: “Alamia' matin ammu meloloa' umpasokki lako kayu pantokesan, annu tae' tappa' kao dengan kukabuttui kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Natimba' to Yahudi nakua: “Situru' sangka'ki, inde taue sipato' dipatei annu ussanga kalena Anakna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Satuttuan marea'mi Pilatus anna urrangngimo inde kadanna to Yahudie. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Napolalan sule tama angngenanna, anna mekutana lako Puang Yesus nakua: “Umba tappa'ra Iko mungei buttu?” Sapo tae' natimba'i Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nakuamo Pilatus: “Mokako la untimba'ina'? Ta'raka muissanan kumua kao pawa temo, la dirappanarrokoka iaraka ammu dipasok lako kayu pantokesan?” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Natimba' Puang Yesus nakua: “Kela tangngia Puang Allata'alla umbengangko itin kakuasaammuo, innang tae' dengan kakuasaammu lako kaleku. Iamo too marru mabanda' ia kasalaanna to ussorongna' lako kalemu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Urrangnginna tula'na Puang Yesus, umpeangmi lalan Pilatus la urrappananni. Sapo sipetamba-tambaan to Yahudi nakua: “Ianna murappanan, tangngiako solana tomaraya dio Roma. Annu benna-benna ussanga kalena tomaraya iamo ewalinna tomaraya dio Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Inde anna urrangngimo kadanna to Yahudie, ussuami tau Pilatus umbaa Puang Yesus tama salian. Ummokko'mi Pilatus yao ka'dera sinangei urratta' bisara, illaan mesa angngenan disanga Sali Batu (basa Ibrani disanga Gabata). ");
INSERT INTO mqjNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Attu iatoo umbai la tettek sapulo duamo, sipatu allo pa'patokaan la umpakaroa' allo Paskah. Ma'kadami Pilatus lako to Yahudi nakua: “Tomarayammua' tee!” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sipetamba-tambaammi nakua: “Pateii! Pateii! Pasokki lako kayu pantokesan!” Nakua pole omo Pilatus: “La kupateiangkoka tomarayammua' yao kayu pantokesan?” Natimba' kapala imam nakua: “Tae' kami dengan tomaraya senga'ki salianna tomaraya dio Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ussorongammi Puang Yesus Pilatus lako tau kamban la napatei yao kayu pantokesan. Dengammi pira-pira tantara ummala Puang Yesus anna baai lao. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Umpassammi kayu pantokesanna Puang Yesus anna le'ba suun kota lu lako mesa angngenan disanga Angngenan Karorak Ulu (illaan basa Ibrani disanga Golgota). ");
INSERT INTO mqjNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Iamo dingei umpasokki yao kayu pantokesan sola dua tau senga', mesa dio tandai kairinna anna mesa dio tandai kananna. Puang Yesusmo illaan alla'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ussuami tau Pilatus umpalekke' pangnguki' yao kayu pantokesanna Puang Yesus, nakua: Yesus To Nazaret, Tomarayanna To Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Buda to Yahudi umbaca inde pangnguki'e annu inde angngenan dingei untoke' Puang Yesus-e sikadappi' kota, anna diuki' illaan basa Ibrani, basa Latin anna basa Yunani. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nakuamo kapala imam lako Pilatus: “Dau uki'i kumua ‘Tomarayanna to Yahudi’, sapo la nakua: ‘Inde taue sinakua, Kaomo tomarayanna to Yahudi.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sapo natimba' Pilatus nakua: “Iamo mangka kuuki', ia liumo la tiuki'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yaoi kayu pantokesan Puang Yesus, naalami tantara pakeanna anna tawa-tawai napa'appa' sandai sisabarean. Naalami duka' bayu rui' tanda tamanna. Inde bayu rui'e tae' dengan naola pedasi', salamba' babang mengkalao yao sae rokko. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sipantula'-tula'mi tantara nakua: “Daua' anta serek-serek inde bayu rui'e. Anta undimia' battu bennanta ummalai.” Kara-kara iatee dadi anna malara lemba' battakada illaan Buku Masero nakua: “Untawa-tawa pakeangku anna ummundi bayu rui'ku.” Napasusi tongan tantara. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Dengan pira-pira baine ke'de' dio sa'de kayu pantokesanna Puang Yesus, iamo: indona Puang Yesus anna sirondongna, sola Maria bainena Klopas anna Maria Magdalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Inde anna ummitamo indona sola passikola to randan napakamaya ke'de' dio sa'denae, ma'kadami Puang Yesus nakua: “O indo', iamo tu anakmuo.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Anna mane ma'kada lako passikolana nakua: “Iamo tu indomuo.” Mengkalao diomi tee naola umpobaa indona Puang Yesus inde passikolae. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mangkai too, naissanammi Puang Yesus kumua mangka asammi. Nakuamo: “Marekko' kollongku.” Ia nangei ma'kada susi anna malara lemba' battakada tiuki' illaan Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Dio angngenan iatoo dengan pa'pengngean kaissi anggur maissuk. Diotommi lumu' diala dio tasik rokko inde anggur maissukke anna dipalekke' lako roan anna mane padundui pudukna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mangkai ummiru' inde anggur maissukke, ma'kadami Puang Yesus nakua: “Suppikmi.” Lumbangmi napolalan kattu penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Attu iatoo iamo allo pa'patokaan la tama allo katorroan. Situru' kabeasaanna to Yahudi pemali ke tontong liui titoke' batang rabukna to dipatei yao kayu pantokesan illaan allo katorroan. La'bi-la'binna allo iatoo sipatu allo Paskah. Iamo too anna le'ba'mo pira-pira perepi'na to Yahudi lako Pilatus anna pelaui la dipoloan asan lentekna inde to ditoke'e anna malara ma'sirra' bonno', anna dipaturun yao mai kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Le'bami tantara umpoloan lentekna to nasolaan Puang Yesus ditoke'. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sapo inde anna ullambi'mo Puang Yesus-e naitai bonno'mia napolalan ta'mo napoloan lentekna. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sapo dengan mesa tantara untossokki doke sa'dena tappa suun siami rara sirau wai. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iamo te to melolo ummita inde kadadianne, untetteranni ammu mangngoreanna' duka'. Annu inde kasa'bian napalanda'e tonganna, anna naissanan duka' kumua tonganna. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iate nangei dadi susie anna lemba'ra battakada tiuki' illaan Buku Masero nakua: “Tae' dengan bukunna la dipoloan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dengan toi duka' tiuki' nakua: “La umparandan to mangka natossok doke.” ");
INSERT INTO mqjNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mangkai too, dengammi mesa tau disanga Yusuf to lu dio mai Arimatea lao umpelau batang rabukna Puang Yesus lako Pilatus la napaturun yao mai kayu pantokesan. (Inde Yusuf-e passikolana duka' Puang Yesus, sapo tae' napa'peissanan aka marea' lako perepi'na to Yahudi.) Naporanammi Pilatus pelaunna napolalan lao umpaturun batang rabukna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Dengan tau nasolaan Yusuf disanga Nikodemus. Inde Nikodemus-e iamo to mangka untungka bongi Puang Yesus. Umbai dengan tallu pulo kilo mabanda'na lite bumanangnga' nabaa, iamo mur dipasirau gaharu. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ummalami sampin pebalun inde dua taue, anna umbalun batang rabukna Puang Yesus napasibalun inde lite bumanangnga'e, situru' kabeasaanna to Yahudi ke la ullamunni to matena. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dengan bela' nasikadappisan angngenan dingei untoke' Puang Yesus. Illaan inde bela'e dengan lokko' bakaru, ta'pa dengan to mate dipatama. ");
INSERT INTO mqjNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Napalutamami annu madappi' anna la nalambi'mo allo katorroan. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Allo Minggui, menannarimi Maria Magdalena lako liang. Saei lako ummitami batu ditutu'ian lokko' mangka diberoi. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Le'ba' siami kumondong lao umpellambi'i Simon Petrus anna passikola to randan nakamasei Puang Yesus anna kuanni: “Mangka naala tau batang rabukna Puang Yesus illaan mai liang, tae' kuissanan umba napa'pengngei.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mengkalao siami Petrus sola inde passikolae lako liang. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bassi kumondongmi, sapo marru malapu' ia inde passikolae napolalan yolo ia sae lako liang. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mengngollongmi tama lokko', napolalan ummita sampin pebalun tilena' babang, sapo tae' lao tama. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saei Simon Petrus, tarru' siami tama lokko'. Ummitami duka' sampin pebalun tilena' babang illaan. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mengke'de' sampin dibekesanni ulunna, torro senga' ia tilulun, tae' sola inde pebalunne. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tamami duka' lokko' inde passikola to yolo sae lako liangnge, naitami napolalan mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Annu sae lako attu iatoo ta'pa umpekalembasan issinna Buku Masero kumua: “Innang la tuo sule dio mai alla'na to mate.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mangkaii, sulemi lako banua inde dua passikolae. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sapo ke'de' ia Maria Magdalena dio ba'ba lokko' tumangi'. Marassanni tumangi', mengngollongmi tama lokko'. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ummitami dua malaeka' ma'pakean mabusa ummokko' dio angngenan mangka nangei batang rabukna Puang Yesus, mesa dio tandai pengnguluanna anna mesa dio tandai lentekna. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mekutanami inde malaeka'e nakua: “O indo', maakari ammu tumangi'?” Natimba' Maria nakua: “Naala tau Puangku, anna tae' kuissanan umba napa'pengngei.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mangkai mantula', menggirikmi lako boko'na, ummitami Puang Yesus ke'de' dio, sapo tae' naissanan kumua Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mekutanami Puang Yesus nakua: “O Indo', maakari ammu tumangi'? Bennaraiko mupeang?” Nasanga Maria to ma'bela', napolalan ma'kada lako nakua: “O tuang, ianna ikora umberoi lao, pokadanna' umba mupa'pengngei angku lao ummalai.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nakuamo Puang Yesus: “O Maria.” Messailemi Maria lako Puang Yesus anna ma'kada ma'basa Ibrani nakua: “Rabuni!” (kalembasanna “Tuangguru”.) ");
INSERT INTO mqjNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nakuammi Puang Yesus: “Dau ammu anda'ina' annu ta'pa' dengan lao langngan Ambeku. Sapo laomoko umpellambi'i angganna sa'do'dorangku ammu paissannii kumua: ‘Temo, la laona' langngan Ambeku anna Ambemua'; langngan Puang Allata'alla Dewatangku anna Dewatammua'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mengkalao siami Maria Magdalena lao umpellambi'i passikolana Puang Yesus anna kuanni: “Silambi'mokkao Puang!” Napokadami duka' kumua angganna te maie Puang Yesus untula'i lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Bonginna inde allo Minggue, ma'mesa-mesami passikolana Puang Yesus illaan mesa banua, anna mangkado' annu marea' lako perepi'na to Yahudi. Tokke'mi sae Puang Yesus ke'de' illaan alla'-alla'na passikolana anna ma'kada nakua: “La masakke marendengkoa'!” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mangkai ma'kada Puang Yesus, umpa'paitaammi limanna sola sa'dena. Dore' asammi passikola ummita Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma'kada pole omi Puang Yesus nakua: “La masakke marendengkoa'! La kusuakoa' duka' susi Ambeku ussuana'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Mangkaii, ussimburru'imi passikola anna ma'kada nakua: “Tarimaia' Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ianna unggarri'ikoa' kasalaanna tau, la digarri'i kasalaanna, ianna tae' mugarri'i, tae' la digarri'i kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dengan mesa to nakala' sapulo dua passikolana Puang Yesus, disanga Tomas, sidikuan to Rambung, tae' dio reen anna sae Puang Yesus umpa'paitaan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nakuammi solana: “Mangkamokangkami siita Puang.” Sapo natimba' Tomas nakua: “Ianna ta'pa melolo matangku ummita lalan pasok dio limanna anna ta'pa kuroroan tarunoku tama iato lalan pasokko anna ta' topa dengan kuroroan limangku tama sa'dena, tae' dengan leleanna la kuorean.” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pitu bongii mangkanna, ma'mesa-mesa omi passikolana Puang Yesus illaan inde banuae. Attu iatoo diomi duka' reen Tomas. Mangka asan dikado' ba'ba. Tokke'mi sae Puang Yesus ke'de' illaan alla'-alla'na passikola anna ma'kada nakua: “La masakke marendengkoa'!” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma'kadami Puang Yesus lako Tomas nakua: “Nenne'imi inde limangkue ammu tossokki tarunomu. Ette'mi limammu ammu roroanni tama sa'deku ammu daumo tae' liu mangngorean sapo oreammi!” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Natimba' Tomas nakua: “O Puangku anna Dewatangku!” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nakuammi Puang Yesus: “Muoremmi annu muitamo'. Kerongko' anna maupa' angganna to mangngorean moi anna tae'na' naita!” ");
INSERT INTO mqjNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Budapi tanda memangnga-mangnga senga' napogau' Puang Yesus dio tingngayona passikolana sapo ta'mo diuki' illaan inde sura'e. ");
INSERT INTO mqjNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sapo angganna te maie diuki' anna malara muoreanna' kumua Puang Yesusmo To dibassei bayu-bayu la ma'pasalama', Anakna Puang Allata'alla; anna la ullolongangkoa' katuoan ummolai kapangngoreanammu lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mangkai too, umpa'paitaan pole omi kalena Puang Yesus lako passikolana dio biring Tasik Tiberias. Susi inde lalannae: ");
INSERT INTO mqjNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pissan attu ma'mesa-mesa pira-pira passikolana Puang Yesus dio biring tasik, iamo: Simon Petrus, Tomas sidikuaan to Rambung, Natanael to lu dio mai Kana dio Galilea, dua anakna Zebedeus, anna duapa passikola senga'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nakuamo Simon Petrus lako solana: “La laonakkao mebe'dok.” Natimba' solana nakua: “La laokia' sola.” Mengkalaomi ma'lopi. Sapo tae' tappa' dengan aka naala tuttu' bongi. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","La birra'i allo, ke'de'mi Puang Yesus dio biring tasik sapo tae' naissanan passikola kumua Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ma'kadami Puang Yesus nakua: “Dengangka be'dok mualaa'i?” Natimba' passikolana nakua: “Tae' dengan.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nakuammi Puang Yesus: “Sampero lakoi tandai kananna lopi dalamua', la mualamia' too.” Nasampero lako tongammi, napolalan tae' nabela urruntu' dalana annu budami be'dok illaan. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma'kadami passikola to napakamaya Puang Yesus lako Petrus nakua: “Puangta tendee.” Narangnginna Petrus kumua Puang, ma'bayu siami (annu tae' ma'bayu) anna mengkattibe rokko tasik. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma'lopimia passikola senga' ummula'i napasiolaan urrui' dalana ponno be'dok, annu tae' sikambela gantanan umbai angga saratu' mete' alla'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Turunni yao mai lopi, ummitami roti anna roaya nangei tipatodo' be'dok. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma'kadami Puang Yesus nakua: “Baaia' mai pira-pira itin be'dok mane mualao.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Langngammi lopi Petrus anna urruntu' dalana langngan gantanan. Saratu' lima pulo tallu be'dok sikamai ponno illaan inde dalae. Sapo moi anna susi budanna tae' sesse' dala. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nakuamo Puang Yesus lako passikolana: “Maimokoa' ummande.” Tae' dengan passikola barani mekutana kumua: “Bennako?” Annu naissanan asammi kumua Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Mendendemi Puang Yesus anna ummala roti anna untandoi passikolana. Ummalami duka' be'dok anna beenni. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iamo te kapentallunna umpa'paitaan kalena Puang Yesus lako passikolanae mangkanna tuo sule dio mai alla'na to mate. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mangkai ummande, ma'kadami Puang Yesus lako Simon Petrus nakua: “O Simon anakna Yohanes, mutondorrika solamu ungkamaseina'?” Natimba' Petrus nakua: “O Puang, tonganna. Muissanan kumua kukamaseiko.” Nakuamo Puang Yesus: “Kambisanna' dombaku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Mekutana pole omi Puang Yesus kapenduanna nakua: “O Simon anakna Yohanes, mukamaseinakka?” Natimba' Petrus nakua: “O Puang, tonganna. Muissanan kumua kukamaseiko.” Nakuamo Puang Yesus: “Kambisanna' dombaku.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mekutana pole omi Puang Yesus kapentallunna nakua: “O Simon anakna Yohanes, mukamaseinakka?” Rosso siami penawanna Petrus annu pentallummi mekutana Puang Yesus kumua mukamaseirakka? Natimba'mi Petrus nakua: “O Puang, Ikomo to untarru' angga maritik. Dadi muissanan kumua kukamaseiko.” Nakuamo Puang Yesus: “Kambisanna' dombaku. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kupokadangko sitonganna, inde ammu mangngurapae iko kalena umbeke' awakmu, ammu lu rekke lu sau' situru' pa'kua penawammu. Sapo ianna matuamoko la ummette'moko limammu anna poriko tau senga' anna baako lako angngenan tamuporainna.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iate nangei mantula' susi Puang Yesus-e annu napayolo lalammi lako Petrus umba la nakua kamateanna la napolalan umpomatande Puang Allata'alla.) Nakua pole omo Puang Yesus lako Petrus: “Turu'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Inde anna messaile Petrus-e, ummitami passikola to napakamaya Puang Yesus dio boko'na. (Iamo te passikola to umbarean kalena lako Puang Yesus anna ummandee anna mekutana nakua: “O Puang, benna la umpa'perososangko?”) ");
INSERT INTO mqjNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Inde anna itami Petrus-e, mekutanami lako Puang Yesus nakua: “O Puang, umba ia la nakua inde taue?” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Natimba' Puang Yesus nakua: “Ianna kukua la tuo liu sae lako attu kasaeangku sule, tangngia issammu. Sapo angga iko la muissanan la muturu'na.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Silelemi kareba illaan alla'-alla'na to mangngorean kumua inde passikolae tae' la bonno'. Sapo tae' ia nakua Puang Yesus lako Petrus tae' la bonno', sapo nakua: “Ianna kukua la tuo liu sae lako attu kasaeangku sule, tangngia issammu.” ");
INSERT INTO mqjNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Passikola iamo tee to umpalanda' kasa'bian diona inde mai kara-karae anna ia toi ummuki'i. Anna taissanan kumua tonganna angganna tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Budapi senga'na napogau' Puang Yesus. Sapo maka' la diuki' asan, umbai tae' la sirua illaan lino sura' dipangnguki'i.");
INSERT INTO mqjNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Teofilus, illalan sura'ku bunga'na kupomakalesomi angganna pengkaranganna Puang Yesus sola pepa'guruanna, ");
INSERT INTO mqjNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sae lako allo nangei tiangka' langngan suruga. Inde anna ta'pa tiangka' langngan surugae, ma'pakari'di'pi ummolai kakuasaanna Penawa Masero lako angganna rasulna to mangka napile. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mangkai ummolai kamatean, appa' tapulopi allona naola pempiran-piran umpa'paitaan kalena lako rasulna. Anna buda tanda napa'paitaan la naola umpomanassai kumua tuo sule anna untetteran kaparentaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pissan attu anna marassan ummande sola rasulna ma'pakari'di'mi kumua tae' la umpellei Yerusalem, annu la ummampai pa'dandinna Ambena susi mangka napokada, nasanga kadanna: “Mangkami murangngi kupokada. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wai ia napopantedok Yohanes, sapo' pira-pirangngallopia' iko ammu ditedokmo Penawa Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Inde anna ma'mesa rasul sola Puang Yesus-e mekutanami lako nakua: “O Puang la mupake'de'mika sule temo kaparentaanna to Israel?” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Natimba' Puang Yesus nakua: “Tae' ikoa' parallu muissanan attunna annu Ambeku umpatantui situru' kakuasaanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sapo' la dibengangkoa' kakuasaan ke turummi Penawa Masero tama kalemua' anna la mendadikoa' sa'bingku dio Yerusalem, lembangna Yudea, anna Samaria, sae lako lili'na lino.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Mangkanna mantula', tiangka'mi Puang Yesus langngan loa naparandan rasul. Nakabu'mi gaun napolalan ta'mo naita. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mentungngu langngan liupi langi' rasul, anna tokke'mo ke'de' dua tau ma'pakean mabusa dio sa'dena. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma'kadami inde taue nakua: “O to Galilea maakari ammu mentungngu langngan liua' langi'? Inde Puang Yesus tiangka' langngan suruga umpelleikoa'e la sule yao mai susi muita temo.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mangkai too, ma'pasulemi rasul yao mai Tanete Zaitun lako Yerusalem umbai angga la sangkilo alla'na. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Saei lako, lu langngammi loteng dio banua sinangei torro. Inde mai rasul-e iamo Petrus anna Yohanes, Yakobus anna Andreas, Filipus anna Tomas, Bartolomeus anna Matius, Yakobus anakna Alfeus anna Simon to nakala' kombongan Zelot, anna Yudas anakna Yakobus. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tontong liu umpamesa penawa ma'sambayang sola pira-pira baine, Maria indona Puang Yesus, anna sirondongna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pissan attu ma'mesa omi umbai saratu' dua pulo tau budanna, ke'de'mi Petrus anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mentu'ko siulu'ku, angganna issinna Buku Masero innang la diganna'inna. Susi battakada untetteran Yudas to ummatalalanan to ussakka Puang Yesus napalanda' Penawa Masero ummolai Daud. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Inde Yudas-e solaki yolona anna mangngala tawa duka' illalan pengkarangangki.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mangkami naallian litak doi' passarona umpogau' kakadakean. Iamo nangei tobang tappa lumbang lambisan salian asan tambukna. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kara-kara iatoo naissanan asan tau dio Yerusalem napolalan inde litakke nasangai “Hakal Dama” situru' basana, kalembasanna Litak Rara.) ");
INSERT INTO mqjNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sitarru'na tula'na Petrus nakua, “Dengan tiuki' illalan sura' Pampudian nakua: ‘Make disayangngi banuanna, pabeai mammi tae' dengan tau torro dio,’ dengan toi duka' tiuki' nakua: ‘Make nangei tau senga' angngenanna.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Dadi kiparallui mesa tau la ussolangkan umpa'pesa'bian katuoanna sule Puang Yesus. Sapo' la diala dio mai to sikisolaan liu mengkalao dio mai mane natedok Yohanes Puang Yesus sae lako tiangka' langngan suruga untampekan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Unturomi dua tau inde to ma'mesae, iamo disanga Yusuf sidikuan duka' Barsabas (disangai toi duka' Yustus), anna disanga Matias. ");
INSERT INTO mqjNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ma'sambayangmi nakua: “O Puang, Ikomo to ullosa tama unak penawanna angganna tau. Turomi bennanna la mupile inde dua taue ");
INSERT INTO mqjNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","la mendadi rasulmu ussonda Yudas, to umpelleimo karanganna napolalan ullambi'mo angngenan la sipato'na nangei.” ");
INSERT INTO mqjNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naundimi napolalan Matias napatu la mendadi rasul urrangnganni inde to sapulo mesae. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Inde anna nalambi'mo allo Pentakostae, ma'mesami angganna to mangngorean dio mesa angngenan. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tokke'mi urrangngi oni susi bara' kamai turun yao mai langi' lu tama banua nangei ma'rempun. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ummitami susi api ma'lana-lana titantan pantan urrampoi tau illalan inde banuae. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nakuasai asammi Penawa Masero napolalan pantan mantula' ummoyong ma'rupa-rupa basa situru' pa'kuanna Penawa Masero illalan kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Attu iatoo, buda to Yahudi to unturu' tongan-tongan parentana Puang Allata'alla torro dio Yerusalem, to lu dio mai pira-pira botto illalan lino. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tappana urrangngi oni susi bara' kamai, buda tau sasaean ma'silullu'. Pusa' asan umpenawa-nawanni annu pantan urrangngi basana napake inde mai to mangngoreanne. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mangnga-mangnga asan napolalan sipantula'-tula' nakua: “Inde lako taue sangngin to Galilea! ");
INSERT INTO mqjNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Umbara nakua anta mala pantan urrangngi basata napake? ");
INSERT INTO mqjNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anu' dengangkia' to Partia, Media, Elam, Mesopotamia, Yudea, Kapadokia, Pontus, Asia, ");
INSERT INTO mqjNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Mesir, to lu dio mai lembangna Libia sikadappi'na Kirene; anna to sae dio mai Roma. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Susi to Yahudi tenni tau senga' salianna to Yahudi sapo' ma'aluk Yahudi, to lu dio mai Kreta anna Arab; tarangngi asan umpake basata untetteran kara-kara memangnga-mangnga napogau' Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mangnga-mangnga asan napolalan sipantula'-tula' nakua: “Akamo te kalembasannae?” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sapo' dengan duka' tau untellei nakua: “Inde lako taue malango asan annu buda sigali anggur nairu'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ke'de'mi Petrus sola sapulo mesa solana anna ma'kada lako tau kamban nakua: “O to Yahudi anna angganna issinna Yerusalem, perangngi manappai ammu paillalan penawai tula'ku. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inde mai taue musanga malango, sapo' tae' annu mane tettek kasera mebongngi'. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sapo' inde kara-karae la ungganna'i battakadanna Puang Allata'alla mangka napalanda' nabi Yoel nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Illalan allo ma'katampakanna lino la kupaturun Penawa Masero lako angganna ma'rupa tau, napolalan angganna anakmua' la ullombungan battakadangku. Angganna to mangngurammua' la taman anna angganna to matua-tuammua' la mangngimpi. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Illalan allo iatoo la kupaturun duka' Penawa Masero lako angganna sabua'ku muane tenni baine anna la ullombungan battakadangku. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anna la kupadadi buda tanda memangnga-mangnga yao langi' anna ma'rupa-rupa tanda illalan lino susinna rara, api, sola rambu buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","La pi'de mata allo anna la malea susi rara bulan anna mane nalambi' allo kamainna Puang Allata'alla la nangei umpakawanan kamatandeanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Anna benna-benna ussa'bu' sanganna Puang Allata'alla, la dipasalama'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","O anggammua' to Israel, patananni talinga inde tula'kue: Puang Yesus to Nazaret mangka napakawanan Puang Allata'alla lako kalemua' kumua iamo pesuanna ummolai kakuasaan anna ma'rupa-rupa tanda anna tanda memangnga-mangnga. Muissanan asan annu inde kara-karae dadi illalan alla'-alla'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Situru' pa'kuanna sola pa'patantunna Puang Allata'alla mengkalao dio mai, inde Puang Yesus-e la napalessu' lako kalemua' la mupopepatei ammu umpabeai to kadake umpasokki lako kayu pantokesan. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sapo' napatuo sule Puang Allata'alla, naalai dio mai kakuasaanna kamatean annu innang tae' dengan leleanna la nakuasai liu kamatean. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Annu inde Puang Yesus-e innang mangka napokada Daud nakua: ‘Tontong liu dio sa'deku Puang Allata'alla anna tontong liuna' nakambi' kupolalan tae' sarubeba' illalan salu katuoangku. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Iamo too anna buttumo kadoresan illalan penawangku umpakendek pampudian anna dengan kaparannuan naampui batang kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Annu tae' mupabeai batang sunga'ku torro illalan alla'-alla'na to mate, anna tae' mupabeai puru' batang kalena inde To Maseromue. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mangkamo' mupaturoi lalan lu lako katuoan anna la ma'dore'-dore'na' annu la tontong liuna' musolaan.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dadi mentu'ko siulu'ku, malamo' untula' neneta Daud lako kalemua' temo kumua tangngia kalena napatu kadanna, annu mangkami bonno' anna dilamun anna taitapa liangna sae lako temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sapo' inde Daud-e mesa nabi, dadi naissanan kumua mangka ummoton pinda Puang Allata'alla anna ma'dandi la ummangka' mesa peampoanna Daud mendadi tomaraya. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Natimang duka' umpokada katuoanna sule To nabassei bayu-bayu Puang Allata'alla, kumua tae' la napabeai Puang Allata'alla torro illalan alla'-alla'na to mate, anna tae' napabeai puru' batang kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Puang Yesusmo to napatuo sule Puang Allata'alla dio mai alla'na to mate, anna kamimo ussa'bii. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mangkanna naangka' Puang Allata'alla langngan angngenan kamatandean dio tandai kananna, untarimami Penawa Masero situru' pa'dandinna Puang Allata'alla Ambena. Iamo te Penawa Masero napaturunne susi muita anna murangngia' temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Annu tae' ia lao langngan suruga Daud sapo' ma'kadaria nakua: ‘Mangka ma'kada Puang Allata'alla lako Puangku nakua: Okko'ko dio tandai kanangku ");
INSERT INTO mqjNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","angku lukkoangko angganna ewalimmu dio tingngayomu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dadi parallua' muissanan tongan anggammua' to Israel kumua inde Puang Yesus to mangkaa' mupopetoke'e naangka'mi Puang Allata'alla mendadi Dewatanta anna nabasseii bayu-bayu la umpasalama'ki'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tappana urrangngi tula'na Petrus masussa siami penawanna angganna to dio reen napolalan mekutana lako Petrus sola solana nakua: “Akamo la kipogau'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Natimba' Petrus nakua: “Pengkatoba'koa' ammu ditedok illalan sanganna Puang Yesus Kristus anna malara digarri'i kasalaammu anna bengkoa' Penawa Masero Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Annu ikomoa' sola peampoammu napatu pa'dandi iatoo anna budapa to mambela la natambai Puang Allata'alla Dewatanta.” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Budapi tula' senga' napalanda' Petrus lako tau kamban naola umpakilalai kumua: “Alaikoa' kalemu illalan mai alla'-alla'na inde mai to kadake gau'e ammu malara salama'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ditedokmi angganna to ummorean tula'na Petrus, napolalan kerangngan to mangngorean allo iatoo umbai tallu sa'bu tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inde mai taue barring umperangngii pepa'guruanna rasul. Sima'rempun umpamesa penawa, umpiak-piak roti anna ummande sola-sola, anna ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Buda tanda memangnga-mangnga sola ma'rupa-rupa tanda napogau' rasul napolalan mengkarea' asan tau langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Anna angganna inde to mangngoreanne tontong liu ma'mesa anna angganna aka-aka nasola-solai. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ianna dengan umbaluk ewananna natawa-tawami allinna situru' kaparalluanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Allo-allona ma'mesa liu illalan Banua Ada'na Puang Allata'alla. Sibala'-bala'mi nangei banuanna ma'mesa sitonda penawa malenna' ma'dore'-dore' ummande ");
INSERT INTO mqjNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","napasiolaan umpudi sanganna Puang Allata'alla. Naporai asammi tau dio Yerusalem anna allo-allona narangnganni liu Puang Allata'alla bilanganna to dipasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pissan attu, la tettek tallumi karuen mengkalaomi Petrus sola Yohanes langngan Banua Ada'na Puang Allata'alla annu la nalambi' omi attunna ma'sambayang to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dio sa'de ba'ba balana Banua Ada'na Puang Allata'alla disanga Ba'ba Maleke, dengan mesa muane balimbingan mengkalao dio mai dadinna. Inde taue sidibulle liu sae keallo annu la melau lako to la tama Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tappana ummita Petrus sola Yohanes la tama Banua Ada'na Puang Allata'alla, melaumi lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bassi unnenne'imi inde to balimbinganne anna mane ma'kada Petrus nakua: “Nenne'ikan mai.” ");
INSERT INTO mqjNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nanenne'imi annu parannu dengan aka la natandoianni. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nakuamo Petrus: “Tae'na' ummampui bulawan sola pera' sapo' iamo dio kaleku, iamo kubengangko. Ummolai kakuasaanna Puang Yesus Kristus to Nazaret, menono'moko!” ");
INSERT INTO mqjNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Naanda'imi lima kananna anna pake'de'i. Tappa matoto' siami lentekna, napolalan ma'sirra' ke'de' anna menono' leen anna mane unturu' Petrus sola Yohanes tama pa'ranteanna Banua Ada'na Puang Allata'alla napasiolaan mengkattibe-tibe umpudi sanganna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Mangnga-mangnga asan to dio Banua Ada'na Puang Allata'alla ummitai menono' napasiolaan umpudi Puang Allata'alla annu naissanan asammi kumua to siummokko' kapelau-lau dio sa'de Ba'ba Maleke. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inde taue ummula' liu Petrus anna Yohanes sae lako mesa angngenan illalan Banua Ada'na Puang Allata'alla disanga sali-salinna Salomo. Sae siami nakarompo' tau kamban anu' mangnga-mangnga ummitai. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tappana ummita tau buda Petrus, ma'kadami nakua: “O to Israel, maakari ammu mangnga-mangnga ummita inde kadadianne? Maakari ammu nenne'i liukan susi tappa' kakuasaangki battu kamaseroangki napolalan malapu' inde taue? ");
INSERT INTO mqjNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Puang Allata'alla Dewatanna Abraham, Ishak, Yakub, anna angganna neneta mangka untandean Sabua'na iamo Puang Yesus to mangka musorong rokko lisu pala'na Pilatus sola tumpu pala' dio tingngayona, moika anna morai Pilatus la urrappananni. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","To Maseromo anna To Malolo mutumpu pala'a', anna to papateammo mupelau lako Pilatus la dirappanan. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Umpateimokoa' To la mepatette lako katuoan sae lako-lakona sapo' napatuo sule Puang Allata'alla dio mai alla'na to mate, anna kara-kara iatoo kami sa'binna. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Annu kapangngoreanan lako Puang Yesus napolalan mala menono' inde to muissanan kumua balimbinganne susi muita temo. Malapu'mi annu kapangngoreananna lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mentu'ko siulu'ku, kuissanammi kumua ia mungei ma'pasusia' sola perepi'mu lako Puang Yesus annu tae'a' muissanan aka mupogau'. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sapo' lalan iamo tee nangei ungganna'i battakadanna Puang Allata'alla napalanda' nabi kumua: innang la ummolai kamaparrisan To nabassei bayu-bayu Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Iamo too mengkatoba'mokoa'i, ammu ma'pasule lako Puang Allata'alla, anna garri'iangkoa' kasalaammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Anna malara napomasannang penawammu Puang Allata'alla anna ussua Puang Yesus To mangka nabassei bayu-bayu la umpasalama'koa'. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","La torro yao suruga Puang Yesus sae lako nalambi' attunna la ungganna'i pa'dandinna Puang Allata'alla, la umbakarui angga lako, susi mangka napalanda' nabi to maserona mengkalao dio mai. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Susi mangka napokada Musa nakua: ‘La dengan mesa tau illalan alla'-alla'mua' la naangka' nabi Puang Allata'alla Dewatammu susina'. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Benna-benna tae' umperangngii tula'na inde nabie la disukke'i illalan mai alla'-alla'na petauanna Puang Allata'alla anna ditallanni.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Susi duka' angganna nabi mengkalao dio Samuel umpa'pakarebaan asan aka dadi temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ikomoa' la untarima battakadanna Puang Allata'alla mangka napalanda' nabi anna la mangngala tawa illalan pa'dandinna Puang Allata'alla lako neneta. Annu mangka ma'kada Puang Allata'alla lako Abraham nakua: ‘Ummolai pembatisammu angganna ma'rupa tau illalan lino la kutamba'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Napolalan ummangka' Sabua'na Puang Allata'alla anna bunga'-bunga'na nasua lako kalemua', annu la natamba'koa' natette dio mai lalan kakadakean.” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Marassampi mantula' Petrus sola Yohanes lako tau kamban anna saemo napellambi'i pira-pira imam sola to Saduki anna kapalana to siundagai Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Inde taue keara' asan lako Petrus sola Yohanes annu umpa'guru tau kamban anna ma'tetteran kumua: tuomi sule Puang Yesus dio mai alla'na to mate iamo umpomanassai kumua la dengan katuoanna sule to mate. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Umpealaimi Petrus sola Yohanes anna patamai tarungkun sae lako masiang annu bongimi. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sapo' buda to urrangngi pepa'guruanna mangngorean napolalan kerangngan bilanganna to mangngorean umbai la nalambi'mo lima sa'bu muane. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Masiangna, ma'mesami dio Yerusalem perepi'na to Yahudi sola to dipotomatua anna to untarru' issinna Sura'na Musa. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dio duka' reen Pongkena Imam disanga Hanas sola Kayafas, Yohanes, Aleksander anna budapa tau senga' dio mai rapunna Pongkena Imam. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dibaami Petrus sola Yohanes lako tingngayona inde to ma'mesae anna kutanaii nakua: “Benna umbengangkoa' kamatoroan anna kakuasaan mupolalan mala umpogau' kara-kara iatoo?” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nakuasai siami Penawa Masero Petrus anna timba'i nakua: “Mentu'ko to dipotomatua anna perepi'na to Yahudi: ");
INSERT INTO mqjNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ianna diparessakan temo ura'na umpogau'kan kamapiaan lako mesa to balimbingan anna la moraikoa' ummissananni kakuasaan aka umpomalapu'i, ");
INSERT INTO mqjNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","parallu tongan muissanan sola anggammua' to Israel kumua: Inde taue malapu'mi anna ke'de'mo temo dio tingngayomua' ura'na kakuasaanna Puang Yesus Kristus to Nazaret. Inde Puang Yesus-e mangka mupateia' yao kayu pantokesan, sapo' napatuo sule Puang Allata'alla dio mai alla'na to mate. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Puang Yesusmo tee nakalembasanni battakada illalan Buku Masero kumua: ‘batu mutibea' anggammua' tukan, diala dipobatu lentong.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Angga Puang Yesus mala umpasalama' ma'rupa tau annu tae' dengan tau senga' illalan lino nabeen kakuasaan Puang Allata'alla umpasalama' ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mangnga-mangngami to ma'mesa ummita kabaranianna Petrus sola Yohanes annu naissanan kumua tau beasa anna to tamassikola. Nakilalaimi kumua to unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sapo' ta'mo naissan mantelang aka dio siami sa'dena Petrus sola Yohanes ke'de' inde to napomalapu'e. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ussuami Petrus sola Yohanes suun anna mane sipantula'-tula' ");
INSERT INTO mqjNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nakua: “Akamoa' la tapogau' lako inde taue? Annu naissanan asammi tau inde Yerusalem kumua inde to duae mangka umpogau' tanda memangnga-mangnga anna tae' diissan la ditelang. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sapo la tadapaia' untetteran sanganna Yesus lako tau moi benna, indana tuttuan budamo tau urrangngi pepa'guruanna.” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dadi mangkai sipantula'-tula' untambaimi sule Petrus anna Yohanes anna dapaii umpa'pa'guruan battu ussa'bu' sanganna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sapo' natimba' Petrus sola Yohanes nakua: “Iko mammoa' umpenawa-nawanni, umbanna la mapia dio olona Puang Allata'alla: pa'kuammurakaa' la dituru' pa'kuannaraka Puang Allata'alla? ");
INSERT INTO mqjNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Annu tae' dengan leleanna tae' la kitetteran liu kara-kara mangka kiita sola kirangngi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tuttuan undapaimi Petrus sola Yohanes anna mane rappananni, annu tae' dengan lalan naita la naola umpabambannii sangka', annu umpudi asammi Puang Allata'alla tau kamban ummita kara-kara napogau' rasul. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Inde to napomalapu' ummolai tanda memangnga-mangngae, la'bimi appa' tapulo taunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mangkai dirappanan Petrus sola Yohanes, laomi umpellambi'i solana anna untetteran angganna tula'na kapala imam sola to perepi'na to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Inde anna rangngimi solana tula'nae umpamesami penawa anna ma'sambayang langngan Puang Allata'alla nakua: “O Puang Allata'alla to menggaraganna langi' anna lino, sola tasik anna angganna issinna. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mangkamoko umpaombo' battakadammu ummolai kuasanna Penawa Masero napalanda' sabua'mu Daud neneki kumua: ‘Maakaria anna kakeara'-ara' angganna to salianna to Yahudi; anna anggamo kara-kara tala malanna nalambi' iamo la umbali Puang Allata'alla napasalui penawa to buda? ");
INSERT INTO mqjNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Angganna tomaraya illalan lino ma'patoka anna ma'mesa angganna pekutu' la umbali Puang Allata'alla sola To nabassei bayu-bayu Puang Allata'alla.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","O Puang Allata'alla, sitonganna innang mangkami ma'mesa inde Yerusalem tomaraya Herodes anna Pontius Pilatus sola tau senga' salianna to Yahudi anna to Israel umbali Puang Yesus Sabua' maseromu anna to mangka mubassei bayu-bayu. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Annu la umpalako mentu'na kara-kara mangka mupatantu mengkalao dio mai situru' kakuasaammu anna pa'kuammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Puang, muissanammi umba napasusi undapaikan la umpalanda' Kareba Kadoresan. Dadi bengkan kamatoroan anggangki sabua'mu angki malara barani umpalanda' battakadammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pakawanammi kamatoroammu illalan kaleki umpomalapu' to masaki anna umpogau' ma'rupa-rupa tanda anna tanda memangnga-mangnga ummolai kakuasaanna Puang Yesus Sabua' maseromu.” ");
INSERT INTO mqjNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mangkanna ma'sambayang parodo siami angngenan nangei ma'mesa. Nakuasai asammi Penawa Masero napolalan baranimo umpalanda' battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Angganna to mangngorean mesa penawa anna tae' dengan mesa tau la kendek illalan penawanna kumua angganna diona kalena mesai ummampuii, sapo angganna diona kalena napada-padai. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ummampuimi kakuasaan rasul untetteran katuoanna sule Puang Yesus, anna angganna to mangngorean ullolongan tamba'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Tae' dengan mesa tau tae' la sidundu annu to ummampui litak battu banua nabaluk anna baai lako rasul allinna annu la natawa-tawa lako simesa-mesa tau situru' kaparalluanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Susi duka' Yusuf umbaluk bela'na anna baai lako rasul allinna. Inde Yusuf-e peampoanna Lewi to lu dio mai Siprus sinasangai Barnabas rasul kalembasanna to ma'pakatana. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dengan duka' mesa tau disanga Ananias sola bainena disanga Safira umbaluk salaoan litakna. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nasituru'imi bainena la umpatorro sabarean alli litakna anna sabareanna nabaa lako rasul. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Sapo' ma'kada Petrus lako nakua: “O Ananias maakari anna kuasai ponggawana setang penawammu mupolalan tae' ungkaloloi Penawa Masero umpatorro sabarean alli litakmu? ");
INSERT INTO mqjNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Inde ammu ta'pa umbaluk litakmue, iko ummampuii. Mangkai mubaluk iko liu siamo ummampui allinna. Dadi maakari anna kendek illalan penawammu la ma'gau' susi? Tangngia angga lako ma'rupa tau mungei tae' mantula' tongan sapo' langngan duka' Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tappana urrangngi tula'na Petrus songka siami Ananias anna kattu penawanna. Marea' asan angganna to urrangngi kadadian iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Saemi pira-pira anak muane umbalun batang rabukna Ananias anna mane lao ullamunni. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Umbai tallui tettek mangkanna, saemi duka' bainena sapo' tae' naissanan aka mane mangka dadi. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma'kadami Petrus lako nakua: “Tulasanna' sitonganna, angga tongammika te pada alli litakmua'e?” Natimba' inde bainee nakua: “Io, angga tongammi tu padao.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nakuamo Petrus: “Maakari ammu situru'ia' muanemu la ussandak-sandak Penawa Maserona Dewata? Perangngii, itin lako tauo mane sule lao ullamun muanemu, ia siamo duka' la lao ullamungko.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Songka siami dio tingngayona Petrus anna pa'de penawanna. Saei tama inde mai anak muanee bonno'mi nalambi'. Nabullemi lao anna lamunni dio sa'dena muanena. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Marea' tongan-tongammi angganna to mangngorean anna mentu'na to urrangngi kara-kara iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Buda tanda anna tanda memangnga-mangnga napadadi rasul illalan alla'-alla'na tau buda. Sima'mesami to mangngorean dio Sali-salinna Salomo dio Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tae' dengan tau senga' la barani umpentappaii, sapo' moi susi too natayuk liu duka' tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Samasae-saena sakerangngan-rangnganna to mangngorean lako Puang Yesus, susi muane tenni baine. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lambisan buda tau umbaa to masakinna lako lalan anna pamamma'i dio angngenan mammasan battu ampa' dio biring lalan. Annu nakua moi podo kalimbayonamo Petrus ke liui urrua sala' bennanna inde to masakie tae' mala tamalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Buda duka' tau sae dio mai tondok sikadappi'na Yerusalem umbaa to masakinna anna to natamai setang. Angganna tau iatoo dipomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mangungngu' penawami Pongkena Imam sola angganna to unturu'i iamo to Saduki, aka sabuda-budannamo tau ummorean Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","napolalan umpealai angganna rasul anna patamai tarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sapo' bongii saemi mesa malaeka'na Puang Allata'alla untungka'i ba'ba tarungkun anna pasunni anna ma'kada nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Laokoa' lako Banua Ada'na Puang Allata'alla ammu ulelean kareba katuoan bakaru lako tau buda.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Unturu'mi kadanna malaeka' rasul, napolalan mebongngi'-bongngi' lako Banua Ada'na Puang Allata'alla ma'pa'guru. Marassanni ma'pa'guru rasul, mesuami Pongkena Imam sola to unturu'i untambai angganna pa'bisara alukna to Yahudi battu dikua perepi'na to Israel anna ma'mesa. Anna mane ussua tau lao ummala angganna rasul tama tarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sapo' saei lako pa'tarungkunan pa'de asammia rasul illaan, napolalan ma'pasule anna ma'kada lako nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Saekan lako pa'tarungkunan manda' ba'ba tikado' anna lako siamo sa'de ba'ba to daga. Sapo' untungka'ikan ba'ba ta'mo dengan tau illalan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mangnga-mangnga inde kapalana to siundagai Banua Ada'na Puang Allata'allae sola angganna kapala imam urrangngi tula'na inde taue, anna pusa' umpikki' battu akamo la dadi. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tapakala sae mesa tau umbaa kareba nakua: “Perangngia'i, iato to mupatamaa' tarungkunno, illalan asammi Banua Ada'na Puang Allata'alla marassan ma'pa'guru lako tau kamban.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mengkalao siami kapalana to siundagai Banua Ada'na Puang Allata'alla sola pira-pira to sidio sa'dena lao ummala rasul, sapo' tae' naparrang annu marea' la naleba'i batu tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nabaami lako tingngayona pa'bisara alukna to Yahudi. Naparessami Pongkena Imam nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kusanga mangkamokoa' kidapai la umpa'pa'guruan itin tau disanga Yesus-o. Sapo' tuttuan ussambairokoa' iko Yerusalem untetteranni anna moraikoa' la umpatumangngikan kamateanna itin tauo.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Natimba'mi Petrus sola solana nakua: “Tangngia kami pa'kuanna ma'rupa tau la kituru' sapo' pa'kuanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Aka Puang Yesus, to mupopepateia' yao kayu pantokesan, mangkami napatuo sule dio mai alla'na to mate Puang Allata'alla to napenombai neneta. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mangkami nabeen kamatandean anna kakuasaan Puang Allata'alla mendadi Perepi' anna To umpasalama' ma'rupa tau, anna malara dengan lalan la naola to Israel mengkatoba' anna digarri'i angganna kasalaanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kamimo ussa'bii angganna kara-kara iatoo. Nasa'bii toi duka' Penawa Maserona Puang Allata'alla mangka napa'kamasean lako to unturu' Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tappana urrangngi kadanna Petrus, rede siami ara'na pa'bisara alukna to Yahudi napolalan nasituru'-turu'i la umpatei angganna rasul. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sapo' dio duka' reen mesa to Farisi disanga Gamaliel to nakala' kombongan pa'bisara alukna to Yahudi. Inde Gamaliel-e mesa to untarru' issinna Sura'na Musa anna naangga' tau kamban. Ke'de' anna ussua tau umpasuun rasul lako salian sappai'. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Le'bai ma'kadami lako inde to ma'mesae nakua: “O to Israel pikki' manappaia' aka la mupogau' lako inde mai taue. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Annu yolona dengan kendek mesa tau disanga Teudas, to ussanga-sanga kalena, napolalan umbai appa' ratu' tau unturu'i boko'na, sapo' dipatei lambisan sisarak-sarak babang to unturu'i, katampakan pa'de babang. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mangkai too, attunna anna parrekenan ma'rupa tau, kendek pole omi Yudas to Galilea anna buda tau menturu' lako, la umbali to ma'parenta. Sapo' katampakanna dipatei anna sisarak-sarak babang duka' to unturu'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Dadi, kupakilalakoa' temo kumua tae'koa' la umpogau' aka-aka lako inde taue. Pabeai mammi, annu ianna pa'kua rupa taura pa'tangnga'na sola pa'palakona innang tokke' sia la pa'de babang. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sapo' ianna situru'ra pa'kuanna Puang Allata'alla innang tae' la mubela mutaloia', anna bennara ummissananni ke dako' anna Puang Allata'allamo iko mubalia'.” Inde tula'na Gamaliel-e natarima pa'bisara alukna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Untambaimi sule rasul anna popekambeii, anna dapaii umpa'pa'guruan liu Puang Yesus, anna mane rappananni. ");
INSERT INTO mqjNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Dore' asammi rasul umpellei kombongan pa'bisara alukna to Yahudi aka nasa'ding kumua: “Naangga'kia' Puang Allata'alla sipato' untarima pandarraan ura'na sanganna Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Allo-allona ma'pa'guru liu illalan Banua Ada'na Puang Allata'alla sola lako banuanna tau anna ummulelean Kareba Kadoresan kumua Puang Yesus iamo To nabassei bayu-bayu Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Attu iatoo tuttuan budami kerangngan to mangngorean. Kendekmi nuku-nuku illalan alla'-alla'na to Yahudi to ma'basa Yunani lako to Yahudi senga' to ma'basa Ibrani annu kaparalluanna baine ballunna tangkaan dipapada baine balu senga'. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Urrempummi to mangngorean inde sapulo dua rasul-e, anna ma'kada lako nakua: “Tae' sipato' ke la ta'mokan umpalanda' battakadanna Puang Allata'alla annu la untarakannimokan baine balu. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dadi mentu'ko siulu', pilemia' pitu tau illalan alla'-alla'mua' to musangaa' mapia penawa anna to nakuasai Penawa Masero anna keaka'. Annu tau iatoo la kiangka' la untarakanni mentu'na baine balu. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Angki malara kami umpatutui penawa umpalanda' battakadanna Puang Allata'alla anna ma'sambayang.” ");
INSERT INTO mqjNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nasituru'imi angganna to ma'rempun, napolalan umpile: Stefanus mesa to matoto' kapangngoreananna anna to nakuasai Penawa Masero, sola Filipus, Prokhorus, Nikanor, Timon, Parmenas, anna Nikolaus to lu dio mai Antiokhia to tama alukna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dibaami lako tingngayona rasul. Saei lako ma'sambayangmi rasul anna umballa'i pala' inde to pitue la umpalako karangan iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tuttuan budami tau urrangngi battakadanna Puang Allata'alla anna tuttuan kerangngan to mangngorean dio Yerusalem. Buda duka' imam ummorean Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus untarima pa'tamba'na Puang Allata'alla anna kakuasaan napolalan mala umpogau' ma'rupa-rupa tanda anna tanda memangnga-mangnga illalan alla'-alla'na tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Sapo' dengan pira-pira tau umbalii napolalan sipekka Stefanus. Tau iatoo sima'sambayang illalan mesa pa'sambayanganna to Yahudi disanga Libertini (kalembasanna: Pa'sambayanganna To Dilappasan dio mai kasabuasan), pa'sambayanganna to lu dio mai Kirene, Aleksandria, Kilikia anna Asia. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sapo' tae' nabela untalo kada Stefanus annu Penawa Masero umbenganni kakeakasan napolalan manarang mantula'. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Laomi usse'dek pira-pira tau la umpatampoi kasalaan Stefanus kumua: “Mangka kirangngi untelle Musa sola Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iamo napolalan kendek ara'na tau kamban sola perepi'na to Yahudi anna to untarru' issinna Sura'na Musa. Umpealaimi Stefanus anna mane baai lako tingngayona pa'bisara alukna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pira-pira sa'bi tatongan napopengngolo lako pa'bisara alukna to Yahudi, umpalanda' kasa'bianna nakua: “Inde taue untunai liu Banua Ada'na Puang Allata'alla anna pepa'guruanna Musa. ");
INSERT INTO mqjNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mangka kirangngi nakua: ‘Inde Yesus to Nazaret-e la urroppokan inde Banua Ada'na Puang Allata'allae anna la umbanga' sangka' napa'pa'guruan Musa lako kaleta.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Angganna to tongkon illalan pa'rempunan iatoo unnenne'i asan Stefanus, naitami lindona susi rupanna malaeka'. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mekutanami Pongkena Imam lako Stefanus nakua: “Tongannaraka tula'na inde mai taue?” ");
INSERT INTO mqjNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ma'kadami Stefanus nakua: “Anggammua' sa'do'dorangku anna to kupotomatua, perangngia' tula'ku: Mangka umpa'paitaan kalena Puang Allata'alla To Randan Matande lako neneta Abraham dio Mesopotamia, anna ta'pa membero lako tondok Haran. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Attu iatoo ma'kada Puang Allata'alla nakua: ‘Tampeko tondokmu anna rapummu ammu lao lako mesa tondok la kupaturoiangko.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mengkalao siami Abraham umpellei lembangna to Kasdim anna membero lako Haran. Mangkanna bonno' ambena, nasua pole omi Puang Allata'alla membero sae inde lembang tangeia' torro temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Attu iatoo, ta'pa dengan nabenganni Puang Allata'alla litak illalan inde lembangnge la napomana' moi la sadangkammo. Sapo' ma'dandi Puang Allata'alla nakua: ‘Pissan attu inde litakke la kubengangko ammu ampuii sola angganna peampoammu.’ Moika anna attu iatoo ta'pa dengan anakna Abraham. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nakua kadanna Puang Allata'alla lako Abraham: ‘Angganna pembatisammu la mendadi to messae dio lembangna tau senga' anna la naposabua' sola napakario-rio appa' ratu' taunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sapo' inde to umposabua'ie la kupatumangngi pa'palakona. Mangkaii mallaimi dio mai angngenan iatoo, anna la sule sae inde umpenombaina'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Anna mane umpaombo' pa'dandi sunna' Puang Allata'alla lako pembatisanna Abraham. Napolalan karuai allona dadinna Ishak anakna Abraham, nasunna'mi. Ishak undadian Yakub anna Yakub undadian to sapulo dua to tangeia' buttu angganta to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Inde nenetae mangungngu' penawa lako mesa sirondongna disanga Yusuf napolalan nabaluk lako Mesir naposabua' tau. Sapo' inde Yusuf-e nasolaan liu Puang Allata'alla ");
INSERT INTO mqjNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","anna sinalappasan dio mai angganna kamaparrisan. Nabenganni kakeakasan Puang Allata'alla napolalan keangga' dio tingngayona Firaun tomarayanna Mesir. Lambisan naangka' tomaraya Firaun ummanda'i kakuasaan dio lembangna Mesir anna illalan banuanna tomaraya. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tapakala kendek karorian illalan lembangna Mesir anna lembangna Kanaan napolalan ussa'dingan kamaparrisan mabanda' neneta aka ta'mo dengan nangei ummala nande. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tappana naissanan Yakub kumua dengan gandum dio Mesir, ussuami anakna lako. Iamo te bunga'na lao lako Mesir nenetae. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Inde anna laomo kapenduannae, mane umpa'paissanarri kalena Yusuf lako sirondongna, napolalan naissanan Firaun rapunna Yusuf. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ussuami tau Yusuf lao ummala Yakub ambena sola angganna rapunna anna membero lako Mesir. Rapunna Yakub attu iatoo pitu pulomi lima. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Memberomi Yakub lako lembangna Mesir, napolalan bonno' diomo sola angganna neneta. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Sapo' dibaa sule lako Sikhem batang rabukna anna dipatama lokko' mangka naalli doi' pera' Abraham lako anakna Hemor dio Sikhem. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Madappi'i attunna la ungganna'i pa'dandinna Puang Allata'alla lako Abraham, tuttuan kembea'mi neneta dio Mesir. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pissananna diangka' mesa tomaraya senga' ma'parenta dio Mesir, to ta'mo ummissanan Yusuf. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inde tomarayae umpa'tomaroi neneta lambisan nadarra-darra anna suai untibe anak mane dadinna indana tuo. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Attu iamo too nangei dadi Musa, mesa anak maleke rupanna. Tallu bulan illalan banua nataranak to matuanna ");
INSERT INTO mqjNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","anna mane ditibe. Sapo' naruruk anakna Firaun baine anna taranakki susi anak dadianna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Inde Musae dipa'guru angganna kamanaranganna to Mesir, napolalan karangngian susi tula'na tenni pa'palakona. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Appa' tapuloi taunna, kendekmi illalan penawanna morai la lao umpellambi'i to Israel rapunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Attu iatoo ummita mesa to Israel nadarra mesa to Mesir, napembalasammi, lambisan umpatei inde to Mesir-e. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nasanga Musa la naissanammi siulu'na to Israel kumua iamo la napake Puang Allata'alla ullappasanni dio mai kasabuasan, sapo' ta'ra naissanan. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Masiangna ummita omi dua tau bassi to Israel menge siala. Naalla'imi Musa anna sandakki napasikapia, nakuammi: ‘Maakari ammu sialaa' pakaiko siamo?’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sapo' inde to sala lako solanae ussulunan Musa anna ma'kada lako nakua: ‘Benna ummangka'ko perepi'ki ammu la bisarakan? ");
INSERT INTO mqjNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Morairokoka la umpateina' duka' susi to Mesir mupatei samai'?’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Urrangnginna tula' iatoo, mengkalao siami Musa lako Midian anna torro dio. Iamo nangei dadi dua anakna bassi muane. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Appa' tapuloi taunna dio, napellambi'imi mesa malaeka' dio alla' padang sikadappi' Tanete Sinai. Inde malaeka'e buttu illalan api ma'lana-lana dio to' duri. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mangnga-mangnga Musa ummita kadadian iatoo. Lao siami napengkadappi'i, napolalan urrangngi kamaranna Puang Allata'alla nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kaomo te Dewata to napenombai nenemue, Dewatanna Abraham, sola Ishak anna Yakub.’ Tappa lumalla' siami Musa anna marea' unnenne'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma'kada omi Puang Allata'alla nakua: ‘Alaii palopakmu illalan mai lentekmu annu itin litak mungeio litak masero. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kukawanan tongammi kamaparrisanna petauangku dio Mesir anna kurangngimo sarrona, iamo kungei sae temo la ullappasanni. Ga'gelamoko anu' la kusuako sule lako Mesir.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Iamo te Musae mangka natumpu pala' to Israel inde anna kuannie: ‘Benna ummangka'ko perepi'ki ammu la bisarakan?’ Sapo' iaria nasua Puang Allata'alla la mendadi perepi' anna to la ullappasan to Israel, ummolai malaeka'na illalan to' duri ma'lana-lana. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Anna ia siamo umbaa suun to Israel illalan mai Mesir anna umpogau' ma'rupa-rupa tanda anna tanda memangnga-mangnga dio Mesir, dio Tasik Malea anna lako padang alla' appa' tapulo taunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa siamo duka' mangka mantula' lako to Israel nakua: ‘La umpabuttu mesa nabi susina' dio mai pembatisammua'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Anna ia siamo ussolaan petauanna Puang Allata'alla dio padang alla' anna umpalanda' tula'na malaeka' yao Tanete Sinai lako neneta. Anna iatomo duka' untarima battakada tuona Puang Allata'alla la dipalanda' sae lako kitaa' temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Sapo' moka neneta unturu' Musa sangngadinna natumpu pala' anna morai la sule lako Mesir. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Napelaumi lako Harun nakua: ‘Garagangkan pira-pira dewata la umpatettekan, annu ta'mo kiissanan aka dadi lako Musa to untettekan dio mai Mesir.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Unggaragami pa'pasusian silio anak saping la napodewata, anna mane umbaa bua pemala'na lako umpenombaii anna ma'dore'-dore' umpakasalle pa'padadinna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Napolalan napemboko'i Puang Allata'alla anna pabeai umpenombai bentoen susi tiuki' illalan sura'na nabi nakua: ‘O to Israel, tangkao mupenombai anna mubaan bua pemala'mu ammu dioa' padang alla' appa' tapulo taunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Annu anggami lantang simungeia' umpenombai Molokh mubaa lelleen sola bentoenna dewatammu disanga Refan, panggaragammua' la mupenombai. Iamo kungei la umpali'koa' lako tandai lakona lembangna Babel.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pa'sambayangan sidingei ummanna parentana Puang Allata'alla nabaa neneta illaan kapenonosanna dio padang alla'. Inde pa'sambayanganne dipadadi situru' tandengan mangka napa'parentaan Puang Allata'alla lako Musa. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pa'sambayangan iatoo natarima neneta dio mai to matuanna anna baai sae inde lembang iatee, attunna anna sae sola Yosua untalo angganna to ma'tondok to narambai lao Puang Allata'alla. Iato pa'sambayanganno dipake liumi sae lako attunna ma'parenta Daud. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Inde Daud-e to umpomasannang penawanna Puang Allata'alla anna to umpelaui kenamala dipabeai umpake'de' banua la nangei Puang Allata'alla to napenombai to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sapo' inde banuae Salomoria umpake'de'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sapo' ta'raia torro illalan banua panggaraga ma'rupa tau Puang Allata'alla to Randan Matande, susi tula'na nabi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ma'kada Puang Allata'alla nakua ‘Suruga kungei ma'parenta anna angganna issinna lino Kao ungkuasaii. Banua umbamo susi la mupake'desanna'? Anna angngenan umbamo la kungei melliwe? ");
INSERT INTO mqjNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kusanga Kao asan umpadadi angga lako.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Makarra' ulu tongarrokoa' iko moka mengkaola langngan Puang Allata'alla! Tae'koa' umperangngii battakadanna Puang Allata'alla! Susi siamokoa' nenemu, angga umbali liu Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bennamo nabi tae' nadarra nenemua'? Sae lako umpatei angganna to umpakareba kasaeanna To Malolo, to mangkaa' mupa'perososan lambi' sae lako mupopepatei. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mangkamokoa' urrangngi pepa'guruanna Musa napalandasangkoa' malaeka', sapo' mokakoa' unturu'i.” ");
INSERT INTO mqjNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tappana urrangngi tula'na Stefanus inde pa'bisara alukna to Yahudie rede siami ara'na anna tikarasissik isinna. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sapo' nakuasai Penawa Masero Stefanus mentungngu langngan suruga anna ummita kamatandeanna Puang Allata'alla sola Puang Yesus ke'de' yao angngenan kamatandean dio tandai kananna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tappa ma'kadami nakua: “Nenne'ia', ummitana' suruga titungka' anna Anak Mentolino ke'de' dio tandai kananna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Sapo' ussissing asammi talinganna anna mealo'-alo' ungkarompo' Stefanus anna mane rui' sesse'i lako salian tondok la nasileba'-leba'i batu. Inde to sa'bi tatonganne ummalai bayu rui'na anna paokko'i dio tingngayona mesa to mangngura disanga Saulus anna mane ma'leba'. ");
INSERT INTO mqjNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Marassanni nasileba'-leba'i batu ma'sambayangmi Stefanus nakua: “O Puang Yesus, tarimami sunga'ku!” ");
INSERT INTO mqjNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Anna mane malimuntu' anna mealo' nakua: “O Puang dau patumangngi kasalaanna inde mai taue.” Mangkanna mantula' susi, kattumi penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Nasituru'i duka' Saulus kadipateianna Stefanus. Mangkai too saemi pira-pira to mengkarea' langngan Puang Allata'alla ummala batang rabukna Stefanus anna batingngii anna mane lamunni. Sapo' inde Saulus-e morai la umpa'dean angganna to mangngorean lako Puang Yesus. Laomi ullelean banua anna urrui' sesse' to mangngorean susi baine tenni muane anna mane popetarungkunni. Dadi attu iatoo naparandukmi kendek pandarraan mabanda' lako to mangngorean dio Yerusalem. Napolalan angganna to mangngorean, salianna rasul, tisembu' anak manuk ussambai lembangna Yudea anna Samaria. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pantan le'bami ussambai tondok umpalanda' Kareba Kadoresan inde to mangngorean to tisembu' anak manukke. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipus lu rokko mesa tondok dio Samaria anna untetteran To nabassei bayu-bayu Puang Allata'alla lako to ma'tondok. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tappana urrangngi tula'na Filipus anna ummita ma'rupa-rupa tanda napogau', napaillan tambuk asammi. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Annu buda tau mallai setang illalan mai kalena napasiolaan kumillong-killong, anna buda duka' to balimbingan sola to kempo' napomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Napolalan kendek kadoresan illalan tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Illalan inde tondokke dengan mesa tau disanga Simon masae allomi naola umpamangnga-mangnga tau dio Samaria anu' ma'issan-issan, anna siussanga kalena to kamai. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Angganna tau, kasalle barinni' mengkaola lako kalena anna ma'kada nakua: “Tau iatee iamo kuasanna Puang Allata'alla sidisangai ‘Kuasa Ma'tanda Langnganan’.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iamo nangei buda tau unturu'i anu' masaemi naola umpamangnga tau napobua' issan-issanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sapo' tappana sae Filipus umpalanda' Kareba Kadoresan untetteran kaparentaanna Puang Allata'alla anna Puang Yesus Kristus, naorean asammi anna ditedok susi muane tenni baine. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Inde Simon-e mangngorean duka' napolalan ditedok. Sola liumi Filipus mangkanna ditedok anna simangnga-mangnga ummita ma'rupa-rupa tanda anna tanda memangnga-mangnga dadi. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tappana napekareba angganna rasul dio Yerusalem kumua untarimami battakadanna Puang Allata'alla to dio Samaria, ussuami Petrus sola Yohanes lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Saei lako umpa'sambayangammi to dio Samaria anna malara nabeen Penawa Masero Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Anu' ta'pa dengan natamai Penawa Masero moi la mesa, aka mane angga ditedok illalan sanganna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Naballa'imi pala'na Petrus anna Yohanes napolalan natamai asan Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Naitanna Simon kumua mala tau natamai Penawa Masero ke naballa'i pala'na rasul, umbaami doi'na lako Petrus anna Yohanes ");
INSERT INTO mqjNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","anna ma'kada nakua: “La mubeenna' itin kakuasaammuo anna malara benna-benna kuballa'i pala'ku, mala duka' natamai Penawa Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sapo' natimba' Petrus nakua: “La sanggangko sola itin doi'muo, annu musanga mala dialli doi' kakuasaanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tae'ko sipato' ungkarang pengkarangan iatee aka tae'ko malolo dio tingngayona Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dadi pengkatoba'ko ammu pa'sambayang langngan Puang Allata'alla, anna malara nagarri'i kakadakean illalan penawammu, ");
INSERT INTO mqjNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","annu kuissanan kumua dengan kapuisan illalan penawammu anna napungoko kakadakean.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Natimba' Simon nakua: “La mupa'sambayanganna' langngan Puang Allata'alla anna malara angganna inde tula'mue tae' la dadi lako kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mangkanna umpalanda' battakadanna Puang Allata'alla untetteran Puang Yesus, ma'pasulemi Petrus sola Yohanes lako Yerusalem ummola buda tondok senga' dio Samaria anna umpalanda' Kareba Kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dengan mesa malaeka'na Puang Allata'alla sae ma'kada lako Filipus nakua: “Ga'gelako ammu mengkalao ummundu' lalan yao mai Yerusalem lu lako Gaza.” (Inde lalanne ummola alla' padang.) ");
INSERT INTO mqjNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tappa mengkalao siami Filipus. Dio lalan iatoo dengan to Etiopia mesa to kamai to ummissanan angganna ewananna Kandake tomaraya baine dio kaparentaan Etiopia. Tau iatoo lu yao mai Yerusalem sule lao menomba langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ummola lalammi ma'pasule lako Etiopia, ummokko' yao bendinna marassan umbaca sura' nabi Yesaya. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ma'kada Penawa Masero lako Filipus nakua: “Laoko umpellambi'i udio bendio!” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Lao tongammi napellambi'i Filipus, napolalan narangngi marassan umbaca sura' nabi Yesaya. Nakutanaimi Filipus nakua: “Muissanangka kalembasanna itin mubacao?” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Natimba' inde taue nakua: “Umbamo la kukua ummissananni ke tae' dengan tau umpatuduna'?” Untambaimi Filipus langngan bendinna ummokko' dio sa'dena. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inde battakadanna Puang Allata'alla nabacae nakua: “Sirapan domba direnden lako angngenan pantunuan, anna susi anak domba mengkamma' ke dikotti bulunna. Susi siami duka' tae' dengan moi podo la tiu'bi'mo pudukna. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dipakario-rio anna dipaolai tasipato'na. Tae' dengan tau naissan urrettenni pembatisanna annu dialai sunga'na illalan mai lino.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mekutanami inde tau lako Filipus-e nakua: “Bennara napatu tula'na inde nabie? Kalenaraka? Tau senga'raka?” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Naparanduk pole' ma'tetteran Filipus mengkalao dio inde issinna sura' nabaca angngena'e napolalan umpalanda' Kareba Kadoresan untetteran Puang Yesus lako inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Napatarru' liu siami menono', napolalan ullambi' mesa angngenan dengan wai dio. Tappa ma'kada inde taue nakua: “Dengammi wai talambi', dengampika la ullawai ke ditedokna'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Natimba' Filipus nakua: “Ianna sangkalebu tongammo penawammu mangngorean malamoko ditedok.” Natimba' nakua: “Kuoreammi kumua Puang Yesus Kristus anakna Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ussuami to umpopenonosanni bendinna anna patorroi anna mane turun rokko wai sola Filipus, anna tedokki. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kendekki dio mai wai sae siami Penawa Maserona Dewata ummala Filipus nabaa lao, napolalan ta'mo naita inde to natedokke. Dore'mi le'ba umpatarru' penonosanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Sapo' lemba' diomia Asdod Filipus. Umpatarru'mi penonosanna Filipus, napasiolaan siami umpalanda' Kareba Kadoresan lako angganna tau tama tondok illalan lembang iatoo napolalan sae lako Kaisarea. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Attu iatoo morai liupi Saulus la umpakarea' anna la umpatei angganna to ummorean Puang Yesus. Napolalan lao umpellambi'i Pongkena Imam dio Yerusalem ");
INSERT INTO mqjNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","anna umpelau sura' parenta annu la napa'paitaan lako angganna perepi' illalan pa'sambayanganna to Yahudi dio Damsyik anna malara dipabeai umpealai to unturu' pepa'guruanna Puang Yesus susi muane tenni baine, anna baai lako Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Illalan penonosanna lako Damsyik, la sae kalemi lako, tokke'mi dengan pangngarrang yao mai langi' ungkabu' Saulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tisambak siami rokko litak anna urrangngi kamara nakua: “O Saulus, O Saulus, maakari ammu pakario-riona'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mekutanami Saulus nakua: “O Puang, bennaroko Iko?” Natimba'mi nakua: “Kaomo te Puang Yesus to mupakario-rioe. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sapo' millikmoko ammu tarru' lako Damsyik, annu la saepoko lako ammu mane ditulasan aka la mupogau'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Marea' asammi to nasolaan Saulus napolalan tae' naissan sumu, annu urrangngi duka' kamara sapo' tae' dengan ummita tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ke'de'mi Saulus anna umpamillik matanna sapo' ta'mo paita, iamo nangei natettemo solana sae lako Damsyik. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tallungngallo tae' paita, anna tala ummande tala ummiru'. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dio Damsyik dengan mesa to ummorean Puang Yesus disanga Ananias. Inde Ananias-e taman napolalan urrangngi kamaranna Puang Yesus nakua: “Ananias!” Natimba'mi nakua: “O Puang, akara muparalluianna'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ma'kada pole omi nakua: “Laoko lako banuanna Yudas dio disanga Lalan Malolo ammu pekutananni mesa to lu dio mai Tarsus disanga Saulus. Marassan ma'sambayang temo ");
INSERT INTO mqjNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","sapo' tokke' taman napolalan ummita mesa tau disanga Ananias sae umballa'i pala' anna malara paita sule.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sapo' natimba' Ananias nakua: “O Puang Yesus, budami tau umpokadai kumua tau iatoo siundarra angganna to ummoreangko dio Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Temo saemi inde Damsyik napakuasa kapala imam la umpealai angganna to ummoreangko.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Sapo' ma'kada Puang Yesus nakua: “Laoko, annu tau iatoo mangka kupilei la umpa'peassakan sangangku, susi lako tau senga' salianna to Yahudi anna tomarayanna tenni lako to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Annu Kao siamo la umpaitaii umba susi kamaparrisan la natammu annu ummorean sangangku.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mengkalao siami Ananias umpellambi'i Saulus dio banuanna Yudas. Tappana sae lako umballa'imi pala' Saulus anna ma'kada nakua: “O siulu'ku Saulus; Puang Yesus, to mangka umpa'paitaan kalena matin dio lalan ammu lu dio mai Yerusalem sae inde, ussuana' sae umpellambi'iko ammu malara paita sule sola nakuasai Penawa Masero.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nasa'ding siami Saulus dengan aka susi sissik be'dok mallai illalan mai matanna, napolalan paita sule. Millikmi Saulus anna ditedok. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mangkai ummande, matoromi sule nasa'ding. Pira-pirangngallopi Saulus torro dio Damsyik sola to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tappa laomi lako pira-pira banua pa'sambayanganna to Yahudi anna uleleanni kumua: Puang Yesus iamo anakna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mangnga-mangnga asan to urrangngii pepa'guruanna anna mane ma'kada nakua: “Kisanga tau iamo tee to siumpongko to ummorean Puang Yesus dio Yerusalem, anna kasaeanna inde iamo la umpealai to ummorean Puang Yesus la nabaa lako kapala imam dio Yerusalem.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sapo' tuttuan manarang Saulus ummulelean anna umpakawanan kumua Puang Yesusmo To nabassei bayu-bayu Puang Allata'alla. Napolalan pusa' babangmo to Yahudi dio Damsyik. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pira-pirangngalloi mangkanna, nasituru'-turu'imi to Yahudi la umpatei Saulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sapo' tappa naissanan Saulus pa'kua penawanna. Allo bongi undagai liu ba'ba tondok inde to Yahudie anna malara umpatei Saulus ke suunni. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sapo' nasolaan bongi langngan bala batu ulliling tondok to mangngorean napatama buria' anna mane lolloranni rokko salian. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ummalaimi kalena Saulus dio mai Damsyik anna lu lako Yerusalem. Dioi Yerusalem morai liumi Saulus la umpentappai angganna to unturu' boko'na Puang Yesus, sapo' nakarea' asan aka tae' naorean kumua unturu' tongammi boko'na Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Anggami Barnabas lao umpellambi'i anna solanni lako rasul. Natulasammi Barnabas umba nakua Saulus ummita Puang Yesus dio tangnga lalan anna umba nakua mantula' lako. Natula' toi duka' umba nakua kabaranianna ummulelean Puang Yesus dio Damsyik. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Torromi pole' Saulus sola angganna to mangngorean dio Yerusalem anna tae' dengan marea' ummulelean Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sisipantula'mi anna sikuama to Yahudi to ma'basa Yunani, sapo' inde lako taue umpeangria lalan la naola umpatei Saulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Sapo' inde anna issanammi solana to mangngoreanne, ussolammi Saulus le'ba' rokko Kaisarea anna mane patarru'i lako Tarsus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dadi masannang asan pole' angganna to mangngorean dio lembangna Yudea, Galilea anna Samaria, anna tuttuan matoto' kapangngoreananna. Illalan salu katuoanna mengkarea' langngan Puang Allata'alla anna napakaranga Penawa Masero. Tuttuan kerangngammi to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Dengan pissan attu, mengkalao Petrus ullelean tondok anna umpellambi'i angganna to mangngorean. Ullambi'mi mesa tondok disanga Lida. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Attu iatoo, illalan inde tondokke dengan mesa tau disanga Eneas karuami taunna dio sali annu balimbingan. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma'kadami Petrus lako nakua: “O, Eneas napomalapu'moko Puang Yesus Kristus, millikmoko, ammu lulun ampa'mu.” Tappa millik siami Eneas. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Angganna to dio tondok Lida anna to torro dio lili'na padang Saron ummita Eneas malapu', napolalan tappa ummorean Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Dengan mesa baine to mangngorean dio tondok Yope disanga Tabita, nasangai to Yunani Dorkas (kalembasanna donga). Inde bainee mesa to madota' anna to barring ma'petando lako to mase-mase. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Attu iatoo rokko masaki, napolalan tappa bonno'. Mangkai didio', dipamamma'mi illalan tambing yao loteng. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Inde tondok Yope anna tondok Lidae sikadappi'. Tappana napekareba to mangngorean dio Yope kumua dio Lida Petrus, ussuami dua tau lao untambaii. Saei lako nakuammi: “La ma'sirra'ko ade' lao lako.” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ke'de' siami Petrus anna mengkalao sola inde to metambae. Saei lako, disolammi langngan loteng nangei inde to matee. Dengan pira-pira baine balu yao, tumangi' asan ungkarompo' Petrus anna umpa'paitaan angganna bayu rui' sola pakean senga' pandasi'na Dorkas anna tuopa. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ussua asammi tau Petrus suun anna mane malimuntu' ma'sambayang. Mangkai ma'sambayang, menggirikmi untingngayo inde to matee anna ma'kada nakua: “O Tabita, millikko!” Umpamillikmi matanna Tabita. Tappana ummita Petrus, membangun siami anna ma'loko. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Naanda'imi limanna Petrus anna pake'de'i. Anna mane untambai angganna to mangngorean sola angganna inde baine balue anna ma'kada nakua: “Tuomi sule Tabita!” ");
INSERT INTO mqjNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tappana napelele issinna Yope kara-kara iatoo, buda tau ummorean Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pira-pirangngallopi torro Petrus dio tondok Yope dio banuanna to siumperekko'i balulang disanga Simon. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dio Kaisarea dengan mesa tau disanga Kornelius, ponggawana saratu' tantara disangai tantara Italia. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Inde Kornelius-e tangngia to Yahudi sapo' mengkarea' langngan Puang Allata'alla sola angganna to torro illalan banuanna. Sibarring ma'petando lako to Yahudi anna ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pissan attu umbai tettek tallu karuen tokke'mi taman Kornelius, napolalan ungkaleso mesa malaeka'na Puang Allata'alla sae tama banuanna anna ma'kada nakua: “O Kornelius!” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Unnenne'imi inde malaeka'e anna sitonda kamareasan ma'kada nakua: “O Puang, akara muparalluianna'!” Natimba' malaeka' nakua: “Angganna sambayangmu sola pa'petandomu saemi langngan olona Puang Allata'alla anna nakilalaiko. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Suako tau temo lao lako tondok Yope untambai mesa tau disanga Simon beasa toi duka' disangai Petrus, ");
INSERT INTO mqjNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","torro dio banuanna to siumperekko'i balulang disanga Simon, dio biring tasik.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Le'banna malaeka' untambaimi dua sabua'na Kornelius anna mesa tantarana to siumparakaii to mengkarea' duka' langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Natetteranammi Kornelius angganna tula'na malaeka', anna mane suai lako tondok Yope. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Masiangna umbai tangngamo allo, la sae kalemi lako tondok Yope inde to tallue, attu iatoo laomi langngan papa marante Petrus ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Moraimi la ummande Petrus annu tadea' sigalimi. Marassanni dipatokaan nande, tokke'mi taman. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ummitami langi' titungka' anna dengan aka susi sampin kallumbang dilolloran yao mai disangke' appa' katetukna. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Dio inde sampinne dengan ma'rupa-rupa olo'-olo' ma'lentek appa', olo'-olo' sumasa' anna ma'rupa-rupa dassi. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Urrangngimi kamara nakua: “O Petrus, ga'gelako ammu tunui ammu andei.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Sapo' natimba' Petrus nakua: “O Puang, tae' sigali-gali mala, aka pempon dadingku ta'pa dengan leleanna kupatama sadangku andean pemali diande.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Urrangngi pole omi kamara kapenduanna nakua: “Dau angga' pemalii tae'na napemalii Puang Allata'alla.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pentallun te susie, anna mane tiangka' sule langngan langi' inde sampinne. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Marassanni umpenawa-nawaan kalembasanna pangngitanna Petrus, diomi duka' luba'ba to nasua Kornelius, annu ullambi'mi banuanna Simon mangkanna napekutanaan. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma'kadami tama banua nakua: “Iamoka te banua sinangei Simon-e? Bassa' duka' siditambai Petrus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Marassan liupi umpenawa-nawaan kalembasanna pangngitanna Petrus, ma'kadami Penawa Masero nakua: “O Petrus dengan tallu tau sae umpeangko. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Turummoko rokko ammu lao sola, dau pomabanda' penawammu annu Kao ussuaii.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Turummi Petrus rokko anna ma'kada lako inde to saee nakua: “Kaomo te mupeangnge. Aka mutungka sae?” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Natimba'mi nakua: “Nasuakan Kornelius, ponggawana tantara mesa to malolo anna to mengkarea' langngan Puang Allata'alla naangga' toi to Yahudi. Nasua malaeka' maserona Puang Allata'alla umpopetambaiko lako banuanna, annu la naperangngii tula'mu.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nabawaimi Petrus tama banua anna patorroi ma'bongi dio. Masiangngi, mengkalaomi Petrus sola inde to metambae anna pira-pira to mangngorean dio Yope. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Masiangna pole saemi lako Kaisarea. Naampaimi Kornelius sola angganna rapunna anna solana to natambai lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Saena Petrus natammuimi Kornelius anna malimuntu' dio tingngayona umpenombaii. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sapo' tappa napake'de' Petrus anna ma'kada lako nakua: “Ke'de'ko, annu ma'rupa tauna' duka'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Menge liu siami sipantula' Kornelius tarru'mi tama banua. Illalan inde banuae budami tau tirempun ummampaii. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma'kadami Petrus nakua: “Muissanan asammia' kumua napemalii tongan-tongan to Yahudi sangkalamma' tau senga' salianna to Yahudi iapaka la tama banuanna. Sapo' mangkamo' napaitai Puang Allata'alla kumua tae'na' mala ummangga' pemali tau senga' kusolaan. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iamo nangei tae' mabanda' penawangku sae. Dadi la kukutanaikoa' temo: Maakari ammu popetambaina'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Natimba'mi Kornelius nakua: “Tallu bongimi temo, katenanna tee umbai tettek tallu karuen, marassanna' ma'sambayang illalan banua. Dengan mesa tau tokke' ke'de' dio tingngayoku pangngarrang pakeanna, ");
INSERT INTO mqjNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","anna ma'kada nakua: ‘O Kornelius, narangngimi sambayangmu Puang Allata'alla anna nakilalai pa'petandomu lako to mase-mase. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Suai tau lao lako tondok Yope untambai mesa tau disanga Simon sibeasa ditambai Petrus, torro dio banuanna to siumperekko'i balulang, disanga Simon, sidio biring tasik.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Iamo kungei tappa ussuamo tau lao untambaiko. Ma'kurru' sumanga'kan anu' ta' mammo mabanda' penawammu sae. Temo ma'mesamokan inde, dio tingngayona Puang Allata'alla la umperangngii aka nasuangko Puang Allata'alla la mupalanda' lako kaleki.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Naparandukmi Petrus mantula' nakua: “Sitonganna mane kuissanan tappa' temo kumua tae' mangngita rupa Puang Allata'alla lako ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sapo' angganna tau illalan lino to mengkarea' lako kalena anna umpogau' kamaloloan, natarima duka'. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Muissanan asammia' battakada mangka napopellambi' lako to Israel, iamo battakada untetteran kasikalinoanna sule ma'rupa tau anna Puang Allata'alla ummolai Puang Yesus Kristus, Dewatanna angganna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Muissanan asammia' aka mangka dadi illalan lembangna Yudea mengkalao dio Galilea mangkanna pantedokan napa'pakarebaan Yohanes. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Umba nakua Yesus, to lu dio mai Nazaret nabassei bayu-bayu Puang Allata'alla, iamo nabenganni Penawa Masero anna kakuasaan. Lu rekke lu sau' umpogau' kamapiaan anna umpomalapu' angganna to nakuasai ponggawana setang annu nasolaan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kamimo ussa'bii angganna mangka napogau' illalan lembangna to Yahudi anna dio Yerusalem. Anna mangka napatei tau, iamo napasok lako kayu pantokesan, ");
INSERT INTO mqjNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","sapo' katallungngallona napatuo sule Puang Allata'alla anna pakawananni lako ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tae' napakawanan lako angganna tau, sapo' angga lako kami angganna sa'binna to mangka napilei Puang Allata'alla. Iamo to ummande sola Puang Yesus mangkanna tuo sule dio mai alla'na to mate. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Anu' mangkamokan nasua umpalanda' Kareba Kadoresan anna la mendadi sa'bi lako angganna tau kumua: Puang Yesusmo to mangka naturo Puang Allata'alla la mendadi To Ma'bisaranna rupa tau, to tuo anna to mate. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Puang Yesusmo duka' napatu kadanna angganna nabi kumua: ‘Benna-benna ummoreanni la digarri'i kasalaanna ummolai kakuasaanna.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Marassampi mantula' Petrus, anna turummo Penawa Masero umpentamai angganna to umperangngii tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Angganna to Yahudi to mangngoreammo, to nasolaan Petrus dio mai Yope, mangnga-mangnga asan ummita tau senga' salianna to Yahudi mala duka' napatamai Penawa Maserona Puang Allata'alla, ");
INSERT INTO mqjNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","annu narangngimi mantula' umpake ma'rupa-rupa basa memangnga-mangnga anna umpudi umpomatande Puang Allata'alla. Ma'kadami Petrus nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Inde mai taue natamai asammi Penawa Masero susikia', dadi ta'mo dengan tau la undapaii ke ditedokmi wai.” ");
INSERT INTO mqjNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nasuami Petrus ditedok illalan sanganna Puang Yesus Kristus. Mangkaii, napelaumi kenamala torropa Petrus pira-pirangngallo sola. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Urrangngimi duka' kareba angganna rasul sola to mangngorean dio lembangna Yudea kumua budami tau senga' salianna to Yahudi untarima battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iamo nangei napasalamo to Yahudi to mangngoreammo Petrus anna sae lako Yerusalem, ");
INSERT INTO mqjNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","nakua: “Maakari ammu tama banuanna tau senga' salianna to Yahudi lambisan ummandeko sola?” ");
INSERT INTO mqjNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Naparanduk pole' Petrus ummulelean aka mangka dadi mengkalao dio pa'parandukanna, nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Marassanna' ma'sambayang dio Yope, tokke'mokkao taman. Kuitami dengan aka susi sampin kallumbang disangke' appa' katetukna, dilolloran yao mai langi' tiranduk dio tingngayoku. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kupengka'da'imi kupolalan ummita ma'rupa-rupa olo'-olo' ma'lentek appa', olo'-olo' malaira, olo'-olo' sumasa', anna ma'rupa-rupa dassi. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kurangngimi kamara nakua: ‘O Petrus, ga'gelako, ammu tunui ammu andei.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Sapo' kutimba' kukua: ‘O Puang, tae' sigali-gali mala, aka pempon dadingku ta'pa dengan leleanna kupatama sadangku andean pemali diande.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma'kada pole omi inde kamara yao mai langi'e nakua: ‘Dau angga' pemalii andean tae' napemalii Puang Allata'alla diande.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Pentallun te susie anna mane tiangka' asan sule langngan langi'. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Attu iatoo saemi tallu tau dio banua kingei torro. Inde taue disua dio mai Kaisarea sae untambaina'. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kurangngimi kamara nakua: ‘Dau pomabanda' penawammu lao sola.’ Inde annan siulu'tae kusolaan lako banuanna Kornelius. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Natulasammokan umba nakua mesa malaeka' tokke' ke'de' illalan banuanna anna ma'kada lako nakua: ‘Suai tau lako Yope untambai mesa tau disanga Simon sidikuan Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Annu la natulasangkoa' kareba la umpasalama'ko sola angganna tau illalan banuammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kuparandukna mantula' turummi Penawa Masero umpentamai asan inde taue susi dadi lako kaleta yolona. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tappa kukilalaimi tula'na Puang Yesus nakua: ‘Wai ia napake mantedok Yohanes, sapo' Penawa Masero ikoa' la ditedokangko.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dadi, tae' dengan lalangku la undapai Puang Allata'alla kela umpebeenni Penawa Maserona lako tau senga' salianna to Yahudi susi anta mane ummoreanna' Puang Yesus Kristus yolona.” ");
INSERT INTO mqjNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tappana urrangngi tula'na Petrus mattan asan pole' penawanna anna umpakasalle Puang Allata'alla nakua: “Napabeai duka' Puang Allata'alla tau senga' salianna to Yahudi mengkatoba' napolalan ullolongan katuoan sae lako-lakona.” ");
INSERT INTO mqjNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mangkanna dipatei Stefanus kendekmi pandarraan napolalan tisembu' angganna to mangngorean; dengan lu lako Fenisia, lako Siprus, anna dengan lu lako Antiokhia. Tontong liu umpalanda' Kareba Kadoresan sapo' anggami lako to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Sapo' inde mai to mangngoreanne dengan duka' to lu dio mai Siprus anna Kirene sae lako Antiokhia umpalanda' Kareba Kadoresan untetetteran Puang Yesus lako tau senga' salianna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tontong liu nasolaan Puang Allata'alla napolalan tuttuan buda tau mangngorean anna unturu' Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Napelele duka' to mangngorean dio Yerusalem kadadian dio Antiokhia, napolalan ussuamo Barnabas lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Inde Barnabas-e mesa to malolo anna to nakuasai Penawa Masero anna to lantuk mangngorean. Saei lako dore'mi ummita tamba'na Puang Allata'alla lako to dio Antiokhia. Napakari'di'mi kenamala tontong liu mentoe manda' mengnganti matoto' illalan kapangngoreananna lako Puang Yesus. Tuttuan budami tau mangngorean langngan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mangkaii, lu lakomi Tarsus Barnabas umpeang Saulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Silambi'i, nasolaammi sae dio Antiokhia. Torromi dio Antiokhia sataun anna sima'rempun sola angganna to mangngorean anna umpa'guru tau kamban. Diomo te Antiokhiae nangei bunga'-bunga'na to mangngorean disangai “to Sarani”. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Attu iatoo sae dio Antiokhia pira-pira nabi lu dio mai Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Dengan mesa disanga Agabus nakuasai Penawa Masero napolalan ma'kada nakua: “La kendek karorian illalan lili'na kaparentaanna Roma.” Kara-kara iatoo dadi tongan attunna Klaudius mendadi tomaraya. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Iamo too anna ummalamo kada situru' to mangngorean la urrempun doi' situru' pa'belanna la napopebaa lako siulu'na to mangngorean dio Yudea. ");
INSERT INTO mqjNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Umpalako tongammi kasiturusanna napolalan tirempun doi'. Nabengammi Barnabas sola Saulus la umpalanda' lako perepi'na to mangngorean dio Yudea. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Attu iatoo naparandukmi ungkarra'i pira-pira to mangngorean tomaraya Herodes. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Susinna umpopepatei Yakobus sirondongna Yohanes dibatta pa'dang. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tappana naissanan tomaraya Herodes kumua dore' to Yahudi ummitai pa'palakona, ussua pole omi tau umpealai Petrus. Attu iatoo allo kamai disanga Roti Tae' Diboloi Ragi. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dialai Petrus, ditarungkummi nadagai pole sapulo annan tantara sibala'-bala' sanda siappa'. Annu la diparessa dio tingngayona tau kamban ke lessu'mi Allo Paskah. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ditarungkummi Petrus, sapo' tontong liu napa'sambayangan to mangngorean langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","La naparessami Herodes dio tingngyona tau kamban Petrus dikua makale'. Bongii, mamma'mi Petrus napaillan alla' dua tantara dipungo rante bassi patomali limanna. Dengampi tantara daga dio sa'de ba'ba tarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tokke'mi ke'de' mesa malaeka'na Puang Allata'alla dio sa'dena Petrus pangngarrang illalan tarungkun. Untuyong-tuyongmi Petrus anna ma'kada nakua: “Sirra'ko millik.” Lappa' siami rante dio limanna Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nakua pole omo inde malaeka'e: “Pa'beke'ko ammu pake palopakmu.” Ma'beke'mi Petrus anna ma'palopak. Nakua pole omo: “Pakei bayu rui'mu ammu ula'na'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ummula'mi malaeka' Petrus suun illalan mai tarungkun, sapo tae' naissanan kumua dadi tongan inde pa'kuanna malaeka'e annu nasanga mangngimpi. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ullewanni angngenanna to daga bunga'na anna kapenduanna, ullambi'mi ba'ba bassi untutu'i lalan lu tama tondok. Tokke'mi titungka' kalena napolalan naola Petrus sola malaeka' suun illalan mai tarungkun anna le'ba ummundu' lalan. Tappa umpa'deammi kalena inde malaeka'e. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kilalai Petrus mane ma'kadari nakua: “Mane kuissanarri pole' temo kumua Puang Allata'alla ussua malaeka'na sae ullappasanna' dio mai kakuasaanna Herodes anna pa'kua penawanna to Yahudi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mangkai ma'pikki' sappai' mengkalaomi lako banuanna Maria indona Yohanes. Inde Yohanes-e sidisangai duka' Markus. Buda tau ma'rempun dio ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Undede'mi ba'ba bala Petrus, saemi mesa sabua' baine disanga Rode la umpetua'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tappa ummissanan kamaranna Petrus, sapo ta'pa untungka'i ba'ba anna le'bamo kumondong tama banua natumang kadoresanna anna pokadai kumua sae Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nakuamo to illalan banua: “Ta'mo tontong penawammu.” Sapo' nakua liu duka' tonganna sae Petrus. Nakuamo to illalan banua: “Malaeka'na muita.” ");
INSERT INTO mqjNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Menge liupi undedek ba'ba Petrus anna sasaeammo solana untungka'i. Mangnga-mangnga asammi ummita Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ummangka'mi limanna Petrus umpakamma' solana anna mane tetteranni umba nakua suun illalan mai tarungkun natette Puang Allata'alla. Untampakkimi tula'na Petrus nakua, “Tetteranni kadadian iatee lako Yakobus sola lako angganna sa'do'doranta.” Mangkai mantula' mengkalaomi lako angngenan senga'. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Masiangngii, karambami tantara to daga dio pa'tarungkunan anna pusa' umpikki'i kumua battu aka dadi lako kalena Petrus. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ussuami tau tomaraya Herodes umpeang Petrus sapo' ta'mo dengan nalambi'. Diparessa simesa-mesami inde to dagae anna mane pesuai Herodes dibaa lao dipatei. Mangkai too mengkalaomi Herodes dio Yudea lu lako Kaisarea anna torro dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Attu iatoo keara' sigalimi tomaraya Herodes lako to Tirus anna to Sidon. Inde dua tondokke moika anna bassi tae' nakala' kaparentaanna tomaraya Herodes sapo' kammandeanna lu dio asan mai kaparentaanna Herodes. Napolalan ma'mesa anna ussua tau lao mengngolo lako tomaraya. Umpeangmi lalan inde to disuae anna usse'dek Blastus kapalana to mengkarang illalan banuanna tomaraya anna malara lao lako tomaraya anna pelauanni kenamala dengan kasikalinoan lako inde dua tondokke. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Inde anna lambi'mi allo pa'temponae umpakemi pakean tomarayanna Herodes anna ummokko' yao okkosan kamatandeanna anna mane mantula' lako tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Marassanni mantula' tomaraya sipealo'-alosammi tau kamban umpakasallei nakua: “Itin kamarao, kamaranna dewata tangngia kamaranna ma'rupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tappa nalambi' siami perambinna Puang Allata'alla ummolai malaeka'na aka tae' umpakasalle Puang Allata'alla, iamo nangei masaki napolalan ollisan lambisan bonno'. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Budami tau urrangngi battakadanna Puang Allata'alla napolalan tuttuan kerangngan to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mangkanna pengkaranganna dio Yerusalem, ma'pasulemi Barnabas sola Saulus lako Antiokhia anna ussolaan Yohanes battu' dikua Markus. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Attu iatoo dengan pira-pira nabi anna tuangguru dio Antiokhia, iamo Barnabas, Simeon sidikuan To' Lotong, Lukius (to Kirene), anna Menahem to dipasitaranak tomaraya Herodes, anna Saulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pissan attu anna marassan ma'sambayang langngan Puang Allata'alla sola ma'puasa, ma'kadami Penawa Masero lako nakua: “Palao senga'i Barnabas anna Saulus annu la ungkarang karangan mangka kupatantuanni.” ");
INSERT INTO mqjNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mangkai ma'puasa anna ma'sambayang umballa'imi pala' inde to duae anna mane pabeai le'ba. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Situru' pesuanna Penawa Masero mengkalaomi Barnabas anna Saulus rokko Seleukia anna mane tarru' lako libukan Siprus ma'kappala'. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ussolammi Yohanes la umpamoloii. Saei lako tondok Salamis umpalanda'mi battakadanna Puang Allata'alla illalan pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ulleleammi tondok illalan inde libukanne sae lako Pafos, napolalan silambi' mesa to Yahudi disanga Baryesus mesa to ma'issan-issan anna to ussanga kalena nabi. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Inde Baryesus-e sisola leen Sergius Paulus, to keaka' anna to ma'parenta illalan inde libukanne. Untambaimi Barnabas sola Saulus inde to ma'parentae annu morai la umperangngii battakadanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Sapo' inde to ma'issan-issanne (sinasangai duka' tau Elimas) ullammai tula'na Barnabas sola Saulus annu nakua indana mangngorean Sergius Paulus lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sapo' nakuasai Penawa Masero Saulus sidikuaan duka' Paulus anna unnennengngi Baryesus ");
INSERT INTO mqjNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","anna mane ma'kada lako nakua: “Anaknako ponggawana setang. Anggami ma'tengko illalan penawammu sola angganna kakadakean la umbali kamapiaan. Ta' liupokoka la sonto ussengkosan lalan malolona Puang Allata'alla? ");
INSERT INTO mqjNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Temo la napalambi'imoko perambinna Puang Allata'alla. La nabutaiko, napolalan la pira-pirangngalloko tae' ummita mata allo.” Buta siami inde taue anna kasapu-sapu umpeang tau la untettei. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tappana ummita kadadian iatoo, mangngorean siami lako Puang Yesus inde to ma'parentae annu mangnga-mangnga urrangngi pepa'guruan untetteran Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mengkalaomi Paulus umpellei Pafos sola solana anna ma'kappala' sae lako Perga dio lembangna Pamfilia. Sapo' ma'pasule ia Yohanes dio tondok iatoo anna lu lako Yerusalem untampe solana. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mengkalao dio Perga umpatarru'mi penonosanna sae lako Antiokhia dio lembangna Pisidia. Nalambi'i allo katorroan tamami banua pa'sambayanganna to Yahudi anna ma'loko. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mangkai dibaca battakadanna Puang Allata'alla illalan mai Sura'na Musa anna illalan mai sura'na nabi, ussuami tau perepi' illalan pa'sambayangan umpellambi'i Paulus sola solana anna kuanni: “Ianna dengangkoa' ade' la umpalanda' pepakatoto' lako inde mai taue, malami mupalanda' temo.” ");
INSERT INTO mqjNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ke'de' siami Paulus anna ummangka' limanna umpakamma' tau kamban anna mane ma'kada nakua: “O to Israel anna anggammua' to mengkarea' langngan Puang Allata'alla, perangngi manappaia' tula'ku! ");
INSERT INTO mqjNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Puang Allata'alla to tapenombai angganta to Israel mangka umpile neneta sola napakembea' anna torro to messaepa dio lembangna Mesir. Anna mane tettei ummolai kakuasaanna suun illalan mai Mesir. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Appa' tapulo taunna naola sa'bara' Puang Allata'alla ummita panggauanna neneta dio padang alla'. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mangkai untallanni pitu kaparentaan dio lembangna Kanaan, untawa-tawami litak Puang Allata'alla dio la napomana' neneta. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Angganna kara-kara iatoo dadi illalan umbai appa' ratu' lima pulo taunna. Mangkai ditawa litak naangkasammi pira-pira pa'bisara aluk Puang Allata'alla sisonda-sonda sae lako attunna nabi Samuel. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Anna mane umpelau mesa tomaraya langngan Puang Allata'alla napolalan ummangka' tomaraya Saul anakna Kish peampoanna Benyamin, ma'parenta appa' tapulo taunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mangkai ummalai Saul Puang Allata'alla ummangka' pole omi Daud mendadi tomaraya. Nakua Puang Allata'alla untula' Daud: ‘Kulambi' pole' Daud anakna Isai to la umpomasannang penawangku anna to la umpalako pa'kuangku.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Situru' pa'dandinna ummangka'mi mesa peampoanna Daud, iamo Puang Yesus, la umpasalama' to Israel. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ta'pa umparanduk pengkaranganna Puang Yesus anna pa'peassakammi Yohanes lako angganna to Israel nakua: ‘Pengkatoba'koa' ammu ditedok.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","La suppikki pengkaranganna Yohanes nakuamo: ‘Umbai musangana' To nabassei bayu-bayu Puang Allata'alla. Tangngia, la windi ia sae, angga pekapu' palopakna la kubukaianni anna tae'na' la sipato'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Mentu'ko siulu'ku peampoanna Abraham anna angganna to mengkarea' langngan Puang Allata'alla, dipalambi'imikia' kareba kasalamasan. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aka angganna tau dio Yerusalem sola angganna perepi'na tae' ummissanan Puang Yesus kumua iamo To nabassei bayu-bayu Puang Allata'alla. Tae' toi umpekalembasan tula'na nabi sidibaca liu ke allo katorroan, napolalan ummala kada situru' umpopepatei Puang Yesus la naola ungganna'i tula'na nabi. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Anna moi tae' dengan lalan naita la naola umpateii nenne' napelau lako Pilatus kumua la dipatei. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mangkai ungganna'i angganna pangnguki' illalan Buku Masero untetteran Puang Yesus, napaturummi batang rabukna yao mai kayu pantokesan anna patamai liang. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Sapo' napatuo sule Puang Allata'alla dio mai alla'na to mate, ");
INSERT INTO mqjNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","anna pira-pirangngallopa naola siumpa'paitaan kalena lako angganna to unturu'i mengkalao dio Galilea sae lako Yerusalem. Inde to unturu'ie iamo mendadi sa'binna lako to Israel temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Dadi kipokadangkoa' temo Kareba Kadoresan: Pa'dandianna Puang Allata'alla lako neneta ");
INSERT INTO mqjNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","naganna'imi lako kita peampoanna, annu ummangka'mi Puang Yesus la umpasalama'ki'. Annu dengan battakadanna Puang Allata'alla tiuki' illalan sura' Pampudian kaduanna nakua: ‘Ikomo Anakku; mengkalao allo temo makalesomi kumua Kaomo Ambemu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Mangkami napatuo sule Puang Allata'alla dio mai alla'na to mate anna ta'mo la napabeai ummolai pole kamatean, situru' battakadanna nakua: ‘Pa'dandingku lako Daud masero anna mala diorean, la kuganna'imi lako kalemu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Iamo nangei ma'kada Daud illalan Pampudian senga' nakua: ‘Tae' la mupabeai batang kalena To Maseromu la puru'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Sapo' mangkanna umpalako pa'kuanna Puang Allata'alla, bonno'mi Daud anna dilamun sola nenena iamo nangei puru'mo batang kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Sapo' tae' ia susi Puang Yesus to mangka napatuo sule Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Dadi parallua' mupengngissananni mentu'ko siulu' kumua: angga ummmolai Puang Yesus nangei dengan kareba kagarrisanna kasalaan dipalanda' lako kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Annu parenta napa'pa'guruan Musa tae' nabela umpa'dei kasalaan, sapo' benna-benna ummorean Puang Yesus la dipa'dei angganna kasalaanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iamo too la matangkingkoa' indana dadi lakomo kalemu kadanna nabi illalan sura'na nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Petua'ia' anggammu to ma'telle. La kupamangnga-mangngakoa' mupolalan la ditallanni annu kupogau'mi illalan lino temo mesa kara-kara tae' la muorean moi la dengan tau umpokadangkoa'.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Inde anna suummo Barnabas sola Paulus illalan mai banua pa'sambayanganne napelaumi tau kamban kenamala natetteran pole ke allo katorroan la sae. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Soro'i ma'sambayang budami to Yahudi anna to ma'aluk Yahudi to mengkarea' langngan Puang Allata'alla unturu' Paulus sola Barnabas napolalan napakari'di' kumua kenamala tontong liu mentoe manda' lako pa'kamasena Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nalambi'i allo katorroan, kamala sae asammi issinna tondok ma'rempun illalan banua pa'sambayangan la umperangngii battakadanna Puang Allata'alla napalanda' Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sapo' mangungngu' penawa to Yahudi ummita tau buda napolalan untelle Paulus anna lammai tula'na. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Sapo' tuttuan barani Paulus sola Barnabas ma'kada nakua: “Innang ikoa' iko yolo dipalambi'i battakadanna Puang Allata'alla, sapo' mutumpu pala'a'. Dadi iko siamoa' ummangga' kalemu tae' sipato' untarima katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Annu nakua parentana Puang Allata'alla lako kaleki: ‘Mangkako kupile la mendadi ballo lako angganna tau senga' salianna to Yahudi ammu malara umpalanda' kareba kasalamasan sae lako lili'na lino.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tappana urrangngi tula'na Paulus dore' asan tau senga' salianna to Yahudi anna umpakasalle Puang Allata'alla ura'na battakadanna. Mangngorean asammi lako Puang Yesus angganna to mangka napile Puang Allata'alla la untarima katuoan sae lako-lakona. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Napolalan silele tau urrangngi battakadanna Puang Allata'alla illalan lili'na lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Sapo' inde to Yahudie lao urrasi angganna to kamai illalan tondok iatoo sola baine to keangga' to mengkarea' langngan Puang Allata'alla, napolalan undarra Paulus sola Barnabas anna suai umpellei lembang iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Untambakkimi soyok dio lentekna Paulus sola Barnabas annu la mendadi tanda lako to untumpu pala'i pepa'guruanna anna mane le'ba' lako Ikonium. ");
INSERT INTO mqjNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Siayun asammi kadoresan to mangngorean dio Antiokhia anna nakuasai Penawa Masero. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kara-kara dadi dio Antiokhia dadi duka' dio Ikonium. Tamami pa'sambayanganna to Yahudi Paulus sola Barnabas anna ma'pa'guru untetteran Puang Yesus napolalan buda to Yahudi anna tau senga' salianna to Yahudi mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sapo' inde mai to Yahudi to moka mangngoreanne urrasi tau senga' salianna to Yahudi anna malara ungkabassi to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Iamo too anna masae-saemo torro Paulus sola Barnabas dio, anna sitonda kabaranian untetteran Puang Yesus. Nabengammi kakuasaan Puang Allata'alla umpadadi ma'rupa-rupa tanda anna tanda memangnga-mangnga, la naola umpakawananni kumua angganna kareba untetteran pa'kamasena lako ma'rupa tau, tonganna asan. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Sapo' sipekka-pekka tau illalan inde tondokke napolalan tipa'dua, dengan unturu' to Yahudi anna dengan unturu' rasul. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ma'mesami pira-pira to Yahudi anna tau senga' salianna to Yahudi sola perepi'na napolalan ummala kada situru' la undarra inde dua rasul-e anna leba'i batu. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Sapo' naissanan inde dua rasul-e, napolalan ummalai kalena lako lembangna Likaonia anna ullelean pira-pira tondok susinna Listra anna Derbe. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Iamo te nangei umpalanda' Kareba Kadoresanne. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Dio Listra dengan mesa muane ta'pa dengan leleanna menono' aka balimbingan mengkalao dio mai dadinna. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Inde taue ma'loko umperangngii tula'na Paulus. Nanenne'imi Paulus napolalan naissanan kumua dengan kapangngoreananna, anna sipato' dipomalapu'. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Napemanduimi ma'kada Paulus nakua: “Ke'de'moko!” Kumalintayong siami ke'de' anna menono' leen. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tappana naita tau buda kara-kara napogau' Paulus, sipealo'-alosan siami illalan basana to Likaonia nakua: “Turun tongammi dewata tama lino merrupa tau.” ");
INSERT INTO mqjNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Napolalan ussangai Barnabas dewata Zeus anna Paulus nasangai dewata Hermes annu ia simantula'. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Saemi imam dewata Zeus dio ba'ba tama tondok lu dio mai pa'sambayanganna dio salian tondok, umbaa pira-pira saping laki napamanikki bunga-bunga la natunu memala' sola tau kamban lako rasul. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sapo' tappana narangngi Paulus sola Barnabas aka la napogau' tau, kadake siami nasa'ding napolalan ussesse' pakeanna anna kumondong tama alla'-alla'na tau kamban anna mealo'-alo' nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Maakari ammu ma'gau' susia'i? Rupa tau beasakan duka', susi siamikia'! Sapo' saekan inde la umpalanda' Kareba Kadoresan lako kalemua' ammu malara untampe angganna dewata takeangga'. Sapo' la mengngolo langngangkoa' dewata tuo, iamo Puang Allata'alla to menggaraganna langi' anna lino sola tasik anna angganna issinna. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yolona, napabeai Puang Allata'alla ma'rupa tau umpogau' pa'kua penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Sapo' tontong liu umpakawanan kalena ummolai ma'rupa-rupa kamapiaan lako ma'rupa tau susinna: umpasae liu uran yao mai langi'; umpakendek pa'taunan; nabeen liukoa' nande anna kamasannangan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sapo' moi anna susimo te tula'na dua rasul-e nenne' kamala tae' nabela undapai tau kamban umpalako pantunuan la napopemala' lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tapakala sae pira-pira to Yahudi lu dio mai Antiokhia dio Pisidia anna dio mai Ikonium, usse'dek inde tau kambanne, lambisan ia naturu'. Napolalan ussileba'-leba'i batu Paulus anna mane rui'i lako salian tondok annu nasanga bonno'mi. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sapo' inde anna talimbungmi to mangngoreanne, membangummi sule anna le'ba tama tondok. Masiangna mengkalaomi lako Derbe sola Barnabas. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Saei lako Derbe Paulus sola Barnabas umpalanda' omi Kareba Kadoresan napolalan buda tau mangngorean lako Puang Yesus. Mangkaii, ma'pasulemi lako Listra le'ba lako Ikonium anna mane tarru' lako Antiokhia dio Pisidia. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Umpakatoto'mi kapangngoreananna angganna to unturu' Puang Yesus illalan inde tallu tondok naolae anna pakari'di'i nakua, “Innang la ussa'dingangki' ma'rupa-rupa kamaparrisan anta mane tama kaparentaanna Puang Allata'alla. Iamo too kenamala la tontong liu kapangngoreanammua' lako Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pantan ummangka'mi perepi' Paulus sola Barnabas lako simesa-mesa kombonganna to mangngorean. Ma'puasami anna ma'sambayang ussorong inde perepi'e rokko lisu pala'na Puang Yesus to naorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mangkaii, umpatarru'mi penonosanna ummola lako lembangna Pisidia sae lako lembangna Pamfilia. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Umpalanda'mi battakadanna Puang Allata'alla dio Perga anna mane tarru' rokko Atalia. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mengkalao diomi ma'kappala' sule lako Antiokhia, tondok nangei disorong lako pa'kamasena Puang Allata'alla la umpalako karangan mangkamo nakarang temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Saei lako Antiokhia urrempummi angganna to mangngorean anna untetteran kara-kara napogau' Puang Allata'alla ummolai pengkaranganna. Natula' toi duka' umba nakua Puang Allata'alla umbukaian lalan tau senga' salianna to Yahudi mangngorean langngan Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Torromi Paulus anna Barnabas dio Antiokhia masae-sae sola angganna to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Saemi dio Antiokhia pira-pira to Yahudi to mangngoreammo lako Puang Yesus lu dio mai Yudea, anna ma'pa'guru lako tau senga' salianna to Yahudi to mangngoreammo duka', nakua: “Ianna tae'koa' disunna' situru' kabeasaan napa'pa'guruan Musa, tae'koa' mala dipasalama'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sapo' marru nasassai Paulus sola Barnabas lambisan sipekka inde taue. Napolalan nasituru'-turu'i angganna to mangngorean ussua Paulus sola Barnabas anna pira-pira to mangngorean dio Antiokhia lao umpellambi'i rasul sola angganna perepi'na to mangngorean dio Yerusalem, anna malara umpa'mesai kara-kara iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Naanta'mi angganna to mangngorean dio Antiokhia sae lako salian tondok, anna mane le'ba ummola lako lembangna Fenisia anna lembangna Samaria. Ma'tetterammi lako to mangngorean dio pira-pira tondok naola kumua budami tau senga' salianna to Yahudi mangngorean lako Puang Yesus, napolalan dore' asan urrangngii. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Saei lako Yerusalem natarima manappami to mangngorean sola angganna rasul anna perepi'. Natulasammi kara-kara napogau' Puang Allata'alla ummolai pengkaranganna Paulus anna Barnabas. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Sapo' sae pira-pira to Farisi to mangngoreammo nakua: “Angganna tau senga' salianna to Yahudi to mangngoreammo lako Puang Yesus manggi' disunna' anna disua unturu' angganna pepa'guruanna Musa.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ma'mesami angganna rasul sola perepi' dio Yerusalem untula' kara-kara iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Masae-saei nasitimba'-timba'i, ke'de'mi Petrus anna ma'kada nakua: “Mentu'ko siulu'ku, muissanammia' kumua mangkamo' napile Puang Allata'alla illalan mai alla'-alla'mua' yolona la umpalanda' Kareba Kadoresan lako tau senga' salianna to Yahudi anna rangngii napolalan mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Annu mangkami napakawanan Puang Allata'alla to ullosa penawanna ma'rupa tau kumua untarima duka' tau senga' salianna to Yahudi ummolai Penawa Maserona napaturun lako tau iatoo susikia'. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Anna tae'kia' naissan la napaleang, susi kita to Yahudi tenni tau senga' salianna to Yahudi, annu naseroianni duka' penawanna ura'na kapangngoreananna. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ianna susi too, maakaria' ammu la ussandak-sandak Puang Allata'alla? Maakaria' ammu morai la umpapassai passanan mabanda' lako to mangngorean? Annu inde passananne mengkalao dio mai neneta sae lako kita tae' tabela tapalako. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sapo' taoreanna' kumua: Angga ummolai pa'kamasena Puang Yesus tangei mala salama', susi siami duka' tau senga' salianna to Yahudi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mengkamma' asammi angganna to dio reen anna umperangngii Paulus sola Barnabas untetteran ma'rupa-rupa tanda anna tanda memangnga-mangnga napadadi Puang Allata'alla illalan alla'-alla'na tau senga' salianna to Yahudi ummolai pengkaranganna duai. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mangkai mantula' Paulus sola Barnabas, ma'kadami duka' Yakobus nakua: “Mentu'ko sa'do'dorangku, perangngia' tula'ku: ");
INSERT INTO mqjNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Mangkami natetteran Simon Petrus umba nakua pa'parandukanna Puang Allata'alla umpakawanan pa'kamasena lako tau senga' salianna to Yahudi, iamo napile illalan mai alla'-alla'na to la mendadi petauanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kara-kara iatoo siundu' battakadanna Puang Allata'alla mangka nauki' nabi nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Dako' la saena' umpake'de' sule banuanna Daud iato mangka roppokko, anna angganna tala kayunna la kupake'de' matoto' sule. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Anna malara angganna tau senga' la tinanda lako Puang Allata'alla, iamo angganna tau senga' salianna to Yahudi to mangka kutambai la mendadi petauangku. Susimi te kadanna Puang Allata'allae to umpadadi angganna kara-kara iatoo ");
INSERT INTO mqjNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","to mangka umpa'peissananni mengkalao dio mai.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dadi situru' pikki'ku, tae'kia' mala ussussai tau senga' salianna to Yahudi to la mengngolomo langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sapo' la ummuki'kia' sura' lako anna malara tae' ummande andean mangka dipopemala' lako dewata senga', tae' la ullullu' pa'bannetauan, tae' mala ummande rara anna balena olo'-olo' mate ditekke. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Annu mengkalao dio mai sidibaca liu pepa'guruanna Musa ke allo katorroan illalan banua pa'sambayangan lako simesa-mesa tondok.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ummalami kada situru' angganna rasul sola perepi' anna angganna to mangngorean dio Yerusalem la umpile pira-pira tau illalan mai kombonganna to mangngorean la nasolaan Paulus anna Barnabas ma'pasule lako Antiokhia. Umpilemi Yudas sidisangai Barsabas anna Silas, bassi to diangga' illalan alla'-alla'na to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Dibengammi sura' nabaa. Issinna inde sura'e nakua: “Salama'ki, anggangki siulu'mua' susi rasul tenni perepi', matin anggammua' siulu'ki salianna to Yahudi itin Antiokhia, Siria, anna Kilikia. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kikarebami kumua dengan pira-pira solaki tokke' sae matin tae' kisua, anna umpalanda' pepa'guruanna napolalan selang penawammua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iamo kingei ussituru'-turu'i umpile dua tau to la ussolaan Barnabas anna Paulus to kikamasei; ");
INSERT INTO mqjNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","to umbotoran sunga'na untetteran sanganna Puang Yesus Kristus Dewatanta. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dadi kipasan polepi Yudas sola Silas la umpalanda' puduk pepasangki matin susi illalan inde sura'e. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ummalamokan kada situru' naparunduk Penawa Masero kumua tae'koa' la dipapassanni passanan mabanda', sapo' anggami parallunna la muturu' iamo: ");
INSERT INTO mqjNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tae'koa' mala ummande andean mangka dipopemala' lako dewata senga'; tae'koa' mala ummande rara anna balena olo'-olo' mate ditekke, ammu daua' ullullu' pa'bannetauan. Umpogau'mokoa' to kamapiaanno ke ta'mo mupogau' kara-kara iatoo. Padami te pepasangkie. Salama'ki matin.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mangkai dipatontong, mengkalaomi inde to disuae lako Antiokhia. Saei lako umpopa'mesami angganna to mangngorean dio anna beenni inde sura'e. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dore' asammi to mangngorean dio umbacai annu napakaranga issinna inde sura'e. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Budapi pepakaranga sola pepakatoto' napalanda' Yudas sola Silas lako to mangngorean annu inde dua taue innang nabi duka'. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Masae-saei dio Antiokhia Yudas anna Silas napabeaimi to mangngorean ma'pasule lako Yerusalem siayun kamasakkean. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sapo' naporaipia Silas torro. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Masae-saepi duka' Paulus anna Barnabas torro dio Antiokhia, anna ma'pa'guru sola umpalanda' battakadanna Puang Allata'alla untetteran Puang Yesus sola buda tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Masae-saei dio, nakuamo Paulus lako Barnabas: “Umbai la mapia ke laoki' ullelean sule siulu'ta lako tondok mangka tangei umpalanda' battakadanna Puang Allata'alla untetteran Puang Yesus, battu maakami.” ");
INSERT INTO mqjNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nasituru'imi Barnabas sapo' morai la ussolaan Yohanes sidikuan Markus. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Sapo' moka Paulus annu nasanga kadanna, tae' dadi ussolaan to mangka mepellei dio Pamfilia anna moka mesolaan mengkarang. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sipekkami Paulus anna Barnabas napolalan sisarak. Lu lakomia Siprus Barnabas sola Markus ma'kappala'. ");
INSERT INTO mqjNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Mengke'de' Paulus, Silas ia napile la nasolaan. Mangkai nasorong lako pa'kamasena Puang Allata'alla siulu'na to mangngorean dio Antiokhia mengkalaomi ");
INSERT INTO mqjNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ullelean tondok illalan lembangna Siria anna Kilikia umpakatoto' kapangngoreananna to mangngorean illalan simesa-mesa kombongan. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Umpatarru'mi penonosanna Paulus lako tondok Derbe anna Listra. Iamo nangei silambi' mesa to mangngoreammo disanga Timotius. To Yahudi indona anna to mangngoreammo mengke'de' ambena tangngia to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Inde Timotius-e napokada mapia asan to mangngorean dio Listra anna Ikonium. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Morai Paulus la ussolaan Timotius illalan penonosanna, iamo nangei napopesunna'mo anna malara naporai to Yahudi annu naissanan asan kumua tangngia to Yahudi ambena. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Illalan kapenonosanna ullelean tondok, Paulus sola Silas umpalanda' kada rapa'na rasul anna perepi' dio Yerusalem, anna malara naturu' mentu'na to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Susimi tee angganna kombonganna to mangngorean dipakatoto' kapangngoreananna napolalan samasae-saena sabuda-budanna to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lu lakomi lembangna Frigia anna Galatia Paulus sola Silas annu tae' napabeai Penawa Masero umpalanda' Kareba Kadoresan dio lembangna Asia. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ullambi'i katonanna lembangna Misia nasandakmi la ma'palutama lili'na Bitinia, sapo' tae' natangga' Penawa Maserona Puang Yesus, ");
INSERT INTO mqjNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","napolalan tarru' rokko Troas ummola lako lembangna Misia. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Bongii tokke'mi taman Paulus napolalan ummita mesa to Makedonia ke'de' dio tingngayona anna melau nakua: “Lambangko mai ammu sae umpamoloikan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mangkanna tee ma'patakkan siamokan la mengkalao lako Makedonia annu kiissanan kumua nasuamokan Puang Allata'alla la umpalanda' Kareba Kadoresan lako to Makedonia. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mengkalaokan dio Troas ma'kappala' ummola lako Samotrake, masiangna saemokan lako Neapolis. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mengkalao diomokan tee lu lako Filipi, mesa tondok maroa' illalan lembang bunga'na dilambi' dio lili'na Makedonia. Inde Filipie sinangei torro buda to messae dio mai Roma. Pira-pira bongikan torro dio tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nalambi'i allo katorroan suummokan illalan mai tondok, angki le'ba rokko randanan, kipolalan ullambi' angngenan sinangei ma'sambayang to Yahudi aka innang illalammi penawangki la dengan dio. Ma'lokomokan sola pira-pira baine dio angngenan iatoo angki sipantula'-tula'. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Saemi duka' ma'perangngi mesa baine disanga Lidia to lu dio mai tondok Tiatira. Inde bainee sima'baluk sampin mellolo pao rupanna, anna mesa duka' to menomba liu langngan Puang Allata'alla. Napomalesomi Puang Allata'alla tula'na Paulus lako Lidia napolalan napaillan tambuk. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mangkai ditedok Lidia sola angganna rapunna, nabawaimokan nakua: “Ianna mutonganammoa' kapangngoreanangku lako Puang Yesus, anta torro dioa' banua.” Nase'dek liumokan kipolalan ma'din. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dengan pissan attu inde angki lao lako angngenan sinangei ma'sambayang to Yahudie, silambi'mokan mesa baine, sabua' sima'ita-ita aka natamai setang napolalan napopallolongan angganna puangna. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Naturu' liumokan sola Paulus meoli-oli ummola lalan nakua: “Inde mai taue sabua'na asan Puang Allata'alla To Randan Matande, anu' iamo umpakarebaikoa' lalan kasalamasan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Inde anna pira-pirangngallomo naola ma'pateenne makaringngi'mi talinganna Paulus urrangngii napolalan menggirik anna ma'kada lako inde setangnge nakua: “Illalan sanganna Puang Yesus Kristus kusuako mallai illalan mai kalena itin baineo!” Tappa mallai siami inde setangnge. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Naitanna angganna puangna kumua pa'de pole' pallolonganna, umpealaimi Paulus sola Silas anna rui' sesse'i lako tingngayona to ma'parenta sitorro dio sa'de pasa'. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Saei lako tingngayona to ma'parenta, nakuamo: “Inde dua to Yahudie sae umpasisala-sala tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Annu umpa'pa'guruan kabeasaan tae' mala tatarima anna taturu' to Romakia'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Buda duka' tau sae la umbali Paulus anna Silas. Napesuaimi to ma'parenta ullossokkianni pakeanna anna mane tambak pusoi. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mangkai ditambak puso dipatamami tarungkun anna ussua mando' tarungkun undagai manappaii. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iamo nangei umpalutamai tangngana pa'tarungkunan mando' tarungkun anna mane sangkalai. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Umbai tangngai bongi ma'sambayangmi Paulus sola Silas anna menani umpudi Puang Allata'alla. Naperangngii asammi duka' angganna to ditarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tapakala tokke'mo dadi lino' kamai urruyong batu lentongna pa'tarungkunan napolalan titungka' asan ba'ba, anna lappa' rante bassinna angganna to ditarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Millikki mando' tarungkun, ummitami ba'ba titungka' napolalan umbonok pa'dangna la mentuyo annu nasanga le'ba asammi to ditarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Sapo' metamba Paulus nakua: “Dau sanggangngi kalemu annu inde asangkan!” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Umpelaumi ballo inde mando' tarungkunne anna kumondong tama lumalla'-malla' marea' anna malimuntu' dio tingngayona Paulus sola Silas. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Anna mane ummanta' Paulus sola Silas suun illalan mai tarungkun anna ma'kada lako nakua: “O tuang, aka la kupogau' angku malara salama'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Natimba' Paulus sola Silas nakua: “Oreangko Puang Yesus Kristus ammu malara salama' susi iko tenni angganna rapummu.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Umpalanda'mi battakadanna Puang Allata'alla untetteran Puang Yesus lako mando' tarungkun sola lako angganna tau illalan banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Bongi ia siamo tee anna umbawai Paulus sola Silas lao nabaseian balalanna anna mane umpebeen kalena ditedok sola rapunna. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mangkaii, nabawaimi lako banuanna anna to saei. Dore' asammi sarapui annu mangngoreammi lako Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Masiangngi, ussuami to sidio sa'dena to ma'parenta lao umpellambi'i mando' tarungkun anna kuanni: “Rappanammi ade' itin dua tauo.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Lao siami umpellambi'i Paulus inde mando' tarungkunne anna kuanni: “Nasuana' to ma'parenta urrappanangkoa'. Dadi suummokoa' ammu le'ba manappa.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Sapo' ma'kada Paulus lako mando' tarungkun sola to sidio sa'dena to ma'parenta nakua: “To Romakan tee, ta'pakan dengan dibisara angki tokke'mo ditambak puso dio tingngayona tau kamban angki mane ditarungkun. Temo, tokke'mokan la narappanan babang tae' naissanan tau. Tae' dengan leleanna la susi. Make sae asanni to ma'parenta anna melolo urrappanangkan illalan mai tarungkun.” ");
INSERT INTO mqjNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mengkalao siami to sidio sa'dena to ma'parenta umpalanda' kadanna Paulus lako to ma'parenta. Tappana naissanan kumua to Roma, marea' asan pole'. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Saemi umpellambi'i Paulus sola Silas anna ummakui kasalaanna lako. Nasolaammi suun anna pelaui kenamala umpellei tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Umpelleimi pa'tarungkunan anna lu lako banuanna Lidia. Saei lako silambi'mi to mangngorean dio, napakatanami anna mane umpellei tondok Filipi. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Umpatarru'mi kapenonosanna Paulus sola Silas ummola lako Amfipolis, le'ba' lako Apolonia anna mane sae lako Tesalonika. Dio tondok iatoo dengan pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tamami banua pa'sambayangan Paulus susi beasanna sinapogau'. Pentallun siruntun allo katorroan nangei umpokada anna ussitimbang-timbangngi Buku Masero Paulus sola tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Napomakalesomi sola natetteran manappa kumua innang la ussa'dingan kamaparrisan To nabassei bayu-bayu Puang Allata'alla lambisan dipatei anna la tuo sule dio mai alla'na to mate. Nakuamo: “Inde To nabassei bayu-bayu Puang Allata'allae, iamo Puang Yesus to kutetteran lako kalemua'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Dengan pira-pira to Yahudi to dio reen attu iatoo untongananni napolalan umpentappai Paulus sola Silas. Susi duka' buda to salianna to Yahudi to mengkarea' langngan Puang Allata'alla anna pira-pira baine keangga'. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Sapo' buda to Yahudi mangungngu' penawa napolalan urrempun to kadake sitama pasa' anna solanni lao umpakaramba tau illalan tondok. Napissannimi lu lako banuanna Yason umpeang Paulus sola Silas annu la nabaa lako tingngayona tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Sapo' tae' dengan nalambi', napolalan Yason sola pira-pira to mangngorean narui' sesse' lako to ma'parenta illalan tondok. Saei lako metamba-tambami nakua: “Saemi duka' inde tondokta to siumpabuttu kakadakean illaan lino, ");
INSERT INTO mqjNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","anna natarima manappa Yason torro dio banuanna. Tau iatee umbali atoranna kaparentaan Roma annu nakua dengan tomaraya senga' disanga Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pusa' asammi tau sola to kamai illalan tondok urrangngi tula'na inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dipelauimi doi' Yason sola solana aka' indana umpabuttu liu kamarukkaan. Mangkai nabaya' dirappanammi. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bongi ia siamo too nangei ussua Paulus sola Silas to mangngorean dio Tesalonika mengkalao lako Berea. Saei lako lu tamami pa'sambayanganna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","To Yahudi dio Berea tae' makarra' penawa susi to dio Tesalonika annu masannang penawanna untarima battakadanna Puang Allata'alla. Siumpelaya'i liumi Buku Masero ke allo la naola ummissananni kumua tongannaraka pepa'guruanna Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Buda to Yahudi ummorean Puang Yesus anna buda toi duka' to tangngia to Yahudi susi baine keangga' tenni muane. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Sapo naissananna to Yahudi dio Tesalonika kumua umpalanda' duka' battakadanna Puang Allata'alla Paulus dio Berea, laomi lako urrusoi tau buda napolalan selang penawanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tappa ussuami Paulus lako biring tasik to mangngorean dio Berea sapo torropia Silas sola Timotius. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ummanta'mi Paulus sae lako Atena inde to lao ussolannie. La sulei lako Berea, mepasammi Paulus lako Silas anna Timotius kumua kenamala ma'sirra' lao umpellambi'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Torromi Paulus dio Atena ummampai Silas sola Timotius. Mapa'di'mi penawanna ummita tau-tau sidipenombai samba lako tondok. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iamo nangei sipantula'-tula'mo to Yahudi Paulus illalan banua pa'sambayangan sola to salianna to Yahudi to mengkarea' langngan Puang Allata'alla, anna angganna to nasilambisan illalan pasa' ke allo. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Sitimba'mi duka' pira-pira tuangguru to unturu' pepa'guruanna Epikuros anna pepa'guruanna kombonganna Stoa, anna dengan ma'kada nakua: “Akamo la napokada itin to buda kada babangngo?” Dengammi duka' ungkuai: “Umbai to umpa'peassakan pepa'guruanna dewata tadiita rambu apinna.” Annu umpalanda' Kareba Kadoresan Paulus untetteran Puang Yesus anna katuoanna sule. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ussolammi Paulus lako kombonganna pa'bisara disanga Areopagus anna kuanni: “Malarika mupomakaleso lako kaleki pepa'guruan bakaru mangka mupalanda'? ");
INSERT INTO mqjNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Annu itin pepa'guruammuo senga'-senga' kirangngi, dadi moraikan la umpengngissananni kalembasanna.” ");
INSERT INTO mqjNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Angganna to Atena anna to messae dio sinadotaan umpatorro karanganna annu la umpokada battu umperangngii kara-kara bakaru.) ");
INSERT INTO mqjNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ke'de'mi Paulus illalan alla'-alla'na to ma'rempun dio Areopagus anna ma'kada nakua: “O anggammua' to Atena, kuita pa'palakomua' illalan angganna kara-kara barringkoa' siperambuan dewatammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Annu inde angku menono'-nono' illalan tondokmua' umpetua'-tua' angngenan kapemalasammua'e, ummitamo' mesa angngenan kapemalasan, dengan pangnguki' dio nakua: ‘Kapemalasan langngan dewata tadiissanan.’ Iamo te Dewata mupenombaia' tae' muissananne kupalanda' lako kalemua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Puang Allata'alla to mangka umpadadi lino anna issinna, iamo Dewatanna langi' anna lino, tae' la mala torro illalan banua pa'sambayangan panggaraganna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tae' toi manggi' nakandapa ma'rupa tau takuananta to tae' ganna' kaparalluanna. Annu Dewata iamo tee umpebeen penawa lako ma'rupa tau napolalan tuo anna umpebeen sangga' rupanna lako angganna tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Bunga'-bunga'na angga mesa tau, iamo nangei umpabuttu angganna rupa tau ummissii lino. Innang mangkami napatantu Puang Allata'alla attu katuoanna ma'rupa tau sola ungkatonanni angngenanna tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ia nangei umpatenni anna malara lao kakarang-karang ma'rupa tau umpeang Puang Allata'alla umba-umba aka anna mala nalambi', moika anna sitonganna tae'ki' sikambela Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Annu ummolai kakuasaanna malakia' tuo, malaki' membero leen, malaki' dio reen, susi sinapokadangkoa' to paissammu kumua: ‘Annu anaknakia' duka' te Puang Allata'allae.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Dadi ianna anaknakia' Puang Allata'alla, tae' la mala tapapada angga' Puang Allata'alla anna tau-tau bulawan, tau-tau pera', battu tau-tau batu, panggaraga situru' kamanaranganna ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yolona tae' umpatumangngi kasalaanna rupa tau Puang Allata'alla annu balan tanaissananna, sapo temo pole' umparentami angganna tau illalan lino mengkatoba'. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Annu mangkami umpatantu allo la nangei mesa to mangkamo napatantu la umbisara gau'na rupa tau illalan lino. Inde to mangka napatantue mangkami napakawanan lako ma'rupa tau ummolai katuoanna dio mai alla'na to mate.” ");
INSERT INTO mqjNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Tappana urrangngi battakada kumua dengan katuoanna sule to mate, dengammi pira-pira tau untellei, sapo' dengan duka' pira ungkuai: “Anna dengan polepa attu ammu tetteranan polekan itin kara-kara mutula'o.” ");
INSERT INTO mqjNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mengkalaomi Paulus umpellei inde kombonganne. ");
INSERT INTO mqjNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Sapo' dengan siami duka' pira-pira muane mengkoppa' lako Paulus anna ummorean Puang Yesus, susinna Dionisius mesa duka' pa'bisara alukna Areopagus. Anna dengampi mesa baine disanga Damaris anna pira-pirapa tau senga'. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mangkai too, mengkalaomi Paulus dio Atena lu lako Korintus. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Saei lako Korintus, silambi'mi mesa to Yahudi disanga Akwila to lu dio mai Pontus. Ta'pa masae saena dio mai Italia sola bainena disanga Priskila annu umpasuun parenta tomaraya Klaudius ussua angganna to Yahudi umpellei Roma. Lempangmi Paulus lako banuanna ");
INSERT INTO mqjNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","napolalan torro dio anna mengkarang sola annu susi karanganna siumpapia kemah. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sisipantula'-tula' liumi tau Paulus ke allo katorroan illalan pa'sambayanganna to Yahudi anna malara mangngorean to Yahudi sola to salianna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Saei Silas sola Timotius dio mai Makedonia, nasatutuimi Paulus umpalanda' Kareba Kadoresan anna uleleanni lako to Yahudi kumua Puang Yesusmo To nabassei bayu-bayu Puang Allata'alla ma'pasalama'. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Sapo nabali to Yahudi sola natelle, napolalan untambakki soyok dio mai pakeanna Paulus anna ma'kada lako nakua: “Ikomoa' umpassan kasalaammu, makayonakkao anna tae'na' kasalaan. Mengkalao temo la lu lakomo' tau senga' salianna to Yahudi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Suummi illalan mai banua pa'sambayanganna to Yahudi anna lu lako banuanna mesa to tangngia to Yahudi disanga Titius Yustus, to umpenombai duka' Puang Allata'alla. Inde banuae sitere siami banua pa'sambayangan. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sapo kapalana banua pa'sambayangan disanga Krispus sitonda rapunna ummorean Puang Yesus anna budapa to Korintus, to urrangngi pepa'guruanna Paulus mangngorean anna ditedok. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pissan attu bongi, taman Paulus napolalan ummita Puang Yesus sae umpa'kadaii nakua: “Dau marea'; dau torroanni umpalanda' Kareba Kadoresan. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Annu kusolaan liuko anna tae' dengan tau la umparuaiko kakadakean, annu la buda petauangku illalan inde tondokke.” ");
INSERT INTO mqjNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Torromi dio Paulus sataun anna annan bulanna umpa'pa'guruan battakadanna Puang Allata'alla illalan alla'-alla'na to ma'tondok. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Sapo' inde anna diangka' gubernur Galio dio Akhayae, ma'mesa pole' pira-pira to Yahudi umbali Paulus napolalan napealai anna baai lako tingngayona pa'bisara tondok. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Anna ma'kada nakua: “Inde taue umpa'guru sala tau menomba langngan Puang Allata'alla annu sisala issinna sura'na Musa.” ");
INSERT INTO mqjNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Sapo' tappana la naparanduk mantula' Paulus, ma'kadami Galio lako to Yahudi nakua: “O to Yahudi, ianna ullendara parenta, battu kakadakearraka mungeia' umparapa' inde taue, sipato' la kutarima. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Sapo' ianna anggara battakada, sangaraka, battu ullenda kabeasaanna to Yahudi, papura illalammia' alla'-alla'mu. Tangkao la urratta'i annu mokana' la umbisara kara-kara susi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Anna mane urrambai tau illalan mai angngenan sidingei ma'bisara. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Suunna illalan mai umpealaimi Sostenes kapala pa'sambayanganna to Yahudi anna limbuii nasidangguru'-guru'i dio luba'ba banua sidingei ma'bisara, sapo' tae' naaku nasaile Galio. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Masae-saepi torro Paulus dio Korintus anna mane ma'kappala' lako Siria sola Priskila anna Akwila umpellei to mangngorean dio. Inde anna ta'pa langngan kappala' dio Kengkreae ungkottiimi beluakna Paulus situru' ada'na to Yahudi aka ungganna'i samayanna langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Saei lako Efesus lu tamami pa'sambayanganna to Yahudi Paulus anna sipantula'-tula' to Yahudi. Napelaumi to Yahudi kenamala masae-sae torro dio. Sapo' moka Paulus napolalan ma'kada nakua: “Tangga'pa' le'ba', angku sae polemora ke nakuapa Dewata.” Mengkalaomi umpellei to Efesus, sapo' torromia Priskila anna Akwila dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Saei lako Kaisarea, lu lakomi Yerusalem umpessitai angganna to mangngorean anna mane tarru' lako Antiokhia. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Inde anna masae-saemo dioe, mengkalao omi ullelean tondok illalan lembangna Galatia anna Frigia umpakatoto' angganna to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Attu iatoo saemi mesa to Yahudi dio Efesus disanga Apolos to lu dio mai Aleksandria. Mesa duka' to pa'rurru kada anna to untarru' Buku Masero. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mangka toi dipa'guru manappa pepa'guruanna Puang Yesus. Sinapetonganni mantula' anna lumantang untetteran Puang Yesus sapo' angga pantedokanna Yohanes naissanan. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Naparandukmi ma'pa'guru sitonda kabaranian illaan pa'sambayanganna to Yahudi. Sapo' narangnginna Priskila sola Akwila, nabawaimi lako banuanna anna tetteranan manappai lalanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Mangkaii, moraimi Apolos la lao lako Akhaya, napolalan umpopebaa sura' to mangngorean dio Efesus lako to mangngorean dio anna malara untarima manappa Apolos. Kasaeanna Apolos lako marru keangga' illalan alla'-alla'na to mangngorean, to untarimamo Puang Yesus ura'na pa'kamasena Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Annu napetonganni umbali to Yahudi dio tingngayona tau buda, napolalan natalo kada annu naendekan illalan mai Buku Masero kumua Puang Yesusmo To nabassei bayu-bayu Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Diopi Korintus Apolos, suppikmi Paulus ullelean tondok illalan lembangna Frigia anna Galatia, napolalan sae lako Efesus. Ullambi'mi pira-pira to mangngorean dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Mekutanami Paulus nakua: “Untarimakoka Penawa Maseroa' inde ammu mane mangngoreanne?” Natimba' nakua: “Ta'pa dengan, annu sae lako ditula' kumua dengan Penawa Masero anna ta'pa dengan kirangngi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nakuamo Paulus: “Ianna susi too, pantedokan umbamo mangka ditedokangkoa'?” Natimba' nakua: “Pantedokanna Yohanes.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nakuamo Paulus: “Pantedokanna Yohanes iamo tanda pengkatobasan anna nakua kadanna lako tau kamban: ‘La ummoreangkoa' to la sae windingku,’ iamo Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tappana urrangngi tula' iatoo, ditedokmi ummolai sanganna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Marassanni naballa'i pala' Paulus natamaimi Penawa Masero napolalan mantula' ummoyong ma'rupa-rupa basa memangnga-mangnga anna umpalanda' battakada napaombo' Puang Allata'alla lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Inde taue umbai sapulo duai. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tallu bulan naola Paulus tama pa'sambayanganna to Yahudi anna barani mantula' lako to dio reen, sipantula'-tula' to Yahudi anna umpomakaleso kaparentaanna Puang Allata'alla lako anna malara naorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Sapo' dengan duka' pira-pira tau makarra' penawa. Moka mangngorean, lambisan untelle pepa'guruanna Puang Yesus illaan alla'-alla'na tau buda. Iamo nangei umpelleimo tau buda Paulus anna umbawai to mangngorean lako mesa banua sidingei kombong disanga Tiranus. Iamo pole' sinangei Paulus ke allo ma'pa'guru. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Dua taun naola Paulus mengkarang susi tee, napolalan angganna tau illalan lili'na Asia urrangngi battakadanna Puang Yesus, susi to Yahudi tenni to salianna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Puang Allata'alla umpadadi tanda memangnga-mangnga ummolai Paulus, ");
INSERT INTO mqjNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","napolalan buda tau siummala sapu'-sapu' battu sampin senga'raka mangkanna napake Paulus anna baai lako to masakinna, napolalan tappa malapu' anna dengan pira mallai setang illalan mai kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Attu iatoo dengan pira-pira to Yahudi sima'issan-issan ullelean tondok. Inde taue siurrambai setang illalan mai kalena tau. Susi duka' pitu to ma'sirondong, anakna mesa kapala imam to Yahudi disanga Skewa, nasandak duka' urrambai setang umpotendan sanganna Puang Yesus. Nakua lako inde setangnge: “Kurambaiko ummolai sanganna Yesus, to sinatula' Paulus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sapo' natimba' setang illalan mai kalena inde taue nakua: “Kuissanan Yesus sola Paulus, sapo' ikoa', bennarokoa' iko?” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Urropangngi siami to ma'sirondong inde to natamai setangnge anna ressu-ressui, lambisan le'ba sikakondong ma'kale-kale anna balala-lala kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kara-kara iatoo napekareba angganna tau dio Efesus, susi to Yahudi tenni salianna to Yahudi napolalan marea' asan tau. Iamo pole' nangei tuttuan dipakasalle sanganna Puang Yesus. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Attu iatoo buda to mane mangngorean sae ummakui angganna gau' kadakena dio tingngayona tau kamban. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Susi toi duka' lako angganna to sima'issan-issan, urrempun asan sura'na anna sumpunni dio tingngayona tau kamban. Umbai la dengan lima pulo sa'bu doi' pera' angga'na inde sura' disumpunnie. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Napolalan Kareba Kadoresan untetteran Puang Yesus titale' ambun illalan lembang iatoo anna tuttuan buda tau tigara' penawanna mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mangkanna kara-kara iatoo, la lu lakomi Yerusalem Paulus ummola lako Makedonia anna Akhaya, annu nakua: “Mangkana' lu lako Yerusalem, innang la laona' duka' lako Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ussuami dua to siumpamoloii disanga Timotius anna Erastus yolo lako Makedonia annu la torropi masae-sae dio Asia. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Umbai attu iamo tee nangei kendek kamarukkaan kamai dio Efesus ura'na pepa'guruanna Puang Yesus napalanda' Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Inde kamarukkaanne napakendek mesa tau disanga Demetrius pa'tampa pera', siumpapia banua-nua pera' susi tappa' angngenan kapemalasan lako dewata Artemis. Buda tau sinapake illalan pengkaranganna anna buda pallolonganna. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Urrempummi angganna solana pa'tampa pera' anna mentu'na to mengkarangna, anna ma'kada nakua: “Anggammua' sa'do'dorangku, tasa'dingammia' pada-pada umba susi kamasannanganta ura'na pengkaranganta annu buda pallolonganta. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Temo, taitamia' sola tarangngi umba nakua Paulus inde Efesus anna illalan lili'na Asia usse'dek anna umpapusa buda tau kumua angganna panggaraganna ma'rupa tau tangngia dewata. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Dadi tae' angga pengkaranganta la napetawai tau sapo banua kapemalasan duka' lako dewata Artemis la pa'de angga'na lambi' lako kalena dewata Artemis to napenombai to Asia anna sangkalebu lino, ta'mo la kadewataan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Urrangnginna tula'na Demetrius keara' asammi napolalan sipeoli-olian nakua: “Dipomatande sanganna Artemis, dewatanna to Efesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Turun tondok pole' tau anna sipa'silullusan lako banua pa'mesaan. Umpealaimi dua to Makedonia sinasolaan Paulus menono' disanga Gayus anna Aristarkhus, anna rui'i lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Morai Paulus la tama alla'-alla'na inde tau budae sapo' tae' natangga' to mangngorean. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pira-pira duka' to kamai illalan lembangna Asia sangkalamma'na Paulus, mepasan kumua dau anna lao tama angngenan pengkitaan. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Sipealo'-alosammi to ma'rempun illalan inde angngenanne, iamo natula' iamo annu rukkami tau anna buda tau tae' ummissanan ura'na nangei ma'rempun. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dengan mesa to Yahudi disanga Aleksander urrangngi tula'na pira-pira tau napolalan naissanan balayanna nangei turun tondok tau. Nabussummi solana lako tingngayona tau buda anna malara mantula'. Ummangka'mi limanna umpakamma' tau annu la mantula' usseroi kalena sola to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Sapo naissananna tau buda kumua to Yahudi, sipealo'-alosan omi umbai dua tettek nakua: “Dipomatande sanganna Artemis dewatanna to Efesus!” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Napolalan ke'de'mo guru tuli' illalan tondok umpakamma' tau buda anna ma'kada nakua: “O to Efesus, tae' dengan tau illalan lino tae' ummissananni kumua kitamoa' to Efesus to urrepi' manappa angngenan kapemalasan lako dewata Artemis to dipomatande anna to undagai tau-taunna, iato ronno' yao mai langi'o. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kara-kara iatee tae' diissan ditelang. Iamo too, la mattangkoa' ammu dau tokke' ma'palako buta. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Annu tokke'mokoa' umbaa sae inde dua taue, moika anna tae' dengan ungkadakei angngenan kapemalasanta, tae' toi dengan untelle dewatanta. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Dadi, ianna dengan kara-karana Demetrius sola to ma'tampana lako mesa tau, anna palulakoi angngenan pa'bisaraan annu dengan to ma'parenta la umparokkoi. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Sapo ianna dengan senga'na dio penawammua', mala dibisara illaan kombonganna tau buda pa'patantunna to ma'parenta. ");
INSERT INTO mqjNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Annu sirapangkia' to dio palimping temo annu malakia' ditanda' la umpabuttu kakadakean illalan tondok. Annu tae' dengan pengngandasanta la taola ummaloloan kaleta ura'na inde pa'rempunan marukkae.” ");
INSERT INTO mqjNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mangkai mantula' inde guru tuli'e ussuami lao angganna tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mattanni sule to Efesus, urrempummi to mangngorean Paulus anna pakatoto'i. Mangkai mantula', ussalama'mi angganna to mangngorean anna mane mengkalao lako Makedonia. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Saei lako, ulleleammi tondok illalan lembang iatoo napasiolaan umpakilala anna umpakatoto' to mangngorean, napolalan sae lako Yunani. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tallu bulanni dio Yunani moraimi Paulus la ma'kappala' lamban lian Siria. Sapo' napekareba Paulus kumua dengan pa'bunu' penawanna to Yahudi la umpateii, napolalan kalebu dio penawanna la ma'pasule ummola lako Makedonia. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dengan pira-pira tau ussolanni iamo Sopater anakna Pirus to Berea anna Aristarkhus anna Sekundus bassi to Tesalonika, anna Gayus to Derbe anna Timotius anna duapi solana bassi to Asia, disanga Tikhikus anna Trofimus. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Sapo' mengkalao asammia yolo ma'kappala' lako Troas annu la naampai diokan. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Lessu'i allo kamai disanga Roti Tae' Diboloi Ragi mane ma'kappala'rakan mengkalao dio Filipi. Limangngallokan ma'kappala' angki mane sae lako Troas, kipolalan silambi'mo solaki to yolomo sae lako. Pitungngallopakan torro dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Allo Sattu bongi, ma'mesamokan umpia'-piak roti. Mantula'mi Paulus sae lako tangnga bongi sola angganna to mangngorean dio Troas, annu moraimi la mengkalao makale'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Illalan inde banua kingeie, ma'mesa yaokan tanda langngan nangei buda ballo mian. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Dengan mesa anak muane disanga Eutikhus ma'loko yao sulewa'. Nataloimi matanna napolalan mamma' annu masae sigalimi mantula' Paulus napolalan metobang rokko, mengkalao yao katallu todo'na langngan. Naangka'mi tau sapo innang bonno'mi. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Turun siami Paulus umpellambi'i anna lumbangngi naraka' anna mane ma'kada nakua: “Daua' pomasussa penawammu annu ummambuk penawa sule.” ");
INSERT INTO mqjNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mangkaii, sulemi Paulus langngan banua anna umpiak-piak roti anna andei pada-pada. Mangkai ummande, mantula' pole omi Paulus lako to mangngorean sae lako nannari. Tibungka'i masiang, mengkalaomokan. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mengkalaomi duka' to ma'rempun sitonda kamasannangan ummanta' inde to metobang lako banuannae, aka tuoria sule. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mengkalaomokan yolo langngan kappala' la lu lako Asos. Situru' pa'kua penawanna Paulus la diopi anna mane langngan kappala' kingei annu la menono' ia lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Silambi'kan Paulus dio Asos kisolaammi langngan kappala', angki mane tarru' lako Metilene. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mengkalao dio Metilene menono' liumi kappala'ki, napolalan masiangngii untingngayomokan libukan disanga Khios. Masiang polei saemokan lako Samos, sangngallo polepakan ma'kappala' angki mane sae lako Miletus. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Annu situru' pa'bunu'-bunu' penawanna Paulus, ta'mo la lempang dio Efesus, indana masae sigali torro dio Asia annu ma'sirra' umba aka anna saemo lako Yerusalem anna mane lambi'i allo kamai iamo Pentakosta. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Diokan Miletus ussuami tau Paulus lako Efesus untambai angganna perepi' dio anna sae untammuii. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Saei, napantula'imi Paulus nakua: “Muissanammia' umba nakua katuoangku illalan alla'-alla'mua', mengkalao dio angku mane sae inde Asia. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ummampa'na' penawa anna sitonda wai mata umpengkarangan Dewata anna ussa'dinganna' ma'rupa-rupa kamasussaan. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Muissanan toia' kumua tae'na' malaya' untulasangko la ma'gunanna lako kalemua'. Kupa'guru manappakoa' susi dio tingngayona tau buda tenni illalan pa'rempunan lako banuammua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Umpalanda' liuna' pepakilala lako to Yahudi anna lako tau senga' salianna to Yahudi, anna malara mengkatoba' langngan Puang Allata'alla napolalan ummorean Puang Yesus Dewatanta. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Temo la lu lakomo' Yerusalem situru' pesuanna Penawa Masero, sapo' tae' kuissanan aka la dadi lako kaleku dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Anggami kuissanan kumua illalan simesa-mesa tondok mangkanna kuola sinapakawanan Penawa Masero lako kaleku kumua la didarrana' anna la ditarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Sapo ta'mokkao umpikki' sunga'ku moi sangkanuku malotongmo ke mala siai suppik manappa pengkarangan mangka napapassannianna' Puang Yesus, iamo la umpalanda' Kareba Kadoresan pa'kamasena Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Temo kuissanammi kumua anggammua' to mangka kupellambi'i kutetteranan kaparentaanna Puang Allata'alla, ta'mo' dengan la muita polea'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Iamo too kupokadangkoa' temo kumua yaona' tanarambui, diongna' tanato'doi ke dengangkoa' tae' ullolongan kasalamasan. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Annu tae'na' lembe untulasangkoa' angganna pa'kuanna Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Dadi, dagai manappakoa' kalemu anna angganna pa'kambi'mu annu ikomoa' to naponto bannangngi Penawa Masero la urrepi' kombonganna to mangngorean. Iamo too la ungkambi' manappakoa' kombonganna to mangngorean langngan Puang Allata'alla, to mangka naalli rara, iamo rarana Anakna. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Annu kuissanan kumua ianna le'bamo', la saemi tama alla'-alla'mua' to kadake urrenggang kombonganna to mangngorean sirapan aramau ussesseran pa'kambi'mua'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Anna la dengan duka' buttu illalan mai alla'-alla'mua' to ussewangan pepa'guruan sala la umpapusa to mangngorean napolalan naturu'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Iamo too kenamala matangkin tongan-tongangkoa' ammu pengkilalaii kumua tallu taun kuola tae' dengan torro, allo-bongi sitonda wai mata unnanna' simesa-mesakoa'. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Temo, kusorongkoa' rokko lisu pala'na Puang Allata'alla. La umpengnganda'koa' battakadanna Puang Allata'alla untetteranni pa'kamasena. Annu inde battakadannae malakoa' napakatoto' illalan kapangngoreanammu, anna la natandoikoa' tamba'na Puang Allata'alla mangka napatokaan angganna petauanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tae' dengan kendek illalan penawangku morai la natandoi pera' tau, battu bulawan, battu sampin. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Muissanan kumua simelolona' duka' mengkarang anna malara ganna' kaparalluangku sola kaparalluanna angganna to kusolaan. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mangkamokoa' kupaitai tandengan illalan mentu'na kara-kara umba la dipasusi mengkarang manappa, anta malara la umpamoloi to tanabela mengkarang. Anna la umpengnganda'kia' battakadanna Puang Yesus kumua: ‘Marru kerongko' ia to ma'petando anna la to ditandoi.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Mangkai mantula' Paulus, malimuntu' asammi anna ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Sitangi'-tangisammi anna mane urraka' Paulus naudung. ");
INSERT INTO mqjNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Rantang asammi buana, la'bi-la'binna annu dengan kadanna Paulus kumua ta'mo dengan la siita pole. Mangkai tee naanta'mi sae langngan kappala'. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Sisarakmokan perepi'na to Efesus, ma'kappala'mokan ma'maloloan lako Kos. Masiangngi saemokan lako Rodos angki mane tarru' lako Patara. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Saekan lako Patara dengan kappala' la mengkalao lako Fenisia. Langngammokan inde kappala'e, angki mengkalao. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tapakala ummitamokan libukan Siprus dio tandai kairi, sapo tarru' liukan lako Siria. Saekan lako Tirus torromi kappala' annu la dipaturun bawaanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Umpellambi'imokan pira-pira to mangngorean dio angki torro sola saminggu. Umpakari'di'mi Paulus annu naparunduk Penawa Masero kumua daumo anna lao lako Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Sapo nalambi'i attunna la mengkalaokan, umpatarru'mokan penonosangki. Naanta'kan to mangngorean sitonda baine sola anak suun illalan mai tondok. Saekan lako biring tasik, pada-padamokan malimuntu' angki ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mangkakan ma'sambayang, sisarak-sarakmokan. Langngammokan kappala' anna ma'pasule duka' lako banuanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mengkalaokan dio Tirus umpatarru' penonosangki kipolalan sae lako Ptolemais. Silambi'mokan duka' angganna to mangngorean dio, sisalama'-lama'mokan anna torropakan sola sangngallo. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Masiangngii, mengkalao omokan tarru' lako Kaisarea. Saekan lako melolo lakomokan banuanna Filipus mesa duka' to siumpalanda' Kareba Kadoresan. Inde Filipus-e iamo to nakala' bilanganna to pitu to mangka dipilei la untawa-tawa kammandean dio Yerusalem. Iamo kingei torro. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Dengan appa' anakna, anak dara asammi, ummampui kapaissanan umpalanda' battakada napaombo' Puang Allata'alla lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pira-pira bongikan dio, saemi mesa nabi disanga Agabus dio mai Yudea. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Saemokan napellambi'i, ummalami beke'na Paulus anna umpungo limanna sola lentekna anna mane ma'kada nakua: “Nakua kadanna Penawa Masero: ‘La dipasusimi te puangna inde beke'e, la napungo to Yahudi dio Yerusalem anna soronganni rokko lisu pala'na tau senga' salianna to Yahudi.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kirangnginna inde battakadae, pada-padamokan sola to mangngorean dio melau lako Paulus kenamala ta'mo lao lako Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","“Maakari ammu tumangi' umparosso buaku? Annu kutarima asammi kao, tae' angga la dipungo, sapo' moi la dipateina' dio Yerusalem ura'na sanganna Puang Yesus.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Sapo tae' umperangngii tula'ki Paulus kipolalan monda umpakilalai. Anggami kikuanni: “Dewatamo pawa.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pira-pirangngallokan dio Kaisarea, ma'patakkammokan la mengkalao lako Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nasolaammokan pira-pira to mangngorean to lu dio mai Kaisarea, naanta' lako banuanna Manason to Siprus, mesa to masaemo mangngorean, annu la torro diokan. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Saekan lako Yerusalem, dore' asammi angganna to mangngorean untammuikan. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Masiangngii, laomokan sola Paulus umpellambi'i Yakobus, dio asammi reen perepi' kilambi' lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nasalama' asammi Paulus anna mane untetteran angganna kara-kara mangka napogau' Puang Allata'alla ummolai pengkaranganna illalan alla'-alla'na tau senga' salianna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Umpakasalle asammi Puang Allata'alla anna urrangngimo tula'na Paulus, anna mane ma'kada lako nakua: “O sa'do'dorangku, messa'bumi duka' to Yahudi inde ummorean Puang Yesus anna matutu unturu' pepa'guruanna Musa. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Sapo' napekareba pepa'guruammu lako to Yahudi dio lembang senga' kumua tae' la unturu' pepa'guruanna Musa. Annu umpa'guruko ade' tau tae' la ussunna' anakna anna tae' la unturu' kabeasaanna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Dadi, umbamo la takua temo, annu innang la naissanan kumua saeko? ");
INSERT INTO mqjNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Dadi kenamala muperangngi tula'ki ammu turu'i. Dengan appa' solaki mangka ma'dandi langngan Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Laomokoa' sola umpalako sara' usseroi kalemu, sapo iko la umpatoka angganna kaparalluan la mupakea' napolalan mala dikotti asan beluakna. La kawanammi pole' lako tau kumua angganna kareba untula'ko narangngi to Yahudi tae' tonganna, sangngadinna tontongko umpengnganda' pepa'guruanna Musa. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Sapo lako to salianna to Yahudi to ummoreammo Puang Yesus, mangkami kipopebanni sura' kumua tae' la ummande nande mangka dipopemala' lako dewata senga', tae' la ummande rara, balena olo'-olo' mate ditekke, anna tae' la ullullu' pa'bannetauan.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Masiangngi, mengkalaomi Paulus ussolaan inde appa' taue, lao usseroi kalena situru' alukna to Yahudi. Lu tamami Banua Ada'na Puang Allata'alla lao umpa'peissanan attunna la nangei suppik sara' usseroi kalena, anna attunna la nangei umbaa bua pemala'na simesa-mesai. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","La nalambi'i kapitungngallona nangei usseroi kalena, dengammi pira-pira to Yahudi to lu dio mai Asia ummita Paulus illalan Banua Ada'na Puang Allata'alla. Urrasimi tau kamban anna mane umpealai Paulus, ");
INSERT INTO mqjNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","napasiolaan meoli-oli nakua: “O anggammua' to Israel, pamoloikan kami! Iamo te to silao ma'leleanne umpa'guru tau la umbelle'kia' to Israel anna pepa'guruanna Musa anna Banua Ada'na Puang Allata'alla. Temo ussolaan pole omi to Yunani tama Banua Ada'na Puang Allata'alla ungkadakei angngenan masero.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Annu mangka ummita Trofimus to lu dio mai Efesus sola leen Paulus illalan Yerusalem, napolalan nasanga nasolaan Paulus tama Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ramba siami tau illalan Yerusalem anna sikakondong sae umpealai Paulus anna rui' sesse'i illalan mai Banua Ada'na Puang Allata'alla. Tappa ditutu'i asammi ba'bana Banua Ada'na Puang Allata'alla. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Marassanni la umpatei Paulus, sae siami kareba lako randan ponggawana tantarana to ma'parenta Roma kumua ramba issinna Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mengkalao siami randan ponggawana tantara sola pira-pira ponggawa senga', ussolaan tantarana lao lako angngenan nangei tau buda. Tappana ummita tantara, monda siami ungkambei Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Umpellambi'imi Paulus inde randan ponggawana tantarae anna sakkai. Ussuami tantarana umpungoi dua rante bassi anna pekutananni kumua bennannara inde taue anna aka napogau'. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Sapo' mongngo' babang tau sitimba'-timba' meoli-oli tae' dengan tanapokada, dadi tae' dengan ma'lesoan narangngi randan ponggawana tantara. Napolalan ussua tantarana umbaa Paulus lako angngenanna tantara. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Saei lako sa'de eran, nasirande-randeimi tantara annu ma'dallo'mi tau buda. ");
INSERT INTO mqjNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bu'dak tau ummula'i menge sipealo'-alosan nakua: “Pateii.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Inde anna la dipatamamo angngenanna tantara Paulus-e, nakuamo lako randan ponggawana tantara: “Malarokoka kupantula'i sappalli'?” Natimba' nakua: “Muissan ma'basa Yunani? ");
INSERT INTO mqjNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Dadi tangngiako to Mesir, to mane mangka la umbali to ma'parenta napolalan ussolaan appa' tasa'bu gurilla lako padang alla'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Natimba' Paulus nakua: “To Yahudina', to lu dio mai Tarsus, mesa tondok kalelean sanganna dio Kilikia. Kupelau matin kenamala mupabeaina' mantula' lako inde tau kambanne.” ");
INSERT INTO mqjNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Napatiolaimi randan ponggawana tantara. Ke'de'mi Paulus yao eran anna ummangka' limanna umpakamma' tau kamban. Mattanni tau, mantula'mi ma'basa Ibrani nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“O anggammua' sa'do'dorangku anna mentu'na to matua, tanan talingaii kada la kupalanda' tama alla'-alla'mua' temo, la umpa'timpasan kaleku.” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Tappana urrangngi Paulus ma'basa Ibrani, tuttuan mattan pole' tau buda. Nakuamo Paulus: ");
INSERT INTO mqjNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“To Yahudina', dadi diona' Tarsus lembangna Kilikia. Sapo' kamai indena' Yerusalem, anna naparundukna' tuangguru disanga Gamaliel situru' alukna neneta. Napolalan barringna' unturu' Puang Allata'alla susikoa' temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Buda duka' to unturu' Lalanna Puang Yesus mangka kupakario-rio lambisan mate, susi muane tenni baine kupealai angku mane popetarungkunni. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kara-kara iatee nasa'bii Pongkena Imam sola pa'bisara aluk annu nabenganna' sura' parenta kubaa lako solaki to Yahudi dio Damsyik annu la umpealaina' to unturu' Puang Yesus la kubaa sae inde Yerusalem dipabambanni sangka'. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Sapo ummolana' lalan, la sae kalemo' lako Damsyik umbai tangngamo allo, tokke'mi dengan pangngarrang yao mai langi' ungkabu'na'. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Songka siamo', kurangngimi kamara nakua: ‘O Saulus, O Saulus, maakari ammu pakario-riona'?’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kukuamo untimba'i: ‘O Puang, bennaroko Iko?’ Nakuammo': ‘Kaomo te Puang Yesus to Nazaret to mupakario-rioe.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Inde to kusolaanne ummita duka' pangngarrang, sapo' tae' urrangngi tula'na to umpantula'ina'. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Kukuamo: ‘O Puang, akamo la sipato' kupogau'?’ Nakuammo': ‘Millikmoko ammu tarru' lako Damsyik, annu la diopoko ammu mane ditulasan aka mangka napatantu Puang Allata'alla la mupogau'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Natettemo' solaku menono' tarru' lako Damsyik annu ta'mo' paita napobua' pangngarrang yao mai langi'. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Dio Damsyik, dengan mesa tau disanga Ananias, iamo mesa to maiman anna to matutu ummanda'i pepa'guruanna Musa. Inde taue napakasalle angganna to Yahudi illalan tondok iatoo. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Saemo' naollongngi anna ke'de' dio sa'deku ma'kada lako kaleku nakua: ‘O sa'do'dorangku Saulus, paitako sule!’ Paita siamo' kupolalan ummita inde taue. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anna mane ma'kada pole nakua: ‘Puang Allata'alla to napenombai neneta mangka unturoko la umpengngissananni pa'kuanna. Anna la ummitako Puang Yesus To Malolo anna la urrangngiko kamara suun dio pudukna. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Annu la mupa'pesa'bian lako ma'rupa tau kara-kara mangka muita anna mangka murangngi. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Dadi daumo anna selang penawammu. Millikmoko, ammu ditedok ammu pelaui langngan Puang Allata'alla anna nagarri'iangko kasalaammu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Saena' sule inde Yerusalem, marassanna' ma'sambayang illalan Banua Ada'na Puang Allata'alla, tokke'mo' taman. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ummitamo' Puang Yesus ma'kada nakua: ‘Ma'sirra'ko umpellei Yerusalem annu tae' dengan tau inde la ummorean kasa'biammu untetteranna'.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Sapo' kutimba' kukua: ‘O Puang Yesus, naissanan asan tau inde kumua kaomo siullelean banua pa'sambayangan untambak puso to ummoreangko angku mane patamai tarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Susi duka' anna dipatei mesa sa'bimmu disanga Stefanus, diona' reen ussituru'i kadipateianna anna kaomo undagai bayu rui'na to umpateii.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Sapo' natimba' Puang Yesus nakua: ‘Mengkalaoko, annu la kusuako lako angngenan mambela umpellambi'i tau senga' salianna to Yahudi.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tappana urrangngi tula'na Paulus kumua la lu lako tau senga' salianna to Yahudi, sipealo'-alosammi tau buda nakua: “Pa'deanni illalan lino itin tauo. Tae' sipato' tuo liu.” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Menge liumi sipealo'-alosan tau buda napasiolaan umpa'tibean leen bayu rui'na anna ussembu' soyok langngan loa. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Iamo nangei mesua randan ponggawana tantara la dibaa Paulus tama angngenanna tantara annu la diparessa dipasiolaan ditambak puso anna malara diissanan balayanna nangei sipealo'-alosan tau lako kalena. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Marassanni disangke' limanna la ditambak puso, nakuamo Paulus lako mesa ponggawana tantara to ke'de' dio sa'dena: “Malarokoka tokke' untambak puso mesa to Roma ke ta'pa mangka dibisara?” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tappana urrangngi tula'na Paulus, lao siami umpellambi'i randan ponggawana anna kuanni: “Akamo la tapogau' annu to Romaria?” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lao siami umpellambi'i Paulus inde randan ponggawana tantarae anna kuanni: “Pokada manappai, to Roma tongarrokoka?” Natimba' Paulus nakua: “Io, tonganna.” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nakuamo inde randan ponggawana tantarae: “Masulli' kao kubayasanni angku mane mala digente' to Roma.” Natimba' Paulus nakua: “Innang to Romanakkao annu to Roma undadianna'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Marea' asammi to disua untambak puso Paulus napolalan soro'. Marea'mi duka' randan ponggawana tantara naissanannamo kumua to Romaria Paulus, to napopepungo. ");
INSERT INTO mqjNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Sapo' moi susi too, morai tappa' randan ponggawana tantara la umpengngissananni ura'na nangei dipasala Paulus. Iamo nangei, masiangna, untambaimi angganna kapala imam sola pa'bisara alukna to Yahudi anna urrappanan Paulus illalan mai tarungkun anna mane baai tama alla'-alla'na to ma'mesa. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pantan unnenne'imi pa'bisara alukna to Yahudi Paulus anna mane ma'kada nakua: “O anggammua' sa'do'dorangku, tae' dengan kendek illalan penawangku kumua kasalaanna' dio olona Puang Allata'alla sae lako allo temo.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Tappa mesua siami Ananias Pongkena Imam lako to ke'de' dio sa'dena Paulus anna sappai sadangna. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nakuamo Paulus: “Anna Puang Allata'allamora umbala'i pa'palakomu, annu siumpa'paitangko kalemu takuananta to masero. Anna tongkongko temo umparessana' situru' pepa'guruanna Musa, sapo' sitonganna tae' situru' pepa'guruanna Musa pa'palakomu ussua tau ussappa sadangku.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nakuamo to dio reen lako Paulus: “Maakari ammu telle Pongkena Imamna Puang Allata'alla?” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Natimba' Paulus nakua: “O anggammua' sa'do'dorangku, tae' kuissanan kumua Pongkena Imam. Tonganna, dengan tiuki' nakua: ‘Dau untula' kadake perepi'mu.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Innang naissanan Paulus kumua inde pa'bisara alukke dengan to Saduki dengan duka' to Farisi, napolalan napemandui mantula' nakua: “O anggammua' sa'do'dorangku, to Farisina' duka', peampoanna to Farisi. Ia kungei dibisara annu ummoreanna' katuoanna sule to mate.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tappana ma'kada susi Paulus, kendek siami kasipekkaan illalan alla'-alla'na to Saduki anna to Farisi, napolalan sipa'barean inde to ma'rempunne. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Annu nasanga to Saduki kumua tae' dengan katuoanna sule to mate, tae' dengan malaeka' anna anitu. Mengke'de' to Farisi ummorean katuoanna sule to mate anna naorean kumua dengan malaeka' sola setang. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Sipealo'-alosammi tau sipekka-pekka. Pira-pira to untarru' issinna sura'na Musa to nakala' kombonganna to Farisi ke'de' anna meoli nakua: “Sitonganna tae' dengan kikabattui kasalaanna inde taue, annu umbai dengan anitu battu malaeka' umpantula'i.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tuttuan maroa' pole' tau sipekka, napolalan marea' randan ponggawana tantara annu napikki' kumua ullimbui mani Paulus. Ussuami tantara lao ummala karra' Paulus tama alla'-alla'na tau, anna baai lako angngenanna tantara. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Bongi polei saemi Puang Yesus ke'de' dio sa'dena Paulus anna pantula'i nakua: “Pomatoroi penawammu, annu umba mukua umpa'pesa'bianna' inde Yerusalem, la susimi duka' mupalako dio Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Masiangngi, ma'mesami to Yahudi la'bi appa' tapulo urrapa' kada la umpatei Paulus anna ummoton pinda kumua tae' la ummande sola ummiru' ke ta'pa mangka napatei. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Laomi umpellambi'i kapala imam anna angganna perepi'na to Yahudi anna kuanni: “Mangkamokan ummoton pinda kumua tae'kan la ummande sola ummiru' ke ta'pa umpatei Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Dadi, ma'mesakoa' anggammu pa'bisara aluk ammu pelaui lako randan ponggawana tantara anna umpopengngolo pole Paulus tama pa'rempunammua', susi to la diparessa pole kara-karana. Sapo innang la diomokan salian ummadangngi napolalan ta'pa la sae tama pa'rempunammua' angki pateimi.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Sapo' dengan anak urena Paulus, anakna sirondongna baine urrangngi kara-kara iatoo. Laomi tama angngenanna tantara anna palanda'i lako Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Untambaimi mesa ponggawana tantara Paulus anna kuanni: “Laopoko ussolaan inde anak muane lako randan ponggawana tantarae annu dengan la napokada.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Saei lako randan ponggawana tantara, nakuamo: “Natambaina' Paulus iato to ditarungkunno anna kuanna': ‘Laopoko ussolaan inde anak muane lako randan ponggawana tantarae annu dengan la napokada.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ummanda'imi limanna anak muane inde randan ponggawana tantarae anna bawai lako kasalaanna, anna kutanaii nakua: “Aka la mupokada?” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Natimba' inde anak muanee nakua: “Buda to Yahudi mangka urrapa' kada la napelau matin anna malara makale' mupopengngolo pole Paulus lako pa'bisara aluk, susi to la diparessa pole kara-karana. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Sapo' kenamala tae' mupatiolai annu la'bi appa' tapulo tau mangngadang la umpatei Paulus. Mangkami ummoton pinda kumua tae' la ummande sola ummiru' ke ta'pa umpatei Paulus. Dadi tula'mu mandami naampai.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ussuami anak muane sule, anna pakari'di'i nakua: “Dau pokadai lako tau moi benna, kumua kara-kara iatoo iko sae untulasanna'.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Untambaimi dua ponggawana tantara inde randan ponggawana tantarae, anna kuanni: “Patokai dua ratu' tantara, pitu pulo to ma'darang anna dua ratu' to ma'doke, annu la mengkalao lako Kaisarea temo bongi umbai tettek kasera. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Patokai duka' pira-pira darang la nasakei Paulus ammu solaan manappai lako gubernur Feliks.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ummuki'mi sura' randan ponggawana tantara, nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Salama'ku, Klaudius Lisias lako gubernur Feliks to kupakasalle. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Inde taue napealai to Yahudi la napatei. Sapo marassanni la napatei, saemo' ussolaan tantara undapaii napolalan narappanan, annu kurangngi kumua to Roma. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kupopengngolomi lako pa'bisara alukna to Yahudi la kuola ummissananni ura'na nangei ditanda'. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Napolalan kuissanan kumua angga ullenda kabeasaanna to Yahudi nangei ditanda', sapo tae' dengan pa'tanda'na la mala dipoisungan umpateii battu ditarungkun. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Lambisan dengami tau sae untulasanna' kumua ma'mesa to Yahudi urrapa' kada la umpateii napolalan kusua matin umpellambi'iko. Mangkami duka' kukuanni to patanda' anna matin ammu bisarai.” ");
INSERT INTO mqjNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Laomi ummala Paulus inde mai tantarae situru' parentana ponggawana anna baa bongii lako Antipatris. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Masiangna, anggami to ma'darang tarru' ussolaan Paulus, mengke'de' tantara menono' ma'pasule lako angngenanna. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Saei lako Kaisarea, umpebeemmi sura' inde mai to ma'darangnge anna ussorongan Paulus rokko lisu pala'na gubernur. ");
INSERT INTO mqjNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Mangkai umbaca sura' gubernur, ungkutanaimi Paulus kumua lembang umba nangei buttu. Narangnginna kumua to Kilikia, ");
INSERT INTO mqjNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nakuamo lako Paulus: “La kubisarakoa' ke saemi to untanda'ko.” Anna mane ussua tantara umbaa Paulus lako banua kaparentaan disanga Istana Herodes anna didagai dio. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Limangngalloi mangkanna, saemi Pongkena Imam disanga Ananias sola pira-pira perepi'na to Yahudi anna mesa to manarang umpantulasan to ma'kara-kara disanga Tertulus. Umpellambi'imi gubernur anna tulasanni aka ura'na nangei untanda' Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Dipopengngolomi Paulus lako gubernur. Naparandukmi Tertulus ummulelean pa'tanda'na nakua: “Feliks to kipakasalle, tontongkan ussa'dingan liu kamasannangan ura'na pengkarangammu anna tibangummo lembangki ura'na kakeakasammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Angganna te maie tontong kikurru'i sumanga' kipolei paraya umba-umba angngenan kingei torro. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Sapo indana budamo attummu dilewa'i, kupelau kenamala la muperangngipakan sappai' sitonda kamalennasan penawammu. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ianna kiita inde taue innang to la pasanggangan, annu umpakendek kasipekkaan illalan alla'-alla'na to Yahudi sangkalebu lino. Iamo duka' mesa perepi'na kombonganna to Sarani. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","La'bi-la'binna mangkami nasandak untunai kamaseroanna Banua Ada'na Puang Allata'alla napolalan kisakka la kibisara situru' alukki. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Sapo sae randan ponggawana tantara disanga Lisias ummala karra'i dio mai kaleki, ");
INSERT INTO mqjNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","anna ussua to patanda' mengngolo lako kalemu. Ianna muparessamo inde taue, la muissanan asammi kara-kara kitandasanni.” ");
INSERT INTO mqjNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Angganna tula'na Tertulus natonganan asan duka' to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Umbengammi tanda Paulus inde gubernur-e kumua la malami mantula'. Nakuamo Paulus: “Kuissanan kumua ma'taummi muola ma'bisara illalan inde lembangnge, iamo nangei menumpu penawangku la umpa'timpasan kaleku dio tingngayomu. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","La mupesa'man manappa ammu issananni kumua ta'pa nalewan sapulo dua allona mangkangku lao lako Yerusalem ma'sambayang. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tae'na' dengan dilambi' menge sipekka tau, battu usse'dek tau umpakendek kamarukkaan, susi illalan Banua Ada'na Puang Allata'alla tenni illalan pa'sambayangan battu lako angngenan senga' dio Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tae' toi nabela umpomanassa pa'tanda'na lako kaleku temo. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Sapo kuakui dio olomu kumua umpenombaina' Puang Allata'alla, Dewatanna neneki situru' Lalanna Puang Yesus, iamo nasanga kadanna lalan sala. Kuorean asan issinna sura'na Musa anna issinna sura'na nabi. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Parannuna' langngan Puang Allata'alla, susi siamokan inde mai taue kumua dengan katuoanna sule to mate, susi to malolo tenni to kadake. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Iamo kungei siumpeang liu lalan anna malara angganna kedoku la mengkalao illalan unak penawangku, susi langngan Dewata tenni lako padangku ma'rupa tau. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Pira-pira taunna' umpellei Yerusalem, laomo' lako sule umbaa doi' la ditawa lako to mase-mase sitonda laona' memala' langngan Dewata. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Innang naitana' to Yahudi illalan Banua Ada'na Puang Allata'alla, angku mangka diseroi situru' ada'na to Yahudi anna inde angku marassan umpalako pemala'e. Sapo' attu iatoo tae' buda tau dio reen kusolaan anna tae' dengan tau marukka, ");
INSERT INTO mqjNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","sapo' dengan duka' pira-pira to Yahudi to lu dio mai Asia illalan Banua Ada'na Puang Allata'alla. Iamo te maie la sipato' mupadio reen anna ummendekan pa'tanda'na lako kaleku ke sia dengan. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sapo pabeaimi to dio reen temo untula' kasalaan aka kupogau' angku marassan naparessa pa'bisara alukna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Umbai angga sabatta kadangku napasala angku mantula' illalan alla'-alla'na, iamo kukua: ‘Dibisarana' allo temo annu kuorean kumua dengan katuoanna sule to mate.’ ” ");
INSERT INTO mqjNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Sapo umpatorro salapi inde kara-kara Feliks-e nakua: “Anna saepa Lisias, randan ponggawana tantara angku mane kattu inde kara-karamua'e.” Inde Feliks-e budami tau narangngi untetteran Kasaranian napolalan budamo napekalembasan. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ussuami ponggawana tantara umpatama tarungkun Paulus, sapo tae' la didagai sigali, anna tae' toi la didapai solana ungkandapai. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pira-pirangngalloi, sae omi Feliks sola bainena disanga Drusila, mesa to Yahudi. Umpopetambaimi Paulus annu la natetterananni kapangngoreanan lako Puang Yesus Kristus. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Sapo tappana ullambi' kada kamaloloan, ungkuasai kale, anna attunna la dibisara ma'rupa tau, marea'mi Feliks napolalan nakua lako Paulus: “Sirua opi, laomoko sule anna dengan opa attungku angku mane tambaiko.” ");
INSERT INTO mqjNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Sapo' sitonganna parannu Feliks la nabengan doi' Paulus. Iamo nangei pembuda umpopetambai Paulus napopantula'. ");
INSERT INTO mqjNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dua taunni mangkanna, disondaimi gubernur Feliks, nasonda Perkius Festus. Ia nangei untarungkun liu Paulus, annu morai Feliks la ummala penawanna to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tallungngalloi saena Festus dio lembang iatoo, mengkalaomi dio Kaisarea lu lako Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Dioi Yerusalem, napellambi'imi kapala imam sola angganna perepi'na to Yahudi anna untetteran pa'tanda'na lako Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Usse'dek liumi Festus kenamala napatiolai anna ussua Paulus sae dio Yerusalem, annu napattuyu la napatei dio lalan. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Sapo natimba' Festus kumua innang ditarungkun dio liu ia Kaisarea Paulus, anna innang la ma'sirra' duka' sule lako. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nakua Festus: “Dadi la laokan sola to paissammua' lako Kaisarea anna umpokada pa'tanda'na lako Paulus, ke sia dengan kasalaanna.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","La'bi saminggupi Festus dio Yerusalem anna mane sule lako Kaisarea. Masiangna, ummokko'mi illalan angngenan pa'bisaraan, anna umpopetambai Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Saei Paulus, naliling tamami to Yahudi lu dio mai Yerusalem, anna umpokada buda pa'tanda'na, sapo' tae' nabela napomanassa. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Umpa'timpasammi kalena Paulus nakua: “Tae' dengan kasalaangku moi padamo nennu', susi lako ada'na to Yahudi anna Banua Ada'na Puang Allata'alla, tenni lako to ma'parenta Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Sapo morai Festus la ummala penawanna to Yahudi, napolalan ma'kada lako Paulus nakua: “La ma'dingkoka lao lako Yerusalem angku bisara diokoa'?” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Natimba' Paulus nakua: “Temo diomo' tingngayona pa'bisara to nabengan kakuasaan tomaraya Roma, dadi sipato'mi ke dikattu indei kara-karaku. Annu muissanammi kumua tae' tongan-tongan dengan kasalaangku lako to Yahudi. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ianna dengan kasalaangku kupolalan la sipato' dipabambanni sangka' dipatei, masannangna' la dipatei. Sapo ianna tae' tonganna pa'tanda'na lako kaleku, tae' dengan tau mala ussoronganna' rokko lisu pala'na inde mai taue. Dadi kupelau kenamala inde kara-karakue dibisara dio tingngayona tomaraya Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Sipantula'-tula'mi Festus anna inde to nasolaan ma'bisarae anna mane ma'kada nakua: “Mangkami mupelau la dibisara dio tingngayona tomaraya Roma kara-karamu, dadi kupalulakomoko tomaraya Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pira-pirangngalloi mangkanna, saemi tomaraya Agripa sola Bernike dio Kaisarea umpellambi'i Festus anna salama'i. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Pira-pirangngalloi torro dio, untetteran kara-karana Paulus gubernur Festus lako nakua: “Dengan mesa to ditarungkun inde disanga Paulus, natampe Feliks. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Saena' lako Yerusalem, natulasammo' kapala imam sola perepi'na to Yahudi angganna pa'tanda'na lako inde taue napasiolaan napelau la dipabambanni sangka'. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Sapo' kutimba' kukua: ‘Tangngia kabeasaanna to ma'parenta Roma tokke' la umpabambanni sangka' mesa tau ke ta'pa dibisara annu la dibengampi attu umpa'timpasan kalena dio tingngayona balinna.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Dadi inde anna saemo pira-pira to Yahudie kupa'sirra'imi umbisarai. Masiangngii le'ba' siamo' tama angngenan pa'bisaraan angku mane umpopetambai Paulus. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Inde anna ke'de'mo untetteran pa'tanda'nae, tangngiaria gau' kadake susi illalan penawangku napokada. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sapo anggaria alukna nasipekkai anna dengan mesa tau disanga Yesus, mangkami bonno' sapo pissan kadanna Paulus kumua tuo. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Pusa'mo' umba la kukua ummissanan tappa' inde kara-karae, kupolalan ungkutanai Paulus kukua: ‘La ma'dirrokoka lao lako Yerusalem ammu dibisara dio?’ ");
INSERT INTO mqjNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Sapo' napelau la dibisara dio tingngayona tomaraya Roma anna la dipaillalampa tarungkun sae lako nalambi' attunna dibisara. Dadi kusua tau umpatamai tarungkun inde napolalan ummampai attu la kungei ussua tau ussolanni lako tomaraya Roma.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nakuamo tomaraya Agripa: “Moraina' la urrangngi tula'na itin tauo.” Natimba' Festus nakua: “Makale'pa ammu perangngii.” ");
INSERT INTO mqjNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Masiangngii, saemi Agripa sola Bernike umpasangga' porewana la umperangngii Paulus. Tamami angngenan pa'bisaraan sola angganna ponggawana tantara anna to diangga' illalan tondok. Ussuami tau Festus lao ummala Paulus anna solanni tama angngenan pa'bisaraan. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ma'kadami Festus nakua: “O tomaraya Agripa sola anggammua' to ma'kombong temo. Petua'ia' inde taue. Iamo te to ditanda' umpogau' kakadakeanne, natanda' angganna to Yahudi susi dio Yerusalem tenni inde Kaisarea. Saena' napellambi'i anna sipealo'-alosan nakua: ‘Itin tauo tae' mala dipabeai tuo liu.’ ");
INSERT INTO mqjNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Sapo' tae' dengan kukabuttui pa'palakona la dipolalan umpabambanni sangka' dipatei. Sapo napelau la dibisara dio olona tomaraya Roma, dadi la kupalulakomi Roma. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Sapo ta'pa kuissanan akamo la nakua sura'ku untetteranni lako tomaraya. Iamo kungei umpopengngolomi tama alla'-alla'mua' temo la'bi-la'binna lako tomaraya Agripa, anna malara dengan mala kuuki' ke mangkami diparessa. ");
INSERT INTO mqjNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Annu nakua inawangku tae' natamai akkalan tokke' la ussua mesa to ditarungkun mengngolo lako tomaraya ke tae' dipasiolaan kasalaan napogau' situru' pa'tanda'na tau lako kalena.” ");
INSERT INTO mqjNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ma'kadami tomaraya Agripa lako Paulus nakua: “Dibengammoko attu mantula' la umpa'timpasan kalemu.” Ummangka'mi limanna Paulus anna mane mantula' umpa'timpasan kalena nakua: ");
INSERT INTO mqjNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“O tomaraya Agripa, kerongko'na' allo temo annu malana' ke'de' dio tingngayomu umpa'timpasan kaleku, untimba' angganna pa'tanda'na to Yahudi lako kaleku. ");
INSERT INTO mqjNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","La'bi-la'binna kuissanan kumua untarru' tongangko kabeasaanna to Yahudi sola kara-kara sibeasa nasipekkai. Iamo too, kupelau la sa'bara'ko umperangngii tula'ku. ");
INSERT INTO mqjNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Angganna to Yahudi ummissanan asan pa'palakoku mengkalao dio mai angku mangngurapa susi dio tondok kadadiangku tenni dio Yerusalem. ");
INSERT INTO mqjNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Masaemi anna issananna'. Anna kela naakui, la malana' napa'pesa'bian kumua mengkalao dio mai to nakala'na' kombonganna to Farisi, kombon