﻿USE sofia;
DROP TABLE IF EXISTS sofia.mqbNT_vpl;
CREATE TABLE mqbNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mqbNT_vpl WRITE;
INSERT INTO mqbNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Həna anan nà, ɗerewel sə sləmay ana bije a Yesu Almasihu ahay. Winen mə wahay a nà, pə zahav ana Dawuda wan sə kutov ana Ibərahima. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibərahima a wahay Isiyaku, Isiyaku winen a wahay Yakob, Yakob ite a wahay Yahuda, tinen tə mərak anahan ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda winen a wahay atə Fares tə Jara pə uwar a sə ngaman Tamar ata wa. Fares a wahay Hesərunu, Hesərunu ite a wahay Aram, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ite a wahay Aminadabu, Aminadabu ite a wahay Nasunu, Nasunu ite a wahay Salmuna. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuna a wahay Bo'es pə uwar a sə ngaman Rahab ata wa. Bo'es ite a wahay Obed pə uwar a sə ngaman Rut ata wa. Obed ite a wahay Yisa, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisa ite a wahay bahay Dawuda. Dawuda a wahay Sulimanu pə uwar anahan sə ngəzar pə Uriya wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulimanu ite a wahay Roba'am, Roba'am ite a wahay Abiya, Abiya ite a wahay Asa, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ite a wahay Yusafat, Yusafat ite a wahay Yoram, Yoram ite a wahay Ujiya, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiya ite a wahay Yotam, Yotam ite a wahay Akas, Akas ite a wahay Hejekiya, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekiya ite a wahay Manasa, Manasa ite a wahay Amos, Amos ite a wahay Yusiya, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yusiya ite a wahay Yekoniya tə mərak aya awan. À alay a tinen ata, bahay sə Babila a pak anan Isəra'ila ahay ù kon wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pə dəɓa a way ata wa asa, Yekoniya a wahay Salatiyel, Salatiyel ite a wahay Zorobabila, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabila ite a wahay Abihuda, Abihuda ite a wahay Eliyakim, Eliyakim ite a wahay Ajora, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajora ite a wahay Sadok, Sadok ite a wahay Akim, Akim ite a wahay Eliyada, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyada ite a wahay Eliyajaru, Eliyajaru ite a wahay Matan, Matan ite a wahay Yakob, ");
INSERT INTO mqbNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakob ite a wahay Yusufu, mbaz ana Mariyama, may a Yesu sə ngaman Almasihu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abaslay zahav ata pə mədire pə mədire a bənay ahay pə Ibərahima wa hus pə Dawuda nà, kà gak bije ahay kuro nga anahan a fuɗo. A ban pə Dawuda wa ite, hus pə ana tinen sə həɗek à Babila ɗukwen, kà gak bije ahay kuro nga anahan a fuɗo. A bənay pə winen ata wa ite, hus pa sə wahay anan Almasihu ite nà, kà gak bije ahay kuro nga anahan fuɗo a re. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Awahay ana Yesu Almasihu a təra nà, natiya awan: Mariyama, may anahan ata nà, winen dəle ana Yusufu. À alay a tə gəɓak zek fan bay nà, məgala sə Apasay Cəncan a, a gan wan anà Mariyama. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu, dəle anahan ata nà, winen ɗo ɗiɗek awan, a pərahan azar anà Mbərom. A nan sa ra apan waray pa 'am sə ɗo ahay bay. Anga nan, Yusufu a nan sə mbəsak anan dəle anahan tə wurwer. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Winen apan i bayak pa 'am ata mba, maslay a Mbərom a kan zek ì cœn sə zuɓay inde. A jan, a wa: «Yusufu, ɗo sə zahav ana Dawuda, kə̂ jəjar sə gəɓa anan dəle anak Mariyama bay, anga sa gan wan nà, məgala sə Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I wahay wan mungol awan, kə̂ ngaman Yesu, anga i tam anan ɗo anahan ahay ì ines a tinen ahay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Way ata fok a təra anga aday 'am ana Mbərom Ba Məduwen a sa ja tə dungo ana ɗo maja'am anahan ata, â təra. A wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Dəna dalay a i ga wan, i wahay wan mungol awan, ti ngaman Imanuwila.» ");
INSERT INTO mqbNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu a pəɗek pə ahan wa nà, a ga kawa ana maslay a Mbərom sa jan ata awan. A gəɓa anan dalay anahan Mariyama agay. ");
INSERT INTO mqbNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Əna tə japak tə Mariyama bay, hus pa sə wahay anan wan anahan ata awan. Yusufu a ɗaf apan sləmay Yesu a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu nà, winen mə wahay a à Baytilama pə daliyugo sə Yahudiya. À alay ata nà, bahay sə Yahudiya a nə Hiridus. Pə dəɓa sə wahay anan Yesu wa nà, kəlire ahay ta nay ahay kwa ta day sə dara wa, à Urəsalima. Tinen aday nà, ta san way pə cəveɗ sə mawuzlawazl ahay zle. Anga nan tə cəce pə ɗo ahay wa, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«Wan a mə wahay a, aday i sa təra bahay sə Yahuda ahay ata nà, winen ahaw? Mə canak anan anà mawuzlawazl anahan a kə̀ slabakak ahay à dəlon wa. Ma nay sa naa həran ayak nga.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bahay Hiridus a sləne cəna, 'am ata kə̀ wusek atan nga, winen tu ɗo sə Urəsalima ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hiridus a halan nga anà bahay sə gəɗan dungo anà way ahay anga Mbərom, pi zek tə miter sə Tawrita ahay fok. A cəce patan wa, a wa: «Ti wahay Almasihu nà, ahaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tə mbəɗahan apan, ta wa: «Ti wahay Almasihu nà, à Baytilama, pə daliyugo sə Yahudiya. Anga ɗo maja'am a Mbərom kə̀ vindek kwakwa, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Iken Baytilama, wulen su doh pə daliyugo sə Yahudiya, kə kəcak à mamasl sə wulen su doh sə Yahudiya ahay bay jiga awan. Anga bahay i sləray ahay nà, ì iken wa, aday i gan nga anà Isəra'ila ɗo uno ahay kawa ɗo sə jugwar təman ahay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Natiya kutok, Hiridus a ngaman atan ayak anà kəlire ahay ù doh pə cakay anahan. A ngaman atan ayak mənjəna ɗo ahay sa san apan, aday a cəce patan wa, a wa: «Kə cinen anan anà mawuzlawazl ata a slabak nà, à alay wuraw?» Tə ɗakan anan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pə dəɓa anahan a wa a jan atan asa, a wa: «Zlen à Baytilama, pəlen anan wan ata lele. Ki ten anan à nga cəna, ka naa jen uno, aday nen ni zla saa həran ahay nga a cite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tinen ite, tə sləne anan 'am a bahay ata cəna, ta zla kutok. Mawuzlawazl a, tinen a sə canan kurre a ata, a njahan atan pa 'am wa. A dəzle pa nga su doh a aday wan a à man ata ata nà, mawuzlawazl ata a tavay dek. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tə canan anà mawuzlawazl sə tavay dek ata cəna, ta njaɗ ataslay mivel məduwen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta zla ù doh a aday wan a winen à man ata ata awan. Ta tan à nga anà Yesu, tinen maya tə may anahan Mariyama. Tə dukwen gərmec ù vo, tə həran nga anà wan ata awan. Tə pəsak anan mbulo a tinen ahay, aday tə varan magwagway ahay cara cara: gura ahay, mətətok sə ləluway sə rəbas lele ataya awan, pi zek tə wurde sə ngaman mira ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pə dəɓa anahan a wa nà, Mbərom a ɗakan atan anan ì cœn sə zuɓay inde nà, tâ ma ta man ana Hiridus sabay. Natiya ta zla agay tə cəveɗ hinen kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ɗo a ataya ta zla way a tinen cəna, maslay a Mbərom a kan zek anà Yusufu ì cœn sə zuɓay inde, a jan, a wa: «Slabak! Zla anan wan tə may anahan a təke à Misra, bina Hiridus i pəlay wan a anan, anga a nan sə lize anan. Njihen à man ata hus pə luvon a azanan ni jak, hayak ikwen ahay wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Matanan kutok Yusufu a slabak sə luvon, a zla anan Yesu tə Mariyama a təke à Misra. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tə njahay à man ata hus pə amac ana Hiridus. Natiya, way ana Mbərom Ba Məduwen sa ja tə dungo ana ɗo maja'am anahan ata a təra. A wa: «Ni ngaman anà wan uno kwa pə daliyugo sə Misra wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hiridus a ca apan nə ɗo ataya ta gak kawa ananahan sa jan atan ata sabay cəna, a ga mivel. A jan anà suje anahan ahay nà, tâ vaɗ anan gwaslay ahay à Baytilama wa fok, pi zek tu kon aya sa van nga ataya awan, a ban pa wan ma va a bay a wa, hus pa wan ma va cew ataya awan. Anga kawa ana kəlire ataya sə ɗakan anan alay a ana mawuzlawazl a sə sləray ahay ata nà, a baslay ava awan, i ga nə matanan. A vaɗ atan fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A təra kawa ana ɗo maja'am a Mbərom Yeremiya sa ja, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Zliyzloy kà gak à Rama, ayam tə aja mawa kə̀ zalak. Rahilu winen apan i yam gwaslay anahan ahay. A nan ɗowan â bənan mbac bay, anga gwaslay anahan ahay tə məcak fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hiridus a mac cəna, maslay a Mbərom a kan zek anà Yusufu ì cœn sə zuɓay inde à Misra, ");
INSERT INTO mqbNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a jan, a wa: «Slabak! Zla anan wan tə may anahan a təke pə daliyugo sə Misra wa, ma pə daliyugo sə Isəra'ila, anga ɗo sa gan may sa vaɗ anan wan ataya tə məcak.» ");
INSERT INTO mqbNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufu a slabak, a gəɓa anan wan tə Mariyama a təke, ta ma pə daliyugo sə Isəra'ila kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aya əna, a sləne sa jəka sa pa 'am ana Hiridus nà, wan anahan sə ngaman Arkilawus ata nà, kə̀ jəjarak sə njahay à man anahan pə daliyugo sə Yahudiya. Anga nan Mbərom a kan anan ahay ì cœn sə zuɓay inde way anahan təɗe saa ga ata awan. Ta zla à Galile kutok, ");
INSERT INTO mqbNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","tə njahay way a tinen à wulen su doh a sə ngaman Nazaratu ata awan. A təra matanan ata ɗukwen, anga ɗo maja'am a Mbərom ahay ta jak, ta wa: «Ti ngaman Nazaratu ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yawa, à alay ata nà, ɗowan a inde tə ngaman Yuhana, a taa gan baptisma anà ɗo ahay. A taa nahay à saf inde à kiɓe sə Yahudiya, aday a taa wazan anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","A wazay, a wa: «Mbəsiken ines a kwanay ahay, anga bahay a Mbərom winen bəse tə kwanay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yuhana aday nà, winen ɗo mbala ana ɗo maja'am a Mbərom Ezaya sa ja apan ata awan, a wa: «Ɗowan a inde, winen apan i zlah à saf inde à kiɓe, a wa: “Ten anan cəveɗ anga Bahay winen apan i nay. Ten anan cəveɗ ata mə tavay nga a fəhhe lele.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yuhana a nà, winen a pak pi zek nə zana ma han a tə sibœk sə zlugweme awan, a ɓan zərkutov ɗukwen tə maslərapa sa zlay. Way sa pa anahan a nà, hayam ahay pi zek tə umam sə kiɓe aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɗo sə Urəsalima ahay pi zek tu ɗo sə Yahudiya azar aya tatə ɗo su kon sə cakay sə zlinder sə Urdon ataya fok, ta nay pə cakay anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tə dazlan sə ɗakay anan ines a tinen ahay, aday Yuhana a gan atan baptisma à zlinder sə Urdon ata inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yuhana a canan anà Farisa ahay pi zek tə Saduki ahay ta nay pə cakay anahan saa ga baptisma nà, a jan atan, a wa: «Kwanay zahav sə kòn ahay, ɗo sa njak ɗo ahay, waya sə ɗakak ikwen anan sa haw pə sariya ana Mbərom saa nay ahay ata wa anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gen mer su way lele aya aday sə ɗakay anan nə kə mbəsiken ines a kwanay ahay acəkan ata awan aday. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kâ saa bayiken à nga inde nà, kwanay wan ana Ibərahima ahay ata bay. Way ata i tam kwanay bay. Nen apan ni jak ikwen, Mbərom i mba apan sə təra anan kon a anaya wan ana Ibərahima aya təte. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mbərom kə̀ lavak anan zek tə tirez, i gaɗ anan dədazl si sé aday a wahay wan lele aya bay ata fok. I gaɗ atan, aday i pak atan ù uko inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Nen na gak ikwen baptisma nə tə a'am aday sə ɗakay a nə kə mbəsiken ines a kwanay ahay ata awan. Aya əna, ɗowan inde i nay à dəɓa uno wa, winen nà, i gak ikwen baptisma nə tə Apasay Cəncan awan aday tə uko. Winen nà, a zalay nen tə mazlaɓ lele. Na slak aday ni pəsakan anan liɓer sə təkarak anahan ahay à saray wa bay jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gəsaɗaf inde à alay anahan sə vəvay anan ndaw, i gəzla anan ndaw pi zek wa tə janjar. I halan nga anà ndaw sa pak ì de, aday i vak anan janjar tə uko a aday a mbacay kula itəbay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Natiya kutok, Yesu a slabakay ahay pə daliyugo sə Galile wa, a nay ahay pə cakay ana Yuhana à zlinder sə Urdon. A nan nà, Yuhana â gan baptisma. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Abay Yuhana a ngam bay, a jan, a wa: «Nen aɗəka nə na gan may kû go baptisma. Aday iken asa nə ki nay ahay pə cakay uno nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu a mbəɗahan apan, a wa: «Â zlak à nga! Anga sumor a nà, gumo anan mer su way a abay təɗe a nan à Mbərom gumo ata awan.» Natiya kutok, Yuhana a təma, ");
INSERT INTO mqbNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","a gan baptisma anà Yesu. Yesu a slabakay ahay à a'am wa cəna, a canan ayak anà bagəbaga mburom a təɓa pangaya, aday a canan ayak anà Apasay a Mbərom kawa badəbada, winen apan i dazay ahay, a njahay apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Am ɗukwen a ndəray ahay kwa à bagəbaga mburom wa, a wa: «Həna anan nà, wan uno, ləliwe uno awan. Nə taslay mivel bayak a nə tə winen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pə dəɓa anahan a wa nà, Apasay a Mbərom a zla anan Yesu à man sa saf inde à kiɓe, anga aday Fakalaw â sa njak anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu kà pak awan bay, luvon ahay kwa kuro fuɗo. Luvon tə ipec fok, kà pak awan bay jiga awan. May a han apan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fakalaw a həɗəken ayak pə cakay, a jan, a wa: «Kak iken nə Wan a Mbərom cukutok nà, jan anà kon a anaya tə̂ təra ɗaf, aday ki pa biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu a mbəɗahan apan, a wa: «Deftere a Mbərom a ja nà: “Ɗo zənzen a a njahay uho nə tə way sa pa ɗəkɗek bay, əna ta 'am ana Mbərom sa ja ataya fok.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Fakalaw a zla anan Yesu à Urəsalima, wulen su doh cəncan awan, a ɗaf anan pa nga su doh sə mazlaɓ a Mbərom, ");
INSERT INTO mqbNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a jan kutok: «Kak iken Wan a Mbərom a acəkan nà, ənga larak ayak zek à man a anan wa. Anga Deftere a Mbərom kà jak, a wa: “Mbərom i jan anà maslay anahan ahay sa ba iken. Ti kəcaw iken à alay a tinen inde, anga aday kâ saa ɓurgosl anan saray anak ahay pu kon bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu a mbəɗahan apan, a wa: «Deftere a ja ɗukwen: “Kâ sa ca azan pə Mbərom anak wa bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Matanan, Fakalaw a zla anan à ɓəzlom a inde, sololo cəveɗabay. A ɗakan pə bahay sə daliyugo tembərəzem fok, tə mazlaɓ sə zlile a tinen aya təke. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A jan kutok asa, a wa: «Way a anaya fok, ni varak atan, kak kə dukwek uno gərmec ù vo, aday kə hərak uno nga nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Əna Yesu a jan kutok, a wa: «Zla à man a anan wa, iken Fakalaw, mbəsak nen. Anga mə vinde a à Deftere a Mbərom inde, a wa: “Həran nga nà, anà Mbərom Fetek a taayak, winen Bahay anak. Gan mer su way nà, anà winen a kərtek.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","À alay ata kutok, Fakalaw a mbəsak anan Yesu. Maslay a Mbərom ahay ta nay, ta gan mer su way anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pə luvon a inde, Yesu a sləne nə tə bənak anan Yuhana à dangay. A slabak, a ma pə daliyugo sə Galile. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A mbəsak Nazaratu, a zla way anahan saa nahay à Kafarnahum, wulen su doh a pa 'am sə bəlay sə Galile ata awan, pa day su kon sə Jabulon tə Neftalim ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A ga matanan ata nà, aday 'am ana ɗo maja'am a Mbərom Ezaya sa ja ata â təra. A wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Kon sə Jabulon aday kon sə Neftalim, kwanay pa day uho sə Urdon, pə cəveɗ sa zla à bəlay inde, kwanay pə daliyugo sə Galile, à wulen su ɗo sə pəra ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kwanay mə njahay aya à luvon inde ataya, ki cinen anan anà jiyjay məduwen awan. Kwanay mə njahay aya à man hərəkhərek ataya ù vo sə amac inde, jiyjay ata i dəvak ikwen kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A bənay pə winen ata wa kutok nà, Yesu a dazlan sə wazay. A wa: «Mbəsiken ines a kwanay ahay, anga bahay a Mbərom winen defefe coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu winen apan i bar pa 'am sə bəlay sə Galile. A canan ayak anà ɗowan aya inde tinen cew, ɗo sa ban kəlef ahay. Ɗowan ataya nà, atə Simon, ɗowan a Yesu sə ngaman Piyer ata awan, tə mərak anahan a inde, tə ngaman Andəre. Tinen apan ti ban kəlef a tinen ahay tə zuvo. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu a jan atan, a wa: «Hayak ikwen ahay. Pərihen uno azar, aday ki bənen nə kəlef sabay. Ki i njiɗen uno nà, ɗo sə pəruho azar ahay aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kwayan'a tə mbəsak zuvo a tinen ahay, aday tə pərahan azar à Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu a həɗek pa 'am mənjœk asa, a tan à nga anà ɗo ahay à kwalalan inde cew mungol aya awan. Ɗowan ataya nà, atə Yakuba tə mərak anahan a inde tə ngaman Yuhana. Tinen tatə Zebede, bəbay a tinen awan, tinen apan ti ndakay anan zuvo a tinen ahay à kwalalan inde. Yesu a ngaman atan. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kwayan'a wan ataya tə mbəsak anan kwalalan a tinen tə bəbay a tinen a təke, tə pərahan azar anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kə̀ bərak pə daliyugo sə Galile fok. A ɗakan anan way anà Yahuda ahay ù doh sə wazay a tinen aya awan. A wazan atan ləbara mugom a sə bahay a Mbərom. A mbar anan ɗo sə ɗəvac ahay cara cara pi zek tu ɗo mə təra à məndak aya cara cara bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ləbara anahan ata a ta 'am təɗay pə daliyugo sə Siriya fok. Ta nan anan ahay ɗo sə ɗəvac ahay cara cara pi zek tu ɗo jəje aya awan, ɗo tə setene aya à nga inde, ɗo tə məhərvov aya awan, ɗo ma mac hawal si zek aya fok, a mbar atan. ");
INSERT INTO mqbNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Man su ɗo məduwen a a taa pərahan azar kutok. Ta nay ahay pə daliyugo sə Galile wa, kwa pə daliyugo sə ngaman Dekapol ata wa, kwa à Urəsalima wa, aday kwa pə daliyugo sə Yahudiya azar aya wa, aday kwa pə daliyugo sa day uho sə zlinder sə Urdon ata wa re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu a canan anà man su ɗo ata nà, a ján à ɓəzlom saa njahay à man ata awan. Njavar anahan ahay ɗukwen, ta ján à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesu a dazlan sə wazan atan 'am a anan: ");
INSERT INTO mqbNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Ataslay mivel inde, anga ɗowan aya aday ta san zle, tinen mətawak aya pa 'am a Mbərom ata awan, anga bahay a Mbərom ma var a nə anga tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","«Ataslay mivel inde, anga ɗo sa yam ahay, anga Mbərom i bənan atan mbac. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","«Ataslay mivel inde, anga ɗo sə njahay səkəffe ahay, anga Mbərom i varan atan anan daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","«Ataslay mivel inde, anga ɗo sə pəlay sa ga way sa zlan à nga anà Mbərom ata awan, anga Mbərom i man atan zek sa ga kawa a tinen sa gan may ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","«Ataslay mivel inde, anga ɗo sa gan sumor anà ɗo ahay, anga Mbərom i gan atan sumor. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","«Ataslay mivel inde, anga ɗo sə pəlay Mbərom tə mivel kərtek awan, anga ti i canan tə iɗe a tinen njœk anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","«Ataslay mivel inde, anga ɗo sə ndakay ɗo ahay pi zek ataya awan, anga Mbərom i ngaman atan wan anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","«Ataslay mivel inde, anga ɗo aday tə jugwar panan 'am anga a pəlay sa ga way sa zlan à nga à Mbərom ata awan, anga i njahay pə kərtek a tatə Mbərom à bahay anahan inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Kak ɗo ahay tə gənahak ikwen, tə jugurak pikwen wa 'am, ta rak pikwen 'am kəriya awan, anga kə ɗəfen upo nga nà, ataslay mivel inde anga kwanay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tislen mivel bayak awan, anga Mbərom i varak ikwen magwagway məduwen a à bagəbaga mburom. Ta gan atan ahay anà ɗo maja'am a Mbərom a sə lahak ikwen ahay ataya kwakwa fok ɗukwen, kətana awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Matanan, kawa ana zətene su gom anan way sa pa ata nà, kwanay ɗukwen ki gumen anan daliyugo nə matanan re. Əna kak zətene awan a vaɗ sabay nà, ki ma anan apan avaɗ anahan a nə ta ma asa anaw? Zətene ata i gom sabay, ti lar anan, ɗo ahay ti ján apan à məndak. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Kwanay nà, kawa jiyjay sə dəvan anà daliyugo, kawa wulen su doh ma han a à ɓəzlom. Wulen su doh a matanan ata nà, a ɗer zek itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta taa han uko pə lalam nə sa ɗer anan ta sə hərok apan tasa ɗaw? Ti ɗaf anan bugol nà, pə way sa ɗaf lalam awan, aday â dəvan anà ɗo su doh ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Matana re, lele bine siwaw nà, jiyjay a kwanay â dəvan anà ɗo ahay. Ata ti canan anà mer su way a kwanay a lele ataya awan, aday ti həran nga anà Bəbay a kwanay winen à bagəbaga mburom ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Kâ sa bayiken sa jəka na nay sa naa mbazl anan Tawrita, kabay sa mbazl anan 'am ana ɗo maja'am a Mbərom ahay nà, matanan bay. Na nay ahay aɗəka nà, sa naa rah anan wa, bina sa mbazl anan wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nen apan ni jak ikwen tə ɗiɗem a həna: Hus pə ana daliyugo tə bagəbaga mburom saa lize azanan ata nà, kula alfabe inde kərtek à Deftere a Mbərom ti lar anan wa à məndak nà, ibay, si way a uda ataya fok ti təra aday. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Anga nan kutok, kuwaya kə̀ mbəsakak anan, kabay kə̀ tətakak anan anan anà ɗo hinen sə mbəsak anan nga sa 'am a mə baslay a kwa zek cəɗew a kərtek a nà, winen ɗukwen i təra ɗo zek cəɗew a à bahay a Mbərom inde re. Əna ɗowan a kə̀ təmahak sa ban anan 'am a Mbərom, aday kə̀ ɗakak anan anan anà ɗo hinen sa ban anan re cəna, i təra ɗo məduwen a à bahay a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nen apan ni jak ikwen anan həna re: Ki njiɗen sa zla à bahay a Mbərom a bay, kak si ɗiɗek a kwanay i zalay anan ɗiɗek sə miter sə Tawrita ahay tə Farisa ahay aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Kə sənen zle, Mbərom a jan anà bije a kwanay ahay nà: “Kâ vaɗ nga su ɗo bay. Kuwaya kə̀ vəɗak ɗo cəna, ti gan sariya.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Əna nen ni jak ikwen həna kəma, kuwaya ɗowan a kà gak mivel pə njavar uno hinen cəna, kà slak ti gan sariya ca. Aday kuwaya ɗowan a kà jak anan anà njavar uno hinen: “Iken nə wayaw?” cəna, kà slak aday ɗo sə lavay nga ahay ti halay nga sa gan sariya. Kuwaya kà jak anan anà njavar uno hinen: “Iken ka san Mbərom bay” ɗukwen, 'am ata kà slak sa ban anan apan aday sa lar anan à dəlov sə uko inde coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Anga nan, kak iken ka nak ù doh sə mazlaɓ a Mbərom tə way a à alay inde coy, əna kə jalak pə way inde à wulen a kwanay tə njavar uno hinen anga kə nəsek anan cəna, ");
INSERT INTO mqbNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mbəsak anan way anak à man ata aday, zla, pəlay ahay ayaw ana ɗowan anak ata, aday ki may ahay saa var way anak ata anga Mbərom a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Kak ɗowan a kə̀ zlahak apak, aday ki sa zlen àga ɗo sa ga sariya cəna, pəlay panan asan zek pə cəveɗ. Bina kà sak a dəzle tə iken àga ɗo sa ga sariya coy nà, ɗo sa ga sariya i sa varan iken à alay inde anà suje ahay. Tinen ite ti sa dərazl iken ù doh sə dangay. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nen apan ni jak tə ɗiɗem a həna: Hus pə ananak saa hamay anan way anahan ata bay cəna, ti mbəsakay ahay iken ù doh sə dangay ata wa bay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Kə slənen 'am a Mbərom a sa ja ata zle, a wa: “Kâ ga mədigweɗ bay.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Əna ni jak ikwen həna kutok nà, kuwaya fok, ɗowan a kà cak pə ɗo uwar a tə iɗe sa ga apan ubor cəna, ata kà gak mədigweɗ à mivel anahan inde tə uwar ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Matanan kutok, kak iɗe sə alay puway anak i sapat iken sa ga ines nà, ndaha anan, aday lar anan dəren pi zek anak wa. Anga suwan hawal si zek anak kərtek a â lize tə winen zek anak a fok sa saa lize à məke sə mərda inde nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Matanan re, kak alay puway anak i sapat iken sa ga ines nà, gaɗ anan, aday lar anan dəren pi zek anak wa. Anga suwan hawal si zek anak kərtek a â lize, tə winen zek anak a fok saa lize à məke sə mərda inde nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«'Am a Mbərom a ja, a wa: “Kuwaya ɗowan a kə̀ rəzlak anan uwar anahan cəna, â varan ɗerewel à alay inde sə ɗakay anan nà, kə̀ rəzlak anan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Əna nen ni jak ikwen həna kutok nà, kuwaya ɗowan â saa razl anan uwar anahan bay, si kak a ban atan pi zek tu ɗo aday. Aday uwar ma razl a kà zlak à mbaz hinen, uwar ata kà gak mədigweɗ cite re. Matanan, ɗowan a kə̀ gəɓak uwar ma razl a cəna, kà gak mədigweɗ cite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Asa, kə sənen zle, Mbərom a jan anà bije a kwanay ahay nà: “Ga anan way anak sə mbaɗay apan ata awan. Kə mbaɗak pa 'am a Mbərom ɗukwen, rah anan ambaɗay anak ata lele.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Əna nen ni jak ikwen həna kutok nà, kâ saa mbaɗay bay jiga awan: kwa â ga nə tə bagəbaga mburom, anga winen nə man sə njahay ana Mbərom; ");
INSERT INTO mqbNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kwa â ga nə tə daliyugo, anga winen nə man sa ɗaf saray ana Mbərom; kwa â ga nə tə Urəsalima ɗukwen, kə̂ mbaɗay anan bay, anga winen wulen su doh ana Mbərom Ba Məduwen. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kâ saa mbaɗay anan kwa ta nga anak bay, anga ki mba apan sə mbəɗa anan sibœk sa nga anak bay, kwa â ga nə zənzen awan, kwa â ga nə kweɗekkweɗek awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ki ja lele awan aɗəka cəna, “Ayaw” kak matanan nà, na, “A'ay” kak matanan bay cite nà, na. Anga 'am a sa ja azar aya nà, sa var nə Fakalaw.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Kə slənen 'am a Mbərom a sa ja ata zle, a wa: “Kak ɗowan a kə̀ nəsek anak anan iɗe, ki nəsen anan iɗe cite. Kak ɗowan a a kaɗak anan nə slan, ki kaɗan anan uda slan a cite.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Əna nen ni jak ikwen həna kutok nà, kâ si men anan anan uda sikeɗ sə ines anà ɗo sə huwan ahay bay. Kak ɗowan a kə̀ dəcak anak pə cakay sləmay kərtek a nà, mbəɗahan anan apan cakay sləmay hinen re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kak ɗowan a a nan sa zlah apak anga aday i ngəzar panak zana anak məduwen a cəna, mbəsakan anan apan tegwere sə zana ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Matanan, kak ɗo kà gak anak bəlaray sə tavak way anahan kilomiter kərtek nà, tavakan anan way sə kilomiter cew lele. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɗowan a kə̀ cəcihek panak way cəna, kâ sa gan anan azay bay, varan. Matanan re, ɗo kə̀ cəcihek panak gudire ɗukwen, kâ saa ngaman anan bay ata bay. Varan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Kə slənen 'am a Mbərom sa ja, a wa: “Pəlay anan ɗo sə məsudoh anak, aday nan iɗe anà ɗo maniɗe anak ite.” ");
INSERT INTO mqbNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Əna nen ni jak ikwen nà: Pəlen anan ɗo maniɗe a kwanay ahay, gen amboh anga ɗo sə jugwar pikwen wa 'am ahay fok, ");
INSERT INTO mqbNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","anga aday kî gen way təɗe anga wan ana Bəbay a kwanay Mbərom, winen à bagəbaga mburom. Winen kəma, a dav anan pac anahan nà, pu ɗo lele aya tu ɗo lelibay aya təke fok. A ga iven anahan pu ɗo sa ga mer su way lele aya tu ɗo sa ga mer su way lelibay aya təke fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kak kə pəlen nə ɗo sə pəlay kwanay ahay ɗəkɗek nà, ki ben magwagway sa ma a kwanay pə Mbərom wa asa re anaw? Ɗo sə cakal jangal ahay ɗukwen ta ga matanan re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kak ki jen anan 'am anà zek a kwanay ahay ɗəkɗek nà, ata ki gen way lele sə zalay ɗo azar aya ɗaw? Kwa ɗo sə pəra ahay ɗukwen ta ga nə matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Təren ɗo lele aya à way ahay inde fok, kawa Bəbay a kwanay Mbərom, winen mə njahay a à bagəbaga mburom winen ɗo lele à way ahay inde fok ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kwanay apan ki gen anan sumor anà ɗo nà, kâ si gen anan pa 'am sə ɗo ahay anga aday tə̂ canak ikwen bay. Bina, Bəbay a kwanay Mbərom, winen à bagəbaga mburom ata i varak ikwen magwagway sabay. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Kak kə njaɗak way sa man anan zek anà ɗo nà, kâ sa zlapay anan awan aday saa varan anan bay. Sa ga way ata matanan cəna, ɗo sə mbaɗəmbaɗa ahay. Ta ga matanan nà, ù doh sə wazay ahay, aday à lumo ahay, anga aday ɗo ahay tə̂ həran atan nga. Nen apan ni jak ikwen tə ɗiɗem a həna, tə njaɗak anan magwagway a tinen a coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Əna iken kəma, kak a nak sa man zek anà ɗo nà, ga anan tə wurwer awan. Kwa ɗo inde pə cakay anak ɗukwen â san apan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ga sumor anak nà, à miɗer a inde. Ata Bəbay anak Mbərom ɗukwen i varak magwagway. Winen nà, a canan anà way ma ga à miɗer a inde ataya fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«À alay a ki gen amboh ɗukwen nà, kâ sa təren kawa ɗo sə mbaɗəmbaɗa ahay bay. Tinen nə, a nan atan sa ga amboh nà, ti tavay jərek ù doh sə wazay ahay, kabay pə məgəzləga cəveɗ ahay, anga aday ɗo ahay tâ ca patan lele. Nen apan ni jak ikwen tə ɗiɗem a həna, tə njaɗak magwagway a tinen coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iken, a nak sa ga amboh kəma, zla ù doh, tacay anan məsudoh lele, gan amboh anà Bəbay anak Mbərom. Mbərom nà, winen inde à man a mi ɗer ata awan. A canan anà way anak ma ga à man a mi ɗer ata re, i varak anan way anak a sə cəce panan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kwanay apan ki gen amboh ata ɗukwen, kâ sa zilen anan 'am aya zeɗeɗeɗe bay. Sə zalan anà 'am nà, ɗo sə pəra ahay. A ga patan nə Mbərom i təma amboh a tinen anga tə zalak anan anà 'am bayak a ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kâ si gen kawa ana tinen ata bay, anga Bəbay a kwanay awan aday nà, a san way a kwanay a saa cəce panan wa ata zle, mənjəna kwanay sə dazlan anà amboh awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Kwanay ki gen amboh kəma, gen nə natiya awan: Bəbay a manay, iken à bagəbaga mburom, ɗo ahay tâ san sləmay anak nə cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bahay anak â ga zek à wulen à manay ite. Way anak sa gan may â təra à wulen a manay pə daliyugo, kawa anahan sə təra à bagəbaga mburom ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Varan umo way sa pa saa slan umo biten ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pəsen umo anan ines a manay ahay, kawa ana manay sə pəsen anan anà ɗo sa gan umo ines ataya cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ba manay pə way saa njak manay ahay wa ite, anga aday mâ sa zla ì ines inde bay. Dərgwaɗay manay à alay ana Fakalaw a wa. Anga bahay nà, iken. Məgala anak tə mazlaɓ anak nà, inde sə coy. Amen. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kak kwanay apan ki pəsen anan anan ines anà ɗo sa gak ikwen ines ahay nà, Bəbay a kwanay, winen mə njahay a à bagəbaga mburom ata ɗukwen, i pəsek ikwen anan ines a kwanay ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Əna ka sak a pəsen anan anan ines anà ɗo azar aya bay cəna, Bəbay a kwanay ɗukwen i pəsek ikwen anan ines ahay bay ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Kwanay apan ki gen sumaya nà, kâ si ken anan iɗe a kwanay kawa kwanay ma ga mugo aya bay. Ɗo sə mbaɗəmbaɗa ahay nà, ta ga matanan. Tinen apan ti rac jœr aday ɗo ahay tâ san tinen apan ti ga sumaya. Əna nen apan ni jak ikwen həna, tə njaɗak anan magwagway a tinen coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Əna, iken ki ga sumaya nà, banay anan iɗe anak, ga apan amar lele, ");
INSERT INTO mqbNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","anga aday ɗo ahay tâ san iken apan ki ga sumaya bay jiga awan. Bina saa san anan way anak sa ga fok nà, si Bəbay anak Mbərom. Winen inde à man a mi ɗer ata awan. A canan anà way ata zle, aday i varak anan magwagway anak. Winen nà, a canan anà way mi ɗer aya fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Matanan kutok, kâ sa hilen anan nga anà way ahay pə daliyugo a anan anga kwanay a bay. Anga pə daliyugo a anan nà, mumok ahay inde, zəɓzeɓ sa ján mangaz pə way ahay ɗukwen inde, ti nes anan way ata fok. Aday ɗo sə akar ahay ɗukwen ti zlar anan doh ahay aday ti kəra anan way a kwanay sə halay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Əna hilen anan way anà nga a kwanay aɗəka nà, à bagəbaga mburom. À man ata nà, mumok ahay tə mangaz ɗukwen ti nes anan sabay. Aday ɗukwen ɗo sə akar ahay ti zlar anan doh aday sə kəra way ahay sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Anga, zlile anak ma ɗaf a à man ata nà, mivel anak a ɗukwen i ga nə cezlezlen'e à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Iɗe nà, kawa lalam sə dəvan jiyjay anà zek. Kak iɗe anak winen lele nà, ata zek anak a fok winen à jiyjay a inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Əna kak iɗe anak lelibay nà, zek anak a fok winen ì iɗe zənzen a inde. Saa varak jiyjay a nə ma asa anaw? Kak iɗe anak kə̀ tərak iɗe zənzen a nà, takəɗimbomma iken à luvon inde acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ɗowan saa mba apan sa gan mer su way anà bahay su doh ahay cew nà, ibay. Anga kə̀ pəlak anan ɗo kərtek a lele nà, i nan iɗe anà ɗowan a hinen ata awan. Kabay, tə njahak tu ɗo kərtek a lele gerger cəna, i kəɗey anan ɗowan a hinen ata awan. Matanan, ki mben apan sa gan mer su way anà Mbərom aday sə pəlay dala cew maya ɗukwen, i ga zek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Nen apan ni jak ikwen asa: Kâ sa jilen pə way sa pa tə zana bay. Sifa si zek a zalay way sa pa, aday zek ɗukwen a zalay zana asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cen pə məvuhom ahay aday. Ta casl awan bay, ta car awan bay, tə halay awan itəbay. Əna Bəbay a kwanay a mə njahay a à bagəbaga mburom ata, winen apan i gan atan sumor ta sə varan atan way sa pa. Aday kwanay kə zilen anan məvuhom ahay biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Waya à wulen a kwanay saa mba apan tə ajalay nga anahan sə zəga anan apan luvon sə njahay anahan mənjœk anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Kak matanan cukutok nà, kə jilen pə zana kə̀ zalak nə angamaw? Ənga, cen pə avərez sə way ahay sa hay ahay à kiɓe ataya aday! Ta ga mer sə awan bay, ta han awan pi zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tə winen ata təke nà, nen apan ni jak ikwen: Kwa abay bahay Sulimanu tə zlile anahan a bayak ata təkeɗe nà, kula kə̀ pəkak zana lele aya pi zek kawa avərez sə way ahay à kiɓe ataya bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aday Mbərom winen apan i rəɓa anan daslam sə kiɓe, tinen inde biten lele, aday sidew a cəna ti i han anan uko tə daslam ataya re. Kwanay ɗo ma kac aɗaf nga a anan aya awan, kak Mbərom kà mbak apan sa ga mer su way matana nà, i mba apan sə pəkak ikwen zana pi zek lele aya zal way ahay, à kiɓe ataya biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Matanan kutok, kâ sa viwen anan nga anà zek a kwanay tə ajalay nga pə way sa pa, pə way sa sa, kabay pə zana sa pak pi zek ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sə pəlay way matanan ataya cəna, ɗo sə pəra ahay. Aday Bəbay a kwanay Mbərom a ɗukwen a san zle, kwanay ki gen anan may anà way ataya way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Əna lihen aɗəka sə pəlay bahay a Mbərom aday ɗiɗek anahan awan. Ata winen a, i varak ikwen way a kwanay a sa gan may ataya fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kâ sa viwen anan nga anà zek a kwanay tə ajalay nga pə way sə sidew bay, anga sidew ata ɗukwen i gan nga anà zek anahan a cite. Pə iɗe sə cəɗe fok, way anahan aya inde i sla saa bayak apan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Kâ si men anan anan mungok ù ɗo azar aya à mivel inde bay, anga aday Mbərom â sa mak ikwen anan mungok bay ite. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anga Mbərom i mak ikwen anan mungok nà, kawa ana kwanay sa man anan mungok anà ɗo ahay ata cite. I lavak ikwen way nà, tə way mbala ana kwanay sə lavan anan anà ɗo ahay ata cite re. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Iken nà, ka mba apan sə canan anà cukol ì iɗe ana mərak anak inde, aday dədom ì iɗe anak a inde nà, ka mba apan sə canan sabay ata nà, angama kutok anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka mba apan sa jan anà mərak anak: “Hayak anan, nə̂ gəɓak anan cukol ì iɗe wa!” aday cəkəbay dədom zləlngəɗɗa ì iɗe anak a inde nà, kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mbaɗəmbaɗa biɗəka! Gəɓay anan dədom ì iɗe anak a wa aday! Ata ki mba apan sə canan sə gəɓay anan ahay cukol ì iɗe anà mərak anak wa kutok cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Matanan, kâ sa viren anan anan way cəncan a anà kəla ahay bay, anga ti sa may ahay pikwen, ti ngalay kwanay awan. Kâ sa viren anan anan mədine a kwanay ahay anà gadura ahay bay, anga tâ sa ndərasl atan à dəndəloɓ inde bay, bina ti lize.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Cəcihen! Mbərom i varak ikwen way a kwanay sə cəce ata awan. Pəlen! Ki ten anan à nga anà way a kwanay a sə pəlay ata awan. Jen 'am pi zek wa uho, aday ti təɓak ikwen ayak wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anga kuwaya kə̀ cəcihek way cəna, ti varan. Kuwaya kə̀ pəlak way ɗukwen, i njaɗ way anahan a sə pəlay ata awan, aday kuwaya kà jak ayak 'am uho wa ɗukwen, ti təɓan ayak wa cite re. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Matanan re, waya à wulen a kwanay saa varan kon à alay inde anà wan anahan, anga a cəce panan wa ɗaf anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kabay kak wan a a cəce nə kəlef nà, ki varan dədew à alay inde bay re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwanay ɗo lelibay aya bugol ɗukwen, kə sənen a viren anan way lele aya anà wan a kwanay ahay. Aday Bəbay a kwanay Mbərom, winen à bagəbaga mburom ata nà, a san sə varan way lele aya anà ɗo sə cəce panan wa way ahay zal mbala a kwanay sa san biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Way a təɗe abay ki gen anan may ɗo ahay tâ gak ikwen anan ataya fok nà, lihen apan sa gan atan anan aday. Anga way a mə vinde aya à Tawrita inde, aday à Deftere ana ɗo maja'am a Mbərom ahay inde fok nà, tə dazlan nə ta 'am ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Zlen tə məsudoh a mə mbəɗec a njulehwehwe ata awan. Anga məsudoh a zləbatam ata aday cəveɗ anahan a ɗukwen ma da 'am a bay ata nà, a dəzle ɗo nà, à man sə lize. Ɗo sa zla ta man ataya nə bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Əna məsudoh a mə mbəɗec ata aday cəveɗ anahan a ɗukwen ma da 'am ata nà, a dəzle ɗo nà, à man sə sifa sa ndav bay ata awan. Ɗo sa zla ta man ataya nà, tinen bayak aya itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Bənen nga a kwanay lele pu ɗo maja'am a Mbərom mungwalay aya wa. Ti zlak ayak à wulen a kwanay ahay inde nà, tinen kawa təman ahay, aday cəkəbay tinen nə kawa kəla kiɓe ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ki sənen atan nà, pi mer su way a tinen aya wa. Anga jəgem i wahay buway kulibay. Matanan iyam ɗukwen i wahay maka kulibay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Matanan dədezl si sé lele awan, i wahay wan lele cite re. Sé lelibay a ɗukwen i wahay wan lelibay aya cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sé lele cəna, i wahay wan lelibay a kulibay, sé lelibay ite, i wahay wan lele aya kulibay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sé sə wahay wan lele aya bay ata cəna, ti gaɗ anan, ti lar anan ù uko inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Matanan, ki sənen anan ɗo maja'am a Mbərom mungwalay aya nə pi mer su way a tinen aya wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Sənen anan pi zek wa lele re: Saa zla à bahay a Mbərom inde nà, ɗo sə ngumo “Bahay, bahay” ataya fok bay. Əna saa dəzle cəna, ɗo sa ga way kawa sa zlan à nga anà Bəbay uno, winen mə njahay a à mburom ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kə̀ dəzlek pə luvon saa ga sariya ata asanaw nà, ɗo ahay bayan aya ti ja: “Bahay, bahay, ma mak anan anan 'am a Mbərom anà ɗo ahay tə sləmay anak, mə rəzlak anan setene ahay tə sləmay anak, ma gak masuwayan sə way ahay bayak a tə sləmay anak a re.” ");
INSERT INTO mqbNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Əna ni jan atan nà: “Kula nə sənak kwanay a bay jiga awan. Zlen ayak à man uno wa, kwanay ɗo sa ga sədœk ahay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Natiya kutok, ɗowan a nə kuwaya kə̀ slənek 'am uno a anaya, aday kə̀ ɗəfak anan apan lele cəna, winen a a ga minje tə ɗowan a inde ma san way awan, winen a han anan doh a anahan pə pəkəraɗ. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iven a ga, zəlaka a haway, aday vəvara a ga, a ɓal anan doh ata, əna hwiya kə̀ mbəzlak anan bay, anga doh ata ma han a pə pəkəraɗ. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aday ɗowan a kə̀ slənek anan 'am uno a anaya, aday kə̀ ɗəfak anan apan bay ite nà, ata winen a ga minje tə ɗowan a inde ma san way a bay awan. Winen a han doh anahan pə wiyen. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iven a ga, zəlaka a haway ahay, vəvara a ga, a ɓal anan doh ata awan, a mbazl gərep gərep hele hele.» ");
INSERT INTO mqbNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu a ndav anan 'am anahan ataya cəna, wazo anahan ata a gan wadan wadan anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Anga winen a ɗakay anan way nə kawa ɗo sə mazlaɓ bina, kawa miter sə Tawrita ahay itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu a ndav anan atətak way anahan ataya nà, a dazay ahay à ɓəzlom ata wa, aday ɗo ahay bayak a tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ɗowan a inde à man ata, winen ɗo mə dugwaɗ awan. A zlak ayak pə cakay ana Yesu, a dukwen gərmec ù vo, a wa: «Ba Məduwen, kà zlak anak à nga nà, ki mba apan sa mbar nen aday zugol uno â ndav ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu a ndəɗoy anan alay anahan, a laman, aday a jan kutok, a wa: «U no, mbar! Zugol anak kə̀ ndəvak.» Kwayan'a ɗowan a mə dugwaɗ ata a mbar acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu a jan asa, a wa: «Sləne lele, kâ sa təkəren ləbara a anan anà ɗowan bay, əna zla saa kan zek anà ɗo sə gəɗan dungo anà way anga Mbərom, â zəzor iken. Aday varan way a Mbərom kawa ana Tawrita a Musa sa ja ata awan, aday ɗo ahay tâ san apan zugol anak kə̀ ndəvak.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Natiya kutok, Yesu a zla à wulen su doh sə Kafarnahum. Bahay sə suje ahay a inde à man ata awan, winen nà, Ruma ahay. A həɗek pə cakay ana Yesu saa cəce panan maməzek. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A jan, a wa: «Ba Məduwen, ɓile uno a inde, winen mə nahay a àga nen. Winen ma mac saray aya awan, a ga ɗəce tə mindel.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu a mbəɗahan apan, a wa: «Ni zlak ayak saa mbar anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bahay sə suje ata a jan, a wa: «Ba Məduwen, na slak aday sa jəka ki zla àga nen ata bay. Əna ja 'am a kərtek cəna, ɓile uno ata i mbar asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nen a aday nà, bahay uno ahay ɗukwen inde, aday nen nə bahay sə lavan nga anà suje ahay bayan aya re. Na sak a jan anà ɗowan a kərtek a: “Zla tiya”, i zla. Na sak a jan anà ɗo hinen: “Hayak à man a anan”, i nay ahay. Na sak a jan anà ɓile uno: “Ga natiya”, i ga anan acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu a sləne 'am anahan ataya cəna, a zlan à nga lele. A jan anà ɗo sə pərahan azar ataya awan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kula na tak anan à nga anà ɗo sa ɗaf upo nga lele kawa ɗowan a anan à wulen su ɗo sə Isəra'ila ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni jak ikwen: Ɗo ahay bayak a, ti i halay ahay nga kwa pə daliyugo ahay wa fok, ti i pa way à bahay a Mbərom tatə Ibərahima, tatə Isiyaku, aday tatə Yakob. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Əna ɗo sa jəka tinen abay mə walay aya bugol saa pa 'am sə bahay a Mbərom ataya nà, ti gucey atan uho ì iɗe zənzen a inde. À man ata nà, ti i yam aday ti i rac slan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu a dazlan sa jan anà bahay sə suje ata awan, a wa: «Zla way anak agay! I tərak kawa ananak a sa ɗaf upo nga ata awan.» À alay ata awan ite, ɓile anahan ata a mbar acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aya, Yesu a zla àga Piyer. A dəzle cəna, a tan ayak à nga anà jəje ana Piyer nà, winen mə nahay a, nga a ɓərzlan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu a laman alay anà uwar ata awan, aday nga a sə ɓərzlan ata a ndalay panan. A slabak, a dan way sa pa anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Suko anahan a ga cəna, ta ran ahay ɗo sə ɗəvac azar aya bayan awan, tinen tə setene aya à nga inde. Yesu a razl anan setene ahay ta 'am anahan sa jan atan, aday a mbar anan ɗo sə ɗəvac ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A ga matanan ata aday 'am ana ɗo maja'am a Mbərom Ezaya sa ja ata â təra, a wa: «Winen nà, kə̀ gəɓak puko wa bəle a mənuko, kə̀ tavakak anan puko wa ɗəvac ana mənuko ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu a canan anà man su ɗo pə cakay anahan ata nà, a jan anà njavar anahan ahay tə̂ takas way a tinen pa day uho sə bəlay. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Miter sə Tawrita a inde, a həɗəken ayak pə cakay ana Yesu, a jan, a wa: «Miter, nen ni pərahak azar kwa aha fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu a mbəɗahan apan, a wa: «Hwehwe ahay nà, məke a tinen ahay inde, məvuhom sa nga mburom ahay ɗukwen, doh a tinen ahay inde, əna nen Wan su Ɗo nà, man sə nahay uno inde saa man uda ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɗowan a maza à wulen sə njavar a Yesu ahay wa a jan, a wa: «Ba Məduwen, u no sə pərahak azar, əna vuro cəveɗ nâ zla agay, nâ saa lay anan ahay bəbay uno aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu a mbəɗahan apan ite, a wa: «Mbəsak anan məsinde ahay tâ la məsinde a tinen ahay. Iken, hayak, pəruho azar.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pə dəɓa anahan a wa nà, Yesu a ján way anahan à kwalalan inde tə njavar anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tinen apan ti zla kutok, vəvara məduwen a a slabak kwayan'a pa nga sə a'am. Məsugurndolon sə miresl sə a'am a slabak, a njəvek ayak à kwalalan inde. Ata Yesu nà, winen apan i njak ahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Njavar anahan ataya ta nay apan, tə pəɗek anan, ta jan, ta wa: «Ba Məduwen, mənuko apan ɗi lize. Tam mənuko ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu a mbəɗahan atan apan, a wa: «Kə jəjiren nà, angamaw? Kə ɗəfen upo nga bayak a bay kələɗaw?» Coy Yesu a slabak hərom, a gafan 'am anà maɗ, a jan anà məsugurndolon sə a'am ahay tə̂ mbəsak sa ɓal. Ɗekek, atə maɗ tə a'am tə tavay acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Way ata a gan masuwayan anà ɗo ataya bayak awan. Anga nan ta ja, ta wa: «Ɗowan a anan ata nà, ɗo maw? Kwa atə maɗ tə məsugurndolon sə a'am ahay ɗukwen tə ɗəfan apan!» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pə dəɓa anahan a wa nà, Yesu a dəzle pa 'am sə bəlay, pa day uho su kon sə Gadarena ahay. À man ata nà, ɗowan aya inde cew, tə setene aya à nga inde. Tinen aday nà, ta ga zlawan cəveɗabay. Anga nan, ɗo ahay tə mbəsakak sa zla ta man ata awan. Ɗowan ataya ta nay ahay à wulen sə jəvay ahay wa, tə zlangay tatə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tə canan à Yesu cəna, ta zlah pi zek, ta wa: «Iken Wan a Mbərom, kə pəlay pumo wa həna kwayan'a nə maw? Ka nak sa naa ga alay tə manay kwayan'a mənjəna alay a Mbərom sa ɗaf ata sə dəzley ahay ca ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta man a tinen ata dəren mənjœk nà, gadura ahay inde, tinen apan ti rac apa. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Setene ataya tə cəce pə Yesu a wa, ta wa: «Kak a nak sa razl manay nà, varan umo cəveɗ mə̂ ndərmaɗ à gadura a anaya inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu a jan atan kutok, a wa: «Zlen uda awan!» Tə zləray ahay ù ɗo ataya wa, ta zla à gadura ahay inde. Gadura ahay fok ite, ta haw kwa pa zar kon wa, tə dazak ayak kwa pa 'am məgujeguje wa à bəlay inde, tətah, tə lize uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ɗo sa gan nga anà gadura ataya ta haw à wulen su doh. Ta jan anà ɗo ahay way a sə təra pu ɗo cew ataya awan, aday pə gadura ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɗo sə wulen su doh ahay fok, ta nay saa zlangay tə Yesu. Tə canan cəna, tə dubok anan Yesu, aday â zla ù kon a tinen ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Natiya kutok, Yesu a ján à kwalalan inde maza awan, a takas bəlay, a ma way anahan à Kafarnahum, wulen su doh anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","À wulen su doh ata wa, ɗowan aya inde tə gəɓan ahay ɗo pə lala, winen mə təra à məndak awan. Yesu a canan anà aɗaf nga a tinen ata cəna, a jan anà ɗowan a mə təra à məndak ata awan, a wa: «Dəna uno, kə̂ jalay awan sabay. Nə pəsek anan ines anak ahay coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aya əna, miter sə Tawrita ahay inde à man ata awan, tə jalay nà: «Ɗowan a anan, winen apan i jənan pa 'am anà Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu a san abayak nga a tinen ata zle coy. Anga nan a wa: «Kə jilen way lelibay a matanan à mivel a kwanay inde nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ma da 'am a nə maw? Sa ja: “Nə pəsek anan ines anak ahay” ata ɗaw, kabay sa ja: “Slabak, zla” ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Əna u no kə̂ sənen apan lele, nen Wan su Ɗo nà, məgala uno inde sə pəsen anan ines à ɗo ahay pə daliyugo.» A jan anà ɗowan a mə təra à məndak ata: «Slabak, gəɓa lala anak, zla agay!» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɗowan ata a slabak, a zla way anahan agay acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ɗo ahay tə canan anà way ata cəna, tə jəjar pi zek, aday tə həran nga anà Mbərom, anga kə̀ varak anan mazlaɓ matanan ata anà ɗo zənzen aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu a slabak à man ata wa asa, a zla way anahan. Winen apan i zla ata nà, a canan à ɗowan a inde tə ngaman Mata, winen mə njahay a ù doh sə cakal jangal. Yesu a canan cəna, a jan: «Pəruho azar!» Mata a slabak, a pərahan azar acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tə njahay pə tuwez àga Mata kutok, Yesu tə njavar anahan ahay. Aday ɗo sə cakal jangal ahay tu ɗo sə atahasl azar aya bayak a ta zlak ayak re. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisa ahay tə canan anà way ata cəna, tə cəce pə njavar anahan ataya wa: «Miter a kwanay nà, a pa way pə kərtek a tu ɗo sə cakal jangal ahay, aday tu ɗo sə atahasl ahay nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu a sləne anan lele nà, a jan atan, a wa: «Ɗo ɗəvac a bay cəna, a gan may anà ɗo sə disise bay, si ɗo sə ɗəvac ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aɗəka bay, zlen saa tətak nà, 'am a ma ja à Deftere a Mbərom inde a anan: “U no ɗo ahay tâ gan sumor ì zek ahay, bina u no tə̂ vuro gənaw ma sla dungo aya bay.” Nen a aday ɗukwen, na nay ahay sa naa ngaman anà ɗo sa ga way lele ataya bay. Əna na nay ahay nà, sə ngaman anà ɗo sə atahasl ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Natiya kutok, njavar a Yuhana ahay tə cəce pə Yesu wa, ta wa: «Manay tə Farisa ahay, ma ga sumaya kutok nà, njavar anak ahay nə ta ga itəbay angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu a mbəɗahan atan apan, a wa: «A ga pikwen nà, ɗo mə ngamay aya à man sə gəɓa dalay nà, ti mba apan sa ga sumaya itəɗaw? Matanan bay! Əna pa pac a ɗo sə gəɓa dalay ata, tə bənak anan à wulen a tinen wa nà, ata ti ga sumaya kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Matana re, waya sə tapay zana wiya a pə zana anahan məduwer a anaw? Ibay. Anga à man sə banay anan nà, məgabal sə zana wiya ata i zəga anan apan məke ana zana məduwer ata awan, i ngəraw. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Matana re, ɗowan sa mbaɗ mahay mə kwasay a bay a à mbulo sa zlay məduwer a ɗukwen ibay. Anga mahay mə kwasay a bay ata kà sak a kwasay nà, i ngəraw anan mbulo sa zlay a məduwer ata awan, aday mahay ɗukwen i mbaɗ à məndak, mbulo sa zlay kə̀ nəsek asa re. Anga nan, suwan sa mbaɗ mahay mə kwasay a bay à mbulo sa zlay wiya awan. Ata, awan saa nes ɗukwen ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu winen apan i ja 'am anahan ataya nà, ɗowan inde winen bahay awan, a zlak ayak. A dukwen gərmec ù vo anà Yesu, a jan, a wa: «Dəna uno kə̀ məcak həna. Hayak àga nen. Kâ ɗaf apan alay anak aday â mbar ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Atə Yesu tə njavar anahan ahay tə slabak, tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uwar a inde à man ata ite, winen ɗəvac a, ava kuro nga cew. Mez winen apan i pəkan ahay à kutov wa. Anga nan, a nay ahay à wulen sə ɗo ahay ta sə dəɓa a Yesu. A dazlan, a laman alay nec anà 'am sə zana ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A jalay nà: «Kak nə njaɗak sə laman anà zana anahan a cəna, ni mbar asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ite a mbəɗa 'am pə uwar ata, a canan, aday a jan: «Mazar uno, kə̂ jalay awan bay, aɗaf nga anak pi nen ata kə̀ mbərak iken.» À alay ata awan ite, uwar ata a mbar acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu a dəzle àga bahay ata awan. A canan anà ɗo sa fa gingec ataya pi zek tu ɗo sa yam ataya fok nà, ");
INSERT INTO mqbNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a jan atan, a wa: «Zlen à man a anan wa, anga dəna a anan kə̀ məcak bay. A njak ahan ca.» Man su ɗo ataya tə mbasay apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ta razl anan ɗo ahay fok uho lele nà, Yesu a zla ù doh à man sə məsinde, a bənan anan alay anà dəna ata awan. Dəna ata a slabak hərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Matana kutok, ləbara ata a ta 'am təɗay pə daliyugo ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu a slabak à man ata wa asa, a zla way anahan. Pə cəveɗ anahan ata kutok, hurof ahay cew tə pərahan ayak azar, tinen apan ti zlah, ta wa: «Iken wan a Dawuda, mâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu a zla ù doh lele nà, hurof ataya tə həɗəken ayak pə cakay. Yesu a cəce patan wa, a wa: «Kə ɗəfen upo nga ni mba apan sa mbar kwanay acəkan ɗaw?» Tə mbəɗahan apan, ta wa: «Ayaw, mə ɗəfak apak nga.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Natiya kutok, Yesu a laman atan alay pə iɗe, aday a wa: «Â tərak ikwen kawa ana kwanay sə ɗəfay upo nga ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iɗe a tinen ahay tə təɓa acəkan ngurret. Pə dəɓa wa nà, Yesu a gafan atan 'am pi zek wa lele, a wa: «Kâ sa təkəren anan 'am a anan anà ɗowan bay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Əna tinen ta zla cəna, tə təker anan ləbara a Yesu kwa aha pə daliyugo ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɗowan a abay hurof ataya tinen apan ti zla way a tinen mba, ɗo ahay tə gəɓan ahay ɗowan a inde anà Yesu. Ɗowan ata a ja 'am bay, winen maandak awan, anga setene inde anan à nga. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu a razl anan setene ata awan, aday ɗowan a maandak ata a dazlan sa ja 'am kutok. Way a sə təra ata a gan masuwayan anà ɗo ahay. Anga nan ta ja, ta wa: «Way kawa həna anan ata, ɗowan kə̀ canak anan kula à Isəra'ila bay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aya əna, Farisa ahay ta wa: «Sə varan məgala sa razl anan setene ahay nà, bahay sə setene aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu a bar à wulen su doh ahay, aday a zla pu kon pu kon. Winen apan i tətakan anan way anà ɗo ahay ù doh sə wazay ahay. A taa wazan atan ləbara sə bahay ana Mbərom mugom awan. Kə̀ mbərak anan ɗo sə ɗəvac a tinen ahay fok, pi zek tu ɗo mə təra à məndak aya fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu a canan anà man su ɗo ata cəna, ta gan ì zek wa, anga ta yak nga, tə dawarak kawa təman mənjəna ɗo sa gan atan nga ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Natiya kutok, a jan anà njavar anahan ahay, a wa: «Way sa pa inde à guvo bayak a sə halan nga, əna ɗo sə halan nga aya ta kac ike. ");
INSERT INTO mqbNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Suwan gen anan kem anà bahay sə guvo awan, â zəga anan ɗo ahay à guvo, anga sə halan nga anà way sa pa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Natiya awan, Yesu a ngaman anà njavar anahan kuro nga cew ataya pə cakay anahan. A varan atan məgala sa razl anan setene ahay, aday sa mbar anan ɗo sə ɗəvac ahay fok, tu ɗo mə təra à məndak aya fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sləmay su ɗo maslan anahan a kuro nga cew ataya nà, həna: mama'am awan, Simon, ɗowan a Yesu sə ngaman Piyer ata awan, tinen tə mərak anahan Andəre. Yakuba tinen tə mərak anahan Yuhana, tinen wan ana Zebede ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip tə Bartilome, Tomas tə Mata ɗo sə cakal jangal ata awan, Yakuba wan ana Alfa, Tade, ");
INSERT INTO mqbNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ɗo maniɗe sə Ruma ahay ata awan, tə apan Yudas Iskariyot ɗo saa ga ɗaf pə Yesu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu a slan anan ɗo maslan anahan ahay kuro nga cew ataya ta sa jan atan: «Kâ si zlen àga ɗo sə pəra ahay bay, kâ si zlen à wulen su doh sə Samariya ahay bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kî zlen asanaw cəna, pə cakay sə Isəra'ila ahay, tinen kawa təman mə lize ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","À man a kwanay sa zla fok, ɗiken atan anan nà: “Bahay a Mbərom winen bəse tə kwanay coy.” ");
INSERT INTO mqbNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbəren anan ɗo ahay à ɗəvac a tinen ahay wa. Slabiken anan ɗo ma mac aya re. Ɗo mə dugwaɗ aya ɗukwen, mbəren atan aday zugol a tinen â ndav. Rəzlen anan setene à ɗo ahay wa. Kə njiɗen məgala ata ɗukwen kəriya awan, viren anan anà ɗo ahay kəriya cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kâ sa gəɓen dala à alay bay, kwa dala sə gura, kwa sə gursa, kwa sə rəslom. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kâ sa gəɓen taɓay à alay bay, kâ sa gəɓen zana ahay cew bay, kâ si ren təkarak ahay saray cew bay, kâ sa gəɓen dəker à alay bay fok. Anga ɗo si mer su way cəna, i pa nà, way sə herreɓ anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ka sak a dəzlen à wulen su doh cəna, pəlen ɗo təɗe i təma kwanay ata awan. Njihen àga winen hus à luvon a kwanay sa zla à man hinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kwanay apan ki i dəzlen àga ɗo nà, jen atan kawa həna a anan: “Zay â tərak ikwen.” ");
INSERT INTO mqbNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ata kak ɗo su doh ataya tə təmahak kwanay nà, zay a kwanay â njahay patan acəkan. Aday kak ɗo su doh ataya tə təmahak kwanay bay ite cəna, zay a kwanay â may ahay pikwen. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Matana re, kak ɗowan aya tinen tə təmahak kwanay bay, kabay ta ngam sə sləne 'am a kwanay bay nà, zlen way a kwanay à man ata wa, aday kə̂ bəzləmen morbodok su kon a tinen pə saray a kwanay ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nen apan ni jak ikwen tə ɗiɗem a həna: Pə luvon a aday Mbərom i gan sariya anà ɗo sə daliyugo ahay ata nà, zek i naa dan anà ɗo su kon ataya zal mbala ana Sodoma tə Gomora.» ");
INSERT INTO mqbNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ni slan kwanay həna, kawa təman ahay à wulen sə kəla kiɓe ahay inde. Anga nan, təren ɗo wurwer aya kawa dədew ahay, aday njihen səkəffe kawa badəbada ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ben nga a kwanay lele pu ɗo sə daliyugo ahay wa, anga ti naa zla kwanay à man sə sariya ahay, ti naa ndaɓay kwanay ù doh sə wazay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ti naa ngəza kwanay pa 'am sə guverner ahay aday pa 'am sə bahay məduwen aya anga kwanay njavar uno ahay. Matanan ki gen side pa 'am a tinen ahay, aday pa 'am ana ɗo sə pəra ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kwa siwa siwa tə bənak kwanay à man sə sariya ahay nà, kâ sa jilen à mivel a kwanay inde: “Mi i ja həna nə maw, aday mi ja kəkəmaw?” bay. Anga ki njiɗen 'am i nak ikwen ahay à nga inde à alay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anga 'am ata i nay ahay ɗukwen à nga a kwanay wa bay. Saa jak ikwen ahay nà, Apasay a Bəbay a kwanay Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Matanan, mərak ahay ti varan anan mərak a tinen ahay anà ɗo ahay aday tâ vaɗ atan. Bəbay ahay ɗukwen ti gan anà gwaslay a tinen ahay matana re. Gwaslay ahay ɗukwen, ti slabak pə bəbay a tinen ahay aday ɗo ahay tâ vaɗ atan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɗo ahay fok ti nak ikwen iɗe anga kwanay njavar uno ahay. Əna ɗowan a kə̀ səmak anan anà ɗəce ata hus à andav a inde nà, winen i tam. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kak ɗo ahay ta gak alay tə kwanay ù kon ata nà, zlen way a kwanay ù kon hinen. Nen apan ni jak ikwen tə ɗiɗem a həna: Nen Wan su Ɗo ni may ahay nà, ki mben apan sə zlangay alay pu kon sə Isəra'ila fok aday bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Ɗo sə jangay nà, i zalay miter anahan bay. Matanan, ɗo sa ga mer su way àga ɗo ɗukwen, i zalay bahay su doh ata bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ɗo sə jangay kà sak a dəzle ù doh anà ɗo sə jangan ata awan, kabay ɗo si mer su way ɗukwen kà sak a dəzle à məduwen sə mazlaɓ ana bahay su doh ata awan, ata winen kà slak kutok. Kak aday tə ngamak uno ì nen bahay su doh “Bə'elzebul” nà, ti təra kwanay ɗo su doh uno ahay fok à məndak kə̀ zalak kutok biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Anga nan, na wa: Kə̂ jəjiren anan anà ɗo sa ga alay tə kwanay ahay bay. Way mi ɗer aya fok ti kay ahay zek uho mba, aday 'am mə səsœk aya asəsœk fok, ti sləne zek kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Way uno sa jak ikwen mənuko taayak ataya fok, jen anan pə iɗe sə ɗo ahay fok kutok re. Way a kwanay sə sləne mə səsœk asəsœk ataya nà, jen anan pə zavay wa kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kə̂ jəjiren anà ɗo sa mba apan saa ndəvak ikwen anan sifa təte ataya bay. Jəjiren anan aɗəka nà, anà Mbərom. Winen nà, i mba apan sə lize anan zlay si zek tə sifa a təke à məke sə mərda ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tə dala anak mənjœk nà, ti pəkak apan kəɗeye ahay ngwer cew biɗaw? Kəɗeye ataya nà, inde kərtek sə slahay pa nga mburom wa à məndak mənjəna Bəbay Mbərom sa gan may nà, inde ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kwanay həna ɗukwen, kwa sibœk sa nga a kwanay, tinen mə baslay aya fok kərtek kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Anga nan, na jak ikwen: Kə̂ jəjiren bay, bina kwanay kə zilen kəɗeye ahay bayak a asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Natiya, kak ɗowan a kà jak pa 'am su ɗo sə daliyugo ahay “Nen ɗo a Yesu!” nà, nen ɗukwen, ni ja pa 'am ana Bəbay uno Mbərom, winen à bagəbaga mburom ata: “Winen ɗo uno!” cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Əna ɗowan kà jak pa 'am su ɗo sə daliyugo ahay sa jəka a san nen Yesu bay cəna, nen ɗukwen ni jan anà Bəbay uno Mbərom, winen à bagəbaga mburom ata nà, na san anan bay ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Natiya asa, kə̂ jilen sa jəka na nay ahay nà, sə gəɓay ahay zay bay. Na nay sə gəɓay nə zay bay, əna maslalam. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nen na naa njak anan atə wan pi zek tə bəbay anahan, aday atə dəna dalay a pi zek tə may anahan, atə dalay sa wan pi zek tə jəje anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Saa təra pi zek ɗo maniɗe ahay nà, ɗowan aya ù doh pə kərtek ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Ɗowan a kà sak a pəlay bəbay anahan kabay may anahan zal sə pəlay nen cəna, winen kà slak njavar uno bay. Aday ɗowan kà sak a pəlay wan anahan kabay dəna anahan zal sə pəlay nen cəna, kà slak njavar uno bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kak ɗowan a kə̀ tavakak dədom anahan mə zləlngaɗ a aday kə̀ pərahak uno azar bay cəna, kà slak njavar uno bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɗowan a kà nak anan sa tam anan sifa anahan tə alay anahan a cəna, i lize anan aɗəka bugol. Əna ɗowan a kə̀ lizek anan sifa anahan anga nen ite nà, ata i njaɗ anan way anahan aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ɗowan a kə̀ təmahak kwanay, a təma nà, nen awan. Aday ɗo sə təma nen ɗukwen, a təma ɗo sə slənay ahay nen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɗowan a kə̀ təmahak ɗo maja'am a Mbərom anga winen ɗo maja'am a Mbərom cəna, i njaɗ mərdok anahan kawa ana ɗo maja'am a Mbərom ata awan. Aday ɗowan a kə̀ təmahak ɗo ɗiɗek a anga winen ɗo ɗiɗek a cəna, i njaɗ mərdok anahan kawa ana ɗo ɗiɗek ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya ɗowan a kə̀ varak anan kwa a'am mə taslay a anà ɗo ma kac a kərtek à wulen sə njavar uno a anaya anga winen njavar uno nà, i njaɗ magwagway anahan acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Natiya kutok, Yesu a ndav anan sə ɗakan anan way anà njavar anahan ahay kuro nga cew ataya cəna, a zla way anahan à man maza aya awan, anga a nan sə tətakan anan aday sə wazan anan 'am a Mbərom anà ɗo sə wulen su doh sa man ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","À alay ata ite, Yuhana ɗo sa gan baptisma anà ɗo ahay ata aday nà, winen à dangay. A sləne ləbara si mer su way ana Yesu Almasihu sa ga ataya nà, a slənay anan njavar anahan ahay ite, tâ nay pə cakay ana Yesu ");
INSERT INTO mqbNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","saa cəce panan wa: «Iken nà, Almasihu ɗowan a manay sə sləne i nay ahay mba ata ɗaw? Kabay mâ ba ɗo maza ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu a mbəɗahan atan apan, a wa: «Zlen, təkəren anan anà Yuhana nà, way a kwanay sə sləne aday way a kwanay sə canan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Hurof ahay tə təɓak iɗe, vədal ahay tinen apan ti zla tə saray a tinen, aday ɗo mə dugwaɗ aya ɗukwen, zugol inde patan sabay anga tə mbərak. Mədəngazlak ahay, tinen apan ti sləne way tə sləmay a tinen ahay re, ɗo ma mac aya tə slabakak ahay à məke wa, aday ɗo mətawak aya tə slənek ləbara sa 'am mugom awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ataslay mivel i təran anà ɗo aday kə̀ mbəsakak sa ɗaf upo nga itəbay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","À alay a njavar a Yuhana ahay tinen apan ti zla way a tinen kutok ata nà, Yesu a dazlan sa jan 'am ana Yuhana anà man su ɗo ata awan, a wa: «Ki zlen à kiɓe à man sa saf inde nà, saa cay ahay pa maw? Pə gusuko aday maɗ winen apan i ɓal anan ata ɗaw? A'ay! ");
INSERT INTO mqbNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Əna aday ka si cen ahay nà, pa ma kutok anaw? Pu ɗo aday winen ma pak zana kəlfeɗeɗe aya ata ɗaw? Ɗo sa pak zana kəlfeɗeɗe aya ɗukwen, tinen nà, ù doh sə bahay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aka aday ka si cen ahay nə pa ma kərtek a kutok anaw? Pu ɗo maja'am a Mbərom biɗaw? Ayaw, winen ɗo maja'am a Mbərom acəkan, aday nen ni jak ikwen nà, winen a zalay ɗo maja'am a Mbərom ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anga 'am inde mə vinde à Deftere a Mbərom inde, pə winen. Mbərom a wa: “Həna ni slan ɗo maslan uno, i lahak pa 'am saa ndakak anan cəveɗ lele.” ");
INSERT INTO mqbNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Nen apan ni jak ikwen tə ɗiɗem a həna: À wulen su ɗo sə njahay ahay pə daliyugo nà, ɗowan inde sə zalay anan Yuhana ɗo sa gan baptisma anà ɗo ahay ata nà, ibay. Aya əna, ɗo ma kac awan à bahay a Mbərom inde ata ite nà, winen a zalay anan Yuhana tə məduwen. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwa a bənay ahay à alay Yuhana sə dazlan sə wazan anan 'am sə bahay a Mbərom anà ɗo ahay hus ahay həna ata nà, ɗo maniɗe ahay inde ta gak vəram tə bahay a Mbərom, aday a nan atan sə ngəzar anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hus ahay pə Yuhana sə dəzley, Deftere Tawrita a Musa, tə Deftere mbala ana ɗo maja'am a Mbərom ahay fok, ta jay ahay nà, pa 'am sə bahay a Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kak ki təmihen 'am uno kəmaya, 'am ana Deftere sa ja pə amay ana Eliya ata nà, kə̀ tərak tə Yuhana kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sləmay inde pə ɗowan a sə sləne 'am a anan cəna, â sləne. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Ɗo a wuswes anaya həna ata nà, ni ga atan minje nà, ta maw? Ni ga atan minje cəna, tə gwaslay ahay sə njahay pə zavay sə wulen su doh, ti zlahan ayak anà gwaslay sa day hinen ataya, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ma fak ikwen ayak gungozl, kə gərven bay. Ma fak ikwen ayak gingec, kə yimen bay re!” ");
INSERT INTO mqbNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bina Yuhana kà nak, a pa way sa pa kəray bay, a sa mahay bay re, ta ja apan ta wa: “Winen tə setene à nga!” ");
INSERT INTO mqbNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nen Wan su Ɗo na nak, na pa ɗaf kəray, na sa mahay kəray. Tinen apan ti ja upo re, ta wa: “Cen apan! Ɗowan a anan nà, ɗo sə kutov, ɗo sə vaway nga, aday winen car su ɗo sə cakal jangal ahay pi zek tu ɗo sə atahasl ahay.” Aya əna, ɗo ahay ti san kəlire ana Mbərom winen lele, anga ti canan anà mer su way anahan sa ga ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu a dazlan, a gafan 'am anà ɗo sə wulen su doh aya aday winen sa ga uda zek məduwen sə masuwayan anahan ahay ataya awan, anga tə ngəmak sa yam pə ines a tinen ahay itəbay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","A ja, a wa: «Iken, wulen su doh sə Kurajin, yam zek anak anga ɗəce i tak à nga. Iken, wulen su doh sə Baytisada ɗukwen, ɗəce i tak à nga re. Anga abay masuwayan aya ma ga à wulen su doh a kwanay ataya, tâ ga atan à wulen su doh sə Tirus tə Sidon nà, ɗo sa man ataya ti yam pə ines a tinen ahay biɗaw? Ti pak zana sə məsinde pi zek, ti kukot rəɓa pa nga aday sə ɗakay anan tə yimak pə ines a tinen ahay tə ɗiɗek awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anga nan, nen apan ni ɗakak ikwen anan həna: Pə luvon sa ndav anan daliyugo nà, sariya ana atə Tirus tə Sidon nà, i dan atan 'am kawa ana kwanay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Iken Kafarnahum, a ga apak nà, Mbərom i cakaf wa iken à mburom ɗaw? Matana bay! Ki zla nà, à məke sə mərda aɗəka coy. Anga masuwayan aya ma ga àga iken ataya nà, abay â ga nə tinen ma ga aya nə à wulen su doh sə Sodoma nà, ata tiya winen i ga inde hus biten cite re. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Anga nan, ni jak ikwen: Pə luvon sa ndav anan daliyugo nà, sariya ana Sodoma i dan 'am kawa ananak bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","À alay ata awan, Yesu a ja, a wa: «Bəbay uno, iken Bahay sə bagəbaga mburom, iken Bahay sə daliyugo. Suse anak, anga kə ɗakak anan anan way a anaya anà gwaslay ahay, way ataya aday ɗukwen abay kə ɗərek anan pu ɗo sə kəlire ahay wa, pu ɗo sə asan way ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ayaw, Bəbay uno, ka ga matanan, anga a zlak à nga anakiken awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Matanan, a jan anà njavar anahan ahay, a wa: «Bəbay uno kə̀ varak uno anan way ahay fok. Ɗowan sa san Wan a Mbərom nà, ibay, si zek ana Bəbay Mbərom awan. Aday ɗowan sa san Bəbay Mbərom ɗukwen ibay, si nen wan anahan awan, tu ɗo aday Wan a Mbərom a gan may sə ɗakan atan anan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Kwanay ɗo ma ya nga aya, kwanay tə way ma ba aya pa nga ata awan, hayak ikwen ahay pə cakay uno, aday ki njiɗen sa man uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pərihen anan azar lele nà, anà 'am uno ahay, tətiken way pi nen wa, anga nen nə ɗo səkəffe awan, ki gen ɗəce à alay uno wa itəbay. Ata aday, sifa a kwanay ahay ti man uda awan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anga 'am uno ahay nen sa jak ikwen ataya nà, ti njahak ikwen pa may. Way nen sə ɗəfak ikwen uda pa nga ata nà, i ba pikwen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pə luvon a inde nà, Yesu tə njavar anahan ahay ta zla tə guvo sa ndaw. Njavar anahan ahay ta kaɗ ndaw aday ta pa, anga may a han patan. Əna, pac ata nà, luvon sa man uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisa ahay tə canan à way a tinen sa ga ata cəna, tə cəce pə Yesu a wa, ta wa: «Ca apan, njavar anak ahay nà, ta ga way aday təɗe abay sa ga pə luvon sa man uda bay ata nə, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu a mbəɗahan atan apan, a wa: «Kwanay kə jingen way ana Dawuda sa ga tu ɗo anahan ahay, à alay a may a han apan ata itəbay ɗaw? A ga nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawuda a zla à jawjawa sə mazlaɓ a Mbərom inde, a ray pen ma ga nga a anga Mbərom, ta pa tu ɗo anahan ahay. Aday abay təɗe sa pa pen ataya nà, si ɗo sə gəɗan dungo anà way anga Mbərom ahay taayak biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","«Kabay kula kə jingen Tawrita itəbay ɗaw? Ɗo sə gəɗan dungo anà way ahay anga Mbərom nà, ta ga mer su way ù doh sə mazlaɓ a Mbərom nə pac pac, kwa tə luvon sa man uda awan. Tə winen ata təke ɗukwen, ines inde patan ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ni jak ikwen həna: Ɗo sə zalay doh sə mazlaɓ a Mbərom inde həna à man a anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","«Mə vinde à Deftere a Mbərom inde nà, Mbərom a wa: “U no ɗo ahay tâ gan sumor ì zek ahay, bina u no tə̂ vuro gənaw ma sla dungo aya bay.” Ata nà, abay kə̂ sənen anan 'am ata nà, ki viren anan ines anà ɗo mənjəna ines ahay həna biten ataya bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bina nen Wan su Ɗo nà, nə lavan nga anà luvon sa man uda awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Natiya awan, Yesu a slabak, a zla ù doh sə wazay a inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ɗowan a inde à man ata, winen ma mac alay awan. Aday ɗukwen Farisa ataya, a nan atan sa man anan mungok anà Yesu pa sa ga mer su way pə luvon sa man uda ata awan. Anga nan tə cəce pə Yesu wa: «Tawrita a mənuko kə̀ varak uko cəveɗ sa mbar ɗo pə luvon sa man uda awan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu a mbəɗahan atan apan, a wa: «Hinahibay təman anak inde, aday kə̀ slahak panak à məke inde nà, ki gəɓay anan à məke wa, kwa â ga nə pə luvon sa man uda awan biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tə ɗiɗem a nà, ɗo a zalay təman biɗaw? Anga nan, cəveɗ inde sa ga mer su way lele awan, kwa pə luvon sa man uda awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu a jan anà ɗowan a ma mac alay a ata kutok: «Ndəɗoy anan alay!» Ɗowan ata a ndəɗoy anan alay acəkan, alay anahan kə̀ pəsakak kawa alay a hinen ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Matana awan, Farisa ataya ta nay ahay uho, tə halay nga, aday tə pəlay cəveɗ sə lize anan Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aday Yesu a sləne ləbara a tinen ata cəna, a slabak à man ata wa, a zla way anahan. Ɗo ahay tə pərahak anan azar bayak a re, aday a mbar anan ɗo ɗəvac aya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A gafan atan 'am pi zek wa lele, tâ sa jan anà ɗowan winen wayaw bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Natiya awan, 'am a Mbərom sa ja tə dungo ana Ezaya ata a təra ɗiɗek a kutok. Mbərom a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ɗo si mer su way uno nen sə walay ata, həna! Winen nà, ləliwe uno awan, nə taslay anan mivel nə tə winen awan. Ni slənak ayak apan Apasay uno. I ɗakan atan anan ɗiɗek uno anà ɗo su kon ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I ngam sə təre tu ɗo bay, i zlah awan itəbay. Ɗowan sə sləne dungo anahan pə cəveɗ ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gusuko winen apan i kaɗ coy ɗukwen, winen i ndav a wa bay, lalam winen apan i mbacay coy ɗukwen, winen i ndəvan wa alay itəbay re, hus pə luvon mbala ɗiɗek anahan saa tavay nga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ɗo ahay fok ti ɗəfan iɗe nà, anà sləmay anahan kərtek.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pə dəɓa anahan a wa nà, tə gəɓan ahay ɗowan a inde, winen hurof awan, aday maandak a re, anga setene inde anan à nga. Yesu a mbar anan. Ɗowan ata a ja 'am, a canan iɗe kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Way a sə təra ata a gan masuwayan anà man su ɗo ata fok. Ta ja, ta wa: «Ɗowan a anan nà, winen Wan ana Dawuda mənuko sa ba ata biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aya əna Farisa ahay tə sləne cəna, ta ja, ta wa: «Ɗowan a anan nà, sə varan məgala sa razl anan setene ahay nà, Bə'elzebul bahay sə setene ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu a san ajalay nga a tinen a zle. Anga nan a jan atan, a wa: «À bahay a wura wura fok cəna, kak ɗo anahan aya 'am kà zlak atan pi zek bay nà, bahay ata i nes wa. Wulen su doh a wura wura, gulom su doh a wura wura ɗukwen, kak ɗo ahay uda ataya 'am kà zlak atan pi zek sabay cəna, i tavay nga sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kak Fakalaw bahay sə setene ahay winen apan i razl setene ahay nà, 'am kà zlak atan pi zek tu ɗo anahan aya sabay. Matanan bahay anahan a i tavay nga sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kak nen na razl setene ahay tə məgala ana Fakalaw nà, aday wan a kwanay ahay ti sa razl setene ahay nə tə məgala à waya kutok asa anaw? Anga nan, sa naa mak ikwen anan mungok nà, wan a kwanay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tə ɗiɗem awan, na razl setene ahay tə məgala sə Apasay a Mbərom. Matanan re, ki sənen anan kutok, bahay a Mbərom kà nak ahay à wulen a kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Matana re, ɗowan saa zlan ù doh ù ɗo gədan a saa ngəzəray panan way anahan ahay nà, ibay. Si kə̀ lahak apan kurre kə̀ jawak anan ɗowan ata awan, aday i saa mba apan sa zlan ù doh sa ray panan way anahan ahay nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Ɗowan aday winen ti nen bay cəna, ata winen ɗo maniɗe uno. Ɗowan a kà mak uno zek sə halan nga anà ɗo ahay bay, ata winen a i tan atan 'am. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anga nan ni jak ikwen həna, ɗo zənzen a kə̀ nəsek kabay kə̀ jənak anan pa 'am anà Mbərom nà, Mbərom i pəse anan ines anahan ata awan. Aya əna, kak ɗowan a kə̀ jənak anan pa 'am anà Apasay Cəncan a nà, ata Mbərom i pəsen anan ines anahan ata itəbay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Matanan re, kwa ɗowan a nə a ja 'am lelibay a pa Wan su Ɗo, Mbərom i pəsen anan ines anahan ata, əna ɗo sa ja 'am lelibay pa 'am ana Apasay Cəncan ata nà, Mbərom i pəsen anan ines anahan ata kula ite sabay, kwa həna pə luvon sə biten, kwa pə luvon saa nay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kak dədazl si sé a nə sumor a cəna, wan anahan a i təra sumor a re. Aday kak dədazl si sé a nə sumor a bay ite, ata wan anahan a ɗukwen nə sumor a bay re cite. Anga nan, ta san dədazl si sé nà, pa wan a wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kwanay aday nà, zahav su kòn ahay, ki mben apan sa ja 'am lele aya nə kəkəmaw? Bina təbəlem su ɗo a ja nə way sa nay ahay à mivel anahan wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɗo lele a nà, a san sa ja 'am zle ləfeɗeɗe, anga 'am anahan ata a nay ahay nà, kwa à mivel anahan lele ata wa. Matanan, ɗo sə huwan ɗukwen a ja nə 'am sə huwan, anga 'am anahan ata a nay ahay nà, kwa à mivel anahan a lelibay ata wa re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nen ni jak ikwen həna: Pə luvon a Mbərom sa ga sariya ata nà, ɗo ahay ti mbəɗahan apan anà nga a tinen ahay pa 'am a tinen ahay ma ja aya lelibay ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mbərom i ban iken, kabay i mbəsak iken nà, anga 'am anak ma ja awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Natiya awan asa, ɗo ahay à wulen sə Farisa ahay pi zek tə miter sə Tawrita aya ta jan anà Yesu, ta wa: «Miter, a nan umo, ga masuwayan sə way kərtek sə ɗakay anan nà, Mbərom a sə slənay ahay iken acəkan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu a mbəɗahan atan apan, a wa: «Ɗo sə biten ahay nə huwan aya fok, ɗo sə mbəɗahan lœn anà Mbərom ahay. Tinen ta gan may nà, anà masuwayan. Əna ti canan anà masuwayan sə awan sabay, kak si masuwayan sə təra pə Zonas, ɗo maja'am a Mbərom ata aday. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kawa ana Zonas sa ga luvon ahay maakan à kutov sə kəlef məduwen a inde ata nà, nen Wan su Ɗo ni ga matanan luvon ahay maakan à məke inde re. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pə luvon sə sariya a Mbərom saa ga ata nà, ɗo sə Nəniwe ahay ti slabakay ahay uho pə kərtek a tu ɗo sə biten a anan ataya, ti gan atan sariya. Anga ɗo sə Nəniwe ahay nà, tə sləne wazo ana Zonas cəna, ta yam pə ines a tinen ahay. Aday ɗukwen, ɗo sə zalay Zonas winen inde à man a ana awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","«Pə luvon sə sariya nà, bahay sə Saba ɗukwen i slabak sa gan sariya anà ɗo sə biten a anaya awan. Anga kwa winen dəren təkeɗe nà, kà nak ahay sa naa pəkak ayak sləmay pa 'am ana bahay Sulimanu, ma ja aya tə kəlire ata awan. Əna, cen apan həna kutok, ɗo sə zalay anan Sulimanu tə məduwen ɗukwen, winen inde à man a ana awan. Əna hwiya ɗowan a ngam sə sləne 'am anahan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Setene kà nak ahay ù ɗo wa nà, i zla à man kiɓe inde saa bar, saa pəlay man sa man uda awan. Əna kə̀ njaɗak man bay nà, ");
INSERT INTO mqbNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i jan anà nga anahan: “Suwan ni ma ù doh uno nen a sa nay ahay wa ata awan.” Kà sak a may ahay nà, i tan à nga anà doh anahan a mama'am ata mə ndakay awan, mə faɗay a lele, ɗowan uda ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aday cəna, i ma pə dəɓa, i ray ahay apan setene azar aya cuwɓe, sə zalay anan tə huwan asa, ti nay, ti njahay à ɗowan ata inde. Aday anjahay ana ɗowan ata nà, lelibay zal pa sə kukwa ata wa asa. Natiya ɗukwen, i təran anà ɗo sə biten a huwan ataya fok nà, matanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu winen apan i jan 'am ata anà ɗo ahay mba, mərak anahan ahay tatə may anahan ta nay, tə tavay uho. Ta gan may sa ja 'am tə winen. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɗowan a a jan anà Yesu, a wa: «Atə may anak tatə mərak anak ahay, tinen mə tavay aya uho. A nan atan sa jak 'am.» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu a mbəɗahan apan, a wa: «May uno nà, wayaw? Mərak uno ahay nà, maya anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A sukwe alay pə njavar anahan ahay, a wa: «Sə təra mərak uno ahay aday may uno nà, tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Anga ɗo sa ga way sa zlan à nga anà Mbərom, winen à bagəbaga mburom ata nà, sə təra may uno tə mərak uno nə winen aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Natiya kutok, pə luvon ata kərtek awan, Yesu a nay ù doh wa, a zla way anahan sa jan 'am anà ɗo ahay pa 'am sə bəlay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɗo ahay bayan a tə mindel ta nay ahay pə cakay anahan. Anga nan, a ján way anahan sə njahay à kwalalan inde. Ɗo ahay ite tə tavay pa 'am məgujeguje. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu a ɗakan atan anan way ahay bayan a tə jike ahay. A jan atan, a wa: «Ɗowan inde a zla à guvo, saa casl ndaw. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Winen apan i casl ndaw ata kutok, zahav a guce panan pə cəveɗ, aday məvuhom ahay tə ɗagay anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zahav azar a, a guce pə saray pəkəraɗ, ta hay ahay bəse, anga yugo inde bayan a ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Əna pac a sləray cəna, a ɓutoy anan aday a vak anan, anga sləlay a ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Zahav mə mbəsakan a à alay inde ata a guce à wulen sə adak inde. Ta ha cəna, ta har pi zek tə adak, əna adak a bənan mbiyeɗ, ndaw ata kə̀ nahak bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Əna zahav azar awan, a guce à məndak pə yugo lele awan. Ta nah bine siwaw nà, nga sa ndaw kərtek a cəna, hawal sa ndaw apan nə səkat, azar a kwa kuro mbərka, hinen ahay ɗukwen inde apan kwa kuro maakan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu a jan atan kutok, a wa: «Sləmay inde pə ɗowan a nə, â sləne 'am a anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pə dəɓa anahan a wa nà, njavar anahan ataya ta zla à man anahan sə cəce panan, ta wa: «Ka taa jan 'am anà ɗo ahay tə jike nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu a mbəɗahan atan apan, a wa: «Kwanay nà, way mi ɗer aya à bahay a Mbərom a inde ata nà, winen a kà gak ikwen panan akar sa 'am sə bahay anahan a coy. Aday ɗo a azar a nà, Mbərom kə̀ varak atan cəveɗ sa san anan itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɗo aday way anahan ahay inde nà, i njaɗ apan re, way i ga inde apan bayan a kutok. Əna, ɗo aday awan anahan inde ibay ata, i lize anan mbala anahan a mənjœk ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Natiya, na jan atan 'am tə jike nà, anga ti ca apan, əna tə canan bay, ti pak apan sləmay, əna tə sləne bay, ti san awan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Am mbala ana Ezaya sa ja ata a təra patan kutok. Mbərom a wa: “Ki pəken sləmay, əna ki slənen awan bay. Ki cen apan tə iɗe, əna ki cinen anan anà awan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Anga ɗo ataya nà, tə tacak anan iɗe, anga aday tə̂ canan anà awan bay, tə dəngəzlak anan sləmay a tinen, anga aday tə̂ sləne awan bay, tə dərzlak anan mivel a tinen, anga aday tâ san awan bay. Bina, abay ti mbəɗahan lœn anà ines a tinen ahay, aday ni mbar atan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Əna kwanay nà, tislen mivel, anga iɗe a kwanay ahay tə canan à way ahay zle, sləmay a kwanay ɗukwen ti sləne way ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo maja'am a Mbərom ahay bayan a pi zek tu ɗo ɗiɗek aya bayak a ta gak anan may sə canan à way a kwanay a sə canan həna ata awan, əna tə canak anan anà awan bay. Ta gan may sə sləne way a kwanay a sə sləne həna ata awan, əna tə slənek awan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Natiya kwanay nà, sənen anan jike su ɗo sa casl ndaw ata kutok: ");
INSERT INTO mqbNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kuwaya, ɗowan a kə̀ slənek ləbara sə bahay a Mbərom, aday kə̀ sənak anan bay cəna, Ɗo sə Sədœk a nay ahay, a wuɗeh anan way a ma casl a à mivel anahan inde ata awan. Cəveɗ aday zahav sə guce apan ata nà, a ga minje tu ɗo matanan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ɗo maza aya ite, tinen ta ga minje tə saray pəkəraɗ, zahav sə guce apan ata awan. Tinen nà, tə slənek 'am a Mbərom cəna, tə təma anan tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Əna, 'am ata a pak sləlay à mivel a tinen inde bay. Ti njahay mənjœk cəna, ɗəce i tan atan à nga, kabay ajugwar 'am i nay ahay patan anga 'am ana Mbərom nà, ti mbəsak cəveɗ sa 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ɗo maza aya ite, tinen ta ga minje tə wulen sə adak zahav sə guce uda ata awan. Tinen tə slənek anan 'am a Mbərom nà, ti sapat zek tə way sə daliyugo ahay, ti gan may à zlile sə daliyugo ahay. Way ataya nà, ti bənan mbiyeɗ anà 'am a Mbərom aday â nah bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Əna ɗo azar aya nà, tinen ta ga minje tə yugo lele awan, zahav sə guce uda ata awan. Tinen kutok, tə slənek 'am a Mbərom nà, ti san anan. Anga nan, ta zla nga uho pa 'am a Mbərom. Ti nah aday hawal sa ndaw ahay ti ga patan nə səkat, kwa kuro mbərka, kabay kwa kuro maakan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Asa, Yesu a gan atan jike maza awan, a wa: «Bahay a Mbərom a ga minje tu ɗo aday a zla à guvo, a casl ndaw. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Əna luvon a ga bine siwaw nà, à alay a ɗo ahay tinen apan ti njak ahan ata nà, ɗo maniɗe a zla à guvo ata ite, a casl uda azay sa sla pa nga ana ndaw, a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ndaw a hay, a har, a zla nga uho cəna, azay sa sla ata a ha, a har, a kay anan nga anahan uho cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɗo sa ga mer à guvo ana ɗowan ata ataya ta zla à guvo nà, ta may, ta jan: “Ka casl à guvo nà, ndaw asənə, aday azay sa sla a hay ahay uda awanaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A mbəɗahan atan apan, a wa: “Sa casl uda nà, ɗo maniɗe uno.” Ɗo ataya tə cəce panan, ta wa: “A nak mə̂ ndaha anan wa həna ɗaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A mbəɗahan atan apan: “A'ay, anga ki i ndihen anan pi zek ta ndaw! ");
INSERT INTO mqbNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mbəsiken anan tâ nah pi zek hus pə luvon sa car ndaw aday. Ata ni jan anà ɗo si mer su way uno ahay: Ɓinen anan azay sa sla, viken anan, aday hilen anan nga anà ndaw ì de uno kutok.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu a jan atan 'am sə jike maza awan, a wa: «Bahay a Mbərom a ga minje nà, ta wan sə bəzan. Ɗo a gəɓa wan awan, a casl anan à guvo anahan inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wan sə bəzan nà, ma kac a à wulen sə zahav sə dədazl sə way sə kiɓe ahay fok. Əna kak ta sak a casl anan aday kà hak ite nà, a har a zalay dədazl si sé azar aya tə məduwen. A har ɗukwen, kawa dədazl si sé məduwen aya re. Məvuhom ahay ta mba apan sə njahay uda tu doh.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu a zəgahan atan anan 'am sə jike hinen asa, a wa: «Bahay a Mbərom a ga minje nə tə wuɗah. Uwar a ra mənjœk, a gan anan, a pak pə nuko anahan gəsaɗaf maakan. A laɓ anan nà, nuko ata fok a kwasay, a zlambar.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Natiya kutok, Yesu a jan 'am a anaya anà man su ɗo ata fok nə tə jike. Kà jak atan 'am sə awan maza mənjəna jike bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A ga matanan nà, aday 'am a Mbərom mbala Ezaya sə vinde anan ata â təra, bina Mbərom a wa: «Ni jan atan 'am tə jike, ni ɗakan atan anan way mi ɗer a, kwa à alay a daliyugo ɗukwen mə ndakay a fan bay ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aday kutok, Yesu a mbəsak anan man sə ɗo ahay ahay uho, a zla way anahan ù doh. Njavar anahan ataya tə həɗəken ayak pə cakay, ta jan: «Pəsakan umo anan ahay jike sə azay sa sla à wulen sa ndaw inde ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu a jan atan, a wa: «Ɗo sa casl ndaw, winen Wan su Ɗo. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Guvo a nà, daliyugo. Ndaw a nà, ɗo sə ɗəfan apan à Mbərom ataya awan. Azay sa sla kutok nà, ɗo sə ɗəfan apan anà ɗo sə huwan ataya ite re. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɗo sə Sədœk sa casl azay sa sla ata nà, Fakalaw. Alay sa car ndaw ɗukwen, luvon sa ndav anan daliyugo. Ɗo sa car ndaw ahay ɗukwen, tinen maslay a Mbərom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kawa ana ɗo sa ra azay sa sla aday a vak anan ata nà, way i təra pə luvon sa ndav anan daliyugo ɗukwen matanan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","À alay ata nà, nen Wan su Ɗo, ni slənay ahay maslay uno ahay aday ti fakan wa alay anà ɗo sə huwan ahay aday sa man zek anà ɗo ahay sa ga ines ataya fok à bahay a Mbərom wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ti lar atan ɗukwen à bərom sə uko inde. À man ata awan, ti yam ta sa rac slan ngərcəca. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","À alay ata kutok, ɗo ɗiɗek aya nà, ti dav kawa pac à bahay a Bəbay a tinen Mbərom inde. Ɗo aday sləmay inde apan nà, â sləne 'am a anan!» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Bahay a Mbərom a ga minje nà, tə zlile mi ɗer a à guvo. Ɗo a njaɗ anan, a ɗer anan maza awan, a zla tə ataslay mivel awan. A sukom anan dala tə way anahan ahay fok, a sukom anan guvo winen sa ɗer anan uda zlile anahan ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Asa, bahay a Mbərom a ga minje tu ɗo sa ga masa tə mədine ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A njaɗ mədine lele awan, a sukom anan dala tə way anahan ahay fok, aday a sukom anan mədine ata kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Matanan re, bahay a Mbərom a ga minje nə tə zuvo ma lar a à dəlov inde, a ray ahay kəlef ahay bayan a cara cara ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A rah lele nà, ɗo sa ban kəlef ahay tə ngəzahay anan uho kutok. Ti pəkay anan wa kəlef ahay pə məgujeguje, tə walay a wa kəlef lele aya à mbulo, aday kəlef lelibay ataya ɗukwen tə guce atan. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Way i naa təra pə luvon sa ndav anan daliyugo ɗukwen matanan. Maslay a Mbərom ahay ti nay ahay, ti walay anan ɗo sə huwan ahay à wulen su ɗo ɗiɗek aya wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ti lar anan ɗo sə huwan ahay à bərom sə uko inde, aday ti yam ta sa rac slan a ngərcəca à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu a cəce way pə njavar anahan ahay wa kutok: «Kwanay kə sənen way a anaya fok ɗaw?» Tinen ite tə mbəɗahan apan, ta wa: «Ayaw, mə sənak.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Anga nan, Yesu a jan atan kutok: «Kak miter sə Tawrita inde, aday kə̀ ɗakak anan 'am sə bahay a Mbərom nà, kə̀ tərak kawa bahay su doh sa ray anan way anahan ahay məduwer aya ù doh wa pi zek tə way wiya aya təke def uho ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu a ndav anan sa ja 'am ataya nà, a zla way anahan ");
INSERT INTO mqbNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","à Nazaratu, kon anahan a sa har uda ata awan. A dazlan, a zla ù doh sə wazay, a tətakan anan way anà ɗo ahay à man ata awan. 'Am anahan ataya a gan atan masuwayan, aday ta wa: «A njaɗay ahay kəlire sə asan way ata awanaw? Aday a mba apan sa ga masuwayan a anaya nà, waya sə varan gədan ata anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Winen nà, wan ana ɗo sə cəceɗ dədom ba? May anahan ɗukwen Mariyama. Məran aya ɗukwen, ɗa san atan zle, atə Yakuba tə Yusufu tə Simon tatə Yuda. ");
INSERT INTO mqbNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mərak anahan ahay dəna aya ɗukwen, ɗa san atan zle lele, tinen pə cakay a mənuko. Aday winen a njaɗay gədan matanan ata awanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Anga nan, tə ngəmak sa ɗaf nga pə Yesu bay. Yesu a jan atan kutok: «Ɗo ahay ta gan nga anà 'am ana ɗo maja'am a Mbərom kwa ta sə wura fok. Əna ù kon anahan awan, aday ù doh anahan a nà, ɗowan a gan nga anà 'am anahan ahay itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu a ga masuwayan sə way à man ata nà, mənjœk ca, anga tə təmahak sa ɗaf apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ihe, à alay ata nà, Hiridus nə bahay a pə daliyugo sə Galile. A sləne pə ləbara ana Yesu nà, ");
INSERT INTO mqbNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a jan anà ɗo anahan ahay, a wa: «Ɗowan ata nà, i ga nə Yuhana ɗo sa gan baptisma anà ɗo ahay ata kà mak uho. Anga nan, a mba apan sa ga masuwayan sə way ahay nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kwakwa ata nà, Hiridus a gəɓa anan Hirudiya, uwar ana wanbay anahan a inde, tə ngaman Filip. Anga nan, Yuhana a jan, a wa: «Ki jipen pə uwar tə mərak anak nə, lelibay. Way ata nà, ines!» Anga nan kutok, Hiridus a jan anà ɗo ahay tâ ban anan Yuhana. Ta ban anan, tə ɗəfak anan ayak ù doh sə dangay. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Anga nan kutok, a nan anà Hiridus sa vaɗ anan Yuhana. Aya əna, kə̀ vəɗak anan bay, anga a jəjaran anà Yahuda ahay, bina ta ca pə Yuhana nà, ɗo maja'am a Mbərom wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pa pac a inde kutok, azar uko sə bayak pə luvon sə wahay anan bahay Hiridus a ga. Dəna a Hirudiya a inde, a nay, a gərvan pa 'am anà Hiridus tu ɗo anahan mə ngamay ataya. Agərav ata a zlan à nga anà Hiridus, ");
INSERT INTO mqbNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","a mbaɗay i varan way anà dəna ata kawa anahan saa cəce panan ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dəna ata ite, a zla à man ana may anahan, a cəce panan: «Nə̂ cəce nə maw?» May anahan a jan nà: «Cəce nà, tə̂ gəɗak ahay nga a Yuhana.» A may à man ana Hiridus, a cəce: «U no ki gaɗ anan nga anà Yuhana, aday vuro anan ahay həna à kwatama inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Way a mə cəce ata kà zlak anan à nga anà Hiridus sabay. Əna ɓa kə̀ mbaɗak anan pa 'am ana ɗo anahan mə ngamay aya coy. Natiya kutok a jan anà suje ahay tə̂ varan ahay nga a Yuhana anà dəna ata kawa anahan sə cəce ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Suje a zla ù doh sə dangay saa gəɗay ahay nga ana Yuhana. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta nay anan ta nga a Yuhana ma ɗaf a à kwatama inde, tə varan anan anà dəna a Hirudiya ata kutok. Winen ite a təma anan cəna, a varan anan anà may anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Njavar a Yuhana ahay ite, ta zla ù doh sə dangay, tə gəɓay anan məsinde ana Yuhana, ta la anan. Pə dəɓa anahan a wa, ta zla sə təkəren 'am ata anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu a sləne Yuhana kə̀ məcak cəna, a slabak à man ata wa, a ján à kwalalan inde tə njavar anahan ahay ɗəkɗek, a zla way anahan kəcah pə ɗo ahay wa à kiɓe. Ɗo ahay tə sləne sa jəka tinen à kiɓe ata nà, ta nay ahay à wulen su doh ahay wa, tə pərahan azar à kiɓe tə saray. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu a dazay ahay à kwalalan wa cəna, a canan anà ɗo ahay bayak awan. Ɗo ataya ta gan ì zek wa. A dazlan, a mbəran atan anan ɗo sə ɗəvac a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Suko a ga bine siwaw nà, njavar anahan ahay ta jan, ta wa: «Luvon winen apan i ga! Aday həna ɗukwen mənuko à man kiɓe. Suwan, mbakan cəveɗ anà ɗo ahay tâ zla à wulen su doh ahay. Ata ti njaɗ sə sukom way sa pa ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu ite, a mbəɗahan atan apan, a wa: «Ti gan may sa zla à man a bay, əna kwanay a viren atan way sa pa awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tinen ite tə mbəɗahan apan re, ta wa: «Awan inde pumo ibay! Inde həna ɗukwen si tapa sa pen ahay ɗara tə kəlef ahay cuwcuwwe coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu a jan atan: «Hayak ikwen anan ahay!» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A jan anà ɗo ahay tə̂ njahay pa nga sə gujeɗ à məndak. A gəɓa anan tapa sa pen a ɗara ataya, tə kəlef a cew ataya awan. A ca iɗe à mburom, a ngəran ayak anà Mbərom. A gəzla anan tapa sə pen ataya ì zek wa, a varan anan anà njavar anahan ahay, aday tə̂ gəzlan anan anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɗo ataya fok ta pak, tə rahak ɓah ɓah. Njavar anahan ahay tə halan nga anà mə mbəsak ataya nà, a ga cəkarak kuro nga anahan a cew re. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɗo sa pa way à man ata ɗukwen, tinen mə baslay a nà, mungol a ɗəkɗek aday nà, ta ga mbulo ɗara, mənjəna sə baslay anan uwar ahay pi zek tə gwaslay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pə dəɓa ana way ata wa kutok, Yesu a jan anà njavar anahan ahay tâ ján à kwalalan inde, aday tə̂ lahan pa 'am sa zla pa day sə uho. Winen awan, i i mbəsak anan ɗo ahay à dəɓa a tinen wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tə gəzla nga tə ɗo ahay lele nà, a zla way anahan à ɓəzlom saa ga amboh, winen a taayan. Luvon a ga apan à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","À alay ata nà, kwalalan winen dəren coy. Maɗ winen apan i vawan nga anà kwalalan pa nga sə a'am, anga tə zlangay uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aday iɗe kə̀ cəɗek lele fan bay, Yesu a zla pə cakay a tinen cukwe cukwe pa nga sə a'am tə saray. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Njavar anahan ataya tə canan winen apan i zla tə saray pa nga sə a'am ata cəna, tə jəjar pi zek yiɓyeɓ, ta wa: «Həna anan nà, mədahan.» Ta ma nga sa zlah pi zek, anga zlawan cərkəke. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aya əna Yesu a canan atan cəna, a jan atan ayak 'am a kwayan'a, a wa: «Bənen mbac lele, nen awan, kə̂ jəjiren bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyer a jan 'am, a wa: «Bahay uno, kak iken acəkan nà, jo ahay ì nen nâ zlak ayak pa nga sə a'am tə saray a ite kwa!» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu a jan ahay: «Hayak!» Piyer a dazay à kwalalan wa ca, a zla à man a Yesu tə saray aday pa nga sə a'am acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Əna a canan ayak anà maɗ nà, a ma nga sə jəjar, aday a dazlan kwayan'a sə kəkar à a'am inde. Winen ite a zlah pi zek, a wa: «Bahay uno, tam nen ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Natiya Yesu a bənan alay bəse, aday a jan kutok: «Aɗaf nga anak a kac ike ɗaw? Sa gak hiyem hiyem nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ta ján way a tinen à kwalalan inde cew maya awan cəna, maɗ a mbəsak sa ɓal cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Njavar anahan a azar ataya tə həran nga, ta wa: «Acəkan, tə ɗiɗem a nà, iken nə Wan a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tə takasay ahay pa day sə agay lele nà, ta zla ù kon sə Gənesaret. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ɗo su kon ataya ta san anan Yesu lele cəna, ta tar anan 'am a pə daliyugo a tinen fok. Anga nan, ɗo ahay ta ray anan ahay ɗo sə ɗəvac ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta gan amboh â mbəsakan cəveɗ anà ɗo ɗəvac ataya tə̂ laman alay kwa anà 'am sə zana anahan, aday tâ mbar ite. Ɗo sə laman ataya fok, tə mbərak acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Natiya kutok, Farisa ahay pi zek tə miter sə Tawrita aya ta nay ahay kwa à Urəsalima wa, pə cakay ana Yesu. Tə cəce panan, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Njavar anak ahay nà, tə pərahan azar anà atətak way sə bije ahay bay nə angamaw? Bina, ta pa ɗaf mənjəna sə banay alay kawa atətak way sə bije ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu a mbəɗahan atan apan, a wa: «Aday kwanay ɗukwen, tə atətak way a kwanay nà, kə nəsen anan 'am a Mbərom angama kəla anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anga Mbərom a ja nà: “Ɗəfan apan anà bəbay anak tə may anak” aday “Kuwaya ɗowan a kà jak 'am lelibay a pə bəbay anahan kabay pə may anahan nà, sa vaɗ anan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Əna kwanay ki jen nà, kak ɗowan a kà jak anan anà bəbay anahan kabay anà may anahan: “Way uno abay saa mak anan zek ata nà, kə̀ tərak anà Mbərom.” ");
INSERT INTO mqbNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ata i ɗəfan apan anà atə bəbay tə may sabay. Matanan kutok, kə nəsen anan way a Mbərom ma ɓan awan, anga sə pərahan azar anà atətak way sə bije ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kwanay aday nà, mbaɗəmbaɗa aya awan. Ezaya kà jak pikwen 'am a Mbərom ɗiɗem awan, Mbərom a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ɗo anaya tə həro nga nà, ta 'am ɗəkɗek, mivel a tinen aya nə dəren ti nen. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tinen apan ti dukwo gərmec ù vo nə kəriya awan. Bina tinen apan ti tətakan anan anà ɗo ahay nà, way sa nga a tinen ahay ɗəkɗek.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu a ngaman ayak anà ɗo ahay tâ nay pə cakay anahan. A jan atan, a wa: «Pəken uno sləmay, sənen 'am a anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saa ga məsagar pu ɗo nà, way sa zla ta 'am ì zek su ɗo ata bay. Əna way sa ga məsagar pu ɗo nà, way sa nay ta 'am ì zek wa aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Njavar anahan ahay tə həɗəken ayak pə cakay ta jan, ta wa: «'Am anak a sa ja ata nà, kə̀ cəɓak anan anà Farisa ahay nə, ka san biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu a mbəɗahan atan apan, a wa: «Zahav sə way a aday Bəbay uno winen à bagəbaga mburom ata sa casl bay ata cəna, ti ndaha wa zek. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mbəsiken atan. Tinen nà, hurof sə bənan alay anà hurof ahay aɗəka. Kak aday ɗo hurof a winen apan i bənan alay anà ɗo hurof a cəna, ti slahay nə cew maya à gujar inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Natiya kutok, Piyer a jan, a wa: «Ɗakan umo anan 'am sə jike ata ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu a mbəɗahan apan, a wa: «Hus həna ɗukwen, kwanay kə sənen fan bay ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Way sa zla ì zek su ɗo ta 'am nà, a zla nə à kutov a way anahan, a may uho tə mətilen, kə sənen bay re ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Əna way sa nay uho ù ɗo wa ta 'am nà, a nay ahay nə kwa à mivel wa. Ata sa ga məsagar pu ɗo nà, way ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Anga sa nay à mivel su ɗo wa kutok cəna, way kawa ajalay nga lelibay aya, avaɗ nga su ɗo, aga mədigweɗ, aga vuwar, akar, agaɗ mungwalay, agəɗan azar ù ɗo. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Natiya, sa ga məsagar pu ɗo kutok nà, way ataya awan. Bina, apa way mənjəna sə banay alay kawa ana bije a kwanay ahay sa ja nà, a ga məsagar pu ɗo bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu a slabak way anahan à man ata wa, a zla way anahan pə daliyugo sə Tirus tə Sidon. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","À man ata awan, uwar a inde, ɗo sə pəra, winen Kanana ahay. A nay à man ata wa, pə cakay ana Yesu, a jan: «Bahay uno, wan a Dawuda, mo zek ite, bina dəna uno winen tə setene awan, a bənan ɗəvac bayak awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Əna Yesu kə̀ mbəɗahak anan apan bay. Əna njavar anahan ahay ta nay, ta jan, ta wa: «Miter, kem, ɓal anan aday â mbəsak iken, bina winen apan i vawak uko nga tə abəbal awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu a mbəɗahan apan anà njavar anahan ahay, a wa: «Nen mə slənay a nà, anga ɗo sə pəra ahay bay. Əna nen mə slənay a nə pə təman mə lize aya à wulen sə Isəra'ila ahay wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Uwar ata a həɗek pə cakay anahan asa, a dukwen gərmec ù vo, a wa: «Bahay uno, mo zek!» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu a mbəɗahan apan kutok, a wa: «Sə gəɓa anan way sa pa sə gwaslay ahay, sə varan anan anà kəla ahay nà, sumor a ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Natiya kutok asa, uwar ata a wa: «Matanan, bahay uno, əna kəla ahay ɗukwen ta pa way sə pəpas pə tuwez ana bahay a tinen ahay wa re asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu a ja, a wa: «Iken uwar a anan, aɗaf nga anak nə məduwen awan. Â tərak nə kawa ananak sə pəlay ata awan.» Natiya, à alay ata ite, dəna anahan ata a mbar. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu a slabak à man ata wa asa, a zla way anahan pa 'am sə bəlay sə Galile. A ján à ɓəzlom, a njahay way anahan à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Man su ɗo a a nay ahay pə cakay anahan, ta zlan anan ayak tu ɗo mə kuray saray aya awan, ɗo hurof aya awan, ɗo vədal aya awan, ɗo maandak aya awan pi zek tu ɗo sə ɗəvac ahay bayak a cara cara. Tə nahay atan fok pə cakay à Yesu, aday a mbar atan fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ana ɗo sə ɗəvac ahay sa mbar fok ata nà, a gan masuwayan anà ɗo ahay bayak a cite, anga tə canan anà ɗo maandak aya ta ja 'am kutok, ɗo vədal aya tə mbərak, ɗo ma mac saray ataya tinen apan ti zla kutok, hurof ahay tə canan iɗe zle coy kwaler kwaler. Tə dazlan sə həran nga anà Mbərom sə Isəra'ila ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu a ngaman anà njavar anahan ahay, a jan atan: «Ɗo a anaya tu go ì zek wa, anga mənuko pə kərtek a luvon maakan həna, way sa pa ibay. Ni mba apan sə mbəsak atan tâ zla agay ta may awan bay, anga ti sa ga bəle pə cəveɗ.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tinen ite ta jan: «Aday ɗi njaɗay way sa pa anga ɗo a anaya fok à kiɓe inde à man a anan awanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu a cəce patan wa kutok: «Tapa sə pen inde pikwen nə jugumaw?» Tə mbəɗahan apan, ta wa: «Cuwɓe, tə kəlef ahay mənjœk.» ");
INSERT INTO mqbNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Matanan Yesu a jan anà ɗo ahay tə̂ njahay à məndak. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A gəɓa anan tapa sə pen a cuwɓe ataya awan, pi zek tə kəlef a təke, a gan ayak suse anà Mbərom, a gəzla anan ì zek wa, a varan anan anà njavar anahan ahay tə̂ gəzlan anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Ɗo a mə halay nga ataya fok, tinen mbulo fuɗo, mənjəna sə baslay anan uda uwar ahay pi zek tə gwaslay ahay. Ta pak, tə rahak fok a tinen awan. Tapa sə pen mə mbəsak ata nà, a ga cəkarak cuwɓe re. ");
INSERT INTO mqbNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Coy, Yesu a mbəsak anan ɗo ahay tə gəzla nga. Winen a a ján à kwalalan inde sa zla pə cakay sə wulen su doh sə Magadan. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Natiya kutok, Farisa ahay pi zek tə Saduki ahay tə tavay den pə cakay anahan. Tə cəce panan wa masuwayan sə way sa nay ahay à mburom wa, anga ta gan may sa ban anan pə kwande. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu a mbəɗahan atan apan, a wa: «Pac kə̀ slahak ù doh nà, zamburom a ca ngəlaɓaɓa, ata ki wen: “Sidew nà, pac i dav.” ");
INSERT INTO mqbNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aday duwdew sa pac sə sləray ahay ite, kak matapasl kə̀ ɗəfak aday a ca ngəlaɓaɓa nə ki wen: “Biten nà, iven i ga.” Way sa ga à mburom tə way saa təra pə daliyugo fok nə kə sənen a agəzlan anan alay pi zek wa nə lele, aday kə sənen pə way sə təra à alay a wuswes a anan inde sabay ata nà, angama kutok anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ɗo sə biten ahay nà, huwan aya aday tə mbəɗahan lœn anà Mbərom re. Tinen ta gan may nà, anà masuwayan. Əna ti canan anà masuwayan sə awan sabay, kak si masuwayan sə təra pə Zonas, ɗo maja'am a Mbərom ata aday.» A mbəsak atan à man ata awan, a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aday à alay a tinen apan ti takas bəlay nà, njavar anahan ahay tə mbəɗəkek anan nga sə gəɓa tapa sə pen à alay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu a jan atan, a wa: «Uffa ahak ikwen, bənen nga a kwanay nə lele pə wuɗah sə Farisa ahay tə Saduki ahay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Əna tinen ta ja à wulen a tinen inde nà: «I ga nə a ja pə pen ɗə gəɓak à alay inde bay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu ite a san way a tinen a sə bayak ata zle re. Anga nan, a cəce patan wa, a wa: «Kə bayiken, na ja nə anga tapa sə pen inde pikwen ibay nà, angamaw? Kwanay munok aya pa sa ɗaf nga pə way. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kə sənen apan fan bay ɗaw? 'Am sə pen tapa ɗara, aday ɗo ahay mbulo ɗara ta pak, tə rahak aday kə̀ mbəsakak re ata, aday kə rihen anan cəkarak ahay ata nà, kə mbəɗəkek ikwen à nga wa ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aday 'am sə pen tapa cuwɓe nen sə varan anà ɗo ahay mbulo fuɗo, ta pa, ta rah, aday kə rihen anan cəkarak ahay ata nà, kə sənen apan sabay kələɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Na jak ikwen nə 'am sə pen bay. Kwanay kə sənen bay nà, angamaw? Aya əna, bənen nga a kwanay pə wuɗah sə Farisa ahay ta sə Saduki ahay wa lele.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Natiya kutok, ta sa san sa jəka a jan atan nə pə wuɗah sə pen bay, əna pə atətak way sə Farisa ahay ta sə Saduki ahay nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pə dəɓa anahan a wa kutok, Yesu a slabak, a zla way anahan pə cakay sə wulen su doh a sə ngaman Kaysariya Filipi ata awan. À man ata awan, a cəce 'am pə njavar anahan ahay wa, a wa: «Ɗo ahay ta ja pi nen, nen Wan su Ɗo nà, nen nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tinen ite tə mbəɗahan apan, ta wa: «Ɗo hinen ahay ta wa, iken Yuhana ɗo sa gan baptisma anà ɗo ahay ata awan. Ɗo maza aya ta wa, iken Eliya, ɗo maja'am a Mbərom. Ɗo azar aya ɗukwen ta ja nà, iken Yeremiya, ɗo maja'am a Mbərom, kabay iken ɗo hinen à wulen su ɗo maja'am a Mbərom ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu a cəce asa, a wa: «Aday kwanay a nà, ki wen nen wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piyer a mbəɗahan apan, a wa: «Iken nà, Almasihu, Wan a Mbərom, bahay sə sifa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu a mbəɗahan apan, a wa: «Iken Simon, wan ana Zonas, iken nà, Mbərom kə̀ ɗəfak apak alay sə mazlaɓ anahan coy. Anga sə ɗakak anan way a ɗiɗek ata nà, Bəbay uno winen à bagəbaga mburom ata awan, bina ɗo zənzen a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pak sləmay, ni jak 'am inde həna: Iken nə Piyer, kawa sa ja nà, Pəkəraɗ. Pə pəkəraɗ a anan kutok, ni halan apan nga anà ɗo sa ɗaf upo nga ahay fok, aday məgala sə məke i i mbasay patan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ni varak lakile sə təɓa anan məsudoh sə bahay a Mbərom à alay inde. Aday way anak saa ɓan pə daliyugo cəna, winen ma ɓan a matanan à mburom re. Way anak saa pəsak anan pə daliyugo ite ɗukwen, winen mə pəsak a à mburom re ca.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Əna Yesu a gafan 'am anà njavar anahan ahay sə ɗakay anan winen nə Almasihu. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Natiya awan kutok, a bənay pə winen ata wa ite, Yesu a dazlan sa jan 'am tə njanjorzlom a anà njavar anahan ahay kutok, a wa: «Bəlaray ni zla à Urəsalima. Ata, məceɗ sə Yahuda ahay, tə bahay sə gəɗan dungo anà way ahay anga Mbərom, tatə miter sə Tawrita ahay ti ga alay ti nen tə mindel, ti vaɗ nen. Aday pə luvon maakan anahan a cəna, nen ni slabakay ahay way uno à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyer ite a ngaman, ta zla kəcah, a gafan 'am, a wa: «A'ay, bahay uno. Â tərak matanan bay!» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu a mbəɗa apan 'am, a jan: «Zlak ayak pə cakay uno wa, iken Fakalaw! Kə pəlay sə slaray nen à cəveɗ uno wa. Anga ajalay nga anak ata nà, a nay ahay ù ɗo zənzen a wa, bina mbala a Mbərom ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu a jan anà njavar anahan ahay fok kutok: «Kak ɗowan a a nan sə pəruho azar nà, â mbəsak sə bayakan way anà nga anahan, â tavak dədom anahan mə zləlngaɗ awan, â pəruho azar. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anga kâ nak anan anà ɗowan a sa tam anan sifa anahan nà, i lize anan aɗəka. Əna ɗowan a kə̀ lizek anan sifa anahan anga nen ite nà, i njaɗ anan uda way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bina, ɗo kà sak a njaɗ anan way sə daliyugo a anan fok anà winen, aday sifa anahan a nà, kə̀ lizek anan nə, saa gan dəɗaffa nà, ma mba asa anaw? Ibay! Awan a inde aday ɗo zənzen i var sə bəmbaɗ anan sifa anahan nà, inde ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nen Wan su Ɗo, ni nay ahay tə mazlaɓ a Bəbay uno mba, aday tə maslay anahan ahay re. I man anan anà kuwaya nà, kawa mer su way anahan a sa taa ga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan aya inde à man a anan, ti mac bay si ti canan anà Wan su Ɗo i nay tə bahay anahan a təke aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pə dəɓa anahan a wa kutok, a ga luvon ahay mbərka nà, Yesu a gəɓa pə azar Piyer, Yakuba tə apan Yuhana mərak ana Yakuba, ta ján taayak à ɓəzlom a inde zəbor awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tə dəzle cəna, zek a Yesu a mbəɗahan atan pə iɗe. Tə canan anà jœr anahan nà, kawa sə kwakwa sabay, a wuteɗen atan kawa pac. Zana anahan pi zek ɗukwen, a dav nə herre kawa jiyjay sə uko ma dav awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Njavar anahan ataya tə canan anà atə Musa tə Eliya ɗo maja'am a Mbərom ahay kwakwa, tinen apan ti ja 'am tatə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyer a dazlan sa jan anà Yesu, a wa: «Bahay uno, mənuko à man a anan nə sumor awan. Kà zlak anak à nga nà, ni ngaray jawjawa ahay maakan, kərtek awan anga Musa, kərtek a ite anga Eliya, aday mədakwidok a nà, anga iken awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Winen apan i ja 'am ata mba, mugudongudon a dazay, a van atan nga sərdədek. Aday 'am a ndəray ahay à mugudongudon ata wa, a wa: «Həna a anan nà, wan uno ləliwe uno awan. Tə winen nà, nen ni taslay anan mivel bayak awan. Slənen anan anan 'am anahan!» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Atə Piyer tə sləne 'am ata cəna, ta ma nga sə jəjar pi zek, tə slahay duboz. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu a həɗəken atan ayak pə cakay, a laman atan alay, a wa: «Slabiken, kə̂ jəjiren bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ta sa cakaf nga asanaw nà, ɗowan inde pə cakay ana Yesu sabay, a mbəsak winen a kərtek coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tinen apan ti dazay à ɓəzlom ata wa mba, Yesu a jan atan, a wa: «Way a kwanay sə canan ahay à ɓəzlom wa ata nà, kâ si jen anan à ɗowan bay, hus pə luvon uno nen, Wan su Ɗo, saa slabakay à məke wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Njavar anahan ataya tə dazlan sə cəce panan wa: «Miter sə Tawrita ahay ta wa, Eliya i lahan anà Almasihu aday nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu a ɗukwen a mbəɗahan atan apan, a wa: «Acəkan, Eliya i lahay aday i ndakay anan way ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nen apan ni jak ikwen: Eliya kà nak ahay coy, aday ɗowan kə̀ sənak apan bay. Ta gak anan anà Eliya way kawa a tinen sa gan may sa ga fok. Aday ɗukwen ti gan anà Wan su Ɗo azanan nə matanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Atə Piyer tə sənak kwayan'a a ja 'am ata nà, pə Yuhana ɗo sa gan baptisma anà ɗo ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aday tə dəzley ahay pə cakay sə ɗo ahay cəna, ɗowan a inde a nay ahay, a dukwen gərmec ù vo anà Yesu, ");
INSERT INTO mqbNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a jan: «Bahay uno, wan uno winen lelibay. Â gak ì zek wa ite. Məhərvov a taa gan, a bənan ɗəvac bayak awan, a taa slahay anan ù uko inde kabay à a'am inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na nak anan pə cakay ana njavar anak ahay, əna ta mbak apan sə mbəro anan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu a ja, a wa: «Kwanay nà, aɗaf nga a kwanay ma kac awan kələɗaw? Kə sənen anan cəveɗ a Mbərom bay re. Ni njahay tə kwanay, aday ni səmen anà way a kwanay ahay nə hus à siwaw? Hayak ikwen uno anan ahay wan a aday!» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu a jan 'am anà məhərvov ata tə angəraz awan: «Hayak à wan a anan wa!» Məhərvov ata a zləray à wan ata wa, wan ana ɗowan ata a mbar à alay ata acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pə dəɓa anahan a wa kutok, njavar anahan ataya tə həɗəken ayak pə cakay taayak a tinen awan, tə cəce: «Manay ma mba apan sə rəzlay anan wa setene ata bay nà, angama kərtek anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu a mbəɗahan atan apan, a wa: «Anga aɗaf nga a kwanay a a kac ike. Nen apan ni jak ikwen tə ɗiɗem a həna: Kak abay aɗaf nga a kwanay â ga inde nə mənjœk kawa wan sə bəzan ɗukwen, ki jen anan anà ɓəzlom a anan ataya: “Zla à man a anan wa, zla tiya!” ɗukwen, i ndaha, i zla à man a kwanay sa jan “zla tiya” ata awan. Awan saa dak ikwen 'am ibay jiga awan.  ");
INSERT INTO mqbNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Əna abay zahav sə setene həna anan nà, kak si ta sa ga amboh tə sumaya aday bina, a razl zek bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pə luvon a inde nà, njavar a Yesu ahay mə halay nga aya pə kərtek a à Galile. Yesu a jan atan 'am, a wa: «Nen Wan su Ɗo nà, ti varan nen à alay inde anà ɗo sə daliyugo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tinen ite, ti vaɗ nen à məke, aday pə luvon maakan anahan a cəna, ni slabakay ahay à məke wa.» Njavar anahan ahay tə sləne 'am ata cəna, mbac a slahay patan wa tə mindel asa. ");
INSERT INTO mqbNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tə dəzle à Kafarnahum cəna, ɗo sə cakal jangal anga doh sə mazlaɓ a Mbərom ahay, ta nay ahay pə cakay ana Piyer, ta jan: «Miter a kwanay nà, a var jangal anga doh sə mazlaɓ a Mbərom itəbay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer a mbəɗahan atan apan, a wa: «A taa hamay ike!» Aday à alay a tinen apan ti i zla ù doh mba kutok, Yesu a lah sə cəce pə Piyer wa: «Simon, a ga apak nà, bahay sə uho a anaya ti təma jangal nə pə waya wa anaw? Pə wan su kon aya wa ɗaw, kabay pə mədurlon ahay wa ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer a mbəɗahan apan, a wa: «Pə mədurlon ahay wa.» Yesu a wa: «Kak matanan nà, abay wan sə agay ahay nə ti hamay bay ba? ");
INSERT INTO mqbNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aya əna, ɗâ saa ga way sə cəɓan anà ɗo ahay bay. Natiya, zla à bəlay, larak anan ayak kwaniyel anak à a'am inde. Kəlef anak a saa bənay ahay pa 'am ata cəna, təɓan anan 'am, ki tan à nga uda à dala təɗe i sla anga mənumo cew ata awan. Varan atan anan kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","À alay ata awan ite, njavar a Yesu ahay tə həɗəken ayak pə cakay, aday tə cəce panan, ta wa: «Waya sə zalay ɗo hinen tə məduwen à bahay a Mbərom inde anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu a ngaman ayak anà wan cəɗew a, a tavay anan à mamasl pa 'am a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kak kə mbəɗihen aday sə təra nga a kwanay kawa gwaslay ahay bay cəna, ki dəzlen à bahay a Mbərom inde bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɗowan a kà mak anan nga anahan à məndak kawa wan a anan nà, sə təra ɗo məduwen a à bahay a Mbərom nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«Kuwaya kà sak a təma jəba sa wan kawa həna anan ataya kərtek a anga sləmay uno nà, ɗowan ata a təma nə nen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Əna kak ɗo kà vak atan saray pə cəveɗ anà ɗo cəɗew anaya sa ɗaf upo nga ata nà, suwan pə winen tə̂ ɓanan van à dungo aday tə̂ larak anan ayak à bəlay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","«Ayaw! Ɗəce inde pə daliyugo a anan, anga way ahay inde tinen apan ti njan saray anà ɗo ahay. Way ataya ti ga inde hwiya, əna ɗəce inde anga ɗo aday way ata a təra tə alay anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kak alay anak kabay saray anak i sapat iken ì ines inde cəna, gaɗ anan, lar anan dəren. Suwan sa zla à bahay inde pə cakay a Mbərom, iken ma gaɗ alay awan kabay tə saray anak slangalan a, tə winen aday ki i zla ù uko sə mbacay itəbay ata inde tə alay aya cew, saray anak ahay səndaɓ cew nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kak iɗe anak i sapat iken sa ga ines cəna, ndaha anan, lar anan dəren tə iken. Suwan sa zla à bahay inde pə cakay a Mbərom tə iɗe anak a kərtek mbiyan'a ta sa zla à dəlov sə uko inde tə iɗe anak aya cew maya nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Gen anan ngatay anà zek lele anga pa sə kəɗey anan ɗo cacəɗew a anaya wa. Nen apan ni jak ikwen həna: Maslay a Mbərom ahay inde mə tavay aya pa 'am a Bəbay uno pac pac sa gan atan nga.  ");
INSERT INTO mqbNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Anga nen Wan su Ɗo na nay ahay nà, sa tam anan ɗo mə lize aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Kə bayiken nə kəkəmaw? Kak ɗowan a nà, təman anahan ahay inde səkat, aday kərtek à wulen a wa kə̀ lizek nà, i ga kəkəmaw? I mbəsak anan kwa kuro dəsuɗo nga dəsuɗo mə lize bay ataya à ɓəzlom, i zla saa pəlay anan winen mə lize ata biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nen apan ni jak ikwen tə ɗiɗem a həna: Kak kə̀ njaɗak anan mə lize ata nà, i taslay mivel tə winen nə zal tə tinen mə lize a bay aya kwa kuro dəsuɗo nga dəsuɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Matanan kutok re, Bəbay a kwanay a winen à bagəbaga mburom ata nà, a nan ɗowan â lize kwa kərtek à wulen su ɗo ma kac a anan ataya wa bay ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Yawa matanan, kak mərak anak kà gak ines nà, zla à man anahan awan, jan anan kwanay a cuwcuwwe, way anahan a sa ga lelibay ata awan. Kak kə̀ pəkak anak apan sləmay nà, ki njaɗ anan mərak anak maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Əna hinahibay i ngam sə pəkak apan sləmay pa 'am ata bay. Kak matanan nà, zla pə cakay anahan kwanay cew tu ɗo hinen, kabay kwanay maakan à alay inde. Anga: “Kak ɗowan a kə̀ zlahak pu ɗo nà, tâ njaɗ ɗo sə side way ata ɗo ahay cew kabay maakan”, kawa ana Deftere a Mbərom sa ja. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kà sak a ngam 'am su ɗo ataya bay re cəna, jan anan 'am ata pa 'am su ɗo uno ahay, aday ata ti jan apan kutok. Kà sak a ngam sa pak apan sləmay bay re cəna, ɗo matanan ata ɗukwen, ca apan nə kawa ɗo sə pəra, kabay winen ɗo sə cakal jangal tə danakay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Nen apan ni jak ikwen tə ɗiɗem a həna: Way a kwanay saa ɓan pə daliyugo cəna, i ɓan zek matanan à mburom. Way a kwanay saa pəsak anan həna pə daliyugo ata ɗukwen, i pəsak zek à mburom re. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Ni jak ikwen 'am hinen asa: Kak ɗowan aya cew pə daliyugo aday 'am kà zlak atan pi zek sə cəce way cəna, Bəbay uno à bagəbaga mburom ata i varan atan kawa ana tinen sa gan may ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Anga ɗowan aya cew kabay maakan ta sak a halay nga tə sləmay uno cəna, nen inde à wulen a tinen a re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Piyer a nay ahay pə cakay ana Yesu, a cəce panan: «Ba Məduwen, hinahibay, mərak uno inde, kà gak uno ines nà, ni pəsen anan nà, saray jugumaw? Hus à saray cuwɓe biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu a mbəɗahan apan, a wa: «A'ay! Ki pəsen anan saray cuwɓe bay, əna saray kwa kuro cuwɓe məcapar cuwɓe. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Matanan kutok, bahay a Mbərom a ga minje nà, tə bahay a inde, a nan ɗo si mer su way anahan ahay fok tə̂ haman anan gudire anahan ahay fok cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A dazlan anà mer su way ata cəna, tə bənan ahay ɗowan a inde, dala ata apan nə bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɗowan ata ite, zlile anahan a saa hamay anan gudire ata ibay. Bahay ata a jan anà ɗo si mer su way anahan a azar aya nə tə̂ sukom anan way tə way ana ɗowan ata fok, tu ɗo su doh anahan ahay, ti zek anahan a təke, aday i saa slan pə gudire anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ɗowan ata ite, a nay a dukwen gərmec ù vo anà bahay ata, a wa: “Amboh, ni hamak anan way anak ahay nə fok. Ga ngatay aday!” ");
INSERT INTO mqbNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Am anahan ata a gan ì zek wa anà bahay ata awan, a mbəsakay anan zek anahan awan, aday a mbəsakan anan gudire ata fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ɗowan ata a təmay uho lele nà, tə zlangay tu ɗo si mer su way hinen, aday abay gudire anahan inde apan ite. Aday dala anahan apan dinar səkat kərtektəkke. A ban anan, a jakan alay pə dungo. A jan, a wa: “Si ki humo anan dala uno həna.” ");
INSERT INTO mqbNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ɗo sə gudire anahan ata ite, a dukwen gərmec ù vo ite, a jan, a wa: “Amboh, ga ngatay aday, ni hamak anan way anak fok.” ");
INSERT INTO mqbNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Əna winen nà, a ngam bay, a ban anan, a zla anan à dangay, a dərazl anan hus pə luvon ana ɗowan ata saa hamay anan gudire ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ɗo a tinen a sa taa ga mer su way pi zek ataya tə canan cəna, a cəɓan atan bayak awan. Ta zla àga bahay ata awan, tə ɗakan anan ləbara ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Bahay a tinen ata ite a ngaman ayak asa, a jan: “Iken nà, ɗo si mer su way lelibay awan. Nə mbəsakak anak anan gudire anak abay ki humo ata awan, anga ka gak uno amboh. ");
INSERT INTO mqbNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aday ka mba apan sə pəsen anan anà ɗo kwanay ì mer su way inde maya ata kətanan bay nà, angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anga nan bahay ata a ga apan mivel, a ban anan maza awan, a varan anan à alay inde anà suje ahay, tə̂ tacak anan ayak à dangay, tâ ga anan alay, hus pə luvon anahan sə hamay anan gudire ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu a zəga anan asa, a wa: «Kak ka sak a pəsen anan anan ines anà mərak a kwanay ahay tə mivel kərtek a bay cəna, Bəbay uno sə mburom ata i ga tə kwanay aya ɗukwen matanan kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu a ndav anan 'am ata cəna, a slabak way anahan à Galile wa, a zla à Yahudiya, ta day uho sə zlinder sə Urdon. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ɗo ahay bayan a tə pərahan azar, aday a mbar anan ɗo sə ɗəvac a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aday Farisa ahay tə həɗəken ayak pə cakay saa ban anan pə kwande, ta jan: «Tawrita kə̀ varak anan cəveɗ anà mungol sa razl anan uwar kwa pa 'am wura wura ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu a mbəɗahan atan apan, a wa: «Kwanay kə jingen way mə vinde à Deftere a Mbərom ata itəbay ɗaw? À dəlen anahan a inde ɗukwen, Mbərom a ndakay ɗo nà, mungol tə uwar. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aday a ja nà: “Anga nan, ɗo mungol a i mbəsak anan bəbay anahan tə may anahan, i həɗek pə cakay ana uwar anahan. Cew maya a tinen a ti təra nà, zek kərtektəkke coy.” ");
INSERT INTO mqbNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ti naa təra kula inde zek cew sabay. Ti təra zek kərtek sə coy. Anga nan kutok, way a Mbərom sə japay anan ata, ɗowan â sa gəzla anan kula bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisa ahay tə cəce asa: «Kak matanan cukutok nà, Musa a varan cəveɗ ù ɗo aday â varan ɗerewel à alay inde anà uwar anahan aday â razl anan nà, angama kəla anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu a mbəɗahan atan apan, a wa: «Musa a sa varak ikwen cəveɗ sa razl anan uwar a kwanay ahay nà, anga akuray nga a kwanay a kə̀ zalak. Cəkəbay, pə dəlen a wa ɗukwen, cəveɗ inde sa razl uwar ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nen apan ni jak ikwen: Kak ɗowan kə̀ rəzlak anan uwar anahan, aday kə̀ gəɓak uda uwar hinen, ɗowan ata kà gak mədigweɗ, si kak a ban atan pi zek tu ɗo aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Njavar anahan ahay ta jan: «Kak abay matanan à wulen atə ana mbaz tə uwar nà, suwan tə̂ gəɓa zek bay biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu a mbəɗahan atan apan, a wa: «Ɗo ahay fok ta mba apan sə təma atətak way a anan bay. Si ɗowan aya Mbərom sə varan atan gədan ata way anahan aday. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bina, ɗo ahay inde tə gəɓa uwar bay anga tinen mə wahay aya matana coy. Azar aya ɗukwen tə dədasl atan adədasl. Ɗo azar aya ite tə gəɓa uwar bay anga 'am sə bahay a Mbərom a wanahan. Ɗo inde a nan sə təma atətak way a anan nà, â təma kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Natiya, pə dəɓa anahan a wa kutok nà, ɗo ahay ta nan anan ahay gwaslay cacəɗew aya anà Yesu, anga aday â ɗaf patan alay sə ngama. Əna njavar anahan ahay ta ca apan ɗo ahay tinen apan ti nay anan ahay gwaslay ahay ata nà, ta ma nga sə gafan 'am anà ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Əna Yesu a jan anà njavar anahan ahay, a wa: «Mbəsiken anan ahay gwaslay ahay, kə̂ gifen atan 'am sa nay ahay pə cakay uno bay, anga bahay a Mbərom mə lavay zek awan aɗəka nà, anà ɗo sa ga minje tə tinen anaya ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesu a dazlan a ɗaf ngama pə gwaslay ahay a kutok, aday a zla way anahan à man ata wa, a həɗek way anahan ù kon hinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Natiya asa, ɗowan a inde, winen njavar awan, a nay pə cakay ana Yesu. A cəce: «Miter, ni ga mer sa ma lele aday ni saa njaɗ sifa sa ndav bay ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu a mbəɗahan apan, a wa: «Kə cəce puno wa way sa ga lele awan nà, angamaw? Ɗo lele nà, ibay, si Mbərom a kərtek. Əna a nak sa zla à bahay a Mbərom nà, ban anan 'am sə Tawrita ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Winen ite a cəce pə Yesu wa: «'Am ana Tawrita wura aya anaw?» Yesu a mbəɗahan apan, a wa: «Kâ vaɗ nga su ɗo bay. Kâ ga mədigweɗ bay. Kâ ga akar bay. Kâ gaɗ mungwalay pu ɗo bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ɗəfan apan anà atə bəbay tə may anak. Pəlay anan ɗo sə cakay su doh anak kawa iken sə pəlay anan nga anak ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Njavar ata a jan asa: «'Am ataya fok nà, nə bənak atan lele, a mbəsuko maza nə wuraw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu a jan: «Kak a nak sə təra ɗo mənjəna ines fok cəna, zla, sukom anan way tə way anak ahay fok, aday varan anan dala awan anà ɗo mətawak aya awan. Matanan kutok, ki i njaɗ zlile anak à mburom. Aday hayak, pəruho azar.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɗowan ata a sləne 'am ata cəna, a cəɓan, a zla way anahan, anga winen zlile awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu a jan anà njavar anahan ahay kutok, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ma dan 'am awan anà ɗo zlile awan sa zla à bahay a Mbərom inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kə sənen apan zle, zlugweme i ndərmaɗ tə məke sə ləpəre nà, i ga zek bay. Əna ma da 'am a sə zalay way ata nà, ɗo sə zlile sa zla à bahay a Mbərom inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Njavar a Yesu ahay tə sləne 'am ata cəna, a gan atan masuwayan. Anga nan ta wa: «Kak sə matanan cukutok nə, waya saa mba apan saa tam aday sa zla à bahay a Mbərom inde anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu a zəzor atan, a wa: «Pu ɗo zənzen a nà, i ga zek kula bay, əna pə Mbərom nà, matanan bay. Way ahay fok a ga zek ca.» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyer a mbəɗahan apan ta sa jan kutok: «Aday manay həna nà, mə mbəsakak anan way a manay ahay fok sə pərahak azar. Saa təran umo nà, magwagway wuraw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu a jan atan: «Nen apan ni jak ikwen tə ɗiɗem a həna: Pə uho sa nay, à alay nen Wan su Ɗo ni njahay pa man sə njahay sə bahay sə mazlaɓ uno nà, kwanay ɗo sə pəruho azar ahay ɗukwen, ki i njihen pa man sə njahay ahay kuro nga anahan a cew, sa gan sariya anà zahav sə Isəra'ila ahay kuro nga anahan a cew ite re. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aday kuwaya ɗowan a kə̀ mbəsakak doh anahan ahay, mərak anahan ahay, bəbay anahan pi zek ta may anahan, gwaslay anahan ahay kabay guvo anahan ahay anga sləmay uno cəna, i njaɗ uda way anahan ahay nə məcapar bayak awan, aday i njaɗ sifa sa ndav bay ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Anga aday kutok nà, ɗo sa lah pa 'am həna ataya bayak a ti i təra ɗo mə dədəɓa aya cite asa. Aday ɗo sə dəɓa ahay bayan a, azanan ti i təra ɗo ma lah aya ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu a ja asa: «Way sa ga anan minje tə bahay a Mbərom nà, həna: «Bahay su doh a inde a wule pərek sa ra ɗo ahay à guvo. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta ga masa tu ɗo anahan a sa ra ataya nà, i haman atan hway cəna, dala sə dinar kərtek. Aday a zla atan à guvo. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tə njamde dəsuɗo asa, a zla sə pəlay ɗo ahay. A canan anà ɗo hinen ahay ite, tinen mə tavay aya, mer su way inde patan ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A jan atan ite: “Zlen à guvo uno, ni hamak ikwen dala kawa sə ɗo ahay təɗe sə haman ataya awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ta zla à guvo anahan ata re. Man ipec kà gak, bahay sə guvo a zla sə pəlay ahay ɗo maza aya re. A zla tə njamde maakan asa, a ga kawa sə kwakwakwa awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tə njamde ɗara a zla asa, a njaɗ ɗo ahay mə tavay aya, mer su way inde patan ibay re. A cəce patan wa: “Kə tiven hway kəriya, ki gen mer sə awan bay nà, angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tə mbəɗahan apan, ta wa: “Ɗowan kà rak manay à guvo bay kutok nà, mâ ga nə mer sa maw?” Bahay sə guvo ata a wa: “Hayak ikwen ahay, zlen à guvo uno, mer su way inde.” ");
INSERT INTO mqbNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Pac a slahay ù doh nà, bahay sə guvo a jan anà bahay su ɗo si mer su way ahay: “Ngaman ayak anà ɗo si mer su way ahay, haman atan dala a tinen. Dazlan pu ɗo dœk ataya wa, ki ndav anan tu ɗo sə lahak ayak à guvo ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɗo sa zla à guvo tə njamde ɗara ataya ta zlak ayak. Ta njaɗ kuwaya a tinen a dala sə dinar kərtek kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ɗo sa zla à guvo pa 'am ataya ta zlak ayak bine siwaw nà, a ga patan nə tinen ti njaɗ dala sə zalay anan ɗo sa zlak ayak à guvo dœk ataya awan. Aday ɗukwen ta njaɗ nə dinar kərtek kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tə təma anan dala a tinen cəna, ta ma nga sə gungwazan anà bahay sə guvo, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ɗo sa nay ahay həniniye ataya ɗukwen, ta ga mer nə ler kərtek, aday iken pa haman atan hwiya kawa manay. Manay aday nà, ma ga mer nə hway à pac inde, ma yak nga nə ndəlekeke.” ");
INSERT INTO mqbNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bahay sə guvo a mbəɗahan apan anà ɗowan a tinen a kərtek a, a wa: “Car uno, na gak iken tə danakay bay! Kà zlak anak à nga kawa anumo sa ja ata coy. Matanan, ni hamak hway nà, dinar kərtek biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Təma dala anak, zla way anak. U no ni varan anà ɗowan mədakwidok a anan kawa ananak. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Abay ike ni mba apan sa ga anan mer su way tə dala uno kawa su no biɗaw? Ka ga sərak nà, pi nen sa gan sumor anà ɗo ahay ata ɗaw?”» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu a zəga anan apan kutok, a wa: «Natiya, ɗo mədakwidok aya ti naa lah, aday ɗo mama'am aya ɗukwen ti naa təra mədakwidok aya kutok re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu winen apan i zla à Urəsalima nà, a ngaman anà njavar anahan ahay kuro nga cew ataya à wulen sə ɗo ahay wa, a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Sənen anan həna, mənuko apan ɗi zla à Urəsalima. À man ata awan, ti varan nen, Wan su Ɗo, à alay inde anà bahay sə gəɗan dungo anà way ahay anga Mbərom, aday anà miter sə Tawrita ahay. Ti go sariya aday sa vaɗ nen, ");
INSERT INTO mqbNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ti varan nen à alay inde anà ɗo sə pəra ahay. Tinen ite, ti mbasay upo, ti ndaɓay nen, aday ti daray nen pə dədom mə zləlngaɗ awan. Pə dəɓa anahan a wa, luvon maakan anahan i təra nà, nen ni slabakay way uno à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Natiya kutok, uwar ana Zebede, may ana atə Yakuba tə Yuhana, a zla pə cakay ana Yesu, a dukwen gərmec ù vo sə cəce panan wa way. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu a jan, a wa: «A nak nə maw?» Uwar ata a mbəɗahan apan kutok, a wa: «Gwaslay uno ahay cew həna! Varan atan cəveɗ sə njahay pə cakay anak à bahay anak inde ite. Ɗo kərtek a à alay puway anak inde, ɗo hinen ɗukwen à alay gula anak inde ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Əna Yesu a mbəɗahan atan apan ite: «Kə sənen way a kwanay a sə cəce ata bay jiya awan. Ki mben apan sa sa məndolor sə ɗəce uno sa saa sa ɗaw?» Atə Yakuba tə Yuhana ta wa: «Ha, mi mba apan!» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu a mbəɗahan atan apan, a wa: «Tə ɗiɗem awan, ki i sen məndolor sə ɗəce kawa anuno saa sa, əna anjahay à alay puway uno, kabay à alay gula uno nà, nen saa var apan cəveɗ a bay. Man ataya mə lavay zek aya nà, anà ɗo a Bəbay uno sə walay atan saa njahay apan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Njavar a Yesu a azar ataya kuro tə sləne ləbara ata nà, ta ma nga sa ga mivel pu ɗo a cew ataya cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Matanan, Yesu a ngaman atan ayak fok pə cakay anahan awan, a jan atan, a wa: «Kə sənen zle, bahay sə daliyugo ahay tinen apan ti ga bahay pə ɗo ahay nə tə məgala. Aday ɗo sə lavan nga anà ɗo ahay ɗukwen, ta ka anan nə məgala a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Əna, à wulen a kwanay nà, way ataya tə̂ təra itəbay. Aɗəka bay, a nan anà ɗowan a sə təra ɗo məduwen a cəna, â gan mer su way anà ɗo azar aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aday, kak ɗo a kwanay a kərtek a a nan sə təra ɗo mama'am a cəna, â təra ɓile a kwanay a fok aday. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bina nen Wan su Ɗo na nay ahay nà, aday ɗo ahay tû go mer su way bay, əna na nay ahay aday sa gan mer su way anà ɗo ahay aɗəka, ni var anan sifa uno saa bəmbaɗay anan ahay man su ɗo ahay à amac wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Atə Yesu tə njavar anahan ahay tinen apan ti zla way a tinen à Yeriko wa. Ɗo ahay tinen apan ti pərahan azar bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ɗowan aya inde cew hurof aya, tinen mə njahay aya pə cakay cəveɗ. Tə sləne Yesu winen apan i zla tə cəveɗ a tinen ata nà, tə dazlan sa zlah, ta wa: «Bahay a manay, wan a Dawuda, mâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɗo a sa zla ataya ta ma nga sə gafan atan 'am, ta wa: «Ticen 'am, njihen tete.» Əna ɗowan a hurof ataya tə zəga anan apan sa zlah tə məgalak awan, ta wa: «Bahay a manay, wan a Dawuda, mâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu a tavay jek, a ngaman atan ayak, a cəce patan wa: «A nak ikwen nâ gak ikwen nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tə mbəɗahan apan, ta wa: «Bahay, təɓan umo anan iɗe ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta gan ì zek wa anà Yesu. A laman anà iɗe a tinen. Kwayan'a iɗe a tinen ahay tə təɓa ngurret. Tə pərahan azar anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Atə Yesu tə njavar anahan ahay tə dəzle bəse tə Urəsalima, defefe tə wulen su doh sə Baytifaji, pə cakay ana culok sə ngaman Ulivet ata nà, a slan njavar anahan ahay cew, ");
INSERT INTO mqbNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta sa jan atan: «Zlen à wulen su doh a tiya pa 'am a kwanay ata awan. Ki ten anan à nga anà wan sə zungo a inde ta may anahan a ma ɓan awan. Natiya, pəsiken atan ahay, aday hayak ikwen uno atan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta sak a jak ikwen awan a dəp nà, mbəɗihen atan apan nə: “Bahay a gan atan may, i may atan həniniye.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A təra matanan, anga aday 'am ana ɗo maja'am a Mbərom sa ja ata â təra. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Mbərom a wa: «Jen anan anà ɗo sə Urəsalima ahay nà: Kagasl, bahay a kwanay winen apan i nay ahay, winen ma ján a pə zungo. Winen pa wan sə zungo ta may anahan ata awan, anga winen ɗo mə nahay nga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Njavar ana Yesu ataya ta zla, ta ga kawa anahan a sa jan atan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ta nan anan ahay zungo ata ta wan anahan a təke anà Yesu kutok, tə ɓəɓat patan zana a tinen ahay aday Yesu a njahay apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ɗo azar aya bayak tə wadaɗ anan zana a tinen ahay pə cəveɗ. Ɗo azar aya asa, tə ngərway ahay alay si sé ahay aday sə ɓəɓat pə cəveɗ a re. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ɗo sə lahan pa 'am anà Yesu ataya, tatə ɗo sə dəɓa ahay fok, tinen apan ti zlah, ta wa: «Həren anan nga anà wan a Dawuda! Mbərom â ɗaf alay sə mazlaɓ anahan pu ɗo saa nay tə sləmay anahan ata awan. Həren anan nga anà Mbərom à bagəbaga mburom.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu i dəzle à Urəsalima coy nà, wulen su doh ata fok a ɓal cuwaɗ cuwaɗ. Ɗo ahay ta wa: «Ɗowan a anan nə winen wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Man sə ɗo ahay tə mbəɗa apan, ta wa: «Winen nə Yesu, ɗo maja'am a Mbərom, ɗo sə Nazaratu pə daliyugo sə Galile.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu a zla ù doh sə mazlaɓ a Mbərom kutok. A razl anan ɗo sə sukom anan way tə way ahay aday ɗo sə sukom way ahay fok uho. A fakay anan tabal su ɗo sə bəmbaɗ dala ahay, pi zek ta man sə njahay su ɗo sə sukom anan way tə kurkudok ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","A jan atan, a wa: «Mə vinde a à Deftere a Mbərom inde nà, natiya awan: “Ti ngaman anà doh sə mazlaɓ uno nà, doh sa ga amboh.” Aday kwanay kə təren anan həna, lar su ɗo sə ngəzar ɗo ahay a nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hurof ahay pi zek tu ɗo vədal aya ta nay pə cakay ana Yesu ù doh sə mazlaɓ a Mbərom, a mbar atan fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Əna bahay sə gəɗan dungo anà way ahay anga Mbərom pi zek tə miter sə Tawrita aya tə canan anà way a Yesu a sa ga masuwayan aya, aday tə sləne gwaslay ahay ù doh sə mazlaɓ a Mbərom tinen apan ti zlah «Həren anan nga anà wan a Dawuda!». Way ata a gan atan nə wadan wadan. Tə dazlan sa ga mivel pə Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta jan, ta wa: «Way a gwaslay ahay tinen apan ti ja ata nà, kə sləne zle dəp ɗaw?» Yesu a mbəɗahan atan apan, a wa: «Nə sləne zle. Kə jingen 'am ata à Deftere a Mbərom inde itəbay kələɗaw? A wa: “A nak nə təbəlem sə gwaslay ahay pi zek tə dungo sa wan gindez aya ti hərak nga.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu a mbəsak atan à man ata awan, a zla way anahan à Baytiniya, a sa nahay à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu winen apan i may ahay à Urəsalima sidew a duwdew nà, may a han apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","A canan ayak anà buway pə cəveɗ, a həɗəken ayak ù vo. A ca apan nà, daslam a ɗəkɗek. Wan a ibay. A jan 'am anà buway ata awan: «Kula iken ki njaɗ wan ite sabay.» Cəna, buway ata a kuray sokok kwayan'a. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Njavar anahan ahay tə canan cəna, a gan atan masuwayan, tə cəce: «Buway a anan a kuray bəse kwayan'a kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu a mbəɗahan atan apan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kak aɗaf nga a kwanay inde, aday awan kà gak ikwen hiyem hiyem bay cəna, ki mben apan sa ga way uno sa gan anà buway a anan. Aday ki mben apan sa jan kwa anà ɓəzlom a anan: “Slabak à man a anan wa, zla à bəlay inde!” Aday i təra kawa ana kwanay sa ja ata acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kak aɗaf nga a kwanay inde nà, ki njiɗen anan way a kwanay saa cəce à amboh a kwanay inde ataya nə fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu a ma ù doh sə mazlaɓ a Mbərom, aday winen apan i tətakan anan way anà ɗo ahay. Bahay sə gəɗan dungo anà way ahay anga Mbərom, pi zek tə məceɗ sə Yahuda ahay tə həɗəken ayak pə cakay anà Yesu. Tə cəce panan: «Ka ga way anak a anan ataya nə tə məgala ana wayaw? Sə varak cəveɗ a nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu a a mbəɗahan atan apan: «Nen ɗukwen, ni cəce pikwen wa way kərtek. Kə̂ mbəɗihen uno apan aday. Ata nen ni jak ikwen ite, na ga way a anaya tə məgala a wayaw nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sə slənay anan ahay Yuhana sa gan baptisma anà ɗo ahay nə wayaw? Mbərom ɗaw, kabay ɗo zənzen a ɗaw?» Tinen ite, tə mbəɗa 'am pi zek a tinen awan, ta wa: «Ɗi jan həna nà, kəkəmaw? Kak ɗa sak a jəka, Mbərom sə slənay anan ahay nà, i jak uko asa: “Kak kə sənen apan zle cukutok nà, kə ɗəfen apan nga bay nə angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aday kak ɗa sak a jəka, ɗo zənzen a sə slənay anan ahay nà, ata guko ngatay, bina man su ɗo a ɗukwen i vawak uko nga. Bina a ga patan nà, Yuhana nə ɗo maja'am a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Anga nan kutok, tə mbəɗahan apan anà Yesu, ta wa: «Ma san bay!» Yesu a wa: «Kak sə matanan cukutok ata nà, nen ɗukwen ni ɗakak ikwen anan ɗowan a sə vuro məgala sa ga mer su way anaya bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu a jan anà məceɗ sə Yahuda ataya asa, a wa: «Bayiken pə ləbara inde həna aday. Ɗowan a inde nà, gwaslay anahan ahay inde cew. A jan anà wan kərtek awan: “Dəna uno, zla à guvo. Kâ sa ga mer.” ");
INSERT INTO mqbNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wan ata a mbəɗahan apan anà bəbay anahan nà: “Ni zla bay.” A jalay pə dəɓa anahan a wa nə, a zla à guvo ata cukutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bəbay a tinen ata a zla pə cakay ana wan hinen, a jan kawa ana wan a mama'am ata re. Wan ata ite a mbəɗahan apan ta sa ja nà: “Ni zla.” Əna kà zlak à guvo ata bay aɗəka bugol. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","À wulen sə gwaslay ahay a anaya wa nà, sa ga way sa zlan à nga anà bəbay nə wan wuraw?» Tə mbəɗahan apan anà Yesu nà: «Wan mama'am awan!» Yesu a jan atan kutok, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo sə cakal jangal ahay, tə uwar sa ján uho tə ɗo ahay so ataya ti i lahak ikwen à bahay a Mbərom inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yuhana ɗo sa gan baptisma anà ɗo ahay kà nak sə ɗakak ikwen anan cəveɗ lele sə ɗəfan apan anà Mbərom, aday kə ɗəfen nga pa 'am anahan aya bay. Əna ɗo sə cakal jangal ahay, tə uwar sa ján uho tə ɗo ahay so ataya, tinen tə ɗəfak nga pa 'am ana Yuhana. Kə cinen anan, əna kə ngəmen sə mbəɗahan lœn anà azla a kwanay lelibay ataya bay hwiya, aday kə ɗəfen nga pa 'am anahan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu a jan atan asa, a wa: «Pəken sləmay pə jike a hinen həna re. Ɗowan a inde a jule təroz à guvo. A ga apan jal, a ɗaf uda kuɗom məduwen a sa zlaɓ uda wan si sé. A ɗezl uda lagaɗ zəbor awan anga ɗo sa ba anan guvo ata awan. A mbakan anan guvo à alay inde anà ɗo si mer su way ahay, a zla way anahan à man dəren awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«À alay a ɗo ahay tinen apan ti ban təroz nà, bahay sə guvo a slan ɗo anahan ahay pə cakay ana ɗo sa ga mer à guvo ahay saa təmahan ahay mbala anahan ite. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Əna ɗo sə guvo ataya tə canan atan cəna, ta ban atan. Ta ndazl anan ɗo kərtek a leɗəɗɗe. Ɗo mə slala cew a ta vaɗ anan bəskol à məke. Ɗo mə slala maakan awan, ta ra apan kon sa tar anan gəngaf gəngaf. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bahay sə guvo ata a zəga anan apan sa slan ɗo ahay bayak a re. Əna ɗo sa ga mer ahay à guvo, ta gan atan nə kawa ana ɗo sə kwakwa ataya re. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pə dəɓa a tinen ata wa fok nà, bahay sə guvo a slənan atan ayak wan si zek anahan awan. A bayak nà: “Wan si zek uno ɗəgerger nà, ti ɗəfan apan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Cəkəbay ɗo sa ga mer ahay tə canan anà wan si zek anahan ata aɗəka nà, ta ja à wulen a tinen inde, ta wa: “Sa naa pa 'am sə guvo a aɗəka nə winen. Bənuko anan, vəɗuko anan. Ata guvo a anan i təra a mənuko.” ");
INSERT INTO mqbNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ta ban anan wan ata awan, tə ngəza anan uho à guvo wa, ta vaɗ anan kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Natiya kutok Yesu a cəce: «Bahay sə guvo ata kà sak a nay ahay tə alay anahan a nà, i ga anan ɗo si mer su way ataya nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Məceɗ sə Yahuda ataya tə mbəɗahan apan, ta wa: «Bahay sə guvo kà nak nà, i ga atan alay ndəlekeke, aday i vaɗ atan kutok. I mbəsakan anan guvo ata anà ɗo maza aya awan, aday i njaɗ patan wa magwagway sə guvo anahan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Anga nan, Yesu a jan atan kutok, a wa: «Kula kə jingen anan 'am a anan à Deftere a Mbərom inde itəbay kələɗaw? “Kon mbala ana ɗo sa ɗezl way ahay sa lar anan ata nà, sə təra kon sə mide lele aɗəka nà, winen. Sa ga way ata ɗukwen, zek ana Mbərom Fetek awan. Way ata a gak uko masuwayan pə iɗe.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Yesu a ja asa, a wa: «Kak ɗowan a kə̀ slahak pu kon ata nà, kon ata i nes anan. Aday kon ata kà sak a slahay pə ɗowan a ite ɗukwen, i ngəlaɗ anan. Anga nan, Mbərom i təma pikwen wa bahay anahan, i varan anan anà ɗo ahay aday ti ɗəfan apan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bahay sə gəɗan dungo anà way ahay pi zek tə Farisa aya tə sləne ləbara a Yesu a sa ga anan jike ata nà, ta san zle kutok, Yesu a ja nə pə tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tə pəlay abay sa ban anan, əna tə jəjaran anà man su ɗo sə pərahan azar a Yesu ata awan. Bina ɗo ataya ta ja nà, Yesu nə winen ɗo maja'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu a gəɓa jike maza asa sa jan anà ɗo ahay. A jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Way maza həna sa ga anan minje tə bahay a Mbərom re. Bahay a inde a lavay anan zek tə way sa pa sə azar uko bayak a anga wan anahan i gəɓa dalay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A slan ɗo si mer su way anahan ahay saa ngaman ahay anà ɗo mə ngamay ataya, pə way sa pa. Əna tə ngəmay ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A slan ɗo maza aya sa jan anà ɗo mə ngamay ataya nà: “Way sa pa ma da coy. Nə vəɗak guson sa sla ahay, pi zek ta sla mə ɗəɗok aya awan. Way ahay fok nə lavak anan zek anga agəɓa dalay coy. Hayak ikwen ahay!” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Əna ɗo a mə ngamay ataya ta gak anan nga anà angamay ata bay. Ta zla way a tinen ahay, ɗo hinen à guvo, ɗo hinen à lumo. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ɗo maza aya ite, ta ma nga sa ban anan ɗo si mer su way ataya, ta ga atan alay, aday ta vaɗ atan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«A cəɓan anà bahay ata awan. A slan suje ahay saa vəɗay anan ɗo sa vaɗ ɗo ataya, aday sə vakan atan anan wulen su doh a tinen ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pə dəɓa anahan a wa asa, a jan anà ɗo si mer su way anahan ahay, a wa: “Way sa pa mə lavay zek a anga azar uko sə gəɓa dalay coy. Əna ɗo a mə ngamay ataya ta slak təɗe sa pa anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Zlen ayak pə məgəzləga cəveɗ ahay, ngimen anan ahay anà ɗowan a kwanay saa canan ataya fok, tâ nay à azar uko.” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɗo si mer su way ataya ta zla pə cəveɗ, tə halan nga anà ɗo aday tinen sa njaɗ ataya fok, ɗo lele aya awan pə kərtek a tə ɗo sə huwan ahay re. Natiya kutok, doh sə azar uko ata a rah tə ɗo ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Zek a bahay a zlak ayak sa ca pə ɗo a mə ngamay ataya kutok. Aya əna, a canan anà ɗowan a inde, winen nà, zana sə azar uko inde pi zek ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bahay ata a jan: “Car uno, ka nay à man a anan mənjəna zana sə azar uko nə kəkəmaw?” Ɗowan ata kə̀ mbəɗahak anan apan awan a ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bahay a jan anà ɗo si mer su way anahan ahay, a wa: “Jiwen anan, liren anan ayak uho, ì iɗe zənzen inde, à man aday ɗo ahay ti yam ta sa rac slan ata awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu a zəga anan kutok, a wa: «Mbərom a ngaman anà ɗo ahay nə bayan awan, əna ɗo mə walay aya ite nà, bayan a bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Natiya Farisa ahay tə halay nga, tə pəlay cəveɗ sa ban anan Yesu pə mungok sa 'am anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ta slan njavar a tinen ahay pi zek tu ɗo ana Hiridus ahay. Ɗo ataya pə kərtek a kutok, ta jan à Yesu, ta wa: «Miter, ma san zle, iken nə ɗo ɗiɗem awan. Kə tətakan anan anà ɗo ahay ɗukwen, ɗiɗek sə way ana Mbərom sa jan anà ɗo ahay tâ ga ata awan. Kə jəjaran anà 'am sə ɗo ahay bay, kə zəzor way sə wuteɗ iɗe itəbay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jan umo, kə bayak nə kəkəmaw? Cəveɗ inde sə varan jangal anà bahay sə Ruma ɗaw? Bəzi mə̂ varan bay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu a san sədœk a tinen a zle. Anga nan a jan atan kutok: «Kwanay nə mbaɗəmbaɗa aya ɗaw? Ki ngen upo ɓalay angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ken uno anan ahay dala sə jangal awan aday!» Ta kan anan karanga awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu a təma anan, aday a jan atan: «Pə karanga a anan nà, mezeze a wayaw, aday mə vinde apan nà, sləmay a wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tə mbəɗahan apan kutok: «Wita nà, mezeze tə sləmay ana bahay sə Ruma.» Yesu a jan atan kutok: «Lele, kak matanan cukutok nà, viren anan anan way ana bahay sə Ruma anà bahay sə Ruma, aday way a Mbərom anà Mbərom a ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tə sləne cəna, a gan atan masuwayan. Tə mbəsak anan Yesu, ta zla way a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pə luvon ata kərtek awan, azar su ɗo aya inde, tinen Saduki ahay, ta nay ahay pə cakay a Yesu sə cəce panan 'am. Tinen a aday nà, ta wa ɗo kə̀ məcak nə i slabakay ahay sabay. Anga nan tə cəce 'am a anan pə Yesu wa, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Miter, Musa kə̀ vindek umo, a wa: “Ɗo kə̀ məcak aday kə̀ mbəsakak uwar mənjəna wan nà, mərak a məsinde ata â gəɓa anan mədukway sə uwar awan aday ti wahan məgije anà ɗowan a ma mac ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ɗowan aya inde àga manay cuwɓe, tinen tə mərak ahay. Ɗo zek məduwen awan, a gəɓa uwar, a mac mənjəna sa njaɗ panan wan. Ɗo sa mban apan a həɗek anan uwar ata mədukway awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Winen ite a mac re, tə wahak bay a re. Ɗo mə slala maakan a həɗek anan asa ite re. Matanan fok a tinen a cuwɓe awan, tə wahak pi zek tə uwar ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pə dəɓa a tinen a wa fok ɗukwen, zek a uwar ata a mac re. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ata pə luvon saa slabakay ahay à məke wa ata nà, uwar ata i təra nə uwar a wayaw? Bina cuwɓe a tinen a, tə gəɓak anan pa sə uwar a re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu a dazlan, a mbəɗahan atan apan kutok, a wa: «Kwanay apan ki zluwen à cəveɗ wa, anga kə sənen Deftere a Mbərom bay, kə sənen məgala ana Mbərom bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bina, ɗo ahay tə slabakak ahay à məke wa nà, kwa ɗo mungol aya awan, kwa ɗo uwar aya ɗukwen, ti i gəɓa zek ahay sabay fok. Anga ti i təra à mburom nà, kawa maslay a Mbərom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aday pa 'am sə slabakay ahay à məke wa ata nà, kə jingen way ana Mbərom sa jak ikwen ata itəbay kələɗaw? Mbərom a ja nà: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nen nà, Mbərom ana Ibərahima, Mbərom ana Isiyaku, aday Mbərom ana Yakob.” Mbərom, winen nà, Mbərom su ɗo ma mac aya bay, əna winen Mbərom su ɗo tə sifa aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ɗo ahay bayak a tə slənek atətak way anahan ataya awan, aday atətak way anahan ata a gan atan masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisa ahay tə sləne sa jəka Yesu kə̀ mbasak pə Saduki ahay ata nà, tə halay nga à man ata kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɗo a tinen a kərtek, winen miter sə Tawrita awan, a cəce panan wa way aday sa ban anan pə kwande, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Miter, à Tawrita inde nà, nga sa 'am mə baslay aya fok nà, wura məduwen a aday a zalay azar aya anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu a mbəɗahan apan, a wa: «“Pəlay anan Mbərom Fetek, Bahay anak nə tə mivel anak a təke, tə apasay anak a təke, aday tə abayak nga anak a təke.” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Natiya sə təra nga sa 'am mə baslay a məduwen a aday a zalay azar aya nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hinen aday sə lavay tə winen ata həna re: “Pəlay anan ɗo sə cakay su doh anak kawa iken sə pəlay anan nga anak ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tawrita a Musa pi zek ta 'am ana ɗo maja'am ana Mbərom ahay fok, tə bənay nə pa 'am a cew a anan ataya wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisa ahay tinen mə halay nga à man ata hwiya. Anga nan, Yesu a cəce patan wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kwanay kə bayiken ma pə Almasihu anaw? Aday ki jen nə winen wan ana wayaw?» Tə mbəɗahan apan, ta wa: «Winen wan ana Dawuda.» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu a jan atan kutok, a wa: «Aday Dawuda a ngaman bahay anahan nà, kəkəma asa anaw? A ja 'am tə məgala ana Apasay Cəncan awan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Mbərom Fetek a jan anà Bahay uno: Njahay à alay puway uno, aday ni nahay anan ɗo sa nak iɗe ahay, ki ján patan tə saray.” ");
INSERT INTO mqbNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Kak Dawuda a ngaman anà Almasihu nə “Bahay uno” bugol nà, winen i saa təra wan ana Dawuda nə, kəkəma asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɗowan kwa kərtek sə mbəɗahan apan nà, ibay. Pə dəɓa wa nà, kuwaya a jəjar sə cəce panan 'am maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Natiya, Yesu a jan 'am anà man sə ɗo ahay tə njavar anahan ahay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Miter sə Tawrita ahay pi zek tə Farisa ahay nà, mer su way a tinen aya nə sə ɗakan anan Tawrita a Musa anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ɗəfen anan apan anà atətak way a tinen, aday gen way a tinen sa jak ikwen ataya fok. Əna kî gen way a tinen sa ga ataya bay, anga tinen a ta ga way a tinen sa ja ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bina, tə ɓanan way ma ba aya pa nga anà ɗo ahay, əna ta ngam sa man atan zek sə tavakan atan pa nga kwa ta wan sə alay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Ta ga way ahay fok nà, pə iɗe sə ɗo ahay aday tə̂ canan atan. Anga nan, zlangar a tinen sa nga aday sa ɗaf pi zek ataya nà, məduwen aya awan. Aday way a tinen sa tam pa 'am sə zana a tinen ahay ɗukwen nà, zəbor aya re. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta zlak à man sa pa way nà, tə pəlay man sə njahay lele aya awan. Tinen ù doh sə wazay ahay cəna, ta ca wa ɗukwen man zəbor aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta gan may nà, ɗo ahay ta jan atan 'am à kwasuko nà, tə akərdeh aya awan, à wulen sə ɗo ahay inde fok. Aday ta gan may nà, ɗo ahay tə ngaman atan nə “Miter.” ");
INSERT INTO mqbNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Əna kwanay nà, kə̂ ngəmen tə̂ ngamak ikwen “Miter” itəbay. Anga miter a kwanay inde nà, si kərtek. Kwanay fok nà, tə mərak ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kâ sa ngimen anan anà ɗowan “Bəbay” pə daliyugo bay. Bəbay a kwanay inde kərtek ɗukwen, winen à mburom. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kə̂ ngəmen sə ngamak ikwen “Bahay nga” ahay bay re, anga bahay nga a kwanay inde nə kərtek, Almasihu. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɗowan a məduwen a à wulen a kwanay ata â təra aɗəka nà, ɗo si mer su way a kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɗowan a kə̀ pəlak man sə njahay pa 'am sə ɗo ahay cəna, ti ɗaf anan à dəɓa à məndak aɗəka. Aday ɗo mə nahay nga sə njahay à dəɓa ata ite nà, ti ɗaf anan pa 'am sə ɗo ahay kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Anga kə ticen anan məsudoh sə bahay a Mbərom pə ɗo ahay wa. A nak ikwen anà kwanay a sa zla uda bay, aday kwanay gədek a gafan 'am anà ɗo ahay sa zla uda re.  ");
INSERT INTO mqbNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Anga kwanay apan ki ngəzəren way pə mədukway sə uwar ahay wa. Kwanay apan ki gen amboh ɗukwen, ki gen nə zeɗeɗeɗe bayak awan, anga aday ɗo ahay tə̂ canak ikwen. Əna kwanay nà, Mbərom i gak ikwen sariya ma da 'am awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Kwanay apan ki bəren kwa aha pə daliyugo, pa nga sə bəlay ahay, anga aday kə̂ njiɗen ɗo kərtek sə pərahak ikwen azar. Ata ki təren anan ɗo saa njaɗ sariya a Mbərom a zal kwanay a saray cew aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ɗəce inde anga kwanay! Kwanay ɗo hurof aya aday ki jen ki bənen anan alay anà ɗo ahay ata awan. Aday ki wen: “Ɗowan a kə̀ mbaɗak anan tu doh sə mazlaɓ a Mbərom nà, wita kə̀ mbaɗak bay. Əna kə̀ mbaɗak tə gura a ù doh sə mazlaɓ a Mbərom ata nà, ata ambaɗay anahan nə lele awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kwanay nə hurof aya aday ɓəlɓəle aya nà, angamaw? Gura a aday ù doh sə mazlaɓ a Mbərom ata nà, winen way ma gan nga awan, anga winen ù doh sə mazlaɓ anahan. Sə zalay way hinen nə maw? Gura ɗaw, kabay doh a sə təra anan gura ata cəncan ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aday asa, ki wen: “Ɗowan a kə̀ mbaɗak anan ta man sə gəɗan dungo anà way anga Mbərom ata nà, wita kə̀ mbaɗak bay. Əna kə̀ mbaɗak tə way a ma gaɗ dungo pa man ata nà, ata ambaɗay anahan nə lele awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kwanay nà, hurof aya acəkan! Sə zalay way nə maw? Way ma gaɗ dungo coy ata ɗaw, kabay man sə gəɗan dungo anà way aday a təra anan way ata cəncan a ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Matanan, kak ɗowan a a mbaɗay nə ta man sə gəɗan dungo anà way ata nà, kə̀ mbaɗak anan tə way a ma gaɗ dungo ata pi zek ta man sə gəɗan dungo anà way ata təke biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ɗo sə mbaɗay anan tu doh sə mazlaɓ a Mbərom ata ɗukwen, a mbaɗay nə tə Mbərom a sə njahay ù doh sə mazlaɓ ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɗo sə mbaɗay anan tə mburom ite a mbaɗay ɗukwen ta man sə njahay a Mbərom, aday tə Mbərom a mə njahay a uda ata təke. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Anga kə rəzlen anan à nga wa sa var alay mbok wa kərtek sə daslam ahay cara cara nə lele. Əna kə mbəɗəken anan à nga wa sa ga mer su way ta 'am məduwen aya à Tawrita inde, kawa sa ja nà, sa ga way tə cəveɗ awan, sa gan sumor ù ɗo, sa ɗaf nga pə Mbərom tə mivel kərtek awan. Abay təɗe ki gen nà, way ataya awan, mənjəna sə mbəsak sa ga way a azar aya re. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kwanay hurof ahay, aday ki jen ki bənan anan alay anà ɗo ahay! Kwanay apan ki ɗəzen anan a'am anga sə gəɓa anan wa makwakwaɗ ahay, əna kwanay apan ki səɗəken anan zlugweme mənjəna asan apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Kwanay nà, ki gen minje nə tə gəsa'am kabay tuwez. Kə cakiɗen anan day sə uho aya lele cəna coy. Aday cəkəbay, ta su doh sə mivel a kwanay ahay nà, mə cakaɗ aya bay. Mivel a kwanay ahay ma rah aya nà, tə ubor a kwanay ahay tə way a kwanay mə kəra aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kwanay Farisa ahay hurof aya awan, cakiɗen anan kutov sə gəsa'am a kwanay ahay, aday day sə uho a i saa təra mə cakaɗ a lele biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Anga ki gen minje tə jəvay mə sluray aya awan. Ta day sə uho nà, a dav nə herre. Cəkəbay ta su doh aya nə ma rah a tə məsinde ahay, aday tə way mə wuslay aya cara cara bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kwanay həna ɗukwen, kətanan. Ta day sə uho nà, kwanay kawa ɗo ɗiɗek aya awan, əna ta su doh a ite nà, kwanay ma rah aya tə mbaɗəmbaɗa aday tə sədœk aya ɗəkɗek.» ");
INSERT INTO mqbNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kwanay, miter sə Tawrita ahay, Farisa ahay, kwanay ɗo sə mbaɗəmbaɗa ahay, wawayah, ɗəce i tərak ikwen! Kwanay apan ki ɗəzlen anan jəvay anà ɗo maja'am a Mbərom ahay. Kwanay apan ki sluren anan jəvay su ɗo ɗiɗek aya awan, ");
INSERT INTO mqbNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","aday ki jen, ki wen: “Ta wa abay mâ ga inde kwakwa ata tə bije a manay ahay nà, mi japay ahay tə tinen sa vaɗ anan ɗo maja'am a Mbərom ahay bay.” ");
INSERT INTO mqbNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kə ɗiken anan həna ata nà, kwanay wan ana ɗo sa vaɗ anan ɗo maja'am a Mbərom ataya re. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Həna nà, ki ndəven anan mer su way ana bije a kwanay sə dazlan ahay ataya cukutok ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Kwanay dədew ahay biɗəka, kwanay wan su kòn ahay. Ki mben apan sa tam anan nga a kwanay à sariya sa zla à məke sə mərda ata wa nà, kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Matanan kutok, slənen anan 'am a anan aday: Ni slan ɗo maja'am a Mbərom ahay tu ɗo kəlire aya, aday tə miter ahay àga kwanay. Azar aya ki vəɗen atan kabay ki diren atan pə dədom mə zləlngaɗ aya awan. Azar aya ite ɗukwen, ki naa ndiɓen atan ù doh sə wazay a kwanay ahay, ki hiwen atan azar ɗukwen kwa ta sə wura fok asəka. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Anga nan kutok, mez su ɗo ɗiɗek aya sa mac pə daliyugo a anan ataya fok i nay ahay pikwen. A bənay ahay kwa pə amac ana Abel wa, hus pə amac ana Zakari, wan ana Barakiya, ɗowan a kwanay sa vaɗ à gala su doh sə mazlaɓ a Mbərom à wulen ana atə man cəncan a ta man sə gəɗan dungo anà way ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nen apan ni jak ikwen tə ɗiɗem a həna, Mbərom i gan sariya anga way ataya fok nà, anà ɗo a wuswes a anan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Hayaka Urəsalima ahay! Kwanay ɗo sə Urəsalima ahay! Kə vəɗen anan ɗo maja'am a Mbərom ahay, aday kə tiren anan ɗo a Mbərom sə slənak ikwen ahay ataya tu kon. Aday saray bayak a, na gak anan may sə halak ikwen nga anà kwanay ɗo sə Urəsalima ahay ù vo uno, kawa man njəkar sə halan nga anà wan anahan ahay à bərgaslay inde ata awan. Hwiya kə ngəmen bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ihe, doh sə mazlaɓ a Mbərom a kwanay i təra rəgay. ");
INSERT INTO mqbNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Matanan, ni jak ikwen anan: Ki cinen uno sabay, si azanan ki naa cinen uno nà, à alay a aday ki i jen: “Mbərom â ɗaf alay sə mazlaɓ anahan pu ɗo sa nay ahay tə sləmay anahan ata awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pə dəɓa anahan a wa, Yesu a nay ù doh sə mazlaɓ a Mbərom wa, winen apan i zla way anahan. Njavar anahan ahay tə həɗek pə cakay anahan, aday tə ɗakan pu doh mi ɗezl aya à gala su doh sə mazlaɓ a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aday Yesu a jan atan kutok, a wa: «Kə cinen anan anà doh a anaya zle fok biɗaw? Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo maniɗe ahay ti mbazl anan. Kon hinen saa ɗinger zek pə hinen nà, ibay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu a njahay à ɓəzlom sə Ulivet. Njavar anahan ataya tə həɗəken ayak pə cakay, tinen a taayak, aday tə cəce panan wa, ta wa: «Jan umo biɗaw? Doh sə mazlaɓ a Mbərom i saa mbazl nə siwaw? Minje sa ma i ga aday mi saa san ki may ahay aday daliyugo i ndav coy anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu a mbəɗahan atan apan, a wa: «Liven anan ì zek a kwanay ahay lele, ɗowan â sa njak kwanay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anga ɗo ahay bayak a ti gəɓa sləmay uno, ti nay, kuwaya i ja winen nə Almasihu. Ti njak anan ɗo ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ki slənen ləbara sə vəram ahay cara cara, kwa dəren, kwa bəse, əna kə̂ jəjiren anan bay. Anga təktek way ataya ti təra aday. Əna wita kə̀ dəzlek pə andav ana daliyugo fan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kon a anan, i slabak pu kon hinen, bahay a anan i vaɗ zek tə bahay hinen. À man ahay cara cara may i ga, aday daliyugo i ɓal matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɗəce ataya fok ti təra nə kawa wan sə dəlay anan uwar ti zek cew ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«À alay ata nà, ti varan kwanay à alay inde anà ɗo ahay aday tâ ga alay tə kwanay, tâ vaɗ kwanay à məke sa ndaw. Ɗo su kon ahay fok ti nak ikwen iɗe anga kwanay njavar uno ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","À alay ata kutok, ɗo ahay bayak a ti mbəsak sa ɗaf upo nga, ti ga ɗaf pi zek ahay, ti nan iɗe ì zek ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɗo maja'am a Mbərom mungwalay aya bayak a ti nay ahay, ti zluwe anan ɗo ahay bayak a cite. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mer su way sə sədœk i zakay aday asan zek sə ɗo ahay bayak a i səfe. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Əna ɗowan a kə̀ səmak anan hus à andav a inde cəna, winen i tam. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ti ɗakay anan ləbara sə bahay a Mbərom mugom a anan pə daliyugo kəzlek, aday ɗo su kon ahay fok ti sləne anan. Ata daliyugo i sa ndav kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ki i cinen anan anà səkar sə lize way i tavay à man cəncan awan, kawa ana ɗo maja'am a Mbərom Daniyel sa ja apan ata awan. (Ɗowan a kə̀ jingek anan 'am a anan nà, â sənan anan anà nga anahan nə lele.) ");
INSERT INTO mqbNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","À alay ata asanaw nà, ɗo sə Yahudiya ahay tâ haw sa ma nga à ɓəzlom ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ɗo aday winen pa nga su doh ɗukwen â dazay, â haw, əna â sa ray ahay way anahan ahay ù doh wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ɗowan a winen à guvo ɗukwen, â saa nay ahay agay sa naa gəɓak ayak zana anahan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wuna, pa pac ataya nà, ɗəce inde anga uwar ti zek cew aya awan, aday anga uwar ta wan a à bak ataya re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gen anan amboh à Mbərom aday ahaw a kwanay â sa təra à alay sa maɗ kabay pə luvon sa man uda bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Anga à alay ata nà, ɗəce i zalay, bina kwa ana Mbərom sə ndakay daliyugo hus ahay biten ɗukwen, ɗəce kawa winen ata kə̀ tərak kula bay, aday inde i təra kula sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Əna, Mbərom kə̀ kəcak anan luvon ataya bay nà, abay ɗowan saa tam nà, ibay. Əna, kə̀ kəcak anan luvon awan anga ɗo anahan a sə walay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«À alay ata nà, ɗowan a kà jak ikwen: “Almasihu winen həna” kabay “Winen tiya” nà, kâ sa ɗəfen apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anga almasihu ahay mungwalay aya bayak a ti nay ahay pi zek tu ɗo sə jəka tinen ɗo maja'am a Mbərom ahay. Ti ga minje sə way ahay, tə masuwayan aya cara cara sa njak anan kwa ɗo mə walay aya awan, abay a ga zek nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na jak ikwen anan pi zek wa kurre. Sənen pi zek lele. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ta sak a jak ikwen: “Almasihu winen tiya pə pala à kiɓe” nà, kî zlen saa cay anan ahay bay. Kabay ta sak a jak ikwen: “Winen mi ɗer zek a həna” ɗukwen, kə̂ təmihen 'am ata bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bina Wan su Ɗo i nay ahay nə kawa awuteɗ a Mbərom sə wuteɗ pəraɗ, a dav kwa aha ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","À man a aday way ma mac a inde ata cəna, mugudok ahay ti halay nga bayak a nà, à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Pə luvon sə ɗəce ataya sa ndav cəna, pac i dav sabay, kiya ɗukwen matanan. Mawuzlawazl ahay ti gucey ahay à məndak, aday ɗukwen məgala sə way ahay à mburom ataya, ti ɓal. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ata minje mbala Wan su Ɗo i kay ahay zek pa nga mburom kutok. À alay ata, ɗo su kon ahay fok ti zlah, ti yam. Ata, ti canan anà Wan su Ɗo winen apan i may ahay pə matapasl ahay pa nga mburom tə məgala awan, aday tə mazlaɓ a bayak a re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Məzləzlilen məduwen a i fa zek. Aday Wan su Ɗo i slənay ahay maslay anahan ahay, ti halan nga anà ɗo anahan a sə walay ataya kwa ta sə wura fok hus pə magaga sə daliyugo.» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Sənen pə way ana buway sə ɗakak ikwen anan ata aday. Kə cinen anan anà alay anahan aya ta gak kulɓosloslo nà, daslam aya ɗukwen ta ɗak, ata kə sənen zle coy viya winen apan i slay bəse. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Matanan re, kə cinen anan anà way uno sə ɗakak ikwen anan ataya cəna, sənen a nà, nen Wan su Ɗo, nen apan ni may ahay bəse, nen pə alay sə məsudoh. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nen apan ni jak ikwen tə ɗiɗem a həna: Əlek ɗo sə biten ahay ti i mac nà, way ataya fok ti təra. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Daliyugo i ndav, kərngay i slukwac pə bagəbaga mburom, əna 'am uno nà, i ndav itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Əna, ɗowan saa san luvon sə way ataya nà, ibay. Maslay a Mbərom ahay ta san bay, nen wan anahan a ɗukwen na san bay. Sa san luvon a cəna, si zek a bəbay uno Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","À alay a Wan su Ɗo i may nà, way ahay ti təra nə kawa sə təra à alay ana Nuhu ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","À alay ata nà, ɗo ahay tinen apan ti taslay mivel sa pa way ahay, ta sa sa way a tinen ahay, mungol ahay ti gəɓa dalay, dəna ahay ɗukwen ti zla à mbaz, hus pə luvon ana Nuhu sa zla way anahan à kwalalan inde ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɗo ataya fok, tə sənak pi zek bay, hus pə luvon ana a'am sa rah anan daliyugo aday a ra atan fok ata awan. À alay ana Wan su Ɗo sa may ahay ata ɗukwen, i təra nə kətanan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«À alay ata kutok, ɗo ahay cew ti ga mer à guvo kərtek awan, ɗo kərtek a nà, ti gəɓa anan, aday ɗo hinen nə ti mbəsak anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uwar ahay cew ti gan pa van kərtek awan, ɗo kərtek a nà, ti gəɓa anan, aday ɗo hinen nə ti mbəsak anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Njihen cəna, mə lavay zek aya awan, bina kə sənen luvon ana Bahay a kwanay sa nay ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","«Sənen pə way inde lele aday: Kak bahay su doh awan, a san apan zle, à alay a həna anan nà, ɗo sə akar ahay ti nay ahay àga winen saa zləray anan ahay nà, ɗowan ata i njak ahan ɗaw? I nahay nə tə iɗe cekərkərre anga aday ɗo sə akar ataya tâ zlan ù doh bay, biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Anga nan kutok, kwanay ɗukwen, njihen mə lavay zek aya cekərkərre matanan re, bina, nen Wan su Ɗo nà, ni i may ahay à alay a ɗuwuraw ɗukwen, ki sənen apan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ɗo sa ga mer su way lele awan, aday winen nə wurwer a ata nà, wayaw? Winen nà, ɗowan a aday bahay su doh anahan a sə mbakan anan ɗo si mer su way ahay fok à alay anahan inde ata awan. Winen i varan atan way sa pa lele à alay aday təɗe sa pa way ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ataslay mivel i təran anà ɗowan ata awan, kak bahay su doh anahan kà mak agay aday kà tak anan ahay à nga winen apan i gan nga anà ɗo si mer su way anahan ataya lele nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nen apan ni jak ikwen tə ɗiɗem a həna, bahay su doh anahan ata i mbəsakan anan way ahay à alay inde nə fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","«Aya əna, hinahibay ite, ɗo sa ga mer su way ata kà sak a jalay à nga anahan inde: “I ga nà bahay su doh uno i may bəse bay.” ");
INSERT INTO mqbNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Winen gədek sa ga anan alay tə azar su ɗo si mer su way ahay, gədek pə way sa pa anahan ahay, sa pa, aday i sa mahay anahan tu ɗo sə vaway nga ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sənen apan lele kutok, bahay su doh ana ɗowan ata i may ahay nà, pə luvon a aday winen a i san apan bay jiga ata awan, kabay à alay a ɗukwen i san bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bahay su doh anahan ata kà sak a may ahay aday kà tak anan ahay à nga nà, winen apan i ga mer su way lelibay aya ata nà, i ga anan alay tə ɗowan ata tə mindel. I razl anan à man su ɗo sə mbaɗəmbaɗa ahay, aday ti rac slan tə iɗe sə ayam awan anga ɗəce à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«À alay a Wan su Ɗo i may ata nà, i ga minje tə dəna dalay aya kuro sa ba ɗo sə gəɓa dalay ata awan. Tə gəɓa lalam a tinen ahay, ta zla sa ba ɗowan a sə gəɓa dalay ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cəkəbay, dəna ataya nà, ɗara aya nə ɓəlɓəle aya awan, ɗara aya ite, ma san nga aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dəna ɓəlɓəle ataya cəna, tə gəɓay lalam a tinen ahay mənjəna sə gəɓay apan kwalaba sə kwalenjer maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dəna ma san nga ataya nà, tə gəɓay lalam a tinen ahay, tinen tə pəkay kwalenjer maza à kwalaba hinen ahay inde re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aya əna, ɗowan sə gəɓa dalay ata kə̀ njahak ayak bayak awan, dəna ataya fok tə dangwaz, ta njak ahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Man luvon a ga bine siwaw cəna, tə sləne abəbal awan sə ɗo ahay, ta wa: “Ɗo sə gəɓa dalay kə̀ dəzlek ahay. Slabiken, təmihen anan!” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dəna ataya fok tə pəɗek cəna, tə dazlan sə lavay anan zek tə lalam a tinen ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dəna ɓəlɓəle ataya tə dazlan sa jan anà dəna ma san nga ataya kutok, ta wa: “Amboh, viren umo kwalenjer a kwanay ataya panan mənjœk mənjœk ite, bina lalam a manay ahay tinen apan ti mbacay pumo wa.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dəna ma san nga ataya tə mbəɗahan atan apan, ta wa: “A'ay, i slak uko fok bay. Suwan, zlen à wulen su doh, aday ki sukumen ahay pə ɗo sa ga masa ahay wa.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dəna ɓəlɓəle ataya ta zla saa sukumay ahay kwalenjer à wulen su doh ahay wa kutok. À alay a tinen apan ti pəlay kwalenjer à wulen su doh wa ata awan, ɗo sə gəɓa dalay a dəzley ahay ite. Dəna ma san nga ataya tə slabak, ta zla à man sə azar uko tatə ɗo sə gəɓa dalay. Bahay su doh a tacay anan məsudoh anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","A njahay zərata cəna, dəna dalay a azar ataya ɗara aya, tə dəzley ahay ite. Ta jan ayak 'am anà bahay su doh uho wa, ta wa: “Kem, təɓan umo ayak wa ite!” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bahay su doh ata a jan atan ahay apan, a wa: “Tə ɗiɗek a nà, na san kwanay bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Natiya kutok, Yesu a wa: «Anga nan, njihen mə lavay zek aya awan, anga kə sənen luvon a bay, kwa alay aɗəka sabay fan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«À alay ata ɗukwen, i ga minje tə bahay su doh saa zla à man dəren ata awan. A ngaman anà ɗo si mer su way ahay, a mbəsakan atan anan zlile anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A varan dala sə gura səkat ɗara anà ɗo kərtek awan. Anà ɗowan hinen ɗukwen, dala sə gura səkat cew, aday anà ɗo mə slala maakan a nà, dala sə gura səkat kərtek. A varan anà kuwaya ɗukwen, kawa ana ɗowan a saa mba apan ata awan. A dazlan, a zla way anahan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","«Kwayan'a, ɗo sa njaɗ dala sə gura səkat ɗara ata a zla, a mbəɗa anan alay lele. Kə̀ njaɗak apan wan a ɗukwen dala sə gura səkat ɗara re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ɗo sa njaɗ dala sə gura səkat cew ata a zla, a mbəɗa anan alay, kawa ɗowan a mama'am ata re. Kə̀ njaɗak apan wan a ɗukwen dala sə gura səkat cew re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Əna ɗowan sə təma dala sə gura nə səkat kərtek ata, a zla, a la anan dala ana bahay anahan ata à məke inde, a ɗer anan uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«A njahay pə dəɓa wa bayak a nà, bahay a tinen ata a may agay. A cəce patan wa, ta ga anan tə dala sə gura anahan ahay nə kəkəmaw. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ɗo sa njaɗ dala sə gura səkat ɗara ata, a nay, a jan anà bahay anahan: “Kə varak uno dala sə gura səkat ɗara. Ca apan, nə njaɗak apan wan aya səkat ɗara re.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bahay anahan ata a jan nà: “Suse, iken ɗo si mer su way lele aday ɗiɗek a re. Ka gak mer su way lele awan tə way a aday abay bayak a bay ataya awan. Ni mbəsakak way ahay bayan a à alay inde re. Hayak wa ù doh. Taslumo mivel pə kərtek awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Ɗo sa njaɗ dala sə gura səkat cew ata, a nay, a jan anà bahay anahan, a wa: “Bahay uno, kə varak uno dala sə gura səkat cew. Ca apan, nə njaɗak apan wan aya səkat cew re.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bahay anahan ata a jan nà: “Suse, iken ɗo si mer su way lele aday ɗiɗek a re. Ka gak mer su way lele awan tə way a aday abay bayak a bay ataya awan. Ni mbəsakak way ahay bayan a à alay inde re. Hayak wa ù doh. Taslumo mivel pə kərtek awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Ɗo sa njaɗ dala sə gura səkat kərtek ata ɗukwen a nay, a jan anà bahay anahan, a wa: “Na san iken zle, iken ɗo jinje awan. À man aday kə caslak ayak way bay ata ɗukwen, ka zla sə cəray wa way re. À man aday kə zəvak awan bay ata ɗukwen, ka ban panan way re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nə jəjarak tə iken bayak awan. Anga nan, nə ɗərek anan dala anak à məke. Ahan way anak kutok.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Bahay anahan ata a jan, a wa: “Iken nà, ɗo lelibay awan, isew awan. Ka san apan zle, nen nà, ɗo jinje awan. À man a nə caslak awan bay ata ɗukwen, nə cəray wa way re. À man aday nə zəvak ayak awan bay ata ɗukwen, na ban panan way re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Matanan, abay təɗe ki ɗaf anan dala uno à bank, aday ata na mak agay nà, ni tan à nga anà dala uno tə wan a awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Təmihen panan dala sə gura səkat kərtek ata awan, aday viren anan anan apan anà ɗo aday dala sə gura anahan inde mbulo ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Anga kuwaya way anahan inde cəna, ti zəgahan anan apan aday â ga inde apan bayak a aɗəka. Əna ɗo aday way anahan nə mənjœk ata nà, ti ngəzar panan kwa mənjœk anahan ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aday ɗo si mer su way a isew a kəriya ata nà, liren anan ayak uho ì iɗe zənzen a inde. À man ata nà, ɗo ahay ti yam, ti rac slan.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Pə luvon a aday Wan su Ɗo kà sak a nay ahay à mazlaɓ inde tə maslay anahan ahay fok cəna, i njahay tə mazlaɓ a pa man sə njahay sə bahay anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɗo sə daliyugo ahay pu kon pu kon fok ti halay nga pa 'am anahan. Aday i dazlan sə gəzla atan kawa ɗo sə jugwar gənaw ahay sə gəzla anan təman anahan ahay pi zek wa tə awak ahay day cew ata awan: təman ahay cara, awak ahay cara. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I tavay anan təman ataya tə alay puway anahan, aday awak ahay ɗukwen, tə alay gula anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Aday bahay i jan anà ɗo sa day sə alay puway anahan ahay kutok: “Hayak ikwen ahay, kwanay ɗo ana Bəbay uno sa ɗaf pikwen alay sə mazlaɓ anahan ataya awan. Njihen à bahay anahan a inde kutok, bahay a anan mə lavay zek a nə anga kwanay kwa həna kabay, daliyugo ɗukwen mə ndakay a fan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Anga, abay may a han upo, kə viren uno ahay way sa pa, abay jom u go, kə viren uno ahay a'am, abay nen mbəlok awan, kə təmihen ahay nen, kə liven upo zek, ");
INSERT INTO mqbNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","abay zana inde upo ibay, kə viren uno ahay zana pi zek, abay nen ɗəvac awan, ki men uno ahay zek, abay nen ù doh sə dangay, ki cen ahay upo.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Ɗo a ɗiɗek ataya ti cəce panan wa: “Bahay a manay, mə canak may a han apak, aday mə varak way sa pa ata nà, siwaw? Mə canak jom a gak, aday mə varak a'am ata nà, ahaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mə canak iken mbəlok awan, aday mə təma iken, mə lavay apak zek ata nà, siwaw? Mə canak zana anak ibay, aday mə pəkak apak zana a nà, ahaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mə canak iken ɗəvac a, kabay iken ù doh sə dangay, aday ma zlak ayak sa cay ahay apak ata nà, siwaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Bahay i mbəɗahan atan apan kutok: “Nen apan ni jak ikwen tə ɗiɗem a həna: Way a kwanay sa gan anà mərak uno a kərtek ma kac ata nà, ki gen uno nà, ì nen awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Kagasl, bahay i jan anà ɗo sə alay gula anahan ataya kutok: “Kwanay ɗo a Mbərom mə tahasl a anaya, zlen ayak pə cakay uno wa. Zlen ù uko sə mbacay itəbay ata inde, uko a mə lavay zek a nə anga Fakalaw tə maslay anahan ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Abay may a han upo, kə viren uno ahay way sa pa bay, abay jom u go kə viren uno ahay a'am bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Abay nen mbəlok awan, kə təmihen ahay nen bay, kə liven upo zek bay. Abay zana inde upo ibay, kə viren uno ahay bay. Abay nen ɗəvac awan, nen ù doh sə dangay, ki zlen ayak pə cakay uno sa cay ahay upo bay.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Tə cəce panan wa: “Bahay a manay, mə canak aday may a han apak, kabay jom a gak, kabay iken mbəlok awan, kabay zana inde apak ibay, iken ɗəvac a, kabay iken ù doh sə dangay, aday ma mak anak ahay zek bay ata nà, siwaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ihe, Bahay i mbəɗahan atan apan kutok: “Nen apan ni jak ikwen tə ɗiɗem a həna: Way a kwanay sa ngam sa gan anà ɗo uno a anaya ma kac ataya kwa kərtek bay ata nà, ki gen uno bay ata nà, anà nen awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Ti zla atan à man sə ɗəce sa ndav sabay ata awan, əna ɗo ɗiɗek aya kəma, ti njaɗ sifa sa ndav bay ata ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu a ndav anan 'am a anaya fok cəna, a jan anà njavar anahan ahay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Kə sənen apan zle, a mbəsak luvon ahay cew coy aday azar uko sə Pasəka i sla. À alay ata ti ban nen, nen Wan su Ɗo, ti varan nen anà ɗo ahay aday ti darak ayak nen pə dədom mə zləlngaɗ awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","À alay ata ite, bahay sə gəɗan dungo anà way ahay anga Mbərom, tə məceɗ sə Yahuda ahay, tə halay nga àga Kayafas, bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tə jəjem 'am sa ban anan Yesu tə wurwer, aday sa vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Əna ta wa: «Ɗâ sa ban anan à azar uko inde bay, bina ɗo ahay ti sa vəze puko.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","À alay ata nà, Yesu winen à Baytiniya, àga ɗowan a inde, tə ngaman Simon ɗo mə dugwaɗ awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Uwar a inde a zlak ayak à man anahan tə dunguzlok sə amar sə wurde a dala bayak awan. A mbaɗ anan amar ata pa nga ana Yesu à alay a winen apan i pa way. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Njavar anahan ahay tə canan anà way anahan sa ga ata cəna, a ma nga sə cəɓan atan. Ta wa: «A nes anan amar a anan həna nà, pa maw? ");
INSERT INTO mqbNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ta wa, abay tə̂ sukom anan way tə amar a anan nà, i ga dala bayak awan, aday ti var anan dala awan anà ɗo mətawak aya nà, ta gak way lele biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu ɗukwen a sləne way a tinen a sa ja ata zle re. A jan atan kutok, a wa: «Kə bənen anan mbiyeɗ anà uwar a anan nə pa maw? Way anahan su go ata nə lele. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Anga ɗo mətawak aya nà, ti ga inde tə kwanay hwiya, əna nen ni ga inde tə kwanay hwiya itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A pak upo amar a anan nà, a ga upo nə amar uno sa zla anan à məke. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nen apan ni jak ikwen tə ɗiɗem a həna: À man aday ɗo ahay ti wazay anan ləbara uno mugom a anan kwa aha pə daliyugo fok nà, ti təker anan ləbara sə way ana uwar a anan sa ga həna ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Natiya kutok, ɗo kərtek à wulen su ɗo maslan anahan kuro nga cew ataya wa, sə ngaman Yudas Iskariyot ata, a zla pə cakay sə bahay sə gəɗan dungo anà way ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","A jan atan, a wa: «Kak nə varak ikwen anan Yesu nà, ki viren uno ma ì nen awan anaw?» Tə baslay dala kwayan'a, tə varan dala sə gursa kwa kuro maakan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","A ban pə winen ata wa kutok cəna, Yudas a pəlan atan cəveɗ sə varan atan anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Natiya, à luvon mama'am sə azar uko sa pa tapa sə pen mə zlambar a bay ata bine siwaw nà, njavar a Yesu ahay ta nay, tə cəce panan, ta wa: «A nak mâ sa lavay anan zek tə way sa pa sə Pasəka ata nà, ahaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu a jan atan kutok, a wa: «Zlen à wulen su doh sə Urəsalima àga mana, jen anan nà: “Miter a manay a ja nà: Alay uno i sla bəse. U no sa ga azar uko sə Pasəka tə njavar uno ahay nà, àga iken.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Njavar anahan ataya ta ga kawa ana Yesu a sa jan atan ata awan, tə lavay anan uda zek tə way sa pa sə azar uko sə Pasəka kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Suko a a ga nà, Yesu a njahay pə tuwez tu ɗo maslan anahan ahay kuro nga cew sa pa way pə kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tinen apan ti pa way a kutok, Yesu a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan a kərtek à wulen a kwanay inde, i i ga upo ɗaf.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Am ata a wusen nga anà njavar anahan ahay fok. Tə dazlan sə cəce panan fok a tinen a kərtek kərtek, ta wa: «Bahay, nen bay ba?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu a mbəɗahan atan apan, a wa: «Ɗowan a manay sa tar alay maya à tuwez inde ata, saa ga upo ɗaf nə winen. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nen Wan su Ɗo nà, ni mac, kawa ana Deftere a Mbərom sa ja upo ata awan. Əna ɗəce i naa tan à nga anà ɗo saa ga upo ɗaf ata awan. Suwan pə winen maka tə̂ wahay anan bay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, ɗowan a saa ga apan ɗaf ata, a cəce, a wa: «Miter, nen bay ba?» Yesu a mbəɗahan apan, a wa: «Iken a sa ja!» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","À alay a tinen apan ti pa way mba, Yesu a gəɓa tapa sə pen, a ngəran ayak anà Mbərom, a gəzla anan ì zek wa, aday a varan anan anà njavar anahan ahay, ta sa jan atan: «Təmihen, pen. Həna anan nà, zek uno awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pə dəɓa anahan a wa nà, a gəɓa gəsa'am, a ngəran ayak anà Mbərom, aday a varan atan anan gəsa'am ata awan, ta sa jan atan nà: «Sen wa juɓjoɓ, kwanay a fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Həna anan nə mez uno mə pəkay a anga sə pəse ines sə ɗo ahay bayak awan. Tə mez uno a anan, Mbərom a ɓan 'am tə ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nen apan ni jak ikwen tə ɗiɗem awan: I ban pə luvon sə biten a anan wa nà, ni naa sa way kawa həna a anan sabay, si azanaka pə luvon aday ɗi saa sa maza pə kərtek a à bahay a Bəbay uno inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pə dəɓa anahan a wa nà, ta ga ara sə həran nga anà Mbərom, ta zla way a tinen à ɓəzlom sə Ulivet. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","À alay a tinen apan ti zla way a tinen ata kutok nà, Yesu a jan anà njavar anahan ahay, a wa: «À luvon a sə biten a anan inde, ki i mbəsiken nen, kwanay a fok. Anga Deftere ana Mbərom a ja nà: “Ni vaɗ anan ɗo sə jugwar təman awan, aday ɗukwen təman ahay ti ta 'am.” ");
INSERT INTO mqbNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Əna, na sak a slabakay ahay à məke wa nà, ni lahak ikwen à Galile.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyer a jan kutok, a wa: «Kwa â ga nə ɗo ahay fok ti mbəsak iken dəp nà, nen ni mbəsak iken itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu a mbəɗahan apan, a wa: «Nen apan ni jak tə ɗiɗem a həna, Piyer: À luvon a sə biten a anan inde, zukwa njəkar i saa zlah nà, ka jak saray maakan ka san nen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyer a mbəɗahan apan, a wa: «Kwa â ga nə ni mac anga iken dəp nà, ni ja kula na san iken bay itəbay!» Njavar a Yesu a azar ataya fok ta ja matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Natiya kutok, tə dəzle à man a sə ngaman Gecemene ata tə njavar anahan ahay. Yesu a jan atan: «Njihen à man a anan, ni zla tiya saa gay amboh.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Winen apan i zla nà, a ngaman anà atə Piyer ta wan ana Zebede ahay cew, ta zla jiga awan. A dazlan sə jalay mərava sə ɗəce anahan ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A jan atan, a wa: «Mivel uno i ndəroɓ, hus pa sa mac anan. Njihen à man a anan. Ben ti nen lele.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A zla pa 'am mənjœk nà, a slahay ta 'am duboz, a ga amboh kawa həna anan: «Bəbay uno, kà zlak anak à nga nà, ki gəɓa puno ɗəce saa nay upo a anan ata awan. Aya əna, way kawa su no nà, â təra bay, si kawa sa nak iken.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A ma à man ana njavar anahan a maakan ataya nà, a tan atan ahay à nga nə ma njak ahan aya awan. A jan anà Piyer: «Ki mben apan sa ba ti nen kwa ler kərtek bay asəka? ");
INSERT INTO mqbNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ben lele, gen amboh, anga aday kə̂ tiven anan anà way saa njak kwanay ahay. Apasay su ɗo zənzen a nà, a gan may sə ɗəfan apan anà Mbərom, əna zlay si zek anahan a bəle awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A zla mə slala cew a ɗukwen, a ga amboh asa, a wa: «Bəbay uno, kak i njaɗ zek aday ɗəce a anan i zla puno wa bay cəna, nâ sa anan aɗəka. Way a sa nak ata â təra.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A may ahay pə cakay ana njavar anahan ataya asa, a tan atan à nga nà, tə njəkak ahan asa, ta mba apan sə təɓa iɗe kwa mənjœk bay jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A mbəsak atan, a zla saa ga amboh asa, kawa sə manan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cəna, a ma pə dəɓa à man ana njavar anahan ahay, a jan atan, a wa: «Kwanay apan ki man anan uda awan ɗaw, ɗo sa njak ahan ahay? Kagasl, alay a kà slak həna kutok, aday ti varan nen Wan su Ɗo à alay inde anà ɗo sə atahasl ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Slabiken, zluko. Ɗo sa ga upo ɗaf winen tiya, kà nak ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu kə̀ ndəvak anan 'am anahan ata fan bay, Yudas, ɗo kərtek à wulen sə njavar anahan aya inde kuro nga cew ata, a dəzley ahay pə cakay anahan. A njahan pa 'am wa anà ɗo ahay bayak a tə way sə alay a hunjəslesle: maslalam a pi zek tə sukol aya re. Sə slənay atan ahay nə bahay sə gəɗan dungo anà way ahay pi zek tə məceɗ sə Yahuda ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas, ɗowan a sa ga ɗaf pə Yesu ata, ɓa kə̀ varak atan minje sə way, a wa: «Ɗowan a ni ban anan həmbok ata nà, winen awan. Bənen anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kwayan'a, Yudas a həɗek pə cakay ana Yesu, a jan: «Iken inde zay biɗaw, Miter?» A varan alay, a ban anan pi zek həmbok. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu a jan kutok: «Car uno, ndav anan way a sə gəɓay iken à man a anan ata awan.» Ɗo ahay ta zlak ayak kutok, ta ban anan, ves. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ɗowan a kərtek à wulen su ɗo a Yesu ataya, a ndahay maslalam anahan, a car anan ɓile ana bahay nga su ɗo sə gəɗan dungo anà way anga Mbərom, aday maslalam anahan ata a gaɗ panan sləmay kərtek a poc. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Əna Yesu a jan, a wa: «Ma anan maslalam anak ù doh anahan awan, anga ɗo sa ban maslalam ahay ti lize nə tə winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aday asa, ka san sa jəka, nâ gan may nə ni cəce pə Bəbay uno wa, i sləno ahay maslay anahan ahay bayak a məcapar a kuro nga cew biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aka aday, kak nə cəcihek maməzek ata nà, way a mə vinde upo à Deftere a Mbərom inde ata i sa təra kəkəmaw? Deftere a ja nà, i təra upo kawa həna anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu a jan anà ɗo ahay kutok, a wa: «Ki nen upo tə maslalam aya aday tə sukol aya sa ban nen kawa nen ɗo sə ngəzar ɗo à cəveɗ inde ɗaw? Nen inde ù doh sə mazlaɓ a Mbərom pac pac, nen apan ni tətakan anan way anà ɗo ahay, kə bənen nen bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Əna way a anaya fok a təra cəna, aday way ana ɗo maja'am a Mbərom ahay sa ja à Deftere a Mbərom inde ataya tə̂ təra.» Kagasl kutok, njavar anahan ahay tə mbəsak anan, ta haw way a tinen fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ɗo sa ban anan Yesu ataya ta zla anan àga Kayafas, winen bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom. Miter sə Tawrita ahay pi zek tə məceɗ sə Yahuda ahay tinen mə halay nga a à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyer winen apan i pərahan ayak azar à dəɓa wa à dəɓa wa, dezl à gala ana bahay nga su ɗo sə gəɗan dungo anà way ata awan. A zla ù doh ite re, tə njahay pi zek tu ɗo si mer su way sə àga ɗowan ata ataya awan, anga sa ca pə andav sə sariya ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aday nà, bahay sə gəɗan dungo anà way ahay, pi zek tu ɗo sə lavan nga anà Yahuda ahay, fok a tinen a ta ban bitem sə mungwalay ahay aday ti vaɗ anan Yesu à məke. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Əna ta njaɗ cəveɗ a bay, kwa abay ɗo sə mungwalay ahay bayak a tə ndəɓak apan 'am ahay cara cara dəp nà, na. Kagasl, ɗo ahay cew ta nay, ");
INSERT INTO mqbNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ta wa: «Ɗowan a anan kà jak, a wa: “Ni mba apan sa mbazl anan doh sə mazlaɓ a Mbərom, ni han uda maza à luvon maakan inde.”» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bahay nga su ɗo sə gəɗan dungo anà way ahay a slabak, a jan anà Yesu, a wa: «Kə mbəɗa apan itəbay kələɗaw? Ɗo a anaya fok ta ja apak nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu a njahay way anahan faafa. Bahay nga su ɗo sə gəɗan dungo anà way ahay ata a jan kutok, a wa: «Nen apan ni cəce panak həna. Mbaɗay tə sləmay a Mbərom, bahay sə sifa. Jan umo, iken nə Almasihu, Wan a Mbərom ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu a mbəɗahan apan kutok, a wa: «Matanan! Əna nen apan ni jak ikwen həna: Pa 'am kəmaya, ki cinen anan anà Wan su Ɗo, winen mə njahay a à alay puway ana Mbərom Ba Məgala. Ki cinen anan pə matapasl ahay pa nga mburom, winen apan i may ahay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Natiya, bahay nga su ɗo sə gəɗan dungo anà way ahay ata a ngəraw anan zana anahan pi zek wa, a wa: «Həna nà, ɗi gan may anà side hinen re ɗaw? Kə̀ jənak anan pa 'am a Mbərom. Kə slənen 'am anahan a coy. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ki jen həna nə kəkəmaw?» Ɗo ahay tə mbəɗahan apan, ta wa: «Winen tə mungok a coy. Kà slak sa vaɗ anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tə təfen məne pə iɗe, tə duzlay anan tə alay, aday ɗo azar aya tə dəcan, ");
INSERT INTO mqbNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta wa: «Iken nə Almasihu, ɗo maja'am a Mbərom nà, jan umo kutok: Sə dəcak nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Natiya, Piyer winen mə njahay a à gala hwiya. Dəna sa ga mer su way a inde à man ata a nay, a jan: «Iken ɗukwen abay kwanay jiya tatə Yesu sə Galile ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Əna Piyer a məman anan, pa 'am sə ɗo ahay fok, a wa: «Nen na san 'am anak a sa jay ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piyer a slabak, a zla way anahan à məgədengəden uho. Dəna hinen asa a canan re, a jan anà ɗo ahay à man ata awan: «Həna a anan ɗukwen, winen tə Yesu sə Nazaratu ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer a məman anan asa, a wa: «Ni mbaɗay, tə ɗiɗek a, na san anan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A njahay mənjœk asa, ɗo sa man ataya ta nay pə cakay a Piyer. Ta jan, ta wa: «Tə ɗiɗem awan, iken ɗo a tinen wanahan, anga miresl anak a a ɗakay anan iken nə Galile ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kagasl Piyer a dazlan sə mbaɗay coy: «Kak na san ɗowan ata zle nà, Mbərom a tə alay anahan awan â tahasl nen! Na san ɗowan ata bay fok!» Kwayan'a, njəkar a zlah. ");
INSERT INTO mqbNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Am a Yesu a sa jan kurre ata à man à nga inde, a wa: «Njəkar i saa zlah nà, ka jak saray maakan ka san nen bay.» A nay uho, a yam cəɗœk cəɗœk tə iɗe sə ayam. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iɗe a cəɗe siwa a cəna, bahay sə gəɗan dungo anà way ahay pi zek tə məceɗ sə Yahuda ahay ta ɓan 'am sa vaɗ anan Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Coy tə jaway anan, ta zla anan àga Pilatu, guverner sə Yahudiya, winen Ruma ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Natiya, Yudas a ca apan nə ta gan anà Yesu nà, sariya sa vaɗ anan à məke cəna, a jalay anan cəɗœk cəɗœk, a zla à man ana bahay sə gəɗan dungo anà way ahay anga Mbərom tə məceɗ sə Yahuda ahay, a man atan anan dala sə gursa a tinen sə varan kwa kuro maakan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A jan atan, a wa: «Na gak ines, anga nə njəkak anan uda anà ɗo mənjəna ines.» Əna tinen ite ta jan apan, ta wa: «Ma a manay apan anaw! Wita nà, baway anak kutok!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Coy Yudas a dazlan, a guce anan dala ata à gala su doh sə mazlaɓ a Mbərom. A zla, a ngərew zek anahan tə liɓer. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bahay sə gəɗan dungo anà way ahay anga Mbərom ataya ta ra anan dala ata awan, ta wa: «Tawrita kə̀ varak uko cəveɗ sa tar anan dala a anan à kukwar sa ɗaf dala su doh sə mazlaɓ a Mbərom bay. Anga tə dala ata tə sukom nə mez su ɗo.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ta ɓan apan à wulen a tinen a inde kutok, tə̂ sukom anan guvo ana ɗo sa han səngəle a inde tə dala ata awan, aday ti taa la uda mədurlon ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Anga nan kutok, hus həna ɗukwen, tə ngaman anà guvo ata nà, Guvo sə Mez. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Natiya 'am ana ɗo maja'am a Mbərom Yeremiya a təra, anga kà jak, a wa: «Ta ra dala sə gursa kwa kuro maakan, dala mbala ana Isəra'ila ahay sa ɓan apan sə sukom anan tə winen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tə sukom anan guvo ana ɗo sa han səngəle a inde, kawa ana Mbərom Fetek sə ɗuko anan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu, winen mə tavay a pa 'am ana guverner Pilatu. Pilatu ite, a cəce panan wa, a wa: «Iken nà, bahay sə Yahuda ahay ɗaw?» Yesu a mbəɗahan apan, a wa: «Ka jak anan asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bahay sə gəɗan dungo anà way ahay anga Mbərom pi zek tə məceɗ sə Yahuda ahay ta ndaɓ apan 'am, əna kə̀ mbəɗahak apan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kagasl, Pilatu a cəce panan asa, a wa: «Kə̀ slənek 'am ana ɗo sa ra apak 'am a anaya itəbay kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu kə̀ mbəɗahak apan kwa mənjœk bay fok, aday a gan masuwayan anà guverner Pilatu. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pə azar uko sə Pasəka fok cəna, guverner a taa mbəsakan atan ahay ɗo kərtek à dangay wa, ɗowan a kawa ana ɗo ahay saa cəce ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","À alay ata ite, ɗowan a inde à dangay a re, ɗo ahay fok ta san anan lele. Tə ngaman Yesu Barabas. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ɗo ahay tə halay nga, aday Pilatu a cəce patan wa kutok, a wa: «A nak ikwen nə̂ mbəsakak ikwen ahay à dangay wa həna nà, wayaw? Yesu Barabas ɗaw, kabay Yesu sə ngaman Almasihu ata ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatu a san zle, ta ban anan Yesu nà, anga sərak cərkəke. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","À alay a Pilatu winen apan i ga sariya ù doh ata nà, uwar anahan a slənay apan ɗo, â jan nà: «Kâ sa gan awan anà ɗowan a mənjəna ines a anan bay, bina avaɗ a nə, cœn sə zuɓay kə̀ bənak uno mbiyeɗ anga winen bayak awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aya əna, bahay sə gəɗan dungo anà way ahay, pi zek tə məceɗ sə Yahuda ahay, ta ran 'am anà ɗo ahay aday tə̂ cəce Pilatu â mbəsakan atan anan Barabas aday â vaɗ anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Guverner a cəce patan wa asa, a wa: «A nak ikwen nə̂ mbəsakak ikwen ahay à wulen su ɗo a cew a anaya wa nə wayaw?» Tə mbəɗahan apan, ta wa: «Mbəsakan umo ahay nə Barabas.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A cəce patan wa: «Aday nâ ga anan tə Yesu sə ngaman Almasihu ata nà, kəkəmaw?» Tə mbəɗahan apan pə kərtek a tinen a fok, ta wa: «Darak anan ayak pə dədom!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatu a cəce asa: «A ga mer sa ma lelibay a anaw?» Əna tə zəga anan sa zlah tə məgalak a, ta wa: «Darak anan ayak pə dədom!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatu a ca apan nə i mba apan sa ga awan kwa mənjœk ibay, aday abəbal awan winen apan i zəga hwiya. Natiya kutok, a banay alay anahan pa 'am sə ɗo ahay ta sa ja nà: «Ines sa vaɗ anan ɗowan a anan inde upo ibay. Wita nà, kwanay sa san!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɗo ahay fok tə mbəɗahan apan, ta wa: «Ines sa vaɗ ɗowan a anan â njahay pa nga a manay ahay, aday pa nga a gwaslay a manay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatu a mbəsakan atan anan Barabas. A jan anà suje ahay tə̂ ndaɓay anan Yesu. Aday a varan atan anan, tə̂ daray anan pə dədom. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Suje ana Pilatu ahay ta zla anan tə Yesu ù doh sə guverner, aday tə halan nga anà suje ahay fok pə cakay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tə culok panan zana, tə ɗəfan zana ɗəzɗaz a pi zek, kawa sə bahay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tə hanan jugo sə adak, tə ɗəfan à nga inde, tə varan sukol à alay puway anahan. Kagasl tə dukwen gərmec ù vo, ta ma nga sə mbasay apan, ta wa: «Bahay sə Yahuda ahay â ga inde sə coy!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tə təfe apan məne, tə ngəzar panan sukol sə manan aday tə dəcan anan pa nga saray bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ta ndav anan sə mbasay apan nà, tə culok panan zana ata, ta man anan zana anahan pi zek kutok. Ta zla anan saa darak anan ayak pə dədom mə zləlngaɗ awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Natiya awan, tinen apan ti zla anan Yesu ata nà, suje ahay tə zlangay uda tə ɗowan a inde tə ngaman Simon, winen Siren ahay. Suje ahay ta gan bəlaray sə tavak dədom ata pə Yesu wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tə dəzle à man a inde tə ngaman Golgota, kawa sa ja nà, Kəlakasl-sa-Nga. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","À man ata nà, tə varan way mə kwasay a mə japay a tə ndəliwen a anà Yesu aday â sa. Əna Yesu a tukom anan cəna, a ngam sa sa bay. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Coy tə darak anan ayak pə dədom mə zləlngaɗ awan, aday tə gəzla anan zana a Yesu ahay à wulen a tinen ahay inde, ta sa ga apan caca. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tə njahay à man ata sa ba anan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tə vinde anan way a tinen a sa ban anan apan ata awan, tə lawak anan ayak pə dədom pa nga anahan. Tə vinde anan 'am ata nà, natiya awan: «Ɗowan a anan nə Yesu, bahay sə Yahuda ahay!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tə darak ayak ɗo sə akar aya inde cew re, ɗo kərtek a tə alay puway, ɗo hinen tə alay gula, Yesu à mamasl a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɗo sa zla ta man ataya awan fok ta ɓal nga kwata kwata, tə gənahan, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Iken ka wa ki mbazl anan doh sə mazlaɓ a Mbərom aday ki han anan maza awan à luvon maakan inde ba? Tam anan nga anak kwa! Kak iken Wan a Mbərom cukutok nà, dazay ahay pə dədom a wa biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bahay sə gəɗan dungo anà way ahay anga Mbərom, tə miter sə Tawrita ahay, tə məceɗ sə Yahuda ahay, ta ma nga sa ran mindel a re. Ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Kə̀ təmak anan ɗo azar aya awan, əna a mba apan sa tam anan nga anahan a bay. Winen bahay sə Isəra'ila acəkan ɗaw? Â dazay həna pə dədom wa aday ɗi sa ɗaf apan nga kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A ɗaf nga pə Mbərom, a wa winen wan anahan! Lele, cuko apan kutok, kak a nan à Mbərom sa tam anan həna nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɗo sə akar ataya mə daray aya pə kərtek a tatə Yesu ataya ta ma nga sə gənahan matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Natiya, a ban pə man ipec wa nà, luvon a ga pə daliyugo fok takəɗimbom, hus à njamde maakan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A ga njamde maakan nà, Yesu a zlah tə məgalak a, a wa: «Eli, Eli, lama sabaktani?» Kawa sa ja nà: «Mbərom uno, Mbərom uno, kə mbəsak nen angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɗo a mə tavay aya à man ata azar a tə sləne bine maw cəna, ta wa: «Winen apan i ngaman anà Eliya.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɗowan a tinen a kərtek a haw, a gəɓa awan a kawa baf, a tar anan à way mə kwasay a inde, aday sərekeke re asa. A taran anan ayak tə gusuko zəbor awan aday Yesu â susœɓ. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Əna ɗo a azar ataya ta wa: «Kak Eliya i nay saa tam anan nà, ɗi ca apan aday. Buko!» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu a zlah tə məgalak awan asa, a mac way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","À alay anahan a sa mac ata ite, zana sə gəzla anan man sə njahay a Mbərom pi zek wa tə ɗo ahay ù doh sə mazlaɓ a Mbərom ata, a ngəraw ì zek wa əndem, a bənay ahay kwa à mburom wa hus à məndak. Aday ɗukwen daliyugo a ɓal, pəkəraɗ ahay ta ta ì zek wa. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jəvay ahay tə təɓa re, aday ɗo a Mbərom ma mac ataya tə slabakay à məke wa bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɗo ataya tə jənay ahay à jəvay wa, aday pə dəɓa ana Yesu sə slabakay ahay à məke wa ata nà, ta zlak à Urəsalima, wulen su doh cəncan awan, aday ɗo ahay bayak a tə canak atan re. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Suje sə Ruma ahay tə bahay a tinen, tinen apan ti ba pə Yesu. Tə canan anà daliyugo a sa ɓal pi zek tə way a sə təra ataya nà, tə jəjar pi zek anga way a sə təra ata awan. Ta ja, ta wa: «Tə ɗiɗek awan, winen Wan a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Uwar ahay bayak a inde à man ata awan, tə tavay zaɗ, tinen apan ti cak ayak apan. Tinen aday nà, tə pərahan ahay azar anà Yesu kwa à Galile wa, anga ti gan mer su way. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","À wulen sə uwar ataya nà, ɗi tan à nga anà Mariyama dəna sə Magədala ahay, tə Mariyama may ana Yakuba tə Yusufu, aday may ana wan a Zebede aya inde à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Suko a a ga cəna, ɗowan a inde zlile awan, winen Arimatiya ahay, a nay. Ɗowan ata nà, tə ngaman Yusufu, winen ɗukwen njavar ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A zla à man ana Pilatu, a cəce panan məsinde ana Yesu. Pilatu ɗukwen kə̀ təmahak anan anan, a varan cəveɗ sa la anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu a zla, a gəɓa anan məsinde, a nga anan apan rəkot a inde lele awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A ɗəfak anan ayak à jəvay anahan a inde ma la a à jama inde wiya awan. A bətukwal apan bələlen məduwen a, a tacay anan 'am sə jəvay kutok, a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyama, dəna sə Magədala ahay, tə Mariyama hinen ata, tinen mə njahay aya pa 'am jəvay, ti ca apan. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sidew a cəna, luvon sa man uda awan, bahay sə gəɗan dungo anà way ahay anga Mbərom pi zek tə Farisa ahay ta zla àga Pilatu. ");
INSERT INTO mqbNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ta jan anà Pilatu kutok, ta wa: «Bahay a manay, 'am inde kà mak umo ahay à nga inde. Bina, à alay a ɗo sə mungwalay a anan kə̀ məcak fan bay ata nà, a wa: “Pə dəɓa sə amac uno wa luvon maakan nà, ni slabakay à məke wa.” ");
INSERT INTO mqbNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Suwan həna nà, jan anà suje ahay tâ ba anan jəvay awan luvon a maakan ataya cite. Bina njavar anahan ahay tâ sa nay sə kəra anan məsinde anahan a bay. Ata ti jan anà ɗo ahay: “Yesu kə̀ slabakak ahay à məke wa.” Aday mungwalay a həna anan ata nà, i zalay winen a mama'am ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu a jan ata, a wa: «Suje ahay inde həna. Zlen, kâ si ben anan jəvay ata kawa ana kwanay sa mba apan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ta zla, tə tapay anan 'am sə jəvay ata tə mətətok, ta pak suje ahay à man ata sa ba anan jəvay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pə dəɓa sə luvon sa man uda wa, kawa sa ja nà, pa pac sə zaka, pərek, Mariyama dəna sə Magədala tə Mariyama hinen ata, ta zla sa cak ayak pə jəvay. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Natiya ca, daliyugo a ɓal kəzlek kəzlek, anga maslay a Mbərom a nay à mburom wa, a bətukwal anan bələlen ana tinen sə tacay a 'am sə jəvay ata, a njahay apan ton. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Maslay a Mbərom ata a dav nə kawa awuteɗ a Mbərom sa dac ata awan. Zana anahan pi zek ɗukwen a dav nə kawa lanja. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ɗo sa ba pə jəvay ataya tə canan cəna, tə jəjar pi zek bayak awan, tə təra kawa ɗo ma mac aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maslay a Mbərom ata a jan anà uwar ataya: «Kwanay nà, kə̂ jəjiren bay, bina na san zle, kwanay apan ki pəlen Yesu, ɗowan a tə darak anan ayak pə dədom mə zləlngaɗ ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Winen inde à man a anan sabay! Kə̀ slabakak ahay à məke wa kawa ananahan a sa ja ata awan. Əna, hayak ikwen ahay! Cen pa man a tinen sə nahak anan ayak uda ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aday zlen bəse, jen anan anà njavar anahan ahay nà: “Yesu kə̀ slabakak ahay à məke wa. I lahak ikwen à Galile. Ki i cinen anan nà, à man ata awan.” Na jak ikwen anan coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kwayan'a, uwar ataya ta haw ahahaw pa 'am jəvay wa, tinen ma rah a tə zlawan aday tə ataslay mivel a re. Tinen apan ti zlan anan ayak tə ləbara ata anà njavar a Yesu ahay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kwayan'a Yesu a nay ahay, tə zlangay uda tə uwar ataya awan. Yesu a jan atan, a wa: «Zay ɗaw?» Uwar ataya tə həɗəken ayak pə cakay. Ta ban anan à saray a wa, tə həran nga. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu a jan atan, a wa: «Kə̂ jəjiren bay. Zlen, jen anan anà mərak uno ahay nə tâ zla pə daliyugo sə Galile. Ti i cuno nà, à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Uwar ataya tinen apan ti zla way a tinen kutok, suje sa ba pə jəvay ataya azar aya ta zla à Urəsalima, tə təkəren ləbara sə way a sə təra ataya fok anà bahay sə gəɗan dungo anà way ahay anga Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tinen ite tə halay nga pə kərtek a tə məceɗ sə Yahuda ahay. Ta ɓan à wulen a tinen inde, tə̂ varan dala bayak a anà suje ahay, ");
INSERT INTO mqbNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tâ jan atan nà: «Jen nà: “Mə njəkak ahan, aday njavar anahan ahay ta nak, tə kərak anan məsinde sə luvon.” ");
INSERT INTO mqbNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Guverner kà sak a sləne 'am a anan ite nà, manay a mi san sə bənan mbac, mi təmay ahay kwanay à ɗəce ahay wa fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Suje ataya tə təma dala ata, aday ta ga kawa ana tinen a sa jan atan ata awan. Mungwalay ata kà tak 'am à wulen sə Yahuda ahay bayak a hus ahay biten. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Natiya kutok, njavar a Yesu ahay kuro nga kərtek ataya ta zla pə daliyugo sə Galile, ta zla à ɓəzlom a ɓa Yesu a kà jak atan anan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tə canan cəna, tə dukwen gərmec ù vo, əna ɗo a azar aya ta ma nga sa ja nà: «Hinahibay nə winen bay dəge.» ");
INSERT INTO mqbNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu a həɗəken atan ayak pə cakay, a ja: «Mbərom kə̀ varak uno anan məgala pə way sə mburom ahay fok tə məgala pə way sə daliyugo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Anga nan, zlen pə cakay su ɗo su kon ahay fok, təren atan njavar uno aya awan. Gen atan baptisma tə sləmay ana Bəbay Mbərom, tə sləmay ana Wan anahan, aday tə sləmay ana Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tətiken atan anan aday ti ɗəfan apan anà way uno sa jak ikwen ataya fok. Sənen anan, ni ga inde tə kwanay pə luvon pə luvon hus pa sa ndav anan daliyugo.»");
INSERT INTO mqbNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ləbara mugom a, pə Yesu Almasihu, Wan a Mbərom, a dazlan nà, natiya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A təra kawa ana Ezaya, ɗo maja'am a Mbərom, sə vinde, a wa: «Mbərom a jan ahay anà ɗo si mer su way anahan nà: “Həna ni slan ɗo maslan uno, i lahak pa 'am saa ndakak anan cəveɗ lele. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ɗowan a inde, winen apan i zlah à saf inde à kiɓe, a wa: Ten anan cəveɗ anga Bahay winen apan i nay. Ten anan cəveɗ ata mə tavay nga a fəhhe lele.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Matanan kutok, Yuhana ɗo sa ga baptisma, a zla à man sa saf inde. Winen apan i wazan à ɗo ahay, a wa: «Mbəsiken ines a kwanay ahay, təmihen sa ga baptisma, aday Mbərom i pəsek ikwen anan ines a kwanay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɗo sə Urəsalima ahay pi zek tu ɗo sə Yahudiya azar aya fok, ta nay pə cakay a Yuhana. Tə dazlan sə ɗakay anan ines a tinen ahay. Aday Yuhana a gan atan baptisma à zlinder sə Urdon inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuhana a aday nà, a ɗaf pi zek nə zana ma han a tə sibœk sə zlugweme awan, a ɓan zərkutov ɗukwen tə maslərapa sa zlay. Way sa pa anahan ite nà, hayam ahay pi zek tə umam sə kiɓe aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","À wazo anahan inde nà, a wa: «Ɗowan inde, i nay à dəɓa uno wa, a zalay nen tə mazlaɓ lele. Anga nan, nen na slak sə kuɗœk, aday ni pəsakan anan liɓer sə təkarak anahan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nen nà, na gak ikwen baptisma nə tə a'am, winen kəma, i i gak ikwen baptisma nə tə Apasay Cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","À alay ata kutok, Yesu a slabakay ahay, kwa à wulen su doh sə Galile sə ngaman Nazaratu ata wa, a nay ahay pə cakay a Yuhana à zlinder sə Urdon, aday Yuhana a gan baptisma. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu winen apan i jənay à a'am wa cəna, a canan à bagəbaga mburom a təɓa pangaya, aday Apasay a Mbərom winen apan i dazay ahay apan kawa badəbada. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aday 'am a ndəray ahay kwa à mburom wa, a wa: «Iken wan uno, ləliwe uno awan. Nə taslay mivel bayak a nə tə iken.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kwayan'a, Apasay a Mbərom a zla anan Yesu à man sa saf inde à kiɓe. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesu, winen à man ata nə luvon kwa kuro fuɗo, Fakalaw winen apan i njak anan. Atə Yesu mə njahay a, pi zek tə way sə kiɓe ahay, aday maslay a Mbərom ahay tinen apan ti gan mer su way. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","À alay ata asanaw nà, bahay Hiridus a ban anan Yuhana à dangay. Pə dəɓa anahan a wa nà, Yesu a ma pə daliyugo sə Galile. A wazay anan ləbara mugom a, mbala ana Mbərom sə slənay, ");
INSERT INTO mqbNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a wa: «Alay a kà slak həna, bahay a Mbərom winen defefe kutok. Mbiken ines a kwanay ahay, aday ɗəfen nga pə ləbara mugom awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Natiya, Yesu a zla ta man sə bəlay sə Galile nà, a canan anà ɗo sa ban kəlef aya inde cew, atə Simon tə mərak anahan Andəre, tinen apan ti ban kəlef tə zuvo a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu a jan atan, a wa: «Hayak ikwen ahay. Pərihen uno azar, aday ki bənen nə kəlef sabay. Ki i njiɗen uno nà, ɗo sə pəruho azar ahay aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kwayan'a tə mbəsak zuvo a tinen ahay, aday tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A həɗek pa 'am mənjœk, a tan à nga anà ɗowan aya cew asa, atə Yakuba tə mərak anahan Yuhana, wan ana Zebede ahay. Tinen apan ti ndakay zuvo a tinen ahay à kwalalan inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A ngaman atan ayak ite, kwayan'a tə mbəsak anan bəbay a tinen Zebede pi zek tu ɗo si mer su way anahan ahay à kwalalan inde, tə pərahan azar anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Atə Yesu tə njavar anahan a, sə ngaman ataya, ta zla way a tinen, tə dəzle à wulen su doh sə Kafarnahum. Pə luvon sa man uda awan, Yesu a zla ù doh sə wazay, a dazlan sə ɗakan atan anan way. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wazo anahan a a gan atan masuwayan, anga winen a ɗakay way nə kawa ɗo sə mazlaɓ bina, kawa miter sə Tawrita ahay itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","À alay ata ite, ɗowan inde à man ata awan, winen tə setene à nga inde. A zlah pi zek, ");
INSERT INTO mqbNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","a wa: «Iken Yesu, ɗo sə Nazaratu, ma a nak pə manay anaw? Ka nak sə lize manay ca ɗaw? Na san iken zle lele, iken nə ɗo maslan a Mbərom Cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Cəna Yesu a gafan 'am tə məgalak awan, a jan nà: «Kə̂ bəbal awan bay, hayak à ɗowan ata wa aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kwayan'a, setene ata a ɓal anan ɗowan ata kəzlek kəzlek, a zlah pi zek sə məgala, aday a nay à ɗowan ata wa bok. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A gan masuwayan anà ɗo ahay fok. Aday tə cəce pi zek ahay wa, ta wa: «Həna anan nə maw? Mərike wiya a aday tə mazlaɓ a biɗaw? Winen apan i jan 'am anà setene ahay, aday tə ɗəfan apan acəkan!» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cəna, ləbara anahan a ata a ta 'am təɗay pə daliyugo sə Galile ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Natiya, atə Yesu ta nay tatə Yakuba tə Yuhana, ù doh sə wazay wa cəna, ta zla way a tinen àga atə Andəre tə Simon. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jəje ana Simon inde, winen mə nahay a ù doh, anga nga a ɓərzlan. Yesu a dəzlek ayak cəna, tə təkəren ləbara awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu a həɗek pə cakay anahan, a bənan alay, a slabak anan. Nga sə ɓərazl a ndalay panan. Uwar ata a slabak, a dan atan way sa pa. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pə dəɓa ana pac sə slahay ù doh wa nà, ɗo maza aya tə gəɓay ɗo sə ɗəvac a tinen ahay, pi zek tu ɗo tə setene aya à nga inde ataya fok. Ta nay atan pə cakay ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɗo sa man ataya fok tə halay nga pə bərkwitek su doh ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu a mbar anan ɗo sə ɗəvac ahay cara cara, a razl anan setene ahay à ɗo ahay wa. Aday kə̀ varak atan cəveɗ anà setene ahay sa ja 'am bay, anga ta san anan zle lele. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sidew a nà, Yesu a wule pərek, a zla à kiɓe à saf inde saa ga amboh à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Atə Simon tu ɗo aday tinen àga winen ataya, ta zla saa pəlay anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ta njaɗ anan cəna, ta jan, ta wa: «Ɗo ahay fok, tinen apan ti pəlay iken.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A mbəɗahan atan apan, a wa: «Zluko aɗəka nə à wulen su doh sə kiɓe ahay, aday ni saa wazan à ɗo ahay à man ataya re. Anga na nay nà, saa ga mer su way ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Matanan acəkan, a bar pə daliyugo sə Galile fok. A wazay ù doh sə wazay ahay, a razl anan setene ahay à ɗo ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɗowan a inde, winen mə dugwaɗ awan, a nay pə cakay ana Yesu. A dukwen gərmec ù vo, a jan tə zəhha awan: «Kà zlak anak à nga nà, ki mba apan sa mbar nen aday zugol uno â ndav ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","'Am anahan ata, a gan ì zek wa anà Yesu. A ndəɗoy alay, a laman, ta sa ja: «U no. Mbar! Zugol anak kə̀ ndəvak.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cəna, mbəlak məduwen ata a ndalay pə ɗowan ata wa, a mbar kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aya əna Yesu a gafan 'am pi zek wa lele, aday a razl anan, ta sa jan nà: ");
INSERT INTO mqbNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Zla wanak, aday kâ sa təkəren ləbara a anan anà ɗowan bay. Əna zla saa kan zek anà ɗo sə gəɗan dungo anà way anga Mbərom, â zəzor iken. Aday varan way anà Mbərom, kawa a Tawrita ana Musa sa ja, sa vaɗ panak awiyaway. Natiya ɗo ahay tâ san apan, zugol anak kə̀ ndəvak.» ");
INSERT INTO mqbNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Əna, ɗowan ata a zla way anahan cəna, a gar anan ɗo ahay tə ləbara kawa sə təra apan. Anga nan, Yesu a mba apan sa zla à wulen su doh ahay, pə iɗe su ɗo ahay, sabay. A njahay wanahan nə, uho à kiɓe. Cəkəbay, ɗo ahay ta zlak ayak pə cakay anahan ta day ahay wa fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pə dəɓa sə nahay mənjœk wa cəna, Yesu a may ahay à Kafarnahum. Ɗo ahay fok tə sləne asa winen inde agay à wulen su doh. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tə halay nga bayak awan, aday man kə̀ mbakak kwa mənjœk bay, uho kawa ù doh re. Aday Yesu winen apan i ɗakan atan anan 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ɗo ahay fuɗo tə gəɓak ayak ɗowan a tinen inde tə lala, winen mə təra à məndak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tə njaɗak man sə dəzle anan ɗowan ata pə cakay ana Yesu bay, anga ɗo kə̀ zalak ù doh awan, roɗ ahay à məsudoh inde. Anga nan kutok, ta ján pa nga su doh, tə təɓa anan nga su doh à man ana Yesu winen mə tavay a uda ata awan. Tə taran anan ayak ɗowan pə lala ata tə liɓer. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu a canan anà aɗaf nga a tinen ata cəna, a jan anà ɗowan a mə təra à məndak ata awan, a wa: «Dəna uno, nə pəsek anan ines anak ahay coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kutok nà, miter sə Tawrita ahay mə njahay aya inde à man ata awan. Tə jalay à nga a tinen inde, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ɗowan a anan a ja 'am ata nà, angama kəlanaw? A jənan pa 'am anà Mbərom. Waya sa mba apan sə pəse ines su ɗo anaw, kak si Mbərom a aday bina!» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu a san anan ajalay nga a tinen a kwayan'a, a jan atan: «Kə jilen à mivel a kwanay inde matana ata nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ma da 'am a nə maw? Sa ja: “Nə pəsek anan ines anak ahay”, ata ɗaw, kabay, sa ja: “Slabak, gəɓa lala anak, zla”, ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Əna u no kə̂ sənen apan lele, nen Wan su Ɗo nà, məgala uno inde sə pəsen anan ines à ɗo ahay pə daliyugo.» Matanan, a jan anà ɗowan mə təra à məndak ata awan: ");
INSERT INTO mqbNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nen apan ni jak: Slabak, gəɓa lala anak, zla agay!» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Cəna, a slabak, a gəɓa lala anahan pə iɗe sə ɗo ahay fok, a zla wanahan. A gan atan masuwayan. Anga nan, tə həran nga à Mbərom, ta wa: «Kula ɗə canak anan anà way mə təra kawa həna anan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Asa, Yesu a zla ta man sə bəlay sə Galile. Ɗo ahay fok ta zla pə cakay anahan, aday a ɗakan atan anan way. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Winen apan i zla ata nà, a canan ayak anà ɗowan inde tə ngaman Lewi, wan ana Alfa, winen mə njahay a ù doh sə cakal jangal. Yesu a jan, a wa: «Pəruho azar!» Lewi a slabak ca, a pərahan azar acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pə dəɓa anahan a wa, Yesu a njahay tə njavar anahan ahay sa pa way àga Lewi. Ɗo sə cakal jangal ahay pi zek tu ɗo sə atahasl ahay tə njahay pə cakay ana Yesu sa pa way à tuwez kərtek a wa, tinen bayak a sə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Miter sə Tawrita à wulen sə Farisa ahay wa tə canan winen apan i pa way pə kərtek a tu ɗo sə cakal jangal ahay, aday tu ɗo sə atahasl ahay nà, tə cəce pə njavar anahan ahay wa, ta wa: «A pa way pə kərtek a tu ɗo sə cakal jangal ahay, aday tu ɗo sə atahasl ahay nə, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu a sləne anan lele nà, a jan atan, a wa: «Ɗo ɗəvac a bay cəna, a gan may anà ɗo sə disise bay, si ɗo sə ɗəvac ahay. Nen na nay ahay sa naa ngaman anà ɗo sa ga way lele ataya bay. Əna na nay ahay nà, sə ngaman anà ɗo sə atahasl ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Natiya, njavar a Yuhana ahay pi zek tə Farisa ahay, tinen apan ta ta ga sumaya. Ɗo ahay ta jan anà Yesu: «Njavar a Yuhana ahay ta sə Farisa ahay ta ga sumaya, aday mbala anak ahay nə ta ga itəbay nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu a mbəɗahan atan apan, a wa: «A ga pikwen nà, ɗo mə ngamay aya à man sə gəɓa dalay nà, ti mba apan sa ga sumaya ite ɗaw? Matanan bay! À alay a tinen pi zek tatə ɗo sə gəɓa dalay ata nà, ti ga sumaya kula bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Əna pa pac a ɗo sə gəɓa dalay ata, tə bənak anan à wulen a tinen wa nà, ata ti ga sumaya kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Matana re, waya sə tapay zana wiya a pə zana anahan məduwer a anaw? Ibay. Anga à man sə banay anan nà, məgabal sə zana wiya ata i zəga anan apan məke ana zana məduwer ata awan, i ngəraw. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Aday ɗukwen, ɗowan sa mbaɗ mahay anahan mə kwasay a bay, à mbulo sa zlay məduwer a nà, ibay. Anga mahay mə kwasay a bay ata kà sak a kwasay uda nà, i ngəraw anan mbulo məduwer ata awan. Ata mahay i mbaɗ, aday mbulo ɗukwen kə̀ nəsek re. Sumor a nà, sa mbaɗ mahay mə kwasay a bay à mbulo wiya inde cite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa pac a inde nà, luvon sa man uda awan, atə Yesu tə njavar anahan ahay ta zla tə guvo sa ndaw. Tinen apan ti zla ata nà, njavar anahan ahay ta kaɗ ndaw sa pa. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisa ahay tə canan cəna, tə cəce pə Yesu wa kutok, ta wa: «Ca apan, ta ga way aday təɗe abay sa ga pə luvon sa man uda awan bay ata nə angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu a mbəɗahan atan apan, a wa: «Kula kwanay kə jingen way ana Dawuda sa ga tu ɗo anahan ahay, à alay a may a han apan ata itəbay ɗaw? A ga nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","À alay a Abiyatar winen bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom ata nà, Dawuda a zla à jawjawa sə mazlaɓ a Mbərom, a ray pen ma ga nga anga Mbərom. Təɗe abay saa pa ɗaf ata nà, tinen ɗo sə gəɗan dungo anà way ahay taayak ba. Əna Dawuda kà pak tu ɗo anahan ahay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu a jan atan kutok: «Mbərom a ɗaf luvon sa man uda awan nà, anga ɗo, bina a ɗaf ɗo anga luvon sa man uda awan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kətanan, nen Wan su Ɗo nà, nə lavan nga anà luvon sa man uda awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pə dəɓa anahan a wa nà, Yesu a zla ù doh sə wazay maza asa. Ɗowan inde à man ata ma mac alay awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ɗo maniɗe a Yesu aya inde nà, tinen apan ti ɗəfan iɗe. Kak kə̀ mbərak anan ɗowan ata pə luvon sa man uda awan nà, ata aday ti man anan mungok. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu a jan anà ɗowan ma mac alay ata awan: «Slabak, tavay pa 'am sə ɗo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cəna, a cəce pə ɗo ahay wa, a wa: «Pə luvon sa man uda nà, cəveɗ inde sa ga mer su way lele awan, kabay cəveɗ inde sa ga mer su way lelibay awan, ɗaw? Təɗe sa tam anan sifa su ɗo ɗaw, bəzi lele nə sə lizen anan sifa ɗaw?» Əna ta ngam sə mbəɗahan apan bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu a ca patan nerre tə mivel awan, aday asəder a tinen ata ɗukwen kə̀ cəɓak anan ite. A jan à ɗowan ma mac alay a ata kutok: «Ndəɗoy anan alay anak!» A ndəɗoy anan acəkan, alay anahan a pəsak ike. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisa ahay tə canan cəna, ta nay ahay uho, aday tə halay nga pə kərtek a tu ɗo ana Hiridus ahay, aday tə pəlay cəveɗ sə lize anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu a slabak à wulen a tinen wa, a zla way anahan pə bəlay sə Galile tə njavar anahan ahay. Ɗo ahay bayak a tə pərahak anan azar. Ta nay ahay kwa à Galile wa, kwa à Urəsalima wa, tu ɗo sə Yahudiya ahay fok, aday à Idumiya wa, pi zek tu ɗo ahay sa nay ahay kwa à dəɓa sə zlinder sə Urdon wa, aday tu kon sə cakay sə Tirus tə Sidon ahay wa fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Anga nan kutok, Yesu a jan anà njavar anahan ahay tə̂ pəlan kwalalan cəɗew awan, aday i njahay uda awan, bina ɗo ahay tinen apan ti ngəɗec anan kə̀ zalak. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kə̀ mbərak ɗo sə ɗəvac ahay bayak awan. Anga nan, ɗo sə ɗəvac azar aya cara cara tə zəgahak ayak apan, aday tâ njaɗ sə laman à Yesu ite. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ɗo sə setene ahay ite, tə canan à Yesu a cəna, tə slahay pa 'am anahan, ta zlah, ta wa: «Iken nə Wan a Mbərom!» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu a gafan 'am anà setene ataya tâ sa jan anà ɗowan winen wayaw bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pə dəɓa anahan a wa nà, Yesu a ján way anahan à ɓəzlom, a ngaman ayak à ɗo ahay kawa sa nan fok. Ta nay pə cakay anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Winen ite, a walay wa kuro nga anahan a cew, a ngaman atan nə ɗo maslan ahay. A jan atan, a wa: «Nə walay kwanay nà, aday ki njihen ti nen, ata ni slan kwanay saa wazay, ");
INSERT INTO mqbNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","saa razl setene ahay tə məgala a nen saa varak ikwen ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɗo a mə walay a kuro nga cew ataya nà, sləmay a tinen aya həna: Simon (Yesu a ɗaf apan sləmay hinen, a ngaman Piyer), ");
INSERT INTO mqbNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","atə Yakuba tə Yuhana, wan ana Zebede ahay (Yesu a ɗaf patan sləmay re, a ngaman atan Bowanerges ahay, kawa sa ja nà, wan ma dac Mbərom ahay), ");
INSERT INTO mqbNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andəre, Filip, Bartilome, Mata, Tomas, Yakuba wan ana Alfa, Tade, Simon, ɗo maniɗe sə Ruma ahay, ");
INSERT INTO mqbNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tə Yudas Iskariyot, ɗo saa ga ɗaf pə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Atə Yesu tə njavar anahan ahay ta may ahay agay. Asa, ɗo ahay tə halay nga kə̀ zalak, aday Yesu tə njavar anahan ahay tə njaɗak alay a sa pa way bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ɗo anahan ahay tə sləne 'am ata nà, ta nay sə gəɓak anan ayak, anga ɗo ahay ta wa: «I ga nə nga a vawan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Miter sə Tawrita aya inde, ta nay ahay kwa à Urəsalima wa. Ta wa: «Bə'elzebul apan!» Azar aya ta wa: «Ayaw! Fakalaw sə varan məgala sa razl anan setene ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu a ngaman ayak anà ɗo ataya pə cakay anahan, a jan atan 'am ta 'am sə jike, a wa: «Fakalaw i mba apan sa razl Fakalaw nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","À wulen sə bahay kərtek a inde nà, kak ɗo anahan aya tinen apan ti vaɗ zek nə, bahay ata i tavay nga mba ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kak ɗo su doh ahay, 'am kà zlak atan pi zek bay nà, doh ata i tavay nga mba ɗaw? A'ay. I gugwes. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Matana re, kak Fakalaw kə̀ slabakak pi zek anahan a nà, gədan anahan a i gəzla cew nà, i tavay nga mba ɗaw? A'ay. I lize. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Ɗowan saa mba apan sa zla ù doh su ɗo gədan a saa ngəzəray panan way anahan ahay nà, ibay. Si kə̀ lahak apan kurre kə̀ jawak anan ɗowan ata awan, aday i saa mba apan sa zlan ù doh sa ray panan way anahan ahay nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo ahay ti ga ines, ti jənan pa 'am anà Mbərom ɗukwen, i pəsen atan anan fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Əna ɗo sə jənan pa 'am anà Apasay Cəncan a nà, i njaɗ apəse 'am sə atahasl anahan kulibay. Anga ines anahan a sa ga ata nà, i njahay apan sə viyviya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu a ja matanan nà, anga ɗowan ataya ta wa: «Apasay lelibay inde apan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pə dəɓa anahan a wa nà, mərak a Yesu ahay tatə may anahan ta nay. Tə dəzle cəna, tə tavay uho, ta slan apan ɗo saa ngaman ayak. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɗo ahay inde bayak a mə njahay a pə cakay anahan ta jan kutok, ta wa: «Atə may anak tə mərak anak ahay, tinen mə tavay aya uho, tə cəce iken.» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Əna Yesu a mbəɗahan atan apan, a wa: «May uno, mərak uno ahay, ata nə atə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A ca pu ɗo sa van nga tew ataya, a wa: «Sə təra mərak uno ahay aday may uno nà, tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɗo sa ga way sa zlan à nga anà Mbərom ata nà, sə təra may uno tə mərak uno nə winen aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yawa, Yesu a dazlan sə wazan à ɗo ahay maza pa 'am sə bəlay sə Galile. Ɗo ahay bayak a tə halay nga pə cakay anahan. Anga nan, a ján à kwalalan inde saa njahay uda pa nga sə bəlay. Ɗo ahay fok mə njahay a pə yugo. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu a ɗakan atan anan way ahay bayan a tə jike ahay. À wazo anahan a inde a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Pəken sləmay. Ɗowan inde a zla à guvo, saa casl ndaw. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Winen apan i casl ndaw ata kutok, zahav a guce panan pə cəveɗ, aday məvuhom ahay tə ɗagay anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Zahav azar a, a guce pə saray pəkəraɗ, ta hay ahay bəse, anga yugo inde bayan a ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Əna pac a sləray cəna, a ɓutoy anan aday a vak anan, anga sləlay a ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zahav azar a a guce à wulen sə adak inde. Ta ha cəna, ta har pi zek tə adak, əna adak a bənan mbiyeɗ, ndaw ata kə̀ nahak bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Əna zahav azar a a guce pə yugo lele awan. Winen a hay cəna, a har, a zla nga uho, a nah kutok. Kərtek awan, hawal sa ndaw apan nə kwa kuro maakan, hinen ahay, hawal sa ndaw kwa kuro mbərka. Azar aya inde ɗukwen, hawal sa ndaw apan nə səkat səkat.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu a jan atan kutok: «Sləmay inde pə ɗowan a nə, â sləne 'am a anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pə dəɓa anahan a wa nà, Yesu winen taayak tu ɗo maslan anahan ahay kuro nga cew, tu ɗo maza aya ma van nga tew ata, tə cəce panan 'am anahan sa jan atan tə jike ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu a mbəɗahan atan apan, a wa: «Kwanay nà, way mi ɗer aya à bahay a Mbərom a inde ata nà, winen a kà gak ikwen panan akar sa 'am sə bahay anahan a coy. Əna ɗo maza aya nà, ti sləne way ahay fok nà, si ta 'am sə jike, ");
INSERT INTO mqbNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","anga aday: Tâ ca apan, əna tə canan bay, tâ pak apan sləmay, əna tə sləne bay. Bina aday tâ saa may ahay pə cakay ana Mbərom bay, aday Mbərom â pəsen atan anan ines a tinen ahay bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu a jan atan asa, a wa: «Kə slənen 'am sə jike a anan bay dəge? Matanan acəkan! Ki i slənen 'am sə jike ahay kula sabay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ɗo sa casl ndaw ata nà, a casl nə 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Zahav sa ndaw pə cəveɗ ata nà, ɗo sə sləne 'am a Mbərom a ahay. Pə dəɓa anahan a wa nà, ti təma anan bəse, əna Fakalaw i nay, i wuɗeh anan 'am a ma casl à tinen inde ata awan, anga aday â hay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Ɗo maza aya awan, ta ga minje tə zahav ma casl a pə saray pəkəraɗ ata awan. Tə slənek 'am a Mbərom nà, tə təma anan bəse tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Əna 'am ata a pak sləlay à mivel a tinen inde bay. Anga nan, ɗəce i tan atan à nga, kabay ajugwar 'am i nay ahay patan anga 'am ana Mbərom nà, ti mbəsak cəveɗ sa 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Ɗo maza aya ta ga minje tə zahav ma casl a à wulen sə adak inde. Tinen apan ti sləne 'am a Mbərom cite. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Əna way sə daliyugo inde cara cara. Ti sapat zek tə way sə daliyugo ahay, ti gan may à zlile sə daliyugo ahay, ti ga ubor si zek pə way ahay cara cara. Way ataya fok nà, ti bənan mbiyeɗ anà 'am a Mbərom, aday â nah bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Ɗo maza aya asa, ta ga minje tə zahav sa ndaw ma casl a pə yugo lele awan. Tinen apan ti sləne 'am ana Mbərom ma ja awan, tə təma anan lele, ta zla nga uho pa 'am a Mbərom. Anga nan, kərtek a i nah lele, hawal i ga apan kwa kuro maakan, hinen ahay ti nah ɗukwen, hawal i ga patan kwa kuro mbərka, azar aya kutok ite, ti nah, hawal i ga patan səkat səkat.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu a jan atan asa, a wa: «Kak, tə hanak uko pə lalam nà, ti ɗer anan ta sə hərok apan tasa, kabay ti ɗaf anan ù vo lala ɗaw? Lele nà, sa ɗaf anan pə way sa ɗaf lalam a biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sənen anan, way mi ɗer a, aday i njaɗ zek bay nà, ibay. Wurwer sə way saa dəzley ahay ipec məduwen a bay ɗukwen ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Anga nan kutok, kak ɗo, sləmay inde apan cəna, â sləne!» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A jan atan re asa: «Gen anan nga anà way a kwanay sə sləne ahay. Tasa a mbala a kwanay sə lavay anan way ata nà, Mbərom i lavak ikwen anan ɗukwen tə winen awan asa, aday i zəgahak ikwen anan apan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɗo kə̀ təɓak anan sləmay sə sləne 'am nà, Mbərom i zəgahan anan sə sləne 'am ite re. Aday ɗo kə̀ tacak anan sləmay, anga a nan sə sləne 'am bay nà, Mbərom i zəgahan anan sə tacan anan apan re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu a jan atan 'am maza awan, a wa: «Bahay a Mbərom a ga minje nà, tu ɗo sa casl zahav à guvo. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Â njak ahan, â njak ahan bay dəp nà, luvon tə ipec, zahav nə i ha, i har, mənjəna winen sa san a təra nə kəkəmaw nà, a san bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yugo nà, a ha anan zahav taayak, a təra anan gujeɗ, aday a təra anan gusuko, azanan asa, a zla nga uho, a nah zahav sə way asa re. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pə dəɓa anahan sa nah ata wa asa, i bəbez dem anahan saa car, sə halan nga anga way kə̀ nahak.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A ja asa, a wa: «Ɗi ga anan minje tə bahay a Mbərom nà, ta ma asa anaw? Kabay ɗi ɗakay anan nə tə jike wura asa anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bahay a Mbərom a ga minje nà, ta wan sə bəzan. Winen ma kac a pə zahav sə way sə daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Əna aday tə caslak anan à məke cəna, a ha, aday a har nà, a zalay dədazl si sé azar aya awan. Alay si sé anahan aya nə məduwen aya awan. Məvuhom ahay ti mba apan sə njahay uda à sise anahan awan tu doh a tinen aya təke.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu a təkəren 'am anà ɗo ahay nà, tə jike ahay bayak a kawa həna anaya awan, aday kawa ana ɗo ahay sa mba apan sə sləne. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kà jak atan 'am sə awan maza mənjəna jike bay. Əne pə dəɓa anahan a wa nà, atə Yesu, tinen mə mbəsak a taayak. À alay ata kutok, a ɗakan atan anan 'am sə jike aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pa pac ata kərtek awan, suko a ga bine siwaw nà, Yesu a jan anà njavar anahan ahay, a wa: «Takasuko pa day uho.» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tə slabak, tə mbəsak anan ɗo ahay mə halay nga kutok. Njavar anahan ahay ta zla à kwalalan anahan sə lahan ata uda pa 'am ata awan, tə njahay uda awan. Tə gəɓa anan, ta zla way a tinen, aday kwalalan azar aya ɗukwen inde à man anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tə dəzle à mamasl sə bəlay nà, vəvara məduwen a a slabak pa nga sə a'am. Məsugurndolon sə a'am ahay tə slabak, a nan à kwalalan sa rah coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu nà, winen ma njak ahan awan ta sə dəɓa, à slaway a inde, nga anahan ma ɗaf a pə way aday â gan dəɗaf. Njavar anahan ahay tə dazlan, tə pəɗek anan ta sa jan: «Miter, ɗi lize kutok nə, a gak à nga wa itəbay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu a slabak, a gafan 'am anà maɗ, a jan 'am anà məsugurndolon sə a'am ahay, a wa: «Njihen ɓəɓətek ɓəɓətek! Bəlay, iken ɗukwen ngatay aday, njahay tetəmtəme!» Maɗ a mbəsak sa ɓal, anga nan, bəlay ɗukwen kə̀ njahak tetəmtəme acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu a cəce pə njavar anahan ahay wa kutok: «Kə jəjiren nà, angamaw? Kə ɗəfen upo nga fan bay kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ta ma nga sə jəjar pi zek asa. Ta ja à wulen a tinen, ta wa: «Ɗo wura həna anan anaw? Atə maɗ tə məsugurndolon sə a'am ahay ɗukwen tə ɗəfan apan ata nà?» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu a nay pa 'am sə bəlay, pa day su kon sə Gerasina ahay, tinen tə njavar anahan ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A dazay ahay à kwalalan wa cəna, ɗowan inde, winen tə setene aya à nga inde, a nay ahay à wulen sə jəvay ahay wa, i zla pə cakay a Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ɗowan ata a taa nahay way anahan nà, à wulen sə jəvay ahay inde. Ɗowan a mba apan sa ban anan aday sə jaway anan bay. Tə jawak anan à səsile inde dəp nà, a kaɗ anan fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Saray bayan awan, tə ɓanak anan tə calalaw, alay tə saray a təke fok, əna, a taa slaɗ anan nduroc nduroc fok re. A zalan məgala ana ɗo sə pəlay sa gan nga ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Luvon tə ipec fok, winen apan i bar à wulen sə jəvay ahay inde. Winen apan i zlah à ɓəzlom ahay inde, aday a ta zek mbəlak awan tu kon. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Əna a canan ayak à Yesu winen apan i nay ahay cəna, a hawan ayak pa 'am, a dukwen gərmec ù vo. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","A zlah pi zek tə məgalak awan, a wa: «Iken Yesu, Wan a Mbərom sə bagəbaga mburom, kə pəlay puno wa maw? Na gak kem tə sləmay a Mbərom, kâ ga alay ti nen bay ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A jan matanan ata nà, anga ɓa Yesu kà jak anan: «Iken apasay lelibay awan, hayak à ɗowan a anan wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu a cəce panan kutok: «Sləmay anak a nə wayaw?» A mbəɗahan apan: «Sləmay uno Daskalak, anga manay bayak awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A dubok a Yesu tə mindel, a wa: «Kem, kâ sa razl setene a anaya dəren pə daliyugo a anan wa bay ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","À man ata aday nà, gadura ahay inde bayak a pa zar kon, mə jugwar aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Apasay lelibay ataya ta jan à Yesu kutok: «Varan umo cəveɗ, mâ zla à gadura a anaya inde ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu a varan atan cəveɗ acəkan, tâ zla à gadura ahay inde. Ta nay à ɗowan ata wa, tə ndərmaɗ à gadura ahay inde kutok. Gadura ahay ta haw way a tinen, tə haway kwa ahay pa zar kon wa, tə dazak ayak kwa pa 'am məgujeguje wa à bəlay inde. Gadura ahay ti ga mbulo cew, əne tə lizek fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Matanan, ɗo sa gan nga anà gadura ahay tə canan cəna, ta haw way a tinen agay. Ta tan 'am anà ləbara awan à wulen su doh məduwen awan, aday à wulen su doh sə kiɓe ahay fok re. Ɗo ahay ta nay ahay sa ca pə way ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tə dəzley ahay pə cakay a Yesu cəna, tə canan à ɗowan a apasay lelibay aya sa nay ahay wa ata awan, winen mə njahay awan, winen tə zana pi zek kutok. A san nga anahan zle lele coy. Aday ta ma nga pə ajəjar. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ɗo a sə canan anà masuwayan ataya tə təkəren ləbara sə təra pə ɗowan ata awan, aday pə gadura ahay fok anà ɗo sa zlak ayak ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɗo sa man ataya tə dazlan sə dubok Yesu aday â zla ù kon a tinen wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu winen apan i ján à kwalalan inde mba, ɗowan apasay lelibay aya sa nay ahay wa ata a jan anà Yesu nà: «Nə̂ pərahak azar ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Əna Yesu kə̀ mbakak anan cəveɗ sa zla maya tə winen bay, əna a jan, a wa: «Zla agay, təkəren anan anà ɗo su doh anak ahay nə ləbara sə way sə təra apak ataya, aday ka gan ì zek wa anà Mbərom Ba Məduwen nə kəkəmaw ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɗowan ata a zla way anahan, a dazlan sə təker anan ləbara ataya pə daliyugo sə Dekapol, kawa ana Yesu sa gan fok, aday a gan masuwayan anà ɗo sə sləne ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Natiya, Yesu a takasay bəlay, a nay pa day sə agay asa. Ɗo ahay tə halay nga pə cakay anahan bayak a pa 'am sə bəlay. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɗowan inde, tə ngaman Zayrus, a zlak ayak à man a Yesu. Winen ɗo məduwen awan, sə lavan nga anà mer su way ù doh sə wazay nà, winen. A dəzley ahay pə cakay anahan nà, a dukwen gərmec ù vo anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A gan may kə̀ zalak, a wa: «Dəna uno inde, winen ɗəvac awan, i mac! Kem, hayak, ɗaf apan alay anak ite, aday â mbar, â njahay zay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu a slabak, a pərahan azar. Aday, Yesu winen apan i zla nà, ɗo sə pərahan azar ahay tə ngəɗec anan pə cəveɗ. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uwar a inde à man ata awan, ɗəvac a ite re. Ava kuro nga cew, mez winen apan i pəkan ahay à kutov wa hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kà gak ɗəce à alay sə doktor ahay wa nə bayak awan. Kə̀ lizek anan zlile anahan fok, aday kə̀ njaɗak apan zay bay re, ɗəvac anahan a ma nga sə zakay bugol. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Iyo, uwar ata kə̀ slənek ləbara a Yesu. Anga nan, a nay ahay à wulen sə ɗo ahay wa ta sə dəɓa anahan. A jalay nà: «Abay nâ njaɗ sə laman alay anà zana anahan a cəna, ni mbar.» A laman à zana awan cəna, ");
INSERT INTO mqbNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","mez anahan sa taa pəkay ata a dəkac ma kərtek. A jəjam anan zek anahan nà, cəcaɓ cəcaɓ a san zle kə̀ mbərak à ɗəce anahan wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu ite, a san zle, məgala kà nak ahay à winen wa. A mbəɗa zek à wulen sə ɗo ahay inde, a cəce: «Waya sə lumo anà zana anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Njavar anahan ahay tə mbəɗahan apan, ta wa: «Kə canan zle, ɗo ahay tinen apan ti ngəɗec iken. Kutok nà, ki cəce ɗo sə lamak asa ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Əna Yesu winen apan i ca iɗe tuwwe hwiya, anga a nan sə canan à ɗowan sa ga awan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uwar ata a canan à masuwayan ata sə təra ì zek anahan inde ata nà, a jəjar pi zek yiɓyeɓ anga zlawan. A nay, a dukwen gərmec ù vo anà Yesu, a təkəren anan 'am ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu a jan kutok, a wa: «Mazar uno, aɗaf nga anak pi nen ata kə̀ mbərak iken! Həna ɗəvac anak inde sabay. Zla agay tə zay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","À alay a Yesu winen apan i ja 'am ata mba cəna, ɗo ahay ta nay àga Zayrus wa, winen ɗo sə lavan nga anà doh sə wazay ata awan, ta wa: «Zayrus, dəna anak nə kə̀ ndəvak zek. Kə̂ vawan nga anà Miter fan sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu kà gak anan nga anà 'am a tinen ata bay, a jan anà Zayrus: «Kə̂ jəjar bay, ɗaf upo nga lele cəna coy!» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kutok, Yesu a dazlan sa zla àga Zayrus asa. Əna kə̀ mbakak anan cəveɗ à ɗo ahay fok sə lagay anan bay, si anà Piyer, aday anà Yakuba tə mərak anahan Yuhana. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tə dəzle àga Zayrus nà, Yesu a sləne ɗo ahay tinen apan ti yam tuhhwa, ti zlah, ɗəce inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A zla ù doh, a ja: «Kə̂ bəbilen awan bay. Ki yimen angamaw? Dəna a anan kə̀ məcak bay. A njak ahan ca!» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Man su ɗo ataya tə mbasay apan. Yesu a rəzlay atan uho fok, a mbəsak ù doh nà, bəbay ta may ana dəna ata awan, tə apan njavar anahan maakan ataya awan. Tə dəzle pə cakay ana dəna ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A bənan anan alay a dəna ata awan, a jan: «Talita kumi!» kawa sa ja nà: «Dənama, slabak!» ");
INSERT INTO mqbNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kwayan'a, dəna ata a slabak, a dazlan sa bar. Aday ɗo ahay tə jəjar pi zek bayan awan. Ava ana dəna ata nà, kuro nga cew. ");
INSERT INTO mqbNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu a gafan atan 'am lele, a wa tâ saa jan à ɗowan bay. A jan atan asa tə̂ varan way sa pa à dəna ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kagasl, Yesu a slabak à man ata wa, a zla ù kon anahan à Nazaratu asa. Njavar anahan ahay tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Winen à man ata awan, luvon sa man uda awan a dəzley ahay nà, Yesu a dazlan sə ɗakay anan 'am a Mbərom ù doh sə wazay. Ɗo ahay bayan awan inde, tə sləne 'am sə tətak way a anahan ata nə a gan atan masuwayan, aday ta wa: «A tətakay way a anaya awanaw? A njaɗ kəlire sə asan way a anan kəkəmaw? Aday, a ga masuwayan həna anan cara cara nə ta maw? ");
INSERT INTO mqbNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na wa, winen nə ɗo sə cəceɗ dədom ba? May anahan Mariyama biɗaw? Mərak anahan ahay inde, atə Yakuba, tatə Yoses, Yuda, Simon, aday məran dəna aya ɗukwen inde, tinen à wulen a mənuko awan ba?» Anga nan kutok, ta ngam sa ɗaf nga pə Yesu bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu a jan atan, a wa: «Ɗo ahay ta gan nga anà 'am ana ɗo maja'am a Mbərom kwa ta sə wura fok. Əna ù kon anahan awan, à mamasl su ɗo anahan aya awan, aday ù doh anahan a nà, ɗowan a gan nga anà 'am anahan ahay itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Natiya, Yesu kə̀ njaɗak sa ga masuwayan à man ata kwa wura bay. Si a ɗaf alay pu ɗo sə ɗəvac azar aya ngal, a mbar atan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A gan à winen awan wadan wadan, anga aɗaf nga a tinen inde pə Mbərom kwa mənjœk ibay. Pə dəɓa a way ata wa nà, Yesu a zla pu kon sə daliyugo ata fok, a ɗakan anan way à ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","8","À alay ata awan, a nan à Yesu sa slan anan ɗo maslan anahan kuro nga cew ataya à wulen su doh aya inde. A halan atan nga, aday a varan atan məgala sa razl apasay lelibay aya awan. A jan atan kutok, a wa: «Ni slan kwanay nə cew cew. Kâ saa gəɓen awan pə alay anga cəveɗ bay, kwa way sa pa, kwa mbulo sə dala. Ki gəɓen nà, si sukol, ");
INSERT INTO mqbNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","təkarak, aday zana ɗukwen kərtek.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A jan atan asa, a wa: «Kak ki zlen à wulen su doh a nà, njihen nə àga ɗowan a sə təma uda kwanay ata awan. Ki njihen àga winen hus pə luvon a kwanay saa zla way a kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Əna aday ɗo sa man ataya tə təmahak kwanay bay ite nà, zlen way a kwanay à man ata wa, aday kə̂ bəzləmen morbodok su kon a tinen pə saray a kwanay ahay wa, anga aday tâ san pi zek tinen tə ines aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɗo maslan a Yesu ataya ta zla, tə wazan à ɗo ahay, aday tə̂ mbəɗahan lœn ì ines a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tə rəzlak setene ahay bayak awan, aday tə mbərak ɗo sə ɗəvac ahay bayak awan ta sə mbəɗan atan amar pa nga. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iyo, bahay a inde məduwen awan, tə ngaman Hiridus, a sləne ləbara ana Yesu, anga ɗo ahay fok tinen apan ti təker ləbara a Yesu kwa aha fok. Ɗo ahay ngal ta ja, ta wa: «Yuhana, ɗo sa gan baptisma anà ɗo ahay ata, kà mak uho.» Tə ɗakan à Yesu nà, Yuhana. Anga nan, ta ja nə, a mba apan sa ga masuwayan ahay ata nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɗo maza aya ite, ta wa: «Yesu nà, Eliya.» Aday ɗo hinen ahay ɗukwen ta wa: «Winen nà, ɗo maja'am a Mbərom hinen, kawa ɗo maja'am a Mbərom sə kwakwa ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Əna Hiridus a sləne 'am ataya fok nà, a ja, a wa: «Yuhana, nen sa gaɗ panan nga ata nà, kə̀ slabakak ahay à məke wa!» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kwakwa ata nà, Hiridus a gəɓa anan Hirudiya, uwar ana wanbay anahan a inde, tə ngaman Filip. Anga nan, Yuhana a jan, a wa: «Ki jipen pə uwar tə mərak anak nə, lelibay. Way ata nà, ines!» Anga nan kutok, Hiridus a jan anà ɗo ahay tâ ban anan Yuhana. Ta ban anan, tə ɗəfak anan ayak ù doh sə dangay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Natiya kutok, Hirudiya a nan iɗe à Yuhana, a gan may sə lize anan. Əna, kə̀ njaɗak apan cəveɗ a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aday ɗukwen Hiridus a jəjaran anà Yuhana. A san zle, Yuhana a nà, winen ɗo lele awan, aday ɗiɗem a pa 'am a Mbərom. Anga nan re, a gan nga lele. A ta pak sləmay pa 'am anahan awan nà, a wusen nga, əna hwiya a gan may sə sləne asa. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pə luvon a inde kutok, Hirudiya a njaɗ cəveɗ sa ban anan Hiridus pə kwande. Azar uko sə bayak pə luvon sə wahay anan bahay Hiridus a ga. A da way sa pa, a ngaman anà ɗo sə zlile ahay pə daliyugo sa Galile, pi zek tu ɗo sə lavan nga anà suje ahay fok, pi zek tə bahay sə daliyugo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kutok nà, dəna a Hirudiya inde, a zlak ayak, a gərvan atan. Agərav anahan ata lele, kà zlak anan à nga anà bahay Hiridus tu ɗo anahan ahay fok. Aday Hiridus a cəce pə dəna ata wa, a wa: «A nak nə maw? Way anak saa cəce fok ni varak anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dərzalah a mbaɗan apan, a wa: «Ni varak anan way anak saa cəce ata fok, kwa i dəzle hus pa sə gəzla anan bahay uno ì zek wa cew dəp nà, ni varak anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dəna dalay ata, a nay uho, a jan anà may anahan, a wa: «Mamay, nə̂ cəce nə maw?» May anahan a wa: «Cəce nà, tə̂ gəɗak ahay nga a Yuhana.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Cəna, dəna a dalay ata awan a may ahay pə cakay ana Hiridus, a jan, a wa: «U no ki gaɗ anan nga anà Yuhana, aday vuro anan ahay həna à kwatama inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Way a mə cəce ata kà zlak anan à nga anà Hiridus sabay fok. Əna ɓa kə̀ mbaɗak anan pa 'am ana ɗo anahan mə ngamay ataya coy. I varan anan bay nà, i ga zek sabay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Matanan, a slan suje kərtek, aday â gəɗan anan ahay nga a Yuhana à kwatama inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Suje ata a zla ù doh sə dangay, a gəɗay nga pə Yuhana wa. A nàn anan à kwatama inde, a varan anà dəna a Hirudiya. Winen ite a təma anan cəna, a varan anan anà may anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Njavar a Yuhana ahay tə sləne ləbara awan cəna, ta zla saa gəɓay anan ahay məsinde a Yuhana, ta la anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aday, ɗo maslan a Yesu ataya ta may agay kutok. Tə halan nga pə cakay, tə dazlan sə təkəren anan way a tinen sa ga, aday sa jan anà ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","À alay ata nà, ɗo ahay tinen apan ti zlak ayak, tinen apan ti zla way a tinen bayak awan. Atə Yesu tu ɗo maslan anahan ahay ta njaɗ cəveɗ aday ti pa way bay. Anga nan kutok, Yesu a jan atan, a wa: «Kwanay, hayak ikwen ahay taayak a kwanay awan, zluko à kiɓe à man a ɗowan inde uda ibay ata awan. Ata, ɗi njaɗ sa man uda mənjœk.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ta ján à kwalalan inde, aday ta zla kəcah pə ɗo ahay wa à kiɓe. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɗo ahay bayak a tə canan atə Yesu tə njavar anahan ahay tinen apan ti zla way a tinen. Aday ɗukwen ta san atan zle. Anga nan, ɗo ahay ta nay ahay à wulen su doh ahay wa cara cara, ta haw tə saray à man ana Yesu saa zla. Tə lahan atan à Yesu tə njavar anahan ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu a dazay ahay à kwalalan wa cəna, a canan anà ɗo ahay bayak awan. Ɗo ataya ta gan ì zek wa, anga tinen kawa təman ahay, aday mənjəna ɗo sa gan atan nga. Anga nan, Yesu a dazlan sə ɗakan atan anan way ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Anga luvon winen apan i ga ata nà, njavar a Yesu ahay ta nay pə cakay anahan, ta wa: «Mənuko à man kiɓe inde, aday luvon winen apan i ga. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Suwan, mbakan cəveɗ anà ɗo ahay tâ zla à wulen su doh ahay, pə culok ahay, aday ti i sukom way sa pa ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu a mbəɗahan atan apan, a wa: «Kwanay a viren atan way sa pa awan.» Njavar anahan ataya, ta jan, ta wa: «A nak ma saa sukumay ahay way sa pa tə dala sə dinar səkat cew, anga aday mi varan atan acəkan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu a cəce patan wa asa, a wa: «Tapa sə pen inde pikwen həna nə jugumaw? Ənga, cen apan aday.» Ta cay ahay apan, ta jan: «Inde nà, tapa sə pen ahay ɗara, tə kəlef ahay cew.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kagasl, Yesu a jan anà njavar anahan ahay tə̂ njahay anan ɗo ahay pə gujeɗ məngəɗez a à man ata awan, njəɓukɓok cara cara. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tə njahay atan nà, njəɓok cəna səkat səkat, aday njəɓok cəna kwa kuro ɗara kwa kuro ɗara. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu a gəɓa anan tapa sə pen a ɗara ataya tə kəlef a cew ataya awan. A ca iɗe à mburom, a ngəran ayak anà Mbərom. A gəzla anan tapa sə pen ataya ì zek wa, a varan anà njavar anahan ahay, aday tə̂ gəzlan anan anà ɗo ahay. Kutok, Yesu a gəzla anan apan kəlef a cew ataya awan, a varan atan apan. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɗo ataya fok ta pak, tə rahak ɓah ɓah. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pə dəɓa a way ata wa coy nà, njavar anahan ahay tə halan nga anà tapa sə pen tə kəlef a mə mbəsak ata nà, a ga cəkarak kuro nga anahan a cew. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɗo sa pa way à man ata ɗukwen, tinen mə baslay a nà, mungol a ɗəkɗek aday nà, mbulo ɗara. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pə dəɓa anahan a wa cəna, Yesu a jan anà njavar anahan ahay tâ ján à kwalalan inde, aday tə̂ lahan pa 'am sa zla à Baytisada pa day sə uho. Winen awan, i i mbəsak anan ɗo ahay à dəɓa a tinen wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tə gəzla nga tə ɗo ahay kutok, a zla way anahan à ɓəzlom saa ga amboh. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Luvon a ga coy nà, Yesu winen taayak anahan à məndak mba. Njavar anahan ahay ɗukwen tinen tə kwalalan a kwa à mamasl sə bəlay dəren coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A canan atan ayak nà, tinen apan ti ɓal kwalalan nə tə gədan, anga tinen apan tə zlangay nga uda ta maɗ. Way ata fok a təra nà, luvon uda mba. Iɗe a sa jəka i cəɗe nà, Yesu kə̀ dəzlek à man a tinen winen apan i zla tə saray pa nga sə a'am. A ga kawa i saa gəɗan atan anan 'am. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Njavar anahan ahay tə canan winen apan i zla tə saray pa nga sə a'am ata cəna, tə jalay nà, i ga nə mədahan. Anga nan kutok, ta zlah pi zek. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tə jəjar pi zek yiɓyeɓ anga tinen a fok tə canak anan. Aya əna Yesu a canan atan cəna, a jan atan ayak 'am kwayan'a, a wa: «Bənen mbac lele, nen awan, kə̂ jəjiren bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A ján à kwalalan inde pə cakay a tinen awan cəna, maɗ a mbəsak sa ɓal cite. À man ata wa kutok, ajalay nga a tinen a mbəɗa wucəfeɗ. Way ata a gan atan masuwayan ");
INSERT INTO mqbNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","anga 'am sə masuwayan sə təra tə tapa sə pen ata a ja nə maw nà, tə sənak anan bay re. Kurkwilen inde à sləmay a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tə takasay ahay pa day sə agay lele nà, ta zla ù kon sə Gənesaret. Ta ban anan kwalalan pa 'am sə bəlay. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tə dazay à kwalalan wa cəna, ɗo ahay tə sənak ayak Yesu kwayan'a ");
INSERT INTO mqbNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ɗo ahay tə sləne sa jəka Yesu winen à man tiya ata cəna, tə haway ahay tə day sə wulen su doh ahay wa fok. Tə dazlan sa ran ahay ɗo sə ɗəvac mə nahay aya pə lala ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta man anahan sa zla fok cəna, a ga nà, culok, kiɓe, kabay wulen su doh aɗəka, tə halan ahay ɗo sə ɗəvac ahay. Tinen a tavay atan pa man sə lumo ahay fok. Ta gan amboh â mbəsakan cəveɗ anà ɗo ɗəvac ataya tə̂ laman alay kwa anà 'am sə zana anahan, aday tâ mbar ite. Ɗo sə laman ataya fok, tə mbərak acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisa aya inde, tinen tə azar sə miter sə Tawrita ana Musa ahay, ta nay ahay kwa à Urəsalima wa, tə halay nga pə cakay ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tə canan anà njavar a Yesu azar aya tinen apan ti pa way mənjəna sə banay alay kawa atətak way sə Farisa ahay. Ata pə tinen nà, njavar a Yesu ahay ta gak ines. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Anga aday nà, Yahuda ahay fok, mə zakan a anà Farisa ahay nà, tə ɗəfan apan anà atətak way sə bije a tinen ahay nə lele. Ta taa pa way aday mənjəna sə banay alay kawa atətak way sə bije a tinen bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kwa, ta nay ahay nə à kwasuko wa ɗukwen, tə banay zek, aday ta sa pa way. Tə ɗəfan apan anà atətak way sə bije azar aya ɗukwen lele, kawa acakaɗ gəsa'am, kəlawa, aday tuwez ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anga nan kutok, Farisa ataya pi zek tə miter sə Tawrita ahay tə cəce pə Yesu wa, tə dazlan, ta wa: «Njavar anak ahay nà, tə pərahan azar anà atətak way sə bije ahay bay nə angamaw? Bina, ta pa ɗaf mənjəna sə banay alay kawa atətak way sə bije ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu a mbəɗahan atan apan, a wa: «Kwanay aday nà, mbaɗəmbaɗa aya awan. Ezaya kə̀ vindek 'am a Mbərom ɗiɗem a anga kwanay, Mbərom a wa: “Ɗo anaya tə həro nga nà, ta 'am ɗəkɗek, mivel a tinen aya nə dəren ti nen. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tinen apan ti dukwo gərmec ù vo nə kəriya awan. Bina tinen apan ti tətakan anan anà ɗo ahay nà, way sa nga a tinen ahay ɗəkɗek.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu a jan atan asa: «Kwanay nà, kə mbiken 'am a Mbərom ma ja aya awan, anga sə pərahan azar anà 'am sə ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ambəsak 'am a Mbərom, aday sə mbəɗek pə anjahay sə bije ahay nà, a dak ikwen 'am bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa kà jak: “Ɗəfan apan anà bəbay anak tə may anak” aday “Kuwaya ɗowan a kà jak 'am lelibay a pə bəbay anahan kabay pə may anahan nà, sa vaɗ anan.” ");
INSERT INTO mqbNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Əna kwanay ki jen nà, kak ɗowan a kà jak anan anà bəbay anahan kabay anà may anahan: “Way uno abay saa mak anan zek ata nà, winen korban, kawa sa ja nà, kə̀ tərak anà Mbərom.” ");
INSERT INTO mqbNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ata i ɗəfan apan anà atə bəbay tə may sabay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Matanan kutok, kə nəsen anan way a Mbərom ma ɓan awan, anga sə pərahan azar anà atətak way sə bije ahay. Kwanay apan ki gen way maza aya cara cara kətanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu a ngaman ayak anà ɗo ahay maza awan, tâ nay pə cakay anahan. A jan atan, a wa: «Pəken uno sləmay, kwanay a fok, sənen 'am a anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Way inde uho, i zla à kutov su ɗo saa ga apan məsagar nà, ibay. Əna, sa ga məsagar pu ɗo nà, way sa nay ù ɗo wa uho bugol aɗəka.  ");
INSERT INTO mqbNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kak sləmay inde pə ɗowan sə sləne 'am nà, â pak sləmay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu a dazlan nà, a zla way anahan ù doh pə cakay sə ɗo ahay wa. Njavar anahan ahay tə cəce panan jəba sa 'am sə jike ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu a jan atan: «Kwanay ɗukwen, kə sənen fan bay ɗaw? Way sa zlak ayak uho wa ù ɗo inde nà, i mba apan sa ga məsagar pu ɗo bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Anga way sa pa i zlan à mivel inde bay, si à kutes inde. Pə dəɓa anahan a wa nà, i may ahay uho. Kwanay kə sənen bay re ɗaw?» Yesu a ja kətanan nà, aday tâ san nə way sa pa ahay fok lele. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A ja asa: «Way sa nay ahay ù ɗo wa uho nà, i ga apan məsagar kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Anga sa nay à mivel su ɗo wa kutok cəna, way kawa aga vuwar, akar, avaɗ nga su ɗo, ");
INSERT INTO mqbNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aga mədigweɗ, aga ubor, aga huwan, agaɗ mungwalay, aga way sə wurwer ana ayaw si zek lelibay awan, aga sərak, agəɗan azar ù ɗo, ahəran nga anà zek anahan, aga way sə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Way ataya fok, ta nay fok nà, ù ɗo wa, aday ta ga məsagar pu ɗo acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pə dəɓa anahan a wa nà, Yesu a slabak way anahan à man ata a wa kutok, a zla à wulen su doh a inde, bəse tə Tirus. A dəzle cəna, a njahay àga ɗowan inde, aday a nan abay ɗowan â san apan bay. Əna ɗo ahay tə sənak apan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uwar a inde à man ata nà, dəna anahan inde, winen tə setene awan. A sləne ləbara a Yesu cəna, a nay pə cakay anahan. A dukwen gərmec ù vo. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uwar ata nà, winen Sirofiniki ahay, a ja 'am sə Gərek. A jan anà Yesu, â razl anan setene à dəna anahan ata wa, apasay a sə vawan nga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aday Yesu a mbəɗahan apan, a wa: «Mbəsak anan gwaslay ahay tâ rah aday. Anga sə gəɓa anan way sa pa sə gwaslay ahay, sə varan anan anà kəla ahay nà, sumor a bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Uwar ata a mbəɗahan apan, a wa: «Matanan, bahay uno. Əne kəla ahay ɗukwen ta pa way sa pa sə pəpas pə gwaslay ahay wa ata re asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu a jan: «Anga 'am anak a anan, ki mba apan sa zla agay. Apasay sə vaway nga ata, kà nak ahay à dəna anak wa coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uwar ata a zla agay, a dəzle cəna, a tan ayak à nga à dəna anahan mə nahay a pə biket. Apasay sə vaway nga ata kà nak à dəna ata wa acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu a nay way anahan pə daliyugo sə Tirus wa. A zla tə daliyugo sə Sidon, a dəzle pə cakay sə bəlay sə Galile, pə daliyugo sə Dekapol. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","À man ata kutok, ɗo ahay ta nan anan ahay ɗowan a inde mədəngazlak awan. Ɗowan ata nà, a sləne sləmay bay aday a ja 'am lelibay re. Ta gan amboh anà Yesu aday â ɗaf apan alay, â mbar anan ite. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu a ngaman ayak à wulen sə ɗo ahay wa. Ta zla tə Yesu dal nà, Yesu a ɗəfan alay à sləmay inde. Aday, a təfe məne pə alay, a laman anan à miresl anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A ca iɗe à mburom, a sakaf pi zek, a ja, a wa: «Effata!» kawa sa ja nà: «Təɓa zek!» ");
INSERT INTO mqbNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Natiya cəna, sləmay anahan ahay tə təɓak, miresl anahan ɗukwen kə̀ pəsakak ite, a ja 'am lele kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu a jan atan fok a tinen awan, tâ sa jan à ɗowan bay. Winen apan i taa gafan atan 'am dəp nà, tinen tə zəga anan sə təker ləbara awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɗo sə sləne ləbara ataya fok, a gan atan masuwayan, ta wa: «Way anahan sa ga fok nə lele. Mədəngazlak ahay tə sləne sləmay, aday maandak ahay ɗukwen ta ja 'am kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","À alay ata awan, ɗo ahay tə halay nga bayak a miza awan. Way sa pa ɗukwen inde patan ibay. Anga nan kutok, Yesu a ngaman anà njavar anahan ahay, a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ɗo a anaya tu go ì zek wa, anga mənuko pə kərtek a luvon maakan həna, way sa pa ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kak na sak a mbəsak atan ti zla agay ta may awan nà, ti ga bəle pə cəveɗ. Aday ɗukwen ɗo azar aya ta nay ahay kwa à man dəren aya wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Njavar anahan ahay ta jan, ta wa: «Mənuko à kiɓe kutok nà, ɗi saa njaɗay ahay way sa pa awan awana, aday saa slan ù ɗo a anan fok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu a cəce patan wa, a wa: «Tapa sə pen inde pikwen nə jugumaw?» Tə mbəɗahan apan, ta wa: «Cuwɓe.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu a jan anà ɗo ahay, tə̂ njahay à məndak, aday a gəɓa anan tapa sə pen a cuwɓe ataya awan. A gan ayak suse anà Mbərom nà, a gəzla anan ì zek wa, aday a varan anan anà njavar anahan ahay, aday tə̂ gəzlan anà ɗo ahay. Tə gəzla anan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kəlef cəɗew aya inde patan mənjœk re. Yesu a ngəran ayak à Mbərom anga nan re. Aday a jan anà njavar anahan ahay tə̂ gəzla anan kawa tapa sə pen ahay asa. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ɗo a mə halay nga ataya fok, tinen ta ga mbulo fuɗo, ta pak, tə rahak. Tapa sə pen mə mbəsak ata nà, a ga cəkarak cuwɓe re. Coy, Yesu a mbəsak anan ɗo ahay tə gəzla nga. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Cəna, Yesu a ján à kwalalan inde tə njavar anahan ahay. Ta zla way a tinen ù kon sə Dalmanuta. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisa aya inde, ta nay sa vaɗ awiyaway tatə Yesu. Tə cəce Yesu â ga masuwayan sə way sa nay ahay à mburom wa, anga a nan atan sa ban anan pə kwande. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu a sakaf, a ma anan apasay à zar kutov lele nà, a ja, a wa: «Ɗo sə biten ahay tə pəlay masuwayan nà, angamaw? Nen apan ni jak ikwen tə ɗiɗem a həna, ti njaɗ minje sə masuwayan sabay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Coy, a mbəsak anan Farisa ataya awan, a ma way anahan à kwalalan inde, sə takas bəlay pə day hinen asa. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Njavar a Yesu ahay tə mbəɗəkek anan nga sə gəɓa tapa sə pen à alay inde. Tapa sə pen inde patan à kwalalan inde nà, si kərtek coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu a jan atan, a wa: «Uffa ahak ikwen! Bənen nga a kwanay nə lele pə wuɗah sə Farisa ahay wa, tə wuɗah ana Hiridus.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Əna tinen ta ja à wulen a tinen inde nà: «I ga nə a ja pə pen ɗə gəɓak à alay inde bay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu a sənan atan anan kwayan'a, a jan atan, a wa: «Kə bayiken, na ja nə anga tapa sə pen inde pikwen ibay nà, angamaw? Kə sənen apan fan bay ɗaw? Ki mben apan sə sləne 'am a anan bay kələɗaw? Kurkwilen inde à sləmay a kwanay ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","«Iɗe inde pikwen asənə, kə cinen anan à awan bay kələɗaw? Sləmay inde pikwen asənə, kə slənen sləmay bay kələɗaw? «Aday, kə mbəɗəkek ikwen à nga wa ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","À alay a nə gəzla tapa sə pen ahay ɗara, anà ɗo ahay tinen mbulo ɗara nà, kə hilen anan nga a mə mbəsak a ata awan nə cəkarak jugumaw?» Tə mbəɗahan apan, ta wa: «Cəkarak kuro nga anahan awan cew.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Aya, aday nə gəzlan tapa sə pen cuwɓe à ɗo ahay mbulo fuɗo nà, kə hilen anan nga à mə mbəsak awan nə cəkarak jugumaw?» Tə mbəɗahan apan, ta wa: «Cuwɓe!» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","«Aya aday kə sənen həna bay nà, angama kutok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu tə njavar anahan ahay tə dəzle à Baytisada kutok. Ɗo ahay tə gəɓay ahay ɗowan a inde, winen hurof awan. Ta gan amboh anà Yesu aday â laman alay ite. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu a bənay anan ɗowan ata alay a wa, a zla anan kəcah à wulen su doh wa. A təfen məne pə iɗe, a ɗaf apan alay. A cəce panan, a wa: «Kə canan à way ahay zle ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Winen a mbəɗahan apan, a wa: «Nen apan ni canan anà ɗo ahay tinen apan ti zla, əna tinen kawa dədazl si sé ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu a ɗəfan alay pə iɗe maza awan. Winen ite a zəzor way ahay lele, kə̀ mbərak kutok, a canan iɗe zle coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu a jan, a wa: «Zla agay. Kâ ma tə wulen su doh sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pə dəɓa anahan a wa nà, atə Yesu tə njavar anahan ahay ta zla ù kon maza awan, pə cakay sə Kaysariya Filipi. À alay a tinen pə cəveɗ mba nà, Yesu a cəce patan wa, a wa: «Ɗo ahay ta ja pi nen nà, nen nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Njavar anahan ataya tə mbəɗahan apan, ta wa: «Ɗo hinen ahay ta wa iken Yuhana, ɗo sa gan baptisma anà ɗo ahay ata awan. Ɗo maza aya ta wa, iken Eliya, ɗo maja'am a Mbərom. Ɗo azar aya ɗukwen ta ja nà, iken ɗo kərtek à wulen su ɗo maja'am a Mbərom ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu a cəce patan wa: «Aday kwanay a nà, ki wen nen wayaw?» Piyer a mbəɗahan apan, a wa: «Iken nà, Almasihu.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu a gafan atan 'am, a wa: «Kâ saa ɗiken anan 'am a anan anà ɗowan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Cəna, Yesu a dazlan sə ɗakan anan anà njavar anahan ahay, a wa: «Bəlaray nen, Wan su Ɗo nà, ni ga ɗəce bayak awan. Aday məceɗ sə Yahuda ahay, tə bahay sə gəɗan dungo anà way ahay anga Mbərom, tatə miter sə Tawrita ahay, ti lar nen, aday ɗo ahay ti vaɗ nen. Aday ɗukwen, luvon maakan pə dəɓa anahan a wa cəna, ni slabakay way uno à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A jan atan anan nà, ì iɗe inde. Piyer ite a ngaman, ta zla kəcah, a gafan 'am. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu a mbəɗa 'am pə njavar anahan ahay, a cak ayak patan. Cəna, a gafan 'am anà Piyer, a wa: «Zlak ayak pə cakay uno wa, iken Fakalaw. Anga ajalay nga anak ata nà, a nay ahay ù ɗo zənzen a wa, bina mbala a Mbərom ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cəna, Yesu a ngaman ayak anà ɗo ahay, tə njavar anahan aya təke, a jan atan: «Kak ɗowan a a nan sə pəruho azar nà, â mbəsak sə bayakan way anà nga anahan, â tavak dədom anahan mə zləlngaɗ awan, â pəruho azar. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anga kâ nak anan anà ɗowan a sa tam anan sifa anahan nà, i lize anan aɗəka. Əna ɗowan a kə̀ lizek anan sifa anahan anga nen, aday anga ləbara uno mugom a anan ata nà, i tam anan sifa anahan aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bina, ɗo kà sak a njaɗ anan way sə daliyugo a anan fok anà winen, aday sifa anahan a nà, kə̀ lizek anan nə, sa gan dəɗaffa nà, ma mba asa anaw? Ibay! ");
INSERT INTO mqbNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awan a inde aday ɗo zənzen i var sə bəmbaɗ anan sifa anahan nà, inde ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Ɗo sə biten ahay nà, mi nes aya awan, aday tə mbəɗahak anan lœn anà Mbərom. Aya əna, kak ɗowan a kà gak waray sə ɗakay anan sləmay uno aday sə ɗakay anan 'am uno ahay nà, nen ni ga anan winen kəkəmaw? À alay a aday na mak ahay tə mazlaɓ ana Bəbay uno Mbərom, aday tə maslay anahan cəncan aya ata nà, nen Wan su Ɗo ɗukwen ni naa pəkan waray ì iɗe cite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu a ja asa, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan aya inde à man a anan, ti mac mənjəna sə canan anà bahay a Mbərom bay. Si bahay a Mbərom i nay ti canan tə məgala awan aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pə dəɓa anahan a wa kutok, a ga luvon ahay mbərka nà, Yesu a gəɓa pə azar Piyer, Yakuba tə Yuhana, ta ján taayak à ɓəzlom a inde zəbor awan. À man ata kutok, zek anahan a mbəɗahan atan pə iɗe. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zana anahan a mbəɗa kweɗekkweɗek, a dav herre kə̀ zalak. Ɗowan saa mba apan pə daliyugo sə banay zana kətanan nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Njavar anahan a maakan ataya, tə canan anà atə Eliya tə Musa tə sləray, tinen apan ti ja 'am tatə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyer a jan à Yesu, a wa: «Miter, mənuko à man a anan nə sumor awan. Mi ngaray jawjawa ahay maakan: kərtek awan anga Musa, kərtek a ite anga Eliya, aday mədakwidok a nà, anga iken awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Anga zlawan sa gan atan ata awan, Piyer a san way anahan a sa ja ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pə dəɓa anahan a wa nà, mugudongudon a dazay, a van atan nga sərdədek. Aday 'am a ndəray ahay à mugudongudon ata wa, a wa: «Həna a anan nà, wan uno ləliwe uno awan. Slənen anan anan 'am anahan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Am ata a ndav cəna, njavar ataya tə canak anan à ɗowan sabay. Si Yesu a kərtektəkke pə cakay a tinen coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tinen apan ti dazay à ɓəzlom ata wa mba, Yesu a jan atan, a wa: «Way a kwanay sə canan ahay à ɓəzlom wa ata nà, kâ si jen anan à ɗowan bay, hus pə luvon uno nen, Wan su Ɗo, saa slabakay à məke wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Njavar anahan ataya tə təmahak 'am ata awan, ta ɗer anan à mivel inde, əna tə cəce pi zek ahay wa asa: «I slabakay à məke wa aday nà, 'am ata a nan sa ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Anga nan, tə cəce pə Yesu wa, ta wa: «Miter sə Tawrita ahay ta wa, Eliya i lahan anà Almasihu aday nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","A mbəɗahan atan apan, a wa: «Acəkan! Eliya i lahay, i ndakay anan way ahay fok. Aday ɗukwen Deftere a Mbərom a wa bəlaray, si Wan su Ɗo i ga ɗəce bayan awan, aday ɗo ahay ti kəɗey anan nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nen apan ni jak ikwen: Eliya kà nak ahay, aday ta gak anan kawa a tinen sa gan may sa ga fok, kawa ana Deftere sa ja apan ata coy.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu tə njavar anahan a maakan ataya tə dəzley ahay à man sə njavar anahan azar aya nà, tə canan anà ɗo ahay bayak a ma van atan nga cərlew. Njavar anahan ahay tinen apan ti vaɗ awiyaway pi zek tə azar sə miter sə Tawrita ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ɗo ahay tə canan anà Yesu nà, a gan atan masuwayan tə mindel. Tə haway ahay pə cakay anahan ahahaw sa naa jan 'am: «Iken inde zay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu a cəce pə njavar anahan ahay wa, a wa: «Kə vəɗen awiyaway tə tinen nə pa maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ɗo kərtek à wulen su ɗo ahay wa a mbəɗahan apan, a wa: «Na nak anak anan ahay ta wan uno. Məhərvov a vawan nga. A mba apan sa ja 'am tətibay, a ɓan panan 'am. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Məhərvov ata kà nak apan kwa aha ɗukwen, ata i ban anan à məndak ɓərav. Aday ata mumbof a rahan à 'am inde popo, i rac slan ngərəcəcəcəcəca, zek anahan a nà, a səre anan səɗœɗœ. Na gak anan kem anà njavar anak ahay, aday tə rəzlay a wa məhərvov ata awan, əna ta mbak apan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Coy Yesu a jan atan, a wa: «Kwanay nà, aɗaf nga a kwanay ma kac awan kələɗaw? Ni njahay tə kwanay, aday ni səmen anà way a kwanay ahay nə hus à siwaw? Hayak ikwen uno anan ahay wan a aday!» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ta nan anan ahay wan ata pə cakay anahan a kutok. Coy, wan ata a canan à Yesu nà, məhərvov ata a ban anan, a ɓal anan zek a wan ata tə məgala, aday a slahay à məndak. I ja mawa tumbolombolo pə yugo, aday mumbof à 'am inde popo bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu a cəce pə bəbay a wan ata wa, a wa: «Way a anan a dazlan sa gan nà, kwa siwaw?» Ɗowan ata a mbəɗahan apan, a wa: «Kwa winen tə cəɗew awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saray bayak a məhərvov a anan i ban anan, ata i slahay anan ù uko inde, kabay à a'am inde, aday â mac. Əna na gak nə kem, nâ gak ì zek wa ite, kak ki mba apan nà, man umo zek ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu a mbəɗahan apan, a wa: «Ka ja, ka wa: “Kak ki mba apan” nà, angamaw? Pu ɗo sa ɗaf nga pə Mbərom nà, way ahay fok ta ga zek asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Coy bəbay a wan ata a zlah pi zek, a wa: «Ni ɗaf nga pə Mbərom, əna ni mba apan sə ɗaf apan nga gem fan bay. Kem, mo zek ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu a canan à ɗo ahay ɗukwen tinen apan ti zlak ayak à man a tinen bayak awan. Cəna, Yesu a ngəraz pə apasay ata, a jan: «Iken apasay a sə dəngazl ɗo aday sa ɓan 'am pu ɗo wa a anan. Hayak à wan a anan wa! Kâ naa ma apan sa zla à winen inde kula sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Natiya, apasay ata a zlah pi zek, a ɓal anan wan ata kəzlek kəzlek tə məgala, a nan ahay ì zek wa bok. Wan ata nà, kawa ma mac a coy. Ɗo ahay bayak a tə bayak nə, winen kə̀ məcak. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Əna Yesu a bənan alay, a slabak anan. Wan ata a tavay jek. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Natiya, Yesu a may ahay agay nà, njavar anahan ahay tə cəce panan taayak a tinen awan, ta wa: «Manay ma mba apan sə rəzlay anan wa məhərvov ata bay nà, angama kərtek anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu a mbəɗahan atan apan, a wa: «Məgala hinen saa razl jəba sə məhərvov a anan nà, si sa ga nə amboh aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Natiya, pə dəɓa anahan a wa kutok, atə Yesu tə njavar anahan ahay tə mbəsak Kaysariya Filipi, ti takas daliyugo sə Galile. A nan à Yesu nà, ɗowan â san anan winen à man ata bay, ");
INSERT INTO mqbNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","anga a nan sə təkəren atan anan 'am a anan. A jan atan kutok, a wa: «Nen Wan su Ɗo nà, ti varan nen à alay inde anà ɗo sə daliyugo ahay, aday ɗo ataya ti vaɗ nen à məke. Pə dəɓa anahan a wa, ni i slabakay ahay à məke wa pə luvon maakan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Əna njavar anahan ataya tə sənak nga sa 'am anahan a sa jan atan ata bay, aday ɗukwen zlawan a gan atan sə cəce panan 'am anahan ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Natiya awan, atə Yesu tə njavar anahan ataya tə dəzle à Kafarnahum kutok. Ta zla ù doh a Yesu sə njahay uda ata nà, Yesu a cəce patan wa kutok, a wa: «Kə vəɗen ahay awiyaway sa 'am sa ma à cəveɗ wa anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɗəkɗek njavar anahan ataya tə mbəɗahak anan apan bay. Anga abay pə cəveɗ wa ata nà, tə vəɗak ayak apan awiyaway nə pa 'am sa jəka, à wulen a tinen wa nà, waya məduwen a sə zalay ɗo anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Coy Yesu awan a njahay, aday a ngaman ayak anà njavar anahan a kuro nga cew ataya pə cakay anahan awan, a jan atan, a wa: «A nan à ɗowan a sə təra ɗo mama'am a nà, â təra anan nga anahan nà, ɗo mədakwidok awan, â gan mer su way à ɗo ahay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A ngaman ayak anà wan cəɗew awan, a tavay anan à mamasl pa 'am a tinen, a ban anan həmbok. A jan anà njavar anahan ataya kutok, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Kuwaya kà sak a təma jəba sa wan kawa həna anan ataya kərtek a anga sləmay uno nà, ɗowan ata a təma nə nen awan. Aday ɗowan a kə̀ təmahak nen ite nà, a təma nà, nen a taayak sabay. A təma nə Mbərom, ɗo sə slənay ahay nen ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhana a jan anà Yesu kutok, a wa: «Miter, ma tak anan à nga anà ɗowan a inde winen apan i razl apasay lelibay aya à ɗo ahay wa tə sləmay anak. Əna mə gafak anan 'am, anga winen ɗo a mənuko bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Cəna, Yesu a mbəɗahan apan, a wa: «Kə̂ gifen anan 'am bay. Anga kuwaya kà gak masuwayan sə way tə sləmay uno nà, pə dəɓa i mba apan sa ja upo 'am lelibay a kwayan'a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ɗo aday a nak uko iɗe bay ata nə, winen nə ɗo a mənuko asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya kə̀ varak ikwen a'am sa sa mənjœk anga kwanay ɗo ana Almasihu ahay nà, i təma magwagway anahan tə ɗiɗem awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Natiya, Yesu a ja asa, a wa: «Kak ɗo kà vak atan saray pə cəveɗ anà ɗo cəɗew anaya sa ɗaf upo nga ata nà, suwan pə winen tə̂ ɓanan van à dungo, aday tə̂ larak anan ayak à bəlay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kak alay anak i sapat iken ì ines inde nà, gaɗ anan. Suwan sa zla à bahay inde pə cakay a Mbərom iken ma gaɗ alay awan, tə winen aday ki i zla à məke sə mərda inde, man aday uko a mbacay itəbay ata tə alay aya cew nà, na.  ");
INSERT INTO mqbNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","À man ata nà, mətunay ahay ta mac bay, uko ɗukwen a mbacay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kabay, kak saray anak i sapat iken ì ines inde nà, gaɗ anan. Suwan sa zla à bahay inde pə cakay a Mbərom tə saray anak slangalan a, tə winen aday ki i zla à məke sə mərda inde saray anak ahay səndaɓ cew nà, na.  ");
INSERT INTO mqbNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","À man ata nà, mətunay ahay ta mac bay, uko ɗukwen a mbacay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Matanan re, kak iɗe anak i sapat iken sa ga ines nà, ndaha anan. Suwan sa zla à bahay inde pə cakay a Mbərom tə iɗe anak a kərtek mbiyan'a, ta sa zla à məke sə mərda inde, tə iɗe anak aya cew maya nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","À man ata nà, mətunay ahay ta mac bay, uko ɗukwen a mbacay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Tə ɗiɗem a nà, azanan nə kuwaya i təra lele, kawa sluweɗ ma ga zətene awan, anga ɗəce i guce ines a tinen ahay, kawa uko sə guce ruhom pə rəslom wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zətene awan aday nà, way lele awan, əna kak zətene awan a vaɗ sabay kəma, ki ma anan apan avaɗ anahan a nə ta maw? Bugol bay, təren aɗəka nà, ɗo ma ga zətene ma vaɗ aya awan. Kwanay a fok, njihen zay tə kuwaya.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A mbəsak Kafarnahum kutok, a slabak, a zla way anahan tə daliyugo sə Yahudiya. A takas zlinder sə Urdon. À man ata awan, ɗo ahay tə halan nga pə cakay asa, aday Yesu a tətakan atan anan way kawa anahan sa taa ga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Azar sə Farisa ahay ta nay ahay pə cakay anahan. Tə cəce panan way, anga a nan atan abay sa ban anan pə kwande. Ta wa: «Tawrita kə̀ varak anan cəveɗ anà mungol sa razl anan uwar anahan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu a mbəɗahan atan apan, a wa: «Musa a jak ikwen nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tinen tə mbəɗahan apan, ta wa: «Musa a ja nà, ki vinde ɗerewel à alay inde anà uwar aday sa razl anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu a jan atan asa, a wa: «Anga akuray nga a kwanay a kə̀ zalak, Musa a saa varak ikwen cəveɗ sə vinde ɗerewel nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cəkəbay, à dəlen anahan a inde ɗukwen nà, matanan bay. “Mbərom a ndakay ɗo nà, mungol tə uwar. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Anga nan, ɗo mungol a i mbəsak anan bəbay anahan tə may anahan, i həɗek pə cakay ana uwar anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cew maya a tinen a ti təra nà, zek kərtektəkke coy.” Ti naa təra kula inde zek cew sabay. Ti təra zek kərtek sə coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Anga nan kutok, way a Mbərom sə japay anan ata nà, ɗowan â sa gəzla anan kula bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ta zla ù doh tə njavar anahan ahay nà, tə cəce panan 'am ata taayak maza asa. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu a mbəɗahan atan apan, a wa: «Kak ɗowan kə̀ rəzlak anan uwar anahan, aday kə̀ gəɓak uda uwar hinen, ɗowan ata kà gak mədigweɗ pə uwar a mama'am ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Matana awan, kak uwar kə̀ mbakak anan mbaz anahan, aday ɗo hinen kə̀ gəɓak anan ite nà, uwar ata kà gak mədigweɗ cite re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Natiya, pə dəɓa anahan a wa kutok nà, ɗo ahay ta nan anan ahay gwaslay cacəɗew aya anà Yesu, anga aday â ɗaf patan alay sə ngama. Əna njavar anahan ahay ta ca apan ɗo ahay tinen apan ti nay anan ahay gwaslay ahay ata nà, ta ma nga sə gafan 'am anà ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu a canan cəna, a ga mivel pə njavar anahan ahay, a jan atan, a wa: «Mbəsiken anan ahay gwaslay ahay, kə̂ gifen atan 'am sa nay ahay pə cakay uno bay, anga bahay a Mbərom mə lavay zek a aɗəka nà, anà ɗo sa ga minje tə tinen anaya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya kə̀ təmahak Mbərom bahay anahan kawa wan cəɗew bay nà, Mbərom i ga apan bahay kula itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Coy, a ra atan, a ban atan pi zek həmbok, a ɗəfan atan alay pa nga, a gan atan amboh. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu a ban cəveɗ anahan sa zla way anahan. Ɗowan inde a haway apan ahahaw. A dukwen gərmec ù vo anà Yesu, a cəce panan: «Miter lele a anan, ni ga nə ma aday ni saa njaɗ sifa sa ndav bay ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu a mbəɗahan apan: «Ka wa nen lele a nà, angamaw? Ɗowan inde lele ibay, si Mbərom a kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ka san nga sa 'am a Mbərom mə baslay aya zle asanaw? Kâ vaɗ nga su ɗo bay, kâ ga mədigweɗ bay, kâ ga akar bay, kâ gaɗ mungwalay pu ɗo bay, kâ ran mindel ù ɗo bay, ɗəfan apan anà atə bəbay anak tə may anak.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɗowan a zlile ata a wa: «Miter, 'am ataya fok nà, nə bənak atan lele, kwa à alay a nen cəɗew a mba.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu a zəzor anan lele, a pəlay anan cəveɗabay. A jan, a wa: «Wita nà, a mbakak way kərtektəkke. Zla, sukom anan way tə way anak ahay fok, aday varan anan dala awan anà ɗo mətawak aya awan. Matanan kutok, ki i njaɗ zlile anak à mburom. Aday hayak, pəruho azar.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A sləne 'am ataya cəna a tacay pə iɗe sərat, a cəɓan, a zla way anahan, anga winen zlile awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu a ca pə ɗo ahay tə iɗe tuwwe, a jan anà njavar anahan ahay, a wa: «Wuna! Ma dan 'am awan anà ɗo zlile awan sa zla à bahay a Mbərom inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Am ata nà, a gan anà njavar a Yesu ahay wadan wadan. Əna Yesu a jan atan asa, a wa: «Dəna uno ahay, ma da 'am a sa zla à bahay a Mbərom inde! ");
INSERT INTO mqbNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kə sənen apan zle, zlugweme i ndərmaɗ tə məke sə ləpəre nà, i ga zek bay. Əna ma da 'am a sə zalay way ata nà, ɗo sə zlile sa zla à bahay a Mbərom inde ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A gan atan masuwayan bayak a asa, tə cəce pi zek ahay wa: «Kak sə matanan cukutok nə, waya saa mba apan saa tam aday sa zla à bahay a Mbərom inde anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu a zəzor atan asa, a wa: «Pu ɗo zənzen a nà, i ga zek kula bay, əna pə Mbərom nə a ga zek ca. Anga pə Mbərom nà, way ahay fok a ga zek.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyer a dazlan sa jan kutok, a wa: «Manay həna nà, mə mbəsakak anan way a manay ahay fok sə pərahak azar biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu a jan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya kə̀ mbakak doh anahan, kabay mərak anahan ahay, kabay may anahan, kabay bəbay anahan, kabay gwaslay anahan ahay, kabay guvo anahan ahay, anga nen aday anga ləbara uno a mugom a nà, ");
INSERT INTO mqbNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i i njaɗ anan uda saray səkat həna à anjahay anahan pə daliyugo a anan inde: doh ahay, mərak ahay, may ahay, gwaslay ahay, guvo ahay à yime inde, pi zek tə ajugwar 'am sə daliyugo a təke fok. Aday pə uho saa nay ata ɗukwen, i njaɗ sifa sa ndav bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Anga aday kutok nà, ɗo sa lah pa 'am həna ataya bayak a ti i təra ɗo mə dədəɓa aya cite asa. Aday ɗo sə dəɓa ahay bayan a, azanan ti i təra ɗo ma lah aya ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Atə Yesu tə njavar anahan ahay, tinen pə cəveɗ ti zla à Urəsalima. Yesu, winen a nà, pa 'am, ɗo azar a nə pə dəɓa. Njavar anahan ahay tinen apan ti jəjar, aday zlawan a gan à man su ɗo sə pərahan atan azar ataya re. Natiya, Yesu a ngaman à njavar a kuro nga anahan a cew ataya taayak, a jan atan way saa təra apan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A wa: «Sənen anan həna, mənuko apan ɗi zla à Urəsalima. À man ata awan, ti varan nen, Wan su Ɗo, à alay inde anà bahay sə gəɗan dungo anà way ahay anga Mbərom, aday anà miter sə Tawrita ahay. Ti go sariya aday sa vaɗ nen, ti varan nen à alay inde anà ɗo sə pəra ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tinen ite ti mbasay upo, ti cəre upo məne, ti ndaɓay nen, ti vaɗ nen kutok. Pə dəɓa a wa nà, ni i slabakay ahay à məke wa pə luvon maakan anahan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A njahay pə dəɓa wa mənjœk nà, atə Yakuba tə Yuhana, wan ana Zebede ahay, tə həɗəken ayak pə cakay ana Yesu. Ta jan, ta wa: «Miter, way inde a nan umo mi cəce aday ki gan umo anan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu a cəce patan wa: «A nak ikwen na ga anga kwanay həna nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tə mbəɗahan apan: «Ka sak a njahay à man sə bahay anak inde azanan nà, a nan umo nə, ɗaf manay, ɗo kərtek a à alay puway anak inde, ɗo hinen ɗukwen à alay gula anak inde ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu a jan atan: «Kə sənen way a kwanay a sə cəce ata bay jiya awan. Ki mben apan sa sa məndolor sə ɗəce uno sa saa sa ɗaw? Ki təmihen sa ga baptisma kawa anuno saa ga ata ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tə mbəɗahan apan, ta wa: «Ha, mi mba apan!» Yesu a wa: «Tə ɗiɗem awan, ki i sen məndolor sə ɗəce kawa anuno saa sa, ki i gen baptisma kawa anuno saa ga. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Əna anjahay à alay puway uno, kabay à alay gula uno nà, nen saa var apan cəveɗ a bay. Man ataya mə lavay zek aya nà, anà ɗo a Mbərom sə walay atan saa njahay apan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Njavar a Yesu a azar ataya kuro tə sləne ləbara ana atə Yakuba tə Yuhana cəna, ta ma nga sa ga patan mivel. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Anga nan, Yesu a ngaman atan ayak fok pə cakay anahan awan, a jan atan, a wa: «Kə sənen zle, ɗo ahay ta ca pa nga a tinen kawa bahay sə daliyugo ahay ata nà, tinen ti ga bahay pə ɗo ahay nə tə məgala. Ɗo sə lavan nga anà ɗo ahay ɗukwen, tinen ta ka anan nə məgala a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Cəkəbay, à wulen a kwanay nà, way ataya tə̂ təra itəbay. Aɗəka bay, a nan anà ɗowan a sə təra ɗo məduwen a cəna, â gan mer su way anà ɗo azar aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aday, kak ɗo a kwanay a kərtek a a nan sə təra ɗo mama'am a cəna, â təra ɓile sə ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Anga nen Wan su Ɗo na nay ahay nà, aday ɗo ahay tû go mer su way bay, əna na nay ahay aday sa gan mer su way anà ɗo ahay aɗəka, ni var anan sifa uno saa bəmbaɗay anan ahay man sə ɗo ahay à amac wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pə dəɓa anahan a wa, Yesu tə njavar anahan ahay tə dəzle à Yeriko nà, ta zla à wulen su doh ata wa tu ɗo ahay bayak tə pərahak atan azar. Tinen apan ti zla kutok, ɗowan inde hurof awan, winen mə njahay a sə dubok way pə cakay cəveɗ. Ɗowan ata nà, tə ngaman Bartime, wan a Time. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A sləne Yesu sə Nazaratu winen apan i zla ta man ata cəna, a dazlan sa zlah, a wa: «Yesu, wan ana Dawuda, amboh! Nâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɗo ahay bayak a tə gafan 'am, ta jan nà: «Tacay 'am! Njahay tete.» Əna ɗowan ata a ngam sə təma 'am a tinen ata bay jiya awan. A ma nga sə zakay anan sa zlah tə məgalak aɗəka, a wa: «Wan ana Dawuda, amboh! Nâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu a sləne cəna, a tavay jek, a jan anà njavar anahan ahay nà: «Ənga, ngimen anan ayak â nay à man uno awan.» Tə ngamàn à ɗowan ata kutok, ta jan: «Slabak! Kə̂ jəjar bay. Ban mivel. Winen apan i ngamak aɗəka!» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ɗowan ata a slabak hərom, gem larak ayak gwedere anahan pi zek wa, a nay pə cakay a Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Coy Yesu a cəce panan, a wa: «A nak nâ gak nə maw?» Ɗowan a hurof ata a mbəɗahan apan kutok, a wa: «Amboh, Miter. Ni gan may nà, təɓo anan iɗe uno ite.» ");
INSERT INTO mqbNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu a jan: «Ki mba apan sa zla way anak. Anga kə ɗəfak upo nga, kə mbərak.» Cəna iɗe anahan a təɓa ngurret, a canan iɗe zle lele. A pərahan azar anà Yesu, aday ta zla pi zek jiya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Atə Yesu tə njavar anahan ahay tə dəzle bəse tə Urəsalima, defefe tə wulen su doh sə Baytifaji tə Baytiniya, pə cakay ana culok sə ngaman Ulivet ata nà, a slan njavar anahan ahay cew, ");
INSERT INTO mqbNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ta sa jan atan, a wa: «Zlen à wulen su doh a tiya pa 'am a kwanay ata awan. Kə dəzlen à man ata nà, ki ten anan à nga anà wan sə zungo a inde ma ɓan awan, aday ɗowan kə̀ jənak apan kula bay re. Natiya, pəsiken anan ahay, aday hayak ikwen anan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kak ɗowan kə̀ cəcihek pikwen wa, kà jak ikwen: “Ki i gen anan maw?” nà, mbəɗihen anan apan nə: “Bahay a gan may. I may anan ahay həniniye.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta zla kutok. Tə dəzle cəna, tə njaɗak anan ayak wan sə zungo ata ma ɓan a pə gərveɗ sə məsudoh a inde. Tə dazlan sə pəsak anan cəna, ");
INSERT INTO mqbNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ɗo mə tavay aya inde à man ata tə cəce pə njavar a Yesu ataya wa: «Kə pəsiken anan wan sə zungo a nà, ki gen anan maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Njavar a ataya tə mbəɗahan atan apan kawa ana Yesu sə təkəren atan ata awan. Tə dazlan sə mbəsak atan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta nan anan ahay zungo ata anà Yesu kutok, tə wadaɗ apan zana a tinen ahay. Yesu a njahay apan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yesu winen apan i zla nà, ɗo ahay tə ɓəɓot zana a tinen ahay pə cəveɗ ite, aday ɗo a azar aya tə ngərway ahay alay si sé ahay à guvo wa, tə ɓəɓot cite. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɗo sə lahan pa 'am anà Yesu ataya, tatə ɗo sə dəɓa ahay fok ta zlah, ta wa: «Həren anan nga anà Mbərom! Mbərom â ɗaf alay sə mazlaɓ anahan pu ɗo saa nay tə sləmay anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mbərom â ɗaf alay sə mazlaɓ anahan pə bahay ana Dawuda, bije ana mənuko, bahay anahan saa nay ata awan. Həren anan nga anà Mbərom à bagəbaga mburom!» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Coy, aday Yesu a dəzle à Urəsalima kutok, a zla ù doh sə mazlaɓ a Mbərom. A ca iɗe tuwwe pə way ahay fok nà, a zla way anahan à Baytiniya tə njavar anahan a kuro nga cew ataya, anga suko kà gak kə̀ zalak. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sidew a kutok, tinen apan ti nay ahay à Baytiniya wa nà, may a han pə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A canan ayak à buway pa 'am a tinen dəren mba nà, a ga apan ɗukwen wan i ga inde, anga winen tə daslam a lele. A həɗəken ayak pə cakay lele, a zlan ayak ù vo nà, a njaɗ apan nə daslam a ɗəkɗek, anga aday ɗukwen alay sə wahay wan ana buway bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu a jan 'am anà buway kawa anà ɗo, a wa: «Ɗowan â saa tukom wan anak kula sabay!» Njavar anahan ahay ɗukwen tə slənek 'am ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tə dəzle à Urəsalima maza nà, Yesu a zla ù doh sə mazlaɓ a Mbərom. À man ata nà, ɗo sə sukom anan way tə way ahay inde, pi zek tə ɗo sə sukom way ahay fok. Cəna, a ma nga sə ɓəlay atan ahay uho. A fakay anan tabal su ɗo sə bəmbaɗ dala ahay, pi zek ta man sə njahay su ɗo sə sukom anan way tə kurkudok ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A gafan 'am anà ɗo ahay sə takasay anan gala su doh sə mazlaɓ a Mbərom tə way a pa nga. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aday a tətakan atan anan way ta sa jan atan, a wa: «Mə vinde a à Deftere a Mbərom inde biɗaw: “Ti ngaman anà doh sə mazlaɓ uno nà, doh sa ga amboh su ɗo su kon ahay kəzlek.” Aday kwanay kə təren anan həna, lar su ɗo sə ngəzar ɗo ahay a nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bahay sə gəɗan dungo anà way ahay anga Mbərom, tə miter sə Tawrita ahay, tə sləne 'am ata cəna, ta ma nga sə pəlay wurwer sa vaɗ anan wa Yesu. Tə jəjaran à man su ɗo awan, anga azar su ɗo a nà, atətak way a Yesu a zlan atan nga. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Luvon a ga cəna, atə Yesu tə njavar anahan ahay ta zla way a tinen à Urəsalima wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sə duwdew, atə Yesu tinen apan ti zla way a tinen, tə canan anà buway ata, kə̀ kurak sokokkwa tə sləlay a təke. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A man ahay à nga inde anà Piyer, a jan anà Yesu: «Miter, ca pə buway a anan, iken sə tahasl anan ata, kə̀ kurak sokok fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu a mbəɗahan atan apan, a wa: «Sənen a kutok, ɗəfen nga pə Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo kà sak a jan à ɓəzlom a anan: “Slabak à man a anan wa, zla à bəlay inde” nà, aday kə̀ jəjarak bay, kə̀ guɗicek bay, kə̀ ɗəfak apan nga cəna, i təran kawa anahan sa ɗaf apan nga ata acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anga nan, nen apan ni jak ikwen, kə cəcihen way à amboh a kwanay inde nà, ɗəfen apan nga. Ki njiɗen anan coy, aday i tərak ikwen acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kak kə tiven sa ga amboh coy, aday way kà mak ikwen ahay à nga inde, way inde a cəɓak ikwen pu ɗo nà, pəsen anan anan, anga aday Bəbay a kwanay winen à bagəbaga mburom ata â pəsak ikwen anan ines a kwanay ahay re.  ");
INSERT INTO mqbNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Əna aday, kak kə pəsen anan anan ines a mərak a kwanay ahay bay nà, Bəbay a kwanay winen à bagəbaga mburom ɗukwen i pəsek ikwen anan ines ahay bay ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ta may ahay à Urəsalima kutok. Yesu a zla sa bar ù doh sə mazlaɓ a Mbərom nà, bahay sə gəɗan dungo anà way ahay anga Mbərom, pi zek tə məceɗ sə Yahuda ahay tə həɗəken ayak pə cakay anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tə cəce panan: «Ka ga way anak a anan ataya nə tə məgala ana wayaw? Sə varak cəveɗ sa ga kətanan nà, waya kərtek anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu a mbəɗahan atan apan: «Nen ɗukwen ni cəce pikwen wa way kərtek. Kə̂ mbəɗihen uno apan aday. Ata nen ni jak ikwen ite, na ga way a anaya tə məgala a wayaw nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sə slənay anan ahay Yuhana sa gan baptisma anà ɗo ahay nə wayaw? Mbərom ɗaw, kabay ɗo zənzen a ɗaw? Mbəɗihen uno ahay apan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tinen ite, tə mbəɗa 'am pi zek a tinen awan, ta wa: «Ɗi jan həna nà, kəkəmaw? Kak ɗa sak a jəka, Mbərom sə slənay anan ahay nà, i jak uko asa: “Kak kə sənen apan zle cukutok nà, kə ɗəfen apan nga bay nə angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aday kak ɗa sak a jəka, ɗo zənzen a sə slənay anan ahay nà, ata guko ngatay!» Tə jəjar ta man su ɗo awan, anga ɗo ahay fok ta ca pə Yuhana nà, kawa ɗo maja'am a Mbərom acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Anga nan kutok, tə mbəɗahan apan anà Yesu, ta wa: «Ma san bay!» Yesu a wa: «Kak sə matanan cukutok ata nà, nen ɗukwen ni ɗakak ikwen anan ɗowan a sə vuro məgala sa ga mer su way anaya bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu a dazlan sa jan 'am tə jike anà ɗo ahay, a wa: «Ɗowan a inde a jule təroz à guvo. A ga apan jal, a ɗaf uda kuɗom məduwen a sa zlaɓ uda wan si sé. A ɗezl uda lagaɗ zəbor awan anga ɗo sa ba anan guvo ata awan. A mbakan anan guvo à alay inde anà ɗo si mer su way ahay, a zla way anahan à man dəren awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Alay a a sla kutok, ɗo ahay tinen apan ti ban təroz nà, bahay sə guvo a slənay ahay ɗo saa təmahan anan ayak mbala anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɗo sə guvo ahay tə canan anà ɗo maslan ata cəna, ta ban anan, ta ndazl anan leɗəɗɗe. Tə mbəsak anan, a zla agay alay kəray awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bahay sə guvo a slənay ahay ɗo maslan maza awan. Ta ban anan, ta gan mbəlak pa nga, tə walay panan agənah pəleslesle. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bahay sə guvo a slənay njavar maza asa re. A saa dəzle pə winen kutok nà, ta vaɗ anan bəskol. Matanan, bahay sə guvo kə̀ slənak ɗo ahay nə bayak awan. Ta ndazl anan ɗo hinen ahay, aday ta vaɗ atan azar aya nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«A mbakan anà bahay sə guvo nà, wan si zek anahan awan kərtektəkke, aday wan ata ɗukwen ləliwe anahan awan. A slənay anan pə cakay su ɗo si mer su way anahan ahay à guvo anahan ata awan. A jalay nà: “Anga wan si zek uno ɗəgerger nà, ti ɗəfan apan ite.” ");
INSERT INTO mqbNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Cəkəbay ɗo sa ga mer ahay ta ja à wulen a tinen inde, ta wa: “Sa naa pa 'am sə guvo a aɗəka nə winen awan. Bənuko anan, vəɗuko anan. Ata guvo a anan i təra a mənuko.” ");
INSERT INTO mqbNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta ban anan, ta vaɗ anan acəkan. Tə laray anan məsinde awan à guvo wa əgem.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu a cəce: «Bahay sə guvo ata nà, i ga nə maw? Tə ɗiɗem a nə, i may ahay agay, i lize anan ɗo sa ga mer à guvo anahan ataya fok. Aday i varan anan guvo ata anà ɗo maza aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kəmaya! Kə jingen 'am ana Deftere a Mbərom a anan itəbay kələɗaw? Deftere a wa: “Kon mbala ana ɗo sa ɗezl way ahay sa lar anan ata nà, sə təra kon sə mide lele aɗəka nà, winen. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sa ga way ata ɗukwen, zek ana Mbərom Fetek awan. Way ata a gak uko masuwayan pə iɗe.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ɗo sə njahan pa 'am wa anà Yahuda ahay tə sləne 'am ataya, tə pəlay cəveɗ saa ban anan, anga ta san zle Yesu a ja jike sa 'am ata nà, pə tinen. Əna tə jəjaran anà ɗo ahay. Anga nan re, tə mbəsak anan Yesu, ta zla way a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta slan ɗo ahay à wulen sə Farisa ahay wa, tu ɗo ana Hiridus ahay, aday ta saa ban anan Yesu à ɓalay sa 'am anahan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ta jan, ta wa: «Miter, ma san zle, iken nə ɗo ɗiɗem awan. Kə jəjaran anà 'am sə ɗo ahay bay, kə zəzor way sə wuteɗ iɗe itəbay re. Kə ɗakay anan cəveɗ a Mbərom ɗukwen tə ɗiɗem awan kawa anahan sa ja. Həna nà, ɗakan umo anan. Cəveɗ inde sə varan jangal anà bahay sə Ruma ɗaw? Bəzi mə̂ varan bay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu a san pə mbaɗəmbaɗa a tinen a zle. A jan atan: «Ki ngen upo ɓalay angamaw? Viren uno ahay karanga, na ca apan aday.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tə varan ahay karanga awan. A cəce patan wa: «Pə karanga a anan nà, mezeze a wayaw, aday mə vinde apan nà, sləmay a wayaw?» Tə mbəɗahan apan, ta wa: «Wita nà, mezeze tə sləmay ana bahay sə Ruma.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu a jan atan, a wa: «Lele, kak matanan cukutok nà, viren anan anan way ana bahay sə Ruma anà bahay sə Ruma, aday way a Mbərom anà Mbərom a ite.» Anahan sə mbəɗa apan kətanan ata, a gan atan masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Azar su ɗo aya inde, tinen Saduki ahay, ta nay ahay pə cakay a Yesu sə cəce panan 'am. Tinen a aday nà, ta wa ɗo kə̀ məcak nə i slabakay ahay sabay. Tə cəce 'am a anan pə Yesu wa, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Miter, Musa kə̀ vindek umo, a wa: “Ɗo kə̀ məcak aday kə̀ mbəsakak uwar mənjəna wan nà, mərak a məsinde â gəɓa anan mədukway sə uwar awan aday ti wahan məgije anà ɗowan a ma mac ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Matanan, ɗowan aya inde cuwɓe, tinen tə mərak ahay. Ɗo zek məduwen awan, a gəɓa uwar, a mac mənjəna sa njaɗ panan wan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɗo sa mban apan a həɗek anan uwar ata mədukway awan. Winen ite a mac mənjəna wan re. Ɗo mə slala maakan awan a həɗek anan uwar ata ite re. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hus a dukoy pu ɗo tə bahay cuwɓe awan kutok, kə̀ məcak re. Aday uwar ata ɗukwen kə̀ məcak re. Tə mbəsakak wan uho kwa kərtek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aday həna azanan kutok nà, pə luvon saa slabakay ahay à məke wa ata nà, uwar ata i təra nə uwar a wayaw? Bina cuwɓe a tinen a, tə gəɓak anan pa sə uwar a re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu a mbəɗahan atan apan, a wa: «Kwanay apan ki zluwen à cəveɗ wa, anga kə sənen Deftere a Mbərom bay, kə sənen məgala ana Mbərom bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɗo ahay ti slabakay à məke wa nà, kwa ɗo mungol aya awan, kwa ɗo uwar aya ɗukwen, ti i gəɓa zek ahay sabay fok. Anga ti i təra à mburom nà, kawa maslay a Mbərom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Əna aday, 'am sə slabakay ana ɗo ma mac aya à məke wa nà, kə jingen Deftere a Mbərom kula itəbay ɗaw? Mbərom a jan ahay anà Musa, ù uko sə vəragaz wa nə: “Nen Mbərom ana Ibərahima, Mbərom ana Isiyaku, aday Mbərom ana Yakob” ba? ");
INSERT INTO mqbNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mbərom, winen nà, Mbərom su ɗo ma mac aya bay, əna winen Mbərom su ɗo tə sifa aya awan. Anga nan kə zluwen à cəveɗ wa aɗəka bugol.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Əna, miter sə Tawrita inde à man ata awan, kə̀ slənek avaɗ uway sa 'am a tinen ata awan. A ca pə Yesu sə mbəɗahan apan anà Saduki ahay ata lele. A nay, a cəce panan, a wa: «Nga sa 'am mə baslay aya fok nà, wura məduwen a aday a zalay azar aya anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu a mbəɗahan apan: «Sə təra mama'am sa nga sa 'am mə baslay a nà: “Iken Isəra'ila, pak sləmay. Mbərom Fetek, Bahay a mənuko, winen kərtek bahay awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pəlay anan Mbərom Fetek, Bahay anak, tə mivel anak a təke, tə apasay anak a təke, tə abayak nga anak a təke, aday tə məgala anak a təke.” ");
INSERT INTO mqbNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nga sa 'am mə baslay a tə bahay cew a nə həna: “Pəlay anan ɗo sə cakay su doh anak kawa iken sə pəlay anan nga anak ata awan.” Nga sa 'am inde mə baslay awan saa zalay həna anaya nà, ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Miter sə Tawrita ata a jan, a wa: «Acəkan, miter, ka jak ɗiɗek. Mbərom nə kərtek. Mbərom maza sa ga anan minje nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Anga nan, lele nà, ɗo zənzen i pəlay anan Mbərom nə tə mivel anahan a təke, tə abayak nga anahan a təke, aday tə məgala anahan a təke. Aday i pəlay anan ɗo sə cakay su doh anahan kawa winen sə pəlay anan nga anahan ata awan. Sə təma sə ɗəfan apan anà 'am a anaya ɗukwen, a zalay way ma tak aya awan, tatə way mə waslay aya sə varan à Mbərom ataya fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu a ca apan nə ɗowan ata kə̀ mbəɗahak apan lele tə mərike awan. A jan, a wa: «Iken dəren tə bahay a Mbərom a bay!» Pə dəɓa wa nà, kuwaya a jəjar sə cəce panan 'am maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pə dəɓa wa, Yesu winen apan i tətakan anan way anà ɗo ahay ù doh sə mazlaɓ a Mbərom nà, a cəce, a wa: «Kəkəma aday miter sə Tawrita ahay ta jəka, Almasihu nà, wan ana Dawuda anaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawuda ta nga anahan awan a ja tə məgala sə Apasay Cəncan awan, a wa: “Mbərom Fetek a jan anà Bahay uno, a wa: Njahay à day sə alay puway uno, aday ni nahay anan ɗo sa nak iɗe ahay, ki ján patan tə saray.” ");
INSERT INTO mqbNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Kak Dawuda a ngaman anà Almasihu nə “Bahay uno” bugol nà, winen i saa təra wan ana Dawuda nə, kəkəma asanaw?» Ɗo ahay bayak a tə sləne 'am a Yesu ata tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","À atətak way anahan ataya inde nà, a jan atan, a wa: «Bənen nga a kwanay pə Miter sə Tawrita ahay wa, anga a nan atan sa bar nà, tə rəkot aya awan, aday ɗukwen ta gan may nà, ɗo ahay ta jan atan 'am à kwasuko nà, tə akərdeh aya awan, à wulen sə ɗo ahay inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tinen ù doh sə wazay ahay cəna, ta ca wa ɗukwen man zəbor aya awan. Ta zlak à man sa pa way nà, tə pəlay man sə njahay lele aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tinen apan ti ran mindel anà mədukway sə uwar ahay. Ti ngəzar patan wa doh a tinen ahay. Ɗukwen, pə iɗe su ɗo ahay nà, tə zədeh amboh nə kawa ɗo lele aya awan. Ɗo matanan ataya nə, sariya a tinen a nà, ma da 'am awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pə dəɓa anahan a wa kutok, Yesu a njahay à man sə ɗo ahay sə pəkak ayak way à kukwar sə dala ù doh sə mazlaɓ a Mbərom ata awan. Winen apan i ca pu ɗo sə pəkak ayak dala ataya awan. Ɗo sə zlile ahay tə pəkak ayak dala bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Coy, mədukway sə uwar a inde aday mətawak awan, a zlak ayak ite. A gucek ayak uda dala sərɗəɗe aya cew, kawa sa ja nà, dala bayak a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Anga nan, Yesu a ngaman anà njavar anahan ahay, a jan atan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Mədukway sə uwar a mətawak a anan ata kə̀ varak à kukwar sə dala inde nà, zal ɗo ahay a sa pak ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Anga ɗo ahay fok ta var nà, mənjœk pə way a tinen a bayak a ataya wa. Əna mədukway sə uwar a anan ata, kwa â ga nə winen mətawak a dəp nà, kə̀ ndəvak pi zek. Anga a var anan nà, ta sa pa way anahan a təke fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu a nay ù doh sə mazlaɓ a Mbərom ata wa cəna, ɗo kərtek à wulen sə njavar anahan ataya a jan, a wa: «Miter, ca pu kon a anaya awan, aday pə iɗezl anahan aya ite tə rəɓa ike!» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu a mbəɗahan apan: «Kə canan anà way a mi ɗezl a anan ba? Ɗo maniɗe ahay ti mbazl anan. Kon hinen saa ɗinger zek pə hinen nà, ibay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pə dəɓa wa, winen mə njahay a à ɓəzlom sə Ulivet, a mbəɗa 'am pu doh sə mazlaɓ a Mbərom. Piyer, Yakuba, tatə Yuhana tə Andəre nà, tinen taayak a tinen a tatə Yesu. Tə cəce panan, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Jan umo biɗaw? Doh sə mazlaɓ a Mbərom i saa mbazl nə siwaw? Minje sa ma i ga aday mi saa san i təra kutok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu a dazlan sə ɗakan atan anan kutok, a wa: «Liven anan ì zek a kwanay ahay lele, ɗowan â sa njak kwanay bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anga ɗo ahay bayak a ti gəɓa sləmay uno, ti nay, kuwaya i ja winen nə Almasihu. Ti njak anan ɗo ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ka sak a slənen ləbara sə vəram, kwa dəren, kwa bəse, kâ sa jəjiren bay. Anga təktek way ataya ti təra aday. Əna wita kə̀ dəzlek pə andav ana daliyugo fan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kon a anan, i slabak pu kon hinen, bahay a anan i vaɗ zek tə bahay hinen. Daliyugo i ɓal à man ahay cara cara, may i ga matanan re. Ɗəce ataya fok ti təra nə kawa wan sə dəlay anan uwar ti zek cew ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Gen anan nga ì zek à kwanay, anga ti ban kwanay aday ti zla kwanay pa 'am sə sariya ahay. Ti ndəzlay kwanay ù doh sə wazay ahay wa. Anga kwanay njavar uno ahay, ki tiven atan pa 'am ana bahay ahay pi zek tə guverner ahay, aday kî gen side pa 'am a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Anga bəlaray ləbara mugom a â wazay zek pu kon ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kwa siwa siwa tə bənak kwanay sa ga sariya pa 'am a tinen nà, kâ sa jilen sa jəka mi i ja nə maw ata bay. Jen nə 'am a sa nak ikwen ahay à nga inde à alay ata awan. Anga 'am a kwanay a saa ja ata nà, i nay à nga a kwanay wa bay. Saa jak ikwen nə Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mərak ahay ti varan anan mərak a tinen ahay anà ɗo ahay aday tâ vaɗ atan. Bəbay sa wan ahay ti gan anà gwaslay a tinen ahay nà, matanan. Gwaslay ahay ɗukwen, ti slabak pə bəbay a tinen ahay aday ɗo ahay tâ vaɗ atan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɗo ahay fok ti nak ikwen iɗe anga kwanay njavar uno ahay. Əna ɗowan a kə̀ səmak anan hus à andav a inde cəna, winen i tam.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu a ja asa, a wa: «Ki i cinen anan anà səkar sə lize way à man aday təɗe i tavay uda bay ata awan. (Ɗowan a kə̀ jingek anan 'am a anan nà, â sənan anan anà nga anahan nə lele.) À alay ata asanaw nà, ɗo sə Yahudiya ahay tâ haw sa ma nga à ɓəzlom ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɗo aday winen pa nga su doh ɗukwen â dazay, â haw, əna â sa ray ahay way anahan ahay ù doh wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ɗowan a winen à guvo ɗukwen, â saa nay ahay agay sa naa gəɓak ayak zana anahan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wuna, pa pac ataya nà, ɗəce inde anga uwar ti zek cew aya awan, aday anga uwar ta wan a à bak ataya re. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gen anan amboh à Mbərom aday way ataya tâ sa təra à alay sa maɗ bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Anga pə luvon ataya nà, ɗəce i zalay, bina kwa ana Mbərom sə ndakay daliyugo hus ahay biten ɗukwen, ɗəce kawa winen ata kə̀ tərak kula bay, aday inde i təra kula sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Əna, Bahay Mbərom kə̀ kəcak anan luvon ataya bay nà, abay ɗowan saa tam nà, ibay. Əna, kə̀ kəcak anan luvon awan anga ɗo anahan a sə walay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Asa, ɗowan a kà jak ikwen: “Almasihu winen həna” kabay: “Winen tiya” nà, kâ sa ɗəfen apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anga almasihu ahay mungwalay aya bayak a ti nay ahay pi zek tu ɗo sə jəka tinen ɗo maja'am a Mbərom ahay. Ti ga minje sə way ahay, tə masuwayan aya cara cara sa njak anan kwa ɗo mə walay aya awan, abay a ga zek nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kwanay nà, uffa ahak ikwen. Gen anan nga anà zek lele. Na jak ikwen anan kurre nà, anga nan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«À alay a pə dəɓa ana ɗəce ataya wa nà, pac i dav sabay, kiya ɗukwen matanan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mawuzlawazl ahay ti gucey ahay à məndak, aday ɗukwen məgala sə way ahay à mburom ataya, ti ɓal. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ata aday ti canan anà Wan su Ɗo winen apan i may ahay pa nga sə matapasl ahay pa nga mburom tə məgala bayak awan, aday tə mazlaɓ a re. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aday Wan su Ɗo i slənay ahay maslay anahan ahay, ti halan nga anà ɗo anahan a sə walay ataya kwa ta sə wura fok hus pə magaga sə daliyugo.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Sənen pə way ana buway sə ɗakak ikwen anan ata aday. Kə cinen anan anà alay anahan aya ta gak kulɓosloslo nà, daslam aya ɗukwen ta ɗak, ata kə sənen zle coy viya winen apan i slay bəse. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Matanan re, kə cinen anan anà way uno sə ɗakak ikwen anan ataya cəna, sənen a nà, nen Wan su Ɗo, nen apan ni may ahay bəse, nen pə alay sə məsudoh. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nen apan ni jak ikwen tə ɗiɗem a həna: Əlek ɗo sə biten ahay ti i mac nà, way ataya fok ti təra. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Daliyugo i ndav, kərngay i slukwac pə bagəbaga mburom, əna 'am uno nà, i ndav itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Əna, ɗowan saa san luvon sə way ataya nà, ibay. Maslay a Mbərom ahay ta san bay, nen wan anahan a ɗukwen na san bay. Sa san luvon a cəna, si zek a bəbay uno Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gen anan məkəlingesl ì zek a kwanay ahay. Bənen nga a kwanay, anga kə sənen luvon a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Way matanan i təra nà, kawa ɗo saa zla à man dəren awan. A mbəsakan anan doh anahan anà ɗo si mer su way anahan ahay nə kərtek tə kərtek, kuwaya ti mer su way awan. Ɗo sa ba doh ɗukwen, a jan nà: “Ba pu doh!” ");
INSERT INTO mqbNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Anga nan kutok nà, təren ɗo mə lavay zek aya awan! Bahay su doh ata i may nə siwaw nà, kə sənen bay. A ga nə suko, man luvon, alay a njəkar sa zlah, kwa duwdew ɗukwen, alay ataya fok cəna i nay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kà sak a nay, kwanay ma njak ahan aya nə lelibay. ");
INSERT INTO mqbNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kawa anuno sa jak ikwen həna ata nà, ni jan anan anà ɗo ahay fok: Təren ɗo mə lavay zek aya awan!» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A mbəsak luvon ahay cew nà, azar uko sə Pasəka, aday sa pa tapa sə pen mə zlambar a bay ata i sla kutok. Bahay sə gəɗan dungo anà way ahay anga Mbərom, pi zek tə miter sə Tawrita aya awan, a nan atan sa ban anan Yesu tə wurwer, aday sa vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Anga nan ta ja 'am à wulen a tinen ahay inde, ta wa: «Ɗâ sa ban anan à azar uko inde bay, bina ɗo ahay ti sa vəze puko.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yawa, Yesu winen à Baytiniya, àga ɗowan a inde, tə ngaman Simon ɗo mə dugwaɗ awan. Yesu winen apan i pa ɗaf nà, uwar a inde a nay ahay, tə amar sə wurde anahan tə dunguzlok awan à alay inde. Ta da amar ata aday nà, tə nardi. Masa anahan a ɗukwen mənjœk bay. A kaɗ panan 'am awan aday â təɓa, a mbəɗan anan pa nga anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Matanan kutok, way ana uwar ata sa ga ata nà, a cəɓan anà ɗo azar aya bayak awan. Ta ja à wulen a tinen ahay inde, ta wa: «A nes anan amar a anan kəriya həna nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ta wa, abay tə̂ sukom anan way tə amar a anan nà, i zalay dala sə dinar səkat maakan, aday ti var anan dala awan anà ɗo mətawak aya nà, ta gak way lele biɗaw?» Ta ga mivel pə uwar ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kutok, Yesu a jan atan, a wa: «Mbəsiken anan, abay kə bənen anan mbiyeɗ nà, angama kərtek anaw? Way anahan su go ata nə lele. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ɗo mətawak aya nà, ti ga inde tə kwanay hwiya. Kà nak ikwen nà, ki gen atan sumor awan kwa siwa mba asanaw? Əna nen ni ga inde tə kwanay hwiya itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Way abay i mba apan sa ga ata nà, kà gak anan həna kurre anga nen: A lah anan upo amar uno sa zla anan à məke. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nen apan ni jak ikwen tə ɗiɗem a həna: À man aday ɗo ahay ti wazay anan ləbara uno mugom a kwa aha pə daliyugo fok nà, ti təker anan ləbara sə way ana uwar a anan sa ga həna ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Natiya kutok asa, Yudas Iskariyot a zla àga bahay sə gəɗan dungo anà way ahay anga Mbərom, anga aday â gan atan ɗaf pə Yesu. Winen a aday nà, ɗo kərtek à wulen su ɗo maslan a Yesu ahay kuro nga cew ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tə sləne 'am anahan a cəna, tə taslay mivel bayak a tə Yudas, tə zlapay sə haman dala. A bənay pə winen ata wa kutok cəna, Yudas a pəlan atan cəveɗ sə varan atan anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Natiya asa, à luvon mama'am sə azar uko sa pa tapa sə pen mə zlambar a bay ata, aday à pac sə waslay wan sə təman sə Pasəka ata inde, njavar a Yesu ataya ta jan: «A nak mâ sa lavay anan zek tə way sa pa sə Pasəka ata nà, ahaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","À wulen sə njavar anahan ataya wa nà, Yesu a slan ɗo ahay cew. A jan atan: «Zlen à wulen su doh sə Urəsalima. Ki zlingen tə ɗowan a inde kəlawa pa nga, aday winen apan i may ahay à a'am wa. Pərihen anan azar. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ù doh anahan a saa dəzle uda ata nà, jen anan anà bahay su doh ata nə: “Miter a manay a ja nà: Doh a aday mi i pa uda ɗaf sə azar uko sə Pasəka tə njavar uno ahay ata nà, wuraw?” ");
INSERT INTO mqbNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ata i ɗakak ikwen pə sewene a inde məduwen awan, mə lavay zek a coy. Kə̂ ndiken uko anan uda way ahay fok à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Njavar anahan ataya ta zla. Tə dəzle cəna, ta tan ayak à nga anà way ahay nà, kawa ana Yesu sa jan atan. Tə lavay anan uda zek tə way sa pa sə azar uko sə Pasəka kutok. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Suko a a ga nà, atə Yesu ta nay ahay tu ɗo maslan anahan ahay kuro nga cew. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tinen mə njahay a, ti pa way kutok, Yesu a ja, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan a kərtek à wulen a kwanay inde, mənuko apan ɗi tar alay à tuwez jiga awan həna, i i ga upo ɗaf.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'Am ata a wusen atan nga fok. Tə dazlan sə cəce panan fok a tinen a kərtek kərtek: «Nen bay ba?» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu a jan atan asa, a wa: «Ɗowan ata nà, à wulen a kwanay a kuro nga cew a anaya awan. Manay apan mi tar alay à tuwez miya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tə ɗiɗem a nà, nen Wan su Ɗo nà, ni mac, kawa ana Deftere a Mbərom sa ja upo ata awan. Əna ɗəce i naa tan à nga anà ɗo saa ga upo ɗaf ata awan. Suwan pə winen maka tə̂ wahay anan bay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Coy, tinen apan ti pa way ata kutok, Yesu a gəɓa tapa sə pen, a ngəran ayak anà Mbərom, a gəzla anan ì zek wa, a varan atan, a wa: «Təmihen. Həna anan nà, zek uno.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pə dəɓa anahan a wa nà, a gəɓa gəsa'am, a ngəran ayak anà Mbərom, aday a varan atan anan gəsa'am ata awan, aday tâ sa wa way juɓjoɓ fok a tinen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A jan atan, a wa: «Həna anan nà, mez uno mə pəkay awan anga ɗo ahay bayak awan. Tə mez uno a anan, Mbərom a ɓan 'am tə ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nen apan ni jak ikwen tə ɗiɗem a həna: I ban pə luvon sə biten a anan wa nà, ni naa sa way kawa həna a anan sabay, si azanaka pə luvon aday ɗi saa sa maza à bahay a Mbərom inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pə dəɓa anahan a wa nà, ta ga ara sə həran nga anà Mbərom, ta zla way a tinen à ɓəzlom sə Ulivet. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu a jan anà njavar anahan ahay, a wa: «Kwanay a fok, ki i hiwen, ki i mbəsiken nen. Anga Deftere ana Mbərom a ja nà: “Ni vaɗ anan ɗo sə jugwar təman awan, aday ɗukwen təman ahay ti ta 'am.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Aday Yesu a zəga anan asa, a wa: «Na sak a slabakay ahay à məke wa nà, ni lahak ikwen à Galile.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyer a mbəɗahan apan, a wa: «Kwa â ga nə ɗo ahay fok ti mbəsak iken dəp nà, nen ni mbəsak iken itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu a jan: «Nen apan ni jak tə ɗiɗem a həna: À luvon a sə biten a anan inde, zukwa njəkar i saa zlah saray cew nà, ka jak saray maakan, ka san nen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyer a ma pa 'am anahan ata maza awan, a wa: «A ga nə ni mac anga iken dəp nà, ni ja kula na san iken bay itəbay!» Fok a tinen a ta ja 'am kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Natiya, atə Yesu tə njavar anahan ahay ta zla à man sə ngaman Gecemene. Tə dəzle à man ata kutok nà, a jan anà njavar anahan ahay: «Njihen à man a anan à alay a nen ni gay ahay amboh.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Winen apan i zla nà, a ngaman anà Piyer, anà Yakuba, aday anà Yuhana, ta zla jiga awan. Zlawan a dazlan sa ban anan, a jəjar pi zek. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A jan atan asa: «Mivel uno i ndəroɓ hus pa sa mac anan. Njihen à man a anan, ben lele.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A zla à man a tinen ata wa mənjœk cəna, a slahay à məndak duboz. A ga amboh aday ɗəce ata â zla panan wa ite, abay â ga zek nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A wa: «Abba, bəbay uno, pə iken nà, way ahay fok ta ga zek. Gəɓa puno ɗəce saa nay upo a anan ata ite. Aya əna, way kawa su no nà, â təra bay, si kawa sa nak iken.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A ma à man ana njavar anahan a maakan ataya nà, a tan atan ahay à nga nə ma njak ahan aya awan. Anga nan a jan anà Piyer: «Simon, iken ma njak ahan a ɗaw? Ka mbak apan sa ba kwa ler kərtek bay asəka? ");
INSERT INTO mqbNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ben lele, gen amboh anga aday kə̂ tiven anan anà way saa njak kwanay ahay. Apasay su ɗo zənzen a nà, a gan may sə ɗəfan apan anà Mbərom, əna zlay si zek anahan a bəle awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu a ma maza asa, a ga amboh kawa anahan sə manakwakwa awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","A may ahay pə cakay ana njavar anahan ataya asa, a tan atan à nga nà, tə njəkak ahan asa, ta mba apan sə təɓa iɗe kwa mənjœk bay jiga awan. Aday ta san sa jan həna nə maw bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A zla, a ga amboh asa, a may ahay tə bahay maakan awan. A jan atan: «Kwanay apan ki men anan uda ɗaw, ɗo sa njak ahan ahay? Coy, alay a kà slak həna kutok, aday ti varan nen Wan su Ɗo à alay inde anà ɗo sə atahasl ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Slabiken, zluko. Ɗo sa ga upo ɗaf winen tiya, kà nak ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu kə̀ ndəvak anan 'am ata fan bay cəna, Yudas, ɗo kərtek à wulen sə njavar anahan aya inde kuro nga cew ata a dəzley ahay. A njahan pa 'am wa anà ɗo ahay bayak a tə way sə alay a hunjəslesle: maslalam a pi zek tə sukol aya re. Sə slənay atan ahay nə bahay sə gəɗan dungo anà way ahay, pi zek tə miter sə Tawrita ahay, aday tə məceɗ sə Yahuda ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas, ɗowan a sa ga ɗaf pə Yesu ata, ɓa kə̀ varak atan minje sə way, a wa: «Ɗowan a ni ban anan həmbok ata nà, winen awan. Bənen anan, aday kî gen anan nga lele, zlen anan kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A dəzlek ayak cəna, a zla pə cakay ana Yesu bəse. A jan 'am: «Miter!» A dazlan a varan alay, a ban anan pi zek həmbok. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Cəna ves, ɗo ahay ta ban anan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ɗo kərtek à wulen su ɗo a Yesu mə tavay a à man ataya, a ndahay maslalam anahan, a car anan ɓile ana bahay nga su ɗo sə gəɗan dungo anà way anga Mbərom, aday maslalam anahan ata a gaɗ panan sləmay kərtek a poc. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu a jan anà ɗo ahay, a wa: «Ki nen upo tə maslalam aya aday tə sukol aya sa ban nen kawa nen ɗo sə ngəzar ɗo à cəveɗ inde ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pac pac nen inde tə kwanay ù doh sə mazlaɓ a Mbərom, nen apan ni tətakan anan way anà ɗo ahay, əna kə bənen nen bay. Əna way a anan a təra həna nà, aday 'am ana ɗo maja'am a Mbərom ahay sa ja upo à Deftere a Mbərom inde ata â təra.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Njavar anahan ahay tə mbəsak anan, ta haw way a tinen fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wan a inde nà, winen apan i pərahan azar anà Yesu. Zana pi zek ɗukwen gwedere kərtektəkke. Tə pəlay abay sa ban anan, ");
INSERT INTO mqbNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","aya əna alay a tinen a dəzle nà, pə zana ata awan. Winen ite a pəsakay anan ahay gwedere ata à zar wa, gədek sa haw zek kəray a gweder gweder. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɗo sa ban anan Yesu ataya ta zla anan àga bahay nga su ɗo sə gəɗan dungo anà way ahay. Bahay sə gəɗan dungo anà way ahay, tə məceɗ sə Urəsalima ahay pi zek tə miter sə Tawrita aya tə halay nga fok a tinen awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyer winen apan i pərahan ayak azar à dəɓa wa à dəɓa wa. A dəzlek ayak à gala ana bahay nga su ɗo sə gəɗan dungo anà way nà, a njahay à wulen su ɗo si mer su way ahay su doh ata awan. Tə njahay pə uko anga alay sa maɗ. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aday nà, bahay sə gəɗan dungo anà way ahay, pi zek tu ɗo sə lavan nga anà Yahuda ahay, fok a tinen a ta ban bitem sə mungwalay ahay aday ti vaɗ anan Yesu à məke. Əna ta njaɗ cəveɗ a bay, ");
INSERT INTO mqbNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","kwa abay ɗo sə mungwalay ahay bayak a tə ndəɓak apan 'am ahay cara cara dəp nà, na. Aday 'am a tinen awan kà zlak atan pi zek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ɗo hinen ahay tə slabak tə mungwalay a tinen ite, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Manay nà, mə slənek a wa: “Doh sə mazlaɓ a Mbərom a ma han a tə alay su ɗo a anan nà, ni mbazl anan, aday nen ni han anan à luvon maakan inde tə alay su ɗo zənzen a sabay.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tə winen ata təke ɗukwen side ata kà zlak atan pi zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bahay nga su ɗo sə gəɗan dungo anà way ahay a slabak à wulen sə ɗo ahay inde, a cəce pi zek à Yesu a wa, a wa: «Kə mbəɗa apan itəbay kələɗaw? Ɗo a anaya fok ta ja apak nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu a njahay way anahan faafa. Kə̀ təɓak anan 'am anahan a bay jiga awan. Bahay nga sə ɗowan ata a mənahan anan asa: «Iken nà, Almasihu, wan a Mbərom mbala ɗo ahay sə həran nga ata ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu a mbəɗahan apan kutok: «Ayaw! Nen nà, winen awan. Kwanay ɗukwen ki cinen anan anà Wan su Ɗo, winen mə njahay a à alay puway ana Mbərom Ba Məgala. Ki cinen anan pə matapasl sa nga mburom, winen apan i may ahay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bahay nga su ɗo sə gəɗan dungo anà way ata a sləne 'am ataya nà, a ngəraw anan zana anahan pi zek wa, a wa: «Həna nà, ɗi gan may anà side hinen re ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kə̀ jənak anan pa 'am a Mbərom. Kə slənen 'am anahan a coy. Ki jen həna nə kəkəmaw?» Fok a tinen ta gan nə sariya sə mac. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɗo azar aya ta ma nga sə təfe apan məne. Tə kərtan way pə iɗe, tə dəcan, aday ta jan: «Jan umo kutok: Sə dəcak nə wayaw?» Ɗo si mer su way ahay ta zla anan, tə dəcan ite. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyer nà, winen à gala hwiya, mə njahay a pə uko. Dəna sa ga mer su way àga bahay nga su ɗo sə gəɗan dungo anà way, a nay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A canan anà Piyer nà, a zəzor anan cəna, a jan: «Iken ɗukwen ɗo ana Yesu sə Nazaratu ata ba?» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piyer a məman anan, a wa: «Nen na san 'am anak ata sa jay həna ata bay.» A slabak, a həɗəkey ahay à məgədengəden uho. Njəkar a zlah kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dəna ata a canan asa cəna, a jan anà ɗo a mə njahay ataya awan, a wa: «Həna anan ɗukwen ɗo a tinen aya kərtek awan.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyer a məman anan asa. A njahay mənjœk asa cəna, ɗo sa man ataya ta jan à Piyer: «Ki mba apan sə məman zek bay! Tə ɗiɗem awan, iken ɗo a tinen, anga iken Galile ahay re.» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piyer a dazlan sə mbaɗay coy: «Kak na san ɗowan ata zle nà, Mbərom a tə alay anahan awan â tahasl nen! Nen na san ɗowan ata bay!» ");
INSERT INTO mqbNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kwayan'a, njəkar a zlah mə slala cew awan. Piyer a sləne cəna, 'am a Yesu a sa jan kurre ata à man à nga inde, a wa: «Njəkar i saa zlah saray cew nà, ka jak saray maakan ka san nen bay.» Səkwelkwele mə tavay awan, a dazlan ayam. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iɗe a cəɗe siwa a cəna, bahay sə gəɗan dungo anà way ahay ta ma anan 'am ì zek tə məceɗ sə Yahuda ahay pi zek tə miter sə Tawrita ahay, tə halay nga tu ɗo sə mbəɗa alay pa 'am azar aya fok. Coy tə jaway anan Yesu, ta zla anan àga Pilatu, guverner sə Yahudiya, winen Ruma ahay. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu a kutok a cəce 'am pə Yesu wa: «Iken nà, bahay sə Yahuda ahay ɗaw?» Yesu a mbəɗahan apan, a wa: «Ka jak anan asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bahay sə gəɗan dungo anà way ahay ta ndaɓ 'am pə Yesu nà, anga way ahay cara cara bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu a cəce panan asa: «Kə mbəɗa apan itəbay ɗaw? Ca pə way aya tinen sa zlah anan apak ata awan!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu ite a ngam sə mbəɗa apan bay fok. Ambəɗa apan bay a Yesu ata a gan masuwayan anà bahay Pilatu. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pə azar uko sə Pasəka fok cəna, bahay a taa mbəsakan atan ahay ɗo kərtek à dangay wa, kawa ana tinen sə cəce fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","À alay ata ite, ɗowan a inde tə ngaman Barabas nà, tinen tə ɗowan aya inde tə vəze pə Ruma ahay à wulen su doh, tə vəɗak uda awan nga su ɗo re. Anga nan, winen à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Natiya kutok, ɗo ahay fok ta zlak ayak, tə cəce kawa ana tinen sa taa ga sə kukwa awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu a cəce patan wa, a wa: «A nak ikwen nə̂ mbəsakak ikwen anan ahay bahay sə Yahuda ahay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Anga a san zle lele, bahay sə gəɗan dungo anà way ahay ta ban anan Yesu nà, anga sərak cərkəke. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Əna bahay sə gəɗan dungo anà way ahay tə pəkan 'am anà man su ɗo ata fok aday tə̂ cəce pə bahay wa nà, Barabas. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu a cəce pə ɗo ahay wa asa: «Aday nâ ga anan tə ɗowan a kwanay sə ngaman bahay sə Yahuda ahay ata nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ta zlah azlazlah, ta wa: «Darak anan ayak pə dədom!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatu a cəce: «A ga mer sa ma lelibay a anaw?» Tə zəga anan sa zlah, ta wa: «Darak anan ayak pə dədom!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu a nan sa ga nà, way sa zlan à nga anà ɗo ahay. Anga nan, a mbəsakan atan anan Barabas. A jan anà suje ahay tə̂ ndaɓay anan Yesu. Aday a varan atan anan, tə̂ daray anan pə dədom. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Suje ahay ta zla anan Yesu à man sə njahay a tinen à gala su doh àga Pilatu. Tə halan nga anà suje ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tə ɗəfan zana ɗəzɗaz a pi zek, kawa sə bahay, tə hanan jugo sə adak, tə ɗəfan à nga inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tə dazlan sa jan 'am kawa ana bahay kutok, ta wa: «Bahay sə Yahuda ahay â ga inde sə coy!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tə dəcan pa nga tə sukol, tə təfe apan məne, tə dukwen gərmec ù vo, tinen mə rihe nga aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ta ndav anan sə mbasay apan nà, tə culok panan zana ata, ta man anan zana anahan pi zek kutok. Ta zla anan saa darak anan ayak pə dədom mə zləlngaɗ awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tinen apan ti zla anan Yesu ata kutok, tə zlangay tə ɗowan a inde tə ngaman Simon, ɗo sə Siren ahay, winen ɗukwen bəbay ata ana Aleksandire tə Rufus. Winen a aday nà, winen apan i may ahay à kiɓe wa. Suje ahay ta gan bəlaray sə tavak dədom ata pə Yesu wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta zla anan tə Yesu pa man sə ngaman Golgota ata, kawa sa ja nà, Kəlakasl-sa-Nga. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","À man ata nà, ɗowan aya inde abay a nan atan sə varan way mə kwasay a mə japay a tə ndəliwen awan, aday â man zek à ɗəce anahan inde. Əne Yesu a ngam bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tə dazlan tə daray anan pə dədom. Tə gəzla anan zana a Yesu, ta ga caca pə zana anahan ata à wulen a tinen ahay inde, aday sa san anan pi zek wa saa njaɗ zana ataya nə wayaw. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tə daray anan Yesu nà, i ga njamde dəsuɗo. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tə vinde way a tinen a sa ban anan apan ata awan: «Bahay sə Yahuda ahay.» Tə tapan anan pə dədom ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tə darak ayak ɗo sə akar aya inde cew re, ɗo kərtek a tə alay puway, ɗo hinen tə alay gula, Yesu à mamasl a tinen.  ");
INSERT INTO mqbNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kawa ana Deftere sa ja ata nà, a təra matanan acəkan. A wa: «Tə baslay anan à wulen su ɗo mi nes aya inde.» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɗo sa zla ta man ataya fok ta ɓal nga kwata kwata, tə gənahan, ta wa: «Na wa, iken ka wa ki mbazl anan doh sə mazlaɓ a Mbərom aday ki han anan maza awan à luvon maakan inde ba? ");
INSERT INTO mqbNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Əna dazay ahay pə dədom a wa kutok, aday tam anan nga anak biɗaw!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Matanan, bahay sə gəɗan dungo anà way ahay, miter sə Tawrita ahay pə kərtek a, ta ran mindel à wulen a tinen, ta wa: «Kə̀ təmak anan ɗo azar aya awan, əna a mba apan sa tam anan nga anahan a bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kak ɗə canak anan anà Almasihu bahay sə Yahuda ahay kə̀ dazak ahay pə dədom wa həna ata nà, ɗi ɗaf apan nga acəkan!» Ɗo aya tinen mə daray aya tatə Yesu ataya ɗukwen ta ma nga sə gənahan ite re. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A ban pə man ipec wa nà, luvon a ga pə daliyugo fok takəɗimbom, hus à njamde maakan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tə njamde maakan kutok cəna, Yesu a zlah tə məgalak a, a wa: «Elowa, Elowa, lama sabaktani?» Kawa sa ja nà: «Mbərom uno, Mbərom uno, kə mbəsak nen, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ɗo a mə tavay aya à man ata azar a tə sləne bine maw cəna, ta wa: «Winen apan i ngaman anà Eliya həna!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɗowan a tinen a kərtek a a haw, a gəɓa awan a inde kawa baf, a tar anan à way mə kwasay a inde, aday sərekeke re. Tə taran anan ayak tə gusuko zəbor awan aday Yesu â susœɓ. Ta wa: «Kak Eliya i nay sa naa dazay anan ahay pa man a anan wa nà, ɗi ca apan aday. Buko!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Əna Yesu a zlah tə məgalak awan, a mac way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cəna, zana sə gəzla anan man sə njahay a Mbərom pi zek wa tə ɗo ahay, ù doh sə mazlaɓ a Mbərom ata, a ngəraw ì zek wa əndem, a bənay ahay kwa à mburom wa hus à məndak. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Bahay sə suje a mə tavay a pa 'am ana atə Yesu a mə daray ataya kə̀ canak anan a mac nə kəkəmaw. Anga nan a wa: «Tə ɗiɗek awan, winen Wan a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Uwar ahay inde à man ata awan, tə tavay zaɗ, tinen apan ti cak ayak apan. À wulen sə uwar ataya nà, ɗi tan à nga anà Mariyama dəna sə Magədala ahay, tatə Salome, aday Mariyama may ana Yakuba zek cəɗew awan tatə Yoses. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","À alay a Yesu winen à Galile nà, uwar ataya ta taa pərahan azar, aday ta taa gan mer su way re. Uwar azar aya ɗukwen inde bayak a tə pərahak anan ahay azar à Urəsalima, tinen inde à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pac ata nà, luvon sə lavay zek anga luvon sa man uda awan. Kawa sa ja nà, luvon sə lahan anà luvon sa man uda awan. Suko awan a ga nà, ");
INSERT INTO mqbNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu, ɗo sə Arimatiya ahay, a nay. Winen ɗo tə mazlaɓ awan à wulen su ɗo sə lavay nga ahay. Winen apan i ba bahay a Mbərom re. A sa mbac sa zla à man ana Pilatu, a cəcihey ahay cəveɗ sa la anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu a sləne sa jəka Yesu kə̀ məcak coy nà, a gan masuwayan, anga pə winen nà, Yesu kə̀ məcak bəse kak matanan nà, na. Pilatu a ngaman ayak anà bahay sə suje ata awan, a cəce panan: «A mac nà, kə̀ njahak bayak a ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bahay sə suje ata a ndav anan sə təkəren ləbara cəna, a jan anà Yusufu nà: «Ka a gəɓa məsinde anak, la!» ");
INSERT INTO mqbNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu a sukom apan rəkot, a dazay anan ahay məsinde a Yesu pə dədom mə zləlngaɗ ata wa. A nga anan apan rəkot ata awan, a ɗəfak anan ayak à jəvay a ma la à jama inde ata awan. A bətukwal apan bələlen məduwen a, a tacay anan 'am sə jəvay. ");
INSERT INTO mqbNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Atə Mariyama, dəna sə Magədala ahay, tə Mariyama, may ana Yoses, ta ca pa man a ta la anan uda Yesu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pə dəɓa ana luvon sa man uda awan wa nà, Mariyama sə Magədala, tə Salome, tatə Mariyama may ana Yakuba, tə sukom amar lele aya sə rəbas dun'a ata awan, saa gak ayak pə məsinde a Yesu à jəvay inde. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta pac sə zaka awan duwdew, pac winen apan i gay ahay tərɗussa, uwar ataya ta zla pa 'am jəvay. Pac kà gak cəf lele way anahan, ta sa dəzle nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tinen apan ti ja à wulen a tinen inde ta wa: «Waya saa bətukolok uko anan bələlen a pa 'am jəvay wa anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tə cakaf nga nà, tə canan ayak anà bələlen a məduwen ata mə bətukwal a pa 'am jəvay wa, mə jəkay a coy. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta zla à jəvay inde, ta ca iɗe nà, tə canan à ɗowan inde njavar awan mə njahay tə alay puway, winen tə zana pi zek səɗek awan aday kweɗekkweɗek. A gan atan masuwayan, ta ma nga pə ajəjar yiɓyaɓ. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Əna ɗowan ata a jan anà uwar ataya, a wa: «Kə̂ jəjiren bay! Kwanay apan ki pəlen nə Yesu sə Nazaratu, ɗowan a tinen sə darak anan ayak pə dədom mə zləlngaɗ ata awan. Cen apan. Man sə nahay anahan awan nə həna. Winen inde à man a anan sabay. Kə̀ slabakak! ");
INSERT INTO mqbNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Həna nà, zlen! Kâ si jen anà njavar anahan ahay tatə Piyer nà: “I lahak ikwen à Galile. Ki cinen anan nà, à man ata awan, kawa anahan sa jak ikwen.”» ");
INSERT INTO mqbNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kwayan'a, uwar ataya ta haw ahahaw pa 'am jəvay wa tə ajəjar awan, anga zlawan a gan atan. Tə təkərek anan 'am ata anà ɗowan kwa kərtek bay anga tinen apan ti jəjar. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu a slabakay ahay à məke wa nà, pac sə zaka duwdew pərek. Mama'am awan a kan zek anà Mariyama, dəna sə Magədala ahay ata, Yesu sə rəzlay ahay wa apasay lelibay aya cuwɓe à winen wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariyama ata awan a zla sə ɗakan anan ləbara awan anà ɗo sa taa japay tatə Yesu ataya, tinen apan ti yam anga mbac kə̀ slahak patan wa. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tə sləne sa jəka winen inde tə sifa awan, aday Mariyama kə̀ canak anan ɗukwen, tə təmahak sa ɗaf apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pə dəɓa wa ɗukwen nà, Yesu a kan zek anà njavar anahan ahay cew ti zek hinen. Tinen a aday nà, tinen apan ti nay à wulen su doh wa sa zla tə kiɓe. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Njavar ataya ɗukwen ta mak, tə təkərek anan ləbara awan anà njavar anahan azar ataya awan, əna tə təmahak atan anan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pə dəɓa anahan a wa nà, Yesu a kan atan zek anà njavar anahan ahay kuro nga anahan a kərtek, tinen mə njahay a ti pa ɗaf. A gafan atan 'am anga tə ɗəfak apan nga bay, aday anga kurkwilen à sləmay a tinen ahay inde, bina tə təmahak 'am su ɗo sə canan kə̀ slabakak ataya bay. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesu a jan atan, a wa: «Zlen kwa ta sə wura pə daliyugo fok. Ɗiken anan ləbara mugom a anan kwa anà waya fok. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kuwaya, ɗowan a kə̀ ɗəfak apan nga pə ləbara ata awan aday kə̀ təmahak sa ga baptisma nà, i tam. Aday ɗowan a kə̀ ɗəfak apan nga bay ite nà, Mbərom i gan sariya. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɗo ma ɗaf upo nga aya awan ti njaɗ sa ga way masuwayan aya awan. Ti razl setene ahay tə sləmay uno, ti njaɗ sa ja 'am wiya aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hinahibay ti ban dədew tə alay kabay ti varan atan leke dəp nà, i gan atan awan bay. Ti ɗəfan alay pa nga ana ɗo sə ɗəvac ahay nà, ti mbar à ɗəvac a tinen ahay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pə dəɓa ana Bahay Yesu sa jan atan 'am ata wa nà, zek anahan a cakaf à məndak wa, a zla à mburom saa njahay à alay puway ana Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Njavar anahan ataya ite ta zla saa wazay anan ləbara mugom ata kwa ta sə wura fok. Bahay Yesu a varan atan məgala sa ga masuwayan, aday ɗo ahay tâ san 'am a tinen nà, ɗiɗem aya awan.");
INSERT INTO mqbNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Na jak anak ayak 'am, iken Tiyufil ɗo məduwen awan. Ɗo azar aya tə canak anan tə iɗe a tinen awan, anà way a Mbərom sa ga à wulen a mənuko inde kurre ataya awan. Aday Mbərom a slan atan sə ɗakay anan ləbara sə way a tinen sə canan ata awan. Tinen ɗukwen tə ɗakak umo anan re. Ɗo ahay bayak a à wulen a manay wa, ta rak apan zek sə vinde anan ləbara ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nen həna ɗukwen nə bənak anan bitem sə cəce anan way a sə təra kurre ataya awan, aday həna nə gəzlan alay pi zek wa lele kutok. Anga nan, u no sə vindek anan ayak way ataya pə mədire pə mədire akiken Tiyufil. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nə vindek anan ayak iken ite nà, aday kâ san anan ɗiɗek sə way a iken sə tətak həna ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Natiya awan, à alay a Hiridus winen bahay a pa nga sə daliyugo sə Yahudiya ata nà, ɗowan a inde tə ngaman Zakari. Winen ɗo sə gəɗan dungo à way ahay anga Mbərom, ɗo sə slala ana Abiya. Dalay anahan inde tə ngaman Elizabet winen dəna sə slala ana Haruna, bahay sə gəɗan dungo anà way a re. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tinen cew maya tə dalay anahan nà, ɗo sa ga way ɗiɗek aya pa 'am a Mbərom. Tə ɗəfan apan anà nga sa 'am ana Bahay Mbərom mə baslay aya nà, dəc dəc lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Əna wan a tinen ibay, anga dalay anahan Elizabet ata nà, dərlay awan. Tə wahak wan bay, hus ta gak məduwer. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Natiya kutok, pə luvon a inde, Zakari winen apan i ga mer su way anahan ù doh sə mazlaɓ a Mbərom, anga alay a saa ga mer su way a tinen tu ɗo sə slala ana Abiya ahay kà slak. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ɗo sə gəɗan dungo à way ataya ta taa gəzla anan mer su way ata pə luvon pə luvon. Pac ata kutok, alay a ca pə Zakari. A zla ù doh sə mazlaɓ a Mbərom, à man cəncan awan, aday a vak anan awan a inde kawa ləluway a rəbas ike lele dun'a. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","À alay a Zakari winen apan i vak awan ata ù doh sə mazlaɓ a Mbərom à man a cəncan ata nà, ɗo a Mbərom ahay tinen apan ti gan amboh à Mbərom uho kurkwer. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zaməma nà, Zakari a canan anà maslay a Mbərom mə tavay a à man sə vakan way anà Mbərom, ta day sə alay puway. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari a canan cəna, a ma nga pə ajəjar, zlawan a gan tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Əna maslay a Mbərom a jan: «Kə̂ jəjar bay, Zakari, anga Mbərom kə̀ slənek anak anan amboh anak. Dalay anak Elizabet i wahak wan mungol awan, aday ki ngaman anà wan ata nà, Yuhana. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","À alay ata awan, ki taslay mivel tə mindel, anga wan ata awan. Ɗo ahay bayak a təkeɗe ti taslay mivel anga awahay ana wan ata re, ");
INSERT INTO mqbNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","anga i təra ɗo məduwen a pa 'am a Mbərom. I sa mahay bay, i sa way mə kwasay aya bay re. I saa nay ahay à kutov a may anahan wa nà, winen ma rah a tə Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I may anan ahay ɗo sə Isəra'ila ahay bayak a à man ana Bahay Fetek, Mbərom a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I nay ahay kawa ɗo maja'am a Mbərom tə məgala sə apasay a kawa ana Mbərom sə varan anà Eliya, ɗo maja'am anahan kwakwa ata awan. Wan anak ata i mbəɗa anan mivel sə bəbay ahay ta day a wan a tinen ahay, anga aday 'am â zlan atan pi zek. I mbəɗa anan mivel su ɗo sə ɗəfan apan anà Mbərom bay ataya aday ti saa bayak nga kawa ɗo ɗiɗek aya kutok ite. Aday ata, ɗo ahay ti ga inde mə lavay zek aya awan, anà Bahay a mənuko.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Natiya, pə dəɓa anahan a wa ite, Zakari a cəce pə maslay a Mbərom ata wa, a wa: «Ni i san aday way ata i təra acəkan nà, kəkəmaw? Anga nen nà, məceɗ a coy, aday dalay uno ɗukwen ava anahan sə wahay wan sabay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maslay a Mbərom ata a mbəɗahan apan, a wa: «Nen nà, Jibirila. Nen mə tavay a pa 'am a Mbərom sa gan mer su way. A slənay ahay nen həna nà, sa naa ɗakak anan ləbara sa 'am a mugom a anan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Way uno sa jak i təra acəkan ata nà, kə ɗəfak nga pa 'am uno ata bay. Anga na awan, ki təra ɗo maandak awan, ki mba apan sa ja 'am tətibay. Ki njahay tete dezl pə luvon ana way ata i təra aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","À alay ata ite, ɗo ahay tinen apan ti ba anan Zakari uho. A gan masuwayan anà ɗo sə uho ataya, anga kə̀ njahak ayak ù doh ata bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakari a nay uho kutok nà, a mba apan sa jan 'am anà ɗo ahay sabay, anga kə̀ tərak ɗo maandak awan. A jan atan 'am nà, tə alay. Cəna, ɗo ahay ta san zle i ga nə kə̀ canak anan ahay anà awan a à man a cəncan ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Natiya kutok, alay sa ga mer su way ana Zakari ù doh sə mazlaɓ a Mbərom a ndav nà, a zla way anahan agay. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pə dəɓa sə way ataya wa nà, uwar anahan Elizabet a təra ɗo. Anjahay way sə kiya ɗara ahay nà, winen a njahay way anahan agay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Na gak anan ì zek wa à Mbərom, anga həna waray sə dərlay inde upo sabay, aday ɗo ahay ti mbasay upo sabay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Natiya, kiya a gan mbərka anà Elizabet nà, Mbərom a slənay ahay maslay anahan Jibirila à wulen su doh a inde tə ngaman Nazaratu, pə daliyugo sə Galile. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A slənay anan ahay àga dəna inde dalay awan, tə ngaman Mariyama, dəle a Yusufu. Yusufu ata nà, winen ɗo sə slala ana Dawuda bije anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maslay a Mbərom ata a zla pə cakay a Mariyama kutok, a jan: «Na jak anak 'am, dənama. Taslay mivel bayak awan, anga Mbərom kà gak anak nga tə asan zek anahan. Mbərom Fetek winen inde tə iken.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Əna Mariyama a sləne 'am a matana ata cəna, a wusen nga tə mindel. Winen apan i bayak, a wa: «Aday u jo 'am matana ata jiya nà, a nan sa ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maslay a Mbərom ata kutok a wa: «Kə̂ jəjar bay, Mariyama, anga Mbərom kà gak anak sumor. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Həna nà, ki təra ɗo ti zek cew awan. Ki i wahay wan mungol awan, ki ɗaf apan sləmay nà, Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I təra ɗo məduwen a pa nga sə ɗo ahay fok. Ti ngaman nà, wan a Mbərom sə bagəbaga mburom. Bahay Fetek Mbərom i man anan bahay ana bije anahan Dawuda. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I ga bahay pa nga sə Isəra'ila ahay nà, pa sə viyviya awan. Bahay anahan i ndav kulibay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyama a mbəɗahan apan anà maslay a Mbərom ata awan, a wa: «Həna nà, kula mə zlangak tə ɗowan bay kutok nə aday way ata i təra nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maslay a Mbərom a mbəɗahan apan, a wa: «Apasay Cəncan a i dazay apak, məgala a Mbərom sə bagəbaga mburom i nay apak sərdədek kawa mezeze. Anga nan, wan a iken saa wahay ata nà, winen cəncan awan, ti ngaman nə Wan a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ənga ca apan həna, Elizabet, dəna a mərbay anak, winen mə təra ɗo awan, i wahay wan. Abay ɗo ahay tə bayak nà, winen dərlay a coy, əna həna kiya kà gak anan mbərka kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Way aday Mbərom a mba apan sa ga anan bay nà, ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariyama a mbəɗahan apan, a wa: «Nen nà, ɗo si mer su way anà Bahay Mbərom coy. Mbərom awan, â ga kawa ananak a su jo a anan ata awan.» Pə dəɓa wa kutok, maslay a Mbərom ata a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pə dəɓa anahan a wa nà, Mariyama a slabak, kwayan'a a zla à ɓəzlom, à wulen su doh a inde pə daliyugo sə Yahudiya. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A zla àga Zakari. A dəzle cəna, a jan 'am anà Elizabet. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet a sləne 'am ana Mariyama ata cəna, wan ana Elizabet à kutov ata a ɓal kuzleɗ kuzleɗ. Aday Apasay Cəncan a a zlan à mivel inde ana Elizabet. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A jan anà Mariyama tə məgalak awan, a wa: «Mbərom kə̀ ɗəfak apak alay sə mazlaɓ anahan zal uwar ahay pə daliyugo fok. Ngama ana Mbərom inde pa wan anak a saa wahay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aday a ja asa, a wa: «May ana Bahay uno i nay ahay àga nen kawa həna ata nà, Mbərom sa ma uno ite anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Anga nə sləne 'am anak iken su jo ata cəna, wan a dazlan sa ɓal à kutov uno, anga wan ata kə̀ taslak mivel tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ataslay mivel i tərak iken anga kə ɗəfak nga pa 'am ana maslay a Mbərom a sa jak ata awan, way ata i təra.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Natiya kutok, Mariyama a ga ara, a wa: «Mivel uno i həran nga anà Mbərom Ba Məduwen. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Apasay uno i taslay mivel anga Mbərom, winen ɗo sa tam nen. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Anga winen kə̀ bayakak pi nen ɓile anahan, aday na slak awan bay ata awan. Ayaw, həna kutok ɗo ahay fok ti taa ja coy, nen uwar tə ngama a Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mbərom Ba Məgala kà gak uno mer su way lele aya bayak awan. Sləmay anahan nà, cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ɗo sa ɗaf apan nga ahay nà, ta gan ì zek wa pa sə viyviya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kà gak mer su way ahay tə məgala sə alay anahan njənnjan awan. Kà tak anan 'am anà ɗo sa gan may anà ahar nga ahay à man ahay cara cara fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kə̀ dazak anan ahay bahay ahay à man sə njahay a tinen ahay wa, aday kə̀ slabakak anan nga anà ɗo mə nahay nga aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kə̀ rahak anan ɗo may sa han patan ataya tə way lele aya awan, əna ɗo sə zlile ahay nà, kə̀ rəzlak atan alay məgaɓar aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kà mak anan zek anà ɗo si mer su way anahan Isəra'ila ahay. Ta gak anan ì zek wa, kə̀ mbəɗəkek atan à nga wa bay, kà gak atan asan zek hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kawa anahan sə zlapan anan anà bije a mənuko ahay, tatə Ibərahima, aday tə slala anahan ahay ata nà, i ga anan way ata hwiya.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyama a njahay tə Elizabet way sə kiya maakan, aday a zla way anahan agay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Natiya, alay a a sla aday Elizabet i njaɗ wan kutok. A wahay wan mungol awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɗo sə cakay su doh anahan ahay tu ɗo sə zaav anahan ahay tə sləne sa jəka Elizabet kà gak anan ì zek wa anà Mbərom ata nà, ta nay saa taslay mivel pə kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Natiya, wan ata a njahay luvon jəmaakan nà, ɗo ahay ta nay ahay saa gəɗan mədəndalas, sa ɗaf apan sləmay. Abay ta gan may sə ngaman tə sləmay ana bəbay anahan Zakari. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Əna may anahan awan a mbəɗa apan, a wa: «Matana bay. Sləmay anahan a nà, Yuhana.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tə mbəɗahan apan, ta wa: «Matana bay. Anga sləmay a ɗowan inde matana pə slala anak ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tə cəce pə bəbay a wa, kawa mədəngazlak wulak wulak tə alay, aday sa san, a nan sə ngaman anà wan anahan a nà, wayaw. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Natiya kutok, Zakari a cəce way sə vinde apan way, aday a vinde apan 'am aya awan: «Sləmay anahan a nà, Yuhana.» Way ata a gan atan masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cəna kwayan'a, Zakari a mba apan sa ja 'am, aday a dazlan sə həran nga anà Mbərom kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Natiya, ɗo sə cakay su doh anahan ahay fok ta ma nga sə jəjar, aday à ɓəzlom sə daliyugo sə Yahudiya ataya fok, tinen apan ti təker ləbara sə way a sə təra ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɗo sə sləne ləbara sa 'am ataya fok, ta ma nga sə bayak, ta wa aday: «Ləbara a wan ata i naa ga nà, kəkəmaw?» Anga alay sə mazlaɓ a Mbərom Ba Məduwen inde pa wan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pə dəɓa a wa kutok, Apasay Cəncan awan a rahan à mivel inde anà Zakari, bəbay ana wan a ata awan. Natiya awan, a dazlan sa ma anan 'am a Mbərom, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Zambaɗuko anan Bahay Fetek, Mbərom ana Isəra'ila ahay, anga kà gak atan nga lele, kə̀ təmak atan ahay à ɓile wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kə̀ slənak uko ahay anà mənuko ite, ɗo sa tam ɗo məgala awan pə slala ana Dawuda wa, ɗo sa ga mer su way anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bina ɓa kà jak anan matanan kwakwa ta 'am ana ɗo maja'am anahan cəncan aya awan, ");
INSERT INTO mqbNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a wa, i təmay ahay mənuko à alay ana ɗo maniɗe a nuko ahay wa, aday à alay ana ɗo sa nak uko iɗe ahay wa fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Natiya, Mbərom a kay anan ahay sumor anahan sə zlapan anan anà bije a mənuko ahay ata awan, anga a bayak pə aɓan 'am a tinen ata hwiya, ");
INSERT INTO mqbNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","way a Mbərom sə zlapan anan anà Ibərahima, bije a mənuko ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A wa, i təmay ahay mənuko à alay ana ɗo maniɗe a mənuko ahay wa, aday ɗi mba apan sa gan mer su way mənjəna ajəjar, ");
INSERT INTO mqbNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ɗi gan mer su way tə cəveɗ awan mənjəna ines ahay, pə iɗe a Mbərom, hus pə luvon a sifa a nuko saa ndav pə daliyugo wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakari a ja hwiya asa re, a wa: «Iken, wan a cəɗew a ana awan, ti naa ngamak ɗo maja'am a Mbərom sə bagəbaga mburom, anga ki lahan anà Ba Məduwen, sə ndakan anan cəveɗ anahan, ");
INSERT INTO mqbNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","aday sə ɗakan anan anà ɗo anahan ahay nà, winen i naa tam atan ta sə pəsen atan anan ines a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anga winen nà, ɗo sa ga sumor, aday ɗo sə asan zek re. A kay puko jiyjay anahan à mburom wa, kawa pac sə sləray ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jiyjay ata i dəvan ayak anà ɗo sə iɗe zənzen ataya awan, tinen bəse ɗo sə məke ahay coy ata awan, i lagay mənuko à cəveɗ sə zay inde.» ");
INSERT INTO mqbNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Natiya, pə dəɓa anahan a wa, Yuhana a har, a san nga lele, a zla way anahan à saf inde. A njahay à man ata dezl pə luvon anahan sa kan ahay zek anà Isəra'ila ahay ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","À alay ata ite, bahay sə Ruma Agustus a jan anà ɗo si mer su way anahan ahay tə̂ baslay anan sləmay su ɗo pə daliyugo anahan ahay ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Wita nà, mama'am sə baslay ɗo pə daliyugo sə Ruma ahay ata awan. A təra nà, à alay a Kiriniyus winen ɗo sə lavan nga anà daliyugo sə Siriya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anga nan kutok, kuwaya fok a zla saa vindek anan ayak sləmay anahan à wulen su doh ana bije anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Natiya kutok, Yusufu ite a slabak à Nazaratu pə daliyugo sə Galile wa, a zla pə daliyugo sə Yahudiya à wulen su doh sə Baytilama, man sə wahay ana bije anahan Dawuda. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aday ta zla saa vindek anan ayak sləmay a tinen tə Mariyama, dəle anahan, winen mə təra ɗo awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","À alay a tinen à Baytilama à man ata kutok nà, wan a dəlay anan Mariyama, bina kà slak pə kiya anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aday a wahay wan mungol a murkwaya anahan, a kumboh anan à zana inde, a nahay anan à kuɗom inde, bina man inde sə nahay ù doh sabay, anga mbəlok ahay tə zalak ayak. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Natiya awan, ɗo sa ɓal way ahay inde à kiɓe sa man ata awan, tinen apan ti ba pə gənaw a tinen ahay sə luvon. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Maslay a Mbərom a sləray ahay à wulen a tinen inde. Jiyjay sə mazlaɓ a Mbərom a dəvay ahay patan pəzlaɗ pəzlaɗ, aday ta ma nga sə jəjar tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Əna maslay a Mbərom ata a jan atan nà: «Kə̂ jəjiren bay, anga na nak ikwen anan ahay nà, tə ləbara mugom a, sə taslan anan mivel anà ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɗo sa tam ɗo mə wahay a anga kwanay biten à Baytilama, wulen su doh a Dawuda. Winen nà, Almasihu, Ba Məduwen. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ki i sənen anan pə minje sə way a anan: Ki njiɗen anan ayak wan cəɗew a ndəleɓœɓe mə kumboh a à zana inde, aday mə nahay awan à kuɗom inde.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kwayan'a cəna, daskalak, maslay a Mbərom azar aya tə sləray ahay, tə japay tə maslay a Mbərom ata awan. Tə taslay mivel pə kərtek awan, tə həran nga anà Mbərom ta sə zambaɗ anan, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Zambaɗuko anan Mbərom à bagəbaga mburom. Zay â ga inde pə daliyugo à wulen su ɗo anahan a sa zlan à nga ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pə dəɓa anahan a wa nà, maslay a Mbərom ataya tə mbəsak anan ɗo sa ɓal way ataya awan. Ta ma way a tinen à man a Mbərom nà, ɗo sa ɓal way ahay ta ja à wulen a tinen inde, ta wa: «Zluko à Baytilama, cuko ahay pə way a sə təra à man ata kawa ana maslay a Mbərom sə ɗakak uko anan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Cəna, tə slabak, ta zla kwayan'a, ta tan ayak à nga anà atə Mariyama tə Yusufu aday ta wan a cəɗew a ata, mə nahay awan, à kuɗom inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ɗo sa ɓal gənaw ahay tə canan à wan ata cəna, tə dazlan sə ɗakay anan way kawa ana maslay a Mbərom sa jan atan pa wan ata ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","'Am ana ɗo sa ɓal way ataya a ma nga sa gan masuwayan anà ɗo sə sləne 'am a tinen ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Əna Mariyama nà, a ɗaf anan à nga inde way a sə təra ataya fok kəcek kəcek, a taa jalay apan à mivel anahan inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pə dəɓa anahan a wa nà, ɗo sa ɓal way ahay ta ma way a tinen à kiɓe à man sə gənaw a tinen ahay. Tinen apan ti zambaɗ a Mbərom, tinen apan ti həran nga, anga way a tinen sə canan ta sə sləne ataya fok. Kə̀ tərak kawa ana maslay a Mbərom a sa jan atan ayak kurre ata acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A njahay pə dəɓa wa kwasuko kərtek nà, alay a a sla sə gəɗan mədəndalas anà wan ata kutok. Ta ɗaf apan sləmay a nà, Yesu. Sləmay ata nà, sləmay mbala ana maslay a Mbərom sə ɗakan anan anà Mariyama, à alay a kə̀ tərak ɗo fan bay a ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Alay sa ga mudo ana Mariyama a ndav kutok, kawa ana Tawrita ana Musa sə ɗakay anan nà, ta zla anan tə Yesu à Urəsalima sə ɗakan anan à Mbərom, ù doh sə mazlaɓ a Mbərom awan, ");
INSERT INTO mqbNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","anga mə vinde a à Tawrita a Mbərom inde nà: «Murkwaya sə wan mungol a cəna, ma ga nga awan, anà Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aday ta var way ta 'am kəray awan, anga mə vinde a à Tawrita a Mbərom inde matanan: «Sa var nà, kurkudok ahay cew, kabay badəbada ahay cew.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","À alay ata ite, ɗowan a inde à Urəsalima à man ata awan, tə ngaman Simiyon, winen ɗo ɗiɗek a aday a jəjaran anà Mbərom cəveɗabay. Winen apan i ba anay ana ɗo saa tam anan Isəra'ila ahay ata awan. Apasay Cəncan a ɗukwen inde à mivel anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɓa Apasay Cəncan a kə̀ ɗakak anan anan, i mac fan bay si i canan anà Almasihu a Mbərom saa slənay anan ahay ata aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","À alay ata ite, Apasay a Mbərom kà nak anan ahay Simiyon ù doh sə mazlaɓ a Mbərom. Aday bəbay a Yesu ta may anahan ta nak anan ahay Yesu à man ata, saa zugulan way kawa mə vinde a à Tawrita ana Mbərom inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Cəna, Simiyon a təma anan wan à alay anahan inde, a gan suse anà Mbərom, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Bahay Mbərom, 'am anak a su jo kurre ata kà gak zek kutok. Həna nà, mbəsak nen ɓile anak nâ mac. Nen à zay inde kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Anga həna nə canak anan tə iɗe uno njœk anà ɗo iken sə slənay saa tam anan ɗo ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Winen, iken sə lavan a zek anà ɗo sə daliyugo ahay fok ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Winen nà, jiyjay sə ɗakan anan way anà ɗo sə daliyugo ahay fok, aday winen i varan mazlaɓ anà ɗo anak Isəra'ila ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","'Am ana Simiyon sa jan à nga wa anà Yesu ata nà, a gan masuwayan à bəbay anahan tə may anahan a təke fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Natiya kutok, Simiyon a ɗaf patan ngama, aday a jan anà Mariyama, may a Yesu awan, a wa: «San apan lele, wan anak a anan nà, i naa dəcan saray anà Isəra'ila ahay bayak awan, aday i naa təran cəveɗ sa njaɗ sifa anà Isəra'ila ahay bayak a re. Winen i təra ɗo saa ɗakan anan Mbərom anà ɗo ahay, əna ɗo ahay ti təma 'am anahan bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","I kay anan ahay uho abayak nga su ɗo mi ɗer ataya awan. Əna iken, Mariyama nà, way i cəɓak à mivel inde kawa ta ndaz iken zlac zlac tə maslalam.» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","À Urəsalima à man ata nà, ɗo maja'am a Mbərom a inde uwar awan, tə ngaman Anna. Winen dəna ana Fanuwel, ɗo sə zaav ana Aser. Uwar ata winen məduwer a coy. Ɓa kə̀ njahak abay pi zek tə mbaz ava cuwɓe tə dalay anahan awan, əna mbaz a mac panan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A njahay winen mədukway sə uwar awan, ava anahan kà gak həna kutok kwa kuro jəmaakan nga anahan a fuɗo. Winen apan i ga mer su way ù doh sə mazlaɓ a Mbərom hwiya, luvon tə ipec a təke. Winen apan i ga amboh tə sumaya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","À alay a Simiyon tə Yesu a à alay inde ata nà, Anna a zla à man a tinen awan, a gan suse à Mbərom. A təkəren ləbara a Yesu anà ɗo sa ba aday Mbərom i tam anan Urəsalima ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pə dəɓa anahan a wa, atə bəbay a Yesu tə may anahan ta ndav anan sa ga way kawa mə vinde a à Tawrita a Mbərom inde ataya nà, ta ma way a tinen pə dəɓa à wulen su doh a tinen à Nazaratu pə daliyugo sə Galile kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Natiya awan, wan ata kə̀ hərak. Kə̀ njaɗak məgala lele, kə̀ njaɗak kəlire lele re, aday Mbərom a pəlay anan cəveɗabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Atə bəbay a Yesu tə may anahan ta taa zla pə ava pə ava saa gay ahay azar uko sə Pasəka à Urəsalima wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ava ana Yesu a ga kuro nga anahan a cew kutok nà, ta zla pə kərtek a à azar uko ata, kawa ana Isəra'ila ahay sa taa zla ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Azar uko a ndav nà, atə bəbay anahan tə may anahan ta ma pə dəɓa sa zla agay. Əna wan a tinen Yesu ata nà, winen mətak njahay way anahan à Urəsalima. Aday atə bəbay anahan tə may anahan nà, tə sənak pi zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tinen tə bayak nà, i ga inde à wulen su ɗo a tinen ahay. Ta zla way sə luvon kərtek nà, winen ibay hwiya. Matanan tə dazlan sə pəlay anan à wulen su ɗo a tinen ahay, tə məndala anahan ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Əna ta tak anan à nga à wulen su ɗo ataya inde bay, ta ma pə dəɓa à Urəsalima, saa pəlay anan ahay à man ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hus pə luvon maakan anahan a ta saa tan à nga ù doh sə mazlaɓ a Mbərom, winen mə njahay awan, à wulen sə miter sə Tawrita ahay inde. Winen apan i pak sləmay pa 'am a tinen, aday winen a ɗukwen winen apan i cəce patan wa 'am ahay ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A ma nga sa gan həɓəkəkka anà ɗo sa pak sləmay pa 'am anahan ataya fok, anga 'am anahan a sə mbəɗahan atan apan ata nà, tə mərike sa san way awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Atə bəbay anahan tə may anahan tə canan kutok nà, a gan atan həɓəkəkka re. Anga nan awan, may anahan a jan, a wa: «Wan uno, ka gan umo ata nà, way maw? Ma yak nga sə pəlay iken tə bəbay anak aday zek kà dak umo ndəlekeke sə pəlay iken nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A mbəɗahan atan apan, a wa: «Kə pəlen nen nà, angamaw? Kə sənen apan abay sa jəka, ni njahay ù doh ana Bəbay uno biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Əna tə sənak anan 'am anahan a sa jan atan ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pə dəɓa anahan a wa kutok nà, Yesu a ma tə tinen a təke fok à Nazaratu. Kə̀ ɗəfak anan apan anà atə bəbay anahan tə may anahan. May anahan nà, a ɗaf anan way a sə təra ataya fok à nga anahan inde kəcek kəcek lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Natiya awan, Yesu winen apan i har, winen apan i san nga kurkwer. A zlan à nga anà Mbərom, aday a zlan à nga anà ɗo ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Natiya, Tiberiyas kà gak à bahay inde ava kuro nga ɗara pə daliyugo sə Ruma ahay fok; sə lavan nga anà daliyugo sə Yahudiya nà, Pontiyos Pilatu; sə lavan nga anà daliyugo sə Galile nà, Hiridus; mərak anahan Filip ɗukwen a lavan nga anà kon sə Ituriya, tə daliyugo sə Tarakunitis; Lisaniya ɗukwen a lavan nga anà daliyugo sə Abilene. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Atə Anas tə Kayafas ite, tinen bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom. À alay ata ite kutok, Mbərom a jan ahay 'am anahan anà Yuhana, wan ana Zakari, winen mə njahay a nà, à saf inde taayak. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yuhana a bar à wulen su doh sa mban anà zlinder sə Urdon ataya fok ta sə wazan anà ɗo ahay, a wa: «Mbəsiken ines a kwanay ahay, təmihen sa ga baptisma, aday Mbərom i pəsek ikwen anan ines a kwanay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Matanan kawa ana Ezaya, ɗo maja'am a Mbərom sə vinde à Deftere a Mbərom inde, a wa: «Ɗowan a inde, winen apan i zlah à saf inde à kiɓe, a wa: “Ten anan cəveɗ anga Bahay winen apan i nay. Ten anan cəveɗ ata mə tavay nga a lele fəhhe. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Futor ahay fok, rihen a wa, ndisen uda awan. Ɓəzlom tə culok ahay, mbəzlen a wa, â ga fəkətuwwa lele. Cəveɗ mə slaray aya fok, tə̂ tavay nga. Cəveɗ mi nes aya fok, tə̂ ndakay zek lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Matanan, ɗo ahay fok ti san apan Mbərom i tam anan ɗo ahay kutok.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Natiya kutok, ɗo ahay bayak a tinen apan ti zla à man a Yuhana, aday â sa gan atan baptisma. Yuhana a jan ù ɗo ataya, a wa: «Kwanay zahav su kòn ahay, ɗo sa njak ɗo ahay, waya sə ɗakak ikwen anan sa haw pə sariya ana Mbərom saa nay ahay ata wa anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gen mer su way lele aya aday sə ɗakay anan nə kə mbəsiken ines a kwanay ahay acəkan ata awan aday. Bina, kâ sa ɗəfen ajalay nga a kwanay ta sa jəka: “Manay nà, wan ana Ibərahima ahay asanaw” ata bay. Nen apan ni jak ikwen, Mbərom i mba apan sə təra anan kon a anaya, wan ana Ibərahima aya təte. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbərom kə̀ lavak anan zek tə tirez, i gaɗ anan dədazl si sé aday a wahay wan lele aya bay ata fok. I gaɗ atan, aday i pak atan ù uko inde.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ɗo ataya tə cəce panan kutok, ta wa: «Aday mâ ga həna nà, kəkəma kutok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yuhana a mbəɗahan atan apan, a wa: «Ɗo aday zana anahan ahay inde cew ata nà, â varan panan wa anà ɗo aday zana anahan ibay ata awan. Ɗo aday way sa pa anahan inde ata ɗukwen, â varan panan wa anà ɗo hinen, aday way sa pa anahan inde apan itəbay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɗo sə cakal jangal ahay ite ta zlak ayak à man a Yuhana anga aday â gan atan baptisma ite re. Tə cəce panan, ta wa: «Miter, mi ga həna nà, kəkəma ite anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A mbəɗahan atan apan, a wa: «Kâ sa təmihen way pə ɗo ahay wa zal pə mbala ana bahay a kwanay sa jak ikwen ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suje ahay ite asa tə cəce panan, ta wa: «Aday manay həna nà, mâ ga kəma ite anaw?» A mbəɗahan atan apan, a wa: «Kə̂ ngəzəren dala pu ɗo ahay wa tə məgala, kabay ta sa gaɗ patan mungwalay bay. Tislen mivel nà, pə dala sa ga mer su way a kwanay aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Anga nan kutok, ɗo ataya fok tinen apan ti bayak à nga a tinen inde ta sa ja nà: «Həna anan nà, i ga nə Almasihu bay dəge?» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Əna Yuhana a mbəɗahan atan apan à tinen ata fok, a wa: «Nen nà, na gak ikwen baptisma nà, tə a'am cəna coy. Əna, ɗo hinen inde i nay ahay pə dəɓa uno wa mba, winen a zalay nen tə mazlaɓ lele. Nen, na slak sə həɗek pə cakay anahan aday ni pəsakan anan liɓer sə təkarak anahan bay. Winen kà sak a nay ahay nà, i naa gak ikwen baptisma nà, tə Apasay Cəncan awan, aday tə uko. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ɗowan ata nà, i nay ahay tə gəsaɗaf anahan a à alay inde saa vəvay ndaw, anga sə gəzla anan ndaw pi zek wa tə janjar. Aday i halan nga anà ndaw ì de anahan, janjar ɗukwen i ɗəfan uko, i vak anan wa tə uko sə mbacay kula itəbay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Natiya, Yuhana a ɗakan anan ləbara sa 'am a Mbərom mugom a, anà ɗo ataya nà, ta 'am a ma ja a anaya awan, aday ta 'am azar aya re. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Cəkəbay, bahay a inde ite, tə ngaman Hiridus. A ngəzar anan uwar a inde tə ngaman Hirudiya, pə wanbay anahan wa. Aday ɗukwen winen apan i ga way lelibay aya inde azar aya bayan a re. Anga nan, Yuhana a jan apan anga mer su way anahan a lelibay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Əna Hiridus a ga way lelibay a miza awan, zal way ata asa re. A ban anan Yuhana, a ɗəfak anan ayak à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Natiya awan, à alay ana Yuhana winen apan i gan baptisma anà ɗo ahay mba ata nà, a gan baptisma anà Yesu ite re. À alay a Yesu winen apan i ga amboh ata nà, bagəbaga mburom a təɓa pangaya. ");
INSERT INTO mqbNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Apasay Cəncan a dazay ahay apan ti zek a kawa badəbada dəgurzelehhe. 'Am a ndəray ahay kwa à bagəbaga mburom wa, a wa: «Iken nà, wan uno, ləliwe uno awan. Nen a nə taslay mivel bayak a nə tə iken awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","À alay a Yesu sə dazlan sə ɗakay anan ləbara sa 'am a Mbərom ata nà, ava anahan i ga way sə kwa kuro maakan ahay. Pə ana ɗo ahay sə bayak nà, winen wan ana Yusufu. Aday kutok, Yusufu winen wan ana Heli, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wan ana Matat, Matat wan ana Lewi, Lewi wan ana Melki, Melki wan ana Yanay, Yanay wan ana Yusufu, Yusufu wan ana Matatiya, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiya wan ana Amos, Amos wan ana Nahom, Nahom wan ana Hesəli, Hesəli wan ana Nagay, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay wan anan Mahata, Mahata wan ana Matatiya, Matatiya wan ana Semeyon, Semeyon wan ana Yosek, Yosek wan ana Yoda, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda wan ana Yowanan, Yowanan wan ana Reza, Reza wan ana Zorobabila, Zorobabila wan ana Salatiyel, Salatiyel wan ana Neri, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri wan ana Melki, Melki wan ana Adi, Adi wan ana Kosam, Kosam wan ana Elmadem, Elmadem wan ana Eri, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri wan a Yosuwa, Yosuwa wan ana Eliyezer, Eliyezer wan ana Yorim, Yorim wan ana Matat, Matat wan ana Lewi, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi wan ana Simiyon, Simiyon wan ana Yahuda, Yahuda wan ana Yusufu, Yusufu wan ana Yonam, Yonam wan ana Eliyakim, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim wan ana Meliya, Meliya wan ana Mena, Mena wan ana Matata, Matata wan ana Natan, Natan wan ana Dawuda, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda wan ana Yisa, Yisa wan ana Obed, Obed wan ana Bo'es, Bo'es wan ana Salmuna, Salmuna wan ana Nasunu, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasunu wan ana Aminadabu, Aminadabu wan ana Adəmin, Adəmin wan ana Arəni, Arəni wan ana Hesərunu, Hesərunu, wan ana Fares, Fares wan ana Yahuda, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda wan ana Yakob, Yakob wan ana Isiyaku, Isiyaku, wan ana Ibərahima, Ibərahima wan ana Tarak, Tarak wan ana Nakor, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor wan ana Saruku, Saruku wan ana Ragaw, Ragaw wan ana Falek, Falek wan ana Eber, Eber wan ana Sala, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala wan ana Kaynam, Kaynam wan ana Arəfasada, Arəfasada wan ana Sem, Sem wan ana Nuhu, Nuhu wan ana Lemek, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek wan ana Matusala, Matusala wan ana Anuhu, Anuhu wan ana Yeret, Yeret wan ana Meleliyel, Meleliyel wan ana Kaynam, ");
INSERT INTO mqbNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam wan ana Enos, Enos wan ana Setu, Setu wan ana Adama, Adamu ata nà, wan ana Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Coy, pə dəɓa ana Apasay Cəncan a sa nay ahay pə Yesu ata wa nà, Yesu a may ahay à zlinder sə Urdon wa. Aday Apasay ata a zla anan à man sa saf inde à kiɓe. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Winen à saf inde à man ata nà, luvon kwa kuro fuɗo, Fakalaw winen apan i njak anan. Luvon kwa kuro fuɗo ata fok nà, Yesu kə̀ tukumok awan bay jiga awan. Luvon ata a ndav kutok nà, may a han apan tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Coy kutok, Fakalaw a jan, a wa: «Kak iken nə Wan a Mbərom cukutok nà, jan anà kon a anan â təra ɗaf biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu a mbəɗahan apan, a wa: «Ɓa mə vinde a à Deftere a Mbərom inde coy, a wa: “Ɗo zənzen a a njahay uho nə tə way sa pa ɗəkɗek bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Asa, Fakalaw a zla anan pa nga sə ɓəzlom zəbor awan, a ɗakan pə bahay sə daliyugo tembərəzem fok, kawa akəɓac iɗe. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A jan, a wa: «Daliyugo a anan fok, ni varak anan pə alay anak. Ki lavan nga tə mazlaɓ sə zlile anahan a təke fok. Anga way a iken sə canan anaya fok nà, mə vuro a à alay uno inde. Ni mba apan sə varan anan anà ɗowan a kawa su no. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kə dukwek uno gərmec ù vo aday kə hərak uno nga nà, way a anaya fok ni varak atan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu a mbəɗahan apan, a wa: «Mə vinde a à Deftere a Mbərom inde, a wa: “Həran nga nà, anà Mbərom Fetek a taayak, winen Bahay anak. Gan mer su way nà, anà winen a kərtek.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pə dəɓa anahan a wa asa nà, Fakalaw a zla anan Yesu à wulen su doh sə Urəsalima, a ján anan pa nga su doh sə mazlaɓ a Mbərom a cəkəɗkeɗ a aday sololo re. Aday a jan kutok, a wa: «Kak iken Wan a Mbərom a acəkan nà, ənga larak ayak zek kwa à man a anan wa à məndak biɗaw! ");
INSERT INTO mqbNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anga Deftere a Mbərom kà jak, a wa: “Mbərom i jan anà maslay anahan ahay sa ba iken” asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aday ɗukwen, a wa: “Ti kəcaw iken à alay a tinen inde, anga aday kâ saa ɓurgosl anan saray anak ahay pu kon bay” biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu a mbəɗahan apan asa re, a wa: «Deftere a Mbərom a ja nà: “Kâ sa ca azan pə Mbərom anak wa bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pə dəɓa anahan a wa, Fakalaw kà yak nga dəftakar pə Yesu wa. Coy a mbəsak anan, a zla way anahan pə cakay anahan wa, si pac a hinen asa. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pə dəɓa ana way ataya wa fok kutok, Yesu a may ahay pə daliyugo sə Galile, winen ma rah məgala sə Apasay a Mbərom awan. Ɗo ahay tə dazlan sə təker anan ləbara sa 'am anahan awan, anà ɗo ahay à wulen su doh sa man ataya fok, pu kon pu kon. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu a ɗukwen kə̀ ɗakak anan anan 'Am a Mbərom anà ɗo ahay ù doh sə wazay ahay. Ɗo sa man ataya fok ta ma nga sə varan zlangar. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu a may ahay a Nazaratu, wulen su doh a winen sa har uda ata awan. Pə luvon sa man uda awan, kawa anahan sa taa ga, a zla ù doh sə wazay ata awan. A slabak anga aday i jangan Deftere a Mbərom anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tə varan ahay Deftere ana Ezaya, ɗo maja'am a Mbərom. A təɓa anan Deftere ata awan, a njaɗ man sə jinge, winen apan i ja nà: ");
INSERT INTO mqbNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Apasay a Mbərom Fetek inde pi nen. A zəɓa nen anga aday sə ɗakan anan ù ɗo mətawak aya awan, ləbara mugom awan. A slənay ahay nen sa jan anà ɗo sə dangay ahay nà: “Həna ti mbəsak kwanay coy”, aday anà hurof ahay nà: “Həna iɗe a kwanay i təɓa kutok”. A slənay ahay nen saa tam anan ɗo aday tinen apan ti ga atan alay ataya à ɗəce a tinen ahay wa, ");
INSERT INTO mqbNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","aday sa naa ɗakay anan ava a Mbərom sa kay anan ahay sumor anahan ata kà slak.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pə dəɓa wa kutok, a tacay anan Deftere ata awan, a man anan anà ɗo sa ga mer su way ù doh ata awan. A njahay way anahan kutok. Ɗo su doh ataya fok iɗe pə winen həməcəcce, tinen apan ti ca apan. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu a jan atan kutok, a wa: «Way a kwanay sə sləne à Deftere a Mbərom wa ata nà, həna biten way ata kà gak zek coy.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","'Am anahan a lele sa jan atan ata nà, a gan atan masuwayan. Ta wa: «Winen nà, ɗo lele awan. Əna aday na wa, winen nà, wan ana Yusufu ba? Aday a gəɓay wurwer sa san way a anahan a matanan ata awanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Natiya, Yesu a jan atan apan kutok, a wa: «Na san zle, ki saa jen uno jike sa 'am kawa həna a anan awan: “Doktor, ənga mbar zek anak tə alay anak awan. Matanan, way anak a manay sə sləne iken sa ga à Kafarnahum ata fok nà, ənga ga anan ù kon anak awan ite biɗaw?”» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu a jan atan asa, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo ahay ta gan nga anà 'am ana ɗo maja'am a Mbərom kwa ta sə wura fok. Əna ù kon anahan a nà, ɗowan a gan nga anà 'am anahan ahay itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nen apan ni jak ikwen tə ɗiɗem a asa re. À alay ana Eliya ɗo maja'am a Mbərom winen inde mba ata nà, iven kà gak bay ava maakan tə kiya mbərka. May kà nak pə daliyugo bayak awan. Aday ɗukwen, mədukway sə uwar ahay nà, inde pə daliyugo sə Isəra'ila re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Əna Mbərom kə̀ slənek anan Eliya àga mədukway sə uwar ataya bay. Si Mbərom a slan anan nà, àga mədukway sə uwar a inde winen à Sarəfat pu kon sə Sidon biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aday à alay ana Elize ɗo maja'am ana Mbərom ata ɗukwen ɗo mə dugwaɗ aya inde bayak a pə daliyugo sə Isəra'ila, əna Elize kə̀ mbərak ɗowan kwa kərtek bay. Si a mbar anan nà, Na'aman taayak, winen ɗukwen ɗo sə daliyugo sə Siriya.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Natiya kutok, ɗo mə njahay aya ù doh sə wazay ata, tə sləne 'am ata cəna, a cəɓan atan tə mindel, mivel a tinen a ban nə kawa uko. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tinen a fok tə slabak, tə ngəza anan kucəcəren kucəcəren, ta zla anan zaɗ à wulen su doh wa. Wulen su doh a tinen ata nà, pa nga sə culok. Ta zla anan pə zalan, aday ti i fakan ayak alay à man ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Əna a nay ahay à wulen a tinen wa, a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pə dəɓa anahan a wa, Yesu a slabak à man ata wa, a zla à wulen su doh sə Kafarnahum pə daliyugo sə Galile. Pə luvon sa man uda awan, a ɗakan atan anan way ù doh sə wazay. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wazo anahan a a gan atan masuwayan, anga a ɗakay anan way nə, tə mazlaɓ awan, doɗok doɗok lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɗowan inde ù doh à man ata awan, winen tə setene à nga inde. A zlah pi zek tə məgalak awan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Iken Yesu, ɗo sə Nazaratu, ma a nak pə manay anaw? Ka nak sə lize manay ca ɗaw? Na san iken zle lele, iken nə ɗo maslan a Mbərom Cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Cəna Yesu a gafan 'am tə məgalak awan, a jan nà: «Kə̂ bəbal awan bay, hayak à ɗowan ata wa aɗəka.» Cəna ɓəram, setene ata a lar anan ɗowan ata à məndak à wulen su ɗo ahay inde à man ata awan. A nay à ɗowan ata wa bok, a mbəsak anan mənjəna sa gan awan kwa mənjœk. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Way a sə təra ata kà gak anan masuwayan anà ɗo ataya fok, ta ma nga sə cəce pi zek ahay wa, ta wa: «Jəba su ɗo wura həna anan anaw? Winen apan i jan 'am anà setene ahay tə məgala sə mazlaɓ awan, aday tə bənan à 'am wa acəkan re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɗo ataya ta tan 'am à ləbara ana Yesu pə daliyugo ata təɗay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Natiya awan, Yesu a nay ù doh sə wazay wa cəna, a zla àga Simon. A tan ayak à nga anà jəje a Simon winen lelibay. Nga a ɓərzlan tə mindel. Ta gan kem, â mbar anan ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu a zla pə cakay anahan awan, a kuɗœk apan. A ngəraz pə ɗəvac sa nga sə ɓərazl ata cəna, a ndalay panan. Kwayan'a, uwar ata a slabak, a dan atan way sa pa. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pə dəɓa ana pac sə slahay ù doh wa ite nà, ɗo ahay ta zlak anan ayak tu ɗo sə ɗəvac a tinen ahay cara cara bayak awan, à man a Yesu. A dazlan sa ɗaf patan alay kərtek kərtek a tinen awan, aday tə mbərak fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Apasay lelibay aya ta nak ahay à ɗo ahay wa bayak awan. Apasay lelibay ataya tinen apan ti zlah kurkwer, ta wa: «Iken nà, Wan a Mbərom wanahan!» Əna Yesu a ngəraz patan, a gafan atan 'am anga aday tâ ja matanan bay. Bina ta san zle, winen nà, Almasihu a wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Iɗe a cəɗe sidew a nà, Yesu a zla à wulen su doh ata wa, a zla à kiɓe, à saf inde. Əna ɗo ahay ta zla saa pəlay anan. Ta tan ayak à nga kutok, ta gan may nà, abay â mbəsak atan bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Əna Yesu a jan atan nà: «Abay təɗe ni zla aɗəka, saa ɗakay anan ləbara sa 'am mugom a sə bahay a Mbərom, anà ɗo sə wulen su doh sə kiɓe ahay re. Bina nen mə slənay a bugol nà, saa ga mer su way ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A zla sə wazay pu kon pu kon ù doh sə wazay ahay à wulen su doh sə Yahudiya ataya inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pə luvon a inde, Yesu winen mə tavay a pa 'am sə bəlay sə Gənesaret. Ɗo ahay inde bayak a à man anahan, tinen apan ti ngəɗac zek ahay tə mindel, anga a nan atan sə sləne 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Coy a canan ayak anà kwalalan ahay cew pa 'am məgujeguje. Ɗo sa ban kəlef ahay tə dazak ahay wa, tinen apan ti banay anan zuvo a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A ján à kwalalan kərtek a inde, mbala ana Simon. A jan anà Simon a nà, â həɗek anan kwalalan anahan ata pa 'am məgujeguje wa mənjœk, sa ma nga à mamasl awan. Coy Yesu a a njahay uda awan, a dazlan sə wazan anà ɗo ahay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu a ndav anan 'am anahan ata nà, a jan anà Simon, a wa: «Həɗek anan kwalalan pa man sə a'am səɗek awan, aday kə̂ liren ayak zuvo à a'am inde sə bənay ahay wa kəlef ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon a mbəɗahan apan, a wa: «Miter, ma gak mer su way ata matanan sə luvon a anan ndekərkərre, mə njəkak ahan bay, mə nahay apan nə hwiyop. Aday ɗukwen mə bənak kəlef a kwa kərtek bay. Əna ka jak umo həna ata nà, mi təma sə larak anan ayak zuvo aya à a'am inde aday biɗaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tə larak anan ayak zuvo à a'am inde bine siwaw nà, kəlef ahay bayak a tə rahak anan zuvo. Bəse coy a nan anà zuvo sə məndah. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tə ngaman ayak anà ɗo à kwalalan hinen inde ataya, saa man atan zek. Ɗo ataya tə dəzlek ayak nà, ta rah anan kwalalan a tinen a cew ataya fok tə kəlef ahay. Bəse coy a nan anà kwalalan ataya sə kəkar à a'am inde, anga ta ba ike kə̀ zalak. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Piyer a canan anà way a matanan ata cəna, a nay à man a Yesu. A dukwen gərmec ù vo, a ja nà: «Ba Məduwen uno, mbəsak nen cəpak, bina nen nà, nen ɗo sə atahasl.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon tu ɗo si mer su way anahan ataya ta ma nga pə ajəjar anga kəlef a sa ban ata kə̀ zalak pə alay a mindel a wa, bayak a jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Way ata kà gak anan masuwayan anà atə Yakuba tə Yuhana, wan ana Zebede ahay, tinen ɗo sa ga mer su way kərtek a tatə Simon ata re. Əna Yesu a jan anà Simon, a wa: «Kə̂ jəjar bay. Iken ki təra həna aɗəka nà, ɗo sə njuɗo ɗo sə pəruho azar ahay, bina iken ɗo sa ban kəlef sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ta may anan ahay kwalalan a tinen ahay, tə tavay atan pa 'am məgujeguje asa. Cəna tinen mbəsak ayak way a tinen ahay fok à man ata awan, tə pərahan azar à Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Natiya, Yesu winen ù kon hinen asa. Tə zlangay tə ɗowan a inde mə dugwaɗ awan. Ɗowan ata a canan à Yesu cəna, a lar zek à məndak pa 'am anahan, a gan amboh, a jan nà: «Ba Məduwen, kà zlak anak à nga nà, ki mba apan sa mbar nen aday zugol uno â ndav ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu a ndəɗoy alay, a laman ta sa jan nà: «U no. Mbar! Zugol anak kə̀ ndəvak.» Kwayan'a, ɗəvac a ɗowan ata a ndalay panan, kə̀ mbərak. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Coy, Yesu a gafan 'am pi zek wa lele, a jan, a wa: «Kâ sa təkəren ləbara a anan anà ɗowan bay. Əna zla saa kan zek anà ɗo sə gəɗan dungo à way ahay anga Mbərom, â zəzor iken. Aday kâ var way kawa ana Tawrita ana Musa sa ja, aday ɗo ahay tâ san apan zugol anak kə̀ ndəvak.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kwa abay Yesu kà jak anan kâ sa ɗakan anan à ɗowan bay təkeɗe nà, sləmay a Yesu a ma nga sə zakay sa ta 'am pə daliyugo ata təɗay bayak awan. Ɗo ahay ta nay ahay à man anahan bayak a sa naa sləne 'am anahan, aday â mbar atan à ɗəvac a tinen ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Əna Yesu a a zla way anahan, a njahay à man sa saf inde, aday a taa gan amboh à Mbərom à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pə luvon a inde asa, Yesu winen apan i tətakan way anà ɗo ahay. Farisa ahay pi zek tə miter sə Tawrita ahay tinen inde mə njahay a pə cakay anahan. Ɗo ahay ta nay ahay kwa pu kon ahay wa cara cara: ɗo sə Galile ahay, ɗo sə Urəsalima ahay pi zek tu ɗo sə Yahudiya azar aya re. Aday məgala a Mbərom inde pə Yesu sa mbar anan ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","À alay ata ite, ɗowan aya inde tə gəɓak ayak ɗo pə lala, winen mə təra à məndak awan. Ta gan may sa zla anan ù doh à man a Yesu, aday ti nahay anan pa 'am anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Əna ta san sa jəka ti zla anan ù doh nə ta sə wuraw bay, anga ɗo kə̀ zalak ù doh awan, roɗ ahay à məsudoh inde. Ta ján pa nga su doh, tə pəpas man, aday tə tarak anan ayak ɗowan a pə lala ata tə liɓer ù doh, ɗinger à man a Yesu awan. A dəzle à wulen su ɗo bayak ata inde, tə nahak anan ayak pa 'am a Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu a canan anà aɗaf nga a tinen ata nà, a jan anà ɗowan a ɗəvac ata awan, a wa: «Car uno, nə pəsek anan anan ines anak ahay coy.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pə dəɓa a 'am anahan ata wa kutok nà, Farisa ahay, tə miter sə Tawrita ahay, ta ja ta nga ta nga, ta wa: «Jəba su ɗo wura həna anan sə jənan pa 'am anà Mbərom matana ata anaw? Waya sa mba apan sə pəse ines su ɗo anaw, kak si Mbərom a aday bina!» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu a san way a tinen sə jalay ata zle kwayan'a, a jan atan, a wa: «Kə jilen way matanan à mivel a kwanay inde nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ma da 'am a nə maw? Sa ja: “Nə pəsek anan ines anak ahay” ata ɗaw, kabay sa ja: “Slabak, zla” ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Əna u no kə̂ sənen apan lele, nen Wan su Ɗo nà, məgala uno inde sə pəsen anan ines à ɗo ahay pə daliyugo.» A jan anà ɗowan a mə təra à məndak ata kutok, a wa: «Nen apan ni jak: Slabak, gəɓa lala anak, zla agay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Cəna, ɗowan ata a slabak pə iɗe su ɗo ataya fok. A gəɓa lala anahan a sə nahay apan ata awan, a zla way anahan agay, ta sə həran nga anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Way ata a gan masuwayan ù ɗo ataya fok, aday tə həran nga anà Mbərom, ta ma nga pə ajəjar, ta wa: «Biten a anan nà, ɗə canak anan anà way ma ga masuwayan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pə dəɓa anahan a wa, Yesu a may ahay ù doh wa nà, a canan anà ɗo sə cakal jangal a inde tə ngaman Lewi, winen mə njahay a ù doh sə cakal jangal. Yesu a jan, a wa: «Pəruho azar!» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ɗowan ata a slabak kwayan'a, a mbəsak way anahan ahay fok à man ata awan, a pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pə dəɓa wa kutok Lewi sə ɗowan ata a da way sa pa bayak a àga winen sə təma anan Yesu. Ɗo sə cakal jangal ahay tu ɗo azar aya bayak awan, tinen apan ti pa way sa pa pə kərtek a tatə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aya əna Farisa ahay tə miter sə Tawrita ahay nà, way ata kà zlak atan à nga bay. Anga nan, ta jan anà njavar a Yesu ataya, ta wa: «Kwanay apan ki pen way a aday ki sen way pə kərtek a tu ɗo sə cakal jangal ahay aday tu ɗo sə atahasl ahay nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu a jan atan, a wa: «Ɗo ɗəvac a bay cəna, a gan may anà ɗo sə disise bay, si ɗo sə ɗəvac ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nen na nay ahay sa naa ngaman anà ɗo sa ga way lele ataya bay. Əna na nay ahay nà, sə ngaman anà ɗo sə atahasl ahay, anga aday tâ yam pə ines a tinen ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Farisa ahay pi zek tə miter sə Tawrita ahay ta jan anà Yesu, ta wa: «Njavar ana Yuhana ahay ta sə Farisa ahay ta taa ga sumaya tə amboh a kutok nà, aday mbala anak ahay ta ga itəbay nà, angama kəlanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu a mbəɗahan atan apan, a wa: «A ga pikwen nà, ɗo mə ngamay aya à man sə gəɓa dalay nà, ti mba apan sa ga sumaya itəɗaw? Matanan bay! ");
INSERT INTO mqbNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Əna pa pac a ɗo sə gəɓa dalay ata tə bənak anan à wulen a tinen wa nà, ata ti ga sumaya kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Natiya kutok, Yesu a təkəren atan 'am sə jike a anan, a wa: «Kula ɗowan saa ngərway anan ahay zana wiya a aday i tam anan pə zana məduwer a nà, ibay asanaw? Kak ɗowan a kà gak matanan nà, kə̀ nəsek anan zana wiya ata biɗaw? Aday zana məduwer ata ɗukwen nà, i zla pi zek tə zana wiya ata bay ba? ");
INSERT INTO mqbNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aday ɗukwen, ɗowan saa mbaɗ mahay mə kwasay a bay a à mbulo sa zlay məduwer a inde nà, ibay. Ɗowan a kà sak a ga matanan cəna, mahay a mə kwasay a bay ata kà sak a kwasay uda nà, i ndazl anan mbulo ata awan. Mahay i pak, aday mbulo ɗukwen kə̀ nəsek. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kak matanan bay cəna, si ti pak mahay mə kwasay a bay awan, à mbulo wiya a inde cite. ");
INSERT INTO mqbNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɗowan a kà sak mahay mə kwasay a nà, i gan may anà mə kwasay a bay ata sabay asanaw? Anga ta ja nà, lele a nə mə kwasay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pə luvon sa man uda a inde nà, atə Yesu tə njavar anahan ahay tinen apan ti zla tə guvo sa ndaw kutok nà, njavar anahan ahay ta kaɗ ndaw, ta pa. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Əna azar sə Farisa aya sə canan atan ataya ta jan atan nà: «Ki gen way aday təɗe abay sa ga pə luvon sa man uda bay ata nə, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu a mbəɗahan atan apan, a wa: «Kula kwanay kə jingen way ana Dawuda sa ga tu ɗo anahan ahay, à alay a may a han apan ata itəbay ɗaw? A ga nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dawuda a zla à jawjawa sə mazlaɓ a Mbərom, a ray pen ma ga nga anga Mbərom ata awan, a pa, aday ɗo anahan ahay ɗukwen, kə̀ varak atan, ta pak re. Abay təɗe saa pa nà, ɗo sə gəɗan dungo à way ahay anga Mbərom ɗəkɗek biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu a jan atan asa, a wa: «Nen Wan su Ɗo nà, nə lavan nga anà luvon sa man uda awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Natiya awan, pə luvon sa man uda hinen asa, Yesu a zla ù doh sə wazay, winen apan i wazay. Ɗowan a inde à man ata awan, alay puway anahan ma mac awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Miter sə Tawrita ahay tə Farisa ahay tinen apan ti ɗəfan iɗe anà Yesu, ata aday, kak kə̀ mbərak anan ɗo pə luvon sa man uda awan nà, ti njaɗ apan alay sa 'am sa man anan mungok kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aya əna, Yesu nə a san way a tinen sə bayak ata zle. Anga nan, a jan anà ɗowan a ma mac alay ata, a wa: «Slabak! Tavay à wulen su ɗo anaya inde.» Cəna, ɗowan ata a slabak, a tavay jek à wulen su ɗo ataya inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Natiya, Yesu a jan anà miter sə Tawrita ahay tə Farisa ataya fok, a wa: «U no sə cəce pikwen wa: Pə luvon sa man uda nà, cəveɗ inde sa ga mer su way lele awan, kabay cəveɗ inde sa ga mer su way lelibay awan, ɗaw? Təɗe sa tam anan sifa su ɗo ɗaw, bəzi lele nə sə lizen anan sifa ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu a ca patan nerre fok, a jan anà ɗowan a ma mac alay ata kutok, a wa: «Ndəɗoy anan alay anak.» Ɗowan ata a ndəɗoy anan alay anahan cəna, wuret alay anahan kə̀ pəsakak. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Əna, way ata kə̀ cəɓak anan anà ɗo ataya awan. Ta ma nga sa vaɗ apan awiyaway, aday kəkəma ti i ga anan tə Yesu anaw. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","À luvon ataya inde kutok nà, Yesu a ján wanahan à ɓəzlom saa ga amboh. A nahay apan hwiyop tə iɗe cekərkərre sa gan amboh anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iɗe a a cəɗe kutok bine siwaw nà, Yesu a jan anà njavar anahan ahay tə̂ halay nga pə cakay anahan. Ta nay ahay kutok nà, a walay wa kuro nga anahan a cew. A ngaman atan nà, ɗo maslan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sləmay a tinen aya həna: Simon, ɗowan a Yesu a ngaman tə sləmay hinen, Piyer ata awan, aday Andəre, mərak ana Simon, Yakuba, Yuhana, Filip, Bartilome, ");
INSERT INTO mqbNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata, Tomas, Yakuba wan ana Alfa, Simon ɗo maniɗe sə Ruma ahay, ");
INSERT INTO mqbNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tə apan Yuda wan ana Yakuba aday tə apan Yudas Iskariyot, ɗo saa ga ɗaf pə Yesu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pə dəɓa anahan a wa nà, atə Yesu tu ɗo maslan anahan ataya tə dazay à ɓəzlom wa, tə tavay pa man barbara a faɗaɗa. Njavar a Yesu azar aya tinen inde à man ata bayak awan. Aday man su ɗo azar aya ta nay kwa ù kon a azar aya wa, kawa ɗo sə Urəsalima pi zek tu ɗo sə Yahudiya azar aya, tə apan ɗo sə wulen su doh aya bəse tə bəlay ataya, kawa ɗo sə Tirus ahay aday tu ɗo sə Sidon ahay fok, tinen à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ta nay ahay nà, sa naa pak sləmay pa 'am anahan ahay, aday sa naa njaɗ zay si zek a tinen ahay. Aday ɗo setene sə hurvos atan ataya ɗukwen ta nak ahay, aday fok tə mbərak re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kuwaya a gan may sə laman alay à Yesu, anga məgala sa mbar ɗo ahay a nay à winen wa, aday a mbar atan fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Natiya awan, Yesu a ca pə njavar anahan ahay, a jan atan, a wa: «Ataslay mivel inde anga kwanay, ɗo mətawak aya awan, anga bahay a Mbərom ma var a nə anga kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ataslay mivel inde anga kwanay, ɗo may a han pikwen həna ataya awan, anga ki naa rihen pə luvon a inde nà, mboɗol mboɗol mba. Aday ataslay mivel inde anga kwanay, ɗo sə jalay mərava ahay ite asa, anga ki naa mbisen pə luvon a inde mba. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kak həna ɗo ahay ta nak ikwen iɗe, tə rəzlak kwanay à wulen a tinen wa, tə gənahak ikwen, ta jak pikwen 'am lelibay aya anga kə ɗəfen nga pi nen Wan su Ɗo nà, tislen mivel aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pə luvon a ta gak ikwen way matana ataya cəna, tislen mivel, ndəzlen tə ambasay aɗəka, anga Mbərom i varak ikwen magwagway məduwen a à bagəbaga mburom. Anga bije a tinen ahay ɗukwen ta gak anan ahay anà ɗo maja'am a Mbərom ahay kətanan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Əna, kwanay ɗo sə zlile ahay nà, ɗəce inde pikwen, anga ɓa kə njiɗen panan magwagway a kwanay həna pə daliyugo coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kwanay, ɗo ma rah aya həna ataya awan, ɗəce inde pikwen, anga may i naa rawaɗ kwanay pə luvon a inde mba. Kwanay, ɗo à ambasay inde həna ataya awan, ɗəce inde pikwen, anga ki naa yimen ta sə jalay mərava pə luvon a inde mba. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kak həna ɗo ahay ta ja pikwen nə 'am lele aya nà, ɗəce inde pikwen, anga bije a tinen ahay ɗukwen tə varak anan zlangar matanan anà ɗo maja'am mungwalay ataya re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pə dəɓa anahan a wa, Yesu a jan atan asa, a wa: «Kwanay ɗo sə puko sləmay ahay, nen apan ni jak ikwen: Pəlen anan ɗo maniɗe a kwanay ahay, gen anan sumor anà ɗo sa nak ikwen iɗe ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pəsen 'am lele aya anà ɗo sə tahasl kwanay ahay. Gen amboh anà Mbərom anga ɗo sa ga alay tə kwanay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","«Ɗowan a kə̀ dəcak anak pə cakay sləmay kərtek a nà, mbəɗahan anan apan day hinen asa. Kabay ɗowan a kə̀ ngəzərak panak zana anak məduwen a sa pak pi zek ata nà, mbəsakan anan apan tegwere sə zana ata re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","«Ɗowan a kə̀ cəcihek panak wa way nà, kâ sa gan anan azay bay, varan. Kabay ɗowan kə̀ ngəzərak panak wa way anak nà, mbəsakan anan, kə̂ cəce a panan bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","«Way a aday həna ki gen anan may ɗo ahay tâ gak ikwen anan nà, gen atan anan ɗukwen matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Kak kə pəlen nà, ɗo sə pəlay kwanay ahay ɗəkɗek nà, waya saa ngərak ikwen apan anaw? Kwa ɗo sə atahasl ahay ɗukwen tə pəlay nà, ɗo sə pəlay atan ataya re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kabay, kak ki gen anan sumor nə ù ɗo sa gak ikwen sumor ahay ɗəkɗek ata nà, mərdok sə ayanga a kwanay wuraw? Abay ɗo sə atahasl ahay nà, ta ga nə matanan bay cara ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","«Kak kə viren anan gudire nà, anà ɗowan aya aday kə sənen zle ti mba apan sə hamak ikwen anan uda təte ataya nà, waya saa ngərak ikwen apan anaw? Kwa abay ɗo sə atahasl ahay təkeɗe tə varan gudire nà, anà ɗowan aya aday ta san zle ti mba apan sə haman atan anan uda təte ataya biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Əna, aɗəka bay, pəlen anan ɗo maniɗe a kwanay ahay, gen atan sumor, viren atan gudire, əna mənjəna sə bayak sa jəka ti sa haman umo anan uda mba ata awan. Kak ki gen matanan nà, ki i njiɗen magwagway bayak awan, ki təren nə wan a Mbərom sə bagəbaga mburom ahay. Anga Mbərom awan, winen a gan sumor nà, anà ɗo sa ngar pə alay itəbay ataya awan, aday anà ɗo sə huwan ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gen anan sumor ì zek ahay, anga Bəbay a kwanay Mbərom nà, winen ɗo sa gan sumor ù ɗo.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kâ si men anan anan mungok ù ɗo azar aya à mivel inde bay. Ata Mbərom ɗukwen i mak ikwen anan mungok bay ite re. Kə̂ bənen ɗo à mivel inde bay. Ata Mbərom ɗukwen i ban kwanay tə sariya bay ite re. Pəsen anan anan ines anà ɗo ahay, aday Mbərom ɗukwen i pəsek ikwen anan à kwanay aya ite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","«Viren anan way anà ɗo ahay, aday Mbərom ɗukwen i mak ikwen anan uda awan. I mak ikwen uda nà, tə way sə lavay way məduwen awan, aday i tambal anan, i jəjak anan uda nə lele. I rahak ikwen anan cucucœ aday i pəkak ikwen ayak uda à mbulo inde. Mbərom i lavak ikwen ayak uda nà, tə way a kwanay sə lavan uda anà ɗo ahay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu a təkəren atan 'am sə jike hinen asa, a wa: «Ɗo hurof a nà, i mba apan sə bənan alay anà hurof car a təte ɗaw? Kak matanan nà, ti slahay à gujar inde cew maya biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɗo sə jangay nà, i zalay miter anahan bay. Əna ɗo sə jangay ata i ndav anan ajangay anahan aday ti sa lavay tə miter anahan ata kutok ba?» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","A jan atan asa, a wa: «Iken nà, ka mba apan sə canan anà cukol ì iɗe ana mərak anak inde, aday dədom ì iɗe anak a inde nà, ka mba apan sə canan sabay ata nà, angama kutok anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ka mba apan sa jan anà mərak anak: “Ənga, nə gəɓak anan ahay cukol ì iɗe wa”, aday cəkəbay iken a nə dədom ì iɗe anak a inde zləlngəɗɗa nà, kə gəɓak anan ahay wa bay re asanaw? Mbaɗəmbaɗa biɗəka! Ənga, gəɓay anan ahay dədom ì iɗe anak a wa, aday ki ca iɗe lele. Ata aday ki i mba apan sə gəɓay anan ahay cukol iɗe anà mərak anak wa nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Natiya, Yesu a jan atan asa, a wa: «Dədezl si sé lele a nà, i wahay wan lelibay a bay. Dədezl si sé lelibay a ite nà, i wahay wan lele aya bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anga na awan, ɗa san anan dədezl si sé ahay fok nà, pa wan a tinen aya wa. Ɗowan i mba apan sə bənay ahay wan sə buway ì sé sə jəgem wa nà, ibay. Ɗowan sa sa bənay ahay maka ì sé sə iyam wa ɗukwen ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɗo lele a nà, a san sa ja 'am zle ləfeɗeɗe, anga 'am anahan ata a nay ahay nà, kwa à mivel anahan a lele ata wa. Aday ɗo sə huwan ite nà, a ja nə 'am sə huwan, anga 'am anahan ata a nay ahay nà, kwa à mivel anahan a lelibay ata wa re. Bina təbəlem su ɗo a ja nə way sa nay ahay à mivel anahan wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Pə dəɓa anahan a wa asa, Yesu a jan atan, a wa: «Kə ngimen uno “Bahay, Bahay!” nà, aday ki gen way a kawa nen sa jak ikwen aday kî gen ata bay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ni ɗakak ikwen anan həna. Ɗo zənzen a kà nak à man uno, kə̀ slənek 'am uno, kə̀ ɗəfak anan apan lele nà, winen a ga minje nə tə wayaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Winen a ga minje nà, tu ɗo sə ndakay doh. A pak saray a nà, a la məke səɗek dezl pə pəkəraɗ, a pəkay ahay saray su doh anahan pə pəkəraɗ ata wa kutok. Zəlaka a haway ahay, a van nga anà doh a mi ɗezl ata awan, əna doh ata kə̀ mbəzlak bay, anga saray su doh ata ma pak a lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Əna ɗo sə sləne 'am uno aday kə̀ ɗəfak anan apan bay ata nà, winen a ga minje tu ɗo sa ɗezl doh anahan pə yugo mənjəna sa pak a saray a ata awan. Iven a ga, zəlaka a haway ahay, a van nga anà doh ata cəna, doh ata a mbazl sekeɗ sekeɗ kwayan'a.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Natiya kutok, pə dəɓa anahan a wa, Yesu a ndav anan 'am anahan sa jan anà ɗo ahay nà, a slabak, a zla way anahan à wulen su doh sə Kafarnahum. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bahay sə suje ahay a inde à man ata awan, winen nà, Ruma ahay. Ləliwe sə ɓile anahan a inde ɗəvac awan, bəse winen apan i ndav zek coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Matanan, bahay sə suje ata a sləne pə ləbara a Yesu cəna, a slənay ahay məceɗ sə Yahuda ahay à man anahan sa naa gan kem, aday â zla saa mbar anan ɓile anahan ata ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Natiya, ɗo ataya tə dəzley ahay à man a Yesu nà, tə dubok anan, ta gan kem, ta sa jan nà: «Ɗowan ata nà, abay kə̂ slənen anan ayam anahan ite nà, təɗe. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Winen a pəlay ɗo a mənuko ahay tə mindel, aday sə hanan umo doh sə wazay ata ɗukwen, winen a re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Natiya awan, Yesu a zla tə məceɗ ataya kutok. Abay bəse tinen apan ti dəzle àga bahay sə suje ata kutok nà, ɗowan ata a slənay car anahan ahay pə cəveɗ sa naa jan à Yesu nà: «Ba Məduwen, kâ yay nga sa nay ahay bay, anga nen na slak təɗe aday ki dəzley ahay àga nen bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Anga nan, na ca apan nà, ni zlak ayak ta nga uno awan, à man anak a nà, na slak bay. Ja 'am anak a dasl kərtek cəna, ɓile uno i mbar. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nen a aday nà, bahay uno ahay ɗukwen inde, aday nen nə bahay sə lavan nga anà suje ahay bayan aya re. Na sak a jan anà ɗowan a kərtek a: “Zla tiya”, i zla. Na sak a jan anà ɗo hinen: “Hayak à man a anan”, i nay ahay. Na sak a jan anà ɓile uno: “Ga natiya”, i ga anan acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Natiya, Yesu a sləne anan 'am ataya fok cəna, a zlan à nga lele. A mbəɗahay 'am pu ɗo sə pərahan ayak azar ataya, a wa: «Nen apan ni jak ikwen tə ɗiɗek awan, kula na tak anan à nga anà ɗo sa ɗaf upo nga lele kawa ɗowan a anan à wulen su ɗo sə Isəra'ila ahay bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɗo maslan ataya ta ma pə dəɓa àga bahay sə suje ata kutok. Taa tan ayak à nga anà ɓile anahan ata nà, kə̀ mbərak, winen inde zay coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Natiya kutok, pə dəɓa anahan a wa nà, Yesu a zla à wulen su doh a inde tə ngaman Nayin. Njavar anahan ahay, tə ɗo ahay bayak a tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bəse Yesu winen apan i dəzle à wulen su doh ata inde nà, tə zlangay tu ɗo ahay tə gəɓak ahay məsinde, tinen apan ti zla anan à məke. Məsinde ata nà, wan ana mədukway sə uwar a inde, mənduwel awan. Ɗo ahay bayak a tinen apan ti zla tatə uwar ata pa 'am jəvay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aday kutok, Yesu Ba Məduwen a canan à mədukway sə uwar ata cəna, a gan ì zek wa, a jan, a wa: «Njahay way anak, kâ yam bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Cəna, a zla, a laman alay anà lala sə gəɓa məsinde ata awan, ɗo sə gəɓa məsinde ataya tə tavay. Yesu a jan anà məsinde ata, a wa: «Wan ada, nen apan ni jak: Slabak!» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cəna, wan ata a slabak acəkan, a njahay tun, winen apan i ja 'am. Aday Yesu a man anan à alay inde anà may anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ɗo sə canan à way a Yesu a sa ga ata nà, ta ma nga pə ajəjar, tə həran nga anà Mbərom ta sa ja nà: «Ɗo maja'am a Mbərom məduwen a kà nak ahay à wulen a mənuko inde» aday «Mbərom kà nak sa man zek anà mənuko ɗo anahan Isəra'ila ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ləbara sə way a Yesu a sa ga ata a ta 'am təɗay pə daliyugo sə Yahudiya, aday pu kon azar a sa mban atan ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Natiya awan, njavar ana Yuhana ɗo sa gan baptisma anà ɗo ahay ata, tə təkəren anan ləbara sə way a Yesu sa ga ataya fok anà miter a tinen. Yuhana a ngaman anà njavar anahan ahay cew, ");
INSERT INTO mqbNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a slan atan à man a Yesu Ba Məduwen, saa cəce panan: «Iken nà, Almasihu, ɗowan a manay sə sləne i nay ahay mba ata ɗaw? Kabay mâ ba ɗo hinen ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ɗo maslan a Yuhana ataya tə dəzle à man a Yesu nà, tə cəce panan kutok, ta wa: «Yuhana ɗo sa gan baptisma anà ɗo ahay a slənay manay à man anak saa cəce panak: Iken nà, Almasihu ɗowan a manay sə sləne i nay ahay mba ata ɗaw? Kabay mâ ba ɗo hinen ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","À alay ata ite, Yesu winen apan i mbar ɗo sə ɗəvac ahay bayak a, à ɗəvac a tinen ahay wa cara cara, tu ɗo sə setene ahay, aday kə̀ təɓak anan anan iɗe anà hurof ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu a mbəɗahan atan apan, a wa: «Zlen, təkəren anan anà Yuhana nà, way a kwanay sə canan aday sə sləne: Hurof ahay tə təɓak iɗe, vədal ahay tinen apan ti zla tə saray a tinen, aday ɗo mə dugwaɗ aya ɗukwen, zugol inde patan sabay anga tə mbərak. Mədəngazlak ahay, tinen apan ti sləne way tə sləmay a tinen ahay re, ɗo ma mac aya tə slabakak ahay à məke wa, aday ɗo mətawak aya, tə slənek ləbara sa 'am mugom awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Zay i təran anà ɗo aday kə̀ mbəsakak sa ɗaf upo nga itəbay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pə dəɓa ana ɗo maslan a Yuhana ataya sa zla way a tinen ata wa nà, Yesu a dazlan sa jan 'am ana Yuhana anà man su ɗo ata awan, a wa: «Ki zlen à kiɓe à man sa saf inde nà, saa cay ahay pa maw? Pə gusuko aday maɗ winen apan i ɓal anan ata ɗaw? A'ay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Əna aday ka si cen ahay nà, pa ma kutok anaw? Pu ɗo aday winen ma pak zana kəlfeɗeɗe aya ata ɗaw? Ɗo sa pak zana kəlfeɗeɗe aya aday tinen zlile aya ata ɗukwen, mə njahay aya way a tinen à gala bahay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aka aday ka si cen ahay nə pa ma kərtek a kutok anaw? Pu ɗo maja'am a Mbərom biɗaw? Ayaw, winen ɗo maja'am a Mbərom acəkan, aday nen ni jak ikwen nà, winen a zalay ɗo maja'am a Mbərom ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Anga 'am inde mə vinde à Deftere a Mbərom inde, pə winen. Mbərom a wa: “Həna ni slan ɗo maslan uno, i lahak pa 'am saa ndakak anan cəveɗ lele.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu a jan atan asa, a wa: «Nen ni jak ikwen ite nà, ɗowan inde mə wahay a pə daliyugo sə zalay Yuhana nà, ibay. Aya əna, ɗo ma kac awan à bahay a Mbərom inde ata ite nà, winen a zalay anan Yuhana tə məduwen.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ɗo ahay, tu ɗo sə cakal jangal aya təke fok, tə sləne 'am ataya cəna, tə sənak way a Mbərom ahay fok nà, lele aya awan, bina tə ngəmak baptisma ana Yuhana coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Əna Farisa ahay tə miter sə Tawrita ahay, tə təmahak kawa ana Mbərom sa gan may tâ ga ata bay, bina tə ngəmak baptisma ana Yuhana ata itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu a ja asa re, a wa: «Ɗo a wuswes anaya həna ata nà, ni ga atan minje nà, ta maw? Ta ga minje nə tə wayaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ta ga minje tə gwaslay mə njahay aya pə zavay sə wulen su doh, tinen apan ti zlahan ì zek ahay, ta sa ja nà: “Ma fak ikwen ayak gungozl, kə gərven bay. Ma fak ikwen ayak gingec, kə yimen bay re!” ");
INSERT INTO mqbNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Anga Yuhana a nay ahay, winen a sa mahay bay, a taa ga sumaya re. Əna ki wen: “Winen mə vaway nga awan”. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Əna nen, Wan su Ɗo, na nay ahay, na pa ɗaf kəray, na sa way kəray nà, ki wen: “Cen apan! Ɗowan a anan nà, ɗo sə kutov, ɗo sə vaway nga, aday winen car su ɗo sə cakal jangal ahay pi zek tu ɗo sə ines ahay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aya əna, ɗo ahay ti san kəlire ana Mbərom winen lele, anga ti canan anà mer su way anahan sa ga ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Natiya kutok, ɗowan a inde tə ngaman Simon, winen Farisa ahay. A ngaman à Yesu saa pa way àga winen miya awan. Yesu a zla àga ɗowan ata, tə njahay sa pa way pə kərtek a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uwar a inde à wulen su doh ata awan, winen nà ɗo sə atahasl. A sləne sa jəka Yesu winen apan i pa way àga Simon, Farisa ahay ata cəna, a nay ahay àga ɗowan ata awan, tə amar sə wurde anahan a à dunguzlok inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Uwar ata a tavay à dəɓa ana Yesu bəse à man sə saray anahan. Winen apan i yam gweguzguzze, iɗe sə ayam anahan a dazlan sə banay anan saray a Yesu kusler kusler. A ma nga sə təlkaɗ panan iɗe sə ayam anahan ata tə sibœk sa nga anahan, a ban anan saray a Yesu həmbok, a pak apan amar sə wurde ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Natiya kutok, Simon, Farisa sə ɗowan a sə ngaman ayak à Yesu àga winen ata, a canan à way a matanan ata cəna, a jalay ta nga ta nga, a wa: «Ɗowan a anan i ga nà, ɗo maja'am a Mbərom bay aday bina, a san sa jəka uwar sə laman a anan ata, winen ɗo sə atahasl ɗukwen a san bay ata nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pa 'am anahan ata kutok, Yesu a jan, a wa: «Simon, way inde u no sa jak.» Simon a mbəɗahan apan, a wa: «Miter, ja asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu a jan kutok, a wa: «Ɗowan a inde nà, gudire anahan inde pə ɗo ahay cew. Pu ɗo kərtek awan, dala anahan apan mbulo səkat ɗara, pu ɗo hinen ite, mbulo kwa kuro ɗara. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Əna ɗo sə dala ata a ca patan cew miya ɗukwen, ɗowan saa mba apan sə haman anan dala anahan ata təte nà, ibay. Anga nan, a mbəsakan atan anan dala anahan ata fok sə coy awan. Əna à wulen su ɗo a cew ataya wa nà, iken kə bayak saa pəlay anan ɗowan ata tə mindel nà, ɗowan a ɗuwuraw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon a mbəɗahan apan, a wa: «I ga nə, saa pəlay anan ɗowan ata tə mindel nà, ɗo aday winen sə mbəsakan anan dala zek məduwen a ata awan.» Yesu a jan apan kutok, a wa: «Ka jak 'am ɗiɗem awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pə dəɓa anahan a wa nà, Yesu a mbəɗa 'am pə uwar ata awan, aday a jan anà Simon, a wa: «Na wa, kə canak anan anà uwar a anan ba? Nen na nak àga iken, əna kə varak uno a'am aday anga nə̂ banay anan saray uno ahay bay. Əna winen kə̀ banak uno anan saray tə iɗe sə ayam anahan, aday pa təlkaɗ panan tə sibœk sa nga anahan re biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aday iken nà, kə təmahak nen ta sa ban nen həmbok həmbok bay. Əna winen nà, kwa anuno sa nay ahay àga iken nà, kə̀ mbəsakak sə buno anan saray uno ahay həmbok həmbok bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iken kə mbəɗak uno amar sə wurde pa nga bay, əna winen kə̀ mbəɗak amar sə wurde pə saray uno ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anga nan, nen apan ni jak: Winen nà, i pəlay nen tə mindel, anga ines anahan ahay bayak a ɗukwen mə pəse aya awan. Əna ɗo aday ines anahan ahay mə pəse a mənjœk akinen ata nà, winen ɗukwen i pəlay nen tə mindel bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Natiya pə dəɓa anahan a wa kutok, Yesu a jan anà uwar ata, a wa: «Mazar uno, ines anak ahay mə pəse aya coy.» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɗo a sa pa way pə kərtek a tə winen ataya fok tə dazlan sə jalay ta nga ta nga, ta wa: «Jəba su ɗo wura aday kwa sə pəse ines pu ɗo wa ɗukwen a mba apan re ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Əna Yesu a jan à uwar ata asa, a wa: «Aɗaf nga anak pi nen kə̀ təmak iken. Zla tə zay!» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Natiya, pə dəɓa anahan a wa a njahay əngal nà, Yesu a zla tə njavar anahan a kuro nga cew ataya awan, à wulen su doh ahay, aday pu kon pu kon. A ɗakay anan ləbara sə bahay a Mbərom mugom awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Uwar aya inde tə pərahan azar. Uwar ataya nà, ɓa Yesu kə̀ mbərak atan à ɗəvac a tinen ahay wa, aday kə̀ rəzlak ahay setene à nga a tinen ahay wa re. À wulen sə uwar a sə pərahan azar ataya inde nà: Mariyama, dəna sə Magədala ahay, aday Yesu sə rəzlay ahay setene ahay cuwɓe à nga anahan a wa ata awan; ");
INSERT INTO mqbNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tə apan Yuwana, uwar ana Huza, ɗo məduwen a sa ga mer su way àga Hiridus; tə apan Suzana; aday tə apan azar sə uwar aya bayak a re. Uwar ataya ta mak anan zek à Yesu tə njavar anahan ahay tə zlile a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pə wulen su doh ahay wa cara cara, ɗo ahay bayak a tə halay nga à man a Yesu. A dazlan sa jan atan 'am tə jike, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɗowan inde a zla à guvo, saa casl ndaw. Winen apan i casl ndaw ata kutok nà, zahav a guce panan pə cəveɗ. Ɗo ahay tə dədasl anan, aday məvuhom ahay tə ɗagay anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zaav sa ndaw azar a a guce panan pə saray pəkəraɗ. A hay ahay, aday a kuray kwayan'a, anga man ata mə naaz a sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zahav mə mbəsakan a à alay inde ata a guce à wulen sə adak inde. Ta ha cəna, ta har pi zek tə adak, əna adak a bənan mbiyeɗ, ndaw ata kə̀ nahak bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Əna azar sə zaav a mə mbəsak ata, a guce pə yugo lele awan. A hay, a har, a nah wan pə hawal sa ndaw kərtek a nà, səkat səkat.» Pə dəɓa sa 'am ata wa asa nə, a jan atan 'am tə məgalak awan, a wa: «Sləmay inde pə ɗowan a nə, â sləne 'am a anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pə dəɓa anahan a wa kutok nà, njavar anahan ahay tə cəce panan, ta wa: «Jike sa 'am anak a sa ga sə manan ata nà, a nan sa ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu a mbəɗahan atan apan, a wa: «Kwanay nà, way mi ɗer aya à bahay a Mbərom a inde ata nà, winen a kà gak ikwen panan akar sa 'am sə bahay anahan a coy. Əna ɗo azar aya nà, ti sləne way ahay fok nà, si ta 'am sə jike. Anga nan: Tinen apan ti ca apan, əna tə canan bay, aday ti pak apan sləmay, əna tə sləne bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Coy, Yesu a wa: «'Am sə jike anan a nan sa ja nà, natiya awan: Zaav sa ndaw nà, 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ɗo azar aya ta ga minje ta ndaw mə guce pə cəveɗ ata awan. Tinen nà, tə sləne anan 'am a Mbərom bəse, əna Fakalaw i nay, i wuɗihey anan 'am ata à mivel a tinen wa, anga aday tâ ɗaf apan nga sa tam bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ɗo azar aya ite, ta ga minje tə zaav sa ndaw mə guce pə saray pəkəraɗ ata awan. Tinen nà, tə slənek 'am a Mbərom cəna, tə təma anan tə ataslay mivel awan. Əna 'am ata a pak sləlay a mivel a tinen inde bay. Zanaka ɗəce sə daliyugo kà nak, tə way sa njak ɗo anahan aya cəna, ti mbəsak cəveɗ sa 'am a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ɗo azar aya ite, ta ga minje tə zaav sa ndaw sə guce à wulen sə adak ahay inde ata awan. Tinen tə slənek 'am a Mbərom nà, way sə daliyugo ahay inde cara cara ti njak atan. Kawa ti jalay nga pə way sə daliyugo ahay, ti gan may anà zlile sə daliyugo, ti taslay mivel sa ga ubor pə way sə daliyugo ahay cara cara. Way ataya ti bənan mbiyeɗ anà 'am a Mbərom à mivel a tinen inde, aday 'am ata â zla nga uho saa nah bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Əna ɗo azar aya ite asa, tinen ta ga minje tə zaav sa ndaw sə guce pə yugo lele ata awan. Tə sləne 'am a Mbərom nà, ta ban anan tə mivel kərtek a lele. Kwa ɗəce kə̀ njaɗak atan ɗukwen, tə mbəsak bay re. Ta ban mivel, aday ta zla nga uho pa 'am a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pə dəɓa anahan a wa kutok, Yesu a jan atan asa, a wa: «Ɗowan saa ɗaf uko pə lalam aday i ɗer anan ta sə hərok apan tasa, kabay i ɗərek anan ayak ù vo lala nà, ibay asanaw? I ɗaf anan bugol nà, pa man jəgaɗ awan, anga aday iɗe jiyjay â dəvan anà ɗo sa zla ù doh ataya fok lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ayaw, way a mi ɗer a aday ɗowan i canan bay nà, i ga inde sabay. Akar sa 'am ma ja aya bay ɗukwen, i kay zek pa 'am su ɗo ahay à man ipec inde.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A jan atan asa, a wa: «Gen wurwer pə way a kwanay sə sləne ahay. Anga ɗo kə̀ təɓak anan sləmay sə sləne 'am nà, Mbərom i zəgahan anan sə sləne 'am ite re. Aday ɗo kə̀ tacak anan sləmay, anga a nan sə sləne 'am bay nà, Mbərom i təma panan mənjœk anahan a abay sə bayak, kə̀ slənek anan coy ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mərak a Yesu ahay tatə may anahan ta nay ahay à man anahan, əna ta mbak apan sə dəzle dezl à man anahan a bay, anga ɗo ahay inde bayak a kə̀ zalak. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Anga nan, ɗo ahay ta jan à Yesu, ta wa: «Atə may anak tə mərak anak ahay tinen mə tavay aya uho, ta gak may.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Əna Yesu a mbəɗahan atan apan, a wa: «Pi nen nà, atə may uno tə mərak uno ahay nà, ɗo sə sləne 'am a Mbərom ahay, aday sə ɗəfan apan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pə luvon a inde asa, Yesu a ján à kwalalan inde tə njavar anahan ahay, a jan atan, a wa: «Takasuko pa day uho!» Ta ra zek, ta zla. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","À alay a tinen apan ti takas tə kwalalan mba ata ite, Yesu a njak ahan à kwalalan ata inde. Zaməma nà, vəvara əduɗ a slabakay ahay pa nga sə bəlay ata awan, a'am a ma nga sa rah anan kwalalan, aday bəse tinen apan ti lize coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Natiya njavar anahan ahay tə həɗek pə cakay anahan, tə pəɗek anan, ta jan, ta wa: «Miter, miter! Aday mənuko apan ɗi lize bəse coy asanaw!» Cəna, Yesu a slabak, a gafan 'am anà atə maɗ tə məsugurndolon sə a'am ahay tə məgalak awan. Cəna, a'am a tavay ɗekek, awan a ɓal sabay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Natiya Yesu a jan anà njavar anahan ataya awan, a wa: «Kə ɗəfen upo nga jiga nə kəkəmaw?» Njavar anahan ataya ta ma nga pə ajəjar, a gan atan masuwayan. Ta ja à wulen a tinen, ta wa: «Ɗo wura həna anan anaw? A gafan 'am anà atə maɗ tə a'am ahay ɗukwen, tə ɗəfan apan re ata nà, jəba su ɗo wura kəlanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pə dəɓa anahan a wa kutok, atə Yesu tə njavar anahan ahay tə takas pə day hinen, tə dəzle ù kon sə Gerasina ahay. Kon ata, winen ɗinger pa 'am anà daliyugo sə Galile. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu a dazay ahay à kwalalan wa bine siwaw nà, ɗo su kon ataya inde a nay ahay pə cakay anahan kwayan'a. Ɗowan ata nà, setene ahay ta taa ban anan. A taa pak zana pi zek sabay, aday a taa nahay agay sabay re. Əna a taa nahay way anahan ahay nà, à wulen sə jəvay ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Abay setene ata a taa ban anan nà, saray bayak a way anahan. Ta taa ɓan anan tə calalaw, alay tə saray a təke, aday tə jaway anan à səsile inde, anga sa gan nga. Tə winen ata təke nà, a slaɗ anan way ataya nduroc nduroc, aday setene ataya tə vawan nga sa haw way anahan à kiɓe re. A canan à Yesu nà, a zlah pi zek tə məgalak awan, a dukwen gərmec ù vo, a wa: «Iken Yesu, Wan a Mbərom sə bagəbaga mburom, kə pəlay nə ma pi nen wa anaw? Na gak anak kem, kâ ga alay ti nen bay ite.» A ja matana ata nà, anga ɓa Yesu kà jak anan anà apasay lelibay ata â nay à ɗowan ata wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu a cəce panan kutok, a wa: «Sləmay anak a nə wayaw?» A mbəɗahan apan, a wa: «Tə ngumo nə Daskalak.» Ɗowan ata a ja matanan ata nà, anga setene ahay inde bayak a ì zek anahan inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Setene ataya tə dubok a Yesu, ta wa: «Amboh, kem â nak ite. Kâ sa razl manay dəren aday mə̂ lize dənam à məke sə mərda inde bay ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","À man ata awan, ɗowan aya inde, tinen apan ti ɓal gadura ahay pa zar kon bayan awan, gadura ataya tinen apan ti rac apa a tinen ahay. Əna setene ataya ta gan kem à Yesu, ta wa: «Kem, amboh, ənga varan umo cəveɗ mâ zla à gadura tiya ataya inde ite.» A varan atan cəveɗ. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Natiya, setene ataya tə zləray à ɗowan ata wa, ta zla à gadura ataya inde cəna, gadura ataya tə pəkay anan ahay ahaw kwa pa zar kon wa, tə dazak ayak kwa pa 'am məgujeguje wa à bəlay inde. Fok a tinen awan, tə lizek à a'am ata inde ɗəɗam. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ɗo sa gan nga anà gadura ataya tə canan à way a sə təra ata cəna, ta haw saa ɗakay anan ləbara sə way a sə təra patan tə gadura a tinen ataya fok à wulen su doh məduwen awan, aday à wulen su doh sə kiɓe ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɗo ahay tə zləray ahay à wulen su doh ataya wa. Ta zla saa ca pə ləbara sə way a sə təra ata awan. Tə dəzley à man a Yesu nà, ta tan à nga anà ɗowan a setene ahay sa nay ahay à winen wa ata, mə njahay a à man a Yesu, winen tə zana pi zek kutok. A san nga anahan zle lele coy. Aday ta ma nga pə ajəjar. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɗo a sə canan anà masuwayan ataya nà, tə təkəren ləbara sə ambar ana ɗowan ata anà ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ɗo su kon ataya ta ma nga sa gan kem à Yesu aday â zla ù kon a tinen wa, anga tə jəjarak tə way ata tə mindel. Natiya kutok, Yesu a ma way anahan à kwalalan inde sa zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","À alay a Yesu winen apan i ján à kwalalan inde sa zla way anahan ata nà, ɗowan a setene sa nay ahay à winen wa ata a gan kem, aday tâ zla maya ite. Əna Yesu a man 'am pi zek wa ta sa jan nà: ");
INSERT INTO mqbNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ma agay, aday kâ sa ɗakan anan anà ɗo ahay way a Mbərom sa gak ataya fok.» A zla way anahan, a ɗakay anan ləbara sə way a Yesu a sa ga anga winen ata à wulen su doh inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pə dəɓa anahan a wa nà, Yesu a takasay ahay bəlay, a may ahay pə day sə Galile kutok. A tan ahay à nga anà ɗo ahay mə halay nga bayak a, tinen apan ti ba anan. Tə təma anan tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","À alay ata kutok ite, ɗowan a inde tə ngaman Zayrus kà zlak ayak à man a Yesu. Winen ɗo məduwen awan, sə lavan nga anà mer su way ù doh sə wazay nà, winen. A nay, a dukwen gərmec ù vo anà Yesu, a gan kem aday â zla àga winen ite, ");
INSERT INTO mqbNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","anga dəna anahan a inde mənduwel a ma va kuro nga cew awan, winen apan i mac bəse coy. À alay a Yesu winen apan i zla àga ɗowan ata kutok nà, ɗo ahay bayak a tinen apan ti ngəɗec anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uwar a inde à wulen su ɗo ataya ite, mez winen apan i pəkan ahay à kutov wa. Kà gak a pi zek nà, ava kuro nga cew. Kə̀ lizek anan dala anahan fok sa haw a pi zek wa ɗukwen, ɗowan kà mbak apan sa mbar anan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uwar ata a həɗəkey à dəɓa a Yesu, a laman anà 'am sə zana a Yesu pec. Cəna, cənjəlan ɗəvac anahan kə̀ ndalak panan. Kə̀ mbərak, mez a pəkan ahay à kutov wa sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Natiya, Yesu a cəce pu ɗo sə pərahan azar ataya wa, a wa: «Waya sə lumo anaw?» Kuwaya a ma nga sa ja nà: «Nen bay.» Əna Piyer a mbəɗahan apan, a wa: «Miter, ɗo ahay nà, tinen apan ti ngəɗec iken kutok nà, aday ki cəce waya sə lamak anaw re asa ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Əna Yesu a jan atan, a wa: «Ayaw, əna nen a na san ɗowan kə̀ lamak uno nà, anga məgala inde kà nak ahay ì nen wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Uwar ata a ca apan nà, Yesu kə̀ sənak apan, i mba apan sa ɗer panan zek sabay. Anga nan, a nay ahay pa 'am anahan sləɓslaɓ tə ajəjar awan, a dukwen gərmec ù vo anà Yesu à wulen su ɗo ataya inde. A ɗakan anan anà man su ɗo ata ləbara anahan sə laman anà Yesu, aday à alay anahan sə laman ata nà, a mbar kwayan'a ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pə dəɓa a 'am anahan ata wa nà, Yesu a jan anà uwar ata, a wa: «Mazar uno, aɗaf nga anak pi nen ata kə̀ mbərak iken! Zla agay tə zay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","À alay a Yesu winen apan i ja 'am ata mba cəna, ɗo maslan a nay ahay àga Zayrus wa, winen ɗo sə lavan nga anà doh sə wazay ata awan. A jan anà Zayrus a nà: «Dəna anak nə, kə̀ ndəvak zek coy. Həna nà, kə̂ vawan nga anà miter sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu a sləne 'am ana ɗo maslan ata cəna, a jan anà Zayrus nà: «Kə̂ jəjar bay, ɗaf upo nga lele cəna coy! Dəna anak nà, i mbar.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tə dəzle àga Zayrus kutok nà, Yesu a mbakan cəveɗ sa zla ù doh tatə winen a nà, anà Piyer, anà Yuhana tə Yakuba, tə apan anà bəbay a dəna ata tə may anahan cəna coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yesu a tan ayak à nga anà ɗo ahay bayak a tinen apan ti yam dəna ata, tuhhwa. Əna Yesu a jan atan, a wa: «Kə̂ yimen bay, anga dəna a anan kə̀ məcak bay. A njak ahan ca.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Man su ɗo ataya tə mbasay apan, anga ta san zle, dəna ata nà, abay kə̀ məcak wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Əna Yesu a həɗəken ayak pə cakay anà dəna ata awan, a bənan alay, a ja tə məgalak awan, a wa: «Dənama, na jak nà, slabak!» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Cəna, dəna ata a mbar, a slabak acəkan. Coy Yesu a jan atan kutok: «Viren anan ahay way sa pa aday â pa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Way a Yesu a sa ga ata a gan masuwayan anà bəbay a dəna ata tə may anahan a tə mindel. Əna Yesu a jan atan, a wa: «Way a sə təra a anan fok nà, kâ si jen anà ɗowan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Natiya pə luvon a inde, Yesu a halan nga anà ɗo maslan anahan a kuro nga cew ataya awan. A varan atan məgala tə mazlaɓ awan, sa razl setene ahay, aday sa mbar anan ɗo sə ɗəvac ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A slan atan saa ɗakay anan ləbara sa 'am sə bahay a Mbərom, aday ta sa mbar anan ɗo sə ɗəvac ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A slan atan, ta sa jan atan kutok, a wa: «Zlen! Əna way kawa dəker, mbulo, way sa pa, aday dala nà, kâ sa gəɓen à alay inde bay. Aday ki gəɓen zana pi zek ɗukwen kərtektəkke re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kə dəzlen à man a aday tə təmahak kwanay àga ɗowan a nà, kâ sa həɗəken way a kwanay àga ɗowan ata wa bay. Njihen nà, àga ɗowan a sə təma kwanay àga winen ata awan, hus pə luvon a kwanay saa zla way a kwanay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Əna aday ɗo sa man ataya tə təmahak kwanay bay ite nà, zlen way a kwanay à man ata wa, aday kə̂ bəzləmen a morbodok su kon a tinen pə saray a kwanay ahay wa, anga aday tâ san pi zek tinen tə ines aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Natiya, ɗo maslan anahan ataya ta ra zek, ta zla pu kon pu kon sə ɗakay anan ləbara mugom a sa 'am sə bahay a Mbərom kwa aha fok. Aday tinen apan ti mbar anan ɗo sə ɗəvac ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Natiya kutok, Hiridus, bahay sə Galile, a sləne pə ləbara si mer su way a Yesu a sa ga tə njavar anahan ahay ataya awan. Aday ɗo ahay tinen apan ti təker ləbara anahan ata re nà, a wusen nga tə mindel. Anga ɗo azar aya awan, tinen apan ti ja nà, ta wa: «I ga nà, Yuhana ɗo sa gan baptisma anà ɗo ahay ata kà mak uho.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ɗo azar aya ite ta wa: «Sə sləray ahay nà, Eliya.» Ɗo azar aya ite asa ta wa: «I ga nà, ɗo kərtek à wulen su ɗo maja'am a Mbərom sə kwakwa ataya kà mak uho.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Əna Hiridus nà, a wa: «Aday Yuhana ɗo sa gan baptisma anà ɗo ahay ata nà, nə gəɗak panan nga. Aday sa ga mer su way matana ataya, hus sləmay anahan a saa ndar ndənndan ata nə waya asa anaw?» Natiya Hiridus a gan may sə canan anà Yesu aday â san anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Natiya pə dəɓa anahan a wa nə ɗo maslan a Yesu a sa slan ataya ta mak ahay à man anahan. Tə ɗakan anan way a kawa ana tinen sa gay à man ataya wa ata fok. Aday Yesu a ngaman atan taayak a tinen a, ta zla zaɗ, bəse tə wulen su doh a sə ngaman Baytisada ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Natiya, ɗo ahay ta san patan tinen tiya nà, ta zla, ta njaɗ anan Yesu tə njavar anahan ahay à man ata awan. Yesu a təma atan, a ɗakan atan anan ləbara sa 'am sə bahay a Mbərom. A mbar anan ɗo a sa gan may anà zay a tinen ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Natiya kutok, suko a ga lele nà, ɗo maslan ataya ta zla pə cakay a Yesu, ta jan nà: «Suwan, mbakan cəveɗ anà ɗo ahay tâ zla pə culok ahay, à wulen su doh ahay, anga aday tâ saa pəlay way sa pa, ta man sə nahay aya, bina mənuko à man kiɓe inde asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Əna Yesu a mbəɗahan atan apan, a wa: «Kwanay a viren atan way sa pa awan.» Tə mbəɗahan apan, ta wa: «Inde pumo nà, tapa sa pen ahay ɗara tə apan kəlef ahay cew. Kak si ka gan may mâ zla à wulen su doh ahay inde, saa pəlay ahay way sa pa aday ata bina, həna anan i slan anà man su ɗo a anan bay asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ɗo sa pa way à man ata ɗukwen, tinen mə baslay a nà, mungol a ɗəkɗek aday nà, ta ga mbulo ɗara. Əna Yesu a jan anà njavar anahan ahay, a wa: «Jen anà ɗo ahay tə̂ njahay njəɓukɓok. Man kərtek cəna, i ga ɗo ahay kwa kuro ɗara, kwa kuro ɗara.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Njavar anahan ataya, ta ga mer su way a kawa ananahan a sa jan atan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu a gəɓa anan tapa sa pen a ɗara ataya, tə kəlef a cew ataya awan. A ca iɗe à mburom, a ngəran ayak anà Mbərom. A gəzla anan ì zek wa, a varan anan anà njavar anahan ahay aday tə̂ gəzlan anan anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɗo ataya fok ta pak, tə rahak ɓah ɓah. Tə halan nga anà mə mbəsak a patan wa ata awan, aday kə̀ rahak anan cəkarak ahay kuro nga anahan a cew re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pə luvon a inde, Yesu winen apan i ga amboh taayak anahan awan. Aday njavar anahan ahay ɗukwen tinen inde bəse à man anahan kutok. Yesu a cəce patan wa, a wa: «Ɗo ahay ta ja pi nen nà, nen nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tə mbəɗahan apan ite, ta wa: «Ɗo hinen ahay ta wa, iken nà, Yuhana ɗo sa gan baptisma anà ɗo ahay ata awan. Ɗo maza aya ta wa, iken Eliya, ɗo maja'am a Mbərom. Ɗo azar aya ɗukwen ta ja nà, iken ɗo kərtek à wulen su ɗo maja'am a Mbərom ahay sə kwakwa ataya sa may uho.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aday Yesu a cəce patan wa asa, a wa: «Aday kwanay a nà, ki wen nen nà, wayaw?» Natiya kutok nà, Piyer a mbəɗahan apan, a wa: «Iken nə Almasihu, ɗo ana Mbərom sə slənay ahay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu a sləne 'am ata cəna, a gafan atan 'am, a wa: «Əna kâ sa ɗiken anan anan anà ɗowan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A jan atan asa, a wa: «Bəlaray nen Wan su Ɗo nà, ni ga ɗəce bayak awan. Aday məceɗ sə Yahuda ahay, tə bahay sə gəɗan dungo anà way ahay anga Mbərom, tatə miter sə Tawrita ahay ti lar nen, aday ɗo ahay ti vaɗ nen. Əna pə luvon maakan anahan a cəna, nen ni slabakay ahay à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Natiya, pə dəɓa anahan a wa kutok nà, Yesu a jan ù ɗo sə pərahan azar ataya fok, a wa: «Kak ɗowan a a nan sə pəruho azar nà, â mbəsak sə bayakan way anà nga anahan, â tavak dədom anahan mə zləlngaɗ ata kəla luvon fok, â pəruho azar. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Anga kâ nak anan anà ɗowan a sa tam anan sifa anahan nà, i lize anan aɗəka. Əna ɗowan a kə̀ lizek anan sifa anahan anga nen nà, i tam anan sifa anahan aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bina, ɗo kà sak a njaɗ anan way sə daliyugo a anan fok anà winen, aday sifa anahan a nà, kə̀ lizek anan nə, sa gan dəɗaffa nà, ma mba asa anaw? Ibay! ");
INSERT INTO mqbNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","«Asa, kak ɗowan a kà gak waray sə ɗakay anan sləmay uno aday sə ɗakay anan 'am uno ahay nà, nen ni ga anan winen kəkəmaw? À alay a aday na mak ahay tə mazlaɓ uno awan, tə mazlaɓ ana Bəbay uno Mbərom, aday tə maslay anahan cəncan aya ata nà, nen Wan su Ɗo ɗukwen ni naa pəkan waray ì iɗe cite. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","«Nen apan ni jak ikwen tə ɗiɗek awan: Ɗowan aya inde à man a anan, ti mac mənjəna sə canan anà bahay a Mbərom bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Natiya kutok, a njahay pə dəɓa ana 'am a tinen ata wa way sə lumo kərtek nà, Yesu a gəɓa pə azar, Piyer, Yuhana tə Yakuba. A ján à ɓəzlom saa ga amboh. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","À alay a winen apan i ga amboh à ɓəzlom à man ata bine siwaw nà, zek anahan a mbəɗa, aday zana anahan ɗukwen a dav herre kweɗekkweɗek. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Cəna, ɗowan aya inde cew, atə Musa tə Eliya, tə sləray à jiyjay sə mazlaɓ a Mbərom inde. Tinen apan ti kaɗ bala tatə Yesu, pə amac anahan saa təra à wulen su doh sə Urəsalima, anga sa ndav anan wa mer su way anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Cəkəbay Piyer tə Yuhana, aday tatə Yakuba nà, tinen ma njak ahan aya awan. Ahan ata kə̀ gumak atan tə mindel, əna tə pəɗek pə ahan wa nà, tə canan anà jiyjay sə mazlaɓ a Yesu, tu ɗo a cew ataya mə tavay aya pə cakay a Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","À alay a ɗo a cew ataya tinen apan ti gəzla nga tatə Yesu ata nà, Piyer a jan à Yesu, a wa: «Miter, mənuko à man a anan nə sumor awan. Natiya mi ngaray jawjawa ahay maakan: kərtek awan anga Musa, kərtek a ite anga Eliya, aday mədakwidok a nà, anga iken awan.» Piyer a ja 'am anahan ata nà, so, bina a gəzlan alay anà 'am anahan ata bay jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","À alay a Piyer winen apan i ja 'am ata nà, mugudongudon a dazay, a van atan nga sərdədek. Njavar a Yesu ataya ta ma nga pə ajəjar anga mugudongudon a sa van atan nga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cəna, 'am a ndəray ahay à mugudongudon ata wa, a wa: «Wita nà, wan uno, ɗo nen sə walay anan ata awan. Slənen anan anan 'am anahan!» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pə dəɓa ana Mbərom sa jay ahay 'am à mugudongudon ata wa cəna, tə canak anan anà ɗowan miza pa nga a Yesu wa sabay. À alay ata ite, njavar anahan ataya tə njahay way a tinen tete, tə təkərek anan anan ləbara sə way a tinen sə canan ata anà ɗowan bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iɗe a cəɗe sidew a kutok, Yesu a dazay ahay à ɓəzlom wa tə njavar anahan a maakan ataya awan. Tə dəzley ahay cəna, ɗo ahay bayak a ta zla saa zlangay tə tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","À wulen su ɗo a bayak ata wa, ɗowan a inde à man ata a zlah pi zek tə məgalak awan, a wa: «Miter, amboh. Na gak anak kem, anga wan uno mənduwel a həna anan â gak ì zek wa ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Məhərvov a taa ban anan. À alay a aday kə̀ bənak anan nà, a ma nga sa zlah pi zek, winen apan i nguce, aday ɗukwen mumbof a rahan à 'am inde nə popo. Winen apan i ga anan alay ta wan a anan tə mindel, aday kə̀ bənak anan ɗukwen, a man uda bəse bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na gak anan kem anà njavar anak ahay, aday tâ razl panan apasay sə məhərvov ata ite ɗukwen, ta mbak apan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu a jan atan, a wa: «Kwanay nà, aɗaf nga a kwanay ma kac awan kələɗaw? Kə sənen anan cəveɗ a Mbərom bay re. Ni njahay tə kwanay, aday ni səmen anà way a kwanay ahay nə hus à siwaw?» A jan anà bəbay a wan ata kutok, a wa: «Ənga, hayak anan ahay wan anak ata à man uno awan aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","À alay a wan ata winen apan i nay ahay à man a Yesu ata nà, apasay sə məhərvov ata a ban anan kwayan'a ɓəram à məndak. Winen apan i nguce, nguc nguc. Cəna, Yesu a lar angəraz pə apasay sə məhərvov ata tə məgalak awan. Kwayan'a, a ndalay panan sə coy. A man anan à alay inde à bəbay anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Way a sə təra ata a gan masuwayan anà ɗo sa man ataya tə mindel, anga məgala sə mazlaɓ a Mbərom ata awan. Əna ɗo ataya fok tinen apan ti jalay pə way a Yesu sa ga ataya mba nà, Yesu a jan anà njavar anahan ahay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Pəken sləmay lele pa 'am uno nen a saa jak ikwen a həna ata awan. Nen Wan su Ɗo nà, ti varan nen à alay inde anà ɗo sə daliyugo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Əna njavar anahan ataya tə sənak nga sa 'am anahan a sa jan atan ata bay. Nga sa 'am ata mi ɗer a patan wa, anga aday tâ san anan 'am anahan a sa jan atan ata bay. Aday ɗukwen zlawan a gan atan sə cəce panan 'am anahan ata re. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Natiya, pə dəɓa anahan a wa asa kutok, njavar anahan ahay tinen apan ti vaɗ awiyaway pa 'am sa jəka waya məduwen à wulen a tinen inde anaw. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kwayan'a, Yesu a san way sə mivel a tinen ata zle coy. A ngaman ayak anà wan cəɗew awan, a tavay anan pə cakay anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A jan atan, a wa: «Kuwaya kà sak a təma jəba sa wan kawa həna anan ataya kərtek a anga sləmay uno nà, ɗowan ata a təma nə nen awan. Aday ɗowan a kə̀ təmahak nen ite nà, a təma nə Mbərom, ɗo sə slənay ahay nen ata awan. Bina ɗowan aday həna winen cəɗew a à wulen a kwanay inde fok ata nà, winen nə ɗo məduwen a kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhana a jan anà Yesu, a wa: «Miter, ma tak anan à nga anà ɗowan a inde winen apan i razl apasay lelibay aya à ɗo ahay wa tə sləmay anak. Əna mə gafak anan 'am, anga winen ɗo a mənuko bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Əna Yesu a mbəɗahan apan, a wa: «Kə̂ gifen anan 'am bay. Ɗo aday a nak ikwen iɗe bay ata nə, winen nə ɗo a kwanay asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Natiya, alay a Yesu saa zla pə daliyugo wa à mburom winen apan i slay ahay bəse coy ata nà, a jan ì zek anahan nə ni zla à Urəsalima aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A slan ɗo maslan anahan ahay pa 'am. Ta zla à wulen su doh sə Samariya a inde. Tə dəzle nà, tə pəlan man sə nahay à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ɗo sə wulen su doh ataya tə təmahak a bay, anga ɓa tə slənek, a nan sa zla à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Əna atə Yakuba tə Yuhana, njavar anahan ahay, tə canan anà way ataya nà, ta jan anà Yesu, ta wa: «Ba Məduwen, a nak mâ jan ù uko â dazay ahay patan à mburom wa aday â lize atan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Əna Yesu a cak ayak patan basl tə iɗe, a jan atan, a wa: «Ata nà, inde pikwen nə apasay wuraw? ");
INSERT INTO mqbNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Anga nen Wan su Ɗo nà, na nay ahay anga sə lize anan sifa sə ɗo ahay bay, əna anga sa tam anan.» Cəna, ta zla way a tinen ù kon hinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Natiya, tinen pə cəveɗ sa zla mba ata nà, ɗowan a inde a jan à Yesu, a wa: «Nen ni pərahak azar kwa aha fok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu a sləne 'am ana ɗowan ata nà, a jan, a wa: «Hwehwe ahay nà, məke a tinen ahay inde, məvuhom sa nga mburom ahay ɗukwen, doh a tinen ahay inde, əna nen Wan su Ɗo nà, man sə nahay uno inde saa man uda ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A jan anà ɗo hinen asa, a wa: «Hayak, pəruho azar!» Əna ɗowan ata a mbəɗahan apan, a wa: «Ba Məduwen, u no sə pərahak azar, əna vuro cəveɗ nâ zla agay, nâ saa lay anan ahay bəbay uno aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu a mbəɗahan apan, a wa: «Mbəsak anan məsinde ahay tâ la məsinde a tinen ahay. Əna iken, zla saa ɗakay anan ləbara sa 'am sə bahay a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɗo hinen ite a jan à Yesu, a wa: «Ba Məduwen, u no sə pərahak azar, əna mbuko cəveɗ saa jan ahay 'am pi zek wa anà ɗo su doh uno ahay aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu a mbəɗahan apan ite, a wa: «Ɗo kə̀ bənak alay pi jœ sa ga mer aday winen apan i ca iɗe à dəɓa kurkwer nà, kà slak saa ga mer su way à bahay a Mbərom inde bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pə dəɓa anahan a wa nà, Yesu a walay njavar maza aya awan, tinen kwa kuro cuwɓe nga cew. A slan atan pa 'am anahan cew cew à wulen su doh ahay inde, aday ta man anahan a sa zla uda ataya fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A slan atan ta sa jan atan, a wa: «Way sa pa inde à guvo bayak a sə halan nga, əna ɗo sə halan nga aya ta kac ike. Suwan gen anan kem anà bahay sə guvo awan, â zəga anan ɗo ahay à guvo, anga sə halan nga anà way sa pa. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","«Zlen, na slan kwanay kawa wan sə təman ahay à wulen sə kəla kiɓe ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Əna way kawa dala, mbulo, təkarak nà, kâ sa gəɓen à alay inde bay. Kâ sa mbəɗəken awan pə cəveɗ, anga sa jan 'am anà ɗo ahay bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Kə dəzlen àga ɗowan a nà, jen anà ɗo su doh ataya nà, zay a Mbərom â təra à gulom su doh a anan inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kak ɗo sa gan may à zay a Mbərom inde à gulom su doh ata nà, zay a kwanay i təran anà ɗowan ata awan. Kak matanan bay cəna, zay a kwanay i təran atan bay. Əna zay a kwanay ata, i may ahay pə kwanay awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Njihen à gulom su doh a sə təma uda kwanay ata awan. Pen way, aday sen way a tinen a saa varak ikwen ata fok. Anga ɗo si mer su way i pa nà, way sə herreɓ anahan. Kâ sa bəren awan pu doh pu doh bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Kə dəzlen à wulen su doh a aday tə təmahak uda kwanay ata nà, pen way a tinen saa varak ikwen ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mbəren anan ɗo sə ɗəvac ahay kawa ana kwanay sa tan à nga à man ata awan. Aday jen atan ɗukwen: “Bahay a Mbərom, winen defefe coy.” ");
INSERT INTO mqbNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Əna kə dəzlen à wulen su doh a aday tə təmahak kwanay à man ata bay cəna, zlen, kâ sa tiven à məgəzləga cəveɗ, aday jen atan nà: ");
INSERT INTO mqbNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mi bəzləmak ikwen anan morbodok sə wulen su doh a kwanay pə saray a manay ahay wa anga ines a kwanay. Əna sənen apan lele, bahay a Mbərom winen defefe tə kwanay coy.” ");
INSERT INTO mqbNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Əna nen apan ni jak ikwen, pə luvon sə sariya nà, zek i naa dan anà ɗo su kon ataya zal ɗo sə Sodoma ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu a ja asa, a wa: «Iken, wulen su doh sə Kurajin, yam zek anak anga ɗəce i tak à nga. Iken, wulen su doh sə Baytisada ɗukwen, ɗəce i tak à nga re. Anga abay masuwayan aya ma ga à wulen su doh a kwanay ataya, tâ ga anan à wulen su doh sə Tirus tə Sidon nà, ɗo sa man ataya ti yam pə ines a tinen ahay biɗaw? Ti pak zana sə məsinde pi zek, ti njahay à məndak à rəɓa inde aday sə ɗakay anan tə yimak pə ines a tinen ahay tə ɗiɗek awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anga na awan, pə luvon sa ndav anan daliyugo nà, sariya ana atə Tirus tə Sidon nà, i dan atan 'am kawa ana kwanay bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","«Iken Kafarnahum, a ga apak nà, Mbərom i cakaf wa iken à mburom ɗaw? Matana bay! Ki zla nà, à məke sə mərda aɗəka coy.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Natiya, Yesu a jan anà njavar anahan ataya kutok, a wa: «Ɗo kə̀ slənek ikwen anan nà, kə̀ slənek uno anan re. Ɗowan a kə̀ təmahak kwanay bay nà, a təma bay nà, nen awan. Aday asa ɗo kə̀ təmahak nen bay, a təma bay nà, zek a Mbərom a sə slənay ahay nen ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɗo maslan a kwa kuro cuwɓe nga cew ataya ta may ahay tə ataslay mivel awan. Ta nay, ta jan à Yesu nà: «Ba Məduwen! Kwa apasay lelibay aya ɗukwen tə bənak umo à 'am wa anga sləmay anak.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu a jan atan ite, a wa: «Nə canak anan anà Fakalaw kə̀ slahak ahay à bagəbaga mburom wa kawa Mbərom a wuteɗ ike. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Əna ihe! Anga məgala sə mazlaɓ uno, ni varak ikwen cəveɗ ki jənen pa nga sə dədew ta sə rəje aya awan, aday ki gen bahay pə maniɗe a kwanay Fakalaw, pə way ahay fok. Awan saa ga alay tə kwanay nà, inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aya əna kə̂ tislen mivel həna anga apasay lelibay aya tə bənak ikwen à 'am wa cəna coy bay. Tislen mivel həna aɗəka nà, anga sləmay a kwanay ahay mə vinde awan, à mburom.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","À alay ata kutok, Apasay Cəncan a a taslan a mivel anà Yesu. A həran nga anà Mbərom, a wa: «Bəbay uno, iken Bahay sə bagəbaga mburom, iken Bahay sə daliyugo. Suse anak, anga kə ɗakak anan anan way a anaya anà gwaslay ahay, way ataya aday ɗukwen abay kə ɗərek anan pu ɗo sə kəlire ahay wa, pu ɗo sə asan way ahay wa. Ayaw, Bəbay uno, ka ga matanan, anga a zlak à nga anakiken awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A jan anà ɗo sa man ataya kutok, a wa: «Bəbay uno Mbərom kə̀ varak uno anan way ahay fok. Ɗowan sa san sa jəka nen wan anahan nə ibay, si zek ana Bəbay Mbərom awan. Aday ɗukwen, ɗowan sa san Bəbay uno nə wayaw nà, ibay, si nen wan anahan awan, tu ɗo aday Wan a Mbərom a gan may sə ɗakan atan anan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pə dəɓa anahan a wa Yesu a mbəɗa 'am pə njavar anahan ahay, a jan atan anà tinen a ɗəkɗek, a wa: «Tislen mivel anga kə cinen anan anà way a anaya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nen apan ni jak ikwen: Ɗo maja'am a Mbərom ahay tə bahay ahay bayak a ta gak anan may sə canan à way a kwanay a sə canan həna ata awan, əna tə canak anan anà awan bay. Ta gan may sə sləne way a kwanay a sə sləne həna ata awan, əna tə slənek awan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Natiya awan, miter sə Tawrita a inde a slabak, anga a nan sa ban anan Yesu pə kwande. A cəce pə Yesu wa kutok, a wa: «Miter, ni ga nə mer sa ma aday ni sa njaɗ sifa sa ndav bay ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu a mbəɗahan apan, a wa: «Ka tan à nga mə vinde a à Deftere sə Tawrita inde nə maw? Iken apan ki jinge nà, a ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A mbəɗahan apan anà Yesu ite, a wa: «Mə vinde uda nà: “Pəlay anan Mbərom Fetek, Bahay anak, tə mivel anak a təke, tə apasay anak a təke, tə məgala anak a təke, tə abayak nga anak a təke” aday “Pəlay anan ɗo sə cakay su doh anak kawa iken sə pəlay anan nga anak ata awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu a jan: «Wita nà, lele. Zla, kaa ga matanan kawa iken a sə baslay ata, aday ki njaɗ sifa sa ndav bay ata kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Əna miter sə Tawrita ata a nan sə ɗakay anan nà, acəce 'am anahan ata nə lele awan. Anga nan, a cəce pə Yesu wa asa, a wa: «Aday ɗo sə cakay su doh uno ata nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu a mbəɗahan apan kutok, a jan nà: «Ɗowan a inde a slabak à Urəsalima wa, i zla à Yeriko. Pə cəveɗ kutok, ɗo sə akar ahay ta kaɗ apan, tə culok panan zana, ta ndazl anan leɗəɗɗe. Ta zla way a tinen, tə mbəsak anan nə həɗek həɗek kawa i ndav zek coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«À man ata ɗukwen, ɗo sə gəɗan dungo anà way anga Mbərom a inde, a nay tə cəveɗ ata cite. A canan anà ɗowan ata mə nahay a gwehəhhe nà, a zla way anahan tə zlawak cangəhha. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","«Capəpa asa, ɗo hinen a nay ahay ta man ata re, winen ɗo sa ga mer su way ù doh sə mazlaɓ a Mbərom. A nay, a ca pə ɗowan ata matana re cəna, a ban cəveɗ tə zlawak, a zla way anahan ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Əna Samariya a inde, winen apan i zla à man anahan dəren a ite, a dəzley à man ata nà, a canan anà ɗowan a mə nahay a gwehəhhe ata awan, a gan ì zek wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","A həɗəken ayak pə cakay, a pəkan disise ahay pə mbəlak anahan a pi zek ataya awan, a ɓanan apan. A slabak anan, aday a zləzlam anan pə zungo anahan, a zla anan à wulen su doh, à man sə təma mbəlok ahay, a gan nga anà ɗowan ata lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","«Iɗe a cəɗe sidew a nà, a varan dala sə dinar ahay cew anà bahay su doh ata awan. A jan nà: “Gan nga anà ɗowan a anan lele. Kwa â ga nə kə lizek anan dala anak anà nga dəp nà, pə luvon a ni may ahay ta man a anan ata nà, ni naa hamak anan dala anak kutok.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu a cəce pə miter sə Tawrita ata wa kutok, a wa: «À wulen a su ɗo a maakan ataya inde nà, sə təra ɗo sə cakay su doh ana ɗowan aday ɗo sə akar ahay sa kaɗ apan ata nà, wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Miter sə Tawrita ata a mbəɗahan apan anà Yesu kutok, a wa: «Sə təra ɗo sə cakay su doh anahan nà, ɗowan a sa gan sumor ata awan.» Yesu a jan kutok, a wa: «Əna, iken zla, kâ sa ga matanan ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Natiya awan, atə Yesu tə njavar anahan ahay tinen pə cəveɗ sa zla à Urəsalima nà, tə dəzle à wulen su doh a inde. À man ata nə, uwar a inde tə ngaman Marta, a təma atan àga winen. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Məran a uwar ata inde dəna awan, tə ngaman Mariyama. A nay ahay pə cakay a Yesu, a njahan ù vo, winen apan i pak sləmay pa 'am ana Yesu sa ja ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Cəkəbay Marta nà, nga winen apan i wusen ti mer su way à mbak inde. Natiya kutok, Marta a nay ahay à man a Yesu, a jan, a wa: «Ba Məduwen! Dəna a anan winen mə njahay a pə cakay anak kəriya awan, aday zek winen apan i do ti mer su way ahay taayak uno kutok nà, ka jan û mo zek ite biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu a mbəɗahan apan, a wa: «Hey Marta, hey Marta! Iken nà, kə varak anan nga anak pi mer su way ahay bayak a ba? ");
INSERT INTO mqbNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Əna way inde kərtek lele awan, təɗe sə varan anan nga anak. Mariyama a varan anan nga anahan nà, anà way ata awan. Ɗowan saa gafan apan 'am nà, inde sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pə luvon a inde, Yesu winen apan i ga amboh à man a inde. A ndəvay anan ahay sa ga amboh ata nà, ɗo kərtek à wulen sə njavar anahan ahay wa a jan: «Ba Məduwen, ɗakan umo anan sa gan amboh anà Mbərom, kawa ana Yuhana sə ɗakan anan anà njavar anahan ahay ata ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A mbəɗahan atan apan, a wa: «Kwanay apan ki gen amboh anà Mbərom nà, jen nə natiya awan: Bəbay a manay, ɗo ahay tâ san sləmay anak nə cəncan awan. Bahay anak â ga zek à wulen a manay ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Varan umo way sa pa saa slan umo ata pə luvon pə luvon fok ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pəsen umo anan ines a manay ahay, kawa ana manay sə pəsen anan anà ɗo sa gan umo ines ataya cite. Ba manay pə way saa njak manay ahay wa ite, anga aday mâ sa zla ì ines inde bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","A jan atan asa, a wa: «Hinahibay məndala anak inde, aday ki zla àga winen gak à luvon inde. Ki jan nà: “Amboh, məndala uno. Ɗaf kə̀ mbakak pikwen wa mənjœk ite ɗaw? Ənga, vuro ite! ");
INSERT INTO mqbNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Anga car uno a inde, a may ahay à man a wa, winen àga nen, əna way sa pa inde upo sə varan ibay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Natiya kutok, məndala anak ata i mbəɗahak ahay apan ù doh wa ta sa jak nà: “Kə̂ bəbulo ahay awan bay wuna! Nə tacak anan məsudoh uno coy, manay apan mi njak ahan tə gwaslay uno ahay. Ni mba apan sə slabak aday sə varak ayak way sa pa sabay!”» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Natiya Yesu a jan atan asa, a wa: «Nen apan ni jak ikwen: Məndala anahan ata i slabak sə varan ahay way anahan a sa gan may ata awan. I varan ahay nà, anga sa jəka winen məndala anahan ata bay, əna anga winen apan i bəbalan ayak awan uho wa hwiya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Natiya kutok, nen apan ni jak ikwen: Cəcihen! Mbərom i varak ikwen way a kwanay sə cəce ata awan. Pəlen! Ki ten anan à nga anà way a kwanay a sə pəlay ata awan. Jen 'am pi zek uho, aday ti təɓak ikwen ayak wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Anga kuwaya kə̀ cəcihek way cəna, ti varan. Kuwaya kə̀ pəlak way ɗukwen, i njaɗ way anahan a sə pəlay ata awan, aday kuwaya kà jak ayak 'am pi zek uho wa ɗukwen, ti təɓan ayak wa cite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Kwanay bəbay ahay, wan anak kə̀ cəcihek panak kəlef nà, ki mba apan sə varan dədew à yime sə kəlef inde bay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kabay wan anak a cəce panak slay nà, ki mba apan sə varan rəje à yime sa slay inde bay re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwanay ɗo lelibay aya aɗəka nà, kə sənen a viren anan way lele aya anà wan a kwanay ahay zle. Matana re, Bəbay a kwanay Mbərom winen à bagəbaga mburom ɗukwen, i mba apan sə varan Apasay Cəncan a anà ɗo sə cəce panan ataya fok biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pə luvon a inde, Yesu a rəzlay anan ahay setene ù ɗo maandak a wa, aday ɗowan ata a dazlan sa ja 'am njəlen'en'e. Way ata a gan masuwayan anà ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Əna ɗo azar aya ta wa: «Sə varan məgala a aday sa razl setene ataya nà, Bə'elzebul, winen bahay sə setene ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɗo azar aya ite ta gan may sa ban anan pə kwande. Anga nan, tə cəce panan â gan atan masuwayan sə way sa nay ahay à mburom wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Əna Yesu a san way a tinen sə jalay ata zle kwayan'a. A jan atan kutok, a wa: «À bahay a wura wura fok cəna, kak ɗo anahan aya 'am kà zlak atan pi zek bay nà, bahay ata i nes wa. Doh ahay ɗukwen ti təra nə rəgay ahay, ti mbazl sekeɗ sekeɗ. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Matanan re, kak Fakalaw kà gak vəram ti zek anahan a nà, bahay anahan a ɗukwen i tavay nga ɗaw? Natiya, kwanay ki jen, nen na razl setene ahay nə tə məgala ana Fakalaw nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kak nen na razl setene ahay tə məgala ana Fakalaw nà, aday wan a kwanay ahay ti sa razl setene ahay nə tə məgala à waya kutok asa anaw? Anga nan, sa naa mak ikwen anan mungok nà, wan a kwanay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tə ɗiɗem awan, na razl setene ahay tə məgala sə Apasay a Mbərom. Matanan re, ki sənen anan kutok, bahay a Mbərom kà nak ahay à wulen a kwanay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A ja asa, a wa: «Kak ɗo gədan a, aday mə lavay zek a tə way sə alay anahan a, i ba way su doh anahan ahay lele nà, way anahan ahay ti lize ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Əna ɗo sə zalan məgala à nga wa kà nak ite, kə̀ zalak anan winen tə mungol nà, i ngəzar panan way sə alay anahan sə lavay anan zek ata awan, i gəzla anan zlile anahan a sə ngəzar pə ɗowan ata wa anà car anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Ɗo sə pəlay nen bay ata nà, winen nə ɗo maniɗe uno. Ɗowan a kà mak uno zek sə halan nga anà way ahay bay cəna, sa tan 'am à kiɓe nà, winen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu a ja asa, a wa: «Setene kà nak ahay ù ɗo wa nà, i zla à man kiɓe inde saa bar, saa pəlay man sa man uda awan. Əna kə̀ njaɗak man bay nà, i jan anà nga anahan: “Suwan ni ma ù doh uno nen a sa nay ahay wa ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kà sak a may ahay nà, i tan à nga anà doh anahan a mama'am ata mə ndakay awan, mə faɗay a lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aday cəna, i ma pə dəɓa, i ray ahay apan setene azar aya cuwɓe, sə zalay anan tə huwan asa, ti nay, ti njahay à ɗowan ata inde. Aday anjahay ana ɗowan ata nà, i təra lelibay a zal pa sə kukwa ata wa asa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu winen apan i ja 'am ata mba cəna, uwar a inde à wulen su ɗo ataya, a ja tə məgalak awan, a wa: «Mbərom kə̀ ɗəfak ngama anahan pə uwar a sə wahay iken, aday iken sa sa pay anahan a ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Əna Yesu a mbəɗahan apan ite, a wa: «Mbərom a ɗaf ngama aɗəka nà, pu ɗo sə sləne 'am anahan ahay, aday sə ɗəfan apan anà 'am anahan a ma ja ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Natiya kutok, ɗo ahay bayak a tinen apan ti zlak ayak à man a Yesu asa. Coy, a jan atan kutok, a wa: «Ɗo sə biten ahay nà, tinen huwan aya awan. Tinen ta gan may nà, anà masuwayan. Əna ti canan anà masuwayan sə awan sabay, kak si masuwayan sə təra pə Zonas, ɗo maja'am a Mbərom ata aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kawa ana Mbərom sə ɗakay anan mazlaɓ sə sləmay anahan anà ɗo sə Nəniwe ahay tə masuwayan sə təra pə Zonas ata nà, nen, Wan su Ɗo, həna ɗukwen ni təran anà ɗo sə biten ahay nə matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pə luvon sə sariya nà, bahay sə Saba ɗukwen i slabak sa gan sariya anà ɗo sə biten a anaya awan. Anga kwa winen dəren təkeɗe nà, kà nak ahay sa naa pəkak ayak sləmay pa 'am ana bahay Sulimanu, ma ja aya tə kəlire ata awan. Əna, cen apan həna kutok, ɗo sə zalay anan Sulimanu tə məduwen ɗukwen, winen inde à man a ana awan. Əna hwiya ɗowan a ngam sə sləne 'am anahan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pə luvon sə sariya a Mbərom saa ga ata nà, ɗo sə Nəniwe ahay ti slabakay ahay uho pə kərtek a tu ɗo sə biten a anan ataya, ti gan atan sariya. Anga ɗo sə Nəniwe ahay nà, tə sləne wazo ana Zonas cəna, ta yam pə ines a tinen ahay. Aday ɗukwen, ɗo sə zalay Zonas winen inde à man a ana awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu a ja asa, a wa: «Ɗowan saa ɗaf uko pə lalam, aday i ɗer anan, kabay i hərok apan tasa nà, ibay. Əna i ɗaf anan lalam ata nà, pə way sa ɗaf lalam awan, anga aday iɗe jiyjay â dəvan anà ɗo sa zla ù doh ataya fok lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","«Iɗe anak nà, kawa lalam sə dəvan jiyjay anà zek anak. Kak iɗe anak winen lele nà, ata zek anak a fok winen à jiyjay a inde. Əna, kak iɗe anak a lelibay nà, zek anak kə̀ tərak kawa winen ì iɗe zənzen a inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gan nga anà zek anak lele, bina iɗe jiyjay anak â sa tərak kawa iɗe zənzen bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kak zek anak a fok ì iɗe jiyjay inde nà, aday kə̀ mbakak uda man sə iɗe zənzen mənjœk bay nà, zek anak fok i təra iɗe jiyjay, kawa lalam sa kak anan jiyjay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu a ndav anan 'am anahan ata mba cəna, Farisa a inde, a ngaman pa ɗaf àga winen. Ta zla àga ɗowan ata kutok, ta pa ɗaf miya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A gan masuwayan anà Farisa ata, anga Yesu a pa ɗaf mənjəna sə banay alay kawa atətak way sə bije a tinen ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesu a san way anahan a sə bayak ata zle. Anga nan, a jan, a wa: «Kwanay Farisa ahay nà, ki gen minje nə tə gəsa'am kabay tuwez. Kə cakiɗen anan day sə uho aya lele cəna coy. Aday cəkəbay, ta su doh sə mivel a kwanay ahay nà, mə cakaɗ aya bay. Mivel a kwanay ahay ma rah aya nà, tə ubor aday tə huwan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kwanay nà, demdemem sə ɗo ahay! Mbərom a ndakay way ahay nà, day sə uho tə day su doh a təke biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Way a à sikeɗ a kwanay kabay à tuwez a kwanay inde ataya nà, viren anan anan anà ɗo mətawak aya awan, aday way a azar aya fok ti i tərak ikwen cəɗan'a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Əna kwanay Farisa ahay, wawayah, ɗəce i tərak ikwen! Kə rəzlen anan à nga wa sa var alay mbok wa kərtek sə daslam ahay cara cara nə lele. Əna kə̀ mbəɗəken anan nga tə ɗiɗek anahan, tə asan zek anahan ahay. Abay təɗe ki gen nà, way ataya awan, mənjəna sə mbəsak sa ga way a azar aya re. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Kwanay Farisa ahay, wawayah, ɗəce i tərak ikwen! Anga ki zlen ù doh sə wazay ahay cəna, ki cen wa ɗukwen, man zəbor aya awan. Ki gen anan may nà, ɗo ahay ta jak ikwen anan 'am à kwasuko nà, tə akərdeh aya awan, à wulen sə ɗo ahay inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Wita nà, wawayah, ɗəce i tərak ikwen! Anga ki gen minje nà, tə jəvay, aday ɗo ahay tə canak anan bay ata awan. Ɗo ahay tinen apan ti bəran pa nga mənjəna sa san apan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pə dəɓa ana 'am a Yesu a sa jan atan ata wa nà, ɗo kərtek à wulen sə miter sə Tawrita ahay a mbəɗahan apan, a wa: «Ta 'am anak a sa ja ata nà, kə tərak manay à məndak re biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu a mbəɗa apan, a wa: «Kwanay, miter sə Tawrita ahay, wawayah, ɗəce i tərak ikwen! Anga kwanay apan ki taviken anan way ma ba aya tə mindel ata pa nga anà ɗo ahay, anga aday tə̂ gəɓa. Əna kwanay a ɗukwen, ki men atan apan zek kwa ta wan sə alay bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Wawayah, ɗəce i tərak ikwen! Anga kwanay apan ki ɗəzlen anan jəvay anà ɗo maja'am a Mbərom ahay. Aday cəkəbay, sa vaɗ anan ɗo ataya nà, bije a kwanay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","I ga nà, way a bije a kwanay ahay sa ga à alay ataya nà, kà zlak ikwen à nga. Bina, sa vaɗ anan ɗo maja'am a Mbərom ataya nà, bije a kwanay aya awan. Aday kwanay həna ɗukwen, kwanay apan ki ɗəzlen anan jəvay ataya re angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Anga nan, Mbərom kà jak, a wa: “Ni slan ɗo maja'am uno ahay tu ɗo maslan uno ahay. Ti vaɗ anan azar su ɗo a tinen aya awan, aday ti ga anan alay tu ɗo azar aya re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Anga, kwa pa sə ndakay daliyugo wa, hus həna nà, tinen apan ti ndav anan ɗo maja'am uno ahay ta sa vaɗ atan à məke sa ndaw. Anga nan, ni naa cəce mez ana ɗo uno ahay nà, pu ɗo sə biten a anan aya wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","A bənay ahay kwa pə amac ana Abel wa, hus pə amac ana Zakari, winen ma vaɗ a à gala su doh sə mazlaɓ a Mbərom à wulen ana atə man cəncan a ta man sə gəɗan dungo anà way ahay ata awan. Ayaw, acəkan, Mbərom i naa gan sariya anà ɗo sə biten a anaya awan, anga way ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Kwanay, miter sə Tawrita ahay, wawayah, ɗəce i tərak ikwen! Anga kə ticen anan cəveɗ sa san Mbərom. Aday kwanay a ɗukwen, ki zlen à cəveɗ ata inde sabay re. Aday kə gifen anan 'am anà ɗo sa gan may sa zla tə cəveɗ ataya re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Natiya kutok, pə dəɓa ana 'am anahan ataya wa nà, a slabakay way anahan à man ata wa. Cəna, miter sə Tawrita ahay tə Farisa ahay, ta ga apan mivel. Tə cəce panan way ahay cara cara bayak awan, ");
INSERT INTO mqbNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","anga ta gan may nà, abay Yesu â nes 'am cəna, ata ti ban anan pə kwande. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Natiya, à alay ata a ite, ɗo ahay tə halay nga bayak awan, a baslay zek bay. Tinen apan ti zla nà, tə jənan pə saray ì zek ahay. Yesu a dazlan sa jan anà njavar anahan ahay, a wa: «Bənen nga a kwanay nə lele pə wuɗah sə Farisa ahay wa, anga tinen nà, ɗo sə mbaɗəmbaɗa ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Way mi ɗer aya fok ti kay ahay zek uho mba, aday 'am mə səsœk aya asəsœk fok, ti sləne zek kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Anga nan, 'am a kwanay sa ja ì iɗe zənzen a inde ata nà, i sləne zek ì iɗe jiyjay a inde, aday 'am a kwanay sə səsœk asəsœk taayak ù doh a kwanay ataya ɗukwen, ti sləne zek kawa ki jen nə uho pə zavay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesu a jan atan asa, a wa: «Nen apan ni jak ikwen, car uno ahay: Kə̂ jəjiren anà ɗo sa mba apan saa ndəvak ikwen anan sifa təte ataya bay, anga pə dəɓa anahan a wa nà, ti i mba apan sa ga awan inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ɗo a aday təɗe ki jəjiren anan ata nà, nen apan ni ɗakak ikwen anan: Jəjiren anan aɗəka nà, anà Mbərom. Winen nà, i mba apan sə ndəvak ikwen anan sifa təte, aday pə dəɓa anahan a wa ɗukwen, i mba apan sa zla kwanay à məke sə mərda inde re. Ayaw, sumor a nà, jəjiren anan anà ɗowan ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Slənen asa aday, na wa kə sənen zle, tə sukom kəɗeye ahay ɗara tə dala sərɗəɗe aya cew biɗaw? Əna aday ɗukwen, Mbərom a san patan zle fok re asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kə̂ jəjiren awan bay jiga awan. Kwa sibœk sa nga a kwanay ahay ɗukwen mə baslay aya kərtek kərtek fok coy. Pə Mbərom nà, kwanay kə zilen a kəɗeye ahay gəmgam asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesu a jan anà njavar anahan ahay asa re, a wa: «Kak ɗowan a kà jak pa 'am su ɗo sə daliyugo ahay “Nen ɗo a Yesu!” nà, nen Wan su Ɗo ɗukwen, ni ja pa 'am ana maslay a Mbərom ahay: “Winen ɗo uno!” cite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Əna ɗowan kà jak pa 'am su ɗo sə daliyugo ahay sa jəka a san nen Yesu bay cəna, nen ɗukwen ni jan anà maslay a Mbərom ahay nà, na san anan bay ite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","«Ɗo kə̀ jənak uno pa 'am ì nen Wan su Ɗo nà, Mbərom i pəsen anan. Əna kak ɗowan a a jənan pa 'am nə anà Apasay Cəncan a nà, wita Mbərom i pəsen anan ines anahan kula itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Kwa siwa siwa tə bənak kwanay aday ta zlak kwanay pa 'am sə sariya ù doh sə wazay ahay, kabay pa 'am ana bahay sə daliyugo ahay, kabay pa 'am su ɗo məduwen aya dəp nà, kâ sa jilen sa jəka aday mi i mbəɗahan atan apan nə, kəkəmaw kabay mi i ja nə maw ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Anga à alay ata nà, Apasay Cəncan a i ɗakak ikwen anan 'am a kwanay a saa ja ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","À wulen su ɗo a bayak ata wa kutok, ɗowan a inde a jan anà Yesu, a wa: «Miter, ənga, jan anà mərak uno â gəzlan umo anan way a bəbay a manay sa mac panan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Əna Yesu a mbəɗahan apan, a wa: «Ɗowan a anan, nen nə tərak ɗo sa gak ikwen sariya, kabay sə gəzlak ikwen anan zlile a kwanay ahay bay asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Natiya, a jan anà ɗo ataya fok kutok, a wa: «Bənen nga a kwanay pa sə pəlay zlile wa. Anga sə bənan anan sifa uho anà ɗo zənzen a nà, way anahan ahay, kabay zlile anahan ahay bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Natiya awan, Yesu a təkəren atan jike sa 'am a anan kutok, a wa: «Ɗowan a inde nà, zlile awan, guvo anahan ahay inde pa man ma ndaɓ aya awan. Kà gak apan way bayak a tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɗowan ata a jalay à mivel anahan inde kutok, a wa: “Man i sla sa pak anan uda way uno ma ga bayak a anaya fok bay kutok nà, ni ga nə kəkəmaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Coy a jan ì zek anahan a kutok, a wa: “Nə njaɗak anan nga sa 'am a kutok. Suwan ni kaɗ anan de uno ahay fok, ni han uda məduwen aya awan, aday ni pak anan uda ndaw uno tə way sa pa uno azar ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aday ni jan à nga uno nà: Zek uno, way anak inde mə ndakay man a bayak awan, i ndav bay, i slak way sə ava bayak a wanahan. Man uda kutok, pa way sa pa anak ahay aday bay itəɗaw! Ənga, sak ayak way həna anan aday, mbasay, taslay mivel bayak awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Əna Mbərom a mbəɗahan apan, a wa: “Ɗowan a mindel a anan awan, à luvon a sə biten a anan inde nà, ni gəɓa anan sifa anak. Əna aday way anak a sə halan nga bayak a anan ata nà, waya saa pa anan kutok anaw?”» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu a ndav anan ta sa jan atan kutok, a wa: «Matanan awan, pu ɗo sə halan nga anà zlile bayak a, anà nga anahan a ɗəkɗek ata nà, i naa təran matana re, bina pə iɗe a Mbərom nə winen ɗo mətawak awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pə dəɓa anahan a wa kutok, Yesu a jan anà njavar anahan ahay, a wa: «Nen apan ni jak ikwen həna: Kâ sa jilen pə way sa pa tə zana bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sifa si zek a zalay way sa pa, aday zek ɗukwen a zalay zana re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ənga, cen pə ngahak ahay aday. Ta casl awan bay, ta car awan bay, aday de a tinen ahay ɗukwen ibay. Əna Mbərom winen apan i varan atan way sa pa re. Əna kwanay, pə iɗe a Mbərom nà, kə zilen a məvuhom ahay lele biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","«Waya à wulen a kwanay saa mba apan tə ajalay nga anahan a sə zəga anan apan luvon sə njahay anahan mənjœk anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kak ki mben apan sa ga way mənjœk kawa wita bay asənə, aday kə jilen pə way azar aya nà, angama kutok anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ənga, cen pə avərez sə way ahay sa hay ahay à kiɓe ataya aday. Ta ga mer sə awan bay, ta han awan pi zek bay. Tə winen ata təke nà, nen apan ni jak ikwen: Kwa abay bahay Sulimanu tə zlile anahan a bayak ata təkeɗe nà, kula kə̀ pəkak zana lele aya pi zek kawa avərez sə way ahay à kiɓe ataya bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Həna dəp nà, Mbərom winen apan i rəɓa anan daslam sə kiɓe ahay, aday sidew a ɗukwen ti i han anan uko tə daslam ataya re. Kwanay ɗo ma kac aɗaf nga a anan aya awan, kak Mbərom kà mbak apan sa ga mer su way matana nà, i mba apan sə pəkak ikwen zana pi zek lele aya zal way ahay, à kiɓe ataya biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Matana awan, kwanay nà, kâ sa yan anan nga ì zek a kwanay ahay sə pəlay nə way sa pa kabay way saa sa ata bay. Kə̂ jilen pə way ataya bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anga jəba sə way kawa way ataya ata nà, sa ya apan nga sə pəlay nà, ɗo sa san Mbərom bay ataya awan. Əna kwanay a nà, ki gen anan may anà way ataya ɗukwen, Mbərom Bəbay a kwanay a san apan zle re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Suwan, pəlen aɗəka nà, bahay a Mbərom, aday way a kwanay sa gan may ataya nà, Mbərom awan, i varak ikwen atan kutok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kə̂ jəjiren awan bay, dəna uno ahay, anga Mbərom a gan may sə varak ikwen anan bahay anahan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yesu a jan atan asa, a wa: «Sukumen anan way tə way a kwanay ahay, aday kə̂ viren anan anan dala awan, anà ɗo mətawak aya awan. Təmen mbulo sa ɗaf dala lele aya, aday sa nes itəbay ataya awan. Ndiken ayak man pə zlile a kwanay ahay à bagəbaga mburom. Anga à man ata nà, zlile a kwanay ahay ti lize itəbay. Ɗo sə akar ahay ti njaɗ apan alay bay, mumok ahay ɗukwen ti mba apan sa pa anan sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Anga, zlile a kwanay ma ɗaf a à man ata nà, mivel a kwanay a ɗukwen i ga nə cezlezlen'e à man ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu a jan atan asa, a wa: «Liven zek lele. Hinen anan lalam a kwanay ahay lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Təren nà, kawa ɗo sa ga mer su way ahay, tinen sa ba anan bahay su doh a tinen i may ahay à man sə gəɓa uwar wa ata awan. Kwa â ga nə bahay su doh ata â may ahay agay nə siwa siwa cəna, tinen inde mə lavay zek a sə təɓan ayak wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kak bahay su doh ata a may agay, aday a tan à nga anà ɗo si mer su way anahan ataya ma njak ahan aya bay, tinen apan ti ban pu doh cekərkərre nà, ngama i təran anà ɗo ataya awan. Nen apan ni jak ikwen tə ɗiɗem a həna: Winen a ta nga anahan awan, i jawaɗ zek, i ngaman atan ahay, i varan atan man sə njahay, aday i gəzlan atan way sa pa tə alay anahan awan, ti pa kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kak bahay su doh a tinen ata a may nə man luvon kabay əduw təkeɗe, aday a tan atan ahay à nga nə tinen tə iɗe cekərkərre nà, ngama i təran anà ɗo sa ba pu doh ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Sənen pə way inde lele aday: Kak bahay su doh awan, a san apan zle, à alay a həna anan nà, ɗo sə akar ahay ti nay ahay àga winen saa zləray anan ahay nà, ɗowan ata i nahay nə tə iɗe cekərkərre anga aday ɗo sə akar ataya tâ zlan ù doh bay, biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kwanay ɗukwen, njihen mə lavay zek aya cekərkərre matanan re, bina, nen Wan su Ɗo nà, ni i may ahay à alay a ɗuwuraw ɗukwen, ki sənen apan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Natiya, pə dəɓa ana 'am a Yesu a sa jan atan ata wa kutok nà, Piyer a jan, a wa: «Ba Məduwen, ka ja 'am sə jike a anan ata nà, anga manay ɗaw, bəzi anga ɗo ahay fok ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu a mbəɗahan apan, a wa: «Ɗo sa ga mer su way lele awan, aday winen nə wurwer a ata nà, wayaw? Winen nà, ɗowan a aday bahay su doh anahan a sə mbakan anan ɗo si mer su way ahay fok à alay anahan inde ata awan. Winen i varan atan way sa pa lele à alay aday təɗe sa pa way ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Zay i təran anà ɗowan ata awan, kak bahay su doh anahan kà mak agay aday kà tak anan ahay à nga winen apan i gan nga anà ɗo si mer su way anahan ataya lele nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Matana awan, nen apan ni jak ikwen lele, bahay su doh anahan ata i mbəsakan anan way ahay à alay inde nə fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","«Aya əna, hinahibay ite, ɗo sa ga mer su way ata kà sak a jalay à nga anahan inde: “I ga nà, bahay su doh uno i may bəse bay.” Winen gədek sa ga anan alay tə azar su ɗo si mer su way ahay, gədek pə way sa pa anahan ahay, sa pa, aday winen apan i vaway nga tə mahay anahan ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sənen apan lele kutok, bahay su doh ana ɗowan ata i may ahay nà, pə luvon a aday winen a i san apan bay jiga ata awan, kabay à alay a ɗukwen i san bay re. Bahay su doh anahan ata kà sak a may ahay aday kà tak anan ahay à nga nà, winen apan i ga mer su way lelibay aya ata nà, i ga anan alay tə ɗowan ata tə mindel. I razl anan, i sa njahay tu ɗo lelibay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Hinahibay ɗo si mer su way a inde, aday a san way kawa ana bahay su doh anahan sa gan may â ga anan ata awan. Aya əna, ɗowan ata kə̀ lavak anan zek, aday kà gak anan way kawa sa zlan à nga anà bahay su doh anahan ata bay re. Kak matanan nà, ti jan pə akəta nə lele, ti vaɗ anan alay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Əna ɗo si mer su way hinen inde, winen a san sa ga way a kawa sa zlan à nga anà bahay su doh anahan ata bay. Winen nà, ti jan pə akəta nə mənjœk kəriya awan, anga a san bay. Tə varak anan way anà ɗowan a bayak a nà, ti cəce panan wa nə bayak a re. Ɗowan a aday tə mbakak anan anan way à alay inde bayak nà, ti naa cəce panan ɗukwen bayak a re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Natiya awan, Yesu a dazlan sa ja asa, a wa: «Nen na nay ahay nà, anga sa naa ɗəfan uko anà daliyugo, aday na gan may nə uko ata abay â han kwayan'a. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nen ni dazay təzlev həna à ɗəce inde kawa ɗo sə dazay à a'am inde à alay a winen sa ga baptisma ata awan. Əna hwiya nen ni sa məndolor sə ɗəce ata hus à andav a inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kwanay ki jen nà, nen na nay ahay anga aday zay â ga inde pə daliyugo ɗaw? Cəkəbay matanan bay, na nay sə gəzla anan ɗo ahay pi zek wa aɗəka bugol. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Azanan ɗo ahay ɗara a gulom su doh kərtek a inde nà, ti gəzla. Ɗo ahay maakan awan, 'am i zlan atan pi zek tu ɗo cew aya sabay. Ɗo a cew ataya ɗukwen, 'am i zlan atan pi zek tu ɗo maakan ataya sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bəbay sa wan i nes pi zek ta wan anahan, aday wan ata ɗukwen, ti nes pi zek tə bəbay anahan ata re. May sa wan i nes pi zek tə dəna anahan, aday dəna ata ɗukwen, ti nes pi zek tə may anahan ata re. May sa wan ɗukwen i nes pi zek tə dalay ana wan anahan, aday dalay ana wan anahan ata ɗukwen, ti nes pi zek tə jəje anahan ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu a jan atan asa, a wa: «Kə cinen anan anà mburom kə̀ gəɓak ahay vegege tə day sə dəlon wa nà, ki wen, iven i gay ahay, aday a ga ike acəkan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ka sak a cinen anan à maɗ winen apan i ma nga à dəlon nà, ki wen ata herreɓ i ga, aday a ga ike acəkan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Matana awan, kwanay ɗo sə mbaɗəmbaɗa ahay, way sa ga à mburom tə way saa təra pə daliyugo fok nə kə sənen a agəzlan anan alay pi zek wa nə lele, aday kə sənen pə way sə təra à alay a wuswes a anan inde sabay ata nà, angama kutok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Pə dəɓa anahan a wa, Yesu a jan atan asa, a wa: «Kwanay a ki mben apan sə gəzlan alay pi zek wa anà way lele aya tə lelibay aya ta nga a kwanay a bay jiga nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hinahibay, ɗowan a kə̀ zlahak apak, aday kwanay pə cəveɗ sa zla à man sə sariya mba nə, suwan 'am â zlak ikwen pi zek. Njiɗen zay à wulen a kwanay inde, à alay a kwanay pə cəveɗ mba ata awan. Bina tə mungok anak ata təke, ɗowan ata kà sak a dəzle iken à man su ɗo sa ga sariya ahay nà, ti mak anan mungok aday ɗo sa ga sariya i varan iken à alay inde anà suje ahay, ti tacak ayak iken à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nen apan ni jak: Hus pə ananak saa hamay anan way anahan a sa zlah anan apak ata bay cəna, ti mbəsakay ahay iken ù doh sə dangay ata wa bay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","À alay ata ite, ɗowan aya inde à man ata awan, ta jan à Yesu ləbara su ɗo sə Galile ahay, ta wa: «Pilatu kə̀ vəɗak anan Galile ahay à alay a tinen apan ti gəɗan dungo anà way anà Mbərom, aday mez a tinen kə̀ japak tə mez sə way a ma gaɗ dungo aya ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu a mbəɗahan atan apan, a wa: «Kwanay kə jilen nà, ɗo a ma vaɗ ataya ta mac matanan nà, anga tinen ɗo sa ga ines ahay zal a ɗo sə Galile azar ataya ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nen apan ni jak ikwen nà, matanan bay, əna kwanay həna ɗukwen kə mbəɗihen anan lœn anà ines a kwanay ahay bay cəna, ki lizen kawa ɗo ataya cite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kabay ɗo a kuro nga jəmaakan sa mac à Silowam, à alay a doh zəbor a sa mbazl patan ata nà, kə jilen tinen ta gak ines ahay zal ɗo sə Urəsalima azar ataya fok ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nen apan ni jak ikwen nà, matanan bay re. Əna kwanay həna ɗukwen, kə mbəɗihen anan lœn anà ines a kwanay ahay bay ite nà, ki lizen dənam kawa ɗo ataya re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu a jan atan 'am sə jike a anan awan, a wa: «Ɗowan a inde a jule buway à guvo anahan, a nay saa bənak ayak wa wan awan, əna kə̀ bənak bay, anga kə̀ wahak bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ɗowan ata a jan anà ɗo sa ga mer su way à guvo ata, a wa: “Həna kà gak ava maakan, nen apan ni ta nay abay sə bənak ayak wa wan sə buway anan, əna nə njaɗak bay anga kə̀ wahak bay. Suwan gaɗ anan, bina winen apan i nəso anan guvo kəriya nə pa maw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Əna ɗowan ata a jan nà: “Bahay su doh uno, suwan mbəsak anan apan sə tə viya a anan kərtek aday, ni lan à cakay wa, ni pəkan bərbor tuwwe nə, ");
INSERT INTO mqbNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","izəne pac hinen ahay nà, i wahay kəmaw? Kak kə̀ wahak bay re nà, aday kâ gaɗ anan kutok.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pə luvon a inde nà, luvon sa man uda awan, aday Yesu winen apan i wazay ù doh sə wazay. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","À man ata awan, uwar a inde mə təra à məndak a ava kuro nga jəmaakan, anga setene sa gan. A mba apan sə tavay bay. A zla nà, mə kərdeh a tuhha. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu a canan anà uwar ata cəna, a ngaman ahay, aday a jan, a wa: «Mazar, kə mbərak à atəra à məndak anak wa!» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Cəna, a ɗaf apan alay, kwayan'a uwar ata a tavay lele kutok, a həran nga anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Cəkəbay, way ata kə̀ cəɓak anan anà ɗo sə lavan nga anà doh sə wazay ata, anga Yesu sa mbar anan uwar ata pə luvon sa man uda ata, ata awan. A jan anà ɗo ahay kutok, a wa: «Luvon ahay inde mbərka sa ga mer su way ahay, əna suwan kî nen ahay à luvon a mbərka ataya inde aday sa mbar, bina si pə luvon sa man uda aday bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yesu Ba Məduwen a mbəɗahan apan, a wa: «Kwanay nà, ɗo sə mbaɗəmbaɗa ahay kələɗaw? Pə luvon sa man uda nà, kə pəsiken sla a kwanay ahay, kabay zungo a kwanay ahay sa zla atan à man saa varan atan a'am biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Uwar a həna anan nà, winen ɗo sə zaav ana Ibərahima. Fakalaw kà gak anan alay ava kuro nga jəmaakan nà, abay təɗe sə pəsakay anan ahay à alay a Fakalaw wa pə luvon sa man uda itəbay kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","'Am ana Yesu a sə mbəɗahan atan apan ata a pəkan waray ì iɗe inde anà ɗo maniɗe anahan ataya fok. Əna ɗo azar ataya fok tə taslak mivel anga mer su way ana Yesu a sa ga lele ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pə dəɓa anahan a wa asa, Yesu a wa: «Bahay a Mbərom a ga minje nà, ta maw? Aday ni ga anan minje həna nà, ta maw? ");
INSERT INTO mqbNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ta ga minje nə tə wan sə bəzan. Ɗowan a a gəɓa, a casl anan à guvo anahan, a hay ahay, a təra dədazl si sé məduwen awan, aday məvuhom ahay tə ndakay apan doh pə alay si sé anahan aya ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","À dəɓa wa asa re, Yesu a ja, a wa: «Bahay a Mbərom ta ga minje nə ta ma asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ta ga minje tə wuɗah sə kwasay way ata awan. Uwar a ra mənjœk, a gan anan, a pak pə nuko anahan gəsaɗaf maakan. A laɓ anan nà, nuko ata fok a kwasay, a zlambar.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Natiya, à alay a Yesu winen apan i zla à Urəsalima nà, a takas kon a azar aya, tə wulen su doh ahay. Aday winen apan i tətakan way anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","À alay ata kutok nà, ɗowan a inde, a cəce panan, a wa: «Ba Məduwen, waka Mbərom i tam a nà, azar su ɗo ahay əngal cəna coy ɗaw?» Yesu a mbəɗahan atan apan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Njəzlen pi zek sa zla à bahay a Mbərom inde tə məsudoh a mbəɗec a njulehwehwe ata awan. Nen ni jak ikwen, ɗo ahay bayak awan, ti gan may sa zla uda awan, əna ti mba pi zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aday, alay a i nay, bahay su doh i slabak nà, i tacay anan məsudoh anahan kutok. Ata kwanay nà, kwanay uho mba. Matanan, ki dəzlen anan sə dəcan ayak anà məsudoh, ta sa ja nà: “Manay uho ite. Bahay su doh a manay, təɓan umo ayak wa ite.” «Bahay su doh ata i mbəɗahak ikwen ahay apan ta sa ja nà: “Kwanay mayanaw, na san kwanay bay fok.” ");
INSERT INTO mqbNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Aday ki dizlen anan sa ja kutok: “Ɗa pak way sa pa, ɗa sak way fok tatə iken awan, aday kə̀ wazak à wulen su doh a manay re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«I mbəɗahak ikwen ahay apan hwiya ta sa ja nà: “Na jak ikwen lele, na ja nə kwanay mayanaw nà, na san bay jiga awan. Mbəsiken nen səfek. Zlen ayak à man uno wa, kwanay ɗo sə huwan ahay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«À alay ata kutok nà, ki cinen anan anà Ibərahima, Isiyaku tə Yakob, aday tu ɗo maja'am a Mbərom ahay fok à bahay a Mbərom inde. Ata kwanay nà, ki yimen, ki rəcen slan, anga tə tacak pikwen uho. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ɗo ahay ti halay ahay nga kwa pə daliyugo ahay wa fok, kwa ta sə wura wa fok. Ti nay pə kərtek a sa pa way à bahay a Mbərom inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sənen apan lele kutok, azar su ɗo a ma lah aya pa 'am həna ata nà, ti naa təra ɗo mədakwidok aya awan. Aday azar su ɗo a mədakwidok ataya ite, ti naa təra ɗo ma lah aya pa 'am cukutok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","À alay ata ite, Farisa aya inde, ta nay ahay pə cakay a Yesu, aday ta jan: «Zla way anak à man a anan wa, bina Hiridus a gan may sa vaɗ iken.» ");
INSERT INTO mqbNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Əna Yesu a mbəɗahan atan apan, a wa: «Zlen ka si jen anà ɗo sə wurwer a kawa wan ana ayah ata nà: Luvon sə biten ta sə sidew nə, nen apan ni razl apasay lelibay aya awan, ni mbar anan ɗo sə ɗəvac ahay. Aday pə luvon maakan anahan a nà, ni ndav anan mer su way uno. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aya əna, sumor a ni pərahan azar anà cəveɗ uno biten, sidew, aday anjahay sidew kərtek, bina a zla pi zek aday ɗo maja'am a Mbərom â mac uho à man aya bay, sumor a nà, à Urəsalima awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Hayaka Urəsalima ahay! Kwanay ɗo sə Urəsalima ahay! Kə vəɗen anan ɗo maja'am a Mbərom ahay, aday kə tiren anan ɗo a Mbərom sə slənak ikwen ahay ataya tu kon. Aday saray bayak a, na gak anan may sə halak ikwen nga anà kwanay ɗo sə Urəsalima ahay ù vo uno, kawa man njəkar sə halan nga anà wan anahan ahay à bərgaslay inde ata awan. Əna hwiya kə ngəmen bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ihe, doh sə mazlaɓ a Mbərom a kwanay i təra rəgay. Nen ni jak ikwen anan: Ki cinen uno sabay, si azanan ki naa cinen uno nà, à alay a aday ki i jen: “Mbərom â ɗaf alay sə mazlaɓ anahan pu ɗo sa nay ahay tə sləmay anahan ata awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pə luvon sa man uda a inde nà, bahay sə Farisa ahay a inde, a ngaman à Yesu saa pa way sa pa àga winen. Əna à man ata kutok nà, ɗo a à man sa pa ɗaf ataya, tə ɗəfan iɗe anà Yesu zuhhwe nə lele. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aday ɗowan a inde à man ata awan, zek anahan a fok nà, ma tar a dəngəleffe, anga ɗəvac a gan, winen pa 'am a Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu a cəce pə miter sə Tawrita tə Farisa mə ngamay ataya wa, a wa: «Pə luvon sa man uda nà, cəveɗ inde sa mbar anan ɗo ɗəvac a ɗaw, kabay cəveɗ ibay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɗo ataya tətəte way a tinen, ta ngam sə mbəɗahan apan bay. Coy Yesu a mbəɗa 'am pə ɗowan a ata kutok, a mbar anan, aday a jan â zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pə dəɓa anahan a wa nà, Yesu a jan ù ɗo sa man ataya asa, a wa: «Kwanay nà, hinahibay wan anak kabay sla anak kə̀ slahak à kurok inde kwa pə luvon sa man uda nà, ki zəɓay anan ahay wa way anak kwayan'a biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tətəte way a tinen ta mbak apan sə mbəɗahan apan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Natiya, à man ata kutok, Yesu a ca pu ɗo a mə ngamay a ataya nə, ta ca nà, man sə njahay lele aya awan. Anga nan, a gan atan jike sa 'am a anan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Kak tə ngamak anak à azar uko sə gəɓa dalay nà, kâ sa lah sə njahay à man lele inde bay, anga hinahibay à wulen su ɗo a mə ngamay ataya inde nà, ɗo sə zalay iken tə məduwen, i ga inde uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ata, bahay su doh a sə ngamak ikwen ata, i nay pə cakay anak, i jak kutok: “Mbəsakan man sə njahay a anan anà ɗowan a anan.” Ata nà, waray i gak sa zla saa njahay à man sə njahay a sə dəɓa ata inde biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aɗəka bugol nà, kak tə ngamak anak à man a nà, kâ sa njahay, à man sə njahay su ɗo məduwen aya inde bay. Ata ɗo sə ngamak ikwen ata kà sak a canak nà, i jak: “Car uno, hayak! Ka naa njahay à man a lele a anan inde.” Ata i varak mazlaɓ lele pa 'am su ɗo a mə ngamay a à azar uko ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Matana awan, kak ɗowan a kə̀ hərak anan nga ì zek anahan nà, ti təra anan à məndak. Aday kak ɗowan a kà mak anan nga anahan à məndak ite nà, ti həran nga nə lele.» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pə dəɓa anahan a wa nà, a jan anà ɗowan a sə ngaman anà ɗo ahay à azar uko àga winen ata kutok, a wa: «Ka sak a da way sa pa sə azar uko nà, kâ saa ngaman apan anà car anak ahay, kabay mərak anak ahay, tu ɗo anak ahay, aday anà ɗo sə cakay su doh anak zlile aya ata bay. Anga tinen nà, ti naa ga azar uko pə luvon a inde, aday ti ngamak saa hamak anan uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Əna kak ka dak way sa pa sə azar uko nà, suwan ngaman apan anà ɗo mətawak aya awan, anà ɗo mə təra à məndak aya awan, tu ɗo vədal aya awan, aday anà ɗo hurof aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Natiya Mbərom i ɗaf apak alay sə mazlaɓ anahan, anga ɗo ataya nà, ti mba apan sə hamak anan uda bay. Əna Mbərom i i hamak anan uda awan, pə luvon anahan saa slabakay anan ahay ɗo ɗiɗek aya à məke wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Natiya kutok, ɗowan a inde à wulen su ɗo sa pa ɗaf pə kərtek a tatə Yesu ataya, a sləne jike sa 'am ata cəna, a wa: «Ataslay mivel i təran anà ɗo sa pa way sa pa anahan à bahay a Mbərom inde ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Coy Yesu a mbəɗahan apan kutok, a wa: «Ɗowan a inde, a ga azar uko məduwen awan, a da way sa pa, aday a ngaman apan anà ɗo ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Alay sa pa ɗaf i sa sla kutok nà, a jan anà ɗo si mer su way anahan, a wa: “Zla, ka sa jan anà ɗo uno sə ngaman atan ataya nə, tâ nay həna kutok, anga way sa pa mə lavay zek a coy.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Əna ɗo a mə ngamay ataya fok ta ma nga sa may 'am pi zek wa, ta sa ja: “Mi zlak ayak sabay.” Ɗo mama'am a a jan anà ɗo maslan ata, a wa: “Nə sukumak guvo həniniye. Ni zla təktek saa cay apan aday, na gak kem, â sa cəɓak bay ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Ɗo hinen ite a wa: “Nə sukumak sla ahay kuro. Suwan nâ sa cay pə mer su way a tinen aya aday. Na gak kem. Â sa cəɓak bay ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Ɗo hinen ite asa a wa: “Nen nə gəɓay dalay həniniye, anga nan, ni mba apan sa zlak ayak həna bay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Natiya kutok, ɗo maslan ata a ma agay à man ana bahay su doh anahan, a təkəren anan way ataya fok. Way ata a cəɓan anà bahay su doh ata kutok, a jan anà ɗo maslan anahan ata, a wa: “Zlak ayak nə anga anga à man sə halay nga sə ɗo ahay ahay tə məgəzləga cəveɗ ahay à wulen su doh inde, aday ngaman ahay anà ɗo mətawak aya awan, anà ɗo mə təra à məndak aya awan, anà ɗo hurof aya awan, aday tu ɗo vədal aya təke fok.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ɗo si mer su way ata a zla saa ngaman ù ɗo ataya awan. Anjahay capəpa nà, a may agay, a nay, a jan anà bahay su doh anahan nà: “Kawa iken su jo ata nà, nə ngamak anan ahay ù ɗo ataya awan, əna doh kə̀ rahak fan bay. Man mə mbəsak a inde mba.” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Bahay su doh ata a jan anà ɗo si mer su way anahan ata asa, a wa: “Zla pə cəveɗ sə kiɓe ahay fok, à guvo ahay. Kâ jan anà ɗowan aya iken saa tan atan à nga ataya fok nà, təktek tâ nay ahay, anga aday doh uno â rah. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tə ɗiɗek a nà, ɗo a mə ngamay a mama'am ataya aday sə ngəmay ahay bay ata nà, ti naa tukom way sa pa uno sabay.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pə dəɓa anahan a wa, à alay a Yesu winen pə cəveɗ mba ata nà, ɗo ahay bayak a tinen apan ti pərahan azar. Coy, a ma iɗe à dəɓa, a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ɗowan kə̀ pərahak uno ahay azar, aday a nan sə təra njavar uno nà, â pəlay nen, zal bəbay anahan, zal may anahan, zal uwar anahan, zal gwaslay anahan ahay, zal mərak anahan ahay, aday zal zek anahan a təkeɗe re! ");
INSERT INTO mqbNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kak ɗowan a kə̀ tavakak dədom anahan mə zləlngaɗ a aday kə̀ pərahak uno azar bay cəna, kà slak sə təra njavar uno bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Matanan, kak ɗowan inde à wulen a kwanay, a nan sa han doh məduwen a lele a nà, i njahay tun, sə bayak apan aday biɗaw? I jan à nga anahan kutok: “Doh ata i sa ndav nà, i pa puno fok nə dala jugumaw?”, i san anan pi zek wa aday re ba? ");
INSERT INTO mqbNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bina, kà sak a pak a saray awan, aday doh ata kə̀ ndəvak sa han sabay nə, ɗo sə canan ataya nə ti mbasay apan biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ɗo ataya ti ja nà: “Ɗowan a həna kə̀ pəkak saray su doh, əna kà mbak pi zek sa ndav a wa sabay!” ");
INSERT INTO mqbNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Matanan re, kak bahay a inde, a nan sa ga vəram tə bahay su kon hinen nà, i njahay tun sə bayak apan aday biɗaw? I ca apan ɗo anahan ahay nə tinen mbulo kuroroo nà, i sla pi zek sa ga vəram tu ɗo mbulo kwa kuro cew nà, i san anan pi zek wa aday re ba? ");
INSERT INTO mqbNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kak bahay ata kà cak apan i sla pi zek saa ga vəram tə ɗowan ata tətibay cəna, i slan ɗo maslan ahay pə cakay anà bahay a hinen ata, à alay a winen dəren mba, i man ù vo ta sa man ayak 'am pi zek wa anga aday tâ njaɗ zay. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","«Natiya awan, kak ɗowan kə̀ mbəsakak anan way anahan ahay fok bay nà, i mba apan sə təra njavar uno bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Pə dəɓa anahan wa nà, a jan atan 'am sə jike asa, a wa: «Kə sənen apan zle, zətene nà, way lele awan. Əna aday kak zətene ata a vaɗ sabay nà, ti man anan ahay avaɗ anahan a hərɓeɓe ata, awana mba anaw? Inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Zətene ata nà, kə̀ tərak way kəriya awan, i təra way lele a anga yugo sabay, aday i təra way lele a kawa bərbor sabay re. Ɗo ahay ti guce anan nə uho kəriya awan. Natiya kutok, sləmay inde pə ɗowan a sə sləne 'am a anan nà, â sləne.» ");
INSERT INTO mqbNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Natiya, ɗo sə cakal jangal ahay, pi zek tu ɗo sə atahasl ahay bayak awan, tə halay nga à man a Yesu anga aday ti sləne 'am anahan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Anga nan, Farisa ahay tə Miter sə Tawrita ahay ta ma nga sa ja 'am à wulen a tinen a inde ngura ngura ngura, ta wa: «Ɗowan a anan a təma aday ɗo sə atahasl ahay tâ pa way tə winen nà, angama aday anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Anga nan kutok, Yesu a gan atan jike sa 'am a anan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Izəne ɗo inde à wulen a kwanay, aday təman anahan ahay inde səkat. Kwa â ga sə lize nə kərtek a dəp nà, i mbəsak azar sə təman a kwa kuro dəsuɗo nga dəsuɗo ataya à kiɓe, aday i zla saa pəlay anan ahay kərtek ata hus pa sa njaɗay anan ahay re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aday, kə̀ njaɗak anan ahay təman a kərtek ata nà, i ɗəfay a way anahan jap pə jugom, i may agay nə, tə ataslay mivel a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kə̀ dəzlek ahay agay nà, i ngaman ahay anà car anahan ahay, tu ɗo sə cakay su doh anahan ahay, aday i jan atan: “Tasluko mivel, anga nə njaɗak anan ahay təman uno a sə lize ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","«Natiya awan, həna, nen apan ni jak ikwen, kak ɗo sə atahasl kərtek kə̀ yimak pə ines anahan nà, ataslay mivel i ga inde à mburom bayak awan. Ataslay mivel ata i zalay ataslay mivel anga ɗo ahay kwa kuro dəsuɗo nga dəsuɗo ɗiɗek aya, aday ta gan may sa yam pə ines a tinen ahay bay ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pə dəɓa wa a jan atan 'am sə jike hinen asa, a wa: «Uwar a inde nà, karanga anahan ahay inde kuro, aday kak kərtek a kà sak a lize panan nà, i ga kəkəmaw? I han nə uko pə lalam anahan, aday i ca doh anahan ata fok ta sə faɗay anan lele. I pəlay bətek bətek hus pa sa njaɗ anan dala anahan ata biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kak kà sak a njaɗ a dala anahan ata nə, i ngaman anà məndala anahan ahay tu ɗo sə cakay su doh anahan ataya, i jan atan: “Tasluko mivel pə kərtek awan, anga nə njaɗak anan dala uno sə lize ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","«Matanan re, ni jak ikwen, kak aday ɗo kərtek kə̀ yimak pə ines anahan ahay nà, maslay a Mbərom ahay ti taslay mivel anga winen re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu a ja asa, a wa: «Ɗowan a inde nà, wan anahan ahay inde cew. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wan zek cəɗew ata a jan à bəban anahan, a wa: “Bəbay uno, vuro anan zlile uno nen saa njaɗ à alay saa pa 'am anak azana ata awan.” Aday ɗowan ata a gəzlan atan anan zlile anahan acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Pə dəɓa wa mənjœk nà, wan a cəɗew ata a halan nga anà way anahan ahay fok, a sukom a way, aday a zla way anahan pə daliyugo hinen dəren. À man ata nà, a lize anan zlile anahan ata fok ta sə gəsle anan pə way kəriya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","«Dala a ndav panan cəna, may a ga pə daliyugo ata tə mindel. Ɗəce sə way sa pa ɗukwen a dazlan saa gan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Anga nan, a zla saa ga mer su way àga ɗo su kon ataya awan. Ɗowan ata a slan anan saa ba gadura ahay à kiɓe. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A pəlay abay sa pa way sa pa mbala ana gadura ahay ata awan, anga may a han apan, əna ɗowan a ngəman a bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«A dazlan sə jalay pə anjahay anahan à alay a winen àga bəbay anahan ata awan, a ja: “Ɗo si mer su way a bəbay uno ahay ɗukwen, tinen apan ti pa way sa pa kawa sa nan atan, a mbəsak patan wa re, aday nen aɗəka bugol ni mac ta may à man a anan nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Suwan ni ma agay, aday ni i jan anà bəbay uno nà: Bəbay uno, na gak ines pa 'am a Mbərom, aday pa 'am anak re. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na slak həna ki ca upo kawa nen wan si zek anak sabay, təra nen kawa ɗo si mer su way anak kərtek awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Natiya a slabak, a may agay kutok. «Bəbay anahan a canan ayak dəren winen apan i nay ahay cəna, a gan ahay ì zek wa. A haw apan, a ban anan həmbok pi zek. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wan ata a jan à bəbay anahan kutok, a wa: “Bəbay uno, na gak ines pa 'am à Mbərom, aday pa 'am anak re. Na slak həna kâ ca upo kawa nen wan si zek anak sabay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«Əna bəbay anahan ata a jan ù ɗo si mer su way anahan ahay, a wa: “Kagasl, gəɓen uno ahay zana lele aya awan, pəken anan pi zek. Ɗəfen anan wurɗek à alay inde, aday pəken anan təkarak à saray inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pəsiken ahay guson sa sla ma har a lele ata awan, wasluko, duko, aday puko tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Anga abay wan uno a anan nà, kə̀ tərak kawa ma mac awan, aday həna winen inde tə sifa awan. Kə̀ lizek coy, əna nə njaɗak a way uno.” Tə dazlan sa ga azar uko tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«À alay a tinen apan ti ga azar uko agay ata nà, wan a ɗowan ata zek məduwen a, winen à guvo. Winen apan i may à guvo wa mba aday i dəzley ahay agay bəse nà, a sləne ɗo ahay tinen apan ti ga ara tə agərav awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A ngaman ù ɗo si mer su way a bəban anahan ahay kərtek, a cəce panan ləbara awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɗowan ata a mbəɗahan apan, a wa: “Mərak anak kà mak agay, aday bəbay a kwanay a vaɗ guson sa sla, anga kə̀ njaɗak anan winen inde zay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Wan a zek məduwen ata a ngam sa zla ù doh sabay. A cəɓan, a ga mivel. Bəbay anahan a nay uho saa dəbukok anan ayak ù doh. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Əna a mbəɗahan apan anà bəbay anahan, a wa: “Ngatay, bəbay uno. Ava bayan awan, nen apan ni gak mer su way nə lele mənjəna sa gak isew. Na taa ɗəfak apan re, aday tə winen ata təke ɗukwen, kula kə varak uno kwa wan sə awak zləkətev a anaya anga sa ga anan azar uko tə məndala uno ahay bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aday wan anak kə̀ lizek anan dala anak tə uwar sa ján uho ahay. Həna a may ahay agay nə kə vəɗak anan guson sa sla anga winen asa re!” ");
INSERT INTO mqbNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Bəbay anahan a jan: “Wan uno, iken nà, iken inde ti nen a hwiya asanaw? Abay way uno ahay fok nà, ananak a biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sumor a nà, ɗi ga azar uko tə ataslay mivel awan, anga mərak anak a anan nà, kə̀ tərak kawa ma mac awan, aday həna winen inde tə sifa awan. Kə̀ lizek coy, əna ɗə njaɗak anan.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pə dəɓa anahan a wa asa, Yesu a jan anà njavar anahan ahay, a wa: «Ɗowan a inde nà, winen zlile awan, aday ɗukwen ɗo inde kərtek sə lavan nga anà ɗo si mer su way anahan ahay re. Əna ɗo ahay ta ma 'am pə ɗowan ata à man a bahay su doh anahan ta sa ja nà: “Ɗo si mer su way anak a anan winen apan i nes anan dala anak kəriya awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","«Bahay su doh ata a sləne 'am ata cəna, a ngaman anà ɗowan ata kwayan'a, aday a jan, a wa: “Nə slənek ɗo ahay ta mak apak 'am. Ɗuko anan mer su way anak iken a sa ga anan tə zlile uno nen sə mbakak anan ata awan, bina iken ki təra ɗo si mer su way uno sabay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Ɗo si mer su way ata a ma nga sə jalay kutok, a wa: “Aday həna jiga nà, ni ga nə kəmaw? Bahay su doh uno kə̀ larak nen ì mer su way anahan wa re. Bənuko jœ, ni mba apan bay, aday ni dubok way pə ɗo ahay wa, wita ɗukwen waray re. Pa ga həna jiga nà, kəma kutok anaw, zek uno? ");
INSERT INTO mqbNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iyo, həna nə njaɗak anan nga sa 'am a nen saa ga ata kutok. Aday kwa bahay su doh uno kə̀ larak nen ì mer su way anahan wa ɗukwen, ɗo ahay ti təma nen àga tinen re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«A ngaman ahay anà ɗo sə təma gudire pə bahay su doh anahan ataya wa kərtek kərtek fok. A cəce pu ɗo mama'am a wa, a wa: “Gudire ana bahay su doh uno inde apak nə jugumaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Ɗowan ata a mbəɗahan apan, a wa: “Gudire sə amar ana bahay su doh anak inde upo, gungwan səkat.” «Ɗo si mer su way ata a jan, a wa: “Ihe, təma ɗerewel sə gudire anak həna kwayan'a. Njahay aday vindey apan nà, gungwan sə amar kwa kuro ɗara bina səkat sabay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«A jan anà ɗo hinen asa, a wa: “Aday iken, gudire ana bahay su doh uno inde apak nə juguma ite anaw?” «A mbəɗahan apan, a wa: “Gudire sa ndaw anahan inde upo buho səkat ɗara.” «Ɗo si mer su way ata a jan nà: “Ihe, gəɓa ɗerewel sə gudire anak kagasl, aday vindey ahay apan nə gudire sa ndaw ata nà, buho səkat fuɗo.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Bahay su doh anahan ata kə̀ varak anan zlangar anà ɗo si mer su way anahan ata awan, anga ɗowan ata kà gak mer su way sə wurwer à wulen a tinen inde. Anga ɗo sə daliyugo a anan aya nà, tə zalay ɗo sə iɗe jiyjay ahay ta sa ga mer su way sə wurwer. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Natiya, nen apan ni jak ikwen, kwanay nà, bənen car tə ɗo ahay tə zlile sə daliyugo a anan aday biɗaw? Ata, zlile sə daliyugo a kà sak a ndav pikwen wa nà, Mbərom i təma kwanay pə cakay anahan a sə coy kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Kak ɗowan aday kà mbak apan sa gan nga anà way bayak a bay ata tə cəveɗ a nà, kwa way bayak a ɗukwen i mba apan sa gan nga tə cəveɗ a re. Aday kak ɗowan a a mba apan sa gan nga anà way bayak a bay ata tətibay nà, kwa way bayak a ɗukwen i mba apan sa gan nga tətibay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Matanan, kak abay ki mben apan sa gan nga anà zlile sə daliyugo a anan tətibay nà, waya saa mbakak ikwen anan zlile ɗiɗek a aday ki gen anan nga anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kak aday abay ki mben apan sa gan nga anà zlile su ɗo hinen ahay tətibay nà, waya sa varak ikwen mbala ana kwanay a saa lavay ata mba asa anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ɗowan saa mba apan sa gan mer su way anà bahay su doh ahay cew nà, ibay. Anga kə̀ pəlak anan ɗo kərtek a lele nà, i nan iɗe anà ɗowan hinen ata awan. Kabay, tə njahak tu ɗo kərtek a lele gerger cəna, i kəɗey anan ɗowan a hinen ata awan. Matanan, ki mben apan sa gan mer su way anà Mbərom aday sə pəlay dala, cew maya ɗukwen, i ga zek bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisa aya inde à man ata tə sləne 'am a Yesu ma ja ataya fok nà, ta ma nga sə mbasay apan anga tinen a aday nà, tə pəlay zlile tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Anga nan, Yesu a jan atan, a wa: «Kwanay aday nà, ki gen anan may, ɗo ahay ta ca pikwen nə, kawa ɗo lele aya awan. Əna cəkəbay Mbərom nà, a san way sə mivel a kwanay aya zle. Bina way aday ɗo ahay tə həran nga ata nà, Mbərom a ca pə way ata ite nə, kawa way ma ga mənjaɗak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kwakwa ata nà, ɗo ahay tə pərahan azar anà Mbərom nə ta sə ɗəfan apan ana Tawrita a Musa tə deftere ana ɗo maja'am a Mbərom ahay. Əna a bənay ahay kwa pə ana Yuhana ɗo sa gan baptisma anà ɗo ahay ata wa nà, ɗo ahay tinen apan ti ɗakay anan ləbara sə bahay a Mbərom mugom awan. Natiya kuwaya kà gak anan may sə ndərɓoc uda zek, anga sə dəzle a uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aya əna, Tawrita a Musa nə lele hwiya. Andav a daliyugo tə bagəbaga mburom nà, wita way ma da 'am a bugol bay. Ma da 'am a aɗəka nà, sə lize a wa alfabe kərtek à Tawrita a Musa wa, i ga zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Matanan re, kuwaya kə̀ rəzlak anan uwar anahan, aday kə̀ gəɓak uda uwar hinen nà, wita kà gak mədigweɗ. Ɗowan kə̀ gəɓak uwar a ma razl a ata ɗukwen, winen kà gak mədigweɗ ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pə dəɓa anahan a wa asa, Yesu a jan atan, a wa: «Ɗowan a inde nà, winen zlile awan. Zana anahan a sa pak pi zek təkeɗe nà, lele awan, aday sə dala bayak a re. Pə luvon, pə luvon fok nà, winen mə njahay a nə, à barbarar inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ɗowan a inde ite, tə ngaman Lazarus, winen mətawak awan. A taa nahay nə pə məsudoh a ɗowan ata awan, aday zek anahan a ɗukwen, mbəlak a ɗəkɗek. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A gan may sa pa way sa pa sə pəpasay pə ɗowan a zlile ata wa ata awan. Kəla ahay ɗukwen, ta nay ahay sə ndəlkeɗ anan mbəlak a anahan a ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Natiya kutok, ɗowan mətawak ata a mac, aday maslay a Mbərom ahay tə gəɓak anan ayak à man ana Ibərahima, pə cakay a Mbərom. Ɗo sə zlile ata ɗukwen a mac ite re, aday ta la anan à məke. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","À man ata kutok nà, ɗowan a zlile ata, winen apan i ga ɗəce bayak awan. A ca iɗe à mburom, a canan ayak anà Ibərahima tə Lazarus, tinen miya awan, dəren. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A zlah pi zek, a wa: “Ibərahima! Kem, nâ gak ì zek wa ite! Amboh, slan Lazarus, â tar wan sə alay anahan à a'am inde, aday i naa təlo pə miresl aday û go ziyya ite. Bina nen apan ni ga ɗəce ù uko a anan inde tə mindel.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Ibərahima a mbəɗahan ahay apan ite, a wa: “Matanan, wan uno. Əna ənga, bayak pə anjahay anak à alay iken tə sifa mba ata aday. Iken nà, kə njahak à barbarar a inde, aday Lazarus nà, kà gak ɗəce bayak awan. Həna ite nà, winen, winen apan i man uda à man a anan, aday iken ite ɗukwen, ki ga ɗəce kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tə winen ata təke ɗukwen, cəveɗ inde aday ɗo a manay i dəzlek ayak à man a kwanay nà, ibay, kabay ɗo a kwanay i nay à man a manay ɗukwen, i ga zek bay re. Anga məke inde sololo à wulen a nuko.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ɗowan ata a mbəɗahan apan asa: “Amboh, Ibərahima! Kem, slan Lazarus àga bəbay uno ite. ");
INSERT INTO mqbNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anga mərak uno aya inde ɗara nà, u no Lazarus â sa təkəren atan 'am à sləmay ite, anga aday tâ sa nay à man sə ɗəce uno a anan inde sabay ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Ibərahima a mbəɗahan apan asa, a wa: “Tawrita a Musa tə deftere ana ɗo maja'am a Mbərom ahay inde asənə, mərak anak ataya tə̂ ɗəfan atan apan biɗaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Ɗowan ata a jan asa, a wa: “A'ay! Ibərahima, bəbay uno, wuna! Əna, hinahibay ɗo sə məke kà zlak patan dezl nà, ti yam pə ines a tinen ahay tə ɗiɗek awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Ibərahima a jan, a wa: “Matanan. Əna kak mərak anak ataya tə slənek anan anan 'am a Musa tu ɗo maja'am a Mbərom ataya bay cəna, kwa ɗo sə məke a â zla təkeɗe nà, ti slənen a bay re.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu a jan anà njavar anahan ahay asa, a wa: «Hwiya way ahay inde, tinen apan ti zla anan ɗo zənzen a ì ines ahay inde. Aya əna, ɗəce i təran anà ɗo sa njak anan ɗo ahay aday tâ ga ines ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Natiya, ata pə ɗowan a sa njak anan ɗo ahay ata nà, suwan pə winen tə̂ ɓanan van à dungo, aday tə̂ larak anan ayak à bəlay inde. Bina, ɗo aday winen apan i njak ɗo ahay matanan ata nà, Mbərom i ga anan alay tə ɗowan ata zal pa sa lar anan à bəlay inde ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Matanan, liven anà zek a kwanay ahay lele. «Aday, kak mərak anak inde, kà gak ines nà, suwan ɗakan anan tə təpa təpa awan. Winen ite kə̀ təmahak, kə̀ mbəsakak anan ines anahan ata nà, pəsen anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kwa abay â ga winen apan i gak ines pə luvon kərtek a saray cuwɓe, aday winen apan i nay ahay à man anak ɗukwen saray cuwɓe ta sa ja nə “Amboh, nə yimak pə ines uno!” nà, iken ɗukwen, pəsen anan acəkan ite re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Natiya, pə dəɓa anahan a wa nà, ɗo maslan a Yesu ataya ta jan nà: «Ba Məduwen, man umo zek aday aɗaf nga a manay pə Mbərom â zəga ite!» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bahay a tinen ata a mbəɗahan atan apan nà: «Kwa aɗaf nga a kwanay â ga inde nə mənjœk, kawa wan sə bəzan mənjœk nà, ki mben apan sa jan anà dədazl sə ngəvəray: “Ndaha à man a anan wa, aday ka saa njahay à bəlay inde!” ɗukwen, i bənak ikwen à 'am wa re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu a ja asa, a wa: «Hinahibay ɗowan a kwanay kərtek a, aday ɗo si mer su way anahan inde, winen apan i ga mer su way à kiɓe, kabay winen apan i ɓal təman ahay. Kà mak ahay à kiɓe wa nà, bahay su doh anahan i jan: “Hayak ahay, pa ɗaf!” kwayan'a ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","I jan aɗəka bugol nà: “Do ahay way sa pa, mbəɗahan anà zana, aday kâ naa vuro way sa pa tə way sa sa aya awan.” Aday i jan: “Iken, ki naa pa nà, pə dəɓa anahan a wa!” biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kwanay kə jilen nà, i gan suse anà ɗo si mer su way anahan ata anga kà gak anan mer su way ataya ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","«Kwanay a ɗukwen matanan re. Ka sak i gen anan mer su way mbala a Mbərom sa jak ikwen: “Gen anan!” ataya nà, jen aɗəka nà: “Manay nà, ɗo sa ga mer su way anak ahay ca. Ma ga nə mer su way mbala ana manay a saa ga ata awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Natiya, à alay a Yesu winen apan i zla à Urəsalima nà, a zla tə wulen ana daliyugo sə Samariya tə Galile. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A sa jəka i dəzle à wulen su doh a inde nà, tə zlangay tə ɗowan aya inde kuro, mə dugwaɗ aya awan. Tə tavay zaɗ, ");
INSERT INTO mqbNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aday ta jay 'am tə məgalak awan, ta wa: «Amboh Yesu, bahay a manay, mâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu a canan atan ayak ite cəna, a jan atan, a wa: «Zlen, aday ka si ken anan anan zek a kwanay anà ɗo sə gəɗan dungo anà way ahay anga Mbərom.» À alay a tinen apan ti zla à man ana ɗo sə gəɗan dungo à way ahay ataya kutok nà, tinen a fok tə mbərak. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Əna ɗo a kərtek à wulen a tinen ata wa, a ca apan kə̀ mbərak ata nà, pəlasl, a ma pə dəɓa à man a Yesu, a dazlan sə həran nga anà Mbərom tə məgalak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A dəzley ahay à man a Yesu cəna, a dukwen gərmec ta sə rihen nga ù vo, a ngəran kutok. Ɗowan ata nà, winen Samariya ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu a cəce kutok, a wa: «Na wa, ɗo a kuro ataya fok nà, tə mbərak re ba? Aday azar su ɗo a dəsuɗo ataya nà, tinen aha kəlanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ɗowan sə jalay apan aday sa naa ngəran anà Mbərom nà, ibay, si mədurlon a anan taayak kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pə dəɓa wa kutok, a jan anà ɗowan ata awan: «Slabak, zla way anak. Mbərom kə̀ mbərak iken anga kə ɗəfak upo nga.» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Natiya, pə dəɓa anahan a wa kutok Farisa ahay tə cəce pə Yesu wa, ta wa: «Bahay a Mbərom a i sa slay ahay nà, siwaw?» Winen a mbəɗahan atan apan, a wa: «Bahay a Mbərom a i slay ahay aday nà, ɗowan i canan tə iɗe bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɗowan i mba apan sa jəka: “Bahay a Mbərom nə winen həna” kabay “Winen tiya” bay re. Əna, sənen apan lele, bahay a Mbərom nà, winen à mivel a kwanay aya inde aɗəka coy.» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pə dəɓa anahan a wa nà, Yesu a jan anà njavar anahan ahay, a wa: «Alay a inde i slay ahay, aday ki gen anan may sə cinen uno apan way sə luvon kərtek à wulen a kwanay inde. Əna i ga pikwen zek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ti naa jak ikwen asa: “Almasihu nə winen həna” kabay “Winen tiya” nà, kâ sa ngəmen sa zla à man ataya bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anga nen, Wan su Ɗo, ni may ahay nà, kawa awuteɗ a Mbərom sə wuteɗ pəraɗ, aday ɗo ahay fok ta san apan zle ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Əna way ata i saa təra nà, nen Wan su Ɗo ni ga ɗəce bayak awan, aday ɗo a sə wuswes anan aya ɗukwen, ti ngam nen bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«À alay a Wan su Ɗo i may nà, way ahay ti təra nə kawa sə təra à alay ana Nuhu ata re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","À alay ata nà, ɗo ahay tinen apan ti taslay mivel sa pa way ahay, ta sa sa way a tinen ahay, sə gəɓa uwar ahay, aday sa var a dəna a tinen ahay à mbaz, hus pə luvon ana Nuhu sa zla way anahan à kwalalan inde ata kutok. Pə dəɓa anahan a wa cəna, iven sukwat ahay ngəv ngəv kutok, pa rah anan daliyugo nə faɗaɗa, pa lize anan ɗo ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Aday asa, ni i may ahay nà, i ga nə kawa way sə təra à alay ana Ludu ata awan. À alay ata nà, ɗo ahay tinen apan ti pa way, ti sa way ahay, tinen apan ti sukom anan way tə way a tinen ahay, aday tinen apan ti sukom uda re, tinen apan ti casl guvo ahay, aday tinen apan ti han doh ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aday, pə luvon ana Ludu sa nay way anahan à Sodoma wa ata nà, uko pi zek tə mətətok sə uko awan, tə pəkay ahay à mburom wa, dənam lize anan ɗo ataya fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aday pə luvon uno nen Wan su Ɗo saa may ahay ata nà, way ahay ti təra matanan. Ɗowan saa san pi zek nà, ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Əna pə luvon ata kutok nà, ɗo aday winen pa nga su doh ɗukwen â dazay, â haw, əna â sa ray ahay way anahan ahay ù doh wa bay. Ɗowan a winen à guvo ɗukwen, â saa nay ahay agay bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ənga, bayiken pə way a uwar a Ludu sa ga ata aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Matanan, ɗowan a kà gak anan may sa tam anan sifa anahan nà, i lize anan. Aday ɗo sə lize anan sifa anahan nà, i tam anan aɗəka bugol. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","«Nen nà, ni jak ikwen anan acəkan: Pə luvon ata nà, kwa ɗo ahay cew mə nahay a pə lala kərtek a dəp nà, ɗo kərtek a nà, ti gəɓa anan, aday ɗo hinen nə ti mbəsak anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kwa uwar ahay cew tinen apan ti gan pə kərtek a dəp nà, ɗo kərtek a nà, ti gəɓa anan, aday ɗo hinen nə ti mbəsak anan.  ");
INSERT INTO mqbNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kabay ɗo ahay cew tinen à guvo kərtek a inde dəp nà, ɗo kərtek a nə ti gəɓa anan, aday ɗo hinen nə ti mbəsak anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Njavar anahan ahay tə cəce panan kutok, ta wa: «Ba Məduwen, way ata i sa ga zek jiya nà, ahaw?» A mbəɗahan atan apan, a wa: «À man a aday way ma mac a inde ata cəna, mugudok ahay ti halay nga bayak a nà, à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pə dəɓa anahan a wa nà, Yesu a gan jike sa 'am a anan anà njavar anahan ahay, anga aday tâ sa ya nga sa gan amboh anà Mbərom bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A jan atan kutok, a wa: «À wulen su doh a inde nà, bahay sa man ata nə a jəjaran anà Mbərom bay jiga awan, aday a təma 'am a ɗowan itəbay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mədukway sə uwar a inde à wulen su doh ata ite, a taa nay ahay cuhcœh àga bahay ata awan, a jan anà bahay ata nà: “Amboh, go anan sariya uno inde à wulen a manay tu ɗo maniɗe uno ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Əna hwiya bahay ata a ngam sa gan anan sariya anà uwar ata bay, hus sariya anahan ata kə̀ njahak bayak awan. «Coy, bahay ata a jalay à mivel anahan inde, a wa: “Kwa abay nə jəjaran à Mbərom bay, kwa nə təma 'am su ɗo bay təkeɗe nà, ");
INSERT INTO mqbNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","suwan ni gan anan sariya anahan a anan. Bina mədukway sə uwar a anan winen apan i taa wuse nga ta sa nay ahay àga nen sidew sidew anga 'am sə sariya anahan a anan.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pə dəɓa anahan a wa kutok nà, Bahay Yesu a jan atan asa, a wa: «Ənga, jilen pə way a bahay a sa ga ata lele aday! ");
INSERT INTO mqbNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kwanay kə sənen apan ite bay ɗaw? Matanan, Mbərom bugol nà, i man zek anà ɗo anahan sa taa gan amboh luvon tə ipec ataya re biɗaw? I ga apan munok bay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nen apan ni jak ikwen anan həna: Mbərom i man zek anà ɗo anahan ataya bəse. Aya əna, nen, Wan su Ɗo ni saa may ahay pə daliyugo nà, ni tan ahay à nga anà ɗo sa ɗaf upo nga ahay dəp ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Natiya, ɗo azar aya inde à man ata, tinen tə jalay nà, tinen ɗo ɗiɗek aya awan. Aday tə kəɗey anan ɗo azar aya re. Anga nan, Yesu a gan atan jike miza asa, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Ɗowan aya inde cew ta zla ù doh sə mazlaɓ a Mbərom saa ga amboh. Ɗowan a kərtek a nà, Farisa ahay, aday ɗo hinen ite nà, winen ɗo sə cakal jangal. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Farisa ata a tavay, a ga amboh à mivel anahan inde, a wa: “Mbərom, suse anak anga nen nà, ɗo mi nes a kawa ɗo azar aya ite bay. Aday nen ɗukwen kawa ɗo sə cakal jangal a anan ite bay re. Nen ɗo sə akar bay, na ga mədigweɗ bay, aday nen huwan a bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na ga sumaya pə lumo fok nə, saray cew. Nə njaɗak way cəna, à kuro wa fok nà, nə varak anan kərtek awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Ɗo sə cakal jangal ata ite, a tavay dəren, a nan sa ca iɗe à mburom bay fok. A ma nga sə jalay mərava si zek anahan, a wa: “Mbərom, amboh. Nâ gak ì zek wa ite, anga nen nà, ɗo sə atahasl.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Natiya, Yesu a ndav anan kutok, a wa: «Sa zla agay ɗiɗek a pa 'am a Mbərom a nà, ɗo sə cakal jangal ata awan, bina Farisa ata bay. Anga ɗowan kə̀ hərak anan nga ì zek nà, Mbərom i man anan nga anahan à məndak. Aday ɗowan kà mak anan nga anahan à məndak ite nà, Mbərom i həran nga aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Natiya, pə dəɓa anahan a wa kutok nà, ɗo ahay ta nan anan ahay gwaslay cacəɗew aya anà Yesu, anga aday â ɗaf patan alay sə ngama. Əna njavar anahan ahay ta ca apan ɗo ahay tinen apan ti nay anan ahay gwaslay ahay ata nà, ta ma nga sə gafan 'am anà ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu a ngaman ahay anà gwaslay ahay pə cakay anahan, aday a jan anà njavar anahan ataya ite, a wa: «Mbəsiken anan ahay gwaslay ahay, kə̂ gifen atan 'am sa nay ahay pə cakay uno bay, anga bahay a Mbərom mə lavay zek a aɗəka nà, anà ɗo sa ga minje tə tinen anaya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya kə̀ təmahak Mbərom bahay anahan kawa wan cəɗew bay nà, Mbərom i ga apan bahay kula itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pə dəɓa anahan a wa nà, bahay a inde a cəce pə Yesu wa, a wa: «Miter, lele a anan, ni ga nə ma aday ni saa njaɗ sifa sa ndav bay ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu ite a mbəɗahan apan, a wa: «Ka wa nen lele a nà, angamaw? Ɗowan inde lele ibay, si Mbərom a kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na wa, ka san nga sa 'am a Mbərom mə baslay aya zle asanaw? Kâ ga mədigweɗ bay, kâ vaɗ nga su ɗo bay, kâ ga akar bay, kâ gaɗ mungwalay pu ɗo bay, ɗəfan apan anà atə bəbay anak tə may anak.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɗowan ata a mbəɗahan apan kutok, a wa: «'Am ataya fok nà, nə bənak atan lele, kwa à alay a nen cəɗew a mba.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu a sləne 'am a ɗowan ata cəna, a jan nà: «Tə winen ata təke nà, way inde kərtek kə̀ mbəɗəkek panak re: Zla, sukom anan way tə way anak ahay fok, aday kə̂ gəzlan anan dala a anà ɗo mətawak aya awan. Matanan kutok, ki i njaɗ zlile anak à mburom. Aday hayak, pəruho azar.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Əna ɗowan ata a sləne anan 'am a Yesu ata cəna, a cəɓan, anga winen zlile awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu a zəzor anan ɗowan ata lele nà, a wa: «Ma dan 'am awan anà ɗo zlile awan sa zla à bahay a Mbərom inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kə sənen apan zle, zlugweme i ndərmaɗ tə məke sə ləpəre nà, i ga zek bay. Əna ma da 'am a sə zalay way ata nà, ɗo sə zlile sa zla à bahay a Mbərom inde ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ɗo sə sləne 'am anahan a sa ja matanan ataya nà, ta wa: «Kak sə matanan cukutok nə, waya saa mba apan saa tam aday sa zla à bahay a Mbərom inde anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu a mbəɗahan atan apan, a wa: «Pu ɗo zənzen a nà, i ga zek bay, əna pə Mbərom nà, way ahay fok a ga zek ca.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pə dəɓa anahan a wa nà, Piyer a jan ite, a wa: «Aday manay həna nà, mə mbəsakak anan way a manay ahay fok sə pərahak azar asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu a jan atan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo aday kə̀ mbəsakak anan doh anahan, kabay dalay anahan, kabay mərak anahan ahay, kabay ɗo anahan ahay, kabay gwaslay anahan ahay anga bahay a Mbərom ata nà, ");
INSERT INTO mqbNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kwayan'a həna, i naa njaɗ anan uda way anahan ataya bayak awan, zal panan aɗəka. Aday i njaɗ anan uda way anahan ahay cəna coy bay re. Azanan, pə uho saa nay ata nà, i naa njaɗ nà, sifa sa ndav bay ata pa 'am re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Natiya, Yesu a ngaman anà ɗo maslan anahan a kuro nga cew ataya ɗemɗem kəcah à wulen sə ɗo ahay wa, a jan atan nà: «Ihe, pəken sləmay pa 'am a anan aday. Sənen anan həna, mənuko apan ɗi zla à Urəsalima. À man ata kutok nà, way ana ɗo maja'am a Mbərom ahay sə vinde pi nen, Wan su Ɗo, ataya fok i i ga zek kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ti varan nen à alay inde anà ɗo sə pəra ahay. Tinen ti mbasay upo, ti ro mindel, ti cəre upo məne, ");
INSERT INTO mqbNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ti ndaɓay nen, aday ti i vaɗ nen kutok. Əna cəkəbay aday, pə luvon maakan anahan a nà, ni i slabakay ahay way uno à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Am anahan a sa jan ù ɗo maslan anahan ataya nà, tinen tə sənak anan 'am ata bay jiga awan. Pə tinen nà, 'am ata mi ɗer a mba, anga 'am ata a nan sa ja nə maw nà, tə sənak a bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Natiya, à alay a Yesu winen apan i dəzle à wulen su doh sə Yeriko bəse coy nà, hurof a inde mə njahay a pə cakay cəveɗ, winen apan i dubok way pə ɗo ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ɗowan a hurof ata a sləne nə ɗo ahay tinen apan ti zla tə cəveɗ ata nà, a cəce patan wa, ləbara awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɗo ataya ta jan nà: «Yesu ɗo sə Nazaratu, winen apan i zla tə cəveɗ a anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A sləne 'am ata cəna, a zlah pi zek, a wa: «Yesu, wan ana Dawuda, nâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ɗo mə lahay a pa 'am a Yesu pə cəveɗ ataya ta ma nga sə gafan 'am, ta jan nə: «Tacay 'am. Njahay tete.» Əna hwiya ɗowan ata a ngam sə təma 'am a tinen ata bay. A ma nga sə zakay anan azlah tə məgalak a bugol, a wa: «Amboh, wan a Dawuda, nâ gak ì zek wa ite!» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu a sləne 'am anahan ata nà, a tavay jek, a jan ù ɗo ataya nə: «Ənga, bənen anan ahay alay à man uno a aday.» Tə bənan ahay alay à man a Yesu awan. A dəzley pə cakay anahan a nà, Yesu a cəce panan kutok, a jan: ");
INSERT INTO mqbNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«A nak nâ gak nə maw?» Ɗowan ata a mbəɗahan apan, a wa: «Ba Məduwen, u no, təɓo anan iɗe uno ahay ite!» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu a jan: «Kə mbərak coy! Ka mbar nà, anga kə ɗəfak upo nga ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kwayan'a, ngurret iɗe anahan ahay tə təɓak acəkan. Winen ite gədek sə pərahan azar anà Yesu. A dazlan sə həran nga anà Mbərom, aday ɗo sə canan anà way ata fok, ta ma nga sə həran nga anà Mbərom ite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Natiya kutok, Yesu a dəzle à Yeriko, aday winen apan i zla tə wulen su doh ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ɗowan a inde à wulen su doh ata, tə ngaman Zakayus, winen zlile awan, aday winen bahay su ɗo sə cakal jangal ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A gan may sə canan anà Yesu ite, əna a mba apan sə canan bay, anga ɗo ahay inde bayak awan, aday ɗukwen winen ɗo betele a re. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A haw pa 'am, a ján ì sé sə ngəvəray inde, anga aday â canan à Yesu, bina Yesu winen apan i zla tə cəveɗ sa man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu a dəzle ù vo sə ngəvəray ata nà, a cak ayak uda iɗe, aday a canan ayak anà Zakayus. A jan ayak, a wa: «Zakayus, dazay ahay kagasl bəse. Bina, biten nà, ni zla àga iken, nen nə mbəlok anak awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayus a sləne 'am ata cəna, a dazay ahay ì sé ata wa kwayan'a, ta zla tə Yesu àga winen awan, a təma anan Yesu tə ataslay mivel awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ɗo ataya fok tə canan anà Yesu sa zla àga Zakayus ata nà, a cəɓan atan. Anga nan ta ma nga sə gəɗan azar, ta wa: «A zla àga ɗo sə atahasl a anan jiga nə ləbara maw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Natiya kutok, Zakayus a tavay pa 'am a Yesu, a jan: «Miter, nen nà, ni gəzla anan zlile uno wurasl ì zek wa, aday ni varan anan əngal awan, anà ɗo mətawak aya awan. Aday asa, kak way su ɗo inde nə ngəzərak panan tə danakay ɗukwen, ni man anan uda məcapar fuɗo.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu a mbəɗahan apan, a wa: «Biten a anan nà, zay a Mbərom kə̀ tərak à gulom su doh a anan, bina Mbərom kə̀ təmak iken. Iken a ɗukwen, zahav ana Ibərahima guzgwez a re asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anga, nen Wan su Ɗo, na nay ahay nà, sə pəlay ɗo mə lize aya awan, aday sa tam atan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pə dəɓa anahan a wa nà, Yesu a gan jike sa 'am anà ɗo sa pak sləmay pa 'am anahan ataya awan. Anga tinen tə bayak nà, Yesu i saa dəzle à Urəsalima nə, bahay a Mbərom i i kay zek uho kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Anga nan a jan atan, a wa: «Ɗowan a inde nà, winen ngəlaw awan, a slabak sa zla pə daliyugo dəren awan, anga aday ti i ɗəfay anan ahay bahay a pu ɗo anahan ahay, aday i may agay. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","À alay a winen apan i ra zek sa zla nà, a ngaman anà ɗo si mer su way anahan azar aya kuro, aday a gəzlan atan dala sə mbəɗa anan alay anà tinen a fok. A varan anà kuwaya fok dala sə gura kərtek. A jan atan nà: “Mbəɗihen anan alay, hus pə luvon uno saa may ahay ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Pə dəɓa anahan a wa nà, ɗo a sə wulen su doh anahan ataya tə sləne sa jəka winen kà zlak pə daliyugo dəren a aday ti ɗəfay anan ahay bahay pa nga a tinen ata nà, a cəɓan atan anga tə pəlay anan bay. Anga nan ta slan ɗo ahay à dəɓa anahan wa saa jan anà ɗo sa man ataya nà: “A nan umo ɗowan ata â njahay bahay a pa nga a manay bay.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Tə winen ata təke ɗukwen hwiya tə ɗəfak anan ahay bahay a pa nga a tinen təktek. Winen a may ahay agay kutok. A ngaman anà ɗo anahan a winen sə gəzlan atan dala ataya fok, aday a nan sa san, ta ga nə ma tə dala anahan a sə gəzlan atan ata anaw. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Ɗo mama'am awan, a nay ahay, a jan: “Bahay uno, iken kə vuro nə dala sə gura kərtektəkke. Əna dala anak kə̀ wahak ahay apan kuro, uwec wa may sə dala a re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Bahay ata a mbəɗahan apan, a wa: “Ka gak mer su way lele tə way bayak a bay awan. Anga nan, həna ni ɗaf iken bahay awan, aday ki lavan nga anà wulen su doh ahay kuro.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ɗo mə slala cew awan, a nay ahay ite, a jan: “Bahay uno, iken kə vuro dala sə gura nə kərtektəkke, əna dala anak kə̀ wahak ahay apan ɗara, uwec wa may sə dala a re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Bahay ata a mbəɗahan apan, a wa: “Iken ɗukwen ka gak mer su way lele a re. Nə ɗəfak iken bahay awan, ki lavan nga anà wulen su doh ahay ɗara ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Ɗo hinen a nay ahay ite asa, a jan anà bahay ata, a wa: “Bahay uno, dala anak həna, nə ndakak apan man a zana inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nə jəjarak tə mindel. Na san zle, iken ɗo jinje awan. Anga à man a aday kə ɗəfak ayak way bay, ka zla sa ray ahay way à man ata wa re. À man a aday kə caslak ayak way bay, ka zla sə cəray wa way re.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Bahay ata a mbəɗahan apan, a wa: “Iken nà, ɗo lelibay awan. Ni gak sariya pa 'am anak a anan. Ka san apan zle nen nà, ɗo jinje awan. À man a nə ɗəfak way bay ɗukwen nə gəɓay ahay wa way re. Aday à man a nə caslak awan bay ɗukwen, nə cəray wa way re biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kak sə matanan nà, kə nduko ayak man pə dala uno à bank bay nà, angamaw? Aday ata na mak agay nà, kagasl ni tan ahay à nga nə kə̀ wahak apan biɗaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«A jan anà ɗo ahay kutok, a wa: “Təmihen panan dala a kərtek a anan, aday viren anan anan apan anà ɗo a aday dala anahan kə̀ wahak apan wan a kuro ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Tinen tə mbəɗahan apan ite, ta wa: “Ba Məduwen, winen bugol nà, dala anahan nə inde kuro asənə, mi varan anan apan asa ɗaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«A jan atan, a wa: “Nen nà, ni jak ikwen anan: Kuwaya way anahan inde cəna, ti zəgahan anan apan aɗəka, əna ɗo aday way anahan nə mənjœk ata nà, ti ngəzar panan kwa mənjœk anahan ata re. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aday ɗukwen, abay kurre ata nà, ɗo maniɗe uno ahay ta gan may nə̂ təra bahay a bay bugol asanaw? Əna kagasl, ənga, bənen atan ahay pa 'am uno à man a anan, aday kə̂ vəɗen atan kutok.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pə dəɓa ana 'am anaya wa nà, Yesu a njahan pa 'am wa anà ɗo ahay, sa zla à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tə dəzle bəse tə wulen su doh sə Baytifaji tə Baytiniya, pə cakay ana culok sə ngaman Ulivet ata nà, a slan njavar anahan ahay cew ta sa jan atan nà: ");
INSERT INTO mqbNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Zlen à wulen su doh a tiya pa 'am a kwanay ata awan. Kə dəzlen à man ata nà, ki ten anan à nga anà wan sə zungo a inde ma ɓan awan, aday ɗowan kə̀ jənak apan kula bay re. Natiya, pəsiken anan ahay, aday hayak ikwen anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kak ɗowan a kə̀ cəcihek pikwen wa “Ki i gen anan maw?” nà, jen anan: “Bahay a gan may.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɗo maslan a cew ataya ta zla kutok, ta tan ayak à nga nà, kawa ana Yesu sa jan atan ayak ata acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tə dazlan sə pəsak anan zungo ata nà, bahay sə zungo ataya tə cəce patan wa, ta wa: «Ki pəsiken umo anan wan sə zungo a nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tə mbəɗahan atan apan nà: «Bahay a manay a gan may.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta nan anan ahay zungo ata anà Yesu kutok, tə ɓəɓat apan zana a tinen ahay, aday tə zləzlam anan apan Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tə dazlan sa zla kutok nà, ɗo ahay tə wadaɗ zana a tinen ahay pə cəveɗ. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Natiya, à alay a tinen apan ti dəzle à Urəsalima bəse, à man sə kəkarak anan ayak ɓəzlom sə Ulivet ata nà, njavar anahan ahay fok tə taslay mivel. Ta ma nga sə həran nga anà Mbərom tə məgalak awan, anga masuwayan a tinen a sə canan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ta wa: «Mbərom â ɗaf alay sə mazlaɓ anahan pə bahay a saa nay tə sləmay anahan ata awan.» «Zay inde à mburom! Mbərom, winen Bahay sə mazlaɓ!» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisa aya inde à wulen su ɗo ataya awan, ta jan à Yesu nà: «Miter, jan anà njavar anak anaya nə, tə̂ mbəsak sə bəbal awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Əna Yesu a mbəɗahan atan apan, a wa: «Nen, ni jak ikwen, kwa tinen tə̂ njahay way a tinen təkeɗe nà, kon ahay ɗukwen ti zlah re asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","À alay a tinen apan ti dəzle à Urəsalima bəse coy ata nà, Yesu a canan ayak anà Urəsalima, aday a dazlan sə yiman anan anà wulen su doh ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","A wa: «Iken, wulen su doh a anan, abay kâ san zay a sə dəzley ahay apak biten a anan ata nà, suwan biɗaw? Əna way ata kə̀ ɗərek panak zek həna, anga nan kə sənak a bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wawayah wuna, iken wulen su doh a anan. Luvon anak a inde i slay ahay mba. Ɗo maniɗe anak ahay ti vak nga tə way sə alay aya awan, tə day ahay wa fok. Ti tacay iken. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ɗo maniɗe anak ataya ti lize iken tə gwaslay anak aya təke. Ti mbazl a way ahay nə fok, kon hinen saa ɗinger zek pə hinen nà, ibay. Way ataya ti təra nà, anga kə sənak pə luvon a Mbərom a sa nay aday sa mak zek ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pə dəɓa anahan a wa kutok, Yesu a zla ù doh sə mazlaɓ a Mbərom. Aday a dazlan sə rəzlay a wa ɗo sa ga uda masa ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A jan atan nà: «Ihe! Mə vinde a à Deftere a Mbərom inde nà, natiya awan: “Ti ngaman anà doh sə mazlaɓ uno nà, doh sa ga amboh.” Aday kwanay kə təren anan həna, lar su ɗo sə ngəzar ɗo ahay a nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pə dəɓa anahan a wa kutok, a taa wazay ù doh sə mazlaɓ a Mbərom ata nà, pac pac. Əna bahay sə gəɗan dungo anà way ahay, tə miter sə Tawrita ahay, aday tu ɗo sə lavan nga anà ɗo ahay ahay nà, ta gan may sa vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Əna cəveɗ a aday ti i ban anan nə kəkəmaw ata nà, tə sənak bay, anga ɗo ahay inde bayak a sa ta pak sləmay pə atətak way anahan nə lele tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Natiya, pə luvon a inde nà, Yesu winen apan i tətakan anan way anà ɗo ahay ù doh sə mazlaɓ a Mbərom. Aday winen apan i ɗakan atan anan 'am sə ləbara mugom a re. À alay ata kutok ite, bahay sə gəɗan dungo anà way ahay anga Mbərom, tə miter sə Tawrita ahay, pi zek tə məceɗ sə Yahuda ahay tə həɗəken ayak pə cakay anà Yesu, ");
INSERT INTO mqbNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tə cəce panan, ta wa: «Ɗakan umo anan aday, ka ga way anak a anan ataya nə tə məgala ana wayaw? Sə varak cəveɗ a nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu a mbəɗahan atan apan, a wa: «Nen ɗukwen ni cəce pikwen wa way kərtek aday re. Jen uno ite aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sə slənay anan ahay Yuhana sa gan baptisma anà ɗo ahay nə wayaw? Mbərom ɗaw, kabay ɗo zənzen a ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tinen ite, tə mbəɗa 'am pi zek a tinen awan, ta wa: «Ɗi jan həna nà, kəkəmaw? Kak ɗa sak a jəka, Mbərom sə slənay anan ahay nà, i jak uko asa: “Kak kə sənen apan zle cukutok nà, kə ɗəfen apan nga bay nə angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aday kak ɗa sak a jəka, ɗo zənzen a sə slənay anan ahay nà, ɗo ahay ti tar mənuko tu kon, anga tə ɗəfak apan nga, Yuhana nà, winen ɗo maja'am a Mbərom acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Anga nan kutok, tə mbəɗahan apan anà Yesu, ta wa: «Ma san bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu a wa: «Kak sə matanan cukutok ata nà, nen ɗukwen ni ɗakak ikwen anan ɗowan a sə vuro məgala sa ga mer su way anaya bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pə dəɓa anahan a wa nà, Yesu a gan jike a anan anà ɗo ahay, a wa: «Ɗowan a inde a jule təroz à guvo. A mbakan anan guvo à alay inde anà ɗo si mer su way ahay, a zla way anahan à man dəren awan. Kə̀ njahak ayak bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","«Natiya, alay a a sla kutok, way ahay ɗukwen tə nahak, bahay sə guvo ata a slənay ahay ɗo maslan anahan sa naa təmahan ayak way sə guvo ata pu ɗo anahan a sə mbəsak atan à guvo anahan ataya wa. Əna ɗo si mer su way ahay tə canan anà ɗo maslan ata cəna, ta ban anan, ta ndazl anan leɗəɗɗe. Tə mbəsak anan, a zla agay alay kəray awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","«Bahay sə guvo a slənay ɗo miza re, winen ɗukwen ta ndazl anan, tə walay panan agənah pəleslesle, ta razl anan, a ma way anahan alay kəriya re. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bahay sə guvo a slənay ɗo mə slala maakan a re. Pə winen ite nà, ta ga apan mbəlak bayak awan, aday tə rəzlay anan ahay à guvo wa re. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Bahay sə guvo a wa: “Aday ni ga həna nà, kəkəma aday anaw? Suwan ni slan wan uno ləliwe a anan. Winen nà, izəne ti ɗəfan apan ite.” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Cəkəbay ɗo sa ga mer ahay tə canan anà wan ata aɗəka nà, ta ja à wulen a tinen inde, ta wa: “Sa naa pa 'am sə guvo a aɗəka nə winen. Bənuko anan, vəɗuko anan. Ata guvo a anan i təra a mənuko.” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wan ata a sa dəzlek ayak siwa a cəna, tə ngəza anan uho à guvo wa, ta zla anan zaɗ, ta vaɗ anan à məke sa ndaw kutok.» Pə dəɓa anahan a wa nà, Yesu a jan atan kutok, a wa: «Aday həna nà, bahay sə guvo ata i ga anan ɗo si mer su way ataya nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bahay sə guvo ata nà, i may ahay agay, i lize anan ɗo sa ga mer à guvo anahan ataya fok. Aday i varan anan guvo ata anà ɗo maza aya awan.» Əna ɗo sə sləne 'am ana Yesu ataya tə mbəɗahan apan, ta wa: «Wita matanan nà, i ga zek kula bay asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu ite a ca patan, aday a jan atan, a wa: «Ənga, bayiken pə way a mə vinde à Deftere inde a anan aday. Way ata a nan sa ja nə maw? A wa: “Kon mbala ana ɗo sa ɗezl way ahay sa lar anan ata nà, sə təra kon sə mide lele aɗəka nà, winen.” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Kuwaya kə̀ slahak pu kon ata nà, kon ata i nes anan. Aday kon ata kà sak a slahay pə ɗowan a ite ɗukwen, i ngəlaɗ anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","À man ata kutok nà, miter sə Tawrita ahay, pi zek tə bahay sə gəɗan dungo anà way ahay inde re. Tinen ta gan may sa ban anan Yesu, anga ta san zle, Yesu a ga jike sa 'am ata nà, pə tinen awan. Əna ta mbak apan sa ban anan bay, anga tə jəjaran anà man su ɗo awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tə dazlan sə ɗəfan iɗe anà Yesu, ta slan ɗo ahay pə cakay anahan, anga aday ti ca panan azan. Ɗo ataya tə təra anan nga a tinen à man a Yesu nə kawa tinen ɗo ɗiɗek aya awan. Ta gan may sa ban anan à acəce 'am a tinen ahay inde, anga aday ti varan anan anà bahay sə lavay daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɗo ataya tə cəce pə Yesu wa kutok, ta wa: «Miter, ma san zle, way anak sə ɗakay anan, ta 'am anak sa ja ahay fok nà, ɗiɗek aya awan. Pə iken nà, ɗo ahay fok hərro à alay kərtek a wa, iken apan ki ɗakay anan cəveɗ a Mbərom nà, tə ɗiɗek awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Əna mbəɗahan umo pə acəce 'am a manay a inde həna aday: Cəveɗ inde sə varan jangal anà bahay sə Ruma ɗaw? Bəzi mə̂ varan bay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu a san wurwer a tinen a zle. Anga nan a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ənga, viren uno ahay karanga kərtek aday biɗaw?» Tə varan ahay kutok. A jan atan asa: «Ɗiken uno anan aday, pə karanga a anan nà, mezeze a wayaw, aday mə vinde apan nà, sləmay a wayaw?» Tə mbəɗahan apan ite, ta wa: «Wita nà, mezeze tə sləmay ana bahay sə Ruma.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu a mbəɗahan atan apan ite, a wa: «Lele, kak matanan cukutok nà, viren anan anan way ana bahay sə Ruma anà bahay sə Ruma, aday way a Mbərom anà Mbərom a ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɗo ataya ta ca apan nà, Yesu kə̀ bənak atan pə kwande. Ta mbak apan sə njaɗ apan alay sa 'am sa ban anan pa 'am sə ɗo ahay sabay. Aday 'am anahan a sə mbəɗahan atan apan matanan ata ɗukwen kà gak atan masuwayan, tə njahay way a tinen ndəɗek. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pə dəɓa anahan a wa nà, azar su ɗo aya inde, tinen Saduki ahay, ta nay ahay pə cakay a Yesu sə cəce panan 'am. Tinen a aday nà, ta wa ɗo kə̀ məcak nə i slabakay ahay sabay. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tə cəce 'am a anan pə Yesu wa, ta wa: «Miter, Musa kə̀ vindek umo, a wa: “Ɗo kə̀ məcak aday kə̀ mbəsakak uwar mənjəna wan nà, mərak a məsinde â gəɓa anan mədukway sə uwar awan aday ti wahan məgije anà ɗowan a ma mac ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aya əna, ɗowan aya inde cuwɓe, tinen tə mərak ahay. Ɗo zek məduwen awan, a gəɓa uwar, a mac mənjəna sa njaɗ panan wan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɗo sa mban apan a həɗek anan uwar ata mədukway awan, aday kə̀ njaɗak panan wan bay re, ");
INSERT INTO mqbNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","hus pə ɗo mə slala maakan a ɗukwen matanan asa re. A təra nə matanan, matanan, hus tinen a cuwɓe fok tə məcak mənjəna sa njaɗ wan pə uwar ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Coy uwar ata ɗukwen kə̀ məcak à dəɓa wa re. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Əna aday kutok nà, pə luvon saa slabakay ahay à məke wa ata nà, uwar ata i təra nə uwar a wayaw? Bina cuwɓe a tinen a, tə gəɓak anan pa sə uwar a re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu a mbəɗahan atan apan, a wa: «Pə uho a mənuko a anan nà, ɗo ahay tinen apan ti zəɓa uwar ahay, aday uwar ahay ɗukwen tinen apan ti zla à mbaz re. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Əna azanan pə uho saa nay ahay ata nà, ɗo aday ti slabakay à məke wa ataya aday təɗe ta slak sə dəzle uda ataya nà, kwa ɗo mungol aya awan, kwa ɗo uwar aya ɗukwen, ti i gəɓa zek ahay sabay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anga tinen nà, ti mac sabay, tinen kawa maslay a Mbərom ahay coy. Ti təra wan a Mbərom ahay, anga tə slabakak ahay à məke wa coy ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","«Pa 'am sə aslabakay à məke wa nà, Musa ɗukwen kà jak anan cərah awan, ɗo ma mac aya nə ti i slabakay wanahan. À alay ana Musa sə vinde anan ləbara a Mbərom sa jan ahay 'am ù uko sə vəragaz wa ata nà, a vinde, a wa, Bahay a mənuko nà, winen: “Mbərom ana Ibərahima, Mbərom ana Isiyaku, aday Mbərom ana Yakob” biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mbərom, winen nà, Mbərom su ɗo ma mac aya bay, əna winen Mbərom su ɗo tə sifa aya awan. Anga Mbərom a ca pə ɗo ahay fok nà, tinen tə sifa aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Azar su ɗo à wulen sə miter sə Tawrita ataya inde, ta jan a Yesu nà: «Miter, ka jak 'am lele awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pə dəɓa wa nà, kuwaya a jəjar sə cəce panan 'am maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pə dəɓa anahan a wa nà, Yesu a cəce patan wa, a wa: «Kəkəma aday ɗo ahay ta jəka, Almasihu nà, wan ana Dawuda anaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Anga Dawuda a ta nga anahan a ɗukwen kà jak à Deftere Jabura inde, a wa: “Mbərom Fetek a jan anà Bahay uno: Njahay à alay puway uno, ");
INSERT INTO mqbNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","aday ni nahay anan ɗo sa nak iɗe ahay, ki ján patan tə saray.” ");
INSERT INTO mqbNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Kak Dawuda a ngaman anà Almasihu nə “Bahay uno” bugol nà, winen i saa təra wan ana Dawuda nə, kəkəma asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Natiya, Yesu a jan 'am anà njavar anahan ahay pa 'am ana ɗo ataya fok, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ihe, bənen nga a kwanay pə miter sə Tawrita ahay wa. A nan atan sa bar nà, tə rəkot aya awan. Ta gan may nà, ɗo ahay ta jan atan 'am à kwasuko nà, tə akərdeh aya awan, à wulen sə ɗo ahay inde fok. Tinen ù doh sə wazay ahay cəna, ta ca wa ɗukwen man zəbor aya awan. Ta zlak à man sa pa way nà, tə pəlay man sə njahay lele aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tinen apan ti ngəzar way pə mədukway sə uwar ahay wa. Tinen apan ti ga amboh ɗukwen, ta ga nə zeɗeɗeɗe bayak awan, anga aday ɗo ahay tə̂ canan atan. Əna tinen nà, Mbərom i gan atan sariya ma da 'am awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu winen ù doh sə mazlaɓ a Mbərom mba ata, a ca pu ɗo sə zlile ahay nà, tinen apan ti pak dala à kukwar sa pak dala inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aday a canan anà mədukway sə uwar a inde mətawak awan, a gucek ayak uda dala sərɗəɗe aya cew ite, kawa sa ja nà, dala bayak a bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Əna Yesu a jan à ɗo ahay, a wa: «Nen apan ni jak ikwen tə ɗiɗek awan: Mədukway sə uwar a mətawak a anan ata nà, kə̀ varak dala zal ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Anga ɗo ahay fok ta var nà, mənjœk pə way a tinen a bayak a ataya wa. Əna mədukway sə uwar a anan ata, kwa â ga nə winen mətawak a dəp nà, kə̀ ndəvak pi zek. Anga a var anan nà, ta sa pa way anahan a təke fok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Azar su ɗo əngal tinen apan ti ja 'am pu doh sə mazlaɓ a Mbərom ata awan, ta wa: «Ənga, cen pu doh a anan aday, mi ɗezl a tu kon lele aya awan, aday tə way mə varan a anà Mbərom lele ataya awan.» Əna Yesu a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Alay a inde, i slay ahay mba, way a kawa ana kwanay sə canan mə rəɓa a anan ataya fok nà, ɗo maniɗe ahay ti mbazl anan. Kon hinen saa ɗinger zek pə hinen nà, ibay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Natiya, ɗo a sə sləne 'am anahan ataya tə cəce panan, ta wa: «Miter, doh sə mazlaɓ a Mbərom i saa mbazl nə siwaw? Minje sa ma i ga aday mi saa san way ataya ti ga zek bəse anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A mbəɗahan atan apan, a wa: «Liven anan ì zek a kwanay ahay lele, ɗowan â sa njak kwanay bay. Anga ɗo ahay bayak a ti gəɓa sləmay uno, ti nay, kuwaya i ja winen nə Almasihu. Əna kâ sa təmihen sə pərahan atan azar bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ki slənen ləbara sə vəram ahay, aday ɗo ahay ti vəze pi zek ahay kwa aha fok, əna kâ sa jəjiren bay. Anga təktek way ataya ti təra aday. Əna wita kə̀ dəzlek pə andav ana daliyugo fan bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Natiya kutok, Yesu a jan atan asa, a wa: «Kon a anan, i slabak pu kon hinen, bahay a anan i vaɗ zek tə bahay hinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Daliyugo i ɓal, məgara i ga inde, may i ga inde re, way ataya ti təra à man ahay cara cara. Kwa à bagəbaga mburom, minje sə way məduwen aya fok ti təra, aday ɗo ahay ti jəjar. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Əna way ataya ti sa təra aday nà, ɗo ahay ti ban kwanay. Ti varan kwanay à alay inde anà bahay ahay sa gak ikwen sariya ù doh sə wazay ahay, aday ti zla kwanay à dangay. Ti zla kwanay pa 'am ana bahay sə daliyugo ahay, aday pa 'am ana guverner ahay anga kwanay njavar uno ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Way ataya ti təra nà, anga sə varak ikwen cəveɗ sa ga side sa 'am uno pa 'am a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kâ sa bayiken sa jəka “mi i mbəɗahan atan apan nà, kəkəmaw?” ata bay, ");
INSERT INTO mqbNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","anga nen awan, ni ɗakak ikwen a way, aday ni varak ikwen kəlire sa ja 'am. Aday ɗo maniɗe a kwanay ahay ti mba apan sa ja 'am sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","«Ɗo a kwanay ahay, tə mərak a kwanay ahay, tə car a kwanay ahay, ti varan kwanay anà ɗo maniɗe a kwanay ahay, aday ti vaɗ anan azar su ɗo a kwanay aya re. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɗo ahay fok ti nak ikwen iɗe anga kwanay njavar uno ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tə winen ata təke nà, kwa sibœk sa nga a kwanay ahay kərtek a ɗukwen i lize bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tiven lele. Ata ki gen matanan nà, ki təmen anan sifa a kwanay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesu a ja asa, a wa: «Ka sak a cinen anan anà ɗo maniɗe ahay ta vak anan nga anà Urəsalima cəna, ata sənen anan, alay sa mbazl anahan a kà slak coy kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","À alay ata asanaw nà, ɗo sə Yahudiya ahay tâ haw sa ma nga à ɓəzlom ahay inde, ɗo sə wulen su doh sə Urəsalima ataya tâ haw wa. Aday ɗo azar aya tinen à kiɓe ataya ɗukwen, tâ haw re, əna tâ may nga à wulen su doh bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","«Anga pə luvon ataya nà, Mbərom i kəta anan ɗo ahay, kawa ana Deftere sa ja apan ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wuna, pa pac ataya nà, ɗəce inde anga uwar ti zek cew aya awan, aday anga uwar ta wan a à bak ataya re. Ɗəce i ga bayak a pə daliyugo, anga Mbərom i ga mivel pu ɗo sə Yahudiya ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɗo maniɗe ahay ti vaɗ anan ɗo ataya tə maslalam. Ti jaway atan, aday ti zla atan ù kon azar aya cara cara. Ɗo sə pəra ahay ɗukwen ti mbazl anan wulen su doh sə Urəsalima a anan, hus pə alay a tinen a saa ndav.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu a jan atan asa, a wa: «À alay ana Wan su Ɗo saa may ahay nà, ki sənen anan nà, pə minje ana atə pac tə kiya wa, aday pə minje ana mawuzlawazl ahay wa re. Pə daliyugo ɗukwen, zlawan i gan anà ɗo su kon ahay kəzlek, aday ajalay nga a tinen i wuse, i gan atan hərɓəɓəkka, anga agungol ana zəlaka à zlinder. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɗo ahay ti mac nà, anga zlawan a saa gan atan ata cərkəke, aday anga way a saa təra ataya awan. Aday ɗukwen məgala sə way ahay à mburom ataya, ti ɓal re. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","«À alay ata kutok, ti canan anà Wan su Ɗo winen apan i may ahay pa nga sə matapasl ahay pa nga mburom tə məgala awan, aday tə mazlaɓ a bayak a re. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kə cinen anan anà way ataya kə̀ dazlak anan matanan ata cəna, bənen mivel, cen iɗe à mburom, anga alay a kə̀ dəzlek ahay Mbərom i tam kwanay kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pə dəɓa anahan a wa asa, Yesu a gan atan jike, a wa: «Ənga, cen pə buway ti sé azar aya aday. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ka sak a cinen atan tinen apan ti ɗa daslam pi zek nà, kə sənen apan zle, viya winen apan i slay coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Matanan re, kə cinen anan anà way uno sə ɗakak ikwen anan ataya cəna, sənen a nà, bahay a Mbərom ɗukwen winen apan i slay ahay bəse coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Nen apan ni jak ikwen tə ɗiɗem a həna: Əlek ɗo sə biten ahay ti i mac nà, way ataya fok ti təra. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Daliyugo i ndav, kərngay i slukwac pə bagəbaga mburom, əna 'am uno nà, i ndav itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ben a nga a kwanay, anga aday ajalay nga a kwanay ahay â sa wuse pa 'am sə azar uko ahay bay, kabay pa 'am sa sa mahay bay, aday pa 'am sə vaway nga bay, aday anga ɗəce sə daliyugo ahay bay re. Anga kak nga a kwanay kə̀ wusek tə way ataya nà, luvon ata i slay ahay pikwen gangaf mənjəna kwanay sa san pi zek. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Andav a daliyugo i nay ahay nà, kawa ɓalay sa mbazl way dənam ata awan. Matanan, ɗo ahay kəzlek pə daliyugo fok ti san pi zek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anga nan, njihen mə lavay zek aya hwiya, gen amboh, anga aday kə̂ njiɗen məgala sa tam pə way a saa təra ataya wa. Ata nen, Wan su Ɗo, na sak a may ahay nà, ki tiven uno pa 'am lele.» ");
INSERT INTO mqbNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Natiya awan, Yesu nà, a taa ɗakan anan way anà ɗo ahay ù doh sə mazlaɓ a Mbərom sə ipec. Aday sə luvon nà, a taa nahay way anahan ahay à ɓəzlom sə Ulivet. ");
INSERT INTO mqbNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aday, iɗe kə̀ cəɗek sidew a cəna, ɗo ahay ta zla à man anahan ù doh sə mazlaɓ a Mbərom saa sləne atətak way anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Alay sə azar uko sə Pasəka aday sa da tapa sə pen mə zlambar a bay ata, winen apan i dəzley ahay bəse coy. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bahay sə gəɗan dungo anà way ahay anga Mbərom pi zek tə Miter sə Tawrita ahay, tə pəlay cəveɗ sa vaɗ anan Yesu, anga zlawan sə ɗo ahay a gan atan. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Natiya kutok, Fakalaw a zlan à mivel inde anà Yudas, sə ngaman Iskariyot, winen ɗo kərtek à wulen su ɗo maslan a Yesu kuro nga cew ataya wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aday Yudas ata a zla, tə jəjem 'am tə bahay sə gəɗan dungo anà way ahay anga Mbərom ataya, pi zek tə bahay sa ba pu doh sə mazlaɓ a Mbərom ahay. Tə pəlay cəveɗ anga aday Yudas â gan atan ɗaf pə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɗo ataya tə taslay mivel bayak a tə Yudas, tə zlapay sə haman dala. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","A zlan à nga kutok, aday a pəlan atan cəveɗ sə varan atan anan Yesu, a nan aday ɗowan â san apan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Natiya awan, azar uko sa pa tapa sə pen mə zlambar a bay ata a sla, aday ti waslay wan sə təman sə Pasəka ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu a slan Piyer tə Yuhana, a jan atan nà: «Zlen, ka saa liven uko a zek tə way sa pa sə azar uko, aday ɗi saa pa.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tə cəce panan: «A nak mâ sa lavay anan zek tə way sa pa ata nà, ahaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A mbəɗahan atan apan, a wa: «Ihe, kə dəzlen à wulen su doh sə Urəsalima nà, ki zlingen tə ɗowan a inde kəlawa pa nga, aday winen apan i may ahay à a'am wa. Pərihen anan azar dezl ù doh anahan a saa zla uda ata awan, ");
INSERT INTO mqbNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aday ki jen anà bahay su doh ata nà: “Miter a manay a ja nà: Doh a aday mi i pa uda ɗaf sə azar uko sə Pasəka tə njavar uno ahay ata nà, wuraw?” ");
INSERT INTO mqbNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ata i ɗakak ikwen pə sewene a inde məduwen awan, mə lavay zek a coy. Kə̂ ndiken anan uda way ahay fok à man ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ta zla kutok, ta tan ayak à nga anà way ahay fok nà, kawa ana Yesu sa jan atan ayak ata awan. Tə lavay anan uda zek tə way sa pa sə azar uko sə Pasəka kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Alay a a sla kutok nà, atə Yesu tu ɗo maslan anahan ahay tə njahay pə kərtek awan, sa pa way sə azar uko. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A jan atan, a wa: «Na gak anan may tə mindel sa pa way sə azar uko a anan tə kwanay, zukwa ɗəce uno i sa nay nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Anga, nen apan ni jak ikwen, ni naa pa way sə azar uko sabay, si azar uko a anan i ga zek à bahay a Mbərom aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A gəɓa gəsa'am, a ngəran ayak anà Mbərom, aday a jan atan, a wa: «Təmihen anan, aday sen wa jəɓjeɓ kwanay a fok, ");
INSERT INTO mqbNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","anga ni jak ikwen, i ban pə luvon sə biten a anan wa nà, ni naa sa way kawa həna a anan sabay, si azanan à alay à bahay a Mbərom kà nak aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aday a gəɓa tapa sə pen, a ngəran ayak anà Mbərom, a gəzla anan ì zek wa, a varan atan, a wa: «Həna anan nà, zek uno awan, ma var a à yime a kwanay inde ata awan. Kâ ti gen matanan à wulen a kwanay anga sə jalay pi nen.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Matana asa re, pə dəɓa a way a tinen sa pa ata wa, a gəɓa gəsa'am, a varan atan anan, a wa: «Tə gəsa'am a anan nà, Mbərom a ɓan 'am wiya tə ɗo ahay. A ɓan 'am a nə tə mez uno ma pak a anga kwanay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aya əna, ihe! Ɗo sa ga upo ɗaf ata, winen apan i pa way pə kərtek a ti nen à man a anan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tə ɗiɗem a nà, nen Wan su Ɗo nà, ni mac, kawa ana Deftere a Mbərom sa ja upo ata awan. Əna ɗəce i naa tan à nga anà ɗo saa ga upo ɗaf ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Njavar anahan ataya tə dazlan sə cəce pi zek ahay wa, ta wa: «Aday waya à wulen a nuko sa ga way ata anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pə dəɓa anahan a wa nà, avaɗ awiyaway a slabak à wulen su ɗo maslan ahay inde pa 'am sa jəka, à wulen a tinen inde, sə zalay ɗo tə məduwen nə wayaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu a jan atan: «Bahay sə daliyugo ahay tinen apan ti ga bahay pə ɗo ahay nə tə məgala. Əna hwiya ta gan may ɗo ahay tə varan atan zlangar, aday tâ ja nà, tinen ɗo sa man zek à ɗo ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Aya əna, a kwanay nà, matana itəbay. Ɗo məduwen a à wulen a kwanay inde nə â təra kawa ɗo cəɗew awan. Ɗo sa lavan nga anà ɗo ahay ɗukwen â təra aɗəka nà, kawa ɗo si mer su way. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","«Ɗo məduwen a nà, wayaw? Ɗo mə njahay a à man sa pa way ata ɗaw, kabay ɗo sa gan mer su way ata ɗaw? Ɗo məduwen a nà, winen mə njahay a à man sa pa way ata ba? Əna, nen à wulen a kwanay inde nà, kawa ɗo si mer su way. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Aday kwanay nà, ɗo mə njahay aya ti nen pac pac à ɗəce uno ahay inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kawa ana Bəbay uno sə vuro ahay bahay ata nà, nen ɗukwen ni təra kwanay bahay aya re, ");
INSERT INTO mqbNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","anga aday ki sen way, ki pen way pə kərtek a ti nen à bahay uno inde. Ki i njihen à man sə njahay sə bahay inde, sa gan sariya à zaav sə Isəra'ila ahay kuro nga cew ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu a jan anà Piyer, a wa: «Simon, Simon! Fakalaw kə̀ njaɗak pikwen cəveɗ sə tambal kwanay, kawa ndaw aday sə gəzla anan pi zek wa tə janjar ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Əna na gak amboh anà Mbərom anga iken, Simon, aday kə̂ mbəsak sa ɗaf nga pi nen bay. Aday iken kə jalak pə ines anak, kà mak pə cəveɗ nà, kə̂ varan məgala anà mərak anak ahay ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer a jan, a wa: «Ba Məduwen, nen mə lavay zek a sa zla tə iken kwa à dangay, kwa hus pə amac uno ɗukwen nen inde re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu a mbəɗahan apan, a wa: «Piyer, ni jak tə ɗiɗek awan, à luvon a sə biten a anan inde, zukwa njəkar i saa zlah nà, ka jak saray maakan ka san nen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu a jan anà njavar anahan ahay asa, a wa: «Anuno sa slan kwanay mənjəna dala, mənjəna mbulo, aday mənjəna təkarak nà, awan a inde ki gen ɗəce a ɗaw?» Tə mbəɗahan apan, ta wa: «A'ay. Ma gak ɗəce sə awan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","A jan atan asa, a wa: «Əna, həna aɗəka kutok nà, ɗo tə dala awan, tə mbulo a nà, â gəɓa. Ɗo a aday maslalam inde apan ibay nà, â gəɓa kəlmije anahan, â sukom a way, aday â sukom a maslalam kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Anga nen apan ni jak ikwen, tə vindek anga nen à Deftere inde, ta wa: “Winen mə baslay a à wulen su ɗo sə atahasl ahay inde.” Way a aday mə vinde pi nen ata nà, təktek i təra.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Njavar anahan ahay ta jan nà: «Ba Məduwen, ihe, maslalam ahay inde həna cew.» A jan atan: «Coy, i sla ɗa!» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu a nay ù doh wa, a zla kawa anahan sə kwakwa ata awan, à ɓəzlom sə Ulivet. Njavar anahan ahay tə pərahan azar. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A dəzle à man ata nà, a jan atan, a wa: «Gen amboh anà Mbərom anga aday kə̂ tiven anan anà way saa njak kwanay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A zla pə cakay a tinen wa zaɗ, a dukwe gərmec, a ga amboh, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Bəbay uno, kà zlak anak à nga nà, gəɓa puno ɗəce saa nay upo a anan ata ite. Aya əna, way kawa su no nà, â təra bay, si kawa sa nak iken.»  ");
INSERT INTO mqbNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Natiya maslay a Mbərom a nay à mburom wa, a kan zek à Yesu sa man a mivel ù doh. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Winen apan i jalay mərava a tə mindel, a ga amboh tə məgalak awan. Winen apan i ga amboh ata nà, herreɓ anahan a təra kawa məcərkazlay si mez, aday a laray pə yugo. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A slabak pə amboh wa bine siwaw nà, a ma à man ana njavar anahan a maakan ataya awan. A tan atan ahay à nga nə ma njak ahan aya awan, anga mbac kə̀ slahak atan tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A jan atan nà: «Kə njəken ahan nà, angamaw? Slabiken, gen amboh anga aday kə̂ tiven anan anà way saa njak kwanay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu kə̀ ndəvak anan 'am ata fan bay, ɗo ahay bayak a ta nay ahay. Yudas, ɗo kərtek à wulen sə njavar anahan aya inde kuro nga cew ata, winen a njahan atan ahay pa 'am wa. A həɗəkey pə cakay a Yesu aday sa ban anan həmbok. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Əna Yesu a jan, a wa: «Iya, Yudas! Cəkəbay, a nak sə njəko uda awan, ì nen Wan su Ɗo nà, ta sa ban nen həmbok matana ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ɗo aya tinen jiga pə kərtek a tatə Yesu ataya tə canan à way a saa təra ata nà, ta jan nà: «Ba Məduwen, mə̂ wacay atan tə maslalam ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cəna, ɗo kərtek à wulen a tinen wa, a car anan ɓile ana bahay nga su ɗo sə gəɗan dungo anà way anga Mbərom, aday maslalam anahan ata a gaɗ panan sləmay sə alay puway poc. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Əna Yesu a jan atan nà: «Mbiken! Kà slak ɗa.» A laman anà sləmay a ɗowan ata, a mbar anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aday Yesu a jan anà bahay sə gəɗan dungo anà way ahay pi zek tə bahay sa ba pu doh sə mazlaɓ a Mbərom ataya, aday tə məceɗ sə Yahuda aya sa nay apan sa ban anan ata nà: «Ki nen upo tə maslalam aya aday tə sukol aya kawa nen nà, ɗo sə ngəzar ɗo à cəveɗ inde ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","À alay a nen inde tə kwanay ù doh sə mazlaɓ a Mbərom pac pac dəp nà, kə bənen nen ɗaw? Əna həna nə alay a kwanay kà slak, alay ana bahay sə setene ahay sa ga bahay à luvon inde ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Natiya, ɗo ahay ta ban anan Yesu kutok, ta zla anan àga bahay nga su ɗo sə gəɗan dungo anà way ahay. Piyer winen apan i pərahan ayak azar à dəɓa wa à dəɓa wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɗo ahay ta han uko à gala, aday tə njahay apan tuw nà, Piyer ɗukwen a njahay à wulen a tinen inde cite re. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dəna sa ga mer su way ù doh ata a canan à Piyer winen mə njahay pə uko ata nà, a zəzor anan, a wa: «Həna ana ata nà, ɗo a Yesu a re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Əna Piyer a məman anan, a wa: «Dalay a anan, nen, na san a ɗowan a anan bay jiga awan!» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pə dəɓa wa mənjœk, ɗo hinen a canan asa, a wa: «Iken ɗukwen ɗo a Yesu a re.» Piyer a mbəɗahan apan, a wa: «A'ay, wan ada. Nen ɗo anahan bay wuna!» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A njahay pə dəɓa wa capəpa nà, ɗo hinen inde a mənahan anà 'am ata hayəɓ hayəɓ, a wa: «Tə ɗiɗem awan, həna anan ata nà, ɗo a Yesu awan, bina winen Galile ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyer a mbəɗahan apan, a wa: «Wan ada, a nak sa ja nə maw? Na san 'am anak ata bay wuna.» Mənjəna sa ndav anan 'am anahan ata cəna, njəkar a zlah kwayan'a. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Coy, Bahay Yesu a mbəɗahay 'am, a cay ahay pə Piyer, aday cəna 'am a Yesu a sa jan kurre ata à man à nga inde, a wa: «À luvon a sə biten a anan inde, aday njəkar i saa zlah nà, ka jak saray maakan ka san nen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Coy Piyer a nay uho, a yam cəɗœk cəɗœk tə iɗe sə ayam. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ɗo sa ba pə Yesu ataya tinen gədek sə gənahan. Tə kərtan zana pə iɗe, aday tə dəcan, tə cəce panan kutok: «Jan umo kutok: Sə dəcak nə wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ta jan 'am sə suwat ahay à nga wa cara cara. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iɗe a cəɗe sidew a cəna, məceɗ sə Yahuda ahay pi zek tə bahay sə gəɗan dungo anà way ahay, aday tə miter sə Tawrita ahay, tə halay nga fok. Ta zla anan Yesu à man sa ga sariya a tinen, ");
INSERT INTO mqbNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","tə cəce panan, ta wa: «Kak iken nə Almasihu, ɗo ana Mbərom sə slənay saa tam anan ɗo sə daliyugo ahay ata nà, ɗakan umo anan biɗaw?» A mbəɗahan atan apan, a wa: «Həna nə ɗakak ikwen anan dəp ɗukwen, ki ɗəfen apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aday nə̂ cəce pikwen wa ɗukwen, ki mbəɗihen uno apan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aya əna, azanan pa 'am nà, nen, Wan su Ɗo, ni i njahay tə alay puway ana Mbərom Ba məgala.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tinen a fok ta jan, ta wa: «Həna nà, iken nə Wan a Mbərom cukutok ɗaw?» A mbəɗahan atan apan: «Ayaw! Kawa ana kwanay a sa ja ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ta ja kutok, ta wa: «Həna nà, ɗi gan may anà side hinen re ɗaw? Mənuko ɗə slənek tə sləmay a nuko à 'am anahan wa coy asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pə dəɓa anahan a wa kutok nà, ɗo sa gan sariya anà Yesu ataya fok, tə slabak ta zla anan àga Pilatu, ɗo sə Ruma, winen bahay a pə daliyugo sə Yahudiya. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta ndaɓ 'am ahay cara cara pə Yesu, ta wa: «Winen apan i təran awan anà ɗo a manay ahay. A wa ɗowan â varan jangal anà bahay sə Ruma bay fok. Aday ɗukwen a wa winen nà, Almasihu, bahay awan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu a cəce 'am pə Yesu wa, a wa: «Iken nà, bahay sə Yahuda ahay ɗaw?» Yesu a mbəɗahan apan, a wa: «Ka jak anan asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatu a jan anà bahay sə gəɗan dungo anà way ahay tu ɗo a mə halay nga bayak ata awan, a wa: «Na tak anan à nga anà mungok sa ban anan apan ɗowan a anan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Əna, ɗo ataya tə mənahan asa, ta wa: «Winen apan i təran awan anà ɗo ahay ta 'am anahan ataya pə daliyugo sə Yahudiya fok. A dazlan ahay kwa pə daliyugo sə Galile wa, dezl həna kə̀ njaɗak anan ahay à man a anan re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu a sləne 'am ata cəna, a wa: «Ɗowan a anan nà, winen Galile ahay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A sləne sə jəka Yesu a nay nà, pə daliyugo ana Hiridus wa ata nà, a wa tâ zla anan àga Hiridus, anga à alay ata ɗukwen, Hiridus a winen inde agay anahan awan, à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hiridus a canan à Yesu cəna, a zlan à nga. Kə̀ njahak bayak awan, a gan may sə canan à Yesu, anga ɓa ɗo ahay tə təkərek anan ləbara anahan awan. Winen a bayak nà, i canan à Yesu winen apan i ga masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hiridus a cəce 'am ahay pə Yesu wa bayak awan, əna Yesu kə̀ mbəɗahak anan apan bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bahay sə gəɗan dungo anà way ahay, tə miter sə Tawrita ahay tinen inde à man ata re. Tinen, tə zəga anan sa ndaɓ apan 'am asa. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Coy Hiridus tə suje anahan ahay ta ca apan nà, gəsən'a, ta ma nga sə mbasay apan. Ta pak apan zana lele awan, aday ta ma anan àga Pilatu asa. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pə luvon ata ite, atə Hiridus tə Pilatu ta ban car kutok, bina abay həren, tinen nà, tə ngəlinge ì zek bay way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatu a halan nga anà bahay sə gəɗan dungo anà way ahay, pi zek tu ɗo sə lavan nga anà ɗo ahay, aday tu ɗo azar aya bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","A jan atan: «Kə bənen uno ahay ɗowan a anan. Ki jen nà, winen apan i təran awan anà ɗo ahay. Ihe, nə cəcihek panan həna nà, pa 'am a kwanay a fok. Ki jen nà, winen tə mungok awan. Əne, nen nə njaɗak apan way kawa ana kwanay sa ja, abay təɗe sa man anan mungok ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hiridus ɗukwen kà mak anan ahay à man ana awan, anga kà tak anan à nga à mungok sə awan aday abay təɗe sa vaɗ anan apan ata bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anga nan, ni ndaɓay anan cəna coy, aday ni mbəsak anan.»  ");
INSERT INTO mqbNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A jan atan matanan ata nà, anga azar uko sə Pasəka kà slak ahay cəna, a taa mbəsakan atan anan ahay ɗo sə dangay kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Əna tinen a fok ta zlah tə məgalak awan, ta wa: «Ma gan may ki mbəsakay ahay nà, Barabas, aday ɗowan a anan nà, kâ vaɗ anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas sə ɗowan ata nà, winen à wulen su ɗo sə vəze pə Ruma ahay à Urəsalima ataya awan. Aday winen nə kə̀ vəɗak nga su ɗo re. Ta ban anan à dangay nà, anga nan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu a man atan anan 'am ata asa, anga winen nà, a nan sə mbəsak anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Əna ɗo ataya ta zlah tə məgalak a asa, ta wa: «Darak anan ayak pə dədom! Darak anan ayak pə dədom!» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatu a jan atan tə slala maakan a asa, a wa: «A ga mer sa ma lelibay a anaw? Nen nə njaɗak apan ines sa man anan mungok aday abay təɗe sa vaɗ anan apan à məke itəbay. Suwan ni ndaɓay anan cəna coy, aday ni mbəsak anan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Əna ɗo ataya tə zəga anan sa zlah tə məgalak awan. Ta gan may si tə̂ darak anan ayak pə dədom. Tə njaɗak apan cəveɗ anga abəbal awan a tinen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatu a təma sa ga kawa ana a tinen sa gan may ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A mbəsakay anan ahay Barabas, kawa ana tinen sə cəce panan ata awan, ɗowan aday ɓa tə bənak anan à dangay anga a vəze pə Ruma ahay, aday ɗukwen kə̀ vəɗak uda nga su ɗo re, ata awan. Yesu nà, Pilatu a varan atan anan ahay, aday tâ ga anan alay kawa ana tinen sa gan may ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Natiya kutok, suje ahay tinen apan ti zla anan Yesu nà, tə zlangay tə ɗowan a inde tə ngaman Simon, winen ɗo sə Siren ahay, winen apan i may ahay à kiɓe wa. Ta ban anan, tə tavakan dədom mə zləlngaɗ a mbala Yesu ata, aday â pərahan anan ayak azar à dəɓa wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɗo ahay bayak a, tinen apan ti pərahan ayak azar à dəɓa wa anà Yesu. À wulen a tinen nà, uwar aya inde, tinen apan ti yam gweguzguzze anga winen. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu a mbəɗahay patan 'am, a jan atan ahay, a wa: «Dəna sə Urəsalima ahay, kə̂ yimen anga nen bay. Yimen aɗəka nə zek a kwanay, aday wan a kwanay ahay re! ");
INSERT INTO mqbNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Anga alay sə ɗəce winen apan i nay ahay. Ata, sa naa taslay mivel nà, uwar aday winen dərlay awan, tə uwar aday kə̀ wahak fan bay ata awan, tatə uwar aday kula ɗowan kà sak pay anahan bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aday, ɗo ahay ti dazlan sa ja nà: “Ɓəzlom ahay, mbəzlen ahay pumo! Culok ahay ɗukwen ənga ndisen ahay pumo ite!” ");
INSERT INTO mqbNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nen nà, kawa dədom məngəɗaz awan. Aday ta sak u go way a anaya anà nen, dədom məngəɗaz ata nà, ti naa gan anà ɗo aday tinen kawa dədom mə kuray ataya ite nə, kəkəma asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","À man ata ite nà, ɗo sə akar aya inde cew. Suje ahay ta ra atan anga ines a tinen, saa vaɗ atan tatə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tə dəzle à man sə ngaman Kəlakasl-sa-Nga ata nà, tə daray anan Yesu tu ɗo sə akar a cew ataya pə dədom à man ata awan, ɗo kərtek a tə alay puway, ɗo hinen tə alay gula, Yesu à mamasl a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu a gan amboh anà Mbərom, a wa: «Bəbay uno, pəsen atan anan ines a tinen, anga ta san way a tinen a sa ga həna ata bay.» Suje ahay tə gəzla anan zana a Yesu ahay à wulen a tinen ahay inde, ta sa ga apan caca. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aday ɗo a mə tavay aya à man ata awan, tinen apan ti ca iɗe həməcəcce. Bahay sə Yahuda aya inde ite, tinen apan ti təra anan Yesu à məndak, ta wa: «Kə̀ təmak anan ɗo azar aya asanaw! Kak winen Almasihu, ɗo a Mbərom mə walay saa tam anan ɗo a acəkan nà, â mbar a zek anahan a ite biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Suje ahay ɗukwen tə həɗəken ayak pə cakay, sa jan ayak 'am sə suwat. Tə varan ayak way mə kwasay a inde, aday sərekeke re aday â sa. Ta jan: ");
INSERT INTO mqbNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Kak iken bahay sə Yahuda ahay nà, tam anan nga anak a kutok biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tə vinde way pə pəlungwaɗ, ta wa: «Həna anan nà, bahay sə Yahuda ahay.» Aday tə tapak anan ayak pa nga sə dədom a mə zləlngaɗ ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Natiya, ɗo kərtek à wulen su ɗo sə akar a mə daray aya pə dədom ata awan, a gənahan à Yesu ite, a wa: «Na wa iken nà, Almasihu ba? Ənga, tam a zek anak, aday kâ tam manay ite biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Əna ɗo anahan a hinen ata a gafan ayak apan 'am, a wa: «Iken nà, kə jəjaran anà Mbərom itəbay ɗaw? Anga iken ɗukwen ɗo ma ban a kawa winen a re asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mənumo ɗa sa ɗəce a anan nà, təɗe anga ines anumo sa ga ata awan. Əna winen nà, kà gak awan itəbay asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Natiya, ɗowan ata a jan à Yesu, a wa: «Ka sak a nay ahay tə mazlaɓ sə bahay anak a nà, aday kem, kə̂ bayak upo ite.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu a mbəɗahan apan kutok, a wa: «Nen apan ni jak tə ɗiɗem a həna: Pə luvon a sə biten a anan, ɗi zlumo à jerne a Mbərom inde.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Natiya awan, à man ipec inde nà, luvon a ga pə daliyugo fok takəɗimbom, hus à njamde maakan. Aday zana sə gəzla man sə njahay a Mbərom pi zek wa tu ɗo ahay ù doh sə mazlaɓ a Mbərom ata, a ngəraw à mamasl a wa əndem. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu a zlah tə məgalak awan, a wa: «Bəbay uno, ni mbəsakak anan ayak sifa uno à alay anak inde.» Pə dəɓa anà 'am anahan ata wa nà, a mac way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bahay sə suje sa man ataya ata, a canan à way a sə təra ata nà, a həran nga anà Mbərom, a wa: «Ɗowan a anan nà, winen ɗo ɗiɗek a acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ɗo sa nay sa cak ayak apan ataya fok tə canan à way a sə təra ì iɗe a tinen inde ata nà, kuwaya fok a haw way anahan gərləhlah ta nga mugo. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Əna ɗo sa san anan ataya pi zek tə uwar sə pərahan ahay azar kwa à Galile wa ataya, tə tavay zaɗ, ta ca pə way a sə təra ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Natiya kutok, ɗowan a inde tə ngaman Yusufu, winen ɗo sə Arimatiya ahay pə daliyugo sə Yahudiya. Winen apan i ba bahay a Mbərom. Winen ɗo ɗiɗek a pa 'am a Mbərom. Abay winen nà, ɗo kərtek à wulen su ɗo sa gan sariya anà Yesu ataya awan, əna winen nə kə̀ təmahak 'am a tinen ata itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A zla à man a Pilatu saa cəce panan cəveɗ sə gəɓa məsinde a Yesu aday i sa la anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A njaɗ cəveɗ ata kutok nà, a zla, a dazay anan ahay məsinde a Yesu pə dədom mə zləlngaɗ ata wa. A nga apan rəkot a inde, a ɗəfak anan ayak à jəvay ma la a à jama inde, à man a aday kula tə ɗəfak ayak uda məsinde bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Way ata a təra nà, ta pac sə dezele, aday defefe luvon sa man uda winen apan i slay uda bəse. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Uwar sə pərahan ahay azar anà Yesu kwa ahay à Galile wa ataya tə pərahan azar anà Yusufu dezl pa 'am jəvay, aday ta ca pa sə ɗəfak anan ayak Yesu à məke inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aday ta ma way a tinen agay, tə lavay a zek tə amar sə wurde sə rəbas lele dun'a ata awan. Aday ta man uda awan pə luvon sa man uda awan, kawa ana Tawrita a Musa sə ɗakan atan anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta pac sə zaka kutok, pərek duwdew, uwar ataya tə wule pa 'am jəvay. Ta zla anan tə amar a tinen sə lavak anan ayak zek ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tə dəzle nà, ta tan ayak à nga anà bələlen mə bətukwal a pa 'am jəvay wa, mə jəkay awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ta zla à jəvay ata inde məreh kutok, əna ta tak anan à nga anà zek sə məsinde a Yesu Ba Məduwen bay re. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A gan atan nà, wurdədəsdəssa. Kwayan'a, ɗowan aya inde cew ta kan atan zek. Aday tinen tə zana aya pi zek, a dav nà, herre kweɗekkweɗek. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Uwar ataya tə canan à ɗowan a cew ataya cəna, ta ma nga sə jəjar, tə rihe nga a tinen ahay ù vo. Cəna, ɗo ataya ta jan atan: «Waka ɗo nə tə sifa coy asənə, kə pəlen anan à wulen sə məsinde ahay wa nà, angama mba asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Winen inde à man a anan sabay. Kə̀ slabakak ahay à məke wa. Bayiken pa 'am anahan a sa jak ikwen à alay a kwanay à Galile ata awan. A wa: ");
INSERT INTO mqbNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Təktek, nen, Wan su Ɗo nà, ni slahay à alay su ɗo sə atahasl ahay inde, ti darak ayak nen pə dədom mə zləlngaɗ awan. Aday pə luvon maakan a anahan a nà, ni slabakay ahay à wulen sə məsinde ahay wa.”» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Natiya, 'am a Yesu a sa jan atan ata a man atan ahay à nga inde kutok. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Coy, ta may way a tinen pa 'am jəvay wa, tə ɗakan anan ləbara ata anà njavar a Yesu a kuro nga kərtek ataya awan, aday anà azar su ɗo ahay a fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sa man anan ləbara ata anà ɗo maslan ataya nà, Mariyama sə Magədala, tə Yuwana, aday tə Mariyama, may a Yakuba, aday uwar a azar a sə pərahan atan ayak azar ataya re. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ɗo ataya tə sləne ləbara sa 'am ata cəna, tə ɗəfak apan nga bay. A ga patan nà, kawa uwar ataya ta jan atan nà, 'am sə uwar ahay kəriya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Əna Piyer nà, a slabak, a haw pa 'am jəvay. A dəzle cəna, a zərɗek ayak iɗe à jəvay inde. Awan uda ibay. Mə mbəsak a nà, zana vərre gərəvve kəriya awan. A zla agay, əna way ata a gan nə wurdədəsdəssa hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta pac ata kərtek awan, ɗo ahay cew à wulen sə njavar anahan ataya wa, tinen apan ti zla à wulen su doh a inde sə ngaman Emawus ata awan, dəren pi zek wa tə Urəsalima nà, i ga way sə kilomiter kuro nga kərtek. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tinen apan ti zla nà, ti kaɗ bala pə ləbara su way a sə təra ata kurkwer. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tinen apan ti kaɗ bala a tinen ata mba cəna, degeslef Yesu a njaɗak atan ayak pə cəveɗ. Ta zla pə kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tə canak anan à Yesu, əna awan a kə̀ nahak atan pə iɗe. Anga nan, tə sənak a bay. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu a cəce patan wa, a wa: «Kə kiɗen bala pa ma à cəveɗ wa anaw?» Tə tavay jərem ma ga mugo aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ɗowan a kərtek a sə ngaman Keliyupas ata a mbəɗahan apan, a wa: «Ɗo sə Urəsalima ahay fok ta san pə way a sə təra à luvon a anaya inde kutok nà, sa san apan ite bay nə, iken kərtek kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu a cəce patan wa, a wa: «Ma sə təra anaw?» Tə mbəɗahan apan: «Way sə təra pə Yesu, ɗo sə Nazaratu ata awan. Winen nə ɗo maja'am a Mbərom. Ɗo tə məgala si mer su way a, aday tə mazlaɓ sa 'am a, pa 'am a Mbərom aday pa 'am sə ɗo ahay fok re. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bahay sə gəɗan dungo anà way ahay pi zek tu ɗo sə lavan umo nga ahay, ta ban anan, tə varan anan anà Ruma ahay, ta gan sariya saa vaɗ anan, tə darak anan ayak pə dədom. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Abay manay mə jalay nà, winen nə ɗo saa tam anan Isəra'ila ahay. Aday way a sə təra apan ata ɗukwen həna kà gak way sə luvon maakan re. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Natiya ɗukwen, uwar sə àga manay ahay tə vawak umo nga wadan wadan, anga sə duwdew a anan tə wulek pa 'am jəvay, ");
INSERT INTO mqbNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","əna ta tak anan à nga anà məsinde anahan a à jəvay inde sabay re. Ta may agay, ta jan umo ləbara awan, ta wa: “Maslay a Mbərom ahay ta kan umo zek, ta jan umo nà, winen inde tə sifa awan!” ");
INSERT INTO mqbNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aday, ɗo sə àga manay ahay ta zlak saa cay iɗe pa 'am jəvay ata wa ɗukwen, ta tan ayak à nga anà way a kawa ana uwar ataya sa jan umo, əna ta tak anan à nga anà məsinde a bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Natiya, Yesu a jan atan kutok, a wa: «Hey, kwanay ɗo sa san awan bay ahay, ɗo mənok aya sa ɗaf nga pa 'am ana ɗo maja'am a Mbərom ahay! ");
INSERT INTO mqbNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Abay Almasihu i sa zla à mazlaɓ sə bahay anahan inde nà, təktek i ga ɗəce ndəlekeke aday biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aday a ɗakan atan anan 'am kawa ma jay a pə winen à Deftere a Mbərom inde, ata a dazlan ahay à deftere a Musa ahay wa, hus anan à deftere su ɗo maja'am a Mbərom ahay inde fok. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Natiya, tinen apan ti dəzle à wulen su doh a tinen saa zla uda ata bəse nà, Yesu a ga kawa i zla way anahan ta man hinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Əna ta ngam â zla patan wa bay. Ta jan nà: «Pac kə̀ slahak ù doh aday luvon winen apan i ga bəse kutok nə, suwan njahuko à man a anan.» Yesu a may ahay, a njahay tə tinen. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","À alay sa pa way nà, Yesu a gəɓa tapa sə pen, a ngəran anà Mbərom, a gəzla anan tapa sə pen ata ì zek wa, a varan atan anan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Natiya, iɗe a cəɗen atan lele, ta san anan kutok. Cəna sawayah a zla pa man sə iɗe a tinen wa. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ta jan ì zek ahay kutok, ta wa: «Kawa anahan sa jak umo ahay 'am pə cəveɗ wa, aday sə ɗakak umo anan 'am sə Deftere a Mbərom ata nà, a gak umo ahay nə mbaɗaɗa biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tə slabak kwayan'a, ta ma à Urəsalima. Ta tan ayak à nga anà njavar anahan ahay kuro nga kərtek ataya, tu ɗo azar aya mə halay nga awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɗo a mə halay nga ataya ta jan ù ɗo cew ataya kwayan'a, ta wa: «Yesu Ba Məduwen kə̀ slabakak ahay acəkan, bina Simon kə̀ canak anan!» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɗo a cew ataya ite tə təkəren anà ɗo ataya way sə təran atan ayak pə cəveɗ wa, aday taa san a Yesu nà, à alay a winen sə gəzla anan tapa sə pen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tinen apan ti ja 'am ata mba kutok, Yesu a tavay jek à wulen a tinen inde. A jan atan, a wa: «Zay â tərak ikwen.» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cəna, tanday mbac a slahay patan wa, zlawan a gan atan. Tə bayak, i ga nə tə canan anà mədahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A jan atan nà: «Kə jəjiren nà, angamaw? Kwanay a fok kə bayiken way à nga a kwanay inde cuwcew nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cen pə alay uno tə saray uno ahay. Həna anan nà, nen awan. Limen uno, cen upo. Mədahan nà, kəlakasl tə sluweɗ si zek inde apan ibay. Əna, kə cinen uno həna nà, matana bay asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A jan atan 'am ata nà, a kan atan anan alay anahan ahay pi zek tə saray anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ta mbak apan sa ɗaf nga pə way ata fan bay, anga ataslay mivel a tinen a kə̀ zalak, aday way ata a gan atan masuwayan re. Yesu a cəce patan wa kutok, a wa: «Way sa pa inde pikwen ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tə varan ahay kəlef ma vak aya mənjœk. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A gəɓa, a rac ì iɗe a tinen a inde. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A jan atan: «Həna anan nà, way nen sə ɗakak ikwen anan, à alay a nen inde tə kwanay mba ata awan. Abay way aya inde mə vinde a pi nen à Tawrita a Musa, tə deftere ana ɗo maja'am a Mbərom ahay, tə Jabura ahay. Təktek way ataya fok tə̂ təra.» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A təɓan atan anà abayak nga a tinen, aday tâ san 'am sə Deftere a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A jan atan: «Mə vinde à Deftere a Mbərom inde nà, natiya. Təktek Almasihu nà, i ga ɗəce, aday i slabakay à məke wa pə luvon maakan awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ti wazay à mazlaɓ sə sləmay anahan inde pə daliyugo fok, i dazlan nà, à Urəsalima wa, ti ja: “Mbəɗihen anan lœn anà ines a kwanay ahay, aday Mbərom i pəsek ikwen anan.” ");
INSERT INTO mqbNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Saa side anan way ataya nə kwanay awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Azanan nà, nen a, ni slənak ikwen ahay way a, kawa ana Bəbay uno sə zlapak ikwen anan ata awan. Əna, njihen à wulen su doh sə Urəsalima hus pə luvon a ni slənak ikwen ahay məgala sa nay à mburom wa ata aday.» ");
INSERT INTO mqbNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu a zla atan à wulen su doh wa. Ta zla bəse tə Baytiniya. A cakaf alay à mburom, a ɗaf patan ngama. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","À alay a winen apan i ɗaf patan ngama ata mba cəna, a ján à wulen a tinen wa. Mbərom a gəɓak anan ayak à man anahan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tinen ite tə həran nga anà Yesu, aday ta ma à Urəsalima tə ataslay mivel a bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta taa zla ù doh sə mazlaɓ a Mbərom nà, pac pac, sa taa həran nga anà Mbərom.");
INSERT INTO mqbNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mama'am awan, abay Mbərom kə̀ ndakak daliyugo fan bay ata nà, ɗowan a inde tə ngaman 'am. 'Am ata nà, tinen tə Mbərom nə maya awan, aday winen nə, Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tinen tə Mbərom a nà, pə dəlen a wa maya kurre wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta 'am ata nà, Mbərom a ndakay anan way ahay kəzlek. Way mə ndakay a mənjəna 'am ata nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sifa a nay ahay nà, à 'am ata wa. A təran anà ɗo sə daliyugo ahay nà, jiyjay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Abay luvon nà, inde wanahan, jiyjay ata a dav uda awan, aday luvon a mba apan sə mbacay anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Natiya, Mbərom a slənay ahay ɗowan a inde tə ngaman Yuhana. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yuhana a nay ahay kawa side, sə ɗakan anan jiyjay ata anà ɗo sə daliyugo ahay, aday tâ ɗaf apan nga. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yuhana ta nga anahan a nà, winen jiyjay ata bay. Əna, a nay saa ga side sə ɗakay anan nə jiyjay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jiyjay a guzgwez ata, winen apan i nay ahay pə daliyugo, sə dəvan anà ɗo ahay kəzlek. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","'Am ata nà, abay winen inde pə daliyugo. Mbərom a ndakay daliyugo a nà, tə winen awan. Əna ɗo sə daliyugo ahay təkeɗe tə sənak anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A nay ahay nà, pə daliyugo anahan a wanahan, əna ɗo anahan aya ɗukwen tə təmahak anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Cəkəbay, ɗo azar aya nà, tə təmahak anan, tə ɗəfak apan nga. Anà ɗo ataya nà, 'am ata kə̀ varak atan cəveɗ sə təra atan wan ana Mbərom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tə təra wan a Mbərom ahay nà, pə ruhom si zek bay, pa sə wahay sə bəbay ahay bay. Tə təra nə, anga Mbərom kə̀ tərak bəbay a tinen coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","'Am ata a təra ɗo ti zek awan, kə̀ njahak à wulen a manay. Mə canak anan anà mazlaɓ anahan awan. A njaɗ mazlaɓ ata nà, anga winen a nà, wan ana Bəbay Mbərom, winen wan mənduwel awan. Mbərom a kay anan ahay sumor anahan tə ɗiɗem anahan ahay fok nà, tə winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhana kà jak apan tə məgalak awan, a wa: «Winen nà, ɗo, nen sa jak ikwen, na wa: “Ɗo inde i nay ahay à dəɓa uno wa, əna winen nà, a zalay nen asa, anga à alay a nen mə wahay a fan bay ɗukwen nà, winen inde coy.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mənuko a jiya ɗə njaɗak sumor à alay anahan wa, sumor pa nga sə sumor. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mbərom a varak uko anan ahay Tawrita nà, tə alay ana Musa. Əna sumor a Mbərom tə ɗiɗem anahan nà, a kay atan ahay anà ɗo ahay tə alay ana Yesu Almasihu. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mbərom a aday nà, ɗowan kula kə̀ canak anan bay. Əna, wan anahan a mənduwel ata, winen mə njahay a tə Bəbay anahan maya awan, winen kà kak uko anan ahay Mbərom awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Side ana Yuhana a dazlan nà, natiya awan: Pa pac a inde nà, məceɗ sə Yahuda ahay tə slənay ahay ɗo sə gəɗan dungo anà way anga Mbərom ahay kwa à Urəsalima wa, tinen pə kərtek a tu ɗo sa man atan zek ù doh sə mazlaɓ a Mbərom ahay. Tə cəce pə Yuhana wa, ta wa: «Iken nà, iken wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yuhana ɗukwen kə̀ məmanak atan anan bay, a jan atan anan ngəlarak, a wa: «Nen nà, Almasihu bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tə cəce panan asa, ta wa: «Aday iken nə waya kutok anaw? Iken nə Eliya kələɗaw?» Yuhana a mbəɗahan atan apan, a wa: «A'ay. Nen nà, Eliya bay.» Ta jan, ta wa: «Yo, iken nə ɗo maja'am a Mbərom, manay sa ba ata ɗaw?» Yuhana a wa: «A'ay, matanan bay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɗo ataya ta jan kutok, ta wa: «Siya, aday iken nə wayaw? A nan umo sa man ayak 'am anà ɗo sə slənay manay ahay. Ka jan anà nga anak a nà, iken wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yuhana a mbəɗahan atan apan asa, a wa: «Nen nà, ɗo mbala ana ɗo maja'am a Mbərom Ezaya sa jəka: “Ɗowan a inde, winen apan i zlah à saf inde à kiɓe, a wa: Ten anan cəveɗ anga Bahay winen apan i nay. Ten anan cəveɗ ata mə tavay nga a fəhhe lele.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aday à wulen su ɗo mə slənay a pə cakay ana Yuhana ataya nà, Farisa ahay uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tə cəce panan, ta wa: «Kak iken Almasihu bay, iken Eliya bay, aday ɗo maja'am a Mbərom hinen ata bay re nà, ka gan baptisma anà ɗo ahay angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuhana a mbəɗahan atan apan, a wa: «Nen na gak ikwen baptisma nà, tə a'am. Əna, ɗo inde à wulen a kwanay, kə sənen a bay, ");
INSERT INTO mqbNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","i nay ahay à dəɓa uno wa. Nen na slak sə pəsakan anan liɓer sə təkarak anahan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Natiya, way a anaya fok a təra nà, à wulen su doh sə ngaman Baytiniya ata awan, pə day uho sə zlinder sə Urdon, à man ana Yuhana sa gan baptisma anà ɗo ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iɗe a cəɗe sidew a cəna, Yuhana a canan ayak anà Yesu winen apan i zlak ayak. A wa: «Tiya, wan sə təman ana Mbərom saa pəse anan atahasl sə daliyugo ata awan! ");
INSERT INTO mqbNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Winen nà, ɗowan a nen sa jak ikwen, na wa: “Ɗowan a inde, i nay ahay à dəɓa uno wa, a zalay nen, anga à alay a nen mə wahay a fan bay ɗukwen nà, winen nà, winen inde coy.” ");
INSERT INTO mqbNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Winen wayaw nà, abay na san bay. Əna, na nay saa gan baptisma anà ɗo sə Isəra'ila ahay nà, aday tâ san anan lele.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuhana a ga apan side asa, a wa: «Nə canan anà Apasay a Mbərom a dazay à bagəbaga mburom wa kawa badəbada, a njahay apan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Abay na san winen nə wayaw bay. Əna Mbərom, ɗo sə slənay ahay nen sa ga baptisma tə a'am ata, kà jak uno, a wa: “Ki canan anà Apasay i dazay ahay pu ɗo, i njahay apan. Ɗowan ata nà, i ga baptisma tə Apasay Cəncan awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yuhana a ja asa, a wa: «Nə canak anan acəkan. Winen nə Wan a Mbərom. Ni side 'am ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Natiya kutok, iɗe a cəɗe sidew a nà, Yuhana winen mə tavay a à man ata tə njavar anahan ahay cew. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","A canan à Yesu winen apan i bar ta man ata nà, a ja, a wa: «Cen apan! Wan sə təman a Mbərom, winen tiya.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Njavar a Yuhana cew ataya tə sləne 'am ata cəna, tə pərahan azar anà Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu a ma iɗe à dəɓa nà, a canan atan ayak, tinen apan ti pərahan azar nà, a cəce patan wa: «Kə pəlen maw?» Ta jan: «Rabi, man sə njahay anak ahaw?» Ta 'am a tinen «Rabi» a nan sa ja nà, «Miter». ");
INSERT INTO mqbNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu a jan atan, a wa: «Hayak ikwen ahay! Kâ ni cen apan!» Ta zla pə kərtek awan, tə canan à man sə njahay ana Yesu. A təra nà, tə njamde fuɗo. À alay ata, tə təfek pi zek jiga hus à suko. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Natiya, ɗo a cew a sə sləne side aday sə pərahan azar anà Yesu ataya nà, ɗowan a inde kərtek, tə ngaman Andəre, mərak ana Simon Piyer. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Natiya, Andəre a zla a pəlay anan mərak anahan Simon, a jan: «Manay mə njaɗak anan Almasihu!» Almasihu ta 'am hinen nə Kristo. A nan sa ja nə ɗo ma ga amar awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andəre a lagay anan Simon pə cakay ana Yesu. Yesu a canan nà, a zəzor anan, a jan, a wa: «Iken nà, Simon wan ana Yuhana biɗaw? Pa 'am azanan nà, sləmay anak i i təra nə Kefas.» Ta 'am a tinen, Kefas a nan sa ja nà, pəkəraɗ. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sidew a nà, a nan anà Yesu sa zla pə daliyugo sə Galile. Tə zlangay tə Filip, a jan: «Pəruho azar!» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip a aday nà, winen Baytisada ahay, tinen ù kon kərtek a tatə Piyer tə mərak anahan Andəre. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip a zla à man ana Nataniyel ite, a jan: «Ɗowan a aday atə Musa tu ɗo maja'am ana Mbərom ahay sə vinde apan à Deftere inde ata nà, mə njaɗak anan kutok. Winen nə Yesu wan ana Yusufu, ɗo sə Nazaratu ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel a jan apan, a wa: «Kak way lele a nà, i nay ahay à Nazaratu wa ɗaw?» Filip a jan: «Hayak ahay, ca apan!» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu a canan anà Nataniyel nà, winen apan i nay ahay pə cakay anahan, a ja, a wa: «Cen apan! Ɗo sə Isəra'ila ɗiɗem a, aday a njəkan uda anà ɗo itəbay ata həna!» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel a cəce pə Yesu wa, a wa: «Ka san nen ta maw?» Yesu a mbəɗahan apan, a wa: «Kurre, Filip ɗukwen kə̀ ngamak anak fan bay ata nà, nə canak nà, iken ù vo sə buway mba.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel a jan apan kutok: «Miter, iken nə Wan ana Mbərom. Bahay sə Isəra'ila nà, iken.» ");
INSERT INTO mqbNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu a mbəɗahan apan asa, a wa: «Ka ɗaf upo nga nà, anga nen sa jak, na wa: Nə canak anak ù vo sə buway ata, biɗaw? Ki i canan anà way ahay sə zalay həna anan tə məduwen aya mba. ");
INSERT INTO mqbNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni jak tə ɗiɗem a nà: Ki i cinen anan anà bagəbaga mburom mə təɓa awan, aday ki cinen anan anà maslay a Mbərom ahay ti ján, ti dazay ti nen, Wan su Ɗo.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yawa, luvon cew pə dəɓa anahan a wa nà, azar uko sə gəɓa dalay a təra à Kana, pə daliyugo sə Galile. May ana Yesu winen inde à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ɗukwen tə ngamak atan ayak anà atə Yesu tə njavar anahan ahay à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","À alay sa sa mahay sə azar uko kutok, mahay a ndav pə ɗo ahay wa. Anga nan, may a Yesu a jan, a wa: «Mahay inde pə ɗo ahay sabay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu a mbəɗahan apan, a jan, a wa: «Uwar a anan, kə̂ vuwo nga ti mer su way ata nə angamaw? Alay uno kà slak fan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","May anahan a jan anà ɗo si mer su way ahay, a wa: «Gen kawa anahan saa jak ikwen ata fok!» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Matanan, tugoy su kon ahay inde à man ata ma la aya mbərka sa taa pak uda a'am. Kərtek sə tugoy ataya nà, a gəɓa a'am i ga way sə liter səkat, kawa sa ja bine siwaw nà, kəlawa mbərka. Tə a'am sə tugoy ataya awan, Yahuda ahay ta taa banay anan saray, zek, tə cakaɗ a way, kawa sə pəra a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu a jan anà ɗo sa ga mer su way ahay: «Rihen anan tugoy a anaya tə a'am.» Tə ngahay a'am awan, ta rah anan tugoy ataya cesl cesl. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu a ja kutok: «Həna nà, ngihen ahay wa asa, zlen anan anan ayak anà bahay sə azar uko.» Ta ga kawa anahan sa jan atan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bahay sə azar uko ata, a tukom anan nà, kə̀ tərak mahay coy. Əna, winen nà, a san sa jəka mahay a, a nay ahay nə tə wura wa anaw bay. Sa san nà, ɗo sə ngahay ataya ɗəkɗek. A ngaman ayak anà ɗo sə gəɓa dalay ata awan, a jan: ");
INSERT INTO mqbNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Abay ɗo ahay ta taa lahan anan anà ɗo ahay nà, mahay mugom awan. Kagasl, mahay kə̀ vawak atan nga nà, ti var winen mugom a bay ata awan. Aka aday iken nà, kə ɗərek anan mugom awan hus həna nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Natiya awan, masuwayan ana Yesu sa ga mama'am awan, a təra nà, à wulen su doh sə Kana, pə daliyugo sə Galile. A kay anan ahay mazlaɓ anahan, aday njavar anahan ahay ta ɗaf apan nga. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pə dəɓa anahan a wa, ta zla way a tinen à wulen su doh sə Kafarnahum tatə may anahan tə mərak anahan ahay pi zek tə njavar anahan ahay, aday tə njahay à man ata luvon ahay mənjœk ca. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Natiya, alay sə azar uko sə Pasəka ana Yahuda ahay i sa dəzley bəse nà, Yesu a zla à Urəsalima kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A njaɗak ayak ù doh sə mazlaɓ a Mbərom à man ata nà, ɗo sa ga masa ahay. Ɗo hinen ahay tə sukom anan way ta sla ahay, tə təman ahay, tə kurkudok ahay, aday ɗo a azar aya nə, ɗo sə bəmbaɗ dala ahay. Tinen a fok mə njahay aya pə tabal a tinen ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Natiya kutok, Yesu a japay anan 'am sə liɓer ahay, aday a təra anan məkiɓek awan, a rəzlay atan ahay gənaw ahay uho: sla ahay, təman ahay. A dazlan, a guce anan dala a tinen ataya à məndak, a hərok anan tabal su ɗo sə bəmbaɗ dala ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A jan anà ɗo sə kurkudok ahay re, a wa: «Zlen anan awan anaya à man a anan wa. Kə̂ təren anan doh ana Bəbay uno doh sa ga uda masa bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Njavar anahan ahay ta ma nga sə jalay pa 'am ma ja a à Deftere inde ata awan. 'Am ata a wa: «Asan zek su doh anak nà, winen apan i ban à mivel uno inde bayak a kawa uko.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bahay sə Yahuda ahay tə cəce pə Yesu wa kutok, ta wa: «Gədan anak inde sa ga way ataya ɗaw? Əna ga masuwayan, aday mâ san gədan inde apak matana acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu a mbəɗahan atan apan, a wa: «Mbəzlen anan doh sə mazlaɓ a Mbərom a anan. Aday nen ni han anan maza à luvon maakan inde.» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ta jan, ta wa: «Ɗo ahay ta han doh a anan nà, ava ahay ta gak kwa kuro fuɗo nga mbərka. Aday iken nà, ki han anan à luvon maakan inde kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu a ga minje tu doh ata nà, pi zek anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pə dəɓa ana Yesu sə slabakay ahay à məke wa nà, njavar anahan ahay tə jalay pa 'am anahan ataya jiga awan. Ta ɗaf nga pa 'am ma ja à Deftere a Mbərom inde ataya awan, aday ta ɗaf nga pa 'am anahan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Natiya awan, à alay sə azar uko sə Pasəka ata fok nà, Yesu a njahay à Urəsalima à man ata awan. Ɗo ahay bayak a tə ɗəfak apan nga, anga tə canak anan anà masuwayan anahan ahay sa ga. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aya əna, Yesu kə̀ ngəmak sa ɗaf patan nga bay, anga winen a san ajalay nga su ɗo ahay zle kəzlek. ");
INSERT INTO mqbNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesu kə̀ pəlak sa jəka ɗowan â ɗakan anan ajalay nga su ɗo kwa mənjœk bay, anga a san way sə mivel sə ɗo ahay zle fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɗowan inde à wulen sə Farisa ahay inde, tə ngaman Nikodemus. Ɗowan ata nà, winen ɗo kərtek à wulen sə məceɗ sə Yahuda ahay inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nikodemus kutok, a nay ahay pə cakay ana Yesu sə luvon. A jan a wa: «Rabi, na san zle, iken nà, miter ana Mbərom sə slənay ahay, anga kula ɗowan kà gak masuwayan sə way kawa ananak ite nà, ibay. Kak si Mbərom winen tə ɗowan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu a mbəɗahan apan, a wa: «Nen apan ni jak tə ɗiɗem a həna: Ɗo zənzen a nà, i mba apan sa zla à bahay a Mbərom inde bay, kak si i təra ɗo mə wahay a mə slala cew a aday.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus a cəce panan kutok a wa: «Ɗo kà gak məduwer coy nà, i njaɗ ti wahay anan maza awan nà, kəkəmaw? Ɗowan ata i njaɗ sa ma à kutov ana may anahan maza awan, aday may anahan i wahay anan asa kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu a jan: «Nen apan ni jak tə ɗiɗem a həna: Kak ɗowan a mə wahay a miza tə a'am bay, aday tə Apasay Cəncan awan bay cəna, ɗowan ata i mba apan sa zla à bahay ana Mbərom inde bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ɗo sə daliyugo ahay tinen apan ti wahay, əna tə wahay nə zek ɗəkɗek. Aday ɗo mə wahay a tə Apasay Cəncan ataya nà, tinen ɗo ana Apasay Cəncan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Am a anan â gak masuwayan aɗəka bay. Kawa anuno sa jak, bəlaray tə wahay kwanay tə slala cew a aday. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Maɗ a ɓal nà, à man anahan kawa sa gan may. Kə sləne zle, əna ka san sa jəka a nay awanaw bay. A zla nə ahaw ɗukwen, ka san man anahan a bay re. Ɗo mə wahay a tə Apasay Cəncan awan a ɗukwen a təra nà, matanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus a cəce maza awan pə Yesu, a wa: «I sa njaɗ zek ata nà, kəkəma kəlanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu a mbəɗahan apan: «Iken aɗəka nà, miter sə Yahuda ahay, əna ka san way ataya bay kələɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nen apan ni jak tə ɗiɗem a həna: Manay mə təker nà, way ana manay sa san. Manay apan mi side ɗukwen way ana manay sə canan tə iɗe a manay. Əna hwiya kə təmihen side a manay bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","À alay a nə təkərek ikwen way sə daliyugo ahay nà, kə ɗəfen upo nga bay. Həna ni ɗakak ikwen anan way saa təra à mburom, ki i mben apan sa ɗaf nga pa 'am uno ahay kəkəma kutok anaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","«Ɗowan saa zla kula à bagəbaga mburom nà, ibay. Si nen, Wan su Ɗo, sa nay ahay à mburom wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kawa ana Musa sə laway dədew sə rəslom ɗəzɗaz a pə dədom à kiɓe kwakwa ata nà, ɗo ahay ti laway nen, Wan su Ɗo, ɗukwen matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aday kuwaya kə̀ ɗəfak nga pa Wan su Ɗo nà, i njaɗ sifa sa ndav bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mbərom nà, a pəlay anan daliyugo cəveɗabay. Anga nan awan, a varay anan wan anahan mənduwel a coy. Natiya kutok, kuwaya kə̀ təmahak sa ɗaf nga pa wan ata nà, i lize bay, əna i njaɗ sifa sa ndav bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mbərom a slənay ahay wan anahan nà, sa nay saa gan sariya sa ban anan ɗo sə daliyugo ahay bay. Əna a nay sa tam anan ɗo sə daliyugo ahay aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","«Kuwaya kə̀ təmahak sa ɗaf nga pa Wan a Mbərom nà, sariya inde saa ban anan sabay. Aday ɗowan a kə̀ təmahak sa ɗaf nga pa wan a Mbərom a mənduwel ata bay ite nà, winen kə̀ slahak à sariya inde coy aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sariya ata aday nà, anga 'am a anan: Jiyjay a nay ahay pə daliyugo, əna ɗo sə daliyugo ahay tə pəlay luvon zal jiyjay, anga tinen apan ti ga nà, mer su way lelibay aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kuwaya winen apan i ga mer su way lelibay aya cəna, ata winen apan i nan iɗe anà jiyjay. I gan may sa nay à jiyjay inde bay, anga winen a jəjaran anà jiyjay saa kay anan mer su way anahan ma ga a à luvon inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kuwaya, ɗowan a kà gak mer su way sə ɗiɗem nà, winen nà, i nay, i bar ì iɗe jiyjay inde, anga aday jiyjay â dəvan pi mer su way anahan lele aya ma ga pa 'am a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Natiya kutok, Yesu a zla way anahan pə daliyugo sə Yahudiya tə njavar anahan ahay. Tə njahay pi zek à man ata awan, aday a gan baptisma anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuhana ite winen apan i gan baptisma anà ɗo ahay à wulen su doh sə Aynun, anga a'am inde à man ata bayak awan. Aynun awan aday nà, dəren tə wulen su doh sə Salim bay. Ɗo ahay bayak a ta zla pə cakay anahan saa gay ahay baptisma. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","À alay ata nà, Yuhana ma ban a à dangay fan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pa pac a inde, njavar ana Yuhana ahay tu ɗo kərtek à wulen sə Yahuda ahay tinen apan ti vaɗ uway pa 'am sə cəncan sə way ahay pi zek tə cəncan si zek. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Anga nan, ta zla pə cakay ana Yuhana. Ta jan, ta wa: «Miter, ɗowan a iken sə side apan, kə zlingen pa 'am zlinder sə Urdon ata nà, həna winen ɗukwen, winen apan i gan baptisma anà ɗo ahay. Ɗo ahay ɗukwen tinen apan ti zla fok pə cakay anahan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuhana a mbəɗahan atan apan, a wa: «Ɗowan sa njaɗ awan mənjəna Mbərom a sə varan anan nà, ibay asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kwanay kə slənen anan 'am uno coy. Na jak: Nen nà, Almasihu bay, əna Mbərom a slənay nen nà, aday nə̂ lahan pa 'am ca. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Uwar nà, anà ɗo sə gəɓa dalay a way anahan. Aday car ana ɗo sə gəɓa dalay ɗukwen, a tavay uho saa pak sləmay. Kə̀ slənek winen apan i nay coy nà, i taslay mivel ta 'am anahan aya fok. Matanan, nen nə taslay mivel ɗukwen nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Natiya awan nà, məduwen uno â kac, mbala anahan â zəga aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Ɗo sa nay ahay à mburom wa nà, winen pa nga su ɗo a kəzlek. Ɗo sə daliyugo ahay ɗukwen, tinen pə daliyugo. Ta ja nà, 'am sə daliyugo ɗəkɗek. Ɗo sa nay à bagəbaga mburom wa ata nà, winen pa nga sə ɗo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Way anahan sə canan tə way anahan sə sləne, a ga side ɗukwen pə way ataya awan. Əna ɗowan sə təma side anahan a nà, kwa kərtek ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kuwaya kə̀ təmahak side anahan nà, a san zle, Mbərom winen ɗo sə ɗiɗek. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɗo maslan a Mbərom cəna, winen apan i ja ɗukwen 'am ana Mbərom, anga Mbərom a, winen apan i rah anan tə Apasay anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bəbay Mbərom nà, a pəlay wan anahan cəveɗabay. Kə̀ varak anan gədan pa nga sə way ahay kəzlek. ");
INSERT INTO mqbNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kuwaya kə̀ ɗəfak nga pa wan a Mbərom nà, kə̀ njaɗak sifa sa ndav bay ata awan. Kuwaya kə̀ təmahak anan Wan a Mbərom bay ite nà, i njaɗ sifa kulibay, aday Mbərom i ga apan mivel sə coy.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisa ahay tə sləne nà, Yesu winen apan i njaɗ njavar ahay aday winen a gan baptisma anà ɗo ahay a zalay Yuhana. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aday nà, Yesu a kà gak anan baptisma anà ɗowan kwa kərtek bay. Sa ga mer su way ata nà, njavar anahan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu a sləne 'am a tinen ata cəna, a mbəsak daliyugo sə Yahudiya, a ma pə dəɓa à Galile. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Anga nan, si i takas ɗukwen tu kon sə Samariya. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Natiya awan, a dəzle à wulen su doh a inde tə ngaman Sikar, bəse tə guvo ana Yakob a inde, a varan anan kwakwa anà wan anahan Yusufu. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","À man ata kutok, kurok ana Yakob inde. Natiya kutok, man i pec a ga nà, Yesu a njahay pa nga kurok, anga kà yak nga tə cəveɗ. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","À alay ata awan ite nà, njavar anahan ahay, ta zlak à wulen su doh saa pəlay way sa pa. Aday uwar sə Samariya a inde a nay ahay pə kurok saa ngahak ayak a'am. Yesu a cəce panan a'am, a wa: «Vuro a'am ite.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Həren aday nà, 'am a zlan atan pi zek ana Yahuda ahay tə Samariya ahay bay. Anga nan, uwar ata awan a jan, a wa: «Iken nà, Yahuda ahay, nen ɗukwen Samariya ahay. Ki cəce puno a'am sa sa kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu a mbəɗahan apan kutok, a wa: «Abay kâ san sumor ana Mbərom saa ga, aday kâ san ɗowan a sə cəce panak a'am sa sa ata nà, iken ki cəce panan a'am sə varan sifa anà ɗo ahay ata aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uwar ata a jan anà Yesu, a wa: «Mazar, na ca apak nə cafgal sə ngahay a'am inde apak ibay! Kurok a anan ɗukwen sololo. Ki njaɗ a'am sə varan sifa anà ɗo ahay ata nà, ta maw? ");
INSERT INTO mqbNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bije a manay Yakob sə varan umo kurok a anan ɗukwen, kà sak wa a'am. Winen tə gwaslay anahan ahay fok, aday tə gənaw anahan aya təke, ta sak wa a'am. Aday iken kə zalay Yakob tə məduwen kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu a mbəɗahan apan, a wa: «Kuwaya kà sak a'am sə kurok a anan nà, jom i gan asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Aya əna, ɗowan kà sak a sa a'am mbala uno saa varan ata nà, jom i gan kula sabay, anga a'am ata i təra kawa zəlaka à winen inde, i varan sifa sa ndav bay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Uwar ata a jan, a wa: «Vuro a'am ata awan, aday jom û go sabay, nâ sa may ahay sə ngahak ayak a'am pə kurok wa kula sabay re biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu a jan apan, a wa: «Zla, ngaman ahay anà mbaz anak, hayak ikwen ahay à man a anan aday.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uwar ata a ja kutok, a wa: «Mbaz uno ibay!» Yesu a jan, a wa: «Ka jak ɗiɗem awan, kak ka wa mbaz anak ibay nà, na! ");
INSERT INTO mqbNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Anga ka zlak à mbaz həna saray ɗara, aday ɗowan a həna kwanay maya ata ɗukwen, winen mbaz sə pəzugoy anak a bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uwar ata a mbəɗahan anà dungo kutok, a wa: «Miter, nə sənak iken nə ɗo maja'am ana Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bije a manay ahay ɗukwen tə hərak anan nga anà Mbərom pə ɓəzlom a manay a anan, əna kwanay Yahuda ahay nà, ki wen, man sə həran nga anà Mbərom kərtek nà, si à Urəsalima.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu a jan, a wa: «Uwar, təma 'am a nen sa jak həna ata awan: Alay awan i sla azanan, ki həren anan nga anà Bəbay Mbərom nà, à ɓəzlom a anan ɗəkɗek sabay, kwa à Urəsalima taayak sabay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kwanay Samariya ahay aday nà, kə sənen ɗowan a kwanay sə həran nga ata bay. Əna manay Yahuda ahay nà, ma san ɗowan a manay sə həran nga ata zle, anga Mbərom a tam anan ɗo ahay nà, tə alay a manay Yahuda ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aday, alay a i nay ahay mba, kà slak coy aɗəka, Apasay Cəncan a, sa kay anan ɗiɗem ana Mbərom ata, i sənan anan zek anà ɗo ahay. Natiya awan, ɗo sa ɗaf nga pə Mbərom tə ɗiɗem ataya ti san sə həran nga pa man pa man ahay fok. Anga a nan anà Mbərom awan nà, ɗo sə həran nga matanan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mbərom nà, apasay sə varan sifa anà ɗo ahay. Ɗo ahay ti həran nga nà, tə ɗiɗem a aday tə məgala sə Apasay Cəncan a re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uwar ata a mbəɗahan apan, a wa: «Na san zle, Almasihu i i nay ahay. Kà nak coy nà, i ɗakak uko anan way ahay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Natiya, Yesu a mbəɗahan apan, a wa: «Nen a sa jak 'am ata nà, winen awan!» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Njavar a Yesu ataya ta may ahay kutok. Tə canan anà Yesu winen apan i ja 'am tu ɗo uwar a nà, a gan atan masuwayan. Aday ɗowan kwa kərtek kə̀ cəcihek pə uwar ata wa sa jəka: «Kə pəlay panan maw?» nà, ibay. Kabay, ɗowan sa jan anà Yesu: «Ki jen 'am angamaw?» ɗukwen, ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uwar ata a dazlan nà, a mbəsak anan kəlawa anahan pə kurok, a nay agay, a jan anà ɗo ahay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Hayak ikwen ahay aday, cen pə ɗowan inde, u jo həna way uno ahay sa ga ataya fok. Hinahibay nà, i ga nə winen Almasihu dəge?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɗo ahay ta nay ahay à wulen su doh wa kutok, ta zla pə cakay ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","À alay ata kutok, njavar a Yesu ahay ta jan, ta wa: «Miter, suwan pa way mənjœk aday.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu a mbəɗahan atan apan, a wa: «Way sa pa uno inde, kə sənen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Njavar anahan ahay tə cəce pi zek ahay wa, ta wa: «Ɗowan kə̀ varak anan ahay way sa pa dəge?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu a jan atan kutok: «Way sa pa uno awan nà, aɗəfan apan anà ɗo sə slənay ahay nen, aday sa ga mer su way anahan sə mbuko à alay inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Am ana kwanay inde ka ti jen nà: “A mbəsak həna kiya fuɗo, way ahay ti saa nah, aday saa car.” Aya əna nen ni jak ikwen, cen pə guvo ahay lele. Ndaw kə̀ nahak, kà slak sa car coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɗo sa car ndaw à guvo su ɗo nà, i halan nga anà ndaw ana bahay sə guvo, aday i njaɗ magwagway anahan pə ɗowan ata wa. Ndaw ata nà, kawa sa ja, ɗo sa njaɗ sifa sa ndav bay ataya awan. Anga aday ɗo sa casl pi zek tu ɗo sa car tə̂ taslay mivel cew maya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Am sə jike inde asa, a ja nà: “Ɗo sa casl winen cara, ɗo sə halan nga ɗukwen, winen cara.” Winen ata nà, 'am ɗiɗem awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na slan kwanay nà, saa cəray à man aday kwanay kə cislen bay ata wa. Ɗo maza aya sa casl, kwanay ɗukwen kə njiɗen anan magwagway ti mer su way a tinen.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ɗo sə Samariya ahay à Sikar bayak a tə təmahak sa ɗaf nga pə Yesu anga side ana uwar ata sa jan atan: «U jo anan way uno ahay sa ga ataya fok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ta nay ahay pə cakay ana Yesu nà, ta jan â njahay tə tinen mba. Yesu a njahay àga tinen kutok luvon ahay cew. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɗo ahay bayak a tə ɗəfak nga pə Yesu asa, anga tə slənek 'am anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Anga nan, ta jan anà uwar ata awan: «Həna nà, mə ɗəfak nga pə Yesu nà, anga 'am anak sa jan umo ata bay. Cərkəke ma ɗaf apan nga, mə təma nà, anga manay awan mə slənek 'am anahan aya awan. Ma san zle, winen nà, ɗo sa tam anan ɗo ahay acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pə dəɓa à luvon cew ata wa nà, Yesu a mbəsak atan, a zla way anahan à Galile. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu a kà jak, a wa: «Ɗo ahay ta gan nga anà 'am ana ɗo maja'am a Mbərom kwa ta sə wura fok. Əna ù kon anahan a nà, ɗowan a gan nga anà 'am anahan ahay itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tə dəzle pə daliyugo sə Galile awan nà, ɗo sa man ataya tə təma anan lele, anga tinen ta zlak à azar uko sə Pasəka à Urəsalima, aday tə canak anan ahay à mer su way anahan sa ga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Natiya, Yesu a ma way anahan à Kana pə daliyugo sə Galile, à man anahan sə mbəɗa anan a'am mahay awan ata awan. Ɗowan a inde, winen məduwen a à man ata awan, winen ɗo si mer su way ana bahay sə daliyugo ata awan. Wan ana ɗowan ata winen ɗəvac awan, aday mə nahay a à wulen su doh sə Kafarnahum. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɗowan ata a sləne sa jəka Yesu winen pə daliyugo sə Yahudiya sabay, winen à Galile nà, a zla pə cakay anahan, a jan: «Zlumo à Kafarnahum, aday ki saa mbəro anan wan uno inde mə nahay a, winen ɗəvac awan, i mac coy.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu a jan, a wa: «Ki ɗəfen upo nga fan bay, si ki cinen anan anà masuwayan ahay aday ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɗowan ata a mbəɗahan apan kutok, a wa: «Hayak àga nen aday. Wan uno ata i saa mac.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu a wa: «Zla agay, wan anak kə̀ mbərak!» Winen a ɗaf nga pa 'am ana Yesu ata awan, a zla way anahan agay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Winen pə cəveɗ sa zla agay mba, ɗo anahan ahay ta nay agay wa, ta jan: «Wan anak nə kə̀ mbərak coy!» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɗowan ata a cəce patan wa: «A njaɗ sa man uda awan nà, siwaw?» Tə mbəɗahan apan: «Avaɗ a sə ipec, tə njamde kərtek, nga sə ɓərazl a ndalay panan nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bəbay a wan ata, a may anan ahay à nga inde 'am à Yesu sa jəka: «Wan anak kə̀ mbərak» ata nà, kəslsla alay ata acəkan. Ta ɗaf nga pə Yesu tu ɗo su doh anahan ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Masuwayan a Yesu sa ga ata nà, winen mə slala cew a sə təra à Galile. A təra pə dəɓa anahan sa may ahay à Yahudiya wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pə dəɓa anahan a wa mənjœk nà, Yahuda ahay ta zla saa zar uko à Urəsalima. Yesu ɗukwen a zla ite. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","À man ata nà, məsudoh a inde tə ngaman Məsudoh sə Təman ahay. Dəlov a inde ma la awan, aday ta ga apan galak ahay ɗara tew. A'am ata nà, tə ngaman Baytizata ta 'am sə Yahuda ahay nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɗo sə ɗəvac ahay cara cara bayak a mə nahay aya ù vo sə galak ataya awan: hurof ahay, vədal ahay, pi zek tə ɗo sə jəje ahay. Tinen apan ti ba, hinahibay a'am i ɓal, ");
INSERT INTO mqbNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","anga pac a hinen ahay nà, maslay a Mbərom a dazay ahay à a'am ata inde, i ɓal anan. A'am ata kə̀ ɓəlak nà, ɗowan a sa lah uda pa 'am ata cəna, winen kə̀ mbərak à ɗəvac anahan wa, kwa â ga nə ɗəvac wura wura fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɗowan a inde ɗəvac awan à man ata, kà gak à ɗəvac inde ava kwa kuro maakan nga anahan a jəmaakan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu a canan cəna, a san zle, ɗəvac kə̀ njahak apan. Anga nan, a cəce panan: «A nak sa mbar à ɗəvac anak wa ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɗowan ata a mbəɗahan apan, a wa: «Wan ada, ɗowan uno inde saa zla nen à a'am inde, ibay. A'am kə̀ ɓəlak dəp nà, kwa nə̂ rəzlen à nga wa kəma kəma ɗukwen, ɗo maza awan i luho uda awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu a jan asa: «Slabak, gəɓa lala anak, zla way anak kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɗowan ata a mbar ca, a gəɓa lala anahan, a zla təpa təpa. Cəkəbay, pac ata nà, luvon sa man uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Anga nan, bahay sə Yahuda ahay ta jan anà ɗowan ata awan: «Biten nà, luvon sa man uda awan. Cəveɗ anak inde sə tavak lala anak pa nga ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Winen ite a mbəɗahan atan apan, a wa: «Ɗowan a sa mbar nen ata u jo nà, gəɓa lala anak, zla way anak.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɗowan ataya tə cəce panan, ta wa: «Ɗowan a sa jak: “Gəɓa lala anak, zla” ata nà, wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ɗowan ata ɗukwen a san sa mbar anan nə wayaw bay. Bina Yesu a ɗukwen kà zlak way anahan à man ata wa səmaɗ bəse, anga ɗo ahay bayak a à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pə dəɓa anahan a wa nà, Yesu a tan ayak à nga anà ɗowan ata awan ù doh sə mazlaɓ a Mbərom. A jan, a wa: «Həna nà, kə̀ mbərak. Kâ saa ga ines sabay, anga way sə zalay winen ata â sa nay ahay apak sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɗowan ata a zla sa jan anà bahay sə Yahuda ahay nà, sa mbar anan nə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Natiya kutok, bahay sə Yahuda ataya tə dazlan sə jugwar 'am pə Yesu wa asa, anga a mbar anan ɗo pə luvon sa man uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Əna Yesu a ɗakan atan anan lele, a wa: «Bəbay uno nà, winen apan i ga mer su way nə pac pac. Nen ɗukwen si ni ga mer su way kətana awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Anga 'am anahan ataya awan, Yahuda ataya tə zəga anan sa nan iɗe hus pa sə pəlay sa vaɗ anan à məke aɗəka. Anga sa jəka, winen a ga mer su way pə luvon sa man uda ata ɗəkɗek sabay, əna a wa Mbərom nə bəbay anahan. Matanan, a lavay anan nga anahan tə Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu a jan atan asa, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Nen, wan a Mbərom nà, ni mba apan sa ga way ta nga uno itəbay. Ni ga nà, way mbala ana Bəbay uno sa ga, way aday nə canak anan ata awan. Kawa ana Bəbay uno sa ga jiga awan, nen ni ga winen a re, ");
INSERT INTO mqbNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","anga aday nà, Bəbay uno a pəlay nen, a ɗuko anan way anahan sa ga ahay fok. I ɗuko pə way sə zalay həna anaya awan mba. Nen wan nà, ni ga atan. Way ataya cəna, ti gak ikwen masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","«Natiya, kawa ana Bəbay uno sə slabak anan ɗo ma mac aya awan, aday a varan atan sifa ata nà, nen wan anahan ɗukwen ni varan sifa anà ɗo kawa su no anà nen matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","«Aday asa, Bəbay uno nà, kə̀ pəlak sa gan sariya anà ɗowan kwa kərtek bay, əna a mbəsak anan sariya fok à alay uno inde nen wan anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Anga aday ɗo ahay tə̂ həro nga anà nen wan anahan, kawa sə həran nga anà Bəbay uno sə slənay nen ata awan. Kak ɗowan a a həro nga anà nen wan anahan bay nà, a həran nga anà Bəbay uno bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya ɗowan a kə̀ slənek 'am uno aday kə̀ ɗəfak nga pu ɗo sə slənay ahay nen nà, winen kə̀ njaɗak sifa sa ndav bay ata awan, sariya i ban anan itəbay. Kawa sa ja bine siwaw nà, kə̀ takasak ahay à amac wa, kà zlak à sifa inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Nen apan ni jak ikwen tə ɗiɗem a həna: Alay a i slay ahay, kà slak aɗəka coy, ɗo ma mac aya ti sləne dungo uno, nen Wan a Mbərom, aday ɗo sə sləne ahay fok ti njahay uho tə sifa awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kawa ana Bəbay uno sa mba apan sə njahay anan ɗo ahay uho ata nà, nen wan anahan ɗukwen a vuro gədan sə njahay anan ɗo ahay uho re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A vuro gədan a nà, aday nâ gan sariya anà ɗo ahay, anga nen Wan su Ɗo. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«'Am a anan â gak ikwen masuwayan bay. Alay a awan kà slak anga ɗo ma mac aya aday tə sləne dungo uno, ");
INSERT INTO mqbNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aday ti slabakay ahay à məke a tinen ahay wa. Ɗo sa taa ga way lele aya awan, ti may uho saa njaɗ sifa. Aday ɗo sa taa ga nə way sə cəɓan anà Mbərom ite, ti may uho nà, sariya i ban atan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Na ga sariya nà, kawa ana Mbərom a su jo. Ni mba apan sa ga awan ta nga uno bay. Sariya uno sa ga nà, winen lele, anga nen na ga way sa nga uno bay. Na ga nà, way mbala ana ɗo sə slənay ahay nen ata awan, aday kawa sa nan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesu a ja asa, a wa: «Abay kak na gan side anà nga uno nà, ata side uno kà zlak tə ɗiɗem a bay asanaw. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Əna ɗowan a inde, winen a ga side anga nen, aday na san zle side anahan nà, tə ɗiɗem awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kwanay awan, kə slənen ɗo pə cakay ana Yuhana, kà jak ikwen side anahan, aday side anahan nà, ɗiɗem awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Abay nə pəlay side su ɗo zənzen a bay. Əna na ja pə Yuhana ata nà, aday kə̂ təmen à amac wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Anga Yuhana kə̀ tərak nà, kawa lalam ma han uko awan. Winen apan i dav. Jiyjay anahan ata kà zlak ikwen à nga, əna à alay a inde mənjœk coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Aya əna, 'am sə side uno inde sə zalay side mbala ana Yuhana. 'Am sə side ata nà, mer su way a Bəbay uno su jo: “Ga anan!” ata awan. Ni ga mer su way a anan ata nà, anga saa side, nen na nay ahay nə pə cakay ana Bəbay uno wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Abay Bəbay uno ɗo sə slənay ahay nen ata ɗukwen, winen apan i ga upo side a re. Kwanay kula kə slənen anan dungo anahan itəbay, aday kula kə cinen anan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kula kə bənen 'am anahan à mivel a kwanay inde bay, anga kə ɗəfen nga pi nen, ɗo anahan sə slənay ahay à wulen a kwanay ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Kwanay apan ki jingen Deftere a Mbərom, anga a ga pikwen nà, ki njiɗen wa sifa sa ndav bay ata awan. Aday cəkəbay Deftere ata ɗukwen a təker nà, 'am sə side sa ga pi nen a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Əna, a nak ikwen sa nay ahay pə cakay uno aday kə̂ njiɗen sifa ɗiɗem ata bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Nə pəlay sa njaɗ mazlaɓ pə ɗo ahay wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Əna na san kwanay aya zle. Kwanay kə pəlen Mbərom bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na nay ahay nà, à sləmay ana Bəbay uno inde. Aday, cen apan. Kə ngəmen sə təma nen bay re. Aday, kak ɗowan a maza â nay ahay ta 'am sa nga anahan həna nà, ki təmihen anan, winen aɗəka nà, tə alay cuwcew awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kwanay kə pəlen ayaw mbala ana Mbərom bay, əna kuwaya a pəlay nà, ayaw sə ɗo ahay. Aday ki mben apan sa ɗaf upo nga nà, kəkəma asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Kâ sa jilen sa jəka nen ni zlah pikwen pə cakay ana bəbay uno Mbərom bay. Əna Musa, ɗo a kwanay sa ɗaf apan nga ata awan, winen saa zlah pikwen. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aday abay kə ɗəfen ahay nga pa 'am ana Musa ahay aday nà, ki ɗəfen nga həna pa 'am uno ahay re. Anga Musa aday ɗukwen a vindey ahay nà, anga nen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Natiya, kak kə ɗəfen nga pə way mbala anahan mə vinde aya bay nà, ki i mben apan sa ɗaf nga pa 'am uno bay re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pə dəɓa anahan a wa nà, Yesu a takas bəlay sə Galile a inde, a zla pa day uho. Tə ngaman anà bəlay ata nà, Tiberiyas re. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ɗo ahay tə pərahan azar bayak awan, anga tə canak anan anà mer su way anahan ma ga masuwayan aya awan, a mbar anan ɗo sə ɗəvac ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu a ján way anahan à ɓəzlom tə njavar anahan ahay, tə njahay à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Azar uko sə Pasəka ɗukwen i sla bəse. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu a cakaf nga bine maw nà, a canan anà ɗo ahay bayak a tinen apan ti nay pə cakay anahan. Anga nan kutok, a jan anà Filip: «Ɗi njaɗ sə sukumay ahay way sa pa sə varan anà ɗo ahay a anan fok awanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A cəce ata nà, aday â san way mbala a Filip saa mbəɗahan apan ata awan. Bina, Yesu a nà, a san way anahan saa ga zle. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip a mbəɗahan apan, a wa: «Kak aday a nak uko sa jəka ɗi varan way sa pa anà man su ɗo a anan nà, kwa dala sə dinar səkat cew ɗukwen i sla awan bay asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mərak ana Simon Piyer a inde, tə ngaman Andəre, winen njavar ana Yesu a re. A jan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Wan inde həna à man a anan, tapa sə pen ahay inde apan ɗara. Kəlef ahay ɗukwen inde apan cew! Aka aday i sla ma, anga man su ɗo a anan anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu a jan atan kutok, a wa: «Jen anan ù ɗo a anaya fok tə̂ njahay a məndak.» Gujeɗ inde məngəɗez a à man ata awan. Ɗo ahay tə njahay apan kutok. Ɗo ahay à man ata ɗukwen, tinen mə baslay a nà, mungol a ɗəkɗek aday nà, ta ga mbulo ɗara. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu a gəɓa anan tapa sə pen a ɗara ataya awan, a ngəran ayak anà Mbərom aday a gəzlan anan anà ɗo ahay. A ga anan tə kəlef ɗukwen matanan. Kuwaya kə̀ njaɗak kawa sa nan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tinen ata fok, ta rah nà, Yesu a jan anà njavar anahan ahay: «Hilen anan nga anà tapa sə pen mə mbəsak ata awan, anga aday â sa nes bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tə halan nga anà mə mbəsak ata nà, a ga cəkarak kuro nga anahan a cew. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ɗo ahay sə canan anà masuwayan ana Yesu a sa ga ata nà, ta wa: «Tə ɗiɗem awan, ɗowan a anan nà, i ga nà, winen ɗo maja'am a Mbərom saa nay ahay pə daliyugo azanan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu a san zle, ɗo ahay ti nay ahay saa ban anan aday ti i ɗaf anan bahay awan sə məgala. Anga nan, a zla way anahan səmaɗ à ɓəzlom maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Natiya awan, suko a a ga cəna, njavar ana Yesu ahay tə dazay pa 'am sə a'am sə bəlay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ta ján à kwalalan inde sa zla à Kafarnahum. À alay ata ɗukwen, iɗe kə̀ bənak lele coy, aya əna Yesu winen inde tə tinen ibay hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A'am a ɓal tə məgalak awan, anga maɗ winen apan i ɓal bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kwalalan a haw pa nga sə a'am i ga kilomiter ɗara kabay mbərka nà, tə canan anà Yesu, winen apan i nay ahay tə saray pa nga sə a'am, aday winen bəse tə tinen coy. Tinen ite tə jəjar pi zek. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Coy Yesu a jan atan, a wa: «Nen awan! Kə̂ jəjiren bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Natiya kutok, a nan atan sə gəɓa anan à kwalalan inde, aday kwayan'a kwalalan ata kə̀ dəzlek pə yugo à man a tinen sa gan may ata coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sidew a nà, ɗo sə njahay pa day sə bəlay hinen ataya tə pəlay anan Yesu. Anga ta san zle, avaɗ awan nà, kwalalan inde nə kərtektəkke. Aday ta san zle re, Yesu nà, kə̀ jənak à kwalalan mbala ana njavar anahan ahay sə gəɓa ata bay. Ta zla nà, mənjəna winen. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Əna kwalalan azar aya inde ta nay ahay à Tiberiyas wa. Tə dəzley ahay nà, ɗinger pa man ana Yesu sə varan tapa sə pen anà ɗo ahay ta sə ngəran anà Mbərom ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɗo ahay ta ca iɗe cəna, Yesu winen ibay, aday njavar anahan ahay ɗukwen tinen ibay. Natiya tə gəɓa kwalalan ahay sa zla a Kafarnahum saa pəlay Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta njaɗ anan winen pa day uho, tə cəce panan, ta wa: «Miter, ka nay ahay à man a anan nə siwaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu a mbəɗahan atan apan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kə pəlen nen nə, anga ki pen way həniniye, aday kə rihen re ata awan. Bina, masuwayan uno sa gak ikwen ata nà, kə sənen bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kə̂ mbəɗəken sa ga mer su way sa njaɗ way sa pa sa nes ata aɗəka bay. Suwan aɗəka, gen nà, mer su way sa njaɗ way sa pa sə njahay pa sə viyviya ata awan. Way sa pa ata nà, a var sifa sa ndav bay ata awan. Saa varak ikwen anan nà, nen Wan su Ɗo. Anga Bəbay uno awan, kə̀ təmahak sa ɗaf anan upo mazlaɓ anahan pə iɗe sə ɗo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɗo ahay tə cəce panan asa, ta wa: «Mi njaɗ sa ga ma, kawa ana Mbərom sə pəlay anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu a jan atan, a wa: «Mer su way ana Mbərom sə pəlay nà, ɗəfen nga pi nen, nen ɗo anahan mə slənay ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tə cəce panan re, ta wa: «Mi ɗaf apak nga ata nà, ki gan umo nə masuwayan a wuraw? Ki ga nə maw? ");
INSERT INTO mqbNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bije a manay ahay ta pak manu à kiɓe. Kawa ana Deftere sa ja apan ata: “A varan atan way sa pa à kiɓe. Way sa pa ata ɗukwen a dazay ahay à mburom wa.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu a mbəɗahan atan apan maza re, a wa: «Ki wen, sə varak ikwen way sa pa sə dazay ahay à mburom wa nà, Musa. Əna matanan bay. Nen apan ni jak ikwen tə ɗiɗem a həna: Sə varak ikwen way sa pa guzgwez awan, aday sa nay ahay a mburom wa nà, Bəbay uno awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Way sa pa a Mbərom saa varak ikwen ata nà, nen, ɗo sə dazay ahay pə kərngay à mburom wa ata awan. Aday saa varan sifa anà ɗo ahay pə daliyugo ɗukwen, nen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ta jan asa, ta wa: «Wan ada, varan umo way sa pa ata pac pac hwiya biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu a jan atan, a wa: «Ɗaf sa var sifa nà, nen awan. Ɗowan a kà nak pə cakay uno nà, may i han apan kula sabay. Aday ɗowan a kə̀ ɗəfak nga pi nen ɗukwen, jom i gan kula sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aya əna na jak ikwen: Kə cinen uno, əna kə ɗəfen upo nga bay hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bəbay uno kə̀ varak uno anan kuwaya fok cəna, i nay ahay pə cakay uno awan. Aday kuwaya kà nak ahay pə cakay uno cəna, ni lar a bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anga na nay ahay à mburom wa nà, sa naa ga way su no anà nen bay, əna sa naa ga way sa nan anà ɗo sə slənay ahay nen. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aday way ana ɗo sə slənay ahay nen ata sa nan nà, həna: Nâ saa lize anan ɗo winen sə vuro ataya kwa kərtek bay, əna pa pac sa ndav anan daliyugo nà, nə̂ slabakay atan ahay à məke wa uho. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Natiya awan, kuwaya kə̀ canak uno anà nen Wan ana Mbərom, aday kə̀ ɗəfak upo nga nà, ɗowan ata i njaɗ sifa sa ndav bay ata awan. Aday nen ni slabakay anan ahay à məke wa pa pac sa ndav anan daliyugo. Sa nan à Bəbay uno nà, way ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Anga nan kutok, Yahuda ahay tə dazlan sə gəɗan azar ana Yesu, anga a wa: «Nen nà, way sa pa sə dazay ahay à mburom wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ta wa: «Na wa, winen nə Yesu ba? Wan ana Yusufu biɗaw? Ɗa san atə bəbay anahan tə may anahan a təke biɗaw? Aka aday, i jəka winen a dazay ahay à mburom wa nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu a jan atan, a wa: «Mbəsiken sa gaɗ azar à wulen ana kwanay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɗowan saa njaɗ sa nay ahay pə cakay uno nà, ibay, si kak Bəbay uno a sə slənay ahay nen ata kə̀ jərahak apan sa nay anan aday. Kuwaya ɗowan a kə̀ njaɗak sa nay ahay pə cakay uno nà, nen ni slabakay anan ahay à məke wa pa pac sa ndav anan daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ɗo maja'am ana Mbərom ahay tə vindek, ta wa: “Tinen a kəzlek, Mbərom i ɗakan atan anan way.” Ɗowan a kə̀ slənek 'am ana Bəbay uno, aday kə̀ təmahak atətak way anahan nà, i nay ahay pə cakay uno. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kula ɗowan kə̀ canak anan anà Mbərom bay, si nen, ɗo sa nay ahay pə cakay ana Mbərom a wa, nen kərtek nə, nə canak anan à Bəbay acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Natiya awan, nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan a kə̀ ɗəfak upo nga nà, kə̀ njaɗak sifa sa ndav bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Way sa pa sa var sifa ata nà, nen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bije a kwanay ahay ta pak manu à saf inde. Kə̀ varak atan sifa bay. Anga nan, fok a tinen a tə məcak à saf inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yo, ɗo sa pa tapa sə pen sə dazay ahay à mburom wa ata nà, â ga nə kuwaya i mac itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nen nà, way sa pa sa nay ahay à mburom wa ata awan, way sa pa sa var sifa. Ɗowan a kà pak way sa pa ata nà, i mac kula itəbay. Way sa pa ata nà, zek uno awan. Ni var anan anga aday ɗo ahay tâ njaɗ sifa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'Am a anaya awan a gəɓan atan ahay agaɗ azar sa ga mivel anà Yahuda ataya asa, ta wa: «I varak uko zek anahan aday ɗi pa nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu a mbəɗahan atan apan, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Nen Wan su Ɗo nà, kak ki pen zek uno bay, aday ki sen mez uno bay nà, sifa i ga inde à kwanay ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Əna ɗowan a kà pak zek uno aday kà sak mez uno re cəna, ɗowan ata kə̀ njaɗak sifa sa ndav bay ata awan, aday ni slabakay anan ahay à məke wa pa pac ana daliyugo saa ndav. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anga zek uno bine siwaw nà, way sa pa guzgwez awan, aday mez uno ɗukwen way sa sa guzgwez a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kuwaya kà pak zek uno, kà sak mez uno nà, winen kə̀ japak ti nen; nen nə japak tə winen re. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bəbay uno, ɗo sa var sifa nà, sə slənay ahay nen nà, winen awan. Nen nə njahay uho nà, anga winen. Matanan, kuwaya kà pak zek uno nà, i njahay uho anga nen cite re. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","«Natiya, way sa pa sə dazay ahay à mburom wa nà, zek uno kutok. Bije a kwanay ahay nà, ta pak manu sə dazay à mburom wa à saf inde. Aday pə dəɓa anahan a wa ɗukwen, tə məcak fok re. Aya əna, kuwaya ɗowan a kà pak way sa pa mbala uno saa var ata nà, i mac kula itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","À alay ata nà, Yesu winen apan i wazay ù doh sə wazay ana Yahuda ahay à wulen su doh sə Kafarnahum, a saa ja 'am a anaya nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ɗo ahay bayan a à wulen sə njavar ana Yesu ahay tə sləne 'am ataya cəna, ta wa: «'Am anaya ma da 'am aya awan. Waya sa mba apan sə təma kətanan anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu a san zle tinen apan ti gəɗan azar pa 'am ataya awan. Anga nan, a jan atan, a wa: «'Am uno kə̀ mbəɗahak ikwen anan ajalay nga a kwanay ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aday, azanan kə cinen anan anà nen, Wan su Ɗo, nen apan ni ján à man sə njahay uno kwakwa ata awan. Ata aday, ki i jen kəkəma asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sa var sifa nà, Apasay a Mbərom. Zek su ɗo zənzen a nà, a mba apan itəbay. 'Am a nen sa jak ikwen ataya nà, sə zəɓay ahay Apasay tə sifa nà, tinen aya kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Əna, ɗowan aya inde à wulen ana kwanay nà, ta ɗaf upo nga itəbay.» Anga kurre a ata ɗukwen Yesu a san ɗo saa ɗaf apan nga tə ɗiɗem a bay ataya zle, aday a san ɗowan a saa ga apan ɗaf ata zle re. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu a zəga anan asa, a wa: «Anga nan, na jak ikwen, na wa: “Ɗowan saa njaɗ sa nay pə cakay uno nà, ibay, si kak Bəbay uno a sə slənay nen ata kə̀ jərahak apan sa nay anan pə cakay uno awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A bənay ahay kwa pə alay ata wa nà, njavar a Yesu ahay bayak a ta zla way a tinen, ta ngam sə pərahan azar sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kutok, Yesu a jan anà ɗo maslan a kuro nga cew ataya awan: «Kwanay ɗukwen, a nak ikwen sa zla way a kwanay re ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyer a mbəɗahan apan kutok, a wa: «Miter, mi zla nà, pə cakay ana wayaw? 'Am anak nà, 'am sa var sifa sa ndav bay, pə cakay ana Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aday manay ma ɗaf apan nga, ma san zle, iken nà, ɗo cəncan a sa nay pə cakay ana Mbərom wa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu a mbəɗahan atan apan, a wa: «Nen a sə walay kwanay, kwanay a kuro nga anahan a cew. Aday cəkəbay ɗowan a kwanay a kərtek a nà, winen bahay sə setene awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A ja 'am ata nà, pa wan ana Simon Iskariyot, sə ngaman Yudas ata awan. Anga kwa â ga nà, Yudas kə̀ tərak ɗo kərtek à wulen sə njavar ahay kuro nga cew ataya wa ɗukwen, saa ga ɗaf pə Yesu nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pə dəɓa anahan a wa nà, Yesu a bar pə daliyugo sə Galile fok. A nan abay sa zla pə daliyugo sə Yahudiya bay, anga a nan anà bahay sə Yahuda ahay sa vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aya əna, azar uko sə jawjawa ahay winen bəse nà, ");
INSERT INTO mqbNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","mərak ana Yesu ahay ta jan, ta wa: «Mbəsak man a anan, zla way anak pə daliyugo sə Yahudiya. Aday ata njavar anak ahay tə̂ canan anà mer su way anak ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɗowan a, a nan ɗo ahay tâ san anan nà, a ɗer zek sa ga mer su way itəbay. Ki ga mer su way a anaya asənə, ga atan pə iɗe sə ɗo ahay fok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwa mərak aya ɗukwen tə ɗəfak apan nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu a jan atan: «Kə̀ dəzlek pə alay uno təɗe ata fan bay. Pə kwanay nà, alay wura wura cəna təɗe, əna kətanan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɗo sə daliyugo ahay ti mba apan sa nak ikwen iɗe itəbay. Nen a nà, ɗo sə daliyugo ahay ti no iɗe anga nen apan ni kay anan mer su way a tinen ma ga aya nà, tinen lelibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kwanay nà, zlen à man sə azar uko ata awan. Əna nen ni zla bay, anga alay uno kə̀ dəzlek fan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A jan atan 'am ata cəna, winen a a njahay à Galile. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pə dəɓa ana mərak a Yesu ahay fok sa zla à azar uko nà, Yesu a ɗukwen a zla cite. Əna kà kak anan zek anà ɗo ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bahay sə Yahuda ahay tə pəlay anan à wulen sə ɗo ahay wa à man sə azar uko ata awan, tə cəce: «Winen ahaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ɗo ahay tə səsœk a səsœk à wulen a tinen ahay inde. Ɗo a azar aya ta wa: «Winen ɗo lele awan.» Ɗo a azar aya ɗukwen ta wa: «A'ay, winen apan i lize anan ɗo ahay aɗəka.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Əna ɗowan sa ja 'am ataya tə njezlnjezlezl a ɗukwen ibay, anga tə jəjaran anà bahay sə Yahuda ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Natiya awan, luvon sə azar uko ahay ta zla panan əngal nà, Yesu a zla ù doh sə mazlaɓ a Mbərom, a dazlan sə tətakan anan way anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A gan masuwayan ana bahay sə Yahuda ahay. Anga nan tə cəce, ta wa: «Ɗowan a anan kə̀ jingek bay kutok nà, a njaɗ mərike kawa həna anan nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu a mbəɗahan atan apan, a wa: «Way nen sa ta jak ikwen ata nà, a nay ahay ì nen a wa bay, əna a nay ahay nà, ù ɗo sə slənay ahay nen ata wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kuwaya, kak ɗowan a kə̀ təmahak sa ga mer su way kawa sa nan anà Mbərom cəna, i san sə gəzla way ahay pi zek wa. Matanan, kak na ja 'am ana Mbərom, kabay na ja 'am sa nga uno, aday tə məgala uno nà, i san kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kuwaya, kak a ja nà, 'am sa nga anahan, i pəlan mazlaɓ anà nga anahan. Əna kuwaya kə̀ pəlak sə həran nga anà ɗo sə slənay anan ahay nà, ɗowan ata ɗukwen, ɗo ɗiɗem awan, mungwalay inde apan ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na wa, Musa kə̀ varak ikwen Tawrita à alay inde ba? Əna ɗowan kwa kərtek sə ɗəfan apan nà, ibay asanaw? Kə pəlen sa vaɗ nen nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ɗo ahay tə mbəɗahan apan kutok, ta wa: «Setene inde anak à nga dəge, nga i vawak kələɗaw! Waya sə pəlay sa vaɗ iken anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu a mbəɗahan atan apan: «Na ga way kərtektəkke cəna, kà gak ikwen masuwayan jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa a jak ikwen nà, 'am sa gaɗ mədəndalas. Cəkəbay, sə dazlan nə Musa bay, əna bije ahay kwakwa tə lahak anan apan. A wa, kə̂ gəɗan anan mədəndalas à wan ana kwanay ahay pə luvon jəmaakan anahan sə wahay anan. Anga nan, kwa â ga nə pə luvon sa man uda dəp nà, kwanay apan ki gəɗen anan mədəndalas anà wan a kwanay a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kə gəɗen anan mədəndalas anà wan, aday kâ sa mbəsiken anan 'am ana Musa à dəɓa bay, kwa â ga nə luvon sa man uda nà, na. Aday, a cəɓak ikwen anà kwanay pi nen, anga na mbar anan zek su ɗo zənzen a təsœs fok pə luvon sa man uda nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mbəsiken sə gəɗan azar anà ɗo pə way sa ca apan tə iɗe, əna sənen anan way ataya tə ɗiɗek aya aday.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɗo ahay à wulen su ɗo sə Urəsalima ataya ta wa: «Na wa, Yesu nà, winen ɗo abay tə pəlay sa vaɗ anan ata ba? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A ja 'am tə njezlnjezlezl awan. Ɗowan sə gafan 'am ibay. Natiya awan nà, ɗo a mənuko məceɗ aya ta san zle winen nə Almasihu ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aya əna, kak winen nə Almasihu nà, ɗowan i san man anahan awan, a nay ahay awanaw bay. Aday ɗowan a anan ata nà, ɗa san man anahan a zle asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","À alay ata nà, Yesu winen apan i tətakan anan way anà ɗo ahay ù doh sə mazlaɓ a Mbərom. A zəga anan tə dungo mə təɓa lele, a wa: «Kə sənen nen zle ɗaw? Aday kə sənen man uno sa nay wa ata zle ɗaw? Na nay nə gəɓay nà, 'am sa nga uno bay. Ɗowan a sə slənay nen ata nà, ɗo ɗiɗem awan. Aka aday, kə sənen anan bay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nen nà, na san anan zle, anga na nay ahay nə pə cakay anahan a wa. Sə slənay ahay nen nà, winen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tə pəlay sa ban anan à man ata kutok, əna ɗowan kə̀ njaɗak sə laman bay, anga kà slak pə alay anahan a bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cəkəbay, ɗo ahay bayak a tə ɗəfak apan nga, ta wa: «Almasihu a kà sak a nay ahay nà, i ga masuwayan ahay sə zalay ɗowan a anan kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisa ahay tə sləne asəsœk 'am sə ɗo ahay ata pə Yesu nà, tə halay nga tə bahay sə gəɗan dungo anà way ataya awan. Aday tə jəjem 'am, ta slan ɗo sa ba pu doh sə mazlaɓ a Mbərom ahay saa bənay anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu a ja, a wa: «Nen ni njahay tə kwanay mənjœk mba. Pə dəɓa anahan a wa nà, ni ma pə cakay ana ɗo sə slənay ahay nen. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ki i pəlen nen, ki njiɗen nen sabay, anga ki mben apan sa zla à man uno saa zla ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bahay sə Yahuda ahay tə cəce pi zek ahay wa, ta wa: «I zla aha anahan aday mənuko saa mba apan sa njaɗ anan itəbay ata kəlanaw? Aday i zla àga Yahuda ahay tinen à wulen sə Gərek ahay ata ɗaw? I zla saa ɗakan atan anan way anà Gərek ahay dəge? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Winen awan a wa: “Ki pəlen nen, aday ki njiɗen nen bay, anga ki mben apan sa zla à man uno sa zla ata bay.” A nan sa ja aday nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Luvon sa ndav anan azar uko cəna, a zalay luvon azar aya tə mazlaɓ. Pa pac ata awan, Yesu a tavay à wulen sə ɗo ahay. A ja 'am tə məgalak awan, a wa: «Kuwaya, jom a gan cəna, â nay ahay pə cakay uno, aday i sa a'am. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Aday ɗowan a kə̀ ɗəfak upo nga, “mivel anahan i təra kurok sə a'am sa var sifa, i haw kawa zəlaka.” Deftere a Mbərom a ja nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu a ga jike ata nà, pə Apasay Cəncan awan, apasay mbala ɗo sa ɗaf apan nga ahay saa njaɗ ata awan. À alay ata nà, ɗo anahan ahay tə njaɗak Apasay Cəncan ata fan bay, anga Yesu a ɗukwen kà zlak à man sə mazlaɓ anahan fan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɗo azar aya tə sləne 'am ataya cəna, ta wa: «Tə ɗiɗem awan, ɗowan a anan nà, ɗo maja'am a Mbərom a mənuko sa ba ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ɗo maza aya ite ta wa: «Winen nà, Almasihu asanaw!» Ɗo hinen ahay asa ta wa: «Kəmaya, Almasihu sa maw! Winen nà, i nay ahay à Galile wa bay asanaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Deftere a Mbərom a ja nà, Almasihu i təra nà, ɗo sə slala ana Dawuda, aday ti wahay anan à Baytilama, wulen su doh ana bahay Dawuda way anahan. Matanan biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mawrasan a zlan à mivel inde anà ɗo ahay anga Yesu cərkəke. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɗo azar aya à wulen a tinen a nan atan sa ban anan Yesu, əna ɗowan kə̀ njaɗak sə laman bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yawa, ɗo maslan ahay ta may ahay pə cakay ana bahay sə gəɗan dungo anà way ahay, tinen pə kərtek a tə Farisa ahay. Tinen ite, tə cəce pu ɗo maslan ataya wa: «Kə bənen anan ahay Yesu a bay nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ɗo maslan ahay tə mbəɗahan atan apan, ta wa: «Kula, ɗowan saa njaɗ sa ja 'am kawa ɗowan ata nà, ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisa ahay tə cəce patan wa: «Kwanay a ɗukwen kə pərihen anan azar anà mungwalay anahan aya re kələɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ɗowan inde kərtek à wulen sə məceɗ a mənuko ahay wa, kə̀ ɗəfak nga pə ɗowan ata nà, inde ɗaw? Kabay à wulen sə Farisa ahay wa nà, inde kələɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɗo sa ɗaf apan nga ataya nà, ɗo kəriya aya awan, anga tinen ta san Tawrita bay. Aday ɗukwen tinen mə tahasl aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Natiya, ɗowan a inde tə ngaman Nikodemus, winen Farisa ahay. Winen nà, ɗowan a sa zla à man ana Yesu sə luvon ata awan. Winen a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Tawrita ana mənuko kə̀ varak uko cəveɗ sa gan sariya anà ɗo matanan bay. Aɗəka bay, ɗi lah nà, sə sləne anan 'am anahan ahay. Aday ɗi saa san 'am anahan tə way anahan sa ga ahay nà, na!» ");
INSERT INTO mqbNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tə mbəɗahan apan, ta wa: «Iken ɗukwen ka nay à Galile wa ɗaw? Jinge Deftere, ki tan à nga à man inde, ɗo maja'am a Mbərom kwa kərtek a nay à Galile wa nà, ibay asanaw!»  ");
INSERT INTO mqbNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Natiya awan, kuwaya a zla way anahan agay, ");
INSERT INTO mqbNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","əna Yesu nà, a zla way anahan à ɓəzlom sə Ulivet. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sidew a awan kutok, Yesu a wule ù doh sə mazlaɓ a Mbərom asa. Ɗo ahay fok tə halan nga pə cakay. A njahay kutok, a dazlan sə ɗakan atan anan way. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Miter sə Tawrita ahay pi zek tə Farisa ahay ta nay anan ahay uwar a inde, ta ban anan tinen pi zek tu ɗo. Tə tavay anan pa 'am sə ɗo ahay, ");
INSERT INTO mqbNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aday ta jan anà Yesu kutok: «Miter, mə bənay ahay uwar a həna, winen apan i ga mədigweɗ, bina, tə nahak tu ɗo. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","À Tawrita a mənuko inde, Musa a ja nà, uwar kawa winen a anan nà, mâ tar anan tu kon, aday â mac. Aday iken ka ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ta ja matanan nà, aday tâ njaɗ apan cəveɗ sa ban anan pə kwande. Kak kà jak atan awan a nà, ti mba apan sa gan apan sariya. Yesu a kuɗœk, a vinde awan a à məndak ta wan sə alay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tinen ite, hwiya tə pərahan azar sə cəce way ahay. Yesu a cakaf nga pa nga mburom, a jan atan: «Ɗowan a inde à wulen a kwanay, kula kà gak ines bay cəna, â lah sə taran kon awan…» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A kuɗœk asa, a vinde awan a à məndak maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ɗo sə bənan ahay uwar ataya tə sləne 'am ata cəna, ta zla way a tinen fok suɗuk suɗuk suɗuk, ɗo məceɗ aya ta lah pa 'am. Mə mbəɗek a à man ata awan nà, Yesu tə uwar ata coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu a cakaf nga asa, a cəce panan: «Uwar, ɗo ataya tinen ahaw? Ɗowan sa ban iken tə sariya inde kwa kərtek ibay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Uwar ata a mbəɗahan apan, a wa: «Mazar, ɗowan inde kərtek ibay!» Yesu a mbəɗahan apan kutok: «Zla way anak, kâ sa ga ines sabay. Nen ɗukwen ni gak sariya bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu a dazlan sa jan 'am anà ɗo ahay maza awan, a wa: «Nen nà, jiyjay sə dəvan anà daliyugo. Kuwaya ɗowan kə̀ pərahak uno azar nà, i njaɗ jiyjay sa var sifa, winen i zla à luvon inde itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisa ahay ta jan: «Iken ka gan side anà nga anak ata nà, ata side lele kutok ɗaw? Wita nà, 'am anak kə̀ tərak kəriya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu a mbəɗahan atan apan: «Kwa â ga həna, nen nə siden anà nga uno, side uno nà, lele awan hwiya, anga na san man uno sa nay ahay wa ata zle, na san man uno saa zla ata zle re. Əna kwanay nə kə sənen man uno sa nay ahay wa ata bay, aday kə sənen man uno saa zla ata bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kwanay aday nà, ki gen anan sariya anà ɗo nà, sa zlan à nga anà iɗe su ɗo zənzen awan. Nen ni gan sariya anà ɗowan itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kwa nâ gan sariya anà ɗowan a ɗukwen, sariya uno cəna, hwiya winen lele awan. Lele awan, anga na ga sariya awan nə taayak uno a bay. Manay maya tə Bəbay uno a sə slənay ahay nen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Way inde mə vinde a à Deftere sə Tawrita a kwanay, a wa: Kak ɗo ahay cew ta gak side pə way kərtek a nà, side a tinen ata nà, lele, aday ɗiɗem a acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nen na gan side anà nga uno. Bəbay uno a sə slənay ahay nen ata ɗukwen winen apan i ga upo side re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Natiya awan asa tə cəce panan: «Bəbay anak a nà, winen ahaw?» Yesu a mbəɗahan atan apan, a wa: «Kə sənen nen bay. Anga nan, ki sənen Bəbay uno bay re. Abay kə̂ sənen nen nà, ki sənen bəbay uno awan re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu a ja 'am anaya nà, winen ù doh sə mazlaɓ a Mbərom. Winen mə tavay a à man sə kukwar sa pak dala. Əna ɗowan kə bənak anan bay, anga alay anahan a kà slak fan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Asa, Yesu a jan atan: «Nen ni zla way uno. Kwanay ite ki pəlen nen, əna ki məcen à atahasl ana kwanay inde. À man uno saa zla ata nà, ki mben apan sa zla itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahuda ahay tə cəce pi zek a tinen ahay wa, ta wa: «A wa: “Ki mben apan sa zla à man uno saa zla ata bay.” I zla saa vaɗ a nga anahan kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu a mbəɗahan atan apan: «Kwanay ki nen nà, à dəlon wa, pə daliyugo a anan. Əna nen na nay à mburom wa. Kwanay ɗo sə daliyugo a anan, nen nə ɗo sə daliyugo a anan itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Anga nan ɓa na jak ikwen: “Ki məcen ì ines ana kwanay ahay inde.” Kak kə ɗəfen nga pi nen, nen nə nen, bay nà, ki məcen ì ines ana kwanay ahay inde acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tə cəce panan kutok: «Iken nə wayaw?» Yesu a mbəɗahan atan apan, a wa: «Nen nà, ɗo nen sa jak ikwen apan kurre pə dəlen a wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Way ahay inde bayan a təɗe ni ja pikwen aday. Way ahay inde bayan a təɗe ni gak ikwen apan sariya re. Əna ɗo sə slənay ahay nen nà, ɗo ɗiɗem awan. Nen apan ni ɗakan anan anà ɗo sə daliyugo ahay nà, way kawa nen sə sləney ahay pə winen a wa ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tə sənak sa jəka, a jan atan nə pə Bəbay anahan Mbərom nà, ta san bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Anga nan Yesu a jan atan kutok: «Azanan kə liwen nen à mburom, nen Wan su Ɗo nà, ki i sənen, nen nà, nen kutok. Ki sənen nà, na ga awan inde ta nga uno nà, ibay. Əna na jak ikwen nà, way ana Bəbay uno sə tətuko anan ahay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɗo sə slənay ahay nen ata, winen ti nen. Kə̀ mbəsakak nen taayak uno bay, anga na ga nə hwiya way sa zlan à nga.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","À alay ana Yesu sa ja 'am ataya nà, ɗo ahay bayak a tə ɗəfak apan nga. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu a dazlan, a jan 'am anà Yahuda aya aday tinen nà, tə ɗəfak apan nga ataya awan: «Kak kə ɗəfen apan nga pə way nen sa jak ikwen ataya nà, ata ki təren njavar uno ahay tə ɗiɗem aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Natiya ki sənen ɗiɗem sə way ahay aday i i təmay ahay kwanay à ɓile ahay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tinen ite tə mbəɗahan apan, ta wa: «Manay awan aday nà, ɓile ahay kələɗaw? Na wa manay nà, wan ana Ibərahima ahay kutok nà, mə təra ɓile aya asa aday nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu a jan atan asa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya kà gak ines nà, ines i lavan nga, anga winen ɓile anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɗo ɓile a nà, i njahay pi zek tu ɗo su doh ahay hwiya itəbay. Aya əna, wan sə agay, winen mə baslay a nà, à wulen su ɗo su doh aya hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kak nen, Wan a Mbərom, nə təmak ahay kwanay à ɓile ata wa nà, kwanay ɓile ahay sabay tə ɗiɗem awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aday nà, na san kwanay biɗaw? Kwanay zaav ana Ibərahima ahay. Aday həna a nak ikwen sa vaɗ nen nà, anga kə təmihen 'am uno ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nen apan ni ja nà, way kawa ana Bəbay uno sə ɗuko anan, aday kwanay ɗukwen ki gen nà, way mbala a bəbay a kwanay a re cite.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tə mbəɗahan apan anà Yesu kutok, ta wa: «Bəbay a manay nà, Ibərahima.» Yesu a jan atan asa: «Abay kə̂ təren zaav ana Ibərahima ahay tə ɗiɗem a nà, ki gen mer su way anahan aya awan kawa anahan sa taa ga ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nen na jak ikwen anan ɗiɗem sə way nen sə slənay ahay pə cakay ana Mbərom wa ata awan. Aday kwanay apan ki pəlen sa vaɗ nen məsinde awan hwiya. Ibərahima nà, kà gak matanan itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kwanay apan ki gen nə mer su way ana bəbay a kwanay ahay.» Ɗo ataya tə mbəɗahan apan: «Manay nə məgəjara aya bay, anga bəbay a manay inde kərtek nà, winen Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu a jan atan: «Matana bay. Kak abay tə ɗiɗem a kwanay wan ana Mbərom ahay nà, ki pəlen nen lele, anga na nay ahay nə pə cakay anahan a wa. Na nay ahay aday nà, ta nga uno a ite bay, Mbərom a sə slənay ahay nen. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kə sənen way nen sa jak ikwen ata bay nà, angamaw? Anga a nak ikwen sa pak sləmay pa 'am uno bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","«Bəbay ana kwanay nà, Fakalaw. A nak ikwen sa ga mer su way a bəbay a kwanay a sə pəlay. Winen nə ɗo sa vaɗ nga su ɗo kurre way anahan. Aday kula kà jak ɗiɗem itəbay, anga abay ɗiɗem a inde à winen ibay wanahan. A gaɗ mungwalay nà, ata way sə mivel anahan ɗiɗem a ite. Anga winen mungwalay awan, bəbay sə mungwalay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","«Əna nen nà, na ja ɗukwen ɗiɗem. Kə təmihen 'am uno bay nà, anga nan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Waya à wulen a kwanay i mba apan sa jəka nen, Yesu, na gak ines anaw? Ibay! Aday kak na jak ikwen nə ɗiɗem sa 'am ahay nà, kə təmihen anan bay angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɗo a Mbərom nà, i pak sləmay pa 'am ana Mbərom ahay. Kwanay aɗəka nà, ɗo a Mbərom ahay bay. Anga nan, kə pəken sləmay pa 'am uno aday sə ɗəfan apan bay nà, na.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aday bahay sə Yahuda ahay ta jan anà Yesu, ta wa: «Ma jak, iken nà, Samariya ahay, aday ɗukwen nga a vawak asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu a mbəɗahan atan apan, a wa: «Nga a vuwo itəbay. Nen nə həran anan nga anà Mbərom, aday kwanay ki men nga sə təra nen à məndak. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nə pəlak anan məduwen anà nga uno bay. Ɗo inde sə pəlo məduwen, winen nə ɗo sa ga sariya. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya ɗowan a kə̀ ɗəfak anan apan anà 'am uno ahay cəna, i mac itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tinen, bahay sə Yahuda ahay ta jan kutok: «Həna nà, ma san zle, nga nà, a vawak tə ɗiɗem awan. Ibərahima kə̀ məcak! Ɗo maja'am a Mbərom ahay tə məcak. Aday ka wa: “Kuwaya ɗowan kə̀ ɗəfak anan apan anà 'am uno cəna, i mac itəbay.” ");
INSERT INTO mqbNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bije a manay Ibərahima aɗəka nə kə̀ məcak, aday iken kə zalay anan ɗaw? Ɗo maja'am a Mbərom ahay ɗukwen tə məcak, aday… ka ca pa nga anak nà, iken waya kəlanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu a mbəɗahan atan apan, a wa: «Kak nə həran nga anà zek uno nà, ahar nga uno kəriya awan. Ɗowan a kwanay sə ngimen anan Mbərom a kwanay ata nà, winen Bəbay uno. Sə həro nga ata nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kwanay kə sənen Mbərom bay. Nen nà, na san a zle. Na sak a jəka na san anan bay nà, ata nə tərak ɗo kərtek a tə kwanay, ɗo sə mungwalay ahay. Aya əna, na san anan zle, nə ɗəfan apan aɗəka nà, anà 'am anahan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ibərahima, bije a kwanay ata nà, kə̀ taslak mivel anga saa canan anà luvon sə wahay uno. Kə̀ pəlak, kə̀ njaɗak sə taslay mivel, anga kə̀ canak anan anà luvon ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahuda ataya ta ma nga sə buwtay apan, ta wa: «Kak iken a ka gak ava kwa kuro ɗara bay cəna, kə canak anan anà Ibərahima ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu a mbəɗahan atan apan kutok, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Tə wahak Ibərahima fan bay ata, nen nà, nen inde coy.» ");
INSERT INTO mqbNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ɗo ataya tə sləne 'am ata cəna, ta ra kon sa tar anan. Yesu a ɗer zek, a gəɗay ahay səmaɗ ù doh sə mazlaɓ a Mbərom wa, a zla way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Natiya, Yesu winen apan i zla way anahan à man maza awan nà, a canan anà ɗowan a inde, mə wahay à kutov wa hurof awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Njavar anahan ahay ta jan, ta wa: «Miter, tə wahay anan ɗowan a anan hurof a nà, angamaw? Anga atahasl ana waya kərtek a anaw? Ines anahan a ɗaw, anga atahasl ana atə bəbay anahan ta may anahan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu a mbəɗahan atan apan, a wa: «Tə wahay anan hurof a nà, anga atahasl anahan bay, anga atahasl mbala ana bəbay anahan ahay bay re. Winen mə wahay a hurof a nà, aday məgala ana Mbərom â kay ahay zek pə iɗe sə ɗo ahay tə winen. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Həna nà, man i pec mba ata nà, guko mer su way mbala ana ɗo sə slənay ahay apan nen ata awan. Luvon i saa ga bine siwaw nà, guko mer su way aday, bina ɗowan saa mba apan sa ga mer su way à luvon inde nà, inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","À alay a nen pə daliyugo a anan mba ata nà, nen nə jiyjay sə dəvan à daliyugo.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pə dəɓa anahan sa ja 'am ata wa nà, Yesu a təfe məne à məndak, a laɓ anan yugo, a slərɓan anan pə iɗe anà hurof ata awan, aday a jan: ");
INSERT INTO mqbNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","«Zla, kaa banay iɗe a dəlov sə ngaman Silowam ata wa.» Silowam ata nà, ta 'am sə Yahuda ahay, kawa sa ja bina maw nà: «ma slan awan». Hurof ata a zla à Silowam, a banay anan iɗe anahan. A may ahay nà, a canan iɗe zle coy kweler kweler. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ɗo sə məsudoh anahan ahay, pi zek tu ɗo sa taa canan winen apan i rəke way ataya, ta wa: «Na wa, ɗo sa taa njahay sə rəke way ata ba?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɗo ahay ngal ta wa: «Winen awan dəge?» Ɗo maza aya ite, ta wa: «A'ay, winen bay. Ɗo hinen, ɗo sa ga minje tə winen.» Winen a kutok a wa: «A'ay, nen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tə dazlan, tə cəce panan: «Iɗe anak ahay tə təɓa nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A mbəɗahan atan apan, a wa: «Ɗowan a inde tə ngaman Yesu, a laɓ yugo mənjœk, a slərɓo anan iɗe, aday u jo: “Zla à dəlov sə ngaman Silowam ata awan, ka saa banay iɗe.” Na zla, nə banay iɗe, iɗe uno ahay tə təɓa ngurret kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tə cəce panan: «Ɗowan ata həna, winen ahaw?» A mbəɗahan atan apan, a wa: «Na san bay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Natiya, tə lagay anan ɗowan a iɗe anahan ahay sə təɓa ata pə cakay sə Farisa ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aya əna, pac ana Yesu sa laɓ yugo, sə slərɓan anan iɗe, aday sə təɓan anan iɗe anà hurof ata nà, luvon sa man uda awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Anga nan, Farisa ahay tə cəce pə ɗowan ata wa, ta wa: «Ka njaɗ sa ca iɗe həna nà, kəkəmaw?» Ɗowan ata a mbəɗahan atan apan, a wa: «Ɗowan ata a slərɓo duɗo pə iɗe mənjœk, na zla, nə banay anan, iɗe uno ahay tə təɓa kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ɗo ahay ngal à wulen sə Farisa ahay inde ta ja, ta wa: «Ɗo sa ga way matanan ata nà, a nay pə cakay a Mbərom wa bay, anga winen awan aday ɗukwen a bənan bitem anà luvon sa man uda awan bay.» Ɗo maza aya ite ɗukwen ta wa: «Kəkəmaw? Kak ɗowan a nə ɗo sə atahasl nà, i mba apan sa ga masuwayan sə way matanan kələɗaw?» Tə gəzla zek, anga mawrasan kà zlak atan à mivel inde. Tə japak 'am pə kərtek a sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisa ahay tə cəce pə ɗowan a iɗe anahan sə təɓa ata wa asa, ta jan: «Bayak way inde kərtek, anga kə̀ təɓak anak anan iɗe. Iken a, ka ja nə maw?» Ɗowan ata a mbəɗahan atan apan, a wa: «Nen na ja nà: Winen nə ɗo maja'am a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aday məceɗ sə Yahuda ahay nà, tə ɗəfak apan nga sa jəka abay winen mə wahay a nə hurof awan bay. Anga nan, tə ngaman anà atə bəbay anahan ta may anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tə cəce patan wa: «Həna anan nà, wan ana kwanay ɗaw? Kwanay kə sənen zle winen mə wahay a nà, hurof awan ɗaw? Aday a canan iɗe həna kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Atə bəbay ta may anahan a tə mbəɗahan atan apan, ta wa: «Ma san a zle, winen wan a manay, aday winen mə wahay a nə hurof a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Əna ma san sa jəka iɗe anahan a təɓa nə kəkəmaw nà, ma san bay, aday ma san ɗowan a sə təɓan anan iɗe ata bay re. Əna winen a aday nà, kà slak sə mbəɗahan pa 'am anà nga anahan asanaw! Cəcihen panan!» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Atə bəbay ta may anahan ata, ta ja matanan nà, aday Yahuda ahay tâ njaɗ patan alay sa 'am sabay. Bina, Yahuda ahay ɓa ta jak à wulen a tinen inde, ɗowan a kə̀ təmahak Yesu nə Almasihu nà, ata aday ti razl anan à wulen a tinen wa, aday ù doh sə wazay ahay wa re. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Natiya, atə bəbay ta may a ɗowan ata ta wa: «Winen awan aday ɗukwen kà slak sə mbəɗahan pa 'am anà nga anahan asanaw!» nà, anga nan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisa ahay tə ngaman ayak anà ɗowan iɗe anahan sə təɓa ata awan, maza awan. Ta jan: «Mbərom a slənek anan! Ja 'am ɗiɗek awan! Manay nà, ma san zle, ɗowan a sə təɓak anan iɗe ata nə, ɗo sə atahasl.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","A mbəɗahan atan apan, a wa: «Nen nà, na san itəbay, əna na san way inde kərtek nà: Abay nen hurof awan, aday həna, nə canan iɗe zle. Bay nà, winen ɗo sə atahasl, kabay winen ɗo sə atahasl bay nà, wita nà, na san bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tə cəce panan tə cəveɗ maza awan, ta wa: «A gak aday nə maw? A təɓak anan iɗe a nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A mbəɗahan atan apan asa, a wa: «Na jak ikwen anan kurre, a nak ikwen sə sləne anan bay. Aday angama, a nak ikwen nə̂ mənahan asa anaw? Kabay kwanay ɗukwen, a nak ikwen sə pərahan azar aday sə təra njavar anahan ahay kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tə gənahan, ta jan: «Njavar anahan aɗəka nà, iken aday bina. Manay nà, mbala ana Musa ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma san zle, Mbərom kà jak anan ahay 'am anà Musa. Əna ɗowan anak ata nà, ma san winen nə mayanaw bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A mbəɗahan atan apan, a wa: «Iya, cəkəbay, a ga masuwayan nà, na. Winen mayanaw nà, kə sənen bay. Əna, iɗe uno nà, kə̀ təɓak uno anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ɗa san zle, mənuko fok, Mbərom nà, i təmahan anan 'am anà ɗo sə atahasl kula bay. A təmahan a nà, 'am ana ɗo sə həran nga aday a ga way sa zlan à nga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kula, kwa sə dazlan anà daliyugo nà, ɗə slənek ɗo kə̀ təɓak anan anan iɗe anà ɗo aday winen mə wahay a nə hurof a ɗaw? Ibay! ");
INSERT INTO mqbNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kabay, kak ɗowan a anan a nay ahay nə pə cakay ana Mbərom wa bay nà, i mba apan sa ga mer su way kawa həna anan bay asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ta jan, ta wa: «Zek anak a fok mə wahay a à atahasl inde kutok nà, a nak sə ɗakan umo anan nə maw?» Coy, tə rəzlay anan à wulen a tinen wa, aday ù doh sə wazay ahay wa re. ");
INSERT INTO mqbNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu a sləne sa jəka Yahuda ahay tə rəzlak anan ɗowan ata à wulen a tinen wa cəna, a zla, a tan à nga, a cəce panan 'am, a wa: «Kə ɗəfak nga pə Wan su Ɗo ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A mbəɗahan apan, a wa: «Wan ada, ɗuko anan winen wayaw, aday ni ɗaf apan nga!» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu a jan, a wa: «Iken apan ki ca apan sa jak 'am ata nà, winen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","A dukwen gərmec ù vo anà Yesu, a wa: «Ba Məduwen, nə ɗəfak apak nga.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu a jan kutok, a wa: «Nen, na nay ahay pə daliyugo a anan nə saa ga sariya sə kataɓ anan ɗo ahay: Hurof ahay tâ ca iɗe ite; Ɗo sa ca iɗe ahay ɗukwen tə̂ hurof cite kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ɗo à wulen sə Farisa ahay inde, tinen pə cakay ana Yesu ata, tə sləne 'am ata cəna, tə cəce panan, ta wa: «Manay ɗukwen hurof aya ite ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu a mbəɗahan atan apan: «Ki gen makwakwa abay hurof aya nà, atahasl inde pikwen ibay. Əna, ki jen nə “Manay mə canan iɗe zle.” Anga nan atahasl a kwanay inde pikwen hwiya.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu a ja 'am sə jike, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya, ɗowan a winen kà zlak tə məsudoh pə təman ahay bay, əna latœk, a ján ta nga sa jal, winen nə ɗo sə akar, ɗukwen winen ɗo sə ngəzar ɗo. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aday ɗo sa zla à jal inde, pə cakay sə təman ahay tə məsudoh nà, winen nə ɗo sə jugwar təman ahay way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","«Iɗe kə̀ cəɗek cəna, ɗo sə jugwar way i zla à man sə təman ahay. Ɗo sa ba pə təman ahay sə luvon, i təɓan ayak wa. Təman ahay ti sləne dungo ana ɗo sə jugwar way, aday winen i ngaman anà təman anahan ahay tə sləmay tə sləmay. I zla atan pə dədan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kə̀ mbakak atan uho nà, i lahan atan pa 'am. Təman ahay ti pərahan azar, anga ta san dungo anahan a zle. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Əna təman ahay nà, ti pərahan azar anà ɗo aday ta san anan bay ata bay. Aɗəka bay, ti haw bugol, anga ta san dungo anahan a bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu a jan atan 'am sə jike a anan, əna tə sənak anan a ja pa maw bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu a pərahan azar anà 'am anahan, ta sa jəka: «Nen apan ni jak ikwen tə ɗiɗem a həna: Nen nà, məsudoh sa jal sə təman ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɗo sə luho ahay ataya fok, tinen ɗo sə akar ahay, ɗo sə ngəzar ɗo ahay. Aday təman ahay tə slənek atan anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nen nà, məsudoh sa jal. Kuwaya ɗowan a kà zlak à jal inde ti nen nə i tam. I njaɗ sa zla à jal inde, i njaɗ sa nay uho, aday i njaɗ way sa pa re. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ɗo sə akar nà, a nay ahay saa kəra way ahay ca, saa gəɗan dungo anà gənaw ahay, aday saa lize anan way ahay. Nen, na nay ahay aday ɗo ahay tâ njaɗ sifa, tâ njaɗ anan nə tə dedengəlen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Nen nà, ɗo sə jugwar təman ahay lele awan. Ɗo sə jugwar way lele a nà, a var anan sifa anahan tə alay anahan awan, anga təman anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Aya əna ɗo sə jugwar way anga magwagway cəna, təman aya nə si zek anahan ahay bay. Anga nan, kə̀ canak anan anà kəla kiɓe cəna, i haw, i mbəsak anan təman ahay. Aday, kəla kiɓe ɗukwen i ban a təman ahay, i tan atan 'am kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Natiya awan, winen a i haw, anga a gan may jiga nà, anà magwagway anahan, bina anà təman ahay itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«Nen nà, ɗo sə jugwar təman ahay lele awan. Bəbay uno a san nen zle, nen na san Bəbay uno zle re. Matanan, nen na san təman uno ahay zle, aday təman uno ahay ɗukwen ta san nen zle. Nen ni mac anga təman uno ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Təman uno maza aya inde, tinen à jal a anan inde itəbay. Sumor a nà, ni nay atan ahay à jal a anan inde re. Tinen ɗukwen ti təma 'am uno, ti japay pə kərtek a tə təman sa jal ahay, aday ɗo sə jugwar atan ɗukwen kərtek re. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Bəbay a pəlay nen nà, anga ni var anan sifa uno, aday ni njaɗ anan way uno maza awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɗowan saa gəɓa anan sifa uno nà, ibay. Nen a ni var anan tə alay uno awan. Ni mba apan sa var anan, ni mba apan sa njaɗ anan way uno re. A nan anà Bəbay uno, nâ ga nə matanan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Anga 'am ana Yesu ata awan, mawrasan a zlan à mivel inde anà Yahuda ahay asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɗo ahay bayak a ta wa: «Setene inde anan à nga, nga a vawan. Kutok nà, kə pəlen sə sləne 'am anahan nə angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ɗo maza aya ite ta wa: «Ɗo tə setene à nga inde nà, i ja 'am matanan bay. A ga pə kwanay nà, setene i njaɗ sə təɓan anan iɗe anà ɗo hurof a ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Həna nà, alay sa maɗ, aday à Urəsalima nà, alay sə azar uko sə bayak pa sa gan nga anà doh sə mazlaɓ a Mbərom ata kà slak. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu a zla ù doh ata awan, winen apan i bar ù vo galak sə ngaman galak a Sulimanu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahuda ahay ta nay, ta van nga tew, ta jan: «Kak iken nə Almasihu cukutok nà, ɗakan umo anan tə ɗiɗek a kwa. Manay apan mi ba hwiya ata nà, mi i man uda nə siwaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu a mbəɗahan atan apan, a wa: «Ɓa na jak ikwen anan asanaw, əna kə ɗəfen upo nga bay. Mer su way uno sa ga tə gədan ana Bəbay uno Mbərom ataya nà, ta slak sa ja 'am pa nga uno wa ɗa. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kə ɗəfen upo nga bay nà, anga kwanay nə təman uno ahay bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","«Təman uno ahay nà, tə sləne dungo sa 'am uno zle, aday na san atan lele re. Tinen apan ti pəruho azar. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ni varan atan sifa sa ndav bay ata awan, natiya awan ti mac itəbay. Ɗowan saa ngəzar atan à alay uno wa ɗukwen, ibay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bəbay uno sə vuro atan ata, winen a zalan məgala anà way ahay fok. Anga nan, ɗowan saa ngəzar atan à alay a Bəbay uno a wa ɗukwen ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nen tə Bəbay uno ata nə manay kərtek.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bahay sə Yahuda ahay tə sləne 'am ata cəna, ta ma nga sa ra kon à alay inde miza awan, aday sa tar anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Anga nan, Yesu a jan atan: «Na gak mer su way ahay lele aya bayan a pa 'am ana kwanay tə məgala ana Bəbay uno. Ki tiren nen həna gəngaf gəngaf bine siwaw nà, pi mer su way wura kərtek a anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bahay sə Yahuda ahay tə mbəɗahan apan, ta wa: «A nan umo sa tar iken nà, anga mer su way anak lele aya bay, əna anga kə jənak anan pa 'am anà Mbərom. Iken nə ɗo zənzen awan, aday a nak sə təra anan nga anak həna, Mbərom awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu a mbəɗahan atan apan: «Mə vinde à Deftere a kwanay inde, Mbərom a ja nà: “Kwanay aday nà, mbərom ahay.” ");
INSERT INTO mqbNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɗa san zle, way ana Deftere a Mbərom ma ja nà, a mbacay wa zek bay. Ɗo sə sləne 'am ataya nà, Mbərom a ngaman atan nə mbərom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nen nà, Mbərom u go nga, aday a slənay nen pə daliyugo. Ki jen nà, nə jənak anan pa 'am anà Mbərom nà, kəkəmaw? Anga na wa, nen wan anahan ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kak na ga nə mer su way ana Bəbay uno Mbərom bay nà, kə̂ ɗəfen upo nga bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aday kak na ga nà, mer su way anahan tə ɗiɗem a cəna, ɗəfen nga pi mer su way uno. Kwa kə ɗəfen nga pi nen bay nà, ɗəfen nga pi mer su way uno a kwa. Anga aday, kə̂ sənen anan hwiya, Bəbay uno nà, manay kərtek awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Asa bahay sə Yahuda ahay tə pəlay sa ban anan, tə njaɗak anan bay, kə̀ təmak patan wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pə dəɓa anahan a wa, Yesu a zla way anahan pə day uho sə zlinder sə Urdon, a njahay way anahan à man ana Yuhana sa taa ga baptisma ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɗo ahay ta nay pə cakay anahan bayan a awan. Ta ja, ta wa: «Yuhana nà, kula kà gak masuwayan ahay itəbay, əna 'am anahan a sa ja pə ɗowan a anan nà, kə̀ tərak ɗiɗem aya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɗo maza aya bayan a à man ata awan, tinen tə ɗəfak apan nga. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ɗowan a inde tə ngaman Lazarus, winen ɗəvac awan. Ɗowan ata nà, winen ù kon sə ngaman Baytiniya ata awan. Mərak anahan ahay inde dəna aya cew ɗukwen, tinen à man ata re, atə Marta tə Mariyama. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariyama aday nà, uwar saa mbəɗan amar pə saray anà Yesu aday sə takaɗ panan tə sibœk sa nga anahan ata awan. Lazarus a ɗəvac ata nà, mərak anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Atə Marta tə Mariyama ta slan ɗo saa jan anà Yesu nà: «Ba Məduwen, car anak Lazarus nə winen lelibay, ɗəvac a gan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu a sləne 'am ata cəna, a wa: «Ɗəvac ana Lazarus nà, ɗəvac sa mac anan bay. Əna ɗəvac ata i ka anan məgala ana Mbərom, aday mazlaɓ uno re, nen Wan a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Atə Marta tə Mariyama tatə Lazarus nà, Yesu a pəlay atan nə lele. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aday cəkəbay, anahan sə sləne Lazarus ɗəvac awan ata nà, kə̀ njahak à man ata luvon ahay cew asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pə dəɓa wa, a jan anà njavar anahan ahay, a wa: «Muko pə daliyugo sə Yahudiya.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tinen ta jan, ta wa: «Miter, Yahuda ahay tə pəlay abay sa tar iken tu kon nə kwakwa bay asanaw? Həna, a nak sa ma à man ata re ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu a mbəɗahan atan apan, a wa: «Pac a dav nà, hway biɗaw? Aday kak ɗo winen apan i bar à jiyjay anahan a inde nà, saray i dəcan ɗaw? Saray i dəcan bay, anga a canan iɗe zle lele, winen à jiyjay sa dav pə daliyugo a anan inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Aya əna, ɗo sa bar à luvon inde ite nà, saray i dəcan, i slahay təktek, anga jiyjay inde sə luvon itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pə dəɓa sa 'am ata wa asa, Yesu a jan atan: «Car a mənuko Lazarus ata kə̀ njəkak ahan. Əna ni zla saa pəɗəkey anan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Njavar anahan ahay tə mbəɗahan apan, ta wa: «Ba Məduwen, kak a njak ahan ata nà, i mbar asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Abay a nan anà Yesu sa ja nà: Lazarus kə̀ məcak! Əna pə njavar anahan ahay nà, a jan atan nə 'am sə ahan acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu a jan atan anan ngəlarak kutok, a wa: «Lazarus kə̀ məcak! ");
INSERT INTO mqbNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Əna na zlak à man ata bay nà, anga kwanay. Natiya, ataslay mivel uno inde, anga tə way a saa təra ata nà, kwanay ki i njiɗen sa ɗaf upo nga kutok. Həna nà, zluko pə cakay ana Lazarus awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas, ɗowan a tə ngaman Didimus anga winen muwsa ata, a jan anà azar sə njavar ana Yesu aya, a wa: «Mənuko ɗukwen zluko saa mac tatə miter a mənuko.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Natiya, Yesu a dəzle à Baytiniya cəna, a sləne tə zəɓak anan Lazarus à məke kà gak luvon ahay fuɗo coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Baytiniya a aday nà, bəse tə Urəsalima i ga nà, way sə kilomiter ahay maakan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahuda ahay bayan a ta nak à məsinde ana Lazarus. Ti i bənan mivel anà mərak anahan ahay, atə Marta tə Mariyama. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ana Marta sə sləne sa jəka Yesu kà nak ata nà, a slabak, a zla à man anahan pə cəveɗ. Əna Mariyama nà, winen a njahay agay. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta a jan anà Yesu: «Abay kâ ga inde à man a anan nà, mərak uno i mac bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Həna ɗukwen na san zle, Mbərom i varak way kawa ananak saa cəce panan ata fok re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu a mbəɗahan apan, a wa: «Mərak anak i slabakay à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta a wa: «Na san zle, pa pac sa ndav anan daliyugo nà, i i slabakay ahay tə ɗo ahay fok à məke wa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu a jan: «Nen nà, ɗo sə slabakay anan ahay ɗo ma mac aya à məke wa, ɗo sə varan atan sifa re. Kuwaya, ɗowan a kə̀ ɗəfak upo nga nà, i njahay uho tə sifa awan, kwa kə̀ məcak dəp nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kuwaya, ɗowan a tə sifa mba cəna, kə̀ ɗəfak nga pi nen a nà, i mac bay. Iken, kə təmahak 'am a anan ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta a mbəɗa apan, a wa: «Ayaw, Ba Məduwen, nə ɗəfak apak nga. Iken nà, Almasihu, Wan a Mbərom a sa nay ahay pə daliyugo ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pə dəɓa ana Marta sa ja 'am ata wa nà, a zla pə cakay ana mərak anahan Mariyama, a jan tə sœksœk awan: «Miter kà nak, winen apan i ngamak!» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyama a sləne matanan cəna, a slabak hərom, a zla pə cakay ana Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu a aday nà, kə̀ dəzlek à wulen su doh bay. Winen à man a tinen sə zlangay tə Marta ata mba. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɗo a tinen mə njahay aya ù doh tatə Mariyama ata, tinen apan ti man a mivel ù doh. Tə canan winen sə slabak baram ata nà, tə pərahan azar. A ga patan nà, i zla saa yimay ahay pə jəvay wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyama a dəzley ahay pə cakay ana Yesu nà, a dukwen gərmec ù vo, a jan: «Ba Məduwen, kâ ga inde à man a anan aday nà, mərak uno i mac bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu a canan à Mariyama nà, winen apan i yam, aday Yahuda ahay sə pərahan ayak azar ataya ɗukwen tinen apan ti yam re. Anga nan, a slabakan anan mivel anà Yesu, a cəɓan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu a cəce: «Ki len anan ahaw?» Tə mbəɗahan apan, ta jan: «Miter, hayak, ca apan!» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Cəna, Yesu a pəkay iɗe sə ayam. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahuda ahay ta wa: «Cen apan, a pəlay anan Lazarus a re!» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aya əna ɗo azar aya ta wa: «Winen ɗo sə təɓan anan iɗe anà ɗowan a hurof ata awan. Abay winen â dəzley ahay à alay a Lazarus tə sifa mba ata nà, i mba apan sa mbar anan aday â mac bay, biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","A cəɓan anà Yesu maza asa, a zla pə jəvay. Jəvay a nà, mə tacay a tə bələlen. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Anga nan kutok, Yesu a wa: «Təɓen anan jəvay awan!» Marta a wa: «Ba Məduwen, i rəbas, anga kà gak həna luvon ahay fuɗo à məke inde.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu a mbəɗahan apan, a wa: «Na jak anak biɗaw? Kak kə ɗəfak upo nga nà, ki canan anà məgala sə mazlaɓ a Mbərom asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tə təɓa anan bələlen pə jəvay wa kutok. Yesu a ca iɗe à mburom, a wa: «Na gak ayak suse, Bəbay uno, anga kə slənek uno anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nen, na san zle, hwiya ki sləno anan. Əna na jak ayak nà, anga ɗo sa man a anaya tâ ɗaf apak nga, tâ san iken sə slənay ahay nen acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A ndav anan 'am anahan ata nà, a ja 'am tə məgalak a asa, a wa: «Lazarus, hayak uho!» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus, ɗowan a ma mac ata, a nay ahay uho, saray tə alay anahan aya tinen mə tuweɗ aya tə pətike. Iɗe anahan a ɗukwen mə tuweɗ a tə zana. Yesu a jan atan, a wa: «Pəsiken panan zana, aday â zla way anahan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yahuda a sa zlak ayak pə cakay ana Mariyama ataya, tə canan anà mer su way ana Yesu sa ga ata cəna, bayak a à wulen ana tinen wa tə ɗəfak nga pə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Aya əna, ɗo a azar aya ta zla pə cakay ana Farisa ahay saa ray ahay apan 'am anga mer su way anahan sa ga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Anga nan, Farisa ahay pi zek tə bahay sə gəɗan dungo anà way ahay tə ngaman anà məceɗ sə Yahuda azar aya, aday tə halay nga. Ta wa: «Ɗi ga həna nà, kəkəmaw? Anga ɗowan a anan winen apan i ga masuwayan sə way ahay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kak ɗa sak a mbəsak anan â ga mer su way matanan nà, ɗo ahay kəzlek ti ɗaf apan nga. Aday pə dəɓa anahan a wa kutok nà, Ruma ahay ti i ja à 'am ata inde. Ti mbəzlak uko anan doh sə mazlaɓ a Mbərom, aday ti tak uko 'am re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ɗo kərtek à wulen a tinen awan tə ngaman Kayafas, winen bahay nga su ɗo sə gəɗan dungo anà way pə viya ata awan. Winen a jan atan: «Kwanay kə sənen awan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Suwan ɗo kərtek â mac anga ɗo a kəzlek, tə ɗo ahay saa lize jiya nà, na. Matanan biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A ja 'am ataya nà, tə ndaraw si zek anahan a itəbay. Sə ɗakan anan 'am ata nà, Mbərom, anga tə viya ata nà, winen bahay nga su ɗo sə gəɗan dungo anà way ahay. Anga nan, a wa Yesu i sa mac anga Yahuda ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Əna Yesu i mac nà, anga Yahuda ahay ɗəkɗek bay. I mac nà, anga aday â halan nga anà wan a Mbərom ma ta 'am ataya, tə̂ njahay pə kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A ban pə luvon ata wa kutok nà, bahay sə Yahuda ahay tə dazlan sa ga wurwer sa vaɗ anan Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Anga nan, Yesu kà mbak apan sa bar lele à wulen sə Yahuda ahay sabay. A slabak à wulen su doh ata wa, a zla à man kiɓe. Natiya tə njahay à man ata tə njavar anahan ahay à wulen su doh sə ngaman Efərayim ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Azar uko sə Yahuda ahay sə ngaman azar uko sə Pasəka ata, i sla bəse. Anga nan, ɗo sə wulen su doh sə kiɓe ahay ta zla à Urəsalima saa lavay anan zek a tinen ahay à cəncan a inde kurre. ");
INSERT INTO mqbNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tə dəzley ahay à Urəsalima nà, tə pəlay anan Yesu. Tə halay nga ù doh sə mazlaɓ a Mbərom nà, tə cəce pi zek ahay wa, ta wa: «A ga pikwen nà, i nay ahay à azar uko ɗaw, i nay ahay bay?» ");
INSERT INTO mqbNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bahay sə gəɗan dungo anà way ahay, pi zek tə Farisa ahay ta ɓan 'am à wulen a tinen inde, ta wa: «Ɗowan a kə̀ sənak man a Yesu nà, â ɗakak uko anan aday ɗi ban anan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Natiya, a mbəsak luvon mbərka aday azar uko sə Pasəka i sla nà, Yesu a zla à Baytiniya, ù kon ana Lazarus, ɗowan a Yesu sə slabakay anan ahay à məke wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ta dan way sa pa anà Yesu à man ata awan, aday Marta a varan atan. Ɗo ahay inde bayak a pə tuwez ata awan, Lazarus ɗukwen winen inde re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","À man sa pa way nà, Mariyama a gəɓa amar sə wurde anahan sə dala bayak awan, a rəbas nə dun'a. A mbəɗan anan pə saray anà Yesu. Ta da amar ata aday nà, tə way sə ngaman nardi, i ga à dunguzlok sə amar inde. A mbəɗan anan pə saray lele nà, a takaɗ anan panan tə sibœk sa nga anahan. Doh ata fok a rəbas nə dun'a lele. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Njavar ana Yesu a inde kərtek à man ata awan, tə ngaman Yudas Iskariyot. Winen ɗo saa ga ɗaf pə Yesu ata awan. A canan anà way ana Mariyama sa ga ata nà, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Ta wa, abay tə̂ sukom anan way tə amar a anan nà, i ga dala sə dinar səkat maakan, aday ti var anan dala awan anà ɗo mətawak aya nà, ta gak way lele biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas a ja 'am ataya nà, anga aday a gan may sa man zek anà ɗo mətawak aya bay. Əna a ja matanan nà, anga winen aday nà, ɗo sa ban dala a tinen awan, aday a taa kəra panan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aya əna, Yesu a wa: «Mbəsiken anan uwar a anan, a lah anan upo nà, way a aday ti su go pac sa la nen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɗo mətawak aya nà, ti ga inde tə kwanay hwiya, əna nen ni ga inde tə kwanay hwiya itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Natiya Yahuda ahay bayak a tə sləne Yesu winen à Baytiniya nà, ta zla à man ata awan. Ta zla à man ata ɗukwen nà, anga Yesu cəna coy bay. Ta zla saa cay ahay pə Lazarus re, winen ɗowan a Yesu sə slabakay anan à məke wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Matana awan, Yahuda ahay bayan a tə mbəsakak sə pərahan azar anà pəra a tinen, tə pərahan azar bugol nà, anà Yesu, anga Lazarus. Anga nan kutok, bahay sə gəɗan dungo anà way ahay ɗukwen tə ɓanak 'am sa jəka ti vaɗ anan Lazarus à wulen ana tinen wa re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sidew a kutok, ɗo a sə halay nga anga azar uko sə Pasəka ataya, tə sləne Yesu winen apan i nay ahay à wulen su doh sə Urəsalima cəna, ");
INSERT INTO mqbNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tə ngərway alay sə gazlangaw ahay à alay inde. Ta zla saa zlangay tatə Yesu pə cəveɗ tə daslam ataya à alay inde. Ta zlah, ta wa: «Həren anan nga anà Mbərom! Mbərom â ɗaf alay sə mazlaɓ anahan pu ɗo saa nay tə sləmay anahan, bahay sə Isəra'ila ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu a njaɗ zungo a inde, a ján apan, a zla pə cəveɗ. A təra kawa ana Deftere sa ja ata awan. A wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ɗo sə Urəsalima ahay, kə̂ jəjiren bay. Bahay a kwanay winen apan i nay ahay həna, winen ma ján a pə zungo.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Njavar anahan ahay tə sənak 'am anan fan bay. Aday Yesu a zla à man sə mazlaɓ ana Mbərom nà, ta may anan ahay 'am ata à nga inde kutok. Ta san nà, Deftere a ja 'am ata nà, pə winen awan, aday pi mer su way a tinen sa ga anga winen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","À alay a Yesu sə ngaman ahay anà Lazarus uho, a slabakay anan à məke wa ata nà, ɗo ahay inde à man ata bayan awan. Ɗo ataya tə canak anan, aday tə təkəren 'am awan anà ɗo azar aya re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Natiya awan, ɗo ahay ta nay ahay bayan a, tə təma anan Yesu, anga tə sləne kà gak masuwayan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisa ahay ta jan ì zek a tinen aya awan, ta wa: «Cen apan, way a mənuko sa ga həna ata fok nə kə̀ varak uko magwagway bay, anga ɗo ahay fok tinen apan ti pərahan azar.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","À wulen sə ɗo ahay sa nay à man sə azar uko sə həran nga anà Mbərom ataya nà, Gərek ahay uda awan, ta nak re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ta zla pə cakay ana Filip, ɗo su kon sə Baytisada, pə daliyugo sə Galile ata awan. Ta jan, ta wa: «Wan ada, a nan umo sə canan anà Yesu.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ite, winen a zla pə cakay ana Andəre, a jan. Ta zla maya awan saa jan 'am ata anà Yesu. Tə dəzle cəna, ta jan, ");
INSERT INTO mqbNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","aday Yesu a mbəɗahan atan apan, a wa: «Alay a kà slak həna, nen Wan su Ɗo, ni ka anan mazlaɓ ana Mbərom sə vuro ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nen apan ni jak ikwen tə ɗiɗem a həna: Wan sa ndaw kə̀ slahak pə yugo aday kə̀ məcak bay cəna, i njahay nə hwiya wan sa ndaw kərtektəkke. Əna wan sa ndaw kà sak a slahay aday kə̀ məcak ite nà, i wasay bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kuwaya ɗowan a, a nan sifa anahan nà, i lize anan. Əna ɗowan a kà nak anan iɗe anà sifa anahan pə daliyugo nà, i tam anan, i njaɗ sifa sa ndav bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kuwaya, a nan à ɗowan a su go mer su way nà, â pəruho azar. Aday ɗo su go mer su way nà, â saa zla à man uno saa zla ata ite. Ɗo su go mer su way ì nen cəna, kuwaya, Bəbay uno ɗukwen i həran nga nà, anà winen.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu a ja, a wa: «Həna nà, mivel uno i ndəroɓ. Nâ jan anà Bəbay uno nà, awan a maw? Nâ jan nà, â tam nen à ɗəce a anan wa ɗaw? Aday ɗukwen na nay ahay pə daliyugo nà, sa sa ɗəce a anan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bəbay uno, ka anan mazlaɓ sə sləmay anak.» 'Am a ndəray ahay kwa à mburom wa, a wa: «Na kak anan mazlaɓ uno, aday ni ka anan maza re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ɗo a sa man ata aya tə sləne 'am ata nà, ta wa: «Mbərom sa dac!» Ɗo azar aya ite ta wa: «A'ay, maslay a Mbərom sa jan ahay 'am.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Əna zek a Yesu a, a jan atan, a wa: «Dungo ata a jay ahay 'am nà, anga nen bay, əna anga kwanay aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Həna nà, alay a Mbərom kà slak sa gan sariya anà ɗo sə daliyugo ahay. Mbərom i razl anan bahay sə daliyugo a anan həna. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Əna, ta sak a cakaf nen à mburom nà, ni gəɓak anan ayak ɗo ahay fok pə cakay uno awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu a ja 'am ata nà, anga sə ɗakay anan amac anahan i təra nə kəkəmaw ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Natiya, ɗo ahay ta jan: «Manay mə sləne à Deftere inde nà, Almasihu i nay, i ga inde hwiya. Ka ja, ka wa: Wan su Ɗo nà, ti cakaf anan à mburom nà, kəkəma asanaw? Wan su Ɗo aday nà, wita nà, wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu a mbəɗahan atan apan, a wa: «Jiyjay inde winen apan i dəvak ikwen mənjœk mba. Bəren à man sə iɗe jiyjay a anan tamak, anga luvon i sa ga bəse. Aday ɗo sa bar à luvon inde nà, a san man anahan a saa zla ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","À alay a jiyjay winen inde tə kwanay mba cəna, ɗəfen nga pə iɗe jiyjay, anga aday kə̂ təren ɗo sə iɗe jiyjay ahay.» Pə dəɓa sa 'am ata wa, Yesu a zla saa ɗer patan wa zek. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Natiya, kwa â ga nà, Yesu kà gak mer su way masuwayan aya bayak pa 'am a tinen dəp nà, Yahuda ahay tə ngəmak sa ɗaf nga pə Yesu bay hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Way ata a ga zek nà, anga aday 'am ana Ezaya, ɗo maja'am a Mbərom ata â təra. A ja, a wa: «Ba Məduwen, waya sa ɗaf nga pa 'am a manay anaw? Mbərom Fetek a kan anan ahay gədan anahan nà, à wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Matanan, ta mbak apan sa ɗaf apan nga bay, anga Ezaya ɗukwen kə̀ lahak apan, kà jak, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Mbərom kə̀ hurfok atan, anga aday tə̂ canan iɗe bay, kə̀ ɗəfak atan kurkwilen à sləmay, anga aday tə̂ sləne bay, tâ san bay. Bina, abay ti mbəɗahan lœn anà ines a tinen ahay, aday ni mbar atan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezaya a ja 'am ata nà, pə Yesu awan, anga kə̀ lahak sə canan anà mazlaɓ anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kwa tə winen ata təke, à wulen sə bahay sə Yahuda ahay wa ɗukwen, ɗo ahay inde bayak a tə ɗəfak nga pə Yesu. Əna tə ngəmak sə ɗakay anan pa 'am sə ɗo ahay fok bay, anga tə jəjaran anà Farisa ahay, tâ saa rəzlay atan ahay ù doh sə wazay ahay wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tə pəlay nà, mazlaɓ su ɗo zənzen awan, bina mazlaɓ a Mbərom saa varan atan ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu a ja 'am tə məgalak awan asa, a wa: «Kuwaya, ɗowan a kə̀ ɗəfak nga pi nen nà, a ɗaf nga pi nen taayak bay. A ɗaf nga pə ɗo sə slənay ahay nen re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kuwaya ɗowan kə̀ canak uno nà, kə̀ canak anan anà ɗo sə slənay ahay nen re. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na nay ahay pə daliyugo nà, aday ɗo sa ɗaf upo nga ahay tə̂ njahay à luvon inde itəbay, anga nen nə jiyjay sa dav pə daliyugo a anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Kuwaya kə̀ slənek 'am uno, kə̀ ɗəfak anan apan anà 'am ata bay cəna, saa gan sariya nà, nen bay, anga na nay ahay saa gan sariya anà ɗo sə daliyugo ahay bay, əna saa tam atan aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Natiya, ɗowan a kə̀ ngəmak nen bay, kə̀ təmahak 'am uno bay, i tavay pa 'am sə sariya, anga 'am uno sa ja ataya ti gan sariya. Ti gan sariya pa pac sa ndav anan daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","«'Am inde na jak tə məgala uno ite nà, ibay. Əna nə təker nà, 'am ana Bəbay uno su jo, aday nâ ja ataya awan. Nə ɗakay anan nà, 'am ataya ɗəkɗek. ");
INSERT INTO mqbNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na san zle re, way anahan su jo ahay nà, ti gəɓak ikwen ahay aɗəka nə sifa sa ndav bay ata awan. Awan a inde, na ja ta nga uno nà, ibay, si mbala a Bəbay uno su jo ataya ɗəkɗek.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Natiya, a mbəsak ibay luvon kərtek aday azar uko sə Pasəka i sla. Yesu ɗukwen a san zle, alay anahan a kà slak sa ma pə cakay ana Bəbay anahan bəse, i mbəsak anan daliyugo a anan. Hwiya a pəlay anan ɗo anahan ahay pə daliyugo, aday həna a pəlay atan nə hus pa sa var sifa anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Alay sə təfek suko, atə Yesu tə njavar anahan ahay tinen apan ti pa ɗaf nà, ɓa Fakalaw kə̀ ɗəfak abayak nga à mivel ana Yudas inde, wan mbala ana Simon Iskariyot ata awan, aday â ga ɗaf pə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu a san zle, Mbərom kə̀ varak anan gədan pə way ahay fok, aday a san zle re, a nay ahay pə cakay ana Mbərom wa, aday i ma pə cakay anahan asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Anga nan, a slabak pa man sa pa way a tinen ata wa, a culok anan zana anahan zəbor a pi zek wa, a ɓan zana kataw awan à zar. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A ngah a'am à tasa inde, a dazlan sə banay a saray a njavar anahan ahay. Kə̀ banak a saray a ɗowan a nà, ata i takaɗ panan tə zana anahan a mə kətuwal a à zar ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A həɗəkey ahay pə cakay ana Simon Piyer bine siwaw nà, Piyer a jan: «Ba Məduwen, iken ki buno anan saray ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu a mbəɗahan apan, a wa: «Piyer, ki san way uno sa ga həna ata fan bay. Əna ki i san mba.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer a mbəɗahan apan asa, a wa: «A'ay, ki buno saray kula itəbay.» Yesu a jan anan ngəlarak kutok, a wa: «Kak aday nə banak anak a saray bay nà, iken ɗo uno sabay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Piyer a jan kutok, a wa: «Miter, kak matanan cukutok nà, kə̂ buno saray ɗəkɗek bay, əna buno anan alay aday ta nga a təke.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu a mbəɗahan apan, a wa: «Kak ɗo kə̀ banak coy nà, a gan may anà abanay zek sabay, əna i banay nə saray ɗəkɗek, anga winen mə banay awan. Kwanay nà, mə banay aya awan. Əna, kwanay a fok bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nà, a san ɗowan a saa ga apan ɗaf ata zle. Anga nan a wa: «Kwanay mə banay aya awan, əna fok bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu a ndav anan sə banan atan anan saray nà, a ma anan rəkot anahan pi zek. A njahay à man sa pa way asa, a wa: «Kə sənen way nen sa gak ikwen həna ata zle ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kwanay apan ki ngimen uno “Miter”, “Bahay a manay” acəkan, anga nen nà, winen a way anahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nen nə Miter a kwanay, Bahay a kwanay, nə banak ikwen anan saray. Sumor a ɗukwen, kwanay nà, binen anan anan saray ì zek ahay matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na ga matanan, aday kə̂ tətiken sa ga matanan cite. Nə ɗakak ikwen anan minje a coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗo sa ga mer su way àga ɗo ɗukwen, i zalay bahay su doh ata bay. Ɗo sa slan ɗo nà, a zalay anan ɗo si mer su way anahan a sa slan anan ata biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Matanan, həna kə sənen anan kutok. Kak aday ki gen anan mer su way a acəkan nà, ki i tislen mivel bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Na ja nə pə kwanay a fok bay, anga na san ɗo uno sə walay ataya zle. Əna, way a mə vinde awan à Deftere a Mbərom ataya inde nà, â təra. Mə vinde uda nà: “Ɗowan a ma pak ɗaf maya ata, kə̀ tərak ɗo maniɗe uno.” ");
INSERT INTO mqbNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ni jak ikwen anan həna, mənjəna way ata sə təra, anga aday, way kətanan kə̀ tərak nà, kə̂ ɗəfen upo nga, kə̂ sənen anan, nen nà, nen. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","«Nen apan ni jak ikwen tə ɗiɗem a həna: Kuwaya ɗowan a kə̀ təmahak anan ɗo nen sa slan anan ata nà, ɗowan ata a təma nə nen awan. Aday ɗo kə̀ təmahak nen ɗukwen, a təma anan nə ɗo sə slənay ahay nen ata re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Natiya, pə dəɓa ana Yesu sa ja 'am ataya wa cəna, mivel anahan a slabak, a ja 'am ngəlarak asa, a wa: «Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan a kərtek à wulen a kwanay inde, i i ga upo ɗaf.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Njavar anahan ataya tə zəzor zek ahay nerre, aday ta san sa jəka a ja 'am ata pə wayaw nà, ta san bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ɗo kərtek inde à wulen sə njavar anahan ataya, Yesu a pəlay anan kə̀ zalak. Winen mə njahan a pə cakay. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyer a cak ayak apan, a ma panan iɗe biyya, kawa sa ja bine siwaw nà: «Cəce pə Yesu wa, a ja nə pə wayaw.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ɗowan ata a həjəkak ayak nga pa mbac ana Yesu, a cəce: «Ba Məduwen, saa ga apak ɗaf a nà, wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu a mbəɗahan apan, a wa: «Həna ni gaɗ ɗaf, ni tar anan à tuwez, aday winen nà, ɗowan a ni varan anan ɗaf ata awan.» Cəna, Yesu a gaɗ ɗaf, a tar anan à tuwez, a varan anan anà Yudas, wan ana Simon Iskariyot. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yesu a varan a ɗaf ata cəna, Fakalaw a zlan à mivel inde anà Yudas. Yesu a jan kutok: «Awan anak inde sa ga nà, gamacan coy!» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","À wulen su ɗo a mə njahay a pə tuwez ataya, ɗowan sa san kwa kərtek Yesu a ja 'am ata angamaw nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yudas nà, ɗo sa ban dala a tinen awan. Anga nan tə bayak i ga nà, Yesu a jan 'am sə sukumay ahay way sa ga azar uko, kabay â zla saa varan way anà ɗo mətawak aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudas a təma anan ɗaf ata cəna, a nay wanahan uho. Abay luvon kà gak coy re. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas a nay ahay uho cəna, Yesu a wa: «Həna nà, mazlaɓ uno, nen Wan su Ɗo, winen apan i ka zek. Aday ti nen ɗukwen, Mbərom i ka anan mazlaɓ anahan re kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Natiya, nen Wan a Mbərom, na kak anan mazlaɓ anahan nà, winen a i ka anan mazlaɓ ana wan anahan tə alay anahan a awan, aday i ka anan nə həna coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Dəna uno ahay, nen inde tə kwanay mənjœk mba, aday pə dəɓa wa ki i pəlen nen. Əna ni jak ikwen həna way uno sa jan anà bahay sə Yahuda ahay ata awan: “À man uno saa zla ata nà, ki mben apan saa zla itəbay.” ");
INSERT INTO mqbNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Anga nan, ni jak ikwen nga sa 'am wiya həna: Sənen zek à wulen a kwanay. Ayaw, sənen zek à wulen a kwanay ahay, kawa anuno sa pəlay kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Njiɗen sa san zek à wulen a kwanay ahay lele. Natiya, ɗo ahay fok ti san, kwanay nà, njavar uno ahay acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyer a jan anà Yesu, a wa: «Ba Məduwen, ki zla ahaw?» Yesu a mbəɗahan apan, a wa: «À man uno saa zla həna ata nà, ki mba apan sə pəruho azar fan bay. Əna ki i mba apan sə pəruho azar nə mba.» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer a jan anà Yesu: «Ba Məduwen, ni mba apan sə pərahak azar həna fan bay nà, angamaw? Nen, u no ni var anan sifa uno anga iken re!» ");
INSERT INTO mqbNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu a mbəɗahan apan, a wa: «Tə ɗiɗem a nà, a nak sa var anan sifa anak anga nen acəkan ɗaw? Nen apan ni jak tə ɗiɗem a həna: Zukwa njəkar i saa zlah nà, ka jak saray maakan ka san nen bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu a jan anà njavar anahan ahay kutok, a wa: «Awan â jalay kwanay bay. Ɗəfen nga pə Mbərom, aday kə̂ ɗəfen upo nga re. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","À gulom su doh ana Bəbay uno Mbərom nà, man ahay inde bayak awan. Ni zla saa ndakak ikwen man à man ata awan. Kak matanan bay nà, ni jak ikwen bay asanaw. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aday azanan na sak a zla, nə ndakak anan man a coy nà, ni may ahay, aday ni ra kwanay pə cakay uno awan. Natiya, ki i njihen à man uno saa njahay ata ite. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Aday ɗukwen, cəveɗ sa zla à man uno saa zla ata nà, kə sənen zle.» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas a mbəɗahan apan, a wa: «Ba Məduwen, manay aday nà, ma san man anak a saa zla uda ata bay kutok nà, mi i san cəveɗ awan nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu a mbəɗahan apan, a wa: «Nen nà, cəveɗ, ɗiɗem, aday sifa. Anga nan, mənjəna nen cəna, ɗowan saa mba apan sa zla à man ana Bəbay Mbərom nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kak kə sənen nen nà, ki sənen anan Bəbay uno zle re. A ban pə həna anan wa cəna, kə sənen anan zle coy, anga kə cinen anan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip ite a jan, a wa: «Ba Məduwen, ɗakan umo anan Bəbay awan cəna, i slan umo ɗa asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu a mbəɗahan apan, a wa: «Filip, nen inde tə kwanay kwa həna kabay, aday ka san nen bay hwiya ɗaw? Ɗowan a kə̀ canak uno cəna, kə̀ canak anan anà Bəbay uno re. Ka ja, ka wa: “Ɗakan umo anan Bəbay awan” nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nen tə Bəbay uno, Bəbay uno ti nen, manay kərtek a nà, kə ɗəfak apan nga bay dəge? 'Am a nen sa jak ikwen ata fok nà, a nay ahay ì nen wa bay. Sa ga mer su way ata nà, Bəbay uno a, winen ì nen inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ɗəfen nga pa 'am uno sa jak ikwen: “Nen tə Bəbay uno, Bəbay uno ti nen nà, manay kərtek” ata awan. Kak matanan bay ɗukwen, ɗəfen upo nga anga mer su way uno ahay kwa. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Nen apan ni jak ikwen tə ɗiɗem a həna: Ɗowan a kə̀ ɗəfak upo nga cəna, winen ɗukwen i ga mer su way kawa anuno sa gay ahay ata ite re. Ɗowan ata i sa ga aɗəka nà, way sə zalay mbala anuno, anga nen apan ni zla nà, pə cakay ana Bəbay uno awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Way ana kwanay saa cəce tə sləmay uno ataya fok, ni ga atan. Matanan, nen Wan su Ɗo ni ka anan mazlaɓ ana Bəbay uno Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kə cəcihen puno wa way tə sləmay uno nà, ni ga anan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu a ja asa, a wa: «Kak kə pəlen nen asanaw nà, ki ɗəfen anan apan anà 'am uno ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Aday nen ni gan kem anà Bəbay uno anga aday â slənak ikwen ahay ɗo hinen maza saa mak ikwen zek. Ɗowan ata nà, winen Apasay sə ɗakay anan ɗiɗek a Mbərom. Winen i njahay tə kwanay sə coy. Ɗo sə daliyugo ahay ti njaɗ sə təma anan à mivel a tinen inde itəbay, anga ti canan bay, aday ti san anan bay re. Kwanay nà, ki sənen anan anga i njahay tə kwanay à mivel inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ni mbəsak kwanay taayak kawa wan mətawak ahay bay, ni may ahay pə cakay a kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aday azanan mənjœk nà, ɗo sə daliyugo ahay ti cuno sabay, kwanay nà, ki cinen uno hwiya. Nen nà, ɗo tə sifa awan. Anga nan kwanay ɗukwen ki njihen tə sifa aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Luvon ata kə̀ dəzlek ahay nà, ki sənen anan manay tə Bəbay uno nə manay kərtek, aday mənuko ɗukwen kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ɗo sə pəlay nen tə ɗiɗem a cəna, i təma 'am uno, i ɗəfan apan, i ga mer su way kawa 'am uno sa jan. Bəbay uno ɗukwen i pəlay anan ɗo sə pəlay nen, ata nen ɗukwen ni ɗakan anan asan zek uno, ni ɗer panan zek bay, ni kan zek lele.» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda ite, winen aday nà, Yudas Iskariyot itəbay ata, a wa: «Ba Məduwen, ki kan umo zek aday ki kan zek anà ɗo sə daliyugo ahay ite bay ata nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu a mbəɗahan apan, a wa: «Kəmaya, ɗowan a kə̀ pəlak nen nà, i ɗəfan apan anà 'am uno ahay. Bəbay uno ɗukwen i pəlay anan, manay a cew maya mi ɗer panan zek bay, aday mi njahay tə winen. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Əna, ɗowan a kə̀ pəlak nen bay ite, i ɗəfan apan anà 'am uno ahay bay. Aday ɗukwen, 'am a kwanay sə sləne həna ata nà, a nay ahay ì nen wa bay. Bəbay uno sə slənay ahay nen ata sa ja. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","À alay a nen inde tə kwanay a mba ata nà, na jak ikwen anan way a anaya coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pa 'am nà, Bəbay uno i slənak ikwen ahay maməzek tə sləmay uno. Winen nà, Apasay Cəncan awan. Ata aday, winen aɗəka i ɗakak ikwen anan way ahay fok, aday i mak ikwen anan 'am uno ahay fok à sləmay inde asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Natiya kutok, ni mbəsakak ikwen nà, zay. Ni varak ikwen zay uno. Zay uno saa varak ikwen anan ata nà, kawa zay ana daliyugo sa var ata bay. Həna, nen ni zla way uno, əna kə̂ jilen awan bay, kə̂ jəjiren bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kə slənen sa jəka: Ni zla way uno, aday ni may ahay pə cakay ana kwanay. Kak aday kə pəlen nen asanaw cəna, tislen aɗəka nà, mivel. Anga nen apan ni zla nà, à man ana Bəbay uno, winen a zalay nen tə mazlaɓ. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","«Nə ɗakak ikwen anan pi zek wa aday way ataya ti saa təra. Ata way ataya tə tərak nà, kwanay ki ɗəfen upo nga kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ni njaɗ alay a tə kwanay gem sə ɗakak ikwen anan way ahay sabay, anga həna bahay sə daliyugo a anan i nay ahay. Məgala anahan inde upo kwa mənjœk ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Əna aday, ɗo sə daliyugo ahay tâ san nà, nə pəlay anan Bəbay uno, aday na ga ɗukwen mer su way anahan awan. «Həna aɗəka nà, slabiken, zluko à man a anan wa!» ");
INSERT INTO mqbNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu a ja 'am tə jike awan, a wa: «Nen nà, na ga minje tə dədazl si sé lele awan. Bəbay uno ɗukwen, winen nà, ɗo sə lavan nga anà sé ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Anga nan, alay si sé awan aday a wahay wan bay ata nà, i gaɗ anan. Winen sə wahay ata ite nà, i kəkal anan aday alay si sé ata â zəga anan sə wahay wan bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kwanay nà, ɓa kə təren kawa alay si sé mə kəkal aya, anga 'am uno sa jak ikwen ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dizlen alay ì nen inde, aday nen ni dazlay alay à kwanay inde ite. Anga alay si sé mə japay a tə dədazl si sé a bay ata nà, a mba apan sə wahay wan bay. Kwanay həna ɗukwen matanan re. Kə dizlen alay ì nen inde bay cəna, ki mben apan bay kawa dədazl si sé ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Nen nà, dədazl si sé, kwanay ɗukwen alay aya awan. Ɗowan a kə̀ dazlak alay ì nen inde, aday nen ɗukwen nə dazlak alay à winen inde ite cəna, i təra kawa sé sə wahay lele ata awan. Anga mənjəna nen cəna, ki mben apan sa ga awan bay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aday ɗowan a kə̀ mbəsakak alay pi nen wa ite, Bəbay uno i lar anan à məndak kawa alay si sé ma gaɗ ataya awan. Alay si sé ma gaɗ ataya nà, ti kuray, ɗo ahay ti ra atan, saa pak ù uko inde, sa vak atan coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«Cəkəbay, kak kə dizlen alay ì nen inde lele, aday kak 'am uno mə dazlay alay a à kwanay inde lele ite nà, kə cəcihen way kawa ana kwanay sa gan may ataya fok, aday ki njiɗen anan acəkan ca. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kak kwanay apan ki gen way lele aya hwiya cəna, kwanay njavar uno ahay acəkan. Ata ki ken anan nə mazlaɓ a Bəbay uno Mbərom anà ɗo ahay bayak a kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Kawa ana Bəbay uno sə pəlay nen ata awan, nen ɗukwen nə pəlay kwanay nà, kətanan re. Anga nan, ngiren alay lele à asan zek uno inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nen nà, nə ɗəfak anan apan anà 'am ana Bəbay uno ahay, aday nə ngarak alay à asan zek anahan inde. Matanan, kak aday kə ɗəfen anan apan anà 'am uno ahay nà, ki ngiren alay à asan zek uno inde lele acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na jak ikwen anan way a anaya nà, aday ataslay mivel a kwanay â ga inde kawa anuno awan, aday ata ataslay mivel mbala ana kwanay nà, â rah wa lele. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«'Am uno sa jak ikwen ata nà, həna anan: Sənen zek à wulen a kwanay lele, kawa nen sə pəlay kwanay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ɗo kə̀ təmahak sa mac anga car anahan ahay nà, asan zek saa zalay anan mbala anahan ata nà, inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kə təmihen sa ga kawa anuno sa jak ikwen nà, kwanay nə car uno ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ni ngamak ikwen ɗo si mer su way ahay sabay, anga ɗo si mer su way nà, a san mer su way ana bahay anahan bay. Əna ni ngamak ikwen həna nà, car uno ahay aɗəka, anga ɓa nə ɗakak ikwen anan way uno sə sənay ahay pə cakay a Bəbay uno wa ata coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kwanay sə walay nen bay. Nen nə walay kwanay aɗəka, anga aday kâ si gen mer su way lele aya awan, aday lele a tinen a â ndav bəse bay ata awan. Ata Bəbay uno i varak ikwen anan way ana kwanay saa cəce panan tə sləmay uno ataya fok kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Natiya awan, 'am uno ma ja nà, sənen zek à wulen a kwanay inde lele.» ");
INSERT INTO mqbNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Sənen a pi zek wa, ɗo sə daliyugo ahay ta saa nak ikwen iɗe nà, ta lah su no iɗe aɗəka nà, ì nen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kak abay kî gen nə ɗo sə daliyugo ahay ata nà, ti nak ikwen iɗe bay, ti pəlay kwanay, anga kə təren nà, ɗo a tinen ahay. Əna ɓa nə walak kwanay à wulen a tinen ahay wa, aday kwanay ɗo a tinen ahay sabay. Anga nan, tinen apan ti nak ikwen iɗe hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","«Ənga, men anan ahay 'am uno inde à nga inde aday. Na wa: Ɗo sa ga mer su way àga ɗo ɗukwen, i zalay bahay su doh ata bay. U no sa ja həna nà, kak tə kukwarak uno azar saa ga alay ti nen nà, ti kukwarak ikwen azar saa ga alay tə kwanay matanan re. Aday, kak tə ɗəfak anan apan anà 'am uno ahay nà, ata ti taa ɗəfan apan anà 'am a kwanay ahay ite. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Aday nà, ti gak ikwen way ataya fok nà, anga nen, bina ta san ɗowan a sə slənay ahay nen ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","«Ta wa abay â ga aɗəka nà, na nak bay, aday nə ɗakak atan anan 'am uno bay nà, ines a tinen i ga ibay. Əna na nak cukutok aday nə ɗakak atan anan 'am uno nà, hwiya tinen apan ti ga ines a tinen ahay re. Anga nan, 'am a tinen inde saa tam wa nà, inde sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɗowan a kà nak uno iɗe cəna, kà nak anan iɗe anà Bəbay uno re. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na gak mer su way à wulen a tinen lele aya awan, aday kula ɗowan maza kà gak matana bay. Kak matanan bay nà, abay ines inde patan ibay re. Tinen tə canan tə iɗe a tinen aya awan, anà mer su way uno sa ga. Tə winen ata təke nà, tinen apan ti nan umo iɗe anà manay tə Bəbay uno hwiya. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mə vinde awan à Deftere a Mbərom inde nà: “Tu no iɗe nà, kəriya pa 'am sə awan a ibay.” Həna ta nan umo iɗe nà, anga aday 'am ata â təra.» ");
INSERT INTO mqbNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yesu a jan atan asa, a wa: «Ɗo inde i nay ahay saa mak ikwen zek. I nay ahay nà, pə cakay ana Bəbay uno wa. Na sak a zla agay à man ana Bəbay uno awan nà, ni slənay anan ahay à man a kwanay. Ɗowan ata nà, Apasay sə ɗakay anan ɗiɗek a Mbərom. Kà sak a nay cəna, i ga nà, side uno awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aday kwanay a ɗukwen, ki naa təren ɗo sə side uno ahay re, anga kwanay pə cakay uno nà, kurre way anahan asanaw!» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Na jak ikwen anan way a anaya həna nà, anga aday kâ saa slihen à alay sə ɗəce inde bay, kə̂ mbəsiken sa ɗaf upo nga bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Anga, azanan ti kukwarak ikwen ahay azar ù doh sə wazay ahay wa. Aday ɗukwen alay a inde i slay nà, ɗo ahay ti vaɗ kwanay. Ata ti bayak nà, kawa ta gan mer su way anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti ga matanan, anga ta san sa jəka, nen, Wan a Mbərom nà, tə sənak bay, aday tə sənak zek a Mbərom a bay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na jak ikwen anan həna nà, anga aday ta sak a dazlan sa ga matanan cəna, â mak ikwen ahay à nga inde nà, ɓa na jak ikwen anan coy. Na jak ikwen anan kurre bay nà, anga nen a inde tə kwanay a mba.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Natiya, həna nen ni zla way uno à man ana ɗo sə slənay ahay nen ata awan. Aka aday ɗowan kərtek sə cəce puno wa ki zla ahaw nə ibay ata nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Aday mbac kə̀ slahak pikwen wa həna, anga nə ɗakak ikwen anan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ɗiɗek a acəkan nà, ni jak ikwen anan: Sumor a pə kwanay cəna, nâ zla way uno aɗəka. Anga na sak a zla way uno bay nà, ɗo sa mak ikwen zek ata i nay ahay bay. Na sak a zla way uno ite nà, ni slənay anan ahay pə cakay a kwanay. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Winen ite, kà sak a nay cəna, i ɗakan anan anà ɗo sə daliyugo ahay nà, tinen apan ti jəjay anga 'am sə ines, anga 'am sə ɗiɗek, aday anga 'am sə sariya a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tinen apan ti jəjay anga 'am sə ines, anga aday nà, tə ɗəfak upo nga itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tinen apan ti jəjay pa 'am sə ɗiɗek, anga nen apan ni zla way uno pə cakay ana Bəbay uno Mbərom, aday ɗukwen, kwanay tə tinen ki i cinen uno kula sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tinen apan ti jəjay anga 'am sə sariya, bina bahay sə daliyugo a anan aday ɗukwen, sariya kə̀ bənak anan coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«'Am ahay inde upo cara cara bayak a sa jak ikwen anan, əna ti zalak ikwen məgala à nga wa həna. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Əna Apasay sə ɗakay anan ɗiɗek a Mbərom ata kà sak a nay ahay cəna, i ɗakak ikwen anan ɗiɗek sə way ahay nə fok lele. Anga i ja aday nà, 'am sa nga anahan a bay, əna way anahan sə sləney ahay pə Mbərom wa, i jak ikwen anan. Ata aday i ɗakak ikwen anan way saa təra azanan pa 'am ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I i ka anan nə mazlaɓ uno awan, anga i njaɗay ahay 'am ahay fok ì nen a wa, aday i mak ikwen anan fok re. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Way a manay tə Bəbay uno a nə kərtek. Anga nan kutok, na wa: 'Am anahan a saa sləney ahay pi nen wa ata, i mak ikwen anan à sləmay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu a jan atan asa, a wa: «I njahay həna mənjœk nà, ki i cinen uno sabay, aday ɗukwen i njahay apan mənjœk cəna, ki i cinen uno maza asa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Azar sə njavar anahan aya tə cəce pi zek ahay wa, ta wa: «A nan sa ja jiya nə maw? A wa: “I njahay həna mənjœk nà, ki i cinen uno sabay, aday ɗukwen i njahay apan mənjœk cəna, ki i cinen uno maza asa.” Aday asa a wa: “Ni zla way uno pə cakay ana Bəbay uno asa.” A ja matanan nà, kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aday tə mənahan asa, ta wa: «“I njahay həna mənjœk” ata nà, a nan sa ja jiya nə maw? Ɗa san way anahan a sa gan may sa jak uko ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kə̀ sənak sa jəka, a nan à njavar anahan ahay sə cəce panan wa way. Anga nan a jan atan, a wa: «Kwanay apan ki vəɗen uway nà, pa 'am uno sa jak ikwen ata ba? Na wa: I njahay həna mənjœk nà, ki i cinen uno sabay, aday ɗukwen i njahay apan mənjœk cəna, ki i cinen uno maza asa. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","«Nen apan ni jak ikwen tə ɗiɗem a həna: Ki i yimen, ki i jen mawa, əna ɗo sə daliyugo ahay aɗəka nà, ata ti ma nga sə mbasay. Way i i cəɓak ikwen, aday way a sə cəɓak ikwen ata i tərak ikwen ambasay aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uwar ti zek cew a bine siwaw nà, mbac i slahan anga kutov kà sak a dəlay anan nà, na. Əna kà sak a ca apan, bəslok wan anahan kà nak uho asanaw cəna, awan a cəɓan sabay anga kə̀ wahak wan, a njaɗ nà, ataslay mivel coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Matanan awan, kwanay həna ɗukwen, mbac i slahak ikwen kawa uwar ti zek cew ata awan. Əna ni naa canak ikwen maza awan. À alay ata nà, ataslay mivel a kwanay i zəga nə bayak awan, aday ɗowan saa təma pikwen wa ataslay mivel ata nà, ibay. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Luvon ata kà sak a dəzley ahay nà, ki i cəcihen puno 'am sə awan sabay, anga ki sənen anan way ahay nə fok. Acəkan, nen apan ni jak ikwen tə ɗiɗem a həna: Kə cəcihen way pə Bəbay uno wa aday tə sləmay uno a nà, Bəbay uno i varak ikwen anan way a kwanay sə cəce fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hus ahay həna ɗukwen, kwanay kə̀ cəcihen awan tə sləmay uno bay. Əna cəcihen, ki njiɗen way a kawa ana kwanay sə cəce ata awan, aday ataslay mivel a kwanay i rah wa kutok acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu a ja asa, a wa: «Na ta jak ikwen way ahay nà, tə 'am sə jike. Alay a i nay ahay aday ni ja 'am tə jike sabay, əna ni ɗakay anan way ahay pə Bəbay uno nà, ngəlarak ngəlarak kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pə luvon ataya nà, ki cəcihen way ahay pə Bəbay uno wa nə tə sləmay uno. Na ja nà, nen saa cəce anga kwanay bay, əna kwanay awan ki cəcihen tə sləmay uno. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Anga zek a Bəbay uno awan aday nà, a pəlay kwanay, anga kwanay ɗukwen kə pəlen nen, kə təmihen nen na nay ahay nà, pə cakay anahan a wa acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Matanan nə slabakay nà, pə cakay ana Bəbay uno wa acəkan, na nay ahay pə daliyugo. Anga nan, həna ni slabak ni ma pə cakay anahan asa, ni mbəsak anan daliyugo.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Njavar anahan ataya ta jan, ta wa: «Ca apan kutok, həna ka jak 'am mənjəna 'am sə jike kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Həna ma san zle, iken ka san way ahay nə fok. Anga ɗowan a i saa cəce panak wa way cəna, kə sənak anan anan way anahan a saa cəce ata awan. Anga nan, ma ɗaf apak nga, ka nay ahay nə pə cakay anà Mbərom wa acəkan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu a jan atan, a wa: «Həna nà, kə ɗəfen upo nga acəkan ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Alay a inde i nay ahay mba, kà nak aɗəka coy, aday ki i ten 'am, kuwaya i zla way anahan à man anahan sa nan. Ata ki i mbəsiken nen nà, taayak. Əna nen nə taayak acəkan bay, anga Bəbay uno a nà, winen inde ti nen hwiya wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","«Na jak ikwen anan nà, aday kə̂ njiɗen sə njahay zay ti nen. Pə daliyugo həna nà, ki gen ɗəce bayak awan, əna bənen mivel lele, anga ɓa nen nə mbasak pə daliyugo coy.» ");
INSERT INTO mqbNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu a ndav anan 'am a anaya cəna, a ca iɗe à mburom, a wa: «Bəbay uno, alay uno kà slak həna kutok. Kan anan mazlaɓ uno anà ɗo ahay, anga aday nen nâ kan anan mazlaɓ mbala anak anà ɗo ahay cite re. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kə varak uno məgala sə lavan nga anà ɗo ahay fok kəzlek, anga aday ɗo a iken sə vuro atan ataya tâ njaɗ sifa sa ndav bay ata ì nen wa kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sifa sa ndav bay ata nà, kawa sa ja bine siwaw nà, tâ san iken, iken nə Mbərom ɗiɗek a kərtek, aday tâ san nen Yesu Almasihu nà, wan anak mə slənay a pə daliyugo ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","«Na kak anan mazlaɓ anak anà ɗo sə daliyugo ahay, kawa sa ja nà, nə ndəvak anan mer su way anak a sə vuro ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Həna kutok, Bəbay uno, vuro ahay mazlaɓ pa 'am anak ite, mazlaɓ a kawa anuno a kurre nen pə cakay anak a mba, kwa à alay daliyugo ɗukwen mə ndakay a fan bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Nə ɗakak atan anan way ahay pə iken anà ɗo iken sə walay atan ahay à wulen sə ɗo sə daliyugo ahay wa ataya awan. Anga nan, həna nà, ta san iken zle lele kutok. Tinen nə ɗo anak ahay, kə varak uno anan ite, tə ɗəfak anan apan anà 'am anak. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Həna ɗukwen ta san zle, way iken sə vuro anan ata fok nà, a nay ahay à alay anak wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nə ɗakak atan anan ləbara anak ɗukwen kawa ananak su jo ata awan, tə təmahak anan acəkan. Tə sənak, nen na nay ahay pə cakay anak wa acəkan, aday ɗukwen tə təmahak, sə slənay ahay nen nə iken awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Na gak amboh həna anga tinen. Ni gak amboh anga man su ɗo a bay, əna anga ɗo a iken sə vuro ataya awan, anga tinen ɗo anak ahay re ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɗo uno inde cəna, winen ɗo anak. Mbala anak inde ite ɗukwen, winen ɗo uno re. Aday ɗo anumo ataya, tinen apan ti ka anan mazlaɓ uno pə daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I njahay həna mənjœk nà, ni mbəsak anan daliyugo a anan, ni mak ayak way uno pə cakay anak awan. Natiya awan, tinen nà, ni mbəsak atan pə daliyugo re. Bəbay uno cəncan awan, ba atan tə məgala sə sləmay anak awan, sləmay iken sə vuro anan kurre ata awan, aday tinen tə̂ təra kərtek, kawa mənumo ɗukwen, mənumo kərtek ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","À alay a manay pə kərtek ata nà, na bak atan tə məgala sə sləmay anak, iken sə vuro ata awan. Na gak atan nga lele, mənjəna ɗowan sə lize, si ɗo mbala ana Deftere a Mbərom sa ja apan ata awan. Winen kəma, kə̀ lizek anan zek anahan acəkan. Ata aday, way ana Deftere sa ja ata â təra kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Həna nà, ni mak ayak way uno pə cakay anak, aday na jak anan way a anaya pə daliyugo nà, aday ataslay mivel a tinen â rah wa lele, kawa anuno awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nə təkərek atan anan 'am anak, aday həna ɗo sə daliyugo ahay ta nan atan iɗe cəveɗ a bay, anga tinen ɗo sə daliyugo ahay sabay ata awan, kawa nen a ɗukwen, nen ɗo sə daliyugo bay ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nə cəce panak həna kəma, ba atan pə Ɗo sə Sədœk wa, â sa laman atan bay, bina ni jak, ra atan pə daliyugo wa aɗəka bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tinen ɗo sə daliyugo ahay sabay, kawa nen awan, nen ɗo sə daliyugo bay ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","«Ɗakan atan anan ɗiɗek anak, aday tə̂ təra ɗo anak ma ga nga aya awan. Ɗiɗek nà, 'am anak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kawa iken sə slənay ahay nen pə daliyugo ata nà, nen ɗukwen ni slan atan həna pə daliyugo cite re. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nə varak anan nga uno anga tinen, aday tinen ɗukwen tə̂ varak anan nga a tinen ahay acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Na gak amboh həna nà, anga tinen ɗəkɗek bay, əna na gak amboh anga ɗo mbala tinen saa ngamay ataya re. Bina ti i təma nen nà, anga 'am ana njavar uno a anaya saa təkəren atan pi nen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amboh uno həna nà, tə̂ təra nə zek kərtek, fok a tinen awan. Kawa iken awan, Bəbay uno, iken ti nen nà, zek kərtek awan. Aday asa, tinen a fok, tə̂ təra ɗukwen kərtek a tə mənumo, aday ɗo sə daliyugo ahay tə̂ təma nà, iken sə slənay ahay nen acəkan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nen nə varak atan anan mazlaɓ anak sə vuro ata awan, aday tə̂ təra tinen a fok kawa ɗo kərtek, kawa mənumo ɗukwen ɗo kərtek a ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nen tə tinen zek kərtek, aday iken ɗukwen, mənumo zek kərtek a cite. Tə̂ təra nà, zek kərtek a way anahan. Ata, ɗo sə daliyugo ahay ti san anan, sə slənay nen nà, iken acəkan. Ti san nà, kə pəlay atan, kawa iken sə pəlay nen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Bəbay uno, sə vuro atan nà, iken awan. U no ɗukwen tâ saa njahay à man a həna nen saa njahay uda ata awan, aday tə̂ canan anà mazlaɓ uno iken sə vuro ata awan. Kə vuro anan ɗukwen, anga kə pəlay nen, kwa daliyugo winen mə ndakay a fan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Bəbay uno, iken ɗo ɗiɗek awan, ɗo sə daliyugo ahay ta san iken bay. Nen nà, na san iken zle, aday tə sənak, sə slənay ahay nen nà, iken awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nə ɗakak atan anan iken, ni pərahan azar sə ɗakan atan anan hwiya, anga aday asan zek anak a sə pəlay nen ata â rahan atan à mivel inde. Natiya kutok, tinen ti təra zek kərtek a ti nen.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Natiya, Yesu a ndav anan sa ga amboh asanaw nà, ta zla way a tinen tə njavar anahan ahay, tə takas zlinder sə ngaman Kedəron ata awan. Tə njahay à jerne a inde à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aday ɗukwen, Yudas, ɗo saa ga ɗaf pə Yesu ata, a san man ata zle, anga ɓa Yesu a taa zla à man ata tə njavar anahan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yudas a njahan ahay pa 'am wa anà suje ahay bayak awan. Suje sə Ruma ahay inde, aday bahay sə gəɗan dungo anà way ahay anga Mbərom tə Farisa ahay ɗukwen tə slənak ahay suje sa ba pu doh sə mazlaɓ a Mbərom ahay re. Suje ahay ta dav uko à alay inde, aday tinen tə way sə alay aya hunjəslesle re. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu a ɗukwen a san way saa təra apan ata zle. Anga nan, a lah sə cəce patan wa, a wa: «Kə pəlen wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ta gak munok bay, tə mbəɗahan apan, ta wa: «Mə pəlay Yesu sə Nazaratu ata awan!» Yesu a jan atan: «Nen həna!» Yudas, ɗo sə njəkan uda anà Yesu ata ɗukwen, winen mə tavay a pə kərtek a tu ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ana Yesu sa jan atan: «Nen həna!» ata cəna, fok a tinen a, ta ma à dəɓa dərdar, aday tə slahay à məndak. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu a cəce patan wa asa, a wa: «Kə pəlen nə wayaw?» Tə mbəɗahan apan, ta wa: «Yesu sə Nazaratu!» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu a jan atan kutok: «Na jak ikwen nà: Nen həna! Kak kə pəlen nə nen kəma, mbəsiken ɗo a anaya awan, tinen ta zla way a tinen agay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Matanan, a təra nà, kawa anahan a sa ja ata awan, a wa: «Nâ saa lize anan ɗo iken sə vuro ataya kwa kərtek bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyer kəma, maslalam inde apan, a ndahay anan, a gaɗ sləmay sə alay puway pə ɗowan wa poc. Ɗowan ata nà, tə ngaman Malkus, winen ɗo si mer su way anà bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu a jan anà Piyer, a wa: «Ma anan maslalam anak ù doh anahan a inde. A ga apak nà, ni sa anan məgəvet sə ɗəce uno, kawa ana Bəbay uno sə luvo anan zek ata bay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pə dəɓa anahan a wa kutok, suje ahay pi zek tə bahay nga a tinen aya, tə suje sa ba doh sə mazlaɓ a Mbərom ataya, ta ban anan Yesu, tə jaway anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ta zla anan pa 'am nà, àga Anas, midem ana Kayafas. Tə viya ata nà, Kayafas, winen bahay nga su ɗo sə gəɗan dungo anà way anga Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aday sa jəka: «Suwan ɗo kərtek â mac, tu ɗo ahay saa lize jiya nà, na.» ata nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Atə Simon Piyer tə njavar a inde tə pərahan azar anà Yesu. Ɗowan a hinen ata nà, ta san anan zle lele àga bahay nga su ɗo sə gəɗan dungo anà way ahay ata awan. Anga nan, a zla ù doh à alay a ɗo ahay sa zla anan Yesu ù doh ata re. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyer ite, anga ɗowan a san anan itəbay ata awan, a tavay way anahan pə alay sə məsudoh uho. Ɗowan a hinen ata a may uho, a jan anà uwar sa ba 'am su doh ata, â mbəsakan cəveɗ anà Piyer sa zla ù doh ite. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dalay ata a jan anà Piyer, a wa: «Iken ɗukwen njavar anà ɗowan ata ba?» Piyer a mbəɗahan apan, a wa: «A'ay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ɗo sa ba məsudoh ahay pi zek tu ɗo si mer su way ahay tə hanak uko, anga maɗ a ga ike. Piyer ɗukwen a tavay à man ana tinen, a njahay pə uko. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bahay nga su ɗo sə gəɗan dungo anà way ahay a cəce 'am pə Yesu a wa. A cəce 'am pə njavar anahan ahay aday pə atətak way anahan aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu a mbəɗahan apan: «Na taa ja 'am pa 'am sə ɗo ahay fok asanaw? Nen apan ni wazay ù doh sə mazlaɓ a Mbərom, ù doh sə wazay ahay, à man aday Yahuda ahay fok ta taa halay uda nga ata awan. Na jak awan inde tə sœksœk a itəbay. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kə cəce puno wa asa nà, angamaw? Cəce aɗəka nà, pu ɗo sə sləne 'am uno ahay wa, ti jak way nen sa ja ataya ta nga təte, anga ta san zle.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu winen apan i ja 'am ataya mba cəna, suje a kərtek a, a dəcan pə məhulom, a wa: «Kə mbəɗahan apan anà bahay nga su ɗo sə gəɗan dungo anà way matanan nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu a mbəɗahan apan, a wa: «Kak na gaɗ mungwalay nà, ɗakay anan ɗiɗem awan kwa! Aday kak na ja nà, ɗiɗem a nà, kə dəco angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Natiya Anas a slənay anan Yesu tə alay sə suje ahay, mə jaway a hwiya, àga Kayafas, bahay nga su ɗo sə gəɗan dungo anà way ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","À alay ata kutok, Piyer mə njahay a pə uko ata hwiya. Ɗo a pə uko ataya tə cəce panan: «Iken nà, ma wa iken njavar a ɗowan ata ba?» Piyer a məman anan asa, a wa: «A'ay, matanan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ɗo kərtek à wulen su ɗo si mer su way su doh ataya, aday mərak anà ɗowan a Piyer sa gaɗ panan sləmay ata, a wa: «Nə canak anak à jerne iken tə winen maya na wa ba?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyer a məman anan asa. À alay ata ite, njəkar a zlah coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sidew a pərek, tə gəɓa anan Yesu àga Kayafas wa, ta zla anan àga Guverner Pilatu, winen Ruma ahay. Bahay sə Yahuda ahay nà, ta ngam sa zla ù doh bay, anga tə jəjar sa nes a zek, bina ti njaɗ saa pa way sə azar uko sə Pasəka bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Anga nan kutok, Pilatu a nay ahay patan uho, a cəce patan wa: «Kə zlihen pə ɗowan a anan nà, angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tə mbəɗahan apan, ta wa: «Kak kà gak awan bay cəna, manay mi bənay anan pa 'am anak kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu a jan atan, a wa: «Təmihen anan, aday kî gen anan sariya awan kawa ana sariya a kwanay a sa ja.» Bahay sə Yahuda ahay tə mbəɗahan apan, ta wa: «Cəveɗ a manay inde sa gan sariya anà ɗo aday sa mac anan itəɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A təra matanan, anga aday 'am a Yesu sa ja pa 'am sə amac anahan ata, â təra. ");
INSERT INTO mqbNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatu a ma way anahan ù doh. A ngaman ayak anà Yesu taayak, a cəce panan, a wa: «Iken nà, bahay sə Yahuda ahay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu a mbəɗahan apan, a wa: «Kə lavay à nga anak a wa ite ɗaw, kabay ɗowan a sa jak kələɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu a jan asa, a wa: «Nen Yahuda ahay bay asanaw? Bahay sə gəɗan dungo anà way ahay pə kərtek a tu ɗo sə slala anak aya ta zlah apak àga nen. Ka ga nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu a mbəɗahan apan, a wa: «Bahay uno sa ga nà, a nay ahay pə daliyugo wa bay. Abay â ga nə matanan kəma, njavar uno ahay ti ga puno wa 'am, anga aday nâ saa zla à alay sə bahay sə Yahuda ahay inde bay, biɗaw? Anga nan, bahay uno sa ga nà, a nay ahay pə daliyugo wa bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatu a cəce panan, a wa: «Ayaw, kwa matanan bay dəp nà, iken nə bahay ɗaw?» Yesu a mbəɗa apan, a wa: «Matana awan, ka ja nà, nen nə bahay. Nen mə wahay a, na nay pə daliyugo nà, saa ɗakay anan ɗiɗem sa 'am. Kuwaya a nan ɗiɗem sa 'am nà, i sləne 'am nen apan ni ja ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu a cəce panan: «Ɗiɗem sa 'am nà, awan a maw?» Pilatu a may ahay uho, a zla pə cakay ana bahay sə Yahuda ahay, a jan atan, a wa: «Nen nə njaɗak apan ines sa gan apan sariya anà ɗowan a anan bay! ");
INSERT INTO mqbNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kawa sə kwakwa bine maw nà, ni mbəsakak ikwen anan ahay ɗo kərtek à dangay wa, kawa ana kwanay sa gan may. A nak ikwen nə̂ mbəsakak ikwen anan ahay bahay sə Yahuda ahay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tə mbəɗahan ayak apan tə məgalak awan, ta wa: «A'ay, kə̂ mbəsakan umo ahay winen bay. A nan umo nà, mbəsakay ahay aɗəka nà, Barabas.» Barabas ata nà, ɗo sə vəze pə Ruma ahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatu a jan anà suje ahay tə̂ gəɓa anan Yesu, aday tə̂ ndaɓay anan. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Suje ahay tə hanan jugo sə adak, tə ɗəfan à nga inde, aday tə ɗəfan zana ɗəzɗaz a pi zek, kawa sə bahay. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tə həɗəken ayak pə cakay, ta jan: «Bahay sə Yahuda ahay â ga inde sə coy!» Tinen apan ti dəcan kurkwer. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu a nay uho pə cakay su ɗo ahay asa, a jan atan, a wa: «Ni ngaman uho pə cakay a kwanay à man a anan, aday ki sənen anan nà, nə njaɗak apan ines təɗe aday sa gan apan sariya ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tə ngaman ahay à Yesu uho, winen tə jugo sə adak awan à nga inde, tə zana sə bahay a sə makukwa pi zek hwiya. Bahay Pilatu a jan atan kutok, a wa: «Winen həna!» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bahay sə gəɗan dungo anà way ahay pi zek tu ɗo sa ba doh sə mazlaɓ a Mbərom ahay tə canan anà Yesu cəna, ta ma nga sa zlah, ta wa: «Darak anan ayak pə dədom, darak anan ayak pə dədom!» Pilatu a jan atan, a wa: «Kak sə matanan cukutok nà, kwanay aya gəɓen anan aday kə̂ diren anan. Bina nen, nə njaɗak apan ines sa gan sariya ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahuda ahay ta jan, ta wa: «Tawrita a manay inde, aday kawa ana Tawrita sa ja nà, si i mac! Anga a təra zek anahan, Wan a Mbərom awan!» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu a sləne matanan cəna, zlawan a zəgahan à mivel inde bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ta ma ù doh asa, a cəce pə Yesu a wa: «Iken, ka nay ahay nà, awanaw?» Yesu a ngam sə mbəɗahan apan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bahay Pilatu a jan asa, a wa: «Ki mbəɗuho apan bay ɗaw? Gədan uno inde sa tam iken, aday gədan uno inde sə daray iken pə dədom re nà, ka san itəbay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu a mbəɗahan apan kutok, a wa: «Gədan anak inde pi nen kwa mənjœk itəbay, kak si zek a Mbərom a sə varak anan aday. Anga nan, ɗo sə varak nen à alay inde ata nà, ines anahan nə a zalay ike pə ananak wa.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A ban pə winen ata wa kutok cəna, Pilatu nà, a pəlay cəveɗ sə mbəsakay anan ahay Yesu. Əna Yahuda ahay ta jan nà: «Ka sak a mbəsak anan nà, iken a nà, ki təra car ana ɗo sə lavak nga, bahay sə Ruma sabay. Anga kuwaya, ɗowan a kə̀ tərak anan zek anahan bahay a nà, winen maniɗe ana bahay sə Ruma.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatu a sləne matanan cəna, a mbakay anan Yesu uho, winen a a njahay à man anahan sa taa ga sariya ata awan. Man ata nà, mə pəpay a tu kon. Ta 'am sə Yahuda ahay nà, tə ngaman Gabata. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Alay a ata nà, man ipec pə luvon sə lavan zek anà azar uko sə Pasəka. Anga sidew a nà, Pasəka kutok. Pilatu a jan anà Yahuda ahay, a wa: «Bahay a kwanay həna!» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ta zlah pi zek, ta wa: «Lize a wa, lize a wa! Darak anan ayak pə dədom!» Pilatu a jan atan: «Nə̂ daray anan bahay a kwanay ɗaw?» Bahay sə gəɗan dungo anà way ahay a, ta wa: «Bahay a manay maza inde, pa nga ana bahay sə Ruma wa nà, ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Natiya Pilatu a varan anan Yesu anà suje ahay, aday tə̂ daray anan pə dədom. Tə gəɓa anan, ta zla anan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu a tavak dədom anahan mə zləlngaɗ awan, ta zla anan à wulen su doh ataya wa, hus pa man sə ngaman Kəlakasl-sa-Nga. Ta 'am sə Yahuda ahay nà, tə ngaman Golgota. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Suje ahay tə daray anan Yesu pə dədom à man ata kutok. À alay ata ite, tə daray anan ɗowan aya inde cew pə cakay anahan, ɗo kərtek a tə alay puway, ɗo hinen tə alay gula, Yesu à mamasl a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu kə̀ vindek ayak ləbara sə sariya ana Yesu, aday a jan atan tə̂ laway anan 'am ata pə dədom a Yesu ata awan. 'Am ata mə vinde a nà, natiya awan: «Yesu sə Nazaratu, Bahay sə Yahuda ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahuda ahay bayan a tə jinge anan, anga man ata aday ɗukwen winen dəren pi zek wa tə wulen su doh bay. Ləbara ata mə vinde ɗukwen ta 'am su kon ahay maakan: ta 'am sə Yahuda ahay, ta 'am sə Ruma ahay, aday ta 'am sə Gərek ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bahay sə gəɗan dungo anà way ahay, ta jan anà Pilatu, ta wa: «Kə̂ vinde “Bahay sə Yahuda” bay! Vinde nà: “Winen a a ja nà: Nen Bahay sə Yahuda.”» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu a mbəɗa apan, a wa: «Way nen nə vindek anan ata nà, i njahay nə kawa anuno sə vinde anan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Suje ahay ta ndav anan mer su way sə daray anan Yesu cəna, tə gəɓa anan zana anahan ahay, tə gəzla atan ì zek wa fuɗo. Kuwaya fok kə̀ njaɗak wa bat. Tə gəɓa rəkot anahan matanan re, winen ma han a ɗukwen mənjəna man sa tam. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Suje ahay ta ja à wulen a tinen: «Ɗa saa ngəraw anan zana a anan bay, əna suwan guko apan caca, aday sa san saa njaɗ anan nə wayaw. Cuko apan!» Matanan, way mbala Deftere a Mbərom sa ja apan ata aday a təra. Ma ja a nà: «Tə gəzla anan zana uno ahay à wulen a tinen, ta ga caca pə rəkot uno.» Suje ahay ta ga nà, matanan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Uwar aya inde mə tavay a pə cakay sə dədom ana Yesu mə daray ata awan: may a Yesu tə mərak anahan; Mariyama, uwar ana Kulapas; aday Mariyama dəna sə Magədala. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu a canan anà atə Mariyama may anahan tə njavar anahan a ləliwe ata nà, a jan atan, a wa: «Mamay, wan anak həna nà, winen kutok! ");
INSERT INTO mqbNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wan ada, həna nà, winen may anak cite.» A bənay à alay ata wa cəna, njavar anahan ata a gəɓa anan Mariyama àga winen. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pə dəɓa anahan a wa, Yesu a san a zle kutok, way ahay fok tə ndəvak coy. Matanan a ja, a wa: «Jom u go!» anga aday 'am ma ja à Deftere a Mbərom inde ata, â təra acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","À man ata ite, tugoy sə a'am inde, winen ma rah a tə way mə kwasay a inde, aday sərekeke re. Tə gəɓa awan a inde kawa baf, ta tar anan uda awan. Tə taran anan ayak pa 'am tə sukol aday â susœɓ. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu a tukom anan cəna, a wa: «Way ahay fok tə ndəvak coy!» Nga anahan a lar pa 'am tolongor, kə̀ məcak coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pac ata nà, luvon sa man uda i i sla sidew awan. Anga nan, a nan anà bahay sə Yahuda ahay nə məsinde â njahay mə daray a bay, bina luvon sa man uda ata nà, luvon məduwen a sə ɗəfan apan àga tinen Yahuda ahay. Anga nan kutok, tə cəce pə Pilatu wa, aday â jan anà suje ahay tə̂ kaɗan anan saray ana ɗo mə daray aya pə dədom ataya awan, aday ɗukwen, tə̂ dazay atan ahay pə dədom ataya wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Suje ahay tə dəzley cəna, tə kaɗan anan saray anà ɗo mə daray aya pə cakay a Yesu ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Taa dəzle pə Yesu nà, ɓa winen kə̀ məcak coy. Anga nan, tə kaɗak anan anan saray ite bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Əna ɗo kərtek a à wulen sə suje ahay wa, a ndəzan anan jaham ngəram tə suwer. Atə mez tə a'am tə japay tə ngəzay ahay à kutov wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɗowan a sə canan ata nà, kə̀ sidek tə ɗiɗem awan, aday a san zle side anahan nà, ɗiɗem awan. A side nà, anga aday kwanay ɗukwen kə̂ ɗəfen apan nga re. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A təra matanan nà, anga aday 'am ana Deftere a Mbərom ma ja ata nà, â təra, a wa: «Ti kaɗan a kəlakasl anahan kwa kərtek ite bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","À man hinen ɗukwen, Deftere a Mbərom a wa: «Ti canan ù ɗo tinen sa ndaz anan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pə dəɓa anahan a wa, Yusufu, ɗo sə Arimatiya ahay a cəce cəveɗ pə Pilatu wa, sə gəɓa anan Yesu à məke. Yusufu ata ɗukwen, winen njavar ana Yesu, aya əna a ta pərahan azar nə tə wurwer awan, anga a jəjaran anà bahay sə Yahuda ahay. Pilatu a varan cəveɗ anà Yusufu awan sə gəɓa anan Yesu à məke kutok. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, ɗowan a sa zla à man ana Yesu sə luvon ata ɗukwen, a gəɓay ahay ləluway ahay mə japay a tə way azar aya bayak awan, aday a rəbas lele ataya awan. Way anahan ataya fok, i ga kilo kwa kuro maakan. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tinen a cew maya tə Yusufu tə gəɓa anan məsinde a Yesu. Ta nga apan rəkot, aday ta ga apan way a sə rəbas lele ataya awan. Ta gan kawa ana Yahuda ahay sa gan may ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jəvay a inde nà, ɗowan kula kə̀ ɗəfak uda məsinde fan bay. Jəvay ata nà, à guvo inde à man ata awan, dəren ta man sə daray a Yesu ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tə ɗəfak anan ayak uda Yesu, anga sidew a nà, luvon sa man uda awan, aday ɗukwen, man ata winen dəren bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pac sə zaka pərek, iɗe kə̀ cəɗek lele fan bay nà, Mariyama dəna sə Magədala ata a zla pə jəvay. A canan nà, bələlen inde pa 'am jəvay a sabay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A haw pə cakay ana atə Simon Piyer tə njavar a Yesu winen ləliwe anahan ata awan. A jan atan, a wa: «Tə gəɓak anan bahay. Winen inde à jəvay sabay, aday ma san man a tinen sa ɗaf anan ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Atə Piyer tə njavar a hinen ata, ta zla pə jəvay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cew maya a tinen a ta haw, əna ɗowan hinen ata a zalay Piyer tə ahaw. Anga nan kutok, a dəzlen pa 'am anà Piyer. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Winen a zərɗek ayak iɗe à jəvay inde nà, a canan ayak anà rəkot pi zek tə pətike tinen ma pak aya awan, əna winen a nà, kà zlak à jəvay inde bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Piyer a dəzlek ayak ite cəna, a zla à jəvay inde, a canan anà rəkot pi zek tə pətike ma pak aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pətike sə tuwɗen anan iɗe ata nà, winen mə japay a pi zek tə zana azar aya bay. Zana ata nà, winen mə faɗay a aday ma ɗaf a cara. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɗo sə dəzlek ayak pa 'am ata ɗukwen, a zla à jəvay inde kutok ite. A canan à way ahay cəna, a ɗaf apan nga. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Deftere a Mbərom a ja nà, Yesu i slabakay ahay à məke wa. Aya əna hus a dəzley ahay alay ata nà, njavar anahan ahay tə sənak 'am ata fan bay.) ");
INSERT INTO mqbNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pə dəɓa anahan a wa nà, njavar anahan a cew ataya ta zla agay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Əna Mariyama ɗukwen kà mak, winen mə tavay a uho mba, i yam. A zərɗek ayak iɗe à jəvay inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A canan ayak anà maslay a Mbərom ahay tinen cew. Tinen ma pak zana herre aya pi zek, aday tinen mə njahay aya ɗukwen à man sə nahay a Yesu ata awan, kərtek a tə day sa nga, kərtek a hinen tə day sə saray. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tə cəce panan, ta wa: «Uwar, ka yam maw?» A mbəɗahan atan apan, a wa: «Tə gəɓak anan bahay uno, aday na san man a bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mariyama a ndav anan 'am ata cəna, a cay iɗe mə dədəɓa nà, a canan anà Yesu a mə tavay awan, əna a san sa jəka winen bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu a cəce panan, a wa: «Uwar, kə pəlay wayaw, aday ka yam maw?» Pə Mariyama nà, sa jan 'am ata nə ɗo sə guvo. Anga nan, a jan, a wa: «Wan ada, kak iken sə gəɓa anan nà, ɗuko anan man anak sa zla anan uda ata awan, aday ni i gəɓay anan way uno biɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu a jan: «Mariyama!» Mariyama a mbəɗahak ayak apan 'am, a jan: «Raboni!» Ta 'am sə Yahuda ahay, kawa sa ja nà: «Miter!» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu a jan: «Kə̂ lumo bay, anga na zlak pə cakay anan Bəbay uno fan bay. Əna zla pə cakay ana mərak uno ahay, jan atan nà, nen apan ni zla pə cakay ana Bəbay uno, Bəbay a tinen re, pə cakay ana Mbərom uno, aday Mbərom a tinen cite re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariyama sə Magədala a zla saa jan anà njavar a Yesu ahay. A dəzle nà, a wa: «Nen nə canak anan anà Ba Məduwen!» Aday a jan atan anan way a Yesu sə təkəren ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pa pac sə zaka ata awan, suko a ga cəna, njavar a Yesu ahay tə halay nga ù doh. Tə tacay anan məsudoh pi zek lele, anga tə jəjaran anà bahay sə Yahuda ahay. Natiya, Yesu a nay ahay, a tavay jek à wulen a tinen inde, a jan atan: «Zay â tərak ikwen!» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A jan atan 'am ata cəna, a kan atan anan alay anahan ahay tə jaham anahan ma ndaz ataya awan. Njavar anahan ahay tə canan à bahay a tinen cəna, ataslay mivel a tinen a rah wa. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu a mənahan atan anan, a wa: «Zay â tərak ikwen. Kawa ana Bəbay uno sə slənay ahay nen ata nà, nen ni slan kwanay matanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A vəzle patan apasay, a wa: «Təmihen Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɗo a kwanay sə pəsen atan anan ines ahay ata nà, Mbərom kə̀ pəsek atan anan coy. Aday ɗo a kə pəsen atan anan itəbay ataya nà, Mbərom kə̀ pəsek atan anan bay acəkan re.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yawa, Yesu a nay ahay pə cakay ana njavar anahan ahay wa nà, ɗowan a tinen a kərtek a sə ngaman Tomas ata nà, winen ibay. Tomas nà, tə ngaman Didimus re, anga winen muwsa. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Njavar azar ataya ta jan, ta wa: «Mə canak anan anà Ba Məduwen.» Əna Tomas a mbəɗahan atan apan, a wa: «Nen nà, nə canak anan anà vivay sə mbəlak anahan ahay pə alay ata bay, nə lamak anan alay anà mbəlak ataya bay, aday nə tarak wan sə alay à mbəlak sə jaham anahan ata bay cəna, ni ɗaf nga pə ləbara ata fan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pə dəɓa anahan a wa, a ga lumo pam nà, njavar a Yesu ataya tə halay nga ù doh asa, məsudoh mə tacay awan. Pac ata nà, Tomas winen inde kutok ite. Yesu a nay, a tavay jek à wulen a tinen inde asa, a jan atan: «Zay â tərak ikwen!» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","A jan anà Tomas kutok, a wa: «Tomas, hayak anan wan sə alay anak à man a anan. Ca pə alay uno ahay! Tar alay à jaham uno inde. Mbəsak avaɗ uway, ɗaf upo nga.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas a mbəɗahan apan, a wa: «Ba Məduwen uno, Mbərom uno.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu a jan, a wa: «Həna kə canak uno kutok nà, ata kə ɗəfak upo nga a ɗaw? Ataslay mivel i təran anà ɗo sa ɗaf upo nga aday winen mənjəna sə cuno ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yawa, Yesu kà gak mer su way masuwayan aya cara cara bayak awan pa man sə iɗe ana njavar anahan ahay fok, əna masuwayan azar aya ɗukwen mə vinde à Deftere a anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aya əna, way a mə vinde a anaya nà, anga aday kə̂ ɗəfen apan nga, Yesu nà, winen Almasihu, Wan a Mbərom, aday kə̂ njiɗen anan sifa, anga kə ɗəfen apan nga ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pə dəɓa anahan a wa nà, Yesu a kan zek anà njavar anahan ahay asa, tinen pa nga sə a'am sə bəlay sə Tiberiyas. A kan atan zek a nà, natiya: ");
INSERT INTO mqbNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tinen a aday nà: Simon Piyer; Tomas sə ngaman Didimus anga winen muwsa ata awan; Nataniyel wan sə Kana winen pə daliyugo sə Galile; aday wan ana Zebede ahay; tə apan njavar ana Yesu maza aya inde tinen cew re. Tə japay fok tinen cuwɓe. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aday Simon Piyer a jan atan, a wa: «Nen ni zla saa bənay kəlef.» Ɗo ataya tə mbəɗahan apan, ta wa: «Manay a ɗukwen mi zla re.» Ta zla pə kərtek awan, ta ján à kwalalan inde. Hwiyop apan sə luvon ata fok, əna tə bənak kəlef kwa kərtek bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pac a saa jəka i sləray siwa a nà, Yesu a kan atan zek pa 'am məgujeguje, əna tə sənak anan bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu a cəce patan wa 'am: «Kə bənen kəlef a dəp ɗaw, məndala uno ahay?» Tə mbəɗahan apan: «A'ay!» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A jan atan: «Tiren anan zuvo a kwanay ta day sə alay puway nà, ki bənen.» Ta tar anan zuvo ta day ata cəna, tə bənay ahay kəlef acəkan. Ta mba apan sə ngəza anan à kwalalan inde sabay, anga zuvo kà rak ahay kəlef bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Njavar a aday ləliwe ana Yesu ata a jan anà Piyer, a wa: «Həna anan nà, Ba Məduwen!» Simon Piyer a sləne 'am ata cəna, a ma anan zana anahan mə cəlok ata pi zek, a dazay à a'am inde. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Njavar a azar ataya ta zla anan kwalalan pə məgujeguje ta sə ngəza anan zuvo a tinen ma rah a tə kəlef ata awan. Tinen abay dəren pi zek wa ta 'am məgujeguje a bay. Izəne i ga miter səkat cəna coy. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tə jənay pə yugo cəna, tə canan anà kəlef pə uko, tə canan anà tapa sə pen ahay inde re. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu a jan atan, a wa: «Ren ahay kəlef a kwanay a sə bənay ata mənjœk aday.» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyer a ján à kwalalan inde kutok, a gəɓay anan zuvo ata à məndak. Kəlef məduwen aya uda səkat tə kwa kuro ɗara nga anahan maakan (153), tə winen ata təke ɗukwen zuvo kə̀ ngərwak bay. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu a jan atan: «Hayak ikwen ahay, pen!» Aday ɗowan sə cəce panan kwa kərtek «Iken wayaw?» ɗukwen ibay, anga ta san zle, winen nə Ba Məduwen awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu a zla, a ra tapa sə pen ahay, a varan atan anan, a ra kəlef ahay matanan, a varan atan anan re. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Həna anan nà, aka zek ana Yesu anà njavar anahan ahay tə slala maakan awan, kwa ananahan sə slabakay ahay à məke wa nà, na. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pə dəɓa sa pa way wa nà, Yesu a jan anà Simon Piyer, a wa: «Simon, wan ana Yuhana, kə pəlay nen a zalay ɗo a anaya ɗaw?» A mbəɗahan apan, a wa: «Ba Məduwen, ka san zle, nə pəlay iken asanaw!» Yesu a jan, a wa: «Gan nga anà wan sə təman uno ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aday a cəce panan tə slala cew a asa: «Simon, wan ana Yuhana, kə pəlay nen dəp ɗaw?» A mbəɗahan apan, a wa: «Ayaw, Ba Məduwen! Ka san zle nə pəlay iken asanaw!» Yesu a jan: «Varan way sa pa anà təman uno ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu a jan tə slala maakan a asa, a cəce panan: «Simon, wan ana Yuhana, kə pəlay nen ɗaw?» Mbac a slahan anà Piyer, anga Yesu sə cəce panan saray maakan «Kə pəlay nen ɗaw?» ata awan. A mbəɗahan apan, a wa: «Ba Məduwen, ka san way ahay zle fok. Ka san zle, nə pəlay iken re.» Yesu a jan: «Gan nga anà təman uno ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nen apan ni jak tə ɗiɗem a həna: À alay a iken njavar a mba ata nà, kə juwaɗ zek anak nə tə alay anak awan, aday ka taa zla à man anak sa nak. Əna ka sak a ga məduwer nà, ki kan alay anà ɗo maza awan, i juwaɗ iken, i lagay iken ɗukwen ta man sa nak ahay sabay.» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta 'am a anaya bine siwaw nà, Yesu a ɗakan anan anà Simon Piyer cəveɗ anahan saa mac aday amac anahan i ka anan mazlaɓ a Mbərom ata awan. Aday Yesu a jan kutok: «Pəruho azar!» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyer a mbəɗa zek, a ca iɗe, a canan ayak anà njavar a Yesu a inde, winen apan i pərahan atan ahay azar. Njavar ata ɗukwen nà, ləliwe ana Yesu awan. Njavar ata nà, à alay sə azar uko sə Pasəka nà, winen sə həjəkak ayak nga pa mbac a Yesu, aday sə cəce panan wa, a wa: «Saa ga apak ɗaf nə wayaw?» ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kutok, Piyer a cəce pə Yesu wa, a wa: «Aday ɗowan a anan kəmaw? Ma saa təra apan ite anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Natiya, Yesu a mbəɗahan apan anà Piyer kutok, a wa: «Kà nak uno, winen â njahay uho tə sifa hus pə luvon uno saa may nà, ma anak apan anaw? Iken nà, hayak, pəruho azar.» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","'Am ata a ta 'am təɗay à wulen su ɗo sa ɗaf nga pə Yesu ahay inde nà, ta wa: «Yesu a ja nà, njavar ata i mac itəbay.» Aday abay Yesu kà jak anà Piyer matanan bay. A ja bine siwaw nà: «Kà nak uno â njahay uho tə sifa hus pə luvon uno saa may nà, ma anak apan anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɗo sə side ləbara sa 'am a anaya nà, njavar ata awan. Kə̀ vindek anan ləbara awan. Ma san zle, way anahan sə təker nà, ɗiɗem aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu kà gak mer su way ahay maza aya bayan a cara cara. Kak abay tə vinde anan kərtek tə kərtek fok à deftere ahay inde nà, a ga upo ɗukwen, zek ana daliyugo awan, i mba apan sə tavak anan deftere ataya bay.");
INSERT INTO mqbNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nə vindek ayak nə anakiken, Tiyufil, car uno. À deftere uno inde sə vindek ayak mama'am ata nà, nə ɗakak anak anan ayak mer su way a Yesu sa ga tə way anahan sə ɗakan anan anà ɗo ahay kwa pa sə dazlan a wa, ");
INSERT INTO mqbNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","aday hus pə ana Mbərom sə gəɓa anan à mburom ata awan. À alay a winen pə daliyugo mba ata nà, a walay anan ɗo maslan anahan ahay, a ɗakan atan anan way a tinen saa ga pə dəɓa anahan wa ataya tə məgala ana Apasay Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pə dəɓa sə amac anahan wa nà, a slabakay ahay à məke wa, a njahay pə daliyugo luvon kwa kuro fuɗo. A kan zek anà ɗo maslan anahan ataya tə cəveɗ ahay cara cara saray bayak awan, anga aday tâ san tə ɗiɗek awan, winen inde tə sifa awan. À alay ata nà, winen apan i ɗakan anan ləbara sa 'am sə bahay a Mbərom anà ɗo maslan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pə luvon a inde kutok, à alay a tinen à man sa pa way nà, a jan atan, a wa: «Kâ si zlen à Urəsalima wa bay. Njihen, hus pə ana Bəbay uno i slənak ikwen ahay way anahan sə zlapak ikwen anan ata awan. Na jak ikwen kurre biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yuhana kà gak anan baptisma anà ɗo ahay tə a'am, əna azanaka, Mbərom i gak ikwen baptisma nà, tə Apasay Cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","À alay a Yesu winen mə njahay a pə kərtek a tu ɗo maslan ahay nà, tə cəce panan wa, ta wa: «Ba Məduwen, ki man anan bahay à alay inde anà zahav sə Isəra'ila ahay aday ti lavay nga a tinen həna ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu a mbəɗahan atan apan, a wa: «Kwanay nà, alay sa 'am a kwanay uda sə gəzlan alay pi zek wa anà way ataya nà, ibay. Way ata i təra nə luvon wuraw, kabay à alay wuraw fok nà, wita nə zek a Mbərom sa ɗaf tə məgala anahan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Aya əna, Mbərom i naa slənak ikwen ahay Apasay anahan Cəncan a nà, ki njiɗen məgala sə ɗakay anan ləbara uno à Urəsalima, pə daliyugo sə Yahudiya tə Samariya awan, aday hus pə magaga sə daliyugo fok.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Natiya, pə dəɓa sa 'am anahan ata wa nà, Yesu a ján à mburom ì iɗe a tinen inde, aday matapasl a sərat apan sərdədek, tə canan sabay. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɗo maslan ataya nə tinen apan ti cak ayak iɗe à mburom həməcəcce hwiya. Kwayan'a ɗowan aya inde cew tə zana aya pi zek kweɗekkweɗek, tə sləray ahay pə cakay a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aday ta jan atan, ta wa: «Kwanay wan sə Galile ahay, kwanay apan ki cen ayak iɗe həməcəcce à mburom matanan nà, angamaw? Yesu nà, kà zlak pikwen wa à mburom. Aday kawa ana kwanay a sə cinen anan a zla həna ata nà, winen i naa may ahay ɗukwen, kətanan re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Natiya pə dəɓa anahan a wa kutok, ɗo maslan ataya tə dazay ahay à ɓəzlom sə Ulivet ata wa, ta may ahay à wulen su doh sə Urəsalima kutok. Man ata nà, dəren tə wulen su doh a bay, i ga nə way sə kilomiter kərtek ca. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tə dəzley ahay à wulen su doh sə Urəsalima nà, ta zla à man sə təfek a tinen, à sewene a tinen a sa taa njahay uda ata awan. Sləmay su ɗo ataya həna: Piyer, Yuhana, atə Yakuba tə Andəre, atə Filip tə Tomas, atə Bartilome tə Mata, Yakuba wan ana Alfa, Simon ɗo maniɗe sə Ruma ahay, aday Yuda wan ana Yakuba. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tinen ata fok, tatə uwar aya inde, tatə Mariyama may a Yesu, aday tə mərak a Yesu ahay, tinen a fok ta taa halay nga aday ta taa ga amboh pə kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","À alay ata nà, ɗo sa ɗaf nga pə Yesu ahay, tinen ti ga səkat tə kwa kuro cew (120). Aday pə luvon a inde kutok, Piyer a slabak à wulen a tinen inde, a jan atan, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Mərak ahay, way kawa ana Apasay Cəncan a sa ja à Deftere a Mbərom inde ata nà, təktek kə̀ tərak. Tə dungo ana bahay Dawuda, Apasay Cəncan a a ja 'am pə Yudas, ɗo sa ɗakay pa man a Yesu aday tâ ban anan ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aday abay cəkəbay Yudas a nà, ɗo kərtek à wulen a manay ɗo maslan ahay inde, winen ti mer su way a Yesu à alay inde cite re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudas aday nà, kə̀ njaɗak magwagway anga way anahan a sa ga lelibay ata awan. Anga nan, a zəɓa anan dala ata kutok, a zla, a sukom anan guvo. À guvo ata inde kutok, a slahay kup məbəburot, aday dinde ahay zərɗəɗ ahay uho. A mac à man ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Matanan, way a sə təra ata nà, ɗo sə Urəsalima ahay fok tə slənek apan, aday tə ngaman anà guvo anahan ata ta 'am su kon a tinen nà, Hakəldama, kawa sa ja ite nà, guvo sə mez. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piyer a ja asa, a wa: «Matanan, mə vinde a à Deftere Jabura inde, Mbərom a ja, a wa: “Doh anahan a nà, â təra rəgay. Ɗowan â sa njahay uda bay.” «Aday ma ja awan asa re, a wa: “Ɗo hinen â zəɓa anan mer su way anahan awan.” ");
INSERT INTO mqbNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Natiya, a zla pi zek kutok nà, gəɓuko ɗo kərtek à wulen a mənuko wa aday â təra ɗo maslan a Yesu à yime ana Yudas inde. Sumor a nà, winen ɗo sə pərahan azar anà Bahay a mənuko Yesu pə kərtek a tə manay kwa siwa siwa fok, ");
INSERT INTO mqbNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a ban kwa pə ana Yuhana sa gan baptisma wa, hus pə ananahan sa ján à mburom ata awan. Zəɓuko nà, ɗo matanan ata awan, anga i təra kawa mənuko, ɗo sə side aslabakay a Yesu à məke wa ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Natiya awan, ta kay anan ahay sləmay sə ɗo ahay cew: atə Yusufu, ɗowan a tə ngaman Barsabas kabay Yustus re ata awan, tə apan Matiyas. ");
INSERT INTO mqbNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ɗo maslan ataya ta ga amboh, ta wa: «Ba Məduwen, iken nà, ka san mivel a kuwaya zle fok. Ɗakan umo anan à wulen su ɗo a anaya cew aya nà, kə zəɓa wa nə waya ");
INSERT INTO mqbNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","aday i təra ɗo maslan anak, i ga anan mer su way ana Yudas sə mbəsak ata anaw. Anga Yudas kà zlak à man a mə lavay zek a anga winen ata kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pə dəɓa anahan a wa nà, ta kaɗ anjar sa ca apan, i slahay nə pə wayaw, aday anjar ata a kay anan, a slahay pə Matiyas. Winen a təra ɗo maslan mə slala kuro nga cew awan à yime ana Yudas inde kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Natiya, pə luvon sə azar uko ana Yahuda ahay sə ngaman Pentekosta ata nà, njavar a Yesu ahay tə halay nga à man kərtek awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kwayan'a, agungol a ndəray ahay à mburom wa, kawa vəvara məduwen awan, a rah anan doh a njavar ahay mə njahay uda ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tə canan anà awan aya kawa miresl sə uko, ta nay ahay, tə gəzla zek, tə njahay pa nga su ɗo a tinen ù doh ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Fok a tinen a, Apasay Cəncan a a rahan atan à mivel ahay inde, aday ta ma nga sa ja 'am su kon azar aya cara cara, kawa ana Apasay a Mbərom a sə varan atan məgala ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","À Urəsalima ata nà, Yahuda ahay inde bayak a tə ɗəfan apan à Mbərom lele, abay tinen mə njahay aya pu kon sə daliyugo ahay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tə sləne agungol ata cəna, tə halay nga à man su ɗo ataya awan. Aday way ata a gan atan wurdədəsdəssa, anga ɗo ataya tinen apan ti ja 'am nà, kuwaya a sləne ta 'am su kon anahan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Way ata a gan atan masuwayan. Anga nan ta ma nga sa ja, ta wa: «Ɗo anaya fok nà, tinen Galile ahay biɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aday ta ja 'am su kon a mənuko ahay fok nə kəkəmaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mənuko nà, ɗa nay ahay kwa à Partiya wa, à Mediya wa, à Elamiya wa. Mənuko ɗo sə njahay à Mesopotamiya ahay, à Yahudiya ahay, à Kapadosiya ahay, à Pontus ahay, à Aziya ahay, ");
INSERT INTO mqbNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","à Firigiya ahay, à Pamfiliya ahay, à Misra ahay, à Siren pə daliyugo sə Libiya ahay. Mənuko ɗo sa nay ahay kwa à Ruma wa, ");
INSERT INTO mqbNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ɗa nay ahay kwa à Kereta wa tə Arabiya wa re. À wulen a mənuko inde nà, azar su ɗo aya nə Yahuda ahay, aday azar aya ite nà, tinen Yahuda ahay bay, əna tə pərahan azar anà pəra sə Yahuda ahay. Aday mənuko fok ɗə sləne tinen apan ti ɗakay anan masuwayan a Mbərom sa ga ataya fok ta 'am a mənuko ahay nə kəkəmaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Way a sə təra ata a gan atan masuwayan, ta san ti ja nə maw bay fok. Ta ja à wulen a tinen inde, ta wa: «Way a həna anan ata nə masuwayan ɗuwuraw? A nan sa ja nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aya əna, azar su ɗo aya ta ma nga sə mbasay pu ɗo a Yesu ahay, ta wa: «Ɗo a anaya nə ta sak mahay, tə vawak nga.» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Natiya, pə dəɓa a wa kutok, Piyer tu ɗo maslan a kuro nga kərtek ataya fok tə slabak à wulen su ɗo ataya inde, aday Piyer a dazlan sa jan 'am anà ɗo ahay tə məgalak awan, a wa: «Kwanay Yahuda ahay tu ɗo sə njahay à Urəsalima a anaya awan, slənen anan 'am uno a anan lele, ni ɗakak ikwen anan ləbara sa 'am a anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kawa ana kwanay sə bayak nà, ɗo a anaya nə tə vawak nga. Əna cəkəbay matanan bay, anga həna nà, njamde dəsuɗo sə duwdew mba, alay sə vaway nga kà slak fan bay asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aya, way a anan a təra nà, kawa ana ɗo maja'am a Mbərom Yo'el sa ja, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Mbərom a ja nà: À luvon mədakwidok aya inde nà, ni slan Apasay uno à kuwaya inde fok. Wan a kwanay ahay tə dəna a kwanay ahay fok ti man anan 'am uno anà ɗo ahay. Njavar a kwanay ahay ti canan anà way uno sə ɗakan atan anan ataya awan. Məceɗ a kwanay ahay ɗukwen, ni jan atan 'am à cœn sə zuɓay inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ayaw, pə luvon ataya nà, ni slan Apasay uno ù ɗo si mer su way uno ahay inde, â ga nə mungol awan, â ga nə dəna awan, ti man anan 'am uno anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ni ga way masuwayan aya à mburom, aday pə daliyugo ɗukwen, mez i pak, uko tə jinjek ti kay ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pac i dav sabay, aday kiya ɗukwen i mbəɗahan sa ca nà, nduzzo kawa mez. Way ataya tə tərak nà, luvon ana Bahay a mənuko i saa may ata, i dəzley ahay bəse kutok. Luvon ata nà, məduwen a aday tə mazlaɓ a re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Matanan, kuwaya ɗowan a kə̀ ɗəfak nga pə sləmay ana Mbərom Fetek cəna, i tam.”» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyer a ja asa, a wa: «Kwanay Isəra'ila ahay, slənen 'am uno a anan lele aday. Yesu ɗo sə Nazaratu ata nà, ɗa san zle, winen ɗo a Mbərom sə slənay ahay, anga Mbərom a kà gak masuwayan ahay cara cara à wulen a kwanay inde tə alay a Yesu ata awan. Kwanay kə sənen apan zle lele re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Mbərom a varak ikwen anan Yesu, kawa anahan sə lavay a zek kwakwa ata awan. Aday a san zle, kwanay ɗukwen kə viren anan anan à alay inde anà ɗo sə atahasl ahay, ti darak anan ayak pə dədom mə zləlngaɗ awan, kawa ana kwanay sa ga anan həna ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Əna Mbərom kə̀ slabakak anan ahay à məke wa, winen inde tə sifa awan. Kə̀ təmak anan Yesu à ɗəce sə amac wa, anga amac nà, məgala anahan inde sa ban anan ibay. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","«Matanan Dawuda kà jak pə Yesu, a wa: “Nə canan anà Mbərom Fetek pac pac winen inde pə cakay uno. Winen mə njahay a tə alay puway uno. Anga nan, ni jəjar sabay. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Matanan, mivel uno həna nà, ma rah a tə ataslay mivel awan, nen apan ni təɓa 'am sa ga ara tə ambasay awan. Kwa nə məcak təkeɗe nà, nen ni ɗəfak iɗe hwiya, ");
INSERT INTO mqbNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","anga iken ki mbəsak nen à məke inde bay, ki mbəsak anan zek uno â wuslay à məke inde bay, nen ɗo anak cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kə ɗakak uno pə cəveɗ sa njaɗ sifa. Ki vuro ataslay mivel bayak a pə cakay anak.” ");
INSERT INTO mqbNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Mərak ahay, ɗa san apan zle, bije a mənuko Dawuda ata nà, kə̀ məcak aday ta lak anan. Jəvay anahan a ɗukwen inde, ɗa san man a zle re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Winen nà, ɗo maja'am a Mbərom. Anga nan, a san apan zle re, ɓa Mbərom kə̀ zlapak anan anan ta sa jan nà, i naa ɗaf wan sə kutov anahan à bahay anahan inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawuda ɗukwen a san apan zle Almasihu nà, i slabakay ahay à məke wa. Anga nan, a wa: “Iken Mbərom nà, ki mbəsak nen à məke inde bay, ki mbəsak anan zek uno â wuslay à məke inde bay.”» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Piyer a ja asa re: «Yesu nà, Mbərom kə̀ slabakak anan ahay à məke wa. Manay a fok ma san apan zle, manay ɗo sə canan njœk tə iɗe a manay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mbərom kə̀ zəɓak anan ayak anga sə njahay tə alay puway anahan awan. Yesu a təma Apasay Cəncan a pə Bəbay anahan wa, kawa ana Bəbay anahan sə zlapay anan ata awan. Winen ɗukwen kə̀ varak umo ahay Apasay ata re. Natiya kutok, way a kwanay sə sləne ta sə canan a anan fok, sa ga mer su way ata nà, winen awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aya, Dawuda nà, kə̀ jənak à man a Mbərom itəbay. Əna winen a a wa: “Mbərom Fetek a jan anà Bahay uno nà: Njahay tə day sə alay puway uno, ");
INSERT INTO mqbNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","aday ɗo maniɗe anak ahay fok nà, ni təra atan ɓile anak aya awan.” ");
INSERT INTO mqbNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Anga nan, kwanay Isəra'ila ahay fok, sənen anan tə ɗiɗek awan: Yesu ɗowan a kwanay sa vaɗ anan ta sə daray anan pə dədom mə zləlngaɗ ata nà, Mbərom a təra anan Bahay a nuko awan aday Almasihu re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ɗo ataya tə sləne 'am ata fok cəna, mbac a slahay patan wa. Anga nan tə cəce pə Piyer tu ɗo maslan ataya wa, ta wa: «Mâ ga həna jiya nə kəmaw, mərak ahay?» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer a mbəɗahan atan apan, a wa: «Mbəɗihen anan lœn anà ines a kwanay ahay, təmihen sa ga baptisma anga sə təra ɗo a Yesu Almasihu ahay, aday Mbərom i pəsek ikwen anan ines a kwanay ahay, i varak ikwen Apasay anahan Cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mbərom kə̀ zlapak sə varak ikwen Apasay anahan Cəncan ata nà, a zlapan anan anà ɗo ahay aday winen saa ngaman atan, saa pərahan azar ataya fok re, kawa sa ja nà, anà kwanay tə wan sə kutov a kwanay ahay, aday anà ɗo su kon dəren aya fok re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyer a jan atan 'am a azar aya bayak asa. A nan nà, tə̂ təma 'am ata awan, aday tâ sa ya nga bay re. A jan atan asa re, a wa: «Kwanay, mbəsiken anan ɗo a wuswes a anaya awan, təmen zek a kwanay ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɗo ahay bayak a tə təmahak 'am ana Piyer ata awan, tə təmahak sa ga baptisma. Pə luvon ata nà, ɗo a Yesu ahay tə zəgahak anan apan njavar a Yesu ahay, ti ga way sə mbulo maakan. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pac pac tinen apan ti halay nga sə tətak way pu ɗo maslan a Yesu ahay wa, ti gəzla pen tə sləmay a Yesu, ti ga amboh. Tə njahay pə kərtek awan, à asan zek inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ɗo a Yesu ahay fok tə jəjaran anà Mbərom lele, aday Mbərom a ga masuwayan ahay bayak a cara cara tə alay ana ɗo maslan a Yesu ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tinen a fok 'am a tinen kərtek, way a tinen ɗukwen mə japay pə kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tə sukom a way tə way a tinen, tə guvo a tinen ahay, tə japay anan dala awan, aday tə varan anà kuwaya fok nà, kawa anahan sa gan may. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pac pac fok, tinen apan ti halay nga pə kərtek awan ù doh sə mazlaɓ a Mbərom. Tinen apan ti halan nga anà way sa pa a tinen ahay pə kərtek a àga tinen aya awan. Tinen apan ti pa way a tinen ahay pə kərtek awan, tə ataslay mivel aya awan, aday tə mivel kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tinen apan ti həran nga anà Mbərom, ta zlan à nga anà ɗo ahay fok. Aday ɗo ahay tinen apan ti tam pac pac fok, Bahay Yesu winen apan i zəgahan atan anan apan ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pa pac a inde, atə Piyer tə Yuhana ta zla ù doh sə mazlaɓ a Mbərom. Ta zla nə tə njamde maakan, alay a ɗo ahay sa taa ga amboh ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tinen apan ti dəzle à məsudoh su doh sə mazlaɓ a Mbərom inde sə ngaman Mə-Rəɓa-Awan ata nà, ta tan ayak à nga anà ɗowan a inde mə təra à məndak awan, kwa sə wahay anahan. Ta taa zəɓak anan ayak nə pac pac, anga aday i dubok way pu ɗo sa zla ù doh sə mazlaɓ a Mbərom ahay wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ɗowan ata a canan anà atə Piyer tə Yuhana tinen apan ti zla ù doh cite nà, a dubok patan wa dala. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Atə Piyer tə Yuhana tə zəzor anan, aday Piyer a jan, a wa: «Ca pumo lele.» ");
INSERT INTO mqbNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɗowan ata a zəzor atan lele. Winen a bayak i ga nà, ti varan dala. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyer a jan, a wa: «Dala nà, inde upo ibay. Əna way a həna inde upo ata nà, ni varak anan. Na jak nà, tə sləmay a Yesu Almasihu, ɗo sə Nazaratu, slabak, zla tə saray anak!» ");
INSERT INTO mqbNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piyer a bənan anan alay puway, a man zek sə slabak. Kwayan'a saray anahan ahay tə ndarkwaslak anahan ahay ta njaɗ məgala. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A slabak hərom, a dazlan sa bar. Ta zla ù doh sə mazlaɓ a Mbərom tatə Piyer tə Yuhana, winen apan i zla, winen apan i dazay à mburom kwerkwer, winen apan i zambaɗ anan Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Winen apan i zla, i zambaɗ anan Mbərom ata nà, ɗo ahay fok tə canak anan, ");
INSERT INTO mqbNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","aday tə sənak anan kutok. Ta wa: «Winen nà, ɗowan mə təra à məndak ata sa taa dubok way pə ɗo ahay wa pə məsudoh sə ngaman Mə-Rəɓa-Awan ata awan.» Natiya awan, way ata a gan atan hərɓəɓəkka tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɗowan ata, winen pə cakay ana atə Piyer tə Yuhana hwiya, ɗo sa man ataya fok ta ma nga sa haw pə cakay a tinen à man a sə ngaman «Vo galak ana Sulimanu» ata awan, anga way sə təra ata a gan masuwayan anà ɗo ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piyer a canan atan cəna, a jan atan, a wa: «Kwanay Isəra'ila ahay, way ata a gak ikwen masuwayan nə angamaw? Aday ki cen pumo hwiya nden'e nà, angamaw? Kwanay kə bayiken ɗowan a anan a mbar nà, anga məgala a manay, kabay anga mə ɗəfan apan anà Mbərom lele ata ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mbərom ana Ibərahima, tə ana Isiyaku tə ana Yakob, Mbərom ana bije a nuko ataya sə ɗəfan apan ata awan, anga sə varan mazlaɓ anà Yesu, ɗo si mer su way anahan, Mbərom kə̀ mbərak anan ɗowan a anan. Kwanay nà, kə viren anan anan à alay inde anà Ruma ahay, anga aday tâ vaɗ anan. Kwa abay Pilatu a gan may sə mbəsak anan ɗukwen, kwanay kə ngəmen â mbəsak anan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Winen nà, ɗo cəncan awan, ɗo ɗiɗek awan, əna kə ngəmen aday Pilatu â mbəsakay anan ahay bay. Ki gen anan kem anà Pilatu bugol nà, â mbəsakak ikwen anan ahay ɗo a sa vaɗ nga su ɗo ata aɗəka. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kə vəɗen anan ɗo sə varan sifa anà way ahay fok ata à məke sa ndaw, əna Mbərom kə̀ slabakak anan ahay à məke wa. Manay ɗukwen mi mba apan sa ra ambar sa 'am a anan təte. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ɗowan həna anan nà, kwanay a fok kə cinen anan, aday kə sənen anan zle, winen a mbar nà, anga kə̀ ɗəfak nga pə sləmay a Yesu. Sa mbar anan jiga nà, sləmay a Yesu, anga ɗowan a anan kə̀ ɗəfak apan nga. Kwanay a fok, ki cinen anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ayaw, mərak uno ahay, na san zle, ki gen anan way ataya anà Yesu nà, anga kə sənen ɗiɗek bay. Bahay a kwanay ahay ɗukwen ta san ɗiɗek bay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Əna way ata a ga zek matanan nà, anga ɓa Mbərom kà jak anan tə dungo ana ɗo maja'am anahan ahay kwakwa, ta sa ja təktek Almasihu anahan saa slənak ikwen ahay ata â ga ɗəce. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Həna aɗəka nà, mbəɗihen anan lœn anà ines a kwanay ahay, men anan ù vo anà Mbərom, aday Mbərom i pəsek ikwen anan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aday Bahay Mbərom i varak ikwen zay, ta sə slənak ikwen ahay Yesu, winen Almasihu a Mbərom sə lavay anan zek anga kwanay kurre ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ayaw, həna ata nà, Yesu Almasihu nà, i njahay à mburom à man ata tamak, hus i dəzle pə luvon a Mbərom saa mbəɗa anan way ahay fok wiya aya kawa ana ɗo maja'am anahan cəncan aya sa ja apan ata aday. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa a ja nà: “Mbərom Bahay a kwanay i naa varak ikwen ɗo maja'am hinen kawa nen à wulen ana zahav a kwanay a wa. Kə̂ təmihen anan anan 'am anahan saa jak ikwen ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɗowan a kə̀ təmahak anan anan 'am anahan itəbay ata nà, Mbərom i lize anan à mamasl su ɗo anahan ahay wa.”» ");
INSERT INTO mqbNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Piyer a pərahan anan azar sa ja, a wa: «Ɗo maja'am a Mbərom ahay kwakwa, a bənay ahay kwa pə Samiyel wa hus pu ɗo maja'am a Mbərom azar aya, fok a tinen a kərtek tə kərtek ta jak 'am pə way a sə təra pə luvon a anan ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ɗo maja'am a Mbərom ataya ta ja way ataya pə kwanay awan, aday Mbərom kə̀ ɓanak 'am tə bije a kwanay ahay anga kwanay a re. A jan anà Ibərahima nà: “Tə alay ana wan sə kutov anak ahay, ni ɗaf alay sə mazlaɓ uno pu ɗo su kon ahay fok.” ");
INSERT INTO mqbNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Matanan kutok, Mbərom a lah sə slənay anan ahay Yesu, ɗo si mer su way anahan nà, anà kwanay awan, anga aday â ɗaf pikwen alay sə mazlaɓ anahan ta sa may ahay kwanay à cəveɗ sə huwan a kwanay ahay wa.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","À alay a Piyer tə Yuhana tinen apan ti jan 'am anà ɗo ahay mba, ɗo sə gəɗan dungo anà way ahay pi zek tə bahay su ɗo sa ba doh sə mazlaɓ a Mbərom, aday tə Saduki ahay, ta zla à man a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ta ma nga sa ga patan mivel, anga atə Piyer tə Yuhana nà, tinen apan ti ɗakan anan anà ɗo ahay nə Yesu kə̀ slabakak ahay à məke wa. Matanan, ɗo ma mac aya ɗukwen, ti naa slabakay ahay à məke wa tə sifa aya re. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Anga nan kutok, ta ban anan ɗo maslan ataya awan, tə tacay atan à dangay, hus sa ca pa 'am sə sariya nə sidew awan, bina suko kà gak coy re. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aya əna, ɗo ahay bayak a à wulen su ɗo sə sləne 'am a Piyer ataya wa tə təmahak 'am ana ɗo maslan ataya awan, tə ɗəfak nga pə Yesu. Ɗo ataya tə zəgahak anan ɗo ana Yesu ahay. Tə baslay mungol ahay ɗəkɗek, tinen mbulo ɗara kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iɗe a cəɗe sidew a nà, bahay sə Yahuda ahay pi zek tə məceɗ sə Yahuda ahay aday tə miter sə Tawrita ahay tə halay nga à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Atə Anas, bahay nga su ɗo sə gəɗan dungo anà way ahay, tatə Kayafas, Yuhana, Aleksandire aday tə azar su ɗo ana Anas ahay, inde à wulen a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tə ngaman anà ɗo maslan a cew ataya pa 'am a tinen, aday tə cəce patan wa, ta wa: «Kə mbəren anan ɗowan a mə təra à məndak ata nà, tə məgala wuraw, kabay tə sləmay a wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Cəna Apasay Cəncan a a zlan à mivel inde anà Piyer, a mbəɗahan atan apan, a wa: «Kwanay bahay ahay tə məceɗ ahay, ");
INSERT INTO mqbNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","manay həna pa 'am a kwanay nà, anga sumor a manay sa ga ta sa mbar anan ɗowan a vədal a anan ata bugol biɗaw? A nak ikwen sa san nà, kə̀ mbərak tə məgala sə sləmay a wayaw ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kak matanan nà, kwanay tə Isəra'ila ahay fok, sənen anan kutok: Ɗowan a həna anan mə tavay a pa 'am a kwanay kə̀ mbərak nà, anga məgala sə sləmay ana Yesu Almasihu, ɗo sə Nazaratu. Winen nà, kə vəɗen anan pə dədom mə zləlngaɗ awan, əna Mbərom kə̀ slabakak anan ahay à məke wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Natiya, Deftere a Mbərom a ja 'am həna anan ata nə pə winen awan, a wa: “Kon mbala ana ɗo sa ɗezl way ahay sa lar anan ata nà, sə təra kon sə mide lele aɗəka nà, winen.” ");
INSERT INTO mqbNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Ɗo sa mba apan sa tam ɗo ahay miza nà, ibay, si Yesu a kərtek. Bina sləmay inde maza pə daliyugo sa mba apan sa tam mənuko uwec wa mbala ana ɗo ana Mbərom sə varak uko ahay ata nà, ibay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","'Am ana Piyer ata a gan masuwayan anà ɗo mə halay nga ataya awan, anga ta ca apan ɗo maslan a cew ataya nà, ɗo məduwen aya bay, aday mə jangay aya bay re, əna tə jəjar sə mbəɗahan atan apan bay re. Aday ɗo ataya tə sənak ɗo maslan ataya tə njahak pə kərtek a tə Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Əna tinen apan ti ca pə ɗowan a ma mbar ata winen inde zay mə tavay a pə cakay ana ɗo maslan a cew ataya awan. Anga nan, ta mbak apan sə mbəɗahan atan apan awan a ibay jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Matanan, ta ma anan ɗo maslan a cew ataya uho tamak, kutok tinen tə mbəɗek sa vaɗ uway pa 'am ata à wulen a tinen inde aday. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ta wa: «Ɗo a anaya həna jiya nà, ɗi ga atan kəmaw? Ɗo sə Urəsalima a anan ataya fok tə sənak pə masuwayan a məduwen a tinen sa ga anan ata lele coy. Aday mənuko ɗukwen, ɗi mba apan sə məman anan nà, i ga zek bay re asa. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Aya həna nà, ɗi ngaman atan ayak, aday ɗi gafan atan 'am, tâ saa ma apan sa jan 'am tə sləmay a Yesu anà ɗowan sabay. Ata kutok nà, ləbara sa 'am a tinen ata i ta 'am bay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tə ngaman atan ayak asa, ta jan atan, ta wa: «Mbəsiken sa jan 'am tə sləmay a Yesu aday sə ɗakan anan ləbara sa 'am ana Yesu anà ɗo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aya əna, atə Piyer tə Yuhana tə mbəɗahan atan apan, ta wa: «Ənga, kwanay a bayiken apan lele aday, təɗe saa zlan à nga anà Mbərom nə maw? Təɗe sə ɗəfan apan nə anà Mbərom a ɗaw, kabay lele nà, sə ɗəfak ikwen apan anà kwanay bugol aɗəka ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Manay nà, way a manay sə canan ta sə sləne fok cəna, mi ɗakay anan, bina mi mba apan sə njahay way a manay bay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pə dəɓa anahan a wa nà, ɗo sa gan atan sariya ataya tə ngəraz patan anga aday tə̂ njahay way a tinen, tə mbəsakay atan ahay kutok. Tə sənak sa jəka ti kəta atan kəkəmaw bay, bina ɗo ahay fok tinen apan ti həran nga anà Mbərom anga way anahan a sa gan anà ɗowan a vədal ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ava ana ɗowan a tinen sa mbar anan tə masuwayan ata nà, a zalay kwa kuro fuɗo. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pə dəɓa a sə mbəsakay atan ahay ata nà, atə Piyer tə Yuhana ta ma pə cakay ana ɗo a tinen ahay, tə təkəren atan anan way ana bahay sə gəɗan dungo anà way ahay tə məceɗ ahay sa jan atan ata fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ɗo a tinen ataya tə sləne anan 'am ata nà, tinen a fok ta ma nga sa gan amboh anà Mbərom tə mivel kərtek awan, ta wa: «Ayaw, Bahay a manay, iken ɗo sə ndakay bagəbaga mburom tə daliyugo tə bəlay ahay, aday tə way a uda ataya təke fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iken awan ka jak 'am tə dungo ana ɗo si mer su way anak Dawuda, winen bije a manay awan. Apasay anak Cəncan a kà jak à winen inde, a wa: “Ɗo su kon azar aya ti ga mivel, aday ɗo sə pəra ahay ti jəjem 'am kəriya nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bahay sə daliyugo ahay tinen apan ti ndire zek, aday ɗo sə lavan nga anà ɗo ahay ahay tinen apan ti lavan zek anà vəram tə Mbərom Fetek aday tə Almasihu anahan.” ");
INSERT INTO mqbNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Ayaw, way ata matanan acəkan, anga həna kutok nà, Hiridus tatə Pontiyos Pilatu, tə halay nga à wulen su doh a anan inde tə Ruma ahay tə Isəra'ila aya awan, anga sa ɓan 'am pə Yesu ɗo si mer su way anak cəncan a, iken sə walay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iken nà, məgala awan. Natiya, way a tinen sa ga fok nà, way kawa ananak a sa gan may kurre ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Həna kutok, Ba Məduwen, sləne way a tinen sa ja ti gan umo ataya awan. Kem, varan məgala anà ɗo si mer su way anak ahay sa ja 'am anak mənjəna ajəjar. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Varan umo gədan sa mbar anan ɗo sə ɗəvac ahay ta sa ga masuwayan ahay cara cara tə məgala sə sləmay a Yesu, ɗo si mer su way anak cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pə dəɓa sa ndav anan amboh a tinen ata wa nà, man a tinen ata a ɓal kəzlek kəzlek. Tinen a fok tə njaɗak məgala sə ɗakay anan 'am a Mbərom mənjəna sə jəjar, anga Apasay Cəncan a kə̀ rahak atan à mivel inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɗo a Yesu ataya fok nà, mivel a tinen a kərtek, abayak nga a tinen ahay kərtek a re. Tə japay anan zlile a tinen pə kərtek awan. Ɗowan sa jəka «zlile uno anuno taayak» nà, ibay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tə məgala a bayak a, ɗo maslan ataya tə pərahan azar sə ɗakay anan, tə canak anan Yesu kə̀ slabakak ahay à məke wa. Mbərom kà gak atan sumor bayak awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ɗowan mətawak a à mamasl a tinen nà, inde sabay fok, bina ɗo aday guvo anahan inde kabay doh anahan inde ataya fok, tə sukom a way, ta nay anan dala awan ");
INSERT INTO mqbNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","anà ɗo maslan ahay, aday tinen tə varan anà kuwaya pə ananahan sa gan may. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ɗowan a inde ite, tə ngaman Yusufu, winen pə slala ana Lewi, a njahay pə daliyugo sə Kiprus. Sləmay anahan hinen nà, Barnabas, kawa sa ja nà, ɗo sə varan məgala anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Winen ɗukwen, guvo anahan inde re, a sukom a way, a nay anan dala awan, a varan anan anà ɗo maslan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɗowan a inde asa tə ngaman Ananiyas tə uwar anahan Safira, tə sukom anan way tə guvo a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tinen a ta pak 'am ahay ì zek. Ananiyas a ra pə dala wa məcak, a ndakay apan man. Azar a kutok a zla anan à man ana ɗo maslan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A dəzlek anan ayak cəna, Piyer a jan, a wa: «Ananiyas! Kə mbəsakan anan mivel anak anà Fakalaw angamaw? Anga həna nà, kə gəɗak anan mungwalay anà Apasay Cəncan awan. Ka rak ayak pə dala sə guvo a kwanay wa məcak agay nà, angamaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Guvo a nà, guvo anak awan. Kə sukumak anan way ɗukwen, dala nà, ananak a re. Əna kə jalay sa ga way lelibay a matanan nà, angamaw? Kə gəɗan mungwalay ata nà, anà ɗo zənzen a bay, əna anà zek a Mbərom awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pə dəɓa sə sləne 'am ata wa cəna, Ananiyas a slahay à məndak, aday a mac kwayan'a. Ɗo sə sləne ləbara sa 'am ataya fok nà, mbac kə̀ slahak patan wa, ta ma nga sə jəjar. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pə dəɓa anahan a wa nà, njavar ahay ta zlak ayak ù doh, ta nga apan rəkot, ta nay anan uho saa la anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A njahay pə dəɓa wa way sə ler maakan nà, uwar anahan Safira ɗukwen kà zlak ayak ite. Winen kə̀ sənak pə way a sə təra tə mbaz anahan ata bay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Uwar ata a dəzlek ayak ù doh cəna, Piyer a cəce panan, a wa: «Uwar a anan, ənga, jan umo aday. Kə sukumen anan way tə guvo a kwanay nà, dala a nə kawa winen a anan dəp ɗaw?» Uwar ata a mbəɗa apan, a wa: «Ayaw, dala a nà, matanan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyer a jan asa, a wa: «Mazar! Kwanay tə mbaz anak kə jipen 'am a kwanay kərtek sə njəkan uda anà Apasay a Bahay Yesu nà, angamaw? Ənga, cak ayak apan, ɗo sa la anan mbaz anak ahay, tinen uho. Kagasl, ti naa zəɓak ayak iken saa la cite.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pə dəɓa ana 'am ata wa cəna, uwar ata a slahay à məndak, aday a mac. Njavar ahay ta nay ù doh, tə zəɓa məsinde, ta lak anan ayak pə cakay ana mbaz anahan. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ɗo a Yesu ahay fok tu ɗo sə sləne anan ləbara sa 'am ata fok nà, ta ma nga sə jəjar. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɗo maslan ahay nà, ta taa ga mer su way masuwayan aya bayak a à wulen sə ɗo ahay inde. Ɗo a Yesu ahay fok ta taa halay nga ù vo sə galak ana Sulimanu inde à gala su doh sə mazlaɓ a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Əna, kwa abay ɗo ahay tinen apan ti ja patan ta sa ja nà, tinen ɗo lele aya ɗukwen, ɗo a azar aya sə ɗəfan apan anà Yesu bay ataya ta ngam sə njahay pə cakay a tinen bay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tə winen ata təke ɗukwen, ɗo ahay tinen apan ti ɗaf nga pə Bahay Yesu hwiya. Ɗo a Yesu ahay tinen apan ti zəga apan nà, pac pac, mungol tə uwar aya təke fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ɗo ahay tə sləne 'am sə masuwayan ana ɗo maslan ataya sa ga ata kutok. Anga nan, ta ma nga sa zla anan ɗo sə ɗəvac a tinen ahay pə cəveɗ ahay, tə nahay atan pə biket kabay pə lala, anga tinen tə bayak nà, hinahibay Piyer i zla ta man ata nə, mezeze anahan a â njaɗ sə laman anà ɗo sə ɗəvac a tinen azar aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ɗo maza aya ite ta nay anan ahay tu ɗo sə ɗəvac a tinen ahay kwa à wulen su doh a azar aya sa mban anà Urəsalima ataya wa. Ta nay anan ahay tu ɗo a tinen ɗəvac aya awan, tu ɗo a setene sa taa vawan atan nga ataya fok. Ta nan atan anan ahay, aday fok a tinen a tə mbərak. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Natiya kutok, bahay nga su ɗo sə gəɗan dungo anà way ahay, tu ɗo anahan ahay tinen à wulen sə Saduki ahay ataya fok nà, ta ma nga sə jugwar 'am pu ɗo maslan a Yesu ahay wa, ta ga patan sərak. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Cəna, ta ban anan ɗo maslan a Yesu ataya, aday tə ɗəfak atan ayak à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aya əna, cəkəbay, à luvon ata inde nə, maslay a Mbərom a nay ahay, a təɓa anan məsudoh sə dangay ata awan, aday a nay anan ahay ɗo maslan ataya uho. A jan atan kutok, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Həna nà, zlen à gala su doh sə mazlaɓ a Mbərom, aday kâ sa ɗiken anan ləbara sə sifa wiya a anan fok anà ɗo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɗo maslan ataya tə təmahak 'am ana maslay a Mbərom ata awan, tə wule sə duwdew à gala su doh sə mazlaɓ a Mbərom kutok. Ta zlak ayak nà, tinen gədek anan azar sə tətakan anan way anà ɗo ahay. Pə dəɓa wa mənjœk, bahay nga su ɗo sə gəɗan dungo anà way ahay, tu ɗo anahan ahay tə dəzlek ayak cəna, tə ngaman ayak anà ɗo sə lavan nga anà Yahuda ahay, kawa sa ja nà, məceɗ sə Isəra'ila ahay fok. Aday kutok, ta slan suje ahay pu ɗo maslan ataya à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Suje ahay tə dəzle ù doh sə dangay nà, ta tak anan ayak à nga anà ɗo maslan ataya à man ata sabay. Cəna, ta may ahay pə dəɓa à dangay wa, ta nay, ta jan anà ɗo mə halay nga ataya awan, ta wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Manay ma zlak ù doh sə dangay kawa ana kwanay sa jan umo ata acəkan, əna ma tan ayak à nga anà məsudoh nà, mə tacay awan, aday ɗo sa ba patan ataya ɗukwen, tinen cekərkərre tə iɗe, tinen apan ti ba re. Mə təɓa anan məsudoh, ma zla ù doh sə dangay nà, ma tak anan ayak à nga anà ɗowan à man ata bay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ɗo sə lavan nga anà suje sa ba pu doh sə mazlaɓ a Mbərom, tə bahay sə gəɗan dungo anà way ahay, tə sləne ləbara sa 'am ata matanan cəna, a wusen atan nga. Ta ma nga sə cəce pi zek a tinen aya wa, ta sa jan ì zek ahay nà: «Way a anan a ga matanan ata nà, aday ma sə təra tu ɗo a anaya awan anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pə dəɓa anahan a wa nà, ɗowan a inde a nay ahay, a jan atan nà: «Ɗowan a kwanay sə tacak atan ayak à dangay ataya nà, tinen à gala su doh sə mazlaɓ a Mbərom, tinen apan ti tətakan anan way anà ɗo ahay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Cəna, bahay sə suje ahay a zla patan tu ɗo anahan ahay saa bənay atan ahay. Əna ta nay atan nə tə gədan a bay, anga tinen a ɗukwen tə jəjaran anà man su ɗo awan, ta sə bayak nà, hinahibay ɗo ahay ti i tar atan tu kon. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ta nay atan ahay ɗo maslan ataya kutok, aday tə tavay atan pa 'am sə məceɗ sə Yahuda ahay. Bahay nga su ɗo sə gəɗan dungo anà way ahay a cəce patan wa kutok, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Manay nà, mə gafak ikwen 'am lele ta sa jak ikwen nà, kâ sa tətiken anan anan way anà ɗo ahay tə sləmay ana ɗowan ata sabay. Əna hwiya kə mbəsiken bay. Həna, wulen su doh sə Urəsalima nà, 'am ata kà tak uda 'am coy. Natiya, tə way a kwanay sa ga ata nà, a nak ikwen sa ja nə 'am sə amac anahan ata nə pa nga a manay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyer tu ɗo maslan a azar ataya tə mbəɗahan atan apan, ta wa: «Sumor a nà, mə̂ ɗəfan apan bugol nə anà Mbərom, bina anà ɗo zənzen a bugol ɗaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kwanay nà, kə vəɗen anan Yesu ta sə daray anan pə dədom mə zləlngaɗ awan. Əna pə dəɓa anahan a wa nà, Mbərom ɗo ana bije a mənuko ahay sə ɗəfan apan ata kə̀ slabakak anan ahay à məke wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mbərom nà, kə̀ varak anan mazlaɓ, kə̀ ɗəfak anan tə day sə alay puway anahan, kə̀ tərak anan bahay awan, ɗo sa tam ɗo, anga aday â ɗakan anan anà Isəra'ila ahay cəveɗ sə mbəɗahan lœn anà ines a tinen ahay aday i pəsen atan anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Manay apan mi side anan, aday Apasay Cəncan a i side anan re. Winen nà, Mbərom a varan anan anà ɗo sə ɗəfan apan ataya awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ɗo mə halay nga à man sa ga sariya ataya tə sləne 'am ata cəna, ta ga patan mivel tə mindel. A nan atan sa vaɗ anan ɗo maslan ataya à məke. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aya əna, ɗowan a inde à wulen a tinen awan, a slabak. Ɗowan ata nà, tə ngaman Gamaliyel, winen Farisa ahay, aday winen miter sə Tawrita a re. Ɗo ahay fok tə jəjaran deeɓ deeɓ. A jan anà ɗo ahay, a wa: «Ənga, mbəsiken anan ɗo maslan a anaya tâ zla uho mənjœk aday.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pə dəɓa ana ɗo maslan ahay sa nay uho ata nà, a jan anà ɗo ataya kutok, a wa: «Kwanay Isəra'ila ahay, gen anan ngatay anà way a kwanay a saa gan anà ɗo a anaya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Anga kə̀ njahak bayak a bay, ɗowan a inde tə ngaman Tudas, kà nak ahay, a jan anà ɗo ahay nà, winen bahay məduwen awan. Aday ɗo ahay ti ga səkat fuɗo tə pərahak anan azar. Pə dəɓa anahan a wa nà, tə vəɗak anan, ɗo sə pərahan azar ahay fok ta tak 'am, aday ləbara sa 'am anahan inde həna sabay. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«Pə dəɓa wita wa asa ɗukwen nà, ɗowan a sə ngaman Yudas winen ɗo sə Galile ahay ata, a nay ahay à alay a sə baslay anan sləmay sə ɗo ahay pə daliyugo ata awan. Winen ɗukwen, kà rak ɗo ahay bayak a pi zek, tə pərahak anan azar. Pə dəɓa a wa, ta vaɗ anan ɗukwen, ɗo sə pərahan azar ataya ta tak 'am səret fok re. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","«Anga nan, nen apan ni jak ikwen way inde kərtek həna: Mbəsiken anan ɗo a anaya awan tâ zla way a tinen. Ɗowan â sa gan atan awan bay fok. Kak mer su way a tinen a sa ga anan ataya, ta nay à nga su ɗo zənzen a wa, mer su way a tinen ataya ti lize asəka, ti dəzle anan jo à man a bay! ");
INSERT INTO mqbNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Aya əna, kak ta ga mer su way a Mbərom acəkan nà, ki mben apan sə lize anan 'am a anan tətibay re. Matanan, gen ngatay aday, bina hinahibay ki sa gen məgəzləga ti zek a Mbərom awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Natiya, ɗo mə halay nga sa ga sariya ataya, tə təma 'am ana Gamaliyel ata awan. Tə ngaman ayak anà ɗo maslan ataya ù doh miza awan, tə ndaɓay atan, tə gafan atan 'am ta sa ja nà: «Kâ si jen anan 'am anà ɗo ahay tə sləmay a Yesu sabay fok.» Tə mbəsak atan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɗo maslan ahay ta nay ahay à wulen su ɗo ataya wa tə ataslay mivel awan, anga Mbərom a ca patan, ta slak aday ɗo ahay tə̂ pəkan atan waray ì iɗe, tâ ga atan alay anga sləmay a Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tinen bine siwaw nà, pac pac fok, ta zla à gala su doh sə mazlaɓ a Mbərom aday à gulom su doh sə ɗo ahay re, tinen apan ti wazay, ti ɗakan anan anà ɗo ahay nà, ləbara mugom a sa ja nə Yesu winen Almasihu ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","À alay ata kutok nà, abaslay su ɗo sə pərahan azar anà Yesu ahay kə̀ zəgahak apan bayak awan. Aday acakal 'am kə̀ zəɓak ahay à wulen ana ɗo sa ɗaf nga pə Yesu ahay tinen sa ja 'am sə Gərek ahay tu ɗo sa ja 'am sə Ibəraninko ahay ata awan. Ɗo sa ja 'am sə Gərek ataya ta wa: «Pac pac, à man sə gəzla way sa pa nà, mədukway sə uwar a manay ahay ta njaɗ awan itəbay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anga nan kutok, ɗo maslan ataya tə halan nga anà ɗo sa ɗaf nga pə Yesu ahay fok, aday ta jan atan, ta wa: «A zla pi zek manay mi mbəsak mer su way sə ɗakay anan 'am a Mbərom bay. Mi mbəɗek pi mer su way sə gəzlan way sa pa anà ɗo ahay nà, i ga zek bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Anga nan, mərak ahay, wilen ɗo ahay cuwɓe à wulen a kwanay wa, tinen ɗo ma rah Apasay a Mbərom aya awan, ɗo sə kəlire ahay aday ma ndar sləmay aya re. Ɗi mbəsakan anan mer su way sə gəzla way sa pa nà, anà tinen kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aday manay mi ga amboh, mi ɗakay anan 'am a Mbərom tə fefəne kutok.» ");
INSERT INTO mqbNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","'Am ata kà zlak anan à nga anà ɗo a Yesu ahay fok. Matanan, tə walay Etiyen, winen ɗo sa ɗaf nga pə Yesu lele aday ma rah a tə Apasay Cəncan a re. Asa tə walay apan atə Filip, Porokoros, Nikanor, Timon, Parmenas tə apan Nikola, winen ɗo sə wulen su doh sə Antakiya. Abay winen nà, ɗo sə pəra əna ɓa kə̀ təmahak sə pərahan azar anà Tawrita a Musa. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pə dəɓa wa nà, ta zla anan ɗo ataya cuwɓe pa 'am ana ɗo maslan a Yesu ataya awan. Ɗo maslan ahay ta ga amboh, tə ɗəfan atan alay pa nga anà ɗo mə walay ataya anga sa ɗaf atan ì mer su way ata inde kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Matanan kutok, 'am a Mbərom nà, a zəga apan sa ta 'am bayak awan. Ɗo sa ɗaf nga pə Yesu ahay ta ma nga sə zəga apan tə mindel à Urəsalima. Aday ɗo ahay bayak a à wulen su ɗo sə gəɗan dungo anà way ahay wa tə ɗəfak nga pə Yesu a re. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyen nà, Mbərom kə̀ ɗəfak apan alay sə mazlaɓ anahan, kə̀ varak anan məgala sa ga masuwayan sə way ahay cara cara pa 'am sə ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Azar sə Yahuda aya inde à man ata awan, ta taa halay nga ù doh sə wazay a tinen sə ngaman doh sə wazay sə ɓile mə mbəsak aya ata awan. Ta nay ahay à wulen su doh sə Siren tə Aleksandriya wa, aday azar aya ɗukwen ta nay pə daliyugo sə Silikiya tə Aziya wa. Tinen a ta ma nga sa vaɗ awiyaway tatə Etiyen. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aya əna, ta mbak apan sə vəɗan uway bay, anga Apasay a Mbərom kə̀ varak anan kəlire sa ja 'am. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pə dəɓa anahan a wa nà, tə haman anà ɗo ahay aday tâ gaɗ apan mungwalay ta sa ja nà: «Mə slənek Etiyen kə̀ jənak anan pa 'am anà Musa aday anà Mbərom re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ta 'am a tinen ata kutok, ta ma nga sə səder anan mivel sə ɗo ahay, ta sə məceɗ sə Yahuda ahay, ta sə miter sə Tawrita ahay. Ta ban anan Etiyen, ta zlan anan ayak anà ɗo sə lavan nga anà Yahuda ahay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta ray ahay ɗo sa gaɗ apan mungwalay miza aya asa. Tə dazlan sa gaɗ apan mungwalay aya kutok, ta wa: «Ɗowan a anan a ja 'am lelibay a pu doh sə mazlaɓ a Mbərom, aday pə Tawrita ana Musa re. ");
INSERT INTO mqbNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mə slənek panan winen apan i ja, a wa: Yesu ɗo sə Nazaratu ata i mbazl anan doh sə mazlaɓ a Mbərom aday i mbəɗa anan 'am ana Musa ma ja aya asa re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ɗo a mə halay nga ù doh sa ga sariya ataya fok, ta ma nga sə zəzor anan Etiyen, aday tinen apan ti ca pə iɗe anahan a nà, a gan atan nə kawa ta ca pə maslay a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pə dəɓa anahan a wa kutok, bahay nga su ɗo sə gəɗan dungo anà way ahay, a cəce pə Etiyen wa, a wa: «'Am a sa ja apak a anaya fok nà, mungwalay ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyen ite a mbəɗahan atan apan, a wa: «Mərak uno ahay tə bəbay uno ahay, ənga, pəken sləmay pa 'am uno a anan aday. Mbərom Bahay sə mazlaɓ kà kak anan zek anà bije a mənuko Ibərahima à alay a winen pə daliyugo sə Mesopotamiya mba, kà zlak à Haran fan bay ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mbərom a jan nà: “Slabak, zla pu kon anak wa, mbəsak anan ɗo anak ahay, aday kâ zla ù kon a həna nen saa ɗakak apan ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Cəna, Ibərahima a slabak pə daliyugo sə Kaldiya ahay wa, a zla à wulen su doh sə Haran, a njahay à man ata awan. Pə dəɓa ana bəbay anahan sa mac wa ite, Mbərom a jan â həɗek ù kon hinen asa, â nay à man a nuko a anan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","À alay ata nà, Ibərahima nə wan anahan inde fan bay. Kwa man sa ɗaf saray dap kərtek ɗukwen, kə̀ varak anan fan bay. Əna Mbərom a zlapan anan tə daliyugo a anan, a wa: “Ni varak anan daliyugo a anan, ki lavay anan iken ta wan sə kutov anak ahay fok.” Aday à alay anahan sa jan 'am ata ɗukwen, Ibərahima nə wan anahan inde fan bay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mbərom a jan ahay, a wa: “Wan sə kutov anak ahay ti njahay pə daliyugo sə mədurlon, ti təra atan ɓile aya ta sa ga atan alay ava ahay səkat fuɗo. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Aya əna, kon a saa təra atan ɓile ahay ata nà, nen a ni i kəta anan. Aday pə dəɓa anahan a wa nà, ni may atan ahay pə daliyugo a anan, ti naa həro nga kutok.” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Matanan, Mbərom a ɓan 'am tə Ibərahima, ta sa ja â gaɗ mədəndalas. Pə dəɓa anahan a wa, Ibərahima a wahay Isiyaku, aday pə luvon jəmaakan sə wahay anahan nà, a gəɗan mədəndalas. Isiyaku ɗukwen a wahay Yakob, a gan matanan, aday Yakob ite a wahay wan anahan ahay kuro nga cew ataya awan, tinen bije a mənuko ahay, a gan atan matanan re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Bije a mənuko ataya nà, ta nan iɗe anà mərak a tinen Yusufu, tə sukumak anan way pə daliyugo sə Misra ɓile awan. Tə winen ata təke ɗukwen, Mbərom winen apan i ba anan Yusufu hwiya, ");
INSERT INTO mqbNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a tam anan pə way sə gəɓan ahay 'am ahay wa. A varan kəlire anga aday â zlan à nga anà Firawna, bahay sə Misra ata awan. Anga nan, Firawna a ɗaf anan ɗo sə lavan nga anà daliyugo sə Misra, aday ɗo sə lavan nga anà gulom su doh anahan re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Aday kutok nà, may a ga pə daliyugo sə Misra ata, tə daliyugo sə Kanana a təke fok. Zek kà dak anan anà ɗo ahay nà, ndəlekeke. Matanan, bije a mənuko ataya ta njaɗ way sa pa sabay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pə dəɓa wa kutok, Yakob a sləne sa jəka ndaw inde sə sukom à Misra nà, a slan bije a mənuko ataya tâ saa sukumay ahay ndaw. Wita, mama'am sə azla a tinen à Misra. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ta ma mə slala cew a saa sukumay asa nà, Yusufu kə̀ ɗakak anan anan zek anà mərak anahan ahay. Matanan Firawna ɗukwen kə̀ sənak zahav ana Yusufu ahay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pə dəɓa anahan a wa, Yusufu a slan ɗo saa nay anan ahay bəbay anahan Yakob tə zahav anahan aya təke. Tinen sa nay pə daliyugo sə Misra ata nà, abaslay a tinen a nə kwa kuro cuwɓe nga ɗara. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Matanan, Yakob a njahay à Misra. Pə dəɓa anahan a wa nà, a mac à man ata awan, tə bije a mənuko ataya təke. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ta zla saa la atan à Sikem pə daliyugo sə Kanana, à jəvay ana Ibərahima sə sukom pə zahav ana Hamor wa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«À alay aday 'am a Mbərom sə zlapan anan anà Ibərahima ata i təra, i i sla bəse coy nà, zahav a mənuko Isəra'ila ahay a ma nga sə wasay pə daliyugo sə Misra ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Aday Misra ahay ta ɗaf uda bahay hinen, əna bahay a wiya ata a san Yusufu bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Anga nan, a ga wurwer pə bije a mənuko ataya awan, a ga atan alay. A gan atan bəlaray tâ lar anan wan a tinen ndəleɓœɓe aya aday tâ mac. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","À alay ata ite, tə wahay Musa, wan lele a pa 'am a Mbərom, leftekəre. Ta gan nga àga bəbay anahan ù doh way sə kiya maakan ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pə dəɓa anahan a wa, ta zla anan, tə mbəsak anan pa 'am zlinder. Əna dəna a bahay ata a tan à nga, a zəɓa anan, a ɗəɗok anan agay kawa wan si zek anahan wanahan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa nà, à alay a winen sa har àga bahay ata nà, kə̀ tətakak anan asan way sə Misra ahay fok. Winen nà, a san sa ja 'am zle lele, aday a ga mer su way ɗukwen tə məgala re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Ava ana Musa a ga kwa kuro fuɗo nà, a jalay sa zla saa can iɗe anà ɗo sə zahav anahan Isəra'ila ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Winen a tan à nga anà ɗo sə Misra inde, winen apan i ga anan alay tu ɗo sə Isəra'ila ahay. A zla sa man zek anà ɗo anahan ata, bəskol winen vaɗ anan ɗo sə Misra ata məsinde awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa a bayak nà, Isəra'ila ahay ti san Mbərom i tam atan tə alay anahan. Əna ɗo anahan ataya tə sənak bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sidew a asa a tan à nga anà ɗo anahan Isəra'ila ahay cew tinen apan ti vaɗ zek. Anga nan, a təker anan sə ndakay atan pi zek, a jan atan, a wa: “Məndala uno ahay, aday kwanay nə tə mərak ahay asanaw, ki vəɗen zek nà, angamaw?” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aya əna, ɗo sə jugwar 'am ata a kaɗan anà Musa ta sa jan nà: “Iken, waya sa ɗaf iken bahay a pa nga a manay aday sa gan umo sariya anaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bina, a nak sa vaɗ nen kawa iken sa vaɗ anan ɗo sə Misra avaɗ ata re ɗaw?” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa a sləne 'am ata cəna, a haw way anahan pə daliyugo sə Madiya saa njahay à man ata kawa mədurlon. Pə dəɓa wa, a njaɗ wan mungol aya cew à man ata re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Pə ava anahan a kwa kuro fuɗo ata nà, maslay a Mbərom a kan ahay zek ù uko sə vəragaz wa à man sa saf bəse tə ɓəzlom sə Sina. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa a canan anà way ata nà, a gan masuwayan. Anga nan, a həɗek apan saa zəzor anan. Əna Mbərom Ba Məduwen a jan ahay, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nen nà, Mbərom ana bije anak ahay. Nen Mbərom ana Ibərahima, Mbərom ana Isiyaku aday Mbərom ana Yakob.” Musa a sləne 'am ata cəna, a ma nga pə ajəjar kwaslkwaslkwasl. A rihe nga ù vo, a nan sə canan sabay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mbərom a jan ahay asa, a wa: “Culok anan təkarak à saray wa, bina man a iken sə tavay uda ata nà, man cəncan awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ayaw, Musa, nen nə sənak pə ɗəce ana ɗo uno ahay sa ga pə daliyugo sə Misra, nə slənek aɗəma way a tinen awan. Anga nan, nə dazak ahay həna nà, sa naa təmay atan ahay. Həna ni slan iken, ma à Misra asa.”» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Musa ata nà, Isəra'ila ahay tə larak anan, anga 'am a tinen sa jan “Waya sa ɗaf iken bahay a pa nga a manay aday sa gan umo sariya anaw?” ata awan. Aya Musa ata nà, Mbərom kə̀ gəɓak anan, kə̀ tərak anan bahay awan, ɗo sa tam ɗo a re. A walay anan tə alay ana maslay anahan sa kan zek ù uko sə vəragaz inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa nà, a təmay atan à Misra wa. A ga masuwayan ahay cara cara à Misra, à bəlay sə ngaman Bəlay Ɗəzɗaz ata, aday ava kwa kuro fuɗo à saf inde re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Musa ata asa re kà jak anan anà Isəra'ila ahay, a wa: “Mbərom i naa slənak ikwen ahay ɗo maja'am anahan hinen kawa nen à wulen ana ɗo sə zahav a kwanay ahay wa.” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aday à alay a bije a mənuko ahay tinen mə halay nga à kiɓe pə pala ata nà, maslay a Mbərom a jan 'am à Musa pə ɓəzlom sə Sina. Musa kə̀ tərak ɗo a sa ma anan 'am à wulen ata ana maslay a Mbərom tə bije a mənuko ataya awan. A təma 'am sa var sifa ahay pə Mbərom wa, aday a mak uko anan 'am ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Aya əna, bije a mənuko ataya tə ngəmak sə təmahan anan 'am ana Musa bay, tə larak anan. Ta gan may aɗəka nà, sa ma à Misra bugol. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Anga nan, ta jan anà Haruna nà: “Ndakan umo mbərom a manay ahay, aday mi bar nà, mi ɗaf anan pa 'am wa. Bina Musa sə ɗowan a anan sa ray ahay mənuko à Misra wa ata nə ma san sa tan à nga nə maw bay.” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Natiya, tə ndakan pəra anà nga a tinen ahay. Pəra ata nà, kawa wan sə minjev. Tə həran nga ta sə waslan way. Ta ga azar uko sə taslay mivel anga mer su way a tinen ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aya əna, Mbərom a mbəsak atan à alay anahan wa sənday, aday tə̂ ɗəfan apan anà mawuzlawazl ahay. Kə̀ tərak kawa ana ɗo maja'am a Mbərom sa ja apan à Deftere a Mbərom inde ata awan, Mbərom a wa: “Kwanay Isəra'ila ahay, à alay kwanay à saf inde way sə ava kwa kuro fuɗo ata nà, kə wislen uno way ɗaw, kə viren uno way ɗaw? Kə viren uno awan bay fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aya əna, kə ndiken jawjawa anga pəra sə ngaman Molok ata awan, aday kə taviken anan mawuzlawazl sə pəra a kwanay sə ngaman Refan ata re. Pəra ataya nà, kə ndiken atan tə alay a kwanay anga sə həran atan nga. Anga nan, ni razl kwanay pə daliyugo a anan wa, ti ra kwanay dəren pə Babila wa re.” ");
INSERT INTO mqbNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«À alay a bije a mənuko ahay à kiɓe ata nà, ta taa gəɓa anan jawjawa sə mazlaɓ a Mbərom. Tə ndakay anan nə uwek, kawa ana Mbərom sə ɗakan anan minje awan anà Musa ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pə dəɓa anahan a wa, atə Yosuwa tə bije a mənuko ahay ta pak anan 'am sə jawjawa sə mazlaɓ a Mbərom ata à alay a bəbay a tinen ahay wa. Ta zla pə daliyugo sə Kanana nà, tə zəɓa anan alay. Ɗo sə daliyugo ataya nà, Mbərom kə̀ rəzlak atan. Bije a mənuko ataya ta pak atan pə daliyugo ata wa. Matanan, jawjawa sə mazlaɓ a Mbərom ata inde à Kanana dezl ahay pə alay ana bahay Dawuda sə njahay à bahay inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","«Bahay Dawuda a nà, kə̀ tərak ləliwe ana Mbərom. Aday kutok nà, Dawuda a cəce cəveɗ aday â ndakan doh anà Mbərom ana Yakob. Əna Mbərom kə̀ varak anan cəveɗ sə ndakay doh ata bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Saa han doh ata nà, bahay Sulimanu, wan ana Dawuda. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Aya əna, Mbərom sə bagəbaga mburom i njahay ù doh su ɗo zənzen a sə ndakay ata bay. Kawa ana ɗo maja'am a Mbərom sa ja, ");
INSERT INTO mqbNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mbərom a wa: “Bagəbaga mburom kə̀ tərak man sə njahay sə bahay uno. Aday daliyugo ɗukwen, man sa ɗaf saray uno re. Bina, ki i ndiken uno təɗe nà, doh sa ma ite anaw? Man aday ki viren uno təɗe sə njahay uda ata nə ahaw? ");
INSERT INTO mqbNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bina, sə ndakay anan way ataya fok nà, nen a biɗaw?”» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyen a pərahan anan azar ta sa ja, a wa: «Kwanay nà, ɗo rawraw aya pa 'am a Mbərom kawa ɗo sə pəra ahay. Bina kə ticen anan mivel a kwanay, kə rəɗen anan sləmay a kwanay, anga aday kə̂ slənen 'am a Mbərom bay. Kə ngəmen sə ɗəfan apan anà Apasay Cəncan a bay. Kwanay kawa bije a kwanay ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bina, abay ɗo maja'am a Mbərom a wura aday bije a kwanay ahay ta gak anan alay bay anaw? Tə vəɗak anan ɗo maja'am a Mbərom aya sə ɗakan atan anan ahay anay ana ɗo maslan anahan a ɗiɗek ata awan. Aday ɗo maslan anahan a ɗiɗek ata a dəzley ahay ta nga anahan a ɗukwen, ki gen apan ɗaf, kə vəɗen anan re. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kwanay nà, kə təmihen anan Tawrita ana Mbərom sə slənay tə alay ana maslay anahan ahay ata awan, əna kə ngəmen sə ɗəfan anan apan bay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ɗo sə lavan nga anà Yahuda ahay ataya tə sləne 'am ana Etiyen ata fok nà, 'am ata a cəɓan atan nə ndəlekeke, ta ga apan mivel tə mindel. Ta ma nga sa rac apan alay təsl təsl jiga awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aya əna, Etiyen nà, winen ma rah Apasay Cəncan awan, a ca iɗe à mburom, a canan ayak anà jiyjay sə mazlaɓ a Mbərom, aday anà Yesu mə tavay a tə alay puway a Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","A ja, a wa: «Nə canan ayak anà bagəbaga mburom mə təɓa awan, aday Wan su Ɗo ɗukwen, winen mə tavay a tə alay puway ana Mbərom re.» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɗo sə sləne 'am anahan ataya fok ta zlah, tə rəɗay a sləmay a tinen ahay, anga aday tə̂ sləne 'am anahan ataya sabay fok. Tə slabak fok a tinen a, ta kaɗ apan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ta ban anan, ta zla anan à wulen su doh wa, aday tə dazlan sa tar anan tu kon. Ɗo sə side way ataya tə culok anan zana a tinen ahay pi zek wa, tə halan anan anà njavar a inde tə ngaman Sol anga aday â ban atan apan. ");
INSERT INTO mqbNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","À alay a tinen apan ti tar anan Etiyen tu kon ata nà, a ga amboh, a wa: «Bahay uno Yesu, həna nà, kem, təma sifa uno à alay anak inde ite.» ");
INSERT INTO mqbNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A slahay duk duk gərmec, a zlah pi zek sə məgala, a wa: «Amboh, Bahay uno, pəsen atan anan ines a tinen a anan ite.» Pə dəɓa ana 'am anahan ata wa cəna, a mac. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Avaɗ Etiyen ata nà, kà zlak anan à nga anà Sol a re. Ta pac ata kwayan'a cəna, tə dazlan sa ga anan alay tu ɗo a Yesu ahay à wulen su doh sə Urəsalima inde. Tinen a fok ta ta 'am à Urəsalima wa. Ta haw à wulen su doh sə kiɓe sə Yahudiya ta sə Samariya aya awan. Mə mbəsak a à Urəsalima nà, ɗo maslan a Yesu ahay vərre coy. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɗo sə jəjaran anà Mbərom a azar aya ta nay, ta la anan Etiyen, tə yimak anan ɗukwen tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Aya əna, Sol sə ɗowan ata nà, a ma nga sə pəslay anan ɗo a Yesu ahay nə jiga awan. A zla nà, doh tu doh, gədek sə bənay anan ahay ɗo sa ɗaf nga pə Yesu ahay, uwar tə mungol aya təke fok, pa tacak atan ayak à dangay. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ɗo a Yesu a sa ta 'am ataya ta ma nga sə ɗakay anan ləbara a Yesu à man a tinen sa bar ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip nà, a zla à wulen su doh a inde pə daliyugo sə Samariya. À man ata kutok, a ɗakay anan 'am a Yesu Almasihu anà ɗo ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɗo sə wulen su doh ataya ta pak sləmay pa 'am ana Filip nə lele, anga tə slənek 'am anahan, aday tə canak anan anà way anahan sa ga tə masuwayan aya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Setene ahay ta nak ahay à ɗo ahay wa bayak awan, ta sa zlah pi zek tə məgalak awan. Ɗo mə təra à məndak aya tu ɗo vədal aya bayak a tə mbərak re. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Matanan, ataslay mivel inde bayak a à wulen su doh sə Samariya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Natiya, à wulen su doh ata inde nà, ɗowan a inde tə ngaman Simon. Ɗowan ata nà, maram awan, kà gak mer su way sa gan masuwayan anà ɗo sə Samariya ataya tə mindel, aday a wa winen nà, ɗo məduwen awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ɗo ataya fok, ɗo mətawak aya tu ɗo zlile aya təke, tə varan zlangar anà ɗowan ata, ta sa ja nà: «Winen nə məgala a Mbərom sə ngaman Məgala Məduwen a ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kə̀ njahak nə bayak awan, Simon sə ɗowan ata, winen apan i gan masuwayan anà ɗo ahay bayak a ti mer su way sə kəlen anahan ata awan. Anga nan, ta taa pəkan sləmay anà 'am anahan a nə lele tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Aya əna, Filip a zla à man ata kutok, a wazay anan ləbara mugom a mbala ana Yesu Almasihu ta sə bahay a Mbərom a nà, ɗo ataya ta ɗaf nga pə Yesu. Mungol tə uwar aya təke fok ta ga baptisma. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Natiya Simon sə ɗowan ata ɗukwen kə̀ ɗəfak nga pə Yesu aday kà gak baptisma re. Winen gədek sa taa pərahan azar anà Filip kwa aha fok, anga a canan anà mer su way a Filip sa ga ataya nà, ta gan masuwayan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Natiya, ɗo maslan a Yesu ahay à Urəsalima tə sləne sa jəka ɗo sə Samariya ahay tə ɗəfak nga pa 'am a Mbərom ata nà, ta slan atə Piyer tə Yuhana à man a tinen. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ɗo a cew ataya tə dəzle à Samariya nà, ta gan amboh anà Mbərom aday â varan Apasay anahan Cəncan a anà ɗo sə Samariya ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ɗo ataya ta ga baptisma nà, tə sləmay a Yesu Almasihu ɗəkɗek, bina tə njaɗak Apasay Cəncan ata fan bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Matanan, atə Piyer tə Yuhana ta ga amboh sə ɗəfan atan alay pa nga, aday Apasay Cəncan a a dazay patan kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon sə ɗowan ata a ca apan ɗo sa ɗaf nga pə Yesu ahay tə njaɗak Apasay Cəncan a à alay ana ɗo maslan ahay sə ɗəfan atan alay pa nga ta sa ga amboh ata nà, a gəɓa dala sə varan anà atə Piyer tə Yuhana, ");
INSERT INTO mqbNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a jan atan nà: «Viren uno məgala ata ite! Ata aday nen nə njaɗak məgala ata nà, ni mba apan sa ɗaf alay pa nga su ɗo aday â njaɗ Apasay Cəncan a ite.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aya əna Piyer a mbəɗahan apan ite, a jan nà: «Kak sə matanan cukutok nà, kə̂ lize tə dala anak a təke, bina iken kə jalay nə ki mba apan sə sukom məgala a Mbərom sa var ta 'am kəriya ata asanaw! ");
INSERT INTO mqbNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Matanan, iken nà, ki mba apan sə japay tə manay sabay fok, anga mivel anak a aday nà, winen ɗiɗek a pa 'am a Mbərom bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Iken həna aɗəka nà, mbəɗahan lœn anà ines anak. Cəce pə Mbərom wa aday hinahibay i pəsek anan way anak sə jalay matanan à mivel anak inde ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Anga na ca apak nà, iken nə sədœk awan, aday huwan kà gak apak bahay jiga awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon sə ɗowan ata a sləne 'am ata cəna, a jan anà atə Piyer tə Yuhana nà: «Kem, gen anan amboh anà Bahay Yesu anga nen, aday way a kwanay sa ja upo həna ata â təro bay ite!» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pə dəɓa anahan a wa nà, ɗo maslan a cew ataya tə pərahan anan azar sə ɗakay anan ləbara a Yesu anà ɗo ahay. Mer su way a tinen a ndav nà, ta ma way a tinen à Urəsalima, aday tinen apan ti ɗakay anan ləbara mugom a anà ɗo sə wulen su doh sə Samariya ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pə dəɓa anahan a wa kutok, maslay a Mbərom Ba Məduwen a jan anà Filip nà: «Slabak, zla ta day sə dəlon pə cəveɗ a sə slabak à Urəsalima wa sa zla à Gaza ata awan, ɗo ahay tə mbəsakak sa zla tə cəveɗ ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Cəna, Filip a slabak, a zla kwayan'a. Pə cəveɗ ata kutok, a tan ayak à nga anà ɗowan a inde winen Etiyopiya ahay, winen mə dədasl awan. Winen nà, ɗo məduwen awan, ɗo sa ba pə dala ana uwar sə ngaman Kandake, winen bahay sə Etiyopiya ahay ata awan. A zla à Urəsalima nà, saa həran nga anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Winen apan i ma pə dəɓa agay tə muta sə pəles awan, aday Deftere ana ɗo maja'am a Mbərom Ezaya inde apan, winen apan i jinge anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Apasay a Mbərom a jan anà Filip nà: «Zla pə cakay ana muta sə pəles a tiya ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Cəna, Filip a hawan ayak azar anà muta sə pəles ata awan. A bənak anan ayak nà, a sləne nə ɗowan sə muta sə pəles ata winen apan i jinge Deftere ana ɗo maja'am a Mbərom Ezaya. Filip a cəce panan kutok, a wa: «Iken apan ki sləne way a iken sə jinge ata dəp ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɗo sə Etiyopiya ata a mbəɗahan apan anà Filip, a wa: «Ni mba apan sə sləne kəkəma aday mənjəna ɗowan sə ɗuko anan way a uda ataya anaw?» A gan kem anà Filip aday â jənak ayak à muta inde sə njahay pə cakay anahan. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Natiya, way anahan a sə jinge à Deftere a Mbərom inde ata nə həna: «Winen kawa təman aday tinen apan ti zla anan à man sə waslay way ata awan. Aday kawa wan sə təman aday tinen apan ti gaɗ panan sibœk ɗukwen a yam bay ata, matanan kə̀ təɓak anan 'am anahan sa yam bay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tə tərak anan à məndak, ta gak anan sariya tə cəveɗ a bay, ɗowan saa ja 'am sa wan sə kutov anahan ɗukwen, ibay fok. Anga tə lizek anan anan sifa pə daliyugo wa.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pə dəɓa anahan a wa kutok, ɗowan ata a cəce pə Filip wa, a wa: «Ənga, ɗuko anan ite aday: Ɗo maja'am a Mbərom ata a ja 'am ata jiga nə pə wayaw? A ja 'am ata nà, pi zek anahan a ɗaw? Kabay a ja nə pu ɗo hinen ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Natiya awan, Filip a dazlan ta 'am a mə jinge ata awan, aday a ɗakan anan 'am sə ləbara mugom a mbala ana Yesu ata kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tinen apan ti zla pə cəveɗ nà, tə dəzle à man sə a'am. Ɗowan ata a cəce pə Filip wa kutok, a wa: «A'am inde həna asənə, ni ga baptisma a bay ike nà, angamaw?»  ");
INSERT INTO mqbNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip a mbəɗahan apan, a wa: «Kak kə ɗəfak nga pə Yesu tə mivel kərtek a nà, wita i ga zek, ki mba apan sa ga baptisma acəkan.» A mbəɗahan apan anà Filip nà: «Nə ɗəfak nga pə Yesu Almasihu nə winen Wan a Mbərom.» ");
INSERT INTO mqbNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Natiya, a tavay anan muta sə pəles anahan. Tə dazay à a'am inde tə Filip, aday Filip a gan baptisma kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tə jənay ahay à a'am wa cəna, sewek Apasay ana Bahay Mbərom a zəɓa anan Filip à man ata wa. Ɗowan ata kə̀ canak anan sabay fok. A pərahan azar anà cəveɗ anahan sa zla tə ataslay mivel a tə mindel. ");
INSERT INTO mqbNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ite nà, a saa ca apan nə winen à Azot. A zla kwa aha fok ta sə wazay anan ləbara ana Yesu mugom a, hus a dəzle à Kaysariya. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","À alay ata nà, Sol winen apan i pərahan azar sə kətəɓar anan ɗo a Bahay Yesu ahay ta sa ja nə i vaɗ atan. Anga nan, a zla pə bahay nga su ɗo sə gəɗan dungo anà way ahay anga Mbərom, ");
INSERT INTO mqbNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a cəce panan â vinden ɗerewel à alay inde, i varan anà ɗo sə lavan nga anà doh sə wazay ana Yahuda ahay à wulen su doh sə Damas inde ataya, aday tâ san 'am si zek ana Sol awan. Anga a gan may nà, kak kà tak anan à nga anà ɗo sə pərahan azar anà cəveɗ a Yesu ahay à Damas nà, kwa ɗo mungol awan, kwa ɗo uwar a fok, i ban atan aday i nay atan à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Natiya, à alay a winen apan i zla aday bəse i dəzle à Damas kutok nà, jiyjay a nay ahay à mburom wa, a dav, a va anan ù doh tew. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Cəna a slahay anan à məndak, aday a sləne agungol sa 'am winen apan i jan 'am, a wa: «Sol, Sol, kə jugwar puno wa 'am jiga nà, angama kərtek anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol a mbəɗa apan ite, a wa: «Iken nə wayaw, bahay uno?» 'Am ata a mbəɗahan ahay apan ite, a wa: «Nen nà, Yesu, ɗowan a iken sə jugwar panan wa 'am ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Slabak, zla à Damas, aday ti i jak way anak a saa ga ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ɗo sa zla jiga tatə Sol ataya fok tə tavay sleɓərɓərre mənjəna aja 'am. Tə slənek agungol sa 'am ata awan, əna tə canak anan anà ɗowan bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol a slabak, a təɓa anan iɗe anahan ahay nà, a canan iɗe sabay, kə̀ hurfok. Anga nan, tə bənan alay à Damas ababan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Luvon maakan fok, winen hurof awan. Kà pak awan bay, aday kà sak awan bay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","À Damas ata nà, njavar a Yesu a inde, tə ngaman Ananiyas. Bahay Yesu a ngaman ì cœn sə zuɓay inde, a jan: «Ananiyas!» Ananiyas a ngaman apan: «Walaw, Bahay uno. Nen həna.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bahay Yesu a jan nà: «Slabak, zla àga Yudas, pə cəveɗ sə ngaman “cəveɗ mə tavay awan” ata awan. Kə̂ cəce ɗowan a inde, tə ngaman Sol, winen ɗo sə Tarsus, anga həna winen apan i ga amboh. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","À cœn sə zuɓay inde a canan anà ɗowan a sə ngaman Ananiyas ata a zlak ayak, a ɗəfan alay pa nga, aday â mba apan sə canan iɗe miza awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas ite a mbəɗahan apan, a wa: «Bahay uno, ɗo ahay bayak a tə təkərek uno ləbara sa 'am a ɗowan ata awan. Tu jo nà, kà gak anan alay bayak a tu ɗo anak ahay à Urəsalima. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aday həna a nay ahay à man a anan ata nà, bahay sə gəɗan dungo anà way ahay tə vindek anan ahay ɗerewel à alay inde, anga aday â ban anan ɗo sə hərak nga a anaya fok.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aya əna, Bahay Yesu a mbəɗahan apan anà Ananiyas, a wa: «Iken, zla pə cakay anahan awan! Winen a nà, nə walak anan su go mer su way anga aday i ɗakan anan sləmay uno anà ɗo sə pəra ahay tə bahay a tinen ahay, aday anà ɗo sə Isəra'ila ahay re. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nen a ta nga uno awan ni ɗakan anan ɗəce anahan a sa naa ga anga sləmay uno ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Natiya, Ananiyas a zla àga Yudas ata kutok. A zla à gulom su doh ata nà, a ɗəfan alay pa nga anà Sol ta sa jan: «Sol, mərak uno, sə slənay nen à man anak nà, Bahay Yesu, ɗowan a sa kak zek pə cəveɗ à alay a iken apan ki nay à man a anan ata awan. A slənay nen nà, anga iɗe anak ahay tə̂ təɓa, aday anga kâ njaɗ Apasay Cəncan awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kwayan'a cəna, awan a a slahay ì iɗe ana Sol ahay wa, kawa sliper sə dombana, iɗe anahan ahay tə təɓa kutok, a mbar. Sol a slabak, a ga baptisma. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aday, a pa way sa pa, a njaɗ məgala miza kutok. Sol a njahay way sə luvon ahay mənjœk tə ɗo a Yesu ahay à Damas ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kwayan'a a dazlan sə wazay ù doh sə wazay sə Yahuda ahay, ta sa ja nà, Yesu nə winen Wan a Mbərom acəkan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ɗo sə sləne 'am anahan ataya fok, a gan atan masuwayan, ta wa: «Na wa, ɗowan a anan nà, winen ɗo sa ga anan alay tu ɗo a Yesu ahay à Urəsalima ba? Aday həna a nay ahay à man a anan nà, anga aday i ban anan ɗo sə həran nga anà Yesu ahay, i zlan atan anan ayak anà bahay sə gəɗan dungo anà way ahay re ba?» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aya əna, Sol a njaɗ apan məgala sə wazan anà Yahuda ahay à Damas ata awan. Sol a tavay apan njənjan ta sa ja nà, Yesu nə winen Almasihu. Ɗo ataya ta mbak apan sə mbicen 'am bay jiya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A njahay pə dəɓa anahan a wa əngal nà, Yahuda ahay ta ma anan 'am ì zek ahay anga aday ti vaɗ anan, ");
INSERT INTO mqbNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","aya əna, Sol nə kə̀ sənak apan. Luvon tə ipec fok, Yahuda ahay tinen apan ti ba məsudoh sə wulen su doh ahay anga aday ti vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Əna pə luvon a inde kutok, ɗo ana Sol ahay tə gəɓa anan à cəkarak inde, tə taray anan ahay uho tə liɓer à mufəlok sə dalam wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ana Sol sə dəzle à Urəsalima nà, a gan may sə japay tu ɗo a Yesu ahay à man ata awan. Əna hərra ɗo ataya fok tə jəjaran, anga sa jəka tə ɗiɗek a, winen nà, ɗo a Yesu re nà, tə təmahak bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Aya Barnabas kutok, winen a zəɓa anan Sol, ta zla pi zek à man su ɗo maslan a Yesu ahay. Barnabas a ɗakan atan anan nà, Sol kə̀ canak anan anà Bahay Yesu pə cəveɗ sa zla à Damas ata awan, aday Bahay Yesu ɗukwen kà jak anan ahay 'am re. Aday ɗukwen, Sol kə̀ ɗakak anan anan ləbara a Yesu anà ɗo ahay à Damas mənjəna ajəjar. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Natiya, a ban pə winen ata wa kutok, Sol a japay tu ɗo a Yesu ahay. A dazlan sa bar à wulen su doh sə Urəsalima ta sə ɗakay anan ləbara ana Bahay Yesu mənjəna ajəjar. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Winen apan i ja 'am, i vaɗ awiyaway tə Yahuda sa ja 'am sə Gərek ataya awan, əna tinen ite ta gan may sa vaɗ anan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Matanan, ɗo a Yesu ahay tə sləne apan nà, ta zla anan Sol à Kaysariya, aday ta slan anan à Tarsus. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pə dəɓa anahan a wa kutok, ɗo a Yesu ahay pə daliyugo sə Yahudiya tə Galile aday ta sə Samariya fok, tinen mə njahay a nà, à zay inde, ɗəce inde sabay kutok. Tə varan məgala ì zek ahay, tə həran nga anà Bahay Yesu pac pac, Apasay Cəncan a a man atan anan mivel ù doh, aday abaslay a tinen a ma nga sə zəga apan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyer nà, winen apan i zla kwa ta sə wura fok. Pə luvon a inde nà, a zla sa can iɗe anà ɗo a Yesu ahay à Lida. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","À man ata kutok, a tan à nga anà ɗowan a inde tə ngaman Aneyas, winen mə təra à məndak awan. Way sə ava jəmaakan, winen mə nahay awan. A mba apan sə slabak bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyer a jan nà: «Aneyas, slabak! Yesu Almasihu kə̀ mbərak iken. Faɗay anan man sə nahay anak.» Cəna, a slabak kwayan'a. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Natiya, ɗo sə Lida tu ɗo sə Saron ahay fok tə canan anà way ata nà, ta ɗaf nga pə Bahay Yesu kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","À Yafo nà, uwar a inde, tə ngaman Tabita, winen ɗo a Yesu. Tabita a nan sa ja nà, «Miyak», kabay «Dorkas» ta 'am sə Gərek. Uwar ata a taa ga nə mer su way lele aya awan, a taa man zek anà ɗo mətawak aya re. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pə luvon a inde, ɗəvac a ban anan Tabita, a mac. Tə banay anan məsinde awan, aday tə ɗəfak anan ayak ù doh à sewene inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Wulen su doh sə Yafo nà, dəren pi zek wa tə wulen su doh sə Lida bay. Anga nan, ɗo a Yesu ahay à Yafo tə sənak apan Piyer nə winen à Lida, ta slan ɗo ahay cew à man anahan aday tâ jan nà: «Kem, ənga haway àga manay bəse aday!» ");
INSERT INTO mqbNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyer a sləne cəna, a zla tə tinen à Yafo. Piyer a dəzle cəna, tə lagay anan ù doh à sewene pə cakay ana məsinde awan. Mədukway sə uwar ahay ta va anan Piyer tew, tinen apan ti yam, ta kan anan kəlmije tə zana ana Dorkas azar a winen sa tam à alay a winen tə sifa mba ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyer a rəzlay anan ahay ɗo ahay uho. A dukwe gərmec aday a ga amboh. Coy, a mbəɗa 'am pə məsinde, a jan: «Tabita, slabak!» Tabita a təɓa iɗe ngurret, aday a canan a Piyer nà, a slabak, a njahay ziyaf. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyer a bənan alay, a man zek sə slabak. Pə dəɓa wa nà, a ngaman anà ɗo a Yesu ahay tə mədukway sə uwar ahay, a kan atan anan Tabita winen tə sifa awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Natiya, ləbara ata a ta 'am à wulen su doh sə Yafo inde fok, aday ɗo ahay bayak a tə ɗəfak nga pə Bahay Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer kə̀ njahak à Yafo ata bayak awan, àga ɗowan inde tə ngaman Simon, winen ɗo sə kəfaɗ ambar. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ɗowan a inde tə ngaman Korneliyus à wulen su doh sə Kaysariya, winen bahay sə suje ahay à wulen ana suje sə Italiya ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Winen tu ɗo su doh anahan ahay nà, tinen Yahuda ahay bay, əna tə ɗəfan apan anà Mbərom aday tə həran nga lele. A taa man zek anà ɗo mətawak aya awan, aday a taa gan amboh anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pə luvon a inde sə suko kutok, i ga nə njamde maakan, Mbərom a kan anan way. A canan anà maslay a Mbərom njœk tə iɗe anahan. Maslay a Mbərom ata a nay pə cakay anahan, a jan: «Korneliyus!» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneliyus a canan anà maslay a Mbərom ata nà, zlawan a gan. A mbəɗahan apan: «Ma sa ga anaw, bahay uno?» Maslay a Mbərom a mbəɗahan apan ite, a wa: «Mbərom kə̀ slənek amboh anak, kə̀ canak anan anà way anak sə varan anà ɗo mətawak a ataya awan. Ka zlak anan à nga à Mbərom, kə̀ mbəɗəkek iken à nga wa bay. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Həna nà, slan ɗo ahay à Yafo, tâ saa ngaman ahay anà ɗowan a sə ngaman Simon Piyer ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Winen àga ɗowan a inde tə ngaman Simon, winen ɗo sə kəfaɗ ambar. Doh ana ɗowan ata nə pa 'am sə bəlay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Maslay a Mbərom ata a zla way anahan kutok nà, Korneliyus a ngaman anà ɗo si mer su way anahan ahay cew tə apan suje anahan kərtek, winen ɗukwen, ɗo sə ɗəfan apan anà Mbərom lele. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korneliyus a jan atan way a sə təra ata fok, aday a slan atan à Yafo saa ngaman anà Piyer. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sə sidew a nà, à man ipec inde, ɗo a Korneliyus ahay tinen bəse ti dəzle à Yafo. Əna, Piyer a ján pə zlukwaɗ saa ga amboh. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","May a dazlan sa han apan. Anga nan, a nan sa pa way. Tinen apan ti dan ahay way sa pa nà, Mbərom a kan anan ahay way. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A ca iɗe à mburom nà, bagəbaga mburom nə mə təɓa awan, aday awan a inde kawa gwedere mə laway a à mburom ma ɓan a pə slaway anahan aya fuɗo fok, aday winen apan i dazay ahay pə daliyugo. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","À zana ata inde nà, a canan anà gənaw ahay tə saray aya fuɗo fuɗo cara cara fok, pi zek tə way sa zla tə kutov ahay, aday tə məvuhom sa nga mburom ahay. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Piyer a sləne dungo a a jan ahay, a wa: «Piyer, slabak! Gəɗan dungo aday kâ rac.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyer a mbəɗahan apan, a wa: «A'ay, Bahay uno. Kula na pak way ma ga mənjaɗak a aday mə gafay 'am aya bay.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Piyer a sləne dungo ata asa, a wa: «Way a Mbərom sə təra anan cəncan ata nà, kâ saa jəka ma ga məsagar a bay!» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Awan ata kà mak ahay apan nà, saray maakan, aday zana ata a ma à mburom tətah kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyer a ma nga sə cəce pi zek anahan a wa: «Way uno sə canan ata nə a nan sa ja nə maw?» À alay ata ite, ɗo maslan ana Korneliyus ataya tə njaɗak anan doh ana Simon ata awan, tinen uho pa 'am su doh. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tə cəce tə məgalak awan, ta wa: «Waka mbəlok a inde tə ngaman Simon Piyer nà, winen inde à gulom su doh a anan ite ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyer nà, dezenzen'e winen apan i jalay pə way ana Mbərom sa kan anan ata mba. Aya əna Apasay a Mbərom a jan: «Ɗo ahay inde uho maakan, tinen apan ti pəlay iken. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dazay kwayan'a, kâ sa jalay awan anga sa zla tə tinen bay. Sə slənay atan ahay nà, nen awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyer a dazay, a zla pə cakay a tinen, a jan atan: «Ɗowan a kwanay sə pəlay ata nà, nen awan. Ki jen nə maw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tə mbəɗahan apan: «Sə slənay ahay manay nà, Korneliyus, winen bahay sə suje ahay. Winen ɗo ɗiɗek awan, aday a ɗəfan apan anà Mbərom lele re. Yahuda ahay fok ta san apan zle winen ɗo lele awan. Maslay a Mbərom cəncan a a jan nà, â ngamak ayak àga winen aday i saa sləne 'am anak saa jan ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyer a təma atan, a varan atan man sə nahay. Sə sidew a kutok, Piyer a zla tu ɗo a Korneliyus ataya, aday tə azar su ɗo a Yesu ahay à Yafo kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","À anjahay sidew kərtek anahan awan, tə dəzle à Kaysariya kutok. Korneliyus nà, ɓa kə̀ gərak anan ɗo anahan ahay ta car anahan ahay sa ba anan gərekke agay. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","À alay a Piyer sə dəzlek ayak ata cəna, Korneliyus a haway apan sa naa təmahak anan ayak. A nay, a dukwen gərmec ù vo, a həran nga. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aya əna, Piyer a bənan alay à məndak wa, a slabak anan ta sa jan nà: «Slabak! Nen ɗo zənzen a re asanaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tinen apan ti kaɗ bala hus ta zla pi zek à gulom su doh. À man ata nà, Piyer a tan ayak à nga anà ɗo ahay bayak a mə halay nga aya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A jan atan, a wa: «Kə sənen apan zle, manay Yahuda ahay, sə japay tu ɗo kabay sa zla àga ɗo aday winen Yahuda ahay itəbay ata nà, pəra a manay kə̀ gafak umo apan 'am. Aya əna, Mbərom kə̀ ɗakak uno anan way həna aday nâ ca pə kuwaya nà, ɗo mənjaɗak a kabay ɗo mə gafay 'am a sabay. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Anga nan, həna nə ngamak ikwen ahay apan pə angamay a kwanay. Na jak sa jəka, ni nay ahay bay bay.» A jan atan kutok, a wa: «Na nak, ki jen nə ma kutok anaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyus a mbəɗahan apan, a wa: «Kà gak way sə luvon maakan ahay, nen apan ni ga amboh, kəslsla à alay a həna anan inde sə suko ù doh uno. À alay ata kutok, ɗowan a ma pak zana a wuteɗ ike ata a tavay pa 'am uno, ");
INSERT INTO mqbNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","u jo, a wa: “Korneliyus, Mbərom kə̀ slənek anan amboh anak, kə̀ canak anan anà way anak sə varan anà ɗo mətawak aya ata awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Həna nà, slan ɗo ahay à Yafo, tâ saa ngaman ahay anà ɗowan a sə ngaman Simon Piyer ata awan. Winen àga ɗowan a inde tə ngaman Simon, winen ɗo sə kəfaɗ ambar. Doh ana ɗowan ata nə pa 'am sə bəlay.” ");
INSERT INTO mqbNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Anga nan, nə slənak ayak ɗo sə ngamak ahay bəse, aday suse ka nak ahay acəkan. Aya kutok, manay a fok mə halak nga pa 'am a Mbərom həna, ma gan may sə sləne way ana Bahay a mənuko a sa gan may kâ jan umo ata awan.» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Natiya Piyer a dazlan sa ja 'am kutok, a wa: «Həna nà, nə sənak Mbərom a gəzla anan ɗo ahay pi zek wa sabay kutok. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kwa abay â ga nə iken zahav wura wura fok aday kə həran nga anà Mbərom, ka gak mer su way lele fok cəna, ki zlan à nga anà Mbərom. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kə sənen apan zle, Mbərom a slənay ahay ləbara anahan nà, anà Isəra'ila ahay. A ɗakan atan anan ləbara mugom a sə zay sa nay tə alay ana Yesu Almasihu, Bahay ana ɗo ahay fok kəzlek. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","A dazlan ahay nə kwa pə ana Yuhana sa jan anà ɗo ahay nə tâ ga baptisma ata wa. Kwanay kə sənen pə way a sə təra pə dəɓa anahan a wa, pə daliyugo sə Galile, aday pə daliyugo sə Yahudiya. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yesu, ɗo sə Nazaratu ata nà, Mbərom kə̀ varak anan məgala tə Apasay Cəncan awan. Kà zlak kwa ta sə wura fok, kà gak mer su way lele aya awan, kə̀ mbərak anan ɗo ahay aday setene ahay sa ban atan ataya fok, anga Mbərom winen inde tə winen. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Sə side anan mer su way anahan sa ga à Urəsalima aday pə daliyugo sə Yahuda ahay a anan fok nə manay aya awan. Ta vaɗ anan ta sə laway anan pə dədom mə zləlngaɗ awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Cəkəbay, pə luvon maakan sə amac anahan ata nà, Mbərom kə̀ slabakak anan ahay à məke wa. Kà kak anan zek anà ɗo ahay, ");
INSERT INTO mqbNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","əna anà ɗo ahay so bay. Kà kak umo zek anà manay ɗo a Mbərom sə walay kwakwa sə side ləbara anahan ahay. Manay ɗukwen, ma pak way, ma sak way pə kərtek a tə Yesu pə dəɓa sə aslabakay anahan à məke wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","A jan umo nà, mə̂ wazay anan ləbara mugom ata anà ɗo ahay, mâ ja nà, Mbərom a ɗaf saa gan sariya anà ɗo ma mac aya tu ɗo sə uho ahay fok nə winen. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ɗo maja'am a Mbərom ahay fok ta ja nə 'am anahan awan, ta wa: “Kuwaya ɗowan a kə̀ ɗəfak apan nga nà, Mbərom i pəsen anan ines anahan ahay, anga məgala sə sləmay anahan awan.”» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Natiya, à alay a Piyer winen apan i ja 'am ata mba, Apasay Cəncan a a dazay pu ɗo sə sləne wazo anahan ataya fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahuda ahay à wulen su ɗo sa ɗaf nga pə Yesu ahay aday ta nay tatə Piyer jiya ataya, way ata a ma nga sa gan atan masuwayan, anga cəkəbay ɗo su kon azar aya ɗukwen, Mbərom kə̀ varak atan cəveɗ sa njaɗ Apasay Cəncan a re! ");
INSERT INTO mqbNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bina, tə sləne bine siwaw nà, tinen apan ti ja 'am ta 'am a aday ɗowan a san bay ataya awan, tinen apan ti həran nga anà Mbərom. Anga nan kutok Piyer a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɗo a anaya ta njaɗ Apasay Cəncan a nə kawa ana mənuko sa njaɗ ata re. Ɗowan a saa jəka tâ njaɗ sa ga baptisma bay ata nà, wayaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Natiya kutok, a wa tâ gan atan baptisma tə sləmay ana Yesu Almasihu. Pə dəɓa anahan a wa nà, Korneliyus a cəce Piyer â njaɗ sə njahay tə tinen luvon ahay əngal ite. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɗo maslan ahay tu ɗo a Yesu ahay kwa aha pə daliyugo sə Yahudiya ataya tə slənek kwa ɗo su kon azar aya ɗukwen tə təmahak 'am a Mbərom re. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Natiya, Piyer a zla à Urəsalima kutok nà, ɗo a Yesu aday tinen Yahuda ahay ataya ta man anan mungok, ");
INSERT INTO mqbNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ta wa: «Iken ka zla àga ɗo sə pəra ahay aday ka pak ahay way sa pa pə kərtek a tə tinen jiga nə angamaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piyer a təkəren atan anan 'am ata, kwa pa sə dazlan a wa jiga fok cərah lele, a wa: ");
INSERT INTO mqbNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«À alay a nen à Yafo nà, nen apan ni ga amboh, aday Mbərom u ko anan ahay masuwayan sə way à cœn sə zuɓay inde. Nə canan anà awan a inde kawa gwedere mə laway a à mburom ma ɓan a pə slaway anahan aya fuɗo fok, aday winen apan i dazay ahay à man ata wa pə cakay uno. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nə zəzor anan lele nà, nə canan anà gənaw ahay, way sə kiɓe ahay, way sa zla tə kutov ahay, tə məvuhom sa nga mburom ahay tinen uda fok. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","«Nə sləne agungol sa 'am a ndəray ahay, u jo ahay nà: “Piyer, slabak! Gəɗan dungo, aday kâ rac.” ");
INSERT INTO mqbNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Aday nen nə mbəɗahan ayak apan, na wa: “A'ay, Bahay uno. Wita i ga zek bay, anga way mənjaɗak aya kabay way mə gafay 'am aya nà, kula kə̀ sələmak à 'am uno bay.” ");
INSERT INTO mqbNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Nə sləne agungol sa 'am ata u jo ahay mə slala cew awan, a wa: “Way a Mbərom sə təra anan cəncan ata nà, kâ saa jəka ma ga məsagar a bay.” ");
INSERT INTO mqbNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Awan ata kà mak uno anan ahay 'am ata saray maakan, aday pə dəɓa anahan a wa gwedere ata a ma anan way anahan à mburom tətah. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«À alay ata kutok, ɗo ahay maakan ta zlak ayak à man uno a sə njahay ata awan. Tə slənak atan ayak à Kaysariya wa. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Apasay a Mbərom u jo nà, nâ zla tə tinen jiga awan, â su go gərwecwec bay. Ɗo a mbərka həna anaya tə pəruho azar àga ɗowan a inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ɗowan ata a jan umo, a wa a canan anà maslay a Mbərom a slərak ayak ù doh anahan, a jan nà: “Slan ɗo ahay à Yafo pə ɗowan a inde tə ngaman Simon Piyer, â nay ahay àga iken. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Piyer sə ɗowan ata i naa jak 'am sa tam iken tu ɗo su doh anak aya təke fok.” ");
INSERT INTO mqbNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Natiya, à alay nen apan ni dazlan sa jan atan 'am nà, Apasay Cəncan a a dazay ahay patan kawa anahan sə dazay ahay puko kurre ata re. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Matanan, na may anan ahay 'am ana Bahay a nuko ma ja kurre ata, a wa: “Yuhana kà gak anan baptisma anà ɗo ahay tə a'am, əna Mbərom i gak ikwen baptisma nà, tə Apasay Cəncan ata awan.” ");
INSERT INTO mqbNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Matanan kutok, Mbərom kə̀ varak atan Apasay Cəncan awan, kawa anahan sə varak uko ata, à mənuko ɗo sa ɗaf nga pə Bahay a nuko Yesu Almasihu ata awan. Bina, abay kwanay kə jilen nà, nen ni mba apan sə gafan 'am anà Mbərom pə way anahan sa gan may sa ga ata təte ɗaw?» ");
INSERT INTO mqbNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ɗo ataya tə sləne anan 'am a Piyer ata cəna, ta mak anan anan mungok sabay, aday tə həran nga à Mbərom, ta wa: «Mbərom kə̀ varak anan cəveɗ anà ɗo su kon azar aya aday tâ yam pə ines a tinen ahay, tâ njaɗ sifa sa ndav bay ata re!» ");
INSERT INTO mqbNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pə dəɓa sa vaɗ anan Etiyen ata wa nà, bahay sə Yahuda ahay ta ma nga sa ga anan alay tu ɗo a Yesu ahay tə mindel. Anga nan, azar su ɗo a Yesu ahay ta tak 'am à Urəsalima wa, ta zla kwa pə daliyugo sə Finikiya tə Kiprus aday à wulen su doh sə Antakiya. À alay a tinen apan ti zla ata nà, tə ɗakan anan ləbara a Yesu nə anà Yahuda ahay ɗəkɗek. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Əna azar su ɗo a Yesu ahay, tinen Kiprus ahay tə Siren ahay ataya, ta zla à Antakiya, tə ɗakan anan ləbara mugom a pə Bahay Yesu anà ɗo aday tinen Yahuda ahay itəbay ataya awan. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ɗo ahay bayak a tə ɗəfak nga pə Bahay Yesu, tə təmahak sə pərahan azar, anga məgala a Mbərom a ga mer su way ù ɗo sə ɗakay anan ləbara ataya inde. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Natiya, ɗo a Yesu à Urəsalima ataya tə sləne ləbara ata nà, ta slan Barnabas à Antakiya. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnabas a dəzle à Antakiya kutok, a taslay mivel, anga a tan ayak à nga nà, Mbərom kà kak atan anan ahay sumor anahan. Natiya, a varan atan məgala aday tə̂ pərahan azar à Bahay Yesu tə ɗiɗek awan, aday tə mivel kərtek a re. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas nà, winen ɗo lele awan. Winen ma rah a tə Apasay Cəncan awan, aday a ɗaf nga pə Yesu tə mivel kərtek awan. Matanan, ɗo ahay bayak a tə ɗəfak nga pə Bahay Yesu. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pə dəɓa anahan a wa nà, Barnabas a zla à Tarsus saa pəlay anan ahay Sol. ");
INSERT INTO mqbNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A tan à nga kutok nà, ta nay ahay maya à Antakiya. Matanan, atə Barnabas tə Sol ta ga pi zek tu ɗo a Yesu ahay à man ata nà, ava daz. Tə tətakak anan anan way anà ɗo ahay bayak awan. À man ata wa kutok, tə dazlan sə