﻿USE sofia;
DROP TABLE IF EXISTS sofia.mpx_vpl;
CREATE TABLE mpx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mpx_vpl WRITE;
INSERT INTO mpx_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Abatelipuna elana Yabowaine labulabum ge panayawi i ginolil. ");
INSERT INTO mpx_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He panayawi i enonovan ya, ge nigeya ga ana awa i mamasal i oola te sauga ya. Gogou kubwa wewel limwalimwanina i yabom, ge Yabowaine Yayaluwana i nononawanawa wewel pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yaka Yabowaine i ba, “Mwananal ga ni gan,” inoke mwananal i gan. ");
INSERT INTO mpx_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Inoke Yabowaine i kite mwananal i waisi. Mwananal ge gogou i teli walel, ");
INSERT INTO mpx_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","yaka mwananal alana i tun “lan” ge gogou alana i tun “bulin.” He bulin i mowasi ge lan i mowasi, lan houwan to. ");
INSERT INTO mpx_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Yaka Yabowaine i ba, “Hawawal ga ni gan wewel ali luwaluwala ge wewel ni walel.” ");
INSERT INTO mpx_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Yabowaine hawawal i ginol yaka wewel i wali eluwe, etega i minaa hawawal pwatanaa ge etega i minaa gabulanaa. Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yaka Yabowaine hawawal alana i tun “labulabum.” He bulin i mowasi ge lan i mowasi, lan eluwana to. ");
INSERT INTO mpx_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Yaka Yabowaine i ba, “Wewel toto labulabum gabulanaa ni tub pahipahi, inoke bilibili kekevana ni masal.” Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yaka Yabowaine bilibili kekevana alana i tun “datu,” ge wewel i tub pahipahi alana i tun “hoga.” Inoke Yabowaine i kite i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yaka Yabowaine i ba, “Bugul siusiunil ga nihi siun datuwa: mwawin bolo enowaliya pwatum ge ebwakil bolo enowaliya pwatumwina gaganina ali awa tomaha ge tomaha.” Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Bugul siusiunil hi siun datuwa: mwawin ali awa tomaha tomaha ge ebwakil ali awa tomaha tomaha. Inoke Yabowaine i kite i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","He bulin i mowasi ge lan i mowasi, lan etonina to. ");
INSERT INTO mpx_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Yaka Yabowaine i ba, “Mwananal ona ga nihi gan labulabumwa, heliya lan ge bulin nihi teli walel, nihi ola etotohi tal, lan, ge baliman kaiweliya, ");
INSERT INTO mpx_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ge nihi yana labulabumwa panayawi nihi yane.” Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yabowaine mwananal bwabwatal labui i ginolil, toto mwananalina bwabwatana lan ni logugui-an, ge toto mwananalina kekeisi bulin ni logugui-an. I ola al putum i ginolil. ");
INSERT INTO mpx_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Yabowaine i telel labulabumwa panayawi nihi yane, ");
INSERT INTO mpx_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","lan ge bulin nihi logugui-an, ge mwananal ge gogou nihi teli walel. Inoke Yabowaine i kite i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","He bulin i mowasi ge lan i mowasi, lan esopalena to. ");
INSERT INTO mpx_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Yaka Yabowaine i ba, “Bugul bolo yawaliliya gaganil hoga ga nihi pakalaopop, ge bwasumu ga nihi youyou hawawala panayawi pwatanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yabowaine moti bwabwatal hot ge bugul yawaliliya gaganil bolo hi nawanawa hogaa ge hi pakalaopop, ali awa tomaha ge tomaha i ginolil. I ola al bwasumu bolo hi youyou ali awa tomaha ge tomaha i ginolil. Inoke Yabowaine i kite hi waisi. ");
INSERT INTO mpx_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yaka Yabowaine i ba muloluagil i ba, “Moti, nuku talaabab ge nuku gewi, yaka nuku debalala hoga nuku pakalaopop. Bwasumu bolo ku youyou, nuku gewi yaka nuku debalala panayawi pwatanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","He bulin i mowasi ge lan i mowasi, lan nimala panunana to. ");
INSERT INTO mpx_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Yaka Yabowaine i ba, “Bwasumu yawaliliya gaganil ali awa tomaha ge tomaha nihi masal datuwa: bolo totounuwal, bolo hi yawayawal bilibili pwatanaa, ge bolo bekikil, ali awa tomaha ge tomaha.” Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Yabowaine bwasumu bekikil ali awa tomaha ge tomaha, bwasumu totounuwal ali awa tomaha ge tomaha, ge bugul bolo hi yawayawal bilibili pwatanaa ali awa tomaha ge tomaha i ginolil. Inoke Yabowaine i kite i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Yaka Yabowaine i ba, “Gamagal ga ta ginol totola kanukanunula elana ge ni ola kila, yaka moti hogaa, bwasumu hawawala, bwasumu totounuwal, bwasumu bekikil ge bwasumu bolo hi yawayawal bilibili pwatanaa gegewel nihi logugui-agil.” ");
INSERT INTO mpx_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Yabowaine gamagal i ginol totona kanukanununa elana, he iya Yabowaine totona kanukanununa elana i ginolil; gamagalau i ginolil tau ge yova. ");
INSERT INTO mpx_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yaka Yabowaine i ba muloluagil i ba, “Nuku talaabab ge nuku gewi, yaka nuku debalala panayawi nuku pakalaopop ge ni minaa wami logugui gabulanaa. Moti hogaa, bwasumu hawawala ge bugul gegewel yawaliliya gaganil bolo hi nawanawa bilibili pwatanaa nuku logugui-agil.” ");
INSERT INTO mpx_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Yaka Yabowaine i baek elal i ba, “Mwawin gegewel panayawi pwatanaa bolo enowaliya pwatum ge ebwakil gegewel bolo enowaliya pwatumwina gaganina ya pewa. He nuku ahel aanan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ge bwasumu gegewel panayawiya, bwasumu gegewel hawawala, ge bwasumu gegewel bolo hi nawanawa bilibili pwatanaa—he bugul gegewel yawaliliya gaganil—mwawin ge ebwakil lamwaliya gegewel ya pek eliyalil aanan kaiwena.” Inoke i gan i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Inoke Yabowaine bugul gegewel i ginolil i kitel hi waisi hot. He bulin i mowasi ge lan i mowasi, lan sikis-ina to. ");
INSERT INTO mpx_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Inoke Yabowaine labulabum ge panayawi ginebi ge buguliliyau gegewel i ginolil habal. ");
INSERT INTO mpx_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","He mulaa abwe lan seben-ina Yabowaine tuwalali gegewena i ginolil iyaka i pwamowasi, inoke lan seben-ina elana i veyahoem wana tuwalali elana. ");
INSERT INTO mpx_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Inoke lan seben-ina i ba muloluan ge i teli i bwabwalena, kaiwena lan o elana i veyahoem wana tuwalali gegewena elal bolo iyaka i ginolil. ");
INSERT INTO mpx_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yehoba labulabum ge panayawi i ginolil i mowasi, yaka liwanina i ola hiwe. Sauga Yehoba Yabowaine labulabum ge panayawi i ginolil, inoke gamagal al i ginol. ");
INSERT INTO mpx_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Houwan ga nige ebwakil etega o ebo mwawin etega i sisiun bilibiliya, ebo uleya, ebo eyowaa, kaiwena Yehoba Yabowaine nigeya ga kehe i papatuna bilibili i papahun, ge nige gamagal i gagan tage bilibili ni eyowa-an. ");
INSERT INTO mpx_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","He gogau i heem bilibiliya yaka tutulina bilibili pwatana gegewena i pahunhun. ");
INSERT INTO mpx_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yehoba Yabowaine bilibili i ahe gamagal i ginoliya, yaka yawal yawalina gaganina i yana papanetan buhunaa, inoke gamagal yawalina i gan. ");
INSERT INTO mpx_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","He Yehoba Yabowaine eyowa iyaka i ginol labi balimana, labena Ideni elana, inoke tau toto i ginol i teliya eyowa o elana. ");
INSERT INTO mpx_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yehoba Yabowaine ebwakil tomaha ge tomaha ali awa waiwaisal ge enowaliya waiwaisana aanan kaiwena i pasiuniliya to. Eyowa nuwanaa ebwakil labui hi siuna, yawal ana ebwakil ge aatena gegewena waiwaisana ge nanakina ana ebwakil. ");
INSERT INTO mpx_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wewel etega i sani solaa labena Ideni gamwanaa eyowa i pahunhun. Yaka abwe i wali lalana esopali hi tabwa wewel unuliya. ");
INSERT INTO mpx_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Wewel houwan alana Pison, iya i sani solaa labi Havila gamwanaa. (He labi o elana gold i minaa, ");
INSERT INTO mpx_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","goldina i waisi hot. I ola al ebwakil etega suina hi aahe bugul bwalena waiwaisana hi ginoliya ge pat ali awa waiwaisal hi gan al to.) ");
INSERT INTO mpx_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Wewel eluwana alana Gihon, iya i sani solaa labi Kus gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wewel etonina alana Taigilis, iya i sani olak panuwa Asul labena balimana, ge wewel esopalena alana Yupeleitis. ");
INSERT INTO mpx_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yehoba Yabowaine tau i ahe i teliya Ideni eyowana elana, inoke ni tuwalali-an ge ni matahikan. ");
INSERT INTO mpx_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yaka Yehoba Yabowaine i baek tau elana i ba, “I bosowaina te ebwakil gegewel eyowa gamwanaa enowaliya nu anan ya; ");
INSERT INTO mpx_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","yaa aatena gegewena waiwaisana ge nanakina ana ebwakil enowana bahi nu aan, kaiwena sauga toto ebo nu an, he nasi nu aliga.” ");
INSERT INTO mpx_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Inoke Yehoba Yabowaine i ba, “Nige i wawaisi te tau maisena ya ni mimwaumwau. Ana tolaba etega na ginol iya alona.” ");
INSERT INTO mpx_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","He Yehoba Yabowaine iyaka bilibili i ahe bwasumu gegewel i ginoliliya, bolo hi nawanawa bilibili pwatanaa ge bolo hi youyou hawawala. Inoke i enil pwatanik tau elana ge ni kite tau alaliya ga ni tun ola. Inoke tau bwasumu bolo totounuwal, bolo hi youyou hawawala ge bolo bekikil gegewel alaliya i tun. Bugul gegewel alaliya ga i tun ola, he alaliya i ola to. Yaa Adama nige ana tolaba etega i pwapwawa ge alona. ");
INSERT INTO mpx_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Inoke Yehoba Yabowaine tau i pakenu mati. Sauga i kenukenu, inoke luluna tutuwana etega i ahe, yaka tuwana i kaus pasikal. ");
INSERT INTO mpx_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yehoba Yabowaine tau luluna tutuwana i ahe yova i ginoliya, yaka i pwatanik tau elana. ");
INSERT INTO mpx_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Sauga tau yova i kite, yaka i ba, “He abwe o hulhula hot. Tutuwana i neem tutuwau elana ge bunumwina i neem bunumwiu elana. Inoke alana na tun ‘yova’ kaiwena i masalem tau tuwana elana.” ");
INSERT INTO mpx_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Heiya te kaiwena tau tamana ge hinana ni miluwagil ni na alona ge lagona nihi mipamaisena, inoke ali toto labui nihi ola tuwan maisena. ");
INSERT INTO mpx_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","He Adama ge lagona hi bokaboka, yaa nige hi pupuluwawi. ");
INSERT INTO mpx_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bwasumu bolo Yehoba Yabowaine i ginolil gamwaliyaa, he gegewel mwata i siba lakel. Yaka mwata i baek yova elana i ba, “Age Yabowaine ebwakil gegewel eyowa gamwanaa enowaliya i lopwali bahi nuku aan?” ");
INSERT INTO mpx_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Inoke yova mwata anana i lahe i ba, “Bosowaina ya ebwakil gegewel eyowa gamwanaa enowaliya naha anan ya, ");
INSERT INTO mpx_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","iyai ya te ebwakil toto i siuna eyowa nuwanaa enowana nige naha aan. Yabowaine i ba, ‘Ebwakil o enowana bahi nuku aan o ebo nuku pipihikan, eba nuku aliga.’” ");
INSERT INTO mpx_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yaka mwata i baek yova elana i ba, “Nigeya! Nige nuku aaliga. ");
INSERT INTO mpx_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yabowaine i ba ola o kaiwena i atena te sauga ebo nuku an, he abwe matamiu ni mwapwela yaka bugul gegewena waiwaisana ge nanakina nuku atena ge nuku ola iya Yabowaine.” ");
INSERT INTO mpx_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Yova ebwakil i kite ana awa i waisi ge enowana i waisi aanan kaiwena. I ola al i nuwatu i ba, “I waisi te na an inoke na siba.” Inoke enuna i ahe i an. I ola al enuna i pek lagona i an. ");
INSERT INTO mpx_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yaka mataliya i mwapwela ge hi kitel age hi bokaboka, inoke poga lamwana hi bugulan ge hi helil tuwaliya ana ekaukaus. ");
INSERT INTO mpx_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kokoyaviya vetutulina elana Yehoba Yabowaine i nawanawa eyowa gamwanaa, yaka butuna tau ge lagona hi hago, inoke hi na hi bunsumi ebwakil gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yaka Yehoba Yabowaine i yoga tau elana i ba, “Owa ga?” ");
INSERT INTO mpx_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Anana tau i lahe i ba, “Butum ya hago u nawanawa eyowa gamwanaa, inoke ya lovakun ge ya bunsumi, kaiwena ya bokaboka.” ");
INSERT INTO mpx_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Inoke Yehoba Yabowaine i ba, “Ga i ola ge u atena te u bokaboka? Henala ge wam wasa i pewa? Bi ola ebwakil toto ya lopwali enowana u an?” ");
INSERT INTO mpx_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Yaka tau i ba, “Yova toto u pem alou, iya te ebwakil o enowana enuna i pem ya an.” ");
INSERT INTO mpx_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Inoke Yehoba Yabowaine i baek yova elana i ba, “Ga i ola ge u ginol ola o?” Yaka yova i ba, “Mwata i kakaweyau inoke ya ahe ya an.” ");
INSERT INTO mpx_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yaka Yehoba Yabowaine i baek mwata elana i ba, “Kaiwena ginol ya u ginol, inoke sauga ya na ba nuwamut-agiwa ge am lahi na baunan. Am pulowan bwasumu gegewel totounuwal ge bekikil ali pulowan ni bwata lake. Yawalim ana minamina gegewena elana, tinem nu uluwan ge bilibili pwapwalanana kokowam ni papakove. ");
INSERT INTO mpx_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Na ba owa alom ge yova nuku pepihigelgel-agimiu, i ola al tubutubunim ge iya tubutubunina nihi pepihigelgel-agil. Tubutubunina etega kokowam abwe ni puligebal ge owa aena gunina nu tal.” ");
INSERT INTO mpx_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yaka i baek yova elana i ba, “Na ba owa wam liyan elana pulowan ni gewi nu pwawa, ge wam ab elana lomwan bwabwatana nu pwawa. Lagom ana nuwan ni gasisi eliyam ge iya ni logugui-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Yaka i baek Adama elana i ba, “Owa lagom wana baaba u hago ge ebwakil enowana toto ya lopwali u an. Kaiwena ginol o u ginol, inoke sauga ya na ba bilibili ni nak. Yawalim ana minamina gegewena elana nu tuwalali gagasisi ge nu lomwan mulaa abwe enowana nu an. ");
INSERT INTO mpx_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pepesala ge mwawin nanakina nihi siunem bilibiliya kaiwem, yaa aanan nu eyowa-an ga mulaa abwe nu anan. ");
INSERT INTO mpx_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nu tuwalali gagasisi lamwam ni alutan mulaa abwe nu anan, ana siga nu sikal bilibili elana, toto ya ahe ya ginoliwa. Kaiwena owa bilibili, yaka nu sikal nu tabwa bilibili.” ");
INSERT INTO mpx_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adama lagona alana i tun Ive, kaiwena iya gamagalau gegewel yawaliliya gaganina hinaliya. ");
INSERT INTO mpx_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Inoke Yehoba Yabowaine bwasumu kunisina i ahe Adama ge lagona ali kaliko i ginoliya yaka i pagaloil. ");
INSERT INTO mpx_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yaka Yehoba Yabowaine i ba, “Gamagal iyaka bugul gegewena waiwaisana ge nanakina i atena ge i ola kila. Nige bosowaina ge ta talamwan yawal ana ebwakil enowana al ni ahe ni an, eba yawalina ni mihot.” ");
INSERT INTO mpx_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Inoke Yehoba Yabowaine tau ge yova i patuna owaowa-agil hi tagil Ideni eyowana elana, yaka tau bilibili ni eyowa-an, toto Yabowaine i ahe ge i ginoliya. ");
INSERT INTO mpx_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tau ge yova i patuna owaowa-agil i mowasi, yaka bwasumu opeliya gaganina ge elohaveyan kilepana tautauina i huli pwapwati labi gegewena elal, i telel Ideni eyowana labena balimana. Inoke kamwasa hi kausil bahi gamagal etega ni nonok yawal ana ebwakil elana. ");
INSERT INTO mpx_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adama alona ge lagona Ive hi kenukenu, yaka i liyan, inoke natuna melutauina i ab. Yaka i ba, “Yehoba wana labe eliyana wawaya melutauina ya pwawa.” Inoke alana i tun Keni. ");
INSERT INTO mpx_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Yaka abwe al talina Eibol i liyanan ge i ab. Sauga wawayau hi lobwata, inoke Eibol i tabwa sipi ali tomatahikan ge Keni iya toeyowa. ");
INSERT INTO mpx_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Abwe Keni wana eyowa enowana enuna i ahe ge i pek Yehoba ana powon. ");
INSERT INTO mpx_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eibol wana sipi bolo ab houwan enuna i lolil, yaka gabomwiliya waiwaisal i ahel ge i pek Yehoba ana powon. Yaka Yehoba Eibol ge wana powon i yaliyaya-an, ");
INSERT INTO mpx_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","yaa Keni ge wana powon nige i yayaliyaya-an. Inoke Keni i huga nabi ge maninina i lala. ");
INSERT INTO mpx_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Inoke Yehoba i baek Keni elana i ba, “Hauna kaiwena u huga ge maninim i lala? ");
INSERT INTO mpx_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Binimala ebo wam ginol ni sapu, he nasi na yaliyaya-agiwa. Yaa ebo wam ginol ni nak, he gegi iyoho i matamatan ni apanakiwa. Nuwana ni ahewa, yaa owa nu gasisi lake.” ");
INSERT INTO mpx_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Inoke Keni i baek talina Eibol elana i ba, “Ta na ta nawanawa uleya.” Sauga hi na uleya, yaka Keni i tatalut talina i tagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yaka Yehoba i baek Keni elana i ba, “Talim Eibol iya ga?” Anana Keni i lahe i ba, “Nige ya aatena. Age nau taliu ana tomatahikan?” ");
INSERT INTO mpx_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yaka Yehoba i ba, “Hauna kaiwena ginol nanakina ya u ginol? Talim saliyana i lau bilibiliya ge i kahin ha eliyau, nuwana ana lol lahena na ginol. ");
INSERT INTO mpx_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Talim u tagapaaliga ge saliyana bilibili u paim, inoke am ba nuwamut na baunan na ba bilibili ni nak nige al bosowaim nu tuwalali-an. ");
INSERT INTO mpx_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sauga ebo bilibili nu eyowa-an, he nige wam tuwalali enowana ni pepewa. Nige abam hot ni gagan, yaa nu nononawanawa ya panayawiya.” ");
INSERT INTO mpx_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Yaka Keni i baek Yehoba elana i ba, “Lahi ya i bwata hot ge nige bosowaiu na mikalivai! ");
INSERT INTO mpx_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","He iyaka u patuna owaowa-agau nige al bosowaina bilibili na tuwalali-an ge o bwaga ni yapu maninimwa. Nige abau hot ni gagan, yaa na nononawanawa ya panayawiya. Ge ebo gamagalau nihi nopwawau, nasi nihi tagapaaligau.” ");
INSERT INTO mpx_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yaka Yehoba i baek Keni elana i ba, “Nigeya! Ebo gamagal etega ni tagapaaligawa, wana ginol o lahena na ginol elana ni bwata hot.” Inoke Yehoba etotohi etega i teli Keni tuwanaa i lopwali ebo gamagalau Keni nihi nopwawa bahi nihi tatagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Yaka Keni i egon ana bwaga i yapu Yehoba manininaa, i na i minaa panuwa alana Nodi, iyoho Ideni labena balimana. ");
INSERT INTO mpx_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Keni alona ge lagona hi kenukenu, yaka i liyan ge i ab, inoke wawaya alana hi tun Inok. (He Keni panuwa bwabwatana i sepa ge i tal, yaka natuna Inok alana i tun pwatanek panuwa o elana.) ");
INSERT INTO mpx_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Abwe Inok natuna i gan alana Ilad. Yaka Ilad natuna alana Mehuyael, Mehuyael natuna alana Metusael, ge Metusael natuna alana Lemeki. ");
INSERT INTO mpx_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemeki yowau labui i alolonagil, etegana alana Eda ge etegana alana Silaa. ");
INSERT INTO mpx_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eda i ab natuna alana Yabal, iya houwan hot i minaa epanapana elana yaka sipi, goti ge bulumwakau ali matamatahikan i pamasal. ");
INSERT INTO mpx_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Talina alana Yubal, iya hapi ge igo i galavenu-an pamasal. ");
INSERT INTO mpx_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silaa i ab natuna alana Tubal-Keni, iya etuwalali tomaha ge tomaha kopa ge aiyan elana i ginoliya. He nuna alana Nama. ");
INSERT INTO mpx_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemeki i ba haha, i baek lagonau elalil i ba, “Eda ge Silaa, nuku laegan eliyau, nau Lemeki lagowau komiu, no baaba nuku hago. Tau etega i lolau yaka ya tagapaaliga, he ya tagapaaliga kaiwena i palomwanagau. ");
INSERT INTO mpx_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Gamagal toto Keni ni tagapaaliga, wana ginol lahena ni bwata hot, yaa gamagal toto nau Lemeki ni lolau, wana ginol lahena nau na ginol eliyana ni bwata nabiyan hot.” ");
INSERT INTO mpx_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama alona ge lagona hi kenukenu, yaka i liyan al ge i ab natuna melutau. Yaka i ba, “Yabowaine natu etega al i pem Eibol lahena, kaiwena Keni Eibol i tagapaaliga.” Inoke natuna alana i tun Seti. ");
INSERT INTO mpx_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Abwe Seti natuna i gan alana i tun Inosi. He sauga o elana gamagalau hi telipuna hi tapwatapwalolo Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama alonau natunau ge tubutubunau liwaniliya i ola hiwe. Sauga Yabowaine gamagal i ginolil, he iya totona kanukanununa elana i ginolil. ");
INSERT INTO mpx_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I ginolil tau ge yova, inoke i ba muloluagil, ge alaliya i tun, “gamagal.” ");
INSERT INTO mpx_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama wana baliman 130 yaka natuna tau etega al i gan. Wawaya ya Adama kanukanununa, i ola ya te iya. Inoke alana i tun Seti. ");
INSERT INTO mpx_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti hi ab enaa, Adama i minamina al baliman 800 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","He Adama wana baliman gegewena 930 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti wana baliman 105 yaka natuna i gan alana Inosi. ");
INSERT INTO mpx_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosi hi ab enaa, Seti i minamina al baliman 807 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","He Seti wana baliman gegewena 912 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inosi wana baliman 90 yaka natuna i gan alana Keinan. ");
INSERT INTO mpx_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Keinan hi ab enaa, Inosi i minamina al baliman 815 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","He Inosi wana baliman gegewena 905 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Keinan wana baliman 70 yaka natuna i gan alana Mahalalil. ");
INSERT INTO mpx_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalil hi ab enaa, Keinan i minamina al baliman 840 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","He Keinan wana baliman gegewena 910 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalil wana baliman 65 yaka natuna i gan alana Yaledi. ");
INSERT INTO mpx_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yaledi hi ab enaa, Mahalalil i minamina al baliman 830 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","He Mahalalil wana baliman gegewena 895 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi wana baliman 162 yaka natuna i gan alana Inok. ");
INSERT INTO mpx_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inok hi ab enaa, Yaledi i minamina al baliman 800 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","He Yaledi wana baliman gegewena 962 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inok wana baliman 65 yaka natuna i gan alana Metuisela. ");
INSERT INTO mpx_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metuisela hi ab enaa, Inok i mipalalek hot Yabowaine elana baliman 300 al, yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","He Inok wana baliman gegewena 365 i pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inok i mipalalek hot Yabowaine elana, yaka lan etegana Yabowaine Inok i ahe egonan ge nige al hi kikite. ");
INSERT INTO mpx_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuisela wana baliman 187 yaka natuna i gan alana Lemeki. ");
INSERT INTO mpx_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemeki hi ab enaa, Metuisela i minamina al baliman ana gewi 782 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","He Metuisela wana baliman gegewena 969 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemeki wana baliman 182 yaka natuna tau i gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Inoke i ba, “Valila Yehoba i ba bilibili ni nak inoke ta tuwalali gagasisi ge ta lomwan, yaa wala lomwan o eliyana wawaya ya ni payaliyaya-agila.” Inoke natuna alana i tun Nowa. ");
INSERT INTO mpx_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowa hi ab enaa, Lemeki i minamina al baliman ana gewi 595 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","He Lemeki wana baliman gegewena 777 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowa wana baliman 500 inoke natunau hi gan alaliya Semi, Hami ge Yapeta. ");
INSERT INTO mpx_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sauga gamagalau hi gewi hi debalala panayawiya ge natuliyau yowau hi abil hi gewi, ");
INSERT INTO mpx_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","he Yabowaine natunau melutauil panayawi gamagaliliyau natuliyau yowau hi kitel ali awa i lowaisi hot, inoke bolo nuwaliya i noek hi alolonagil. ");
INSERT INTO mpx_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Inoke Yehoba i ba, “Yawal toto ya pek gamagalau eliyalil nige ni mimihot. He heliya gamagalau ya, yawaliliya abwe ni mowasi. Inoke yawaliliya ana yapu besena te baliman 120.” ");
INSERT INTO mpx_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He sauga Yabowaine natunau melutauil avaliyau panayawi gamagaliliyau natuliyau yowau hi kenu toyawa, yaka hi ab natuliyau hi hul kantutubwai. Inoke saugena o ge sauga o enaa al, gamagalau ololal o hi gan, heliya toasiyala bolo houhouwel, alaliya bwabwatana. ");
INSERT INTO mpx_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yehoba i kite gamagalau wali gegi i bwata nabi ge nuwatu nanakina ya te hi mimi nuwanuwatu-an ateliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yaka nuwana i nak ge i ba, “Hauna kaiwena gamagalau ya ginolil ya telel panayawi ge hi gegi?” Inoke atena i palomwan nabiyan. ");
INSERT INTO mpx_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yaka i ba, “Gamagalau bolo ya ginolil, avaliyau bwasumu bolo hi nawanawa, bolo hi yawayawal ge bolo hi youyou, gegewel na pwamowasel. Nuwau i nak te ibwe ge ya ginolil.” ");
INSERT INTO mpx_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yaa Yehoba Nowa i awa wawaisian ge i yaliyaya-an. ");
INSERT INTO mpx_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","He Nowa alonau natunau liwaniliya i ola hiwe. Nowa wana pagan i sapu ge iya maisena ya sauga o gamagaliliyau gamwaliyaa nige wana ginol nanakina i gagan, yaa i mipalalek hot Yabowaine elana. ");
INSERT INTO mpx_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","He Nowa natunau bolau eton alaliya te Semi, Hami ge Yapeta. ");
INSERT INTO mpx_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Yabowaine matanaa gamagalau panayawi wali ginol i nak nabi ge lohalohaveyan i gasisi labena gegewena elal. ");
INSERT INTO mpx_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yabowaine i kite panayawi iyaka i nak hot gamagalau gegewel wali pagan nanakina kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Inoke i baek Nowa elana i ba, “Ya nuwatu gamagalau gegewel ge panayawi na apanakil nihi mowasi, kaiwena wali lohalohaveyan i gasisi labena gegewena elal. ");
INSERT INTO mpx_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Inoke kewadi waiwaisal nu ahel nu talil wam waga etega nu ginol. Baba tomwa ona nu ginolil gamwanaa, yaka kolta nu ahe gamwanaa ge tolinaa nu ebaliya. ");
INSERT INTO mpx_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","He nu ginol ni ola hiwe: ana yapu 140 mita, ana magaga 23 mita ge ana miha 13.5 mita. ");
INSERT INTO mpx_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Pwatana nu kaus ge hawawal ana bwata ni ola 50 sentamita ni gan ana vavan ge ana helhel ali hawawala. Ana nog nu ginol bebenaa, ge gamwana eton nu ginolil, etegana paiya, etegana nuwanuwanaa, ge etegana natiya. ");
INSERT INTO mpx_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","He nau abwe kehe na patuna panuwa ni tub ge nub ni ha, yaka bugul gegewel bolo hi yanayana yoho ni apanakil. Inoke bugul gegewel panayawi pwatanaa nihi aliga. ");
INSERT INTO mpx_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Yaa owa elam no bateli na ginol na pwamwalimiu. He alomwau lagom, natumwau ge lagoliyau, nuku na nuku ulutuk wagaa. ");
INSERT INTO mpx_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Bwasumu gegewel yawaliliya gaganina, eluwa eluwa, tau ge yova, nu ahel, inoke bahi nihi aaliga. ");
INSERT INTO mpx_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bwasumu bolo hi youyou gegewel, bolo hi nawanawa gegewel ge bolo hi yawayawal gegewel, eluwa eluwa alomwau nuku tuk wagaa, inoke bahi nihi aaliga. ");
INSERT INTO mpx_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","I ola al aanan tomaha tomaha ona nu ahel ge nu bugul tukagil alomiyau ge bwasumu amiu.” ");
INSERT INTO mpx_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Inoke Nowa bugul gegewena i ginol i ola Yabowaine wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yaka lan etega Yehoba i baek al Nowa elana i ba, “Heyan sauga ya gamwaliyaa, ya kitewa owa maisem wam pagan i sapu. Inoke alomwau am heniheni ku na ku ulutuk wagaa. ");
INSERT INTO mpx_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bwasumu gegewel bolo bosowaina powon, ali gewi seben, aloliyau ge lagoliyau, nu ahel. Bwasumu gegewel bolo nige bosowaina powon, eluwa eluwa, aloliyau ge lagoliyau, nu ahel. ");
INSERT INTO mpx_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ge bwasumu gegewel bolo hi youyou, ali gewi seben, aloliyau ge lagoliyau, nu ahel. He nu ahel alomwau nuku ulutuk wagaa, inoke bwasumu tomaha ona bahi etega ni momowasi panayawiya. ");
INSERT INTO mpx_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Lan seben ya ni mowasi, yaka na ba lan poti ge bulin poti kehe ni laulau. Inoke bugul gegewel yawaliliya gaganina bolo ya ginolil, na pwamowasel panayawiya.” ");
INSERT INTO mpx_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Inoke Nowa bugul gegewena i ginol i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","He Nowa wana baliman 600 te nub i ha. ");
INSERT INTO mpx_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Yaka alonau lagona, natunau ge lagoliyau, hi ulutuk wagaa nub hi lou luwan. ");
INSERT INTO mpx_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","He avaliyau bwasumu bolo hi nawanawa, bolo hi youyou ge bolo hi yawayawal—bolo bosowaina powon ge bolo nige bosowaina powon. ");
INSERT INTO mpx_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Bwasumu gegewel o, eluwa eluwa, tau ge yova, avaliyau hi ulutuk wagaa i ola Yabowaine wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Lan seben i mowasi, yaka panuwa i tub ge nub i ha. ");
INSERT INTO mpx_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","He liwanina i ola hiwe. Nowa wana baliman 600, weikena eluwana ana lan sebentin-ina elana, wewel bwabwatana i sani heem bilibili gamwanaa, ge labulabum i mwapwela kehe i maligin laulau. ");
INSERT INTO mpx_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Yaka lan poti ge bulin poti kehe i mimi laulau. ");
INSERT INTO mpx_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lan toto o elana Nowa alonau lagona, natunau Semi, Hami ge Yapeta, aloliyau lagoliyau hi ulutuk wagaa. ");
INSERT INTO mpx_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","He avaliyau bwasumu sosokal tomaha ge tomaha, bwasumu totounuwal tomaha ge tomaha, bwasumu bolo hi yawayawal tomaha ge tomaha, ge bwasumu bolo hi youyou tomaha ge tomaha. ");
INSERT INTO mpx_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bugul gegewel bolo hi yanayana yoho, eluwa eluwa, tau ge yova, avaliya Nowa hi ulutuk wagaa, ");
INSERT INTO mpx_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","i ola Yabowaine wana baaba. He sauga Nowa i ulutuk, inoke Yehoba waga ana nog i kaus. ");
INSERT INTO mpx_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lan poti ge bulin poti nub i haha ya. Wewel iyaka i bwata nabi, inoke waga i ota hin. ");
INSERT INTO mpx_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Wewel iyoho i bwabwata heheya, yaka waga i otaota wewel pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Wewel iyoho i bwabwata heheya, yaka oya i yabomwil, ");
INSERT INTO mpx_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","oya i heluwan ana miha i ola 7 mita. ");
INSERT INTO mpx_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bugul gegewel panayawi pwatanaa hi aliga—bwasumu bolo hi youyou, bolo totounuwal, bolo bekikil ge bolo kekeisi ona, ginebi ge gamagal. ");
INSERT INTO mpx_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bugul gegewel bolo hi yanayana yoho ge hi miminaa bilibili pwatanaa hi mowasi. ");
INSERT INTO mpx_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yehoba bugul gegewel yawaliliya gaganina, gamagal, bwasumu bolo hi nawanawa, bolo hi yawayawal ge bolo hi youyou, i pwamowasel. Nowa alonau ge alonau bolo wagaa ya te hi mwal. ");
INSERT INTO mpx_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Lan ali gewi 150 wewel iyoho i bwata panayawi i yabom. ");
INSERT INTO mpx_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Yaa Nowa alonau ge bwasumu totounuwal ge bekikil wagaa, Yabowaine nige i nunuluwagil. Inoke i ba mana i towa panayawiya, yaka wewel i taltal lau. ");
INSERT INTO mpx_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","He iyaka wewel bwabwatana nige al i sasani heem bilibili gamwanaa ge kehe nige al i mamaligin laulau. ");
INSERT INTO mpx_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Inoke wewel iyoho i taltal lau. Lan ali gewi 150 i mowasi wewel iyaka i lau, ");
INSERT INTO mpx_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","inoke weikena seben-ina ana lan sebentin-ina elana, waga i buntal labi Alalat oyana etega elana. ");
INSERT INTO mpx_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Wewel iyoho i taltal lau, yaka weikena elulutega ana lan houwan elana oya pwataliya hi hopit. ");
INSERT INTO mpx_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lan poti al i mowasi, Nowa waga ana windo toto iyaka i ginol i pwela ");
INSERT INTO mpx_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ge okok i patuna i you tagil. Nige i sisikal wagaa, he i youyou pwatpwat ya ana siga wewel i mowasi ge bilibili i kevakeva. ");
INSERT INTO mpx_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Yaka bunibuni al i patuna i tagil ge ni atena ebo wewel iyaka i tal lau ge bilibili i dato. ");
INSERT INTO mpx_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Yaa wewel iyoho ya i bwayabwaya bilibili i yayabom, inoke bunibuni nige wana abayoutal i pwapwawa. Yaka i you sikal i na wagaa, inoke Nowa nimana i paelu tagilan yaka bwasumu i youtala ge i teli tukan. ");
INSERT INTO mpx_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowa i matamatan al lan seben i mowasi, yaka bunibuni i patuna al i tagil. ");
INSERT INTO mpx_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kokoyaviya bunibuni i you sikal Nowa elana, he olibe lamwana kolena etega i alahikan awanaa. Inoke Nowa i atena te wewel iyaka i tal lau. ");
INSERT INTO mpx_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Inoke i matamatan al lan seben i mowasi, yaka abwe bunibuni i patuna al i tagil. Yaa sauga toto o nige i yoyou sikal Nowa elana. ");
INSERT INTO mpx_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowa wana baliman 601, weikena houwan ana lan houwan elana, wewel iyaka i tal lau ge bilibili i dato. Yaka Nowa waga pwatana i pwela yoho, inoke matana i nok i kite bilibili pwatana iyaka i dato. ");
INSERT INTO mpx_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","He weikena eluwana ana lan tuwenti seben-ina (27-ina) elana bilibili iyaka i kevakeva hot. ");
INSERT INTO mpx_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yaka Yabowaine i baek Nowa elana i ba, ");
INSERT INTO mpx_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Alomwau lagom, natumwau ge lagoliyau waga ku loluwai ku tagil noleleya. ");
INSERT INTO mpx_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bwasumu bolo hi youyou, bolo hi nawanawa ge bolo hi yawayawal, gegewel nu ahel alomwau nuku tagil tola. Inoke heliya abwe nihi talaabab ge nihi gewi, yaka nihi debalala panayawiya.” ");
INSERT INTO mpx_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yaka Nowa alonau lagona, natunau ge lagoliyau, waga hi loluwai hi tagil noleleya. ");
INSERT INTO mpx_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Yaka bwasumu bolo hi nawanawa, bolo hi yawayawal ge bolo hi youyou, tomaha ge tomaha ali pwahin elana hi tagilem wagaa. ");
INSERT INTO mpx_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Yaka Nowa pat i pahe abapowon i ginol ge ni tapwalolo Yehoba elana. Yaka bwasumu bolo bosowaina powon, bolo hi nawanawa ge bolo hi youyou, enuna i ahel ge i powon pwabwaligel Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yehoba powon bwalena i hago ge i awa wawaisian, yaka atena elana i ba, “Bwagana gamagalau nuwatu nanakina ya te hi nuwanuwatu-an ateliyaa, i telipunaa wali sauga wawaya elana, he nige al na babaa ge panayawi na aapanak wali ginol nanakina kaiwena. Ge nige al bwasumu gegewel na aapapanak-agil ni oola toto iyaka ya ginol. ");
INSERT INTO mpx_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Panayawi miminana elana, logalagalauma ge lovelovetomwa, tultul ge kalakalas, kehe ge sabwelu, lan ge bulin, ni gangan ya nige ni momowasi.” ");
INSERT INTO mpx_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yaka Yabowaine Nowa ge natunau i ba muloluagil i ba, “Nuku talaabab ge nuku gewi, yaka nuku debalala panayawi nuku pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bwasumu gegewel, bolo hi nawanawa, bolo hi youyou, bolo hi yawayawal, ge moti gegewel nihi lovakunagimiu. Iyaka ya telel wami logugui elana ge nuku logugui-agil. ");
INSERT INTO mpx_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bugul gegewel yawaliliya gaganina nuku anan ya. Valila bugul siusiunil enowaliya ge lamwaliya ya pewa amiu, yaa sauga ya bugul gegewena ya pewa eliyamiu aanan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Yaa bahi bunum salisaliyana nuku an, kaiwena yawal i minaa saliya eliyana. Saliya ga ni lohaba yaka abwe nuku an. ");
INSERT INTO mpx_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","He ebo bwasumu etega gamagal etega ni tal saliyana ni lau ge yawalina ni mowasi, nau abwe ana lahi na ginol. I ola al ebo gamagal etega alona yawalina ni pwamowasi, nau abwe ana lahi na ginol. ");
INSERT INTO mpx_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ebo gamagal etega alona yawalina ni pwamowasi, he iya al yawalina gamagalau nihi pwamowasi, kaiwena nau Yabowaine gamagalau ya ginolil totou kanukanunu elana. ");
INSERT INTO mpx_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“He nuku talaabab ge nuku gewi, yaka ami boda ni bwata panayawiya.” ");
INSERT INTO mpx_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yaka Yabowaine i baek Nowa alonau natunau eliyalil i ba, ");
INSERT INTO mpx_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sauga ya no bateli na ginol eliyamiu, tubutubumiyau eliyalil, ");
INSERT INTO mpx_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ge bugul gegewel bolo yawaliliya gaganina eliyalil — bwasumu bolo hi youyou, bolo totounuwal, ge bolo bekikil — bolo alomiyau ku tagilem wagaa. ");
INSERT INTO mpx_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","He ya bateli te nige al na babaa nub ni gagan ge bwasumu gegewel ni pwapwamowasel, nige al nub panayawi ni aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Yaka Yabowaine i ba al i ba, “Bateli toto ya ginol eliyamiu ge bwasumu gegewel eliyalil, iya bateli mihomihotina heyan mulaa gegewel kaiweliya. He bateli o ana etotohi i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Liliyal na ginol yaluyalu eliyalil, inoke ni tabwa no bateli ana etotohi, bateli toto ya ginol panayawi elana. ");
INSERT INTO mpx_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sauga ebo yaluyalu na ginol panayawi ni yabom ge liliyal ni masal yaluyaluwa, ");
INSERT INTO mpx_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","yaka no bateli na nuwahikan, toto ya ginol eliyamiu ge bugul gegewel yawaliliya gaganina eliyalil. He nige al nub ni tutub ge bugul gegewena ni aapapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Sauga ebo liliyal ni masal yaluyalu eliyalil ge na kite, inoke ni panuwahikagau bateli mihomihotina kaiwena, toto nau Yabowaine ya ginol bugul gegewel yawaliliya gaganina panayawiya eliyalil.” ");
INSERT INTO mpx_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","He Yabowaine i ba i ola to Nowa elana, i ba, “Liliyal iya no bateli ana etotohi, toto ya ginol bugul gegewel panayawiya eliyalil.” ");
INSERT INTO mpx_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowa natunau bolo hi tagilem wagaa alaliya Semi, Hami ge Yapeta. (He Hami iya Kenani tamana.) ");
INSERT INTO mpx_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowa natunau ali toto eton ya, heliya gamagalau gegewel panayawiya tubuliyau. ");
INSERT INTO mpx_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa iya toeyowa ge iya houwan hot oine ana eyowa i ginol ge i galaumaan. ");
INSERT INTO mpx_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sauga etegana Nowa oine i im kokona-an, yaka i kenu bokaboka wana epanapana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenani tamana Hami i tuk tamana bobokana i kite, yaka i tagil i lowasawasa-an talinau eluwa elal. ");
INSERT INTO mpx_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yaka Semi ge Yapeta kaliko etega hi ahe hi anal vevelaliyaa ge hi pihikan, yaka eliya hi huwalaan hi na tamaliya hi pahabobu. He mataliya hi ligetoga-an ge bahi tamaliya bobokana nihi kikite. ");
INSERT INTO mpx_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sauga oine wana gasisi i mowasi ge Nowa i lut, yaka wasa i hago natuna toalaalahul Hami wana ginol kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Inoke i ba: “Sauga ya Kenani ya ba nuwamut-an. Iya ni totuwalali loloyowan hot talinau elal.” ");
INSERT INTO mpx_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yaka i ba al: “Yehoba ya tobalan, iya Semi wana Yabowaine! He Kenani ni totuwalali loloyowan Semi elana. ");
INSERT INTO mpx_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ya awanun Yabowaine Yapeta wana labi ni pwabwata, i ola al tubutubunau ge Semi tubutubunau nihi mibubun. He Kenani ni totuwalali loloyowan elana.” ");
INSERT INTO mpx_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nub enaa, Nowa i minamina al baliman 350. ");
INSERT INTO mpx_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","He Nowa wana baliman gegewena 950 i pwawa, yaka abwe i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowa natunau Semi, Hami ge Yapeta, avaliyau natuliyau ge tubutubuniliyau liwaniliya i ola hiwe. He nub enaa natuliyau hi gewi hi abil. ");
INSERT INTO mpx_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapeta natunau bolau heliya Gomeli, Magog, Madai, Yavan, Tubal, Meseki ge Tilasi. ");
INSERT INTO mpx_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeli natunau bolau te Askenasi, Lipat ge Togalama. ");
INSERT INTO mpx_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan natunau bolau te Elaisa, Talsis, ge boda Kit tubuliya ge Lodan tubuliya. ");
INSERT INTO mpx_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","He boda bolo hi miminaa Hoga Mediteleiniya bebenaa ge tavalina ona elal hi neem Yavan natunau o elal. Hi miminek tomaha wali labi ge wali panuwa ona elal, ge anan tomaha ona hi baubaunan. ");
INSERT INTO mpx_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hami natunau bolau heliya Kus, Itipita, Puti ge Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus natunau bolau te Seeba, Havila, Sabita, Laama ge Sabiteka. Laama natunau bolau te Seba ge Dedan. ");
INSERT INTO mpx_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus tubutubunina etega te Nimlod. Iya haveyan ana toematana gasigasisena, yaka alonau wana boda panuwa hi gewi hi pakokovel. ");
INSERT INTO mpx_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yehoba wana labe eliyana iwauka i sibaan. Inoke heiya te kaiwena gamagalau wali ebaaba etega i ola hiwe, “Tau ya i ola te Nimlod, iya houhouwena Yehoba wana labe eliyana iwauka i sibaan.” ");
INSERT INTO mpx_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Wana abalogugui i tal houwan labi Babiloniya elana, panuwa Babiloni, Elek, Akad ge Kalne elal. ");
INSERT INTO mpx_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Yaka abwe i na al labi Asiliya inoke panuwa bwabwatal bolo Ninibe, Lehobot-Il, Kala ");
INSERT INTO mpx_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ge Lesen i ginolil. He Lesen i minaa Ninibe ge panuwa bwabwatana Kala ali hawawala. ");
INSERT INTO mpx_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Itipita tubutubunau heliya boda Lud, Anam, Lehab, Naptuhi, ");
INSERT INTO mpx_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patulusi, Kasiluhi ge Kaptoli. He boda Pilistiya hi neem al boda Kaptoli elal. ");
INSERT INTO mpx_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kenani natuna gamaun te Saidoni. Natunau al hi gan, inoke Kenani tubutubunau te boda Hiti, ");
INSERT INTO mpx_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebusi, Amoli, Gegasi, ");
INSERT INTO mpx_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi, Alki, Sini, ");
INSERT INTO mpx_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Alvadi, Semali ge Hamati. Un bolo Kenani tubutubunau hi miwaliwali labi tomaha ge tomaha, ");
INSERT INTO mpx_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","yaka labi toto hi miminaa i telipunaa panuwa Saidoni ge i nok Gelal kaiwena ana siga te Gasa, ge i ola al i nok Sodoma, Gomola, Adima ge Seboim kaiweliya ana siga te Lasa. ");
INSERT INTO mpx_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","He Hami natunau ge tubutubunau i ola to. Inoke un bolo o anan tomaha ona hi baubaunan ge hi miminek tomaha wali labi ge wali panuwa ona elal. ");
INSERT INTO mpx_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi, iya Yapeta talina bwabwatana, natunau al hi gan. (He iya Ebe alonau tubutubunau tubuliya houhouwena.) ");
INSERT INTO mpx_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semi natunau bolau te Elam, Asul, Alpakad, Lud ge Alam. ");
INSERT INTO mpx_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alam natunau bolau te Us, Hul, Geta ge Meseki. ");
INSERT INTO mpx_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alpakad iya Sela tamana ge Sela iya Ebe tamana. ");
INSERT INTO mpx_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebe natunau bolau eluwa. Etegana alana hi tun Peleg, kaiwena wana sauga elana gamagalau hi miwaliwali panayawi labena gegewena elal. He Peleg talina alana hi tun Yoktan. ");
INSERT INTO mpx_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan natunau te Alimodad, Selep, Hasamavet, Yela, ");
INSERT INTO mpx_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadolam, Usal, Dikila, ");
INSERT INTO mpx_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO mpx_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opil, Havila ge Yobab. He Yoktan tubutubunau i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Labena toto hi miminaa i telipunaa Mesa ge i na Sepal, iyoho labi manaoyaoya toto balimana. ");
INSERT INTO mpx_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","He Semi natunau ge tubutubunau i ola to. Inoke un bolo o anan tomaha ona hi baubaunan ge hi miminek tomaha wali labi ge wali panuwa ona elal. ");
INSERT INTO mpx_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","He Nowa natunau ge tubutubunau ali lihu ana siga to, ge tomaha wali labi elana hi miminek. Inoke nub enaa, heliya eliyalil boda tomaha ona hi masalem ge hi miwaliwali panayawi labena gegewena elal. ");
INSERT INTO mpx_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Valila gamagalau gegewel panayawiya analiya maisena ya ge wali baaba i maisena. ");
INSERT INTO mpx_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","He gamagalau hi mimi heheya labi balimana, inoke abwab bwabwatana etega hi pwawa labi Babiloniya elana yaka hi minaa to. ");
INSERT INTO mpx_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yaka abwe hi pebaaba-agil hi ba, “Ehei! Bilibili ta ahe bilik ta ginolil yaka ta tonil ge nihi gasisi.” Inoke hi ginol ola to, yaka bilik hi ahe limi hi taliya, ge kolta hi ahe bilik hi papihikagil. ");
INSERT INTO mpx_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yaka abwe hi ba, “Ehei! Wala panuwa bwabwatana etega ta ginol ge limi mihahaina hot etegana ta tal ni na ni tupa yaluyaluwa. Ta ginol ola o, inoke alala ni bwata ge bahi ta mimiwaliwali panayawi labena gegewena elal.” ");
INSERT INTO mpx_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yaa Yehoba i nem i lau panuwa bwabwatana ge limi mihahaina hot toto gamagalau hi taltal o i kitel. ");
INSERT INTO mpx_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Inoke i ba, “Gamagalau ya heliya boda maisena ge anan maisena elana hi baaba. Sauga ya bugul ya hi giginol, he bwaliga abwe bugul ni gewi al nihi ginolil. Ebo bugul etega nihi nuwatuan, he bosowailiya ya te nihi awaawaginol ya. ");
INSERT INTO mpx_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ehei! Ta na ta lau analiya ta pasamwayagayaga inoke bahi avaliyau wali baaba ana sapu nihi aatena.” ");
INSERT INTO mpx_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Inoke eliyana Yehoba gamagalau i waliwali-agil hi na panayawi labena gegewena elal, yaka panuwa o nige al hi tatal. ");
INSERT INTO mpx_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Inoke panuwa alana hi tun Babiloni kaiwena panuwa o elana Yehoba gamagalau gegewel analiya i pasamwayagayaga, yaka eliyana i waliwali-agil panayawi labena gegewena elal. ");
INSERT INTO mpx_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Semi alonau natunau ge tubutubunau liwaniliya i ola hiwe. Nub i mowasi enaa baliman eluwana elana, Semi wana baliman 100 yaka natuna i gan alana Alpakad. ");
INSERT INTO mpx_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Alpakad hi ab enaa, Semi i minamina al baliman 500 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alpakad wana baliman 35 yaka natuna i gan alana Sela. ");
INSERT INTO mpx_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela hi ab enaa, Alpakad i minamina al baliman 403 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela wana baliman 30 yaka natuna i gan alana Ebe. ");
INSERT INTO mpx_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebe hi ab enaa, Sela i minamina al baliman 403 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebe wana baliman 34 yaka natuna i gan alana Peleg. ");
INSERT INTO mpx_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg hi ab enaa, Ebe i minamina al baliman 430 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg wana baliman 30 yaka natuna i gan alana Liu. ");
INSERT INTO mpx_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Liu hi ab enaa, Peleg i minamina al baliman 209 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Liu wana baliman 32 yaka natuna i gan alana Selag. ");
INSERT INTO mpx_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Selag hi ab enaa, Liu i minamina al baliman 207 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selag wana baliman 30 yaka natuna i gan alana Naho. ");
INSERT INTO mpx_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naho hi ab enaa, Selag i minamina al baliman 200 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naho wana baliman 29 yaka natuna i gan alana Tela. ");
INSERT INTO mpx_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tela hi ab enaa, Naho i minamina al baliman 119 yaka natunau bolau ge yowau enuna al hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela wana baliman 70 yaka natunau hi gan alaliya Abalam, Naho ge Halan. ");
INSERT INTO mpx_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","He Tela alonau natunau ge tubunau liwaniliya i ola hiwe. Tela natunau hi gan alaliya Abalam, Naho ge Halan. Inoke Halan natuna i gan alana Lote. ");
INSERT INTO mpx_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","He Tela yawalina miminana, natuna Halan i aliga panuwa Ul, labi Koldiya elana, panuwa toto hi aba. ");
INSERT INTO mpx_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abalam i alolon lagona alana Selai ge Naho i alolon lagona alana Milika, iya Halan natuna. He Milika talina alana Iska. ");
INSERT INTO mpx_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Yaa Selai i kobwas yaka nige i aab. ");
INSERT INTO mpx_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela i lut natuna Abalam, tubuna Lote (Halan natuna) ge yawana Selai (Abalam lagona) i ahel, yaka panuwa Ul labi Koldiya elana hi eguluwan ge nihi nok nihi na Kenani. Yaa sauga hi vin panuwa Halani, yaka hi miminaa ga to. ");
INSERT INTO mpx_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela wana baliman 205 i pwawa, yaka i aligaa panuwa Halani. ");
INSERT INTO mpx_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yehoba i baek Abalam elana i ba, “Wam panuwa, tutumwau, ge tamwam wana limi ana heniheni nu eguluwagil nu na panuwa toto abwe na pankitewa. ");
INSERT INTO mpx_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yaka tubutubumwau nihi gewi na pewa nihi tabwa boda gasigasisena etega, ge na mulolu-agiwa. Alam na pwabwata, ge owa eliyam gamagalau mulolu nihi pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bolo nihi mulolu-agiwa nau na mulolu-agil, yaa bolo ami hehegan hi apapanak-an nau na nuwamut-agil. Ge owa eliyam un gegewel panayawiya na muloluagil.” ");
INSERT INTO mpx_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abalam wana baliman 75, yaka panuwa Halani i eguluwai ge i nawanawa, i ola Yehoba wana baaba eliyana. He Lote al ge i nok alona. ");
INSERT INTO mpx_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abalam, lagona Selai ge talina natuna Lote i ahel alonau, ginebi gogomwau gegewena ge totuwalali gegewel bolo hi pwawal Halani elana. Yaka panuwa o hi eguluwai ge hi nawanawa Kenani kaiwena. Sauga hi vin, ");
INSERT INTO mpx_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","inoke Abalam labi Kenani gamwana i nosolaan ge i nawanawa i na i vin Mole wana kawadi bwabwalena elana panuwa Sekemi elana. He saugenana o Kenani gamagaliliyau iyoho ya hi minamina labi Kenani elana. ");
INSERT INTO mpx_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yaka Yehoba i masal Abalam elana ge i ba, “Labi toto ya ya pewa tubutubumwau eliyalil.” Yaka Abalam pat i pahe abapowon i ginol panuwa o elana ge i tapwaloloek Yehoba elana, iya i masala elana. ");
INSERT INTO mpx_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Toto o enaa, yaka Abalam i egon i noek labi manaoyaoya elana panuwa Betel labi nati, ge wana epanapana i pamilil panuwa Betel ge Ai ali luwaluwala. He panuwa Betel i minek labi pai ge panuwa Ai i minek labi nati. Yaka abapowon etega al i ginol ge i tapwalolo Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Toto o enaa, yaka i novevehe al i nanawa labi kekevana Negeb kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Yaka galebu bwabwatana etega i masal labi Kenani elana. He galebu o i bwata hot, inoke Abalam i na Itipita ge i miminek ga to. ");
INSERT INTO mpx_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Kelaubwa Abalam ni vin Itipita ana labiya, yaka i baek lagona elana i ba, “Selai, ya atena te am awa i waisi hot. ");
INSERT INTO mpx_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","He ebo Itipita nihi kitewa, nasi nihi ba, ‘Lagona to.’ Yaka nihi tagapaaligau ge owa nihi pwamolowa. ");
INSERT INTO mpx_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","He nu baek eliyalil nu ba, ‘Nu te,’ inoke owa kaiwem o hehegan nihi abubun ge yawaliu nihi pwamwal.” ");
INSERT INTO mpx_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Sauga Abalam i na i vin Itipita, yaka Itipita gamagaliliyau Selai hi kite ana awa i waisi hot. ");
INSERT INTO mpx_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","I ola al kin wana totuwalali bwabwatal Selai hi kite, inoke hi na kin elana ge ana awa hi awa wawaisi-an ge hi tobalan. Yaka hi na hi ahe ge hi en pwatanik kin wana limiya, alona hi mina. ");
INSERT INTO mpx_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","He kin Abalam ana hehegan i ginol bubun, kaiwena Selai i ahe alona hi mina wana limiya, yaka wana sipi, goti, bulumwakau, donki, kamel ge wana totuwalali loloyowanil ona i bugul pek. ");
INSERT INTO mpx_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yaa Yehoba kasiyebwa nanakina hot etega i patuna kin alonau ge wana limi ana heniheni gegewel hi kasiyebwa, kaiwena kin Abalam lagona Selai i ahe tukan alona hi mina wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Inoke kin Abalam ana baaba i patuna ge i nok elana. Sauga i vin yaka i neli i ba, “Hauna pagan u ginol eliyau e? Hauna kaiwena nige no wasa u pepem te Selai iya lagom? ");
INSERT INTO mpx_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Hauna kaiwena u ba tage iya num, ge ya ahe i ola lagou? He lagom hiwe! U ahe ge ku egon.” ");
INSERT INTO mpx_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Inoke kin i baek awana toabinau elal, yaka Abalam alona lagona hi patuna owaowa-agil ginebi ge wali gogomwau gegewena Itipita hi eguluwan. ");
INSERT INTO mpx_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Inoke Abalam ge lagona wali gogomwau gegewena hi bugulan yaka Itipita hi eguluwai ge hi nawanawa hi na labi Negeb. He Lote al i nok aloliya. ");
INSERT INTO mpx_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abalam i gogomwau hot, wana bwasumu ona hi gewi nabi, i ola al wana silba ge wana gold. ");
INSERT INTO mpx_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Yaka i novevehe al kekeisi kekeisi i nohoholavi panuwa ge panuwa ona elal, ana siga i vin Betel ge Ai ali hawawala toto valila wana epanapana i tatala, ");
INSERT INTO mpx_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ge abapowon i ginoginola. Yaka i tapwalolowa al to Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","He Lote alona Abalam hi nononawanawa, iya al ge wana sipi, goti, bulumwakau ge wana totuwalali ona hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nige bosowailiya nihi mipamaisena, kaiwena wali bwasumu hi gewi nabi, ge wali abaanan nige i bwabwata. ");
INSERT INTO mpx_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Yaka ba apwaapwanawa i gan Abalam ge Lote wali bwasumu ali tomatahikan elal. He sauga o elana boda Kenani ge Pelisi iyoho ya hi minamina labi o elana. ");
INSERT INTO mpx_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Inoke Abalam i baek Lote elana i ba, “Nige nuwala ba apwaapwanawa ni gan owa ge nau elala, ge wala bwasumu ali tomatahikan elal, kaiwena owa ge nau tubula maisena hot. ");
INSERT INTO mpx_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","He ta nowali tomaha tomaha ta nonoek. Labi gegewena i mwapwela eliyam, labena etegana u hile ge nu na nu minaa. Ebo nu tukik labena aluwabwa, inoke nau na tagilik yavanaa. Ebo nu tagilik yavanaa, inoke nau na tukik aluwabwa.” ");
INSERT INTO mpx_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Yaka Lote matana i lipwapwati i kite wewel Yolidani abwabwina i waisi ge wewelina i bwata i na ana siga panuwa Sowal elana, i ola te Yehoba wana eyowa Ideni ge panuwa Itipita. (He ana awa i ola to, mulaa te abwe Yehoba panuwa Sodoma ge Gomola i apapanak-agil.) ");
INSERT INTO mpx_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yaka Yolidani abwabwina gegewena i hile iya totona kaiwena, inoke i hek ge i minaa to. He Abalam ge Lote wali miwali i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Inoke Abalam i na i minaa labi Kenani elana, yaa Lote i na i minaa Yolidani abwabwina panuwa ona gamwaliyaa ge wana epanapana i pamilil Sodoma gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","He Sodoma gamagaliliyau wali ginol i nak hot, ge hi gegi nabi Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Sauga Lote i egon enaa, yaka Yehoba i baek Abalam elana i ba, “Labi toto u taltalmilila matam u lipwapwati ni nok labena aluwabwa, yavanaa, balimana ge yalasa. ");
INSERT INTO mpx_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Labena bolo u kitel bibilena gegewena ya pewa hoti alomwau ge tubutubumwau eliyamiu sauga gegewena nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tubutubumwau nihi gewi nabi na pewa nihi ola bilibili papakovana. He nige bosowaina gamagal etega bilibili papakovana ni vasili haba, i ola al nige bosowaina tubutubumwau nihi vasilel haba. ");
INSERT INTO mpx_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","He u nok u na bilibili o ana yapu ge ana magaga u nawaan, kaiwena iyaka ya pewa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yaka Abalam wana epanapana i lekel ge i na i miminaa Mamele wana kawadi bwabwalel gegeliliyaa Hebiloni elana. Inoke abapowon i ginol ge i tapwalolo Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sauga o elana kin esopali, heliya Amlapel Babiloniya ana kin, Aliyoka Elasa ana kin, Kedolaoma Elam ana kin, ge Taidal Goim ana kin, ");
INSERT INTO mpx_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","hi nok hi na avaliyau ge kin nimala panuna hi lohaveyan, heliya Bila Sodoma ana kin, Bilsa Gomola ana kin, Sinab Adima ana kin, Semeba Seboim ana kin ge Bela (alana al te Sowal) ana kin. ");
INSERT INTO mpx_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","He kin bolo nimala panuna o wali ivan hi ahel hi teli pamaisena-agil panuwa Sidim abwabwina elana. (Toto sauga ya iyaka Hoga Alialigana i ehik.) ");
INSERT INTO mpx_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","He liwanina i ola hiwe. Valila baliman elulutega eluwa (12) Sodoma ana kin ge alonau hi minaa Kedolaoma wana logugui gabulanaa, yaa baliman tetin-ina (13-ina) elana yaka wana logugui hi towani nige hi giginol. ");
INSERT INTO mpx_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kedolaoma i huga, inoke baliman potin-ina (14-ina) elana alonau wana pan kin wali ivan hi ahel hi teli pamaisenal, yaka hi nem labi o elana. Wali nemnem eliyana avaliyau boda enuna al hi lohaveyan ga. Lepaimi hi pakokovel Astelot Kanaim elana, Susim hi pakokoveliya Hami elana, Emim hi pakokoveliya Kiliyataim abwabwina elana, ");
INSERT INTO mpx_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ge Holi hi pakokoveliya Seil oyana elalil ge hi takel ana siga Elpalan labi kekevana gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yaka hi awona pil ge hi sikal hi nem Keides (alana al te Enmispat), inoke Amaleki hi pakokovel ge wali labi gegewena hi ahe, i ola al Amoli bolo hi miminaa panuwa Haseson Tamal elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Yaka Kedolaoma alonau ge alonau hi nem al, inoke panuwa Sodoma, Gomola, Adima, Seboim ge Bela ali kin avaliyau wali tolohaveyan, ge hi tagil hi na Sidim abwabwina elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Inoke hi lovivina avaliyau ge Kedolaoma Elam ana kin, Taidal Goim ana kin, Amlapel Babiloniya ana kin, ge Aliyoka Elasa ana kin nihi lohaveyan. Yaka kin nimala panuna avaliyau ge kin esopali hi lohaveyan. ");
INSERT INTO mpx_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kedolaoma wana boda hi gasisi, inoke Sodoma ge Gomola wali kin avaliyau wali tolohaveyan hi lou. He Sidim abwabwina kolta ali gol hi gewi, inoke sauga hi lou, enuna hi soguek kolta ali gol gamwanaa ge enuna hi lou hi na hi ha oya elal. ");
INSERT INTO mpx_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Yaka kin bolo ali toto esopali hi na Sodoma ge Gomola wali gogomwau ge aliya gegewena hi bugulagil, inoke hi egonan. ");
INSERT INTO mpx_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","He Abalam talina natuna Lote al hi ahe, ginebi ge wana gogomwau gegewena, kaiwena saugenana o i miminaa Sodoma. ");
INSERT INTO mpx_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tau etega i lou ge i na bugul gegewena i wasaan Abalam gagama Hibilu eliyana. Saugenana o Abalam i miminaa Mamele gagama Amoli wana ebwakil bwabwalel gegeliliyaa. He Mamele alonau talinau Eskol ge Anel, heliya Abalam ana tolaba haveyan elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Sauga Abalam i hago talina natuna Lote iyaka hi yowan ge hi ahe egonan, yaka wana boda gamwanaa wana tolohaveyan ali gewi 318 i yogaagil ge hi tatauliulil Kedolaoma ge alonau eliyaa ana siga hi na hi vin panuwa Dani. ");
INSERT INTO mpx_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Inoke bulina Abalam wana tolohaveyan i walel ali boda ona elana, yaka hi tuk Kedolaoma ge alonau hi lekaleka-agil ge hi takel ana siga panuwa Hoba, Damasiko labena aluwabwa. ");
INSERT INTO mpx_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yaka Abalam bugubugul gegewena bolo Kedolaoma ge alonau hi bugulan i ahel pasikalil. I ola al talina natuna Lote ginebi wana gogomwau gegewena i ahe, alonau yowau ge gamagalau enuna al. ");
INSERT INTO mpx_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abalam Kedolaoma alonau wana pan kin eton i pakokovel i mowasi ge i sikasikal, yaka Sodoma ana kin i na Abalam i kite Save Abwabwina elana, alana etegana al te Kin Abwabwina. ");
INSERT INTO mpx_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Yaka Melkisedek, iya panuwa Salem ana kin ge iya Yabowaine Mihahaina Hot wana topowon, beleid ge oine i ahe yaka i tagil i na i pek Abalam elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yaka i ba muloluan i ba: “Yabowaine Mihahaina Hot, iya labulabum ge panayawi ali toginol, Abalam ni muloluagiwa. ");
INSERT INTO mpx_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ge ya ba mulolu Yabowaine Mihahaina Hot elana ge ya tobalan, kaiwena am topihigelgel i telel nimwam elana.” Inoke Abalam bugul gegewena bolo i oem haveyan elana i wali paelulutega (10) ge gamwaliyaa wali maisena i pek Melkisedek elana. ");
INSERT INTO mpx_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Yaka Sodoma ana kin i baek Abalam elana i ba, “Bugubugul gegewena u kukuhikan kaiwem, yaa no gamagalau ya te nu pem pasikalil eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Yaka wana baaba Abalam i lahe i ba, “Nimwau ya latahin ya papasila Yehoba, Yabowaine Mihahaina Hot elana, iya labulabum ge panayawi ali toginol, ");
INSERT INTO mpx_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nige wam bugul etegana na aahe. Bwagana bugul kekeisisi hot ololana teleid o but ana hihiu, gegewena na pewa pasikal, eba bwaliga nu ba, ‘Nau te Abalam ya pagogomwau.’ ");
INSERT INTO mpx_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nige bugul etegana na aahe, besena ya te aanan o hevalau hi an. Yaa nuwau o tolabe ali toto eton, Anel, Eskol ge Mamele, ali guyau nihi ahe.” ");
INSERT INTO mpx_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bugul bolo o enaa, Abalam ana pankite elana Yehoba anana i hago i ba, “Abalam, bahi nu lolovakun. Nau am ligovan na kausiwa nak elana ge nau am mulolu bwabwatana na pewa.” ");
INSERT INTO mpx_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yaka Abalam i ba, “O Babala Yehoba, hauna ana waisi ebo o mulolu bwabwatana nu pem, nau nige aeu pipihina i gagan, gagama Damasiko Eliyesa iya te bwaliga no gogomwau ni ahe. ");
INSERT INTO mpx_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nige natu etega u pepem, inoke bwaliga ebo na yaomal, no limi ana totuwalali etegana te no gogomwau ni ahe ge ni logugui-an.” ");
INSERT INTO mpx_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yaka Abalam Yehoba anana i hago al i ba, “Sauga ebo nu yaomal, tau toto ya nige wam gogomwau ni aahe. Yaa natum melutau etega ni masalem saliyam elana ge iya wam gogomwau ni ahe.” ");
INSERT INTO mpx_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Inoke Yehoba Abalam i en tagilan noleleya ge i baek elana i ba, “Matam i ha hawawala putum u kitel. Tab bosowaim nu vasilel? Nigeya! He tubutubumwau bwaliga ali gewi ni ola to.” ");
INSERT INTO mpx_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","He Abalam Yehoba i abulilek-an, inoke Yehoba Abalam i kite iya tosapu wana abulilek kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yaka Yehoba i baek Abalam elana i ba, “Nau Yehoba, ya ahewaa panuwa Ul labi Koldiya elana ge labi toto ya na pewa nu ahe wam labi.” ");
INSERT INTO mpx_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Yaka Abalam i ba, “O Babala Yehoba, ga na atena ola labi toto ya nu pem na ahe no labi?” ");
INSERT INTO mpx_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Inoke Yehoba i ba, “Bulumwakau meluyovana maisena, goti maisena ge sipi melutauina maisena wali baliman eton ona, i ola al bunibuni maisena ge lumlum maisena nu ahel nu pwatanim eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Inoke Abalam bwasumu bolo o i ahel ge i pwatanik Yehoba elana. Yaka i gopwetapweta-agil labi labui ona ge i telel vatal labui, yaa bunibuni ge lumlum nige i gogopwetapweta-agil. ");
INSERT INTO mpx_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","He bwasumu bwabwatal enuna hi youyou lau tage bwasumu tuwaliya nihi anil, yaa Abalam i tatakel. ");
INSERT INTO mpx_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Sabwelu lobelobekina elana Abalam i kenu mati ge gogou kubwa lolovakunina i yabom. ");
INSERT INTO mpx_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Inoke Yehoba i baek elana i ba, “Nu atena bubun te tubutubumwau bwaliga labi ya nihi ahe. He houwan nihi na nihi mibwabwali panuwa getoga elana, nihi paloloyowan-agil ge ali hehegan nihi apapanak-an baliman ana gewi 400. ");
INSERT INTO mpx_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Yaa bolo tubutubumwau hi paloloyowan-agil na lahel, ge sauga panuwa o nihi eguluwan, gogomwau ni bwata hot nihi ahe. ");
INSERT INTO mpx_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","(Yaa owa nu liki bubun yaka alom wam nuwa laumwal nu yaomal ge tuwam nihi teli.) ");
INSERT INTO mpx_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","He tubutubumwau bolo heyan esopalena heliya te abwe nihi sikalim labena ya elana. Kaiwena Amoli gamagaliliyau nigeya ga na tatakel nihi tatagil ana siga wali pagan nanakina ni bwata hot ge lahena nihi pwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Inoke sauga sabwelu i lobek ge i gogou, yaka hiwo ana ulun i kasukasu ge i tautau sauga o i masal, yaka i nosolaa gopwetapweta bwasumoliyau vatal labui ali hawawala. ");
INSERT INTO mpx_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","He i gan i ola to, inoke lan o elana Yehoba bateli i ginol Abalam elana i ba, “Labi toto ya ya pek tubutubumwau elal, i telipunaa Itipita ana Sinawel elana ge i nok i na wewel Yupeleitis elana: ");
INSERT INTO mpx_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni wali labi, Kenisi wali labi, Kadmoni wali labi, ");
INSERT INTO mpx_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiti wali labi, Pelisi wali labi, Lepaimi wali labi, ");
INSERT INTO mpx_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoli wali labi, Kenani wali labi, Gegasi wali labi ge Yebusi wali labi.” ");
INSERT INTO mpx_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abalam lagona Selai nige Abalam natuna etega i aab. Yaa wana totuwalali loloyowanina meluyovana etega i gan alana Hega, Itipita yovana, ");
INSERT INTO mpx_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","inoke Selai i baek Abalam elana i ba, “Yehoba i kausau nige ya aab. He nu na alom no totuwalali loloyowanina meluyovana nuku kenukenu, yaka ebo ni liyan ge ni ab, inoke wawaya o na awa natuni.” Yaka Abalam i talam. ");
INSERT INTO mpx_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Inoke Selai wana totuwalali loloyowanina Hega i en pwatanik Abalam elana i ola lagona etegana al|. He ginol ya i gana wali minamina Kenani elana ana baliman elulutega enaa. ");
INSERT INTO mpx_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abalam alona Hega hi kenukenu yaka i liyan. Sauga i atena i liyan, inoke Selai i kite lowan. ");
INSERT INTO mpx_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Yaka Selai i baek Abalam elana i ba, “Owa wam nak te. No totuwalali ya pewa eliyam, inoke sauga i liyan, yaka i kite lowagau. Yehoba ni hilela henala ge i sapu, owa o ebo nau.” ");
INSERT INTO mpx_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abalam Selai anana i lahe i ba, “He iya wam totuwalali loloyowanina i minaa wam logugui eliyana. Nu ginol elana ni ola hauna wam nuwatu.” Inoke Selai Hega ana hehegan i apapanak-an, yaka i lou luwai. ");
INSERT INTO mpx_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yaka Yehoba wana anelose Hega i pwawaa wewel bwanapitpit etegana gegelinaa labi kekevana elana, panuwa Sul ana kamwasa bebenaa. ");
INSERT INTO mpx_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yaka i ba, “Hega, Selai wana totuwalali loloyowanina, ga u noem, ge ga u nana?” Yaka anana i lahe i ba, “No nevenak Selai ya lou luwai.” ");
INSERT INTO mpx_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yaka Yehoba wana anelose i ba, “U sikal u na wam nevenak eliyana ge nu minaa wana logugui gabulanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yaka i ba vevehe al i ba, “Bwaliga tubutubumwau na pagewel nabiyan ge nige bosowaina gamagal etega ni vasilel habal.” ");
INSERT INTO mpx_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yaka i baek al elana i ba: “He iyaka u liyan tei, ge abwe nu ab natum melutau. Yaka alana nu tun Isimel, kaiwena wam kahin Yehoba iyaka i hago. ");
INSERT INTO mpx_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He totona ni logugui-an ni ola ewalili. Ni pihigelgel gamagalau gegewel elal, ge gamagalau gegewel nihi pihigelgel elana. Ge nige alonau ge tutunau nihi mimibubun.” ");
INSERT INTO mpx_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Inoke Hega Yehoba, iya i baaba elana, alana i tun “Yabowaine toto i kiteyau,” kaiwena i ba, “Age Yabowaine toto i kiteyau ya kite.” ");
INSERT INTO mpx_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Heiya te kaiwena gamagalau wewel o alana hi tun, “Wewel Yabowaine yawalina gaganina i kiteyau.” He wewel o iyoho panuwa bolo Keides ge Beled ali luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Inoke Hega Abalam natuna melutauina i ab, yaka Abalam wawaya alana i tun Isimel. ");
INSERT INTO mpx_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","He Abalam wana baliman 86 te Hega Isimel i ab. ");
INSERT INTO mpx_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abalam wana baliman 99 yaka Yehoba i masal elana ge i baek elana i ba, “Nau Yabowaine Togasisi Hot. U mipalalem eliyau ge bahi wam ginol nanakina ni gagan. ");
INSERT INTO mpx_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","He no bateli na ginol eliyam tubutubumwau na pagewel.” ");
INSERT INTO mpx_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yaka Abalam i kululu maninina i patupa bilibiliya, inoke Yabowaine i baek elana i ba, ");
INSERT INTO mpx_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“He nau no bateli toto ya ginol eliyam i ola hiwe: nasi nu tabwa boda nihi gewi tubuliya. ");
INSERT INTO mpx_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Alam nige al ni oola te Abalam, yaa alam na tun Abalahama, kaiwena iyaka ya ba nu tabwa boda nihi gewi tubuliya. ");
INSERT INTO mpx_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tubutubumwau na pagewel yaka nihi tabwa boda nihi gewi, ge kin ona nihi masalem owa eliyam. ");
INSERT INTO mpx_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Bateli toto ya ginol iya bateli mihomihotina owa eliyam ge tubutubumwau emwa heyan ge heyan elal. Ya bateli nau wam Yabowaine ge tubutubumwau wali Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Labi Kenani sauga ya eliyana u mibwabwali, bwalibwaligena na pewa ni mihot eliyam ge tubutubumwau eliyalil, yaka nau na ola wali Yabowaine.” ");
INSERT INTO mpx_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Yaka Yabowaine i ba vevehe al Abalahama elana i ba, “He owa no bateli ana logugui nu henapuan, owa ge tubutubumwau emwa heyan ge heyan. ");
INSERT INTO mpx_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","He no bateli toto ya ginol owa eliyam ge tubutubumwau eliyalil ana logugui i ola hiwe: wami bolau gegewel gotomwa yoho paganina nihi ahe. ");
INSERT INTO mpx_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Tuwamiu buhuna kunisina nuku gotomwa yoho ge ni tabwa bateli toto ya ginol eliyamiu ana etotohi. ");
INSERT INTO mpx_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Wami bolau heyan ge heyan, sauga nihi abil ge wali lan eit ni mowasi, yaka gotomwa yoho paganina nihi ahe. Gegewel nihi ahe: komiu natumiyau, wami totuwalali loloyowanil bolo hi abil wami limi ana heniheni gamwaliyaa, ge i ola al wami totuwalali loloyowanil bolo ku pwamolal hi neem labi getoga. ");
INSERT INTO mpx_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Gegewel gotomwa yoho paganina nihi ahe inoke no bateli mihomihotina ana etotohi ni minaa tuwamiwa. ");
INSERT INTO mpx_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ebo melutau etega nige tuwana buhuna kunisina nihi gogotomwa yoho, he ni mitagil wana boda gamagaliliyau gamwaliyaa, kaiwena no bateli ana logugui i leke.” ");
INSERT INTO mpx_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yaka Yabowaine i ba vevehe al Abalahama elana i ba, “He lagom Selai, nige al alana ni oola te Selai, yaa alana nu tun Sela. ");
INSERT INTO mpx_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Na muloluan yaka natum melutauina ni ab. Na muloluan ni tabwa boda nihi gewi tubuliya, ge panuwa ona wali kin nihi masalem iya eliyana.” ");
INSERT INTO mpx_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yaka Abalahama i kululu maninina i patupa bilibiliya. Yaa Yehoba wana baaba nige i memelteli-an, yaka i nival ge atena elana i ba, “No baliman iyaka elulu bwagabwaga (100), he ga na ola ge natu ni gan? Ge Sela iyaka wana baliman 90, he ga ni ola ge ni ab?” ");
INSERT INTO mpx_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yaka Abalahama i baek Yabowaine elana i ba, “Binimala Isimel te ni tabwa wam ba mulolu gamagalina, yaka toto u bateli eliyau nu ginola iya eliyana.” ");
INSERT INTO mpx_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Inoke Yabowaine i ba, “Nigeya! Lagom Sela natum melutauina ni ab yaka alana nu tun Aisake. No bateli na ginola iya eliyana, bateli mihomihotina tubutubunau enaa heyan ge heyan kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","He wam awanun Isimel kaiwena iyaka ya hago: tunahot na muloluan, yaka tubutubunau na pagewel. Bwaliga natunau melubolau ali gewi elulutega eluwa heliya nihi tabwa un ali tohouwa, ge tubutubunau nihi gewi na pek nihi tabwa boda gasigasisena etega. ");
INSERT INTO mpx_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yaa no bateli na ginola Aisake eliyana, iya baliman i nenem gamwanaa, ni ola te sauga e, Sela ni ab.” ");
INSERT INTO mpx_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","He Yabowaine wana baaba i pwamowasi, yaka i eguluwai. ");
INSERT INTO mpx_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Inoke lan o elana Abalahama i ginol i ola Yabowaine wana baaba ge bolau gegewel wana limi ana heniheni elana tuwaliya buhuna kunisina i gotomwa yoho: natuna Isimel, wana totuwalali loloyowanil bolo hi abil wana limi ana heniheni gamwaliyaa, ge wana totuwalali loloyowanil bolo i pwamolal hi neem labi getoga. ");
INSERT INTO mpx_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","He Abalahama wana baliman 99 te tuwana buhuna kunisina hi gotomwa yoho, ");
INSERT INTO mpx_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ge natuna Isimel wana baliman elulutega eton (13). ");
INSERT INTO mpx_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","He liwanina i ola to, inoke lan toto Yabowaine i baaba Abalahama elana, Abalahama alona natuna Isimel gotomwa yoho paganina hi ahe. ");
INSERT INTO mpx_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","I ola al, lan o elana bolau gegewel wana limi ana heniheni elana gotomwa yoho paganina hi ahe. ");
INSERT INTO mpx_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abalahama i miminaa Mamele wana abwakil bwabwalel gegeliliyaa, yaka lan etega alalati bwagatau Yehoba i masal al elana. He liwanina i ola hiwe. Abalahama i misiyo wana epanapana ana abauluulutuka, ");
INSERT INTO mpx_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","yaka matana i lihin, he sauga o bolau eton i kitel hi taltalmilil nige ali bwaga i yayapu. Inoke i lut i tapalelu i na elal, ge i kululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Inoke i baek elal i ba, “No tonowakau, nau wami totuwalali, ebo ku yaliyaya-agau, yaka bahi egon, yaa alowau komiu ga ta mina. ");
INSERT INTO mpx_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Na ba no totuwalali etega eliyana wewel kekeisi ni pwatanim, yaka aemiu nuku ul ge nuku veyaho abwakil ya pwapwaligumwina elana. ");
INSERT INTO mpx_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Iyaka ku nem nau wami totuwalali no abamina elana, inoke aanan kekeisi na pwatanim nuku an ge tuwamiu ni gasisi, yaka abwe nuku novevehe al.” Yaka anana hi lahe hi ba, “I waisi, nu ginol ni ola wam baaba.” ");
INSERT INTO mpx_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yaka etimwawa Abalahama i sikal i na i tuk wana epanapana gamwanaa ge i baek Sela elana i ba, “Etimwawa pwalawa matana waiwaisana nu wage bol dis bwabwatal eton ana luvi, yaka nu pitoli ge beleid nu umun.” ");
INSERT INTO mpx_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Inoke etimwawa Abalahama i na wana bulumwakau ali yawi elana ge natuna tatabwana bunumwina waiwaisana etega i hile. Yaka i pek wana totuwalali etega elana ge iya etimwawa i lovivina-an. ");
INSERT INTO mpx_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Iyaka aanan hi lovivina-an haba, inoke Abalahama aanan sis ge hul enuna alona bulumwakau bunumwina momolana i bugulan, i na i pwahin bolau eton maniniliyaa ge hi anan. Inoke Abalahama i talmilil gegeliliyaa abwakil ligumwina elana ge i matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Yaka abwe hi nel Abalahama elana hi ba, “Lagom Sela iya ga?” Analiya i lahe i ba, “Iya iyoho epanapana gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yaka avaliya etega i ba, “Baliman i nenem gamwanaa, ni ola te sauga e, na sikalim, yaka lagom Sela ni ab natuna melutau.” Yaa Sela iyoho i lalaegan epanapana ana abaululutuka Abalahama enaa. ");
INSERT INTO mpx_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","He Sela alona ge Abalahama iyaka hi liki nabi, ge Sela iyaka nige al i weweikena kasiyebwa. ");
INSERT INTO mpx_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Yaka i nival ge atena elana i ba, “Iyaka ya pweyata ge no babala iyaka i liki, he nige al bosowaiu yaliyaya toto ya na pwawa tage wawaya na ab.” ");
INSERT INTO mpx_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Inoke Yehoba i baek Abalahama elana i ba, “Hauna kaiwena Sela i nival ge i ba, ‘Iyaka ya liki nige bosowaiu na ab’? ");
INSERT INTO mpx_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nige bugul etega i pupulowan tage nau Yehoba nige bosowaiu na ginol. He baliman i nenem gamwanaa, ni ola te sauga e, na sikalim, yaka lagom Sela ni ab natuna melutau.” ");
INSERT INTO mpx_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sela i lovakun yaka i alaha i ba, “Nige ya ninival.” Anana Yehoba i lahe i ba, “Nigeya, he tunahot te u nival.” ");
INSERT INTO mpx_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Inoke bolau eton hi lut ge hi nawanawa hi na labi toto elana mataliya ni lau Sodoma nihi kite. He Abalahama i nok alonau hi notoyawa ge ni entelel. ");
INSERT INTO mpx_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yaka abwe Yehoba atena elana i ba, “Nak toto abwe na ginol panuwa Sodoma elana bahi na susume Abalahama elana. ");
INSERT INTO mpx_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kaiwena bwaliga tubutubunau nihi tabwa boda bwabwatana ge gasigasisena etega, ge iya eliyana gamagalau gegewel panayawiya na muloluagil. ");
INSERT INTO mpx_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Iya ya hile natunau ge tubutubunau ni pankitel nau Yehoba no kamwasa nihi toulil, yaka ginol waiwaisana ge sasapona nihi awaawaginol, inoke hauna ya bateli iya kaiwena na ginol.” ");
INSERT INTO mpx_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Inoke Yehoba i baek Abalahama elana i ba, “Panuwa Sodoma ge Gomola wasaliya i bwata te gegi paganina hi awaawaginol nabiyan. ");
INSERT INTO mpx_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Na na ga na lau na kitel ebo tunahot wali pagan nanakina ana bwata i ola toto ya hago, o ebo nigeya.” ");
INSERT INTO mpx_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Yaka bolau eluwa hi noegon ge hi noek kamwasa toto i na Sodoma. Yaa Yehoba alona ge Abalahama hi minaa to. ");
INSERT INTO mpx_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Inoke Abalahama i na Yehoba gegelinaa ge i nel i ba, “Nasi bolo tosapu avaliyau ge bolo wali pagan nanakina nu pwamowasel? ");
INSERT INTO mpx_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ga i ola ebo bolo tosapu ali gewi pipti (50) iyoho panuwa o elana, age nasi panuwa bwabwaligena nu apapanak-an? Age nige panuwa nu pwapwamwal bolo tosapu ali gewi pipti (50) kaiweliya? ");
INSERT INTO mpx_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bahiwa! Bahi bolo tosapu avaliyau ge bolo wali pagan nanakina nu pwapwamowasel. Ebo nu ola o, he tosapu ali hehegan iyaka i ola ya te bolo wali pagan nanakina ali hehegan. Bahiwa! Owa gamagalau gegewel panayawiya ali toyatala, ge sapu elana te nu payatalal.” ");
INSERT INTO mpx_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Anana Yehoba i lahe i ba, “Binimala ebo tosapu ali gewi pipti (50) na pwawal panuwa Sodoma gamwanaa, yaka heliya kaiweliya panuwa bwabwaligena na pwamwal.” ");
INSERT INTO mpx_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Inoke Abalahama i ba al i ba, “Babala, nau gamagal ya, ya ola bilibili ge papakova, iyaka ya baaba, inoke nu talamwagau ga na baaba al. ");
INSERT INTO mpx_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ga i ola ebo tosapu ali gewi poti paib (45) ya iyoho panuwa o gamwanaa? Age nasi panuwa bwabwaligena nu apapanak-an kaiwena nimala panuna hi kala?” Anana Yehoba i lahe i ba, “Ebo tosapu ali gewi poti paib (45) na pwawal, he nige panuwa na aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Inoke Abalahama i ba vevehe al i ba, “Ga i ola ebo ali gewi poti (40) ya nu pwawal?” Anana Yehoba i lahe i ba “Ebo ali gewi poti (40) iyoho, he nige panuwa na aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Inoke Abalahama i ba, “Babala, bahi nu huhugaagau, yaa nuwau na baaba al eliyam. Ga i ola ebo ali gewi teti (30) ya nu pwawal?” Yaka anana Yehoba i lahe i ba, “Ebo ali gewi teti (30) na pwawal, he nige panuwa na aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Inoke Abalahama i ba, “Babala, iyaka ya baaba, inoke nu talamwagau ga na baaba al. Ga i ola ebo ali gewi tuwenti (20) ya nu pwawal?” Anana i lahe i ba, “Ebo ali gewi tuwenti (20) na pwawal, he nige panuwa na aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Inoke Abalahama i ba, “Babala, bahi nu huhugaagau, yaa nuwau pamaisena al na baaba eliyam. Ga i ola ebo ali gewi elulutega (10) ya nu pwawal?” Yaka anana Yehoba i lahe i ba, “Ebo ali gewi elulutega (10) na pwawal, he nige panuwa na aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Sauga Yehoba alona ge Abalahama hi liwaliwan haba, inoke Yehoba i egon, ge Abalahama i sikal i na wana epanapana elana. ");
INSERT INTO mpx_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lan o kokoyavi elana aneloseyau labui hi na hi vin panuwa Sodoma, he Lote iyoho i misiyo panuwa ana gana ana abauluulutuka. Sauga aneloseyau i kitel inoke i lut i na eliyalil, ge i kululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Inoke i baek eliyalil i ba, “No tonowakau, nau wami totuwalali, ya awanun elamiu nuku nem no limiya ge aemiu nuku ul, yaka bulina nuku kenu. Bwaligumwa mweluluga kekeisi abwe nuku nawanawa al.” Yaka Lote anana hi lahe hi ba, “Nigeya, naha kenuwa te bakubakuwa e panuwa ana abamimigogowa.” ");
INSERT INTO mpx_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yaa Lote i ba balbalgig inoke hi nok avaliya ge hi na hi tuk wana limiya. Yaka i baek wana totuwalali elal pwalawa nige alona yis hi vivikuhu hi umun, inoke aanan hi lovivina-an ge hi anan. ");
INSERT INTO mpx_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","He nigeya ga hi kekenu, yaka bolau gegewel hot, hevalau ge tonowakau, hi neem panuwa Sodoma gamwana gegewena elal hi na limi hi mipainan. ");
INSERT INTO mpx_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Inoke hi yoga tuktuk Lote elana hi ba, “Bolau bolo hi nem eliyam bulin e heliya ga? U ahel nihi tagilem eliyama ge naha loneganega-agil.” ");
INSERT INTO mpx_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Inoke Lote i na i tagil elal ge nog i tagakaus enaa, ");
INSERT INTO mpx_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","yaka i baek elal i ba, “No heliyamwau, bahi pagan nanakina toto ya nuku giginol. ");
INSERT INTO mpx_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","He natuwau galokau labui hi gan nigeya ga hi lolobolau, na ahel nihi tagilim eliyamiu, inoke hauna nuwamiu, he nuku ginola eliyalil. Yaa bahi bugul etega nuku giginol bolau ya elal, kaiwena iyaka hi nem no limiya ge na matahikagil bubun.” ");
INSERT INTO mpx_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yaa Lote anana hi lahe hi ba, “U miegonik!” Yaka hi ba, “Tau ya iya bwabwali yaka tage ni logugui-agila!” Inoke hi baek al Lote eliyana hi ba, “Nak toto tage naha ginol bolau labui elal, nasi naha ginol panak hoti owa eliyam.” Inoke Lote hi bibin pasikal, yaka hi nok hi na tage nog hi tatagaleke. ");
INSERT INTO mpx_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yaa bolau labui limi gamwanaa nimaliya i tagil Lote hi momol tukan, yaka nog hi tagakaus. ");
INSERT INTO mpx_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Yaka bolau gegewel limi tolinaa mataliya hi tagapagogou inoke hi babalalu, yaa nige bosowailiya nog nihi pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Yaka bolau hi baek Lote elana hi ba, “Panuwa ya wali pagan nanakina wasana i bwata hot Yehoba i hago, inoke i patunama ha nem ge naha apapanak-an. Tab wam boda enuna al hi gan e, ebo natumwau bolau ge yowau, ebo natumwau yowau ali kawakawalolu, o ebo tutumwau enuna al panuwa ya elana? Ebo hi gan, nu na nu ahel ge alomwau nuku tagil, kaiwena panuwa ya ha aapapanak-an.” ");
INSERT INTO mpx_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yaka Lote i tagil i na i baek natunau yowau ali kawakawalolu elal i ba, “Etimwawa ku nem panuwa ya ta eguluwan, kaiwena Yehoba i aapapanak-an.” Yaa hi nuwatu tage i tatalawasi. ");
INSERT INTO mpx_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mweluluga kekeisi hot, aneloseyau Lote hi patotoe hi ba, “Etimwawa lagom ge natumwau galokau labui bolo sauga ya alomwau, u ahel, yaka panuwa ya ku lou luwai. Inoke sauga Yehoba ni apapanak-an, komiu nige nuku yayaomal.” ");
INSERT INTO mpx_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","He Lote iyoho i nuwatu pilpil, yaa Yehoba i atilomwan-an, inoke bolau labui Lote alonau lagona ge natuliyau galokau labui nimaliya hi ahe ge hi nul tagilagil panuwa tolinaa. ");
INSERT INTO mpx_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Iyaka hi tagil haba inoke bolau o alona etega i baek elal i ba, “Ku lou, eba nuku aliga! Bahi nuku tatagena sikalek emiwa ge bahi nuku veveyaho Yolidani abwabwina panuwana etega elana. Ku lou ku na oya elal yaka nige nak nuku pwapwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Yaa anana Lote i lahe i ba, “Tonowak, bahiwa! ");
INSERT INTO mpx_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Wam pagan i waisi eliyau, ge u muloluagau yawaliu u pwamwal. Yaa nige bosowaiu na lou noek to oya elal. Nasi nigeya ga na vivin inoke nak toto ya ni kukuhikagau ge na yaomal. ");
INSERT INTO mpx_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","He awan kekeisi etega huwo nige ana bwaga i yayapu. Na lou noek to. He awan o i kekeisisi age? Na noek to, inoke mwal na pwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yaka anelose i baek Lote elana i ba, “I waisi, ya talam nu nok to ni ola wam awanun. Inoke awan o nige na aapapanak-an. ");
INSERT INTO mpx_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","He etimwawa u lou u noek to, kaiwena nigeya ga bugul etega na giginol ana siga nu na nu vin.” (Lote awan o i awa kekeisisi-an inoke alana hi tun Sowal.) ");
INSERT INTO mpx_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Sabwelu iyaka i ha te Lote i vin awan Sowal elana. ");
INSERT INTO mpx_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Inoke sauga o Yehoba pat salpa tautauina i ligin lowanem hawawala i tala panuwa Sodoma ge Gomola elal. ");
INSERT INTO mpx_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yaka panuwa bolo o ge labi o abwabwina gamwana bwalibwaligena, ginebi ge gamagalau gegewel bolo hi miminaa o, ge bugul bolo hi siun bilibili pwatanaa al ge, Yehoba i apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Yaa Lote lagona i tagena sikalek enaa, inoke i tabwa solti papatina i talmilil i ola kokola. ");
INSERT INTO mpx_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","He lan o mweluluga ya, yaka Abalahama i lut i na i talmilil labi toto nolu alona ge Yehoba hi milimilila. ");
INSERT INTO mpx_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Inoke matana i lau panuwa Sodoma ge Gomola elal ge labi o abwabwina gegewena elana, ge i kite panuwa kasona babalona i haha i ola ginaha hi ton gol gamwanaa kasona. ");
INSERT INTO mpx_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","He liwanina i ola to. Inoke Yabowaine Yolidani abwabwina panuwana i apapanak-agil, yaa Abalahama wana awanun nige i nunuluwan, yaka Lote i palou ga mulaa abwe panuwa toto i eguluwan i ton olan. ");
INSERT INTO mpx_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lote i lovakun te ni minaa awan Sowal elana, inoke alonau natunau galokau labui hi egon hi na oya elal ge hi miminaa gol etega elana. ");
INSERT INTO mpx_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lan etega natuna galok toto bwabwatana i baek kekeisina elana i ba, “Tamala iyaka i liki, ge nige bolau hi gagan te labi ya elana tage avalau ta alolon ge natulau nihi gan, ni ola panayawi labena gegewena bolau ge yowau hi giginol. ");
INSERT INTO mpx_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Oine ta ahe tamala ta paim nabiyan, yaka ta na avala ta kenu ge iya eliyana natulau nihi gan, yaka bahi un ni yayaomal.” ");
INSERT INTO mpx_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Inoke bulin o oine hi ahe tamaliya hi paim nabiyan, yaka toto bwabwatana i na i tuk ge alona tamana hi kenu. He tamana nige i aatena te natuna i na i tuk alona hi kenu ge nige al i aatena te i lut ge i tagil. ");
INSERT INTO mpx_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Lan i gan inoke toto bwabwatana i baek talina kekeisina elana i ba, “Bulin alou ge tamala ha kenu, he nasi bulina ta paim nabiyan al, yaka owa nu na nu tuk ge alom nuku kenu. Inoke iya eliyana natulau nihi gan ge bahi un ni yayaomal.” ");
INSERT INTO mpx_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Yaka bulin o tamaliya hi paim nabiyan al, inoke toto kekeisina i na i tuk alona tamana hi kenu. He tamana nige i aatena te natuna i na i tuk alona hi kenu, ge nige al i aatena te i lut ge i tagil. ");
INSERT INTO mpx_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Inoke Lote natunau galokau labui hi liyan, wali liyan i neem tamaliya elana. ");
INSERT INTO mpx_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Toto bwabwatana i ab natuna melutau, inoke alana i tun Mowabi. He iya boda Mowabi bolo sauga ya tubutubuliya. ");
INSERT INTO mpx_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yaka toto kekeisina al i ab natuna melutau, inoke alana i tun Benami. He iya boda Amoni bolo sauga ya tubutubuliya. ");
INSERT INTO mpx_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abalahama Mamele wana abwakil bwabwalel i eguluwan yaka i tagilik i na labi Negeb, ge i minaa ga panuwa Gelal, Keides ge Sul ali hawawala. ");
INSERT INTO mpx_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yaka gamagalau o wali wasa i pek lagona Sela bana i ba, “Nu te.” Inoke Abimeleki, panuwa Gelal ana kin, i hago ge i ba wana totuwalali elal hi na Sela hi en pwatanik elana ge i ahe tukan wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Yaa bulin etega kenonou elana Yabowaine i masala Abimeleki elana ge i ba, “Owa nasi nu aliga, kaiwena yova toto u ahe iya toalolon.” ");
INSERT INTO mpx_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","He Abimeleki nigeya ga alona Sela hi kekenu, inoke anana i lahe i ba, “Babala, nau nige gegi ya giginol! Age nasi alowau ge no gamagalau nu lopaaligama? ");
INSERT INTO mpx_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abalahama no wasa i pem i ba, ‘Nu te Sela,’ yaka Sela al i ba, ‘Nu te Abalahama.’ He ya atena bubun, toto ya ginol nige tage nuwatu nanakina elana ge ya ginol.” ");
INSERT INTO mpx_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Inoke kenonou o elana Yabowaine i baek al Abimeleki elana i ba “Ee, ya atena nige nuwatu nanakina elana ge u giginol. Inoke nau te ya kaisewa ge nige alom yova ku kekenu ge tage nu gegi matawa. ");
INSERT INTO mpx_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","He yova ya nu pek pasikal lagona elana. Tau o iya palopita, yaka ni awanun kaiwem ge nige nu aaliga. Yaa ebo nige nu pepek pasikal, he nasi nu aliga, alomwau ge wam gamagalau gegewel.” ");
INSERT INTO mpx_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Lan i gan mweluluga kekeisi, Abimeleki wana totuwalali bwabwatal gegewel i yogaagil. Inoke bugul gegewena toto i masal ana kenonou elana i wasaan elal, yaka hi lovakun nabi. ");
INSERT INTO mpx_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Inoke Abimeleki Abalahama i yogaan ge i baek elana i ba, “Hauna kaba pagan u ginol eliyama e? Nau nige bugul etega ya giginol panak eliyam, yaa wam ginol kaiwena alowau no gamagalau ha minaa lahi bwabwatana ya elana. Binimala bahi nu giginol ola!” ");
INSERT INTO mpx_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Yaka Abimeleki i nel al i ba, “Hauna wam puna ge u ginol ola o?” ");
INSERT INTO mpx_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Inoke anana Abalahama i lahe i ba, “No nuwatu tage panuwa ya gamagaliliyau nige etega Yabowaine i lolovakun-an, yaka lagou kaiwena nasi nihi tagapaaligau ge nihi oe. ");
INSERT INTO mpx_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","He tunahot nu te Sela, alou tamama maisena, yaa hinameyau tomaha ona te ya alolonan e. ");
INSERT INTO mpx_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yaka sauga Yabowaine i ba nam wana limi ana heniheni ya eguluwagil ge ya nononawanawa, yaka ya baek elana ya ba: Ebo u nunuwana-agau, yaka hauna labi elana ta nonoek, gamagalau wali wasa nu pek nu babaa, ‘Tau ya iya nu.’” ");
INSERT INTO mpx_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Yaka Abimeleki sipi, bulumwakau ge totuwalali loloyowanil bolau ge yowau i ahel ge i pek Abalahama elana. Inoke lagona Sela i pek pasikal elana. ");
INSERT INTO mpx_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Inoke i baek Abalahama elana i ba, “Matam u lipwapwati no abalogugui ana bwata nu kite, yaka labi etega nu hile ge nu na nu minaa.” ");
INSERT INTO mpx_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Inoke i baek Sela elana i ba, “He mani silba tausan maisena (1,000) ya pepek num elana am puluwawi ana abwabubun kaiwena, ge gamagalau gegewel nihi atena tunahot te owa nige gegi etega u giginol.” ");
INSERT INTO mpx_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","He valila, sauga toto Abimeleki Abalahama lagona Sela i ahe tukan wana limiya, inoke baena Yehoba Abimeleki wana limi ana heniheni yowau gegewel lalgamaniliya i lokausan nige bosowailiya nihi liyan. Inoke Abalahama i awanun Yabowaine elana, yaka Yabowaine Abimeleki alonau lagona ge wana totuwalali loloyowanil yowau, i pwamolol bosowailiya al nihi liyan ge nihi ab. ");
INSERT INTO mpx_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yehoba Sela i muloluan i ola valila wana baaba, ge i ginol eliyana i ola wana bateli. ");
INSERT INTO mpx_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Inoke i liyan, yaka Abalahama wana liki ana sauga elana natuna melutauina Sela i ab. He sauga toto Yabowaine Abalahama i bateli, ana sauga hot elana te i masal. ");
INSERT INTO mpx_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Yaka wawaya toto Sela i ab, Abalahama alana i tun Aisake. ");
INSERT INTO mpx_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sauga hi ab ge wana lan eit i pwawa, yaka Abalahama natuna Aisake tuwana buhuna kunisina i gotomwa yoho, i ola Yabowaine wana baaba elana. ");
INSERT INTO mpx_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","He Abalahama wana baliman ana bwata elulu bwagabwaga (100) elana te natuna Aisake Sela i ab. ");
INSERT INTO mpx_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Inoke Sela i ba, “Yabowaine i panivalau ya yaliyaya, ge gamagalau gegewel bolo no ab wasana nihi hago alowau naha nival toyawa.” ");
INSERT INTO mpx_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Inoke i ba vevehe al i ba, “He valila nige gamagal etega ni nuwatu tage wawaya etega na paalahul. Yaa age Abalahama wana liki ana sauga elana te natuna etega iyaka ya ab e.” ");
INSERT INTO mpx_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","He Aisake i bwaya yaka hul hi paalayoho, inoke lan o Abalahama aanan bwabwatana i ginol. ");
INSERT INTO mpx_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Yaa Sela i kite Abalahama natuna toto Hega Itipita yovana i ab, Aisake i sisinali-an. ");
INSERT INTO mpx_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Inoke i baek Abalahama elana i ba, “Yova totuwalali loloyowanina ei alona ge natuna nu patuna owaowa-agil. Kaiwena yova totuwalali loloyowanina natuna nige tamana wana gogomwau ni aahe, natu Aisake ya te ni ahe.” ");
INSERT INTO mpx_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Baaba o kaiwena Abalahama atena i lomwan nabi, kaiwena Isimel al ge iya natuna. ");
INSERT INTO mpx_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yaa Yabowaine i baek Abalahama elana i ba, “Bahi atem ni lolomwan nabi wawaya alona ge hinana wam totuwalali loloyowanina kaiweliya. Nu ginol ni ola Sela wana baaba eliyam, kaiwena tubutubunim bolo ya bateli kaiwem nihi masalem Aisake elana. ");
INSERT INTO mpx_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Yaa yova totuwalali loloyowanina natuna tubutubunau nihi gewi na pek, ge heliya al nihi tabwa boda etega, kaiwena iya al ge natum.” ");
INSERT INTO mpx_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Lan i gan mweluluga kekeisi, Abalahama aanan enuna, ginebi ge wewel patuna etega toto goti kunisina hi ginoliya i ahel ge i na i telel Hega vevelanaa. Yaka alona natuna i patunal hi egon, ge hi nonobwagabwaga Biyaseba ana labi kekevana elana. ");
INSERT INTO mpx_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Sauga wewel i mowasi patuna gamwanaa, yaka Hega geman i teliya abwakil kekeisi etega pwapwaligumwina elana. ");
INSERT INTO mpx_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Inoke i na i misiyo laha ana bwaga i ola 100 mita, kaiwena i nuwatu i ba, “Bahi natu na kikite ni aaliga.” He Hega iyoho i misiyo abanaa ge i kahikahin. ");
INSERT INTO mpx_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yaka Yabowaine i hago geman i kahikahin, inoke Yabowaine wana anelose i yoga Hega elana anana i loem labulabumwa i ba, “Hega, ga i ola? Hauna gun i nak? Bahi nu lolovakun, Yabowaine geman wana kahin iyaka i hagoem labi toto u teliya. ");
INSERT INTO mpx_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","U lut u na geman u pamilil ge nu nolabin, kaiwena bwaliga tubutubunau nihi gewi na pek, ge heliya nihi tabwa boda gasigasisena etega.” ");
INSERT INTO mpx_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Yaka Yabowaine wewel kenken etega i pankite, inoke Hega i na patuna i pakalaopop, ge i pek geman i im. ");
INSERT INTO mpx_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","He geman i bwatabwata ge Yabowaine i miminaa elana. I minaa uleya labi kekevana elana ge i tabwa egipoyo ana toalialihin waiwaisana. ");
INSERT INTO mpx_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Sauga i miminaa o labi kekevana alana Palan, yaka hinana yova etega i hilek Itipita ge i alolonan. ");
INSERT INTO mpx_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sauga etega kin Abimeleki alona ge wana tolohaveyan wali tohouwa Pikol, hi na Abalahama elana, ge i baek elana i ba, “Ya atena Yabowaine i minaa eliyam, inoke bugul gegewena u ginolil hi waisi. ");
INSERT INTO mpx_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","He Yabowaine matanaa nu bateli te alowau natuwau ge tubutubuwau nige nu kakakawema. Nau pagan waiwaisana ya ginol eliyam, inoke nu bateli pagan waiwaisana al nu ginol eliyau, ge panuwa u mibwabwaliya e gamagaliliyau elal.” ");
INSERT INTO mpx_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Inoke Abalahama i ba, “Ya bateli ni ola to.” ");
INSERT INTO mpx_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Yaka abwe Abalahama i baaba Abimeleki elana wewel kenken etega kaiwena, toto Abimeleki wana totuwalali hi oem Abalahama wana totuwalali eliyalil. ");
INSERT INTO mpx_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Yaa Abimeleki i baek elana i ba, “Nige ya aatena te henala ge i ginol ola o. Valila nige no wasa u pepem, he abwe ya hago te lan e.” ");
INSERT INTO mpx_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Inoke Abalahama sipi ge bulumwakau enuna i ahel ge i pek Abimeleki elana, yaka ali toto labui wali bateli hi ginol. ");
INSERT INTO mpx_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","He Abalahama sipi natunau meluyowau seben al i ahel ali yawi gamwanaa ge i teli getogaagil. ");
INSERT INTO mpx_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Inoke Abimeleki i nel Abalahama elana i ba, “Hauna kaiwena ge sipi natunau meluyowau bolo seben u teli getogaagil ei?” ");
INSERT INTO mpx_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Inoke anana Abalahama i lahe i ba, “Sipi natunau meluyowau bolo seben e hi neem eliyau. Nu ahel, yaka eliyana nu patunahot te wewel kenken ya nau ya ken.” Yaka Abimeleki i ginol i ola Abalahama wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Inoke gamagalau panuwa o alana hi tun Biyaseba, kaiwena eliyana tonowakau labui wali bateli hi ginola. ");
INSERT INTO mpx_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Sauga tonowakau labui wali bateli hi ginol i mowasi, inoke Abimeleki alona ge wana tolohaveyan wali tohouwa Pikol hi sikal wali panuwaa labi Pilistiya. ");
INSERT INTO mpx_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Yaka Abalahama abwakil tamalik etega i luwan panuwa Biyaseba elana, ge i tapwalolo Yehoba Yabowaine Mihomihotina elana. ");
INSERT INTO mpx_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","He Abalahama i miminaa labi Pilistiya sauga i yapu. ");
INSERT INTO mpx_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sauga etegana al abwe Yabowaine Abalahama wana abulilek i labose. I baek elana i ba, “Abalahama!” Yaka Abalahama i talam i ba, “O, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Inoke Yabowaine i baek elana i ba, “Natum maisena hot Aisake, iya u nunuwana-an nabiyan, nu ahe alom nuku na labi Molaiya. Yaka abwe oya etega na baunaniwa ge eliyana nu powonan pwabwalige eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Lan i gan mweluluga kekeisi Abalahama i lut ge wana donki i lovivina-an. Powon ana kewadi enuna i gela, yaka wana totuwalali labui ge natuna Aisake i ahel alonau, ge hi nawanawa nihi na labi toto Yabowaine i baunanik elana. ");
INSERT INTO mpx_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Lan etonina elana, Abalahama matana i nok labi o i kite payapu. ");
INSERT INTO mpx_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yaka i baek wana totuwalali elal i ba, “Ku minaa te, alomiu ge donki. Nau alou geman naha nok ga huwo ge naha tapwalolo Yabowaine elana, yaka abwe naha sikalim eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Inoke Abalahama powon ana kewadi i ahe ge natuna Aisake i pakalivai, yaka iya hiwo ge kaini i noahe. Sauga ali toto labui hi nawanawa, ");
INSERT INTO mpx_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","yaka Aisake i baek tamana Abalahama elana i ba, “Nam!” Yaka Abalahama i talam i ba, “O, natu.” Inoke Aisake i ba, “Hiwo ge powon ana kewadi iyahe hi gan, yaa sipi natuna powon kaiwena iya ga?” ");
INSERT INTO mpx_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Anana Abalahama i lahe i ba, “Natu, Yabowaine totona abwe sipi natuna ni pem powon kaiwena.” Inoke ali toto labui hi nawanawa al. ");
INSERT INTO mpx_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Sauga hi vin labi toto Yabowaine i baunanik elana, inoke Abalahama pat i pahe abapowon, yaka powon ana kewadi i pahel pwatanaa. He natuna Aisake aena ge nimana i yowanil ge i pakenuwa kewadi pwataliyaa abapowon elana. ");
INSERT INTO mpx_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Inoke nimana i nok kaini i ahe tage natuna i gogopaaliga. ");
INSERT INTO mpx_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yaka Yehoba wana anelose i yoga loem labulabumwa i ba, “Abalahama! Abalahama!” Yaka Abalahama i talam i ba, “O, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Inoke i ba, “Bahi geman nu gogopaaliga. Bahi bugul etega nu giginol panak eliyana. Iyaka ya atena nau Yabowaine o lovakun i gan eliyam, kaiwena natum maisena hot nige u kakaise eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Inoke Abalahama matana i lihin, yaka sipi melutauina etega i kite ana hon i panoil kewadi kekeisi etega lalana elana. Inoke i nok i na i ahe ge i powonan pwabwalige Yabowaine elana natuna lahena. ");
INSERT INTO mpx_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Yaka Abalahama panuwa o alana i tun “Yehoba Abwe Ni Pem.” Ge i nem ana siga sauga ya, gamagalau wali baaba etega hi babaa ola hiwe, “Yehoba wana oya elana abwe ni pem.” ");
INSERT INTO mpx_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yaka Yehoba wana anelose i yoga palabuina Abalahama elana anana i loem labulabumwa ");
INSERT INTO mpx_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","i ba, “Yehoba i ba: Kaiwena u ginol i ola no baaba ge natum maisena hot nige u kakaise eliyau, inoke totou alau ya papasila-an te ");
INSERT INTO mpx_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tunahot na muloluagiwa, ge tubutubunim nihi gewi na pewa, ali gewi ni ola putum hawawala ge ni ola gilesa talbwasiya. Tubutubumwau ali topihigelgel nihi pakokovel yaka wali panuwa ona nihi ahe, ");
INSERT INTO mpx_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ge tubutubunim eliyana gamagalau gegewel panayawiya na muloluagil. Na ginol ola o, kaiwena no baaba u henapuan.” ");
INSERT INTO mpx_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Inoke Abalahama alona ge natuna hi sikal hi na wana totuwalali elal, ge aloliyau hi nawa sikal panuwa Biyaseba. Yaka Abalahama i miminaa to. ");
INSERT INTO mpx_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sauga etegana al abwe Abalahama wana wasa hi pek hi ba, “Milika i abab, he talim Naho iyaka natunau bolau hi gan. ");
INSERT INTO mpx_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Toto gamaun alana Us, loena alana Bus, ge etoniliya alana Kemuwel (iya Alam tamana), ");
INSERT INTO mpx_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","yaka abwe Kesed, Haso, Pildas, Didlap ge Betuwel.” ");
INSERT INTO mpx_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuwel iya Lebeka tamana. He Milika bolau bolo ya ali toto eit i abil Abalahama talina Naho natunau. ");
INSERT INTO mpx_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naho natunau bolau esopali al hi gan, lagona etegana al alana Leuma i abil. Alaliya i ola hiwe, Teba, Gaham, Tahas ge Maka. ");
INSERT INTO mpx_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sela wana baliman 127 i minamina-an. ");
INSERT INTO mpx_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Yaka abwe i aligaa awan Kiliyat-Aba elana, (he panuwa o alana al te Hebiloni) labi Kenani gamwanaa. Abalahama nuwana i nak nabi ge i na i kahin lagona kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Inoke Abalahama i lut lagona tuwana i eguluwan ge i nok i na alonau Hiti gamagaliliyau hi liwaliwan, yaka i ba, ");
INSERT INTO mpx_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nau bwabwali ge ya mibwabwali ya gamwamiwa. Labi etegana nuku palian eliyau na pwamola ge lagou tuwana na teliya.” ");
INSERT INTO mpx_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Yaka Hiti Abalahama anana hi lahe hi ba, ");
INSERT INTO mpx_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tonowak, wama nuwatu naha baunan ga nu hago. Owa towasawasa etegana gamwameya. Wama salai waiwaisana etegana nu hile inoke eliyana lagom tuwana nu teliya. Nige etegana wana salai ni kakaise lagom tuwana ana teliteli kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yaka Abalahama i lut ge i kululu Hiti gamagaliliyau mataliyaa, ");
INSERT INTO mpx_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","inoke i ba, “Ebo ku yaliyaya lagou tuwana na teliya e, inoke no nuwatu ga na pamasal eliyamiu. Alomiu Epiloni, Sohal natuna, nuku liwan kaiweu, ");
INSERT INTO mpx_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","inoke pat golina toto Makpela elana, iyoho wana bilibili buhunaa, ni palian eliyau. Nuku awanun eliyana te gol o ni palian eliyau molana hot elana ge na pwamola ni tabwa no salai gamwamiwa.” ");
INSERT INTO mpx_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","He Epiloni iyoho to i misiyo alonau gamwaliyaa. Yaka Abalahama anana i lahe, ge wana pan Hiti bolo hi noanik abamigogowa panuwa ana gana ana abauluulutuk elana gegewel hi hago. ");
INSERT INTO mpx_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","I ba, “Tonowak, nigeya. No nuwatu na baunan ga nu hago. No gamagalau mataliyaa bilibili o na pewa ge gol toto i minaa gamwanaa al na pewa eliyam lagom tuwana nu teliya.” ");
INSERT INTO mpx_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yaka Abalahama i kululu al gamagalau mataliyaa, ");
INSERT INTO mpx_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ge i baek Epiloni eliyana gamagalau hi hago i ba, “Ebo u yaliyaya, inoke no nuwatu ga na pamasal. He bilibili o na pwamola, molana nu ahe, yaka lagou tuwana na teliya to.” ");
INSERT INTO mpx_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Abalahama anana Epiloni i lahe i ba, ");
INSERT INTO mpx_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tonowak, no nuwatu na baunan ga nu hago. He bilibili o molana ana bwata mani silba po handeled (400), yaa bahi toto ya ni tatabwa eteli kaus owa ge nau ala hawawala. U na ya lagom tuwana u teliya to.” ");
INSERT INTO mpx_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abalahama mola toto Epiloni i baunan Hiti tanaliyaa i awa wawaisi-an, yaka mani silba po handeled ana pulowan i sikeli ge i pek Epiloni elana. He silba o ana pulowan i sikeli luvi elana toto saugena o topalipali hi patuwalali. ");
INSERT INTO mpx_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Inoke Epiloni wana bilibili toto Makpela elana panuwa Mamele labenaa, hi pek Abalahama elana i tabwa wana abalogugui, ginebi gol toto i minaa gamwanaa ge ebwakilina bolo hi minaa gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hi pek elana Hiti gegewel mataliyaa, bolo hi noanik abamigogowa panuwa ana gana ana abauluulutuk elana. ");
INSERT INTO mpx_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Sauga Abalahama bilibili i pwamola haba, yaka lagona Sela tuwana i teliya gol toto Makpela elana, panuwa Mamele labenaa labi Kenani elana. He Mamele alana al te Hebiloni. ");
INSERT INTO mpx_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","He liwanina i ola to, inoke labi o ge gol toto i minaa gamwanaa, Hiti hi talamwan Abalahama eliyana wana abalogugui i tabwa wana salai. ");
INSERT INTO mpx_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","He Abalahama iyaka i liki nabi ge Yehoba i muloluan bugul gegewel elal. ");
INSERT INTO mpx_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Inoke Abalahama i baek wana totuwalali wali tohouwa toto wana bugul gegewena ana tomatahikan elana i ba, “Nimwam u teliek nagiliu gabulanaa ");
INSERT INTO mpx_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ge nu papasila Yehoba alanaa, iya labulabum ge panayawi ali Yabowaine. Nau ya miminaa Kenani gamwaliyaa ee, yaa nu papasila te bahi natu lagona nu aaheya Kenani yowauiliyau gamwaliyaa, ");
INSERT INTO mpx_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","yaa nu nok nu na no panuwaa ge tutuwau eliyalil natu Aisake lagona nu aheya to.” ");
INSERT INTO mpx_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yaka totuwalali i nel elana i ba, “Yaa ga i ola ebo yova ni towa ge nige ni totoulilau naha nenem panuwa ya elana? Tab bosowaina natum na ahe ni sikal panuwa toto u nonoem?” ");
INSERT INTO mpx_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abalahama i ba, “Bahiwa! Bahi natu nu aahe ni sisikal panuwa o elana. ");
INSERT INTO mpx_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yehoba, iya labulabum ana Yabowaine, i ahe tagilagau nam wana boda elal ge tutuwau wali panuwaa i ba ya nem, yaka totona alana i papasila-an ge i ba, ‘Labi toto ya na pek tubutubumwau eliyalil.’ Inoke wana anelose ni patuna ni houwa, yaka sauga nu vin, yova etega nu aheya to natu lagona. ");
INSERT INTO mpx_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Yaa ebo yova ni towa ge nige ni totouliliwa alom nuku nenem, he iyaka ya sokaliwa ge papasila toto ya ba nu ginol e nu mowasi eliyana. Yaa bugul maisena, bahi natu nu aahe ni sisikal panuwa o elana.” ");
INSERT INTO mpx_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Inoke totuwalali nimana i teliya wana tonowak nagilina gabulanaa, ge i papasila nuwatu o kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Yaka totuwalali wana tonowak wana kamel elulutega (10), ginebi ge wana bugul bolo waiwaisal tomaha ge tomaha i ahel. Inoke i egon i na Mesopoteimiya labena aluwabwa, yaka i na panuwa toto Abalahama talina Naho i miminaa. ");
INSERT INTO mpx_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Sauga i vin, yaka kamel i paveyahol ge hi lomisiyo bilibiliya panuwa tolinaa wewel kenken gegelinaa. He iyaka i kokoyavi to, ge yowau wali sauga nok wewel wagi kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yaka i awanun i ba, “O Yehoba, no tonowak Abalahama wana Yabowaine, no tonowak u atilomwan-an, yaka nu labeyau ge lan ya na nomwaun. ");
INSERT INTO mpx_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","He nau hiwe wewel kenken gegelinaa ya taltalmilil e, ge panuwa ya yowauiliyau hi nenem wewel hi wawagi. ");
INSERT INTO mpx_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ebo na baek yova etegana eliyana na ba, ‘Tab bosowaina wam ulubwal nu telipalo wewel na im?’ ge ebo ni ba, ‘Ee, u im, inoke wam kamel al na paimwil,’ he iya te u hile wam totuwalali Aisake kaiwena. Ebo ni gan ni ola o, inoke na atena te no tonowak iyaka u atilomwan-an.” ");
INSERT INTO mpx_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","He mulaa abwe awanun i pwamowasi, Lebeka iyaka i novin wewel ana ulubwal i kalivai vevelanaa. Lebeka iya Betuweli natuna, he Betuweli iya Abalahama talina Naho alona ge lagona Milika natuliya. ");
INSERT INTO mpx_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Iya yova ana awa waiwaisana hot, ge iya nigeya ga alona tau etega hi kekenu. I na i lau wewel kenken elana wana ulubwal i pakalaopop ge i hesikal. ");
INSERT INTO mpx_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yaka totuwalali etimwawa i nok i na Lebeka eliyana ge i ba, “Tab bosowaina wam ulubwal wewelina kekeisi ga nu pem na im?” ");
INSERT INTO mpx_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Anana i lahe i ba, “Ibwe tonowak, na pewa nu im.” Yaka etimwawa wana ulubwal i nanapalo ge i pihikan, yaka totuwalali i paim. ");
INSERT INTO mpx_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sauga i paim haba, yaka i ba, “Na nok wewel na wagi nem wam kamel al na paimwil, ana siga ali luvi nihi pwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Inoke etimwawa wana ulubwal enona i ligin bwasumu mwaheliyaa, yaka i tapalelu sikal i na wewel kenken elana, ge wewel i wagi nok ana siga kamel gegewel ali luvi hi pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","He tau i mikekei ge i gayawaan, nuwana ni atena te ebo wana nawanawa puna Yehoba iyaka i paolaolaek o ebo nigeya. ");
INSERT INTO mpx_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sauga kamel hi im haba, yaka tau buhun aana molana bwabwatana gold hi ginoliya i ahe ge i teli yova buhunaa, i ola al tovaha bwabwatal gold hi ginoliya i ahel ge i pahel nimana eluwa elal. ");
INSERT INTO mpx_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Yaka i nel i ba, “Tab bosowaina no wasa ga nu pem tamwam henala? Ge tab aban i gan wana limiya ge i bosowaina alowau ge alowau naha kenuwa?” ");
INSERT INTO mpx_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Anana i lahe i ba, “Nau Betuweli natuna, iya Naho ge Milika natuliya.” ");
INSERT INTO mpx_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yaka i ba vevehe al i ba, “Kamel aliya i gewi ge wali abamina iyoho eliyama, i ola al aban i gan wama limiya i bosowaina nuku kenuwa.” ");
INSERT INTO mpx_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Yaka tau i kululu maninina i pahanalowanek bilibiliya ge i tapwalolo Yehoba elana ");
INSERT INTO mpx_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","i ba, “Yehoba ya tobalagiwa, owa no tonowak Abalahama wana Yabowaine, kaiwena wam atilomwan i gangan ya no tonowak eliyana, ge u nul pasapuau ya nem ya vin tutunau elal.” ");
INSERT INTO mpx_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Inoke yova i patalelu i na hinana wana limi ana heniheni wali wasa i pek bugul bolo hi gan kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","He Lebeka nuna i gan alana Leiban. Buhun aana toto nuna buhunaa alona tovaha bolo nimanaa i kitel, ge nuna wana baaba i hago tau ga i ba ola. Yaka etimwawa i patalelu tagil i na tau i kite i taltalmilil wana kamel elal wewel kenken gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yaka i baek eliyana i ba, “Owa Yehoba i muloluagiwa, u nem ta na no limiya. Hauna kaiwena u taltalmilil panuwa tolinaa e? Abamiu iyaka ya lovivina-an haba no limiya, ge i ola al wam kamel abaliya.” ");
INSERT INTO mpx_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Inoke Abalahama wana totuwalali i na limiya. Kamel ali usan hi palo, yaka hi ahel hi na wali abaminaa, ge aaliya hi pek. I ola al wewel hi wage hi pek Abalahama wana totuwalali ge alonau aeliya hi ul. ");
INSERT INTO mpx_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yaka abwe aanan hi lovivina-an ge hi teli maniniliyaa, yaa totuwalali i ba, “Nige ga na aanan, ana siga nuwatu toto kaiwena ya nem na baunan.” Yaka Leiban i ba, “He u ba ta hago.” ");
INSERT INTO mpx_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yaka i ba, “Nau Abalahama wana totuwalali. ");
INSERT INTO mpx_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yehoba no tonowak i muloluan nabiyan ge i gogomwau hot. He sipi, goti ge bulumwakau hi gewi, silba ge gold i bwata, totuwalali bolau ge yowau, ge i ola al kamel ge donki hi gewi i pek. ");
INSERT INTO mpx_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","No tonowak lagona Sela i liki ga yaka abwe Abalahama natuna melutauina i ab. He wana bugul gegewena iyaka i pek i logugui-an. ");
INSERT INTO mpx_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","No tonowak i ba papasila etega na ginol i ba, ‘Nau ya miminaa Kenani gamagaliliyau wali panuwaa, yaa nu papasila bahi natu lagona nu aaheya Kenani yowauiliyau gamwaliyaa, ");
INSERT INTO mpx_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","yaa nu nok nu na nam tutunau ge o un eliyalil ge natu lagona nu aheya to.’ ");
INSERT INTO mpx_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Yaka no tonowak ya neli ya ba, ‘Yaa ga i ola ebo yova ni towa ge nige ni totoulilau naha nenem?’ ");
INSERT INTO mpx_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Anau i lahe i ba, ‘Yehoba toto ya mipalalek eliyana wana anelose ni patuna alom, yaka wam nawanawa puna ni paolaolaek ge natu lagona nu aheem o un ge nam tutunau eliyalil. ");
INSERT INTO mpx_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Yaa ebo nu na o un eliyalil, ge yova nihi kaise, he iyaka ya sokaliwa ge papasila toto ya ba nu ginol e nu mowasi eliyana.’ Inoke ya papasila nuwatu o kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ewasi ya nem wewel kenken elana, yaka ya awanun ya ba, ‘O Yehoba, no tonowak Abalahama wana Yabowaine, ebo wam nuwatu i ola, inoke no nawanawa puna toto kaiwena ge ya nem ana nuwatu nu paolaolaek. ");
INSERT INTO mpx_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","He nau hiwe wewel kenken gegelinaa ya taltalmilil e. Ebo yova etega ni nem wewel wagi kaiwena ge na baek eliyana na ba, “Tab bosowaina owa wam ulubwal wewelina kekeisi nu pem na im?” ");
INSERT INTO mpx_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ge ebo ni ba, “Ee, u im, inoke wam kamel al na paimwil,” he iya te Yehoba u hile no tonowak natuna kaiwena.’ ");
INSERT INTO mpx_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“He mulaa abwe awanun ya pwamowasi atewa, Lebeka iyaka i novin wana ulubwal i kalivai vevelanaa. I na i lau wewel i wage ge i hesikal, yaka ya baek eliyana ya ba, ‘Tab bosowaina wewel nu pem na im?’ ");
INSERT INTO mpx_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Inoke etimwawa wana ulubwal i nanapaloem vevelanaa ge i ba, ‘Ee, u im, inoke wam kamel al na paimwil.’ Yaka ya im ge no kamel al i paimwil. ");
INSERT INTO mpx_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Yaka ya nel ya ba, ‘He tamwam henala?’ “Yaka i ba, ‘Nau Betuweli natuna, iya Naho ge Milika natuliya.’ Inoke buhun aana ya teli buhunaa ge tovaha ya pahel nimana elal. ");
INSERT INTO mpx_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Inoke ya kululu maniniu ya pahanalowanek bilibiliya ge ya tapwalolo Yehoba eliyana. Yehoba ya tobalan, iya no tonowak Abalahama wana Yabowaine, kaiwena i nul pasapuau ya nem no tonowak talina tubuna yovana na ahe natuna kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ebo no tonowak nuku atilomwan-an ge nuku ginol ni ola wana nuwatu, he no wasa nuku pem. Ebo nigeya, he no wasa al nuku pem, inoke na nuwatu hauna gun al na ginol.” ");
INSERT INTO mpx_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Yaka Leiban ge Betuweli anana hi lahe hi ba, “Nuwatu ya i neem Yehoba eliyana, ama nige bosowaima logugui etega naha ginol. ");
INSERT INTO mpx_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","He Lebeka hiwe. U ahe alomiu nuku nok, inoke alona wami tonowak natuna nihi alolon, ni ola toto Yehoba i nuwatuan.” ");
INSERT INTO mpx_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Sauga Abalahama wana totuwalali wali baaba i hago, yaka i kululu Yehoba elana maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","I mat, yaka tuwan ana isela gold ge silba hi ginoliya alona ge kama i ahel, ge i pek Lebeka eliyana. I ola al, Lebeka nuna ge hinana ali mulolu bugul molaliya bwabwatal i pek elal. ");
INSERT INTO mpx_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Inoke abwe iya ge bolo alonau hi nok hi anan ge hi im, yaka abwe hi kenuana to. Sauga hi lut mwelulugaa, yaka i ba, “Nuku talamwagau naha sikal no tonowak eliyana.” ");
INSERT INTO mpx_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yaa Lebeka nuna ge hinana hi ba, “Aloma yova ga naha mina ebo lan elulutega (10), yaka abwe nuku egon.” ");
INSERT INTO mpx_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yaa i baek eliyalil i ba, “Bahi nuku kukuhikagau. Yehoba no nawanawa puna iyaka i paolaolaek, inoke nuku talamwagau na sikal no tonowak eliyana.” ");
INSERT INTO mpx_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yaka anana hi lahe hi ba, “He yova ta yogaan ge ni ba ga ta hago.” ");
INSERT INTO mpx_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Inoke Lebeka hi yogaan ge hi neli hi ba, “Tab alom tau ya nuku egon?” Yaka i ba, “Ee, ya nonok.” ");
INSERT INTO mpx_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Inoke Lebeka ge wana totuwalali yovana toto ana tomatahikan hi patunal avaliyau Abalahama wana totuwalali ge alonau hi egon. He mulaa abwe hi egon, ");
INSERT INTO mpx_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Lebeka hi ba muloluan ga hi ba, “Numa, ha awanun nu tabwa boda tausan ge tausan hinaliya, ge tubutubumwau ali topihigelgel nihi pakokovel yaka wali panuwa ona nihi ahel.” ");
INSERT INTO mpx_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Yaka Lebeka ge wana totuwalali yowau hi lovivina ge hi ha kamel pwataliyaa, inoke Abalahama wana totuwalali hi toulil ge hi egon nihi na Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","He Aisake i noem panuwa toto alana hi ba, “Wewel Yabowaine Yawalina Gaganina I Kiteyau” labi Negeb elana, kaiwena i miminaa labi o elana. ");
INSERT INTO mpx_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kokoyavi etegana Aisake i na i nawanawa uleya ge i nononuwanuwatu, yaka matana i lipwatanik kamel enuna i kitel hi nenem. ");
INSERT INTO mpx_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","He Lebeka al ge matana i lipwatanik Aisake i kite, yaka i mwena lau wana kamel elana, ");
INSERT INTO mpx_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","inoke i nel Abalahama wana totuwalali eliyana i ba, “Hauna tau laha o i nenem eliyala e?” Yaka totuwalali i ba, “He no tonowak Aisake to.” Inoke Lebeka kama etega i ahe ge maninina i kaus. ");
INSERT INTO mpx_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Sauga hi vin, inoke totuwalali tuwalali wasana gegewena i wasaan Aisake eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Inoke Aisake Lebeka i en tukan hinana Sela wana epanapana gamwanaa ge i alolonan. Yaka Aisake lagona Lebeka i nunuwana-an bubun. He Aisake hinana wana yaomal enaa, Lebeka lagona i payaliyaya ge nuwana i pawaisi. ");
INSERT INTO mpx_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abalahama yova etega al i alolonan alana Ketula. ");
INSERT INTO mpx_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula Abalahama natunau i abil Simlan, Yoksan, Medan, Midiyani, Isbak ge Sua. ");
INSERT INTO mpx_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan natunau eluwa, etegana alana Seba ge eluwana alana Dedan. He toto Dedan tubutubunau heliya boda Asul, boda Letus ge boda Leum. ");
INSERT INTO mpx_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyani natunau bolau Epa, Epel, Hanok, Abida ge Elda. He gamagalau bolo o heliya Ketula tubutubunau. ");
INSERT INTO mpx_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abalahama i ba wana yaomal enaa wana bugul gegewena Aisake ni ahe. ");
INSERT INTO mpx_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Yaa mulaa abwe i yaomal, natunau bolo lagonau al hi abil, ali mulolu i ginolil ge i pek. Inoke abwe i patunal hi egon hi hek labena balimana, ali bwaga ni gan natuna Aisake elana. ");
INSERT INTO mpx_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abalahama yawalina ana baliman 175 i pwawa, ");
INSERT INTO mpx_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","kaununa i puwi ge i liki bubun, yaka wana yana i yana yoho ge i yaomal, i na tubunau bolo hi aliga houwa elal. ");
INSERT INTO mpx_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yaka natunau Aisake ge Isimel tuwana hi ahe ge hi teliya pat golina toto Makpela elana panuwa Mamele labenaa. He gol o i miminaa bilibili buhunaa, toto valila gagama Hiti Epiloni, Sohal natuna wana bilibili, ");
INSERT INTO mpx_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ge Abalahama i pwamolaa elana. Valila Abalahama lagona Sela tuwana i teliya gol o elana, inoke Abalahama tuwana al hi teliya to. ");
INSERT INTO mpx_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abalahama wana yaomal enaa, Yabowaine Aisake i muloluan nabiyan. Saugena o iya i miminaa panuwa toto alana hi ba, “Wewel Yabowaine Yawalina Gaganina I Kiteyau” gegelinaa, labi Negeb elana. ");
INSERT INTO mpx_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hega, Itipita yovana, Sela wana totuwalali loloyowanina, i ab Isimel Abalahama natuna. He Isimel alonau natunau ge tubutubunau liwaniliya i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimel natunau melubolau alaliya i ola hiwe ali ab ana vatala: Nebaiyot, iya gamaun, Kedal, Adibil, Mibsam, ");
INSERT INTO mpx_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, ge Masa, ");
INSERT INTO mpx_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Heidad, Tema, Yetul, Neipis ge Kedema. ");
INSERT INTO mpx_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bolau bolo ya Isimel natunau, heliya un elulutega eluwa tubutubuliyau, ge gamagalau alaliya hi tun papanetan wali panuwa ge wali abaholavi ona eliyalil. ");
INSERT INTO mpx_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","He Isimel yawalina ana baliman 137 i pwawa, yaka wana yana i yana yoho ge i yaomal, i na tubunau bolo hi aliga houwa elal. ");
INSERT INTO mpx_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isimel tubutubunau hi minaa labi toto Havila ge Sul ali luwaluwala. Panuwa Sul iyoho Itipita ana siga labi leunati, labi Asul ana kamwasaa. He nige avaliyau ge tutuliyau bolo Abalahama tubutubunau enuna al hi mimibubun. ");
INSERT INTO mpx_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abalahama natuna Aisake alonau natunau liwaniliya i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisake wana baliman 40 i pwawa, yaka alona Lebeka hi alolon. Lebeka iya Betuweli natuna ge Leiban nuna, heliya Alam gamagaliliyau hi miminaa labi Mesopoteimiya. ");
INSERT INTO mpx_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Lebeka i kobwas, yaka Aisake i awanun Yehoba eliyana lagona kaiwena. Aisake wana awanun Yehoba i hago, inoke Lebeka gamaluwaluwa i liyanagil. ");
INSERT INTO mpx_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Wawayau alona ge alona hi tupayopayou Lebeka tinenaa, yaka i ba, “Ga i ola ge ginol ya i gan eliyau?” Yaka i na i nel Yehoba eliyana ginol o ana sapu kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yaka anana Yehoba i lahe i ba, “Boda labui iyoho tinemwa, natumwau bolo nu abil nihi tabwa boda labui nihi awaawalaka. Yaka etegana alona ni gasisi lake, he toto gamaun ni totuwalali loena elana.” ");
INSERT INTO mpx_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lebeka wana sauga ab i pwawa, yaka bolau gamaluwaluwa i abil. ");
INSERT INTO mpx_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gamaun tuwana i laya ge pupunona i balu i ola kama i gagaloi, inoke alana hi tun Iso. ");
INSERT INTO mpx_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Yaka abwe wawaya labuina i louliulil talina enaa ge talina aena gunina i libhikan, inoke alana hi tun Yakobo. He Aisake wana baliman sikisti (60) elana te Iso ge Yakobo hinaliya i abil. ");
INSERT INTO mpx_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Sauga gemanau hi lobwata, yaka Iso iya iyauka i sibaan ge iya tolotuktuk hot uleya. Yaa Yakobo iya tomikemikekei ge tolomipanuwa. ");
INSERT INTO mpx_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","He Aisake Iso i nunuwana-an nabiyan, kaiwena nuwana bekik ona bunumwiliya ni anan, yaa Lebeka natuna Yakobo i nunuwana-an nabiyan. ");
INSERT INTO mpx_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sauga etega Yakobo sup i ligaliga, yaka Iso i sikalem uleya tuwana i aliga ge i galebu nabi. ");
INSERT INTO mpx_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Inoke i baek Yakobo eliyana i ba, “Ya galebu nabi. Etimwawa sup keketina ei enuna u wagem na an.” (Iso i ba ola o, heiya te kaiwena Iso alana hi tun al Idom.) ");
INSERT INTO mpx_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaka anana Yakobo i lahe i ba, “Owa gamaun bosowaina tamala wana gogomwau awalehina bwabwatana bwaliga nu ahe. He waisi gegewena o u guyauan ga eliyau, yaka lahena sup na pewa.” ");
INSERT INTO mpx_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yaka Iso i ba, “Ya aaliga te, he waisi o nige etega ni lalabeyau!” ");
INSERT INTO mpx_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaka Yakobo i ba, “He sauga ya nu papasila te waisi o u pepem elau.” Inoke Iso i papasila ge gamaun ana waisi i guyauan yoho Yakobo elana. ");
INSERT INTO mpx_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yaka Yakobo bin toto lentil supwina enuna i wage ginebi beleid enuna ge i pek Iso elana. Inoke i aanan ge i im, yaka i lut ge i egon. He Iso nige i nuwanuwatu gamaun ana waisi kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","He galebu bwabwatana etega i masal al labi Kenani elana i ola valila Abalahama wana sauga elana, yaka Aisake i na Pilistiya wali kin Abimeleki eliyana panuwa Gelal. ");
INSERT INTO mpx_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Inoke Yehoba i masal Aisake eliyana ge i ba, “Bahi nu nana Itipita, yaa labi toto ebo na baunaniwa, eliyana te nu minaa. ");
INSERT INTO mpx_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nu miminaa ga labena ya elana, yaka alou owa ge na muloluagiwa. He labena ya gegewena na pewa alomwau ge tubutubumwau eliyamiu, yaka no bateli toto ya papasila-an tamwam Abalahama eliyana na patunahot. ");
INSERT INTO mpx_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Tubutubumwau nihi gewi na pewa, ali gewi ni ola putum hawawala, ge labena ya gegewena na pek eliyalil, ge tubutubunim eliyana gamagalau gegewel panayawiya na muloluagil. ");
INSERT INTO mpx_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Na ginol ola o, kaiwena Abalahama anau i hago, yaka no baaba, no panpankiti ge no logugui i henapuagil.” ");
INSERT INTO mpx_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Inoke Aisake i minaa to panuwa Gelal. ");
INSERT INTO mpx_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Sauga panuwa o bolauiliyau hi neli lagona kaiwena, yaka i ba, “Nu te,” kaiwena i lovakun te ebo ni ba, “Lagou.” He i nuwatu i ba, “Ebo na ba lagou, yaka nasi nihi tagapaaligau, kaiwena Lebeka ana awa i waisi hot.” ");
INSERT INTO mpx_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Sauga Aisake iyaka i minabi panuwa Gelal, yaka lan etega Pilistiya wali kin Abimeleki i imowan tagil wana windowa, matana i lau Aisake i kite alona lagona Lebeka hi loloyasam. ");
INSERT INTO mpx_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Inoke Abimeleki Aisake ana baaba i patuna i nok elana ge i ba, “Age lagom te Lebeka! Hauna kaiwena u ba tage num?” Yaka anana Aisake i lahe i ba, “Kaiwena ya nuwatu te ebo na ba lagou, inoke iya baena nasi nuku tagapaaligau.” ");
INSERT INTO mpx_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Yaka Abimeleki i ba, “Hauna kaba pagan u ginol eliyama e? Bosowaina hot no gamagal etega alona lagom nihi kenu! Binimala ebo ni ola o, yaka wam ginol o kaiwena ama naha minaa lahi elana.” ");
INSERT INTO mpx_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Inoke Abimeleki wana gamagalau gegewel ali logugui i baunan i ba, “Ebo gamagal etega pagan nanakina ni ginol tau ya elana o ebo lagona elana, he nasi na ba nihi lopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisake i eyowa labi o elana, yaka baliman maisena o enona i pwawa paelulu bwagabwaga (pa100), kaiwena Yehoba i muloluan. ");
INSERT INTO mpx_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yaka Aisake wana gogomwau i bwatabwata ya ana siga i wasawasa hot. ");
INSERT INTO mpx_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Wana sipi, goti ge bulumwakau ali yawi bwabwatana ya, ge wana totuwalali hi gewi nabi. Yaka toto o kaiwena Pilistiya hi lamwa pulowanan. ");
INSERT INTO mpx_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Yaka wewel kenken bolo i papatuwalali, bilibili elana hi pakalaopopwil ge hi kausil. He tamana Abalahama yawalina miminana wana totuwalali wewel kenken bolo o hi kenil. ");
INSERT INTO mpx_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Yaka Abimeleki i baek Aisake eliyana i ba, “U egon, wama panuwa u eguluwai, kaiwena u wasawasa hot ge iyaka u gasisi lakema.” ");
INSERT INTO mpx_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Inoke Aisake i miegon ge i na Gelal Abwabwina elana ge i miminaa ga to. ");
INSERT INTO mpx_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","He wewel kenken enuna iyoho bolo valila Abalahama yawalina miminana hi kenil, yaa wana yaomal enaa Pilistiya hi yamwi kausil. Aisake wewel kenken o i kenil al, yaka alaliya i tun i olaolaek alan bolo valila tamana i tuniya. ");
INSERT INTO mpx_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisake wana totuwalali wewel waiwaisana etegana hi ken pwawa abwab o elana. ");
INSERT INTO mpx_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Yaka Gelal wali bwasumu ali tomatahikan avaliyau Aisake wana bwasumu ali tomatahikan hi ba apwaapwanawa hi ba, “Ama wama wewel te.” Yaka wewel kenken o alana i tun Awabalgig, kaiwena alonau hi awabalgig. ");
INSERT INTO mpx_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Yaka wana totuwalali wewel kenken etegana al hi ken, inoke baena hi ba apwaapwanawa al, yaka alana i tun Pihigelgel. ");
INSERT INTO mpx_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Yaka hi miegon labena o elana, inoke wewel etegana al hi ken. He nige baena ge gamagal etega aloliya hi babaa apwaapwanawa, yaka alana i tun Abamina, ge i ba, “He abwe sauga ya wala abamina Yehoba i pem, yaka ta talaabab ge ta gewi.” ");
INSERT INTO mpx_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yaka abwe Aisake i egona o i na i vin Biyaseba. ");
INSERT INTO mpx_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Inoke bulinina Yehoba i masal eliyana ge i ba, “Nau tamwam Abalahama wana Yabowaine. Bahi lovakun, kaiwena nau alou owa. Yaka na mulolu-agiwa ge tubutubumwau nihi gewi na pewa, kaiwena ya bateli no totuwalali Abalahama na muloluan.” ");
INSERT INTO mpx_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisake abapowon i ginol panuwa o elana yaka i kululu Yehoba eliyana. Inoke labena o elana wana epanapana i tal ge wana totuwalali wewel kenken etega al hi ken. ");
INSERT INTO mpx_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki alonau ana tolabe Ahusat, ge wana tolohaveyan wali tohouwa Pikol, hi egona Gelal hi nok hi na Aisake eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yaka Aisake i nelil i ba, “Ga i ola ge ku nem eliyau? He valila ku pihigelgel-agau yaka ku patuna owaowa-agau.” ");
INSERT INTO mpx_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Anana hi lahe hi ba, “He iyaka ha kite bubun Yehoba i minaa eliyam, inoke ha nuwatu te binimala aloma owa bateli gasigasisena etega ta ginol. Aloma owa ta pebabateli-agila, ");
INSERT INTO mpx_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","inoke nu bateli te nige nak etega nu giginol eliyama, ni ola valila ama nige pagan nanakina ha giginol eliyam, yaa sauga gegewena am hehegan ha abubun ge nuwa laumwal elana te ha patunawa u egon. He sauga ya iyaka Yehoba i mulolu-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yaka Aisake aanan bwabwatana i ginol kaiweliya, inoke hi anan ge hi im. ");
INSERT INTO mpx_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Lan i gan mweluluga kekeisi, yaka alona ge alona bateli hi ginol. Inoke Aisake nuwa laumwal elana Abimeleki ge alonau i patunal hi egon. ");
INSERT INTO mpx_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Lan o elana Aisake wana totuwalali hi nem ge wana wasa hi pek wewel kenken toto abwe hi ken kaiwena. Hi ba, “Wewel iyaka ha pwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Yaka wewel kenken alana i tun Seba. Inoke gamagalau panuwa o alana hi babaa Biyaseba ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sauga Iso wana baliman poti i pwawa, yaka Hiti yowauiliyau labui i alolonagil, etega alana Diudit iya Beli natuna ge etegana alana Basimata iya Elon natuna. ");
INSERT INTO mpx_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","He yowau labui ya Aisake ge Lebeka amnaliya hi apapanak-an. ");
INSERT INTO mpx_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisake iyaka i liki nabi ge matana i pweyata nige bosowaina bugul ni kitel, yaka natuna gamaun Iso ana baaba i patuna i nok elana ge i ba, “Natu.” Yaka Iso i talam i ba, “O, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Inoke Aisake i ba, “Iyaka ya liki nabi ge nige ya aatena hauna sauga ge na aliga. ");
INSERT INTO mpx_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","He wam egipoyo alona ge gau u ahel u na uleya u iyauka ge bwasumu bekikina etega nu lol kaiweu. ");
INSERT INTO mpx_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Yaka aanan amnana waiwaisana toto nuwau nu ginol ge nu pwatanim eliyau na an, enaa inoke am ba mulolu na baunaniwa mulaa abwe na aliga.” ");
INSERT INTO mpx_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","He Lebeka iyoho to i lalaegan ge Aisake i baaba natuna Iso elana. Sauga Iso i tagil ge i egon ni na uleya ni iyauka, ");
INSERT INTO mpx_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","yaka Lebeka i baek natuna Yakobo elana i ba, “Ya hago tamwam i baek Iso elana i ba, ");
INSERT INTO mpx_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bwasumu bekikina etegana nu lol, yaka nu pwatanim ge aanan amnana waiwaisana nu ginol na an. Enaa inoke Yehoba matanaa am ba mulolu na baunaniwa mulaa abwe na aliga.’ ");
INSERT INTO mpx_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","He natu, nu laegan bubun ge hauna toto na baunan eliyam nu ginol ola. ");
INSERT INTO mpx_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nu tagil nu na bwasumu ali yawi elana, yaka goti natunau tatabwal eluwa nu hilel ge nu pwatanim eliyau. Yaka aanan amnana waiwaisana na ginol ni ola toto tamwam nuwana. ");
INSERT INTO mpx_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Inoke nu ahe ge nu na nu pek ni an, yaka am ba mulolu ni baunaniwa mulaa abwe ni aliga.” ");
INSERT INTO mpx_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaka Yakobo i baek hinana Lebeka elana i ba, “Yaa taliu Iso, iya tuwana i lopunopuno, nau tuwau i sapusapu. ");
INSERT INTO mpx_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ga i ola ebo nam tuwau ni pibose? He nasi ni atena te ya kakawe, yaka ni ba nuwamut-agau, nige ni baba muloluagau.” ");
INSERT INTO mpx_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Yaka anana hinana i lahe i ba, “Natu, ebo ba nuwamut etega ni baunan, he nakina ni heya nau eliyau! Iyai te nu ginol ni ola hauna ya baunan eliyam. Nu na goti nu ahel ge nu pwatanim eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Inoke i na i ahel ge i lolil, yaka i kainel ge i bugul pwatanik hinana elana. Yaka Lebeka aanan amnana waiwaisana i ginol i ola toto Yakobo tamana nuwana. ");
INSERT INTO mpx_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Inoke natuna gamaun Iso ana kaliko waiwaisana iyoho Lebeka wana epanapana elana, i ahe ge natuna kekeisena Yakobo i pagaloi. ");
INSERT INTO mpx_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","I ola al goti kunisiliya i ahel ge i avan painan Yakobo nimana eluwa elal ge gauna puna elana toto nige i lolopunopuno. ");
INSERT INTO mpx_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Inoke aanan amnana waiwaisana ge beleid toto i umun i bugul pek natuna Yakobo elana. ");
INSERT INTO mpx_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Inoke i na tamana elana ge i ba, “Nam.” Yaka Aisake i talam i ola, “O, natu.” Yaka i nel i ba, “Henala owa, Iso o Yakobo?” ");
INSERT INTO mpx_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo i baek tamana elana i ba, “Nau Iso, natum am gamaun. Wam baaba eliyau iyaka ya ginol paolaolaek. U lut u misiyo ge no iyauka bwasumona enuna nu an, enaa inoke o ba mulolu nu baunanim.” ");
INSERT INTO mpx_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yaka Aisake i nel natuna elana i ba, “Natu, ga i ola ge etimwawa bwasumu u pwawa?” Inoke tamana anana i lahe i ba, “Yehoba wam Yabowaine iya i labeyau te ya pwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yaka Aisake i baek Yakobo elana i ba, “Natu, u miminem gegeliwa ge tuwam na pibose, inoke na atena ebo owa natu Iso, o ebo nigeya?” ");
INSERT INTO mpx_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Inoke Yakobo i miminok tamana Aisake gegelinaa, yaka tuwana tamana i pibose ge i ba, “Anam ana gun i ola te Yakobo anana, yaa nimwam amnana i ola Iso nimana.” ");
INSERT INTO mpx_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","He Aisake nige i aatena te iya Yakobo, kaiwena goti pupunoliya i pibose nimana labui elal amnana i ola talina Iso pupunona. He tage Yakobo ana ba mulolu i babaunanik, ");
INSERT INTO mpx_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","yaka i nel ga i ba, “Tunahot owa natu Iso?” Inoke Yakobo i talam i ba, “Ee, nau te.” ");
INSERT INTO mpx_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yaka Aisake i ba, “Natu, wam iyauka bwasumona enuna nu ahem na an. Enaa inoke am ba mulolu na baunaniwa.” Inoke Yakobo aanan i bugul pek tamana i anan, ge oine enuna al i pek i im. ");
INSERT INTO mpx_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yaka tamana Aisake i baek elana i ba, “Natu, u nem hiwe ge u nalowau.” ");
INSERT INTO mpx_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Inoke Yakobo i nok tamana elana ge i nalo. Sauga kaliko bwalena i hago, yaka i ba: Natu bwalena i ola waluwalu toto Yehoba i muloluan bwalena. Ge i ba muloluan i ba: ");
INSERT INTO mpx_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ya awanun Yabowaine wam bilibili ni pahunhun ge ni pamalul, inoke witi ge oine enowaliya nihi gewi ni pewa, wam abaanan ge wam abaimwim. ");
INSERT INTO mpx_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya awanun panuwa gegewena gamagaliliyau nihi totuwalali eliyam, ge nihi kululu maninimwa. Ya awanun talimwau nu logugui-agil, ge hinam tubutubunau nihi kululu maninimwa. Ya awanun bolo nihi nuwamut-agiwa, Yabowaine ni nuwamut-agil, ge bolo nihi muloluagiwa, iya ni muloluagil. ");
INSERT INTO mpx_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Sauga Yakobo ana ba mulolu i baunan haba ge i tagil i egon, yaka sauga o elana talina Iso i vin, i neem uleya. ");
INSERT INTO mpx_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Yaka Iso al ge aanan amnana waiwaisana enuna i ginol, inoke i ahe ge i pwatanik tamana elana. Yaka i baek elana i ba, “Nam, u lut u misiyo ge no iyauka bwasumona enuna nu an, enaa inoke o ba mulolu nu baunanim.” ");
INSERT INTO mpx_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yaka tamana Aisake i neli i ba, “Henala owa?” Inoke anana i lahe i ba, “Nau Iso, natum am gamaun.” ");
INSERT INTO mpx_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yaka Aisake tuwana gegewena i ginu nabinabi, inoke i nel i ba, “Henala ewasi wana iyauka bwasumona i ginol ge i pwatanim eliyau? Ya anan ge ana ba mulolu ya baunanik haba te abwe u nem. He nige bosowaina na pil.” ");
INSERT INTO mpx_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Sauga Iso i hago tamana i ba ola o, yaka alona wana nuwanak i kahin yogayoga i ba, “Nam, nau al ge o ba mulolu etega u baunanim.” ");
INSERT INTO mpx_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yaa anana Aisake i lahe i ba, “Talim i nem ge i kakaweyau, he am ba mulolu iyaka i ahe.” ");
INSERT INTO mpx_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Yaka Iso i ba, “Age Yakobo alana ku tun bubun ya. He paeluwana te i kakaweyau e. Houwan i kakaweyau, yaka nau gamaun bosowaiu wam gogomwau awalehina bwabwatana bwaliga na ahe ana waisi ya guyauan yoho elana. He sauga ya yaka o ba mulolu i oe al.” Yaka i nel i ba, “Tab ba mulolu etega al iyoho eliyam nau kaiweu ge nu baunanim?” ");
INSERT INTO mpx_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisake Iso anana i lahe i ba, “Iyaka ya ba ni logugui-agiwa, ge tutunau gegewel nihi totuwalali elana. I ola al, iyaka ya ba Yabowaine ni muloluan, witi ge oine enowaliya nihi gewi ni pek. He nige al ba mulolu etega i gagan eliyau owa kaiwem ge tage na baunaniwa, natu.” ");
INSERT INTO mpx_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Yaka Iso i awanun nabinabi tamana elana i ba, “Nam, age ba mulolu maisena ya te i gan elam ge nu baunan? Bahiwa! Nam, nau al ge o ba mulolu nu baunanim!” Inoke i kahin anana i bwata. ");
INSERT INTO mpx_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Yaka anana tamana Aisake i lahe i ba: “He labi toto nige i mamalul ge nige kehe i papahunhun, eliyana nu minaa. ");
INSERT INTO mpx_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Haveyan kilepana eliyana wam waisi nu pwawa, ge nu totuwalali talim elana. Yaa bwaliga nu tagalaka elana, yaka abwe nige al nu miminaa wana logugui gabulanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yaka Iso Yakobo i hugaan nuwamutan, kaiwena iya ana ba mulolu iyaka tamana i baunanik Yakobo elana. Yaka atenaa i nuwatu i ba, “Nige sauga ni yayapu te nam ni yaomal ge naha nuwanak, enaa yaka taliu Yakobo na tagapaaliga.” ");
INSERT INTO mpx_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Sauga Lebeka wana wasa hi pek natuna gamaun Iso hauna i baunan, inoke natuna kekeisena Yakobo, ana baaba i patuna. Sauga i vin, yaka hinana i baek elana i ba, “Talim Iso i nuwatu ni tagapaaligawa, inoke wam ginol lahena ni lahe ge ni yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","He natu, nu ginol ni ola hauna toto na baunan eliyam. Etimwawa nu lou nu na panuwa Halani nu Leiban elana. ");
INSERT INTO mpx_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Yaka alom nuku miminewa ga to lan ehila ya, ana siga talim atena ni laumwal, ");
INSERT INTO mpx_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ge pagan toto u ginol elana ni nuwayoho. Yaka abwe baaba na patuna kaiwem inoke panuwa o nu eguluwan ge nu sikalim. Hauna ana waisi ebo natuwau ami toto labui nuku aliga lan maisena elana?” ");
INSERT INTO mpx_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Yaka abwe Lebeka i na i baek Aisake elana i ba, “Hiti yowauiliyau e bolo Iso lagonau, amnau hi apapanak-an hoti. He bahi Yakobo Hiti yovana etegana labi ya elana ni aalolonan. Ebo ni ola o, he binimala na aliga ya.” ");
INSERT INTO mpx_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Inoke Aisake Yakobo ana baaba i patuna i nok eliyana ge i ba muloluan, yaka i ba pagasisi eliyana i ba, “Bahi Kenani yovana etegana nu aalolonan. ");
INSERT INTO mpx_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nu na Mesopoteimiya hinam tamana Betuweli wana limiya. Hinam nuna Leiban natunau galokau hi gan, gamwaliyaa etegana nu hile ge nu alolonan. ");
INSERT INTO mpx_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yabowaine Togasisi Hot ni muloluagiwa yaka natumwau nihi gewi ni pewa, ge tubutubumwau nihi tabwa boda bwabwatana ali un tomaha ge tomaha. ");
INSERT INTO mpx_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Yabowaine owa ge tubutubumwau ni muloluagimiu ni ola i bateli Abalahama ni muloluan. Yaka bilibili toto sauga ya ta mibwabwaliya, toto i pek Abalahama elana, nuku ahe wami bilibili.” ");
INSERT INTO mpx_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Inoke Aisake Yakobo i patuna ge i egon ni na Mesopoteimiya Leiban elana. Leiban iya Betuweli gagama Alam natuna, Yakobo ge Iso hinaliya Lebeka nuna. ");
INSERT INTO mpx_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso wasa i hago te Aisake Yakobo i ba muloluan ge i patuna ni na Mesopoteimiya lagona etega ni ahem to. I ola al wasa i hago te Aisake i ba pagasisi Yakobo eliyana i ba, “Bahi Kenani yovana etegana nu aalolonan.” ");
INSERT INTO mpx_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iso wasa i hago al te Yakobo tamana ge hinana wali baaba i henapuan ge iyaka i egon ni na Mesopoteimiya. ");
INSERT INTO mpx_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Inoke i atena te tamana Aisake nige i yayaliyaya Kenani yowauiliyau kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Inoke i na Abalahama natuna Isimel elana ge natuna yovana alana Mahalat i alolonan, lagonau bolo i alolonagil houwan ali etulan. He Mahalat iya Nebaiyot nuna. ");
INSERT INTO mpx_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo Biyaseba i eguluwan i nanawa panuwa Halani kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Sauga i novin panuwa etega elana inoke i veyaho, kaiwena sabwelu iyaka i lobek. Pat etega i aheya to ge i teli kokowana ana kebeyalu inoke i kenu. ");
INSERT INTO mpx_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I kenonou teti etega i kite i milila panayawiya, buhuna i na i tupa labulabumwa, yaka eliyana Yabowaine wana anelose hi haha ge hi laulau. ");
INSERT INTO mpx_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yaka Yakobo Yehoba i kite i talmilila labenaa ge i ba, “Nau Yehoba, tubum Abalahama wana Yabowaine ge Aisake wana Yabowaine. Bilibili toto eliyana u kenuwa na pewa owa ge tubutubumwau eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tubutubumwau nihi gewi nabi nihi ola bilibili papakovana, ge wali bilibili ni na yalasa, balimana, aluwabwa ge yavanaa. Yaka owa ge tubutubunim eliyamiu un gegewel panayawiya na muloluagil. ");
INSERT INTO mpx_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Alou owa ge hauna labi elana nu noek na matahikagiwa, yaka na pasikaliwa al panuwa ya elana. Nige na eeguluwagiwa ana siga hauna gun ya bateli eliyam na ginol.” ");
INSERT INTO mpx_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaka Yakobo i kenu lut inoke i ba, “Age tunahot Yehoba iyahe panuwa ya elana, yaa nige ya aatena.” ");
INSERT INTO mpx_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yaka i lovakun ge i ba, “Panuwa ya i lololovakun! He Yabowaine wana limi te, labulabum ana abauluulutuk ana nog.” ");
INSERT INTO mpx_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Lan i gan mweluluga kekeisi Yakobo i lut, yaka pat toto i teli kokowana ana kebeyalu i ahe i pamilil abanuwahikan. Inoke enonu i hol pwatanaa i pwabwabwalena Yabowaine kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yaka panuwa o alana i tun Betel, yaa houhouwena alana Lus. ");
INSERT INTO mpx_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Inoke Yakobo i papasila Yehoba elana i ba, “Ebo alou owa ge nu matahikagau nawa yayapona toto e na nawaan, aanan nu pem na an ge kaliko nu pem na galoi, ");
INSERT INTO mpx_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ge ebo alou no molu na sikal al nam wana panuwaa, yaka owa Yehoba nu ola no Yabowaine, ");
INSERT INTO mpx_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ge pat toto ya pamilil abanuwahikan ni tabwa wam limi, abatapwalolo. Ge bugubugul gegewena bolo nu pem na wali paelulutega (pa10) yaka gamwaliyaa, wali maisena na pewa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Inoke Yakobo i novevehe i na i vin gamagalau bolo nati wali labiya. ");
INSERT INTO mpx_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yaka matana i nok wewel kenken etega i kite labi toto nige gamagal hi miminaa. Sipi ge goti ali yawi eton wewel hi kenu painan, kaiwena hi papaimwiliya to. He wewel kenken awana ana epaankaus pat bwabwatana pupulowanina. ");
INSERT INTO mpx_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sauga ebo tomatahikan gegewel wali sipi ge goti ali yawi nihi bugul papaheliya o, yaka wewel awana ana epaankaus nihi pakul egonan, inoke sipi ge goti nihi paimwil. Inoke abwe nihi pakul pasikal al abanaa. ");
INSERT INTO mpx_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaka Yakobo i nel sipi ali tomatahikan elal i ba, “Taliwau, komiu hapanuwa gamagaliliyau?” Anana hi lahe hi ba, “Ama panuwa Halani gamagaliliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yaka i ba, “Tab ku atena Leiban, Naho tubuna?” Anana hi lahe hi ba, “Ee, ha atena ya.” ");
INSERT INTO mpx_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaka i nel al i ba, “Tab i molu?” Anana hi lahe hi ba, “Ee, i molu. He natuna yovana Letiyeli iya huwo i nenem o, alonau tamana wana sipi.” ");
INSERT INTO mpx_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaka Yakobo i baek elal i ba, “He sabwelu bwabwaliga ya te! Nigeya ga sipi ge goti ali sauga bugul pahipahi i oola. Binimala nuku paimwil yaka nuku pasikalil ge nihi alamwawin.” ");
INSERT INTO mpx_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Anana hi lahe hi ba, “Nige bosowaina naha ginol ola, ana siga tomatahikan gegewel wali sipi ge goti ali yawi nihi bugul papahel. Yaka abwe wewel awana ana epaankaus naha pakul egonan, inoke sipi ge goti naha paimwil.” ");
INSERT INTO mpx_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo iyoho ya alonau hi baaba, inoke Letiyeli i vin, alonau tamana wana sipi, kaiwena iya ali tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Sauga Yakobo Letiyeli i kite alonau ge Leiban wana sipi, inoke i na wewel kenken awana ana epaankaus pat i pakul egonan ge wana valehe wana sipi i paimwil. He Letiyeli iya Yakobo wana valehe Leiban natuna yovana. ");
INSERT INTO mpx_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Inoke Yakobo Letiyeli i nalo ge i kahin anana i bwata. ");
INSERT INTO mpx_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yaka i baek elana i ba, “Nau tamwam wana geman, nuna Lebeka natuna.” Inoke Letiyeli i tapalelu i na tamana wana wasa i pek. ");
INSERT INTO mpx_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Sauga Leiban wana geman wasana i hago, inoke i tapalelu i na i kite. Yaka i holatomwa ge i nalo, inoke i en hi na wana limiya. Yaka Yakobo bugul gegewena bolo hi masal elana i wasaan Leiban elana. ");
INSERT INTO mpx_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Inoke Leiban i baek elana i ba, “He tunahot owa tutu hot.” He weikena maisena Yakobo i miminaa Leiban elana, ");
INSERT INTO mpx_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","enaa inoke Leiban i baek elana i ba, “Bwagana owa no geman hot, yaa nige bosowaina nu tuwalali bwagabwaga eliyau. U ba na hago, hauna kaba mola nuwam?” ");
INSERT INTO mpx_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","He Leiban natunau yowau labui, toto gamaun alana Leya ge loena alana Letiyeli. ");
INSERT INTO mpx_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya nige ana awa i wawaisi hot, yaa Letiyeli i hebubun ge ana awa i gagahiyan. ");
INSERT INTO mpx_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo Letiyeli i hebabale inoke i baek Leiban elana i ba, “Baliman seben na tovelam eliyam natum yovana kekeisena Letiyeli kaiwena, inoke nu talamwan na alolonan.” ");
INSERT INTO mpx_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Anana Leiban i lahe i ba, “I waisi te na talamwan eliyam. Nige tau etega al ya nunuwatu-an ge tage ni alolonan. He alou owa ta minaa te.” ");
INSERT INTO mpx_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Inoke Yakobo i tovelam Leiban elana baliman seben Letiyeli kaiwena. Yaa baliman seben o, Yakobo eliyana i ola ya te lan ehila ya, kaiwena Letiyeli ana nunuwana i bwata hot elana. ");
INSERT INTO mpx_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Inoke Yakobo i baek Leiban elana i ba, “Natum u pem na alolonan. No tovelam ana baliman seben iyaka i pwawa, he nuwau alou naha mitoyawa.” ");
INSERT INTO mpx_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Inoke Leiban alolon hagalena i ginol, ge panuwa o gamagaliliyau gegewel i yogaagil hi nok. ");
INSERT INTO mpx_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Yaa bulin o natuna gamaun Leya te i ahe ge i na i pek Yakobo elana alona hi kenu matavi. ");
INSERT INTO mpx_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(He Leiban wana totuwalali loloyowanina yovana alana Silpa i pek natuna Leya elana wana totuwalali loloyowanina.) ");
INSERT INTO mpx_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sauga lan i gan mweluluga, Yakobo i kite age Leya te alona hi kenu. Inoke i na Leiban elana ge i ba hugahuga i ba, “Hauna kaiwena ge pagan ya u ginol eliyau? Letiyeli kaiwena te ya tovelam eliyam! Ga i ola ge u kakaweyau?” ");
INSERT INTO mpx_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Anana Leiban i lahe i ba, “Ama panuwa e nige wama pagan i ola tage natuma kekeisena naha paalolon houwan, mulaa abwe gamaun. ");
INSERT INTO mpx_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","He u matamatan ga natuma toto ya wana alolon ana yaliyaya wik maisena ni mowasi, yaka abwe loena al naha pewa. Yaa nasi baliman seben al nu tovelam eliyau iya kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Inoke Yakobo i ginol ola to. I matamatan wali alolon ana yaliyaya wik maisena i mowasi, inoke abwe Leiban natuna Letiyeli i pek Yakobo elana ge i alolonan. ");
INSERT INTO mpx_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","He Leiban wana totuwalali loloyowanina yovana alana Bilha i pek natuna Letiyeli elana wana totuwalali loloyowanina. ");
INSERT INTO mpx_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo alona al Letiyeli hi kenu toyawa, yaka Letiyeli i nunuwana-an nabiyan, yaa Leya nige i nunuwana-an bubun. Inoke baliman seben al Yakobo i tovelam Leiban elana Letiyeli kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Sauga Yehoba i kite Yakobo nige Leya i nunuwana-an bubun, inoke i talam ni abab ge natunau nihi gan, yaa Letiyeli i kobwas nige natuna i gagan. ");
INSERT INTO mpx_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Yaka Leya i liyan ge i ab natuna melutau, inoke alana i tun Lubeni. I tun ola o kaiwena i ba, “Yehoba o pulowan iyaka i kite. He nasi abwe lagou ni nunuwana-agau!” ");
INSERT INTO mpx_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yaka abwe i liyan al ge i ab natuna melutau, inoke i ba, “Yehoba i hago te lagou nige i nunuwana-agau bubun, inoke natu tauina toto ya i pem al.” Yaka alana i tun Simiyon. ");
INSERT INTO mpx_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yaka abwe i liyan al ge i ab natuna melutau, inoke i ba, “Nasi o nuwan ni bwata lagou elana, kaiwena natunau bolau eton ya abil.” Yaka alana i tun Libai. ");
INSERT INTO mpx_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yaka abwe i liyan al ge i ab natuna melutau, inoke i ba, “Sauga ya Yehoba na tobalan.” Inoke alana i tun Yuda. Yaka abwe ab i pahanateli-an. ");
INSERT INTO mpx_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Sauga Letiyeli i atena iya nige bosowaina Yakobo natuna etega ni ab, inoke talina Leya i lamwa pulowanan. Yaka i baek Yakobo elana i ba, “U paliyanagau. Ebo nigeya, he binimala na aliga ya!” ");
INSERT INTO mpx_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Inoke Yakobo Letiyeli i hugaan ge i baek elana i ba, “Nau nige Yabowaine i oola. Iya te i kausiwa ge nige u aab!” ");
INSERT INTO mpx_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Yaka Letiyeli i baek elana i ba, “No totuwalali loloyowanina yovana Bilha hiwe. Alom nuku kenukenu, inoke ebo ni liyan ge ni ab, wawayau na awa natunagil. Yaka iya eliyana natuwau nihi gan.” ");
INSERT INTO mpx_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Inoke Letiyeli Bilha i pek Yakobo elana i tabwa lagona al. Inoke alona hi kenukenu, ");
INSERT INTO mpx_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","yaka i liyan ge Yakobo natuna melutau etega i ab. ");
INSERT INTO mpx_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Inoke Letiyeli i ba, “Yabowaine iyaka i awa sapusapu-agau, ge no awanun i hago, yaka natu melutau etega i pem.” Inoke alana i tun Dani. ");
INSERT INTO mpx_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha i liyan al, yaka i ab palabuina Yakobo natuna melutau. ");
INSERT INTO mpx_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Inoke Letiyeli i ba, “Ya logasisi nabi taliu elana ge ya lake.” Inoke alana i tun Napitalai. ");
INSERT INTO mpx_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","He Leya i atena te iya iyaka ab i pahanateli-an, inoke wana totuwalali loloyowanina yovana, Silpa, i pek Yakobo elana i tabwa lagona al. ");
INSERT INTO mpx_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silpa Yakobo natuna melutau etega i ab. ");
INSERT INTO mpx_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Yaka Leya i ba, “No waisi ya pwawa te.” Inoke alana i tun Gada. ");
INSERT INTO mpx_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silpa i ab palabuina Yakobo natuna melutau. ");
INSERT INTO mpx_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Yaka Leya i ba, “Ya yaliyaya hot! Nasi yowau nihi awa yaliyaya-agau.” Inoke alana i tun Aseli. ");
INSERT INTO mpx_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","He witi ana lovetomwa ana sauga elana, Lubeni i na uleya yaka mwawin alana mendeleik enuna i pwawal. Inoke enona enuna i bugulan ge i na i pek hinana Leya elana. Yaka Letiyeli i awanun Leya elana i ba, “Tab bosowaina mendeleik enona toto natum i pwawa, enuna nu pem elau?” ");
INSERT INTO mpx_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Yaa Leya i baek elana i ba, “Lagou iyaka u oe. Nige mananana, yaka nuwam al mendeleik enona toto natu i pwawa nu ahe?” Yaka Letiyeli i baek elana i ba, “Ebo mendeleik enona toto natum i pwawa nu pem elau, inoke molana nasi bulina alom ge Yakobo nuku kenu.” ");
INSERT INTO mpx_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kokoyavi o elana, Yakobo i sikalem uleya, inoke Leya i na i pwawa kamwasaa ge i baek elana i ba, “Nasi bulina alou owa ta kenu, kaiwena mendeleik enona toto natu i pwawa, eliyana iyaka ya pwamolawa.” Inoke bulin o Yakobo alona ge Leya hi kenu. ");
INSERT INTO mpx_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yaka Leya i liyan ge i ab panimala panunana Yakobo natuna melutau, kaiwena wana awanun Yabowaine i hago. ");
INSERT INTO mpx_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yaka Leya i ba, “Yabowaine mola waiwaisana i pem, kaiwena valila no totuwalali yovana ya pek lagou elana.” Inoke alana i tun Isaka. ");
INSERT INTO mpx_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Yaka abwe Leya i liyan al ge i ab pasikisina Yakobo natuna melutau. ");
INSERT INTO mpx_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Inoke i ba, “Yabowaine o mulolu waiwaisana etega i muloluan eliyau, yaka nasi lagou ni awatauwagau, kaiwena natunau melubolau sikis ya abil.” Inoke alana i tun Sebuloni. ");
INSERT INTO mpx_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Sauga etega al abwe Leya yova etega i ab, inoke alana i tun Daina. ");
INSERT INTO mpx_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Yabowaine nige Letiyeli i nunuluwan, wana awanun i hago yaka i ba bosowaina natuna ni gan. ");
INSERT INTO mpx_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yaka abwe i liyan ge natuna melutau etega i ab, inoke i ba, “O puluwawi iyaka Yabowaine i ahe yoho.” ");
INSERT INTO mpx_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ge i ba, “Ya awanun Yehoba natu melutau etega al ni pem.” Inoke alana i tun Yosepa. ");
INSERT INTO mpx_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Letiyeli Yosepa i ab enaa, inoke Yakobo i baek Leiban elana i ba, “U talamwagau na sikal no panuwaa. ");
INSERT INTO mpx_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Lagowau kaiweliya ya tovelam nabi eliyam, he nu talamwagil na ahel aloliyau ge wawayau, yaka naha egon. Iyaka u atena te ya loaliga nabi ge ya tovelam eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Yaa Leiban i baek elana i ba, “Ya awanun eliyam bahi nu eguluwagau. He sula ya ab inoke i pamasal te owa kaiwem Yehoba i muloluagau. ");
INSERT INTO mpx_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","He molam u baunan na hago inoke na pwamolawa.” ");
INSERT INTO mpx_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo i baek elana i ba, “U atena ya te ya tuwalali nabi eliyam yaka wam bwasumu hi lowaisi, kaiwena ya matahikagil bubunil. ");
INSERT INTO mpx_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Valila nige ga ya nenem eliyam wam bwasumu nige hi gegewi, yaa sauga ya hi gewi nabi. Hauna labi ya noek ge hauna gun ebo ya ginol, Yehoba i mumulolu-agiwa. He hauna sauga ge na logasisi alowau natuwau wama waisi kaiwena?” ");
INSERT INTO mpx_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Inoke Leiban i nel Yakobo elana i ba, “Hauna gun na pewa?” Anana i lahe i ba, “Bahi bugul etega nu pepem. Yaa no nuwatu i ola hiwe. Ebo nu talamwi, inoke na tuwalali vevehe al ge wam bwasumu na matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","He lan ebe na na na nosola wam bwasumu ali yawi gegewel gamwaliyaa, inoke sipi tuwaliya bibikena gegewel, ge goti lelemwal o ebo leituntun gegewel, na teli walel. He bolo o nu pem molau. ");
INSERT INTO mpx_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Inoke bwaliga etimwawa nu kite pwawa ebo molau ya ahe paolaolaek o ebo ya kakawi. Ebo goti etega tuwana nige ni lelemwalemwa o ni leleituntun, o ebo sipi etega tuwana nige ni bibiki, nu kiteya no bwasumu ali yawi gamwanaa, inoke nu atena te ya kaome.” ");
INSERT INTO mpx_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Anana Leiban i lahe i ba, “I waisi, ta ginol ni ola wam baaba.” ");
INSERT INTO mpx_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Yaa lan o goti melubolau ge meluyowau bolo wawakeki i mihawahawan tuwaliyaa — bolo hi lemwalemwa, bolo hi leituntun ge bolo hi gayatomwa — gegewel Leiban i ahek yohil, avaliyau sipi gegewel bolo tuwaliya i biki. Inoke i telel natunau bolau nimaliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yaka alonau ge natunau sipi ge goti hi ahel hi na panuwa etega ali bwaga i gan Yakobo elana, ana yapu i ola lan eton ana nawanawa. He Yakobo Leiban wana goti ge sipi bolo i eguluwagil i matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobo abwakil alaliya popla, almon ge pelein, laliya enuna i govel. Yaka kunisiliya i puni hawahawanan ge awalehina i puni teli, yaka wawakeki i masal ge ali awa i palemwalemwa. ");
INSERT INTO mpx_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yaka ebwakil laliya bolo i puni hawahawanan i pamilil bwasumu wali abaimwim elana, yaka sauga ebo nihi nem im kaiwena, ebwakil iyoho mataliyaa. I pamililiya o, kaiwena sauga ebo bwasumu nihi nem im kaiwena, inoke nihi lolagolagona to. ");
INSERT INTO mpx_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Inoke sauga goti hi lopoipoi, he ebwakil laliya iyoho awoliyaa, yaka natuliyau hi abil hi lolemwalemwa, hi loleituntun o ebo hi logayatomwa. ");
INSERT INTO mpx_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo sipi i walel abaliya i getoga. Yaka wali sauga lolagolagon elana, sipi i paawona noek wana goti lelemwal ge Leiban wana goti tuwaliya bibikel elal. Yaka sipi hi ab natuliyau tuwaliya i biki. I ginol ola o, inoke iya totona wana bwasumu ali yawi hi gan, yaa nige i tetelel pamaisena alonau Leiban wana bwasumu. ");
INSERT INTO mpx_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","He goti meluyowau gasigasisel wali sauga lolagolagon, inoke Yakobo abwakil laliya ni pamilil wali abaimwim elana goti mataliyaa, inoke sauga nihi lopoipoi, ebwakil laliya iyoho awoliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Yaa bolo nige hi gagasisi wali sauga lolagolagon, inoke Yakobo nige abwakil laliya i papamilil mataliyaa. Yaka goti bolo nige hi gagasisi heliya Leiban wana bwasumu, ge bolo hi gasisi heliya Yakobo wana bwasumu. ");
INSERT INTO mpx_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ginol o eliyana Yakobo i gogomwau nabi. Wana sipi ge wana goti, wana kamel ge wana donki hi gewi nabi, i ola al wana totuwalali bolau ge yowau. ");
INSERT INTO mpx_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo wasa i hago Leiban natunau bolau hi baaba kaiwena hi ba, “Tamala wana bugubugul gegewena Yakobo i bugulan te i gogomwaui e.” ");
INSERT INTO mpx_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","I ola al Yakobo i kite Leiban wana ginol eliyana nige i oola valila. ");
INSERT INTO mpx_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Inoke Yehoba i baek Yakobo elana i ba, “Nu sikal nu na tamwam ge tubum wali panuwaa tutumwau elal. He nau alou owa.” ");
INSERT INTO mpx_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yaka Yakobo baaba i patuna Letiyeli ge Leya eliyalil nihi nem ge nihi kite uleya, labi toto wana bwasumu i teleliya. ");
INSERT INTO mpx_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Hi vin elana inoke i baek elal i ba, “Ya kite tamamiu wana ginol eliyau nige i oola valila, yaa nam wana Yabowaine i miminaa eliyau. ");
INSERT INTO mpx_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","He komiu ku atena te ginebi ge no gasisi bwalibwaligena ya tuwalali tamamiu kaiwena, ");
INSERT INTO mpx_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","yaa i kakakaweyau ge pagewigewi molau i teliteli pwapwati. Yaa Yabowaine nige i tatalam tage wana ginol o eliyana ge nau ni pakalau. ");
INSERT INTO mpx_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sauga ebo ni ba, ‘Bwasumu tuwaliya lelemwana nu ahel wam tuwalali molana,’ yaka bwasumu toabab gegewel hi ab natuliyau tuwaliya lelemwana. Ge sauga ebo ni ba, ‘Bolo tuwaliya gayatomwa nu ahel molam,’ yaka bwasumu toabab gegewel hi ab natuliyau tuwaliya gayatomwa. ");
INSERT INTO mpx_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Inoke ginol o eliyana Yabowaine tamamiu wana bwasumu i aheliem elana ge i pem eliyau. ");
INSERT INTO mpx_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“He bwasumu wali lolagolagon ana sauga elana, kenonou etega ya kenonouan. Matau ya lihin ge ya kite goti melutauil bolo avaliyau ge goti meluyowau hi lolopoipoi, heliya tuwaliya gayatomwa, lelemwal ge leituntun. ");
INSERT INTO mpx_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Yaka kenonou o elana Yabowaine wana anelose i baem eliyau i ba, ‘Yakobo.’ Yaka anana ya lahe ya ba, ‘O, nau iyahe.’ ");
INSERT INTO mpx_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Inoke i ba, ‘Matam nu lihin ge nu kite te goti melutauil bolo avaliyau ge goti meluyowau hi lolopoipoi, heliya tuwaliya gayatomwa, lelemwal ge leituntun. He nau te ya ba ge hi ola o, kaiwena Leiban wana ginol eliyam gegewena iyaka ya kite. ");
INSERT INTO mpx_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nau Yabowaine toto ya masala eliyam panuwa Betel elana, labi toto pat u pamilila ge enonu u hol pwatanaa, ge u papasila nu tapwaloloem ya te elau. He sauga ya nu lovivina yaka labi ya nu eguluwan ge nu sikal panuwa toto u masala.’” ");
INSERT INTO mpx_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yaka Letiyeli ge Leya Yakobo anana hi lahe hi ba, “Nige tamama wana gogomwau etega ni nenem eliyama ge ana waisi naha pwapwawa! ");
INSERT INTO mpx_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Wana ginol eliyama i ola ama panuwa getoga yowauiliyau. I paliagima eliyam, inoke molama gegewena iyaka i apapanak-an haba. ");
INSERT INTO mpx_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","He gogomwau bolo Yabowaine i aheliem tamama elana ge i pewa eliyam, gegewena o ama ge natumeyau eliyama to. He nu ginol ni ola hauna toto Yabowaine i baunan eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Inoke Yakobo natunau ge lagonau i usanil kamel pwataliyaa ");
INSERT INTO mpx_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ge wana bwasumu gegewel i panohouwa-agil awonaa. He wana bugubugul gegewena bolo i pwawal Mesopoteimiya i ahel, yaka i egon ni na tamana elana labi Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mulaa abwe hi egon, Leiban i na wana sipi pupunoliya i tomwatomwa, yaka Letiyeli tamana wana limi ana yabowaineyau gogoginolil i kaomel. ");
INSERT INTO mpx_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","He Yakobo nige wana egon wasana i babaunan Leiban gagama Alam elana, yaa i kakawe ge i lou sumi. ");
INSERT INTO mpx_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inoke wana bugubugul gegewena i bugulan ge i lou, yaka wewel Yupeleitis i kalapanet-an ge labi Giliyad oyana kaiweliya i nanawa. ");
INSERT INTO mpx_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lan etonina elana abwe Leiban wana wasa hi pek te Yakobo iyaka i lou. ");
INSERT INTO mpx_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Inoke tutunau i ahel alonau, ge lan seben hi tatauliulil Yakobo enaa, ana siga hi nopakelakelaubwa elana labi Giliyad oyana elal. ");
INSERT INTO mpx_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bulina Yabowaine i masala Leiban ana kenonou elana ge i baek elana i ba, “Wam baaba gegewena Yakobo elana nu matahikan.” ");
INSERT INTO mpx_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","He Yakobo wana epanapana i pamilila to Giliyad oyana elal. Inoke sauga Leiban Yakobo i kukuhikan, yaka alonau tutunau wali epanapana hi pamilila al to. ");
INSERT INTO mpx_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Inoke Leiban i na i baek Yakobo elana i ba, “Ga i ola ge u kakaweyau ge natuwau yowau u ahel egonagil i ola u oeliem haveyana? ");
INSERT INTO mpx_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Hauna kaiwena u kakaweyau ge u lou sumi? Binimala valila no wasa nu pem, inoke wami egon ana yaliyaya naha ginol ge naha wonawona ginebi tambalin ge gita ona. ");
INSERT INTO mpx_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Yaa nige no sauga etega u pepem tage tubuwau aloliyau ge hinaliyau na nalol ge na lokaiyoni elal. Sigasiga paganina hot u ginol! ");
INSERT INTO mpx_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","No gasisi i gan bosowaiu na apanakimiu, yaa bulina tamwam wana Yabowaine i baem elau i ba, ‘Wam baaba gegewena Yakobo elana nu matahikan.’ ");
INSERT INTO mpx_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","He ya atena te u egon kaiwena nuwam hot nu sikal wam panuwaa. Yaa hauna kaiwena no limi ana yabowaineyau gogoginolil u kaomel?” ");
INSERT INTO mpx_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Inoke anana Yakobo i lahe i ba, “Ya lou sumi kaiwena ya lovakun. Ya nuwatu te nasi natumwau yowau nu ahel pasikalil. ");
INSERT INTO mpx_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yaa ebo wam limi ana yabowaineyau nu pwawaliya ama etega eliyana, he gamagal o ni aliga. Tutulau mataliyaa u loya. Ge ebo wam bugul etega nu pwawaa eliyau, inoke nu ahe.” He Yakobo nige i aatena te Letiyeli tamana wana limi ana yabowaineyau i kaomel. ");
INSERT INTO mpx_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Inoke Leiban i na i ulutuk Yakobo wana epanapana gamwanaa, yowau totuwalali eluwa wali epanapana gamwanaa ge Leya wana epanapana gamwanaa, yaa nige bugul etega i pwapwawa. I tagila Leya wana epanapana elana inoke i na i ulutuk Letiyeli wana epanapana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","He Letiyeli iyaka etimwawa tamana wana limi ana yabowaineyau i ahel ge i telel abamisiyo toto hi teteliya kamel pwatanaa gamwana etega elana, ge i anhikagil. Leiban epanapana gamwana gegewena i loyaan bubun, yaa nige bugul etega i pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Yaka abwe Letiyeli i baek tamana elana i ba, “Tonowak, bahi nu huhuga eliyau. Nige bosowaiu na lut ge na talmilil maninimwa, kaiwena ya weikena kasiyebwa.” Inoke Leiban i loyaloya, yaa nige wana limi ana yabowaineyau i pwapwawal. ");
INSERT INTO mpx_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Inoke Yakobo i huga ge Leiban i ba lalaan i ba, “Hauna nak ya ginol? O ebo hauna logugui ya leke ge kaiwena o lau u lau ge u tatauliulil-agau? ");
INSERT INTO mpx_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","No bugubugul gegewena iyaka u loyaagil haba. Tab wam limi bugulina etega u pwawa? Ebo i ola, he nu teliya hiwe owa ge nau tutulau mataliyaa, yaka nihi hilela henala ge i sapu, owa o ebo nau. ");
INSERT INTO mpx_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ya miminaa eliyam baliman ana gewi tuwenti. Wam sipi ge goti ya matahikagil ge hi abab bubun. Nige wam sipi tauina etega ya aan kaome. ");
INSERT INTO mpx_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sauga ebo bwasumu sosokana wam sipi o ebo goti etega i alapaaliga, inoke totou no sipi o ebo goti ya aahe ge ya teteli lahe. Nige tage toto i aliga na pwataniwa elam ge nu kite. Bwagana ebo i yaomala lana o ebo bulina, yaka lahena bana u aawa molamola eliyau. ");
INSERT INTO mpx_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lana sabwelu kalakalasina i lolau, ge bulina ya wawatut. Ge nige ya kekenu bubun. ");
INSERT INTO mpx_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Baliman ana gewi tuwenti ya miminaa eliyam ya olaola ya to. Baliman potin ya tovelam eliyam natumwau yowau labui kaiweliya, ge baliman sikis ya tuwalali wam bwasumu kaiweliya. Yaa pagewigewi molau u teliteli pwapwati. ");
INSERT INTO mpx_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Binimala tubu Abalahama wana Yabowaine toto nam Aisake i awatauwan, nige ni miminaa eliyau, he nimwau enoenovana ya te nu patunau na egon. Yaa Yabowaine no lomwan ge no tuwalali gagasisi i kite, inoke toto o kaiwena te bulin i ba pahenapowa.” ");
INSERT INTO mpx_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Inoke Leiban Yakobo anana i lahe i ba, “Yowau bolo e heliya natuwau, ge natuliyau heliya tubuwau. Bwasumu bolo e nau no bwasumu, ge bugubugul gegewena bolo u kitel e nau no bugul. Yaa iyaka nige bosowaiu bugul etega na ginol ge natuwau yowau aloliyau ge natuliyau na ahel pasikalil. ");
INSERT INTO mpx_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","He alou owa ta pebabateli-agila. Ge etotohina pat ta pahe ni panuwahikagila wala bateli kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Inoke Yakobo pat yayapona etega i ahe ge i pamilil i ola kokola. ");
INSERT INTO mpx_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yaka i ba tutunau elal pat enuna hi bugulan ge epwepwet hi pahe. Inoke Yakobo ge Leiban hi pebabateli-agil, yaka avaliyau ge tutuliyau hi misiyo epwepwet gegelinaa ge hi anan. ");
INSERT INTO mpx_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","He liwanina i ola hiwe. Leiban epwepwet o alana i tun Pana Alameik elana Yegal Sahaduta ge pana Hibilu elana Yakobo i tun Galid. ");
INSERT INTO mpx_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Leiban i baek Yakobo elana i ba, “Epwepwet toto e owa ge nau ni panuwahikagila wala bateli kaiwena toto nasi ta ginol.” Heiya te kaiwena alana hi tun Galid. ");
INSERT INTO mpx_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Inoke i ba al i ola, “Ya awanun Yehoba ni kite hikagila sauga ebo ta miwali.” Yaka epwepwet o alana al hi tun Mispa. ");
INSERT INTO mpx_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Inoke Leiban i ba vevehe al i ba, “Ebo natuwau yowau ali hehegan nu apapanak-an, o ebo yowau enuna al nu alolonagil, bwagana nige gamagal etega ni gagan ge ni kikite, yaa nu nuwahikan te Yabowaine iya owa ge nau ala topekiti.” ");
INSERT INTO mpx_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Yaka i baek al Yakobo elana i ba, “Epwepwet ge pat i milil i ola kokola nu kitel e, bolo ya ba ge ta ginolil owa ge nau ala luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Heliya nihi panuwahikagila wala bateli kaiwena. Inoke nau bahi epwepwet ya na lilikaan ge na nonowa wam labiya na hahaveyan eliyam, ge owa bahi epwepwet ya ge pat i milil i ola kokola ya nu lilikaan ge nu nenem no labiya nu hahaveyan eliyau. ");
INSERT INTO mpx_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ya awanun tubum Abalahama wana Yabowaine ge tubu Naho wana yabowaine, ebo ala toto eluwa etega bateli ya ni leke, nihi lahe.” Inoke Yakobo i bateli ola to, ge Yabowaine toto tamana Aisake i awatauwan alana i papasila-an. ");
INSERT INTO mpx_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaka Yakobo bwasumu etega i lol ge i powonan Yabowaine elana ge tutunau gegewel i yogaagil hi na hi anan. Hi anan haba inoke bulin o hi kenuana to Giliyad oyana elal. ");
INSERT INTO mpx_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lan i gan mweluluga kekeisi, Leiban natunau yowau avaliyau ge natuliyau i nalol, inoke i lokaiyoni elal, ge i sikal i na wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo al ge i egon, i nawanawa Kenani kaiwena, inoke Yabowaine wana aneloseyau hi pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Sauga aneloseyau i kitel yaka i ba, “Yabowaine wana boda te.” Inoke panuwa o alana i tun Mahanaim. ");
INSERT INTO mpx_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo elopapatuna i patunal nihi houwa awonaa nihi na talina Iso elana labi Seil panuwa Idom. ");
INSERT INTO mpx_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I baek elal i ba, “Nuku baek no tonowak Iso elana nuku ba ola hiwe: Yakobo alona wana hanalau i ba, ‘Ya miminek Leiban elana sauga yayapona ana siga sauga ya. ");
INSERT INTO mpx_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","No bulumwakau, no donki, no sipi, no goti ge no totuwalali bolau ge yowau hi gan. Taliu, alou ge no awatauwan baaba ya ya patunawa nuwau alom wam yaliyaya nu aheyau.’” Inoke hi egon hi na Iso elana. ");
INSERT INTO mpx_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Sauga elopapatuna hi sikal Yakobo elana, inoke wana wasa hi pek hi ba, “Ha nok talim Iso elana wam baaba ha baunanik, he sauga ya iya iyoho i nenem elam, alonau ge ana hevalau ali gewi po handeled (400).” ");
INSERT INTO mpx_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo i lovakun nabi ge atena i bwanabwana. Yaka gamagalau bolo alonau hi notoyawa i walel boda labui i ginolil, avaliyau ge bwasumu sipi, goti, bulumwakau ge kamel. ");
INSERT INTO mpx_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He i nuwatu ola hiwe, “Ebo Iso ni nem haveyan ni ginol ge boda houwan ni lolil, inoke boda eluwana al iyoho bosowaina nihi lou.” ");
INSERT INTO mpx_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Inoke Yakobo i awanun i ba, “Tubu Abalahama wana Yabowaine, ge nam Aisake wana Yabowaine, no awanun nu hago. O Yehoba, valila u baem elau u ba, ‘Nu sikal wam panuwaa ge tutumwau elal, yaka na labewa ge bugul gegewena ni waisi eliyam.’ ");
INSERT INTO mpx_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nau wam totuwalali nige no waisi i gagan, yaa u muloluagau ge wam ginol gegewena i waisi eliyau. Sauga ya lou wewel Yolidani ya kalapanet-an, enonovau ya, iyai te no suki enawanawa. Yaa sauga ya ya sikalim, natuwau ge no bwasumu hi gewi, yaka alowau ama boda i labui. ");
INSERT INTO mpx_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ya awanun elam nu pwamwalau taliu Iso elana, kaiwena ya lovakun eba ni nem ni haveyan eliyama, ge gegewema ni pwamowasema alomeyau yowau ge wawayau. ");
INSERT INTO mpx_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","He valila u ba, ‘Na labewa bugul gegewena ni waisi eliyam, ge tubutubumwau na pagewel ali gewi ni ola gilesa talbwasiya, nige bosowaina gamagal etega ni vasilel.’” ");
INSERT INTO mpx_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakobo i kenuwa to, yaka lan i gan talina Iso ana mulolu enuna i hilel wana bwasumu gamwaliyaa, i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","goti yowau ali gewi tu handeled (200) ge bolau tuwenti (20), sipi yowau ali gewi tu handeled (200) ge bolau tuwenti, ");
INSERT INTO mpx_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kamel yowau ali gewi teti avaliyau ge natuliyau, bulumwakau yowau ali gewi poti (40) ge bolau elulutega (10), ge donki yowau ali gewi tuwenti (20) ge bolau elulutega (10). ");
INSERT INTO mpx_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Inoke bwasumu ali yawi maisena ge maisena i telel wana totuwalali nimaliyaa ge i baek elal i ba, “Nuku nohouwa awowa bwasumu ali yawi maisena ge maisena ali bwaga ni gan avaliyau elal.” ");
INSERT INTO mpx_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Inoke i baek wana totuwalali elana toto bwasumu ali yawi houwan i matahikagil i ba, “Nasi taliu Iso ni pwawawa kamwasaa, yaka ni nel eliyam ni ba, ‘Henala wam tonowak, ge ga u nana? Henala wana bwasumu gegewel hi nohouwa awomwa?’ ");
INSERT INTO mpx_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Yaka anana nu lahe nu ba, ‘Wam totuwalali Yakobo wana bwasumu te, i patunal owa wana tonowak Iso am mulolu. He iya iyoho i nenem emeya.’” ");
INSERT INTO mpx_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakobo i baek al wana totuwalali elal, bolo yawi eluwana, etonina ge yawi gegewel al hi matahikagil, i ba, “Sauga Iso nuku pwawa, yaka baaba maisena o nuku baunan elana. ");
INSERT INTO mpx_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ge bahi nuku nunuluwan te nuku ba, ‘Wam totuwalali Yakobo iyoho i nenem emeya.’” He Yakobo i ginol ola to, kaiwena i nuwatu ola hiwe, “Mulolu bolo ya na patunal houwa yaka Iso nuwana na pawaisi, inoke sauga naha petupatupa-agima, tabana nasi ni yaliyaya kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Inoke Yakobo wana mulolu i patunal houwa awonaa, yaka bulin o iya i kenuwa ga to abaholavi o elana. ");
INSERT INTO mpx_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bulin o elana Yakobo i lut, yaka lagonau hot eluwa ge lagonau al totuwalali eluwa, avaliyau ge natunau bolau elulutega maisena (11), i ahel, inoke wewel Yabok gamwana toto nige i mimilau hi kalapanet-an. ");
INSERT INTO mpx_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Sauga i pakalapanet-agil haba, yaka abwe i sikal i na i baek wana totuwalali elal wana bwasumu ge wana bugubugul gegewena hi bugulan ge heliya al wewel hi kalapanet-an. ");
INSERT INTO mpx_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yaa Yakobo maisena ya hi eguluwana to. Yaka tau etega i na alona hi lopepeunuk ge hi logalogasisi i na ana siga kelaubwa lan ni gan. ");
INSERT INTO mpx_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sauga tau o i atena nige bosowaina Yakobo ni gasisi lake, inoke i pihikana Yakobo nagilina puna ana tubwi elana, i pikiwan, ge mwena i mwakiwan. ");
INSERT INTO mpx_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yaka i baek Yakobo elana i ba, “U teleyau na egon, kaiwena iyaka lan i gagan te.” Yaa anana Yakobo i lahe i ba, “Nige na tetelewa ana siga nu ba muloluagau.” ");
INSERT INTO mpx_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yaka tau o i nel Yakobo elana i ba, “Alamwek?” Anana i lahe i ba, “Alau Yakobo.” ");
INSERT INTO mpx_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Inoke tau o i ba, “Alam nige al ni oola Yakobo, yaa alam ya tun Isileli, kaiwena alom Yabowaine ge alomwau gamagal ku logalogasisi ge u gasisi hot.” ");
INSERT INTO mpx_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo i baek elana i ba, “Alamwek? Alam ga nu lumen.” Yaa tau o i ba, “Bahi alau nu neneli!” Yaka abwe Yakobo i ba muloluan. ");
INSERT INTO mpx_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo i ba, “Yabowaine ya kite alou maninima ha petupatupa-an, yaa nige ya aaliga.” Inoke panuwa o alana i tun Peniyel. ");
INSERT INTO mpx_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Sabwelu i ha ga abwe Yakobo panuwa Peniyel i eguluwan, yaa i nonohomhom kaiwena mwena i mwakiwan. ");
INSERT INTO mpx_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Inoke saugena o ge i nem ana siga sauga ya, ebo boda Isileli bwasumu etega hi lol, nagilina puna bunumwina ewahilina nige hi aan, kaiwena tau o i pihikana Yakobo nagilina puna ewahilina elana yaka mwena i mwakiwan. ");
INSERT INTO mpx_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo matana i lihin talina i kite i nenem, alonau ge ana hevalau ali gewi po handeled, inoke natunau i walel hi na hinaliyau, Leya, Letiyeli ge totuwalali yowau labui elal. ");
INSERT INTO mpx_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Totuwalali yowau labui aloliyau ge natuliyau i teli pahouwa-agil, eliyaa Leya alonau ge natunau, yaka eliyaa al Letiyeli ge Yosepa. ");
INSERT INTO mpx_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Inoke iya i nohouwa awoliyaa. He iyoho i nanawa talina eliyana, yaka paseben i kukululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yaa Iso i tapalelu nem talina i holatomwa, yaka nimana i alipainan mwamwalinaa ge i nalo. Inoke ali toto labui hi kahikahin. ");
INSERT INTO mpx_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Yaka Iso matana i lihin yowau aloliyau ge natuliyau i kitel, inoke i nel i ba, “Henalau alomwau e?” Anana Yakobo i lahe i ba, “Wawayau bolo ya, Yabowaine i muloluagau inoke i pem nau wam totuwalali eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Yaka totuwalali yowau labui aloliyau ge natuliyau hi noha Iso elana ge hi kululu matanaa. ");
INSERT INTO mpx_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Yaka abwe Leya alonau ge natunau hi noha Iso elana ge hi kululu matanaa. Mowamowasena, Letiyeli alona ge Yosepa hi na hi ginol i ola al to. ");
INSERT INTO mpx_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Yaka Iso i nel Yakobo elana i ba, “Bwasumu ona ali yawi bolo ya pwawal, ali nuwatu ga i ola?” Anana Yakobo i lahe i ba, “Ya ginol ola o, nuwau owa no tonowak nu yaliyaya-agau.” ");
INSERT INTO mpx_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Iso i baek Yakobo elana i ba, “Taliu, iyaka bosowaiu. He owa wam bugul ni minewa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaa Yakobo i baek elana i ba, “Bahiwa! Ebo iyaka u yaliyaya-agau, he no mulolu toto ya pewa nu ahe. Sauga maninim ya kite i ola te Yabowaine maninina ya kikite, kaiwena alom wam yaliyaya u aheyau. ");
INSERT INTO mpx_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","He mulolu bolo ya patuna eliyam nu ahe, kaiwena Yabowaine i muloluagau he iyaka i olaolaek eliyau.” Inoke Yakobo i ba lawalawakik, yaka Iso mulolu o i ahe. ");
INSERT INTO mpx_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Inoke Iso i ba, “Ta egonan alowau komiu ta notoyawa.” ");
INSERT INTO mpx_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaa Yakobo i baek elana i ba, “No tonowak, u atena te wawayau nige hi gagasisi, ge ya nuwanuwatu bwasumu bolo natuliyau hi papaalahul kaiweliya. Ebo bwasumu na patotoel ge nihi nonabinabi lan maisena, he nasi gegewel nihi aliga. ");
INSERT INTO mpx_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","U nohouwa, yaka abwe nau kekeisi kekeisi na nawanawa, na golugoluwa wawayau ge bwasumu wali nawanawa elana. Yaka abwe naha nowa labi Seil elana.” ");
INSERT INTO mpx_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Inoke Iso i baek elana i ba, “He o hevalau enuna na telel eliyam, yaka abwe nihi ahemiu ge nuku nem.” Anana Yakobo i lahe i ba, “Ni ola! Tonowak, nu yaliyaya-agau ge ta ginol ni ola no nuwatu.” ");
INSERT INTO mpx_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Inoke lan o Iso i nawanawa i sisikal labi Seil. ");
INSERT INTO mpx_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaa Yakobo i na panuwa Sukot inoke wana limi etega i tal, ge gonu enuna i ginolil wana bwasumu kaiweliya. Heiya te kaiwena ge panuwa o alana hi tun Sukot. ");
INSERT INTO mpx_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaka abwe i na panuwa Sekemi labi Kenani elana. Inoke alona wana molu i sikalem Mesopoteimiya i na i vin labi toto valila i egoegona. Yaka i holaviya panuwa Sekemi awonaa. ");
INSERT INTO mpx_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Inoke bilibili toto wana epanapana i pamilila i pwamolaa Heimo natunau eliyalil, molana mani silba elulu bwagabwaga (100). He Heimo natuna etega alana Sekemi. ");
INSERT INTO mpx_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Inoke Yakobo abapowon etega i pamilila to labi o elana, yaka alana i tun “Yabowaine, iya Isileli wana Yabowaine.” ");
INSERT INTO mpx_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lan etega Daina, Yakobo ge Leya natuliya yovana, i tagil i na labi o yowauiliyau i kitel. ");
INSERT INTO mpx_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Heimo gagama Hivi, iya labi o ana tonowak bwabwatana, natuna tauina alana Sekemi. Sauga Sekemi Daina i kite, inoke i lib ge i loneganega-an. ");
INSERT INTO mpx_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekemi Yakobo natuna Daina i hebabale ge i nunuwana-an, yaka baaba luluvena i baubaunan elana tage nuwana ni ba ahe. ");
INSERT INTO mpx_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yaka abwe i baek tamana Heimo elana i ba, “Yova o nu ahe lagou.” ");
INSERT INTO mpx_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sauga Yakobo wasa i hago Sekemi Daina i lib ge i loneganega-an, he sauga o elana natunau bolau heliya iyoho wana bwasumu hi matamatahikagil uleya. Inoke i anagugumwan nige bugul etega i giginol, i matamatan nihi sikal elana. ");
INSERT INTO mpx_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Yaka Sekemi tamana Heimo i na alona Yakobo nihi liwaliwan, ge Sekemi al i toulil. ");
INSERT INTO mpx_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","He Yakobo natunau nuliya wasana iyaka hi hago, ge hi vin, hi sikalem uleya. Nuwaliya i nak ge hi huga nabi, kaiwena ginol toto Sekemi i ginol Yakobo natuna elana, iya ginol pulupuluwawena hot boda Isileli mataliyaa, ginol ololana bahi gamagalau nihi giginol. ");
INSERT INTO mpx_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Heimo i baek elal i ba, “Natu Sekemi natumiu meluyovana i hebabale. He ya awanun eliyamiu, nuku talamwan elana ge ni alolonan. ");
INSERT INTO mpx_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Inoke alomeyau komiu ta alolon nem nowa. Natumiyau yowau nuku talamwagil alomeyau naha alolon, ge natumeyau yowau nuku ahel alomiyau nuku alolon. ");
INSERT INTO mpx_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Inoke alomeyau komiu ta mina. Wama panuwa labena gegewena i mwapwela eliyamiu, inoke nuku minaa, nuku nem nowa-an, ge enuna nuku pwamola wami bilibili.” ");
INSERT INTO mpx_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Yaka Sekemi i baek Daina tamana ge nunau elal i ba, “No nuwatu nuku yaliyaya-an, yaka hauna gun nuku awanuni, nasi na pewa eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bwagana yova molana ge ami mulolu ali bwata ga nuku teli ola, hauna gun nuku awanuni, nasi na pewa. Iyai te yova nuku talamwan ge na alolonan.” ");
INSERT INTO mpx_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakobo natunau hi nuwanuwatu ginol nanakina kaiwena, toto Sekemi i ginola nuliya elana. Inoke alona wali kakawi hi baek Sekemi ge tamana Heimo elal, ");
INSERT INTO mpx_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","hi ba, “Nige bosowaina numa naha talamwan tau etega elana, toto nige tuwana buhuna kunisina hi gogotomwa yoho. Ebo naha ginol ola o, nasi naha puluwawi nabi. ");
INSERT INTO mpx_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nige wami awanun naha tatalamwi ana siga ebo wami bolau gegewel tuwaliya buhuna kunisina nihi gotomwa yoho ge nuku ola ama. ");
INSERT INTO mpx_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Yaka abwe natumeyau yowau naha talamwagil alomiyau nuku alolon, ge natumiyau yowau naha ahel alomeyau naha alolon. Yaka alomeyau komiu ta mina ala boda maisena. ");
INSERT INTO mpx_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yaa ebo nige wama baaba nuku hahago ge gotomwa yoho paganina nuku giginol, he numa ha aahe ha eegon.” ");
INSERT INTO mpx_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Inoke Heimo alona ge natuna Sekemi nuwatu o hi awa wawaisi-an. ");
INSERT INTO mpx_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Yaka Sekemi etimwawa i na i ginol ola wali baaba, kaiwena Yakobo natuna meluyovana i hebabale hoti. He Sekemi ana awatauwan i bwata tamana wana limi ana heniheni ge tutunau gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Yaka alona ge tamana hi nok hi na abamimigogowa panuwa ana gana ana abauluulutuka. Inoke hi liwaliwan wali panuwa bolauiliyau elal, ");
INSERT INTO mpx_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","hi ba, “Bolau ya heliya gamagalau waiwaisal hi nununuwana. He nihi minaa wala panuwaa ge nihi nem nowa-an. Wala labi i bwata heliya ge kila bosowaila ya. Natuliyau yowau ta ahel ta alolonagil, ge natulau yowau ta talamwagil nihi alolonagil. ");
INSERT INTO mpx_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Yaa nige nihi tatalam avalau ta mimina ala boda maisena, ana siga ebo kila bolau gegewela gogotomwa yoho paganina ta ginol ge ta ola heliya. ");
INSERT INTO mpx_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ta ginol ola to, yaka wali bwasumu ge wali gogomwau gegewena kila wala bugul. He wali nuwatu ta talamwi, yaka avalau ta mipamaisena.” ");
INSERT INTO mpx_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Inoke bolau bolo abamimigogowa panuwa ana gana ana abauluulutuka, gegewel Heimo ge natuna Sekemi wali baaba hi awa wawaisi-an. Yaka panuwa o bolauiliyau gegewel tuwaliya buhuna kunisina hi gotomwa yoho. ");
INSERT INTO mpx_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Lan eton i mowasi, bolau ali gotomwa yoho lomwanina iyaho ya ge nige hi nunuwatu tage abwe nak etega ni gan. Inoke Yakobo natunau eluwa Simiyon ge Libai, heliya Daina nunau hot, wali elohaveyan kilepana hi ahel hi na hi ulutuk panuwa gamwanaa, yaka bolau gegewel hi lolil habal, ");
INSERT INTO mpx_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","aloliyau Heimo ge natuna Sekemi. Yaka Daina hi ahe Sekemi wana limiya ge hi egon. ");
INSERT INTO mpx_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yaka abwe Yakobo natunau bolau enuna hi na bugubugul hi aheliya toyaomal tuwaliyaa, ge panuwa o ana gogomwau gegewel hi oel, Sekemi wana ginol nanakina nuliya elana lahena. ");
INSERT INTO mpx_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","He wali sipi, wali bulumwakau, ge wali donki, bolo panuwa gamwanaa o ebo tolinaa, hi bugulan. ");
INSERT INTO mpx_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","I ola al wali wasawasa buguliliyau gegewel, ge yowau gegewel avaliyau ge wawayau, bugul gegewel limi gamwaliyaa, hi oel. ");
INSERT INTO mpx_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaka abwe Yakobo i baek Simiyon ge Libai elal i ba, “Komiu o pulowan iyaka ku ginol. Alau iyaka ku apapanak-an, Kenani ge Pelisi ge labi ya gamagaliliyau gegewel nihi awa bwaibwaikikin-agau. He kila nige ta gegewi, inoke ebo ali boda nihi pamaisena ge nihi haveyan eliyala, nasi alowau ge o heniheni gegewela nihi pwamowasela.” ");
INSERT INTO mpx_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yaa alona wali huga anana hi lahe hi ba, “Age waisi o, ebo numa ni ginol olaan ni ola iya tololoneganega?” ");
INSERT INTO mpx_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Yabowaine i baek Yakobo elana i ba, “U na panuwa Betel ge nu minaa to, yaka abapowon etega nu ginol panuwa o elana ge nu tapwaloloem elau, nau Yabowaine valila ya masala eliyam sauga toto u lou talim Iso elana.” ");
INSERT INTO mpx_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Inoke Yakobo i baek wana limi ana heniheni avaliyau gamagalau gegewel bolo alonau elal, i ba, “Panuwa getoga wali yabowaine gogoginol bolo iyoho eliyamiu nuku aliyohil. Yaka nuku abubunimiu nuku yanayana tapwalolo kaiwena, ge kaliko waiwaisana nuku galoil. ");
INSERT INTO mpx_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Panuwa ya ta eguluwan ta na panuwa Betel, yaka abapowon etega na ginol ge ta tapwalolo Yabowaine elana, iya i labeyau o pulowan ana sauga elana ge labi gegewena ya noek alou ya.” ");
INSERT INTO mpx_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Yaka panuwa getoga wali yabowaine gogoginol bolo iyoho elal gegewel, ginebi ge heliya tanaliya ana komwakomwa, hi bugul pek Yakobo elana ge i yamwil ebwakil bwabwatana gabulanaa panuwa Sekemi elana. ");
INSERT INTO mpx_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Inoke Sekemi hi eguluwan, ge sauga hi nawanawa, yaka Yabowaine lovakun bwabwatana hot i ginol panuwa bolo labeliyaa gamagaliliyau elal, inoke nige haveyan kaiwena hi tatauliulil-agil. ");
INSERT INTO mpx_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Inoke Yakobo alonau ge wana boda gegewel hi na hi vin panuwa Lus elana (he alana al te Betel), iyoho labi Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Inoke pat i pahe abapowon i ginola to, yaka panuwa o alana i tun “Betel ana Yabowaine,” kaiwena panuwa o elana te valila Yabowaine i masala elana sauga toto i lou talina elana. ");
INSERT INTO mpx_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola, Lebeka wana totuwalali yovana toto ana tomatahikan, i aligaa to, inoke tuwana hi yamwiya abwakil bwabwatana alana ouk gabulanaa Betel labena yavanaa. Inoke abwakil o alana hi tun “Kahin Abwakilina.” ");
INSERT INTO mpx_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo iyoho Betel i sikalem Mesopoteimiya, inoke Yabowaine i masal al elana ge i ba muloluan. ");
INSERT INTO mpx_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","I baek elana i ba, “Alam Yakobo, yaa alam nige al ni oola Yakobo. Alam ya tun Isileli.” ");
INSERT INTO mpx_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yaka i ba vevehe al i ba, “Nau Yabowaine Togasisi Hot. Tubutubumwau na pagewel, yaka nihi tabwa boda bwabwatana ali un tomaha ge tomaha, ge kin ona nihi masalem owa eliyam. ");
INSERT INTO mpx_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","He bilibili toto ya pek Abalahama ge Aisake elal, ya pewa elam, ge na pek al tubutubumwau elal.” ");
INSERT INTO mpx_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Yabowaine i baaba haba eliyana, yaka abwe i eguluwai. ");
INSERT INTO mpx_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Inoke Yakobo pat yayapona etega i pamilila to labi toto Yabowaine i baaba eliyana. Yaka oine i hol pwatanaa wana mulolu Yabowaine elana, ge enonu al i hol pat pwatanaa i pwabwabwalena. ");
INSERT INTO mpx_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Inoke Yakobo panuwa o alana i tun Betel, kaiwena labi o elana Yabowaine i baaba eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yaka Yakobo alonau ge wana boda Betel hi eguluwan ge hi nawanawa al. Ali bwaga kekeisi i gan awan Epalat elana, he Letiyeli wana ab ana sauga iyaka i pwawa, yaa wana ab i pulowan hot. ");
INSERT INTO mpx_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Iya iyoho ya i logalogasisi, yaka topapaab i baek elana i ba, “Bahi lovakun, natum melutauina etega al te.” ");
INSERT INTO mpx_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mulaa abwe Letiyeli yawalina ni yana yoho ge ni aliga, yaka natuna alana i tun Benoni. Yaa Yakobo natuna alana i tun Beniyamina. ");
INSERT INTO mpx_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Inoke Letiyeli i aliga ge tuwana hi teliya to awan Epalat ana kamwasa bebenaa. (He Epalat Bedeliyema alana houhouwena.) ");
INSERT INTO mpx_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaka Yakobo pat etega i pamilil Letiyeli ana salai elana. He pat o iya Letiyeli ana salai ana etotohi ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Inoke Isileli, alana al hi ba Yakobo, labi o i eguluwan ge i nawanawa al. Panuwa Migdal Edel i tataluwan ge i novevehe kekeisi al, yaka wana epanapana i pamilila to. ");
INSERT INTO mpx_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isileli iya iyoho ya labi o elana, yaka Lubeni i na alona Bilha hi kenu toyawa, iya tamana lagonau al etegana. Yaka Isileli abwe Lubeni wana ginol o wasana i hago. Yakobo natunau bolau ali gewi elulutega eluwa. ");
INSERT INTO mpx_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bolo Leya i abil, Lubeni iya gamaun, loena Simiyon, abwe Libai, Yuda, Isaka, ge Sebuloni. ");
INSERT INTO mpx_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bolo Letiyeli i abil, Yosepa, ge Beniyamina. ");
INSERT INTO mpx_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bolo Letiyeli wana totuwalali loloyowanina Bilha i abil, Dani ge Napitalai. ");
INSERT INTO mpx_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Bolo Leya wana totuwalali loloyowanina Silpa i abil, Gada ge Aseli. He bolau bolo ya heliya Yakobo natunau hi abiliek Mesopoteimiya. ");
INSERT INTO mpx_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo i na tamana Aisake elana awan Mamele Kiliyat-Aba labenaa, (he Kiliyat-Aba alana al te Hebiloni). Panuwa o valila Abalahama i miminaa, yaka abwe Aisake al i na i minaa. ");
INSERT INTO mpx_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisake yawalina ana baliman 180 i pwawa, ");
INSERT INTO mpx_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ge i liki bubun, yaka wana yana i yana yoho ge i yaomal, i na tubunau bolo hi aliga houwa elal. Inoke natunau Iso ge Yakobo tuwana hi teli salaiya. ");
INSERT INTO mpx_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso (alana labuina al te Idom) alonau natunau liwaniliya i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso panuwa Kenani yowauiliyau i alolonagil: Eda, iya Elon gagama Hiti natuna, ge Oholibama, iya Anahi natuna, he tubuna te Sibiyon gagama Hivi. ");
INSERT INTO mpx_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","I ola al Basimata i alolonan, iya Isimel natuna ge Nebaiyot nuna. ");
INSERT INTO mpx_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Eda i ab natuna Elipas, Basimata i ab natuna Luwel, ");
INSERT INTO mpx_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ge Oholibama i ab natunau Yeus, Yalam ge Kola. Bolau ya Iso natunau, hi abiliek labi Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Iso ge Yakobo nige bosowailiya nihi mipamaisena, kaiwena wali bwasumu hi gewi nabi, ge wali abaanan nige i bwabwata. Inoke Iso talina i miluwai i na labi etega al. He lagonau ge natunau bolau ge yowau i ahel alonau, ginebi wana bwasumu gegewel ge wana gogomwau gegewena bolo i pwawal Kenani elana. ");
INSERT INTO mpx_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Inoke Iso (alana labuina al te Idom) i na i minaa labi Seil oyana elal. ");
INSERT INTO mpx_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso, iya boda Idom tubutubuliya, i miminaa to labi Seil oyana elal, he natunau ge tubutubunau liwaniliya i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso natunau alaliya i ola hiwe: Elipas, Iso lagona Eda natuna, ge Luwel, Iso lagona Basimata natuna. ");
INSERT INTO mpx_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","He Elipas natunau bolau alaliya i ola hiwe: Teman, Omal, Sepo, Gatam ge Kenasi. ");
INSERT INTO mpx_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipas lagona al i gan alana Timna, i ab natuna Amaleki. Bolo ya heliya Iso lagona Eda tubunau. ");
INSERT INTO mpx_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Luwel natunau bolau alaliya i ola hiwe: Nahat, Selaa, Sama, ge Misa. Bolau ya Iso lagona Basimata tubunau. ");
INSERT INTO mpx_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso lagona Oholibama, Anahi natuna ge Sibiyon tubuna, natunau bolau eton i abil, Yeus, Yolam ge Kola. ");
INSERT INTO mpx_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iso natunau ge tubutubunau hi tabwa un tomaha tomaha ali tonowakau. Iso natuna gamaun Elipas natunau hi tabwa un bolo ya ali tonowakau: Teman, Omal, Sepo, Kenasi, ");
INSERT INTO mpx_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kola, Gatam ge Amaleki. Un bolo o hi minaa labi Idom ge hi masalem Elipas elana, iya Iso ge Eda natuliya. ");
INSERT INTO mpx_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso natuna Luwel natunau hi tabwa un bolo ya ali tonowakau: Nahat, Selaa, Sama, ge Misa. Un bolo o hi minaa labi Idom ge hi masalem Luwel elana, iya Iso ge Basimata natuliya. ");
INSERT INTO mpx_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso ge Oholibama natuliyau hi tabwa un bolo ya ali tonowakau: Yeus, Yalam ge Kola. Un bolo o hi masalem Iso lagona Oholibama elana, iya Anahi natuna. ");
INSERT INTO mpx_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","He Iso (alana labuina al te Idom) tubutubunau ge un bolo hi masalem eliyana i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seil gagama Holi natunau, heliya labi Idom towohiliyau, alaliya i ola hiwe: Lotan, Sobal, Sibiyon, Anahi, ");
INSERT INTO mpx_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Esa ge Disan. Bolau o heliya boda Holi ali un tonowakiliyau labi Idom elana. ");
INSERT INTO mpx_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan natunau bolau alaliya i ola hiwe: Holi ge Homam. He Lotan nuna alana Timna. ");
INSERT INTO mpx_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal natunau bolau alaliya i ola hiwe: Alvan, Manahat, Ebal, Sepo ge Onam. ");
INSERT INTO mpx_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiyon natunau bolau alaliya i ola hiwe: Aiya ge Anahi. He Anahi iya te wewel bwanapitpit kalakalasina i pwawa uleya labi kekevana elana, sauga toto tamana wana donki i matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anahi natuna tauina alana Dison ge natuna yovana te Oholibama. ");
INSERT INTO mpx_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison natunau bolau alaliya i ola hiwe: Hemdan, Esban, Itlam ge Kelan. ");
INSERT INTO mpx_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esa natunau bolau alaliya i ola hiwe: Bilhan, Savan, ge Akan. ");
INSERT INTO mpx_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan natunau bolau alaliya i ola hiwe: Us ge Alan. ");
INSERT INTO mpx_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","He boda Holi ali un tonowakiliyau alaliya i ola hiwe: Lotan, Sobal, Sibiyon, Anahi, ");
INSERT INTO mpx_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Esa ge Disan. He Holi ali un tonowakiliyau alaliya i ola to, hi miminek tomaha tomaha wali labi ona elal labi Seil elana. ");
INSERT INTO mpx_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mulaa abwe Isileli wali kin i gan, kin bolo ya hi tologugui labi Idom elana. ");
INSERT INTO mpx_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela Beo natuna, i tabwa kin panuwa Idom elana. Iya i miminaa Dinhaba. ");
INSERT INTO mpx_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Sauga Bela i yaomal, inoke abana Yobab Selaa natuna i ahe i tabwa kin, he wana panuwa Bosela. ");
INSERT INTO mpx_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Sauga Yobab i yaomal, inoke abana Husam i ahe i tabwa kin. He iya i neem Teman wali labiya. ");
INSERT INTO mpx_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Sauga Husam i yaomal, inoke abana Heidad Bedad natuna i ahe i tabwa kin. Iya Midiyani i pakokovel labi Mowabi elana. He i miminaa Avit. ");
INSERT INTO mpx_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Sauga Heidad i yaomal, inoke abana Samla i ahe i tabwa kin, he wana panuwa Masileka. ");
INSERT INTO mpx_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Sauga Samla i yaomal, inoke abana Saul i ahe i tabwa kin. He wana panuwa Lehobot toto wewel labenaa. ");
INSERT INTO mpx_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauga Saul i yaomal, inoke abana Bal-hanan Akbo natuna i ahe i tabwa kin. ");
INSERT INTO mpx_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Sauga Bal-hanan Akbo natuna i yaomal, inoke abana Heidad i ahe i tabwa kin. Heidad i miminaa panuwa Pau, lagona alana Mehetabel, Matled natuna ge Mesahab tubuna. ");
INSERT INTO mpx_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iso tubutubunau hi tabwa un tomaha tomaha ali tonowakau ge hi miminek tomaha tomaha wali panuwa ona elal, alaliya i ola hiwe: Timna, Alva, Yeteti, ");
INSERT INTO mpx_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Elaa, Pinon, ");
INSERT INTO mpx_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenasi, Teman, Mibsa, ");
INSERT INTO mpx_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiyel ge Ilam. He Idom ali un tonowakiliyau alaliya i ola to, hi miminek tomaha tomaha wali labi ona elal. He Iso, iya Idom tubuliya houhouwena hot, tubutubunau liwaniliya i ola to. ");
INSERT INTO mpx_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo i miminaa Kenani, labi toto valila tamana Aisake i miminaa. ");
INSERT INTO mpx_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","He Yakobo alonau ge natunau liwaniliya i ola hiwe. Natuna Yosepa iya hevalina ya, wana baliman sebentin, iya sipi ge goti ana tomatahikan alonau ge talinau bolo tamana lagonau Bilha ge Silpa natuliyau. He talinau wali ginol nanakina wasana ni baubaunan tamaliya elana. ");
INSERT INTO mpx_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakobo alana etega al Isileli, wana nunuwana Yosepa elana wana nunuwana natunau bolau gegewel al elal i bwata lake, kaiwena wana sauga liki elana te Yosepa hi ab. Ana holahola yayapona etega i hel, matana i waisi ge nimana i yapu. ");
INSERT INTO mpx_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Talinau hi kite tamaliya wana nunuwana Yosepa elana wana nunuwana heliya elal i bwata lake, inoke Yosepa hi pihigelgel-an yaka nige nunuwana ana baaba hi baubaunan elana. ");
INSERT INTO mpx_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Sauga etega Yosepa i kenonou, inoke ana kenonou i baunan talinau elal, yaka abwe hi pihigelgel nabi elana. ");
INSERT INTO mpx_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He i baek elal i ba, “Ku laegan ge o kenonou na baunan nuku hago. ");
INSERT INTO mpx_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tage kilau gegewela iyoho witi ta tomwatomwa ge ta kinkin eyowaa. Yaka nau o kin i lut ge i talmilil pasapu, ge komiu ami kin ona o kin hi milil painan ge hi kululuek elana.” ");
INSERT INTO mpx_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yaka talinau hi baek elana hi ba, “Age u nuwatu nu tabwa wama kin ge nu logugui-agima?” He Yosepa ana kenonou i baunan talinau elal i ola to, inoke abwe hi pihigelgel nabi elana. ");
INSERT INTO mpx_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yaka kenonou etega al i kenonou-an ge i baunan talinau elal i ba, “Ku laegan, kenonou etega al ya kenonou-an i ola hiwe. Tage sabwelu, weikena ge putum ali gewi elulutega maisena hi kululuem elau.” ");
INSERT INTO mpx_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ana kenonou i baunan al tamana elana, yaka tamana i ba lalaan i ba, “Hauna kenonou u kenonou-an ei? Age u nuwatu alowau hinam ge talimwau naha nowa ge naha kululu elam?” ");
INSERT INTO mpx_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yaka talinau hi lamwapulowan-an, yaa tamana kenonou o i nuwahikan atenaa ge i nuwanuwatu kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sauga etega Yosepa talinau tamaliya wana sipi ge goti hi ahel hi na panuwa Sekemi ge hi matahikagil hi anan. ");
INSERT INTO mpx_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Inoke tamaliya Isileli i baek Yosepa elana i ba, “Talimwau heliya iyoho panuwa Sekemi sipi ge goti hi matahikagil hi anan. He nuwau na patunawa ge nu na elal.” Inoke Yosepa i talam i ba, “I waisi, na nok.” ");
INSERT INTO mpx_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yaka tamana i baek elana i ba, “Nu nok nu na nu kite ebo talimwau hi mibubun ge ebo sipi ge goti hi waisi, inoke nu sikalim ge no wasa nu pem.” Inoke Yakobo Yosepa i patuna i egon, yaka labi o Hebiloni Abwabwina i eguluwan. Sauga i na i vin panuwa Sekemi, ");
INSERT INTO mpx_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","inoke i nononawanawa ya labi o elana. Yaka abwe tau etega Yosepa i pwawa, ge i neli i ba, “Hauna gun u loloyaan e?” ");
INSERT INTO mpx_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Anana Yosepa i lahe i ba, “Taliwau ya loloyaagil, heliya wali sipi ge goti hi matahikagil. He tab bosowaina ge no wasa nu pem heliya ga?” ");
INSERT INTO mpx_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Anana i lahe i ba, “Iyaka hi egon. Ya hago hi ba, ‘Ta egon ta na panuwa Dotan.’” Inoke Yosepa i nouliulil talinau eliyaa i na i pwawaliya panuwa Dotan. ");
INSERT INTO mpx_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Sauga talinau mataliya i nok hi kite i nenem laha, inoke mulaa abwe i vin elal, heliya iyaka wali nuwatu hi pamaisena te nihi tagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","He hi pebaaba-agil hi ba, “Ku kite, tokenokenonou iya huwo i nenem o! ");
INSERT INTO mpx_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ehei, ta tagapaaliga, yaka tuwana ta alipaloek wewel kenken bolo ya etega gamwanaa. Inoke tamala wana wasa ta pek te iyaka bwasumu sosokana etega i an. Yaka abwe ta kite tab ana kenonou nihi tabwa tunahot.” ");
INSERT INTO mpx_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Wali baaba o Lubeni i hago inoke iya nuwana Yosepa ni pwamwal, yaka i ba, “Bahi yawalina ta pwapwamowasi. ");
INSERT INTO mpx_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","He bahi ta tatagapaaliga. Ta alipaloek ya te wewel kenken toto ya gamwanaa labi kekevana ya elana, yaa bahi tuwana ta papalomwan.” He Lubeni i ba ola o nuwana Yosepa ni pwamwalem elal ge ni ahe ni pasikal tamaliya elana. ");
INSERT INTO mpx_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Sauga Yosepa i na i vin talinau elal, inoke hi lib ge ana holahola yayapona matana waiwaisana hi kukuleke yoho. ");
INSERT INTO mpx_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Inoke Yosepa hi ahe hi na hi alipaloek wewel kenken etega enoenovana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Hi alipalo wewel kenken gamwanaa i mowasi, yaka hi na hi misiyo ge hi anan. Hi anan ee, abwe mataliya hi lihin boda Isimel hi kitel hi nenem avaliyau ge wali kamel. He aanan amnana ana epawaisi, bugul bwaleliya waiwaisana ge enonu meya hi usanil, hi neem labi Giliyad hi nana panuwa Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Inoke Yuda i baek talinau elal i ba, “Binimala ebo talila ta lol ge wana yaomal wasana ta sume, hauna waisi abwe ta pwawa? ");
INSERT INTO mpx_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","He ta palian boda Isimel elal, yaka bahi tuwana ta papalomwan. Kaiwena iya talila hot, tuwala ge saliyala maisena ya.” Inoke wana baaba talinau hi talamwi. ");
INSERT INTO mpx_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Sauga panuwa Midiyani tolobisnes hi vin elal, yaka Yosepa talinau hi na hi momol heyanem wewel kenken ana gola, ge hi palian boda Isimel elal molana mani silba ana gewi tuwenti. Inoke heliya Yosepa hi ahe ge hi na panuwa Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Yaka abwe Lubeni i sikal i na matana i lau wewel kenken gamwanaa nige Yosepa i kikite, yaka nuwana i nak nabi ge ana kama i kukuleli. ");
INSERT INTO mpx_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Inoke i sikal i na talinau elal ge i ba, “Geman Yosepa nige i gagan to wewel kenken gamwanaa o. He nasi ga na ola e?” ");
INSERT INTO mpx_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Inoke Yosepa talinau goti etega hi lol ge saliyana hi ahe ana holahola hi pasasaliya. ");
INSERT INTO mpx_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yaka hi ahe hi na tamaliya elana ge hi ba, “Holahola yayapona ya ha pwawa. He u hile tab ana awa i ola natum ana holahola?” ");
INSERT INTO mpx_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tamaliya holahola o i kite yaka i ba, “Ee, natu ana holahola te. Bwasumu sosokana etegana iyaka i an. Eu, natu geb! Bwasumu i alatomwatomwa-an!” ");
INSERT INTO mpx_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yaka wana nuwanak kaiwena ana kaliko i kukuleli, kaliko toto bwasumu pupunona elana hi ginoliya i galoi, ge natuna baena i kahikahin sauga yayapona. ");
INSERT INTO mpx_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natunau bolau ge yowau gegewel hi na elana tage nuwana nihi pawaisi, yaa i towa nige nuwana i oola. Inoke i ba, “Na kahikahin ya, ana siga na kahin aliga ge na na Tuma alou ge natu.” Inoke natuna baena i mimi kahikahin. ");
INSERT INTO mpx_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","He Midiyani Yosepa hi ahe hi pwatanik Itipita ge hi palian Potipa elana. Potipa iya Itipita wali kin wana totuwalali bwabwatana etega, wana limi ana tomatahikan wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Saugena o elana, Yuda talinau i eguluwagil i na i miminaa tau etega elana alana Hila, iya panuwa Adulam gamagalina. ");
INSERT INTO mpx_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yaka Kenani tauina etega alana Suwa natuna yovana i pwawa to ge i alolonan, yaka alona hi kenukenu. ");
INSERT INTO mpx_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Inoke i liyan ge i ab natuliya melutauina, yaka alana Yuda i tun El. ");
INSERT INTO mpx_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yaka abwe i liyan al, ge i ab natuna melutauina, yaka alana i tun Onan. ");
INSERT INTO mpx_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Yaka i liyan al ge i ab paetonina natuna melutauina, yaka alana i tun Sila. He Yuda alona ge lagona heliya iyoho panuwa Kesib te wawaya o hi ab. ");
INSERT INTO mpx_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Sauga natuna gamaun El i bwata, inoke Yuda yova etega i hile El lagona, alana Tama. ");
INSERT INTO mpx_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yaa El wana pagan i nak Yehoba matanaa, inoke i lol ge i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yaka Yuda i baek Onan elana i ba, “Talim iyaka i aliga nige natunau. Inoke talim abuabulina nu alolonan yaka alom nuku kenukenu, inoke wawayau nu pamasalil talim alana nihi milili ge aena pipihina ni gan. He wala pagan ana logugui i ola to.” ");
INSERT INTO mpx_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Yaa Onan i atena te ebo wawayau ni pamasalil, heliya nige alana nihi mimilili. Inoke sauga ebo alona talina abuabulina hi kenu toyawa, yaka ana puhu ni pasulu yoho bilibiliya. He nige nuwana i oola wawayau ni pamasalil talina kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wana pagan toto o i nak Yehoba matanaa, inoke iya al i lol ge i aliga. ");
INSERT INTO mpx_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yaka abwe Yuda i baek yawana Tama elana i ba, “U sikal u na tamwam wana limiya ge nu miabuabul ga ana siga natu Sila ni bwata.” He i ba ola o, kaiwena i nuwatu eba Sila al ge ni aliga ni ola talinau. Inoke Tama i sikal i na i miminaa tamana wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sauga kekeisi iyapu abwe Yuda lagona, Suwa natuna, i yaomal. Sauga Yuda wana nuwanak i pwamowasi, inoke alona wana heliyam Hila, Adulam gamagalina, hi na panuwa Timna Yuda wana sipi pupunoliya ana totomwatomwa ni kitel. ");
INSERT INTO mpx_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Yaka Tama wana wasa hi pek hi ba, “Yawam i nenem i nana panuwa Timna wana sipi pupunoliya ni tomwatomwa.” ");
INSERT INTO mpx_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Inoke abuabul kalikona i ahek yoho tuwanaa, yaka kaliko getoga i galoi ge kama etega i ahe maninina i kaus, yaka nige bosowaina ana awa nihi eunaan. Inoke i na i misiyo awan Enaim ana abauluulutuk elana kamwasa toto i na panuwa Timna. I ginol ola o, kaiwena i atena bwagana Sila iyaka i bwata, yaa tamana Yuda nige Tama i pepek alona hi aalolon. ");
INSERT INTO mpx_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Sauga Yuda i pulivin ge i kite, wana nuwatu iya yova toganawal mani kaiwena, kaiwena maninina i kaus. ");
INSERT INTO mpx_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Inoke i nopanet i na yova elana kamwasa bebenaa ge i ba, “Nuwau alou owa ta kenu.” Yaa Yuda nige i aatena te age yawana. Inoke anana yova i lahe i ba, “Ebo alou owa ta kenu, hauna gun nu pem molau?” ");
INSERT INTO mpx_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Anana Yuda i lahe i ba, “Goti natuna etega na ahe no bwasumu ali yawi gamwaliyaa, ge na patuna eliyam.” Inoke yova i ba, “Bugul etega nu pem ga na kukuhikan, inoke ni paatimatuwa-agau te abwe goti natuna u papatunam. Yaka abwe wam bugul na pasikal elam.” ");
INSERT INTO mpx_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yaka anana Yuda i lahe i ba, “Binimala hauna na pewa ge ni paatimatuwa-agiwa?” Inoke anana i lahe i ba, “Wam etotohi ana eawaginol ginebi ana sisiu, ge wam suki nimwamwa ei.” Inoke i bugul pek elana ge alona hi kenu, yaka abwe yova i liyan. ");
INSERT INTO mpx_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Sauga Tama i sikal limiya, yaka maninina ana ekaukaus i ahe yoho, ge ana kaliko i loho abuabul kalikona i galoi pasikal al. ");
INSERT INTO mpx_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yaka abwe Yuda goti natuna etega i pek wana heliyam Hila Adulam gamagalina elana, ge i patuna ni na ni pek Tama elana, inoke wana etotohi ana eawaginol ginebi ana sisiu ge wana suki ni ahel pasikalil. Yaa Hila nige yova i pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Inoke i nel Enaim bolauiliyau enuna elal i ba, “Yova toganawal mani kaiwena, toto i misiyowa kamwasa bebenaa panuwa ya elana, iya ga?” Yaka anana hi lahe hi ba, “Nige sauga etega yova ololana o i miminaa te.” ");
INSERT INTO mpx_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Inoke i sikal i na Yuda elana ge i ba, “Yova o nige ya pwapwawa. He panuwa o bolauiliyau enuna hi baem eliyau hi ba, ‘Nige sauga etega yova toganawal mani kaiwena i miminaa te.’” ");
INSERT INTO mpx_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Inoke Yuda i baek elana i ba, “Ni ola, no bugul ni minaa elana. Bahi ta sisikal, eba gamagalau nihi talawasi-agila. He no bateli ya paolaolaek te goti natuna ya patuna elana, yaa sauga u nok, yaka nige u pwapwawa.” ");
INSERT INTO mpx_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Weikena eton i mowasi abwe Yuda wana wasa hi pek hi ba, “Yawam Tama i gaganawal, he iyaka i liyan.” Inoke Yuda i huga ge i ba, “Ku na ku ahe nuku pwatanik boda mataliyaa, inoke nuku ton paaliga.” ");
INSERT INTO mpx_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sauga hi na hi ahe ge nihi pwatanik boda mataliyaa, inoke baaba i patuna yawana Yuda elana, i ba, “Tau toto wana etotohi ana eawaginol ginebi ana sisiu ge wana suki ei, iya te i paliyanagau. He u eunaan bubun, henala ge wana bugul.” ");
INSERT INTO mpx_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda bugul bolo o i eunaagil inoke i atena te iya wana bugul, yaka i ba, “He nau te ya gegi, iya nigeya, kaiwena nige ya pepek alona ge natu Sila hi aalolon.” Inoke i ahe tukan i miminaa wana boda gamwanaa, yaa nige al alona hi kekenu. ");
INSERT INTO mpx_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tama wana sauga ab i pwawa, he wawayau gamaluwaluwa iyoho tinenaa. ");
INSERT INTO mpx_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Wana sauga ab elana, yaka etega nimana i paelu tagilan, inoke topapaab sisiu keketina i ahe i gimwana to, ge i ba, “Toto ya iya ab houwa.” ");
INSERT INTO mpx_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Yaa nimana i nul pasikal yaka talina i lohouwa, inoke topapaab i ba, “Age wam kamwasa u lopwela ge u sogu houwa!” Yaka alana hi tun Peles. ");
INSERT INTO mpx_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Enaa, inoke talina toto sisiu keketina hi gimwan nimanaa i sogu, yaka alana hi tun Selaa. ");
INSERT INTO mpx_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","He boda Isimel Yosepa hi ahe hi pwatanik panuwa Itipita, yaka Potipa i pwamola wana totuwalali loloyowanina. Potipa iya Itipita wali kin wana totuwalali bwabwatana etega, wana limi ana tomatahikan wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yehoba i minaa Yosepa elana, inoke i labe ge bugul gegewena i ginolil hi waisi. He i miminaa wana tonowak Itipita gamagalina wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Wana tonowak i kite Yehoba i minaa elana ge i labe bugul gegewena i ginolil hi waisi, ");
INSERT INTO mpx_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","inoke i yaliyaya Yosepa kaiwena ge i teli ni totuwalali ya te iya eliyana. Yaka i ba wana limi ana totuwalali i houwaagil ge wana bugubugul gegewena i teli nimanaa i matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sauga o elana ge i nok, Yosepa kaiwena Yehoba Potipa wana limi ana heniheni i muloluagil waisi hi pwawa. Wana bugubugul gegewel, wana limi gamwanaa ge wana eyowaa, Yehoba i muloluagil hi waisi. ");
INSERT INTO mpx_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Inoke wana bugubugul gegewena ali logugui i pek Yosepa elana ni matahikagil, yaka iya nige i nuwanuwatu bugul etega kaiwena iyai te aanan toto i aan. He Yosepa i hebubun ge ana awa i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Wana minamina nige ana sauga i yayapu inoke wana tonowak lagona Yosepa i hebabale ge i baek elana i ba, “U nem alou owa ta kenu.” ");
INSERT INTO mpx_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yaa Yosepa i towa, inoke i baek elana i ba, “No tonowak nige i nuwanuwatu bugul etega kaiwena wana limi gamwanaa, kaiwena nau ya minaa te. He wana bugubugul gegewena i teli nimwawa ya matahikagil. ");
INSERT INTO mpx_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No logugui i gan limi ya gamwanaa i ola iya, ge nige bugul etega i kakaise eliyau iyai te owa lagona. Inoke ga i ola ge pagan nanakina ya na ginol ge na gegi Yabowaine elana?” ");
INSERT INTO mpx_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bwagana lan maisena ge maisena yova i mimi papalawakik Yosepa elana, yaa Yosepa i towa nige alona hi kekenu ge nige alona hi minamina. ");
INSERT INTO mpx_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lan etegana Yosepa i na i tuk limiya tage ni tuwalali, he sauga o elana nige limi ana totuwalali etegana i miminaa to. ");
INSERT INTO mpx_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yaka Potipa lagona i na Yosepa ana holahola i kukuhikan, inoke i baek elana i ba, “U nem alou owa ta kenu!” Yaa Yosepa ana holahola i lou luwana yova nimanaa ge i lou tagil noleleya. ");
INSERT INTO mpx_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Sauga yova i kite Yosepa ana holahola i lou luwana nimanaa ge i lou tagil noleleya, ");
INSERT INTO mpx_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","inoke wana limi ana totuwalali i yogaagil hi nem, ge i baek elal i ba, “Ku kite i! Hibilu gamagalina toto ya no tonowak i pwatanim eliyala, i papapuluwawi-agila. I nem i ulutuk no lum gamwanaa nuwana alou naha kenu, inoke ya yoga nabi. ");
INSERT INTO mpx_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Sauga anau i hago, yaka ana holahola i lou luwana labewa ge i lou tagil noleleya.” ");
INSERT INTO mpx_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","He yova Yosepa ana holahola i teliya labenaa ana siga lagona i sikalim limiya. ");
INSERT INTO mpx_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Inoke wasa maisena i wasaan al lagona elana i ba, “Totuwalali loloyowanina Hibilu gamagalina toto u pwatanim eliyala, i nem i ulutuk no lum gamwanaa tage ni papuluwawi-agau. ");
INSERT INTO mpx_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yaa sauga ya yoga, inoke ana holahola i lou luwana labewa ge i lou tagil noleleya.” ");
INSERT INTO mpx_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yosepa wana tonowak lagona wana baaba i hago, inoke i huga nabi, ");
INSERT INTO mpx_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","yaka i ba tolohaveyan Yosepa hi lib hi na hi teli dela, del toto kin wana tololoyowan wali abamina. He sauga Yosepa iyoho dela, ");
INSERT INTO mpx_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yehoba i minaa elana yaka i nunuwana-an ge i muloluan, inoke del ana tomatahikan i yaliyaya iya kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yaka i teli todibula gegewel i houwaagil ge del ana tuwalali gegewena i matahikan. ");
INSERT INTO mpx_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","He del ana tomatahikan nige i nuwanuwatu tuwalali toto Yosepa i matahikan kaiwena, kaiwena Yehoba i minaa Yosepa elana, inoke i labe ge bugul gegewena i ginolil hi waisi. ");
INSERT INTO mpx_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sauga kekeisi i yapu, abwe Itipita wali kin ana oine ana tomatahikan wali tobwabwatana alona ge ana beleid ana totonton wali tobwabwatana, bugul etega hi ginol panak yaka kin nige i yayaliyaya kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Inoke i huga wana totuwalali bwabwatal eluwa o elal ");
INSERT INTO mpx_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ge i ba tolohaveyan hi na hi telel dela, del toto kin wana limi ana tomatahikan wali tohouwa wana limiya. He Yosepa iyoho al to del maisena o eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Inoke kin wana limi ana tomatahikan wali tohouwa Yosepa i teli i matahikagil, ge hi miminaa o sauga yayapona. ");
INSERT INTO mpx_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Heliya iyoho dela, yaka bulin etega kin ana oine ana tomatahikan wali tobwabwatana alona ge ana beleid ana totonton wali tobwabwatana, ali toto eluwa hi kenonou. Ali kenonou nige i mamaisena ge kenonou ali sapu tomaha ona. ");
INSERT INTO mpx_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Lan i gan mweluluga, yaka Yosepa i na elal ge i kitel ali awa i nuwaleyan. ");
INSERT INTO mpx_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Inoke i nelil i ba, “Hauna gun i panuwanuwatu-agimiu ge lan ebe ami awa i nuwaleyan?” ");
INSERT INTO mpx_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Anana hi lahe hi ba, “Ama toto labui ha kenonou, yaa nige gamagal etega i gagan te ge bosowaina ama kenonou ni pasikal.” Inoke Yosepa i ba, “Yabowaine te i lalabela bosowaina kenonou ta pasikal. He ami kenonou ku baunanim.” ");
INSERT INTO mpx_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Inoke oine ana tomatahikan wali tobwabwatana ana kenonou i baunan Yosepa elana i ba, “O kenonou elana oine puna etega ya kite maniniwa, ");
INSERT INTO mpx_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","lalana eton i tagila nuwanaa. Sauga lamwana i titin, inoke etimwawa lanina i tagilan, yaka enona i gan ge i matuwa. ");
INSERT INTO mpx_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","He kin wana kom ya pihikan, yaka oine enona ya ahe ge suina ya pi loke gamwanaa, inoke ya pek kin elana.” ");
INSERT INTO mpx_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Inoke Yosepa i baek elana i ba, “Am kenonou ana pasikal i ola hiwe. Oine lalana eton, he lan ana gewi eton bana. ");
INSERT INTO mpx_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Lan eton ni mowasi, yaka kin ni sokaliwa nu tagil dela, ge ni teli pasikaliwa wam abatuwalaliya. Inoke ana oine nu pek elana ni ola valila, sauga toto owa ana oine ana tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yaa sauga ebo minamina waiwaisana nu pwawa, he nu nuwahikagau. Nu atilomwan-agau yaka nu baaba kin elana kaiweu, inoke ni aheyau na miegonik te del ya elana. ");
INSERT INTO mpx_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kaiwena valila hi kaomeyauek Hibilu wali panuwaa inoke hi aheyau ge ya nem. Ge sauga ya miminaa e, nige bugul etega ya giginol panak, yaa hi teleyau bwabwageyau abamina nanakina ya elana.” ");
INSERT INTO mpx_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Sauga beleid ana totonton wali tobwabwatana i hago oine ana tomatahikan ana kenonou ana sapu i waisi, inoke i baek Yosepa elana i ba, “He nau al ge ya kenonou. Tage beleid ana egowa eton ya toun pate. ");
INSERT INTO mpx_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Egowa toto pwatanaa hot, beleid, bisket ge keik totonil tomaha ge tomaha kin kaiwena i kalaopop. Yaa bwasumu bolo hi youyou hi nem ge hi anil.” ");
INSERT INTO mpx_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Inoke Yosepa i baek elana i ba, “Am kenonou ana pasikal i ola hiwe. Egowa eton, he lan ana gewi eton bana. ");
INSERT INTO mpx_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Lan eton ni mowasi, kin ni sokaliwa nu tagil dela, yaka ni ba tolohaveyan mwamwalim nihi gotomwa. Inoke tuwam nihi pakuki ebwakil elana ge bwasumu bolo hi youyou nihi nem nihi an.” ");
INSERT INTO mpx_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Lan eton i mowasi kin wana lan ab ana nuwahikan, inoke aanan bwabwatana i ginol wana totuwalali bwabwatal gegewel kaiweliya. Inoke ana oine ana tomatahikan wali tobwabwatana alona ge ana beleid ana totonton wali tobwabwatana, i sokalil hi tagil dela ge i telel wana totuwalali bwabwatal maniniliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Yaka ana oine ana tomatahikan i teli pasikal wana abatuwalaliya inoke kin ana oine i pek elana i ola valila. ");
INSERT INTO mpx_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Yaa i ba tolohaveyan elal ana beleid ana totonton mwamwalina hi gotomwa yaka tuwana hi pakuki ebwakil elana. He i masal i ola toto Yosepa i baunan elal, sauga ali kenonou i papasikal. ");
INSERT INTO mpx_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yaa kin ana oine ana tomatahikan wali tobwabwatana nige Yosepa i nunuwahikan, he i nuluwan hoti. ");
INSERT INTO mpx_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Baliman eluwa i mowasi, yaka abwe Itipita wali kin i kenonou. Tage i talmilila wewel Naile bebenaa, ");
INSERT INTO mpx_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","yaka bulumwakau meluyowau tuwaliya sasapona ge tatabwal, ali gewi seben, hi gaiheem wewela ge hi alaalamwawin wewel bebenaa. ");
INSERT INTO mpx_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Toto o enaa, yaka bulumwakau meluyowau ali gewi seben al hi gaiheem wewela, heliya tuwaliya lalauina ge ali awa nanakina. Inoke hi na hi talmilila bolo hi miminaa wewel bebenaa gegeliliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Yaka bulumwakau bolo tuwaliya lalauina ge ali awa nanakina bolo seben tuwaliya sasapona ge tatabwal hi anil habal. Kin i kenonou i ola o inoke matana i panana. ");
INSERT INTO mpx_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Inoke i kenu al ge kenonou eluwana i kenonou-an. Tage witi enona ali haka seben hi enona nuwana maisena elana, enowaliya hi tabwa ge ali awa i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Toto o enaa, yaka witi enona ali haka seben al hi siun, heliya enowaliya i yakiwa ge mana kalakalasina i neem labi kekevana iyaka i tonil. ");
INSERT INTO mpx_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Yaka haka bolo enowaliya hi yakiwa haka seben bolo enowaliya hi tabwa hi tinonil. Inoke kin i kenu lut ge i atena te i kenonou. ");
INSERT INTO mpx_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Lan i gan mweluluga i nuwanuwatu kenonou o kaiweliya, inoke Itipita wali tokukula ge wali tosiba gegewel ali baaba i patuna ge hi nem. Yaka kenonou labui i baunan elal, yaa nige etega bosowaina ni pasikal. ");
INSERT INTO mpx_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yaka abwe kin ana oine ana tomatahikan wali tobwabwatana i baek elana i ba, “Tonowak, no gegi etega, bugul etega nige ya babaunan eliyam, abwe ya nuwatu te. ");
INSERT INTO mpx_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","He valila sauga etega u huga alou ge am beleid ana totonton wali tobwabwatana eliyama, inoke u telema dela, del toto wam limi ana tomatahikan wali tohouwa wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yaka bulin etega ama toto eluwa ha kenonou, yaa ama kenonou ali sapu tomaha ona. ");
INSERT INTO mpx_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hibilu hevalina etega iyoho to aloma, iya wam limi ana tomatahikan wali tohouwa wana totuwalali loloyowanina. Ama kenonou ha baunanik elana, inoke alou ge alou ama kenonou ali sapu i pasikal kaiwema. ");
INSERT INTO mpx_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","He bugul gegewena i masal i olaolaek te kenonou ali pasikal toto i baunan eliyama. Nau u teli pasikalau no abatuwalaliya, ge u ba tolohaveyan am beleid ana totonton mwamwalina hi gotomwa yaka tuwana hi pakuki ebwakil elana.” ");
INSERT INTO mpx_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Sauga kin baaba o i hago, inoke Yosepa ana baaba i patuna ge ni nem elana. Yaka etimwawa Yosepa hi ahe tagilan dela, yaka i na awana pupunona i kol ge kama waiwaisana i galoi, inoke hi pwatanik kin elana. ");
INSERT INTO mpx_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Inoke kin i baek Yosepa elana i ba, “Kenonou etega ya kenonou-an, yaa nige gamagal etega i bosowaina ni pasikal. He no wasa hi pem tage ebo gamagal etega ana kenonou ni baunaniwa, inoke owa bosowaim nu pasikal.” ");
INSERT INTO mpx_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosepa kin anana i lahe i ba, “Tonowak, nau nige bosowaiu i oola kenonou na pasikal. Yaa Yabowaine am kenonou ana pasikal ni pamasal eliyam ge ana sapu ni waisi.” ");
INSERT INTO mpx_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Yaka kin i baek Yosepa elana i ba, “O kenonou i ola hiwe. Tage ya talmilila wewel Naile bebenaa, ");
INSERT INTO mpx_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","yaka bulumwakau meluyowau tuwaliya sasapona ge tatabwal, ali gewi seben, hi gaiheem wewela ge hi alaalamwawin wewel bebenaa. ");
INSERT INTO mpx_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Yaka bulumwakau meluyowau ali gewi seben al hi gaiheem wewela, heliya tuwaliya lalauina ge ali awa nanakina. Nige sauga etega bulumwakau ololal o ya kikitel panuwa Itipita gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Yaka bulumwakau bolo tuwaliya lalauina ge ali awa nanakina bolo houwan hi gaiheem wewela tatabwal hi anil habal. ");
INSERT INTO mpx_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Yaa bwagana hi an habal, ali kite i ola te nige hi aanan. He tuwaliya ana awa nanakina i ola ya te valila. Inoke matau ya panana. ");
INSERT INTO mpx_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Yaka abwe ya kenu al ge kenonou eluwana ya kenonou-an. Witi enona ali haka seben ya kitel hi enona nuwana maisena elana, enowaliya hi tabwa ge ali awa i waisi. ");
INSERT INTO mpx_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Toto o enaa, yaka witi enona ali haka seben al hi siun, heliya enowaliya i yakiwa ge mana kalakalasina i neem labi kekevana iyaka i tonil. ");
INSERT INTO mpx_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yaka haka bolo enowaliya hi yakiwa haka seben bolo ali awa i waisi hi tinonil. He sauga ya lut, inoke o kenonou ya baunan tokukula elal, yaa nige etega bosowaina ni pasikal eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Inoke Yosepa i baek kin elana i ba, “Tonowak, am kenonou bolo eluwa o ali sapu maisena. Yabowaine i pankitewa hauna gun abwe ni ginol. ");
INSERT INTO mpx_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bulumwakau meluyowau tatabwal ali gewi seben, he baliman ana gewi seben bana, ge witi enona ali haka ali awa waiwaisana ali gewi seben, heliya al baliman ana gewi seben bana. Ali toto eluwa ali sapu maisena ya. ");
INSERT INTO mpx_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ge bulumwakau tuwaliya lalauina ge ali awa nanakina ali gewi seben, bolo mulaa abwe hi masal, he baliman ana gewi seben bana, ge i ola al witi enona ali haka seben, bolo enowaliya nanakina ge mana kalakalasina iyaka i tonil. Heliya hi pamasal baliman ana gewi seben galebu bwabwatana ni masal. ");
INSERT INTO mpx_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Tonowak, he i ola te ewasi ya baunan eliyam: Yabowaine iyaka i pamasal elam hauna gun abwe ni ginol. ");
INSERT INTO mpx_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Baliman ana gewi seben malul bwabwatana ni gan panuwa Itipita ana labi gegewena elana. ");
INSERT INTO mpx_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Enaa, inoke baliman ana gewi seben galebu bwabwatana ni masal. Yaka Itipita ana malul baliman seben gamwanaa nige mulina ni gagan, kaiwena galebu o nasi panuwa ni pagulagula. ");
INSERT INTO mpx_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Gamagalau sauga malumalulina nige al nihi nunuwatu-an, kaiwena galebu o nasi ni bwata hot. ");
INSERT INTO mpx_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kenonou u kenonou-an paeluwa puna kaiwena Yabowaine bugul ya iyaka i nuwatuan haba, ge kaiwena sauga kekeisi ya inoke ni ginol. ");
INSERT INTO mpx_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Inoke tau etega nu hile, toto wana siba i gan ge nuwana i sapu, ge nu teli panuwa Itipita gegewena ni logugui-an. ");
INSERT INTO mpx_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tologugui enuna al nu hilel panuwa nihi logugui-an. Inoke malul ana baliman seben gamwanaa, pahi ana sauga elana pahi enona nihi wali panimala panuna ge wali maisena nihi ahe gamaman kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Yaka aanan gegewena toto nihi ahe malul ana baliman toto i nenem gamwaliyaa, nihi bugul papahe. Inoke wam logugui ana gasisi elana witi enona o nihi teli hikan ali limi gamwanaa panuwa ona elal ge nihi matahikan. ");
INSERT INTO mpx_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Aanan o ni ola etagalou. Yaka galebu ana baliman seben gamwaliyaa toto i nenem panuwa Itipita elana, nihi patuwalali nihi pek gamagalau elal. Inoke bahi gamagalau galebu bwabwatana kaiwena ge nihi aaliga.” ");
INSERT INTO mpx_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Sauga kin alonau ge wana tologugui bwabwatal Yosepa wana baaba hi hago, inoke nuwatu o hi awa wawaisi-an. ");
INSERT INTO mpx_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yaka kin i baek elal i ba, “Nige bosowaina gamagal etega al ta pwawa wana siba ni ola tau ya, iya Yabowaine Yayaluwana i minaa elana.” ");
INSERT INTO mpx_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Inoke i baek Yosepa elana i ba, “Yabowaine bugul bolo ya gegewel iyaka i pankitewa, he nige gamagal etega wana siba ge wana nuwasapu i oola owa. ");
INSERT INTO mpx_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Na telewa nu tabwa tologugui bwabwatana no panuwa elana, inoke no gamagalau gegewel wam baaba nihi henapuan. He nau kin maiseu ya te alau alam ni bwata lake.” ");
INSERT INTO mpx_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Inoke i ba vevehe al Yosepa elana i ba, “Ya telewa nu tologugui bwabwatana Itipita ana labi gegewena elana.” ");
INSERT INTO mpx_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inoke nimana gigina ana lin toto kin etotohena iyoho lin tuwanaa, i palo ge i pahek Yosepa nimana giginaa. Yaka kaliko matana waiwaisana i ahe Yosepa i pagaloi, ge bobot gold elana hi ginoliya i telek Yosepa mwamwalinaa. ");
INSERT INTO mpx_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","I ola al i ba ni heya kin wana waga momomol labuina pwatanaa, yaka gamagalau nihi nohouwa manininaa nihi yogayoga nihi ba, “Ku legi! Ku legi!” He kin i ginol ola o ge i pamasal Yosepa i teli i tologugui bwabwatana panuwa Itipita ana labi gegewena elana. ");
INSERT INTO mpx_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","He i baek Yosepa elana i ba, “Nau te kin, yaa nige gamagal etega al panuwa Itipita ana labi gegewena elana bugul etega totona ni giginol, houwan ga ni papatalam eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Yaka kin Yosepa alana i tun Sepenat Peneya, ge lagona i pek yova alana Asinata, iya panuwa Heliyopelis wali topowon Potipela natuna. Inoke Yosepa alana i bwata i tabwa tologugui Itipita elana. ");
INSERT INTO mpx_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","He Yosepa wana baliman teti te i tuwalali telipuna Itipita wali kin elana. Inoke Yosepa i notagil kin i eguluwan ge wana waga momomol elana i nawanawa panuwa Itipita gamwana gegewena i anugayawa-an. ");
INSERT INTO mpx_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Malul ana baliman seben gamwanaa Itipita wali eyowa enona i bwata nabi. ");
INSERT INTO mpx_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Inoke baliman seben o elana Yosepa aanan i gewi hot i bugulan ge i teli hikan ali limi gamwanaa panuwa ona elal. He panuwa maisena ge maisena ana eyowa enowana i teliya panuwa o elana. ");
INSERT INTO mpx_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Witi enona i gewi nabi i ola hoga gilesana Yosepa i pwahin abaliyaa, inoke nige al bosowaina ana gewi ni ahe. ");
INSERT INTO mpx_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Galebu ana baliman nigeya ga i mamasal, inoke Yosepa lagona Asinata natuliyau bolau labui i abil. Asinata iya panuwa Heliyopelis wali topowon Potipela natuna. ");
INSERT INTO mpx_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosepa natuna gamaun alana i tun Manasa, ge i ba, “Alana ya tun ola o kaiwena Yabowaine i labeyau yaka o pulowan gegewena ge nam wana limi ana heniheni gegewel ya nuluwagil.” ");
INSERT INTO mpx_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Natuna eluwana alana i tun Ipileimi, ge i ba, “Alana ya tun ola o kaiwena Yabowaine natuwau i pem no lomwan panuwana ya elana.” ");
INSERT INTO mpx_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Malul ana baliman seben i mowasi panuwa Itipita elana, ");
INSERT INTO mpx_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","inoke galebu bwabwatana ana baliman seben i telipuna, i ola Yosepa wana baaba. He galebu bwabwatana i masal al panuwa gegewel elal, yaa Itipita ana labi gegewena elana aanan i gan. ");
INSERT INTO mpx_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Sauga Itipita gamagaliliyau hi galebu, inoke hi na kin elana ge aanan kaiwena hi awanun gagasisi. Yaka kin i baek elal i ba, “Nuku na Yosepa elana, yaka hauna gun ni baunan eliyamiu nuku ginol ola.” ");
INSERT INTO mpx_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","He galebu i bwata nabi ge iyaka panuwa Itipita ana labi gegewena i pwawa, inoke Yosepa witi enona ana limi i lopwelaan ge i palian Itipita elal. ");
INSERT INTO mpx_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Panuwa gegewena labi o elana hi na Itipita ge witi enona hi pwapwamola Yosepa elana, kaiwena labi gegewena galebu i apapanak-an. ");
INSERT INTO mpx_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo wasa i hago te witi iyoho Itipita, inoke i baek natunau bolau elal i ba, “Ga i ola ku minamina ya ge ku pepegagayawa-agimiu? ");
INSERT INTO mpx_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ya hago te witi iyoho Itipita. Nuku na enuna nuku pwamola kaiwela, yaka bahi galebu kaiwena ge ta aaliga.” ");
INSERT INTO mpx_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Inoke Yosepa talinau elulutega hi egon nihi na Itipita witi nihi pwapwamola. ");
INSERT INTO mpx_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaa Yakobo nige Beniyamina, iya Yosepa talina hot, i tatalamwan aloliya hi nonok, kaiwena i lovakun eba nak etega ni pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Inoke bolo hi na Itipita witi nihi pwapwamola, gamwaliyaa Yakobo natunau al ge, kaiwena galebu bwabwatana iyaka i masal panuwa Kenani elana. ");
INSERT INTO mpx_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","He sauga o elana Yosepa iya i tologugui bwabwatana panuwa Itipita, ge iya witi i palipali gamagalau elal bolo hi neem panuwa gegewena elal. Inoke sauga talinau hi na hi vin elana, hi kululu elana maniniliya i loek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Sauga Yosepa talinau i kitel inoke i atena te iya talinau, yaa i ginol i ola te nige i aatenal. Inoke i nel elal anana i elolol i ba, “Komiu ga ku neem?” Anana hi lahe hi ba, “Ha neem panuwa Kenani, nuwama aanan naha pwapwamola.” ");
INSERT INTO mpx_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","He bwagana Yosepa i atena te iya talinau, yaa heliya nige hi aatena te henala iya. ");
INSERT INTO mpx_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Inoke Yosepa ana kenonou bolo valila i kenonou-an talinau kaiweliya i nuwatuan. Yaka i baek elal i ba, “Komiu toanugayawa! Ku nem nuku kite hauna labi wama panuwa gamwanaa bosowaina tolohaveyan etimwawa nihi tuk.” ");
INSERT INTO mpx_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Anana hi lahe hi ba, “Tonowak, ama nige toanugayawa i oola. Ha nem aanan pwapwamola kaiwena ha ola wam totuwalali. ");
INSERT INTO mpx_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Gegewema tamama maisena. He ama gamagalau waiwaisal, nige toanugayawa i oola.” ");
INSERT INTO mpx_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Analiya Yosepa i lahe i ba, “Nigeya! Ku nem nuku kite hauna labi wama panuwa gamwanaa bosowaina tolohaveyan etimwawa nihi tuk.” ");
INSERT INTO mpx_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Inoke Yosepa anana hi lahe hi ola, “Tonowak, wam totuwalali ama alomeyau ge talimeyau gegewema ama gewi elulutega eluwa. Tamama maisena, iya i miminaa panuwa Kenani. Ama melumelu iyoho to alona ge tamama, ge toto etegana al iyaka nige i gagan.” ");
INSERT INTO mpx_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosepa i baek elal i ba, “He i ola te ya ba haba eliyamiu: komiu toanugayawa. ");
INSERT INTO mpx_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Wami baaba o eliyana na labosemiu ge na atena ebo komiu gamagalau waiwaisal o ebo nigeya. O sila kin, nige panuwa ya nuku eeguluwan ana siga ami melumelu ni nem na kite. ");
INSERT INTO mpx_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Inoke etega gamwamiwa nuku patuna ni na ami melumelu ni ahe ge ni pwatanim eliyau. Yaa gegewemiu al nuku minaa ga dela ana siga na atena ebo toto ku baunan i tunahot o ebo nigeya. Yaa ebo nige i tutunahot, he o sila kin, komiu toanugayawa!” ");
INSERT INTO mpx_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Inoke gegewel Yosepa i telel dela hi miminaa o lan ana gewi eton. ");
INSERT INTO mpx_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Lan etonina elana Yosepa i baek elal i ba, “Nuku ginol ola hiwe no nuwatu, inoke nige na aapanakimiu, kaiwena nau Yabowaine ya lovakunan. ");
INSERT INTO mpx_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ebo tunahot komiu gamagalau waiwaisal, inoke talimiu etega ni minaa ga dela yaka gegewemiu al witi nuku ahe ge nuku sikal nuku pek tutumiyau togalebu elal. ");
INSERT INTO mpx_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Yaa ami melumelu nuku ahe ge nuku pwatanim eliyau, inoke na atena te toto ku baunan eliyau i tunahot, yaka nige nuku yayaomal.” Inoke Yosepa wana baaba hi awa wawaisi-an. ");
INSERT INTO mpx_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yaka hi pebaaba-agil hi ola, “Valila wala ginol talila elana lahena te sauga ya ta pwawa e. Sauga i awanun nabinabi te bahi ta aapanak, he atena ana lomwan ta kite ya, yaa nige anana ta hahago. Inoke heiya te kaiwena ge pulowan ya i masal elala e.” ");
INSERT INTO mpx_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yaka Lubeni i ba, “Valila ya ba eliyamiu te bahi nuku giginol panak geman elana, yaa nige anau ku hahago. He wana yaomal lahena te sauga ya ta pwawa e.” ");
INSERT INTO mpx_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosepa i hago hauna bana hi baaba, yaa nige hi aatena to, kaiwena iya i papana Itipita ge topapasikal etega i papasikal elal. ");
INSERT INTO mpx_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Inoke Yosepa i eguluwagil i na i kahin. I pwaul i mowasi, inoke i sikal i na i baaba al elal. Yaka i ba wana totuwalali Simiyon hi ahe ge hi yowan mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Inoke Yosepa i baek wana totuwalali elal witi nihi usan pakalaopop talinau wali beig gamwanaa, ge wali mani nihi teli pasikal maisena ge maisena wana beig gamwanaa. I ola al i ba aanan enuna nihi pek wali nawanawa kamwasaa kaiwena. He totuwalali hi ginol ola to kaiweliya, ");
INSERT INTO mpx_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","inoke ali witi ana beig hi usan wali donki pwataliyaa ge hi egon. ");
INSERT INTO mpx_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Hi vin abaveyaho elana ge abwe nihi kenu, yaka taliliya etegana wana beig i pwela tage wana donki aana ni ahe ge ni paan. Inoke wana mani i pwawaa wana beig awanaa. ");
INSERT INTO mpx_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Yaka i yoga talinau elal i ba, “No mani toto witi ya pwamolaya hi teli pasikal. Ku kite, iya hiwe no beig gamwanaa e.” Yaka tuwaliya i aliga ge ginebi wali lovakun hi pebaaba-agil hi ba, “Yabowaine ga i ginol ola eliyala e?” ");
INSERT INTO mpx_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Sauga hi na hi vin tamaliya Yakobo elana panuwa Kenani, inoke bugul gegewena toto i masal elal hi wasaan elana. ");
INSERT INTO mpx_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Hi ba, “Itipita wali tologugui bwabwatana i ba lalaagima, ge i wolema tage ama toanugayawa. ");
INSERT INTO mpx_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Yaa ha baek elana ha ba, ‘Ama gamagalau waiwaisal, nige toanugayawa i oola. ");
INSERT INTO mpx_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","He alomeyau ge talimeyau gegewema ama gewi elulutega eluwa ge tamama maisena. Talima etegana iyaka nige i gagan, ge ama melumelu iyoho Kenani alona ge tamama.’ ");
INSERT INTO mpx_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Inoke tologugui bwabwatana o i baem al eliyama i ola, ‘Wami baaba o eliyana na labosemiu ge na atena ebo komiu gamagalau waiwaisal o ebo nigeya. He talimiu etega nuku eguluwana te eliyau, yaka gegewemiu al witi nuku ahe ge nuku sikal nuku pek tutumiyau togalebu elal. ");
INSERT INTO mpx_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yaa ami melumelu nuku ahe ge nuku pwatanim eliyau, inoke na atena te komiu nige toanugayawa i oola yaa gamagalau waiwaisal. Inoke abwe talimiu toto ku eguluwan eliyau na pewa pasikal, ge na talamwagimiu hauna nuwamiu inoke nuku pwamola.’” ");
INSERT INTO mpx_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Sauga wali beig hi lopwelaan witi hi ligiligin palu, yaka maisena ge maisena wana mani ana os i pwawaa wana beig gamwanaa. Aloliya ge tamaliya mani ana os hi kitel inoke hi lovakun. ");
INSERT INTO mpx_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yaka abwe tamaliya Yakobo i baek elal i ba, “Nasi natuwau gegewel nuku payaomalil nige al na kikitel. Yosepa iyaka nige i gagan, Simiyon iyaka nige i gagan, ge sauga ya nuwamiu Beniyamina nuku ahe. Bugul gegewena iyaka i pulowan eliyau!” ");
INSERT INTO mpx_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Inoke Lubeni i baek tamana elana i ba, “Ebo nige Beniyamina na papasikal eliyam, he natuwau bolau labui nu lolil. U teliya nimwawa o matamatahikan, inoke abwe na en pasikalim eliyam.” ");
INSERT INTO mpx_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaa Yakobo i ba, “Natu nige na tatalamwan nuku aahe alomiu nuku nana Itipita. Talina iyaka i yaomal, iya maisena ya te i mina e. Iyaka ya liki, ebo nuku nawanawa kamwasaa ge nak etega ni pwawa, nasi nuwanakina ni paaligau.” ");
INSERT INTO mpx_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Panuwa Kenani elana galebu iyoho ya i bwatabwata. ");
INSERT INTO mpx_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Inoke sauga witi toto valila hi ahem Itipita hi an haba, yaka Yakobo i baek natunau bolau elal i ba, “Nuku sikal Itipita ge witi enuna al nuku pwamola kaiwela.” ");
INSERT INTO mpx_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yaa Yuda i baek tamaliya elana i ba, “Itipita wali tologugui bwabwatana valila i ba nabinabi eliyama i ba, ‘Ebo nige alomiu talimiu nuku nenem, he nige na tatalam nuku tutuk ge nuku kikiteyau.’ ");
INSERT INTO mpx_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ebo talima nu talamwan aloma naha nok, inoke naha nok yaka aanan naha pwamola kaiwem. ");
INSERT INTO mpx_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Yaa ebo nige nu tatalamwan, he nige naha nonok. Kaiwena tau o iyaka i ba haba eliyama i ba, ‘Ebo nige alomiu talimiu nuku nenem, he nige na tatalam nuku tutuk ge nuku kikiteyau.’” ");
INSERT INTO mpx_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakobo, alana etega al Isileli, i baek elal i ba, “Ga i ola ge tau o wana wasa ku pek ku ba, ‘Talima etega al iyoho,’ yaka eliyana o pulowan bwabwatana ya ku pem.” ");
INSERT INTO mpx_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Anana hi lahe hi ba, “Tau o i nel bubunima ama kaiwema ge tutumeyau kaiweliya. I ba, ‘Tamamiu iyoho ya i minamina? Tab talimiu etegana al i gan?’ Inoke wana nel lahena ya te ha baunan elana. He nige ha aatena te abwe ni baem eliyama ni ba, ‘Talimiu nuku en pwatanim.’” ");
INSERT INTO mpx_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Inoke Yuda i baek tamaliya Isileli elana i ba, “Geman u talamwan ni nem alou, yaka sauga ya te naha egon. Inoke owa ge ama alomeyau natumeyau bahi galebu kaiwena ge ta aaliga. ");
INSERT INTO mpx_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ya batelewa nau na matahikan, inoke pulowanina nu pem o kalikalivai. Ebo nige na een pasikal ge na teteli maninimwa, he nau iyaka ya gegi eliyam, inoke yawaliu miminana ana woliwoli o ni minem eliyau. ");
INSERT INTO mpx_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Binimala nige nu kukuhikagima ge sauga naha aahe nabiyan, he bosowaima te iyaka naha nok ge naha nem palabuina te.” ");
INSERT INTO mpx_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Inoke tamaliya Isileli i baek elal i ba, “Ebo ni ola o, he nuku ginol ni ola hiwe. Wala panuwa enona waiwaisal ona nuku usan wami nabwa gamwanaa: bugul bwaleliya waiwaisana enuna, luvi uleya enuna, aanan amnana ana epawaisi enuna, enonu meya enuna, ge ebwakil pistasiyo ge almon enowaliya enuna. Inoke nuku na nuku pek tologugui o elana wami mulolu. ");
INSERT INTO mpx_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mani toto valila ku noahe, he sauga ya nuku daboli ge nuku ahe. Kaiwena mani toto hi teli pasikal wami beig awanaa nasi nuku pek pasikal ga elal. Tabana eba hi usan pagegi. ");
INSERT INTO mpx_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Talimiu Beniyamina al nuku ahe, inoke sauga ya etimwawa nuku egon nuku sikal tologugui o elana. ");
INSERT INTO mpx_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ya awanun Yabowaine Togasisi Hot tologugui o ni paatilomwanan yaka atena ni lomwanagimiu, inoke talimiu toto etegana alona ge Beniyamina ni talamwagil alomiyau nuku sikalim eliyau. Yaa ebo natuwau na payaomalil, he iyaka ya payaomalil.” ");
INSERT INTO mpx_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Inoke natunau wali mulolu hi ahe, ge mani toto valila hi noahe hi daboli ge hi ahe. Yaka avaliya ge Beniyamina etimwawa hi egon hi na Itipita ge hi masal Yosepa eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sauga Yosepa i kite Beniyamina iyoho avaliya, inoke i baek wana limi ana totuwalali wali tohouwa elana i ba, “Bolau ya nu enil nihi na no limiya, yaka sipi o ebo goti o ebo bulumwakau etega nu tagapaaliga ge aanan nu ginol. Nasi alalati alowau naha anan.” ");
INSERT INTO mpx_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Totuwalali i ginol ola Yosepa wana baaba, yaka i enil ge nihi na Yosepa wana limiya. ");
INSERT INTO mpx_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Hi nanawa limi kaiwena, inoke hi lovakun ge hi nuwanuwatu hi ba, “Mani toto wala nem houwan elana hi teli pasikal wala beig gamwanaa, baena te i ahela ge ta nem e. He nuwaliya nihi pakokovela yaka nihi telela ta ola wali totuwalali loloyowanil ge wala donki nihi ahel.” ");
INSERT INTO mpx_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Limi ana nog elana inoke hi na hi baek Yosepa wana totuwalali elana hi ba, ");
INSERT INTO mpx_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Tonowak, valila ha nem ga houwan aanan ha pwapwamola. ");
INSERT INTO mpx_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Yaa wama sauga sikal elana, ha vin abaveyaho elana ge abwe naha kenu, inoke wama beig ha lopwelaan, yaka maisena ge maisena wama mani ana bwata i olaolaek ha pwawaa wama beig awaliyaa. He iyahe ha pwatanim ge naha pewa pasikal. ");
INSERT INTO mpx_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ge mani enuna al ha pwatanim aanan enuna al naha pwamolaya. Yaa nige ha aatena te henala wama mani toto valila i teli pasikal wama beig ona gamwaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Analiya totuwalali i lahe i ba, “Bahi nuku nuwanuwatu ge nuku lolovakun. Wami Yabowaine, toto tamamiu wana Yabowaine, iya te wami mani i teli wami beig gamwaliyaa. Yaa mani toto valila witi ku pwamolaya iyaka ya ahe.” Inoke i na dela Simiyon i sokal ge i pwatanik talinau elal. ");
INSERT INTO mpx_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Yaka totuwalali i en tukagil Yosepa wana limiya, inoke wewel i wage i pek aeliya hi ul, ge wali donki aliya i pek hi anan. ");
INSERT INTO mpx_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","He iyaka hi hago te nasi alalati avaliya ge Yosepa nihi anan, inoke wali mulolu hi lovivina-an ge sauga Yosepa ni vin nihi pek elana. ");
INSERT INTO mpx_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Inoke sauga Yosepa i sikal limiya, wali mulolu bolo hi bugul tukagil limiya hi ahe ge hi pek elana. Inoke hi kululu elana maniniliya i loek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosepa i nel elal i ba, “Tab ku molu?” Yaka abwe i nel vevehe i ba, “Valila no wasa ku pem tamamiu lilikena kaiwena. He ga i ola? Iya iyoho ya i minamina i molu?” ");
INSERT INTO mpx_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Anana hi lahe hi ba, “Tonowak! Ee, tamama iyoho ya i minamina ge i molu.” Yaka abwe Yosepa ana awatauwan hi ginol hi kululu elana. ");
INSERT INTO mpx_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Sauga Yosepa matana i lipwapwati ge Beniyamina, iya talina hot hinaliya maisena i kite, inoke i nel elal i ba, “Ami melumelu toto valila wasana ku wasaan elau heiya e?” Inoke hi talam, yaka i baek Beniyamina elana i ba, “Natu, Yabowaine ni muloluagiwa.” ");
INSERT INTO mpx_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosepa atena i lomwan nabi talina kaiwena kelaubwa ni kahin, inoke etimwawa i eguluwagil i na wana lum elana ge i kahikahin. ");
INSERT INTO mpx_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Sauga i pwaul yaka wewel i ahe maninina i ul, inoke atena i pagasisi al i na i tagil elal, ge i ba wana totuwalali aanan nihi habwe. ");
INSERT INTO mpx_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosepa i minaa teibol etega elana aana hi pek, talinau hi minaa teibol getoga elana aliya hi pek, ge Itipita bolo avaliyau hi anan hi minaa teibol getoga al elana aliya hi pek. Hi ginol ola o, kaiwena Itipita nige sauga etega avaliyau ge Hibilu hi aanan toyawa, amnaliya i naka hot. ");
INSERT INTO mpx_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","He Yosepa i ba totuwalali talinau hi telel abaliyaa teibol elana. Awoliya i noek Yosepa elana ge ali vatavatal i golugoluwa wali baliman ab elana, i telipunaa ali gamaun elana i na ana siga ali melumelu. Sauga talinau ali vatavatal hi kite, inoke nuwaliya hi ahe ge hi pegagayawa-agil. ");
INSERT INTO mpx_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Totuwalali Yosepa talinau aliya hi habweya Yosepa wana teibol elana hi na hi pek maisena ge maisena elana. Yaa Beniyamina aana hi habwe pwabwata i ola gamagalau nimala panuna aliya ana bwata. Inoke aloliya Yosepa hi anan ge hi imwim ginebi wali yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Sauga hi anan haba, inoke Yosepa i baek wana limi ana totuwalali wali tohouwa elana i ba, “Witi nu wage usan bolau ya wali beig gamwaliyaa ana siga ni kalaopop hot, ge wali mani nu teli pasikal maisena ge maisena wana beig awanaa. ");
INSERT INTO mpx_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","No kom toto silba hi ginoliya nu ahe nu loke ali melumelu wana beig awanaa ginebi ge wana mani toto i pwatanim witi molana.” Inoke i ginol ola Yosepa wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mweluluga kekeisi hot totuwalali Yosepa talinau hi patunal hi egon aloliyau ge wali donki. ");
INSERT INTO mpx_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Sauga hi nawanawa nigeya ga ali bwaga i gagan panuwa elana, inoke Yosepa i baek wana totuwalali wali tohouwa elana i ba, “Nu tatauliulil bolau o eliyaa, inoke sauga nu kukuhikagil yaka nu baek elal nu ba, ‘No tonowak i ginol bubun eliyamiu, inoke hauna kaiwena lahena komiu ku ginol panak elana? ");
INSERT INTO mpx_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hauna kaiwena no tonowak wana kom silba hi ginoliya ku kaome? Kom o heiya te i imwimwa ge i papatuwalali sula ana eabab. Komiu pagan nanakina hot ku ginol.’” ");
INSERT INTO mpx_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yaka wana totuwalali wali tohouwa i tatauliulil eliyaa, inoke sauga i kukuhikagil Yosepa wana baaba o i baunanik elal. ");
INSERT INTO mpx_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Anana hi lahe hi ba, “Tonowak, ga i ola ge baaba ololana o u baunan eliyama? Ama nige wama pagan i oola te ginol ololana o naha ginol. ");
INSERT INTO mpx_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","U atena te mani toto valila ha pwawa wama beig awaliyaa, ha ahem wama panuwa Kenani ha pwatanim ge naha pewa pasikal. Inoke ga i ola ge u nuwatu tage ama silba o ebo gold naha kaome wam tonowak wana limiya? ");
INSERT INTO mpx_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tonowak, ebo kom nu pwawaa ama etega eliyana, he gamagal o ni aliga, yaka gegewema al nu ahema naha tabwa wam totuwalali loloyowanil.” ");
INSERT INTO mpx_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Inoke totuwalali analiya i lahe i ba, “I waisi, ta ginol ni ola wami baaba. Yaa ebo kom na pwawaa alomiu etega eliyana, he gamagal o iya te ni tabwa no totuwalali loloyowanina. Gegewemiu al nige na wowolemiu na talamwagimiu nuku egon.” ");
INSERT INTO mpx_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Inoke etimwawa wali beig hi kaval palo bilibiliya, yaka maisena ge maisena wana beig i pwela. ");
INSERT INTO mpx_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Inoke totuwalali i loya, i telipunaa ali gamaun wana beig elana i na i pwamowasiya ali melumelu wana beig elana. He kom i pwawaa Beniyamina wana beig gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Talinau kom hi kite, inoke nuwanak kaiwena ali kaliko hi kukuleli. Yaka wali beig hi kaval heyagil wali donki pwataliyaa ge hi sikalek eliyaa hi na panuwaa. ");
INSERT INTO mpx_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","He Yosepa iyoho ya wana limiya, yaka Yuda alonau ge talinau hi na hi vin eliyana. Inoke ginebi ge wali lovakun hi sogu bilibiliya Yosepa matanaa. ");
INSERT INTO mpx_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Inoke Yosepa i baek elal i ba, “Hauna kaiwena pagan ya ku ginol? Age nige ku aatena tau ololana nau bosowaiu sula na ab inoke eliyana bugul misusumel na atena?” ");
INSERT INTO mpx_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yaka anana Yuda i lahe i ba, “Tonowak, ga naha ba ola? He nige bosowaima anam naha lahe! Ga naha ola ge naha ba pasapu tage nige ha giginol? He Yabowaine wama gegi iyaka i pamasal. Tonowak, gegewema iyaka ha tabwa wam totuwalali loloyowanil, aloma ge toto kom hi pwawaa wana beig gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yaa Yosepa i ba, “Nigeya! Nige bosowaina na ginol ola eliyamiu! Tau toto kom hi pwawaa wana beig gamwanaa, iya ya te ni tabwa no totuwalali loloyowanina. He gegewemiu al nuku sikal nuku na tamamiu elana ge bahi nuku nuwanuwatu.” ");
INSERT INTO mpx_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Inoke Yuda i noha Yosepa gegelinaa ge i ba, “Tonowak, ateu hot owa, nuwau no baaba nu laeganan. Owa tologugui bwabwatana alam i bwata i ola Itipita ana kin, yaa bahi nu huhugaagau. ");
INSERT INTO mpx_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tonowak, wama nem houwan elana u nel eliyama u ba, ‘Tab tamamiu o ebo talimiu etega al i gan?’ ");
INSERT INTO mpx_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Inoke anam ha lahe ha ba, ‘Ibwe, tamama iyoho i gan, iyaka i liki. Ge ama melumelu i gan, tamama wana sauga liki elana te hi ab. Talina hot iyaka i yaomal, yaka hinana natunau gamwaliyaa iya maisena ya te sauga ya i mina, inoke tamama i nunuwana-an nabiyan.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Tonowak, inoke u baem eliyama u ola, ‘Nuku ahe ge nuku pwatanim eliyau na kite.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Inoke anam ha lahe ha ba, ‘Geman o nige bosowaina tamama ni eguluwan. Ebo ni ginol ola, nasi tamama ni yaomal.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Yaa u baem eliyama u ba, ‘Ebo nige alomiu talimiu nuku nenem, he nige na tatalam nuku tutuk ge nuku kikiteyau.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sauga ha sikal tamama elana, inoke hauna toto u baunan eliyama ha wasaan eliyana. ");
INSERT INTO mpx_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Yaka abwe sauga etega al i baem eliyama i ba, ‘Ku sikal nuku na aanan enuna al nuku pwamola.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Yaa ha baek elana ha ba, ‘Nige bosowaima naha nok. Ana siga ama melumelu nu talamwan aloma te naha nok. Ebo nige aloma ama melumelu naha nonok, he tologugui nige ni tatalam naha tutuk ge naha kikite.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Inoke tamama i baem eliyama i ba, ‘Ku atena ya te lagou Letiyeli natuwau bolau eluwa ya te i abil. ");
INSERT INTO mpx_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Etegana i eguluwagau, yaka nige al sauga etega ya kikite. Yaka ya nuwatu ge ya ba: Bwasumu sosokana iyaka i alatomwatomwa-an! ");
INSERT INTO mpx_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Inoke sauga ya nuwamiu toto ya al ge nuku aheya eliyau. Iyaka ya liki, ebo nak etega ni pwawa, nasi nuwanakina ni paaligau.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Tonowak, binimala ebo na sikal na na nam elana ge nige geman ya ni kikite, he nasi ni yaomal, kaiwena geman ya ana nuwan i bwata tamama elana, atena ununa te. Tamama iyaka i liki nabi, inoke ebo geman ya nige aloma naha nonok elana, nasi nuwanakina ni paaliga. ");
INSERT INTO mpx_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ge bugul etega al, ya bateli nam elana ya ba, ‘Nau geman na matahikan. Ebo nige na een pasikalim eliyam, he nau ya gegi owa nam eliyam, inoke yawaliu miminana ana woliwoli o ni minem eliyau.’ ");
INSERT INTO mpx_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Inoke tonowak, ya awanun eliyam nau geman abana na ahe ge na minaa te na tabwa wam totuwalali loloyowanina. He geman u talamwan alonau talinau nihi sikal. ");
INSERT INTO mpx_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nige bosowaiu na sikal nam elana ebo nige alou geman naha nonok. Bahiwa! Nige nuwau nak toto ni masal nam eliyana o na kite.” ");
INSERT INTO mpx_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yaka Yosepa atena i lomwan nabi, inoke nige al bosowaina ni palahikan wana totuwalali mataliyaa. Inoke i baek elal i ba, “Gegewemiu ku eguluwagau.” Iya maisena ya alonau ge talinau hi mina, yaka abwe totona i pamasal elal. ");
INSERT INTO mpx_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Inoke i kahin anana i bwata nabi. Itipita bolo hi miminaa noleleya wana kahin hi hago, yaka hi na bolo hi miminaa kin wana limiya wali wasa hi pek. ");
INSERT INTO mpx_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","He Yosepa i baek talinau elal i ba, “Nau Yosepa. Nam iyoho ya i minamina?” Yaa talinau nige bosowailiya anana nihi lahe, kaiwena hi lovakunan. ");
INSERT INTO mpx_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Inoke i baek elal i ba, “Ku nem gegeliwa.” Sauga talinau hi ginol ola, yaka abwe i ba, “Nau talimiu Yosepa, valila ku paliagau tolobisnes elal ge hi aheyau te ya nem e Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yaa bahi nuku papanuwanuwatu-agimiu ge totomiu nuku huhugaagimiu kaiwena ku paliagau te ya nem e. He Yabowaine te i patunau ya houwa awomiwa inoke gamagalau na pwamwalil bahi nihi yayaomal. ");
INSERT INTO mpx_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Baliman labuina te galebu bwabwatana panuwa i apapanak-an, yaa baliman nimala panuna iyoho i nenem, baliman o gamwaliyaa gamagalau nige eyowa nihi giginol ge enona nihi papahi. ");
INSERT INTO mpx_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yabowaine i patunau ya houwa awomiwa nuwana pwamwal bwabwatana ni ginol kaiwemiu yaka bahi nuku yayaomal, inoke tubutubunimiu ni gan panayawiya. ");
INSERT INTO mpx_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nige tage komiu ku patunau ge ya nem e, yaa Yabowaine te i patunau ya nem. Iya i teleyau ya tabwa kin ana tolabe bwabwatana. Wana panuwa ya matahikan, ge ya tologugui bwabwatana Itipita ana labi gegewena elana. ");
INSERT INTO mpx_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“He etimwawa nuku sikal nuku na nam elana ge nuku ba, ‘Natum Yosepa i ba ola hiwe: Yabowaine i teleyau panuwa Itipita ana labi gegewena ya logugui-an. Etimwawa nu nem eliyau, bahi nu matamatan. ");
INSERT INTO mpx_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nu minaa gegeliwa labi Gosen eliyana. Alomwau natumwau ge tubumwau nuku minaa o ginebi wami sipi, goti, bulumwakau ge wami bugubugul gegewena. ");
INSERT INTO mpx_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nu minaa Gosen inoke nau na matahikagiwa, kaiwena galebu ana baliman nimala panuna iyoho i nenem. Inoke bahi alomwau am heniheni ge wam bwasumu nuku miminanakina ge nuku gagalebu.’” ");
INSERT INTO mpx_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Inoke Yosepa i ba vevehe al talinau elal i ba, “Alomiu taliu hot Beniyamina iyaka ku kiteyau ge ku atena nau Yosepa te ya baaba eliyamiu e. ");
INSERT INTO mpx_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Nuku baek nam elana te nau ya towasawasa panuwa Itipita elana, ge bugul gegewena toto ku kitel nuku wasaan eliyana. Inoke etimwawa nuku ahe ge nuku pwatanim eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Inoke Yosepa i na alona talina Beniyamina hi holatomwal ge ali toto labui hi kahin. ");
INSERT INTO mpx_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yaka abwe talinau maisena ge maisena i holatomwal, i nalol ge i kahikahin. Toto o enaa, abwe talinau ateliya i matuwa yaka avaliya hi liwaliwan. ");
INSERT INTO mpx_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sauga wasa i vin kin wana limiya te Yosepa talinau hi nem elana, yaka alonau ge wana totuwalali bwabwatal hi yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Inoke baaba i patuna Yosepa elana i ba, “Nu baek talimwau elal, ‘Nuku ginol ni ola hiwe: Witi nuku usan wami donki pwataliyaa, ge nuku sikal nuku na panuwa Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Yaka tamamiu alonau ge natumiyau nuku ahel inoke nuku nem te eliyau. Nau abwe labi waiwaisana etega panuwa Itipita elana na pewa eliyamiu, inoke bilibili enona waiwaisana eliyana nuku anana.’ ");
INSERT INTO mpx_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ge nu baek talimwau elal, ‘Waga momomol enuna nuku aheya Itipita, inoke nuku pwatanik lagomiyau avaliyau ge natumiyau wawayau nuku usanil. Yaka tamamiu al nuku ahe ge alomiu nuku nem. ");
INSERT INTO mpx_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wami bugubugul bolo ebo nuku tataluwagil panuwa Kenani, bahi kaiweliya nuku nuwanuwatu, kaiwena nau abwe panuwa Itipita bugubugulina waiwaisal na pewa eliyamiu.’” ");
INSERT INTO mpx_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Inoke Yakobo natunau hi ginol ola to. He Yosepa waga momomol enuna i pek talinau elal i ola kin wana baaba, ge aanan enuna i pek al wali nawanawa kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","I ola al kaliko vavaluna i guyau talina maisena ge maisena elana, yaa mani silba tili handeled ge kaliko bosowaina gamagalau ali toto nimala panuna i pek Beniyamina elana. ");
INSERT INTO mpx_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yosepa Itipita bugubugulina waiwaisal enuna i ahe tamana kaiwena, i usanil donki elulutega elal, i ola al witi, beleid ge aanan ona i ahe tamana wana nem kamwasaa kaiwena, i usanil donki yowau elulutega elal, inoke i patunal tamana elana. ");
INSERT INTO mpx_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Inoke Yosepa talinau i patunal nihi egon. He wali sauga egon elana i baek elal i ba, “Bahi loapwaapwanawa kamwasaa.” ");
INSERT INTO mpx_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Inoke Itipita hi eguluwan, hi nawanawa hi na hi vin tamaliya Yakobo elana panuwa Kenani. ");
INSERT INTO mpx_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Inoke wana wasa hi pek hi ba, “Yosepa nige i yayaomal, iya iyoho i tologugui panuwa Itipita ana labi gegewena elana.” Tamaliya wasa o i hago, yaka atena i you nuwana i gewagewa, nige wali wasa i aabulilek-an. ");
INSERT INTO mpx_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yaa sauga Yosepa wana baaba gegewena elal hi wasaan elana, ge sauga waga momomol i kitel bolo Yosepa i patunal ge ni heya ni na Itipita, yaka abwe wana nuwatu i sapu. ");
INSERT INTO mpx_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Inoke i baek elal i ba, “Oo, age tunahot! Age natu Yosepa iyoho ya i molu nige i yayaomal. Na nok na na na kite ga mulaa abwe na yaomal.” ");
INSERT INTO mpx_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakobo wana bugubugul gegewena i abubun, yaka abwe alonau ana heniheni ge wana bwasumu gegewel hi telipuna hi nawanawa Itipita kaiwena. Sauga hi na hi vin panuwa Biyaseba, inoke Yakobo bwasumu enuna i powonan tamana Aisake wana Yabowaine elana. ");
INSERT INTO mpx_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bulina pankite etega elana Yabowaine i baaba Yakobo elana i ba, “Yakobo! Yakobo!” Yakobo i talam i ba, “Oo, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Inoke Yabowaine i ba, “Nau Yabowaine, tamwam wana Yabowaine. Bahi nu lolovakun nok Itipita, kaiwena nau na labewa yaka panuwa o elana tubutubumwau nihi tabwa boda bwabwatana. ");
INSERT INTO mpx_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nau alou owa ta nok Itipita, ge nau abwe tubutubumwau na ahel nihi sikalim te. He Yosepa iya abwe aem ni kin.” ");
INSERT INTO mpx_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Inoke Yakobo panuwa Biyaseba i eguluwan. He natunau Yakobo hi usan waga momomol elana, i ola al lagoliyau ge natuliyau wawayau hi usanil waga momomol elal, bolo Itipita wali kin i patunal ge nihi heya. ");
INSERT INTO mpx_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Wali bwasumu ona ge wali bugubugul bolo hi aheliya panuwa Kenani hi bugulagil avaliyau hi nok. Inoke Yakobo alonau ana heniheni gegewel, natunau bolau, natunau yowau, tubunau melubolau ge tubunau meluyowau, hi na Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","He boda Isileli, Yakobo ana heniheni, bolo alonau hi na Itipita alaliya i ola hiwe. Lubeni, iya Yakobo natunau ali gamaun. ");
INSERT INTO mpx_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Lubeni natunau bolau alaliya hiwe: Hanok, Palu, Hesiloni ge Kami. ");
INSERT INTO mpx_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyon natunau bolau alaliya hiwe: Yemuwel, Yamin, Ohad, Yakin, Sohal ge Saul iya hinana panuwa Kenani yovana. ");
INSERT INTO mpx_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libai natunau bolau alaliya hiwe: Gelison, Kohat ge Melali. ");
INSERT INTO mpx_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda natunau bolau alaliya hiwe: El, Onan, Sila, Peles ge Selaa. (He El alona ge Onan hi yaomalek panuwa Kenani.) Peles natunau bolau alaliya Hesiloni ge Hamul. ");
INSERT INTO mpx_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka natunau bolau alaliya hiwe: Tola, Puwa, Yasub ge Similon. ");
INSERT INTO mpx_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuloni natunau bolau alaliya hiwe: Seledi, Elon ge Yalil. ");
INSERT INTO mpx_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","He Lubeni, Simiyon, Libai, Yuda, Isaka ge Sebuloni heliya Leya natunau, Yakobo lagona etegana. Natunau o i abiliek Mesopoteimiya. I ola al Leya natuna meluyovana Daina i ab. Leya natunau ge tubunau bolo o gegewel ali gewi teti tili (33). ");
INSERT INTO mpx_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada natunau bolau alaliya hiwe: Sepon, Hagi, Suni, Esbon, Eli, Alodi, ge Aleli. ");
INSERT INTO mpx_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseli natunau bolau alaliya hiwe: Imna, Isba, Isbi ge Belaiya. He nuliya alana Seila. Belaiya natunau bolau alaliya Hebel ge Malkiyel. ");
INSERT INTO mpx_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Gamagalau o heliya Yakobo alona ge Silpa natuliyau ge tubuliyau, ali gewi sikistin (16). He Leiban Silpa i pek natuna Leya elana wana totuwalali yovana. ");
INSERT INTO mpx_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Letiyeli, iya Yakobo lagona eluwana, natunau bolau heliya Yosepa ge Beniyamina. ");
INSERT INTO mpx_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Itipita elana Yosepa lagona Asinata, iya panuwa Heliyopolis wali topowon Potipela natuna, natunau bolau Manasa ge Ipileimi i abil. ");
INSERT INTO mpx_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beniyamina natunau bolau alaliya hiwe: Bela, Bekel, Asbel, Gela, Naman, Ehi, Losi, Mupim, Hupim, ge Adi. ");
INSERT INTO mpx_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bolau o heliya Yakobo alona ge Letiyeli natuliyau ge tubuliyau, ali gewi potin (14). ");
INSERT INTO mpx_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani natuna tauina alana Husim. ");
INSERT INTO mpx_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napitalai natunau bolau alaliya hiwe: Yasiyel, Guni, Yesa ge Silem. ");
INSERT INTO mpx_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bolau o heliya Yakobo alona ge Bilha natuliyau ge tubuliyau, ali gewi seben. He Leiban Bilha i pek natuna Letiyeli elana wana totuwalali yovana. ");
INSERT INTO mpx_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Inoke Yakobo natunau ge tubunau bolo alonau hi na panuwa Itipita ali gewi sikisti sikis (66), yaa natunau lagoliyau yowau nige ali gewi hi vavasili toyawel. ");
INSERT INTO mpx_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Inoke ebo Yosepa natunau labui bolo i abil Itipita elana ta ahel al, yaka Yakobo ana heniheni bolo hi na Itipita ali gewi sebenti (70). ");
INSERT INTO mpx_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","He Yakobo Yuda i patuna i houwa i na Yosepa elana, yaka i baek elana aloliya nihi petupatupa-agil labi Gosen. He Yakobo alonau ge ana heniheni iyaka hi na hi vin labi Gosen, ");
INSERT INTO mpx_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","inoke Yosepa wana waga momomol i lovivina-an ge i heya i na tamana Yakobo, alana etegana al Isileli, ni kite. Sauga hi petupatupa-agil, inoke Yosepa tamana i holatomwa ge i kahikahin sauga i yapu. ");
INSERT INTO mpx_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yaka Isileli i baek Yosepa elana i ba, “Sauga ya bosowaiu na aliga, kaiwena iyaka totou matawa ya kitewa ge ya atena owa iyahe nige ga u yayaomal.” ");
INSERT INTO mpx_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Inoke Yosepa i baek talinau ge tamana ana heniheni elal i ba, “Na nok kin elana ge na ba, ‘Taliwau aloliyau nam ge ana heniheni hi miminek panuwa Kenani, he heliya iyoho hi nem elau. ");
INSERT INTO mpx_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","He bolau o heliya sipi ge bulumwakau ali tomatahikan, inoke wali sipi, wali bulumwakau ge wali bugubugul gegewena hi ahel te hi nem e.’ ");
INSERT INTO mpx_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Yaka sauga ebo kin ni yoga tukagimiu ge ni nelimiu ni ba, ‘Hauna wami tuwalali?’ ");
INSERT INTO mpx_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","inoke anana nuku lahe nuku ba, ‘Tonowak! Ama wam totuwalali bwasumu ali tomatahikan, i telipunaa wama sauga geman ana siga sauga ya, i ola valila tubumeyau hi giginol.’ Nuku ba ola o, inoke ni talam nuku minaa te labi Gosen elana, ge ami bwaga ni gan Itipita elal, kaiwena heliya nige nuwaliya i oola sipi ali tomatahikan.” ");
INSERT INTO mpx_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yaka abwe Yosepa i sikal i na kin elana ge i ba, “Nam ge taliwau hi neem labi Kenani elana avaliyau wali sipi, wali bulumwakau ge wali bugubugul gegewena, heliya iyoho labi Gosen elana.” ");
INSERT INTO mpx_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Inoke abwe talinau ali toto nimala panuna i ahel ge i en tukagil kin manininaa. ");
INSERT INTO mpx_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Yaka kin i nel Yosepa talinau elal i ba, “Hauna wami tuwalali?” Anana hi lahe hi ba, “Tonowak! Ama wam totuwalali sipi ali tomatahikan, i ola valila tubumeyau hi giginol. ");
INSERT INTO mpx_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ha nem ge naha minaa ga te panuwa ya elana sauga kekeisi, kaiwena galebu i bwata hot labi Kenani elana, inoke nige wama sipi aliya i gagan. He ha awanun elam ge nu talam ama wam totuwalali naha minaa labi Gosen elana.” ");
INSERT INTO mpx_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Inoke kin i baek Yosepa elana i ba, “Tamwam ge talimwau iyaka hi nem eliyam ge alomwau nuku mina, ");
INSERT INTO mpx_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","inoke Itipita labena gegewena i mwapwela eliyam. Labi waiwaisana hot etega nu hile, yaka tamwam ge talimwau nihi minaa. He nihi minaa labi Gosen. Ebo gamwaliyaa enuna u atenal wali aatena i bwata, inoke nu telel no bulumwakau nihi matahikagil.” ");
INSERT INTO mpx_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Inoke abwe Yosepa i na tamana i en tukan kin manininaa, ge Yakobo kin ana ba awatauwan i baunan elana. ");
INSERT INTO mpx_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Yaka kin i nel elana i ba, “Wam baliman ana bwata ehila?” ");
INSERT INTO mpx_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Anana Yakobo i lahe i ba, “No galanawanawa panuwa ge panuwa ona elal yawaliu ana baliman ana bwata wan handeled ge teti (130). He no baliman nige hi gegewi ge pulowan hi gewi ya pwawal. Nam alona ge tubu wali galanawanawa panuwa ge panuwa ona elal yawaliliya ana baliman i bwata, yaa nau yawaliu ana baliman nige i bwabwata.” ");
INSERT INTO mpx_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Inoke kin ana ba awatauwan i baunan al elana ge i eguluwan. ");
INSERT INTO mpx_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Inoke Yosepa labi waiwaisana hot etega i hile Itipita gamwanaa panuwa Lamesese ana labiya, Gosen gamwanaa, yaka i pek tamana ge talinau elal ge hi minaa, i ola kin wana baaba. ");
INSERT INTO mpx_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","He Yosepa tamana, talinau ge tamana ana heniheni gegewel aanan i pekpek elal, i golugoluwa natuliyau ali gewi elana. ");
INSERT INTO mpx_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Galebu iyaka i bwata nabi yaka nige al aanan i gagan labi gegewena elana, inoke panuwa Itipita ge Kenani galebu kaiwena hi wesal. ");
INSERT INTO mpx_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Gamagalau hi nemnem witi hi pwapwamola, inoke eliyana Yosepa Itipita ge Kenani wali mani gegewena i ahe, yaka i bugulan ge i na i pwahin kin wana gogomwau ana abateliya. ");
INSERT INTO mpx_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sauga Itipita ge Kenani wali mani gegewena iyaka hi palian haba, inoke Itipita gegewel hi na Yosepa elana ge hi ba, “Wama mani gegewena iyaka ha pwamowasi. He aanan u guyauan eliyama ge naha an! Bahi naha aaligaa matamwa!” ");
INSERT INTO mpx_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yaka analiya Yosepa i lahe i ba, “Ebo wami mani gegewena iyaka ku pwamowasi, he wami bwasumu nuku pwatanim eliyau, yaka molana aanan na pewa.” ");
INSERT INTO mpx_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Inoke wali bwasumu hosi, sipi ge goti, bulumwakau ge donki hi pwatanik Yosepa elana, yaka molana aanan i guyauan elal. He baliman o Yosepa i ginol ola to, yaka wali bwasumu gegewel hi pek elana aanan molana. ");
INSERT INTO mpx_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yaka baliman etega al ana abatelipuna elana gamagalau hi na Yosepa elana ge hi ba, “Tonowak, nige bosowaina ama pulowan naha sume eliyam. Wama mani gegewena iyaka ha pwamowasi, ge wama bwasumu iyaka ha paliagil eliyam. Nige bugul etega i gagan eliyama tage naha pewa ge molana aanan nu pem, toto i minaa elama iyai te ama ge wama bilibili. ");
INSERT INTO mpx_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Bahi naha aaligaa matamwa ge wama bilibili ni mimibwagabwaga! He aloma ge wama bilibili naha paliagima eliyam, yaka molana aanan nu pem. Inoke ama naha tabwa kin wana totuwalali loloyowanil ge wama bilibili ni minek eliyana. He witi nu pem eliyama, yaka eliyana naha anana ge bahi naha aaliga. Ge pwatum nu pem naha luwan, yaka wama bilibili bahi ni tatabwa bilibili bwagabwaga.” ");
INSERT INTO mpx_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","He galebu iyaka i bwata hot yaka Itipita gegewel wali bilibili hi paliagil Yosepa elana. Inoke Itipita bibilena gegewena i pwamola i tabwa kin wana bilibili. ");
INSERT INTO mpx_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yaka Itipita ana labi gegewena gamagaliliyau hi tabwa kin wana totuwalali loloyowanil. ");
INSERT INTO mpx_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Yaa Itipita wali yabowaineyau ali topowon wali bilibili Yosepa nige i pwapwamola. Heliya nige wali bilibili hi papalian, kaiwena kin aanan i pekpek elal ge eliyana hi anana. ");
INSERT INTO mpx_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yaka Yosepa i baek gamagalau elal i ba, “He lan ebe alomiu wami bilibili iyaka ya pwamolamiu kin kaiwena. He aanan vivena hiwe, ku ahe ge nuku na nuku luwan wami eyowaa. ");
INSERT INTO mpx_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sauga ebo aanan ni matuwa ge nuku pahi, yaka pwahin nimala panuna nuku ginolil, ge maisena nuku pek kin kaiwena. Yaka pwahin esopali nuku kukuhikan, enuna wami vivi kaiwena, ge enuna aamiu, alomiyau natumiyau ge wami limi ana heniheni.” ");
INSERT INTO mpx_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Inoke gamagalau hi baek Yosepa elana hi ba, “Tonowak, owa u ginol bubun eliyama ge yawalima u pwamwal, he ha talam naha tabwa kin wana totuwalali loloyowanil.” ");
INSERT INTO mpx_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Inoke Yosepa logugui etega i ginol Itipita kaiweliya. Ebo wali eyowa enona ni matuwa ge nihi pahi, yaka pwahin nimala panuna nihi ginolil ge maisena nihi pek kin elana. He logugui o iyoho i gangan sauga ya elana. Iyai te topowon wali bilibili nige kin i aahe, inoke nige enona enuna hi pepek kin elana. ");
INSERT INTO mpx_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Boda Isileli hi minaa labi Gosen elana panuwa Itipita, ge hi gogomwau hot. Inoke hi talaabab ge hi gewi nabi. ");
INSERT INTO mpx_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","He Yakobo i minaa panuwa Itipita elana baliman ana gewi sebentin (17), inoke yawalina ana baliman ana bwata wan handeled ge poti seben (147). ");
INSERT INTO mpx_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Sauga amnana i anbose wana yaomal ana sauga iyaka i kelakelaubwa, inoke natuna Yosepa ana baaba i patuna ge i nem elana. Inoke i baek elana i ba, “Ebo u nunuwana-agau nabiyan, yaka nimwam u teliya nagiliu gabulanaa, inoke nu bateli te nu awatauwagau ge nu ginol ni ola no baaba. He bahi tuwau nu teteliya Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yaa sauga na yaomal, yaka tuwau nu kalivai egonan Itipita elana ge nu na nu teliya nam ge tubu wali salaiya.” Anana Yosepa i lahe i ba, “Na ginol ola toto u baunan eliyau.” ");
INSERT INTO mpx_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Inoke i baek Yosepa elana i ba, “Nu papasila eliyau te nasi nu ginol ola o.” Inoke Yosepa i papasila. Yaka abwe Isileli wana suki i ahe ge i gena palalek suki kokowanaa, yaka i tapwalolo Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sauga etegana al, abwe Yosepa wana wasa hi pek hi ba, “Tamwam i kasiyebwa.” Inoke natunau bolau eluwa Manasa ge Ipileimi i ahel ge alonau nihi na tamana nihi kite. ");
INSERT INTO mpx_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sauga hi na hi vin, yaka gamagal etega Yakobo wana wasa i pek i ba, “Natum Yosepa iyahe i vin nuwana ni kitewa.” Inoke Yakobo, alana etegana al Isileli, i logasisi ge i lut i misiyo wana abakenu pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Inoke i baek Yosepa elana i ba, “Yabowaine Togasisi Hot i masal eliyau panuwa Lus elana labi Kenani, ge i ba muloluagau ");
INSERT INTO mpx_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","i ba, ‘Nau abwe natumwau nihi gewi na pewa ge tubutubumwau nihi tabwa boda bwabwatana ali un tomaha tomaha, ge bilibili ya na pek eliyalil ni mihot.’” ");
INSERT INTO mpx_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yaka i ba vevehe al i ba, “Natumwau bolau labui Ipileimi ge Manasa lagom i abil panuwa Itipita elana ge mulaa abwe ya nem, heliya nihi tabwa natuwau hot, ni ola natuwau Lubeni ge Simiyon. ");
INSERT INTO mpx_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Yaa ebo wawayau enuna mulaa abwe lagom ni abil, heliya natumwau, wali bilibili ni noem Ipileimi ge Manasa alaliya bibilena elana. ");
INSERT INTO mpx_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ya ginol ola o, kaiwena hinam Letiyeli natunau labui ya ge i yaomal. Sauga labi Mesopoteimiya ha eguluwan ge ha nawanawa, inoke i yaomala kamwasaa labi Kenani elana, nige ana bwaga i yayapu awan Epalat elana. Inoke alou no nuwanak tuwana ya teliya Epalat ana kamwasa bebenaa.” (Epalat, he Bedeliyema alana houhouwena.) ");
INSERT INTO mpx_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sauga Isileli Yosepa natunau bolau eluwa i kitel, inoke i nel i ba, “Henalau ya?” ");
INSERT INTO mpx_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yaka Yosepa i ba, “Natuwau te. No minamina panuwa Itipita elana Yabowaine i pem.” Inoke Isileli i ba, “U ahel nihi nem eliyau ge na ba muloluagil.” ");
INSERT INTO mpx_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","He Isileli matana i pweyata nige bosowaina bugul ni kite bubun, kaiwena iyaka i liki nabi. Inoke Yosepa natunau i ahel ge i na i telel tamana gegelinaa, yaka Isileli i holatomwal ge i nalol. ");
INSERT INTO mpx_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yaka i baek Yosepa elana i ba, “Valila ya nuwatu tage nige al na kikitewa, yaa Yabowaine i talamwagau inoke sauga ya alomwau ge natumwau ya kitemiu.” ");
INSERT INTO mpx_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yaka Yosepa natunau i ahel Isileli aenaa ge i kululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Inoke abwe natunau labui i pihikagil, Ipileimi i minaa nimana labena awonaa, Isileli nimana labena gegebana i awoni, ge Manasa i minaa Yosepa nimana labena gegebanaa, Isileli nimana labena awona i awoni. Yaka abwe i pwatanik i na i teleliya Isileli gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yaa Isileli nimana i teli pil, awona i teliya toto kekeisi Ipileimi kokowanaa, ge gegebana i teliya gamaun Manasa kokowanaa. ");
INSERT INTO mpx_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Inoke Isileli Yosepa i ba muloluan i ba: Yabowaine toto tubu Abalahama ge nam Aisake hi mipalalek elana, Yabowaine toto yawaliu ana sauga bwalibwaligena i matahikagau i ola sipi ali tomatahikan, ");
INSERT INTO mpx_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yabowaine toto i ola anelose i pwamwalau nak gegewena elana iya gemanau ya ni muloluagil. Ya awanun nau alau, tubu Abalahama alana, ge nam Aisake alana nihi mihot eliyalil, ge natuliyau nihi gewi nihi talaabab inoke tubuliyau nihi debalala panayawiya. ");
INSERT INTO mpx_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","He mulaa abwe Isileli gemanau i ba muloluagil, Yosepa i kite tamana nimana labena awonaa i teliek Ipileimi kokowanaa, yaka nige i yayaliyaya-an. Inoke tamana nimana i pihikan tage ni ahek yoho Ipileimi kokowanaa ge ni teliek Manasa kokowanaa. ");
INSERT INTO mpx_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yaka i baek elana i ba, “Nam, bahiwa! Manasa iya te gamaun. Nimwam awom nu teliek kokowanaa.” ");
INSERT INTO mpx_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Yaa tamana nige wana nuwatu i oola, inoke i baek Yosepa elana i ba, “Natu, ya atena ya te hauna ya giginol. Manasa iya al ge alana ni bwata ge tubutubunau nihi tabwa boda etega. Yaa talina kekeisena iya te alana ni bwata hot ge tubutubunau nihi tabwa boda bwabwatana hot.” ");
INSERT INTO mpx_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Inoke lan o i ba muloluagil i ba, “Sauga ebo boda Isileli ba mulolu nihi baunan, alamiu nihi lumen nihi ba, ‘Ha awanun Yabowaine ni muloluagimiu ni ola Ipileimi ge Manasa.’” Inoke Ipileimi alana i teli houwan ge Manasa alana i teli mulaa. ");
INSERT INTO mpx_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Yaka Isileli i baek Yosepa elana i ba, “Sauga kekeisi na yaomal, yaa Yabowaine ni minaa eliyamiu ge ni ahemiu nuku sikal nuku na tubumiyau wali labiya. ");
INSERT INTO mpx_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","He labi Sekemi bibilena malumalulina ya pewa eliyam, nige ya pepek talimwau elal. No elohaveyan kilepana alona ge no egipoyo elal ya lohaveyani, inoke bilibili o ya aheya boda Amoli elal.” ");
INSERT INTO mpx_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Inoke Yakobo natunau bolau i yoga gogonil ge i baek elal i ba, “Ku mipahipahi gegeliwa, ge na baewa eliyamiu hauna gun abwe nihi gan eliyamiu sauga i nenem elana. ");
INSERT INTO mpx_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nau Yakobo natuwau, ku nem ku migogo gegeliwa,   nau tamamiu Isileli no baaba nuku laeganan. ");
INSERT INTO mpx_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Lubeni, owa natu o gamaun,   no gasisi saugena enowana houwan,   alam i miha ge u gasisi hot, talimwau gegewel u lakel. ");
INSERT INTO mpx_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Yaa wam ginol i ola banata nige bosowaina ta pal,   inoke nige al talimwau nu bwabwata lakel, kaiwena u na no abakenuwa yaka alom ge lagou etega ku kenu,   u ganawali, yaka u papuluwawi-agau. ");
INSERT INTO mpx_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simiyon ge Libai, alom ge talim ku olaolaek ya,   wami elohaveyan kilepana ku patuwalaliek nak ana ginol elana. ");
INSERT INTO mpx_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ginebi wami huga gamagalau ku gulil,   ge totomiu wami nuwatu elana bulumwakau aeliya ana tubwi ku goapwalil. Toto o kaiwena nige na tutuk wami boda elana,   ge nige na tutubwi wami pwahin elana. ");
INSERT INTO mpx_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Yehoba ni apapanak-agimiu, kaiwena wami huga i gasisi   ge wami ginol likalika i bwata. He tubutubunimiu na walel nihi miwaliwali Isileli ana labi ona elal   ge nihi minaa ana un tomaha tomaha gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda, talimwau nihi tobalagiwa,   tamwam natunau nihi kululu elam,   kaiwena am topihigelgel mwamwaliliya nu piatati ge nu pakokovel. ");
INSERT INTO mpx_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, owa nu ola laiyoni hevalina, nu gasisi ge nu tologugui.   Natu, nu ola laiyoni ana mwa i alapaaliga i an yaka i sikal abanaa, inoke i lomisiyo lau ge i tal kenu.   He henala ni palut? Nige etega! ");
INSERT INTO mpx_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kin wali suki ni miminaa ya Yuda nimwamwa,   ge sauga gegewena tubutubumwau nihi tologugui, ana siga gamagal toto iya wana bugul hot ni nem ni ahe,   iya boda gegewel awana nihi ab. ");
INSERT INTO mpx_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wam donki nu gimwana oine nuwana elana,   ge wam donki natuna nu am hikana oine sisiuina waiwaisana elana. Am kama oine suina elana nu ul,   ge am holahola yayapona oine ununa elana nu ul. ");
INSERT INTO mpx_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Am oine ni bwata yaka matam ni paket,   am hul suina ni balu yaka ninim ni pawawakeki. ");
INSERT INTO mpx_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebuloni, owa nu minaa hoga bebenaa,   yaka wam galowa waga wali abaveyaho waiwaisana.   Wam bilibili ni na ana siga labi Saidoni elana. ");
INSERT INTO mpx_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka, owa nu ola donki gasigasisena,   yaa yayaluwana i pweyata alona ge ana kaval i kenukenu. ");
INSERT INTO mpx_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Abamina waiwaisana   ge panuwa ana awa waiwaisana nu kite nu minaa, yaa abwe boda getoga nihi paloloyowan-agiwa   ge kaval pupulowanina nihi pahe vevelamwa. ");
INSERT INTO mpx_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani, owa wam gamagalau nu logugui-agil,   ni ola Isileli ali un maisena ge maisena hi logugui-agil. ");
INSERT INTO mpx_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani, haveyan elana nu siba nu ola mwata kamwasa elana,   nu ola weso kela bebenaa, toto sauga hosi etega ni nem, yaka aena ena ni tal,   inoke toto i heya pwatanaa ni soguek enaa. ");
INSERT INTO mpx_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Yehoba, ya matamatan kaiwem ge nu pwamwalau. ");
INSERT INTO mpx_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada, tolohaveyan kaluoyaoya kaiwena nihi tuk nihi haveyan elam,   yaa owa nu haveyan elal ge nu takel. ");
INSERT INTO mpx_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aseli, wam bilibili enowana ni waisi,   aanan amnana poposana toto kin nunuwaliya ni neem eliyam. ");
INSERT INTO mpx_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napitalai, owa nu ola bwasumu diya toto i patalelu nemnowa,   ge natunau i abil ali awa waiwaisal. ");
INSERT INTO mpx_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosepa, owa nu ola oine enoenonina,   puna i siuna wewel kenken bebenaa ge i enon nabi,   lalana gana hi lema likaan. ");
INSERT INTO mpx_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gamagalau ginebi wali ati elolol nihi haveyan elam,   ge aloliya wali pihigelgel wali egipoyo nihi alihinewa elam. ");
INSERT INTO mpx_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yaa nimwam ni mweyaha ge ni gasisi,   wam egipoyo nu alihin pwamwaun, kaiwena Yakobo wana Yabowaine Gasigasisena nimana elana ni labewa,   iya alana al Sipi ali Tomatahikan ge Isileli ali Libu. ");
INSERT INTO mpx_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Tamwam wana Yabowaine ni labewa,   Yabowaine Togasisi Hot ni muloluagiwa. Ni muloluagiwa ni ba kehe ni loem labulabumwa,   ni muloluagiwa wewel ni patub heyan bilibiliya,   ni muloluagiwa wam bwasumu ge tubutubumwau nihi gewi. ");
INSERT INTO mpx_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nau tamwam no ba mulolu i bwata hot,   mulolu toto nu pwawa oya mihahaina ni heluwan,   waisi toto nu pwawa oya mihomihotil ni lakel. Mulolu gegewena o nihi minaa owa Yosepa eliyam,   owa u getoga talimwau gegewel elal, alam i bwata hot. ");
INSERT INTO mpx_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniyamina, owa nu ola wanuka bekikina toto iyauka i sibaan,   mweluluga elana ana mwa ni alapaaliga ni an,   ge kokoyavi elana bugul bolo i kaluoel ni guyauan ana boda elal.” ");
INSERT INTO mpx_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","He bolau gegewel o heliya Isileli ali un elulutega eluwa. Ali ba mulolu tamaliya i vavaen eliyalil i ola to, i golugoluwa maisena ge maisena ana ba mulolu toto iya i bosowaina. ");
INSERT INTO mpx_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakobo natunau i ba muloluagil i mowasi, inoke i ba pagasisel i ba, “Sauga kekeisi na aliga ge na na tubuwau bolo hi aliga houwan elal. Tuwau nuku ahe nuku na labi Kenani ge nuku teliya tubuwau ali salaiya, pat golina elana Epiloni Hiti gamagalina wana bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","He pat golina o i minaa Makpela elana panuwa Mamele gegelinaa labi Kenani. Valila gol o alona ge bilibili Abalahama i pwamolaa Epiloni Hiti gamagalina elana wana salai. ");
INSERT INTO mpx_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Gol o elana te Abalahama alona lagona Sela, ge Aisake alona lagona Lebeka hi teleliya. Inoke nau al Leya ya teliya to. ");
INSERT INTO mpx_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He bilibili o alona ge pat golina, Abalahama i pwamolaa boda Hiti elal.” ");
INSERT INTO mpx_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sauga Yakobo ba pagasisi i baunan haba natunau elal, inoke aena i teli heyan wana abakenuwa ge i tal kenu, yaka wana yana i yana yoho ge i aliga, i na tubunau bolo hi aliga houwan elal. ");
INSERT INTO mpx_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosepa i kite tamana yawalina iyaka i mowasi, inoke i talpo pwatanaa, yaka maninina i nalo ge i kahikahin. ");
INSERT INTO mpx_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Inoke abwe i ba doketa bolo hi tuwalali elana tamana Isileli tuwana nihi abubun, yaka sawasawal ona nihi telek ge bahi ni bwebweyan. Inoke hi ginol ola to. ");
INSERT INTO mpx_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","He lan ana gewi poti tuwana hi abubun ge sawasawal ona hi telek, kaiwena toyaomal tuwana ana abwabubun ana lan ana gewi i ola to. Ge Itipita Yakobo baena hi nuwanak lan ana gewi sebenti (70). ");
INSERT INTO mpx_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wali nuwanak ana sauga i mowasi, yaka abwe Yosepa i baek kin wana totuwalali bwabwatal elal i ba, “Ebo ku yaliyaya-agau, yaka nuku na kin elana ge no baaba nuku baunan nuku ba, ");
INSERT INTO mpx_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Valila nam wana yaomal ana sauga i kelakelaubwa, inoke i ba ya papasila eliyana te ebo ni yaomal, yaka tuwana na ahe ge na na na teliya aban toto i lovivina-an labi Kenani elana. He u talamwagau na na nam tuwana na teli, yaka abwe na sikalim.’” ");
INSERT INTO mpx_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Inoke Yosepa wana baaba ana lahena kin i patuna pasikal i ba, “Tamwam tuwana nu ahe ge nu na nu teli, ni ola wam bateli elana.” ");
INSERT INTO mpx_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yaka Yosepa alonau kin wana totuwalali bwabwatal gegewel—tonowakau bolo hi tuwalaliya kin wana limiya, ge Itipita ana tonowakau gegewel—hi na tamana tuwana nihi teli. ");
INSERT INTO mpx_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","I ola al Yosepa wana limi ana heniheni gegewel, ge talinau avaliyau tamana wana limi ana heniheni alonau hi nok. He natuliyau ya te avaliyau bwasumu sipi, goti ge bulumwakau hi eguluwagil labi Gosen elana. ");
INSERT INTO mpx_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bolo hi heya waga momomol elana ge bolo hi heya hosi pwataliyaa avaliyau hi nok. He boda bwabwatana hot te hi nowanik teliteli kaiwena. ");
INSERT INTO mpx_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Sauga hi na hi vin panuwa Atad wali witi musana ana abaasiasi elana wewel Yolidani labenaa, inoke toyaomal baena hi kahin lopili analiya i bwata hot. Yaka Yosepa nuwanak ana pagan i ginol tamana kaiwena lan ana gewi seben. ");
INSERT INTO mpx_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","He Kenani towohiliyau bolo hi miminaa o, sauga hi kite boda hi lolokahin lopili panuwa Atad elana, inoke hi ba, “Itipita nuwanak ana kahikahin hi kahikahini.” Yaka panuwa o alana hi tun Ebel Mislaim. ");
INSERT INTO mpx_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yaka Yakobo natunau bolau hi ginol ola valila tamaliya wana ba pagasisi elal. ");
INSERT INTO mpx_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Tamaliya tuwana hi kalivai hi na labi Kenani elana, ge hi teliya pat golina toto i minaa Makpela elana panuwa Mamele gegelinaa. Pat golina toto o alona ge bilibili, valila Abalahama i pwamolaa Epiloni Hiti gamagalina elana wana salai. ");
INSERT INTO mpx_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosepa tamana tuwana hi teli salaiya i mowasi, inoke alonau talinau ge bolo hi nowanik teliteli kaiwena gegewel hi sikal hi na Itipita. ");
INSERT INTO mpx_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yosepa talinau hi kite te tamaliya iyaka i yaomal, inoke hi ba, “Bi ola ge Yosepa iyoho ya i hugahuga kaiwela, ge nuwana nak gegewena toto valila ta ginol elana ni ginol lahe elala?” ");
INSERT INTO mpx_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Inoke baaba hi patuna elana hi ba, “Valila tamala mulaa abwe i yaomal i baem eliyama i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nuku baek Yosepa elana nuku ola: Ya awanun talimwau wali gegi ge nak toto valila hi ginol eliyam nu nuwayoho.’ Inoke ama tamwam wana Yabowaine wana totuwalali, ha awanun elam wama gegi nu nuwayoho.” Sauga Yosepa baaba o i hago, inoke nuwana i nak ge i kahin. ");
INSERT INTO mpx_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Yaka abwe talinau hi nok elana ge hi kululu manininaa ge hi ba, “Ama wam totuwalali loloyowanil.” ");
INSERT INTO mpx_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yaa Yosepa i baek elal i ba, “Bahi nuku lolovakun! Nau nige Yabowaine i oola ge tage na payatala-agimiu. ");
INSERT INTO mpx_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Valila komiu nuwamiu nuku apanakau, yaa Yabowaine i pil waisi i ginoliya, yaka gamagalau hi gewi i pwamwalil ge nige hi yayaomal, i ola te ta kite lan ebe. ");
INSERT INTO mpx_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bahi nuku lolovakun! Nau abwe alomiyau ge natumiyau na matahikagimiu.” Inoke baaba meimeina elana i baaba talinau elal ge ateliya i ba pamatuwa. ");
INSERT INTO mpx_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosepa i miminaa panuwa Itipita elana alonau ge tamana ana heniheni gegewel. He wana baliman ana bwata wan handeled ge ten (110) i pwawa. ");
INSERT INTO mpx_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yaka wana minamina o elana natuna Ipileimi natunau, natuliyau, ge natuliyau, ha eton o, i kitel ga. I ola al, sauga Manasa natuna Makil, natunau hi abil, yaka hi telel Yosepa aenaa, kaiwena iya tubutubunau. ");
INSERT INTO mpx_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Inoke i baek talinau elal i ba, “Sauga kekeisi na yaomal, yaa tunahot Yabowaine ni matahikagimiu ge ni ahemiu nuku tagil labi ya elana, nuku na nuku minaa labi toto wana bateli i papasila-an ni pek Abalahama, Aisake ge Yakobo elal.” ");
INSERT INTO mpx_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Inoke i baek talinau elal i ba, “Tunahot Yabowaine ni matahikagimiu ge ni ahemiu nuku na labi o elana, inoke nuku papasila te sauga o elana tutuwau al nuku kalivai.” ");
INSERT INTO mpx_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosepa wana baliman wan handeled ge ten (110) i pwawa, inoke i yaomala Itipita elana. Yaka tuwana hi abubun ge sawasawal ona hi teli, inoke hi usan kesi pat hi ginoliya gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakobo natunau bolau bolo alonau hi nok hi na Itipita avaliyau ge natuliyau alaliya i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubeni, Simiyon, Libai, Yuda, ");
INSERT INTO mpx_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Sebuloni, Beniyamina, ");
INSERT INTO mpx_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Napitalai, Gada ge Aseli. ");
INSERT INTO mpx_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Bolo ya Yakobo natunau ge tubunau ali gewi sebenti. He natuna Yosepa iyoho Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Hi minamina ee, yaka abwe Yosepa ge talinau, heliya ha bolo o, hi yaomal haba. ");
INSERT INTO mpx_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Yaa tubuliyau Isileli hi talaabab yaka hi gewi nabi, inoke Itipita hi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yaka abwe kin vavaluna etega hauna Yosepa i ginol Itipita wasana nige i aatena i milil ge i tologugui Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","I baek wana gamagalau eliyalil i ba, “Isileli iyaka hi gewi nabi, he kila wala abanak etega to. ");
INSERT INTO mpx_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Binimala ebo tolohaveyan enuna nihi vin, nasi Isileli nihi na avaliyau nihi boda pamaisena ge nihi haveyan elala, inoke wala panuwa nihi louluwan. He nuwatu etega ta ginol ge bahi nihi gegewi al.” ");
INSERT INTO mpx_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Inoke Itipita Isileli hi paloloyowan-agil. Ali tomatahikan hi telel tuwalali gasigasisena hi pek tage yawaliliya nihi apanak. Yaka Isileli taun bwabwatal Pitom ge Lamesese hi talil, kin wana bugul ana abapwahipwahin. ");
INSERT INTO mpx_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yaa sauga Itipita Isileli yawaliliya hi apapanak-an, yaka heliya ali gewi i heheya ge wali awan hi pwabwaya al. Yaka Itipita hi lovakun Isileli eliyalil, ");
INSERT INTO mpx_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","inoke hi ba tuwalali pupulowanina hi ginol ge i papanuwaleyan-agil. Hi patuwalali-agil limi hi taltal ge eyowa hi awaawaginol, nige hi nunuwanak-agil. ");
INSERT INTO mpx_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Yaka Itipita wali kin i liwaliwan yowau labui, Sipila ge Puwa elal, heliya Hibilu yowauiliyau ali topapaab. ");
INSERT INTO mpx_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","I ba, “Sauga Hibilu yowauiliyau nuku label ab elana, ebo nihi ab melutau, yaka nuku pipaaliga. Yaa ebo meluyova, he nuku pwamolu.” ");
INSERT INTO mpx_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Yaa topapaab hi lovakun Yabowaine elana, inoke nige hi giginol ola kin wana baaba yaka nige melubolau hi pipipaaligal. ");
INSERT INTO mpx_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Inoke kin i ba topapaab hi nem elana ge i nelil i ba, “Hauna kaiwena ku ginol ola o? Hauna kaiwena bolau ku pwamolol?” ");
INSERT INTO mpx_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Anana hi lahe hi ola, “Hibilu yowauiliyau nige hi oola Itipita yowauiliyau. Heliya hi gasisi ge wali abab i mweyaha, inoke hi ab ga mulaa abwe ama ha vin.” ");
INSERT INTO mpx_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Yabowaine yowau labui i label totoliya natuliyau i pek elal, kaiwena hi lovakunan. Yaka Isileli ali gewi i haha al, ge hi gewi nabi hot. ");
INSERT INTO mpx_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Yaka abwe kin logugui i ginol ge i baek wana gamagalau gegewel elal i ba, “Hibilu wawayaliyau memelol bolo melutauil nuku aliyohil wewel Naile elana nihi unun, yaa bolo meluyowau nuku pwamolol.” ");
INSERT INTO mpx_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Saugena o elana tau etega ana un Libai alona yova etega ali un maisena hi alolon, ");
INSERT INTO mpx_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","- yaka yova i liyan ge i ab natuliya melutauina. I kite wawaya waiwaisana hot inoke i sume ana siga waikena eton. ");
INSERT INTO mpx_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Yaa sauga nige al bosowaina ni sume, yaka mwawin etega i ola kaliyou, alana papilas, i ahe egowa i ginoliya, ge i ebali. Yaka wawaya i loke ge i paota mwawin yayapona gamwaliyaa wewel Naile bebenaa. ");
INSERT INTO mpx_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Wawaya nuna i talmilil laha ge i gagayawa hauna ni masal elana. ");
INSERT INTO mpx_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Yaka kin natuna meluyovana i na i lau wewela i highig, ge wana totuwalali galokau hi nononawanawa wewel bebenaa. Yaka egowa i kite mwawin yayapona gamwaliyaa, inoke totuwalali loloyowanina meluyovana etega i patuna i na i ahe. ");
INSERT INTO mpx_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kin natuna egowa i pwela yaka wawaya melutauina i kite i kahikahin, inoke nuwana i nakan ge i ba, “Hibilu wawayana etega te.” ");
INSERT INTO mpx_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yaka nuna i na kin natuna elana ge i neli i ba, “Tab na nok Hibilu yovana etega na ba ni nem wawaya ni ahe ni matahikan ge ni papaalahul kaiwem?” ");
INSERT INTO mpx_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Inoke i talam i ba, “Ee, u nok.” Inoke galok o i na wawaya hinana hot i en pwatanim. ");
INSERT INTO mpx_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Yaka kin natuna i ba, “Wawaya ya u ahe nu papaalahul kaiweu, yaka abwe na pwamolawa.” Inoke wawaya i ahe i matahikan ge i papaalahul. ");
INSERT INTO mpx_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sauga wawaya iyaka i bwaya, inoke i pwatanik kin natuna elana, iya i ahe natuna. Inoke i ba, “Ya pagaiheyanem wewela,” inoke alana i tun Mosese. ");
INSERT INTO mpx_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mosese iyaka i tau matuwa, inoke lan etega i na i tagil wana pan Hibilu i kenanagil ge i kite tuwalali pupulowanina hi awaawaginol. Yaka i kite Itipita etega Mosese wana pan Hibilu etega i nibinibihan. ");
INSERT INTO mpx_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosese matana i lipwapwati nige gamagal etega i kikite, inoke Itipita gamagalina i lol ge tuwana i sume bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Lan i gan inoke i tagil al, yaka Hibilu bolauiliyau eluwa i kitel hi lohalohaveyan. Inoke i baek tau toto i gegi elana i ola, “Hauna kaiwena ge wam pan Hibilu u lololi?” ");
INSERT INTO mpx_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Anana tau i lahe i ba, “Owa nige ama wama tologugui ge wama toyatala i oola. Age nasi nu lolau ni ola nolu Itipita gamagalina u lol?” Yaka Mosese i lovakun, kaiwena i nuwatu i ba, “Gamagalau iyaka hi atena hauna ya ginol.” ");
INSERT INTO mpx_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Sauga Mosese wana ginol wasana kin i hago, inoke kamwasa i loya ge Mosese ni lol. Yaa i lou i na labi Midiyani ge i misiyowa wewel kenken etega bebenaa. ");
INSERT INTO mpx_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He Midiyani wali tapwalolo ana tohouwa etega natunau meluyowau ali gewi seben. Hi nem wewel hi wagiwagi ha tamaliya wana sipi ge wana goti wali abaimwim hi papakalaopop ge nihi paimwil. ");
INSERT INTO mpx_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Yaa sipi tomatahikan enuna hi nem yowau hi takel. Inoke Mosese i na i label bolau o i palil, yaka wewel i wage yowau wali bwasumu i paimwil. ");
INSERT INTO mpx_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Sauga yowau hi sikal tamaliya Luwel elana, inoke i nelil i ba, “Hauna kaiwena ge lan ebe etimwawa ku sikal?” ");
INSERT INTO mpx_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Anana hi lahe hi ba, “Sauga sipi tomatahikan hi takema, inoke Itipita gamagalina etega i labema ge i palil, yaka wewel i wage kaiwema ge wala bwasumu i paimwil.” ");
INSERT INTO mpx_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yaka i nel natunau elal i ba, “He iya ga? Ga i ola ge ku tataluwai? Ku nok ku ba ni nem avala ta anan.” ");
INSERT INTO mpx_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Inoke Mosese i talam ge i na wali limiya, yaka abwe i miminaa to. He Luwel natuna etega alana Sipola i pek Mosese elana alona hi alolon. ");
INSERT INTO mpx_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Yaka natuliya melutauina i ab. Mosese i ba, “Ya mibwabwali panuwa ya elana,” inoke wawaya alana i tun Gesomi. ");
INSERT INTO mpx_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Baliman hi gewi i mowasi abwe Itipita wali kin i yaomal, yaa Isileli heliya iyoho hi yowalu wali miloloyowan elana, inoke hi kahin awaawanun labe kaiwena. Wali kahin i ha Yabowaine elana, ");
INSERT INTO mpx_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ge wali yowalu i hago, inoke wana bateli Abalahama, Aisake ge Yakobo elal i nuwahikan. ");
INSERT INTO mpx_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","He Isileli wali lomwan i kite, inoke atena i lomwanagil. ");
INSERT INTO mpx_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosese yawana Yetilo, Midiyani wali tapwalolo ana tohouwa etega, wana sipi ge goti i matahikagil, yaka lan etega i nulil hi noek ula kekevana gamwanaa hi na hi vin Sainai oya bwabwalena. ");
INSERT INTO mpx_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yaka Yehoba wana anelose i masal elana ana awa i ola ginaha memena i tautau ebwakil lamwanaa. Mosese i kite ginaha i tautau, yaa ebwakil nige i kakalas. ");
INSERT INTO mpx_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Inoke i ba, “Abanuwa ahi hot! Hauna kaiwena ebwakil nige i kakalas? Na na ga na kenani.” ");
INSERT INTO mpx_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yehoba i kite Mosese i na i kenakenan, inoke i yogem ebwakil elana i ba, “Mosese! Mosese!” Yaka Mosese i talam i ola, “Oo, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yabowaine i ba, “Bahi nu nenem ebwakil labenaa. Aem ana os u leke kaiwena bilibili toto u talmilila i bwabwalena. ");
INSERT INTO mpx_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nau tubumwau Abalahama, Aisake ge Yakobo wali Yabowaine.” Inoke Mosese maninina i teli kaus, kaiwena i lovakun bahi Yabowaine ni kikite. ");
INSERT INTO mpx_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yaka Yehoba i ba, “Ya kite Itipita no gamagal hi paloloyowan-agil, ge wali kahin ya hago nuwaliya na pwamwalil ali tomatahikan elal. Ya nuwanuwatu wali lomwan kaiwena, ");
INSERT INTO mpx_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","inoke ya lau na pwamwalil Itipita nimaliyaa, ge na nulil tagilagil nihi nok panuwa waiwaisana ge bwabwatana elana, panuwa malumalulina. Sauga ya Kenani, Hiti, Amoli, Pelisi, Hivi ge Yebusi hi miminaa to. ");
INSERT INTO mpx_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","No gamagal wali kahin iyaka ya hago, ge ya kite Itipita hi paloloyowan-agil. ");
INSERT INTO mpx_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","He nu nok, ya papatunawa nu na Itipita wali kin elana ge no gamagal nu nulil tagilagil wana panuwaa.” ");
INSERT INTO mpx_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Yaa Mosese i baek Yabowaine elana i ba, “Nau gamagal bwagabwaga ya! Ga i ola ge na na kin elana ge Isileli na nulil tagilagil Itipita?” ");
INSERT INTO mpx_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Anana Yabowaine i lahe i ba, “Nau alom. He sauga gamagalau nu nulil tagilagil Itipita abwe nuku kululuwa elau oya ya elana, inoke nu atena tunahot nau ya patunawa.” ");
INSERT INTO mpx_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Yaka Mosese i ba, “Sauga ebo na nok Isileli elal ge na ba, ‘Tubulau wali Yabowaine i patunau eliyamiu’ ge ebo nihi nel elau nihi ba ‘Alanaek?’ he ga na ba ola elal?” ");
INSERT INTO mpx_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Anana Yabowaine i lahe i ba, “Nau heiya te nau, nau iyoho ya gangan. Inoke nu ba Isileli elal, ‘Toto alana Nau Heiya te Nau, iya i patunau eliyamiu.’ ");
INSERT INTO mpx_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nu ba Isileli elal, ‘Yehoba, tubulau wali Yabowaine, Abalahama, Aisake ge Yakobo wali Yabowaine, i patunau eliyamiu.’ He alau ya ni mihot; heyan ge heyan alau nihi lumelumeni ni ola to. ");
INSERT INTO mpx_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Nu na Isileli wali tonowakau nu pamigogoil, inoke nu baek eliyalil nu ba, ‘Yehoba, tubulau wali Yabowaine, Abalahama, Aisake ge Yakobo wali Yabowaine, iyaka i masal elau ge i ba: He iyaka ya nem ge Itipita wali ginol eliyamiu ya kite. ");
INSERT INTO mpx_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ya bateli na nul tagilagimiu Itipita wami abaloloyowana, nuku na nuku tuk panuwa malumalulina toto Kenani, Hiti, Amoli, Pelisi, Hivi ge Yebusi hi miminaa.’ ");
INSERT INTO mpx_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Isileli wali tonowakau wam baaba nihi hago. Inoke alomwau nuku nok nuku na Itipita wali kin elana ge nuku ba, ‘Yehoba, ama Hibilu wama Yabowaine, iyaka i masal eliyama. Inoke sauga ya nu talamwagima lan eton naha nawanawa-an ula kekevana elana ge bwasumu naha powonan Yehoba wama Yabowaine elana.’ ");
INSERT INTO mpx_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","He ya atena Itipita wali kin nige ni tatalamwagimiu ge nuku eegon, ebo nige no gasisi bwabwatana na papamasal ni kikite. ");
INSERT INTO mpx_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","No gasisi na patuwalali ginol lolovakunina na ginolil ge Itipita na apapanak-agil, yaka abwe kin ni talamwagimiu nuku egon. ");
INSERT INTO mpx_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“No gasisi kaiwena Itipita nihi awatauwagimiu, inoke sauga nuku egon, nige nimamiu enoenovana i oola. ");
INSERT INTO mpx_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Isileli yowauiliyau nihi nok Itipita yowauiliyau elal, bolo hi miminaa labeliyaa ge bolo avaliyau hi mipamaisena, inoke tuwan ana isela gold ge silba ginebi ge kaliko waiwaisana nihi awanuni elal. Yaka bugul ya natumiyau bolau ge yowau nuku pagaloil, inoke Itipita wali wasawasa nuku ahe egonan.” ");
INSERT INTO mpx_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Yaka Mosese i baek Yehoba elana i ba, “Ga i ola ebo Isileli nige no baaba nihi hahago ge nihi aabulilek-an. Binimala ebo nihi baem elau nihi ba, ‘Yehoba nige i mamasal eliyam,’ ga na ginol na ola?” ");
INSERT INTO mpx_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Inoke Yehoba i nel i ba, “Hauna nimwamwa?” Anana Mosese i lahe ba, “Suki te.” ");
INSERT INTO mpx_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yehoba i baek elana i ba, “U alipalo bilibiliya.” Yaka Mosese suki i alipalo inoke i tabwa mwata, yaka Mosese i lou luwai. ");
INSERT INTO mpx_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yaka Yehoba i baek Mosese elana i ba, “U kululu, nimwam u paelu u aheya mwata ulinaa ge u latahin.” Inoke Mosese i kululu ge i pihikan, yaka i tabwa suki al. ");
INSERT INTO mpx_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yaka Yehoba i ba, “Nu ginol ni ola to, inoke Isileli nihi patunahot te nau Yehoba, tubuliyau wali Yabowaine, Abalahama, Aisake ge Yakobo wali Yabowaine, iyaka ya masal eliyam.” ");
INSERT INTO mpx_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Inoke Yehoba i baek al Mosese elana i ba, “Nimwam u teliya babagalimwa am kaliko gamwanaa.” Mosese i ginol ola ge sauga nimana i ahe, inoke nimana i lepelo, i yanayana hot i ola apwapwali. ");
INSERT INTO mpx_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yaka Yehoba i ba, “Nimwam u teliya al babagalimwa am kaliko gamwanaa.” Mosese i ginol ola, ge sauga nimana i ahe al, inoke nimana i waisi sikal i ola tuwana gegewena. ");
INSERT INTO mpx_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yaka Yehoba i ba, “Binimala ebo ginol yawiyawi houwan nihi kite ge nige nihi abulilewa elam, inoke ginol yawiyawi eluwana nihi kite yaka abwe nihi abulilek. ");
INSERT INTO mpx_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Yaa binimala ebo ginol yawiyawi eluwa o nihi kite, ge nige wam baaba nihi hahago ge nihi abulilewa al elam, inoke Naile wewelina nu wage nu ligin bilibiliya, yaka ni tabwa saliya.” ");
INSERT INTO mpx_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Yaa Mosese i ba, “Bahiwa, Yehoba, bahi nu papatunau. Nau nige toawabaaba i oola. Valila ya ola, sauga al ya ya ola, bwagana nu baaba eliyau. Anau i mumulan ge memeu i pulowan.” ");
INSERT INTO mpx_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yaka Yehoba i ba, “Henala gamagal awana i ginol? Henala tanan i pipatui ge anana i pakekepa? Henala matan i pipanana o ebo i pipakai? Heiya te nau, Yehoba. ");
INSERT INTO mpx_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","U egon! Abwe na labewa baaba na paatenawa ge nu baunan.” ");
INSERT INTO mpx_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Yaa Mosese i ba, “Bahiwa Babala, gamagal getoga u patuna.” ");
INSERT INTO mpx_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yaka Yehoba Mosese i hugaan ge i ba, “Ga i ola talim Eloni, ana un Libai? Ya atena iya toawabaaba. He sauga ya am kaiwa i nenem, ge sauga ni kitewa ni yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Owa nu baek elana hauna ni baunan. Ami toto labui na labemiu nuku baaba ge na baewa eliyamiu hauna nuku ginol. ");
INSERT INTO mpx_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Iya ni baaba gamagalau elal kaiwem. Iya ni ola wam tobaaba, ge owa nu ola Yabowaine eliyana, nu baek elana hauna ni baunan. ");
INSERT INTO mpx_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Suki ei nu noahe inoke eliyana ginol yawiyawi nu ginolil.” ");
INSERT INTO mpx_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Yaka Mosese i sikal i na Midiyani yawana Yetilo elana. Inoke Yehoba i baek elana i ba, “U sikal Itipita, kaiwena bolo nuwaliya nihi loliwa gegewel iyaka hi aliga.” Yaka Mosese i baek yawana elana i ba, “U talamwagau na sikal na na Itipita tutuwau na kitel tab heliya iyoho hi molu.” Inoke Yetilo i talam ge i ba, “Ee, ya yaliyaya nu nok.” ");
INSERT INTO mpx_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Inoke Mosese lagona ge natunau bolau i ahel, i telel donki pwatanaa, ge alonau hi egonan nihi na Itipita. Mosese suki toto Yabowaine i baunan i noahe. ");
INSERT INTO mpx_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yaka Yehoba i baek Mosese elana i ba, “Sauga nu vin Itipita, nu nuwahikan ginol yawiyawi gegewel toto ya talamwan elam, nu ginolil kin matanaa ge nu ba no gamagalau ni talamwagil nihi egon nihi na nihi tapwalolo elau. Yaa kin atena na paelolol, inoke nige ni tatalamwagil nihi eegon. ");
INSERT INTO mpx_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Inoke nu sikal kin elana nu ba, ‘Yehoba i ba: Isileli hi ola natu tauina gamaun. ");
INSERT INTO mpx_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Iyaka ya ba haba eliyam, “Isileli u talamwagil nihi egon nihi na nihi tapwalolo elau.” Yaa ebo nigeya, inoke natum gamaun na lol.’” ");
INSERT INTO mpx_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Abaveveyahowa Itipita ana kamwasaa, Yehoba i masal Mosese elana tage i tatagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Yaa Sipola nibuka i ahe natuna melutauina tuwana buhuna kunisina i gotomwa yoho ge i ahe i patupa Mosese aena elana. Inoke i ba “Tunahot lagou owa u sasaliya.” ");
INSERT INTO mpx_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","I ba ola o, kaiwena nige nuwana i oola gotomwa yoho paganina. Inoke Yehoba Mosese i eguluwai. ");
INSERT INTO mpx_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yehoba iyaka i baek Eloni elana i ba, “U na ula kekevana elana Mosese u kite.” Yaka Eloni i nok ge sauga Mosese i pwawaa Sainai oya bwabwalena elana, inoke i nalo. ");
INSERT INTO mpx_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Yaka baaba gegewena toto Yehoba i ba ni baunan Itipita, Mosese i wasaan Eloni elana. I ola al, ginol yawiyawi toto Yehoba i ba ni ginol i wasaan. ");
INSERT INTO mpx_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Inoke Mosese ge Eloni hi nok hi na Itipita, ge Isileli wali tonowakau gegewel hi pamigogoil. ");
INSERT INTO mpx_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Inoke Eloni baaba gegewena toto Yehoba i baunan Mosese elana i wasaan elal, yaka Mosese ginol yawiyawi gegewena i ginol gamagal mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Hi abulilek Yehoba i patunal, ge sauga hi hago age Yehoba wali miloloyowan i kite ge i atilomwan-agil, inoke hi kululu ge hi tapwalolo. ");
INSERT INTO mpx_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Toto o enaa, yaka Mosese ge Eloni hi na Itipita wali kin elana hi ba, “Yehoba, ama Isileli wama Yabowaine, i ba ola hiwe, ‘No gamagalau u talamwagil nihi egon, inoke hagali nihi ginol ula kekevana elana o awatauwan kaiwena.’” ");
INSERT INTO mpx_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Yaka kin i ba, “Henala Yehoba, ge anana na hago Isileli na talamwagil nihi egon? Yehoba nige ya aatena, inoke nige Isileli na tatalamwagil nihi eegon.” ");
INSERT INTO mpx_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mosese ge Eloni hi ba, “Ama Hibilu wama Yabowaine iyaka i masal eliyama. U talamwagima lan eton naha nawanawa-an ula kekevana elana bwasumu naha powonan Yehoba wama Yabowaine elana. Ebo nigeya, tab abwe ama kasiyebwa ni teli o ebo elohaveyan kilepana elana ni lolima ge naha aliga.” ");
INSERT INTO mpx_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kin i ba, “Mosese ge Eloni, ga i ola ge gamagalau wali tuwalali ku apanak. Ku sikal wami abatuwalaliya. ");
INSERT INTO mpx_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Komiu Isileli iyaka Itipita ku gewi lakema. Ga i ola! Tuwalali iyaka ku towani!” ");
INSERT INTO mpx_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Lan toto o elana, kin logugui gasigasisena i baunanik tontuwalali ge tuwalali ana tomatahikan elal i ba, ");
INSERT INTO mpx_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Bahi widiwidi kekevana alona bilibili nuku pepek elal ge bilik nihi giginol! Nuku ba totoliya nihi na widiwidi nihi loya. ");
INSERT INTO mpx_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Yaa nuku ba al elal bilik nihi ginol ali gewi ni ola valila, bahi ali gewi ni lalau. Heliya hi pweyata, heiya te kaiwena ge hi awanun elau tage na talamwagil nihi na bwasumu nihi powonan wali Yabowaine elana! ");
INSERT INTO mpx_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Wali tuwalali ku pwapwabwaya-an, yaka nihi mimi tuwatuwalali ya, inoke bahi nuwaliya ni nonoek ba kakawi ana haguhagu elana.” ");
INSERT INTO mpx_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Inoke tontuwalali ge tuwalali ana tomatahikan hi tagil, hi na hi baek Isileli elal hi ola, “Kin i ba ola hiwe, ‘Widiwidi nige naha pepewa al. ");
INSERT INTO mpx_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nuku na totomiu wami widiwidi nuku loya hauna labena elana nuku pwawaa, yaa bilik nuku ginol ali gewi ni olaolaek, bahi ni lalau.’” ");
INSERT INTO mpx_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Inoke Isileli, Itipita gamwana gegewena hi nemnowa-an widiwidi ana loya kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tontuwalali Isileli hi palawakikil hi ba, “Lan maisena maisena bilik nuku ginolil ali gewi ni ola sauga toto widiwidi hi pewa eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Yaka tontuwalali tuwalali ana tomatahikan hi nibihil hi ba, “Ga i ola ge bilik nige ku giginolil ali gewi i oola valila?” Tontuwalali heliya gagama Itipita. Tuwalali ana tomatahikan heliya Isileli bolo Itipita hi hilel tuwalali nihi matahikan. ");
INSERT INTO mpx_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Inoke tuwalali ana tomatahikan hi na kin elana hi ba, “Ga i ola ge u giginol ola eliyama? ");
INSERT INTO mpx_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Widiwidi nige hi pepem eliyama, yaa hi ba bilik naha ginolil! Yaka hi nibinibihagima! Wam gamagalau hi gegi te hi ginol ola eliyama.” ");
INSERT INTO mpx_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Yaka kin i ba, “Komiu topweyata, ku pweyata hot! Heiya te kaiwena ku mimi baaba tage na talamwagimiu nuku na bwasumu nuku powonan Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ku sikal, ku na ku tuwalali! Widiwidi nige nihi pepewa, yaa bilik nuku ginolil ali gewi ni olaolaek toto valila.” ");
INSERT INTO mpx_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tuwalali ana tomatahikan hi atena te i pulowan elal, kaiwena kin i ba. “Lan maisena maisena bilik nuku ginolil ali gewi ni ola toto valila.” ");
INSERT INTO mpx_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Sauga kin hi eguluwan, inoke hi na Mosese ge Eloni hi pwawal heliya hi matamatan kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Yaka hi baek Mosese ge Eloni elal hi ba, “Ha awanun Yehoba ni lahemiu, kaiwena kin alonau ge ana tolabe tineliya ku palut ge hi pihigelgel-agima. He wami ginol kaiwena bosowailiya te nihi lolima.” ");
INSERT INTO mpx_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Inoke Mosese i na i awanun Yehoba elana i ba, “Babala, ga i ola ge pulowan u pwatanim wam gamagalau elal? Age toto o kaiwena heiya u patunau ge ya nem? ");
INSERT INTO mpx_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ya nok kin elana wam baaba ya baunanik, inoke nak i ginol gamagalau elal. Nige bugul etega u giginol ge nu pwamwalil!” ");
INSERT INTO mpx_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yaka Yehoba i baek Mosese elana i ba, “Sauga kekeisi abwe nu kite hauna na ginol kin elana. No gasisi kaiwena inoke ni patuna owaowa-agimiu ge wana panuwa nuku eguluwan.” ");
INSERT INTO mpx_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Yaka Yabowaine i baek al Mosese elana i ba, “Nau Yehoba. ");
INSERT INTO mpx_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Sauga ya masala Abalahama, Aisake ge Yakobo elal, alau Yabowaine Togasisi Hot ya te hi atena. Ya masal elal, yaa alau Yehoba, alan bwabwalena, nige ya papamasal elal. ");
INSERT INTO mpx_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Inoke no bateli ya ginol elal labi Kenani na pek, labi toto elana hi mibwabwaliya. ");
INSERT INTO mpx_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Sauga ya Isileli hi miloloyowan Itipita, inoke wali yowalu iyaka ya hago ge no bateli ya nuwahikan. ");
INSERT INTO mpx_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Inoke nu baek Isileli elal, ‘Nau Yehoba. Nau na pwamwalimiu, na sokalimiu Itipita wali paloloyowana. Nimwau gasigasisena na paelu, lahi pupulowanina na pek elal ge na pwamwalimiu. ");
INSERT INTO mpx_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Na ahemiu komiu nuku ola no gamagalau, ge nau wami Yabowaine. Inoke nuku atena nau Yehoba wami Yabowaine, kaiwena na sokalimiu Itipita wali paloloyowana. ");
INSERT INTO mpx_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Na nulimiu nuku na panuwa toto ya bateli na pek Abalahama, Aisake ge Yakobo elal, inoke na pewa hoti wami panuwa. Nau Yehoba.’” ");
INSERT INTO mpx_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","He Mosese Yehoba wana baaba i wasaan Isileli elal i ola to, yaa anana nige hi hahago, kaiwena yayaluwaliya i pweyata wali miloloyowan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yaka Yehoba i baek Mosese elana i ba, ");
INSERT INTO mpx_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Nu na nu ba Itipita wali kin Isileli ni talamwagil nihi tagil wana panuwaa.” ");
INSERT INTO mpx_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Yaa anana Mosese i lahe i ba, “Isileli anau nige hi hahago. Ga i ola ge kin anau ni hago? Nau memeu i pulowan ge ya baaba gegegi.” ");
INSERT INTO mpx_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","He liwanina i ola to. Yehoba i ba Mosese ge Eloni Isileli nihi nulil tagilagil Itipita, ge i patunal nihi baek Isileli elal ge nihi ba Itipita wali kin elana. ");
INSERT INTO mpx_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isileli ali un tubutubuliyau i ola hiwe. Yakobo natuna gamaun Lubeni, natunau bolau esopali: Hanok, Palu, Hesiloni, ge Kami. Heliya un Lubeni ali pwahiya ona tubutubuliyau. ");
INSERT INTO mpx_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Lubeni loena Simiyon, natunau bolau esiwa (6): Yemuwel, Yamin, Ohad, Yakin, Sohal ge Saul, iya Kenani yovana natuna. Heliya un Simiyon ali pwahiya ona tubutubuliyau. ");
INSERT INTO mpx_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Simiyon loena Libai, natunau bolau eton: Gelison, Kohat ge Melali, i ola te i pamasal ali un wasana ana buki elana. Libai yawalina ana baliman wan handeled teti seben (137). ");
INSERT INTO mpx_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gelison natunau bolau eluwa: Libinai ge Simei. Heliya al tubutubuliyau hi gewi. ");
INSERT INTO mpx_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat natunau bolau esopali: Amilam, Isihal, Hebiloni ge Usiyel. Kohat yawalina ana baliman wan handeled teti tili (133). ");
INSERT INTO mpx_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Melali natunau bolau eluwa: Mahali ge Musi. Heliya un Libai ali pwahiya ona tubutubuliyau, i ola te i pamasal ali un wasana ana buki elana. ");
INSERT INTO mpx_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amilam alona tamana nuna Yokebed hi alolon, inoke natunau Eloni ge Mosese i abil. Amilam yawalina ana baliman wan handeled teti seben (137). ");
INSERT INTO mpx_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isihal natunau bolau eton: Kola, Nepeg ge Sikili. ");
INSERT INTO mpx_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiyel natunau bolau eton: Misael, Elisapan ge Sitili. ");
INSERT INTO mpx_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Eloni alona Eliseba hi alolon, iya Aminadab natuna, Nason nuna. Natunau i abil Nadab, Abihu, Eliyesa ge Itamali. ");
INSERT INTO mpx_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kola natunau bolau eton: Asil, Elekana ge Abiyasap; heliya pwahiya Kola ali tonowakau ona. ");
INSERT INTO mpx_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eloni natuna Eliyesa alona ge Putiyel natuna yovana hi alolon inoke i ab natuna Pinehas. He un Libai ali pwahiya ona ge ali tini ona tonowakiliyau liwaniliya i ola to. ");
INSERT INTO mpx_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","He Eloni ge Mosese bolo ya heliya te Yehoba i baek elal i ba, “Isileli ali un gegewena nuku nulil tagilagil Itipita.” ");
INSERT INTO mpx_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ge heliya te hi baek Itipita wali kin elana Isileli ni talamwagil nihi nulil tagilagil Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","He Mosese iyoho Itipita, Yehoba iyaka i baek elana i ba, “Nau Yehoba. Baaba gegewena toto na baunaniwa, nu baunanik Itipita wali kin elana.” ");
INSERT INTO mpx_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Yaa saugena o Mosese i baek Yehoba elana i ba, “Nau memeu i pulowan ge ya baaba gegegi. Ga i ola ge kin anau ni hago?” ");
INSERT INTO mpx_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yaka Yehoba i baek elana i ba, “Ya telewa nu ola Yabowaine kin matanaa, ge talim Eloni ni baaba kin elana ni ola wam palopita. ");
INSERT INTO mpx_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Baaba gegewena toto na baunaniwa nu baunanik Eloni elana, inoke ni ba kin elana Isileli ni talamwagil nihi tagilem wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Yaa kin atena na pagasisi, inoke bwagana ginol yawiyawi ge abanuwaahi ona ni gewi na ginolil Itipita, ");
INSERT INTO mpx_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","yaa anam nige ni hahago. Inoke nimwau na paelu lahi pupulowanina na ginol Itipita elana, yaka no gamagalau Isileli un gegewel na nulil tagilagil. ");
INSERT INTO mpx_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Sauga nimwau na paelu Itipita elana ge Isileli na nulil tagilagil wali panuwaa, yaka abwe Itipita nihi atena nau Yehoba.” ");
INSERT INTO mpx_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Yaka Mosese ge Eloni hi ginol ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Sauga toto hi na hi baaba kin elana, he Mosese wana baliman eiti ge Eloni wana baliman eiti tili. ");
INSERT INTO mpx_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yaka Yehoba i baek Mosese ge Eloni elal i ba, ");
INSERT INTO mpx_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Sauga ebo kin ni baewa eliyamiu ni ba, ‘Ginol yawiyawi etega nuku ginol inoke wami baaba ni patunahot,’ yaka nu baek Eloni elana wana suki ni ahe ni alilowana kin awonaa, inoke ni tabwa mwata.” ");
INSERT INTO mpx_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Yaka Mosese ge Eloni hi nok hi na kin elana ge hi ginol ola Yehoba wana baaba. Eloni wana suki i alilowana kin ge ana tolabe awoliyaa inoke i tabwa mwata. ");
INSERT INTO mpx_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Yaka kin wana tosiba ge wana tokukula i yogaagil, ge wali siba elana hi ginol i ola ya te toto Eloni i ginol. ");
INSERT INTO mpx_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Wali suki hi alilowan inoke hi tabwa mwata. Yaa Eloni wana suki heliya wali suki i tinonil. ");
INSERT INTO mpx_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Yaa kin atena i pagasisi inoke Mosese ge Eloni analiya nige i hahago, i ola valila Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Inoke Yehoba i baek Mosese elana i ba, “Kin atena i gasisi nabi, gamagal nige i tatalamwagil hi eegon. ");
INSERT INTO mpx_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sauga mweluluga ni lau i nana wewel Naile kaiwena, inoke nu na nu kite. Yaka suki toto i tabwa mwata nu noahe ge nu matamatan wewel labenaa. ");
INSERT INTO mpx_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Yaka nu ba kin elana nu ola, ‘Yehoba, ama Hibilu wama Yabowaine, i patunau ya baewa elam ya ba: No gamagal u talamwagil nihi egon, inoke nihi tapwalolo elau ula kekevana elana. Yaa nige anana u hahago. ");
INSERT INTO mpx_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Inoke Yehoba i ba ola hiwe, “Ginol etega na ginol inoke nu atena nau Yehoba.” He suki toto ya pihikan e, eliyana wewel Naile na lol inoke ni tabwa saliya. ");
INSERT INTO mpx_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Yaka moti nihi aliga ge wewel ni bweyan, inoke Itipita nige bosowailiya nihi im.’” ");
INSERT INTO mpx_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yaka Yehoba i baek Mosese elana i ba, “U baek Eloni elana wana suki ni paelu Itipita wewelina gegewena elal, bolo hi sanisani, bolo dulein hi sani toulil ge bolo opopwil, yaka nihi tabwa saliya. Panuwa gamwana gegewena ni sasaliya, i ola al patuna ge ulugomwa wewelina nihi saliya.” ");
INSERT INTO mpx_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Yaka Mosese ge Eloni hi ginol i ola Yehoba wana baaba. Eloni wana suki i latahin kin ge ana tolabe mataliyaa, inoke wewel Naile i lol yaka gegewena i tabwa saliya. ");
INSERT INTO mpx_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Wewel Naile moteliyau hi loaliga ge bwaleliya wewel i pabweyan, inoke Itipita nige bosowailiya wewel nihi im. Itipita gamwanaa gegewena i yousasaliya. ");
INSERT INTO mpx_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yaa Itipita wali tokukula wali siba elana hi ginol i ola ya te toto Eloni i ginol. Yaka kin atena i pagasisi al inoke Mosese ge Eloni analiya nige i hahago, i ola valila Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Yaka kin ena i pek elal ge i sikal i na wana limiya, nige i nuwanuwatu bugul o kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Itipita gegewel ali wewel imwim hi ken loyaloya wewel Naile bebenaa, kaiwena nige bosowailiya wewelina nihi im. ");
INSERT INTO mpx_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yehoba wewel Naile i palogabola, enaa lan seben i mowasi ga. ");
INSERT INTO mpx_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yaka Yehoba i baek al Mosese elana i ola, “U na kin elana ge nu ba, ‘Yehoba i ba ola hiwe: No gamagal u talamwagil nihi egon, inoke nihi na nihi tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ebo nige nu tatalamwagil nihi eegon, nasi wam panuwa na palogabola, gamwana gegewena pwagali nihi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Pwagali wewel Naile nihi pakalaopop inoke nihi na nihi ha wam limiya, wam babatomwa elana, wam abakenuwa, am tolabe wali limiya, ge wam gamagalau wali limiya, i ola al nihi ha wam abaliligaa ge wam ulun gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Nihi susupeni ha elam, wam gamagalau elal ge am tolabe gegewel elal.’” ");
INSERT INTO mpx_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yaka Yehoba i baek Mosese elana i ba, “Nu ba Eloni elana wana suki ni paeluek wewel sanisani, wewel bolo dulein hi sani toulil ge wewel opopwil elal. Inoke pwagali nihi heyan panuwa Itipita nihi pakalaopop.” ");
INSERT INTO mpx_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Inoke Eloni wana suki i paeluek Itipita wewelina gegewena elal, yaka pwagali hi heyan ge panuwa hi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Yaa tokukula wali siba elana hi ginol i ola ya te toto Eloni i ginol, inoke pwagali hi heyan panuwa Itipita hi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Yaka kin Mosese ge Eloni i yogaagil ge i baek elal i ba, “Nuku awanun Yehoba elana pwagali ni ahe yohil alowau ge no gamagalau eliyama, yaka wami gamagalau na talamwagil nihi na bwasumu nihi powonan Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Anana Mosese i lahe i ba, “Ya yaliyaya hot na awanun kaiwemiu. Nu ba hauna sauga ge na awanun alomwau am tolabe ge wam gamagalau kaiwemiu, inoke pwagali nihi mwayayu-em eliyamiu ge wami limi elal nige etega nihi mimina al, iyai ya te bolo wewel Naile gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Yaka kin i ba, “Bwaligumwa hot te nu awanun kaiwema.” Anana Mosese i lahe i ba, “Na ginol ni ola wam baaba, inoke nu atena nige yabowaine etega al i oola Yehoba wama Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Inoke owa, am tolabe, wam gamagalau ge wami limi, pwagali nihi mwayayu luwagimiu. Bolo wewel Naile gamwanaa ya te nihi mina.” ");
INSERT INTO mpx_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mosese ge Eloni kin hi eguluwai enaa, inoke Mosese i awanun Yehoba elana pwagali bolo i patunal kin elana kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yaka Yehoba i ginol ola Mosese wana awanun, inoke pwagali hi loaliga limiya, bakubakuwa, ge eyowaa. ");
INSERT INTO mpx_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Itipita pwagali hi hala papahel ali pwahin bwabwatal ona, inoke bwaleliya panuwa i pabweyan. ");
INSERT INTO mpx_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Yaa sauga kin i kite pwagali iyaka hi mowasi, yaka atena i pagasisi al inoke Mosese ge Eloni analiya nige i hahago, i ola valila Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yaka Yehoba i baek Mosese elana i ba, “Nu ba Eloni elana wana suki ni paelu ge bilibili ni lol, inoke Itipita ana labi gegewena elana bilibili papakovana nihi tabwa sapwasapwa.” ");
INSERT INTO mpx_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Yaka Eloni wana suki i paelu ge bilibili i lol, inoke Itipita ana labi gegewena elana bilibili papakovana gegewena hi tabwa sapwasapwa, inoke gamagal ge bwasumu hi pomwil ge hi talil. ");
INSERT INTO mpx_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Sauga tokukula wali siba hi labose tage sapwasapwa nihi pamasal, he nige bosowailiya. Sapwasapwa hi gewi nabi bwasumu ge gamagal hi talil. ");
INSERT INTO mpx_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Inoke tokukula hi baek kin elana hi ba, “Yabowaine wana ginol te.” Yaa kin atena i gasisi inoke Mosese ge Eloni analiya nige i hahago, i ola valila Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yaka Yehoba i baek Mosese elana i ba, “Bwaligumwa mweluluga kekeisi nu lut, yaka sauga kin ni lau i nana wewela, nu na nu kite ge nu baek elana nu ba, ‘Yehoba i ba ola hiwe: No gamagalau u talamwagil nihi egon, inoke nihi na nihi tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ebo nu kaisel, yaka uluulu ali yawi na patunal nihi you tal alomwau am tolabe ge wam gamagalau eliyamiu ge nihi tuk wami limi elal. Itipita wami limi nihi pakalaopop ge bilibili nihi yabom. ");
INSERT INTO mpx_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Yaa na ginol getoga labi Gosen elana, toto no gamagal hi miminaa. Uluulu ali yawi nige nihi gagana to, inoke nu atena nau Yehoba iyahe panuwa ya elana. ");
INSERT INTO mpx_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","No gamagalau ali hehegan ni getoga wam gamagalau elal. He bwaligumwa hot te ginol yawiyawi ya ni gan.’” ");
INSERT INTO mpx_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Inoke Yehoba i ginol ola hiwe. Uluulu ali yawi bwabwatana i patuna hi tuk kin ge ana tolabe wali limiya. Uluulu Itipita gamwana gegewena hi palogabola. ");
INSERT INTO mpx_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Yaka kin Mosese ge Eloni i yogaagil ge i baek elal i ba, “Nuku na bwasumu nuku powonan wami Yabowaine elana, yaa nuku ginola panuwa ya gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Yaa Mosese i ba, “Nige bosowaima naha ginol ola, kaiwena bwasumu bolo naha powonan Yehoba wama Yabowaine elana, Itipita hi bwaikikin-an. Binimala bwasumu o naha powonan mataliyaa, nasi nihi loipat-agima ge naha aliga. ");
INSERT INTO mpx_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Yehoba wama Yabowaine i ba eliyama lan eton naha nawanawa-an naha na ula kekevana elana yaka bwasumu naha powonan elana.” ");
INSERT INTO mpx_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Yaka kin i ba, “Ya talamwagimiu nuku na ula kekevana elana ge bwasumu nuku powonan Yehoba wami Yabowaine elana, yaa bahi nuku nonopayapu. He nuku awanun kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Anana Mosese i lahe i ba, “Sauga na eguluwagiwa na na na awanun Yehoba elana, inoke bwaligumwa uluulu nihi mowasi hot alomwau am tolabe ge wam gamagalau eliyamiu. Yaa bahi nu kakakawema al. Bahi gamagal nu lolopwalil ge nu babaa, ‘Nige bosowaina nuku na bwasumu nuku powonan Yehoba elana.’” ");
INSERT INTO mpx_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Inoke Mosese kin i eguluwan i na i awanun Yehoba elana, ");
INSERT INTO mpx_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","yaka Yehoba i ginol ola Mosese wana awanun. Inoke uluulu hi mowasi hot kin alonau ana tolabe ge wana gamagalau elal, nige etega i mimina. ");
INSERT INTO mpx_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Yaa kin atena i pagasisi al, inoke gamagal nige i tatalamwagil nihi eegon. ");
INSERT INTO mpx_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Inoke Yehoba i baek Mosese elana i ba, “Nu na kin elana ge nu ba, ‘Yehoba ama Hibilu wama Yabowaine i ba ola hiwe: No gamagalau nu talamwagil nihi egon, inoke nihi na nihi tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ebo nu kaisel ge iyoho ya nu kukukuhikagil, ");
INSERT INTO mpx_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","inoke nau Yehoba no gasisi eliyana wam bwasumu hosi, donki, kamel, bulumwakau, sipi ge goti ona ali gila na teli nihi aliga. ");
INSERT INTO mpx_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yaa Isileli wali bwasumu ali hehegan ni getoga Itipita wali bwasumu elal. Isileli wali bwasumu nige etega ni aaliga. ");
INSERT INTO mpx_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","He nau Yehoba lan iyaka ya teli ya ba bwaligumwa hot te na ginol.’” ");
INSERT INTO mpx_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Lan i gan yaka Yehoba i ginol ola wana baaba. Itipita wali bwasumu gegewena hi loaliga, yaa Isileli wali bwasumu nige etega i aaliga. ");
INSERT INTO mpx_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kin i loya ge i pwawa te Isileli wali bwasumu nige etega i aaliga. Yaa iyoho ya atena i gagasisi, yaka nige gamagalau i tatalamwagil hi eegon. ");
INSERT INTO mpx_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yaka Yehoba i baek Mosese ge Eloni elal i ba, “Papakova ku gagalo ginaha ana abatontona, inoke Mosese ni aliheyan hawawala kin awonaa. ");
INSERT INTO mpx_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Yaka papakova ni ola kasukasu ge ni lovaleyan Itipita gamwana gegewena ni pwawa. Inoke gamagalau ge bwasumu nihi youbabaliyan ge nihi youbonbon.” ");
INSERT INTO mpx_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Inoke papakova hi gagalo ginaha ana abatontona ge hi na hi talmilil kin manininaa, yaka Mosese i aliheyan hawawala kin awonaa. Inoke gamagal ge bwasumu hi youbabaliyan ge hi youbonbon. ");
INSERT INTO mpx_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tokukula nige bosowailiya nihi nem nihi talmilil Mosese matanaa kaiwena hi youbabaliyan, i ola al Itipita gegewel. ");
INSERT INTO mpx_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Yaa Yehoba kin atena i pagasisi inoke Mosese ge Eloni analiya nige i hahago, i ola valila Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Inoke Yehoba i baek Mosese elana i ba, “Bwaligumwa mweluluga kekeisi nu lut, yaka nu na kin nu kite ge nu baek elana nu ba, ‘Yehoba, ama Hibilu wama Yabowaine, i ba ola hiwe: No gamagal nu talamwagil nihi egon, inoke nihi na nihi tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ebo nigeya, yaka logabola nanakil hot na ginol alomwau am tolabe ge wam gamagalau eliyamiu. Inoke nu atena nige etega al panayawiya i oola nau. ");
INSERT INTO mpx_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Bosowaina valila nimwau na paelu ge logabola etega na ginol alomwau wam gamagalau eliyamiu ge na gul habamiu panayawiya. ");
INSERT INTO mpx_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Yaa ya telewa u tabwa kin, kaiwena nuwau no gasisi na pankitewa, inoke wasau ni lelu panayawi gegewena ni soli. ");
INSERT INTO mpx_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Owa wam logugui i gasisi no gamagal elal ge u lopwalil nige hi eegon, ");
INSERT INTO mpx_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","inoke bwaligumwa ni ola te sauga e kehe kalakalapatina na palau, kehe ololana o nige sauga etega i lolowa Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","He nu ba totuwalali elal wam bwasumu ge bugul gegewena bolo hi miminaa noleleya nihi bugul tukagil ligumwa. Kaiwena gamagal ge bwasumu bolo nige hi uulutuk ligumwa, nasi kehe kalakalapatina ni lolil ge nihi aliga.’” ");
INSERT INTO mpx_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kin ana tolabe enuna hi lovakun Yehoba wana baaba kaiwena, inoke etimwawa wali totuwalali loloyowanil ge wali bwasumu hi palou tukagil. ");
INSERT INTO mpx_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Yaa bolo nige hi nuwanuwatu Yehoba wana baaba kaiwena inoke wali totuwalali loloyowanil ge wali bwasumu nige hi papalou tukagil. ");
INSERT INTO mpx_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yaka Yehoba i baek Mosese elana i ba, “Nimwam u paeluek labulabumwa, inoke kehe kalakalapatina ni lau Itipita gamwana gegewena elana, ni lowa gamagal, bwasumu, ge bugul siusiunil eyowaa pwataliyaa.” ");
INSERT INTO mpx_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Inoke Mosese wana suki i paeluek labulabumwa yaka Yehoba gulumwawa ge kehe i patuna, inoke pinamal panuwa i lol. Kehe kalakalapatina Yehoba i palau ge Itipita ana labi gegewena pinamal i topainan. Kehe ololana o nige sauga etega i lolowa Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Itipita labi gegewena elal kehe kalakalapatina bugul gegewena bolo noleleya i apapanak-agil, i ola al gamagal ge bwasumu. Bugul bolo siusiunil eyowaa i paanlolowagil ge ebwakil lamwaliya i olan palo. ");
INSERT INTO mpx_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Yaa kehe nige i lolowa labi Gosen, Isileli wali abaminaa. ");
INSERT INTO mpx_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yaka kin Mosese ge Eloni i yogaagil ge i ba, “Iyaka ya gegi. Yehoba wana ginol i sapu, nau alowau no gamagalau ha gegi. ");
INSERT INTO mpx_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ku awanun Yehoba elana! Besema gulumwawa ge kehe! Ya talamwagimiu nuku egon, nige al nuku mimina.” ");
INSERT INTO mpx_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Yaka anana Mosese i lahe i ba, “Sauga na tagil panuwa ya elana, inoke nimwau na latahin ge na awanun Yehoba elana. Inoke gulumwawa ni bakuhu ge kehe ni mainum. Yaka nu atena panayawi iya Yehoba wana panayawi. ");
INSERT INTO mpx_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Yaa ya atena owa ge am tolabe nigeya ga Yehoba Yabowaine ku lolovakun-an.” ");
INSERT INTO mpx_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(He mwawin palakes toto kaliko hi ginoliya, ge aanan bali kehe i apapanak-agil, kaiwena bali iyaka i matuwa ge palakes lanina abwe i pwela. ");
INSERT INTO mpx_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Yaa witi nige i nanak, kaiwena nigeya ga ana sauga matuwa i oola.) ");
INSERT INTO mpx_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Yaka Mosese kin i eguluwan i notagil panuwa tolinaa, inoke nimana i latahin i awanun Yehoba elana, yaka gulumwawa i bakuhu ge kehe i mainum. ");
INSERT INTO mpx_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Sauga kin i kite kehe i mainum ge gulumwawa i bakuhu, yaka i gegi al, alonau ge ana tolabe ateliya hi pagasisi. ");
INSERT INTO mpx_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Inoke Isileli nige i tatalamwagil hi eegon, i ola valila Yehoba wana baaba Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yaka Yehoba i baek Mosese elana i ba, “Nu na kin nu kite. He alonau ana tolabe ateliya ya pagasisi, kaiwena nuwau no ginol yawiyawi ge etotohi ona na ginola gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Inoke sauga mulaa, nuku liwanan natumiyau ge tubumiyau eliyalil Itipita ali hehegan ga ya apapanak-an ola ge etotohi bolo ya ginolil gamwaliyaa kaiweliya. Inoke nuku atena te nau Yehoba.” ");
INSERT INTO mpx_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Inoke Mosese ge Eloni hi na kin elana ge hi ba, “Yehoba ama Hibilu wama Yabowaine i ba ola hiwe: ‘Hauna sauga abwe nu awatauwagau? No gamagal u talamwagil nihi egon, inoke nihi na nihi tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ebo nu kaisel, yaka bwaligumwa na ba sagagai nihi nem wam panuwa nihi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Nihi gewi nabi bilibili nihi yabom, nige bosowaina ta kite. Bugul gegewena bolo kehe kalakalapatina nige i aapanakil ge hi minaa wami eyowaa, i ola al ebwakil lamwaliya, nihi an habal. ");
INSERT INTO mpx_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Alomwau am tolabe gegewel ge Itipita gegewel wami limi nihi pakalaopop. He logabola ololana o nige sauga etega tamamiyau ge tubumiyau hi kikite, i telipunaa lan toto labi ya hi holave ana siga sauga ya.’” Yaka Mosese ena i pek kin elana ge i eguluwai. ");
INSERT INTO mpx_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Inoke kin ana tolabe hi baek elana hi ba, “Paehila tau ya ala nak ni pem? Isileli nu talamwagil nihi egon, inoke nihi na nihi tapwalolo Yehoba wali Yabowaine elana. Age nige u atena Itipita i logabola?” ");
INSERT INTO mpx_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Inoke Mosese ge Eloni hi en pasikalil hi na kin elana ge i baek elal i ba, “Nuku nok, nuku na nuku tapwalolo Yehoba wami Yabowaine elana. Yaa no wasa ga nu pem henalau nihi nok.” ");
INSERT INTO mpx_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Anana Mosese i lahe i ba, “Gegewema ya naha egon, alomeyau wama wawayau ge toliki, wama bolau ge yowau, i ola al wama sipi, goti ge bulumwakau, kaiwena hagali naha ginol Yehoba ana awatauwan kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Yaka kin i ba, “Nigeya hot! Ebo yowau ge wawayau na talamwagil alomiyau nuku egon, he binimala Yehoba ga ni labemiu, kaiwena houwan ga na apapanak-agimiu! Ya atena ya, ama nak ku aawaginol! ");
INSERT INTO mpx_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Besena bolau ya nihi nok nihi tapwalolo Yehoba elana, ni ola wami awanun.” Yaka Mosese ge Eloni hi patuna owaowa-agil hi tagil. ");
INSERT INTO mpx_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yaka Yehoba i baek Mosese elana i ba, “Nimwam u paeluek Itipita ana labi gegewena elal, inoke sagagai ali yawi nihi nem ge bugul siusiunil bolo kehe kalakalapatina nige i aapapanak-agil nihi anil.” ");
INSERT INTO mpx_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Inoke Mosese wana suki i paeluek Itipita ana labi gegewena elal, yaka Yehoba mana babaliman i patowa lan o ge bulin o. Lan i gan mweluluga, yaka sagagai hi masal. ");
INSERT INTO mpx_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ali yawi bwabwatana hi you vin, panuwa gamwana gegewena hi pakalaopop. Yawi ololana o nige sauga etega i gagan, ge nige al ni gagan. ");
INSERT INTO mpx_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Inoke panuwa hi pomwi ge bikeliya i pit. Bugul siusiunil eyowaa ginebi ge ai huwalu enowaliya bolo nige kehe kalakalapatina i aapanakil, gegewel hi an habal. Ebwakil ge mwawin lamwaliya alalawal, gegewena hi pwamowasel. ");
INSERT INTO mpx_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Inoke etimwawa kin Mosese ge Eloni i yogaagil ge i baek elal i ba, “Iyaka ya gegi Yehoba wami Yabowaine elana, i ola al eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","No gegi ku nuwayoho al pamaisena, ge ku awanun Yehoba wami Yabowaine elana logabola nanakina ya ni ahe yoho.” ");
INSERT INTO mpx_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Inoke Mosese kin i eguluwan i na i awanun Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yaka Yehoba mana i pil pasikal i tabwa yalas gasigasisena, inoke sagagai i yu latalatahinil ge i yu payopayou-agil hi na Hoga Keketina. He nige al sagagai etega i miminaa Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yaa Yehoba kin atena i pagasisi, yaka Isileli nige i tatalamwagil hi eegon. ");
INSERT INTO mpx_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yaka Yehoba i baek Mosese elana i ba, “Nimwam u paeluek labulabumwa, inoke gogou kubwa Itipita gamwana gegewena ni yabom, ge gamagalau nihi babalalu gegegi.” ");
INSERT INTO mpx_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Yaka Mosese nimana i paeluwek labulabumwa, inoke lan eton Itipita bwalibwaligena i gogou hot. ");
INSERT INTO mpx_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Itipita nige bosowailiya avaliyau ge avaliyau nihi pekitikiti-agil, ge lan eton o nige gamagal etega wana limi i tataluwai. Yaa Isileli wali abamina i mwananal. ");
INSERT INTO mpx_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Yaka kin Mosese i yogaan ge i baek elana i ba, “Ku nok, ku na ku tapwalolo Yehoba elana. He alomiyau wami yowau ge wawayau nuku nok, yaa wami sipi, goti ge bulumwakau nihi mina.” ");
INSERT INTO mpx_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Yaa anana Mosese i lahe i ba, “Nigeya! Nu talamwagima wama bwasumu naha ahel, yaka enuna naha powon pwabwaligel ge enuna naha powonagil al Yehoba wama Yabowaine elana. ");
INSERT INTO mpx_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","He alomeyau ya te wama bwasumu, nige etega ni mimina. Bwasumu enuna naha hilel inoke naha tapwalolo Yehoba wama Yabowaine elana. Yaa naha vin ga abwe naha atena hauna bwasumu naha powonagil elana.” ");
INSERT INTO mpx_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yaa Yehoba kin atena i pagasisi, inoke nige nuwana ni talamwagil nihi egon. ");
INSERT INTO mpx_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Yaka i baek Mosese elana i ba, “U egonik hot matawa! Bahi al na kikitewa! Lan toto na kitewa, inoke nu aliga!” ");
INSERT INTO mpx_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Anana Mosese i lahe i ba, “I waisi. Ni ola wam baaba. Nige nu kikiteyau al.” ");
INSERT INTO mpx_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","He Yehoba iyaka i ba haba Mosese elana i ba, “Logabola maisena al na patuna Itipita wali kin ge wana gamagalau elal. Enaa inoke ni talamwagimiu nuku egon. He nige tage ni talamwagimiu ya, yaa ni patuna owaowa-agimiu. ");
INSERT INTO mpx_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ge nu ba Isileli bolau ge yowau nihi nok Itipita bolo hi miminaa labeliyaa, inoke tuwan ana isela gold ge silba nihi awanuni elal.” ");
INSERT INTO mpx_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(He Yehoba Itipita ateliya i pameimei inoke heliya Isileli hi awatauwagil. I ola al, Itipita elana Mosese alana i bwaya kin ana tolabe ge gamagalau gegewel mataliyaa.) ");
INSERT INTO mpx_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Inoke Mosese i ba vevehe al kin elana i ba, “Yehoba i ba ola hiwe: ‘Bulin nuwana Itipita na nosolaan. ");
INSERT INTO mpx_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Inoke gamaun melutauil gegewel nihi aliga, ni telipunaa owa kin towasawasa natum elana ni na ana siga totuwalali loloyowanina witi ana towowowol natuna. I ola al, bwasumu gegewel natuliyau gamaun nihi aliga. ");
INSERT INTO mpx_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Itipita gamwana gegewena kahikahin bwabwatana ni masal, kahin ololana o nige sauga etega i gagan, ge nige al ni gagan. ");
INSERT INTO mpx_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Yaa Isileli elal ni bwagum, nige ni oola wanuka etega ni tatawol gamagal o ebo bwasumu elal. Inoke nu atena nau Yehoba Isileli ali hehegan ya ginol pagetoga Itipita elal.’” ");
INSERT INTO mpx_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Yaka Mosese i ba al i ola, “Am tolabe gegewel nihi nem nihi loepwakoku maniniwa ge nihi ba, ‘Alomwau ge wam gamagalau gegewel nuku egonan.’ Yaka enaa abwe na egon.” Inoke Mosese i huga nabi ge kin i eguluwai. ");
INSERT INTO mpx_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","He valila Yehoba i baek Mosese elana i ba, “Kin anam nige ni hahago, inoke ginol yawiyawi ni gewi na ginolil Itipita.” ");
INSERT INTO mpx_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Inoke Mosese ge Eloni ginol yawiyawi gegewel o hi ginolil kin matanaa, yaa Yehoba kin atena i pagasisi inoke Isileli nige i tatalamwagil ge wana panuwa nihi eguluwan. ");
INSERT INTO mpx_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Itipita elana Yehoba i baek Mosese ge Eloni eliyalil i ola, ");
INSERT INTO mpx_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Waikena ya nuku teli baliman ana waikena houwan. ");
INSERT INTO mpx_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nu ba boda Isileli elal: Waikena ya ana lan elulutega elana, tau maisena ge maisena sipi natuna o ebo goti natuna ni hile wana limi ana heniheni kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ebo tau etega wana limi ana heniheni nige nihi gegewi ge nige bosowailiya bwasumu bwabwaligena nihi an haba, inoke avaliyau ge wali heliyamwau bolo labeliyaa nihi an livaso. Nuku golugoluwa gamagal ali gewi elana ge toto i bosowaina gamagal maisena ge maisena ni an ana luvi. ");
INSERT INTO mpx_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sipi o ebo goti melutauil nuku hilel, wali baliman maisena, tuwaliya sasapona. ");
INSERT INTO mpx_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nihi matahikagil bubun ana siga waikena houwan ana lan potin-ina (14-ina) vekokoyavi, yaka boda Isileli gegewel bwasumu bolo o nihi lolil. ");
INSERT INTO mpx_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Saliyana enuna nihi ahe inoke nihi abutek limi toto hi anana ana nog kokowanaa ge ana ai labi labui elana. ");
INSERT INTO mpx_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Bulin toto o bunumwina nuku ton inoke nuku an ginebi awenuwa hohogana ge pwalawa nige alona yis hi vivikuhiya. ");
INSERT INTO mpx_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Bahi kolena o ebo liligana nuku an, yaa tuwana gabomwina gegewena, balomana, aena ge elokena, nuku ton ni mola bubun inoke nuku an. ");
INSERT INTO mpx_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Bahi ginolina etega nuku aan teli ge mweluluga ni pwapwawa. Ebo ni gan, inoke nuku ton ginaha elana ge ni wai. ");
INSERT INTO mpx_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","He wami aanan ana logugui i ola hiwe. Ami kaliko nuku hipwa bubun, aemiu aana nuku pahe, ge wami suki nuku pihikan nimamiwa yaka bosowaimiu egon. Ge nuku aanan pwamweyaha. Nopalegi Hagalena to nau Yehoba kaiweu. ");
INSERT INTO mpx_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Bulin toto o Itipita na nosolaan, yaka gamagal ge bwasumu gamaun melutauil na lolil, inoke yabowaineyau bolo Itipita hi kululuek elal alaliya na teli lowan. Nau Yehoba. ");
INSERT INTO mpx_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Saliya toto nog kokowanaa ge ana ai labi labui elana ni tabwa limi toto ku miminaa ali etotohi. Sauga saliya na kite, inoke na nopalegemiu. Inoke sauga toto Itipita na lolil, logabola nanakina ya komiu nige nuku pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Lan ya nuku nuwahikan, yaka eliyana heyan ge heyan hagali nuku ginol nau Yehoba o nuwahikan kaiwena. Ami logugui o ni mihot. ");
INSERT INTO mpx_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pwalawa toto nige alona yis hi vivikuhiya nuku an lan ali gewi seben. Lan houwan elana, yis gegewena nuku bugul yohil wami limiya, kaiwena lan houwan ana siga lan seben-ina ebo etega pwalawa toto alona yis hi vivikuhiya ni an, iya nuku ahek yoho boda Isileli gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Lan houwan i ola al lan seben-ina nuku nogogo ge nuku tapwalolo. Lan bolo ya bahi tuwalali, iyai te amiu nuku ligaliga. ");
INSERT INTO mpx_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Pwalawa toto Nige alona Yis Hi Vivikuhiya Hagalena nuku ginol, kaiwena lan o gegewemiu ya nul tagilagimiu Itipita. Heyan ge heyan hagali toto e ana nuwahikan nuku ginol. Ami logugui o ni mihot. ");
INSERT INTO mpx_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Inoke waikena houwan ana lan potin-ina kokoyavi ana siga lan tuwenti wan-ina (21-ina) kokoyavi, pwalawa toto nige alona yis hi vivikuhiya nuku an. ");
INSERT INTO mpx_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Inoke lan seben bahi yis ni gagan wami limiya. Ebo towoho o ebo bwabwali etega pwalawa toto alona yis hi vikuhiya ni an, iya nuku ahek yoho boda Isileli gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hauna labi nuku minaa, pwalawa toto nige alona yis hi vivikuhiya nuku anan. Bahi pwalawa toto alona yis hi vikuhiya nuku aan.” ");
INSERT INTO mpx_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Yaka Mosese Isileli wali tonowakau i yogaagil ge i baek elal i ba, “Maisena ge maisena nuku nok sipi o ebo goti natuna nuku hile alomiyau natumiyau kaiwemiu, yaka nuku tagapaaliga Nopalegi bwasumona kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bwasumu saliyana nuku hol mwaha elana, yaka mwawin alana hisopa nuku pikin ge nuku pahunek saliya ana mwaha gamwanaa, inoke nuku abutek wami limi ana nog kokowanaa ge ana ai labi labui elana. Bahi etega nuku tatagil limiya ana siga mweluluga. ");
INSERT INTO mpx_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Sauga Yehoba ni nosola Itipita ni lolil, he saliya ni kite nog kokowanaa ge ana ai labi labui elalil, yaka limi ni nopalegi. Yaomal ana Anelose nige ni uulutuk wami limiya ge ni lololimiu. ");
INSERT INTO mpx_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Logugui ya ni mihot, inoke sauga gegewena alomiyau ge tubutubumiyau nuku henapuan. ");
INSERT INTO mpx_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sauga nuku tuka panuwa toto Yehoba i bateli ni pewa eliyamiu, yaka nuku ginol ni ola to. ");
INSERT INTO mpx_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Sauga ebo natumiyau nihi nel nihi ba, ‘Hagali ya puna ga i ola?’ ");
INSERT INTO mpx_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","yaka analiya nuku lahe nuku ba, ‘Nopalegi Hagalena te Yehoba ta nuwahikan, kaiwena valila Itipita elana Isileli wala limi i nopalegel, yaka Itipita i lolil ge kila i pwamolola.’” Mosese wana baaba o Isileli hi hago, yaka hi loepwakoku ge hi tapwalolo. ");
INSERT INTO mpx_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Inoke hi ginol i ola Yehoba wana baaba Mosese ge Eloni elal. ");
INSERT INTO mpx_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Bulin nuwana, Yehoba Itipita ali gamaun melutauil i lolil gegewel hi aliga, i telipunaa kin towasawasa natuna elana i na ana siga todibula natuna. I ola al bwasumu ali gamaun gegewel hi aliga. ");
INSERT INTO mpx_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Bulin o, kin alonau ana tolabe ge Itipita gegewel hi kenu lut. Yaka kahin bwabwatana i masala Itipita, kaiwena limi maisena ge maisena aliga nige i kakala. ");
INSERT INTO mpx_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Bulin maisena o elana, kin Mosese ge Eloni i yogaagil ge i baek elal i ba, “Nuku egon! Alomiyau ge Isileli no panuwa ku eguluwan! Ku na ku tapwalolo Yehoba elana ni ola wami awanun elau. ");
INSERT INTO mpx_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Wami sipi, goti ge bulumwakau nuku ahel ni ola wami baaba, yaka nuku egon. He nuku awanun al Yehoba ni muloluagau.” ");
INSERT INTO mpx_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Itipita Isileli hi patotoel etimwawa wali panuwa nihi eguluwan ge hi baek elal hi ba, “Ebo nuku mina, nasi naha aliga haba!” ");
INSERT INTO mpx_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","He pwalawa iyaka hi pahun, yaa nigeya ga yis hi tetelek, inoke ginebi ana etuwalali hi bugulan, kaliko elana hi osiya ge hi kalivai. ");
INSERT INTO mpx_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Yaka Isileli hi ginol ola valila Mosese wana baaba elal, hi na tuwan ana isela gold ge silba ginebi ge kaliko waiwaisana hi awanunil Itipita elal. ");
INSERT INTO mpx_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yehoba Itipita ateliya i pameimei Isileli hi awatauwagil, inoke wali bugubugul hi pek elal i ola wali awanun. Yaka Isileli Itipita wali gogomwau hi bugul egonan. ");
INSERT INTO mpx_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Yaka Isileli Lamesese hi tataluwan hi na Sukot. Bolau ali gewi i ola sikis handeled tausan (600,000), yaa yowau ge wawayau nige hi vavasilel. ");
INSERT INTO mpx_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Gamagalau getogal hi gewi avaliyau Isileli hi egonan. Isileli wali sipi, goti ge bulumwakau ali yawi bwabwatal hi ahel avaliyau hi tagil. ");
INSERT INTO mpx_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pwalawa nige alona yis hi vivikuhiya toto hi pwatanem Itipita, hi ahe hi ton ali beleid. He ali pwalawa nige ga alona yis hi vivikuhu, kaiwena Itipita hi patuna owaowa-agil inoke nige wali sauga ge aliya nihi lovivina-an bubun. ");
INSERT INTO mpx_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isileli wali minamina Itipita elana baliman ana gewi po handeled ge teti (430). ");
INSERT INTO mpx_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Baliman po handeled ge teti ana lan mowamowasena elana te Yehoba wana gamagalau ali un gegewel hi tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Bulin o Yehoba i silawa ge i nulil tagilagil Itipita. Inoke baliman maisena maisena bulin toto o Isileli heyan ge heyan nihi silawa Yehoba ana nuwahikan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","He liwanina i ola to. Yehoba i baek Mosese ge Eloni elal i ba, “Nopalegi Hagalena ana logugui i ola hiwe. “Bolo nige boda Isileli i oola bahi nihi aan. ");
INSERT INTO mpx_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","He wami totuwalali loloyowanina toto iyaka ku pwamola bosowaina ni an, ebo tuwana buhuna kunisina iyaka ku tomwa yoho. ");
INSERT INTO mpx_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Yaa tonawanawa ge totuwalali molana gaganina bolo sauga kaukaubwana ya hi miminaa gamwamiwa, bahi nihi aan. ");
INSERT INTO mpx_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Nopalegi Hagalena bwasumona maisena nuku anana limi maisena gamwanaa. Bahi ginolina etega nuku tatagilan limi o tolinaa ge bahi tutuwana etega nuku gagabom. ");
INSERT INTO mpx_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Boda Isileli gegewel hagali ya nihi ginol. ");
INSERT INTO mpx_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Bwabwali toto i miminaa wami panuwaa, ebo nuwana Nopalegi Hagalena ni ginol Yehoba ana awatauwan kaiwena, he bolau gegewel wana limi ana heniheni gamwaliyaa gotomwa yoho paganina nihi ahe. Ebo ni ola o, inoke bosowaina hagali enowana ni anan ni ola Isileli towohina hot. Yaa bolo nige gotomwa yoho paganina hi aahe, bahi nihi aan. ");
INSERT INTO mpx_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Towoho ge bwabwali bolo hi miminaa wami panuwaa, ami logugui i maisena ya.” ");
INSERT INTO mpx_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","He Isileli gegewel hi ginol ola Yehoba wana baaba Mosese ge Eloni eliyalil. ");
INSERT INTO mpx_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Yaka lan o eliyana Yehoba Isileli ali un i nulil tagilagil Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yaka Yehoba i baek Mosese elana i ba, ");
INSERT INTO mpx_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Gamaun melutauil gegewel nuku pwabwabwalena-agil elau. Komiu Isileli ami gamaun ge wami bwasumu ali gamaun gegewel nau kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Yaka Mosese i baek gamagal elal i ba, “Lan ya hagalena nuku mimi awaawaginol wami abanuwahikan, kaiwena lan ya elana Yehoba alona wana gasisi i ahemiu ku tagilem Itipita wami abaloloyowana. He ebo lan ya nuku mipwawa, bahi pwalawa alona yis hi vikuhiya nuku aan. ");
INSERT INTO mpx_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lan ebe waikena Abib gamwanaa Itipita ku eeguluwan. ");
INSERT INTO mpx_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","He Yehoba i bateli tubumiyau elal Kenani, Hiti, Amoli, Pelisi, Hivi ge Yebusi wali labi ni pewa eliyamiu. Inoke sauga ni nul tukagimiu labi malumalulina o eliyana, hagali nuku ginol baliman maisena maisena ana waikena houwan elana ni ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pwalawa toto nige alona yis hi vivikuhiya nuku anan lan ana gewi seben, inoke lan mowamowasena elana hagali nuku ginol Yehoba kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pwalawa toto nige alona yis hi vivikuhiya nuku anan lan seben o gamwaliyaa. Bahi yis o ebo pwalawa alona yis hi vikuhu ni gagan wami panuwaa. ");
INSERT INTO mpx_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Hagali ana lan elana nuku baek natumiyau elal nuku ba, ‘Ginol ya ta ginol, kaiwena Yehoba ta nuwahikan hauna i ginol kaiwela sauga ta tagilem Itipita.’ ");
INSERT INTO mpx_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Hagali ya wami abanuwahikan, ni ola etotohi hi teli nimamiwa o ebo lamwamiwa. Ni panuwahikagimiu Yehoba wana Logugui nuku baubaunan, kaiwena Yehoba alona wana gasisi i ahemiu ku tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Baliman maisena maisena logugui ya nuku ginol hikahikani ana sauga hot elana. ");
INSERT INTO mpx_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Sauga Yehoba ni nulimiu nuku tuka Kenani wali labiya ge ni pewa eliyamiu, i ola wana bateli eliyamiu ge tubumiyau elal, ");
INSERT INTO mpx_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","inoke natumiyau gamaun melutauil ge wami bwasumu ali gamaun melutauil nuku guyauan Yehoba elana. He bolo ya gegewel heliya Yehoba kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Sipi natuna nuku ahe donki natuna gamaun nuku pwamola pasikal. Ebo nige nuku pwapwamola pasikal, inoke mwamwalina nuku tagaapwal. Natumiyau bolau gamwaliyaa gamaun gegewel nuku pwamola pasikalil. ");
INSERT INTO mpx_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Bwaliga ebo natumiyau nihi nel eliyamiu nihi ba, ‘Ginol ya ana sapu ga i ola?’ yaka nuku baek elal nuku ba, ‘Yehoba wana gasisi elana i ahela ta tagilem Itipita wala abaloloyowana. ");
INSERT INTO mpx_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Itipita wali kin atena i pagasisi ge i lopwalila bahi ta eegon, inoke Yehoba Itipita ali gamaun ge wali bwasumu ali gamaun gegewel i lolil. Heiya te kaiwena bwasumu ali gamaun melutauil gegewel ta powonagil Yehoba elana, ge natulau gamaun ta pwamola pasikalil.’ ");
INSERT INTO mpx_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ginol ya wami abanuwahikan, ni ola etotohi hi teli nimamiwa o ebo lamwamiwa. Ni panuwahikagimiu Yehoba alona wana gasisi i ahemiu ku tagilem Itipita.” ");
INSERT INTO mpx_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sauga Itipita wali kin gamagal i talamwagil hi egon, Yabowaine nige i nunulil hi nonoek kamwasa kaukaubwana elana, labi Pilistiya gamwanaa. Kaiwena Yabowaine i ba, “Ebo gamagalau haveyan nihi pwawa, tab abwe wali nuwatu nihi pil ge nihi sikal Itipita?” ");
INSERT INTO mpx_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yaa Yabowaine i nul painagil hi noek Hoga Keketina ana kamwasaa ula kekevana gamwanaa. He sauga Isileli hi tagilem Itipita, wali elohaveyan iyaka hi lovivina-an nonowe. ");
INSERT INTO mpx_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mosese Yosepa tutuwana i noahe, kaiwena valila Yosepa i ba Isileli nihi bateli nihi ginol ola. Valila Yosepa i ba, “Tunahot Yabowaine ni matahikagimiu ge ni ahemiu nuku na labi o elana, inoke nuku papasila te sauga o elana tutuwau al nuku kalivai.” ");
INSERT INTO mpx_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isileli Sukot hi eguluwan hi na hi holaviya Etama ula kekevana bebenaa. ");
INSERT INTO mpx_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Lana Yehoba i houwaagil i miminaa yaluyalu i milil i ola kokola elana ge kamwasa i pankitel. Bulina i houwaagil i miminaa ginaha i milil i ola kokola elana ge kamwasa i pwamwananal. Inoke bosowailiya lana ge bulina nihi nawanawa. ");
INSERT INTO mpx_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Lana yaluyalu i milil i ola kokola ge bulina ginaha i milil i ola kokola, sauga gegewena hi miminaa gamagalau awoliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yaka Yehoba i baek Mosese elana i ba, ");
INSERT INTO mpx_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Nu ba Isileli elal, nihi nopil nihi na nihi holaviya Pi Hahilot labenaa, Migadol ge Hoga Keketina ali nuwanuwanaa. Nihi holaviya hoga bebenaa, ge Bal Sepon ni minek hoga labi etega al. ");
INSERT INTO mpx_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Yaka kin ni nuwatu ni ba, ‘Isileli nuwaliya i gewagewa ge hi nonobwagabwaga ya. Nige wali abanok, kaiwena ula kekevana i kausil.’ ");
INSERT INTO mpx_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Atena na pagasisi inoke ni tatauliulil-agimiu, yaa alonau wana tolohaveyan na lakel ge wasau ni lelu. Yaka Itipita nihi atena te nau Yehoba.” Inoke Isileli hi ginol ola to. ");
INSERT INTO mpx_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sauga Itipita wali kin i hago gamagalau iyaka hi egonan, inoke alonau ana tolabe wali nuwatu hi pil ge hi ba, “I bwe ta ginol ola! Isileli iyaka ta talamwagil hi egon, yaka nige al nihi tutuwalali kaiwela!” ");
INSERT INTO mpx_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Inoke kin wana waga momomol ge wana tolohaveyan i lovivina-agil. ");
INSERT INTO mpx_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Waga momomol bolo waiwaisal ali gewi sikis handeled (600) ge Itipita ana waga momomol gegewel al, ginebi ali tomatahikan, i ahel alonau. ");
INSERT INTO mpx_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yehoba kin atena i pagasisi, inoke kin i tatauliulil Isileli eliyaa, heliya aloliya wali atimatuwa hi nawanawa. ");
INSERT INTO mpx_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Itipita ana tolohaveyan, ginebi wali hosi ge waga momomol gegewel ge ali tomatahikan, Isileli hi tataulilil-agil. Inoke hi kukuhikagil wali abaholaviya Hoga Keketina bebenaa Pi Hahilot labenaa, ge Bal Sepon i minek hoga labi etega al. ");
INSERT INTO mpx_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Sauga Isileli hi kite kin alonau wana tolohaveyan iyaka hi nopakelakelaubwa hi nenem eliyaa, inoke hi lovakun ge labe kaiwena hi yoga ha Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Yaka hi baek Mosese elana hi ba, “Ga i ola! Age nige salai i gagana Itipita ge u ahema ha nem ula kekevana elana naha yaomal? I bwe ge matama u pwamwa ha tagilem Itipita? ");
INSERT INTO mpx_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Iyaka ha pwawa i ola valila ha ba haba elam Itipita, ha ba, ‘U telema ya naha tuwalali Itipita elal.’ Binimala naha tuwalali kaiweliya, inoke nige naha yayaomal ula kekevana elana.” ");
INSERT INTO mpx_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Yaka analiya Mosese i lahe i ba, “Bahi lovakun! Ku milil gagasisi, inoke nuku kite Yehoba hauna ni ginol ge ni pwamwalimiu lan ebe. Itipita bolo ya ku kita pwamwatomwal, nige al nuku kikitel. ");
INSERT INTO mpx_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yehoba iya ni lohaveyan kaiwemiu, yaa komiu nuku mibabakuhu ya.” ");
INSERT INTO mpx_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yaka Yehoba i baek Mosese elana i ba, “Ga i ola ge labe kaiwena ku yoga eliyau? U ba Isileli nihi nawa nok awoliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Wam suki u latahin ge u paeluek hogaa, inoke ni maleli ge Isileli nihi nosola nuwanuwanaa datu pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Itipita ateliya na pagasisi, inoke nihi tatauliulil emiwa, yaka abwe kin alonau wana tolohaveyan, wana waga momomol ge ali tomatahikan, na lakel ge wasau ni lelu. ");
INSERT INTO mpx_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na lakel inoke nihi atena te nau Yehoba.” ");
INSERT INTO mpx_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Yaka Yabowaine wana anelose, iya i miminaa boda Isileli awoliyaa, i sikal i na eliyaa. I ola al yaluyalu i milil i ola kokola i sikal i na eliyaa, ");
INSERT INTO mpx_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","i miminaa boda Itipita ge boda Isileli ali hawawala. Inoke bulin bwabwaligena yaluyalu Itipita i pagogouil, yaa Isileli i pwamwananalil, yaka bulin o nige bosowailiya nihi petupatupa-agil. ");
INSERT INTO mpx_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mosese nimana i paeluek hogaa, inoke bulin bwabwaligena Yehoba babaliman gasigasisena i patowa hoga i yu pamaleli ge nuwanuwana i dato. ");
INSERT INTO mpx_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Inoke Isileli hi nosola datu pwatanaa, hoga i talmilil i ola baba labena awoliyaa ge gegebaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Yaka Itipita avaliyau wali hosi ge waga momomol gegewel ge ali tomatahikan, hi tatauliulil Isileli eliyaa hi na hi ulutuk hogaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kelaubwa lan ni gan, Yehoba i minaa yaluyalu ge ginaha hi milil i ola kokola elana inoke matana i lilowana Itipita eliyalil ge nuwaliya i pagewagewa. ");
INSERT INTO mpx_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yaka wali waga momomol ali wil i patalsup ge ali momomol i pulowan. Yaka Itipita hi ba, “Ta egonan! Yehoba Isileli i label ge i lohaveyan elala.” ");
INSERT INTO mpx_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yaka Yehoba i baek Mosese elana i ba, “Nimwam u paeluek hogaa, inoke hoga ni bini sikal Itipita avaliyau wali waga momomol ge ali tomatahikan ni yabomwil.” ");
INSERT INTO mpx_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Yaka lan i gan Mosese nimana i paeluek hogaa, inoke hoga i bini sikal abanaa. Itipita nuwaliya nihi lou, yaa Yehoba i aliyohiliek hogaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Hoga i sikal, inoke Itipita ana tolohaveyan ginebi wali waga momomol ge ali tomatahikan, bolo hi tatauliulil hi ulutuk hogaa, gegewel i yabomwil, nige etega i mwamwal. ");
INSERT INTO mpx_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","He Isileli hi nosola datu pwatanaa, hoga i talmilil i ola baba labena awoliyaa ge gegebaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Inoke lan o Yehoba Isileli i pwamwalil Itipita nimaliyaa, ge Isileli Itipita bwaliwawagal hi kitel gilesaa. ");
INSERT INTO mpx_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Sauga Isileli Yehoba wana gasisi bwabwatana hi kite Itipita i pakokovel, inoke hi lovakunan, yaka hi melteli iya ge wana totuwalali Mosese elal. ");
INSERT INTO mpx_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Yaka Mosese alonau Isileli wona ya hi wonaan Yehoba elana: Na wona Yehoba elana,   kaiwena Itipita i pakokovel hoti, hosi ge ali tomatahikan i aliyohiliek hogaa. ");
INSERT INTO mpx_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yehoba iya o libu gasigasisena,   iya i pwamwalau. Iya no Yabowaine, inoke na tobalan,   iya nam wana Yabowaine, inoke na lowasawasa-an. ");
INSERT INTO mpx_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yehoba iya toasiyala;   iya alana Yehoba, iyoho ya i gangan. ");
INSERT INTO mpx_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kin wana tolohaveyan ge wana waga momomol   i aliyohiliek hogaa; wana toematana waiwaisal   hi ununa Hoga Keketina. ");
INSERT INTO mpx_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Hoga i yabomwil;   i ola pat hi lobek limwana. ");
INSERT INTO mpx_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yehoba, nimwam awom ana gasisi i bwata;   Yehoba, nimwam awom topihigelgel i tagalekaleka-agil. ");
INSERT INTO mpx_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Alam i wasawasa hot,   kaiwena bolo hi awatautau elam u apapanak-agil; wam huga i tau i ola ginaha   ge hi kalas haba hi ola musamusa. ");
INSERT INTO mpx_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wam yana eliyana hoga u huven papahe;   hoga i hin i milil sapu i ola baba;   hoga limwalimwanina i milil i gasisi. ");
INSERT INTO mpx_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Topihigelgel hi hanaha hi ba,   “Ta tatauliulil-agil, inoke ta kukuhikagil, ge wali gogomwau ta ahe ta guyauan,   he toto nuwala gegewena ta bugulan. Haveyan kilepana ta momol tagilan abanaa,   inoke Isileli ta apapanak-agil.” ");
INSERT INTO mpx_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Yaa Yehoba, wam yana elana hoga u huven yaka i yabomwil,   hi lobek hi ola patbon hoga lolovakunina elana. ");
INSERT INTO mpx_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yehoba, henala eba ni ola owa yabowaine ona gamwaliyaa? Nige etega. Henala eba ni ola owa,   kaiwena u bwabwalena hot? Nige etega. Am lovakun i bwata ge gamagalau nihi tobalagiwa,   kaiwena owa toginol yawiyawi. ");
INSERT INTO mpx_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nimwam awom u paelu,   yaka bilibili am topihigelgel i tinonil. ");
INSERT INTO mpx_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Iyaka u pwamwalima,   inoke alona wam nunuwana nasi nu houwa-agima; wam gasisi elana nu nulima   naha tuka panuwa bwabwalena toto aloma owa ta minaa. ");
INSERT INTO mpx_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Labi ona wasa nihi hago, yaka lovakun kaiwena nihi ginu;   ati bwanabwana Pilistiya ni yowanil. ");
INSERT INTO mpx_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Labi Idom ana tonowakau nihi lovakun nabi,   Mowabi ana tohouwa nihi ginu. Kenani gamagaliliyau tuwaliya ni sasawowol; ");
INSERT INTO mpx_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","lovakun ge ati bwanabwana amnanina nihi kalaopopwi. Yehoba, wam gasisi elana,   yaka nihi mibabakuhu nihi ola pat, ana siga ama wam gamagalau bolo u pwamwalima naha nopalegel. ");
INSERT INTO mpx_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Inoke abwe nu ahema ge nu en telema wam oya elana. Yehoba, panuwa o iyaka u hile wam abamina,   labi bwabwalena toto Babala totom u ginol. ");
INSERT INTO mpx_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yehoba, owa nu tologugui   sauga gegewena nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","He Isileli hoga hi nosolaan hi nawaa datu pwatanaa, yaa sauga Itipita wali waga momomol ginebi wali hosi ge ali tomatahikan hi ulutuk hogaa, yaka Yehoba hoga i pabini pasikal ge i yabomwil. ");
INSERT INTO mpx_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Inoke Eloni nuna Miliyami, iya palopita, wana tambalin i ahe, yaka evenakau gegewel i houwaagil ginebi wali tambalin hi sagasaga. ");
INSERT INTO mpx_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliyami i wona i ola: Ku wona Yehoba elana,   kaiwena Itipita i pakokovel hoti, hosi ge ali tomatahikan i aliyohiliek hogaa. ");
INSERT INTO mpx_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Yaka Mosese Isileli i nulil Hoga Keketina hi tataluwai hi noek Sula Ulaina elana, labi kekekevana. Lan eton hi nawanawa uleya, yaa nige wewel etega hi pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Sauga hi vin panuwa Mala, he wewelina amnana i nak, yaka nige bosowailiya nihi im. (Heiya te kaiwena alana hi tun Mala.) ");
INSERT INTO mpx_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yaka gamagalau Mosese hi lovehawol-an, ge hi nel hi ba, “Hauna ta im e?” ");
INSERT INTO mpx_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Yaka Mosese i awanun nabinabi Yehoba elana, inoke Yehoba ebwakil etega i pankite ge i ahe i alilowana wewela, yaka wewel amnana i waisi. He panuwa o elana Yehoba Isileli ali logugui i pek ge i labosel. ");
INSERT INTO mpx_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","I ba, “Ebo nau Yehoba wami Yabowaine anau nuku hago bubun, wami ginol ni sapu matawa ge no logugui gegewena nuku henapuan, inoke gila ololana ya pek Itipita elal nige etega na pepewa. Nau Yehoba ami topwapwamolu.” ");
INSERT INTO mpx_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Yaka abwe hi na Ilima. He wewel bwanapitpit elulutega eluwa (12) ge deit puna sebenti (70) heliya iyoho to, inoke hi holaviya wewel bebenaa. ");
INSERT INTO mpx_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isileli ali boda Ilima hi tataluwai, inoke waikena eluwana ana lan piptin-ina hi na hi vin Sini Ulaina elana, Ilima ge Sainai ali luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","He Isileli ali boda heliya iyoho to ula kekevana elana, yaka Mosese ge Eloni hi lovehawol-agil ");
INSERT INTO mpx_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","hi ba, “Binimala Yehoba ni lolima Itipita. Valila ama lolan i bwaya ge aanan nige bosowaima naha an haba. Yaa komiu ku ahema ha nem ula kekevana ya elana inoke galebu kaiwena gegewema naha aliga.” ");
INSERT INTO mpx_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yaka Yehoba i baek Mosese elana i ba, “Sauga ya aanan na ligin paloem labulabumwa kaiwemiu. Lan maisena maisena gamagalau nihi tagilan lan maisena ana luvi nihi ahe. Inoke eliyana na labosel ebo no logugui nihi henapuan o ebo nigeya. ");
INSERT INTO mpx_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Lan sikis-ina elana lan labui ana luvi nihi ahe ge nihi lovivina-an.” ");
INSERT INTO mpx_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Inoke Mosese ge Eloni hi baek Isileli gegewel elal hi ola, “Nasi kokoyavi nuku atena te Yehoba heiya te i ahemiu ku tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","I ola al, mweluluga Yehoba mwananalina namanamalina nuku kite, kaiwena wami lovehawol iya eliyana iyaka i hago. He ama wana totuwalali ya, inoke nige ku lolovehawal eliyama.” ");
INSERT INTO mpx_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Yaka Mosese i ba vevehe al i ba, “Yehoba iya kokoyavi ami lolan ni pewa ge mweluluga aanan ni bwata ni pewa, kaiwena wami lovehawol iya eliyana iyaka i hago. Ama nige ku lovehawol-agima, Yehoba te ku lovehawol-an.” ");
INSERT INTO mpx_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Yaka Mosese i baek Eloni elana i ba, “U ba Isileli ali boda elal nihi nem nihi talmilila Yehoba awonaa, kaiwena wali hawohawol iyaka i hago.” ");
INSERT INTO mpx_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","He Eloni iyoho i baaba Isileli ali boda elal, yaka mataliya hi lipwatanik ula kekevana elana ge Yehoba mwananalina namanamalina hi kite i masala yaluyaluwa. ");
INSERT INTO mpx_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yaka Yehoba i baek Mosese elana i ba, ");
INSERT INTO mpx_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Isileli wali hawohawol iyaka ya hago. He nu baek elal nu ba, ‘Vekokoyavi lolan nuku an ge mweluluga aanan ni bwata nuku an. Inoke nuku atena te nau Yehoba wami Yabowaine.’” ");
INSERT INTO mpx_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kokoyaviya bwasumu kuweli ali yawi bwabwatana hi you vin abaholavi hi pakalaopop. Mweluluga bekubeku hunhunina abaholavi i yao painan bilibili pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Sauga bekubeku hunhunina i kevakeva, yaka bugul etega i masal bilibili pwatanaa, i alalavi ge i lokekeisi. ");
INSERT INTO mpx_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Sauga Isileli hi kite, yaka hi penelnel-agil hi ba, “Hauna gun e?” kaiwena nige hi atena hauna eba o. Yaa Mosese i baek elal i ola, “Aanan toto Yehoba i pewa amiu, heiya te. ");
INSERT INTO mpx_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yehoba wana logugui i ola hiwe, ‘Ami luvi toto bosowaimiu te nuku ahe. Wami limi ana heniheni gamagal maisena maisena ana luvi kom eit nuku ahe.’” ");
INSERT INTO mpx_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Yaka Isileli hi na hi ahe i ola to. Enuna i bwata hi ahe ge enuna nige i bwabwata hi ahe. ");
INSERT INTO mpx_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Yaa sauga eluviluvi elana hi luvi, gegewel hi ahe bubun. Bolo i bwata hi ahe ali luvi nige i lilika, ge bolo nige i bwabwata hi ahe ali luvi nige i lalau. Gegewel hi ahe paolaolaek wali limi ana heniheni ana luvi. ");
INSERT INTO mpx_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Yaka Mosese i baek elal i ba, “Bahi etega nuku aan teli bwaligumwa kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Yaa enuna Mosese anana nige hi hahago, yaka awalehina hi an teli. Lan i gan iyaka i kinol ge i bweyan, inoke Mosese i huga eliyalil. ");
INSERT INTO mpx_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mweluluga gegewena gamagal maisena ge maisena i ahe paolaolaek wana limi ana heniheni ana luvi. Sauga sabwelu iyaka i kalakalas, toto nige hi aahe i wayui. ");
INSERT INTO mpx_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Lan sikis-ina elana lan labui ana luvi hi ahe, gamagal maisena ge maisena ana luvi kom sikistin (16) hi ahe. Yaka boda wali tohouwa hi nem Mosese wana wasa hi pek. ");
INSERT INTO mpx_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Inoke i baek elal i ba, “Yehoba wana logugui i ola hiwe, ‘Bwaligumwa Sabwata lan veyaho, i bwabwalena Yehoba elana. Toto ku uumun, nuku umun, ge toto ku liliga, nuku liga. He toto nuku an teli, nuku teli bwaligumwa kaiwena.’” ");
INSERT INTO mpx_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Inoke hi ginol ola Mosese wana baaba. Enuna hi teli ana siga mweluluga, yaa nige i kikinol ge nige i bwebweyan. ");
INSERT INTO mpx_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Yaka Mosese i baek elal i ba, “Lan ebe aanan ya nuku an, kaiwena Sabwata veyaho ana lan te, i bwabwalena Yehoba elana. Lan ya nige aanan etega nuku pwapwawa bilibili pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Lan sikis amiu nuku ahiahi, yaa lan seben-ina elana, lan Sabwata, nige aanan etega nuku pwapwawa.” ");
INSERT INTO mpx_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yaa lan seben-ina elana gamagal enuna hi tagil hi na tage aliya nihi ahi, yaa nige etega hi pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Inoke Yehoba i baek Mosese elana i ba, “Hauna sauga abwe no logugui nuku henapuan? ");
INSERT INTO mpx_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Nuku nuwahikan nau Yehoba lan veyaho ya pewa, inoke lan sikis-ina elana amiu na pewa lan eluwa ana luvi. Lan seben-ina elana maisena maisena ni minaa abanaa, bahi etega ni tatagil.” ");
INSERT INTO mpx_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Inoke lan seben-ina elana gamagalau hi veyaho. ");
INSERT INTO mpx_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","He Isileli aanan alana hi tun manna. Ana awa i ola pwatum yayanana etega, ge amnana i ola bisket alona luvi hi vikuhu. ");
INSERT INTO mpx_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosese i ba, “Yehoba wana logugui i ola hiwe, ‘Manna kom eit nuku teli hikan ha mul kaiweliya. Inoke aanan nihi kite, toto ya pewa ku anana uleya sauga ya ahe tagilagimiu Itipita.’” ");
INSERT INTO mpx_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Inoke Mosese i baek Eloni elana i ba, “Manna kom eit nu wage, nu usan ulugomwa gamwanaa, inoke nu teliya Yehoba matanaa ha mul kaiweliya.” ");
INSERT INTO mpx_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Inoke Eloni i ginol ola Yehoba wana baaba Mosese elana. Manna i usan ulugomwa gamwanaa ge sauga mulaa i teli Bateli ana Dedewaga gamwanaa pat mamanana sasapona labui awoliyaa, bolo logugui ana leleli i gana tuwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isileli manna hi anan uleya baliman ana gewi poti (40) ana siga hi vin labi Kenani. ");
INSERT INTO mpx_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(He wali eluviluvi ipah gamwanaa, omel ali gewi elulutega.) ");
INSERT INTO mpx_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isileli ali boda Sini Ulaina hi eguluwai, inoke hi nawanawa panuwa ge panuwa elal i ola Yehoba wana baaba. Hi holaviya Lepidim, yaa nige ali wewel im i gagan. ");
INSERT INTO mpx_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Yaka Mosese hi lovehawol-an hi ba, “Wewel nu pem naha im.” Analiya Mosese i lahe i ba, “Ga i ola ku lovehawol-agau? Ga i ola Yehoba ku labose?” ");
INSERT INTO mpx_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yaa gamagalau hi walem nabi, inoke Mosese hi hawolan hi ba, “I bwe u ahema ha tagilem Itipita? He nasi alomeyau natumeyau ge wama bwasumu naha aliga walem kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yaka Mosese i awanun nabinabi Yehoba elana i ba, “Ga na ginol ola gamagalau ya elal? Kelaubwa nihi loipat-agau.” ");
INSERT INTO mpx_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yaka Yehoba Mosese anana i lahe i ba, “Alomwau Isileli wali tonowakau enuna ku notagil gamagalau awoliyaa, ge suki toto Naile u lololiya nu noahe. ");
INSERT INTO mpx_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Na talmilila awomwa pat pwatanaa oya Sainai. Pat nu lol, inoke wewel ni sani tagil gamagalau nihi im.” Inoke Mosese i ginol ola to Isileli wali tonowakau mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yaka panuwa alana i tun Masa ge Meliba, kaiwena Isileli hi hawohawol ge Yehoba hi labose, sauga toto hi nel hi ba, “Yehoba iyahe avala o ebo nigeya?” ");
INSERT INTO mpx_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sauga Isileli heliya iyoho panuwa Lepidim, inoke Amaleki hi nem hi lohaveyan elal. ");
INSERT INTO mpx_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Yaka Mosese i baek Yosuwa elana i ba, “Bolau enuna nu hilel ge ku na alomiyau Amaleki nuku lohaveyan. Bwaligumwa nau na talmilila oyaa ge suki toto Yehoba i pem na pihikan.” ");
INSERT INTO mpx_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwa i ginol ola Mosese wana baaba, inoke hi na avaliyau ge Amaleki hi lohaveyan. Yaa Mosese alonau Eloni ge Huli hi na hi ha oyaa. ");
INSERT INTO mpx_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Sauga ebo Mosese nimana i lalatahin inoke Isileli hi gagasisi, sauga ebo nimana i teteli lowan inoke Amaleki hi gagasisi. ");
INSERT INTO mpx_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosese nimana i alaliga, inoke pat hi teli ge i misiyowa pwatanaa. Yaka Eloni ge Huli hi talmilila labena labui, nimana hi piheyagil, inoke nimana i mihot ana siga sabwelu i lobek. ");
INSERT INTO mpx_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Inoke Yosuwa Amaleki wali tolohaveyan i pakokovel. ");
INSERT INTO mpx_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yaka Yehoba i baek Mosese elana i ba, “Amaleki ku pakokovel liwanina nu leli lowan bukiya, ginebi ge no bateli toto ya ba: nau abwe Amaleki na apapanak-agil hoti ge nige al wasaliya ni gagan panayawiya. Nu leli lowan wami abanuwahikan, inoke nu vasili Yosuwa ni hago.” ");
INSERT INTO mpx_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mosese abapowon pat i pahe inoke bwasumu i powonan Yehoba elana, yaka abapowon alana i tun, “Yehoba o Toematana.” ");
INSERT INTO mpx_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I ba, “Yehoba ala toematana ni houwa-agila. Heyan ge heyan Yehoba ni lohaveyan Amaleki elal.” ");
INSERT INTO mpx_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosese yawana Yetilo, Midiyani wali topowon, wasa i hago bugul gegewena Yabowaine i ginol wana gamagalau Isileli ge Mosese kaiweliya, sauga i nulil hi tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","He valila Mosese lagona Sipola alonau natunau bolau eluwa i patunal hi sikal yawana elana ge i matahikagil. ");
INSERT INTO mpx_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","(Mosese natuna gamaun alana i tun “Gesomi,” kaiwena i ba, “Panuwa getoga elana ya mibwabwali.” ");
INSERT INTO mpx_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Natuna eluwana alana i tun “Eliyesa,” kaiwena i ba, “Nam wana Yabowaine i labeyau inoke Itipita wali kin nige i lololau.”) ");
INSERT INTO mpx_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Sauga Mosese alonau Isileli iyoho hi holaviya oya bwabwalena labenaa ula kekevana elana, yaka Yetilo alonau Mosese lagona ge natunau bolau eluwa, hi nok nihi na elana. ");
INSERT INTO mpx_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","He mulaa abwe i vin, baaba i patuna Mosese elana i ba, “Nau yawam, alowau lagom ge natumwau bolau eluwa ha nonowa.” ");
INSERT INTO mpx_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Inoke Mosese i tagil i na yawana i kite, i kululu elana ge i nalo. Hi mulolu ge hi peliwaliwan-agil wali minamina kaiwena, yaka hi sikal hi na hi ulutuk Mosese wana epanapana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosese bugul gegewena toto Yehoba i ginolil kin alonau Itipita gamagaliliyau eliyalil ge Isileli i pwamwalil, i wasaan Yetilo elana. I ola al pulowan toto hi pwawa kamwasaa ge Yehoba ga i pwamwalil ola i wasaan. ");
INSERT INTO mpx_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetilo wasa gegewena o i hago inoke i yaliyaya, ");
INSERT INTO mpx_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ge i ba, “Yehoba ta tobalan, kaiwena i pwamwalimiu kin ge Itipita gamagaliliyau elal. Yehoba ta tobalan, kaiwena wana gamagalau i pwamwalil Itipita nimaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Iyaka ya atena Yehoba iya yabowaine gegewel i bwata lakel, kaiwena sauga Itipita Isileli hi apapanak-agil, inoke i pwamwalil.” ");
INSERT INTO mpx_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mosese yawana Yetilo bwasumu enuna i pwatanim, yaka maisena hi powon pwabwalige ge enuna hi powonagil al Yehoba elana. Yaka aanan hi ginol, inoke Eloni ge Isileli wali tonowakau gegewel hi nem avaliya Mosese yawana hi anan Yehoba matanaa. ");
INSERT INTO mpx_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Lan i gan inoke Mosese gamagalau i payatalal. He gamagalau Mosese hi milil painan mweluluga ana siga bulin i gan hi matamatan wali sauga kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Sauga Mosese yawana i kite bugul gegewena toto Mosese i ginolil, inoke i neli i ba, “Ga i ola ge bugul gegewena ya u giginol gamagalau kaiweliya? Hauna kaiwena maisem tuwalali ya u ginol mwaumwau-an ge gamagalau hi milil painagiwa mweluluga ana siga bulin i gan hi matamatan yatala kaiwena?” ");
INSERT INTO mpx_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Anana Mosese i lahe i ba, “Ya ginol ola o, kaiwena gamagalau hi nem eliyau nuwaliya Yabowaine wana nuwatu nihi atena. ");
INSERT INTO mpx_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Sauga ebo gamagalau labui bugul etega kaiwena nihi awabalgig, inoke nihi nem eliyau ge na payatalal, yaka Yabowaine anana ge wana logugui na ba pamasal elal.” ");
INSERT INTO mpx_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yaka Mosese yawana i ba, “Kamwasa toto u ginol e nige i wawaisi. ");
INSERT INTO mpx_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Owa ge bolo hi nem eliyam tuwamiu ku paaliga. He tuwalali i pulowan hot, nige bosowaim maisem nu ginol. ");
INSERT INTO mpx_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Am henapu na baunan nu hago! He Yabowaine alom ge ni labewa! Owa nu tobaaba Yabowaine elana gamagalau kaiweliya, ge wali awabalgig nu pwatanik elana. ");
INSERT INTO mpx_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yabowaine anana ge wana logugui nu pankitel, ge minamina waiwaisana ana kamwasa ge pagan bolo nihi ginol nu paatenal. ");
INSERT INTO mpx_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Yaa gamagalau toatena enuna nu hilel, bolo Yabowaine hi lovakunan, i bosowaina ali mel ta teli ge nige bosowaina gamagalau nuwaliya nihi gove gogomwau eliyalil. Nu hilel inoke nu telel gamagalau wali tohouwa, boda tausan wali tohouwa, boda handeled maisena wali tohouwa, boda pipti wali tohouwa ge boda elulutega wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Gamagalau nihi payatalal sauga gegewena. Pulowan bwabwatal gegewena nihi pwatanim elam, yaa toto i mweyaha totoliya nihi pasapu. Pulowan nihi waliwali-an inoke ni mweyaha elam. ");
INSERT INTO mpx_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","He Yabowaine wana nuwatu kaiwem i ola to. Ebo nu ginol ola o, nige tuwam ni alaliga, ge gamagalau ya gegewel nihi sikalan abaliyaa alona wali yaliyaya.” ");
INSERT INTO mpx_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosese, yawana anana i hago ge i ginol ola wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Gamagalau toatena enuna i hilel Isileli gamwaliya, inoke i telel boda tausan wali tohouwa, boda handeled maisena wali tohouwa, boda pipti wali tohouwa ge boda elulutega wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Gamagalau hi papayatalal sauga gegewena. Pulowan bwabwatal gegewena hi pwatanik Mosese elana, yaa toto i mweyaha totoliya hi pasapu. ");
INSERT INTO mpx_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yaka Mosese yawana i patuna i egon, i sikal i na wana panuwa. ");
INSERT INTO mpx_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isileli Lepidim hi tataluwai hi na hi vin Sainai Ulaina kekevana elana. He valila Itipita hi eguluwan enaa, waikena etonina ana lan houwan te hi vin labi o elana. Inoke hi na hi holaviya oya Sainai awonaa. ");
INSERT INTO mpx_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Inoke Mosese i na i ha oyaa Yabowaine elana. Yaka Yehoba i yogem oya pwatanaa Mosese elana i ba, “Nu ba Isileli, Yakobo tubutubunau elal, nu ba ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Yehoba i ba: Iyaka ku kite hauna ya ginol Itipita elal, i ola al ku atena ya kalivaimiu i ola magisubu natuna i kalivai openaa, ge ya ahemiu ku nem elau. ");
INSERT INTO mpx_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Inoke ebo anau nuku hago ge no bateli eliyamiu ana logugui nuku henapuan, komiu no gamagalau. Panayawi mamanana nau no panayawi, yaa komiu no hilihili gamagaliliyau. ");
INSERT INTO mpx_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Komiu boda bwabwalena nau kaiweu, komiu nuku ola topowon ge no tuwalali bwabwalena nuku ginol.’ He nu ba ola to Isileli eliyalil.” ");
INSERT INTO mpx_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Inoke Mosese i sikal i lau, yaka i na Isileli wali tonowakau i yoga gogonil ge bugul gegewena toto Yehoba i baunan elana i wasaanik elal. ");
INSERT INTO mpx_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Gamagal gegewel anana hi lahe hi ba, “Bugul gegewena toto Yehoba i baunan naha ginol.” Inoke gamagal wali baaba Mosese i ahe ge i na ni wasaanik Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Gamagal wali baaba i baunanik Yehoba elana, yaka Yehoba i baek elana i ba, “Na nowa yaluyalu babalona elana, inoke gamagal anau nihi hago alou owa ta baaba ge nihi abulilewa elam sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Inoke Yehoba i ba vevehe al i ba, “Nu na gamagal elal, nu ba lan ya ge bwaligumwa nihi abubunil nihi yanayana ge ali kaliko nihi ul. ");
INSERT INTO mpx_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Nihi lovivina bolu kaiwena, inoke bolu nau Yehoba na lau oya Sainai elana gamagalau gegewel mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Siga nu ginol painan oya punaa, ge nu baek gamagalau elal nu ba, ‘Nuku matahikagimiu bahi nuku haha oyaa o ebo puna nuku popoti. Ebo gamagal etega ni poti, nasi nihi lopaaliga. ");
INSERT INTO mpx_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bahi nihi lilib, yaa nihi loipati, o ebo egipoyo elana nihi howa. He bahi tuwana nihi pipihikan. Bwasumu ge gamagal ali logugui i maisena ya, nihi aliga.’ Yaa sauga ebo bwagigi hi yu hikan anana gamagalau nihi hago, yaka abwe bosowailiya nihi noha oya punaa.” ");
INSERT INTO mpx_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Yaka Mosese i loem oyaa ge i baek gamagal elal i ba, “Nuku abubunimiu nuku yanayana, ge ami kaliko nuku ul. ");
INSERT INTO mpx_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Nuku lovivina bolu kaiwena ge Yehoba ni lau nuku kite. Ge bahi alomiyau ge lagomiyau nuku kekenu toyawa.” ");
INSERT INTO mpx_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Lan etonina elana mwelulugaa, panuwa i lopinamal ge i logulumwawa, yaka yaluyalu babalona i masala oyaa ge bwagigi anana bwabwatana hi hago. Inoke gamagal gegewel abaholaviya lovakun kaiwena hi ginu. ");
INSERT INTO mpx_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Yaka Mosese gamagalau i nulil hi tagilem abaholaviya hi na hi talmilil oya punaa ge avaliya Yabowaine nihi petupatupa-agil. ");
INSERT INTO mpx_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Yehoba i loek oya Sainai pwatanaa hiwo eliyana, inoke kasu oya i pahabobu. Kasu bwabwatana i haha i ola hiwo bwabwatana hi ton kasona, oya i lamwalamwaniu nabiyan, ");
INSERT INTO mpx_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ge bwagigi anana i bwabwata nawa. Inoke Mosese i baaba, yaka anana Yabowaine i lahe gulumwawa elana. ");
INSERT INTO mpx_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Inoke Yehoba i lau oya Sainai pwatanaa i ola to. Yaka i yoga Mosese elana ni na ni ha oyaa. Inoke i na i ha, ");
INSERT INTO mpx_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ge Yehoba i baek elana i ba, “Nu na nu lau ge gamagalau nu lopwalil bahi siga nihi lilikaan nihi nenem nihi kikiteyau. Ebo siga nihi likaan, nasi nihi gewi nihi aliga.” ");
INSERT INTO mpx_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","(Bwagana topowon, heliya hi noknok Yehoba elana, he houwan ga nihi pwabwabwalena-agil nihi yanayana. Ebo nigeya, alona wana huga ni lahel.) ");
INSERT INTO mpx_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosese i baek Yehoba elana i ba, “Nige bosowaina gamagal nihi ha oyaa, kaiwena owa u ba, ‘Oya u teli ni bwabwalena ge siga nu ginol painan.’” ");
INSERT INTO mpx_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Anana Yehoba i lahe i ba, “Nu lau ge Eloni nu en alom nuku nem. Yaa topowon ge gamagalau bahi siga nihi lilikaan ge nihi nenem elau, eba alou no huga na lahel.” ");
INSERT INTO mpx_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Yaka Mosese i na i lau gamagalau elal ge wali wasa i pek hauna Yehoba i baunan elana. ");
INSERT INTO mpx_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yabowaine i ba i ola hiwe, ");
INSERT INTO mpx_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nau Yehoba wami Yabowaine, ya ahemiwa Itipita wami abaloloyowana. ");
INSERT INTO mpx_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Bahi yabowaine etega al nuku kukululuek elana, nau maiseu ya. ");
INSERT INTO mpx_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Bahi gogoginol etega nuku giginol kaiwemiu, ebo labulabum bugulina kakanunina, ebo panayawi bugulina kakanunina, o ebo hoga bugulina kakanunina. ");
INSERT INTO mpx_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Bahi nuku kukululuek gogoginol etega elana o ebo nuku tatapwaloloek elana, kaiwena nau Yehoba wami Yabowaine nige ya tatalam o toawalaka ni gan. Lahi na pek o topihigelgel elal. Lahi ya ni kalapapanet natuliyau, tubuliyau ge tubuliyau natuliyau elal. ");
INSERT INTO mpx_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Yaa bolo hi nunuwana-agau ge no logugui hi henapuan, na nunuwana-agil heyan ge heyan nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Bahi nau Yehoba wami Yabowaine alau nuku lulumen bwabwage, kaiwena ebo etega alau ni lumen bwabwage abwe na lahe. ");
INSERT INTO mpx_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","; - “Lan Sabwata nuku nuwahikan ge nuku teli ni bwabwalena. ");
INSERT INTO mpx_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Wami tuwalali nuku ginol lan sikis gamwanaa, ");
INSERT INTO mpx_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","yaa lan seben-ina elana lan veyaho i bwabwalena elau. Lan yaka bahi etega ni tutuwalali, ebo komiu, ebo natumiyau, ebo wami totuwalali, ebo wami bwasumu, o ebo bwabwali bolo hi miminaa wami panuwaa. ");
INSERT INTO mpx_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nau Yehoba, panayawi, labulabum, hoga, ge buguliliyau gegewel ya ginolil lan sikis gamwanaa, yaa lan seben-ina ya veyaho. Heiya te kaiwena lan Sabwata ya ba muloluan ge ya teli i bwabwalena. ");
INSERT INTO mpx_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Tamwam ge hinam nu awatauwagil, inoke yawalim ana minamina ni yapu panuwa toto na pewa elana. ");
INSERT INTO mpx_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Bahi taulol. ");
INSERT INTO mpx_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Bahi ganawal. ");
INSERT INTO mpx_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Bahi kaoma. ");
INSERT INTO mpx_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Bahi woliwoli kakakawi. ");
INSERT INTO mpx_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Alom wana limi, ebo lagona, ebo wana totuwalali bolau ge yowau, ebo wana bulumwakau, wana donki ge wana bugul gegewena, bahi etega matam ni momomoni-an.” ");
INSERT INTO mpx_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","He gamagalau gulumwawa ge bwagigi anana hi hago, i ola al pinamal ge oya i kasukasu hi kite, yaka lovakun kaiwena hi ginuginu. Inoke hi talmililek laha, ");
INSERT INTO mpx_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ge hi baek Mosese elana hi ba, “Owa nu baaba eliyama ge naha laegan elam. Yaa bahi Yabowaine totona ni baaba eliyama, eba naha aliga.” ");
INSERT INTO mpx_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Analiya Mosese i lahe i ba, “Bahi lovakun. Yabowaine i nem wana gasisi amnana nuku anbose, inoke iya ana lovakun ni minaa eliyamiu ge bahi nuku gegegi eliyana.” ");
INSERT INTO mpx_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Yaa gamagalau iyoho ya hi milimilil laha, inoke Mosese maisena i noha yaluyalu babalona elana, toto Yabowaine i miminaa. ");
INSERT INTO mpx_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Yehoba i ba, “Logugui bolo hiwe nu pek elal.” ");
INSERT INTO mpx_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yehoba i baek Mosese elana i ba, “Alomwau Eloni, Nadab, Abihu ge Isileli wali tonowakau ali gewi sebenti nuku ha oyaa eliyau. Nuku minek laha ge nuku tapwalolo elau. ");
INSERT INTO mpx_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Owa maisem ya te bosowaim nu nem labewa, yaa alomwau bahi nihi nenem labewa, ge gamagalau bahi nihi haha oyaa.” ");
INSERT INTO mpx_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Yaka Mosese i na i lau Yehoba wana baaba ge wana logugui gegewena i wasaanik gamagalau elal. Inoke gegewel pamaisena anana hi lahe hi ba, “Bugul gegewena toto Yehoba i baunan naha ginol.” ");
INSERT INTO mpx_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Inoke Mosese Yehoba wana baaba gegewena i leli lowan. Lan i gan mweluluga kekeisi i na oya punaa, yaka pat i pahe abapowon i ginol, ge pat elulutega eluwa al i pamilil, ali gewi i olaolaek Isileli ali un. ");
INSERT INTO mpx_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yaka hevalau enuna i hilel ge i patunal bulumwakau hi powonagil Yehoba elana, enuna hi powon pwabwaligel ge enuna hi powonagil heliheliyam powonina. ");
INSERT INTO mpx_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosese bwasumu saliyaliya awalehina i ahe i holek mwaha gamwanaa, ge awalehina i ahe abapowon i hol seuseulan. ");
INSERT INTO mpx_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Yaka buki toto Yehoba wana bateli eliyalil ana logugui i leli lowana, i ahe i vasili gamagalau tanaliyaa. Yaka hi talam hi ba, “Yehoba anana naha henapuan, ge bugul gegewena toto i baunan naha ginol.” ");
INSERT INTO mpx_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Yaka Mosese saliya ana mwaha i ahe gamagalau i hol seuseul-agil, ge i ba, “Saliya ya bateli toto alomiu Yehoba ku pebabateli-agimiu i patunahot. Bateli o ana logugui i ola baaba gegewena toto iyaka ya vasili eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Yaka Mosese alonau Eloni, Nadab, Abihu ge Isileli wali tonowakau ali gewi sebenti hi na hi ha oyaa, ");
INSERT INTO mpx_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","inoke Isileli wali Yabowaine hi kite. Aena gabulanaa bugul mamanana sasapona ana awa i ola pat sapaya, ge i namanamal i ola alalati bwagatau labulabum namanamalina. ");
INSERT INTO mpx_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yaa Yabowaine nige nak etega i giginol Isileli wali tonowakau elal. Hi kite, inoke hi anan ge hi im Yehoba matanaa. ");
INSERT INTO mpx_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yehoba i baek Mosese elana i ba, “U nem u ha oyaa elau ge nu miminaa te. Pat mamanana sasapona labui abwe na pewa, toto gamagalau ali logugui ge ali ba pagasisi iyaka ya leli.” ");
INSERT INTO mpx_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosese alona ana tolabe Yosuwa hi lovivina ge nihi ha oya bwabwalena. ");
INSERT INTO mpx_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Inoke Mosese i baek tonowakau elal i ba, “Ku matamatan te abaholaviya ana siga naha sikalim. He Eloni ge Huli iyahei alomiyau, inoke ebo gamagalau labui bugul etega kaiwena nihi awabalgig, nihi nok nihi kitel.” ");
INSERT INTO mpx_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Sauga Mosese i na i ha oyaa, yaka yaluyalu oya i yabom, ");
INSERT INTO mpx_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","ge Yehoba mwananalina namanamalina i lau oya Sainai. Isileli hi kite ana awa i ola ginaha tautauina oya pwatanaa. He lan sikis yaluyalu oya i kaus, ana siga lan seben-ina elana abwe Yehoba i yogem yaluyalu gamwanaa Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Yaka Mosese i nosola yaluyalu gamwanaa ge i na i ha oya pwatanaa. He i miminaa oyaa lan poti ge bulin poti. ");
INSERT INTO mpx_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yehoba i baek Mosese elana i ba, ");
INSERT INTO mpx_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Nu baek Isileli elal wali mulolu nihi pwatanim elau. Henala atena i talam, wana mulolu ni pwatanim ge nu ahe nau kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Nu ba limi bwabwalena nihi tal kaiweu ge na miminaa gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Limi bwabwalena ya ginebi ge bugubugulina gegewena nuku ginol ni olaolaek toto na pankitewa.” ");
INSERT INTO mpx_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Gold enona hot nu ahe dedewaga ana heguna nu ginoliya, wami gegi ana abayakiyakil. Heguna o ana yapu 110 sentamita ge ana manamana 66 sentamita. ");
INSERT INTO mpx_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Gold nu ahe bwasumu labui opeliya gaganina nu bub ginolil, ");
INSERT INTO mpx_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","etegana ni minaa buhuna etega, eluwana ni minaa buhuna etega. Ginebi heguna nu ginolil toyawe. ");
INSERT INTO mpx_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Opeliya nihi anal inoke heguna nihi pahabobu. Awoliya nihi pempewa ge maniniliya ni lau heguna elana. ");
INSERT INTO mpx_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pat mamanana sasapona labui toto abwe na pewa nu teliya dedewaga gamwanaa, inoke ana heguna nu pom. ");
INSERT INTO mpx_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ta petupatupa-agilaa to. Na minaa Bateli ana Dedewaga ana heguna pwatanaa bwasumu labui opeliya gaganina ali luwaluwala, inoke alou owa ta liwaliwan ge no logugui na pewa Isileli kaiweliya.” ");
INSERT INTO mpx_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","“Beleid bwabwalena nuku teliya teibol ya pwatanaa ge sauga gegewena ni miminaa maniniwa.” ");
INSERT INTO mpx_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Gold enona hot nu ahe odam abaliya nu ginoliya.” ");
INSERT INTO mpx_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Nu ba talim Eloni alonau natunau Nadaba, Abihu, Eliyesa ge Idamal nihi nem elam, inoke nu teli getogaagil Isileli gegewel al elal nihi topowon eliyau. ");
INSERT INTO mpx_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kaliko bwabwalel nu ginolil talim Eloni kaiwena, inoke ana awa ni waisi ge gamagalau nihi awatauwan. ");
INSERT INTO mpx_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","“Pat nu telel ipod ana egimwan elal Isileli ali un elulutega eluwa etotoheliya. Inoke alaliya Eloni ni kalivai vevelana pwatanaa, yaka nau Yehoba no gamagalau na nuwahikagil sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Sauga ebo Eloni ni ulutuk Aban Bwabwalena gamwanaa, Isileli ali un alaliya ni kalivai iyoho hi mina babagal ana kama elana, inoke nau Yehoba no gamagalau na nuwahikagil sauga gegewena. ");
INSERT INTO mpx_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ulim ge Tamim nu usan babagal ana kama gamwanaa, inoke sauga ebo Eloni ni tuk Aban Bwabwalena gamwanaa maniniwa, ni kalivail babagalinaa. Inoke bugul bolo i papatuwalali no nuwatu i loloyaan no gamagalau kaiweliya, ni kalivail babagalinaa nau Yehoba maniniwa.” ");
INSERT INTO mpx_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","“Eloni holahola yayapona ya ni galoi abwe ni tuwalali kaiweu. Sauga ebo ni ulutuk Aban Bwabwalena elana ni nem nau Yehoba matawa o ebo ni tagil al, kal butuliya ni gan inoke nige ni aaliga.” ");
INSERT INTO mpx_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","“Leleli o ni minaa Eloni lamwanaa. He sauga ebo Isileli wali mulolu nihi pwatanim nihi pwabwabwalena elau, yaka wali gegi Eloni ni kalivai. Sauga gegewena leleli ni teli lamwanaa, inoke nau Yehoba gamagalau na awa sapusapu-agil. ");
INSERT INTO mpx_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Nu ba hihiu kaliko waiwaisana kaiwena nihi ahe holahola yayapona hot nihi ginoliya, i ola al hihiu kaliko waiwaisana kaiwena elana kowakowa ana eyabom nihi ginoliya. Hihiu ali kala tomaha nihi ahe matan nihi palul ginol, yaka eliyana wasikewa nihi ginol. ");
INSERT INTO mpx_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Nu ba holahola yayapol hot, wasikewa ge kowakowa ana eyabom nihi ginolil Eloni natunau kaiweliya, inoke ali awa ni waisi ge gamagalau nihi awatauwagil.” ");
INSERT INTO mpx_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Mweluluga gegewena sauga Eloni odam ni pabolol ge ni abubunil, yaka bugul bwalena waiwaisana ni ton ana abatontona. ");
INSERT INTO mpx_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ge kokoyavi gegewena sauga odam ni tonil, bugul bwalena waiwaisana ni ton al. Inoke heyan ge heyan bugul bwalena waiwaisana topowon nihi tonton ge kasona ni haha nau Yehoba maniniwa.” ");
INSERT INTO mpx_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Sauga Yehoba i baaba haba Mosese elana oya Sainai pwatanaa, yaka pat mamanana sasapona labui i pek elana, bolo bateli ana logugui nimana elana i leli tuwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sauga i yapu Mosese i minamina oyaa nige i sisikal, inoke gamagal hi nogogo Eloni elana ge hi ba, “Tau toto Mosese i ahela ta tagilem Itipita, iya ga? Nige ta aatena hauna gun i gan elana. Inoke wala yabowaine etega u ginol ge ni nulila.” ");
INSERT INTO mpx_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Yaka analiya Eloni i lahe i ba, “Komwakomwa gold toto lagomiyau, ge natumiyau yowau ge bolau hi papahe, ku palo ge ku pwatanim elau.” ");
INSERT INTO mpx_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Yaka gamagalau gegewel bolo ali komwakomwa gold i gan, hi ahe ge hi pwatanik Eloni elana. ");
INSERT INTO mpx_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Inoke Eloni gold i ahe i pawayui ge bulumwakau natuna melutauina kakanununa etega i ginol. Yaka gamagal hi ba, “Isileli wala yabowaine te, toto i nulila ge ta tagilem Itipita.” ");
INSERT INTO mpx_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Sauga Eloni gamagalau wali yaliyaya i kite, yaka pat i pahe abapowon i ginol bulumwakau gold awonaa, ge i ba, “Bwaligumwa hagali ta ginol Yehoba kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Lan i gan mweluluga kekeisi, gamagalau bwasumu hi bugul pwatanim. Enuna hi powon pwabwaligel, ge enuna hi powonagil heliheliyam powonina, inoke aanan hi ginol. Yaka hi misiyo hi anan ge hi imwim, inoke hi lutan ge neganega paganina hi awaawaginol. ");
INSERT INTO mpx_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yaka Yehoba i baek Mosese elana i ba, “Etimwawa u sikal u na u lau, kaiwena wam gamagalau bolo u nulil hi tagilem Itipita, iyaka hi gegi ge hi towaagau. ");
INSERT INTO mpx_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kamwasa toto ya ba nihi toulil iyaka hi tataluwai. Gold hi ahe bulumwakau kakanununa hi ginoliya, yaka hi kululuek elana ge bwasumu hi powonan elana. Hi ba, ‘Isileli wala yabowaine te, toto i nulila ta tagilem Itipita.’ ");
INSERT INTO mpx_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Iyaka ya atena gamagal ya ateliya i pat. ");
INSERT INTO mpx_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Bahi nu kakausau. Ya huga elal ge nuwau na apapanak-agil, yaa owa tubutubumwau nihi gewi na pewa nihi tabwa boda bwabwatana.” ");
INSERT INTO mpx_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Yaa Mosese i awanun lawalawakik Yehoba, iya wana Yabowaine elana, i ba, “Yehoba, i bwe ge u huga nabi wam gamagalau elal, bolo wam gasisi bwabwatana elana u ahel tagilagil Itipita? ");
INSERT INTO mpx_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nasi Itipita nihi ba, ‘Age nuwatu nanakina kaiwena te Yehoba i nulil tagilagil, nuwana ni lolil oyaa ge ni gulil habal panayawiya.’ Bahi nu huhuga, nu laumwal, ge bahi nak toto o nu giginol wam gamagalau elal. ");
INSERT INTO mpx_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wam totuwalali Abalahama, Aisake ge Yakobo nu nuwahikagil. Valila totom alam u papasila-an, inoke u bateli elal u ba, ‘Tubutubumwau nihi gewi na pewa, ali gewi ni ola putum hawawala. Inoke panuwa gegewena ya na pek ni ola no bateli, ge ni mihot elal.’” ");
INSERT INTO mpx_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Inoke Yehoba wana nuwatu i pil ge nak toto tage ni ginol wana gamagalau elal i nuwayoho. ");
INSERT INTO mpx_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Yaka pat mamanana sasapona labui bolo bateli ana logugui Yehoba i leli tuwaliyaa, Mosese i ahe ge i na i lau. He ali leleli i minaa labeliya labui elal. ");
INSERT INTO mpx_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yabowaine totona pat mamanana sasapona i talil, ge totona ali leleli i lelel tuwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosuwa i hago gamagal hi loloi, inoke i baek Mosese elana i ba, “Anan ya hago abaholaviya i ola te lohaveyan i gagan.” ");
INSERT INTO mpx_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Anana Mosese i lahe i ba, “Anan ana hago nige i oola ebo tagalaka i gan ge hi loloi. Ana hago nige i oola ebo hi pakokovel ge hi lolokahin. He anan toto ya hago i ola te hi wonawona.” ");
INSERT INTO mpx_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Sauga Mosese i nem abaholavi labenaa, bulumwakau gogoginolina i kite ge gamagalau hi sagasaga i kitel, inoke i huga nabi. Yaka pat mamanana sasapona labui i alilowan oya punaa ge hi tal mamagebal. ");
INSERT INTO mpx_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Inoke bulumwakau gogoginol i ahe, i ton ginaha elana, ge i wowol i tabwa papakova. Inoke i na i yoholowan Isileli ali wewel elana ge i ba hi im. ");
INSERT INTO mpx_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Yaka i baek Eloni elana i ba, “Gamagalau ya hauna hi ginol elam ge u nulil pagegel gegi bwabwatana ya hi ginol?” ");
INSERT INTO mpx_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Yaka anana Eloni i lahe i ba, “Tonowak, bahi nu huhuga elau. U atena ya gamagalau pagan nanakina iyaka hi tounuwe. ");
INSERT INTO mpx_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Hi baem elau hi ba, ‘Tau toto Mosese i ahela ta tagilem Itipita iya ga? Nige ta aatena hauna i gan elana. He wala yabowaine etega u ginol ge ni nulila.’ ");
INSERT INTO mpx_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Yaka ya baek elal ya ba, ‘Tuwamiu ana isela gold elana hi ginoliya ku palo.’ Inoke hi ginol hi ola, ge hi pwatanim elau. Inoke ya alilowana ginaha elana ge hi tabwa bulumwakau kakanununa toto ya.” ");
INSERT INTO mpx_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosese i kite Eloni gamagalau i teli yohil hi ginoginol bwagabwaga ya, inoke totoliya ali talawasi hi ginol ali topihigelgel elal. ");
INSERT INTO mpx_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Inoke i talmilila abaholavi ana abauluulutuka, ge i yoga i ba, “Bolo nuwamiu nuku minaa Yehoba wana boda elana, he nuku nem elau.” Inoke un Libai gegewel hi nogogo hi na elana. ");
INSERT INTO mpx_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Yaka i baek elal i ba, “Yehoba, Isileli wala Yabowaine, i ba i ola hiwe, ‘Komiu maisena ge maisena wami elohaveyan kilepana nuku ahe. Inoke abaholavi nuku nem nowaan, nuku telipunaa buhuna etega nuku nok buhuna etega, yaka talimiyau ge alomiyau nuku lolil.’” ");
INSERT INTO mpx_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Inoke un Libai hi na hi ginol ola Mosese wana baaba. Yaka lan o elana gamagal ali gewi tili tausan (3,000) hi gopapaaliga-agil. ");
INSERT INTO mpx_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mosese i ba un Libai elal i ba, “Yehoba wana baaba ku henapuan yaka talimiyau ge natumiyau ku lolil. Inoke lan ebe Yehoba i ba muloluagimiu ge iyaka i pwabwabwalena-agimiu wana tuwalali kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Lan i gan, yaka Mosese i baek gamagalau elal i ba, “Gegi toto ku ginol i nak hot. Sauga ya na ha oyaa Yehoba elana. Tabam bosowaina na awanun elana inoke abwe wami gegi ni nuwaehik.” ");
INSERT INTO mpx_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Inoke Mosese i sikal, i na i ha oyaa Yehoba elana ge i baek elana i ba, “Gamagalau ya gegi toto hi ginol i nak hot. Gold hi ahe wali yabowaine gogoginol hi ginol ge hi kululuek elana. ");
INSERT INTO mpx_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ya awanun elam te wali gegi u nuwayoho. Ebo nigeya, he alau u leke yoho buki toto wam gamagalau alaliya u leleliya.” ");
INSERT INTO mpx_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Anana Yehoba i lahe i ba, “Nigeya! Bolo hi gegi elau heliya te alaliya na leke yoho no bukiya. ");
INSERT INTO mpx_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","U nok u na gamagalau nu nulil nuku na panuwa toto iyaka ya baunaniwa. He no anelose ni nohouwa awomiwa. Yaa ebo no sauga ni pwawa, abwe gamagalau wali gegi na lahe.” ");
INSERT INTO mpx_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yaka abwe Yehoba gamagalau i lahel kasiyebwa nanakina elana, kaiwena hi kululuek bulumwakau gogoginol, toto gold elana Eloni i ginoliya. ");
INSERT INTO mpx_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yehoba i baek Mosese elana i ba, “Alomwau gamagalau bolo u ahel tagilagil Itipita, panuwa ya nuku tataluwai, nuku nok nuku na labi toto ya bateli Abalahama, Aisake ge Yakobo elal, ya ba, ‘Nau abwe na pek tubutubumiyau elal.’ ");
INSERT INTO mpx_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Anelose etega na patuna ni houwa awomiwa, yaka Kenani, Amoli, Hiti, Pelisi, Hivi ge Yebusi na takel yohil. ");
INSERT INTO mpx_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Nuku na panuwa malumalulina, yaa nau nige na nonowa alowau komiu, eba na apapanak-agimiu kamwasaa, kaiwena atemiu i pat.” ");
INSERT INTO mpx_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Sauga gamagalau baaba pupulowanina o hi hago, inoke hi lokahin, yaka nige tuwan ana isela etega hi papahe. ");
INSERT INTO mpx_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","He Yehoba iyaka i ba haba Mosese elana i ba, “Nu baek Isileli elal nu ba, ‘Atemiu i pat. Bwagana ebo sauga kekeisi ya na nowa alowau komiu, yaa nasi na apapanak-agimiu. Inoke tuwamiu ana isela nuku palo, yaka abwe na nuwatu al hauna na ginol eliyamiu.’” ");
INSERT INTO mpx_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Yaka oya Sainai elana Isileli tuwaliya ana isela hi palo, nige al hi papahe. ");
INSERT INTO mpx_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Sauga ebo Isileli hi hoholavi panuwa etega elana, yaka Mosese epanapana ni ahe ni pamilil kekeisi ana bwaga ni gan wali abaholavi elana. Inoke epanapana o alana hi tun “Petupatupa Limena.” Henala ebo Yehoba wana nuwatu ni loyaan, ni nok ni na Petupatupa Limena elana abaholavi tolinaa. ");
INSERT INTO mpx_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Sauga ebo Mosese ni tagilem abaholaviya ge ni nanawa Petupatupa Limena kaiwena, yaka gamagalau nihi talmilila wali epanapana ana nog elal, ge nihi gagayawa-an, ana siga ni na ni tuk Petupatupa Limena gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Yaka yaluyalu toto i milil i ola kokola ni lau ni milila Petupatupa Limena ana nog elana, inoke Yehoba alona ge Mosese nihi baaba. ");
INSERT INTO mpx_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sauga yaluyalu i milil i ola kokola gamagalau nihi kite Petupatupa Limena ana nog elana, inoke nihi talmilila wali epanapana ana nog elal ge nihi tapwalolo. ");
INSERT INTO mpx_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yehoba alona ge Mosese hi pepeliwaliwan-agil, i ola gamagal alona ge alona hi liwaliwan. Yaka Mosese ni sikal abaholaviya, yaa ana tolabe heval Yosuwa, Nan natuna, i miminaa Petupatupa Limena elana. ");
INSERT INTO mpx_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosese i baek Yehoba elana i ba, “Valila u babaem elau u babaa, ‘Gamagalau u nulil,’ yaa nige no wasa u pepem bubun henala alou ge naha nok. I ola al u baem elau u ba, ‘Ya atena bubuniwa ge ya yaliyaya kaiwem.’ ");
INSERT INTO mpx_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ebo u yaliyaya kaiweu, he wam pagan u pankiteyau, inoke na atenawa bubun ge na payaliyaya-agiwa. Nu nuwahikan al gamagalau ya heliya wam hilihili gamagaliliyau.” ");
INSERT INTO mpx_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Anana Yehoba i lahe i ba, “Nau na nowa alou owa, inoke na paveyaho-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Yaka Mosese i baek elana i ba, “Ebo nige nu nenem aloma owa, bahi nu babaa panuwa ya naha tataluwai. ");
INSERT INTO mpx_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","He gamagalau ga nihi atena ola tage u yaliyaya kaiweu ge wam gamagalau kaiweliya, ebo nige aloma owa ta nonok? Owa u minaa eliyama, inoke toto ya i pagetoga-agima gamagalau gegewel al elal panayawiya.” ");
INSERT INTO mpx_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Inoke Yehoba i baek Mosese elana i ba, “Na ginol ni ola wam awanun, kaiwena ya atena bubuniwa ge ya yaliyaya kaiwem.” ");
INSERT INTO mpx_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Yaka Mosese i ba, “Ebo i ola, he mwananalim namanamalina nu pankiteyau.” ");
INSERT INTO mpx_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yaka Yehoba i ba, “Na ba no waisi gegewena ni nopanet maninimwa, ge alau Yehoba na lumen tanamwa. Henala ebo na atilomwan-an, inoke na atilomwan-an, ge henala ebo na nuwaleyan-an, inoke na nuwaleyan-an. ");
INSERT INTO mpx_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Yaa nige bosowaina maniniu nu kite, kaiwena ebo etega maniniu ni kite, nasi ni aliga. ");
INSERT INTO mpx_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Abamina iyahe labewa i bosowaina nu talmilila pat etega eliyana. ");
INSERT INTO mpx_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Sauga mwananaliu namanamalina ni nopanet maninimwa, yaka na telewa pat malelena golinaa, ge nimwau elana na pahabobowa ana siga na nopalegewa. ");
INSERT INTO mpx_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Yaka nimwau na ahe yoho, inoke eputeteu nu kite, yaa maniniu nige nu kikite.” ");
INSERT INTO mpx_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yehoba i baek al Mosese elana i ba, “Pat mamanana sasapona labui nu gotalil ni ola bolo houwan. Baaba bolo ya leli pat houwan elal ge u tagagebal, he na leli al pat vavalul elal. ");
INSERT INTO mpx_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nu lovivina, yaka bwaligumwa mweluluga nu ha oya Sainai ge nu nem elau oya pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Bahi gamagal etega alom nuku nenem o ebo ni gagan oyaa. Ge bahi sipi o ebo bulumwakau nihi anana oya punaa.” ");
INSERT INTO mpx_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Inoke Mosese pat mamanana sasapona labui i gotalil i ola bolo houwan, yaka lan i gan mweluluga, i noahel ge i ha oya Sainai, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yehoba yaluyalu elana i lau i talmilil alona Mosese, inoke alana i lumen Yehoba. ");
INSERT INTO mpx_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yaka i nopanet Mosese manininaa, ge i yoga i ba, “Nau Yehoba, Yabowaine toatilomwan ge tonuwaleyan, nige etimwawa ya huhuga, nunuwana ya kalaopopwi ge ya giginol i ola no baaba. ");
INSERT INTO mpx_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","No gamagalau ya nunuwana-agil heyan ge heyan nige ni momowasi, wali nak ge wali gegi ya nunuwayoho. Yaa bolo hi gegegi ali lahi nige ni kakala. Lahi ya ni kalapapanet natuliyau, tubuliyau ge tubuliyau natuliyau elal.” ");
INSERT INTO mpx_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Etimwawa Mosese i kululu maninina i pahanalowanek bilibiliya inoke i tapwalolo, ");
INSERT INTO mpx_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ge i ba, “Babala, ebo tunahot u yaliyaya kaiweu, ya awanun elam nu nem aloma owa. Gamagalau ya ateliya i pat, yaa wama nak ge wama gegi u nuwayoho, ge u ahema ama wam hilihili gamagaliliyau sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Inoke anana Yehoba i lahe i ba, “Sauga ya no bateli na ginol eliyamiu. Isileli mataliyaa ginol yawiyawi na ginolil, ololal nige sauga etega ya giginol panayawi labena etega boda etega mataliyaa. Boda bolo hi minaa labemiwa nihi kite hauna nau Yehoba na ginol kaiwemiu, inoke nuwaliya nihi ahe ge nihi lovakun. ");
INSERT INTO mpx_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Logugui toto na pewa lan ya nuku henapuan. He nau abwe Amoli, Kenani, Hiti, Pelisi, Hivi ge Yebusi na takel awomiwa. ");
INSERT INTO mpx_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Yaa nuku matahikagimiu bahi alomiyau panuwa toto ku nonoek gamagaliliyau nuku pepebabateli-agimiu, eba nihi paona-agimiu. ");
INSERT INTO mpx_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Wali abapowon ona nuku tagalekaleka-an, pat bolo hi pamilil wali abakululu nuku tagagebagebal-an, ge ebwakil bolo hi pamilil wali yabowaine Asela etotohena nuku gogabogabomwil. ");
INSERT INTO mpx_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Bahi nuku kukululuek yabowaine getoga etega elana, kaiwena nau Yehoba nige ya tatalam o toawalaka ni gan. ");
INSERT INTO mpx_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Bahi alomiyau panuwa o gamagaliliyau nuku pepebabateli-agimiu. Kaiwena sauga nihi kululu ge bwasumu nihi powonan wali yabowaine elal, yaka abwe nihi yoga pahemiu ge wali powon enona nuku an. ");
INSERT INTO mpx_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","I ola al, ebo natumiyau bolau panuwa o yowauiliyau nihi alolonagil, yaka yowau o natumiyau nihi nulil pagegel ge nihi kululuek wali yabowaineyau elal. ");
INSERT INTO mpx_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Bahi yabowaine gogoginol etega nuku giginol ge nuku kukululuek elana. ");
INSERT INTO mpx_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Pwalawa toto Nige alona Yis Hi Vivikuhiya Hagalena nuku ginol, ni ola no baaba eliyamiu. Weikena Abib gamwanaa lan seben pwalawa nige alona yis hi vivikuhiya nuku an, kaiwena waikena o gamwanaa te ku tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Natumiyau gamaun melutauil, avaliyau wami bulumwakau, sipi ge goti natuliyau gamaun melutauil, gegewel nau kaiweu. ");
INSERT INTO mpx_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Sipi natuna nuku ahe donki natuna gamaun nuku pwamola pasikal. Yaa ebo nige nuku pwapwamola pasikal, inoke mwamwalina nuku tagaapwal. Natumiyau gamaun melutauil gegewel nuku pwamola pasikalil. “Bahi etega nimana enoenovana ge ni nenem eliyau. ");
INSERT INTO mpx_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Wami tuwalali nuku ginolil lan sikis gamwanaa, yaa lan seben-ina elana nuku veyaho. Bwagana wami tuwalali i bwaya ololana pelpel o ebo pahi ali sauga, nuku veyaho. ");
INSERT INTO mpx_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Pahi Hagalena nuku ginol hikahikani sauga nuku telipuna witi nuku pahe. I ola al, Epanapana Hagalena nuku ginol hikahikani sauga pahi gegewena ni mowasi. ");
INSERT INTO mpx_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Baliman maisena gamwanaa hagali eton nuku ginolil, inoke eliyana wami bolau gegewel nihi nem nihi tapwalolo nau Babala Yehoba, Isileli wami Yabowaine elau. ");
INSERT INTO mpx_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Boda tomaha tomaha ona na takel awomiwa, inoke wami labi na pwabwata. Sauga ebo hagali eton ya nuku ginolil ge nuku tapwalolo elau, nige gamagal etega wami panuwa ni oe. ");
INSERT INTO mpx_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Sauga bwasumu nuku powonan elau, bahi ginebi pwalawa toto alona yis hi vikuhiya. Bwasumu toto nuku lol Nopalegi Hagalena kaiwena, bahi etega nuku an teli mweluluga kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Baliman maisena ge maisena wami bilibili enowaliya toto ni matuwa houwa nuku pwatanim nau Yehoba no limiya. “Bahi goti natuna bunumwina nuku liligaa hinana hulina suina elana.” ");
INSERT INTO mpx_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yaka Yehoba i baek Mosese elana i ba, “Baaba bolo o nu leli lowan, kaiwena no bateli toto ya ginol owa ge Isileli eliyamiu ana logugui ona i ola to.” ");
INSERT INTO mpx_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosese alona Yehoba hi miminaa oyaa lan poti ge bulin poti, nige i aanan ge nige i iim. Yehoba wana bateli ana logugui i leli pat mamanana sasapona labui tuwaliyaa, baaba o Logugui Elulutega. ");
INSERT INTO mpx_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Sauga Mosese i loem oyaa, pat mamanana sasapona labui bolo bateli ana logugui Yehoba i leli tuwaliyaa, i noahe. Yaa nige i aatena te maninina i namanamal kaiwena alona Yehoba hi liwaliwan. ");
INSERT INTO mpx_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","He Eloni ge gamagalau gegewel Mosese maninina hi kite i namanamal, inoke hi lovakun nige hi nonoek labenaa. ");
INSERT INTO mpx_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Yaa Mosese Eloni ge boda wali tohouwa gegewel i yogaagil hi na elana, inoke i baaba elal. ");
INSERT INTO mpx_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Yaka abwe Isileli gegewel hi nogogo elana, inoke logugui gegewena toto Yehoba i pek oya Sainai, i baunanik elal. ");
INSERT INTO mpx_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Sauga Mosese i baaba haba, yaka kama i ahe maninina i kaus. ");
INSERT INTO mpx_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Yaa ebo ni tuk Petupatupa Limena elana, yaka kama ni ahe yoho ge alona Yehoba nihi baaba. Sauga ni tagil Yehoba wana baaba ni baunanik Isileli elal, ");
INSERT INTO mpx_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","inoke maninina nihi kite i namanamal. Yaka ni kaus al ana siga ni sikal alona Yehoba nihi baaba. ");
INSERT INTO mpx_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosese boda Isileli gegewel i pamigogoil ge i baek elal i ba, “Logugui bolo Yehoba i ba nuku toulil i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Wami tuwalali nuku ginol lan sikis gamwanaa, yaa lan seben-ina elana lan veyaho i bwabwalena nau Yehoba elau. Lan o henala ebo tuwalali etega ni ginol nihi lopaaliga. ");
INSERT INTO mpx_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bahi ginaha nuku toton wami abaholaviya lan Sabwataa. ");
INSERT INTO mpx_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mosese i baek boda Isileli gegewel elal i ba, “Yehoba wana baaba i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Henala atena i talam, inoke bugul bolo i gan elana ni ahe ni pwatanim ge ni muloluan Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Isileli gegewel Mosese hi eguluwan hi na wali epanapana elal. ");
INSERT INTO mpx_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Inoke bolo ateliya i talam ge hi yaliyaya, wali mulolu hi pwatanim Yehoba elana Petupatupa Limena ana taltal kaiwena, i ola al ana etuwalali gegewena ge topowon ali kaliko kaiwena. ");
INSERT INTO mpx_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bolo ateliya i talam, bolau ge yowau, tuwan ana isela gold ona, ololana komwakomwa, niman aana ge bobot, hi pwatanim ge hi muloluan Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bolo hihiu ali kala bulu, pepol ge keketina o ebo hihiu kaliko waiwaisana kaiwena hi gan elal, bolo goti pupunona hi gan elal, bolo sipi kunisina hi kale i ket hi gan elal, ge bolo bwasumu kunisiliya waiwaisana hi gan elal, he hi ahel inoke hi pwatanim. ");
INSERT INTO mpx_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bolo hi yaliyaya silba ge kopa nihi pwatanim, hi ginol ola ge hi muloluan Yehoba elana. Ge bolo ebwakil alana akesiya i gan elal, hi pwatanim totaltal nihi patuwalali. ");
INSERT INTO mpx_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Yowau bolo losalosa ana toatena sipi pupunona hi losa i tabwa hihiu ali kala bulu, pepol ge keketina, o ebo palakes hi losa i tabwa hihiu kaliko waiwaisana kaiwena, yaka hi pwatanim. ");
INSERT INTO mpx_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Yowau bolo hi yaliyaya ge goti pupunona ana losalosa hi atena, hi losa i tabwa hihiu. ");
INSERT INTO mpx_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Tohouwa pat waiwaisal ona, kaneliyan ge enuna al, hi pwatanim inoke totuwalali nihi teliya topowon bwabwatana ana kaliko ipod ana egimwan elal ge nihi am hikan babagal ana kama elana. ");
INSERT INTO mpx_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Bugul bwaleliya waiwaisal ona ge olibe enonona hi pwatanim, inoke totuwalali nihi patuwalali odam ali wewel, i ola al enonu toto epaepaenonu ge bugul bwalena waiwaisana toto hi toton nihi ginolil. ");
INSERT INTO mpx_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isileli bolau ge yowau bolo ateliya i talam, alona wali yaliyaya wali mulolu hi pwatanim Yehoba elana tuwalali kaiwena, toto Yehoba i baunanek Mosese elana nihi ginol. ");
INSERT INTO mpx_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Yaka Mosese i baek Isileli elal i ba, “Yehoba Besaleli, Uli natuna, Huli tubuna, ana un Yuda, iyaka i hile, ");
INSERT INTO mpx_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","inoke Yayaluwana eliyana i pakalaopopwi siba ge aatena i pek elana tuwalali tomaha tomaha kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Lokilkil ali un puna i atenal bubun ni ginola gold, silba ge kopa elal, ");
INSERT INTO mpx_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pat waiwaisal ali vagavagal i atena, ge ebwakil ana taltal ge ana kilkil i atena. He bugul tomaha tomaha ali tuwalali i atena. ");
INSERT INTO mpx_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Alona ge Oholiyab, Ahisamak natuna, ana un Dani, Yehoba siba i pek elal gamagalau enuna al tuwalali nihi paatenal. ");
INSERT INTO mpx_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Siba i pek elal tuwalali gegewena hi atena. Lokilkil ana un puna hi atena, ge palupalul hi atena yaka matan hi ginol hihiu ali kala bulu, pepol ge keketina ge hihiu kaliko waiwaisana kaiwena elal. He tuwalali tomaha ge tomaha hi atena bubun. ");
INSERT INTO mpx_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“He Yehoba siba ge aatena iyaka i pek Besaleli ge Oholiyab avaliyau totuwalali enuna al elal limi bwabwalena ana taltal gegewena hi atena. Inoke tuwalali o nihi ginol ni ola Yehoba wana baaba.” ");
INSERT INTO mpx_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Yaka Besaleli ge Oholiyab avaliyau totuwalali bolo Yehoba aatena i pek elal ge hi yaliyaya tuwalali kaiwena, Mosese i yogaagil hi nok elana. ");
INSERT INTO mpx_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Inoke mulolu gegewena bolo Isileli hi pwatanim limi bwabwalena ana taltal kaiwena, Mosese i bugul pek elal. Yaa Isileli heliya iyoho ya mweluluga maisena ge maisena hi nemnem wali mulolu hi teliteli. ");
INSERT INTO mpx_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Yaka bolo limi bwabwalena hi taltal tuwalali hi paveyaho ga, ");
INSERT INTO mpx_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ge hi na hi baek Mosese elana hi ba, “Mulolu bolo gamagal hi pwatanim i bwata lake te tuwalali toto Yehoba i ba elala ta ginol.” ");
INSERT INTO mpx_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Inoke Mosese i ba, “Bolau ge yowau bahi bugul etega al nihi lolovivina-an ge nihi mumulolu-an limi bwabwalena kaiwena.” Yaka wana baaba hi palelu abaholaviya. Inoke gamagal nige al bugul etega hi pwapwatanim, ");
INSERT INTO mpx_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","kaiwena toto iyaka hi pwatanim, tuwalali gegewena tage nihi ginol ana luvi i bwata lake. ");
INSERT INTO mpx_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Gold enona hot i ahe dedewaga ana heguna i ginoliya, gamagalau wali gegi ana abayakiyakil. Heguna o ana yapu 110 sentamita ge ana manamana 66 sentamita. ");
INSERT INTO mpx_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Gold i ahe bwasumu labui opeliya gaganina i bub ginolil, ");
INSERT INTO mpx_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","etegana i minaa buhuna etega, eluwana i minaa buhuna etega. Ginebi heguna i ginolil toyawe. ");
INSERT INTO mpx_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Opeliya hi anal inoke heguna hi pahabobu. Awoliya hi pempewa ge maniniliya i lau heguna elana. ");
INSERT INTO mpx_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hihiu ali kala bulu, pepol ge keketina hi ahe topowon ali kaliko hi palul yaka nihi galoi sauga nihi tuwalali limi bwabwalena gamwanaa. I ola al kaliko bwabwalel enuna hi ginolil Eloni kaiwena, i ola Yehoba wana baaba Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","He Isileli tuwalali gegewena iyaka hi pwamowasi haba, i ola Yehoba wana baaba Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Inoke Mosese wali tuwalali i hile ge i pwawa iyaka hi ginol i ola Yehoba wana baaba. Inoke Mosese i awanun Yehoba ni muloluagil. ");
INSERT INTO mpx_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mosese bugul gegewena i ginolil i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Inoke baliman eluwana ana waikena telipuna ana lan houwan elana Petupatupa Limena hi pamilil. ");
INSERT INTO mpx_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosese baba ona puliya ali abamisiyo i telel, yaka baba ona i pamililil ge epagapagasisi i pasolal. Yaka abwe kaliko bolo limi ana abatuk ge ana babatomwa ali kokola i pamilil. ");
INSERT INTO mpx_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Inoke kaliko labui i anal limi o pwatanaa, yaka epahabobu labui i anal pwatanaa al. He i ginol i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yaka Mosese pat mamanana sasapona labui i ahe i teli Bateli ana Dedewaga gamwanaa. Dedewaga ana kewa i pahola ge ana heguna, gegi ana abayakiyakil, i teli pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Inoke i nanatukana Limi gamwanaa, yaka kaliko mamanana i pakuki ge Bateli ana Dedewaga i kaus, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Teibol i nanatukan al Petutupa Limena gamwanaa, i teliya limi labena aluwabwa kaliko mamanana tolinaa. ");
INSERT INTO mpx_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Inoke pwalawa bwabwalena i teli pwatanaa Yehoba matanaa, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Yaka odam ginebi abaliya i nanatukan Petupatupa Limena gamwanaa, i teliya limi labena yavana, teibol i awoni. ");
INSERT INTO mpx_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Inoke odam i tonil Yehoba awonaa, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Abatonton gold hi ginoliya i nanatukan Petupatupa Limena gamwanaa ge i teliya kaliko awonaa. ");
INSERT INTO mpx_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Inoke bugul bwaleliya waiwaisana i ton pwatanaa, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Yaka kaliko i pakuki limi ana abauluulutuk elana, ");
INSERT INTO mpx_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","inoke abapowon i teliya awonaa. Yaka eliyana bwasumu ge pwalawa i powonagil pwabwaligel, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Yaka abaulul i teliya Petupatupa Limena ge abapowon ali nuwanuwana, ge wewel i hol. ");
INSERT INTO mpx_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Inoke Mosese ge Eloni alonau natunau hi papatuwalali nimaliya ge aeliya hi ulula. ");
INSERT INTO mpx_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Sauga ebo nihi ulutuka Petupatupa Limena elana o ebo nihi na abapowon elana, inoke nimaliya ge aeliya nihi ul ga, i ola Yehoba wana baaba. ");
INSERT INTO mpx_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Yaka Mosese Petupatupa Limena ge abapowon i gana pipinil, ge kaliko etega i pakuki ana abauluulutuk i kaus. Inoke Mosese tuwalali gegewena i pwamowasi. ");
INSERT INTO mpx_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Yaka yaluyalu Petupatupa Limena i yabom ge Yehoba mwananalina namanamalina i pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","He Mosese nige bosowaina ni ulutuka Petupatupa Limena gamwanaa, kaiwena yaluyalu i lau ge Yehoba mwananalina namanamalina i pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isileli wali minawanawa gegewena gamwanaa, sauga ebo yaluyalu ni ha ge ni noegon Petupatupa Limena pwatanaa, yaka Isileli nihi galaegon ge nihi toulil. ");
INSERT INTO mpx_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Yaa ebo nige ni haha, he nige nihi gagalaegon. ");
INSERT INTO mpx_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sauga gegewena wali minawanawa elana, lana yaluyalu toto Yehoba i miminaa nihi kite Petupatupa Limena pwatanaa, ge bulina nihi kite ginaha i tautau yaluyaluwa. ");
INSERT INTO mpx_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Yehoba wana totuwalali Mosese, ana tolabe Yosuwa Nan natuna. Mosese wana yaomal enaa, inoke Yehoba i baek Yosuwa elana i ba, ");
INSERT INTO mpx_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“No totuwalali Mosese iyaka i aliga. Inoke sauga ya, alomwau Isileli gegewel nuku lovivina wewel Yolidani nuku kalapanet-an ge nuku nok labi toto ya pepewa eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Hauna labi nuku nawaan, he iyaka ya talamwan eliyamiu, i ola no bateli Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Bilibili toto na pewa ni telipunaa ula kekevana elana ni tukik ni na ana siga Lebanoni oyana elal. Wami bilibili ni sikala wewel bwabwatana Yupeleitis elana. Hiti wali labi gegewena ni ahe ge ni lok ni na ana siga Hoga Mediteleiniya. ");
INSERT INTO mpx_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Nige gamagal etega ni papakokovewa yawalim miminana elana. Na labewa ni ola Mosese ya labe. Nige na eguluwagiwa, alou owa ya sauga gegewena. ");
INSERT INTO mpx_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“He nu gasisi ge atem ni matuwa, kaiwena owa gamagalau ya nu nulil ge nuku na nuku minaa panuwa toto ya bateli tubumiyau elal. ");
INSERT INTO mpx_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Iyai te nu gasisi ge atem ni matuwa. Nu matahikagiwa logugui gegewena toto no totuwalali Mosese i pewa nu henapuan. Nu toulil pasapu, bahi nu liliolak labem awomwa o ebo gegebamwa, inoke hauna labi nu noek ge hauna ebo nu ginol, nasi ni waisi. ");
INSERT INTO mpx_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Nu nuwahikan Logugui ana buki ya nu vasili hikahikani. Lana ge bulina nu minuwanuwatu-an, inoke nu matahikagiwa ge logugui gegewena toto hi leli lowan nu henapuagil. Inoke nu mibubun ge hauna gun ebo nu ginol nasi ni waisi hot. ");
INSERT INTO mpx_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Iyaka ya ba haba eliyam te nu gasisi ge atem ni matuwa. Bahi lovakun ge bahi ati bwanabwana, kaiwena hauna labi nu noek, nau Yehoba wam Yabowaine alom ya.” ");
INSERT INTO mpx_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Yosuwa i baek un maisena ge maisena wali tohouwa elal i ba, ");
INSERT INTO mpx_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Ku nopain abaholaviya ge nuku baek gamagalau elal nuku ba, ‘Wami bugubugul ge amiu nuku lovivina-an, kaiwena lan eton ya i mina abwe ta egon, Wewel Yolidani ta kalapanet-an ge ta nok labi toto Yehoba wala Yabowaine i pepem wala panuwa.’” ");
INSERT INTO mpx_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Yaka i baek al un Lubeni, Gada ge un Manasa awalehina elal i ba, ");
INSERT INTO mpx_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Ku nuwahikan Yehoba wana totuwalali Mosese wana baaba eliyamiu i ba, ‘Yehoba wami Yabowaine iyaka i paveyaho-agimiu, ge bilibili toto ya Wewel Yolidani labi leunati i pewa eliyamiu wami panuwa.’ ");
INSERT INTO mpx_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Natumiyau ge wami bwasumu nihi miminaa te wami panuwaa e, yaa komiu tolohaveyan gegewemiu wami elohaveyan nuku bugulan, inoke nuku houwa-agima ge wewel Yolidani ta kalapanet-an. Ama talimiyau nuku labema ga ");
INSERT INTO mpx_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ana siga Yehoba wala Yabowaine ni paveyaho-agima ni ola iyaka i ginol eliyamiu, ge bilibili toto Yehoba i pepem naha ahe ge naha minaan. Enaa abwe nuku sikalim wami panuwa ya elana, toto Yehoba wana totuwalali Mosese i pewa eliyamiu Wewel Yolidani labena leunati.” ");
INSERT INTO mpx_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Inoke Yosuwa anana hi lahe hi ba, “Bugul gegewena naha ginol ni ola hauna toto iyaka u baunan eliyama. Ge ebo hauna labi elana nu patunama, nasi naha nok. ");
INSERT INTO mpx_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Wam baaba naha henapuan ni ola valila Mosese wana baaba ha henapuan. He ha awanun ya te Yehoba wala Yabowaine ni minaa eliyam, ni ola valila i minaa Mosese elana. ");
INSERT INTO mpx_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Henala ebo ni awatautau-agiwa ge nige wam baaba ni hehenapu-an, he ni aliga. Iyai te nu gasisi ge atem ni matuwa.” ");
INSERT INTO mpx_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Panuwa Sitim elana Yosuwa, Nan natuna, tokenan eluwa i patuna sumel i ba, “Ku na panuwa Kenani ku anugayawa-an, Yeliko al ge.” Yaka hi nok hi ginol ola. Sauga hi na hi tuk Yeliko, inoke bulin o hi na hi minaa yova toganawal mani kaiwena alana Leyabi wana limiya. ");
INSERT INTO mpx_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Gamagalau enuna Yeliko ana kin wana wasa hi pek hi ba, “Bulin ebe Isileli enuna hi nem hi tuk ge panuwa hi anugayawa-an.” ");
INSERT INTO mpx_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Inoke kin baaba i patuna Leyabi elana i ba, “Gamagalau bolo hi nem hi ulutuk wam limiya u ahel nihi tagil, kaiwena hi nem panuwa gamwana gegewena hi anugayawa-an.” ");
INSERT INTO mpx_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Mulaa abwe elopapatuna hi vin, he Leyabi tokenan eluwa iyaka i ahel i na limi pwatanaa ge i pabun sumel mwawin palakes nuwaliya gabulanaa, bolo i payane wana limi pwatanaa. Inoke i baek kin wana elopapatuna elal i ba, “Gamagalau hi nem no limiya, yaa nige ya aatena te ga hi noem. Sabwelu lobelobekina elana kelaubwa panuwa ana nog nihi kaus te hi egon. Nige ya aatena ga hi noek, yaa ebo etimwawa nuku tatauliulil eliyaa, nasi nuku kukuhikagil.” ");
INSERT INTO mpx_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Inoke kin wana elopapatuna hi tagil ge tokenan hi loyaagil kamwasaa, hi na ali siga wewel Yolidani ana abakalakalapaneta. Sauga elopapatuna hi tagil, inoke panuwa ana nog hi kaus. ");
INSERT INTO mpx_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Mulaa abwe tokenan hi kenu, Leyabi i na i ha limi pwatanaa ");
INSERT INTO mpx_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ge i baek elal i ba, “Ya atena Yehoba labena ya iyaka i pewa eliyamiu, ge gamagalau gegewema labi ya elana ha lovakun nabi kaiwemiu ge wama gasisi gegewena i mowasi. ");
INSERT INTO mpx_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Wasamiu ha hago sauga ku tagilem Itipita Yehoba Hoga Keketina i pakekepa awomiwa ge ku kalapanet-an. Ha hago al Amoli wali kin labui bolo Yolidani labi leunati, Sihon ge Ogi, avaliyau ge wali gamagalau ku lolil ge ku pwamowasel hoti. ");
INSERT INTO mpx_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Sauga wasamiu ha hago, ha lovakun nabi ge wama gasisi gegewena i mowasi, kaiwena ha atena Yehoba wami Yabowaine iya labulabum natiya ge panayawi ali Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","He nuku papasila Yehoba alanaa te tutuwau nuku muloluagil ni ola nau ya muloluagimiu. Etotohi etega ku baunanim, ");
INSERT INTO mpx_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","inoke na atena tunahot age alowau nam ge nain, nuwau ge taliwau, avaliyau ge natuliyau nige nuku aapapanak-agima, yaa nuku pwamwalima yaomal elana.” ");
INSERT INTO mpx_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Inoke tokenan Leyabi anana hi lahe hi ba, “Ebo yawalimiu ni nak, lahena Yehoba yawalima ni apanak al. Ebo nige nu wawasa-agima, inoke sauga Yehoba labi ya ni pem elama, naha muloluagimiu ge naha pwamwalimiu.” ");
INSERT INTO mpx_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Yeliko ana gana pat elana hi ginoliya, he Leyabi wana limi iyoho i minaa gana o tuwanaa. Inoke hihiu etega i ahe ge tokenan eluwa i pakuki lowagil wana windowa. ");
INSERT INTO mpx_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","He mulaa abwe i pakuki lowagil, i baek ga elal i ba, “Ku nok ku na oyaa, inoke bahi kin wana toloya nihi pwapwawamiu. Nuku bunsumiewa ga to lan eton, ana siga ami toloya nihi sikal, inoke abwe nuku nok wami kamwasaa.” ");
INSERT INTO mpx_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Inoke bolau hi baek Leyabi elana hi ba, “He bateli toto u ba ha papasila-an nige wana gasisi ni gagan eliyama ebo nige nu giginol ni ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Sauga naha tuk wami labiya, hihiu toto keketina ei nu gimwana windo toto nu pakuki lowagima elana. I ola al, tamwam ge hinam, numwau ge tutumwau gegewel, nu ahel alomwau nuku minaa wam limiya. ");
INSERT INTO mpx_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ebo etega ni tagilem wam limiya ni nawanawa kamwasaa ge naha lol, he wana nak lahena totona ni pwawa, ana woliwoli nige ni nenem elama. Yaa ebo bolo alomwau nuku mina etega naha lol, lahena ama naha pwawa. ");
INSERT INTO mpx_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Ge ebo nu wasaagima, he bateli toto u ba ha papasila-an nige wana gasisi ni gagan ge nige naha papaolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Yaka analiya Leyabi i lahe i ba, “Ee, ni ola wami baaba.” Yaka abwe i patunal hi egon, inoke hihiu keketina i ahe ge i gimwan windowa. ");
INSERT INTO mpx_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Tokenan hi na hi ha oyaa ge hi minek ga to lan eton. Toloya tokenan hi loyaagil kamwasaa, yaa nige hi pwapwawal, inoke hi sikal Yeliko. ");
INSERT INTO mpx_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Yaka abwe tokenan eluwa hi loem oyaa, wewel Yolidani hi kalapanet-an ge hi sikal Yosuwa elana. Inoke bugul gegewena toto i gan elal hi wasaan elana. ");
INSERT INTO mpx_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Yaka hi ba, “Ha atena tunahot Yehoba labi Kenani bwabwaligena iyaka i teli nimalaa. He gamagal gegewel hi lovakun nabi kaiwela ge wali gasisi i mowasi.” ");
INSERT INTO mpx_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Lan i gan mweluluga kekeisi, Yosuwa alonau ge Isileli gegewel hi lut Sitim hi eguluwan, inoke hi na Wewel Yolidani elana. Yaka hi holaviya ga to, mulaa abwe nihi kalapanet. ");
INSERT INTO mpx_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Lan etonina elana, inoke tohouwa hi nopain abaholaviya, ");
INSERT INTO mpx_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ge hi baek gamagalau elal hi ba, “Sauga topowon un Libai nuku kitel Yehoba wala Yabowaine wana Bateli ana Dedewaga nihi kalivai, yaka abaholavi nuku eguluwan ge nuku toulilil. ");
INSERT INTO mpx_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Inoke kamwasa nihi pankitemiu, kaiwena nige sauga etega ku nonoem labi ya elana. Bahi nuku nonok Bateli ana Dedewaga labenaa, ami bwaga ni gan ana yapu ni ola kilomita maisena.” ");
INSERT INTO mpx_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Yaka Yosuwa i baek gamagalau elal i ba, “Ku pwabwabwalena-agimiu, kaiwena bwaligumwa Yehoba ginol yawiyawi enuna ni ginolil gamwalaa.” ");
INSERT INTO mpx_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Lan i gan mwelulugaa inoke Yosuwa i baek topowon elal i ba, “Bateli ana Dedewaga ku kalivai ge nuku nohouwa gamagalau awoliyaa.” Inoke hi ginol ola Yosuwa wana baaba. ");
INSERT INTO mpx_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Yehoba i baek Yosuwa elana i ba, “Lan ebe na telipuna alam na teli heyan boda Isileli mataliyaa. Inoke nihi atena nau alou owa, i ola valila alou Mosese. ");
INSERT INTO mpx_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Nu baek topowon bolo Bateli ana Dedewaga ana tokaval elal nu ba, ‘Sauga nuku pulivin Wewel Yolidani bebenaa, yaka nuku gailau ge nuku talmilil wewel gamwanaa.’” ");
INSERT INTO mpx_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Inoke Yosuwa i baek boda Isileli elal i ba, “Ku noanim ga, inoke Yehoba wala Yabowaine wana baaba na wasaan nuku hago. ");
INSERT INTO mpx_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Lan ya bugul etega ni gan, inoke nuku atena age Yabowaine yawalina gaganina iyahe avala ge abwe Kenani, Hiti, Hivi, Pelisi, Gegasi, Amoli ge Yebusi towohiliyau ni takel yohil kaiwemiu. ");
INSERT INTO mpx_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","He panayawi mamanana ana Babala wana Bateli ana Dedewaga nasi ni houwa-agimiu ni na ni lau Wewel Yolidani elana. ");
INSERT INTO mpx_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","13","Inoke sauga topowon bolo Dedewaga hi kalivai aeliya nihi teli Yolidani elana, yaka wewel toto i sani loem natiya nasi ni kekepa ge ni tub papahe abana maisena. (He i ola al bolau ali gewi elulutega eluwa nuku hilel un maisena ge maisena gamwaliyaa.)” ");
INSERT INTO mpx_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Witi tomwatomwa ana sauga inoke banata i sani Wewel Yolidani elana. Sauga Isileli wali abaholavi hi eguluwai hi na Yolidani nihi kalapanet-an, inoke topowon Dedewaga hi kalivai ge hi houwa gamagalau awoliyaa. Sauga toto topowon aeliya hi teli wewel gamwanaa, ");
INSERT INTO mpx_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","yaka wewel toto i sani loem natiya i kekepa. Wewel i tub papahe labi etega ana bwaga i yapu elal, panuwa alana Adama, Saletan labenaa. Wewel toto i sani lok i na Hoga Alialigana elana i kekepa hot, inoke gamagalau bosowailiya nihi kalapanet Yeliko gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Topowon bolo Yehoba wana Bateli ana Dedewaga hi kalivai hi talmilil bubun bilibili kekevana elana Yolidani ana luwaluwala, yaka Isileli hi noknok ana siga gegewel hi kalapanet haba. ");
INSERT INTO mpx_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Sauga Isileli gegewel wewel Yolidani hi kalapanet-an haba, he Yehoba iyaka i ba haba Yosuwa elana i ba, ");
INSERT INTO mpx_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Bolau elulutega eluwa nuku hilel Isileli ali un maisena ge maisena gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Yaka nuku baek elal pat elulutega eluwa nihi aheliya Yolidani ana luwaluwala, toto topowon hi taltalmilila, ge nihi kalivail nihi na nihi teleliya panuwa toto nasi bulina nuku holaviya.” ");
INSERT INTO mpx_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Inoke Yosuwa bolau elulutega eluwa bolo iyaka i hilel haba un maisena ge maisena gamwaliyaa, i yoga gogonil ");
INSERT INTO mpx_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ge i baek elal i ba, “Ku na ku lau Yolidani ana luwaluwala Yehoba wala Yabowaine wana Bateli ana Dedewaga awonaa, yaka tomaha pat maisena ona nuku ahe nuku kalivail vevelamiwa, un maisena maisena nihi bwasowan. ");
INSERT INTO mpx_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Pat bolo o ni panuwahikagila hauna Yehoba i ginol elala. Bwaliga ebo natumiyau nihi nelimiu nihi ba, ‘Pat bolo ya ali sapu ga i ola?’ ");
INSERT INTO mpx_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","yaka nuku ba, ‘Valila wewel Yolidani i kekepa sauga Yehoba wana Bateli ana Dedewaga hi kalivai panetan.’ Pat bolo o boda Isileli heyan ge heyan ni panuwahikagil.” ");
INSERT INTO mpx_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Inoke bolau o hi ginol ola Yosuwa wana baaba. Hi na pat elulutega eluwa hi ahel wewel Yolidani ana luwaluwala, ali gewi i ola un Isileli ali gewi, i ola Yehoba wana baaba Yosuwa elana. Inoke hi kalivail ge hi na hi teli wali abaholaviya. ");
INSERT INTO mpx_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Yaka pat elulutega eluwa, bolo iyaka hi aheliya Yolidani ana luwaluwala labi toto topowon hi taltalmilila, pat o Yosuwa abwe i pahe. He pat bolo o heliya iyoho to ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","He gamagalau etimwawa hi kalapanet haba, yaa topowon bolo Dedewaga hi kalivai hi talmilila Yolidani ana luwaluwala ana siga Yehoba wana baaba gegewena Yosuwa elana Isileli hi ginol haba, i ola ana logugui Mosese i baunan Yosuwa elana. ");
INSERT INTO mpx_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Inoke abwe gamagalau mataliyaa, Dedewaga ge topowon bolo ana tokaval hi kalapanet al. ");
INSERT INTO mpx_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Bolau bolo un Lubeni, Gada ge un Manasa awalehina hi lovivina lohaveyan kaiwena ge hi kalapanet gamagalau gegewel awoliyaa, i ola Mosese wana baaba elal. ");
INSERT INTO mpx_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","He ali gewi poti tausan (40,000) te avaliya Yehoba hi kalapanet hi na Yeliko abwabwina elana lohaveyan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Lan o elana Yehoba Yosuwa alana i teli heyan Isileli gegewel mataliyaa, inoke hi awatauwan yawalina ana sauga miminana, i ola valila Mosese hi awatauwan. ");
INSERT INTO mpx_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","He liwanina i ola to. Yehoba i baek Yosuwa elana i ba, ");
INSERT INTO mpx_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“U baek topowon bolo Bateli ana Dedewaga hi kalivai elal nihi hem Yolidani nihi eguluwai.” ");
INSERT INTO mpx_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Inoke Yosuwa i baek topowon elal i ba, “Ku hem wewel Yolidani ku eguluwan.” ");
INSERT INTO mpx_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Yaka topowon bolo Yehoba wana Bateli ana Dedewaga hi kalivai, hi ha Yolidani hi eguluwan. Sauga hi piliha datuwa, inoke wewel i tub sikal ge banata i sani al. ");
INSERT INTO mpx_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","He baliman ana weikena houwan ana lan elulutega elana te gamagalau Yolidani hi kalapanet-an. Yaka hi na hi holaviya panuwa Gilgal, Yeliko labi leunati. ");
INSERT INTO mpx_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Pat elulutega eluwa bolo hi aheliya wewel Yolidani gamwanaa Yosuwa i pahe panuwa o elana. ");
INSERT INTO mpx_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Inoke i baek boda Isileli elal i ba, “Bwaliga ebo tubutubumiyau nihi nelimiu nihi ba, ‘Pat bolo ya ali sapu ga i ola?’ ");
INSERT INTO mpx_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","yaka nuku baek elal nuku ba, ‘Yolidani wewelina i kekepa, inoke bilibili kekevana elana Isileli hi kalapanet.’ ");
INSERT INTO mpx_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Nuku ba ola o, kaiwena Yehoba wala Yabowaine Yolidani wewelina i pakekepa kaiwemiu ana siga ku kalapanet-an, i ola valila Hoga Keketina i pakekepa kaiwema, ana siga ha kalapanet-an. ");
INSERT INTO mpx_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","I ginol ola o inoke gamagalau gegewel panayawiya nihi atena Yehoba iya Togasisi, ge komiu Yehoba wami Yabowaine nuku awatauwan sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Amoli wali kin bolo Yolidani labena leu pai ge Kenani wali kin bolo Hoga Mediteleiniya bebenaa, gegewel wasa hi hago Yehoba Yolidani wewelina i pakekepa ana siga boda Isileli gegewel hi kalapanet haba. Inoke hi lovakun nabi ge nige wali gasisi i gagan tage avaliyau Isileli nihi lohaveyan. ");
INSERT INTO mpx_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Sauga o elana Yehoba i baek Yosuwa elana i ba, “Nibuka enuna nuku bub ge Isileli melubolau tuwaliya buhuna kunisina nuku gotomwa yoho.” ");
INSERT INTO mpx_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Yaka Yosuwa nibuka i bub ge i ba Isileli melubolau gegewel tuwaliya buhuna kunisina hi gotomwa yoho. Inoke panuwa o alana hi tun Gibeyat Halalot. ");
INSERT INTO mpx_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Yosuwa i ginol ola o, puna i ola hiwe. He Isileli melubolau gegewel bolo hi tagilem Itipita, tuwaliya buhuna kunisina iyaka hi gotomwa yoho. Yaa sauga hi nawanawa ula kekevana elana, wawayau bolo hi abil nige etega tuwana buhuna kunisina hi gogotomwa. Isileli hi nononawanawa ula kekevana elana baliman poti, inoke gamwanaa bolau bolo sauga hi tagilem Itipita wali baliman bosowailiya lohaveyan, gegewel iyaka hi aliga haba, kaiwena Yehoba wana logugui nige hi hehenapuan. Yaka ali lahi hi pwawa i ola Yehoba wana baaba elal, heliya panuwa malumalulina toto Yehoba i bateli tubuliyau elal nige hi kikite. ");
INSERT INTO mpx_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ha vavalul tamaliyau hi milahel, inoke heliya te Yosuwa i ba ge tuwaliya buhuna kunisina hi gotomwa yoho, kaiwena nige hi giginol uleya. ");
INSERT INTO mpx_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Sauga bolau gegewel gotomwa yoho paganina hi ahe haba, yaka hi minaa ga wali abaholaviya ana siga ali kakaini i mwau. ");
INSERT INTO mpx_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Inoke Yehoba i baek Yosuwa elana i ba, “Lan ebe wami miloloyowan Itipita elana puluwawena iyaka ya ahek yoho.” Yaka panuwa o alana hi tun Gilgal. Alan o i mihot ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Sauga Isileli heliya iyoho wali abaholaviya Gilgal, Yeliko abwabwina elana, inoke Nopalegi ana nuwahikan hagalena hi ginol waikena ana lan potin-ina kokoyavena elana. ");
INSERT INTO mpx_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Nopalegi Hagalena i mowasi, hi kenu lan i gan, yaka lan o elana hi telipuna Kenani enowana hi anan. Bali enona enuna hi ekeke, enuna hi wowol yaka beleid toto nige alona yis hi vivikuhiya hi umun. Inoke lan o ge i nok Kenani enowana hi mimi anani. ");
INSERT INTO mpx_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Lan toto Isileli hi telipuna Kenani enowana hi anan, yaka aanan toto manna i lomowasi ge nige etega al hi pwapwawa. Kaiwena baliman o ge i nok, Kenani enowana hi mimi anani. ");
INSERT INTO mpx_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Lan etega Yosuwa iyoho Yeliko gegelinaa, inoke matana i lihin tau etega i kite i taltalmilil awonaa, wana elohaveyan kilepana iyaka i momol tagilan abanaa ge i pihikan. Yaka Yosuwa i na elana ge i neli i ba, “Owa ama tolabe etega o ebo ama topihigelgel?” ");
INSERT INTO mpx_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Tau o i ba, “Nigeya, ya nem te kaiwena nau Yehoba wana tolohaveyan wali tohouwa.” Inoke Yosuwa alona wana awatauwan i talpo maninina i pahanalowanek bilibiliya ge i ba, “Tonowak, hauna nuwam nu baunan nau wam totuwalali elau?” ");
INSERT INTO mpx_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Yaka Yehoba wana tolohaveyan wali tohouwa i baek Yosuwa elana i ba, “Aem ana os u leke, kaiwena bilibili toto u talmilila i bwabwalena.” Inoke Yosuwa i ginol ola to. ");
INSERT INTO mpx_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","(He panuwa Yeliko hi gane painan, inoke Isileli kaiweliya ana abauluulutuk hi lokausan ge hi matahikan bubun, hi lopwali bahi gamagal etega ni tutuk o ebo ni tatagil.) ");
INSERT INTO mpx_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Inoke Yehoba i baek Yosuwa elana i ba, “U kite, Yeliko iyaka ya teli nimwamwa, ginebi ana kin ge ana tolohaveyan gegewel. ");
INSERT INTO mpx_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Lan maisena maisena alomwau ge wam tolohaveyan gegewel panuwa nuku nopainan pamaisena. Nuku ginol ola to lan ali gewi sikis. ");
INSERT INTO mpx_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Topowon ali gewi seben bwagigi bolo sipi ali hon nihi noahel, nihi nohouwa Bateli ana Dedewaga awonaa ge nihi yuyu. Lan seben-ina elana, panuwa nuku nopainan paseben, ge topowon bwagigi nihi noyuyu. ");
INSERT INTO mpx_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Sauga ebo nu hago bwagigi nihi yu hikan, inoke nu ba gamagalau gegewel nihi yala analiya ni bwata. Yaka gana ni maguli ge gamagalau nihi nopasapu nihi na nihi tuk.” ");
INSERT INTO mpx_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Inoke Yosuwa Nan natuna topowon i yoga gogonil ge i baek elal i ba, “Yehoba wana Bateli ana Dedewaga ku ahe ge ku kalivai. Inoke alomiyau ali gewi seben bwagigi nihi noahel nihi nohouwa Bateli ana Dedewaga awonaa ge nihi yuyu.” ");
INSERT INTO mpx_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Inoke i baek gamagalau elal i ba, “Ta nok, ta na panuwa ta nopainan! He tolohaveyan enuna nihi nohouwa hot Yehoba wana Dedewaga awonaa.” ");
INSERT INTO mpx_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Sauga Yosuwa i baaba haba gamagalau elal, yaka topowon ali gewi seben hi nohouwa Yehoba wana Bateli ana Dedewaga awonaa ge bwagigi hi noyuyu. ");
INSERT INTO mpx_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Tolohaveyan enuna hi nohouwa bwagigi ali toyuyu awoliyaa, ge enuna al hi nomula Dedewaga enaa. He bwagigi iyoho hi kahikahin. ");
INSERT INTO mpx_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Yaa Yosuwa iyaka i ba haba gamagalau elal i ba, “Bahi yala, bahi anamiu ni bwabwata, ge bahi baaba etega nuku babaunan. Lan toto na ba, ‘Ku yala,’ he abwe nuku yala.” ");
INSERT INTO mpx_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Yaka Yehoba wana Bateli ana Dedewaga hi kalivai panuwa hi nopainan pamaisena, i ola Yosuwa wana baaba. Inoke hi sikal wali abaholaviya ge hi kenu. ");
INSERT INTO mpx_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Lan i gan mweluluga kekeisi, Yosuwa i lut inoke i ba topowon Yehoba wana Bateli ana Dedewaga hi kalivai al. ");
INSERT INTO mpx_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Yaka topowon seben bolo bwagigi ali toyuyu hi nohouwa al Dedewaga awonaa bwagigi hi noyuyu. I ola al tolohaveyan enuna hi nohouwa Dedewaga awonaa ge enuna hi nomula Dedewaga enaa. He bwagigi iyoho hi kahikahin. ");
INSERT INTO mpx_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Inoke lan eluwana elana panuwa hi nopainan pamaisena al, yaka abwe hi sikal wali abaholaviya. Hi ginol ola to lan ali gewi sikis. ");
INSERT INTO mpx_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Lan seben-ina elana panuwa abwe i mwamwananal, inoke Isileli hi lut hi na Yeliko hi nopainan, i ola toto hi giginol lan sikis gamwanaa. Yaa lan toto o abwe panuwa hi nopainan paseben. ");
INSERT INTO mpx_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Wali nopain pasebenina elana topowon bwagigi hi yu hikan, yaka Yosuwa i baek gamagalau elal i ba, “Ku yala! Kaiwena Yehoba panuwa iyaka i pem elala! ");
INSERT INTO mpx_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Yeliko ana tomina ge bugubugulina gegewena Yehoba i ba pwatanek iya elana ta apapanak-agil. Yaa Leyabi yova toganawal mani kaiwena alonau ge wana limi ana tomina gegewel bahi etega nuku aapapanak-agil, kaiwena wala tokenan i label ge i pabun sumel. ");
INSERT INTO mpx_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","He nuku matahikagimiu bugul bolo Yehoba i ba pwatanek iya elana, bahi nuku aahel, eba totomiu ami nak nuku ginol. Ebo etega nuku ahe, he nasi apapanak Yehoba ni ba pwatanem Isileli gegewela elala. ");
INSERT INTO mpx_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Silba ge gold gegewena ginebi bugul bolo hi ginola kopa ge aiyan elal, ta pwabwabwalena-agil Yehoba kaiwena, ge ta pwahinil gogomwau ana abateliya Yehoba wana limi gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Sauga gamagalau hi hago topowon bwagigi hi yu hikan, yaka hi yala. Inoke Yeliko ana gana i maguli ge tolohaveyan gegewel hi nopasapu hi na hi tuk Yeliko gamwanaa ge hi ahe. ");
INSERT INTO mpx_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Yaka panuwa hi apapanak-an hoti i ola Yehoba wana baaba. Wali elohaveyan kilepana elana bolau, yowau, wawayau ge toliki ginebi ge wali bulumwakau, sipi ge donki hi lolil habal. ");
INSERT INTO mpx_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Yaka Yosuwa i baek tokenan eluwa bolo valila Yeliko hi anugayawa-an elal i ba, “Ku na ku tuk Leyabi wana limiya, inoke alonau tutunau gegewel ku enil nihi nem, ni ola wami bateli elana.” ");
INSERT INTO mpx_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Inoke hevalau toanugayawa hi na hi tuk, yaka Leyabi alonau tamana, hinana, nunau ge tutunau gegewel hi en tagilagil. Inoke hi na hi telel Isileli wali abaholavi tolinaa. ");
INSERT INTO mpx_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Inoke Isileli wali tolohaveyan Yeliko bwabwaligena ge bugubugulina gegewena hi ton olan. Yaa silba ge gold gegewena ginebi bugul bolo hi ginola kopa ge aiyan elal, hi bugulagil ge hi na hi pwahinil gogomwau ana abateliya Yehoba wana limiya. ");
INSERT INTO mpx_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Inoke Yosuwa Leyabi ge tutunau gegewel yawaliliya i pwamwal, kaiwena bolau bolo valila i patunal hi na Yeliko hi anugayawa-an, Leyabi i label ge i pabun sumel. He tubutubunau heliya iyoho hi minaa boda Isileli gamwaliyaa ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Sauga toto o, Yosuwa bateli gasigasisena i baunan i palopisai i ba, “Tau toto ebo ni lut ge panuwa Yeliko e ni tal pasikal, Yehoba tau o ni nuwamut-an nak ni pwawa. Sauga ebo panuwa ana wauwau ni sepa, he natuna gamaun ni aliga. Ge sauga ebo panuwa ana gana ana nog ni pamilil, he natuna melumelu ni aliga.” ");
INSERT INTO mpx_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Yehoba i minek Yosuwa elana, inoke wasana i lelu Kenani ana labi bwalibwaligena elana. ");
INSERT INTO mpx_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Valila Yeliko ge bugubugulina gegewena Yehoba i ba pwatanek iya elana i ba Isileli nihi apapanak-agil, yaa wana logugui o hi leke. He tau etega alana Eikan, iya Kami natuna, Simli tubuna, Selaa tubutubunina, ana un Yuda, Yeliko bugubugulina enuna i ahel. Inoke Yehoba i huga nabi Isileli elal. ");
INSERT INTO mpx_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Yosuwa bolau enuna i patunaliem Yeliko nihi na panuwa Ai, Betel labi nati, Bet-Aben labenaa. I baek elal i ba, “Nuku na nuku ha labi o nuku anugayawa-an.” Inoke bolau hi ginol ola Yosuwa wana baaba. ");
INSERT INTO mpx_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Sauga hi sikal Yosuwa elana inoke wana wasa hi pek hi ba, “Bahi tolohaveyan gegewel nu papatunal nihi nana nihi lolohaveyan panuwa Ai elal. Heliya nige hi gegewi to, inoke besena te tausan eluwa o ebo eton (2,000 o ebo 3,000) nu patunal, yaka panuwa nihi ahe. Bahi nu babaa tolohaveyan gegewel nihi nonok ge tuwaliya nihi nonopaaliga bwabwage.” ");
INSERT INTO mpx_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Inoke Yosuwa tolohaveyan ali gewi i ola tausan eton (3,000) i patunal hi na hi ha hi haveyan, yaa Ai wali tolohaveyan Isileli hi pakokovel. ");
INSERT INTO mpx_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Yaka hi takeliya panuwa ana abauluulutuk elana hi loek labilabiya hi na ali siga labi toto pat hi ahiahiya, oya punaa. Inoke sauga Isileli hi laulau labilabiya, ali gewi teti sikis (36), Ai hi lolil. Inoke boda Isileli hi lovakun nabi nige wali gasisi i gagan. ");
INSERT INTO mpx_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Inoke Yosuwa alonau ge Isileli wali tohouwa nuwanak kaiwena ali kaliko hi kukuleli, papakova hi yoho heyan kokowaliyaa, ge hi talpo bilibili pwatanaa Yehoba wana Bateli ana Dedewaga awonaa ana siga kokoyavi. ");
INSERT INTO mpx_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Inoke Yosuwa i baek Yehoba elana i ba, “Babala Yehoba, hauna kaiwena u ahema wewel Yolidani ha kalapanet-an? Age nu telema boda Amoli nimaliyaa ge nihi apapanak-agima? Binimala valila naha minek ya to wewel Yolidani labena etega. ");
INSERT INTO mpx_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","O Babala, nige ya aatena hauna gun na baunan eliyam. Ama topihigelgel wama tolohaveyan hi pakokovel ge hi lou sikal. ");
INSERT INTO mpx_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Sauga Kenani ge labi ya towohiliyau gegewel al wasa nihi hago, yaka nihi nem nihi haveyan elama ge nihi pwamowasema. Yaka abwe hauna nu ginol ge bahi alam bwabwatana nihi babaa lowan?” ");
INSERT INTO mpx_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Yaa Yehoba i baek Yosuwa elana i ba, “U lut! Hauna kaiwena u talpo bilibiliya ge u kenukenu? ");
INSERT INTO mpx_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Isileli ku gegi, no bateli eliyamiu ana logugui iyaka ku leke. Valila Yeliko bugubugulina ya ba pwatanem elau ya ba nuku apapanak-agil, yaa bugul enuna ku ahe totomiu kaiwemiu. Ku kaoma, ku alahagil, yaka ginebi ge wami bugubugul ku pwahin pamaisena. ");
INSERT INTO mpx_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Inoke apapanak iyaka ya ba pwatanewa Isileli eliyamiu. Heiya te kaiwena ge nige bosowaimiu nuku talmilil gagasisi ami topihigelgel awoliyaa, yaa ku lou sikal. He bugubugul bolo ya ba pwatanem elau ya ba nuku apapanak-agil, ebo nige nuku aahek yoho gamwamiwa ge nuku aapapanak-agil, he nige al na miminaa eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“Nu na gamagalau nu lovivina-agil nihi talmilil maniniwa. Nu baek elal nu ba, ‘Nuku abubunimiu nuku yanayana bwaligumwa kaiwena. Kaiwena Yehoba Isileli wala Yabowaine, i ba: O Isileli! Bugul bolo ya ba pwatanem elau ya ba nuku apapanak-agil, he enuna iyoho gamwamiwa. Nige bosowaimiu nuku talmilil gagasisi ami topihigelgel awoliyaa ana siga bugul bolo o nuku ahek yohil. ");
INSERT INTO mpx_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“‘Bwaligumwa mweluluga un ge un nuku nem nuku talmilil maniniwa. Yaka un toto na hile, pwahiya ge pwahiya nihi notagil. Yaka pwahiya toto na hile, tini ge tini nihi notagil. Yaka tini toto na hile, tau ge tau nihi notagil. ");
INSERT INTO mpx_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Henala ebo na pwawa, he bugubugul bolo ya ba nuku apapanak-agil iyoho elana. Alonau natunau nuku lolil, yaka tuwaliya ginebi ge wana gogomwau gegewel nuku ton ginahaa. Nuku ginol ola, kaiwena nau Yehoba no bateli eliyamiu ana logugui i leke ge Isileli i papapuluwawi-agimiu.’” ");
INSERT INTO mpx_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Lan i gan mweluluga kekeisi Yosuwa i ba Isileli un ge un hi notagil, inoke Yehoba un Yuda i hile. ");
INSERT INTO mpx_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Yaka i ba un Yuda pwahiya ge pwahiya hi notagil, inoke Yehoba pwahiya Selaa i hile. Yaka i ba pwahiya Selaa tini ge tini hi notagil, inoke Yehoba tini Simli i hile. ");
INSERT INTO mpx_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Yaka Yosuwa i ba tini o tau ge tau hi notagil, inoke Eikan, Kami natuna, Simli tubuna, Selaa tubutubunina, ana un Yuda Yehoba i pwawa. ");
INSERT INTO mpx_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Yaka Yosuwa i baek Eikan elana i ba, “Natu, nu baaba tunahot, wam gegi nu ba tagilan, inoke Yehoba, iya Isileli wala Yabowaine, alana ni wasawasa ge gamagalau nihi tobalan. No wasa nu pem hauna u ginol, bahi nu aalahan eliyau.” ");
INSERT INTO mpx_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Anana i lahe i ba, “I tunahot! Iyaka ya gegi Yehoba Isileli wala Yabowaine matanaa. He ya ginol ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Yeliko bugubugulina gamwaliyaa, Babiloni kalikona yayapona ana awa waiwaisana, mani silba ali gewi tu handeled (200), ge gold ba maisena ana pulowan i ola 575 glem (grams) ya kitel. Yaka ya mata momoniagil ge ya ahel. Heliya iyoho ya sumel bilibiliya no epanapana gamwanaa, ge silba i minaa paiya.” ");
INSERT INTO mpx_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Inoke Yosuwa elopapatuna i patunal hi patalelu hi na epanapana elana. Yaka bugul bolo o hi pwawal i sumeliya to, i ola wana baaba. ");
INSERT INTO mpx_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Inoke bugubugul bolo o gegewel hi ahel hi pwatanik Yosuwa ge Isileli gegewel elal, yaka hi vatalil Yehoba manininaa. ");
INSERT INTO mpx_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Inoke Yosuwa alonau ge Isileli gegewel Eikan, Selaa tubutubunina, ginebi silba, kaliko yayapona, gold, i ola al natunau bolau ge yowau, wana bulumwakau, wana donki, wana sipi, wana epanapana ge wana bugubugul gegewena bolo hi gan elana, hi ahel hi na Eikol Abwabwina elana. ");
INSERT INTO mpx_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Yaka Yosuwa i baek Eikan elana i ba, “Hauna kaiwena ge nak u pwatanim elala? He lan ebe Yehoba nak ni ginol eliyam.” Yaka Isileli gegewel Eikan alonau natunau hi loipat-agil ge hi aliga, inoke abwe tuwaliya ge wali bugubugul gegewena hi tonil ginaha elana. ");
INSERT INTO mpx_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Yaka pat pahipahi bwabwatana hi pahe pwataliyaa, ge pat bolo o heliya iyoho ana siga lan ebe. Yaka Yehoba nige al i huhuga Isileli eliyalil. He panuwa o alana Yosuwa i tun Eikol Abwabwina ge alan o hi lumelumeni ana siga sauga ya. ");
INSERT INTO mpx_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Sauga etegana al Yosuwa alonau ge Isileli gegewel hi na Oya Ebal, inoke Yosuwa pat i pahe abapowon etega i ginol Yehoba Isileli wali Yabowaine kaiwena. ");
INSERT INTO mpx_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","I ginol i ola ana logugui, toto valila Yehoba wana totuwalali Mosese i baunan Isileli elal ge i leli wana Logugui ana Buki gamwanaa i ba, “Pat bwabwaligel bolo nige etuwalali aiyan elana hi tatal pasapu-agil te nuku ahe abapowon nuku pahe.” Yaka abapowon o pwatanaa bwasumu enuna hi powon pwabwaligel Yehoba elana ge enuna hi powonagil heliheliyam powonina. ");
INSERT INTO mpx_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Inoke labi o elana Mosese wana logugui toto valila i leli, Yosuwa i leli papanet pat pwataliyaa Isileli gegewel mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","He Isileli gegewel, bolo Isileli hot ge bolo bwabwali, avaliyau wali tonowakau, totuwalali alaliya bwabwatana, ge toasiyala, hi talmilila Yehoba wana Bateli ana Dedewaga bebena labui elal, awoliya i noek topowon bolo hi kaval elal, un Libai. Boda etega hi talmilila Oya Gelisim punaa ge boda etega hi talmilila Oya Ebal punaa. He hi talmilil i ola valila Yehoba wana totuwalali Mosese i ba nihi ginol ge gamagalau ba mulolu ana baaba nihi hago. ");
INSERT INTO mpx_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Yaka abwe Yosuwa Logugui gegewena ginebi ba mulolu ana baaba ge ba nuwamut ana baaba i vasili elal, i ola toto Mosese i leli lowan Logugui ana Buki gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Logugui maisena ge maisena bolo Mosese i leli, Yosuwa i vasili boda Isileli elal, ginebi ana yowau ge ana wawayau, i ola al bwabwali bolo hi minaa elal. ");
INSERT INTO mpx_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Adoni-sedek, Yelusalema ana kin, wasa i hago te Yosuwa panuwa Ai iyaka i ahe ge i apapanak-an hoti, ge ana kin i tagapaaliga, i ola valila i ginola panuwa Yeliko ge ana kin elal. I ola al wasa i hago te panuwa Gibiyon hi bateli avaliyau Isileli nihi mibubun, ge avaliyau hi tubwi pamaisena. ");
INSERT INTO mpx_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Inoke alonau wana gamagalau hi lovakun nabi, kaiwena hi atena Gibiyon iya panuwa bwabwatana, ana bwata i ola panuwa bwabwatal bolo wali kin i gan, yaa panuwa Ai nige i bwabwata, ge hi atena Gibiyon ana bolau heliya tolohaveyan waiwaisal. ");
INSERT INTO mpx_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Inoke Adoni-sedek Yelusalema ana kin, baaba i patuna Hoham Hebiloni ana kin, Pilam Yamut ana kin, Yapiya Lakis ana kin, ge Debil Eglon ana kin elal, ");
INSERT INTO mpx_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","i ba, “Ku nem ku labeyau ge ta lohaveyan Gibiyon elal, kaiwena hi bateli avaliyau Yosuwa ge Isileli nihi mibubun.” ");
INSERT INTO mpx_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Yaka kin ali gewi nimala panuna o, heliya boda Amoli wali kin enuna, wali ivan hi teli pamaisena-agil. Inoke avaliyau wali tolohaveyan hi na panuwa Gibiyon hi mipainan, yaka hi tuk ge hi lohaveyan elal. ");
INSERT INTO mpx_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","He Yosuwa iyoho Gilgal, Isileli wali abaholaviya, yaka ana baaba Gibiyon hi patuna hi ba, “Ama wam totuwalali, bahi nu teteli yohima! Etimwawa nu nem nu pwamwalima! Nu labema, kaiwena Amoli wali kin bolo hi minaa labi oyana gaganina, gegewel wali ivan hi teli pamaisena-agil ge hi nem hi haveyan elama.” ");
INSERT INTO mpx_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Inoke Yosuwa ge wana tolohaveyan gegewel avaliyau bolo waiwaisal Gilgal hi eguluwai. ");
INSERT INTO mpx_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","He mulaa abwe hi egon, Yehoba i baek Yosuwa elana i ba, “Bahi nu lolovakun-agil, heliya iyaka ya telel nimwamwa. Nige bosowaina avaliya etega ni pakokovewa.” ");
INSERT INTO mpx_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Yosuwa ge wana tolohaveyan Gilgal hi eguluwan, yaka bulin bwabwaligena hi nawanawa hi na hi tuk Amoli wali tolohaveyan elal ateliya hi payou. ");
INSERT INTO mpx_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","He Yehoba Amoli wali tolohaveyan nuwaliya i pagewagewa, inoke hi gewi nabi Isileli hi gopapaaliga-agil panuwa Gibiyon elana. Yaka hi takel hi loek Bet-Holon ana kela laulau elana ge hi mimi lololil ana siga hi na hi vin panuwa Aseka ge Makeda. ");
INSERT INTO mpx_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Sauga Isileli wali tolohaveyan iyoho Amoli hi tatakel hi loek Bet-Holon ana kela laulau elana, yaka Yehoba kehe kalakalapatina bwabwatal i ligin lowan Amoli pwataliyaa. He i ginoginol ola ya to ana siga hi na hi vin panuwa Aseka. He Amoli hi gewi hi yaomala kehe kalakalapatina elana, bolo Isileli hi lolil nige hi gegewi. ");
INSERT INTO mpx_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Lan toto o Yehoba Amoli i telel Isileli nimaliyaa. He heliya iyoho hi hahaveyan, inoke Yosuwa i baaba Yehoba elana. Isileli gegewel mataliyaa i ba: “Sabwelu, nu notalmilil panuwa Gibiyon pwatanaa; weikena, nu notalmilil Aiyalon Abwabwina pwatanaa.” ");
INSERT INTO mpx_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Inoke sabwelu i notalmilil ge weikena i notalmilil ana siga Isileli ali topihigelgel hi pakokovel. He liwanina iyoho Yasa i leli wana buki elana. He liwanina i ola to. Sabwelu i notalmilil natiya labulabum ana luwaluwala, yaka sauga ana yapu i ola lan maisena ana yapu i miola ga to nige i lolobek. ");
INSERT INTO mpx_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Lan o enaa ge lan o awonaa, nige sauga etega Yehoba gamagal etega anana i lalaeganan i oola toto i ginol lan o elana. He tunahot Yehoba te i lohaveyan Isileli kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Sauga Yosuwa alonau ge Isileli wali tolohaveyan Amoli hi pakokovel i mowasi, yaka hi sikal hi na wali abaholaviya panuwa Gilgal. ");
INSERT INTO mpx_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","yaka i ba, “Pat bwabwatal ku pakulil gol awana ku paankaus ge bolau enuna ku telel nihi matahikan. ");
INSERT INTO mpx_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Yaa bahi nuku veveyaho, ami topihigelgel nuku mimi tatakel ya! Yaka sauga heliya iyoho hi loulou, inoke nuku noha eliyaa ge nuku lolil, yaka bahi wali panuwa ona nihi lolou pwawa. He Yehoba wami Yabowaine iyaka i telel nimamiwa.” ");
INSERT INTO mpx_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Lan etega un Yuda bolauiliyau enuna avaliya Kelebi hi na Yosuwa elana panuwa Gilgal. Kelebi, iya Yepune natuna pwahiya Kenisi, i baek Yosuwa elana i ba, “U atena ya te valila panuwa Keides Baniya elana Yehoba ga i ba ola owa ge nau kaiwela Mosese elana, iya Yabowaine wana gamagal. ");
INSERT INTO mpx_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","He saugena o no baliman ana gewi poti (40), yaka Yehoba wana totuwalali Mosese i patunala Keides Baniya ta eguluwan ta nem labi ya ta anugayawa-an. Inoke ta sikal ge wasa tutunahotina ya wasaan elana, ");
INSERT INTO mpx_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","yaa bolau bolo avalau ta nok, wali wasa elana wala gamagalau hi palovakun-agil ge wali gasisi gegewena i mowasi. Yaa nau, Yehoba no Yabowaine ya melteli-an alona ateu bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Inoke lan o Mosese i bateli elau i ba, ‘Labi toto u nawaan ni tabwa alomwau ge tubutubumwau wami bilibili mihomihotina, kaiwena Yehoba no Yabowaine u melteli-an alona atem bwalibwaligena.’ ");
INSERT INTO mpx_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“Baliman poti paib (45) iyaka i mowasi te bateli o Yehoba i baunan Mosese elana. Sauga avalau boda Isileli ta nononawanawa ula kekevana elana, Yehoba i matahikagau nige ya aaliga, i ola wana bateli. He u kiteyau, lan ebe yawaliu ana baliman eiti paib (85) iyaka i pwawa. ");
INSERT INTO mpx_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","No gasisi lan ebe i ola ya to valila Mosese i patunala ta nem labi ya ta anugayawa-an. He lan ebe bosowaiu ya na haveyan ge na tatanem nowa ni ola sauga o elana. ");
INSERT INTO mpx_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Inoke ya awanun labi oyana gaganina toto lan o Yehoba i bateli eliyau, nu pem. He u nuwahikan te valila alou owa labi o ta anugayawa-an, yaka ta pwawa boda Anak heliya iyoho, ge wali panuwa i lobwata ali gana i gasisi ge i miha. Yaa ebo Yehoba ni labeyau, he bosowaiu ya na takel tagilagil ni ola wana baaba.” ");
INSERT INTO mpx_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Yaka Yosuwa i awanun Yehoba Kelebi, Yepune natuna, ni muloluan, yaka abwe panuwa Hebiloni i pek wana bilibili. ");
INSERT INTO mpx_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Inoke ana siga lan ebe, panuwa Hebiloni i tabwa Kelebi, Yepune natuna pwahiya Kenisi, tubutubunau wali bilibili, kaiwena Yehoba, Isileli wali Yabowaine, i melteli-an alona ge atena bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","(Hebiloni alana houhouwena Kiliyat-Aba. He valila Aba iya boda Anak wali toasiyala bwabwatana hot, inoke alana hi tun pwatanek panuwa elana.) Yaka panuwa ona hi laumwal nige al lohaveyan i gagan. ");
INSERT INTO mpx_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","He liwanina i ola to, inoke labi gegewena toto Yehoba i bateli Isileli tubuliyau houhouwel elal, he i pek elal yaka hi ahe wali panuwa ge hi minaan. ");
INSERT INTO mpx_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Yaka labi gegewel elal Yehoba i pamibubun-agil, i ola wana bateli tubuliyau houhouwel elal. Nige bosowaina ali topihigelgel etega ni talmilil gagasisi awoliyaa, kaiwena Yehoba i telel nimaliyaa ge hi pakokovel. ");
INSERT INTO mpx_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Yehoba wana bateli waiwaisal boda Isileli eliyalil, nige etega i tatabwa bugul bwagabwaga. He bateli gegewel i paolaolaek elal. ");
INSERT INTO mpx_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","“Nuku matahikagimiu bubun logugui toto Yehoba wana totuwalali Mosese i baunaniwa nuku ginol: Yehoba wami Yabowaine nuku nunuwana-an, wana kamwasa nuku toulil bubun, wana logugui nuku henapuan, nuku tubwi gagasisi eliyana, ge nuku kululuek elana ginebi ge atemiu bwalibwaligena ge yawalimiu bwalibwaligena.” ");
INSERT INTO mpx_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Yaa ebo ana en nuku pek, ge ebo boda bolo ku tagatelel iyoho hi mina gamwamiwa alomiyau nuku tubwi pamaisena ge nuku pealalolon-agimiu, ");
INSERT INTO mpx_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","he nuku atena bubun te Yehoba wami Yabowaine nige al boda o ni tatakel awomiwa. Yaa heliya nihi ola ami kota o ebo ami vineya, nihi ola hihiu elololina eputetemiu i lololi, o ebo pepesala matamiu i howahowa-an. Nihi ola to, ana siga nihi pwamowasemiu labi waiwaisana ya elana, toto Yehoba wami Yabowaine i pewa. ");
INSERT INTO mpx_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Sauga kekeisi abwe na yaomal, ni ola to tomipanayawi gegewela wala kamwasa. Atemiu gunina elana ku atena te bateli waiwaisal bolo Yehoba wami Yabowaine i batelemiu, nige etega i tatabwa bugul bwagabwaga. He wana bateli maisena ge maisena i paolaolaek eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Yaa ebo Yehoba wami Yabowaine nige nuku hehenapu-an, inoke nak gegewel bolo i baunanagil ni patunahot eliyamiu, ni ola te wana bateli maisena ge maisena i paolaolaek. He ni ginol ola eliyamiu ana siga ni pwamowasemiu labi waiwaisana ya elana, toto i pewa. ");
INSERT INTO mpx_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Ebo Yehoba wami Yabowaine wana bateli eliyamiu ana logugui nuku leke ge nuku kululu ge nuku tapwaloloek yabowaineyau gegetogal elal, inoke alona wana huga ni lahemiu, yaka etimwawa nuku mowasi hot labi waiwaisana ya elana, toto i pewa eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Inoke Yosuwa Isileli ali un gegewel i pamigogo-agil panuwa Sekemi elana. Yaka wali tonowakau, tohouwa, toasiyala, ge totuwalali alaliya bwabwatana i yogaagil hi na hi talmilil Yabowaine matanaa Petupatupa Limena awonaa. ");
INSERT INTO mpx_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Inoke i baaba heliya ge gamagal gegewel elal i ba, “Yehoba kila Isileli wala Yabowaine i ba i ola hiwe: Houhouwena elana tubumiyau hi miminek wewel Yupeleitis labena etega, ge hi kukululuek yabowaineyau gegetogal elal. He tubumiyau bolo o etegana te Tela, Abalahama ge Naho tamaliya. ");
INSERT INTO mpx_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Yaa tubumiu Abalahama ya ahem to labi o elana, ge ya nul labi Kenani gamwana gegewena i nawaan, ge tubutubunau hi gewi ya pek. Natuna Aisake ya pek, ");
INSERT INTO mpx_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","yaka Aisake natunau Yakobo ge Iso ya pek. Inoke labi Seil oyana gaganina ya pek Iso elana wana panuwa, yaa tubumiu Yakobo alonau ge natunau hi na hi lau Itipita. ");
INSERT INTO mpx_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“Yaka sauga etega abwe Mosese ge Eloni ya patunal hi na Itipita, inoke logabola nanakil ona ya ginolil Itipita ya apapanak-agil. Inoke tubumiyau ya ahe tagilagil Itipita elana. ");
INSERT INTO mpx_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Yaka sauga ya ahe tagilagil ge hi nawanawa, inoke Itipita aloliyau wali waga momomol ge wali hosi haveyan kaiwena hi tatauliulil-agil, ana siga hi kukuhikagil Hoga Keketina elana. ");
INSERT INTO mpx_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Yaa hi yoga eliyau labe kaiwena, yaka gogou ya teli heliya ge Itipita ali hawawala. Yaka abwe hoga ya pabini pasikal Itipita i yabomwil ge hi unun. He ku atena ya hauna ya ginol Itipita elal. Inoke ku miminaa ula kekevana elana sauga yayapona. ");
INSERT INTO mpx_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“Yaka abwe ya ahemiu ku na boda Amoli bolo Yolidani labi leunati wali labi elana. Inoke hi haveyan eliyamiu, yaa ya telel nimamiwa ku tagalakel. Nau ya houwa awomiwa ge ya apapanak-agil, inoke wali bilibili ku ahe wami panuwa. ");
INSERT INTO mpx_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Yaka abwe Belaki Sipo natuna, panuwa Mowabi wali kin, i lovivina tage haveyan i giginol eliyamiu, inoke baaba i patuna Belami Beo natuna elana ge ni na ni ba nuwamut-agimiu. ");
INSERT INTO mpx_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Yaa nige ya tatalam te Belami ni ginol ola o, inoke ya ba te ni ba muloluagimiu pagewigewi. I ginol ola o, inoke ya pwamwalimiu kin Belaki elana. ");
INSERT INTO mpx_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“Yaka wewel Yolidani ku kalapanet-an ge ku nem Yeliko. Inoke towohiliyau hi haveyan eliyamiu, i ola al boda Amoli, Pelisi, Hiti, Gegasi, Hivi, ge Yebusi hi haveyan eliyamiu, yaa gegewel ya telel nimamiwa ku tagalakel. ");
INSERT INTO mpx_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Wasamiu ya palelu awomiwa ge hi lovakun nabi, inoke heliya ge Amoli wali kin labui ya takel awomiwa. He nau ya pakokovel kaiwemiu, nige tage komiu wami haveyan kilepana ge wami egipoyo eliyana ge ku pakokovel. ");
INSERT INTO mpx_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Bilibili nige ku eeyowan, ge panuwa nige ku tatalil ya pewa eliyamiu. Inoke sauga ya ku miminaa panuwa o elal, yaka oine ge olibe bolo nige ku luluwanil enowaliya ku anana.” ");
INSERT INTO mpx_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Yaka Yosuwa i ba vevehe al i ba, “Yehoba nuku awatauwan ge nuku kululu tunahot elana. Yabowaine gogoginolil bolo valila tubumiyau hi kukululuek elal wewel Yupeleitis labena etega ge Itipita, nuku aliyohil, ge nuku kululuek ya te Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Yaa ebo nige amnamiu i oola nuku kululuek elana, he lan ebe ku hilihili hauna yabowaineyau elal nuku kululuek, ebo bolo valila tubumiyau hi kukululuek elal wewel Yupeleitis labena etega, o ebo Amoli, bolo wali labi sauga ya elana ku minaa, wali yabowaineyau. Yaa nau ge no limi ana heniheni naha kululuek Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Yaka anana gamagalau hi lahe hi ola, “Nigeya! Ama nige Yehoba naha eeguluwan ge naha kukululuek yabowaineyau gegetogal elal! ");
INSERT INTO mpx_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Yehoba wala Yabowaine kilau ge tubulau i ahe tagilagila Itipita wala abaloloyowana, ge matalaa ginol yawiyawi bwabwatal ona i ginolil. Kamwasaa ta nawanawa ge boda tomaha tomaha wali labi gamwaliyaa ta nosolasola, yaa iya i matahikagila. ");
INSERT INTO mpx_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Yaka Amoli ge boda gegewel bolo hi miminaa labi ya elana i takel awolaa. Inoke ama al ge naha kululuek Yehoba elana, iya wama Yabowaine.” ");
INSERT INTO mpx_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Inoke Yosuwa i baek elal i ba, “Bahi etimwawa nuku babaa houwa tage bosowaimiu ya nuku kululuek Yehoba elana, iya Yabowaine bwabwalena, ge nige i tatalam ana toawalaka ni gan. Wami awatautau ge wami gegi paganina nige ni nunuwayoho. ");
INSERT INTO mpx_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Bwagana valila wana pagan i waisi eliyamiu, yaa ebo nuku eguluwan ge nuku kululuek panuwa getogal wali yabowaineyau elal, nasi wana nuwatu ni pil, yaka nak ni ginol eliyamiu ge ni pwamowasemiu.” ");
INSERT INTO mpx_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Yaa heliya hi baek Yosuwa elana hi ola, “Nigeya! Ama naha kululuek Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Yaka Yosuwa i ba, “Totomiu ku wasaagimiu te iyaka Yehoba ku hile nuku kululuek elana. Inoke ebo nige nuku giginol ola, he ami lahi ni mwananal.” Anana hi lahe hi ba, “E, i ola.” ");
INSERT INTO mpx_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Inoke Yosuwa i ba, “Panuwa getogal wali yabowaineyau bolo hi minaa eliyamiu nuku aliyohil, ge atemiu nuku talamwan Yehoba elana, iya Isileli wala Yabowaine.” ");
INSERT INTO mpx_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Yaka gamagalau hi baek elana hi ba, “Ama naha kululuek Yehoba wala Yabowaine elana, ge wana baaba naha henapuan.” ");
INSERT INTO mpx_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Inoke lan o panuwa Sekemi elana Yosuwa bateli etega i ginol gamagalau kaiweliya avaliya Yehoba hi pebabateli-agil. Bateli o gamwanaa, logugui bolo bosowaina gamagalau nihi toulil. ");
INSERT INTO mpx_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Inoke Yosuwa i leli tukagil Yabowaine wana logugui ana buki gamwanaa. Yaka pat bwabwatana etega i ahe ge i pamilila abwakil ouk gabulanaa Petupatupa Limena labenaa. ");
INSERT INTO mpx_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Yaka i baek gamagalau gegewel elal i ba, “Pat ya etotohi. Yehoba wana baaba eliyala iyaka i hago, inoke ebo bwaliga nuku awatautau wami Yabowaine elana ge wami bateli toto ga ku ba ola nuku leke, iya ni wasaagimiu.” ");
INSERT INTO mpx_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Inoke Yosuwa gamagalau i patunal hi egonan, hi sikal wali panuwa ona elal, bolo valila i guyauan elal. ");
INSERT INTO mpx_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Toto o enaa, inoke Yehoba wana totuwalali Yosuwa Nan natuna, wana baliman wan handeled ge ten (110) i pwawa, ge i aliga. ");
INSERT INTO mpx_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Yaka tuwana hi teliya totona wana bilibiliya panuwa Timnat Sela, iyoho un Ipileimi wali labi oyana gaganina elana, oya Gas labena aluwabwa. ");
INSERT INTO mpx_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","He Yosuwa yawalina miminana Isileli hi kukululuek Yehoba elana, ge i ola al tonowakau bolo Yosuwa i yaomal luwagil yawaliliya miminana, bolo Yehoba wana ginol gegewena Isileli kaiweliya hi kite mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","He sauga Isileli hi tagilem Itipita, Yosepa tutuwana hi kalivai aloliya hi nawanawa. Tuwatuwa ona o hi teleliya panuwa Sekemi elana, bilibili toto valila Yakobo i pwamolaa Heimo natunau elal, molana mani silba elulu bwagabwaga (100). (Heimo natuna etega alana Sekemi.) He labi o i tabwa Yosepa tubutubunau wali bilibili. ");
INSERT INTO mpx_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Eloni natuna Eliyesa i aliga, inoke tuwana hi teliya panuwa Gibiya. Panuwa o valila hi pek Eliyesa natuna Pinehas elana wana panuwa, iyoho un Ipileimi wali labi oyana gaganina elana. ");
INSERT INTO mpx_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Mulaa abwe Isileli wali kin i gan, toasiyala wali sauga logugui gamwanaa, galebu bwabwatana hot i masal labi Kenani elana. Tonowak etegana alana Elimeleki, ana un Epalat, wana panuwa Bedeliyema labi Yuda. Inoke alonau lagona Naomi ge natuliyau melubolau eluwa, Maloni ge Kiliyon, hi nok hi na labi Mowabi ge hi miminaa ga to. ");
INSERT INTO mpx_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Hi minamina ee, yaka Elimeleki lagona ge natunau eluwa i yaomal luwagil. ");
INSERT INTO mpx_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Yaka abwe Maloni ge Kiliyon Mowabi galokiliyau eluwa hi alolonagil, etegana alana Opa, eluwana alana Ludi. Baliman i ola elulutega hi minamina ga, ");
INSERT INTO mpx_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","yaka abwe Maloni ge Kiliyon al hi aliga. Hinaliya Naomi hi yaomal luwai, nige lagona ge natunau i gagan. ");
INSERT INTO mpx_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi wasa i hago Yehoba iyaka wana gamagalau i muloluagil ge malul hi pwawa. Inoke alonau ge yawanau hi lovivina labi Mowabi nihi eguluwan ge nihi sikal Bedeliyema. ");
INSERT INTO mpx_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Yaka awan toto hi miminaa hi eguluwan ge hi nawanawa kamwasaa nihi na labi Yuda. ");
INSERT INTO mpx_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Inoke Naomi i baek yawanau elal i ba, “Ku sikal, ku na wami awana tutumiyau elal. Ya awanun Yehoba ni matahikagimiu ni ola wami matahikan elau ge bolo hi yaomal elal. ");
INSERT INTO mpx_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ge ya awanun Yehoba ni labemiu nuku alolon al ge nuku mibubun.” Yaka yawanau i nalol ge alonau hi kahikahin. ");
INSERT INTO mpx_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Abwe hi baek elana hi ba, “Bahiwa! Aloma owa ta na wam gamagalau elal.” ");
INSERT INTO mpx_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Yaa Naomi i baek elal i ba, “Yawawau, nuku sikal wami awana! Hauna kaiwena ge nuku tatauliulil eliyau? Ku nuwatu tage nasi bolau enuna na abil al inoke abwe nuku alolonagil? ");
INSERT INTO mpx_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yawawau, nuku sikal wami awana! Nau iyaka ya liki, nige bosowaiu na alolon al. Bwagana ebo na ba bosowaiu ya, he binimala nasi bulina na alolon ge abwe natuwau bolau na abil, ");
INSERT INTO mpx_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","age bosowaimiu ya nuku matamatan nige nuku aalolon ana siga nihi lobwata? Yawawau, nigeya! He komiu ku nuwaleyan, yaa nau ya nuwaleyan hot, kaiwena Yehoba iyaka o en i pem.” ");
INSERT INTO mpx_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Inoke hi lokahin al, yaka Opa yawana i nalo ge i lokaiyoni. Yaa Ludi i kukuhikan yawana eliyana. ");
INSERT INTO mpx_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Yaka Naomi i ba, “He wam pan-alolon iyaka i sikal i nana tutunau ge wana yabowaineyau elal. U sikal u na alom.” ");
INSERT INTO mpx_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Yaa anana Ludi i lahe i ba, “Bahi nu babaa na eguluwagiwa ge na sisikal no awana. Na nowa alou owa. Ga nu noek, na noek, ge ga nu minaa, na minaa. Tutumwau, he tutuwau, ge wam Yabowaine, he no Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ga nu aligaa, na aligaa, inoke nihi teleyawa to. Yaomal ya maisena abwe ni teli pwamwaumwau-agila. Ebo bugul getoga al ni teli getogaagau, he ya talamwagau Yehoba hauna wana lahi kaiweu, ni ginol.” ");
INSERT INTO mpx_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Sauga Naomi i kite Ludi wana nuwatu i gasisi hot ni nok alona, inoke nige al baaba etega i babaunan. ");
INSERT INTO mpx_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yaka ali toto labui hi nawanawa. Sauga hi vin Bedeliyema, inoke gamagalau gegewel awan o eliyana ateliya i waiwai kaiweliya, ge yowau hi nel hi ba, “Tunahot Naomi e?” ");
INSERT INTO mpx_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi i baek elal i ba, “Bahi alau toto Naomi nuku lulumen. Nuku ba Mala, kaiwena Togasisi Hot iyaka i panuwaleyan-agau. ");
INSERT INTO mpx_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Sauga panuwa ya ya eguluwan ya kalaopop hot, yaa no sauga sikalim enoenovau ya. He Yehoba i ginol olaagau to. Ga i ola ge alau toto Naomi ku lumen? Yehoba iyaka i palomwanagau; Togasisi Hot iyaka o nak i ginol.” ");
INSERT INTO mpx_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","He Naomi i sikalem labi Mowabi, alona ge yawana Ludi, Mowabi yovana, liwanina i ola to. Bali abwe hi telipuna tomwatomwa te hi vin Bedeliyema. ");
INSERT INTO mpx_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi ana giba Elimeleki tutuna etegana alana Bowasa, iya togogomwau ge alana i bwata. ");
INSERT INTO mpx_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Lan etegana Ludi Mowabi yovana i baek yawana Naomi elana i ba, “Tab bosowaina na nok na na bali ali eyowaa? Ebo gamagal etega ni yaliyaya-agau, yaka totomwatomwa na toulilil ge bali ana haka toto hi pipasogu na hivat eliyaa.” Yaka Naomi i talam i ba, “Ee, yawau, u nok.” ");
INSERT INTO mpx_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Inoke Ludi i na bali ana eyowa etega elana ge haka toto totuwalali hi pipasogu i hivahivat eliyaa. Yaa age Bowasa, Elimeleki tutuna, wana bali ana eyowa te i noek. ");
INSERT INTO mpx_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Sauga kekeisi abwe Bowasa i noem Bedeliyema i na wana eyowaa. Inoke i ba mulolu wana totuwalali elal i ba, “Yehoba alomiu.” Anana hi lahe hi ba, “Yehoba ni mulolu-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowasa i nel wana totuwalali wali tohouwa elana i ba, “Hauna yova o? Henala tutuna?” ");
INSERT INTO mpx_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Inoke totuwalali wali tohouwa i ba, “Iya Mowabi yovana, toto valila alona ge Naomi hi nem. ");
INSERT INTO mpx_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ewasi i nem i baem eliyau i ba, ‘Tab bosowaina na noek totuwalali eliyaa ge bali ana haka toto hi pipasogu na hivat.’ Yaka i nok ge mweluluga ana siga sauga e i mimi tuwatuwalali, yaa i veyaho ga sauga kekeisi epanapana gabulanaa.” ");
INSERT INTO mpx_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yaka abwe Bowasa i baek Ludi elana i ba, “Natu, u laegan. Bahi nu nana eyowa getoga elana ge bali nu hihivat, besena te toto e. Nu minaa te alomwau ge no totuwalali yowau. ");
INSERT INTO mpx_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nu kite hauna labi elana bolau hi totomwaa, yaka yowau bolo hi hivahivat ge hi kinkin, nu toulilil ge nu hivat eliyaa. Iyaka ya baek no totuwalali bolau elal nige nimaliya ni nonoewa eliyam. Ge sauga ebo nu walem, nu na wewel toto totuwalali hi wage nu im.” ");
INSERT INTO mpx_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Yaka Ludi i kululu, maninina i loek bilibiliya, ge i ba, “Nau panuwa getoga gamagalina, ga i ola ge u yaliyaya-agau i ola o?” ");
INSERT INTO mpx_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Anana Bowasa i lahe i ba, “Wasam ya hago bugul gegewena u ginolil yawam kaiwena, sauga lagom i yaomal ana siga sauga e. Ya hago ga u ola ge tamwam, hinam ge wam panuwa u eguluwagil, ge u nem u minaa gamagalau bolo valila nige u aatenal gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ya awanun Yehoba ni mulolu-agiwa wam tuwalali waiwaisana enona. Iyaka u nem u minaa Yehoba, Isileli wama Yabowaine gabulanaa, iya am libu. He ya awanun mola bwabwatana hot ni pewa.” ");
INSERT INTO mpx_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Yaka Ludi i ba, “Tonowak, ya atena iyaka u yaliyaya-agau, kaiwena bwagana nau nige wam totuwalali etega i oola, wam baaba eliyau i waisi yaka amnan waiwaisana ya pwawa.” ");
INSERT INTO mpx_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Aanan ana sauga yaka Bowasa i baek Ludi elana i ba, “U nem hiwe, am beleid enuna nu ahe, ge nu pahun oine elana.” Yaka i na i misiyo alonau ge totuwalali, ge Bowasa bali enona toto hi ekeke enuna i pek elana. Ludi i anan e ana siga ana luvi i pwawa, yaa aanan enuna iyoho i tupwa. ");
INSERT INTO mpx_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Sauga Ludi i lut ge i nanawa bali ni hivat al, inoke Bowasa i baek wana totuwalali bolau elal i ba, “Bwagana ebo ni hivat nek bali ali kin gamwaliyaa, bahi nuku lolopwali. Yaa bali ana haka enuna nuku momol tagilan ali kin elana ge nuku teli ni ahe.” ");
INSERT INTO mpx_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Inoke Ludi bali ana haka i hivahivata eyowa toto o elana ana siga i kokoyavi. Sauga i bibi ge enona i lobabal, he ana bwata i ola 10 kiloglem. ");
INSERT INTO mpx_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ludi bali i toun ge i sikal i na panuwaa, inoke ana bwata yawana i pankite. I ola al wana an teli i pek yawana elana. ");
INSERT INTO mpx_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Yaka Naomi i nel yawana elana i ba, “Henala wana eyowaa bali ana haka u hivahivata lan e? Yehoba gamagal toto i yaliyaya kaiwem ni muloluan.” Anana Ludi i lahe i ba, “Ya hivahivata tau toto alana Bowasa wana bali ana eyowaa.” ");
INSERT INTO mpx_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Yaka Naomi i baek yawana elana i ba, “Ya awanun Yehoba ni muloluan. Yehoba wana atilomwan nige sauga etegana i momowasi. He bolo iyaka hi yaomal valila hi pwawa ge kila al lan ebe ta pwawa.” Yaka i ba vevehe al i ba, “Tau toto ei lagou tutuna etegana. Iya ala topwapwamola pasikal etegana, iya bosowaina ni ahela ge ni matahikagila.” ");
INSERT INTO mpx_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Inoke Ludi, Mowabi yovana, i ba, “I baem al eliyau i ba, ‘Nu hivahivata no eyowaa, alomwau no totuwalali, ana siga no bali enona nihi tomwa haba.’” ");
INSERT INTO mpx_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Yaka Naomi Ludi anana i lahe i ba, “E, yawau, i waisi te ebo alomwau ge wana totuwalali galokau bali ana haka nuku hivahivata wana eyowaa. Ebo nu na gamagal getoga wana eyowaa, tab eba pagan nanakina nihi ginol elam.” ");
INSERT INTO mpx_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Inoke Ludi alonau ge Bowasa wana galokau hi tuwalali toyawa ana siga bali ge witi ali tomwatomwa i mowasi. He i miminaa yawana elana. ");
INSERT INTO mpx_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Sauga etega abwe Naomi i baek Ludi elana i ba, “Yawau, wam abamina etegana na loyaan ge eliyana nu mibubun. ");
INSERT INTO mpx_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","He Bowasa toto wana galokau alomwau ku tuwatuwalali, iya lagou tutuna etega. Nasi bulina bali enona alona ge musana ni ase ana abaasiasi elana. ");
INSERT INTO mpx_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Nu na nu highig, tuwam nu paenonu, ge kaliko waiwaisana nu galoi. Inoke nu na bali musana ana abaasiasi elana, yaa bahi Bowasa ni kikitewa ana siga ni anan ge ni im haba. ");
INSERT INTO mpx_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Nu kite bubun ga i kekenuwa. Sauga ebo iyaka ni kenu mati, inoke nu na aenaa habobu nu gabom pasikal, yaka nu kenu. Iya abwe ni baewa elam hauna nu ginol.” ");
INSERT INTO mpx_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Yaka anana Ludi i lahe i ba, “Na ginol ni ola wam baaba.” ");
INSERT INTO mpx_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Inoke Ludi i na bali musana ana abaasiasi elana ge bugul gegewena toto yawana i baunan eliyana i ginol. ");
INSERT INTO mpx_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Sauga Bowasa i anan ge i im haba, yaka amnana i waisi, inoke i na i kenu bali enowana ana pwahin buhunaa. Yaka Ludi i nokekei i na Bowasa aenaa habobu i gabom pasikal ge i tal kenu. ");
INSERT INTO mpx_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Bulin nuwana Bowasa atena i you, yaka i kul pil yova etega i kite i kenukenu aena gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Inoke i nel i ba, “Henala owa?” Anana i lahe i ba, “Tonowak, nau Ludi. Am habobu buhuna u anal u pahabobuwau, kaiwena owa topwapwamola pasikal etegana kaiwema.” ");
INSERT INTO mpx_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Yaka Bowasa i ba, “Yehoba ni muloluagiwa. Nunuwana toto u ginol sauga ya i bwata lake toto valila u ginola Naomi elana. Kaiwena nige hevalau, ebo togulagula o ebo towasawasa, u loloyaagil. ");
INSERT INTO mpx_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","He bahi nu nuwanuwatu. Na ginol ni ola wam awanun. Kaiwena panuwa ya ana tomina gegewel hi atena owa yova toto wana pagan sasapona. ");
INSERT INTO mpx_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tunahot nau topwapwamola pasikal etegana, yaa etegana al iyoho i gan, iya Elimeleki ana tiniya hot, nau tini kekeisi. ");
INSERT INTO mpx_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Bulin e nu kenuwa ga te. Bwaligumwa mweluluga iya na hago ga. Ebo nuwana ni ginol ni ola pwapwamola pasikal ana ginol, he i waisi. Yaa ebo nigeya, he ya bateli Yehoba yawalina gaganina alanaa, nau na ginol. He u kenuwa te ana siga mweluluga.” ");
INSERT INTO mpx_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Inoke Ludi i kenuwa Bowasa aena gegelinaa ana siga mweluluga. Panuwa nigeya ga i mwamwananal hot ge i bosowaina gamagal ali awa ta kite bubun, yaka Ludi i lut, kaiwena Bowasa i ba, “Bahi gamagalau nihi atena te u kenuwa e.” ");
INSERT INTO mpx_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Yaka Bowasa i baek Ludi elana i ba, “Am kaliko babalona tultul kaiwena u ahem ge u anal hiwe.” Sauga i ginol ola, inoke Bowasa bali ana bwata kelaubwa tuwenti kiloglem (20 kg) i ligin kaliko pwatanaa ge i patoun. Inoke Ludi i sikal ni na wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Sauga i vin, inoke Naomi i neli i ba, “Yawau, wam nawanawa wasana ga i ola?” Inoke bugul gegewena toto Bowasa i ginol eliyana i wasaan. ");
INSERT INTO mpx_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Yaka i ba vevehe al i ba, “Bowasa i baem eliyau, ‘Bahi enoenovam nu sisikal yawam eliyana.’ Yaka bali hiwe, ana bwata kelaubwa tuwenti kiloglem, i pem.” ");
INSERT INTO mpx_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Inoke Naomi i ba, “Yawau, u matamatan ga ana siga ta kite hauna gun ni masal. Lan ebe Bowasa nige ni babakuhu ana siga am logugui ni pasapu.” ");
INSERT INTO mpx_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bowasa i na panuwa o ana gana ana abatuktuka, wali abamimigogowa, ge i misiyowa to. Yaka Elimeleki tutuna, iya topwapwamola pasikal etegana al toto Bowasa i babaunan, i nem. Inoke Bowasa i baek elana i ba, “Alou, u nem u misiyowa hiwe.” Inoke i nok i na i misiyo. ");
INSERT INTO mpx_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Yaka Bowasa panuwa o ana tonowakau elulutega i ahel ge i ba hi misiyo. ");
INSERT INTO mpx_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Inoke i baek toto topwapwamola pasikal elana i ba, “Naomi iyahe i sikalem Mowabi, ge nuwana tutula Elimeleki wana bilibili ni palian. ");
INSERT INTO mpx_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Inoke atewa ya ba nuwatu o na pwatanim eliyam ge na baewa elam na ba, ‘Bilibili u ahe tonowakau bolo hi misiyowa e mataliyaa.’ Ebo nuwam nu pwamola pasikal, he nu pwamola pasikal. Yaa ebo nige nuwam i oola, yaka nu ba na hago. Kaiwena pwapwamola pasikal ana logugui te owa houwa emwa abwe nau.” Inoke anana tonowak o i lahe i ba, “Nau na pwamola pasikal.” ");
INSERT INTO mpx_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Yaka Bowasa i ba, “Ebo bilibili nu pwamola Naomi elana, he nasi abuabul Ludi, Mowabi yovana, u aahe lagom. Inoke wawayau nu pamasalil yaka toto i alaliga alana nihi milili ge bilibili ni miminaa ya ana tiniya.” ");
INSERT INTO mpx_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Sauga tonowak baaba o i hago, inoke i ba, “Iyaka nige bosowaiu bilibili o na pwamola pasikal, kaiwena nige bosowaina natuwau nihi ahe. He nau nige na pwapwamola, owa te nu pwamola pasikal.” ");
INSERT INTO mpx_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(He saugena o elana, Isileli wali pagan te ebo gamagal etega nige nuwana bilibili ni pwamola pasikal yaka gasisi ni pek alona elana ni pwamola, inoke aena aana ni ahek yoho ge ni pek alona elana. Inoke gamagalau nihi kite ge nihi patunahot.) ");
INSERT INTO mpx_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Inoke sauga tonowak o i baek Bowasa elana, “Owa nu pwamola pasikal,” yaka aena aana i ahek yoho ge i pek Bowasa eliyana. ");
INSERT INTO mpx_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Inoke Bowasa i baek tonowakau ge gamagalau gegewel elal i ba, “Lan ebe iyaka ku kite matamiwa, Elimeleki alonau natunau, Kiliyon ge Maloni, wali bilibili gegewena iyaka ya pwamolaa Naomi elana. ");
INSERT INTO mpx_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","I ola al Maloni abuabulina Ludi, Mowabi yovana, iyaka ya ahe lagou. Inoke wawayau na pamasalil, yaka toto i alaliga alana nihi milili ge bilibili ni miminaa ya ana tiniya, yaka alana bahi ni yayaomal ana un ge panuwa ya elana. He lan ebe iyaka ku kiteya matamiwa.” ");
INSERT INTO mpx_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Yaka tonowakau ge gamagalau gegewel bolo hi migogowa panuwa ana gana ana abatuktuka, hi ba, “Iyaka ha kiteya matameya. Ha awanun Yehoba lagom ni paabab ni ola Letiyeli ge Leya hi abab ge Yakobo natunau hi gewi hi abil. Ha awanun al Yehoba eliyana nu tabwa un Epalat ana towasawasa ge alam ni bwata Bedeliyema gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Tubutubumwau bolo yova ya eliyana abwe Yehoba ni pewa, alaliya ni bwata, ni ola Peles, Yuda ge Tama natuliya, tubutubunau alaliya i bwata.” ");
INSERT INTO mpx_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Inoke Bowasa Ludi i ahe lagona. Yaka alona hi kenukenu ge Yehoba Ludi i muloluan i liyan, inoke i ab natuna melutauina. ");
INSERT INTO mpx_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Yaka nevenakau hi baek Naomi elana hi ba, “Ta tobal Yehoba eliyana, iya lan ebe tubum etega i pewa am tomatahikan. Ha awanun Yehoba eliyana, wawaya ya abwe alana ni bwaya Isileli gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Iya yawalim ni pavavaluna ge ni matahikagiwa wam liki ana sauga elana. He yawam i nunuwana-agiwa ge wana labe eliyam i bwata nabi, i lake te binimala natumwau bolau seben nihi gan wali labe. Inoke lan ebe iya tubum etega i ab.” ");
INSERT INTO mpx_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Yaka Naomi wawaya o i ahe i teli aenaa, ge i matahikan i ola natuna. ");
INSERT INTO mpx_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Inoke panuwa o nevenakiliyau hi ba, “Naomi iyaka natuna melutauina i gan.” Yaka wawaya o alana hi tun Obedi. He Obedi natuna Diyesi, ge Diyesi natuna Deibid. ");
INSERT INTO mpx_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peles tubutubunau ali lihu i ola hiwe: Peles natuna Hesiloni, Hesiloni natuna Lama, ");
INSERT INTO mpx_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Lama natuna Aminadab, ");
INSERT INTO mpx_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab natuna Nason, Nason natuna Salimon, ");
INSERT INTO mpx_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salimon natuna Bowasa, Bowasa natuna Obedi, ");
INSERT INTO mpx_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedi natuna Diyesi, ge Diyesi natuna Deibid. ");
INSERT INTO mpx_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Tau etega alana Elekana i neem panuwa Lama, labi Sup, Ipileimi wali labi oyana gaganina elana. He Elekana tamana Yeloham, Yeloham tamana Elihu, Elihu tamana Tohu, ge Tohu tamana Sup, ali un Ipileimi. ");
INSERT INTO mpx_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Lagonau labui, etegana alana Hana ge eluwana alana Penina. He Penina i abab, yaa Hana nige i aab. ");
INSERT INTO mpx_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Baliman maisena ge maisena alonau ge natunau wali panuwa nihi eguluwan, ge nihi na panuwa Sailo Yehoba wana limiya, nihi tapwalolo ge bwasumu nihi powonan Yehoba Togasisi Hot elana. He panuwa o elana topowon Ilai natunau bolau labui, Hopni ge Pinehas hi topowon Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Sauga ebo Elekana bwasumu ni powonan, inoke aanan ana sauga elana bunumwina ni gabom natunau elal. Lagona Penina ana awahini ni pek elana, ge Penina natunau bolau ge yowau ali awahini ona al ni pek elal. ");
INSERT INTO mpx_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Yaa Hana ana awahini ni pek pwabwata, kaiwena i nunuwana-an nabiyan, bwagana lalgamanina Yehoba i kaus ge nige i aab. ");
INSERT INTO mpx_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Penina alona i awaawahuli-an ge amnana i apapanak-an, kaiwena lalgamanina Yehoba i kaus ge nige i aab. ");
INSERT INTO mpx_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Inoke baliman maisena ge maisena Penina i giginol i olaola ya to. Sauga ebo nihi na Yehoba wana limiya panuwa Sailo, yaka alona ni mimi awahuli-an ana siga ni kahin ge nige ni aanan. ");
INSERT INTO mpx_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Inoke lagona Elekana ni nel elana ni ba, “Hana, ga i ola ge u kahin? Ga i ola ge nige u aanan? Ga i ola ge atem i lomwan? Nau ya nunuwana-agiwa nabiyan! He no nunuwana o ana nuwatu te ni bwata eliyam, yaa tage natumwau bolau elulutega nihi gan ana nuwatu nige i bwabwata.” ");
INSERT INTO mpx_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Sauga etegana heliya yoho Sailo, powon enowana hi aanan ge hi imwim enaa, yaka Hana i lut i na ni awanun. He topowon Ilai iyoho to i misiyo wana abamisiyowa Yehoba wana limi ana nog labenaa. ");
INSERT INTO mpx_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hana atena i lomwan nabi, inoke alona ge wana kahin i awaawanun Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Inoke Hana bateli gasigasisena i ginol i ba, “O Yehoba Togasisi Hot, matam nu lipwatanim no nuwanak nu kite, yaka no awanun nu hago. Ebo natu melutauina etega nu pem, inoke ya papasila te na pewa pasikal ni minaa Yehoba eliyam yawalina ana sauga bwalibwaligena, ge iya ni bwabwalena elam nige kokowana pupunona nihi totomwa.” ");
INSERT INTO mpx_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","He Hana iyoho ya i awaawanun Yehoba elana, yaka Ilai matana i lihikan awana i gayawaan. ");
INSERT INTO mpx_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Hana atena elana i awaawanun ge hohopena i palamwalamwaniu, yaa nige anana i gagan. Inoke Ilai i nuwatu tage wewel gasigasisena i im kokonaan. ");
INSERT INTO mpx_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Yaka i baek elana i ba, “Hauna sauga abwe nu bakuhu imwim? Wam imwim paganina nu paveyaho.” ");
INSERT INTO mpx_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Anana Hana i lahe i ba, “Tonowak, nigeya! Nige oine o ebo wewel gasigasisena getoga etega ya iim. Yawaliu eliyana o pulowan i bwata hot, yaka yayaluwau ana lomwan ya ba tagilan Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Bahi nu nunuwatu tage nau wam totuwalali yova sisisigana. Ateu i lomwan nabi ge ya nuwanak te ya awaawanun e.” ");
INSERT INTO mpx_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Anana Ilai i lahe i ba, “Nu egon ginebi wam laumwal. He ya awanun Isileli wala Yabowaine wam awanun lahena ni paolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Inoke Hana i ba, “Ateu owa, tonowak! He sauga gegewena nau wam totuwalali nu yaliyaya-agau!” Yaka abwe i egon i na i anan, nige al nuwana i nanak. ");
INSERT INTO mpx_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","He Elekana alonau lagonau ge natunau hi kenuwa to, lan i gan mweluluga kekeisi hi lut hi na hi tapwalolo Yehoba elana, inoke abwe hi sikal wali panuwaa Lama. Yaka Elekana alona ge lagona Hana hi kenukenu inoke Hana wana awanun Yehoba i lahe. ");
INSERT INTO mpx_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","He sauga nige i yayapu yaka Hana i liyan ge i ab natuna melutau, yaka alana i tun Samuwela. I tun ola o, kaiwena i ba, “Ya awanuni Yehoba elana inoke i pem.” ");
INSERT INTO mpx_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Powon toto baliman maisena ge maisena hi giginol ana sauga iyaka i pwawa al, inoke Elekana alonau natunau gegewel hi nok al panuwa Sailo bwasumu nihi powonan Yehoba elana, ge i ola al wana bateli etegana toto valila i ginol ni patunahot. ");
INSERT INTO mpx_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","He sauga o Hana nige i nonok, yaa i baek lagona elana i ba, “Nige na nonowa, ana siga wawaya ni bwata ge hul na paalayoho. Yaka abwe na ahe na pwatanik ge na guyauan Yehoba elana, inoke ni mihot yawalina ana sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Yaka Elekana i baek lagona elana i ba, “Hauna gun ebo u nuwatu i waisi eliyam, inoke nu ginol. He nuku mina ga ana siga wawaya ni bwata ge hul nu paalayoho. Ge ya awanun Yehoba ni labewa inoke wam bateli nu patunahot.” Inoke Hana i misikal ge natuna i matahikan. ");
INSERT INTO mpx_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Sauga hul i paalayoho, he wawayana ya te hinana ge tamana hi ahe ge hi pwatanik Yehoba wana limiya panuwa Sailo. I ola al bulumwakau melutau maisena wana baliman eton, pwalawa ana bwata kelaubwa ni ola ten kiloglem (10 kg), ge oine patuna maisena hi ahel wali powon kaiwena ge hi nok. ");
INSERT INTO mpx_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Sauga bulumwakau hi lol ge hi powonan Yehoba elana, yaka geman hi pwatanik Ilai elana. ");
INSERT INTO mpx_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Inoke Hana i ba, “Tonowak, tunahot nau yova toto valila u kiteyau ya taltalmilila e ge ya awaawanun Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Ya awanun wawaya toto ya kaiwena, yaka no awanun Yehoba i paolaolaek eliyau. ");
INSERT INTO mpx_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Inoke sauga ya na guyauan pasikal elana, ge ni totuwalali iya kaiwena yawalina ana sauga gegewena.” Inoke hi tapwalolowa to Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Yaka Hana i awanun i ba: “Ateu i yaliyaya Yehoba elam,   no gasisi i noem owa eliyam. Ya ba hanaha o topihigelgel elal,   ya yaliyaya kaiwena u pwamwalau. ");
INSERT INTO mpx_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Nige etega i bwabwalena i oola owa Yehoba,   nige yabowaine etega al i gagan,   ge nige Pat abalou etega i oola wama Yabowaine owa. ");
INSERT INTO mpx_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","O topihigelgel elal na ba, ‘Wami ba hanahanaha ku paveyaho!   Besemiu ba haha! Kaiwena Yehoba iya Yabowaine toto bugul gegewena i atena,   ge iya wala ginol gegewena i hihile.’ ");
INSERT INTO mpx_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Tolohaveyan gasigasisel wali egipoyo i gabogabomwan,   yaa bolo hi pweyata i pagasisi-agil. ");
INSERT INTO mpx_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Bolo valila tineliya i kiya, tuwalali hi loya wali aanan kaiwena,   yaa bolo valila hi galebu, iyaka nige al hi gagalebu. Yova toto valila i kobwas, sauga ya wawayau ali gewi seben i abil,   yaa yova toto valila natunau bolau hi gewi, iyaka hi yaomal haba nige ana tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Yehoba iya yawal ana toahe, iya al yawal ana topem.   Enuna i teli lowagil salaiya ge enuna i teli heyagil. ");
INSERT INTO mpx_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Yehoba gamagalau enuna i pagulagula-agil, ge enuna i pagogomwau-agil,   enuna i pahanalowagil, ge enuna i teli heyagil abamina bwabwatana elana. ");
INSERT INTO mpx_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Togulagula i palutil papakova gamwanaa,   ge i latahiniliem wali miloloyowana. Ali hehegan i abubun hi ola kin natunau,   ge i telel hi minaa abamisiyo wawasana elana. He i ola, kaiwena panayawi labena gegewena Yehoba wana bugul.   Bugul gegewel i telel abaliyaa ge ali logugui i ginol. ");
INSERT INTO mpx_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Wana gamagalau bwabwalel i matahikagil,   yaa nak ana toginol nihi yaomal nihi na nihi minaa gogouwa. Nige bosowaina gamagal totona wana gasisi elana ge ni tagalaka. ");
INSERT INTO mpx_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Bolo hi pihigelgel Yehoba elana ni apapanak-agil hoti. He ali lahi ni baunan wana baaba ni ola gulumwawa i loem labulabumwa,   Yehoba panayawi labena esopali ni payatalal. Gasisi ni pek wana kin elana,   iya wana hilihili gamagalina wana gasisi ni pwabwata.” ");
INSERT INTO mpx_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Yaka Elekana alona ge lagona Hana hi sikal hi na wali panuwaa Lama, yaa geman Samuwela hi eguluwana to i totuwalali Yehoba kaiwena Ilai wana logugui gabulanaa. ");
INSERT INTO mpx_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ilai natunau bolau labui Hopni ge Pinehas wali ginol nige i wawaisi, nige Yehoba hi aawatauwan. ");
INSERT INTO mpx_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","He powon bwasumona bunumwina toto topowon kaiweliya ana logugui nige hi totoulil. Sauga ebo gamagal etega ni na bwasumu ni powonan Yehoba elana, ge bunumwina ni ligaliga aanan kaiwena, Hopni ge Pinehas nige nihi mamatamatan ali bunum ni gabom elal. Yaa wali totuwalali etega nihi patuna pok bwabwatana matana eton ni ahe ge ni nok. ");
INSERT INTO mpx_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Inoke ni paulu lowan ulun gamwanaa, yaka bunum toto ni howa pwawa ni ahe topowon labui o kaiweliya. He Isileli gegewel bolo hi na panuwa Sailo ge bwasumu nihi powonan Yehoba elana, ali hehegan hi giginol i olaola ya to. ");
INSERT INTO mpx_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Ge i ola al, sauga enuna nige ga posa nihi toton abapowon elana, yaka topowon wali totuwalali ni na ni baek tau toto i popowon elana ni ba, “Topowon ana bunum enuna nu pem ni ekeke. Iya nige nuwana i oola toto liligana nu pek, nuwana kolena.” ");
INSERT INTO mpx_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Ge ebo tau ni ba, “Nigeya, binimala posa ga ta ton houwa Yehoba elana, yaka abwe hauna gabom toto nuwam, he nu ahe,” inoke anana totuwalali ni lahe ni ba, “Nigeya! Sauga ya nu pem! Ebo nigeya, nasi totou na ahe.” ");
INSERT INTO mpx_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","He Ilai natunau bolau labui wali gegi i bwata hot Yehoba matanaa, kaiwena ana powon nige hi aawatauwan. ");
INSERT INTO mpx_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Yaa geman Samuwela topowon ali kaliko, kaliko waiwaisana hi ginoliya, alana ipod, i gagaloi ge i totuwalali Yehoba kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Baliman maisena ge maisena Hana Samuwela ana holahola yayapona ni ginol ana luvi elana. Inoke sauga alona ge lagona nihi na baliman maisena ge maisena ana powon nihi ginol Yehoba elana, yaka holahola o ni ahe ni na ni pek Samuwela elana. ");
INSERT INTO mpx_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","He mulaa abwe Elekana ge lagona nihi sikal wali panuwaa, Ilai ni ba mulolu-agil ni ba, “Ya awanun Yehoba ni mulolu-agimiu natumiyau enuna al Hana ni abil, inoke wawaya toto i guyauan Yehoba elana abana nihi milahe.” ");
INSERT INTO mpx_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Inoke Yehoba Hana i muloluan, yaka abwe wawayau bolau eton ge yowau labui i abil. Yaa geman Samuwela i bwataa Yehoba wana limiya. ");
INSERT INTO mpx_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","He Ilai iyaka i liki hot, natunau bolau labui wali ginol nanakina gegewena Isileli gegewel elal wasana i hago. I hago al te avaliyau yowau bolo hi tutuwalaliya Petupatupa Limena ana abatuktuk elana hi gaganawal. ");
INSERT INTO mpx_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Yaka i baek elal i ba, “Hauna kaiwena ginol ya ku awaawaginol? Gamagalau no wasa hi pem wami ginol nanakina kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","He nuku bakuhu, natuwau. Wasa toto ya hago hi papalelu Yehoba wana gamagalau gamwaliyaa nige i wawaisi. ");
INSERT INTO mpx_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Binimala gamagal gegi ni ginol wana pan gamagal elana, Yabowaine bosowaina ni label ge gegi o nihi pasapu. Yaa ebo gamagal ni gegi Yehoba elana, nige etega bosowaina gamagal o ni labe.” Yaa Ilai natunau bolau labui nige hi oolak tamaliya wana pahepahenapu elana, kaiwena Yehoba wana nuwatu i ola te ni tagapaaligal. ");
INSERT INTO mpx_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","He geman Samuwela i bwabwata nawa ge i ola al Yehoba ge gamagalau hi yaliyaya-an nabiyan. ");
INSERT INTO mpx_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Lan etega palopita etega i na i baek Ilai elana i ba, “Yehoba i ba ola hiwe: Sauga boda Isileli hi minaa Itipita ana kin wana paloloyowan elana, inoke totou ya pamasalau tubum Eloni ge ana un elal. ");
INSERT INTO mpx_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Isileli ali un gegewel gamwaliyaa tubum Eloni ya hile ni tabwa no topowon, bwasumu ni powonan abapowona, bugul bwalena waiwaisana ni ton ana abatontona, ge topowon bwabwatana ana kaliko alana ipod ni galoi ni talmilil maniniwa. I ola al ya talam Isileli wali powon bwasumona gabomwina enuna tubum Eloni ana un nihi an. ");
INSERT INTO mpx_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Ga i ola o powon ge o mulolu nige ku aawatauwan? Natumwau ali awatauwan i bwata, yaa nau o awatauwan nige i bwabwata. No gamagalau Isileli wali powon bwasumona gabomwiliyau bolo waiwaisal ku mimi anani inoke eliyana ku lotabwa. ");
INSERT INTO mpx_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“Nau Yehoba Isileli wami Yabowaine, valila ya bateli am tini toto i noem tubumwau elal nuku topowon kaiweu sauga gegewena. He iyaka nige al ni oola to! Bolo hi awatauwagau, heliya te na awatauwagil, yaa bolo hi awatautau elau, na towaagil. ");
INSERT INTO mpx_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Sauga i nenem am tini bolauiliyau na pwamowasel. Nige tubutubumwau bolau etega wana liki hot ni pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Pulowan nihi gewi nihi masal am tini gamwanaa. No mulolu na guyauan boda Isileli elal, yaa komiu nige etega wana liki hot ni pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Ebo tubutubunim etega nige na aahek yoho abanaa ni topowon, he iya ni nuwanuwanak ge ni kahikahin matanununa ni laulau. Tubutubumwau gegewel wali sauga gasisi gamwanaa te nihi aliga. ");
INSERT INTO mpx_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Natumwau bolau labui Hopni ge Pinehas nihi aliga lan maisena elana, inoke toto ya ni ola wam etotohi ge nu atena bugul gegewena bolo ya baunan eliyam abwe nihi tunahot. ");
INSERT INTO mpx_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","“He topowon etega na pamilil toto bosowaina ana mel na teli ge ni ginol ni ola hauna ya nuwatuan atewa. Na ba iya ana tini ni tutubwe ya, ge nihi topowon no hilihili gamagaliliyau kin ona elal sauga gegewena. ");
INSERT INTO mpx_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Inoke tubutubumwau bolo nige nihi aaliga, gegewel nihi na nihi loepwakoku matanaa nihi awanun mani kekeisi ge aanan mumwina kaiwena. Nihi ba, ‘U hilema topowon naha label, yaka aama ni gan naha aanan.’” ");
INSERT INTO mpx_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Geman Samuwela i totuwalali Yehoba kaiwena Ilai wana logugui gabulanaa. He saugena o elana, baaba toto i nonoem Yehoba elana ge wana pankite nige i gangan hot boda Isileli elal. ");
INSERT INTO mpx_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Ilai matana iyaka i pwepweyata nawa nige bosowaina bugul ni kite bubun. Bulin etega iya iyoho i kenukenu wana abakenuwa, ");
INSERT INTO mpx_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","ge geman Samuwela iyoho i kenu Yehoba wana limi gamwanaa, toto Yehoba wana Bateli ana Dedewaga hi teliya. He mweluluga kekeisi Limi Bwabwalena ana odam nige ga hi papabolu, ");
INSERT INTO mpx_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","yaka Yehoba i yoga i ba, “Samuwela!” Inoke anana i lahe i ba, “O, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Yaka i lut i tapalelu i na Ilai elana ge i ba, “Tonowak! U yogaagau, he nau hiwe.” Anana Ilai i lahe i ba, “Nige ya yoyogaagiwa, u sikal u na u kenu.” Inoke Samuwela i sikal ge i na i kenu. ");
INSERT INTO mpx_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Yaka Yehoba i yoga al i ba, “Samuwela!” Yaka Samuwela i lut i na Ilai elana ge i ba, “Tonowak! U yogaagau, he nau hiwe.” Anana Ilai i lahe i ba, “Natu, nige ya yoyogaagiwa, u sikal u na u kenu.” ");
INSERT INTO mpx_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","He Samuwela nigeya ga Yehoba i aatena, kaiwena nige sauga etega i baaba elana ge i hahago. ");
INSERT INTO mpx_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Inoke Yehoba i yoga paetonina, yaka Samuwela i lut i na Ilai elana ge i ba, “Tonowak! U yogaagau, he nau hiwe.” Inoke abwe Ilai i nuwatu Yehoba te geman Samuwela i yogaan. ");
INSERT INTO mpx_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Yaka i baek elana i ba, “U sikal u na u kenu. Ebo ni yogaagiwa al, yaka nu talam nu ba, ‘Yehoba, u ba na hago, nau wam totuwalali ya laegan-agiwa.’” Yaka Samuwela i sikal i na i kenu abanaa. ");
INSERT INTO mpx_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Inoke Yehoba i na i talmilila Samuwela gegelinaa ge i yoga i ola wana yoga bolo houwa, i ba, “Samuwela! Samuwela!” Yaka anana i lahe i ba, “U ba na hago, nau wam totuwalali ya laegan-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Inoke Yehoba i baek elana i ba, “Bugul etega ya giginol boda Isileli gamwaliyaa, inoke wasana nihi hago ge nuwaliya nihi ahe. ");
INSERT INTO mpx_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Lan o, lahi toto ya baunan Ilai ana tini kaiweliya, gegewena na ginol paolaolaek. ");
INSERT INTO mpx_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Iyaka ya baek elana te lahi mihomihotina na ginol ana tini elana, kaiwena natunau wali ginol i bwaikikin matawa. He Ilai i atena ya, yaa nige i papaveyahol. ");
INSERT INTO mpx_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Inoke ya papasila Ilai ana tini kaiweliya te nige powon o ebo mulolu etega bosowaina ge wali gegi ni yakil yoho.” ");
INSERT INTO mpx_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samuwela i kenu ana siga mweluluga, yaka i lut ge Yehoba wana limi ana nog i pwela. Yaa i lovakun te Yehoba hauna i baunan ana pankite elana ni wasaan Ilai elana. ");
INSERT INTO mpx_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Yaka Ilai i yoga elana i ba, “Samuwela, natu.” Anana i lahe i ba, “O, nau iyahe.” ");
INSERT INTO mpx_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Yaka Ilai i baek elana i ba, “Yehoba ga i ba ola eliyam? Bahi nu aalahan eliyau. Ebo bugul etega nu sume eliyau, he Yehoba lahi pupulowanina hot ni ginol eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Inoke Samuwela bugul gegewena i wasaan eliyana, nige etega i aalahan. Yaka Ilai i ba, “Iya Yehoba, hauna toto i waisi matanaa, he ni ginol ya.” ");
INSERT INTO mpx_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","He Samuwela i bwabwata nawa, Yehoba i minaa elana ge i labe wana baaba gegewena nige etega i tatabwa bugul bwagabwaga. ");
INSERT INTO mpx_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Yaka Isileli gegewel, i telipunaa aluwabwa un Dani wali labiya i na ana siga yavanaa Biyaseba ana labiya, hi atena te Samuwela iya Yehoba wana palopita etega. ");
INSERT INTO mpx_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","He Yehoba i mimi masamasal Samuwela elana panuwa Sailo ge wana baaba i babaunan elana. ");
INSERT INTO mpx_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Yaka abwe Samuwela i wawasaan Isileli gegewel elal. Sauga o elana Isileli wali tolohaveyan hi lovivina-agil ge nihi tagil nihi na avaliyau Pilistiya nihi lohaveyan. Isileli hi holaviya Ebenisa ge Pilistiya hi holaviya Apek. ");
INSERT INTO mpx_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Yaka Pilistiya wali tolohaveyan hi tagil hi na avaliyau Isileli hi petupatupa-agil ge hi lohaveyan. Haveyan i gagasisi nawa, yaka Pilistiya Isileli hi pakokovel ge ali gewi po tausan (4,000) hi lolil. ");
INSERT INTO mpx_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Sauga Isileli wali tolohaveyan hi sikal wali abaholaviya, yaka wali tonowakau hi penelnel-agil hi ba, “Hauna kaiwena Yehoba i talamwagila Pilistiya hi pakokovela lan ebe? Ta na panuwa Sailo Yehoba wana Bateli ana Dedewaga ta kalivai pwatanim, inoke alola ta na haveyana ge ni pwamwalila ala topihigelgel nimaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Inoke bolau enuna hi patunal hi na panuwa Sailo Bateli ana Dedewaga hi kalivai, toto Yehoba Togasisi Hot i minaa pwatanaa bwasumu labui opeliya gaganina ali luwaluwala. He Ilai natunau bolau labui Hopni ge Pinehas iyoho to aloliya Bateli ana Dedewaga. ");
INSERT INTO mpx_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Sauga hi pwatanik wali abaholaviya, yaka boda Isileli gegewel hi yoga analiya i bwata ge bilibili i nunu. ");
INSERT INTO mpx_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Pilistiya yoga bwabwatana hi hago inoke hi nel hi ba, “Ga i ola ge Hibilu hi yogayoga abaholaviya o?” Yaka abwe wali wasa hi pek te Yehoba wana Bateli ana Dedewaga iyaka hi pwatanik Isileli wali abaholaviya. ");
INSERT INTO mpx_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Inoke hi lovakun nabi ge hi ba, “He yabowaine etega to hi pwatanik wali abaholaviya o. Kila iyaka ta nak! Valila ginol ololana o nige sauga etegana i mamasal elala. ");
INSERT INTO mpx_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Eeu, kila geb! Henala ni pwamwalila yabowaineyau togasisi o nimaliyaa? Heliya te valila logabola nanakina ona hi ginolil Itipita elal labi kekevana elana. ");
INSERT INTO mpx_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Pilistiya, nuku gasisi! Nuku haveyan ginebi wami atimatuwa! Ebo nigeya, he nasi Hibilu nihi pakokovela, yaka ta tabwa wali totuwalali loloyowanil, ni ola valila hi totuwalali loloyowan elala. Nuku haveyan ginebi wami atimatuwa!” ");
INSERT INTO mpx_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Pilistiya hi haveyan gagasisi, inoke Isileli hi pakokovel. He Isileli wali tolohaveyan ali gewi teti tausan (30,000) hi gopapaaliga-agil, yaka hi gewi al hi lou hi na tomaha ona wali epanapana elana. ");
INSERT INTO mpx_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","He Pilistiya Yabowaine wana Bateli ana Dedewaga hi ahe, i ola al Ilai natunau bolau labui, Hopni ge Pinehas, hi gopaaligal. ");
INSERT INTO mpx_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Lan maisena o elana, tau etega ana un Beniyamina i lou neem abalohaveyana ni na panuwa Sailo. He nuwanak kaiwena ana kaliko iyaka i kukuleli ge papakova i yoho heyan kokowanaa. ");
INSERT INTO mpx_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Sauga i vin, Ilai iyoho i misiyo wana abamisiyowa kamwasa bebenaa ge i matamatan, kaiwena atena i bwanabwana ge i lovakun bahi nak etega ni gagan Yabowaine wana Bateli ana Dedewaga elana. Yaka tau o i tuk panuwa gamwanaa ge haveyan wasana i wasaan, inoke gamagalau gegewel hi gan kahikahin analiya i bwata. ");
INSERT INTO mpx_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Ilai anan bwabwatana o i hago inoke i nel i ba, “Hauna gun i gan ge gamagalau hi gangan kahikahin o?” Inoke tau etimwawa i na Ilai elana. ");
INSERT INTO mpx_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","He Ilai wana baliman naenti eit (98) iyaka i pwawa ge matana i tupa nige bosowaina bugul ni kite. ");
INSERT INTO mpx_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Yaka tau i baek elana i ba, “Lan ya abwe ya lou neem abalohaveyana.” Yaka Ilai i nel i ba, “Natu, hauna i gan?” ");
INSERT INTO mpx_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Inoke tau o Ilai anana i lahe i ba, “Kila Isileli wala tolohaveyan Pilistiya hi lou luwagil ge hi gewi hi lopaaligal. I ola al natumwau bolau labui Hopni ge Pinehas iyaka hi aliga, ge Yabowaine wana Bateli ana Dedewaga hi ahe egonan.” ");
INSERT INTO mpx_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","He Ilai i misiyowa panuwa ana abatuktuk bebenaa. Sauga Yabowaine wana Bateli ana Dedewaga wasana i hago, inoke i soguem wana abamisiyowa ge i loek enaa. Yaka mwamwalina i tal apwal ge i aliga, kaiwena iyaka i liki ge i tabwa. Iya Isileli i houwaagil baliman ana gewi poti. ");
INSERT INTO mpx_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Ilai natuna Pinehas lagona i liyan ge wana ab i kelakelaubwa. Sauga wasa i hago Yabowaine wana Bateli ana Dedewaga Pilistiya hi ahe, ge yawana Ilai ge lagona Pinehas iyaka hi aliga, inoke wawaya matana i panana. Yaa ab lomwanina i bwata hot yaka i ab aliga. ");
INSERT INTO mpx_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Mulaa abwe ni yana yoho ge ni aliga, topapaab hi baek elana hi ba, “Bahi pweyata! Natum melutauina etega te u ab e.” Yaa nige analiya i lalahe ge i oolak elal. ");
INSERT INTO mpx_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","He sauga wawaya i masal, alana i tun Ikabod, ge i ba, “Yehoba alona ge wana wasawasa kila Isileli i miluwagila.” I ba ola o, kaiwena Yabowaine wana Bateli ana Dedewaga iyaka hi ahe, i ola al yawana Ilai, ge lagona Pinehas iyaka hi aliga. ");
INSERT INTO mpx_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","He i ba, “Yehoba alona ge wana wasawasa kila Isileli i miluwagila, kaiwena Yabowaine wana Bateli ana Dedewaga iyaka hi ahe.” ");
INSERT INTO mpx_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","He Pilistiya Yabowaine wana Bateli ana Dedewaga iyaka hi ahe, inoke hi kalivaiem panuwa Ebenisa ge hi pwatanik Asdod, heliya wali panuwa bwabwatana etega. ");
INSERT INTO mpx_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Inoke hi nanatukan wali yabowaine Dagon wana limi tapwalolo gamwanaa ge hi teliya kakanununa gogoginol bebenaa. ");
INSERT INTO mpx_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Hi kenu lan i gan mweluluga kekeisi panuwa o gamagaliliyau hi lutan ge hi kite gogoginol o iyaka i sogu maninina i loek bilibiliya Yehoba wana Bateli ana Dedewaga awonaa. Inoke hi ahe ge hi teli pasikal abanaa. ");
INSERT INTO mpx_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Yaa sauga hi kenu ge lan i gan al mweluluga kekeisi, hi lutan ge hi kite iyaka i sogu al maninina i loek bilibiliya Yehoba wana Bateli ana Dedewaga awonaa. Kokowana ge nimana labui hi mwagabom ge hi minaa nog abatuktuk ana yamwan elana, he tuwana ge aena ya te hi mina. ");
INSERT INTO mpx_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Heiya te kaiwena i nem ana siga lan ebe, Dagon wana topowon o ebo bolo nihi tuk wana limi tapwalolowa panuwa Asdod elana, nog abatuktuk ana yamwan nige nihi popoti. ");
INSERT INTO mpx_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Yehoba wana gasisi elana Asdod ginebi awanina ona i apapanak-agil nabiyan, kasiyebwa youlololon i ola baliyan elana i lolil. ");
INSERT INTO mpx_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Sauga bolauiliyau hi kite hauna i gangan, inoke hi ba, “Isileli wali Yabowaine wana Bateli ana Dedewaga bahi ni miminaa elala. He wana gasisi elana avala ge wala yabowaine Dagon i aapapanak-agila.” ");
INSERT INTO mpx_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Inoke Pilistiya wali panuwa bwabwatal gegewel wali tologugui hi yoga gogonil ge hi nelil hi ba, “Hauna ta ginol Isileli wali Yabowaine wana Bateli ana Dedewaga elana?” Analiya hi lahe hi ba, “Ku ahe ku pwatanik panuwa Gat.” Yaka hi ahe ge hi na hi teli panuwa o elana. ");
INSERT INTO mpx_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Inoke gamagaliliyau gegewel i telipunaa wawayau i na ana siga liki, Yehoba wana gasisi elana i lahel youlololon i ola baliyan i masal elal, inoke hi lovakun nabi ge panuwa hi paawaawauli. ");
INSERT INTO mpx_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Yaka hi patuna al i na panuwa Eklon. Yaa sauga i tuktuk panuwa gamwanaa, yaka gamagalau hi yoga hi ba, “Isileli wali Yabowaine wana Bateli ana Dedewaga iyaka hi pwatanim elala. He nuwaliya gegewela ta aliga!” ");
INSERT INTO mpx_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Inoke Pilistiya wali panuwa bwabwatal gegewel wali tologugui hi yoga gogonil al ge hi baek elal hi ba, “Isileli wali Yabowaine wana Bateli ana Dedewaga ta patuna pasikal ni na totona wana abaminaa, eba gegewela ni lolila ge ta aliga.” He hi ba ola o, kaiwena Yabowaine wana gasisi elana i apapanak-agil iyaka hi alaliga, inoke hi lovakun nabi ge panuwa gamwana gegewena hi paawaawauli. ");
INSERT INTO mpx_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","I ola al bolo nige hi aaliga, youlololon i ola baliyan i masal tuwaliyaa. Inoke gamagalau panuwa o elana hi yoga ha wali yabowaineyau elal ge nihi label. ");
INSERT INTO mpx_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Yehoba wana Bateli ana Dedewaga i miminaa Pilistiya wali labiya waikena seben. ");
INSERT INTO mpx_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Yaka wali topowon ge tokukula hi yogaagil, inoke hi baek elal hi ba, “Binimala hauna naha ginol Yehoba wana Bateli ana Dedewaga elana? Ku ba eliyama hauna ginebi naha patuna pasikal ni na totona wana abaminaa?” ");
INSERT INTO mpx_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Analiya hi lahe hi ba, “Ebo nuku patuna, bahi awawana nuku papasikal, yaa ginebi ge ana mulolu wala gegi molana. Nuku ginol ola o, inoke ebo ta molu, yaka ta atena iya te wana gasisi elana ala gila i awaawaginol.” ");
INSERT INTO mpx_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Inoke gamagalau hi nel hi ba, “Hauna mulolu naha patuna Isileli wali Yabowaine elana wala gegi molana?” Analiya hi lahe hi ba, “Gold nuku ahe kasiyebwa youlololon i ola baliyan kakanununa nimala panuna ge sikokoi kakanununa nimala panuna nuku ginolil, ni paolaolaek Pilistiya wala tologugui ali gewi. Kaiwena heliya ge kila logabola maisena elana i apapanak-agila. ");
INSERT INTO mpx_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Inoke kasiyebwa youlololon i ola baliyan kakanununa ge sikokoi bolo wala panuwa hi apapanak-an kakanunuliya nuku ginolil wala awatauwan Isileli wali Yabowaine elana. Inoke tabam ni veyaho nige al wana gasisi elana avalau wala yabowaineyau ge wala panuwa ni aapapanak-agila. ");
INSERT INTO mpx_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Ga i ola ge bugul ya kaiwena atemiu i gasisi i ola houhouwena Itipita aloliya ge wali kin hi ginol? Ali hehegan Yabowaine i apapanak-an, enaa abwe Isileli hi talamwagil hi tagil. ");
INSERT INTO mpx_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","“Waga momomol vavaluna etega nuku ginol, yaka bulumwakau toab vavalul labui bolo nige sauga etega hi papatuwalali-agil nuku ahel. Inoke waga momomol nuku am hikan gaunapuliyaa, yaa natuliyau nuku ahel nuku telel ali ganaa. ");
INSERT INTO mpx_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Inoke Yehoba wana Bateli ana Dedewaga nuku usan waga momomol gamwanaa. Yaka kakanun gold hi ginoliya bolo nuku patuna wala gegi molana, nuku usan dedewaga etega elana ge nuku teliya Bateli ana Dedewaga bebenaa. Inoke bulumwakau nuku patuna egonagil waga momomol nihi momol ge totoliya nihi nawanawa, ");
INSERT INTO mpx_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","yaa nuku kite hikan bubun. Ebo nihi nopasapu Isileli panuwana Bet-Semes kaiwena, yaka ta atena Yehoba te logabola nanakina ya i pwatanim elala. Yaa ebo nigeya, he ta atena te iya nige nak ya i giginol elala, yaa i masal bwagabwaga ya.” ");
INSERT INTO mpx_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Inoke hi ginol ola to. Waga momomol vavaluna etega hi ginol, yaka hi ahe ge hi am hikan bulumwakau toab vavalul labui gaunapuliyaa. Yaa natuliyau hi telel ali ganaa. ");
INSERT INTO mpx_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Yaka Yehoba wana Bateli ana Dedewaga ginebi kasiyebwa youlololon i ola baliyan ge sikokoi kakanunuliya gold hi ginoliya ana dedewaga hi usan waga momomol gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Inoke hi noegon hi nopasapu kamwasaa, nihi na Isileli panuwana Bet-Semes elana. Bwagana hi nonowaguwagul natuliyau baeliya, yaa nige hi nonoek labeliya awoliyaa o ebo gegebaliyaa. Yaka Pilistiya wali tologugui nimala panuna bulumwakau hi nouliulilagil ana siga Bet-Semes ana sigaa. ");
INSERT INTO mpx_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","He panuwa Bet-Semes wali witi hi tomwatomwa opwopwa. Sauga mataliya hi lihin Bateli ana Dedewaga hi kite, yaka hi yaliyaya nabi hot. ");
INSERT INTO mpx_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","He bulumwakau waga momomol hi momol tukan Yosuwa gagama Bet-Semes wana witi ana eyowaa, yaka hi notalmilila pat bwabwatana bebenaa. Inoke un Libai bolauiliyau enuna hi na Yehoba wana Bateli ana Dedewaga, ginebi kakanun gold hi ginoliya ana dedewaga, hi kaval palol ge hi teleliya pat bwabwatana pwatanaa. Yaka gamagalau waga momomol ana ginol hi kukulekaleka-an ge hi gela powon ana ebwakil, yaka bulumwakau hi lolil ge hi powonagil pwabwaligel Yehoba elana. Inoke lan o elana Bet-Semes gamagaliliyau bwasumu enuna al hi powon pwabwaligel, ge enuna hi powonagil Yehoba elana heliheliyam powonina. ");
INSERT INTO mpx_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Pilistiya wali tologugui nimala panuna ginol o gegewena hi kite, yaka abwe lan maisena o elana hi sikal hi na panuwa Eklon. ");
INSERT INTO mpx_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","He kasiyebwa youlololon i ola baliyan kakanununa gold hi ginoliya bolo Pilistiya hi patuna Yehoba elana wali gegi molana ali gewi nimala panuna, i paolaolaek Pilistiya wali taun maisena ge maisena Asdod, Gasa, Askelon, Gat ge Eklon. ");
INSERT INTO mpx_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","I ola al, sikokoi kakanununa gold hi ginoliya ali gewi nimala panuna, i paolaolaek Pilistiya wali taun bwabwatal ginebi ge awanina ona, bolo tologugui ali gewi nimala panuna hi logugui-agil. He pat bwabwatana toto Yehoba wana Bateli ana Dedewaga hi teliya, iyoho to Yosuwa wana witi ana eyowaa. Inoke sauga o ge i nem ana siga sauga e, i panuwahikagil bugul bolo hi ginola o kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Yaa Yehoba Bet-Semes bolauiliyau ali gewi sebenti (70) i lolil ge hi aliga, kaiwena mataliya i lau wana Bateli ana Dedewaga gamwanaa. Inoke gamagal nuwaliya i nak ge hi kahikahin Yehoba wana ginol o kaiwena, ");
INSERT INTO mpx_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","yaka hi ba, “Nige etega bosowaina ni talmilil Yehoba manininaa, kaiwena iya Yabowaine bwabwalena. He Bateli ana Dedewaga ta patuna egonan, yaa i nana henalau elal?” ");
INSERT INTO mpx_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Yaka elopapatuna enuna hi patunal hi na Kiliyat-Yelim gamagaliliyau elal ge hi ba, “Pilistiya iyaka Yehoba wana Bateli ana Dedewaga hi pasikal. Ku nem ku lau ku ahe ge ku na ku teliya wami panuwaa.” ");
INSERT INTO mpx_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Inoke Kiliyat-Yelim bolauiliyau hi na hi lau Bet-Semes Yehoba wana Bateli ana Dedewaga hi ahe. Yaka hi na hi teliya Abinadab wana limiya, i miminaa oya etega elana, ge natuna Eliesa hi pwabwabwalena Dedewaga ana tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Sauga i yapu Yehoba wana Bateli ana Dedewaga i miminaa panuwa Kiliyat-Yelim. He baliman ana gewi tuwenti (20) i mowasi, yaka abwe Isileli hi nuwa sikal Yehoba elana ge hi awanun kahikahin labe kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Inoke Samuwela i baek Isileli gegewel elal i ba, “Ebo ku sisikal Yehoba elana ginebi ge atemiu bwalibwaligena, he panuwa getogal wali yabowaineyau ge yabowaine Astolet gogoginolil nuku aliyohil. Yaka nuku talamwagimiu ge nuku kululuek ya te Yehoba elana, inoke iya abwe ni pwamwalimiu Pilistiya nimaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Yaka Isileli yabowaineyau Bal ge Astolet gogoginolil hi aliyohil ge hi kululuek ya te Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Inoke Samuwela i ba, “Isileli gegewel nuku pamigogo-agil panuwa Mispa, yaka nau abwe na awanuna to Yehoba elana kaiwemiu.” ");
INSERT INTO mpx_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Sauga Isileli hi migogo, yaka gamagalau hi na wewel hi wagi ge hi ligin bilibiliya Yehoba matanaa. Inoke lan o elana ali galebu hi palahikan, ge wali gegi hi lopapit hi ba, “Ama iyaka ha gegi Yehoba elana.” (He Mispa elana te Samuwela i tabwa Isileli wali tohouwa.) ");
INSERT INTO mpx_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Sauga Pilistiya wasa hi hago te Isileli heliya iyoho hi migogo panuwa Mispa, yaka wali tologugui nimala panuna avaliyau wali tolohaveyan, hi nok ge nihi haveyan elal. He Isileli wasa hi hago inoke hi lovakun, ");
INSERT INTO mpx_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","yaka hi baek Samuwela elana hi ba, “Nu mimi awaawanun Yehoba wala Yabowaine elana, inoke ni pwamwalima Pilistiya nimaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Inoke Samuwela sipi natuna memelona etega i ahe i lol ge i powonan pwabwalige Yehoba elana. Yaka i awanun nabinabi Isileli kaiweliya ge wana awanun lahena Yehoba i ginol. ");
INSERT INTO mpx_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","He Samuwela iyoho ya powon bwasumona i tonton, yaka Pilistiya wali tolohaveyan hi noha Isileli gegeliliyaa ge nihi haveyan elal. Yaa Yehoba i ba gulumwawa butuna bwabwatana i gan, yaka Pilistiya wali tolohaveyan nuwaliya i pagewagewa inoke Isileli hi lou luwagil. ");
INSERT INTO mpx_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Inoke Isileli wali tolohaveyan hi tagilem panuwa Mispa, yaka Pilistiya hi takel ge hi mimi lololil ana siga panuwa Bet-Ka hi eguluwan. ");
INSERT INTO mpx_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Yaka Samuwela pat etega i ahe ge i pamilila panuwa Mispa ge Sen ali luwaluwala. Yaka i ba, “Yehoba i labela ana siga sauga ya,” inoke pat alana i tun Ebenisa. ");
INSERT INTO mpx_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","He Isileli iyaka Pilistiya hi pakokovel hoti, inoke nige hi sisikal al ge hi lolohaveyan Isileli wali labiya. Samuwela yawalina miminana, Yehoba wana gasisi elana Pilistiya i teli lowagil. ");
INSERT INTO mpx_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Yaka Isileli wali panuwa bolo hi minaa Eklon ge Gat ali luwaluwala, valila Pilistiya hi oel haveyan elana, Isileli iyaka hi ahel pasikalil, ginebi ge awanina ona bolo hi minaa panuwa o wali labiya. I ola al, Isileli avaliyau Amoli hi laumwal ge hi mibubun. ");
INSERT INTO mpx_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Samuwela iya Isileli wali tohouwa, i telipunaa Mispa elana ge i nok ana siga i yaomal. ");
INSERT INTO mpx_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Baliman maisena ge maisena ni nopain panuwa Betel, Gilgal ge Mispa, yaka kot ni awaawaginol panuwa o elal ge Isileli ali pulowan ni abubun. ");
INSERT INTO mpx_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Yaa sauga gegewena i sisikal wana panuwaa Lama, inoke kot ni awaawaginol al to. Yaka pat abapowon i paheya to Yehoba kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samuwela iyaka i liki, inoke natunau bolau labui i telel hi tabwa Isileli wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Natuna gamaun alana Yoeli, ge loena alana Abaidiya, hi miminaa panuwa Biyaseba ge kot hi awaawaginol. ");
INSERT INTO mpx_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Yaa wali ginol nige i oola tamaliya wana pagan. Heliya hi nuwa mani, yaka kakakawi manina hi ahiahi gamagalau elal ge logugui ana sapu hi pipil getogaan. ");
INSERT INTO mpx_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Yaka Isileli wali tonowakau gegewel ali boda hi pamaisena, inoke hi na Samuwela elana panuwa Lama, ");
INSERT INTO mpx_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","ge hi baek elana hi ba, “Iyaka u liki ge natumwau wali ginol nige i oola wam pagan. He gamagal etega nu hile ni tabwa wama kin ge ni houwaagima, ni ola boda gegewel al wali kin i gan.” ");
INSERT INTO mpx_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Yaa wali awanun kin kaiwena Samuwela nige i yayaliyaya-an, inoke i na i awanun Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Yaka Yehoba i baek elana i ba, “Nu ginol ni ola wali baaba eliyam, kaiwena nige tage owa hi towaagiwa, yaa nau hi towaagau nige nuwaliya na ola wali kin. ");
INSERT INTO mpx_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","I telipunem lan toto ya ahel hi tagilem Itipita ana siga lan ebe, hi miluwagau ge hi kukululuek yabowaineyau gegetogal elal. He pagan maisena o heiya te hi awaawaginol eliyam ei. ");
INSERT INTO mpx_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Nu ginol ni ola wali baaba, yaa wali wasa nu pek bubun yaka nihi atena te kin toto bwaliga ni logugui-agil ga ni ginol ola elal.” ");
INSERT INTO mpx_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Yaka Yehoba wana baaba gegewena Samuwela i baunanik gamagalau elal, heliya hi awanun nuwaliya kin. ");
INSERT INTO mpx_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","I ba, “Kin toto bwaliga ni logugui-agimiu wana ginol eliyamiu ni ola hiwe: Natumiyau bolau ni aheliya eliyamiu, yaka enuna ni telel nihi heya wana haveyan ana waga momomol elal, enuna wana hosi pwataliyaa, ge enuna ni ba nihi patalelu wana waga momomol awonaa. ");
INSERT INTO mpx_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Enuna ni telel wana tolohaveyan tausan ali toematana, ge enuna pipti (50) ali toematana. Enuna wana eyowa nihi giyagiyal ge nihi pahipahi. I ola al, enuna ni telel elohaveyan ge wana waga momomol ana etuwalali buguliliyau nihi awaawaginol. ");
INSERT INTO mpx_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Natumiyau yowau ni aheliya eliyamiu, yaka ni ba enonu bwalena waiwaisana nihi awaawaginol, aanan nihi ligaliga ge pwalawa nihi umuumun iya kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Wami bilibili, wami oine ana eyowa ge wami olibe ana gungun, bolo waiwaisal hot, ni ahel ni pek wana totuwalali alaliya bwabwatal elal. ");
INSERT INTO mpx_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Wami witi ge oine ni wali paelulutega yaka gamwaliyaa wali maisena ni ahe ge ni guyauan wana totuwalali alaliya bwabwatal ge wana totuwalali enuna al elal. ");
INSERT INTO mpx_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Wami totuwalali loloyowanil bolau ge yowau, ginebi ge wami bulumwakau ge wami donki waiwaisal, ni ahel ni patuwalali-agil totona kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Wami bwasumu sipi ge goti ni wali paelulutega, yaka gamwaliyaa wali maisena ni ahe, ge komiu al nuku tabwa wana totuwalali loloyowanil. ");
INSERT INTO mpx_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","He sauga o elana, abwe nuku yoga ha labe kaiwena Yehoba elana kin toto ku hile kaiwemiu wana ginol kaiwena, yaa lan o elana Yehoba nige ni lalabemiu.” ");
INSERT INTO mpx_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Yaa gamagalau nige nuwaliya i ola Samuwela wana baaba nihi laeganan, yaka hi ba, “Nigeya! Nuwama wama kin ni gan ge ni logugui-agima. ");
INSERT INTO mpx_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Yaka naha ola boda gegewel al, wama kin ni gan ni houwaagima ge haveyan elana ni toematana.” ");
INSERT INTO mpx_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Sauga Samuwela gamagalau wali baaba gegewena i hago, yaka i na i baunanik Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Anana Yehoba i lahe i ba, “Nu ginol ni ola wali baaba, inoke gamagal etega nu hile wali kin.” Yaka Samuwela i baek Isileli elal i ba, “Gegewemiu ku sikal ku na tomaha ona wami panuwaa.” ");
INSERT INTO mpx_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Tau etega alana Kisi ana un Beniyamina, iya togogomwau ge alana i bwata. Tamana alana Abiyel, Abiyel tamana Selol, Selol tamana Bekolati, ge Bekolati tamana Apiya, heliya un Beniyamina ana tonowakau. ");
INSERT INTO mpx_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kisi natuna tauina etega i gan alana Sol, i hebubun ana awa i waisi hot Isileli gegewel gamwaliyaa, ge i yapu alonau gegewel hi sikala ya te vevelana elana. ");
INSERT INTO mpx_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","He Kisi wana donki enuna hi tatayaomal, yaka i baek natuna Sol elana i ba, “Totuwalali etega u ahe alom nuku na donki nuku loyaagil.” ");
INSERT INTO mpx_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Yaka Sol totuwalali etega i ahe alona, inoke hi nosolaa un Ipileimi wali labi oyana gaganina gamwanaa ge labi Salisa, yaa nige hi pwapwawal. Yaka hi novevehe al labi Salim ge abwe Beniyamina wali labi gamwana gegewena hi loyaan, yaa nige hi pwapwawal. ");
INSERT INTO mpx_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Sauga hi na hi vin labi Sup, yaka Sol i baek totuwalali elana i ba, “U nem ta sikal. Ebo nigeya, nasi nam nige al ni nuwanuwatu donki kaiweliya, yaa ni nuwanuwatu te kila kaiwela.” ");
INSERT INTO mpx_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Anana totuwalali i lahe i ba, “Besi ga! Palopita etegana iyahe te panuwa ya elana, ana awatauwan i bwata gamagalau elal ge bugul gegewena ni baunanagil i masal i ola wana baaba. Ta na ta kite. Tabam bosowaina kamwasa ni ba lounan yaka ta noek.” ");
INSERT INTO mpx_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Yaka Sol i baek totuwalali elana i ba, “Ebo ta nok, hauna bugul ta muloluan elana? Aanan bolo ta loke wala nabwaa iyaka i mowasi. He binimala hauna ta pek elana?” ");
INSERT INTO mpx_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Anana totuwalali i lahe i ba, “Mani silba kekeisi iyahe elau. Na pek elana, inoke kamwasa ni ba lounan yaka ta noek.” ");
INSERT INTO mpx_vpl VALUES ("S19_9","010_9_9","1SA","9","9","11","Anana Sol i lahe i ba, “I waisi, he ta egon.” Inoke hi nawanawa nihi nok panuwa toto palopita i miminaa. Sauga hi haha oya elana panuwa kaiwena, yaka galokau enuna hi pwawal hi tagilem to hi nana wewel hi wawagi. Inoke hi nel elal hi ba, “Tokita pahuwala iyoho?” (He houhouwena elana, ebo gamagal nuwaliya bugul etega nihi atena Yehoba elana, yaka nihi ba, “Ta na tokita pahuwala ta kite,” kaiwena saugena o elana palopita alaliya hi tutun ola to.) ");
INSERT INTO mpx_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Analiya hi lahe hi ba, “E, abwe i vin te lan e, kaiwena lan ya bwasumu hi powonagil oyaa abapowona ge ananina hi giginol. Iyahe tei maninimiwa, he etimwawa nuku nok. ");
INSERT INTO mpx_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Sauga nuku tuk panuwaa, yaka nasi nuku pwawa, mulaa abwe ni na ni ha oyaa abapowona ge alonau alonau nihi anan. He bolo hi awanunil nigeya ga nihi aanan ana siga iya ni nok ge powon enowana ni ba muloluan, yaka abwe nihi aanan. He etimwawa nuku nok, kaiwena sauga ya bosowaina te nuku pwawa.” ");
INSERT INTO mpx_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Inoke hi na hi ha panuwaa. Sauga hi tuktuk panuwa ana abatuktuka, yaka Samuwela hi pwawa i nenem elal, i nanawa abapowon kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","He nolu Yehoba iyaka i baaba haba Samuwela elana i ba, ");
INSERT INTO mpx_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Tau etega i neem Beniyamina wali labiya, bwaligumwa ni ola te sauga e, na patuna ni nowa elam. Enonu nu hol kokowanaa iya ni tabwa no gamagalau Isileli wali tohouwa, inoke ni pwamwalil Pilistiya nimaliyaa. He wali kahin ya hago ge wali lomwan ya kite.” ");
INSERT INTO mpx_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Samuwela matana i nok Sol i kite, yaka Yehoba i baek elana i ba, “Tau toto o iya kaiwena te nolu ya baaba elam. Iya no gamagalau ni logugui-agil.” ");
INSERT INTO mpx_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Sol i noha Samuwela elana panuwa ana abatuktuka, yaka i nel i ba, “Tab bosowaina no wasa nu pem tokita pahuwala wana limi ga?” ");
INSERT INTO mpx_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Anana Samuwela i lahe i ba, “He nau te tokita pahuwala. Ku nohouwa maniniwa ta na oyaa abapowona, kaiwena lan ebe alowau komiu ta aanan toyawa. Inoke bwaligumwa mweluluga bugul gegewena toto nuwam nu atena na pwamwananal elam, yaka abwe na patunamiu nuku egon. ");
INSERT INTO mpx_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Yaa donki bolo hi tatayaomal ge lan eton iyaka i mowasi, bahi kaiweliya nuku nuwanuwatu, iyaka hi pwawal. Yaa henala ge boda Isileli gegewel nunuwaliya hot? He iyai te owa ge tamwam ana heniheni.” ");
INSERT INTO mpx_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Anana Sol i lahe i ba, “Ga i ola ge baaba o u baunan eliyau? Nau o un Beniyamina, iya i kekeisi hot Isileli ala un gegewel gamwaliyaa. Ge ama tini nige alana i bwabwata un Beniyamina elana.” ");
INSERT INTO mpx_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Inoke hi na hi ha oyaa abapowona. Yaka Samuwela Sol ge wana totuwalali i en tukagil limi gamwanaa, ge i pamisiyoil gamagalau alaliya bwabwatana wali yau elana, yaa bolo hi awanunil ali gewi teti (30) wali yau i getoga. ");
INSERT INTO mpx_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Yaka Samuwela i baek toligaliga elana i ba, “Bwasumu bunumwina waiwaisana toto ya pewa ge ya ba nu teli getogaan, u pwatanim.” ");
INSERT INTO mpx_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Inoke toligaliga bwasumu nagilina i ahe i pwatanik i na i teli Sol manininaa. Yaka Samuwela i baek Sol elana i ba, “Toto e, owa kaiwem. U ahe u an. He sauga ya baek toligaliga elana, ‘Gamagalau iyaka ya awanunil nihi nem,’ yaka ya ba toto e i teli getogaan owa kaiwem an toyawa ya kaiwena.” Inoke lan o Sol alona ge Samuwela hi anan. ");
INSERT INTO mpx_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Sauga hi aanan haba, yaka abapowon hi eguluwan ge hi na hi lau panuwaa. Inoke Samuwela Sol i en heyan wana limi pwatanaa toto hi tal paabwab, yaka alona hi liwaliwan. ");
INSERT INTO mpx_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Lan i gan hi lut, inoke Samuwela i yoga ha Sol elana i ba, “U lovivina, yaka ta na na en telewa kamwasaa.” Inoke Sol i lovivina, yaka aloliya Sol wana totuwalali hi na hi tagil kamwasaa. ");
INSERT INTO mpx_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Sauga hi na hi vin panuwa ana sigaa, yaka Samuwela i baek Sol elana i ba, “U ba wam totuwalali elana ni nohouwa awolaa.” Totuwalali i egon, yaka Samuwela i ba vevehe al Sol elana i ola, “U mina ga alou owa sauga kekeisi, yaka Yabowaine wana baaba na baunaniwa nu hago.” ");
INSERT INTO mpx_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Inoke Samuwela olibe enonona ana patuna etega i ahe ge i hol Sol kokowanaa, yaka i nalo ge i baek elana i ba, “Enonu ya hol kokowamwa kaiwena Yehoba i hilewa nu tabwa iya wana gamagalau hot Isileli ali tonul. ");
INSERT INTO mpx_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Sauga nu eguluwagau ge nu nawanawa, yaka bolau labui nu pwawal tubula Letiyeli ana salai gegelinaa panuwa Selsa elana, un Beniyamina wali labi ana sigaa. Yaka wam wasa nihi pewa nihi ba, ‘Donki bolo kaiweliya ku loyaloya iyaka hi pwawal. He tamwam iyaka nige al i nuwanuwatu kaiweliya, yaa komiu kaiwemiu te i nuwanuwatu. Iya iyoho i nelnel i ba, “Ga na ola ge natu na pwawa?” ’ ");
INSERT INTO mpx_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","“Yaka abwe nu novevehe al nu na nu vin panuwa Tabo abwakilina bwabwalena elana, yaka bolau eton al nu pwawal hi nanawa panuwa Betel kaiwena ge nihi tapwalolo Yabowaine elana. Etegana goti natunau eton ni kalivail, eluwana beleid eton ni noahel, ge etonina oine ana patuna etega goti kunisina elana hi ginoliya ni kalivai. ");
INSERT INTO mpx_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Yaka alomwau nuku pemumulolu ge beleid eluwa nihi pewa ginebi wam yaliyaya nu ahe. ");
INSERT INTO mpx_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","“Toto o enaa, abwe nu na Gibeya, iya Yabowaine wana oya. He labi o Pilistiya wali tolohaveyan wali abaholavi etega iyoho to. Sauga nu novin panuwa gegelinaa, yaka palopitau ali boda nu pwawal hi loem oyaa abapowona. Enuna nihi houwa egalagalavenu hapi, tambalin ge gita nihi lolol ge igo nihi yuyu, yaka gegewel Yehoba Yayaluwana wana gasisi elana nihi wonawona ge nihi sagasaga. ");
INSERT INTO mpx_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Inoke sauga o Yehoba Yayaluwana ni lau eliyam ge ni pagetoga-agiwa, yaka alomwau nuku wonawona ge nuku sagasaga. ");
INSERT INTO mpx_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","He sauga ebo etotohi bolo ya baunagil nihi tabwa tunahot, yaka hauna u nuwatuan i waisi tage nu ginol, nu ginol ya, kaiwena Yabowaine ni miminaa eliyam. ");
INSERT INTO mpx_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","“He nu houwa maniniwa nu na nu lau panuwa Gilgal. Nu matamatan lan ana gewi seben, yaka abwe na nowa, inoke bwasumu na powonan pwabwalige, ge heliheliyam powonina na ginol. Yaka wam wasa na pewa hauna abwe nu ginol.” ");
INSERT INTO mpx_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Sauga Sol i mipil ge ena i pek Samuwela elana ni eguluwai, yaka Yabowaine Sol yawalina i pil pavavaluna, ge etotohi gegewena bolo Samuwela i baunan, lan o hi tabwa tunahot. ");
INSERT INTO mpx_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","He sauga Sol ge wana totuwalali hi vin panuwa Gibeya, yaka palopitau ali boda hi pwawal. Inoke Yabowaine Yayaluwana wana gasisi i lau Sol elana, yaka alonau hi wonawona ge hi sagasaga. ");
INSERT INTO mpx_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Gamagalau bolo Sol hi atena, wana ginol o hi kite inoke hi penelnel-agil hi ba, “Hauna gun i gan Kisi natuna Sol elana? Bi ola iya al palopita avaliya etega?” ");
INSERT INTO mpx_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Tau etega i miminaa to, analiya i lahe i ba, “He palopitau ya, henala tamaliya?” Yaka heliya wali baaba etega hi babaa ola hiwe, “Bi ola Sol iya al palopita avaliya etega.” ");
INSERT INTO mpx_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","He Sol i wonawona ge i sagasaga haba, yaka abwe i na i ha oyaa abapowona. ");
INSERT INTO mpx_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Sauga etega Sol tamana talina i nel Sol alona ge wana totuwalali elal i ba, “Ga ku nanawaa?” Anana Sol i lahe i ba, “Ha na donki bolo hi tatayaomal ha loyaagil, yaa nige ha pwapwawal, yaka ha na Samuwela elana.” ");
INSERT INTO mpx_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Inoke tau o i nel i ba, “No wasa ku pem Samuwela ga i ba ola eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Anana Sol i lahe i ba, “I baem eliyama te donki bolo hi tatayaomal iyaka hi pwawal.” Yaa nige i wawasaan te Samuwela i baek elana i ba, “Owa abwe nu tabwa Isileli wali kin.” ");
INSERT INTO mpx_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Sauga etega al Samuwela boda Isileli i yoga gogonil hi na panuwa Mispa ge hi talmilila Yehoba awonaa. ");
INSERT INTO mpx_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Inoke i baek elal i ba, “Yehoba, Isileli wala Yabowaine, i ba ola hiwe: Ya pwamwalimiu Itipita nimaliyaa ya ahemiu ku tagilem Itipita ku nem Kenani. Ge ya pwamwalimiu abalogugui ona elal bolo wali logugui ana gasisi i paanlowagimiu. ");
INSERT INTO mpx_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Yaa bwagana ya pwamwalimiu ami pulowan ge ami nak gegewel elal, he nau wami Yabowaine iyaka ku towaagau. Inoke ku awanun elau ku ba, ‘Wama kin etega nu pem ge ni logugui-agima.’ He ami un ge un, pwahiya ge pwahiya, nuku nem nuku talmilil nau Yehoba maniniwa.” ");
INSERT INTO mpx_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Sauga Samuwela i ba Isileli un ge un hi notagil, yaka Yehoba un Beniyamina i hile. ");
INSERT INTO mpx_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Yaka Samuwela i ba un Beniyamina pwahiya ge pwahiya hi notagil, yaka Yehoba pwahiya Matili i hile. Yaka abwe pwahiya o gamwanaa Yehoba Sol i hile, iya Kisi natuna. Yaa hi loyaloya nige hi pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Inoke hi nel Yehoba elana hi ba, “Tab Sol i nem e?” Wali nel i lahe i ba, “E, iyaka i nem, iya iyoho i bunsumi bugubugul gamwaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Yaka hi patalelu hi na hi ahe tagilan ge hi en pwatanik i talmilil boda gamwaliyaa. Iya i yapu hot alonau gegewel hi sikala ya te vevelana elana. ");
INSERT INTO mpx_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Yaka Samuwela i baek Isileli gegewel elal i ba, “Ku kite! Tau toto e iya te Yehoba i hile i tabwa wami kin. He nige etega al i gagan boda Isileli gamwalaa i oola iya.” Yaka gegewel hi yoga hi ba, “Wama kin yawalina ni yapu!” ");
INSERT INTO mpx_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Yaka Samuwela kin ali logugui i ba pwamwananal gamagalau elal. Inoke i leli tukan buki etega elana ge i na i teli Yehoba manininaa. Yaka abwe gamagalau i patunal hi sikal wali panuwa tomaha ona elal. ");
INSERT INTO mpx_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","He Sol al ge i na wana panuwaa Gibeya, alonau bolau gasigasisel enuna bolo ateliya Yabowaine i pihikan nihi tabwa Sol ana tototoulil. ");
INSERT INTO mpx_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Yaa gamagalau sisigal enuna hi kite lowan inoke hi ba, “Tau ya bosowaina ya ni pwamwalila?” Yaka nige mulolu etega hi pwapwatanik elana. Yaa Sol nige baaba etega i babaunan kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Yaka abwe sauga etega boda Amoni wali kin Nahas wana tolohaveyan i ahel, hi na Isileli panuwana Yabesi, iyoho labi Giliyad elana, ge hi mipainan. Inoke Yabesi bolauiliyau gegewel hi na hi baek kin Nahas elana hi ba, “Ta pebabateli-agila alomeyau komiu ta mibubun, yaka naha minaa wam logugui gabulanaa.” ");
INSERT INTO mpx_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Yaa analiya kin Nahas i lahe i ba, “Nigeya! Iyai te ebo gegewemiu nuku talamwagimiu matamiu labena awomiwa na bwana yohil, yaka abwe alomeyau komiu ta pebabateli-agila. Na ginol ola o, yaka Isileli gegewemiu nuku puluwawi.” ");
INSERT INTO mpx_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Yaka Yabesi wali tonowakau hi awanun elana hi ba, “Lan ana gewi seben nu pem ga, inoke wama elopapatuna naha patunal nihi na Isileli gamwana gegewena elal wali wasa nihi pek. Ebo nige etega ni nenem ni lalabema, yaka abwe naha talamwagima eliyam wam nuwatu nu ginol.” Inoke wali awanun Nahas i talamwi. ");
INSERT INTO mpx_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Sauga elopapatuna hi novin Gibeya, Sol wana panuwaa, ge Nahas wana logugui hi wasaan, inoke gamagalau hi lokahin nabi analiya i bwata. ");
INSERT INTO mpx_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","He sauga o elana, Sol i neem wana eyowaa i sisikal panuwaa, alonau ge wana bulumwakau bolo i patuwalali-agil wana eyowaa. Inoke kahin bwabwatana i hago, yaka i nel gamagalau enuna elal i ba, “Hauna gun i gan gamagalau elal? Hi bwe ge hi lolokahin?” Yaka wana wasa hi pek i ola to hauna Yabesi wali elopapatuna hi wasaan elal. ");
INSERT INTO mpx_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Sauga wali baaba i hago, yaka Yabowaine Yayaluwana wana gasisi i lau elana ge i huga nabi kin Nahas kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Yaka bulumwakau labui i ahel i tagapaaligal ge tuwaliya i gotomwatomwa-agil, inoke i pek elopapatuna elal ge i ba hi kalivail pwapwati Isileli gamwana gegewena elal, ge hi ba, “Henala nige ni nonouliulil Sol ge Samuwela eliyaa ge ni hahaveyan boda Amoni elal, he wana bulumwakau nihi gotomwatomwa-agil ni ola hiwe!” Sauga gamagalau baaba o hi hago, inoke Yehoba i palovakun-agil kaiwena wana gasisi hi kiteya Sol elana. Yaka bolau gegewel hi boda pamaisena ge hi tagil toyawa nige etega i miminaa panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Inoke Sol i pamigogoil panuwa Bisek elana ge i pwawa bolau bolo hi neem Isileli ali gewi tili handeled tausan (300,000), ge bolo hi neem Yuda ali gewi teti tausan (30,000). ");
INSERT INTO mpx_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Inoke hi baek elopapatuna bolo hi neem panuwa Yabesi elana hi ba, “Nuku na nuku baek alomiyau eliyalil te bwaligumwa mulaa abwe alalati bwagatau, ama naha pwamwalimiu.” Sauga elopapatuna hi sikal hi na Yabesi wali wasa hi pek, inoke hi yaliyaya nabi. ");
INSERT INTO mpx_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Yaa hi baek Amoni elal hi ba, “Bwaligumwa naha talamwagima eliyamiu, yaka hauna ku nuwatuan nuku ginol ya.” ");
INSERT INTO mpx_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Sol wana tolohaveyan i walel boda eton, yaka mweluluga kekeisi hot nigeya ga didiga i totomwa te hi vin, hi na hi tuk Amoni wali abaholaviya ge hi mimi lololil ana siga alalati bwagatau. Bolo hi mwal, hi lou waliwali, maisena ge maisena tomaha hi nonoek. ");
INSERT INTO mpx_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Haveyan enaa, yaka Isileli wali tolohaveyan hi nel Samuwela elana hi ba, “Bolau bolo hi ba nige nuwaliya Sol ni tabwa kin heliya ga? U ahel nihi nem eliyama yaka naha tagapaaligal.” ");
INSERT INTO mpx_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Yaa Sol i baek elal i ba, “Nige gamagal etega ta tatagapaaliga, kaiwena lan ebe Yehoba Isileli i pwamwalila ala topihigelgel elal.” ");
INSERT INTO mpx_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Yaka Samuwela i baek gamagalau elal i ba, “Ta na panuwa Gilgal ge ta patunahot te Sol iya wala kin.” ");
INSERT INTO mpx_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Inoke gegewel hi nok, yaka Yehoba manininaa Sol hi patunahot iya i kin. Inoke heliheliyam powonina hi ginol Yehoba manininaa, yaka Sol alonau ge gamagalau hi anan toyawa ge hi yaliyaliyaya. ");
INSERT INTO mpx_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Inoke Samuwela i baek Isileli gegewel elal i ba, “Iyaka ya ginol i ola wami awanun eliyau ge gamagal etega ya teli iya wami kin. ");
INSERT INTO mpx_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","He wami kin o sauga ya i houwaagimiu. Nau iyaka ya liki kaunu i puwi, he natuwau bolau heliya iyahe alomiyau. I telipunaa no sauga heval ana siga lan ebe nau ya houwaagimiu. ");
INSERT INTO mpx_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","He sauga ya ya talmilil awomiwa. Inoke ebo bugul etega ya ginol panak, yaka nuku ba pamasal Yehoba ge wana hilihili kin mataliyaa. Tab gamagal etega wana bulumwakau ya ahe? O, age etega wana donki ya ahe? Tab gamagal etega ya kakawe ge wana gogomwau ya ahe? O, age etega ana hehegan ya apapanak-an? Tab kakawi manina ya ahe gamagal etega elana inoke nige ana lahi ya giginol? Ebo bugul bolo o etega ya ginol, he no wasa nuku pem yaka na abubun.” ");
INSERT INTO mpx_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Anana hi lahe hi ba, “Nige u kakakawema ge wama gogomwau u aahe, o ebo ama hehegan u aapapanak-an. Ge nige kakawi manina u aahe gamagal etega elana.” ");
INSERT INTO mpx_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Inoke Samuwela i baek elal i ba, “Yehoba alona ge wana hilihili kin wami baaba o iyaka lan ebe hi hago, inoke nihi patunahot te nige no ginol nanakina etega ku pwapwawa.” Yaka anana hi lahe hi ba, “E. I ola. Yehoba wama baaba o iyaka i hago.” ");
INSERT INTO mpx_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Inoke Samuwela i ba vevehe al gamagalau elal i ba, “Yehoba te Mosese ge Eloni i hilel. Iya te tubulau i ahel hi tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","He nuku talmilil Yehoba matanaa, yaka ginol bwabwatal bolo i ginolil tubulau kaiweliya ge komiu kaiwemiu na liwanagil. Inoke eliyana wami gegi na pamasal eliyamiu, kaiwena nuwamiu kin. ");
INSERT INTO mpx_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","“He Yakobo alonau natunau ge tubunau hi na Itipita. Baliman hi gewi i mowasi abwe Itipita boda Isileli hi papalomwan-agil, yaka labe kaiwena hi yoga ha Yehoba elana inoke Mosese ge Eloni i patunal elal. Yaka tubulau hi ahel hi tagilem Itipita ge hi nulil hi nem hi miminaa labi ya elana. ");
INSERT INTO mpx_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","“Yaa Yehoba, iya tubulau wali Yabowaine, hi nuluwan. Inoke sauga ali topihigelgel hi nem hi lohaveyan elal, yaka i tatalamwagil nimaliyaa. Ali topihigelgel etegana Sisila, panuwa Heisol wali tolohaveyan wali tohouwa, etegana boda Pilistiya, ge etegana labi Mowabi wali kin. ");
INSERT INTO mpx_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Inoke sauga maisena ge maisena tubulau labe kaiwena hi yoyoga ha Yehoba elana hi babaa, ‘Ama iyaka ha gegi, kaiwena am en ha pewa ha kukululuek yabowaine gogoginol Bal ge Astolet elal. He nu pwamwalima ama topihigelgel nimaliyaa, yaka naha kululu elam.’ ");
INSERT INTO mpx_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Yaka sauga maisena ge maisena Yehoba gamagal etega i papatuna, etegana Gidiyon, etegana Belaki, etegana Yepta, ge etegana nau Samuwela. Inoke Yehoba i pwamwalimiu ami topihigelgel nimaliyaa ge ku mibubun. ");
INSERT INTO mpx_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“Yaa sauga Nahas, Amoli wali kin, alonau wana tolohaveyan hi nenem nihi lohaveyan eliyamiu, yaka bwagana Yehoba wami Yabowaine iya wami kin, he ku baem eliyau ku ba, ‘Nigeya! Nuwama wama kin ni gan ge ni logugui-agima.’ ");
INSERT INTO mpx_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","He kin toto ku hile iya hiwe. Ku awanuni, he iya Yehoba iyaka i teli wami kin ge ni logugui-agimiu. ");
INSERT INTO mpx_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Ebo Yehoba nuku lovakunan yaka nuku tapwalolo elana, wana baaba nuku hago ge nige wana logugui nuku totowani, ge ebo alomiu wami kin Yehoba wana kamwasa nuku toulil, inoke nuku mibubun. ");
INSERT INTO mpx_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Yaa ebo nige wana baaba nuku hahago ge ebo wana logugui nuku towani, yaka wana gasisi elana ni apapanak-agimiu ni ola valila tubulau i apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","“He nuku talmilil, yaka ginol bwabwatana etega Yehoba i giginol matamiwa nuku kite ni ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Sauga ya witi tomwatomwa ana sauga. Ge ku atena kila wala labiya nige kehe ana sauga i oola. Yaa nau na awanun Yehoba elana panuwa ni pagulumwawa ge ni lokehe. Ebo ni ginol ola o, yaka abwe nuku atena te sauga ku awanun wami kin ni gan, he iyaka ku gegi Yehoba matanaa.” ");
INSERT INTO mpx_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Yaka Samuwela i awanun Yehoba elana, inoke lan o panuwa i pagulumwawa ge i lokehe. Inoke gamagalau gegewel Yehoba ge Samuwela hi lovakunagil. ");
INSERT INTO mpx_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Yaka gegewel hi baek Samuwela elana hi ba, “Nu awanun Yehoba wam Yabowaine elana ama wam totuwalali kaiwema yaka bahi naha aaliga. Kaiwena wama gegi ona iyaka ha paetulan te ha awanun wama kin ni gan.” ");
INSERT INTO mpx_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Analiya Samuwela i lahe i ba, “Bahi lovakun! Tunahot gegi bolo ya ku ginolil. Yaa bahi al Yehoba ana en nuku pepek, nuku kululu elana alona ge atemiu bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Bahi Yehoba nuku eeguluwan ge nuku kukululuek yabowaine gogoginol elal. Heliya bugul bwagabwaga hot, nige bugul waiwaisana etega nihi giginol kaiwemiu ge nige nihi pwapwamwalimiu. ");
INSERT INTO mpx_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Yehoba wana yaliyaya elana i hilemiu iya wana gamagalau. Inoke komiu nige ni teteli yohimiu, kaiwena ebo ni ginol ola, he totona alana ni papuluwawi-an to. ");
INSERT INTO mpx_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Ge nau nige na babakuhu awaawanun kaiwemiu, kaiwena ebo na bakuhu, he iyaka ya gegi Yehoba elana to. I ola al, kamwasa waiwaisana ge sasapona na pankitemiu ge eliyana nuku nanawaa. ");
INSERT INTO mpx_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Yehoba wana ginol bwabwatal bolo i ginolil kaiwemiu nuku nuwatuagil. Inoke nuku lovakunan ge nuku kululu tunahot elana ginebi ge atemiu bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Yaa ebo gegi nuku mimi awaawaginol, yaka alomiu wami kin Yehoba ni ahek yohimiu labi ya elana.” ");
INSERT INTO mpx_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Sol wana baliman teti (30) te i tabwa kin, yaka Isileli i logugui-agil baliman ana gewi poti tu (42). ");
INSERT INTO mpx_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Sauga etegana bolau ali gewi tausan eton (3,000) i hilel Isileli gamwaliyaa hi tabwa wana tolohaveyan. Tausan eluwa (2,000) i ahel alonau hi miminaa panuwa Mikmas ge Betel ana labi oyana gaganina elana, ge tausan maisena (1,000) i patunal aloliya natuna Diyontan hi miminaa panuwa Gibeya un Beniyamina wali labiya. Yaka bolo i hilel pasogol i patunal hi sikal hi na wali panuwa ona elal. ");
INSERT INTO mpx_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Diyontan alonau wana tolohaveyan hi tuk Pilistiya wali abaholavi toto i minaa Gibeya aloliyau hi lohaveyan ge hi pakokovel. Yaka wali ginol wasana etimwawa i lelu Pilistiya gamwaliyaa. Inoke Sol elopapatuna i patunal hi na Isileli labi gegewena bwagigi hi yuyu, ge hi ba, “Hibilu, nuku laegan!” ");
INSERT INTO mpx_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Yaka Isileli gegewel wali wasa hi pek hi ba, “Sol iyaka i tuk Pilistiya wali abaholavi toto i minaa Gibeya ge i pakokovel, inoke Pilistiya hi huga nabi kila Isileli elala.” Ge hi ba al bolau nihi migogo Sol elana panuwa Gilgal. Inoke hi ginol ola. ");
INSERT INTO mpx_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","He Pilistiya al wali tolohaveyan hi bugul papahel ge avaliyau Isileli nihi lohaveyan. Wali waga momomol ali gewi tausan eton (3,000), tolohaveyan bolo hi gaiheya elal ali gewi sikis tausan (6,000) ge bolo hi nawaa aeliyaa ali gewi i ola gilesa talbwasiya. Inoke hi na hi holaviya panuwa Mikmas, Bet-Aben labena nati. ");
INSERT INTO mpx_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Isileli hi kite te ali pulowan i bwata, kaiwena Pilistiya hi gewi nabi, heliya nige hi gegewi. Inoke enuna hi na hi bunsumi pat golinaa, ebwakil ge pat gamwaliyaa, bilibili golinaa ge wewel kenken elal. ");
INSERT INTO mpx_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Ge enuna wewel Yolidani hi kalapanet-an hi na un Gada wali labiya ge labi Giliyad. Yaa Sol i minaa panuwa Gilgal, yaka tolohaveyan gegewel bolo alonau, lovakun kaiwena hi ginuginu. ");
INSERT INTO mpx_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Lan seben i matamatan Samuwela wana sauga vin kaiwena, yaa Samuwela nige i nenem. Inoke tolohaveyan hi egoegon ge Sol hi eguluwan. ");
INSERT INTO mpx_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Yaka i ba, “Bwasumu toto ta popowon pwabwalige ge bolo ta popowon-agil heliheliyam powonina ku pwatanim eliyau.” Hi ginol ola, inoke totona bwasumu i powonan pwabwalige Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","He Sol powon o abwe i ginol haba, yaka Samuwela i vin. Inoke Sol i na i kite ge alona hi mulolu. ");
INSERT INTO mpx_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Yaka Samuwela i nel elana i ba, “Hauna gun u ginol e?” Anana i lahe i ba, “Ya kite tolohaveyan iyaka hi egoegon ge hi eguluwagau, ge owa nige u vivin wam sauga vin elana. I ola al, ya atena Pilistiya wali tolohaveyan iyaka hi migogo panuwa Mikmas, ");
INSERT INTO mpx_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","yaka ya ba, ‘Nasi nihi loem te Gilgal ge nihi haveyan eliyama, yaa nigeya ga ya aawanun Yehoba elana labe kaiwena.’ Inoke o puwapuwala ya te bwasumu ya powonan pwabwalige Yehoba elana, kaiwena nige bugul etega al bosowaiu ge na ginol.” ");
INSERT INTO mpx_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Yaka Samuwela i baek elana i ba, “U sigasiga hot! Logugui toto Yehoba wala Yabowaine i pewa nige u hehenapu-an. Binimala nu henapuan, inoke wam abalogugui ni pagasisi ge tubutubumwau nihi tologugui Isileli elana sauga gegewena nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Yaa nasi nige wam abalogugui ni mimihot. He kaiwena Yehoba wana logugui nige u hehenapu-an, inoke tunahot Yehoba tau toto iya nunuwana, abwe ni hile ge ni teli wana gamagalau wali tohouwa.” ");
INSERT INTO mpx_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Inoke abwe Samuwela panuwa Gilgal i eguluwan ge i nawanawa. Yaka Sol alonau wana tolohaveyan hi egon nihi na labi toto Pilistiya wali tolohaveyan hi miminaa. Inoke Gilgal hi eguluwan hi na Gibeya un Beniyamina wali labiya. Yaka tolohaveyan bolo hi miminaa eliyana i vasilel, ali gewi sikis handeled (600). ");
INSERT INTO mpx_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Inoke Sol ge natuna Diyontan, avaliyau ge wali tolohaveyan, hi holaviya Gibeya un Beniyamina wali labiya. Yaa Pilistiya wali tolohaveyan hi holaviya panuwa Mikmas. ");
INSERT INTO mpx_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Pilistiya pwahin eton hi papatunal hi tatagila wali abaholaviya hi nana Isileli wali panuwa tomaha elal, yaka aliya ge wali bugubugul hi kakaluoel. Pwahin etegana hi tatagilik hi nonoek kamwasa toto i na Opela labi Suwal, ");
INSERT INTO mpx_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","pwahin eluwana hi lolok hi nonoek kamwasa toto i na Bet-Holon, ge pwahin etonina hi nonoek kamwasa toto i na manaoyaoya toto awona i noek Seboim Opopwina ge labi kekevana elana. ");
INSERT INTO mpx_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","He saugena o, nige gamagal etega i gagan Isileli wali labi gamwanaa toto bosowaina aiyan ni tuwalali-an. Pilistiya nige hi tatalam tuwalali ololana o Isileli nihi ginol, kaiwena hi ba, “Bahi Hibilu wali haveyan kilepana ge gau nihi giginolil!” ");
INSERT INTO mpx_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","(Inoke ebo Isileli wali egiyagiyal, matok, kenumu o ebo witi ana etomwatomwa mataliya ni but, nihi noahel nihi lau Pilistiya wali labiya ge nihi pek nihi vagalel. ");
INSERT INTO mpx_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Pilistiya wali mola hi teli heyan. Ebo egiyagiyal o matok mataliya nihi vagale, molana mani silba ana bwata eit glem. Ebo pok bwabwatana o kenumu mataliya nihi vagale o ebo bulumakau ali elopetaki nihi abubun, molana mani silba ana bwata glem esopali.) ");
INSERT INTO mpx_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Inoke lohaveyan ana lan elana, Isileli wali tolohaveyan gegewel nige wali haveyan kilepana ge gau i gagan, iyai te Sol ge natuna Diyontan. ");
INSERT INTO mpx_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Pilistiya wali tolohaveyan hi na hi holaviya opop pwatanaa toto Mikmas ana labiya. He opop o iya kamwasa abanosola etega. ");
INSERT INTO mpx_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Lan etega Sol natuna Diyontan i baek heval toto wana elohaveyan ana tokaval elana i ba, “U nem ta egon opop ta nopanetan ta na Pilistiya wali abaholaviya.” Yaa nige tamana wana wasa i pepek. ");
INSERT INTO mpx_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Saugena o Sol i miminaa abwakil pomaglenet gabulanaa awan Miglon elana panuwa Gibeya tolinaa. Tolohaveyan bolo alonau ali gewi sikis handeled (600). ");
INSERT INTO mpx_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","He topowon Ahaidiya iyoho gamwaliyaa holahola ipod i galoi. Ahaidiya iya Ikabod talina Ahitub natuna. Ahitub iya Pinehas natuna, ge Pinehas iya Ilai natuna, Ilai iya valila i topowon Yehoba elana panuwa Sailo. Yaa nige gamagal etega i aatena te Diyontan iyaka i egon. ");
INSERT INTO mpx_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Opop toto Diyontan nuwana ni nopanetan ni na Pilistiya wali abaholaviya bebena labui hi lebwalebwal. Lebwalebwal etega alana Bosese ge eluwana alana Sene. ");
INSERT INTO mpx_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Etega i minek opop labena aluwabwa panuwa Mikmas gegelinaa, ge etega i minek labena yavanaa panuwa Gibeya gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Diyontan i baek wana elohaveyan ana tokaval elana i ba, “U nem ta egon opop ta nopanetan ta na Pilistiya wali abaholaviya, heliya nige Yehoba hi aatena ge nige gotomwa yoho paganina hi aahe. Tabam nasi Yehoba bugul etega ni ginol kaiwela. Bwagana ebo ta gewi o ebo nige ta gegewi, nige bugul etega bosowaina Yehoba ni kaus ge tage nige ni lalabela ge ta papakokovel.” ");
INSERT INTO mpx_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Yaka anana i lahe i ba, “Hauna u nuwatuan, he nu ginol ya! Ta nowa! Ya talamwagau alou owa ya!” ");
INSERT INTO mpx_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Inoke Diyontan i ba, “I waisi! Ta nopanet ge ta pamasalila Pilistiya nihi kitela. ");
INSERT INTO mpx_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Ebo nihi baem elala nihi ba, ‘Ku matamatana tei ana siga naha nowa eliyamiu,’ yaka ta talmilil ya abalaa. ");
INSERT INTO mpx_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Yaa ebo nihi ba, ‘Ku nem ku ha eliyama,’ inoke ta ginol ola to. Ebo ni masal ola o, he wala etotohi to Yehoba iyaka i telel nimalaa ge nasi ta pakokovel.” ");
INSERT INTO mpx_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Inoke ali toto labui hi nopanet ge hi pamasalil Pilistiya wali tolohaveyan hi kitel, yaka hi talawasi-agil hi ba, “Ku kite! Hibilu abwe hi yawal tagilem gola wali ababunsumiya.” ");
INSERT INTO mpx_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Yaka hi yoga lau Diyontan ge ana tolabe heval elal hi ba, “Ku hem elama ge naha pahenapomiu.” Inoke Diyontan i baek wana elohaveyan ana tokaval elana i ba, “Na mwena houwa, yaka nu mwena uliulil ewa, kaiwena Yehoba iyaka Pilistiya i telel Isileli nimalaa ge nasi ta pakokovel.” ");
INSERT INTO mpx_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Yaka i mwena hek lebwalebwala ge ana tolabe heval i mwena uliulil enaa. Inoke abwe Diyontan Pilistiya wali tolohaveyan enuna i tagapasogol, yaka ana tolabe heval i nouliulil ge i gopapaaliga-agil. ");
INSERT INTO mpx_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Haveyan houwan o elana Diyontan alona ge wana elohaveyan ana tokaval Pilistiya ali gewi tuwenti (20) hi lolil labi kekeisi etega gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Yaka Pilistiya wali tolohaveyan gegewel, bolo hi minaa abaholaviya ge bolo hi tagil hi kaluoyaoya, hi lovakun nabi ge nuwaliya i gewagewa. I ola al sauga o mwaniknik i masal. He Yehoba wana ginol eliyana te hi lovakun nabi. ");
INSERT INTO mpx_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Sol wana tolohaveyan, bolo i telel Pilistiya ali topekiti, heliya iyoho Gibeya un Beniyamina wali labiya, hi kite Pilistiya hi lou waliwali labi tomaha tomaha elal. ");
INSERT INTO mpx_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Yaka hi na Sol wana wasa hi pek, inoke i baek bolo alonau elal i ba, “Tolohaveyan gegewel ku yoga gogonil, yaka nuku kite henalau hi eguluwagila ge hi na hi haveyan Pilistiya elal.” Hi ginol ola o, inoke hi pwawa te Diyontan alona ge wana elohaveyan ana tokaval nige hi gagan. ");
INSERT INTO mpx_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Yaka Sol i baek topowon Ahaidiya elana i ba, “Am holahola ipod u galoi ge u nem elau.” (He saugena o Ahaidiya holahola ipod i gagaloi boda Isileli mataliyaa.) ");
INSERT INTO mpx_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Inoke topowon i nok, yaa Sol iyoho ya i baaba elana, yaka Pilistiya wali lovakun ge wali nuwa gewagewa i bwabwata nawa ge hi gan yogayoga wali abaholaviya. Inoke i ba, “Ni ola ya! Iyaka nige sauga i gagan tage Yehoba wana nuwatu ta loyaan!” ");
INSERT INTO mpx_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Inoke Sol alonau ge wana tolohaveyan hi nok hi na hi tuk haveyana. Hi pwawa te Pilistiya nuwaliya i gewagewa nabi, wali haveyan kilepana elana avaliyau hi gopapaaliga-agil. ");
INSERT INTO mpx_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Hibilu bolo valila hi na hi tubwiek Pilistiya elal ge hi na hi minaa wali abaholaviya, hi mipil hi tubwi wali pan Isileli elal, bolo avaliyau Sol ge Diyontan. ");
INSERT INTO mpx_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","I ola al, bolo valila hi lou hi na hi bunsumi un Ipileimi wali labi oyana gaganina elana, wasa hi hago te Pilistiya hi lou, inoke heliya al hi petaki Pilistiya eliyaa. ");
INSERT INTO mpx_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Yaka hi mimi hahaveyan ya hi na panuwa Bet-Aben hi eguluwan ge hi nok al. Inoke lan o elana Yehoba Isileli i pwamwalil ali topihigelgel elal. ");
INSERT INTO mpx_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Mulaa abwe hi na haveyana, Sol lopwal gasigasisena iyaka i baunanik elal i ba, “Bahi tolohaveyan etega aanan ni aan ga ana siga na lohaveyan lahi o topihigelgel elal. Ebo henala no logugui ya nige ni hehenapuan ge aanan ni an mulaa abwe sabwelu ni lobek, he Yehoba ni nuwamutan.” Inoke toto o kaiwena Isileli wali tolohaveyan nige aanan etega hi aan, yaka lan o elana galebu kaiwena tuwaliya i sasawowol. ");
INSERT INTO mpx_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Sauga heliya iyoho hi pepetaki, gegewel hi na hi nosolaa ula etega gamwanaa ge luvi ali pom hi gewi hi kitel bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Hi kite luvi i sulusulu tagil ali pom elal, yaa nige tolohaveyan etega i aahe i iim, kaiwena Sol wana lopwal gasigasisena hi lovakunan. ");
INSERT INTO mpx_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Yaa Diyontan nige tamana wana lopwal wasana i hahago. Inoke wana suki buhuna i paelu tukan luvi ana pom etega gamwanaa, yaka suina enuna i ahe i im, ge tuwana i gasisi. ");
INSERT INTO mpx_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Inoke tolohaveyan aloliya etega i baek elana i ba, “Tamwam lopwal gasigasisena i baunanim eliyama i ba, ‘Ebo lan ebe tolohaveyan etega aanan ni an, Yehoba ni nuwamutan.’ Heiya te kaiwena gegewema tuwama i sasawowol.” ");
INSERT INTO mpx_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Yaka anana Diyontan i lahe i ba, “Nam wana lopwal kila Isileli ala pulowan i pwabwata. He ku kiteyau! Luvi suina kekeisi ya im inoke tuwau i gasisi al. ");
INSERT INTO mpx_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Binimala tolohaveyan ni talamwagila aanan toto ta pwawa ala topihigelgel hi lou luwai ta an! He binimala ni ola o, bosowaila Pilistiya nihi gewi al ta lolil.” ");
INSERT INTO mpx_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Inoke lan bwabwaligena o Isileli Pilistiya hi takel ge hi mimi lololil, i telipunaa panuwa Mikmas i na ana siga Aiyalon. Yaka galebu kaiwena tuwaliya i sasawowol. ");
INSERT INTO mpx_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Inoke sauga sabwelu iyaka i lobek, etimwawa hi na bugubugul elal bolo hi oem haveyana, yaka sipi, bulumwakau ge bulumwakau natuliyau hi ahel. Inoke hi loliliya to labi o elana. Yaa nige saliyaliya hi papasulu i lolohaba ga, inoke bunum salisaliyana hi ahe hi liga hi an. ");
INSERT INTO mpx_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Yaka Sol wana wasa hi pek hi ba, “Tolohaveyan hi gegi Yehoba elana, kaiwena bunum salisaliyana hi an.” Sauga Sol wasa o i hago, inoke i ba, “Komiu toawatautau, logugui ku leke! Sauga ya pat bwabwatana etega ku pakul pwatanim eliyau.” ");
INSERT INTO mpx_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Yaka i baek elal i ba, “Ku nok tolohaveyan gamwaliyaa ge ku baek elal wali bulumwakau ge sipi nihi pwatanim te eliyau. Yaka nihi lolil pat ya pwatanaa ge saliyaliya ni lohaba, inoke abwe bunumwiliya nihi liga ge nihi an. Bahi Yehoba wana logugui nihi leleke ge bunum salisaliyana nihi aan.” Inoke bulin o tolohaveyan gegewel wali bulumwakau hi pwatanik ge hi loliliya to. ");
INSERT INTO mpx_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Inoke Sol pat o abapowon i ginoliya ge eliyana bwasumu bolo o hi powonagil Yehoba elana. He abwe pamaisena te abapowon i ginol. ");
INSERT INTO mpx_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Yaka Sol i baek wana tolohaveyan elalil i ba, “Bulin e ta na ta lau ta petaki Pilistiya eliyaa, yaka wali bugubugul ta kaluoyaoya-an ana siga lan ni gan mweluluga. He ta lolil habal, bahi etega ni mwamwal.” Anana hi lahe hi ba, “He nu ginol ni ola wam nuwatu.” Yaa topowon Ahaidiya i ba, “Yabowaine wana nuwatu ta loyaan ga.” ");
INSERT INTO mpx_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Inoke Sol Yabowaine i neli i ola hiwe: “Na lopetaki Pilistiya eliyaa o ebo bahiwa? Tab nu telel nimameya ge naha pakokovel?” Yaa bulin o elana Yabowaine nige Sol wana nel i lalahe. ");
INSERT INTO mpx_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Yaka Sol tolohaveyan wali tohouwa gegewel i yogaagil ge i ba, “Ku nem ta loya henala gegi i ginol lan ebe ge hauna wana gegi. ");
INSERT INTO mpx_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Ya papasila Yehoba yawalina gaganina alanaa, iya Isileli wala Topwamwal, henala ta pwawa gegi i ginol, bwagana ebo natu Diyontan, nasi ni aliga.” Yaa nige gamagal etega anana i lalahe. ");
INSERT INTO mpx_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Inoke Sol i baek tolohaveyan elal i ba, “Komiu nuku talmililek huwo, nau ge natu Diyontan naha talmililem hiwe.” Yaka anana hi lahe hi ba, “He nu ginol ni ola wam nuwatu.” ");
INSERT INTO mpx_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Yaka Sol i baek Yehoba, Isileli wali Yabowaine elana i ba, “Yehoba, hauna kaiwena ge bulin ebe nige no nel u lalahe? Ebo nak puna i minaa nau ge Diyontan elama, he nu pamasal pat Ulim elana, yaa ebo i minaa tolohaveyan elal, he nu pamasal pat Tamim elana.” Inoke topowon pat bolo o i patuwalali ge i pwawa nak i minaa Sol ge Diyontan elal, nige i miminaa tolohaveyan elal. ");
INSERT INTO mpx_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Yaka Sol i ba, “Pat u patuwalali al nau ge natu Diyontan eliyama.” Inoke i ginol ola ge i pwawa te Diyontan iya gegi puna. ");
INSERT INTO mpx_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Sol i baek Diyontan elana i ba, “No wasa u pem hauna u ginol.” Anana i lahe i ba, “He no suki buhuna ya paelu tukan luvi ana pom etega gamwanaa, yaka suina kekeisi ya im bose. He nau hiwe ya talam na aliga.” ");
INSERT INTO mpx_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Yaka Sol i ba, “E natu, tunahot nu aliga. Ebo nigeya, ya awanun Yehoba lahi pupulowanina hot ni ginol elau.” ");
INSERT INTO mpx_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Yaa tolohaveyan hi baek Sol elana hi ba, “Diyontan iya te kila Isileli i pwamwalila! Inoke nasi nu ba ni aliga? Bahiwa! Ha papasila Yehoba yawalina gaganina alanaa, nige tuwana gabomwina kekeisi etega ni nanak. Kaiwena lan ebe Yehoba i labe ge ginol bwabwatana i ginol.” Yaka Diyontan hi sokal nige i aaliga. ");
INSERT INTO mpx_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Inoke Sol i bakuhu nige al Pilistiya i tatakel, ge Pilistiya hi sikalan wali labiya. ");
INSERT INTO mpx_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Sauga Sol i tabwa Isileli wali kin ge iyaka i mibubun abamina o eliyana, yaka i lohaveyan Isileli ali topihigelgel, bolo hi mipainagil labi tomaha ge tomaha elal: Mowabi, Amoni, Idom, Soba ana kin ona avaliyau wali gamagalau, ge Pilistiya. Hauna labi ni haveyan noek, yaka ana topihigelgel ni pakokovel ge ni apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","I ola al, alona wana atimatuwa i haveyan gagasisi ge Amaleki i pakokovel. Inoke Isileli i pwamwalil ali topihigelgel nimaliyaa, bolo valila hi haveyan elal ge wali bugubugul hi kaluoel. ");
INSERT INTO mpx_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","He Sol natunau bolau alaliya i ola hiwe: Diyontan, Isbi ge Malki-Suwa. Natunau yowau labui, toto bwabwatana alana Melab ge kekeisena alana Mikal. ");
INSERT INTO mpx_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Sol lagona alana Ahinowam, iya Ahimas natuna. Wana tolohaveyan wali tohouwa alana Abna, iya Sol tamana talina alana Nel natuna. ");
INSERT INTO mpx_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Sol tamana Kisi, ge Abna tamana Nel, heliya tonowak Abiyel natunau. ");
INSERT INTO mpx_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","He Sol yawalina ana sauga bwalibwaligena, alonau ge wana tolohaveyan hi lohalohaveyan gagasisi Pilistiya elal. Ebo Isileli bolauiliyau enuna i kitel ateliya i matuwa ge hi gasisi, yaka ni ahel tukagil nihi tabwa wana tolohaveyan hot. ");
INSERT INTO mpx_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Sauga etega Samuwela i baek Sol elana i ba, “Nau te valila Yehoba i patunau enonu ya hol kokowamwa ge u tabwa wana gamagalau Isileli wali kin. He nu laegan wasa toto i neem elana kaiwem na baunaniwa. ");
INSERT INTO mpx_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Yehoba Togasisi Hot i ba ola hiwe: ‘Boda Amaleki na lahel, kaiwena tubuliyau valila Isileli tubumiyau wali kamwasa hi mikaus ge hi haveyan elal sauga hi tagilem Itipita. ");
INSERT INTO mpx_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","He alomwau wam tolohaveyan nuku na nuku haveyan elal. Heliya ge wali bugubugul gegewena iyaka ya ba pwatanem elau, inoke nuku apapanak-agil. Wali bolau, yowau ge wawayau gegewel, i ola al wali bulumwakau, sipi, kamel ge donki nuku gopapaaliga-agil. Bahi yawaliliya nuku pwapwamwal.’” ");
INSERT INTO mpx_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Sol baaba o i hago inoke wana tolohaveyan i yogaagil ge i pamigogoil panuwa Telem elana. Bolo i aheliya Isileli ali un gamwaliyaa ali gewi tu handeled tausan (200,000), ge bolo i aheliya un Yuda elana ali gewi ten tausan (10,000). ");
INSERT INTO mpx_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Yaka i nulil ge hi na Amaleki wali panuwa bwabwatana ge hi bunsumi sinawel etega opopwina gamwanaa hi matamatan wali sauga waiwaisana etega kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Inoke Sol wasa i patuna boda Keni elal bolo hi miminaa Amaleki gamwaliyaa, i ba, “Labi ya nuku eguluwan, yaka bahi alomiyau ge Amaleki na apapanak-agimiu. Kaiwena valila tubumiyau ama tubumeyau hi mulolu-agil sauga hi tagilem Itipita ge hi nem labi ya elana.” Yaka boda Keni Amaleki hi miluwagil. ");
INSERT INTO mpx_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Inoke Sol alonau ge wana tolohaveyan hi tuk Amaleki elal ge hi pakokovel, hi telipunaa panuwa Havila hi na ali siga panuwa Sul, Itipita labena nati. ");
INSERT INTO mpx_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Amaleki gegewel haveyan kilepana elana hi apapanak-agil, yaa wali kin Eigag hi lib ge hi ahe. ");
INSERT INTO mpx_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","He Eigag yawalina hi pwamwal, i ola al sipi ge bulumwakau waiwaisal, aloliyau ge natuliyau tatabwal. Bugubugul gegewel bolo waiwaisal hi bugulagil. Bwagana Yehoba i ba pwatanek iya elana, he hi ahe, nige nuwaliya i oola nihi apapanak-agil. Yaa bwasumu bolo hi pweyata ge bugubugul bolo nige nuwaliya i nonoek, gegewel hi apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Yaka Yehoba i baek Samuwela elana i ba, ");
INSERT INTO mpx_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Nuwau i nak te ibwe valila Sol ya teli i tabwa kin, kaiwena o en i pem ge no baaba nige i papaolaolaek.” Samuwela baaba o i hago inoke i nuwanuwatu nabi, yaka bulin bwabwaligena o i awawanun nabinabi Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Lan i gan mweluluga kekeisi, Samuwela i lut i na Sol i loyaan. Gamagalau hi baek elana hi ba, “Sol i na panuwa Kamel ge pat etega i pamilil alana ana tobal etotohina, yaka abwe i na i lau panuwa Gilgal.” ");
INSERT INTO mpx_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Sauga Samuwela i na Sol i pwawa, inoke Sol i baek elana i ba, “Yehoba ni mulolu-agiwa! He wana baaba gegewena iyaka ya paolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Yaa Samuwela i baek elana i ba, “Ebo i ola o, ga i ola sipi ge bulumwakau wali kahikahin ya hago tanawa?” ");
INSERT INTO mpx_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Anana Sol i lahe i ba, “Tolohaveyan hi aheliya Amaleki elal. He sipi ge bulumwakau bolo waiwaisal hot yawaliliya hi pwamwal tage nihi powonagil Yehoba wam Yabowaine elana. Yaa gegewel al iyaka ha apapanak-agil.” ");
INSERT INTO mpx_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Yaka Samuwela i baek elana i ba, “U bakuhu! Wam wasa ga na pewa hauna gun bulin Yehoba i baunanim kaiwem.” Anana Sol i lahe i ba, “He u ba na hago.” ");
INSERT INTO mpx_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Inoke Samuwela i baek elana i ba, “Bwagana valila u nuwatu tage gamagal bwagabwaga owa, yaa u tabwa Isileli ali un wali tohouwa, age? He Yehoba i hilewa wali kin. ");
INSERT INTO mpx_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Yaka i patunawa tuwalali etega nu ginol, i baewa elam i ba, ‘Nu na nu haveyan Amaleki, boda nanakil elal. Heliya ge wali bugubugul gegewena iyaka ya ba pwatanem elau, inoke nu apapanak-agil ana siga nu pwamowasel.’ ");
INSERT INTO mpx_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Hauna kaiwena nige wana baaba u hehenapu-an? Hauna kaiwena u gegi matanaa ge etimwawa u na Amaleki wali bugubugul u bugulan kaiwem?” ");
INSERT INTO mpx_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Yaa anana Sol i lahe i ba, “Yehoba wana baaba ya henapuan ya! Tuwalali toto iya i patunau na ginol, he ya ginol. Amaleki ya apapanak-agil, yaka wali kin Eigag ya lib ge ya pwatanim. ");
INSERT INTO mpx_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Bugul bolo Yabowaine i ba pwatanek iya elana gamwaliyaa, tolohaveyan sipi ge bulumwakau bolo waiwaisal hot hi bugulan ge hi pwatanim te Gilgal tage nihi powonan Yehoba wam Yabowaine elana.” ");
INSERT INTO mpx_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Yaa anana Samuwela i lahe i ba, “Hauna ginol toto Yehoba i yaliyaya-an hot: bwasumu ta powonan pwabwaligel ge powon ona ta ginolil,   o ebo wana baaba ta hago? He wana baaba ta hago i waisi lake te bwasumu ta powonagil,   ge anana ta laeganan i waisi lake te sipi posana ta ton elana. ");
INSERT INTO mpx_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Ebo ta awatautau Yehoba elana, gegina i ola ya te ta olaolal,   ge ebo ta hanaha iya elana, nakina i ola ya te ta kukululuek gogoginol elal. Kaiwena Yehoba wana baaba iyaka u towani,   he iya iyaka i towaagiwa nige al ni aawa kin-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Yaka anana Sol i lahe i ba, “E, iyaka ya gegi. Yehoba wana baaba ge owa wam logugui nige ya hehenapuan. Tolohaveyan ya lovakunagil inoke ya ginol ola wali nuwatu. ");
INSERT INTO mpx_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","He ya awanun eliyam no gegi nu nuwayoho, yaka alou owa ta sikal tolohaveyan elal ge na tapwalolo Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Yaa Samuwela i baek elana i ba, “Nigeya! Nige na nonowa. He Yehoba wana baaba iyaka u towani, inoke iya iyaka i towaagiwa nige al ni aawa kin-agiwa ge Isileli nu lologugui-agil.” ");
INSERT INTO mpx_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Yaka Samuwela i tagena pil tage ni noegon, yaa ana holahola yayapona buhuna Sol i pihikan momol yaka i kukuleli. ");
INSERT INTO mpx_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Inoke Samuwela i baek elana i ba, “He lan ebe Yehoba iyaka Isileli ana abalogugui i kukuyoho elam, ge i pek alom etega elana toto i waisi lakewa. ");
INSERT INTO mpx_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Isileli ana Yabowaine wawasana iya nige i kakakawi o ebo wana nuwatu i pipil. Kaiwena iya nige gamagal ololana kila i oola ge tage wana nuwatu ni pil.” ");
INSERT INTO mpx_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Anana Sol i lahe i ba, “Iyaka ya gegi. Yaa tab bosowaina nu awatauwagau no gamagalau Isileli avaliyau wali tonowakau mataliyaa? Alou owa ta sikal ge na tapwalolo Yehoba wam Yabowaine elana.” ");
INSERT INTO mpx_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Yaka Samuwela i sikal alona, inoke Sol i tapwalolo Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Yaka Samuwela i ba, “Amaleki wali kin Eigag ku pwatanim elau.” Sauga hi pwatanik, alona ge wana atimatuwa i nok, kaiwena i nuwatu i ba, “Iyaka nige nihi lololau.” ");
INSERT INTO mpx_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Yaa Samuwela i baek elana i ba, “Wam haveyan kilepana elana gamagalau u lolil yaka yowau hi gewi nige natuliyau hi gagan,   inoke i ola to, nau na loliwa yaka hinam nige natuna ni gagan.” Yaka Samuwela Eigag i gopaaliga abapowon awonaa panuwa Gilgal elana. ");
INSERT INTO mpx_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Inoke Samuwela i egon i na wana panuwaa Lama, ge Sol i sikal wana limiya iyoho wana panuwaa Gibeya. ");
INSERT INTO mpx_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","He lan o i na ana siga Samuwela i aliga, nige sauga etega i nana Sol i kikite, yaa baena i lolonuwanak. Yaka Yehoba nuwana i nak te ibwe valila Sol i teli i tabwa kin ge Isileli i logugui-agil. ");
INSERT INTO mpx_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Inoke Yehoba i baek Samuwela elana i ba, “Sauga ana yapu ga ni ola ge nu lonuwanak Sol baena? Iyaka ya towani nige al na aawa kini ge Isileli ni lologugui-agil. He olibe enonona nu holek wam patuna toto sipi ali hon hi ginoliya nu pakalaopop, yaka nu ahe ge nu egon. Ya papatunawa nu na panuwa Bedeliyema tonowak Diyesi elana, kaiwena natunau bolau gamwaliyaa etega iyaka ya hile ni tabwa kin.” ");
INSERT INTO mpx_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Anana Samuwela i lahe i ba, “Nige bosowaina na ginol ola to! Ebo Sol wasau ni hago, nasi ni lopaaligau.” Inoke Yehoba i baek elana i ba, “Bulumwakau natuna yovana etega nu ahe ge alom nuku nok, yaka nu ba, ‘Ya nem na powon Yehoba elana.’ ");
INSERT INTO mpx_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Diyesi ana baaba nu patuna ni nem powon ge enona elana, yaka abwe na ba elam hauna gun nu ginol. He natuna toto na pankitewa, enonu nu hol kokowanaa kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Yaka Samuwela i ginol i ola Yehoba hauna gun i baunan elana. Sauga i vin Bedeliyema, yaka tonowakiliyau hi nok elana ginebi wali ginu ge hi neli hi ba, “Wam nem eliyama ginebi ge wam laumwal?” ");
INSERT INTO mpx_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Yaka analiya i lahe i ba, “E, ginebi ge no laumwal. Ya nem na powon Yehoba elana. He nuku abubunimiu nuku yanayana tapwalolo kaiwena, yaka nuku nem alowau komiu ta na powon ge enona elana.” Inoke Diyesi alonau ge natunau bolau ali abububun paganina Samuwela i ginol, ge i ba heliya al nihi nok. ");
INSERT INTO mpx_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Sauga hi na hi vinan, yaka Samuwela matana i nok Eliyab i kite, iya Diyesi natuna tauina gamaun. Inoke i nuwatu i ba, “Tunahot Yehoba wana hilihili gamagalina te i taltalmilil Yehoba manininaa e.” ");
INSERT INTO mpx_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Yaa Yehoba i baek elana i ba, “Bahi nuwam ni nonoek ana awa ana waisi ge wana yapu elana, kaiwena iya iyaka ya towani. No hilihili nige i oola komiu gamagal wami hilihili. Komiu awa toto noleleya te ku gagayawa-an, yaa nau Yehoba ati te ya gagayawa-an.” ");
INSERT INTO mpx_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Inoke Diyesi Abinadab i yogaan ge i ba i nawa nok Samuwela manininaa. Yaa Samuwela i ba, “Iya al ge Yehoba nige i hihile.” ");
INSERT INTO mpx_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Yaka Diyesi i ba Sama i nawa nok Samuwela manininaa. Inoke Samuwela i ba, “Toto al ge Yehoba nige i hihile.” ");
INSERT INTO mpx_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Diyesi i giginol ola to, ana siga natunau bolau ali gewi seben hi nawa nok Samuwela manininaa. Yaa Samuwela i baek elana i ba, “Natumwau bolo ya nige etega Yehoba i hihile.” ");
INSERT INTO mpx_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Yaka i nel elana i ba, “Natumwau bolau ali gewi iyai ya e?” Anana Diyesi i lahe i ba, “Ali melumelu iyoho uleya, iya sipi i mamatahikagil.” Yaka Samuwela i baek elana i ba, “Ana baaba u patuna ni nem. Nige ta mimisiyo ge powon enona ta aan ana siga ni vin.” ");
INSERT INTO mpx_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Inoke Diyesi gamagal etega i patuna i na i en pwatanik elal. Tuwana i sapusapu ge maninina ana awa i waisi. Yaka Yehoba i baek Samuwela elana i ba, “He iya te, u nok ge enonu u hol kokowanaa.” ");
INSERT INTO mpx_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Inoke Samuwela olibe enonona ana patuna i ahe ge i hol Deibid kokowanaa talinau mataliyaa. Yaka Yehoba Yayaluwana wana gasisi i lau i minaa elana, i telipunaa lan o ge i nok. Yaka abwe Samuwela i sikal i na wana panuwaa Lama. ");
INSERT INTO mpx_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Yehoba Yayaluwana iyaka Sol i miluwai, ge yayaluwa toapapanak etega i noem Yehoba elana ge i papalovakuni. ");
INSERT INTO mpx_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Inoke wana totuwalali hi baek elana hi ba, “He yayaluwa toapapanak etega i noem Yabowaine elana ge i papalovakuniwa. ");
INSERT INTO mpx_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Tonowak, nu ba ama wam totuwalali naha na gamagal etega naha loyaan toto hapi ana galagalavenu i atena. Yaka ebo yayaluwa toapapanak wana gasisi ni mamasal eliyam, inoke hapi ni lolol ge amnam ni wawaisi.” ");
INSERT INTO mpx_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Inoke i baek elal i ba, “I waisi, nuku na gamagal etega nuku loyaan toto hapi ana lolol i atena bubun ge nuku en pwatanim elau.” ");
INSERT INTO mpx_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Yaka anana totuwalali avaliya etega i lahe i ba, “Diyesi Bedeliyema gamagalina natuna tauina etega ya kite, hapi ana lolol i atena. Iya tolohaveyan gasigasisena, toawabaaba ge i hebubun. He Yehoba i minaa elana.” ");
INSERT INTO mpx_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Yaka Sol elopapatuna i patunal hi na Diyesi elana ge hi ba, “Sol i ba natum Deibid, iya sipi ali tomatahikan, nu patuna elana.” ");
INSERT INTO mpx_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Inoke Diyesi Deibid i patuna i na Sol elana, ginebi donki etega beleid hi usan pwatanaa, oine patuna maisena ge goti natuna etega. ");
INSERT INTO mpx_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Sauga i vin, yaka Sol i ahe tukan i tabwa wana totuwalali. I nunuwana-an bubun, inoke abwe i hile i tabwa wana elohaveyan ana tokaval etega. ");
INSERT INTO mpx_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Yaka baaba i patuna Diyesi elana i ba, “Ya yaliyaya nabi Deibid kaiwena. Nu talamwan ni minaa elau ge ni tuwalali kaiweu.” ");
INSERT INTO mpx_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Sauga ebo yayaluwa toapapanak toto i noem Yabowaine elana wana gasisi i mamasal, yaka Deibid wana hapi i lolol, inoke yayaluwa toapapanak Sol i mimiluwai ge amnana i wawaisi al. ");
INSERT INTO mpx_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Pilistiya wali tolohaveyan haveyan kaiwena hi pamigogoil panuwa Soko Yuda wali labiya. Yaka hi holaviya panuwa Epes-Damim, Aseka ge Soko ali luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Inoke Sol alonau ge wana tolohaveyan hi migogo Elaa abwabwina elana ge hi holaviya to, yaka hi mivatal avaliyau Pilistiya nihi lohaveyan. ");
INSERT INTO mpx_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","He Pilistiya hi minaa oya etega elana ge Isileli hi minek eluwana elana, yaka abwab i minaa ali luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Pilistiya wali toasiyala etega alana Golaiya Gat gamagalina, i notagilem wali abaholaviya. Ana yapu kelaubwa ni ola tili (3) mita. ");
INSERT INTO mpx_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Ana pepem gasigasisena kopa hi ginoliya i pom kokowanaa, ge babagalina ana eteli kaus kopa hi ginoliya ana pulowan i ola pipti seben kiloglem (57 kg). ");
INSERT INTO mpx_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Aena lamwana ana ekaukaus kopa hi ginoliya, ge gau kekeisi etega kopa hi ginoliya i minaa abanaa i pakuki eputetenaa. ");
INSERT INTO mpx_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Wana gau bwabwatana nimana i tut hot ge matana aiyan ana pulowan seben kiloglem (7 kg). Wana ligovan ana tokaval i nawaa manininaa. ");
INSERT INTO mpx_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Golaiya i talmilil yaka i yoga panet Isileli elal i ba, “Ga i ola ge ku nem ku vatal haveyan kaiwena? Nau Pilistiya wali toasiyala ge komiu Sol wana totuwalali loloyowanil. He alomiu etega ku hile yaka ni nem ni lau eliyau. ");
INSERT INTO mpx_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Ebo ni haveyan elau ge ni lopaaligau, yaka ama naha tabwa wami totuwalali loloyowanil. Yaa ebo na pakokove ge na lopaaliga, yaka komiu nuku tabwa wama totuwalali loloyowanil.” ");
INSERT INTO mpx_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Yaka i ba vevehe al i ba, “Isileli tolohaveyan, i bwe ku taltalmilil, ku nem ta lohaveyan. Alomiu etega ku hile ni nem alou naha lohaveyan.” ");
INSERT INTO mpx_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Sauga Sol ge wana tolohaveyan baaba o hi hago, inoke ateliya i bwanabwana ge hi lovakun nabi. ");
INSERT INTO mpx_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Deibid tamana alana Diyesi, ana un Epalat, i miminaa Bedeliyema labi Yuda. Natunau bolau ali gewi eit (8). Sol wana sauga logugui elana iya iyaka i liki nabi. ");
INSERT INTO mpx_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Natunau bolau eton avaliya Sol hi na haveyana: Toto gamaun alana Eliyab, loena Abinadab, ge etonina alana Sama. ");
INSERT INTO mpx_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Ali melumelu alana Deibid. Talinau eton iyoho avaliya Sol haveyana, ");
INSERT INTO mpx_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","yaa iya i nem nowa, sauga enuna ni na alona Sol, ge sauga enuna ni minaa Bedeliyema ge tamana wana sipi ni matahikagil. ");
INSERT INTO mpx_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Lan poti gamwanaa mweluluga ge kokoyavi gegewena, Golaiya ni nonotagil ge ni yoyoga panet Isileli elal. ");
INSERT INTO mpx_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Lan etega Diyesi i baek natuna Deibid elana i ba, “Bali ekekana hiwe ana bwata ni ola ten kiloglem, ginebi ge beleid bolo ya ali gewi elulutega nu ahel talimwau kaiweliya, yaka etimwawa nu pwatanik wali abaholaviya. ");
INSERT INTO mpx_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","I ola al, aanan sis hiwe ali gewi elulutega nu ahel ge nu pek ali pwahin ana tohouwa elana. Nu kite talimwau wali minamina ga i ola, ge bugul etega nu pwatanim eliyau yaka na atena te hi mibubun. ");
INSERT INTO mpx_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Heliya iyoho avaliya Sol ge wana tolohaveyan gegewel hi holaviya Elaa abwabwina elana ge avaliyau Pilistiya hi hahaveyan.” ");
INSERT INTO mpx_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Lan i gan mweluluga kekeisi, Deibid sipi i eguluwagiliya tomatahikan etega elana, yaka ana kaval i bugulan ge i nawanawa, i ola Diyesi wana baaba. Sauga i vin abaholaviya, he tolohaveyan iyoho hi tagitagil hi nana abalohaveyana hi yoku haveyan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Isileli wali tolohaveyan hi mivatal ge Pilistiya wali tolohaveyan hi mivatal, awoliya hi pempewa. ");
INSERT INTO mpx_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Inoke Deibid i na aanan i telel bugubugul ali tomatahikan elana. Yaka iya i tapalelu i na labi toto Isileli wali tolohaveyan hi vatala ge talinau i nelil wali minamina ga i ola. ");
INSERT INTO mpx_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","He iya iyoho i baaba elal, yaka Golaiya, Pilistiya wali toasiyala Gat gamagalina, i notagilem ali vatal elana. Yaka i yoga panet Isileli elal i ba panapanak-agil, i ola lan gegewena i giginol, inoke Deibid i hago. ");
INSERT INTO mpx_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Sauga Isileli wali tolohaveyan Golaiya hi kite, yaka gegewel hi lovakun nabi ge hi lou. ");
INSERT INTO mpx_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Yaka hi pebaaba-agil hi ba, “Ku kite! Tau o lan maisena maisena i nonotagil, yaka i yoyoga nemnem ge i babaa panapanak-agila. Henala ebo ni lopaaliga, he kin Sol nasi mola bwabwatana ni pek elana. I ola al, natuna meluyovana etega ni pek ni alolonan, ge tamana ana tini nige takis nihi pwapwamola.” ");
INSERT INTO mpx_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Deibid i nel bolau elal, bolo hi taltalmilil labenaa, i ba, “Tau toto ebo Pilistiya gamagalina o ni lopaaliga ge kila Isileli ala puluwawi ni ahek yoho, hauna gun kin ni ginol kaiwena? Pilistiya o nige Yehoba i aatena ge nige gotomwa yoho paganina i aahe. Inoke iya henala ge bosowaina kila Yabowaine yawalina gaganina wana tolohaveyan ni ba panapanak-agila?” ");
INSERT INTO mpx_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Inoke baaba maisena o hi baunan al Deibid elana, ge hi ba, “He kin ni ginol ola to tau kaiwena, toto Golaiya ni lopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Deibid iyoho alonau bolau hi baaba, yaka talina gamaun alana Eliyab i hago. Inoke i huga nabi ge i neli i ba, “Hauna kaiwena u nem u lau e? Henala abwe wam sipi bolo u tataluwagil ula kekevana elana ni matahikagil? Ya atena owa tohanaha ge tolokalokakawi! He u nem nuwam te haveyan nu gagayawa.” ");
INSERT INTO mpx_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Anana Deibid i lahe i ba, “Hauna gun ya ginol panak? Age bahi na baaba?” ");
INSERT INTO mpx_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Inoke i mipil i na tolohaveyan etega elana ge nel maisena o i neli al. Yaka i lahe i ola toto houwan. ");
INSERT INTO mpx_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","He Deibid wana baaba tolohaveyan enuna hi hago, yaka hi na hi wasaanik Sol elana, inoke Sol Deibid ana baaba i patuna ge ni nok elana. ");
INSERT INTO mpx_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Sauga Deibid i na Sol elana, yaka i baek elana i ba, “Bahi kila etega Pilistiya gamagalina o ni lolovakunan! Nau wam totuwalali na nok alou naha lohaveyan.” ");
INSERT INTO mpx_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Anana Sol i lahe i ba, “Owa nige bosowaim nu na alom Pilistiya wali toasiyala o nuku lohaveyan! He owa wawayam ya, ge iya tolohaveyan waiwaisana, i telipunaa wana sauga heval ana siga sauga ya.” ");
INSERT INTO mpx_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Yaa Deibid i ba lawalawakik i ba, “Nau wam totuwalali nam wana sipi ya mamatahikagil. Sauga ebo bwasumu sosokana laiyoni o ebo beya etega ni nem ge sipi ni alaegonan ali yawi gamwanaa, ");
INSERT INTO mpx_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","yaka no suki na ahe na tatauliulil enaa, na lol ge sipi yawalina na pwamwal. Ge ebo ni topil tage ni tatalau, yaka na lib mwamwalinaa ge na tagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Nau wam totuwalali, laiyoni ge beya ya tagapaaligal. He nasi na ginol ola al to Pilistiya gamagalina o elana, iya nige Yehoba i aatena ge nige gotomwa yoho paganina i aahe. Kaiwena Yabowaine yawalina gaganina wana tolohaveyan i ba panapanak-agimiu. ");
INSERT INTO mpx_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Yehoba i pwamwalau laiyoni ge beya elal, iya al nasi ni pwamwalau Pilistiya gamagalina nimanaa.” Anana Sol i lahe i ba, “I waisi! He u nok. Yehoba alom.” ");
INSERT INTO mpx_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Inoke kin Sol wana haveyan kalikona i ahe Deibid i pagaloi. Babagalina ana eteli kaus i pahe elana ge ana pepem gasigasisena kopa hi ginoliya i pom Deibid kokowanaa. ");
INSERT INTO mpx_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Yaka Deibid Sol wana haveyan kilepana i pakuki lulunaa, inoke i nonobobosa, yaa nige i totounuwe. Yaka i baek Sol elana i ba, “Nige bosowaiu na nokalivail te, kaiwena nige ya totounuwe.” Inoke i palo yohil. ");
INSERT INTO mpx_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Yaka wana suki i ahe ge i na sinawel elana pat bobomwil nimala panuna i hivatil ge i usan wana nabwaa. Yaka wana elopeu i noahe ge i nawa nok Golaiya gegelinaa. ");
INSERT INTO mpx_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Golaiya Pilistiya gamagalina, alona ge wana ligovan ana tokaval i nawaa awonaa, hi nanawa Deibid kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Yaka matana i nok Deibid i kite hevalina ya, tuwana i sapusapu ge ana awa i waisi. Inoke i kite lowan te iya nige bosowaina bugul etega ni ginol. ");
INSERT INTO mpx_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Yaka i yoga nok elana i ba, “Age nau wanuka ge suki u ahe u nem ei?” Inoke i yoga wana yabowaine elal tage Deibid nihi nuwamutan. ");
INSERT INTO mpx_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Yaka i yoga i ba, “U nem hiwe, inoke na lopaaligawa ge tuwam bwasumu hi youyou hawawala ge bekik nihi an.” ");
INSERT INTO mpx_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Yaka anana Deibid i lahe i ba, “Owa haveyan kilepana, gau bwabwatana ge gau kekeisi u ahe ge u nem nu lohaveyan elau. Yaa nau na lohaveyan elam Yehoba Togasisi Hot alana elana, iya Isileli wama tolohaveyan wali Yabowaine, toto alana u ba panapanak-an. ");
INSERT INTO mpx_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Lan ebe Yehoba ni telewa nimwawa, inoke na tagapasogowa ge mwamwalim na gotomwa yoho. Yaka Pilistiya wami tolohaveyan naha lopaaligal, inoke tuwaliya bwasumu hi youyou hawawala ge bekik nihi anil. Inoke panayawi labena gegewena nihi atena te Isileli wama Yabowaine i gan. ");
INSERT INTO mpx_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","I ola al, bolau gegewel hi migogo e nihi atena te Yehoba wana gamagalau i pwapwamwalil, yaa nige haveyan kilepana ge gau elana i oola. Kaiwena Yehoba te ni lohaveyan, inoke nasi ni telemiu nimameya.” ");
INSERT INTO mpx_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Inoke Golaiya i nawa nok al, yaka Deibid etimwawa i tapalelu nok awonaa Golaiya elana. ");
INSERT INTO mpx_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Nimana i lau wana nabwa gamwanaa, pat etega i ahe tagilan, inoke i telek wana elopeu elana. Yaka i tagapipili ge pat i na Golaiya lamwana i tagahawan i tuk awaa, inoke i sogu ge i talpo bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","He liwanina i ola to, pat ge elopeu elana te Deibid Golaiya i pakokove ge i lopaaliga. Nige haveyan kilepana i gagan nimanaa te i ginol ola o. ");
INSERT INTO mpx_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Yaka Deibid i patalelu i na i milil awawe. Nimana i nok Golaiya wana haveyan kilepana i momol tagilanem abanaa, yaka mwamwalina i gotomwa yoho ge i aliga. Sauga Pilistiya hi kite wali toasiyala iyaka i aliga, inoke hi mipil ge hi lou. ");
INSERT INTO mpx_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Inoke Isileli ge Yuda wali tolohaveyan hi yoku analiya i bwata ge hi tapalelu Pilistiya eliyaa. Hi takel hi na ali siga panuwa Gat ge Eklon ali abatuktuka. He Pilistiya bwaliwawagal i wehel Salaim ana kamwasaa ana siga Gat ge Eklon. ");
INSERT INTO mpx_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Sauga Isileli iyaka Pilistiya hi takel yohil, inoke hi sikal hi na bugubugul gegewena bolo Pilistiya hi eguluwagil wali abaholaviya hi bugulagil. ");
INSERT INTO mpx_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","He Deibid Golaiya balomana i ahe, yaka abwe sauga etega i pwatanik Yelusalema, yaa wana elohaveyan i bugulan i na i teleliya wana epanapana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","He sauga Deibid iyoho i tagitagil ni na alona ge Golaiya nihi haveyan, kin Sol i gagayawa-an, inoke i nel tolohaveyan wali tohouwa elana i ba, “Abna, heval o henala natuna?” Anana i lahe i ba, “O kin, ya baaba tunahot eliyam, nige ya aatena.” ");
INSERT INTO mpx_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Inoke kin Sol i baek elana i ba, “Nu na nu nel tolohaveyan elal heval o henala natuna.” ");
INSERT INTO mpx_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Sauga Deibid Golaiya i lopaaliga i mowasi ge i sikal abaholaviya, inoke Abna i en ge i pwatanik Sol manininaa. He Golaiya balomana iyoho ya nimanaa. ");
INSERT INTO mpx_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Yaka Sol i nel elana i ba, “Heval, owa henala natuna?” Anana i lahe i ba, “Nau wam totuwalali Diyesi natuna, iya panuwa Bedeliyema tonowakina.” ");
INSERT INTO mpx_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Sauga Deibid alona ge Sol hi baaba haba, inoke Diyontan alona ge Deibid hi heliheliyam bubun ge Diyontan Deibid i nunuwana-an i ola totona i nunuwana-an. ");
INSERT INTO mpx_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","He lan o ge i nok Sol Deibid i kukuhikan i totuwalali elana, nige i tatalam ge ni sikal tamana wana limiya. ");
INSERT INTO mpx_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Inoke Diyontan bateli gasigasisena etega i ginol Deibid elana, kaiwena i nunuwana-an i ola totona i nunuwana-an. ");
INSERT INTO mpx_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Yaka wana bateli ana patunahot kaiwena ana holahola yayapona ge wana haveyan kalikona toto i galoi i palo ge i pek Deibid elana, ginebi wana haveyan kilepana, wana egipoyo ge wana wasikewa. ");
INSERT INTO mpx_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Sauga ebo Sol ni ba Deibid ni na haveyan etega ni haveyani, he i giginol ge i wawaisi. Inoke i teli heyan i tabwa tolohaveyan wali tobwabwatana etega. Sol wana tolohaveyan aloliyau wali tohouwa ginol o hi yaliyaya-an. ");
INSERT INTO mpx_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Sauga Deibid Golaiya i lopaaliga ge tolohaveyan hi sikasikal, inoke Isileli panuwana ona yowauiliyau hi tagilan kamwasaa kin Sol ge tolohaveyan hi pwawal. Ginebi wali yaliyaya egalagalavenu tambalin ge hapi hi lolol, yaka hi wonawona ge hi sagasaga. ");
INSERT INTO mpx_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Bolo egalagalavenu hi lolol hi wonawona hi ba, “Sol tausan hi gewi i lolil,   ge Deibid ten tausan hi gewi i lolil.” ");
INSERT INTO mpx_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Baaba o Sol amnana i apanak, yaka i huga nabi ge i nuwatu i ba, “Deibid ten tausan hi gewi hi baunanik elana, yaa nau tausan hi gewi te hi baunanim elau. Nige waisi etega al ni lologasisi-an, iyai te ni tabwa kin ge abau ni ahe.” ");
INSERT INTO mpx_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Inoke lan o ge i nok, Sol alona wana hinahinan Deibid i kite hikan. ");
INSERT INTO mpx_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Lan i gan yaka yayaluwa toapapanak etega toto i noem Yabowaine elana alona wana gasisi bwabwatana i masal Sol elana. Inoke iya iyoho wana limiya i baaba bwagabwaga ge wana ginol i ola tokokona, yaa Deibid iyoho wana hapi i lolol, i ola sauga gegewena i giginol. He Sol gau etega i pihikan nimanaa, ");
INSERT INTO mpx_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","yaka i alihin Deibid elana i nuwatu te Deibid alona baba ni howa toyawel. Yaka abwe sauga etega al Sol gau i alihin Deibid elana, yaa palabui Deibid i kileyan. ");
INSERT INTO mpx_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","He Sol Deibid i lovakunan, kaiwena Yehoba i minaa Deibid elana, yaa iya i miluwai. ");
INSERT INTO mpx_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Inoke Deibid i patuna ni miegon elana ge i teli i tabwa tolohaveyan ali gewi tausan maisena wali tohouwa. Yaka Deibid wana tolohaveyan i nunulil hi tatagil haveyan tomaha ona elal. ");
INSERT INTO mpx_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Bugul gegewena bolo Deibid i giginolil hi wawaisi, kaiwena Yehoba i minaa elana. ");
INSERT INTO mpx_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Sauga Sol i kite bugul gegewena bolo Deibid i giginolil hi wawaisi, inoke i lovakunan nabiyan. ");
INSERT INTO mpx_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Yaa Isileli ge Yuda gegewel Deibid hi nunuwana-an, kaiwena i nunulil hi tatagil haveyan tomaha ona elal. ");
INSERT INTO mpx_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Sol i baek Deibid elana i ba, “Natu meluyovana toto bwabwatana hiwe alana Melab na pewa nu alolonan, iyai te ebo nu haveyan nu ola toasiyala kaiweu ge Yehoba wana haveyan nu lohaveyani.” (He Sol i ba ola o, kaiwena i nuwatu atenaa i ba, “Bahi nau nimwau elana ge na lolopaaliga, yaa Pilistiya te nihi ginol.”) ");
INSERT INTO mpx_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Anana Deibid i lahe i ba, “Wam nuwatu i waisi! Yaa henala nau ge henalau nam ana un Isileli gamwanaa ge tage na tabwa owa kin yawam?” ");
INSERT INTO mpx_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Yaa sauga toto tage Sol Melab ni pek Deibid elana ni alolonan, he nige i pepek, yaa i pek Ediliyel gagama Mehola elana ge i alolonan. ");
INSERT INTO mpx_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","He Sol natuna yovana etegana al alana Mikal i hebabala Deibid elana, ge sauga Sol wasa i hago yaka i yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Sol i nuwatu atenaa i ba, “Mikal na pek ni alolonan yaka ni tabwa Deibid ana kimul ge Pilistiya nihi lopaaliga.” Yaka Sol i baek Deibid elana i ba, “Lan ebe wam sauga waiwaisana labuina ya pewa nu tabwa yawau.” ");
INSERT INTO mpx_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Inoke Sol i baek wana totuwalali alaliya bwabwatana elal i ba, “Nuku na nuku liwan sumi Deibid elana nuku ba, ‘Kin i yaliyaya kaiwem, i ola al ama wana totuwalali gegewema nuwama owa. He i waisi te sauga ya natuna nu alolonan ge nu tabwa yawana.’” ");
INSERT INTO mpx_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Inoke Sol wana baaba hi baunanik Deibid elana, yaka analiya i lahe i ba, “He nige bugul mweyamweyahina i oola tage na tabwa kin yawana! Kaiwena nau togulagula ge gamagal bwagabwaga, inoke nasi ga na tovelam ola eliyana?” ");
INSERT INTO mpx_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Sol wana wasa hi pek hauna Deibid i baunan elal, ");
INSERT INTO mpx_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","inoke analiya i lahe i ba, “Nuku baek Deibid elana nuku ba, ‘Kin nige nuwana mola getoga eliyana ge natuna nu pwamolaya, iyai te Pilistiya bolau ali gewi elulu bwagabwaga (100) nu lolil, yaka tuwaliya buhuna kunisina nu pwatanik elana ni kite. He nuwana ya te nu tagalahi ana topihigelgel elal.’” (He Sol wana nuwatu te Deibid ni patuna ni na alonau Pilistiya nihi haveyan yaka nihi lopaaliga.) ");
INSERT INTO mpx_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Totuwalali alaliya bwabwatana Sol wana nuwatu hi wasaan Deibid elana, yaka i yaliyaya te ni tabwa kin yawana. He Sol iyaka sauga i teli ge mulaa abwe Pilistiya tuwaliya buhuna kunisina Deibid ni pwatanim elana. Sauga o nige ga i pwapwawa, ");
INSERT INTO mpx_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","yaka etimwawa Deibid alonau ge wana tolohaveyan hi tagil hi na Pilistiya bolau ali gewi tu handeled (200) hi lolil. Inoke tuwaliya buhuna kunisina Deibid i pwatanik kin Sol elana, yaka eliyana Sol wana logugui ge ni tabwa yawana i paolaolaek bubun. Inoke Sol Mikal i pek Deibid elana ge i alolonan. ");
INSERT INTO mpx_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Sol iyaka i atena bubun Yehoba i minaa Deibid elana ge Mikal Deibid i nunuwana-an, ");
INSERT INTO mpx_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","inoke i lovakunan nabiyan hoti, ge yawalina miminana i pipihigelgel elana. ");
INSERT INTO mpx_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Pilistiya avaliyau wali tohouwa iyoho ya avaliyau Isileli hi hahaveyan. Sauga ebo hi hahaveyan, he Deibid te wana lohaveyan lahi elal i wawaisi hot, i lake te tohouwa gegewel al Sol wana tolohaveyan gamwaliyaa wali lohaveyan lahi. Inoke Deibid alana i bwata hot Isileli gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Sauga etega Sol i baek wana totuwalali gegewel ge natuna Diyontan elal Deibid nihi lopaaliga. Yaa Diyontan i yaliyaya nabi Deibid kaiwena, ");
INSERT INTO mpx_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","yaka i baek elana i ba, “Nam Sol kamwasa i loya ge ni lopaaligawa. He nu matahikagiwa, bwaligumwa mweluluga nu na uleya abamina etega nu kite inoke nu bunsumiya to. ");
INSERT INTO mpx_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Na ba nam elana, yaka naha nowa labi o elana ge na baaba kaiwem. Yaka ebo ga ni ba ola abwe wam wasa na pewa.” ");
INSERT INTO mpx_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Lan i gan mweluluga, alona tamana hi na uleya, inoke Diyontan Deibid i awa wawaisi-an tamana elana, yaka abwe i ba, “Bahi nak etega nu giginol wam totuwalali Deibid elana. Iya nige sauga etega nak i giginol eliyam. Bugul gegewena bolo i ginolil am labe kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Nige i nuwanuwatu yawalina kaiwena yaka i na alona Golaiya gagama Pilistiya hi lohaveyan ge abwe i lopaaliga. Inoke Yehoba Isileli gegewela i pwamwalilaem nak bwabwatana elana, yaka owa u kite ge u yaliyaya. Deibid iya tau sasapona, inoke ga i ola nak nu ginol elana ge nu lopaaliga bwabwage?” ");
INSERT INTO mpx_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Sol Diyontan wana baaba i yaliyaya-an, yaka i ba, “Ya papasila Yehoba yawalina gaganina alanaa nige Deibid na lolopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Yaka abwe Diyontan Deibid i yogaan ge bugul gegewena bolo alona ge tamana hi liwanan i wasaan elana. Inoke i en pwatanik Sol elana, yaka i totuwalali al elana i ola valila. ");
INSERT INTO mpx_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Sauga etega Isileli avaliyau ge Pilistiya hi lohaveyan, yaka Deibid wana tolohaveyan i nulil hi na hi haveyan elal. Hi lohaveyan gagasisi yaka Pilistiya hi lou. ");
INSERT INTO mpx_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","He lan etega Sol i misiyo wana limi gamwanaa wana gau i pihikan nimanaa. Yaka yayaluwa toapapanak toto i noem Yehoba elana wana gasisi i masal Sol elana. He Deibid iyoho wana hapi i lolol, ");
INSERT INTO mpx_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","inoke Sol gau i alihin elana tage ginebi baba ni howa toyawel, yaa Deibid i kileyan inoke gau baba i howa. Yaka bulin o Deibid i lou. ");
INSERT INTO mpx_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Sol bolau enuna i patunal hi na Deibid wana limi hi kite hikan ana siga lan ni gan mweluluga, yaka nihi lopaaliga. Yaa Mikal, Deibid lagona, i baek elana i ba, “Ebo bulin e nige nu lolou, yaka bwaligumwa mweluluga te nihi lopaaligawa.” ");
INSERT INTO mpx_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Inoke Mikal hihiu elana Deibid i pakuki lowan windo etega elana, yaka i lou. ");
INSERT INTO mpx_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Inoke Mikal gogoginol etega i ahe ge i pakenuwa Deibid wana abakenuwa, yaka kaliko kekeisi goti pupunona elana hi ginoliya i teli kokowanaa ge kama etega i ahe i pahabobu. ");
INSERT INTO mpx_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Sol bolau i patunal hi nok tage Deibid nihi lib, yaka Mikal i baek elal i ba, “Deibid i kasiyebwa, iyoho i kenukenu wana abakenuwa.” ");
INSERT INTO mpx_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Yaka bolau o hi na Sol wana wasa hi pek, inoke i patunal hi sikal Deibid nihi kite. He i baek elal i ba, “Nuku kalivai wana abakenuwa ge nuku pwatanim eliyau na lopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Yaa sauga hi tuk limi gamwanaa, gogoginol hi kite Deibid wana abakenuwa ginebi ge goti pupunoliya i minaa kokowanaa. Yaka hi na Sol wana wasa hi pek. ");
INSERT INTO mpx_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Inoke Sol Mikal i yogaan ge i neli i ba, “Hauna kaiwena u kakaweyau ge o huga gamagalina u palou ge i egon?” Tamana anana i lahe i ba, “I ba palovakunau te ebo nige na lalabe ge ni lolou, yaka ni lopaaligau.” ");
INSERT INTO mpx_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","He sauga Deibid i lou, yaka i na Samuwela elana panuwa Lama ge bugul gegewena toto Sol i ginol elana i wasaan. Yaka alona hi egon hi na awan Naiyot ge hi miminaa to. ");
INSERT INTO mpx_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Gamagalau enuna Sol wana wasa hi pek hi ba, “Deibid iyoho awan Naiyot panuwa Lama.” ");
INSERT INTO mpx_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Yaka bolau enuna i patunal hi nok tage nihi lib. Yaa sauga hi vin, inoke Samuwela hi kite palopitau ali boda etega i houwaagil Yabowaine Yayaluwana wana gasisi elana hi wonawona ge hi sagasaga. Yaka Yabowaine Yayaluwana i lau bolau o elal inoke heliya al ge hi wonawona ge hi sagasaga. ");
INSERT INTO mpx_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Sauga Sol wasaliya i hago, yaka bolau enuna al i patunal hi nok, inoke heliya al ge Yabowaine Yayaluwana wana gasisi elana hi wonawona ge hi sagasaga. Yaka paetonina bolau enuna i patunal hi nok, yaa pagan maisena o i gan al eliyalil. ");
INSERT INTO mpx_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Mowamowasena, Sol totona i egon i nanawa panuwa Lama kaiwena. Sauga i na i vin wewel kenken bwabwatana etega elana panuwa Seku, inoke gamagaliliyau i nelil i ba, “Samuwela alona ge Deibid ga hi miminaa?” Anana hi lahe hi ba, “Heliya iyoho panuwa Lama awanina Naiyot.” ");
INSERT INTO mpx_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Iya iyoho kamwasaa i nanawa Naiyot kaiwena, yaka Yabowaine Yayaluwana i lau elana inoke i nonowonawona ge i nonosagasaga ana siga i na i vin awan Naiyot. ");
INSERT INTO mpx_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Inoke ana kaliko enuna i palo yohil tuwana i pabokaboka, yaka i wonawona ge i sagasaga Samuwela manininaa. Yaka i tal kenu bilibiliya, inoke lan ge bulin bwabwaligena i kenukenu i ola to. Pagan o i gan elana, yaka gamagalau wali baaba etega hi babaa, “Bi ola ge Sol iya al palopita avaliya etega?” ");
INSERT INTO mpx_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Yaka Deibid i louem awan Naiyot panuwa Lama i na Diyontan elana ge i neli i ba, “Hauna ya ginol panak? Hauna gegi ya ginol tamwam elana ge nuwana ni lopaaligau?” ");
INSERT INTO mpx_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Anana Diyontan i lahe i ba, “Nigeya! Nige nu aaliga! Hauna ebo nam ni ginol, ebo bwabwatana o kekeisi, nasi no wasa ni pem ga. Binimala nuwana ni ginol ola o, nige ni susume eliyau. He nige ni oola!” ");
INSERT INTO mpx_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Yaka Deibid i baek Diyontan elana i ba, “Tamwam i atena te u yaliyaya-agau bubun, inoke nige wam wasa ni pepewa hauna ebo nuwana ni ginol eliyau, eba nuwam ni apanak. Ya papasila Yehoba yawalina gaganina alanaa ge owa alamwa, nau aliga ana mwa.” ");
INSERT INTO mpx_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Inoke Diyontan i ba, “Hauna ebo nuwam, yaka nu ba ge na ginol kaiwem.” ");
INSERT INTO mpx_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Anana Deibid i lahe i ba, “Bwaligumwa weikena vavaluna hagalena ana lan, he binimala alou tamwam naha aanan. Yaa u talamwagau na na uleya na bunsumi ge na miminaa ga o ana siga bolu bulin ni gan. ");
INSERT INTO mpx_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Ebo tamwam ni kite pwawa nau nigeya ge ni nel kaiweu, yaka nu baek elana nu ba, ‘Deibid i awanun nabinabi elau te na talamwan etimwawa ni na wana panuwa Bedeliyema, kaiwena alonau ge ana un bwalibwaligel powon nihi ginol, toto baliman maisena ge maisena hi giginol.’ ");
INSERT INTO mpx_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Ebo ni ba, ‘I waisi,’ he nu atena te nau wam totuwalali iyaka ya mwal. Yaa ebo ni huga, he nu atena wana nuwatu i gasisi te ni apanakau. ");
INSERT INTO mpx_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Yaa owa wam pagan ni waisi nau wam totuwalali elau, kaiwena alou owa ta pebabateli-agila Yehoba matanaa. Ebo u nuwatu nau nak ya ginol tamwam elana, he totom nu lopaaligau! Yaa bahi nu teteleyau tamwam nimanaa.” ");
INSERT INTO mpx_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Anana Diyontan i lahe i ba, “Nigeya, nige ni oola! Binimala kekeisi na atena nam wana nuwatu i gasisi te ni apanakiwa, yaka tunahot wam wasa na pewa.” ");
INSERT INTO mpx_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Yaka Deibid i neli i ba, “He nasi ga na atena ola ebo tamwam i huga wam baaba kaiwena?” ");
INSERT INTO mpx_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Inoke Diyontan i baek Deibid elana i ba, “U nem ta na ta nawanawa uleya.” Yaka ali toto labui hi nok to. ");
INSERT INTO mpx_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Yaka Diyontan i baek elana i ba, “Ya bateli Yehoba, kila Isileli wala Yabowaine matanaa, nam amnana kaiwem na anbose ga mulaa abwe bolu ni ola te sauga e. Ebo i yaliyaya kaiwem, tunahot wam wasa na patunawa ge nu atena. ");
INSERT INTO mpx_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Yaa ebo nuwana ni apanakiwa, he ebo nige wam wasa na pepewa ge nu lolou, ya awanun Yehoba lahi pupulowanina hot ni ginol eliyau. Ya awanun Yehoba ni minaa elam ni ola valila i miminaa nam elana. ");
INSERT INTO mpx_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Yawaliu miminana nu atilomwan-agau ni ola Yehoba wana atilomwan, yaka bahi na aaliga. ");
INSERT INTO mpx_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","I ola al, wam atilomwan bahi ni momowasi natuwau ge tubuwau elal, bwagana ebo Yehoba am topihigelgel gegewel ni pwamowasel panayawi pwatanaa.” ");
INSERT INTO mpx_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","He Diyontan alona Deibid hi pebabateli-agil i ola to, ge Diyontan i ba, “Ya awanun am topihigelgel Yehoba ni lahel.” ");
INSERT INTO mpx_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Ge Diyontan i ba Deibid wana bateli gasigasisena iya ana nunuwana kaiwena ni baunan pavavaluna, kaiwena Diyontan Deibid i nunuwana-an i ola totona i nunuwana-an. ");
INSERT INTO mpx_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Yaka Diyontan i baek Deibid elana i ba, “Bwaligumwa weikena vavaluna hagalena ana lan. Owa wam abamisiyo nasi ni enonovan, inoke nam ni kite pwawa ge ni nel kaiwem. ");
INSERT INTO mpx_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Bolu bulin ni gan nu na labi toto valila u bunsumiya ge nu matamatan pat bwabwatana alana Esel labenaa. ");
INSERT INTO mpx_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Abwe na nowa yaka no egipoyo na ahe gau eton na alihinek pat o labenaa, ni ola tage nuwau bugul etega na howa. ");
INSERT INTO mpx_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Yaka geman etega na patuna ni na gau ni loyaagil. Ebo na baek elana na ba, ‘He gau heliya iyahe tei labem i nem elau, nu ahel ge nu pwatanim hiwe,’ inoke owa nu sikalim. Ya papasila Yehoba yawalina gaganina alanaa, nasi nu mwal nige nak nu pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Yaa ebo na baek geman elana na ba, ‘He gau heliya iyoho to awomwa o,’ yaka nu lou, kaiwena Yehoba i papatunawa nu egon. ");
INSERT INTO mpx_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","He bateli toto owa ge nau ta ginol, Yehoba iyaka i hago ge ni kite hilihili-agila sauga gegewena nige ni momowasi.” ");
INSERT INTO mpx_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Inoke Deibid i na i bunsumi uleya. Weikena vavaluna ana lan hagalena ana sauga iyaka i pwawa, inoke kin Sol i na i misiyo abaanan elana. ");
INSERT INTO mpx_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","He Sol i misiyowa baba punaa i ola sauga gegewena i giginol. Diyontan i misiyo awona i noek tamana elana, ge Abna i misiyowa Sol bebenaa, yaa Deibid wana abamisiyo i enonovan. ");
INSERT INTO mpx_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Lan o Sol nige baaba etega i babaunan, kaiwena i nuwatu i ba, “Tabam bugul etega i gan ge Deibid i pabiki, inoke nige bosowaina ni nem tapwalolo enowana ya elana.” ");
INSERT INTO mpx_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Weikena vavaluna ana lan eluwana elana Deibid wana abamisiyo i enonovan al. Yaka Sol i baek Diyontan elana i ba, “Ga i ola nolu ge lan e Diyesi natuna nige i nenem avala ta aanan?” ");
INSERT INTO mpx_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Anana Diyontan i lahe i ba, “Deibid i awanun nabinabi elau te na talamwan ni na Bedeliyema. ");
INSERT INTO mpx_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","I ba, ‘U talamwagau na nok no panuwaa, kaiwena o un bwalibwaligel powon etega nihi ginol ge taliu i ba bahi na kakala. Ebo u yaliyaya-agau, u sokalau na na taliwau na kitel.’ Heiya te kaiwena nige i nenem kin wam hagali enowana elana.” ");
INSERT INTO mpx_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Sol i huga nabi hot, yaka i baek Diyontan elana i ba, “Owa yova toganawal ge toawatautau natuna! Ya atena u olak Deibid elana, yaka totom am puluwawi ge hinam i pamasaliwa ana puluwawi u awaginol. ");
INSERT INTO mpx_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Deibid yawalina miminana owa nige nu tatabwa kin ge nige wam abalogugui ni gagan. He bolau enuna u patunal nihi na nihi en pwatanim eliyau, yaka na lopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Yaka Diyontan i nel tamana elana i ba, “Hauna gegi i ginol ge kaiwena nu lopaaliga? Hauna i ginol panak?” ");
INSERT INTO mpx_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Inoke Sol wana gau i alihinek Diyontan elana tage ni howa paaliga. Yaka i atena te tamana i nuwamut nuwana Deibid ni lopaaliga. ");
INSERT INTO mpx_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Diyontan i huga nabi ge abaanan i lut luwai. He weikena vavaluna ana lan eluwana o nige enona etega i aan, kaiwena nuwana i nak te tamana wana ginol nanakina Deibid alana i teli lowan. ");
INSERT INTO mpx_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Lan i gan mweluluga, Diyontan geman etega i ahe alona hi na Deibid elana i ola valila wali liwaliwan. ");
INSERT INTO mpx_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Yaka i baek geman elana i ba, “U tapalelu nok ga, yaka gau bolo na alihin nu loyaagil.” Sauga geman i tapalelu nok inoke Diyontan gau etega i alihin i alinago i na i tal laha. ");
INSERT INTO mpx_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Geman i vin labi toto gau i tala inoke Diyontan i yoga elana i ba, “He gau iyoho to awomwa o.” ");
INSERT INTO mpx_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Inoke i yoga vevehe al i ba, “Etimwawa u nowa! Bahi veyaho!” Yaka geman i na gau i ahe ge i sikal i na i pek wana tonowak Diyontan elana. ");
INSERT INTO mpx_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Ginol o ana sapu geman nige i aatena, iyai te Diyontan ge Deibid. ");
INSERT INTO mpx_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Inoke Diyontan egipoyo ge gau i pek geman elana ge i ba, “U ahe u sikal panuwaa.” ");
INSERT INTO mpx_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Geman i egon enaa, inoke Deibid i tagilem pat bwabwatana labena yavanaa ge i kululu paeton Diyontan elana maninina i pahanalowanek bilibiliya. Hi peliblib-agil ge hi kahikahin, yaa Deibid i kahin nabi hot. ");
INSERT INTO mpx_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Yaka Diyontan i baek Deibid elana i ba, “U egon ginebi wam laumwal. He iyaka alou owa Yehoba alanaa ta pebabateli-agila ge ta ba, ‘Yehoba iyaka i hago ge iya ni kite hilihili-agila, i ola al tubutubumwau ge tubutubuwau ni kite hilihili-agil sauga gegewena nige ni momowasi.’” Inoke Deibid i egon ge Diyontan i sikal i na wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Yaka Deibid i na panuwa Nobi topowon Ahimelek elana. Sauga Ahimelek Deibid i kite, inoke i lovakun ge i ginu. Yaka i nel elana i ba, “Ga i ola ge u nomwaumwau? Ga i ola nige alom gamagal etega ku nenem?” ");
INSERT INTO mpx_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Anana Deibid i lahe i ba, “Kin Sol i patunau wana tuwalali etega kaiwena, ge i baem elau i ba, ‘Bahi wam nok puna nu babaunan gamagal etega elana ge ni aatena.’ He iyaka ya ba o hevalau elal abwe nihi nem nihi kiteyau labi etega elana. ");
INSERT INTO mpx_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Hauna aanan ona hi gan eliyam? Beleid nimala panuna, o ebo aanan etega al toto i gan nu pem.” ");
INSERT INTO mpx_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Yaa anana topowon i lahe i ba, “Nige beleid getoga etega i gagan, iyai ya te beleid bwabwalena toto valila ha teliya Yehoba manininaa. Ebo nolu ge lan ebe am hevalau nige aloliyau yowau hi kekenu, he bosowaina nu ahel ge nuku an.” ");
INSERT INTO mpx_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Anana Deibid i lahe i ba, “Ee, nolu ge lan ebe nige alomeyau yowau ha kekenu. Kaiwena sauga ebo ha tatagil inoke ha ola to. Bwagana ebo ha nok tuwalali toto nige i bwabwalena kaiwena, hevalau tuwaliya hi pwabwabwalena. Inoke tunahot nihi ola al lan ebe ana tuwalali kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Inoke topowon beleid bwabwalena i pek elana, kaiwena nige beleid getoga i gagan. Beleid bwabwalena ya te i gan, toto valila hi teliya teibol pwatanaa Yehoba manininaa ge iyaka hi ahe ge lahena beleid kalakalasina hi teli. ");
INSERT INTO mpx_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","He lan o Sol wana sipi ali tomatahikan wali tohouwa alana Doegi gagama Idom iyoho to, i nem tapwalolo paganina etega i awaawaginol. ");
INSERT INTO mpx_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Yaka Deibid i nel Ahimelek elana i ba, “Tab gau o ebo haveyan kilepana etega i gan e? Kin Sol i patotoya-agau tuwalali ya kaiwena, yaka nige bosowaina no haveyan kilepana o ebo elohaveyan etega al na ahe.” ");
INSERT INTO mpx_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Anana topowon i lahe i ba, “Golaiya Pilistiya gamagalina, toto valila u lopaaligaa Elaa abwabwina elana, wana haveyan kilepana iyahe te, hi os kama elana ge hi teliya ipod enaa. Ebo nuwam, he nu ahe. He nige haveyan kilepana etega al i gagan te.” Yaka Deibid i ba, “Waiwaisana hot! Nige etega i gagan ge toto o ni waisi lake. He u pem elau.” ");
INSERT INTO mpx_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Yaka lan o Deibid Sol i louwi i na i miminaa Akis elana, iya panuwa Gat wali kin labi Pilistiya gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Yaa Akis wana totuwalali alaliya bwabwatana hi baek elana hi ba, “Tau ya iya Deibid, labi Isileli wali kin. He iya te hi wonawona kaiwena wali sagasaga elana hi ba, ‘Sol tausan hi gewi i lolil,   ge Deibid ten tausan hi gewi i lolil.’” ");
INSERT INTO mpx_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Wali baaba Deibid i panuwanuwatu-an, yaka i lovakun nabi kin Akis ga ni ginol ola elana. ");
INSERT INTO mpx_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","I minaa wali logugui gabulanaa, inoke mataliyaa i kakawi tage i kokona, yaka i lolokilkil bwagabwaga panuwa ana gana ana nog tuwanaa ge gilolona i pasulu lau awana basina elana, i ola tokokona wali ginol. ");
INSERT INTO mpx_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Kin Akis i kite, yaka i baek wana totuwalali alaliya bwabwatana elal i ba, “Ku kite! Tau ya i kokona! Ga i ola ge ku pwatanim eliyau? ");
INSERT INTO mpx_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Age nige tokokona hi gagan no panuwaa? Ga i ola ge toto ya ku pwatanim ge kokona wali pagan i awaawaginol matawa? Bahi ni miminaa no limiya.” Inoke i patuna owani ge i egon. ");
INSERT INTO mpx_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Deibid i na i minaa ababunsumi elal ula kekevana gamwanaa ge oya elal panuwa Sip ana labi kekevana. Lan ge lan Sol i loyaloya kaiwena, yaa Yehoba nige Deibid i tatalamwan Sol nimanaa. ");
INSERT INTO mpx_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Sauga Sol Pilistiya wali tolohaveyan i takel yohil ge i sikal, inoke wana wasa hi pek hi ba, “Deibid iyoho panuwa En-Gedi ana labi kekevana elana.” ");
INSERT INTO mpx_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Inoke tolohaveyan waiwaisal ali gewi tili tausan (3,000) i ahel Isileli gegewel gamwaliyaa, yaka alonau hi egon hi na Deibid ge wana hevalau nihi loyaagil Goti Bekikil ali Pat ana labiya. ");
INSERT INTO mpx_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Sauga hi na hi vin sipi ali gana enuna elal kamwasa bebenaa, gol etega iyoho to, inoke Sol i na i ulutuk ge ni kakamwasa. He Deibid ge wana hevalau heliya iyoho gol o gamwanaa, awaa hot. ");
INSERT INTO mpx_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Yaka wana hevalau hi walgumu elana hi ba, “He wam sauga waiwaisana te, ni ola te Yehoba iyaka i ba haba elam, i ba, ‘Am topihigelgel na teli nimwamwa, yaka hauna u nuwatu kaiwena nu ginol ya.’” Inoke Deibid i yawal nok i na Sol gegelinaa ge ana holahola yayapona buhuna i gotomwa yoho ge i ahe. Yaa Sol nige i aatena. ");
INSERT INTO mpx_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","He abwe Deibid atena i lomwan, i nuwatu binimala bahi Sol ana holahola buhuna ni gogotomwa yoho. ");
INSERT INTO mpx_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Sauga i sikal wana hevalau elal, inoke i baek elal i ba, “Ya awanun Yehoba ni labeyau ge bahi nau na giginol ni ola wami baaba ge no tonowak, iya Yehoba wana hilihili gamagalina, na aapanak, kaiwena Yehoba enonu i hol kokowanaa i tabwa kin.” ");
INSERT INTO mpx_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Deibid i ba ola o ge eliyana wana hevalau wali nuwatu i gotomwa, yaka nige i tatalamwagil Sol nihi lopaaliga. Yaka Sol gol i eguluwai ge i nawanawa. ");
INSERT INTO mpx_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Inoke Deibid i tagilem gol gamwanaa ge i yoga nok Sol elana i ba, “No babala ge no kin!” Sauga Sol i tagena matana i nok enaa, yaka Deibid i kululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Inoke i yoga nok Sol elana i ba, “Hauna kaiwena ge gamagalau bolo hi ba tage nuwau na apanakiwa wali baaba u hago? ");
INSERT INTO mpx_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","He lan ebe u kite matamwa nige i oola! Abwe sauga ya te gol e gamwanaa Yehoba i telewa nimwawa, ge no hevalau hi ba tage na lopaaligawa. Yaa nuwau i nakagiwa ge ya baek elal ya ba, ‘Bahi no tonowak na aapanak, kaiwena iya Yehoba wana hilihili gamagalina.’ ");
INSERT INTO mpx_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Nam, u kite, am holahola yayapona buhuna hiwe nimwawa e! Nau ya gotomwa yoho, yaa nige ya gogopaaligawa. Inoke nu atena te nige nak etega ya giginol ge ya aawatautau eliyam. Nige bugul etega ya giginol panak eliyam, yaa owa u loyaagau nuwam tage yawaliu nu pwamowasi. ");
INSERT INTO mpx_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Ya awanun Yehoba owa ge nau wala pagan ni kite hilihilian. Ge ya awanun iya pagan nanakina toto u ginol eliyau ni ginol lahe elam, yaa nau nige na giginol panak eliyam. ");
INSERT INTO mpx_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Tubulau wali baaba etega i ba, ‘Gamagalau nanakil heliya te pagan nanakina hi giginol.’ He i ola to, inoke nau nige na giginol panak eliyam. ");
INSERT INTO mpx_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","“Nau gamagal bwagabwaga ya, ya ola ya te wanuka alialigana o ebo nekalili, inoke ga i ola ge owa Isileli wali kin o lau u lau? ");
INSERT INTO mpx_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Ya awanun Yehoba ni payatalala ge ni kite hilihili-agila. Ya awanun o pulowan ni kite ge o logugui ni pasapu, inoke ni pwamwalauem nimwamwa.” ");
INSERT INTO mpx_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Sauga Deibid wana baaba i pwamowasi, yaka Sol i nel i ba, “Natu Deibid, owa anam ei?” Yaka i kahin anana i bwata. ");
INSERT INTO mpx_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Inoke i baek Deibid elana i ba, “Owa gamagal sasapona hot, nau gamagal nanakina. O hehegan u ginol bubun, yaa nau am hehegan ya apapanak-an. ");
INSERT INTO mpx_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Ginol waiwaisana toto u ginol eliyau, wasana abwe sauga ya u wasaan ya hago. He Yehoba i teleyau nimwamwa, yaa nige u gogopaaligau. ");
INSERT INTO mpx_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Ebo tau etega ana topihigelgel ni pwawa, tab ni sokal bwabwage, nige nak ni giginol elana? Nigeya! Yaa owa u ginol ola to elau! Ya awanun Yehoba mola waiwaisana ni pewa, kaiwena lan ebe u ginol bubun eliyau. ");
INSERT INTO mpx_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Ya atena bubun tunahot abwe nu tabwa kin ge Isileli wali abalogugui ni minaa wam logugui gabulanaa sauga gegewena. ");
INSERT INTO mpx_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","He Yehoba alanaa nu papasila te tubutubuwau ha mul nige nu pwapwamowasel, yaka bahi alau ni yayaomala o un elana.” ");
INSERT INTO mpx_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Inoke Deibid i bateli Sol eliyana i ola to. Yaka abwe Sol i sikal i na wana panuwaa. Yaa Deibid alonau ge wana hevalau hi na wali ababunsumi elana ula kekevana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","He Samuwela i aliga, yaka Isileli gegewel hi migogo ge wana yaomal kaiwena hi kahikahin. Inoke tuwana hi teliya wana panuwaa Lama. Yaka abwe Deibid i na i minaa labi kekevana alana Palan. ");
INSERT INTO mpx_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Sauga etega Sip gamagaliliyau enuna hi na Sol wana panuwaa Gibeya ge hi baek elana hi ba, “Deibid iyoho i bunsumi Oya Hakila, toto labi kekevana Diyesimon i awoni.” ");
INSERT INTO mpx_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Abisai i baek Deibid elana i ba, “Lan ya Yabowaine am topihigelgel i teli nimwamwa. Nu ba inoke totona wana gau elana alona ge bilibili na howa toyawel. Na howa kamwase ya, he nige na giginol palabuina.” ");
INSERT INTO mpx_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Yaka Sol i baek Deibid elana i ba, “Natu Deibid, Yehoba ni muloluagiwa! Tunahot hauna ebo nu ginol, nasi ni waisi ge nu gasisi.” Yaka Deibid i noegon ge Sol i sikal wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Inoke Akis i melteli Deibid elana, kaiwena atenaa i ba, “Iyaka wana pan Isileli ateliya i elolol iya kaiwena ge amnaliya i nakan, inoke nasi ni totuwalali elau sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Sauga o elana Pilistiya wali tolohaveyan hi pamigogoil panuwa Apek elana nihi na nihi haveyan Isileli elal. Kin Akis i baek Deibid elana i ba, “Nu atena bubun alomwau ge wam hevalau nuku tubwi eliyau, yaka alomeyau komiu ta haveyan Isileli elal.” ");
INSERT INTO mpx_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Inoke Deibid i baek elana i ba, “Ebo i ola, he totom abwe nu kite nau wam totuwalali ga na lohaveyan ola.” Inoke Akis i baek elana i ba, “Ebo i ola, he na telewa nu tabwa o tomatahikan sauga gegewena.” ");
INSERT INTO mpx_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","He valila Samuwela i aliga, yaka Isileli gegewel hi kahikahin kaiwena, inoke abwe tuwana hi teliya wana panuwaa Lama. I ola al, Sol iyaka tolosevasevan ge tokukula i paveyahol Isileli gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Pilistiya wali tolohaveyan hi pamigogoil i mowasi, yaka hi tukik hi na Isileli wali labiya hi holaviya panuwa Sunem. Yaa Isileli wali tolohaveyan gegewel Sol i pamigogoil, yaka hi na hi holaviya oya Gilbowa. ");
INSERT INTO mpx_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Sauga Sol matana i nok Pilistiya wali tolohaveyan i kitel, inoke i lovakun nabi ge atena i bwanabwana. ");
INSERT INTO mpx_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Yaka i nel Yehoba elana i ba, “Ga na ginol ola?” Yaa wana nel Yehoba nige i lalahe ebo kenonou elana, o ebo pat Ulim ge Tamim elal, o ebo palopitau eliyalil. ");
INSERT INTO mpx_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Yaka i baek wana totuwalali alaliya bwabwatal elal i ba, “Yova tolosevasevan etega nuku loyaan, yaka na na na nel eliyana ga na ginol ola.” Anana hi lahe hi ba, “Etega iyoho panuwa Endol.” ");
INSERT INTO mpx_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Inoke Sol kin ali galogaloi i palo kaliko getoga i galoi, yaka bahi ana awa gamagalau nihi eunaan. Bulina alonau ge wana tolohaveyan labui hi na yova elana, inoke i baek elana i ba, “Toaliga etega toto alana na lumen sevasevanina nu yogaan ge eliyana na pwawa ga na ginol ola.” ");
INSERT INTO mpx_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Yaa yova i baek elana i ba, “U atena te tolosevasevan ge tokukula Sol i paveyahol Isileli gamwanaa. Ga i ola ge u laboseyau ge o kota u ginol, yaka eliyana nihi lopaaligau?” ");
INSERT INTO mpx_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Inoke Sol i papasila i ba, “Ya papasila Yehoba yawalina gaganina alanaa, ebo nu ginol ola o, nige lahi etega nu pwapwawa.” ");
INSERT INTO mpx_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Inoke yova i nel elana i ba, “Henala sevasevanina na yogaan kaiwem?” Anana Sol i lahe i ba, “Samuwela.” ");
INSERT INTO mpx_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Inoke yova i ginol ola Sol wana baaba. Sauga Samuwela i kite, inoke i loi anana i bwata. Yaka i baek Sol elana i ba, “Hauna kaiwena u kakaweyau? He owa Sol.” ");
INSERT INTO mpx_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Yaka kin i baek yova elana i ba, “Bahi lovakun. No wasa ga nu pem, hauna gun u kite?” Yova i baek elana i ba, “I ola yabowaine etega ya kite i heem bilibili gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Yaka Sol i nel i ba, “Ana awa ga i ola?” Anana i lahe i ba, “I ola tonowak lilikena etega holahola yayapona i galoi.” Inoke Sol i atena Samuwela to, yaka i kululu maninina i pahanalowanek bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Samuwela i baek Sol elana i ba, “Hauna kaiwena u yogaagau ya nem inoke no minamina u apanak?” Anana Sol i lahe i ba, “I pulowan hot eliyau, kaiwena Pilistiya hi nem hi haveyan elau, i ola al Yehoba o en i pem. Sauga ebo na nel Yehoba elana, no nel nige i lalahe ebo palopitau eliyalil o ebo kenonou elana. Heiya te kaiwena ya yogaagiwa, yaka no wasa nu pem hauna binimala na ginol.” ");
INSERT INTO mpx_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Samuwela i baek elana i ba, “Yehoba iyaka am en i pewa, ge i tabwa am topihigelgel, inoke bahi nu nenel elau hauna binimala na ba nu ginol. ");
INSERT INTO mpx_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Yehoba iyaka i ginol eliyam i ola te valila i baem eliyau ge ya baunaniwa. Yehoba iyaka abalogugui i kukuyoho elam, ge i pek alom etega elana, he Deibid bana. ");
INSERT INTO mpx_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Lan ebe Yehoba i ginol i ola to eliyam, kaiwena nige wana baaba u hehenapu-an ge wana huga gamagaliliyau Amaleki u aapapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Bwaligumwa owa ge boda Isileli ni telemiu Pilistiya nimaliyaa, yaka alomwau ge natumwau bolau nihi lopaaligamiu inoke alowau komiu ta minaa Tuma. He Isileli wami tolohaveyan ni telel Pilistiya nimaliyaa ge nihi pakokovel.” ");
INSERT INTO mpx_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Sol baaba o i hago yaka i lovakun nabi, inoke sauga o elana i sogu i talpo bilibiliya. He tuwana i pweyata, kaiwena lan ge bulin bwabwaligena nige i aanan. ");
INSERT INTO mpx_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Yova i na Sol elana ge i kite te i lovakun nabi, inoke i baek elana i ba, “Tonowak, nau wam totuwalali yovana, yawaliu ya talamwan yaka ya ginol i ola hauna toto u baunan eliyau. ");
INSERT INTO mpx_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Inoke no baaba ga nu hago. Aanan enuna na pwatanim nu an ge tuwam ni gasisi yaka abwe nu nawanawa.” ");
INSERT INTO mpx_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Yaa Sol i towa, yaka i ba, “Nigeya! Nige na aanan.” Inoke wana tolohaveyan bolau labui heliya al avaliya yova hi ba balbalgig te ni anan, yaka abwe wali baaba i hago ge i talam. Inoke i lutem bilibiliya i na i misiyo abamisiyo pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Yova wana bulumwakau natuna tatabwana etega iyoho wana limiya, inoke etimwawa i na i tagapaaliga, yaka bunumwina enuna i liga. Inoke pwalawa i ahe i pitoli ge beleid nige alona yis hi vivikuhiya i umun. ");
INSERT INTO mpx_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Yaka i na aanan i teli Sol alonau ge wana tolohaveyan labui maniniliyaa ge hi anan. Hi anan haba, yaka bulin maisena o yova hi eguluwan ge hi sikal. ");
INSERT INTO mpx_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","He valila Pilistiya wali tolohaveyan gegewel hi pamigogoil panuwa Apek elana, ge Isileli wali tolohaveyan iyoho hi holaviya wewel bwanapitpit labenaa Diyeslil Abwabwina elana. ");
INSERT INTO mpx_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Sauga Pilistiya Apek hi eguluwan hi na Isileli wali labiya, wali tologugui wali ivan ona ali pwahin elulu bwagabwaga ge tausan maisena hi houwaagil ge avaliyau hi nawanawa. Deibid alonau ge wana hevalau avaliya kin Akis hi nawaa eliyaa. ");
INSERT INTO mpx_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Pilistiya wali tologugui hi kitel yaka hi nel Akis elana hi ba, “Hibilu bolo ya hi bwebwe e?” Analiya i lahe i ba, “Ku atena ya Deibid te, iya valila Isileli wali kin Sol wana totuwalali bwabwatana, yaa iyaka baliman maisena ge pwatanaa al alou ha mina. He i telipunaa lan toto Sol i eguluwan ge i nem ana siga sauga e, nige nak etega ya kikite pwawa eliyana.” ");
INSERT INTO mpx_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Yaa Pilistiya wali tologugui hi huga Akis elana yaka hi ba, “U patuna pasikal ni na ni minaa panuwa toto u pek elana. Bahi ni nenem alola ta nana haveyana, eba haveyan gamwanaa ni mipil ge ni tabwa ala topihigelgel. Ebo nuwana wana tonowak ni payaliyaya al, he kamwasa waiwaisana hot te kila wala tolohaveyan ni lolil. ");
INSERT INTO mpx_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","He iya te hi wonawona kaiwena wali sagasaga elana hi ba, ‘Sol tausan hi gewi i lolil,   ge Deibid ten tausan hi gewi i lolil.’” ");
INSERT INTO mpx_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Inoke kin Akis Deibid i yogaan i nok yaka i baek elana i ba, “Ya papasila Yehoba yawalina gaganina alanaa, owa wam pagan i sapu ge ya yaliyaya alou owa ta na haveyana. I telipunaa lan toto u nem eliyau ana siga sauga e, nige nak etega ya kikite pwawa eliyam, yaa no pan tologugui nige hi yayaliyaya kaiwem. ");
INSERT INTO mpx_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Inoke u sikal ginebi wam laumwal, yaa bahi bugul etega nu giginol ge no pan tologugui amnaliya nu aapanak.” ");
INSERT INTO mpx_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Yaa Deibid i nel i ba, “Hauna ya ginol panak? I telipunaa lan toto ya nem ana siga sauga e, hauna nak u kite pwawa nau wam totuwalali elau? Ga i ola nige bosowaina na nowa ge na haveyan no babala ge no kin ana topihigelgel elal?” ");
INSERT INTO mpx_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Anana Akis i lahe i ba, “Ya atena wam ginol i sapu i ola Yabowaine wana anelose etega, ge ya yaliyaya kaiwem. Yaa no pan tologugui hi ba, ‘Bahi ni nenem alola ta nana haveyana.’ ");
INSERT INTO mpx_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Inoke bwaligumwa mweluluga alomwau ge wam babala Sol wana totuwalali bolo alomwau ge ku nem elau etimwawa nuku lut. Sauga panuwa ni mwananal, yaka nuku egon.” ");
INSERT INTO mpx_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Hi kenu lan i gan mweluluga kekeisi, Deibid alonau wana hevalau hi lut ge hi egon nihi sikal labi Pilistiya. Yaa Pilistiya wali tolohaveyan hi novevehe hi na Diyeslil Abwabwina elana. ");
INSERT INTO mpx_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","I pulowan hot Deibid eliyana, kaiwena wana hevalau hi nuwaleyan hot lagoliyau ge natuliyau kaiweliya yaka hi ba, “Deibid ta loipati ni aliga.” Yaa gasisi i pwawaa Yehoba wana Yabowaine elana, yaka atena i matuwa. ");
INSERT INTO mpx_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Deibid i baek topowon Abaiyada elana i ba, “Am holahola ipod u galoi ge u nem elau.” Inoke i galoi ge i nok, ");
INSERT INTO mpx_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","yaka Deibid i nel Yehoba elana i ba, “Tokaluoyaoya ya na takel o bahiwa? Tab na kukuhikagil o nigeya?” Anana Yehoba i lahe i ba, “E, nu takel. Tunahot nu kukuhikagil ge bolo hi libil nu pwamwalil.” ");
INSERT INTO mpx_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","Yaka Deibid alonau wana hevalau ali gewi sikis handeled (600) hi nok. Sauga hi vin sinawel Besol, ali gewi tu handeled (200) hi minaa to, kaiwena tuwaliya i aliga nabi, nige bosowailiya opopwina nihi kalapanet-an ge nihi mwena ha labi etega al. Yaa Deibid alonau wana hevalau ali gewi po handeled (400) hi petaki vevehe tokaluoyaoya eliyaa. ");
INSERT INTO mpx_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Analiya Deibid i lahe i ba, “Taliwau, bahi nuku oola! Ku kite hauna Yehoba i pem elala! He iya i matahikagila, yaka ala topihigelgel bolo valila hi kaluoyaoya elala, i telel nimalaa. ");
INSERT INTO mpx_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Inoke nige bosowaina anamiu naha hago! He gamagal toto i misikal bugubugul i matahikan ana gabom ni olaolaek gamagal toto i na i lohaveyan ana gabom. Ali gabom ni olaolaek ya.” ");
INSERT INTO mpx_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Inoke Deibid logugui i pagasisi i ola to, i tabwa Isileli ali logugui ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Pilistiya hi haveyan Isileli elal oya Gilbowa elana. Yaka Isileli hi louem elal ge hi gewi hi lopaaligaliya to. ");
INSERT INTO mpx_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","He hi petaki Sol ge natunau eliyaa nige ali bwaga, yaka natunau bolau Diyontan, Abinadab, ge Malki-Suwa hi lopaaligal. ");
INSERT INTO mpx_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Pilistiya hi haveyan gagasisi Sol eliyana, yaka toloegipoyo gau hi alihin Sol hi howa pwamwaun ge i lomwan nabi. ");
INSERT INTO mpx_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Inoke Sol i baek wana elohaveyan ana tokaval elana i ba, “Wam haveyan kilepana u momol tagilan abanaa yaka u howa paaligau. Bahi Pilistiya, heliya nige Yehoba hi aatena ge nige gotomwa yoho paganina hi aahe, nihi nenem tuwau nihi papalomwani ge nihi hohowa paaligau.” Yaa wana elohaveyan ana tokaval i lovakun nabi yaka nige i giginol. Inoke Sol totona wana haveyan kilepana i ahe, yaka i pamilil ge i soguek pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Sauga wana elohaveyan ana tokaval i kite Sol iyaka i aliga, inoke iya al ge wana haveyan kilepana i ahe i pamilil ge i soguek pwatanaa, yaka alona ge Sol hi aliga toyawa. ");
INSERT INTO mpx_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Inoke Sol alonau natunau bolau eton, i ola al wana elohaveyan ana tokaval ge wana tolohaveyan, gegewel hi aliga lan maisena o elana. ");
INSERT INTO mpx_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Isileli bolo hi minaa abwabwa Oya Gilbowa gabulanaa ge wewel Yolidani labi leunati, hi kite wali tolohaveyan iyaka hi lou, ge wasa hi hago Sol alonau ge natunau iyaka hi aliga. Inoke wali panuwa ona hi lou luwail, yaka Pilistiya hi na hi holavel. ");
INSERT INTO mpx_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Hi kenu lan i gan, yaka Pilistiya hi na Isileli bolo hi aliga wali bugubugul waiwaisal hi bugulan, inoke Sol ge natunau eton bwaliwawagal hi pwawal Oya Gilbowa elana. ");
INSERT INTO mpx_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Inoke Sol mwamwalina hi gotomwa ge wana elohaveyan hi bugulan. Yaka elopapatuna hi patunal hi na Pilistiya ana labi gegewena elal, inoke wana yaomal wasana hi wasaan wali yabowaineyau wali limi tapwalolowa ge gamagalau elal. ");
INSERT INTO mpx_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Wana elohaveyan hi teleliya wali yabowaine Astolet wana limi tapwalolo gamwanaa, ge tuwana hi pakuki panuwa Bet-San ana gana elana. ");
INSERT INTO mpx_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Panuwa Yabesi, iyoho labi Giliyad elana, wasa hi hago hauna Pilistiya hi ginol Sol elana, ");
INSERT INTO mpx_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","yaka wali tolohaveyan waiwaisal gegewel bulina hi nawanawa hi na hi vin panuwa Bet-San. Inoke Sol ge natunau tuwaliya hi ahe lowan panuwa ana gana elana yaka hi pwatanik wali panuwaa Yabesi ge hi tonil. ");
INSERT INTO mpx_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Yaka tutuwaliya hi ahe hi na hi yamwil abwakil tamalik gabulanaa ge nuwanak kaiwena ali galebu hi palahikan lan ana gewi seben. ");
INSERT INTO mpx_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Sol wana yaomal enaa liwanina i ola hiwe. He Deibid alonau ge ana hevalau iyaka boda Amaleki hi pakokovel ge hi sikal hi miminaa panuwa Siklag. Sol i aliga ge lan labui al i mowasi, ");
INSERT INTO mpx_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","yaka lan etonina elana abwe heval etega i noem labi toto Sol ge wana tolohaveyan hi lohaveyana ni na Deibid elana. Nuwanak kaiwena ana kaliko i kukuleli ge papakova i yoho heheyan kokowanaa. Sauga i na Deibid elana, yaka heval o awatauwan kaiwena i talpo bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Yaka Deibid i neli i ba, “Owa ga u neem?” Anana i lahe i ba, “Ya louem labi toto Isileli wali tolohaveyan hi lohaveyana.” ");
INSERT INTO mpx_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Inoke Deibid i baek elana i ba, “No wasa u pem haveyan wasana ga i ola?” Anana i lahe i ba, “Isileli wali tolohaveyan hi louem haveyana, ge hi gewi Pilistiya hi lopaaligal. I ola al, Sol ge natuna Diyontan iyaka hi aliga.” ");
INSERT INTO mpx_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Yaka Deibid i baek heval elana i ba, “Ga u atena ola tage Sol ge natuna Diyontan iyaka hi aliga?” ");
INSERT INTO mpx_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Yaka heval i liwan Deibid elana i ba, “Nau iyoho ya oya Gilbowa te Sol ya nopwawa wana gau puna i antawan bilibiliya ge i gena palalek elana. Yaka Pilistiya wali waga momomol ginebi ge ana tolohaveyan hi tapalelu nok kelaubwa nihi vin elana. ");
INSERT INTO mpx_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Inoke i tagena pil ge i kiteyau, yaka i yogaagau ge ya ba, ‘Tonowak, ga i ola?’ ");
INSERT INTO mpx_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","“Inoke i nelau i ba, ‘Henala owa?’ “Anana ya lahe ya ba, ‘Nau boda Amaleki gamagalina.’ ");
INSERT INTO mpx_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","“Inoke i awanun eliyau i ba, ‘U nem hiwe gegeliwa e yaka u gopaaligau, kaiwena bwagana yawaliu momolona, yaa i pulowan hot eliyau.’ ");
INSERT INTO mpx_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","“Inoke ya nok gegelinaa ge ya gopaaliga, kaiwena ya atena te iyaka hi howa bubun ge nige ni momolu. Kokowana ana hanahana ge nimana ana tovaha ya ahel, heliya hiwe ya pwatanim owa no babala eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Yaka nuwanak kaiwena Deibid ana kaliko i kukulelelian, ge ana hevalau hi ginol ola al to. ");
INSERT INTO mpx_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Inoke hi lonuwanak, hi kahikahin ge ali galebu hi palahikan, ana siga sabwelu i lobek, kaiwena Sol, natuna Diyontan, Yehoba wana tolohaveyan ge boda Isileli iyaka hi aliga haveyan kilepana elana. ");
INSERT INTO mpx_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Yaka Deibid heval i neli i ba, “Hapanuwa gamagalina owa?” Anana i lahe i ba, “Nau boda Amaleki gamagalina ge ya mibwabwali labi Isileli.” ");
INSERT INTO mpx_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Inoke Deibid i ba, “Ga i ola ge nige u lolovakun? Yaka binimala Yehoba wana hilihili gamagalina bahi nu aapanak.” ");
INSERT INTO mpx_vpl VALUES ("S21_15","011_1_15","2SA","1","15","16","Yaka Deibid i ba vevehe al i ba, “Wam gegi lahena nu aliga, kaiwena totom u wasaagiwa te u ba, ‘Yehoba wana hilihili gamagalina iyaka ya gopaaliga.’” Inoke wana hevalau avaliya etega i yogaan ge i baek elana i ba, “U nok u na u gopaaliga.” Yaka wana haveyan kilepana elana heval o i gopaaliga. ");
INSERT INTO mpx_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","Kahin wonana ya Deibid i wonaan Sol alona ge natuna Diyontan kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","Inoke i ba nihi panpankiti-an un Yuda gamagaliliyau eliyalil. He alana Egipoyo Wonana ge iyoho Yasa i leli lowan wana buki gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","O Isileli, wala toematana bwaliwawagal iyoho wala oya pwataliyaa.   I bwe ge wala toasiyala hi pasogol! ");
INSERT INTO mpx_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Bahi nuku baubaunan panuwa Gat gamwanaa,   o ebo nuku wawasaan Askelon ana kamwasa elal, eba Pilistiya yowauiliyau nuwaliya ni waisi,   ge bolo nige Yehoba hi aatena wali yowau nihi yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","O labi Gilbowa oyana, bahi kehe ge bekubeku hunhunina ni lalau eliyam,   ge bahi bibilem enona ni gagan. Kaiwena toasiyala hi aligaa tei, ge wali ligovan i mibwagabwaga bilibiliya;   Sol wana ligovan iyahe tei nige al nihi papaenonu. ");
INSERT INTO mpx_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Diyontan wana egipoyo gauina hi lilimwaun   yaka tolohaveyan gasigasisel tuwaliya hi howa. Sol wana haveyan kilepana nige i sisikal abanaa enoenovana,   yaa ana topihigelgel saliyaliya i lau hi aliga. ");
INSERT INTO mpx_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Gamagalau Sol ge Diyontan yawaliliya miminana elana hi nunuwana-agil bubun,   ge yaomal elana hi aliga toyawa. Bwasumu magisubu hi mweyaha lakel   ge laiyoni hi gasisi luwagil. ");
INSERT INTO mpx_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Isileli yowauiliyau,   Sol baena nuku kahin, kaiwena kaliko waiwaisana matana keketina elana i pagaloimiu,   ge tuwan ana isela gold hi ginoliya elana i paiselamiu. ");
INSERT INTO mpx_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","I bwe ge wala toasiyala hi pasogol haveyana!   Diyontan bwaliwawagana iyoho wala oya pwataliyaa. ");
INSERT INTO mpx_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Taliu Diyontan, nuwau i nak nabi kaiwem,   kaiwena ya nunuwanagiwa ge wam nunuwana nau kaiweu i getoga hot,   i lake te yova wana nunuwana lagona elana. ");
INSERT INTO mpx_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","I bwe ge wala toasiyala hi pasogol!   Wali elohaveyan hi eguluwagil nige al ali waisi. ");
INSERT INTO mpx_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Sauga etega al, Deibid i nel Yehoba elana i ba, “Tab na sikal na na labi Yuda panuwana etega elana na minaa?” Anana i lahe i ba, “E, nu sikal.” Yaka Deibid i nel al i ba, “Hauna awan elana na minaa?” Anana i lahe i ba, “Panuwa Hebiloni.” ");
INSERT INTO mpx_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Inoke Deibid lagonau labui i ahel alonau, etegana Ahinoam Diyeslil yovana ge labuina Abigeil Nabal gagama Kamel abuabulina. ");
INSERT INTO mpx_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","I ola al ana hevalau avaliyau lagoliyau ge natuliyau i ahel hi na hi minaa Hebiloni ge awanina ona elal. ");
INSERT INTO mpx_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Yaka Yuda bolauiliyau hi na Hebiloni, inoke enonu hi hol Deibid kokowanaa i tabwa boda Yuda wali kin. He Deibid wasa i hago te Yabesi, iyoho labi Giliyad, bolauiliyau Sol tuwana iyaka hi ahe ge ga hi teli ola. ");
INSERT INTO mpx_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","Inoke elopapatuna i patunal hi na elal ge hi ba, “Yehoba ni muloluagimiu, kaiwena wami tonowak Sol tuwana ku ahe ge ku teli, inoke eliyana wami nunuwana iya kaiwena ku pamasal. ");
INSERT INTO mpx_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","Inoke ya awanun Yehoba wana nunuwana ni pamasal hikahikani eliyamiu. Nau al ge ginol waiwaisana toto ku ginol Sol elana lahena na ginol bubun eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","He wami tonowak Sol iyaka i aliga ge Yuda enonu hi hol kokowawa iyaka ya tabwa wali kin, inoke atemiu ni matuwa ge nuku lohaveyan gagasisi.” ");
INSERT INTO mpx_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","(He Sol natuna Diyontan natuna tauina etega i gan alana Mepiboset, iya wana baliman nimala panuna abwe aena labui hi nak. He saugena o Sol ge Diyontan wali yaomal wasana i noem labi Diyeslil, yaka ana tomatahikan i kalivai ge hi lou. Yaa patotoya kaiwena inoke i pwabun ge abwe aena hi nak, nige bosowaina ni nawanawa bubun.) ");
INSERT INTO mpx_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Sauga etega al abwe Isileli ali un gegewel hi na Deibid hi kite panuwa Hebiloni ge hi baek elana hi ba, “Tunahot ama tutuma owa. ");
INSERT INTO mpx_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Valila Sol iya wama kin, yaa owa te ama Isileli wama tolohaveyan u nunulil haveyan elal. Ge Yehoba i baewa elam i ba, ‘Owa bwaliga nu ola sipi ali tomatahikan no gamagalau Isileli kaiweliya, ge nu tabwa wali tohouwa.’” ");
INSERT INTO mpx_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Inoke Hebiloni elana Deibid alonau ge Isileli wali tonowakau hi pebaabateli-agil Yehoba matanaa, yaka enonu hi hol kokowanaa i tabwa wali kin. ");
INSERT INTO mpx_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Deibid wana baliman teti (30) te i tabwa kin, yaka i logugui baliman ali gewi poti (40). ");
INSERT INTO mpx_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Hebiloni elana Yuda i logugui-agil baliman seben ge waikena sikis, yaka abwe Yelusalema elana Isileli ge Yuda gegewel i logugui-agil baliman teti tili (33). ");
INSERT INTO mpx_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Deibid wana tolohaveyan i nulil hi na Yelusalema nihi lohaveyan Yebusi elal, heliya labi o towohiliyau. Heliya hi nuwatu tage Deibid nige bosowaina ni tuk wali panuwaa, yaka hi ba hanaha elana hi ba, “Nige nuku tutuk wama panuwaa. Bwagana tomatakai ge bolo aeliya i kom, bosowailiya ya te nihi palimiu.” ");
INSERT INTO mpx_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Bwagana hi ba ola o, yaa Deibid ge wana tolohaveyan hi tuk ge wali sivesive Saiyoni hi ahe, yaka abwe alana hi tun Deibid wana Panuwa. ");
INSERT INTO mpx_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Mulaa abwe hi tuk hi haveyan, he lan o elana Deibid i ba, “Ebo nuwala Yebusi ta pakokovel, inoke ta uluhek gol kenken toto wewel ana abawagi elana, yaka eliyana avalau ‘bolo aeliya i kom ge tomatakai’ o ta petupatupa-agila, heliya o topihigelgel.” Deibid i ba ola o, heiya te kaiwena gamagalau wali baaba etega hi babaa, “Tomatakai ge bolo aeliya i kom bahi nihi tutuk kin limena elana.” ");
INSERT INTO mpx_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Sauga wali sivesive Deibid i ahe, inoke i na i minaa ge alana i tun Deibid wana Panuwa. Yaka abwe panuwa i tal painan pwabwata, i telipunaa labi toto bwana hi ken ginolil labilabiya mwalu kaiweliya ge i tal tuk panuwa gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Yaka Deibid wana gasisi i bwatabwata ya, kaiwena Yehoba Yabowaine Togasisi Hot i minaa elana. ");
INSERT INTO mpx_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Panuwa Taya wali kin alana Hilam wana elopapatuna i patunal hi na Deibid elana, ginebi ge abwakil sida ge limi ana totaltal, bolo ebwakil elana ge bolo pat elana. Yaka kin limena hi tal Deibid kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Inoke Deibid iyaka i atena te Yehoba i patunahot iya i kin Isileli elal, ge wana abalogugui alana i pwabwata wana gamagalau Isileli wali waisi kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Sauga Deibid panuwa Hebiloni i eguluwan i na i minaa Yelusalema, inoke yowau hi gewi al i alolon-agil, enuna lagonau hot, ge enuna lagonau al. Inoke natunau bolau ge yowau hi gewi al hi abil. ");
INSERT INTO mpx_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","He natunau bolau bolo hi abiliya to alaliya i ola hiwe: Samuwa, Sobab, Neitan, Solomon, ");
INSERT INTO mpx_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","Ibhal, Elisuwa, Nepeg, Yapiya, ");
INSERT INTO mpx_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","Elisama, Eliyada ge Elipelet. ");
INSERT INTO mpx_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Sauga Pilistiya wasa hi hago te Isileli enonu hi hol Deibid kokowanaa i tabwa wali kin, inoke wali tolohaveyan gegewel hi tagil hi na hi loyaan. Wasaliya Deibid i hago, inoke i na ababunsumi elana. ");
INSERT INTO mpx_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","He Pilistiya iyaka hi nem hi holaviya Abwab Lepaim ge hi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Yaka Deibid i nel Yehoba elana i ba, “Na nok na lohaveyan Pilistiya elal o bahiwa? Tab nu telel nimwawa?” Anana Yehoba i lahe i ba, “E, nu nok. Tunahot na telel nimwamwa.” ");
INSERT INTO mpx_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Inoke Deibid alonau wana tolohaveyan hi na panuwa Bal-Pelasim avaliyau Pilistiya hi lohaveyan ge hi pakokoveliya to. Yaka i ba, “Yehoba o topihigelgel i tagalekaleka-agil maniniwa i ola banata gasigasisena.” Inoke heiya te kaiwena panuwa o alana i tun Bal-Pelasim. ");
INSERT INTO mpx_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","He Pilistiya wali yabowaineyau gogoginol hi lou luwagiliya to, yaka Deibid ge wana tolohaveyan hi kalivail egonagil. ");
INSERT INTO mpx_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Sauga etega al abwe Pilistiya hi sikal hi holaviya Abwab Lepaim ge hi pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Inoke Deibid Yehoba i neli ga ni ginol ola. Wana nel i lahe i ba, “Bahi nuku nonopasapu elal, yaa nuku nopain eliyaa, yaka abwe nuku tuk nuku haveyan elal abwakil popla awoliyaa. ");
INSERT INTO mpx_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Sauga ebo butun nuku hago abwakil popla lamwaliyaa ni ola tolohaveyan aeliya butuna, yaka etimwawa nuku tuk nuku haveyan elal. Kaiwena nau Yehoba na nohouwa awomiwa Pilistiya wali tolohaveyan na lolil.” ");
INSERT INTO mpx_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Yaka Deibid i ginol ola Yehoba wana baaba, inoke alonau ge wana tolohaveyan Pilistiya hi takel ge hi mimi lololil, i telipunaa panuwa Gibiyon i na ana siga panuwa Gesel. ");
INSERT INTO mpx_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Sauga etega Deibid Isileli wali tolohaveyan bolo waiwaisal ali gewi teti tausan (30,000) i yoga gogonil ");
INSERT INTO mpx_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","ge hi nok hi na panuwa Bala labi Yuda. Yaka Deibid alonau wana gamagalau gegewel hi egona panuwa o tage Yabowaine wana Bateli ana Dedewaga nihi aheya o nihi pwatanik Yelusalema. Dedewaga o alana hi tun Yehoba Togasisi Hot wana Bateli ana Dedewaga, iya i minaa pwatanaa bwasumu labui opeliya gaganina ali luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","He Yabowaine wana Bateli ana Dedewaga hi ahem Abinadab wana limiya, i miminaa oya etega elana, inoke hi usana waga momomol vavaluna etega gamwanaa. Abinadab natunau bolau labui, Usa ge Ahiyo, heliya waga momomol hi matahikan, ");
INSERT INTO mpx_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","toto Yabowaine wana Bateli ana Dedewaga iyoho pwatanaa. Ahiyo i nohouwa waga momomol ge bulumwakau awoliyaa i kelauni. ");
INSERT INTO mpx_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Yaka Deibid alonau Isileli gegewel ginebi wali gasisi bwalibwaligena hi yaliyaliyaya Yehoba matanaa. Egalagalavenu hapi tomaha ona, tambalin, kal ge simbol hi galavenuagil, yaka hi sagasaga ge hi wonawona. ");
INSERT INTO mpx_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Sauga hi vin Nakon wana witi musana ana abaasiasi elana, yaka bulumwakau hi hanagegegi kelaubwa nihi sogu. Inoke Usa nimana i paelu Yabowaine wana Bateli ana Dedewaga i pihikan bahi ni sosogu. ");
INSERT INTO mpx_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Yaa Usa i gegi to, kaiwena Bateli ana Dedewaga ana logugui nige i hehenapu-an. Yaka toto o elana Yehoba i huga, inoke Usa i lol ge i aligaa to Yabowaine wana Bateli ana Dedewaga bebenaa. ");
INSERT INTO mpx_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Yaka Deibid i huga, kaiwena Yehoba tinena i lut Usa elana ge i tagapaaliga. Inoke panuwa o alana i tun Peles-Usa, yaka gamagalau alan o hi mimi lumelumen ana siga lan ebe. ");
INSERT INTO mpx_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Yaa lan o elana Deibid Yehoba i lovakunan ge i ba, “Iyaka nige bosowaiu Yehoba wana Bateli ana Dedewaga na ahe ni minaa elau.” ");
INSERT INTO mpx_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Yaka nige nuwana Yehoba wana Bateli ana Dedewaga ni ahe ni pwatanik Deibid wana Panuwaa, yaa i na i teliya gagama Gat, Obed-Idom wana limiya. ");
INSERT INTO mpx_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","He waikena eton i miminaa to, yaka Yehoba Obed-Idom ge wana limi ana heniheni gegewel i mulolu-agil. ");
INSERT INTO mpx_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Yaka abwe kin Deibid wana wasa hi pek hi ba, “Yehoba Obed-Idom wana limi ana heniheni i mulolu-agil ge wana bugubugul gegewel hi waisi, kaiwena Yabowaine wana Bateli ana Dedewaga i miminaa elana.” Inoke Deibid alonau wana gamagalau hi na Yabowaine wana Bateli ana Dedewaga hi ahem Obed-Idom wana limiya ge alona wali yaliyaya bwabwatana hi kalivai hi pwatanik Deibid wana Panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Sauga bolo hi kaval hi nawa egon aeliya hi teli pasikis, yaka Deibid i ba hi talmilil inoke bulumwakau melutauina etega ge bulumwakau natuna tatabwana etega i powonagil Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Wali nawanawa kamwasaa, holahola alana ipod, hi ginolem kaliko waiwaisana elana, Deibid i galoi, yaka alona wana gasisi bwalibwaligena i sagasaga Yehoba matanaa. ");
INSERT INTO mpx_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Alonau Isileli gegewel Yehoba wana Bateli ana Dedewaga hi pwatanik Yelusalema, hi nonoyogayoga ge bwagigi hi yuyu. ");
INSERT INTO mpx_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Sauga hi kaval tukan Deibid wana Panuwaa, Sol natuna Mikal iyoho matana i laulau windowa, i kite lagona Deibid i susupeni ge i sagasaga Yehoba matanaa. Yaka atena eliyana i awa naknak-an. ");
INSERT INTO mpx_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Yaka hi na Bateli ana Dedewaga hi kaval teliya abanaa, epanapana toto Deibid i pamilil gamwanaa. Inoke Deibid bwasumu i powonagil Yehoba elana, enuna i powonagil pwabwaligel ge enuna heliheliyam powonina. ");
INSERT INTO mpx_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Sauga i powon haba, yaka gamagalau i ba mulolu-agil Yehoba Togasisi Hot alana elana. ");
INSERT INTO mpx_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Inoke beleid maisena, deit enona hi pakevakeva ana os maisena ge oine enona hi pakevakeva ana os maisena i guyau-an Isileli bolo hi nogogo o, bolau ge yowau, gegewel elal. Yaka abwe hi egonan hi na tomaha ona wali limiya. ");
INSERT INTO mpx_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Sauga Deibid i sikal wana limiya tage ni ba wana limi ana heniheni Yehoba ni mulolu-agil, yaka lagona Mikal Sol natuna i tagil i na i kite ge i baek elana i ba, “Ga i ola ge lan ebe owa Isileli wali kin, totom am puluwawi u ginol ge tuwam u pabokaboka alomwau wali totuwalali loloyowanil galokau mataliyaa, i ola tosigasiga wali ginol?” ");
INSERT INTO mpx_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Anana Deibid i lahe i ba, “Yehoba matanaa te ya sagasaga. Iya i hileyau tamwam ya milahe, i ola al nige ana un gamagalina etega i hihile. Yaa nau i hileyau ya tabwa wana gamagalau Isileli ali tologugui, inoke na yaliyaliyaya ya Yehoba matanaa. ");
INSERT INTO mpx_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Ya yaliyaya te alau na teli lowan hoti, o ebo totou o puluwawi na ginol. Yaa totuwalali galokau bolo baliya u babaa ei, heliya nihi awatau-agau.” ");
INSERT INTO mpx_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","He Sol natuna Mikal nige sauga etega i aab ana siga i aliga. ");
INSERT INTO mpx_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Sauga Yehoba kin Deibid i labe ana topihigelgel gegewel bolo hi minaa labi Isileli bebenaa i pakokovel ge i veyaho, yaka Deibid i mibubun wana limi elana, ");
INSERT INTO mpx_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","inoke i baek palopita Neitan elana i ba, “Nau hiwe ya minaa kin limena abwakil sida elana hi taliya, yaa Yabowaine wana Bateli ana Dedewaga i minaa epanapana gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Kin anana Neitan i lahe i ba, “Hauna u nuwatuan atemwa, he nu ginol ya, kaiwena Yehoba i minaa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Yaa lan o bulinina Yehoba i baek Neitan elana i ba: ");
INSERT INTO mpx_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Nu na nu baek no totuwalali Deibid elana nu ba, ‘Yehoba i ba ola hiwe: Owa nige limi nu tatal kaiweu ge na miminaa. ");
INSERT INTO mpx_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","I telipunaa sauga Isileli ya ahel hi tagilem Itipita ana siga lan ebe, nige ya miminaa limi etega gamwanaa. Ya mimi nawanawa panuwa ge panuwa ona elal, he ya miminaa ya te epanapana gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Alowau boda Isileli wama minawanawa labi gegewena elal, nige sauga etega ya babaek tohouwa bolo ya telel no gamagalau Isileli ali tomatahikan elal ya babaa, “Ga i ola ge nige abwakil sida elana limi waiwaisana etega ku tatal kaiweu?” ’ ");
INSERT INTO mpx_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","“Inoke nu baek no totuwalali Deibid elana nu ba, ‘Yehoba Togasisi Hot i ba ola hiwe: Nau ya ahewaa uleyaa owa sipi ali tomatahikan ge ya hilewa u tabwa no gamagalau Isileli ali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Hauna labi elana valila u noek alou owa ya, ge am topihigelgel gegewel ya pakokovel maninimwa. Inoke alam na teli heyan, ni ola gamagalau alaliya bwabwatal panayawiya. ");
INSERT INTO mpx_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","I ola al, no gamagalau Isileli wali panuwa etega na pek elal ge na telel nihi holaviya, inoke ni tabwa totoliya wali panuwa ge nihi mibubun. Inoke toginol naknak nige al nihi papalomwan-agil ni oola valila hi ginol elal, ");
INSERT INTO mpx_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","i telipunaa sauga toto toasiyala ya telel no gamagalau Isileli hi houwaagil. Ge am topihigelgel gegewel na pakokovel ge nu veyaho. “‘Ya baewa elam te nau Yehoba limi etega na pamilil kaiwem. He ya ba alomwau tubutubumwau heyan ge heyan nuku tologugui. ");
INSERT INTO mpx_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Ebo iyaka wam sauga ni pwawa ge nu aliga nu na alomwau tubumwau, inoke natum etega totom saliyam hot na palut abam ni milahe, yaka wana abalogugui na pamilil ni gasisi. ");
INSERT INTO mpx_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","He iya te Limi Bwabwalena ni tal alau kaiwena, inoke wana abalogugui na pamilil ni gasisi ge ni kalapapanet tubutubunau elal ni mihot. ");
INSERT INTO mpx_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Nau na ola tamana ge iya ni ola natu. Ebo ni gegi, inoke suki elana na nibihi, ni ola taman etega natuna i papahenapu. ");
INSERT INTO mpx_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Yaa no nunuwana nige na aahek yoho eliyana, nige ni oola toto ya ginola Sol elana, iya ya ahek yoho abanaa ge owa u milahe. ");
INSERT INTO mpx_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Wam limi ge wam abalogugui nihi mihot matawa sauga gegewena; wam abalogugui ni gasisi ge ni kalapapanet tubutubumwau elal nige ni momowasi.’” ");
INSERT INTO mpx_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Yaka Yehoba wana baaba gegewena toto pankite ya eliyana, Neitan i na i baunanik Deibid elana. ");
INSERT INTO mpx_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Inoke kin Deibid i na i tuk epanapana gamwanaa toto Bateli ana Dedewaga i miminaa, yaka i misiyo Yehoba awonaa ge i awanun i ba: “O Babala Yehoba, henala nau ge henalau nam ana un, ge iyaka u aheyau u teleyau abamina bwabwatana ya elana? ");
INSERT INTO mpx_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Yaa Babala Yehoba, toto o nige mananana! Yaka u ginol paetulan ge u bateli nau wam totuwalali natu ge tubutubuwau sauga mulaa kaiweliya. O Babala Yehoba, age u giginol ola o gamagalau gegewel elal? ");
INSERT INTO mpx_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Gamwaniniu i kevakeva, nige bosowaina na baaba! O Babala Yehoba, nau wam totuwalali o nuwan u tu ge u hileyau. ");
INSERT INTO mpx_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","U bateli ge nuwam nu ginol ola, inoke ginol bwabwatana ya u ginol ge u pamasal nau wam totuwalali eliyau. ");
INSERT INTO mpx_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","“O Babala Yehoba, owa alam i bwata. Nige etega wasana ha hahago i ola owa! Nige Yabowaine etega al i gagan, maisem ya. ");
INSERT INTO mpx_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Nige boda etega panayawiya i oola wam gamagalau Isileli! Owa Yabowaine u pwamola pasikaliliem Itipita hi tabwa owa wam gamagalau ge alam u pawasawasa. I ola al, ginol yawiyawi bwabwatal u ginolil, inoke boda tomaha ona avaliyau wali yabowaineyau u pakokovel ge u takel tagilagil wam gamagalau o awoliyaa ge hi minaa labi toto u hile kaiwem. ");
INSERT INTO mpx_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Boda Isileli u hilel hi tabwa owa wam gamagalau sauga gegewena nige ni momowasi, ge owa Yehoba, u tabwa wali Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","“Inoke Yehoba Yabowaine, wam bateli nau wam totuwalali ge tubutubuwau kaiwema nu patunahot ge ni mihot. Nu ginol ni ola wam bateli, ");
INSERT INTO mpx_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","inoke alam ni wasawasa sauga gegewena nige ni momowasi. Yaka gamagalau nihi ba, ‘Yehoba Togasisi Hot iya Isileli wali Yabowaine!’ Nau wam totuwalali Deibid no abalogugui nu pamilil ni gasisi matamwa ge ni kalapapanet tubutubuwau elal nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","“O Yehoba Togasisi Hot, Isileli wama Yabowaine, u pamasal nau wam totuwalali eliyau u ba, ‘Nau limi etega na pamilil kaiwem, inoke alomwau tubutubumwau heyan ge heyan nuku tologugui.’ Inoke ateu i matuwa te awanun ya ya awanuni eliyam. ");
INSERT INTO mpx_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","O Babala Yehoba, owa Yabowaine tutunahotina! Wam baaba i tunahot, ge waisi toto ya iyaka u bateli nau wam totuwalali eliyau. ");
INSERT INTO mpx_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Kaiwena owa Babala Yehoba u ba ola to, inoke alowau ge tubutubuwau nu ba mulolu-agima, yaka owa matamwa abalogugui ni mihot eliyama. Wam ba mulolu o ni mihot alowau tubutubuwau eliyama!” ");
INSERT INTO mpx_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Deibid i tabwa kin Isileli gegewel elal ge wana logulogugui i waisi ge i sapu. ");
INSERT INTO mpx_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Seluwaiya natuna Yowab, iya tolohaveyan wali tohouwa. Ahilud natuna Yehosapat, iya kin wana logugui ana tomatahikan ge ana towasa. ");
INSERT INTO mpx_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Ahitub natuna Seidok, ge Abaiyada natuna Ahimelek, heliya hi topowon. Selaiya iya toleleli. ");
INSERT INTO mpx_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Yehoiyada natuna Benaiya, iya boda Keleti ge boda Peleti wali tohouwa. Ge Deibid natunau heliya hi ola topowon. ");
INSERT INTO mpx_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Lan etega Deibid i nel wana totuwalali elal i ba, “Tab Sol tubutubunina etega iyoho ya i minamina, inoke na atilomwan-an Diyontan ana awatauwan kaiwena?” ");
INSERT INTO mpx_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","He Sol wana totuwalali etega alana Siba iyoho i gan, inoke hi yogaan i na kin Deibid elana. Yaka i nel i ba, “Owa alam Siba?” Anana i lahe i ba, “E, nau wam totuwalali alau tei.” ");
INSERT INTO mpx_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","Inoke kin i nel i ba, “Tab Sol tubutubunina etega iyoho ya i minamina, inoke na atilomwan-an ni ola Yabowaine wana atilomwan.” Anana Siba i lahe i ba, “E, Diyontan natuna melutauina etega i gan iyoho, yaa aena labui hi nak, nige bosowaina ni nawanawa bubun.” ");
INSERT INTO mpx_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Inoke kin i nel i ba, “He iya ga?” Anana Siba i lahe i ba, “Iya iyoho Amiyel natuna Makil wana limiya panuwa Lo-Debal.” ");
INSERT INTO mpx_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Inoke kin Deibid wana totuwalali i patunal hi na hi ahem Lo-Debal ge hi pwatanim elana. ");
INSERT INTO mpx_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Sauga Mepiboset, iya Diyontan natuna ge Sol tubuna, i na Deibid elana, yaka i kululu maninina i pahanalowanek bilibiliya. Inoke Deibid i baek elana i ba, “Ateu owa Mepiboset!” Anana i lahe i ba, “Nau wam totuwalali.” ");
INSERT INTO mpx_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Yaka Deibid i ba, “Bahi nu lolovakun, kaiwena nasi na atilomwan-agiwa tamwam Diyontan ana awatauwan kaiwena. Inoke bilibili gegewena toto valila i minaa tubum Sol eliyana na pewa eliyam, ge owa sauga gegewena nu aanana no teibola.” ");
INSERT INTO mpx_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Yaka Mepiboset i kululu ge i baek Deibid elana i ba, “Nau gamagal bwagabwaga ya, ya ola ya te wanuka alialigana, inoke ga i ola ge u atilomwan-agau?” ");
INSERT INTO mpx_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Inoke kin Deibid Siba i yogaan ge i baek elana i ba, “Bugul gegewena toto valila i minaa Sol ge ana un elal, iyaka ya pek wam tonowak tubuna Mepiboset elana. ");
INSERT INTO mpx_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Owa alomwau natumwau ge wam totuwalali bilibili nuku eyowaan, yaka enowana nuku pwatanim wam tonowak tubuna Mepiboset kaiwena. Ge iya sauga gegewena ni aanana no teibola.” He Siba natunau bolau ali gewi piptin (15) ge wana totuwalali ali gewi tuwenti (20). ");
INSERT INTO mpx_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Yaka Siba i baek elana i ba, “No babala ge no kin, nau wam totuwalali hauna ebo nu baunan nasi na ginol.” Inoke sauga o ge i nok Mepiboset i aanana Deibid wana teibola i ola natuna etega. ");
INSERT INTO mpx_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mepiboset natuna geman etega i gan alana Mika. Inoke sauga o ge i nok, Siba alonau wana limi ana heniheni gegewel hi totuwalali Mepiboset elana. ");
INSERT INTO mpx_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Iya i miminaa Yelusalema ge sauga gegewena i aanana kin wana teibola. He aena labui hi nak nige bosowaina ni nawanawa bubun. ");
INSERT INTO mpx_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Baliman ana abatelipuna elana, kin ona wali sauga hi tatagil ge hi lolohaveyan, inoke Deibid Yowab i patuna i tagil, alonau tolohaveyan wali tohouwa ona ge Isileli wali tolohaveyan gegewel. Yaka Amoni wali tolohaveyan hi pakokovel, inoke abwe wali panuwa bwabwatana Laba hi mipainan ge hi mikausil. Yaa Deibid nige i nonok, i misikal Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Lan etega vekokoyaviya, Deibid i kenu lutem wana abaveveyahowa, yaka i na i ha limi pwatanaa toto hi tal paabwab ge i nononawanawa. Yaka abwe matana i nok, inoke yova etega i kite i highig, ana awa i waisi hot. ");
INSERT INTO mpx_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Yaka elopapatuna etega i patuna i nok ge i loyaan yova o iya henala. Inoke Deibid wana wasa i pek i ba, “Yova alana Baseba Eliyam natuna, ge lagona alana Ulaiya, boda Hiti gamagalina.” ");
INSERT INTO mpx_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Yaka elopapatuna enuna i patunal hi nok ge yova o hi pwatanik elana. Inoke alona hi kenu toyawa, yaka abwe yova i sikal wana limiya. (He abwe wana weikena kasiyebwa i mowasi, ge ana abububun i pwamowasi haba.) ");
INSERT INTO mpx_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Yaa saliyana i ota, inoke Deibid ana baaba i patuna i ba, “Nau iyaka ya liyan.” ");
INSERT INTO mpx_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Inoke Deibid baaba i patuna Yowab elana i ba, “Ulaiya Hiti gamagalina u patuna ni nem eliyau.” Yaka Yowab i ginol ola to. ");
INSERT INTO mpx_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Sauga Ulaiya i vin, yaka Deibid i nel eliyana Yowab ge tolohaveyan wali minamina kaiwena, ge haveyan ga i ola. ");
INSERT INTO mpx_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Yaka i baek Ulaiya elana i ba, “U na wam limiya, aem u ul ge u veyaho.” Inoke kin wana limi i eguluwai, enaa abwe ana mulolu aanan enuna Deibid i patuna wana limiya. ");
INSERT INTO mpx_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","He Ulaiya nige i nana wana limiya, yaa i kenuwa kin wana limi ana abauluulutuka tomatahikan wali lum elana, alonau ge nog ana tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Yaka abwe Deibid wana wasa hi pek hi ba, “Ulaiya nige i nana wana limiya.” Yaka Ulaiya i yogaan ge i nel i ba, “Hauna kaiwena nige u nana wam limiya? He owa abwe u sikalem labi yayapona elana.” ");
INSERT INTO mpx_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Yaka Ulaiya i baek Deibid elana i ba, “He Bateli ana Dedewaga i minaa ya epanapana gamwanaa, i ola al Isileli ge Yuda wali tolohaveyan heliya iyoho hi miminaa epanapana gamwaliyaa. No tonowak Yowab alonau wam tohouwa ona heliya iyoho hi holaviya uleya abalohaveyana. Inoke nige bosowaiu na nok no limiya na aanan, na imwim ge alou lagou naha kenu. He ya papasila Yehoba yawalina gaganina alanaa ge owa alamwa, nige na giginol oola!” ");
INSERT INTO mpx_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Inoke Deibid i baek elana i ba, “Lan maisena ga u mina yaka bwaligumwa abwe na patunawa nu sikal.” Yaka Ulaiya i minaa Yelusalema i ola Deibid wana baaba. ");
INSERT INTO mpx_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Inoke Deibid Ulaiya i yogaan alona hi anan ge hi imwim, yaka Ulaiya i paim pakokona. Yaa bulin o nige i sisikal wana limiya, he i kenuwa wana helagi pwatanaa alonau ge nog ana tomatahikan. ");
INSERT INTO mpx_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Lan i gan mweluluga, Deibid Yowab wana leta i leli, yaka i pek Ulaiya elana ge i patuna i egon. ");
INSERT INTO mpx_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","He leta o gamwanaa Deibid i leli i ba, “Ulaiya nu teli ni mihouwa labi toto haveyan i gasisi hot elana, yaka nuku misikal inoke nihi lopaaliga.” ");
INSERT INTO mpx_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","He Yowab ge wana tolohaveyan heliya iyoho panuwa bwabwatana Laba hi mipainan, yaka Ulaiya i teliya labi toto ali topihigelgel wali tolohaveyan waiwaisal hi minaa. ");
INSERT INTO mpx_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Sauga panuwa o wali tolohaveyan hi tagil avaliyau Yowab ge wana tolohaveyan hi lohaveyan, inoke Deibid wana tolohaveyan enuna hi howa paaligal. He Ulaiya Hiti gamagalina al ge hi howa paaliga. ");
INSERT INTO mpx_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Inoke Yowab haveyan o wasana gegewena i patuna Deibid elana. ");
INSERT INTO mpx_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","I baek elopapatuna elana i ba, “Sauga ebo haveyan wasana nu baunan kin elana, ");
INSERT INTO mpx_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","he bosowaina ya te ni huga ge ni neliwa ni ba, ‘Hauna kaiwena ku mituk panuwa bebenaa hot haveyan kaiwena? Age nige ku aatena bosowailiya ya egipoyo gauina nihi alitagilanem ganaa ge nihi howamiu? ");
INSERT INTO mpx_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","He liwanina ku atena bubun ga i ola ge valila Gidiyon natuna Abimelek i yaomal. Panuwa Tibes elana yova etega pat bwabwatana witi ana ewowowol i alilowanem ganaa, yaka i tala pwatanaa ge i aliga. Inoke hauna kaiwena ku mituk gana bebenaa?’ Ebo ni nel ola o, yaka nu baek elana nu ba, ‘Ulaiya Hiti gamagalina al ge iyaka i aliga.’” ");
INSERT INTO mpx_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Sauga elopapatuna i na i vin Yelusalema, inoke bugul gegewena toto Yowab i patuna ge ni pamasal, i wasaan Deibid eliyana. ");
INSERT INTO mpx_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","He i ba ola hiwe, “Ama topihigelgel hi gasisi hot nige bosowaima naha palil, yaka hi tagilem wali panuwaa alomeyau ha lohaveyan. Yaka abwe ha bibin pasikalil hi na wali panuwa ana gana ana abauluulutuka. ");
INSERT INTO mpx_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Inoke toloegipoyo gau enuna hi alihinem eliyama yaka wam tolohaveyan enuna hi howa paaligal. He Ulaiya Hiti gamagalina al ge iyaka i aliga.” ");
INSERT INTO mpx_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Yaka Deibid i baek elopapatuna elana i ba, “Nu baek Yowab elana nu ba, ‘Bahi nu nuwanuwatu nabi hauna gun i gan kaiwena, nige nak hot i oola. Sauga gegewena gamagalau hi aligaa haveyan elana, ge nige ta aatena henala nasi ni pwawa. Nuku haveyan gagasisi yaka nuku pakokovel ge wali panuwa nuku apapanak-an.’ Baaba ya nu baunan inoke eliyana Yowab nu ba pagasisi.” ");
INSERT INTO mpx_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Sauga Ulaiya lagona wasa i hago wana tonowak iyaka i aliga, inoke i kahikahin ge nuwanak paganina i ginol. ");
INSERT INTO mpx_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","He nuwanak paganina o ana sauga i mowasi, yaka Deibid gamagalau enuna i patunal ge yova o hi en pwatanik wana limiya ge i alolonan. Inoke abwe Deibid natuna tauina etega i ab. Yaa ginol toto Deibid i ginol, Yehoba nige i yayaliyaya-an, i nak hot matanaa. ");
INSERT INTO mpx_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Yehoba palopita Neitan i patuna i na Deibid elana i ba, “Bolau labui hi miminaa panuwa maisena elana, etegana togogomwau ge eluwana togulagula. ");
INSERT INTO mpx_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Togogomwau wana sipi ge bulumwakau hi gewi nabi. ");
INSERT INTO mpx_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Yaa togulagula wana gogomwau iyai ya te sipi natuna maisena hot, valila i pwamola. I matahikan bubun yaka i bwataa alonau ge natunau elal. Alona hi aanan toyawa, hi imwimwa kom maisena elana, ge i papakenuwa aenaa. He i ola te natuna meluyovana etega. ");
INSERT INTO mpx_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","“Lan etegana bwabwali etega i na togogomwau wana limiya. He togogomwau nige nuwana totona wana bwasumu etega ni lol ana bwabwali ni an. Yaka i na togulagula wana sipi i ahe i lol ge i liga ana bwabwali kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Deibid i huga nabi tau o wana ginol kaiwena, yaka i baek Neitan elana i ba, “Ya papasila Yehoba yawalina gaganina alanaa, tau toto ginol ya i ginol bosowaina ta ba ni aliga. ");
INSERT INTO mpx_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Pagan o i ginol alona nige i atilomwana-an, inoke paesopali sipi ni pwamola pasikal elana.” ");
INSERT INTO mpx_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Inoke Neitan i baek Deibid elana i ba, “Tau o heiya te owa! He Yehoba Isileli wala Yabowaine i ba ola hiwe: ‘Enonu ya hol kokowamwa u tabwa Isileli wali kin ge ya pwamwaliwa Sol nimanaa. ");
INSERT INTO mpx_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","He wam tonowak Sol wana limi ana gogomwau gegewena ya pewa, i ola al lagonau ya pewa nimwamwa. Abalogugui Isileli ge Yuda ya pewa u logugui-an. Binimala u nuwatu bugul bolo ya nige mananana, bosowaiu ya te na paetulan al. ");
INSERT INTO mpx_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Hauna kaiwena nau Yehoba no logugui u awatautau-an, yaka pagan i nak nabi eliyau u ginol matawa? Ulaiya Hiti gamagalina u paaliga ge lagona u ahe lagom. Amoni wali haveyan u patuwalali ge u paaliga. ");
INSERT INTO mpx_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Inoke sauga gegewena haveyan ge lopaaliga ni gangan am un gamwanaa. Am lahi i ola to, kaiwena u awatautau eliyau yaka Ulaiya lagona u ahe lagom.’ ");
INSERT INTO mpx_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","“He Yehoba i ba ola hiwe: ‘Na ba nak ni masal eliyam, ni neem am un gamagalina etega elana. Lagomwau na aheliya eliyam yaka na pek alom etega elana, inoke alonau nihi kenu toyawa lan gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Owa gegi u ginol sume, yaa nau am lahi ya na ginol pamasal lan gamwanaa, boda Isileli gegewel mataliyaa.’” ");
INSERT INTO mpx_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Inoke Deibid i baek Neitan elana i ba, “Iyaka ya gegi Yehoba elana.” Anana Neitan i lahe i ba, “Yehoba wam gegi iyaka i nuwayoho, yaka nige nu aaliga. ");
INSERT INTO mpx_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Yaa kaiwena u awatautau nabi Yehoba elana, inoke natum tauina toto abwe ku ab, nasi ni aliga.” ");
INSERT INTO mpx_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Inoke Neitan i egon i na wana limiya. Yaka abwe wawaya toto Deibid ge Ulaiya lagona natuliya, Yehoba i pakasiyebwa nabiyan. ");
INSERT INTO mpx_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Inoke Deibid i awanun gagasisi Yehoba elana wawaya kaiwena. Ana galebu i palahikan ge bulin gegewena i kekenuwa bilibiliya. ");
INSERT INTO mpx_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Yaka wana totuwalali alaliya bwabwatal hi nok elana ge hi palawakik tage ni lutem bilibiliya, yaa i towa, nige nuwana ni lut ge alonau nihi anan. ");
INSERT INTO mpx_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","He lan seben-ina elana yaka wawaya i aliga. Inoke wana totuwalali hi lovakun te wana wasa nihi pek, kaiwena hi nuwatu hi ba, “Sauga wawaya nigeya ga i aliga, ta baaba elana yaa nige i lalaegan elala. He nasi ga ta ola ge wana wasa ta pek natuna iyaka i aliga? Ebo wana wasa ta pek, tab eba nak etega ni ginol?” ");
INSERT INTO mpx_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Sauga Deibid i kite wana totuwalali hi lolowalwalgumu gamwaliyaa, inoke i nuwatu te wawaya iyaka i aliga. Yaka i nel i ba, “Wawaya iyaka i aliga?” Anana hi lahe hi ba, “E! Iyaka i aliga.” ");
INSERT INTO mpx_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Inoke Deibid i lutem bilibiliya. Yaka i na i highig, tuwana i paenonu, ge kaliko vavaluna i galoi, yaka i na i tuk Yehoba wana limiya ge i tapwalolo. Inoke i sikal i na wana limiya, i ba aanan hi loviviva-an, yaka abwe i aanan. ");
INSERT INTO mpx_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Yaka wana totuwalali hi neli hi ba, “Ga i ola u ginol ola o? Sauga wawaya nigeya ga i aliga, galebu u palahikan ge u kahikahin, yaa sauga iyaka i aliga, inoke u lut u anan.” ");
INSERT INTO mpx_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Analiya i lahe i ba, “Sauga wawaya nigeya ga i aliga, galebu ya palahikan ge ya kahikahin, kaiwena ya nuwatu te tab eba Yehoba ni mulolu-agau inoke natu ni molu. ");
INSERT INTO mpx_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Yaa sauga e wawaya iyaka i aliga, he hauna kaiwena galebu na palahikan? Tab i bosowaiu yawalina na pasikal? Sauga etega abwe na na elana, yaa iya nige ni sisikalim eliyau.” ");
INSERT INTO mpx_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Inoke Deibid lagona Baseba i payaliyaya ge alona hi kenukenu yaka abwe natuna tauina etega al i ab ge alana hi tun Solomon. He Yehoba wawaya o i nunuwana-an. ");
INSERT INTO mpx_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Inoke baaba i patuna palopita Neitan eliyana wawaya alana nihi tun Yedidaiya, kaiwena Yehoba i nunuwana-an. ");
INSERT INTO mpx_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Deibid natuna Absalom nuna i gan alana Tama, iya ana awa i waisi hot. He sauga etega abwe Amnon yova ya i hebabale. Amnon iya Deibid natuna etega al, yaa hinan getoga. ");
INSERT INTO mpx_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","He Absalom i lou i na i minaa tubuna Talmai panuwa Gesul wali kin elana, iya Amihud natuna. Yaa lan hi gewi Deibid i lolonuwanak natuna kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","Sauga Absalom i lou i na Gesul, yaka baliman eton i miminaa to. ");
INSERT INTO mpx_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","He kin Deibid wana lonuwanak i so ge i yaliyaya al, yaka amnana gegewena te Absalom ni kite. ");
INSERT INTO mpx_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Seluwaiya natuna Yowab i atena te kin Deibid nuwana hot Absalom ni kite. ");
INSERT INTO mpx_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Inoke abwe kin i baek Yowab elana i ba, “I waisi, na ginol ni ola wam nuwatu. He nu nok nu na heval Absalom nu en pasikalim.” ");
INSERT INTO mpx_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Yaka kin ana awatauwan kaiwena Yowab i kululu maninina i pahanalowanek bilibiliya. Inoke i ba, “No babala ge no kin, Yehoba ni mulolu-agiwa! Lan ebe nau wam totuwalali ya atena u yaliyaya-agau bubun, kaiwena no awanun eliyam iyaka u paolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Inoke Yowab i na panuwa Gesul Absalom i en pasikalim Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Yaa kin i ba, “Ni noek ya wana limiya ge ni miminaa to, bahi ni nenem ni kikiteyau.” Inoke i na wana limiya ge nige i nana kin i kikite. ");
INSERT INTO mpx_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Isileli gegewel gamwaliyaa, Absalom ana tobal i bwata te iya ana awa i waisi hot. He nige potpot etega i gagan tuwanaa, i telipunaa kokowanaa i lau i na aenaa. ");
INSERT INTO mpx_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Baliman maisena ge maisena pamaisena kokowana ni tomwa yoho, kaiwena i balu ge i pupulowan. Yaka ana pulowan ni luvi ni ola tu kiloglem (2 kg) ge pwatanaa al. He ana pulowan i sikeli eluviluvi toto kin i ba gamagalau nihi patuwalali elana. ");
INSERT INTO mpx_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Absalom natunau bolau ali gewi eton ge yovana maisena, lagona i abil. Toto yovana alana Tama, ge sauga i bwata ana awa i waisi hot. ");
INSERT INTO mpx_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Baliman labui Absalom i miminaa Yelusalema, yaa nige i nana kin i kikite. ");
INSERT INTO mpx_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Inoke baaba i patuna Yowab elana tage ni na eliyana yaka ni patuna kin elana, yaa Yowab i towa nige i nonok. He palabuina al baaba i patuna, yaa i towa nige i nonok. ");
INSERT INTO mpx_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Yaka Absalom i baek wana totuwalali elal i ba, “Ku atena te Yowab wana bali ana eyowa i minaa no eyowa bebenaa. He ku na ku ton.” Yaka hi ginol ola wana baaba. ");
INSERT INTO mpx_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Inoke Yowab i na Absalom wana limiya ge i neli i ba, “Hauna kaiwena wam totuwalali no bali ana eyowa hi ton?” ");
INSERT INTO mpx_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Yaka Absalom i baek elana i ba, “Am baaba ya patuna nu nem eliyau, yaa nige u nenem. Tage na patunawa nu na kin nu neli hauna kaiwena Gesul ya eguluwai ge ya nem e. Binimala na minek to. He sauga ya nuwau na na kin na kite. Ebo bugul etega kaiwena ni pwawaagau ya gegi, he ya talam ni tagapaaligau.” ");
INSERT INTO mpx_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Inoke Yowab i na kin wana wasa i pek Absalom ga i ba ola. Yaka kin Absalom i yogaan ni na eliyana. Sauga i vin, inoke i kululu maninina i pahanalowanek bilibiliya kin awonaa. Yaka abwe kin Absalom i nalo ge i yaliyaya-an. ");
INSERT INTO mpx_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Sauga etega al, Absalom waga momomol etega ge hosi enuna i ahel iya kaiwena ge i patuwalali-agil, yaka i ba bolau ali gewi pipti (50) hi patalelu houwa manininaa. ");
INSERT INTO mpx_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","I ola al, mweluluga kekeisi ni lut, yaka ni na ni talmilil panuwa ana gana ana abauluulutuk ana kamwasa bebenaa. Ebo gamagal etega ni nem ana pulowan ni pwatanik kin elana kot kaiwena, yaka ni yoga nok elana ni ba, “Hapanuwa gamagalina owa?” Inoke anana ni lahe ni ba, “Nau wam totuwalali ya noem Isileli ana un panuwana etega elana.” ");
INSERT INTO mpx_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","Yaka Absalom ni baek elana ni ba, “Nuwatu toto u pwapwatanik kin elana i sapu ge i waisi, yaa nige gamagal etega i gagan kin ge wana totuwalali gamwaliyaa tage wam kot ni hago.” ");
INSERT INTO mpx_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Inoke ni ba vevehe al ni ba, “Binimala nau nihi hileyau na tabwa topapayatala wala labiya! Yaka henala ebo ana pulowan i gan kot kaiwena ni nem elau, inoke na pasapu kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","I ola al, ebo gamagal etega ni noha elana ge tage ni kululu manininaa, yaka nimana ni paelu ni holatomwa ge ni nalo. ");
INSERT INTO mpx_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","He i ginoginol ola to Isileli gegewel bolo hi nana kin elana kot kaiwena elal, inoke nuwaliya i gove ge hi olak elana. ");
INSERT INTO mpx_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Baliman esopali ana abapwamowasi elana, yaka Absalom i baek kin elana i ba, “U talamwagau na na Hebiloni inoke no bateli Yehoba elana na patunahot. ");
INSERT INTO mpx_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Sauga ya miminaa Gesul labi Alam, yaka ya bateli ya ba, ‘Ebo Yehoba ni ahe pasikalau Yelusalema, inoke na na na tapwalolo elana Hebiloni.’” ");
INSERT INTO mpx_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Yaka kin i baek elana i ba, “He u nok ginebi wam laumwal.” Inoke Absalom i na Hebiloni. ");
INSERT INTO mpx_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Yaka Absalom wana elopapatuna i patunal sumel hi na un Isileli gegewel elal nihi ba, “Sauga ebo bwagigi anana nuku hago, yaka nuku ba, ‘Absalom iyaka i tabwa wala kin panuwa Hebiloni.’” ");
INSERT INTO mpx_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","He bolau ali gewi tu handeled (200) iyaka i aheliya Yelusalema hi toulil, i awanunil ana bwabwali powon kaiwena, yaa wana nuwatu gamwana nige hi aatena. ");
INSERT INTO mpx_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Sauga iya iyoho Hebiloni bwasumu i powopowon, yaka Ahitopel gagama Gilo, iya Deibid wana totuwalali bwabwatana etega i lalabe nuwatu loyaloya elana, ana baaba i patuna i noem wana panuwa Gilo i na elana. He Absalom wana nuwatu toto kin Deibid abana ni ahe iyaka i gagasisi nawa, yaka gamagalau hi gewi hi tubwi elana. ");
INSERT INTO mpx_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Yaka abwe elopapatuna etega i na i baek Deibid elana i ba, “Isileli iyaka hi olak Absalom elana.” ");
INSERT INTO mpx_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Inoke Deibid i baek wana totuwalali alaliya bwabwatana bolo alonau hi miminaa Yelusalema elal i ba, “Ta egon ta lou! Ebo nigeya, nige etega ta mwamwal Absalom elana. Etimwawa, eba ni mweyaha ge ni pwawala, yaka ni apapanak-agila ge Yelusalema ana tomina ni gopapaaliga-agil haveyan kilepana elana.” ");
INSERT INTO mpx_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Inoke anana wana totuwalali hi lahe hi ba, “Wama babala ge wama kin, hauna ebo u nuwatuan i waisi, ama wam totuwalali naha ginol ola.” ");
INSERT INTO mpx_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Yaka kin i egon ge wana limi ana heniheni gegewel hi toulil, yaa lagonau al ali gewi elulutega (10) i tataluwagil kin limena nihi matahikan. ");
INSERT INTO mpx_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","He kin i nawanawa ge wana gamagalau gegewel hi toulil, hi na panuwa buhunaa limi mowamowasena elana, yaka kin ge alonau enuna hi notalmilil. ");
INSERT INTO mpx_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Yaka wana tolohaveyan gegewel hi nopalegi hi noek awonaa, avaliyau al boda Keleti ge Peleti. I ola al, tolohaveyan Pilistiya panuwa Gat gamagaliliyau ali gewi sikis handeled (600), heliya Deibid hi toulil hi neem Gat, hi noha nihi nopalegi nihi noek awonaa. ");
INSERT INTO mpx_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Inoke kin i baek wali tohouwa Itai, gagama Gat elana i ba, “Ga i ola ge u nem aloma owa? U sikal u na alom kin Absalom. He owa bwabwali, nige u miminaa wam panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Abwe u vin ya te nolu. Inoke lan ebe, bahi na babaa aloma owa ta nonobwagabwaga, kaiwena nige ya aatena ga ya nonoek. U sikal, wam gamagalau u en pasikalil, ge ya awanun Yehoba wana nunuwana tutunahotina ni minaa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Yaka anana Itai i lahe i ba, “No babala ge no kin, ya papasila Yehoba yawalina gaganina alanaa ge owa alamwa, hauna labi elana nu noek, bwagana ebo molu o yaomal, nasi alou owa ya.” ");
INSERT INTO mpx_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Inoke Deibid i baek Itai elana i ba, “I waisi. Ku nem ku nok.” Yaka Itai alonau wana tolohaveyan ge natuliyau bolo avaliyau, hi nopalegi hi noek awonaa. ");
INSERT INTO mpx_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Yelusalema ge awanina ona ana tomina hi kahin analiya i bwata, sauga Deibid alonau wana gamagalau gegewel hi nopalegel ge hi nok. Yaka hi na hi lau sinawel Kidilon hi kalapanet-an, hi heheya ula kekevana kaiwena. ");
INSERT INTO mpx_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","He Seidok alonau un Libai gegewel heliya al iyoho, Yabowaine wana Bateli ana Dedewaga hi kalivai. Sauga hi kaval palo, yaka Abaiyada bwasumu i powonagil Yehoba elana ana siga gamagalau gegewel Yelusalema hi eguluwan ge hi nok. ");
INSERT INTO mpx_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Inoke kin i baek Seidok elana i ba, “Yabowaine wana Bateli ana Dedewaga u kalivai pasikal panuwaa. Ebo Yehoba ni yaliyaya-agau, yaka abwe ni pasikalau inoke wana limi ge wana Bateli ana Dedewaga na kite al. ");
INSERT INTO mpx_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Yaa ebo nige i yayaliyaya kaiweu, he ya talamwagau hauna i nuwatuan i waisi, yaka ni ginol eliyau ni ola to.” ");
INSERT INTO mpx_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Yaka kin i baek al topowon Seidok elana i ba, “He no nuwatu i ola hiwe. Alom Abaiyada nuku sikal panuwaa ginebi wami laumwal, alomiyau natum Ahimas ge Abaiyada natuna Diyontan. ");
INSERT INTO mpx_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Nau na matamatana wewel Yolidani ana abakalakalapaneta ana siga wasa etega nu patunam hauna i gangan Yelusalema.” ");
INSERT INTO mpx_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Inoke Seidok ge Abaiyada Bateli ana Dedewaga hi kalivai pasikal Yelusalema ge hi miminaa to. ");
INSERT INTO mpx_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Deibid kokowana i os ge aena awawana ya i nonokahikahin i na i ha oya Olibe. He gamagalau bolo alonau, heliya al kokowaliya hi os ge hi nonokahikahin. ");
INSERT INTO mpx_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","He ewasi Deibid wana wasa iyaka hi pek hi ba, “Ahitopel iyaka i tubwi am toawatautau elal bolo hi olak Absalom elana.” Inoke i awanun i ba, “O Yehoba, Ahitopel wana ba pelabalaba Absalom elana, nu pil getogaan ni ahe ni ola nuwatu sisigana.” ");
INSERT INTO mpx_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Sauga Deibid i vin oya Olibe pwatanaa labi toto gamagal hi tatapwalolowa Yabowaine elana, he Husai, iya ana tini Alki, iyoho to, nuwana alona nihi petupatupa-agil, ana kaliko i kukuleli ge kokowana i papakove. ");
INSERT INTO mpx_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Inoke Deibid i baek elana i ba, “He nasi nu tabwa pulowan eliyau ebo nu nem alou owa. ");
INSERT INTO mpx_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","U sikal Yelusalema yaka nu baek Absalom elana nu ba, ‘O kin, valila ya totuwalali tamwam kaiwena, yaa lan ebe na totuwalali kaiwem.’ Inoke eliyana bosowaina nu labeyau Ahitopel wana ba pelabalaba Absalom elana nu ba pakokove ni tabwa bugul bwagabwaga. ");
INSERT INTO mpx_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Topowon Seidok ge Abaiyada heliya al iyoho panuwaa hi misikal. Ebo wasa etega nu hago kin wana limiya, yaka nu baunanik elal. ");
INSERT INTO mpx_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Natuliyau bolau labui Ahimas Seidok natuna ge Diyontan Abaiyada natuna, iyoho to avaliyau. Ebo wasa etega nuku hago, yaka nuku patunal nihi nem eliyau no wasa nihi pem.” ");
INSERT INTO mpx_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Sauga Husai Deibid wana heliyam i na i vin Yelusalema, he Absalom abwe i vin, i tuktuk panuwa ana gana ana nog elana. ");
INSERT INTO mpx_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Deibid oya Olibe i eguluwan ge kekeisi i nawa nok, he Mepiboset wana totuwalali Siba iyoho to, i matamatan kaiwena. He donki enuna i lovivina-agil, yaka beleid ana gewi tu handeled (200), oine enona hi pakevakeva ana os ana gewi wan handeled (100), poga enona hi pakevakeva ana os ana gewi wan handeled (100) ge oine ana patuna maisena i usanil donki o pwataliyaa. ");
INSERT INTO mpx_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Yaka kin i nel Siba elana i ba, “Hauna kaiwena bugul bolo ya u pwatanim?” Anana i lahe i ba, “He donki alomwau natumwau kaiwemiu nuku heya, beleid ge poga bolau nihi an, ge gamagalau bolo tuwaliya ni aliga ula kekevana elana, oine nihi im.” ");
INSERT INTO mpx_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Inoke kin i nel i ba, “Wam tonowak Sol tubuna Mepiboset, iya ga?” Yaka Siba i baek elana i ba, “Iya iyoho Yelusalema, kaiwena i nuwatu i ba, ‘Lan ebe Isileli tubu wana abalogugui nihi pem ni minem eliyau.’” ");
INSERT INTO mpx_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Inoke kin i baek Siba elana i ba, “Sauga e, Mepiboset wana bugul gegewena iyaka ya pewa eliyam wam bugul.” Yaka Siba i ba, “No babala ge no kin, ya kululu eliyam. He ya awanun sauga gegewena nu yaliyaya-agau!” ");
INSERT INTO mpx_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Sauga kin Deibid panuwa Bahulim i nopakelakelaubwa, yaka tau etega i neem Sol ana tiniya i notagilem awan o elana. Alana Simei Gela natuna, i tagitagil ge i nonobaaba Deibid i ba panapanak-an. ");
INSERT INTO mpx_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","I ola al, pat i alialihin Deibid alonau wana totuwalali alaliya bwabwatal elal, bwagana iya iyoho i minaa tolohaveyan ge toasiyala gamwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","He Simei Deibid i ba panapanak-an i ola hiwe: “U egon! U egon! Toginol naknak owa ge nimwam i saliya! ");
INSERT INTO mpx_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Yehoba iyaka i lahewa, kaiwena Sol wana limi ana heniheni u lopaaligal ge abana u ahe u tologugui. He wam ginol o kaiwena, Yehoba wam abalogugui iyaka i pek natum Absalom elana. Owa iyaka nak u pwawa, kaiwena nimwam i saliya!” ");
INSERT INTO mpx_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Inoke Seluwaiya natuna Abisai i baek kin elana i ba, “Tau ya iya gamagal bwagabwaga ya, i ola ya te wanuka alialigana. I bwe owa no babala ge no kin i ba panapanak-agiwa? Na nok na na mwamwalina na gotomwa yoho!” ");
INSERT INTO mpx_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Yaka kin i ba, “Alom talim Yowab, nige wami puna i gagan ge nuku baaba kaiwena. Ebo Yehoba wana nuwatu i ola ge i ba panapanak-agau, he kilau nige wala sapu i gagan ge ta pabakuhu.” ");
INSERT INTO mpx_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Inoke Deibid i baek Abisai ge wana pan totuwalali alaliya bwabwatal elal i ba, “Natu hot te i logalogasisi nuwana ni lopaaligau. He nige bosowaina ta baaba tau ya iya ana un Beniyamina kaiwena. Ku teli ni ba panapanak-agau, kaiwena Yehoba i ba ola elana ni ginol. ");
INSERT INTO mpx_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Tab abwe Yehoba o pulowan ni kite, yaka ni mulolu-agau ba panapanak toto lan ebe ya pwawa, lahena waisi ni pem eliyau?” ");
INSERT INTO mpx_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Yaka Deibid ge wana boda hi nawa nok wali kamwasaa, yaa Simei i nawaa oya pwatanaa i nouliulil. Inoke i nonobaaba Deibid i ba panapanak-an, i ola al pat ge bilibili papakovana i alialihin elal. ");
INSERT INTO mpx_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Sauga kin ge wana boda hi vin wewel Yolidani, tuwaliya i aliga hot, yaka hi veyahowa to. ");
INSERT INTO mpx_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Absalom ge Isileli gegewel iyaka hi vin Yelusalema, he Ahitopel iyoho avaliya. ");
INSERT INTO mpx_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Yaka Husai, ana tini Alki, iya Deibid wana heliyam, i na Absalom elana ge i ba, “Wama kin, yawalim ni yapu! Wama kin, yawalim ni yapu!” ");
INSERT INTO mpx_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Inoke Absalom i neli i ba, “He wam nunuwana Deibid elana i ola o? Ga i ola nige u nana alom wam heliyam?” ");
INSERT INTO mpx_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Inoke anana i lahe i ba, “Tau toto Yehoba, gamagalau bolo alomwau ya ge Isileli gegewel hi hile ni kin, he nau iya kaiwena ge na minaa elana. ");
INSERT INTO mpx_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Ge nuwatu etega al, age bahi na tutuwalali no tonowak natuna kaiwena? Valila ya tuwalali tamwam eliyana, inoke i ola al to, sauga e na tuwalali eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Yaka Absalom i baek Ahitopel elana i ba, “He u ba labema. Wam nuwatu ga i ola, hauna binimala naha ginol.” ");
INSERT INTO mpx_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Anana Ahitopel i lahe i ba, “U na alomwau tamwam lagonau al ku kenu toyawa, bolo i eguluwagil kin limena hi matahikan. Yaka Isileli gegewel nihi atena iyaka u tabwa tamwam ana topihigelgel, inoke nihi atimatuwa ge nihi touliliwa.” ");
INSERT INTO mpx_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Inoke epanapana etega hi ginol limi pwatanaa, yaka Absalom i na alonau tamana lagonau al hi kenukenu gamwanaa, Isileli gegewel mataliyaa. ");
INSERT INTO mpx_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","He saugena o Ahitopel wana ba pelabalaba toto i baunan, tolaegan hi ahe i ola te i nenem Yehoba elana. He valila Deibid ana mel i teli, inoke Absalom i ginol i ola al to. ");
INSERT INTO mpx_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Yaka Ahitopel i baek Absalom elana i ba, “No nuwatu te binimala tolohaveyan ali gewi tuwel tausan (12,000) na ahel, inoke bulin e naha petaki uliulil Deibid enaa. ");
INSERT INTO mpx_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Sauga na kukuhikan, iya iyoho tuwana i aliga ge i pweyata. Na haveyan elana, yaka ni lovakun nabi ge wana gamagalau gegewel nihi lou luwai. He iya maisena ya te na lopaaliga, ");
INSERT INTO mpx_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","yaka gamagalau gegewel na ahel inoke na pasikalil eliyam. Toto ana lau u lau wana yaomal eliyana, yaka gamagalau gegewel nihi sikal elam ge nige nak etega nihi pwapwawa.” ");
INSERT INTO mpx_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","He nuwatu ya Absalom alonau Isileli wali tonowakau gegewel hi awa wawaisi-an. ");
INSERT INTO mpx_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Yaa Absalom i ba, “Husai ana tini Alki ku yogaan ni nem, yaka wana nuwatu ni baunan ta hago.” ");
INSERT INTO mpx_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Sauga i nok eliyana, yaka Ahitopel wana nuwatu Absalom i baunanik elana ge i nel i ba, “He ga i ola, tab wana baaba naha toulil? Ebo nigeya, inoke wam nuwatu u baunan naha hago.” ");
INSERT INTO mpx_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Anana Husai i lahe i ba, “Nuwatu toto Ahitopel i baunan, sauga e nige i wawaisi. ");
INSERT INTO mpx_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","U atena tamwam alonau wana bolau heliya tolohaveyan gasigasisel, i ola te ebo beya i huhuga natunau baeliya wana gasisi. I ola al, tamwam wana aatena haveyan kaiwena i bwata, inoke bulin e nige ni miminaa wana tolohaveyan elal. ");
INSERT INTO mpx_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","He sauga e, iya iyoho i bunsumi gol gamwanaa o ebo panuwa etega al elana. Binimala ni lohaveyan houwa wam tolohaveyan elal ge enuna ni lopaaligal, nasi bolo wasa nihi hago nihi ba, ‘Absalom wana tolohaveyan hi gulil.’ ");
INSERT INTO mpx_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Bwagana wam tolohaveyan bolo hi gasisi ge ateliya i matuwa i ola laiyoni, nasi lovakun kaiwena nihi ginuginu. Kaiwena Isileli gegewel hi atena tamwam iya toasiyala ge wana tolohaveyan ateliya i matuwa. ");
INSERT INTO mpx_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","“He no nuwatu i ola hiwe: Isileli wali tolohaveyan gegewel nu pamigogoil, ni telipunaa aluwabwa un Dani wali labiya ni na ana siga yavanaa panuwa Biyaseba, ali gewi ni ola gilesa talbwasiya. Yaka totom nu nulil nuku na haveyana. ");
INSERT INTO mpx_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Inoke ebo hauna labi elana ta pwawaa, yaka alonau wana tolohaveyan ta mikausil, ni ola bekubeku hunhunina i lalau bilibili pwatanaa. Inoke iya alonau wana gamagalau gegewel ta gulil, nige etega ni mwamwal. ");
INSERT INTO mpx_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Ebo ni lou ni na panuwa bwabwatana etega, inoke Isileli gegewel hihiu nihi ahe yaka panuwa o ana gana nihi momol lowan opopwa, ana siga gegewena hot ni samwalekaleka.” ");
INSERT INTO mpx_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Yaka Absalom ge Isileli wali tonowakau gegewel hi ba, “Husai ana tini Alki wana nuwatu i waisi lake te toto Ahitopel i baunan.” He i masal i ola to, kaiwena Yehoba iyaka i ba Ahitopel wana ba pelabalaba waiwaisana ni tabwa bugul bwagabwaga, inoke nak ni pwatanik Absalom elana. ");
INSERT INTO mpx_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Inoke Husai i na topowon Seidok ge Abaiyada elal, yaka Ahitopel ga i ba ola Absalom ge Isileli wali tonowakau elal ge iya al ga i ba ola, i wasaan elal. ");
INSERT INTO mpx_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","Yaka i ba, “He etimwawa Deibid ana baaba ku patuna nuku ba, ‘Bahi nuku kekenuwa wewel Yolidani ana abakalakalapaneta. Nuku kalapanet nuku noek labi kekevana elana, eba Absalom ge wana boda nihi nowa, yaka owa kin ge wam gamagalau gegewel nihi pwamowasemiu.’” ");
INSERT INTO mpx_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","He nuwatu iyaka hi tal haba i ola hiwe. Diyontan ge Ahimas nihi miminaa wewel bwanapitpit alana En-Logel, yaka totuwalali yovana etega ni nok wasa ni pwatanik elal ge heliya nihi na nihi wasaan Deibid elana. Nuwatu hi tal ola o, inoke bahi gamagalau nihi kikitel Yelusalema gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Yaa sauga totuwalali yovana i nok Diyontan ge Ahimas elal, geman etega i kite pwawal, yaka i na Absalom wana wasa i pek. Inoke etimwawa hi lou hi na tonowak etega wana limiya panuwa Bahulim. Wewel kenken etega iyoho wana bakubakuwa, inoke hi mwena lau gamwanaa hi bunsumi. ");
INSERT INTO mpx_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Yaka tonowak o lagona kaliko i ahe i yao wewel ana heguna pwatanaa. Inoke witi enowana i yoho valeyan pwatanaa, yaa nige gamagal etega i aatena ge i kikite. ");
INSERT INTO mpx_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Sauga Absalom wana totuwalali hi na yova elana limiya, yaka hi nel hi ba, “Ahimas ge Diyontan heliya ga?” Analiya i lahe i ba, “Heliya iyaka wewel hi kalapanet-an.” Yaka hi na hi loya, yaa nige hi pwapwawal, inoke hi sikal Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Sauga iyaka hi egon enaa, yaka Ahimas ge Diyontan hi mwena heem wewel kenken gamwanaa, inoke hi na hi baek kin Deibid elana hi ba, “Sauga e ku lut wewel ku kalapanet-an, kaiwena Ahitopel iyaka nuwatu i pek Absalom elana tage bulin e nihi nem nihi haveyan eliyamiu ge nihi lopaaligawa.” ");
INSERT INTO mpx_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Yaka bulin o Deibid alonau ge wana gamagalau gegewel hi lut wewel Yolidani hi kalapanet-an. He gegewel iyaka wewel labena etega mulaa abwe panuwa i mwananal. ");
INSERT INTO mpx_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Sauga Ahitopel i kite wana nuwatu nige hi totoulil, yaka wana donki i lovivina-an ge i heya pwatanaa, i na wana panuwaa Gilo. Inoke i vavaen natunau elal i ba ga nihi ginol ola, yaka abwe i na i gadisowa ge i aliga. Yaka tuwana hi teliya tubunau ali salaiya. ");
INSERT INTO mpx_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Deibid alonau gamagalau gegewel wewel Yolidani hi kalapanet-an enaa, yaka hi na panuwa Mahanaim. Absalom wana tolohaveyan i lovivina-agil hi neem Isileli ana labi gegewena elal, yaka heliya al wewel Yolidani hi kalapanet-an. ");
INSERT INTO mpx_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Absalom iyaka Amasa i teli wana tolohaveyan wali tohouwa, Yowab abana i milahe. (Amasa tamana alana Yeta, gagama Isileli, ge hinana Abigeil. Abigeil talina Seluwaiya Yowab hinana, tamaliya alana Nahas.) ");
INSERT INTO mpx_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Inoke Absalom alonau Isileli wali tolohaveyan hi holaviya labi Giliyad. ");
INSERT INTO mpx_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","He sauga Deibid i vin Mahanaim, inoke Nahas natuna Sobi, gagama Laba labi Amoni, Amiyel natuna Makil, Lo-Debal gamagalina, ge Basilai, gagama Logelim labi Giliyad, hi na hi kite. ");
INSERT INTO mpx_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","He abakenu, mwaha ge ulun hi bugul pwatanik elana. I ola al aanan witi, bali, pwalawa, bali ekekana, bin, lentil, ");
INSERT INTO mpx_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","luvi, sipi, goti ge sis tomaha hi ginolem bulumwakau hulina elana hi pwatanik Deibid ge wana gamagalau aliya. Hi ginol ola o kaiwena hi nuwatu hi ba, “Gamagalau hi nawanawa nabi ula kekevana elana, inoke hi galebu, hi walem ge tuwaliya i aliga.” ");
INSERT INTO mpx_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Deibid wana tolohaveyan gegewel i pamigogoil, yaka wali tohouwa enuna i hilel inoke i telel boda tomaha ona, enuna tausan ali tohouwa ge enuna handeled ali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Yaka i walel boda eton, etega Yowab i nulil, eluwana Abisai iya Yowab talina hinaliya alana Seluwaiya i nulil ge etonina Itai, gagama Gat i nulil. Inoke i baek elal i ba, “Nau al ge na nowa alowau komiu.” ");
INSERT INTO mpx_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Yaa wana tolohaveyan hi baek elana hi ba, “Bahi nu nenem aloma owa. Ebo nihi takela ta lou, nasi nige nihi nuwanuwatu kaiwema. Bwagana ebo naha gewi nabi naha aliga, yaa nige nihi nuwanuwatu kaiwema. He owa te nasi am lau nihi lau, inoke owa am nuwatu i ola te ama gewi ten tausan (10,000). He i waisi te nu misikal, yaka ama labe nu papatuna eliyama.” ");
INSERT INTO mpx_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Analiya kin Deibid i lahe i ba, “Hauna ku nuwatuan kaiweu i waisi, yaka na ginol ola.” Inoke i talmilil panuwa ana abauluulutuk bebenaa, yaka wana tolohaveyan ali boda tausan ge handeled ona hi nawa tagil. ");
INSERT INTO mpx_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","He kin iyaka logugui i baunan Yowab, Abisai ge Itai elal i ba, “Nau kaiweu, nuku hehegan bubun heval Absalom elana.” Inoke sauga i baaba tohouwa elal Absalom kaiwena, tolohaveyan gegewel hi hago. ");
INSERT INTO mpx_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Yaka tolohaveyan panuwa hi eguluwan hi na ula etega alana Ula Ipileimi, inoke avaliyau Isileli hi petupatupa-agil ge hi lohaveyan. ");
INSERT INTO mpx_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Deibid wana tolohaveyan Isileli hi pakokovel, yaka lan o nak bwabwatana hot hi pwawa ge ali gewi tuwenti tausan (20,000) hi aliga. ");
INSERT INTO mpx_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","He haveyan i nem nowa labi gegewena o elana, inoke hi gewi ula ana nak ona hi pwawa ge hi aliga, yaa bolo hi gopaaligal nige hi gegewi. ");
INSERT INTO mpx_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Heliya iyoho hi lohalohaveyan, he Absalom i heya wana miul pwatanaa yaka Deibid wana tolohaveyan enuna i lilipwawal. Nuwana ni lou, yaa sauga i sola abwakil ouk bwabwatana lalana babalona gabulanaa, yaka kokowana i pano. Inoke i havakuki hawawala, yaa wana miul iyoho i mimi patapatalelu. ");
INSERT INTO mpx_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","He tolohaveyan etega i kite pwawa, yaka i na i baek Yowab elana i ba, “Absalom ya kite i kukuki abwakil ouk elana.” ");
INSERT INTO mpx_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Inoke anana Yowab i lahe i ba, “Ine? Age u kite yaka nige u lolopaaliga? Binimala nu lopaaliga, he nasi na yaliyaya hot inoke silba ana gewi elulutega ge toasiyala wali wasikewa na pewa molam.” ");
INSERT INTO mpx_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Yaa anana tau o i lahe i ba, “Bwagana ebo silba ana gewi tausan maisena nu pem, yaa nige bosowaiu nimwau ni tal kin natuna elana ge na lolopaaliga. Ama gegewema ha hago kin i baewa alomwau Abisai ge Itai eliyamiu i ba, ‘Nau kaiweu bahi nak etega nuku giginol heval Absalom elana.’ ");
INSERT INTO mpx_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","He binimala ebo kin natuna yawalina na apanak, tunahot wasau kin ni hago, kaiwena nige bugul etega i mimisumi elana tage nige ni aatena. Yaka owa am bwaga ni gan elau nige nu babaa labeyau.” ");
INSERT INTO mpx_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Inoke Yowab i ba, “Nige al na matamatan alou owa ta liwaliwan.” Yaka gau eton i ahel i na Absalom i howaa babagalinaa, sauga toto yawalina iyoho ya ge i kukuki abwakil elana. ");
INSERT INTO mpx_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Yaka tolohaveyan bolo Yowab wana elohaveyan ana tokaval ali gewi elulutega hi na Absalom hi mipainan inoke hi gopaaliga. ");
INSERT INTO mpx_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Yaka Yowab bwagigi i yu tolohaveyan ni pabakuhol, inoke hi veyaho petaki Isileli eliyaa. ");
INSERT INTO mpx_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","He Absalom bwaliwawagana hi ahe yaka hi alipalo gol bwabwatana elana bilibili gamwanaa, inoke pat ana pwahin bwabwatana hi pahe pwatanaa. Yaa Isileli wali tolohaveyan hi lou hi na tomaha ona wali panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Absalom yawalina miminana, pat mamanana etega i pamilila panuwa etega alana Kin Abwabwina elana iyoho Yelusalema bebenaa, totona alana ana abanuwahikan. I ginol ola o, kaiwena i nuwatu i ba, “Nau nige natuwau bolau hi gagan ge alau nihi pakalapapanet-an o tini elana.” Inoke totona alana i tun pwatanek pat o elana, ge gamagalau alana hi babaa ola “Absalom ana Abanuwahikan” ana siga te lan ebe. ");
INSERT INTO mpx_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Inoke Ahimas Seidok natuna i baek Yowab elana i ba, “Na patalelu wasa na pwatanik kin elana te Yehoba iyaka i pwamwalem ana topihigelgel nimaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Yaka Yowab i ba, “Bahiwa, lan ebe bahi owa nu nana nu wawasa. Sauga etega al abwe wasa getoga etega nu pwatanik, yaa lan ya bahiwa, kaiwena kin natuna iyaka i aliga.” ");
INSERT INTO mpx_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Inoke i baek gagama Itiyopiya etega elana i ba, “U nok u na hauna gun iyaka u kite u wasaan kin elana.” Yaka Yowab ana awatauwan kaiwena i kululu lau, inoke i patalelu egon. ");
INSERT INTO mpx_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Yaka Ahimas i ba lawalawakik Yowab elana i ba, “Bwagana hauna ebo ni gan, yaa na patalelu gagama Itiyopiya enaa.” Inoke Yowab i baek elana i ba, “Natu, hauna kaiwena nuwam nu nok? Nige wasa waiwaisana i gagan elam ge tage kin molam ni pewa wasa o kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Yaka Ahimas i ba, “Bwagana hauna ebo ni gan, yaa nuwau na patalelu nok.” Inoke Yowab i ba, “He nu nok.” Yaka Ahimas i patalelu egon i noek abwab elana ge gagama Itiyopiya i patalelu luwai i na i vin houwa Mahanaim. ");
INSERT INTO mpx_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","He Deibid i misiyowa panuwa ana abauluulutuk ana nog toto noleleya ge toto maleleya ali luwaluwala. Tolohaveyan etega wana tuwalali te ni kenan, yaka i na i ha gana ana abaulululutuk pwatanaa. Matana i lipwapwati, yaka tau etega i kite maisena ya i papatalelu nem. ");
INSERT INTO mpx_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","Inoke i yoga lau kin wana wasa i pek. Yaka kin i ba, “Ebo maisena ya, he wasa waiwaisana te i pwapwatanim ei.” Inoke tau toto i patalelu iyaka i tatakelakelaubwa. ");
INSERT INTO mpx_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","Yaka tokenan tau etega al i kite i papatalelu nem. Yaka i yoga lau nog ana tomatahikan elana i ba, “Tau etega al to, maisena ya i papatalelu nem.” Yaka kin i ba, “Iya al wasa waiwaisana i pwapwatanim.” ");
INSERT INTO mpx_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Inoke tokenan i ba, “Tau toto houwan wana patapatalelu ya kite i ola te Ahimas, Seidok natuna.” Yaka kin i ba, “Iya tau waiwaisana. He wasa waiwaisana te i pwapwatanim ei.” ");
INSERT INTO mpx_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Sauga Ahimas i vin, inoke i yoga kin elana i ba, “Bugul gegewena i waisi.” Yaka maninina i pahanalowanek bilibiliya kin awonaa ge i ba, “Yehoba wam Yabowaine ta tobalan! Bolo hi awatautau owa no babala ge no kin elam, Yehoba iyaka i telel nimalaa ge ta pakokovel.” ");
INSERT INTO mpx_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Inoke kin i nel i ba, “Yaa heval Absalom i molu ya?” Anana Ahimas i lahe i ba, “Tonowak, sauga Yowab nau ge gagama Itiyopiya toto i totuwalali elam i patunama ha nem, he samwayagayaga bwabwatana ya kite, yaa nige ya aatena hauna i gan.” ");
INSERT INTO mpx_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Inoke kin i baek elana i ba, “U talmilila ga huwo ge u matamatan.” Yaka i ginol ola wana baaba. ");
INSERT INTO mpx_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Inoke gagama Itiyopiya i vin ge i ba, “No babala ge no kin, wasa waiwaisana nu hago! Lan ebe Yehoba i pwamwaliwaem bolo hi pihigelgel elam nimaliyaa.” ");
INSERT INTO mpx_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Yaka kin i nel i ba, “Yaa heval Absalom i molu ya?” Anana i lahe i ba, “No babala ge no kin, binimala am topihigelgel ge bolo hi awatautau elam gegewel nihi ola to heval o.” ");
INSERT INTO mpx_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","He kin nuwana i nak nabi. Yaka alona wana kahin i na i ha lum toto abauluulutuk pwatanaa, i nonokahikahin i ba, “O natu Absalom! Natu, natu Absalom! Binimala nau te na aliga, owa bahiwa! O Absalom, natu, natu!” ");
INSERT INTO mpx_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Yowab wana wasa hi pek hi ba, “Kin Deibid nuwana i nak Absalom kaiwena yaka i kahikahin.” ");
INSERT INTO mpx_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Tolohaveyan gegewel wasa hi hago te kin i nuwanak natuna kaiwena, inoke lan o wali tagalaka ana yaliyaya i pil i tabwa nuwanak. ");
INSERT INTO mpx_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","Yaka hi nokekei hi tuk panuwaa, i ola tolohaveyan bolo hi puluwawi kaiwena hi louem haveyana wali ginol. ");
INSERT INTO mpx_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Yaa kin maninina i kaus yaka i kahikahin anana i bwata i ba, “O natu Absalom! O Absalom, natu, natu!” ");
INSERT INTO mpx_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Inoke Yowab i na kin wana limiya ge i baek elana i ba, “Lan ebe wam tolohaveyan gegewel u papuluwawi-agil, heliya te abwe owa alomwau natumwau, lagomwau hot ge lagomwau al yawalimiu hi pwamwal. ");
INSERT INTO mpx_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","Bolo hi pihigelgel-agiwa, owa u nunuwana-agil, yaa bolo hi nunuwana-agiwa, owa u pihigelgel-agil. He wam ginol eliyana lan ebe u pamasal te tolohaveyan avaliyau wali tohouwa ona heliya hi ola bugul bwagabwaga eliyam. Iyaka abwe ya atena binimala lan ebe Absalom nige ni aaliga ge ama gegewema naha aliga, nasi nu yaliyaya. ");
INSERT INTO mpx_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Sauga e nu tagil nu na wam tolohaveyan ateliya nu ba pamatuwa. Ya papasila Yehoba alanaa te ebo nige nu tatagil, mulaa abwe bulin ni gan nige tolohaveyan etega ni miminaa elam, nasi gegewel nihi eguluwagiwa. Inoke pulowan toto o ni bwata hot elam, ni lake te pulowan gegewel bolo u pwawal, i telipunaa wam sauga heval ana siga sauga ya.” ");
INSERT INTO mpx_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Inoke kin i tagil i na i misiyo panuwa ana abauluulutuka. Sauga wana tolohaveyan wasa hi hago iya iyoho i misiyo abauluulutuka, yaka gegewel hi nok elana. He Isileli wali tolohaveyan iyaka hi lou hi na tomaha ona wali panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","Inoke ali un gegewel gamwaliyaa, gamagalau hi peawabalgig hi ba, “Kin Deibid te i pwamwalila ala topihigelgel elal. He iya te eliyana ge ta mwal Pilistiya nimaliyaa. Yaa Absalom kaiwena iyaka i lou i na labi etega. ");
INSERT INTO mpx_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","He Absalom te valila ta hile wala kin i logugui-agila, yaa iya iyaka i aliga haveyana. Inoke ga i ola ta mikekei nige ta babaaba ge kin Deibid ta een pasikal?” ");
INSERT INTO mpx_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Deibid topowon Seidok ge Abaiyada ali baaba i patuna nihi na Yuda wali tonowakau elal, yaka iya wana baaba nihi baunan nihi ba, “Bahi komiu nuku tatabwa un mowamowasena ge abwe nuku nenem nau kin nuku een pasikalau no limiya Yelusalema. Ya ba ola o, kaiwena Isileli labi gegewel hauna hi baunan iyaka wasana ya hago. ");
INSERT INTO mpx_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Komiu tutuwau, totou saliyau ge bunumwiu. Bahi komiu nuku tatabwa un mowamowasena ge abwe nuku nenem nuku een pasikalau.” ");
INSERT INTO mpx_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","I ola al, Seidok ge Abaiyada ali baaba i patuna nihi na Amasa elana nihi ba, “Deibid i ba, ‘Owa tutu, totou saliyau ge bunumwiu. Inoke i telipunaa lan ebe, ya telewa no tolohaveyan wali tohouwa Yowab lahena. Ebo nigeya, ya awanun Yabowaine lahi pupulowanina hot ni ginol elau.’” ");
INSERT INTO mpx_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Yaka Yuda gegewel wali nuwatu i maisena hi olak Deibid elana. Inoke kin Deibid ana baaba hi patuna hi ba, “U sikalim alomwau ge wam gamagalau gegewel.” ");
INSERT INTO mpx_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Inoke Deibid ge wana gamagalau hi nawa sikal ana siga hi vin wewel Yolidani. He Yuda iyaka hi vin Gilgal ge abwe nihi na avaliya kin nihi petupatupa-agil wewel Yolidani ge nihi pakalapanet-an. ");
INSERT INTO mpx_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Gela natuna Simei, gagama Bahulim, ana un Beniyamina, i lilipatotoya alonau Yuda hi na hi lau wewel Yolidani kin Deibid nihi kite. ");
INSERT INTO mpx_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","He alonau un Beniyamina ali gewi tausan maisena, i ola al Siba, Sol ana un wali totuwalali, alonau natunau ali gewi piptin (15) ge wana totuwalali ali gewi tuwenti (20). Inoke hi lilipatotoya hi na hi vin wewel Yolidani labi toto kin i miminaa. ");
INSERT INTO mpx_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Inoke hi kalapanet wewel ana abakalakalapaneta kin alonau wana limi ana heniheni nihi pakalapanet-agil ge hauna ebo ni baunan yaka nihi ginol. Sauga Simei Gela natuna i kalapanet, yaka i talpo kin manininaa ");
INSERT INTO mpx_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","ge i baek elana i ba, “No babala ge no kin, lan toto Yelusalema u eguluwan gegi ya ginol elam. No babala, ya awanun no gegi o bahi nu nunuwahikan, yaa nu nuwayoho ge bahi nu kukuhikan atemwa. ");
INSERT INTO mpx_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Nau wam totuwalali ya atena te iyaka ya gegi, inoke Isileli ali un elulutega gamwaliyaa nau hiwe ya nem houwa lan ebe alou owa ta petupatupa-agila.” ");
INSERT INTO mpx_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Inoke Seluwaiya natuna Abisai i ba, “Binimala Simei ta lopaaliga wana gegi lahena! Kaiwena owa Yehoba wana hilihili gamagalina i ba panapanak-agiwa.” ");
INSERT INTO mpx_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Yaka anana Deibid i lahe i ba, “Alom talim Yowab, nige wami puna i gagan ge nuku baaba kaiwena. He wami ginol lan ebe i ola te komiu o topihigelgel! Age nige ku aatena lan ebe iyaka hi teli pasikalau nau Isileli wali kin? Inoke tage na ba gamagal etega nihi lopaaliga Isileli gamwaliyaa? Nigeya!” ");
INSERT INTO mpx_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Yaka i papasila ge i bateli Simei elana i ba, “Nige nu aaliga.” ");
INSERT INTO mpx_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Mepiboset, Sol tubuna, iya al ge i na wewel Yolidani inoke alona ge kin nihi petupatupa-agil. He sauga kin Yelusalema i eguluwan ana siga lan o ge ni sikal, Mepiboset wana nuwanak kaiwena nige aena i uul, awana i kokol ge nige ana kaliko i uulil. ");
INSERT INTO mpx_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Sauga i neem Yelusalema ge alona kin hi petupatupa-agil, yaka kin i nel elana i ba, “Mepiboset, ga i ola nige u nenem alou owa?” ");
INSERT INTO mpx_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","Anana i lahe i ba, “No babala ge no kin, u atena ya te nau wam totuwalali aeu hi nak nige bosowaiu na nawanawa bubun, inoke ya nuwatu ya ba, ‘Na ba no donki nihi lovivina-an, yaka na heya ge alou kin naha nok.’ Yaa no totuwalali Siba i kakaweyau. ");
INSERT INTO mpx_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Yaka abwe i nowa ge wasau i wasa panapanak-an no babala ge no kin elam. Yaa owa u ola Yabowaine wana anelose etega sapu ge kakawi ali getoga u atena. Inoke hauna u nuwatuan i waisi, he u ginol ya. ");
INSERT INTO mpx_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","No babala ge no kin, Sol tubunau gegewema nige wama sapu etega i gagan matamwa, bosowaina te nu lopaaligama. Yaa owa u ba nau wam totuwalali ya aanana wam teibola. He nige no sapu i gagan ge na awanun vevehe eliyam.” ");
INSERT INTO mpx_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Yaka kin i baek elana i ba, “Besena liwaliwan! Nau ya ba alom ge Siba tubum wana bilibili nuku wali paolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Inoke Mepiboset i ba, “He gegewena u talamwan ni ahe ya! Nau ya yaliyaya, kaiwena iyaka u sikalim alona wam molu.” ");
INSERT INTO mpx_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Basilai al ge labi Giliyad gamagalina i noem panuwa Logelim i na wewel Yolidani, inoke kin ni en alona nihi kalapanet ge ni patuna wana kamwasaa. ");
INSERT INTO mpx_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Iya iyaka i liki, wana baliman ana bwata eiti (80). Iya togogomwau hot, inoke kin ge alonau i matahikagil sauga i miminaa Mahanaim. ");
INSERT INTO mpx_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Inoke kin i baek Basilai elana i ba, “Alou owa ta kalapanet yaka abwe nu miminaa elau Yelusalema ge na matahikagiwa.” ");
INSERT INTO mpx_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Yaa anana Basilai i lahe i ba, “Bahiwa! Iyaka ya liki nabi, nasi nige sauga ni yayapu yaka na yaomal, inoke ana sapu ga i ola ge na nowa ta na Yelusalema? ");
INSERT INTO mpx_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","No baliman eiti (80) iyaka i pwawa ge nige bosowaiu amnan waiwaisana ge amnan nanakina ali getoga na atena. Iyaka nige bosowaina hauna na an ge hauna na im amnaliya na anbose. Nige bosowaina towonawona analiya na hago. He bahi na nonowa eba na tabwa pulowan no babala ge no kin elam. ");
INSERT INTO mpx_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Alou owa wewel Yolidani ta kalapanet-an ge kekeisi al ta novevehe. Yaa bahi o mulolu nu giginol ni ola hauna u baunan. ");
INSERT INTO mpx_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","He u talamwagau na sikal, yaka abwe na aligaa no panuwaa ge nihi teleyau nam ge nain ali salai labenaa. Yaa no babala ge no kin, natu Kimham hiwe, alom nuku nok inoke hauna u nuwatuan i waisi yaka nu ginol eliyana.” ");
INSERT INTO mpx_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Inoke kin i ba, “I waisi, Kimham ni nem alou yaka waisi toto na ginol eliyana nasi ni ola wam nuwatu. Ge hauna ebo nu awununi elau, na ginol kaiwem.” ");
INSERT INTO mpx_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Yaka gamagalau gegewel wewel Yolidani hi kalapanet-an ge abwe kin Deibid al i kalapanet. Inoke abwe Deibid Basilai i nalo ge i awanun Yehoba ni muloluan, yaka Basilai i sikal wana panuwaa. ");
INSERT INTO mpx_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Inoke kin alona Kimham hi na panuwa Gilgal. He un Yuda gegewel ge Isileli ali un awalehina kin Deibid hi pakalapanet-an wewel Yolidani ge hi matahikan wana kamwasaa. ");
INSERT INTO mpx_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Yaka abwe Isileli bolauiliyau gegewel hi noknok kin elana ge hi babaa, “Hauna kaiwena talimeyau Yuda bolauiliyau nige wama wasa hi pepem ge alomeyau naha pakalapanet-agiwa? He hi nowa sumi, yaka alomwau natumwau ge wam tolohaveyan gegewel hi pakalapanet-agimiu wewel Yolidani.” ");
INSERT INTO mpx_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Inoke Yuda bolauiliyau Isileli wali apwanawa hi lahe hi ba, “Ha ginol ola o, kaiwena iya ama un gamagalina. He ga i ola ge baena ku huga? Age kin aanan i guguyau eliyama ge ha aanana? Nigeya! Age gogomwau enuna ha ahe kaiwema? Nigeya!” ");
INSERT INTO mpx_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Yaka analiya Isileli bolauiliyau hi lahe hi ba, “Age komiu ya wami kin Deibid ge ama nigeya? Nige i oola! He ama un ali gewi elulutega (10), yaa komiu ami un maisena ya. Inoke ama wama sapu i bwata lake te komiu wami sapu. Ga i ola ku kite lowagima ge ginol o ku ginol eliyama? Ama te ha baaba houwa ha ba, ‘Wala kin ta en pasikal.’” Yaa Yuda hi ba lahi analiya i gasisi hot, Isileli analiya i gasisi lake. ");
INSERT INTO mpx_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Yowab, iya Isileli wali tolohaveyan gegewel wali tohouwa. Yehoiyada natuna Benaiya, iya boda Keleti ge boda Peleti wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Adonilam, iya totuwalali bolo nige molaliya i logugui-agil. Ahilud natuna Yehosapat, iya kin wana logugui ana tomatahikan ge ana towasa. ");
INSERT INTO mpx_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","Seva iya toleleli. Seidok ge Abaiyada heliya hi topowon, ");
INSERT INTO mpx_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","ge Yail tubutubunina etega alana Ila, iya Deibid wana topowon. ");
INSERT INTO mpx_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","Deibid wana sauga kin gamwanaa, galebu bwabwatana i gan ge i tutubwe baliman eton. Inoke Deibid i awaawanun Yehoba elana pulowan o kaiwena. Yaka Yehoba i baek elana i ba, “He i gan, kaiwena valila Sol boda Gibiyon i lopaaligal nuwana ni pwamowasel, inoke Sol ge tubutubunau iyaka nimaliya i saliya.” ");
INSERT INTO mpx_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Sauga Yehoba Deibid i pwamwalem ana topihigelgel gegewel ge Sol nimaliyaa, inoke wona ya i wonaan Yehoba elana, ");
INSERT INTO mpx_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","i ola hiwe: Yehoba i ola no pat mihahaina, no ababunsumi ge iya i aheyauem nak elana; ");
INSERT INTO mpx_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","no Yabowaine i ola no pat ge no abalou tuk,   o ligovan ge no topwamwal gasigasisena. Iya no sivesive, no abalou ge no topwamwal,   iya i pwamwalau toginol naknak elal. ");
INSERT INTO mpx_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Ya yoga ha Yehoba elana, iya alana ta tobalan,   ge i pwamwalau o topihigelgel eliyalil. ");
INSERT INTO mpx_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Yaomal i ola bagol i bini pwatawa;   nak i ola alol i yaleyau. ");
INSERT INTO mpx_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Tuma i ola hihiu i avanau;   yaomal i ola kimul i kota hikagau. ");
INSERT INTO mpx_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","No minanakina hot elana ya yoga ha Yehoba elana;   ya yoga no Yabowaine elana. Yaka anau i hagoem wana limi bwabwalena elana;   no kahin labe kaiwena i laeganan. ");
INSERT INTO mpx_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Yaka panayawi i lomwaniknik ge i tulutulu,   ge labulabum ana wauwau i lamwalamwaniu,   kaiwena Yabowaine i huga. ");
INSERT INTO mpx_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Inoke i ola kasu i tagilem buhunaa;   hiwo memena i tagilem awanaa   ge gibwal kalakalasina i ligin lowan. ");
INSERT INTO mpx_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","Labulabum i pwela yaka i nem i lau;   yaluyalu bibikena i minaa aena gabulanaa. ");
INSERT INTO mpx_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Wana nem i ola i heheya anelose elana ge i yoyou;   i ola i gagavai leuleu elana. ");
INSERT INTO mpx_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","Tuwana i os gogou elana   ge milil leuleuina yaluyalu bibikel elal. ");
INSERT INTO mpx_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","Mwananal bwabwatana i yana awonaa   ge pinamal i lilitautau i tagilem elana. ");
INSERT INTO mpx_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Yehoba Tomihahaina Hot i baaba,   anana i ola gulumwawa i loem labulabumwa. ");
INSERT INTO mpx_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","Pinamal i ola egipoyo gauina i alihin, yaka ana topihigelgel nuwaliya i pagewagewa ge hi lou. ");
INSERT INTO mpx_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Hoga i kevakeva gunina i masal   ge panayawi ana wauwau i mwananal bosowaina ta kite, kaiwena Yehoba i ba haveyan   ge wana huga elana i ba lala. ");
INSERT INTO mpx_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","Nimana i paelu lowanem natiya ge i pihikagau,   yaka i momol heyagau banata gasigasisena elana. ");
INSERT INTO mpx_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","I pwamwalauem o topihigelgel gasigasisel elal,   heliya hi huga eliyau ge hi gasisi lakeyau. ");
INSERT INTO mpx_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Hi mikausau ya minaa nak gamwanaa,   yaa Yehoba iya o tolabe. ");
INSERT INTO mpx_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","I aheyauem nak elana ge i teleyau labi waiwaisana elana;   i pwamwalau, kaiwena i yaliyaya kaiweu. ");
INSERT INTO mpx_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Yehoba i hehegan bubun eliyau kaiwena no ginol i sapu,   ge o mulolu i pem kaiwena nige nak ya giginol. ");
INSERT INTO mpx_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","He Yehoba wana kamwasa ya toulil,   nige ya gegegi ge no Yabowaine ana en ya pepek. ");
INSERT INTO mpx_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Wana logugui gegewena ya nuwahikagil   ge ali baaba nige ali en ya pepek. ");
INSERT INTO mpx_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Nige o woliwoli i gagan matanaa   ge ya matahikagau bahi gegi na giginol. ");
INSERT INTO mpx_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Yehoba o mulolu i pem kaiwena no ginol i sapu,   ge nige nak ya giginol, ya henapu matanaa. ");
INSERT INTO mpx_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Bolo wam baaba hi henapuan, owa u nunuwana-agil,   bolo nige nak u pwapwawaa elal, owa nige nak u giginol elal. ");
INSERT INTO mpx_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Bolo wali ginol i sapu, owa wam pagan i sapu elal,   yaa bolo hi sigasiga, owa u teli gegetoga elal. ");
INSERT INTO mpx_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","Bolo hi hanalau u pwamwalil,   yaa bolo hi hanaha u kite hikagil ge u teli lowagil. ");
INSERT INTO mpx_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","O Yehoba, owa u ola no odam,   inoke no gogou u payane. ");
INSERT INTO mpx_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Wam labe eliyana, bosowaiu na tagalaka tolohaveyan ali boda elal,   ge owa no Yabowaine wam gasisi eliyana, bosowaiu panuwa ana gana na mwena likaan. ");
INSERT INTO mpx_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Yabowaine, iya wana pagan bwalibwaligena i waisi;   Yehoba wana baaba i tunahot.   Iya i ola ligovan bolo hi lou tuk elana kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Nige Yabowaine etega al, iyai te Yehoba,   nige pat abalou etega al, iyai te wala Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Yabowaine iya i pagasisi-agau   ge no kamwasa i pwamwananal. ");
INSERT INTO mpx_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","I labeyau aeu ya pilibubun mananaknak elal i ola diya;   i labeyau ya mwena ha ya talmilil oya pwataliyaa. ");
INSERT INTO mpx_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","Haveyan ana kamwasa i pankiteyau;   i pagasisi-agau bosowaiu egipoyo eloelolina na momol ge gauina na alihin. ");
INSERT INTO mpx_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","Wam pwamwal i ola o ligovan;   u labeyau yaka eliyana ya gasisi. ");
INSERT INTO mpx_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Kamwasa i magaga u pwela awowa,   yaka ya nobubun nige aeu ya hahanapil. ");
INSERT INTO mpx_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","O topihigelgel ya takel ge ya apapanak-agil,   nige ya sisikalek ewa ana siga ya pwamowasel. ");
INSERT INTO mpx_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Ya gopasogol nige bosowailiya nihi lut;   hi sogu hi minaa aeu gabulanaa. ");
INSERT INTO mpx_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","U pagasisi-agau haveyan kaiwena,   ge o topihigelgel u nulil hi kululuwa aewa. ");
INSERT INTO mpx_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","U ba o topihigelgel hi lou matawa,   ge bolo hi hugaagau ya apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Labe kaiwena hi yoga, yaa nige gamagal etega bosowaina ni pwamwalil;   hi yoga Yehoba elam yaa nige analiya u lalahe. ");
INSERT INTO mpx_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Ya pimukumuku-agil hi ola bilibili papakovana;   ya pulilolowagil hi ola pweyapweya kamwasaa. ");
INSERT INTO mpx_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","U pwamwalauem no gamagalau bolo hi teli gegetoga elau nimaliyaa;   u matahikagau ya tabwa boda tomaha ona wali tohouwa. Gamagalau bolo valila nige ya aatenal, sauga ya hi minaa no logugui gabulanaa; ");
INSERT INTO mpx_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","toloha ginebi wali lovakun hi kululu eliyau,   ge ebo ya baaba elal, no logugui hi toulil. ");
INSERT INTO mpx_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Wali atimatuwa i mowasi,   yaka wali sivesive hi eguluwan alona wali ginu hi nem elau. ");
INSERT INTO mpx_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Yehoba i mihot! Iya Pat no abalou ta tobalan!   No Yabowaine, iya Pat no abamwal, alana ta latahin! ");
INSERT INTO mpx_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Bolo hi ginol panak elau Yabowaine i tagalahi elal,   boda ona i telel no logugui gabulanaa, ");
INSERT INTO mpx_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","ge i sokalauem o topihigelgel elal. O Yehoba, u oeyau bolo hi hahaveyan elau nimaliyaa;   u pwamwalauem toginol naknak elal. ");
INSERT INTO mpx_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Inoke na tobalagiwa boda ona gamwaliyaa;   ge alam ana tobal na wonaan. ");
INSERT INTO mpx_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","Yehoba i labeyau nau kin o topihigelgel ya pakokovel hoti;   wana atilomwan i gangan wana hilihili gamagalina nau Deibid elau,   ge tubutubuwau elal nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Tomihahaina Hot abamina bwabwatana i pek Deibid Diyesi natuna elana, Yakobo wana Yabowaine i hile ni tabwa kin,   ge iya Isileli wali wona waiwaisal ana totomwatomwa. He wana wona mowamowasena ana baaba i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","Yehoba Yayaluwana wana baaba i baunanim na baunan,   iya wana liwaliwan elau na pamasal. ");
INSERT INTO mpx_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Isileli wala Yabowaine,   iya wala Pat abalou, i baem elau i ba: “Ebo gamagal etega ni tologugui alona wana ginol sasapona,   ebo ni nul alona nau Yabowaine o lovakun, ");
INSERT INTO mpx_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","he iya i ola sabwelu matakululuna sauga i haha mwelulugaa,   nige ana yaluyalu, i ola kehe mwawin i pahun i siun bilibiliya,   ge sabwelu i yane namanamalina.” ");
INSERT INTO mpx_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Nau alowau tubutubuwau Yabowaine i hilema naha kin.   Wana bateli i baunan eliyau ni mihot,   bateli o iya i nuwatuan ge ni patunahot. Sauga gegewena i pwamwalau   ge waisi toto nuwau nasi ni ba ni gan. ");
INSERT INTO mpx_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Yaa gamagalau nanakil ni apapanak-agil ni ola pepesala ta tomwa yohil,   heliya nige bosowaina niman elana ta libhikagil. ");
INSERT INTO mpx_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Nige bosowaina nimala awawana elana ta tuwalali-an,   iyai te etuwalali aiyan ge ebwakil elana bosowaina ta tomwa palol,   yaka abwe ta pahel ge ta ton olagil. ");
INSERT INTO mpx_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Yaka Deibid abapowon i ginola to Yehoba elana ge bulumwakau i powon pwabwaligel ge enuna i powonagil heliheliyam powonina. Yaka gamalagau wali awaawanun wali labi kaiwena Yehoba i hago, inoke kasiyebwa nanakina labi Isileli elana i bakuhu. ");
INSERT INTO mpx_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Pesiya wali kin Sailusa wana logugui ana baliman houwan gamwanaa, Yehoba nuwatu etega i ginol inoke wana baaba i tabwa tunahot, toto palopita Yelemaiya i baunan. Sailusa atena i pawaiwai yaka i lut logugui etega i ginol. Logugui ya hi leli lowan, inoke i patuna i tagil hi vasili wana abalogugui gamwana gegewena elal, i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","Sailusa, Pesiya wala kin, i ba: Yehoba, labulabum ana Yabowaine, abalogugui gegewena panayawiya i pem eliyau, ge i hileyau Limi Bwabwalena etega na tal iya kaiwena Yelusalema labi Yudiya elana. ");
INSERT INTO mpx_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Ebo wana gamagalau enuna hi minaa gamwamiwa, wali Yabowaine ni minaa elal ge ni muloluagil. Inoke nihi na Yelusalema labi Yudiya, ge Yehoba Isileli wali Yabowaine toto i minaa Yelusalema, wana Limi Bwabwalena nihi tal. ");
INSERT INTO mpx_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","I ola al, ebo Yudiya bolo hi mina, enuna iyoho hi mibwabwali wami panuwa tomaha ona elal, inoke nuku label. Silba, gold, bugubugul ona ge bwasumu, ginebi wami mulolu enuna al, nuku pek elal Yabowaine wana Limi Bwabwalena Yelusalema ana taltal kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Inoke un Yuda ge un Beniyamina ali tini ona wali tohouwa, topowon, ge un Libai, avaliyau ge Yudiya gegewel bolo Yabowaine ateliya i pawaiwai, hi lovivina nihi na Yehoba wana Limi Bwabwalena nihi tal pasikal Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Bolo hi minaa labeliyaa gegewel labe hi ginol, bugul ona hi ginolem silba ge gold elal, bugubugul ona ge bwasumu hi pek elal. Ge gogomwau hi gewi, ginebi wali mulolu enuna al hi pek. ");
INSERT INTO mpx_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","I ola al, Sailusa Pesiya wali kin i ba Yehoba wana Limi Bwabwalena bugubugulina bolo valila kin Nebukanesa i aheliem Yelusalema ge i na i teleliya wana yabowaineyau wali limi bwabwalena elana, nihi bugul tagilagil. ");
INSERT INTO mpx_vpl VALUES ("ER1_8","016_1_8","EZR","1","8","8","I ba Mitledat, iya wana gogomwau ali tomatahikan, i bugul tagilagil yaka i vasilel ge i pwahinil Sesbasal manininaa, iya Yudiya wali tobwabwatana. ");
INSERT INTO mpx_vpl VALUES ("ER1_9","016_1_9","EZR","1","9","9","He bugubugul o heliya huwe: mwaha hi ginolem gold elana ali gewi teti (30), mwaha hi ginolem silba elana ali gewi tausan maisena (1,000), bugul bwalena waiwaisana ana etonton dis hi ginolem silba elana ali gewi tuwenti naen (29), ");
INSERT INTO mpx_vpl VALUES ("ER1_10","016_1_10","EZR","1","10","10","bol dis hi ginolem gold elana ali gewi teti (30), bol dis hi ginolem silba elana ali gewi po handeled ten (410), ge bugubugul enuna al ali gewi tausan maisena (1,000). ");
INSERT INTO mpx_vpl VALUES ("ER1_11","016_1_11","EZR","1","11","11","He bugubugul bolo hi ginolem gold ge silba elal ali gewi bwalibwaligena paib tausan po handeled (5,400). Inoke sauga Sesbasal alonau ge Yudiya bolo hi mibwabwali hi egona Babiloni hi nok Yelusalema, bugubugul o hi kalivail hi nok. ");
INSERT INTO mpx_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Hi minamina yaka abwe baliman ana weikena seben-ina hi mipwawa. He boda Isileli iyaka hi minaana wali mumuga panuwana ona elal, inoke gegewel hi na hi boda pamaisena Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","Inoke Yosadak natuna Yesuwa ge wana pan topowon avaliyau Seyaltiyel natuna Selababel ge wana pan tohouwa, Isileli wali Yabowaine ana powon ana abatonton hi tal pasikal, inoke bosowaina bwasumu nihi powon pwabwaligel pwatanaa, ni ola Mosese, Yabowaine wana palopita wana Logugui ana leleli. ");
INSERT INTO mpx_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Bwagana hi lovakun gamagalau bolo hi miminaa labeliyaa elal, yaa abapowon hi tala ana wauwau houhouwena elana. Inoke mweluluga ge kokoyavi gegewena bwasumu hi powon pwabwaligel Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("ER3_4","016_3_4","EZR","3","4","4","Yaka Epanapana Hagalena hi ginol i ola Mosese wana Logugui ana leleli, inoke lan maisena maisena bwasumu hi powon pwabwaligel, ali gewi i ola ana logugui lan o kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER3_5","016_3_5","EZR","3","5","5","Toto o enaa, bwasumu hi powonan pwabwaligel lan maisena maisena ana powon, Weikena I Lovin ali powon, ge hagali bolo Yehoba i ba nihi ginol ali powon. I ola al, gamagalau wali atitalam elana powon hi ginol wali mulolu Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("ER3_6","016_3_6","EZR","3","6","6","He weikena seben-ina ana lan houwan elana te hi telipuna bwasumu hi powonan pwabwaligel Yehoba elana. Yaa nigeya ga Yehoba wana Limi Bwabwalena ana wauwau pat hi vavatalil. ");
INSERT INTO mpx_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Yaka Yudiya mani hi pek bolo wali atena i gan pat nihi gotalil ge limi ana totaltal elal, yaka limi ana ginol ona hi ginolil. I ola al, witi, oine, ge olibe enonona hi pek panuwa Taya ge Saidoni elal inoke ebwakil sida nihi ahem wali labiya Lebanoni, ge nihi pagayu hogaa ni na panuwa Yopa, kaiwena Pesiya wali kin Sailusa iyaka gasisi i pek elal nihi ginol ola to. ");
INSERT INTO mpx_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Yudiya hi sikalim Yelusalema Yabowaine wana Limi Bwabwalena elana enek, yaka baliman eluwana ana weikena labuina elana hi telipuna taltal. Seyaltiyel natuna Selababel alona ge Yosadak natuna Yesuwa, avaliyau wali pan totuwalali, topowon, ge un Libai, i ola al avaliyau gamagalau gegewel bolo hi sikalem Babiloni, hi tuwalali toyawa taltal o eliyana. Inoke Selababel ge Yesuwa gasisi hi pek un Libai bolauiliyau bolo wali baliman tuwenti (20) ge pwatanaa elal heliya Yehoba wana Limi ana taltal nihi houwan. ");
INSERT INTO mpx_vpl VALUES ("ER3_9","016_3_9","EZR","3","9","9","Yesuwa alonau natunau ge talinau avaliyau ge Kadmiyel alonau natunau (heliya Hodavaiya tubutubunau) hi tubwi pamaisena yaka Yabowaine wana Limi ana totaltal hi houwaagil. He tini Henadad, heliya al un Libai, hi pelabalaba tuwalali ya elana. ");
INSERT INTO mpx_vpl VALUES ("ER3_10","016_3_10","EZR","3","10","10","Sauga totaltal Yehoba wana Limi Bwabwalena ana wauwau pat hi vatalil haba, inoke topowon ali holahola yayapona hi galoi ge bwagigi hi ahe, avaliyau ge un Libai bolo topowon Asap tubutubunau egalagalavenu simbol hi ahe, inoke hi talmilil abaliyaa ge Yehoba nihi tobalan, i ola Deibid iya Isileli wali kin wana baaba. ");
INSERT INTO mpx_vpl VALUES ("ER3_11","016_3_11","EZR","3","11","11","Inoke hi tobal ge hi ba mulolu Yehoba elana yaka wona ya hi wonaan hi ba: Iya i waisi!   Wana nunuwana Isileli kaiwela i mihot. Yaka gamagalau gegewel hi yoga analiya i bwata wali tobal Yehoba elana, kaiwena wana Limi ana wauwau pat iyaka hi vatalil haba. ");
INSERT INTO mpx_vpl VALUES ("ER3_12","016_3_12","EZR","3","12","12","Yaa topowon, un Libai ge tini ona wali tohouwa bolo hi liki, hi gewi Limi Bwabwalena toto houwan valila hi kite ga. Sauga hi kite Limi ya ana wauwau vavaluna pat iyaka hi vatal haba, inoke hi kahin analiya i bwata, yaa gamagalau gegewel al wali yaliyaya kaiwena hi yogayoga. ");
INSERT INTO mpx_vpl VALUES ("ER3_13","016_3_13","EZR","3","13","13","He hi yogayoga analiya i bwata bosowaina gamagalau nihi hagoek laha, inoke bolo hi hago nige bosowailiya yaliyaya ana yogayoga ge nuwanak ana kahikahin ali getoga nihi atena. ");
INSERT INTO mpx_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","1","Un Yuda ge Beniyamina ali topihigelgel wasa hi hago te Yudiya bolo valila hi mibwabwali labi Babiloniya heliya iyoho Limi Bwabwalena etega hi taltal Yehoba Isileli wali Yabowaine kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER4_2","016_4_2","EZR","4","2","2","Yaka hi nem Selababel ge tini ona wali tohouwa elal hi ba, “Naha labemiu alomeyau komiu ta taltal, kaiwena ama al ge ha kukululu wami Yabowaine elana i ola te komiu. Powon ha awaawaginol elana, i telipunaa sauga toto Asiliya wali kin Esalhadon i ahema ha nem labi ya elana, ana siga sauga ya.” ");
INSERT INTO mpx_vpl VALUES ("ER4_3","016_4_3","EZR","4","3","3","Yaa analiya Selababel, Yesuwa ge Isileli ali tini ona wali tohouwa hi lahe hi ba, “Nige bosowaina alomeyau komiu Yehoba wana Limi Bwabwalena ta tal. Ama totoma abwe naha tal Yehoba Isileli wama Yabowaine kaiwena, ni ola Pesiya wali kin Sailusa wana logugui i baunan eliyama.” ");
INSERT INTO mpx_vpl VALUES ("ER4_4","016_4_4","EZR","4","4","4","Inoke gamagalau bolo hi miminaa labeliyaa Yudiya yayaluwaliya hi pwapweyata ge hi palovakun-agil yaka hi bakuhu taltal. ");
INSERT INTO mpx_vpl VALUES ("ER4_5","016_4_5","EZR","4","5","5","I ola al, mani elana labi o ana tologugui nuwaliya hi gove yaka hi pihigelgel Yudiya elal ge wali tuwalali hi papulowan. Wali ginol i olaola ya to kin Sailusa wana logugui ana sauga bwalibwaligena elana, ge i na ana siga Pesiya wali kin Dalaiyas wana sauga logugui gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("ER4_6","016_4_6","EZR","4","6","6","He baliman hi gewi i mowasi, kin Seksis wana sauga logugui ana abatelipuna elana, Yuda ge Yelusalema ali woliwoli ana leta etega ali topihigelgel hi leli yaka hi patuna kin elana. ");
INSERT INTO mpx_vpl VALUES ("ER4_7","016_4_7","EZR","4","7","7","Baliman hi gewi al ga i mowasi, kin Ataseksis wana sauga logugui gamwanaa, yaka Bislam, Mitledat ge Tabil aloliyau wali pan totuwalali leta etega hi patuna i na kin Ataseksis elana. He leta o pana Alameik elana hi leli ge abwe ana baaba hi pasikal kin kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER4_8","016_4_8","EZR","4","8","8","Tologugui Lehum ge toleleli Simsai te leta o hi leli Yelusalema ana tomina wasaliya ge hi patuna kin Ataseksis elana. He ana baaba i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("ER4_9","016_4_9","EZR","4","9","9","Atema owa kin. He ama, tologugui Lehum ge toleleli Simsai, alomeyau toyatala ge wama pan totuwalali ona, ge alomeyau al Pesiya, panuwa Elek, Babiloni ge Susa, labi Elam gamagaliliyau, ");
INSERT INTO mpx_vpl VALUES ("ER4_10","016_4_10","EZR","4","10","10","ge boda gegewel al bolo valila Asiliya wali kin alana bwabwatana Asulbanipal i ahemeya wama panuwa ona elal, i telema panuwa Sameliya ge panuwa ona al elal wewel Yupeleitis labena leupai. ");
INSERT INTO mpx_vpl VALUES ("ER4_11","016_4_11","EZR","4","11","11","Leta ya i nowa kin Ataseksis elam, i neem ama wam totuwalali bolo ha minaana wewel Yupeleitis labena leupai. ");
INSERT INTO mpx_vpl VALUES ("ER4_12","016_4_12","EZR","4","12","12","Nuwama owa kin nu atena te Yudiya bolo hi egonana ei ge hi nem eliyama, iyaka hi na wali panuwa Yelusalema hi tatal pasikal, panuwa o wasana i bwata heliya toawatautau ge toginol naknak. Heliya iyoho gana ana wauwau hi abububun ge ana hawawal ona hi kakaukaus. ");
INSERT INTO mpx_vpl VALUES ("ER4_13","016_4_13","EZR","4","13","13","I ola al, nu atena te ebo panuwa ya nihi tal pasikal ge ana gana nihi pahe haba, nasi nige takis tomaha ona nihi pwapwamola eliyam, yaka wam mani nige ni bwabwata nu pwapwawa. ");
INSERT INTO mpx_vpl VALUES ("ER4_14","016_4_14","EZR","4","14","14","Ama ha bateli naha totuwalali elam ge wama bateli o ha nuwahikan, nige nuwama i oola heliya owa kin nihi papuluwawi-agiwa ni ola to. Heiya te kaiwena leta ya ha leli ge wam wasa ha pewa ei. ");
INSERT INTO mpx_vpl VALUES ("ER4_15","016_4_15","EZR","4","15","15","Ha nuwatu te nu ba wam totuwalali nihi loya labi ei ana kin houhouwel wali tuwalali wasana ana buki ona gamwaliyaa. Nasi nu pwawa te panuwa ya heliya toawatautau ge pulowan hi gewi hi ginolil kin ge gavana ona elal, i telipunaa tubuliyau houhouwel wali sausaugaa i nem ana siga sauga ya. Heiya te kaiwena wali panuwa, Babiloni hi apapanak-an. ");
INSERT INTO mpx_vpl VALUES ("ER4_16","016_4_16","EZR","4","16","16","Wam wasa naha pewa te ebo panuwa ya nihi tal pasikal ge ana gana nihi pahe haba, nasi nige al wewel Yupeleitis labena leupai nu lologugui-an. ");
INSERT INTO mpx_vpl VALUES ("ER4_17","016_4_17","EZR","4","17","17","Inoke wali leta lahena kin Ataseksis i patuna i ola hiwe: Leta ya i nowa tologugui Lehum ge toleleli Simsai eliyamiu, alomiyau ge wami pan totuwalali ona bolo ku minaana Sameliya ge panuwa ona elal wewel Yupeleitis labena leupai. Ya mulolu eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("ER4_18","016_4_18","EZR","4","18","18","Leta toto ku patunam iyaka hi vasili ge ana baaba hi pasikal ya hago. ");
INSERT INTO mpx_vpl VALUES ("ER4_19","016_4_19","EZR","4","19","19","Ya ba yaka no totuwalali hi loya, ge hi pwawa te panuwa ya wali awatautau liwanina i yapu kin ona elal. Tunahot heliya toteli gegetoga ge toginol naknak. ");
INSERT INTO mpx_vpl VALUES ("ER4_20","016_4_20","EZR","4","20","20","Valila kin gasigasisel hi tologugui Yelusalema, yaka wewel Yupeleitis labena leupai hi logugui-agil ge hi ba takis tomaha ona hi pwapwamola elal. ");
INSERT INTO mpx_vpl VALUES ("ER4_21","016_4_21","EZR","4","21","21","He nuku ba bolau ei tuwalali nihi paveyaho, yaka panuwa ei bahi nihi tatal pasikal ana siga ebo na baya. ");
INSERT INTO mpx_vpl VALUES ("ER4_22","016_4_22","EZR","4","22","22","Nuku matahikan bahi nuwatu ya nuku kikita luwai, eba nak ya ni bwata yaka nau kin no tuwalali ni papulowan. ");
INSERT INTO mpx_vpl VALUES ("ER4_23","016_4_23","EZR","4","23","23","Sauga kin Ataseksis wana leta hi vasili Lehum ge toleleli Simsai aloliyau ge wali pan totuwalali ona elal, yaka etimwawa hi na Yelusalema ge alona wali gasisi Yudiya hi paveyahoil bahi panuwa ana gana nihi papahe al. ");
INSERT INTO mpx_vpl VALUES ("ER4_24","016_4_24","EZR","4","24","24","He iyaka hi bakuhu Yabowaine wana Limi Bwabwalena ana taltal Yelusalema elana, ge i miola o ana siga Dalaiyas, Pesiya wali kin wana sauga logugui ana baliman labuina elana. ");
INSERT INTO mpx_vpl VALUES ("ER5_1","016_5_1","EZR","5","1","1","Saugena o palopita Hagai ge palopita Sakalaiya, iya Ido tubuna, heliya hi palopisai Yudiya bolo hi minaana Yuda ge Yelusalema elal. He hi palopisai te Isileli wali Yabowaine toto Yudiya i logugui-agil alanaa. ");
INSERT INTO mpx_vpl VALUES ("ER5_2","016_5_2","EZR","5","2","2","Inoke Yudiya wali tohouwa Selababel, iya Seyaltiyel natuna ge topowon bwabwatana Yesuwa, iya Yosadak natuna, hi telipuna Yabowaine wana Limi hi taltal al Yelusalema. He Yabowaine wana palopitau labui iyoho avaliyau ge hi lalabel. ");
INSERT INTO mpx_vpl VALUES ("ER5_3","016_5_3","EZR","5","3","3","Saugena o Tatenai wewel Yupeleitis labena leupai ana gavana ge Setal-Bosenai, aloliyau wali pan totuwalali ona hi na elal yaka hi nelil hi ba, “Henala gasisi i pewa tage Limi Bwabwalena ya nuku tal pasikal ge nuku pwamowasi?” ");
INSERT INTO mpx_vpl VALUES ("ER5_4","016_5_4","EZR","5","4","4","Ge hi nelil al hi ba, “Bolau bolo limi ya hi taltal alaliyaek?” ");
INSERT INTO mpx_vpl VALUES ("ER5_5","016_5_5","EZR","5","5","5","Yaa Yabowaine Yudiya wali tohouwa i matahikagil, yaka tologugui o nige hi papabakuhol taltal, ana siga leta nihi patuna ga kin Dalaiyas elana ge lahena ni sikal elal. ");
INSERT INTO mpx_vpl VALUES ("ER5_6","016_5_6","EZR","5","6","6","Yaka gavana Tatenai ge Setal-Bosenai avaliyau ge totuwalali enuna al wewel Yupeleitis labena leupai, leta etega hi leli ge hi patuna kin Dalaiyas elana. ");
INSERT INTO mpx_vpl VALUES ("ER5_7","016_5_7","EZR","5","7","7","Leta o ana baaba i ola hiwe: Leta ya i nowa kin Dalaiyas elam. Ha mulolu nabi eliyam. ");
INSERT INTO mpx_vpl VALUES ("ER5_8","016_5_8","EZR","5","8","8","Nuwama owa kin nu atena te ha na labi Yudiya Yabowaine alana bwabwatana wana Limi Bwabwalena elana. Inoke ha kite gamagalau pat bwabwatal hi pahipahi limi o ana baba, ge timba hi teli pat ali vatal ali luwaluwala. He alona ateliya bwalibwaligena hi tuwalali gagasisi, ge tuwalali i nawanawa ya. ");
INSERT INTO mpx_vpl VALUES ("ER5_9","016_5_9","EZR","5","9","9","Yaka wali tonowakau ha nelil ha ba, “Henala gasisi i pewa tage Limi Bwabwalena ya nuku tal pasikal ge nuku pwamowasi?” ");
INSERT INTO mpx_vpl VALUES ("ER5_10","016_5_10","EZR","5","10","10","I ola al, alaliya ha neli inoke bosowaina wali tohouwa alaliya naha leli lowagil wam atena kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER5_11","016_5_11","EZR","5","11","11","Yaka anama hi lahe hi ba ola hiwe: “Ama labulabum ge panayawi ana Yabowaine wana totuwalali, ge wana Limi Bwabwalena ya ha tatal pasikal. Valila sauga hohouwena Isileli wama kin alana bwabwatana i tal ge i pwamowasi. ");
INSERT INTO mpx_vpl VALUES ("ER5_12","016_5_12","EZR","5","12","12","Yaa tubumeyau labulabum ana Yabowaine hi pahuga, inoke i telel Babiloni wali kin Nebukanesa nimanaa, iya labi Koldiya gamagalina. Yaka Limi Bwabwalena ya i apapanak-an ge gamagalau i ahel egonagil i telel labi Babiloniya. ");
INSERT INTO mpx_vpl VALUES ("ER5_13","016_5_13","EZR","5","13","13","“Inoke abwe Babiloni wali kin Sailusa wana logugui ana baliman houwan gamwanaa, logugui etega i ginol te Yabowaine wana Limi ya naha tal pasikal Yelusalema elana. ");
INSERT INTO mpx_vpl VALUES ("ER5_14","016_5_14","EZR","5","14","14","I ola al, Yabowaine wana Limi bugubugulina hi ginolem gold ge silba elal, bolo valila Nebukanesa i aheliem Limi Bwabwalena Yelusalema ge i na i teleliya wana limi bwabwalena Babiloni, kin Sailusa i ba hi bugul tagilagil. Yaka i pek tau etega alana Sesbasal elana, toto valila i hile labi Yudiya ana gavana. ");
INSERT INTO mpx_vpl VALUES ("ER5_15","016_5_15","EZR","5","15","15","Inoke i baek elana i ba, ‘Bugubugul bolo ya nuku kalivail nuku nok ge nuku telel Limi Bwabwalena Yelusalema. Yabowaine wana Limi o nu tal pasikal ana mwalu houhouwena elana.’ ");
INSERT INTO mpx_vpl VALUES ("ER5_16","016_5_16","EZR","5","16","16","Yaka Sesbasal toto o i nem Yelusalema, inoke Yabowaine wana Limi ana wauwau pat i vatalil. He lan toto o ge i nem ana siga sauga e, taltal iyaka i gan, yaa nigeya ga ha pwapwamowasi.” ");
INSERT INTO mpx_vpl VALUES ("ER5_17","016_5_17","EZR","5","17","17","He owa kin, ebo nuwatu ya nu yaliyaya-an, yaka nu ba wam totuwalali nihi loya Babiloni ana kin houhouwel wali tuwalali wasana ana buki ona gamwaliyaa. Inoke nu kite ebo tunahot valila kin Sailusa logugui etega i ginol Yabowaine wana Limi nihi tal pasikal Yelusalema. Yaka wama wasa nu pem ga u lologugui ola nuwatu ya kaiwena. ");
INSERT INTO mpx_vpl VALUES ("ER6_1","016_6_1","EZR","6","1","1","Inoke kin Dalaiyas i ba wana totuwalali hi loya kin houhouwel wali tuwalali wasana ana buki ona gamwaliyaa, bolo hi minaa ali abateli waiwaisal labi Babiloniya gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("ER6_2","016_6_2","EZR","6","2","2","Yaka buki etega hi pwawaa panuwa gasigasisena Ekbatana labi Mediya ge ana leleli i ba ola hiwe: Wasa: ");
INSERT INTO mpx_vpl VALUES ("ER6_3","016_6_3","EZR","6","3","3","Kin Sailusa wana logugui ana baliman houwan gamwanaa, logugui etega i ginol Yabowaine wana Limi Bwabwalena kaiwena Yelusalema elana. Limi Bwabwalena o ana wauwau pat nihi vatalil ge nihi tal, inoke bosowaina powon ona nihi ginola to Yabowaine elana. Ana miha ni ola 27 mita ge ana manamana ni ola 27 mita. ");
INSERT INTO mpx_vpl VALUES ("ER6_4","016_6_4","EZR","6","4","4","Ana baba pat bwabwatal vatal eton yaka abwe timba vatal maisena nihi pahel, ge nihi ginol ni olaola ya to ana siga baba ni mowasi. Taltal o molana ni neem kin wana abalogugui ana mani elana. ");
INSERT INTO mpx_vpl VALUES ("ER6_5","016_6_5","EZR","6","5","5","I ola al, Yabowaine wana Limi bugubugulina hi ginolem gold ge silba elal, bolo valila Nebukanesa i aheliem Limi Bwabwalena Yelusalema ge i na i teleliya Babiloni, nihi pasikalil abaliyaa Yabowaine wana Limi Bwabwalena elana Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER6_6","016_6_6","EZR","6","6","6","Yaka leta toto hi patuna Dalaiyas eliyana, i lahe i ola hiwe: Komiu Tatenai wewel Yupeleitis labena leupai ana gavana ge Setal-Bosenai, alomiyau labi ei ana totuwalali al, bahi nuku babaa tuktuk Limi Bwabwalena ana totaltal elal. ");
INSERT INTO mpx_vpl VALUES ("ER6_7","016_6_7","EZR","6","7","7","Bahi Yabowaine wana Limi Bwabwalena ana tuwalali nuku kakaus. Yudiya ana gavana ge Yudiya tonowakiliyau nuku talamwagil Yabowaine wana Limi ei nihi tal pasikal ana mwalu houhouwena elana. ");
INSERT INTO mpx_vpl VALUES ("ER6_8","016_6_8","EZR","6","8","8","I ola al, ami logugui ya pepewa te Yudiya wali tonowakau ei nuku label Yabowaine wana Limi ana taltal eliyana. Wali taltal molana bwalibwaligena nuku pwamola, inoke tuwalali bahi ni babakuhu. Mani ni noem no abalogugui ana mani toto i neem wewel Yupeleitis labena leupai gamagaliliyau eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("ER6_9","016_6_9","EZR","6","9","9","Lan maisena ge maisena, bahi ni kakala te hauna gun ebo topowon bolo Yelusalema nihi awanuni, nuku pekpek elal: bulumwakau natuliyau melutauil, sipi melutauil, ge sipi natuliyau melutauil powon pwabwaliga kaiweliya labulabum ana Yabowaine elana, i ola al witi, solti, oine ge olibe enonona. ");
INSERT INTO mpx_vpl VALUES ("ER6_10","016_6_10","EZR","6","10","10","Inoke powon bolo labulabum ana Yabowaine i yaliyaya-an nihi ginol elana, yaka nihi awanun nau kin alowau natuwau bolau ni muloluagima. ");
INSERT INTO mpx_vpl VALUES ("ER6_11","016_6_11","EZR","6","11","11","I ola al, logugui ya giginol te ebo gamagal etega no baaba o ni hewa likaan, wana limi ginolina etega nihi kukuleke ge buhuna nihi tal paimu, yaka iya nihi howaya ge nihi pakuki. Yaka wana gegi o kaiwena wana limi nihi pasamwalekaleka hoti. ");
INSERT INTO mpx_vpl VALUES ("ER6_12","016_6_12","EZR","6","12","12","Ebo kin o boda etega no logugui o ni hewa likaan, o ebo Limi Bwabwalena Yelusalema ni apapanak-an, he ya awanun Yabowaine toto i ba iya alana ni minaa, kin o ni ahek yoho abanaa ge boda o ni teli lowagil nige wali gasisi al ni gagan. Nau Dalaiyas, logugui ya iyaka ya ginol, inoke ginebi atemiu bwalibwaligena nuku henapuan bubun. ");
INSERT INTO mpx_vpl VALUES ("ER6_13","016_6_13","EZR","6","13","13","Inoke Tatenai wewel Yupeleitis labena leupai ana gavana ge Setal-Bosenai, avaliyau wali pan totuwalali ona, logugui toto kin Dalaiyas i patuna elal hi henapuan bubun alona ateliya bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Inoke Yudiya wali tonowakau hi mimi taltal ge tuwalali i nawanawa ya. Palopitau Hagai ge Sakalaiya, iya Ido tubuna, iyoho hi papalopisai Yabowaine wana baaba hi baubaunan, yaka gamagalau ateliya hi ba pamatuwa. Inoke Limi Bwabwalena hi tal haba i ola Isileli wali Yabowaine wana baaba ge Pesiya wali kin ona Sailusa, Dalaiyas ge Ataseksis wali logugui. ");
INSERT INTO mpx_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","He kin Dalaiyas wana logugui ana baliman sikis-ina gamwanaa weikena Adal ana lan etonina elana te Limi Bwabwalena hi tal haba. ");
INSERT INTO mpx_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Yaka Isileli gamagaliliyau—topowon, un Libai ge bolo valila hi mibwabwali labi Babiloniya gegewel al—alona wali yaliyaya Yabowaine wana Limi hi pwabwabwalena. ");
INSERT INTO mpx_vpl VALUES ("ER6_17","016_6_17","EZR","6","17","17","He pwabwabwalena o elana, bulumwakau melutauil ali gewi wan handeled (100), sipi melutauil ali gewi tu handeled (200) ge sipi natuliyau melutauil ali gewi po handeled (400) hi powonagil. I ola al, Isileli gegewel wali gegi powonina goti melutauil ali gewi tuwel (12) hi powonagil Isileli ali un hi paolaolaek. ");
INSERT INTO mpx_vpl VALUES ("ER6_18","016_6_18","EZR","6","18","18","Yaka topowon ge un Libai hi walel ali pwahin ona elal nihi tuwalali Yelusalema Yabowaine wana Limi Bwabwalena elana, ni ola Mosese wana Logugui ana Buki ana leleli. ");
INSERT INTO mpx_vpl VALUES ("ER6_19","016_6_19","EZR","6","19","19","Baliman vavaluna ana weikena houwan ana lan potin-ina elana, Yudiya bolo valila hi mibwabwali Babiloniya Nopalegi Hagalena ana yaliyaya hi ginol. ");
INSERT INTO mpx_vpl VALUES ("ER6_20","016_6_20","EZR","6","20","20","Topowon ge un Libai ali abwabubun paganina iyaka hi ginol ge hi yanayana tapwalolo kaiwena. Inoke un Libai Nopalegi Hagalena bwasumona sipi natuna melutauina hi lol bolo valila hi mibwabwali gegewel kaiweliya, wali pan topowon, ge heliya kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("ER6_21","016_6_21","EZR","6","21","21","Inoke Isileli bolo valila hi sikalem wali mibwabwali elana Nopalegi Hagalena enona hi an, aloliyau ge boda getoga gamagaliliyau bolo hi minaana labi o ge wali pagan bwaibwaikikinil hi towani yaka hi kukululuek Yehoba, Isileli wali Yabowaine elana. ");
INSERT INTO mpx_vpl VALUES ("ER6_22","016_6_22","EZR","6","22","22","Yaka lan seben alona wali yaliyaya Pwalawa toto Nige alona Yis Hi Vivikuhiya Hagalena hi ginol. Yaliyaya ateliya i pakalaopop, kaiwena Yehoba Asiliya wali kin wana nuwatu i pil yaka Isileli i label ge wali Yabowaine wana Limi hi tal. ");
INSERT INTO mpx_vpl VALUES ("ER7_1","016_7_1","EZR","7","1","1","Baliman hi gewi i mowasi enaa, Pesiya wali kin Ataseksis wana sauga logugui gamwanaa, tau etega alana Esila. Ana lihu i ola hiwe: Esila tamana Selaiya, Selaiya tamana Asalaiya, Asalaiya tamana Hilkaiya, ");
INSERT INTO mpx_vpl VALUES ("ER7_2","016_7_2","EZR","7","2","2","Hilkaiya tamana Salum, Salum tamana Seidok, Seidok tamana Ahitub, ");
INSERT INTO mpx_vpl VALUES ("ER7_3","016_7_3","EZR","7","3","3","Ahitub tamana Amalaiya, Amalaiya tamana Asalaiya, Asalaiya tamana Melaiyot, ");
INSERT INTO mpx_vpl VALUES ("ER7_4","016_7_4","EZR","7","4","4","Melaiyot tamana Selahaiya, Selahaiya tamana Usi, Usi tamana Buki, ");
INSERT INTO mpx_vpl VALUES ("ER7_5","016_7_5","EZR","7","5","5","Buki tamana Abisuwa, Abisuwa tamana Pinehas, Pinehas tamana Eliyesa, Eliyesa tamana Eloni, iya topowon bwabwatal wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("ER7_6","016_7_6","EZR","7","6","6","Esila toto ya i egona Babiloni i nok Yelusalema. Iya topankite, ge wana aatena i bwaya Mosese wana Logugui toto valila Yehoba Isileli wali Yabowaine i pek elal. Mulaa abwe i egona Babiloni, bugubugul gegewena bolo i awanunil, kin i pek elana kaiwena Yehoba, iya wana Yabowaine i minaa elana ge i muloluan. ");
INSERT INTO mpx_vpl VALUES ("ER7_7","016_7_7","EZR","7","7","7","Topowon enuna, un Libai enuna, towonawona enuna, nog ana tomatahikan enuna, Limi Bwabwalena ana totuwalali enuna ge Isileli enuna al, avaliya Esila hi nok Yelusalema Ataseksis wana sauga logugui ana baliman seben-ina gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("ER7_8","016_7_8","EZR","7","8","9","He baliman o ana weikena houwan ana lan houwan te Babiloni i eguluwan, ge weikena nimala panunana ana lan houwan elana i vin Yelusalema, kaiwena wana Yabowaine i minaa elana ge i muloluan. ");
INSERT INTO mpx_vpl VALUES ("ER7_10","016_7_10","EZR","7","10","10","I masal i ola o, kaiwena Esila totona i talamwan Yehoba wana Logugui ni vavasili-an, ni henapuan, ge ana logugui ona ni panpankiti-an Isileli elal. ");
INSERT INTO mpx_vpl VALUES ("ER7_11","016_7_11","EZR","7","11","11","He mulaa abwe Esila Babiloni i eguluwan, kin Ataseksis leta etega i leli ge i pek elana, iya topowon ge topankite, wana aatena i bwaya ba pwatanek ge logugui kaiweliya bolo Yehoba i pek Isileli elal. Leta o ana baaba i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("ER7_12","016_7_12","EZR","7","12","12","Nau Ataseksis, kin gegewel wali kin, leta ya ya patuna Esila elam, owa topowon ge labulabum ana Yabowaine wana Logugui ana topankite. Ya mulolu eliyam. ");
INSERT INTO mpx_vpl VALUES ("ER7_13","016_7_13","EZR","7","13","13","Logugui ya giginol te Isileli bolo hi minaa no abalogugui gamwanaa aloliyau topowon ge un Libai, henalau ebo nihi talam yaka alomwau nuku na Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER7_14","016_7_14","EZR","7","14","14","Nau kin, alowau ge o tobahikan ali gewi seben ha papatunawa nu na Yuda ge Yelusalema, yaka nu kite tab wam Yabowaine wana Logugui toto i pewa hi henapuan bubun. ");
INSERT INTO mpx_vpl VALUES ("ER7_15","016_7_15","EZR","7","15","15","Inoke silba ge gold nuku noahel, bolo alowau o tobahikan ha pewa wama mulolu Isileli wami Yabowaine elana, iya wana abamina iyoho Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER7_16","016_7_16","EZR","7","16","16","I ola al, silba ge gold bolo nuku aheliya labi Babiloniya gamagaliliyau elal, ginebi Isileli gamagaliliyau ge topowon wali mulolu wali Yabowaine wana Limi Bwabwalena Yelusalema kaiwena, gegewena nuku noahe. ");
INSERT INTO mpx_vpl VALUES ("ER7_17","016_7_17","EZR","7","17","17","Mani ya bwalibwaligena nuku patuwalali yaka bulumwakau melutauil, sipi melutauil, ge sipi natuliyau melutauil, ginebi powon enowana pwalawa ge oine nuku pwamolal. Yaka nuku powonagil abapowona wami Yabowaine wana Limi Bwabwalena elana Yelusalema. ");
INSERT INTO mpx_vpl VALUES ("ER7_18","016_7_18","EZR","7","18","18","Ebo silba ge gold tupwana ni gan, alomwau wam pan Yudiya nuku patuwalaliek hauna ku nuwatuan i waisi ni ola wami Yabowaine wana nuwatu. ");
INSERT INTO mpx_vpl VALUES ("ER7_19","016_7_19","EZR","7","19","19","Bugubugul bolo ha talamwan wam Yabowaine wana Limi Bwabwalena ana tapwalolo kaiwena, gegewena nu pwatanik ge nu muloluan Yabowaine toto iyoho Yelusalema elana. ");
INSERT INTO mpx_vpl VALUES ("ER7_20","016_7_20","EZR","7","20","20","Ge ebo bugul etega al nu kalaan wam Yabowaine wana Limi Bwabwalena kaiwena, he molana nu aheya no abalogugui ana mani elana. ");
INSERT INTO mpx_vpl VALUES ("ER7_21","016_7_21","EZR","7","21","21","Nau kin Ataseksis, komiu wewel Yupeleitis labena leupai ana mani ana tomatahikan ami logugui ya pepewa i ola hiwe. Hauna ebo Esila, iya topowon ge labulabum ana Yabowaine wana Logugui ana topankite ni awanuni, inoke bwalibwaligena nuku pek. ");
INSERT INTO mpx_vpl VALUES ("ER7_22","016_7_22","EZR","7","22","22","He silba nuku pekpek elana ana siga tili tausan po handeled kiloglem (3,400 kg), witi ana siga sikistin tausan kiloglem (16,000 kg), oine ana siga tu tausan tu handeled lita (2,200 l), ge olibe enonona ana siga tu tausan tu handeled lita (2,200 l), yaa solti nuku pekpek ya bahi ana siga. ");
INSERT INTO mpx_vpl VALUES ("ER7_23","016_7_23","EZR","7","23","23","Hauna gun ebo labulabum ana Yabowaine iyaka i baunan wana Limi Bwabwalena kaiwena, he bwalibwaligena nuku pek. Inoke bahi ni huhuga yaka no abalogugui ge natuwau ni apapanak-agil! ");
INSERT INTO mpx_vpl VALUES ("ER7_24","016_7_24","EZR","7","24","24","I ola al, nuku atena te nige ya tatalam tage takis ona nuku aahe topowon, un Libai, towonawona, Limi Bwabwalena ana nog ana tomatahikan ge ana totuwalali, o enuna al bolo hi tutuwalaliya Yabowaine wana Limiya elal. ");
INSERT INTO mpx_vpl VALUES ("ER7_25","016_7_25","EZR","7","25","25","Ge owa Esila, nuwatu sasapona toto wam Yabowaine i pewa nu patuwalali ge topapakot ge kot ana totuwalali ona nu hilel kot nihi awaawaginol ge labi Yupeleitis labena leupai gamagaliliyau gegewel, bolo wam Yabowaine wana logugui ona hi atena, ali pulowan nihi abubun. I ola al, bolo logugui ona o nige hi aatena, nu panpankiti elal. ");
INSERT INTO mpx_vpl VALUES ("ER7_26","016_7_26","EZR","7","26","26","Henala ebo wam Yabowaine wana Logugui ge nau kin no logugui nige ni hehenapu-an, ana lahi nihi ginol pwabwata, ebo ni aliga, ebo nihi patuna owaowani, ebo wana gogomwau nihi oe, o ebo nihi teli tukan dela. ");
INSERT INTO mpx_vpl VALUES ("ER7_27","016_7_27","EZR","7","27","27","Yaka Esila i ba, “Ya ba mulolu Yehoba elana, iya tubulau wali Yabowaine, kaiwena nuwatu i pek kin elana ge Yehoba wana Limi Yelusalema ni awatauwan ni ola to. ");
INSERT INTO mpx_vpl VALUES ("ER7_28","016_7_28","EZR","7","28","28","Ge ya ba mulolu Yehoba elana, kaiwena i muloluagau yaka kin alonau ana tobahikan ge wana totuwalali gasigasisel hi yaliyaya-agau. Yehoba no Yabowaine i minaa eliyau ge i muloluagau, yaka ateu i matuwa ge Isileli wali tohouwa enuna ya pamigogoil inoke abwe alowau naha sikal Yelusalema.” ");
INSERT INTO mpx_vpl VALUES ("ER8_21","016_8_21","EZR","8","21","21","Inoke wewel Ahava bebenaa ya ba gegewema ama galebu naha palahikan, inoke naha pahanalowagima wama Yabowaine matanaa ge naha awanun elana ni matahikagima, yaka ama ge natumeyau ginebi wama gogomwau wama nawanawa ni waisi. ");
INSERT INTO mpx_vpl VALUES ("ER8_22","016_8_22","EZR","8","22","22","He ya puluwawi te na awanun kin elana tolohaveyan ge bolo hi heya hosi pwataliyaa nihi matahikagima topihigelgel elal kamwasaa, kaiwena iyaka kin wana wasa ha pek ha ba, “Gamagal gegewel bolo mataliya ni noek Yehoba elana, iya ni muloluagil, yaa bolo ana en nihi pek gegewel wana huga bwabwatana nihi pwawa.” ");
INSERT INTO mpx_vpl VALUES ("ER8_23","016_8_23","EZR","8","23","23","Inoke galebu ha palahikan ge ha awaawanun wama Yabowaine elana nuwatu o kaiwena, yaka wama awanun i lahe. ");
INSERT INTO mpx_vpl VALUES ("ER8_31","016_8_31","EZR","8","31","31","Weikena houwan ana lan tuwel-ina te ha egona wewel Ahava naha nok Yelusalema. Wama Yabowaine i minaa eliyama ge i muloluagima, inoke i matahikagima topihigelgel ge toginol naknak eliyalil kamwasaa. ");
INSERT INTO mpx_vpl VALUES ("ER8_32","016_8_32","EZR","8","32","32","Inoke ha vin Yelusalema ge lan eton ha veyahoan. ");
INSERT INTO mpx_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Yehoyakim Yuda wali kin, wana logugui ana baliman etonina gamwanaa, inoke Nebukanesa, Babiloni wali kin, alonau wana tolohaveyan hi na Yelusalema ana abatagil gegewena hi mikaus ge avaliyau hi haveyan. ");
INSERT INTO mpx_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Inoke Babala Yuda wali kin Yehoyakim i teli nimaliyaa, ge Yabowaine wana Limi Bwabwalena bugubugulina enuna hi bugulan. Bugubugul o hi pwatanik wali yabowaineyau wali limi tapwalolowa labi Babiloniya, ge hi teliya wali gogomwau ana abateliya. I ola al gamagal enuna hi yowanil ge hi ahel hi na Babiloni. ");
INSERT INTO mpx_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Yaka kin i ba wana totuwalali wali tohouwa Aspenas Isileli enuna ni hilel bolo hi yowanil gamwaliyaa ge ni pwatanik kin wana limiya. Hilihili ni noek te hevalau bolo kin o ebo wasawasa natuliyau elal. ");
INSERT INTO mpx_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","Bahi tuwaliya etega ni nanak, ali awa ni waisi, nuwaliya ni sapu, nihi vavasili bubun, ge wali aatena ni mweyaha, inoke bosowailiya nihi tuwalali kin wana limiya. Yaka Aspenas pana Babiloni ana leleli ge ana vavasili ni pankitel. ");
INSERT INTO mpx_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Ali logugui kin i teli lan maisena ge maisena aliya ge ali oine ni neem iya wana limi enowana elana. Aspenas ni pavavasilel baliman eton, yaka abwe nihi tabwa kin wana totuwalali. ");
INSERT INTO mpx_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Bolo hi hilel gamwaliyaa enuna te Daniyela, Hananaya, Miseil ge Asalaiya, heliya ali un Yuda. ");
INSERT INTO mpx_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Yaka alaliya vavaluna Aspenas i tun. Daniyela alana i tun Beltesesa, Hananaya alana i tun Setaleki, Miseil alana i tun Mesake ge Asalaiya alana i tun Abedenigo. ");
INSERT INTO mpx_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Yaa Daniyela i nuwatu bahi aanan ge oine toto i neem kin elana ni aan, kaiwena Yehoba wana logugui i ba ebo aanan ololana o nihi an, he nasi ni pabikel. Inoke i awanun tohouwa Aspenas elana ge bahi ni pepek. ");
INSERT INTO mpx_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","He Yabowaine tohouwa Aspenas atena i pameimei, inoke Aspenas nuwana Daniyela ni labe. ");
INSERT INTO mpx_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","Yaa i baek Daniyela elana i ba, “No tonowak kin ya lovakunan. Kaiwena ami logugui iyaka i baunan hauna nuku an ge nuku im. Ebo aanan o nige na pepewa ge tuwamiu ana awa nige ni wawaisi ni oola wami pan hevalau gegewel, nasi kin ni tagapaaligau.” ");
INSERT INTO mpx_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Inoke Daniyela i na tomatahikan elana, toto Aspenas i teli hevalau ali gewi esopali ni matahikagil, ");
INSERT INTO mpx_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","ge i ba, “U labosema lan ali gewi elulutega. Eyowa enona awawana nu pem naha an ge wewel awawana nu pem naha im. ");
INSERT INTO mpx_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Yaka alomeyau ge wama pan hevalau bolo hi anana kin wana limi enowana elana, nu kite hilihili-agima henalau tuwaliya ana awa i waisi. Inoke nu ginol ni ola wam kite pwawa.” ");
INSERT INTO mpx_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Yaka i talam ge i labosel lan ali gewi elulutega. ");
INSERT INTO mpx_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Lan elulutega i mowasi, he heliya tuwaliya ana awa i waisi hot, ge avaliyau bolo hi anana kin wana limi enowana elana, hi gasisi lakel. ");
INSERT INTO mpx_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Yaka tomatahikan aanan amnana waiwaisana ge oine toto i neem kin elana nige al i pepek, yaa aanan toto eyowa enona i pekpek elal. ");
INSERT INTO mpx_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Yabowaine leleli ge vavasili tomaha tomaha ali aatena i talamwan hevalau bolo esopali elal. I ola al i talamwan Daniyela bosowaina kenonou ge pankite tomaha tomaha ali sapu ni atena. ");
INSERT INTO mpx_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Sauga ali pavavasili ana baliman eton i mowasi i ola toto kin Nebukanesa i baunan, inoke totuwalali wali tohouwa Aspenas hevalau gegewel i ahel hi na kin elana. ");
INSERT INTO mpx_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","20","Yaka kin alonau hi liwaliwan ge i pwawa nige etega wana aatena i oola Daniyela, Hananaya, Miseil ge Asalaiya wali aatena. Bwagana hauna kaba nel i nelian elal o hauna pulowan i pamasal elal, i pwawa hevalau ali toto esopali ya wali siba i bwata nabiyan hot, tosiba ge tokukula gegewel wana abalogugui gamwanaa wali siba i lake. Inoke kin i ahel hi tabwa wana totuwalali. ");
INSERT INTO mpx_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","He Daniyela i tuwalali papanet kin ona elal ana siga kin Sailusa, gagama Pesiya, wana logugui ana baliman houwan Babiloni elana. ");
INSERT INTO mpx_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Nebukanesa wana logugui ana baliman labuina gamwanaa inoke i kenonou. Kenonou o i panuwanuwatu-an ge nige i bosowaina ni kenu bubun. ");
INSERT INTO mpx_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Inoke baaba i patuna wana totuwalali sisibal bolo hi atena hauna i mamasal sauga i nenem, aloliyau tokukula ge toolaolal, nihi nem ge ana kenonou nihi pasikal. Sauga hi nem hi talmilil matanaa, ");
INSERT INTO mpx_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","yaka i baek elal i ba, “Kenonou etega ya kenonouan. He i panuwanuwatu-agau, inoke nuwau nuku pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Yaka tosiba kin anana hi lahe hi pana Alameik, hi ba, “Oo kin, yawalim ni mihot! Am kenonou u baunanim inoke naha pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Yaka kin i baek tosiba elal i ba, “No nuwatu hot i ola hiwe. Ebo o kenonou nige nuku babaunanim ge nuku papasikal, nasi na ba nihi gotomwatomwa-agimiu ge wami limi nihi pasamwalekaleka hoti. ");
INSERT INTO mpx_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Yaa ebo o kenonou nuku baunanim ge nuku pasikal, nasi na pwamolamiu ge alamiu na teli heyan. He sauga ya o kenonou nuku baunanim ge nuku pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Yaka anana hi lahe al hi ba, “Oo kin, am kenonou nu baunanim inoke naha pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Inoke i baek elal i ba, “Iyaka ya atenamiu! Nuwamiu sauga nuku payapu, kaiwena no nuwatu iyaka ku atena, i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","Ebo o kenonou nige nuku babaunanim, nasi gegewemiu na lahemiu, ami lahi ni olaolaek. Iyaka gegewemiu ku nuwatu haba tage nuku lokalokakawi eliyau, kaiwena ku nuwatu tage ebo sauga ni yapu yaka abwe no nuwatu na pil. He sauga ya o kenonou ku baunanim, inoke na atena age i bosowaimiu o kenonou nuku pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Yaka tosiba kin anana hi lahe hi ba, “Oo kin, nige etega i gagan panayawi pwatanaa ge bosowaina ni ginol ni ola wam nuwatu. Nige kin etegana sauga etegana i babaa tage wana tosiba o wana tokukula bugul ololana o nihi ginol, bwagana iya i gasisi o ebo alana i bwata. ");
INSERT INTO mpx_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","Bugul toto owa kin u ba naha ginol i pulowan hot. Nige gamagal etega i bosowaina ni pamasal elam, iyai te yabowaineyau, yaa anamusa nige hi miminaa gamagal elala.” ");
INSERT INTO mpx_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Baaba ya kaiwena kin i huga nabi, inoke i ba tosiba gegewel Babiloni gamwanaa nihi lolil. ");
INSERT INTO mpx_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","Yaka logugui i ginol i ola to ge i patuna tagilan, inoke Daniyela ge alonau hi loyaagil ge nihi lolil. ");
INSERT INTO mpx_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Aliyoka, iya kin wana tolohaveyan bolo wana limi ana tomatahikan wali tohouwa, i tagil i nana Babiloni ana tosiba ni tagapaaligal. Sauga i vin Daniyela elana, inoke Daniyela alona wana siba ge wana nuwasapu i baaba elana. ");
INSERT INTO mpx_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","I nel i ba, “Hauna kaiwena kin logugui pupulowanina ya i ginol?” Inoke Aliyoka kin wana logugui puna i baunan elana. ");
INSERT INTO mpx_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Yaka Daniyela i na kin elana i awanun sauga enuna al ni talamwan ge abwe ana kenonou ni pasikal. ");
INSERT INTO mpx_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Inoke Daniyela i sikal wana limiya bugul ya i wasaan wana heliyamwau Hananaya, Miseil ge Asalaiya elal. ");
INSERT INTO mpx_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","Yaka i baek elal nihi awanun Yabowaine labulabumwa elana ni atilomwan-agil, inoke bugul misusumena ya ni pwamwananal eliyalil ge bahi avaliyau ge Babiloni ana tosiba nihi tatagapaaligal. ");
INSERT INTO mpx_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Yaka bulin o Yabowaine bugul misusumena o ana mwananal i pamasal Daniyela ana pankite elana. Inoke Yabowaine labulabumwa i tobalan, ");
INSERT INTO mpx_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","i ba: “Yabowaine iya tosiba ge togasisi hot, ta tobalan sauga gegewena. ");
INSERT INTO mpx_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Iya baliman ge huwalu ali sauga i logugui-an, iya al kin i telel abaliyaa ge i ahek yohil. Iya te siba ge nuwatu sasapona i pem elala. ");
INSERT INTO mpx_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","Bugul misusumena ge limwalimwanina iya i pankitela, bugul toto i minek gogouwa i atena, mwananal i minaa eliyana. ");
INSERT INTO mpx_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Owa tubuwau wali Yabowaine, ya ba mulolu ge ya tobalagiwa. Siba ge gasisi iyaka u pem eliyau, toto ha awanuni eliyam iyaka u pankitema, kin ana kenonou iyaka u pankitema.” ");
INSERT INTO mpx_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Inoke Daniyela i na Aliyoka eliyana, toto kin i ba tage Babiloni ana tosiba ni tagapaaligal, ge i baek elana i ba, “Bahi Babiloni ana tosiba nu tatagapaaligal. U aheyau ta na kin elana ge ana kenonou na pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Yaka sauga o Aliyoka Daniyela i ahe ge alona hi na kin elana ge i ba, “Tau etega ya pwawa Yuda bolo yowayowanil gamwaliyaa, iya bosowaina am kenonou ni pasikal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Yaka kin i nel Daniyela elana, alana al hi ba Beltesesa, i ba, “I bosowaim ya o kenonou nu baunanim ge nu pasikal?” ");
INSERT INTO mpx_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Yaka anana Daniyela i lahe i ba, “Nige tosiba etega, o ebo tokukula ge toolaolal etega bosowaina am kenonou ni baunaniwa. ");
INSERT INTO mpx_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","Yaa Yabowaine etega i gan labulabumwa, iya bosowaina bugul misusumena ni pankitela. Inoke owa kin Nebukanesa i pankitewa hauna abwe ni masal sauga i nenem. He am kenonou ge am pankite toto i masal eliyam sauga owa iyoho u kenukenu wam abakenuwa i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","“Oo kin, sauga u kenukenu, inoke bugul bolo abwe nihi gan hi nem wam nuwatu elana, ge Yabowaine toto bugul misusumena ali topapamasal i pankitewa hauna abwe ni masal. ");
INSERT INTO mpx_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Bugul misusumena ya i pamasal elau, puna nige i oola tage nau no siba gamagal gegewel wali siba i bwata lake. Yaa i pamasal elau, kaiwena nuwana owa kin am kenonou, toto i nem wam nuwatu elana, ana sapu nu atena. ");
INSERT INTO mpx_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","“Oo kin, am kenonou elana gogoginol bwabwatana etega, gamagal kakanununa, u kite i talmilila maninimwa, i namanamal ge ana kite i lolovakun. ");
INSERT INTO mpx_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","Balomana gold enowana hot elana hi ginoliya, babagalina ge nimana silba elana hi ginoliya, tinena ge nagilina kopa elana hi ginoliya, ");
INSERT INTO mpx_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","aibibilana aiyan elana hi ginoliya, ge aena pwatana ge gamwana aiyan ginebi ge ulun hi ginoliya. ");
INSERT INTO mpx_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Sauga owa iyoho u gagayawa, inoke pat bwabwatana hi gotomwa yohem labilabiya, yaa nige gamagal nimaliya elana i oola. Kakanun aena pwatana toto aiyan ginebi ulun hi ginoliya i lol ge i tagamukumuku-an. ");
INSERT INTO mpx_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Sauga o pamaisena, aiyan, ulun, kopa, silba ge gold i tagamukumuku-agil. Mumwina i kekeisisi hot, i ola witi musana sauga witi enona alona ge musana hi asiasi. Mumwina gegewena mana i yu yoho, nige mulina i gagan. Yaa pat toto kakanun i lol i tabwa oya bwabwatana ge panayawi gegewena i pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","“He am kenonou i ola to, inoke sauga ya na pasikal. ");
INSERT INTO mpx_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","Oo kin, owa kin gegewel wali kin. Yabowaine toto labulabumwa i telewa owa tologugui bwabwatana, gasisi ge wasawasa i pewa eliyam. ");
INSERT INTO mpx_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","Gamagalau ge bwasumu, bolo bilibiliya ge bolo hawawala, i telel nimwamwa. Ebo hauna labi ona hi minaana, i telewa nu logugui-agil. He owa to, baloma toto gold elana hi ginoliya. ");
INSERT INTO mpx_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","“Emwa, yaka abwe abalogugui etega al ni milil, yaa nige wana gasisi ni oola wam abalogugui wana gasisi. Toto o enaa, yaka abalogugui etonina wana gasisi ni ola kopa, panayawi bwalibwaligena ni logugui-an. ");
INSERT INTO mpx_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","He mowamowasena abalogugui esopalena wana gasisi ni ola aiyan. He aiyan bosowaina bugul gegewena ni tagagebagebal-an ge ni mukumuku-an. Inoke abalogugui ya, abwe abalogugui bolo houwan ni pasamwalekaleka-agil ni ola aiyan wana ginol. ");
INSERT INTO mpx_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","U kite al aena pwatana ge aena gigina aiyan ginebi ulun hi ginoliya. He ana mwananal heiya abalogugui ya nihi waliwali-an. Yaa nasi kekeisi wana gasisi ni ola aiyan, kaiwena aiyan ginebi ulun hi vikuhu. ");
INSERT INTO mpx_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","Aen gigina, aiyan ginebi ulun hi ginoliya. He i ola al, abalogugui o kekeisi ni gasisi ge kekeisi ni pweyata. ");
INSERT INTO mpx_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","U kite aiyan alona ge ulun hi vikuhu. He ana mwananal heiya gamagalau tomaha ge tomaha nihi gan gamwanaa. Yaa nige nihi boboda pamaisena, i ola nige bosowaina aiyan ginebi ulun ta vikuhu bubun. ");
INSERT INTO mpx_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","“Kin bolo o wali sauga logugui gamwanaa, inoke Yabowaine toto labulabumwa abalogugui etega ni pamilil, toto nige nihi aapapanak-an ge nige boda getoga nihi aahe. Inoke abalogugui gegewel o ni pasamwalekaleka-agil ge ni pwamowasel, yaa iya ni mihot. ");
INSERT INTO mpx_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","He pat toto u kite hi gotomwa yohem labilabiya, yaa nige gamagal nimaliya elana i oola, yaka aiyan, kopa, ulun, silba ge gold i tagagebagebal-agil, ana sapu i ola to. “He Yabowaine Tobwabwatana i pamasal kin elam hauna abwe ni masal sauga i nenem. Am kenonou i tunahot, ge ya pasikal paolaolaek.” ");
INSERT INTO mpx_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Inoke kin Nebukanesa i talpo Daniyela manininaa, ge i ba bwasumu nihi powonan ge bugul bwaleliya waiwaisana nihi ton Daniyela ana awatauwan kaiwena. ");
INSERT INTO mpx_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","Yaka i baek Daniyela elana i ba, “I tunahot wam Yabowaine iya yabowaineyau wali Yabowaine, ge kin wali Babala, iya bugul misusumel ali topapamasal. He iyaka ya atena to, kaiwena bugul misusumena ya iyaka u pwamwananal.” ");
INSERT INTO mpx_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Inoke abatuwalali mihahaina i pek Daniyela elana, ge ana mulolu waiwaisal hi gewi i pek. Yaka i teli labi Babiloni ni logugui-an, ge ana tosiba gegewel ni houwaagil. ");
INSERT INTO mpx_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","I ola al, Daniyela wana nuwatu eliyana yaka kin, Setaleki, Mesake ge Abedenigo i telel labi Babiloni nihi matahikan. He Daniyela iya i miminaa kin ana tolabe elal kin wana awana. ");
INSERT INTO mpx_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Kin Nebukanesa gold i ahe gogoginol etega i ginoliya, ana miha 27 mita ge ana manamana 2.7 mita. Gogoginol o i pamilila Dula abwabwina elana, labi Babiloni gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Inoke gavana, bolo gavana gabulaliyaa ge tologuguiyau, i ola al tobahikan, mani ana tomatahikan, topapakot ge polobins ona ali totuwalali gegewel, i yogaagil nihi nem gogoginol toto i pamilil ana pwabwabwalena kaiwena. ");
INSERT INTO mpx_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Yaka totuwalali alaliya bwabwatal ya gegewel hi migogo gogoginol ana pwabwabwalena kaiwena, ge hi na hi talmilil awonaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","Yaka kin wana tobaaba etega i yoga anana i bwata i ba, “Panuwa gegewena gamagaliliyau, tuwan tomaha tomaha ge anan tomaha tomaha, ami logugui i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Sauga bwagigi, igo, gita, hapi ge egalagalavenu tomaha ona analiya nuku hago, yaka nuku loepwakoku ge nuku kululu gogoginol ya elana, toto kin Nebukanesa i pamilil. ");
INSERT INTO mpx_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Henala ebo nige ni loloepwakoku ge nige ni kukululu, iya nihi alitukan ginaha kalakalasina gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Inoke sauga gamagalau gegewel egalagalavenu ona analiya hi hago, yaka hi loepwakoku ge hi kululu gogoginol o elana, toto kin Nebukanesa gold i ginoliya ge i pamilil. ");
INSERT INTO mpx_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Sauga o Babiloni ana tosiba enuna hi na kin elana ge Yudiya gamagaliliyau hi wasaagil. ");
INSERT INTO mpx_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Hi baek elana hi ba, “Oo kin, yawalim ni mihot! ");
INSERT INTO mpx_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Owa logugui iyaka u ginol tage sauga bwagigi, igo, gita, hapi ge egalagalavenu tomaha ona analiya naha hago, yaka gegewema naha loepwakoku ge naha kululuek gogoginol elana. ");
INSERT INTO mpx_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","Ge u ba henala ebo nige ni loloepwakoku, iya nihi alitukan ginaha kalakalasina gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Yaa Yudiya enuna, bolo u telel labi Babiloni hi matahikan—Setaleki, Mesake ge Abedenigo—heliya nige wam logugui hi hehenapuan. Nige hi tatapwalolo wam yabowaineyau elal, ge nige hi kukululuek gogoginol toto u pamilil elana.” ");
INSERT INTO mpx_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Yaka kin Nebukanesa i huga nabi, ge i ba bolau eton ya hi ahel ge hi pwatanik elana. ");
INSERT INTO mpx_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Inoke i nelil i ba, “Setaleki, Mesake, ge Abedenigo, tunahot nige ku tatapwalolo no yabowaineyau elal, ge nige ku kukululuek gogoginol elana, toto gold ya ginoliya ge ya pamilil? ");
INSERT INTO mpx_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","He ebo bwagigi, igo, gita, hapi ge egalagalavenu tomaha ona analiya nuku hago, yaka nuku loepwakoku ge nuku kululuek gogoginol toto ya ginol elana, he i waisi. Yaa ebo nigeya, yaka na ba nihi alitukagimiu ginaha kalakalasina gamwanaa. He ku nuwatu tage yabowaine etega i gan ge bosowaina ni pwamwalimiu?” ");
INSERT INTO mpx_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Yaka Setaleki, Mesake, ge Abedenigo kin anana hi lahe hi ba, “Oo Nebukanesa, nige naha awabalgig eliyam bugul ya kaiwena. ");
INSERT INTO mpx_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Ebo nu ba nihi alitukagima ginaha kalakalasina gamwanaa, he Yabowaine toto ha kululuek elana, iya bosowaina ni pwamwalima ginaha elana ge owa kin wam logugui elana. ");
INSERT INTO mpx_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Yaa nu atena te, bwagana ebo nige ni pwapwamwalima, he nige naha tatapwaloloek wam yabowaineyau elal, ge nige naha kukululuek gogoginol toto u pamilil elana.” ");
INSERT INTO mpx_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Inoke Nebukanesa i huga nabi ge maninina i lala Setaleki, Mesake ge Abedenigo elal. Yaka i ba wana totuwalali ginaha hi ton pagasisi, waiwaina i gasisi nabi hot. ");
INSERT INTO mpx_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Ge i ba wana tolohaveyan gasigasisel enuna bolau eton o nihi yowanil ge nihi alitukagil ginaha kalakalasina gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Ali kaliko bwalibwaligena, i telipunaa kokowaliyaa ana siga aeliyaa, iyoho tuwaliyaa inoke hi yowanil, yaka hi alitukagil ginaha kalakalasina gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","He kin wana logugui kaiwena ginaha iyaka hi ton pawaiwai nabi hot. Inoke tolohaveyan bolo Setaleki, Mesake ge Abedenigo hi kalivail, ginaha memena i ton paaligal. ");
INSERT INTO mpx_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","Yaa bolau eton o, ginebi ali eyowan, heliya iyaka hi talek ginaha kalakalasina gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Yaka Nebukanesa atena i you, i tatalutan ge i nel ana tobahikan elal i ba, “Bolau eton ya te ta yowanil ge ta alitukagil ginaha gamwanaa, age?” Anana hi lahe hi ba, “Ee, kin. I ola!” ");
INSERT INTO mpx_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Yaka i ba, “Yaa bolau esopali to ya kitel hi nononawanawa ginaha gamwanaa, ali eyowan nige i gagan, ge nige tuwaliya etega i nanak. He esopaleliya ana awa i ola yabowaine etega natuna.” ");
INSERT INTO mpx_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Inoke Nebukanesa i pelinok ginaha ana abatonton awana labenaa, ge i yoga i ba, “Setaleki, Mesake ge Abedenigo, Yabowaine Tomihahaina Hot wana totuwalali, ku tagilim!” Inoke hi tagilem ginahaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Yaka gavana, bolo gavana gabulaliyaa, tologuguiyau ge kin ana tobahikan ona, hi nogogo bolau hi mipainagil. Hi pwawa nige ginaha mulina i gagan tuwaliyaa, kokowaliya pupunona ge ali kaliko nige i kakalas, ge nige kasu bwalena i gagan tuwaliyaa. ");
INSERT INTO mpx_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Inoke Nebukanesa i ba, “Setaleki, Mesake ge Abedenigo wali Yabowaine ta tobalan. Iya wana anelose i patuna ge wana totuwalali i pwamwalil. Ana mel hi teli, inoke anau nige hi hahago, yaa hi talamwagil nihi yaomal, nige nuwaliya nihi kululuek yabowaine getoga elana, iyai te wali Yabowaine. ");
INSERT INTO mpx_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Inoke logugui ya ginol te, ebo panuwa etega o ebo anan etega gamagaliliyau Setaleki, Mesake ge Abedenigo wali Yabowaine nihi ba panak ge nige nihi aawatauwan, he nihi gotomwatomwa-agil ge wali limi nihi pasamwalekaleka. Kaiwena nige yabowaine etega al i gagan ge bosowaina ni pwamwalila ni ola te.” ");
INSERT INTO mpx_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Inoke kin abamina mihahaina i pek Setaleki, Mesake ge Abedenigo elal labi Babiloni gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","Nau kin Nebukanesa, wasa ya ya patuna panuwa gegewena gamagaliliyau eliyamiu, tuwan tomaha tomaha, ge anan tomaha tomaha, panayawi pwatanaa. Atewau komiu ku gewigewi. ");
INSERT INTO mpx_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Sauga ya nuwau wami wasa na pewa ginol yawiyawi ge pankite kaiweliya, bolo Yabowaine Tomihahaina Hot i ginola elau. ");
INSERT INTO mpx_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Wana pankite abanuwa ahi, wana ginol yawiyawi alona ge wali gasisi. Wana logugui, logugui mihomihotina, wana abalogugui ni gangan ya heyan ge heyan elal. ");
INSERT INTO mpx_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Nau Nebukanesa iyoho no limiya, no minamina i waisi ge ya yaliyaliyaya. ");
INSERT INTO mpx_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Bulin etega ya kenonou ge i palovakunau. He nau iyoho ya kenukenu no abakenuwa, yaka ya lovakun pankite bolo hi masal no nuwatu elana kaiweliya. ");
INSERT INTO mpx_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Inoke ya ba tosiba gegewel bolo hi miminaa Babiloni gamwanaa, nihi nem ge o kenonou nihi pasikal. ");
INSERT INTO mpx_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Sauga totuwalali sisibal bolo hi atena hauna i mamasal sauga i nenem, avaliyau tokukula ge toolaolal hi nem, yaka o kenonou ya baunanik elal, yaa nige bosowailiya nihi pasikal. ");
INSERT INTO mpx_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Yaka Daniyela mulaa abwe i nem ge o kenonou ya baunan eliyana. (He iya alana al Beltesesa, no yabowaine valihina, ge Yabowaine Bwabwalena yayaluwana i minek elana.) ");
INSERT INTO mpx_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","Ya baek elana ya ba, “Beltesesa, tosiba wali tohouwa, ya atena Yabowaine Bwabwalena yayaluwana i minewa eliyam, ge nige bugul misusumena etega i pupulowan hot elam. He o kenonou hiwe. Nuwau nu pasikal. ");
INSERT INTO mpx_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","“Sauga ya kenukenu no abakenuwa, inoke pankite etega i masal eliyau. Abwakil yayapona hot ya kite i talmilila panayawi ana luwaluwala. ");
INSERT INTO mpx_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","Abwakil i siun i bwata ge i gasisi, ana siga i tupa labulabumwa, inoke gamagal gegewel panayawiya bosowailiya nihi kite. ");
INSERT INTO mpx_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","He lamwana ana awa i waisi ge enona i gewi boda bosowailiya. Bwasumu bekikil wali abaveyaho hi pwawaa pwapwaligumwina elana, ge bolo hi youyou hawawala ali vata hi ginola lalana elana. He gamagal ge bwasumu gegewel hi anana elana. ");
INSERT INTO mpx_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","“Nau iyoho ya kenukenu no abakenuwa, inoke o pankite gamwanaa anelose etega ya kite i loem labulabumwa, iya elopapatuna. ");
INSERT INTO mpx_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","I yoga anana i bwata i ba, ‘Abwakil ku gopaguli, lalana ku tagaan, lamwana ku pwalaha yoho ge enona ku yohi pwapwati. Bwasumu bolo hi minaa gabulanaa ge bolo ali vata hi ginola lalana elana, ku takel yohil. ");
INSERT INTO mpx_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","Yaa etutukina ku yowan hikan aiyan ge kopa elana, yaka ni miminaa bilibiliya mwawin gamwaliyaa. “‘Bekubeku tuwana ni pahun, ni minaa mwawina, alonau ge bwasumu. ");
INSERT INTO mpx_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","Wana nuwanuwatu nige ni oola gamagal, yaa ni ola bwasumu wali nuwatu, ana siga baliman seben ni mowasi. ");
INSERT INTO mpx_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","“‘Logugui ya, ama aneloseyau elopapatuna ha wasaan, inoke gamagalau gegewel nihi atena Tomihahaina Hot abalogugui gegewena panayawiya i logugui-an. Iya bosowaina abalogugui ni guyauan gamagal toto i hile elana, bwagana henala alana i kekeisi hot ni teli heyan ni tologugui.’ ");
INSERT INTO mpx_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","“He kenonou toto nau Nebukanesa ya kenonou-an, i ola to. He owa Beltesesa, nuwau nu pasikal na hago, kaiwena tosiba gegewel bolo hi miminaa no abalogugui elana, nige bosowailiya nihi pasikal. Yaa owa bosowaim, kaiwena Yabowaine Bwabwalena yayaluwana i minewa eliyam.” ");
INSERT INTO mpx_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","Sauga no baaba ya pwamowasi, inoke Daniyela, alana al Beltesesa, i nuwanuwatu nabi ge atena i bwanabwana. Yaka nau kin ya ba, “Beltesesa, bahi kenonou ana sapu kaiwena ge nu nuwanuwatu nabi.” Inoke anau i lahe i ba, “No babala, binimala kenonou ana sapu ni noek am topihigelgel elal, yaa bahi ni nonoewa elam. ");
INSERT INTO mpx_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","Abwakil toto u kite i siun i bwata ge i gasisi, ana siga i tupa labulabumwa, inoke gamagal gegewel panayawiya bosowailiya nihi kite. ");
INSERT INTO mpx_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","Lamwana ana awa i waisi ge enona i gewi boda bosowailiya. Bwasumu bekikil wali abaveyaho hi pwawaa pwapwaligumwina elana, ge bolo hi youyou hawawala ali vata hi ginola lalana elana. ");
INSERT INTO mpx_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","Oo kin, abwakil toto o heiya te owa. U miha ge u gasisi. Wam gasisi i bwata hot, i miha ana siga i tupa labulabumwa, ge wam abalogugui i noek panayawi labena gegewena elal. ");
INSERT INTO mpx_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","“Oo kin, am kenonou elana anelose etega u kite i loem labulabumwa, iya elopapatuna, yaka i ba, ‘Abwakil ku gopaguli ge ku apapanak-an, yaa etutukina ku yowan hikan aiyan ge kopa elana ge ku teli ni miminaa mwawin gamwaliyaa, ge ewahilina ni miminaa bilibiliya. Bekubeku tuwana ni pahun, ge iya ni ola bwasumu bekikina, ana siga baliman seben ni mowasi.’ ");
INSERT INTO mpx_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","“Oo kin, kenonou ana pasikal ge am logugui toto Tomihahaina Hot i ginol ni masal no babala eliyam, i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","Owa nihi patuna owaowa-agiwa gamagalau gamwaliyaa, nu nok nu na uleya ge alomwau bwasumu bekikil nuku mina. Mwawin nu anan ni ola bulumwakau ge tuwam bekubeku ni pahunhun. Baliman seben nu ola to, ana siga nu atena Tomihahaina Hot abalogugui gegewena panayawiya i logugui-an, ge iya bosowaina abalogugui ni guyauan gamagal toto i hile elana. ");
INSERT INTO mpx_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","Logugui toto anelose i baunan i ba, ‘Etuktuk ge ewahil ni minaa bilibiliya,’ he ana sapu i ola hiwe. Wam abalogugui abwe nihi pewa pasikal, sauga ebo iyaka nu atena ge nu ba, ‘Yehoba iya panayawi ana tologugui.’ ");
INSERT INTO mpx_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","“Oo kin, nuwau no baaba nu hago. Wam gegi ana en nu pek, inoke pagan waiwaisana nu ginol ge bolo hi palomwanagil nu atilomwan-agil. Binimala nu ola o, inoke tabam wam minamina waiwaisana toto sauga ya nige ni momowasi.” ");
INSERT INTO mpx_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","Yaka bugul gegewena i masal nau kin Nebukanesa elau i ola Daniyela wana baaba. ");
INSERT INTO mpx_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Weikena elulutega eluwa i mowasi, inoke sauga etega ya nononawanawa no limi pwatanaa, Babiloni gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","Yaka ya ba, “Oo nige Babiloni ana bwata! Iyaka ya tal no wasawasa panuwana, inoke no gasisi ge no wasawasa ana bwata gamagalau nihi kite.” ");
INSERT INTO mpx_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","No baaba nige ya pwapwamowasi, inoke anan etega ya hago i loem labulabumwa i ba, “Kin Nebukanesa, am logugui i ola hiwe. Wam logugui ana gasisi iyaka ya ahek yoho elam. ");
INSERT INTO mpx_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","Owa nihi patuna owaowa-agiwa gamagalau gamwaliyaa, nu na uleya ge alomwau bwasumu bekikil nuku mina, inoke nu alaalamwawin ni ola bulumwakau. Baliman seben nu ola to, ana siga nu atena Tomihahaina Hot abalogugui gegewena panayawiya i logugui-an, ge iya bosowaina abalogugui ni guyauan gamagal toto i hile elana.” ");
INSERT INTO mpx_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Sauga o elana, nau kin Nebukanesa o bateli i tabwa tunahot. Hi patuna owaowa-agau gamagalau gamwaliyaa, yaka ya alaalamwawin i ola bulumwakau, ge bekubeku tuwau i pahun. Inoke kokowau pupunona i siun nabi i ola magisubu dagulina, ge nimwau kimbwaina i loyapu i ola bwasumu kimbwaina. ");
INSERT INTO mpx_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","Baliman seben i mowasi, abwe matau ya lihin labulabumwa ge ya awanun, inoke nuwatu waiwaisana i sikal eliyau. Inoke Tomihahaina Hot ya tobalan, ya awatauwan ge ya awa wasawasa-an, iya yawalina i gangan sauga gegewena. Wana logugui, logugui mihomihotina, wana abalogugui ni gangan ya heyan ge heyan elal. ");
INSERT INTO mpx_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","Gamagalau gegewel panayawiya i kitel i ola heliya bugul bwagabwaga. Aneloseyau labulabumwa ge gamagalau panayawiya, hi minaa wana logugui gabulanaa. Nige bosowaina gamagal etega wana nuwatu ni gotomwa, o ebo ni nel ni ba, “I bwe ge u ginol ola?” ");
INSERT INTO mpx_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","Sauga nuwatu waiwaisana i sikal eliyau, inoke gamagalau hi awatauwagau al i ola kin ali awatauwan. O tolabe ge panuwa ana tohouwa hi aheyau, inoke no abamina hi pem pasikal ya tologugui al. Yaka abwe alau i bwata hot, i lake toto valila. ");
INSERT INTO mpx_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","Inoke sauga ya nau Nebukanesa Kin toto labulabumwa alana ya latahin, ya tobalan ge ya awa wasawasa-an, kaiwena bugul gegewena bolo i awaawaginol i sapu ge i olaolaek. He bolo hi hanaha iya bosowaina ni teli lowagil. ");
INSERT INTO mpx_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Kin Belsesa hagali bwabwatana etega i ginol, towasawasa ali gewi tausan maisena kaiweliya, inoke alonau hi anan ge oine hi imwim toyawa. ");
INSERT INTO mpx_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Sauga Belsesa iyoho ana oine i imwim, yaka i ba kom bolo gold ge silba elana hi ginoliya nihi pwatanik elana, toto valila tubuna Nebukanesa i ahem Yelusalema Limi Bwabwalena gamwanaa. He nuwana alonau towasawasa, lagonau hot, ge lagonau al nihi imwimwa. ");
INSERT INTO mpx_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","Yaka kom bolo valila tubuna i ahem Yelusalema Yabowaine wana Limi Bwabwalena gamwanaa hi bugul pwatanik elana, inoke alonau alonau hi imwimwa. ");
INSERT INTO mpx_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Oine hi imwim ee, inoke hi tobatobal yabowaineyau gogoginol elal, bolo gold, silba, kopa, aiyan, abwakil ge pat elana hi ginoliya. ");
INSERT INTO mpx_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Sauga o elana, gamagal nimana gigina i masal inoke i leleli kin wana limi ana baba tuwanaa, labi toto odam i miminaa. Kin niman gigina i gagayawa-an i leleli. ");
INSERT INTO mpx_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","Yaka i lovakun nabi, inoke ana awa i mwaleli, aena i ginu ge tuwana i pweyata. ");
INSERT INTO mpx_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","Inoke wana totuwalali sisibal bolo hi atena hauna i mamasal sauga i nenem, aloliyau tokukula ge toolaolal, i yogaagil ge i baek elal i ba, “Henala ebo leleli ya ni vasili ge ni pwamwananal eliyau, iya towasawasa ali kaliko na pagaloi ge bobot gold hi ginoliya na pin mwamwalinaa. Yaka na teli heyan ni tabwa Babiloniya ana tologugui etonina, nau ge nam gabulameya.” ");
INSERT INTO mpx_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Yaka kin wana tosiba gegewel hi tuk, yaa nige bosowailiya leleli nihi vasili ge nihi pwamwananal elana. ");
INSERT INTO mpx_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","Inoke i lovakun nabi ge ana awa i mwaleli hot. I ola al towasawasa bolo alonau, nuwaliya i gewagewa nabi. ");
INSERT INTO mpx_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","Kin alonau ge towasawasa analiya hinana i hago, inoke i na i tuk hagaliya ge i ba, “Oo kin, yawalim ni mihot! Bahi nu lolovakun ge am awa ni mwamwaleli. ");
INSERT INTO mpx_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","Tau etega i gan wam abalogugui gamwanaa, iya Yabowaine Bwabwalena yayaluwana i minek eliyana. Tubum Nebukanesa wana sauga logugui elana, tau ya hi kite wana siba ge wana aatena i bwata, i ola yabowaineyau wali siba. Inoke tubum tau ya i teli i tabwa tokukula, toolaolal ge tosiba gegewel wali tohouwa. ");
INSERT INTO mpx_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","Tau o iya Daniyela, alana tubum i tun al Beltesesa. He hi pwawa wana nuwatu i sapu, wana aatena ge wana siba i bwata, i ola al bosowaina kenonou ni pasikal, kunkun ni talisian ge pulowan bwabwatal ni ase. He u yogaan, inoke iya leleli ya ni pwamwananal eliyam.” ");
INSERT INTO mpx_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Yaka Daniyela hi en pwatanik kin elana, inoke i neli i ba, “Owa Daniyela, yowayowanil bolo tubu i ahemiuek Yuda avaliya etega? ");
INSERT INTO mpx_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","“Ya hago tage Yabowaine Bwabwalena yayaluwana i minewa eliyam, inoke wam siba ge wam aatena i bwata hot. ");
INSERT INTO mpx_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","He ya ba tosiba ge tokukula hi enil pwatanim eliyau tage leleli ya nihi vasili ge nihi pwamwananal eliyau, yaa nige bosowailiya. ");
INSERT INTO mpx_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Iyaka ya hago owa bosowaim bugul misusumena nu pwamwananal ge pulowan bwabwatal nu ase. He ebo leleli ya nu vasili ge nu pwamwananal eliyau, nasi towasawasa ali kaliko na pagaloiwa ge bobot gold hi ginoliya na pin mwamwalimwa. Yaka na telewa nu tabwa Babiloni ana tologugui etonina, nau ge nam gabulameya.” ");
INSERT INTO mpx_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Inoke Daniyela kin anana i lahe i ba, “Wam mulolu ni minewa eliyam, o ebo nigeya, u pek gamagal getoga elana. Yaa leleli na vasili ge na pwamwananal eliyam. ");
INSERT INTO mpx_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","“Oo kin, Yabowaine Tomihahaina Hot tubum Nebukanesa i teli heyan abalogugui bwabwatana i pek elana ge i pawasawasa. ");
INSERT INTO mpx_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","Alana ana miha kaiwena, panuwa gegewena gamagaliliyau, tuwan tomaha tomaha ge anan tomaha tomaha, hi lovakunan. Ebo nuwana etega ni tagapaaliga, ni tagapaaliga ya. Ebo nuwana etega ni pwamwal, nasi ni pwamwal ya. Ebo nuwana etega ni teli heyan, he ni teli heyan. Ge ebo nuwana etega ni teli lowan, he ni teli lowan. ");
INSERT INTO mpx_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","Yaa wana hanaha ge wana ati elolol kaiwena, inoke Yabowaine i ahek yoho abanaa nige al i totologugui, ge wana wasawasa i ahek yoho. ");
INSERT INTO mpx_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Yaka hi patuna owaowani gamagalau gamwaliyaa, ge wana nuwanuwatu nige i oola gamagal, yaa i ola bwasumu wali nuwatu. Inoke alonau donki bekikil hi mina, ge mwawin i anan i ola bulumwakau. Ge tuwana bekubeku i pahunhun, ana siga i atena age Yabowaine Tomihahaina Hot abalogugui gegewena panayawiya i logugui-an, ge iya bosowaina abalogugui ni guyauan gamagal toto i hile elana. ");
INSERT INTO mpx_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","“Oo Belsesa, bwagana owa Nebukanesa tubuna, nige abapankite u aheya elana ge nu pahanalowagiwa. ");
INSERT INTO mpx_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","Totom u teli heyagiwa ge Babala labulabumwa u awatautau-an, yaka u ba wana Limi Bwabwalena komwina hi bugul pwatanim elam. Inoke alomwau towasawasa, lagomwau hot, ge lagomwau al ku imwimwa. Inoke ku tobatobal yabowaineyau gogoginol elal, bolo silba, gold, kopa, aiyan, abwakil ge pat elana hi ginoliya. Yabowaineyau bolo ya, nige mataliya, nige tanaliya, ge nige bugul etega hi aatena. Yaa Yabowaine toto yawalim ge wam nawanawa gegewena i logugui-an, nige u aawatauwan. ");
INSERT INTO mpx_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","Heiya te kaiwena Yabowaine niman i patuna eliyam, toto u kikite i leleli limi ana baba tuwanaa. ");
INSERT INTO mpx_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","“Leleli ana baaba i ola hiwe: Vasili, vasili, luvi ge wali. ");
INSERT INTO mpx_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","“He baaba ana sapu i ola hiwe: Vasili: Yabowaine wam logugui ana lan ali gewi iyaka i vasili haba ge i pwamowasi. ");
INSERT INTO mpx_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","Luvi: Yabowaine i luvewa sikel elana, inoke am luvi toto iya nuwana nige i pwapwawa, u aimweyaha hot. ");
INSERT INTO mpx_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","Wali: Wam abalogugui iyaka i wali ge i pek Mediya ge Pesiya elal.” ");
INSERT INTO mpx_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Yaka Belsesa i ba wana totuwalali elal towasawasa ali kaliko hi ahe Daniyela hi pagaloi, ge bobot gold hi ginoliya hi pin mwamwalinaa. Inoke kin i wasa i ba, “Daniyela iyaka ya teli heyan i tabwa tologugui etonina Babiloni gamwanaa.” ");
INSERT INTO mpx_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Bulin o, Mediya ge Pesiya hi nem Belsesa, Babiloni wali kin, hi tagapaaliga. ");
INSERT INTO mpx_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Inoke Dalaiyas, gagama Mediya, wana baliman sikisti tu, abana i ahe. ");
INSERT INTO mpx_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Dalaiyas gavana ali gewi 120 i hilel ge i telel wana abalogugui ana labi gegewena nihi matahikan. ");
INSERT INTO mpx_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","Yaka pwataliyaa tologugui bwabwatal eton al i telel, etegana te Daniyela. Heliya gavana wali tuwalali nihi kite hikan, bahi kin wana tuwalali ni nanak. ");
INSERT INTO mpx_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Kin i kite pwawa Daniyela wana tuwalali, tologugui bwabwatal ge gavana gegewel wali tuwalali i waisi lake. Inoke i nuwatu tage Daniyela ni teli heyan abalogugui gegewena ni logugui-an. ");
INSERT INTO mpx_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Toto o kaiwena, yaka tologugui bwabwatal ge gavana Daniyela wana gegi hi loya wana tuwalali gamwanaa, inoke eliyana ana woliwoli nihi ginol. Yaa nige bosowailiya wana gegi etega nihi pwawa, kaiwena bosowaina gamagalau ana mel nihi teli, wana ginol gegewena i sapu ge wana tuwalali i ginol bubun. ");
INSERT INTO mpx_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Yaka abwe bolau ya hi ba, “Nasi nige wana gegi etega ta pwapwawa ge tage ta wole. Yaa ta labose wana puna etega ta pwawa ni neem wana tapwalolo ana logugui elana.” ");
INSERT INTO mpx_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Inoke tologugui bwabwatal ge gavana hi boda pamaisena hi na kin elana ge hi ba, “Oo kin Dalaiyas, yawalim ni mihot! ");
INSERT INTO mpx_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","Ama wam tologugui bwabwatal ge gavana, alomeyau am tobahikan ge tologuguiyau, wama nuwatu ha tal i ola hiwe. Binimala logugui etega nu ginol te lan ana gewi teti gamwanaa, bahi gamagalau nihi awanun yabowaine o gamagal etega elana, iyai te owa kin elam. Inoke logugui o nu pagasisi, yaka henala ebo nige ni hehenapu-an, abwe nihi alipalo laiyoni ali gola. ");
INSERT INTO mpx_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","Oo kin, logugui nu ginol ge nu leli lowan, inoke bahi al ta pipil, ni mihot ni ola Mediya ge Pesiya wala logugui ana kamwasa.” ");
INSERT INTO mpx_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Inoke Dalaiyas logugui i ginol ge i leli lowan i ola to. ");
INSERT INTO mpx_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Sauga Daniyela i atena kin iyaka logugui i leli ge i patunahot, inoke i sikal wana limiya, i ha natiya ge i tuk wana lum gamwanaa. I loepwakokuwa windo toto awona i nonoek Yelusalema elana, inoke i awanun ge i ba mulolu wana Yabowaine elana. He lan maisena ge maisena i awaawanun paeton, i ola sauga gegewena i giginol. ");
INSERT INTO mpx_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Inoke bolau ya ali boda elana hi nok ge Daniyela hi pwawa i awaawanun wana Yabowaine elana labe kaiwena. ");
INSERT INTO mpx_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","Yaka hi na kin elana ge hi ba, “Valila logugui u ginol te lan ana gewi teti gamwanaa, bahi gamagalau nihi awanun yabowaine o gamagal etega elana, iyai te owa kin elam. Ge u ba henala ebo logugui o nige ni hehenapu-an, abwe nihi alipalo laiyoni ali gola. I ola age?” Analiya kin i lahe i ba, “Ibwe. Ge logugui o ni mihot, ni ola Mediya ge Pesiya wala logugui ana kamwasa. He nige bosowaina ta pil.” ");
INSERT INTO mpx_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Inoke hi baek elana hi ba, “Oo kin, Daniyela iya Yuda bolo yowayowanil avaliya etega, nige anam i hahago ge logugui toto u leli lowan nige i hehenapu-an. He lan maisena ge maisena i awaawanun paeton.” ");
INSERT INTO mpx_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Sauga wali baaba o kin i hago, yaka nuwana i nak nabi. Inoke i logasisi hauna kamwasa eliyana ge Daniyela ni pwamwal. I nuwatu loyaloya ana siga sabwelu i lobek. ");
INSERT INTO mpx_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Inoke bolau ali boda elana hi sikal hi na kin elana ge hi ba, “Oo kin, u atena ya, ebo kin logugui etega ni leli lowan ge ni patunahot, he nige bosowaina ta pil, kaiwena Mediya ge Pesiya wala logugui ana kamwasa i ola to.” ");
INSERT INTO mpx_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Yaka kin i ba Daniyela hi en pwatanik, inoke i baek elana i ba, “Ya awanun wam Yabowaine toto u kukululuek elana ni pwamwaliwa.” Yaka abwe hi alipalo laiyoni ali gola, ");
INSERT INTO mpx_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","ge pat etega hi ahe gol awana hi paankaus. Inoke kin wana lopwal ana etotohi, ginebi ge towasawasa ali etotohi, hi telek pat elana, bahi gamagal etega ni tutuk Daniyela ni pwapwamwal. ");
INSERT INTO mpx_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Inoke kin i sikal wana limiya. I nuwanuwatu nabi, yaka bulin o nige i aanan, nige nuwana ana epayaliyaya nihi ginol, ge nige bosowaina ni kenu. ");
INSERT INTO mpx_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","Lan abwe i gangan ya, kin i lut i tapalelu nok laiyoni ali gol elana. ");
INSERT INTO mpx_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Sauga i vin gol labenaa, inoke alona wana atilomwan i yoga Daniyela elana i ba, “Daniyela, Yabowaine yawalina gaganina wana totuwalali! Wam Yabowaine toto u kukululuek elana, tab i pwamwaliwa laiyoni elal?” ");
INSERT INTO mpx_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Anana Daniyela i lahe i ba, “Oo kin, yawalim ni mihot! ");
INSERT INTO mpx_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","No Yabowaine wana anelose i patuna i nem laiyoni awaliya i lokausan, yaka nige hi tatalau. I ginol ola, kaiwena i kiteyau no pagan i sapu matanaa. I ola al, nige gegi etega ya giginol owa kin elam.” ");
INSERT INTO mpx_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Yaka kin i yaliyaya nabi ge i ba Daniyela nihi momol heyan gol elana. Sauga iyaka hi momol heyan, inoke tuwana hi hile nige etega i nanak, kaiwena wana Yabowaine i meltelian. ");
INSERT INTO mpx_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Inoke kin i ba bolau bolo Daniyela hi wole kakawe, hi libil ge hi alilowagil laiyoni ali gola, avaliyau lagoliyau ge natuliyau. Nige ga hi bubuntal paiya te laiyoni hi alahikagil ge tutuwaliya hi alagabogabomwan. ");
INSERT INTO mpx_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Yaka kin Dalaiyas leta i leli i patuna panuwa gegewena gamagaliliyau elal, tuwan tomaha tomaha ge anan tomaha tomaha, wana abalogugui gamwanaa. I ba: Atewau komiu ku gewigewi! ");
INSERT INTO mpx_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Sauga ya, logugui ya ginol te no abalogugui ana labi gegewena elal, gamagalau Daniyela wana Yabowaine nuku lovakunan ge nuku awatauwan. He iya Yabowaine yawalina gaganina, ge iya i mihot. Wana abalogugui nige bosowaina ta apapanak-an, wana logugui nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","Iya tolabe ge topwamwal, abanuwaahi ge ginol yawiyawi i ginolil labulabumwa ge panayawiya. Daniyela i pwamwalem laiyoni eliyalil. ");
INSERT INTO mpx_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","He Dalaiyas wana sauga kin, ge Sailusa, gagama Pesiya, wana sauga kin, Daniyela wana minamina i waisi hot. ");
INSERT INTO mpx_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","Belsesa Babiloni wali kin, wana sauga logugui ana baliman houwan gamwanaa, Daniyela kenonou etega i kenonou-an ge pankite etega i masal eliyana sauga iya iyoho i kenukenu wana abakenuwa. Yaka bugul bolo i kitel ana kenonou elana wasaliya i leli lowan. ");
INSERT INTO mpx_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","I leli ola hiwe: Bulin o, o pankite elana matau ya lipwatanik ge ya kite mana hi towa neem labena gegewena elal ge hoga mamanana hi yu pabagobagol. ");
INSERT INTO mpx_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","Yaka bwasumu bekikil bwabwatal esopali, ali awa tomaha ge tomaha ona hi hopitem hogaa. ");
INSERT INTO mpx_vpl VALUES ("DN7_4","028_7_4","DAN","7","4","4","Toto houwan ana awa i ola laiyoni etega, ge opena i gan i ola magisubu opeliya. Nau iyoho ya ya gagayawa-an yaka opena labui hi kukuyoho, ge hi pamilil i ola gamagal wali milimilil. Yaka gamagal wali nuwatu hi pek elana. ");
INSERT INTO mpx_vpl VALUES ("DN7_5","028_7_5","DAN","7","5","5","Inoke labuina al ya kite i hopit, ana awa i ola bwasumu beya etega. Aena labi maisena i milili, ge lul tutuwana eton i alahikan nininaa. Inoke anan etega ya hago i baek elana i ba, “U lut! U na bunum ni bwata nu anil!” ");
INSERT INTO mpx_vpl VALUES ("DN7_6","028_7_6","DAN","7","6","6","Toto o enaa, matau ya lipwatanik etoniliya al ya kite, ana awa i ola bwasumu lepad etega, ge open esopali hi minaa eputetenaa i ola bwasumu youyou opeliya. Bwasumu bekikina o kaununa esopali, ge gasisi hi pek elana ni tologugui. ");
INSERT INTO mpx_vpl VALUES ("DN7_7","028_7_7","DAN","7","7","7","Toto o enaa, o pankite elana bulin o matau ya lipwatanik esopaleliya al ya kite ana awa i lolovakun hot ge wana gasisi i bwata nabi. Ninina aiyan hi lobwata, ge ana mwa i alamukumuku-agil ge i tinonil, yaka toto i alapasogol i poti lolowan aena gabulanaa. Iya i getoga hot alonau bolo hi hopit houwa elal. He ana hon ali gewi elulutega (10). ");
INSERT INTO mpx_vpl VALUES ("DN7_8","028_7_8","DAN","7","8","8","Nau iyoho ya hon bolo o ya gagayawa-agil, yaka hon kekeisi etega ya kite i heem hon bolo o gamwaliyaa, ge bolo houwan eton i tagayohil. Hon toto o matana i gan i ola gamagal mataliya ge awana i gan ba hanaha i kalaopopwi. ");
INSERT INTO mpx_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","Nau iyoho ya ya gagagayawa, yaka abamisiyo wawasana hi telel abaliyaa, inoke Toto Yawalina Gaganina I Masalem Abatelipuna elana i na i misiyo wana abamisiyo wawasana elana ge yatala ni ginol. Ana kama i wawakeki i ola yaluyalu wakewakekena, ge kokowana ana yanayana i ola apwayowa pupunoliya. Hiwo memena i totagilem wana abamisiyo wawasana elana, ge ana wil hiwo i topainagil. ");
INSERT INTO mpx_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","Hiwo i toyu tagilem elana i ola wewel wana sani. Aneloseyau tausan ge tausan hi totuwalali elana, miliyon ge miliyon hi talmilil manininaa. Yaka yatala ana sauga i telipuna ge buki ona hi lopwelaan. ");
INSERT INTO mpx_vpl VALUES ("DN7_11","028_7_11","DAN","7","11","11","Nau iyoho ya ya gagagayawa, kaiwena ya hago hon toto kekeisi i baaba hanahanaha. No gagayawa o gamwanaa, yaka bwasumu bekikina esopalena hi lopaaliga, inoke tuwana hi alitukanek hiwo memena gamwanaa ge i tomwamwaol. ");
INSERT INTO mpx_vpl VALUES ("DN7_12","028_7_12","DAN","7","12","12","Bolo eton al, he wali gasisi ge nihi tologugui valila hi ahek yoho eliyalil, yaa hi talamwagil nige ga nihi yayaomal nihi mina ga sauga kekeisi. ");
INSERT INTO mpx_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","O pankite elana bulin o matau ya lipwatanik awa etega ya kite i ola gamagal natuna, i nenem yaluyalu pwatanaa. I na i noha Toto Yawalina Gaganina I Masalem Abatelipuna elana, yaka abwe hi en pwatanik manininaa. ");
INSERT INTO mpx_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Inoke wasawasa ge gasisi i pek elana ni tologugui, yaka gamagalau gegewel panuwa tomaha ge tomaha, tuwan tomaha ge tomaha, anan tomaha ge tomaha, hi kululu elana. Wana logugui logugui mihomihotina, ge wana abalogugui nige nihi aapapanak-an. ");
INSERT INTO mpx_vpl VALUES ("DN7_15","028_7_15","DAN","7","15","15","Nau Daniyela, pankite o i masal eliyau, inoke i panuwanuwatu-agau ge ya lovakun nabi. ");
INSERT INTO mpx_vpl VALUES ("DN7_16","028_7_16","DAN","7","16","16","Inoke ya na bolo hi talmilil abamisiyo wawasana labenaa avaliya etega ya neli bugul gegewena bolo ya kitel ali sapu hot kaiwena. Yaka i talisian eliyau i ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("DN7_17","028_7_17","DAN","7","17","17","“Bwasumu bekikil bwabwatal esopali heliya hi ola abalogugui esopali abwe nihi lut panayawiya. ");
INSERT INTO mpx_vpl VALUES ("DN7_18","028_7_18","DAN","7","18","18","Yaa abapwamowasi eliyana, Tomihahaina Hot abalogugui ni pek wana gamagalau bwabwalel elal ge nihi tologugui sauga gegewena nige ni momowasi.” ");
INSERT INTO mpx_vpl VALUES ("DN7_19","028_7_19","DAN","7","19","19","Inoke nuwau bwasumu bekikil esopaleliya ana sapu hot na atena, iya i getoga alonau eton elal, ge ana awa i lolovakun hot. Ninina aiyan ge aena kimbwaina kopa, yaka ana mwa i alamukumuku-agil ge i tinonil, yaka toto i alapasogol i poti lolowan aena gabulanaa. ");
INSERT INTO mpx_vpl VALUES ("DN7_20","028_7_20","DAN","7","20","20","I ola al, nuwau hon elulutega hi minaa kokowanaa ge toto kekeisi mulaa abwe i heem gamwaliyaa ge eton i tagayohil ali sapu na atena. Hon toto o ana awa lolovakunina alonau gegewel ali awa i lakel, matana i gan ge awana ba hanaha i kalaopopwi. ");
INSERT INTO mpx_vpl VALUES ("DN7_21","028_7_21","DAN","7","21","21","He sauga nau iyoho ya ya gagagayawa, yaka haveyan i awaawaginol Yehoba wana gamagalau bwabwalel elal ge i papakokovel, ");
INSERT INTO mpx_vpl VALUES ("DN7_22","028_7_22","DAN","7","22","22","ana siga Toto Yawalina Gaganina I Masalem Abatelipuna elana i nem yatala i ginol, yaka i ba Tomihahaina Hot wana gamagalau bwabwalel heliya te nihi tologugui, kaiwena wali sauga iyaka i vin. ");
INSERT INTO mpx_vpl VALUES ("DN7_23","028_7_23","DAN","7","23","23","Inoke i talisian eliyau ola hiwe. “Bwasumu bekikil esopaleliya iya i ola abalogugui esopalena abwe ni masal panayawiya ge iya ni getoga abalogugui bolo eton eliyalil. Panayawi labena gegewel ni pakokovel, ana topihigelgel ni gulil habal, ni poti lowalowagil ge ni pulimukumuku-agil. ");
INSERT INTO mpx_vpl VALUES ("DN7_24","028_7_24","DAN","7","24","24","He ana hon elulutega, heliya hi ola kin ali gewi elulutega wali sauga tomaha tomaha ona abalogugui o nihi logugui-an. Bolo o nihi mowasi yaka etegana al ni milil, iya ni getoga hot alonau bolo hi tologugui houwa elal, ge eton ni tagalakel. ");
INSERT INTO mpx_vpl VALUES ("DN7_25","028_7_25","DAN","7","25","25","Iya Tomihahaina Hot ni awa nanak-an ge wana gamagalau bwabwalel ni paloloyowan-agil. Wana nuwatu ni tal wali tapwalolo ana logugui ge wali hagali ali sauga ona ni pil getogaan. He Tomihahaina Hot wana gamagalau ni talamwagil nihi minaa kin o wana logugui gabulanaa baliman eton ge awalehina. ");
INSERT INTO mpx_vpl VALUES ("DN7_26","028_7_26","DAN","7","26","26","“Yaa abwe yatala ana sauga ni telipuna, inoke wana gasisi Tomihahaina Hot ni ahek yoho ge ni ba nihi apapanak-an hoti. ");
INSERT INTO mpx_vpl VALUES ("DN7_27","028_7_27","DAN","7","27","27","Inoke Tomihahaina Hot gasisi ni pek wana gamagalau bwabwalel elal nihi tologugui, yaka ginebi wali gasisi ge alaliya bwabwatana abalogugui gegewel panayawiya nihi logugui-agil. Iya wana abalogugui abalogugui mihomihotina, ge tologugui gegewel nihi kululu elana ge nihi henapuan.” ");
INSERT INTO mpx_vpl VALUES ("DN7_28","028_7_28","DAN","7","28","28","He o pankite ana siga to. Nau Daniyela, ya lovakun nabi ge o awa i mwaleli, yaa bugul gegewena o ya teliya ya atewa. ");
INSERT INTO mpx_vpl VALUES ("DN8_1","028_8_1","DAN","8","1","10","Kin Belsesa wana logugui ana baliman etonina elana, Daniyela ana pankite etega i gan. Sipi melutauina etega ana hon labui i kite i patalelu nok labi pai, labi aluwabwa ge labi yalasa ge i pakokovel. Yaka goti etega ana hon bwabwatana maisena etimwawa hot i patalelu i neem pai, inoke sipi melutauina i lol ge iya i tabwa togasisi hot. Abwe ana hon bwabwatana o i mwagabom ge lahena hon esopali hi siun. (puna 1-8)  Enaa, hon etega i siun neem hon esopali o avaliya etegana elana. Hon o i telipuna i kekeisi, yaa wana gasisi i bwatabwata ya i na Panuwa Waiwaisana o ebo ta ba Bateli Panuwana i ahe ge Yehoba wana boda enuna i pulilowalowagil. (puna 9-10)  ");
INSERT INTO mpx_vpl VALUES ("DN8_11","028_8_11","DAN","8","11","11","Yaka totona i teli heyan i awatautau labulabum ana ivan ana Tohouwa elana. Powon bolo lan maisena ge maisena hi popowonan Tohouwa o elana i lopwali, ge wana Limi Bwabwalena ana bwabwalena i apanak. ");
INSERT INTO mpx_vpl VALUES ("DN8_19","028_8_19","DAN","8","19","19","Inoke i ba, “Wam wasa na pewa hauna gun abwe ni gan sauga mulaa Yehoba wana huga ana sauga elana, kaiwena am pankite ana nuwatu i noek sauga mowamowasena elana toto Yehoba iyaka i teli. ");
INSERT INTO mpx_vpl VALUES ("DN8_20","028_8_20","DAN","8","20","20","“Sipi melutauina toto u kite ana hon labui, iya i ola abalogugui toto Mediya ge Pesiya ali abalogugui. ");
INSERT INTO mpx_vpl VALUES ("DN8_21","028_8_21","DAN","8","21","21","Goti i ola Gilis ana abalogugui, ge ana hon bwabwatana i minaa matana labui ali luwaluwala i ola ana kin houwan. ");
INSERT INTO mpx_vpl VALUES ("DN8_22","028_8_22","DAN","8","22","22","Hon o i mwagabom yaka hon esopali hi siun lahe ana sapu Gilis ana abalogugui nihi wali ni tabwa abalogugui esopali, yaa wali gasisi nige ni oola abalogugui toto houwan. ");
INSERT INTO mpx_vpl VALUES ("DN8_23","028_8_23","DAN","8","23","23","“Sauga abalogugui esopali o wali sauga kelaubwa ni mowasi ge gegi paganina iyaka i bwata hot, yaka kin etega ni masal iya tohugahuga ge kakawi ni sibaan. ");
INSERT INTO mpx_vpl VALUES ("DN8_24","028_8_24","DAN","8","24","24","Iya ni tabwa togasisi hot, yaa nige totona wana gasisi elana i oola. Apapanak bwabwatana ni ginol ge hauna nuwana ni ginol bosowaina ni ginol. Tohouwa gasigasisel ge i ola al Yehoba wana gamagalau bwabwalel ni apapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("DN8_25","028_8_25","DAN","8","25","25","Alona wana siba kakawi ni patuwalali, yaka hauna nuwana ni ginol bosowaina ni ginol, ge atena hanaha ni kalaopopwi. Gamagalau nihi gewi nihi ba, ‘Nige ta bwebwe!’ yaka iya ni apapanak-agil. I ola al ni lut ge ni lohaveyan tohouwa wali Tohouwa elana. He abwe nak ni pwawa, yaa nige gamagal etega wana gasisi eliyana i oola.” ");
INSERT INTO mpx_vpl VALUES ("DN9_1","028_9_1","DAN","9","1","1","Dalaiyas Seksis natuna, Mediya gamagalina, i tabwa kin Babiloni ge ana abalogugui elana. ");
INSERT INTO mpx_vpl VALUES ("DN9_2","028_9_2","DAN","9","2","2","Wana sauga logugui ana baliman houwan gamwanaa, nau Daniyela buki bwabwalena ya vavasili. Inoke Yehoba wana baaba toto palopita Yelemaiya i lelelian ya minuwanuwatu-an, toto i ba Yelusalema ni samwalekaleka hawawal ana yapu baliman sebenti (70). ");
INSERT INTO mpx_vpl VALUES ("DN9_3","028_9_3","DAN","9","3","3","Inoke o galebu ya palahikan, kaliko toto bwasumu pupunoliya elana hi ginoliya ya galoi, ge tuwau ya papakove. Yaka ya awaawanun nabinabi Babala Yabowaine elana. ");
INSERT INTO mpx_vpl VALUES ("DN9_4","028_9_4","DAN","9","4","4","Inoke alowau gamagalau wama gegi ya lopapit Yehoba no Yabowaine elana ya ba: “O Babala, owa Yabowaine bwabwatana ge ha kite lovakunagiwa. Wam bateli u nuwahikan ge wam nunuwana u ginol hikahikani bolo hi nunuwana-agiwa ge wam logugui hi henapuan elal. ");
INSERT INTO mpx_vpl VALUES ("DN9_5","028_9_5","DAN","9","5","5","Ama iyaka ha gegi, ge pagan nanakina ha ginol. Ha towaagiwa, yaka wam logugui ge wam panpankiti ali en ha pek. ");
INSERT INTO mpx_vpl VALUES ("DN9_6","028_9_6","DAN","9","6","6","Wam totuwalali palopitau analiya nige ha hahago, bolo valila wam baaba hi wasaan wama kin ona, wama tohouwa, tubumeyau ge wama panuwa gamagaliliyau gegewel elal. ");
INSERT INTO mpx_vpl VALUES ("DN9_7","028_9_7","DAN","9","7","7","“Babala, owa tosapu, yaa ama puluwawi ha kalaopopwi ana siga lan ebe, ama Yelusalema, Yuda ge Isileli gegewema, bolo ha mikelaubwa ge bolo ama bwaga i yapu ha minaa panuwa ona elal, panuwa bolo u patunama ha mibwabwaliya kaiwena ha teli gegetoga nige ha miminaa elam. ");
INSERT INTO mpx_vpl VALUES ("DN9_8","028_9_8","DAN","9","8","8","O Yehoba, ama alomeyau ge wama kin ona, wama tohouwa ge tubumeyau puluwawi ha kalaopopwi kaiwena ha gegi eliyam. ");
INSERT INTO mpx_vpl VALUES ("DN9_9","028_9_9","DAN","9","9","9","Babala wama Yabowaine, owa toatilomwan ge gegi ana tonuwayoho. He ama ha towaagiwa, ");
INSERT INTO mpx_vpl VALUES ("DN9_10","028_9_10","DAN","9","10","10","owa Yehoba wama Yabowaine anam nige ha hahago, ge logugui bolo u pem wam totuwalali palopitau awaliyaa nige ha totoulil. ");
INSERT INTO mpx_vpl VALUES ("DN9_11","028_9_11","DAN","9","11","11","Ama Isileli gegewema wam logugui ha leke ge am en ha pewa nige anam ha hahago. “Wama gegi kaiwena inoke apapanak ge lahi bolo wam totuwalali Mosese wana logugui i baunan iyaka u ginol elama. ");
INSERT INTO mpx_vpl VALUES ("DN9_12","028_9_12","DAN","9","12","12","Valila u ba alomeyau ge wama tologuguiyau nu lahema, inoke wam baaba o iyaka u patunahot ge u ba nak bwabwatana i nem eliyama. He panuwa gegewel panayawi pwatanaa nige etega u aapapanak-an i oola toto u ginola Yelusalema elana. ");
INSERT INTO mpx_vpl VALUES ("DN9_13","028_9_13","DAN","9","13","13","Nak gegewena o i masal eliyama i ola toto Mosese wana logugui i baunan. Yaa bwagana o, nige wama gegi ana en ha pepek ge wam baaba tutunahotina ha totoulil, inoke owa Yehoba wama Yabowaine atem ni laumwal ge nu yaliyaya kaiwema. ");
INSERT INTO mpx_vpl VALUES ("DN9_14","028_9_14","DAN","9","14","14","Yehoba wama Yabowaine, wam ginol gegewena i sapu, ge ama nige anam ha hahago, inoke nak toto u lovivina-an, he iyaka u ginol eliyama i ola to. ");
INSERT INTO mpx_vpl VALUES ("DN9_15","028_9_15","DAN","9","15","15","“O Babala wama Yabowaine, nimwam gasigasisena elana wam gamagalau u ahe tagilagima Itipita elana, ge alam u pawasawasa ana siga lan ebe. Yaa ama ha gegi, ge pagan nanakina ha ginol. ");
INSERT INTO mpx_vpl VALUES ("DN9_16","028_9_16","DAN","9","16","16","O Babala, owa pagan sasapona ana toginol, wam huga u ahek yoho wam panuwa Yelusalema elana, iya wam oya bwabwalena. He alomeyau ge tubumeyau wama gegi kaiwena, inoke boda gegewel bolo hi minaa gegelimeya Yelusalema ge ama wam gamagalau hi kite lowagima. ");
INSERT INTO mpx_vpl VALUES ("DN9_17","028_9_17","DAN","9","17","17","“O wama Yabowaine, nau wam totuwalali no awanun nu hago. O Babala, alam kaiwena wam Limi Bwabwalena toto valila hi apapanak-an u pavavaluna. ");
INSERT INTO mpx_vpl VALUES ("DN9_18","028_9_18","DAN","9","18","18","O Yabowaine, tanam ni nem elama ge wama awanun nu laeganan. Matam ni nem elama ge alam panuwana nakina nu kite. Ha awanun elam nige tage ama tosasapol, yaa kaiwena atilomwan u kalaopopwi. ");
INSERT INTO mpx_vpl VALUES ("DN9_19","028_9_19","DAN","9","19","19","O Babala, wama awanun nu hago. O Babala, wama gegi nu nuwayoho. O Babala, wama awanun nu laeganan ge nu ginol ola. O no Yabowaine, alam kaiwena bahi wama awanun lahena ni eesowal, kaiwena Yelusalema alam panuwana ge ama wam gamagalau.” ");
INSERT INTO mpx_vpl VALUES ("DN9_20","028_9_20","DAN","9","20","20","Nau iyoho no gegi ge no pan Isileli wali gegi ya lolopapit Yehoba no Yabowaine elana, ge ya awaawanun wana Limi Bwabwalena kaiwena. ");
INSERT INTO mpx_vpl VALUES ("DN9_21","028_9_21","DAN","9","21","21","Sauga nau iyoho no awanun gamwanaa, inoke anelose Gabeliyel, iya valila ya kite o pankite etegana elana, i you vin elau powon ana sauga kokoyaviya. ");
INSERT INTO mpx_vpl VALUES ("DN9_22","028_9_22","DAN","9","22","22","Inoke i ba pwamwananal eliyau i ba, “Daniyela, ya nem ge Yelemaiya wana palopisai gamwana ana sapu na talisian nu hago. ");
INSERT INTO mpx_vpl VALUES ("DN9_23","028_9_23","DAN","9","23","23","Sauga wam awanun u telipuna, Yehoba wam awanun lahena i baunan, yaka nau ya nem ge na wasaan elam, kaiwena i nunuwana-agiwa nabiyan. He nu laegan wam awanun lahena nu hago, ge hauna Yehoba nuwana ni pankitewa ana sapu nu atena. ");
INSERT INTO mpx_vpl VALUES ("DN9_24","028_9_24","DAN","9","24","24","“Yehoba logugui iyaka i ginol haba baliman seben nihi gan pasebenti wam gamagalau ge wam panuwa bwabwalena Yelusalema kaiweliya. Yaka baliman bolo o eliyalil, gamagalau wali ginol likalika ge wali gegi paganina ni pwamowasi, pagan nanakina ni yakil yoho, logugui sasapona ni pamilil ni mihot, palopitau ali pankite ni tabwa tunahot, ge Aban Bwabwalena Hot ni pwabwabwalena al. ");
INSERT INTO mpx_vpl VALUES ("DN9_25","028_9_25","DAN","9","25","25","“He nuwam ni sapu baaba hiwe kaiwena: tologugui etega abwe ni ba Yelusalema nihi tal pasikal, yaka ni telipunaa sauga o ni na ana siga tohouwa toto Yehoba wana hilihili gamagalina ni nem, he baliman seben paseben ge baliman seben ali gewi sikisti tu (62) nihi mowasi ga. (He sauga Yelusalema nihi tal pasikal, ginebi ana kamwasa ona ge ana gana gasigasisena, yaa sauga o elana nasi ni pulowan hot Yehoba wana gamagalau elal.) ");
INSERT INTO mpx_vpl VALUES ("DN9_26","028_9_26","DAN","9","26","26","Baliman seben ali gewi sikisti tu (62) o nihi mowasi, yaka Yehoba wana hilihili gamagalina nihi lopaaliga, ana kite ni ola nige wana abalogugui i gagan. Yaka tohouwa etega ni masal inoke wana boda Yelusalema ge Limi Bwabwalena nihi apapanak-an. (Yaa iya abwe ni mowasi, wana mowasi nakina ni ola banata wana apapanak.) Yehoba logugui iyaka i ginol haba haveyan ge apapanak nihi gangan ni na ana siga abapwamowasiya. ");
INSERT INTO mpx_vpl VALUES ("DN9_27","028_9_27","DAN","9","27","27","Tohouwa o alonau ge gamagalau nihi gewi nihi pebabateli-agil ge bateli o nihi pagasisi baliman seben kaiwena. Yaa baliman seben o ali nuwanuwanaa, powon ge mulolu bolo hi giginol Yehoba elana ni lopwali ge ni paveyaho. Yaka Limi Bwabwalena pwatanaa toapapanak bwaibwaikikinina ni pamilil ge ni minaa o ana siga Yehoba tohouwa toto apapanak i giginol ni pwamowasi, ni ola te iyaka i logugui-an haba.” ");
INSERT INTO mpx_vpl VALUES ("DN10_1","028_10_1","DAN","10","1","21","Sailusa Pesiya wali kin wana sauga logugui ana baliman etonina gamwanaa, Daniyela ana pankite etega al i gan. (puna 1)  Wasana i leli lowan i ola hiwe: Nau Daniyela wik eton aanan amnana waiwaisana ge oine ya kokowanan, ge ya awaawanun aatena enuna Yehoba ni pem elau. Enaa sauga ya talmilil wewel Taigilis bebenaa, o pankite etega i gan. Anelose etega ya kite ana awa i ola gamagal, kaliko wakewakekena waiwaisana i galoi ge ana awa i namanamal. Anana i bwata i ola boda bwabwatana analiya. (puna 2-6)   Lovakun kaiwena tuwau i pweyata ge ya talpo bilibiliya. Yaka nimana elana i kukupalutau inoke epwakokou ya loantawan ge nimwau ya tuhikan. Yaka i ba, “U lut ge u laegan bubun hauna na baunan.” Inoke ya lut ya talmilil. (puna 7-11)  Yaka i baem elau i ba, “Lan toto u telipuna u awaawanun aatena enuna Yehoba ni pewa i nem ana siga sauga ya, Yehoba wam awanun i hago. Inoke i patunau ya nem ge na pamasal eliyam hauna gun abwe sauga i nenem ni gan wam gamagalau elal. He lan ana gewi tuwenti wan (21) Pesiya ana abalogugui ana tobwabwatanai kausau, yaa Maikol, aneloseyau wali tohouwa bwabwatana etega, i nem i labeyau.” (puna 12-14)  Nige bosowaiu na baaba, inoke anelose hohopeu i pihikan i pabaaba-agau. I ola al no gasisi gegewena i mowasi, inoke i pihikagau ge i pagasisi-agau. (puna 15-19)  Yaka i baem elau, “Nau ya nem ge wam wasa na pewa ga hi leli ola ba tunahot ana buki elana.” (puna 20-21)  ");
INSERT INTO mpx_vpl VALUES ("DN11_1","028_11_1","DAN","11","1","10","Yaka anelose i liwan eliyau i ola hiwe. “Pesiya ana abalogugui ana kin eliyaa, kin etega al wana abalogugui ni pamilil, yaa abwe nihi wali ni tabwa abalogugui esopali. (puna 1-4)  “Abalogugui labui, toto i minaa yalasa ge toto i minaa aluwabwa, nihi lohaveyan nemnowa. (puna 5-20)  “Yaka abwe gamagal etega wana pagan nanakina hot ni tabwa aluwabwa wali kin gasigasisena. Iya ni pihigelgel Yehoba wana gamagalau elal ge wali tapwalolo elana. (puna 21-30)  ");
INSERT INTO mpx_vpl VALUES ("DN11_31","028_11_31","DAN","11","31","31","“Wana tolohaveyan Limi Bwabwalena nihi ahe, yaka ana bwabwalena nihi apapanak-an. Lan maisena ge maisena ana powon nihi paveyaho ge toapapanak bwaibwaikikinina nihi pamilil. ");
INSERT INTO mpx_vpl VALUES ("DN11_32","028_11_32","DAN","11","32","32","Bolo Yehoba wana bateli ana en hi pek, nuwaliya ni gove inoke nihi olak elana. Yaa bolo wali Yabowaine ana mel hi teli alona wali gasisi nihi haveyan sikal elana.” ");
INSERT INTO mpx_vpl VALUES ("DN12_1","028_12_1","DAN","12","1","1","Yaka abwe anelose o i ba, “Sauga o elana Maikol, iya aneloseyau wali tohouwa bwabwatana etega toto wam gamagalau ali tomatahikan, ni lut. He miloloyowan bwabwatana ni gan ololana nige sauga etega i gagan i telipunaa sauga toto abwe boda ona hi masal. Yaa sauga o elana wam gamagalau gegewel bolo alaliya iyoho Yehoba i leli lowan wana buki elana ni pwamwalil. ");
INSERT INTO mpx_vpl VALUES ("DN12_2","028_12_2","DAN","12","2","2","Bolo hi aliga ge tuwaliya i kenukenu bilibili gamwanaa, hi gewigewi nihi lut al. Enuna yawal mihomihotina nihi pwawa ge enuna puluwawi ge nak mihomihotina nihi pwawa. ");
INSERT INTO mpx_vpl VALUES ("DN12_3","028_12_3","DAN","12","3","3","Bolo tonuwa sapu ge pagan sasapona hi panpankiti-an gamagalau hi gewi elal, maniniliya ni namanamal ni ola alalati bwagatau labulabum namanamalina ge ni ola putum, sauga gegewena nige ni momowasi. ");
INSERT INTO mpx_vpl VALUES ("DN12_4","028_12_4","DAN","12","4","4","“Owa Daniyela, am pankite ya ana baaba nu sume gamagalau elal, ana buki nu papi kaus ana siga sauga mowamowasena. He gamagalau nihi gewi nihi patalelu nemnowa nuwaliya wali aatena nihi pwabwata.” ");
INSERT INTO mpx_vpl VALUES ("DN12_5","028_12_5","DAN","12","5","5","Yaka nau Daniyela matau ya lipwatanik anelose labui al ya kitel, etega i minaa wewel labena etega ge etegana i minaa labena etega. ");
INSERT INTO mpx_vpl VALUES ("DN12_6","028_12_6","DAN","12","6","6","Anelose toto kaliko wakewakekena waiwaisana i galoi i minaa hawawala wewel pwatanaa, inoke anelose labui o etegana i nel elana i ba, “Sauga lolovakunina ya ana yapu ga ni ola ge abwe ni mowasi?” ");
INSERT INTO mpx_vpl VALUES ("DN12_7","028_12_7","DAN","12","7","7","Inoke anelose toto kaliko wakewakekena waiwaisana i galoi nimana labui i latahin labulabumwa, yaka i papasila Yabowaine toto yawalina i mihot alanaa ge i ba, “Ana yapu ni ola baliman eton ge awalehina. Sauga gamagal toto gamagalau bwabwalel i apapanak-agil wana gasisi ana sauga ni so, he bugul bolo ya nihi mowasi.” ");
INSERT INTO mpx_vpl VALUES ("DN12_8","028_12_8","DAN","12","8","8","Wana baaba ya hago, yaa nige nuwau i sasapu. Inoke ya nel, “Tonowak, bugul bolo ya gegewel ali abapwamowasi ga ni ola?” ");
INSERT INTO mpx_vpl VALUES ("DN12_9","028_12_9","DAN","12","9","9","Anau i lahe i ba, “Daniyela, bahi nu nuwanuwatu kaiwena, nu nowa ya, kaiwena baaba ya nihi misumi ga ana siga sauga mowamowasena. ");
INSERT INTO mpx_vpl VALUES ("DN12_10","028_12_10","DAN","12","10","10","Gamagalau nihi gewi, labose o eliyalil Yehoba ni abubunil ge nihi yanayana, yaa nak ana toginol nak nihi mimi awaawaginol ya. Nak ana toginol nige nuwaliya ni sasapu, yaa tonuwa sapu baaba ana sapu nihi atena. ");
INSERT INTO mpx_vpl VALUES ("DN12_11","028_12_11","DAN","12","11","11","“Lan maisena ge maisena ana powon nihi paveyaho ge toapapanak bwaibwaikikinina nihi pamilil, yaka toto o enaa lan ali gewi 1,290 nihi gan. ");
INSERT INTO mpx_vpl VALUES ("DN12_12","028_12_12","DAN","12","12","12","Bolo ebo nihi abulilek ge alona wali atimatuwa nihi matamatan ana siga lan ali gewi 1,335 nihi mowasi, Yehoba ni muloluagil. ");
INSERT INTO mpx_vpl VALUES ("DN12_13","028_12_13","DAN","12","13","13","“Yaa owa, nu nowa alom wam nuwa laumwal nu mina ana siga wam lan ali abapwamowasi. Nu aliga ge nu veyaho, inoke sauga mowamowasena elana nu lut al ge molam toto Yehoba i lovivina-an nu ahe.” ");
INSERT INTO mpx_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Sauga etegana Yehoba i baek Yona, Amitai natuna elana i ba, ");
INSERT INTO mpx_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Nu na Ninibe panuwa bwabwatana, ge nu papaatena nu ba nau na lahel, kaiwena wali ginol nanakina i bwata matawa.” ");
INSERT INTO mpx_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Yaa Yona nuwana Yehoba ni lou luwai ge ni na Sipein. Inoke i na i lau panuwa Yopa, waga etegana i pwawa i nana labi o elana. Yaka wana kamwasa i pwamola, inoke i gaiha ge i kuki tage ni na Sipein ge ana bwaga ni gan Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Yaka abwe Yehoba mana bwabwatana hot i patowa hoga pwatanaa. Wowol ana gasisi kaiwena kelaubwa waga ni pasamwalekaleka. ");
INSERT INTO mpx_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Waga ana totuwalali gegewel hi lovakun, inoke maisena maisena labe kaiwena hi yoga wali yabowaineyau elal. Inoke usan toto hi usan hi yoho palo hogaa, yaka waga ni mweyaha. Yaa Yona iyoho waga gamwanaa ge i kenu mati. ");
INSERT INTO mpx_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Abwe kapten i na elana ge i ba, “Gan, ga i ola ge u kenu mati? U lut ge u awanun wam yabowaine elana! Tab eba ni nuwanakagila ge ni pwamwalila.” ");
INSERT INTO mpx_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Waga ana totuwalali hi pebaaba-agil hi ola, “Sula ta ab ge ta loyaan henala wana gegi ge nak ya i masal.” Inoke sula hi ab ge Yona hi pwawa. ");
INSERT INTO mpx_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Yaka hi nel elana hi ba, “U ba bubun eliyama. Owa wam gegi kaiwena nak ya i masal eliyala o nigeya? Hauna wam tuwalali? Hauna labi elana u noem? Hapanuwa gamagalina owa?” ");
INSERT INTO mpx_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Inoke analiya i lahe i ba, “Nau Hibilu gamagalina, ya kululu Yehoba, Yabowaine labulabumwa, iya panuwa ge hoga ali toginol.” ");
INSERT INTO mpx_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Inoke hi lovakun nabi. He hi atena te Yehoba i lou luwai, kaiwena iyaka wali wasa i pek ola. Inoke hi baek elana hi ba, “Ga i ola ge u ginol ola?” ");
INSERT INTO mpx_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Yaa wowol iyaka i gagasisi nawa, inoke hi baek elana hi ba, “Hauna gun naha ginol eliyam ge wowol ya ni mowasi?” ");
INSERT INTO mpx_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yona i baek elal i ba, “Ku alipalowau hogaa inoke ni mainum. Ya atena nau no gegi kaiwena, heiya te wowol bwabwatana ya i masal eliyamiu.” ");
INSERT INTO mpx_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","He totuwalali nige nuwaliya i oola, yaka hi logasisi tage waga nihi leva tukan panuwaa. Yaa nige bosowailiya, kaiwena wowol iyaka i gasisi hot. ");
INSERT INTO mpx_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Inoke hi yoga ha Yehoba elana hi ba, “Oo Yehoba, ha awanun elam, bahi nu babaa naha yayaomal kaiwena tau ya yawalina ha apanak. Bahi nu babaa tage gegi i minaa eliyama kaiwena tau etegana ha payaomal. Bahi nu lalahema, kaiwena owa u ba te wowol ya i masal.” ");
INSERT INTO mpx_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Inoke Yona hi ahe ge hi alipalo hogaa, yaka abwe wowol bwabwatana i mowasi ge i mainum. ");
INSERT INTO mpx_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ginol o kaiwena totuwalali Yehoba hi lovakunan nabiyan, inoke bwasumu etega hi powonan elana ge hi bateli nihi kukululu eliyana. ");
INSERT INTO mpx_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Inoke Yehoba moti bwabwatana etegana i patuna i na Yona i tinon, ge i miminaa tinena gamwanaa lan eton ge bulin eton. ");
INSERT INTO mpx_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yona iyoho moti tinena gamwanaa, inoke i awanun wana Yabowaine Yehoba elana, ");
INSERT INTO mpx_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","i ba: O Yehoba, no minanakina elana ya yoga elam, inoke anau u lahe. Yaomal hot elana ya awanun labe kaiwena, inoke anau u hago. ");
INSERT INTO mpx_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","U alipalowau hogaa ya lau limwan gamwanaa hot, hoga i mipainagau. Wam bagol bwabwatal hi bini pwatawa. ");
INSERT INTO mpx_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ya ba, “Iyaka u patuna owaowa-agau matamwa, yaa matau na lihin al elam wam Limi Bwabwalena elana.” ");
INSERT INTO mpx_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Hoga i yabomwau kelaubwa na unun, limwan i mipainagau, lumun kaunu i avan. ");
INSERT INTO mpx_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ya lobek ya na paiya hot o siga oya wali siun i telipunaa, ya lau ya na Tuma, iya nige bosowaina gamagal naha tagila. Yaa owa, Yehoba no Yabowaine, yawaliu u momol heyanem panuwa milalauina o elana. ");
INSERT INTO mpx_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Sauga yawaliu kelaubwa ni mowasi, Yehoba ya nuwahikagiwa. No awanun i ha elam i na wam Limi Bwabwalena elana. ");
INSERT INTO mpx_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Bolo hi kukululuek yabowaine kakawel elal, iyaka hi towaagiwa, nige hi nunuwana-agiwa. ");
INSERT INTO mpx_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Yaa alou no ba mulolu bwasumu na powonan eliyam, ge na ginol ni ola no bateli eliyam. Pwamwal i noem Yehoba eliyam. ");
INSERT INTO mpx_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Inoke Yehoba i ba moti i na Yona i mamanuvi-an datuwa. ");
INSERT INTO mpx_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yaka paeluwana Yehoba i baek Yona elana i ba, ");
INSERT INTO mpx_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Nu na Ninibe panuwa bwabwatana, ge wasa toto ya baunan elam nu wasaan elal.” ");
INSERT INTO mpx_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Inoke Yona Yehoba anana i hago ge i na Ninibe. He Ninibe panuwa bwabwatana hot, ebo gamwana ta nawaan nasi lan eton ta nawanawa-an. ");
INSERT INTO mpx_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Lan houwan elana, Yona i telipuna i nawanawa panuwa gamwanaa, inoke i papaatena i ba, “Lan poti ni mowasi abwe Yehoba Ninibe ni pasamwalekaleka.” ");
INSERT INTO mpx_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninibe gamagaliliyau Yabowaine wana baaba hi abulilek-an. Inoke i telipunaa bolo alaliya bwabwatal i na bolo alaliya kekeisi elal, hi ba ali galebu nihi palahikan ge kaliko toto bwasumu pupunona elana hi ginoliya nihi galoi. ");
INSERT INTO mpx_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Sauga Ninibe ana kin i hago Yona ga i ba ola, inoke i lutem wana abamisiyo wawasana elana ge wasawasa kalikona i palo yoho tuwanaa, yaka kaliko toto bwasumu pupunona elana hi ginoliya i galoi ge i misiyowa papakova gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Inoke baaba i patuna i na Ninibe ana tomina gegewel elal i ba: Logugui hiwe i noem nau kin alowau ge o tolabe elama. Bahi gamagal o ebo bwasumu etega, ebo bulumwakau, sipi o goti, aanan ni aan ge wewel ni iim. ");
INSERT INTO mpx_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Gamagalau ge bwasumu tuwaliya nihi os kaliko toto bwasumu pupunona elana hi ginoliya, inoke nihi awanun gagasisi Yabowaine elana. Yaka wali pagan nanakil ali en nihi pek ge wali lohalohaveyan nihi paveyaho. ");
INSERT INTO mpx_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ebo ta ginol ola, tab abwe Yabowaine ni atilomwan-agila ge wana nuwatu ni pil, yaka ana huga ni mowasi ge nige ta yayaomal? ");
INSERT INTO mpx_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Sauga Yabowaine gamagalau wali ginol i kite ge i kite wali pagan nanakil ali en iyaka hi pek, inoke i atilomwan-agil, nige i aapapanak-agil i oola valila wana baaba. ");
INSERT INTO mpx_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","He Yona nige i yayaliyaya Yehoba wana nuwatu kaiwena inoke i huga. ");
INSERT INTO mpx_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yaka i awanun Yehoba elana i ba, “O Yehoba, valila nau iyoho no panuwaa, he ya atena ya te Ninibe nige nu lalahel! Heiya kaiwena etimwawa ya lou tage na nok Sipein. Kaiwena ya atena owa Yabowaine toatilomwan ge tonuwaleyan, nige etimwawa u huhuga, nunuwana u kalaopopwi, ge etimwawa wam nuwatu nu pil nige gamagalau nu aapapanak-agil. ");
INSERT INTO mpx_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","O Yehoba, sauga ya yawaliu nu ahe. Nige nuwau na molu, nuwau na aliga.” ");
INSERT INTO mpx_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Yaa anana Yehoba i lahe i ba, “Wam sapu i gan ge nu huga?” ");
INSERT INTO mpx_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Inoke Yona i tagil i na panuwa tolinaa labi balimana. Ana pwapwaligum etegana i ginol, inoke i misiyowa liguligumwina elana ge i matamatan ni kite Yehoba panuwa Ninibe ni lahe o ebo nigeya. ");
INSERT INTO mpx_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Yaka abwe Yehoba Yabowaine hihiu etegana i pasiun i hek Yona pwatanaa ana pwapwaligum, inoke tuwana amnana ni pawaisi. Yona nuwana i waisi hot hihiu o kaiwena. ");
INSERT INTO mpx_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Yaa panuwa abwe i mwamwananal, Yehoba i ba mwatamwata etegana hihiu i an inoke i aliga. ");
INSERT INTO mpx_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Sabwelu iyaka i ha, inoke Yehoba mana babaliman kalakalasina i patowa ge sabwelu Yona kaununa i yane, inoke tuwana i pweyata. Nuwana ni aliga, yaka i ba, “Binimala na aliga, nige nuwau na molu.” ");
INSERT INTO mpx_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Yaa Yabowaine i baek elana i ba, “Wam sapu i gan ge hihiu baena u huga?” Yaka i ba, “Ibwe, ya huga nabi, nuwau na aliga.” ");
INSERT INTO mpx_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Inoke Yehoba i ba, “Owa u nuwanuwatu hihiu ya kaiwena, yaa nige u papasiun ge nige bugul etega u giginol kaiwena. Bulin maisena i siun ge bulin etega al i aliga. ");
INSERT INTO mpx_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","He Ninibe, iya panuwa bwabwatana, gamwanaa gamagal ali gewi wan handeled tuwenti tausan (120,000) yayaluwaliya i gogou, avaliyau ge bwasumu hi gewi. Age bahi nau na nuwanuwatu kaiweliya?” ");
INSERT INTO mpx_vpl VALUES ("ML1_1","040_1_1","MAL","1","1","1","Palopisai e Yehoba wana baaba, toto i baunan palopita Malakai elana ge ni wasaan boda Isileli elal. ");
INSERT INTO mpx_vpl VALUES ("ML1_2","040_1_2","MAL","1","2","2","Yehoba i ba, “Ya hilemiu komiu no nunuwana gamagaliliyau.” Yaa ku nel ku ba, “He ga i ola ge u ba tage u hilema ama wam nunuwana gamagaliliyau?” Yaka Yehoba i ba, “Ku atena ya te Iso iya Yakobo talina. He Yakobo ya hile, ");
INSERT INTO mpx_vpl VALUES ("ML1_3","040_1_3","MAL","1","3","3","yaa Iso ya towani. Inoke wana labi oyana gaganina ya apapanak-an i tabwa ula kekevana wanuka bekikil wali abamina.” ");
INSERT INTO mpx_vpl VALUES ("ML1_4","040_1_4","MAL","1","4","4","Tabam boda Idom nihi ba, “Bwagana wama panuwa ona u tagalekaleka-agil, ama abwe naha tal pasikal.” Inoke Yehoba Togasisi Hot i ba ola hiwe, “Nihi tal pasikal, yaa nau abwe na pasamwalekaleka al. Yaka gamagalau getogal nihi ba, ‘Labi o wali pagan i nak ge Yehoba i hugaagil sauga gegewena nige ni momowasi.’ ");
INSERT INTO mpx_vpl VALUES ("ML1_5","040_1_5","MAL","1","5","5","Abwe totomiu matamiu elana nuku kite, yaka nuku ba, ‘Yehoba alana i bwata labi bolo nige kila Isileli wala labi i oola al elal!’” ");
INSERT INTO mpx_vpl VALUES ("ML1_6","040_1_6","MAL","1","6","6","Yehoba Togasisi Hot i baek topowon elal i ba, “Natun tamana i awatauwan, i ola al totuwalali wana tonowak i henapuan. He nau Tamamiu, hauna kaiwena ge nige ku aawatauwagau? Nau wami Tonowak, ga i ola ge nige ku lolovakunagau? Komiu alau ku teli lowan, i ola gamagal bwagabwaga nau.” Yaa ku nel ku ba, “He ga i ola ge u ba tage alam ha teli lowan?” ");
INSERT INTO mpx_vpl VALUES ("ML1_7","040_1_7","MAL","1","7","7","Yaka Yehoba i ba, “Alau ku teli lowan te powon nige hi bwabwalena ku ginola o abapowona.” Yaa ku nel ku ba, “Ga i ola ge u ba tage wama ginol elam nige i bwabwalena?” Yehoba Togasisi Hot i ba, “Wami ginol elau nige i bwabwalena kaiwena ku nuwatu tage o abapowon bugul bwagabwaga. ");
INSERT INTO mpx_vpl VALUES ("ML1_8","040_1_8","MAL","1","8","8","Sauga ebo bwasumu bolo mataliya i kai ku pwatanim nuku powonagil elau, ginol o tab i waisi? Nigeya! Sauga ebo bolo aeliya i kom o hi kasiyebwa ku pwatanim eliyau, ginol o tab i waisi? Nigeya! He bwasumu ololal o nuku muloluagil wami tologugui bwabwatana elana, tab nasi ni yaliyaya-agimiu ge ni labemiu? Nigeya!” ");
INSERT INTO mpx_vpl VALUES ("ML1_9","040_1_9","MAL","1","9","9","Yehoba Togasisi Hot i ba, “He nuku awanun nabinabi nau wami Yabowaine elau na atilomwan-agimiu! Yaa ebo mulolu ololal o ku pwatanim, tab na yaliyaya-agimiu? Nigeya!” ");
INSERT INTO mpx_vpl VALUES ("ML1_10","040_1_10","MAL","1","10","10","Yehoba Togasisi Hot i ba, “Binimala alomiu etega Limi Bwabwalena ana nog ni kaus, yaka bahi hiwo nuku toton ge bwasumu nuku popowonagil bwabwage o abapowona. Nige ya yayaliyaya-agimiu ge wami mulolu nige na aahe. ");
INSERT INTO mpx_vpl VALUES ("ML1_11","040_1_11","MAL","1","11","11","Sabwelu wana abaheheya i na ana abalobeka, alau ni bwata panayawi labena gegewel elal. Panuwa gegewel bugul bwalena waiwaisana nihi ton elau ge mulolu waiwaisal nihi pwatanim elau, kaiwena alau ni bwata panayawi labena gegewel elal. ");
INSERT INTO mpx_vpl VALUES ("ML1_12","040_1_12","MAL","1","12","12","Yaa komiu alau nige ku aawatauwan ge nige ku pwapwabwabwalena, kaiwena ku nuwatu ku ba, ‘Babala ana abapowon nige i bwabwalena ge ana powon heliya bugul bwagabwaga.’ ");
INSERT INTO mpx_vpl VALUES ("ML1_13","040_1_13","MAL","1","13","13","Ge ku ba, ‘Tuwalali ya ha esaian!’ yaka buhumiu ku lewaan. Inoke bwasumu bolo ku kaomel ge bolo aeliya i kom o ebo hi kasiyebwa ku pwatanim elau. He bolo o ku pwatanim tage wami mulolu eliyau! Tab nasi wami mulolu na ahel? Nigeya!” He Yehoba wana baaba i ola to. ");
INSERT INTO mpx_vpl VALUES ("ML1_14","040_1_14","MAL","1","14","14","Yehoba Togasisi Hot i ba, “Tokakawi na nuwamutan ana lahi pupulowanina na pek, toto wana sipi o goti melutauina waiwaisana i gan inoke i bateli ni pem elau, yaa getoga, ana gila gaganina, ni ahe ni powonan nau Babala elau. Ana lahi na pek, kaiwena nau Kin bwabwatana ge alau panayawi labena gegewel nihi lovakunan.” ");
INSERT INTO mpx_vpl VALUES ("ML2_1","040_2_1","MAL","2","1","1","Yehoba Togasisi Hot i ba, “Komiu topowon ami logugui na baunaniwa ni ola hiwe. ");
INSERT INTO mpx_vpl VALUES ("ML2_2","040_2_2","MAL","2","2","2","Ebo nige anau nuku hahago ge nige alau nuku aawatauwan ginebi atemiu bwalibwaligena, yaka na ba nuwamut-agimiu ami nak na ginol, ge toto tage ami mulolu na pil ni tabwa ami nak. He iyaka ya ginol i ola to, kaiwena nige ku aawatauwagau ginebi atemiu bwalibwaligena. ");
INSERT INTO mpx_vpl VALUES ("ML2_3","040_2_3","MAL","2","3","3","Tubumiyau nige nihi tatalaabab yaka abwe nihi mowasi. Wami hagali bwasumoliyau elokena na loabuabut-an maninimiwa, yaka na ahe tagilagimiu wami abatuwalaliya i ola bwasumu elokena hi kaval egonan hi teli musamusa abanaa. ");
INSERT INTO mpx_vpl VALUES ("ML2_4","040_2_4","MAL","2","4","4","Yaka saugena o abwe nuku atena ami logugui ya pewa te nuku awatauwagau, kaiwena nuwau bateli toto sauga houhouwena alowau un Libai tubutubumiyau ha pebabateli-agima ni mihot. ");
INSERT INTO mpx_vpl VALUES ("ML2_5","040_2_5","MAL","2","5","5","“Nau ya bateli yawal ge mibubun na pek elal, ge ya ginol ola. Heliya ali logugui te nihi lovakunagau, yaka tunahot hi lovakunagau ge alau hi awatauwan. ");
INSERT INTO mpx_vpl VALUES ("ML2_6","040_2_6","MAL","2","6","6","Panpankiti tutunahotina hi baubaunan awaliyaa, nige kakawi i tatagilem hohopeliyaa. Hi mipalalem hot elau ginebi wali mibubun ge wali pagan sasapona, ge gamagalau hi gewi hi pasikaliliem wali gegi elana. ");
INSERT INTO mpx_vpl VALUES ("ML2_7","040_2_7","MAL","2","7","7","He topowon wali tuwalali te aatena tutunahotina nihi mimi baubaunan hohopeliyaa, ge panpankiti waiwaisana gamagalau nihi hagowa awaliyaa. Kaiwena heliya nau Yehoba Togasisi Hot no elopapatuna.” ");
INSERT INTO mpx_vpl VALUES ("ML2_8","040_2_8","MAL","2","8","8","Yehoba Togasisi Hot i ba, “Yaa komiu kamwasa tutunahotina ku nopalegi, ge wami panpankiti elana gamagalau hi gewi ku pagegel ge hi sogu. Bateli toto alowau tubumiyau un Libai ha pebabateli-agima komiu ku apanak. ");
INSERT INTO mpx_vpl VALUES ("ML2_9","040_2_9","MAL","2","9","9","Inoke na ba gamagal gegewel nihi awa naknak-agimiu ge nihi teli lowagimiu nuku puluwawi mataliyaa, kaiwena nige no kamwasa ku totoulil, ge wami ginol nige i olaolaek gamagalau gegewel elal, yaa ku logugui pagasisi enuna elal ge enuna nigeya.” ");
INSERT INTO mpx_vpl VALUES ("ML2_10","040_2_10","MAL","2","10","10","Kila gegewela Tamala maisena ya, age? He Yabowaine maisena ya i ginolila, age? Inoke ga i ola ge wala bateli avalau elal ta leke ge eliyana bateli toto Yehoba alonau ge tubulau hi pebabateli-agil ta apanak? ");
INSERT INTO mpx_vpl VALUES ("ML2_11","040_2_11","MAL","2","11","11","Kila Yuda wala bateli iyaka ta leke. Pagan bwaibwaikikinina iyaka ta ginol Yelusalema ge labi Isileli. Ginol o heiya labi getoga yowauiliyau bolo hi kululuek yabowaine kakakawena elana ta alolonagil, inoke eliyana Limi Bwabwalena toto Yehoba i nunuwana-an ta papabiki-an. ");
INSERT INTO mpx_vpl VALUES ("ML2_12","040_2_12","MAL","2","12","12","Gamagal maisena ge maisena toto pagan ya i ginol, bwagana bwasumu i pwapwatanik ge i mumulolu-an Yehoba Togasisi Hot elana, ya awanun Yehoba ni ahek yoho boda Isileli gamwanaa. ");
INSERT INTO mpx_vpl VALUES ("ML2_13","040_2_13","MAL","2","13","13","He bugul etega al: alona wami kahin lopili ku nem Yehoba wana abapowona ge matanunumiu i sani laulau, kaiwena wami mulolu nige i yayaliyaya-an ge i aahe. ");
INSERT INTO mpx_vpl VALUES ("ML2_14","040_2_14","MAL","2","14","14","Yaka ku nel ku ba, “Hauna kaiwena nige i yayaliyaya-an?” Puna i ola hiwe, kaiwena Yehoba wam bateli i hago, toto u ginol lagom eliyana, iya wam sauga heval u alolonan. Yaa bwagana u bateli te iya lagom ge alom ku tubwi, bateli o iyaka u leke. ");
INSERT INTO mpx_vpl VALUES ("ML2_15","040_2_15","MAL","2","15","15","Yehoba iyaka i ginolimiu ku tabwa maisena, age? Ge ami toto eluwa tuwamiu ge yayaluwamiu iya wana bugul. He Yehoba hauna nuwana? Nuwana natumiyau bolo iya nihi awatauwan. Inoke nuku matahikagimiu bahi komiu etega wana bateli lagona elana, iya wana sauga heval i alolonan, ni leleke. ");
INSERT INTO mpx_vpl VALUES ("ML2_16","040_2_16","MAL","2","16","16","Kaiwena Yehoba Isileli wala Yabowaine i ba, “Alolon ana towa nige ya yayaliyaya-an. He nige ya yayaliyaya-an te tau lagona ana hehegan ni apapanak-an ni ola o.” Yehoba Togasisi Hot wana baaba i ola to. Inoke nuku matahikagimiu bahi wami bateli nuku leleke. ");
INSERT INTO mpx_vpl VALUES ("ML2_17","040_2_17","MAL","2","17","17","Wami baaba kaiwena Yehoba amnana i ahe. Yaka ku nel ku ba, “He ga i ola ge u ba tage wama baaba kaiwena Yehoba amnana i ahe?” Kaiwena ku babaa, “He bolo nak hi giginol gegewel hi waisi Yehoba matanaa ge i yaliyaya-agil ya!” O kaiwena ku babaa, “Yabowaine toto tage gamagalau ni payatalala, he iya ga!” ");
INSERT INTO mpx_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","Yaka Yehoba Togasisi Hot i ba, “He no elopapatuna na patuna, iya kamwasa ni lovivina-an kaiweu. Yaka Babala toto kaiwena ku babaa, ‘Iya ga?’ etimwawa ni nem wana Limi Bwabwalena elana; elopapatuna, no bateli ana towasa, toto nuwamiu hot nuku kite, iya ni nem.” ");
INSERT INTO mpx_vpl VALUES ("ML3_2","040_3_2","MAL","3","2","2","Yaa lan toto ni nem, henala bosowaina wana lahi ni palahikan? Sauga ni vin, henala bosowaina ni talmilil manininaa? Nige etega. Kaiwena iya ni ola hiwo kalakalasina toto eliyana silba hi pawayui yaka mumusana hi ahek yoho. Iya ni ola sop gasigasisena toto kaliko hi uliya i yanayana. ");
INSERT INTO mpx_vpl VALUES ("ML3_3","040_3_3","MAL","3","3","3","Wana tuwalali ni ola tau toto silba i pawayui ge mumusana i ahek yoho. Inoke topowon, heliya un Libai, wali nak ni ahek yoho, yaka abwe nihi waisi nihi ola gold ge silba enoliya hot. Inoke Yehoba wana totuwalali ginebi wali pagan sasapona powon waiwaisal nihi powonagil, ");
INSERT INTO mpx_vpl VALUES ("ML3_4","040_3_4","MAL","3","4","4","yaka Yuda ge Yelusalema wali powon Yehoba ni yaliyaya-an, ni ola to valila sauga houhouwena. ");
INSERT INTO mpx_vpl VALUES ("ML3_5","040_3_5","MAL","3","5","5","Yehoba Togasisi Hot i ba, “Ya nonowa yaka na payatala-agimiu. Etimwawa na baaba, inoke bolo hi kukukula, bolo hi gaganawal, bolo hi woliwoli kakawi, bolo totuwalali molaliya nige hi pepek bubun, bolo abuabulau ge wawayau mwawamwawas ali hehegan hi apapanak-an, ge bolo bwabwali nige ali logugui hi aabubun na ba pamasalil. Heliya wali pagan i pamasal nige hi lolovakun-agau.” ");
INSERT INTO mpx_vpl VALUES ("ML3_6","040_3_6","MAL","3","6","6","Yehoba Togasisi Hot i ba, “Nau Yehoba nige no nuwatu ya pipil getogaan. Heiya te kaiwena ge komiu Yakobo tubutubunau nige ya pwapwamowasemiu. ");
INSERT INTO mpx_vpl VALUES ("ML3_7","040_3_7","MAL","3","7","7","I telipunaa tubumiyau houhouwel wali sauga elana i nem ana siga sauga ya, no logugui ali en ku pek nige ku hehenapu-agil. He nuku sikalim elau, yaka nau na sikal eliyamiu.” Yaa ku nel ku ba, “Ga i ola ge u ba tage naha sikal elam?” ");
INSERT INTO mpx_vpl VALUES ("ML3_8","040_3_8","MAL","3","8","8","Yaka Yehoba i ba, “Tab i sapu gamagal ni kaoma wana Yabowaine elana? Nigeya hot! Yaa age komiu ku kakaoma elau.” Yaa ku nel ku ba, “Ga i ola ge u ba tage ha kakaoma elam?” Yehoba Togasisi Hot i ba, “Ku kaoma te nige wami eyowa enona ge wami bwasumu ku wawalel paelulutega ge wali maisena ku pwapwatanim elau. I ola al nige wami mulolu ona ku pepem. ");
INSERT INTO mpx_vpl VALUES ("ML3_9","040_3_9","MAL","3","9","9","Inoke iyaka ya ba nuwamut-agimiu ami nak ya ginol, kaiwena gegewemiu ku kakaoma elau. ");
INSERT INTO mpx_vpl VALUES ("ML3_10","040_3_10","MAL","3","10","10","He wami eyowa enowaliya nuku wali paelulutega, yaka ana wali maisena toto nau kaiweu, bwabwaligena nuku pwatanim ana abateliya, inoke aanan ni gewi no limiya. He nuku laboseyau. Nuku ginol ni ola to, yaka nuku kite tab nau no mulolu kalakalaopopwina na ligin paloem labulabumwa. Ibwe, na ginol ni bwata hot, yaka nige abateli ni gagan ge bosowaina gegewena nuku teliya.” ");
INSERT INTO mpx_vpl VALUES ("ML3_11","040_3_11","MAL","3","11","11","Yehoba Togasisi Hot i ba, “Bwasumu nanakil ge kasiyebwa ona na kausil bahi wami eyowa nihi aapapanak-an. I ola al, wami oine enona nige nihi mamanubohina ge nihi sosogu, yaa nihi boina bubun ge nuku kibwal. ");
INSERT INTO mpx_vpl VALUES ("ML3_12","040_3_12","MAL","3","12","12","Yaka boda getogal gegewel nihi baewa eliyamiu nihi ba, ‘Tunahot Yehoba i muloluagimiu ku miwaiwaisana.’ Nihi ba ola, kaiwena wami labi ni yaliyaliyaya ni tabwa abamina waiwaisana etega.” He Yehoba Togasisi Hot wana baaba i ola to. ");
INSERT INTO mpx_vpl VALUES ("ML3_13","040_3_13","MAL","3","13","13","Yehoba i ba, “Iyaka ku ba panapanak-agau.” Yaa ku nel ku ba, “Ga i ola ge u ba tage ha ba panapanak-agiwa?” ");
INSERT INTO mpx_vpl VALUES ("ML3_14","040_3_14","MAL","3","14","14","Yaka Yehoba i ba, “Kaiwena ku ba, ‘Yabowaine awana ha aab, yaa nige ana waisi i gagan. Yehoba Togasisi Hot wana logugui ha henapuan, ge ginebi wama hanalau ha kahikahin matanaa wama gegi kaiweliya, yaa nige kekeisi etega i lalabema. ");
INSERT INTO mpx_vpl VALUES ("ML3_15","040_3_15","MAL","3","15","15","Nak ana toginol hi gogomwau, ge bwagana Yabowaine wana palahikan hi labose, nige lahi etega hi pwapwawa. Inoke tohanaha ha nuwatuagil heliya Yehoba i muloluagil ge hi miwaiwaisana.’” ");
INSERT INTO mpx_vpl VALUES ("ML3_16","040_3_16","MAL","3","16","16","He abwe bolo Yehoba hi lovakunan hi peba pagapagasisi-agil, yaka wali baaba Yehoba i laeganan bubun. Inoke i ba bolo hi lovakunan ge alana hi awatauwan, alaliya nihi leli lowan buki etega elana ali abanuwahikan iya matanaa. ");
INSERT INTO mpx_vpl VALUES ("ML3_17","040_3_17","MAL","3","17","17","Inoke Yehoba Togasisi Hot i ba, “Lan toto na tuwalali gamagalau na payatalal, heliya nihi ola no hilihili hot gamagaliliyau. Alou no atilomwan nige na lalahel, ni ola tau etega natuna toto iya awana i aab i aatilomwan-an. ");
INSERT INTO mpx_vpl VALUES ("ML3_18","040_3_18","MAL","3","18","18","Yaka abwe nuku kite al te no ginol i getoga tosasapol elal ge toginol naknak elal, i ola al i getoga bolo nau Yabowaine awau hi aab ge bolo nigeya elal.” ");
INSERT INTO mpx_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Yehoba Togasisi Hot i ba, “He lan o i nenem. Lahi toto na ginol lan o ni ola hiwo kalakalasina hot, yaka tohanaha gegewel ge nak ana toginol gegewel nihi ola mwawin kekevana. Inoke lan o no lahi ni ton olagil, he nige ewahililiya etega o ebo nuwaliya etega ni mimina. ");
INSERT INTO mpx_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Yaa bolo ku lovakunagau, he toto sapu ni pwatanim ni ha ni ola sabwelu kaiwemiu, yaka ni pwamolomiu ni ola sabwelu i yanemiu. Yaka komiu nuku tagil ge alona wami yaliyaya nuku susupeni ni ola bulumwakau natunau bolo hi sokalil ali gana kekeisi elana. ");
INSERT INTO mpx_vpl VALUES ("ML4_3","040_4_3","MAL","4","3","3","Yaka toginol naknak nuku potil lowagil. Lan toto na tuwalali gamagalau na payatalal, heliya nihi ola papakova aemiu gabulanaa.” He Yehoba Togasisi Hot wana baaba i ola to. ");
INSERT INTO mpx_vpl VALUES ("ML4_4","040_4_4","MAL","4","4","4","Yehoba i ba, “No totuwalali Mosese wana logugui nuku nuwahikan. Nau ya pek elana oya Sainai ge ya ba Isileli gegewel nihi henapuan. ");
INSERT INTO mpx_vpl VALUES ("ML4_5","040_4_5","MAL","4","5","5","“He mulaa abwe no lan bwabwatana ge lolovakunina ni vin, palopita Ilaitiya ga na patuna eliyamiu. ");
INSERT INTO mpx_vpl VALUES ("ML4_6","040_4_6","MAL","4","6","6","Iya tamataman aloliyau ge natuliyau ni ahel maniniliya ni abubun. Ebo nigeya, yaka na nem ge wami panuwa na apapanak-an hoti.” ");
INSERT INTO mpx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yeisu Keliso ana lihu i ola hiwe. Yeisu Keliso iya Deibid tubutubunina, Deibid iya Abalahama tubutubunina. ");
INSERT INTO mpx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalahama natuna Aisake, Aisake natuna Yakobo, Yakobo natunau Yuda ge talinau, ");
INSERT INTO mpx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda natunau Peles ge Sela, hinaliya Tama, Peles natuna Hesiloni, Hesiloni natuna Lama, ");
INSERT INTO mpx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama natuna Aminadab, Aminadab natuna Nason, Nason natuna Salimon, ");
INSERT INTO mpx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimon natuna Bowasa, hinana heiya Leyabi, Bowasa natuna Obedi, hinana heiya Ludi, Obedi natuna Diyesi, ");
INSERT INTO mpx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diyesi natuna Kin Deibid. Deibid natuna Solomon, hinana heiya toto valila Ulaiya lagona, ");
INSERT INTO mpx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon natuna Lehobowam, Lehobowam natuna Abaidiya, Abaidiya natuna Asa, ");
INSERT INTO mpx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa natuna Yehosepat, Yehosepat natuna Yolama, Yolama natuna Usaiya, ");
INSERT INTO mpx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya natuna Yotami, Yotami natuna Ehasi, Ehasi natuna Hesekaiya, ");
INSERT INTO mpx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiya natuna Manasa, Manasa natuna Eimon, Eimon natuna Yosaiya, ");
INSERT INTO mpx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiya natunau Yehoyasin ge talinau, sauga toto Babiloni hi nem Isileli hi ahel ge hi na hi telel Babiloni. ");
INSERT INTO mpx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isileli hi ahel ge hi na hi telel Babiloni inoke enaa: Yehoyasin natuna Seyaltiyel, Seyaltiyel natuna Selababel, ");
INSERT INTO mpx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selababel natuna Abiuda, Abiuda natuna Elayakim, Elayakim natuna Eiso, ");
INSERT INTO mpx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eiso natuna Seidok, Seidok natuna Akim, Asim natuna Eliuda, ");
INSERT INTO mpx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda natuna Eliyesa, Eliyesa natuna Meitan, Meitan natuna Yakobo, ");
INSERT INTO mpx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ge Yakobo natuna Yosepa, Meli lagona. Meli i ab Yeisu, heiya te ta ba Mesaiya. ");
INSERT INTO mpx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","He inoke Abalahama ana siga Deibid ta pwawa heyan ali gewi potin, Deibid ana siga sauga toto Isileli hi telel Babiloni heyan ali gewi potin, ge sauga toto o ana siga Mesaiya i masal heyan ali gewi potin. ");
INSERT INTO mpx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yeisu Keliso wana masal i ola hiwe. Hinana Meli alona ge Yosepa hi kawakawalolu. Nigeya ga hi aalolon, hi pwawa Meli iyaka i liyan Yayaluwa Bwabwalena wana gasisi eliyana. ");
INSERT INTO mpx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yosepa wana pagan i sapu ge nige nuwana Meli ni papuluwawi-an boda mataliyaa, inoke i nuwatu tage wali kawakawalolu ni leke sume. ");
INSERT INTO mpx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","I nuwanuwatu ola o, yaka ana kenonou elana Yehoba wana anelose i masala elana ge i ba, “Yosepa, Deibid tubuna, bahi nu lolovakun te Meli nu ahe lagom, kaiwena wana liyan i neem Yayaluwa Bwabwalena elana. ");
INSERT INTO mpx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Abwe ni ab natuna melutau, inoke alana nu tun Yeisu, kaiwena wana gamagalau ni pwamwalil wali gegi elana.” ");
INSERT INTO mpx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","He i masal i ola to, inoke Yehoba wana baaba toto palopita etega i pamasal i tabwa tunahot, ");
INSERT INTO mpx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","i ba, “Gamaina matabubuwa ni liyan ge ni ab natuna melutau, inoke alana nihi tun Imanuwela.” Imanuwela ana sapu heiya “Yehoba avala.” ");
INSERT INTO mpx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sauga Yosepa i kenu lut, inoke Meli i alolonan i ola Yehoba wana anelose wana baaba eliyana. ");
INSERT INTO mpx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yaa nige alona hi kekenu toyawa ana siga i ab natuna melutau. Inoke Yosepa wawaya alana i tun Yeisu. ");
INSERT INTO mpx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yeisu hi ab Bedeliyema, Yudiya ana labi elana, sauga toto Helodi iya wali kin. Inoke tosiba enuna hi loem nati hi nem Yelusalema, ");
INSERT INTO mpx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yaka hi nel hi ba, “Wawaya toto hi ab tage Yudiya wali kin iya ga? Ana etotohi putum ha kitek nati, inoke ha nem ge naha kululu elana.” ");
INSERT INTO mpx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sauga Kin Helodi wasa ya i hago i nuwanuwatu nabi, i ola al Yelusalema ana tomina hi gewigewi. ");
INSERT INTO mpx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Topowon bwabwatal ge Logugui ana topankite i yoga gogonil ge i nelil i ba, “Mesaiya ga nihi aba?” ");
INSERT INTO mpx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hi ba, “Bedeliyema, Yudiya ana labi elana, kaiwena palopita i leli i ola hiwe: ");
INSERT INTO mpx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Komiu Bedeliyema, Yudiya ana labi elana, nige bosowaina ta ba alamiu nige i bwabwata Yudiya ana tohouwa gamwaliyaa, kaiwena tohouwa etega ni masal gamwamiwa inoke no gamagalau Isileli ni nulil.” ");
INSERT INTO mpx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yaka Helodi i ba tosiba hi nem alonau hi liwan sumi, inoke i nelil hauna sauga hot putum ya i masal. ");
INSERT INTO mpx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yaka abwe i patunal hi na Bedeliyema i ba, “Ku na ga wawaya nuku loyaan bubun. Sauga ebo nuku pwawa inoke no wasa nuku pem, yaka nau al ge na na na kululu elana.” ");
INSERT INTO mpx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Tosiba kin anana hi hago inoke hi nawanawa al, yaka putum toto hi kitek nati hi kite al. He sauga hi kite, hi yaliyaya bubun hot. Inoke putum i houwaagil ana siga i veyahowa awan toto wawaya i miminaa pwatanaa. ");
INSERT INTO mpx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yaka hi na hi ulutuk limiya ge wawaya hi kite alona hinana Meli, inoke hi loepwakoku ge hi kululu elana. Wali gogomwau ana nabwa hi pwela inoke wali mulolu hi pek, gold, plenkinsens ge enonu toto alana meya. ");
INSERT INTO mpx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kenonou elana Yehoba i baek elal bahi nihi sisikal Helodi elana, inoke hi noek kamwasa getoga elana hi na wali panuwaa. ");
INSERT INTO mpx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sauga tosiba hi egon, yaka Yosepa ana kenonou elana Yehoba wana anelose i masal elana ge i ba, “Helodi nasi wawaya ni loyaan nuwana ni tagapaaliga. U lut, wawaya alona ge hinana u ahel ge ku lou ku na Itipita. Inoke nuku miminaa ga o ana siga na ba, yaka abwe nuku sikal.” ");
INSERT INTO mpx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yaka Yosepa i lut, wawaya alona ge hinana i ahel inoke bulina hi egon hi na Itipita, ");
INSERT INTO mpx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ge hi miminaa ga o ana siga Helodi i aliga. He i masal i ola to, inoke Yehoba wana baaba toto palopita etega i pamasal i tabwa tunahot, i ba, “Natu ya yogaan i tagila Itipita.” ");
INSERT INTO mpx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sauga Helodi i atena age tosiba hi kakawe, inoke i huga nabi. Yaka wana tolohaveyan i patunal ge wawayau melutauil Bedeliyema ge ana labi gegewena, bolo wali baliman eluwa ge gabulanaa, hi tagapaaligal. I golugoluwa sauga toto tosiba hi pamasal ge putum i masal. ");
INSERT INTO mpx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","He i masal i ola to, inoke Yelemaiya wana baaba i tabwa tunahot, i ba: ");
INSERT INTO mpx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Anan etega hi hago Lama elana, kahin nuwanuwanakina hot. Letiyeli i kahin natunau kaiweliya, nige nuwana nihi payaliyaya kaiwena iyaka hi aliga. ");
INSERT INTO mpx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wali minamina ana siga Helodi i aliga, inoke Itipita elana Yehoba wana anelose i masal Yosepa ana kenonou elana ");
INSERT INTO mpx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ge i ba, “U lut, wawaya alona ge hinana u ahel ge ku sikal labi Isileli, kaiwena toto nuwana wawaya ni lol iyaka i aliga.” ");
INSERT INTO mpx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Inoke Yosepa i lut, wawaya alona ge hinana i ahel ge hi sikal labi Isileli. ");
INSERT INTO mpx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yaa sauga i hago Akeleyas i tabwa kin labi Yudiya elana, tamana Helodi abana i milahe, inoke Yosepa i lovakun nok to labi o elana. Ana kenonou elana Yehoba i baek elana inoke i nok i na Galili ana labi elana, ");
INSERT INTO mpx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ge i na i miminaa panuwa Nasaleta. He i masal i ola to, inoke palopitau wali baaba i tabwa tunahot, hi ba, “Gamagalau nihi ba iya gagama Nasaleta.” ");
INSERT INTO mpx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saugena o Diyon Tobabitaiso i nem ge i papaatena labi Yudiya wali ula gamwanaa labi kekevana elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","I ba, “Wami pagan nanakina ana en nuku pek, kaiwena Yehoba wana abalogugui ana sauga i kelaubwa.” ");
INSERT INTO mpx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Diyon bana te palopita Aiseya i baunan sauga toto i ba: Gamagal etega to i yogayoga uleya labi kekevana elana, i ba, “Babala wana kamwasa ku lovivina-an, wana kela ku pasapu.” ");
INSERT INTO mpx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Diyon ana kaliko heiya kaliko toto kamel pupunona elana hi ginoliya ge henuwanina ana wasikewa bulumakau kunisina elana hi ginoliya. Aana heiya sagagai ge luvi toto uleya. ");
INSERT INTO mpx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Gamagalau hi nem elana hi neem Yelusalema, hi neem Yudiya labena gegewena, ge labi gegewena toto wewel Yolidani labenaa. ");
INSERT INTO mpx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wali gegi hi wasaan inoke i pababitaisol wewel Yolidani elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Boda Palisi ge boda Sadiusi hi gewi i kitel hi nenem tage ni pababitaisol, inoke i baek elal i ba, “Komiu ku ola mwata! Henala i baewa eliyamiu ge nuwamiu Yehoba wana lahi toto i nenem nuku louwi? ");
INSERT INTO mpx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ebo tunahot wami gegi iyaka ana en ku pek, he enona ni masal yawalimiu elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bahi nuku nuwatu tage nuku ba, ‘Ama tamama Abalahama, bosowaima ya te Yehoba wana lahi naha louwi.’ Na ba eliyamiu Yehoba i bosowaina pat ya ni ahel ge Abalahama tubunau ni ginolil. ");
INSERT INTO mpx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","He wana kenumu iyaka i lovivina-an ebwakil ewahililiya ni gotomwa ge nihi maguli. Ebwakil gegewel bolo enowaliya nige i wawaisi ni govel ge ni yoho tukagil ginaha elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nau ya pababitaisomiu wewel elana kaiwena wami pagan nanakina ana en iyaka ku pek. Yaa toto i nenem ewa, iya alana i bwata, nau alau nige i bwabwata. Nau nige no waisi i gagan ge tage bosowaiu aena ana os na kalivai. He iya abwe ni pababitaisomiu Yayaluwa Bwabwalena ge ginaha elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wana sobel iyoho i pihikan nimanaa, yaka i tetelipuna wana witi enona alona ge musana ni ase, inoke abwe enona hot ni bugulan ni teliya wana gonuwa, ge musana ni ton ginaha elana toto nige sauga etega ni bobolu.” ");
INSERT INTO mpx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Saugena o Yeisu i neem Galili i na wewel Yolidani, inoke i baek Diyon elana i ba, “Nu pababitaisowau.” ");
INSERT INTO mpx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yaa Diyon nuwana Yeisu wana nuwatu ni pil, yaka i ba, “Binimala owa te nu pababitaisowau. Ga i ola ge u nem elau?” ");
INSERT INTO mpx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Anana Yeisu i lahe i ba, “Sauga e ta ginol ni ola ga no nuwatu. Ebo ta ola o, nasi Yehoba wana nuwatu ta paolaolaek.” Inoke Diyon i talam. ");
INSERT INTO mpx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Diyon Yeisu i pababitaiso yaka Yeisu i gaihem wewela. Inoke sauga o labulabum i mwapwela ge Yehoba Yayaluwana i kite i ola bunibuni i laulau i nem elana. ");
INSERT INTO mpx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yaka anan etega i loem labulabumwa i ba, “Toto ya iya natu nunuwanina hot; ya yaliyaya nabiyan iya kaiwena.” ");
INSERT INTO mpx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Inoke Yayaluwa Bwabwalena Yeisu i nul i na uleya labi kekevana elana ge Seitani Yeisu ni labose. ");
INSERT INTO mpx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lan poti ge bulin poti Yeisu galebu i palahikan ge i awaawanun, inoke i galebu. ");
INSERT INTO mpx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yaka Seitani i nem elana ge i labose i ba, “Ebo tunahot owa Yehoba Natuna, u ba pat ya elal inoke nihi tabwa aanan.” ");
INSERT INTO mpx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Anana Yeisu i lahe i ba, “Buki Bwabwalena i ba, ‘Nige tage gamagal aanan awawana ni an ge yawalina ni gan, yaa baaba gegewena toto i neem Yehoba awanaa ni hago inoke yawalina ni gan.’” ");
INSERT INTO mpx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yaka Seitani Yeisu i nul hi na Yelusalema, awan bwabwalena, ge i patalmilil Limi Bwabwalena pwatanaa hot. ");
INSERT INTO mpx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Inoke i baek elana i ba, “Ebo tunahot owa Yehoba Natuna, u supeni lau, kaiwena Buki Bwabwalena i ba: Yehoba ni ba wana aneloseyau elal nihi matahikagiwa, nimaliya elana nihi pihikagiwa, inoke nige aem etega nu tutupaan pat elana.” ");
INSERT INTO mpx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Anana Yeisu i lahe i ba, “Buki Bwabwalena i ba al, ‘Bahi Yehoba wam Yabowaine nu lalabose.’” ");
INSERT INTO mpx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yaka Seitani Yeisu i nul al hi na oya mihahaina hot elana ge abalogugui gegewena panayawiya ge ana gogomwau i pankite. ");
INSERT INTO mpx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Inoke i ba, “Bugul gegewena o nasi na pewa elam, ebo nu loepwakoku ge nu kululu elau.” ");
INSERT INTO mpx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Anana Yeisu i lahe i ba, “Seitani, u egon hot eliyau! Kaiwena Buki Bwabwalena i ba, ‘Nu kululu Yehoba wam Yabowaine elana, iya maisena ya te nu tapwalolo elana.’” ");
INSERT INTO mpx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Inoke Seitani Yeisu i eguluwan ge aneloseyau hi nem ana labe hi pek. ");
INSERT INTO mpx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sauga Yeisu wasa i hago Diyon iyaka hi teli dela, inoke i sikal i na Galili. ");
INSERT INTO mpx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nige i miminaa Nasaleta, yaa i na i minaa Kapeniyama, awan etega Hoga Galili bebenaa, iyoho un Sebuloni ge un Napitalai wali labi elana. ");
INSERT INTO mpx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","He i masal i ola to, inoke palopita Aiseya wana baaba i tabwa tunahot, i ba: ");
INSERT INTO mpx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Un Sebuloni ge un Napitalai wali labi elana, labi toto hoga ana kamwasaa, labi toto wewel Yolidani labena leunati elana, ge Galili elana, bolo nige Yudiya i oola hi gewi hi miminaa: ");
INSERT INTO mpx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","gamagalau hi miminaa gogou elana inoke mwananal bwabwatana nihi kite, hi miminaa yaomal gogouina elana, inoke mwananal ni yana eliyalil. ");
INSERT INTO mpx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Inoke saugena o Yeisu wana papaatena i telipuna-an i ba, “Wami pagan nanakina ana en nuku pek, kaiwena Yehoba wana abalogugui ana sauga i kelaubwa.” ");
INSERT INTO mpx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeisu i nawanawa Hoga Galili bebenaa inoke tologi labui i kitel, alona ge talina, etega Saimon toto alana Pita ge etega Andulu. Wali vineya hi ahe ge hi logilogi hogaa. ");
INSERT INTO mpx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Inoke i baek elal i ba, “Ku nem ku toulilau, inoke na paatenamiu komiu nuku tabwa gamagalau ali tologi.” ");
INSERT INTO mpx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Etimwawa wali vineya hi eguluwan ge hi toulil. ");
INSERT INTO mpx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","I nawanawa al yaka gamagalau eluwa al i kitel, Yemesa Sebedi natuna alona ge talina Diyon. Avaliya ge tamaliya Sebedi hi miminaa wagaa, wali vineya hi lovilovivina. Inoke Yeisu i yogaagil, ");
INSERT INTO mpx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yaka etimwawa wali waga ge tamaliya hi eguluwagil ge hi toulil. ");
INSERT INTO mpx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeisu Galili ana labi gegewena i nopainan, inoke i panpankiti wali limi tapwalolowa, Yehoba wana abalogugui wasana waiwaisana i papaatena-an, ge gamagalau ali kasiyebwa ge ali gila tomaha ge tomaha i pwamolol. ");
INSERT INTO mpx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wasana hi palelu Siliya ana labi gegewena, inoke gamagalau ali kasiyebwa tomaha ge tomaha gegewena hi pwatanim elana, bolo hi youlolomwan, bolo yayaluwa bibikel hi ulutuk elal, bolo hi kikiuha ge bolo tuwaliya i elolol, inoke i pwamolol. ");
INSERT INTO mpx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Boda bwabwatana hi toulil, hi neem labi Galili, labi Dekapolis, Yelusalema, Yudiya ge labi toto wewel Yolidani labena leunati. ");
INSERT INTO mpx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yeisu boda i kitel inoke i na i ha oyaa ge i misiyo. Yaka wana tohago hi nogogo elana, ");
INSERT INTO mpx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","inoke awana i pwela i panpankiti elal i ba: ");
INSERT INTO mpx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Bolo hi atena yayaluwaliya i gulagula, Yehoba i muloluagil, kaiwena Yehoba wana abalogugui iyaka i minek elal. ");
INSERT INTO mpx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bolo hi kahin Yehoba i muloluagil, kaiwena ni payaliyaya-agil. ");
INSERT INTO mpx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bolo hi hanalau Yehoba i muloluagil, kaiwena wana bateli panuwana nihi pwawa. ");
INSERT INTO mpx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bolo hi galebu ge hi walem pagan sasapona kaiwena, Yehoba i muloluagil, kaiwena yayaluwaliya ni pakalaopop. ");
INSERT INTO mpx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bolo avaliyau hi atilomwan-agil Yehoba i muloluagil, kaiwena i atilomwan-agil. ");
INSERT INTO mpx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bolo nige ateliya i bibiki Yehoba i muloluagil, kaiwena Yehoba nihi kite. ");
INSERT INTO mpx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bolo huga ana topabakuhu Yehoba i muloluagil, kaiwena ni ba, “Heliya natuwau.” ");
INSERT INTO mpx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bolo hi palomwanagil kaiwena Yehoba awana hi ab, Yehoba i muloluagil, kaiwena Yehoba wana abalogugui iyaka i minek elal. ");
INSERT INTO mpx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ebo gamagalau hi kitemiu ku toulilau inoke hi ba sigasiga-agimiu, hi palomwanagimiu ge wasamiu hi wasa panapanak-an, ebo hi ginol ola o, Yehoba i muloluagimiu. ");
INSERT INTO mpx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nuku yaliyaya hot, kaiwena molamiu bwabwatana iyoho labulabumwa. He palopitau houhouwel hi palomwanagil i ola ya to. ");
INSERT INTO mpx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Komiu wami tuwalali panayawi gamwanaa i ola hoga wana tuwalali. Yaa ebo hoga ana gasisi ge amnana ni so, nige bosowaina ta pahogahoga al. Nige al wana tuwalali i gagan, inoke ta aliyoho ge gamagalau nihi poti. ");
INSERT INTO mpx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Komiu ku ola mwananal panayawi gamwanaa. Ebo panuwa etega nihi ginol oya pwatanaa, nasi gamagalau gegewel nihi kite. ");
INSERT INTO mpx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nige sauga etega gamagal odam ni toton yaka ulun ni aahe ni popom lowan. Nasi ni teliya teibol pwatanaa, inoke mwananal ni pek halan o ana tomina gegewel elal. ");
INSERT INTO mpx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Komiu wami mwananal ni yana gamagalau elal ni ola al to, inoke wami ginol waiwaisana nihi kite ge Tamamiu labulabumwa alana nihi tobalan. ");
INSERT INTO mpx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Bahi nuku nuwatu tage ya nem Mosese wana Logugui ge palopitau wali panpankiti na leke yoho. Nige ya nenem tage na lekel yohil, ya nem na patunahotil. ");
INSERT INTO mpx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ya ba tunahot eliyamiu, ana siga labulabum ge panayawi nihi mowasi, nige Logugui ana baaba kekeisi etega ni yayaomal ana siga gegewena ni tabwa tunahot. ");
INSERT INTO mpx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Henala ebo logugui kekeisi etega nige ni hehenapu-an ge gamagalau enuna al ni pankitel nihi ginol ola, he alana ni kekeisi Yehoba wana abalogugui elana. Yaa henala logugui ni henapuan ge gamagalau ni pankitel, he alana ni bwaya Yehoba wana abalogugui elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Palisi ge Logugui ana topankite hi ba tage heliya wali pagan i sapu, yaa na baewa eliyamiu, ebo nige wami pagan heliya wali pagan ni wawaisi lake, he nige bosowaimiu nuku ulutuk Yehoba wana abalogugui elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iyaka ku hago Mosese wana logugui gamagalau houhouwel elal i ola hiwe, “Bahi taulol. Henala ebo ni taulol nasi lahi ni pwawa.” ");
INSERT INTO mpx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yaa nau ya ba eliyamiu, henala ebo ni huga talina elana nasi lahi ni pwawa, henala ebo talina ana ba ni apapanak-an nasi nihi pakot, ge henala ebo ni ba, “Kokona owa!” i bosowaina ni na ginaha ni pwawa Gehena. ");
INSERT INTO mpx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Inoke ebo nu nem limi bwabwalena elana tage wam mulolu u pepek Yehoba elana ge abwe nu nuwatu talim i hugaagiwa bugul etega kaiwena, ");
INSERT INTO mpx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","he wam mulolu nu teli limi bwabwalena elana nu na ga alom ge talim maninimiu nuku abubun. Yaka abwe nu sikalim ge wam mulolu nu pek Yehoba elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ebo gamagal etega ni wolewa ge ni ahewa nuku na nu kot, he etimwawa alom woliwoli o nuku pasapu ga kamwasaa mulaa abwe nuku vin abakot elana. Ebo nigeya, nasi ni telewa toyatala elana, inoke toyatala ni telewa pulisiman nimaliyaa ge nihi telewa dela. ");
INSERT INTO mpx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ya ba tunahot elam, nige bosowaina nu tagil ana siga am vaga gegewena nu leke haba. ");
INSERT INTO mpx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iyaka ku hago Mosese wana logugui i ola hiwe, “Bahi alom lagona nu loloneganega-an.” ");
INSERT INTO mpx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yaa nau ya ba eliyamiu, henala ebo yova etega ni gagayawa-an ge nuwana alona nihi kenu, iya iyaka i loneganega-an nuwatu elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ebo matam toto labi awomwa ni pagegewa, nu bwana yoho. I waisi te ebo nige tuwam gabomwina etega ni gagan, bahi tuwam bwalibwaligena nihi aaliyoho Gehena elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","I ola al, ebo nimwam toto awom ni pagegewa, nu gotomwa yoho. I waisi te ebo nige tuwam gabomwina etega ni gagan, bahi tuwam bwalibwaligena nihi aaliyoho Gehena elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mosese wana logugui i ba i ola hiwe, “Henala ebo nuwana lagona ni towani, houwan ga wana towa wasana ni leli lowan inoke ni pek yova elana.” ");
INSERT INTO mpx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yaa nau ya ba eliyamiu, ebo tau etega bwagana lagona nige i gaganawal ni towani, ge abwe yova o ni alolon al, he tau wana gegi kaiwena inoke yova o i tabwa toganawal. I ola al, tau toto yova eguluwan o ni alolonan, he iya i ganawal. ");
INSERT INTO mpx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iyaka ku hago al Mosese wana logugui gamagalau houhouwel elal i ola hiwe, “Bahi wam papasila nu leleke, yaa nu ginol ni ola wam bateli Yehoba elana.” ");
INSERT INTO mpx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yaa nau ya ba eliyamiu, bahi sauga etega nu papasila. Bahi nu ba, “O sila labulabum,” kaiwena Yehoba wana abamina to. ");
INSERT INTO mpx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bahi nu ba “O sila panayawi,” kaiwena aena ana abateli te. Bahi nu ba, “O sila Yelusalema,” kaiwena Kin bwabwatana wana panuwa to. ");
INSERT INTO mpx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bahi nu papasila kokowam elana, kaiwena nige bosowaina nu ba ge kokowam pupunona etega ni yanayana o ebo nu ba ge etega ni biki. ");
INSERT INTO mpx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iyai ya te nu ba, “E” o ebo “Nigeya”. Hauna gun al nu lumen i neem Seitani elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iyaka ku hago Mosese wana logugui i ola hiwe, “Ebo gamagal etega, alona matana maisena ni apanak, lahena iya al matana maisena nihi apanak. Ebo alona ninina maisena ni tagagebal, lahena iya al ninina maisena nihi tagagebal.” ");
INSERT INTO mpx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yaa nau ya ba eliyamiu, ebo gamagal etega ni ginol panak elam, bahi nu lalahe. Ebo gamagal etega gegenam toto awomwa ni taganepal, he nu tagena pil gegenam toto gegebamwa nu pek ni taganepal al. ");
INSERT INTO mpx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","I ola al, ebo gamagal etega ni telewa kot elana ge tage am holahola ni ahe, inoke am kaliko babalona toto tultul kaiwena nu talamwan al elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ebo tolohaveyan etega am logugui ni ginol tage ana kaval nu kalivai hawawal kekeisi ni yapu, he nu kalivai hawawal yayapona elana. ");
INSERT INTO mpx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ebo gamagal etega ni awanun elam, nu pek elana; ebo gamagal etega wam bugul ni patalam, bahi nu kakaise. ");
INSERT INTO mpx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iyaka ku hago tage Mosese wana logugui i ba, “Wam heliyamwau nu nunuwana-agil, am topihigelgel nu hugaagil.” ");
INSERT INTO mpx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yaa nau ya ba eliyamiu, ami topihigelgel nuku nunuwana-agil ge bolo hi palomwanagimiu nuku awanun kaiweliya, ");
INSERT INTO mpx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","inoke nuku ola Tamamiu labulabumwa natunau. Kaiwena i ba sabwelu ni ha ge ni yana gamagalau nanakil ge gamagalau waiwaisal elal, ge kehe i patuna bolo wali pagan i sapu ge bolo wali pagan nige i sasapu elal. ");
INSERT INTO mpx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ebo bolo hi nunuwana-agimiu ya te nuku nunuwana-agil, ga i ola ge Yehoba ni pwamolamiu? Takis ana toahi hi giginol i oola al to, bwagana heliya nige gamagalau waiwaisal i oola. ");
INSERT INTO mpx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ebo talimiyau ya te nuku ba mulolu elal, nige i gegetoga toto gamagalau gegewel hi giginol. Bolo nige toabulilek i oola, hi giginol i oola al to. ");
INSERT INTO mpx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Inoke komiu wami pagan bwalibwaligena ni waisi ni ola Tamamiu labulabumwa wana pagan bwalibwaligena i waisi. ");
INSERT INTO mpx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Sauga ebo ginol waiwaisana etega nuku ginol, bahi nuku giginola gamagalau mataliyaa ge tage ginol waiwaisana o nihi kite. Ebo nuku ola o, he Tamamiu labulabumwa nige ni pwapwamolamiu. ");
INSERT INTO mpx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Inoke sauga ebo bugul etega nu pek togulagula elal, bahi nu yoyoga pwapwati ni oola tokakakawi wali pagan. Heliya hi giginol ola limi tapwalolowa ge kamwasaa, kaiwena nuwaliya gamagalau nihi tobalagil. Ya ba tunahot eliyamiu, molaliya gegewena iyaka hi ahe haba. ");
INSERT INTO mpx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yaa ebo bugul etega nu pek togulagula elal, bahi nimwam toto gegebam ni aatena nimwam toto awomwa ga i ginol ola. ");
INSERT INTO mpx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nu ginol sume ya. Tamwam bugul gegewena toto u ginol sume i kite, inoke iya molam ni pewa. ");
INSERT INTO mpx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sauga ebo nuku awanun, bahi nuku oola tokakakawi. Heliya nuwaliya nihi talmilil ge nihi awanun limi tapwalolowa ge kamwasa lala elana, kaiwena nuwaliya gamagalau nihi kitel. Ya ba tunahot eliyamiu, molaliya gegewena iyaka hi ahe haba. ");
INSERT INTO mpx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sauga ebo nu awanun, nu ulutuk lumwa, nog nu kaus inoke nu awanun Tamwam elana, iya nige ta kikite. Tamwam bugul gegewena toto u ginol sume i kite, inoke iya molam ni pewa. ");
INSERT INTO mpx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sauga ebo nuku awanun, bahi baaba bwagabwaga nuku babaa pipili ni oola bolo nige toabulilek i oola. Heliya hi nuwatu tage Yabowaine wali awanun ni hago kaiwena wali awanun i yapu. ");
INSERT INTO mpx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bahi nuku oola heliya. Nigeya ga nuku aawanun Tamamiu elana, he iyaka i atena hauna nuwamiu. ");
INSERT INTO mpx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Inoke nuku awanun ni ola hiwe: Tamama labulabumwa, alam bwabwalena ama gamagal naha awatauwan, ");
INSERT INTO mpx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","wam logugui ni nem, wam nuwatu gamagal naha ginol panayawiya ni ola hi giginol labulabumwa. ");
INSERT INTO mpx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Lan ya enona nu pem eliyama. ");
INSERT INTO mpx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wama gegi nu nuwayoho, ni ola alomeyau wali gegi iyaka ha nuwayoho. ");
INSERT INTO mpx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bahi nu tetelema lawakik elana, yaa nu pwamwalima gegi elana. Kaiwena owa tologugui, owa togasisi ge owa towasawasa, sauga gegewena nige ni momowasi. Ibwe. I ola. ");
INSERT INTO mpx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ebo alomiyau wali gegi eliyamiu nuku nuwayoho, inoke Tamamiu labulabumwa wami gegi ni nuwayoho al. ");
INSERT INTO mpx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yaa ebo alomiyau wali gegi nige nuku nunuwayoho, Tamamiu wami gegi nige ni nunuwayoho. ");
INSERT INTO mpx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sauga ebo galebu nuku palahikan awanun kaiwena, bahi ami awa nuku papanuwaleyan ni oola tokakakawi. Heliya ali awa hi panuwaleyan kaiwena nuwaliya gamagalau gegewel nihi kitel galebu hi palahikan. Ya ba tunahot eliyamiu, molaliya gegewena iyaka hi ahe haba. ");
INSERT INTO mpx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sauga ebo galebu nu palahikan awanun kaiwena, maninim nu ul ge kokowam nu paenonu, ");
INSERT INTO mpx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","inoke bahi gamagalau nihi aatena te galebu u palahikan. Tamwam toto nige ta kikite, iya ya te ni atena. Tamwam bugul gegewena toto u ginol sume i kite, inoke iya molam ni pewa. ");
INSERT INTO mpx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Bahi gogomwau nuku pwapwahin kaiwemiu panayawiya, kaiwena panayawiya wala bugul mwatamwata ge pwaha hi apanak, ge tokaoma hi ulutuk ge hi kaoma. ");
INSERT INTO mpx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gogomwau nuku pwahin kaiwemiu labulabumwa, kaiwena labulabumwa mwatamwata ge pwaha nige bosowaina bugul nihi apanak, ge tokaoma nige bosowailiya nihi ulutuk ge nihi kaoma. ");
INSERT INTO mpx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hauna labi wam gogomwau nihi minaa, nasi yayaluwam ni minaa al to. ");
INSERT INTO mpx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matala i ola tuwala ana odam. Ebo matam ni waisi, nasi mwananal tuwam bwalib