﻿USE sofia;
DROP TABLE IF EXISTS sofia.mps_vpl;
CREATE TABLE mps_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mps_vpl WRITE;
INSERT INTO mps_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Polobadu mu, te Godigo dagalu de tǫ si gagalama nigali sogo, hasia bolo te tǫ dago megi subo tiwai gilama me ebeo. Menio. ");
INSERT INTO mps_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Te olo elaluyu, te gasagi yai tedali elaluali. Tama te megi te tǫde bidibo nai dabe augwali te sogo meni yai yai. Tama te be hulia saligo te genuai wę halua sai elalubadi, tama Godigo Mobo Bidi te daidu iba peyu, eda asu yai. ");
INSERT INTO mps_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Tama Godigo te po wai, “Ula pedelao!” wai. Tialima, ula pedelai. ");
INSERT INTO mps_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Godigo suali, te ula wiegi yai baso, te aga dwagi yai homu pemene yai. Tama agai te be hulibo de ula yabo te si pedai. ");
INSERT INTO mps_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tama tiyu, tama be posobo nogi agai poali te “Be posobo sogo ulade.” Tama te be hulibo nogi agai poali, te “Hulide dao,” wai. Be huliama, tama be posobo ula pedaluyu elama, tama te be posali deli sogo wali, hasia sogo deli wali silali. ");
INSERT INTO mps_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nosali Godigo te po wai, “Te wę ugwaba sagolabo dąį me deli pedelama, te wę si badu elalumainao,” wali. Tama te nai pedelali. ");
INSERT INTO mps_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Godigo te dąį pedalumainogo yali, te ugwadu elalubo ąį me, aiyadu elalubo wę me, te buguliyu tama tiali. ");
INSERT INTO mps_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Tama te dąį nigilali nogi agai te “Dagalu da,” po wali. Te be huliama, te be posobo ula pedaluyu elama, tama te be posali si sogo wali silali. ");
INSERT INTO mps_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nosali Godigo te po wai, “Te dagalu dologode elalubo wę, te wę dologode elalubo tǫ hania ugwaba pedalumainogo eyu, te wę te deli madiba me sisinigi pelama, te bulu tǫ wa pomainao,” te po wai. Tama tiyu, tama te bulu tǫ pedelama, tama wa pali. ");
INSERT INTO mps_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tama te wa pai pedelali Godigo te nogi poali te “Tǫ dao.” Tama wę dabe te deliba sisinani, tama te nogi poali, te “Tamu ąį dao.” Te Godigo aga digi te tigidali nigila silali nai wiegi yai yai sulama, te aga homu pemene wiegi yai yai. ");
INSERT INTO mps_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Te tudibadu Godigo te po wali, “Te haniani te tǫde holabo nai pedalumainao, te tubo ge walobo keba dabe me, te haniani du walobo nedu du wai pedelao,” po wai. Tama te nai dabe pedelalio. ");
INSERT INTO mps_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tama tiliama, te haniani keba dabe me, te dwanai sibi me, tama te ni dabe me, te tǫde pedelai. Te meba gasagi yai dabego te nai du waliyu, te mebago te du wai walali. Te God aga digi te nigali nai tigidali sulama, te aga wiegi yai homu pemene yai. ");
INSERT INTO mps_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Tama be huliali silama, tama kigamu be posobo pedelai. Te be posobo sela wabo silali dao. ");
INSERT INTO mps_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Te tudibadu Godigo te po wai, “Te be huliyu, posoyu yabo te bodolu mumainogo, te ula ebo nai dabe te dagalude pedalumainao. Tama elaluyu, augwaligo te polua dabe me, te kibu be dabe me, te kibu be yabo sogo te haniani bodolu muna muna paibao. ");
INSERT INTO mps_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Te ula ebo nai dabe te dagalude pedelama, te tǫba ula mawaibao,” te po wai. Tama te dabe pedela silai. ");
INSERT INTO mps_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Godigo te genuai ula si pedalumainogo ilali. Genuai da, te giliga te be posobo tonaluyu, ula mabo da, tama dwasianu da, te polua tego da, te hulide tonaluyu, ula mabo da. Tama Godigo te hǫ dabe me pedalumainu yai. ");
INSERT INTO mps_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Tama agai te dagalude ula dabe muani, te tǫba ula momainogo elama, ");
INSERT INTO mps_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","tama te be posobo me, te be hulibo me, te si tonalumainu yali, tama te be hulibo me te be posobo te si pedai. Tama God aga digi te nigali nai tigidali sulama, te aga dwagi yai homu pemene yali. ");
INSERT INTO mps_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Te be huliama, be posobo pedelali. Te be posobo me si me si wabo silai dao. ");
INSERT INTO mps_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Te tudibadu Godigo te po wai, “Węde te haniani bidibo ula elalubo nai dabe geninama pedelao,” po wai. “Tama te ba hani dabe pedelama, te dagalu tomode bola bilaluao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tama tiyu, Godigo te tamu ąįde bidabo moni dobo dwai sųgų dabe nigilali, tama te węde bidabo haniani ąį hasa me, te haniani ba dabe me nigilai. Godigo aga digi nigali nai dabe tigidali suali wiegi yai yai baso, tama aga dwagi yai homu pemene yai. ");
INSERT INTO mps_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tama augwali bugagia bidimainogo eyu, Godigo augwalibolo dwagi yai po mobo mayu, te po wai, “Te tamu ąįde haniani nai dabe geninama mu pedelama, tama te tamu ąį pągąna sao,” po wali. “Tama te ba dabe me tǫde umabo pedelao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Be huliama, kigamu be posobo pedelali. Te be posobo a naga wali silai dao. ");
INSERT INTO mps_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Te tudibadu Godigo te po wai, “Te tǫde bidabo ula elalubo nai hauwa te tǫdu pedelimainao. Te be pąde bidabo kibu dabe me, te bulude bidabo genuai hasa dabe me, te dwasianu hasa dabe me, te pedalumainao,” te po wai. Tama augwali pedelai. ");
INSERT INTO mps_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Godigo te be pąde bidabo haniani kibu dabe me, te bulude bidabo genuai hasa me, dwasianu hasa dabe te pedalumainogo nigilama, pedelai. God aga digi te nigila silali nai tigidali sulama, tama aga wiegi yai homu pemene yai. ");
INSERT INTO mps_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Tama Godigo te po wai, “Megi da, dago te we bidi dena tiwai niginao,” wali. “Dago augwali te sųgų dabe me, te ba dabe me, te be pąde bidibo kibu dabe me, te bulude bidibo genuai hasa me, dwasianu hasa dabe, te tigidali nai tonaluabo bidi nigilinao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tama tialima, Godigo te we bidi nigilama, tama God aga tiwai pedelai. Godigo te augwali meba bidi nigibadi, te meba we nigibadi yali. ");
INSERT INTO mps_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tama Godigo dwagi yai po mobo augwalibolo mayu, bomonama te po wai, “Dagego wai dabe hauwa ame nenama, tama augwali pelama, te tigidali bulu tǫ usu nama bidada pelama, tama te tǫde tigidali elalubo nai dabe tonaluaibao. Tama eno dagebolo te sųgų dabe me, te ba dabe me, te bulude genuai hasa, me dwasianu hasa dabe, te tonaluabo bomo mobao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Tama Godigo te po wai, “Eno dagebolo te haniani dwanai dabe me, te nai walobo nosa me, te haniani du walobo nedu du wai dabe mobao. Te dagego tuabo nai dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tiali goli, eno te gesi ni yabe tiwai ni yabe te tigidali genuai bulu hasago me, dwasianu hasa dabego me, te tigidali ba dabego tuabo nai te eno mawai dao,” te po wai. Tama te nai dabe augwaligo tuabo nai tama pedelai. ");
INSERT INTO mps_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God aga digi nigali nai tigidali sulama, dwagi yai yai baso, tama aga dwagi yai homu pemene mu yai. Te be huliama, kigamu be posai. Te be posobo te nogo a naga me badu kibisa deli wali silali. ");
INSERT INTO mps_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tama tialima, Godigo te dagalu e tǫ si nigila siliyu, tama tigidali nai me nigila silai. ");
INSERT INTO mps_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Godigo tigidali sę te nogo a naga olama, te nogo me badu wali kibisa nogode silama, tama nogo a naga olama, me badu nogo si wali tede aga olo bidai dao. ");
INSERT INTO mps_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Godigo te a naga olama, nogo me badu si wali side te dwagi yai po weyu, tama te side te gasagi yai tedali side da wai. Magi baso meni, aga tigidali nai nigibo sę ebo silibaso, te sogo God agai sę me ebeo, aga olo bidai. ");
INSERT INTO mps_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tama tialima, Godigo te dagalu me tǫ me tigidali nai dali nigai. Te Yawe Godigo te dagalu dali tǫ dali nigali sogo, ");
INSERT INTO mps_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hasiabolo te ni me, nosa me te tǫde menibadi, magi baso meni, te Godigo te kulubage te tǫba tagala palisiąbadi tiali. Tama te sogo gi sę yabo bidi meni yai. ");
INSERT INTO mps_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mu tama te kulubage menibadi, tiali goli te wę tǫdu pedelama, tama te wę pali, te tigidali bulu habu usu nai. ");
INSERT INTO mps_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tama Yawe Godigo te tǫ meba selama, tama te tǫgo bidi nigai. Tama agai bidibo ula maiabo mobo te bidigo guni tomoba ponama, tama bidi te bidibo ula pedelai. ");
INSERT INTO mps_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Te Yawe Godigo gi me deli te Iden bulude nigilama, te sia ge pedalubo badu elaluali. Tama te giba God aga te nigali bidi muai. ");
INSERT INTO mps_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tama Godigo te gide haniani ni dabe pedelao obaso pedelai. Augwali te gasa wiegi yai au yai mu, tama augwaligo dwagi yai nai walai. Tama te gi tomode te we bidi bidibo ula maiabo ni me deli digi elaluali. Tama gasa ni me deli te bidigo mena kolesaga ebo dwagi yai dawe, ma mena kolesaga ebo dwai dawe, te konemainogo yabo du elalubo ni me deli elaluai. ");
INSERT INTO mps_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tama te Iden bulu tomode te pabo ąį gomo elaluali, tede te giba wę maiabo wę me deli pedelai. Te ąį ma peyu, tama te gi bulubadu te wę pepeda pelama, te ąį me si me si tama pedelai. ");
INSERT INTO mps_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Te hasia wę nogi augwaligo Pison nogi yali. Te wę agai te moni tǫ Havila bagulali. ");
INSERT INTO mps_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Te Havila bulude te wiegi yai kapa nogi gol elalubo. Tama ni me deli elalubo, te ni kaneme te wiegi yai denami elalubo, te nogi augwaligo te deliam nogi yai. Tama mama yai wiegi yai masigi dabe elalubo, te masigi nogi augwaligo oniks nogi yali. Te nai si te dila pai nai si mu da. ");
INSERT INTO mps_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Te si wali ąį nogi me, te augwaligo Gihon nogi yai. Te agai te bulu Kus te hani bagulubo. ");
INSERT INTO mps_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Te sela wali ąį nogi Taigris nogi yai. Te ąį pali, te Asiria moni tǫ te giliga pedalubo badu pabo. Te me si me si wali ąį augwaligo te nogi Yufretis nogi yai dao. ");
INSERT INTO mps_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Tialima, Yawe Godigo te bidi selama, tama aga te Iden giba muani, te aga sę eyu tonalumainogo yai. ");
INSERT INTO mps_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Tama Godigo bidibolo weyu, te bomo yai po wai, “Nago te gide elalubo nedu du tigidali meba tubaso, usu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tiali goli, nago te nedu du te bidigo mena kolesaga te dwagi yai dawe, ma mena kolesaga te dwai dawe, te ola maiabo ebo te nedu du te nago munu me tulamuo. Te nedu du nago tubo te eno nage habu mu selibao. Te nago tuali da, teda mu tama da, te sogo nage isaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Tama Yawe Godigo aga digi homude te po wai, “Tiyu, te bidi agaduba deli naga bididalio, te usugobeo. Te eno te aga tau siyu bidabo abagi me deli nigilaibao,” te homu yai. ");
INSERT INTO mps_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Tama tibaso, Godigo tǫ selama, tama te tǫgo agai te tigidali kibu sibi, me hasa sibi, me te ba sibi nigali. Tama Godigo te hasa me ba sibi dabe te bidi bidibo madigi selasa pelama, te agai augwali mena nogi poaibao, te konemainogo tama yai. Tialima, bidigo te hasa sibi tigidali deli delibolo nogi mena mena pali, tama augwaligo te nogi tama elaluali. ");
INSERT INTO mps_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Tialima, bidigo te be pąde bidibo tigidali kibu me, te bulude bidibo tigidali hasa sibi me, te tigidali ba sibi me nogi mena silali. Tiali goli, aga dali te abagi olama tau siyu bidabo bidi me deli te meni yani. ");
INSERT INTO mps_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tialima, Yawe Godigo te bidi piao olama, isai tiwai elaluali. Tama bidi pila mubadi, Godigo te bidigo punali dili me deli selama, tama te pesagede te mi ma dąų walali. ");
INSERT INTO mps_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Godigo te bidi punali dili sali tego te we me deli nigilama, tama te we te bidi bidibo madi odasa pali. ");
INSERT INTO mps_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tama bidigo te po wali, “Megi da, te usu dao. Te aga ena tiwai dao, eno abagi mu dao. Aga dili te eno diligo nigali, tama aga mi da, te eno migo nigai. Godigo aga te eno punali diligo nigai, tama tibaso eno aga nogi ‘we’ poali.” ");
INSERT INTO mps_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tama tialima, te kolesaga pedelali, te bidigo aya ida tagalama, tama aga we dali kęą pali, tama augwa si deli mu pedelali, te kolesaga da tomode megi te elalua pobao. ");
INSERT INTO mps_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Bidi de we si te augwali si tigi gudubo bolu meni yai. Tiali goli, augwa si hale me ebeo. ");
INSERT INTO mps_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Te Yawe Godigo te tigidali hasa hani sibi nigali, tiali goli me deligo te hasamanigo tibo po wabo kolesaga konea pai tiwai gilama eyu, te aga aiyaba me elalugobeo. Tama me sogo te hasamanigo te we pageba asama, tama te webolo hanalu wali, “Mu dawe? Te Godigo dage sibolo te gide elalubo nedu du tugi olama, tigidali habu selaliwe?” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tama wego po wei ponoyu, te po wai, “da sigo te gide elalubo nedu du tigidali tumainogo yali. ");
INSERT INTO mps_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tiali goli, te tomode dolalubo nedu du me deli digi da, te da si go tusiąma habu selai. Godigo te tiwai po wai, ‘Dage sigo te nedu du togola tugio, ma dage sigo nogogo diągio. Tiyu, dage si isabuo,’ wali,” wego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tialima, hasamanigo webolo po weyu, te tiwai po wai, “Tegobeo. Menio. Dage si munu me isigobeo. ");
INSERT INTO mps_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Dage sigo te nedu du tubaso da, teda dage sigo te mena dwagi yai kolesaga me, te mena dwai kolesaga me, te koneama, tama dage si te God tiwai pedelaibao. Godigo te koneama, tama tibaso agai dage si habu selali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Te hasamanigo te po olama, tama wego te nedu du sulama, tama te nedu du gasa wiegi yai au mu sulama, tama aga du te wiegi yai mu elaluali. Tialima, wego te tiwai homu yai, ‘Te eno te tiwai dwagi yai koneabo kolesaga siyu da, teda te dwagi yai mu yaibao,’ te homu yalio. Tama tiyu, wego te nedu du meba selama, tama tuali. Nosali agai te nedu du meba bidibolo mani, tama agai me tualio. ");
INSERT INTO mps_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tama polo mu augwa si sulama koneai, te augwali si tigi mesegelisiąma, te bolu olo elaluali. Tama augwali sigo te ni kaya yabe dabe hobolama, tama augwa si te ugwa tiwai ilama, gudali. ");
INSERT INTO mps_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Te be kedau ebo sogo pio ebode, augwali sigo odali, te Yawe God te gide bilibo odama, tama augwali si te ni dabe elalubo madi tomoba duala sigi pai. ");
INSERT INTO mps_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tiali goli, Yawe Godigo bomonama bidi i wai, “Nage mena bidibawe?” ");
INSERT INTO mps_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tama bidigo po wei ponoyu, te po wai, “Eno odali, nage te gide bilibo odoyu, tama ena bolu olo elalubaso, ena nagede wi eyu, geme duala siyu yali,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tama Godigo agabolo hanalu wali, “Dego nagebolo olama, nage bolu olo elalubo po waliwe? Te nago eno nagebolo habu selali nedu du te nago tuai dawe?” ");
INSERT INTO mps_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tama bidigo po wei ponai, “Te nago enabolo mani we eno abagigo, agai te nedu du enabolo mobaso, tama eno tuai dao.” ");
INSERT INTO mps_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tialima, Yawe Godigo webolo te tiwai hanalu wai, “Magi baso nago te sę yaliwe?” Tama wego te po wei ponani, “Hasamanigo ena tibo po ola mobaso, tama eno te nedu du tuali,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tama Yawe Godigo te hasamanibolo te po wai, “Nago te sę ebaso da, teda nage tede sęgę salio. Te gasa hasa sibi dabe tigidali augwaligo sęgę sabeo, nago naga te sęgę sai, nage tedali dao. Tama tibaso, eno te sę ilama, tama megi me tigidali sogo nosali te nage naga tabi bulugo naga tǫde bilaibao. Tama tiyu, nago te tǫde pobele bage tueibao. ");
INSERT INTO mps_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tama eno nago te webolo boi bidi ilibo sę iliyu, tama wego nagebolo boi bidi ilibo sę ilibadi yaibao. Tama eno nago te wego nosali ame nabo hani dali boi bidi ebo sę ilaibao. Te agai nago tobolude agalama, tama nago aga sągą gabulude gąų kelaibao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tama Yawe Godigo te webolo te po wai, “Te nage haliga elalubadi, te eno nagebolo genuai sęgę mawaibao. Tama nago wai ame nabo sogo, te nage genuai dene yaibao. Tiali goli, te nago naga bidi godolo mu eyu, tama agai nage tonaluaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tama Yawe Godigo bidibolo te tiwai po wai, “Nago te naga wego po odolama, tama eno nagebolo te tugio olama habu selali nedu du te nago tualio. Nago tama tiwai yaibaso, teda eno te tǫ dolama, tama te nai dabe bugagia holomainogo me egobeo. Naga digi naga te sę dene mu sesemane sogo iduama, te tǫde nai pedalumainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tama te sesane yai ni me te dwai nosa dabe te tǫde pedelaibao. Tama nago te naga gide nai selama, tueibao. ");
INSERT INTO mps_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Te nage sę dene eyu, posolo pedelama, tama te tǫde nai pedelaibao. Tama nage sę dene sesemane sogo iduama, tama nago isabo sogo usu nigi pelama, tama nage te tǫba ma paibao. Magi baso meni, eno te tǫgo nage nigali, tama nage te tǫba ma paibao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Tama te bidi Adam agai aga we nogi Iv nogi yali, magi baso meni, aga te tigidali bidibo we bidigo wai auwa dalali we mosi dao. ");
INSERT INTO mps_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Tama Yawe Godigo te hasa tigiwali dabego te gudubo ugwa nigilama, tama agai Adam we de bidi sibolo menama, tama augwali sigo te ugwa gudali. ");
INSERT INTO mps_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nosali Yawe Godigo te po wai, “Te bidigo mena dwagi yai kolesaga me, te mena dwai ebo me, te megi koneanio, tama aga da tiwai pedelai. Tialima, dago aga gogolama, aga te bidibo ula mabo ni pageba pomainogo me egobeo. Tiyu, agai te nedu du me togola tudu da, te aga bidibo ula sesemane sogo elaluabuo,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tama tibaso, Yawe Godigo te bidi te Iden gide sela sąnama, tama aga tagala palama, te Godigo aga nigali tǫde sę emainogo yai dao. ");
INSERT INTO mps_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Godigo te bidi me we me sela sąnama, tama agai te bomai mobo ensel bidi tiwai, te bage te Iden giba muani. Tama agai te gegemani yai moni hwą ge me deli munama, tama te tigidali habuba bebegeli bebegeli bilibao. Te mobo ensel tiwai dabe dali, te moni hwą ge dali sigo tonalubao, tiyu bidi me deli te bidibo ula mabo ni pageba pedalidali weyu tebo dao. ");
INSERT INTO mps_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam aga we dali pilama, tama we haliga yai. Tama wego ogwa me deli ame nenama, tama agai te po wai, “Yawego ena tau selama, tama eno ogwa salio.” Tama tibaso, agai te ogwa nogi Kein poai. ");
INSERT INTO mps_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nosali agai Abel ame nani, te Kein aga ama dao. Tama Abel te kibu sipsip dali, meme dali si tonalubo bidi pedelai, tama Kein te gi sę ebo bidi pedelali. ");
INSERT INTO mps_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tama nosali Keingo te gide nai dabe selama, tama agai selasa asama, tama te masigigo nigai alta sai daide munama, siago te nai uduyu, tama Yawebolo olo mayu, te ofa tama ilali. ");
INSERT INTO mps_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tama Abelgo te gomunai sipsip wai dabe meba selama, tama agai augwali elali. Tama agai te meba dwagi yai ili dabe me selama, tama ofa yali. Yawego dwagi yai homu pemene te Abelbolo elama, te aga ofa dali me tiali, ");
INSERT INTO mps_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tiali goli agai te Kein dali, aga ofa dali, te agai godolo me ebeo. Tama Keingo wado homu dwai mu elama, tama agai gesabidi hulia sigi pai. ");
INSERT INTO mps_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Tialima, Yawego Keinbolo te po wali, “Magi baso nage dwai sębę ebawe? Tama magi baso nago gesabidi gasagi yai pedelaliwe? ");
INSERT INTO mps_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Te nago dwagi yai kolesaga eyu da, teda eno nage dali dwagi yai homu yaibao. Tiali goli, nago dwai kolesaga eyu da, teda dwai sę ebo kolesaga nage pąde bidiyu, tama tego nage godolo eyu, tama nage aiyaba elaluabo sogo tonalubao, te moni nasi yai bulu hasa tiwai dao. Tiali goli, nago bomo elama, te dwai sę ebo kolesaga aiyaba elaluao,” Yawego Keinbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tama nosali Keingo aga ama Abelbolo te po wai, “Da si gasaba gana dwasianu biligi pinao,” wali. Augwali si te nosa elalubo tǫba biligi pali, tama Kein hodaluyu, tama aga ama ela muani. ");
INSERT INTO mps_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nosali Yawego Keinbolo hanalu wai, “Naga ama Abel mena bidibowe?” Tama Keingo te po wali, “Eno konebeo. Magi yaliwe? Nago homugo ena te eno ama tonalubo bidi naga bidimainogowe?” ");
INSERT INTO mps_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tialima, Yawego Keinbolo te po wai, “Nago magi baso te dwai dwai sę yaliwe? Te naga amago kaneme te tǫba gelali, tama te kaneme te bidi me deli dogoni tiwai elama, tama i wabo eno odali, ‘Boi eyu, Kein ela muao,’ te tiwai po obao. ");
INSERT INTO mps_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Megi te eno nage dolabo bomai po obao. Nage te naga gi sę yabo tǫde bidibo gudulama, paibao. Magi baso meni, te naga nogogo digi te naga ama kaneme te tǫba gelalio. Tama te tǫ te penane dalalubo tiwai elama, tama te kaneme tualio. ");
INSERT INTO mps_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tama tibaso, nago nai te tǫde bulubaso da, te nai bugagia me hologobeo. Te nago page bulu mu meniama, tama nage te tǫ sibi usu nama, te bulu wau bilibo bidi tiwai bidaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tama Keingo Yawebolo te po wali, “Te nago enabolo mabo sęgę te genuai mu dao. Eno te sęgę tolobo usugobeo. ");
INSERT INTO mps_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Te nago ena e tǫde nago gedude me te sela sąwaibao po wai. Te ena bidabo bulu meniama, tama ena subigila te tǫde bilaibao. Tama bidi me deligo te ena suali da, teda agai ena ela muaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tiali goli, Yawego te po wai, “Menio. Te nage bidi me deligo ela muyu da, mu tama te eno genuai sęgęgo wei ponaibao.” Tialima, Yawego te dąį me deli Keinde muani, tama bidi dabego aga suyu, tama te dąį ilali subaso da, teda augwaligo aga me ela mugobeo. ");
INSERT INTO mps_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tama Kein te Yawe bidibo madi tagalama, wi pelama, tama tǫ me deli teba bidigi pali, te augwaligo te tǫ nogi poali “Subigila Bilibo,” te nogi poali. Te tǫ te Iden gi elaluali madi te giliga asobo badu elaluai. ");
INSERT INTO mps_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Tama nosali Kein te aga we dali pilama, tama we haliga yalima, ogwa me deli ame nani, aga nogi Enok. Nosali Keingo hanu me deli nigilama, tama aga ogwa Enok nogi te hanu nogi polali. ");
INSERT INTO mps_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nosali Enokgo ogwa ame nenama, tama Enokgo te ogwa nogi Irat nogi poai. Nosali Iratgo ogwa ame nenama, tama Iratgo aga nogi Mehujael nogi poai. Nosali Mehujaelgo ogwa ame nenama, tama Mehujaelgo aga nogi Metusael nogi poali. Tama nosali Metusaelgo ogwa ame nenama, tama Metusaelgo aga nogi Lamek poali. ");
INSERT INTO mps_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Tama nosali Lamekgo we si sai. We me deli nogi Ada, tama mego nogi Sila dao. ");
INSERT INTO mps_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adago Jabal ame nani. Jabalgo nosali ame nani wąį dabe augwali da te kibu bulmakau sibi negeyu, te ugwa bede bidaluali wąį hani dao. Jabal agai te kolesaga ebo hasia bolo gagalali, te sę page bidi mu dao. ");
INSERT INTO mps_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Te Jabal aga ama nogi te Jubal. Te Jubalgo wąį hani sibi da, te augwaligo tęąbi te musik gita me, genagigo ona elebo tiwai dali, te gagali yali wąį dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tama nosali te we Silago te Tubalkein ame nani. Tubalkein da, te bras me ain te kapa sigo te haniani sę yabo nai tul dabe te nigibo wąį hani bidi dabe hasia bolo pedelai. Te Tubalkein aga abe nogi te Nama dao. ");
INSERT INTO mps_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Tama me sogo te bidi Lamek aga we sibolo te po wai, “Ada me Sila, dage sigo eno pedauwalide po wabo odiąo. Dage si da, te Lamekgo we da, dage sigo eno po bugagia odiąo. Bidi me deligo ena elibaso, tama eno aga ela muani. Te bidi aga gesi ogwa bidi bidibadi, tama agai ena subigila dodolama elibaso, te eno aga ela muani. ");
INSERT INTO mps_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Augwaligo te po wabo da, ‘Te bidi mego Kein ela muyu da, teda aga moni genuai sęgę mu saibao.’ Tiali goli, eno e po obao, bidigo ena elali da, teda aga moni genuai sęgę mu sesa pidubadi geaibao,” Lamek agai te po wai. ");
INSERT INTO mps_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Te nosali Adam aga we dali ma piai. Tama wego ogwa ame nobaso, tama te po wai, “Te Godigo enabolo te gasa wai te Abel bidali hasegelama mani, te Keingo aga ela muani.” Tialima, agai te wai nogi Set poai. ");
INSERT INTO mps_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Te nosali Setgo wai ame nenama, tama Setgo aga nogi Enos poali. Tama te sogo te bidi dabego te Yawe nogi wabo gagalama, tama agaba lotu po weyu bidali. ");
INSERT INTO mps_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Te Adamgo wąį hani dabe pedelali nogi e tama dao, Godigo bidi dali, we dali, te aga digi tiwai nigai. ");
INSERT INTO mps_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Godigo bidi deli badi, we deli badi nigai. Agai augwali si nigilama, tama augwali si dali dwagi yai sę yabo po olama, tama augwali si nogi poliyu, “Bidi da” wai. ");
INSERT INTO mps_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tama Adam te kibu be 130 bidama, tama aga te ogwa me deligo aya te aga tiwai mu pedelai. Tama Adamgo aga nogi Set nogi poai. ");
INSERT INTO mps_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tama ame nenama, tama nosali te Adam agai gasa ogwa me, wegi me ame neyu bidibadi, aga te gasa kibu be 800 me bidali. ");
INSERT INTO mps_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tama Adam te kibu be umabo bidi sese hauwa 930 kibu be bidama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Te Set te kibu be bidi sese a naga olama, ogwadu a naga, 105 kibu be bidama, te aga ogwa me deligo aya pedelali, nogi Enos. ");
INSERT INTO mps_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set aga te kibu be 807 ma bidama, tama aga gasa ogwa dabe wegi dabe ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tama Set te kibu be bidi sese hauwa, te 912 kibu be bidama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos te kibu be 90 bidama, aga te ogwa me deligo aya pedelali, te ogwa nogi Kenan poai. ");
INSERT INTO mps_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos te kibu be 815 ma bidama, tama agai te gasa ogwa wegi dabe me ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos te kibu be 905 bidama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Te bidi Kenan kibu be bidi sese sela olama, nogo si bidama, tama te ogwa me deli ame nani, te ogwa nogi Mahalalel, ");
INSERT INTO mps_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","tama Kenan te kibu be 840 ma bidama, tama agai te gasa ogwa wegi dabe ame nani. ");
INSERT INTO mps_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan te kibu be 910 bidama, tama aga isali. ");
INSERT INTO mps_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel te kibu be 65 bidama, tama agai te ogwa me deli ame nani tego aya pedelali, te ogwa nogi Jaret. ");
INSERT INTO mps_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Tama Mahalalel te kibu be 830 ma bidama, tama agai te gasa ogwa wegi dabe ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tama tiyu, tama Mahalalel te kibu be 895 bidama, te aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Te Jaret te kibu be 162 bidama, tama aga te ogwa me deligo aya pedelai, aga nogi Enok. ");
INSERT INTO mps_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Tama Jaret te kibu be 800 ma bidibadi, tama agai te gasa ogwa wegi dabe ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tama tiyu, Jaret te kibu be tigidali 962 siliyu bidama, tama aga isali. ");
INSERT INTO mps_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tama Enok kibu be bidi sese sela, me badu nogo a naga, 65 kibu be bidama, tama aga te ogwa me deligo aya pedelali, nogi Metusela. ");
INSERT INTO mps_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tama Enok aga te God dali deli homu naga eyu bilali. Tama tiyu, aga te kibu be 300 ma bidibadi, tama aga te gasa ogwa wegi dabe me ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok te bidibo ula dali e tǫde bidali kibu be te 365 dao. ");
INSERT INTO mps_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Aga te God dali sesemane sogo deli homu eyu bidali, tama Godigo aga selama, tama bidi dabego aga ma subeo. ");
INSERT INTO mps_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tama Metusela te 187 kibu be bidama, tama aga te ogwa me deligo aya pedelali, te ogwa nogi Lamek. ");
INSERT INTO mps_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Tama Metusela te gasa kibu be 782 ma bidibadi, tama agai te gasa ogwa wegi dabe me ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela te kibu be 969 bidama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tama Lamek te kibu be 182 bidama, tama aga te ogwa me deligo aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tama agai te po wai, “Te Yawego te tǫ dolabo bomai po muanio. Megi da, te waigo da te tǫde sę dene ebo te toma nomainogo ilaibao,” te po wai. Tama tibaso, Lamek agai te ogwa nogi Noa poai dao. ");
INSERT INTO mps_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Tama nosali Lamek aga te kibu be 595 ma bidibadi, tama agai gasa wegi ogwa dabe meba ame nai. ");
INSERT INTO mps_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tama Lamek aga te kibu be 777 bidama, tama aga isali. ");
INSERT INTO mps_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tama Noa te kibu be 500 bidama, tama aga te ogwa selago aya pedelali, Siem, me Ham, me Jafet, te tama deli deli ame nanio. ");
INSERT INTO mps_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nosali te we bidi hauwa te tigidali tǫde pedelama, tama augwaligo wegi mani me hauwa elaluai. ");
INSERT INTO mps_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tama te Godigo ogwa dabego te wegi mani dabe sulama, te gasa sawi yai mu yai. Tama augwali deli deligo augwa homugo digi te we dabe anoma eyu, tama augwali selama, bidali. ");
INSERT INTO mps_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tialima, Yawego te po wai, “Eno te bidibo ula sesemane sogo bidada pomainogo sesabi gana emainu mabo mobo te momainogo me egobe, magi baso meni, augwali te osogo bidabo nai tama naga da. Megi da, te bidi bidibo ula te kibu be 120 naga usu nama bidimainu yaibao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tama te sogo me, te nosali sogo me, te moni genuai bobobage bidi dabe meba te tǫde bidaluali. Te bidi dabe augwali te Godigo ogwa dabede sali te we dabego augwaligo ame nani bidi dabe bidali. Augwali te bomai bidi mu gagalama, tama te sogo augwali nogi genuai elaluai. ");
INSERT INTO mps_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Te Yawego te tigidali tǫ badu bidalubo we bidi dabego ebo kolesaga suali, te dwai dwai mu yali. Augwaligo homu te dwai sę ebode naga konealuali. ");
INSERT INTO mps_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Tama Yawego te polobadu bidi de we si tǫgo nigilama, te dwagi yai homu pemene yali, te homu ma koneani. Tiali goli, agai te we bidi hani dabego homu suali, te augwaligo homu te dwai naide naga konebaso, tama tede homu dene eyu, agai te polobadu dwagi yai homu pemene yali tiwai gilama ma ebeo. Te meni. ");
INSERT INTO mps_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Homu dene mu eyu, tama agai te po wali, “Te eno nigali bidi tigidali te eno ela silaibao, te augwali menade bidada pabo te mu silaibao. Te eno tigidali hasa sibi dabe tigidali me, te ba dabe me, te nai dabe me, tigidali silaibao. Magi baso meni, ena digi ena te nai dabe nigali goli, augwaligo ebo kolesagago enaba dene ilibo dao, tama wiegi yai homu pemene ma egobeo,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tiali goli, Yawego te bidi Noa dali digi dwagi yai homu pemene yalio. ");
INSERT INTO mps_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Te Noade po da te tiwai dao. Agai ogwa sela elaluali, Siem, Ham, me Jafet. Noa da dwagi yai bidi, te sogo bidali we bidi tomode te Noa deli digi aga bilibo kolesaga te Godigo gedude dolo mu yali. Aga te God dali deli homu naga eyu, tama Godigo abagi mu dao. ");
INSERT INTO mps_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tiali goli, gasa we bidi dabe augwali tigidali te God gedude dolama bidali, tama dwai kolesaga me, te hwįbo kolesaga me, te tigidali habuba pągąna sigi pai. ");
INSERT INTO mps_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tama Godigo tǫba tonaluama, tama agai tigidali bidigo dwai kolesaga mu ebo suali. Te bidigo bilibo kolesaga te gaga pai mu pedelama, tama dwai kugumini naga yai. ");
INSERT INTO mps_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tialima, Godigo Noabolo te po wali, “Tigidali bidi augwaligo tigidali tǫde te haniani dwai hwįbo kolesaga mu ebo. Tama tibaso, eno tede homugo konea palama, tama te homu ebao, eno augwali dolai hagede ebao. Te eno tigidali we bidi mu silaibao. ");
INSERT INTO mps_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tama nago dwagi yai ni pedai selama, tama naga moni genuai geba sip me deli nigao. Nago te tomode be habu meba nigilao, tama tomode me bulu badu mabode te agebele megego bugagia sebelao. ");
INSERT INTO mps_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nago te tiwai sip nigao. Te sip bobage usu sabo, te 133 mita, te aga genuai ilabo usu te 22 mita dao. Tama nago ugwaba bobage usu ni sabo, te 13 mita dao. ");
INSERT INTO mps_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nago te sip pedu nigilao. Tiali goli, te sip bulubadu paiabo ni name dabe augwali te pedu dologoba mu paigio. Menio. Te hap mita olo elalumainao, te ula tomoba asomainu. Te sip tomode be sela te tama tiwai sę yao, me deli aiyadu, me deli tomode, me deli ugwadu. Tama nago te me bogo badu te sip tomoba pabo sunumi me deli nigao. ");
INSERT INTO mps_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Te eno te tǫde wę asobo genuai mu pedalumainu elama, te tigidali bidibo ula elalubo nai dabe dola silimainu yaibao. Te tǫde tigidali nai dabe isila silaibao. ");
INSERT INTO mps_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tiali goli, eno nage dali da, te eno bomai po dąų walaibao. Nage da, naga we dali badi, te naga ogwa dabego augwa we dabe dali, dage da te moni geba sip tomoba bula sao. ");
INSERT INTO mps_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Tama nago te tigidali haniani hasa dabego si si sao, te me omai, me so tama, si sao. Tama nago augwali te duga dali hodobo te moni sip tomoba sela pobaso da, teda augwali me isigobeo. ");
INSERT INTO mps_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Te tigidali haniani ba me, te genuai me, te dwasianu dabe me, te omai de so si si augwali te sip tomoba pelama, te augwali me isigobeo. ");
INSERT INTO mps_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Tama nago te naga tuabo haniani nai badi, te haniani hasa dabego tubo nai me, te ba dabego tubo nai me selama, te moni sip geba tomoba muao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Tialima, Noago Godigo agabolo te wali po gilama te tigidali sę ela silai. ");
INSERT INTO mps_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Nosali Yawego Noabolo te po wai, “Eno nage deli naga nage te tigidali bidi tomode dolo bidibo sualio. Tama tibaso, megi nage te moni geba sip tomoba, naga we wai puluba tigidali dali tomoba bula sao. ");
INSERT INTO mps_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tama nago te tigidali haniani hasa dabe, te ofa maiabo usu eyu, meda meni yai hasa dabe naga sobadi, te omai a naga olama, me badu nogo si badi, te so me a naga olama, me badu nogo si, te augwali selama, te sip tomoba muao. Tiali goli, te eno gedude wiegi yai isąyani hasa, te ofa maiabo usu meni yai hasa dabe, te nago omai dali, tama so dali, te si naga sao. ");
INSERT INTO mps_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Tama tiali goli, nago te tigidali haniani ba dabego te omai ba a naga me si sobadi, te so ba me a naga olama, me si sobadi yao. Nago tama tiyu da, teda augwali me isisąyu, tama nosali augwaligo wai dabe hauwa ma te tǫde dala pomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","“Tama te nogo a naga olama, me badu nogo si, te tama si silama, tama eno te tǫba kulubage tagala palama, tama te kulubage tulaludubadi, te bidi sese si ulade me, te bidi sese si hulide bidibadi yaibao. Tama te kulubagego te eno te bidibo ula elalubo tigidali ena nigali nai te tǫ daide eno sela sąna silaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tialima, Noago te tigidali sę te Yawego agabolo po wali gilama te sę ela silali. ");
INSERT INTO mps_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tama Noa te kibu be 600 bidai elalubadi, tama te genuai wę te tǫde pedelai dao. ");
INSERT INTO mps_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tama Noa we de bidi si dali, te aga ogwa dabe me, augwa we dabe dali, te geba sip tomoba bula sali, te wę asiyu, te augwali me dologobeo. ");
INSERT INTO mps_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Tama te tigidali haniani hasa, dwagi yai me te dwagi yai isiąwani hasa dabego te omai me so deli deli sesa pobadi, tama te ba dabego me, te dwasianu hasa dabe me, te tigidali omaigo siyu, sogo siyu elama, ");
INSERT INTO mps_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","te sip tomoba Noa dali pali, te Godigo po wali gilama tama yalio. ");
INSERT INTO mps_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tama tiyu, te nogo a naga olama, me badu nogo si sogo silama, tama te genuai ąį asiyu, te tǫ mesegelalio. ");
INSERT INTO mps_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Te Noa te kibu be hauwa mu 600 bidama, tama te si wabo polua, dei 17 nogo si olama, sągągo a naga, me badu sągągo si tama side, te tǫ dologode te tigidali genuai wę dabe te sunumi dala pela silama, tama wę ugwaba pedelali. Tama dagalude me te tigidali dedage dala pelama, tama wę aiyaba gelalio. ");
INSERT INTO mps_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tama genuai kulubage mu tuludubadi, te hauwa sogo huliyu, posoyu yali, te ulade bidi sese si 40 dei, te hulide bidi sese si 40 sogo bidibadi, tama yali. ");
INSERT INTO mps_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tama te genuai ąį asobo gagalali side naga, te Noa me aga we me, te aga ogwa sela Siem, me Ham, me Jafet dali badi, te augwa we dabe sibi dali, augwali te sip tomoba bula sali. ");
INSERT INTO mps_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Tama tigidali haniani bulu hasa dabe me, te bede bidibo hasa dabe me, te dwasianu hasa me, te tigidali haniani ba sibi me, augwali te sip tomoba Noago hani dali pali. ");
INSERT INTO mps_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Te tigidali bidibo ula elalubo haniani nai sibi te omai me so te deli deli naga selama, augwali Noa dali te sip tomoba pali, te Godigo wali po tiwai gilama yalio. Noa te sip tomoba bula sabode, tama Yawego te sip sunumi paliali. ");
INSERT INTO mps_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tama te moni wę pedaludubadi, te bidi sese si sogo elama, tama bo dabo ugwaba mu holama, tama te geba sip ugwanu sela holali. Tama sipgo te tǫ taga holali. ");
INSERT INTO mps_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tama wę genuai mu pedelama, tama sip te wę daide ugwadu biliduali. ");
INSERT INTO mps_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tama wę bo dabo ugwanu mu holodu genama, tama tigidali moni bobage bulu du mesegelali. ");
INSERT INTO mps_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tama pelama, tama te węgo tigidali bulu du aiyaba elalualima, tama ugwanu mu holodu geani, te usu ni sabo te 7 mita dao. ");
INSERT INTO mps_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tama tǫde bidibo ula elaluali nai dabe tigidali isa silai, te ba dabe me, te be pąde bidalubo hasa dabe me, te dwasianu hasa dabe me, tama tigidali nai me, te we bidi dali tigidali isila silai. ");
INSERT INTO mps_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Te tǫde bidibo ula elaluali nai dabe tigidali isalio. ");
INSERT INTO mps_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Yawego te tǫde tigidali nai dolali, te we bidi dabe me, te be pąde bidibo hasa dabe me, te dwasianu hasa dabe me, te ba sibi dabe me, te tigidali dolai. Tama te hani me deli naga augwali te węgo me dolobe, te Noa aga hani dabe me, tama augwali dali te sip tomode bidali nai dabe dali, augwali dolobeo. ");
INSERT INTO mps_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tama wę moni bage mu pedaludubadi, tama tǫ mesegelai elaludubadi, tama bidi sese a naga olama, me badu nogo si olama, te gasa bidigo nogo si sogo, 150 dei te wę elaludubadi geani. ");
INSERT INTO mps_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Te Godigo Noa dali, te bulu uni hasa dabe dali me, te be pąde bidalubo hasa dabe me aga dali te sip tomode bidalubo, te Godigo homugo koneani. Tama tiyu, Godigo te wali te tǫ daide ugwadu bilimainu ilama, tama wę aiyaba kekasa dulubo gagalali. ");
INSERT INTO mps_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tama tǫ dologode elaluali tigidali węgo sunumi, me te dagalude dedage elaluali, tigidali te palia sali. Tulubage te dagalude ma tulusiąbadi, ");
INSERT INTO mps_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","tama wę aiyaba kekasa dulali. Te aiyaba dulubo sę idubadi, te tama polua nogo a naga, te 150 sogo teba usu nani. ");
INSERT INTO mps_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tama te polua a naga me badu si wali, te polua dei nogo si olama, a naga, me badu si, te 17, tede te moni geba sip te bulu du me deliba dąų wagi pali, te bulu du dabe nogi Ararat dao. ");
INSERT INTO mps_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tama te wę aiyaba duludubadi, tama te nogo si polua, dei deli wabode, te gasa pąde elalubo bulu du tobolu dabe pedali gulalio. ");
INSERT INTO mps_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Nosali te bidi sese si wabo side silai madi, tama Noago te sip pola sali dwasianu sunumi dalama, ");
INSERT INTO mps_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","tama sisi yai ba me nogi kotkot, te ba tądi tiwai ba me deli tagala palali. Te ba pelama, bola bilidubadi, te tǫ wę sula sabo sogo usu nigi pai. ");
INSERT INTO mps_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Tama nosali Noago ba hi me deli tagala palai, te wę aiyaba kekasa dulaliwe naga konemai hagede tialio. ");
INSERT INTO mps_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tiali goli, ąįgo te tǫ halualudubadi gebaso, tama te ba hi aga dualama, toma nabo madi meni baso, te aga ma geasa aselama, tama Noago nogo buluba dinama, tama aga sip tomoba ma sali. ");
INSERT INTO mps_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tialima, Noa te me sela, me sela, me deli, te tama sogo bidama, tama agai te ba hi ma tagala palai. ");
INSERT INTO mps_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tama te be pio mu ebode te ba higo Noa bidibo madi ma aselama, tama aga penanide te gesi ni oliv yabe me deli selasa asali. Tama tibaso, Noago koneani, te wę aiyaba kekasa dulali dao, wali. ");
INSERT INTO mps_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tama aga te a naga me si, te tama sogo tonaluama, tama te ba hi ma tagala palai. Tama te ba hi munu me asobeo. ");
INSERT INTO mps_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noago kibu be 601 elama, tama te polua deli wabo, dei deli ebode te tǫ daide elaluali wę tigidali sula sali. Tama Noago te sip haluali nai dagala sąnama, tama tonono bilali. Tama agai te tǫ wa pabo suai. ");
INSERT INTO mps_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tama bidama, tama te polua si, te dei 27, te sogode te tǫ tigidali mu wa palio. ");
INSERT INTO mps_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tama Godigo Noabolo te po wai, ");
INSERT INTO mps_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nago te geba sip tagalama, tama nage naga we dali, me naga ogwa dabe, augwa we dabe dali, dage tǫba aiyaba dulao” po wai. ");
INSERT INTO mps_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","“Tama tigidali hasa sibi dage dali aiyaba sela dulao, te ba dabe me, te be pąde bidalubo hasa dabe me, te genuai bulu hasa dabe me, dwasianu hasa dabe me, te tigidali te tǫba dulao. Te augwali bilaluyu, tama wai dabe ame nenama, umabo pedaliyu, tama tigidali tǫ pedai usu ilimainao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tialima, Noago te sip tagalama, te aga we dali, te aga ogomani dali, te augwa we dabe me, augwali hodobo te tǫba dula silali. ");
INSERT INTO mps_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tama te tigidali uni hasa sibi me, te be pąde bidibo hasa sibi me, te ba dabe me, te dwasianu hasa sibi dabe, augwali te deli deliba naga hodobo sisina silama, tama te sip tagalama, tama tǫba dula silali. ");
INSERT INTO mps_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Tama Noago te Yawebolo nai olo momainogo eyu, tama te ofa maiabo alta sai nigali. Tama agai te tigidali haniani hasa sibi tigidaligo te ofa maiabo usu yai hasa deli deli, me te ba dabe me sobadi elama, tama agai augwali elama, ofa yalio. Tama agai te alta sai ilali madi daide ulali. ");
INSERT INTO mps_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yawego te gasa sawi yai pusu yai ofa ulubo denami odobaso, tama agai aga homude te po wai, “Eno te we bidi dabego dwai kolesaga wei ponoyu, te tǫ dolabo po munu ma wagobeo. Eno koneani, te bidi dabe ogwa bidi bidibo sogo gagalama, tama peyu, sesemane sogo te bidi dabego homu kolesaga dwai elaluduai. Eno te bidibo ula elalubo nai tigidali te munu me ma dologobeo, te eno megi yali tiwai me egobeo. ");
INSERT INTO mps_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tama tiyu, te nai bulabo sogo me, te nai sabo sogo me elaluaibao. Tama te giliga nanobo sogo me, te tulubage sogo me elaluaibao. Te giliga me te be hulibo tama elaluaibao. Te e tǫ elalua pobadi, tama te tigidali nai me sia sogobeo,” Yawego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Te Godigo dwagi yai po mobo Noabolo me, aga ogomani dabe dalibolo mayu, e tama po wali, “Te wai dabe hauwa mu ame nenama, te dagego hanigo te tigidali tǫ pedai pągąna sao. ");
INSERT INTO mps_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Te tigidali tǫde hasa sibi me, te ba dabe me, te dwasianu hasa sibi dabe me, te sųgų dabe, te augwali dagede wi mu yaibao. Eno te augwali dagego nogoba muyu, tama dagego te augwali tonaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dagego te tigidali haniani hasa sibi me te haniani tǫde bilalubo hasa, te dagego tuabo nai da, te usu yaibao. Polobadu eno te we bidi dabebolo te tǫde holobo nai, te nai walobo nosa me, te haniani du walobo nedu du wai dabe, te nai dabe eno tama mayu, tama dagego tuabo nai dao wali. Tama te tiwai gilama eno megi obao, te tigidali nai te dagego tuabo nai dao. ");
INSERT INTO mps_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tiali goli, te nai me deli da dagego me tugio, te kaneme hauwa me elalubo mi, magi baso meni, te kaneme da, te bidibo ula elalubo page te dao. ");
INSERT INTO mps_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Te bidi me deligo dage ela mubaso da, teda eno te bidi sula tagalogobeo, eno agabolo me wei ponaibao. Tama te hasa sibigo dage me elibaso da, teda aga me eno ela muaibao. Ma, bidigo gasa bidi ela mubaso da, teda agabolo eno wei ponaibao. ");
INSERT INTO mps_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Te bidigo gasa bidi ela mubosi, aga digi te bidi dabego nogode isimainogo yaibao, magi baso meni, ena God eno bidi nigali, te ena noma bidi tiwai digi nigali. ");
INSERT INTO mps_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Megi da, dagego wai dabe hauwa ame nomainao, tama dagego wai dabe hani te hauwa mu pedelama, tama tigidali tǫ pedai badu pągąna sao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tama Godigo Noa dali, me aga ogomanibolo dali po weyu, bomonama te po wai, ");
INSERT INTO mps_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Megi ena da, eno bomo yai po dage dali, me te dagego nosali ame neyu elalua pabo bulai wai dabe dali te dąų obao. ");
INSERT INTO mps_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Tama eno te tigidali bidibo ula elalubo nai sibi dali me te bomo yai dwagi yai po dąų obao, te ba dabe me, te bidigo negebo hasa dabe me, tama te bulude bidalubo uni hasa sibi dabe me, tigidali te dage dali sip tomode bidaluai. ");
INSERT INTO mps_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Eno dage dali e tama pogo dąų obao, eno po dąų mu weyu, te bidibo ula elalubo tigidali nai dabe te eno munu me ma te ąįgo me dologobeo. Tama wę asiyu, te e tǫ munu ma dologobeo,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Tama Godigo te po wali, “Eno te dagalude unigi bidi mubo, te eno dage dali, me te hasa sibi dali, sesemane sogo yali te dąį tiwai mubao. Te unigi bidi te eno tigidali tǫde bidi dali po dąų wali dąį dao, tama te dąų wali dwagi yai po munu me siligobeo. ");
INSERT INTO mps_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Te eno dagalude te pǫ pedalumainogo ebo sogo da, teda te unigi bidi me pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Tama tiyu, eno te po dage dali, me te hasa sibi dabe dali, te dąų wali po eno homugo konealu, teda te tiwai wę asiyu, te bidibo ula elalubo tigidali nai dabe me dologobeo. ");
INSERT INTO mps_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Te eno te unigi bidi te dagalude pedalubo subo sogo da, teda eno te elalua pabo gamonabo dąų wali po sesemane sogo kone palu, te megi eno te tigidali tǫde bidibo ula elalubo nai dabe dali me tiaibao.” ");
INSERT INTO mps_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Tama Godigo po weyu, Noabolo te po wali, “Te e unigi bidi da, te eno dąų wabo dwagi yai po te tǫde bidibo ula elalubo tigidali nai dabe dali dąį ilibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Te e da Noago ogwa sela te sip tagalama dulali ogwa sela nogi dao, Siem, me Ham, me Jafet dao. Tama Ham te Kenango aya dao. ");
INSERT INTO mps_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Te bidi Noago te ogwa dabe da, augwali te tǫde bidalubo tigidali bidi sibigo wąį monu dabe te augwali dao. ");
INSERT INTO mps_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa aga te gi sę ebo bidi bidai, tama aga te bono du ąį wain gi bulali. ");
INSERT INTO mps_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tama nosali me sogo deli sogode agai te wain bomai ąį meba tulama, te aga tobolu gęǫ eyu, aga esela pai. Tama eyu, aga ugwa dabe pepeda pelama, tama aga bolu olo te aga ugwa be tomode pila muani. ");
INSERT INTO mps_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Tama Ham, te Kenango aya, agai te aga aya bolu olo pila mubadi sulama, tama aga pelama, aga ama sibolo wagi pai. ");
INSERT INTO mps_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tialima, Siem de Jafet sigo te ugwa selama, te augwa si nageba muani. Tama augwali si te ugwa be tomoba tudibadu naga pelama, tama augwa si aya te ugwago haluali. Te augwali sigo gesabi begelama, te augwa si aya bolu olo pila mubo subeo. ");
INSERT INTO mps_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tama nosali Noa aga hodaluama, tama aga homu kolesaga ma peda pabode, agai odali, te sabi bidi ogwago te agade yali po odai. ");
INSERT INTO mps_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tama agai te po wali, “Genuai sęgę te Kenande ugwadu elaluaibao. Te aga hani dabe te aga ama dedego hani dabego nogi meni yai sę ebo olo gagalama, bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Tama Noago te tiwai po me wali, “Dago te Yawego nogi ugwaba sinao, te Siemgo God da. Kenan da, te Siemgo olo sę ebo bidi elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Eno homugo Godigo Jafetgo wai puluba dabe te hauwa pedalumainu ilaibao, tama augwali te Siemgo hani dabe dali bugagia bidalumainu yaibao. Tama Kenan da, te Jafetde te olo sę ebo bidi elaluaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Te genuai wę asali sila madi, tama Noa te kibu be hauwa 350 mu ma bidai dao. ");
INSERT INTO mps_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tama e tǫde bidali sogo te umabo kibu be 950 bidama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Te e dao te węgo ela silai madi te nosali Noago ogwa sela Siem, me Ham, me Jafet, te augwali selade pedelali bidi hani dabe te nogi e dao. ");
INSERT INTO mps_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Te e dao te Jafetgo ogwa dabe dao, Gomer, Magok, Madai, Javan, Tubal, Mesek, me Tiras, te tama dao. ");
INSERT INTO mps_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Te Gomergo ogwa dabe, te e da, Askenas, Rifat, Togarma, te tama. ");
INSERT INTO mps_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Te Javango ogwa dabe da, e dao, Elisa, Tarsis, te Saiprus bidi hani me Rodan hani bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Te e hani wąį dabe da, augwali te ąį sanede ma te ąįgo bobegelali tomode bidaluali hani dao. Augwali te hani bidi te Jafet tede pedelama, tama deli deli hani te augwa bidibo pedai badu nosali bidalua pali. Tama deli deli hani augwa po tedali tedali weyu bidai. ");
INSERT INTO mps_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Te e da te Hamgo ogwa dabe dao, Kus, Isip, Put, me Kenan, te tama. ");
INSERT INTO mps_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Te Kusgo ogwa dabe da, te augwali e dao, Seba, Havila, Sapta, Rama, me Sapteka. Ramago ogwa si ame nani, me Siba me Dedan. ");
INSERT INTO mps_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Tama Kusgo ogwa deli bidali, te nogi Nimrot. Nimrot aga te tǫde hasia polasa te boma pai tobolu bidi pedelali. ");
INSERT INTO mps_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Te Yawego gesabide te Nimrot te hasa gegebo sę mu koneai bidi pedelai. Tama te bidi augwaligo te po wali, “Te bidi aga te Nimrot tiwai tama dao. Te Yawego gedude aga te hasa dabe gegabo bomai bidi mu pedelai dao.” ");
INSERT INTO mps_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Te Nimrotgo hasia bolo tonaluali moni hanu me si me si elaluali, Babel, me Erek, me Akat, me Kalne. Tama te hanu dabe me si me si te Babilonia pedai badu elaluali. ");
INSERT INTO mps_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrotgo te Babilonia taga soyu, te genuai hanu te Asiria tǫba nigigi pali, te hanu me Ninive, me Rehobotir, me Kala, ");
INSERT INTO mps_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","me Resen. Resen hanu te Ninive de te genuai hanu Kala si tomode elaluali. Te hanu dabe te Asiria dabego tǫ pedai badu elaluai. ");
INSERT INTO mps_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Tama Isip te Lut hani sibigo aya pedelali, te Anam hani, me Lehap, Naptu, ");
INSERT INTO mps_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patros, Kaslu, te hani dabe, me Krit. Te Filistia bidi ama sibi te Krit te bidi hanide nosali pedelai dao. ");
INSERT INTO mps_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Saidon aga te Kenango gomunai ogwa da. Kenan te Hit bidi dabego aya me da, ");
INSERT INTO mps_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","tama Jebus bidi dabe me, Amor me, Girgas, ");
INSERT INTO mps_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi, Arka, Sini, ");
INSERT INTO mps_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvat, Semar, me Hamat, tama nosali Kenango hani deli deli pelama, te bidabo pesage te hauwa tǫ pedai badu nigilama, bidali. ");
INSERT INTO mps_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tama Kenan dabe bidali tǫ dąį te Saidon tedu gagalama, tama pelama, te Gerar tǫba dąį igi pai, tama te Gasa nogi wabo tǫ te pedai badu me dąį igi pali. Tama sesegedu begelama, te Sodomba, me Gomora, me Atma, me Seboim, te hanu dabeba sabaligi palima, tama pelama, te tǫ Lasa teba sabaligi pai. ");
INSERT INTO mps_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Te bidi Hamde pedelali hani dabe te e tama. Te deli deli hani dabe te augwa bulude digi bidada pali. Tama nosali deli deli hani te augwa po tedali deli deli ola pelawai. ");
INSERT INTO mps_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Tama Siemgo ogomani me elaluali, tama te da te Ebergo hani wąį dabe da. Siem da, te Jafetgo amanu dao. ");
INSERT INTO mps_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Te e da te Siemgo ogwa dabe nogi da, Elam, Asur, Arpaksat, Lut, me Aram da. ");
INSERT INTO mps_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Te Aramgo ogwa dabe, te e dao, Us, Hul, Geter, me Mesek dao. ");
INSERT INTO mps_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksat aga te Selago aya, tama Sela te Ebergo aya dao. ");
INSERT INTO mps_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Tama Ebergo ogwa si ame nani. Te mego nogi Pelek. Magi baso meni, aga te tǫde bididubadi, tama te bidi hani dabe augwaligo augwa tedali tedali po wabo gagalali, tama tebogo te augwali tomode pedai dao. Tama Pelekgo ama nogi te Joktan da. ");
INSERT INTO mps_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Tama Joktan da, te Almodatgo aya, me Selep, me Hasarmavet, me Jera, te augwali tama bagego aya dao, ");
INSERT INTO mps_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, me Usal, Dikla, ");
INSERT INTO mps_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO mps_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, me Jobap da. Te tigidali da, te Joktango ogwa dabe nogi dao. ");
INSERT INTO mps_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Te e bidi hani dabe bidaluali pesage da, te bulu Mesade gagalama, tama pelama, te Sefar pedai badu tugi pali, tama palima, te giliga pedalubo badu te bulu du dabe elalubo pedai badu tugi palio. ");
INSERT INTO mps_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Te Siemgo hani dabede pedelali bidi dabe da. Tama deli deli hani dabe te augwa bidalubo bulude digi bidalua pali. Tama nosali deli deli hani dabe te augwa po dabe tedali elalua pali. ");
INSERT INTO mps_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Te e nogi dabe nogi yali da, te Noago ame nani ogwade pedelali hani dabe nogi dao, tama te augwa bidali tǫ pedai dabe me da. Te węgo bidi ela silai madi, tama te nosali te tigidali tǫ pedaide te pedelali bidi sibi dabe, te augwali Noago wai dabego hanide naga pedela silali hani te megi me bidalubo. ");
INSERT INTO mps_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Polobadu mu, te moni węgo bidi ela silai madi silama, tama te tǫde bidaluali bidi sibigo te wabo po deli naga elaluai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Augwali te giliga pedalubo badu kikili pelama, tama augwali te malu tǫ me deliba sabolali. Tialima, augwali te malu tǫ nogi Sina te bulu habu badu bidaluai, te bulu nogi me Babilonia. ");
INSERT INTO mps_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nosali augwa hasi po minama, augwaligo tama tiwai po wai, “Awe, abagi dedeo! Dago te dwagi yai mama yai tǫ meba begelama, te siaba ulama, te masigi tiwai pedalumainu ilinao,” wai. Tama tilama, te be sę yabo masigi meni baso augwaligo te be sę ebo nai tama nigali. Tama te masigi dąų wabo simen meni baso, augwaligo te be sę eyu, dąų walobo nai kolta me selama, elaluai. ");
INSERT INTO mps_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tialima, augwaligo te po wai, “Megi da, dago dena genuai hanu me dedeli niginao. Tama te tomode moni bobobage sigi be nigaibao. Tama te be sese holobo te bobage ugwa dagaluba mu usu nigi holaibao. Tama tialima, te we bidi dabego te sę ebo suyu da, teda augwaligo dago nogi ugwaba saibao. Tama tiyu da, da munu me tedela pelama, gasa tǫ pedai badu gasa gasaba me tedela pelama, me bidigi pogobeo,” augwaligo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Tialima, megi da Yawego te tǫde osogo bidibo bidi dabe augwaligo te nigila silali te masigigo sę ebo moni hanu dali, te moni bobage sigi be dali si, te suagasuyu dulalio. ");
INSERT INTO mps_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Tama tibadi, agai te po wai, “Megi da, te e bidalubo bidi hani te deli hani bage naga dao, tama augwaligo po te deli naga elalubao. Tama tilama, augwaligo e moni hanu nigibo sę deli naga te yabo homu eyu, tama te sę usu yaibao. Tiali goli, augwaligo tama tiyu da, teda te pąde sogo digi tama te augwa digi te augwaligo tigidali haniani sę nigibo homu eyu, tama augwaligo te sę ebo me usu yaibao, tede ususiąbo egobeo, te augwa homu naga wali peyu bidaibao. ");
INSERT INTO mps_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tama tidali weyu, da te tǫba dulama, te augwaligo po dedeli wabo te augwali dogoni hasegelama, te mebago te mego wabo po te munu me odisiąmainu, te augwali hamena begela siligi pinao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tama tiyu, Yawego te augwali gasa gasa tedali tǫ pedaiba tedela pomainu ilalima, tama augwaligo te moni hanu munu ma nigibeo. ");
INSERT INTO mps_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Tama augwaligo te hanu nogi Babel poai, magi baso meni, te Yawego te tigidali hani bagego po hasegelali, tama augwali hani bugulama, tama augwali tigidali tǫ pedaiba tedali tedali tedala pela silai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Te e dao te Siemgo wai hani dabe dao. Te genuai wę asali bidama, tama nosali te kibu be si bidai madi, te sogo Siem aga kibu be bidi sese a naga 100 yia elalubadi, tama aga te ogwa me deligo aya pedelali, te Arpaksat ame nani. ");
INSERT INTO mps_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Tama te ogwa Arpaksat ame nenama, tama te Siem te kibu be umabo mu, te 500 yia ma bidama, te agai gasa ogwa wegi me ame nenama, aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tama te Arpaksat te kibu be 35 kibu be elama, tama aga te ogwa me deli Selago aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Tama nosali Arpaksat te kibu be umabo, te 403 kibu be ma bidama, tama agai gasa ogwa wegi me ame nenama, tama aga isai. ");
INSERT INTO mps_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tama te Sela te kibu be bidi sese deli olama, nogo si kibu be bidalima, te aga Ebergo aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Tama nosali te Sela te kibu be hauwa mu, te 403 ma bidalima, te agai gasa wegi ogwa me ame nobadi elama, te aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Te Eber te 34 kibu be bidama, te aga ogwa me deli ame nenama, te ogwa Pelekgo aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nosali te Eber te kibu be umabo te 430 ma bidama, te aga gasa wegi ogwa me ame nenama, tama aga isali. ");
INSERT INTO mps_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Te Pelek aga te kibu be bidi sese olama, nogo si bidama, Reugo aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nosali Pelek te kibu be hauwa, te 209 ma bidama, tama agai gasa wegi ogwa me ame nobadi elama, te aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Te Reu kibu be bidi sese deli olama, nogo si olama, me si, 32 bidama, tama aga ogwa me deli Serukgo aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Tama nosali Reu te kibu be bidi sese hauwa 207 bidama, te agai gasa wegi ogwa me ame nobadi elama, te aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tama Seruk te kibu be bidi sese deli olama, nogo si bidama, tama aga ogwa me deli ame nani ogwa Nahorgo aya pedelai. ");
INSERT INTO mps_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Tama nosali Seruk te kibu be umabo 200 ma bidama, te aga gasa wegi ogwa me ame nenama, tama aga isali. ");
INSERT INTO mps_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tama Nahor te 29 kibu be bidama, te aga ogwa me deli ame nani, te ogwa Terago aya pedelali. ");
INSERT INTO mps_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nosali Nahor te kibu be hauwa, 119 kibu be ma bidalima, tama aga gasa ogwa me wegi ame nenama, tama aga isalio. ");
INSERT INTO mps_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tama Tera te kibu be bidi sese sela olama, nogo si, 70 kibu be bidama, te aga Abram, me Nahor, me Haran, te tama sela ogwago aya pedelai. ");
INSERT INTO mps_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Te e da te Terago hani wai dabe dao. Tera te Abram, me Nahor, me Haran, te augwaligo aya da. Tama Haran te bidi Lotgo aya da, ");
INSERT INTO mps_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","tama Haran te aga bulude isali, te Ur te Kaldia pedai badu, te aga aya bidibadi dao. ");
INSERT INTO mps_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Tama Abramgo te we nogi Sarai sali, tama Nahorgo te Harango wegi Milka sai. Haran te gasa wegi Iskago aya me dao. ");
INSERT INTO mps_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Tama Saraigo wai ame nabo usu me ebeo. ");
INSERT INTO mps_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terago te aga ogwa Abram sali, tama Lot te aga wąį da, tama Sarai te aga wąį da. Lot te Harango ogwa, tama Sarai te Abramgo we da. Tama Tera dali, te hani bidi dabe dali, augwaligo te hanu Ur tagalama, te Kaldia pedai badu tedu peyu, tama te Kenan tǫ pedaiba bidigi pai. Augwali bidada pali, tama tomode te Kenan tǫba sabalisiąbadi, te Haran tǫ teba usu nama bidaluai. ");
INSERT INTO mps_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tama Tera te kibu be hauwa 205 mu bidama, tama aga te bidali pesage Haran te bulude isai dao. ");
INSERT INTO mps_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Te Yawego Abrambolo te tiwai po wai, “Nago te nago tǫ badi, te naga ayago hani me, te naga ayago bulu me, taga pao. Tama nage eno ola mabo digi gasa pedai badu me bidigi pagameo. ");
INSERT INTO mps_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Te eno nago wąį hani dabe te genuai hani mu pedalumainu yaibao. Te eno nage dali dwagi yai sę mu yaibao. Eno te nago nogi genuai ilaibao. Tama gasa we bidi dabe augwaligo te tiwai po waibao, ‘Eno homugo te Godigo enabolo dwagi yai sę emainao, te agai Abram dali yali tiwai yao.’ ");
INSERT INTO mps_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Te nage dali wiegi yai kolesaga ebo bidi dabe, augwalibolo te eno wiegi yai mobo augwaliba mayu yaibao. Te ena digi te nago nogi aiyaba muabo dwai po wabo bidi dabe te eno augwalide te dolabo po mu waibao. Tama tigidali tǫde bidalubo bidi hani dabe te nago hanide naga te wiegi yai mobo augwaligo saibao,” Yawego Abrambolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tama te po obaso, Abramgo te Yawego po wali pelama, tama Lot aga dali pali. Abram bidali kibu be te bidi sese sela olama, nogo si olama, me badu nogo a naga, te 75 kibu be bidai elalubadi, te sogo agai te Haran hanude bidali tagalama, pai. ");
INSERT INTO mps_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tama Abramgo aga we Sarai sobadi, te aga amago ogwa Lot sobadi elama, te augwali hodobo pali. Tama augwaligo augwa sę ebo bidi dabe me sobadi, tama augwaligo te Haran hanude sali doado bage me tigidali selama, tama pelama, pelama, tama augwali te Kenan moni tǫ pedaiba soali. Augwali te Kenan tǫba sabolai madi, ");
INSERT INTO mps_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","tama Abram te tǫ tomodu ma pelama, tama aga te gasa pesage te hanu nogi Sekem teba saboligi pai. Tama te bulude te gasa moni ni mu deli nogi More te elaluali. Tama te sogo te Kenan hani bidi dabe te bulude bidibadi dao, tama augwaligo augwa tibo god dabebolo te moni ni pagede te augwa lotu po weyu, bidaluali. ");
INSERT INTO mps_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Te Yawe Abram bidiboba pedelama, tama tobo po wai, “Te e genuai tǫ da, te eno nago wąį hani wai dabebolo mawaibao,” te po wali. Tama tibaso, Abramgo te Yawe agaba pedelali madi te pesagede te Yawebolo lotu po weyu, ofa nai mayu yabo alta sai nigai. ");
INSERT INTO mps_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nosali Abramgo te More bulu tagalama, ma pelama, tama dolo nogo pedai badu, te saut wabo, te badu peyu, tama te bulu du elalubo buluba sabolali. Te bulu du dabe elalubo badu te sia ge pedalubo pedai badu, te Betel hanu pąde elalubo madi, te badu bidigi pai. Tama agai te pesage me deli te Betel de Ai hanu si tomode aga ugwa be dabe dodolama, muani. Te hanu Ai te giliga dulubo badu elaluali, te Betel hanu te giliga pedalubo pedai badu elaluali. Tama Abramgo alta sai te bulude me nigilama, te Yawe nogi weyu, agabolo lotu po wai dao. ");
INSERT INTO mps_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Tama elama, bidama, tama nosali Abram te me mu pidubadi geanima, te giliga pabo bogo badu te moni tǫ pedai Negeb, te badu sabaligi pai. ");
INSERT INTO mps_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Te nosali Abram te Negeb tǫ pedaide bididubadi, te nasi ebo sogo pedelama, tama te bulude nai mu meni yai. Tama tibaso, Abram te Isip moni tǫ pedai teba pelama, te pęwadage sogo naga bidigi pai. ");
INSERT INTO mps_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tama Abram te pelama, te Isip pąba sabalubo sogo, te aga we Saraibolo tama po wai. Agai te po wali, “Odao, eno koneani, nage te gasa sawi yai we mu dao. ");
INSERT INTO mps_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Te Isip bidi dabego nage sulama, te po waibao, ‘Te Abramgo we da,’ po waibao. Tama augwaligo ena ela munama, tama nage saibao. ");
INSERT INTO mps_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nago augwalibolo tama tiwai po wao, ‘Abram aga te ena abe da,’ wao. Tama po obaso da, te augwaligo dwagi yai kolesaga naga ena dali eyu, tama ena ela mugobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tama Abram te Isipba mu sabolali, tama te mu tama, te Isip bidi dabego te agai we suali, te gasa sawi yai mu asobo suali. ");
INSERT INTO mps_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tama te Isip dabego genuai polasa tuni bidi tego sę tonalubo bidi dabego te Sarai sulama, augwaligo augwa tuni bidibolo te po wali, “Te we da, te gasagi yai sawi yai we mu dao.” Tialima, augwaligo aga sigi pelama, tama tuni bidigo beba odasa pai. ");
INSERT INTO mps_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tama te genuai tuni bidigo Sarai godolo mu elama, tama agai dwagi yai kolesaga Abrambolo yali. Tama agai Abrambolo te sipsip me, meme me, bulmakau me, moni kibu donki me, te hauwa mu mobadi, tama sę ebo bidi me, sę ebo we me, te moni kibu kamel me, te tama nai Abrambolo mani. ");
INSERT INTO mps_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tiali goli, Yawego te haniani dwai gasi dabe te genuai tuni bidibolo me, te aga bede bidali we bidibolo dali tagala palama, te tuni bidigo te Sarai dali emai hagede dwai sę te wei ponoyu, tama tiai dao. ");
INSERT INTO mps_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tialima, te tuni bidigo Abram i olama, agaba asobosi, te agabolo te tiwai po hanalu wai, “Magi baso nago te tiwai kolesaga enabolo yaliwe?” te po wai. “Nago enabolo Sarai te nago we da po wabeo. ");
INSERT INTO mps_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nago te naga abe da po wali, tama tibaso te eno aga selama, te eno we tiwai bidali. Magi baso nago te kolesaga yaliwe? Naga we sao! Tama duga si piąo!” ");
INSERT INTO mps_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tialima, te polasa tuni bidigo aga bidi dabebolo po olama, tama augwaligo Abram te Isipde bidali sela sąwai. Tama augwaligo aga me, aga we dali me, te aga tigidali doado bage dali me gudulama, tama te Isip tǫ pedai sesegeba augwali dali hodobo pai, te Abram gasaba pomainogo tama yai. ");
INSERT INTO mps_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Te Abramgo doado bage hauwa elaluali. Agai te sipsip me, meme me, bulmakau me, te dila pai kapa silva gol dali si, te tama nai doado bage hauwa mu elaluai. Tialima, Abramgo te Isip bulu taga soyu, te moni tǫ pedai badu nogi Negeb, teba soai. Agai te aga we me te aga doado bage tigidali selama, tama Lot me aga dali hodobo soali. ");
INSERT INTO mps_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Tama Abramgo te Negeb tǫ nosali taga peyu, tama me pidubadi geanima, te aga te Betel hanu pedai badu sabaligi pai. Aga te aga polobadu ugwa be dabe elaluali madi, te Betel de Ai te hanu si tomoba bidigi pai. ");
INSERT INTO mps_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tama tede aga te alta sai polobadu nigali madi pelama, tama aga Yawego nogi weyu, lotu po te Yawebolo wali. ");
INSERT INTO mps_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot te Abram dali hodobo bilali. Agai te meme, me sipsip, me bulmakau te hauwa mu elaluyu, te genuai we bidi hani me elaluai dao. ");
INSERT INTO mps_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abram de Lot sigo sipsip, meme, te bulmakau bage hauwa mu elaluali, tama tiyu, te augwali si deli madi hodobo bidabo te usu meni yai. ");
INSERT INTO mps_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tama wado po te Lot de Abram augwa si hasa tonalubo sę ebo bidi dabe tomode pedelali. Te sogo te Kenan dabe me, te Peres dabe me tede bidalubadi dao. ");
INSERT INTO mps_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tialima, Abramgo Lotbolo te po wai, “Dadi si te deli kaneme si dao. Tiyu, da si wado po wabuo, tama da si go sę ebo bidi dabe augwa hasi me wado po wabuo,” Abramgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","“Suao, te genuai tǫ pedai elalubao. Te naga pedai badu bidabo madi me deli dodolama, tama nago ena taga peyu, naga teba bidigi painu te usu da. Te nage dolo nogo pedai badu painogo da, teda ena te pobase nogo pedai badu paibao. Ma, nage te pobase nogo badu painogo eyu da, teda ena te dolo nogo badu bidigi paibao,” Abramgo te po wai. Te augwa ama nami si tama po dodolali. ");
INSERT INTO mps_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tialima, Lot dolugulama, tonono bilali. Agai te tigidali tǫ malu te wę Jordan sesegedu tonono pali, te tigidali pedaiba usu nama, te Soar te pedaiba usu nigi palio. Te tǫ tigidalide te dwagi yai wę hauwa te gasa sawi yai, te Yawego Iden gide elalubo tiwai, me tama te Isip dabe tǫde elalubo tiwai elaluali. (Tama te sogo te Yawego te Sodom de Gomora te hanu si dolisiąbadi dao.) ");
INSERT INTO mps_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tama tibaso, Lot te giliga pedalubo pedai badu pelama, tama agai te wę Jordan sese badu elalubo tǫ malu tigidali sali. Tama tibaso, te augwali si hodobo ma bidibeo. ");
INSERT INTO mps_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram te Kenan tǫde bididuali. Tama Lot te Jordan malu elalubo hanu dabe tomoba bidigi pelama, tama aga bidabo ugwa be dabe te Sodom moni hanu pąba pidubadi geanima, tama munama, bidai. ");
INSERT INTO mps_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tama te hanude bidalubo we bidi dabe augwaligo te dwai sę genuai mu te Yawe gedude yalio. Te augwaligo agai bomai po te wali me pabeo. ");
INSERT INTO mps_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Te Lot pai madi, tama Yawego Abrambolo te po wai, “Nage ede dolaluyu, te nago tigidali pedaiba tonono pao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","“Te megi nago subo tǫ tigidali, te eno nagebolo mayu, tama nago nosali ame nabo hani wai dabebolo mobadi yaibao. Tama te tǫ dagego sesemane sogo mu elalua paibao. ");
INSERT INTO mps_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Te eno nago wai puluba dabe hauwa mu te masigi sane kemi tiwai pedalumainogo ilaibao. Te bidigo te masigi kemi tigidali nedebo usu yabo homu eyu da, teda agai te nago wai puluba pedalubo tigidali te nedabo usu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tialima, nage hogodama, tama biliyu, tama te tǫ tigidali nago susa bilao. Magi baso meni, te tigidali tǫ te eno nagebolo mawaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Tama tibaso, Abramgo aga ugwa be dabe gudulama, tama te bidali bulu tagalama, tama pidubadi geanima, tama aga pelama, te nosali te Hebron buluba bidigi pali, tama aga bidabo pesage te bidi Mamrego genuai ni dabe elalubo pąde te pesage nigali. Tama aga ugwa be dabe tede dodolama muyu, tama agai te Yawebolo lotu po wabo alta te bulude nigali. ");
INSERT INTO mps_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Te Abram aga te Hebron bulude tama bidalubadi, tama te bidi nogi Kedorlaomer aga te bulu Elam gavman tuni bidi dao. Tama Kedorlaomer gavman tuni bidigo te gasa gavman tuni bidi dabe tonaluali. Tama agai augwali tonalubadi, te kibu be nogo si olama, sągą badu si wai, tama sągą badu sela wagi soabo kibu bede augwaligo te Kedorlaomer gavman tuni bidigo po sela sąwani, te takis mone me mabeo. Te tuni bidi dabe e dao, Bera te hanu Sodom gavman tuni bidi da, tama Birsa te Gomora hanu gavman tuni bidi da, tama Sinap te Atma gavman tuni bidi, me Semeber te Seboim tuni bidi, tama te Bela pedai badu gavman tuni bidi me elaluali, te bulu Bela te gasa nogi me Soar elaluai. Tama te bage augwaligo te tuni bidi Kedorlaomer hagela homu eyu, agai po sela sąwani. Tialima, te nogo si olama, sągągo me si me si wabo kibu bede, te gavman tuni bidi Kedorlaomer tuni bidigo te aga abagi solo gavman tuni bidi sela i wali, Amrafel te Babilonia moni tǫ gavman bidi badi, te Ariok te Elesar tǫ gavman bidi, me Tidal te Goim tǫ gavman bidi dao. Te gavman tuni bidi dabe me si me si te augwa ami hwįbo bidi dabe palima, tama augwaligo te hasia bolo te Refaim hani bage dali, te Asterot Karnaim tede boi hwįnama, tama augwali aiyaba elaluali. Te tudibadu augwaligo te Sus hani te Ham tǫde aiyaba elalubadi, te Emgo ami hani bidi dabe te Kiriataim bulu du elalubo tǫde aiyaba elaluali. Tama te Hor dabe tego ami hani augwali te Seir bulu dude elaluama, tama augwali pobasa pidubadi, te Elparan bulu dolo te bidi meni yai buluba tagaligi palio. Nosali augwali begasa peyu, te Kades tǫba pali. Te Kadesgo poloba nogi da te e tama Enmispat wai. Tama augwaligo boi hwįani, te Amalek dabego tigidali tǫ pedai badu te boi hwįnama, te Amalek dabe aiyaba elaluali. Tama augwaligo te Amor hani dabe dali te bulu Hasason Tamar tede hwįnama, tama augwali aiyaba elaluai dao. Te boi hwįani silama da, teda te Kedorlaomer gavman tuni bidi dali, te aga abagi gavman bidi dabe dali, augwaligo te a naga bulu gavman bidi dabe augwali dali hwįgi pali, te hanu dabe nogi e tama da, Sodom, me Gomora, me Atma, me Seboim, me Bela. Te a naga hanu gavman tuni bidi augwa ami bidi dabe dali, augwali te Sidim tǫ malu odogode deliba sisinani. Tama augwaligo te Kedorlaomer dali, te aga gavman tuni bidi sela bage augwali dali boi hwįainu sisi elaluai. Tama te a naga gavman bidi dabego ami bidi dabego te gavman tuni bidi me si me sigo ami bidi dabe dali boi hwįani. ");
INSERT INTO mps_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tama te Sidim odogo tǫde te kolta sabo tǫ dedage hauwa elaluai. Tama te Sodom de Gomora gavman tuni bidi si augwa bidi dabe dali te boi hwįbaso, wi painogo homu yali, tiali goli augwali meba te kolta sabo tǫ dedage dabeba tulaluali, tama isali. Te augwaligo ami bidi dabe meba te bulu du bageba wi pai. ");
INSERT INTO mps_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tama Kedorlaomer aga abagi dabe dali, augwaligo te boi bidi dabe augwali aiyaba elaluai. Tama augwaligo te Sodomde me Gomora te hanu side te tigidali doado bage sobadi, tama augwaligo tigidali tubo nai dabe me sela pai. ");
INSERT INTO mps_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tama Lot te Abram aga amago ogwa te Sodomde me bidai, tama augwaligo aga me aga doado bage dali tigidali sela pali. ");
INSERT INTO mps_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Tiali goli, bidi me deli te boi hwįbadi wi pelama, tama aga Abram bidibo madi sabolai, Abram da aga Hibru bidi me deli da, tama agabolo te po walali. Abram te bidi Mamrego genuai ni sili elalubo pąde bidali. Te bidi Mamre te Amor hani bidi me deli da, tama aga ama si elaluali, Eskol me Aner, tama te sela augwali te Abramgo abagi dao. ");
INSERT INTO mps_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramgo po odali, te tuni bidi dabe augwaligo aga ogwa sela pali po wai. Tama agai te aga hani bomai bidi dabe naga i wali. Te augwali hwįgi pabo bidi dabe namba hauwa tama, te 318 dao. Tama augwaligo te gavman tuni bidi dabe augwa ami bidi dabe dali pobasa pali, te Dan bulu dąį igi pai. ");
INSERT INTO mps_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Te bulude te Abram aga hani si bugali. Tama te hani sigo te gavman tuni bidi hani me si me si dali augwaligo hulide hwįani, tama augwali ugwaba igulama, te augwali aiyaba elaluali. Augwaligo te boi bidi dabe augwali pobasa pali, te giliga degebo bogo badu te Damaskusba sabolama, te ela solama, te Hoba te badu usu nigi pelama, ");
INSERT INTO mps_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","tama augwaligo wi sali doado bage tigidali ma dobola sai. Abramgo te aga ogwa Lot ma sobadi, te aga tigidali doado bage me, te we dabe me, tama te Lotgo bidi hani dabe me, tigidali ma sai dao. ");
INSERT INTO mps_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramgo te Kedorlaomer gavman bidi dali, te aga abagi dabe dali boi hwįani silama, tama aga ma geasa asai. Tama te Sodom gavman tuni bidi aga Abram tiąba asali, te odogo tǫ elalubo teba sisinani, te nogi augwaligo koneai, me te Tuni Bidi Dabego Odogo Tǫ da wai. ");
INSERT INTO mps_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Tama Melkisedek, te Salem hanu tuni bidi tama God Ugwadu Mu Bidibo Bidi ofa mabo pris bidi da, te agai giguai nai bret me wain ąį Abrambolo selasa asali. ");
INSERT INTO mps_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tama Melkisedekgo dwagi yai po e tiwai te Abrambolo wali, “Eno homugo te God Ugwadu Mu Bidibo Bidigo te dagalu dali tǫ dali nigali, agai te wiegi yai sę nage dali yao. ");
INSERT INTO mps_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Dago aga nogi ugwaba sao. Magi baso meni, nago te boi bidi dabe dali hwįbadi, tama agai nage tau selama, te nago te boi bidi dabe augwali aiyaba elalualio,” te po wai. Tama Abramgo te ma dobola sali doado bage tigidali dodolama, tama nogo si badu togolama, tama Melkisedekbolo me deli pedai mani. ");
INSERT INTO mps_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tama elama, tama Sodom tuni bidigo te tiwai po Abrambolo wali, “Naga hwįyu sali nai tigidali te naga selama, tolaluao. Tiali goli, te eno hani da, te enaba ma asomainogo yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Tiali goli, Abramgo te po wali, “Yawe da, te Ugwadu Mu Bidibo God da, agai te dagalu dali tǫ si nigali. Tama eno nogo me deli ugwaba siyu, tama aga gedude te dąų wabo po wai, ‘Eno te Sodom bidigo doado bage me sogobeo, te dwasianunu nai me deli sogobeo. Eno tiyu da, teda Yawe nago ena ela muao,’ eno te dąų wabo bomai po wali. Magi baso meni, nage Sodom tuni bidi nago te po weyu, ‘Ena digi eno te Abram te doado bage hauwa elalubo bidi pedalumainu ilai da,’ po waidalio. ");
INSERT INTO mps_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ena digi te magi nai deli eno me sogobeo. Te eno hanigo tuali tubo nai da, te naga eno salio. Tama eno abagi sela, Aner dali, Eskol, me Mamre, augwaligo te doado bage me badu pedai somainao,” Abramgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nosali Abramgo na tiwai ebaso, tama Yawego agabolo te tiwai po wai, “Abram, nage wi munu me elamuo,” wali. “Eno nage te auwago bugagia mu seselalubo tiwai gilama ebao. Eno nage dali dwagi yai sę eyu, tama nage te genuai nogi elalubo bidi pedalumainu iliyu yaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tiali goli, Abramgo te po wai, “Yawe, ena hobede ya, eno Genuai Bidi, ena wai meni yai bidiyu, tama nosali isaibao. Te nago magi ilama, te ena genuai nogi elalubo bidi pedelaibawe? Te ena isibosi, te bidi me deligo te eno doado bage saibao, te Damaskus bulu bidi Elieser dao. ");
INSERT INTO mps_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nago enabolo wai me mabeo. Tama tibaso, ena isibosi, te ena sę bidi Elieser agai te ena hasegelama, tama eno doado bage tigidali somainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tiali goli, Yawego Abrambolo te po wai, “Te nage isibosi, te sę ebo bidigo nage hasegelama, te nago doado bage tigidali me sogobeo. Te nago ogwa wai mu te nago doado bage tigidali te nosali sabo bidi pedelaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tama Yawego Abram buluba odasa solama, tama agabolo po bomonama weyu, te po wai, “Nago te dagalude te hǫ dabe suao. Te nago tigidali nedebo usu yaibawe? Tialima, nago wąį dabego wai dabe augwali te hǫ tiwai umabo mu pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Tama Abramgo te po mu po naga dao homu eyu, tama te Yawego wali po aga homude dąų wai. Tama tibaso, Yawego aga doloba pai bidi nogi poai dao. ");
INSERT INTO mps_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Tama Yawego Abrambolo te tiwai po wai, “Ena Yawe dao. Eno nage i obaso, te naga bidali bulu Ur te Kaldia tǫ pedaide bidali te taga soai. Eno tama tiali, eno e tǫ nagebolo mawainogo yali, tama e tǫ nago tǫ mu pedelaibao.” ");
INSERT INTO mps_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tiali goli, Abramgo te po wai, “Te Yaweo, eno Genuai Bidi, te mena tama eno koneama, te e tǫ te eno tǫ dao po wagowe? Nago magi ilama, tama eno te tiwai koneaibawe?” ");
INSERT INTO mps_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tama tibaso, Yawego po wei ponani, “Te e tama tiwai nai dabe te enabolo selasa asao, te tamadi dilai bulmakau so te kibu be sela yai sesebadi, te meme me deli me te kibu be sela yai sesebadi, me te sipsip omai te kibu be sela yai sela asobadi, te dwasianu ba hi si sesebadi yao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tialima, Abramgo te nai tigidali selama, te Yaweba sela pali. Tama Abramgo te kibu dabe te tomode si hwągo pedama, tama te nai dabe dedelage te si badu wasi sili pali. Tiali goli, te ba si da te agai elali goli, te togobeo, sese muani. ");
INSERT INTO mps_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tama te ba kemodage meba aselama, te kibu dabe tuainogo ebaso, te Abramgo augwali ela gudulali. ");
INSERT INTO mps_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tama elama, tama te giliga degegi painu ebode te Abram aga godege pialima, te isai tiwai mu yai. Agai pilamubadi, te agai nade subo nai tiwai te moni dwai be huli mu sulama, te aga wi dwai mu eyu bidali. ");
INSERT INTO mps_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tama edubadi, Yawego agabolo tama po wali, “Mu tama koneao, te nago wąį dabego wai dabe te augwali gasa hani bidi dabego tǫde te bulu meni yai bidi dabe te bulu wau bilibo bidi dabe pedelaibao. Te augwaligo olo sę ebo bidi dabe pedaliyu, tama gasa hanigo dolobo sę ebo dologode augwali bididubadi, te bidi sese nogo si sągą si 400 kibu be tama usu naibao. ");
INSERT INTO mps_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tiali goli, eno te kolesaga ebo hani augwalibolo te eno sęgę mawaibao. Tama nago wąį te augwaligo wai dabego te doado bage hauwa mu selama, tama te bidali bulu taga paibao. ");
INSERT INTO mps_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tiali goli, te sę esiąbadi, te nage digi te nage homu nagame bugagia elama, bidiyu elama, te nage monu dabe mu elama, te nage isibaso, tama augwaligo nage pubulaibao. ");
INSERT INTO mps_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Te nago wąį dabe augwali te e tǫba polo ma asogobeo. Te megi ede bidalubo Amor hani augwaligo te dwai kolesaga hauwa me isiąbadi. Te nosali mu te Amor hani augwaligo dwai sę ela silai digi, teda eno augwali dolobo sę elama, tama augwali ela gudulaibao. Tama te sogo, nosali mu, te nago wąį hani dabe augwaligo wąį hani dabe tama pedalubode, te sogo augwali ma begasa aselama, e tǫde bugagia bidaibao,” Yawego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Te giliga dega sigi pelama, tama be hulia sali, tialima polo tama te baket tiwai nai me deli pedelali, tama tede hano eyu, sia bogoli eyu yai. Tama te nai aga digi tama te Abramgo dodolali hasa hani si tomodu bilibo suali. ");
INSERT INTO mps_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Te side digi tama te Yawego tau sabo bomai po Abram dali dąų weyu, tama agai tama po wali, “Te eno te e tǫ tigidali te nago nosali ame nabo bulai wai, te hani dabe augwalibolo mawaibao. Tama te tǫ dąį te wę sesedu te Isip dabe tǫ pedai badu gagalasa, te genuai wę Yufretis teba saboligi paibao, moni tǫ mu. ");
INSERT INTO mps_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Te augwaligo te Kin dabego me, te Kenis dabe me, te Katmon, te augwaligo tǫ sobadi, ");
INSERT INTO mps_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","tama Hit dabe me, te Peres dabe me, Refaim dabe, ");
INSERT INTO mps_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","te Amor dabe me, te Kenan me, te Girgas me Jebus, te tama hani bidi dabe augwali tǫ saibao. Eno tama po mu dąų obao,” Yawego Abrambolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Te Sarai, Abramgo we, agai wai meni yai. Tiali goli, agai sę ebo Isip we me deli bidali, aga nogi Hagar. ");
INSERT INTO mps_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tama Saraigo Abrambolo tama po walali, “Nago koneani, Yawego eno tabi paliama, tama eno wai me ame nogobeo. Nage eno sę ebo we dali pigi pao. Te agai eno wai me deli ame naibao,” wali. Tialima, Abramgo aga we Saraigo wabo po odai, usu da wai. ");
INSERT INTO mps_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tama Saraigo sę ebo te Isip we Hagar selama, tama aga te Abram aga we tiwai selama, bidali. Abram te Kenande kibu be nogo si bidai elalubadi, tama te sę pedelali. ");
INSERT INTO mps_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tialima, Abram te Hagar dali pilama, tama Hagar haliga yali. Te Hagar aga haliga elalubo konebo sogo, agai te Sarai dali hagoma yali. ");
INSERT INTO mps_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tama Saraigo Abrambolo po bomo elama weyu, te po wali, “Hagargo ena dali hagoma ebao. Te tiabo page naga digi yali. Mu tama, ena digi te ena sę ebo we te nagebolo mani. Tiali goli, megi aga koneani, te aga haliga ebaso, te agai ena dali hagoma ebao. Yawego digi te da si dagalumainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramgo po wei ponani, “Odao. Hagar te naga sę ebo we dao. Te nago aga tonalubao. Te nago mena sę agabolo yainu, te homugo tiao,” wali. Tama Saraigo te Hagar dali boi bidi elama dwai sę ebaso, tama Hagar wi palio. ");
INSERT INTO mps_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar te bidi meni yai pedai badu te Sur pabo sunumidu pai. Aga te wę ulu tubo madi dulalubadi, te Yawego Ensel Mobo Bidi te agaba pedelali. ");
INSERT INTO mps_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Tama Mobo Bidi Enselgo agabolo tama tiwai po wali, “Hagar, te Saraigo sę ebo we, nage menadu aselama, tama nage menaba painogo ebawe?” Tama Hagargo po wei ponoyu, te po wali, “Sarai aga da, te ena tonalubo we dao, tama eno te Sarai taga soyu, ena wi sobao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tama Mobo Bidi Enselgo te po wai, “Nage Sarai pageba ma geasa pelama, tama agai po tigidali wali pao.” ");
INSERT INTO mps_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nosali agai po ma weyu, te po wai, “Te eno nago hani wąį te wai dabe hauwa umabo pedelama, tama bidi dabe augwaligo nedainogo ebo usu me egobeo.” ");
INSERT INTO mps_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tama Mobo Bidi Enselgo po ma wali, “Te dwasianu sogo pąde tama nago te wai ogwa ame naibao. Tama nago aga nogi Ismael poao. Magi baso meni, nage sęgę elalubadi, tama Yawego nago gela wabo odai. ");
INSERT INTO mps_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tiali goli, nago wai da, te uni yowi tiwai bidaibao. Te agai tigidali bidi dali boi bidi eyu, tama tigidali bidigo agabolo boi bidi eyu yaibao. Te aga deli kaneme dabe dali te bugagia homu nagame elama, me bidigobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagargo te homu yai, ‘Sesemane sogo Godigo ena sudu geyu, tama megi eno aga suali, tiali goli, te ena bidibo ula me elaluba, isibeo,’ te homu yali. Tama agai te agabolo po wali Yawe nogi gasa me wali, “Nage da, te ena subo God dao.” ");
INSERT INTO mps_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tama te tialigo naga, te bidi dabego te wę ulu asobo te Kades de Beret tǫ si tomode suali, augwaligo te nogi poali, “Te ena subo Bidibo Ula Elalubo Bidigo wę ulu dao,” tama nogi poali. ");
INSERT INTO mps_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tama nosali Hagargo te Abramgo wai ogwa ame nani, tama Abramgo aga nogi Ismael poai. ");
INSERT INTO mps_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tama te sogo Abramgo kibu be te 86, te tama kibu be elalubadi dao. ");
INSERT INTO mps_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Te Abram te kibu be bidi sese a naga wabo pąde, te kibu be 99 elalubadi, tama Yawe agaba pedelama, tama te po wai, “Ena te Tigidali Bomo Elalubo Bomai God dao. Eno po sesemane sogo wali piduao. Tama nage dolasa bugagia bidiyu, tama nagede po me meni yai elalumainu eyu, bididuao. ");
INSERT INTO mps_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Te nage dali eno dwagi yai tau sabo bomai po dąų wali po, tede eno megi usu da po weyu, tama nagebolo menama, tama eno nago hani wai dabe te umabo hauwa pedalumainu ilaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tialima, Abram aga basi giluama, tama aga gesabidi tǫba pubaligiluali. Tama Godigo agabolo tama tiwai po wai, ");
INSERT INTO mps_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Te enade da, te eno nage dali te tama tiwai dwagi yai tau sabo bomo yai po dąų waibao, te nage umabo hauwa we bidi hanigo wąį monu pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nago nogi megi te Abram ma wagobeo. Megi nago nogi te Abraham waibao. Magi baso meni, eno nage te umabo hauwa we bidi hanigo wąį monu pedalumainogo ilali. Tama tibaso, eno te nogi nagebolo mobao. ");
INSERT INTO mps_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Te eno nago wai hani dabe te hauwa pedalumainu elama, tama meba te gavman tuni bidi pedelaibao. Te nago hani wai dabe te umabo hauwa hani mu pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Te eno nage dali me, te augwali nosali pedalubo hani dabe dali me, te eno dwagi yai tau sabo bomai po dąų walobao. Ena da, nago God me, te ena nago nosali pedelabo hani wai dabe augwaligo God me dao. Te dąų wali bomai po da, te sesemane bidada pabo sogo elalua piduaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te nage megi e bulu wau biliyu, te e bidibo tǫ da, te eno nagebolo, me te nago hani wai dabe nosali pedalabo bage augwalibolo maiabo tǫ dao. Tigidali te Kenan tǫ dabe da, te sesemane sogo dagego tǫ elaluaibao, tama ena da, ena te nago wai puluba hani dabego God bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Tama Godigo Abrahambolo te tiwai po wai, “Te nagede, nage badi, te nago hani wąį dabe augwali badi, te dage tigidaligo eno dwagi yai tau sabo bomai po dąų wali te wali piąo. ");
INSERT INTO mps_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dagego eno te dąį ilali bomai po wali pao. Dagego te duga hani bidi tigidali te tigiwali togoiąo. ");
INSERT INTO mps_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Dagego te duga ame nabo ogwa wai dabe tigidali tigiwali togobo sę te a naga olama, me badu sela wabo side silibo si, te tigiwali togwao. Tama dagego te duga sę ebo bidi dabe augwaligo tigiwali me togwao, te tigidali sę ebo bidi, te augwa ida duga bede ame nani sę bidi, me te digibulu bulude abelali sę ebo bidi dabe tigidali, te augwali tigiwali me togwao, te nosali pedalubo ogwa wai dabe augwalide me tama eyu, bidada piduao. Te dąį ebo da, te eno dage dali dąų wabo bomai po te dao. Mu tama dao. Dagego duga bidi dabe tigidali te tigiwali togoiąo. Tama te dąį ilali te duga tigide elalubo, te bidi dabe augwaligo koneama, te eno dwagi yai tau sabo dąų walali po te bomo sesemane sogo elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Te bidi me deligo hagela homu eyu, tama augwaligo aga tigiwali togosiąbaso da, te agai eno bomai dąų wali po sela sąbao. Tama tibaso, te bidi aga te aga hani dali hodobo me bidilamuo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Tama Godigo Abrahambolo te po wai, “Nago naga we nogi Sarai nosali me nogigio. Megi agai nogi Sara dao. ");
INSERT INTO mps_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Te eno Sara wiegi yai tau sabo po menama, tama agai nago ogwa me deli ame naibao. Te eno Sarabolo wiegi yai homu elama, dwagi yai tau sabo po mayu, tama aga te we bidi hauwa hanigo auwa mosi pedelama, tama meba te gavman tuni bidi pedelama, bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Te Abrahamgo God genuai nogi mabo eyu, tama Abraham basi giluama, tama aga gesabi te tǫba mu pogulali. Tama aga gisugu weyu, tama homu yali, ‘Te bidigo kibu be te bidi sese a naga, te 100 kibu be yai elalubadi da, te aga wai ame nabo usu dawe? Tama Sarago kibu be bidi sese me si me si olama, nogo si, te 90 kibu be yai madi, te agai wai ame nabo usu egowe?’ ");
INSERT INTO mps_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tama Abrahamgo Godibolo te po wai, “Eno homugo nago te Ismael me bugagia tonalumainu ebao. Tiyu, aga bugagia bidaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tiali goli, Godigo te po wai, “Awe. Tiali goli, nago we Sarago te wai ogwa me deli ame naibao, tama nago aga nogi Aisak poao. Te eno aga dali, me te aga hani wai dabe dali, te dwagi yai tau sabo bomai po dąų waibao. Te dąų wabo bomai po te sesemane sogo bomo elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nago enabolo te Ismael me bugagia tonaluao wali. Teda eno tama tiaibao. Te eno agabolo wiegi yai tau sabo po mawaibao. Tama tiyu, eno agabolo te wai puluba hauwa menama, tama eno agai wai puluba hani te umabo mu pedalumainu ilaibao. Te aga te nogo si olama, sągągo si tobolu bidigo aya pedaliyu, tama eno agai hani wai dabe te genuai mu pedalumainu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tiali goli, e tobage sogo te nosali kibu bede te Sarago nago wai ogwa te Aisak ame naibao, tama eno aga dali naga te dwagi yai tau sabo bomai po dąų walaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Godigo te tama po Abraham dali ola silama, tama aga ugwaba holoyu, tama pai. ");
INSERT INTO mps_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tialima, te sogo digi polo tama Abrahamgo Godigo po wali pelama, tama agai hanide tigidali bidi te gasa tigiwali togwali. Agai aga ogwa Ismael tigiwali togobadi, tama aga sę ebo bidi dabego tigiwali me togwai. Te sę ebo bidi meba augwa idago te Abrahamgo bede ame nani, tama meba agai te gasa bulude abelai bidi te augwali tigiwali togwai dao. ");
INSERT INTO mps_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abrahamgo kibu be te bidi sese a naga wabo pąde deli, te 99 kibu be elalubadi, te aga ogwa Ismaelgo kibu be te nogo si olama, sągą badu sela kibu be yai madi, tama augwaligo augwali si tigiwali togwai dao. ");
INSERT INTO mps_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Augwaligo te augwali si tigiwali te deli sogode naga togwai. ");
INSERT INTO mps_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tama augwaligo Abrahamgo tigidali sę ebo bidi dali tigiwali togwalio, te Abraham me Ismael hodobo, te meba augwa idago te Abrahamgo bede ame nani, tama meba agai te gasa bulude abelai bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nosali Yawe te Abraham bidibo madi, te bidi Mamrego genuai ni dabe elalubo digi, teba pedelali. Te giliga sesane mu ebaso, tama Abraham te aga ugwa be sunumi mabode dulaludai. ");
INSERT INTO mps_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Agai tonono pobadi, tama bidi sela dolalubo suali. Agai augwali sulama, tama aga ugwa be tagalama, tama udada pelama, augwali pageba sabolali. Aga kidu sugunu gulama, tama aga gesabi te tǫba mu pogiluama, ");
INSERT INTO mps_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","tama agai te po wai, “Genuai bidi dedeo, dagego usu da wida, eno dage tau saio. Dagego eno be ela solamuo. Ena dagego sę ebo bidi dao. ");
INSERT INTO mps_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Te eno bidi me deli i olama, te wę sela asama, dage sągą wę telamainu yaibao. Dage te ni pagede toma tuyu, dulaluiagameo. ");
INSERT INTO mps_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Te eno dage bomo ilabo nai meba sela menama, tama nosali duga ma piagameo. Dage eno beba aselama, tama eno dage tau saio,” wali. Tama augwaligo te po wali, “Te wiegi yai dao, nago tama tiwai te po wabo gilama yao.” ");
INSERT INTO mps_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tama Abraham te ugwa beba polo pelama, tama Sarabolo wagi pali, “Nago te wiegi yai plaua hauwa selama, tama taluama, polo begelama, tama bret ulao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Tialima, Abraham udulama, te bulmakau bidalubo oboba pelama, tama te ogwa bidi te nisali bulmakau me deli sali. Agai te bulmakau te sę bidi me delibolo menama, tama sę bidigo elama, sisi elama, tama ulali. ");
INSERT INTO mps_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Te kibu mi delama, te Abrahamgo te kibu mi, me te ili, me ame pę, me ame pęgo nigali nai sis meba me selama, tama agai te bidi selabolo mani. Augwaligo te nai tudubadi, tama Abraham te ni dologode te augwali pąde dolaluali. ");
INSERT INTO mps_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Augwaligo nai tula silama, tialima augwaligo Abrahambolo hanalu wali, “Nago we Sara menade bidibowe?” Tama Abrahamgo tobo wali, “Aga te ugwa be tomode bidibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tialima, augwali me deligo te po wali, “Nosali te kibu be me deli silama, tama naga we Sarago wai ogwa me deli ame naibao, tama mu tama ena ma asaibao,” wali. Sara te bidi tudibadu te ugwa be sunumi pąde bidai, tama agai te po wabo odali. ");
INSERT INTO mps_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham de Sara augwali si te monu dabe, mosi dabe yai, tama Sarago te wai ame nabo usu egobeo. ");
INSERT INTO mps_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tama aga homude digi te homu elama, gisugu weyu, tama po wali, ‘Ena da, mosi dabe yalima, tama eno da, wai ame nabo usugobeo. Tama eno bidi me monu dabe yalio. Magi ilama, te eno te wai ame neyu, tama tede wiegi yai homu pemene yaibawe?’ Te homude po wai. ");
INSERT INTO mps_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Tama Yawego Abrahambolo hanalu wali, “Magi baso Sarago gisugu weyu, tama po wali, ‘Te ena mosi dabe yai madi, te magi ilama eno te wai ame naibawe?’ ");
INSERT INTO mps_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Te eno magi sę me ebo usugobewe? Nosali kibu bede, te mani bodolude, te sogo asama, te Sarago wai ogwa ame nai madi, tama ena ma asaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tama Sara wi ebaso, tama agai tibo po weyu, te po wai, “Eno gisugu me wabeo,” wali. Tiali goli, Yawego te po wai, “Menio! Nago gisugu walio.” Te po wali. ");
INSERT INTO mps_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tama te bidi sela hogodama, palio. Tama Abrahamgo te augwali pabo sunumidu dwasianu tama aga augwali dali pai. Tama augwali pelama, meba me sabaligi pelama, tama augwali doligi pelama, tama Sodom hanuba aba tonononaluali. ");
INSERT INTO mps_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tama Yawego tama homu yali, ‘Te genuai sę eno yainogo ebo, te eno Abrahambolo geme dualubo te usugobe da,’ te po wali. ");
INSERT INTO mps_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","‘Te agai hani wai dabe te augwali genuai bomai hani pedelaibao. Tama tigidali tǫde bidalubo we bidi augwaligo enabolo hanaluyu, te eno wiegi yai sę augwalibolo eyu, tama dwagi yai po augwali dali wao po waibao, te eno Abraham dali wiegi yai sę elama, dwagi yai po wali gilama tiaibao. ");
INSERT INTO mps_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Eno aga sa muani, te agai aga wai pulubabolo me te aga wąį dabe augwalibolo olama, te augwaligo eno po wali pomainogo yaibao. Tama tiyu, augwaligo wiegi yai doloba pai kolesaga wali paibao. Tama tiyu, te eno agabolo te tigidali sę agabolo eno wali po gilama yaibao.’ ");
INSERT INTO mps_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tialima, Yawego te po wali, ‘Te haniani dwai sę mu dabe te Sodom de Gomora hanu side pedalubo walio. ");
INSERT INTO mps_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Te ena aiyaba dulama, te augwaligo mena sę ebowe naga sugulaibao. Te eno odali po, te mu po yaliwe naga, tama eno sugi pelama, koneaibao,’ te homu yali. ");
INSERT INTO mps_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Nosali te bidi si hogodama, tama Sodom hanu pali. Tiali goli, Yawe te Abraham dali bidai. ");
INSERT INTO mps_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Tama Abraham te Yawe pąba pelama, tama agai Yawebolo tama po hanalu wai, “Te mu tama, nago te dwagi yai bidi dabe te dwai sę yali bidi dabe dali si, augwali dolomainu yaibawe? ");
INSERT INTO mps_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Te wiegi yai bidi dabe 50 te genuai hanude bidibadi yaibaso da, te nago augwali me te gasa bage dali dololaibawe? Nago te genuai hanude te wiegi yai bidi dabe te 50 bidi bidibaso, augwali tobade hanu elalumainu sula tagalubo usugowe? ");
INSERT INTO mps_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nago te wiegi yai bidi dabe augwali te dwai bidi dabe augwali dali elainu ebo. Te wiegi yai egobeo. Nago tama tiwai me elamuo. Tiyu, te wiegi yai bidi dabe te dwai bidi dabe augwali dali dolabuo. Te dwai mu dao. Nage da, te tigidali tǫ pedaide po tų odobo bidi dao. Nago te doloba pai kolesaga wali pomainogo egobewe?” Abrahamgo te po hanalu wali. ");
INSERT INTO mps_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tama Yawego te tiwai po wei ponai, “Te eno te 50 wiegi yai bidi te Sodom hanude bidibo subaso da, teda augwali tobade eno te tigidali we bidi bidimainu sula tagaliyu, tama te wiegi yai bidi dabe hagaidali weyu tama tiaibao.” ");
INSERT INTO mps_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tialima, Abrahamgo po ma wali, “Genuai Bidio, nago eno te po hauwa wabode wado po wabo homu me elamuo. Ena olo bidi naga dao. Eno magi nai po deli me wagobeo. ");
INSERT INTO mps_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tama te 50 doloba pai bidi meniyu, tama 45 bidi naga elalubaso da, teda nago te hanu tigidali dolaibawe, ma meniwe?” Tama Yawego te po wai, “Te eno 45 naga doloba pai bidi elalubo subaso da, teda eno te hanu me dologobeo.” ");
INSERT INTO mps_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tama Abrahamgo po ma wai, “Te doloba pai bidi te 40 naga bidibaso da, te tama magi yaibawe?” Tama Yawego te po wali, “Te eno wiegi yai bidi te bidi sese si subaso da, teda augwali tobade eno te hanu me dologobeo.” ");
INSERT INTO mps_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tama Abrahamgo te po wali, “Genuai Bidio, nago wado po olamuo. Eno po ma wainogo ebao. Te tobage bidi te bidi sese deli olama, nogo si naga elalubaso da, magi yaibawe?” Tama Yawego te po wali, “Te eno wiegi yai bidi te bidi deli olama, nogo si bidibo subaso da, teda eno te hanu me dologobeo.” ");
INSERT INTO mps_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Tama Abrahamgo po ma weyu, te po wali, “Genuai Bidio, nago wado po eno te po hauwa obaso wagio. Te bidi sese deli wiegi yai bidi elalubaso da, magi yaibawe?” Tama Yawego te po wali, “Te eno bidi sese deli te doloba pai bidi subaso da, teda augwali tobade eno te hanu me dologobeo.” ");
INSERT INTO mps_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tama Abrahamgo te po wali, “Genuai Bidio, nago wado po olamuo. Eno po me deli ma simaniyu obao. Te nogo si doloba pai bidi naga bidibaso da, magi yaibawe?” Tama Yawego te po wai, “Te doloba pai nogo si bidi bidibaso da, teda augwali tobade eno te hanu me dologobeo.” ");
INSERT INTO mps_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yawego te Abraham dali po ola silama, tama aga palio. Tama Abraham aga beba ma geasa pai. ");
INSERT INTO mps_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Te bidi Lot te we bidi sisinibo pesagede te Sodom hanu genuai sunumi elalubo madigi bididuai, tama piode te mobo bidi ensel si teba pedelai. Lotgo te bidi si asobo sulama, tama aga hogodama, augwali si pąba pai. Aga te bogoli sugunu pogiluama, tama aga gesabidi te tǫba mu pogulama, ");
INSERT INTO mps_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","tama agai te po wai, “Abagi, dage si aselama, duayagasu bolo yao,” te po wali. “Dage si eno beba asiąo. Dage si sągą bolo wę tedelama, tama dage si megi hulide ede piagameo. Tama kigamu duga si hogodama, pagameo.” Tiali goli, augwali sigo po wei ponoyu, te tiwai po wali, “Menio. Da si te bede me pigobeo. Te da si e bidi sisinibo pesagede piaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tiali goli, Lotgo augwali si dali anoma mu idubadi genama, tama nosali augwali si aga dali beba pali. Tama Lotgo te bo disiąwai te yis meni yai bret ulubadi, te augwali si wiegi yai nai sisi ilama, mani. Tama augwali sigo te nai tuali. ");
INSERT INTO mps_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Te Lot aga abagi si pisąbadi, tama te Sodom bidi dabego te be bobogela sagasali. Te hanude bidaluali tigidali bidi dabe asali, te gesi bidi dali, te monu dabe dali asai. ");
INSERT INTO mps_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Augwaligo Lotbolo i olama, tama tiwai wali, “Te bidi si aselama, te nage dali te hulide bidibo, te bidi si mena bidibawe? Te augwali si buluba dinao. Te dago augwali tąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tama Lot te buluba teda solama, tama aga sobadi sunumi paliali. ");
INSERT INTO mps_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tama agai te po wai, “Abagi dede, dagego odiąo. Dagego te dwai kolesaga igimio. ");
INSERT INTO mps_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Eno wegi si bidibao, tama augwali si te bidi dali me pisąbadi dao. Eno augwali si dageba odasa buluba asaibao, tama duga magi homu ebo te augwali side siliagameo. Tiali goli, te bidi si da, te eno abagi si, tama augwali si eno bede bididubadi, tama eno augwali si bugagia te ena tonaluaibao. Tama tibaso, dagego dwai sę augwali side me igimio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tiali goli, augwaligo te po wali, “Nage bulu wau bilibo bidi, nage gedao! Nago dago ebo kolesaga dagaligio. Te nage geda sisąwani da, teda dago augwali side dwai sę eyu, tama nage me te gisiga mu yaibao.” Tama augwaligo Lot te be tomoba edaba pogoliyu, tama augwaligo te be sunumi aluainu yali. ");
INSERT INTO mps_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tiali goli, te be tomode bidali bidi sigo te be tų dalama, tama nogo buluba dįnama, tama Lot be tomoba kegali, tama augwali sigo te be sunumi paliali. ");
INSERT INTO mps_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Nosali augwali sigo te tigidali bulubadu bidaluali bidi dabe augwali gedu paliali. Tama gedu widai bage tiwai osogo bidiyu, tama augwaligo te be sunumi gegabo usu me isiąwai dao. ");
INSERT INTO mps_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Tialima, te bidi sigo Lotbolo hanalu wali, “Te nago hani meba te hanude bidalubawe? Nago te naga ogwa dabe dali, wegi dabe dali, te wegi sabo wąį dabe me, te tigidali badi, te nago ede bidalubo gasa hani dali tigidali selama, tama dagego te hanu taga piąo. ");
INSERT INTO mps_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Te da si go te hanu dolaibao. Yawego te bidi dabego dwai kolesaga ebo po odama, tama augwali dolomainu agai da si tagala palai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tialima, Lot te aga wegi si noma sali bidi aga wąį si bidibo madi pai. Tama agai te po augwali sibolo wagi pali, “Dage si hogodama, te hanu polo taga soao,” wali. “Yawego te bulu dolainogo ebao.” Tiali goli, augwali sigo homugo agai te gagali po wabo homu naga yai. ");
INSERT INTO mps_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Te be posai madi, tama te mobo bidi ensel sigo te Lot seliyu, tama po wali, “Asesa yao! Te naga we dali, naga ede bidibo wegi si dali selama, tama e hanu taga piąo. Tiyu, dage te gasa we bidi dabe dali haga yabuo.” ");
INSERT INTO mps_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Augwali sigo po wabode, tama Lot polo asesa me pabe. Tiali goli, Yawego Lot homu dene eyu tau sainogo yali. Tama tibaso, te bidi sigo te Lot aga me, te aga we me, aga wegi si dali, augwali nogo tulama, tama augwali sigo augwali odasa te hanu buluba dilanio. ");
INSERT INTO mps_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Te mobo bidi ensel sigo te augwali bulubadu dilama, tama mego te po wai, “Dage wi piąo. Tiyu, dage isabuo! Dagego tudiba begelama, ma tonogio. Tama dage te malu elalubo madi toma me nenamuo. Te dage udada pelama, te bulu duba ugwa holali da, teda dage me isigobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tiali goli, Lotgo te po wali, “Genuai Bidio, eno homugo hagela homu ebao. ");
INSERT INTO mps_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Odao! Nago ena homu dene mu elama, tama nago ena tau siyu, wiegi yai sę yai. Tiali goli, te bulu du digibulu mu elalubao. Te ena polo sabalogobeo. Tiyu, te hanu doliyu, te ena dali hagawaibao. ");
INSERT INTO mps_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nago ude te elalubo dwasianu hanu suao. Te pąde elalubo, tama ena teba polo sabalubo usu yaibao. Te dwasianu bulu naga dao. Nago ena teba pomainogo eyu da, te ena me isigobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tama mobo bidi enselgo te po wali, “Te me usu dao. Teda te hanu eno me dologobeo. ");
INSERT INTO mps_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Te polo pao! Asesa yao! Eno magi sę deli isiąbadi, dage te hanuba sabolaibao,” wali. Lotgo te po wai, te hanu da te dwasianu hanu da, tama tibaso augwaligo te hanu nogi Soar poai dao. ");
INSERT INTO mps_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Te giliga aselama pedalubo sogo, Lot te dwasianu hanu Soar teba sabaligi palio. ");
INSERT INTO mps_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tama Yawego digi te posolo yai masigi, me te sia dali te Sodom de Gomora hanu siba te dagaludu aiyaba tula palali. ");
INSERT INTO mps_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tama Yawego te hanu si dali, te malu tǫ me, te hanu side bidali we bidi tigidali badi, tama te tǫde pedelali nai tigidali te siago delama, mu dolalio. ");
INSERT INTO mps_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Tiali goli, Lotgo we te Lot tudibadu wali asudu, tama agai tudiba ma begelama tonani, tama aga tede isalima, tama aga tigi te gelali ni page tiwai elalualio, tama te tamugo aga mu mesegelali. ");
INSERT INTO mps_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Te kigamu digi mu Abraham te Yawe dali dolalu polobadu te po miani pesageba palio. ");
INSERT INTO mps_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Abrahamgo te Sodom me, Gomora me, te tigidali tǫ odogo maluba aba tonono bilalio. Tama agai te hano pedalubo suali, te genuai sia hano tiwai pedalubo sualio. ");
INSERT INTO mps_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Godigo te tigidali malu tǫde elaluali hanu dolali. Tiali goli, agai te Abrahamba homu kone palama, tama agai te Lot dali, te aga bidali hanu dali, te me dolobeo. Te dolobo sę ebogo te Lot polobadu bidali hanu dabe mu dola silalio. ");
INSERT INTO mps_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Te Lot te Soarde me bidibo wi yai. Tama tibaso, aga te bulu duba te aga wegi si dali holali. Tama augwali te ola be me delide bidai. ");
INSERT INTO mps_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tama gomunai wegigo tomo wegibolo te tiwai po wai, “Te da sigo aya monu dabe megi ebao,” wali. “Tama te tigidali tǫ pedaide te da si sabo bidi menio. Te da sigo wai magi ilama ame naibawe? ");
INSERT INTO mps_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Te dena ayago hani te silidali weyu, te tama tinao! Te da sigo dena si aya te bomai ąį wain tumainu menama, tama aga tobolu gęǫ ilaibao. Tialima, da si aga dali pagela pilama, tama agade wai ame naibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tama hulide augwali sigo te wain wę augwa ayabolo menama, tama aga tobolu gęǫ yali. Tama gomunai wegi aga dali piali. Tiali goli, waingo te aya gęǫ mu ilama, tama agai te tiali sę me konebeo. ");
INSERT INTO mps_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Te me sogo side gomunai wegigo tomo wegibolo te po wali, “Te do hulide ena aya dali piali. Te e sogo hulide da sigo te aya tobolu gęǫ yabo sę ma ilaibao,” wali. “Tama nage aga dali te eno yali gilama piagameo. Tama tilama, da sigo agade wai ame naibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tialima, te sogo hulide te augwa si aya te wain menama, gęǫ ma ilali, tama tomo wegi aga dali pialio. Augwa si aya te tobolu mu gęǫ page elama, te polobadu yali tiwai ma yali, tama te sę yali te agai me konebeo. ");
INSERT INTO mps_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Te tama tiali kolesagade te wegi si augwa si aya Lotde digi, te augwali haliga yalio. ");
INSERT INTO mps_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tama gomunai wegigo te ogwa ame nani, te ogwa nogi Moap poai. Te we bidi hanigo wai nogi Moap nogi poai dao. ");
INSERT INTO mps_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tama tomo wegigo me te ogwa ame nani, te ogwa nogi Benami poali. Te bidi da, te Amon we bidi hani dabego wąį monu dao. ");
INSERT INTO mps_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Te Abraham te Mamre tede bidali taga peyu, te Negeb moni tǫ pedai te badu pelama, tama aga te bulu si Kades me Sur, te bulu si tomode bidali. Aga te Gerar hanude te aga we Sara dali bidai. ");
INSERT INTO mps_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Tama te we bidi augwalibolo te tiwai po wai, “Sara te eno abe dao.” Tama Abimelek, te Gerar hanu tonalubo genuai bidi, agai te sę bidi meba tagala palama, tama augwaligo Sara agaba odasa asai. ");
INSERT INTO mps_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tiali goli, hulide God te Abimelekba nade pedelama, tama te po wai, “Sara te Abrahamgo sai we dao. Tama nage isaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tiali goli, Abimelek te Sara pąba pisąbadi tialio. Tama agai te po wai, “Genuai Bidio, te bidi deligo dwai sę me isiąbadi da, teda nago aga ela muaibawe? Nago eno hani bage me ela muaibawe? ");
INSERT INTO mps_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham aga digi te tiwai po enabolo wai, ‘Te aga eno abe dao,’ wali. Tama we aga digi me te po wai, ‘Aga eno abe dao,’ wali. Te eno homude dolo da homu ebaso, tama tialio. Eno dwai sę ebeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Te nade Godigo te tiwai po wei ponani, “Awe, eno koneani, te nago homude dolo homu ebaso, nago tama tiali. Tama koneabaso, eno nage te we pąba pigi pisąma emainu elama, tama enabolo dwai sę idali homu yai. ");
INSERT INTO mps_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tiali goli, megi nago te we aga bidiba ma tagala palao. Te bidi aga te eno po pusubo bidi profet dao, te agai gedu haluasa po weyu da, te nage me isigobeo. Te nago te we ma tagala palisiąwani da, teda nage me, te naga bidalubo tigidali we bidi dali, mu isila paibao,” Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Te sogo kigamu digi mu Abimelekgo aga sę ebo bidi tigidali i olama, tama augwalibolo te sę yali po tigidali augwalibolo pusali. Tama augwali wi dwai mu yalio. ");
INSERT INTO mps_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Tama Abimelekgo Abraham i olama, aga aselama, tama agai agabolo hanalu wali, “Nago mena tiwai kolesaga dabolo yaliwe? Nago te tibo po dabolo weyu, tama ena badi, te eno tonalubo we bidi augwali badi, da tigidaligo nago wede moni sęgę sali. Eno nagede mena dwai sę hasia bolo ebaso, tama nago te sę wei ponoyu, da dali tama tialiwe? Waa? Nago te yali kolesaga te dolo ebeo. ");
INSERT INTO mps_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Magi baso nago tama tialiwe?” wali. ");
INSERT INTO mps_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tama Abrahamgo po wei ponoyu, te po wai, “Polobadu eno te tama homu yai, ‘Te e bulu bidi dabe augwali te Godide wi isiąbowe,’ te homu yai. ‘Tiyu, augwaligo ena ela munama, tama eno we saiba,’ homu yalio. ");
INSERT INTO mps_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Tama mu tama, Sara te ena abe dao. Te da si go aya deli, tiali goli te aga ida tedali. Tama eno aga sai dao. ");
INSERT INTO mps_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Polobadu te ena ayago bede bidibadi, tama Godigo ena tagala palobaso, te ena gasa buluba pali. Tama eno Sarabolo te tiwai po wai, ‘Nago te tiwai wiegi yai kolesaga naga enade yao,’ wai, ‘Te da si pabo madi tigidali pedaide nago te tama weyu, “Abraham te ena abe da,” po wao,’ te po wai dao,” Abrahamgo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tialima, Abimelekgo Sara te Abrahambolo ma mawai. Tama agai te sipsip meba badi, bulmakau me, sę ebo bidi me, sę ebo we me, te Abrahambolo manio. ");
INSERT INTO mps_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Tama agai Abrahambolo tama po wai, “Suao. Te tigidali tǫ te eno dao. Te nage me badu pedai badu bidabo homu ebaso da, te nago sę dao.” ");
INSERT INTO mps_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tama agai Sarabolo te po wali, “Eno te mone umabo, te mone 1,000 mone silva, te nago abebolo mani. Te tialigo te po isilalio. Te augwaligo mu koneama, te nago dwai sę ebeo po waibao,” Abimelekgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Yawego te Abimelekgo hanide te tigidali we sibi haliga palia silama, te augwaligo wai ame nabo usu isiąwani. Agai tama tiali, te Abimelekgo te Abrahamgo we Sarabolo yali, te kolesaga wei ponoyu, tama tialio. Tama Abrahamgo Godibolo gedu haluasa po olama, tama Godigo Abimelek usu ma ilali. Tama Godigo Abimelekgo we me usu ilibadi, te aga sę ebo we dabe dali usu ilama, tama augwaligo wai ame nabo usu ma yai dao. ");
INSERT INTO mps_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Te Yawego agai polobadu dąų walali po wali peyu, tama agai wiegi yai olo tau sabo kolesagago te Sara dali dwagi yai sę yali. ");
INSERT INTO mps_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tama tiyu, Sara haliga elama, ogwa ame nani, te sogo Abraham monu dabe yai madi dao. Sarago te wai te polobadu Godigo agabolo te bodolu mani sogo tama naga ame nanio. ");
INSERT INTO mps_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Tama Abrahamgo te Sarago ame nani ogwa nogi Aisak poalio. ");
INSERT INTO mps_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nosali te a naga olama, me badu sela sogo wali bidama siligi pabode, tama Abrahamgo Godigo po wali peyu, tama te ogwa Aisakgo gasa tigiwali bo togwalio. ");
INSERT INTO mps_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamgo digi kibu be bidi sese a naga, te 100 yia elalubadi, tama Sarago te Aisak ame nai. ");
INSERT INTO mps_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tama Sarago te po wai, “Godigo wiegi yai kolesaga enabolo ebaso, tama ena wiegi yai homu pemene eyu, tama ena gisugu obao. Tama tigidali bidigo te tiali po odobaso, te augwaligo wiegi yai homu pemene ena dali hodobo yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tama Sarago po ma wai, “Polobadu bidi mego e tiwai po Abrahambolo wabo usu meni yai, ‘Nago we Sarago te wai ame nenama, tama agabolo ame mawaibao,’ wabo usu meni yai. Tiali goli, megi Abraham monu dabe yai digi, tama eno agai wai ogwa te ame nanio,” Sarago te po wai. ");
INSERT INTO mps_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tama te wai Aisak genuai igulali. Tama aga te ame tubo tagalubo sogode Abrahamgo genuai nai ulalio. ");
INSERT INTO mps_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hagar te Isip bulu we, agai te Abrahamgo ogwa me deli polobadu ame nani, te Ismael dao. Tama te genuai nai tuali sogode Sarago suali, te ogwa Ismaelgo agai waibolo dwai gisugu mabo suai. ");
INSERT INTO mps_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tama agai Abrahambolo te po wai, “Nago te sę ebo we aga ogwa dali si sela sąyao. Te olo sę ebo wego waigo te nago doado bage bugulama, me badu me sogobeo. Te doado bage tigidali te eno wai Aisakgo nosali saibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ismael mu te Abrahamgo wai, tama tibaso te pogo Abraham homu sęgę mu ilali. ");
INSERT INTO mps_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tiali goli, Godigo Abrahambolo walali, “Nago homu sęgę te sę ebo we Hagar aga ogwa dali tede igio. Nago te Sarago po wali pao. Te Aisakde naga te nago wąį hani wai dabe nosali pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tama eno te sę ebo we Hagargo waigo wąį hani wai dabe, augwali me te genuai hani pedalumainu ilaibao. Magi baso meni, aga me nago wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Do kigamu mu te Abrahamgo te nai dali, te wę botol dali sisi elama, tama Hagarbolo mani. Abrahamgo te nai dabe te Hagar nageba anugulama, tama aga dali aga ogwa dali si ibaba olo tagala palali, gasaba. Tialima, Hagar palima, te Berseba tǫ pedai badu subigila te bidi bidisiąwai madi biliduai. ");
INSERT INTO mps_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nosali te botolde wę sia sobaso, tama agai te ogwa te dwasianu ni dologode bididubadi taga soali. ");
INSERT INTO mps_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tama aga digibulu gana duagi pelama, homu kone palali, ‘Eno te wai isibo subo te ena hagelabo,’ te homu yai. Aga tede dulaludubadi, tama ogwa gela walio. ");
INSERT INTO mps_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Godigo te ogwa gela wabo odali. Tama Godigo mobo bidi ensel te dagalude bidiyu, tama i olama, Hagarbolo te po wai, “Magi yaliwe, Hagar? Nage wi me elamuo. Godigo te ogwa aga bidibo madide gela wabo odalio. ");
INSERT INTO mps_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nage hogodasa pelama, te ogwa auwa sigi pao, tama nago pagea sao. Magi baso meni, eno te agai wai hani dabe te genuai hani pedalumainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Tama Godigo Hagar gedu pedelali, tama agai te wę ulu me deli pedalubo suai. Tama aga pelama, te wę botolde tugi pai. Tama te wę agai te ogwabolo mani, tama agai tuali. ");
INSERT INTO mps_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Tama nosali God te ogwa Ismael dali bidibaso, tama aga genuai yai. Aga te Paran pedai badu te bidi dabe bidisiąwai madi bidali. Tama aga te bulu hasa gegebo konebo bidi mu pedelalio, te enesigi enebo sę agai mu konea pali. ");
INSERT INTO mps_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Tama aga idago aga we me deli te Isip bulu we selama, aga ogwa mani. ");
INSERT INTO mps_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Te sogo Abimelek te aga ami bidi tonalubo polalubo bidi Fikol dali, augwali si te Abraham bidibo madi pelama, tama po wai, “Te tigidali sę nago ebode te God nage dali bidibo dao. ");
INSERT INTO mps_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tialima, nago te God gedude po dąų walao, te nago enabolo me, te eno wai puluba dali me, te eno wąį hani dabe dali me, te tibo po wabo kolesaga me egobeo, te po wao. Eno wiegi yai kolesaga nagebolo yai. Tama tiwai naga nago te tibo sę isiąbo wiegi yai homu kęą pali kolesaga enaba ebadi, te nage megi bidibo tǫde bidibo we bidi me te tiwai kolesaga yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tama Abrahamgo te po wali, “Eno tama tiwai po dąų walobao.” ");
INSERT INTO mps_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Tama Abrahamgo Abimelek dali te aga sę ebo bidi dabe augwaligo agai ulu wę anoma bomonama sali po elalualio. ");
INSERT INTO mps_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tama Abimelekgo tobo wali, “Te tama tiali eno konebeo. Nago enabolo polobadu me wabeo. Megi naga eno te po odobao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tama tibaso, Abrahamgo te sipsip me bulmakau meba te Abimelek mawai, tama augwa si tomode po dąų walai. ");
INSERT INTO mps_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Tama Abrahamgo aga sipsip hani tomode te a naga olama, me badu si, tama sipsip sou wai selama, tama me badu tedali dagalama, muani. ");
INSERT INTO mps_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Tama Abimelekgo agabolo hanalu wali, “Magi baso nago tama tebawe?” ");
INSERT INTO mps_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tama Abrahamgo po wei ponoyu, te po wai, “Nago te sipsip wai a naga olama, me badu si, te nago sao. Te tebo kolesagade nago hanilama, te ena digi eno te wę ulu nigai da po omainogo ebao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Augwa si te bulude po minama, dąų wai. Tama tibaso, te bulu nogi augwaligo Berseba nogi poai dao. ");
INSERT INTO mps_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Augwa si te Bersebade po minama dąų olama, tama Abimelek aga ami tonalubo polalubo bidi Fikol dali, te augwali si te Filistia tǫba ma geasa pai dao. ");
INSERT INTO mps_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Tama Abrahamgo te Bersebade te polo isisąbo ni me deli bulama, tama agai Yawego nogi weyu, gedu haluasa po wai, te aga sesemane sogo bidada peyu, bidada pabo God dao. ");
INSERT INTO mps_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tama Abraham te Filistia dabego tǫde sesabi gana elama bidalio. ");
INSERT INTO mps_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nosali Godigo Abraham usu sali. Agai Abraham agabolo i olama, te tiwai po wai, “Abraham o!” Tama Abrahamgo te po wai, “Ena e bidibao.” ");
INSERT INTO mps_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tialima, Godigo te po wali, “Nago ogwa deli digi te elalubao, Aisak, tama nago aga godolo mu ebao. Nago te wai odasa, nage te Moria te pedai badu pao. Te eno bulu du me deli nagebolo ola mawaibao. Tama te bulu dude nago te Aisak enabolo ofa mayu, te augwaligo ofa eyu, te siago domainu ulubo tiwai yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tialima, kigamu digi mu Abrahamgo te moni kibu donki me sisi elama, te Aisak sobadi, te aga sę bidi me si dali sali. Agai te ofa yabo bagawai isi meba sobadi elama, tama agabolo te Godigo po wali pesageba palio. ");
INSERT INTO mps_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tama digibulu palima, te sela wabode Abrahamgo suali, te bulu du digibulu me elalualio. ");
INSERT INTO mps_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tama agai te sę bidi sibolo te po wai, “Dage si ede te kibu donki dali bididuao,” wai. “Te ena u badu te wai dali pelama, tama da si tede lotu wagi paibao. Tama nosali da si ma asaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Tama Abrahamgo te ofa yabo sia te Aisakbolo menama, tama agai tolai. Tama Abrahamgo sia dage dali, hwą ge dali tolali. Tama augwa si palio. ");
INSERT INTO mps_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Te augwali si pelama gana, tama Aisakgo te po wai, “Ayao!” Tama Abrahamgo te po wali, “Magi yaliwe, ogwao?” Tama Aisakgo agabolo hanalu wali, “Ayao, eno te sia dage me te ulabo sia da sigo sela soabo subao, tiali goli te ofa yabo sipsip te mena bidibowe?” ");
INSERT INTO mps_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Tama Abrahamgo po wei ponoyu, te po wai, “Ogwa, te Godigo digi te sipsip gegela mawaibao.” Te po olama, tama augwali si palio. ");
INSERT INTO mps_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Augwali si te Godigo po wali pesageba sabolama, tama Abrahamgo te alta sai masigigo nigilama, tama sia ugwadu daide dodolama muani. Tama agai aga ogwa Aisak te bonogo nogo sągą duanio. Tama agai aga te alta te isi daiba muai. ");
INSERT INTO mps_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tialima, Abrahamgo te hwą ge selama, tama aga ogwa elainu yali. ");
INSERT INTO mps_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Tiali goli, Yawego Mobo Bidi Ensel te dagalude bidiyu, tama i wali, “Abraham! Abraham!” Tama Abrahamgo te po wai, “Ena e bidibao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tama Mobo Bidi Enselgo te po wali, “Nago te wai elamuo. Nago magi sę me deli aga dali me igio. Nago ogwa deli naga elalubadi, tama nago aga yogo eyu, dąų me wabeo. Tama tibaso, eno koneani, nage te Godigo po odobo bidi dao,” Yawego Ensel Mobo Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tama Abrahamgo tonono bilibadi, tama sipsip omai me deli suali, te aga gąų te dwasianu ni nologo abe sai ni nologode habela sai elaluali. Aga pelama, tama te sipsip sigi pai. Agai elama, tama tigidali siaba ulalio. Tama tiyu, agai te ofa Godibolo mawai. Tama te sipsipgo te Aisakgo pesage hasegelai dao. ");
INSERT INTO mps_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tialima, Abrahamgo te bulu nogi poali “Yawego mawaibao.” Tama bidi dabego megi tama me te po wabo, “Yawego aga bulu dude te sǫą pabo nai mawaibao.” ");
INSERT INTO mps_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tialima, Yawego Mobo Bidi Enselgo te Abraham si sogo i bomonama weyu, te po wai, ");
INSERT INTO mps_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Yawego te tiwai wali, ‘Te ena nogide digi eno mu dąų walai bomai po obao. Nago naga te deli naga elalubo ogwa me yoga sabeo. Tama tibaso, mu tama, eno nage dali wiegi yai sę mu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Eno te tiwai po obao, te eno nago hani wąį dabe te wai puluba hauwa mu, te dagalude hǫ, me te tamu ąį sanede masigi kemi tiwai hauwa mu pedelaibao. Tama nago wąį hani wai dabe augwaligo te boi bidi dabe augwali aiyaba mu elaluama, tama augwaligo doado bage mu saibao. ");
INSERT INTO mps_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tama tigidali tǫde bidalubo bidi hanigo ena hanalu, te augwali dali dwagi yai sę yao po weyu, te nago wąį hani dabe dali dwagi yai sę yali te tiwai yao po waibao. Magi baso meni, nago eno po wali palio,’ Yawego te po wali,” Mobo Bidi Enselgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tama Abraham dali, Aisak dali si aga sę bidi si bididuali madi ma pelama, tama augwali te Berseba teba ma pali. Tama Abraham te Bersebade bidali. ");
INSERT INTO mps_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Nosali Abrahamgo te tiwai po odali, “Milkago te wai meba ame nani po wai.” Milka te Nahorgo we, tama Nahor te Abrahamgo ama dao. ");
INSERT INTO mps_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Te e da te wai dabe augwali nogi e dao, Us te gomunai bidi, tama Bus, me Kemuel, aga te Aramgo aya dao, ");
INSERT INTO mps_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","tama Keset, me Haso, me Pildas, me Jitlap, me Betuel. ");
INSERT INTO mps_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel te aga te we Rebekago aya dao. Milkago te Nahor tego ogwa te a naga olama, me sela ame nani, te Nahor te Abrahamgo ama dao. ");
INSERT INTO mps_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Te Nahor aga dali bidali gasa we me nogi da, te Reuma, agai ame nani ogwa te Teba, me Gaham, me Tahas, me Maka, te tama ame nai. ");
INSERT INTO mps_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Te Sarago kibu be te 127 kibu be bidama, ");
INSERT INTO mps_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","tama aga te Kiriat Arba, te gasa nogi Hebron, te Kenan pedai badu tede isai. Tama Abrahamgo te Sarade homu dene mu ebaso, aga tigi osogo muani madiba hogonigi peyu, tama agai aga we hagede gela wai. ");
INSERT INTO mps_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Te gela uduama, nosali Abrahamgo aga te we Sara tigi munalubadi osogo taga peyu, tama aga pelama, te Hit hani we bidi dali po migi peyu, te hanu sunumiba pai. Agai te po wali, ");
INSERT INTO mps_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ena te bulu wau bilibo bidi ede bidibaso, tama eno be tede me elalubeo. Eno te dage tomode te gų page nigabo tǫ pedai me badu mu abelama, tama eno we tede muainogo obao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tama Hit hani bidi dabego te po wai, ");
INSERT INTO mps_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Woo, genuai bidio, nago dago po odao. Nage te da tomode bidibo genuai tobolu bidi deli dao. Nago we te dago wiegi yai gų pagede pubulao,” wali. “Te da me deli te dago te nago we pubulainu te gų page sainu ebaso, te dago me yogo eyu, dąų me wagobeo. Menio.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tama Abraham dolalu, tama aga tobolu te bulu page we bidi gesabiba aga tobolu aiyaba basi gulai. ");
INSERT INTO mps_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Tama agai te po wai, “Te dagego eno we te badu pubula po weyu, usu da po obaso da, teda dagego te bidi mebolo waiąo, Efron te Sohargo ogwabolo hanalu wao. ");
INSERT INTO mps_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Eno te ola be augwaligo te nogi weyu, te Makpela nogi yali, te eno abelaibao. Te Efrongo tǫ sesege pedai badu elalubao. Te dagego agabolo olama, te dage tigidali gedude te ola be agai enabolo momainu yaibao. Te eno agabolo te mone dolo bugagia mayu, tama dagego tǫ tomode te gų page eno gų page mu elaluaibao,” Abrahamgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efron aga me te Hit bidi dabe bidalubo tomode te hanu sunumi elalubo pąde te po mibo pesagede augwali dali bididuai. Te Hit bidi dabe tigidali bidalubadi, tama augwaligo odali, te Efrongo Abraham dali te tiwai po wei ponani, ");
INSERT INTO mps_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Mu menio, genuai bidi. Eno po odao. Te eno te tǫ pedai tigidali me, te ola be gų page dali elalubo, te eno nage olo mu mawaibao,” po wai. “Te ena hani gedude te megi eno nagebolo menama, te nago we tede pubulagameo.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tama Abrahamgo aga tobolu te bulu page we bidi augwaliba basi gulai. ");
INSERT INTO mps_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Tama augwaligo odali, agai Efronbolo te tiwai po wai, “Nago po wali dao. Teda eno te tǫ pedai tigidali abelaibao. Nago eno mone sao, tama eno ena we te tǫde pubulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Tama Efrongo te tiwai po Abrahambolo wei ponani, ");
INSERT INTO mps_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Genuai bidio, nago odao. Te tǫde mone te 400 mone silva masigi dabe dao. Tiali goli, tagala, te da si tomode olo bage tiwai elalubao. Te nago we tede pubulao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamgo te usu da olama, tama aga mone te bisnis bidi dabego ebo kolesaga tiwai elama, bugula muani. Te Hit bidi dabe augwaligo te Efrongo te tǫde mone te 400 mone silva masigi nogi yali po wabo odali. Tama Abrahamgo te dobolama, tama Efron agabolo manio. ");
INSERT INTO mps_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Te kolesagade Abrahamgo te Efrongo tǫ te Makpela te badu elaluali tǫ mu sai dao. Te tǫ pedai te giliga asobo badu te Mamrede elaluali, tama Abrahamgo te ola be dali, te tǫde elaluali tigidali ni dabe dali abelai dao. ");
INSERT INTO mps_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Te Hit bidi dabe tigidali te po mibo madi bidali bidi dabego koneani, te tǫ megi da te Abrahamgo tǫ mu da walio. ");
INSERT INTO mps_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nosali Abrahamgo aga we Sara te ola be gų page te Makpela tǫde pubulai dao. Te tǫ bulu Mamre pąde dao, te augwaligo megi gasa nogi wabo Hebron, te Kenan tǫ pedai badu tomode elalubao. ");
INSERT INTO mps_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Te tama tiyu, tama Hit bidi hani dabego tǫ, te gų page ola be elaluali dali, te Abrahamgo gų page tǫ mu gagawai dao. ");
INSERT INTO mps_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Te Abraham te monu dabe mu yalio. Tama Yawego agai tigidali yali sęde te wiegi yai tau sabo sę eyu, tama Abraham bugagia mu bidali. ");
INSERT INTO mps_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Tama Abrahamgo aga sę yali monu dabe bidi i wali. Te bidigo te Abrahamgo doado bage tigidali tonalubo bidi da. Abrahamgo agabolo te po wali, “Naga nogo guni sisu muyu, nago dila pai po ena dali dąų walao. ");
INSERT INTO mps_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nago te Yawego nogide te po bomo yai po dąų wao, te dagalu de tǫ dali sigo God dao, te tama tibaso, nago eno ogwago we te Kenan tomode we dabe me te noma sigio, te ena e bidibo tǫde. ");
INSERT INTO mps_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Nage te eno page buluba ma begasa pelama, tama ena hani tomode digi te we me deli gegelama, tama aga noma selama, tama eno ogwa Aisakgo somainu yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tiali goli, te sę bidigo te po wai, “Te wego te aga bulu taga soabo hagela homu eyu, te ena dali e buluba asabo homu isiąbaso da, teda magi yaibawe? Ma, te eno nago ogwa te naga page buluba tagala palagawe?” ");
INSERT INTO mps_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tama Abrahamgo po wei ponoyu, te po wai, “Woo, nago te eno ogwa te eno page buluba munu me tagala palamuo! ");
INSERT INTO mps_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, te dagalude bidibo Godigo ena te eno ayago bede, me te ena hani dabego tǫde selama, asali. Tama agai bomai dąų wabo po wali, te agai e elalubo tǫ te eno hani wąį dabebolo mawaibao wai. Yawego digi te aga mobo bidi ensel te nage pabodu polasa tagala palaibao. Tama tibaso, nago tede te eno ogwago we gegela sueibao. ");
INSERT INTO mps_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tiali goli, te we nage dali asisąbaso da, teda nago enabolo te dąų wali po te pogo nage dali munu me kęalugobeo. Tiali goli, nago eno ogwa te eno page buluba me odasa pelamuo.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tialima, sę ebo bidigo nogo guni sisu muyu, aga genuai bidi dali bomo yai po dąų wai. Agai po dąų waliyu, te Abrahamgo agabolo ya wali sę tigidali agai mu yaibao po walio. ");
INSERT INTO mps_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tama sę ebo bidigo te Abrahamgo te nogo si kibu kamel me te maiabo wiegi yai nai hauwa sali. Tama agai te tigidali doado bage sisi ilama, tama te Nahor bidibo bulu te Mesopotemia teba palio. ");
INSERT INTO mps_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aga digibulu pelama, teba sabolama, tama agai te kamel dabe te wę ulu pąde te bulu sesege badu pila mumainu yalio. Agai tama tiali, te we dabe augwaligo te wę tuagasobo sogo te be pio ebadi dao. ");
INSERT INTO mps_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Agai tama tiwai gedu haluasa po wali, “Yaweo, eno genuai bidi Abrahamgo God, nago eno sę megi wiegi yai ilao,” wai. “Nago te eno genuai bidi dali megi dwagi yai tau sabo sę emainogo eyu, tama ena tau mao. ");
INSERT INTO mps_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ena e ulu ąį tubo pąde bidibadi, tama e bulu page wegi mani te augwali asama, wę tuagasaibao. ");
INSERT INTO mps_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Te eno wegi ogwa me deli dali te tiwai po waibao, ‘Ae, nago genuai botol aiyaba munama, te ena wę dwasianu tuaio,’ po waibao. Tama agai te po olama, ‘Nage te wę tuao, tama te eno nago kamel dabe me te wę mawaibao,’ tama obaso da, teda eno homugo nago sę bidi Aisakgo sabo we te tama da po waibao. Tama te tiwai pedalubaso da, teda eno koneyu, nago te eno genuai bidi dali dąų wali tau sabo po te mu tama usu nubao po waibao,” te tiwai gedu haluasa po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Sę bidigo te tiwai gedu haluasa po odubadi, tama Rebeka sabolalio. Agai te wę sabo botol aga nagede tolasa asali. Rebeka te Betuelgo wegi dao. Tama Betuel te Milkago ogwa dao, aga te Nahor tego we, te Abrahamgo ama dao. ");
INSERT INTO mps_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Te wegi ogwa we te gasa sawi yai mu tonani, tama aga te bidi dali me pisąwai. Tialima, aga te wę ulu tugi soyu, aiyaba dulama, tama edaba ma holalio. ");
INSERT INTO mps_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tama te sę bidi aga pageba udulama, tama te po wai, “Ae, nago te botol węgo enanu dwasianu tuaio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Tama Rebekago te po wai, “Genuai bidi, nage tuao.” Tama polo agai te botol wę aiyaba mugulama, tama nogogo tolalubadi, tama aga tumainu yalio. ");
INSERT INTO mps_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Agai te wę tula silibo si, tama Rebekago po ma wai, “Te eno nago kamel dabe me wę menama, te augwali tulama, usu elama, pągąmainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tama polo agai te botol ąį habuge te masigi ąį gamia te kibu kamel dabego ąį tubo madi gelali. Tama aga ma udulama, te wę geninama sigi pedu geani, te tigidali kamel usu elama, mu pągąmainogo yai. ");
INSERT INTO mps_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tama te sę bidigo po me wabeo. Agai tonalu naga yalio. Agai koneainu, Yawego te agai sę wiegi yai ilibowe naga koneainogo, tama tialio. ");
INSERT INTO mps_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Te kamel dabego wę tula silibo si, tama Abrahamgo sę bidigo agai te ring gol te gasa sawi yai mu selama, tama te Rebekago guniba muanio. Tama agai te golgo nigai nogo mo si te Rebeka nogoba holali. ");
INSERT INTO mps_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Tama agai te po wai, “Ae, nago enabolo walao. Nage te dego wegi dawe? Tama magi yaliwe? Te nago ayago be habu te usu yabo elalubawe, te ena eno hani dali bidabo madi te po obao.” ");
INSERT INTO mps_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Tama Rebekago te tiwai po wei ponani, “Ena te Betuelgo wegi da, aga te Nahor me Milka te bidi de we sigo ogwa dao. ");
INSERT INTO mps_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Awe, te kamel dabe pibo pesage wiegi yai elalubo, tama augwali tuabo nai me elalubao. Tama be dąį togwali habu me elalubo, tama dage tede bidiagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tialima, Abrahamgo sę bidigo aga kidu sugunama, tama Yawebolo lotu po walio. ");
INSERT INTO mps_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Tama agai te po wai, “Dago Yawe nogi ugwaba sao, te eno genuai bidi Abrahamgo God dao. Agai te eno genuai bidibolo dąų wali po te mu usu nanio, te aga dwagi yai tau sabo kolesaga ebo me, te Abraham dali homu kolesaga kęą pai bidi kolesaga ebo me, te Yawego tagalobeo. Yawego te eno genuai bidi aga amago hanigo beba dolo ena sela asama, tagalagasali dao,” tama wali. ");
INSERT INTO mps_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tialima, te wegi ogwa we aga udulama, te aga idago beba palima, tama tede bidali bage augwalibolo te tigidali sę yali po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Tama Laban, te Rebekago abe, agai te ring gol me, te golgo nigai nogo mo si me, te aga gunide walali me, te nogode holali suali. Tama agai odali, te bidigo yali sę po tigidali Rebekago pusali. Tama aga udayu, te bedu buluba teda solama, tama aga te Abrahamgo sę bidi me bididubo madi saboligi pai, aga te aga kamel dabe dali te ulu wę tubo pąde dolaludai. ");
INSERT INTO mps_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Tama Labango te po wali, “Abagio, Yawego te wiegi yai sę te nage dali yalio. Magi baso nage te bulude dolaludubawe? Da si beba pinao. Eno nage bidabo pesage dodolalio. Tama te kamel dabe me bidabo pesage usu yai elalubao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tialima, te sę bidi aga dali pelama, te be tomoba pai. Tama Labango po aga sę bidibolo obaso, augwaligo te kamel dabego tudide munasa asali walu dabe sela munama, tama augwaligo te nosai me nai te augwali mani. Tama augwaligo wę te Abrahamgo sę bidi aga hani dali teba selasa pelama, te augwali sągą wę telamainu yalio. ");
INSERT INTO mps_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Augwaligo nai sela asali, tiali goli sę bidigo te po wali, “Eno nai asena polo tugobeo. Eno hasiabolo po pusaibao.” Tama Labango te po wai, “Te usu dao. Nago po weyu bolo yao.” ");
INSERT INTO mps_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tialima, sę bidigo te po wali, “Ena te Abrahamgo sę bidi dao. ");
INSERT INTO mps_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawego eno genuai bidibolo wiegi yai mobo menama, tama aga genuai bidi nigilali. Yawego agabolo nai hauwa mani, te e nai dabe dao, sipsip, meme, bulmakau, silva me gol, sę bidi me, sę ebo we me, kamel me donki, te tama doado bage hauwa mawai dao. ");
INSERT INTO mps_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tama aga we Sara aga te mosi dabe yai madi te aga ogwa ame nai. Tama eno genuai bidigo tigidali doado bage aga te ogwabolo mawai dao. ");
INSERT INTO mps_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Agai enabolo po bomo elama weyu, te po wai, ‘Nago eno ogwa we te Kenan dabe augwali tomode te we munu me gegelamuo. Menio. Nage pelama, tama eno hani, te eno ayago hani tomode digi, tede te we me deli gegelama, tama eno ogwa Aisakgo somainu yao,’ wai. Agai tama po obaso, tama eno te po wali peyu, tama ena aga dali po dąų wai. ");
INSERT INTO mps_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Tama eno ena genuai bidibolo tama tiwai po wai, ‘Tama te we ena dali ma asobo hagela homu ebaso da, teda magi yagawe?’ ");
INSERT INTO mps_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tama agai te po wai, ‘Ena te Yawego po wali pabo bidi dao. Te agai aga mobo bidi ensel te nage dali tagala palama, tama nago sę wiegi yai bugagia ilaibao. Te nago eno ogwago we me deli te eno ayago hani tomode sesaibao. ");
INSERT INTO mps_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Te nago tama tibaso da, teda te dąų wali pogo te nage me kęalugobeo. Te nage eno haniba pelama, tama augwaligo nago po obadi usu da po wasiąyu da, teda te tiwai naga eyu, te dąų wali pogo nage me kęalugobeo,’ Abrahamgo enabolo te po wai.” ");
INSERT INTO mps_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Megi e tama side, te bubugade ena te wę ulu elalubo madi pedelama, dolaludu, tama eno te tiwai gedu haluasa po oduali, ‘Yawe, te eno genuai bidi Abrahamgo God, nago eno sę te wiegi yai ilao,’ po wali. ");
INSERT INTO mps_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","‘Megi ena te wę ulu tubo pąde bidibao. Tama te wegi ogwa we me deli te wę tuagasu asobode, teda eno te tiwai po agabolo waibao, “Ae, nago te botolde wę enanu dwasianu menama, ena tuaio.” ");
INSERT INTO mps_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Tama agai te po wabosi, “Nage tuao,” olama, “tama eno nago kamel dabe me wę mawaibao,” obaso da, teda eno homugo te we naga te nago sa muani we dao, te eno genuai bidigo ogwago we da homu yaibao.’ ");
INSERT INTO mps_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Eno gedu haluasa po udubadi, tama Rebeka sabolali. Agai te wę tubo botol te aga nagede tolasa, tama aga te wę ulu tugi soyu, aiyaba dulalio. Tama agabolo eno te po wali, ‘Ae, nago węgo enanu dwasianu menama, ena tuaio,’ te po wali.” ");
INSERT INTO mps_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Tama polo agai te botol wę aiyaba mugulama, tama nogogo tolaluyu, tama po wai, ‘Genuai bidi, nage tuao,’ wai. ‘Tama eno nago kamel dabe me wę mawaibao,’ wai. Tama ena wę tuali silibo si, tama agai te kamel dabe me wę mani. ");
INSERT INTO mps_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Tama eno aga hanalu wali, ‘Nage dego wegi dawe?’ Tama agai te po wai, ‘Ena te Betuelgo wegi dao, aga te Nahor tego ogwa, aga ida Milka dao,’ te wegigo te po wai. Tama eno aga gunide te ring waliyu, te nogo side mo holiyu yai. ");
INSERT INTO mps_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tama eno kidu sugunama, te eno Yawebolo lotu po wali. Tama eno Yawe nogi ugwaba sali, te eno genuai bidi Abrahamgo God. Agai te ena genuai bidi aga amago hanigo beba dolo ena odasa asai. Tama eno te wegi ogwa we gegali, te eno genuai bidigo ogwago sabo we sualio, te eno genuai bidi aga amago ogwago wegi dao. ");
INSERT INTO mps_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Megi te dagego te dwagi yai tau sabo kolesaga me, te homugo kęą pai kolesaga me, te eno genuai bidibolo yainogo homu eyu da, teda dagego po waiąo. Tama dagego homugo hagela homu ebaso da, teda dagego enabolo olama, tama ena homugo digi te mena sę yainu te ena tiaibao,” Abrahamgo sę bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban me Betuel augwali sigo po wei ponoyu, te po wai, “Yawe aga digi te sę pedalumainu yali. Te dago po meni. ");
INSERT INTO mps_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka te bidibao. Nago aga selasa, tama naga pao. Aga te nago genuai bidigo ogwago somainao, te Yawego wali po tiwai gilama emainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Te Abrahamgo sę bidigo te augwaligo wabo po odama, tama aga tobolu te tǫba basi gulama, tama aga Yawebolo lotu po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Tama tilama, nosali aga te haniani au dobage te silva me gol me, te gasa sawi yai gudubo ugwa me sobadi elama, te Rebekabolo mawai. Agai te haniani gasagi yai sawi yai dila pai nai dabe te Rebeka aga abebolo mobadi, te aga idabolo me mayu yai. ");
INSERT INTO mps_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tama te po ola siminama, tama Abraham aga sę bidi aga hani dali te augwali nai tuyu, wę tuyu elama, tama augwali piali. Tama kigamu digi augwali hodaluama, tama Abrahamgo sę bidigo tama po wai, “Ena te ena genuai bidi bidiboba ma paibao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tiali goli, Rebeka aga ida de aga abe sigo te po wai, “Te wegi ogwa we da dali te nogo si sogo bidimainu elama, tama nosali aga pomainu yaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tama Abrahamgo sę bidigo te tiwai po wei ponai, “Dagego ena dąų ola sigimio. Yawego eno sę wiegi yai ilama pedelai. Ae, te ena genuai bidi bidibo madi ma painu ebao.” ");
INSERT INTO mps_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tama augwaligo te tiwai po wai, “Dago te wegi ogwa we i olama, tama agabolo te aga homu kolesaga hanaluinao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tialima, augwaligo Rebeka i olama, asobosi, tama augwaligo aga hanalu wai, “Nage te bidi dali paibawe?” Tama agai te po wai, “Awe, te ena paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tama tibaso, augwaligo augwa abe Rebeka aga tonalubo we dali augwali si te Abrahamgo sę bidi aga hani dali pomainu tama tagala palai. ");
INSERT INTO mps_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tama Rebekabolo wiegi yai sę pedalumainu eyu, augwaligo te tiwai wai, “Abe, dena homugo te nage umabo bidi mugo ida pedelaibao. Te nago wąį hani augwaligo te augwa boi bidi aiyaba elaluama, tama augwaligo hanu dabe somainao” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tama Rebeka dali, aga sę ebo wegi ogwa we dabe dali, augwali hogodama, tama augwali te kamelba duagulama, tama augwali te Abrahamgo sę bidi wali pai. Tama sę bidigo Rebeka oda selama, tama augwali te digibulu buluba pabo gagalali. ");
INSERT INTO mps_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Te Abrahamgo sę bidi agai te we gegeyu, tama digibulu mu peyu, digibulu ma asu, tama tibadi, te Aisak agai te bidi dabe augwali bidisiąwani badu taga soali, augwaligo te bulu nogi poali ‘Te ena subo Bidibo Ula Elalubo Bidigo wę ulu.’ Te nogi poai. Tama aga pelama, te Negeb pedai badu bidigi pai. ");
INSERT INTO mps_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Te nosali me sogo be pio ebode aga te nosai elalubo digi pebeli dilide biliduai, tama agai te kamel meba aselabo suali. ");
INSERT INTO mps_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tama Rebekago Aisak sulama, tama aga te kamel daide dulaluali tagalama, aiyaba dulai. ");
INSERT INTO mps_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Tama agai te Abrahamgo sę bidibolo hanalu wai, “Te mena bidi da tiąba asobawe?” Tama sę bidigo te po wai, “Te eno genuai bidi dao.” Tama tibaso, Rebeka aga tobolude elaluali ugwa namego te aga gesabidi au palia sai. ");
INSERT INTO mps_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tama ma sabolama, tama te sę bidigo agai yali sę po tigidali te Aisakbolo pusali. ");
INSERT INTO mps_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tama Aisakgo Rebeka te aga ugwa beba odasa pelama, tama agai aga salio. Aisakgo te Rebeka godolo mu elama, tama aga homu wiegi yai ma yali. Polobadu te aga ida isibaso, tama aga homu dene eyu, homu sęgę elaluai dao. ");
INSERT INTO mps_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamgo gasa we me sali nogi te Ketura dao. ");
INSERT INTO mps_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Te wego ame nani ogwa wai dabe te Simran, Joksan, Medan, Midian, Isbak me Sua, tama dao. ");
INSERT INTO mps_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan te Seba de Dedan sigo aya pedelai. Tama te Dedango wai dabe te augwali hani wąį dabe te Asur hani, te Letus hani, me Leum hani, te augwa aya Dedango wąį dabe te tama dao. ");
INSERT INTO mps_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tama te Midiango ogwa dabe te e tama elaluai, Efa, Efer, Hanok, me Abida, me Elda. Te tigidali hani sibi wąį augwa auwa mosi te Ketura dao. ");
INSERT INTO mps_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham aga isabode, te aga nai me tigidali doado bage te Aisakbolo naga mena silai. ");
INSERT INTO mps_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tiali goli, aga bidibo sogo digi, te agai doado bage meba te aga gasa wego wai puluba augwaliba olo mani. Tama agai augwali te giliga pedalubo pedai badu tagala palama, te aga ogwa Aisak bidibo digi te augwali digibulu bidigi pomainu yali. Tama augwali pelama, te giliga pedalubo bulu te badu bidigi pai dao. ");
INSERT INTO mps_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham te kibu be umabo te 175 kibu be bidai. ");
INSERT INTO mps_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Aga te monu dabe mu elama isibaso, tama augwaligo aga pubulali. Tama aga te aga polobadu isali wąį dabe augwali dali ma sisinanio, tama wabo. ");
INSERT INTO mps_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Aga ogwa si te Aisak me Ismael sigo aga pubulali, te gų page dedage page te Mamre, te badu te Makpela ola be gų page te giliga pedalubo badu muani. Polobadu te tǫ pedai te Sohargo ogwa Efrongo tǫ, aga te Hit bidi hani me deli dao. ");
INSERT INTO mps_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrahamgo te tǫ te Hit bidi dabe dali abelai. Augwaligo Abraham te aga we Sara polobadu pubulali madide, te tǫ pedai badu pubulai. ");
INSERT INTO mps_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham isai digi, tama Godigo aga ogwa Aisak dali dwagi yai tau sabo sę yai. Aisak te wę ulu me deli pedalubo madi pąde bidali, te augwaligo nogi yali ‘Ena subo Bidibo Ula Elalubo Bidigo wę ulu.’ ");
INSERT INTO mps_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Te e da, te Ismaelgo wąį hani dabe e dao. Ismael te Abrahamgo ogwa te Hagargo ame nani. Hagar te Isip we me deli, te aga Sarago olo sę iduai we me deli bidai dao. ");
INSERT INTO mps_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Tama Ismaelgo wai dabe nogi te gomunai waide gagalama, te ogwa bidi wai dabeba siminigi paibao, Nebaiot te Ismaelgo gomunai ogwa nogi, nosali te Kedar ame nani, Atbel, me Mipsam, ");
INSERT INTO mps_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO mps_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Jetur, Nafis, me Kedema. ");
INSERT INTO mps_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Te augwali Ismaelgo ogwa dabe tama te augwali nogi dabe dali, te bulu dabe te tǫ pedai me te augwaligo pesage nigilama bidali, te nogi dali dao. Tama augwaligo tobolu bidi dabe te nogo si olama, sągągo si elaluali, tama nogo si olama, sągą si hani bidi dabe bidali. ");
INSERT INTO mps_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael te kibu be hauwa 137 kibu be bidama isibaso, tama augwaligo aga pubulali. Tama aga te aga polobadu isali wąį nǫų dabe dali deliba sisinama, bidigi pai dao, tama wabo. ");
INSERT INTO mps_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Te Ismaelgo hani wąį dabe augwali te tǫ pedai Havila me Sur te tomo agebele side bidaluali. Te bulu te Isip pąde te Asur teba pabo sunumi te giliga pedalubo pedai badu elaluai. Te Ismaelgo hani augwaligo te haniani hani dali boi bidi homu ebaso, tama augwali digibulu bidigi pai dao. ");
INSERT INTO mps_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Te e po da te Abrahamgo ogwa Aisak aga te tama bidali wabo po dao. ");
INSERT INTO mps_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisakgo te Rebeka sali sogo te aga kibu be bidi sese si 40 elaluai. Rebeka te Betuelgo wegi da, aga te Aram bulu bidi me deli, te Mesopotemia pedai badu elaluai. Tama Rebeka te Labango abe, aga te Aram bidi me deli dao. ");
INSERT INTO mps_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Te Aisakgo wego wai me ame nabeo. Tama tibaso, Aisakgo aga tobade gedu haluasa po weyu, te Yawego aga we tau somainu yai. Yawego te Aisakgo gedu haluasa po wabo odama, tama Rebeka haliga yalio. ");
INSERT INTO mps_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Te Rebekago haligade te wai si elalu, tama augwa si tomode usu siyu begelali. Tibaso, Rebekago te po wali, “Te ebo kolesaga magi baso enaba pedelaliwe?” Agai te sę ebo page koneainu, teda agai Yawebolo gedu haluasa po hanalu wali. ");
INSERT INTO mps_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Tama Yawego te tiwai po Rebekabolo wai, “Te bidi hani si te nago haliga tomode bidibao. Te hani bidi si nago ame nainu ebaso, te augwali si dali si ususu si yainu ebao, tama nosali hani si bugulama, tedali bidaibao. Te me hani deligo gasa hani me dali bomo mu yaibao. Tama polasa te ame nabo wai aga te nosali ame nabo waigo sę ebo bidi pedelaibao,” Yawego Rebekabolo te po wei ponani. ");
INSERT INTO mps_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tama te tiabo sogo bodolu pedelama, tama mu tama Rebekago te wai ogwa si ame nani. ");
INSERT INTO mps_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Te polasa ame nani waigo tigi da, te mama mu elama, tama tigi tu nisi hauwa elaluali, te hasa nisi tiwai yai. Tama tibaso, augwaligo aga nogi Iso poali. ");
INSERT INTO mps_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Te nosali pedelali wai ogwa aga ame nobadi tama aga nogogo te Iso sągą gabulude tolalubadi, tama ame nani. Tama augwaligo aga nogi Jekop poai. Te sogo Aisakgo kibu be te 60 kibu be elalubo sogo Rebekago te wai si ame nani. ");
INSERT INTO mps_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Te ogwa si genuai elama, tama Iso te bulu hasa gegebo koneai bidi mu bidali. Aga te bulu hasaba naga pabo sę ebo bidi bidai. Tiali goli, Jekop te subigila me bilisiąbo bidi dao. Aga te augwaligo ugwa be dabede naga bididuai. ");
INSERT INTO mps_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisakgo te Iso godolo elaluai, magi baso meni, agai te Isogo elebo bulu hasa tuyu, wiegi yai homu pemene iduali. Tiali goli, Rebekago Jekop agai godolo homu yali. ");
INSERT INTO mps_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Me sogo side Jekopgo te nai tegabi sup uludubadi, tama Iso te bulu hasa gegegi pelama, ugwa beba ma sabolali. ");
INSERT INTO mps_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Aga moni nasi ebaso, tama agai Jekopbolo te po wai, “Ena nasigo mu dwalio. Te ulali mama yai naigo ena dwasianu mao, tuaio,” wai. (Tama tibaso, nosali augwaligo aga nogi Idom poali.) ");
INSERT INTO mps_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tiali goli, Jekopgo te tiwai po wei ponani, “Da si dobu si inao. Hasia bolo nago enabolo te nage gomunai ogwa da nogi wabo po te enabolo mobaso da, teda nosali eno te ulali sup nai nagebolo mawaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tama Iso te po wai, “Te usu dao. Nasi baso te pąde ena isabo homu ebo, tama ena te gomunai bidi elalubo nogigo te enabolo magi nai magowe?” ");
INSERT INTO mps_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tama Jekopgo te po wali, “Tiali goli, nago hasia bolo te nago po dąų weyu, tama po wao, ‘Eno te enade elalubo gomunai bidi nogi te Jekopbolo mu mobao. Tede eno tibo po obaso da, teda eno homugo te Godigo ena ela muao,’ tama po hasia bolo wao,” Jekopgo te po wai. Isogo te mu po naga da dąų wabo po ola silibo si, tama aga te gomunai ogwa nogi elaluali te nogi Jekopba mawai. ");
INSERT INTO mps_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nosali Jekopgo te bret meba dali, te sup me mawai. Iso aga te nai polo tuyu, wę tuyu yai. Nosali aga hogodama, palio. Agai te aga gomunai bidi da, tama aga aya isibosi da, teda aga doado bage hauwa sabo bidi dao, tede te olo nai naga dao homu elama, tama tagalalio. ");
INSERT INTO mps_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gasa sogo te nasi ebo si te buluba pedelali, te polobadu Abraham bidali sogo pedelali nasi tiwai ma pedelali. Tialima, Aisak te Filistia dabego tuni bidi Abimelek bidibo bulu te Gerarba pali. ");
INSERT INTO mps_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yawe te Aisakba pedelama, tama agabolo te tiwai po wai, “Nage te Isipba munu me pelamuo. Nage te eno nagebolo bida wabo bulude bidagameo,” wai. ");
INSERT INTO mps_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","“Nage te bulude bolo bidao, tama ena nage dali bidiyu, tama dwagi yai tau sabo sę nage dali yaibao. Te e elalubo tǫ pedai tigidali te eno nagebolo mayu, te nago hani wąį dabe augwalibolo me mawaibao wai. Tama eno te nago aya Abraham dali dąų wali po te eno homude me gegeda palogobeo. ");
INSERT INTO mps_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Te nago wąį hani augwali te umabo mu pedalumainu yaibao, te dagalude elalubo hǫ dabe tiwai gilama yaibao. Tama eno e tǫ pedai te tigidali eno augwalibolo mawaibao. Tama te tǫde tigidali bidi dabego te augwali da dali dwagi yai sę yao wabo po enabolo hanalu, te eno nago hani wąį dabe dwagi yai sę yali tiwai gilama yao po waibao. ");
INSERT INTO mps_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abrahamgo eno haniani te kolesaga yao po odama, tama agai eno bomai po tigidali wali pai. Tama tibaso, eno nage dali dwagi yai sę yaibao,” Yawego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tialima, Aisak te bulu Gerar tede bididualio. ");
INSERT INTO mps_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tama te bulu bidi dabego te aga we po agabolo hanalubo sogo agai te tiwai po wali, “Aga te ena abe dao.” Aga wi ebaso, tama agai te po me wabe, “Aga te eno we da,” wabeo. Aisak wi elama, tama tiwai homu yali tiyu, te bidi dabego Rebeka sainu te aga ela muidali homu yali. Magi baso meni, Rebeka te gasagi yai sawi yai we bidai. ");
INSERT INTO mps_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisak te badu bidali sogo sesabi gana elama bidai, tama te Filistia tǫ tonalubo tuni bidi Abimelek te be tomodu te winduadu tonobadi dolaluyu, tama agai suali, Aisak aga we Rebeka tigiba nono tubo sę ebo suai. ");
INSERT INTO mps_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tialima, Abimelekgo Aisak i olama, agabolo te po wai, “Odao. Te nago we dao! Tiali goli, magi baso nago te naga abe da po waliwe?” Tama Aisakgo te po wei ponoyu, te po wali, “Eno e tama tiwai homu yai, ‘Te eno po weyu, te ena we da po obaso da, teda augwaligo ena ela mugowe?’ te homu yai dao.” ");
INSERT INTO mps_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tialima, Abimelekgo te po ma wai, “Magi baso nago da dolainogo yaliwe? Suao, te eno hani bidi hauwa te elalubao, te dua digi mu te bidi me deli nago we dali olo pigi pigi dao. Te bidi me deligo tama tigi sogo da, te naga digi te dwai sęgę daba pedelabo page yalio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tama tibaso, nosali Abimelekgo te e tiwai po bomo elama, te tigidali bidi dabebolo walio, “Te bidi me deligo dwai sę te e bidi dali, ma we dali me ebaso da, teda te bidi aga mu isimainao.” ");
INSERT INTO mps_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisakgo te tǫde nai wai dabe bulama, tama te kibu bede nai umabo mu pedelama, tama agai nai te hauwa sogo mu bulu dali tiwai gilama yali. Yawego aga tau siyu, tama dwagi yai sę aga dali yai, ");
INSERT INTO mps_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","tama agai nai hauwa mu sidu geani, tama aga genuai bidi mu pedelai. ");
INSERT INTO mps_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Agai kibu sipsip me, bulmakau me, sę ebo bidi me hauwa mu elalubaso, tama te Filistia bidi dabego te sulama, tama augwali pesą yali. ");
INSERT INTO mps_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Te Abraham tede bidali sogo, agai sę bidi dabe augwaligo te wę ulu dabe nigali. Megi te Filistia dabe augwaligo te Aisak dali dwai homu ebaso, augwaligo te tǫde ulu wę pedalubo te ma dąų olama, te tǫgo ma paliali. ");
INSERT INTO mps_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tama nosali Abimelekgo Aisakbolo te tiwai po wai, “Nago da taga peyu, pao. Megi nage bomo mu ebao. Da nage dali usu me egobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tialima, Aisak tede bidali taga peyu, tama aga pelama, te bidabo pesage me deli te bulu du si elalubo madi tomode, te tǫ me badu tede bidali, te odogo tǫ nogi te augwaligo Gerar poai. ");
INSERT INTO mps_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abrahamgo te wę ulu tǫde meba polobadu nigai. Tiali goli, te aga isali sogo te Filistia bidi dabego te wę ulu dabe paliali. Tama Aisakgo te wę ulu dabe ma dalama, tama aga ayago polobadu deli delibolo poali nogi tiwai ma poalio. ");
INSERT INTO mps_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Te Aisakgo sę bidi dabe augwaligo te bulude tǫ diganama, tama te wę ulu me deli nigainu te augwaligo dwasianu wę ulu tǫde pedalubo gegalio. ");
INSERT INTO mps_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tiali goli, te Gerar tede te kibu bulmakau tonalubo bidi dabego te Aisakgo kibu tonalubo sę ebo bidi dabe dali wado po weyu, te po wai, “Te e wę dago wę dao,” po wai. Tama Aisakgo te wę ulu nogi e tiwai nogi poai “Wado po wai.” Magi baso meni, te bidi dabego wado po tede wai. ");
INSERT INTO mps_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tama Aisakgo sę bidi dabego gasa wę me ma nigali, tama tede me augwaligo wado po wai. Tialima, Aisakgo te wę ulu nogi e tiwai nogi poai “Genuai wado po wai.” ");
INSERT INTO mps_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Agai te pedai badu tagalama, te aga gasa badu me te wę ulu ma nigai. Tiali goli, te sę ebo bidigo tede te wado po me wabeo. Tialima, Aisakgo te e tiwai nogi poali “Te pesagede po ma wasiąwai,” tama agai te po wali, “Megi da, Yawego da e tǫde te genuai bidabo pesage mayu, tama te da bugagia homu nagame elama bidimainu yalio. Tama dago te bulude doado bage hauwa elaluaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aisak aga tede bidali taga peyu, te aga te Berseba teba sabolali. ");
INSERT INTO mps_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Te sogo hulide Yawe te agaba pedelama, tama te po wai, “Ena naga aya Abrahamgo God dao. Nage wi me elamuo. Ena nage dali bidibao. Te eno nage tau siyu, nage dali dwagi yai sę elama, tama nago wąįgo wai dabe hauwa pedalumainu yaibao, magi baso meni, eno te ena sę bidi Abraham godolo mu yali dao, tama aga tobade eno tama tiaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aisakgo te ofa maiabo alta me deli te bulude dodolama, tama agai Yawebolo lotu wai. Nosali agai te bidabo pesage tede nigilama, tama aga sę bidi dabego tede tǫ diganama, tama te wę ulu me deli nigali. ");
INSERT INTO mps_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelek te aga bulu Gerar taga soyu, asama, Aisak suagasali. Ahusat, te bidigo Abimelekbolo te wiegi yai homu kolesaga mabo bidi, me Fikol, aga te aga ami bidi dabe tonalubo polalubo bidi, augwali si te Abimelek dali asai. ");
INSERT INTO mps_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tialima, Aisakgo augwalibolo hanalu wali, “Polobadu dagego ena dali wado po olama, tama ena dagego bulude bidibadi gudulai. Tama magi baso megi da, duga digi dage ena bidibo digi asaliwe?” wali. ");
INSERT INTO mps_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tama augwaligo te tiwai po wei ponani, “Megi dago koneani, te Yawe nage dali bidibao. Tama dago homugo te dago dage dali te mu po naga dao weyu, te boi homu ebo silabo po me deli dąų waibao. Dago nagebolo dwai sę me ilibeo. Tama dago homugo te nago bomo yai po dąų weyu, ");
INSERT INTO mps_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","te nago da me dolamu dao. Dago wiegi yai kolesaga nagebolo yali, te nago dago bulu taga soali sogo te dago nage dali me hwįbeo, te nage homu nagame dali dua digi soai dao. Magi baso meni, te hania pedelalio, te Yawego te dwagi yai sę te megi nage dali ebo dao.” Augwaligo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aisakgo te augwali nai genuai me ulama, tama augwali nai me wę tuai. ");
INSERT INTO mps_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Te kigamu digi mu augwali hogodaluama, tama augwali dali, Aisak dali, augwaligo augwa nogo guni sisu muyu, augwa hasi e tiwai po dąų wali, “Te dago dage dali sesemane sogo te wiegi yai homu deli naga elama, bidaibao.” Aisakgo augwaliba dage tao olama, tama augwali nogo menama, tama augwali pali. ");
INSERT INTO mps_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Te sogo digi te Aisakgo sę bidi dabe sabolama, tama augwaligo agabolo te augwaligo wę ulu nigali po wagasai. Augwaligo te po wai, “Dago wę gegalio.” ");
INSERT INTO mps_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tialima, Aisakgo te wę ulu nogi Seba nogi poai. Tama megi tebode augwaligo te hanu nogi Berseba wabo dao. ");
INSERT INTO mps_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso aga kibu be te bidi sese si olama, 40 wabode, tama agai te we Judit sali, te Berigo wegi, te Hit bidi hani me deli da. Isogo te Basemat te we me sali, te Elongo wegi, te me Hit hani bidi me deli dao. ");
INSERT INTO mps_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Aisak de Rebeka si te we sigo ebo kolesaga hagela homu eyu, tama haliga dene mu iduai. ");
INSERT INTO mps_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisak monu dabe mu elama, tama aga gedu halua selama, tama te nai dabe me, bulu ula me ma bugagia suabo ąǫ isąwai. Tialima, agai aga gomunai ogwa Iso i olama, tama agabolo te po wali, “Ogwao!” Tama Isogo po wei ponani, “Awe, ena e bidibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tama Aisakgo te po wai, “Ena monu dabe elama, tama ena pąde isainu ebao, te ena isabo sogo eno konebeo. ");
INSERT INTO mps_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tama nago naga enesigi me ene dali selama, tama nage busiba pelama, tama eno hasa me deli gegegi pao. ");
INSERT INTO mps_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Te nago gegelama, subosi da, teda nage pelama, te eno godolo ebo nai ulama, tama nago enaba selasa asao. Te eno te nai tulama da, tama eno nagebolo te Yawego nage dali dwagi yai tau sabo sę emainao po menama, tama nosali ena isaibao.” Aisakgo te po Iso dali wali. ");
INSERT INTO mps_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Tiali goli, Rebeka agai odali, te Aisakgo aga ogwa Iso dali po mibo odali. Tialima, Iso te aga ayago tuabo hasa me deli te busiba gegegi peyu pai madi, ");
INSERT INTO mps_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekago aga ogwa Jekopbolo te tiwai po wali, “Megi tama eno odali, te naga ayago te po nago ama Isobolo mabo po eno odali, ");
INSERT INTO mps_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Te hasa me deli selasa asama, tama ena habi nai meba ula magasao,’ po walio. ‘Tama tialima, te nai eno tulama da, tama eno te Yawego nage dali dwagi yai tau sabo sę emainao po te nagebolo Yawe gedude mawaibao,’ wai, ‘tama nosali ena isaibao,’ naga ayago Isobolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Te megi da, te ogwa, te nago eno po bugagia odama, tama eno nagebolo po wabo gilama te sę yao. ");
INSERT INTO mps_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nage te kibu sibi bidalubo obo elalubo teba pelama, tama te wiegi yai nisai meme wai si te enaba selasa asao. Tama eno te nago ayago godolo ebo te tobage wiegi yai nai ulaibao. ");
INSERT INTO mps_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tama nago te naga ayabolo magi pagameo, te agai tuaibao. Tama nosali agai isisąbadi, agai te Yawego nage dali dwagi yai sę emainao po nagebolo mawaibao, tama nosali aga isaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tiali goli, Jekopgo te tiwai po aga idabolo wei ponani, “Nago koneani, Iso tigide te tigi tu nisi hauwa elalubao. Tiali goli, ena tigide te menio. ");
INSERT INTO mps_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tama tiyu, ayago eno tigi nogo diąnama, tama agai homugo te eno aga usu suyu, tama tibo po ola mabowe te homu idalio. Tiyu, agai wado po weyu, te aga God i olama, ena dolidalio, tama eno te Yawego ena dali dwagi yai sę emainao po me sigi pogobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tiali goli, aga idago te po wai, “Ogwao, tagalao, enade digi te dolobo sę pedalumainao. Tiali goli, nago da, te eno nagebolo wabo po gilama te sę yao, tama nage pelama, te meme si sela asa,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tialima, Jekopgo te meme si sigi pelama, te aga idabolo magasali. Tama Rebekago te Jekop aga ayago godolo mu ebo nai te ulai. ");
INSERT INTO mps_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tama Rebekago te Isogo gudubo ugwa dabe te augwa bidibo bede munaluali. Tama agai te Isogo ugwa wiegi yai sawi ugwa mu selama, tama Jekop te ugwa gudulama, au ilai. ");
INSERT INTO mps_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Tama agai te Jekop nogo dali, aga nage me, te meme tigiwaligo mesegelai. ");
INSERT INTO mps_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tama Rebekago te ulali pusu yai nai me, te agai ulali te bret meba me selama, te Jekopbolo mani. ");
INSERT INTO mps_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Tialima, Jekopgo te nai dabe te aga ayabolo selasa pelama, te po wali, “Ayao!” Tama Aisakgo te po wali, “Awe, ogwao. Nage de dawe?” ");
INSERT INTO mps_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tama Jekopgo te po wai, “Ena Iso, te nago gomunai ogwa dao. Eno nago enabolo te po wali nai sisi elasa asalio. Nage megi da hodaluama, tama eno e selasa asali nai mi meba tugulao, tama nago te Yawego ena dali dwagi yai sę emainao po enabolo magameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tiali goli, Aisakgo te tiwai po ma wai, “Ogwao, magi ilama, tama nago te hasa polo gegaliwe?” Tama Jekopgo e tiwai po wei ponani, “Yawe te nago Godigo ena tau selama, tama tibaso, eno te hasa polo gegai dao.” ");
INSERT INTO mps_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tialima, Aisakgo tama po Jekopbolo wai, “Te nage pąba edaba gana dwasianu asama, te eno nage diąna suaio,” wali, “nage te eno gomunai ogwa Iso yaliwe, ma meni yaliwe, te eno sueio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jekop te aga aya pąba pelama, tama ayago aga tigi diąnama, tama bugagia koneama, te po wai, “Nago po wabo te Jekopgo po wabo tiwai obao. Tiali goli, eno nago nogo diąyani, te nago nogo te Isogo nogo tigi tu nisi tiwai yalio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aisakgo te Jekop bugagia me konebeo, magi baso meni, te meme tigi nisigo te aga nogo halualigo te nogo Isogo nogo tiwai yai. Aisakgo te Yawego aga dali dwagi yai sę eyu, tau sabo po agabolo mawainu yali, ");
INSERT INTO mps_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tiali goli hasia agai hanaluyu bolo ma yai, “Te mu tama, nage te eno ogwa Iso dawe?” Tama Jekopgo te po wali, “Awe.” ");
INSERT INTO mps_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tialima, Aisakgo te po wai, “Te ulali nai mi te enaba magasao. Te ena nai tulama da, te eno dwagi yai po nagebolo mawaibao.” Tialima, Jekopgo te nai me te wain wę me sela pelama, te Aisakbolo magi pelama, tama Aisakgo te nai me wę tuali. ");
INSERT INTO mps_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nosali Jekop aga ayago te po wai, “Ogwao, eno homugo te nage ena pąba asama, te eno gesabidiba nono nagasao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tama Jekop te pąba pelama, tama aga dali gesabidi sebedi usuyu, nono nani, tama Aisakgo Jekopgo gudali ugwa denami odama, tama agai te Yawego aga dali dwagi yai tau sabo sę emainogo eyu wabo po agabolo mani. Agai te po wali, “Te eno ogwago wiegi yai denami te Yawego dwagi yai tau sabo po mani, te gi me deli denami tiwai gilama ebao. ");
INSERT INTO mps_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Te eno homugo te Godigo hulide te siginibo wę tagala palomainu elama, tama nago tigidali gide nai hauwa holomainu yaibao. Te agai nagebolo te wit hauwa me, wain wę me hauwa momainu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Te tigidali bulude bidi dabe te augwali nagede sę ebo bidi pedelama, tama te bidi dabe nage dologode bidaibao. Te nago te naga ama dabe tonaluaibao. Tama nago idago hani wąį dabe augwali te nage dologode bidaibao. Te Godibolo nage dolomainu i wabo bidi dabe, te augwa digi deli deli augwa ma dolomainu yaibao. Tiali goli, te bidi dabego Godiba i olama, te agai nage dali dwagi yai tau sabo sę emainu i wabo bidi dabe, augwali deli deli dali me te agai dwagi yai sę yaibao, te eno homugo te tama elalumainao,” Aisakgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisakgo dwagi yai po te Jekopbolo menama, tama Jekopgo aga aya taga pali. Tama te sogo naga te aga ama Iso te busidu ma beba sabolali. ");
INSERT INTO mps_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Agai me te wiegi yai pusu ebo nai ulasa, te aga aya bidibo digi sela palio. Tama agai te po wai, “Ayao, nage hodaluama, te eno selasa asali nai mi meba tugulao, tama nago te Yawego ena dali dwagi yai sę yabo po enabolo magameo.” ");
INSERT INTO mps_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Aisak agai te po wai, “Nage de dawe?” Tama Isogo e tiwai po wei ponani, “Ena Iso, te nago gomunai ogwa dao.” ");
INSERT INTO mps_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisak aga dwai midigi mu selama, didibili elama, tama agabolo hanalu wali, “Tiali goli, dego hasia te hasa elama, te mi selasa, enabolo magasali bidi de dawe? Nage sabolisiąbadi, te nai eno tualio. Tama eno te Yawego aga dali dwagi yai sę yabo po te bidibolo mena silai, tama te dwagi yai po agade sesemane sogo elalua pidu, mu elalua paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Te sogo Isogo te tiwai po wabo odobaso, polo aga dwai homu mu eyu, aga dwai gela mu wali. Tama agai te po wai, “Ayao, te nago gasa dwagi yai po te enaba me mao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tiali goli, Aisakgo te po wai, “Naga amago ena tibo po ola menama, tama agai te nagebolo maiabo dwagi yai tau sabo po sai dao.” ");
INSERT INTO mps_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tialima, Isogo te po wai, “Te megi e da, te agai si sogo megi ena guni tǫba ilali. Tama tiyu, te nogi Jekop te nogi page te ‘polobo bidi’ tama dao, te agade dolo mu yali. Te idago hasia ena bolo ame nani, tiali goli Jekopgo te enade elaluali te gomunai ogwa wali, te nogi agai wi sai. Tama megi me te agai te enabolo maiabo dwagi yai po wi salio. Magi yaliwe, aya, te nago enabolo maiabo po te gasa me deli sisi yai elalubewe?” ");
INSERT INTO mps_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tama Aisakgo Isogo po wei ponani, “Eno aga te nage tonaluabo bidi ilama, tama eno te aga deli kaneme te tigidali agai sę bidi pedelaibao. Tama eno te nosali pedelabo tubo nai wit me wain te agabolo mani. Megi te mena nai gasa me elalubo weyu, te eno nage momainu te ogwa nago te po obawe?” ");
INSERT INTO mps_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tiali goli, Isogo bomonama, aga ayabolo hanaludubadi geani, “Aya, nago te dwagi yai po deli naga elaluai dawe? Aya, nage enabolo me te Yawego ena dali dwagi yai sę emainao po mao,” wali. Isogo te po olama, tama aga moni genuai gela ma wai. ");
INSERT INTO mps_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tialima, Aisakgo agabolo te po wai, “Te nago bulu dwai tǫ te wiegi yai ili yai tǫ digibulu elaluaibao. Tama hulide te siginibo wę te nago giba me tulalugobeo. ");
INSERT INTO mps_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tama nage te bugagia bidiyu, te nai tuabo pesage gegeyu, te nago bainat hwą gego hwįyu, tama yaibao. Tama nage te nago amago sę ebo bidi bidaibao. Tiali goli, nosali nago hagela homu eyu, tama agai po sela sąbaso, tama agai nage ma tola sogobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isogo homugo te ayago te dwagi yai sę pedelabo po te Jekop te bolo mani, te agai homude wado ebo homu dwai mu te Jekop dali yai. Tialima, Isogo e tama homu elama, te po wai, “Te pąde dwasianu sogo naga te aya isibaso, tama dago aga homu dene yaibao. Te homu dene yali sogo sia sabo si da, teda eno te Jekop ela muaibao.” Isogo te tama homu elalualio. ");
INSERT INTO mps_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebekago te aga gomunai ogwa Isogo te homu ebo po odai. Tialima, agai te aga sabi bidi ogwa Jekop i olama, te po agabolo wali, “Nago e po bugagia odao. Te naga ama Isogo te nago agabolo yali te sęde te agai nageba wei ponoyu, ela muainu te homu ebao. ");
INSERT INTO mps_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tialima, megi da, ogwa, te nago eno po wabo gilama te sę yao. Nage sisi elama, tama wi pelama, te eno abe Laban dali te Haran teba osogo bidigi pao. ");
INSERT INTO mps_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nage te eno abe aga dali bidibadi, te nago amago homu sębę yali te homu kedau elama, ");
INSERT INTO mps_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","tama agai te nago yali sęde te boi bidi homu gegeda palomainu emainao. Tama nosali eno te bidi me deli te po nagebolo wagasomainu tagala palama, tama nage eba ma odasa asomainu yaibao. Da si go tama tinao. Magi baso meni, te eno wai dage si te deli sogo hagabo, te eno homugo hagela idalio,” Rebekago te po wai. ");
INSERT INTO mps_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nosali Rebekago e tiwai po Aisakbolo wai, “Eno te Hit hani we dabe te eno mu hagela idubao. Te Jekopgo me, te Hit hani we dabego me, te e bidibo we si tiwai kolesaga ebo we sobaso da, teda ena isimainu yaibao,” Rebekago te tiwai po Aisak dali wai. ");
INSERT INTO mps_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Te Aisakgo Jekop i olama, tama te dwagi yai sę agabolo pedelabo po agabolo mawai. Tama Aisakgo agabolo e tiwai bomo yai po mani, “Nago te e bulu Kenan tǫ we me deli munu me selamuo. ");
INSERT INTO mps_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nage sisi elama, tama nage te Mesopotemia tǫ, te Betuel tego buluba pao, aga te nago idago aya da. Tama nago te naga idago abe Labango wegi me deli sao. ");
INSERT INTO mps_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Te eno homugo te Tigidali Bomo Mu Elalubo Godigo nage dali wiegi yai sę elama, tama nago wai hauwa ame naibao. Tama tibaso, te nage bidi hani hauwago aya monu pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tama eno homugo te Godigo nage dali dwagi yai sę eyu, te nago wąį te wai dabe me tiyu, te Abraham dali dwagi yai tau sabo sę yali tiwai gilama yaibao. Tama tiyu, tama nago megi naga te bidibo tǫ sobadi yaibao, magi basowe, Godigo e tǫ te naga wąį Abrahambolo maiabo po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisakgo te tiwai po olama, tama agai te Jekop te Mesopotemia buluba te Laban bidibo digi tagala palai, te Betuelgo ogwa, te Aram bulu bidi me deli. Laban te Rebekago abe, te aga Jekop de Iso augwa si ida dao. ");
INSERT INTO mps_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isogo te Aisakgo Jekop dwagi yai tau sabo po menama, tagala palu, te Mesopotemia tǫ te pedai badu we me deli sigi pomainu tagala palali po odali. Aga me koneani, te Aisakgo Jekop dwagi yai tau sabo po mayu, agai Jekopbolo te po weyu, nago te Kenan bulu we me selamu da po wai. ");
INSERT INTO mps_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tama agai koneani, Jekopgo te aga aya idago po wabo odama, tama aga te Mesopotemia buluba pai. ");
INSERT INTO mps_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tama te sogo naga Isogo koneani, te aga Aisakgo te Kenan tǫ we sabo te agai hagela homu yai. ");
INSERT INTO mps_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tama tibaso, aga te Ismaelgo haniba pali, aga te Abrahamgo ogwa, tama agai gasa we me sali, aga nogi te Mahalat. Te we te Ismaelgo wegi, tama aga te bidi Nebaiotgo abe dao. ");
INSERT INTO mps_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jekop te Bersebade bidali taga peyu, tama aga hogodama, te Haran teba painu pali. ");
INSERT INTO mps_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tama digibulu pelama, tama tomode me sogo aga te bulu me deliba sabolama, tama aga tede bididuai, magi baso meni, te be pio eyu, giliga dega sigi pali. Tama tibaso, agai tede munaluali masigi me deli selama, te aga tobolu muabo dologo badu tobolo ni tiwai munama, tama aga godege piali. ");
INSERT INTO mps_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Te aga piali sogo te aga na ebadi suali, te togobili me deli page te tǫde elalu, te aga tobolu te dagalude ugwaba ilama elaluai. Tama te Godigo mobo bidi ensel dabe te togobilidu ugwaba holoyu, aiyaba duluyu ebo, te agai suali. ");
INSERT INTO mps_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tama Jekopgo suali, te Yawe aga pąde dolalu tama po wai, “Ena Yawe, te nago wąį Abrahamgo God, me Aisakgo God dali dao. Te megi nage e pilamubo tǫ te eno nagebolo mayu, te nago ame nabo waigo wai dabebolo me mawaibao. ");
INSERT INTO mps_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Te nago ogwa dabego ame nabo wai dabe augwali te tǫ hogomu tiwai hauwa umabo mu pedelaibao. Tama augwaligo te augwa tǫ sese pedai tigidali pedaiba usu elama, bidaluaibao. Tama tigidali tǫde bidalubo bidi dabe augwaligo enabolo te augwali dali dwagi yai sę yao po hanalu, te eno nage me, te nago ame nani waigo wai dabe augwali dali dwagi yai sę yali tiwai gilama dwagi yai sę yao po hanalu waibao. ");
INSERT INTO mps_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Odiąo. Ena nage dali bidiyu, tama nage paboba te tigidali habu te eno tonalua bilaibao. Tama nage eno e tǫba ma odasa asaibao. Tama eno nage munu me tagalisiąbadi, te eno nagebolo po wabo sę tigidali usu nama, pedela silaibao,” Yawego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jekop te pila muani hodalu, tama po wai, “Eno Yawe te e bulude bidibo me konesiąwai. Tiali goli, mu tama aga bidibao.” ");
INSERT INTO mps_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Aga wi elama te po wali, “Ena e bulude wi mu ebao! Te e da, Godigo be mu dao. Awe, te dagalugo sunumi dao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tialima, Jekop te kigamu digi mu hodaluali. Tama agai te tobolo ni tiwai te aga tobolu dologode munama piali masigi sawali selama, tama agai te masigi tǫde dualali, te aga homu hodolomainu ebo sę tiwai ilali. Tama agai te wel te masigi daide ugwadu gelali, te tǫ Godigo gasagi yai nai tedali da olama, te sa muani. ");
INSERT INTO mps_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Agai te bulu nogi te Betel nogi poai. Polobadu te bidi dabego te bulu pąde elalubo hanu nogi Lus nogi yai. ");
INSERT INTO mps_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Tama Jekopgo te tiwai po God dali dąų wali, “Te nage ena dali bidiyu, tama nago ena e bobobage sunumidu pobadi tonaluyu, tama nago ena te nai me, ugwa me menama, ");
INSERT INTO mps_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tama ena te ena ayago buluba bugagia ma sabolubaso da, teda nage eno God mu bidaibao. ");
INSERT INTO mps_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Te e masigi eno ugwaba dualali, te e da nago be elalubo bulu da olama, sa muani. Tama tigidali ena mani nai, te eno nogo si badu togolama, te eno me deli pedai te nagebolo mawaibao,” Jekopgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tialima, Jekop te sunumidu palio. Aga pelama, pelama, tama nosali te giliga pedalubo badu bidali bidi hani dabe bidalubo pedai badu sabolai. ");
INSERT INTO mps_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Aga doligi pelama, tonono bilibadi, tama te nosai elalubo moni tǫde agai te kibu sipsip hani sela te wę ulu me deli tubo madi pąde pila mubo hania suali. Te sipsip kibu hani augwaligo te ulu wę tubo da, tama te ulu wę dedage palibo genuai masigi elaluali. ");
INSERT INTO mps_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tama te tigidali kibu sipsip hani sisinagasa silai madi, tama te kibu tonalubo bidi dabego te ulu wę panialuali genuai masigi dagala sąnama, tama augwaligo te sipsip dabe wę mayu yai. Tama te kibu sipsip dabego wę tula silibo si, tama te kibu sipsip tonalubo bidi dabego te wę ulu palibo madi teba ma paliyu yai. ");
INSERT INTO mps_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Te Jekopgo augwalibolo hanalu wali, “Abagi dede, dage mena badu bidi dabe dawe?” Tama augwaligo te po wai, “Da te Haran bulu bidi dabe dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tialima, agai augwalibolo hanalu wali, “Dagego te Laban, te Nahor tego wąį ogwa koneaniwe?” Tama augwaligo te po wai, “Awe, dago aga koneanio.” ");
INSERT INTO mps_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tama Jekopgo augwalibolo hanalu wai, “Laban bugagia bidibowe?” Tama augwaligo te po wai, “Aga bugagia bidibao. Nago suao. Resel, te agai wegi, te Labango kibu sipsip hani dali megi te asobao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jekopgo te po wali, “Magi yaliwe? Te giliga genuai nanalubadi, tama te sipsip dabe te obo tomoba muabo me elalubadi dao. Tagala, te augwali wę menama, tama augwali te nosa dabe tumainu ma selasa pao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tama kibu tonalubo bidi dabego te po wai, “Menio. Dago tama me tegobeo. Te tigidali sipsip hani sisiniyu bolo elama, tama nosali dago te wę ulu dedage paliali masigi dagala munama, tama te sipsip dabe wę mabo dao.” ");
INSERT INTO mps_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jekopgo te kibu tonalubo bidi dabe dali po midubadi, tama Resel te aga ayago kibu sipsip hani kegasa asobo suali, magi baso meni, te agai augwali tonalubo sę yai. ");
INSERT INTO mps_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jekopgo te Resel te aga hai te Labango kibu sipsip hani dali subaso, tama aga te wę ulu elalubo madi pelama, tama te mesegalubo masigi sela munama, tama te sipsip dabe wę mawai. ");
INSERT INTO mps_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Tama Jekopgo te Resel dali nono nenama, tama gela wai. ");
INSERT INTO mps_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tama agai agabolo wali, “Te ena da, te nago ayago deli hani bidi dao, te aga abe Rebeka te eno ida dao.” Tama Resel udulama, te aga ayabolo wagi palio. ");
INSERT INTO mps_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labango te aga abego wai asali po odama, tama aga udulama, aga bidibo madi pai. Labango Jekop aga pagea selama, tama aga nono nenama, tama aga beba odasa pali. Tialima, Jekopgo agade yali sę po tigidali pusali. ");
INSERT INTO mps_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tama Labango agabolo te po wai, “Awe, te mu tama, da si te deli kaneme mu dao.” Tama Jekop aga dali bidibadi, te polua deli bidai. ");
INSERT INTO mps_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Te polua deli bidama, tama nosali Labango Jekopbolo te po wai, “Nage te eno abego ogwa mu dao, tama nago te sę olo ebo da, te eno homugo usu meni yaibao. Nago te nisu naga nai te sęde nago saibawe?” ");
INSERT INTO mps_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labango wegi si bidali, te gomunai wegi Lea, te tomo wegi Resel. ");
INSERT INTO mps_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Te gomunai wegi Leago gesabidi te wiegi yai mu meni, tiali goli te tomo wegi Resel te gesabi sawi yai mu bidai. ");
INSERT INTO mps_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jekopgo te Resel godolo mu yali, tama tibaso, agai te po wai, “Eno te kibu be nogo a naga olama, me badu si te nagede sę yaibao, te nago gesi wegi Resel sainogo tama tiaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tialima, Labango te po wali, “Te mu tama, eno te gasa bidiba mabo te usu dao, tiali goli te eno aga nagebolo mobaso da, te dwagi yai mu dao. Nage te ena dali bidao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tama tibaso, Jekopgo te Resel sainu, te kibu be a naga me badu si, te tama sę iduai. Tama Jekopgo te kibu be a naga me badu si te agai homu kone palali te yadela pali, magi baso meni, agai te Resel godolo mu yai. ");
INSERT INTO mps_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tialima, megi da, Jekopgo Labanbolo te po wai, “Te bodolu silalio. Te nago wegi ena menama, tama eno aga saibao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tialima, Labango te genuai nai te wegi sabo sogode ulainu, tama agai te bulude bidalubo tigidali we bidi dabe i olama, tama augwali te nai tuagasali. ");
INSERT INTO mps_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tiali goli, te sogo hulide Labango te wegi Resel mawainu yali hasegelama, te Jekopbolo Lea menama, tama Jekopgo te konesiąbaso, te Lea aga dali piai. ");
INSERT INTO mps_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Tama Labango te Leabolo sę ebo we me deli mawai dao, te aga nogi Silpa. ");
INSERT INTO mps_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tama kigamu, tegoba! Jekopgo Lea sulama koneyu, tama agai Labanbolo te po wai, “Magi baso nago te tiwai kolesaga enabolo yaliwe? Eno te Resel sainu nagede sę dene ebo sę yai. Magi baso nago ena ili po ola maniwe?” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tialima, Labango te po wai, “Dago kolesaga te tiwai ede elalubo dao. Te gomunai wegi bolo hasia bidigo selama, tama nosali tomo wegi te me bidigo somainu ebo dao. ");
INSERT INTO mps_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nago tonaluyu elama, te we sabo sogo nai tuali te Sarere siligi pabode, tama eno te Resel me te nagebolo mawaibao. Tiali goli, te nago enade te sę kibu be a naga, me badu nogo si te nago sę ma yagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jekopgo te pode usu da po olama, tama te we sabo sogo te nai ulali Sarere deli silibode, Labango Resel te Jekopbolo menama, tama Resel te aga we mu pedelama bidali. ");
INSERT INTO mps_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labango Reselbolo te sę ebo we me deli mani, te aga nogi Bilha dao. ");
INSERT INTO mps_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tialima, Jekop te Resel dali pagelama piali. Tama agai te Resel godolo mu eyu, tiali goli agai te Lea godolo te kuna me ebeo. Tama Jekop te kibu be a naga me si te Labande sę ma iduai. ");
INSERT INTO mps_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Te Yawego suali, te Jekopgo Lea te godolo kuna me isąwai. Tama agai te Lea haliga emainu tau sai. Tiali goli, Reselgo wai meni yai. ");
INSERT INTO mps_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nosali Lea haliga elama, tama ogwa me deli ame nani. Tama Leago te po wali, “Yawego te eno homu sęgę ebo sulama, tama megi da te eno bidigo ena godolo emainogo yaibao,” wali. Tialima, agai te wai nogi Ruben poai. ");
INSERT INTO mps_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nosali te Lea haliga ma elama, tama gasa ogwa me ame nani. Tama agai te po wai, “Yawego te gasa ogwa te wai enabolo mani, magi baso meni, agai odali, Jekopgo ena kuna godolo me isąwai.” Tialima, agai te ogwa nogi Simeon poali. ");
INSERT INTO mps_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tama Lea te haliga ma elama, tama ogwa gasa me ame nani. Tama agai te po wai, “Megi da, te eno bidigo ena godolo mu elama, tama ena dali dąų olama, bugagia bidaibao, magi baso meni, te eno agai wai te ogwa sela ame nani.” Te po wai. Tama agai te wai nogi Livai poai. ");
INSERT INTO mps_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tama Lea te tabi ma elama, tama gasa wai te ogwa ame nani. Tama agai te po wai, “Te sogo eno te Yawe nogi ugwaba saibao,” wali. Tama Leago te ogwa nogi Juda poali. Tama nosali te Leago wai ma ame nabeo. ");
INSERT INTO mps_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Te Reselgo wai me ame nisąbadi te sogo, agai te aga ama Lea dali haliga sębę elama, tama Jekopbolo te po wai, “Nago enabolo wai mao. Te menisiąyu da, teda ena isaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jekopgo wado po Resel dali weyu, te po wai, “Eno te Godigo yali sę hasegelibo usu me iligobeo. Aga digi te nago tabi paliama, tama nago te wai me ame nabe dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tialima, Reselgo te po wai, “Nago te eno sę ebo we Bilha sao. Nago aga dali pilama, tama agai eno wai ame nomainu yaibao. Tama ena te wai dabego ida pedalaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tialima, Reselgo te aga sę ebo we Bilha te Jekopbolo tagala palama, tama Jekop aga dali piali. ");
INSERT INTO mps_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tama Bilha tabi elama, tama Jekopgo ogwa me deli ame nani. ");
INSERT INTO mps_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Tama Reselgo te po wai, “Godigo ena dagala sulama, tama agai eno gedu haluasa po wabo odama, tama agai ogwa wai me deli enabolo manio,” wali. Tialima, Reselgo te wai nogi Dan poai. ");
INSERT INTO mps_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tama Bilha te Reselgo sę ebo we te aga tabi ma elama, tama Jekopgo ogwa tomo bidi ame nani. ");
INSERT INTO mps_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Tama Reselgo te po wai, “Eno te ena ama dali bomonama mu hwįanigo tama megi eno nogi ugwa sali.” Tama agai te wai nogi Naptali poai. ");
INSERT INTO mps_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leago suali, agai te wai ma ame nabo homu isąbaso, tama agai aga sę ebo we Silpa te Jekopbolo mawai. Tama Silpa te Jekopgo we tiwai pedelai. ");
INSERT INTO mps_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nosali Silpago te Jekopgo ogwa me deli ame nai. ");
INSERT INTO mps_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Tama Leago te po wai, “Ena nogi ugwaba mu igulalio.” Tama tibaso, agai te wai nogi te Gat poali. ");
INSERT INTO mps_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tama nosali Silpa, te Leago sę ebo wego, te Jekopgo tomo ogwa ame nani. ");
INSERT INTO mps_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tama Leago te po wai, “Megi ena wiegi yai homu pemene mu yali, tama tigidali we dabe sibigo enabolo te po weyu, te eno homu pemene wiegi yai mu ebo da po wai dao,” wali. Tama agai te ogwa nogi Aser poai. ");
INSERT INTO mps_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tialima, te tubo nai wit togobo sogo pedalubode, tama te ogwa Ruben te wit togobo madiba pelama, tama agai te wego wai sainu tau sabo nai te dwasianu nide sai. Tama agai te aga ida Leabolo sela asali. Tama Reselgo te naide koneama, tama Leabolo te po wali, “Nago te wai sainu tau sabo nai meba te enabolo mao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tiali goli, Leago po wei ponoyu, te po wai, “Nago eno bidi sai dao, tama nago te olo nai da te homu ebawe? Tama megi nago te eno ogwago sali nai nago godoloyu sainogo obawe?” wali. Tama Reselgo te po wai, “Te nago ogwago gegali nai te ena mobaso da, teda nage Jekop dali megi hulide piagameo,” Reselgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Te pio Jekop te giba pali beba ma asobadi, tama Lea te sunumidu aga tiąba pelama, tama te po wai, “Nage megi hulide ena dali piagameo, magi baso meni, te eno ogwago gegali naigo nage abelalio.” Tialima, te sogo hulide Jekop aga dali piali. ");
INSERT INTO mps_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tama Godigo te Leago gedu haluasa po wabo odama, tama Lea tabi yai. Tama agai wai te a naga wabo ame nani. ");
INSERT INTO mps_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tama Leago te po wali, “Eno sę ebo we te ena bidibolo menama, tama Godigo dwagi yai sęgo ena abelali.” Tama agai te wai nogi Isakar poai. ");
INSERT INTO mps_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nosali Lea aga tabi ma elama, tama agai wai te nogo a naga olama, me badu deli wabo wai ame nai. ");
INSERT INTO mps_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tama agai te po wai, “Godigo te dwagi yai sę me deli enabolo yai. Megi da, te ena bidigo te ena godolo mu yaibao, magi baso meni, eno agai wai te nogo a naga, me badu deli, te tama wai eno ame nani,” wali. Tama agai te wai nogi Sebulun poali. ");
INSERT INTO mps_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tama nosali Leago wegi me deli digi ame nani, tama agai te aga nogi Daina poai. ");
INSERT INTO mps_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tama Godigo Resel homu kone ma palalio. Tama agai Reselgo gedu haluasa po wabo odama, tama aga te wai ame nomainu ilalio. ");
INSERT INTO mps_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tama Resel aga tabi elama, tama ogwa me deli ame nai. Tama agai te po wai, “Godigo eno hale elaluali te dagala sąwai. ");
INSERT INTO mps_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Eno homugo te Yawego te gasa wai enabolo momainu homu ebao,” olama, tama agai aga nogi Josep poai. ");
INSERT INTO mps_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Reselgo te Josep ame nai digi, tama Jekopgo Labanbolo te po walali, “Eno te we dabe dali, te wai dabe dali abelibo sę dene ela silalio. Tialima, megi ena tagala palama, tama ena te ena buluba ma paio,” wali. “Nago koneani, eno nagede bugagia mu sę yalio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labango Jekopbolo te po wali, “Odao! Eno nage dali po elalubao. Eno te enade pedelali sęde konea selama, tama megi da, eno konebao, te Yawego wiegi yai sę enabolo yali, magi baso meni, te nage ena dali bidibo dao. ");
INSERT INTO mps_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nago te nisu naga nai sabo homu ebaso, te nago dolo enabolo wao. Tama eno te nai nagebolo mawaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Tama Jekopgo agabolo te po wali, “Naga digi nago te eno yali sę nago koneani. Tama nago koneani, eno nago kibu sipsip hani te bugagia tonaluai. ");
INSERT INTO mps_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Polobadu te nago sipsip hauwa meni yai, te dwasianu hani elaluali. Tama megi te ena nage dali bidiyu, tama nago sipsip kibu dabe geninama, hauwa pedelali, magi baso meni, te nago ena haniani sęba muani goli, te Yawego wiegi yai sę nagebolo yali. Tiali goli, te eno ena hani bage tau sabo sę nisu egowe?” ");
INSERT INTO mps_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labango hanalu wali, “Te eno nage magi naigo abelagawe?” Tama Jekopgo te po wali, “Eno te mone po olama, i me wabeo. Te nago eno po wabo godolo ebaso da, teda nago sipsip hani dabe te eno ma tonaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Megi da, te eno nago sipsip me meme dabe bugagia osola sueibao. Tama eno te tigidali husugu yai sipsip wai, me te tigidali meme dali, tigidali sipsip te husugu yai elalubo, me te dodobolo pai bage, teda eno sa muaibao. Te dabe da te eno saibao, te eno sę ebode sabo nai dao. ");
INSERT INTO mps_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Tama eyu bidaluama, nosali nago osola sulama, te eno doloba pai kolesaga yali, ma nago suagameo. Te nago eno ena maiabo nai dodolobo sogo, tama te meme me deli, ma te sipsip me deli te dodobolo pai ma husugu yai elalusiąbaso da, teda nago koneyu, te eno wi sali da po wagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Tama Labango te po wali, “Te wiegi yai dao! Dago te nago wabo po gilama tiwai yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tiali goli, te sogo digi Labango digi te tigidali meme omai me, te tigidali meme so me, te dodobolo pai naga salio. Tama agai te husugu yai sipsip wai tigidali sali. Tialima, aga ogwa dabego te sipsip me meme dabe tonalumainu tedali muani. ");
INSERT INTO mps_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Tama polo Labango Jekop taga soyu, tama aga dodobolo pai sipsip me meme dabe dali sela sogo tomoba pigi solama, tama augwali gasa pedai me badu bidai. Tama Jekopgo te Labango gasa hani dodobolo pisąwai sipsip me meme hani naga tonaluai. ");
INSERT INTO mps_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tama nosali Jekopgo te gesi ni nologo haniani selama, tama agai augwali husugu yai tigi wali me badu dagalama, tama te me badu tedela yai ilali. ");
INSERT INTO mps_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Agai te tiwai dodobolo pai ni nologo tigidali te sipsip hani dabe augwali gesabidide te wę tubo pesagede dodolali. Agai koneani, te sipsip dabe me meme dabe augwali te wę tuagasobo sogo, te sipsip omai me te meme omai augwaligo te kibu so dabe penani yaibao, te homu yali. ");
INSERT INTO mps_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tama te meme omai dabego te ni nologo dabe sulama, tama penani emainu yali, tama nosali te so kibu dabego te ame nabo wai te dodobolo pai dabe ame nomainu yalio. ");
INSERT INTO mps_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Tama Jekopgo te dodobolo pai sipsip wai hani tigidali te gasaba tedali muani. Tama agai te Labango tedela yai sipsip omai dabe te so dabe me selama, tama augwaligo Jekopgo dodobolo pai sipsip tonalubadi augwaligo penani yali. Agai te tiwai tama tilama, te aga digi sipsip me meme dabe pedalumainu ilali, tama agai te Labango sipsip me meme dabe dali deliba me sisinibeo. ");
INSERT INTO mps_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tama te wiegi yai bomai sipsip me meme dabe penani ebaso da, teda Jekopgo te ni nologo dabe te wę tubo madi te augwali gesabidide muani, tama augwaligo te ni nologo dabe sulama, tama penani yai. ");
INSERT INTO mps_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tiali goli, agai te bomo meni yai sipsip me meme dabe augwali gesabidide te ni nologo dabe me mubeo. Tama tibaso, te sipsip me meme dabe te bomo meni yai dabe augwali te Labango da, tama te wiegi yai, te boma pai, te dabe te Jekopgo sali. ");
INSERT INTO mps_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Tama tibaso, Jekopgo doado bage geninama, umabo mu elaluali. Agai te sipsip me meme hani genuai mu elaluali, tama sę ebo bidi me sę ebo we hauwa bidai, tama te kibu kamel dabe me donki dabe hauwa bidaluali. ");
INSERT INTO mps_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jekopgo te Labango ogomanigo te po wabo odali, “Jekopgo te dago ayago doado bage dabe tigidali salio,” te po wali. “Tama megi da, agai doado bage hauwa elalubao, tiali goli te wiegi yai nai dabe agai te dago ayade naga sai dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tama Jekopgo suali, Labango kolesaga hasegelama, tama Labango aga te polobadu godolo yai gilama tiwai me ebeo. ");
INSERT INTO mps_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Tama nosali Yawego Jekopbolo te po wai, “Nage te naga ayago buluba, me te naga haniba ma pao,” wali. “Tama ena nage dali bidaibao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Tama tibaso, Jekopgo po te Resel dali Lea sibolo po ola tolama, te augwali si aselama, aga te sipsip hani dabe dali bidalubo pesageba suagasao po wali. ");
INSERT INTO mps_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Te augwali si sabalubode, tama Jekopgo augwali sibolo te po wai, “Eno suali, te dage sigo ayago te enade polobadu yali kolesaga tiwai isiąyu, tama agai kolesaga hasegelali. Tiali goli, eno ayago God te ena dali bidibao. ");
INSERT INTO mps_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Dage sigo koneani, eno te dage sigo aya dali sę bomo yali, ");
INSERT INTO mps_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","tiali goli agai ena tibo po ola menama, tama eno sęde sabo nai te nogo si sogo hasegelali. Tiali goli, Godigo agai ena dolomainu me gogolobeo. ");
INSERT INTO mps_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tama tiyu, e tiwai pedelali. Labango te po wali, ‘Te meme dabe te dodobolo pali naga te nago,’ obaso, teda te meme hani dabego te dodobolo pabo te tobage yai naga te wai dabe ame nani. Ma, agai te po wali, “Te husugu yai sipsip me meme te nago da,” po obaso, teda augwaligo te tobage wai dabe ame nai dao. ");
INSERT INTO mps_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tama tiyu, tama Godigo te dage sigo ayago meme ma sipsip hani selama, te enabolo mawai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Tama te meme omai dabego penani ebo sogo, eno te tiwai na yai, eno te meme omai kibu augwaligo tigide dodobolo pali haniani elalubo suali, te augwaligo naga te meme so kibu dabe penani ebo dao. ");
INSERT INTO mps_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tama eno nade Godigo ensel mobo bidigo ena i olama, tama enabolo te po wali, ‘Jekop.’ Tama eno te po wai, ‘Ena e bidibao.’ ");
INSERT INTO mps_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tama agai po ma wali, ‘Suao. Te omai kibu meme te tigide haniani dodobolo pali, augwaligo naga te meme kibu so dabe penani ebao. Ena digi eno te tiwai ilibao, magi baso meni, eno suali, te Labango nagebolo ebo sę tigidali eno sualio. ");
INSERT INTO mps_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Te God nageba te Betel buluba pedelali, te ena tama dao. Te Betel bulude nago te homu hodolubo masigi me deli dodolali, tama te wel ugwadu daiba gelali. Tama nago bomo yai dąų wali po me deli ena dali dąų walai. Tialima, megi da, te nago doado bage sisi ilao, tama nago te bulu taga peyu, tama naga page buluba ma pagameo,’ agai enabolo te po wali,” Jekopgo aga we sibolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Resel de Lea sigo te po wali, “Te gasa nai me deli te da si go ayade nosali sabo, te menio. ");
INSERT INTO mps_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tama ayago da si te digibulu we si pedalumainu ilali. Agai da side nai polo sai dao. Tiali goli, agai te nai tigidali dobola silai dao. ");
INSERT INTO mps_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tigidali nai Godigo da sigo ayade selama, tama nagebolo mani, te nai te da sigo, me te da sigo wai pulubago nai dabe mu dao. Tama tibaso, nago te Godigo nagebolo wali po gilama tama tiao,” te we sigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tialima, Jekop hogodama, tama aga we wai te kamelba duamainu elama, tama agai te sipsip hani me meme hani polasa, te aga dali te gasa nai sibi te Mesopotemiade sali nai sibi dali, te tigidali polasa tagala palai. Augwali te aga aya Aisak bidibo madi te Kenan tǫba ma painu, te bulu taga soai. ");
INSERT INTO mps_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Te augwali pisiąbadi, tama Laban te sipsip dabe nisi togogi peyu, digibulu gana pai digi, tama Reselgo te aga ayago be tonalubo tibo god te bede wi salio. ");
INSERT INTO mps_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jekopgo te Aram bidi Labanbolo te aga pobao po me wabeo, te aga geme soai. Tama tiyu, agai te aga ili po ola maduali tiwai yali. ");
INSERT INTO mps_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tama eyu, te aga doado bage tigidali selama, tama aga wi soali. Agai te Labango bulu tagalama, tama te wę Yufretis nogolama, tama aga te Gileat bulu du dabe elalubo tǫba painu soali. ");
INSERT INTO mps_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Si sogo bidai digi, tama te bidi dabego te Jekop wi pali po Labanbolo wali. ");
INSERT INTO mps_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tialima, Labango te aga bidi dabe meba selama, tama augwaligo te Jekop pali wali pidubadi, te a naga olama, nogo si, tama sogo wabode sabolali. Tama augwaligo Jekop te Gileat bulu du pedai te badu bidibo suai. ");
INSERT INTO mps_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tama hulide, Aram bidi Labango na yali, tama God agaba pedelama, te po wali, “Nago te Jekop dali magi po me deli, ma aga wi ilibo sę me elamu dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekopgo te aga osogo bidabo pesage te dwasianu bulu dude nigai, tama Labango aga gegelama suali. Labango me aga bidabo pesage te Gileat bulu du elalubo madide nigai, te Jekop bidibo pesage pąde nigali. ");
INSERT INTO mps_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tialima, Labango Jekopbolo te po wai, “Magi baso nago ena ili po ola menama, tama nago eno wegi si te boide sali we si tiwai sela soaliwe? ");
INSERT INTO mps_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Magi baso nago ena tibo po ola menama, tama nage geme naga wi soyu, tama nago enabolo pobao po wabewe? Te hasia nago enabolo wagi sogo da, teda eno nage te wiegi yai homu pemene dali tagala palu, te habidi me gita tęąbi wagi dao.” Labango te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","“Tiali goli, nago ena bolo te eno wegi sibolo, me te eno wąį, eno wegigo wai dabebolo te dage tao po omainogo me ebeo. Nago kolesaga te dwai mu yalio.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","“Eno te nage dolabo bomo elaluali, tiali goli hulide nago ayago Godigo enabolo te po wali, ‘Nago te Jekop wi ilibo sę deli me elamuo,’ po wali. ");
INSERT INTO mps_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Eno koneani, nage te naga page buluba ma pabo homu godolo mu ebaso, tama nago ena taga pali. Tiali goli, magi baso nago eno be tonalubo god dabe wi selasa soaliwe?” wali. ");
INSERT INTO mps_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tama Jekopgo te po wei ponani, “Eno wi yali. Te nago bomonama, naga wegi si ma oda sidali weyu, te ena geme pai. ");
INSERT INTO mps_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tiali goli, te da tomode me deligo te nago god wi sela soai yaibaso da, teda nago aga ela muagameo. Te da e bidalubo bidi dabe gedude te nage aselama, tama dago tigidali sulama, tama dago doado bage osola suao, tama nago naga nai me deli subaso da, teda nago sao,” wali. Tiali goli, Jekopgo konebe, te Reselgo aga ayago god dabe wi sela soali. ");
INSERT INTO mps_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tialima, Laban te Jekopgo ugwa be tomoba pelama, tama agai doado bage dabe susa bilali. Tama nosali aga te Leago ugwa be tomoba pelama, te me susa bilali. Tama aga te sę ebo we sigo ugwa be tomoba me pelama, susa bilali, tiali goli agai god dabe te agai me subeo. Tama aga te Reselgo ugwa be tomoba pali. ");
INSERT INTO mps_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reselgo te aga ayago god dabe wi selama, tama agai te kamel dabe beg tomoba geme dualama, tama aga te beg daide ugwa dualaluali. Labango te ugwa be tomode te tigidali doado bage susa bilali, tiali goli agai te god dabe me subeo. ");
INSERT INTO mps_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tama Reselgo aga ayabolo te po wali, “Aya, nago ena dali wado po me olamuo. Te da we dabe sibigo gasi te ena sobaso, tama ena hodalugobeo.” Labango te tigidali doado bage susa bilali, tiali goli agai god dabe te agai me subeo. ");
INSERT INTO mps_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Tialima, Jekop te sębę elama, tama Laban dali te tiwai wado po wai, “Eno mena dwai sę, me eno mena bomo yai po bolai baso, tama nago bomonama, tama ena te tiwai megi pobeasa asaliwe? ");
INSERT INTO mps_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nago eno doado bage tigidali susa bilama, tama nago bede elaluali naide te mena nai sualiwe? Waa? Te nago suaibaso da, teda nago hanilama, te nago hani me, eno hani me, te augwali gedude hania muao, tama da si tomode te augwa hasi po mia somainao. Tama dago te dego po te dolo mu yabowe nago sueibao. ");
INSERT INTO mps_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ena nage dali bidibadi, te kibu be bidi sese deli yai dao. Tama sesemane sogo te nago sipsip me meme hani tigidali te augwaligo wai ame nabo te me hagawai meni. Tama eno nago sipsip omai me ela tubeo. ");
INSERT INTO mps_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tama te uni hasago nago sipsip me deli ela mubo sogo, eno nagebolo sela asiyu, tama nagebolo me waselagasobeo. Menio. Ena digi eno te haga yali nai wei ponani. Nago sesemane sogo enabolo po bomonama weyu, te be bubugade me hulide te gasa bidi dabego wi sali sipsip meme tigidali wei ponao po oduai dao, tama te tigidali ena digi eno wei ponani. ");
INSERT INTO mps_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ena e tama bididuali, hauwa sogo te giliga posologo ena mu dolali. Tama hauwa sogo hulide me te kedaugo ena dolali, tama ena bugagia godege me pibeo. ");
INSERT INTO mps_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ena nage dali bidiyu sę ebadi, te kibu be bidi sese deli bidali. Ena te kibu be 14 te nago wegi si sainu sę yali, tama te kibu be a naga me deli te nago sipsip hani meba sainu te sę yai. Tiali goli, nago eno sabo mone sę te nago nogo si sogo te hasegelai. ");
INSERT INTO mps_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Tama eno ayago aya Abrahamgo God, te Bidi Wi Ilibo Godibolo te Aisakgo lotu po wabo God, te ena dali me bidigi menigi sogo da, teda nago ena olo ma tagala paligi dao. Tiali goli, Godigo eno homu sęgę ebo, me te eno ebo sę dabe suali, tama tiyu, hulide te aga digi te po bomonama, nage dali te po wali,” Jekopgo te po Labanbolo wai. ");
INSERT INTO mps_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tialima, Labango te po wei ponani, “Te wegi si badi, te augwali sigo wai dabe me, te eno naga dao, tama te sipsip me meme hani dabe te eno da. Te tigidali nai nago suali, te eno nai dabe dao. Tiali goli, eno magi sę te wegi si dali, me te wai dabe dali egowe? ");
INSERT INTO mps_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tialima, da si te bomai po dąų waibao. Tama dago te masigi dabe pesage holama, tama te pesage ede elalubaso, da sigo te dąų wali po homude konealuaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tialima, Jekopgo te bobage masigi me deli selama, tama te dąį tiwai ilama, tama dodolai, ");
INSERT INTO mps_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","tama agai aga hani dabebolo walama, tama augwaligo te masigi dabe meba pesage holao po wai. Augwaligo te sę ela silama, tama augwali te masigi pesage holali pąde te nai be pio tuali. ");
INSERT INTO mps_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Te Aram pode Labango te bulu nogi te Jegar Sahaduta poali, tama te Hibru pode Jekopgo te bulu nogi Galet poali. ");
INSERT INTO mps_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labango te po wali, “Te e masigi pesage holali te da sigo te bomai po dąų wali, te homugo gegeda palidali weyu, te dąį tiwai muani.” Tama tibaso, augwaligo te bulu nogi te Galet poai. ");
INSERT INTO mps_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Tama Labango te po ma wai, “Megi da, te da si tomode te dwai kolesaga idali homu eyu, te da si talua si ma bidigobeo. Nage me badu tedali bidiyu, te ena gasa badu tedali bidaibao. Tama eno homugo Yawego da si tonaluaibao,” wali. Tama tibaso, te bulu nogi augwaligo Mispa poai. ");
INSERT INTO mps_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tama Labango po ma wadolama, wali, “Te nago eno wegi si dali dwai sę eyu, tama te nago gasa we me sobaso, tama eno konesiąbaso da, teda eno homugo nago te Godigo da si tonaluba te homu yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nosali Labango te Jekopbolo te po wai, “Nago te da si tomode te masigi pesage holali sulama, tama eno te bobage masigi muani, te po dąų wali te homugo konealumainu ebao. ");
INSERT INTO mps_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Te masigi pesage holali, me te homugo konealumainu muani bobage masigi, te augwali side da sigo homu konealumainu tama tiwai, eno te bolama, nage dali hwįagasogobeo, tama nago me te bolama, ena dali me hwįgobeo. ");
INSERT INTO mps_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Eno homugo te Abrahamgo God me Nahorgo God, agai te da sigo ebo kolesaga dagalaibao,” Labango te po wai. Tialima, Jekopgo te Godigo nogide bomai po dąų wali, te aga aya Aisakgo lotu wabo Bidi Wi Ilibo God dao. ");
INSERT INTO mps_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Agai te kibu sipsip me deli elama, te bulu dude Godibolo ofa mani. Tama agai aga hani dabe aselama, te nai be piode tuagasomainu i wai. Augwaligo te nai tula silama, tama hulide augwali te bulu dude piai. ");
INSERT INTO mps_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Te kigamu digi mu, Labango te aga wegi sibolo, me te aga wegi sigo wai puluba dabe, augwalibolo te dage dali dwagi yai sę naga pedalumainao po weyu, tama dage tao po olama, tama agai augwali taga peyu, tama aga buluba ma geasa palio. Jekopgo Iso suainu sisi yai ");
INSERT INTO mps_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Te Laban aga buluba ma geasa pelama, tama Jekop aga page buluba painu eyu, ma pali. Tama aga pidubadi, tama Godigo ensel mobo bidi dabe te sunumide aga pageba pedelai. ");
INSERT INTO mps_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Agai augwali sulama, tama agai te po wai, “Te augwali Godigo ami bidi hani dao.” Tialima, agai te bulu nogi Mahanaim poai. ");
INSERT INTO mps_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Tama Jekopgo bidi meba te polasa te Seir tǫ te Idom hanu tǫ pedaiba te aga ama Iso bidibo digi te po sela pomainogo tagala palai. ");
INSERT INTO mps_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Tama agai augwalibolo te po sela pomainu ola mani, “Ena Jekop dao, ena te nago sę bidi dao. Eno ama Iso, nage da eno genuai bidi dao, te ena Laban dali osogo bidigi pai goli, tama ena bobage sogo tede bidama, tama megi ena ma asainogo ebao. ");
INSERT INTO mps_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Eno hani sibi te hauwa elalubo, te kibu bulmakau, me donki, me sipsip, me meme, me sę bidi dabe, me sę ebo we dabe, te elalubao. Tama eno te po nageba ola tolobao, eno genuai bidi, tama eno homugo nago wiegi yai homu ena dali emainogo ebao, tama nago ena ma asomainu usu da po omainogo obao,” agai te po ola tolali. ");
INSERT INTO mps_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nosali te po sela pali bidi dabe augwali ma begasa asiyu, Jekopbolo te po wagasali, “Da te nago ama Iso bidibo digi sabolalio, tama agai nage te sunumi tiąba asainu sisi iduali. Aga dali asabo bidi dabe te hauwa, 400 bidi elaluali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jekopgo te po odama, tama aga wi genuai mu elama, tama aga homu sęgę elama, tama homu hauwa yali. Tialima, agai te aga we bidi hani bugulali, te sipsip hani dabe, me te meme, me bulmakau, me kamel dali, tama hani si pedelali. ");
INSERT INTO mps_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Agai te tiwai homu yali, ‘Te Iso asiyu, tama te polali hani dali wąbi hwįnama, tama augwali dolobaso da, teda te nosali yali hani te sana pelama, wi paibao,’ te homu yai. ");
INSERT INTO mps_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tama Jekopgo gedu haluasa po wali, “Te eno wąį Abrahamgo God, te nage eno aya Aisakgo God, nago eno po odao! O Yawe, nago enabolo te tiwai po wai, ‘Nage te naga tǫba ma peyu, tama naga deli kaneme bidibo digi pao,’ wali, ‘tama eno nage bugagia tonaluaibao, wai dao. ");
INSERT INTO mps_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ena nago sę bidi da. Ena wiegi yai bidi meni goli, tiali goli nago wiegi yai kolesagago ena olo tau sali, tama nago ena dali homugo kęą pai kolesaga eyu, tama enade wiegi yai sę mu yai. Te polobadu ena te wę Jordan nogeali sogo, te eno nogode magi nai me elalubeo. Eno peyu tolasa pabo dono naga elaluali. Tiali goli, megi ena te e hani si dali ma asobao. ");
INSERT INTO mps_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Eno nageba gedu haluasa po obao, nago ena tau selama, te eno ama Isogo bomo aiyaba tamunao. Magi baso meni, ena wi ebo, tiyu agai da dali wąbi hwįagasiyu, tama da tigidali silama, te we wai dabe dali silaibao. ");
INSERT INTO mps_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ena tau mao. Nago naga dąų wali bomai po te ma homugo koneao. Polobadu nago te po wali, ‘Te eno nage bugagia tonaluaibao,’ wai. ‘Tama eno te nago wąį te wai dabe hauwa menama, tama te bidi dabego augwali nedebo usu me egobeo. Te augwali te węde te masigi sane tiwai pedelaibao,’ nago te po wali,” Jekopgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jekop te hulide bididu, tama aga ama Iso homu nagame iliyu maiabo nai te kibu dabe meba dodola muai. ");
INSERT INTO mps_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Agai e tama tiwai sa muani, 200 meme so kibu, te omai kibu bidi sese deli te 20, te 200 sipsip so, me te omai kibu bidi sese deli 20, ");
INSERT INTO mps_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","te 30 kamel so augwa wai elalubadi, te 40 bulmakau so, te omai bulmakau nogo si, te donki 20 so kibu, te omai kibu donki nogo si dao. ");
INSERT INTO mps_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Agai te kibu dabe tonalubo sę bidi dabe deli deli nidigili pali, tama augwalibolo agai te po wali, “Dage polasa peyu, ena nosali ilao. Tama me kibu hani te gasa kibu hani pabo digibulu bidaluao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Tama Jekopgo te polalubo sę bidibolo te po wali, “Te eno ama Isogo te nage sunumide sulama, tama nagebolo hanalu, ‘Nage dego sę bidi dawe? Tama nage mena sobawe? Tama e te kibu hani dabe dego dawe?’ te po hanalu waibao. ");
INSERT INTO mps_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Teda nago e tiwai po wei ponao, ‘Te e kibu hani dabe te nago sę bidi Jekopgo dao,’ te po wao. ‘Genuai bidi, te Jekopgo te olo maiabo dwagi yai nai te nageba tagala palai. Tama Jekop digi aga te nosali asobao,’ nago te po Isobolo wao,” Jekopgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tama Jekopgo te po naga te tomo me sę bidibolo wali, tama te sela wali sę bidibolo me, tama te kibu dabe tonalubo tigidali sę bidi dabebolo te po naga wai. Agai te po wali, “Te dagego aga subo sogo, te po naga agabolo wao. ");
INSERT INTO mps_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tama dagego te tiwai po ma naga weyu yao, ‘Awe, nago sę bidi Jekop te da tudibadu nosali asobao,’ po waiyąo.” Jekopgo te tiwai homu yai, ‘Eno te ena ama homu nagame ilibo nai te polasa tagala palaibao,’ te homu yali, ‘tama eno aga gesabi subo side, teda agai eno aga dali polobadu yali sę te agai homu gegeda palaibao,’ te homu yali. ");
INSERT INTO mps_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Agai te maiabo nai dabe polasa tagala palama, tama aga bidali pesagede te sogo hulide bidai. ");
INSERT INTO mps_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tama te sogo hulide Jekop hogodama, tama aga we si selama, tama augwali sigo sę ebo we si me sobadi, te aga wai dabe nogo si olama, sągągo deli selama, tama agai te wę Jabok nogelama pali. ");
INSERT INTO mps_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Agai augwali tagala palama, tama agai aga doado bage me tigidali sela pela silai. ");
INSERT INTO mps_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tama agaduba deli naga bididuai. Tialima, hulide bidi me deli pedelama, tama aga dali nogogo pelegebo hwįdubadi, be posobo siba usu nani. ");
INSERT INTO mps_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Augwali si tama tiwai hwįdubadi, tama te bidigo koneani, agai aga aiyaba elalugobeo, te homu yai. Tama agai Jekop te sili dili dali, te tudi dili dali si ununani si tede elali. Tama te sili dili ununani te guda pali. Te augwali si usu siyu hwįdubadi, ");
INSERT INTO mps_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","tama te bidigo Jekopbolo te po wai, “Nago ena tagala palama, ena paio,” wai. “Te pąde be posainogo ebao,” wali. Tiali goli, Jekopgo agabolo te po wai, “Eno nage me tagala palogobeo. Nago te dwagi yai tau sabo po enabolo mayu bolo yao.” ");
INSERT INTO mps_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tama te bidigo Jekopbolo hanalu wali, “Nago nogi de dawe?” Tama Jekop po wei ponani, “Ena nogi te Jekop dao.” ");
INSERT INTO mps_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tialima, te bidigo te po wai, “Megi da, nago nogi te Jekop ma wagobeo. Nago te God dali hwįani, tama bidi dali me hwįai, tama nago nogi ugwaba sali. Tialima, nago gesi nogi te Israel dao.” ");
INSERT INTO mps_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tama Jekopgo te po wai, “Ae, nago nogi po enabolo wao,” te po wai. Tiali goli, agai te po wei ponani, “Magi baso nago enabolo eno nogi po hanalubawe?” Tama agai Jekopbolo te aga dali dwagi yai sę pedelabo po mawai. ");
INSERT INTO mps_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Tama nosali aga noma sobaso, Jekopgo te po wai, “Eno God sualio, tiali goli ena me isibeo.” Tama tibaso, agai te bulu nogi Peniel poai. ");
INSERT INTO mps_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Te giliga pedelama, tama Jekopgo te Peniel bulu taga soai. Tiali goli, aga dolo bugagia me soabeo, aga te haiagalu ela soali, magi baso meni, te sili si wadolali te guda palio. ");
INSERT INTO mps_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tama te sogo dąį elama, megi tama bidada asobo sogo, te Israel dabe augwaligo te kibu sipsip, meme, bulmakau, te bage sili dilide daganalubo mi te me tubeo, magi baso meni, polobadu te bidigo Jekop te sili dilide elali dąį elama, tama tiai dao. ");
INSERT INTO mps_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Te Jekop aga hani dali tama pobadi, tama agai digibulu gana tonoyu, tama Iso te aga hani bidi dabe te 400 dali asobo suali. Tama aga hani tigidali wai dabe bugulama, tama te Leaba, me Reselba, me te sę ebo we sibolo te dobaba pali. ");
INSERT INTO mps_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Agai te sę ebo we si augwa wai dabe dali augwali te podolali. Tama Lea aga ogomani dali augwali wali pomainu ilali. Tama agai te Resel te Josep dali nosali mu ilama, pali. ");
INSERT INTO mps_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jekop digi aga hani asobadi, te aga polasa pali. Tama agai kidu tǫba susugunu pidubadi geani, te nogo a naga olama, me badu si sogo te usu nigi peyu, te aga ama pageba pedelali. ");
INSERT INTO mps_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tiali goli, Iso udada aselama, tama aga ama pagea sagaselama, tama aga dali nono nai. Tama aga si talua si gela wali. ");
INSERT INTO mps_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Tama Isogo tonono bilama, suali, te we dabe me, wai puluba dali sulama, tama agai Jekopbolo hanalu wali, “Te e mena we wai nage dali bidibawe?” Jekopgo po wei ponoyu, te po wai, “Godigo wiegi yai kolesaga nago sę bidi enabolo elama, tama agai te wai dabe enabolo mawai dao.” ");
INSERT INTO mps_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tialima, te sę ebo we si augwa wai dabe dali aselama, tama augwali te Iso gedude te tǫba kidu sugunagasali. ");
INSERT INTO mps_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tama Lea me aga wai dabe dali, augwaligo me te tǫba kidu sugunagasali. Tama simaniyu mu, Josep dali Resel si aselama, tama te tǫba kidu sugunagasai. ");
INSERT INTO mps_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tama Isogo te po wai, “Eno te gasa hani polasa sobadi sisinama suai. Te magi basowe?” Tama Jekopgo te po wali, “O genuai bidio, te nago homu wiegi yai ena dali emainu yai dao!” ");
INSERT INTO mps_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tiali goli, Isogo te po wai, “Eno ama, ena doado bage usu yai elalubo. Nago naga nai dabe ma sao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tama Jekopgo te po wai, “Woo, te nago ena dali dwagi yai homu eba wida, teda nago eno te mabo nai sao,” wali. “Eno nage gesabidi sulama, tama eno te God gesabidi subo tiwai yali, magi baso meni, te nago ena dali dwagi yai homu yai. ");
INSERT INTO mps_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Megi eno homugo nago te eno nage mabo te nai nago sao, Godigo dwagi yai kolesaga ena dali elama, tama agai tigidali nai ena menama, tama ena usu mu yai,” wali. Agai Isogo te nai somainogo bomo mu ebaso, tama Isogo te nai sai. ");
INSERT INTO mps_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Tama nosali Isogo te po wai, “Tialima, megi da, da sisi elama, paibao. Tama ena te polasa pobadi, te dage nosali asiagameo.” ");
INSERT INTO mps_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tiali goli, Jekopgo agabolo te po wai, “Genuai bidi, nago koneani, te wai dabe augwali te bomo elama me pabeo. Tama eno homu hauwa te sipsip me, te bulmakau hani dali, te augwali tamadi holobo wai dabede te homu yai. Te augwali deli sogo bubugade bomonama pobaso da, tiyu te tigidali kibu sibi dabe te isila pidalio. ");
INSERT INTO mps_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Genuai bidi, nage te ena asobadi te polasa polo pagameo, te ena dua dua nosali asiduaibao, te eno kibu sibi dali te eno wai dabe asaibao. Tama nosali nage eno te Seirde da si te deliba gesabi yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tama Isogo te po wai, “Te eno hani bage meba nagebolo mawaibao,” wali. “Augwali te nage dali bidiyu, tama dage odasa asomainu yaibao.” Tiali goli, Jekopgo te po wei ponai, “Genuai bidi, eno homugo te nago wiegi yai homu ena dali emainao. Tiali goli, nago bidi dabe ede bidao homu, te tagalao, te eno sę ebo augwali te usu yaibao.” ");
INSERT INTO mps_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tama te po obaso, te sogo bubugade digi Iso te Seirba ma painu soai. ");
INSERT INTO mps_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tiali goli, Jekop te Sukot teba pai. Tama aga be sę ebadi, te kibu sibi dabe osogo piabo dwasianu be me sę yani. Tama tibaso, augwaligo te bulu nogi Sukot poai dao. ");
INSERT INTO mps_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jekop te Mesopotemiadu ma begasa asali, tama aga Sekemgo hanuba, te Kenan tǫ pedaiba bugagia nosali sabolai. Tama aga ugwa be dabe te hanu pąde sę yani. ");
INSERT INTO mps_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tama agai te tǫ te Hamor hani bage dali mu abelali, te Hamor Sekem aga aya da. Te tǫ abelali mone te 100 silva masigi tamago abelai. ");
INSERT INTO mps_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tama agai te alta me deli tede dodolali. Tama agai te alta nogi te tiwai poali, “Te Israelgo God da, te bomo yai God mu dao,” te nogi poali. ");
INSERT INTO mps_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Te Daina te Jekop de Lea sigo wegi, tama me sogo agai te bulu page we dabe meba bidibo sugi pai. ");
INSERT INTO mps_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hamor, aga te Hivi hani bidi me deli, aga tede tobolu bidi nigilama bidai. Agai ogwa, te Sekem, agai te Daina sulama, tama agai aga nogo tulama, tama aga dali dwai sę yali. ");
INSERT INTO mps_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tiali goli, Sekemgo te Jekopgo wegi Daina te wei mu ebaso, tama agai te aga homu wiegi yai ilibo po dua digi wai. ");
INSERT INTO mps_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tama nosali Sekemgo aga ayabolo hanalu wali, “Ayao, te we selama, te eno we bidaibao.” ");
INSERT INTO mps_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jekopgo odali, te Sekemgo dwai sę te Daina dali yali po, te aga wegi dao. Tiali goli, agai ogomani te augwali te kibu sipsip meme sibi dabe tonalugi peyu pai. Tama Jekopgo po me wabeo. Agai ogomani te sęba pali ma asobo tonaluali. ");
INSERT INTO mps_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tama Hamor te Sekem aga ayago te Jekop dali po miainu asai. ");
INSERT INTO mps_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Augwali te po midubadi, tama aga ogomani te sęba pali, ma beba asali. Magi baso meni, augwaligo odali, te Sekemgo augwaligo abe penani yali po, tama augwali homu dene eyu, sębę mu elama, tama wado po wai. Te sę te Sekemgo te Jekopgo wegi wi sali, te hale ilibo kolesaga mu te Israel dabego gedude yai. Te Israel dabe augwaligo homude, te tobage kolesaga ebo te habu mu sai elaluai. ");
INSERT INTO mps_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Tama Hamorgo augwalibolo te po wai, “Sekem te ogwago te dagego wegi wei mu ebao. Tama eno dagebolo hanalubao, te augwali si sabo, usu egowe? ");
INSERT INTO mps_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Teda da abagi olama, te dago dagego wegi dabe siyu, tama dagego dago wegi dabe siyu inao. ");
INSERT INTO mps_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tama dage da dali te e tǫ pedaide bidagameo. Tama duga te bidainu yali, te tǫ pedaide bidagameo. Tama dagego dabolo nai dabe abeliyu, tama dago dageba nai abeliyu yaibao. Tama dagego te duga sainu wei yali nai te sagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Tialima, Sekemgo te Daina aga ayabolo me aga abe dabebolo te po wai, “Te dagego enabolo usu obaso da, teda eno dagebolo te mena nai dagego sainu homugo wei ebo nai, te dagebolo eno mawaibao. ");
INSERT INTO mps_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tama dagego te duga sabo wei ebo wiegi yai nai po enabolo po wao. Te wegide mone nisu naga dagego muabo homu ebaso da, te usu da, te eno dage mawaibao. Tiali goli, eno homugo dagego te we enabolo menama, tama eno aga saibao,” te bidi Sekemgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Te Jekopgo ogwa dabego te augwa abe Dainade te Sekemgo dwai penani sę yali, tede homu kone palali. Tama augwaligo te Sekem dali, aga aya dali sibolo te tibo po ola mabo po wei ponani. ");
INSERT INTO mps_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Augwaligo te po wali, “Dago abe te aga tigiwali togosiąwai bidi dali pomainogo me egobeo. Te dago tama tiyu da, teda da hale dwai mu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tiali goli, dagego e tiwai sę me deli bolo hasia yao. Dagego te duga bage bidi te tigiwali togolama, te augwali da tiwai pedaliąo, tama nosali te dago usu da po dage dali waibao. ");
INSERT INTO mps_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Te dagego te tiwai tama tibaso da, teda dago dagebolo usu da olama, tama dagego te dago wegi dabe siyu, te dago me dagego wegi dabe siyu yaibao. Tama da dage dali hodobo bidiyu, tama da deli hani pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tiali goli, dagego dago po wali pisąma, tama tigiwali togosiąbaso da, teda dago te dena abe ma selama, tama dago e bulu taga paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tama Hamor me, aga ogwa dali, augwali sigo te po godolo yai. ");
INSERT INTO mps_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tama Sekemgo augwaligo te po polo wali pali, magi baso meni, agai te Jekopgo wegi godolo yali. Sekem te aga deli hani bagego aga te polalubo bidi da te yai. ");
INSERT INTO mps_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tialima, Hamor dali aga ogwa Sekem augwali si te bidi sisinibo pesage te hanu sunumi pąde teba pelama, tama augwali sigo te hanude bidalubo gasa bidi dabe dali po miani. Augwali sigo te po wali, ");
INSERT INTO mps_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Te Jekop aga hani bidi augwali wiegi yai bidi hani, tama augwali da dali abagi wainogo homu ebo. Tama dago tǫ te genuai tǫ elalubao. Dago augwali te dago tǫde bidimainu emainao, tama augwa homugo bilalumainao. Dago augwaligo wegi dabe siyu, tama dago wegi dabe augwaligo siyu, tama emainu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tiali goli, augwaligo te sęde bomo mu yai, dago te dena bidi dabe augwali tigiwali togolama, tama augwali tiwai pedalinao. Te dago tama tiyu da, teda te bidi hani te da dali bidainu usu da olama, tama da dali deli hani pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tama te sipsip meme dabe me, te walu dabe, tama augwaligo bulmakau dabe me, te augwali dago nai pedelaibao. Tiali goli, dago te sę me deli inao, te augwali da dali usu da olama bidaibao,” te Hamor de Sekem sigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Te tigidali hanude bidaluali we bidi augwaligo te Hamor de Sekem sigo po usu da olama, tama augwaligo te tigidali bidi dabego tigiwali togwa silai. ");
INSERT INTO mps_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Te sela sogo bidama, tama te bidi dabe tigiwali togwali te dene mu iduali. Tama Jekopgo ogwa si, Simeon me Livai, te augwali si te Daina aga abe si mu dao. Te augwali sigo te moni bainat hwą ge selama, tama tibo te hanuba biligi pai. Tiali goli, augwali sigo te bidi dabe augwali ela muabo te augwaligo konebeo. Megi da, te augwali sigo te hanude bidali bidi dabe tigidali ela silai. ");
INSERT INTO mps_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Augwali sigo te Hamor dali, aga ogwa dali si ela mubadi elama, tama augwa si abe Daina te Sekemgo bede oda selama, tama augwali pali. ");
INSERT INTO mps_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Tama te Jekopgo gasa ogwa dabe augwali asama, tama te ela muani bidi dabe tede suali. Tama augwaligo te hanude wiegi yai nai tigidali selama, tama pali, magi baso meni, Sekemgo te hanude te kolesaga Dainade yali, te Israelgo gedude te wiegi yai me ebeo, dwai mu dao. ");
INSERT INTO mps_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Augwaligo te sipsip hani me, te bulmakau hani me, te donki hani sobadi yali, tama augwaligo te hanude me te gide elaluai nai dabe tigidali mu sela silai. ");
INSERT INTO mps_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Augwaligo te tigidali wiegi yai nai me, te augwaligo tigidali we wai me sali, tama augwaligo te be tomode munaluali tigidali doado bage me, te tigidali sela silama, tama augwali pai. ");
INSERT INTO mps_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jekopgo Simeon de Livai augwali sibolo te po wai, “Dage sigo ena te dwai ilalio. Te tigidali we bidi tede bidalubo, augwali te Kenan hani me Peres hani, augwaligo te ena godolo ma egobeo. Eno bidi dabe te hauwa me elalube, tama te bidi dabe augwa hasi te deliba sisiniyu da, teda augwaligo ena dali, te eno we wai dabe dali tigidali ela silaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tiali goli, augwali sigo te po wai, “Dago te bidi me deligo dago abe te penani we nogi sidali weyu, te dago me gogologobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tama nosali Godigo Jekopbolo te po wai, “Nage hogodama, tama nage te Betelba pelama, tama nage teba osogo bidigi pao,” wali. “Tama nago te Godibolo ofa yabo te alta sai me deli nigao, te God nageba pedelali, te naga ama Iso dali wi ebaso soali sogo, te God nageba pedelai,” wali. ");
INSERT INTO mps_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tialima, Jekopgo te aga we waibolo, me te augwali dali bidaluali we bidi tigidalibolo wai, “Dagego duga tibo god dabe tigidali te sela sąyao. Dage te wę bugagia paluama, tama meda meni yai ugwa naga muao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","“Te dago te bulu taga peyu, te da Betel teba holoyu, tama paibao. Tama eno te Godibolo te alta me deli nigaibao. Agai ena te sęgę elalubo sogo tau sali, tama ena menaba pali, teba aga ena dali bidali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tialima, augwaligo te augwa tibo god dabe tigidali te Jekopbolo mawai. Tama te odode walali ring dabe me te augwaligo agabolo mani. Tama Jekopgo te nai dabe tigidali te Sekem pąde te genuai ni page dologode pubulali. ");
INSERT INTO mps_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Jekop dali aga ogomani augwali pepela wali. Tama Godigo te Sekem hanu pąde bidalubo we bidi augwaliba te genuai wi pedalumainu ilama, tama augwaligo te Jekop dali me boi hwįabo homu eyu, pobeasa pabeo. ");
INSERT INTO mps_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Tama Jekop aga hani dali augwali tigidali te bulu Lusba pali, te bulu gasa nogi me Betel wabo, te Kenan tǫ pedai badu elalubo buluba tama pali. ");
INSERT INTO mps_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tama agai te alta sai me deli nigilama, tama te bulu nogi poali, te Betel God da wali, magi baso meni, God aga digi aga te Jekopbolo waselai, te aga amade wi elama soali, te sogo aga ola mani. ");
INSERT INTO mps_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Tama Debora, te Rebekago sę polobadu yali we, aga isai, tama augwaligo aga te Betelde te genuai ni dologode pubulai. Tama augwaligo te ni nogi poali, ‘Tede gela wali ni dao,’ te po wai. ");
INSERT INTO mps_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Te Jekop te Mesopotemiade bidali ma asobo sogode, God te agaba ma pedelama, tama agaba dwagi yai sę pedelabo po te agabolo mawai. ");
INSERT INTO mps_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Tama tiyu, Godigo agabolo te po wai, “Nago nogi Jekop dao. Tiali goli, megi da, te augwaligo nago nogi te Jekop ma nogi me wagobeo. Augwaligo nago nogi te Israel nogi yaibao,” wali. Tama Godigo aga nogi te Israel poali. ");
INSERT INTO mps_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Tama Godigo agabolo te po wali, “Ena da, te Tigidali Bomo Mu Elalubo God dao. Nago te wai hauwa pedalumainu yao. Te nage hauwa we bidigo wąį hani pedelama, tama te bidi dabe meba augwali te gavman tuni bidi pedelaibao. ");
INSERT INTO mps_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Te tǫ eno polobadu te Abrahambolo me Aisakbolo mani tǫ, te megi eno nagebolo mobao. Tama eno nago hani wąį dabebolo me mawaibao.” ");
INSERT INTO mps_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Godigo po miani silama, tama agai Jekop taga peyu, aga te dagaluba ma pai. ");
INSERT INTO mps_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Tialima, Jekopgo te Godigo aga dali po miani pesagede te bobage masigi me deli selama, te ugwaba dodolama, muani. Tama agai te masigi daiba ugwadu te wain wę me, wel dali si te ofa tiwai elama gelali. ");
INSERT INTO mps_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Tama tiyu, te bulu agai te nogi Betel ma poali. ");
INSERT INTO mps_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Augwaligo te Betel taga peyu, tama augwali te Efrata teba painu yali. Augwali pedubadi, tama te Reselgo wai tega pabo sogo te pedelali. Tama aga dene genuai mu sai. ");
INSERT INTO mps_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Te aga te tiwai genuai dene sabo sogo, te aga tau sabo wego agabolo te po wali, “Nage wi me elamuo. Te gasa ogwa wai me dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tama pąde Resel mu isainu ebode, tama agai te wai nogi Benoni poali. Tiali goli, aga ayago aga nogi Benjamin poai. ");
INSERT INTO mps_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resel isibaso, tama augwaligo aga te Efrataba pabo sunumide pubulali, te Betlehem hanu pąde dao. ");
INSERT INTO mps_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tama Jekopgo aga pubulali gų page homugo konealumainu tama masigi me deli dodolali. Tama te Reselgo dąį ilali te megi me elalubo dao. ");
INSERT INTO mps_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Tama Israel pelama, tama te gasa bagego augwa sipsip tonalumainu eyu, bobage masigi be sęwai madi, te bulu taga soyu, tama dwasianu pelama gana tama aga bidabo pesage nigai. ");
INSERT INTO mps_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel tede bididubadi, tama Rubengo te aga ayago sę ebo we Bilha dali pagela piali. Tama Israelgo te tiali po odali. Te Jekopgo ogwa dabe te nogo si olama, sągągo si elaluai. ");
INSERT INTO mps_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Te Leago wai dabe e dao, Ruben, te Jekopgo gomunai ogwa da, tama Simeon, me Livai, me Juda, me Isakar, me Sebulun. ");
INSERT INTO mps_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reselgo wai si elaluali, Josep me Benjamin. ");
INSERT INTO mps_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha te Reselgo sę ebo wego te wai si elaluali, Dan me Naptali. ");
INSERT INTO mps_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silpa, te Leago sę ebo wego te wai si elaluali, Gat me Aser. Jekop te Mesopotemia tǫde bidiyu, tama agai te wai dabe augwali ame nai. ");
INSERT INTO mps_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jekop te aga aya Aisak bidibo digi, te moni ni sili nogi Mamre, teba sabolali. Te bidi mebago te bulu nogi te Kiriat Arba nogiyu, tama nosali te gasa nogi me elaluali, te Hebron nogi yali. Te bulu te Abraham me Aisak te polobadu bidai bulu dao. ");
INSERT INTO mps_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Te Jekop aga Aisak dali nosali bidada peyu, tama Aisak te kibu be 180 bida silama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Aga te monu dabe mu elama, tama mobo kegebo silama, tama aga isali hani bage dali bidigi pai. Tama aga ogwa si, Iso me Jekop, augwali sigo aga pubulai dao. ");
INSERT INTO mps_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Te e da, te Isogo hani wai dabe, te augwaligo Idom nogi me poali. ");
INSERT INTO mps_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isogo te Kenan we dabe sela sai, Ada te Elongo wegi, te Hit hani bidi me deli, tama Oholibama te Anago wegi, te Ana aga aya te Sibeon, te Hivi hani bidi me deli da, ");
INSERT INTO mps_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","tama Basemat te Ismaelgo wegi, te Nebaiotgo abe da. ");
INSERT INTO mps_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adago te Elifas ame nani, te Isogo wai, tama Basematgo te Ruel ame nai. ");
INSERT INTO mps_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tama Oholibamago te Jeus, me Jalom, me Kora, te tama ame nai. Isogo te wai dabe te Kenan tǫ tede bidibadi ame nani. ");
INSERT INTO mps_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Nosali Isogo aga ama taga peyu, tama aga hogodama, gasa buluba me pali. Agai te aga we wai me, te aga we wai dali bidali we bidi dabe dali sobadi, tama tigidali kibu hani sibi te agai Kenande sali nai dabe tigidali selama, tama augwali pali. ");
INSERT INTO mps_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Te Jekop de Iso augwali si bidali tǫ te augwali sigo kibu dabe pągąna selama, tama augwali si talua bidabo te usu me ebeo. Tama tibaso, Isogo Jekop taga peyu, ");
INSERT INTO mps_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","tama aga te Seir dabego bulu du dabe elalubo tǫba bidigi pali. Idom te Isogo gasa nogi me dao. ");
INSERT INTO mps_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Te Isogo nosali pedelali hani bage augwaligo aga gasa nogi Idom sali, tama augwali te Seir bulu du dabe elalubo bulude bidaluai. Augwali e tama pedelali po megi obao. ");
INSERT INTO mps_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Te Isogo ogwa dabe, te augwali e dao, Elifas te Isogo we te Adago ogwa da, tama Ruel te Isogo we Basematgo ogwa dao. ");
INSERT INTO mps_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Te Elifasgo ogwa dabe, te augwali e dao, Teman, me Omar, me Sefo, me Gatam, me Kenas. ");
INSERT INTO mps_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna te Isogo ogwa Elifasgo nosali sali we, tama Timnago te Amalek ame nani. Te hani ogwa dabe augwali te Isogo we Adago wąį dabe da. ");
INSERT INTO mps_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Te Ruelgo ogwa dabe, te augwali e dao, Nahat, me Sera, me Sama, me Misa. Te e dabe te Isogo we Basematgo ogwago hani ogwa dabe da. ");
INSERT INTO mps_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Te Isogo we Oholibama agai ogwa Jeus, me Jalam, me Kora, te tama ame nani. Te e da te Oholibamago hani ogomani dabe, te bidi Anago wegigo wai dabe. Tama Ana aga aya te Sibeon dao. ");
INSERT INTO mps_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Te e da, te Isogo wai hani dabe augwali te tobolu bidi dabe bidali. Te Isogo gomunai ogwa te Elifasgo ogwa dabe, te augwali e dao, te tobolu bidi dabe te Teman, Omar, Sefo, Kenas, ");
INSERT INTO mps_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, Amalek. Te augwali te Elifasgo tobolu bidi hani dabe te Idom dabe da. Augwali te we Adago hani wai puluba te wąį dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Te Isogo ogwa Ruel aga wai dabe te augwali e dao, te tobolu bidi dabe augwali Nahat, Sera, Sama, Misa. Augwali te Ruelgo tobolu bidi hani te Idom dabe da. Augwali te Isogo we Basemat tego wąį te wai dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Te Isogo we Oholibamago ogwa dabe te augwali e dao, te tobolu bidi te Jeus, Jalam, Kora. Oholibama te bidi Anago wegi, tama Isogo we agai te tobolu bidi dabe ame nai. ");
INSERT INTO mps_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Te e da, te Isogo hani wai dabe, tama gasa nogi Idom, te augwaligo tobolu bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Te e da, te bidi nogi Seir aga ogwa dabe, aga te Hor hani me deli da. Tama te Hor hani bage augwali te Seirgo tǫ pedaide bidai. Tama Seirgo ogwa dabe te augwali e dao, Lotan, me Sobal, me Sibeon, me Ana, ");
INSERT INTO mps_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","tama me Dison, me Eser, me Disan. Te bidi dabe augwali te Hor hanigo tobolu bidi hani dabe da, tama augwali te Seirgo wai dabe te Idom pedai badu dao. ");
INSERT INTO mps_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotango ogwa si elaluali, Hori me Homam. Tama te wegi Timna te Lotango abe da. ");
INSERT INTO mps_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Te Sobalgo ogwa dabe, augwali te e dao, Alvan, me Manahat, me Ebal, me Sefo, me Onam. ");
INSERT INTO mps_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Te Sibeongo ogwa dabe, te augwali e dao, Aia me Ana. Te bidi Anago te talua ge wę pedalubo te bidi meni yai madi pedalubo te aga aya Sibeongo kibu donki tonaluali sogo gegai dao. ");
INSERT INTO mps_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Te Anago wai dabe, te augwali e dao, te bidi Dison, me Oholibama, te Anago wegi dao. ");
INSERT INTO mps_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Te Disongo ogwa dabe, te augwali e dao, Hemdan, me Esban, me Itran, me Keron. ");
INSERT INTO mps_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Te Esergo ogwa dabe, te e dao, Bilhan, me Savan, me Akan. ");
INSERT INTO mps_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disango ogwa si yali, Us me Aran. ");
INSERT INTO mps_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Te e da te Hor hanigo tobolu bidi hani dabe da, Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO mps_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser, Disan. Augwali te Seir tǫ pedai badu te Hor hani deli deligo tobolu bidi hani dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Te Israel dabe augwa hani tuni bidi king menibadi, tama te Idom bagego gavman tuni bidi king dabego te Idom pedai badu tonaluai. Augwali e tiwai pedelali. ");
INSERT INTO mps_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela te Beorgo ogwago te Idom tonaluali. Te aga king sę eyu bidali hanu nogi da, te Dinhaba. ");
INSERT INTO mps_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Te Bela isibaso, tama te Jobap, te bidi Serago ogwago, te aga te Bela tuni bidi sęde hasegelama, bidali. Bosra te bulu te Jobapgo page bulu dao. ");
INSERT INTO mps_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tama nosali Jobap isibaso, tama Husamgo te aga hasegelama, tama tuni bidi pedelali. Husam te Teman pedai badu bidi dao. ");
INSERT INTO mps_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam isibaso, tama Hadat, te Bedatgo ogwa, te aga tuni bidi pedelali. Hadatgo te Midian hani dali te Moap tǫde boi hwįnama, tama te Midian dabe aiyaba elaluali. Avit hanu te Hadatgo king sę eyu bidali hanu dao. ");
INSERT INTO mps_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Te Hadat isibaso, tama Samlago te agai sę hasegelama sali. Samla aga te Masreka bulu bidi. ");
INSERT INTO mps_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tama Samla isibaso, tama Saulgo te agai tuni bidi sę sali. Saul aga te Rehobot hanu bidi, te hanu te wę nogi Yufretis sesegede elalubo hanude bidali. ");
INSERT INTO mps_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul isibaso, tama Balhanan, te Akbor tego ogwa, agai te tuni bidi sę sai. ");
INSERT INTO mps_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tama Balhanan te Akborgo ogwa isibaso, tama Hadatgo agai te sę selama, bidai. Pau te aga te king sę eyu bidali bulu da, tama agai te we Mehetabel sali, te we nogi Matretgo wegi da. Tama Matret te Mesahapgo wegi dao. ");
INSERT INTO mps_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Te e da, te Iso hani dabe tobolu bidi dabe da, Timna, Alva, Jetet, Oholibama, Ela, Pinon, Kenas, Teman, Mipsar, Makdiel, Iram. Te augwali te Idom tobolu bidi hani dabe da. Idom te Isogo gasa nogi me, tama Iso te Idom hani nogi aga aya dao. Te augwali tigidali deli deli te augwa bulu elalubao, tama augwa hanide te augwali tobolu bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekop te aga aya polobadu biliyu bidali bulu, te Kenan tǫde bididuai. Te Jekop aga ogomani dali augwali bidibadi, tama e tobage kolesaga augwalide pedelali. Odao. ");
INSERT INTO mps_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Josep te gesi ogwa bidi, te agai kibu be te 17 kibu be elaluali. Tama aga ama dede meba augwaligo te kibu sipsip me meme tonaluali, tama Josepgo augwali tau sali. Te aga ama dede augwali te sę ebo we Bilha me Silpa sigo ogomani, te augwali si aga ayago we si da, te aga paba si dao. Tama agai te aga ayabolo te aga ama dedego dwai kolesaga ebo po weyu yai. ");
INSERT INTO mps_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israelgo te Josepde wiegi yai homu pemene mu ebo tiwai te aga gasa ogomani dali wiegi yai homu ebo tiwai me ebeo, magi baso meni, idago te Israel monu dabe ebo sogo Josep ame nani. Tama agai te wiegi yai au yai ugwa nigilama, tama agai te Josepbolo mawai. ");
INSERT INTO mps_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Te aga ama dedego suali, te ayago Josep dali wiegi yai homu pemene mu eyu, tama augwali te godolo kuna me ebe. Tama tibaso, augwaligo dwai homu mu te Josep dali elama, tama augwaligo abagi homu eyu, wiegi yai po aga dali me wabeo. ");
INSERT INTO mps_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tama me sogo deli te Josepgo na elama, tama agai te na yali te aga ama dede dali pusali. Tama augwaligo odama, tama augwaligo homu dwai mu elaluali. Magi baso meni, ");
INSERT INTO mps_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Josepgo te na yali pusuyu, te po wai, “Dagego eno na yali po odao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Da tigidali te wit gide bidaluyu, tama te wit dunu pali. Tama eno duani te hogodama, tama dolo dolugulali. Tama dagego duani nai dabe dolaluyu, te eno duani nai te bagulama, tama teba kidu sugunani,” wali. ");
INSERT INTO mps_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Te aga ama dedego agabolo te po wali, “Nago homugo te nage dago tuni bidi pedelama, tama da tonaluainogo ebawe?” Tama aga ama dede augwaligo te na yali po odama, tama augwaligo aga dali sębę mu yai. ");
INSERT INTO mps_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Tama nosali Josepgo na ma elama, tama agai te po aga ama dabe dali pusali. Agai te po wali, “Odiąo, eno gasa na ma ebo suali, tama eno te giliga de polua si, me te nogo si olama, sągągo deli te hǫ dabe, augwali te enaba basi gulama, kidu sugunidu geai,” wali. ");
INSERT INTO mps_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Agai te na yali po te aga aya dali, me te aga ama dede dali pusubadi yali. Tama aga ayago aga dali wado po olama, te po wali, “Te magi yai na dawe? Nago homugo ena, naga ida dali, me te naga ama dede dali, te da aselama, te nage gesabidiba kidu sugunama, basia gulagasomainu ebawe?” ");
INSERT INTO mps_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tama Josep aga ama dedego aga dali haliga husugu yali, tiali goli aga ayago te po tigidali aga homude munalualio. ");
INSERT INTO mps_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nosali te Josepgo ama dede augwali te augwa ayago kibu sipsip tonalugi peyu, te Sekemba pali. ");
INSERT INTO mps_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tama Israelgo Josepbolo te po wai, “Naga ama dede augwali te Sekem bulu pąde te kibu sipsip tonalu bidibao. Nage sisi elama, eno nage te augwali bidalubo digi tagala palaibao,” wali. Josepgo te tiwai po wei ponani, “Ena sisi yai dao.” ");
INSERT INTO mps_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tama ayago te po wali, “Nage te naga ama dede bidiboba pelama, tama augwali sugi pao, te augwali bugagia bidibowe, ma meniwe? Tama nago te sipsip dabe me suyu, te augwali usu elalubowe, ma meniwe? Te augwali sulama, teda nage ma ena bidibo madi asiyu, tama enabolo wagameo,” wali. Te aga aya Jekop te Hebron hanu odogo tǫde bidiyu, tama te Josep tagala palali. Josep digibulu pelama, tama te Sekem tǫba sabolama, ");
INSERT INTO mps_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","tama aga tede augwali gegeyu, bagula biliduali. Tama bidi me deligo aga subaso, tama agabolo hanalu wali, “Nago magi nai gegebawe?” ");
INSERT INTO mps_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Tama Josepgo te po wali, “Eno te ena ama dede gegebo sę ebao. Nago enabolo te augwali mena badu te sipsip tonalubo po waibawe?” ");
INSERT INTO mps_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Te bidigo agabolo te po wai, “Augwaligo e bulude bidali taga pai dao. Te augwali te Dotanba paiba po wabo eno odali.” Tama Josep te aga ama dede pali wali nosali digibulu ma pelama, tama augwali te Dotande bidibo suali. ");
INSERT INTO mps_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Aga te digibulu digi asobadi, tama aga ama dede augwaligo aga suali. Aga te pąba asisąbadi, tama aga ama dedego aga elabo po minama, dąų wali. ");
INSERT INTO mps_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Augwaligo te augwa hasi tomode po minama, tama te po wai, “Te na ebo koneai bidi te asobao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Polo tama, dago aga ela munama, tama aga tigi te ulu sigi ąį elaluai madigi dedage me deli teba sąwaibao. Te nosali dago te po waibao, ‘Te genuai uni hasa me deligo aga elama, tuali,’ po waibao. Tama agai na yali sę mu pedelaibawe, ma meniwe, te dago koneaibao,” augwaligo tama po wali. ");
INSERT INTO mps_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubengo te po dabe augwaligo mibo po odama, tama agai Josep tau sainu yali. Tama agai te po wali, “Dago te aga me ela mugobeo. Menio. ");
INSERT INTO mps_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Te dagego aga kaneme me geligobeo. Te aga te e bidi meni yai bulude elalubo tǫ dedageba sąyagameo. Tiyu, dagego aga dolamuo,” wali. Rubengo homugo te Josep tau sabo homu elama, tama aga te aga aya bidibo madi nosali ma tagala palainu, tama agai te po wai dao. ");
INSERT INTO mps_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Tama Josep te aga ama dede bidibo madi teba sabalubadi, tama polo augwaligo aga pageabi elama, tama augwaligo bomonama, te wiegi yai au yai bobage ugwa te dia sąwani. ");
INSERT INTO mps_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Tama augwaligo aga sela pelama, te wę sula sai tǫ dedage me deli elalubo madi teba tula palai. ");
INSERT INTO mps_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Tama nosali augwali dugulama, tama toma neyu, nai tuali. Te augwali nai tuyu bidalubadi, tama augwaligo te Ismael bidi hani aselabo suali, te gasa nogi me elalubo te Midian bage dao. Augwali te Gileat tedu aselama, tama te Isipba painu soali. Tama augwaligo kamelgo te gasagi yai denami ebo ni kaneme, me te haniani sanda dabe, te sela soali, magi baso meni, augwali te Isipba pelama, tama tede te augwa dobu si ebo bisnis sę yaibao. ");
INSERT INTO mps_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tama Judago aga ama dedebolo weyu, te po wali, “Te dago dena ama elama, tama dago geme dualubo sę eyu da, te dago mena dwagi yai nai agade sogowe? ");
INSERT INTO mps_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Te dago aga e Ismael hanibolo menama, tama dago mone sinao. Te kolesaga eyu da, te dago aga me dologobe. Aga te dago ama, tama dago deli kaneme mu dao.” Tama te ama dedego te po usu da po wali. ");
INSERT INTO mps_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Te Midian bisnis bidi meba teba asobaso, tama augwaligo Josep te tǫ dedagede selama, tama aga te Ismael dabebolo mani. Te Ismael dabe augwaligo Josep te mone ge bidi sese deli, te 20 silva monego abelama, tama augwaligo aga te Isipba selasa pali. ");
INSERT INTO mps_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nosali te gomunai ama Ruben te ma aselama, te tǫ dedageba tonani, tiali goli Josep tede me bidibeo. Aga te homu dene elama, tama aga gudali ugwa pisą yali. ");
INSERT INTO mps_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Aga te ama dede bidibo madi pelama, tama te po wali, “Te ogwa Josep tede bidibeo! Te eno magi sę megi yaibawe?” ");
INSERT INTO mps_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nosali te aga ama dedego te meme me deli elama, tama augwaligo te Josepgo gudali ugwaba te kaneme muai. ");
INSERT INTO mps_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tama augwaligo te ugwa te augwa ayaba sela pelama, tama augwaligo te po wali, “Dago e ugwa gegali. Nago suao. Te ugwa te nago ogwago ugwa dawe, ma meniwe?” ");
INSERT INTO mps_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ayago te ugwa sulama, koneyu, tama te po wai, “Awe. Te ugwa te Josepgo ugwa dao. Te dwai uni hasa me deligo aga elama, tama aga tigidali tula silai sualio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tama Jekopgo aga ugwa pisilama, tama agai te dwai olo ugwa te aga ogwade homu dene ebo te ola mayu ebo, te ugwa gudali. Tama agai te wai hagede gela wabo te sesabi elama, mu wai. ");
INSERT INTO mps_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Te tigidali ogomani, wegi mani me aselama, tama augwaligo te aga homu te wiegi yai ma ilabo po wagasali. Tiali goli, agai te wei mu isiąma, tama te po wai, “Eno aga hagede gela udubadi, te ena aga dali te isali bidi dabego gų pageba bidigi peyu, usu naibao,” wali. Tama aga ogwa Josep hagede te gela naga udu bididualio. ");
INSERT INTO mps_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Tama tidubadi, te Isipde te Midian dabego Josep te Isip tuni bidigo ofisa bidi me deli, te Potifarbolo mani, tama agai Josep te monego mu abelai. Potifar te Isip tuni bidigo genuai be tonalubo ami bidi dabe augwali tonalubo bidi dao. ");
INSERT INTO mps_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Tama te sogo Juda te aga ama dede taga peyu, tama te Hira dali bidigi pali, te Adulam bidi me deli da. ");
INSERT INTO mps_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tama Judago te we me deli suali, te aga bidi me deli Kenan bidi Suago wegi dao. Agai te we selama, tama aga dali pagela piali. ");
INSERT INTO mps_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Tama te we tabi elama, tama ogwa me deli ame nani. Tama Judago aga nogi Er poai. ");
INSERT INTO mps_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nosali te wego tabi ma elama, tama gasa ogwa me ame nani, tama agai aga nogi Onan poai. ");
INSERT INTO mps_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tialima, nosali te wego ogwa me deli ma ame nenama, tama aga nogi Sela poai. Juda te Kesipde bidibadi, tama aga wego te Sela ame nani. ");
INSERT INTO mps_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nosali Judago te aga gomunai ogwa Ergo we me deli gegali. Aga nogi te Tamar dao. ");
INSERT INTO mps_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tama Ergo kolesaga te Yawe gedude dwai ebaso, tama Yawego aga isilali. ");
INSERT INTO mps_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tialima, Judago Onanbolo te po wai, “Nago te naga amago we dali piao. Te nago ama isali, tama agai wai meni. Te dago kolesaga te tiwai nago te naga amago we selama, tama aga nogide te wai ame nao. Tama te naga amago wai hani elaluaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tiali goli, Onango koneani, te wai dabe te agai wai dabe meni, te homu yali. Tama aga te we dali piali sogo, agai wę te tǫba olo madi gelali. Tama aga amago hani wai dabe me elalubeo. ");
INSERT INTO mps_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Te kolesaga Onango te Yawe gedude dwai ebaso, tama Yawego aga me isilali. ");
INSERT INTO mps_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Tama nosali Judago te aga wąį we Tamarbolo te po wai, “Nago bidi isalio. Tama nage te nago ayago beba ma pelama, tama nage wilawe we bidigi pelama, te eno ogwa Sela genuai ebo teba usu naibao.” Aga wi elama, tama po wali. Tiyu, te Sela me te aga ama si isali tiwai gilama idalio. Tialima, Tamar te aga ayago beba ma pelama, tama bididuali. ");
INSERT INTO mps_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Tama me sogo nosali te Judago we isali, te aga Suago wegi da, aga me te isali. Judago te homu dene ebo sogo silama, tama aga te Timna buluba peyu te bidi dabego aga sipsip nisi togobo pesageba pali. Te aga abagi Hira te Adulam bulu bidi aga dali pali. ");
INSERT INTO mps_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Te bidi me deligo te we Tamarbolo wali, “Te nago bidigo aya, nago wąį, te Timna buluba peyu, te sipsip nisi togogi soyu, soali,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tialima, Tamargo te aga bidi isali te konemainu te muani ugwa te peda sąnama, te gasa ugwa hasegelama muani. Tama agai gesabidi te sesela selama, te dwasianu ugwa name munama, tama te Enaim hanu soabo sunumi tunu si age tede dulaluali, te Timna sunumi teba pabo pesage elaluali. Agai koneai, te Sela te genuai yali, tiali goli augwaligo te Selago te Tamar sabo po te dodolisiąwai. ");
INSERT INTO mps_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judago te sipsip nisi togobo sę sula silama, tama beba ma pobadi, agai te we sulama, tama agai homugo te penani ebo we da, te homu yali, magi baso meni, te wego gesabidi te dwasianu ugwa namego halua sai elaluali. ");
INSERT INTO mps_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Aga te we te sunumi sesegede bidibo madi pelama, tama agabolo te po wali, “Ae, polo tama, ena nage dali piabo homu ebao.” Tiali goli, Judago te aga wąį we da, te homu isiąyu, tama agai me konebe. Tama te wego te po wali, “Te nago magi nai hasia te enabolo mawaibawe?” ");
INSERT INTO mps_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judago te po wali, “Eno te meme elalubo, tama te ogwa bidi me deli eno te nageba tolaibao.” Wego te po wali, “Te usu da, tiali goli nago te meme enaba tolabo te po dąų walobo dąį ilibo nai me deli te enabolo mao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tialima, Judago te po wali, “Te eno magi nai te po dąų waliyu, eno nagebolo magawe?” Tama wego te po wali, “Te naga te nogi asębo nai me, aga naga dogonide walobo bono me, te megi nago tolalubo te tolasa bilibo au yai dono me, te enabolo mao,” wai. Tialima, Judago te nai dabe te webolo mani. Te augwa si te sogo pagela pilama, tama nosali te we tabi yali. ");
INSERT INTO mps_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tialima, Tamar hogodama, tama palio. Tama agai te aga gesabidi halualuali te dwasianu ugwa name peda sąnama, tama te aga bidi isai da olama, te bidigo konemainu mubo ugwa te ma muani. ");
INSERT INTO mps_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judago te ogwa bidi meme te aga abagi Adulambolo menama, tama aga tagala palama, agai te webolo mani doado bage te ma sigi pelama, sesemainu yali. Tiali goli, agai te we gegali, te me subeo. ");
INSERT INTO mps_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tama agai te bulu bidi dabebolo hanalu wali, “Te Enaim te sunumi tųnu age side te penani we bidali, te menade bidibawe?” Tama augwaligo te po wali, “Te penani we me deli te badu me bidibo menio.” ");
INSERT INTO mps_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Aga te Juda bidibo madi ma geasa pelama, te po wai, “Eno te we me gegebeo. Tama te bulu bidi dabego te po wali, ‘Te penani we deli te badu me bidibo menio,’ te po wali.” ");
INSERT INTO mps_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tialima, Judago te po wai, “Tagalao. Te nai aga tolasa bilimainao. Nago te ma gegelamuo. Tiyu, te bidi dabego da si gisugu mayabuo. Eno te meme ogwa bidi te weba tolali. Tama nago gegali, tiali goli te nago me subeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tama te polua sela bidai digi, tama augwaligo Judabolo te po wali, “Te nago wąį Tamar te penani wego ebo sę elama, tama megi te aga tabi elalubao,” wai. Tama Judago te tiwai po bomo yali, “Te aga buluba sela solama, tama aga te siaba ulama, te aga isimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Te augwaligo aga sela pabo sogo, agai te aga wąį wali ayabolo po ola tolai. “Ena te tobage doado bage tolalubo bidide te ena tabi yali. Te e nai dabe te bugagia osolama yao, te dąį ilibo nai, me te bono, me te tolasa bilibo au yai dono, te tama nai elalubao. Te tama doado bage te dego dawe?” ");
INSERT INTO mps_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judago te nai dabe sulama, koneyu, tama agai te po wai, “Eno tama te dwai sę yali. Te wego dwai sę meni yani. Aga te eno ogwa Selago saiba wai. Tiali goli, eno te augwali si sabo po dodolisiąwai.” Tama tibaso, Juda te aga dali me pibeo. ");
INSERT INTO mps_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tama nosali te Tamargo wai ame nainogo ebo sogo, augwaligo koneani, te aga tabide wai si elaluali. ");
INSERT INTO mps_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Te ame nabo sogo, te wai me deligo nogo te polasa teda soali. Tama te tonalubo wego te nogo tola selama, tama te mama ugwa pedai dwasianu te nogode kęnani. Tama agai te po wali, “Te wai bolo hasia pedelai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Tiali goli, te waigo nogo te ugwaba ma kega selama, tama aga ama me bolo te hasia ame nani. Tialima, te tonaluali wego te po wai, “Magi yaliwe? Nago te hani si pedelama, tama bomonama, nage bolo te hasia ame nani dawe?” Tama tibaso, augwaligo aga nogi te Peres poai. ");
INSERT INTO mps_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nosali te aga ama te mama ugwa pedai nogode kęnani, te me ame nani. Tama augwaligo aga nogi te Sera poali. ");
INSERT INTO mps_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Te Ismael dabego te Josep Isipba odasa pelama, tama te bidi me deli aga nogi Potifar, tego aga abelai. Potifar te Isip bidi me deli, tama te Isip tuni bidigo sę ebo ofisa bidi me deli da. Agai te ami bidi dabe te Isip tuni bidigo genuai bede tonaluali. ");
INSERT INTO mps_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yawe te Josep dali bidibaso, tama agai yali sę tigidali te wiegi yai naga pedelali. Josep te Potifargo bede sę eyu bidali. ");
INSERT INTO mps_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Tama Potifargo sulama, koneani, Yawe te Josep dali bidiyu, tama tigidali sę Josepgo yali te dwagi yai naga pedelali. ");
INSERT INTO mps_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tama agai te Josep dali wiegi yai homu pemene mu elama, tama agai te Josep te aga digi pąde bidibo tau sabo bidi nigilali. Tama tibaso, Potifargo Josep te agai bede tigidali doado bage tonalumainu muani. ");
INSERT INTO mps_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tama te sogo Yawego te Isip bidi Potifargo hani dabe dali dwagi yai sę ebo gagalali, magi baso meni, te Josep augwali dali bidali. Yawego te tigidali doado bage, me tigidali we bidi te Potifargo bede bidalubo, me te tigidali gide elalubo nai dabe, te hauwa mu pedalumainu te dwagi yai tau sabo sę yali. ");
INSERT INTO mps_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tialima, Potifargo te agai doado bage tigidali tonalumainu Josep te tonalubo bidi nigilali. Tama aga digi te magi nai me deli tede te agai homu me ebeo. Menio. Agai te aga tubo naide naga homu yali. Tialima, Josepgo tigi te wiegi yai mu elama, tama gasagi yai sawi yai bidi mu pedelali. ");
INSERT INTO mps_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tama pąde digi tama Potifargo wego te Josep gedu eyu, tama pesą yalima, tama agabolo te po wai, “Nage ena dali pagela piagasao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tiali goli, Josepgo te hagela elama, tama agabolo te po wali, “Te ena tonalubo genuai bidigo ena te bede te tigidali doado bage tonalubo bidi nigilali, tama agai te magi nai me delide te homu me ebo menio. ");
INSERT INTO mps_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Eno te bede te aga bomo tiwai digi te eno elalubao. Tama agai te magi nai me deli te enabolo me habu selibeo, nage deli naga, te nage agai we da. Magi baso eno te tiwai dwai kolesaga yaibawe? Te eno tama tiwai dwai sę ebaso da, teda eno God gedude dwai sęgę saibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tama tigidali bidibo sogode te wego Josep te aga dali piagasa wabo po hanalubo sę iduali. Tiali goli, Josepgo te agai wabo po me odama, tama aga dali me pisąma, tama aga te aga pąba me pabeo. ");
INSERT INTO mps_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Te me sogo deli Josep te be tomoba aga sę yainu pali, tama te sę ebo bidi me deli tede me bidisiąwai. ");
INSERT INTO mps_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tialima, Potifargo wego te Josepgo ugwa tola selama, tama agai te po wai, “Nage ena dali piagasao,” wai. Tiali goli, agai holobo ugwa te wego nogode tolalubadi taga peyu, tama aga wi soyu, te bedu buluba soali. ");
INSERT INTO mps_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Te wego te Josepgo aga ugwa taga peyu, tama wi pabo suali, ");
INSERT INTO mps_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tialima agai te bede sę ebo bidi dabeba i weyu, tama te po wai, “Dagego suiąo! Eno bidigo te Hibru bidi te dago beba odasa bidali bidigo tama megi agai dwai kolesaga te dabolo yainogo yali. Aga te ena pibo be habu badu asama, tama agai te ena nogo tulama, dwai sę yainu yali. Tiali goli, eno bomo elama, po daga walio. ");
INSERT INTO mps_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tialima, agai te eno hai wabo odama, tama agai ugwa te eno pagede taga peyu, tama aga te bedu buluba wi pai,” te wego te po wai. ");
INSERT INTO mps_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tama te sogo pio Potifargo wego te Josepgo ugwa tolalubadi, te aga tonalubo bidi te beba sabolali. ");
INSERT INTO mps_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nosali agai te po aga bidibolo pusuyu, te deli tobage po naga wali. Agai te po wai, “Te Hibru bidi, te olo sę ebo bidi, te nago dago beba odasa bidali bidi, agai te ena pibo be habuba asama, tama agai dwai sę ena dali yainogo yai. ");
INSERT INTO mps_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tiali goli, eno hai obaso, tama aga ugwa ena pagede taga peyu, tama buluba wi pai,” wali. ");
INSERT INTO mps_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Te wego te po pusuyu, tama tiwai po wali, “Te nago sę bidigo ena dali tama tiali.” Tialima, Josep tonalubo bidigo odama, tama agai sębę dwai mu yali. ");
INSERT INTO mps_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Agai po obaso, tama te ami bidi dabego Josep nogo dunama, tama aga kalabusiba muani. Augwaligo aga te gavman tuni bidigo te dwai sę yali bidi dabe kalabus ilama bidibo madi, te Josep teba kalabus ilama muani. Tama aga tede bidaluali. ");
INSERT INTO mps_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Tiali goli, Yawe te Josep dali bidiyu, tama agai aga dali dwagi yai sę yali. Tama tiyu, Yawego te kalabus tonalubo bidigo Josep dali wiegi yai homu pemene emainogo yali. ");
INSERT INTO mps_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tama tibaso, agai te Josep te tigidali kalabus bidi tonalubo bidi nigilali. Tama Josepgo te tigidali kalabus bidi dabego ebo sę tonalubo sę yali. ");
INSERT INTO mps_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yawe te Josep dali bidiyu, tama aga tau sobaso, tama agai tigidali sę yali te dwagi yai naga pedelali. Tama te kalabus tonalubo bidigo te Josepgo tonalubo sęde te agai homu si me ebeo. ");
INSERT INTO mps_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Tama bidali sogo dwasianu sesabi gana elama, tama te bomai ąį wain tonalubo tobolu bidi, me te bret nigibo be tonalubo tobolu bidi, augwali sigo te Isip tuni bidi Fero dali dwai sę me deli yali, aga te augwali sigo genuai bidi dao. ");
INSERT INTO mps_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fero te sę tonalubo bidi si dali sębę elama, ");
INSERT INTO mps_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","tama agai augwali si te ami bidi dabe tonalubo bidigo be teba muani. Augwali si te Josep augwaligo kalabusiba muani madi te kalabus beba naga muai. ");
INSERT INTO mps_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tama te ami bidi dabe tonalubo bidigo te Josepgo te tobolu bidi si tau mabo bidi nigilali. Augwali si te sesabi elama gana te kalabuside bidama, ");
INSERT INTO mps_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","tama me sogo hulide, te wain sę tonaluali tobolu bidigo, me te bret nigibo sę tonaluali tobolu bidi, te Isip tuni bidigo sę yali bidi sigo na yai. Te deli deligo na yali te na page me elaluali. ");
INSERT INTO mps_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tama Josep te augwali si bidibo madi kigamu sabolali, tama agai te augwali si te homu sęgę elalubo suali. ");
INSERT INTO mps_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tama agai augwali sibolo hanalu wali, “Magi baso te dage si homu sęgę elalubawe?” ");
INSERT INTO mps_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Augwali sigo te po wai, “Da sigo te na yai. Tama ede te bidibo bidi mego te na yali po page da sibolo pusabo te meni yani,” wali. Tama Josepgo augwalibolo te po wai, “Godigo naga te na yali page dabolo ola mabo usu dao. Tialima, dage sigo te na yali po enabolo waiąo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tama tibaso, te wain tonalubo tobolu bidigo te na yali po pusali. Agai te po wai, “Te eno nade, eno te wain nigabo du walobo bono me deli suali. ");
INSERT INTO mps_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tede te nologo sela elaluali. Te yabe dabe pedelama, tama polo te dudili pedelama, tama te ni wain du walama, tama tigidali tau ela silai. ");
INSERT INTO mps_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Eno te Ferogo kap tuali. Tialima, eno te wain du dabe selama, tama eno nogogo pegelama, tama aga wę te kapba tabilama, tama eno te Ferobolo mani,” wali. ");
INSERT INTO mps_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Josepgo te po wali, “Te na page e tiwai dao, te wain nologo sela wali, te sela sogo bodolu mani. ");
INSERT INTO mps_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Te sela sogo wali silisiąbadi, tama Ferogo nage ma sagasaibao. Tama agai nage, te naga yali sęba ma muaibao. Te nago hasia polobadu te wain sę tonalubo tobolu bidi bidiyu, te nago wain tuabo kap te Ferobolo mani tiwai gilama, te nago te wain wę kap te Ferobolo mawaibao,” Josepgo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","“Te nage bugagia bidibo sogo, nago ena homugo konea palao. Nago ena homu dene elama, tama eno nogi Ferobolo olama, ena e kalabuside bidibo tagalumainao. ");
INSERT INTO mps_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Magi baso meni, te hasia mu te bidi dabego ena te Hibru dabego bulude te olo sę ebo bidi tiwai elama, wi sela asali. Te megi e tǫde me, te eno magi sę me deli isiąbadi, te ena augwaligo e kalabusiba muani,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Te bret nigibo be tonalubo tobolu bidigo te na page odali te wiegi yai ebaso, tama agai Josepbolo te po wali, “Eno me eno na yali. Te na tama tiwai yali, te eno tobolude te basket sela tolali, tama te tobage te plaua dabe nigali bret te pągąwai. ");
INSERT INTO mps_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Te ugwadu polaluali basketde te tobage tigidali te bret me bisket te pągąnaluali, te Ferogo wei ebo nai dao. Tiali goli, te ba dabego te bret dabe tubo sę yai,” te bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tama Josepgo te po wali, “Te na yali page te e tiwai dao, te sela wali basket te sela sogo bodolu mani. ");
INSERT INTO mps_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Te sela sogo bidali silisiąbadi, tama Fero agai nage te kalabus bedu dogoni mage togwaibao. Tama agai nage tigi te ni me deli walama, tama te ba dabego nago tigi mi tuagasaibao,” Josepgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Te sela sogo wali pedelama, tama Ferogo te tigidali sę ebo bidi dali te aga idago aga ame nani bodolu side te genuai nai da ulama, tuainu yali. Tama agai te wain tonaluali tobolu bidi, me te bret ulubo be tonalubo bidi me, te augwali si oda selama, tama augwali si te aga sę ebo bidi dabego geduba dolaluagasali. ");
INSERT INTO mps_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Agai te wain sę tonalubo tobolu bidi te aga sęba ma tagala palali. ");
INSERT INTO mps_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tiali goli, Ferogo te bret ulubo sę yali tobolu bidi te niba walali. Te sę dabe pedelali, te Josepgo augwali sigo te na yali po page pusali sogo te wali po tiwai gilama yali. ");
INSERT INTO mps_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tiali goli, te wain sę tonalubo bidigo te Josep homugo kone me ebeo. Agai homugo te aga homu dene mu gegeda palali. ");
INSERT INTO mps_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Te kibu be si bidama, tama Ferogo na yai. Agai te tiwai na yai, aga te moni pabo wę Nail pąde dolaluali. ");
INSERT INTO mps_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tama te a naga olama, me badu si te nisai kibu bulmakau te węde pedelama, tama augwali te wę pąde nosai tudali. ");
INSERT INTO mps_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nosali te gasa nogo a naga, me badu nogo si bulmakau te węde pedelai. Augwali te nomona selama, tama augwali tonobo te usu meni yani. Augwali aselama, tama te gasa bulmakau hani bidibo madi te wę sesege pąba dolaluagasali. ");
INSERT INTO mps_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nosali te nomona sali bulmakau dabego te nisali bulmakau te a naga olama, me si te ela tuali. Tama tiwai na ebaso, tama Fero aga pila muani tagalama, te hodaluai. ");
INSERT INTO mps_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tama nosali te aga ma pilama, te agai na ma yali. Te me na yalide te agai suali, te yuyu a naga olama, me si, te yuyu deli dilide pedelali. Augwali te genuai elama, tama ina yani. ");
INSERT INTO mps_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nosali te gasa a naga olama, me badu si yuyu te pedelali. Augwali te dwasianu ebaso, tama te bulude posolo yai waligo te augwali ulali. ");
INSERT INTO mps_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Te nomonasi sia dabego te nisali yuyu a naga olama, me badu si te sia gego pągąwai te nomonasi yuyu dabego augwali dalali. Tialima, megi da, te Fero hodaluama, tama agai te na yalide homu elama, agai koneani. ");
INSERT INTO mps_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tama kigamu aga moni homu elama, tama agai te Isip dabe te kolesaga konea pai bidi dabe, me te geme dualali nai dabe subo bidi dabe me, augwali i wali. Agai te na si yali po te augwalibolo wali, tiali goli te na yali page pusabo bidi me deli te usu meni yai. ");
INSERT INTO mps_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nosali te wain tonalubo tobolu bidigo Ferobolo te po wali, “Te megi e sogo tama te eno dwai sę yali po me pusubao. ");
INSERT INTO mps_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Polobadu nago te naga sę bidi dabe dali wado po olama, tama nago ena dali, te bret ulubo sę tonaluali tobolu bidi, da si te kalabus bidi tonalubo bidi dabego beba da si kalabus muani. ");
INSERT INTO mps_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tama me sogo hulide te da si piai digi te na yai. Tama da sigo na deli deli yali te aga page tedali elaluali. ");
INSERT INTO mps_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tama te Hibru gesi bidi me deli te da si dali bidai. Aga te ami bidi dabe tonalubo bidigo olo sę ebo bidi bidai. Tama da sigo te na yali po dabe agabolo wali. Tialima, agai te da sigo na yali po page hanilama, tama agai te da sigo na yali po page pusai. ");
INSERT INTO mps_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tama agai te po wali tiwai gilama, te sę dabe pedelali. Ena te ena yali sęba ma asiyu, tama te bret ulubo tonalubo tobolu bidi te augwaligo aga te nide walali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ferogo te Josep i obaso, tama polo augwali te kalabus beba pelama, tama aga oda sigi pai. Josep te penane nisi poalama, tama aga ugwa hasegelama, gasa ugwa gudama, tama aga te Fero bidibo digi pali. ");
INSERT INTO mps_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Tialima, Ferogo Josepbolo te po wali, “Eno na yai, tama te na yali po page pusabo bidi meni yai. Te bidi dabe augwaligo te po wai, te nago na yali po odobaso da, nago te na yali po page pusubo usu ebo da po wai.” ");
INSERT INTO mps_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tiali goli, Josepgo te po wai, “Ena digi eno usugobe, tiali goli Godigo da nage dali dwagi yai sę eyu, agai nagebolo te na yali po page ola mabo usu yaibao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tama Ferogo te po wali, “Eno na ebadi, ena te wę Nail sanede dolaluali, ");
INSERT INTO mps_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","tama eno te nisai bulmakau te a naga olama, me si te węde pedelama, tama augwali te wę pąde nosai tubo gagalubo suali. ");
INSERT INTO mps_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nosali te gasa a naga olama, me si bulmakau te pedelali. Augwaligo tigi pobea sai, tama augwali te nomona selama, tama tonani mu dwalio. Eno te tobage tiwai bulmakau dabe te Isip badu te dwai me sube. ");
INSERT INTO mps_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Te nomonasi bulmakau dabego te nisali bulmakau dabe ela tuali. ");
INSERT INTO mps_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Augwaligo tuali, tiali goli augwaligo te tuali ąǫ me ebeo. Menio. Augwali te polobadu tonani tiwai gilama, te dwai mu elaluali. Tama nosali ena pila muani tagalama, hodaluai.” ");
INSERT INTO mps_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Tama nosali ena ma pilama, tama ma na yali. Eno te deli yuyu pagede te a naga olama, me si yuyu te pedalubo suali. Augwali te genuai holama, tama ininama, tau yali. ");
INSERT INTO mps_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nosali te gasa a naga olama, me si te yuyu sia pedelali. Augwali te dwasianu holama, tama te bulude posolo yai waligo augwali ulama, tama sasia pali. ");
INSERT INTO mps_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Te pua pai bugagia holisiąwani te yuyu sia dabe augwaligo te pua pai bugagia holali yuyu sia dabe, te ge pągąwani sia te augwaligo augwali dalali. Eno te na te dualali nai subo konebo bidi dabebolo pusali, tiali goli niwai bidi deli mego te na page pusabo te usu meni yai,” Ferogo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tialima, Josepgo Ferobolo te po wali, “Te na si page te deli tiwai tobage naga yali. Godigo nagebolo te agai tamadi yabo sę ola mani. ");
INSERT INTO mps_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Te nisali bulmakau a naga olama, me si, te kibu be a naga olama, me si dao, tama te wiegi yai yuyu sia dabe me te tiwai, te kibu be a naga te me si tama. Augwali te page deli tiwai elaluali. ");
INSERT INTO mps_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Tama te nomona sai bulmakau nosali pedalubadi, tama te hagana wai yuyu sia me te pedelama, tama te posolo yai waligo te hagana wai yuyu sasia ilali, te tiwai augwali te kibu be a naga olama, me badu si te nasi yabo kibu be pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Te tiwai eno nagebolo te po walio, Godigo te agai tamadi yabo sę te nagebolo ola mani. ");
INSERT INTO mps_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Te kibu be a naga olama, me badu si, te kibu be tomode te nai umabo hauwa te Isipde elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tiali goli, nosali te kibu be a naga me badu si, te tama kibu bede te nasi elalu, tama te Isip bidi dabego te wiegi yai kibu bede yali homu kolesaga te ma kone me palugobeo. Te e tǫ pedai hanu tigidalide te nai nasigo dolaibao. ");
INSERT INTO mps_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tama te bulu bidi dabego te polobadu nai hauwa tuali sogo te homugo mu gegeda paibao, magi baso meni, te sogo nosali te dwai nasi mu asabo elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Godigo te sę yabo te homugo konea selama, tama mu dąų walali. Tama agai nago aga dąų walali homu konemainogo iliyu, nago na si sogo emainu yali. Tama te sesabi elama bidisiąbadi, te pąde sogo tama Godigo te sę pedalumainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Tialima, megi da, nago te wiegi yai kolesaga koneai bidi te nigilama, tama agai te Isip tigidali tǫ pedai badu tonalumainao. ");
INSERT INTO mps_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tama nago te hanu tǫ tonaluabo te tobolu bidi meba nigilibadi yao. Tama te kibu be a naga me si, tede te nai hauwa elalubadi, te tobolu bidi dabego te a naga pedai badu bugulama, te we bidi dabego gide elalubo nai me deli te gavmanigo te takis sabo tiwai gilama sao. ");
INSERT INTO mps_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Augwaligo te wiegi yai kibu bede te nai dabe tigidali selama, sisinao. Augwaligo te nage dologode sę eyu, tama augwaligo te wit, me yuyu, me te hanu tomode elalubo nai dabe me, te tigidali deliba sisinao. Tama augwaligo te nai dabe tigidali te bugagia tonaluao. ");
INSERT INTO mps_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tama te kibu be a naga olama, me si, te sogode te nasi Isipba pedalubode, te Isip hani dabe we bidigo te augwaligo sisinama muani nai te augwa sela tumainu yaibao. Tama eyu, te we bidi dabe augwali te nasigo me isigobeo,” Josepgo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Tama Fero dali aga tobolu bidi dabe dali, augwaligo te po usu da po wali. ");
INSERT INTO mps_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tama tibaso, agai te po augwalibolo wai, “Te e bidide te Godigo Mobo Bidi elalubao. Dago te tobage bidi tiwai te menade suai dawe?” ");
INSERT INTO mps_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tialima, Ferogo te po Josepbolo wali, “Godigo digi nagebolo te sę dabe ola manio. Tama tibaso, mena bidi me deligo te nago te homu kolesaga dagalabo kolesaga tiwai me elalugobeo, te nago koneani homu kolesaga tiwai me elalubeo. ");
INSERT INTO mps_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Te tama tialima, eno nage te eno hanu tǫde te polalubo gavman bidi nigilama, tama eno hani we bidi Isip dabe tigidali augwaligo nago po wali pomainu yaibao. Ena te gavman tuni bidi te eno nogi deli naga te nago nogi aiyaba elaluaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Tialima, Ferogo Josepbolo te po wai, “Nago odao, megi eno nage te Isip tǫ pedai tigidali badu te gavman genuai bidi nigilibao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ferogo te tuni bidigo mubo ring me deli elaluali. Tama agai te ring aga nogode munaluali pedelama, tama agai te Josepgo nogoba muani. Ferogo te gasagi yai sawi yai mu ugwa dabe te Josep tigiba gudulama, tama aga magede te golgo nigai sen me deli domonai. ");
INSERT INTO mps_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Agai Josep te me tuni bidi wiegi yai duabo karisde dualasa bilimainu yali. Tama te kibu hos tego te karis kegasa peyu, tama te ami bidi dabe te polasa peyu, tama te tiwai i ola pali, “Te sunumide gedao,” wali. Te kolesaga Ferogo yali, te Josep te Isip tǫ pedai tigidalide te gavman bidi pedalumainogo ilali. ");
INSERT INTO mps_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Tama Ferogo agabolo te po wai, “Ena tuni bidi gavman dao. Tama eno te po obao, te Isip bidi me deligo te aga homugo magi sę me egobeo. Menio. Agai te nagebolo hasia hanalu wao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Tama Ferogo te nogi Safenat Panea te Josepbolo mani. Tama agai te Josepbolo we me deli mani. Te we nogi te Asenat. Aga te Potiferago wegi da, te hanu me deli nogi augwaligo Heliopolis wabo, tede aga pris bidi dao. Tialima, Josep te Isip tǫ tigidali pedai badu bilali. ");
INSERT INTO mps_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josepgo kibu be te 30 kibu be elalubadi, tama aga te Isip tuni bidi Ferogo sę gagalama yali. Tama Josepgo te Fero taga peyu, aga te Isip tǫ pedai sesede usu nama bilali. ");
INSERT INTO mps_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Te wiegi yai kibu be a naga olama, me si, te kibu bede te nai hauwa mu pedelali. ");
INSERT INTO mps_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tialima, te a naga olama, me si te kibu bede te Isipde nai hauwa mu elaluali, Josepgo te nai hauwa sisinani. Agai te deli deli hanude elalubo nai sisini bilama, tama agai te tigidali hanu bakstuade te nai muani. ");
INSERT INTO mps_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Agai te wit umabo mu te wę sane masigi kemi tiwai sisinama, tama Josepgo te ma nedebo te usu meni baso, tagalali. ");
INSERT INTO mps_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tama te nasi yabo kibu be dabe te pedalisiąbadi, tama Asenat, te Josepgo wego, te ogwa si ame nani. Asenat te Potifera te Heliopolis hanu pris bidigo wegi dao. ");
INSERT INTO mps_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tialima, Josepgo te po wai, “Godigo ena tau selama, tama te eno sali sęgę, me te eno aya ida, ama dede, augwalide homu dene ebo, te eno homugo gegeda palai.” Tama tibaso, agai te aga gomunai ogwa nogi te Manase nogi poai. ");
INSERT INTO mps_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Agai te tiwai po me wali, “Godigo te ena e sęgę sali bulude tau siyu, tama te agai enabolo te gasa wai me mani.” Tama tibaso, agai te aga tomo ogwa nogi te Efraim poali. ");
INSERT INTO mps_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Te a naga olama, nogo me si wali, te wiegi yai kibu be bidali te silama, ");
INSERT INTO mps_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","megi da, te Josepgo wali po gilama te a naga olama, me si wali te nasi yabo kibu be pedelai. Te genuai nasi ebo te tigidali gasa tǫ pedaide me pedelali. Tiali goli, te Isip tǫ pedai tigidalide te nai usu elaluai. ");
INSERT INTO mps_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nosali te Isip tǫ pedai tigidalide te nasi pedelali, tama te we bidi dabego te Feroba gela weyu, te augwali nai mao wali. Tialima, Ferogo te Isipde bidalubo we bidi augwalibolo wali, “Dage te Josepba pelama, tama agai po odigi pao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Te dwai nasi mu te Isip tǫ pedai tigidali badu pedalubaso, tama Josepgo te nai muani bakstua sunumi dalama, tama te Isip hani we bidi dabe aselama, te wit abelagasai. ");
INSERT INTO mps_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Te tigidali tǫ badu bidi hani we bidi augwali me te Isipba Josep bidibo madi aselama, te wit abelagasali, magi baso meni, te dwai nasi ebo si te tigidali tǫ usu nama, te nasi pedelali. ");
INSERT INTO mps_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nosali Jekopgo odali, te Isipde wit elalubo po odali. Tama agai te aga ogomanibolo weyu, bomonama, te po wai, “Magi baso dage olo bidalubawe? ");
INSERT INTO mps_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Eno te po odali, augwaligo te Isipde wit elalubo po odai. Dagego te da tuabo te meba wit abeligi pao, tiyu da te nasigo isabuo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tialima, te Josepgo ama dede nogo si bage pelama, te Isipba wit abeligi pali. ");
INSERT INTO mps_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tiali goli, Jekopgo te Josep aga deli idago ame nani ama mu, te Benjamin, te augwali dali pomainu me tagala palubeo. Te Jekop wi eyu, tama te Benjamin te dolidali homu yai. ");
INSERT INTO mps_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Genuai nasi mu te Kenan tǫde pedalubaso, tama te Jekopgo ogwa dabe augwali te wit abeligi peyu, te gasa bidi dabe dali pai. ");
INSERT INTO mps_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Te Josep aga te polalubo gavman bidi te Isipde bidali, tama tigidali Isip tǫ badu bidalubo bidi dabe te aga bidibo digi pelama, tama te wit abeligi pai. Tama te Josepgo ama dede te aga bidibo madi sabolama, tama augwali te aga gedude kidu sugunama, tama augwali te gesabidi te tǫba basi gulali. ");
INSERT INTO mps_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tama Josepgo aga ama dede sulama, tama polo agai augwali sulama, konea pali. Tiali goli, agai augwali dali po miani te agai augwali konesiąwai bage dali po mibo tiwai yai. Agai augwali dali po bomonama, tama te po wai, “Dage menadu asaliwe?” Augwaligo te po wai, “Da te Kenandu aselama, tama da nai abelagasu asali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josepgo aga ama dede augwali sulama, konea pali, tiali goli augwaligo aga te sulama, konebe. ");
INSERT INTO mps_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Agai te na yali dabe te aga ama dede dabe dali na polobadu yali te ma homugo kone palama, tama agai te po wai, “Dage te daba sa asobo bidi dabe dao. Dagego te dago tǫ pedai te mena badu mu te hwįbo bomo meniwe naga sueinu gege bilibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Tama augwaligo po wei ponani, “Mena, ąą, genuai bidi. Da te nago sę bidi dabe da, da te nai abelagasu asali. ");
INSERT INTO mps_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Da tigidali te bidi deligo wai dabe dao. Dago te sa asobo bidi tiwai gilama me ebeo. Menio. Da te mu po wabo bidi dabe dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tiali goli, Josepgo augwalibolo te po wali, “Menio! Dagego te dago tǫ hanu pedai mena badu te hwįbo bomo meniwe naga susa bilibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tama augwaligo te po wali, “Genuai bidi, da te nogo si olama, sągągo si bidi da. Da te Kenan tǫde te bidi deligo ogwa dabe dao. Te dago ama gesi bidi mu te megi dago aya dali bidibo, tama dago ama gasa me te hagawai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tiali goli, Josepgo te po ma wali, “Te tiwai po eno wai dao. Dage te sa asobo bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Te eno dage te tiwai usu saibao, eno te Ferogo nogide mu po obao. Te dagego ama gesi bidi te asisąbaso, dage te duga buluba ma geasa me pogobeo. ");
INSERT INTO mps_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tama dage te kalabuside e bidibadi, te dage me deli tagala palama, tama duga amanu sigi pelama, odasa asao. Tama tiyu, te dago sulama koneainu, te dagego po te mu po we, ma tibo po we, te eno koneaibao. Te dagego po tigidali te mu po menibaso da, eno koneama, te dage sa asai bidi dabe da po waibao. Eno mu po mu te Ferogo nogide obao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Agai te tiwai po tama olama, tialima agai augwali te kalabusiba munama, te sela sogo bidali. ");
INSERT INTO mps_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Te sela sogo wabode Josepgo augwalibolo te po wali, “Dagego eno po wali pelama, tama dage bidibo ula elalubao, magi baso meni, eno lotu po te Godiba wabo dao. ");
INSERT INTO mps_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Te dage mu po wabo bidi dabe da wida, teda dage me deli naga te dage kalabus bidali bede bidimainu yaibao. Tama dage gasa bage, te dage duga we wai dabe nasi ebaso, tau sainu abelali nai wit sela peyu, tama dage pagameo. ");
INSERT INTO mps_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tiali goli, dagego duga ama gesi bidi te enaba odasa asiąo, tama tiyu da, te eno koneama, tama dagego mu po wali homu eyu, tama dage me isimainu me egobeo.” Augwaligo te Josepgo po usu da po wai. ");
INSERT INTO mps_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tama Josep aga ama dede augwa hasi tomode po miyu, te po wali, “Mu tama, dena digi polobadu te dena ama dwai sę ilali. Dago aga gela wabo suali, tama dago aga tau somainu agai i wali, tiali goli dago agai i wabo me odobeo. Tama megi, da te tiali sęgę sobao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tama Rubengo te po wali, “Eno dagebolo weyu, te dagego dena ama doligio po wali, tiali goli dagego te po me odai meni. Tama megi te sęgę dago sabo, te aga isainu yali te wei ponobao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Josepgo te augwa hasi tomode mibo po odoyu, te po page koneani, tiali goli te aga ama dedego te me konebe, magi baso meni, Josepgo te Isip pogo po weyu, tama te po begelebo bidigo te Josepgo wali po te augwaliba weyu yai. ");
INSERT INTO mps_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Josepgo odama, tama augwali taga pelama, tama aga gela wagi pali. Aga gela wali silama, te aga ma aselama, tama augwali dali po miagasali. Tialima, agai Simeon nogo tų ilama, tama augwaligo Simeon te ama dede augwa gedude nogo tulama, bidali. ");
INSERT INTO mps_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nosali Josepgo te sę ebo bidi dabebolo olama, augwaligo te ama dedego begba te wit bulali, tama augwa beg deli deli tomoba te augwa mone ma bubulu pali, tama augwali te sunumidu peyu, tųdu pabo nai me te augwali tau siyu mawai. Tialima, augwaligo Josepgo wali po tiwai gilama yai. ");
INSERT INTO mps_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Te ama dede augwaligo te augwa donki dabe daiba te wit beg dabe munama, tama augwali pai. ");
INSERT INTO mps_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Te augwali pigi pali bulu te hulide te augwali pali, te ama mego te aga donki nai mawainu te begde nai tedali. Tama agai te aga mone te beg po tomode bulalubo suali. ");
INSERT INTO mps_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tama aga ama dedebolo i wali, “Suao! Augwaligo te eno mone ma te begba bulali! Te eno begde munalubo suai.” Augwaligo te po wabo odama, tama augwali dwai noma mu sali. Tama augwali wi mu elama, tama subigila po miyu, te po wali, “Godigo mena sę dabolo megi yaliwe?” ");
INSERT INTO mps_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Augwali te Kenanba sabolama, tama augwaligo augwa aya Jekopbolo te augwaliba pedelali sę po tigidali pusali. ");
INSERT INTO mps_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Augwaligo te tiwai po wai, “Te Isip polalubo gavman bidigo te bomai po dabolo weyu, tama dabolo te da sa asobo bidi dabe dao po wali. ");
INSERT INTO mps_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Dago te tiwai po agabolo wali, ‘Da te mu po wabo bidi dabe dao,’ wali, ‘tama da te bulu sa asobo bidi dabe menio,’ wali. ");
INSERT INTO mps_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","‘Da te ama dabe nogo si olama, sągągo si bidi, te bidi deligo wai dabe naga da. Te ama me deli te isai, tama dago ama gesi bidi mu te aga aya dali te Kenande bidibao.’ ");
INSERT INTO mps_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tialima, te gavman polalubo bidigo te po dabolo ma wali, ‘Te dage me deli ena dali bidibaso da, tama eno koneama, te dage mu po wabo bidi dabe da wainogo. Tama dage meba gasa te dage duga we wai nasi idali weyu maiabo nai wit sela peyu, tama duga piąo,’ te po wali. ");
INSERT INTO mps_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","‘Tiali goli, dagego duga ama gesi ogwa bidi te odasa asao,’ wai. ‘Tama eno koneama, te dage bulu sa asisąwai bidi dabe da waibao, te dage mu po naga wabo bidi da po wainogo. Tialima, eno duga ama te dagebolo ma menama, tama duga e bulu tǫde bisnis sę iyagameo,’ te bidigo dabolo te po wai.” ");
INSERT INTO mps_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tigidaligo te augwa wit beg gegeli pelama, tama augwaligo mone gamugi dage te augwa beg deli deli tomode munalua pabo suai. Tama augwaligo te augwa aya dali augwaligo te mone gamugi dage elalubo sulama, tama augwali tigidali wi yai. ");
INSERT INTO mps_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tama Jekopgo augwalibolo te po wai, “Dagego eno ogwa si doligi pai. Josep te hagawai. Simeon me te hagawali. Tama megi dagego te Benjamin hagaligi painu obao. Te tama tebo sęgo te ena homu sęgę mawai!” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tialima, Rubengo te po aga ayabolo wai, “Te eno Benjamin te nageba ma odasa asisąbaso da, teda nago te eno ogwa si ela muagameo. Te eno aga tonalumainu emainao, tama eno aga te nage bidibo madi ma odasa asaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tiali goli, Jekopgo te po wali, “Te eno ogwa nage dali pomainogo me egobeo. Te aga ama isai dao. Tama agaduba deli naga megi bidibao. Ena monu dabe yai, tama aga te sunumide doloyu da, teda dagego ena te moni homu denego te ela mubo tiwai yaibao,” Jekopgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tialima, te Kenade nasi ebo te genuai me elaluali. ");
INSERT INTO mps_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tama Jekop aga hani we wai dabe augwaligo te Isipba sigi pali nai te sia sobaso, tama Jekopgo aga ogomani dabebolo weyu, te po wali, “Dage te Isipba ma pelama, tama dago nai dwasianu meba abeligi pao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tiali goli, Judago aga ayabolo te tiwai po wali, “Aya, nagebolo dago wai dao. Te Isipde bidibo gavman tobolu bidigo da dali wado yai. Agai dabolo te dage ede ma sugobeo po wali, te dago ama te da dali me asisąbaso da, te tama tiwai po wai dao. ");
INSERT INTO mps_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Te nago usu da olama, dago ama te da dali pao obaso da, teda da pelama, te nago nai abeligi paibao. ");
INSERT INTO mps_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tiali goli, te nago hagela ebaso da, te da me pogobeo, magi baso meni, te Isip gavman tobolu bidigo te da ma subaso da, te hagela mu yaiba, te dago ama te da dali asisąbaso tiaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tiali goli, Israelgo te po wali, “Magi baso dagego te gavman tobolu bidibolo te dagego te gasa ama me bidibo po waliwe? Dagego te enabolo genuai sęgę mu manio.” ");
INSERT INTO mps_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Augwaligo te po wali, ‘Te bidigo dabolo hauwa sogo hanalu wali. Agai te da hani sibi po hanalu wali. Agai te po wali, ‘Te dagego aya bidibowe, ma isaliwe? Te dagego ama me deli bidibowe, ma meniwe?’ Agai te tama tiwai po hanalubaso, tama dago agabolo wali. Dago konebe, agai dabolo te dago ama sela asao wabo po te dago me konebeo.” ");
INSERT INTO mps_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Tama Judago aga aya Israelbolo weyu, te po wali, “Te Benjamin ena dali tagala palama, te da polo paibao. Tama tiyu, te nage me, te dago wai dabe me, tama da me, te da tigidali te nasigo me isigobeo. ");
INSERT INTO mps_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Te ena digi eno aga tonaluaibao. Te eno aga nageba ma odasa asisąbaso da, teda te sę page enade elaluaibao, te ena e tǫde tigidali sogo bidibo usu nama tiaibao. ");
INSERT INTO mps_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Tama nago da dąų wagi menigi sogo da, teda da pelama, tama si sogo ma asigi da,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tialima, Israel, te augwa aya, agai augwalibolo te po wali, “Te tiwai tama pedalubaso da, teda dagego tama tiao. Te e bulude elalubo te wiegi yai nai dabe te selama, duga genuai waba munama, tama dage pelama, tama te gavman tobolu bidibolo te aga wiegi yai homu emainu magi pao. Te tobage tiwai dwasianu haniani nai tigidali sao, te ganima bunugo nigali pusu yai nai me, te mege me, tama te denami ebo ni kaneme, me te haniani sanda, tama me te meba ni haga du walobo tiwai ni du nogi pistasio, me te ni du amon, te tiwai haniani nai sela pao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","“Dagego te mone dabe dali dabulama, sela pao. Dagego te beg tomoba ma bulali te mone dabe me ma sela pao. Eno konebe, te augwaligo homugo gegeda peyu, tama tiali bogo. ");
INSERT INTO mps_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Duga ama selama, tama dage te bidi bidibo digi polo pao. ");
INSERT INTO mps_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Eno gedu haluasa te tiwai, te Tigidali Bomo Elalubo Godigo te bidigo homu begelibaso, te agai dage homu dene yaibao. Tama eno homugo agai te duga gasa ama Simeon me, te Benjamin badi, te si dagebolo ma mawaibao. Te eno ogomani tagalu da, eno bomogo te sę hasegelainu ebo te usu me egobeo,” Israelgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tialima, te ama dede augwaligo te homu wiegi yai ilabo nai dabe selama, tama augwaligo gasa nai dabe te mone dali ugwadu daganama, tama augwali pali. Augwaligo te Benjamin me oda sali. Tialima, augwali hogodama, tama Isipba polo pali, tama augwali Josep bidiboba sabolali. ");
INSERT INTO mps_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tama Josepgo te Benjamin augwali dali asobo suali, tama agai aga be tonalubo sę bidibolo wali, “Nago te bidi dabe beba odasa pao. Te bulmakau me deli elama, ulao. Te bidi dabe augwali te ena dali te giliga tomode belo wabode nai tueibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tialima, te sę bidigo te Josepgo po wali gilama, tama agai te bidi dabe te Josepgo beba odasa pali. ");
INSERT INTO mps_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tama te ama dede wi ebaso, tama augwaligo te tiwai homu yali, ‘Augwaligo te da hasia polasa asali sogo te dago beg tomoba te mone bulali munalubo suai. Augwaligo te homu elama, tama augwaligo da e be tomoba odasa pali,’ te homu yali. ‘Te augwaligo da polo elama, tama augwaligo da te olo sę ebo bidi tiwai nigilaibao. Tama augwaligo te dago donki dabe me saibao,’ te homu yali. ");
INSERT INTO mps_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tama tibaso, augwali te Josepgo be tonalubo sę bidi bidibo madi sabolama, tama augwaligo aga dali te be sunumi pąde po miani, ");
INSERT INTO mps_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Genuai bidi, nago te dago wabo po odao. Polobadu da eba aselama, tama nai abelagasai. ");
INSERT INTO mps_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tiali goli, te da pelama, te deli sogo pigi pali hulide, te da deli deligo dena beg po dada pali, tama da tigidaligo te dena mone te gamugi dagede dali te begde bulalubo suali. Megi dago te mone me ma sela asai dao. ");
INSERT INTO mps_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tama dago te nai abelabo mone meba dali sesali. Te dego te dago beg tomoba te mone ma bulali, te dago me konebeo,” te po wali. ");
INSERT INTO mps_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tama sę bidigo te po wali, “Dagego homu si me elama, tama dage wi me elamuo. Te duga Godigo, me duga ayago God, agai te dagego homu wiegi yai ilibo sę eyu, te dagego begba te nai ma muani. Dagego mone te eno sai dao,” wali. Tama nosali agai te Simeon augwaliba odasa asali. ");
INSERT INTO mps_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Tama agai augwali Josepgo beba odasa pali. Agai augwalibolo te sągą wę telabo wę mayu, te nai meba te donkibolo mayu yai. ");
INSERT INTO mps_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Augwaligo augwa sesali te wiegi yai homu ilabo nai dabe sisi ilali, magi baso meni, te augwaligo odali, te Josep augwali dali giliga tomode te belo wabode augwali dali nai tuagasaibao po wabo odali. ");
INSERT INTO mps_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Augwali te bede bidaludubadi tama Josep asali. Tama augwaligo te wiegi yai homu ilibo nai dabe te agaba sela pelama, tama augwaligo agaba kidu sugunama, tama mage tǫba basi gulali. ");
INSERT INTO mps_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Josepgo augwaliba hanalu wali, “Dage bugagia bidibowe, ma meniwe?” Nosali agai augwaliba hanalu wali, “Magi yaliwe, te duga aya monu, polasa dagego te aga po enabolo wali, aga te bugagia bididubowe?” ");
INSERT INTO mps_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Augwaligo te po wali, “Dago aya, nago sę bidi, aga te bugagia bidibao.” Augwaligo kidu sugunama, tama agaba mage basi gulali. ");
INSERT INTO mps_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Josepgo te aga ama mu Benjamin sulama, tama agai te po wali, “Te bidi aga te dagego ama gesi ogwa bidi mu yali bogo, polasa dagego te aga po dagego enabolo wali, te dawe? Ogwao, eno homugo Godigo dwagi yai olo tau sabo sęgo nage tau somainogo yao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tama Josepgo aga amanu homu dene mu yali. Tama pąde aga gela wainu yali. Tama polo agai augwali taga peyu, te aga be habuba pelama, tama geme naga gela wali. ");
INSERT INTO mps_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Aga te gela ola silama, tama aga gesabi te węgo tedelama, tama aga ma asali. Agai te homu dene ebo te aga homu tomode dąų olama, tama aga sę bidibolo te po wai, “Te tebol saiba nai muao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Augwaligo te Josepgo nai te gasa tebol saiba muyu, te aga ama dedego nai te gasa tebol saiba muyu yali. Te Isip dabe augwaligo te Hibru dabe dali nai deli madi tubo te hagela yai. Te augwaligo bomai pode te dolo meni da, te homu yai. ");
INSERT INTO mps_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Augwaligo te Josep aga ama dede augwali te tebol saide te agai gedu te gesabidi te badu dugayali. Tama augwaligo te ama dede augwa idago ame nani usu nama, tama waselali. Augwaligo te gomunai bidide gagalama, te sabi bidi te ogwa bidiba simanigi pali. Tama te ama dede augwa digi te tiwai dualalubo suali, tama augwaba digi ma tonono pelama, tama augwa homu hauwa eyu, noma sali. ");
INSERT INTO mps_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tama te Josepgo sę ebo bidi dabego te Josepgo tebol saide nai selama, te ama dedebolo dobalama, tuali. Tama te ama dedego nai togolama, dobayali, te tuabo usu naga mani. Tiali goli, te Benjamingo nai te augwaligo genuai mu togwali, te a naga bidigo tuabo nai usu. Tialima, augwali te nai me, wę me te Josep dali hodobo tuyu, tama augwali homu pemene wiegi yai mu yali. ");
INSERT INTO mps_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Augwali nai tula silama, tama Josepgo te aga be tonalubo sę bidibolo te po wali, “Te nai dabe te bidi dabe augwaligo sela pabo usu nama, tama te begba bulao, tama deli deligo mone te augwa beg poba bulao. ");
INSERT INTO mps_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tama eno silva kap te augwaligo ama te sabi bidigo beg tomoba te wit abelali mone dali bulao,” wali. Tialima, sę bidigo te Josepgo wali po tiwai gilama yali. ");
INSERT INTO mps_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tama kigamu digi mu te sę bidi dabego te Josepgo ama dede augwali te augwa donki dabe dali pomainu tagala palali. ");
INSERT INTO mps_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Augwaligo te genuai hanu tagalama, tama augwali digibulu gana pisąbadi, tialima Josepgo te aga be tonaluali bidibolo weyu te po wali, “Nage hogodama, tama te bidi dabe pali wali pobeao. Te nago augwali subosi da, teda augwalibolo nago te tiwai po hanalu wao, ‘Eno genuai bidigo dage dali dwagi yai kolesaga yali dao. Magi baso dagego aga wei ponoyu, tama dwai kolesaga yaliwe? ");
INSERT INTO mps_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Magi baso dagego eno genuai bidigo silva kap wi sela soaliwe? Genuai bidigo te kapde wę tuyu, tama agai te mena sę nosali pedelabo te me konebo sę ebo dao. Dagego dwai kolesaga mu yalio!’ Nago augwalibolo tama po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Te Josepgo sę bidi te augwaliba sabolama, tama augwalibolo te Josepgo wali po te augwalibolo wai. ");
INSERT INTO mps_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tiali goli, augwaligo te tiwai po wei ponani, “Genuai bidi, nago mena tiwai homu elalubaso, tama nago te tiwai po obawe? Dago te tiwai kolesaga yabo te usu me egobeo. ");
INSERT INTO mps_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nago da te Kenan tǫdu ma asali, te nago suai dao. Tama dago te dena beg pode te bulali mone dabe te dago ma sesali. Tama megi magi baso nago homugo dago nago genuai bidigo bede te gol silva te dago wi sela soali homu ebawe? ");
INSERT INTO mps_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Genuai bidi, nago te kap te da me deligo munalubo subaso da, teda te bidi isimainu yaibao, tama da tigidali te nago olo sę ebo bidi pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tama sę bidigo te tiwai po wei ponani, “Dagego po te dolo obao. Tialima, eno te kap gasa bidi me deligo begde bulalubo subaso da, teda te bidi deli naga aga te eno sę olo ebo bidi pedelaibao. Tiali goli, dage meba gasa bage te duga piagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tama polo tama te augwali deli deligo beg te tǫba muna muna pelama, tama dayali. ");
INSERT INTO mps_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Te Josepgo sę bidigo te kap gegebo sę te augwa ama gomunai bidigo begde gagalama, susa paligo te augwa ama gesi ogwa bidigo begba siminigi pali. Tama agai te kap te Benjamingo begde bulalubo suai. ");
INSERT INTO mps_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Te ama dedego te tiwai elalubo sulama, te midigi dwai noma mu selama, tama augwaligo te augwa gudaluali ugwa dabe pisą yali. Tialima, augwaligo te beg dabe te augwa donki tudiba ma munama, tama augwali gelama, te hanuba ma pai. ");
INSERT INTO mps_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda aga ama dede dali te Josepgo beba sabolama, tama augwaligo aga te bede me bidalubo suali. Tama augwali wi mu ebaso, tama augwaligo augwa digi te Josep gesabidiba gedude te tǫba degasa dulali. ");
INSERT INTO mps_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Tialima, Josep hodalu, tama augwalibolo te po wali, “Dage magi yaliwe? Te dagego ena te haniani geme yai sę page koneabo bidi da, te homu ebewe?” ");
INSERT INTO mps_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tama Judago po wei ponoyu te po wai, “Genuai bidi, te dago po mena tama wei ponagawe? Godigo te dago sęgę haninani. Genuai bidi, te nago kap elalubo suali naga, aga te nago olo sę ebo bidi me pedalugobeo. Menio. Da tigidali hodobo tiaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Josepgo te po wali, “Te me tegobeo! Eno tama me egobeo. Te augwaligo te kap munalubo suali bidi, te aga naga eno sę olo ebo bidi pedelaibao. Tiali goli, dage tigidali meba te duga aya bidibo digi ma piagameo. Eno dagede po menio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Juda te Josepba pelama, te po wali, “Genuai bidi, te dago po nage dali omainogo yao. Nage genuai bidi mu te Fero aga tiwai dao. Tiali goli, eno homugo te nago ena dali wado po me olamuo. ");
INSERT INTO mps_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Polobadu nago dabolo te tiwai po hanalu wali, ‘Dagego aya me ama dede bidalubowe?’ wali. ");
INSERT INTO mps_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tama dago te po wali, ‘Awe, dago aya bidibo, aga te monu dabe yai. Tama dago ama gesi ogwa bidi me bidibo,’ wai. ‘Te ida Reselgo te aya monu dabe badi ame nani,’ te po wai. ‘Tama te gesi ogwa bidi aga ama te isai da. Tama te Reselgo ame nani ogwa si te me deli naga bidibo,’ wai, ‘tama aga ayago aga godolo mu ebo dao,’ wai. ");
INSERT INTO mps_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tama genuai bidi, nago te tiwai po dabolo wai, ‘Te dagego ama odasa aselama, te eno sueibao,’ wai. ");
INSERT INTO mps_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Tama dago nago po te tiwai wei ponani, ‘Te waigo aga aya me taga soagobeo,’ wai. ‘Te aga aya taga sobaso da, teda aya isaibao,’ wali. ");
INSERT INTO mps_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tama nosali nago te tiwai po me wai, ‘Te dagego ama gesi ogwa bidi te dage dali asisąbaso da, teda dage ena geduba me pedelamuo,’ wali.” ");
INSERT INTO mps_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Da te dena aya bidibo madi ma pali, te nago sę bidi, tama dago te nago dabolo wali po te agabolo wai. ");
INSERT INTO mps_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Nosali ayago te po wali, ‘Dage ma pelama, tama dago nai dwasianu abeligi pao,’ wai. ");
INSERT INTO mps_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tama dago te po wali, ‘Da me pogobeo. Te ama gesi ogwa bidi te da dali pisąbaso da, teda da te bidi geduba me pedalugobeo. Menio. Tiali goli, te ama gesi ogwa bidi te da dali pali da, teda da paibao.’ ");
INSERT INTO mps_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tama dago ayago dabolo te tiwai po wai, ‘Dagego koneani, eno te wego ogwa si digi ame nani. ");
INSERT INTO mps_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Te me deligo ena taga pai dao. Eno aga munu ma subeo. Tama eno homugo te uni kibugo ela tuali homu yai dao. ");
INSERT INTO mps_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Megi dagego te gasa gesi ogwa bidi te ena digibulu odasa painu wabo, tama aga te isibaso da, teda dagego ena homu dene dwai mu ilaibao. Ena monu dabe yai, tama te homu denego ena mu silaibao,’ dena ayago te po wai.” ");
INSERT INTO mps_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Genuai bidi, megi da, te ena olo ma pobaso, tama ayago te ogwa ena dali ma asobo susiąbaso da, teda aga isaibao, magi baso meni, agai bidibo homu kolesaga te waigo bidibo homu kolesagaba mu dąų wagi pai. Te dago aya te monu dabe dwai mu. Tama te wai da dali ma hodobo asisąbaso da, teda dago te aya aga homu dene ilibogo te aga digi ela mubo tiwai mu yaibao. ");
INSERT INTO mps_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Eno te tiwai po me agabolo dąų wali, te eno te wai te ma odasa asisąbaso da, teda te sę yabo page te enade elalubadi, te ena isibo si usu naibao. ");
INSERT INTO mps_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tama tibaso, eno te waigo pesage selama, tama ena ede nago sę olo ebo bidi bidaio. Te nago aga te aga ama dede dali ma pomainogo emainao. ");
INSERT INTO mps_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Tama te wai ena dali ma pisąbaso da, ena te aya pageba ma pogobeo. Eno te tiwai sęgę te eno ayaba pedalubo te eno homude hagela yaibao,” Judago te Josepbolo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Te Josepgo aga homu dene ebo te aga sę bidi dabe gedude te ma pania sabo te usu yabo ąǫ isąbaso, tialima agai te i bomo elama wali, “Dage tigidali bidi dabe buluba bolo pebelayao.” Tama agaduba deli naga te aga ama dede dali bidali. Tama agai augwalibolo wali, “Ena da, ena te duga ama Josep, te ena tama dao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tama Josepgo gela genuai mu wali, tama Isip dabe odali, tama te tebo po te gavman tuni bidigo beba pedelali. ");
INSERT INTO mps_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Josepgo aga ama dedebolo te tiwai po wali, “Ena Josep dao. Eno aya te bidibowe, ma isai dawe?” Tiali goli, aga ama dede agade wi mu elama, tama didibili eyu, tama augwaligo agai po wei ponabo ąǫ isiąwai. ");
INSERT INTO mps_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Nosali Josepgo po ma olama, “Dage ena pąba asiąo,” wali. Augwali te aga pąba pobaso, tama agai te po wali, “Ena Josep, ena te dagego ama dao. Polobadu dagego ena te Isip dabe dali tagala palai dao. ");
INSERT INTO mps_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tiali goli, megi dage homu sęgę me isiąyu, tama dagego duga digi dwai homu te polobadu dagego ena dali dwai kolesaga yalide, te dwai homu me igio. Menio. Godigo digi eno te dage me isidali weyu, te tau somainu te ena polasa tagala palali. ");
INSERT INTO mps_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Te megi e bulude nasi elalubadi, te kibu be si yalio. Tiali goli, te bidi dabego gide nai sela tusiąbadi, te nai sili bidabo kibu be te a naga me elalubao. ");
INSERT INTO mps_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Tiali goli, Godigo te ena polasa tagala palali, te dage me isidali olama tama tiali. Tama Godigo bomonama, tama dage tau sobaso, dage hauwa te bidibo ula dali me bidaibao. ");
INSERT INTO mps_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Tama dagego digi enade mone siyu, tama ena tagala palobaso, te ena e buluba soabeo. Menio! Godigo digi ena tagala palobaso, tama ena soali. Tama agai ena te Ferogo aya tiwai ilali. Eno agai bede me bulubadu hani tigidali tonalu, tama ena te Isip tigidali pedai badu tolalubo tobolu bidi bidibo dao,” Josepgo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Megi da, dage te dena aya bidiboba pelama, tama agabolo wagi piąo, ‘Te e po te naga ogwa Josepgo po da, Godigo ena te Isip pedai tigidali badu tobolu bidi nigilama bidibao. Nago me tonalugio. Nage polo asao. ");
INSERT INTO mps_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Te nage ena bidibo pąde te tǫ Gosen pąde bidagameo. Nage me, naga ogomani dali, tama naga ogwa dabego wai puluba me, dage te tǫde te duga sipsip me, meme dabe me, bulmakau dabe me, duga doado bage tigidali dali, tede bidagameo. ");
INSERT INTO mps_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Te nage te tǫ Gosenba bidagasobaso da, teda eno nage tonaluaibao. Te nasi yabo kibu be te a naga me elalubao, tama eno homugo nage, me nago we wai puluba, me kibu dabe dali, te nasigo dolidali homu eno hagela ebao.’ Ayabolo te po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Megi dage tigidaligo me, te eno ama Benjamingo me, dagego ena sulama, konea pali. Te ena Josep tama dao, eno te po megi dage dali obao. ");
INSERT INTO mps_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Te eno ayabolo weyu, te ena genuai nogi megi te Isip tǫde genuai elalubo po obadi, tama agabolo me te tigidali nai dagego sula silali po wao. Tialima, dage polo pelama, tama aga odasa eba asao,” Josepgo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tama Josepgo aga ama Benjamin pagea selama, tama gela wali. Benjamingo te aga ama bomonama pagea selama, tama gela wali. ");
INSERT INTO mps_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Tama Josepgo aga ama solo tigidali nono neyu, tama gela dali wai. Tama nosali augwaligo aga dali po miani. ");
INSERT INTO mps_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Te gavman tuni bidi Ferogo beba te tiwai po sabalu, te Josep aga ama dede sabolali po wali. Tama Ferogo me, te sę ebo ofisa bidi dabe dali, augwaligo te pode wiegi yai homu pemene mu yali. ");
INSERT INTO mps_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ferogo te tiwai po Josepbolo wali, “Nago naga ama dedebolo olama, te augwaligo augwa donki dabe sisi elama, tama augwali te Kenanba ma pao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","“Te augwaligo augwa aya, me augwa we wai puluba oda sigi pelama, tama augwali ena pageba ma asiąo. Te ena Ferogo augwalibolo te Isipde wiegi yai tǫ me deli mawaibao. Tama augwali te bulu nai te wiegi yai mu sela tueibao. ");
INSERT INTO mps_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Nago augwalibolo te Isipde te karis meba dali selama, te augwaligo augwa we wai puluba dali sela asomainu te po wao. Te augwaligo augwa aya me eba odasa asao po wao. ");
INSERT INTO mps_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Te po augwaliba weyu, augwaligo te Kenan tǫde taga soabo naide homu godolo me elamuo. Te eno augwalibolo te Isip bulude te wiegi yai tǫ pedai me deli mawaibao,” te tuni bidi Ferogo Josepbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Te Jekopgo ogwa dabego te Ferogo augwaliba wali po tiwai gilama yali. Tama Josepgo te kibu hosgo kegabo karis meba augwaliba mani, te meba nai augwali te sunumidu peyu tuabo nai dali mani, te Ferogo wali gilama tiali. ");
INSERT INTO mps_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tama agai ama tigidali deli delibolo te gesi gudubo ugwa mena mena pali. Tiali goli, te Benjaminbolo agai te gudubo ugwa a naga badi, te mone 300 silva mone mobadi yali. ");
INSERT INTO mps_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Tama Josepgo te Isipde ebo wiegi yai doado bage hauwa te nogo si donkiba munama, tama aga ayabolo tolali. Tama agai gasa nogo si so donki dali, te wit me bret badi, tama te haniani nai te aga aya sunumidu asobadi te tau selama tųdu asabo nai me tolali. ");
INSERT INTO mps_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Josepgo aga ama dede augwali tagala paliyu, augwalibolo te tiwai po wali, “Dage peyu, tama dagego duga hasi konila po olamuo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Augwaligo te Isip tǫ kantri tagalama, te augwa aya Jekop bidibo madi te Kenanba sabolali. ");
INSERT INTO mps_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Augwaligo te po wali, “Josep te isibe yalio. Menio. Aga bidali, tama megi agai te Isip tǫ pedai tigidali tonalubao,” wali. Jekop te midigi dwai mu selama, tama agai te augwaligo wabo poba te homu dąų me wabeo. ");
INSERT INTO mps_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tialima, augwaligo te Josepgo augwalibolo wali po tigidali agabolo wali. Tama Jekopgo suali, te Josepgo aga te Isip odasa asomainu tolali karis dabe. Tama aga wiegi yai homu pemene mu yai. ");
INSERT INTO mps_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Tialima, Jekopgo te po wali, “Mu tama dao! Megi eno koneani, eno ogwa Josep te bidibo ula elalubao! Eno aga sugi paibao. Tama nosali ena isimainu yaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Te Jekopgo aga doado bage tigidali sisinama, tama aga te Berseba teba pelama, tama agai te aga aya Aisakgo Godiba ofa igi pali. ");
INSERT INTO mps_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Te hulide nade God te Jekopba pedelama, tama i wali, “Jekop, Jekop.” Tama Jekopgo te po wali, “Ae, ena e bidibao.” ");
INSERT INTO mps_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Tialima, Godigo te po wali, “Ena God dao. Ena te nago ayago God dao. Nage te Isipba pabo wi me elamuo. Te eno nago hani sibi wąį dabe te genuai hani mu pedelimainu ilaibao. ");
INSERT INTO mps_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Te ena digi ena nage dali te Isipba pelama, tama nosali eno nago hani wąį dabe te eba ma odasa asaibao. Tama Josep nage dali bidibadi, te nage isibo siba usu naibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tialima, Jekopgo Berseba taga soali. Tama aga ogomanigo aga me, te augwa we dabe me, tama te dwasianu wai te Ferogo augwali te sela asomainu te tolali karisba munama pali. ");
INSERT INTO mps_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Tama augwaligo te Kenande sali te bulmakau me, te gasa nai dabe dali selasa peyu, tama augwali te Isipba pai. ");
INSERT INTO mps_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Tigidali ogwa me, wegi dabe dali, te dwasianu ogwa wąį me we, augwali tigidali te Jekop dali pali. ");
INSERT INTO mps_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Te Jekop dali Isipba pali hani dabe augwali nogi e dao. Te gomunai ogwa Ruben da. ");
INSERT INTO mps_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Te Rubengo ogwa dabe nogi te e tiwai, Hanok, me Palu, me Hesron, me Karmi. ");
INSERT INTO mps_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Tama Simeongo ogwa dabe nogi e dao, Jemuel, me Jamin, Ohat, Jakin, Sohar me Saul. Saul te Kenan wego ame nani ogwa dao. ");
INSERT INTO mps_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Tama te Livaigo ogwa dabe e da, Gerson, me Kohat, me Merari. ");
INSERT INTO mps_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Tama Judago ogwa dabe e tama da, Er, me Onan, me Sila, me Peres, me Sera. Tiali goli, Er de Onan si te Kenande isali. Tama te Peresgo ogwa dabe e da, Hesron me Hamul. ");
INSERT INTO mps_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Tama te Isakargo ogwa dabe te e dao, Tola, Puva, me Iop, me Simron. ");
INSERT INTO mps_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Tama te Sebulungo ogwa dabe e tama, Seret, me Elon, me Jalel. ");
INSERT INTO mps_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ruben me Simeon, me Livai, me Juda, me Isakar, me Sebulun te Jekopgo we Leago, te augwali Mesopotemiade bidali sogo te augwali ame nani. Agai te wegi me deli me ame nani, te wegi nogi Daina. Te we Leago ame nani wai dabe te wąį te tigidali 33 usu dao. ");
INSERT INTO mps_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Te Gatgo ogwa dabe te e tama, Sifion, me Hagi, me Suni, me Esbon, me Eri, me Arodi, Areli. ");
INSERT INTO mps_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Tama te Asergo ogwa dabe te e tama, Imna, me Isva, me Isvi, me Beria, tama augwa abe da Sera da. Tama te Beriago ogwa dabe te e tama, Heber me Malkiel. ");
INSERT INTO mps_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tama te 16 hani sibi augwali te Jekopgo wąį te ogwa dabe te we Silpago ame nani. Silpa te sę ebo we te Labango aga wegi Leabolo mani, te sę ebo we dao. ");
INSERT INTO mps_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Te Jekopgo we Reselgo wai te e tama, Josep de Benjamin si dao. ");
INSERT INTO mps_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Josepgo we Asenat te Isipde selama, tama ogwa si ame nani, Manase me Efraim. Asenat te Heliopolis bulu pris bidi Potiferago wegi dao. ");
INSERT INTO mps_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Tama te Benjamingo ogwa dabe te e tama wali, Bela, me Beker, ma Asbel, me Gera, me Naman, me Ehi, me Ros, me Mupim, me Hupim, me Art, tama da. ");
INSERT INTO mps_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Te 14 bage, te augwali Jekopgo ogwa dabe me wai, te Reselgo ame nani hani dao. ");
INSERT INTO mps_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dango te ogwa deli naga ame nani, te Husim dao. ");
INSERT INTO mps_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tama te Naptaligo ogwa dabe te e tama, Jasiel, me Guni, me Jeser, me Silem. ");
INSERT INTO mps_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Te augwali 7 hani te we Bilhago ame nani. Bilha te sę ebo we Labango te aga wegi Reselbolo mawai. ");
INSERT INTO mps_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Te Jekopgo ogwa dabe me wąį hani dabe dolo te Isipba pali, te 66 hani augwali Kenandu pali. Te nedali te Jekopgo ogwa dabego we dabe te augwali nedebe. ");
INSERT INTO mps_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Te Josepgo wego ogwa si te Isipde ame nani. Tama tialima, te Jekopgo hani tigidali augwali te Isipba pali bage nedeyu, tama Josep aga we waide nedali te deliba sisinama, te namba te bidi sese sela olama, gasa bidigo nogo si, te 70 tama augwali te sogo Isip tǫba sisinama, bidai dao. ");
INSERT INTO mps_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Te Jekopgo Juda polasa tagala palali, te Josepbolo hanalugi pomainu pelama, te aga aya agai te Gosen hanu tǫba tiąba asomainu yali. Tama Jekopgo hani augwali te sabolubo sogode, ");
INSERT INTO mps_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","tialima Josepgo te agai po ola tolama, te aga karis sela asobosi, te aga aya tiąba peyu, te Gosen tǫba pali. Aga aya bidiboba sabolama, tama polo aga pagea sigi pelama, tama gela sesabi elama mu wali. ");
INSERT INTO mps_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Tialima, Jekopgo Josepbolo te po wali, “Megi da, ena isibaso, te usu dao, magi baso meni, eno nage suali, tama eno koneani, te nage bidibo ula dali bidibo te eno suali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Tialima, Josepgo aga ama dedebolo me te aga ayago we wai sibibolo te po wai, “Megi da, te eno Ferobolo e tama po wagi paibao, ‘Eno ama dede me eno ayago hani dabe, augwali te Kenande bidali te enaba aselama, bidibao,’ po waibao. ");
INSERT INTO mps_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","‘Te hani bidi dabe augwaligo te sipsip me bulmakau dabe tonalubo sę ebo da. Augwaligo sipsip me bulmakau dabe dali te tigidali doado bage sela asai,’ eno agabolo te po pusaibao. ");
INSERT INTO mps_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tama Ferogo dage i olama, tama dagebolo hanalu, te dagego magi sę ebo dawe po obaso da, ");
INSERT INTO mps_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","teda dagego e tiwai po agabolo waiąo, ‘Genuai bidi, dago te bulmakau me sipsip tonalubo sę te da dwasianu ogomani elalubadi gagalama, te megi e sogoba usu nagasali, te dago dena aya dede hanigo polobadu yali tiwai te dago me yai.’ Te dagego te tama tiwai po weyu da, teda dage te Gosen tǫ pedaide bida po waibao. Eno tama tiwai po wali, magi baso meni, te Isip bidi dabe augwaligo te sipsip tonalubo bidi dabe te augwaligo godolo me ebo meni, tama tedali bidimainao homu ebo dao,” Josepgo aga hani bagebolo te po wai. ");
INSERT INTO mps_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Tialima, Josepgo te tiwai po Ferobolo wagi pali, “Te eno aya me, eno ama dede dali, augwali te Kenan tagalama, tama megi eba sabolalio. Augwaligo te sipsip dabe me, te bulmakau me, tama augwa doado bage tigidali selasa asai. Augwali megi te Gosen tǫde bidibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tama Josepgo aga ama dede a naga sela pelama, tama agai augwali te Ferobolo ola magi pali. ");
INSERT INTO mps_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tialima, Ferogo augwalibolo hanalu wali, “Dagego magi sę ebo dawe?” Augwaligo te po wai, “Genuai bidi, dago te sipsip dabe te dena ayago polobadu yali tiwai, te dago me te sipsip dabe tonalubo sę ebo dao. ");
INSERT INTO mps_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Da te e bulude bidiyu, sę yainu asali, magi baso meni, te nasi genuai te Kenan tǫde eyu, tama dago sipsip dabe te tuabo nosai meni baso, da eba asai. Tama dago homugo te nago dabolo usu da po obaso da, teda da te tǫ Gosende osogo bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tialima, Ferogo Josepbolo te po wali, “Te nago aya me, te nago ama dede dali, augwali te asalio. ");
INSERT INTO mps_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Te Isipde wiegi yai tǫ hauwa te elalubao. Nago me deli gegelama, tama augwali teba muao. Te augwali te Gosende bidainogo ebaso da, te usu dao. Tama nago koneani, te augwali mebago te bulmakau tonalubo sę kuna koneani homu eyu da, teda nago augwali te eno bulmakau tonaluabo bidi me nigilao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Tialima, Josepgo te aga aya Jekop te Fero pageba odasa pali. Tama Jekopgo agabolo te “Eno homugo nage bugagia bidao,” wabo po te Ferobolo mani. ");
INSERT INTO mps_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Tama Ferogo agabolo hanalu wali, “Nago kibu be nisu naga megi elalubawe?” ");
INSERT INTO mps_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jekopgo te po wai, “Eno kibu be te 130 elalubadi, te ena tigidali tǫ pedaiba bilali. Tiali goli, te kibu be dabe te bobage sogo sesabi elama bidisiąbadi, tama ena sęgę hauwa gegali. Te eno kibu be yali, te eno aya dabego yali kibu be te augwali bilali kibu beba usu nubeo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tialima, Jekopgo Ferobolo nage tao po olama, tama aga pali. ");
INSERT INTO mps_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nosali Josepgo aga aya me, aga ama dede dali, te Isipde bidimainu tau sali. Agai augwalibolo te Rameses hanu badu elaluali tǫ te augwali mani. Te tǫ te wiegi yai mu tama, te Isipde elaluali tǫ dabe tigidali aiyaba elaluali. Josepgo te Ferogo wali po tiwai gilama yai. ");
INSERT INTO mps_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Agai te aga aya me, aga ama dede me, te augwa we wai puluba usu nama, te bidabo tubo nai mani. ");
INSERT INTO mps_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Te genuai nasi mu pedelama, tama tigidali tǫ pedai badu nai meni yai. Tama te Isip me Kenan tǫ bidi dabe si te augwali bomo mu meni yai. ");
INSERT INTO mps_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Josepgo te Isip de Kenan bidi dabego te wit abelali mone tigidali sisinama, tama agai te Fero pageba selasa pai. ");
INSERT INTO mps_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Te Isip me Kenan tǫde bidali we bidi tigidaligo mone silali. Tialima, te Isip we bidi tigidali te Josepba pelama, tama augwaligo te po wai, “Nago da nai mao! Te meniyu da, teda nasigo da isaibao. Te nago da tau sabo sunumi me deli gegao! Te dago mone tigidali silalio,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Josepgo te po wali, “Te dagego mone mu silali wida, teda dagego kibu sibi dabe enaba selasa asao, tama eno dage nai mawaibao.” ");
INSERT INTO mps_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tialima, augwaligo te hos dabe me, te sipsip me, meme dabe me, bulmakau dabe me, te donki dabe me, te augwaligo Josepba sela asobaso, tama Josepgo augwali nai mani. Josepgo te tiwai sę ela pidubadi, te kibu be siligi pali. ");
INSERT INTO mps_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tama gasa nosali kibu be mede augwali te Josep pageba ma pelama, tama augwaligo te po wali, “Genuai bidi, dago sęgę ebo te nagebolo geme me dualugobeo. Te dago mone tigidali silibadi, te tigidali sipsip me bulmakau, te doado bage te nageba mena silai elalubao. Dago nageba maiabo nai me elalubeo. Te dago tigi dali, te dago tǫ dali si naga te elalubao. ");
INSERT INTO mps_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nago da te nasigo isimainu sula tagalamuo. Te nago da tau sabo sunumi me deli gegaibawe? Nago te gasa bidi dabego dago tǫ somainogo elamuo. Nago da me, te dena tǫ dali abelama, tama da nai mao. Te da Ferogo olo sę ebo bidi selama, tama agai dago tǫ me saibao. Tiali goli, nago da bulabo nai wai mao. Meniyu da, te da tigidali nasigo isiyu, tama te bulude bidi meni yaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Te nasi bomo mu ebaso, te Isip we bidi tigidaligo te augwa tǫ Josepba menama, tama agai te tǫ tigidali abelai. Tama te Isipde tigidali tǫ te Ferogo tǫ naga pedelama, elaluali. ");
INSERT INTO mps_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tama te Isip tǫ pedai tigidali badu we bidi tigidali augwali te Ferogo sę olo mu ebo we bidi pedelali. ");
INSERT INTO mps_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Te Isip bagego lotu wabo pris dabego tǫ naga te augwaligo me abelibeo. Ferogo te pris dabebolo mone menama, tama te monego augwaligo nai abela tuyu, bidali. Tama tibaso, augwaligo tǫ te me abelimainu me ebeo. ");
INSERT INTO mps_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Te Josepgo te tiwai po te tigidali we bidibolo wali, “Dagego odao, te megi e sogode eno dage me, te dagego tǫ dali abelalio. Megi da, dage te Ferogo bage elalubao. Te e da dagego bulabo nai wai dao. Tialima, dagego te giba bulugi pao,” wai. ");
INSERT INTO mps_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","“Nosali te gide bulali nai tau elama, sabo si, teda dagego te nai bugulama, pesage a naga holama, tama a wali pesage Ferobolo mao. Te me si me si nama pesage te dagego sao, meba te wai bulao, me badu duga we wai dali tuabo nai muao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tama augwaligo te po wai, “Genuai bidi, nago da tau mu saligo, tama da me deli te gų pageba me mubeo. Tialima, megi da, nago homugo usu eyu da, da tigidali te Ferogo sę olo mu ebo bidi dabe pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tialima, Josepgo te tiwai bomo yai po me deli te Isipde muani. Te gide nai inabosi da, teda augwaligo gide sabo nai bugulama, pesage a naga holama, tama a wali pesage te Ferogo nai dao, te bomai po te megi me elalubao. Te prisgo tǫ naga te Ferogo me sabe. ");
INSERT INTO mps_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Te Israel dabe augwali te Gosen tǫde bidaluali, tama augwaligo wai dabe umabo hauwa mu ame nani, tama augwaligo doado bage me hauwa elaluali. ");
INSERT INTO mps_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekop te Isipde bidibadi, te kibu be nogo si olama, sągągo a naga, me badu sągą si wagi soali, tama agai kibu be deliba sisinama, te kibu be 147 mu bidai. ");
INSERT INTO mps_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Te pąde Jekop isainu yali. Tama tibaso, aga ogwa Josep i olama, agabolo te po wali, “Te nago enabolo usu da po weyu da, teda nago nogo si te eno sągą si tomoba munama, tama nago bomai po dąų mu weyu, te nago ena bugagia tonaluama, tama ena isibode nago ena te Isipde munu me pubulamuo. ");
INSERT INTO mps_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Eno homugo nago ena te ena aya dede pąba pubaligi pao. Te ena Isipdu ugwaba tolasa pelama, tama ena te augwali muani gų pageba pubaligi pao,” wali. Josepgo te tiwai po wei ponani, “Te eno nago po wabo gilama tama tiaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tiali goli, Jekopgo te po wali, “Megi nago te sę mu yaibao olama, tama mu dao po wao.” Josepgo te bomo yai po dąų walama, tama agabolo nage usu da po omainogo eyu, Jekopgo tobolu te aga betiba pǫgulali. ");
INSERT INTO mps_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Te meba sogo bidama nosali, augwaligo Josepbolo te po wali, “Nago aya gasi elalubao,” wai. Tama Josepgo aga ogwa si, Manase me Efraim si oda sobadi, tama augwali pelama, aga aya sugi pali. ");
INSERT INTO mps_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Te bidi dabego Jekopbolo te tiwai po wali, “Te nago ogwa Josepgo te nage suainu asalio.” Tialima, Israel te dwasianu bomo elama gana hodaluama, tama betiba duagulali. ");
INSERT INTO mps_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Josep sabalubosi, tama Jekopgo agabolo te po wali, “God te Tigidali Bomo Elalubo te enaba te hanu Lusde te Kenande pedelali, tama agai ena wiegi yai mobo menama, ");
INSERT INTO mps_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","tama agai te po wali, ‘Te eno nagebolo wai hauwa mawaibao, tama nago waigo wąį dabe te bidi hani hauwa pedelaibao. Te augwalibolo te e tǫ menama, tama augwaligo tǫ gagalama, sesemane sogo bidaibao.’ ");
INSERT INTO mps_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ena nage bidibo digi te Isipba asisąbadi, tama nago wego ogwa si ame nani. Te megi eno homugo te ogwa si te eno ogwa si mu tiwai bidimainogo ebao. Efraim me Manase te ena ogwa mu si, te Ruben me Simeon te tiwai si dao. ");
INSERT INTO mps_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tiali goli, te nago wego nosali ame nabo wai dabe, te augwali naga wai mu yaibao. Tama nosali te deli deli haniba tǫ dobabo sogo, te nago nosali ame nabo wai dabe te Efraim dali Manase dali sigo hanide te augwaligo tǫ sa munama, saibao. ");
INSERT INTO mps_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Eno te kolesaga yali, magi baso meni, polobadu te naga ida Resel te ena te Mesopotemiadu ma asobadi, te aga isali. Tama tede ena moni homu dene genuai mu yai. Aga te Kenan tǫde isali, te da te bulu Efratade te dwasianu digibulu gana bidibadi tiali. Eno aga te Efrataba pabo sunumi sesegede pubulai,” wali. Efrata te Betlehem bulu dao. ");
INSERT INTO mps_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Jekopgo te Josepgo ogwa si sulama, tialima agai te tiwai po hanalu wali, “Te e ogwa si te dego wai si dawe?” ");
INSERT INTO mps_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Tama Josepgo te po wali, “Te eno ogwa si da. Godigo te Isipde augwali si te enabolo mani.” Tialima, Jekopgo te po wai, “Eno homugo te augwali si enaba odasa asama, te augwali si eno mobo mawaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jekop te monu dabe elama, tama agai gedugo te nai dabe bugagia suainu ebo te usu meni yai. Josep aga ogwa si odasa aselama, tama Jekopgo augwali si nogo tola selama, tama augwali si nono nani. ");
INSERT INTO mps_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Te Jekopgo Josepbolo te po wali, “Polobadu eno homugo te eno nage ma sugobe da, te homu yali. Tiali goli, megi Godigo ena gogoliyu, sula tagalubaso, tama eno nage me, te naga ogwa si dali, te eno megi dage suali,” wali. ");
INSERT INTO mps_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tama Josepgo te aga ogwa si te Jekopgo sągą pagede bidali te ma dobola siyu, tama agai Jekop gedude te agai gesabidi te tǫba basi gulali. ");
INSERT INTO mps_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Josepgo augwali si nogo tola sali. Te dolo nogo badu Josepgo te Efraim nogogo tuali, te Jekopgo aga pobase nogo badu tumainu yali. Tama pobase nogogo te Josepgo Manase nogo tuali, te aga Jekopgo dolo nogo badu tumainu yali, tama agai augwali si te Jekop pageba odasa pali. ");
INSERT INTO mps_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tiali goli, te Jekopgo nogo hasegelama, dolo nogo dali pobase nogo dali si agabe selama muyu, tama agai dolo nogo te Efraim toboluba muani, aga te sabi ogwa bidi tama. Tama agai pobase nogo te Manase toboluba muani, aga te gomunai ogwa dao. ");
INSERT INTO mps_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tialima, agai augwali si mobo te tiwai mani, “Te eno wąį Abraham, me te eno aya Aisak, augwali si te God gedude bugagia bilali. Eno homugo te Godigo te e wai si dali dwagi yai sę emainao. Te Godigo ena bugagia tonaluyu, ena odasa asali, te megi ede ena bidibao, agai te augwali mobo momainao. ");
INSERT INTO mps_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Te mobo bidi enselgo tigide pedelali God, te agai ena tonaluyu, tama ena me dolobe, eno homugo aga digi mobo te augwali si momainao. Te eno homugo te eno nogi me, te eno wąį Abrahamgo nogi me, te eno aya Aisakgo nogi me, te augwali sigo hanide elaluaibao. Te augwali sigo wai hauwa mu ame nenama, tama genuai hani bage pedelaibao. Godigo augwali side tama timainao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Te Josepgo suali, te aga ayago dolo nogo te Efraimgo toboluba mubaso, te agai hagela homu yali. Tama agai aga ayago nogo te Efraimgo toboluba mubo te sela sąnama, tama te Manasego toboluba muainu yali. ");
INSERT INTO mps_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Tama agai te tiwai po aga ayabolo wali, “Aya, nago te yali sę dolo ebeo,” wali. “Te e ogwa da, aga te gomunai ogwa dao. Te nago dolo nogo aga toboluba mugi sogo da, te usu igi dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tiali goli, aga ayago te agai po wali me pabeo. Menio. Agai te tiwai po Josepbolo wali, “Eno koneani, ogwao. Eno koneanio. Te Manasego hani wąį dabe te augwali hani me te genuai pedelaibao. Tiali goli, te aga ama sabi bidi da, te genuai bidi pedelaibao. Tama agai wąį dabe te augwaligo te Manasego hani te aiyaba elaluama, tama augwali te genuai hani bidi sibi mu pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tialima, Jekopgo augwali si te sogo te mobo po mayu, te tiwai po wali, “Te augwaligo te Israel dabebolo hanalu, te dage si mobo mani tiwai emainu, te gasa bidi dabego me te Godigo augwali mobo mao po hanalu waibao. Te augwaligo te po waibao, ‘Godigo dage te Efraim de Manase te augwali sibolo yali tiwai yao,’ tama waibao,” te po wali. Jekopgo te tiwai elama, te agai Efraim te podolama, te Manase nosali ilali. ");
INSERT INTO mps_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nosali Jekopgo Josepbolo te po wali, “Odao! Te pąde ena isainu ebao. Tiali goli, God te nage dali bidama, tama agai nage te naga aya dedego tǫba ma odasa paibao. ");
INSERT INTO mps_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Sekem te wiegi yai tǫ mu dao. Eno te Amor dabe dali te hwą ge bainat me enesigi sigo boi hwįnama, tama augwaligo te tǫ eno sali. Tama ena digi eno te tǫ te eno nagebolo naga megi mobao. Eno te naga ama dede augwalibolo me magobeo,” Jekopgo Josepbolo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Te Jekopgo aga ogomani tigidali i olama, tama aga pibo sai bet sesegede duagulama, tama agai augwalibolo te po wali, “Dage hodobo sisinagaselama, tama eno dagebolo nosali pedelabo nai po waibao. ");
INSERT INTO mps_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Aselama, hodobo duayagasao, dage te Jekopgo ogomani, tama bugagia odiąo. Dagego duga aya Israelgo po bugagia odao. ");
INSERT INTO mps_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, eno gomunai ogwa, nagede eno bomo elalubao. Tama nage eno gomunai ogwa te ena gesi bidi elalubadi, hasia bolo ame nani. Nago nogi genuai mu, tama nage te eno tigidali ogwade nage bomai mu elalubo dao. ");
INSERT INTO mps_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Te nago kolesaga te wę bomonama, subigila soabo tiwai gilama ebo. Tiali goli, nage te gomunai bidi nogi me elalugobe, magi baso meni, nago te naga ayago we dali pagela piali. Tama nago eno we sabo hwįgiani. Nago te ena pibo bet tomoba bogi soali!” wali. ");
INSERT INTO mps_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon de Livai si, augwali si te ama nami si dao. Augwali sigo te hwįbo moni hwą te sabiliyu, te dwai kolesaga ebo dao. ");
INSERT INTO mps_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Eno te augwali sigo geme ebo sęde te eno usu da po me wagobe. Ena te augwali si sisinama bidibo pesagede me bidigobeo, magi baso meni, te augwali sigo te wado ebo sogo te bidi dabe ela muyu yali. Tama hagoma eyu, augwali sigo te dodolama bilibo kolesagago te bulmakau sągą babi kigibili tologobo da. ");
INSERT INTO mps_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Te haliga sębę ebo sęgęgo te augwali si mesegelali, magi baso meni, te augwali sigo wado po wabo te bomo mu yali. Tama haliga sębę ebo sęgęgo te augwali mesegelali, magi baso meni, te augwali sigo haliga sębę ebo te dwai mu yai. Te eno augwali si te Jekopgo bulu tedali tedali tedela pomainu yaibao. Te eno augwali si te Israel bage tomode bidada pomainu tedela palaibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, te naga ama dede augwaligo te nago nogi ugwaba saibao. Nago te naga boi bidi dabe augwali te magede tola siyu yaibao. Te naga ama dede augwali mage aiyaba basi gulama, tama nage nogi ugwaba saibao. ");
INSERT INTO mps_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, nage te gesi ogwa bidi laion me deli tiwai. Agai te aga hasa elama, tama nosali te aga geme dualalubo pesagede geme ma duala sigi pabo tiwai yali. Juda te ogwa bidi laion me deli tiwai aga da. Agai te aga sągą dili dodolama, tama nosali aga pibo da. Tama me deligo te aga dali hagoma me eyu me egobeo. ");
INSERT INTO mps_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Agai te tuni bidigo dono tulama, tama aga sągą sawali si tomoba muani. Tama tede mu elaluaibao, te gasa bidigo te bomo sogobeo. Teda agai te bomo tolaluyu, tama te bomo aga aya mu pedelama, tama te tigidali hani bidi dabe tonalubo teba mu usu naibao. ");
INSERT INTO mps_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Agai te aga donki te bono ni wainde gebelaibao. Agai te ogwa bidi donki te wiegi yai ni wain nologode mu gebelaibao. Agai te aga ugwa te waingo wę telawaibao. Agai te kaneme tiwai wain te mama yai ąįgo wę telawaibao. ");
INSERT INTO mps_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Te wain wę te sisi yai dao, tiali goli te nosali pedelabo tuni bidigo gedu si te husugu sisi mu yaibao. Te ame pę te tedela yai dao, tiali goli te we bidi tonalubo bidigo kele dabe te wiegi yai nala tigi poai yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun te tamu ąį pąde bidaibao. Te aga bidibo tama wę saneba te sip dabe tuagasobo madi elaluaibao. Te agai tǫ sesege badu te dąį igi pabo te Saidon buluba usu nugi paibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar te bomai donki tiwai me deli dao. Tiali goli, aga olo te walu tomo daide pila muaibao. ");
INSERT INTO mps_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Agai te toma nabo dwagi yai bulu pesage sulama, tama tǫ te wiegi yai mu elaluai, tama agai te walu dabe toliyu, te dili bomo elama, tama aga te olo sę ebo bidi pedelama, tama bomai sę dene yaibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan te aga hani bidi dabe augwali te Israel hani me deli dao, tama agai te aga we bidi dali te po tų dodolobo sę bugagia yaibao. ");
INSERT INTO mps_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan te sunumi sesegede te hasamani me deli tiwai elaluaibao. Te hwįbo hasamani me deli da. Aga te sunumi sesegede bidaibao, tama te posoga paliyu, te hos sągąde gąų kelaiba, tama bidi te hosde dualama udabaso da, te aga tula muaibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Yawe, nago ena tau somainu eno nage tonalubo dao.” ");
INSERT INTO mps_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Te nai wi sabo bidi dabe augwaligo te Gat dali hwįagasaibao. Tiali goli, Gatgo te augwali dali ma begelama hwįyu, tama augwali ela gudulaibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Te Asergo tǫde te wiegi yai nai mu holaibao. Te Asergo te gavman tuni bidigo wiegi yai tuabo nai pedalubo sę ilaibao.” ");
INSERT INTO mps_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali te uni sulai meme te aga homu wali bilibo tiwai yaiba. Tama aga wiegi yai wai dabe ame nabo da.” ");
INSERT INTO mps_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josep te bidigo tonalusiąbo donki me deli tiwai. Aga te wę ulu sesegede bidibo donki me deli tiwai. Aga te bulu du pedai badu bidibo, te ogwa bidi hos me deli tiwai dao. ");
INSERT INTO mps_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Te boi bidi dabego moni wąbi dobo mu hwįaibao. Augwaligo enesigigo aga pobeasa paibao. ");
INSERT INTO mps_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tiali goli, augwaligo enesigi tigidali togwa pali. Tama agai enesigi balibi pedebeo. Te God, Tonalubo Bidi, agai te Israel dabe sesemane sogo tau siyu, tama te kolesaga ebo hasegelegobeo. Te agai bomo te moni genuai bulu du masigi tiwai dao. Te God agai te Josep dali boi homu ebo bage augwali aiyaba elaluaibao. ");
INSERT INTO mps_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Aga te naga ayago God, tama aga bomo mu tigidali elalubo. Eno homugo agai nage mobo mayu, tama nage tau sabo. Te mobo hauwa Josepba muaibao, te kulubage ugwadu tulubo, tama tǫ dologode wę pedalubo, te idago wai hauwa ame nabo mobo mobadi, ");
INSERT INTO mps_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","te tubo nosai wai dabego mobo me, te plaua dabe holobo mobo me mani, te polobadu bulu du dabe te mobo me mani, te sesemane sogo elaluabo bulu du dabe mobo mawai. Eno homugo te tigidali mobo te Godigo Josep toboluba muao. Augwali te bidiba holama, te augwaligo aga te gasagi yai bidi te aga ama dede tiwai gilama me nigilibeo. Menio. Josep aga gasagi yai tedali bidi bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin da, te genuai uni yowi me deligo te hasa dabe elibo kolesaga konebo tiwai gilama yaibao. Te kigamu te aga te elali hasa tubo gilama yaibao. Tama pio aga te sali nai dabe dobaduaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Te e da, te Israel hani nogo si olama, sągągo si, tama te dwagi yai bidabo po dabe te aga ayago augwalibolo wali. Tama agai augwali tigidali deli delibolo usu nama, te po augwa ayago augwalibolo wali. ");
INSERT INTO mps_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nosali Jekopgo te po aga ogomanibolo wai, “Enade, te pąde megi tama eno ena hani isali bage dabe sisinigi paibao. Dagego eno tigi te ena wąį dabe dali te bidi Hit hani dabego te Efrongo tǫ pedai badu te ola be tomoba mugi pao. ");
INSERT INTO mps_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Te ola be te giliga ge pedalubo badu te Mamre, te Makpela bulude elaluali, te Kenan tǫ badu elaluali. Abrahamgo te tǫ te Hit bidi dabe, te Efrongo tǫde abelali. Agai te tǫ me, te ola be me, te gų page nigainu abelai dao. ");
INSERT INTO mps_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Augwaligo Abraham de aga we Sara si te gų pagede pubulali. Tama augwaligo Aisak me aga we Rebeka te gų pagede pubulali. Tama eno te Lea me te gų pagede pubulali. ");
INSERT INTO mps_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Abrahamgo te tǫ me, te ola be dali, te Hit bidi dabe dali polobadu abelai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jekopgo aga ogomani dali po mia silama, te aga sągą te bet sai dologo tomoba bulama, tama aga isali. Aga te aga hani bage bidalubo madi, te isali bidi dabego buluba tama pai. ");
INSERT INTO mps_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Josep aga aya bauba pigiluama, tama aga gela olama, tama agai aga gesabidide nono nani. ");
INSERT INTO mps_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nosali Josepgo te aga dokta bidi dabebolo olama, te aga tigiba te tobage wel muao wali, te tigi polo me dolidali weyu tama tiali. Te dokta dabego te Josepgo wali po tiwai gilama yali. ");
INSERT INTO mps_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Augwaligo te tiwai sę te bidi sese si sogo, te 40 dei, te tama sogo yali, te tama sogo augwaligo te sę yali bodolu muani. Nosali te Isip bidi dabego Jekopde gela udubadi, te 70 sogo bidali. ");
INSERT INTO mps_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Te Josep aga ayade homu dene eyu, gela weyu yali te silibo side, teda agai te tiwai po te Ferogo ofisa bidi dabe dali wali, “Te dagego enade wiegi yai homu eba wida, teda eno e wabo po te dagego Ferobolo wagi pao, ");
INSERT INTO mps_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Te eno aya isainogo ebo sogo, agai enade po dąų walu, te eno aga te aga tigi te Kenande nigali gų pageba pubaligi pao po wai. Tama tibaso, nago ena tagala paloyu da, te eno aya bolo pubaligi pelama, tama nosali te ena ma asaibao,’ te po wao,” Josepgo te po wali. ");
INSERT INTO mps_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ferogo te tiwai po wei ponani, “Nago te naga ayago nagebolo te po dąų wali gilama tama naga aya pubaligi pao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tialima, Josep pelama, te aga aya pubaligi pali. Te tigidali ofisa bidi dabe, me te Ferogo bede bidalubo genuai bidi dabe, me te Isipde bidalubo tigidali tobolu bidi dabe me, augwali te Josep dali pepela wali. ");
INSERT INTO mps_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Te Josepgo we wai me, te aga ama dede me, te aga ayago we wai me, tigidali te augwali pali. Te dwasianu wai dabe naga te sipsip dabe dali, te meme dabe me, tama te bulmakau dabe dali, augwali te Gosen tǫde bidaludali. ");
INSERT INTO mps_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Te karis dabe me, te hos kibude bilibo bidi dabe me, augwali te Josep dali pepela wali. Tama te genuai hani dabe mu augwali pai. ");
INSERT INTO mps_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Augwali tama pelama, tama te wit penibo pesage te Jordan ąį u badu, te augwali Atat teba pedelali sogo, augwaligo te bobage sesabi ebo gela genuai te bidi pubalubo gela tiwai wali. Tama Josepgo te homu dene ebo kolesaga elama, tama aga gela udubadi, te a naga olama, me badu nogo si sogo bidali. ");
INSERT INTO mps_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Te Kenan bage augwaligo te Isipdu asali bage te Atat bulude gela me homu dene ebo sulama, tama augwaligo te po wai, “Te sę ebo te Isip dabego genuai gela weyu, te homu dene ebo kolesaga dao.” Tama tibaso, augwaligo te bulu nogi te Abel Misraim nogi yali. Te bulu te giliga pedalubo te Jordan badu elaluali. ");
INSERT INTO mps_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Te Jekopgo ogomanigo po wali pelama, te augwalibolo wali po tiwai gilama yali. ");
INSERT INTO mps_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Augwaligo aga te Kenan tǫba tolasa pelama, tama augwaligo aga te Makpela ola bede pubulali, te bulu te Mamre te giliga pedalubo badu elaluali. Abrahamgo te tǫ te Efrongo tǫ pedaide abelali, aga te Hit hani bidi me deli da. Agai te tǫ abelali, te gų page nigabo pesage abelali. ");
INSERT INTO mps_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josepgo aga aya pubulama, tialima aga te Isipba te aga ama dede dali badi, te aga dali asali bidi dabe tigidali te Isipba ma pepela wali. ");
INSERT INTO mps_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Te augwa aya isalima, te Josep aga ama dedego augwa hasi te po wai, “Megi da, magi yaliwe, te Josepgo da dali te dago aga dali dwai sę yali te tigidali wei ponoyu, te da dali wado me udugowe?” ");
INSERT INTO mps_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tialima, augwaligo te po Josepba ola tolali, “Te nago aya isisąbadi, agai te po dabolo mawai, ");
INSERT INTO mps_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Te Josepbolo wao, “Eno nagebolo hanalu wali, te naga ama dedego te dwai sę genuai yali, te sęgę nago sela sąyao,” ’ te po wai dao. Da te nago ayago Godigo sę bidi dao. Da nagebolo dwai sę yali. Megi, nago te dago yali dwai sę sela sąyao.” Josepgo te po wali odolama, tama aga gela udali. ");
INSERT INTO mps_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nosali te Josep aga ama dede sabolama, tama augwaligo augwa tobolu aiyaba basi gulai. Tama augwaligo agabolo te tiwai po wai, “Da nageba pedelali, te nago olo sę ebo bidi bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tiali goli, Josepgo te po augwalibolo wai, “Dage wi munu me elamuo. Eno te God tiwai gagalama, te dagego te dwai kolesaga yali te eno wei ponogobeo. ");
INSERT INTO mps_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Polobadu dagego ena dolabo homu dąų wali. Tiali goli, Godigo te dwai kolesaga begelali, tama agai te bidi hauwa bidibo ula elaluyu, tama augwali me hagaidali weyu, wiegi yai sę pedalumainu ilali. Tama tialigo da, megi te we bidi dabe bidaluali. ");
INSERT INTO mps_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tialima, megi dage wi munu me elamuo. Te eno dage me, te dagego wai dabe dali, tonalueibao.” Josepgo te tobage wiegi yai po aga ama dedebolo menama, tama te pogo augwali homu bugagia tegaluali. Tama augwali wi munu me ma ebeo. ");
INSERT INTO mps_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Te Josep te Isipde aga ayago hani dabe dali bidali. Te Josepgo kibu be 110 elama, tama aga isai dao. ");
INSERT INTO mps_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Aga te gedu pedalu bidibadi, tama aga ogomani me subadi, te Efraimgo ame nani wai dabe me suali. Te Makirgo wai dabe ame nani sogode, Josepgo te aga hani wai tomoba sela muani. Makir te Manasego ogwa dao. ");
INSERT INTO mps_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Josepgo te tiwai po aga ama dedebolo wai, “Te sia sabode ena isaibao,” wai. “Tiali goli, te Godigo dage tonalueibao, tama agai dage e bulude bidali sela peyu, taga paibao. Tama agai dage odasa peyu, te Abrahambolo me, Aisak me Jekop, te augwalibolo mawaibao olama, te po dąų wali tǫba dage odasa tagaligi paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nosali Josepgo te Israelgo ogwa dabebolo te mu po dao po wao po me deli te hanalu wali. Agai te po wali, “Dagego enaba po dąų waliyu, te God asiyu dage tau sabo sogode, teda dagego ena pubulali pesagede te ena tigi dili hodolama, tama dage peyu, te dili sela piąo,” wali. ");
INSERT INTO mps_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Josep aga kibu be te 110 elama, te aga isali. Augwaligo te bidi tigi damusiąbo te tobage wel dabe te aga tigi damudali weyu, te aga tigide muani. Augwaligo te tiwai Isipde elama, tama augwaligo aga tigi te gų page nigali halobage me deliba muani. ");
INSERT INTO mps_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","2","Te Jekop aga ogomani dali augwali hodobo Isip buluba pai. Tama te sogo augwa we wai dabe dali hodobo pai. Jekopgo ogomani nogi tama wai: Ruben, me Simeon, me Livai, me Juda, ");
INSERT INTO mps_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","me Isakar, me Sebulun, me Benjamin, ");
INSERT INTO mps_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","me Dan, me Naptali, me Gat, me Aser. ");
INSERT INTO mps_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tama agai ogwa me te Josep polasa pelama, Isip buluba polobadu bidigi pai dao. Te sogo te Israel hani, te Jekop aga hani mu, augwali te bidi sese sela olama, nogo si we bidi 70 augwali Isip buluba bidigi pai. ");
INSERT INTO mps_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tama nosali Josep aga ama dede aga hani tigidali augwali te sogo te Isip bulude bidibadi, augwali tigidali isai. ");
INSERT INTO mps_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tiali goli, augwaligo ame nani wai te Israel hani augwaligo wai hauwa ame nai, tama augwali hani hauwa mu te bomai bidi hani pedelai, tama augwaligo te Isip tǫ pedai badu Gosen te pągąna sai. ");
INSERT INTO mps_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Tama nosali gesi tuni bidi me deli pedelama, agai te Isip bidi hani tonaluai. Tama te gesi tuni bidi agai te Josepgo nogi konesiąwai. ");
INSERT INTO mps_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Tama te tuni bidigo aga Isip we bidi hani dali te po wai, “Suiąo, te Israel we bidi hani augwali hauwa mu yai, tama augwaligo bomogo dago bomo aiyaba elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tama wąbi hwįbaso da, te augwaligo dago boi bidi dali taluama, da dali hwįyu, tama dago bulu tagalama, augwali wi paibao. Tama dago augwali hani hauwa pedalidali weyu, dąų wabo tų gegegaibao,” te Isip gavman polasa tuni bidi agai te po wai. ");
INSERT INTO mps_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tama te po olama, te Isip hanigo te Israel hanigo bomo kimi isilainogo eyu, tama augwaligo te sę tonalubo bidi dabebolo te sę mawai, tama te bidi dabe augwaligo te Israel hani sę emainogo selai, tama augwali sę dene mu yai. Tama augwaligo te Israel hanibolo genuai hanu me si niga po wai, te hanu me nogi Pitom, me Rameses. Te hanu side te Isip tuni bidigo nai sisinabo madigi te hanu nigai. ");
INSERT INTO mps_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tama te Isip hani augwaligo Israel hani dali dwai sę dene menama, tama augwali mu dolobo sę yai goli, tialima te Israel hani bidi hauwa mu pedaliyu, tama tedela peyu, tama te Isip bulu tǫ pągąna sai. Tama Isip hani augwali te Israel bidi hani sulama, tama dwai homu eyu, augwali wi mu yai. ");
INSERT INTO mps_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Tama Isip hanigo Israel bidi hanibolo sę dene mawai. Tama Israel hani augwali dodolama mu bidai. Tama te Isip hanigo Israel bidi hanibolo te masigigo be sę ebo, te sę me te gi sę me ya wai, tama augwali sę dene mu yai. Tama augwaligo Israel bidi hani hobede me ebeo. Mu menio. ");
INSERT INTO mps_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Tama we si bidali, te we me nogi Sifra, me we nogi Pua, tama te we augwali sigo te Israel te Hibru we dabego wai ame nabo tau sabo sę yai. Tama te Isip tuni bidi agai te we sibolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Dage sigo te Hibru we me deligo wai ame nobadi tau sabo sogo, tama te wego wai te ogwa ame nobaso da, te wai dage sigo ela muao. Tama te wego wegi ame nobaso da, te wai dage sigo elisiąma tagalao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Tama te we si God dali wi elama, tama augwali sigo te tuni bidigo wali po wali pabeo. Tama te we sigo te Israel we dabego ogwa ame nabo elisiąma tagalama elaluai, te we sigo te ogwa ame nabo elebeo. ");
INSERT INTO mps_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tama te Isip tuni bidigo te we si i olama, augwali sibolo te po hanaluyu, te po wai, “Magi baso dage sigo tama tebo dawe? Magi baso dage sigo te Israel wego te ogwa ame nabo sula tagalama elalubo dawe?” wali. ");
INSERT INTO mps_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Tama augwali sigo po wei ponoyu, te po wai, “Hibru we augwali te da Isip we dabe tiwai menio. Augwali te bomo yai we dabe weyu, tama augwaligo wai polo mu ame nabo dao. Tama da augwali pąba pedalisiąbadi, augwaligo wai polo ame nai digi da pabo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Tama Godigo te we si dali dwagi yai sę yali. Augwali sigo God dali wi yai, tama agai te we augwali sigo me wai ame nomainogo yai. Tama Israel hani augwali hauwa mu pedaliyu, tama augwali bomo yai bidi hani pedelai. ");
INSERT INTO mps_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Tama nosali tuni bidigo Isip we bidibolo te po wai, “Dagego te Hibru hanigo ame nabo wai te ogwa tigidali selama, te moni pabo ąį Nail te ąįba sąya,” wai, “tama te wegi yai baso da, tagalama bidimainao,” wai. ");
INSERT INTO mps_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Tama te Israel hani tomode, bidi hani me Livai hanigo te me Livai hanigo wegi sai dao, polobadu. ");
INSERT INTO mps_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Tama nosali te we haliga elama, tama wai ogwa me deli ame nai. Tama te wego te wai bǫų dwagi yai wai yai baso, geme dualama, tama te wai dualama polua sela bidai. ");
INSERT INTO mps_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tama nosali agai te wai ma dualainogo yali usu meni yai, tama agai te basket wa augwaligo te awi diligo nigai selama, tama mege me siyu, tama te megego te basket wa dedage sebelai. Tama agai te wai te basket wa tomode pilama, sela pai, tama te Nail ąį sesegede te sigi sili elalubo digi te wai dualigi pai, te sigi sili tomode, te ąį daide muai. ");
INSERT INTO mps_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Tama te wai aga abe digibulu gana dulaluyu, tama te wai dali magi sę ebowe naga suainogo tonaluai. ");
INSERT INTO mps_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Tama aga dolalubadi, te Isip tuni bidigo wegi aga sę we dabe dali te ąįba asai. Tama aga sę we dabe augwali te olo bilalubadi, tama te tuni bidigo wegi ąį paugi pai. Tama te wegi agai te basket wa sigi sili tomode munalubo sulama, tama agai aga sę we me deli tagala palama, tama te wa agabolo sela magasali. ");
INSERT INTO mps_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Tama tuni bidigo wegi agai te basket wa dalama suali, te wai bǫų ogwa te wade munalubo suai. Tama agai te wa po dabadi, tama te wai bǫų gela wai, tama te tuni bidigo wegi agai te wai homu dene mu eyu, tama agai te po wai, “Te e wai! Te Hibru hanigo wai dao,” te wegigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Tama te wai aga abe pąba aselama, te tuni bidigo wegibolo hanaluyu, te po wai, “Te eno Hibru we me i wagi pelama, tama e wai ame menama, tama te e wai te wego negebo usu egowe?” ");
INSERT INTO mps_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Tama tuni bidigo wegi agai te po wali, “Te usu dao, te nago tama tiao,” wai. Tama te wai aga abego aga ida mu odasa asai. ");
INSERT INTO mps_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Tama te wai aga ida asai, tama te tuni bidigo wegigo te webolo te po wai, “Eno te wai nago selama, ame mayu, bugagia tonaluao,” wai, “tama eno nage masigigo abelaibao,” wai. Tama te wai aga idago selama, ame mayu, bugagia tonaluai. ");
INSERT INTO mps_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Tama nosali te wai dwasianu genuai gana ebo si, aga idago te wai te tuni bidigo wegibolo magi pai. Tama tuni bidigo wegigo te wai aga wai mu tiwai yai. Tama agai te po wai, “Te eno e wai ąįde munalubadi, tama eno ugwaba sela holai, tama tebo olama. Tama tibaso, eno agai nogi Moses poai,” wali. ");
INSERT INTO mps_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Tama nosali Moses genuai bidi yai, tama agai te Hibru bidi hani sugi pai, te augwali aga hani bidi, tama abagi dabe dao. Tama agai suali, te augwali Isip tuni bidigo sę ebo dene mu yai. Tama agai suali, te Isip bidi me deligo Hibru bidi me deli ela mubo suai, te Moses aga abagi te Hibru hani. ");
INSERT INTO mps_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Tama Moses agai tonono bilali, te bidi me bidibo subeo. Tama agai polo mu te Isip bidi ela muai, tama te bidi te masigi kemide haluai. ");
INSERT INTO mps_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Tama te sogo nosali Mosesgo suali, te Hibru bidi me aga si hwįbo suai. Tama Moses agai te wado po olama, hwįani page bidi dali te po wali, “Magi baso nago naga abagi elebawe?” ");
INSERT INTO mps_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Tama te bidigo Mosesgo po wei ponoyu, te po wai, “Nage te tobolu bidi, tama dago po dodolobo bidi menio. Tama nago ena elainogo, te nago Isip bidi me ela muani tiwai yainogo obawe?” Tama Mosesgo te bidigo te po wabo odolama, aga wi yai. Tama agai te homu yai, ‘Eno te Isip bidi me elali, te we bidi augwaligo polo koneai,’ te homu yai. ");
INSERT INTO mps_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Tama nosali Isip tuni bidigo Mosesgo te sę yali po odolama, tama agai Moses elainogo yai, tama tibaso Moses aga wi digibulu pelama, te Midian buluba bidigi pai. Aga te tǫba sabolama, tama aga te ąį tubo digi te sesegede dulaluai. ");
INSERT INTO mps_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tama te Midian tǫde pris bidi me deli digi bidai, tama agai nogi si, te Ruel, me Jetro. Tama te bidi agai wegi a naga olama me badu nogo si bidai. Tama Moses te ąį ulu tǫ dedagedu asobo digi pąde dulaluai, tama te bidigo wegi dabe te augwa ayago kibu sipsip meme dabe maiabo ąį tuagasu asai. ");
INSERT INTO mps_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tama tialima, gasa sipsip tonalubo bidi hani aselama, tama augwaligo te bidigo wegimani ąį tuagasu asobadi, augwali sela sąnama, “Pao,” wai. Tama Moses agai te wegi dabe tau siyu, tama te bidi dabe augwali sela sąwai. Tama nosali Moses agai te wegi dabego kibu sipsip meme dabe ąį mawai. ");
INSERT INTO mps_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Tama nosali te wegi dabe augwa aya Ruel bidibo digi ma pai, tama augwa ayago augwalibolo hanaluyu, te po wali, “Magi elama, dage megi polo ma asobawe?” ");
INSERT INTO mps_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Augwaligo po wei ponoyu, te po wali, “Isip bidi me deli agai da tau selama, tama te gasa kibu sipsip tonalubo bidi dabe augwaligo da ela gudulubeo. Tama te bidi agai dago kibu sipsip meme dabe me agai ąį mawai,” wali. ");
INSERT INTO mps_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tama te bidi aga wegi dabebolo hanaluyu, te po wali, “Te bidi menade bidibowe? Tama magi baso dagego aga ude taga soaliwe? Dagego te bidi aga i wagi pelama, tama aga da dali nai tuagasomainao,” wali. Tama te wegi dabe pelama, augwaligo Moses odasa asai. ");
INSERT INTO mps_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Tama nosali Jetro agai homugo Moses aga dali bidimainogo yai, tama Mosesgo te usu dao te po wai. Tama Jetro agai wegi Sipora me Moses mawai, tama Mosesgo te wegi sai. ");
INSERT INTO mps_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Tama nosali Sipora wai haliga elama, tama ogwa me deli ame nai. Tama Moses agade digi po weyu, te po wali, “Ena gasa bulu tǫ bidi e tǫde bidibao. Tama tibaso, eno te wai nogi Gersom dao obao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Tama kibu be meba bidilama, tama nosali te Isip tuni bidi isai. Tama Isip hani augwaligo Israel hanibolo sę dene mu mawai. Tama Israel hanigo Godigo augwali tau somainogo tigidali sogo Godibolo gela weyu, i wai. ");
INSERT INTO mps_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tama Godigo augwaligo te gela wabo odoyu, tama Godigo te bomo yai po Abraham, me Aisak, me Jekop, augwali dali dąų wali, te agai koneai, tama agai te augwaligo wąįgo wai dabe augwali tau saibao te po wai, polobadu. ");
INSERT INTO mps_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tama tibaso, God agai te Israel bidi hani augwali dodolama mu bidibo suai. Tama agai augwali hobede elama, agai augwali tau sabo homu yai. ");
INSERT INTO mps_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Tama nosali me sogo Moses agai te kibu sipsip dabe, me te meme dabe te aga wąį Jetro nai dabe tonaluai, te Jetro aga da te God dali te Midian bage tomode dolalubo pris bidi dao. Tama me sogo deli sogo Mosesgo te kibu sipsip me meme dabe odasa peyu, te wa pai bulu taga peyu, te tǫ pedai me nogi Horep, te bulu du Sainai tede elalubo, teba sabolali, te Godigo bulu du dao. ");
INSERT INTO mps_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tama Genuai Bidigo Ensel Mobo Bidi agaba pedelama, te sia dabo tiwai, te dwasianu ni nologo tomode sia bogoli pedelai. Tama Mosesgo sia te nide dabo suali, tiali goli te siago te ni dela dolobeo. ");
INSERT INTO mps_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tama Moses aga homu hauwa eyu, te po wali, “Te gasagi yai nai mu dao. Tama magi baso mu siago te ni dolobewe? Te ena pąba pelama, te sia dabo nai sugi paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Genuai Bidi te sia dabo ni tomode bidibadi, te Moses pąba asobo suali, tama Godigo i olama, te po wali, “Moses. Moses.” Te po wali. Tama Mosesgo te po wai, “Magi yaliwe?” ");
INSERT INTO mps_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Tama Godigo te po wai, “Nage pąba aselamo dao. Tama nago sągą nadoba dią muao. Magi baso meni, te megi nage dolalubo tǫ te eno tedali gasagi yai tǫ, tama te tǫ eno habu selai tǫ dao. ");
INSERT INTO mps_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Tama ena te nago wąį dabego God dao. Ena te Abraham, me Aisak, me Jekop, te bagego God dao.” Mosesgo te po odolama, aga gesabi halua sali, magi basowe, agai te God subo wi ebaso, tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Tama Genuai Bidigo aga dali te po wali, “Eno suali, augwaligo eno we bidi Isip bulude mu dolobao. Tama eno we bidi augwali ena i wabo sę ebao, te augwali dwai tonalubo bidigo nogode ma somainogo yai. Eno te i wabo odoyu, tama eno mu koneani, te augwali dene me te sęgę mu sabo dao. ");
INSERT INTO mps_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tama ena dulai dao, tama te augwali te Isip dabego nogode ma selama, tama augwali te genuai tǫ me deli te tǫ ili hauwa elalubo, te nai bugagia dwagi yai mu holobo tǫba odasa paibao. Te tǫde megi te Kenan bidi hani me, te Hit hani me, te Amor hani me, te Peres, me Hivi, me Jebus, te tama hani augwali te tǫde megi bidibo dao. ");
INSERT INTO mps_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mu tama, eno te Israel hani we bidigo gela odolama, eno suali, te Isip dabe augwaligo dwai kolesaga mu augwali dali ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tama megi eno nage te Isip tuni bidi bidibo digi tagala palama, te tuni bidigo nage sula tagalama, te nago eno we bidi Israel hani augwali te Isip bulu tagalama asomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Tiali goli, Mosesgo Godibolo te po wali, “Ena magi yai bidi, tama ena te Isip tuni bidiba pobaso da, eno te Israel we bidi te Isip bulu tagalama, odasa asobo usu egowe?” ");
INSERT INTO mps_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Tama Godigo te po wali, “Ena nage dali bidibao. Tama megi eno magi nai me deli nagebolo waselama ola mayu, tama nago kuna koneagameo, te ena digi eno nage te Israel we bidi augwalibolo tagala palobao. Te ola mabo sę e tama dao: te nago te we bidi Isip tǫ tagalama, odasa aselama, tama dagego enabolo e bulu dude digi lotu po waibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Tama Mosesgo Godibolo te po wai, “Ena te Israel we bidi augwali bidibo teba pedalobo sogo, te augwalibolo eno te tiwai po waibao, ‘Dago wąį augwaligo Godigo ena tagala palobaso, ena dage bidibo digi asai.’ Tama augwaligo enabolo hanalubaso da, ‘Te aga nogi de dawe?’ obaso da, teda eno mena nogi wabogo augwali dali wei ponogowe?” ");
INSERT INTO mps_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Tama Godigo te po wali, “Ena Digi Ena Tama Bidibo Dao. Nago te Israel we bidi dali te po wao, ‘Ena Digi Bidibo, te Godigo nogi dao. Tama agai ena tagala palobaso, tama ena dage bidiboba asai.’ ");
INSERT INTO mps_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nago tama po te Israel we bidi dali weyu, te Yawe Genuai Bidi, aga te dagego wąį dabe augwaligo God, te Abraham, me Aisak, me Jekop, te agai nage tagala palama, tama nage augwali bidibo digi asai dao po wao.” Tama Godigo po Moses dali ma wali, “Eno nogi Genuai Bidi, te eno nogi sesemane bidada pabo sogo, tama nosali pedalobo wąį dabe augwaligo ena nogi tama nogi yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Nage pelama, te Israel tobolu bidi dabe augwali sisinama, te God po augwalibolo wao, ‘Te dagego wąįgo Genuai Bidi, Abraham, me Aisak, me Jekop, te bagego God enaba mu pedelama, dagebolo wabo po ena dali tama wai dao, “Eno suali, te Isip hani augwaligo tigidali dwai kolesaga mu dage dali ebaso, tama eno homu hauwa dage dali ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tama eno te po wali, te eno dage Isip tǫde selama, te bulu bidi dabego dwai sę mu dagebolo ebaso, tama eno dage te Kenan bagego tǫ, me te Hit hani, me te Amor me, Peres me, te Hivi, me Jebus, te hanigo tǫba eno dage odasa painogo ebao. Te dwagi yai tǫ, te ili hauwa elalubo tǫ dao.” ’ ");
INSERT INTO mps_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Nago te tama po augwali dali weyu da, te augwaligo nago po odolama, wali paibao. Tama nago te Israel bage tobolu bidi dabe selama, tama dage te Isip tuni bidi bidibo teba pelama, agabolo te po wao, ‘Genuai Bidi Yawe aga te da Hibru bagego God dao, te aga da dali deliba sisinai dao. Tama dago nagebolo hanalu wagasali, te nago usu da obaso, te da te bidi meni yai buluba pelama, sela sogo dago Godibolo te ofa igi painogo obao, te dago Genuai Bidi dao,’ tama po wao. ");
INSERT INTO mps_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Eno koneani, te eno bomo yai nogogo aga dali bomai sę esiąyu da, teda te Isip tuni bidigo dage tagala paliyu pao, te po hasia bolo wagobeo. Tiali goli, agai dage tagala palomainogo, eno bomo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tama tibaso, eno bidigo isiąwai bomo yai sę haniani te Isip hani augwaligo tǫde eyu, tama eno bomogo te sę augwali dali yaibao. Tama te bomo yai sę dabe elama, nosali te Isip tuni bidi agai dage pomainao, te po waibao.” ");
INSERT INTO mps_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Eno tama ilama, tama te Isip we bidi augwaligo dage dali dwagi yai homu yaibao, tama dagego te Isip tǫ taga soainogo ebode, te dage olo me pogobeo. Menio. ");
INSERT INTO mps_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Dagego we tigidali te Isip we dabe augwali bidibo pąba pelama, me te Isip we dabe dagego bede bidibo, tama dagego we dabe sibigo te Isip we dabe sibi hanaluyu, tama te ugwa, me te meba gasa au ebo doado bage gol me silva tama, te nai dabe augwaligo dage mawaibao. Tama dagego te nai duga wai dabe tigide muaibao. Tama dagego te tebo kolesagade te Isip dabego doado bage tigidali siyu, selasa paibao,” Godigo Mosesbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Tama tialima, Mosesgo Genuai Bidi dali te po wai, “Te Israel hani augwaligo eno wabo po homude dąų wasiąma, tama eno pusubo po te augwali odogobeo. Tama augwaligo te po weyu, ‘Nago tibo po naga obao,’ waibao. ‘Tama Genuai Bidi nageba pedalobeo,’ te po waibao. Te augwaligo tama weyu da, teda eno magi sę egowe?” ");
INSERT INTO mps_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Tama Genuai Bidigo Moses dali hanalu wai, “Nago magi nai tolalubawe?” Tama agai te po wai, “Tolasa bilibo dono tolalubo,” po wai. ");
INSERT INTO mps_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Tama Genuai Bidigo te po wai, “Te dono tǫba sąyao.” Tama Mosesgo te dono tǫba sąbadi, te hasamani gagawai, tama Mosesgo te hasamani sulama, wi pai. ");
INSERT INTO mps_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Tiali goli, Genuai Bidigo Mosesbolo te po wali, “Tagalama, nago nogo aiyaba munama, te danu nogogo touao.” Tama Mosesgo te hasamani nogogo danude touwai, tama te hasamani hasegelama, tama te bilibo dono ma pedelai. ");
INSERT INTO mps_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Tama Genuai Bidigo te po wai, “Nage te Israel bageba pabo sogode nago tama tiao, tama augwaligo nago e sę tiwai ebo sulama, nago po homude dąų weyu, mu tama Genuai Bidi ena nageba pedelali da, te homu emainogo nago tama tiao. Tama augwaligo koneyu, te ena augwa wąį dabego God da, ena te bidi Abraham, me Aisak, me Jekop, te bagego God ena nageba pedelai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Genuai Bidigo Moses dali te po ma wai, “Nago nogo naga ugwa tomoba muao.” Agai te Genuai Bidigo wali po gilama tama tiai, tama agai nogo me teda sai, tama te nogode keni dwai mu, tama te keni tigidali tedela yai. ");
INSERT INTO mps_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Tama Genuai Bidigo te po ma wai, “Nago nogo naga ugwa tomoba ma muao.” Te agai tama tiali, tama agai nogo ma teda sali, tama te nogo wiegi yai yali, te aga tigi me badu elalubo tiwai yai. ");
INSERT INTO mps_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Tama Genuai Bidigo te po wai, “Te augwaligo homude nago po dąų olama musiąbaso da, te nago hasia ebo bomo yai sę yali augwaligo homu teba dąų wasiąbaso da, te gasa bomo yai sę si nago ebo te augwaligo sulama, tama augwaligo homu nageba muaibao. ");
INSERT INTO mps_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Tiali goli, augwaligo te bomo yai sę si ebo sulama, tama augwaligo nago po homuba dąų wasiąbaso da, teda nago te genuai wę Nail meba selama, te tǫba gelao. Tama te wę hasegelama, kaneme pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Tama Mosesgo Genuai Bidi dali te po wai, “Tama Genuai Bidi, tiali goli polobadu bidi hauwa gedude eno po bugagia wai menio. Tama megi nago ena dali po wali, tialima tego ena te po wabo bidi tiwai egobeo. Eno pedauwali sęgę mu yai, tama eno po bugagia wainogo ebo, te usu egobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Tama Genuai Bidigo agabolo te po wali, “Niwai bidigo te we bidibolo po wabo pedauwali te mabo dawe? Niwai bidigo te bidi odo dega weyu, te pedauwali paliyu ebo dawe? Tama dego te gedugo tonono bilimainogo eyu, ma te gedu widao po wabo dawe? Ena, Genuai Bidigo naga, eno tama tiwai kolesaga ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Megi da, nage pao. Te nago wabo po tigidali te eno tau siyu, tama te nago wabo po nagebolo ola mayu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Tiali goli Mosesgo te po wai, “Genuai Bidi, eno usugobeo. Nago gasa bidi tagala palao.” ");
INSERT INTO mps_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tama Genuai Bidigo Moses dali wado po weyu, te po wai, “Magi basowe? Nago ama genuai bidi Aron te Livai hani bidibao. Eno koneani, te aga da, te po bugagia wabo bidi mu dao. Tama megi naga tama agai nage tiąba asobao, agai nage suyu, wiegi yai homu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nago agabolo te po olama, tama agai te po tigidali pusumainao. Tama eno dage sigo pedauwali tau siyu, tama dage sigo eno po bugagia naga waibao. Tama magi sę dage sigo yainogo ebaso, te sę yao po eno waibao. ");
INSERT INTO mps_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aga te nago pedauwalide po selama, te nago po te we bidibolo mawaibao. Tama agai gedude te nage te God tiwai bidiyu, te nago wabo po agai te we bidibolo pusaibao. ");
INSERT INTO mps_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tama megi da, nago te bilibo dono selama, tama nage pao. Tama nosali nago te donode te bidigo isiąwai bomai sę meba yaibao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mosesgo po God dali ola silama, tama aga te aga wąį Jetro bidibo teba ma pelama, tama agabolo te po wai, “Eno homugo nago ena te Isip tǫba ma pelama, te eno deli hani sugi painogo ebo, te nago ena pao po wabo te usu da wao. Eno koneama, augwali bidibowe, ma augwali isaliwe, te eno augwali sugi peyu pobao,” wali. Jetro agai te usu da po aga dali wai, “Te usu da, nage pao.” ");
INSERT INTO mps_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Tialima, Moses aga pisąbadi, tama Genuai Bidigo agabolo te po wai, “Megi nage te Isip tǫba ma pao, te nage elainogo yali bidi dabe, augwa digi isai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tama Moses agai te po wabo odolama, te aga we dali te aga wai si augwali te kibu donki me deliba muai. Tama agai te Godigo dono me selama, tama augwali Isip tǫba ma pabo gagalali. ");
INSERT INTO mps_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tama Genuai Bidigo Moses dali te po wai, “Nosali nage Isip tǫba pedalobode, te nago te bomai sę te Isip tuni bidi gedude yao. Eno nagebolo te bomai sę yabo bomo mobao. Tiali goli, eno te tuni bidide ilama, tama aga te aga homuba masigi sąwai bidi pedelaibao. Tama tibaso, agai te we bidi dabe augwali pao wagobeo. ");
INSERT INTO mps_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nosali nago tuni bidi dali eno po weyu, ‘Te Genuai Bidi agai tiwai po wabo dao, “Israel hani te eno hasia wai, te gomunai ogwa tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Tama eno nagebolo te po wai, ‘Nago te wai tagala palama, enabolo lotu po omainao.’ Tiali goli, nago hagela homu eyu da, te nago hasia wai te ogwa eno ela muaibao,” Genuai Bidigo te po wai,’ nago te po te Isip polasa tuni bidibolo wao.” ");
INSERT INTO mps_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Te Moses te Isip tǫba pabo tųde pibadi, tama te toma nabo pesage tede Moses aga gasi selama, tama te gasigo aga ela muainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Tama Sipora, te Mosesgo wego, te poa pai masigi selama, tama aga wai te ogwa te gasa tigiwali togolama, Moses sągąba muai. Tama agai te po wai, “Nage eno bidi dao, tiali goli nage kaneme tama sabo bidi dao.” ");
INSERT INTO mps_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tama Genuai Bidigo sulama tagaliyu, tama Moses bidimainogo yai, tama agai aga ela mubeo. Te we Siporago te dąį ilibo tigiwali togwabo kolesaga tede hagela homu eyu, tama agai te po wai, “Kaneme sabo bidi dao.” ");
INSERT INTO mps_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Tama Genuai Bidigo Aronbolo te po wai, “Nage te masigi sane yai buluba pelama, Moses dali tede sisinaibao.” Tialima, aga pelama, Moses te Godigo bulu dude sisinama, gesabidi suyu, tama dwagi yai homu eyu, augwa si gesabidide nono nai. ");
INSERT INTO mps_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Tama Mosesgo Aronbolo te Genuai Bidigo agabolo wali po tigidali wai, te Genuai Bidigo aga tagala paliyu wali, te po wai. Tama Mosesgo Aronbolo te Genuai Bidigo agabolo te bidigo isiąwai bomai sę yabo po wali, te po me Aron dali wai. ");
INSERT INTO mps_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Tama nosali Moses de Aron augwali si te Isip tǫba pelama, tama augwali sigo te Israel tobolu bidi dabe deliba sisinai. ");
INSERT INTO mps_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Tama Arongo te Genuai Bidigo Mosesbolo wali po tigidali augwalibolo te po wai, tama te Israel hani olo we bidi dabe me deliba sisinama, tama agai te bidigo isiąwai bomai sę te we bidi augwali gedude yai. ");
INSERT INTO mps_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Tama tibaso, augwaligo homu Aronba mu dąų wai. Augwaligo te po tiwai wabo odali, Genuai Bidigo suali, te Isip hani augwaligo te Israel hani dali dwai kolesaga ebaso, agai homu hauwa augwalide ebo dao. Tama te we bidi dabe augwaligo te po odolama, tama augwa tobolu tǫba aiyaba munama, Genuai Bidibolo lotu po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Tama nosali Moses de Aron si te Isip polasa tuni bidi bidibo teba pelama, tama te po wai, “Da Israel bagego Genuai Bidi Yawe Godigo te po wai, ‘Eno hani augwali te bidi meni yai bulu, te masigi saneba pelama, enabolo te genuai lotu po weyu, ena nogi ugwaba somainogo, augwali pomainao,’ wali.” ");
INSERT INTO mps_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tiali goli te tuni bidigo te po wai, “Genuai Bidi Yawe de dawe? Magi baso eno agai po odolama, te dage Israel hani pomainogo yaibawe? Eno te Genuai Bidi Yawe konebeo, tama tiyu, eno dage pagameo te po wagobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tama augwali sigo te po wali, “Da Hibru bagego God te da si bidibo digi pedelai dao. Da te masigi sane yai buluba sela sogo bidigi painogo homu yai, tama dago Godibolo te ofa mawainogo, te dago Genuai Bidi dao. Tama nago da pao wabo te usu yaibawe? Te dago tama tisąwani da, te agai da genuai gasigo, me te hwįbo sogode, te da mu dolaibao.” ");
INSERT INTO mps_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Tama te Isip tuni bidigo Moses de Aron si dali te po wai, “Magi baso dage sigo eno sę ebo te we bidigo tagalomainogo te po obawe? Dage si sęba polo ma pao. ");
INSERT INTO mps_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Dage Israel hani hauwa mu pedaliyu, tama da bulu page bidi aiyaba elaluai, tama megi dagego te sę ebo taga painogo obawe?” ");
INSERT INTO mps_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tama te sogo naga te tuni bidigo po me deli te Isip bage dali, te Israel augwa digi te Israel sę ebo bidi tonalubo bidi augwali dali te po wai. Agai te po wai, ");
INSERT INTO mps_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Dagego te wa pai nosa te Israel hanigo te be sę yabo dila pai nai brik nigimainogo magio, te dagego tebo dao. Augwa digi te nosa dabe sigi pomainao. ");
INSERT INTO mps_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Tiali goli, augwaligo te sesemane sogo te nigibo tiwai brik naga augwaligo nigimainao. Dagego te namba te pęwadage iligio. Mu menio. Augwali sę hagela ebo we bidi dao. Tama tibaso, augwaligo te po wai, ‘Da pelama, dago Godibolo ofa igi pomainogo emainao.’ ");
INSERT INTO mps_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Augwalibolo sę hauwa menama, tama augwali sę dene mu yao, tama augwaligo te tiwai tibo po wabo odabo sogo te meni yaibao,” te Isip tuni bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Tama te Isip sę tonalubo tobolu bidi dabe, me te Israel sę tonalubo bidi dabe me, augwali te Israel haniba pelama, augwali dali te po wai, “Tuni bidigo te po wai, dago nosa dabe dagebolo sela magasigio wai. ");
INSERT INTO mps_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Duga digi pelama, tama te nosa gegegi pao wai, tama dagego te mama tǫgo nigibo nai brik te polobadu nigali tiwai hauwa nigao, tama te nigibo brik namba te aiyaba me dulugio. Te namba te polobadu elaluali tiwai naga tama elalumainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tama te Israel we bidi augwali te tigidali Isip teba tedela pelama, te nosa dabe tigidali sisinai. ");
INSERT INTO mps_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tama te sę tonalubo bidi dabego sę polo yao weyu, augwaligo te po wai, “Dagego deli sę tiwai naga tigidali sogo eyu, te dago nosa dagebolo mobadi yali sę tiwai sę yao.” ");
INSERT INTO mps_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tama te Isip sę tonalubo bidi dabe augwali te Israel augwa digi te sę tonalubo bidi nigilali, te bidi pageba pai. Tama augwaligo te bidi dabe augwali eliyu, te po wai, “Magi baso dagego te brik namba te polobadu nigali tiwai nigibewe?” ");
INSERT INTO mps_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Tama tibaso, te Israel sę tonalubo bidi dabe augwali te Isip tuni bidi bidibo teba pelama, aga dali te po wai, “Magi baso nago te tiwai kolesaga da dali ebawe? ");
INSERT INTO mps_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Augwaligo nosa dabolo magasobeo, tiali goli augwaligo dabolo te brik nigao te po wedu gebo dao. Tama megi me augwaligo da elai. Te brik namba sǫą pali kolesaga page dago menio. Te kolesaga te Isip bage duga digi te sę yai dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tama te polasa tuni bidigo augwalibolo te po wai, “Dage sę hagela ebo bidi dabe mu dao. Tama tiyu, dagego te po wai, ‘Dago dena Genuai Bidibolo ofa magi pobaso, te dagego da sula tagalao,’ te po wedu gebo dao. ");
INSERT INTO mps_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Woo! Dage duga sęba ma pao. Augwaligo nosa dagebolo magasogobeo. Tiali goli, dagego te brik namba augwaligo dagebolo po weyu, te nigao,” te polasa tuni bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Tama te Israel sę tonalubo bidi dabe augwaligo te tuni bidigo wabo po odolama, augwaligo te brik namba pęwadage ilisiąyu, tama augwaligo koneani, megi genuai sęgę augwaliba pedelali, te homu yai. ");
INSERT INTO mps_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tama augwaligo te tuni bidi taga sobadi, te sogo augwaligo te Moses de Aron si gesabidi suai. Augwali sigo augwali te be bulu badu asobo tonaluai. ");
INSERT INTO mps_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Tama augwaligo te bidi si dali te po wai, “Dena homugo te Genuai Bidi Yawego dage sigo kolesaga osola suao, tama Genuai Bidi agai dage sibolo dene mawaibao, magi basowe, dage sigo te tuni bidi dali, te aga tobolu bidi dabe dali, augwaligo da te dwai nai tiwai mu, te homu ebo dage sigo ilalio. Te tuni bidigo da elemainogo dage sigo tų nigibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tama Moses ma pelama, tama Genuai Bidibolo te po wai, “Genuai Bidi, magi baso nago naga we bidi hanibolo te dene maniwe? Tama magi baso nago ena eba tagala palai dawe? ");
INSERT INTO mps_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Te nago po eno te tuni bidibolo wagi pali, tede gagalama dąį megi tama, agai dwai sę augwali Israel we bidi dali ebao. Tama nago augwali tau selama, magi sę me deli ebeo,” Mosesgo Godibolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Tama Genuai Bidi Yawego Moses dali te po wai, “Megi nago eno te tuni bidi dali ebo sę suaibao. Te eno bomogo yaibao, tama tibaso agai te dage Israel hani gasaba tagala palaibao. Mu tama, te eno aga selebo sę eyu, aga mu doloyu, tama agai dage agai tǫde bidibo sela sąnama, tama dage paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Godigo Mosesbolo te po wai, “Ena digi ena te Genuai Bidi Yawe dao. ");
INSERT INTO mps_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Polobadu kibu be hauwa ena te Abraham, Aisak, Jekop, te bageba pedelali, te augwaligo koneai, ena te Tigidali Bomo Elalubo God dao. Tiali goli, eno te tama po augwali dali wabe, Genuai Bidi Yawe te eno nogi da, te po wagi sogo da, teda te nogi page augwaligo konegi dao. ");
INSERT INTO mps_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tama eno bomo yai po augwali dali dąų weyu, te tǫ Kenan augwali mawaibao, te po wai. Augwali te bulude te tǫ page bidi hani bidisiąwai goli, eno te tǫ augwalibolo mabo homu yai. ");
INSERT INTO mps_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Te me elalubo, te Isip bidi dabe augwaligo te Israel hani kalabus sę ebo tiwai sę menama yai, tama te Israel hani augwali moni gela wai. Tama megi augwali gela wabo eno odai, tama eno homugo polobadu eno te bomo yai po dąų wali, te eno ma koneai.” ");
INSERT INTO mps_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Tama tibaso, nago te po Israel hani dali wao, ‘God agai te po wai, “Ena digi ena Genuai Bidi Yawe dao. Eno dage te Isip hanigo nogode selama, tama te augwaligo sęgę dagebolo mabo tede me eno selama, tama dage olo mu bidimainogo yaibao. Tama eno bomogo augwali dene mu somainogo menama, tama dage eno genuai bomogo dobola ma saibao. ");
INSERT INTO mps_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Te dage selama, tama dage ena we bidi mu pedelama, tama ena te dagego God bidaibao. Nosali dage te Isip bagego kalabus sęde bidali tagalama, tama dage olo mu bidaibao. Tama te sogo dagego mu koneyu, ena te Genuai Bidi da weyu, tama ena dagego God da, te homu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Eno dage te tǫ Abraham, Aisak, Jekop, augwali dali bomo yai po dąų weyu, te tǫ mawaibao wai. Tama te tǫ eno dagebolo menama, tama te dagego tǫ mu elaluaibao. Ena da, te Genuai Bidi Yawe dao,” God agai te po wai,’ nago te po augwalibolo pusao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Tama Mosesgo te po Israel hani dali wai, tiali goli augwaligo agai po odobeo. Magi basowe, te sę dene yaligo augwali homu aiyaba mu tula palai. ");
INSERT INTO mps_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Nosali Genuai Bidigo Moses dali te po wai, ");
INSERT INTO mps_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Nage pelama, te Isip tuni bidibolo te po wagi pelama, te Israel hanigo agai tǫ mu taga pomainao, te po omainao.” ");
INSERT INTO mps_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Tiali goli, Mosesgo te po wei ponoyu, te po wai, “Te Israel hani augwaligo eno po odobo menio. Tama tuni bidigo eno po mena tama odogowe? Eno pedauwali sęgę ebao. Eno po te tuni bidi dali bugagia dolo wainogo ebo te usu egobeo.” ");
INSERT INTO mps_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tialima, Genuai Bidigo Moses de Aron si te Israel hani bidibo, teba me, te Isip tuni bidi bidibo digi me, te tagala palali, augwali sigo te Israel hani te Isip tǫ tagalama, augwali odasa asomainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Te bidi hani augwali te Moses de Aron sigo hasia wąį dabe te bidi hani nogi e dao. Ruben, te Jekopgo gomunai ogwago wai dabe nogi e dao. Te ogwa me si me si, me nogi Hanok, me Palu, me Hesron, me Karmi. Te Rubengo hani me si me si te hani me si me wąį si tomode te Ruben pedelai. ");
INSERT INTO mps_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon, te Jekopgo tomo ogwa, agai wai ogwa te a naga olama me badu nogo deli, gomunai ogwa Jemuel, me Jamin, me Ohat, me Jakin, me Sohar, me Saul. Saul aga ida te Kenan we me deli dao. Simeongo hani a naga me badu nogo deli, te hani tomode Simeon aga wąį pedelai. ");
INSERT INTO mps_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Livai, te Jekopgo ogwa me, agai wai ogwa sela, gomunai ogwa Gerson, me tomo ogwa Kohat, sabi ogwa Merari. Tama Livai agai kibu be 137 bidilama, isai. ");
INSERT INTO mps_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersongo ogwa si ame nai, me ogwa Lipni, me Simei. Te ogwa si wąį te Livaigo hani tomode elaluai. ");
INSERT INTO mps_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat agai wai ogwa me si me si, Amram, Ishar, Hebron, Usiel. Tama Kohat kibu be 133 bidilama, isai. ");
INSERT INTO mps_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merarigo wai si, Mali me Musi. Te bidi hani tigidali augwali te Livaigo wai hani augwali dao. ");
INSERT INTO mps_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram agai we Jokebet sai, te aga ayago amago wegi, tama Jokebetgo Aron de Moses si ame nai. Tama Amram kibu be 137 bidilama, isai dao. ");
INSERT INTO mps_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ishargo wai sela, Kora, me Nefek, me Sikri. ");
INSERT INTO mps_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiel agai wai sela, Misael, me Elsafan, me Sitri. ");
INSERT INTO mps_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arongo we Eliseba sai, te Aminadapgo wegi, te Nason aga abe dao. Tama Elisebago wai me si me si ame nai, Nadap, Abihu, Eleasar, me Itamar. ");
INSERT INTO mps_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korago ogwa sela, gomunai ogwa Asir, me Elkana, me Abiasap. Te bage sela augwaligo hani wąį Kora dao. ");
INSERT INTO mps_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasar te Arongo ogwa, agai te Putiel te bidigo wegi selama, agai wai te Finias ame nai. Te megi nogi nogi yali bidi hani augwali da te Livai hani sibi deli deli augwaligo tobolu bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Nago te bidi hani augwali tomode te Aron de Moses si nogi elalubo suai. Genuai Bidigo te bidi sibolo naga po weyu, te po wai, “Dage sigo te Israel hani dabe augwali te Isip tǫde bidibo tagalama, augwali odasa asao,” te po Genuai Bidigo augwali si dali wai. ");
INSERT INTO mps_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Te bidi augwa sigo digi te Isip tuni bidi dali, te Israel hani tagala palaibao, te po wai. Tama te bidi sigo naga te sę yai. ");
INSERT INTO mps_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Genuai Bidigo Moses dali Isipde po wali sogo, agai te po wai, “Ena digi ena te Genuai Bidi dao. Tigidali po eno nagebolo mabo, te po nago Isip tuni bidi dali wao.” ");
INSERT INTO mps_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Tialima, Mosesgo Genuai Bidi dali te po wai, “Nago koneani, ena po wabo bidi menio. Tuni bidigo eno po odogobeo.” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Tama tialima, Genuai Bidigo Moses dali te po wali, “Odao, eno nage te God tiwai te tuni bidigo gedude nigiliyu, tama nago ama Aron, te nagede po sabo bidi tiwai nigilama, tama nago po agai te tuni bidibolo waibao. ");
INSERT INTO mps_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tigidali nai po eno nagebolo wali, te po nago Aron dali wao. Tama agai te po te tuni bidi dali weyu, te agai te Israel hanigo te tuni bidigo tǫ tagalama, pomainao po waibao. ");
INSERT INTO mps_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Tiali goli, eno te tuni bidide iliyu, tama aga homu tomoba masigi sąwai bidi pedelaibao, tama agai te Arongo po odogobeo. Tama tibaso, eno genuai bomai sę hauwa te Isip tǫde yaibao. ");
INSERT INTO mps_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Tiali goli, te tobage bomai sę ebadi digi, tama te tuni bidi agai nago po odogobeo. Tama tibaso, eno te Isip tǫ dolama, augwali dene mu somainogo tiaibao. Tama ena polasa peyu, te Israel hani sibi dabe odasa peyu, augwali te eno we bidi hani, tama augwaligo te Isip tǫ mu taga paibao. ");
INSERT INTO mps_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Tama eno te Isip hani dali haniani dwai dene mabo, te sogo tama Israel hani odasa peyu, te Isip tǫ taga paibao, tama te sogo Isip hanigo koneyu, te Genuai Bidi Yawe aga digi te Israel hani odasa pabo homu emainogo tama tiwai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Tama nosali Moses de Aron augwali sigo te Genuai Bidigo wali po wali pelama, te sę tigidali yai. ");
INSERT INTO mps_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Te sogo Mosesgo kibu be 80 elalubadi, tama Arongo kibu be 83 elalubadi, augwali sigo te sogo te Isip tuni bidi po miai. ");
INSERT INTO mps_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Genuai Bidigo Moses de Aron si dali e tama wai, ");
INSERT INTO mps_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Tuni bidigo dage sibolo te bomai sę meba agai suainogo, te sę yao po wabo si da, te eno dage si tagala palobao, tama Moses nago Aronbolo agai te bilibo dono selama, te tuni bidigo gedude tǫba sąyao. Tama te dono hasamani gagalama pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tama tibaso, Moses de Aron augwali si te Genuai Bidigo po wali pelama, te tuni bidi bidibo digi pai. Tama Arongo dono te tuni bidigo gedude, me te aga sę ebo bidi dabe gedude, Mosesgo dono tǫba sąwai, tama te dono hasamani pedelai. ");
INSERT INTO mps_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tuni bidigo te tebo sulama, tama agai te tigidali po page koneai bidi dabe, me te haniani pobi wabo bidi dabe i olama, augwaligo me te pobi po olama, tama Arongo ebo kolesaga tiwai augwaligo me yai. ");
INSERT INTO mps_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Augwaligo me augwa dono sąbadi, tama hasamani gagawai, tiali goli Arongo hasamanigo augwaligo hasamani elama tuyu dalai. ");
INSERT INTO mps_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Tiali goli, tuni bidi aga homu kolesaga dąų ola sali, te Genuai Bidigo po wali gilama tama tiwai, tama Moses de Aron augwali sigo po odobeo. ");
INSERT INTO mps_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Tama Genuai Bidigo Mosesbolo te po wai, “Tuni bidi agai kolesaga te doyu, mu gagea pai eyu, tama agai te Israel hani pomainao te po wagobeo. ");
INSERT INTO mps_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tama kigamu aga te ąį Nail tede nago aga gesabidi deliba sisinama sueibao. Tama nago te hasamani pedelali dono selama, aga te ąį sesegeba tonalugi pao. ");
INSERT INTO mps_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tama nago tuni bidi dali te po wao, ‘God, da Hibru hanigo Genuai Bidi, agai ena tagala palali, nage te po omainogo, te agai we bidi te bidi meni yai buluba lotu po wagi pomainogo nago augwali tagala palao, te po wagasai. Tiali goli, megi nago te po odao. ");
INSERT INTO mps_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tama megi Genuai Bidigo te po wai, “Nago eno ebo sę sulama, tama nago koneyu, ena digi ena te Genuai Bidi Yawe da, te po nago waibao,” Godigo te po nagebolo obao. Suao, eno donogo te ąįba elebode te ąį kaneme pedelaibao. ");
INSERT INTO mps_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tama te sųgų dabe isilama, dwai kugumini mu yaibao. Tama Isip we bidi augwaligo te ąį tubo usugobeo,’ te po agabolo wao,” Godigo te po Mosesbolo wali. ");
INSERT INTO mps_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Tama Genuai Bidigo Mosesbolo te po ma naga weyu, te po wai, “Aronbolo agai dono sao te po olama, tama agai te donogo te genuai ąį, me te tigidali ąį gamia, me te tigidali Isip tǫde elalubo sigi ąį tigidali nago te donogo sa muao. Tama te wę dabe kaneme pedelaibao, tama tigidali Isip te badu te pede poude kaneme naga elaluyu, augwaligo te kaneme ni namego me te botolgo te masigigo nigai me, te kaneme pedelaibao,” Genuai Bidigo Mosesbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tama Moses de Aron sigo te Genuai Bidigo augwa si dali wali po wali pelama, te sę yai. Tama te tuni bidi dali, aga sę ebo bage meba dali, augwaligo gedude Arongo dono selama, te Nail moni pabo ąįba elali, tama te ąį tigidali kaneme pedelai. ");
INSERT INTO mps_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tama te Nail ąįde elalubo tigidali sųgų isilama, dwai kugumini mu te ąįde yai. Tama te Isip we bidi augwaligo te wę tuabo usu egobeo. Tama kaneme te Isip tǫ tigidalide elaluai. ");
INSERT INTO mps_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Tama te kolesaga page osola subo Isip bidi dabe, augwaligo pobigo te Arongo ebo kolesaga tiwai yai. Tama tuni bidigo augwali sigo po odobe. Menio. Agai kolesaga gagea pai me elaluai, te Genuai Bidigo tama tiaibao te po wai. ");
INSERT INTO mps_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Tama tuni bidi aga beba ma pelama, te sogo yali sęde me agai homu midigi siyu hodalobeo. ");
INSERT INTO mps_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tama te Isip hani augwaligo te ąį tuabo usu ebeo, tibaso augwaligo te wę sesegede dedage nigai, te tuabo wę tede sainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Tama te wę Nail dwai elalubadi, te a naga olama, me badu nogo si sogo tama bidai. ");
INSERT INTO mps_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Tama nosali Genuai Bidigo Moses dali te po wai, “Nage tuni bidi pageba pelama, aga dali eno te po wao. ‘Genuai Bidi Yawe agai te po wai, “Eno we bidi augwali enaba lotu po wagasiyu asomainogo, augwali sula tagalao. ");
INSERT INTO mps_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Nago augwali tagala palisiąbaso da, teda eno te gedeli dabe augwali tagala palama, augwali te dagego be tomoba aselama, tama nago tǫde bidibo we bidi augwali dolaibao. ");
INSERT INTO mps_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Tama te wę Nail te gedeligo mu pągąna selama, tama augwali te wę tagalama, tama tuni bidi nago genuai be tomoba aselama, tama nago pibo be tų bet saiba asaibao. Tama te gedeli dabe te nago sę ebo bidi dabego be tomoba, me te nago we bidigo beba asaibao. Tama te nai ulubo nai stov tomoba, me te bret nigibo pou tomoba bidagasaibao. ");
INSERT INTO mps_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tama te gedeli dabe augwali posoga palama, nago tigi daiba duayagasu, te nago sę ebo bidi dabeba, me te nago we bidi augwali tigiba duayagasaibao,” Genuai Bidi Yawego te po wai.’ Te po wao,” Genuai Bidigo te po wai. Mosesgo te po tuni bidiba wagasai, tama te tuni bidigo agai po odobeo. ");
INSERT INTO mps_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Tama tibaso, Genuai Bidigo Moses dali te po wai, “Aronbolo po olama, te aga nogo dodolama, tama agai dono ugwaba selama, nogogo tuao, tama te wę dabe, me ąį gamia dabe, me te sigi ąį ge, tede te gedeli dabe pedelama, tama te Isip bidi dabego tǫ pągąna somainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tama Arongo nogo dodolama, tama dono ugwaba selama, tama te wę dabe dąį ilai. Tama te gedeli dabe pedelama, tama Isip bagego tǫ tigidali pągąna sai. ");
INSERT INTO mps_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tiali goli, tuni bidigo po page osola subo bidi dabe augwaligo pobigo me te gedeli ąįde bidali tagalama, hauwa te tǫba pai. ");
INSERT INTO mps_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tama tuni bidigo Moses de Aron si i olama, asobode augwali sibolo te po wai, “Dage sigo Genuai Bidibolo gedu haluasa po olama, agai te gedeli dabe da tigide bidibo sela sąmainao, tama eno nago we bidi pomainogo tagala paliyu, tama augwa Genuai Bidibolo ofa magi pomainogo yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Tama Mosesgo te tuni bidibolo po wei ponoyu, te po wali, “Te usu dao, eno gedu haluasa po nage tau siyu waibao. Naga digi te sogo bodolu mobaso, te eno gedu haluasa po nage tau siyu, te nago sę bidi dabe, me te nago we bidi dabe, augwali tau somainogo yaibao. Tama dagego bede bidibo gedeli dabe silama, tama te gedeli dabe augwali te wę Nailde naga bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Tama tuni bidigo te po wai, “Gedu haluasa po do wagameo.” Tama Mosesgo te po wali, “Te eno nago po wabo gilama tama tiaibao, tama nago koneyu, te God tiwai Genuai Bidi Yawe me deli meni yai, te aga dago God dao. ");
INSERT INTO mps_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Tama te gedeli dabego nage tagaliyu, te nago sę bidi dabe, me te nago we bidi dabe, augwali tagalama, tama augwali te wę Nailde naga bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Tama Moses de Aron sigo te tuni bidi tagalama, pai. Tama Mosesgo gedu haluasa po Genuai Bidibolo bomonama weyu, agai te tuni bidibolo tagala palali gedeli sela sąmainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Tama Genuai Bidigo Mosesgo hanalu wali pode tama tiwai, tama te bede bidali gedeli dabe, me obo tomode bidali, me te gide bidali, te tigidali gedeli isai. ");
INSERT INTO mps_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tama te Isip bidi dabe augwaligo te gedeli dabe deliba sisinama, pesage holai, tama te gedeli dabe damuyu, kugumini dwai mu pedelai. ");
INSERT INTO mps_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tama tuni bidi te gedeli dabe isali sulama, tama agai koneani, te dwai sogo silali. Tama tibaso, agai kolesaga ma doyu, gagea pai, te Genuai Bidigo agade po wali tiwai gilama tiwai, tama agai Moses de Aron sigo po odobeo. ");
INSERT INTO mps_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Nosali Genuai Bidigo po Mosesbolo ma weyu, te po wai, “Aronbolo te po olama, agai dono tǫba elama, tama tigidali Isip tǫ hogomugo te dina dabe pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tama augwali sigo tama tiwai. Arongo dono selama, tǫba elai, tama tigidali Isip tǫ hogomugo dina pedelama, tama te dina dabego te we bidi dabe, me te hasa dabe, augwali halua selama, tama augwali gąųgo kela tuai. ");
INSERT INTO mps_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tama te pobi page koneai Isip bidi dabe augwaligo te dina pedalomainogo pobi po wali, tiali goli augwaligo usu ebeo. Tama te dina dabego te hasa dabe augwali halua sai. ");
INSERT INTO mps_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tama te pobi po koneai bidi dabe augwaligo tuni bidi dali te po wai, “God aga digi te sę ebao.” Tiali goli, tuni bidigo kolesaga dolama gagea pai, te Genuai Bidigo po tama tiaibao wai, tama agai Moses de Aron sigo po wabo odobeo. ");
INSERT INTO mps_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Genuai Bidigo Moses dali te po wai, “Tama kigamu mu tuni bidi węba asaibao,” wai, “tama aga asobadi nago aga sulama, tama eno po agabolo wao, ‘Genuai Bidi Yawego te po wai, “Eno we bidi lotu po enabolo omainogo pomainao. ");
INSERT INTO mps_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nago augwali tagala palisiąyu da, teda eno te bolia hauwa nageba tagala paliyu, te nago sę bidi dabebolo, me te nago we bidiba me, te bolia tagala palaibao. Tama dagego be me, te dage bidibo tǫ me, te boliago pągąna saibao. ");
INSERT INTO mps_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Tiali goli, te bolia dabe pedalobo sogo te Gosen tǫ eno tonaluyu, te eno we bidi bidibo bulu, tama te bolia dabe augwali bidibo badu me pedelama bidigobeo. Te eno tama tebo sogo nago konemainogo te ena digi ena Genuai Bidi Yawe, eno te sę nago tǫde ebao. ");
INSERT INTO mps_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Eno te deli tigi tiwai sę eno we bidi dali ebo tiwai te nago we bidi dali tegobeo. Odao, te gasagi yai bomai sę te do pedelaibao,” Genuai Bidi Yawego te po wai,’ tuni bidi dali te po wao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tuni bidigo homu kolesaga hasegelebe, tama Genuai Bidi agai tama tiai, te agai po obadi, tama te genuai bolia hani hauwa te tuni bidigo genuai be tomoba asali, tama aga sę bidi dabego beba me asiyu, te Isip we bidi tigidaligo beba pai. Tama te boliago te Isip hani tigidali dolai. ");
INSERT INTO mps_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Tama tuni bidigo Moses de Aron si asa olama i wai, tama agai te po wai, “Dage pelama, duga Godibolo te Isip tǫ tomode naga ofa mao.” ");
INSERT INTO mps_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Tialima, Mosesgo te po wali, “Dago tama tiyu da, te dolo meni, magi basowe, Isip bage augwaligo te dago Genuai Bidi Godibolo ofa ebo hasa dabe sulama, tama augwaligo da dali dwai homu yaibao. Dago te hasa dabe elama ofa eyu da, te Isip bage augwaligo ofa isąwai nai, tama Isip bage augwaligo te tebo suyu, tama augwali sębę eyu, masigi sąnama, da ela muaibao. ");
INSERT INTO mps_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Da pelama, sela sogo te bidi meni yai tǫba dago Godibolo ofa igibu paibao, dago Genuai Bidi Yawe, agai te sę dabolo yao te po wai.” ");
INSERT INTO mps_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tama tuni bidigo te po wai, “Te usu da, eno dage te duga Godibolo ofa magi pomainogo tagala paliyu, te duga Genuai Bidi Yawebolo te bidi meni yai tǫba ofa igi pomainogo, tiali goli dage digibulu gana pelamo dao. Tama dagego ena me tau somainogo gedu haluasa po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Tama Mosesgo po wei ponoyu, te po wai, “Te eno nage taga pabo sogo te eno Genuai Bidibolo gedu haluasa po weyu, te do agai nago bede te bolia dabe sela sąyu, te nago sę bidigo bede me, te nago we bidi augwaligo bede me tiaibao. Tialima, nago tibo po da ma ola mayu, tama te we bidi augwali te augwa Genuai Bidibolo ofa magi pidali weyu, te tų nago ma paligio.” ");
INSERT INTO mps_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Tama Mosesgo te tuni bidi taga peyu, Genuai Bidibolo gedu haluasa po wagi pai. ");
INSERT INTO mps_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Tama Genuai Bidigo Mosesgo aga dali hanalu wali te sę yai. Tama tigidali bolia dabego te tuni bidi dali, te aga sę bidi me, te aga we bidi, augwali tagalama, tama te bolia me deli tede me bidibeo. ");
INSERT INTO mps_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Te bolia dabe pela silai, tiali goli te tuni bidi aga homu ma hasegelisiąyu, tama agai te Israel we bidi augwali tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Nosali Genuai Bidigo Mosesbolo te po wai, “Nage pelama, te tuni bidibolo te po agabolo wagi pao, ‘Da Hibru bagego God, Genuai Bidi Yawe, agai te po wai, “Eno we bidi augwaligo enaba lotu po omainogo augwali tagala palao. ");
INSERT INTO mps_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Nago augwali dąų weyu, tama augwali tagala palisiąbaso da, te eno nage dali, te naga hani dabe dali dene mayu, tama eno genuai gasi te nago tigidali kibu dabeba tagala paliyu, te hos dabe me, te bidi duabo donki dabe me, te kamel, me bulmakau, me sipsip, me meme, te tama bulu badu bidibo nai dabeba eno gasi tagala palaibao. ");
INSERT INTO mps_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Tialima, Genuai Bidi Yawe ena digi bugagia eno te Israel hanigo kibu dabe tonaluyu, tama augwaligo kibu dabe me deli isigobeo.” Genuai Bidi Yawego te po wai.’ Nago te po te tuni bidibolo wagi pao,” Genuai Bidigo te po Mosesbolo mawai. ");
INSERT INTO mps_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Tama Genuai Bidigo te sę yabo sogo bodolu mayu, tama te po wali, “Do eno te sę yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tama tuni bidigo homu kolesaga hasegelebe, tama Genuai Bidi agai te po wali sę yali, tama Isip bagego bulu badu bidali kibu dabe tigidali isai. Tiali goli, Israel hanigo kibu dabe tigidali te bugagia bidali, tama me deli isibeo. ");
INSERT INTO mps_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Tama tuni bidigo aga hani dali hanalu wali, “Te Israel bagego kibu dabe te bugagia bidibowe?” Tama te bidi mebago agabolo te po wai, “Awe. Tigidali bugagia bidibao. Me deli munu me isibeo.” Tiali goli, te tuni bidi homu kolesaga dwai me elaluyu, tama te we bidi augwali me tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Tama Genuai Bidigo Moses de Aron si dali te po wali, “Dage si te brik ulubo be me deliba pelama, tama te sia keli meba selama, tama tuni bidi bidibo digi pao. Dage si te tuni bidi bidiboba sabolama, tama Moses nago te keli ugwaba sąyao. ");
INSERT INTO mps_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Tama te keli hogomu pedelama, tama Isip tǫ tigidali usu naibao. Tama te keli hogomu bidi tigiba me, te kibu dabe tigiba me tulalubode, te dili keni tiwai pedelama, tama genuai keni pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tama augwaligo te keli selama, pelama, te tuni bidi geduba doligi pali, tama Mosesgo te keli ugwaba sąwai. Tama te keligo te dili keni tiwai pedelali, tama te dili keni dabe ulu elama, tama keni te we bidi tigide, me te kibu dabe tigide pedelai. ");
INSERT INTO mps_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tama te pobi page koneai bidi dabe augwaligo te Moses ebo bomo yai sę teba pedelainogo ebo te usu ebe, magi basowe, augwali tigide te dili keni pągąna sali, te Isip we bidi tigide keni yali tiwai, augwali tigide me te keni pedelai. ");
INSERT INTO mps_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Tialima, Genuai Bidigo te tuni bidigo homu kolesaga dąų walama, tama te tuni bidigo Moses de Aron sigo po wabo odobeo, te Genuai Bidigo tama po wali gilama tama tiwai. ");
INSERT INTO mps_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Tama nosali ma, Genuai Bidigo Moses dali te po wali, “Kigamu digi mu nage pelama, tuni bidi agabolo te po weyu, ‘Da Hibru bagego God, Genuai Bidi Yawe, agai te po wali, “Te eno we bidi hani augwali enaba lotu po wagasomainogo tagala palao. ");
INSERT INTO mps_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tama nago te we bidi tagala palisiąbaso da, megi eno nagebolo dali, te nago sę ebo tobolu bidi dabe me, te nago we bidi dali, dageba te dene ilibo sę dabe mu mawaibao. Tama dagego te tigidali tǫ habu badu te bidi me deli, me te tibo god te ena tiwai me bidibo meni, te megi dagego mu bugagia konea saibao. Ena te God mu dao. ");
INSERT INTO mps_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Te eno nage dali, naga we bidi dali, dage te eno genuai gasigo dage dolainogo homu igi sogo da, teda dage tigidali mu ela siligi da. ");
INSERT INTO mps_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Tiali goli, eno nage hodolama, te tuni bidi nigiliyu, te eno genuai bomo dagebolo ola mayu, tama te we bidigo eno genuai nogi te tigidali tǫba te po pusugi pomainogo tebao. ");
INSERT INTO mps_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tiali goli, nago eno we bidi dali te boi bidi homu eyu, tama nago augwali tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tama tibaso, odao. Do e tobage tiwai sogo, te eno moni genuai tulubage, te talua ge tiwai tulubage e tǫba dulumainogo yaibao. Te tiwai tobage talua ge tulubage te Isip tǫba gesi sogo pedalisiąbadi, tama megi sogoba usu nagasai. ");
INSERT INTO mps_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tama te bidi dabe augwalibolo po olama, te kibu bulmakau dabe, me te nago nai gasa badu bidalua pabo nai dabe tigidali selama, te gasa be meba tomoba selasa pao. Meni baso, te eno genuai talua ge tulubage te bidi dabe tigiba, me te bulu badu bidibo kibu dabe tigiba tulama, tama augwali isaibao.” God Genuai Bidigo te po wai,’ dage sigo te po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Tama te tuni bidigo sę bidi meba augwali te Genuai Bidigo wali pode wi elama, tama augwaligo augwa sę ebo bidi dabe, me te augwa kibu dabe, te augwa be tomoba selama muai. ");
INSERT INTO mps_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Tiali goli, bidi meba augwaligo te Genuai Bidigo wali pode wi isąma, tama augwaligo augwa sę bidi, me te kibu dabe dali, augwali bulu badu olo bidai. ");
INSERT INTO mps_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Tama Genuai Bidigo Mosesbolo te po wali, “Nago nogo ugwaba selama, tama nago te dagalu usu siyu, tama te talua ge tulubage te Isip tǫ tigidali habu badu tuluyu, te we bidi dali te gide elalubo tigidali naiba tulubage tulaibao.” ");
INSERT INTO mps_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Tama Mosesgo dono ugwaba sali, tama Genuai Bidigo dagalu kulukulu omainogo yali, tama dagalude te be sele ebo ula te tǫba dulali, tama te talua ge tulubage tǫba tagala palai. Genuai Bidigo te talua ge tulubage te tigidali Isip tǫba tulumainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tama te talua ge tulubage me mu tutulu pidubadi geai, tama dagalude te be sele ebo ula te sia dabo tiwai eyu, tama te tigidali habuba pidubadi geai. Tama polobadu te Isip bage augwaligo te tiwai talua ge tulubage me subeo. Mu menio. ");
INSERT INTO mps_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tama te tulubagego te bidi dabe, me te kibu dabe, me te Isip tǫde bulu badu elaluali nai dabe tigidali dolai. Tama te talua ge tulubagego te gide elaluali nai, me te ni du dabe tigidali pedelama, tigidali mu dolai. ");
INSERT INTO mps_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tiali goli, te Gosen tǫ badu, te Israel bage bidibo digi, te bulu delide digi naga te tobage tulubage menio. ");
INSERT INTO mps_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tama tuni bidigo po ola toloyu, te Moses de Aron si asao, te po wai. Tama augwali si aselama, tama tuni bidigo augwali dali te po wali, “Megi eno dwai sęgę salio. Genuai Bidi Yawego doloba pai kolesaga yai, tiali goli ena dali, te eno we bidi dabe dali, dago dwai kolesaga yalio. ");
INSERT INTO mps_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Te talua ge tulubage tulali dali, te dagalu kulukulu wali, te sigo da dolai dao. Tama nago gedu haluasa po Genuai Bidibolo olama, tama agai te nai silibo side, te eno dage pomainogo tagala palaibao. Tama dage e tǫde ma bidimainogo menio,” wali. ");
INSERT INTO mps_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Tama Mosesgo te tuni bidi agabolo te po wali, “Te ena te hanu buluba pabo sogo, te eno nogo ugwaba selama, te Genuai Bidibolo gedu haluasa po waibao. Tama te be kulukulu ma wasiąma, tama te talua ge tulubage silaibao. Tama te sogo nago koneyu, te tǫ te Genuai Bidigo tǫ naga da waibao. ");
INSERT INTO mps_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Tiali goli, eno koneani, nage dali, te nago sę bidi dabego te Yawe God dali wi isiąyu, te aga Genuai Bidi da te homu menio,” wali. ");
INSERT INTO mps_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Te dwasianu ni dabe augwaligo tigi waligo te ugwa hobolobo hobi nigibo nai, me te rais bali dabe mu dolali, magi basowe te rais bali sabo tau sisi yai, tama te dwasianu ni dabe honu megi tama pedalobadi dao. ");
INSERT INTO mps_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Te tubo nai wit te digi dolobe, magi basowe, te honu dwasianu pedelai elaluai. ");
INSERT INTO mps_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Tama Mosesgo te tuni bidi taga peyu, aga te hanu sesege bulu badu pai. Tama agai nogo ugwaba selama, tama Genuai Bidibolo gedu haluasa po wai. Tama te dagalu kulukulu ma wasiąma, tama te talua ge tulubage me, te olo tulubage me, te tigidali sia sai. ");
INSERT INTO mps_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Tama tuni bidigo suali, te dagalu be kulu wasiąyu, tama te talua ge tulubage me, te olo tulubage me, te me te silali, tama te tuni bidi aga dali, te gavman sę ebo bidi dali, augwaligo kolesaga hasegelisiąma, tama augwa homu dąų olama, tama augwaligo dwai sę God dali ma yai. ");
INSERT INTO mps_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Mu tama, te tuni bidigo homu dąų olama, tama agai te Israel hani tagala palobe, te Genuai Bidigo te Mosesgo pedauwalide polobadu po weyu, tama tiaibao wai. ");
INSERT INTO mps_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Tama nosali Genuai Bidigo Mosesbolo te po wai, “Nago te tuni bidi sugi pao. Eno digi te tuni bidigo homu me, te aga dali gavman sę ebo bidi dabego homu me, te mu dąų ilai, tama eno te bomai sę augwali tomode yaibao. ");
INSERT INTO mps_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Tama eno te sę ebaso, te dagego duga wai dabebolo, me te dagego wąįgo wai dabebolo te eno te bomai sę Isip tomode yali po weyu, tama te Isip bage augwalibolo eno te bidigo isiąbo bomai sę eyu, tama augwaligo homu kolesaga aiyaba mu elaluali. Tama dage Israel dabe tigidaligo te sę ebo koneyu, tama ena digi ena te Genuai Bidi Yawe da, te me dagego mu koneaibao,” Genuai Bidigo Mosesbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Tama Moses de Aron si pelama, te tuni bidi agabolo te po wagi pali, “Da Hibru bagego God, Genuai Bidi Yawe, agai te po wai, ‘Nisu naga sogo nago te po sela sąyu, tama nage ena dologode bidigobewe? Te eno we bidi hani tagala palao, te augwaligo lotu po enaba wagasomainao. ");
INSERT INTO mps_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Te nago tama tisąbaso da, teda do eno te kuli mano dabe tagala palama, tama nago tǫba pągąna sagasaibao. ");
INSERT INTO mps_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Te augwaligo tigidali habu badu mesega sagaselama, tama nago te tǫ me sugobeo. Tama te nai dabe, me te ni dabe, te talua ge tulubagego dolisiąwani nai, te kuli mano dabe augwaligo te tigidali mu tula silaibao. ");
INSERT INTO mps_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Augwali te nago beba, me te nage dali gavman sę ebo bidigo beba me, te nago we bidigo beba me, te kuli mano dabe augwali pągąna saibao. Polobadu wąį dabe me te aya dede bidada asali, te megi tama bidibo sogo te tiwai kuli mano dabe hauwa te dagego tǫba me pedelai menio. Te dwai nai mu dao.’ Godigo te po wai.” Mosesgo te po olama, tama aga begelama, te tuni bidi tagalama, buluba pai. ");
INSERT INTO mps_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tama te tuni bidi aga dali gavman sę ebo bidi dabe augwaligo te tuni bidi dali te po wai, “Odao. Nisu naga sogo dabolo te sęgę mabo bidi da tomode me bidaibawe? Te we bidi dabe naga te augwali te augwa God Genuai Bidibolo lotu wagi peyu pomainao. Nago te Isip tǫ dolali susiąma ebawe?” ");
INSERT INTO mps_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tama augwaligo te Moses de Aron si te tuni bidiba odasa ma asai. Tama tuni bidigo augwali sibolo te po wali, “Dage te duga God Genuai Bidibolo lotu po wagi peyu piąo. Tiali goli, eno koneama te de dede naga mu dage paibawe?” ");
INSERT INTO mps_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Tama Mosesgo te tuni bidigo po wei ponoyu, te po wai, “Da tigidali paibao. Te dago gesi bidi dali, te monu dabe me, te wai ogwa me, te wegi me, tama te tigidali sipsip, me te meme, me te tigidali bulmakau dabe, te tigidali sela paibao. Magi basowe, te dago genuai nai daa tuyu, lotu po genuai te dago Genuai Bidibolo weyu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Tiali goli, tuni bidigo te po wai, “Eno te dage dali dagego we wai tigidali dali tagala paligi sogo da, teda eno homugo dagego Genuai Bidi Yawe aga me dage dali pigi da. Tiali goli, te menio, eno dagego te we wai dali tigidali sela pomainogo ebeo. Mu menio. Eno koneani, dagego dwai kolesaga dabolo yainogo ebao. ");
INSERT INTO mps_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tama eno te we wai dabe pomainogo me tagala palogobeo. Te bidi dabe augwali naga pelama, te Genuai Bidiba lotu po wagi peyu pomainao.” Tuni bidigo po ola silama, tama augwaligo Aron de Moses si buluba sela sąwai. ");
INSERT INTO mps_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tama nosali Genuai Bidigo Moses dali te po wali, “Nago nogo ugwaba selama, tama nago te Isip tǫ usu sao, tama te kuli mano dabe tigidali asomainao. Tama te kuli mano augwaligo te ni yabe dabe tigidali te genuai ais tulubagego dolisiąwani nai dabe tigidali tula silimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tama Godigo te po obaso, Mosesgo dono ugwaba sali, tama Genuai Bidigo te giliga pedalobo badu te wali te deli sogo giligade aselama, tama be hulia sai. Tama kigamu te waligo te kuli mano dabe selasa asalio. ");
INSERT INTO mps_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tama genuai genuai kuli mano dabe aselama, te Isip tǫ tigidali habu badu mesega sagasai. Polobadu Isip hani augwaligo te tiwai genuai kuli mano hani suai meni, tama nosali augwaligo ma sugobeo. ");
INSERT INTO mps_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tama te kuli mano augwali mu pągąna sagaselama, tama te tǫ tigidali mu mesega sai, tama te tǫ sisi mu yai. Tama te kuli mano augwaligo te tigidali nosa dabe, me te tigidali nedu du wai te genuai ais tulubagego dolisiąwani, te tigidali tula silai. Tama te nide te ni yabe, me te Isip tǫde nosa dabe deli digi me elalubeo. Menio. Augwaligo mu silai. ");
INSERT INTO mps_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tama tuni bidigo po polo tagala paliyu, tama Moses de Aron si asao wai. Tama augwali pali, tama agai augwali sibolo te po wai, “Eno dwai sęgę God dali yali, te dagego Genuai Bidi Yawe dali, me dage si dali me, te eno sęgę salio. ");
INSERT INTO mps_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tama dage sigo eno sęgę megi deli sogo digi ma sela sąyao. Tama dage sigo Godiba gedu haluasa po weyu, tama dagego Genuai Bidi agabolo hanaluyu, tama te dwai naigo ena dolainogo ebo te sela sąmainao.” ");
INSERT INTO mps_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tama augwali sigo te tuni bidi taga peyu, tama Mosesgo Genuai Bidiba gedu haluasa po wagi pai. ");
INSERT INTO mps_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tama Genuai Bidigo te wali hasegelama, te bomai wali te sia ge dega sabo badu asomainogo yai. Tama waligo te kuli mano tigidali te mama yai tamu ąįba selasa pai. Tama te Isipde te kuli mano tede me deli bidibeo. Menio. ");
INSERT INTO mps_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Tiali goli, Genuai Bidigo te tuni bidigo homu dąų mu ilama, tama tuni bidi te Israel bage augwali tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Nosali Genuai Bidigo Moses dali te po wai, “Nago nogo ugwaba sao, tama moni genuai hulia sabogo te Isip tǫ halua saibao. Te be hulia sabo te gasagi yai mu dao. Te bomai nai augwaligo nogogo tuabo usu tiwai dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Tama Mosesgo nogo ugwaba sali, tama genuai be hulia selama, tama Isip tǫ tigidali sela sogo be hulia sai elaluai. ");
INSERT INTO mps_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tama Isip we bidi augwali te augwa hasi suainogo ebo usu ebeo. Tama tigidali we bidi te sogo augwa be tomode bidai. Augwali buluba soabo usu ebeo. Tiali goli, te Israel bage augwali bidibo digi te be hulia sabeo. Menio. ");
INSERT INTO mps_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tama tuni bidigo Moses i olama, asobode agabolo te po wai, “Dage te duga Genuai Bidibolo lotu po wagi piąo. Tama te we wai augwali duga dali pomainao. Tiali goli, te bulmakau, sipsip dabe augwali te Isipde bidimainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Tama Mosesgo po wei ponoyu, te po wai, “Menio. Nago dago God Genuai Bidi Yawebolo ofa yabo nai me sela pomainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tama dago dena kibu dabe me tigidali selama, dago sela odasa paibao. Dago me deli bidibadi taga pogobeo. Dago kibu dabe meba te dago Genuai Bidibolo ofa yabo sa muaibao. Tiali goli, da te lotu po wabo buluba pedelama, tama dago koneama, mena kibu te ofa yainogo te saibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tiali goli, Genuai Bidigo te tuni bidigo homu dąų olama, tama tuni bidigo augwali tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Agai Mosesbolo te po wai, “Ao, nage pao! Nage te bulude bidigio, gedao. Nago ena ma sugobeo. Tama nago ena ma suagasiyu da, te deli sogo mu eno nage ela muaibao.” ");
INSERT INTO mps_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosesgo te po odoyu, te po wai, “Te dolo dao. Eno nage ma sugobeo.” ");
INSERT INTO mps_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Tama Moses te Isip tuni bidi sugi pesiąbadi, hasia bolo Genuai Bidigo Mosesbolo te po wai, “Eno deli sogo digi me te Isip tuni bidi, aga hani we bidi dali, augwalibolo te eno dene mu ilaibao. Tama tebo si, nosali agai dage tagala palaibao. Tama agai dage dali homu nagame elama, dage tagala palogobeo. Menio. Te agai dage polo mu pao weyu, tama dage te bulude tigidali mu sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tama megi nago te Israel we bidi tigidalibolo te po olama, tama augwali te pąde bidibo Isip haniba pelama, tama augwalibolo te au dobage gol, me te au dobage silva te augwali momainogo hanalugi pao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Nosali augwaligo tama tiwai, tama Genuai Bidigo te Israel bage augwalibolo te genuai nogi te Isip we bidi augwaligo gedude menama, tama augwaligo au dobage gol me silva te Israel bage augwalibolo mawai. Mu tama, te gavman sę ebo genuai bidi dabe dali, te Isip olo we bidi dali, augwaligo Moses te genuai bidi mu da, te homu yali, tama tiyu, augwaligo te sę ebo homu yai. ");
INSERT INTO mps_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tama te tuni bidigo te “Nago ena ma sugobeo,” te po olama, tama Mosesgo tuni bidibolo po wei ponoyu, te po wali, “Genuai Bidigo po odao. Agai te po wai, ‘Me sogo be huli tomode ena te Isip tǫ tigidali habuba bilaibao,’ te po wai. ");
INSERT INTO mps_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","‘Tama tigidali Isip bagego gomunai ogwa isa silaibao. Tama tuni bidi, nago gomunai ogwade digi gagalaibao. Te wai agai nage hasegelama, te tuni bidi pedelainogo yali, te ogwa isaibao. Tama tigidali gomunai ogwa te isiyu, tama te olo sę ebo we dabego gomunai ogwa me tigidali isaibao, te nogi meni yai we dabe sibi augwaligo te tubo nai wit te masingo agaga pelama te bret nigibo sę ebo dao. Tama te tigidali bulmakau dabego gomunai wai dabe me isaibao. ");
INSERT INTO mps_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tama tigidali Isip tǫ badu bidibo we bidi augwali homu sęgę me elama, tama gela genuai mu waibao. Te tiwai gela te Isipde polobadu me wai meni, tama te gela ma wagobeo. ");
INSERT INTO mps_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Tiali goli, eno dwai sę deli me te Israel we bidi augwali dali, me te augwaligo bulmakau nai dabe dali, dwai sę me egobeo,’ Genuai Bidi Yawego te po wai. Tama nago koneama, aga da te Genuai Bidi Yawe da, te homu emainogo yai, agai te deli tigi tiwai kolesaga te Israel bage dali ebe, te dage Isip dabe dali ebo kolesaga tiwai ebo menio.” ");
INSERT INTO mps_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tama Mosesgo te po ma wai, “Tama tuni bidi, nage dali, gavman sę ebo bidi dabe, dage tigidali aselama, tama enaba kidu sugunama, po bomonama weyu, te po waibao, ‘Nage pao. Nage naga we bidi hani dali, polo pao.’ Te sę tigidali pedela silama, tama nosali eno te Isip taga paibao.” Tama Moses sębę mu elama, tama agai te tuni bidi tagala buluba soai. ");
INSERT INTO mps_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Te Moses te tuni bidi polobadu sugi pesiąbadi, tama Genuai Bidigo Mosesbolo te po wai, “Tuni bidigo nago po me odogobeo, magi baso meni, te eno bomai sę meba te Isipde ma emainogo tama yaibao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Tama Moses de Aron sigo bomai sę hauwa deli deli te tuni bidigo gedude yai, tiali goli Godigo aga homu dąų olama, tama te tuni bidigo te Israel bage augwali agai tǫ tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Moses de Aron si Isipde bidibadi, Genuai Bidigo augwali sibolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Te megi polua te hasia polua te dagego kalenda bukude elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tama tigidali Israel we bidibolo te po wao, ‘Tama e polua dei nogo si wabode, te deli deli bidigo aga we waide te kibu sipsip wai sa muao, ma aga kibu meme wai me deli sa muao.’ ");
INSERT INTO mps_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Tama te we bidi wai augwali hani dwasianu eyu, tama augwaligo te nai tula silabo homu isiąbaso da, teda ayago te aga pąde bidibo we bidi wai augwali asa olama, tama te hani augwa si te nai dobola selama tuao. Augwaligo homugo te we bidi wai bidibo usu nama, tama te kibu sipsip mi augwaliba dobayao. ");
INSERT INTO mps_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tama dagego kibu sipsip omai, ma te meme omai, te kibu be deli yai sa muao. Dagego te sipsip meme te tigide keni keni yai me selamo dao. ");
INSERT INTO mps_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Augwaligo te kibu dabe bugagia tonaluama, te polua dei 14 wabode, tama pio mu tigidaligo te augwa kibu dabe elao. ");
INSERT INTO mps_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tama augwaligo te kibu dabe kaneme meba selama, tama mena bede te nai tubo te be tųde elalubo ni pos side me, te ugwadu me, te kaneme pipili pao. ");
INSERT INTO mps_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tama te sogo hulide dagego sipsip meme mi dabe siade ulao. Tama dagego te kibu mi dali, te bo disiąwai bret, me te ha yai donai dali tuao. ");
INSERT INTO mps_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tama dagego te kibu mi disiąwai tugio, tama dagego sęnęde ulama tulamuo. Menio. Dagego siade naga ulao. Tama te kibu tobolu me, te nogo sągą me, te tigidali haliga dabe, te kibu sipsip wai, ma meme wai, tigi sese elalubadi tama ulama, te mi tuao. ");
INSERT INTO mps_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Dagego te kibu mi meba munalubadi kigamu elamuo. Tama te kibu mi meba kigamu munalubaso da, teda te siaba ulama, tama te siago tigidali dela silimainao. ");
INSERT INTO mps_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Dagego te kibu mi tuabo sogo e tama tiao. Gudubo ugwa gudama, tama sągą nadoba mubadi, bilibo dono nogode tola sao. Tama dagego polo te kibu mi tuao, magi basowe, te nai tuali bodolude ena Genuai Bidi Yawe eno dage ela soaibao.” ");
INSERT INTO mps_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Tama te sogo hulide tama, ena te Isip tǫ tigidaliba pelama, tama te Isip we bidigo tigidali te gomunai ogwa ela muyu, tama augwaligo kibu dabe me elaibao. Ena digi ena te Genuai Bidi Yawe, tama eno te Isip bage augwaligo tibo god tigidali augwali te bomo meni yai bage mu dao hanilama, ola mawaibao. ");
INSERT INTO mps_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tama dagego te be pilali kaneme te dagego dąį tiwai elaluaibao. Tama eno te Isip bage augwali dene ilibo sogo, eno te kaneme sulama, tama eno dage ela soaibao.” ");
INSERT INTO mps_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Te sę yali sogo, dagego bodolu pedalobode, te dagego genuai lotu po wabo sogo yagasaibao, tama te sogo koneama, ena Genuai Bidi eno te sę yai. Tama dage hani nosali nosali pedalobo bage, augwaligo me te Godigo dage Tagalama Ela Soali Sogo pedalobode te nai tueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Genuai Bidigo po ma weyu, te po wai, “Te nosali bidada peyu, tama dagego te Pasova bret tubosi da, teda dagego te a naga olama, me badu nogo si, te tama side te bo disiąwai nai bret tuao. Te hasia mu dagego bede munalubo te bret bo dabo nai yis tigidali selama, tagalao. Magi baso meni, niwai bidi me deli agai hasia sogo te bo dabo nai yis tudu pelama, te a naga olama, me nogo si usu nigi pobaso da, teda aga dagego te Israel hanide sela sąyao. ");
INSERT INTO mps_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Te hasia deli sogo, me te a naga olama, me badu si sogo, dage sisinama, lotu po wao. Dagego te si sogo gasa sę me igio. Dagego duga tubo nai dabe naga dodolao. Te sę ebo naga te usu da.” ");
INSERT INTO mps_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Te hasia deli sogo te a naga olama, me badu si sogo wabode, te sogo digi eno dage hani tigidali te Isip taga peyu odasa paibao. Tama tigidali kibu bede dagego te wali peyu, te Bo Disiąwai Nai Bret Tuali bodolu muao. Tigidali sogo nosali dagego hani augwaligo te sogo te dagego genuai side tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Tama dagego te bo disiąwai nai bret te polua dei 14, tede pio tubo gagalama, tama te polua dei 21, te tama te nai tuao. ");
INSERT INTO mps_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tama te 7 sogo elalubadi, te yis dagego bede me munaluamo dao. Tama dage hani bidi me deli, ma te gasa bulu bidi dage dali bidibo bidi, te niwai bidigo te yis elalubo bret te sogo tubaso da, teda te bidi aga te dage Israel hanide sela sąyao. ");
INSERT INTO mps_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Odao. Te dage tedali tedali mena bidibo me, te Bo Disiąwai Nai Bret Tubo bodolu mani sogo, tede dagego te bo dabo nai yis tugio. Dagego te bo disiąwai bret naga tuao.” Genuai Bidi Godigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Tama Mosesgo tigidali Israel tobolu bidi dabe i olama asobode, augwalibolo te Israel hanibolo pusabo po weyu, te po wai, “Dage pelama, te ogwa bidi sipsip meme te dage dali duga we wai pulubade sa munama, tama te Godigo dage ela soabo Pasova side te sipsip meme dabe elao. ");
INSERT INTO mps_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Tama kaneme te pouba gelama, tama te ni hisop dwasianu nologo selama, tama te kaneme munalubo pouba muao. Tama kaneme dwasianu me badu te be tųde elalubo ni pos side piliyu, tama te tų ugwadu podilali nide me, te kaneme pilao. Tama dage tigidali te be tomode bidiyu, tama buluba me soasiąma, tama kigamu be posaibao. ");
INSERT INTO mps_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tama nosali Genuai Bidi te Isip tǫ habu tigidali teba pelama, te Isip bagego gomunai ogwa dabe elaibao. Tama agai te kaneme dagego be tų sesegede elalubo sulama, tama agai dage ela soyu, tama te ensel mobo bidi dabe augwaligo te be tomoba pelama, dagego gomunai wai dabe elegobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Tama dage dali, tama dagego nosali ame nabo bulai wai dabe, augwaligo te tiwai kolesaga tigidali kibu bede yao. ");
INSERT INTO mps_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Tama dage te Genuai Bidigo po dąų weyu, dage mawaiba wali te tǫba bidigi pabo sogo me, tama dagego te Godigo dage tagalama ela soali side te nai tuao. ");
INSERT INTO mps_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tama nosali dagego wai dabego dagebolo hanaluyu, te po waibao, ‘Magi po pagede te nai tubo dawe?’ ");
INSERT INTO mps_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Tama dagego augwalibolo te po wao, ‘Megi da, te Pasova sogo dao. Dago te ofa Genuai Bidibolo ebo, te agai da Israel hani tagalama ela soali bodolu side te sę ebao. Dago te Isip hani augwaligo gomunai ogwa agai elali sogo homugo koneama tiwai. Tiali goli, agai da Israel bagego be tagalama, ela soai, tama dago wai dabe sula tagalama, bugagia bidai.’” Mosesgo te po te tobolu bidi dabebolo wai. Tama nosali te we bidi augwaligo te po odoyu, tama augwali tobolu aiyaba munama, tama Godibolo lotu po wai. ");
INSERT INTO mps_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Tama nosali augwali hodaloama peyu, tama augwaligo te Genuai Bidigo Moses de Aron sibolo wali po wali peyu, te sę igi pai. ");
INSERT INTO mps_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Tama huli tomode mu, Genuai Bidigo te Isip dabego gomunai ogwa tigidali ela silai. Agai te tuni bidigo gomunai ogwade elebo gagalama, tama ela pelama, tama te kalabus bidi dabego gomunai ogwa dabeba me usu nigi pai. Tama agai te haniani kibu hani dabego gomunai wai dabe me elai. ");
INSERT INTO mps_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Tama te sogo hulide naga, te tuni bidi aga dali, gavman sę ebo bidi dabe me, tama te Isip we bidi tigidali, augwali hodaloama, te wai dabe isai suai. Tama Isip tǫ tigidali habu badu tigidali we bidi genuai gela ola pali, magi basowe, tigidali be deli delide wai ogwa isasa pai. ");
INSERT INTO mps_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tama te sogo hulide naga tuni bidigo Moses de Aron si i olama, asobode augwali sibolo te po wai, “Dage pao! Dage si dali, te tigidali Israel we bidi, dage polo piąo! Eno hani we bidi taga pao. Dagego enabolo hanalu wali te dagego Genuai Bidi Yawebolo lotu po wagi pao. ");
INSERT INTO mps_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tama te kibu sipsip, me meme, tama te kibu bulmakau me selama, tama te Isip mu tagalama, dagego polobadu wali po tiwai eyu pao. Tama nago gedu haluasa po Godibolo obaso, agai ena dwagi yai ilimainao,” te Isip tuni bidigo augwali sibolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tama Isip dabe augwaligo te Israel dabe augwaligo te Isip tǫ tagalama, polo pomainogo bomonama yai. Augwaligo te po wai, “Dagego da taga peyu, polo pesiąyu da, teda da tigidali isaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tama te Israel dabe augwaligo plaua te yis dali begelisiąbadi te pouba muai. Tama augwaligo te pou name ugwago haluama, tama augwaligo nagede tolasa pai. ");
INSERT INTO mps_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Tama Israel hani augwaligo te Isip we bidibolo te gol, me silva, me ugwa dabe, te nai hanalu wai, Mosesgo te po augwalibolo polobadu wai. ");
INSERT INTO mps_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Tama Genuai Bidigo te Israel hani augwalibolo genuai nogi te Isip we bidi augwaligo gedude mawai. Tama te Isip dabe augwaligo te Israel hanigo sainogo homu yali nai augwalibolo mawai. Tame te kolesagade Israel hanigo te Isip dabego nai umabo sai. ");
INSERT INTO mps_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Te Israel bage augwali hogolama peyu, te Rameses hanu tagalama, tama te Sukot hanuba pai. Te sogo te Israel hani bidi te bidi sese hauwa 600,000 mu pali, tiali goli augwaligo te we wai dabe dali nedebeo. ");
INSERT INTO mps_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tama te Israel hani isiąwai we bidi hani hauwa, me te bulmakau, me sipsip, me meme dabe hauwa, te augwali dali pai. ");
INSERT INTO mps_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tama augwaligo bret te yis meni yai plaua te Isipdu sela asali tedali ulai. Augwaligo te yis te plaua dali musiąwai, magi basowe, te Isip dabego augwali polo mu sela sąyu, tama augwaligo te nai sisi yabo sogo meni yai. ");
INSERT INTO mps_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tama te Israel hani augwali Isip tǫde kibu be bidi sese hauwa 430 mu bidai. ");
INSERT INTO mps_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tama te sogo mu dolo augwali Isip tǫde bidali kibu be bidi sese hauwa 430 mu bidama, tama Genuai Bidigo Israel hani dabe we bidi augwaligo te Isip tǫ taga soai. ");
INSERT INTO mps_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tama te sogo hulide naga Genuai Bidigo te Israel hani bugagia tonaluai, tama augwali te Isipde selama odasa asai. Tama tibaso, tigidali sogo nosali kibu bede augwali te sogo hulide odasa asali sogo Genuai Bidi homugo koneama, tama bugagia tonaluyu, augwaligo agabolo lotu po wabo dao. ");
INSERT INTO mps_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Genuai Bidigo Moses de Aron sibolo te po wai, “Odao, te Pasova nai dabego bomai po e dao. Te Israel hani isiąwai gasa bulu we bidigo te nai tugio. ");
INSERT INTO mps_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","Te augwali dage dali pęwadage sogo naga bidibaso da, ma augwali mone sabo sę eyu da, teda augwaligo te nai sela tugio. Tiali goli, dagego abelama te olo sę ebo bidi pedelali, tama dagego augwali tigiwali togwali, te bage augwaligo te nai tubo usu dao.” ");
INSERT INTO mps_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Te we bidi augwaligo te mi te nai sisi yali bede naga tuao. Augwaligo te nai meba te buluba sela pigio. Tama me te augwaligo te kibu sipsip dili dabe togogio. ");
INSERT INTO mps_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tama tigidali Israel hani augwaligo te nai tubo sę ilao. ");
INSERT INTO mps_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tiali goli, tigiwali togosiąwai bidigo te nai tugio. Tama gasa bulu bidi hani me deli te dagego bulu tǫba bidagasai yai baso da, tama te bidi agai te nai sela tuainogo yai, te Genuai Bidi Yawe eno dage tagalama ela soali sogo tubo nai, tama dagego te bidi aga bidi tigidali, me te mena bidi aga dali bidibo bidi dabe, te tigidali augwali tigiwali togwa. Tama nosali te bidi aga hani dali augwaligo te nai tumainao. Tama te bidi aga te dagego bidi me deli tiwai bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tama te gasa bidi hani te Israel hani augwali dali bidagasali bagego te Israel hanigo Pasova nai bomai po tiwai naga wali peyu, dage dali bidao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tama te Israel hani augwaligo te Genuai Bidigo te Moses de Aron sibolo po wali gilama te tiwai sę yai. ");
INSERT INTO mps_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Tama te sogo naga Genuai Bidigo te Israel hani tigidali Isipde selama, tama augwali odasa asai. ");
INSERT INTO mps_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Dagego gomunai ogwa tigidali enabolo mao. Dage Israel hanigo gomunai ogwa tigidali, me te dagego tigidali sipsip, meme, bulmakau gomunai omai wai dabe me, te enaba naga mao. Augwali te eno tedali muani nai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosesgo te we bidi augwalibolo te po wai, “Dage te Isipde bidali, te kalabus sę ebo bulu dao. Tama aga bomogo digi, Genuai Bidigo dage Isip bulude selama, odasa asai. Tama tibaso, tigidali kibu be dagego agai te tama tiali side homugo koneama, tama dagego te bo dai nai bret dali tugio. ");
INSERT INTO mps_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tama megi dagego te Isip taga sobao, te side e polua delide, augwaligo te nogi Abip wai. ");
INSERT INTO mps_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Tama Genuai Bidigo dago wąį dabe dali po dąų olama weyu, te Kenan dabe augwaligo tǫ, me Hit bidi dabe, me te Amor dabe, me te Hivi, me te Jebus dabe, te bidi hani augwaligo tǫ dage mawaibao. Te tǫ wiegi yai mu, tama ili hauwa elalubao. Tama Genuai Bidigo dage te tǫba odasa pabo sogo, dagego te Bo Disiąwai Nai Bret tuali te genuai side tigidali kibu be e Abip nogi wabo poluade te sę wali piąo. ");
INSERT INTO mps_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tama dagego te bo disiąwai nai bret te a naga olama me badu nogo si tama side tuao. Tama a naga olama me badu si sogo, te dagego te genuai nai tuyu, Genuai Bidibolo lotu po wao. ");
INSERT INTO mps_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tama te a naga olama me badu nogo si te side te we bidi augwaligo te bo disiąwai nai bret tulama, tama dagego te yis, me bret te yis elalubadi, te bulude me te dagego tǫde munalubadi elaluamu dao. ");
INSERT INTO mps_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tama te genuai side pedalobo si, dagego duga ogwa te wai dabe augwalibolo te po haninama pusao, ‘Dago te kolesaga tigidali ebo, te Genuai Bidi agai da te Isip tǫde bidibadi, da odasa asali sogo koneagasu, te sę ebo dao.’ ");
INSERT INTO mps_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Tama dagego kegeda pidali weyu, te tiwai lotu po wabo kolesaga da, te dąį me deli dao, te dagego duga nogode me gesabidide elaluabo dąį ąǫ yaibao. Tama te Genuai Bidigo bomai po te dagego homu kolesaga iliyu, tama po wabo nigilaibao. Magi basowe, Genuai Bidigo bomogo sę elama, tama da Isip tǫde selama, odasa asai dao. ");
INSERT INTO mps_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tama tigidali kibu bede te tiali sogo pedalobode, te sogo dagego te nai tuao,” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Te Mosesgo po ma weyu, te po wai, “Genuai Bidigo dage te Kenan dabego tǫba odasa paibao. Tama agai dagebolo me, te dagego waigo wai dabe, te dagego wąį dabe, augwalibolo me te tǫ maiabo po polobadu digi dąų wai dao. ");
INSERT INTO mps_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Tama agai te tǫ dageba mabo sogo, tama dagego gomunai ogwa tigidali te dagego Genuai Bidiba mao. Tama tigidali kibu dabego gomunai wai, te me Genuai Bidigo naga dao. ");
INSERT INTO mps_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tiali goli, dagego te sipsip wai me deligo te donki gomunai wai ma dobola abelama, ofa ilao. Tiali goli, dagego te donki ma abelesiąyu da, teda dagego te donki dogoni togwao, isimainao. Tama dagego duga digi te gomunai ogwa wai dabe tigidali ma abelao.” ");
INSERT INTO mps_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Tama nosali dagego ogwa dabego dagebolo te tiwai hanaluyu, te po tiwai waibao, ‘Te kolesaga page mena tama dawe?’ Tama dagego augwalibolo te po wao, ‘Da Isip bulude kalabus sę ebadi, tama Genuai Bidigo bomai sę mu elama, tama da Isip bulude selama, da odasa asai dao. ");
INSERT INTO mps_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tama hasia sogo Isip hani tuni bidigo homu kolesaga hasegelisiąyu, tama da tagala palobeo. Tiali goli, Genuai Bidigo te Isip dabego gomunai ogwa tigidali, me te augwaligo kibu dabe gomunai wai tigidali ela muai. Tama megi dago te kibu dabego gomunai wai te Genuai Bidiba ofa ebo dao. Tama tiali goli, dago te dena gomunai wai ogwa te augwali ma abelebo dao.’ Te po duga ogwa dabebolo wei ponao. ");
INSERT INTO mps_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Dago te sę ebo te dago homugo ma koneama, te Genuai Bidigo bomogo aga digi da te Isipde selama, odasa asai. Tama te dago nogode me gesabidide muai nai tiwai, tama dago homu hodolobo sę ebo dao,” Mosesgo te Israel hani we bidibolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Te Isip tuni bidigo te Israel we bidi hani tagala palai sogo, Godigo augwali te nabis badu te pęwadage tųdu te Filistia tǫ badu odasa pabeo. Magi basowe, Godigo te homu yai, ‘Te Israel hani augwali te pęwadage tųdu odasa peyu da, tama gasa hanigo augwali dali hwįainogo ebo suyu da, teda augwaligo homu hasegelama, te Isipba ma paibao. Tama te Israel hani augwaligo te tama tebo te eno hagela yai.’ ");
INSERT INTO mps_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tama tibaso, Godigo augwali te ni meni yai te tǫ wa pai bulu, te badu bagulama soyu, tama augwali te mama yai tamu ąįba pedelai. Augwaligo te boi bidi dali hwįbo nai me tolama pai. ");
INSERT INTO mps_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Polobadu Josepgo te Israel hanibolo te po wai, “Nosali ena isama, tama Godigo dage Isipdu te Kenan tǫba ma oda sagasobode, tama dagego eno dili dabe dali selasa pao.” Tama Israel dabe augwaligo bomai po dąų weyu, tama tiaibao wai. Tama Mosesgo te Josepgo dili dabe selama, tolasa pai. ");
INSERT INTO mps_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Tama Israel hani augwaligo te Sukot hanu tagalama, te masigi sane yai bulu Etam sesegeba pedelai. ");
INSERT INTO mps_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Tama siade te Genuai Bidi te genuai bobage pǫ tomode bidali, tama aga polasa peyu, augwali pabo tų ola mawai. Tama hulide aga te genuai bobage sia dabe tomode bidiyu, tama aga polasa peyu, tama augwalibolo te sia ula ilai. Tama tibaso, augwali te siade me, hulide me pabo usu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tama sesemane sogo siade te pǫ te we bidi augwali pobadi te pǫ polasa pali, tama hulide me te sia polasa peyu, ula ela pai. ");
INSERT INTO mps_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Te Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Te Israel dabe augwalibolo te po olama, tama augwali ma geasa peyu pelama, tama te tamu ąį sesegede te bulu Pihahirot, tede te bidabo pesage nigao. Te bulu te Mikdol dali, te mama tamu ąį dali, te si tomode elalubao, te Balsefon bulu dolo si dao. ");
INSERT INTO mps_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Tama augwali tama tibaso da, teda te Isip tuni bidigo augwali soali gegelama suyu, te po waibao, ‘Te Israel hani augwali te pabo tų susiąma gegede biliyu, te masigi sane yai bulude olo bilama, tama augwaligo te badu tų taga pabo menio,’ tuni bidigo te homu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Tama eno te tuni bidigo homu hasegelama, tama agai dage pobeasa asomainogo yaibao. Tiali goli, eno aga te agai ami bidi dabe aiyaba elaluama, tama eno genuai nogi te sę ebode saibao. Tama Isip dabe augwaligo koneama, ena digi ena Genuai Bidi Yawe dao,” Genuai Bidigo te po wai. Tama po obaso, te Israel dabe augwaligo te Genuai Bidigo po odolama, augwali ma geasa pai. ");
INSERT INTO mps_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Tama te Isip we bidi dabego te Israel bage augwali wi pali po te tuni bidibolo wai, tama aga dali, te gavman sę ebo ofisa bidi dabe dali, augwaligo homu hasegelama, tama augwaligo te po wai, “Magi baso dago te Israel hani augwali tagala palaliwe? Tama megi da, augwaligo dago sę egobeo. Dago dwai geda mu muai dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Augwaligo te po olama, tama tuni bidigo aga kibu hosgo kegela pabo hwįbo nai karis dali, te aga ami dabe augwali sai. ");
INSERT INTO mps_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Tama agai te bidi sese hauwa 600 te wiegi yai polasa peyu hwįbo nai karis dabe dali, te ami bagego gasa karis tigidali me, te agai karis tonalubo ofisa dabe augwali me selama, pai. ");
INSERT INTO mps_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Tama Israel hani augwaligo koneani, te Isip dabe augwali aiyaba elaluama, tama augwali dwagi yai homu dali pai. Tiali goli, Genuai Bidigo te tuni bidigo homu hasegelama, tama tuni bidigo augwali nosali polo pobeasa asai. ");
INSERT INTO mps_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Te Isip ami bidi dabego karis elaluai, tama te ami bidi dabe augwali te hosde duayu, tama ami bidi dabe meba tǫdu pali, tama augwali tigidaligo te Israel hani augwali pobeasa peyu, pai. Tama augwali te Israel bage bidibo pąba pedelai, te mama tamu ąį sesegede, te Pihahirot bulu pąde, te Balsefon bulu dolo si elaluali, tede pedelai. ");
INSERT INTO mps_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tama te Isip tuni bidi aga ami dabe dali, augwali pąba polo asobo te Israel hani augwaligo suai. Tama augwali wi mu eyu, tama Genuai Bidigo augwali tau somainogo i wai. ");
INSERT INTO mps_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Tama augwaligo Mosesbolo te po wai, “Magi baso nago da e masigi yai kemi tǫ buluba olo odasa asaliwe? Nago da e olo bulude isimainogo yaliwe? Tama da te Isip tǫde bidibadi isigi sogo da, te usu igi dao. Te Isip bulude elalubo gų page te da usu igi dao. ");
INSERT INTO mps_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Dago te Isip taga soasiąbadi, tama dago nagebolo te tiwai sę pedelaiba, te po walio. Tama dago te po wai, ‘Da tagalama, da ede bidimainao, tama da te Isip dabego olo sę bidi bidimainao,’ te po wai. Tama da sę olo mu naga igi dao. Tama tiyu, da e olo masigi naga yai bulude isibo dwaibao.” Augwaligo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Tama Mosesgo augwalibolo te po wei ponoyu, te po wai, “Wibo tagalao. Bomonama dolaluyu, tama megi Genuai Bidigo dage tau selama, tigidali sę ebo suaibao. Tama megi dagego te Isip dabe subo, tiali goli nosali dagego augwali munu ma sugobeo. ");
INSERT INTO mps_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Odao, Genuai Bidigo dage tau siyu, hwįaibao. Tiali goli, duga digi magi sę me elamuo. Dagego pedauwali dąų naga wao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Tama Genuai Bidigo Mosesbolo te po wai, “Magi baso nago ena i wabo sę ebawe? Te Israel dabe augwalibolo te po weyu, augwali pomainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","“Tama nago dono ugwaba selama, tama te tamu ąį usu sao. Tama te wę si badu peda pelama, tama wa pai tǫ pedelama, tama Israel dabe augwali te tomodu pelama, te u badu pedalomainao. ");
INSERT INTO mps_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tama eno te Isip bage augwaligo homu kolesaga te homu tomoba masigi sąwai bidigo homu tiwai ilama, tama augwaligo dage Israel dabe wali pobasa asaibao. Tama eno te tuni bidi aga karis dabe dali, me te hosde duawali ami bidi dabe tigidali, augwali aiyaba elaluama, tama eno te sę yalide te eno genuai nogi saibao. ");
INSERT INTO mps_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tama eno te Isip dabe aiyaba elalubaso, tama augwaligo homugo ena digi te ena Genuai Bidi Yawe dao,” agai te po wai. ");
INSERT INTO mps_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Te Godigo Ensel Mobo Bidi te Israel hani dabe polasa pabo bidi, tama augwali tede tagalama, aga augwali nosali pai. Tama te Israel dabe pabo tedu polasa pabo pǫ, te me geasa te augwali tudi badu ma doligi sai. ");
INSERT INTO mps_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Tama te sogo hulide te pǫ te Isip dabe dali, te Israel dabe dali, augwali tomode dąį tiwai elaluai. Tama te pǫgo te Isip dabe augwali bidibo badu te be hulia sai mu elaluai. Tiali goli, te pǫgo te Israel dabe bidibo digi, te badu te ula elaluai. Tama tibaso, te sogo hulide te Isip dabe augwali te Israel hani pąba pabo te usu ebeo. ");
INSERT INTO mps_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tama Mosesgo nogo ugwaba selama, tama tamu ąį hulide usu sai, tama Genuai Bidigo bomai wali te sia ge pedalobo badu asiyu pedelali, tama te waligo te tamu ąį te sia ponobo tiwai edubadi, tama be posai. Tama waligo te tamu ąį ma sela sąbode, tama tamu ąį tomode si peda pai. ");
INSERT INTO mps_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Tama tomode tǫ tigidali wa pai, tama Israel dabe augwali tedu uba pai. Tama te tamu ąį si dali si badu te be daga tiwai dolaluai. ");
INSERT INTO mps_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Tama tigidali Isip ami bidi dabe augwaligo te Israel dabe elainogo wali pobasa peyu, augwali me te tamu ąį tomodu pai. Te hos dabe, me te karis, me te hosde dua yali ami bidi dabe, tigidali hodobo pai. ");
INSERT INTO mps_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Tama Genuai Bidi te bobage pǫde me te siade bidiyu, tama te be posobo pąde agai te Isip ami bidi aiyaba tonono bilama, tama agai augwaligo homugo kolesaga te polobo bidigo homu tiwai ilama, tama augwali midigi dwai mu yai. ");
INSERT INTO mps_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Genuai Bidigo te augwaligo karis nadoba te tǫde dąų ilali, tama te karis dabe bomonama uda wainogo yali usu ebeo. Tama te Isip dabego te po wai, “Odiąo. Te Genuai Bidi Yawe aga hani Israel augwali tau siyu, da dali hwįbao. Da polo wi pinao. Dago augwali polo taga pinao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Tama tibaso, Genuai Bidigo Mosesbolo te po wai, “Nago nogo ugwaba selama, te tamu ąį usu sao, tama te ąį ma asiyu, te Isip ami bidi dabe dali, me te karis, me hos dabe me, augwali te ąįgo mesega sagasaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tama Mosesgo nogo ugwaba selama, te tamu ąį usu sali, tama be posobode te ąį ma asiyu, tama te polobadu elaluali tiwai ma yai. Tama te Isip dabe augwali wi pabo usu sali, tiali goli augwali usu meni yai, magi basowe, Genuai Bidigo augwali tigidali te tamu wę tomoba popogolo pai. ");
INSERT INTO mps_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tama te Isip tuni bidigo ami bidi dabe augwali te Israel hani wali peyu, te tamu wę tomoba pali bage, te wę ma asiyu, te Isip ami bidi dabe augwali mesega sai. Tama agai te ami dabe tigidali, me te hos, me karis dabe, augwali dali agai te węgo mesegelali, tama deli me bidibeo. Tigidali isai. ");
INSERT INTO mps_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Tiali goli, te sę pedalisiąbadi, te Israel dabe augwali te tǫ wai digi pali, tama te wę te be daga u badu me e badu elalubo tiwai yai, tama augwali pelama, te wę u badu hasia sabolai dao. ");
INSERT INTO mps_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tama te sogo Genuai Bidigo te Israel dabe te Isip dabego nogode ma dobola sai, tama Israel dabe augwaligo te Isip isai bidi dabe te wę sesegede munalua pai suai. ");
INSERT INTO mps_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Augwaligo te genuai sę Genuai Bidigo eyu, te Isip dabe aiyaba elalubo suai. Tama Israel we bidi augwali wi elama, Genuai Bidi dologode bidiyu, tama augwaligo bomo yai homu agade dąų weyu, tama aga sę bidi Moses dali tiwai. ");
INSERT INTO mps_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tama te sogo Moses dali te Israel dabe augwaligo tęąbi po me deli te Genuai Bidibolo e tiwai tęąbi wali, “Megi te eno Genuai Bidi Yawebolo tęąbi waibao, magi basowe, agai te genuai wąbi mu hwįnama, tama tede genuai wiegi yai nogi sai dao. Agai te hosde duawali bidi dabe dali, te hos dali, augwali te tamu ąį tomoba sąwai. ");
INSERT INTO mps_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Genuai Bidigo digi ena bomo ilali, tama eno tęąbigo aga nogi ugwaba saibao. Agai ena ma dobola sali, aga da te eno God mu dao, tama eno aga nogi ugwaba sobao. Tama aga te eno ayago God, tama agai genuai nogide eno tęąbi po waibao. ");
INSERT INTO mps_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Tama Genuai Bidi aga te boma pai ami bidi mu dao. Genuai Bidi Yawe naga te aga nogi dao. ");
INSERT INTO mps_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Agai te Isip tuni bidigo ami bidi dabe dali, te hwįbo nai karis dabe dali, augwali te tamu ąįba sąwai. Tama te tuni bidigo ami bidi dabego polasa pabo bidi kapten te wę tulama, tama te mama tamu węde isai dao. ");
INSERT INTO mps_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Genuai węgo augwali mesegai, tama augwali aiyaba mu dulama, te kemi masigi tiwai yai.” ");
INSERT INTO mps_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Genuai Bidi, nago dolo nogogo bomo genuai elalubao, tama agai te boi bidi ągąlama, tama augwali mu mia sąwai. ");
INSERT INTO mps_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Te nago genuai bomogo digi nago naga boi bidi augwali aiyaba elaluai. Nago sębę te sia tiwai pedaliyu, tama augwali te wa pai nosa tiwai siago ulai. ");
INSERT INTO mps_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nago te bomai wali hodolai. Tama waligo te wę bo ugwadu ilali, tama wę te obo tiwai dolo dolaluai. Tama aiyadu mu elaluali tamu wę dila pai pedelai.” ");
INSERT INTO mps_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Te boi bidi dabe augwaligo te po wai, ‘Dago augwali pobelama, tama augwali dąų waibao. Tama dago augwaligo wiegi wiegi yai nai dena hanibolo dobola saibao. Tama tigidali nai dago sainogo yali nai te dago siyu naga yaibao. Tama dago augwali dali te poapi ge hwągo hwįnama, tama dena bomogo digi te dago augwali dolaibao.’” ");
INSERT INTO mps_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","“Tiali goli nago mobo deli sogo naga ponani, tama tamu ąįgo Isip dabe mesega sai. Tama augwali aiyaba tomoba mu te tamu wę tomoba masigi dulubo tiwai yai.” ");
INSERT INTO mps_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Genuai Bidi Yawe, mena gasa god bidibo te nago bomo tiwai dawe? Me deli menio. Nage te polalubo tuni bidi te nage ugwadu tama tigidali wiegi yai tedali mu dao. Tama niwai bidi te nage dali usu tiwai dawe? Me menio. Nago te bidigo isąwai bomai sę eyu, tama genuai sę ebaso, te we bidi augwali nagede wi mu ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nago dolo nogo dodolobode tama tǫ dedage elama, tama te boi bidi dabe augwali te tǫ dedagego dalai.” ");
INSERT INTO mps_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Tama nago da homu dene eyu, tau sabo silisiąbo kolesaga eyu, tama nago da ma selama, tama nage polasa peyu, da odasa pai. Tama nago bomogo digi da pabo dodolama, tama nago da te naga digi bidainogo yali wiegi yai buluba odasa pai. ");
INSERT INTO mps_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tama meba tǫde bidibo bage augwaligo te sę yali po odolama, tama augwali wi mu eyu, tama augwali noma saibao. Tama te Filistia bage augwaligo me te po odolama, wi mu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tama Idom tǫde bidibo genuai bidi augwali wi mu yaibao. Tama Moap bomai bidi dabe augwali didibili mu yaibao. Tama Kenan dabe augwaligo bomo te olo wę ayana pabo tiwai yaibao. ");
INSERT INTO mps_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Genuai Bidi, nago genuai bomo augwaligo sulama, tama genuai wigo augwali mesegelama, tama augwaligo magi sę me deli yabo usugobeo. Augwali te ni tigi tiwai, olo naga dolalubadi, tama naga we bidi da ela soala silibo usu yaibao. Genuai Bidi, nago da Isipde ma sela asaligo tama da olo bugagia bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tama nago da odasa asiyu, te da naga bulu dude bugagia dualama bidimainogo yaibao. Tede te naga digi naga be sęwai dao, te bulu nago nogogo digi bugagia dodolama muai dao. ");
INSERT INTO mps_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Tama Genuai Bidi nage tuni bidi sesemane sogo bidada paibao.” Moses agai te Genuai Bidi Yawebolo te tęąbi po wai. ");
INSERT INTO mps_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Te mama tamu ąį te tǫ wa tiwai pedelai tiwaidu tama te Israel dabe pelama, u badu pedelalio. Tiali goli, Isip tuni bidigo ami bidi dabe dali, te hos dali, te karis me, augwali te Israel dabe augwali wali asai, tama Genuai Bidigo te tamu ąį ma asomainogo ilama, tama augwali te węgo mesega sai. ");
INSERT INTO mps_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Tama nosali, Genuai Bidigo po pusubo we Miriam, te Aron aga abe, agai te dwasianu kilikili wabo habili tiwai nai musik sali, te tigidali we dabego me te tobage habili tiwai nai musik selama, te Miriam pabo wali pai. Tama augwaligo te musik dabe eliyu, tęąbi eyu, tigi bebege eyu, danis me yai. ");
INSERT INTO mps_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Tama Miriamgo tęąbi e tiwai augwalibolo wali, “Genuai Bidibolo tęąbi wao, magi basowe, agai genuai wąbi mu hwįani aiyaba elaluai. Agai te hos dabe dali, te hosde duayali bidi dali, augwali te tamu ąį tomoba sąwai dao.” ");
INSERT INTO mps_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Nosali Mosesgo Israel dabe augwali te mama tamu wę tagalama odasa pali, tama augwali te wa pai ni meni yai bulu Sur tedu pai. Tama augwali sela sogo te wa pai nai meni yai buludu pai, tama augwaligo wę me subeo. ");
INSERT INTO mps_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tama nosali augwali te ąį me elalubo bulu me Mara teba pedelali, tiali goli te wę dwai ha pedauwalide ebo wę, tama augwaligo te wę tuabo usugobeo. Te Mara nogi page e tiwai, te pedauwalide ha ebo nai dao. ");
INSERT INTO mps_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tama te we bidi augwaligo wado po weyu, tama po hauwa Moses dali weyu, tama augwaligo agabolo te tiwai po hanalu wai, “Te dago magi nai tuguwe?” ");
INSERT INTO mps_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Tama tibaso, Mosesgo gedu haluasa po bomonama, Genuai Bidibolo wali, tama Genuai Bidigo aga ni me deli ola mani. Tama Mosesgo selama, te węba sąwai, tama te wę wiegi yai pedelai, tama augwaligo tuabo usu yai. Te bulude Godigo te Israel bagebolo bomo yai po meba augwaligo te po wali pomainogo mawai, tama me agai augwali usu sela suali, te augwaligo aga wali asobowe naga suainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Tama Godigo augwalibolo te po wai, “Dagego eno po bugagia odao, te dagego God Genuai Bidi, tama te sę dabe ena digi te dwagi yai sę da homu ebo, tama dagego eno bomo yai po tigidali wali piąo. Dagego tama tibaso da, teda eno dagebolo te haniani dwai gasi te Isip we bidi augwalibolo yali te tiwai dagebolo me magobeo. Ena digi ena te Genuai Bidi dao. Tama eno naga te dagego gasi dabe usu ma ilibo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Tama nosali Israel dabe augwali te Elim buluba pedelai. Tama Elimde wę ulu pedalobo dedage nogo si olama sągągo si, tama ni bidi sese sela olama nogo si, 70 ni det elaluai. Tama Israel dabe augwaligo augwa name ugwa be dabe te wę ulu dedage pąde dodolama, bidai. ");
INSERT INTO mps_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Te Israel hani te Isip taga soalama, tama pelama, tama te bulu Elim tede osogo bidali. Tama te Isip taga soalama, tama polua deli silama, te polua dei 15, te side tigidali Israel hani we bidigo te Elim bulu tagalama, tama te tǫ wa pai nai meni yai bulu nogi Sen tomoba pai. Te bulu te Elim de Sainai te bulu si tomode elaluai. ");
INSERT INTO mps_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tama augwaligo wado po, me te po hauwa te Moses de Aron si dali te bulude wai. ");
INSERT INTO mps_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Augwaligo te bidi si dali te po wai, “Dago homugo Genuai Bidigo da Isipde eligi sogo da, usu igi dao. Polobadu da Isipde bidibadi, mena tiwai nai dabe, me hasa mi me, te dago homugo digi sai dao. Tiali goli, dage sigo da e nai meni yai wa pai buluba odasa asai, tama dage sigo homugo da nai sili bidilama, tama da tigidali isimainogo homu yai. Tama da Isipde bidibadi isigi sogo da, te wiegi yai mu igi dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Tama Genuai Bidigo te po Mosesbolo wai, “Eno te bret dagalude tulalubode te dagego siąo. Tama tigidali deli deli side te we bidi augwali pelama, te side tuabo te nai sigi pao. Te eno augwali te kolesagade usu selama, tama augwaligo eno po wali pogowe, te eno koneainogo tiaibao. ");
INSERT INTO mps_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Tama te nogo a olama me badu deli te side augwaligo si sogo tuabo nai sisilama, sela muao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tama Moses dali Aron sigo te Israel we bidi hani tigidalibolo te po wai, “Tama pio te dagego bugagia koneagameo, Genuai Bidi aga digi dage Isipdu odasa asai dao. ");
INSERT INTO mps_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Dagego wado po weyu, po hauwa aga dali wali, te agai odalio. Tama tibaso, kigamu te Genuai Bidigo digi aga bomo de ula dali si dagego sueibao. Da si te olo bidi naga dao. Tama magi pode dagego wado po da si dali obawe?” ");
INSERT INTO mps_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Tama Mosesgo po ma wai, “Genuai Bidi aga digi dage te nai mi pio mabode te dagego tuagameo. Tama agai te nai bret kigamu te dagego homugo somainogo mawaibao. Magi basowe, dagego po hauwa aga dali wabo odai. Tiali goli, da si te olo nai tiwai dao. Dagego wado po te Genuai Bidi dali naga obao.” ");
INSERT INTO mps_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Tama Mosesgo Aronbolo te po wai, “Augwalibolo e po pusao, ‘Genuai Bidigo te dage tigidali we bidigo wado po wabo odalio. Tama tibaso, dage tigidali aselama, te Genuai Bidi pąba dolagasao,’ te po wao.” ");
INSERT INTO mps_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Tama Arongo te po augwalibolo wali, tama te sogo agai po odubadi, augwaligo te masigi kemi yai buluba tonono pai, tama polo tama Godigo genuai ula de bomo dali si, te augwali polasa pabo bobage pǫ tedu pedelai. ");
INSERT INTO mps_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Tama Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Eno te Israel dabe augwaligo wado po wali po odalio. Tama te po augwalibolo wao, te pio mu augwaligo te nai mi tuyu, tama kigamu augwaligo te bret te augwa homugo sela tuao. Augwaligo te nai sela tuyu, tama augwaligo te tiwai koneyu, ena Genuai Bidi Yawe, ena digi ena te augwaligo God da, te augwaligo konemainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tama pio dwasianu ba hani hauwa augwali bidibo pesageba pągąna sagasai. Tama me te kigamu te hulide tulubage segeni yali ąį te augwali bidibo pesage nosa pąde elaluai. ");
INSERT INTO mps_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tama te wę wa paide, augwaligo suali, te dwasianu nai hauwa te tǫde munaluali, te ni yabe dabe pepeda pabo tiwai yai. ");
INSERT INTO mps_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tama Israel dabe augwaligo te nai suali, tama augwaligo konebeo. Tama augwaligo augwa hasibolo digi hanaluyu, te tiwai po wai, “Te magi nai dawe?” Tama Mosesgo augwalibolo te po wai, “Te bret Genuai Bidigo digi dagego tuabo nai mobao. ");
INSERT INTO mps_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tama Genuai Bidigo tama po wai, ‘Dage deli deligo duga we wai dabe dali usu sisinao. Dagego te lita si sabo sene deli delide te duga ugwa bede bidibo we bidi wai puluba usu nama sao,’ wali.” ");
INSERT INTO mps_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Tama Israel dabe augwaligo tama tiwai, tiali goli mebago hauwa sali, tama mebago dwasianu naga sai. ");
INSERT INTO mps_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Tama augwaligo te nai dagala subo sogo, te nai hauwa sali bidi dabego, te sene usu menio. Tama te dwasianu naga sali bidi dabego, te augwaligo nai habuge ebeo. Tama tigidaligo te nai tulama, tama augwali tabi pągąnama, tama augwali nasi me ebeo. ");
INSERT INTO mps_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Tama Mosesgo augwalibolo te po wai, “Dagego nai meba te do tuaiba olama, me munamo dao.” ");
INSERT INTO mps_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tiali goli, mebago Mosesgo po odisiąma, wali pabe, tama augwaligo nai meba nosali side tuainogo muai. Tiali goli, kigamu dwasianu kigi dabe te naiba pągąna selama, tama kugumini dwai pedelai. Tama Mosesgo augwali dali wado yai. ");
INSERT INTO mps_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tama te we bidi augwaligo tigidali sogo kigamu te nai augwa sabo usu tama sai. Tama giliga nanobo sogode, te sisąma tǫde munaluali nai, te wę tiwai pedelama, odolali sia sai. ");
INSERT INTO mps_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tama te namba 6 dei augwaligo nai si sogo tuabo usu siyu, te dwasianu sene si te deli deli bidi usu nama sai. Tama Israel tobolu bidi dabe aselama, Mosesbolo te sę yali po wagasai. ");
INSERT INTO mps_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Tama Mosesgo augwalibolo te po wai, “Genuai Bidigo te po wai, do te olo bidibo side dao. Te Sabat side, tama te Genuai Bidigo olo bidibo side. Tama megi te dagego nai meba siade ulai wida, teda dagego uluiąo, tama meba te dagego sene ulainogo wida, teda te sene ulao. Tama te me badu munalubaso da, teda te do ulabo munalumainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tama augwaligo Mosesgo po wali pelama, te sogo nai meba ula tuali, tama augwaligo ulusiąwani nai meba te nosali side ulainogo muai. Tama do kigamu augwaligo suai, te nai damua pisąma, tama dwasianu kigi dabe me pedalobeo. ");
INSERT INTO mps_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Tama te side Mosesgo te po wai, “Megi te Sabat side, te side olo bidiyu, genuai nogi Genuai Bidibolo mabode, tama megi dagego nai te dage bidibo pesage tǫde me gegegobeo. Tama dagego te do munaluali tubo nai megi tuagameo. ");
INSERT INTO mps_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tama te tigidali Sarere te a naga olama me deli tede, dagego te nai saibao. Tama a naga olama me badu nogo si, te side te olo bidibo side, tama te side te tǫde nai me munalugobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Tama agai te po wai goli, te nogo a olama me badu si te olo bidibo Sabat side te we bidi meba nai sigi peyu pai, tiali goli augwali odolali gegai. Nai me munalubeo. ");
INSERT INTO mps_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Tama Genuai Bidigo Mosesbolo te po wai, “Nisu sogo dagego te dwai kolesaga ebo tagalama, tama dagego eno bomo yai po wali paibawe? ");
INSERT INTO mps_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bugagia odao, Genuai Bidi eno dagebolo te olo bidabo side te mobao. Tama tibaso, te dwasianu Sarere eno dagebolo eno te deli sogode te si sogo tuabo nai mawaibao. Tama, te nogo a naga olama nogo me si wabo side tigidali we bidi te ugwa bede bidiąo. Te bidi me deligo me, te wego me, te aga bidibo obo bolama, te buluba me pelamo dao.” ");
INSERT INTO mps_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tama te po obaso, nosali augwali te a naga olama me badu nogo si te side olo bidai. ");
INSERT INTO mps_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Tama Israel we bidi augwaligo te tǫ daide sali nai nogi mana wai. Te nai mana dwasianu ge tedela yai, te nedu du me deli tiwai. Tama te nai pusu, te bisket hani mege dali gelama nigai tubo pusu tiwai yai. ");
INSERT INTO mps_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Tama Mosesgo augwalibolo te po wai, “Genuai Bidigo te po wai, dago te tǫgo nigai dwasianu sene selama, te nai mana tede munama, te dago wąį te wai dabe augwalide muao. Nosali augwaligo te Genuai Bidigo da te nai meni yai bulude mani nai sumainu, te agai da Isip tagalama odasa asai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Tama Mosesgo te po Aronbolo wai, “Te tǫgo nigai sene me deli selama, tede te nai mana pągąnama, tama te sene te Genuai Bidigo gedude muao, tama te nosali ame nabo hani wai dabe augwaligo te sulama, konemainao.” ");
INSERT INTO mps_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tama Arongo te mana muani sene te bomo yai po munalubo halobage eda badu muani, te Genuai Bidigo Mosesbolo wali po gilama tama tiwai. ");
INSERT INTO mps_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Tama Israel dabe augwaligo te nai mana te kibu be bidi sese side 40 tuai. Tama te kibu be bidi sese si silama, tama nosali augwali te bulu tǫ Kenan teba pedelama, tama augwali te tǫde bidiyu, gi sę yai. ");
INSERT INTO mps_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Tama te mana nai senede muani sogo, augwaligo sene gasa tobage tiwai si elaluai. Te me sene deli te dwasianu usu tama, tama gasa te dwasianu sene nogo si usu yabo tiwai elaluai. Tama Arongo te tobage dwasianu sene te nai mana pągąnama, te Genuai Bidigo gedude muani.) ");
INSERT INTO mps_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Tigidali Israel we bidigo te wa pai bulu Sen tagalai. Genuai Bidigo te po obaso da, teda augwaligo te bidali bulu me tagalama, tama gasa buluba pelama, bidigi pidu geai. Tama nosali augwali te bulu Refidim teba pedelama, tede te bidabo pesage nigai, tiali goli te bulude te tuabo wę menio. ");
INSERT INTO mps_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tama tibaso, te we bidi augwaligo wado po Moses dali wai. Tama augwaligo te po wai, “Da wę mao. Da tuaibao.” Tama Mosesgo augwaligo po wei ponoyu, te po wai, “Magi baso dagego wado po ena dali obawe? Dagego homugo aga usu siyu, Genuai Bidigo bomo dagebolo ma ola momainogo ebawe?” ");
INSERT INTO mps_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tiali goli, te we bidi augwali te wę nogonego mu isabo ąǫ ebaso, tama augwaligo po hauwa Moses dali wai. Augwaligo te po wali, “Magi baso nago da Isipde selama, da odasa asai dawe? Nago homugo da dali, te dago wai dabe me, te dago kibu dabe me, da wę menia selama, tama da isimainogo ebawe?” ");
INSERT INTO mps_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Tama tibaso, Mosesgo gedu haluasa po bomonama Genuai Bidiba te tiwai wai, “Te we bidi augwaligo masigi sąnama, tama ena ela muainogo ebao. Tama eno magi sę augwalibolo egowe?” ");
INSERT INTO mps_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Tama Genuai Bidigo Mosesbolo te po wai, “Te Israel tobolu bidi dabe meba selama, tama dage polasa peyu, te we bidi augwali nosali asomainao. Tama dage pabo sogo, te dono polobadu nago te wę Nailba elali, te dono me sela pao. ");
INSERT INTO mps_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Tama ena te moni genuai masigi me deli daide ugwadu te bulu du Horep, tede ena dolaluaibao. Tama nage pąba aselama, te donogo te masigiba elama, tama wę te masigide pedelama, tama te we bidi dabego tumainao,” te po wai. (Te bulu du nogi Horep te gasa nogi me elalubao, te Sainai bulu du dao.) Tama te Israel tobolu bidi dabe augwaligo Mosesgo te tiwai sę ebadi, tama te masigide wę pedelama asobo suai. ");
INSERT INTO mps_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tama te bulu nogi augwaligo Masa wai, te nogi page “Usu sai,” tama me nogi Meriba, te nogi page “Wado po wai.” Magi basowe, Israel augwaligo wado eyu, tama augwaligo te po wai, “Genuai Bidi da dali bidibowe, ma meniwe?” Tama te dwai kolesagade augwaligo te Genuai Bidigo bomogo ebo sę usu sai. ");
INSERT INTO mps_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tama nosali Amalek hani bidi dabe aselama, Israel dabe te Refidim bulude bidibadi hwįagasai. ");
INSERT INTO mps_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Tama Mosesgo bidi me deli Josuabolo po weyu, te po wai, “Nago dago bidi meba usu selama, tama do dagego te Amalek dabe dali hwįgi pao. Tiali goli, ena da, te dwasianu bulu du bagede dolaluyu, tama Godigo enabolo te sela bilao wali dono te eno nogogo tolaluaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tama Josuago te bidi dabe meba selama, te Amalek hani bidi dabe dali hwįgi pali, te Mosesgo agabolo te po wali gilama tama tiwai. Tama Moses dali, te Aron, me te Hur, augwali sela te dwasianu bulu duba holai. ");
INSERT INTO mps_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tama Mosesgo nogo ugwaba sabo sogo, te Israel ami dabego te Amalek dabe aiyaba elaluai. Tiali goli, agai nogo aiyaba elalubo sogo, te Amalek dabego te Israel ami dabe aiyaba elaluyu yai. ");
INSERT INTO mps_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tama nosali Mosesgo nogo dene eyu, boma pobaso, tama agai nogo ugwaba ma sabo usugobeo. Tama Aron de Hur sigo masigi me deli selama, tǫba munama, tama Moses te masigide dulaluai. Tama augwali si Moses pąde u badu, me e badu dolaluyu, tama augwali sigo te Mosesgo nogo ugwaba selama, tolaluai. Augwali sigo tolalubadi, sia ge dega sigi pai. ");
INSERT INTO mps_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tama Josua dali Israel dabe augwaligo te Amalek dabe augwali aiyaba elaluama, tama augwali mu dolai. ");
INSERT INTO mps_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Tama nosali Genuai Bidigo Mosesbolo te po wai, “Te po te buku me delide asęnama, te we bidi augwaligo homude konealumainao. Te po e tiwai, ‘Genuai Bidi eno te Amalek dabe mu silaibao silama, tama te we bidi dabego homugo augwali munu me ma konegobeo.’ Tama nago te po Josuabolo me mao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Genuai Bidigo po wai digi, tama Mosesgo te Genuai Bidibolo nai ula maiabo alta sai me deli nigilama, tama te alta sai yali nogi e tiwai wai, “Genuai Bidi aga eno te nide walama, ugwaba sabo plak ugwa tiwai dao.” ");
INSERT INTO mps_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Tama Mosesgo te poali nogide te po wai, “Te ugwaba sagalobo plak ugwa tiwai eyu, tama eno ena nogo si ugwaba selama, tama Genuai Bidi aga bidibo digi teba gedu haluasa po te hwįbode wai dao. Magi basowe, Genuai Bidi agai sesemane sogo te Amalek hani bidi dabe dali hwįaibao,” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro aga te Midian dabego pris bidi, tama Mosesgo wąį, aga we aga aya. Tama agai Godigo tigidali sę Moses dali, me te Israel dabe dali me yali po odai. Tama me agai te Genuai Bidigo aga we bidi Israel dabe te Isipde bidibadi dobolama, odasa soainogo yali kolesaga, te po me odai. ");
INSERT INTO mps_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Tama Jetro aselama, Moses suagasai. Polobadu Mosesgo we Sipora te aga aya pageba ma osogo tagala palai. Tama megi da, Jetrogo te Moses we Sipora dali, aga ogwa si badi, augwali odasa aselama, aga bidibo digi pedelai. Te wai sigo nogi e tiwai, Gersom, me Elieser. Polobadu Mosesgo te po wai dao, “Ena gasa badu bidi, tama ena gasa tǫde bidibao.” Tama agai gomunai ogwa nogi e tiwai nogi yai, Gersom dao. ");
INSERT INTO mps_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Tama nosali agai te po wai, “Eno ayago God agai ena tau selama, tama Isip tuni bidigo ena ela mubeo.” Tama tiyu, agai tomo ogwa nogi Elieser po wai. ");
INSERT INTO mps_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Tama Jetro te Mosesgo we dali, te aga ogwa si me, augwali aselama, te masigi kemi bulu te Godigo bulu du pąba sabolali, te Mosesgo pesage nigilama bidibo digi dao. ");
INSERT INTO mps_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Tama Jetrogo po Mosesbolo ola toloyu, te po wai, “Ena Jetro, te naga wąį dali, te naga we me, te naga ogwa si me, da asobao.” ");
INSERT INTO mps_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Tama Mosesgo te po odama, tama agai Jetro tiąba tųdu pai. Tama Mosesgo mage basi gulama, tama nosali agai aga sebedi usai. Tama augwa si bidabo po dabe olama, tama nosali augwali Mosesgo ugwa be tomoba pai. ");
INSERT INTO mps_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Tama Mosesgo Jetro dali te Genuai Bidigo Isip tuni bidi dali yali sę po tigidali wali, me te Isip we bidi dabe dali me, te Israel dabe tau selama tiai. Tama agai Jetro dali me te dwai sogo te sęgę te tųde augwaliba pedelali po wali, tama Genuai Bidigo augwali tau selama bugagia bidai. ");
INSERT INTO mps_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Tama Jetrogo te wiegi yai sę Genuai Bidigo te Israel dabe augwali te Isip dabego nogode ma sainogo yali po odolama, tama aga wiegi yai homu mu yai. ");
INSERT INTO mps_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Tama agai te po wai, “Genuai Bidi Yawego nogi ugwaba sao. Agai dage te tuni bidigo nogode me, te Isip we bidi dabe augwaligo nogode me, te dage ma sai. Agai aga we bidi dage tau selama, tama dage te dwai kalabus sęde bidali tagalai dao. ");
INSERT INTO mps_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Tama megi eno koneani, Genuai Bidigo te gasa god dabe tigidali aiyaba elaluali, magi basowe, te Isip dabe augwaligo hagoma homu eyu, tama augwaligo dwai sę dagebolo yai baso, tama Genuai Bidi agai dage augwaligo nogode ma dobola sali.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Tama Jetrogo ofa yabo nai me deli sela asali, te siaba tigidali ulama, tama Godibolo mawai. Tama agai meba gasa ofa me te Godibolo yai. Tama Aron dali, te tigidali Israel genuai bidi dabe me aselama, tama Moses aga wąį dali te Godigo gedude nai tuai. ");
INSERT INTO mps_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Te nai tula silama, tama te sogo nosali Moses dualama, te Israel we bidi augwaligo po tų odai. Tama we bidi hauwa Moses bidibo digi kigamu aselama, tama bidada pidubadi, pio mu igi pai. ");
INSERT INTO mps_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jetrogo Mosesgo te sę dabe eyu, te we bidi dabe augwali tau sabo sulama, tama agai Mosesbolo te tiwai po wai, “Tegoba. Nago te we bidi tau sabo sę hauwa mu ebao. Magi baso nagaduba deligo naga nago te po tų odobo sę dabe ebo dawe? Suao, tigidali we bidi kigamu nage dali po wainogo asali, tama augwali dolayu, tonalubadi, be pio ebao. Magi baso nago tama tibawe?” wali. ");
INSERT INTO mps_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Tama Mosesgo agabolo te po wai, “Te we bidi dabe augwaligo te mena sę te Godigo augwaligo emainogo ebo sę te koneainogo tiwai. Tama tiyu, augwali ena bidibo digi asobo dao. ");
INSERT INTO mps_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tama me sogo bidi me aga si magi nai me delide wado ebo sogo, te bidi si ena bidiboba aselama, tama eno augwali sigo po dagalama, tama te po isilaibao. Tama augwaligo wado ebo page tede eno augwalibolo te Godigo bomai po ola mabo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Tama Jetrogo agabolo te po wai, “Moses, nago te sę ebo te wiegi yai tų wali pabeo. ");
INSERT INTO mps_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Te sę genuai mu dao. Nagaduba deligo naga ebo usugobeo. Nago naga te sę eyu da, teda nago tigi hagela mu eyu, tama te we bidi augwali me hagela yaibao. ");
INSERT INTO mps_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Eno po megi odao. Eno wiegi yai tų me deli te nago sę yabo po nagebolo eno te po waibao. Nago te po odoyu da, te God nage dali bidaibao. Tama nage te we bidi augwaligo polalubo bidi te Godigo gedude te augwaligo hwįabo po weyu, wado po wabo dabe, te po nago agaba sela pabo bidi bidiyu da, teda usu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Tama nago augwalibolo te Godigo bomai po tigidali ola mayu, tama augwaligo wali pabo tų me, te sesemane sogo te sę yabo kolesaga, te po augwalibolo wao. ");
INSERT INTO mps_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tiali goli, me nago te po page koneai bidi meba sa munama, tama augwaligo te we bidi tonaluabo bidi bidimainao. Tama mebago te we bidi bidi sese hauwa 1,000 mu tonaluyu, tama meba bidigo te bidi sese a naga 100 we bidi tonaluyu, tama mebago te 50 we bidi tonaluyu, tama mebago te nogo si we bidi naga tonalumainao. Nago te God dologode bidibo bidi dabe augwali sa munama, tama te tiwai bidi dago homu augwaliba dąų olama, tama meba bidi dabego dwai sę yali te monego augwali abelainogo ebo usugobeo. ");
INSERT INTO mps_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tama te bidi dabe augwali te we bidigo po dodolobo bidi pedelemainao. Augwa digi te dwasianu po dabe te po tųde dodolomainao. Tiali goli, augwaligo genuai sę yali po tų te nageba sela aselama, te nago te po dodolomainogo yaibao. Tama augwaligo nage tau siyu, tama te sęgę ebo sę toloyu, tama nago sę dene kuna egobeo. ");
INSERT INTO mps_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Te sę dabe eno nagebolo yao olama po wali, te Godigo digi te sę nago emainogo homu yai. Tama nago eno po wali peyu da, teda te sęgę nage tigi hagela iligobeo. Tama dagego te we bidigo yali sę, me te we bidigo po dodolama, tama augwali homu dua nagame elama, tama augwa buluba ma pelawaibao,” Moses aga wąįgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Tialima Mosesgo te wiegi yai po Jetrogo wabo po odolama, tama tiwai. ");
INSERT INTO mps_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Tama agai te Israel dabe augwali tomode te po page koneai bidi dabe augwali sa munama, tama augwaligo te bidi sese hauwa 1,000 we bidi, me te we bidi 100, we te 50, we te 10 we bidi meba tama tonaluabo bidi nigilai. ");
INSERT INTO mps_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tama sesemane sogo augwaligo te po tų odobo sę tonaluai. Augwa digi te dwasianu sę yali sęgę dabe dodolali, tiali goli augwaligo genuai sęgę yai sę yali te Moses pageba pelama, tama aga digi te sęgę dabe dodolai. ");
INSERT INTO mps_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Te po dabe dodolobo sę tama dodolama, tama nosali Mosesgo aga wąį nogo menama, tama Jetro aga bulu tǫ pedaiba ma pai. ");
INSERT INTO mps_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Te Israel dabe augwaligo te bulu Refidim tagalama, ma soali. Tama solama, tama augwaligo te bulu Isip taga soali sogo gagalama nedeyu, tama polua si mu silama, te polua sela wabo te dei delide, te sogo naga augwali te nai meni yai wa pai bulu Sainaiba sabolai. Tama augwali bidabo pesage te bulu du Sainai pąde nigai. ");
INSERT INTO mps_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Tama Moses te bulu duba God dali po miainogo holai. Tama Genuai Bidi bulu dude bidiyu, Moses i olama, agabolo te Israel dabe augwalibolo maiabo po meba wali, te hani dabe te Jekopgo wąį dabe dao. ");
INSERT INTO mps_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Genuai Bidigo te po wai, “Dagego eno yali sę te Isipde suai dao. Tama eno dage te ba kemodagego te aga gesi noma gǫų te bogo ugwadu daide sela soabo tiwai elama, tama dage eno e buluba odasa aselama, tama megi dage ena dali bidibao. ");
INSERT INTO mps_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tama dagego megi eno bomai po dąų olama, tama eno po mu wali peyu da, teda dage eno gasagi yai tedali we bidi hani pedelaibao. Tigidali tǫ me, tigidali we bidi me, te eno naga, tiali goli eno dage sa munama, hagea siyu, tama dage ena we bidi mu bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Tama dage eno te pris sę ebo tuni we bidi hani bidibo tiwai yaibao. Tama dage te eno tedali we bidi mu bidaibao.” Genuai Bidigo Mosesbolo te po te we bidi dabe augwalibolo mao wai. ");
INSERT INTO mps_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Tama Mosesgo te bulu du tagalama, tama pelama, te Israel dabe genuai bidi nigilali bage augwali sisinama, tama Genuai Bidigo agabolo te bulu dude wali po tigidali augwalibolo wai. ");
INSERT INTO mps_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tama tigidali we bidigo te po wai, “Dago te sę dabe tigidali te Genuai Bidigo po wali gilama te sę yaibao.” Tama Mosesgo te we bidigo po te Genuai Bidibolo wagi pai. ");
INSERT INTO mps_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Tama Genuai Bidigo Mosesbolo te po wai, “Odao, te genuai husugu yai pǫde bidilama, tama ena nageba asiyu, tama te we bidi augwaligo te eno nage dali po mibo odolama, tama sesemane sogo augwaligo nago poba homu dąų omainao.” Tama Mosesgo Genuai Bidibolo te we bidi augwaligo wali po wai. ");
INSERT INTO mps_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Tama Genuai Bidigo Mosesbolo te po wai, “Nago te we bidi augwalibolo te po wagi pelama, megi de do si te augwaligo homu kolesaga me dodolama, tama ugwa wę tedelama, tama augwaligo enaba lotu po wainogo sisilaluao. ");
INSERT INTO mps_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Augwaligo do digi sisi yao. Te duba sogo ena dulama, tama ena te Sainai bulu dude bidibadi, tama te we bidi augwaligo ena sumainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Nago dąį mubogo te bulu du bagulama, tama te we bidi augwali te dąį tomoba pigimio. Tama augwalibolo te po olama, tama augwali bugagia dua bidiyu, tama augwaligo te dąį bolama, tomoba pelama, te bulu duba hologio. Tama augwali te bulu du pąba pigio. Tama niwai bidi me deligo te dąį bolobaso da, augwaligo aga ela muao. ");
INSERT INTO mps_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tialima, augwaligo aga elebo sogo augwaligo nogogo aga eligio. Te augwaligo masigi sąnama eliyu, me te enigo aga enao. Te bidigo, me ma te kibugo te dąį bolobaso da, teda dagego aga te kolesaga elama elao. Te dage deli sogo te bulu duba holabo sogo elalubao. Tama te sogo dagego te bu wabo nai nogi biugel te bu wai da obaso da, teda dage piąo,” Genuai Bidigo te po wali. ");
INSERT INTO mps_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Tama Mosesgo te bulu du tagalama, dulama, tama te we bidi augwalibolo te lotu po wabo sisi iyąo te po wai. Tama augwaligo agai po wali pelama, augwa ugwa dabe wę telawai. ");
INSERT INTO mps_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Tama Mosesgo augwalibolo te po wali, “Dagego do digi sisi ela muao. Tama megi e side gagalama, do tama te sogo dage we dabe dali me pilamo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Tama bidama, te sela sogo wabo side kigamu, te genuai pǫ te bulu dude pedelali, tama te pǫ kulukulu olama, tama be sele ula pepeda pelama, tama bu wabo nai biugel gela genuai mu wai. Tama te bulu du sesegede pesage nigali we bidi dabe tigidali wi mu elama, tama augwali tigi didibili yai. ");
INSERT INTO mps_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tama Mosesgo augwali odasa te be mesalo buluba pelama, tama augwali te bulu du sesegede God dali deliba sisinai hagede dolalugi pai. ");
INSERT INTO mps_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tama Genuai Bidi te sia tomode bidilama dulali, tama te Sainai bulu duba bidagasali, tama genuai hanogo te bulu du tigidali mu mesega sai. Tama ugwaba holali hano te genuai sia mu dabo hano holobo tiwai mu yai, tama tǫ mali genuai mu te bulu dude pedelai. ");
INSERT INTO mps_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Tama te bu wabo nai biugel gela wabo genuai eyu, tama genuai mu pedelai. Tama Mosesgo po Godibolo olama, tama Godigo pedauwalidu agai po wei ponobo odainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Tama Genuai Bidi dulama, te Sainai bulu du bagede bidiyu, tama agai Moses te bulu duba ugwa holomainogo aga i wai. Tama Moses te bulu duba ugwa holai. ");
INSERT INTO mps_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Tama Genuai Bidigo te po agabolo wai, “Nage aiyaba dulama, tama te bomo yai po tigidali we bidibolo magi pao, tama augwaligo te dąį bolama, tama ena me suagasigio. Augwaligo te dąį boloyu da, teda we bidi hauwa isaibao. ");
INSERT INTO mps_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Te pris dabe augwali ena pąba asobo bage, augwali me te augwaligo homu kolesaga dwai meda elalubo dabe geselama, tama augwali eno gedude wiegi yai pedelao. Ma, te kolesaga isąyu da, teda eno augwali dene ilaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Tama Mosesgo te po Genuai Bidibolo wai, “Te we bidi dabe augwali edaba me hologobeo, magi basowe, naga digi nago bomai po dabolo mawai. Tama da te bulu du sesegede bobegelama, tama dąį muai, tama dago te bulu du habu selebao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Tama tialima, Genuai Bidigo agabolo te po wai, “Te usu da, nage aba dulama, tama Aron aga selama, tama nage dali edaba holao. Tiali goli, te pris dabe, me te we bidi dali, augwaligo te dąį muani bolama, ena pąba me edaba holamo da po wao. Ma, augwaligo te dąį boloyu da, teda augwali eno dene ilaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Tama Mosesgo te po wabo odama, tama aga te we bidi dabe bidibo digi dulama, tama Genuai Bidigo agabolo mani po tigidali augwalibolo pusai. ");
INSERT INTO mps_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Godigo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ena digi ena Genuai Bidi Yawe, ena dagego God dao. Eno dage Isipde sali, te bulude kalabus sę ebadi, tama eno dage selama, odasa asai.” ");
INSERT INTO mps_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Nago ena deli naga wali asao. Nago te tibo god me wali pelamo dao.” ");
INSERT INTO mps_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Nago tibo god me nigigio, tama nago te dagalude me, te tǫde me, ma te wę tomode elalubo naigo me, te tǫ dologode elalubo naigo te gasa nai piksa noma me deli munu me nigilamo dao. ");
INSERT INTO mps_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Nago te tibo godiba, me te noma bidiba kidu sugunama, lotu me wagimio, magi basowe, ena Genuai Bidi Yawe te ena nago God, tama ena te tibo godigo hasegelemainogo ebo usu me egobeo. Mu menio. Tede eno hagela homu mu ebo dao. Tama ena hagela mu homu ebo we bidi dabe, augwaligo te naide magi sę yai elalubaso, te eno augwali dene iliyu, tama augwaligo wai hani sela, me me si me si nosali pedelabo hani, augwalibolo me te mabo dene tiwai ilaibao. ");
INSERT INTO mps_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Tiali goli, ena godolo homu elama, tama eno bomai po tigidali wali pabo we bidi bidibaso, teda eno augwali me godolo eyu, te augwaligo wai dabe hauwa 1,000 mu nosali pedalobo hani me, te eno augwali dali wiegi yai homu eyu, augwali eno godolo mu yaibao, tama te kolesaga ebo siligobeo.” ");
INSERT INTO mps_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Nago eno nogi God dwai odolali nogi egio, te nago Genuai Bidi dao. Magi baso meni, ena nogi olo nogi ebo we bidi te eno augwali dene ilaibao.” ");
INSERT INTO mps_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Nago te Sabat side bugagia homugo koneama, te eno bodolu muani side dao. Te side te gasagi yai tedali elalumainao. ");
INSERT INTO mps_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nago te Sarere deli tomode te sę ebo side te nogo a naga olama me badu nogo kibisa deli, te tama sogo sę ebo si elalubao. ");
INSERT INTO mps_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Tialima, te a naga olama me badu nogo si wali, te me deli sogo te nago Genuai Bidi, God eno side dao. Te olo bidibo Sabat side nago sę me igio, tama nago ogwa dabe me, wegi dabe me, sę ebo we bidi dabe me, te nago sę ebo kibu dabe me, te nage dali bidibo gasa bulu tǫ bidi dabe me, dage tigidaligo te side sę me igimio. ");
INSERT INTO mps_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nago te tama tiao, te magi baso meni, te a naga olama me badu nogo kibisa deli sogo naga Genuai Bidi eno te tǫ dagalu, me te tamu ąį, me te tigidali elalubo nai nigai. Tiali goli, te a naga olama me badu nogo si wali, te me deli sogo eno olo bidiyu, toma tuai dao. Tama tibaso, Genuai Bidi eno te Sabat side te gasagi yai side te me tedali mu ilai. Tama te side te eno bodolu dolo mu dao.” ");
INSERT INTO mps_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Nago naga aya ida dologode bidama, tama augwaligo po wali pao. Nago tama tiyu da, te nage polo me isigobeo. Menio, te nage hauwa sogo te tǫde bidimainogo te God eno nago Genuai Bidi eno nage mawainogo homu ebo tǫde bidagameo.” ");
INSERT INTO mps_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Nago we bidi ela mugio.” ");
INSERT INTO mps_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Nago bidigo sai we dali, me ma te we sai bidi dali, me dwai sę me igio.” ");
INSERT INTO mps_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Nago nai wi sigio.” ");
INSERT INTO mps_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Nago tibo po olama, tama gasa we bidi olo po tų ela magio.” ");
INSERT INTO mps_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Nago gasa bidigo be sulama, pesą eyu, godolo igio. Tama nago gasa bidigo we dali gedu igio. Tama aga sę ebo bidi, me te sę ebo we, me te bulmakau, me bidi duabo donki, me te agai tigidali gasa nai dabe me, te nago godolo eyu, sabo homu me igio.” ");
INSERT INTO mps_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Te we bidi augwaligo te pǫ kulukulu wabo, me te bu wabo nai biugel gela wabo me odai. Tama augwaligo te be sele te pǫ ula ebo ugwaba peyu, eda asiyu eyu, tama genuai hano te bulu dude pedalobo sulama, tama augwali wi mu yai. Tama augwali kilasa ma pelama, te bulu du digibulu gana dolalugi pai. ");
INSERT INTO mps_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Tama augwaligo Mosesbolo te po wai, “Nago digi te po dabolo wabo, te dago te po odaibao. Tiyu Godigo po dabolo wabo si, te da isidalio,” wali. ");
INSERT INTO mps_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Tama Mosesgo augwalibolo te po wai, “Dage wibo, tagalao. Godigo dage usu naga sagasiyu asali, te dage aga dologoba pelama bidiyu, tama dagego dwai sę ma idali weyu, tiwai sę yai.” ");
INSERT INTO mps_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tiali goli, te we bidi dabe augwali digibulu digi dolalubadi, Moses agaduba deli naga te genuai husugu yai pǫ pąba, te God bidibo digi pai. ");
INSERT INTO mps_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Tama Genuai Bidigo po Mosesbolo olama, tama agai te Israel dabe augwalibolo te po omainogo yai. Tama Genuai Bidigo te po wai, “Dagego koneani te tiwai, te ena dagalude bidiyu, te eno po dage dali miai dao. ");
INSERT INTO mps_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Odiąo, dagego te tibo god dabe te gol me silvago nigilama, tama te nai dabeba lotu po me wagio. Dagego ena delibolo naga lotu po wao. ");
INSERT INTO mps_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tama dagego tǫ meba selama, tama eno alta nigao. Tama te altade dagego te sipsip dabe me, bulmakau me, te tigidali siaba ulama, siago dabo te ofa dali, te we bidi augwaligo ena dali dedeli homu yabo te ofa me yao. Tama dagego te tigidali bulude te dagego enabolo lotu omainogo, eno te sa mubo bulude dagego tama tibaso da, te ena aselama, dage bugagia wiegi yai mu ilaibao. ");
INSERT INTO mps_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Dagego masigigo te alta me deli nigiyu da, teda dagego te bidigo togwali masigi sigio. Magi baso meni, dagego te sę yai ain tulgo te masigi togoyu da, tama te tiwai masigigo eno sę ebo te dolo egobeo. ");
INSERT INTO mps_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tama dagego te ugwadu daide te alta nigigio, te dagego ofa yainogo ugwaba holabo togobili nigigio. Tiyu yaide, dage te togobilidu ugwaba holobadi, tama augwaligo dagego hale hanialubo suidalio,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Tama Genuai Bidigo po me wadolama weyu, te po wai, “Nago te po tų dodolabo bomai po te Israel we bidi augwalibolo mao. ");
INSERT INTO mps_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Bidi me deligo te olo sę yabo bidi me deli te duga Israel hanide me abelebaso da, teda agai te bidigo sę te kibu be 6 kibu bede te sę yaibao. Tama te kibu be 7 wabo, te kibu be delide te aga pomainogo tagala palao. Tama hasia agai mone meba mobaso, te sigio. Mu menio. Aga olo mu pomainao. ");
INSERT INTO mps_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Tama aga te we sisąbadi te sę ebo bidi pedelai baso da, teda agaduba deli naga pomainao. Tiali goli, hasia aga we bolo selama asai yai baso da, teda agai te sę ebo taga pabo sogo, te aga we dali sela pomainao. ");
INSERT INTO mps_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Tama te bidi aga dali sę yali bidigo we menama, tama te wego wai dabe ame nai baso da, tama te we me, te wai dabe dali, augwali te aga sę yali bidi dali bidaibao. Tama bidi naga aga te sę yali tagalaibao. ");
INSERT INTO mps_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","6","Tiali goli, te sę bidigo te po weyu, ‘Eno ena genuai bidi godolo mu yali, tama ena we me wai dabe godolo elama, tama eno augwali taga pabo hagela homu ebao,’ te po obaso da, teda aga genuai bidigo aga te po tų dodolabo beba selasa pao. Tama te sę ebo bidi te be tųde elalubo pos nide dolalubadi, tama aga genuai bidigo te nel selama, te sę bidigo olo podolama, dedage nigilao. Tama aga te genuai bidigo sę olo ebo bidi bidada pelama, tama aga isiyu, te sę tagalaibao.” ");
INSERT INTO mps_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Tama bidi me deligo masigi dabe sabo homu eyu, tama aga wegi muyu, Israel hani gasa bidigo te wegi abelebaso da, tama te kibu be 7 wabo kibu bede te genuai bidigo te we tagala palagio, tama agai te sę bidi dali hasia yali tiwai kolesaga naga yai. ");
INSERT INTO mps_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tama te bidigo te we te olo sę yabo we tiwai abelebaso da, tama hasia agai homugo te we sainogo yai, tiali goli nosali agai te we sabo homu isąyu da, teda te we aga ayago ma abelama, somainao. Te bidigo te we dali te doloba pai kolesaga ebe, tama agai te we te gasa bulu bidigo abelemainogo elamo dao. ");
INSERT INTO mps_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Tama agai te we aga ogwabolo mawainogo homu eyu da, teda agai wiegi yai sę aga dali ilama, te aga wegi dali ebo kolesaga tiwai gilama te we dali me tama tiao. ");
INSERT INTO mps_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Tama te genuai bidigo gasa we siyu da, teda agai te hasia sali te olo sę ebo we te bugagia tonaluao. Agai te we nai mayu, te ugwa me mayu elama, tama aga te we dali piyu, te agai polobadu yali tiwai gilama yao. ");
INSERT INTO mps_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Tama agai te tobage sę sela te we dali isąyu da, teda agai te we pomainogo tagala palama, tama te wego agabolo te mone meba magio,” wali. ");
INSERT INTO mps_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Bidi me deligo gasa bidi bomonama elai digi, tama te bidi isai baso da, teda dagego te bidi elali te bidi aga me ela muao. ");
INSERT INTO mps_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Tiali goli, agai homugo te bidi mu ela muabo homu isąyu da, tiali goli agai geda muyu naga te bidi elama, nosali aga isimainogo yai, tama te bidi elali bidi aga wi pomainao, te bidigi wi pabo buluba, te eno dagebolo sa muaibao, tama tede aga bugagia bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Tiali goli, bidi me deli agai gasa bidi dali sębę eyu, aga ela muabo homu ebaso da, tama nosali agai tama tiyu da, teda dagego aga digi ela muao. Te aga eno nai ulubo alta teba aselama, bugagia bidabo homu ebo tagaliyu, te dagego aga selasa pelama, aga ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Mena bidigo aga aya, ma aga ida si elebaso da, teda dagego te bidi aga ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Tama bidi me deligo aga abagi me deli wi selama, tama aga sę ebo bidi bidimainogo yai, ma agai gasa bidigo te bidi abelemainogo eyu da, teda dagego te tiwai kolesaga ebo bidi ma suyu, dąų olama eyu, tama aga ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Niwai bidigo aga aya de ida si dali wado po weyu, dwai dolabo bomai po wabo bidi, teda te bidi aga dagego ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Bidi me aga si wado po olama, tama bidi me deligo nogo sugunama, tama gasa bidi me elali, me ma masigi selama elali, tiali goli agai te bidi aga mu ela musiąyu da, teda dagego te bidigo yali dwai sę wei ponogio. Tama elama, tigi dolai bidi aga te betide pila munama, tama nosali aga dono tulama, be bulu badu bilibaso, teda te elali bidigo te mone wei agabolo mao. Te monego agai sę te tigidali sogo isąwani te usu nao. Tama te bidi elali bidi aga te bidi bugagia tonaluama tama, tama aga tigi usu ma ebo si te usu dao.” ");
INSERT INTO mps_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Tama bidi me deligo wąbi selama, tama aga sę ebo bidi me, te aga sę ebo we me elama, tama aga te elali sogo dolo isibaso da, teda dagego te genuai bidi agabolo te dene mu ilao. ");
INSERT INTO mps_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Tialima, te bidi ma te we te deli sogo, me ma si sogo bidilama, tama nosali aga isibaso da, teda dagego te aga genuai bidibolo dene iligio. Magi basowe, sę ebo bidi, ma te sę ebo we, te bidigo digi te aga sę dao, te abelai mone te olo hagawai baso, te aga sęgę dao.” ");
INSERT INTO mps_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Tama bidi meba wąbi hwįyu, tama bidi me deligo te wai tabi elalubo we elali, tama te wai dolama, te wego te wai polo ame nani, tiali goli te wai ame nani ida te dolisiąbaso da, teda te we elali bidigo te we page bidigo wabo po odama, tama agai te dwai sę yali dodoluyu wei begelama, te mone mao. Tiali goli, po tų ebode te mone sabo po usu da po weyu bolo elama, tama nosali te we aga bidigo te mone sao. ");
INSERT INTO mps_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Tiali goli, we ma aga wai tigi dolai baso da, teda dagego te bidibolo me te tiwai kolesaga naga wei ponao. Ma, te we isai yai baso da, teda dagego te we elali bidi aga ela muao. ");
INSERT INTO mps_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Tama te gedu, me ma te kele, me te nogo sągą dolai baso da, teda te tiwai kolesaga naga te aga dali wei ponao. ");
INSERT INTO mps_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Tama me ma, agai te we siago, me ma te we tigi dolama, te keni me te keloago elai baso da, teda dagego te bidibolo te tiwai sę naga yao.” ");
INSERT INTO mps_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Tama bidi me deligo aga sę ebo bidi ma te aga sę ebo we te geduba elama, tama te gedu dolobaso da, teda aga te bidigo sę bidi ma, te sę ebo we ma, te sęde bidigio. Te bidigo te genuai bidi taga pao, te aga gedu dolali dali wei si ponao. ");
INSERT INTO mps_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Tama agai te sę ebo bidi me te sę ebo we me te elali digi, tama aga kele degebaso da, teda agai te sę ebo aga tagalao, te aga kele degali dali wei si yao.” ");
INSERT INTO mps_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Tama bulmakaugo te bidi me deli, ma te we me, te agai gąųgo ela mubaso da, teda te bulmakau dagego ela muao. Tiali goli, dagego te bulmakaugo mi tugio. Tama dagego te bulmakau aga aya po tų ela magio. ");
INSERT INTO mps_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Tiali goli, te bulmakaugo te we bidi augwali te gąųgo eniyu ebaso, tama te we bidi augwaligo po bomonama te bulmakau page bidi dali wali digi, tama te bulmakau page bidigo te obo isąbaso da, teda dagego te tiwai kolesaga yao. Tama te bulmakaugo bidi me deli, ma te we me, ela mubaso da, teda dagego te bulmakau ela muyu, tama te bulmakau page bidi me ela muao. ");
INSERT INTO mps_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Tiali goli, po tų ebode te po obaso da, agai te isali bidi ma te we te aga hanibolo te bulmakaugo dwai sę yali me te aga dali te si ma abelama, tama te mone aga hanibolo mao. Tama tibo si, te aga isigobeo. Agai aga digi bidibo ula ma abelemainao. ");
INSERT INTO mps_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Tama te bulmakaugo te wai puluba, te ogwa me, te wegi me, elebaso da, teda te tiwai bomo yai po naga dagego wali piąo. ");
INSERT INTO mps_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Tama te bulmakaugo te sę ebo bidi ma te sę ebo we elebaso da, teda te kibu page bidigo te monego K300, te sę bidi ma te sę we te aga genuai bidibolo te mone menama, tama dagego masigi sąnama te bulmakau ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Tama bidi me deligo te tǫ dedage haluali nai sela sąwani, ma agai genuai tǫ dedage nigilama halusiąwai, tama bulmakau me deli, ma te bidi duabo donki, te dedageba tulaluama isibaso da, ");
INSERT INTO mps_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","teda te tǫ dedage nigali bidigo te kibu page bidi abelao. Tama te isali kibu aga somainao.” ");
INSERT INTO mps_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Tama bidi me deligo bulmakaugo te gasa bidigo bulmakau ela mubaso da, teda te bidi si me bidigo te bidibo bulmakau te gasa bidigo abelemainogo elama, tama te bidi augwa si te mone selama, tama te isali bulmakau mi, te augwa si dobola sao. ");
INSERT INTO mps_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Tiali goli, te bulmakaugo hwįbo bulmakau yai baso, te kibu page bidigo obo bugagia isąwai yai baso da, teda agai gasa bulmakau te isali bulmakau page bidibolo wei ponao. Tiali goli, agai te isali bulmakau te bidi aga somainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tama Genuai Bidigo po dage wadolama weyu, te po wai, “Tama bidi me deligo te bulmakau, me ma te sipsip me te wi selama ela muyu, me ma agai te gasa bidigo abelemainogo yai baso da, teda dagego te kibu page bidibolo te nai wi sali bidi agai te bulmakau a naga sobadi, te sipsip me si me si sobadi elama, wei ponomainao. ");
INSERT INTO mps_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Tama agai dolo ponomainao. Tiali goli, agai wei ponabo bulmakau me sipsip te meni baso da, te aga dagego te olo sę ebo bidi tiwai te gasa bidigo abelemainogo elama, tama te mone dagego selama, agai te wi sali kibu wei ponao. Tama agai te wi sali bulmakau, me sipsip, ma te bidi duabo donki, te nai dabe te agade elalubaso da, teda agai te nai si te aga te dwai sę yali wei ponao.” “Tama nai wi sabo bidi me deligo be hulide te be daga aluama, tama gasa bidigo aga dąų olama, tama aga ela mubaso da, teda te nai wi sali bidi ela muani bidi aga te sęgę menio. Tiali goli, agai aga te siade ela muyu da, te agai bidi ela mubo sęgę elalubao.” ");
INSERT INTO mps_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Tama bidi me deligo aga bulmakau dabe tedela pelama, tama aga tǫde, ma te aga wain bono du gide nai tumainogo yai, tama augwaligo agai dąį bolama, tama gasa bidigo giba nai tugi pai yai baso da, teda te bulmakau page bidigo te aga gide wiegi yai nai me, te wain bono du me, te gi page bidibolo wei ponao.” ");
INSERT INTO mps_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Tama bidigo aga tǫde te kala siago ulai digi, tama te sia genuai pedelama, tama te dąį bolama, gasa bidigo gide elalubo te tubo nai wit, me ma te wit augwaligo togolama tama pesage holai elaluai, tama te siago dobaso da, teda te sia ulali bidigo te siago dali nai tigidali wei ponao.” ");
INSERT INTO mps_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Tama bidi me deligo aga doado bage meba, ma aga mone dabe te aga abagibolo menama, tama agai bugagia munalumainogo homu yai. Tama nai wi sabo bidi me deli asiyu, te nai dabe wi sai, tama nosali augwaligo aga gegelama subaso da, te nai wi sali bidigo te nai si si naga tigidali te mone sali wei ponao. ");
INSERT INTO mps_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tiali goli, augwaligo te nai wi sali bidi gegabo usu isąbaso da, teda te nai tonaluali bidi dagego selama, te eno geduba te po tų dodolobo bidi dabe bidibo digi pao. Tama agai te po weyu, ‘Mu tama, eno te nai wi me sabeo,’ te po wao. ");
INSERT INTO mps_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Tama tigidali sogo bidigo po aga abagi dali te nai bulmakau, me te bidi duabo donki, me ma te sipsip, me te ugwa dabe, me gasa nai dabe hagawali po elaluai, tama te bidi augwali sigo te po weyu, ‘Te nai ena naga da,’ obaso da, teda te bidi si eno geduba te po tų dodolobo bidi dabe bidibo digi selasa pao. Tama te tibo po wabo bidi te eno aga sa mubaso da, teda te bidigo te nai si si naga te aga abagibolo wei ponaibao.” ");
INSERT INTO mps_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Tama bidi me deligo te bidi duabo donki, me te bulmakau, me ma te sipsip, ma gasa kibu dabe meba te aga abagibolo menama, tama agai tolalumainogo yai, tama te kibu dabe me dolo baso, me ma isiyu, me ma boi bidigo hwįyu selasa peyu da, tama bidigo te nai me susiąyu da, ");
INSERT INTO mps_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","teda te bidi augwali si te po tų dodolobo digi pelama, tama Genuai Bidi eno gedude te abagigo te po wao, ‘Mu tama, eno agai nai doliyu, ma te kibu me te eno wi me sabeo.’ Tama kibu page bidigo agai te po wabo usu da weyu, tama te abagigo agai te hagawali kibu dabe wei ponogobeo. ");
INSERT INTO mps_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Tiali goli, meba bidigo te abagigo tolalubo nai kibu dabe wi sobaso da, teda te kibu page bidibolo te abagigo te monego wei ponao. ");
INSERT INTO mps_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Tama te uni hasago elai baso da, teda te abagigo te kibu elama tuali, te me badu dage te aga abagibolo waselainogo sela pao. Tama agai te uni hasago elali bulmakau wei te monego ponogobeo.” ");
INSERT INTO mps_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Tama bidi me deligo aga abagigo te sę yabo bulmakau me deli osogo abelama, sę emainogo yai, tama te bulmakau page bidi te sogo tede bidisiąbadi, tama te bulmakau doliyu, ma isiyu me ebaso da, teda te abagigo te kibu page bidi abelao. ");
INSERT INTO mps_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Tiali goli, te bulmakau page bidi aga te abagi dali bidibadi, tama te bulmakau dolobaso da, teda abagigo te abelegio. Tama abagi agai hasia nagebolo mone menama, tama te bulmakau sę yainogo sai digi, tama te bulmakau dolobaso da, teda agai abelegio, magi basowe, agai te hasia mani mone te usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Tama bidi me deligo te gesi wegi te bidibolo noma po wasiąwai wegi, tama te bidi dali pisąbadi, tama bidigo te wegi nogo tubaso da, teda agai te we abeleyu, aga ayabolo mone menama, tama agai te we sao. ");
INSERT INTO mps_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tama te we aga ayago te bidigo te we sabo hagela homu ebaso da, te usu dao. Tiali goli, agai te we aga aya te augwaligo bidi dali pisąwai we abelebo mone usugo abelao.” ");
INSERT INTO mps_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Dagego te pobi nigibo we dabe ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Dagego te bulmakau so kibu tąbo bidi ela mubadi, tama omai kibugo te we aga tąmainogo ebo te we ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Tama te we bidi augwaligo ena Genuai Bidiba naga ofa yao. Tama me deligo te tibo godiba ofa ebaso da, te dagego aga ela muao.” ");
INSERT INTO mps_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Dagego te gasa bulu tǫ bidi aselama, dage dali bidibo bidi aga dali haniani dwai kolesaga eyu, ma te sęgę agaba mugimio. Magi basowe, polobadu dage te aga tiwai te Isip tǫde bidai dao.” ");
INSERT INTO mps_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Dagego te aga bidi isai we dali te dwai kolesaga eyu, ma te wai puluba, augwa aya ida isai tiana wai dabe dali me te kolesaga igio. ");
INSERT INTO mps_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tama dagego augwali dolobaso, tama eno augwali tau somainogo tama augwaligo gela enabolo obaso da, te eno augwaligo gela wabo mu odaibao. ");
INSERT INTO mps_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Tama eno sębę eyu, tama te boi bidi dabego dage dali hwįmainogo ilama, tama dage elemainogo yaibao. Tama dagego we dabe te bidi meni eyu, tama te dagego wai dabe augwaligo aya meni yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Tama eno we bidi augwali mone mu menia sobaso, tama augwaligo dage dali negeli sobaso da, teda dagego te mone sabo bisnis sę ebo bidigo negeli mabo tiwai igio. Tama augwaligo te negeli sali wei ponobo sogo, te dagego gasa mone dali daganama, sigio. Mu menio. ");
INSERT INTO mps_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Tama dage dali te negeli sabo bidigo agai te negeli sali wei begelainogo te agai holobo ugwa te sa mubo tiwai eyu, dagebolo mubaso da, teda dagego te sia ge dega sisąbadi, te sogo naga te ugwa agabolo ma mao. ");
INSERT INTO mps_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Magi basowe, agai te ugwa deli naga elaluali, te aga hulide kedau idali weyu, tigi bea sabo ugwa dao. Te ugwa nago tolalubaso da, te aga tigi magi naigo halua selama pigowe? Te eno aga tau somainogo, agai gedu haluasa po enabolo obaso da, te eno agai gedu haluasa po wabo odaibao, magi basowe, eno tigidali we bidi olo tau sabo homu kolesaga mabo dao.” ");
INSERT INTO mps_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tama dagego dwai po God enabolo me wasiąma, tama dagego te dwai po te we bidi augwaligo tobolu bidibolo dagego te Godigo aga dolomainogo, te dwai po me wagio.” ");
INSERT INTO mps_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tama hasia dagego te gide pedalobo te wit, me bono du wain, me tubo wel, me te oliv ni du dabe me, te selama, enabolo te ofa tiwai mabo te hagela igio.” “Tama dagego gomunai wai te ogwa te dagego enabolo mao. ");
INSERT INTO mps_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tama dagego te bulmakau de sipsip sigo gomunai wai te enabolo ofa yao. Tama te bulmakaugo wai, me te sipsipgo wai ame nenama, te nogo a naga olama me badu si sogo te aga ida dali hasia bidimainogo elama, tama te nogo a naga olama me badu sela wali, te me deli sogode dagego te kibu wai elama, enabolo ofa ilao.” ");
INSERT INTO mps_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Dage te eno tedali gasagi yai we bidi hani dao, tama tibaso, dagego te uni hasa dabe augwaligo te bulude ela muai kibu te nai mi dagego me tugio. Dagego te nai te yowi dabego naga tumainogo mao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Tama Mosesgo Genuai Bidigo po pusuyu, te tiwai po wai, “Tama dagego te magi nai po me deli pedelali te po odoyu, tama te mu po meni homu eyu da, teda dagego te sę yali po subigila ola biligio. Tama bidigo te dwai kolesaga ebaso da, teda dagego aga tau siyu, te po tų ebode tibo po wagio. ");
INSERT INTO mps_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tama bidi hauwa augwaligo te dwai kolesaga ebaso da, teda augwaligo te ebo kolesaga wali pigio. Ma, augwaligo te po tų ebode augwaligo tibo po weyu, te po tų dodolobo sę doloyu eyu da, teda augwali dali deli homu eyu, augwaligo te ebo kolesaga me wali pigimio. ");
INSERT INTO mps_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tama bidi mebago te magi nai meni yai bidi po tų ela mainogo, tama augwaligo dage te sę ebo suali tiwai po omainogo dage i obaso da, dagego te magi nai meni yai bidi tau siyu, te po mesegelama tibo po wagio.” ");
INSERT INTO mps_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Tama dagego duga boi bidigo te bidi dualasa pabo donki, ma bulmakau te obo tagalama wi pai yai subaso da, teda dagego selama, te bidi agabolo ma magibao. ");
INSERT INTO mps_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Tama dagego boi bidigo te donki, ma te bulmakau te walu dali tula muai elalubaso da, dagego te boi bidi tau selama, aga ma hodolao. Dagego aga te tǫde pila mumainogo tagaligio.” ");
INSERT INTO mps_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Tama te magi nai meni yai bidigo magi nai me delide po tų yagasobaso da, dagego agai po tų ebo mesegelama, aiyaba elalugio. ");
INSERT INTO mps_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Dagego gasa bidi tibo pode po tų ela magio. Tama doloba pai bidi agai dwai kolesaga me isąbadi, tama augwaligo aga po tų olo mu ilibaso da, teda dagego aga ela mugio. Magi basowe, te tiwai dwai kolesaga ebo bidi eno aga po tų ilama, tama aga hagawaibao.” ");
INSERT INTO mps_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Tama bidigo dage homu bega siyu, te po tų ebode tibo po omainogo te mone mobaso da, dagego te mone sigio. Magi basowe, te tiwai kolesagago te wiegi yai bidigo homu te tibo po wabo bidi tiwai pedelama, tama te dwai kolesaga isąwai bidigo po tų ebo aiyaba mesegelaibao.” ");
INSERT INTO mps_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Dagego bulude bidibo gasa bulu bidi dali dagego dwai kolesaga me igio, magi basowe, polobadu dage te Isipde bidibadi, te aga tǫ mude bidisąbo we bidi ebo kolesaga te dagego bugagia koneai dao.” ");
INSERT INTO mps_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Dagego gide nai bulama tuyu, tama te kibu be a naga olama nogo me badu deli, te kibu bede te nai bulama siyu, beba sisinao. ");
INSERT INTO mps_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Tiali goli, te kibu be 7 wabo, te kibu be me delide dagego nai bulisąma, te tǫ toma tuyu, olo elalumainao, tama dagego te tǫde olo pedalobo nai sigio. Tama te wain gide me, te ni du oliv gide me, dagego te tiwai kolesaga naga yao. Tama te magi nai meni yai bidi dabe augwaligo naga te gide olo holobo nai siyu, tama te magi nai meni yai bidi dabego sisąma tagalali nai me badu, te uni hasa dabego tula silimainao.” ");
INSERT INTO mps_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Tama tigidali Sarere dagego sę te nogo a naga olama me deli, te tama sogo dagego sę eyu, tama te a naga olama nogo me badu si wali, te me deli sogo dagego sę igio. Tama tiyu da, te donki dabe, me te bulmakau, me te sę ebo bidi dabe, me te sę ebo we dabe, me te dage dali bidibo gasa bulu bidi augwali me, te toma tuyu, tama bomo ma saibao.” ");
INSERT INTO mps_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Tama dagego eno te mabo po tigidali bugagia odolama, wali pao. Tama dagego tibo godibolo te gedu haluasa po me wagio. Tama dagego augwaligo nogi me wagio. Habu mu dao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tama deli deli kibu bede sela sogo dagego genuai lotu enaba wabo bodolu muao. ");
INSERT INTO mps_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tama dagego te Bo Disiąwai Nai Bret te genuai side te me bodolu munama, tama sisinama, lotu po wainogo, te eno wali po gilama tiwai yao. Tama dagego te bo disiąwai nai bret te a naga olama nogo me badu si, te tama sogo polua nogi Abip, te sogode te nai tuabo bodolu muai dao. Magi basowe, te poluade naga dagego te bulu Isip taga soai. Tama dagego enaba lotu po wagasainogo da, dagego te ofa yabo nai deli me selasa asiąo.” ");
INSERT INTO mps_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Tama dagego te wit tau yali gagalama hasia bolo nai sabo sogo, tama dagego enabolo usu da po weyu, tama wiegi yai homu te nai tuyu yabo, te sogo genuai bodolu muao.” “Tama dagego te genuai side te poluade te nedu du tau ebo sogo, te me bodolu muiąo. Tama te sogo dagego te wain gide te wain du siyu, osogo bidabo dwasianu be sęnama, tama te bede bidiyu, te wain me, oliv ni du dabe me, te gide siąo.” ");
INSERT INTO mps_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ena God, dagego Genuai Bidi, tama eno te kibu be deli delide sela sogo lotu wabo bodolu muani, tama te tigidali bidi dage aselama, enaba lotu po te sogo wagasiąo.” ");
INSERT INTO mps_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Dagego te kibu sipsip me bulmakau enaba ofa ebo sogo, dagego te bo dai yis elalubo bret dali ofa igio. Tama dagego te ofa ebo kibu ili dabe tigidali te siaba ulama, tama dagego te nosali kigamu ofa yabo me tagalama elalumainogo igio.” ");
INSERT INTO mps_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Tama dagego te polasa mu tau yali wiegi yai nai mu te gasa nai elalubadi, te nai dagego Genuai Bidi God eno beba sela pao.” “Dagego te meme ame pę te seneba munama, tama te memego digi wai elama, aga tigi mi te seneba munama, ulama tugio.” ");
INSERT INTO mps_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Odiąo, te eno sę ebo Ensel Mobo Bidi tagala palama, polasa peyu, tama dage tųdu pabode tonalua paibao. Tama agai te dage eno mawainogo sisi yai elaluali te bulu tǫba odasa peyu, teba sabolaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tama dua dao, dagego agai po bugagia odolama wali pao. Dagego agai po sela sągio, magi basowe, ena digi ena aga dali mu bidiyu, tama agai te po sela sąbo we bidigo dwai kolesaga te sela sągobeo. ");
INSERT INTO mps_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Tialima, dagego agai po wali pelama, tama eno te po wali sę tiwai tigidali ebaso da, te eno dagego boi bidi dabe augwali dali hwįnama, tama te dage dene mabo homu ebo bage me, te eno augwali aiyaba elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Eno sę ebo Ensel Mobo Bidi agai te dagego polasa pabo bidi pedelama, tama dage te Amor dabe, me te Hit dabe, me Peres, me te Kenan dabe, me te Hivi dabe, me te Jebus dabe, te hani augwaligo tǫba dage odasa pelama, tama eno augwali hani mu ela silaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Dagego augwaligo tibo godiba kidu sugunama, lotu wagio. Tama dagego augwaligo lotu wabo te kolesaga sigio. Dagego augwaligo te tibo god dolama, tama augwaligo te lotu wabo masigi dabe pepedela sąyao. ");
INSERT INTO mps_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Tama dagego lotu po enaba naga wao. Ena God, dagego Genuai Bidi dao. Dagego tama tiyu da, te eno dage wiegi yai iliyu, tama dage nai me te wę me mayu, tama dage gasi dabe me tigidali sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tama eno te wai haliga elalubo we dabego wai bugagia ame nomainogo yaibao. Tama eno te bidigo sai wego tabi dąų me walogobeo, te tigidaligo wai ame nomainogo yaibao. Tama dage polo me isigobeo. Menio. Te eno dage tigidali e tǫde bobobage sogo bida waibao.” ");
INSERT INTO mps_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Tama ena dage pabo digi polasa peyu, tama eno te boi bidi dabe augwaliba wi genuai ilama, tama eno augwali homu didibili ilaibao. Tama eno augwali dagede wi ilama pomainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Tama eno te bidi gąų kelebo nai nenemo dabe polasa tagala palama, dage nosali asobadi, tama augwaligo te Hivi dabe me, te Kenan dabe me, te Hit dabe me, te hani augwali sela sąmainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tiali goli, eno augwali te kibu be delide naga sela sągobeo. Eno tama tiyu da, te tǫ olo elalubo digi te bulu uni hasa dabe hauwa tede pedelama, tama dage dolidalio. ");
INSERT INTO mps_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Te eno boi bidi dabe augwali dua dua digi sela sąyu, tama dage hauwa pedelama, tama dagego te tǫ tigidali usu na silao.” ");
INSERT INTO mps_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Tama eno dagego tǫ dąį e tiwai ilaibao, te wę sanede, te mama tamu ąį badu, te Akaba tǫ te badu pelama, te tǫ tomode elalubo genuai tamu ąį Mediterenian teba sabolama, tama genuai wę Yufretis te badu peyu, te masigi kemi elalubo badu teba te dąį sabolaibao. Tama eno bomo dageba menama, tama te tǫde bidibo hani augwali aiyaba elaluama, tama dage te tǫ tomoba peyu, augwali sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tama dagego augwali dali po dąų weyu, me ma augwaligo tibo god dali me te tiwai kolesaga igio. ");
INSERT INTO mps_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Dagego augwali te dagego tǫde bidimainogo sula tagaligio. Tama tiyu, augwaligo dage dwai kolesaga tomoba kegeyu, tama enabolo sęgę ilidalio. Tama dagego augwaligo tibo godiba lotu weyu da, te dage tulaluama, tama mu dolaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Genuai Bidigo Mosesbolo te po wai, “Eno homugo nage dali, te Aron, me Nadap, me Abihu, me te Israel dabe genuai bidi, te bidi sese sela olama nogo si bidi dabe, dage ena bidibo te bulu duba ugwa holomainogo yaibao. Tama dage digibulu gana dolaluyu, tama tǫba basi gulama, tama enaba lotu wagameo. ");
INSERT INTO mps_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Tama Moses, nage deli naga ena pąba asagameo. Tama gasa te Israel genuai bidi dabe augwali te pąba me asisąma, tama te olo we bidi augwali me te nage dali aselamo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tama Moses pelama, te Genuai Bidigo bomai po tigidali te we bidi augwalibolo pusigi pai. Tama tigidaligo te po odolama, tama augwaligo pedauwali deliba munama, tama te po wai, “Dago te Genuai Bidigo po wali te sę tigidali yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tama Mosesgo Genuai Bidigo bomai po tigidali asęai. Tama nosali side aga kigamu mu hodaluama, tama alta me deli te bulu du sesegede nigilama, tama te alta pąde agai te masigi nogo si olama sągągo si dodaluali, te Israel hani nogo si olama sągągo si te dąį ilai. ");
INSERT INTO mps_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Tama nosali agai gesi bidi meba tagala palama, tama augwaligo te ofa dabe te Genuai Bidibolo igi pomainogo tagala palai. Augwaligo te siago tigidali dabo ofa eyu, tama te bulmakau dabe elama, tama God dali deli homu elama bidabo ofa dabe yai. ");
INSERT INTO mps_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Tama augwaligo te ofa ebadi, tama Mosesgo te ofa yai bulmakau dabego kaneme selama, tama dobolama, meba te pouba muyu, tama te kaneme meba munalubo te agai selama, te altaba sąwai. ");
INSERT INTO mps_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Tama agai te bomo yai po dąų wai elalubo buku selama, te Genuai Bidigo po te bukude elalubo te we bidi augwalibolo nedai. Augwaligo odolama, tama augwaligo te po wai, “Dago te Genuai Bidigo po tigidali odoyu, dolo wali paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Tama Mosesgo te poude muani kaneme selama, te we bidi dabeba te kaneme segeni sąsąga pali. Tama agai te po wai, “Te kanemego Genuai Bidi agai dage dali dąų wali bomo yai po dąų walai dao. Tama te bomo yai po dabe te dąų wali po page dao.” ");
INSERT INTO mps_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Tama nosali Moses, me Aron, me Nadap, me Abihu, me te Israel dabe genuai bidi, te bidi sese sela olama nogo si tama, augwali te bulu duba holai. ");
INSERT INTO mps_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Tama augwaligo Israel dabego God suai. Tama agai sągą dologode genuai sisi yai nai me deli, te be sai tiwai nai elaluai, tama te dagalu ula tiwai mu elaluai. ");
INSERT INTO mps_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mu tama, augwaligo God suai, tiali goli agai augwali dolobeo. Tama nosali augwaligo nai te bulude tuai. ");
INSERT INTO mps_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nosali Genuai Bidigo Mosesbolo te po wai, “Nage bulu duba ma holama, tama ena pąba bidagasao. Eno bomo yai po meba te masigi sawali side asęaibao. Tama eno te masigi si nagebolo menama, tama nago te bomo yai po te we bidibolo ola magameo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Tama tibaso, Moses aga sę bidi Josua dali, augwali si sisi elama, te Godigo bulu duba holainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Tama hasia sogo Mosesgo te Israel dabe genuai bidi augwalibolo te po wai, “Dage te be sęnama, bidibo pesagede bidiyu, tama da si ma asobo tonaluyu bidao. Aron de Hur si dage dali bidaibao. Tama bidi mebago po gasa bidi dali wabo elalubaso da, teda augwali te bidi si pageba pelama, tama te bidi sigo te po dodolomainao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosesgo te po ola silama, tama aga te Sainai bulu duba holali, tama pǫgo te bulu du halua sai. ");
INSERT INTO mps_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Tama Godigo genuai ula te bulu duba dulai. Tama Israel dabe augwaligo te Genuai Bidigo te ula te bulu dude te genuai sia ula ebo tiwai suai. Tama pǫgo te bulu du halualubadi, te nogo a naga olama me badu nogo deli sogo yai. Tama te a naga olama me badu si wali, te me deli sogo te Genuai Bidi te pǫ tomode bidiyu, Moses asomainogo i wai. ");
INSERT INTO mps_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Tama Moses te pǫ tomoba pelama, tama te bulu du ugwaba mu holai. Tama aga te bulu dude te bidi sese si 40 te tama sogo bidai. ");
INSERT INTO mps_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Tama Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Te Israel dabe augwalibolo po olama, tama augwaligo nai dabe selama, enabolo ofa momainao. Te we bidi augwaligo mena ofa nai mawainogo homu ebaso, te usu da, te nago sao. ");
INSERT INTO mps_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Nago e tobage tiwai nai dabe augwali dali sao, te kapa gol, me silva, me bras, ");
INSERT INTO mps_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","me te sipsip nisigo nigai hobi dabe, meba sisi yai, meba mama yai, tama te wiegi yai au yai name ugwa me, te gasa ugwa augwaligo meme nisigo nigai me, ");
INSERT INTO mps_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","te sipsip omaigo wali te augwaligo mama pengo pilai me, tama wiegi yai hasa sikau wali tamu ąįde elalubo me, te me badu ni akas, te tama nai dabe sao. ");
INSERT INTO mps_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Tama te lam sole udulabo oliv ni du wel me, te wel dali begelabo pauda me, te eno nai dabe dąį ilabo nai, tama te pauda wiegi yai denami elalubo te hano dali yabo nai me sao. ");
INSERT INTO mps_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Tama haniani bomai masigi, te mone hauwago abelabo masigi tiwai, te pris dabe tobolu bidi aga ugwade belabo ugwa, me te aga bobobage gudubo ugwade te hagawia badu muabo, te sao. ");
INSERT INTO mps_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Tama te we bidi augwalibolo te po olama, tama te ofa mani naigo augwaligo te eno ugwa be me deli sęnama, te wiegi yai tedali bede ena augwali dali tomode bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tama dagego te ugwa be me, te be tomode munalubo nai tigidali me, te dolo bugagia nigimainogo eyu, tama eno te piksa noma nagebolo hasia ola mawaibao.” ");
INSERT INTO mps_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tama dagego halobage me deli te akas ni namego nigao, tama te halobage bobobage nigabo usu ni te 110 sentamita, te genuai te 66 sentamita, tama ugwadu usu ni te 66 sentamita, te tama tiwai nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tama dagego wiegi yai kapa gol te augwaligo siade ulama, pobele bage sela sąwai selama, tama golgo te halobage bulu badu me, tomode me haluama, tama bobobage gol dage me deli te halobage sesegede bagulama kęąo. ");
INSERT INTO mps_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tama te halobage tolabo ring me si me si te golgo nigilama, tama te dwasianu halobage dolalubo sągąde kęąo. Tama me si me sągą side kęyu, me si me sągą side kęyu yao. ");
INSERT INTO mps_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tama dagego te ni akas pedai si dulama, te halobage tolabo te ni pedai si te golgo haluao. ");
INSERT INTO mps_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tama te ni pedai si te ring tomoba te me badu muyu, me badu muyu elama, te halobage tolasa pomainogo eyu, tama tiao. ");
INSERT INTO mps_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tama te ni dage si sesemane sogo te ringde elalumainao. Tama dagego te gudulamo dao. ");
INSERT INTO mps_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tama nosali eno nage te bomo yai po elalubo masigi sawali si mawaibao, tama nago te masigi si te halobage tomoba muao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Tama dagego te halobage po paliabo nai te wiegi yai kapa golgo nigao, te bobobage nigabo usu ni te 110 sentamita, tama te genuai usu ni te 66 sentamita dao. Te halobage da, te we bidigo dwai sęgę sali sela sąbo digi dao. ");
INSERT INTO mps_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tama dagego te gol meba selama, tama te hamago elama, tama te ensel mobo bidi noma si te golgo nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Tama me deli te halobage dolo nogo badu te halobage po paliabo nai elalubo digi te dolalumainogo eyu, tama me deli te pobase nogo badu dolalumainogo muao. Dagego te gol dage me deli selama, te halobage paliabo nai nigilama, tama aga te mobo bidi si me nigao. Tiali goli, dagego te nai sela nigilamuo, menio. Tigidali nigibo nai te deli nai tiwai naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Tama te mobo bidi si te we bidi dabego dwai sę yali sęgę sela sąbo digi dolaluyu, tama mego gesabidigo me gesabidiba tiwai tonaluyu, tama augwali sigo aba te halobageba me tonalumainao. Tama augwali sigo bogo dinigina pai elaluyu, tama te halobage te tama dualumainao. ");
INSERT INTO mps_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tama nagebolo eno te bomo yai po elalubo masigi sawali si menama, tama nago te masigi si te halobage tomoba munama, tama te halobage po paliao. ");
INSERT INTO mps_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Tama ena nage dali te dwai sęgę sela sąbo buluba sisinaibao. Tama ena te mobo bidi si daidu tomode ugwadu bidiyu, tama nage dali da si deliba sisinama, tama eno te bomo yai po tigidali nagebolo pusaibao. Tama nago te bomo yai po te Israel we bidi dabe augwalibolo menama, tama augwaligo wali pomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Tama dagego te ni akasgo te tebol sai me deli nigao, te bobobage usu ni te 88 sentamita, te genuai usu ni te 44 sentamita, tama te ugwadu daidu te usu ni 66 sentamita dao. ");
INSERT INTO mps_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tama te tebol sai te wiegi yai golgo haluama, tama bobobage golgo te tebol sesege badu bagulama, dąų wao. ");
INSERT INTO mps_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tama dagego te gol genuai ilibo te 8 sentamita ilama, tama dwasianu gol dagego te tebol sesege badu tigidali te obo bogegelao. ");
INSERT INTO mps_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tama dagego te tebol tolabo nai ring me si me si te golgo nigilama, tama te tebol sągą me si me si te badu kęąo. ");
INSERT INTO mps_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tama te ring dabe te tebol pąde ugwadu daide munaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tama dagego te ni akas si te tebol tolabo ni dulama, tama te ni si te golgo haluao. ");
INSERT INTO mps_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tama te wain ofa yabo genuai pou dabe, me te dwasianu pou dabe, me kap, me te botol me nigao. Dagego te nai dabe te wiegi yai golgo naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tama sesemane sogo dagego enabolo maiabo bret te tebolba naga munama, tama eno gedude munaluaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Dagego te lam sole dabe muabo nai me deli te wiegi yai golgo nigao. Tama te gol hamago elama, te lam dabe tolalubo nai dolaluabo pesage nigilama, tama dono nigilama, te lam nogo dabe muabo digi nigao. Tama te golgo naga aga au yabo ni duduli noma meba nigao. Tama te tigidali nigibo te deli tigi tiwai naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Te lam donogo nogo te a naga olama nogo me badu deli elalubo, te me sela te me badu muyu, te me sela te me badu muyu yao. ");
INSERT INTO mps_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Tama tigidali nogo deli delide usu nama, te ni duduli noma sela elaluyu, te ni amongo nigai tonobo tiwai yaibao. ");
INSERT INTO mps_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Tama te lam dono aga digi me te tiwai yao. Tama te ni duduli noma me si me si te amon ni aga duduli tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Tama te ni duduli yabe dwasianu dabe te lam dono nogo si si dologode naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Te dagego hama selama, te gol haluama, tama te nai dabe tigidali te deli nai tiwai naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tama dagego te lam a naga olama me badu nogo si nigilama, tama augwali te lam tolalubo naiba muao. Tama augwali te bugagia wasilama, augwaligo ula te ugwa be tomoba pomainao. ");
INSERT INTO mps_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tama te lamde mubo hobi dodolobo nai me, te pou me, te nai dabe te wiegi yai golgo naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Dagego te wiegi yai genuai sęgę elalubo te 35 kilogram golgo te lam tolalubo nai te nai dabe nigao. ");
INSERT INTO mps_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Dagego te nai nigibo sogo, dagego dua bugagia te piksa noma eno nagebolo e bulu dude ola mani, te dolo wali pelama, te nai dabe nigao,” Genuai Bidigo te po Mosesbolo wai. ");
INSERT INTO mps_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Genuai Bidigo po me ma weyu, Mosesbolo te po wai, “Dagego enabolo lotu po waiabo ugwa be te nogo si wiegi yai name ugwa te sisi yai, me te mama yai, te augwaligo hobigo au ilai ugwago nigao. Tama hobi selama, te ensel mobo bidi piksa noma dabe te name ugwade hobolama nigao. Te name ugwa te hobigo wiegi yai au ebo sę mu koneai bidi, agai te tobage au ebo sę emainao. ");
INSERT INTO mps_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tama tigidali te name ugwa te dedeli au yai tiwai naga nogo si nigao. Te ugwa dabe bobobage te 12 mita, tama te genuai usu sabo te 2 mita dao. ");
INSERT INTO mps_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tama a naga name ugwa dali bogo badu hobolama, tama te genuai moni bage kilasa pelama, tama gasa name ugwa te tiwai a naga hobolao. ");
INSERT INTO mps_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tama te genuai name ugwa side wadolabo sisi ugwade te ring meba nigao. Tama te ring dabe te genuai ugwa si sesegede kękę pao. ");
INSERT INTO mps_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tama hasia te name ugwade te ring bidi sese si olama nogo si te sesegede bebe peyu, te gasa bidi sese si olama nogo si me te si wali name ugwa sesegede kęąo. ");
INSERT INTO mps_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tama dagego te bidi sese si olama nogo si huk te genuai ugwa si dali tama te deli ugwa tiwai naga pedelemainogo, bebe pabo te golgo nigao.” ");
INSERT INTO mps_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Tama nosali dagego te genuai name ugwa deli te eno ugwa be haluabo nigao. Tama te name ugwa dage te nogo si olama sągągo deli augwaligo te kibu meme nisigo nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Te tigidali badu te deli tigi tiwai naga nigao. Bobobage usu ni sabo te 13 mita tama, te genuai usu ni sabo te 2 mita dao. ");
INSERT INTO mps_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tama a naga me badu dali hobolama, te bobobage ugwa deli tiwai naga pedelama, tama me sela me sela badu dali hobolama, tama te bobobage ugwa tiwai deli pedelaibao. Tama te me sela me sela wali te ugwa sigo pedelama, te ugwa be sunumi badu haluabo, te tama walolomainao. ");
INSERT INTO mps_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tama te bidi sese si olama nogo si ring te hasia ugwa sesegede kęnama, me te bidi si olama nogo si ring te ugwa si wali ugwade kęąo. ");
INSERT INTO mps_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tama dagego te bidi sese si olama nogo si huk bras nigilama, tama te huk dabe te ringba munama, te genuai ugwa si dali si bebe pelama, te deli ugwa tiwai naga elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Tama te usu sabo nai 1 mita te genuai ugwa te olo munalubo digi dagego te eno ugwa be tudi badude halalumainogo sula tagalao. ");
INSERT INTO mps_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tama te bobobage halubo ugwago te ugwa be bogo badu side bobobage aiya elaluama, te 50 sentamita me badu elaluyu, te me badu elaluyu yaibao. Tama tebogo te ugwa be tigidali mu halua sabo usu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tama te meme nisigo nigai genuai name ugwa, te nai ugwadu muabo gasa haluabo nai me si ma nigao. Me deli te omai sipsip wali te augwaligo mama pengo pilai tego nigao. Tama me deli te tamu ąįde bidibo hasa nogi sikau, te dabego waligo te ugwadu haluabo te nigao.” ");
INSERT INTO mps_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Tama dagego te ugwa be daga dolaluabo ni name dabe te ni akasgo nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Te tigidali ni name deli deligo usu sabo te 4 mita, tama te ni name genuai usu sabo te deli deli te 66 sentamita dao. ");
INSERT INTO mps_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Tama dagego te ni name dabe dolaluama, tama pagede dulama, te pęwadage sągą si si dula dula pelama, tama dagego tigidali ni name te tiwai naga nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tama dagego te tobage ni name bidi sese deli usu nabo te lotu ugwa be me bogo badu dolalumainogo eyu nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Tama dagego te kapa silva selama, tama te gelali ni page tiwai nai te bidi sese si te dedage elalubo te ni name sągą bulabo digi nigao. Te page nai si si te ni name deli deli dologode munaluyu, te tigidali daga ni name page dąų elalumainao. ");
INSERT INTO mps_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Tama dagego te tiwai naga te be gasa bogo badu me tama tiao. Te bidi sese daga ni name nigiyu, te bidi sese si silva te ni name page dąų wabo nai dabe nigilama, te silva pedai si te ni name deli delide muao. ");
INSERT INTO mps_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tama te be daga ni name te me sela me sela te ugwa be tudi badu, te sia ge dega sigi pabo badu, teba mumainogo nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tama te badu kona side te ni name si si nigiyu, tama dabelim yao. Te tama nigao. ");
INSERT INTO mps_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Tama te be dili habu badu te kona ni name si pagede wadolama, tama tigidali ugwaba wadodolo holao. Tama dagego te si dali si habu badu tama tiao. ");
INSERT INTO mps_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Tama te tudi badu te daga ni name te a naga olama nogo me badu sela elaluaibao. Tama nogo si olama nogo a naga tama me badu deli te silva te ni name page dąų wabo nai si usu nama, te deli deli usu dao.” ");
INSERT INTO mps_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","29","“Tama dagego te ni akas selama, tama te ni name tuabo bobobage ni meba nigao. Tama te bobobage ni dabe te ugwa be daga dolalubo ni namede dąų omainogo eyu, tama te wiegi yai kapa golgo te genuai ring dabe nigiyu, munalubo kęąo. Tama te dolalubo ni name tigidali me, te bobobage ni name tuabo ni dabe me, te nigo nigali nai tigidali te golgo haluao. Tama elama, tama te bobobage ni a naga tego te be me bogo badu dolalubo ni name dabede te ring dabego dąų wao. Tama bobobage ni meba te ni name ugwadu muyu, meba te ni name aiya badu muyu yao. Tama meba me tomode muyu, tama te be tudi badu gagalama, tama asama, tama te be gesabi baduba sabolaibao. Tama te be u bogo badu me te bobage ni namego tama naga tiao. Tama te be tudi badu daga, te sia ge dega sigi pabo badu, tede me te bobage ni te dolalubo ni name dabego ringba bulama, tama dąų walao.” ");
INSERT INTO mps_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Tama nosali dagego te lotu wabo ugwa be nigibo nai dabe silama, tama te be dodolobadi, te eno nagebolo e bulu dude ola mani te piksa subo tiwai yao.” ");
INSERT INTO mps_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tama dagego te ugwa be tomode walabo name ugwa gasa au wiegi yai genuai nigao. Tama te wiegi yai tedela yai hobi dabe siyu, te sipsip nisigo nigai sisi yai hobi dabe me siyu, tama te sipsip nisigo nigai mama yai hobi dabe me siyu yao, tama tego te wiegi yai name ugwa me deli nigao. Tama dagego gasa haniani wiegi yai hobi dabego te ensel mobo bidi noma bugagia mu te ugwade hobolao. ");
INSERT INTO mps_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tialima, te ni akas selama, te pos ni me si me si nigao. Tama te pos dabe te golgo haluama, tama te pos dabe te silvago nigai page me si me si tede bulao. Tama te gol huk meba nigilama, tama te ugwa dabe dąų elalumainogo te posde kękę piąo, tede walomainao. ");
INSERT INTO mps_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tialima, tama te ugwa te huk dabeba walama, te bomo yai po dąų wai po asęai masigi sawali si elalubo halobage, te nai te walobo name ugwa tudi badu muao. Tama te ugwago te lotu wabo be tomode dąį tiwai togolama, tama be habu si elaluaibao. Te sunumi pąde te polalubo be habu nogi wabo te Tedali Gasagi Yai Be Habu dao, te name ugwa dąį tudi badu te habu te Tedali Gasagi Yai Mu Be Habu dao. ");
INSERT INTO mps_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tama te bomo yai dąų wali po elalubo masigi sawali si elalubo halobage, aga te Tedali Gasagi Yai Mu Be Habu te be habu badu te halobage munama, tama te halobage po paliabo nai te halobageba muao, te dwai kolesaga yali sęgę sela sąbo madigi dao. ");
INSERT INTO mps_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tama tebol sai te gasa be habude muao, te nogi Tedali Gasagi Yai Be Habu dao, te ugwa be daga pąde, te sia ge pedalubo sesege pobase nogo badu muao. Tama ula ebo sole te gasa badu te be daga pąde muao, te tebol sai dolo si muao.” ");
INSERT INTO mps_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Tama dagego te wiegi yai genuai au yai name ugwa te ugwa be tų bagulabo nigao. Tama te wiegi yai au yai hobolama, te e tiwai hobi, te sis hobi me, te mama yai hobi me, te augwaligo sipsip nisigo nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tama te ni akas selama, tama a naga pos nigilama, te golgo haluao. Tama te pos dabede te huk gol kęnama, te ugwa walabode dao. Tama te page nai a naga te kapa brasgo nigao, dedage elalubo te pos dabe bulabo digi dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Tama Genuai Bidigo po ma naga weyu, te po wai, “Dagego te ni akas selama, te alta sai nigao, te moni halobage tiwai pąde dao. Te tigidali bogo sesege badu te deli tigi gagawai naga nigilao, te usu ni 2 mita 30 sentamita, tama te daide ugwadu usu sabo me ma te usu ni 1 mita 30 sentamita, tama usu nama nigao. ");
INSERT INTO mps_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tama te kibu bulmakau gąų tiwai nai me si me si te ni akasgo nigilama, tama deli deli dage badu dąų walama, tama te alta tigidali te brasgo mesegelao, te aga deli tigi naga elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tama bras selama, te sia keli sabo pou me, te dwasianu savol me, pou me, te ofa hasa mi dodolobo age yai ną me, tama te sia dage sela pabo plet nigibadi yao. ");
INSERT INTO mps_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tama dagego te moni bras sawali selama, tama polola polola pelama, tama te tama pololai bras sawali te alta halobage tomoba muao. Magi baso meni, aga ugwadu daide augwaligo te sia nogelama, tama te ofa mabo nai te siago udubadi, tama te keli aiyaba tuloluaibao. Tama bagua si nai deli deli te bras sawali nai habu badu munama, tolabo madi muabo nai te brasgo nigao. ");
INSERT INTO mps_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tama te alta halobage tomode te tigidali habu badude te aiya badudu usu siyu, ugwaba asiyu, tama tomode mu te dwasianu sai nigiyu, tede dąų wao. Tama te moni pololai bras sawali, aga te dwasianu sai dabe ugwadu daide munaluaibao, te alta halobage tomode. ");
INSERT INTO mps_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tama dagego te ni akas dage si selama, tama dulama, tama te dono si brasgo haluao. ");
INSERT INTO mps_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Tama dagego te alta tolasa painogo ebo sogo, te baguali dedageba te ni dono si munama, tama tolao. ");
INSERT INTO mps_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Dagego ni name selama, te alta te halobage tiwai nigao, tiali goli dagego te ni name te halobage habu pagede musiąma, te dedage elalumainogo yao. Dagego te eno nagebolo te bulu dude ola mani piksa te tiwai nigao,” tama po wali. ");
INSERT INTO mps_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Dagego te genuai gasagi yai ugwa obo ebogo te lotu ugwa be mesalo bagulao. Bobage nigibo usu sabo te 44 mita, te wiegi yai bobage ugwago obo tiwai bagulubo te me badu bogo badu nigilao. ");
INSERT INTO mps_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Tama te wiegi yai bobage obo ugwa walomainogo eyu, tama te kapa bras selama, tama pos te bidi sese deli nigao. Te pos dabe bulabo page dabe me te brasgo nigao. Tama te wiegi yai kapa silva selama, tama bobage dono dabe nigiyu, tama huk dabe hauwa nigiyu yao. Tama te pos dabe si si dolaluyu, tama pos me si tomode ugwadu te dono me deli dąų wao. Tama te donode te huk meba munama, tama te ugwa obo te huk dabede tama walao. ");
INSERT INTO mps_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Tama hasia te nigali tiwai naga, te me badu bogo badu obo bagulubo te tiwai nigao.” ");
INSERT INTO mps_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Tama te sia ge dega sabo badu obo, te ugwa me deli te bobage usu sabo te 22 mita te usu nama nigao. Tama pos nogo si badi, te pos page dąų walabo bras nai, te me nogo si te pos dodolabo madi dedage elalumainogo nigilao. ");
INSERT INTO mps_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Tama te sia ge pedalubo badu obo te tų elalubo madi, te usu sabo me te 22 mita dao. ");
INSERT INTO mps_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Te bobage ugwa walabo madi, te aga bobage usu nama, te 6 mita 90 sentamita, te tų si dali si badu dao. Te ugwa deli delide te pos sela te bras page dolalubo madi wawalo pao. ");
INSERT INTO mps_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Te tų dolo gasa wiegi yai name ugwa walao, te aga te 9 mita usu dao. Tama aga haniani te sipsip kibu nisigo nigai, husugu hobigo, me mama yai hobigo au ilama, hobolao. Tama dagego te pos me si me si te brasgo nigali pagede dodolama, tama te posde te bobage wiegi yai ugwa wawalo pao. ");
INSERT INTO mps_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tama dagego te obo pos si si te ba silva dabego tigidali dąų walao. Tama te bisigi gąų dabe te silvago nigilama, tama te pos dabe te ba silva kęnao. Tama bras selama, te pos dabe dodolabo madi nigao. ");
INSERT INTO mps_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Tama te obogo bobage usu nama, te 44 mita, te aga genuai usu ni te 22 mita, tama te ugwadu usu sabo te si 2 mita me 20 sentamita dao. Tama dagego wiegi yai tedela yai ugwa te obo bagulabo selama, nigao. Tama dagego te bras selama, te obo pos dabe dodolabo madi nigilao. ");
INSERT INTO mps_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Dagego te bras naga selama, te ugwa bede sę yabo tigidali nai te brasgo nigao. Te ugwa be dali, aga mesalo obo dali si tuloluidali weyu, te bono dabe te augwali side gebelama, tama bobobage nil dabe tǫba enama, tama te bono dabe te nil dabeba gebelao. Tama dagego te bobobage nil dabe te brasgo naga nigao.” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Nago te Israel we bidi augwalibolo te po olama, augwaligo te wiegi yai oliv ni dude sabo wel te lamde muabo sela asa wao, tama te lamgo ula te tigidali sogo elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Tama Aron aga ogomani dali, augwaligo te lam sole tolalubo nai eno ugwa be tomoba sela peyu, dodolomainao, te walali ugwa e badu me bogo badu, te bomo yai po elalubo halobage te ugwa tudi badu munalubao. Te ugwa bede ena te we bidi dali sisinabo be dao. Tama tigidali sogo Aron aga hani bagego wel te lamde munama, tama te lam ula ena bidibo madi ula elaluaibao, tama pio gagalama, kigamuba usu nigi paibao. Dage Israel dabe dali, dagego te nosali pedalobo wai dabe dali, augwaligo te eno te lamde wali bomo yai po sesemane sogo tolalua peyu, bidada paibao.” ");
INSERT INTO mps_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Genuai Bidigo po ma wadolama weyu, e tiwai po wai, “Moses, nosali nage ma peyu, nago naga ama Aron aga ogwa dabe dali augwali i wao, Nadap, me Abihu, me Eleasar, me Itamar, augwali asomainao. Tama nago augwali te Israel bage tomode selama, tama augwali eno pris bidi pedalomainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tama Aron prisgo gudabo ugwa wiegi yai tedali nigibadi, tama aga au ilama, tama gasagi yai pedelama, tama aga nogi te Israel we bidi gedude elalumainao. ");
INSERT INTO mps_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tama eno homu kolesaga menama, te ugwa me gasa haniani nai nigao wali, te bidi augwali i olama, tama augwalibolo po olama, tama augwaligo te Aron pris pedalobo sogo muabo ugwa nigimainao. Tama agai enade pris sę yaibao. ");
INSERT INTO mps_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Tama augwalibolo olama, te Arongo hagawiade muabo dwasianu ugwa dage deli au ilama, hobolao po wao. Tama augwaligo au yai ugwa me deli hobolobadi, me bobage ugwa deli badi, me te au ilai holobo ugwa, me tobolude bagulabo ugwa badi, me kukulu deli tama hobolao. Augwaligo te tedali gasagi yai ugwa dabe te Aron pris dali, te aga ogwa dabe, augwaligo me te ena tiwai pris sę emainogo yabo ugwa dabe nigao. ");
INSERT INTO mps_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Te sę bidi dabe augwaligo te husugu hobi, me mama yai hobi, augwaligo te kibu sipsip nisigo nigai, tama gol hobi me, tama wiegi yai name ugwago te ugwa dabe nigimainogo yao.” ");
INSERT INTO mps_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Tama augwaligo te husugu hobi, me mama hobi te augwaligo sipsip nisigo nigali, me te gol hobi selama, tama wiegi yai ugwago hobolama, bugagia au ilao. Te tobage sę ebo mu koneai bidigo naga te sę yao. ");
INSERT INTO mps_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tama augwaligo te ugwa daide ugwadu te ugwa dąų olaluabo kukulu si hobolao, tama kukulu te nagiba bolama, tama te tudiba abebolabo usu nama hobolao. ");
INSERT INTO mps_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Tama augwaligo te sisi hobi, me mama hobi selama, augwaligo te sipsip nisigo nigai, tama wiegi yai ugwa dage sobadi elama, te mǫ tiwai kukulu nigao. Tama augwaligo te kukulu te ugwa sesegede kęnama, tama te ugwa dage aga tiwai elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tama augwaligo nogi ebo wiegi yai masigi konilian si selama, te Jekopgo ogwa dabe nogo si olama sągągo si nogi mumainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Tama gomunai ogwade hasia gagalama, tama te nogo si olama sągą si te sabi ogwaba te nogi mubo siminigi pao. Augwaligo te 6 nogi te me masigide mubadi, te 6 nogi te gasa masigi mede mubadi yao. ");
INSERT INTO mps_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nago te masigide asębo po togobo koneai bidi me delibolo te sę menama, tama agai Jekopgo ogwa dabe nogi te masigi side asęmainao. Tama dagego te gol selama, te masigi si dąų olama tolaluabo au ilabo dwasianu nai si nigao. ");
INSERT INTO mps_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tama te masigi si te nagide bolai elalubo kukulu siba kęnama, tama te Israel hani augwali dąį yai tiwai elaluaibao. Tama Arongo augwali nogi te aga nagide tolasa bilibaso, tama Genuai Bidi eno sulama, tama eno bidi hani te eno homugo augwali sesemane sogo kone palaibao. ");
INSERT INTO mps_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Augwaligo te au yai nai dwasianu si te golgo nigibadi, tama te haliga si me golgo nigao. Augwaligo gol te dwasianu waia tiwai nigilama, tama te haliga nigibo kolesaga tiwaigo nigilama, tama te haliga si te au ilali golba kęnao.” ");
INSERT INTO mps_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Dagego te het prisgo hagawiade muabo dwasianu ugwa me deli nigao. Te nai da, te Godigo homu kolesaga koneainogo tiaibao. Tama dagego te tiwai nai naga augwaligo te het prisgo dwasianu ugwa dagede au ilali tiwai selama, nigao. ");
INSERT INTO mps_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tama dagego te dwasianu ugwa bobage ilibo usu sabo te 44 sentamita, tama aga genuai usu sabo te 22 sentamita dao. Tama bugagia tomode pobelama, te genuai agebele tiwai pobelama, tama tigidali badu me te tiwai dąį naga elaluaibao. ");
INSERT INTO mps_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","20","Tama dagego te me si me si nama hani bomai wiegi yai masigi te ugwade wasilama, kęnao. Tama hasia polalubo hani masigi augwaligo nogi wabo te rubi, me topas, me ganet, tama kęnao. Tama te hani side te masigi emeral, me sapaia, me daimon, te tama kęnao. Tama te kęnabo hani sela masigi tekois, me aget, me ametis dao. Tama te kęnabo masigi hani me si me si te beril, me konilian, me jaspa dao. Tama dagego tigidali deli deli masigide te golgo au tiwai dwasianu ilama, tama nosali te masigi dabe ugwago kęnao. ");
INSERT INTO mps_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Tama te nogo si olama sągągo si wali te tigidali masigi deli delide dagego te Jekopgo ogwa nogi deli deli te duga Israel hani tigidali dąį ela siyu, nogi asęsę pao.” ");
INSERT INTO mps_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Tama dagego wiegi yai gol selama, tama haliga si te hagawiade ugwa tolaluabo haliga si nigao. ");
INSERT INTO mps_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tama te ring gol si nigilama, tama te habu si badu te hagawiade muani ugwa daide ugwadu muao, ");
INSERT INTO mps_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","tama te haliga si te ring side kęnao. ");
INSERT INTO mps_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Tama dagego gasa te haliga gol si sesegede kęnama, te au ilali gol side tama gol au ilali te kukulugo te het prisgo ugwa tolalumainogo kęnao. ");
INSERT INTO mps_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tialima, tama dagego te ring gol me si ma nigilama, tama aiyadu habadu te ugwa elalubo madi hagawia badu te ugwa tudi pąbadu kęnao. ");
INSERT INTO mps_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Tama dagego te ring gol me si ma nigilama, tama te si te kukulugo te ugwa tolalubo madi kęnao, te gasa wiegi yai kukulu te tabi mǫgo bagulali madi pąde, te nai kęnao. ");
INSERT INTO mps_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tama sisi yai string hobi selama, te hagawiade elalubo genuai ugwade ring kęnama, tama tiyu da, te hagawiade elalubo ugwa te mǫ tiwai kukulude dąų ola somainogo elama, tama te hagawiade muani ugwa te munu me peda pogobeo.” ");
INSERT INTO mps_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Tama Aron te Tedali Gasagi Yai Be Habuba pabo sogo, agai te Israel hani tigidali nogi elalubo te dwasianu ugwa te aga hagawiade munama, sela pomainao. Tama ena Genuai Bidi, eno te ena hani bidi dabe augwali sulama, tama eno augwali sesemane sogo homugo kone palaibao. ");
INSERT INTO mps_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tama te masigi si te Godigo homu kolesaga somainogo te hagawia badu muani ugwa agebele tomode munama, tama Aron te Tedali Gasagi Yai Be Habu tomoba pabo sogo, ena Genuai Bidi ena agade bidibao, aga te masigi si dali tolasa pomainogo yaibao. Sesemane sogo agai te hagawiade te muani ugwa sela asomainao, te agai eno Genuai Bidigo magi sę te Israel dabe dali yainogo ebo te agai konemai hagede yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Te bobage ugwa te name ugwa dali kęnama, te dagego sisi hobi augwaligo te sipsip nisigo nigai naga selama, te ugwa nigao. ");
INSERT INTO mps_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Dagego te tobolu muabo madi dedage nigilama, tama dwasianu ugwa dage me deligo te dedage bagulama, tama te sesegede te dedage bomo yai pedelama, tama dedage genuai peda pabuo. ");
INSERT INTO mps_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Tama sisi hobi, me haniani mama yai hobi te augwaligo sipsip nisigo nigai, tama nai mebago te ni pomigranet wai tiwai nigao. Te ni wai du dabe te prisgo ugwa sese aiyadu hobolama, tama golgo nigai belo deli deli te ni pomigranet du dabe tomo tomode hobolama walalumainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Tama Arongo te bobage ugwa munama, te pris sę emainao. Tama aga ena te bidibo pąba te Tedali Gasagi Yai Be Habuba aselama, tama te buluba ma teda pabo sogo, te we bidigo te belo gela wabo odomainao. Ma, agai te bobobage ugwa gudasiąbaso da, teda eno aga ela muidalio.” ");
INSERT INTO mps_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Tama dagego te wiegi yai gol me deli selama, te ula ilibo nai medal me deli nigilama, tama e tiwai po te naide asęao, ‘Te Genuai Bidigo Tedali Gasagi Yai Nai da,’ te po asęao. ");
INSERT INTO mps_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tama sisi hobi selama, tama te gol nai tobolude muani ugwade kęnama, tama te het prisgo gesabidide ugwadu munalumainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Sesemane sogo Arongo te medal tobolude elalubo ugwa muao. Tama tibaso da, ena Genuai Bidi eno te Israel dabego enabolo mabo ofa ebo nai te eno saibao. Ma, augwaligo te ofa ebo kolesaga mebago geda mubaso da, teda, Arongo te tebo augwaligo dwai sę sęgę tolomainogo yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Dagego wiegi yai hobi selama, te holobo ugwa hobolao. Tama Arongo tobolude muabo ugwa wiegi yai nigilama, tama ugwa dage selama, tama mǫ tiwai kukulu nigilama, tama tede wiegi yai au ilama hobolao.” ");
INSERT INTO mps_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Tama dagego te holobo ugwa dabe, me te kukulu te mǫ tiwai, tama te tobolude muabo ugwa me, te Arongo ogwa dabe tigi munama, tama wiegi yai au mu ilama, tama te we bidi augwaligo gedude te Arongo ogwa dabe te nogi elaluyu, tama gasagi yai pedalomainogo tama tiao. ");
INSERT INTO mps_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Tama Moses, nago te ugwa dabe te naga ama Aron dali, aga ogomani dali, augwalibolo muao. Tama te ni oliv wel augwaliba gelama, te augwali pris dabe da olama, sa munama, tama te pris sę enabolo augwaligo emainao.” ");
INSERT INTO mps_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Tama augwaligo gudabo pęwadage ugwa belibo trausis te wiegi yai ugwago hobolama mao, te augwali tigi hale te bulu ulaba hania gagolama pedabuo. ");
INSERT INTO mps_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Tama Aron aga ogomani dali augwaligo te tiwai belibo trausis munama, te augwali alta pąba te Tedali Gasagi Yai Be Habu tomoba pelama, te pris sę ebo sogo, ma gasa sogo te augwali eno ugwa be tomoba painogo te ugwa belibo trausis munama, asomainao. Ma, te tobage sę augwaligo me isąma, te augwali tigi olo eno bidibo madi asobaso da, teda augwali dwai sę yali homu eyu, te eno augwali ela muaibao. Sesemane bidada pabo sogo Aron me, aga wąį dabe nosali pedalobo bage, augwaligo te bomo yai po wali pao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Genuai Bidigo po ma weyu, te po wai, “Megi eno nagebolo nago te Aron dali, aga ogomani me, augwali te pris dabe pedalomainogo yabo sę po waibao. Te kibu bulmakau omai wai me deli badi, te sipsip omai si, te keni kenigo augwali tigi dolisiąwai dabe sao. ");
INSERT INTO mps_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Tama te witgo plaua hasia polali mu, te sao. Nago te plauade te yis me mugio. Tama te plaua meba selama, te bret nigibadi, tama te plaua meba selama, tama te ni oliv wel dali taluama, te bret nigao. Tama plaua meba selama, tama te bisket meba nigibadi elama, tama augwalide te oliv wel pilao. ");
INSERT INTO mps_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tama te bret, me te bisket dabe te bonou wa me deliba munama, tama nago te bulmakau omai, me te sipsip omai si te ofa ilibo sogo te enabolo mao. ");
INSERT INTO mps_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tama Aron dali, aga ogomani augwali dali, te eno lotu ugwa beba odasa aselama, augwali wę paluao. ");
INSERT INTO mps_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nago augwali wę paluama silibo si, teda te pris ugwa dabe te Aronba muao. Holobo ugwa mubadi, tama bobage gudubo ugwa me muyu, tama dwasianu hagawiade mubo ugwa me te agabolo gudulama, tama te wiegi yai kukulugo agaba kęnao. ");
INSERT INTO mps_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tama ugwa te aga tobolude bagulama, tama te po elalubo medal gol te nai sao, te Genuai Bidigo nai dao, tama te tobolude muani ugwade kęnao. ");
INSERT INTO mps_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tama wel selama, te pris nigilali bidi dabe sa muabo wel, tama aga tobolude te wel gelama, aga te sęde sa muao. ");
INSERT INTO mps_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Nago Aron sa muna silibo si, teda agai ogomani odasa aselama, tama augwaliba te hobolo ugwa muao, ");
INSERT INTO mps_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","tama augwali tabide te kukulu bagulama, tama augwali tobolude ugwa dage dabe kęnao. Nago tama tiwai sę te Aron aga ogomani dali augwali te pris dabe nigiliyu, tama tiao. Tama te bidi dabe augwali dali, te augwa wąį ogomani nosali pedalubo bage, augwali hanigo naga te pris sę sesemane sogo ela paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Tama Moses nago te ofa yabo bulmakau te Deliba Sisinabo lotu ugwa be tų pąba sela aselama, tama Aron dali, aga ogwa dabe dali, augwaligo nogo te bulmakau toboluba mumainao. ");
INSERT INTO mps_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Tama eno gedude nago te bulmakau te ugwa be tų pąde elagameo. ");
INSERT INTO mps_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tama te bulmakau kaneme meba nago nogo danigo selama, tama te alta gąų dabeba muao. Tama te tigidali kaneme elalubadi te alta pagede gelao. ");
INSERT INTO mps_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tialima, nosali te tabide ili tigidali sobadi, te wiegi yai homu, me te dwasianu dini homu si te ili dali elalubadi selama, tama te tigidali altade ulama, te enabolo ofa ebo tiwai ilao. ");
INSERT INTO mps_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Tiali goli, te bulmakau mi, me wali, me te di tabi tomode elalubo, te olo madi bulu badu siago domainogo ulao. Te bulmakau da, te augwaligo dwai sę yali sela sąbo ofa yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Tama nago te ofa yabo sipsip omai gomunai wai sao. Tama Aron dali, aga ogomani dali, augwaligo nogo te sipsip toboluba mumainao. ");
INSERT INTO mps_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tialima, te sipsip elama, tama te kaneme selama, te alta me si me si bogo badu sąyao. ");
INSERT INTO mps_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tama nago te sipsip todogo pelama, tama te sągą si wę telabadi, te haliga dabe me tilama, tama tigidali te sipsip tobolu daiba ugwadu manao. ");
INSERT INTO mps_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tama tigidali te altaba munama, te ofa tiwai yao. Tama ena Genuai Bidi eno homu pemene wiegi yai te ofa elama, siago dabo denami ebo te eno homu pemene wiegi yai yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Tama nago te si wali sipsip selama, tama Aron aga ogomani dali augwaligo nogo te sipsip tobolu daiba ugwadu mumainao,” Genuai Bidigo Mosesbolo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","“Tialima nago te sipsip kibu elama, tama aga te kaneme dwasianu selama, tama Aron aga ogomani dali augwaligo dolo olo sabi badu te kaneme muao, tama augwali te kaneme dolo a nogo danide mubadi, te dolo a sągą dani badu muyu yao. Tama te poude munalubo kaneme tigidali te alta me si me si bogo badu sąsą pao. ");
INSERT INTO mps_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Nosali nago te altade munalubo kaneme meba, me te pris sa muabo wel sobadi elama, tama Aronba me agai gudali ugwaba segeni sąsąyu, tama aga ogomaniba me augwaligo gudali ugwaba segeni sąsąyu yao. Nago tama tiali da, teda Aron aga ogomani dali augwaligo gudali ugwa me, te tigidali augwali eno bage deli naga dao.” ");
INSERT INTO mps_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Tama nago te sipsip me togolama, tama te sipsip ili tigidali te pris bage augwali sa munama, tama ofa ilabo nai sao. Te nisali danu, me te haliga mesegelali delegabe ili, me te wiegi yai te sipsip kibu homu sobadi, te homu me si tede ili elalubo, tama dolo sągą badu te tele mi, te me sao. ");
INSERT INTO mps_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tama te tudi badu augwaligo enabolo te bo disiąwai yis meni yai bret ofa ilali nai, nago te deli deli haniani bret dabe sao, me deli augwaligo te oliv wel dali ulali, tama gasa augwaligo te oliv wel me te bisket dali me ulubeo. ");
INSERT INTO mps_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Tialima, te kibu mi, me te bret te Aron aga ogomani dali augwalibolo menama, tama augwaligo te ofa ilibo sę eyu, te ena gedude augwaligo te nai dabe ugwaba sidu geyu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tama augwaligo nogode munalubo te nai selama, tama te alta daiba ugwadu munama, te ofa ebo dabo siago tigidali domainao. Tama ena Genuai Bidi, eno te ofa ebo denami wiegi yai ebo te eno godolo mu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tama nago te Aron te pris sęde sa mumainogo elali sipsip kibu aga bau te nago nogogo tulama, tama sela bilibo, te eno gedude tama tiao. Tama te kibu bau te naga tuagameo.” ");
INSERT INTO mps_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Tama dagego te pris sa muabo sogo pedalubode, dagego te kibu bau, me te sipsip sągą tele mi selama, nago te pris sa muyu, ofa iliyu, tama nogogo tulama, eno gedude sabilao. Tama nosali te mi te pris dabe augwalibolo mao. ");
INSERT INTO mps_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Tigidali sogo Israel dabe augwaligo te kibu sipsip te ena dali deli homu pedelainu enabolo ofa mao, augwaligo te kibu bau, me te dolo sągą badu tele mi selama, tama te pris dabe augwalibolo mao. Te Israel dabe augwaligo te tiwai mabo ena Genuai Bidibolo momainao.” ");
INSERT INTO mps_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Te Aron isibo side da, teda augwaligo agai te pris sę yali ugwa dabe te aga ogomanibolo mao. Tama Aron aga hani bidi augwali te pris sę emainogo sa mubo sogo, te ugwa mumainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Tama te Arongo ogwago te aga aya Arongo het pris sę yali tiwai selama bidainogo ebo sogo, agai te a naga olama nogo me badu si sogo usu nama, te ugwa mubo usu selama, te ugwa mumainao. Tama te a naga olama me si sogo aga eno te Deliba Sisinabo ugwa be obo tomoba pelama, tama te Tedali Gasagi Yai Be Habu tomoba peyu, te sę emainogo yao.” ");
INSERT INTO mps_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Tama nago te Aron aga ogomani dali augwali te pris sę emainogo sa mubo sogo, nago te ofa ilali te sipsip mi selama, tama senede munama, tama te ugwa be obo bagulali tomode ulao. ");
INSERT INTO mps_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Tama pris dabe augwaligo te mi dali, te bret me te basket wade munalubadi selama, tama eno Deliba Sisinabo Ugwa Be tųde dulaluyu, tuao. ");
INSERT INTO mps_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Augwaligo augwa dwai sę yali sela sąyu ofa ilali nai te augwa ma tumainogo yao, te augwali te pris bidi dabe da olama, sa mubo sogo te tiwai yao. Te pris dabe augwaligo naga te nai tuyu, tama te we bidi augwaligo te nai me tugobeo. Menio. Te augwalide habu mu selao, te tedali mu gasagi yai nai naga dao. ");
INSERT INTO mps_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Tama te kibu mi me bret meba munalubadi te kigamuba sabalobaso da, teda te nai augwaligo me tugio. Te kibu mu habu selao, te tedali gasagi yai mu dao, tama augwaligo te siaba ulama, tama siago tigidali dela silimainao.” ");
INSERT INTO mps_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Nago te Aron aga ogomani dali augwali te pris sa mubo sę iliyu, tama eno nagebolo wali po gilama te a naga me te si sogo te sę dolo yao. ");
INSERT INTO mps_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tama tigidali sogo nago te bulmakau me deli selama, te dwai sę yali sęgę sela sąyu, ofa ilao. Tama te ofa ebogo te eno alta te wiegi yai eno gedude ilao. Tama te ni oliv wel te eno altaba sa muyu gelao, te eno nai naga dao. ");
INSERT INTO mps_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Nago te altaba te tiwai sę ilibo te 7 tama sogo te sę yao. Tama te alta te eno nai mu da weyu, te eno habu mu selaibao. Tama bidi me deligo nogogo me dįayu, ma magi nai me deligo te alta sai ugwadu daiba muyu da, te nai da, te tedali gasagi yai nai naga dao, te eno nai naga dao.” ");
INSERT INTO mps_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Tigidali sogo dagego te kibu sipsip wai si te kibu be deli yai elalubadi, tama te altaba munama, ofa yao. ");
INSERT INTO mps_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tama sipsip me deli te kigamu ofa eyu, tama gasa sipsip me te pio mu ofa yao. ");
INSERT INTO mps_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tama te sęgę deli yai plaua te witgo nigai dali, te sęgę deli yai oliv wel dali begelama, te hasia sipsip me deli dali ofa ilao. Tama me, dagego te sęgę deli yai wain ąį dali te ofa tiwai elama, te gelao. ");
INSERT INTO mps_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tama dagego te gasa sipsip me deli te pio ofa yao. Te deli tigi poai plaua me, te oliv wel me, te wain ąį me selama, tama te kigamu yali ofa tiwai gilama yao. Te tubo naigo ofa ebo dagego te nai ena Genuai Bidibolo mobao, tama te siago deyu, tama wiegi yai denami ebo te eno godolo ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Te siago tigidali domainogo ulubo ofa te dagego sesemane sogo te ofa nosali yao, te eno Deliba Sisinabo Ugwa Be tų pąde tigidali sogo te ofa ebo, te eno sueibao. ");
INSERT INTO mps_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Tama eno genuai ula te ugwa beba pedaliyu, tama te badu digi te eno bulu elaluyu, tama tedali gasagi yai bulu tama nigilaibao. Tede me ena te Israel we bidi dali deliba sisinaibao.” ");
INSERT INTO mps_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Tama tibaso, te Deliba Sisinabo Ugwa Bede alta si da, te eno nai da weyu, te eno sa muaibao. Tama eno te Aron aga ogomani dali augwali sa munama, augwali te pris sę tiwai emainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Tama ena dage Israel dabe tomode bidiyu, tama ena dagego God bidaibao. ");
INSERT INTO mps_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Tama dagego ena bugagia koneama, ena Genuai Bidi da weyu, ena duga God dao, tama eno naga dage te Isip tǫde selama, tama eba odasa asai. Tama tiyu, ena dage tomode bidaibao. Ena digi, ena God, dagego Genuai Bidi dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Tama Godigo po ma weyu, te po wai, “Dagego te ni akas selama, tama alta me deli nigilama, te denami ilabo nai pauda ulubo alta tama nigao. ");
INSERT INTO mps_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Te alta bobage usu sabo te 45 sentamita, tama aga genuai te tiwai te 45 sentamita, tama te ugwadu usu sabo te 90 sentamita dao. Tama dagego te bulmakau gąų tiwai me si me si te alta dononama, ugwadu muabo te nai dulao. ");
INSERT INTO mps_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tama te me si me si habu badu mesegelama, tama ugwadu me, tama aga gąųde me, te wiegi yai golgo haluyu, tama bobage golgo te alta bobegelama, obo tiwai nigiyu, kęnao. ");
INSERT INTO mps_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tama te ni munama, te alta tolabo madi te alta me badu gaga nigiyu, me badu te gaga nigibadi yao. Tama te gaga nigali nai si te aiyadu te alta bobegelali gol pąde dagego te sesegede kęnao. ");
INSERT INTO mps_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tama te ni akas dage si selama, te alta tolabo nai dulama, tama te nai si te golgo mesegelao. ");
INSERT INTO mps_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tialima, te ugwa be tomode te genuai walobo ugwa dąį te bomo yai po dualali halobage, te dąį ugwa e badu te alta muao, te dwai sę ebo sęgę sela sąbo madi ugwadu pąde, te halobage munalubo digio. Tama te sęgę sela sąbo madi te eno dage sisinaibao.” ");
INSERT INTO mps_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Te tigidali sogo kigamu Aron aselama, te lam sole sisi yagasaibao, tama te tiagasobo sogo agai te pusu wiegi yai ebo pauda meba te altaba denami elainogo ulao. ");
INSERT INTO mps_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Tama agai te tiwai naga te pio te lam sole domonagasu asobo sogo tiao. Dagego te ofa ena Genuai Bidibolo tigidali sogo nosali me te tiwai ofa elalua pao. ");
INSERT INTO mps_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Dagego te gasagi yai nai dabe te altade ofa igio. Te haniani denami ilibo pauda me te eno dagebolo habu selali nai, te kibu, me wit, me wain ąį, te tama nai me e altade ofa igimio. ");
INSERT INTO mps_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Tigidali kibu bede deli sogo Arongo te alta wiegi yai ilibo te sę eno gedude yao. Te tiwai sę yainogo da, dagego te sęgę sela sąyu te ofa ilali kaneme me badu sobadi, tama te nigilali alta gąų dabeba muao. Dagego te tebo sę te tigidali kibu bede yao. Tama tiyu, te alta te habu mu seliyu, tedali gasagi yai elaluaibao. Te Genuai Bidi eno nai naga da waibao.” ");
INSERT INTO mps_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nosali Genuai Bidigo po Mosesbolo weyu, te po wai, ");
INSERT INTO mps_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Nago te Israel bidi nogi selama, tama te bukude asębo sogo, tigidali bidi deli deligo mone meba enabolo mao. Ma, meni baso da, teda genuai gasi dwai mu pedelama, te sogo augwali dolaibao. ");
INSERT INTO mps_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tigidali bidi dabe augwali nogi sali bage, augwaligo te mone ge a naga te enabolo te ofa tiwai mao. ");
INSERT INTO mps_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Augwaligo te tigidali bidigo kibu be te 20de gagalama, te kibu be ugwaba holali bidi dabe nogi selama, tama tigidaligo te mone enabolo mao. ");
INSERT INTO mps_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Te mone bidigo te agai mone hauwa me menamuo, te magi nai meni yai bidigo te dwasianu mone me mayu me igio. Tigidaligo te mone ge a naga, te tama naga enabolo mao, te tama tiyu augwa yali sęgę abeleyu da, teda augwali me isigobeo. ");
INSERT INTO mps_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Te monego da, te eno lotu ugwa bede elalubo nai te dobaso da, te nai te monego gasa abelama, dodolabo mone dao. Te augwa bidibo ula abelabo mone eno te mone sulama, tama eno homu augwaliba muyu, tama augwali tonaluaibao.” ");
INSERT INTO mps_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Tama Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Dagego te bras meba selama, tama te genuai pou me deli nigibadi, te pou muabo page me nigao. Tama te altade te ugwa be si tomode te tǫba te pou munama, tama te poude te wę pągąnao. ");
INSERT INTO mps_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Tama Aron aga ogomani dali augwali nogo sągą te węde telamainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Te augwali eno ugwa be tomoba painogo, me ma te altade te siago ulubo ofa dabe me yabo homu eyu da, teda augwaligo nogo sągą bolo hasia ąįgo tedelama, tama eno beba asobaso da, teda augwali me isigobeo. ");
INSERT INTO mps_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Mu tama, augwali isidali weyu, augwa nogo sągą ąįgo tedelao. Augwali dali, augwa nosali ame nabo wai dabe dali, augwaligo te bomai po sesemane sogo wali peyu, bidimainao,” wali. Te pris dabe sa mubo wel po wali ");
INSERT INTO mps_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Tama Genuai Bidigo po Mosesbolo ma weyu, te po wai, ");
INSERT INTO mps_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Megi nago te wiegi wiegi yai denami ebo nai dabe sao. Hasia bolo te denami ebo nai sanda mea sao, te nai sęgę te 6 kilo te elalubao. Tama te sinamon pauda meba te wiegi yai denami elalubo, te aga te 3 kilo, tama te tobage wiegi yai denami ebo awi dili badi, te aga sęgę me te 3 kilo dao. ");
INSERT INTO mps_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Tama te ni kasia waligo nigai pauda meba sao, te aga sęgę 6 kilo dao. Tama te oliv wel sęgę 4 lita elalubo te nai dabeba gelama, ");
INSERT INTO mps_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","tama te sanda nigibo sę mu koneai bidigo ebo sę tiwai eyu, te nai dabe bugagia taluama, te sanda tiwai pedelemainao. Te nai dabe da, te eno nai sa muabo nai elaluaibao.” ");
INSERT INTO mps_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“Tama nago te wel dwasianu selama, tama eno dage dali Deliba Sisinabo Ugwa Beba dwasianu geliyu, te bomai po munalubo halobageba gelibadi, ");
INSERT INTO mps_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tama te bret muabo tebol, me te tebolde munalubo nai dabeba me gelao, tama te lam dabe tolalubo nai, me aga nai dabeba badi, tama te denami ilibo altaba me gelao, ");
INSERT INTO mps_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","tama te tigidali siaba uluyu ofa ebo alta me, te aga nai dabeba dali, te wę paubo pou me, te aga pageba me, te tiwai naga yao. ");
INSERT INTO mps_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nago te nai dabe te eno tedali gasagi yai nai dabe mu da olama, tama te we bidi augwalibolo habu mu selao. Ma, bidi me deligo, me ma wego, me ma magi nai dabego te naiba dįya idali weyu, te me habu seliyu, gasagi yai tedali pedelama, tama te eno nai naga dao.” ");
INSERT INTO mps_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Tialima, nosali te wel selama, tama dwasianu te Aronba, me te aga ogomani, augwaliba gelama, tama augwali pris pedelama, tama eno sę emainogo sa muao. ");
INSERT INTO mps_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tama nago te Israel we bidi augwalibolo e tiwai po wao, ‘Dage dali, te duga hani nosali nosali pedalubo bage, dagego te wel selama, tama te dago Genuai Bidigo nai naga da olama, sa muao. ");
INSERT INTO mps_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Dagego te wel te olo bidi dabeba geligimio. Tama dagego te deli tigi poai wel nigigio. Te Godigo tedali gasagi yai nai naga da weyu, tama dagebolo habu selibao. ");
INSERT INTO mps_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ma, te bidi me deligo te deli tigi poai wel nigilama, te pris meni yai olo bidi mebabolo te wel gelibaso da, teda te bidi aga te Godigo we bidi hani bidibo tomode me bidigobeo,’ te po pusao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Tialima, Genuai Bidigo Mosesbolo po ma weyu, te po wai, “Megi eno homugo dagego te wiegi yai denami yabo pauda meba nigiyąo. Te pauda te deli tigi poai dabe naga usu nama, elalumainao. Te pauda mea badi, te augwaligo te lalaigo nigai nai dabe badi, tama te bomai nai te galbanum pauda kanemego nigai me, te ni balsam kanemego nigali, te nai dabe tama sao. ");
INSERT INTO mps_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tama te nai dabe sesa pelama, tama te denami yabo nai pauda bugagia taluama nigao, te wiegi yai denami ilibo nai nigibo bidigo sę ebo tiwai yao. Tama tamu dwasianu te pauda denami wiegi yai tedali gasagi yai ilimainogo, te tamu muao. ");
INSERT INTO mps_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Te nai meba te pauda tiwai mu pedelemainogo, bugagia te nai me badu haluao, tama te ugwa be tomoba eno gedude sela pelama, tama te bomai po munalubo halobage pąde muao, te ena dage dali deliba sisinabo madi. Te denami ebo nai pauda te tedali gasagi yai nai mu dao, te olo nai mu menio. ");
INSERT INTO mps_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Tama dagego duga nai da, te homu elama, tama te tiwai nai munu me nigilamuo. Te Genuai Bidi eno nai naga dao, te tama homu naga yao. ");
INSERT INTO mps_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ma, bidi me deli aga homugo naga agai te denami ebo nai sanda tiwai me deli odainogo nigali da, teda te bidi aga te eno we bidi hani tomode me bidigobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Tama Genuai Bidigo Mosesbolo e tiwai po wai, ");
INSERT INTO mps_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Odao, eno te bidi Besalel sa muani, te Urigo ogwa, tama te Hurgo wąįgo ogwa, te Juda hani bidi, ");
INSERT INTO mps_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","4","tama agabolo eno homu kolesaga te bomo mawai. Tama eno agabolo te wiegi wiegi yai nai gol, me silva, me bras nigabo wiegi yai homu kolesaga mawai dao. ");
INSERT INTO mps_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Tama eno agabolo te gasagi yai bomai masigi dabe togolama te duliyu, tama te ni namede, me te nide, me haniani nai togolama dulumainogo te homu kolesaga mawai, tama te ugwa be au ilibo gasa tigidali haniani sę emainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tama me te Oholiap te eno sa muani, te Ahisamakgo ogwa, tama te Dango hani, tama aga te Besalel dali te sę emainogo yaibao. Tama eno genuai wiegi yai homu kolesaga te gasa bidi dabe mebabolo menama, tama augwaligo eno te po weyu nigao wali nai nigimainogo te usu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Augwaligo te eno ugwa be sę ebadi, te bomai po muabo halobage nigibadi, te aga paliabo nai da te sęgę sela sąbo madi tiwai me, te tigidali ugwa bede muabo nai dabe nigagameo. ");
INSERT INTO mps_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Tama augwaligo te tebol sai dali, tebolde muabo aga doado bage dali nigibadi, tama te lam tolalubo nai dali, te nai aga doado bage, te me nigaibao. Augwaligo te lam sole tolalubo nai te wiegi yai golgo naga nigibadi yao, te aga dali elalubo nai dabe me. Tama augwaligo te denami ilibo alta me nigagameo. ");
INSERT INTO mps_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Tama augwaligo te siago tigidali domainogo te ofa eyu, te ulabo madi te alta nigiyu, tama aga doado bage me, tama te nogo sągą ąį telayabo pou nigibadi, tama te pou muabo page me nigaibao. ");
INSERT INTO mps_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Tama augwaligo Aron aga ogomani dali augwaligo gudabo ugwa te wiegi yai mu hobolama, nigagameo, te bage augwaligo te ugwa gudama pris sę yaibao. ");
INSERT INTO mps_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Tama augwaligo eno nai dabe sa muabo wel nigiyu, tama te Tedali Gasagi Yai Be Habu badu wiegi yai denami iliyu ulabo pauda nigaibao. Augwaligo te nai dabe te eno nagebolo wali po tiwai gilama tama te nai dabe nigimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","13","Tialima, Genuai Bidigo Mosesbolo te po olama, te Israel we bidibolo te po omainogo yai, “Te Sabat side te olo bidiyu, toma nabo side dao, tama te Sabat side sesemane sogo dage eno po odolama, olo bidiyu, toma nao. Te Sabat side eno dagebolo te sa mubo tiwai megi mayu, tama nosali me tigidali sogo tama naga tiao. Tama tebo sę dagego konemainogo, te ena digi ena dagego Genuai Bidi dao, tama eno dage te tedali gasagi yai we bidi hani pedalomainogo ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Te toma tubo side te Genuai Bidi eno side dao, tama tiyu, dage te sogo toma tuyu, olo bidao. Ma, bidi me deli aga te sogo sę yali da, agai te eno bomo yai po sela sąbao, tama te bidi dagego aga ela muao. ");
INSERT INTO mps_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Te tigidali Sarere dagego sę yabo side te 6, te tama side sę yao, tiali goli te dei 7, te me deli sogo da, te eno olo bidibo sogo, tama te olo bidiyu, toma nabo genuai side dao. Dagego te olo bidibo side sę ebo bidi dabe tigidali ela muao. ");
INSERT INTO mps_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Dage Israel bage te sogo toma nao, magi baso meni, te polobadu te po dąų wai elaluai, dagego po dąų olama, te wali paibao wai dao. Tama tibaso, nosali dagego tama tidi pao. ");
INSERT INTO mps_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Te side te po dąų wabo tiwai elama, te ena tomode me te dage Israel bage dali te po sesemane sogo elalua paibao. Magi baso meni, ena Genuai Bidi eno te dagalu de tǫ si nigali, te 6 te tama sogo nigilama, tama te 7 wali, te me deli sogo eno te sę tigidali tagalama, tama ena toma tuyu, olo bidai dao.” ");
INSERT INTO mps_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Te Godigo po te Sainai bulu dude Moses dali wali sogo, agai te masigi name si te bomo yai po God aga digi nogogo asęai, te Mosesbolo mawai dao. ");
INSERT INTO mps_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Te Moses te Sainai bulu duba holama, tama bobage sogo bidali, tama aga gesege mu yali, tama aga polo me asobeo. Tama te we bidi augwali te Aron pageba sisinigi pelama, agabolo te po wai, “Te magi nai te bidi Mosesba pedelali, te dago konebeo, te bidigo da te Isipde selama, tama da odasa eba asai. Tama nago god me deli nigilama, tama pabodu polasa peyu, tama da tųdu odasa pomainogo yaibao.” Augwaligo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tialima, Arongo augwalibolo te po wai, “Dagego duga we dabego olode walalubo gol, me duga wai dabego olode walalubo gol me sesa pelama, tama selasa aselama, enabolo magasao.” ");
INSERT INTO mps_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Arongo te po obaso, te we bidi dabe augwa olode walaluali gol dabe pepede pelama, tama sela aselama, agabolo magasai. ");
INSERT INTO mps_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tama agai augwaligo te olode au yali gol dabe selama, tama ulama, tama te ąį tiwai pedelai. Tama agai te tǫde dedage me deli augwaligo te bulmakau noma tiwai nigilama, tama te ąį tiwai pedelai gol teba gelama, tama te bulmakau tiwai pedelai. Tama agai hwą ge selama, te golgo nigai bulmakau noma bugagia dodolai. Tama nosali te we bidi augwaligo te po wai, “Odiąo! Te nai aga da Israel bagego god dao. Agai da Isipde selama, tama da odasa eba asai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Arongo te tebo sulama, tama agai te bulmakau pąde te alta sai me deli nigai. Tama agai te po wai, “Do da, dago Genuai Bidibolo genuai nogi mayu, genuai nai tueibao.” ");
INSERT INTO mps_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tialima, te sogo nosali kigamu mu, te we bidi dabe augwaligo te ofa eyu, te siaba ulabo kibu bulmakau dabe sela asali. Tama augwaligo homu kolesaga deliba naga muainogo te ofa yabo kibu sipsip dabe me sela asai. Tama augwaligo te nai tuyu, te bomai wę tuyu elama, tama nosali te bidi dabe augwali pelama, te we dabe dali gagali igi pai. ");
INSERT INTO mps_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Tama Genuai Bidigo Mosesbolo te po wai, “Nage polo e bulu dude bidali tagalama, aba dulao. Te naga Isipde odasa asali we bidi dabe augwaligo dwai kolesaga hauwa megi ebao. ");
INSERT INTO mps_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Tama eno po weyu, augwalibolo te wali pao wali tų polo geda munama, tama augwaligo te bulmakau wai te golgo nigilama, tama agabolo lotu po weyu, tama agabolo ofa ilibao. Tama augwaligo te po wai, ‘Odao,’ wali, ‘te aga dago god dao. Agai da Isipde selama, odasa asai dao.’ Te po megi obao. ");
INSERT INTO mps_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Tama ena God eno te we bidi augwali eno koneanio. Augwali da, te hagoma mu ebo we bidi dao. ");
INSERT INTO mps_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Te eno augwali dali sębę mu elama, tama eno augwali mu dolaibao. Tama nago ena me togolamuo, mu menio. Tama nosali eno nage me, te naga hani ogomani dali, augwaligo te Israel bage hasegelama, tama genuai we bidi hani mu pedelaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Tiali goli, Mosesgo te Genuai Bidigo homu bea sainu, agai bomonama gedu haluasa po aga Genuai Bidi Godibolo e tiwai po wai, “Genuai Bidio, tiyu nago sębęgo naga we bidi augwali dolomainogo sula tagalamuo. Nago te we bidi augwali te Isipde te nago naga genuai bomogo digi te augwali selama, odasa asai dao. ");
INSERT INTO mps_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ma, nago te tiwai kolesaga augwalibolo ebaso da, teda te Isip dabego te po waibao, ‘Godigo aga we bidi augwali dali dwai homu yai. Tama tibaso, augwali agai te Isipde selama, tama augwali odasa asali, te augwali te bulu dude mu dola silama, tama tigidali ela muani da,’ te po wabuo. Tiali goli, Genuai Bidi, tagalao. Tama nago te sębę yali homu te nago tagalama, tama nago homu kolesaga hasegelama, tama te we bidi augwali nago me dolamu dao.” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","“Nago naga sę bidi Abraham, me Aisak, me Jekop, te homugo koneao. Tama nago te bomo yai po augwali dali dąų wali po, te homude koneao. Nago bomo yai po dąų mu weyu, e tiwai po wai, ‘Eno mu po obao, eno te dagego wąį nǫų dabe te dagebolo hauwa mu, te hǫ tiwai dageba mawaibao. Tama eno po dąų weyu, te eno dagebolo mawaiba wali te tǫ, teda te tǫ te eno duga wąį nǫų dabe augwaliba mawaibao. Tama augwali sesemane sogo mu te tǫde bidada paibao,’ nago te po wai.” ");
INSERT INTO mps_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Tama Mosesgo te tiwai gedu haluasa po obaso, tama Genuai Bidi aga homu ma hasegelama, tama aga te we bidi dolainu yali nai te aga we bidiba me tagala palobeo. ");
INSERT INTO mps_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Tialima, Moses te bulu dude bidali tagalama, tama aba duliyu, te Godigo bomo yai po asęani te masigi pedai si sela dulai. Godigo po te masigi si te si dali si badu te po asęai dao. ");
INSERT INTO mps_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Godigo digi te masigi si nigilama, tama te masigi side te bomo yai po asęani, te bugagia ma dodolama todogo pai. ");
INSERT INTO mps_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Tama Josua te Sainai bulu dude a badu gana Moses asobo tonaluyu bidali. Tama Moses teba dulama, tama augwali si aba pidubadi, tama Josua agai te we bidi dabe augwaligo te i wabo po daga agai odai. Tama agai Mosesbolo e tiwai po wai, “Ae, Moses! Eno te we bidi bidibo madi te wąbi hwįyu kulukulu wabo odalio.” ");
INSERT INTO mps_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Tiali goli, Mosesgo te po wai, “Menio. Te bidigo wąbi hwįbo te aiyaba elaluyu, i wabo te tiwai me ebeo. Ma, te wąbi hwįbode te bidi dabe aiyaba elalubaso, te gela wabo tiwai menio. Eno te tęąbi wabo dogoni naga odobao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tama Moses te we bidi bidibo pesage pąba sabolama suali, te bulmakau gol, me te we bidi augwali tęąbi idubo suali, tialima tama aga sębę mu yai. Tama agai te tolasa asali te masigi si, agai te bulu du pageba sąnama, tama te masigi si pepeda pai. ");
INSERT INTO mps_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Tama Mosesgo augwaligo te nigali bulmakau selama, tama siaba ulai. Tama te gol ąį tiwai pedelama, tama nosali kedau elama, dila saide, agai te hamago haluama, te olo pauda tiwai pedelai. Tama agai te pauda gol te pabo ąįba sąwai. Tama sąsą bila silama, tama Mosesgo te tiwai ilama, te Israel dabe augwaligo te ąį tumainogo yalio. ");
INSERT INTO mps_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Tama agai Aronbolo te po hanalu wai, “Te e we bidi augwaligo magi sę nagebolo ebaso, tama nago augwaligo te dwai kolesaga mu emainogo sula tagalaliwe?” ");
INSERT INTO mps_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Tialima, Arongo po wei ponoyu, te po wai, “Genuai bidio, nago ena dali sębę igio. Nago te we bidi hani augwaligo ebo kolesaga koneai dao. Augwaligo dwai kolesaga yainogo bomo mu ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tama augwaligo enabolo e tiwai po wai, ‘Dago te bidi Mosesba magi nai pedelali, te dago konebeo, te bidigo da Isipde selama, tama da eba odasa asai. Tama da te pabo tųde polasa pabo god me deli nago nigao.’ ");
INSERT INTO mps_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Eno odolama, tama eno te gol olode elalubo we bidibolo te po olama, tama augwaligo te gol pedelama, enabolo mao wai. Tialima, augwaligo enabolo mawai, tama eno te gol te siaba ulalio. Tama polo te bulmakau wai aga digi odolali pedelalio,” Arongo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosesgo koneani, te we bidi augwaligo dwai kolesaga subigila emainogo yali, tama Arongo augwali dąų wabo usu ebeo, te homu yali. Tama agai te homu yai, tiyu augwa boi bidi dabego augwali sulama, tama posobo po me gisugu maidali, te homu yai. ");
INSERT INTO mps_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tama tibaso, Moses pelama, te obo tųba doligi pelama, tama te tiwai i wai, “Te mena bidigo te Genuai Bidi wali paiba wida, teda te bage te ena bidibo madi asao.” Tialima, te Livai hani bidi tigidali augwali aselama, aga pąba dolagasai. ");
INSERT INTO mps_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Tama agai augwalibolo te po wai, “God, te da Israel bagego Genuai Bidigo te po wai, ‘Dage tigidaligo te bobage ge hwą selama, tama te u bidi dabe bidibo madi te pesageba pelama, tama te tibo god wali pabo bidi dabe ela muao, te ama, me te abagi dabe, te dage dali pąde bidibo bage, te dao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tama te Livai dabe augwaligo te Mosesgo wali po selama, te tiwai sę yai. Tama te sogo naga augwaligo te bidi sese umabo bidi dabe, 3,000 mu ela muai dao. ");
INSERT INTO mps_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Tama Mosesgo te Livai dabe augwalibolo te po wai, “Megi dagego te bidi dabe augwali ela muani, te wai dabe me, te duga ama dede dabe, augwali meba da, te duga wai dabe, ama dede dabe, tiali digi augwaligo dwai sę ebaso, dagego augwali ela muani. Tama dagego te kolesaga yaligo naga, dage te Genuai Bidigo pris dabe tau sabo bage pedelaibao. Tama tiyu, megi Genuai Bidigo wiegi yai sę dagebolo ilaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Tama nosali sogo Mosesgo te we bidi augwalibolo te po wai, “Dagego te yali sęgę, te Genuai Bidi bidibo madi te bulu duba ma holama, tama eno agabolo te dagego sęgę sela sągowe naga, te eno agabolo hanalua sueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tialima, Moses te bulu duba ugwa holama, tama Genuai Bidibolo te tiwai po wai, “Homu dene mu ebao. Te e we bidi augwaligo te genuai sęgę sabo sę mu yalio. Augwaligo te tibo god me deli nigilama, tama augwaligo lotu po agaba wai dao. ");
INSERT INTO mps_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Tiali goli, megi eno nagebolo hanalu obao, te nago homugo augwaligo sęgę sela sąyąbo homu ebaso da, teda nago augwaligo sęgę sela sąyao. Ma, nago hagela homu ebaso da, teda eno nagebolo te po hanalu waibao, te nago naga we bidi augwali nogi asęai elalubo bukude te eno nogi asęai elalubo, te deli naga te sela sąyagameo.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Tiali goli, Genuai Bidigo Mosesbolo te po wai, “Menio. Eno te dwai sę yali we bidi augwaligo nogi naga te eno sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tialima, megi nage pelama, tama te we bidi augwali selama, tama eno nagebolo te po wali te buluba pao. Odao, eno Ensel Mobo Bidigo dage te pabo tųdu odasa paibao. Tiali goli, nosali da, te dene mabo sogo ena asiyu, tama te dwai sę yali we bidi augwali eno dene mu ilaibao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tialima, Genuai Bidigo nosali genuai gasi dwai me deli te bidi dabego dwai sę yali wei ponoyu, tama te gasi augwaliba tagala palai. Magi baso meni, augwaligo po bomo yai Aronbolo olama, tama agai te bulmakau wai te golgo nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Megi da, Genuai Bidigo Mosesbolo e tiwai po wai, “Nage dali, te nago Isipde odasa asali we bidi me, dagego e bulu taga peyu, tama eno dagebolo po dąų weyu, dagebolo te mawaibao wali, te buluba piąo. Polobadu eno Abrahambolo, me Aisak dali, me Jekop dali, te tiwai po wai, ‘Tama eno te tǫ te duga hani wąį nǫų dabe augwalibolo mawaibao,’ wai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Tama eno ensel mobo bidi me deli te dage pabo madi polasa tagalama, tama eno te Kenan hani, me Amor, me Hit, me Peres, me Hivi, me Jebus, te hani augwali eno sela sągi paibao. ");
INSERT INTO mps_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Tama dage te wiegi wiegi yai haniani nai holobo madi, te ili elalubo wiegi yai tǫba bidigi paibao. Tiali goli, ena digi te ena dage dali me pogobeo, magi baso meni, te dage hagoma ebo we bidi dabe dao. Tiyu, te ena dage dali peyu da, te dage eno te tųde dolabuo,” wali. ");
INSERT INTO mps_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Tama Mosesgo te we bidi augwalibolo te Genuai Bidigo te bomai po mobaso, tama augwaligo homu sęgę elama, tama augwaligo te wiegi yai au te tigide me mubeo. ");
INSERT INTO mps_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Tama Genuai Bidigo po Mosesgo te Israel we bidi augwalibolo omainogo te po wai, “Dage te hagoma ebo we bidi dabe mu dao. Te ena dage dali pobaso da, teda eno dage dolabuo. Te ena dage dali pęwadage sogo naga bidagasali goli, te eno dage tigidali dolabuo. Tialima, odiąo, te dagego tigide elalubo ring gol te nai dabe tigidali peda sąwai madi, tama eno mena tiwai kolesaga dagebolo yabo te eno homugo bugagia konemainogo yaibao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tama augwaligo te Sainai bulu du taga pabo sogo, augwaligo te tigide muani te au dobage te me mubeo. ");
INSERT INTO mps_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Tigidali sogo te Israel dabe augwali pelama, te bidigi pabo madi, tama augwa ugwa be sę eyu yai, tama Mosesgo me ugwa be me deli selama, tama augwaligo te be sę ebo pesage te bulu badu te dwasianu digibulu gana te ugwa be sę eyu yai. Tama agai te ugwa be nogi te tiwai nogi poai, te God Dali Sisinibo Ugwa Be da wai. Tama dego te Genuai Bidigo homu kolesaga te koneainogo da, teda aga te ugwa beba paibao. ");
INSERT INTO mps_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tama Moses te ugwa beba pabo sogo da, te tigidali we bidi augwa ugwa bede bidiyu, tama augwali hodaluama, tama augwa ugwa be tųde dolaluyu, tama Moses te ugwa be tomoba pabo suai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tama Moses te ugwa be tomoba pai madigi, tama te pǫ aselama, te ugwa be tų pąba dolagasai. Tama Genuai Bidi te pǫ tomode bidiyu, tama Moses dali po miai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tama te Israel we bidi augwali te augwa ugwa be tųde dolaluyu, tama te pǫ te ugwa be pąde bidibaso da, teda augwali tobolu basi gulama, tama lotu po Godibolo wai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tama Genuai Bidigo Moses dali po miani, te bidigo aga abagi dali po mibo tiwai gilama yai. Augwa si te po ola silama, tama Moses aga te bidibo pesageba ma asiyu yai. Tiali goli, Mosesgo sę ebo ogwa bidi, te Josua, te Nungo ogwa, aga te tomode me bididuai. Agai te Sisinibo Ugwa Be munu me taga pisąwai dao. ");
INSERT INTO mps_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosesgo e tiwai po Genuai Bidibolo wai, “Nago enabolo te e we bidi augwali te augwa tǫba odasa pao, te po wai. Tiali goli, nago enabolo te mena bidigo ena tau somainu yabo bidi te ena dali me pao wabo po, te nago me wabeo. Tama nago te po wai, ‘Eno nage bugagia koneani, tama nage eno godolo ebo da,’ wai. ");
INSERT INTO mps_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Tama nago ena godolo eba wida, teda eno homugo nago enabolo te nago homu kolesaga ola menama, tama eno nage bugagia konemainu, tama sesemane sogo eno te nago godolo yabo kolesaga naga yaibao. Tama eno homugo me te naga digi sa muani we bidi te nago homugo ma konemainogo, te homu eno ebo dao.” ");
INSERT INTO mps_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tama Genuai Bidigo te po wai, “Ena digi nage dali hodobo peyu, tama nagebolo wiegi yai homu nagame ebo kolesaga mawaibao.” ");
INSERT INTO mps_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Tialima, Mosesgo Genuai Bidibolo te po ma wai, “Te naga digi te da dali pisąwani da, teda nago da ede bidali te taga pomainogo te me tigio. ");
INSERT INTO mps_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ma, nage da dali pisąwani da, te gasa bidi hani augwaligo mena tama te nago ena me, te naga we bidi dabe dali, godolo ebo te koneaibawe? Tiali goli, nage da dali pobaso da, teda te gasa bidi hani augwaligo koneama, te da we bidi te gasa we bidi hani tigidali tiwai meni, da te gasagi yai bage mu da waibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Tialima, Genuai Bidigo Mosesbolo te po wai, “Eno te nago wali po selama, te sę yaibao. Magi baso meni, eno nage godolo eyu, tama eno nage bugagia koneai dao.” ");
INSERT INTO mps_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Tama Mosesgo Genuai Bidibolo e tiwai po wai, “Eno homugo nago genuai ula ebo gesabi enabolo waselao.” ");
INSERT INTO mps_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Tama Genuai Bidigo Mosesbolo po wei ponoyu, te po wai, “Eno nagebolo te eno wiegi yai ula tigidali ola mawaibao. Tama eno nogi nagebolo pusuyu, eno e tiwai po waibao, ‘Ena Genuai Bidi dao.’ Odao, te eno olo tau siyu mabo wiegi yai kolesaga eyu, tama eno bidi me delide homu dene eyu, tau sobaso da, teda eno te sę eyu naga ebo dao. ");
INSERT INTO mps_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tiali goli, nago ena gesabi me sugobeo, magi baso meni, te bidi me deligo eno gesabi subaso da, teda aga isaibao. ");
INSERT INTO mps_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Suao, te genuai masigi me dedeli ena pąde elalubao. Tama nage te masigi daiba ugwadu dolugulao. ");
INSERT INTO mps_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tama eno gesabigo genuai ula te nage pąba asobo side, eno nage te masigi dudulawi me deli tomoba munama, tama nage eno nogogo mesegelama elalubadi, ena ela soaibao. ");
INSERT INTO mps_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Tama nosali eno dagala sąbosi, tama nago ena tudi badu naga sumainogo yaibao. Tiali goli, nago ena gesabi me sulamuo,” te po wai. ");
INSERT INTO mps_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nosali Genuai Bidigo po Mosesbolo weyu, te po wai, “Nago te masigi dage si togolama, tama bugagia dodolama, tama nago te sąnama toga pali masigi sawali, te tiwai si ma emainao. Tama eno te hasia polobadu togolama asęani tiwai po naga ma asęaibao. ");
INSERT INTO mps_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Tama nago te masigi si dodola munama, tama do kigamu nage te bulu duba holama, tama ena dali da si deliba sisinaibao. ");
INSERT INTO mps_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Te bidi me deli nage dali me asomainogo menio. Eno homugo te gasa bidi te e bulu duba asela bidagasobo, te eno homu hagela ebo. Tigidali aiyade naga bidalumainao. Tama te sipsip bulmakau dabe me te bulu du pąba aselama, te nosa dabe munu me tuagaselamu dao.” ");
INSERT INTO mps_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Tialima, tama Mosesgo te masigi pedai si te polasa togali te tiwai elama, tama agai te masigi sawali si te Sainai bulu duba kigamu digi mu tolasa holali, te Genuai Bidigo agabolo wali po selama, tama tiwai sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Tama Genuai Bidi te pǫ tomode bidama, tama dulama, tama Moses dali te bulu duba ugwadu dolagaselama, tama aga digi, aga Genuai Bidi nogi page po pusagasai. ");
INSERT INTO mps_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Tama aga te Moses pąba pelama ela soali, tama i weyu, te po wai, “Ena Genuai Bidi, ena Genuai Bidi dao. Ena God, tama ena te olo tau siyu mabo wiegi yai kolesaga badi, te homu dene ebo page bidi dao. Tama eno sębę polo me egobeo. Eno tigidali we bidi godolo mu elama, tama eno ena wali po tigidali wali pabo dao. ");
INSERT INTO mps_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Te eno we bidi hani hauwa godolo iduyu, tama te eno po dąų wali tiwai gilama, tama eno augwaligo hagoma ebo haniani dwai kolesaga te sela sąbo dao. Tiali goli, te dwai sę ebo bidi dabebolo eno dene ilaibao. Tama eno augwaligo wai dabebolo me, tama augwaligo nosali pedalobo wąį te wai dabebolo me, tama te sela, me te me si me si haniba te tiwai dene mabo sę naga augwaliba pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tama Godigo po ola silibo si, tama polo Moses te tǫba degasa dulama, tama Godibolo lotu po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Tama Mosesgo te po wai, “Genuai Bidi, nago ena godolo mu ebo da wida, teda eno homugo nage da dali pomainogo homu ebao. Te mu tama, te e we bidi augwaligo hagoma eyu, dwai kolesaga ebo dao, tiali goli eno homugo te dago tigidali dwai kolesaga ebo me, tama dago sęgę me, te sela sąnama, tama da selama, tama naga we bidi tiwai mu bidimainogo te homu eno ebo dao,” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Tama Genuai Bidigo Mosesbolo te po wai, “Megi eno bomai po dąų dage Israel dabe dali yainogo ebao. Te nago we bidi augwali gedude te eno genuai bomai sę te eno gasa tigidali we bidi hani dali polobadu me isąwai te sę yaibao. Tama tigidali gasa we bidigo te ena Genuai Bidigo dage eno tau siyu, haniani sę ebo te augwaligo sulama, tama augwali homu hauwa elama, tama noma saibao. ");
INSERT INTO mps_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tama megi eno dagebolo te mawainogo ebo bomai po tigidali te dagego odoyu, wali piąo. Ena te dage pabo madi te ena polasa pelama, tama eno te Amor dabe badi, te Kenan dabe me, te Hit dabe me, te Peres dabe me, te Hivi dabe badi, te Jebus, te hani dabe augwali eno sela sągi paibao. ");
INSERT INTO mps_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Tama dua bugagia, te dagego megi painogo ebo te bulu tǫde bidibo bidi dabe dali te abagi nami bidabo bomai po munu me dąų wagimio. Tiyu, augwaligo ebo kolesagaba dage kekelama, tama dage tulaluama, tama dage tigidali dolabuo. ");
INSERT INTO mps_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Menio. Dagego augwaligo te lotu wabo nai dabe dolao. Te alta dabe, me te pos masigi dabe te pepedelama, tama augwaligo tibo god we Asera piksa te ni dagede elalubo, te togolama sąyao.” ");
INSERT INTO mps_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Ena Genuai Bidi, tama dagego ena deliba naga lotu po wao. Dagego te tibo godiba lotu po me wagimio. Magi baso meni, te tibo god me deligo ena bidibo hasegelainogo ebaso, te eno aga me gogologobeo. Tede ena sębę mu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Dagego te bulu tǫde bidibo bage augwali dali te abagi nami bidabo bomai po dąų munu me olamuo. Augwaligo te tibo godiba lotu wabo dao. Tama dagego augwali dali te bomai po dąų obaso da, teda augwaligo dagebolo te augwali dali deliba sisinabo po hanaluama, tama dagego te augwaligo tibo godiba ofa ilali te kibu me te nai dabe tuaibao. ");
INSERT INTO mps_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Tama tiyu, dage Israel gesi bidi dabego te gasa hani gesi wegi mani sabuo. Te dagego tama tiali da, teda te we dabego te augwa bidi kekelama, tama te bidi dabe augwaligo ena tagalama, tama te tibo god dabeba lotu waibao. Te eno gedude te kolesaga te penani ela bilibo kolesaga tiwai yaibao.” ");
INSERT INTO mps_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Dagego te tibo god dabe te aingo nigilama, tama augwaliba lotu po me wagimio. Te habu mu dao.” ");
INSERT INTO mps_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Dagego te Bo Disiąwai Nai Bret te tubo sogo te genuai side te homugo me gegeda pigimio. Dagego polua Abipde te Isip taga soali, tama tigidali kibu bede dagego te yis meni yai bret te poluade, te a naga olama nogo me badu si, te tama sogo naga tuyu, te eno dagebolo polobadu wali gilama tama tiao.” ");
INSERT INTO mps_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Te dagego tigidali gomunai ogwa, me te dagego bulmakau sipsip dabe te gomunai wai omai dabe me, te enabolo naga mao. ");
INSERT INTO mps_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tiali goli, dagego homugo te duga te bidi duabo donki kibu gomunai wai ma abela homu ebaso da, teda duga sipsip wai me deli selama, te donki hasegelama, tama sipsip wai ofa yao. Tama dagego ma abelesiąwani da, teda dagego te donki mage togwao. Tama me te duga gomunai ogwa tigidali te ma abelao.” “Te dagego enaba lotu po wagasabo homu ebaso da, te dagego ofa yabo nai deli digi sela asao, olo asigio.” ");
INSERT INTO mps_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Tama tigidali Sarere te dagego sę yabo side te a naga olama nogo kibisa, te tama sogo naga sę yabo sogo te elalubao, tiali goli te 7 wali, te me deli sogo te sę me egio, te habu selai. Te gide tǫ elabo sogo, ma te nai inayu tau yai nai sisinibo sogo elalubaso da, dagego te olo bidibo side te sę me igimio.” ");
INSERT INTO mps_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Dagego homu wiegi yai pemene te genuai side te inawai nai siyu, te wiegi yai homu pemene yali side te dagego homu koneama, te side te wit hasia inawai te sali side dao. Tama me te poluade te ni du inayu tau yai sali side, dage te dwasianu tolu yabe dabe bede genuai sogo bidali side, te dagego homugo ma koneao. ");
INSERT INTO mps_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tama deli kibu bede sela sogo, dage bidi tigidaligo ena Tigidali Nai Tonalubo God bidibo madi aselama, lotu po wagasao, te duga Israel duga Genuai Bidi dao. ");
INSERT INTO mps_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nosali da, eno dagego tǫde megi te bidibo we bidi hani augwali sela sąnama, tama dagego tǫ dąį genuai ilaibao. Tama dagego enabolo lotu wagasobo sogo, te tigidali kibu bede sela sogo naga te lotu po weyu, tama dagego tama tibadi, te boi bidigo dagego tǫ sainogo homu me egobeo.” ");
INSERT INTO mps_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Dagego te kibu sipsip, meme, bulmakau dabe te enabolo ofa ilibo sogo, dagego te yis elalubo bret te dali te enabolo ofa me elamuo. Tama dagego te Godigo dage Ela Soali Side te bodolu koneama, tama dagego te ofa eyu elali sipsip mi tigidali te dagego me tula silisąbaso da, teda dagego te nai dage dabe te kigamu tuaiba homu elama me mugimio.” ");
INSERT INTO mps_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Te tigidali kibu bede dagego gide te polasa ina yani wiegi yai nai te Genuai Bidi eno beba sela asao.” “Dagego te kibu meme ame pę te seneba pęgęnama, tama te meme digi wai te ąįgo me ulainogo me igimio.” ");
INSERT INTO mps_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Tama Genuai Bidigo Mosesbolo e tiwai po wai, “Nago te po dabe te buku me delide asęao, magi baso meni, te tigidali po nage dali, me te Israel dabe augwali dali, te po dąų wali page e dao.” ");
INSERT INTO mps_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Tama Moses te Genuai Bidi dali te bulu dude te bidi sese si, 40 sogo bidai. Tama agai nai deli me, ąį me, te me tubeo. Mu menio. Tama Genuai Bidigo te bomai po te Mosesgo te sela holali masigi side asęai. Te po te Godigo bomo yai nogo si po dabe dao. ");
INSERT INTO mps_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Tama Mosesgo te bulu du tagalama dulali sogo, agai te bomai po elalubo masigi si me te sela dulali. Agai te Genuai Bidi dali po mianigo, tama Mosesgo gesabi ula mu yai. Tiali goli, aga digi te tiwai ula yali, te agai me konebeo. ");
INSERT INTO mps_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aron dali te we bidi augwaligo te Moses gesabi ula yai sulama, tama augwali wi elama, tama augwali aga pąba me pai menio. ");
INSERT INTO mps_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tiali goli, Mosesgo augwali i obaso, tama Aron dali, te Israel tobolu bidi dabe dali, augwali aga pageba pelama, tama Mosesgo augwali dali po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Tama nosali, te gasa Israel bage meba tigidali te aga pąba pelama, tama Mosesgo augwali tigidalibolo dali te Genuai Bidigo agabolo te Sainai bulu dude mani bomai po, te augwali tigidaliba te po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosesgo te po augwalibolo ola silibo si, teda aga te ugwa pedai selama, tama aga gesabi geme duala siyu yai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Tiali goli, Moses te lotu ugwa be tomoba te Genuai Bidi dali po miainogo pabo sogo, agai te gesabi dualaluali te ugwa pedai sela sąnama, tama buluba ma asiyu, te gesabi halusiąma asai. Aga te bedu buluba asobo si da, teda te we bidi augwalibolo te Genuai Bidigo agabolo wali po tigidali te augwalibolo wai dao. ");
INSERT INTO mps_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Tama te we bidi augwaligo te Moses gesabi ula ebo suai. Mosesgo augwalibolo te po ola silibo si da, teda aga gesabi ma haluama, tama aga te Genuai Bidi dali po ma migi painogo ebo sogo da, agai te ugwa pedai ma sela sąnama, te Genuai Bidi dali po migi pabo dao. ");
INSERT INTO mps_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosesgo te tigidali Israel we bidi i olama, asobode augwalibolo e tiwai po wai, “Genuai Bidigo te po wali, dagego te e bomai po wali piąo, te po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Te Sarere dagego sę yabo side te 6 sogo te sę yabo side te elalubao. Tiali goli, te 7 wali, te me deli sogo te olo bidiyu, toma naga niąo, tama te sę idali weyu, habu mu selao, magi baso meni, te Genuai Bidigo side dolo dao. Te side te bidigo, ma te wego, te sę ebaso da, teda dagego aga ela muao. ");
INSERT INTO mps_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Te dwasianu sę dagego bede te sia udulabo sę elalubaso, te me habu selai dao, te olo bidiyu toma nabo side dao.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","5","Nosali Mosesgo te Israel dabe augwalibolo e tiwai po wai, “Genuai Bidigo te po wai, megi dagego nai meba agabolo mao. Te agabolo nai mawainogo ebo we bidi, augwaligo e tiwai nai dabe sela asomainogo yao, te gol, me silva, me bras, ");
INSERT INTO mps_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","tama te gasa au wiegi yai name ugwa badi, te sisi yai, me te mama yai sipsip nisi, tama te augwaligo te meme nisigo nigai ugwa badi, tama te nai dabe sela asa wai. ");
INSERT INTO mps_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Tama augwaligo te omai sipsip wali te mama pengo pilai, te sela asomainao. Tama augwaligo te wiegi yai hasa nogi sikau wali, te tamu ąįde elalubo, te wali me, te ni akas dage dabe, te sela asobadi, ");
INSERT INTO mps_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","tama te lam wel me, te wel dali taluabo denami ebo haniani nai me sela asiąo. Te taluali wel da, te Godigo nai dabe sa mubo wel dao. Tama wiegi yai denami ebo pauda, te denami ilabo nai dao, te me sela asomainogo yao. ");
INSERT INTO mps_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Tama augwaligo te wiegi yai masigi meba sela asiyu, te ugwa aulubo nai, tama te het pris bidi hagawiade muabo dwasianu masigi muai ugwa dage, teba muabo masigi dabe, te me sela asomainogo yao,” Mosesgo Genuai Bidigo po tama pusali. ");
INSERT INTO mps_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Dage tomode te nai dabe nigibo koneai bidi dabe augwali bidibo, tama te bage aselama, te Genuai Bidigo dagebolo niga wali nai dabe tigidali nigao. ");
INSERT INTO mps_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Tama te ugwa be sę badi, tama te haluabo nai dabe me nigiyu, tama te bisigi dabe te obo ni dili me, te obo eyu te pipili pabo ni dabe me, te tigi ni pos bras dali, te pos page dąų walabo halobage, te nai dabe nigao. ");
INSERT INTO mps_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tama augwaligo te bomai po muabo halobage nigibadi, tama augwaligo te halobage tolabo ni togobadi, tama augwaligo te gol selama, te sęgę sela sąyąbo madi te pesage nigiyu, tama augwaligo te bomai po muani halobage haluabo name ugwa nigibadi yao. ");
INSERT INTO mps_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Tama augwaligo te tebol nigiyu, te aga tede muabo nai dabe me nigibadi, tama te tebol tolabo ni dulubadi, tama augwaligo te God gedude te tebolde muabo bret me niga po wai. ");
INSERT INTO mps_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Tama augwaligo te lam muabo nai, me te aga nai dabe dali nigao. Tama augwaligo te ula yabo lam dabe me, te wel me nigao.” ");
INSERT INTO mps_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","“Tama augwaligo te denami ebo nai pauda ulabo alta nigiyu, tama te alta tolabo ni me togwao. Tama augwaligo te Genuai Bidigo nai da olama, te sa muabo wel me nigiyu, tama wiegi yai denami yabo pauda me nigao. Tama te ugwa be tųde walabo name ugwa me nigao. ");
INSERT INTO mps_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Tama augwaligo te ofa yabo te alta nigibadi, tama alta tomoba mubo pololai moni bras nai, te bras nai dage nigiyu, te alta tolabo ni dage si me, te altade muabo nai dabe tigidali me nigao. Tama te ąį pauabo genuai pou me, te aga muabo page me, nigibadi yao. ");
INSERT INTO mps_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Tama augwaligo te ugwa be bagulali te obode muabo ugwa nigibadi, tama te obo tigi ni pos dabe nigibadi, te tigi ni pos page dąų walabo halobage me nigao. Tama augwaligo te obo bagulali madi tųde muabo name ugwa me nigao. ");
INSERT INTO mps_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Tama augwaligo te ugwa be kęabo te bono dabe nigibadi, te obo kęabo me te tǫde enebo bobobage nil bras, te haliga bono bomonabo nai dabe badi, tama nigao. ");
INSERT INTO mps_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Tama augwaligo te Aron aga ogomani dali augwaligo te Tedali Gasagi Yai Be Habuba augwali te pris sę igi pabo sogo muabo ugwa, te gasa wiegi yai mu nigao.” ");
INSERT INTO mps_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Tialima, tama tigidali Israel we bidigo Moses tagalama, tama palio. ");
INSERT INTO mps_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Tama Mosesgo wali pogo te Israel we bidi hauwa augwali homude enebaso, tama augwaligo te Mosesgo wali po tiwai gilama te sę yainogo yali. Tama augwaligo nai dabe te Genuai Bidiba sela pelama, agai ugwa be sę emainogo yai. Tama augwaligo te lotu wabo nai dabe tigidali me, tama te ugwa bede sę yabo tigidali nai dabe badi, te pris dabego gudabo ugwa nigibo nai dabe tigidali sela pai. ");
INSERT INTO mps_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tama tigidali we bidigo homugo, te augwaligo e tobage haniani au dobage dabe sela pali, gudubo ugwade walobo pin me, olode walobo ring me, nogode mubo ring me, magede domobo beli me, tama golgo haniani doado bage sela pai. Tama te we bidi dabe augwaligo te doado bage te Genuai Bidibolo te ofa tiwai elama, mu mawai dao. ");
INSERT INTO mps_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tama meba we bidigo te gasa au wiegi yai ugwa, me te sisi yai, ma te mama yai sipsip nisigo, me te meme nisigo, me te omai sipsip wali te augwaligo mama pengo pilai badi, te tamu ąįde elalubo wiegi yai hasa sikau wali badi, te tama doado bage elaluali, te augwaligo te nai dabe sela asai dao. ");
INSERT INTO mps_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tama tigidali we bidigo te silva me bras elaluali, te augwaligo sela aselama, tama Genuai Bidi magasai. Tama te ni akas elaluali bidi dabego te ugwa be sę yabo ni sela asai. ");
INSERT INTO mps_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tama te hobi gudubo koneani tigidali we, augwaligo te sisi yai me mama yai sipsip nisi selama, te hobi gudai. Tama augwaligo te wiegi yai ugwa nigabo te tedela yai hobi nigai. Tama augwaligo te hobi dabe dali, te wiegi yai tedela yai name ugwa me, selasa asai. ");
INSERT INTO mps_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Tama te meme nisigo te hobi gudubo bugagia koneai we dabe mebago, te hobi augwaligo bugagia gudai dao. ");
INSERT INTO mps_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Tama te tobolu bidi dabe augwaligo wiegi wiegi yai masigi te ugwaba, me te het pris bidigo hagawiade mubo ugwa, me te aga magede mubo ugwade muabo masigi dabe selasa asai. ");
INSERT INTO mps_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Tama augwaligo te gasa tigi, me tedali yai pauda, me wel, me sanda te wel nigilama, te Genuai Bidigo naiba sa muyu nigabo nai, me te lam dabeba muabo nai, me te denami emainogo munama nigabo nai dabe selasa asalio. ");
INSERT INTO mps_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tigidali Israel we bidigo Genuai Bidibolo nai maiabo homu yali bage, augwaligo dwagi yai homu eyu, te Genuai Bidigo sę te Mosesbolo yao wali, te sę yainogo, te nai dabe olo sela asai. ");
INSERT INTO mps_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosesgo te Israel dabe augwalibolo e tiwai po wai, “Genuai Bidigo te Besalel sa muani, te Urigo ogwa, tama Hur te aga wąį, te Juda hani dao. ");
INSERT INTO mps_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Tama Genuai Bidi Godigo digi aga noma bidi te agabolo mani, tama agai homu kolesaga wiegi yai elaluyu, tama tigidali haniani sę ebo kolesaga wiegi yai koneai elaluai. ");
INSERT INTO mps_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Tama agai homude bugagia koneama, tama te gol, me silva, me bras, te nai dabego te sę emainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Tama agai te wiegi yai au yabo masigi togobo me, te ni dulama te todogo pabo sę me, te gasa au yabo nai meba togobo dabe me, te tigidali agai koneai. ");
INSERT INTO mps_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Tama Genuai Bidigo wiegi yai kolesaga te Besalel de Oholiap, te bidi sibolo mawai, te Oholiap aga te Ahisamakgo ogwa, te Dango hani dao. Tama augwali sigo te gasa bidi dabego te sę dabe emainogo ola mabo te usu yaibao. ");
INSERT INTO mps_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Genuai Bidigo te bidi si te haniani sę yabo homu kolesaga mawai dao, te masigi togobo sę, me te gasagi yai au yai piksa noma nigibo sę me, te wiegi yai gasa au yai ugwa hobolobo sę me, te hobigo au ebo sę me, te augwaligo sisi yai me mama yai sipsip nisigo augwaligo nigai. Augwali sigo te tigidali nai me, te piksa noma dabe me augwaligo nigainogo ebo, te augwali sigo te sę dabe me ebo te usu yaibao,” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Te Mosesgo po ma weyu, te po me wai, “Genuai Bidigo wiegi yai homu kolesaga te Besalel de Oholiap, te bidi sibolo dali, te tigidali sę ebo koneani bidi dabebolo dali, te sę emainogo eyu mani, tama augwaligo te Godigo ugwa be sę yabo nai tigidali nigibo te usu yaibao. Tama te bidi dabego naga te tigidali nai dabe te Genuai Bidigo po wali gilama te sę yainogo yao.” ");
INSERT INTO mps_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Tama nosali Mosesgo Besalel me, Oholiap badi, i weyu, tama te Genuai Bidigo wiegi yai homu kolesaga mani bidi augwali tigidali i wai. Tama te sę ebo godolo homu ebo bidi dabe augwali asali, tama Mosesgo augwalibolo te sę gagalama yao, te po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tama Mosesgo te bidi dabe augwalibolo te Godigo ugwa be sę emainogo te Israel dabego sisinani nai tigidali te augwalibolo mawai. Tama tigidali sogo kigamu te Israel we bidi augwaligo te Godibolo te ofa tiwai maiabo nai dabe selasa pabo sę idu geai. ");
INSERT INTO mps_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Tama tibaso, te ugwa be sę ebo bidi dabe augwaligo te nai dabe sela asobo sulama, tama augwa ebo sę tagalama, ");
INSERT INTO mps_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","tama aselama, Mosesbolo e tiwai po wagasali, “Te we bidi augwaligo te doado bage hauwa sela asali. Te tigidali sę yabo nai dabe te usu yali, te Genuai Bidigo dabolo te sę emainogo wali po gilama. Tama te doado bage meba hauwa te olo munaluaibao,” augwaligo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Tialima, te tiwai Mosesgo te tigidali we bidi bidibo madi po ola tolai, “Dage we bidigo te Godigo ugwa be sę yabo nai dabe me sela aselamuo.” Augwaligo te po odama, tama te nai dabe augwaligo me sela pabeo. ");
INSERT INTO mps_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Te we bidi dabego sela asali tigidali nai dabego te ugwa be sę yabo te usu elama, te dąį ela pelama, tama meba olo munaluai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Te tigidali sę bidigo te sę ebo mu koneama, tama augwaligo te Godigo ugwa be sę yai. Augwaligo te ugwa be sę yani, te genuai ugwa name nogo sigo sę yai. Augwaligo te gasa wiegi yai ugwa selama, tama augwaligo te mama yai, me sisi yai hobigo te name ugwa au ilai, te hobi te augwaligo sipsip nisigo nigai. Tama te sę mu koneai bidi augwaligo te mobo bidi ensel noma te tigidali ugwade hobobolo pai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Te ugwa deli deli bobage usu sali, te 12 mita, te aga genuai usu nama te si tama 2 mita, tama tigidali ugwa te deli tigi poai naga dao. ");
INSERT INTO mps_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Augwaligo te a naga ugwa dali te bobage iliyu, tama te gasa a naga bobage ugwa te tiwai naga elama hobolai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Tama augwaligo te ring meba te husugu ugwago nigilama, tama tego te genuai bobage ugwa siba wadolainogo hobolai. ");
INSERT INTO mps_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Te augwaligo 50 ring te hasia ugwa me dedeli sesegede kęnani, tama te tiwai naga augwaligo me si wali te ugwa sesegede kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Tama augwaligo te 50 huk gol nigilama, tama te genuai ugwa si dali te huk dabego dąų olama, tama deli ugwa poai naga pedelai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Tama augwaligo te ugwa be haluabo genuai ugwa me dedeli nigai. Augwaligo te ugwa 11 nigali, te augwaligo meme nisigo nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Te ugwa deli deli bobage usu sali, te 13 mita, tama te genuai dabe usu nama, te si tama 2 mita, te tigidali usu sali te deli tigi poai naga yai. ");
INSERT INTO mps_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Augwaligo te nogo a naga ugwa dali hobolali, te bobage ugwa dedeli pedelai. Tama augwaligo te ugwa 11de te gilama tiwai naga yai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Tama augwaligo te 50 ring ugwa te hasia ugwa sesegede mubadi, te me ugwade te 50 te gasa me ugwa sesegede kęnai. ");
INSERT INTO mps_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Tama augwaligo te 50 te huk bras te ugwa si dali kęnabo te nigilai. Tama te ugwa si te genuai deli tiwai naga pedelai. ");
INSERT INTO mps_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Nosali augwaligo te ugwa be haluabo gasa nai me te augwaligo mama yai pengo pilai te omai sipsip waligo nigai. Tama nosali me augwaligo te sela wabo te be haluabo nai te tamu ąįde elalubo hasa nogi sikau waligo nigai. Te si haluali madi ugwadu muainogo nigai. ");
INSERT INTO mps_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Augwaligo te ugwa be daga ni name te ni akasgo nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Te ni name tigidali bobage usu sali, te 4 mita, tama te ni name genuai usu sali usu ni te 66 sentamita dao. ");
INSERT INTO mps_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Augwaligo te ni name dabe dwasianu bobage gana togolama, te be dili ni te page nai tomode dąų walomainogo yai. Tama augwaligo tigidali ni name te tiwai naga nigali. ");
INSERT INTO mps_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","24","Tama augwaligo te ni name dabe te bidi sese deli te tǫ sesege badu muabo nigibadi, tama te silva page halobage te bidi sese si te augwaligo te dodolabo ni name nigilama, tama te halobage si te ni name deli deli dologode te ni name page dąų walama, elalumainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Tama augwaligo te tǫ sesege me badu te bidi sese dodolabo ni name nigali, ");
INSERT INTO mps_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","tama augwaligo te bidi sese si silva halobage nigilama, te ni name page dabe dąų walomainogo yai. ");
INSERT INTO mps_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Tama augwaligo te dodolabo ni name me sela me sela te be tudi badu, te ugwa be te sia ge dega sigi pabo badu nigali. ");
INSERT INTO mps_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Tama augwaligo te ni nami si te ugwa be tudi badu te dage badu nigali. ");
INSERT INTO mps_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Augwaligo te be dage si aiyadu ugwaba digigo dąų wawalo holai. Augwaligo te tiwai sę te si dali si dage badu te tiwai yali. ");
INSERT INTO mps_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Tama te be tudi badu muani ni name te 8 badi, tama te 8 ni name dabe page dąų walabo silva halobage dabe elaluali. Te silva halobage si te tigidali dodolabo ni name deli deli dologode elalua muani. ");
INSERT INTO mps_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Tama augwaligo te obo tuabo bobage ni meba te ni akasgo nigai. Augwaligo te tǫ sese me badu te obo tuabo ni nogo a naga nigibadi, te obo me badu sese badu tuabo ni a naga nigiyu, te sia ge dega sigi pabo tudi badu obo tuabo ni a naga nigiyu yai. ");
INSERT INTO mps_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Te ni name dabe tomode dąų walama tuabo ni dabe, augwaligo te be dolo usu nama bobage togai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tama augwaligo te be daga ni name dabe te golgo haluama, tama tigidali ni name deli delide te ring gol meba kęnama, te bobage ni dabego te be daga ni dabe kęani dąų walali. Tama augwaligo te ni name dabe me te golgo haluai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Tama augwaligo te ugwa be tomode walabo dąį te gasa wiegi yai genuai ugwa me deli nigai. Tama augwaligo te sisi yai, me mama yai sipsip nisigo nigai hobigo te ugwa au ilai. Tama te sę mu koneai bidigo te mobo bidi ensel piksa noma te ugwade hobobolo pai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Tama augwaligo te genuai dąį ugwa walabo pos me si me si te ni akasgo nigai. Tama augwaligo te pos dabe te golgo haluama, tama te ugwa walabo gol huk dabe te posba muai. Tama augwaligo te silva page dąų walabo halobage me si me si te pos dabe dodolabo madi nigai. ");
INSERT INTO mps_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Tama augwaligo gasa wiegi yai genuai ugwa te ugwa be tųde muabo nigai. Tama augwaligo te gasagi yai hobi dabego bugagia au ilama, tama augwaligo te au yabo sisi yai hobi, me te mama yai hobi te sipsip nisigo nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Tama augwaligo a naga pos nigilama, tama augwalide te huk dabe kęnama, tama te ugwa dabe walabo madi tama tiwai nigilai. Tama augwaligo te gol selama, te pos toboluba halubadi, tama te posba wadolabo ba dabe me tiai. Tama augwaligo a naga halobage bras, te pos dabe dodolabo madi te me nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Te Besalel dali sę ebo bidi dabe augwaligo te bomai po muabo halobage te ni akasgo nigali, te aga bobage usu nama nedali, te 110 sentamita, tama aga genuai yali usu nama, te 66 sentamita, tama aga ugwadu me te usu nama, te tiwai naga te 66 sentamita naga tama nigalio. ");
INSERT INTO mps_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Tama augwaligo te halobage te wiegi yai golgo te tomo badu me, te bulu badu me haluama, tama augwaligo bobage gol me deligo te halobage sesege badu bagulai. ");
INSERT INTO mps_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Tama te ring gol me si me si te halobage tolabo nigali, tama te ring dabe te sągą me si me si tede kęnani, te me si me badu kęniyu, te me si te me badu kęniyu yai. ");
INSERT INTO mps_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Tama augwaligo te bomai po muani halobage tolabo ni dage si te ni akasgo dulama, tama te ni si te golgo haluai. ");
INSERT INTO mps_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Tama te ni dage si te ring dedage siba me badu me, me badu me palama muani, te halobage tolainogo tiwai. ");
INSERT INTO mps_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Tama augwaligo te halobage po paliabo nai te wiegi yai golgo nigai, aga te dwai sę yali sęgę sela sąbo pesage dao. Te aga bobage usu nama usu sali, te 110 sentamita, tama aga genuai yali usu sali, te 66 sentamita tama nigai. ");
INSERT INTO mps_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Tama augwaligo te gol selama, tama te hamago haluama, tama mobo bidi ensel si nigai. Te mobo bidi ensel si te halobage po paliabo nai nigali si badu dolaluai. ");
INSERT INTO mps_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Tama te mobo bidi ensel si te me deli te dolo nogo badu dolaluyu, te me deli te pobase nogo badu dolaluyu yali. Augwaligo te mobo bidi ensel si nigibadi, tama te halobage po paliabo nai te deli nai tigi tiwai naga nigai. ");
INSERT INTO mps_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Te mobo bidi ensel augwa siba digi ma tonononaluyu, tama aba te halobageba me tonononaluyu, tama augwali sigo bogo te dinigąluyu, tama te halobage po paliabo nai geme dualama elaluai. ");
INSERT INTO mps_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Tama augwaligo tebol sai te ni akasgo nigali, tama bobage usu nama usu ni sali, te 88 sentamita, tama aga genuai usu sali, te 44 sentamita, tama ugwadu usu sali, te 66 sentamita, te tama tiai. ");
INSERT INTO mps_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Tama te tebol augwaligo te wiegi yai golgo haluama, tama bobage golgo te sesege badu bagulai. ");
INSERT INTO mps_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Tama te gol dage me augwaligo te ugwadu dai tigidali sesege badu kęnani, tama aga genuai usu sali, te 8 sentamita teba sabolali. Tama augwaligo te dwasianu golgo te tebol ugwadu dai sesege tigidali bagulama au yai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Tama augwaligo ring gol me si me si nigilama, tama te tebol dage dabe me si me si te tebol sągą dabede kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Tama te ni tolaluali ring dabe te tebol tolobo nai augwaligo te sesegede pąde ugwadu daiba muai. ");
INSERT INTO mps_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Tama augwaligo te tebol tolabo ni dage si te ni akasgo nigai, te si te golgo haluai. ");
INSERT INTO mps_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Tama augwaligo te tebolde muabo pou me te doado bage dabe te wiegi yai golgo nigai. Te wain ąį ofa ilibo pou dabe, tama te plet dabe me, te kap dabe, me botol, te nai dabe tama te ofa yabo nai dao, tama augwaligo te nai dabe te wiegi yai golgo naga nigai. ");
INSERT INTO mps_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Tialima, augwaligo te wiegi yai golgo te lam sole dabe tolaluabo nai nigai. Tama augwaligo te gol hamago haluama, tama te lam dodolabo madi te pesage nigilama, tama lam nogo dabe muabo digi te lam tolalubo nai elaluai. Tama augwaligo te ni duduli dabe te golgo nigilama, te lam tolaluabo nai au ilai. Augwaligo te deli tigi tiwai nai naga tigidali nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Te lam tolaluabo naigo nogo ageali, te me sela me sela elaluali, te me sela me badu elaluyu, tama me sela te me badu elaluyu yai. ");
INSERT INTO mps_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Augwaligo te tigidali nogo age deli deli te ni duduli sela, te ni amon duduli tiwaigo au ilai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Tama augwaligo te lam tolaluabo nai au ilali, te ni duduli me si me sigo au ilai, tama te ni amon ni duduli tiwai tonobo ąǫ yalio. ");
INSERT INTO mps_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Tama augwaligo te dwasianu ni duduli yabe dabe te lam ageali si si dologode nidigili pai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Augwaligo te wiegi yai gol naga me dedeli selama, tama augwaligo te dabe nigilama, tama deli nai tiwai naga mu pedelai. ");
INSERT INTO mps_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Tama augwaligo te gol nogo a naga olama me si lam genagi nigilama, tama selama, te lam tolaluabo naiba muainogo nigali, tama te lam genagi deli deliba muabo hobi, me te plet meba badi, te tama nai nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Augwaligo te sęgę te 35 kilo elalubo te wiegi yai golgo te lam tolaluabo nai, me te aga muabo nai dabe tigidali nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Augwaligo te ni akas selama, tama te denami ebo pauda ulabo alta nigai. Te tigidali sesege badu te deli tigi poai yali, te 45 sentamita usu naga tiwai, tama ugwadu usu sali te 90 sentamita dąį yali. Te altade te tiwai nai te bulmakau gąų me si me si augwaligo dulama, tama te deli deli te alta kele ni dagede muai. ");
INSERT INTO mps_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Tama augwaligo te nai me si me si ugwadu bogo badu haluama, tama te gąų me si me si me te golgo haluai. Tama augwaligo te bobobage golgo te tigidali sesege bobegelama paliai. ");
INSERT INTO mps_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Tama me badude augwaligo te ni palabo madi te ring si golgo nigali, te alta tolabo madi nigilama, tama gasa badu me tama tiali, tama augwaligo te ring me si me si te alta ugwadu sesegede muai. ");
INSERT INTO mps_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Tama te alta ni palabo ni dage si augwaligo te ni akasgo nigilama, tama te ni si te golgo haluai. ");
INSERT INTO mps_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Tama augwaligo te wel nigilama, te Genuai Bidigo nai dabe da olama sa muabo wel dao, tama te begelali, te sanda tiwai dolo mu yai. Tama augwaligo te wiegi yai paudago te wiegi yai denami yabo nai nigali, tama augwaligo bugagia taluai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Te Besalel dali, te sę ebo bidi dabe dali, augwaligo te ni akas selama, te ofa ebo nai dabe ulabo alta sai nigai. Te alta sesegede te tigidali te deli tigi poai naga yali, te 2 mita 20 sentamita te usu tama yali, tama ugwadu usu sali, te 1 mita 30 sentamita, te tiwai usu sai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tama augwaligo te bulmakau gąų tiwai nai me si me si habu badu te ugwadu, te tiwai nai me si me si dulama, tama te gąų dabe te altade mu dąų wai. Tama te alta tigidali augwaligo te brasgo haluai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Tama augwaligo te bras selama, te sia munama tolabo plet dabe badi, te dwasianu savol dabe me, te pou dabe badi, te age age yai na dabe me, tama te sia nogani keli sabo pou dabe, te tama nai dabe tigidali nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Tama augwaligo te bras selama, tama te moni sawali bras nigiyu, polola polola pelama, tama te nai nigilama, tama te nai te alta halobage tomode elalumainogo eyu, muani. ");
INSERT INTO mps_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tama augwaligo te ring bras me si me si nigilama, tama te alta dage me si me si dage badu kęnai. Te ring dabe te ni munama, te alta tolabo digi nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Tama augwaligo te alta tolabo te ni akas si dulama, tama brasgo haluai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Tama augwaligo te ringba te alta si dali si badu muai. Te alta te augwaligo ni namego nigai halobage tiwai yali, tiali goli aga pagede te ni name meni yai. ");
INSERT INTO mps_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Tialima, te Godigo ugwa be tų mabode sę ebo we dabe augwaligo te bras Besalelbolo mawai. Te bras te augwa gesabi subo dula dabe tiwai. Tama te sę ebo bidi dabego te bras selama, tama te wę pauabo genuai pou me deli nigibadi, te pou muabo page me deli nigibadi yai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Augwaligo te Godigo ugwa be bagulabo obo ugwa nigali. Te sesege bogo badu bobobage usu sali, te 44 mita te usu tiwai. ");
INSERT INTO mps_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Tama augwaligo te bras selama, te bidi sese pos nigibadi, te pos dabe page dodolabo halobage te bidi sese nigali, tama augwaligo te huk dabe, me te ba dabe te silva dabego nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Tama augwaligo te deli tigi poai naga te me sesege badu nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Tama te sia ge dulubo badu te name ugwa me deli walai elaluali, te ugwago bobage usu sali, te 22 mita elaluai, tama nogo si pos bras badi, te me nogo si te pos page dodolabo te halobage bras dabe elaluai. Tama te posde kęnabo dabe me, te ba me, te nai dabe augwaligo te silvago nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Tama te giliga pedalu badu obo me te usu sali, 22 mita yai. Tų te obo badu elaluai. ");
INSERT INTO mps_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Te obo me deli te sesege badu te tų sesegede te ugwa me deli walai elaluali, te ugwa aga bobage usu sali te 6 mita ma 60 sentamita usu sali tiwai yali, tama pos sela elaluali, me sela te pos dodolabo halobage nigai elaluai. ");
INSERT INTO mps_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Tama augwaligo te deli tigi poai nai naga te gasa tų sesege obo badu nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Augwaligo te gasa wiegi yai ugwa tigidali naga te obode walabo nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Augwaligo te bras selama, tama te pos dabe page dodolabo halobage nigali. Tama augwaligo te silva selama, te huk dabe nigali, tama te pos dabe kęabo ba te nigai. Tama augwaligo te pos tobolude te silvago naga haluai. Tama te tigidali obo pos dabe augwaligo te ba silvago naga wadolai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Tama augwaligo te obo tųde muabo ugwa wiegi yai mu nigai. Tama augwaligo te ugwade au ilibo nai hobolali, te haniani hobigo, tama te husugu sipsipgo, me te mama yai sipsip nisigo nigai hobigo hobolai. Te ugwago bobage usu sali, te 9 mita tama yali. Tama te ugwa ugwadu dai badu usu sali, te 2 mita 20 sentamita yali, te obo bagulali ugwa te tiwai nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Tama augwaligo te bras halobage me si me side dolalubo te pos me si me side te ugwa walai. Tama te huk dabe me, te pos tobolu haluali nai me, te posba wadolali ba dabe me, te augwaligo silvago naga nigai. ");
INSERT INTO mps_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tama augwaligo te bras selama, tama te tǫba enebo bobage nil dabe nigai, te bomonama kekelama tama te ugwa be dolaluabo bono dąų waliyu, tama te ugwa be bobegelali obo dąų waliyu yainogo tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tama augwaligo te tigidali nai nigali gol, me silva, me bras nedali, augwaligo te tobage wiegi yai kapago nigali nai te Genuai Bidigo ugwa bede muani nai dao. Te ugwa be da, te Godigo nogo si bomai po elalubo masigi pedai si elalubo be dao. Tama Mosesgo digi te Livai dabe augwalibolo te nai nedao po olama, tama augwaligo nedelama, tama nisu naga gol elaluali te augwaligo asęani. Itama, te pris Arongo ogwago te Livai dabego te sę ebo tonaluai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Tama Besalel, te Urigo ogwa, tama Uri te Hurgo ogwa, te Juda hani dao. Tialima, Besalelgo te Genuai Bidigo Mosesbolo wali po gilama te tigidali nai nigibo sę yalio. ");
INSERT INTO mps_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Tama Oholiap te Ahisamakgo ogwa, te Dango hani bidi dao. Te Oholiapgo te wiegi yai masigide asębo po togobo sę konebadi, tama agai te haniani gasa nai dabe nigibo sę me koneai. Tama agai te haniani gasa hobi dabego te au ilibo sę me koneyu, te sisi yai hobi, me te mama yai hobi, te tobage sipsip nisigo nigai hobigo te au dabe ilibo sę koneai dao. Agai te Besalel dologode bidiyu, aga tau sali. ");
INSERT INTO mps_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Augwaligo te we bidigo te Godigo ugwa be sę emainogo sela asali nai dabe te tigidali gol nedai, tama te nai dabego aga sęgę da te e tiwai, te 1,000 kilo usu dao. ");
INSERT INTO mps_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Tama augwaligo te silva nedali, tama te naigo sęgę te tiwai, te bidi sese hauwa, te 3,430 kilo sęgę yai. Te silva te bukude augwa nogi asęna elaluali bidi dabego sela asai. Te bidi dabego kibu be te bidi sese delidu ugwaba holali bage, augwali deli deligo te silva monego te mone ge a naga muani. Te bidi dabe te bidi sese hauwa mu, te 603,550, te tama bidi te mone muna muna pai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tama augwaligo te silvade sęgę 3,400 kilo yali, te Godigo ugwa be dili te dąų walabo nai nigali, tama te pos dabe page dodolabo halobage me, te Tedali Gasagi Yai Be Habu me, te Tedali Gasagi Yai Mu Be Habu me, te madi si te dualabo madi nai nigai. Te bidi sese a naga te 100 halobage elaluai. Te silva dage halobage deli deligo sęgę te 34 kilogram elaluai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Tama me badu te munaluali silvago sęgę te 30 kilo usu tama elaluai. Tama te munaluali silvago augwaligo te huk nigilama, tama te pos dabede wadolama, tama te pos dabe ugwadu haluainogo tiwai sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Te augwaligo Genuai Bidiba mani tigidali brasgo sęgę te bidi sese hauwa mu, 2,425 kilogram igi pai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Tama augwaligo te bras selama, tama te pos dabe dodolabo halobage nigali, tama te Godigo ugwa be tųde muainogo yali nai me, tama alta dali te alta tomoba muani pololai sawali bras, te nai dali elaluali, tama te altade sę yabo nai dabe tigidali nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Tama augwaligo te ugwa be bobegelabo te pos bulabo halobage dabe, me te obo bagulali madi tų nigabo nai dabe nigai. Tama augwaligo te tǫba enabo bobage nil dabe, te ugwa be bomonama kekalumainogo dąų walobo nai nigiyu, tama te ugwa be bobegelabo nai me nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Augwaligo te sisi yai sipsip nisi, me mama yai sipsip nisigo nigali hobi te augwaligo selama, tama te gasa wiegi yai ugwa te pris dabe augwaligo gudabo ugwa au ilama, te pris dabe augwaligo te Tedali Gasagi Yai Be Habu, te be habuba pelama, te pris sę ebo sogo te ugwa muani. Tama augwaligo te Genuai Bidigo Mosesbolo wali po gilama te Arongo pris sę eyu muabo ugwa nigai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Augwaligo te wiegi yai ugwago te tobolu bidi pris gudabo wiegi yai ugwa nigilama, tama augwaligo te gol hobigo au ilama, tama te sisi sipsip nisigo, me mama sipsip nisigo nigai. ");
INSERT INTO mps_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Augwaligo te gol hamago haluama, tama te pepa yabe tiwai pedelai. Tama te gol te hwą gego bugagia pedama, tama hobi tiwai te golgo nigali. Tama augwaligo te ugwa hobolo dwasianu gol hobi tiwai dali, te gasa haniani hobi dabe dali gelali, tama sisi hobigo me mama hobigo badi, tama togolama hobolai, te tobage sę mu koneai bidigo ebo sę tiwai naga tama yai. ");
INSERT INTO mps_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Tama augwaligo te nagede abebolabo kukulu si te ugwago nigilama, tama ugwago digi ma hobolai. ");
INSERT INTO mps_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Tama augwaligo wiegi yai ugwa pedai selama, tama te sesegedu bagulabo kukulu, te haliga tiwai kukulu te ugwago nigai. Tama augwaligo te gasa haniani hobi dabe selama, tama tede au ilali, te Genuai Bidigo Mosesbolo wali po gilama te tiwai sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Tama augwaligo te masigi konilian si te sisi ela munama, tama Jekopgo ogwa 12 te augwali nogi te masigi side asęnama togwali. Tama te masigi si augwaligo te dwasianu golde kęnanio. ");
INSERT INTO mps_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Tama augwaligo te masigi name si te nagede muani te ugwago nigali kukulude kęnani, te Genuai Bidigo Mosesbolo wali po gilama tama tiai. Tama te masigi sigo te Israel hani 12 te hani sa muai dao, te Genuai Bidigo augwalide sesemane sogo homugo kone palomainogo eyu yali. ");
INSERT INTO mps_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Tama augwaligo te hagawiade muabo ugwa te tobolu bidi prisgo gasa ugwa te tiwaigo naga nigai, te tobage sę ebo koneai bidigo ebo tiwai naga nigai. Augwaligo te ugwa te golgo nigai hobigo me, te gasa haniani hobigo me, tama au ilama, nigalio. ");
INSERT INTO mps_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Tama augwaligo te ugwa bobage yali me, te genuai me, te bugagia tomode sugunama, te usususi yali te nedali, 22 sentamita teba sabolai. ");
INSERT INTO mps_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Tama augwaligo te gasa wiegi yai masigi hani me si me si kęnani. Te hasia polali hani augwaligo te masigi hani rubi, me topas, me ganet, te tama masigi bolo podolama kęnai. ");
INSERT INTO mps_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Tama te hani side augwaligo te masigi emeral, me sapaia, me daimon, te tama masigi dabe kęnai. ");
INSERT INTO mps_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Tama te hani me sela te masigi tekois, me aget, me ametis, te tama hani masigi augwaligo kęnani. ");
INSERT INTO mps_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Tama te hani me si me side te augwaligo te masigi hani beril, me konilian, me jaspa, te tama masigi augwaligo kęnani. Augwaligo te deli deli masigide te dwasianu gol au ilabo dąų walobo nai muani, tama nosali augwaligo te masigi dabe te ugwa daide, kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Te tigidali masigi nogo si olama sągą me badu si, te masigi deli delide augwaligo te Jekopgo ogwa nogi deli deli asęsę pali, te tigidali Israel hani sa muyu, tiai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Tama augwaligo te wiegi yai golgo te sen si nigali, te hagawiade muabo ugwa dąų olama, tolalumainogo tama tiwai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Tama augwaligo te au ilibo gol si nigibadi, te ring gol si me nigai. Tama te ring si te hagawiade muabo ugwa dage si badu te nai muai. ");
INSERT INTO mps_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Tama augwaligo te sen gol deli deligo sabi te ring sigo kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Tama augwaligo sen gol deli deligo gasa sabi te au yai gol sigo kęani, tama augwaligo te au yali nai te ugwa tolalubo kukulude kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Tama augwaligo te ring me si ma nigilama, tama te sabi si dabe aiyadu te hagawiade dąų wali, te genuai ugwa pąde te kęnai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Tama augwaligo te ring me si ma nigali, tama te kukulugo te ugwa kęalubo madi kęniyu, te gasa wiegi yai kukulugo te tabi bagulali pąde kęai. ");
INSERT INTO mps_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Tama augwaligo sisi yai string bono sobadi, tama te ring si te hagawiade elalubo ugwa te ring si sobadi elama, te genuai ugwaba kęai. Tama te hagawiade muani ugwa te kukulude dąų olama, tama me tulaluidali weyu dąų wai. Augwaligo te Genuai Bidigo Mosesbolo po walali gilama wali peyu, te tiwai sę yalio. ");
INSERT INTO mps_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Tama augwaligo husugu hobi selama, tama te bobage gudubo ugwa te holobo ugwa dali daganama hobolalio. ");
INSERT INTO mps_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Tama augwaligo te tobolu muabo madi sesege badu te dedage dąų olama hobolali, te ugwa dedage peda pelama, genuai me idali weyu. ");
INSERT INTO mps_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Tama augwaligo gasa haniani hobi dabe selama, tama nai meba te ni pomigranet du tiwai hobolai. Tama augwaligo dwasianu belo te wiegi yai golgo nigai. Tama augwaligo te ni pomigranet du me, te belo me, te tobolu bidi prisgo gudabo ugwa aiyadu sabide walama hobolai. Augwaligo te deli deli gol belo te ni pomigranet du dabe tomo tomode te walalumainogo hobolama walai. Augwaligo te tiwai sę te Genuai Bidigo Mosesbolo po wali gilama tama tiai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","Augwaligo te Arongo holobo ugwa me, te agai ogomanigo holobo ugwa me nigibadi, tama te tobolude bagulabo ugwa pedai dabe me, tama te pęwadage belibo trausis dabe me, tama te mǫ tiwai kukulu dabe me, te tama nai nigai. Te augwaligo wiegi yai name ugwa selama, tama te nai dabe nigai. Tama augwaligo gasa haniani hobi selama, tama te mǫ tiwai nigali kukulude hobolama, wiegi yai au ilali, te Genuai Bidigo Mosesbolo po wali gilama wali peyu, te tiwai sę yai. ");
INSERT INTO mps_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Tama augwaligo te medal te wiegi yai golgo nigali, tego te het pris bidi te Genuai Bidigo bidi da olama sa muani. Augwaligo po me deli agade asęyu te tiwai po wai, “Te Genuai Bidigo Tedali Gasagi Yai Nai da.” Te po wai. ");
INSERT INTO mps_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Tama augwaligo husugu yai hobi bono selama, tama augwaligo te tobolude muani ugwade te medal kęnani, te Genuai Bidigo Mosesbolo wali po tiwai gilama tama tiwai sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tama te ugwa be sę yali tigidali silai. Tama te Israel dabe augwaligo te Genuai Bidigo te Mosesbolo po wali gilama te tigidali nai nigalio. ");
INSERT INTO mps_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Tama augwaligo te nai dabe te Moses bidiboba sela pai. Augwaligo te ugwa be dali, te aga doado bage dabe badi, tama sela pali, tama te huk dabe me, te be daga ni name dabe me, tama te ni name tuabo ni dabe me, te pos dabe me, tama te ni name dodolabo halobage dabe, te tama nai dabe sela pali, ");
INSERT INTO mps_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","tama te ugwa be haluabo genuai nai augwaligo te omai sipsip waligo nigali, tama te haluabo nai me augwaligo te tamu ąįde elalubo hasa sikau waligo nigali, tama te Tedali Gasagi Yai Mu Be Habu te geme dualabo genuai ugwa walobo nigibadi yalio. ");
INSERT INTO mps_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Tama augwaligo te dąų walali bomai po muani halobage me, te aga sęgę sela sąbo madi te po paliabo nai dali elalubo me sela asai. Tama te halobage tolobo ni si me sela asobadi yali, ");
INSERT INTO mps_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tama te tebol me, te tebolde mubo doado bage dali, tama te God gedude te tebolde mubo te bret me, te augwaligo sela pai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Tama augwaligo te wiegi yai golgo nigai te lam dabe tolalubo nai me, te aga doado bage dali me, te lamde muabo wel dabe dali, sela peyu, ");
INSERT INTO mps_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","te alta gol me sela pai. Tama augwaligo te Godigo nai sa muainogo te wel sela pali, tama denami ilibo pauda me, tama te ugwa be tųde mubo ugwa me sela palio. ");
INSERT INTO mps_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Tama augwaligo te brasgo nigai alta me, te pololai sawali bras te alta halobage tomoba muabo nai, te dali sela pai, tama te alta tolobo ni dabe me, tama te tigidali altade nai dabe badi, tama te wę paubo pou me, te aga page dali, sela pali. ");
INSERT INTO mps_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Tama augwaligo te ugwa be bobegelabo obo ugwa dabe badi, te pos dabe dali, tama te pos dodolabo halobage me, te obo tųde muabo ugwa me, te obo dąų walabo bono dabe dali, te tǫba enabo bobobage nil dabe, te bono bomonobo nai dabe badi, tama nai dabe sela pai. Augwaligo te ugwa be tomode sę yabo nai dabe tigidali sela pai. ");
INSERT INTO mps_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Tama te pris dabego te Tedali Gasagi Yai Be Habu tomoba pelama, te pris sę eyu, te gudabo wiegi wiegi yai ugwa dabe, te me augwaligo sela pai. Te ugwa dabe te Godigo te pris Aron aga ogomani dabe dali augwaligo naga te ugwa gudama, te pris sę emainogo sa munama, te tedali gasagi yai ugwa dabe elalumainao wali. ");
INSERT INTO mps_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Te Israel dabe augwaligo te tigidali sę yali, te Genuai Bidigo Mosesbolo wali pode naga te tiwai gilama sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Tialima, Mosesgo augwaligo te nigali nai tigidali bugagia tonono bilama, osola sulama, tama agai koneani, te Genuai Bidigo agabolo po weyu, te nigao wali nai te tigidali te tiwai naga nigai. Agai sulama, tama agai augwalibolo te po wai, “Genuai Bidigo wiegi yai sę bugagia mu dagego te sę yalio. Tama tibaso, eno homugo agai dage dali dwagi yai sę emainao,” Mosesgo te po wai. ");
INSERT INTO mps_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Tama Genuai Bidigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Odao, te hasia nanobo polua, te dei deli wabode, te dagego eno ugwa be sę yao. ");
INSERT INTO mps_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tama dagego te bomo yai po nogo si elalubo te halobage selama, tama te ugwa be tomoba munama, tama te halobage dualiyu, te genuai name ugwa walao. ");
INSERT INTO mps_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tama te tebol tomoba sela pelama, tama te nai dabe ugwadu daiba manao. Tama te lam dabe tolalubo nai sela aselama, tama te lam dabe te aga nogoba muao. ");
INSERT INTO mps_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tama te denami ebo pauda ulubo alta gol te bomo yai po haluali ugwa te sesege e bulu badu pąde muao. Tama te ugwa be tųde ugwa walao. ");
INSERT INTO mps_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tama te ofa dabe yabo genuai alta te ugwa obo tų pąde muao, te mesalode. ");
INSERT INTO mps_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tama te wę pauabo genuai pou te mesalode muao, te ugwa be de te alta si tomode, te ąį pągąnama, muao. ");
INSERT INTO mps_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tama te ugwa be bagulubo obo te dodolobadi, tama te genuai ugwa te obo tųde walobadi yao.” ");
INSERT INTO mps_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Tialima, nosali te wel selama, te eno nai dabe sa muyu, tama te ugwa beba geliyu, te tomode munalubo nai dabe tigidaliba gelao. Te tiwai naga te dagego eno nai naga tigidali da sa muyu, tama tedali gasagi yai mu elalumainao. ");
INSERT INTO mps_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tama te bras altaba te wel geliyu, tama te sę yabo nai tigidaliba tiyu, tama te alta me te Genuai Bidigo nai naga dao homu eyu, tedali gasagi yai nai elalumainao. ");
INSERT INTO mps_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tama te tiwai naga te wę paubo genuai pouba me tiyu, tama aga te pageba me, tama te me te eno nai dao.” ");
INSERT INTO mps_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Nosali nago te Aron aga ogomani augwali dali te ugwa be tųba sela pelama, tama augwali tede wę paumainao. ");
INSERT INTO mps_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Tama te tobolu bidi pris ugwa te Aron tigiba muyu, te wel agaba sa muyu gelibadi, tama agai te eno te pris sę tiwai emainogo tiwai yao. ");
INSERT INTO mps_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tama nosali nago aga ogomani augwali me te pąba sela aselama, tama te pris au dobage augwali tigiba muao. ");
INSERT INTO mps_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Tama augwali te welgo mumuyu, te nago augwa aya sa muani gilama tiao, tama augwa enade te pris sę emainogo yao. Nago augwali te tiwai te welgo sa muao, tama nosali augwa digi, me te augwa hani dali, augwa te pris sę sesemane bidada pabo sogo te sę ela pomainao.” Genuai Bidigo te po wai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Tialima, Mosesgo te po odama, tama Genuai Bidigo agabolo te po wali te tigidali sę yai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tama te hasia polua deli, te dei deli wabode, te kibu be side te augwaligo te Isip bulu taga soali, te bodolu nosali pedalobo sogo, augwaligo te Godigo ugwa be sę eyu yai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Te augwaligo te ni name dabe bulabo te halobage dabe selama, te tǫba munama, tama te be daga ni name dabe te halobage tomoba bulai, tama te ni name te ni name tuabo bobobage ni dabe munama, tama te genuai ugwa walabo te pos dabe bulai. ");
INSERT INTO mps_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Tama augwaligo te genuai ugwa te ugwa be pedu dili ugwadu munama, tama te halubo nai sela selago te ugwa be haluali, te Genuai Bidigo te Mosesbolo wali po gilama te tiwai sę yalio. ");
INSERT INTO mps_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Tama augwaligo te Godigo bomai po asęai masigi pedai si selama, tama te masigi si te dąų wali bomai po muabo halobage tomoba muai. Tama augwaligo te ni dage si te halobage tolabo madi nigilali dedage me si me siba muani, tama te halobage po paliabo nai, te da te sęgę sela sąbo madi, te halobage daiba ugwadu muai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Tama te halobage te ugwa be tomoba munama, tama te halobage aga digi be habu elalumainogo eyu, augwaligo te moni wiegi yai dąį ilibo name ugwa walama, te halobage te Tedali Gasagi Yai Mu Be Habu tama elaluali. Augwaligo te tiwai sę yali, te Genuai Bidigo Mosesbolo po wali gilama tama tiai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Tama augwaligo te tebol te dąį ilibo ugwa e badu muyu, te Tedali Gasagi Yai Be Habu me badu tomoba muanio. ");
INSERT INTO mps_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Tama augwaligo te bret selama, te Genuai Bidigo gedude te tebolba muai, te Genuai Bidigo Mosesbolo po wali gilama te tiwai sę yai. ");
INSERT INTO mps_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Tama te lam dabe tolalubo wiegi yai nai te me badu te tebol dolo si muanio, te Tedali Gasagi Yai Be Habu tomode. ");
INSERT INTO mps_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Tama augwaligo te lam dabe te lam dabe tolaluabo nai te nogo age yaliba muani, tama te lam dabe te Genuai Bidi gedude udulali. Augwaligo te tiwai sę yali, te Genuai Bidigo Mosesbolo po wali gilama te tiwai sę yai. ");
INSERT INTO mps_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Tama augwaligo te alta gol te Tedali Gasagi Yai Be Habu tomoba muyu, te dąį ilibo wiegi yai name ugwa e badu muyu, tama muani. ");
INSERT INTO mps_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Tama te altade augwaligo te denami ebo nai pauda ulali, te Genuai Bidigo po Mosesbolo wali gilama tama tiai. ");
INSERT INTO mps_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Tama augwaligo te ugwa be tųde te genuai name ugwa walai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Tama nosali augwaligo te ofa ebo moni alta te ugwa be tų pąde muani. Tama te altade augwaligo te siago domainu tigidali ulubo kibu bulmakau me, te wit me, augwaligo ofa yali, te Genuai Bidigo Moses dali po wali gilama tama tiai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Tama augwaligo te wę pauabo genuai pou te alta de te ugwa be si tomode te ąį pągąnama muai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Tialima, nosali Moses me, Aron me, te Aron aga ogomani me, augwali nogo sągą te ąįde telawai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Te augwali te Godigo ugwa be tomoba me te altaba painogo, augwaligo hasia bolo nogo sągą ąįgo tedelama, pai. Augwaligo te Genuai Bidigo Mosesbolo po wali gilama tiai. ");
INSERT INTO mps_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Tama augwaligo te ugwa be dali, te alta me, bagulabo obo dodolama, tama augwaligo te obo tųde me te ugwa walali. Tama Moses dali, te bidi dabe me, augwaligo te tigidali sę yali, tama te ugwa be sę yani te sę tigidali silai. ");
INSERT INTO mps_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tama te ugwa be sę silibo si, teda Genuai Bidigo pǫgo te ugwa be mesega sagaselama, tama aga genuai bomo yai ulago te be pągąna sai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Tama tiyu, Moses te ugwa be tomoba pabo te usu me ebe, magi baso meni, te Genuai Bidigo pǫ me, te ula me, te ugwa bede elaluyu, tama te be pągąna sai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tama nosali te pǫgo te Godigo ugwa be taga pabo sogo da, teda te Israel dabe augwa tigidali doado bage selama, tama te pǫ pabo wali pai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Tiali goli, te pǫ me te ugwa be ugwadu me bidibaso da, teda augwaligo te bulu me taga pabeo. Augwaligo suali, te pǫgo te ugwa be taga pabosi, teda augwali me hogodolama, tama te pǫ wali peyu yai dao. ");
INSERT INTO mps_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Te Genuai Bidi bidibo pǫ te ugwa be ugwadu tigidali sogo bidai. Te siade augwaligo te pǫ suali, tama hulide te pǫde sia elalubo suai. Te ela asali sę tiwai tama me ela pidubadi, te Genuai Bidigo augwali mawainogo yali te tǫ pedaiba augwali sabolama bidigi pai dao. ");
INSERT INTO mps_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Genuai Bidi aga Ugwa Be tomode bididu, te Moses asao olama i walima, te agabolo te po wai, ");
INSERT INTO mps_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Te Israel we bidiba e tiwai po wao,” wali, “‘Te dage bidi me deligo te Genuai Bidiba ofa me deli selasa asainogo ebaso da, teda agai te kibu bulmakau me deli, ma kibu sipsip me deli, ma meme kibu me deli, te sela asobo usu dao,’ tama po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Tama Genuai Bidigo Mosesbolo ma walama, te Israel dabebolo e tiwai po walao po wali, “‘Te bidi me deligo te isiba tigidali ulama dabo ofa ebo bulmakau sesebaso da, teda agai te bulmakau omai wiegi yai mu sao, te aga tigide keni keni pobolo meni yai sesao. Te bidigo homugo te Genuai Bidigo agaba bugai haliga emaina homu eyu da, teda agai te tiwai ofa tama yao. Agai te Godigo Ugwa Be sunumi badu te bulmakau selasa aselama, ");
INSERT INTO mps_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","tama te bulmakau toboluba nogo muao, teda te bulmakau te bidi hasegelama tama te bidigo sęgę dabe sela sąyu, Godigo te ofade bugai haliga yaibao. ");
INSERT INTO mps_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Tama te Genuai Bidigo gedude, te bidigo te bulmakau elao, tama te pris dabe, te Arongo hani dabego, te bulmakau kaneme Genuai Bidiba ofa yao. Augwali te Ugwa Be sunumi pąbadu elalubo alta badu pelama, te kaneme te alta sabi dage me si me si te badu sąyao,’” wali. ");
INSERT INTO mps_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","“‘Tama nosali te bidigo te bulmakau tigi wali dagalama, te aga mi dabe tologao. ");
INSERT INTO mps_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","9","Te kau aga haliga me sągą ąį bugagia tela yao. Te pris dabego te altaba isi dabe munama, te isi udulao. Te augwaligo te kau tobolu me, ili me tigidali mi dage te isiba muao, te isigo tigidali dela silimainogo ilama, te keli hogomu naga elalueibao. Tama Genuai Bidigo te ofa denami ebo odama, te aga godolo homu elama bugai haliga yaibao.’” ");
INSERT INTO mps_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘Bidi me deligo te ofa yabo sipsip ma meme sesebaso, agai te omai sipsip ma omai meme wiegi yai mu sesemainao, te keni kenigo aga tigi dolisąwai sela pao. ");
INSERT INTO mps_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Tama te Genuai Bidigo gedude agai te sipsip ma meme te not badu altade elao. Tama te pris dabego te sipsip ma meme kaneme selama, te alta dage me si me si pedai badu sąyao,’” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","“‘Tialima te bidigo te kibu mi togolama, te kibu haliga me sągą bugagia ąį tedelama, te pris me deligo te tobolu me ili me te kibu pedai tigidali te alta siaba muao. Te prisgo Genuai Bidiba te ofa menama, te isigo tigidali dela silimainogo elama, te keli hogomu naga elalumainogo yao. Tama Genuai Bidigo te ofa ulubo denami ebo odama, te agai homu godolo elama, teba bugai haliga eyu yaibao.’” ");
INSERT INTO mps_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘Te bidi me deligo te Genuai Bidiba ofa yabo ba me deli sesainogo eyu da, teda te tobage ba me deli sela asao, te ba nogi balus, ma ba hi te tobage ba prisba sela asao,’” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","“‘Tama prisgo te ba hi altaba sela pelama, te aga ba dogoni pobegelama isaibao. Te agai te ba hi tobolu togolama, te tobolu te alta saiba ulao. Te ba hi kaneme te alta bogo badu gegeli pao. ");
INSERT INTO mps_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Agai te ba hi nisi poabadi, te ba dogoni nai mubo tibu me te selama, te giliga pedalu badu alta te keli mubo badu muao. ");
INSERT INTO mps_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Nosali prisgo te ba hi bogode tola selama, te aga tigi togwao, tialima te bogo mu togwa sągio. Agai te isigo tigidali domainogo yao, te keli naga elalumainogo ilao. Agai te tiwai ebaso da, teda Genuai Bidigo te ba ofa yali denami ebo odama, te aga homu godolo elama, te bugai haliga eyu yaibao,’” wali. ");
INSERT INTO mps_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Tama Godigo Mosesbolo walama, te Israel dabebolo e tiwai po walao po wali, “Te bidi me deligo te Genuai Bidiba te wit ofa yabo homu ebaso da, teda agai te wit wale bo sela sąnama, te aga nai ge naga selama, te wiegi yai plaua mu nigilama, te plaua sela asao. Tama agai te ni oliv wel te plauaba gelama, tama te wiegi yai denami ebo pauda me te plaua ugwadu daiba munama, ");
INSERT INTO mps_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","te Arongo hani dabe, te pris dabeba sela pao. Te pris me deligo nogo te plauaba munama, te plaua dali wel dali si te dwasianu pedai siyu, tama te denami pedalubo pauda tigidali me selama, te altaba ulao. Te dwasianu plauago tigidali plaua te bidigo Genuai Bidiba dąį ilibo ofa mu ebo ofa tiwai dao. Te wit ulubo ofa denami Genuai Bidigo odama, te agai godolo homu elama, bugai haliga yaibao. ");
INSERT INTO mps_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Te me badu elaluali plaua te pris dabego dao. Te plaua te pris dabego witde sali te bidi dabego Genuai Bidiba ofa yali nai, tama te pris sę isąwai bidigo sabo te habu mu yai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Dagego te nai ulubo be nogi aven tede te bret ulama, te Genuai Bidiba ofa yabo bret dage saiba wida, teda te bret dagego te yis dali nigilamuo. Dagego te plaua selama, te oliv ni wel dali taluama nigao, te dagego bret nigilama ofa yao. Te dagego bret nigibo hagela homu ebaso da, teda dagego te bisket naga nigilama, te ni oliv welgo piligilao. ");
INSERT INTO mps_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Dagego te ofa yabo plaua praipende praim eyu da, dagego te yis meni yai wiegi yai plaua mu siyąo. Te dagego te ni oliv wel te plaua dali talu bolo elama, te praim yao. ");
INSERT INTO mps_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Te dagego te plaua dwasianu dwasianu miminama teba wel gelama, te Genuai Bidiba ofa yao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Te dagego ofa yabo bret nigilama, te genuai sospen senede dagego ulainogo da, teda dagego wiegi yai plaua mu te yis meni yai selama, te ni oliv wel dali belegelama ulao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“Ulama, silama da, teda dagego te bret ma plaua te ofa tiwai Genuai Bidiba selasa pelama, te pris me deliba mao. Tama prisgo te altaba sela paibao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","“Nosali prisgo te dwasianu pedai bret ma plaua te dagego Genuai Bidiba ofa yali nai tigidali dąį ebo ofa mao, agai te alta siaba ulaibao. Tialima Genuai Bidigo te ofa denami ebo odama, te agai godolo eyu, bugai haliga mu yaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","“Te bret ma plaua me, badu elaluali da, te pris dabe augwa nai dao. Te bret ma plaua te pris dabe augwa tueinu saibao, te Genuai Bidiba ofa yali nai. Tialima, te pris sę isąwai olo bidi dabede te habu mu selai dao.” ");
INSERT INTO mps_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Dagego ofa ebo bret ma plauaba te yis munama, te Genuai Bidiba me selasa pigio, magi baso meni, te yis ma hani te ofa dabeba musįama, te Genuai Bidiba ofa mayu, te siaba ulubo ofa, te habu mu selai dao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","“Dagego te yis ma hani te hasia polasa gide sabo wit dali munama, te Genuai Bidiba ofa igi peyu selasa pao. Te usu dao,” wali. “Tiali goli te yis ma hani elalubo nai yai baso da, teda dagego te Genuai Bidiba wiegi yai denami iliyu, isiba domainogo ulubo altaba me ulamo dao. ");
INSERT INTO mps_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Te dagego wit ulubo ofa ebo side tigidali sogo tamu muao, magi baso meni, tamugo dagego te God dali dąų walali bomai po dąį ebo tiwai ebao. Te dagego te duga God dali dąų wali bomai po gegeda pidali weyu, te tigidali ofade dagego tamu naga mudao. Dagego te ofa me delide tamu mubo me gegeda paligio. Mu menio,” wali. ");
INSERT INTO mps_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Te dagego gide polasa ina yani wit selama, te Genuai Bidiba ofa yainogo da, teda dagego te nai ulubo madi avende bolo ulama, te mimia sanama, te dwasianu kakali ilama, nosali te Genuai Bidiba selasa pabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Te wit ulubo ofade dagego te oliv wel me te wiegi yai denami ebo pauda me muao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","“Tama prisgo te wit pedai dwasianu me wel me selama, te wiegi yai denami pedalubo pauda te tigidali selama, te dagego ofa dąį ilama te ulao. Te Genuai Bidibolo mabo ofa eyu isiba ulubo nai dao.” ");
INSERT INTO mps_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Te Godigo Mosesbolo walama, te Israel dabebolo te tiwai po wao po wai, “Te bidi me deligo Genuai Bidi dali deli haliga ebo ofa yainogo, te agai kibu bulmakau ofa yainogo ebaso da, teda agai te kau kibu omai ma so kau kibu te wiegi yai mu aga tigide dwai keni kenigo dolisąwai selama, ofa ebaso, usu dao. ");
INSERT INTO mps_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Te Godigo te Israel dabe dali deliba sisinibo Ugwa Be sunumiba asama, tama te bidigo nogo te kibu kau toboluba muyu bolo elama, te nosali agai te ela muao. Te pris dabe, augwali te Arongo hani dabe, augwaligo te alta bogo me si me si badu te kau kibu kaneme sąsągą bilao. ");
INSERT INTO mps_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Te bidigo te kau kibu delage me badu selama te Genuai Bidiba mayu te pris dabego ofa tiwai ulumainao. Agai te haligade ili dabe sao, ");
INSERT INTO mps_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","tama te si wabo kibu homu dali te ili me te polalubo dini homu te wiegi yai me badu sao. Agai te namba wan homu me te namba tu homu si dali te sobadi yao. ");
INSERT INTO mps_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Tama pris dabego te nai dabe te altaba siaba tigidali ulama dela silibo ofa dali ulao. Tama Genuai Bidigo te ofa ebo denami odama te aga godolo elama bugai haliga tede yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Te bidi me deligo te sipsip kibu ma meme kibu selama, te Genuai Bidi dali deli haliga ebo ofa yabo homu ebaso da, teda agai te omai kibu sipsip ma so kibu sipsip, ma te meme kibu omai ma so kibu meme somainao. Tiali goli, agai te kibu sipsip ma kibu meme te wiegi yai mu te keni kenigo tigi me dolisąwai sobaso da, te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Te bidigo te sipsip kibu wai me deli ofa yai hagede eyu da, teda agai Genuai Bidigo gedude selasa asao. ");
INSERT INTO mps_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Tama agai nogo te sipsip kibu toboluba muyu bolo elama, tama nosali agai sipsip kibu te Godigo Ugwa Be gesabidi badu pąde ela mubaso usu dao. Tama pris dabego te kibu kaneme te alta bogo me si me si badu sąsągą bilao,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","“Silama da, teda te bidigo te kibu sipsip delage me badu selama, te Genuai Bidiba mao, te pris dabego te ofa tiwai ulaibao. Agai te sipsip ili tigidali me, te danu badu elalubo genuai ili me sobadi yao. Agai te danu te tudi dili pageba mu togogiluao. Tama agai te haligade ili elalubo tigidali sao. ");
INSERT INTO mps_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Tama agai te si wabo hobuludu te ili dali sobadi, te sipsipgo wiegi yai te namba wan wabo homu lewa me sao. Te namba wan lewa homu, me namba tu homu lewa dali tama sabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Tama prisgo te nai dabe te alta sai daiba ulao, te Genuai Bidiba ofa tiwai dao.” ");
INSERT INTO mps_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Bidi me deligo te kibu meme ofa yainogo eyu da, agai te Genuai Bidigo geduba selasa pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","“Tama agai te meme kibu toboluba nogo muyu bolo elama, tama agai te meme kibu te Genuai Bidigo Be sunumi pąde ela muao. Tialima, te pris dabego te kibu kaneme te alta bogo me si me si badu sąsągą bilao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","“Te bidigo te kibu meme delage meba selama, te Genuai Bidiba mao, te pris dabego ofa tiwai emainao. Agai te haligade elalubo ili dabe tigidali sao, ");
INSERT INTO mps_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","te namba tu homu lewa dali te ili dabe me te namba wan homu lewa wiegi yai me sao. Agai te namba wan homu lewa me namba tu homu lewa dali sobaso, te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Tialima, prisgo te nai dabe selama, te alta sia daiba munama, te ofa tiwai yao, te Genuai Bidigo homu godolo elama, bugai homu yaibao. Te ili tigidali Genuai Bidigo naga dao. ");
INSERT INTO mps_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Te dage Israelgo te kibu ili ma kaneme munu me tugio. Habu mu dao. Dage me te nosali pedalubo hani wąį dabego te bomai po sesemane wali pidubadi geao. Te dage menaba bidigi pali bulude me te bomai po tagaligio, dagego te bomai po wali pao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Genuai Bidigo Mosesbolo walali, ");
INSERT INTO mps_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","te Israel we bidi dabebolo te tiwai po walomainogo yali, “Te bidi me we me deligo te bugagia homu kone palisąma, te Genuai Bidigo bomai po bolobaso da, teda agai sęgę sobao. Tama tibaso, aga te sęgę sela sąbo ofa ebaso usu dao.” ");
INSERT INTO mps_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Te Mosesgo po ma weyu, te tama po wali, “Te hetprisgo digi sęgę sali da, aga te tiali kolesaga dagede te tigidali we bidiba te sęgę ilibao. Tialima, aga te ogwa bidi kau kibu omai wiegi yai mu te tigide keni kenigo dolisąwai me deli sao. Te agai Genuai Bidiba ofa eyu, aga sęgę sela sąmainao. ");
INSERT INTO mps_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Agai te kau kibu te Godigo Ugwa Be sunumiba sela pelama, te kau kibu toboluba nogo muyu bolo elama da, nosali agai te Genuai Bidigo gedude ela mubaso da, usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Tama nosali hetprisgo te kau kibu kaneme selama, te Godigo Ugwa Be tomoba pobaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Te agai nogo tų deli te kanemeba munama, te danide elalubo kaneme te Tedali Gasagi Yai Mu Be Habuba te tede walobo genuai nami ugwa pąba sągąyao, tama Genuai Bidigo te tiwai są ebo sueibao. Agai te tama tiwai sę ebo te a naga olama si sogo usu nama tama yao. ");
INSERT INTO mps_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Tama aga te wiegi yai denami ebo hano holobo ofa ebo alta te Genuai Bidigo geduba Ugwa Be tomoba pao. Tama agai te kau kibu kaneme meba te kau kibu gąų kom me si me si tiwai alta me si me si dage badu teba mumainao. Te kau kibu kaneme me badu tigidali elalubaso da, te agai Ugwa Be sunumi badu alta buluba sela solama, te augwaligo ofa ulubo madi, te alta ulubo dogwa saliba te kaneme gelao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","“Nosali agai te bulmakau haligade elalubo ili delegabe tigidali sobadi yao, ");
INSERT INTO mps_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","te namba tu lewa dali te ili dabe me, te namba wan lewago wiegi yai te dali sao. Agai te namba wan lewa me namba tu lewa si dali sabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Tama prisgo te kibu ili dabe te ofa ulubo altaba ulama, te isigo tigidali dela silama, te keli hogomu naga elalueibao. Agai te bulmakau ili ulama, te deli haliga pedalumainogo ebo tiwai tobage ofa emainao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","“Tiali goli agai te bulmakau tigi wali me kibu mi badi, te tobolu, me sągą si, me nogo si, te haliga tomode ili delegabe me selama, ");
INSERT INTO mps_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","tama bulu badu peyu, te augwa te keli sągi soabo pesageba sela pao. Te pesage te Godigo gedude magi meda meni yai wiegi yai elalubao. Tama agai te sia nogonama, te kibu tigidali te isiba ulama, dela silama, te keli naga elalumainogo yao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Genuai Bidigo Mosesbolo walama, te Israel dabeba te tiwai po omainogo wai, “Te Israel we bidi tigidali te homu kone bugagia me palisąma, te augwaligo Genuai Bidigo bomai po bolobaso da, teda augwaligo sęgę sali dao. Te augwaligo sęgę sali te augwaligo me konesiąwai goli, augwa te yali kolesaga augwa dagede te sęgę sai dao. ");
INSERT INTO mps_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Te nosali augwa te yali sęgę konebaso da, teda augwa te ogwa bidi bulmakau me deli selama, augwa te sęgę sela sąmainogo ofa iyąo. Augwaligo te ofa te Godigo Ugwa Be sunumiba sela pomainu yao. ");
INSERT INTO mps_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Tama te Genuai Bidigo gedude te Israel hetman tobolu bidi dabego nogo te bulmakau toboluba munama, te nosali augwaligo te bulmakau ela mumainao. ");
INSERT INTO mps_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Tama hetprisgo te bulmakau kaneme meba te Ugwa Be tomoba sela pao. ");
INSERT INTO mps_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Tama agai nogo dani deli te kanemeba munama, tama te nogo danide elalubo kaneme te pąde elalubo genuai nami ugwa te Tedali Gasagi Yai Mu Be Habu seselalubo teba sąbaso, te Genuai Bidigo sueibao. Agai te a naga olama, si sogo te tama sę ebaso, usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Tama agai te kau kibu kaneme meba te me si me si wali kom gąų te alta wiegi yai denami hano holobo te Genuai Bidigo gedu badu mubaso, usu yaibao. Te kau kibu kaneme tigidali me badu elalubadi ebaso da, agai te Ugwa Be sunumi bulu badu te augwaligo ofa ulubo badu sela solama, te alta aiyadu dogwali madiba gelao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","“Nosali agai te bulmakau ili tigidali selama, te alta siaba ulao,” po wali. ");
INSERT INTO mps_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","“Hetprisgo te deli tigi poąį kolesaga te bulmakaude yao, te agai aga sęgę sela sąyu ofa yali bulmakaude yali kolesaga tiwai ebaso usu yaibao. Te tiwai naga hetprisgo te tigidali we bidigo sęgę sela sąbo kolesaga eyu, tama tibaso da, teda Godigo augwaligo sęgę me sela sąwaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","“Nosali agai te kau kibu delage selama, te pesage bulu badu sela solama, te isiba ulao, te aga digi sęgę sela sąyu, te bulmakau ofa yali tiwai ebaso usu yaibao. Tigidali we bidigo te kau kibu ofa tama ebo, te augwa sęgę sela sąyu ebao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Genuai Bidigo Mosesbolo waliyu, te Israel dabeba te tiwai po omainogo yali, “Te tobolu bidi me deligo te homu kone bugagia me palisąma, agai Genuai Bidi Godigo bomai po bolobaso da, teda sęgę saibao, te aga ebo kolesaga dagede te sęgę sobao. ");
INSERT INTO mps_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Te nosali agai te sęgę konebaso da, teda agai te wiegi yai meme kibu omai me deli sao, te keni kenigo aga tigi me dolisąwai, te ofa yagasu selasa asao,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","“Te Genuai Bidigo gedude agai te meme toboluba bolo nogo munama, tama nosali agai te kibu dabe elama, te isiba ulama domainu ofa ebo pesagede te meme kibu elimainao. Te meme kibugo aga sęgę sela sąbo ofa ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Tama prisgo nogo dani deli te meme kibu kanemeba munama, te alta kom me si me siba te dwasianu kaneme munana pao. Te elalubo kaneme yai baso da, agai selama, te alta aiyaba dogwa sali dedageba gealuao. ");
INSERT INTO mps_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Tama agai te meme ili altaba ulao. Prisgo te meme kibu elama, te meme ili me te deli haliga pedalumainu ebo ofa tobage tiwai ebaso usu yaibao. Te tiwai naga prisgo te hetman tobolu bidigo sęgę sela sąbo kolesaga eyu, ofa yao, te Godigo agai sęgę sela sąmainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Te Genuai Bidigo Mosesbolo te po waliyu te Israel dabeba e tiwai po pusao wai, “Te we bidi augwali me deligo te bugagia homu konesiąma, te Genuai Bidigo bomai po bolobaso da, teda agai te sęgę sali, te aga dagede te kolesaga ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Tialima, nosali aga homugo te sę koneagasu te aga sęgę sela sąbo ofa yaibao. Te aga pris ma tobolu bidi te meni baso da, teda agai te meme kibu so te dwai keni kenigo tigi me dolisąwai wiegi yai mu me deli selama, te ofa yabo sela pobaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Te agai meme kibu toboluba bolo nogo munama da, te nosali agai te siago tigidali dabo ofa ebo pesageba sela pelama, ela mubaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Tama prisgo nogo dani me deli te meme kanemeba munama, te dwasianu kaneme te alta gąų me si me si teba muao. Tama te kaneme meba elalubadi yaibaso da, te selama, te alta pagede aiyaba gealuao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","“Tama agai te meme kibu ili tigidali te altaba ulao. Prisgo te meme ilide te deli haliga pedalubo ofa ebo tobage kolesaga tiwaigo te ofa yao. Tama agai ili te altade ulao, te Genuai Bidigo te ofa ebo denami godolo yaibao. Te tiwai naga te prisgo te bidi ma wego sęgę sela sąbo ofa ebo kolesaga ebaso da, te Godigo agai sęgę sela sąwaibao.” ");
INSERT INTO mps_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Te bidi me deligo aga sęgę sela sąyabo ofa yabo sipsip kibu sela asobaso da, agai te so kibu sipsip keni kenigo tigi dolisąwai wiegi yai mu sela asiyu, te usu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Agai te kibu sipsip toboluba bolo nogo mumainogo elama, te nosali agai te kibu sipsip elainogo da, te isigo tigidali mu dela silibo ofa ebo pesagede elama, te ofa ebo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nosali prisgo nogo dani deli te sipsip kanemeba munama, tama kaneme dwasianu te alta gąų me si me si elaluboba muao. Te me badu elaluali kaneme agai selama, te ofa ebo alta dedageba gelao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","“Tama agai te sipsip kibu ili te altaba ulao. Prisgo te deli homu naga pedalumainu te ebo tobage ofa ebo tiwai gilama, te sipsip ili ofa eyu te tiwai tama yao. Tama agai te ili altade gasa ofa dali eyu, te augwaligo isigo tigidali domainogo te ulama, Genuai Bidiba mabo ofa tiwai yao. Te tiwai naga prisgo te bidigo sęgę sela sąbo ofa ilao, te Godigo agai sęgę sela sąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Te Genuai Bidigo Mosesbolo waliyu, te Israel dabebolo te tiwai po omainu yai, “Te augwaligo bidi me deliba hanaluyu, te po tų kotba pelama, te agai gasa bidigo sę suali po hanilabo po weyu, ma te agai gasa bidigo wabo po odali, tiali goli te bidigo te sę yali po hanilisąbaso da, teda aga te aga dagede te sę Godigo gedude geda muani dao.” ");
INSERT INTO mps_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Ma te bidi me deligo homu kone bugagia me palisąma, te Godigo te po weyu te wiegi yai meni da po wali nai me deliba nogogo diąyu ebaso da, teda te bidi te Godigo gedude meda yai pedalubao. Tama te hasa sibi te Godigo wiegi yai meni da po wali da, te aga isilama, aga tigi te tǫde munalubadi, tama te bidigo te hasa tigiba bugagia tonosiąma diąyagasobaso da, teda bidi te meda pedalubao. Te aga yali sę konebo sogo da, teda aga te yali sę dagede sęgę elalubo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Ma, te bidi me deligo te homugo bugagia konesiąma, te bidi me deli, me we me deli tigide pedelali sęde nogogo diąyu elama, te Godigo gedude meda elalubaso da, teda te bidi God gedude meda yai pedalubao. Te aga yali kolesaga aga koneagasobo sogo, aga yali sę dagede te sęgę elalubo dao.” ");
INSERT INTO mps_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Ma, bidi me deligo bugagia homu konesiąma, te nai me delide mu po dao po ugwaba obaso da, teda agai Godigo gedude dwai sę ebao. Te aga yali sę konebo sogo da, teda aga yali sę dagede te sęgę sabo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Te bidi me deligo te tobage dobo sę tiwai ebaso da, teda aga yali sę dagede geda mubaso, te sę yali po hanilama pusao. ");
INSERT INTO mps_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Tama agai te sipsip so kibu deli, ma meme kibu so deli selama, te Genuai Bidiba selasa asama, te aga yali sęgę sela sąbo ofa tiwai yagasao. Tama prisgo te kibugo te bidigo sęgę sela sąyu ofa ilibaso da, Godigo agai sęgę sela sąwaibao.” ");
INSERT INTO mps_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Te bidi me aga dagede te mone sǫą pelama, agai te sipsip ma meme abelabo mone meni baso da, agai te ba hi si selama, te aga yali sę sela sąwainu Genuai Bidiba selasa asao. Te ba hi me deligo te sęgę sela sąbo ofa tiwai eyu, me deligo te siaba tigidali ulama, te dela silibo ofa eyu yao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","“Tama agai te ba hi si te prisba sela pelama, te prisgo te ba hi mego te sęgę sela sąbo ofa tiwai yao. Prisgo te ba hi mage togwa sąnama, te tobolu sela sągio. ");
INSERT INTO mps_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Tama agai te kaneme dwasianu selama, te alta bogo badu sąsągą bilao, te gasa me badu kaneme te alta dogwa sali madiba gealuao. Te ba hi te sęgę sela sąbo ofa dao. ");
INSERT INTO mps_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Nosali prisgo te me elalubo ba higo te isigo tigidali dela silibo ofa yao. Agai te tobage ebo ofago bomai po wali pao. Te tiwai naga prisgo te bidigo sęgę sela sąbo ofa ebaso da, teda Godigo agai sęgę sela sąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Te bidi me aga dagede aga te mone mu sǫą pelama, agai te ba hi si abelabo mone usu isąbaso da, teda agai te kilogram deli yai wiegi yai plaua selama, selasa asao. Tiali goli, agai te oliv wel me, te wiegi yai denami hano ilibo pauda me, te plauaba te wit ofa ebo tiwai me igio, magi baso meni, te plaua te sęgę sela sąbo ofa tiwai ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Tama agai te plaua prisba sela pelama, te prisgo te plaua dwasianu nogode selama, te plaua tigidali te Genuai Bidiba ofa ilali dąį tiwai yaibao. Tama prisgo te dwasianu plaua te ofa ebo nai dabe dali te altaba ulao. Te plaua te sęgę sela sąbo ofa dao. ");
INSERT INTO mps_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Tama tialima, prisgo te bidigo sęgę sela sąbo ofa ebaso da, teda Godigo agai sęgę sela sąbo dao. Te plaua me badu munalubadi yaibaso da, te prisgo plaua dao, te wit ulubo plaua ofa tiwai ebao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Genuai Bidigo Mosesbolo waliyu, te Israel dabeba te tiwai po omainogo yali, ");
INSERT INTO mps_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Te bidi me deligo Genuai Bidiba te nai dabe me maiabo homu yai te agai homu kone ebo gegeda pobaso da, teda agai sęgę me elalubao. Tialima, te bidigo te Genuai Bidiba te masiąwani nai wei ponoyu, te aga yali sę silimainu ofa mao. Te prisgo agabolo walama, te wiegi yai sipsip omai kibu me deli sao, te keni kenigo aga tigi me dolisąwai, selasa asao. Tama prisgo te bidigo sela asabo sipsipde mone namba dąį ilaibao. Tama bidigo te tiwai sipsip me deli selama, te prisba selasa asao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","“Te mone me doado bage hasia Genuai Bidiba masiąwani nai, megi agai mayu, te agai gasa dali ugwadu daganama mao. Te agai negeli a naga elalubaso da, teda agai a naga me deli ugwadu daganama, wei ponao, te negeli elaluali dodoliyu tama tiao. Agai te prisba mao. Te prisgo te bidigo sela asali sipsip selama, tama prisgo te bidigo aga sęgę sela sąbaso da, teda Godigo agai sęgę sela sąwaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Te bidi me deligo bugagia homu kone palisąma, te Genuai Bidigo bomai po me deli bolobaso da, aga dagede te Godigo gedude dwai sę yali sęgę elalubao. ");
INSERT INTO mps_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Tialima, agai te ofa me deli prisba sela pelama, te dwai sę yali sela sąyu isilao. Prisgo agabolo weyu, te wiegi yai sipsip omai me deli somainu yao, te keni kenigo aga tigi me dolisąwai, sela asao. Te sipsip sesali bidiba te mone namba dąį ilao. Tama te bidigo te sipsip kibu tiwai me deli selama, te prisba sesao. Tama prisgo te bidigo sęgę sela sąyu ofa elama, tama Godigo agai sęgę sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Te aga yali sę dagede, te Genuai Bidi gedude agai sęgę elalubao. Tama tibaso, te sipsip ofa ilao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Genuai Bidigo Mosesbolo po waliyu, te tiwai po Israel dabeba omainogo yali, ");
INSERT INTO mps_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Te bidi me deligo aga abagigo doado bage bugagia tolaluainu selama, tama agai te nai doado bage ma maiabo homu isąbaso da, teda agai sęgę sobao. Te agai abagigo nai wi sobaso, ma agai augwali tibo po ola menama, te agai doado bage anoma elama sobaso me, ");
INSERT INTO mps_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ma agai gasa bidigo hagawai nai sulama, te tibo po weyu, ‘Mu po obao, eno me subeo,’ obaso da, teda aga sęgę sabo dao. ");
INSERT INTO mps_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Bidigo te tobage kolesaga dabe ebaso, te sęgę ebao, te agai nai wi sabo kolesaga me tibo po wabo kolesaga ebaso, te doado bage wei ponao. Te aga yali kolesaga silimainogo ofa ebo sogo da, teda agai te doado bage aga ayabolo te nai tigidali wei ponao. Te agai 5 nai saibaso da, teda agai te 6 te tama nai wei ponobaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Te sipsip omai me deli agai te prisba sela pelama, te aga yali kolesaga sia somainogo te Genuai Bidiba ofa eyu dola palobo sę yao. Prisgo agabolo walama, te wiegi yai sipsip mu sao po wao, te keni kenigo aga tigi me dolisąwai selama sesao. Tama hasia bolo prisgo te bidigo sesebo sipsip abelabo mone nogiyu dąį ilao. Tama bidigo te sipsip tiwai te prisba selasa asao. ");
INSERT INTO mps_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Tama prisgo te bidigo sęgę sela sąyu, te Genuai Bidiba ofa ebaso, tama Godigo agai sęgę sela sąwaibao,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Nago te siaba tigidali ulubo ofa ebo bomai po te Aron aga ogomani dabe daliba te po walao. Augwaligo te ofa ebo nai te altaba ulama, te isigo dedubadi, te be posoboba usu nao. Te sia bogoli idubadi, te sula somainu me elamu dao. ");
INSERT INTO mps_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Nosali prisgo te pęwadage trausis te augwa wiegi yai nami ugwago nigai trausis gudama, tama te bobage tagalalubo ugwa me munama, te aga altaba pelama, te keli sao, te ili yai ofa elalubo madi, te alta pąde tǫba gealuao,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","“Nosali aga gudali ugwa hasegelama, te sia dali keli selama, te pesage nigali buluba sela solama, te eno gedude meda meni yai pesage me deliba muao. ");
INSERT INTO mps_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Tama te altade nogani sia sesemane didumainao, te munu me sula sągio. Tigidali side kigamu prisgo te sia nogonama, tama agai te ofa yabo kibu hasa dabe selama, te siago tigidali domainogo siaba ulaibao. Te deli haliga pedalubo ofa yabo kibu ili selama, tama te siaba uluyu yao. ");
INSERT INTO mps_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Sesemane sogo te altade sia ula idumainao. Dagego te sia sula somainogo me elamu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Te Genuai Bidigo Mosesbolo te po walima, te Israel dabeba te tiwai po omainu yali, “Te wit ulubo ofago bomai po e tiwai. Te Arongo hanigo pris me deligo te ena Genuai Bidiba te wit ulubo ofa mao, te alta pąde yao. ");
INSERT INTO mps_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Tama prisgo te dwasianu plaua te augwaligo wel muai sobadi, te ofa wiegi yai denami ilabo pauda tigidali sao,” wali. “Tama agai te tigidali te alta siaba tigidali ulao. Te dwasianu ofago te tigidali ofa dąį ilibao, te enaba augwaligo mobao. Tama eno te ofa denami odama, eno godolo homu elama, bugai homu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“Te plaua me badu munalubaso da, te pris dabego tuiyąo. Augwaligo te plaua selama, te yis meni yai bret nigilama, te augwaligo eno Ugwa Be mesalode tuiyąo. ");
INSERT INTO mps_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Augwaligo te plaua dali te yis dali taluama te bret ulamuo. Augwali odolali ulao, magi baso meni, te plaua te eno nai mu tama, te sęgę sela sąbo ofa tiwai, me te bidigo yali dwai sę silimainogo ebo ofa tiwai ebao. Tama eno te plaua dabe te prisba dąį ilali. Te ofa ebo naigo te augwa me badu somainogo ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tama te Arongo hani pris bidi dabego te bret tumainao. Augwaligo te ebo ofade te Israel dabego enaba ofa ebo nai dabego somainao. Sesemane sesemane sogo nosali, te Arongo hani bidi dabego te ofa ebo nai me badu munalubo te augwaligo somainao. Tiali goli, te gasa bidigo diąwani ma te nai me deli te tuabo ofaba dagana sobaso da, teda te bidi ma te nai te habu mu selama elalueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Genuai Bidigo Mosesbolo te tama po wali, ");
INSERT INTO mps_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Te Arongo hani pris dabego te augwali gesi sogo mu hasia te pris sę sabo side, augwaligo te ofa me deli yao,” po wai. “Te bidi me deli augwaligo pris pedalumainogo augwaligo te ni oliv wel aga toboluba geleyu ebo side da, teda agai ofa enabolo yao. Agai te kilogram deli yai wiegi yai plaua deli sao, te wit ulubo ofa tiwai usu nama yao, te pedai me badu kigamu ofa eyu te me badu pedai te giliga dega sigulubadi yao. ");
INSERT INTO mps_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Agai te plaua dali ni oliv wel dali begelama, te praipende bugagia ulao. Nosali agai pepedama, te enabolo mao, Genuai Bidiba. Tama eno te ofa ebo denami odama, te eno godolo elama, bugai homu yaibao. ");
INSERT INTO mps_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Nosali nosali te Arongo hani bidi dabe augwali te hetpris pedelaibao, teda augwaligo te tobage ofa enaba yao. Te augwaligo te siaba tigidali domainu ulubo ofa emainu elama, te keli naga elalumainao. ");
INSERT INTO mps_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Te pris dabego te augwa digi sesali te wit ulubo ofa dwasianu me tugio. Augwa te siago tigidali domainu sula tagalao weyu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Nago te Aron aga ogomani dabe daliba te sęgę sela sąbo ofago bomai po walao. Te bomai po e tiwai dao. Augwaligo te sęgę sela sąyąbo ofa yabo kibu dabe te eno gedude elibaso, te usu yaibao. Augwaligo te kibu elama, te ofa eyu, tigidali siaba ulama dela pabo pesagede te kibu elao. Te eno ofa tedali mu ebao, te habu mu selibo dao. ");
INSERT INTO mps_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Prisgo te sęgę sela sąbo ofa yali, agai digi te kibu mi eno Ugwa Be mesalode tumainao. ");
INSERT INTO mps_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Te pris nogi elalusąbo bidigo, ma te magi nai me deligo te ofa ebo kibude diąbaso da, teda te nai me ma te bidi te eno nai mu tama pedalumainu elama, te habu selalumainao. Te kibu kaneme te name ugwa me deliba tulalubaso da, dagego te name ugwa eno Ugwa Be obo tomode ąį telayao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","“Te prisgo te meme mi te tǫgo nigali sospen senede ulubaso da, teda nosali agai te sospen sene aluao. Tialima, agai te brasgo nigai sospende ulali da, teda nosali agai te sospen ąįgo tedelama, bugagia holobo naigo brasim yao. ");
INSERT INTO mps_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mena pris hani bidi dabego homu godolu eyu, agai te ofa ebo kibu mi tuainu eyu da, te aga tumainao, magi baso meni, te tobage ofa te eno nai mu dao. ");
INSERT INTO mps_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Tiali goli, te hetprisgo te ofa ebo kibu kaneme me badu selama, te eno Ugwa Be tomoba pelama, te sęgę sela sąbo sę ebaso da, teda te pris dabego te ofa ebo nai kibu mi me tulamuo. Augwaligo te isiba tigidali ulama, dela silama, te keli naga elalumainao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Te Godigo Mosesbolo walama, te Israel dabeba e tiwai po walomainogo yali, “Te dobo sę yali silimainogo ebo ofa dabe te Godiba dolo mu ebao, te habu mu selibao. Te ofa dabe ebo bomai po e tiwai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Augwaligo te ofa yabo sipsip dabe elainogo da, augwa te sipsip dabe elama, te ofa eyu, te isiba tigidali ulama, dela silibo pesagede te sę yao. Tama augwa te sipsip kaneme te alta bogo me si me si te badu sąsągą bilao,” po wali. ");
INSERT INTO mps_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“Augwaligo te sipsip kibu ili selama, te altade Godiba ofa ilao. Augwaligo te kibugo nisali danu sobadi, te kibu haliga tigidali bealubo te ili delegabe me sao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","“Tama augwa te hobuludu si dali, tede daganalubo ili me sobadi yao, te sipsipgo polalubo dini homu me deli sao. Augwa te polalubo dini homu me deli siyu, te si wabo homu hobuludu si me sao. ");
INSERT INTO mps_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Tama prisgo te kibu ili tigidali te alta siaba ulao, augwa te Genuai Bidiba mabo ofa tiwai ebao. Te sipsip ofa ebogo te augwa yali dobo kolesaga silimainu ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Te pris hani dabe mena bidigo tuabo homu godolo ebaso, aga te ofa yali sipsip mi tumainao. Te Godiba dolo ofa tama ebao, agai te pris dabebolo dąį ilali. Tama tialima, augwa te Godigo sel Ugwa Be obo tomode tubaso usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Te dwai sęgę sela sąbo ofago bomai po me, te dobo kolesaga silimainogo ebo ofago bomai po me, te si te augwa bomai po dedeli naga elalubao. Tibaso, prisgo te kibugo ofa ebo side te tobage ofa si yaibao, aga digi te ofa ebo bulmakau mi ma sipsip mi somainu ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Te prisgo te isigo tigidali dela silibo ofa me deli te kibu dabego ebo sogo da, teda aga digi te kibugo tigi wali somainu yaibao. ");
INSERT INTO mps_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Te tiwai tama naga te prisgo te augwa wit te moni nai ulubo be nogi aven ma sospende, me praipende ulai wit te ofa ebaso da, aga digi te sela tubo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Te tigidali ulusiąwai witgo ofa ebaso, te augwaligo ni oliv wel dali taluali, te tigidali Arongo hani prisgo dao. Te olo plauago ofa yali nai me, te me prisgo saibao. Augwaligo te pris deli deli usu nama, tama te nai dobola sao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Te Godigo Mosesbolo walama, te Israel dabebolo te tiwai po walomainogo yali, “Te God dali deli haliga pedelabo ofa ebo bomai po, e tiwai elalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Te bidi me deligo Godiba buba hwi wabo homu eyu, agai te deli haliga pedelabo ofa yainu eyu da, agai te hasa dali te bret pedai dage agai yis meni yai plauago nigai, tego ofa yao. Agai te ni oliv wel dali taluali plauago nigai bretgo te ofa yao. Te agai te tama tiabo homu me ebaso da, aga te bisket dabe te oliv ni welgo pilai, tego ofa yao. Te meni baso da, agai te wiegi yai plaua dali, te ni oliv wel dali taluama, tama skon nigai, tego ofa ebaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Tama me agai te yis elalubo bret me badu pedai dage selama, tama te Genuai Bidi dali deli haliga pedalubo ofa yabo usu yaibao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","“Agai te ofa yabo haniani bret deli deli pedai dage me deli selama, te Genuai Bidiba mao. Te prisgo te kibugo kaneme selama, te alta bogo badu sąwai te pris bidigo te bret pedai dage dabe somainao. ");
INSERT INTO mps_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Te bidigo ofa ebo side augwaligo te kibu mi me badu elaluali tigidali tuao. Augwaligo te nosali kigamude tueibao olama, te kibu mi me elalumainu sula tagalamu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Te bidi me deligo deli haliga pedelabo ofa yabo homu yai, te aga Godiba po dąų wali usu nainogo, ma te aga homu godolo ebaso, te ofa Godiba olo dali mobaso da, teda augwa te ofa yali kibu mi te bidigo ofa ebo side tubadi, te nosali me tubo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Tama te si wali side augwa te nai tula silisąma, te sela wabo sogoba usu nubaso da, teda augwaligo te isiba ulama, te isigo tigidali dela silaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","“Augwaligo te sela wabo side te kibu mi tubaso da, teda Godigo te bidigo ofa ebo me sogobeo. Menio. Te Godigo te homu yaibao, te agai ofa te dwai kugumini yai da homu yaibao. Tama niwai bidigo te kibu mi tubaso da, te agai dagede dobo sę ebao, te sęgę elalubao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Te deli haliga pedalubo ofa ebo kibu mi te Godigo gedude wiegi yai isąwai naide diąnalubaso da, teda augwaligo te kibu mi munu me tulamuo. Menio. Augwaligo te nai mi dabe tigidali isiba ulama, te isigo mu dela silimainao.” “Te Godigo gedude meda meni yai wiegi yai we bidi augwaligo te deli haliga pedalubo ofa ebo kibu mi tubaso da, te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Tiali goli, bidi me deli wiegi yai pedalisąbadi agai te ofa ebo mi tubaso da, teda aga te Genuai Bidigo we bidi hani tomode me bidigobeo,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“Te Godigo gedude wiegi yai me isąwani naiba nogo diąwani bidi, tagalao, agai te wiegi yai isąwai meda yai naiba nogo diąwani, ma te bidigo tigide pedalubo naiba diąwai baso, ma te wego tigide pedalubo naiba nogo diąnama, tama nosali agai te ofa yali kibu mi tubaso da, teda aga te Genuai Bidigo we bidi hani tomode me bidigobeo,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Genuai Bidigo Mosesbolo walama, ");
INSERT INTO mps_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","te po te Israel we bidi dabeba mao wai. Genuai Bidigo e tiwai po wali, “Dagego te kibu bulmakau me sipsip meme ili me tugio,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","“Te bulmakau me deli aga digi odolali isaibaso, te ili dagego me tugio. Te me bulu uni hasago te kau kibu ela mueibaso me, dagego kau kibu ili me tugio. Tialima, dagego te kibu ili selama, gasa sę yao. Te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Te augwaligo Genuai Bidiba ofa ebo kau kibu ili te bidi me deligo tubaso da, teda aga te Genuai Bidigo we bidi hani tomode me bidigobe dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“Dage Israel, dage te mena bulu pedaide bidibo we bidi, dagego munu me te kibu hasa me ba dabe te kaneme dali me tulamu dao. Te kolesaga ebo habu mu selibao. ");
INSERT INTO mps_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Bidigo ma wego te dąų wali bomai po bolobaso da, teda aga te Genuai Bidigo hani tomode munu me bidigobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Te Genuai Bidigo Mosesbolo waliyu, ");
INSERT INTO mps_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","te Israel we bidiba te po momainogo yali. Agai te tiwai po wai, “Bidigo te deli haliga pedelabo ofa sela aselama, agai te kibu pedai te Genuai Bidiba dolo dąį ilao, te aga ofa te dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","“Te bidi aga digi te Genuai Bidiba ofa yabo nai kibu sesemainao. Te Genuai Bidiba maiabo kibu pedai dage e tiwai sesao, te kibu ili me kibu baugo mi tama dao. Tama te bidigo Genuai Bidiba ofa e tiwai ilao. Agai te kibu bau mi te nogo tolaluyu, te Genuai Bidigo gedude iba oba hogabo sę yao. ");
INSERT INTO mps_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Tama nosali prisgo te alta siade te kibu ili ulao, tialima te pris augwa te kibu bau sao, te augwa tuabo nai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Te kibugo dolo sągą dagego prisba mao, te olo dali maiabo nai dao. Te pedai badu te deli haliga pedelabo ofa eyu, ");
INSERT INTO mps_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","te prisgo te kibu kaneme me ili tego ofa ebo dao. Tama te ebo pris bidigo te dolo sągą somainao. ");
INSERT INTO mps_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Genuai Bidigo digi te kibu bau me dolo sągą dage Israel we bidide selama, tama te kibu pedai dage si te pris dabeba mawai, te augwali Arongo hani dabe dao. Tama tialima, sesemane sogo nosali te pris dabego te ofa ebo nai pedai dage somainogo yao. ");
INSERT INTO mps_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Te hasa pedai dage Genuai Bidigo digi sali, te dage we bidi dabego agaba ofa ebo nai dao. Te Genuai Bidigo te hasa pedai dage te Aron aga ogomani dabe daliba dąį ilama, te side agai augwali te pris sęba munama bidai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Te side naga tama Genuai Bidigo te Israel augwaliba walama, augwaligo te ofa yali kibu pedai dage te pris dabe augwaliba mao po wali. Tama augwaligo te bomai po sesemane sesemane sogo wali pidubadi geąo,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Te tigidali po te siaba tigidali ulama dela silibo ofa dabego bomai po, te wit ulubo ofa dabe me, te sęgę sela sąbo ofa dabe me, te dobo kolesaga augwa dagede yali silimainu ebo ofa me, te bidi pris pedalumainogo ofa ebo me, te God dali deli haliga pedalubo ofa me, te tama ofa dabego bomai po dao. ");
INSERT INTO mps_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Genuai Bidigo te bomai po dabe te Israel dabe te masigi kemi tǫ wa pai bulude bidali sogo, te bulu du Sainaide Mosesbolo te bomai po mawai. Te Godigo te Israel we bidi augwaliba te ofa yao po wali side, agai te bomai po dabe augwaliba mawai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Te Genuai Bidigo Mosesbolo e tiwai po wai dao, ");
INSERT INTO mps_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Te Aron me aga ogwa dabe dali selama, te eno sel Ugwa Be sunumiba pao. Te pris dabego gudubo ugwa me, te sęde augwali dąį ilibo wel me somainu elama, tama te bulmakau omai me deli, me sipsip omai si, te sęgę sela sąyu ofa yabo nai selama, te basket wa me delide te yis meni yai bret pągąnama, tama te nai dabe me te sel Ugwa Beba selasa pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","“Tama nosali tigidali we bidi te sel Ugwa Beba asomainu i wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Tialima, Mosesgo Genuai Bidigo po odama, te tama sę yali. Tama tigidali we bidi sisinagasali. ");
INSERT INTO mps_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Tama Mosesgo augwaliba walali, “Eno megi e yainogo ebo sę da, te Genuai Bidigo enabolo te sę yao po polobadu obaso ebao.” ");
INSERT INTO mps_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Tialima, Mosesgo Aron aga ogwa dabe dali selama, te we bidi augwali geduba dodolagaselama, tama agai augwali ąįgo paluali. ");
INSERT INTO mps_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Tama agai te holobo ugwa Aronba bolo gudulali. Tama agai te bobage name ugwa te Aron tabidu belali. Tama Mosesgo bobage aiyaba tagalalubo ugwa te genuai name ugwa Aronba gudulama, te welia kukulu au yai selama, te genuai ugwago te Aron tabidu soani kekalio. ");
INSERT INTO mps_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Tama agai te dwasianu name ugwa Arongo hagawiade kekelama, tama te Godigo homu kolesaga konebo masigi si muani, te ugwa agebele poketde muai elaluai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Tama agai bobage ugwa me deli te Arongo tobolude bagulama kęnani. Tama agai te dwasianu nai medal gol selama, Aron te Godigo bidi mu da olama dąį ilu, te ugwa name Arongo gesabidide ugwadu daganani. Mosesgo te sę dabe te Genuai Bidigo agabolo po wali gilama yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Nosali Mosesgo te Godigo nai dabe dąį ilainogo te wel selama, te Godigo sel Ugwa Bede pilibadi, te be tomode elalubo nai tigidali me pilali. Tama te tiali kolesagade te nai doado bage dabe te Genuai Bidigo nai dolo da weyu, tama tiali dao. ");
INSERT INTO mps_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Tama agai te wel habu selama, te nogo a naga olama, me badu nogo si sogo te altaba sąwani, te altade sę yabo doado bage me, te wę paubo moni genuai disba me agai tebolba tama tialio. Te tiali kolesagade agai te nai dabe te Genuai Bidigo nai mu da weyu dąį iliyu tiai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Tama agai wel ąį dwasianu te Aron toboluba gelali, te tiali kolesagade te Aron te Genuai Bidigo pris mu tiwai da olama dąį ilai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Nosali Mosesgo te Arongo ogwa dabe sela asama, augwaliba te holobo ugwa gudulama, tama agai te bobage name ugwa pedai te kukulu tiwai augwaliba belama, te augwali tobolude name ugwa kęnani, te Genuai Bidigo wali po tiwai gilama yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Te silama da, tialima Mosesgo te bulmakau omai te bidi augwaligo te sęgę sela sąbo ofa yainu sela asali, te Aron aga ogwa dabe daligo te bulmakau toboluba nogo mumainao wali. ");
INSERT INTO mps_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Tama nosali Mosesgo te kau kibu elama, te aga kaneme salio. Agai te kaneme dwasianu te nogo dani delide selama, te alta bogo me si me si badu te komde muna muna pali. Te kolesagade agai te alta God gedude wiegi yai tedali mu pedalumainu ilai dao. Nosali te elaluali kaneme tigidali selama te alta aiyaba dogwa saliba gelali, te tama kolesagade te alta te Godigo mu da olama, habu seliyu, te dąį tiwai ebao te po wali. ");
INSERT INTO mps_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Tama Mosesgo te kibu kau haliga bealubo kibu ili delegabe tigidali sobadi, te hasia polalubo dini homu te wiegi yai sobadi, te si wali homugo si siyu, te ili dali selama, tama agai te nai dabe altade ulama, te keli naga elalu yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Tama agai te kibu kau pedai dage me badu dali, te wali me, kibu mi me, te haliga me, tigidali selama, te pesage nigali buluba sela soali. Tama agai te sia nogonama, te kau kibu ulama, te siago tigidali dela silai. Agai te Genuai Bidigo agabolo wali po gilama tama sę yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Nosali Mosesgo te sipsip kibu omai si elaluali te me deli agai sela asali. Te isigo tigidali dela silabo ofa yabo sipsip dao. Tialima, Aron aga ogwa dabe daligo te sipsip toboluba nogo muai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Tama nosali Mosesgo te sipsip ela munama, te sipsip kaneme selama te alta pedai me si me si badu sąsągą bilai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Agai te kaneme sąsągą bila silibo si da, teda agai te sipsip kibu sikilama, te haliga bono dabe me, te kibu sipsip sągą si me ąį telawali. Te nosali agai te kibu tobolu me ili me te sipsip kibu delage tigidali selama, te altaba munama, te tigidali siaba ulama, te keli naga elalueibao. Agai te Genuai Bidigo po wali gilama yali. Te siago tigidali dabo ofa ebo sipsip te sipsip ofa ebaso, te Genuai Bidigo te denami odama, te bugai haliga eyu yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Tialima, Mosesgo gasa kibu sipsip omai sela asali, te bidi pris sę emainogo dąį eliyu ofa ebo sipsip. Te Aron aga ogwa dabe dali augwaligo te sipsip toboluba nogo muai. ");
INSERT INTO mps_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Tama nosali Mosesgo te kibu sipsip elama, te dwasianu kaneme selama, te Arongo dolo olo aiyaba muani, te dolo nogode te a wabo nogo danide, me te dolo sągągo te a wabo sągą danide pilibadi yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Nosali agai te Arongo ogwa dabe sela aselama, te dwasianu kaneme te augwaligo dolo olo badu aiyaba muani, me te dolo nogo te a wabo nogo danide mubadi, te dolo sągą te a wali sągą danide muyu yali. Tama agai te me badu elaluali kaneme selama, te alta bogo me si me si badu sąsągą bilai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nosali agai te kibu sipsip ili salio. Agai te nisa pai kibu danu me sali, te haligade bealubo kibu ili delegabe sobadi, te polalubo dini homu wiegi yai sobadi, te si wabo te kibu homugo si siyu te ili dali sali, te sipsipgo dolo sągą me sai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Nosali Moses te yis meni yai bret pągąnalubo basket te augwaligo Genuai Bidiba mabo bret munalubo madi pelama, tama agai augwaligo te yis dali ulisąwai bret sali, te augwa plauago nigai bret me deli te oliv wel dali begelali, me te bisket me deli sobadi yali. Tama agai te nai dabe te kibu ili me kibu dolo sągą te nai si daiba muai. ");
INSERT INTO mps_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mosesgo te nai dabe te Aron dali aga ogwa dabe daligo nogoba muani, tama augwaligo nogogo te nai tolaluyu, te Genuai Bidigo gedude te nogo edaba ugwaba hoga walio. ");
INSERT INTO mps_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Tama nosali Mosesgo te nai dabe augwalide ma selama, tama te siago tigidali dabo ofa ulubo alta kibu sipsip daiba te muani, tama te nai tigidali mu te isiba ulama, dela silali. Te nai dabego te pris nigali bidi dąį ebo ofa elama, te denami ebo Genuai Bidigo odoyu, godolo eyu, bugai haliga yai dao. ");
INSERT INTO mps_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Tialima, Mosesgo te ofa yabo sipsip kibu bau selama, te nogode tolaluyu, ugwa eda te Genuai Bidigo gedude tama yalio. Te sipsip pedaigo te augwa pris dąį ebo ofa yali, te kibu mi Moses aga digi tumainu yai. Mosesgo te Genuai Bidigo agabolo wali po gilama te sę tigidali ela silai. ");
INSERT INTO mps_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Te Mosesgo wel habu dwasianu selama, te gesi pris dąį ilainu sali, te agai alta bogo badu sąsągą bilabo kaneme sali. Tama agai te kaneme me wel te Aron dali aga ogwa dabe daliba me augwaligo ugwaba me segene sągąwani. Te tama tiali kolesagade Mosesgo te Aron dali, aga ogwa dabeba dali te me augwa ugwaba me dąį ilama, te Genuai Bidigo mu dao wali. ");
INSERT INTO mps_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Nosali Mosesgo Aron dali aga ogwa dabeba me te tama po wali, “Eno dagebolo te kibu mi te Godigo sel Ugwa Be sunumiba sela pelama, te posolo ąįde ulama, te basketde munalubo bret dali tuao wali. Te basketde te pris dąį ilibo ofa ebo bisket me bret elalubao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","“Te dage tuali tabi baso da, teda te me badu munalubo kibu mi me bret, dagego te siaba ulama, te siago tigidali dela silimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","“Dage te Godigo sel Ugwa Be sunumide bidaludubadi te nogo a naga olama, me badu nogo si wagi solama sogo bidao. Te dage pris sęba muani sogo 7 sogo elalueibao. Tama tibaso, dagego me tagaligio, te sogoba usu nama silimainao. ");
INSERT INTO mps_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Genuai Bidigo digi dabolo walama, te dagego sęgę sela sąyu, te tigidali sę emainogo yai. Te megi da dago te sę yali dao. ");
INSERT INTO mps_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dage te sel Ugwa Be sunumide te giligade me hulide bidalubadi, te a naga olama, me si sogo usu nao, tama dagego te Genuai Bidigo dagebolo yao wali sę tigidali yao. Genuai Bidigo enabolo tama tiwai po wai. Tiyu, dagego agai po sela sąbaso, te dage isabuo wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Te Mosesgo pedauwalide naga Genuai Bidigo Aron dali aga ogwa dabeba me te sę yabo po walama, tama augwaligo te tiwai sę yai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Te dei 7, te tama side augwaligo Aron dali aga ogwa dabe te pris sęba muna silibo sę ela silali. Te 8 wabo side Mosesgo te Aron dali aga ogwa dabe dali i obadi, te Israel tobolu bidi dabe me sisinagasao olama, i walio. ");
INSERT INTO mps_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Augwali agaba sisinagasobo si da, Mosesgo Aronbolo te tiwai po wai, “Te ogwa bidi bulmakau omai me deli sobadi, te omai sipsip kibu me deli sao, augwali si te keni kenigo tigi me dolisąwai dabe tama sao. Tama nago te kibu si Genuai Bidiba ofa yao. Te kibu kaugo te sęgę sela sąbo ofa ebadi, te sipsip kibugo te isiba tigidali ulama dela silibo ofa yao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","“Tama nago te Israel we bidi dabeba waliyu, te sęgę sela sąyabo meme kibu omai deli sesao po wao. Te kibu be deli yai omai kau kibu me deli sobadi, te kibu be deli yai sipsip kibu me deli sobadi elama, te isigo tigidali dabo ofa yaibao. Augwaligo te wiegi yai kibu naga sao, te keni kenigo augwa tigi me dolisąwai naga sabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Tama te we bidi augwaligo te omai bulmakau me deli sobadi, te omai sipsip kibu me deli sobadi elama, te deli haliga yabo ofa yaibao. Augwaligo te kibu si Genuai Bidiba ofa emainao, te wit ulubo ofa augwaligo te oliv wel dali taluali. Te megi tama side Genuai Bidi augwali geduba pedalubaso da, teda hasia bolo te ofa augwaligo yao wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Tialima, Aron dali te we bidi augwali pelama, te Mosesgo augwalibolo sigi pao po wali nai dabe selama, tama augwaligo te Godigo sel Ugwa Be pąba selasa asali. Te tigidali we bidi te Genuai Bidiba lotu wainogo te sel Ugwa Be pąba sisinagasalio. ");
INSERT INTO mps_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Tama Mosesgo augwaliba te tiwai po wali, “Genuai Bidigo te po wali, dagego te ofa ebaso da, te Godigo moni bomai ula te dageba pedalumainu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Tama nosali Mosesgo Aronbolo te po walali, “Nage te altaba pelama, te sęgę sela sąbo ofa me yao. Nago te naga sęgę dali, te we bidi dabego sęgę sela sąbo ofa dali, si tama yao. Nosali, te tigidali we bidigo sesali ofa selama, te augwa sęgę sela sąbo ofa yao, te Genuai Bidigo po wali gilama te sę yao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Tialima, Aron te altaba pelama, te ogwa bidi kau kibu omai elali, te aga digi aga sęgę sela sąmainu yalio. ");
INSERT INTO mps_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Te aga ogwa dabego te kibu kaneme selama, agabolo mani, tama agai nogo dani te kanemeba holama, te dwasianu kaneme te gąų me si me si te alta dage me si me si badu teba muai. Tama agai te me badu munaluali kaneme selama, te alta aiya dogwa saliba gealuali. ");
INSERT INTO mps_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Tama nosali Arongo te kau kibu ili tigidali sobadi, te haliga bealubo delegabe, me te si wabo homugo si siyu, tama te altaba ulai dao, te Genuai Bidigo Mosesbolo po wali gilama yai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Tama agai te kibu mi tigidali me kibu tigi wali te we bidi bidibo madi bulu badu nogani isiba ulama, te isigo tigidali dela silai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Arongo te silibo si da, teda agai te isiba tigidali ulama dabo ofa yabo kibu elali. Tama aga ogwa dabego te kibu kaneme selama, agabolo mani, tama agai te kaneme te alta bogo me si me si badu sąsągą pai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Te augwaligo te kibu tobolu dali, te kibu me badu delage pedai me tigidali agabolo menama, tama te tigidali te isigo tigidali dela silibo altaba ulalio. ");
INSERT INTO mps_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Agai te kibu tabi haliga bono dabe ąį telawali, te kibu sągą si me. Tama agai te me badu pedai tigidali te isiba tigidali ulubo ofa daiba munama, te isigo mu dela silai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Nosali Arongo te we bidi augwaligo ofa dabe selama, te Genuai Bidiba ofa ilali. Te we bidi dabe augwa sęgę sela sąwainu sesali kibu meme agai salio. Agai ela munama, tego ofa yali, te agai aga sęgę sela sąyu, te ofa yali kibude yali sę tiwai te ofade tama tialio. ");
INSERT INTO mps_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","17","Te we bidi augwaligo te isiba tigidali ulabo ofa yainu sesali kibu si dabede te me deli agai sali, te ofago bomai pode wali po tiwai gilama, te augwaligo tigidali sogo kigamude ofa eyu yai. Tama agai te plaua selama, te wit ulubo ofa yali. Agai te dwasianu plaua nogogo selama, te plaua te isigo dela silibo ofa ebo altaba ulali. ");
INSERT INTO mps_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Nosali Arongo te we bidi dabego Genuai Bidi dali deli haliga pedalubo ofa yainu sesali kau kibu me sipsip elali. Te kibu sigo kaneme aga ogwa dabego selama, te agabolo mani, tama agai te kaneme te alta bogo me si me si badu sąsągą bilai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Tama Arongo te nisai sipsip kibu danu sobadi, te kibu sigo te ili sali. Agai te haliga bealubo delegabe me te si wabo homugo si siyu, te polalubo deli wabo dini homu wiegi yai deli sai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Tialima, augwaligo te nai dabe te kibu si bauba munama, te tigidali altaba sela pali. Tama Arongo te kibu ili tigidali te altaba ulai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Tama agai te kibu kau me sipsip bau, me kibu dolo sągą me agai nogode tolaluyu, te Genuai Bidigo gedude iba eda hoga yali, te Mosesgo po wali gilama yai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Arongo te ofa dabe ela silama da, teda agai nogo si te we bidi dabeba ugwa selama, te po weyu, te Godigo augwali wiegi yai ilao wali. Nosali agai te alta tagalama, aiyaba dulalio. ");
INSERT INTO mps_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Te Moses de Aron si te Godigo sel Ugwa Be tomoba pai. Te augwali si buluba teda soabo sogo augwa si te po weyu, te augwa homugo te Godigo wiegi yai sę te tigidali we bidiba yao po wali, tama Godigo genuai ula hania haninama pedelama, te we bidi augwaligo suai dao. ");
INSERT INTO mps_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Te polo tama mu Genuai Bidigo isi te altaba tagala palama, tama isigo te siago tigidali mu dela silibo ofa dali te kibu ili tigidali me polo dela silai. Te we bidi dabego te sę ebo sulama, te augwa bomonama i weyu, te augwa gesabidi tǫba pǫgulama, te Genuai Bidiba lotu po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Te sogo Nadap dali Abihu, te Arongo ogwa si, te augwa si plet digi selama, te wiegi yai denami ebo pauda ulali. Tama augwa si te sia dage me pauda te wiegi yai denami hano ebo te plet pou dabeba munama, tama augwali sigo te isi te Genuai Bidiba te ofa eyu sela pali. Tiali goli, Genuai Bidigo augwali sibolo te tiwai isi sesao po me wabeo. Tama te sia te Godigo nai da wasiąyu, te Godigo homu godolo me ebeo. ");
INSERT INTO mps_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Te polo mu tama Genuai Bidigo te isi tagala palama, augwali si ulama, te augwali si Genuai Bidi gedude isai dao. ");
INSERT INTO mps_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Tama Mosesgo Aronbolo te po wai, “Polobadu Genuai Bidigo te tiwai po wali, ‘Te eno sę eyu pąba asobo bidi dabe, ena te olo bidi tiwai meni augwaligo te tiwai koneabo elalubao, ena God mu dao. Augwaligo te tama homu bugagia konebaso da, teda eno genuai bomo me ula te we bidi augwaliba ola mawaibao.’ Agai te tama po wai, tiali goli te bidi sigo te po wali me pisąbaso, tama Genuai Bidigo augwali si dolali,” Mosesgo te po wai. Tama Arongo te tiali po odama, agai po me wabeo. ");
INSERT INTO mps_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Te Mosesgo Misael me Elsafan i obaso augwali si asali. Augwali si te Usielgo ogwa si, te Arongo aya sabi bidi dao. Mosesgo augwali siba te tiwai po wali, “Dage sigo te duga si amago tigi sagasao, te Godigo sel Ugwa Be tagalama, augwali si te Godigo pesagede buluba sela peyu, pubaligi pao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Tialima, te bidi si pelama, te isali bidi si selama, te bidibo pesage tagalama, buluba soali, te Mosesgo wali po tiwai gilama yali. Tiali goli, augwali sigo te isali bidigo gudali ugwa me peda sąbeo. Menio. Augwali si ugwa dali te tigi tolasa palio. ");
INSERT INTO mps_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Megi da Mosesgo po Aronba mayu, te aga gasa ogwa sibolo te po wali, Eleasar dali Itamar si. Agai augwaliba te tiwai po wali, “Dagego te isali bidi side homu dene ebo kolesaga wali me pigio. Te dagego tobolu nisi yaga tigidali side sao. Te dagego olo elalumainogo me elamuo. Te dagego homu dene ebo dąį iliyu, te duga ugwa me pisągio. Dagego te homu dene ebo kolesaga wali pobaso da, teda Genuai Bidigo dage tigidali ela silama, te Genuai Bidigo te da Israel we bidi tigidaliba wado po dwai mu waibao. Te gasa Israel dabe, te duga deli hani, te Genuai Bidigo isi tagala palama, te elali bidi side augwali gasa Israel dabego naga homu dene emainao. ");
INSERT INTO mps_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Dagego te Godigo sel Ugwa Be me tagaligio. Dage te buluba sobaso da, te dage isaibao, magi baso meni, eno te Genuai Bidigo wel dageba muani, tama dage te Genuai Bidigo bidi dolo mu bidibao,” wali. Tialima, augwaligo te Mosesgo po odama, augwaligo te tama tiwai yai dao. ");
INSERT INTO mps_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Genuai Bidigo Aronba te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Te nage me nago ogwa dabego te bomai ąį wain me bia tulama, dage eno sel Ugwa Be tomoba me pelamuo. Te habu mu dao. Te dagego sel Ugwa Be tomode sę yabo sogo ąį tulama, te Ugwa Be tomoba pobaso da, te dage isaibao. Te dagego bulai wąį nǫų dabe nosali pedalubo hani, augwaligo me te bomai po wali pomainao. ");
INSERT INTO mps_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Te dagego bomai ąį tusąbaso da, teda dagego bugagia dagaliyu, te mena nai eno nai ma te olo we bidigo nai mena elalubo bugagia dagalaibao. Te dagego eno gedude mena nai te meda menisąyu, te mena nai meda elalubo te bugagia mu dagalaibao. ");
INSERT INTO mps_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Tama dagego te Israel we bidi te bomai po tigidali eno dagebolo te Mosesgo pedauwalide mabo te ola mobaso usu yaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Tama Mosesgo Aron dali aga bidibo ogwa si daliba te po wali, Eleasar me Itamar. Agai te tama po wali, “Dagego te me badu pedai plaua te wit ulubo ofago te Genuai Bidiba ofa yali me badu munalubo sao. Tama te plauago, dagego te yis meni yai bret nigao. Tama dagego te alta pąde te bret tuiyąo, magi baso meni, te nai te olo nai menio, te God aga ofago digi dagebolo mabo dao. ");
INSERT INTO mps_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Dagego te bret te Godigo sel Ugwa Be obo tomode bididu tuiyąo. Te witgo ebo ofa pedai tigidali te duga dali te duga hani ogwa dabego dali me dao. Dagego te we bidigo Genuai Bidiba ofa yali plauago siyąo. Genuai Bidigo enabolo te sęde po walai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“Te dage dali, te duga we bidi hanigo dali, te kibu bau me kibu dolo sągą te deli haliga pedaliyu ofa yali nai siyąo. Te kibu bau augwa te Genuai Bidigo gedude nogo tolaluyu, ugwa eda ebo dao. Te pesage me deli God gedude wiegi yai me elalubaso da, teda dage te me badu pelama, te kibu dage tuiyąo. Godigo te ofa yali kibu mi te dage me duga ogwa dabe dali tumainogo mawai dao. ");
INSERT INTO mps_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Te we bidigo te ofa yabo ili me te kibu kau me sipsip sągą me bau te sela asobaso, te dagego nogo tulaluyu, te Genuai Bidi gedude iba eda yao. Tama nosali dagego te ili alta isiba ulao. Tiali goli, dagego te kibu sągą me kibu bau selama, tuiyąo. Sesemane sogo te kibu pedai dage si dage dali, duga wai dabe daligo nai siyąo. Genuai Bidigo te tama po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nosali Mosesgo augwaliba po bomonama weyu, te tiwai po wali, “Dagego te sęgę sela sąbo ofa ebo memede mena sę yaliwe?” Tialima, augwaligo te po agabolo wali, “Dago te isiba sese ulama, dela silalio.” Tialima, Mosesgo te po odama, tama agai te Eleasar me Itamar augwali siba wado po wai. Tama agai te po wai, ");
INSERT INTO mps_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Magi baso dage te Godigo sel Ugwa Be tomode bidama, te sęgę sela sąwani kibu tubewe? Te God aga ofa me deli da olama, sa muyu, te agai dageba menama, te dagego te we bidi dabego yali sęgę sela sąmainogo ebo ofa dao. ");
INSERT INTO mps_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Dagego te ofa yali kibu kaneme te Tedali Gasagi Yai Be Habuba me sela pisąwai, tama tialima, magi baso dagego te kibu dage te eno dagebolo wali po gilama te Tedali Gasagi Yai Be Habude tuai meniwe?” ");
INSERT INTO mps_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Tialima, Arongo Mosesbolo te tiwai po wai, “Odao. Megi tama naga te we bidi dabego te augwa sęgę sela sąyabo ofa te Genuai Bidiba mayu, te augwaligo te isiba tigidali ulama dabo ofa yabo sesalio. Tiali goli, te dwai sę enaba pedelai dao. Tialima, te megi tama eno te sęgę sela sąbo ofa ebo kibu mi tubaso da, teda Genuai Bidigo homugo te ebaso godolo yaiba, agawe? Eno homugo te menio,” wali. ");
INSERT INTO mps_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mosesgo te wabo odama, tama agai te Arongo po wiegi yai da homu yali. Tama aga haliga dua nagame igulama bidalio. ");
INSERT INTO mps_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Te Genuai Bidigo Moses de Aron sibolo walama, ");
INSERT INTO mps_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","te Israel dabeba te tiwai po omainogo yali, “Dagego e tobage tǫde bidibo hasa sibi naga tuagameo,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","“Te nogo sągą age si elalubo hasa sibi dabe naga, te augwaligo kibu bulmakaugo nosai tutudubo tiwai ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Tiali goli dagego te kamel kibu, me rabit, me te masigi gabalode bidibo bolo gesia, te me tulamuo. Te hasa dabego te kaugo nosai tubo tiwai ebo dao, tiali goli augwaligo nogo sągą te age si elalubeo. Tama tiyu, dagego homugo augwali te eno gedude wiegi yai meni da homu elama, te dagego habu sao. ");
INSERT INTO mps_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Tama te kibu mu me dagego tugio. Te nogo sągą dani age si elalubo, tiali goli agai te kibu kaugo nosai tubo tiwai gilama ebo meni. Tama tiyu, dagego homugo kibu mu te dwai nai da homu eyu habu selao. ");
INSERT INTO mps_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Dagego te tobage hasa sibi me tugio, te augwali isali sogo te dagego augwali tigiba nogo me mugio, magi baso meni, augwali eno gedude wiegi yai me ebeo,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Dagego te tobage sųgų tigidali te tigide pobolo yai me bogo elalubo, te tiwai sųgų tuagameo, te olo ąį dabede ma tamu ąįde bidibo sųgų dabe, te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Tialima, tigidali sųgų me te dwasianu nai tigidali te tamu ąįde bidibo, me olo ąį dabede bidibo, te tigi pobolo me bogo meni yai, dagego homugo augwali dwali homu yao. ");
INSERT INTO mps_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Tama eyu, dagego me tugimio, te augwali isai elalubadi te dagego nogogo me diągio. Te habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ma odao. Dagego te bogo meni yai sųgų me te tigide pobolo isąwai sųgų te węde bidibo me tugio. Te nai dabe dagego habu selao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“Te tobage ba meba dageba habu selibao, te dagego me tugio. Dagego te nai tigidali dwali homu yao. Te e tobage ba dabe, te tobage genuai me dwasianu ba kemodage, te tobage tigidali ba kemodage hani hulide bilibo ba me, te ba gaugau, me te kebi dabe, te kanai dabe, me te sągą dili bobage yai ba me, te tobage ba hopou, me te komoran wabo ba pato, me te dwasianu bogwą, me genuai bogwą, te dagego habu sao. Te nai tigidali dagego tubo habu selao. ");
INSERT INTO mps_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Te sągą si me nogo si me bogo elalubo nai tigidali, te augwali wiegi yai nai meni, te habu sabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Te sągągo sasa mano pabo, te tobage nai yaibaso da, teda dagego tuabo usu yaibao. ");
INSERT INTO mps_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Tama dagego te tobage kuli mano tigidali tubaso usu yaibao, te genuai me dwasianu dabe te tuagameo. Te tama dao. ");
INSERT INTO mps_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Te gasa nai tigidali te nogo si sągą si te bogo me elalubaso da, teda augwali dagego te dwai nai da te homu elama, habu sao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Te me badu gasa tobage hasago me te dage eno gedude meda pedalubo sę yaibao. Te bidi me deli te isai hasago tigi diąwai baso da, ");
INSERT INTO mps_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ma agai gasaba me tolasa pai baso da, teda te bidi eno gedude meda pedelama, te bididubadi be pioba mu usu naibao. Tama te hasa tolali bidigo ugwa me ąį telayao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Te sągąde age elalubo tobage hasa dabego, te sągą dani age si elalusiąyu, ma te bulmakaugo nosai tubo tiwai isąbo hasa dabe, te hasa hani dabe dagego te wiegi yai nai meni da, te homu yao. ");
INSERT INTO mps_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Te tobage tigidali hasa te sągąde dani elalubaso, te wiegi yai hasa menio. Dage te tobage hasa isai tigi me diąwai baso da, teda dage eno gedude meda pedelama, tama dage tiwai bididubadi te giliga dega sigulaibao,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","“Bidigo te tobage hasa tigi gasaba me tolasa peyu da, agai ugwa ąį telayao, tiali goli aga meda elaludubadi te giliga dega sigulaibao. Te tobage hasa dabego dage meda ilibo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“Te tobage hasa hani me habu selali, te bolo gesia dabe me tǫde bolo me, te dwasianu yogwa dabe me genuai yogai dabe, te habu saibao. ");
INSERT INTO mps_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Eno te hasa dabe dageba habu selibao, te augwali isai madi dagego augwali tigi diąbaso da, te dage meda pedelama, te elaludubadi giliga dega siguluboba usu naibao. ");
INSERT INTO mps_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tama te hasa dabe me deli isilama, te nai me deli daiba tulaluei baso da, te nai eno gedude meda pedalubao. Te naigo tigi te augwaligo nigo nigai nai, me name ugwaba, me kau kibu waliba, me beg daiba tulaluei baso, te aga mena sę elalubaso da, te tagalao, te augwali meda pedelaibao. Tama tiyu, te dagego ąį telayao, tialima te nai dabego meda elalubadi te giliga dega sigulubo sogoba usu naibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Tama te hasago tigi te tǫgo nigai sospen tomoba tulaluei baso da, teda te sospende elaluali nai tigidali te meda pedelaibao. Tama dagego te sospen sene alua sąyao. ");
INSERT INTO mps_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Te nai meba pąde munalubadi te sospen ąį teba gelai baso da, teda te nai me meda pedelaibao. Te sospende elaluali ąį te doyu, meda yali dao. ");
INSERT INTO mps_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Te hasa sibi te mena naiba me tulalubaso te tagalao, te nai te meda ilaibao. Te augwa tǫgo nigai stov ma aven me deli yaibaso, te me dagego aluao. ");
INSERT INTO mps_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Tialima, te hasa me te ulu pedalubo ąįba me te olo tǫde pedalubo ąįba ma te tank ąįba tulaluei baso da, teda te ąį meda pedalugobeo. Menio. Tiali goli, te mena gasa nai te hasa tigide keąlubaso da, te meda elama, dwali dao. ");
INSERT INTO mps_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Te hasa sibi me deli te isama, te dagego bulainogo ebo nai waiba tulaluei baso da, te usu dao, magi baso meni, te nai wai meda ilibeo, aga te wiegi yai elalubao. ");
INSERT INTO mps_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Tiali goli, te nai wai te ąįde munalubadi, te hasago tigi daiba tulaluei baso da, teda te nai wai dabe te eno gedude meda pedalubaso, te habu selabo usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Te eno dagebolo te tuao wali hasa dabe tuabo homu ebaso, te usu yaibao. Te hasa sibi hani me deli te odolali me isai madi, te bidi me we me deli teba nogo diąwani da, te bidi ma we eno gedude meda pedelaibao. Te tiwai agade elalubadi, te sia ge dega siguluboba usu naibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","“Tama bidi me deligo te hasa mi tubaso, ma agai te hasa tolai baso da, teda agai ugwa ąį telayao. Tialima, aga digi te meda elalubadi te sia ge dega sigi paboba mu usu naibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Dagego te dwasianu hasa dabe me, ma te tǫba tedela pabo binatang me tulamuo. Augwali te dwai nai da, dagego te homu yao. ");
INSERT INTO mps_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Te haligago bulu bilibo tobage hasa dabe, ma te nogo sągągo bilibo hasa, ma te sągą hauwa elalubo hasa me, te dagego me tugio. Augwali te wiegi yai nai dabe meni, te habu sao. ");
INSERT INTO mps_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Dagego te hasa sibide deli me tugio. Te dagego tubaso da, te eno gedude dage meda mu pedelaibao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","“Ena Genuai Bidi, ena duga God dao. Tama tiyu, te duga digi dage enabolo mayu, te dolo isąbo kolesaga tagaluyu, te doloba pai kolesaga wali peyu, te meda meni yai wiegi yai tedali mu bidao. Magi baso meni, ena digi ena te magi meda meni yai wiegi yai tedali bidiyu, eno te wiegi yai kolesaga me doloba pai sę mu ebo dao. Tama te tǫde bilalubo dwasianu hasa dabe me tugimio. Tiyu, dage eno gedude meda pedelabuo. ");
INSERT INTO mps_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ena Genuai Bidigo, eno dage te Isipde selama, odasa asali, te ena dagego God bidainogo yali. Tialima, dage te tedali gasagi yai mu bidu, te wiegi yai doloba pai kolesaga naga wali piyąo, magi baso meni, ena digi ena te tedali gasagi yai mu bidiyu, te eno kolesaga wiegi yai doloba pai mu elalubo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Te dagego megi sali te bomai pode elalubo po, agai te tobage hasa sibi me te ba dabe, te węde bidibo sųgų dabe, te dwasianu hasa sibi tigidali, te tǫde bilalubo binatang, te nai sibide bomai po wali dao. ");
INSERT INTO mps_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Tama dagego bugagia dagaliyu, te mena meda meni yai nai, me te mena naigo dage eno gedude meda pedelabo te bugagia dagaliąo. Te dagego tuabo hasa sibi dabe bugagia konebadi, dagego tusiąma habu sabo hasa sibi me konebadi tama yao,” Genuai Bidigo te Moses dali Aron dali sibolo te po wai. ");
INSERT INTO mps_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Nago te Israel we bidibolo walao, te we me deli haliga elama, te aga wai ogwa ame nobaso da, teda aga eno gedude meda elalubao, te we poluago elibo gasi ebo sogo te tiwai elalubao, te aga meda elalubadi te nogo a naga olama me badu nogo si wabo sogo bidaibao. ");
INSERT INTO mps_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Tama te 8 wabo side, augwaligo te waigo gasa tigi wali togwao. ");
INSERT INTO mps_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Te we te 33 sogo bidama, te aga wiegi yai meda meni yai ma pedelaibao, magi baso meni, te aga wai ame nani sogo te aga tigide elaluali kaneme tagalalio. Agai te Godiba mani nai da olama, habu selali nai me deli nogo diąsiąbadi te eno dąį ilali sogoba usu nao. Tama aga te eno sel Ugwa Be obo tomoba pisąbadi, te aga meda meni yai wiegi yai pedalubo sogoba usu nao,” po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Te wego wegi ame nabo sogo, aga eno gedude wiegi yai ebeo, te we sibigo poluago elibo gasi ebo sogo tiwai ebao, te aga Sarere si, te 14 dei usu nama meda elalueibao. Tama te we aga bidibadi, te 66 dei ma bidama da, te aga meda meni yai dwagi yai ma pedelaibao, magi baso meni, agai kaneme tagalai dao.” ");
INSERT INTO mps_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Te tama sogo te we dabe sibi meda meniyu, wiegi yai ma pedalubo si da, teda te wego te kibu be deli yai sipsip kibu sao, te siaba tigidali ulabo ofa yaibao, te augwaligo te ba hi wabo, te ba me deli, te sęgę sela sąyu ofa yabo ba sao. Agai te ofa yabo nai si te eno sel Ugwa Be sunumiba selasa pobaso, usu dao. ");
INSERT INTO mps_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Tama prisgo te wego te sesali ba hi me kibu sipsip selama, te Genuai Bidi, enaba ofa ebaso da, te we te meda meniama, te wiegi yai pedelaibao. Tama te kanemego te we meda me elalumainogo me egobeo. Megi da aga eno gedude wiegi yai yalio. Te wai ogwa ma wegi ame nabo wego te bomai po wali pao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Tialima, te wego mone sǫą pelama, te aga sipsip kibu wai abelabo mone usu meni baso da, teda agai te ba hi sesao. Te ba hi me deligo te isiba tigidali ulubo ofa eyu, te me gasa bago te sęgę sela sąbo ofa yaibao. Te prisgo te ba hi si ofa eyu, te we wiegi yai pedelaibao, tama te we eno gedude wiegi yai pedelaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Te Genuai Bidigo Moses de Aron sibolo te tama po wai, ");
INSERT INTO mps_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Te bidi me deli ma we te tigide keni ma dili keni pedalubaso, ma tigide magi sę me deli pedalubaso, tama te sęgo tonobo te oiyabe gasi tiwai pedelabo homu tiwai ebaso da, teda augwaligo te bidi ma we te Aronba me aga hani prisba odasa pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","“Tama te prisgo te sę bugagia osolama, te agai suali madi te tigi nisi tedela elama, te keni tigi tomoba paibaso da, teda te oiyabe gasi dolo tama ebao. Te prisgo te bidi suali sogo da, agai te tama po wao, ‘Te bidigo tigi wiegi yai me elalubeo,’ po wabo dao. ");
INSERT INTO mps_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Tialima, te dąį tedela yai pedelama, te prisgo suali keni te tigi tomoba pisąma, te tigi nisi tedela pedalisąbaso da, teda prisgo te bidi agaduba te be me deliba munama elalubadi, te Sarere deli, a naga me si sogo, usu nama bidimainao. ");
INSERT INTO mps_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Te 7 wabo side, prisgo te dąį yai elaluali ma osola suao, tama agai homugo te tiwai naga tama me elalubaso, te genuai pedalisąbaso da, teda te bidi agaduba te be me deliba munama bididubadi, te 7 sogoba usu nao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","“Te Sarere si silibaso da, teda prisgo te bidi ma sulama, te nai genuai pedalisąma silainogo ebaso da, teda te bidi olo keni da homu yao. Tialima, prisgo agabolo walama, ‘Nage God gedude wiegi yai da,’ po wao. Te bidi aga ugwa wę tedelama, te aga wiegi yai mu pedalumainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“Te tudi badu nosali, te keni ma pedalubaso da, teda te bidigo pris ma sugi pao. ");
INSERT INTO mps_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Tama prisgo te bidi bugagia sumainao, tama te keni genuai pedalubaso da, teda te bidigo oiyabe gasi elalueibao. Te prisgo agabolo te tiwai po waibao, ‘Nage wiegi yai me ebeo.’” ");
INSERT INTO mps_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Te bidi me deli bomai keni elalubaso, te augwaligo aga te prisba odasa pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","“Te bidi te prisgo bugagia osa yao. Te keni tedela eyu, te tigi nisi tedela pedelama, tama te kenide keni bole pągąną pobaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","teda te bidi te oiyabe gasi dolo elalubao. Tama prisgo te bidiba te tiwai po wao, ‘Nage wiegi yai me ebeo.’ Prisgo koneani, te bidi wiegi yai ebeo, tama tiyu, te bidi agaduba deli bidimainogo me elamu dao. ");
INSERT INTO mps_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Tama te gasi genuai mu pedelama, te bidigo tigi tigidali usu nubaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","teda prisgo te bidigo tigi bugagia osa yao. Te prisgo suali digi te gasigo te bidigo tigi tigidali usu nama, te tigi tigidali tedela ebaso da, agai te bidibolo te tama po wao, ‘Nage Godigo gedude wiegi yai yalio.’ Te bidi wiegi yai mu yai dao. ");
INSERT INTO mps_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Tiali goli, nosali te keni ulu podilama, te tomode elalubo mi hanilibaso da, teda te bidi wiegi yai mu me ebe dao. ");
INSERT INTO mps_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Prisgo te keni ma sulama, agai suali keni te tiwai ulu podilaibaso, agai te bidibolo walao, ‘Nage wiegi yai ebeo.’ Te keni elalubo bidi te keni ulu podilama, te keni tomode mi elalubo bidi da, aga eno gedude wiegi yai me egobeo. Te tobage keni te dwai mu dao. ");
INSERT INTO mps_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Tialima nosali, te keni pedela selama, tigi tedela pedalubaso da, teda te bidi te prisba ma pomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","“Te prisgo te bidi bugagia ma sulama, agai suali te keni pedela selama, te tigi tedela yaibaso da, teda te bidi eno gedude wiegi yai yalio. Te prisgo agabolo te tiwai po walao, ‘Nage wiegi yai mu yai dao,’ po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Te bidi me deli tigide dili keni elama, te keni pedela selama, ");
INSERT INTO mps_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","tama nosali dili keni yali madi du elama, tedela pedalubaso, ma tigi mama yai me tedela dali elalubaso da, teda te bidi prisba pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","“Tama prisgo te bidi dili keni yali pesage bugagia suao. Te keni dwasianu tomoba pelama, te badu tigi nisi te tedela pedelai baso da, teda prisgo te bidibolo te tiwai po walao, ‘Nage God gedude wiegi yai ebeo.’ Te gasi te dili keni pedela sali pesagede pedelali da, te dwai nai mu dao. ");
INSERT INTO mps_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Tiali goli, prisgo te tigi sulama, agai te tigi nisi tedela isąwai sulama, te keni tigi wali tomoba pisąwai, agai te usu ma yabo tiwai tonobo homu ebaso da, teda prisgo agaduba munama bidibadi, te Sarere deli bidama, te nogo a naga olama, te me badu nogo si wagi solama sogo usu nama bidao. ");
INSERT INTO mps_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Te nosali te 7 wabo sogo te nai genuai pedalubaso da, teda te dwai nai mu da, te prisgo bidibolo te tama po walao, ‘Nage te God gedude wiegi yai ebeo,’ po wao. ");
INSERT INTO mps_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Tiali goli, te tigide dąį ilali te tiwai me tama elaludu, te genuai pedalisąbaso da, teda te dili kenigo dila pali tigi wali te masalu pedela salio, te tama dao. Tama te prisgo te bidibolo te tiwai po wao, ‘Nage te God gedude wiegi yai yali dao,’” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Te isigo bidi me deli tigi dai madi, te keni mama yai ma tedela yai te pedalubaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","teda prisgo te keni bugagia osola suao. Te keni tedela yali madi te kenide tigi nisi pedelama, te siago ulali madi keni tomoba paibaso da, teda te keni dwai nai mu dao. Tibaso, prisgo te bidibolo te tama po wao, ‘Nage God gedude wiegi yai ebeo,’ po wao. ");
INSERT INTO mps_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Te keni elalubo madi tigi nisi te tedela yai pedalisąma, te keni tomoba pisąma, te suali madi pedela sabo homu tiwai ebaso da, teda prisgo te bidi agaduba munama bidibadi, te 7 wabo sogo usu nama bidimainao. ");
INSERT INTO mps_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Te 7 wabo side te prisgo aga ma osola suao. Te keni genuai pedelai baso, te keni dwai mu dao. Te prisgo agabolo te tiwai po walao, ‘Nage dwagi yai me ebeo,’ te po wao. ");
INSERT INTO mps_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Tiali goli, te keni me tama elalubaso, te genuai pedalisąbaso da, teda te tigide isigo ulali madi masalu naga elalubao. Tialima, prisgo te bidibolo te po walao, ‘Nage God gedude wiegi yai dao,’” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Te bidi me deli ma we buluba keni keni te tobolude pedalubaso, ma penanede keni ebaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","teda prisgo te buluba keni bugagia suao. Te prisgo homugo te keni keni tigi tomoba pali homu elama, te agai suali te buluba keni yali pesagede te tigi nisi hauwa elalu, te tigi nisi sęwa yaibaso da, teda prisgo koneama, te buluba keni keni dwai nai mu da homu yaibao. Agai te po te bidibolo walao, ‘Nage God gedude wiegi yai ebeo,’ wao. ");
INSERT INTO mps_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Tiali goli, prisgo aga subo sogo, te agai suali te buluba keni kenigo tigi wali tomoba sela pabeo, te buluba keni elaluali madi tigi nisi wiegi yai me pedalisąwai, tialima agai te bidi agaduba munama, te Sarere deli bidimainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","“Te 7 wali side me tama elalubaso da, prisgo te bidigo tigi ma osola suao. Te buluba keni me tama elaluyu, te genuai pedalisąma, te prisgo homugo te tigi tomoba pogobe homu eyu, tama te badu sęwa yai tigi nisi pedalisąbaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","teda te bidi aga tobolu nisi me penani nisi tigidali poayao, tiali goli te keni elalubo madi poagio. Te nosali prisgo te bidi agaduba tedali bididubadi, te nogo a naga olama, me badu nogo si wagi solama sogo ma bidimainao. ");
INSERT INTO mps_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Tama te 7 wabo sogode prisgo te bidigo keni keni ma suao. Te keni keni te tama tiwai me elalu, te genuai me isąyu, tama prisgo homugo te keni tigi tomoba pabe homu eyu da, te agai te bidibolo te tiwai po wao, ‘Nage God gedude wiegi yai yalio.’ Tialima, te bidigo ugwa ąį telabaso, te wiegi yai ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","‘Nage wiegi yai yalio,’ te prisgo te po wali sogo tudi badu nosali te habo keni genuai pedelai baso da, ");
INSERT INTO mps_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","teda te prisgo aga ma osola suao. Te habo keni genuai pedelai baso da, teda prisgo te tiwai koneao, te bidi wiegi yai ebeo homu yao, tama agai te sęwa yali nisi munu me gegegio,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","“Tialima, te prisgo aga suali madi, te habo keni te tiwai me elaluabo homu eyu, te genuai pedalugobe homu elama, tama te keni yali madi wiegi yai tigi nisi pedalubaso da, teda te habo keni silalio. Tialima, prisgo agabolo te tama po walao, ‘Nage God gedude wiegi yai yalio.’” ");
INSERT INTO mps_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Te bidi ma we me deligo tigide tedela yai nai meba pedelai elalubaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","teda prisgo te tigide dąį elalubo bugagia suao. Te dąį elalubo te olo tedela elaluyu, te ula mu meni baso da, teda te dąį olo tama te tigide pedelali homu yao. Tama tialima, te bidi eno gedude wiegi yai yali dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Te bidigo tobolu nisi meniama wane paibaso da, teda aga eno gedude meda elalubeo. Menio. Aga wiegi yai bidi dao. ");
INSERT INTO mps_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Te tobolu nisi tomo bulude naga, te wane pai bidi yai baso da, teda te bidi aga eno gedude meda meni yai wiegi yai bidi dao. ");
INSERT INTO mps_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Tiali goli, te wane pai bidi tobolude te keni pedelama, te kenigo au te mama yai me tedela elalubaso da, teda te keni dwai mu dao. ");
INSERT INTO mps_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Te prisgo bugagia osola suao. Te kenigo au te mama yai ma tedela yai elalu, te oiyabe yai bidigo keni tiwai elalubaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","teda te tobolu wanede keni te dwai nai mu dao, te prisgo agabolo te tiwai po wao, ‘Nage Godigo gedude wiegi yai ebeo.’” ");
INSERT INTO mps_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Bidi me delide te tobage keni elalubaso, agai te pisila pai ugwa munama, te tobolu nisi yaga sigio. Tama aga nogogo pedauwali pania selama, te tiwai i wao, ‘Ena dwagi yai menio. Ena dwagi yai menio,’ te tama po wao. ");
INSERT INTO mps_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sesemane sogo te tobage keni elalubo bidi, aga eno gedude wiegi yai me ebeo. Agai te aga abagi dabe tagalama, te bidibo pesage bulu badu tedali bidao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","Genuai Bidigo po ma weyu, te Moses de Aron sibolo te tama po walio, “Me sogo te nai mebago te ugwa dolobo sę eyu, te gudubo ugwa dabede, me name ugwade, me augwa te sipsip nisigo nigali, ma te wiegi yai hobigo nigali, te bulmakau tigi walide pedaliyu, te tobage naigo nigali naide pedaliyu yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","“Tama te nai te ni yano tigi poai, ma mama yai pedalubaso da, teda augwaligo te ugwa dabe prisba waselama, ola magasao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","“Te prisgo selama, bugagia sulama, te nai gasa, badu munama, te nogo a naga olama me badu nogo si sogo elalumainao. ");
INSERT INTO mps_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Te 7 wabo side te agai ma suao, tama te ugwade genuai pedelaibaso da, teda te oiyabe gasi tiwai ebao, tama te ugwa ma kau wali te eno gedude wiegi yai egobe dao. ");
INSERT INTO mps_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Tama prisgo te ugwa isiba ulao. Te oiyabe pedalubo tiwai yali nai, te isiba ulama, mu siago dela silimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Tiali goli, prisgo te nai suali te tiwai tama me elaluyu, te ugwade genuai pedalisąbaso da, ");
INSERT INTO mps_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","teda agai augwalibolo olama, te ugwa wę tela yao olama, te munalubadi te 7 wabo sogoba usu nao. ");
INSERT INTO mps_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Nosali agai ma suao, te oiyabe tiwai yali te au me tama elaludubaso, te ugwa menade te nai pedelali madi elalu, te nai elaluali pesagede me genuai pedalisąbaso da, tagalao, te eno gedude wiegi yai me egobeo. Tialima, prisgo te ugwa isiba ulao. ");
INSERT INTO mps_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Tialima, augwaligo ąį telawai madi te prisgo ma suali madi, te oiyabe tiwai yali nai silainu ebaso da, teda agai te ugwa pedai te nai pedelali madi togwa sąyu, te tigi wali me peda sąyao, te dolali naga sela sąyao. ");
INSERT INTO mps_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Tialima, nosali te ugwa me kau tigi wali dolali nai ma pedalubaso da, teda te ugwa aga ayago ma kau wali me te isiba ulao, te mu dela silimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","“Tialima, agai te ugwa me kau wali ąį telabo sogo, te oiyabe tiwai nai menia sobaso da, teda agai si sogo ąį tedelama, te ugwa eno gedude wiegi yai mu pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Te tobage naigo te gasa tobage nai dolo bomai po elaluali, te ugwa ma te name ugwa augwa te wiegi yai hobigo nigali, ma te sipsip nisigo nigali, te tigidali nai augwa te kau waligo nigali nai. Te bomai pode te nai dabe te eno gedude wiegi yai yali, ma wiegi yai isąwani te bomai po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Te Genuai Bidigo Mosesbolo te tiwai po wai, ");
INSERT INTO mps_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Te mena bidide oiyabe gasi elalubaso, te sę yabo bomai po e dao. Te aga gasi silama, te aga eno gedude wiegi yai pedelainogo ebaso da, teda augwaligo te prisba tede po wagi pao. ");
INSERT INTO mps_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Tialima, pris te we bidi bidibo pesage tagalama, buluba solama, te oiyabe gasi sai bidi tedali bidibo madiba peyu, tama te aga tigi bugagia osola suao. Te oiyabe gasi mu silai baso da, ");
INSERT INTO mps_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","teda prisgo augwalibolo olama, te eno gedude wiegi yai ba si bidibadi sesao,” wali, “te ni sida dwasianu dage sobadi, te mama yai dila pai hobi me sesao, te ni hisop nologo me selasa asao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","“Te prisgo augwaliba walama, te tǫgo nigai sospen selama, te dwasianu wę asobo madi te ąį tulama sesao. Tialima, nosali augwaligo te ba si wali bago me deli selama, te tǫgo nigai sospen ugwadu tolaluama, te ela munama, te kaneme sospen seneba dulaibao. ");
INSERT INTO mps_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Te prisgo gasa ba me ni sida dage, te mama yai hobi string me, ni hisop me, te selama, te kaneme yai ąįba munama, te ugwaba polo ma sao. ");
INSERT INTO mps_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Tama elama, agai te kaneme dwasianu te nogo a naga olama, te me badu nogo si wagi soabode te eno gedude dwagi yai pedelabo bidi tigiba sąsągą bilao. Tama prisgo agabolo te tiwai po walao, ‘Megi da nage God gedude wiegi yai pedelalio.’ Tama prisgo te bidibo ba selama, te buluba solama, te aga bola pomainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Te bidi aga wiegi yai pedelainogo eyu da, te aga ugwa ąį tedelama, te tobolu nisi togolama, te aga tigi me te aga ąį pauwao. Agai tama tibaso da, teda aga eno gedude wiegi yai pedelaibao. Tama aga te bidibo pesageba pagameo, tiali goli aga ugwa bede bulu, badu bidibadi a naga me si sogo usu nama te usu dao. ");
INSERT INTO mps_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Te nogo a naga si wabo side te aga tobolu nisi me penani nisi tigidali ma togwao, te gedu nisi me, te aga tigide gasa tigi nisi elalubo tigidali mu poayao. Te aga ugwa me ąį telayu, te aga me ąį pauwao, teda aga eno gedude wiegi yai magi meda meni yai pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Te 8 wabo side agai te sipsip omai wai si selama, te sipsip kibu so me deli kibu be deli yai sobadi yao. Augwali te dwai keni kenigo me dolisąwai wiegi yai mu sao. Tama agai te plaua sęgę kilogram sela yali wiegi yai sao, agai te oliv wel dali taluali, te wit ofa ulubo ofa tiwai eyu, te oliv kap wel si me sao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","“Tama agai te kibu sipsip dabe te plaua nai me eno sel Ugwa Beba sela pao, te pris me deligo aga wiegi yai pedalumainogo tau saibao. Tialima, prisgo te bidi te aga ofa yabo nai dabe dali te ena Genuai Bidi eno sel Ugwa Be sunumiba selasa pao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Megi da prisgo te sipsip sigo te me deli selama, agai te oliv wel dali te dwai są yali isilibo ofa tiwai yao. Hasia bolo agai te nai dabe nogogo tulama, te eno gedude hogayu, iba eda yao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","“Tama nosali prisgo te sipsip wai te pesagede elao, augwaligo te sęgę sela sąyu, te bulmakau dabe elama, ofa ebo pesage, te isigo tigidali dela silimainu ofa ebo digi dao. Prisgo tama tiao, magi baso meni, te dwai sę silimainu ebo ofa tiwai te sęgę sela sąbo ofa tiwai ebao. Te ena dolo mu ebo sę ena God, eno te sipsip mi te pris dabebolo mawai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Nosali prisgo te sipsipgo kaneme dwasianu selama, te meda sela sąnama, wiegi yai pedelainu ebo bidigo dolo nogo olo badu muao, te dolo nogo a danide me mubadi, te bidigo dolo sągą a danide me muao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Tama prisgo te oliv wel dwasianu selama, te aga pobase nogoba gelama, te wel nogo diąyao. ");
INSERT INTO mps_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Tama agai dolo nogo dani me deli te welba munama, te wel a naga si sogo sąsągą bilibaso da, te ena Genuai Bidi, eno aga sueibao. ");
INSERT INTO mps_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Nosali prisgo te aga nogode elaluali dwasianu wel selama, te wiegi yai pedalumainu ebo bidigo dolo nogo badu oloba muao, te genuai a nogo danide elalubo kanemeba me muyu, te bidigo a sągą danide elalubo me mubadi yao. ");
INSERT INTO mps_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Te wel me badu prisgo nogode elalubo agai te bidi toboluba muao. Te tebo kolesagade agai te bidi eno gedude wiegi yai pedalubo sę ilibo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Te silama da, teda prisgo te sęgę sela sąbo ofa ebaso da, te bidi eno gedude wiegi yai mu pedelaibao. Te nosali agai te isigo tigidali mu dela silibo ofa yao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","“Tama agai te ofa ebo kibu dali te wit ulubo ofa dali te altade yao. Te kolesagade prisgo te bidi sęgę sela sąbo ofa ebao, tama te bidi eno gedude meda meniama, wiegi yai mu pedelai dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Te bidi magi nai mu meniama, te aga wiegi yai pedelabo ofa yabo nai dabe abelabo mone meni baso da, teda agai te omai sipsip wai deli naga sesao. Te kibu sipsipgo te aga dwai sę yali silimainu yaibao. Te nosali prisgo nogogo tolaluyu, te iba eda eno gedude tama tiao. Tama te bidigo te kilogram deli yai wiegi yai plaua somainao, tama te oliv wel dali taluama te wit ulubo ofa yao. Te agai oliv wel kap si sesemainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Tama agai augwaligo te nogi hi wabo tobage ba si sesao, te ofa yabo, magi baso meni, agai te sipsip hauwa abelabo usu ebeo. Te ba hi me deligo te dwai sęgę sela sąyu, te me deligo te isiba ulama tigidali dela silibo ofa yaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Te augwaligo aga te wiegi yai pedalumainu sę ebo side, te 8 wabo side, agai te kibu doado bage te prisba sela peyu, te Genuai Bidi eno sel Ugwa Be sunumiba selasa asobaso da, teda eno sueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","“Tialima, prisgo te sipsip me oliv wel saibao, te nogogo tulama, te eno gedude iba eda yao. ");
INSERT INTO mps_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Tama prisgo te sipsip wai elama, te dwai sę yali silimainogo ofa yaibao. Agai te ofa ebo nai kaneme dwasianu selama, te wiegi yai pedelainu ebo bidigo dolo nogo olo badu pilao, te agai dolo nogo a danide me pilibadi, te bidigo dolo sągą a danide me pilao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Te prisgo oliv wel dwasianu selama, te aga pobase nogode gealuama, te wel nogo tuwao. ");
INSERT INTO mps_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Te agai dolo nogo dani te welba munama, te wel nogo a naga si sogo sąsągą pobaso da, te ena Genuai Bidi, eno sueibao. ");
INSERT INTO mps_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nosali prisgo te dwasianu wel ąį te hasia agai te dwasianu kaneme muani pesagede muao. Agai te bidigo dolo olo badu mumainao, te dolo a nogo danide me muyu, te agai dolo sągą a danide me muao. ");
INSERT INTO mps_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Te nogode elalubo wel tigidali te prisgo te wiegi yai pedelainu ebo bidigo tobolude pilao, te kolesagade prisgo te bidigo sęgę sela sąbo ofa ebao. ");
INSERT INTO mps_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Tama prisgo te ba hi si te bidigo sela asali te salio, te ofa yabo dao. ");
INSERT INTO mps_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Agai te ba higo te sęgę sela sąbo ofa tiwai eyu, te gasa bago te isiba tigidali ulama dabo ofa yaibao. Agai te wit ulubo ofa dali te ba hi si dali ofa yao. Te kolesagade prisgo te bidigo sęgę sela sąbo sę eyu, eno gedude wiegi yai pedalubo sę tama yaibao. ");
INSERT INTO mps_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Te bomai po te oiyabe gasi yali bidigo gasi sia somainu ebo bomai po, tiali goli te aga mone sǫą pobaso, te agai te bomai pode sesao wali nai tigidali sela pabo usu isąbaso, te aga eno gedude wiegi yai emainogo te tiwai ofa ebo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Te Genuai Bidigo Moses de Aron dali sibolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Nosali dage te tǫ kantri Kenanba bidigi paibao, te eno dageba mawainogo homu ebo bulu, te dagego tǫ mu sesemane elalueibao. Tama dage te Kenan tǫba sabolama bidibo sogo, te eno nai me deli te oiyabe pedalubo tiwai elama, te dagego masigigo nigai be mebade pedelama, te be dolobo sę ilaibao. ");
INSERT INTO mps_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Te be aga ayago suali, te tama sę elalubaso, aga te prisba pelama, agabolo te tiwai po walao, ‘Eno suali, te oiyabe tiwai nai me deli eno beba pedelama, te eno be dolainu homu ebao.’ ");
INSERT INTO mps_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Prisgo te tiwai po odobaso da, teda agai te be page bidibolo walama, te be tomode doado bage tigidali selama, te buluba sela soao. Te bidigo tama tisąwani da, te pris aselama, agabolo te tiwai po walaibao, ‘Te bede tigidali doado bage te God gedude dwalio olama, te nagebolo habu selaibao.’ Tialima, bidigo te bede doado bage tigidali buluba sela soai digi yai baso da, teda pris te be tomoba pelama, te be sumainogo yao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“Agai te be paiyali daga masigi dabe dolobo nai te bugagia osola suao. Te agai suali madi te ni yabe tiwai nai ma mama yai naigo te amamogo tubo tiwai te be daga paiyali masigi dabede dwasianu dodogo paibaso, tama agai homugo te naigo te be daga dodogo pelama, tomoba mu paibaso da, ");
INSERT INTO mps_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","teda pris te buluba dią solama, te po walao, ‘Te bede bidisąma, habu selama, te nogo a naga olama, me badu nogo si sogo olo elalumainao.’ ");
INSERT INTO mps_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Te 7 wabo side pris aselama, te be ma suagasao. Te nai te be paiyali daga masigi dabede genuai mu pedelaibaso da, ");
INSERT INTO mps_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","teda prisgo augwalibolo walama, te dwai nai elalubo masigi dabe sela sąnama, te taun bulu, badu sąyao te eno gedude dwai nai sela sąbo pesageba sela sąyao. ");
INSERT INTO mps_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Augwaligo tama tilama da, teda augwaligo te masigi mesegelali simen tigidali te be tomode elalubo sela sąyao. Tama augwaligo te taun buluba sela solama, te dwai meda yai nai sąbo pesageba naga sąyao. ");
INSERT INTO mps_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Tama augwaligo te gesi masigi dabe selama, te poloba elaluali masigi hasegelama, te be daga masigi te pedai badu ma nigao. Te augwaligo gesi simen selama, te be daga nigali tigidali ma haluao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Te oiyabe tiwai nai te be obo dagade ma pedaliyu, te sę yali tudi, badu te nai ma pedalubaso da, ");
INSERT INTO mps_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","teda pris te beba ma pelama, bugagia suao. Te nai genuai pedelama, te be dolabo homu ebaso da, teda te be eno gedude dwali dao. ");
INSERT INTO mps_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Tibaso, te be augwaligo hųgilama, te tigidali masigi me, ni me, simen me, sela sąyao. Tama augwa te taun bulu badu sela soao, te augwa eno gedude meda yai doado bage sela sąbo pesageba pelama, mugi pao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Te be habu selali elalubadi, te be tomoba bidi me deli pobaso da, te bidi eno gedude meda pedelama, aga te tiwai bididubadi te giliga iba dega sigulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","“Te bidi me deli te tomode godege piali ma nai tubaso da, teda aga ugwa ąį telayao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Tialima, prisgo te be suagasobo sogo da, teda agai suali, te be wiegi yai elaluyu, te nai ma pedalisąbaso, te agai te tiwai po augwaliba walao, ‘Te be Godigo gedude wiegi yai elalubao.’ Magi baso meni, te oiyabe tiwai naigo te be dolali, te munu ma elalubeo. ");
INSERT INTO mps_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Te be eno gedude wiegi yai pedalubo kolesaga e tiwai elalubao. Prisgo te ba hi si sobadi, te ni sida dwasianu dagenu siyu, te mama hobi string dagenu sobadi, te ni hisop nologo sobadi yao. ");
INSERT INTO mps_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Tama augwaligo te tǫgo nigai sospen selama, te dwasianu asobo ąįba pelama, te ąį tulama sesao. Te prisgo ba hi me deli selama, te sospen ugwadu tolaluyu elama, te kaneme sospenba dulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","“Nosali agai te ni sida dagenu me siyu, te ni hisop nologo me siyu, te mama hobi string me sobadi, te bidibo ba hi selama, te kaneme elalubo ąįba munama, te polo ma kega sao. Tama agai te kaneme elalubo ąį te a naga si sogo te beba sągąyao. ");
INSERT INTO mps_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Prisgo tama tilama, te be eno gedude wiegi yai pedelaibao. ");
INSERT INTO mps_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Tama agai te bidibo ba bidibadi te taun buluba te kala elalubo pesage buluba bola pomainogo tagala palama, bola pomainu yao. Te kolesaga te bego dwai meda elalubo sia selama, te be eno gedude wiegi yai ma pedalubo tiwai ebo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","“Te bomai pode te tama po wali, te oiyabe gasi yai we bidi, me te habo keni keni yai we bidi, me te keni ebo me dili keni ebo, me te masalu tigide pedalubo po me walio, te ugwa doado bage, me be dolobo te bomai pode te po wali. ");
INSERT INTO mps_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Te bomai pogo te dagebolo ola mayu, te mena nai te meda yai nai, ma te mena nai te wiegi yai eno gedude pedalubo, te bomai pogo page ola mabo po dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Te Genuai Bidigo Moses de Aron sibolo te tiwai po walali, ");
INSERT INTO mps_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Nago te Israel bidi dabebolo walao, te bidi me deligo gasade keni dį pedalubaso, te keni dįgo aga eno gedude meda ilibao. ");
INSERT INTO mps_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Te keni dį ebogo te ąį bole tiwai gasade pedalubaso, ma te naigo bomogo te poi tabo sunumi pania sobaso da, teda te bidi eno gedude meda elalubao. ");
INSERT INTO mps_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","E tiwai elalubao. Te dugulalubo bet sai me pibo bet sai me tigidali te meda pedelaibao. Te aga dugabo sia sai tigidali me te meda ela silaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","Mena bidigo te bidigo pibo betba nogo mubaso, ma te bidi dugabo sia saiba dugabaso da, teda aga ugwa digi wę telayu, te aga me ąį paugi pao, tiali goli te agade meda elaludubadi te be pio mu igi paibao. ");
INSERT INTO mps_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Te mena bidi me wego te tobage gasi elalubo bidigo tigiba nogo mubaso, te aga ugwa digi ąį telayu, te aga wę me paugi pao, te meda agade elaludubadi te giliga iba dega sigulaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Te gasi elalubo bidi agai te eno gedude wiegi yai elalubo bidi me deliba pesą sąbaso da, teda te gasa bidi me te meda pedalubao, te agai ugwa me ąį telayu, ąį me paugi pao, te meda agade elalubadi te giliga iba dega sigulaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Te tobage gasi elalubo bidi te hosde dugabo nai satelba dugabaso da, teda te nai meda pedalubao. ");
INSERT INTO mps_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Te bidi me deligo te bidi dugayali nai satelba nogo muani da, aga me meda ilama, te tiwai me bididubadi te giliga iba dega sigulaibao. Te nai bidi me deligo sela pobaso me, nosali bidi teba dugabaso da, teda aga ugwa ąį tedelama, te ąį paugi pao, te meda agade elaludubadi te sia ge iba dega sigulaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Te gasi elalubo bidi, te agai nogo ąį bolo telasiąma, te agai nogo gasa bidiba mubaso da, teda te gasa bidi agai ugwa ąį tedelama, te ąį paugi pao, te aga meda elaludubadi te sia ge iba dega sigulaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Te gasi elalubo bidigo agai nogo te tǫgo nigai sospenba mubaso da, teda augwaligo te sospen aluao. Te agai augwaligo te nigo nigai pou disba nogo mubaso da, teda augwaligo te pou dis bugagia ąį telayao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Te bidigo gasi usu ma ebaso da, teda aga te a naga me si sogo bolo bidilama, te aga wiegi yai ma pedelaibao. Te Sarere silibaso da, teda aga ugwa ąį telayao, te pelama, ąį me deliba paugi pao, te aga eno gedude wiegi yai pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","“Te 8 wabo side agai te tobage ba hi si seselama, te ena Genuai Bidi geduba dolagasao, te eno sel Ugwa Be sunumiba aselama, te ba hi si prisba magasao. ");
INSERT INTO mps_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Tama prisgo te ba hi me deligo te sęgę sela sąbo ofa tiwai eyu, te gasa ba mego te isiba tigidali ulama dela silibo ofa yaibao. Te tebo kolesagade agai te gasi silai bidi tau selama, te bidi eno gedude wiegi yai pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Te bidi me deli piali madi aga gasade olo dali gawa gealueibaso da, teda aga meda pedelali, te aga tigi tigidali ąį pauwao, te aga meda elalubadi te giliga dega sigulaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Te bidigo tigide ąį te ugwade tulalueibaso, ma nami ugwade, ma te bulmakau waligo nigali nai dabede tulalueibaso da, teda te nai dabe meda yaibaso te ąį telawaibao, te nai dabe meda elalubadi te giliga dega sigulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Te bidigo we dali pagela pibaso da, te augwali side meda pedelaibao. Te augwali si gagali ela silama da, te augwa si ąį paugi pao, te augwali side meda elalubadi te giliga dega sigulaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Te we me deli poluago elibo gasi sabo side, te aga meda pedelama elalubadi, te Sarere deliba usu naibao. Bidi ma wego te weba nogo mubaso da, teda augwaliba te meda dagana selama elalubadi, te sia ge iba dega sigulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Te we pibo bet sai me tigidali te aga dugabo sai me tigidali, te tigidali meda ela silaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","22","“Mena bidi ma wego te betba nogo muani, ma aga duabo naiba me nogo mubaso da, te meda agade pedelaibao. Te aga ugwa digi ąį telagi pelama, ąį me paugi pao, te meda agade elalubadi sia ge iba dega sigulaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Te pibo ugwa sitbet, ma mena nai te we dulaluali te tagalao, te bidigo ma wego teba nogo mubaso da, te meda agade elalubadi, te be pio mu igi paibao. ");
INSERT INTO mps_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Te bidi me deligo te we poluago elai gasi elalubo sogo te we dali pagela pibaso da, teda bidigo te wego meda selama, te bidi meda elalubadi Sarere deli bidaibao. Te mena bet te bidi pibo madi me meda elalueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Te we aga tigide kaneme elalu, te meba sogoba usu niyu, te poluago elibo gasi agade isąbadi, ma te poluago elibo gasiba wadolama, te kaneme idubadi, te meba sogoba usu nubaso da, teda agade te meda elalubadi te silibo sogoba usu naibao. Te wego bulu be gasigo kolesagade te tama tebo dao. ");
INSERT INTO mps_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Te aga mena betde piali ma mena sia saide dulaluali me, te tagalao, te bet doado bage meda pedalubo dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","“Te bidi ma we me deligo te naiba nogo mubaso da, te meda agade pedelali. Te aga ugwa ąį tedelama, te ąį paugi pao. Te meda agade elalubadi te sia ge dega sigulaibao. ");
INSERT INTO mps_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Te wego tigide pedelali kaneme wa pabo si da, te aga Sarere deli bidilama, te aga eno gedude meda meniama, wiegi yai pedalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Te a naga me sela wabo side agai te tobage ba hi si selama, te eno sel Ugwa Be sunumiba sela pelama, te prisba mao. ");
INSERT INTO mps_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Tama prisgo te ba higo te sęgę sela sąbo ofa tiwai me eyu, te gasa me bago te isiba tigidali ulama, dela silibo ofa emainao. Te kolesagade agai te we eno gedude wiegi yai pedalumainu usu ilibo dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Dage sigo bomai po te Israel dabeba menama, te augwali eno gedude meda elalubo sogo dua dao, bugagia koneao. Eno sel Ugwa Be augwali tomode elalubao, te augwali meda elalubaso da, teda te be tomoba augwali me pelamuo. Tiyu, augwaligo te sel Ugwa Be meda ilidalio. Te sel Ugwa Be augwaligo meda ilibaso da, teda eno augwali ela mueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Te bomai pode te tama po wali, te bidigo gasade tedela yai kaneme pedalubo, me odolali gasade ąį gealubo, me te naigo aga meda ilibao. ");
INSERT INTO mps_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Tama te we tigide poluago elibo gasi ebo po me, te bidi ma we tigide te aga naide tedela kaneme pedalubaso, te bidigo aga we dali pibo po te me te meda elalubao po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Polobadu Arongo ogwa sigo te Genuai Bidiba ofa igi pali te agai augwali sibolo te ofa yabo po wasiąbadi, tibaso augwali si isalio. Te tilama, nosali Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Nago naga ama Aronbolo walao, sesemane sogo aga te Tedali Gasagi Yai Mu Be Habu te genuai dąį togwali tudi badu tomoba me pelamu dao. Tialima, ena digi dąį ilibo sogo, aga tomoba pagameo. Magi baso meni, ena te pǫ me deli tomode bidama, te ena hanilagasu, te sęgę sela sąbo Dąų Wali Bomai Po Elalubo Halobage daiba pedalubo dao. Te aga olo dali te be habu tomoba pobaso da, teda aga isaibao. ");
INSERT INTO mps_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aron te Tedali Gasagi Yai Mu Be Habu tomoba pabo sogo, agai e tama timainao. Hasia bolo agai te sęgę sela sąbo ofa yabo ogwa bidi bulmakau omai me deli sela pao, te agai omai kibu sipsip me deli te isiba tigidali ulama, dela silabo ofa yabo te me sela pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Tama agai prisgo te tobage gasa ugwa gudaibao. Agai te bobage aiyaba tagalalubo ugwa gudama, te pęwadage trausis ugwa me muani, te ugwa nami agai haligade kukulu tiwai kekelama, te nami ugwa me deli te toboludu madi tiwai munama, kekaluao. Te tedela ugwa dabe naga muao. Ena digi te prisgo gudabo ugwa dabe dąį ilali. Tama tibaso, Aron aga ąį bolo paluama, nosali te ugwa doado bage mubaso usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Te Israel we bidi augwaligo te sęgę sela sąyabo meme omai si sobadi, te omai sipsip deli isiba tigidali ulabo me selama, te Aronbolo mao. ");
INSERT INTO mps_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Tama Arongo te omai bulmakau aga digi sela asali te aga sęgę me aga we wai pulubago sęgę dali sela sąyabo ofa yainogo eyu, tama te eno geduba osogo muao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“Nosali agai te meme omai si selama, te si selasa pelama, te ena Genuai Bidi eno sel Ugwa Be sunumiba dolagasobaso, eno sueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","“Te agai masigi si sao, me masigi deli e tiwai po elalueibao, ‘Te Genuai Bidigo da,’ te gasa masigide e tiwai po elalueibao, ‘Te Asaselgo dao.’ Te masigi si agai geme dualama, te deli deli guda selama, te ena Genuai Bidigo meme me deli dąį iliyu, te me deli Asasel dąį ilao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“Tama Arongo enabolo te dąį ilali meme selama, te we bidi dabego sęgę sela sąbo ofa tiwai yao. ");
INSERT INTO mps_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Tialima, agai te Asaselba dąį ilali meme me eligio. Menio. Arongo eno geduba sesao. Tama te bidi meni yai buluba agai te Asaselbolo tagala palao, tama tiyu da, te memego te we bidi augwaligo sęgę sela pabo tiwai yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Arongo te sęgę sela sąbo ofa yabo homu ebo sogo, agai te kolesaga wali pao. Hasia bolo agai te omai bulmakau seselama, te ela munama, te aga sęgę me aga we wai pulubago sęgę sela sąbo ofa yao,” po wali. ");
INSERT INTO mps_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","13","“Nosali agai ain sospen me deli selama, te altaba pelama, te sia dage sospenba bulama, te Tedali Gasagi Yai Mu Be Habuba selasa pao. Te wiegi yai denami ebo pauda agai nogo sigo sabua selama, te sela pelama, te sospende elalubo siaba mugi pao, te eno sueibao. Te paudago hanogo te sęgę sela sąbo pesage te Dąų Wali Bomai Po Elalubo Halobage mesega saibao. Te tiwai ebaso da, Arongo te sęgę sela sąbo pesage sugobeo. Tiyu, agai subaso, te eno aga ela muidali weyu tama tiaibao. ");
INSERT INTO mps_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Tama agai te bulmakau kaneme me badu selama, te kaneme nogoba holama, te kaneme te sęgę sela sąbo pesage daiba ugwadu sąyao. Agai te kaneme nogo danide ma selama, te kaneme nogo a naga si sogo te Dąų Wali Bomai Po Halobage gesabidiba sąyao,” po wali. ");
INSERT INTO mps_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Nosali agai te we bidi dabego sęgę sela sąbo ofa yabo kibu meme ela muao. Tama agai te meme kaneme te Ugwa Be Tedali Gasagi Yai Mu Be Habu tomoba sela pelama, te dwasianu me badu te sęgę sela sąbo pesageba sąyao. Te agai dwasianu meba te Dąų Wali Bomai Po Elalubo Halobage gesabidiba sąyao. Agai te bulmakau kanemego yali sę tiwai yao,” wai. ");
INSERT INTO mps_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","“Te kolesagade agai te Tedali Gasagi Yai Mu Be Habu eno gedude wiegi yai pedelaibao. Magi baso meni, te Israel we bidigo hagoma eyu, eno po sela sąnama, te dwai sę hauwa eyu, te kolesagago te Tedali Gasagi Yai Mu Be Habu meda ilibo dao. Eno sel Ugwa Be te Israel dabe tomode elaluyu, te augwaligo dwai kolesagago te sel Ugwa Be eno gedude meda pedalubao. Tibaso, Arongo te kaneme dwasianu selama, te tobage sę te sel Ugwa Beba me yao, te agai te Tedali Gasagi Yai Mu Be Habude yali sę tiwai elama, te sel Ugwa Be wiegi yai ma pedelaibao. ");
INSERT INTO mps_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Arongo aga sęgę dali, aga we wai pulubago sęgę dali sela sąbo ofa eyu, te Israel we bidi tigidaligo sęgę sela sąbo ofa yao. Aga te Tedali Gasagi Yai Mu Be Habu mu tomoba pabo sogo, te bidi me deli eno sel Ugwa Be tomoba me pisąbadi, te Aron buluba ma dią soaboba usu naibao. Te habu mu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","19","“Nosali agai te Tedali Gasagi Yai Mu Be Habu tagalama, buluba dią solama, te isiba tigidali domainu ulubo ofa ebo altaba pao. Te Israel dabego dwai sęgo te alta eno gedude meda ilali. Tibaso, Arongo te alta wiegi yai pedalumainu ilao. Agai te bulmakau kaneme dwasianu siyu, te meme kaneme siyu elama, te alta bogo me si me si elalubo madi te kom me si me side pibili pao. Tama agai nogo dani te kanemeba munama, te kaneme a naga me si sogo te altaba sąyao. Te kolesagade agai te alta wiegi yai pedalumainu ilaibao, tama te alta eno sę delide naga elalumainu sula tagalao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Genuai Bidigo po e tiwai ma wali, “Te Arongo te Tedali Gasagi Yai Mu Be Habude yali sę tigidali badi, te sel Ugwa Be badu yali sę tigidali mu sia somainu elama, te alta wiegi yai pedalumainu yai baso da, teda agai te meme, te Asaselba sa muani meme, te enabolo selasa asao,” po wali. ");
INSERT INTO mps_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","“Te meme tede bidibadi te Arongo nogo si te meme toboluba munama, Arongo te Israel we bidi dabego yali dwai sę, me dwai kolesaga tigidali, me hagoma kolesaga hanilama pusao. Te kolesagade agai te sęgę tigidali te meme toboluba mueibao. Nosali te meme agai te sa muani bidi me deliba menama, tama te bidigo te tǫ wa pai buluba te meme kibu sela pelama, teba tagaligi paibao. ");
INSERT INTO mps_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Tama te memego te Israel dabe augwaligo sęgę tigidali tolama, te bidi meni yai habu me deliba tagaligi pabo dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Te sę silama da, teda Aron eno sel Ugwa Be tomoba pelama, tama aga te Tedali Gasagi Yai Mu Be Habu tomoba painogo gudali ugwa dabe peda mugi pao. Tama agai te ugwa te sel Ugwa Be tomode elalumainogo yao. ");
INSERT INTO mps_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Tama aga te sel Ugwa Be obo tomoba ąį paugi pao, tama aga te sel Ugwa Be tomoba ma pelama, te ugwa gudama, te hetprisgo gudubo ugwa au yao. Nosali aga te buluba teda solama, te isigo tigidali dela silibo ofa si yao, me ofa agade eyu, me te tigidali we bidide yao. Te ofago aga sęgę sela sąbo ofa eyu, te we bidi augwaligo sęgę sela sąbo ofa me yao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","“Te agai augwaligo sęgę sela sąbo ofa yali kibu ili te siaba ulao. ");
INSERT INTO mps_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Te meme kibu te tǫ wa pai buluba sela pelama, tagaligi pali bidi, agai ugwa ąį tedelama, te aga tigi bolo ąį pauwao, tama nosali aga te bidibo pesage tomoba ma asomainao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Tama augwaligo te sęgę sela sąyabo ofa yabo kibu bulmakau me meme sesao, te hasia bolo prisgo te kibu sigo kaneme te Tedali Gasagi Yai Mu Be Habu tomoba sela pelama, te aga sęgę sela sąyu, te we bidi dabego sęgę me sela sąmainu tama tiali. Augwaligo te kibu si te bidibo pesage bulu badu sela pelama, te isiba ulama, te sia keli naga elalumainogo yao. Te bidi me deligo te kibu wali me mi me haliga di te isiba ulama, te mu deli silimainogo yaibao. ");
INSERT INTO mps_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Nosali te bidigo ugwa ąį tedelama, te aga tigi me ąį paluama, te aga bidibo pesageba ma asomainao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Genuai Bidigo po e tiwai ma wali, “Dagego te bomai po sesemane sogo wali piduao. Te polua a naga olama, me badu nogo si wabo polua, te dei 10de, dage tigidali Israel dali te gasa hani dage dali bidibo we bidi, dage te nai tubo habu selama, te wiegi yai pemene ebo sę me habu selao, tama dagego sę tagalama, te dage toma tuao. ");
INSERT INTO mps_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Magi baso meni, te side naga te prisgo dagego sęgę sela sąbo ofa yaibao, tama dage eno gedude wiegi yai ma pedelaibao. ");
INSERT INTO mps_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Te side te eno genuai side dolo dao. Te dagego tigidali pemene ebo sę te side habu selama, te dage toma nao. Dagego sę munu me elamuo. Te habu mu dao. Te bomai po dagego sesemane sogo wali piduao. ");
INSERT INTO mps_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mena prisgo dage te duga ayago yali sę sabo dąį ilali bidi, agai naga te we bidi dabego sęgę sela sąbo sę emainu yao. Hasia bolo hetprisgo gudubo tedela ugwa te aga tigide muao. ");
INSERT INTO mps_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Te nosali agai te sęgę sela sąbo ofa ebaso da, teda te Tedali Gasagi Yai Mu Be Habu tigidali badu, me sel Ugwa Be me, alta me, te pris dabe me, te Israel we bidi tigidali, te eno gedude wiegi yai ma pedalumainogo yaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Augwaligo te bomai po sesemane sesemane sogo wali pidubadi geao. Hetprisgo te tobage ofa te tigidali kibu bede deli sogo yao, te Israel we bidigo sęgę sela sąyu tiao, te augwali eno gedude wiegi yai pedalumainu ebao,” wali. Genuai Bidigo te po Mosesbolo mobaso, te po tigidali Mosesgo wali pai dao. ");
INSERT INTO mps_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Te Genuai Bidigo Mosesbolo po walama, ");
INSERT INTO mps_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","te Aronbolo po weyu, agai te agai ogwa dabeba me te Israel we bidi tigidaliba walomainogo yali. Genuai Bidigo te tiwai po wai, “Eno te bomai po dabe dageba mobao. ");
INSERT INTO mps_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Te dage Israel bidigo te kibu tuabo homu ebaso, dagego te kau, me sipsip, me meme me deli selama, te bidibo pesage tomode me bulu badu ela mubaso da, ");
INSERT INTO mps_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","teda dagego eno sel Ugwa Be sunumiba selasa aselama, te enabolo ofa tiwai mao, te nosali duga selama, tuagameo. Te dagego kibu elama, te kaneme gelama, te dagego enaba ofa me isąbaso da, teda dagego te bidi ela muani tiwai ebaso, te dagego dwai sę eno gedude elalueibao. Tibaso, dage eno hani tomode bidibo sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Te po page e tiwai dao. Polobadu dage Israel dabego te kibu elama, te bidibo pesage bulu, badu ofa yali, tiali goli megi da, dagego te kibu elibaso, te prisba selasa pao, te eno sel Ugwa Be sunumiba pelama, te ena dali deli haliga pedalubo ofa yao. ");
INSERT INTO mps_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Te prisgo te kibugo kaneme selama, te sel Ugwa Be sunumi pąde elalubo te alta bogo baduba sąwaibao. Tama agai te ofa yabo kibu ili te ofa eyu, altaba ulubaso, te ena Genuai Bidi, eno denami odama, te eno homu godolo eyu, tede eno bugai haliga ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Dage Israelgo te bulu haubo bidi dabeba kibu elama, ofa ebo sę munu ma elamuo. Dagego te tiwai elama, te dagego ena tagaliyu, te tibo godiba homu kęą pali. Sesemane sogo dage hanigo te eno sel Ugwa Beba te kibu ofa tiwai siyu idu geao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","“Te nago te tiwai po augwaliba walao, te dage Israel bidi me deli, ma te dage dali bidibo gasa hani bidi me deligo, te isiba tigidali ulubo ofa me te agai gasa tobage ofa yabo homu ebaso da, teda agai te kibu eno sel Ugwa Beba sela aselama, ofa yao. Te meni baso da, te ena Genuai Bidi, eno hani we bidide aga sela sąyu, gudulaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Dagego te kibu elibo sogo, dagego aga dogoni togolama, te kaneme tigidali aiyaba pomainao. Te dage Israel bidi me deli, ma dage dali bidibo gasa hanigo te kibu mi kaneme elalubadi tubaso da, teda ena Genuai Bidi eno agaba boi bidi eyu, te aga eno hani we bidide sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kanemego tigidali bidiba bidibo ula mayu, te kibuba mobao. Tibaso, eno te po dagebolo obao. Prisgo te ofa ebo kaneme altaba gelibao, te dage we bidigo sęgę dabe sela sąyu, kanemego te bidibo ula page elalubao, te kaneme deligo naga dage we bidi dabego sęgę sela sąbo dao. ");
INSERT INTO mps_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Tama tibaso, eno dage Israel dabebolo obao, te dage me deligo, ma te dage dali bidibo gasa hani bidi me deligo te kibu mi kaneme elalubadi me tugio. Te habu mu dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Te dage Israel bidi me deligo, ma te gasa hani bidi me deligo aga te hasa gegegi pelama, agai te uni meme me deli, ma ba me deli, te eno dagebolo tugio wasiąwai nai enai baso da, teda agai te naigo kaneme gelama, te kaneme tǫgo haluao. ");
INSERT INTO mps_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Magi baso meni, te tigidali bidigo bidibo ula me te hasago bidibo ula te aga kanemede naga elalubao. Te pagede naga eno dage Israel we bidibolo waliyu, dagego te kibu mi kaneme elalubadi tugio po obao. Bidigo te kibu mi kaneme elalubadi tubaso da, teda aga te eno we bidi hanide sela sąwaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Tialima, te kibu me deli olo dali isali, me uni hasago te hasa ela muai, nosali dage hanide digi te bidi ma we me deligo te hasa mi tubaso da, teda aga eno gedude meda pedalubao. Tialima, aga ugwa ąį tedelama, te aga digi me ąį paugi pao, te meda agade elalubadi giliga dega sigulaibao. Giliga iba dega sigulai baso da, teda aga dwagi yai ma pedalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Te agai tigi me ugwa ąį telayu, pauyu isąbaso, te sę page agade digi elalubao, te aga yali kolesagade te sęgę aga tolobo dao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Genuai Bidigo Mosesbolo walama, ");
INSERT INTO mps_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","te agai po Israel dabebolo omainogo yali. Agai te tiwai po wali, “Ena Genuai Bidi, ena dagego God dao. ");
INSERT INTO mps_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Te mu tama, dage Isipde bidaluyu, tialima dagego te Isip dabego kolesaga wali pigio. Te megi eno dage Kenan tǫba odasa painogo ebao, tialima dagego te Kenan dabego kolesaga wali pelamuo. Dagego te augwaligo tama tiao wabo po dabe wali me pelamo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Odao, dagego eno bomai po deli naga wali pao, tama eno dagebolo yao po wabo sę deli naga tigidali yao. Ena Genuai Bidi, ena duga Godgo eno te po dagebolo mobao. ");
INSERT INTO mps_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Dagego te tigidali kolesaga me tigidali bomai po eno godolo yabo sę me eno dagebolo mobao. Te dagego tama sę eyu da, te dagego bidibo ula elalueibao. Ena Genuai Bidi, ena duga God, eno te po obao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Ena Genuai Bidi, eno te po obao. Nago te naga deli hanide we me deli sabo homu elama, nago aga gedu eyu, aga dali gagali me igio. Te tobage kolesaga habu mu selibao. ");
INSERT INTO mps_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nago naga ida mu dali gagali ebo sę igio. Nago te tiwai sę ebaso da, te nago naga aya hale ilibo sę mu ebao. Te naga ame nani ida mu dali gagali ebo sę habu mu selibao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Nago naga ayago gasa we dabe, te nago paba dabe, te dali gagali ebo sę me elamuo. Te nago tama tibaso da, teda nago naga ayabolo dwai hale mu ilibo sę ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Nago naga abe mu dali dobo sę ebo gagali eyu, ma gasa ayago wegi me ida dali te dobo sę ebo gagali me igio. Te idago ayago bede ame naibaso, ma gasa bede ame naibaso, tagalao, te naga abe dao, te nago aga dali dobo gagali ebo sę me elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Nago naga wegigo wegi, ma naga ogwago wegi dali te dobo sę ebo gagali me igio. Te kolesagade nage hale dwai mu ilaibao. ");
INSERT INTO mps_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nago naga pabago wegi dali te penani sę ebo gagali igio. Te naga ayago wai dao, tibaso te nago abe elalubao. Te aga nago we da olama sabo sę te habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Nago te naga ayago abe dali penani igio, magi baso meni, te ayago deli kaneme dao. ");
INSERT INTO mps_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Nago te naga idago ama dali dwai penani sę ebo kolesaga igio, magi baso meni, te naga idago deli kaneme elalubao. ");
INSERT INTO mps_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Nago te naga aya sabi bidigo we dali penani sę me elamuo, magi baso meni, te we te nago ida sabi we elalubao. Te naga aga dali pibaso da, teda nago te nago aya sabi bidi hale dwai mu ilibo sę ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Nago te naga ogwago we dali penani sę igio. Magi baso meni, te nago we menio, teyu te nago aga dali penani ebo sę habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Nago naga amago we dali penani igio. Te nago aga dali pibaso da, teda nago ama hale dwai mu ilibo sę ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Te nago we me deli sali, te wego gasa bidide wegi ame naibaso da, teda nago te wai ma sigio, ma agai wegi me sigio. Te nago wego ogwago wegi me, te nago me somainu elamo dao,” wali. “Magi baso meni, te we dabe te nago wego deli kaneme elalubao. Te nago augwaliba dwai sę ebaso da, teda nago te hale genuai ebo kolesaga ebao. ");
INSERT INTO mps_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nago naga wego ama nago sigio, te nago we bidibadi sigio. Tiyu, nago augwa si wado yabo sę ilabuo. Te kolesaga dolo ebeo,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Nago te we poluago elai gasi sai elalubadi te penani igio, magi baso meni, te sogo aga wiegi yai me elalubeo. ");
INSERT INTO mps_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nago naga abagigo we dali penani me igio. Nago tama tibaso da, teda nage eno gedude meda pedelaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Odao, ena duga Genuai Bidi eno dagebolo te duga wai dabe elama, te isiba ulama, te tibo god Molekba ofa ebo habu selama, te po eno dageba bomai po obao. Tiyu, dagego eno nogi aiyaba elaluidalio, te dagego God dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Te bidi duga hasigo te gasa bidi tągio. Te dwai kolesaga mu ebao, te eno homude godolo me egobeo. ");
INSERT INTO mps_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Bidi dagego te so hasa kibu sibi me te tągio, te we dagego te hasa sibigo dage tąmainogo sula tagaligio. Te kolesagade dage eno gedude meda pedelaibao. Te tebo kolesaga dwai nai mu dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Dagego te dwai kolesaga dabe me elamuo. Te sę dagego eyu da, teda dage eno gedude meda pedelaibao. Te ena Genuai Bidigo po odisąwai hani bidi dabe te Kenan tǫde bidaluyu, augwaligo te tobage dwai kolesaga dabe elama, te augwali meda mu pedelalio. Te megi eno augwali ela gudulubo sę ebao, te dagego augwaligo tǫ somainogo ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Te augwali dwai kolesagade te tǫ digi meda pedelali. Te augwaligo tǫba eno dwai dene mabo sę elama, tama te tǫgo te Genuai Bidigo po odisąwai hani bage te bugubo tiwai eyu, te augwali Kenan tǫde munu ma bidalugobeo. ");
INSERT INTO mps_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Tialima, dage da, dagego eno dagebolo te mani bomai po tigidali wali pao. Dage te Israel we bidi dali, te gasa hani dage dali bidalubo hanigo dali, te Genuai Bidigo po odisąbo bidi dabego ebo kolesaga tiwai igio, magi baso meni, te kolesaga dwai kugumini mu ebaso, te eno godolo homu menio. ");
INSERT INTO mps_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Dagego koneani, te Godigo po odisąwai hani dabe te tǫde polasa bidali, augwaligo te kugumini yai kolesaga yali. Tibaso, te tǫ eno gedude meda yai dao. ");
INSERT INTO mps_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Tiyu, dagego me tama tidalio. Te tama sę dagego eyu da, teda te tǫgo digi dage sela sąwaibao, te ena Genuai Bidigo po odisąwai hani dabe polasa bidali bage sela sąwani tiwai gilama dage me tiabuo. ");
INSERT INTO mps_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Te dage Israel mena bidi ma wego te tobage dwai sę ebaso da, teda eno aga te eno hani we bidi tomode bidali sela sąwaibao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Genuai Bidigo te tama po wai, “Te eno dagebolo mabo po te dagego wali pao. Dagego te tǫde polasa bidali hani bidi dabego yali dwai kugumini yai kolesaga wali me pelamuo. Te dagego tama tibaso da, tiyu dage eno gedude meda pedelabuo. Odao, ena Genuai Bidi, ena duga God, eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Genuai Bidigo Mosesbolo te po walama, ");
INSERT INTO mps_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","te Israel we bidibolo te tiwai po omainogo yali, “Dage wiegi yai mu tedali mu bidiyu, te eno godolo yabo wiegi yai doloba pai kolesaga wali pao. Magi baso meni, ena God, dagego Genuai Bidi, ena tedali wiegi yai mu elalu, eno kolesaga wiegi yai doloba pai mu elalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Dage deli deligo duga ida aya dologode bidu, te augwaligo po wali pao. Dagego te olo toma nabo sogo, te Sabat side, sę me igio, dage olo toma naga tuyu, bidao. Ena Genuai Bidi, ena duga God, eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Dagego te tibo godiba lotu weyu, ena me tagaligio. Te dagego olo dali te olo nai aingo te lotu wabo tibo god nigilama, teba lotu me wagio. Te habu mu dao. Ena Genuai Bidi, ena dagego God, eno te po wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Te dagego ena dali deli haliga pedelabo ofa ebo sogo, dagego eno dagebolo mani bomai po wali pelama, te ofa yao. Dagego te tama ebaso da, teda eno dagego ofa ebo godolo yaibao. ");
INSERT INTO mps_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Dagego te ofa yali kibu mi te kibu elali side ma te nosali side tuiyąo. Te kibu mi munalubadi te sela sogo wabo siba sabalobaso da, teda dagego te isiba ulama, te keli naga elalumainao. ");
INSERT INTO mps_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Te bidi me deligo te sela wabo side elaluali kibu mi tubaso da, teda te kolesaga eno gedude dwalio, tama eno te ebo ofa godolo homu me egobeo,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","“Mena bidigo te sela wali sogoba usu nani munaluali kibu mi tuali bidi da, te ena mani nai digi agai dwai ilibao, te aga yali sę dagede sęgę elalubao. Tama tialima, eno we bidi hanide aga sela sąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Te dagego duga gide nai inawai tau yai togobo sogo, dagego te gi sesege homu badu elalubo nai togolama sigio. Te gi tomode nai dagego sabo sogo, te nai meba ela soabaso da, teda dage ma geasa peyu te nai ma sigio. Tede tama elalumainogo sula tagalao. ");
INSERT INTO mps_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Te dagego te wain tau inayani sela silibo sogo, dage te wain giba si sogo ma pelama, te hasia susiąma tagalali nedu du wain ma sigi pigio. Te tǫba tudulaluai munalubo wain du dagego me sigio. Dagego te nai dabe tagalama elalu, te magi nai meni yai bidi dabego, ma te gasa hani dage dali bidibo, te hani augwali somainao. Ena Genuai Bidi, ena duga Godigo, eno te tiwai po obao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Dagego gasa bidigo nai dabe wi me sigio, te dagego gasa bidiba tibo po wagio, te agai nai anoma elama sainogo tigio. Te dagego gasa bidiba tibo po ola magio. ");
INSERT INTO mps_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Te dagego bidi me deliba bomai po dąų walu, ena nogide te po dąų walai baso da, teda dagego te bomai po olo dali dąų walama, aga tibo po ola magio. Dagego duga te dąų wali bomai po wali pisąbaso da, teda dagego eno nogi aiyaba elalubao. Ena Genuai Bidigo, eno te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Dagego gasa bidi me doloyu, te agai nai dabe wi me sigio. Te dagego bidi me deliba sę mawai baso da, teda dagego agai sę te ela silibo side te abelebo mone mao, te sogo piode. Dagego te mone tolalubadi be huliama te kigamude me magio,” wai. ");
INSERT INTO mps_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Dagego te olo degai we bidi augwaliba te po dwai me wagio, ‘Godigo dage dolabo sę elalubao.’ Dagego te gedu widai bage habela muabo bono gaga te sunumide me mugio. Dage ena Godide wi yao, duga Genuai Bidi dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Te dagego po tų odobo si da, teda dagego te po tųde doloba pai kolesaga naga yao. Te dagego po bugagia dodolao. Dagego te magi nai meni yai bidi dabe tau siyu, te augwaligo po tų ebode ugwaba ela holomainogo elamuo. Me ma, dage te nogi yai bidide wi eyu, te augwali tau selama, te po tųde ela holomainogo elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Duga abagi dabeba kisa sigi pelama biliyu, te gasa bidiba posobo po wagio. Te augwaligo bidi me deligo te genuai sęgę sai madi po tų ilibaso, te dagego aga po tųde tau sabo homu eyu da, teda dagego tau sao. Tiyu, dage pedauwali panialubaso, te po tųgo aga ela muao po wabuo. Eno homugo dagego tama tiwai yao, magi baso meni, ena duga Genuai Bidi dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Te nago abagi me deligo nageba dobo sę yai baso da, teda nago homude aga dali sesemane sogo wado po udugio. Nago aga dali po dodolobaso da, te po isaibao. Tiyu, nago me agai yali kolesagade homu kone paludu, te nago me dwai sęgę me deli sabuo. ");
INSERT INTO mps_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Te naga abagi me deligo nageba dwai sę ebo te nago wei me ponogio, te nago sesemane sogo aga dali wado po me udugio. Nago gasa we bidi dabe godolo mu yao, te naga digi naga godolo ebo tiwai yao. Ena Genuai Bidigo eno te po obao.” ");
INSERT INTO mps_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Dagego eno bomai po dabe wali piyąo. Dagego te kibu hasa sibi si augwa hasi omai sę elama, te wai ame nomainogo sula tagaligio. Tama dagego te tobage nai wai hani si te gi delide buligio. Tama dagego augwaligo te olo hobigo hobolai nami ugwa dali te sipsip nisigo nigai hobigo hobolai ugwa te me gudugio. Te kolesaga ebo habu dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Te bidi me deligo aga olo sę ebo we te agai gasa bidiba maiabo po dąų wali, tialima te gasa bidigo abelesąwai. Tama te we tonalubo bidigo te we dali dobo sę gagali yai baso da, teda dagego augwali si te po tų kotba odasa piyąo. Tiali goli, te dagego augwali si ela mugio, magi baso meni, te we te tonalubo bidigo olo sę ebo we dao. ");
INSERT INTO mps_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Tama te tonalubo bidigo te sipsip kibu omai me deli selama, te eno sel Ugwa Be sunumiba pao. Agai te sipsip ena Genuai Bidiba ofa elama, te dwai sę dodoliyu, te agade elalubo sęgę silimainao. ");
INSERT INTO mps_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Tama prisgo te bidigo sęgę sela sąbo ofa yao. Te eno sulama, eno te sęgę sela sąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Dage te Kenan tǫba pabo sogo dagego te tobage du walobo ni du dabe bulubaso da, teda dagego te kibu be selade te bulali ni du tusiąma te habu selao. ");
INSERT INTO mps_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Te kibu be me si me si wabode, dagego te ni du wai tigidali te ena Genuai Bidiba mao, te dagego enaba wiegi yai pemene eyu puba hwi wabo ola mabo tiwai ebao. ");
INSERT INTO mps_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Tialima, te a naga wabo kibu bede te ni du walobo nai duga tuao. Eno te po dagego wali pobaso da, teda dagego ni du wai hauwa umabo walaibao. Odao, ena God, dagego Genuai Bidi, eno te po obao.” ");
INSERT INTO mps_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Dagego te kaneme elalubo kibu mi tugio. Te dagego haniani pobi wabo sę me te kebele aubo sę me igio. ");
INSERT INTO mps_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Te dagego tobolu nisi te dagego olo pąde togogimio, te dagego penani nisi togolama pęwadage iligimio. ");
INSERT INTO mps_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Te dagego tigide todogo pelama masalu ebo sę iligio. Te bidi isaide, ma we isaide homu dene eyu, duga tigi togobo sę igio. Ena Genuai Bidigo eno dagebolo te kolesaga dabe ebo habu mu selibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Dagego te Godigo po odisąwai bidi dabego ebo kolesaga tiwai eyu, te duga wegi dabe te penanide sǫbo we dabe tiwai pedalumainu elamuo. Tiyu, dagego te tiwai sę eyu, te ena tagaluyu, te dage te tibo godide gone tuą peyu, haniani dwai sę yabuo. Te dagego bulu tigidalide te dwai kolesaga pągąna pidalio.” ");
INSERT INTO mps_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Dagego te olo toma neyu bidibo sogo, te Sabat side, sę munu me igio. Dagego te we bidi dabe aselama, te enaba lotu po wagasobo sel Ugwa Be godolo mu yao. Ena Genuai Bidi, eno dagebolo wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Te dagego wiegi yai homu kolesaga sabo homu ebaso da, teda pelama, te isali bidi dabego noma bidi dali po mibo bidi dabeba me hanalugi pigio, te noma bidide homu kolesaga selama, dageba momainogo igio. Te dagego tama sę ebaso da, te dage eno gedude meda pedelaibao. Ena Genuai Bidi, ena duga God, eno te po wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Dage te monu dabe dologoba pelama, augwaligo po wali peyu, te augwaliba wiegi yai sę yao. Te dage ena dologoba aselama bidao, te dagego God dao. Ena Genuai Bidi, eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Dagego te gasa hani bidi te dagego tǫde bidibo hani bidi augwaliba dwai sę elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Dagego wiegi yai kolesaga naga augwaliba yao, te duga deli hani te Israel dabeba ebo kolesaga tiwai yao. Te dagego augwali godolo homu mu eyu, te duga digi duga godolo ebo tiwai yao. Dage te Isipde polobadu bidali, tama te tiyu bidigo aga page bulu tagalama, te gasa bulu tǫ kantride bidibo kolesaga dagego koneao. Tama tiyu, dagego te gasa hani dage dali bidibo bage bugagia tonaluao. Ena Genuai Bidi, ena duga God, eno te po wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Te gasa bidigo abelabo nai dabe usu selama, dagalama, te nedebo sogo da, teda dagego aga tibo po ola magobeo. ");
INSERT INTO mps_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Menio. Dagego dolo usu selama, dolo dodolama, te nai dabe dolo naga nedao. Ena Genuai Bidi, ena dagego God, te eno dage Isipde selama, te dage odasa asai dao. ");
INSERT INTO mps_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Tama tibaso, eno dagebolo mani bomai po tigidali wali pao. Ena Genuai Bidigo, eno te po dagebolo wai dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Te Genuai Bidigo Mosesbolo te tiwai po walali, ");
INSERT INTO mps_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Nago Israel we bidi augwaliba te tiwai po wao, te dage Israel me deli, ma dage dali bidibo gasa hani me deli, agai aga wai te tibo god Molekbolo ofa tiwai mobaso da, teda dagego te bidi ela muao. Tigidali we bidigo agaba masigi sąnama, te aga isibo siba usu nao. ");
INSERT INTO mps_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Te bidigo wai te Molekba mabo kolesagade, te eno sel Ugwa Be meda ilama, te eno genuai nogi aiyaba mu elalubo sę ebao. Tibaso da, eno te bidiba boi bidi elama, te aga eno we bidi hani tomode bidibo sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Tiali goli, te we bidi augwaligo te bidigo kolesaga suali, te augwaligo homude olo nai me tiwai da homu elama, te augwaligo aga me ela musiąbaso da, ");
INSERT INTO mps_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","teda ena digi eno agaba boi bidi eyu, te aga deli hani bageba me te ena tudiba munama, te Molekba lotu wabo we bidi tigidaliba te tiwai yaibao. Te augwali eno we bidi hanide sela sąwaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Te bidi me deli te kebele aubo bidiba pelama, te isali bidi noma bidi dali po mibo sę igi pabo sę ebo bidi yai baso da, teda te bidigo ena tagalama, te Godigo po odisąwai hanigo kolesaga wali pobao. Tibaso, eno agaba boi bidi eyu, te aga eno hani we bidide sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Dage te tedali gasagi yai bidu tama sesemane sogo te eno godolo yabo wiegi yai doloba pai kolesagade bilao. Ena Genuai Bidi, ena duga God, eno te wai dao. ");
INSERT INTO mps_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Dagego eno bomai po tigidali wali pao, magi baso meni, ena Genuai Bidigo dage eno we bidi wiegi yai pedalumainu sa muai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Te bidi me deligo me, o te we me deligo me, te aga ida ayabolo te dwai da te tiwai po weyu, ‘Godigo nage dolomainao,’ obaso da, teda dagego te bidi ma te we ela muao. Bidi ma wego te tobage po wali da, te aga yali sę dagede aga isimainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Te bidi me deligo abagi me deligo we penani yai baso da, teda dagego te bidi me te we dali si ela muao. ");
INSERT INTO mps_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Te bidigo te aga ayago we me deli dali penani sę yai baso da, te bidigo aga aya dolobao. Tialima, augwaligo te bidi dali te we dali si ela muao. Augwali sigo dwai sę yali sęgę elalubao, tialima augwali si isimainao. ");
INSERT INTO mps_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Te bidi me deligo aga ogwago we dali penani ebaso da, teda dagego augwali si ela muao. Augwa si deli kanemego te penani yali, tialima augwali sigo dobo sę yali sęgę elalubaso, te augwali si isimainao. ");
INSERT INTO mps_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Te bidi mego gasa bidi me penani ebaso, augwali sigo dwai sę genuai mu yalio. Tialima, dagego augwali si ela muao. Augwa si yali sę dagede naga augwa si isibao. ");
INSERT INTO mps_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Te bidi me deligo te we me we aga ida dali sabo si da, te dagego augwali sela ela munama, augwa tigi isiba ulao, magi baso meni, augwaligo dwai sę genuai mu yali, tama dagego te tobage kolesaga dage tomode ebo we me bidi te sula tagaligio. ");
INSERT INTO mps_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Te bidi me deligo te kibu sibi me penani ebo bidi, dagego te bidi ela muyu, te kibu me ela muao. ");
INSERT INTO mps_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Te we me deli te hasa sibiba pelama, te hasa sibigo aga penani emainogo ebaso da, dagego te we dali, te hasa dali, ela muao. Augwa si yali sęgęde augwali si isimainao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Bidi me deligo aga abe mu ma sali, ma gasa aya ma idago wegi saibaso, te bidi me wego dwai kolesaga mu yalio. Tialima, tigidali we bidigo gedude dagego augwali siba wado po olama, te augwali si sela sąyu, te augwali si dage dali munu ma bidigio. Te bidi aga abe dali penani yali, tialima aga yali kolesagade sęgę tolomainao. ");
INSERT INTO mps_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Te bidi me deligo aga we te tigide bulu be gasi sai elalubadi te tąbaso da, teda augwali sigo eno gedude dwai meda yai kolesaga mu yali. Tama dagego augwali si eno we bidi hani tomode sela sąyao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Te bidi me deligo aga ida sabi we dali, ma aga ayago abe dali penani ebaso, te aga deli kanemede te sęgę sobao, te augwa si yali dwai kolesagade sęgę tolomainao. ");
INSERT INTO mps_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Te bidi mego aga aya sabi bidigo we dali penani yali da, te bidigo aga aya sabi bidi hale dwai mu ilibao. Tama te bidi me te we augwa si yali sęde sęgę tolao. Te bidigo sobaso da, teda agai te wai dabe ame nabo usu egobeo, me te aya sabi bidigo wego te wai dabe me ame nogobeo. ");
INSERT INTO mps_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Te bidi mego aga amago we anoma elama sali da, te agai dwai kolesaga mu Genuai Bidi eno gedude ebao, te aga ama hale ilibao. Tibaso, te bidigo me te wego wai me ame nogobeo,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Dagego eno bomai po tigidali me eno po tigidali wali pao. Megi eno dage odasa pabo, te Kenan tǫ te agai dage me bugulisąma, te dage bugagia bidaibao.” ");
INSERT INTO mps_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","“Te ena Genuai Bidigo po odisąma te Kenan tǫde bidibo bidi dabego kolesaga dagego wali me pigio. Augwaligo te dwai sę yai baso, te eno augwali godolo homu mu ebeo. Te megi da, eno augwali te tǫ kantride sela sąnama, te dagego te tǫ sagameo. ");
INSERT INTO mps_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Eno te po dagebolo wai dao, te tǫ da wiegi yai mu, te ili hauwa elalubao, te nai hauwa tede holaibao. Te eno dagebolo menama, te dagego tǫ mu pedelaibao. Ena Genuai Bidi, ena dagego God, te eno dage gasa hani tomode sali, te dage enaduba deligo we bidi naga bidimainogo yai dao. ");
INSERT INTO mps_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Tama tialima, dagego te mena kibu hasa ba sibi me bugagia dagaliyu, te wiegi yai tuabo me tusiąma habu sabo me dagalao. Hasa me ba te eno gedude wiegi yai isąwani, te dagego habu sao. Eno te tobage nai dabe te wiegi yai isąwai nai po dagebolo wali, te hasa me ba te dwasianu nai me, tialima te dagego tubaso da, teda dage eno gedude meda mu pedelaibao. ");
INSERT INTO mps_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Dagego te dwai kolesaga dabe tagalama, te wiegi yai tedali mu bidiyu, te eno wiegi yai doloba pai kolesaga naga wali pao, magi baso meni, ena digi ena tedali wiegi yai elaluyu, te eno kolesaga tigidali te wiegi yai doloba pai mu elalubao. Te ena Genuai Bidi, eno dage te gasa hani bage tomode sali, te dage ena bage naga elalubao. ");
INSERT INTO mps_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Mena bidigo ma wego te isali bidigo noma bidi dali po minama, te augwalide homu kolesaga sabo we bidi yai baso da, aga isimainao. Dagego agaba masigi sąnama, te aga ela muao. Aga yali sę dagede aga isimainao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Te Genuai Bidigo Mosesbolo weyu, te Arongo hani pris augwaliba te po mao wali. Agai te tiwai po wali, “Te dage deli kaneme hani me deli isibaso da, teda diligi peyu, dagego te isali bidide homu dene ebo kolesaga wali pigimio. Te kolesagade dage eno gedude meda ilibo sę pedalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Tialima, te duga deli kaneme mu isai, te ida, ma aya, ma ogwa, me wegi ma ama, ");
INSERT INTO mps_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","te abenu mu bidigo sisąwai te aya dali bede bidibadi, te tiwai deli kaneme dabe isibaso da, teda dagego te homu dene ebo kolesagade meda pedalidali homu ebo tagalao, dagego te homu dene ebo kolesaga yagameo. ");
INSERT INTO mps_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Tialima, te prisgo wego hanide, te aga wąį me deli isibaso da, teda prisgo te homu dene ebo kolesaga wali me pelamuo. Teyu, aga eno gedude meda pedalidalio,” wali. ");
INSERT INTO mps_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Te dage prisgo homu dene ebo kolesaga wali pabo sogo da, teda dagego tobolu me badu tobolu nisi tigidali togogio, tama te penane nisi togolama pęwadage iligio, tama te homu dene ebo kolesagade duga tigi olo madi togogimio. ");
INSERT INTO mps_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Magi baso meni, te dage pris dabe enaba kęą pai bidi mu bidimainogo sa muai. Ena dagego God, te dagego eno nogi aiyaba me elalugio. Dagego enaba ofa ebo sę dabe elalubao, te ofa dabe te dagego enaba nai mabo tiwai ebao. Tibaso, dagego te dwai kolesaga tigidali tudiba munama, te ena dali naga bilao. ");
INSERT INTO mps_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Dage pris eno bidi naga elalubao. Tialima, dagego te penanide bilibo we me sigio, te gasa bidigo penani yai we, ma aga bidigo sela sąwai we me selamo dao. ");
INSERT INTO mps_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Te we bidi augwaligo homude dage pris te eno bidi hani dolo da homu emainao, magi baso meni, dagego te ofa ebo nai dabe enabolo mabo dao. Ena digi ena Genuai Bidi. Ena tedali wiegi yai elaluyu, ena te wiegi yai doloba pai kolesaga naga ebo God bidibao. Eno ena we bidi dabe tedali wiegi yai pedalumainu yaibao, te augwaligo wiegi yai doloba pai kolesaga naga wali pabo dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Te dage prisgo wegi me deligo te penani ebo we pedelama, te meda yai kolesaga wali pabo si da, agai aga aya hale mu ilibao. Tibaso, te we bidi dabego aga ela munama, tama aga tigi isiba ulao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Hetprisgo aga sęde te nogi yai namba sali, te augwaligo aga toboluba wel gelebo sogo, te augwaligo aga te pris sę emainogo sa muai. Tama aga deli hani bage me deli isibaso, te homu dene ebo kolesaga wali pabo sogo, agai tobolu nisi olo elalumainogo igio, aga tobolu yaga bugagia sao. Te agai aga ugwa me pisągio. ");
INSERT INTO mps_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Hetpris te isali bidi munalubo beba me pigio. Tiyu, aga eno gedude meda pedelabuo. Te aga aya ida isibaso, tagalao, agai aga digi te homu dene ebo sogo te meda iligio. ");
INSERT INTO mps_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Tama aga te eno Ugwa Be tagalama, te bidi tigi munalubo beba pelamuo. Agai tama sę eyu da, agai eno sel Ugwa Be meda pedalubo sę ilaibao. Dagego aga wel pilali, te eno dagebolo mani welgo te aga hetpris pedalumainu sa muai dao, tama tialima aga te isai bidi tigi munalubo beba pigio. Ena Genuai Bidigo eno te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Hetprisgo te bidi dali me pisąwai we sobaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Agai te we, bidi me isiyu taga pai we me sigio, ma we aga bidigo sela sąwai we sigio. Agai te sunumide penani sę ela bilai we, ma we, gasa bidigo penani yai we me sigio. Te tama we dabe augwalide habu sali. Agai te bidi dali me pagela pisąwai we sao, tama agai we te pris augwa hanide naga sao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","“Te agai eno te po wali pisąbaso da, teda agai wai dabe eno gedude meda pedelaibao. Ena Genuai Bidi, eno aga ena da olama, sa muani, tama eno aga te hetpris sęba muai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Genuai Bidigo Mosesbolo ma wali, ");
INSERT INTO mps_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Nago Aronba te tiwai po wao, te bidi me deli nago hanide pedalubaso, ma nosali te aga tigi dwasianu dolai baso, te bidigo enabolo mabo nai ofa me elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Tigidali bidi augwali tigi dwasianu dolai baso, augwaligo enaba ofa me elamuo. Eno te tiwai tobage pris bidi dabede po obao, te gedu widai bidi dabe, ma sągą dwai bidi, ma gesabidi dwai bidi, ma te idago aga ame nani sogo te nogo sągą pęwadage elama gagea paibaso, ");
INSERT INTO mps_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ma bidi sągą ma nogo dolali, ");
INSERT INTO mps_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ma bidi tudi sugąsi bidi, ma pęwadage bidi mu yai baso, ma gedu dwai bidi, ma tigi dolali bidi yai baso, ma bidi aga domo dolai bidi, te tama tiwai bidi dabego pris sę eyu, enaba ofa nai me magio. ");
INSERT INTO mps_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Awe, te nago hanide bidai bidi me deli, te aga tigi dwasianu dolai elalubaso, agai te we bidigo mabo te tobage ofa dabe enaba me elamuo. Te habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Tialima, dagego enaba te ofa ebo kibu me gasa nai ofa ebo dabe te agai tumainao. Eno dage prisbolo menama tumainogo ebo ofa nai dabe te agai me sela tumainao. ");
INSERT INTO mps_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Tiali goli, aga te Tedali Gasagi Yai Mu Be Habu genuai ugwa munalubo be habu pąba me pigio, aga te alta pageba me pelamuo. Tiyu, te wiegi yai nai dabe agai eno gedude meda ilidalio. Magi baso meni, ena digi ena Genuai Bidi, tama eno te nai dabe dąį eyu, sa muani, ena sę digi emainogo yali.” Genuai Bidigo te tama po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Tama Mosesgo te tigidali po Aronbolo weyu, te aga ogwa dabeba me walio, te Israel we bidi tigidaliba me te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Te Aron dali, aga ogwa dabeba dali, te tama po walao. Bugagia kone palao, te Israel we bidi dabego ofa dabe da, te ena nai mu dao. Tialima, dagego te ofa dabe bugagia tonaluao. Te meni baso da, teda dagego eno genuai nogi aiyaba muyu dolaibao. Ena Genuai Bidigo eno te po obao. ");
INSERT INTO mps_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Te dage pris hanide bidi me deli te eno gedude meda pedalubaso da, teda aga te Israel dabego enabolo mabo ofa ebo nai pąba pabo habu mu selibao. Aga te pąba pali da, teda eno aga sela sąyu, te aga pris sę munu ma egobeo. Dagego te bomai po sesemane sesemane sogo wali piduao. Ena Genuai Bidigo, eno te po wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","5","“Te dage pris hani bidi me deli te oiyabe gasi elaluyu, ma aga tigide te bomai keni elama, te keni dį tigide pedalubaso da, teda aga eno gedude meda pedelama, te enaba ofa ebo nai dabe tusąbadi, te aga usu ma ebo sogoba usu nao. Te tama kolesagade aga meda pedelai baso, te ofa ebo nai dabe me agai tulamuo, te isai bidi tigide elaluali nai agai me diąwai baso, ma agai gasade gawa ąį pedalubaso, ma agai te wiegi yai isąwai meda yai hasaba nogo mueibaso, ma agai eno gedude meda elalubo bidiba kisa sigi paibaso da, teda te tiwai bidigo eno ofa nai me tulamo dao. ");
INSERT INTO mps_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Mena pris te tiwai meda pedalubaso, te meda agade elalubadi te giliga dega sigulaibao. Te aga ąį bolo bugagia paluama, te augwaligo enabolo ofa mabo kibu mi dabe tuagameo. Te wę pausąbaso, te agai me tugobe dao. ");
INSERT INTO mps_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Te giliga dega sigulai baso da, teda aga wiegi yai ma pedelali, te agai Genuai Bidi eno te ofa nai dabe tumainao, magi baso meni, te dage prisgo nai dao. ");
INSERT INTO mps_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Agai te odolali isali kibugo mi yai baso me tulamuo, te bulu uni hasago ela muai dao, te me tugio. Te agai tubaso da, te aga eno gedude meda pedalubao. Ena Genuai Bidigo, eno te po obao. ");
INSERT INTO mps_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Dage prisgo eno dagebolo mabo bomai po tigidali wali pao. Te dagego eno po sela sąbaso da, teda dagego dobo sę elama, te sęgę elalubaso, te eno dage ela mueibao. Ena Genuai Bidi, eno dage pris ena hani bage mu te sa muai, teyu eno te po wabo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Bidi ma we te dage pris hanide, te augwa naga te we bidi augwaligo ena mabo ofa ebo nai tuao. Te gasa bidigo me tugio. Te pris dali osogo bidibo bidi, ma aga sę bidi, augwaligo me tugio. Te habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Tialima, pris me deligo abelali olo sę ebo bidi dabe, ma olo sę ebo we dabe, te augwali aga dali bidali, te augwa wai dabe, te aga idago te prisgo bede ame nani, te augwaligo da te prisgo sabo tobage nai dabe somainao. ");
INSERT INTO mps_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Te pris me deligo wegi te pris sę isąbo bidigo sai baso da, teda te wego eno te ofa ebo nai dabe me tulamo dao. ");
INSERT INTO mps_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Tialima, te wego bidi isama, te we aga olo bidibadi, ma aga bidigo sela sąnama olo bidibadi, te wai meni badi, te we aga ayago beba ma pelama, bidibadi yai baso da, teda aga te prisgo tubo nai tuao, te aga ayago tubao. Tiali goli, bidi ma we te prisgo hani isąwaigo me tugobeo. Te habu dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Te bidi me deli dage pris hani isąwai, te aga bugagia homu kone palisąma, te agai enabolo ofa mabo nai me badu dage tueibaso da, teda agai prisgo te nai wei ponao. Te agai a naga nai dage saibaso da, teda aga a naga me deli wei ponomainao. ");
INSERT INTO mps_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Tialima, te pris dabego bugagia tonaluao, te olo we bidi augwaligo enaba ofa mabo nai te me tugio,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","“Te dage prisgo te olo bidi me deligo tumainogo yali da, teda te bidigo dwai sę yali, tama agai te nai wei te pris dabeba wei ponao. Magi baso meni, ena Genuai Bidigo eno te ofa sa munama, te ena da weyu, habu selai dao.” Te po wali. ");
INSERT INTO mps_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Tama Genuai Bidigo Mosesbolo te tama po wali, ");
INSERT INTO mps_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Nago te po Aronba me aga ogwa dabeba menama, te Israel we bidi tigidaliba wao. Te dage Israel bidi me deli, ma te dage dali bidibo gasa hani bidi me deli, agai te isiba tigidali ulama dabo ofa me deli sela asiyu, te agai enaba dąų wali po me deli usu nainogo, ma aga homugo digi naga sela asobaso da, ");
INSERT INTO mps_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","teda agai bulmakau omai me deli, ma sipsip omai, ma meme omai ofa emainao. Tialima, dagego te keni kenigo tigi dolai kibugo ofa me elamuo. Dagego tama teyu da, eno te godolo homu me egobe dao. ");
INSERT INTO mps_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Bugagia odao. Te dagego kibu tigi dwasianu dwai gana yaigo ofa ebaso da, teda eno godolo me egobeo. ");
INSERT INTO mps_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Te bidi me deligo ena Genuai Bidi dali deli) haliga ebo ofa mabo sogo, te agai ena dali dąų wali po usu niyu, mabo ofa yaibaso, te tagalao, te aga homugo digi ebo ofa yaibaso da, teda agai wiegi yai bulmakau ma sipsip te keni kenigo aga tigi me dolisąwai sesao. Te agai tama tibaso da, teda eno agai ofa mabo godolo homu yaibao. ");
INSERT INTO mps_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Dagego te gedu widai kibu, ma sągą dwai, ma tigi dolai, ma bomai keni elalubo, ma tigi gesigo togai, ma buluba yai kibu yaibaso, enabolo ofa me elamuo. Dagego te tobage tigi poąį kibu te eno altade ofa elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Te dagego ofa me deli duga homugo digi ebaso da, teda dagego te kibu nogo sągą kikasi pęwadage ma gagea pai selama, te sę ebaso usu yaibao. Tialima, dagego te tobage kibu tiwai selama, te dagego enaba dąų wali bomai po me deli usu nabo ofa yainu da, te tiwai sę me elamuo. Te habu dao. ");
INSERT INTO mps_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Te kibu domo dolai baso, ma augwaligo togali ma pedali, ma augwaligo domo diasąwai baso, dagego te tobage kibu enabolo ofa me igio. Dagego te kibu dabe te tobage kolesagade te duga tǫ kantride doligio. Te habu dao. ");
INSERT INTO mps_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Dagego te tobage kibu dabe te gasa bulu tǫ kantride bidi nogode selama, te ofa me elamuo. Te tiwai kibu dabe eno gedude wiegi yai menio. Eno te tobage ofa homu godolo me egobeo. Mu menio,” wali. ");
INSERT INTO mps_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Te Genuai Bidigo te tiwai po Mosesbolo wali, ");
INSERT INTO mps_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Te bulmakau, me sipsip, me meme te wai ame nabo sogo da, teda te wai dabe aga ida dali te a naga me si sogo bidiyu bolo yao. Te nosali badu, dagego ofa ebo homu eyu da, te altaba sela pelama, ofa yagameo, eno dagego te ofa godolo homu ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Tiali goli, te deli sogo naga dagego te bulmakau, ma sipsip, ma meme te augwa wai dabe elama, te ida me wai selama, te ofa igio. Te habu dao. ");
INSERT INTO mps_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Te dagego ena Genuai Bidiba buba hwi wabo ofa me deli ebaso da, teda dagego te ofa ebo bomai po wali pao, teda eno dagego ebo ofa godolo yaibao. ");
INSERT INTO mps_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Te be ulade naga dagego ofa eyu, dagego te ofa ebo kibu mi tuao. Te me sogo kigamu nosali tueiba olama, te dagego elalumainogo igio. Te tebo sę habu mu selibao. Ena Genuai Bidigo eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Odao. Dagego Genuai Bidi eno bomai po tigidali wali pao. ");
INSERT INTO mps_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Dagego eno genuai nogi aiyaba muyu me doligio. Dage tigidali Israel we bidi te ena dologode bidao, magi baso meni, ena wiegi yai doloba pai mu elalubao. Ena digi ena Genuai Bidi, te eno dage wiegi yai doloba pai we bidi pedalumainogo ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ena dagego God bidainogo, te dage eno Isipde selama, odasa asali. Ena Genuai Bidigo, eno tama tiai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Te Genuai Bidigo Mosesbolo e tama po wali, ");
INSERT INTO mps_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Te Israel we bidi dabebolo te genuai lotu wabo side eno augwaliba bodolu muyu dąį ilai dao po walao. Dage sisinama, e tama side lotu waiyąo. ");
INSERT INTO mps_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Dagego sę yabo side te a naga me deli sogo elalubao. Tialima, te Sabat side da, te toma nabo side naga elalubao, te dagego sę me igio. Dage sisinama, lotu waiyąo. Te Sabat side dage menade bidali tagalao, dagego te ena Genuai Bidigo bodolu muani side da homu yao. ");
INSERT INTO mps_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Megi da, eno dagebolo te genuai sogo dąį ilali po walainogo ebao. Te tigidali kibu bede dage te sogo sisinama lotu wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Te Genuai Bidigo e tiwai po wali, “Dagego Godigo Da te Isipde Bugagia Bidimainu Sula Tagalali Genuai Side, te Pasova Side homu kone palama, dąį ilao. Te genuai side te hasia wabo polua, dei 14, tede gagalao, te giliga dega sigulubo sogo, te deli sogo bubugade usu nama bidao. ");
INSERT INTO mps_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Te polua dei 15 wabode, te Bo Disąwai Bret Tubo Genuai Side elalubao. Tama dagego te bo disąwai yis meni yai bret tudubadi, te Sarere deliba usu nao. ");
INSERT INTO mps_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Te Sarere hasia side dage lotu wainogo sisinao, te dagego duga sę me elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Dagego ena Genuai Bidiba te kibu me nai ula mabo ofa deli deli bubugade idubadi, te Sarere deliba usu nao. Te nogo a naga me si wabo side dage ma sisinama, lotu wao, te side dagego sę munu me elamo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Te Genuai Bidigo Mosesbolo te tiwai po ma wali, ");
INSERT INTO mps_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Te Israel we bidi augwaliba te tiwai ma wao. Te dage eno mawainogo ebo tǫba bidigi pabo sogo, te nosali dagego duga gide te wit tau inawai sabo sogo da, teda te tigidali kibu bede te polasa duani wit selama, dagego te pris dabeba selasa pao. ");
INSERT INTO mps_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Tama prisgo te wit duani nogode tolaluyu, te eno gedude uga eda elama, te eno dagebolo usu da waibao. Prisgo te Sabat side tudi badu nosali ofa ebaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Tama dagego te wit ofa ebo sogo, dagego te sipsip wai kibu be deli yai ofa yao, te wiegi yai mu, te keni kenigo tigi me dolisąwai ofa yao. Te sipsip te isiba tigidali ulubo ofa yao. ");
INSERT INTO mps_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Dagego te wiegi yai plaua me badu dage sao, te aga sęgę 2 kilogram, te oliv wel dali taluama, te wit ulubo ofa yao. Te isiba tigidali ulama dabo ofa dali ofa ilao, eno te ofa ebo denami godolo yaibao. Tama dagego te lita deli wain selama, te ofa si dali ofa yao. ");
INSERT INTO mps_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tialima, dagego te hasia duani wit te duga God, enaba sela asisąbadi, dagego te gide sabo gesi wit tugio. Te dagego sela aselama da, teda duga tuagameo. Dagego te wit ge disąwai nai tuao, ma duga isiba uluyu yao, ma dagego plaua nigilama, te bret ulama tuao. Dagego te ofago bomai po wali peyu, te duga wąį nosali, me nosali pedalubo bage, augwaligo me wali pomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Te Genuai Bidigo po te tiwai ma wali, “Te ena Genuai Bidiba, dagego te duani wit magasobo side te nosali badu nedebo gagalobo te Sarere a naga me si dao. ");
INSERT INTO mps_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Te 50 wabo side, te a naga olama si wali Sarere silibo si nosali badu, dagego te wit gasa gesi ofa enabolo mao. ");
INSERT INTO mps_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Te we bidi wai augwali deli delide bret si seselama, enabolo te gesi wit ofa mabo tiwai yao. Dagego te sęgę kilogram si yai plaua si te bret deli deli nigabo usu selama, te yis dali taluama ulao, te Genuai Bidi, enaba te bret ofa yao. Te prisgo nogo tolaluyu, eno gedude iba eda yao. ");
INSERT INTO mps_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Te dagego gasa nai te bret dali ofa yao. Dagego te kibu sipsip wai te kibu be deli yai a naga me si ofa yao, te ogwa bidi bulmakau me deli, te omai sipsip si sobadi te ofa yao. Dagego te kenigo aga tigi dolali kibu me sigio. Te wiegi yai kibu naga sao. Te dagego enaba te isiba tigidali domainu ulubo ofa tiwai yao, te wit me wain meba te ofa dali muao, te dagego tigidali sogo ebo tiwai yao. Te ofago wiegi yai denami ebaso, ena Genuai Bidigo, eno godolo mu ebo dao. ");
INSERT INTO mps_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Dagego te omai kibu meme me deli selama, te sęgę sela sąbo ofa yao, te kibu be deli yai omai sipsip wai si me selama, te deli haliga pedelabo ofa yao. ");
INSERT INTO mps_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Prisgo te polasa tau inawai witgo nigai bret me te sipsip si selama, nogode tolaluyu, iba eda eno gedude yao, te ofa tiwai ebao. Te ofa dabe te ena nai mu elalubaso, eno te pris augwaliba mawaibao. ");
INSERT INTO mps_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Dagego te ofa ebo side dage sisinama, lotu wao. Dagego duga sę dabe te side me elamuo. Te duga wąį nǫų dabe te nosali nosali pedelama, te menade bidibaso, tigidaligo te bomai po sesemane wali pidubadi geao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Te dagego duga gide te wit tau inawani sabo sogo, dagego te gi sesege badu mu gagalama sigimio. Dagego te gi tomode nai sabo sogo, te me badu nai dagego ela soeibaso da, teda dage te si sogo ma pelama sigi pigio. Te elalumainogo elama, te nai meni yai bidi dabego me te gasa bulu bidi dage dali bidibo bidi, augwaligo te nai somainao. Ena Genuai Bidi, ena dagego Godigo, eno te tama po wai dao.” ");
INSERT INTO mps_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Te Israel we bidibolo te tiwai po walao. Te 7 polua dei 1, dage toma nao. Te duga genuai side me deli dao, te dagego bu wabo nai biugel bu olama, te dage sisinagaselama, lotu wao. ");
INSERT INTO mps_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Tama te side dagego duga sę me elamuo. Menio. Dage te altaba pelama, enaba ofa mao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Te Genuai Bidigo Mosesbolo wali, ");
INSERT INTO mps_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Te 7 polua dei 10de Te We Bidi Augwaligo Sęgę Sela Sąbo Genuai Side dąį ilali. Te side dagego nai tubo me wiegi yai pemene ebo sę tigidali habu selao. Te dage lotu wainogo sisinama, te ofa me deli enaba sesao.” Te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","“Te side dagego sę me igio, magi baso meni, te side prisgo te sęgę sela sąbo ofa yaibao. Prisgo te ofa ebaso, ena God, dagego Genuai Bidi, te eno dagego sęgę tigidali sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Bidi me deligo te side nai tuali da, te aga eno we bidi hanide sela sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Bidi me deligo te side sę ebaso da, teda ena digi ena aga ela mueibao. ");
INSERT INTO mps_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Odao. Eno po ma obao, dagego te side sę me deli igio. Dagego sesemane sogo te bomai po wali piduao. Te dagego wąį nǫų nosali nosali pedelama, menade bidibaso me, augwaligo me wali pomainao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","“Dage te side bugagia toma nao. Te gagalobo side te dei 9 wabode gagalaibao, te giliga dega sigi pabo sogo, te dei 10 wabode te sia ge dega sigi paboba usu naibao. Te side usu nama tigidali, dage nai tubo me wiegi yai pemene tigidali ebo habu mu selao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Genuai Bidigo Mosesbolo walama, Israel dabeba te po mao wali. ");
INSERT INTO mps_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Agai te tiwai po wali, “Te 7 polua 15 dei wabode, te namba 1 dei te genuai side te we bidi augwaligo te dwasianu be te ni nologo selama sę ebo side elalubao, te bede bididubadi te a naga si sogo Sarere deliba usu nama, ena homu kone palao. ");
INSERT INTO mps_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Te Sarere hasia wabo side, dage sisinama, lotu wao, te dagego duga sę me elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Dagego enaba te Sarere usu nama ofa tigidali side yao. Te 8 wabo side, dage ma sisinama, lotu weyu, te dagego ofa yao. Te dei 8 wabo side da, te lotu wabo side naga dao, te dagego sę me igio,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Te side dabe da te ena Genuai Bidigo dąį ilali side, te dage lotuba sisinama, ena ofa yao. Te dagego isiba tigidali ulubo ofa eyu, te wit ulubo ofa, me wain ąį gelebo, me gasa ofa me yao. Tama dagego te ofa deli deli te aga bodolu muani side dolo iyąo. ");
INSERT INTO mps_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Dagego te tigidali side bodolu wali peyu, te enaba lotu weyu, toma nabo Sabat side tigidali me tiao. Dagego te ofa dabe eyu, te dagego enabolo gasa mabo nai me mao, te dąų yali po usu nubo ofa dabe, me te duga homugo digi enabolo mabo ofa me maiyąo,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Te 7 polua 15 dei wabo side, te dagego tau yali nai sela aselama nosali, dagego te nogo a naga olama. me si wabo genuai si te osogo bidabo bede bidiyu, te ena Genuai Bidiba homu kone palao. Te hasia wabo dei me dei 8 wabo side, dage toma nabo side sę tagalama, bidao. ");
INSERT INTO mps_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Te namba wan dei wabo side dagego wiegi yai nai mu meba dagego te tubo ni dude sao. Tama dagego te ni det nologo me te yabe hauwa elalubo ni nologo me sao. Tama dage wiegi yai pemene idubadi, te nogo a naga me si wabo siba te eno gedude tama yao, Genuai Bidi, dagego God dao. ");
INSERT INTO mps_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Tigidali kibu bede te 7 wabo poluade te dagego enaba muani genuai bodolu te 7 sogo elalueibao. Te duga wąį nǫų nosali nosali pedalubo bagego te bomai po wali pao. ");
INSERT INTO mps_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Dage tigidali Israel we bidi te dwasianu tolu yabe bede te a naga me si sogo bidao. ");
INSERT INTO mps_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Dagego tama tibaso da, te wąį nǫų nosali pedalubo hani dabe, augwaligo sulama koneyu, te eno dage te tǫ kantri Isipde selama, te dage odasa asali homu yaibao, tama te sogo eno dage te tobage bede bidali tiwai yali. Ena Genuai Bidi, ena duga God, eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mosesgo te po odama, agai te Israel augwaliba olama, te tigidali genuai bodolu side te Godigo nogi ugwaba sao po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Genuai Bidigo Mosesbolo te tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Te Israel tigidaliba walama. augwaligo te wiegi yai ni oliv wel te eno sel Ugwa Be tomode munalubo lamba muabo wel sesao. Te pris dagego tigidali hulide lam sole udaludaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","“Arongo te lam sole dabe pio ebode mu udulama. te tigidali hulide te lam ula elaludu. te sogo kigamuba usu naibao. Te lam dabe te genuai walali ugwa dąį togali bulu.badu edade elalu. te Dąų Wali Bomai Po Munalubo Halobage te Tedali Gasagi Yai Mu Be Habu tomode munalubo ena Genuai Bidi, eno sueibao. Eno te bomai po dagebolo mani, te dage me duga hani nosali pedalubo hanigo me te bomai po sesemane wali pao. ");
INSERT INTO mps_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arongo te ni dagede elalubo lam sole bugagia tonaluao, te bugagia tonaluyu, te lam ula sula sabuo, te augwali ula elalubo eno sueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Genuai Bidigo Mosesbolo te po ma weyu, te tiwai wali, “Nago te sęgę 12 kilogram elalubo wiegi yai plaua selama, te plauago 12 bret nigao. Te sęgę deli deli dobolama, te bret deli deli nigao. ");
INSERT INTO mps_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Nosali te bret dabe te tebolba muao, augwa te ni akasgo me wiegi yai golgo nigali, te Genuai Bidi ena gedude e munalueibao. Te bret nani si wasilao, te bret a naga me deli te nani deli deli wasilao. ");
INSERT INTO mps_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Te wiegi yai denami pedalubo pauda meba dali te bret nani si dali muao, te nosali augwaligo te pauda enabolo ofa yao, te bret hasegeliyu, tama yao. ");
INSERT INTO mps_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Te tigidali Sabatde te pris augwaligo te bret tebolba mubaso eno sueibao. Sesemane sogo te Israel augwaligo te kolesaga wali pao. Tede te po dąų wabo kontrak me deli eno augwali dali ebao. ");
INSERT INTO mps_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Te bret te Aron dali aga hani pris dabe daligo nai elalueibao. Augwaligo te bret eno sel Ugwa Be obo tomode tuao, magi baso meni, te we bidi augwaligo enaba ofa yali nai dage dao. Te ena nai digi, te eno pris dabeba mawaibao.” Godigo te po Mosesbolo mawai dao. ");
INSERT INTO mps_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Bidi me deli bidali, aga aya Isip bidi, aga ida Israel we me deli. Ida nogi, te Selomit, Selomit te Dirigo wegi, te Dango hani. Te Selomitgo ogwa te bidibo pesagede bidiyu, te Israel bidi me deli dali hwįani. Augwa si hwįbo sę eyu, te Selomitgo ogwago te Genuai Bidigo nogide agabolo po dwai wali. Tama augwaligo aga Mosesba sela palio. ");
INSERT INTO mps_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Tama Mosesgo aga kalabusiba munama, te Genuai Bidigo te bidiba mena sę yabo po te agabolo wabo tonaluali. ");
INSERT INTO mps_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Tialima, Genuai Bidigo Mosesbolo po walali, ");
INSERT INTO mps_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Te bidi selama, te bidibo pesage buluba pao. Agai enabolo po dwai po wabo odali bidi tigidali, augwaligo nogo aga toboluba muao. Augwaligo tama tebo, te we bidi augwaliba ola mayu, te bidigo dwai sę yalio, te sęgę agade elalubao. Te tigidali we bidigo agaba masigi sąnama, te aga isibo siba usu nao. ");
INSERT INTO mps_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Nosali nago Israel augwaliba te po walao, ‘Te bidi me deligo enaba po dwai wali da, aga yali dwai sęgę elalubaso, te aga yali sęgo sęgę tolalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Agai te dwai po wabo sogo ena Genuai Bidi nogi ebaso da, teda aga isimainao. Te Israel bidi mu me, te Israel tomode bidibo gasa hani dabe me, tagalao. Te bidigo ena nogi te tiwai nogi ebaso da, teda tigidali we bidigo agaba masigi sąnama, aga isiboba usu nao,’ te po wao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘Te gasa bidi ma we ela mubo bidi yai baso da, teda dagego aga me ela muao. ");
INSERT INTO mps_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Bidigo gasa bidi mego bulmakau ela mubaso da, te agai gasa bulmakau te bidiba wei ponao. Te tobage dwai sę ebo dodolobo kolesaga e tiwai. Bidigo gasa bidigo kibu elali, agai te tobage tiwai naga agaba wei ponao.’” ");
INSERT INTO mps_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“‘Te bidi mego gasa bidigo tigi dolobaso da, teda dagego deli tigi poai sę agaba wei ponao. ");
INSERT INTO mps_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Te agai gasa bidigo dili togai baso, dagego aga dili me togao. Te agai gasa bidigo gedu dolali, dagego agai gedu me dolao. Te agai gasa bidigo kele degai baso da, teda dagego agai kele me degao. Bidigo mena sęgo te gasa bidi dolai baso, dagego te tobage deli kolesaga naga agaba wei ponao. ");
INSERT INTO mps_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Bidigo gasa bidigo kibu ela muani da, agai te bidiba deli tigi tobage naigo wei ponao. Tiali goli, bidigo gasa bidi me ela muani da, dagego te bidi aga digi ela munama, wei ponao. ");
INSERT INTO mps_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Eno te bomai po deli dage Israelba me dage tomode bidibo gasa haniba me dąį mubao. Ena Genuai Bidi, ena dagego God dao, eno dagebolo te po wai dao,’” wali. ");
INSERT INTO mps_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mosesgo te po dabe Israel we bidi augwaliba pusula silama da, te nosali augwaligo te Godiba po dwai wali bidi selasa, te bidibo pesage buluba odasa pali. Te augwaligo agaba masigi sąnama, aga ela muani. Te kolesaga yali te Israel augwaligo te Genuai Bidigo Mosesba mani po wali peyu yai dao. ");
INSERT INTO mps_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Moses te Sainai bulu dude bidibadi, ");
INSERT INTO mps_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Genuai Bidigo agabolo te Israel augwaliba maiabo po pusali. Genuai Bidigo te tiwai po walio, “Te dagebolo eno mawainogo ebo tǫba dage bidigi pabo sogo da, teda te a naga me si wali kibu be te kibu be me delide dagego nai me bulugio. Dagego te tǫ olo elalumainogo yao. Tǫ toma nomainao, te dage Sabat side toma nabo tiwai emainao. Dagego te tiwai ebo te eno kibu be da olama, dąį eyu yao. ");
INSERT INTO mps_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Te kibu be me sela me selade dagego te duga tǫde mena tobage nai bulao, te wain nologo dabe togolama, te gide nai sao. ");
INSERT INTO mps_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Tiali goli, te 7 wabo kibu be me delide dagego te tǫ toma neyu, olo elalumainao. Te kibu be dagego eno kibu be da olama, sa muao. Dagego nai me bulisąma, te ni wain nologo me togolamo dao. ");
INSERT INTO mps_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Te nai wit pedelama olo dali elalubaso da, teda dagego te nai wai me selama, nai mubo beba me sisinigio. Te ni wainde te age holobaso da, teda dagego te wain nigainogo me sigio. Tigidali sula tagalama elalumainao, magi baso meni, te kibu bede tǫ bugagia toma nomainao. ");
INSERT INTO mps_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Te kibu bede dagego tǫde nai odolali pedelali, te tuyu naga yao. Te nai sisinibo beba sisiniyu, ma wain nigibo sę me egobeo. Dage me, olo sę ebo bidi me, olo sę ebo we me, gasa sę bidi dabe me, te dage dali bidibo gasa hani we bidi dabe, duga tuiyąo. ");
INSERT INTO mps_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Te bulmakau, sipsip, meme dabe, te bulu uni kibu hasa dabego me tumainao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Genuai Bidigo po ma weyu, te tiwai po wali, “Te a naga me si sogo dagego te kibu be 7 te tama nedao, te kibu be bidi sese si a naga me si me si, te 49 kibu beba usu naibao. ");
INSERT INTO mps_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Te kibu be 49 wabo side, te 7 polua dei 10 wabo sogo, dagego bidi meba tagala palama, te duga tǫ kantri pedaiba te bu wabo nai biugel bu wagi pomainao. Te side te God eno genuai side, eno te We Bidi Augwaligo Sęgę Sela Sąyabo Side mu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Te kibu be te 50 gagalobo, te side dagego bu wabo nai biugel bu wao, te eno kibu bede dolo ebao. Te dagego tigidali we bidi augwaliba hanilama weyu, te augwa sęgę silama, te augwa bugagia bidaibao po wao. Te kibu bede, te gasa bidigo tǫ abelali bidi dabe, augwaligo te tǫ aga aya muba, me ma tǫ aga ayago deli haniba te wei ponao. Te olo sę ebo bidi dabe me olo sę ebo we dabe bidali, augwa te sę yali tagalama, te augwa deli hani sibiba ma pelama bidao. ");
INSERT INTO mps_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Te kibu be 50 obaso, te kibu bede da, tigidali we bidi pemene elama, bugagia bidalubo kibu be pedelaibao. Te kibu bede duga tǫde nai me bulugio, tama dagego te wit dabe togolama me sisinigio. Te dagego wain du selama, te wain ąį me nigilamo dao. ");
INSERT INTO mps_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Magi baso meni, dagego te kibu be tigidalide ena Genuai Bidigo kibu be naga da, te homu yao. Te dagego duga tǫde olo pedalubo nai sela tuao, te tama. Dagego te gasa nai dabe me tulamo dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Te kibu bede dage bidi dabego tǫ gasa bidiba mani, dagego te tǫ duga ma sao. ");
INSERT INTO mps_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","15","Te gasa bidi dagego tǫ abelemainogo mabo sogo, dagego koneao, te nisu naga kibu bede te nai tigidali wei ma mabo, te nisu naga sogo agai te bulali nai tau yali sabo me elalubo. Agai bugagia abelemainao, te tǫde mone usu nama dolo sao. ");
INSERT INTO mps_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Te kibu be hauwa yabo elalubaso da, teda mone ugwaba holao. Tialima, te kibu be hauwa egobe da weyu da, te mone aiya dulao, magi baso meni, agai te tǫ mu abelegobeo. Menio. Te tigidali kibu bede te tǫ agai nogode elalu, agai te tǫde sabo nai abelebo dao. ");
INSERT INTO mps_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Dagego te abagi me deli tibo po ola magio, te tǫ abelabo monede. Menio. Dagego enade wi yao, dagego God dao, te doloba pai kolesaga naga yao. Ena Genuai Bidigo te tiwai po obao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Genuai Bidigo po ma weyu, te tama po wai, “Dagego eno po tigidali bugagia wali peyu, eno bomai po me tigidali wali pao. Te dagego tama tibaso da, teda eno dage mawainogo ebo tǫde sesemane bugagia bidaibao. ");
INSERT INTO mps_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Te nai hauwa te tǫde pedelama, te dagego nai hauwa sesemane sogo tudaibao. Tama dage te tǫde bugagia bidaibao. ");
INSERT INTO mps_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Tama teyu, dagego te tiwai po waidalio, ‘Te a naga si wabo kibu bede dago te nai me bulisąma, te odolali tau yali nai naga sisinaibao,’ wagio. ‘Te tama tebo dago habu selai baso da, teda dago magi nai mu te kibu bede tueibawe?’ ");
INSERT INTO mps_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Tagalao, dage moni homu si me igio. Ena Genuai Bidi, te 6 wabo kibu bede eno te tǫ wiegi yai bugagia mu ilaibao, te dagego te nai tudubadi kibu be selaba usu naibao. ");
INSERT INTO mps_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Te 8 wabo kibu bede dagego bulubo nai da, te kibu be a naga me delide sali nai tudubadi geaibao. Te dage nai usu elalubadi, te gesi tamadi bulali nai sabo bodoluba usu naibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Genuai Bidigo te tiwai po ma wali, “Te gasa bidigo dagego tǫ abelai baso, agai sesemane sogo mu tonaludugio. Magi baso meni, te duga tǫ mu elalubeo. Te ena Genuai Bidigo tǫ elalubao, te eno dage Israel bidimainogo yali, te bidi dabego augwa tǫde te gasa tǫ kantri bidi dabe osogo bida wabo tiwai yai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Te dage bidi me deligo te duga bage gasa bidigo tǫ abelebaso da, teda agai te tiwai bugagia kone palao, te nosali tǫ aga ayago ma abelemainogo ebaso da, teda aga abelemainao. ");
INSERT INTO mps_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Te duga abagi me deli magi nai doado bage meni baso, te agai mone meba sabo homu elama, te gasa bidigo aga tǫ abelemainogo ebaso da, teda aga deli kanemego dolo tonalubo sę eyu aga tau sabo sę yao, agai te tǫ ma abelama te agaba ma mao. ");
INSERT INTO mps_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Tialima, te aga tau sabo deli kaneme meni yai baso, aga digi ma abelemainao. Te nosali aga mone hauwa elalubaso da, teda aga te tǫ ma abelao. ");
INSERT INTO mps_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Agai nedali te nisu naga kibu be elalubaso, te nai dabe ma wei mabo kibu be gegabo sogo, te kibu be dabede agai nisu naga nai pedelabo te nedao. Tama agai te nai usu nabo mone usu selama, te aga tǫ polobadu abelali bidibolo mao, tama aga tǫ ma sabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Tialima, te aga mone sǫą pelama, tama aga te tǫ ma abelabo usu meni yai baso da, teda te tǫ abelali bidi aga nogode elalubadi, te nai dabe page bidiba ma mabo sogoba ma usu numainao. Te kibu beba pedalubo sogo, te tǫ abelali bidigo te tǫ aga page bidiba ma dolo mabo usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Te taun obo tomode elalubo bidigo be, te bidi me deligo abelai baso da, teda te be aga ayago te kibu be deli bididubadi, te be page bidigo ma abelabo usu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Te kibu be deli bidai digi agai te be ma abelesąbaso da, teda agai ma abelabo sunumi me elalubeo. Mu menio. Megi da te be te abelali bidi aga be elalueibao, te aga wąį nǫų nosali pedalubo hanigo be pedelaibao. Tama agai te nai dabe wei ma mabo kibu bede ma abelainu ebo usu me egobeo. ");
INSERT INTO mps_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Tiali goli, te obo elalusąbo madi elalubo dwasianu be dabe, te dagego homugo augwali te nai bulabo tǫ tiwai da homu yao. Tialima, te be dabe aga ayago ma abelabo usu yaibao, te nai dabe wei ma mabo kibu bede, te abelali bidi dabego te be aga ayabolo wei ponobaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Tialima, te Livai hani da, augwaligo te bomai po wali pelamuo. Te augwa taun obo tomode elalubo be yai baso da, teda augwaligo ma abelemainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","“Te Livai me deligo aga be bidigo abelemainu yali, te aga ma abelesąbaso da, teda te be abelali bidigo agai te Livai agabolo ma mao, te nai dabe wei ma mabo kibu bede tiao. Magi baso meni, eno dage gasa Israelba tǫ sa muani, tiali goli te Livai hanibolo te tiwai me ebeo. Menio. Eno taun naga augwaliba mani. Tialima, te Livai dabego taunde elalubo be dabe, te Livai hani augwa be mu naga tama sesemane elalubo dao. ");
INSERT INTO mps_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Te Livai dabego taun sesege badu elalubo tǫ dabe, te gasa bidigo me abelamuo. Te Livai dabe augwa tǫ sesemane elalueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Genuai Bidigo po te tiwai ma wali, “Te dagego abagi me deli magi nai meni yai bidi pedelama, te doado bage abelabo mone gegabo sę usu isąbaso da, teda duga digi aga tonaluao, te gasa tǫ kantri bidi dage dali bidagasali bidi tonalubo tiwai yao. Te tiwai ebaso da, te abagi dage dali bidaibao. ");
INSERT INTO mps_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Te agai dagede mone negeli yai baso da, teda agai te mone negeli wei ponobo sogo te dagego gasa ugwadu daganobo mone dali manama, momainogo elamuo. Te agai nai abelainogo ebaso, te dagego mone ugwaba holoyu, te agade gasa mone dali saiba homu igio. Dage Godide wi naga elama, te abagi dage dali bidimainao. ");
INSERT INTO mps_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ena God, duga Genuai Bidi, eno po dagebolo walio. Ena dagego God bidibao homu yai, tibaso eno dage te tǫ kantri Isipde selama, odasa asali, dagebolo te tǫ kantri Kenan mawai hagede yai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Genuai Bidigo po te tiwai ma wali, “Te abagi me deli magi nai menia sobaso, te aga dagego olo mu sę ebo bidi tiwai abelebaso da, teda dagego aga te olo mu sę ebo bidi sesanobo tiwai elamo dao. ");
INSERT INTO mps_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Aga dage dali bidu, te mone sę ebo bidi tiwai bidao, te aga dage dali sę ela pidubadi, te tigidali nai wei ma mabo kibu beba usu nao,” po wai. ");
INSERT INTO mps_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","“Te wali kibu bede aga me aga we wai dali, te augwaligo dage tagalama, te aga haniba ma pelama, te aga wąį nǫų dabego tǫde bidaibao. ");
INSERT INTO mps_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Te page e tiwai elalubao. Polobadu dage Israel te Isipde olo mu sę ebo bidi bidai, eno dage sagaselama, dagego te Isip mu taga soali. Tama tialigo, dage ena Genuai Bidigo olo mu sę ebo bidi ma we pedelali, te dagego me abagi dabe abelama, te augwali olo mu sę ebo bidi sesemane bidaibao homu igio. Te habu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tama tialima, dagego te abagi selebo sę eyu, aga sę dene ilibo sę igio. Menio. Dage enade wi yao, dagego God, te dagego bugagia wiegi yai sę naga agaba yao. ");
INSERT INTO mps_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Te dagego olo mu sę yabo sę bidi, me sę ebo we sabo homu ebaso da, teda dage pąde elalubo tǫ kantri dabede sao, augwali te Israel hani bage isąwai. ");
INSERT INTO mps_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Tama me dagego te olo mu sę ebo bidi abelai hagede te gasa tǫ kantri bidi dabe dage dali bidibo hanide abelao. Te dagego olo mu sę ebo bidi me olo sę ebo we te augwalide abelabo usu mu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Te dage isibo si da, te duga ogwa dabe augwaligo te olo mu sę ebo bidi ma we dabe somainao. Te augwaligo dagego ogwa dabego sę sesemane sogo idumainao. Tiali goli, te duga abagi dagego digi te olo mu sę ebo bidi pedelai baso da, teda dagego augwali selebo sę igio. Dagego augwalide dua dua yao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Te gasa tǫ kantri bidi dage dali bidagasali bidi te mone bidi pedelali. Te dagego abagi Israel bidi me deli te magi nai meni yai bidi pedelai baso, aga te gasa tǫ kantri bidigo abelemainogo elama, aga te bidigo olo sę ebo bidi bidimainao, ma te bidi aga deli hanigo olo sę ebo bidi bidibaso me usu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Te abagi Israelgo tama tibaso da, teda dagego aga ma abelama sagameo. Aga ama me deligo, ");
INSERT INTO mps_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ma aga aya sabi bidigo, ma aga deli kaneme hanigo aga ma abelao. Te aga mone sali usu yai baso da, teda aga digi abelama, te dwai sę olo ebo tagalao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“Te bidigo aga abelali bidi dali po minama, te elaluali tigidali kibu be dali te nai wei ma mabo kibu be dali me usu nama nedao. Tialima, te olo sę yali bidi aga tonaluali genuai bidigo te kibu bede te bidigo mone sę yali dąį ilao. Tama te bidi aga digi ma aga deli kaneme bidigo te tobage tiwai monego mu te bidi ma abelebaso usu dao. ");
INSERT INTO mps_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Te kibu be hauwa elalubadi yai baso da, teda te bidigo genuai mone te tonalubo genuai bidibolo wei ponama mao. ");
INSERT INTO mps_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Te kibu be hauwa bidisąwai te nai wei ma mabo kibu be pedalubaso da, teda agai dwasianu mone te tonalubo bidibolo wei ponao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","“Te tonalubo bidigo koneao, sę bidi te kibu be deli delide te kontrak sę ebo bidi tiwai da weyu, te aga dwagila selebo sę me igio. Agai dua tama naga yao. ");
INSERT INTO mps_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Te augwaligo te bidi te kolesaga me delide te ma abelesąbaso da, teda te nai dabe wei ma mabo kibu bede, te tonalubo bidigo te bidi aga we wai dali tagala palama, olo mu bidimainao. ");
INSERT INTO mps_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Dagego te dage Israel me deli olo mu sę ebo bidi sesemane bidimainao wagio, magi baso meni, ena Genuai Bidi, ena dagego God, te eno dage Isipde selama, te dage odasa asali. Tama tibaso, dage enade digi te olo mu sę ebo bidi bidimainogo yai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Genuai Bidigo te po wai, “Dagego te ni dage selama, tego te piksa noma nigigio, ma genuai masigi selama dualiyu, ma te masigi selama, tego babaga pabo sę elama, te tobage nai dabe dagego tibo god da olama, teba lotu wagio. Menio. Dagego ena deliba naga lotu wao, dagego Genuai Bidi dao. ");
INSERT INTO mps_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Dagego te Sabat dabe side sę me igio, eno dageba dąį ilai dao. Dage toma naga nao. Te dagego eno be godolo mu iyąo. Ena Genuai Bidigo eno te po wai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Te dagego eno bomai po dabe wali peyu, te eno dagebolo yao po wabo sę dabe ebaso da, ");
INSERT INTO mps_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","teda eno te tulubage tulubo sogo te tulubage tulumainogo ilaibao. Tama eno dagego tǫde nai wiegi yai mu holomainogo elama, te ni dabego nai hauwa walaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Te dagego nai hauwa mu elalu, te dagego wit tau yali sesa pidubadi, te wain du tau yali sabo sogoba usu naibao. Tama dagego te wain du tau yali sidubadi, te wit wai bulubo sogoba usu naibao. Te dage nai tudumainogo genama, te dage haliga mu pągąwaibao. Te dage bugagia mu duga tǫde dugulalu bidaibao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Te eno dageba haliga nagame ebo kolesaga menama, te dage bugagia dugulalu, te dage godege pibo sogo magi nai me delide wi me egobeo. Eno dagego tǫde te dwai uni hasa dabe sela sąnama, te boi bidi dabego dage te tǫde bidibadi te boi me hwįgobeo. ");
INSERT INTO mps_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Te boi bidi augwaliba dagego hwįbaso da, te dagego augwali pobelama, ela mubaso, te hwįbogo augwali mu dolaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Te dage nogo a naga bidigo te bidi sese a naga 100 boi bidi aiyaba elalueibao, te dage 100 bidigo te bidi sese umabo hauwa 10,000 boi bidi aiyaba elalueibao, tama tigidali boi bidi dolaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Te eno dage wiegi yai iliyu, dagebolo eno te wai hauwa menama, te dage genuai hani pedalumainogo ilaibao. Te eno polobadu dage dali te dąų wali bomai po kontrak usu naibao. ");
INSERT INTO mps_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Te nai dabe dagego te gide polobadu kibu bede sali te elalubadi, te nosali kibu beba ma usu naibao. Te elaluali nai bugai te dagego gesi tau yali nai sabo sogo, te nai dagego sąyu, tama te nai muani pesagede dagego gesi nai mueibao. ");
INSERT INTO mps_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Te ena dage tomode bidiyu, te ena be tomode digi bidaibao, te eno dage tudiba me mugobeo. ");
INSERT INTO mps_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Te ena dage tomode biliyu, te ena dagego God bidaibao. Te dage eno we bidi dabe bidaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","“Ena digi ena Genuai Bidi, ena dagego God dao. Polobadu dage te Isipde olo sę ebo bidi bidibaso, eno te kalabus ebo sę togwa sąnama, te dage odasa asai. Eno dage te kalabus yali bidi dabego bogo toga sąwai, te dage kalabus tagalama, te wiegi yai homu pemene eyu asai dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Genuai Bidigo po te tiwai ma wali, “Te dagego eno po sela sąyu, tama dagego te bomai po dabe sela sąbaso da, teda eno dagebolo te dene mabo sę yaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","“Te dagego eno bomai po me eno po dali te tudiba munama, tama eno dage dali te dąų wali bomai kontrak te dagego togwali da, ");
INSERT INTO mps_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","teda eno dagebolo dene maiabo sę e tiwai yaibao. Polo tama eno dage dwai wi mu ilama, te dage te tobage genuai gasi somainogo ilaibao, te tigi posolo mu ilibo gasi, me te dage gedu widaibao, te dagego tigi me dolaibao. Te dagego gi nai da bulaibao, tiali goli dagego te nai ge me sela tugobeo. Mu menio. Te boi bidi dabego naga sela tueibao. ");
INSERT INTO mps_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Te ena digi eno dageba boi bidi yaibao, tama eno te gasa bidi dabego dageba boi hwįagasomainogo elama, te dage aiyaba elalumainogo ilaibao. Tama te bidi dabego dage dali dwai homu mu eyu, augwaligo dage tonalubo sę yaibao. Te boi bidi dabego dage pobeasa asisąbadi goli tagalao, te duga digi odolali wi elama, te wi paibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Tama eno te kolesaga dabego dageba te dwai dene mabo sę ebaso, te tudi, badu nosali dagego eno po wali me pisąbaso da, teda eno te dwai dene mabo sę dageba mu geninaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Te eno dagego hagoma aiyaba mu elalueibao. Te eno tulubage tulubo paliama, te dagego tǫba tulubage me tulugobeo, te tǫ mu wa pelama, te ain tiwai dila pai pedelaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Te nai dabe te gide dabe me hologobeo, te ni dabego du me walogobeo. Te dagego sę dene yali odolali yaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Te tama sęgę dabe dageba pedalubaso, te dagego hagoma idu, te po me odisąbaso da, teda eno dagego te ebo dwai kolesagade homu kone paludama, te eno dageba dwai dene mabo sę me mu ela pidubadi geaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Eno te bulu uni hasa dabe dage tomoba tagala palama, te augwaligo te wai dabe ela muyu, te bulmakau dabe me ela mueibao. Tama tialima, te dagego tǫ kantri sunumide te bidi dabe me bilalugobeo, te dwasianu hani we bidi naga bidaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Eno te tiwai dwai dene mabo sę dageba ebaso, te nosali dagego eno po me odisąma, te dagego enaba hagoma ebo dwai sę me idubaso da, ");
INSERT INTO mps_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","teda eno digi dagego te ebo sęgęde homu kone palama, te eno dage dwai dene mabo sę genugia mu idubadi, te dage posolo dwai mu yaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Dagego eno dąų wali bomai po kontrak togalio, tama dageba te boi bidi dabego hwįabo sę eno ilaibao. Te dage te genuai taun te bomai obo elalubo tomoba sisinigi pelama, te dage bugagia bidiba homu yaibao, tagalao, te eno dwai genuai gasi dabe dageba tagala palama, te dage we bidi hauwa mu isaibao. Te dage dolobo sogo da, teda eno dage te boi bidi dabe augwali nogoba mawaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","“Te eno dagego nai mu sǫą pomainogo yaibao, tama te we dabego augwa iside ulabo nai hauwa meni yaibao, te sia tigi delide nogo si wego nai ulaibao. Te dage tigidaligo te nai dwasianu dwasianu naga selama tueibao, tiali digi te dage nasi me elaludaibao,” Genuai Bidigo te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Eno te sę dabe yali, te dagego hagoma me idubadi geyu, te eno po ma sela sąbaso da, ");
INSERT INTO mps_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","teda eno haliga sębę dwai mu eyu, te eno dagego dwai sę ebo umagia mu wei ponodu, te dageba dwai dene mu madubadi geaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","“Te dage nasi dwai mu ebaso, te duga wai te ogwa me wegi dabe te ela tueibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","“Te eno dwai haliga dageba elama, te dagego tibo god dabego lotu be te bulu dude sę yani te eno dolaibao, te wiegi yai denami ebo hano holobo ofa ebo alta eno alueibao. Te eno dage ela munama, te eno dolali te tibo god piksa daiba sąwaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Te eno dagego taun dabe me lotu be dabe dolaibao, tama eno dagego te ebo ofa dabe homu godolo me egobeo. ");
INSERT INTO mps_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Te eno dagego tǫ mu dolaibao, te dagego boi bidi dabego te tǫ selama bidibo sogo, te augwa sulama, te dwai noma mu saibao. ");
INSERT INTO mps_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Eno digi te boi bidi dabego dageba boi hwįmainogo ilaibao, te eno dage augwaligo te gasa tǫ kantriba tedela palomainogo ilaibao. Te dagego tǫde bidi meniama olo elalu, te taun dabe dolai elalueibao. ");
INSERT INTO mps_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Tialima, dage te boi bidi dabego tǫde bidalubo sogo, dagego te tǫ dabe olo dali elalu, te toma nedueibao. Polobadu dage te tǫde bidaluyu, tama dagego te 7 wabo kibu bede te tǫ toma nomainu ilibeo, eno dagebolo te tama tiao po wali gilama me ebeo. Tialima, te tǫ olo elalubo sogo aga te bugagia toma tueibao, te sogo tǫgo godolo yaibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","“Te dage hani dwasianu naga elalu, te boi hwįbo sogo me isigobeo, te dage boi bidi dabego tǫ kantriba bidigi paibao. Te dage eno wi dwai mu ilaibao, te dagego waligo te ni yabe gele gele dwasianu wabo odobaso da, teda dage odolali wi elama, tama te boi bidi dabego pobebaso wi pabo tiwai yaibao. Te boi bidi dabego pobesąbadi digi, te dage odolali wi pelayu, udabogo duga hasi hodola palama, tula munana paibao. Te boi bidi dabego dage dali hwįbaso da, teda dagego augwali dali me hwįgobeo. ");
INSERT INTO mps_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Tialima, dage te boi dabego tǫde isila paibao. Te augwaligo tǫgo dage aiyaba mu dalubo tiwai yaibao. ");
INSERT INTO mps_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Te dage dwasianu hani dabe te boi bidi augwaligo tǫ kantride bidaibao, te dage deli deli dolama, te dage hani silabo homu yaibao. Magi baso meni, duga digi, me te aya dabe, me wąį nǫų dabego yali sęgęde me duga tigidaligo sęgęde tama tiaibao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Tiali goli, nosali dage te hani dabe te augwa yali sęgę homu kone palama, te augwaligo enaba pusaibao. Augwaligo te tama po waibao, ‘Dena digi me te sęgę siyu, te wąį nǫų dabego me sęgę salio. Dago hagoma elama, te nago po sela sąwai dao.’ ");
INSERT INTO mps_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Dagego hagoma ebaso, tialima eno dageba dwai dene menama, tama dage te duga boi bidi dabego tǫ kantriba tagala palali. Tialima, duga hanigo te hagoma ebo tagalobo sogo te augwa digi elaluama, te augwa yali sęgę dwai dene sobaso da, ");
INSERT INTO mps_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","teda eno te Jekop, me Aisak, me Abraham augwali dali te dąų wali bomai po kontrak homu ma koneaibao, te Kenan tǫ augwa wąį nǫų dabebolo mawaibao po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Tialima, hasia bolo dagego te tǫ tagalai elalueibao, te tǫ odolali elaluama, te bobage sesabi elama, toma neyu elalueibao, te dagego tǫ te olo elalumainogo isąwani te sogoba usu naibao. Te dage sęgę tolama, te dwai dene saibao, magi baso meni, dagego eno bomai po tigidali tudiba munama, te eno po me tigidali sela sąwai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Tiali goli, dage te boi bidi dabego tǫ kantride bidibo sogo, te dage mu tagalisąma, te eno dage tigidali mu me dologobeo. Mu menio. Eno te tiwai egi sogo da, teda eno dage dali te dąų wali bomai po kontrak dąų wali, te siligi da. Tiali goli, ena God, duga Genuai Bidi, eno te tama tiwai kolesaga me egobeo. ");
INSERT INTO mps_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Eno dageba homu koneama, eno te dagego wąį nǫų dabe dali dąų wali bomai po kontrak ma homu kone palaibao. Te bidi dabe eno polobadu te tǫ kantri Isipde selama odasa asali, te gasa tǫ kantri we bidi tigidaligo te eno genuai bomo suali. Eno dage sela asali, te Genuai Bidi ena hani bage pedalumainu yali, ena dage Israelgo God bidainogo yai dao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Te po dabe me te bomai po Genuai Bidigo Mosesbolo te Sainai bulu dude mayu dąų walai dao. Tama agai te po weyu, te Israel dabego tigidali wali piyąo wai dao. ");
INSERT INTO mps_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Genuai Bidigo po Mosesbolo weyu, ");
INSERT INTO mps_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","te Israel dabebolo te tiwai po walao wali, “Te bidi me deli aga po dąų waliyu, te aga enaba mawaibao, ma gasa bidi me we te enabolo mawaibao wai baso da, teda agai te dąų wali po usu nainogo te monego te bidi ma we hasegelainogo eyu, te mone meba pris bidiba mao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","“Te we bidi dabe ma abelabo dąį ilali mone e tiwai elalubao. Te kibu be 20 dąį elama, te kibu be bidi sese sela 60 igi pali bidi, augwaligo te mone 500 kina tama monego hasegeliyu abelao. ");
INSERT INTO mps_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Te wego kibu be bidi sese delide dąį elama te bidi sese selaba dąį igi pali we da, te mone 300 kinago abelao. ");
INSERT INTO mps_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Te bidi kibu be a nagade dąį elama te kibu be bidi sese deliba usu nani bidi da, te mone 200 kinago abelao. Te we kibu be a naga dąį elama te kibu be bidi sese deliba usu nani we da, te mone 100 kinago abelao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","“Te wai ogwago polua delidu te kibu be a naga usu nani wai da, te mone 50 kinago hasegeliyu abelao. Te wegi te polua delidu te nogo a naga kibu beba usu nani wegi da te mone 30 kinago abelao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","“Te kibu be bidi sese sela 60 yali bidi, te 150 kina monego abelao. Te kibu be bidi sese sela 60 yali we da, te 100 kina monego hasegeliyu abelao,” te po wai dao. ");
INSERT INTO mps_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Te tiwai mone muabo po dąų wali bidigo, te aga digi aga ma abelabo mone ma aga abagi abelabo mone me meni baso da, teda te bidi prisba pao. Te prisgo te bidigo mone aiyaba dulama, te prisgo homugo aga muabo homu ebo mone usu nama mueibao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Te bidigo te kibu me deli ena Genuai Bidiba ofa yaibao po dąų wai baso, agai te tobage kibu dabe eno dagebolo ofa yao po wabo kibugo te ofa yao. Te dagego ofa ebo kibu tigidali te eno nai mu dao. ");
INSERT INTO mps_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Tama te bidigo te wiegi yai kibu hasegelama, te dwai kibugo ofa igio. Agai te kibu dwai hasegelama, te wiegi yai kibu ofa igio. Tialima, agai hasegelibaso da, teda te kibu si dali si te ena, Genuai Bidigo dao. ");
INSERT INTO mps_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Te bidi me agai enabolo te wiegi yai isąwai kibu me deli agai enabolo ofa yabo usu meni baso da, teda agai te prisba selasa pao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","“Prisgo te kibu wiegi yai yaliwe ma dwaliwe sulama, agai te mone dąį ilaibao. Tama te mone nogi tagalama, gasa mone dąį me iligio. ");
INSERT INTO mps_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Te bidigo te kibu ma abelabo homu ebaso da, teda agai te mone meba dali te prisgo dąį ilali mone dali sesao. Te prisgo 5 kina dąį ilibaso da, teda agai te mone 6 kinago abelao. Ma, prisgo te mone 10 kina po obaso da, agai te mone 12 kina mobaso usu dao,” wai dao. ");
INSERT INTO mps_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Te bidi me deligo aga be ena Genuai Bidiba maiabo homu ebaso da, teda prisgo te be wiegi yai ma dwai yabowe naga suao, agai digi te bego mone dąį ilao, te prisgo dąį ilali mone me hasegeligio. ");
INSERT INTO mps_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Tama ena Genuai Bidiba te be mani bidigo, te nosali aga be ma abelabo homu ebaso da, teda agai te bego mone usu nama mayu, te gasa me badu dali daganama mao. Te prisgo te bego mone 100 kina dąį ilai baso da, teda te bidigo 120 kina mao. Agai te mone prisba menama, te aga be ma sobaso te usu dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Te bidi me deligo agai tǫ pedai enaba mobaso da, teda prisgo te nisu naga te nai wai bali te tǫde bulugowe naga te osola suao. Te augwaligo te sęgę bidi sese deli 20 kilogram bali bulabo tǫ usu yai baso da, teda te tǫgo mone 100 kina usu dao. ");
INSERT INTO mps_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Tama agai enabolo te mani tǫ te nai dabe wei ma ponabo kibu be yagasobode te hasia wabo kibu bede mobaso da, teda te mone te tiwai elalumainao, te me hasegelamo dao. ");
INSERT INTO mps_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Tialima, agai enabolo mabo tǫ te kibu be meba nosali wabo te genuai kibu be wabo sogo mobaso da, teda prisgo nisu naga kibu be elalubadi yai baso te nedao, te nai dabe wei ma ponabo kibu be nisu naga elalubo koneainogo tiao, tama agai te tǫgo mone aiyaba togaibao. ");
INSERT INTO mps_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Te tǫ enabolo te mani bidi, te aga tǫ ma abelainogo ebaso da, teda agai te monego abelemainao. Te mone prisgo 100 kina dąį ilai baso da, teda te bidigo 120 kina mao. Agai te mone prisba menama, te aga tǫ ma somainogo emainao. ");
INSERT INTO mps_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Te hasia bolo agai te tǫ ena Genuai Bidiba abelesąma, tama agai te tǫ gasa bidiba mawai baso da, teda nosali aga digi ma abelainogo ebaso, usu me egobe dao. ");
INSERT INTO mps_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Tama te nai dabe wei ma ponobo kibu be pedalubo sogo, teda te tǫ abelali bidigo enabolo ma mao. Tama te tǫ ena tǫ sesemane sogo elalua paibao, te we bidi augwalide habu selaibao. Te eno pris augwaliba naga mawaibao,” te po walio. ");
INSERT INTO mps_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Te tǫ me deli bidigo abelai, te aga wąį nǫų dabego tǫ menio, agai te tǫ ena Genuai Bidiba mobaso da, ");
INSERT INTO mps_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","teda te nai dabe wei ma mabo te nisu naga kibu be elalubowe naga te prisgo neda suao. Tama agai mena tama kibu be elalubo usu nama te tǫde mone dąį ilao, te side naga dolo te bidigo te prisgo tǫba mone mao. Tama te mone da ena Genuai Bidigo nai dao. ");
INSERT INTO mps_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Tialima, te nai dabe wei ma ponobo kibu bede, te tǫ sali bidigo te tǫ aga ayaba wei ponama dolo mao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Dagego te eno megi po wali tigidali naigo mone dolo neda suao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Te dagego ofa me deli enaba maiabo homu ebaso da, teda dagego te tigidali kibu me gasa nai dabego te podolali nai dabe me sigio, magi baso meni, te eno nai da po walio. Tagalao, te bulmakau ma sipsipgo te gomunai wai dabe, tigidali te eno dao. ");
INSERT INTO mps_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Tialima, te kibugo gomunai wai dabe te kibu dabego eno gedude me wiegi yai meni baso da, teda duga ma abelagameo. Te prisgo 10 kina dąį ilibaso da, teda dagego agabolo 12 kina mao. Tama bidigo te kibu me abelesąbo homu ebaso da, teda prisgo gasa bidigo abelemainogo elama, te prisgo dąį ilali mone usu nama abelao.” ");
INSERT INTO mps_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Tialima, te bidi me deligo te nai me deli ena Genuai Bidi dolo dąį mu ilali naigo, te gasa sę me igio olama, habu selai baso da, teda agai te nai gasa bidigo abelemainogo me igio, te aga digi me te pris dabede ma abelamuo. Te tagalao, agai bidi me deli, ma we me deli, ma kibu me deli, ma te aga wąį nǫų dabede sali tǫ me deli yai baso da, teda sesemane sogo te ena Genuai Bidigo nai naga elalueibao.” Te po wali. ");
INSERT INTO mps_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“Odao. Te agai bidi ma we enabolo sa muyu dąį ilai baso tagalao, teda agai ma abelainu ebo usu egobeo. Mu meni. Dagego te tiwai mani bidi ma we ela muyu naga yao.” ");
INSERT INTO mps_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Te gide pedalubo nai tigidali, te nai wit wai ma ni du wai da, dagego te nogo si badu dobolama, te me deli badu ena Genuai Bidiba mao. Te nogo si wali nai dagego tubo habu mu selaibao. Te enaduba deligo nai naga dao. ");
INSERT INTO mps_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Te bidi me deligo te naigo meba abelainogo ebaso da, teda agai abelemainao. Te naide mone 5 kina yai baso da, teda agai 6 kinago hasegeliyu abelama, te pris dabeba mao. ");
INSERT INTO mps_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Te nogo si bulmakau me sipsip dabe elalubaso, te me deli eno dao. Dagego te kibu dabe tigidali wasilama, te augwali nedelama, tama te nogo si wali tigidali enabolo mao. ");
INSERT INTO mps_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Te nogo si wali kibu wiegi yai ma dwai baso me tagalao, dagego me hasegeligio. Tialima, dagego hasegelibaso da, teda te nogo si wali kibu dali te hasegelali dali saibao, te si dali si eno nai dao, te dagego ma abelamo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Te po dabe dali te bomai po me Genuai Bidigo Mosesbolo te Sainai bulu dude mawai. Tama agai te po weyu, te Israel dabe augwaligo tigidali wali piyąo po wai dao. ");
INSERT INTO mps_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Te si wabo kibu bede te Israel dabe te Isip bulu taga soali tudi badu nosali, te namba 2 poluago namba 1 dei, tede te Genuai Bidigo Moses dali te nai meni yai bulude te Godigo ugwa bede po miani. ");
INSERT INTO mps_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Genuai Bidigo te e tama po wali, “Nage dali Aron dage sigo te Israel dabego nogi tigidali siąo,” po wali. “Dage sigo tigidali bidi dabe sese tama nedama, tama augwa wąį hani tali tali asęyu yao. ");
INSERT INTO mps_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Te tigidali kibu be 20 yai bidi dabe dali, te kibu be 20 edelai bidi dabe dali, augwali te ami bidi nigabo usu yai bidi dabe dao, tama augwaligo nogi me asęyao. ");
INSERT INTO mps_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Tama dage sigo deli deli bidi wąįde deli deli tobolu bidi sa muyu ela pao, te dage si tau sabo bidi dabe. ");
INSERT INTO mps_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Tama dage si te sę ebo tau sabo bidi dabego nogi e tama dao. Te Ruben hanide da, nago te Sedeurgo ogwa Elisur sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Te Simeon hanide da, nago te Surisadaigo ogwa Selumiel sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Te Juda hanide da, nago te Aminadapgo ogwa Nason sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Te Isakar hanide da, nago Suargo ogwa Netanel sao. ");
INSERT INTO mps_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Te Sebulun hanide da, nago Helongo ogwa Eliap sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Tama te Josepgo wąį hanide da, te Efraim hanide da, nago te Amihutgo ogwa Elisama sagameo. Tama te Manase hanide da, nago te Pedasurgo ogwa Gamaliel sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Te Benjamin hanide da, nago te Gideongo ogwa Abidan sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Te Dan hanide da, nago te Amisadaigo ogwa Ahieser sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Te Aser hanide da, nago te Okrango ogwa Pagiel sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Te Gat hanide da, nago te Duelgo ogwa Eliasap sagameo. ");
INSERT INTO mps_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Te Naptali hanide da, nago te Enango ogwa Ahira sagameo,” te po wai. ");
INSERT INTO mps_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","17","Tama te Mosesgo te Israel we bidi hani tomode te tobolu bidi dabe sa muna silali. Augwali da, te augwa wąį hani polalubo bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Tama te Moses de Aron si me te 20 tobolu bidi dabe, augwaligo te tigidali we bidi sisinagasao po wali, tama te si wabo poluago hasia wabo dei, tede augwali polo sisinagasali. Tama te tobolu bidi dabego te tigidali we bidi dabego nogi, me augwa hani tali tali me nogi asęyu yali. Augwaligo te 20 kibu be yai bidi dabe dali, te 20 kibu be edelai bidi dabe me nedali. ");
INSERT INTO mps_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Te Genuai Bidigo Mosesbolo wali po dolo tama wali pelama tama tiali. Te we bidi te nai meni yai bulu Sainaide bidibadi, Mosesgo augwaligo nogi selama, tama augwaligo nogi lista nigali. ");
INSERT INTO mps_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Augwaligo te bidi dabe te kibu be nogo si sągą si eyu yai bidi dabe me nogi asęyu, me kibu be bidi sese edelai bidi dabego nogi me asęyu yali. Te bage te ami bidi dabe nigabo usu yai bidi dabe dao. Augwaligo te bidi dabego nogi selama, tama augwaligo augwa hani bidi we wai nanide nogi lista nigilama tagalali. Te Rubengo hanide gagalali, te Jekopgo gomunai ogwade gagalali. Te bidi dabego namba e tama dao. Te Rubengo hani bidi namba te 46,500 bidi tama bidali. Te Simeongo hani bidi namba te 59,300 bidi tama bidali. Te Gat hani bidi namba te 45,650 bidi tama bidali. Te Juda hani bidi namba te 74,600 bidi tama bidali. Te Isakar hani bidi namba te 54,400 bidi tama bidali. Te Sebulun hani bidi namba te 57,400 bidi tama bidali. Te Efraim hani bidi namba te 40,500 bidi tama bidali. Te Manase hani bidi namba te 32,200 bidi tama bidali. Te Benjamin hani bidi namba te 35,400 bidi tama bidali. Te Dan hani bidi namba te 62,700 bidi tama bidali. Te Aser hani bidi namba te 41,500 bidi tama bidali. Te Naptali hani bidi namba te 53,400 bidi tama bidali. Te tigidali te ami bidi nigabo usu yai bidi dabe namba te 603,550 bidi tama bidali. ");
INSERT INTO mps_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Te augwaligo te bidi dabego nogi asębo sogo, augwaligo te Livai hani bidi dabego nogi te nogi listade asębeo. ");
INSERT INTO mps_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Te magi baso meni, Genuai Bidigo Mosesbolo e tama po wali, ");
INSERT INTO mps_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Nago te bidi dabego nogi sabo sogo, nago te Livai hani dabego nogi asęnamuo,” po wali. ");
INSERT INTO mps_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","“Te menio. Nago te Livai dabebolo nago sę menama, tama augwali eno name ugwago nigali lotu be tonalubo sę eyu, me augwaligo eno be tomode munalubo nai tonalubo sę emainao, tama augwali tede sę eyu emainao. Tama dage gasaba bidigi pabo sogo augwaligo te name ugwago nigali lotu be dali, te be tomode munalubo nai sese dali tolasa pabo sę eyu emainao. Tama augwaligo augwa ugwa be eno ugwa be bagulama sę emainao. ");
INSERT INTO mps_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Te dagego te pesage nigilama, tama gasaba gudasa painogo, te ugwa be hųgiasa painogo da, teda te Livai dabego naga te ugwa be hųginama, tama te bede mubo nai dabe dali augwaligo naga sela pomainao. Tama dagego gesi noma pesage nigibo sogo da, te Livai dabego naga te eno ugwa lotu be sę emainao. Tama gasa olo bidi dabe teba pąba me asobo si da, dagego augwali ela muao. ");
INSERT INTO mps_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Te gasa Israel we bidi augwaligo augwa hani bagego plak ugwa dodolali madi augwaligo be tede naga sese peyu emainao, te augwa hani mu naga sisinibo madi. ");
INSERT INTO mps_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Tiali goli, te Livai dabego te ugwa be te eno ugwa be sę yalubo bagulama naga sę emainao, te augwaligo eno be tonaluyu emainogo. Tiyu, bidi me deli te be pąba asai madi ena sębę ilama ebode, eno dage Israel dabe sese dolidali weyu,” Genuai Bidigo te po wai. ");
INSERT INTO mps_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Tama te Mosesgo te Israel dabebolo Godigo te Moses agabolo wali po sese pusali, tama augwaligo wali pali. ");
INSERT INTO mps_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Godigo Moses de Aron sibolo te tama po wali, ");
INSERT INTO mps_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Te Israel dabe augwaligo gesi noma pesage nigigi pabo sogo da, te deli deli bidi aga ugwa be te aga hani mugo plak ugwa walalubo pagede mu sę emainao. Augwaligo name ugwa be eno name ugwa lotu be bagulama sese pomainao. Tiali goli, augwaligo eno name ugwa be pąde mu sę emainu elamuo. Menio. Augwaligo be digibulu ganama sę emainao.” ");
INSERT INTO mps_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","“Te giliga asobo badu bidi hani sela te Juda wąį hanigo plak pąde sisinalubo madi dao. Augwaligo te augwa hani tobolu bidi dologode naga bidiyu ebo dao. Te Juda wąį hanigo tobolu bidi te Aminadapgo ogwa Nason dao. Te Juda hani bidi da, te 74,600 bidi dabe tama bidibao. Te Isakar hani bidi dabego tobolu bidi da, te Suargo ogwa Netanel dao. Te Isakar hani bidi te 54,400 bidi tama bidibao, tama augwali te Juda hani bogo badu bidaibao. Te Sebulun hani tobolu bidi da, te Helongo ogwa Eliap dao. Te Sebulun hani bidi te 57,400 bidi tama bidibao, tama augwali te Isakar hani pąde bidaibao. Te bidi hani sela tama namba te 186,400 bidi tama elalubao. Tama te gasaba pabo sogo te hani sela bolo polasa pomainao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","“Te Godigo ugwa lotu be saut badu te bidi hani sela te Ruben hanigo plak pagede sisinalubo dao. Augwali te augwa hanigo tobolu bidi dologode naga bidimainao. Te Ruben hanigo tobolu bidi te Sedeurgo ogwa Elisur dao. Te Ruben hanigo te 46,500 bidi tama elalubao. Te Simeon hanigo tobolu bidi da, te Surisadaigo ogwa Selumiel dao. Te Simeon hani bidi da, te 59,300 bidi tama bidibao. Tama augwali te Ruben hani bogo badu bidaibao. Te Gat hanigo tobolu bidi da, te Ruelgo ogwa Eliasap dao. Te Gat hani bidi da, te 45,650 bidi tama bidibao. Tama augwali te Simeon hani bogo badu bidaibao. Te bidi hani selago bidi dabe namba deliba sisinama, te 151,450 bidi tama bidali. Te gasaba pabo sogo da, te hani sela te polasa pabo hani wali tama pomainao.” ");
INSERT INTO mps_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Augwali te pesage nigilama bidali taga peyu, gasaba pabo sogo da, te Juda hani wąį dabe bolo polasa te gasa hani tudiba ilama, augwali bolo polasa pomainao, te gasa hani dabego te augwa dolo nogo badu bidibo bage augwa plak ugwa dali polasa yai digi, te meba hani nosali tama peyu emainao. Tama te Livai hani dabego te Godigo ugwa be, me te ugwa be tomode munalubo nai dabe, augwaligo selasa peyu, augwali te gasa hani dabe tomode mu elama tama peyu emainao. Te a naga olama, me badu nogo deli bidi hani polasa peyu, tama te Livai hani tomode elalu, me a naga olama, me badu nogo deli bidi hani nosali elama, tama pomainao.” ");
INSERT INTO mps_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","“Te giliga dega sabo badu te bidi hani sela te Efraim wąį hanigo plak pąde sisinalubo, tama te bage augwali te augwa hani tobolu bidi dologode naga bidimainao. Te Efraim hanigo tobolu bidi te Amihutgo ogwa Elisama dao. Te Efraim hani bidi te 40,500 bidi tama bidibao. Te Manase hanigo tobolu bidi te Pedasurgo ogwa Gamaliel dao. Te Manase hani bidi te 32,200 bidi dabe tama bidibao. Tama augwali te Efraim hani bogo badude bidaibao. Te Benjamin hanigo tobolu bidi da, te Gideongo ogwa Abidan dao. Te Benjamin hani bidi te 35,400 bidi dabe tama bidibao. Tama augwali te Manase hani bogo badude bidaibao. Te bidi hani selago nedali bidi namba deliba taluyu, te 108,100 bidi dabe tama elalubao. Tama te gasaba pabo sogo da, te bidi hani sela te Livai dabe wali nosali tama peyu yao.” ");
INSERT INTO mps_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","“Te not badu te bidi hani dabe te Dan hanigo plak pąba sisinama bidibo dao, te augwali te augwa tobolu bidi dologode bidalumainao. Te Dan hanigo tobolu bidi te Amisadaigo ogwa Ahieser dao. Te Dan hani bidi te 62,700 bidi dabe tama bidibao. Te Aser hanigo tobolu bidi te Okrango ogwa Pagiel dao. Tama te Aser hani bidi te 41,500 bidi dabe tama bidibao. Tama augwali te Dan hani bogo badude bidaibao. Te Naptali hanigo tobolu bidi te Enango ogwa Ahira dao. Tama te Naptali hani bidi te 53,400 bidi dabe tama bidibao. Tama augwali te Aser hani bogo badude bidaibao. Tama te bidi hani selago nedali bidi dabe te taluyu, te 157,600 bidi dabe tama elalubao. Tama te gasaba pabo sogo, te hani sela augwali te nosali mu elama peyu emainao.” Godigo te po wai dao. ");
INSERT INTO mps_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Te tigidali Israel dabe namba sese deliba taluyu, te 603,550 bidi dabe tama elaluali. ");
INSERT INTO mps_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tiali goli, augwaligo te Genuai Bidigo po wali peyu, augwaligo te Livai hani te gasa Israel dabe dali me nedebeo. Te Livai hani bage te tedali dao. ");
INSERT INTO mps_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Te tama tialima, te Israel dabe augwaligo te Genuai Bidigo te Mosesbolo augwaligo yao wali sę dabe naga wali peyu yali. Tama deli deli bidigo aga ugwa be te augwa plak pąde sę eyu ela pali. Tama augwali gasaba pabo sogo, augwaligo augwa hani dabe mu wali naga peyu yali. ");
INSERT INTO mps_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Te Genuai Bidigo te Moses dali te bulu du Sainaide po wali sogo, te Aron de Moses sigo wai puluba e tama elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Arongo te ogwa me si me si tama elaluali. Agai te gomunai ogwa te Nadap dao, te tudi badu Abihu, te tudi badu te Eleasar, te tudi badu te Itamar dao. ");
INSERT INTO mps_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Mosesgo augwaligo tobolude wel gelama, tama augwali te pris bidi naga nigilali. ");
INSERT INTO mps_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Tiali goli, augwali te nai meni yai bulu Sainaide bidiyu, te Nadap de Abihu augwali sigo te wiegi yai denami ebo hano holobo nai selama, tama Genuai Bidibolo te ofa tiwai mani. Te Genuai Bidi agai mao po wasiąbadi, tama tibaso Genuai Bidigo augwali si elama isilali. Tama augwali sigo wai bǫų dabe meni yai dao. Tialima, te Eleasar de Itamar sigo naga te pris sę yai dao, te Aron augwa aya bidibadi. ");
INSERT INTO mps_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Te Genuai Bidigo Mosesbolo e tama po walali, ");
INSERT INTO mps_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Te Livai dabego hani odasa aselama, tama augwali te pris Arongo sę bidi tiwai sa muao. ");
INSERT INTO mps_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Augwali eno name ugwa bede sę eyu, me pris dabe tau sabo sę eyu, me te we bidi tau sabo sę eyu emainao. ");
INSERT INTO mps_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Augwaligo eno name ugwa lotu bede doado bage dabe bugagia tonaluyu emainao. Te eno Israel dabebolo emainu wali tiwai. ");
INSERT INTO mps_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Te Livai dabe augwaligo te sę deli naga dao. Augwali te Aron dali aga ogwa dabego sę tigidali sogo emainao. ");
INSERT INTO mps_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Nago te Aron me aga ogwa dabe augwaligo naga te pris sę emainogo sa muao. Tiali te gasa bidi dabego me te pris sę yainogo ebaso da, teda dagego aga ela muiąo,” wali. ");
INSERT INTO mps_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Tama Genuai Bidigo Moses e tama tiwai po walali, ");
INSERT INTO mps_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Megi eno te Livai hani te ena hani mu tiwai sa megi mubao. Te eno te Isip dabego gomunai ogwa dabe ela muani sogo, eno te dagego gomunai wai dabe me, te bulmakau sipsip meme dabego gomunai wai dabe me, eno sa muai dao. Tama augwali sese ena mu dao po wai dao. Tiali goli, megi da, eno te gomunai ogomani dabe me sogobeo. Menio. Te Livai dabego augwali hasegelali, tama te Livai dabe te ena mu dao. Ena Genuai Bidi, eno po polo wali.” ");
INSERT INTO mps_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Te nai meni yai bulu Sainaide Godigo Mosesbolo te po wai, ");
INSERT INTO mps_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Te Livai dabe nedama, tama augwa we wai tali tali augwa hanide lista nigao,” po wali. “Tama nago te augwaligo ogwa wai dabe te polua deli polo yai waide gagalasa, tama tigidali ogwa me bidi dabego nogi me sao,” te po wali. ");
INSERT INTO mps_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Tama te Mosesgo te Genuai Bidigo wali po selama, tama tiwai yali. ");
INSERT INTO mps_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Te Livaigo ogwa sela elaluali. Te Gerson, me Kohat, me Merari, tama dao. ");
INSERT INTO mps_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Te Gersongo ogomani nogi te e tama dao, te Lipni me Simei dao. ");
INSERT INTO mps_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Te Kohatgo ogomani nogi e tama dao, te Amram, me Ishar, me Hebron, me Usiel, tama dao. ");
INSERT INTO mps_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Te Merarigo ogomani nogi da e tama dao, te Mali me Musi si dao. Te Livai dabego hani wąį nogi te e tobage nogi elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gersongo hanigo bidi hani te si digi tama elaluali, te Lipni me Simei hani. ");
INSERT INTO mps_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Augwaligo te bidi dabe dali te ogwa dabe te polua deli polo yai wai dabede gagalasa nedama, tama te namba te 7,500 tama elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Te hani wąįgo be dabe te name ugwa lotu be tudi badude te giliga pabo badu elalumainao, te Godigo be elalubo tǫ sesegede. ");
INSERT INTO mps_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Tama Eliasap, te Laelgo ogwa, te hanigo tobolu bidi dao. ");
INSERT INTO mps_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Augwaligo te Godigo ugwa be tonalubo sę elaluyu, me te name be ugwadu halubo nai dabe tonalubo sę elaluali, me te sunumi palibo name ugwa me tonaluyu, ");
INSERT INTO mps_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","me te alta sai, me te ugwa be bagulubo name ugwa dabe tonalubo sę eyu, me te name ugwa obo sunumi palibo name ugwa tonaluyu yali. Augwaligo te nai dabe tonalubo sę naga elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Te Kohat hani wai dabe te me si me si elaluali. Augwali te Amram, me Ishar, me Hebron, me Usiel tama. ");
INSERT INTO mps_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Te augwaligo bidi dabe dali te ogwa dabe te polua deli polo yai wai dabede gagalasa, ugwaba iguluyu nedama, te 8,300 tama elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Te hani augwali te name ugwa be te saut badu augwaligo name ugwa be nani elama bidaluyu emainao. ");
INSERT INTO mps_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Tama augwaligo tobolu bidi te Usielgo ogwa Elisafan dao. ");
INSERT INTO mps_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Augwaligo Godigo Dąų Wali Bomai Po Munalubo Halobage me, tebol sai me, lam tolalubo nai me, alta si me, genuai pou me, plet dabe te pris bidi dabego te habu selai te habu badu me, te habu selai te be habu palibo name ugwa me, tama tonalubo sę ebo dao. ");
INSERT INTO mps_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Te pris bidi Arongo ogwa Eleasar te tigidali Livai dabego tobolu bidi dao. Agai te bidi dabe te Godigo be tomode sę ebo bidi dabe tonalubo dao. ");
INSERT INTO mps_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Te Merari hanigo aga hani si elaluali. Te augwali te Mali dabe me Musi dabe, tama dao. ");
INSERT INTO mps_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Augwaligo bidi dabe dali te wai ogwa dabe te polua deli polo yai ma ugwaba igulali ogwa dabe me te namba te 6,200 tama usu nani. ");
INSERT INTO mps_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Te Abihailgo ogwa Suriel te augwaligo tobolu bidi dao. Tiali tama, te hani augwaligo name ugwa be nani te Godigo ugwa be te not badu augwaligo be nani emainao. ");
INSERT INTO mps_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Augwaligo te ugwa bego dili tonalubo sę elaluali. Augwaligo te be ni pos, me te pos ni tulubo halobage tonalubo sę eyu, me te pos ni tuabo te bobobage ni dabe me, te meba te be dili tolalubo doado bage dabe me tonalubo sę ebo dao. Tama augwaligo te nai dabe naga tonalubo sę emainao. ");
INSERT INTO mps_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Te me augwaligo te ugwa be mesalo bagulubo obo pos ni dabe, me te pos ni tulubo te halobage dabe me tonalubo sę emainao. Me te brasgo nigai bobobage nil dabe, me te baklain bono me tonalubo sę emainao, te name ugwa be bomo elama kegaluabo. ");
INSERT INTO mps_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses me Aron si augwa wai puluba dabe dali augwaligo be Godigo name ugwa be gedu dolo mu dodolama muani, te giliga asobo badu. Te hani augwali deli naga te habu selalubo te be habuba pelama, tama augwaligo te haniani sę eyu, me te we bidi tau sabo ofa nai mayu yali. Ma, te sę gasa hani mebago ebaso da, teda Israel dabe augwaligo aga ela isilimainao. ");
INSERT INTO mps_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Te Livai hani bidigo namba te 22,000 bidi dabe tama usu nama elaluali. Augwaligo tigidali bidi dabe me, tigidali ogwa dabe me, te tigidali ogwa wai dabe te polua deli polo yai gagalasa, ugwaba igulali te genuai ogwa bidiba usu nani, te me augwaligo nedali. ");
INSERT INTO mps_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Tama Genuai Bidigo Mosesbolo walali, “Te dage Israel dabego gomunai ogwa dabe te tigidali te eno naga dao. Tama tibaso, nago te tigidali gomunai ogwa dabe nogi sao, augwali polua deli polo yai dabede gagalasa, tama te genuai ogwa bidiba usu nama pao. ");
INSERT INTO mps_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tiali goli, eno te bage hasegelama, tama te bidi dabe bidimainu sula tagaliyu, tama eno te Livai dabe naga saibao. Te Genuai Bidi ena hani tiwai mu yaibao. Te me ma, te Livai dabego gomunai kau kibu omai dabe eno siyu, te we bidigo gomunai kau kibu omai dabe tagalaibao. Ena da, ena Genuai Bidi dao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Tama Mosesgo Genuai Bidigo po wali peyu, te te Israel dabede tigidali gomunai bidi dabe dali, te ogomani dali, ");
INSERT INTO mps_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","te polua deli edelai ogwa dabe me nedali, te 22,273 tama elaluali. ");
INSERT INTO mps_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tama Genuai Bidigo Mosesbolo ma weyu e tama po wali, ");
INSERT INTO mps_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Megi da, nago te Livai dabe tigidali enabolo mao, te Israel dabego gomunai bidi dabe ogomani hasegeleyu, tama te Livai dabe te eno hani mu bidaibao. Tama augwaligo kau kibu ena mayu, tama augwaligo te Israel dabego gomunai kau kibu hasegelaibao. ");
INSERT INTO mps_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Te Israel dabego gomunai bidi dabego te Livai dabe te 273 nambago augwali edelali, tama tibaso dagego te bidi dabe ma abela sao, te 273 bidi dabe. ");
INSERT INTO mps_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Nago te silva mone ge a naga, a naga, tama sesa pao, te augwaligo deli deli bidi dabede, te augwali ma abelama siyu yao. ");
INSERT INTO mps_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tama te mone te Araon aga ogomani dali augwalibolo mao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","51","Tialima, Mosesgo Genuai Bidigo te sę yao wali po wali peyu, te deli deli ogwa dabede te mone siyu, te 13,650 kina selama, tama te mone te Aron me aga ogwa dabe augwalibolo te mone mani. ");
INSERT INTO mps_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Genuai Bidigo Moses de Aron sibolo te po wai, ");
INSERT INTO mps_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Te Livai genuai bidi hani bugulama, tama te Kohat hani bidi dabego nogi sao. ");
INSERT INTO mps_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Dagego te e tobage Kohat hani bidi dabego nogi sao, te augwaligo kibu be te 30 dąį gagalasa, tama te kibu be 50 te dąįba usu nagasobo bage, te augwaligo nogi sao. Te gesi ogwa bidi dali, te monu dabe dali si, te tagalao. Te nogi sali bidi augwali te eno name ugwa bede sę yabo usu yai bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Augwaligo sę te Tedali Gasagi Yai Mu Be Habu tomode elalubo doado bage dabe tonalubo sę ebo dao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Tama Genuai Bidigo te po Mosesbolo mani. Agai te po wali, “Te Israel dabego te bidibo pesage taga peyu, gasaba painogo da, teda Aron aga ogwa dabe dali augwali eno ugwa be tomoba tula pelama, tama augwaligo te eno Dąų Wali Bomai Po kontrak elalubo halobage pąde walobo moni ugwa name selama, tama te halobage halumainao. ");
INSERT INTO mps_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Tama me augwaligo te wiegi yai tamu węde bidibo sikau sabeago belama, tama me augwaligo wiegi yai sisi name ugwa belama, te halobage haluao. Te tigidali tama mesegeliyu, tama te ni dage si te gol ring dedage si elalubo tedu palama, tolabo nigilao.” ");
INSERT INTO mps_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Tama augwaligo enabolo mani bret mubo tebol sai te sisi dagalu yai name ugwago halumainao, te ena Genuai Bidibolo mani nai. Tama augwaligo te pou me, plet me, te wiegi yai denami holobo hano nai dabe augwaligo somainao, me te gasa ofa ebo nai me, tama te nai dabe sese te sisi name ugwa daide muao. Tama tigidali sogo bret name te name ugwade munalumainao. ");
INSERT INTO mps_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Tama augwaligo te nai dabe sese te bedeba name ugwa me deligo belemainao. Tama tamu węde sikau sabea wiegi yaigo te bedeba ugwa name belemainao, tama te tebol tolabo ni dage si te ring tomoba mumainao.” ");
INSERT INTO mps_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Tama augwaligo te lam dabe tolalubo nai me, te lam dabe me, te lam wik me, te sisi dulu bulubo dwasianu plet me, te oliv wel bubo botol, te sisi dagalu yai name ugwago belao. ");
INSERT INTO mps_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Tama augwaligo te tamu węde bidibo sikau sabea wiegi yai me selama, tego tomagelama, tama tolabo naiba me muao.” ");
INSERT INTO mps_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Nosali augwaligo gol alta sisi dagalu yai name ugwago tomagelao, tama te ugwa te tamu węde sikau sabea wiegi yaigo tomagelao, tama te alta tolabo te ring dedagede te ni dage muao, te alta tolabo.” ");
INSERT INTO mps_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Tama augwaligo te dis pou dabe te pris bidi dabe te Tedali Gasagi Yai Be Habu badu elalubo te pou doado bage dabe selama, tama sisi dagalu yai ugwago belama, tama tamu węde sikau sabea wiegi yaigo belama, tama tolabo nai tomoba muao.” ");
INSERT INTO mps_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Tama augwaligo te brasgo nigai alta saide munalubo te sisi dulu dabe sela sąnama, tama te alta te bedeba name ugwa belao. ");
INSERT INTO mps_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Tama augwaligo te pris bidi dabego te alta saide sę eyu sabilibo nai dabe sese sao. Te e tama nai dabe, te pou dabe te isi mubo dabe me, te mi enebo yaga dabe me, dwasianu savol dabe me, te dwasianu ofa ebo nai kaneme sabo dwasianu plet dabe sao. Tama augwaligo te nai dabe te tamu węde bidibo sikau sabeago belama, tama te alta saiba munama, tama te alta tolabo ni dage si tolabo muao.” ");
INSERT INTO mps_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Te Kohat hanigo te nai dabe tolobo sę elalubao, te eno name ugwa be tomode elalubo nai dabe. Tiali goli, augwaligo te nai dabe nogo toumainu elamo. Ma, augwaligo nogo tuali da, teda eno augwali ela isilaibao. Tialima, Aron aga ogomani dali augwaligo te ugwa be tomode mubo doado bage bugagia tomagelama, tama te gasaba gudasa peyu yao. Tama nosali te Kohat dabego sagaselama, tolasa peyu emainao. Te da, te Kohat dabego sę dao. Te sę augwaligo tigidali sogo gasaba gudasa painogo, te sę naga eyu emainao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Te pris bidi Arongo ogwa Eleasargo te name ugwa be, me lam wel, me te pris bidi sa mubo te wel me, te wiegi yai denami ebo pauda me, te wit ofa nai dabe, tama agai tonalumainao. Me agai eno bede munalubo nai dabe sese me agai tonalumainao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Tama Genuai Bidigo Moses de Aron sibolo e tama tiwai po wali, ");
INSERT INTO mps_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“Te Kohat hani augwali eno doado bage munaluboba pąba asobo si da, dagego augwali bugagia tonaluao. Tiyu, augwaligo dwasianu sę me geda muai digi, eno augwali ela muidalio. Tama tialima, Aron aga ogwa dabe dali augwali te be tomoba bolo pelama, tama te Kohat hani dabe deli deligo sę bolo yao, tama augwalibolo mena nai dabe augwaligo tolabo po walao. ");
INSERT INTO mps_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Tiali goli, te Kohat dabe augwali te tomoba odolali pelama, te pris dabego eno doado bage dabe dodolodubadi sugi pali da, teda eno augwali elama isilaibao,” te po wai. ");
INSERT INTO mps_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Genuai Bidigo Mosesbolo wali, ");
INSERT INTO mps_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Te Gerson dabe augwa hani dabe nogi sao,” po wali, “te Livai hani dabego deli kaneme bugwai dabe. ");
INSERT INTO mps_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Dagego te e tobage Gerson hani bidi dabego nogi sao, te augwaligo kibu be te 30 dąį gagalasa, tama te kibu be 50 teba usu nagasobo bage, te augwaligo nogi sao. Te gesi bidi dali, monu dabe dali si te tagalao. Tama te nogi sai bidi dabe te augwali eno name ugwa be tomode sę yabo usu yai bidi dabe dao.” ");
INSERT INTO mps_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Augwaligo e tama nai dabe tolabo sę elalubao. ");
INSERT INTO mps_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Te da te name ugwa bego name ugwa dabe me, te namba wan walobo haluali genuai ugwa, me namba 2 walobo haluali genuai name ugwa me, te me augwaligo wiegi yai tamu węde sikau sabeago haluali te me, me te sunumi palibo te genuai name ugwa me, ");
INSERT INTO mps_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","me te obo nigabo name ugwa me, me te name ugwa be bagulali baklain bono me, alta me, obo ebo genuai name ugwa, te sunumi paibo name ugwa me, te ugwa be dąų walobo te dwasianu nai dabe me, te obo ebo nai dabe me, augwaligo somainao. Te Gerson dabego te doado bage dabe dodolama, tolobo sę tigidali elalubao. ");
INSERT INTO mps_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aron aga ogwa dabe dali augwaligo te Gerson dabego ebo sę me tonaluyu, me te Gerson dabego tolabo doado bage dabe ola mayu yao. ");
INSERT INTO mps_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Te Gerson hani bage augwaligo te sę te ugwa bede emainao. Tama te pris Arongo ogwa Itamargo augwaligo te sę tonalumainao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Genuai Bidigo Mosesbolo “Te Livai hanide Merari hanigo deli kaneme dabe me nogi sao,” po wali. ");
INSERT INTO mps_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","“Tama dagego te e tobage Merari hani bidi dabego nogi sao, te augwaligo kibu be te 30 dąį gagalasa, tama te kibu be 50 teba usu nagasobo bage, te augwaligo nogi sao. Te gesi bidi dali monu dabe dali si te tagalao. Te nogi sali bidi augwali te eno ugwa lotu be tomode sę yabo usu yai bidi dabe dao. ");
INSERT INTO mps_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Augwaligo te ugwa be pos ni tolabo sę elalubao, me te be paibo ni name dabe me, me ugwa be te pos ni tulubo halobage dabe me, ");
INSERT INTO mps_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","me te ugwa be mesalo bagualubo pos ni dabe, me te pos ni dąų walobo halobage dabe me, te bobobage brasgo nigai nil dabe, te obo dąų walobo te nil dabe, me baklain te obo ni dąų walobo me, te meba obo dąų walobo nai dabe me, tama te pris dabego deli deli bidi dabe augwaligo tolabo nai dabe ola mayu yao. ");
INSERT INTO mps_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Te Merari hani augwaligo te ugwa be augwaligo te sę emainao. Tama pris Arongo ogwa Itamargo augwaligo te sę tonalumainao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Moses me Aron me te we bidigo tobolu bidi dabe augwaligo Genuai Bidigo po wali peyu, tama augwaligo te Livai hani selade bidi dabego nogi sali. Augwali te Kohat dabe, me Gerson dabe, me Merari dabe, tama dao. Tama augwaligo augwa hani me augwa deli kaneme bagego nogi selama, lista nigali. Augwaligo te bidi dabe te kibu be 30 elama 50 kibu be tama yai bidi dabego nogi augwaligo sali, te augwali te Godigo ugwa bede sę yabo usu yai bidi dabe. Augwaligo namba e tama tiwai dao, te Kohat dabego te 2,750 bidi elaluali, me te Gerson dabe te 2,630 bidi elaluali, me te Merari dabe te 3,200 bidi tama elaluali. Te bidi dabe sesego namba te 8,580 tama dao. ");
INSERT INTO mps_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Augwaligo te Genuai Bidigo Mosesbolo te wali yali gilama, augwaligo tigidali bidigo nogi sali. Tama Genuai Bidigo deli deli Livai dabego sę Mosesbolo magi ilao po wali. Augwaligo te Godigo ugwa bede sę eyu, me augwaligo te ugwa bede nai dabe tolobo sę yao, Mosesgo te po polo odama, te Godigo wali po wali pali, te agabolo wali yali gilama. ");
INSERT INTO mps_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Genuai Bidigo Mosesbolo e tama tiwai po walali, ");
INSERT INTO mps_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Te Israel dabebolo te po pusao, te oiyabe yai bidi dabe me, te kenide keni wę bole ebo bidi dabe buluba tagala palao, me tigide wę me te kaneme augwaligo tigide pedalubaso, me te bidi isaide nogo tuali bidi dabe me, te tobage we bidi eno gedude wiegi yai menio. Tama augwali te dwai augwa tigide elaludubadi, te bidibo pesage nigilama, bidibo pesage taga pelama, digibulu gana pomainu yao. ");
INSERT INTO mps_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ena te eno we bidi bidalubo pesagede ena me tede bidibo dao, tama tialima, nago te eno gedude dolo isąwai we me bidi me te dįą siyu, te buluba tagala palao. Tiyu, augwaligo te bidi bidibo pesage eno gedude meda ilabuo,” wali. ");
INSERT INTO mps_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Tama te Israel dabego Genuai Bidigo Mosesbolo wali po wali dolo tama yali, tama augwaligo te tobage we bidi dįą selama, te bidi dabe bidalubo pesagede buluba tagala palali. ");
INSERT INTO mps_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Tama Genuai Bidigo Mosesbolo ");
INSERT INTO mps_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","e tama tiwai po te Israel dabebolo pusa mao po wali. Agai e tama po wali, “Te bidi me we deligo ena tudiba sąnama, tama agai gasa bidi me we dali dwai kolesaga ebaso da, ");
INSERT INTO mps_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","teda agai aga yali dwai kolesaga wei ponoyu abelemainao, te sęgę sela sąmainu yao. E tama tiwai yao. Agai te aga abagigo te 5 kina wi sobaso da, teda agai te 5 kina ma wei ponoyu, tama me wan kina me manao. ");
INSERT INTO mps_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Tiali goli, te mone sabo bidi isai baso me, ma aga ama dabe me meni baso, ma aga ogwa meni baso da, teda te mone mabo bidigo ena Genuai Bidibolo momainao, tama te pris bidi dabego somainao. Tama me agai sipsip kibu omaigo ofa nai menama, aga dwai sęgę sela sąmainao. ");
INSERT INTO mps_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Tama me te Israel dabego wiegi yai nai seselama, enaba sesebaso da, teda te pris dabego augwaligo nogode saibao. ");
INSERT INTO mps_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Te tigidali ofa mabo nai dabe te pris bidi me deliba mobaso da, teda te pris bidi aga somainao,” wali. ");
INSERT INTO mps_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","14","Te Genuai Bidigo Mosesbolo te po te Israel dabebolo mao po wali, Genuai Bidigo e tama po wali, “Te bidi me aga homugo agai we te gasa bidi dali piali homu ebaso, tama te we eno gedude dwai meda yai tiwai pedalubaso me, tama te bidigo konesąma ebaso, te mu po yaliwe, ma tibo po yaliwe konesąma elama, me ma te wego pusisąma eyu, tama me gasa wego me bidigo me susą ebaso, tiali goli bidigo aga we dali dwai homu ebaso da, ");
INSERT INTO mps_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","teda te bidigo aga we te pris bidi pageba odasa pao. Tama me, te bidigo te 1 kilogram plaua te rais baligo nigai, te ofa nai tiwai sela pao. Tiali goli, agai oliv wel te ofa naiba gelamuo, me agai te wiegi yai denami holobo pauda me teba me gelamuo, magi baso meni, te ofa da te bidigo homugo aga wego dwai kolesaga yaliwe homu ebo ofa dao. Teda te agai ofa yali te augwaligo konemainogo, te wego te dwai kolesaga yaliwe ma meniwe, augwaligo konemainogo,” wali. ");
INSERT INTO mps_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Teda te pris bidigo te we eno geduba dodolagasao, ena Genuai Bidi, te alta sai pagede. ");
INSERT INTO mps_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Tama te pris bidigo te habu selai wę te tǫgo nigai seneba gelao, tama aga eno ugw