﻿USE sofia;
DROP TABLE IF EXISTS sofia.mpmNT_vpl;
CREATE TABLE mpmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mpmNT_vpl WRITE;
INSERT INTO mpmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jaꞌa kuu ɨɨn lista taka yɨvɨ ni kikoyo nuu ñuyɨvɨ na janaꞌan jiin Cristo Jesús, ja ni kuu ya jnaꞌan David jiin Abraham. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ni kuu tata Isaac, ti Isaac ni kuu tata Jacob. Jacob ni kuu tata Judá jiin uu ga ñani da. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ni kuu tata Fares jiin Zara, ti nana da ni kuu Tamar. Fares ni kuu tata Esrom, ti Esrom ni kuu tata Aram. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ni kuu tata Aminadab, Aminadab ni kuu tata Naasón, Naasón ni kuu tata Salmón. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ni kuu tata Booz, ti nana da ni kuu Rahab. Booz ni kuu tata Obed, ti nana da ni kuu Rut. Obed ni kuu tata Isaí. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ni kuu tata rey David, ti rey nación Israel ja ni nani David jiin ñasɨꞌɨ Urías, ni ka kuu tata Salomón, ko ja ni jiꞌi Urías sa ni kaku Salomón. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ni kuu tata Roboam, Roboam ni kuu tata Abías, Abías ni kuu tata Asa. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ni kuu tata Josafat, Josafat ni kuu tata Joram, Joram ni kuu tata Uzías. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ni kuu tata Jotam, ja ni kuu tata Acaz, ti Acaz ni kuu tata Ezequías. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ni kuu tata Manasés ja ni kuu tata Amón, ti Amón ni kuu tata Josías. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ni kuu tata Jeconías jiin uu ga ñani da. Ti kuiya yukan ni kaꞌiin yɨvɨ ñuu Israel presu nuu yɨvɨ ñuu Babilonia. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yukan na ti Jeconías ni kuu tata Salatiel, Salatiel ni kuu tata Zorobabel, ");
INSERT INTO mpmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ni kuu tata Abiud, Abiud ni kuu tata Eliaquim, ti Eliaquim ni kuu tata Azor. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ni kuu tata Sadoc, Sadoc ni kuu tata Aquim, Aquim ni kuu tata Eliud. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ni kuu tata Eleazar, Eleazar ni kuu tata Matán, ja ni kuu tata Jacob. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ni kuu tata José, chaa ni kuu yɨɨ María. Ti María ni kuu nana Jesús ja nani Cristo, ni taji Yandios ja ndiso ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ja yukan kuu ja undi uxi kuun yɨvɨ ni ka kuu ja ni kejaꞌa undi Abraham ti ni jaa undi David, ti uxi kuun ga tuku ja ni kejaꞌa jiin David, ti undi kuiya ni ka jaꞌan yɨvɨ Israel presu nuu yɨvɨ ñuu Babilonia. Ti uxi kuun ga tuku ja undi kuiya yukan, ti ni jaa kuiya ni kaku Cristo, ja ni taji Yandios ya, ndiso jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Siaꞌan ni kuu na ni kaku Cristo Jesús. Nana ya María, iyo tratu ña ja nandaꞌa ña jiin José. Na ti najnaꞌan ga ña jiin José, ti ja ni jakuꞌun seꞌe ña. Ti maa Espíritu Santo ni saꞌa ja na jakuꞌun seꞌe ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ɨɨn chaa vaꞌa ni kuu José, ti tu ni kuni da ja stuu da maa da nuu yɨvɨ ja xndoo da ña, chi ni ndoꞌo ini da ja xndoo xeꞌe da ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ni ndoꞌo ini da siaꞌan, ti ni kenda ɨɨn ángel ja junukuachi nuu Yandios. Ti ni kaꞌan ángel un jiin da nuu ñujani, ti ni kachi: ―José, roꞌo ja kuu ra jnaꞌan rey David na janaꞌan, koto yuꞌu ra ja kiꞌin ra María ja kuu ñasɨꞌɨ ra, chi seꞌe ñuꞌun chii ña un vaji nuu maa Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ti nu na kaku suchi lulu un, ti skonani ra i Jesús. Siaꞌan konani suchi lulu un chi maa i kuu ja nama sɨkɨ kuaꞌa ñanijnaꞌan i, yɨvɨ ka iyo kuachi ―ni kachi ángel Yandios un. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Taka un ni kuu nava na kundaa taka jnuꞌun ni kachi profeta Isaías na janaꞌan, na ni kaꞌan da jnuꞌun Yandios: ");
INSERT INTO mpmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jakuꞌun seꞌe ɨɨn ñaꞌan lulu un, ti kuu i ɨɨn suchi yɨɨ. Ti suchi lulu un konani i Emanuel, ja kuni kaꞌan: “Kancha Yandios jiin yo.” ");
INSERT INTO mpmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nu ni ndoto José, ti ni saꞌa da nava ni taꞌu ángel Yandios un jniñu. Ti ni jaka da María ja na kuu ña ñasɨꞌɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko tu ni ka najnaꞌan da, chi ni ndatu da undi ni kaku seꞌe ña. Ti ni ka skonani da i Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús ni kaku ya ɨɨn ñuu lulu nani Belén, ja kuu ɨɨn ndañuu Judea. Ti kuiya yukan ni kuu Herodes rey ja taꞌu jniñu nuu ñuu yukan. Ti ni jakoyo uni chaa ñuu kaꞌiin ichi nuu kaña ndikandii ñuu Jerusalén, ti chaa un ka kuu da chaa tuꞌva. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ti ka nduku jnuꞌun da: ―¿Nanu kande rey yɨvɨ ñuu Judea ja ni kaku un? Chi nuu andɨvɨ ichi nuu saꞌu ndikandii ni ka jini ri ɨɨn luceru jaꞌa seña ja, ja ni kaku i. Ti ja yukan kuu ja vekoyo ri jaꞌa ja na chiñuꞌun ri i naa ri ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nu ni jini rey Herodes jnuꞌun un, ti ni kejaꞌa kaña ii ini da, ti suni kuaꞌa yɨvɨ ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti yukan na ti ni nastutu rey un taka sutu ka kuñaꞌnu jiin taka ga chaa ka xnaꞌan ley Israel un, ti ni ka jikajnuꞌun da nau ñuu ni kaku Cristo. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ti ni ka kachi chaa un: ―Ñuu Belén, ɨɨn ndañuu Judea, chi siaꞌan ni chaa profeta nuu tutu ja ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ti roꞌo yɨvɨ ñuu Belén, ja kanchuku ra ñuu Judá, tu ndaꞌu xaan kendo ra ja kuu nuu taka ga ñuu ka iyo nuu ñuyɨvɨ, chi jaꞌa kuu nuu kaña ɨɨn chaa kuñaꞌnu, ja koto ñuu ri Israel. Kachi tutu. Siaꞌan ni ka kachi chaa un nuu rey Herodes. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yukan na ti ni kana xeꞌe Herodes chaa tuꞌva un, ti ni jikajnuꞌun ndaa da nasa ja ni kuu ja ni kenda luceru un, na ni ka jini da. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yukan na ti ni taji da chaa un kuankoyo da ñuu Belén, ti ni kachi da: ―Kuankoyo naa ra ti nduku jnuꞌun ndaa ra nanu kancha suchi lulu un. Nu ni ka naniꞌin ra nuu kancha i, ti chakoyo ra ti kasjnuꞌun ra nuu ri nava suni na kiꞌin tu ruꞌu, kin chiñuꞌun ri i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Siaꞌan ni xndaku rey un nuu chaa tuꞌva un, ti kuankoyo da. Ti luceru jaꞌa seña ja ni ka jini da ichi nuu kaña ndikandii un, yoxnuu tuku nuu da naa da undi ni jaa nuu kancha suchi lulu un sa ni jakuɨñɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nu ni ka jini chaa tuꞌva un ja ni jakuɨñɨ luceru un, ti ni ka kusɨɨ xaan tonto ini da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nu ni ka kɨvɨ da ini veꞌe un, ti ni ka jini da suchi lulu un kancha i, yɨjnɨ nana i María suchi. Ni ka jakunjitɨ da, ti ni ka nakuaꞌa da ja yɨñuꞌun suchi lulu un. Yukan na ti ni ka jiña da kaja da, ti ni ka jaꞌa da oro, suxia kutu vixi jiin ɨnga nuu suxia (ja nani mirra), ni kutaꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yukan na ti ni kasjnuꞌun ɨɨn ñujani nuu da naa da ja tukaa ga nandeokuñɨ da nuu kancha rey Herodes. Ti ni ka nandeokuñɨ da ɨnga ichi kuan nukoyo da ñuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu ni ka yaꞌa chaa tuꞌva un kuankoyo da, ti ni kaꞌan tuku ɨɨn ángel Yandios jiin José nuu ñujani, ti ni kachi: ―Kiꞌin suchi lulu jña jiin nana i, ti kuankoyo ichi ñuu Egipto naa ra. Ti yukan kunchuku ra naa ra undi na kachi maa ri tuku, chi kuni nanduku rey Herodes suchi lulu jña ja kaꞌni da i ―ni kachi ángel ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yukan na ti ni kiꞌin José suchi lulu un jiin nana i, ti ni ka kee da jakuaa un kuankoyo da ichi ñuu Egipto. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ti yukan ni kaꞌiin da undi ni jiꞌi rey Herodes. Yukan ni kundaa nava ni kachi Yandios ja ni kachi profeta na janaꞌan un: “Undi Egipto ni kana ri seꞌe ri.” ");
INSERT INTO mpmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nu ni jini Herodes ja ni ka kuu ichi ini chaa tuꞌva un maa da. Ti ni kɨtɨ xaan tonto ini da, ti ni taꞌu da jniñu ja na kuū taka suchi kuachi iin uu kuiya, jiin taka suchi yɨɨ kuachi ga ja kanchuku ñuu Belén, jiin taka ga ñuu kaꞌiin yajni un. Siaꞌan ni saꞌa da, chi ja ni niꞌin vaꞌa da jnuꞌun nuu chaa tuꞌva un, chi ni ka kachi chaa un nasa ja ni kuu ja ni kaku Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yukan ni kundaa nava ni chaa profeta Jeremías nuu tutu ja ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ni ka ndeꞌe xaan yɨvɨ ñuu Ramá, ti iyo xaan jnuꞌun kuiꞌya ini. Raquel kuu ñaꞌan ndeꞌe xaan jaꞌa seꞌe ña, ti tu kuni ndusɨɨ ini ña, chi ja ni ndɨꞌɨ i ni ka jiꞌi. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nu ni jiꞌi rey Herodes, ti ni kaꞌan tuku ɨɨn ángel Yandios jiin José nuu ɨɨn ñujani nuu kande da ñuu Egipto un, ti ni kachi: ");
INSERT INTO mpmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Kiꞌin suchi lulu jña jiin nana i, ti nandeokuñɨ ñuu Israel, chi ja ni jiꞌi chaa kuni kaꞌni maa i un ―ni kachi ángel Yandios un. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yukan na ti ni kiꞌin José suchi lulu un jiin nana i, ti kuanoꞌon da ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ko nu ni jini José ja Arquelao ni nukuɨñɨ da nuu tata da Herodes ti taꞌu da jniñu nuu ñuu Judea, ti ni yuꞌu da kiꞌin da yukan, chi ja ni iyo ɨɨn ñujani nuu da, ti kuaꞌan da ichi ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nu ni ka jakoyo da yukan, ti kuankoyo da ñuu Nazaret. Yukan ni kunchuku da. Ti ni kundaa taka jnuꞌun ni ka kaꞌan profeta ja Jesús konani ya, “chaa ñuu Nazaret.” ");
INSERT INTO mpmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yukan ti ni kii Juan, chaa skuanducha un, nuu ñuꞌun teꞌe ñuu Judea, ti kaꞌan da nuu yɨvɨ, ");
INSERT INTO mpmNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ti ni kachi da: ―Nakani ini naa ra, chi ja kuan kuyajni kɨvɨ taꞌu maa Yandios jniñu nuu ra naa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti sɨkɨ Juan jaꞌa kuu ja ni kaꞌan profeta Isaías na ni chaa da ɨɨn tutu siaꞌan: Kin kaꞌan ɨɨn chaa, kin kaꞌan undi nuu ñuꞌun teꞌe un, ti kachi da: “Koo tuꞌva ra naa ra, chi ja yajni chaa Jitoꞌyo. Ti kuni ja na kaka ndaa ra naa ra.” Siaꞌan ni chaa profeta Isaías nuu tutu na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Saꞌma Juan ni kuu jiin ixi camellu. Ni yɨꞌɨ ɨɨn sanchi ñɨɨ chii da. Ni yaji da ndɨkuaꞌyɨ jiin nduxi ñuñu yuku. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ni ka kii yɨvɨ ñuu Jerusalén, jiin yɨvɨ ndañuu Judea, jiin yɨvɨ ñuu kaꞌiin yajni yucha Jordán un, ti ni ka ñusoꞌo i jnuꞌun kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ti nu ni ka kachi i ja, ja ni ka nakani ini i naa i nuu kuachi i, ti ni skuanducha Juan i ini yucha Jordán. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Suni ni ka jakoyo kuaꞌa chaa fariseo, ja ni ka kuu da chaa ka jito vaꞌa nuu ley Israel, jiin kuaꞌa chaa saduceo (chaa un ni ka kuu da ɨnga partido ja suni ka xnaꞌan da sɨkɨ nasa kuni kaꞌan ley Israel). Ni ka kii uu grupo un nuu skuanducha Juan, ti ni jini Juan ja nde kuaꞌa chaa un ni jakoyo. Ti ni nduxaan da nuu chaa un naa da, ti ni kachi da: ―Roꞌo ka kuu ra nanu koo xaan jiin seꞌe tɨ, chi ndevaꞌa xaan ka saꞌa ra. ¿Xi ka jani ini ra ja nama ra maa ra nuu nundoꞌo ja kuan kuu yajni nuu ra naa ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Na kachi ri ja kava yɨñuꞌun ra naa ra nava na kuni ndaa yo ja, ja ni ka nakani ini ra nuu kuachi ra naa ra. Ti nava siaꞌan na nduu ra nanu ɨɨn yujnu vixi ja jaꞌa ndeꞌe vaꞌa, chi ka saꞌa ra jniñu vaꞌa. Ti siaꞌan ka stuu ra ja, ja ni ka nakani ndixia ini ra, ti ni ka xndoo ra kuachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ti tu kondoꞌo vixi ini ra naa ra ja kaꞌan ra: “Maa yo naa yo ka kuu yo jnaꞌan Abraham.” Tu kaꞌan ra siaꞌan, chi na kachi ri ja vasu undi yuū jaꞌa, ti kuu saꞌa Yandios ɨɨn jniñu ñaꞌnu ja na kuu i jnaꞌan Abraham, nu kuni ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ti nuu yɨvɨ ja tu ka kuni nakani ini i nuu kuachi un, ja iyo tuꞌva Yandios ja kuaꞌa ya nundoꞌo nuu i. Ti nundoꞌo ja kuaꞌa Yandios un kuu nanu ɨɨn chaa ja iyo tuꞌva da ja kin sandoo da nuu huerta da, ti kaꞌncha da yujnu ja tukaa jaꞌa ndeꞌe vaꞌa, ti skiꞌin nuu ñuꞌun ja na kayu. Suni siaꞌan kutuꞌva Yandios kuaꞌa ya nundoꞌo nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jandaa kuu ja ruꞌu chi skuanducha ri roꞌo naa ra jiin nducha, ko kuan kuu yajni kɨvɨ kenda ɨɨn chaa kuu ñaꞌnu ga ja kuu ruꞌu. Ti nanu ja skuanducha da roꞌo naa ra ja kuaꞌa da Espíritu Santo ja kuncha ya jiin ra. Ti siaꞌan nanu sandoo ɨɨn ñuꞌun nuu kayu, suni siaꞌan sandoo Espíritu Santo undi ini ra naa ra. Ti chaa kuu ñaꞌnu un, tu kuu kandu ri nuu da, chi kuu ñaꞌnu ga da ja kuu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ti sasɨɨn da yɨvɨ nanu ɨɨn chaa yɨjnɨ pala da ja xndeche da triu da, ti kendo da paja, savaꞌa da triu da ini veꞌe da, ti kaꞌma da paja un. Ti chaa un, chi kuaꞌa da nundoꞌo yɨvɨ jiin ɨɨn ñuꞌun ja tu ndaꞌva kuɨtɨ ―siaꞌan ni kachi Juan nuu chaa fariseo jiin chaa saduceo un. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yukan ti ni kee Jesús ñuu Galilea, ti vaji ya ichi yucha Jordán nuu kande Juan ja na skuanducha da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ko tu kuni Juan ni kuu, ti ni kachi da jini Jesús: ―Maa ni kuu ja skuanducha saña, ti ansu ja maa ni vaji nuu na ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ti ni kachi Jesús: ―Na koo siaꞌan vijna, chi kanuu ja na siuku yo taka jniñu ni taꞌu Yandios ―ni kachi ya. Yukan ti sa ni jantaꞌu Juan. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nu ni janducha Jesús, ni kee ya ini nducha un, ti yukan ni nuña andɨvɨ nuu kancha Yandios, ti ni jini Jesús ja vaji Espíritu Yandios, ti ni jinu xini ya, nanu ɨɨn sata. ");
INSERT INTO mpmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yukan ti ichi andɨvɨ ni kaꞌan Yandios jiin Jesús: ―Jaꞌa kuu seꞌe ri ja kundaꞌu xaan ini ri. Ti kusɨɨ xaan ini ri jiin ya ―ni kachi Yandios jiin seꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yukan ti ni yɨndaꞌa Espíritu un Jesús kuaꞌan ya undi nuu ñuꞌun teꞌe un, ja kuni jaꞌuꞌu un kueꞌe ya ja na saꞌa niꞌin ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ti siaꞌan ni kundee ya uu xiko nduu kɨvɨ, ti uu xiko jakuaa, ni iyo ndicha ini ya. Yukan ti sa ni chaa ɨɨn soko ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yukan ti ni tuꞌva jaꞌuꞌu un nuu Jesús ja kuni keꞌe ya, ti ni kachi: ―Nu ndixia ra ja Seꞌe Yandios kuu ra, saꞌa ja taka yuū jaꞌa na nduu staa kaji yo ―kachi jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ti ni kachi Jesús: ―Kachi nuu tutu Yandios: “Ansu jiin nɨnɨ staa kuchaku yɨvɨ naa i, chi suni kuu kuchaku i jiin taka jnuꞌun kaꞌan Yandios”, ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yukan ti kuaꞌan tuku jaꞌuꞌu un jiin ya ichi ñuu Jerusalén, ja kuu maa ñuu ii, ti ni kaa ya xini veñuꞌun kaꞌnu Israel, ");
INSERT INTO mpmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ti ni kachi tuku jaꞌuꞌu un jiin ya: ―Nu ndixia ra ja Seꞌe Yandios kuu ra, ti skanakava maa ra undi nuu ñuꞌun un, chi siaꞌan yoso nuu tutu: Na taꞌu Yandios jniñu nuu ángel ya ja na koto ya roꞌo. Ti nakindaꞌa ya roꞌo jiin ndaꞌa ya, nava tu tuji sɨꞌɨn ra nuu ni ɨɨn yuu. Kachi tutu, ni kachi jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ti ni kachi tuku Jesús: ―Tuu, chi suꞌva yoso nuu tutu Yandios: “Koto maa keꞌe ga ra maa jitoꞌo ra Yandios”, kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yukan ti kuaꞌan tuku jaꞌuꞌu un jiin Jesús xini ɨɨn yuku sukun xaan, ti yukan ni xnaꞌan nuu ya taka ñuu ka iyo nuu ñuyɨvɨ jiin taka ndajniñu vii ja iyo nuu, ");
INSERT INTO mpmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ti ni kachi: ―Taka jaꞌa kuaꞌa ri nuu ra nu na jakunjitɨ ra ti chiñuꞌun ra ruꞌu ―ni kachi jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yukan na ti ni kachi Jesús: ―Kuxio nuu ri roꞌo jaꞌuꞌu, chi suꞌva kachi nuu tutu Yandios: “Chiñuꞌun nuu maa ɨɨn ni ya kunukuachi ra nuu”, kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yukan ti ni kuxio jaꞌuꞌu un nuu Jesús ti kuaꞌan. Ti sa ni ka chakoyo ángel Yandios, ti ni ka chindee i maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ti yukan ni niꞌin Jesús jnuꞌun Juan, chaa skuanducha un, ja kande da vekaa. Ti nu ni jini ya jnuꞌun un, ni kee ya ti kuaꞌan ya ichi ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko tu ni kendo ya ñuu Nazaret, chi kuaꞌan ya undi ñuu Capernaum, ɨɨn ñuu kande yajni yuꞌu mar Galilea, ja kendo nuu ñuꞌun ñuu Zabulón jiin ñuꞌun Neftalí, ti yukan ni kuncha ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ti yukan ni kundaa nava ni chaa profeta Isaías nuu tutu na janaꞌan: ");
INSERT INTO mpmNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuu Zabulón jiin ñuu Neftalí, ja kuu ɨɨn ichi kuaꞌan yajni yuꞌu mar, ichi nuu kaña ndikandii yucha Jordán, ti ñuu Galilea nuu kanchuku yɨvɨ ja tu ka kuu yɨvɨ Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yɨvɨ ka iyo kuachi kanchuku ñuu un, kanchuku i nanu nuu ñuñaa kuɨtɨ, chi tu ka jini i jnuꞌun Yandios. Ti yɨvɨ kanchuku nanu ndatɨ ñujiꞌi, ni ndinchaa ɨɨn ñuꞌun nuu i. Chi nu na nakuni ndaa i jnuꞌun ya, ti kuu i nanu ja ni ka ndundijin nduchi i. Siaꞌan ni kachi profeta Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Undi kɨvɨ un ni kejaꞌa Jesús xndaku ya, ti kachi ya: ―Nakani ini nuu kuachi ra naa ra, chi ja ni jaa kɨvɨ ja taꞌu Yandios jniñu nuu nɨ tuꞌu ñuyɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kuaꞌan Jesús yuꞌu mar Galilea, ti ni jini ya uu chaa kaꞌiin un, ɨɨn da kuu Simón ja suni nani da Pedro, ti ɨnga da kuu Andrés, ñani da. Kaꞌiin da ka jnɨɨ da chāká, ti ja ni ka chunde da ñunu da ini nducha, ");
INSERT INTO mpmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ti ni kachi Jesús jiin da: ―Kundikun ruꞌu naa ra, na choꞌo. Ja ni ka jnɨɨ xaan ra chāká, ko vijna ruꞌu, na xnaꞌan ri roꞌo nasa nastutu ra yɨvɨ. Ti xnaꞌan ra yɨvɨ un maa jnuꞌun Yandios ja na kandixia i ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ti luego ni, ni ka xndoo da ñunu da ti kuankoyo da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ni jika ya tɨꞌlɨ ga, ti ni jini ya kaꞌiin uu ga da, Jacobo jiin ñani da Juan, seꞌe yɨɨ Zebedeo. Kaꞌiin da ini ɨɨn barco jiin tata da, ka nachaa da ñunu da, ti ni kana Jesús xini da. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yachi ni, ni ka xndoo da barco un jiin tata da, ti ni ka ndikun da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kuaꞌan Jesús nɨ ñuu Galilea, kuaꞌan ya xnaꞌan ya nuu yɨvɨ ini taka veñuꞌun yɨvɨ Israel ja na kutuꞌva yɨvɨ un jnuꞌun Yandios. Xnaꞌan ya nuu yɨvɨ nava taꞌu Yandios jniñu, ti suni kenchaa ya taka nuu kueꞌe ka jnaꞌan yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Taka yɨvɨ ñuu Siria ni ka niꞌin i jnuꞌun Jesús, ti ni ka janchaka i taka yɨvɨ ka jnaꞌan taka nuu kueꞌe nuu ya, jiin taka yɨvɨ ka jnaꞌan tachi xaan, jiin yɨvɨ ka jnaꞌan kueꞌe jiyɨꞌɨ, jiin yɨvɨ tɨkuku un. Ti ni saꞌa Jesús tajna i. ");
INSERT INTO mpmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kuaꞌa yɨvɨ ñuu Galilea ni ka ndikun ya, yɨvɨ ñuu Decápolis, yɨvɨ ñuu Jerusalén, jiin ñuu Judea, jiin yɨvɨ taka ñuu ka kendo ichi nuu kaña ndikandii yucha Jordán. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nu ni jini Jesús yɨvɨ kuaꞌa un, ti kuaꞌan ya xini ɨɨn yuku, ti yukan ni nukoo ya. Ti yukan ni ka ndututu yɨvɨ ka skuaꞌa jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yukan ti ni kejaꞌa Jesús ni xnaꞌan ya nuu i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ti ni kachi Jesús: ―Na kachi ri ja kandichi Yandios jiin yɨvɨ ka iyo jnuꞌun kuiꞌya ini sɨkɨ ja ni ka nakani ini i. Ni ka nakani ini i ja tu ni iyo ni ɨɨn jniñu vaꞌa i nuu Yandios. Ti sɨkɨ yɨvɨ un chi jandaa kuu ja kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Ti jandaa kuu ja kɨvɨ i ñuu nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kachi ri ja kandichi Yandios jiin yɨvɨ ja ka iyo jnuꞌun kuiꞌya ini sɨkɨ kuachi i, ti kuaꞌa Yandios jnuꞌun ndee ini nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kachi ri ja kandichi Yandios jiin yɨvɨ vita ini, ti niꞌin i ñuꞌun ni chisojnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kachi ri ja kandichi Yandios jiin yɨvɨ ka ñukuu ini maa ya ti ka jandatu i jniñu taꞌu ya, ti ka saꞌa i taka nava kuni ya, chi maa ya chindee i ja na siuku i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kachi ri ja kandichi Yandios jiin yɨvɨ ka kundaꞌu ini jnaꞌan, ti suni kundaꞌu ini Yandios maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kachi ri ja kandichi Yandios jiin yɨvɨ ka iyo ndoo añu, ti kuaꞌa ya taꞌu i ja kunchuku i jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kachi ri ja kandichi Yandios jiin yɨvɨ saꞌa ja na kukuee kunchuku yɨvɨ naa i, chi nakinseꞌe Yandios maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Suni kachi ri ja kandichi Yandios jiin yɨvɨ ka jito uꞌu yɨvɨ maa i sɨkɨ ja ka jika ndaa i ichi Yandios. Kandichi Yandios jiin yɨvɨ ya un, ti jandaa kuu ja kɨvɨ i ñuu nuu taꞌu maa ya jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ti kachi ri ja kandichi Yandios jiin roꞌo naa ra ja nu na kaꞌan ndevaꞌa yɨvɨ nuu ra, kaꞌan i sɨkɨ ra ti kundio ini i roꞌo ja kuaꞌa i tau ra naa ra, ti chakuachi i roꞌo savaꞌa ni ga jnuꞌun ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ti sɨɨ xaan na koo ini ra naa ra, chi na niꞌin ra taꞌu nuu Yandios. Suni siaꞌan ni ka saꞌa yɨvɨ jiin profeta ni taji ya ja ni kikoyo undi nuu. Suni ni ka ndiyo ini yɨvɨ maa da, siaꞌan nanu ka ndiyo ini yɨvɨ roꞌo vijna naa ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Roꞌo naa ra, ka kuu ra nanu ñɨɨ ja saꞌa asun ndeyu, chi kanchuku ndaa ra nuu ñuyɨvɨ jaꞌa. Ti nanu ja kanchuku ra siaꞌan, ka kuu ra nanu ñɨɨ ja kuu nuu ndeyu. Chi nu na naa xiko uꞌua ñɨɨ un, ti tukaa kuajniñu yo, chi suꞌva kacha yo kiꞌin, ja na kuañu niꞌnu yɨvɨ sɨkɨ naa i. Ti suni siaꞌan kuu jiin roꞌo, chi nu tu kanchuku ndaa ra nuu yɨvɨ ñuyɨvɨ jaꞌa, ti suni siaꞌan tukaa kuajniñu roꞌo ja kuu nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Roꞌo naa ra, suni ka kuu ra nanu nduva ñuꞌun ja kuu nuu ñuyɨvɨ jaꞌa. Nu ɨɨn ñuu na kundee xini ɨɨn yuku, ti tu kuu jankɨsaꞌyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni tu kuu skuikun yo ɨɨn yɨtɨ, ti chunde yo chii ɨɨn cajón. Chi suꞌva chuxndee yo ñuꞌun un nuu sukun nava na kundijin nuu taka yɨvɨ kanchuku ini veꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Suni siaꞌan kuni ya jiin roꞌo naa ra, ti saꞌa ra ja na ndundijin nuu taka yɨvɨ, ti nava na nakuni i taka jniñu vaꞌa ka saꞌa ra. Ti na nakuantaꞌu i nuu Tata ra Yandios, ya kancha undi andɨvɨ. Nakuantaꞌu i nuu ya vanua siaꞌan chindee ya roꞌo naa ra, ti vii vii kunchuku ra naa ra nuu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Koto kondoꞌo ini ra naa ra ja ni chaa ri xnaa ri ley Moisés, xi jnuꞌun ni ka xnaꞌan taka profeta. Tu xnaa ri jnuꞌun un, chi suꞌva vaji ri ja na siuku ri taka jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na kachi ndaa ri nuu ra naa ra ja nɨ iyo ga andɨvɨ jiin ñuyɨvɨ, ni tu kuu kencha ri ni ɨɨn letra nuu ɨɨn jnuꞌun Yandios, undi na kuu taka nava kuni maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ja yukan kuu yɨvɨ tu ka jandatu nuu taka ley ni jaꞌa Yandios, vasu ɨɨn jniñu lulu, ja na xnaꞌan i nuu ɨnga yɨvɨ ja na saꞌa i, ti na kachi ndaa ri ja yɨvɨ un, tu kuu kɨvɨ i ini ñuu nuu taꞌu Yandios jniñu. Ko yɨvɨ jandatu ti xnaꞌan i nuu ɨnga yɨvɨ ja na kuandatu i, ti yɨvɨ yukan ndixia chi najaa i nuu taꞌu Yandios jniñu ti yukan nduñaꞌnu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ti na kachi ri nuu ra ja nu na kunchuku ra nanu kanchuku chaa ka xnaꞌan ley Moisés jiin chaa fariseo yukan, yukan na ti tu kuñukun ini ra ja kɨvɨ ra ñuu nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ka jini ra naa ra ɨɨn jnuꞌun ni ka kaꞌan jnaꞌan ra na janaꞌan ja kachi: “Tu kaꞌni ra ndɨyɨ, chi nu ɨɨn yɨvɨ na kaꞌni ndɨyɨ ti kiꞌin yɨ nuu juez ja na xndichi da i.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko ruꞌu na kachi ri nuu ra ja nu ɨɨn yɨvɨ na kɨtɨ ini i nuu ñani jnaꞌan i, ti suni kundaꞌa da yɨvɨ un nuu juez. Nu na saꞌa ndevaꞌa i nuu ñani jnaꞌan i, ti kiꞌin i nuu junta kaꞌnu Israel ja na xndichi da maa i. Ti nuu nau yɨvɨ na kachi ja kakuꞌu xi ja tu iyo ndɨꞌɨ ini ñani jnaꞌan i, na kuñukuu ini i ja kiꞌin i nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ja yukan kuu ja nu na kin soko ra nuu altar Yandios, ti nu ja ni jaa ra yukan, ti nukuꞌun ini ra ja kɨtɨ ini ñani ra nuu ra, ");
INSERT INTO mpmNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","xndoo ja yɨndaꞌa ra yukan nuu altar un, ti nandeokuñɨ ra, ti kin nundaka taꞌu ra nuu da. Yukan na ti sa kuu nandeokuñɨ ra, ti soko ra ja yɨndaꞌa ra nuu altar Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nu ɨɨn yɨvɨ na kankuachi jaꞌa ra ja tau ra xuꞌun nuu da, ti kiꞌin da jiin ra undi veꞌe juzgado. Xnakan ndaka taꞌu ra nuu da ichi kuankoyo ra nava tu xndichi da roꞌo nuu juez, chi nakuaꞌa juez un roꞌo nuu policia, ti chaa un chunde da roꞌo vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ti na kachi ndaa ri nuu ra naa ra, ja siaꞌan ni kundee ra vekaa un undi na chunaa ndɨꞌɨ ra ja tau ra nuu chaa un, ti sa kee ra kiꞌin ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ka jini ra nava ni ka kaꞌan yɨvɨ janaꞌan: “Koto kusɨkɨnchaa jnaꞌan ra jiin ɨnga ñasɨꞌɨ.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Chi na kachi ri nuu ra ja nu ɨɨn chaa na kuni da ɨɨn ñasɨꞌɨ ti kuu ini da ndeꞌe da ña, ti chaa un ja ni chakuachi da maa da jiin ña undi añu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ti nu nduchi kuaꞌa ra kuu ja ni ndeꞌe un, tava na kiꞌin. Chi vaꞌa ga ja nu ɨɨn ni nduchi ra na naa, ti ansu ja kiꞌin ra nɨ jiin yɨkɨ kuñu ra nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ti nu ndaꞌa kuaꞌa ra kuu ja ni saꞌa ɨɨn kuachi, kaꞌncha na kiꞌin, chi vaꞌa ga ja nu ɨɨn ni ndaꞌa ra un na naa, ti ansu ja kiꞌin ra nɨ jiin yɨkɨ kuñu ra nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Suni siaꞌan ni ka kaꞌan yɨvɨ janaꞌan: “Nu ɨɨn chaa na xndoo da ñasɨꞌɨ da, ti nuu kuu ja na ndokani da ɨɨn tutu ja ni ka xndoo jnaꞌan da.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko ruꞌu na kachi ri nuu ra ja nu ɨɨn chaa na xndoo da ñasɨꞌɨ da, ti nu tu naa kuachi ni saꞌa ña, ja kinikava ña jiin ɨnga chaa, ti chaa un chakuachi da maa ña. Ko nu ɨnga chaa na nandaꞌa jiin ɨɨn ñaꞌan ni kendo un, ti suni chakuachi da maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Suni siaꞌan ni ka kaꞌan yɨvɨ janaꞌan: “Koto naa ini ra, ti tu siuku ra taka jnuꞌun ni chisojnuꞌun ra nuu Yandios, ja maa Yandios kuu ya kuaꞌa jandaa jaꞌa ra.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko na kachi ri nuu ra naa ra ja tu chisojnuꞌun ra siaꞌan, chi nu na chisojnuꞌun ra ja andɨvɨ kuu ja kuaꞌa jandaa jaꞌa ra, ti yukan kuu nuu kancha maa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni tu kachi ra ja ñuyɨvɨ kuu ja kuaꞌa jandaa jaꞌa ra, chi jaꞌa kuu nuu jañu ya jiin jaꞌa ya, chi maa ya xiin. Ni ja kuu ñuu Jerusalén, ja yukan tu kuaꞌa jandaa jaꞌa ra, chi yukan kuu ñuu chaa kuu Rey kuñaꞌnu ga ja taꞌu jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni tu chisojnuꞌun ra ja kuu ixi xini ra. Sandau tu siuku ra, ti nasa kuu sama ra color ixi xini ra ti maa ya ni jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","So nɨnɨ kuu ja kachi ra naa ra ja “kuu” xi “tu kuu”, chi tu nijniñu ɨnga jnuꞌun un, vasu ɨɨn jnuꞌun kanuu ga kuu ja chisojnuꞌun ra un, chi taka ga jnuꞌun un vaji nuu jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Suni ka jini ra ja ni ka kaꞌan yɨvɨ janaꞌan: “Nu ni stuji yɨvɨ nduchi ra, ti suni stuji nduchi maa i. Ti nu ni tava i jnuꞌun yoso ra, ti suni tava ra jnuꞌun yoso maa i.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko ruꞌu na kachi ri: Koto kinjnaꞌan ra jiin yɨvɨ kani roꞌo, chi suꞌva nu ni kani i ɨɨn nuu nuu ra, kuaꞌa ɨnga nuu ra na kani tuku i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nu ɨɨn yɨvɨ na kankuachi ja kuni kuisonchaa i camisa ra, suni kuaꞌa jnuꞌun ja na kundaꞌa i chamarra ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nu ɨɨn yɨvɨ na chayɨka roꞌo ja kin nchaka ra ndajniñu i sava ichi, ti vaꞌa ga na kinchaka ra i undi nuu kiꞌin yɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ti nu savaꞌa ni ga yɨvɨ na kakan nuu i ɨɨn ndajniñu nuu ra, kuaꞌa ndajniñu kuni i, ti koto siokani ra siaꞌan ni yɨvɨ un kiꞌin. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ka jini ra ja suni siaꞌan ni ka kaꞌan yɨvɨ janaꞌan: “Kundaꞌu ini nuu yɨvɨ kundaꞌu ini roꞌo, ti koto uꞌu nuu yɨvɨ jito uꞌu roꞌo.” ");
INSERT INTO mpmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko ruꞌu na kachi ri nuu ra naa ra ja na kundaꞌu ini ra nuu yɨvɨ jito uꞌu roꞌo. Kakantaꞌu nuu maa Yandios ja kuu yɨvɨ ka kaꞌan ndevaꞌa nuu ra ti ka kaꞌan i sɨkɨ ra, ti chindee yɨvɨ un vasu na kani i roꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chi siaꞌan ti sa stuu ra maa ra ja yɨꞌɨ ra jiin maa Tata ra Yandios, ya kancha andɨvɨ. Chi maa ya kuu ja saꞌa ja ndii sɨkɨ yɨvɨ vaꞌa jiin yɨvɨ kueꞌe, ti suni jaꞌa ya sau ja kuu taka yɨvɨ un, ti yɨvɨ un suni kuu i jnaꞌan ra nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ko nu roꞌo na kundaꞌu ini ra nuu nɨnɨ yɨvɨ ka kundaꞌu ini maa ra, ¿ti nau taꞌu ra iyo ja nu siaꞌan naa saꞌa ra nusa? Ti suni undi chaa ka jikan yaꞌu nuu puestu un ka saꞌa da siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ti suni nu na kanxiaꞌu ra jiin nɨnɨ yɨvɨ mani ra jiin, ti tu vaꞌa nu na saꞌa ra siaꞌan, chi undi yɨvɨ ja tu ka kandixia Yandios, suni siaꞌan ka saꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ja yukan kuu ja koo ndaa ini ra jiin taka ni yɨvɨ. Ti siaꞌan kunchuku ndaa ra, chi Tata yo Yandios, ya kancha andɨvɨ, nɨnɨ iyo ndaa ini ya jiin yoꞌo naa yo ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Siin Jesús xndaku ya nuu yɨvɨ ka skuaꞌa jiin ya, ti ni kachi ya: ―Koto stuu ra ɨɨn jniñu ja ka saꞌa ra nuu yɨvɨ ja na ndeꞌe i roꞌo. Chi nu siaꞌan na saꞌa ra, ti Tata yo Yandios ja kancha andɨvɨ, tu kuaꞌa ya taꞌu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nu ka kuni chindee ra yɨvɨ ndaꞌu naa i, koto stuu ra nuu nɨ ñuu, nanu ka saꞌa yɨvɨ ja ka kaꞌan vixi i, ka jika i ichi, xi ini veñuꞌun Israel, ja jiin jnuꞌun i ka stuu i ja tu ka chiñuꞌun i jnuꞌun Yandios. Siaꞌan ka kaꞌan i nava na nakuaꞌa yɨvɨ ja yɨñuꞌun i nuu i maa i naa i. Ko jandaa na kachi ri nuu ra naa ra ja yukan ni kuu ndɨꞌɨ taꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ti roꞌo nu ka kuni ra chindee ra yɨvɨ ndaꞌu, ko kuaꞌa xeꞌe ra un nava tu kuni ni ɨɨn yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Siaꞌan saꞌa ra nava maa ɨɨn ni Yandios na kuni jniñu un, chi maa ya kuu ja kuaꞌa taꞌu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nu ka kuni kakantaꞌu ra naa ra, koto saꞌa ra nanu ka saꞌa yɨvɨ ja ka nu kujiin i ini veñuꞌun, xi jikɨ calle ja na kuni yɨvɨ nuu i, ja jiin jnuꞌun i ka stuu i ja tu ka chiñuꞌun i jnuꞌun Yandios. Ko na kachi ndaa ri ja jiin yukan ni, ti ja ka iyo taꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko roꞌo nu kuni kakantaꞌu ra, ndɨvɨ ini veꞌe ra, kasɨ yuxeꞌe ra, ti kakantaꞌu nuu Yandios nuu kande maa ɨɨn ni ya jiin ra. Ti jini ya jnuꞌun kaꞌan ra, ti maa ya na kuaꞌa taꞌu jikan ra nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nu jikantaꞌu ra, ti tu ndaku niꞌin nuu nuu ra ɨɨn jnuꞌun kaꞌan ra, nanu ka saꞌa yɨvɨ tu ka nakuni nau kuu maa Yandios. Chi ka ndoꞌo ini i ja kunisoꞌo Yandios jnuꞌun ka kaꞌan i, ja siaꞌan nu nuu nuu ka ndaku niꞌin i jnuꞌun ka kaꞌan i. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Koto ma saꞌa ra siaꞌan naa ra, chi xnaka Yandios jini taka ja ka nandɨꞌɨ ra naa ra, ti sa ka jikan ra nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ja yukan kuu ja siaꞌan kakantaꞌu ra naa ra: Tata yo Yandios, ja kancha ni andɨvɨ, kava yɨñuꞌun yo nuu sɨvɨ ni, ti maa ni kuu ja kuñaꞌnu ga. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jika na nuu ni ja yachi na kiji kɨvɨ taꞌu ni jniñu nuu nɨ tuꞌu ñuyɨvɨ yo. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ti kuaꞌa ni staa nakaji yo vijna ja kuu ja ndendajnu yo ɨɨn kɨvɨ ɨɨn kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kuan kaꞌnu ini ni nuu kuachi ka saꞌa na, nanu ka jan kaꞌnu ini na nuu ñanijnaꞌan na nuu taka ja ka saꞌa i jiin na. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Koto maa kuaꞌa ni jnuꞌun ja kotojnuni jaꞌuꞌu un saña, ti suꞌva nama ni saña nuu nundoꞌo un. Chi maa ni xiin nuu taꞌu jniñu, ti maa ni kuu ja ndiso jniñu ñaꞌnu un. Ti ñaꞌnu ga na koo sɨvɨ ni sɨkɨ yo ja kuu saa ni. Ti siaꞌan na koo. Kachi ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ti ɨɨn jnuꞌun kanuu ja kakantaꞌu ra un kuu ja sakaꞌnu ini ra nuu yɨvɨ jito uꞌu roꞌo. Chi nu siaꞌan na saꞌa ra, ti suni maa Yandios, ya kancha andɨvɨ, sakaꞌnu ini ya nuu kuachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko nu tu sakaꞌnu ini ra nuu yɨvɨ ka jito uꞌu roꞌo naa ra, suni siaꞌan maa Yandios tu sakaꞌnu ini ya nuu kuachi ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Siin Jesús xndaku ya ti ni kachi ya: ―Nu ka kuni ra koo ndicha ini ra, koto sakuiꞌya ini ra naa ra nanu ka saꞌa yɨvɨ ja xndoo jnuꞌun Yandios jiin jnuꞌun i. Ka sakuiꞌya i nuu i ko so ja na kuni yɨvɨ ja ka iyo ndicha i. Na kachi ri nuu ra ja jiin yukan, ti ja ni ka niꞌin taꞌu i. Ti yukan ni kuu ndɨꞌɨ ja niꞌin i. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ko roꞌo naa ra, nu ka kuni koo ndicha ini ra, nakacha nuu ra, ti nachuꞌun ra kuka xini ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nava siaꞌan tu kani ini yɨvɨ naa i ja iyo ndicha ini ra, chi maa ɨɨn ni Yandios, ya kancha jiin ra kuu ja jini ya, ti nava na kuaꞌa ya taꞌu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Siin Jesús xndaku ya, ti ni kachi ya: ―Koto skaya ra ja kuñavaꞌa ra nuu ñuyɨvɨ jaꞌa, chi nde iyo tikixin ti nde kuaꞌa jniñu ka stɨvɨ tɨ, ti suni kuu kɨvɨ ñakuiꞌna ti sakuiꞌna i. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vaꞌa ga ja nu na skaya ra jniñu vaꞌa kuni maa Yandios, ya kancha andɨvɨ, chi yukan tu iyo tikixin ti tundo xnaa yo, ti ni ñakuiꞌna tu kuu kɨvɨ ja sakuiꞌna. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ja yukan kuu ja nu ndiyo xaan ini ra ja na nakaya yaji ra nuu ñuyɨvɨ jaꞌa, ti xnaa ndɨꞌɨ ra yaji ra nuu Yandios nuu kancha ya andɨvɨ ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Siin Jesús xndaku ya ti ni kachi ya: ―Nduva yɨtɨ kuu nduchi ra ja kuu nuu nɨ tuꞌu yɨkɨ kuñu ra. Nu ka iyo vaꞌa nduchi ra, ti suni siaꞌan iyo vaꞌa nɨ yɨkɨ kuñu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko nu tu ndijin nduchi ra, ¿ti nasa kundijin ichi kiꞌin ra nusa? Ti ñuñaa kuaꞌan ra nu siaꞌan. Chi nu na ndaꞌva yɨtɨ un, ti nduva ra ti tuji ra. Ti tu kuu nasa ndoko ra, chi iyo xaan kaa ichi ñuñaa kuaꞌan ra un. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ni ɨɨn yɨvɨ tu kuu kunukuachi nuu uu jitoꞌo, chi kendo vaꞌa i jiin ɨɨn da, ti kendo kuiꞌya i jiin ɨnga da. Ni tu kuu kunukuachi i nuu Yandios, ti ja kundio ini i xuꞌun jiin ñuꞌun. Chi nɨnɨ nuu maa ni ya kuu nu na kondoꞌo ini i, ti ansu ja kundio ini i xuꞌun ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Siin Jesús xndaku ya, ti ni kachi ya: ―Na kachi ri nuu ra naa ra, ja koto ma xndiꞌi ra ini ra ja kuu ja kaji ra xi ja koꞌo ra, ja na kuchaku ra, xi ja kuu saꞌma kuꞌun ra naa ra. Chi maa Yandios ni saꞌa ja chaku ra jiin yɨkɨ kuñu ra. Ti maa ya kuu ja kuaꞌa ja kaji ra jiin saꞌma kuꞌun ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndeꞌe naa ra, kɨtɨ ka ndava nuu tachi un, tu naa jniñu ka saꞌa tɨ ja nastutu tɨ, ti savaꞌa tɨ kuꞌiin, ko Tata ra Yandios, ya kancha ya andɨvɨ, jaꞌa ya ja ka yee tɨ. Ko na kachi ri ja kanuu ga roꞌo naa ra ja kuu kɨtɨ ka ndava un. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ti ni tundo niꞌin ra naa ra vasu na xndiꞌi xaan ini ra jiin ja kuchaku ra, xi jiin ja kundio ini ra ja kusukun ga ra. ¿Va nu ja ndɨꞌɨ xaan ini ra jiin un, ti niꞌin ra kuu ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Xi vaꞌa ka saꞌa ra ja ka xndiꞌi xaan ini ra ja kuu saꞌma ra nu? Ndeꞌe naa ra nasa ka jaꞌnu ita rosa un, ti tu jini yo nasa jaꞌnu, ko vii xaan kanda. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ko na kachi ri ja ni Salomón, chaa ni kuu rey Israel na janaꞌan, tu ni suku da nanu ita un, vasu vii xaan ni kaa saꞌma da. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ti maa Yandios skuaꞌnu ya ita un, ti vii xaan na skutu ya i. Ko vasu vii xaan ni kanda vijna ti ijña ja ni ka ichi, ti tukaa ga kuni yo. Chi suꞌva kayu nuu ñuꞌun. Ja yukan kuu ja nu siaꞌan saꞌa Yandios ja jito vaꞌa ya ita un, ¿ti ansu kanuu ga roꞌo naa ra ja na koto vaꞌa ya nu? ¿Ndoo xaan ka ndɨꞌɨ ini ra nusa? ");
INSERT INTO mpmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ja yukan kuu ja koto kachi ra naa ra: “¿Ndoo kaji yo vijna? ¿Ti nasa koꞌo yo vijna?” Xi kachi ra naa ra: “¿Nasa kuꞌun yo naa yo vijna?” ");
INSERT INTO mpmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Chi taka un ka kaꞌan yɨvɨ, ja tu ka nakuni i nau kuu Yandios. Ko roꞌo naa ra, iyo ɨɨn Tata ra ja kuu Yandios kancha andɨvɨ, ti ja jini ya ja taka un ka nandɨꞌɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ja yukan kuu ja kuñukuu ini maa Yandios naa ra, ti kuandatu nɨ ini ra jniñu taꞌu ya, nava na kuaꞌa ya taka ja ka nandɨꞌɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ti siaꞌan tu xndiꞌi xaan ini ra naa ra ja nasa koo ra ijña, chi taka ni kɨvɨ vaji nundoꞌo un, ti suni siaꞌan kuaꞌa ja ka nandɨꞌɨ yo vaji ɨɨn kɨvɨ ɨɨn kɨvɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Siin Jesús xndaku ya, ti ni kachi ya: ―Koto kuu ichi ini ra nuu yɨvɨ ja kaꞌan ndoo ra, nava suni Yandios tu ske ichi ya roꞌo, ja suni siaꞌan kaa tu maa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chi suni nanu ka kaꞌan ndevaꞌa ra nuu ñanijnaꞌan ra, suni siaꞌan xndichi Yandios roꞌo, ti saꞌa ya jiin ra nanu ka saꞌa maa ra jiin ñanijnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nu siaꞌan na saꞌa Yandios, ¿ti nasa kuu kaꞌan ndoo ra ja kuu ichi ini ra ndeꞌe ra nuu ñanijnaꞌan ra, nu iyo ɨɨn kuachi i, vasu jakuu ga kaa tu maa ra jiin kuachi ra xino? ");
INSERT INTO mpmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ko nu ja kuu ga kaa maa ra jiin kuachi ra, ¿ti ndoo kaꞌan vixi ra nuu ñanijnaꞌan ra ja iyo ndoo ra nusa? ndeꞌe na kaa jniñu saꞌa ra, ti suni yuji xaan ra jiin kuachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ko na kachi ri ja ka kuu ra nanu ja xndoo jnuꞌun Yandios jiin jnuꞌun, yɨvɨ ja tu jini ra ja xnakan ndeꞌe vaꞌa ra nasa kancha maa ra jiin kuachi ra, ti sa kuu kotonchaa ra ɨɨn kuachi lulu ka saꞌa ñanijnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Koto xnaꞌan ra jnuꞌun Yandios nuu yɨvɨ kanchuku nanu ina, chi tu kuantaꞌu i jnuꞌun kaꞌan ra. Suꞌva ske ichi i jnuꞌun un, chi ka kuu i nanu ina xaan ja ka jnɨɨ ñɨꞌɨn tɨ yoꞌo. Ni koto xnaꞌan ra jnuꞌun Yandios nuu yɨvɨ kanchuku nanu kɨtɨ, chi ske xiko i jnuꞌun un, ti kuañu niꞌnu i. Ndeꞌe ra kɨtɨ un nu ni chitu chii tɨ ti tuxijni tɨ, chi nuni un ti jañu niꞌnu tɨ sɨkɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Siin Jesús xndaku ya, ti ni kachi da: ―Koto xndiꞌi ra ini ra, ja kakantaꞌu ra nuu Yandios. Siin kakantaꞌu ra nuu ya nanu ja kana ra xini ɨɨn yɨvɨ nu nandɨꞌɨ ra ɨɨn ndajniñu. Ti siaꞌan na kunisoꞌo ya ti kuaꞌa ya nau ja nandɨꞌɨ ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chi nu siin yo jikantaꞌu yo, ti kuaꞌa ya nuu yo. Chi nu nduku yo ti naniꞌin yo. Ti nu na kana yo ti kunisoꞌo ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Xi ka iyo ɨɨn ɨɨn ra ja tava ini ra kuaꞌa ra ɨɨn yuū nuu seꞌe ra, nu ka jikan i staa nuu ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Xi nu ka jikan i chāká, ti kuaꞌa ra ɨɨn koo nuu i nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Roꞌo naa ra, vasu ka nchakuachi ra, ko suni iyo jniñu vaꞌa ka saꞌa ra ja ka nduku ra ja vaꞌa ja kuu seꞌe ra. Ti suni siaꞌan Tata ra Yandios, ya kancha andɨvɨ, kuaꞌa ya taka ja vaꞌa nu na kakan ra nuu ya naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ja yukan kuu ja kava yɨñuꞌun ra jiin yɨvɨ naa i, nava suni siaꞌan na nakuaꞌa i ja yɨñuꞌun roꞌo naa ra, chi siaꞌan taꞌu ley Moisés jniñu jiin taka ga tutu ni ka chaa profeta na janaꞌan―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Siin Jesús xndaku ya, ti ni kachi ya: ―Na kachi ri ja iyo uu ichi naniꞌin ra, ɨɨn kuu ichi vaꞌa ti ɨnga kuu ichi nundoꞌo. Ti ichi nundoꞌo un tu yɨɨ kiꞌin ra, chi jicha xaan, ti nuña ja saꞌa ra nava kuni maa ra. Yukan iyo jnuꞌun ndichi ini, kuu siin ra jiin taka jnuꞌun ra, ko sandɨꞌɨ ni ga ichi un kande nuu jnaꞌnu ndatu ra, ti kuaꞌa yɨvɨ kuankoyo i ichi un, ko sandɨꞌɨ ni ga ichi un ti naa yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ti ichi vaꞌa ja kuu ichi Yandios, viꞌi nchaa ni kaa, ti nde kuaꞌa yɨvɨ tu ka nanduku i ichi un, chi jaku ni yɨvɨ kuu ja ka naniꞌin ichi un, ti yukan kundikun i kuankoyo i jiin. Ti nuu ndɨꞌɨ ichi un, kuu nuu najaa i nuu Yandios. Ti yukan nanitaꞌu i ja na kuncha i jiin ya ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Koto maa ra naa ra jiin yɨvɨ ka xndaꞌu ñaꞌan, ja ka kaꞌan ja ka kuu i profeta ka kaꞌan jnuꞌun Yandios un. Chi yɨñuꞌun vekoyo i nuu ra naa ra, ko añu i kuu nanu kɨtɨ xaan, chi ka ñuꞌun kuiꞌna ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ti roꞌo naa ra tu ka jini ra ndoo ka ndoꞌo ini yɨvɨ un, nu ka ndoꞌo vaꞌa ini i xi tuu. Ko jiin jniñu saꞌa i un ti kuni ra naa yɨvɨ ka kuu i. Chi na kachi ri ja tu kuu kuniꞌin yo ndeꞌe tɨkaꞌya xini ɨɨn nuꞌiñu, xi kuniꞌin yo tɨchɨ vixi xini ɨɨn nuꞌiñu xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ja yukan kuu ja taka yujnu vaꞌa kuaꞌa ndeꞌe vixi. Ti taka yujnu ka jaꞌa ndeꞌe kueꞌe tu kaji yo. Siaꞌan kuu yɨvɨ vaꞌa, chi ndoꞌo ini i saꞌa i ɨɨn jniñu vaꞌa. Ti yɨvɨ saꞌa ndevaꞌa un, mani jniñu kueꞌe ndoꞌo ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti yujnu vaꞌa un tu kuu kuaꞌa ndeꞌe kueꞌe, ni yujnu kueꞌe un, tu kuu kuaꞌa ndeꞌe vaꞌa. Yukan kuu ja ɨɨn yɨvɨ vaꞌa tu saꞌa ndevaꞌa i, ti yɨvɨ kueꞌe un nɨnɨ ka saꞌa ndevaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ti taka yujnu kueꞌe ja tu kee ndeꞌe vaꞌa xini un, kaꞌncha yo ti na kayu nuu ñuꞌun. Ti nu saꞌa yo siaꞌan jiin yujnu un, va jandaa ndixia kuu ja kuaꞌa Yandios ɨɨn nundoꞌo xaan nuu yɨvɨ kueꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ja siaꞌan kuu ja jiin jniñu ka saꞌa i un, nakuni yo naa yɨvɨ ka kuu i, ja tu kaꞌan ndaa i jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ansu tendɨꞌɨ yɨvɨ ndakuniꞌin sɨvɨ ri najaa i andɨvɨ nuu taꞌu Yandios jniñu, vasu na kachi i: “Niꞌin kuu jitoꞌo na, ti saña kuu seꞌe ni.” Yɨvɨ yukan tuu, chi nɨnɨ yɨvɨ siuku jniñu taꞌu Tata ri Yandios, ya kancha andɨvɨ. Yɨvɨ yukan ni kuu ja najakoyo. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nu na jaa kɨvɨ sandɨꞌɨ ni ga un, ti nde kuaꞌa yɨvɨ ndakuniꞌin sɨvɨ ri, ti kachi: “Niꞌin kuu jitoꞌo na, ti saña kuu seꞌe ni. Saña kuu ja ni ndiso jniñu nuu ni na ni kaꞌan na jnuꞌun ni. Ti jiin sɨvɨ ni ni ka keniꞌin na tachi xaan un kuankoyo, ti suni jiin sɨvɨ ni ni ka saꞌa na kuaꞌa ga jniñu ñaꞌnu”, kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ko yukan na ti kachi ri jini yɨvɨ un: “Jankɨvɨ ni nakuni ri roꞌo ja kuu ra seꞌe ri. Kuxio nuu ri naa ra, ti kuankoyo roꞌo, yɨvɨ ndevaꞌa”, kachi ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Siin Jesús xndaku ya, ti ni kachi ya: ―Ja yukan kuu ja yɨvɨ kuni chunsoꞌo, na chunsoꞌo i, ti na saꞌa i jniñu taꞌu ri. Ti yɨvɨ un kuu i nanu ɨɨn chaa yukun ini, ja konuꞌun xaan ni saꞌa da veꞌe da, ti kunuu teyɨɨ ni skee da yuu ka ndiso nama veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ni kii ɨɨn sau xaan, ni ndaa nducha ti ni kani ɨɨn tachi xaan jika veꞌe un, ko tu ni nduva veꞌe un, chi kunu xaan ka yɨndɨyɨ yuu ka ndiso nama veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko yɨvɨ ni jinisoꞌo ti tu ni siuku i taka jnuꞌun kaꞌan ri, kuu i nanu ɨɨn chaa ñaa ja ni jani da veꞌe da nuu ñuꞌun taꞌya. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ni jaꞌa ɨɨn sau xaan, ni ndaa yucha, ti ni nandoyo ñuꞌun un, ni kee ɨɨn tachi xaan, ti ni nduva veꞌe un kuaꞌan, ti ni naa iī ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ti so ni ka naa ini yɨvɨ ni ka ñusoꞌo jnuꞌun ni kaꞌan ya, ");
INSERT INTO mpmNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","chi ndichi xaan ni xndaku ya jnuꞌun un, ja ni ɨɨn chaa ka xnaꞌan ley Israel un, tu ka xndaku da siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nu ni nandeokuñɨ Jesús jaꞌa yuku un, ti chitu xaan yɨvɨ ni ka nandikun tuku i ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ti ni tuꞌva ɨɨn chaa jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu. Ni jakunjitɨ da nuu ya, ti ni kandaꞌu da jiin ya: ―Jitoꞌyo Jesús, nu kuni ni ti sandoo ni saña jiin kueꞌe na jaꞌa ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yukan na ti ni skaa ya ndaꞌa ya, ni keꞌe ya sɨkɨ da, ti ni kachi ya jiin da: ―Kuni ri, na ndundoo ra vijna ―ni kachi ya. Nu ni kaꞌan ya siaꞌan, ti ni nduvaꞌa ni chaa kuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ti ni xndaku ya nuu da: ―Kuaꞌan, ti koto kani ra jnuꞌun nuu ni ɨɨn yɨvɨ ja, ja ni nduvaꞌa ra. Xnakan, kuaꞌan ti kiꞌin ra nuu sutu un, na kuni da ja, ja ni nduvaꞌa ra. Ti kundaꞌa nau ja soko ra nuu Yandios, siaꞌan nava kachi ley Moisés, nava na kuni yɨvɨ ja, ja ni kenchaa ndɨꞌyɨ un roꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Nu ni jaa Jesús ñuu Capernaum, ti ni kenda ɨɨn chaa kuu capitán, ja kuu chaa yɨndaꞌa ɨɨn ciento soldado, ka yɨꞌɨ jiin ejército ñuu Roma, ti ni kandaꞌu da jiin Jesús: ―Jitoꞌyo, kancha ɨɨn muzu na veꞌe na, katuu i jito, ni kuu tɨkuku i, ti uꞌu xaan tonto i ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ti ni kachi Jesús: ―Maa ri na kin saꞌa tajna i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ti ni kachi chaa un jiin ya: ―Jitoꞌyo, kuñaꞌnu ga ni ja kuu saña, ti tu kuu kejnaꞌan na jiin ni. Ja yukan kuu ja tu kuni na ja kiꞌin ni undi veꞌe na, chi so kuni na ja na taꞌu ni jniñu, ti na nduvaꞌa muzu na. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chi saña, suni iyo ɨɨn chaa kuñaꞌnu taꞌu jniñu nuu na. Ti suni maa na, yɨndaꞌa na soldado na. Ti nu na kachi na jiin ɨɨn da: “Kuaꞌan”, ti kiꞌin da. Ti kachi na jiin ɨnga: “Ñaꞌan jaꞌa”, ti kii da. Ti taꞌu na jniñu nuu muzu na ja na saꞌa i ɨɨn jniñu un, ti saꞌa i ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu ni jinisoꞌo Jesús jnuꞌun un, so ni naa ini ya, ti ni kachi ya jiin yɨvɨ kuaꞌa kuankoyo jiin ya un: ―Jandaa na kachi ri nuu ra naa ra ja nɨ tuꞌu ñuu Israel, tu iyo ni ɨɨn yɨvɨ kandixia ruꞌu nanu ni kandixia chaa jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko na kachi ri nuu ra naa ra ja nde kuaꞌa yɨvɨ kikoyo i ichi nuu kaña jiin ichi nuu kee ndikandii, ti kɨvɨkoyo i ñuu nuu taꞌu Yandios jniñu, ti nukoo i xiin Abraham, Isaac, jiin Jacob. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko kuaꞌa yɨvɨ Israel ja ka kuni kunchuku ñuu nuu taꞌu Yandios jniñu un, keniꞌin ya maa i kinkoyo i ichi fuera ñuu un, ti koo i nundoꞌo kunchuku i. Yukan ti ndeꞌe i ja jnuꞌun kuiꞌya ini, kuꞌyu yuꞌu i, ti nakeyɨꞌɨ i jnuꞌun i ja xaan nakani ini i ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yukan na ti ni kachi ya jini chaa kuu capitán un: ―Kuanoꞌon veꞌe ra, ti na kuu siaꞌan nava ni kandixia ndaa ra ―ni kachi ya. Ti un, ni nduvaꞌa ni muzu chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yukan ti ni jaꞌan Jesús veꞌe Pedro. Ni jini ya ja katuu nana chiso Pedro nuu jito, kuꞌu ña jiin kueꞌe kiji xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ni jnɨɨ ya ndaꞌa ña, ti ni kenchaa ni kiji un maa ña. Yukan ti ni ndoko ña, ni saꞌa ña ndeyu, ni ka yee da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nu ni kuaa, ti ni ka chakoyo yɨvɨ nuu Jesús jiin tɨjnɨ xaan yɨvɨ ka jnaꞌan tachi xaan, ti jiin ɨɨn ni jnuꞌun ni kaꞌan ya, ni keniꞌin ya tachi xaan un kuankoyo. Ti suni ni ka nduvaꞌa ni taka ga yɨvɨ ka kuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yukan ni kundaa jnuꞌun Yandios nava ni kaꞌan profeta Isaías na janaꞌan, ja ni kachi da: “Maa ya ni kundaꞌu ini yoꞌo jiin kueꞌe ka jnaꞌan yo, ti ni kenchaa ya kuaꞌan”, kachi Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nu ni jini Jesús ja nde kuaꞌa yɨvɨ ni ka ndututu jiin ya, ti ni taꞌu ya jniñu nuu ndajaꞌa ya ja na kin yaꞌa da jiin ya undi ɨnga nuu yuu lago un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ti ɨɨn chaa ka xnaꞌan ley Israel un ni tuꞌva nuu ya, ti ni kachi: ―Maestro, kuni kiꞌin na jiin ni vasu savaꞌa ni ga na ichi na kiꞌin ni, ti kiꞌin yo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ti ni kachi Jesús jiin da: ―Ñukuii un chi ka iyo yau kava ka yɨꞌɨ tɨ. Ti saa un suni ka iyo taka tɨ nuu ka ndetatu tɨ. Ko ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, va sa nanu iyo nuu ndetatu tɨꞌlɨ xini ri ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ti ɨnga chaa kuu ndajaꞌa ya un ni kachi: ―Jitoꞌyo, kundatu ni na kin chunduji na tata na xnakan, ti sa chaa na, na choꞌo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ti ni kachi Jesús jiin da: ―Jini ra ja ka iyo yɨvɨ kanchuku nanu ndɨyɨ, chi tu ka chunsoꞌo i jnuꞌun Yandios. Ti sia yɨvɨ un na chunduji jnaꞌan maa i, ti ñaꞌan na choꞌo ―kachi ya jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yukan ti ni kɨvɨ Jesús ini barco, ti yɨvɨ ka skuaꞌa jiin ya, ni ka ndikun i ya kuankoyo i jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yukan ti ni ndonda ɨɨn tachi sau xaan tonto nuu lago un, ni kejaꞌa kava nuu mani ga nducha un nuu barco un. Ko Jesús chi kixi kixi ni ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ti ni ka xndoto ndajaꞌa un ya, ti ni ka kachi da: ―¡Jitoꞌyo, nama ni, yoꞌo chi naa yo. Ka kuni kekaꞌnu yo chii nducha jaꞌa! ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ko ni kachi ya jiin da: ―Ndoo xaan ka yuꞌu ra. ¿Xi ka jani ini ra ja tu chindee Yandios roꞌo naa ra nu? ―ni kachi ya. Yukan ti ni ndokuɨñɨ ya, ti ni taꞌu ya jniñu nuu tachi sau xaan un jiin lago un, ti naꞌin kuɨtɨ ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ti so ni ka naa ini chaa un, ti ka nndajnuꞌun da: ―¡Naa chaa kuu jaꞌa ja undi tachi sau xaan un, jiin lago un ka jandatu nuu da! ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nu ni yaꞌa Jesús ɨnga nuu yuꞌu lago un, nuu kuu yuꞌu ñuu Gadara. Ti undi staa stilateón nuu ka ñunduji ndɨyɨ un ni ka kendakoyo uu chaa ka jnaꞌan tachi xaan, ti ni ka chakoyo da nuu Jesús. Ti ndɨnduu da ka jnaꞌan tachi xaan un, ti kuaꞌan xaan ni ka nduu da ja ni ɨɨn yɨvɨ tukaa ga kuu yaꞌa i ichi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ti ni ka jakunchaa da ka kana koꞌo da: ―¡Niꞌin Jesús, Seꞌe Yandios! ¿Ndoo kɨvɨ nduu ni jiin na naa na, xi vaji ni ja kuaꞌa ni nundoꞌo saña nu? Vasu ti jaa ga kɨvɨ kii juicio ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ti yajni yukan ka jikonuu kuaꞌa xaan kɨnɨ ka yaji tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yukan ti ni ka kandaꞌu tachi xaan un jiin Jesús, ti ni ka kachi: ―Nu kuni keniꞌin ni saña naa na, ko kuaꞌa ni jnuꞌun ja na nandikun na kɨnɨ un naa na ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yukan ti ni kachi Jesús jini tachi xaan un: ―Kuaꞌan naa ra ―ni kachi ya. Yukan ti ni ka xndoo tachi xaan un chaa un naa da, ti ni ka kekoyo kuaꞌan, ti ni ka najnaꞌan jiin kɨnɨ un. Ni ndɨꞌɨ kɨnɨ un ni ka jaꞌa tɨ corrɨ, ti ni ka nukoyo tɨ ɨɨn xaꞌva, ti ni ka kɨvɨ tɨ nuu nducha lago un, ti ni ka kancha tɨ nducha un, ti ni ka jiꞌi tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ti chaa ka ndito kɨnɨ un ni ka yuꞌu xaan da, ni ka jaꞌa da corrɨ, ti ni ka jan kasjnuꞌun da nuu yɨvɨ ñuu un nava ni ka jnaꞌan kɨnɨ da, jiin ja ni ka jnaꞌan chaa ka jnaꞌan tachi xaan un. ");
INSERT INTO mpmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yukan na ti tendɨꞌɨ yɨvɨ ñuu un ni ka jaꞌan nuu kande Jesús. Nu ni ka jakoyo yɨvɨ un nuu Jesús, ti ni ka kachi i jiin ya ja na kee ya, ti na kiꞌin ya ñuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yukan ti ni ndɨvɨ Jesús ini barco, ni nayaꞌa tuku ya ɨnga nuu yuꞌu lago un. Ti ni najaa ya ñuu maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ti yukan ni ka jakoyo yɨvɨ jiin ɨɨn chaa ni kuu tɨkuku, katuu da nuu jito yuu. Ti nu ni jini Jesús ja ni ini da ni ka kandixia da ya ja kuu saꞌa ya tajna chaa kuꞌu un, ti ni kachi ya jiin chaa kuꞌu un: ―Ndaꞌu seꞌe ri, ndee saꞌa ni ra, chi ja iyo jnu kaꞌnu ini nuu kuachi ra ―kachi ya jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ti yukan kaꞌiin tɨjnɨ chaa ka xnaꞌan ley Israel. Ti nu ni ka jinisoꞌo da jnuꞌun ni kaꞌan Jesús jiin chaa tɨkuku un, ti ni ka kejaꞌa ka ndoꞌo ini da: “¿Xi ndaa ja ndoꞌo ini chaa un ja kuu da Yandios, ja siaꞌan kaꞌan da sɨkɨ ya”? kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ti ja ni jini Jesús ja siaꞌan ka ndoꞌo ini da, ti ni kachi ya: ―¿Ndoo ka ndoꞌo ini ra siaꞌan naa ra? ");
INSERT INTO mpmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Chi na kachi ri ja maa ri kuu Seꞌe Yɨvɨ Ñuyɨvɨ, ti ndisojniñu ri ja kuankaꞌnu ini ri nuu kuachi yɨvɨ naa i. Vijna ti na stuu ri ɨɨn jniñu saꞌa ri jaꞌa ―ni kachi ya. Yukan na ti ni kachi ya jiin chaa tɨkuku un: ―Ndoko, nastuu yuu ra, ti kuanoꞌon veꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti ni ndoko chaa tɨkuku un, ti kuanoꞌon da veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nu ni ka jini yɨvɨ un, ti ni ka naa ini i ja siaꞌan ni saꞌa ya. Ti ni ka kuvaa i ni ka nakanajaa i Yandios ja siaꞌan ni jaꞌa ya jniñu ñaꞌnu un nuu ɨɨn chaa. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ni kee Jesús yukan ti kuaꞌan ya, ti ni jini ya ɨɨn chaa nani Mateo, nukoo da nuu kinyaꞌu da puestu, ti ni kachi ya jiin da: ―Ñaꞌan na choꞌo, ti kundikun ra ruꞌu ―ni kachi ya. Yukan ti ni ndokuɨñɨ ni chaa un, ti kuaꞌan da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti nu ni jaa Jesús veꞌe Mateo yukan ni yee ya staa. Ti kuaꞌa xaan chaa ka kinyaꞌu puestu ni kuꞌiin un, jiin tɨjnɨ chaa tu ka siuku ley Israel. Kanchuku da jiin ya nuu mesa ka yee da staa, jiin taka ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ko nu ni ka jini chaa fariseo yukan, ti ni ka jikajnuꞌun da ndajaꞌa ya, ti ni ka kachi da: ―¿Ndoo kuu ja yaji maestro ra staa jiin chaa ka kinyaꞌu puestu un jiin taka chaa tu ka siuku ley Israel yukan? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ni jinisoꞌo Jesús ja siaꞌan ni ka kaꞌan chaa un, ti ni kachi ya jiin da: ―Yɨvɨ ka iyo ndendajnu tu ka nandɨꞌɨ i chaa tajna, chi yɨvɨ ka kuꞌu kuu ja ka nandɨꞌɨ ɨɨn médico. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuanoꞌon naa ra ti skuaꞌa ra nasa kuni kaꞌan jnuꞌun jaꞌa: “Ruꞌu kuni ri ja na kuankaꞌnu ini nuu jnaꞌan ra naa ra, ti ansu ja soko ra kɨtɨ naa ra.” Chi ansu vaji ri ja kaꞌan ri jnuꞌun Yandios nuu yɨvɨ ka jani ini ja iyo ndoo jiin kuachi i. Chi suꞌva ni chaa ri ja na kaꞌan ri jnuꞌun Yandios nuu yɨvɨ ka nakuni ja ka iyo kuachi i, nava na nakani ini i nuu Yandios ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yukan ti ni ka chakoyo ndajaꞌa Juan, chaa skuanducha un, nuu Jesús, ti ni ka jikajnuꞌun da ya: ―¿Ndoo saña naa na jiin chaa fariseo, xaan tɨjnɨ jinu ka kendo ndicha ini na, ti ndoo ndajaꞌa ni, ndoo tu ka kuu koo ndicha ini da naa da? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yukan ti ni kachi Jesús: ―¿Va nu kuu koo ndicha ini yo nu iyo ɨɨn viko nandaꞌa, ti tu kusɨɨ ini yo nu kancha novio un jiin yo nu? Ko nu na jaa kɨvɨ ja kuxio novio un kiꞌin da, yukan na ti sa kuu koo ndicha ini yɨvɨ un naa i. Suni siaꞌan kuu ja nu nɨ kancha ri ti tu kuu koo ndicha ini chaa ka skuaꞌa jiin ri. Ko jaa ɨɨn kɨvɨ nu na kuxio ri kiꞌin ri, yukan na ti sa na koo ndicha ini da naa da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Siin Jesús xndaku ya ja tu kejnaꞌan jnuꞌun jaa ja xnaꞌan ya, jiin jnuꞌun janaꞌan, ti ni kachi ya: ―Tu kuu nachaa yo saꞌma tuꞌu jiin ɨɨn saꞌma jaa, chi ndɨyɨ saꞌma jaa un ti kaꞌncha saꞌma tuꞌu un, ti suꞌva kuu jicha ga teꞌnde kiꞌin. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni tu kuu chuꞌun yo vino jaa chii ɨɨn ñɨɨ tuꞌu, chi vino jaa un ndata ñɨɨ tuꞌu un, ti xnaa yo ndɨnduu. Ja yukan kuu ja na chuꞌun yo vino jaa chii ñɨɨ jaa un, ti siaꞌan ni ɨɨn ni ɨɨn tu xnaa yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ni kaꞌan ga Jesús jnuꞌun un, ti ni jaa ɨɨn chaa kuñaꞌnu ini ɨɨn veñuꞌun Israel un, ni jakunjitɨ da nuu Jesús, ti ni kachi da: ―Ja ni jiꞌi seꞌe sɨꞌɨ na, ko nu na kiꞌin yo, ti chuxndee ni ndaꞌa ni sɨkɨ i, ti va nandoto tuku i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ni ndokuɨñɨ Jesús ti kuaꞌan ya jiin chaa un jiin ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ti yukan kuaꞌan ɨɨn ñasɨꞌɨ ja ja ni kuu uxi uu kuiya jnaꞌan ña kueꞌe nɨñɨ. Ni tuꞌva ña ichi jata Jesús ti ni kueꞌe ña saꞌma ya, ");
INSERT INTO mpmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","chi ni ndoꞌo ini ña: “Nu na kundee ri kueꞌe ri vasu saꞌma ya, ti va nduvaꞌa ri”, siaꞌan ni ndoꞌo ini ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ko ni ndeokoto Jesús, ni ndeꞌe ya nuu ña, ti ni kachi ya: ―Ndee saꞌni ra hija, ja ni nduvaꞌa ra chi ni kandixia ra ruꞌu, ja kuu saꞌa ri tajna maa ra ―ni kachi ya. Ti yukan un ni nduvaꞌa ni ñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nu ni jaa Jesús veꞌe Jairo, chaa kuñaꞌnu un, ti ni jini ya ja, ja ka iyo tuꞌva música ja kin chunduji da ndɨyɨ lulu un, ti yɨvɨ kaꞌiin un ka kanajiin koꞌo i ja ka ndeꞌe xaan i, ");
INSERT INTO mpmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ti ni kachi ya: ―Kuan kee naa ra fuera un, chi tu ni jiꞌi suchi lulu jaꞌa, chi so kixi i ―kachi ya. Ti yɨvɨ kaꞌiin un so ni ka jaku i ja siaꞌan ni kaꞌan Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko ni keniꞌin Jesús maa i kuankoyo i ichi fuera, ti ni kɨvɨ ya ini veꞌe un, ni jnɨɨ ya ndaꞌa ñaꞌan lulu un, ti ni ndoko i. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yukan na ti nɨ tuꞌu ñuu un ni jichanuu jnuꞌun Jesús ja siaꞌan ni kuu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nu ni kee Jesús yukan ti kuaꞌan ya, ti ni ka ndikun uu chaa kuaa jata ya, ti ka kanajiin da kuajakoyo da: ―¡Kundaꞌu ini ni saña naa na, niꞌin ja kuu seꞌe David, chaa ni kuu rey Israel undi na janaꞌan! ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ti nu ni jakuɨñɨ Jesús ɨɨn veꞌe, ni ka tuꞌva chaa kuaa un nuu ya, ti ni jikajnuꞌun ya maa da naa da, ti ni kachi ya: ―¿Kandixia ra naa ra ja kuu saꞌa ri jniñu jaꞌa nu? ―kachi ya. Ti ni ka kachi da: ―Jitoꞌyo, ka kandixia na ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yukan ti ni kueꞌe Jesús nduchi da naa da, ti ni kachi ya: ―Na kuu nava ni ka kandixia ra naa ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ti ni ka nduvaꞌa ni nduchi chaa un naa da. Yukan na ti niꞌin xaan ni taꞌu ya jniñu nuu da naa da, ja tu kani kutɨ da jnuꞌun nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko jiꞌi ni ni ka kee da kuaꞌan da, ti ni ka jani ni da jnuꞌun nuu taka yɨvɨ ñuu un jniñu ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","San ni ka kee chaa un kuankoyo da, ti ni ka chakoyo tuku uu ga da jiin ɨɨn chaa ñɨꞌɨn, ti chaa un suni jnaꞌan da tachi xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu ni keniꞌin Jesús tachi xaan un kuaꞌan, ti ni kejaꞌa kaꞌan chaa ñɨꞌɨn un, so ni ka naa ini yɨvɨ kaꞌiin un, ti ni ka kachi: ―Jankɨvɨ ka jini yo ɨɨn jniñu siaꞌan, ja kuu nuu nɨ ñuu Israel ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko ni ka kachi chaa fariseo un: ―Keniꞌin chaa jaꞌa tachi xaan un kuaꞌan, ko jiin sɨvɨ maa jaꞌuꞌu un saꞌa da ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ni jikonuu Jesús taka ñuu jiin taka ranchu xnaꞌan ya ini veñuꞌun Israel jiin taka ñuu, xndaku ya ja nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios, ti taꞌu ya jniñu nuu i. Ti kenchaa ya taka nuu kueꞌe ja ka jnaꞌan yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ni ndeꞌe ya nuu yɨvɨ un ti ni kundaꞌu ini ya naa i, chi nde ndaꞌu ka saꞌa i, ja ka kuu kuiꞌya ini i. Chi ka kuu i nanu rɨɨ ni ka jichanuu, ti ni ka sana tɨ nanu ja ni ka skuita tɨ jitoꞌo tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yukan na ti ni kachi ya jiin ndajaꞌa ya: ―Jniñu Yandios kuu nanu kɨvɨ ka nastutu yo triu, chi jandaa ndixia kuu ja, ja ni kuu teꞌnde triu un ko jaku ni muzu ka iyo ja sajniñu un. Siaꞌan kuu yɨvɨ jaꞌa naa i, chi ndaꞌu ka saꞌa i ja tundo xndaku nuu i, chi ka kumani chaa xndaku un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yukan kuu ja kaꞌan ri ja kakantaꞌu nuu maa Yandios naa ra, chi maa ya kuu ja xiin jniñu un, ti na chuꞌun ya muzu na nastutu jniñu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yukan na ti ni nastutu Jesús ndɨ uxi uu ndajaꞌa ya ja na kujiin da jiin ya, ti ni jaꞌa ya jniñu ñaꞌnu nuu da naa da, ja na kuu keniꞌin da tachi xaan jiin ja na kenchaa da taka nuu kueꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaꞌa ka kuu sɨvɨ ndɨ uxi uu ndajaꞌa Jesús. Xnakan ni nakaji ya Simón, ja suni nani da Pedro, jiin ñani da Andrés; Jacobo jiin ñani da Juan, ja ka kuu da seꞌe yɨɨ Zebedeo; ");
INSERT INTO mpmNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe; Bartolomé; Tomás; Mateo ja ni kuu da chaa kinyaꞌu puestu un; Jacobo ja kuu seꞌe yɨɨ Alfeo; Lebeo ja suni nani da Tadeo; ");
INSERT INTO mpmNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, chaa ni yɨꞌɨ jiin partido Kananista; jiin Judas, ɨɨn chaa ñuu Cariote ja kuee ga ti ni nakuaꞌa da Jesús nuu enemigo ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ni taji Jesús ndɨ uxi uu chaa un, ko xnakan ni xndaku ya nuu da, ti ni kachi ya: ―Koto kinkoyo ra ñuu nuu tu kanchuku yɨvɨ ka kuu yɨvɨ Israel, ni tu kɨvɨ ra ni ɨɨn ndañu Samaria naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kuankoyo nuu kanchuku yɨvɨ nación Israel, chi ka kuu i nanu rɨɨ ni ka sana, ti siaꞌan tu ka chaku ini i na ichi kuankoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ti kani ra jnuꞌun nuu yɨvɨ un ja, ja ni jaa kɨvɨ nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Saꞌa ra tajna yɨvɨ ka kuꞌu, ti na xndoto ra yɨvɨ ni ka jiꞌi. Suni saꞌa ra tajna yɨvɨ ka jnaꞌan ndɨꞌyɨ teꞌyu nava na ndundoo i. Ti keniꞌin ra tachi xaan naa ra na kinkoyo. Ti koto maa kinyaꞌu ra nu ni kuu ni ka saꞌa ra taka jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ichi kinkoyo ra tu kundaꞌa ra oro, ni plata, ni cobre naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni tu kundiso ra ñunu staa ja kuu ichi ra. Vajnuꞌun ni camisa kuu ja kuꞌun ra naa ra, ti tu kundaꞌa ra ndijña ni yujnu xii. Tu kundiso ra taka un, chi ɨɨn chaa saꞌa jniñu nɨnɨ kuu ja niꞌin da ja kaji da. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nu ni jakoyo ra ɨɨn ñuu xi ɨɨn ranchu, nduku ɨɨn veꞌe nuu kanu ini ra yɨvɨ, ti yukan kunchuku ra undi sa kinkoyo ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu ni ka kɨvɨ ra veꞌe un naa ra, kanxiaꞌu ra jiin yɨvɨ un, ja na kukuee kunchuku i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu ka iyo vaꞌa ini yɨvɨ un, ti kakantaꞌu ja na kukuee kunchuku i. Ti nu tuu, ti nduku ra ɨnga veꞌe nuu kunchuku ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ti taka yɨvɨ ja tu ka jaꞌa veꞌe un, ni tu ka chunsoꞌo jnuꞌun Yandios ka kaꞌan ra, kekoyo veꞌe yɨvɨ un jiin ñuu i. Nu ni kekoyo ra ñuu un, ti kɨsɨ tɨkacha ini ndijña ra naa ra, ti yukan na kuu ɨɨn seña ja tu ni ka kandixia yɨvɨ un jnuꞌun ni ka kaꞌan ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Chi na kachi ri nuu ra naa ra, ja nu na jaa kɨvɨ chaa juicio, ti kaꞌnu ga nundoꞌo kii sɨkɨ yɨvɨ ñuu un, ti ansu yɨvɨ ñuu Sodoma jiin Gomorra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Siin Jesús xndaku ya, ti ni kachi ya: ―Ndeꞌe naa ra, ruꞌu taji ri roꞌo kinkoyo ra nanu rɨɨ kuankoyo nuu kaꞌiin kɨtɨ xaan. Kava vivo ra naa ra, ko so ja koto maa ɨɨn ja saꞌa ra jiin yɨvɨ. Kuee kava ini ra naa ra nanu ɨɨn sata, ja tu nduxaan tɨ. Ti siaꞌan kunchuku ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ko ndeꞌe ra naa ra, chi jnɨɨ yɨvɨ presu roꞌo, ti nakuaꞌa roꞌo nuu chaa ka kuñaꞌnu un naa ra, ti kuaꞌa chaa un tau ra ini veñuꞌun Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ti sɨkɨ ja ka jika ra jiin ri, ti nakuaꞌa da roꞌo vasu undi nuu gobernador xi nuu rey, ko vasu undi nuu chaa un, ti suni kuu kaꞌan ra jnuꞌun ri jiin nuu yɨvɨ ɨnga nación. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu ni ka jnɨɨ da presu roꞌo, ti nakuaꞌa da roꞌo nuu chaa ka kuñaꞌnu un, ti koto ma xndiꞌi ra ini ra naa ra, ja nasa koo jnuꞌun kaꞌan ra naa ra, chi nu na jaa nuu kaꞌan ra, ti maa Yandios na kachi nasa koo jnuꞌun kaꞌan ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Chi ansu roꞌo kuu ja kaꞌan, chi Espíritu maa Yandios kuu ja kuaꞌa jnuꞌun kaꞌan ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Chi yɨvɨ tu ka kandixia, chakuachi jnaꞌan i jiin ñani i, ti nakuaꞌa i da ja na kuū da. Ti suni chaa ka kuu tata, chakuachi da seꞌe da, ti nakuaꞌa da chaa ja na kuū da. Ti suni seꞌe un, chakuachi i tata i, ti nakuaꞌa i da ja na kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ja yukan kuu ja nde kuaꞌa yɨvɨ koto uꞌu roꞌo sɨkɨ ja ka yɨꞌɨ ra jiin ruꞌu, ko taka yɨvɨ ka siuku ndaa, vasu na kuui ja sɨkɨ ruꞌu, ko taka nanitaꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko nu ɨɨn ñuu na koto uꞌu yɨvɨ roꞌo naa ra, kuankoyo ɨnga ñuu. Ti na kachi ndaa ri nuu ra naa ra ja ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, xnaka ja nchaa ri ti sa ndekava ra kuikonuu ra taka ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ndeꞌe naa ra, ja ka jini ra ja ni ɨɨn ndajaꞌa tu kuu kuñaꞌnu ga ja kuu chaa yɨndaꞌa da, ti ni ɨɨn chaa junukuachi tu kuu kuñaꞌnu ga da ja kuu jitoꞌo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Chi nu na saꞌa ndevaꞌa yɨvɨ jiin maa chaa kuñaꞌnu un, ti suni siaꞌan saꞌa i jiin chaa ka kuu taka ndajaꞌa da. Ti nu ka skonani i ruꞌu Beelzebú (ja kuni kaꞌan jaꞌuꞌu kuñaꞌnu), ti ndee ga ja nu tu kaꞌan i sɨkɨ roꞌo naa ra ja ka kuu ra ndajaꞌa ri ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Siin Jesús xndaku ya, ti ni kachi ya: ―Ja yukan kuu ja koto yuꞌu ra ndeꞌe ra yɨvɨ kanda kuaꞌan un, chi tu iyo ni ɨɨn jniñu saꞌa xeꞌe i ja na kendo saꞌyɨ nuu Yandios, chi taka ni kenda nuu ndijin. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko jnuꞌun xnaꞌan ri nuu maa ni ra jaꞌa naa ra, ti kaꞌan ra taka nuu kanchuku yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ti koto yuꞌu ra ndeꞌe ra yɨvɨ ka jaꞌni yɨkɨ kuñu, chi tu niꞌin i añu ra ja kaꞌni i. Ko maa Yandios kuu ja koyuꞌu ra, chi maa ya kuu ja jaꞌni yɨkɨ kuñu nɨ jiin añu nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Maa Yandios kuu ja na kachi nasa koo jiin maa ra naa ra. Jini ndaa yo yukan, chi undi saa kuachi un, jito vaꞌa ya tɨ, ja ni ɨɨn tɨ tu kanakava nuu ñuꞌun nu tu kachi maa Tata ra Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ti ja roꞌo naa ra, chi undi ixi xini ra ni kaꞌu ya ndɨ ɨɨn ndɨ ɨɨn. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ja yukan kuu ja koto xndɨꞌɨ ini ra, chi yaꞌu ga ka nchaa ɨɨn ɨɨn ra nuu Yandios ja kuu ɨɨn jnɨɨ saa kuachi un naa tɨ ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Siin Jesús xndaku ya, ti ni kachi ya: ―Taka yɨvɨ nu na kachi ndaa ja ni ka yɨꞌɨ i jiin ri, ti suni ruꞌu nakachi ndaa ri nuu Tata ri, ya kancha ya andɨvɨ, ja jini ri maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ko nu na chisaꞌyɨ i ruꞌu nuu yɨvɨ, ti suni ruꞌu kachi ri ja tu jini ri yɨvɨ un nuu Tata ri, ja kancha ya andɨvɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Tu kani ini ra naa ra ja ni chaa ri ñuyɨvɨ jaꞌa, ti saꞌa ri ja na kukuee kunchuku mani yɨvɨ naa i. Chi ni chaa ri, ko so ja nu na kandixia i ruꞌu, ti koto uꞌu jnaꞌan yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Koto uꞌu ɨɨn seꞌe yɨɨ nuu tata da, ti suni ɨɨn seꞌe sɨꞌɨ koto uꞌu ña nuu nana ña, ti seꞌe janu un koto uꞌu ña nuu nana chiso ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ja siaꞌan kuu ja nu na kandixia yɨvɨ ruꞌu, ti koto uꞌu jnaꞌan maa i ini veꞌe i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nu ñukuu ini ra ruꞌu, ko nu kundaꞌu ga ini ra tata ra jiin nana ra, ja siaꞌan ti tukaa ga yɨꞌɨ ra jiin ri. Suni nu ka kundaꞌu ga ini ra seꞌe sɨꞌɨ ra xi seꞌe yɨɨ ra, ti suni tukaa ga ka yɨꞌɨ ra ndaꞌa ri naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ti nu tu ka ñukuu ini ra ruꞌu ja kundikun ra ruꞌu, ti vasu na kuū ra, ko tukaa ga ka yɨꞌɨ ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chi taka yɨvɨ ka kuni nama i maa i nuu ñuyɨvɨ jaꞌa, ti tukaa nanitaꞌu i ja kuu saa ni. Ko nu na nakani ini i ti xndoo i taka un ja na kundikun i ruꞌu, ti nanitaꞌu i ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nu ɨɨn yɨvɨ na kuantaꞌu jnuꞌun ri ja ka kaꞌan ra, ti suni jantaꞌu i maa ri. Ti yɨvɨ jantaꞌu ruꞌu, suni ja ni jantaꞌu i Tata ri, ya ni taji ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ti ɨɨn yɨvɨ nu na kuantaꞌu i jnuꞌun Yandios ja kaꞌan ɨɨn profeta, ti suni niꞌin i taꞌu i nanu ni niꞌin profeta un. Ti nu ɨɨn yɨvɨ na kuantaꞌu i ɨɨn chaa vaꞌa ja ni yɨꞌɨ da jiin ruꞌu, ja so ja kuu da chaa vaꞌa, suni niꞌin da taꞌu da nanu niꞌin chaa vaꞌa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ti vasu savaꞌa ni ga yɨvɨ nu na kuaꞌa i ɨɨn vasu nducha vijin nuu chaa ndaꞌu ja ka ndikun da ruꞌu, ti na kachi ndaa ri ja suni iyo taꞌu yɨvɨ un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu ni ndɨꞌɨ ni xndaku Jesús nuu ndɨ uxi uu ndajaꞌa ya, ni kee ya kuan xnaꞌan ya nuu yɨvɨ ñuu kaꞌiin yajni un. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti Juan, chaa ni skuanducha un, ja kande da vekaa. Ti nu kande da un, ni niꞌin da jnuꞌun taka jniñu saꞌa Cristo. Yukan ti ni taji da uu chaa ka jika jiin da un kuankoyo da nuu kande Jesús, ");
INSERT INTO mpmNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ti ni ka jikajnuꞌun da ya siaꞌan: ―¿Maa ni kuu Cristo ja ni chisojnuꞌun Yandios ja kii nu? ¿Xi kundatu yo ɨnga nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yukan ti ni kachi Jesús: ―Kuankoyo naa ra ti kani jnuꞌun nuu Juan naa ra taka ja ni ka jini ra jiin taka jnuꞌun ni ka jinisoꞌo ra jaꞌa naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kani jnuꞌun nuu da ja ka ndundijin nduchi chaa kuaa un, jiin ja ka ndokaka chaa tɨkuku un, jiin ja ka ndundoo chaa ka jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu un. Suni chaa soꞌo un ka ndundijin soꞌo da, jiin ja ka nandoto ndɨyɨ naa i, jiin ja kuu nuu yɨvɨ ndaꞌu kaꞌan ri jnuꞌun Yandios nasa nanitaꞌu i ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ti kachi jiin da ja kandichi Yandios jiin yɨvɨ tu ka yuꞌu i kundikun i ruꞌu, vasu na koo ndoꞌo koo nene i ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nu ni ka yaꞌa chaa un kuaꞌan da, ti ni kejaꞌa Jesús kaꞌan ya jiin yɨvɨ un ja na chaa kuu Juan, ti ni jikajnuꞌun ya: ―Na ni ka jandeꞌe ra undi nuu ñuꞌun teꞌe un, ¿ndoo ka ndoꞌo ini ra ja saꞌa chaa un? Ti tu ni ka jini ra ɨɨn chaa un nanu ɨɨn yoko icha ja kanda jiin tachi un, ti chaa un tu ni sama nuu nuu da jnuꞌun kaꞌan da, chi ɨɨn ni jnuꞌun ni kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ti nu ni ka jandeꞌe ra yukan, ¿Xi ni ka jini ra ja ñuꞌun chaa un saꞌma vaꞌa nu? Chi na kachi ri ja yɨvɨ ka ñuꞌun saꞌma fino kanchuku da veꞌe chaa ka kuu rey. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ti ndoo ni ka jandeꞌe ra nusa? ¿Xi ka jani ini ra ja maa da kuu profeta ja kaꞌan jnuꞌun Yandios nu? Ti jandaa ndixia kuu ja maa da kuu da ɨɨn profeta ja kaꞌan da jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ti sɨkɨ Juan kuu ja kaꞌan nuu tutu ii Yandios siaꞌan: Na taji ri tajnu ri ja na koxnuu da jaa da. Ti na satuꞌva da yɨvɨ naa i sa kiꞌin ra. Ni kachi Yandios, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jandaa na kachi ri ja tukaa ga iyo ni ɨɨn yɨvɨ nanu Juan ja kuñaꞌnu ga ja kuu Juan, chaa skuanducha un. Ko yɨvɨ ja, ja ni ka jantaꞌu jnuꞌun sɨkɨ ja nasa kɨvɨ i ndaꞌa Yandios, ti taꞌu Yandios jniñu nuu i, vasu tu ka ndiso jniñu i nanu Juan, ko kuni ga yɨvɨ un jniñu ñaꞌnu ga ja saꞌa ya ansu maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Undi na ni chaa Juan, chaa skuanducha un, ti undi vijna, uꞌu xaan sa ka kandixia yɨvɨ jnuꞌun kaꞌan ri ja na kuu kɨvɨ i ndaꞌa Yandios, ti taꞌu ya jniñu nuu i. Ti nɨnɨ yɨvɨ ka ñukuu xaan ini, yukan ni kuu ja kuu kɨvɨkoyo i ndaꞌa ya, ti taꞌu ya jniñu nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Taka profeta, chaa ni ka kaꞌan jnuꞌun Yandios jiin jnuꞌun kaꞌan ley Moisés un, chaa yukan ni ka kaꞌan jnuꞌun sɨkɨ ñuu nuu taꞌu Yandios jniñu, sa ni chaa Juan. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ti nu ka kuni kandixia ra naa ra ja Juan kuu maa profeta ja saꞌa jniñu nanu ni saꞌa profeta Elías na janaꞌan, nava yoso nuu tutu Yandios ja kii. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yɨvɨ ka kuni chunsoꞌo, na chunsoꞌo i jnuꞌun jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jaꞌa na kachi ri jiin nau ja skejnaꞌan ri yɨvɨ kanchuku kɨvɨ vijna. Chi yɨvɨ ka iyo vijna ka kuu i nanu suchi kuachi nu ni ka nukoo i nuu yaꞌu ja ka yɨsɨkɨ i, ti ka kana xini jnaꞌan i, ");
INSERT INTO mpmNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ka tɨvɨ yo xkili, ko tu ni ka jitajaꞌa i. Ti kuaka xaan ni ka jita yo ɨɨn yaa, ko tu ni ka ndeꞌe i”, ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Siaꞌan kuu kɨvɨ vijna, chi ni kii Juan, ni kuncha da. Tu ni jiꞌi da ndɨxɨ, ti iyo nasa xndondicha da ini da. Ti roꞌo ni ka kaꞌan ra ja ni yɨꞌɨ da jiin ɨɨn tachi xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yukan na ti ni chaa tu ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, ja yaji ri ti jiꞌi ri, ti ka chakuachi ra ruꞌu ja yaji xaan ri ti jiꞌi xaan ri vino, ti kuu ri amigo chaa ka kinyaꞌu puesto. ¿Nusa ti tu ni ka kandixia ra jniñu ni saꞌa Juan, ni tu ni ka kandixia ra jniñu ni saꞌa tu ruꞌu nu? Ko tundo saꞌa, chi yɨvɨ tuꞌva, ka jini i ja iyo vaꞌa savaꞌa ni ga jniñu ni taꞌu Yandios nuu ri jiin Juan ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yukan ti ni kejaꞌa Jesús kankuachi ya sɨkɨ yɨvɨ ñuu nuu ni saꞌa ya kuaꞌa jniñu ñaꞌnu un, chi taka yɨvɨ ñuu un, tu ni ka nakani ini i nuu kuachi i, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Na xaan ga xndaꞌu roꞌo, yɨvɨ ñuu Corazín! ¡Na xaan ga xndaꞌu roꞌo, yɨvɨ ñuu Betsaida! Sa ti ñuu Tiro jiin ñuu Sidón ni saꞌa ri taka jniñu ñaꞌnu un nava ni saꞌa ri nuu ñuu ra naa ra, va ja ni kuu jnaꞌan ni ka nakani ini yɨvɨ un nuu kuachi i niku. Ti kuꞌun i saꞌma ndayɨ, ti nakuchi i yaa ja na kuu seña i ja ni ka nakani ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko na kachi ri ja kɨvɨ nu na chaa juicio ti niꞌin ga kii nundoꞌo sɨkɨ ra naa ra ja kuu yɨvɨ ñuu Tiro jiin Sidón. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ti roꞌo, yɨvɨ ñuu Capernaum, ¿ka jani ini ra ja ni nduñaꞌnu ga ñuu ra nu? Tuu, chi suꞌva ni nukuu ga ñuu ra, ti ndundaꞌu ga ra ja kuu taka ga ñuu. Sa ti taka jniñu ñaꞌnu ni saꞌa ri ñuu ra jaꞌa, ni saꞌa ri ñuu Sodoma niku, va ni siin ga ñuu un undi vijna niku. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko na kachi ri nuu ra naa ra ja kɨvɨ nu na chaa juicio, ti roꞌo kuu ja niꞌin ga kii nundoꞌo sɨkɨ ra ja kuu sɨkɨ yɨvɨ ñuu Sodoma ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti kɨvɨ jña ni jikantaꞌu Jesús nuu Tata ya Yandios, ti ni kachi ya: ―Nakanajaa na niꞌin, niꞌin ja kuu ni Tata na, ti maa ni yindaꞌa andɨvɨ jiin ñuyɨvɨ. Nakutaꞌu na nuu ni, chi tu ni stuu ni taka jnuꞌun vaꞌa un nuu chaa tuꞌva un, ko ni stuu ni jnuꞌun un nuu yɨvɨ ndaꞌu ja ni ka nakani ini. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ni kuu siaꞌan, chi siaꞌan ni kuu ini maa ni ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti ni siin Jesús xndaku ya nuu yɨvɨ un, ti ni kachi ya: ―Tata ri, ni nakuaꞌa taka jniñu jaꞌa nuu ri. Ti maa ni ya kuu ja jini ndaa kuɨtɨ nava ndoꞌo inijnuni ri, ja kuu ri Seꞌe maa ya. Ti suni ruꞌu, ja kuu ri Seꞌe ya, jini ndaa kuɨtɨ ri inijnuni maa ya, ja maa ya kuu Tata ri Yandios. Ti maa ɨɨn ni ruꞌu, ja kuu ri Seꞌe ya, kuu ja xnaꞌan nuu yɨvɨ nasa kaa maa Tata yo Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñaꞌan nuu ri naa ra roꞌo ja ka ndɨꞌɨ ini, ti ka nduku ra ichi kiꞌin ra ja na kenchaa kuachi ra, ti ruꞌu na nama roꞌo naa ra, ti tukaa kondoꞌo ra jiin kuachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jaꞌa kuu nanu ɨɨn yugo ja chuxndee yo xini yunta nu ka saꞌa tɨ jniñu, ti suni siaꞌan na kuaꞌa ri ɨɨn jniñu nuu ra, ti tu yɨɨ jniñu un, ja tu kuu saꞌa ra. Chi so ja na chunsoꞌo ra jnuꞌun kaꞌan ri, ti kuandatu ra nuu jnuꞌun un. Chi ruꞌu, vaꞌa ini ri jiin ra naa ra, ti ñundaꞌu ini ri ja nama ri roꞌo jiin añu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɨɨn jniñu taya kuu ja kuaꞌa ri nuu ra, ti tu niꞌin iyo ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ti kɨvɨ jña kuaꞌan Jesús jiin ndajaꞌa ya, ɨɨn kɨvɨ ndetatu, ti ni yaꞌa ya ɨɨn ñuꞌun nuu kaa triu. Ti ndajaꞌa ya, ni ka kejaꞌa da ka jnuꞌun da yoko triu. Ka skoyo da ti ka yee da triu un, chi ka jiꞌi da soko. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ti nu ni ka jini chaa fariseo un, ti ni ka kachi da jiin Jesús: ―Ndeꞌe, ¿ndoo ka saꞌa ndajaꞌa ra jniñu ja tu iyo vaꞌa ja saꞌa yo kɨvɨ ndetatu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ti ni kachi ya: ―¿Xi tu ni ka skuaꞌa ra ɨɨn tutu nava ni ka jnaꞌan David ɨɨn kɨvɨ na ni ka jiꞌi da soko, jiin uu ga jnaꞌan da nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jini ra ja ni ka kɨvɨ da ini veꞌe ii Yandios, ti ni ka yee da staa stila ii un, ja ni maa da jiin uu ga jnaꞌan da un, tu kuu kaji da naa da, chi nɨnɨ sutu un kuu ja ka yee staa stila un niku. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Xi tu ka skuaꞌa ra nuu ley Moisés, nuu kachi ja ni sutu un, tu ka ndetatu da ja kuu kɨvɨ ndetatu, ti ansu suni ɨɨn kuachi kuu un nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ko na kachi ri nuu ra, ja vijna ti iyo ɨɨn ja kuñaꞌnu xaan ga ja kuu sutu ka kuñaꞌnu ini veñuꞌun kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ko maa ra naa ra, tu ka chaku ini ra ndoo kuni kaꞌan junuꞌun ja yoso nuu tutu ii, ja ni kaꞌan Yandios: “Ruꞌu, kuni ri ja na kuankaꞌnu ini nuu jnaꞌan ra naa ra, ti ansu ja ka soko ra kɨtɨ nuu Yandios”, ni kachi ya. Sa ti ka chaku ini ra jnuꞌun un naa ra, ti va tu chakuachi ra yɨvɨ naa i ja ka iyo falta i. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chi ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kuñaꞌnu ga ri, ti taꞌu ri jniñu nuu kɨvɨ ndetatu jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yukan ti na kuaꞌan Jesús, ni jaa ya ɨɨn veñuꞌun Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ti yukan kande ɨɨn chaa ni ichi ɨɨn ndaꞌa da. Ko vanuxia chaa fariseo un ka nduku da nasa chakuachi da Jesús, ti ni ka jikajnuꞌun da ya: ―¿Kuu saꞌa yo tajna ɨɨn yɨvɨ kuꞌu ja kuu kɨvɨ ndetatu nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ti ni kachi Jesús: ―Nu nau roꞌo ka ñavaꞌa ɨɨn lélú, ti nu na kinikava tɨ ɨɨn yau ja kuu ɨɨn kɨvɨ ndetatu, ¿ti tu kin tava ra tɨ nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ti ansu yaꞌu ga nchaa ɨɨn yɨvɨ ja kuu lélú un nu? Ja yukan kuu ja na kachi ri ja kuu saꞌa yo ɨɨn jniñu vaꞌa ja kuu kɨvɨ ndetatu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yukan ti ni kachi ya jiin chaa ni ichi ndaꞌa un: ―Skaa ndaꞌa ra ―kachi ya. Ti nu ni skaa chaa un ndaꞌa da, ti ni nduvaꞌa ni nanu kaa ndaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti ni ka kekoyo chaa fariseo un kuaꞌan da, ti ni ka kejaꞌa ka ndajnuꞌun da nasa kuu kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nu ni jini Jesús nava ka ndoꞌo ini chaa fariseo un, ni kee ya yukan ti kuaꞌan ya. Ko kuaꞌa xaan yɨvɨ kuankoyo jiin ya, ti ni saꞌa ya tajna tɨjnɨ yɨvɨ ka kuꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ko niꞌin xaan ni xndaku ya nuu yɨvɨ un ja tu kani da jnuꞌun nau ja kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yukan ti ni kundaa jnuꞌun ni kaꞌan profeta Isaías na janaꞌan, na ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Chaa junukuachi nuu ri jaꞌa, kuu ja ni nakaji ri. Chaa jaꞌa kuu ja kundaꞌu ga ini ri, ti kusɨɨ ini ri jiin da. Kuaꞌa ri Espíritu ri nuu da, ti xndaku da nuu taka nación ja nau kuu maa jnuꞌun ndaa, ti na kuandatu yɨvɨ jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ni tu kava vixi ini maa da, ni tu kachi da nuu ni ɨɨn yɨvɨ nau ja kuu da. Ti ni ɨɨn yɨvɨ tu nakuni i ndusu yuꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tu kuaꞌa da nundoꞌo nuu taka ñuu ndaꞌu, chi suꞌva kuaꞌa da jnundee ini undi kɨvɨ na kiꞌin da jniñu ñaꞌnu da, ti taꞌu da jniñu nava iyo. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ti kɨvɨ un sa na kandixia ndaa yɨvɨ taka nación maa da. Siaꞌan ni kachi profeta Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yukan ti ni ka janchaka da ɨɨn chaa kuaa ja suni ñɨꞌɨn da, ti jnaꞌan da tachi xaan. Ni saꞌa Jesús tajna chaa un, ti ni kuu ndeꞌe da, ti ni kuu kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tendɨꞌɨ yɨvɨ un ni ka naa ini, ti ni ka kachi: ―¿Xi jaꞌa kuu Seꞌe rey David ja ni jiꞌi undi na janaꞌan nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ko nu ni ka jinisoꞌo chaa fariseo jnuꞌun un, ti ni ka kachi da: ―Keniꞌin chaa jaꞌa tachi xaan un kuankoyo, ko jiin sɨvɨ maa jaꞌuꞌu kuñaꞌnu un (ja suni nani Beelzebú), chi yukan kuu ja yɨndaꞌa taka tachi xaan un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nu ni jini Jesús ja siaꞌan ka ndoꞌo ini chaa un, ti ni kachi ya: ―Nu ɨɨn gobiernu, na kusɨɨn da jiin yɨvɨ da ti kejaꞌa kanaa da naa da, ti gobiernu un tu kuñɨɨ, chi naa. Suni siaꞌan nuu ɨɨn ñuu xi ɨɨn familia, nu tu ka iyo ɨɨn nuu ini, ti familia un, tu kuu kunchuku mani. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ti suni siaꞌan kuu nu maa jaꞌuꞌu un na keniꞌin tachi xaan un kiꞌin ja kuu ndajaꞌa maa. Nu siaꞌan na saꞌa, ti ka sasɨɨn jnaꞌan maa, ¿ti nasa kuñɨɨ jiin jniñu ndiso un nusa? ");
INSERT INTO mpmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ti ka kaꞌan ra ja ruꞌu keniꞌin ri tachi xaan un kuankoyo jiin sɨvɨ maa jaꞌuꞌu kuñaꞌnu un. Ko sa ti siaꞌan kuu, ti va suni yɨvɨ ka skuaꞌa jiin ra naa ra, va suni kuu keniꞌin i tachi xaan un jiin sɨvɨ maa jaꞌuꞌu un kinkoyo. Ja yukan na kachi ri ja maa ni ra ka yuji jiin jnuꞌun ka kaꞌan ra un. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko ruꞌu keniꞌin ri tachi xaan un jiin jnuꞌun Espíritu Yandios. Yukan kuu ja, ja ni chaa jniñu ñaꞌnu Yandios ja kuu nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ja siaꞌan, ti saꞌa yo nanu ja ɨɨn ni kuu ja nu kuni yo sakuiꞌna yo veꞌe ɨɨn chaa niꞌin xaan da, ti kuꞌni yo chaa un xnakan, ti sa kuu sakuiꞌna yo ja ñavaꞌa da. Ti suni siaꞌan kuu jaꞌa chi ni kundee ri jiin chaa uꞌu un, ti ni keniꞌin ri ndajaꞌa da un kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ti na kachi ri nuu ra naa ra ja kuu yɨvɨ tu ka kaꞌan vaꞌa jaꞌa ri, ti yɨvɨ un jito uꞌu i ruꞌu. Yɨvɨ tu kejnaꞌan jiin ri, jachanuu i yɨvɨ ka kuni kejnaꞌan jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ja yukan kuu ja na kachi ri nuu ra naa ra ja iyo jnuꞌun kaꞌnu ini Yandios ja kuu yɨvɨ ka saꞌa taka nuu kuachi. Suni nuu yɨvɨ ka kaꞌan ndevaꞌa, vatu ni kuankaꞌnu ini Yandios nuu i. Ko yɨvɨ yɨsɨkɨnchaa Espíritu Santo, jankɨvɨ kuankaꞌnu ini Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ti savaꞌa ni ga yɨvɨ na kaꞌan ndevaꞌa ni ga sɨkɨ ri, ti kuankaꞌnu ini ri nuu i. Ko nu nau ja na kaꞌan ndevaꞌa sɨkɨ Espíritu Santo, tukaa ga iyo jnuꞌun kaꞌnu ini, ni nuu ñuyɨvɨ jaꞌa ni nuu ɨnga ñuyɨvɨ ja kii ɨnga kuiya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nu ɨɨn yujnu vaꞌa, ti kuaꞌa ndeꞌe vaꞌa. Ti nu ɨɨn yujnu kueꞌe kuu, ti suni ndeꞌe kueꞌe kuaꞌa. Jiin ndeꞌe un, ti sa nakuni yo naa nuu yujnu kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yukan na kachi ri ja ka kuu ra nanu koo xaan jiin seꞌe tɨ, chi ndevaꞌa xaan ka saꞌa ra. Ti tu kuu kaꞌan ra ɨɨn jnuꞌun vaꞌa, chi maa ra tu vaꞌa ini ra naa ra. Ti yuꞌu ra chi ka kaꞌan nava ndoꞌo ini añu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Chaa vaꞌa un chi kaꞌan da ɨɨn jnuꞌun kuajniñu, chi iyo ndoo añu da. Ti chaa ka saꞌa ndevaꞌa un, chi kaꞌan ndevaꞌa kuɨtɨ da, chi tu iyo ndoo ini añu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ti na kachi ri nuu ra ja nu na jaa kɨvɨ chaa juicio, ti kɨvɨ jña, ti tendɨꞌɨ yɨvɨ nakuaꞌa i jnuꞌun nuu taka jnuꞌun ndevaꞌa ni kee yuꞌu i ja ni ka kaꞌan i un. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ti sɨkɨ jnuꞌun kaꞌan ra, ti kendo vaꞌa ra. Ti suni jiin jnuꞌun kaꞌan ra un, jnaꞌnu ndatu ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yukan na ti ni ka kachi uu chaa fariseo jiin chaa ka xnaꞌan ley un nuu Jesús: ―Maestro, ka kuni na ja saꞌa ni ɨɨn jniñu ñaꞌnu ja na ndeꞌe na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ti ni kachi Jesús: ―Taka yɨvɨ ja tu ka kuni kuandatu i nuu Yandios, ka kuni i ja na saꞌa ri ɨɨn jniñu ñaꞌnu nuu i, ko jankɨvɨ saꞌa ri jniñu ñaꞌnu un, chi nɨnɨ jiin vanuxii nundoꞌo ni jnaꞌan Jonás, chaa ni kuu profeta na janaꞌan, yukan ni kuu ja xnaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chi nanu ni kundee profeta Jonás uni nduu ti uni jakuaa chii ɨɨn chāká kaꞌnu xaan, ti suni siaꞌan ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kendo ri chii ñuꞌun un uni nduu ti uni jakuaa. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ti sɨkɨ ñuu Nínive nuu ni jaꞌan profeta Jonás, ti yɨvɨ ni kunchuku ñuu un, nandoto i kɨvɨ na chaa juicio ja xndichi ya yɨvɨ kɨvɨ vijna, ti naa ini i ndeꞌe i nuu yɨvɨ kɨvɨ vijna. Chi tendɨꞌɨ yɨvɨ Nínive ni ka nakani ini i na ni kaꞌan profeta Jonás jnuꞌun Yandios. Ko ruꞌu viꞌi ga kuñaꞌnu ri ja kuu Jonás, ti roꞌo naa ra tu ka chunsoꞌo ra ja nakani ini ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Suni ɨɨn ñaꞌan ni kuu reina ja ni taꞌu jniñu ɨɨn ñuu ichi sur, nandoto ña kɨvɨ nu na chaa juicio, kɨvɨ nu na xndichi ya yɨvɨ kɨvɨ vijna. Ti naa ini ña ndeꞌe ña nuu yɨvɨ kɨvɨ vijna sɨkɨ ja niꞌin ini i, chi maa ña undi jika xaan ni kii ña ja ni ñunsoꞌo ña jnuꞌun ndichi ni kaꞌan rey Salomón na janaꞌan. Ti vijna viꞌi ga kuñaꞌnu ruꞌu ja ni kuu Salomón, ti roꞌo naa ra tu ka chunsoꞌo ra jnuꞌun xndaku ri nuu ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nu ɨɨn tachi xaan un na xndoo ɨɨn yɨvɨ, kuaꞌan ti jikonuu nuu ñuꞌun ichi ja nduku nuu ndetatu. Nu tu niꞌin ti ndoꞌo ini: ");
INSERT INTO mpmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Na nandeokuñɨ ri veꞌe nuu ni kundee ri un.” Ko nu ni najaa, ti jini ja iyo nuña ini chaa un nanu ɨɨn veꞌe iyo nuña, ja iyo ndoo, ti iyo tuꞌva. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yukan na ti kiꞌin tachi un ti kin kuaka uxia ga tachi xaan un ja kanda viꞌi ga ja kuu maa. Yukan na ti nchaa ti ndɨvɨkoyo kunchuku jiin chaa un. Yukan na ti chaa un viꞌi ga nduu da ansu nava ni kaa da undi nuu. Ti suni siaꞌan viꞌi ga koo nundoꞌo nuu yɨvɨ ka saꞌa ndevaꞌa kuɨtɨ ja ka iyo kɨvɨ vijna ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɨ kaꞌan ga Jesús jiin yɨvɨ un, ti ni jaa nana ya jiin ñani ya, ni ka kendo da fuera ti ka kuni da kaꞌan da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ni jaꞌan ɨɨn chaa ni jan kaxjnuꞌun nuu ya, ti ni kachi da: ―Nana ni jiin ñani ni kaꞌiin da fuera un, ti ka kuni kaꞌan da jiin ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ti ni kachi ya jiin chaa un: ―Nau kuu nana ri ti nau ja kuu ñani ri ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yukan ti ni xnaꞌan ya ndaꞌa ya nuu taka ndajaꞌa ya, ti ni kachi ya: ―Jaꞌa ka kuu nana ri jiin ñani ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chi vasu savaꞌa ni ga yɨvɨ nu na saꞌa i taka jniñu taꞌu Tata ri ja kancha ya andɨvɨ, ti yukan kuu nana ri, ñani ri jiin kuaꞌa ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kɨvɨ un ni kee Jesús veꞌe un kuaꞌan ya, ti ni nukoo ya yuꞌu lago Galilea un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ti kuaꞌa xaan yɨvɨ ni ka kututu nuu ya. Yukan ti ni kɨvɨ ya ini ɨɨn barco, ni kɨvɨ ya ini nducha un, ti tendɨꞌɨ yɨvɨ un ni ka kendo nuu ñɨtɨ yuꞌu nducha un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yukan ti ni xnaꞌan ya nuu yɨvɨ un siaꞌan, ni kachi ya: ―Ɨɨn chaa jitu triu ni kenda da kuan saka da triu. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ti nuu kuaꞌan da jacha da triu un sava triu un ni ka nukoyo ini ichi, ti ni ka chakoyo saa un naa tɨ, ti ni ka nastutu tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Uu ga triu un ni ka jinu nuu yuu nuu kanchuku yaxin ñuꞌun, ti ni jinu triu un, chi ni niꞌin kajin. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ti nu ni kaña ndikandii, ti ni kuu niꞌni xaan, ti ni ka ichi triu un, chi tu ni niꞌin yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Sava ga triu un ni ka jinu nuu yɨꞌɨ yoꞌo nuꞌiñu. Ti nu ni kaña numa nuꞌiñu un, ti ni ka jasɨ nuu triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ko sava ga triu un ni ka jinu i nuu yɨꞌɨ ñuꞌun vaꞌa, ti ni kaña triu un ti ni jaꞌnu, ti vaꞌa xaan ni kuu. Sava yoko triu un ni nakuaꞌa ɨɨn ciento triu nuu ɨɨn triu tata. Uu ga ni ka nakuaꞌa uni xiko triu, ti uu ga oko uxi. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ti nau roꞌo na kuni chunsoꞌo, ti chunsoꞌo vaꞌa jnuꞌun kaꞌan ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yukan ni ka tuꞌva ndajaꞌa Jesús nuu ya, ti ni ka jikajnuꞌun da: ―¿Ndoo kaꞌan ni siaꞌan nuu yɨvɨ jaꞌa, ti ndoo kuni kaꞌan jnuꞌun un, nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yukan ti ni kachi ya: ―Ja kuu roꞌo naa ra, xnaꞌan Yandios nuu ra naa ra nasa kuu jniñu taꞌu ya, ko yɨvɨ jaꞌa tu kujnuni ini i nasa kuu jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ti yɨvɨ na kandixia jnuꞌun Yandios, ti viꞌi ga niꞌin jnaꞌan i inijnuni i ja kunukuachi i nuu ya. Ko yɨvɨ ja tu kandixia, ti viꞌi ga kendo i, jaku ga koo i, ansu nava ni kaa i undi nuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja yukan kuu ja kaꞌan ri jnuꞌun jaꞌa nuu yɨvɨ naa i, chi vasu ka ñusoꞌo i jnuꞌun kaꞌan ri, ti ka ndeꞌe jniñu saꞌa ri, ko tu ka chaku ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ja siaꞌan ka saꞌa i, ti yukan kundaa jnuꞌun ni kaꞌan profeta Isaías na ni kachi da: Roꞌo, vasu na kunsoꞌo ra naa ra, ko tu chaku ini ra. Ndeꞌe ra jiin nduchi ra naa ra ko tu kojnuni ini ra, chi tu kuni ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chi yɨvɨ niꞌin xaan ini ni ka nduu ini yɨvɨ jaꞌa, ti tu ka chunsoꞌo vaꞌa i. Ti nanu ja ka ndiꞌyu nduchi i, chi tu ka nakuni i jandaa. Chi ni tu ka chunsoꞌo i, ti ni tu ka chaku ini i. Ni tu ka xndoo i kuachi i ja ndɨvɨ i jiin ri, ti na nama ri i. Siaꞌan ni kachi profeta Isaías, kachi tutu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ko kandichi Yandios jiin roꞌo naa ra, chi ka ndeꞌe ra jiin nduchi ra, ka jini ra jniñu saꞌa ri, ti ka jinisoꞌo ra jnuꞌun kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ti jandaa na kachi ri nuu ra naa ra ja kuaꞌa xaan profeta ni ka kikoyo na janaꞌan, jiin yɨvɨ vaꞌa un, ni ka ñukuu ini i ja kuni i taka ja ka jini ra jaꞌa vijna, ko tu ni ka jini i. Suni ni ka ñukuu ini i ja kunsoꞌo i taka jnuꞌun ka jinisoꞌo ra jaꞌa vijna, ko tu ni ka jinisoꞌo i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Siin Jesús xndaku ya, ti ni kachi ya: ―Kunsoꞌo naa ra nasa kuni kaꞌan jnuꞌun chaa saka triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yɨvɨ ka ñunsoꞌo nasa kuu jniñu taꞌu Yandios ko tu ka chaku ini i, yɨvɨ yukan ka kuu nanu triu ni jinu nuu yuꞌu ichi un. Chi chaa jaꞌuꞌu un ti kencha taka jnuꞌun vaꞌa ni chaku ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ti triu ni jinu nuu kanchuku yaxin ñuꞌun nuu yuu, kuu i nanu yɨvɨ ni ka jinisoꞌo jnuꞌun kaꞌan ri, ni ka jantaꞌu i, ti ka kusɨɨ ini i jiin. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ko vanuxia changa ga kuñɨɨ ini i jiin jnuꞌun un, ti nu ni ka kejaꞌa ka jito uꞌu yɨvɨ i ja sɨkɨ jnuꞌun un, ti ka nakani ini i ti tukaa ga ka siin i. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ti triu ni ka jinu nuu yɨꞌɨ yoꞌo nuꞌiñu un, kuu nanu yɨvɨ ni ka chunsoꞌo jnuꞌun un, ko ka ndɨꞌɨ ga ini i ja kuu taka ga ja iyo nuu ñuyɨvɨ jaꞌa, ja na kuu riku i. Ti yukan kuu ja jasɨ ja tu ka siin jiin jnuꞌun Yandios, chi tu ka kuni kuandatu i nuu jnuꞌun ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko triu ni ka jinu nuu ñuꞌun vaꞌa un kuu nanu yɨvɨ ni ka jinisoꞌo, ti ni ka chaku ini i nasa kuu jnuꞌun Yandios, ti ka siuku i jiin. Sava i ka kuu nanu triu ni ka nakuaꞌa ɨɨn ciento triu nuu ndɨ ɨɨn ndɨ ɨɨn xini, xi uni xiko, xi oko uxi triu nuu ndɨ ɨɨn ndɨ ɨɨn xini ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yukan ti ni kaꞌan tuku Jesús ɨnga jnuꞌun jaꞌa, ti ni kachi ya: ―Nava kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, kuu nanu ɨɨn chaa ni saka triu vaꞌa nuu ñuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ko nuu ni naa maꞌna da ka kixi da, ti ni jaa ɨɨn chaa jito uꞌu chaa xiin jniñu un, ti ni jacha da ndɨkɨn yuku kueꞌe nuu triu chaa un, ti kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nu ni jaꞌnu triu un, ni kejaꞌa kuu yoko. Yukan ti sa ni ka jini da ja iin yuku kueꞌe un jiin. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Yukan ti ni ka jaꞌan muzu da, ti ni ka kaxjnuꞌun da nuu chaa xiin triu un ja siaꞌan ni kuu, ti ni ka kachi da: “Taa, ¿Ansu mani triu vaꞌa ni jacha ni nu? ¿Ti nanu ni kii yuku kueꞌe un nusa”? ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yukan ti ni kachi chaa xiin triu un: “Va ɨɨn ñakuasun ini ni saꞌa”, kachi da. Ti ni ka kachi muzu un: “¿Kuni ni ja na kiꞌin jnuꞌun na yuku un nu”? ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ti ni kachi chaa xiin triu un: “Tuu, chi nu na jnuꞌun ra yuku un naa ra ti suni kaña triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sia, na kuꞌiin maa, ti undi na kuaꞌnu triu un, ti sa na taji ri muzu ja na kiꞌin kaꞌncha da yuku kueꞌe un xnaka. Ti na kaꞌncha da nuꞌni ti na kaꞌma yo, ti sa na nastutu da triu un, ja na ndɨvɨ vaꞌa ini veꞌe ri”, kachi da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ti ni siin kaꞌan Jesús: ―Kaꞌan ri ɨɨn jnuꞌun nasa kuu kɨvɨ yɨvɨ kuaꞌa ndaꞌa Yandios, ja na taꞌu ya jniñu nuu i. Yukan kuu nanu ɨɨn ndɨkɨn lulu nu ni xndee yɨvɨ ti kejaꞌa jaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jandaa kuu ja kuu ɨɨn ndɨkɨn lulu ga ja kuu taka ga ndɨkɨn, ko nu na kuaꞌnu, ti yukan kuu ja kuu kaꞌnu xaan ga ja kuu taka ga yuku. Ti kuu nanu ɨɨn yujnu kaꞌnu xaan tonto nu ka jaꞌan saa, ti ka saꞌa tɨ taka tɨ nuu ndaꞌa yujnu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Suni ni kachi ya ɨnga jnuꞌun jaꞌa: ―Kaꞌan ri ɨnga jnuꞌun ja nasa kuu kɨvɨ yɨvɨ kuaꞌa ndaꞌa Yandios, ja na taꞌu ya jniñu nuu i. Yukan kuu nanu levadura ja jajniñu ɨɨn ñasɨꞌɨ ja sakanuu ña jiin ɨɨn bolsa yuchi, ti ja tɨꞌlɨ levadura un saꞌa ja najinu nɨ tuꞌu yujña un ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tɨjnɨ nuu jnuꞌun ni jajniñu Jesús ni kaꞌan ya nuu yɨvɨ naa i, ti tukaa ga naa jnuꞌun ni kaꞌan ya ja kuu jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yukan ni kundaa jnuꞌun ni kaꞌan profeta na ni chaa da tutu: Xndaku ri nuu yɨvɨ jiin savaꞌni ga jniñu. Siaꞌan kaꞌan ri jnuꞌun jaꞌa ja ni kendo saꞌyɨ undi kɨvɨ ni nukoo ñuyɨvɨ. Ni ka kachi profeta ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yukan ti ni kanxiaꞌu Jesús jiin yɨvɨ un, ti kuaꞌan ya. Ni najaa ya veꞌe. Yukan ni ka ndututu ndajaꞌa ya jiin ya, ti ni ka jikajnuꞌun da: ―Kachi ni nasa kuni kaꞌan jnuꞌun sɨkɨ yuku kueꞌe ni kaña nuu ñuꞌun un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yukan ti ni kachi Jesús jiin da: ―Ja saka triu vaꞌa un kuu ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, ");
INSERT INTO mpmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ti ñuꞌun un kuu ñuyɨvɨ. Triu un kuu yɨvɨ ja yɨꞌɨ nuu taꞌu Yandios jniñu. Ti nanu yuku kueꞌe un, ka kuu yɨvɨ ja ka yɨꞌɨ jiin jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti ñakuasun ini ja ni xndee ndɨkɨn kueꞌe un kuu maa jaꞌuꞌu. Ti kɨvɨ ndututu triu un kuu nanu kɨvɨ na ndɨꞌɨ ñuyɨvɨ jaꞌa. Ti chaa ka nastutu triu un ka kuu maa ángel Yandios ja kikoyo andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ti siaꞌan nanu kuu jiin yuku un ja nastutu yo ti kaꞌma yo. Ti suni siaꞌan kuu nu na jaa kɨvɨ na naa ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ko maa Seꞌe Yɨvɨ Ñuyɨvɨ, taji ya ángel ya kikoyo i undi nuu andɨvɨ, ti nastutu ya taka yɨvɨ ka saꞌa kuachi jiin taka yɨvɨ ndevaꞌa kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ti ángel un jnaa da yɨvɨ un na kayu i nuu ñuꞌun. Yukan kondoꞌo i nundoꞌo, ti kuꞌyu yuꞌu i, ti na kee yɨꞌɨ i jnuꞌun i. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yɨvɨ na kachi Yandios ja ka kuu i yɨvɨ vaꞌa, ti nakuaka ya i ja na kunchuku i ñuu nuu taꞌu ya jniñu, ti nduñaꞌnu i nanu ndikandii un, ja jaꞌa nduva ja kuu nɨ tuꞌu ñuyɨvɨ yo. Ti nu na chunsoꞌo ra naa ra, ti chunsoꞌo jnuꞌun kaꞌan ri jaꞌa ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Siin Jesús xndaku ya, ti ni kachi ya: ―Kaꞌan ri ɨnga jnuꞌun nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Yukan kuu nanu ɨɨn jajnu xuꞌun yɨsaꞌyɨ chii ñuꞌun. Nu ɨɨn chaa na naniꞌin jajnu xuꞌun un nuu ñuꞌun ɨnga yɨvɨ, ti nachisaꞌyɨ tuku da nuu kande un. Ti ja kusɨɨ ini da jiin ja kande un, nandeokuñɨ da ti xiko ndɨꞌɨ da ja ñavaꞌa da ti kiꞌin da, ti nakuaan da ñuꞌun un ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Siin Jesús xndaku ya, ti ni kachi ya: ―Kaꞌan ri ɨnga jnuꞌun nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Yukan kuu nanu ɨɨn chaa yaku da nduku da yuu xiñu fino xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ti nu ni niꞌin da ɨɨn yuu fino xaan un ja nchaa yaꞌu xaan tonto ga, kiꞌin da ti xiko da taka ja ñavaꞌa da, ti kuaan da yuu fino un―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Siin Jesús xndaku ya, ti ni kachi ya: ―Kaꞌan ri ɨnga jnuꞌun nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Yukan kuu nanu ɨɨn ñunu ja chunde da nuu nducha mar, ti jnɨɨ da taka nuu chāká. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu ni chitu ñunu un, yukan na ti chaa ka jnɨɨ chāká un tava da ñunu un yuꞌu mar, ti yukan nukoo da nakaji da chāká un, nasavaꞌa da chāká vaꞌa un ini chika da, ti sukoyo da chāká kueꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ti siaꞌan kuu jiin yɨvɨ na ndɨꞌɨ ñuyɨvɨ jaꞌa. Chakoyo ángel Yandios ja kii undi andɨvɨ, ti sasɨɨn i yɨvɨ kueꞌe un, ti suni sasɨɨn i yɨvɨ ja na kachi Yandios ja ka kuu i yɨvɨ vaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ti jnaa i yɨvɨ kueꞌe un ja na kayu i nuu ñuꞌun, ti yukan nakani ini yɨvɨ un ti ndeꞌe, ti kuꞌyu yuꞌu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yukan na ti ni jikajnuꞌun Jesús maa da naa da, ti ni kachi ya: ―¿Ka chaku ini ra taka jnuꞌun jaꞌa nu? ―ni kachi ya. Ti maa da ni ka kachi da: ―Ka chaku ini na ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ti ni kachi Jesús: ―Nu ɨɨn chaa xnaꞌan ley Israel, nu na nakuni ndaa da nasa kuu nuu taꞌu Yandios jniñu, ti ni kuu da nanu ɨɨn chaa xiin veꞌe, ja jini da sasɨɨn da ndajniñu jaa, ti sasɨɨn da ndajniñu ava ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nu ni ndɨꞌɨ ni kaꞌan Jesús taka jnuꞌun un, ni kee ya kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ti ni najaa ya ñuu maa ya, ti yukan ni kejaꞌa ya ni xnaꞌan ya nuu yɨvɨ ini veñuꞌun Israel ñuu yukan. So ni ka naa ini yɨvɨ un, ti ni ka kejaꞌa ka kaꞌan: ―¿Nanu ni jan skuaꞌa chaa jaꞌa taka jnuꞌun un? ¿Nasa kuu ja kuu saꞌa da taka jniñu ñaꞌnu un? ");
INSERT INTO mpmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ti ansu seꞌe chaa yokon yujnu un kuu chaa jaꞌa nu? Ti nana da kuu María. Ti ñani da ka kuu Jacobo, José, Simón jiin Judas. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ti suni jaꞌa kanchuku kuaꞌa da jiin yo jaꞌa naa yo. ¿Ko nanu ni jan skuaꞌa chaa jaꞌa taka jnuꞌun un nusa? ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Siaꞌan ni ka ndeꞌe yɨvɨ un ya nanu ɨɨn chaa ndevaꞌa ni. Ja yukan kuu ja tu ni ka ndee nuu ya. Ko ni kachi Jesús jiin da: ―Taka ga yɨvɨ ka jaꞌa ja yɨñuꞌun ɨɨn profeta, ja kaꞌan da jnuꞌun Yandios. Ko yɨvɨ ñuu maa da, jiin yɨvɨ ini veꞌe da, tu kuantaꞌu i maa da ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ti ja yukan kuu ja tu ni saꞌa ya tɨjnɨ jniñu ñaꞌnu ñuu yukan, chi tu ni ka kandixia i ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti kuiya un ni kuu Herodes gobernador nuu ñuu Galilea. Ti ni niꞌin da jnuꞌun taka jniñu saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ti ni kachi da jiin chaa ka kuu ndajaꞌa da un: ―Va nu suu Juan ja ni skuanducha un kuu, ti va ni nandoto. Ja yukan kuu ja kuu saꞌa taka jniñu ñaꞌnu un ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Vanuxia Herodes ni jnɨɨ da Juan, chaa ni skuanducha un, ni juꞌni da chaa jiin yoꞌo, ti ni chunde da chaa vekaa ja sɨkɨ Herodías, ñaꞌan ni kuu ñasɨꞌɨ ñani da Felipe. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chi Herodías ni jito uꞌu ña Juan un, vanuxia ni kachi da jiin Herodes: ―Tu vaꞌa ja kuncha ni jiin ña nanu ñasɨꞌɨ ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ti kuni Herodes kaꞌni da Juan niku, ko yuꞌu da yɨvɨ naa i, chi ka kandixia i ja Juan kuu ɨɨn profeta ja kaꞌan jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ko kɨvɨ ni nasaꞌa Herodes ɨɨn viko ja ni sinu tuku da ɨnga kuiya da, ti ni kee seꞌe sɨꞌɨ Herodías, ni jitajaꞌa ña nuu yɨvɨ ni ka jakoyo veꞌe da un, ti yukan ni kusɨɨ xaan ini Herodes. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ti ni chisojnuꞌun da nuu ñaꞌan lulu un ja kuaꞌa da vasu savaꞌani ga ndoo na kakan ña nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ti ñaꞌan lulu un ja ni ka ndajnuꞌun ña jiin nana ña, ti ni kachi ña jiin Herodes: ―Kuni na ja kuaꞌa ni xini Juan, chaa skuanducha un, nuu na ini ɨɨn koꞌo xita ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yukan ti ni kukuiꞌya xaan ini rey Herodes, ko vanuxia ja ni chisojnuꞌun da nuu ña, ti suni ni ka jinisoꞌo yɨvɨ kanchuku jiin da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ja yukan kuu ja ni taꞌu da jniñu ja na kin kiꞌin da xini Juan naa da ini vekaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ni ka jan kiꞌin da xini Juan nuu ɨɨn koꞌo xita, ni ka jaꞌa da nuu ñaꞌan lulu un, ti ñaꞌan lulu un ni nakuaꞌa ña nuu nana ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yukan sa ni ka jakoyo chaa ka jikonuu jiin Juan, ni ka nakiꞌin da yɨkɨ kuñu da, ti ni ka chunduji da chaa, ti sa ni ka jan kasjnuꞌun da nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nu ni jini Jesús jnuꞌun nava ni jnaꞌan Juan un, ti ni kendo maa ɨɨn ni ya kuaꞌan ya jiin ɨɨn barco undi ɨnga nuu ni kunde maa ɨɨn ni ga ya. Ko ni ka jini yɨvɨ nanu kuaꞌan ya, ti ni ka kee i ñuu nuu kanchuku i, ti ni ka jika jaꞌa i kuankoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nu ni kee Jesús ini barco un, ti ni jini ya ja, ja ni ka kututu yɨvɨ kaꞌiin i un, ti ni kundaꞌu ini ya yɨvɨ un, ti ni saꞌa ya tajna tɨjnɨ yɨvɨ ka kuꞌu ni jakoyo un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ko vanuxia ja kuan kuñaa, ti ni ka tuꞌva ndajaꞌa ya, ti ni ka kachi da jiin ya: ―Ja kuan ini, ti vaꞌa ga ja na taji ni yɨvɨ jaꞌa na kinkoyo i ñuu kaꞌiin yajni jaꞌa, ti na kuan i ja kaji i naa i ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yukan ti ni kachi Jesús: ―Tu kinkoyo yɨvɨ jaꞌa. Kuaꞌa ma ra ja na kaji i naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yukan ti ni ka kachi da jiin ya: ―Ko tukaa ga ndoo ka yɨndaꞌa na, chi uꞌun ni ga staa stila jiin uu chāká ni ga ka yɨndaꞌa na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yukan ti ni kachi Jesús jiin da naa da: ―Kuaꞌa na kii nuu ri jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yukan ti ni taꞌu ya jniñu ja na nukoo i naa i nuu icha un. Ti ni kiꞌin ya ndɨ uꞌun staa stila un jiin uu chāká un, ni ndakoto ya andɨvɨ, ni nakuantaꞌu ya nuu Yandios. Ti ni saꞌa kuachi ya staa stila un, ti ni jaꞌa ya nuu ndajaꞌa ya ja na tejnaꞌan da nuu yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tendɨꞌɨ yɨvɨ un ni ka yaji, nasa ni kundee maa i. Ti ni kendoso ga staa stila un ja ni ka nastutu da, uxi uu ga chika jiin pedasu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ti yɨvɨ ni ka yaji un ni ka iyo yajni uꞌun mil chaa, ti sɨɨn kuu ñasɨꞌɨ jiin suchi kuachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yukan na ti ni kaꞌan Jesús jiin ndajaꞌa ya ja na kɨvɨkoyo da ini barco un, ti na kinkoyo da ɨnga yuꞌu lago Galilea un, ni kanxiaꞌu ya jiin yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nu ni ndɨꞌɨ ni kanxiaꞌu ya jiin yɨvɨ un, ti kuaꞌan ya xini ɨɨn yuku ja na kakantaꞌu maa ɨɨn ni ya nuu Yandios, ko nɨ kande maa ɨɨn ya yuku un, ti ni kuñaa. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ti barco un ja kuaꞌan, kuu sava nuu nducha un. Yukan ti ni ndonda ɨɨn tachi sau nuu nducha un, ti ni kejaꞌa chindaꞌa barco un ya yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nu ja kuan kuyajni ka uni jañaꞌan, ti ni kuyajni Jesús nuu kuankoyo ndajaꞌa ya jiin barco un, jika ya kuaja ya nuu nducha un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nu ni ka jini da ja jika ya nuu nducha un, ni ka yuꞌu xaan da, ti ni ka kejaꞌa ka kanajiin da: ―¡Ɨɨn niꞌna kuu! ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yukan ti ni kachi Jesús jiin da naa da: ―Chunde ini naa ra, koto yuꞌu ra chi maa ri kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yukan sa ni kaꞌan Pedro, ti ni kachi da jiin ya: ―Jitoꞌyo, nu maa ni kuu, ti kachi ni ja na kuu kaka na nuu nducha jaꞌa, ti na jaa na nuu vaji ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ti ni kachi Jesús: ―Ñaꞌan nusa ―ni kachi ya. Yukan ti ni kuun Pedro nuu barco, ti ni kejaꞌa da jika da nuu nducha un, ti kuaꞌan da nuu vaji Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko nu ni jini da ja niꞌin ndita tachi, ni yuꞌu da ti ni kejaꞌa kekaꞌnu da chii nducha un, ti ni kanajiin koꞌo da: ―¡Jitoꞌyo, nama ni saña! ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti ni skaa Jesús ndaꞌa ya, ti ni jnɨɨ ya maa da, ti ni kachi ya jiin da: ―¿Tindoo tu ñukuu ini ra ruꞌu? ¿Xi tu kandixia ra nusa? ―ni kachi ya jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ti nu ni ka ndɨvɨ da nuu barco un, ti ni kunaꞌiin tachi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yukan na ti chaa kaꞌiin ini barco un, ni ka jakunjitɨ da nuu Jesús, ti ni ka kachi da: ―Jandaa kuɨtɨ kuu, ja Seꞌe Yandios kuu ni ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nu ni ka jika da nuu lago Galilea un, ti ni ka jakoyo da ñuu Genesaret. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ni ka nakuni yɨvɨ un Jesús, ti ni ka jachanuu i jnuꞌun nɨ tuꞌu ñuu un, ti ni ka yɨndaꞌa i taka yɨvɨ ka kuꞌu nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ti ni ka kandaꞌu i jiin ya ja na kuaꞌa ya vasu tɨꞌlɨ saꞌma ya na kueꞌe i, ti taka yɨvɨ ni ka kueꞌe saꞌma ya ni ka nduvaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yukan ti ni ka tuꞌva sava chaa fariseo jiin chaa ka xnaꞌan ley ini veñuꞌun Israel, ja vekoyo da undi ñuu Jerusalén, ti ni ka jikajnuꞌun da ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ndoo jani ini ra ja tu ka siuku ndajaꞌa ra jiin jnuꞌun yɨvɨ janaꞌan, ja tu ka nandaꞌa da ti ka yee da staa? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yukan ti ni jikajnuꞌun Jesús maa da naa da: ―¿Ti suni ndoo ka ndoꞌo ini ra ja ka xndoo ra jniñu taꞌu Yandios, ti ka siin ga ra jiin jnuꞌun nava vekoyo maa ra naa ra? ");
INSERT INTO mpmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chi ni kachi Yandios: “Kuandatu nuu tata ra nuu nana ra.” Ti suni ni kachi ya: “Nu ɨɨn yɨvɨ na kaꞌan ndevaꞌa nuu tata i xi nuu nana i, vaꞌa ga ja na kuū i.” ");
INSERT INTO mpmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ti roꞌo naa ra, chi ka kaꞌan ra ja kuu kachi ɨɨn yɨvɨ jiin tata i xi jiin nana i: “Tukaa kuu chindee na niꞌin, chi taka ja ñavaꞌa na ja ni soko na nuu Yandios.” Ti savaꞌa ni ga yɨvɨ na kaꞌan siaꞌan jiin nana i xi jiin tata i, chi ndoꞌo ini i ja tukaa ga kuu chindee ra da naa da. Ja siaꞌan kuu ja roꞌo naa ra, tu ka chiñuꞌun ra jniñu taꞌu Yandios, chi suꞌva ni ka siin ra jiin jnuꞌun maa ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ko jiin jnuꞌun ra, ka stuu ra ja tu ka chiñuꞌun ra jnuꞌun Yandios. Ti ni kaꞌan ndaa profeta Isaías sɨkɨ ra na janaꞌan na ni kaꞌan da: ");
INSERT INTO mpmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ko yɨvɨ jaꞌa, so jiin yuꞌu i ka chiñuꞌun i ruꞌu, ko añu i chi jika ka kuu ini i ka jito i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ti so ka xndaꞌu i ja ka kandixia ndaa i jnuꞌun Yandios, chi ka siin i jiin jnuꞌun maa i, ti ka kaꞌan i ja ɨɨn ni kuu jiin jnuꞌun Yandios. Siaꞌan ni chaa Isaías jnuꞌun Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yukan na ti ni kana ya xini yɨvɨ un, ti ni kachi ya: ―Chunsoꞌo ti chuun ini naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ansu ja kɨvɨ yuꞌu yɨvɨ kuu ja saꞌa ja nchakuachi i, chi suꞌva ja kee yuꞌu i ja kaꞌan i un, yukan saꞌa ja nchakuachi i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yukan ti ndajaꞌa ya un ni ka tuꞌva da nuu ya, ti ni ka kachi da: ―¿Jini ni ja chaa fariseo un ni ka kuu ika ini da, ni ka jinisoꞌo da jnuꞌun ni kaꞌan ni un? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ko ni kachi ya: ―Chaa fariseo jiin chaa ka xnaꞌan ley Israel un ka kuu da nanu yukū ja tu ni xndee Tata ri Yandios, ya kancha andɨvɨ, ti jnuꞌun ya ja na kiꞌin nɨ jiin yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sia, koto saꞌa r naa ra, chi yɨvɨ un ka kuu nanu ɨɨn chaa kuaa, chi ka jaꞌa da ichi kiꞌin ɨnga chaa kuaa. Chi nu ɨɨn chaa kuaa na kuaꞌa da ichi kiꞌin ɨnga chaa kuaa, ti ndɨnduu da nukoyo ini ɨɨn xaꞌva ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yukan na ti ni kachi Pedro jiin Jesús: ―Xndaku ni nuu yo ndoo kuni kaꞌan jnuꞌun un ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ti ni kachi Jesús: ―¿Xi suni tu ka chaku ini tu roꞌo naa ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tu ka chaku ini ra ja ɨɨn yɨvɨ tu nchakuachi i nuu ndeyu yaji i, chi ja yaji i kuaꞌan chii jitɨ i, ti ndenda kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ko ja kaña yuꞌu i, ja kaꞌan i un, chi undi ini añu i vaji, chi undi añu i ni ndoꞌo ñaa ini i, ti yukan kuu ja nchakuachi ga i jiin. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chi undi añu i kuu nu vaji taka jnuꞌun kueꞌe ka ndoꞌo ini i. Ka kuni i kaꞌni ɨɨn ndɨyɨ. Ka kuni chaa un kusɨkɨnchaa jnaꞌan da i, xi kusɨkɨnchaa da ñakuachi. Ka kuni sakuiꞌna da, ka kuni xndaꞌu ñaꞌan da xi chakuachi da yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ti taka jnuꞌun un kuu ja saꞌa ja nchakuachi yɨvɨ naa i. Ko nu so ja tu siuku yo jnuꞌun janaꞌan ja tu nandaꞌa yo, ti kee yo staa, tu nchakuachi yo ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ni kee Jesús yukan, ti kuaꞌan ya ichi ñuu Tiro jiin ñuu Sidón. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ti yukan kancha ɨɨn ñaꞌan ñuu Canaán, ni chaa ña nuu Jesús, ti kana koꞌo ña kaꞌan ña: ―¡Jitoꞌyo, niꞌin ja kuu ni seꞌe rey David na janaꞌan, kundaꞌu ini ni saña! Chi seꞌe sɨꞌɨ na jnaꞌan i ɨɨn tachi xaan, ti ndoꞌo xaan i jiin kueꞌe un ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko Jesús, tu ni kaꞌan kuɨtɨ ya. Ti ni ka kachi ndajaꞌa ya jiin ya: ―Kaꞌan ni jiin ña na kiꞌin ña, chi kana koꞌo ña vaji ña ichi jata yo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yukan ti sa ni kaꞌan Jesús: ―Ni taji Yandios ruꞌu vaji ri, ja na nama ri yɨvɨ nación Israel, ja ni ka sana i ka jika i nanu rɨɨ ni skuita jitoꞌo tɨ ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ko ni tuꞌva ñaꞌan un undi nuu Jesús, ti ni kachi ña: ―Jitoꞌyo, chindee ni saña ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yukan ti ni kachi Jesús: ―Tu vaꞌa ja kenchaa yo staa yuꞌu seꞌe yo, ti kuaꞌa yo nuu ina ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ko ni kachi ñaꞌan un: ―Jandaa kaꞌan ni Jitoꞌyo, ko ina un chi ka nachii tɨ staa kuachi nukoyo yuꞌu mesa jitoꞌo tɨ ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yukan na ti ni kachi Jesús jiin ña: ―Roꞌo ja kuu ra ñasɨꞌɨ, xaan vaꞌa ja ni kandixia ndaa ra ruꞌu, ti na kuu nava kuni ra ―ni kachi ya. Ti yukan, ni nduvaꞌa ni seꞌe sɨꞌɨ ña un. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ni kee Jesús yukan, ti ni yaꞌa ya yuꞌu lago Galilea, ti ni kaa ya, kuaꞌan ya yuku un, ti yukan ni nukoo ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ti kuaꞌa xaan yɨvɨ ni ni jakoyo nuu kancha ya un, ni ka jakoyo i jiin yɨvɨ ni ka jnaꞌan kueꞌe jiyɨꞌɨ, yɨvɨ kuaa, yɨvɨ ñɨꞌɨn, suni yɨvɨ ja tu sɨꞌɨn xi tu ndaꞌa, jiin tɨjnɨ ga yɨvɨ ka jnaꞌan ɨnga kueꞌe, ni ka jakoyo i nuu Jesús. Ti tendɨꞌɨ yɨvɨ un ni saꞌa ya tajna i. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yukan ti ni ka naa ini yɨvɨ un, chi ja kandokaꞌan yɨvɨ ñɨꞌɨn, ka ndoo kaka vaꞌa yɨvɨ ni ka jnaꞌan kueꞌe jiyɨꞌɨ, ka ndundijin nduchi yɨvɨ kuaa. Ti ka naa ini yɨvɨ un ja siaꞌan ni kuu, ti ni ka kejaꞌa ka nakanajaa i Yandios ja ndito ya yɨvɨ nación Israel, ti ni ka kaꞌan i: ―¡Vaꞌa xaan ini Tata yo Yandios, chi jito ya yɨvɨ nación Israel! ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yukan ti ni kana Jesús ndajaꞌa ya, ti ni kachi ya jiin da naa da: ―Kundaꞌu ini ri yɨvɨ jaꞌa, chi ja ni kuu uni kɨvɨ kaꞌiin i jaꞌa jiin ri. Ti tundo kaji yɨ, ti tu kuni ri ja nataji ri siaꞌan ni, nukoyo i veꞌe i, chi sa sandau kuita i ichi nukoyo i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yukan ti ni ka kachi ndajaꞌa ya un: ―¿Ti nanu niꞌin yo ja kaji yɨvɨ kuaꞌa jaꞌa ja tu naa veꞌe iyo nuu kaꞌiin yo jaꞌa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ti ni jikajnuꞌun Jesús maa da naa da: ―¿Nasa ga staa stila ka ñavaꞌa ra naa ra? ―ni kachi ya. Yukan ti ni ka kachi da: ―Uxia staa stila ti jaku ni ga chāká kuachi ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yukan na ti ni kachi Jesús ja na nukoo yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ni kiꞌin ya ndɨ uxia staa stila un jiin chāká kuachi un, ti ni nakuantaꞌu ya nuu Yandios. Ni sakuachi ya staa stila un, ti ni jaꞌa ya nuu ndajaꞌa ya, ti chaa un ni ka tejnaꞌan da nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tendɨꞌɨ yɨvɨ un ni ka yee i undi ni ka chitu chii i. Ti ni kendoso ga staa stila un, ti ni ka nastutu tuku da uxia chika naꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ti yɨvɨ ni ka yee un ni ka iyo kuun mil chaa, ti sɨɨn kuu ñasɨꞌɨ jiin suchi kuachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yukan ti sa ni kanxiaꞌu Jesús jiin yɨvɨ un, ti ni ndɨvɨ ya nuu barco, ti kuaꞌan ya ichi ndañuu Magdala. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yukan ti ni ka jaꞌan chaa fariseo jiin chaa saduceo ni ka jandeꞌe da Jesús, ja ka nduku da nasa kuu kankuachi da sɨkɨ ya. Ti ni ka jikan da nuu ya ja na saꞌa ya ɨɨn jniñu ñaꞌnu ja vaji nuu Yandios, ya kancha andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ti ni kachi ya jiin chaa un naa da: ―Roꞌo naa ra, chi siaꞌan ka kaꞌan ra: “Na ndii ijña chi ni nakuchi kuaꞌa viko”, ka kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ti ja kuu jañaꞌan ka kaꞌan ra naa ra: “Vijna ti kuun sau chi iña viko kuaꞌa ichi nuu vekaña ndikandii”, ka kaꞌan ra. Chaa ñaa xini ka kuu ra chi ka jini vaꞌa ra seña jaꞌa viko nuu andɨvɨ un, ko tu ka chaku ini ra nau ja kuu ruꞌu, ja saꞌa ri taka jniñu ñaꞌnu jaꞌa kɨvɨ vijna naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ja kuu kɨvɨ vijna ka iyo kuaꞌa yɨvɨ ka saꞌa ndevaꞌa ja tu ka jandatu i nuu Yandios. Ti ka kuni i ja na saꞌa ri ɨɨn jniñu ñaꞌnu nuu i, ko jankɨvɨ saꞌa ri ɨɨn jniñu ñaꞌnu un nuu i, chi nɨnɨ jiin vanuxii nundoꞌo ni jnaꞌan Jonás, chaa ni kuu profeta na janaꞌan―ni kachi ya. Yukan ti ni xndoo ya yɨvɨ un, ti kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ja ni ka yaꞌa ndajaꞌa ya ɨnga nuu yuꞌu lago un, ko ni ka naa ini da kundaꞌa da staa stila. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yukan ti ni kachi Jesús jiin da naa da: ―Ndeꞌe naa ra, koto ra maa ra jiin jnuꞌun ka kaꞌan chaa fariseo jiin jnuꞌun ka kaꞌan chaa saduceo, chi yachi xaan jichanuu nanu keniꞌno levadura chii yujña staa stila ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yukan ti ni ka kejaꞌa ndajaꞌa ya un ka ndajnuꞌun maa da: ―Sɨkɨ ja tu ni ka yɨndaꞌa yo staa stila kuu ja kaꞌan ya ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ko ja ni jini Jesús ndoo ka ndajnuꞌun da, ti ni kachi ya: ―¿Ndoo ka ndajnuꞌun ra ja tu ka ndiso ra staa stila naa ra? ¿Xi tu ka ñukuu ini ra ja niꞌin yo staa stila kaji yo nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Va nu tu ka chaku ini ra, xi tu ka naꞌan ra na ni tejnaꞌan ri uꞌun staa stila ni ka yaji viꞌi ga uꞌun mil yɨvɨ un nu? ¿Ti nasa ga chika ni ka nastutu ra nusa? ");
INSERT INTO mpmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Xi ni tu ka naꞌan ra na ni tejnaꞌan ri uxia staa stila ni ka yaji viꞌi ga kuun mil yɨvɨ un naa i nu? ¿Ti nasa ga chika ni ka nastutu ra un nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ti ndoo tu ni ka chaku ini ra, ja ruꞌu tu ni kaꞌan ri sɨkɨ staa stila na ni kachi ri ja koto ra maa ra naa ra jiin levadura chaa fariseo jiin chaa saduceo yukan nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yukan sa ni ka chaku ini da ja Jesús tu ni kaꞌan ya sɨkɨ levadura staa stila un, chi suꞌva ni kaꞌan ya sɨkɨ jnuꞌun ka xnaꞌan chaa fariseo jiin chaa saduceo yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nu ni jaa Jesús ñuu Cesarea ja kuu ɨɨn ndañuu Filipo, ti ni jikajnuꞌun ya ndajaꞌa ya, ti ni kachi ya: ―¿Ndoo ka kaꞌan yɨvɨ ja nau kuu ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ? ―siaꞌan ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yukan ti ni ka kachi da: ―Sava yɨvɨ ka kaꞌan ja kuu ni Juan ja ni skuanducha un. Sava ga ka kaꞌan ja maa ni kuu profeta Elías ni kii na janaꞌan. Ti sava ka ndaku niꞌin ja maa ni kuu Jeremías xi ɨnga profeta ja kaꞌan jnuꞌun Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yukan ti ni kachi ya jiin da naa da: ―Ti roꞌo naa ra, ¿nau ja ka ndoꞌo ini ra ja kuu ri? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ti Simón Pedro ni kachi da: ―Maa ni kuu Cristo, ja ni taji Yandios ja taꞌu ni jniñu ñaꞌnu. Ti kuu ni Seꞌe maa Yandios chaku ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yukan ti ni kachi Jesús jiin Pedro: ―Roꞌo Simón, seꞌe yɨɨ Jonás, kancha Yandios jiin ra chi ni ɨɨn yɨvɨ tu ni xndaku un nuu ra, chi Tata ri, ya kancha andɨvɨ kuu ja ni kaꞌan inijnuni ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ti ruꞌu na kachi ri ja maa ra kuu Pedro, ja kuni kaꞌan “ɨɨn yuu”, ti jiin yuu kaꞌnu jaꞌa kejaꞌa nastutu ri savaꞌani ga yɨvɨ taka nación, ja na kandixia i ruꞌu. Yukan kuu jniñu kin saꞌa ri jiin yuu jaꞌa. Ti jaꞌuꞌu un tu kundee kutɨ jiin jniñu taꞌu ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chi tatu ri ɨɨn jniñu roꞌo. Roꞌo kuu nanu ɨɨn ndakaa ja jajniñu yo ja kuiña yo ti nakasɨ yo yuxeꞌe. Ti jniñu ra kuu ja na kuiña ra yuxeꞌe ñuu nuu taꞌu Yandios jniñu. Chi kuiña ra ichi ya ja kuu yɨvɨ taka nación, ja na xndaku ra jnuꞌun ri nuu i nasa kaa ichi Yandios. Ti yɨvɨ kandixia, ti ndɨvɨ i ndaꞌa Yandios jiin ñuu nuu taꞌu ya jniñu. Ko yɨvɨ tu kandixia jnuꞌun ri, ti kasɨ ra yuxeꞌe ñuu nuu taꞌu Yandios jniñu ja kuu yɨvɨ un, chi tu ni ka chuꞌun ini i. Ti taka jniñu vaꞌa saꞌa ra nava na kendo vaꞌa nuu Yandios ―ni kachi Jesús jiin Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yukan na ti ni kachi Jesús jiin ndajaꞌa ya ja koto ma kani kutɨ da jnuꞌun nuu yɨvɨ ja maa ya kuu Cristo, ja ni taji Yandios ja ndiso ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Undi sa ni kejaꞌa Jesús ni xndaku ya nuu ndajaꞌa ya, ja nɨnɨ kuu ja kiꞌin ya Jerusalén, ti chaa ka kuñaꞌnu ka iyo nación Israel, jiin sutu ka kuñaꞌnu, jiin chaa ka xnaꞌan ley ini veñuꞌun un, tu kuajnuꞌun da ya, chi suꞌva kuaꞌa da nundoꞌo kondoꞌo ya, ti kaꞌni da ya. Ko nu uni kɨvɨ ti nandoto ya nuu ñujiꞌi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yukan ti ni kana sɨɨn Pedro ya, ti ni kachi da jiin ya: ―Jitoꞌyo, ¡Koto kuaꞌa Yandios jnuꞌun ja koto ni nundoꞌo un! ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ni ndeokoto Jesús nuu Pedro, ti ni kachi ya: ―Kuxio kiꞌin ra, chi kaꞌan ra nanu chaa uꞌu un, ja so sakanuu ra ini ri. Chi roꞌo tu ndoꞌo ini ra ja na siuku ri nava kuni maa Yandios, chi roꞌo ndoꞌo ini ra nava ka ndoꞌo ini yɨvɨ ñuyɨvɨ jaꞌa ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yukan na ti ni kachi Jesús jiin ndajaꞌa ya: ―Nu nau yɨvɨ ka kuni kundikun ruꞌu, ja na siuku jnuꞌun kaꞌan ri, ti na xndoo i ja ka ndoꞌo ini i, ti na tava ini i ja na kondoꞌo koo nene i vasu na kuu i ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chi yɨvɨ ka ndiyo ini ja kunchuku vaꞌa i nuu ñuyɨvɨ jaꞌa, ja tu ka kandixia i jnuꞌun ri, ti xnaa i maa i nuu Yandios. Ko yɨvɨ na kondoꞌo koo nene i ja sɨkɨ ruꞌu, ti suꞌva na niꞌin taꞌu i ja na kunchuku i andɨvɨ ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chi tundo niꞌin kutɨ ɨɨn yɨvɨ vasu na kundee i niꞌin i taka ja iyo nuu ñuyɨvɨ jaꞌa, ti xnaa i añu i nuu Yandios. ¿Xi ka jani ini ra ja chunaa yɨvɨ un nuu añu i nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jaa ɨɨn kɨvɨ ti nchaa tuku ri, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ. Ti nduñaꞌnu xaan ga jniñu ndiso ri nanu kuu maa Tata ri Yandios, ti nchaa ri jiin ángel ri ja ka janukuachi nuu maa ya. Yukan na ti chaꞌu ri nuu ndɨ ɨɨn ndɨ ɨɨn yɨvɨ nasa kaa jniñu ni ka saꞌa maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ti ja kuu kɨvɨ yukan, na kachi ndaa ri ja ka iyo sava roꞌo kaꞌiin jaꞌa kuchaku ga ra, ti kuni ra nchaa ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ. Ti nchaa ri jiin ɨɨn jniñu ñaꞌnu xaan ga, ja undi vijna tu ka jini ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nu iñu kɨvɨ ti kuaꞌan Jesús jiin Pedro, Jacobo, jiin Juan ñani Jacobo, ti ni ka kaa da xini ɨɨn yuku sukun ga. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ti yukan ni ka jini da ja ni nasama nuu ya. Ti taja ii nuu ya nanu ndikandii, ti saꞌma ya ni ndukɨyɨ xaan nanu nduva ndikandii. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti yukan ni ka ndenda uu chaa ni ka kuñaꞌnu ga nuu nación Israel na janaꞌan ni nani Moisés, ti ɨnga chaa un ni kuu profeta Elías, ti ka ndajnuꞌun da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yukan ti ni kachi Pedro jiin Jesús: ―Jitoꞌyo, xaan vaꞌa ja kaꞌiin yo jaꞌa. Nu kuni ni ti na saꞌa na uni veꞌe kuachi kunchuku yo, ɨɨn kuu ni, ɨnga na kuu Moisés, ti ɨnga na kuu Elías ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nɨ kaꞌan ga Pedro siaꞌan, ti ni jakava ɨɨn viko nuꞌun xkɨyɨ sɨkɨ da naa da. Ti nuu viko un ni kaꞌan ɨɨn ndusu siaꞌan: ―Jaꞌa kuu Seꞌe ri ja kundaꞌu ini ri, ti kusɨɨ ini ri jiin. Ti chunsoꞌo jnuꞌun kaꞌan ya ―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nu ni ka jinisoꞌo ndajaꞌa ya jnuꞌun un, ti ni ka jankava ndee da undi nuu ñuꞌun, chi ni ka yuꞌu xaan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yukan ti ni tuꞌva Jesús nuu da naa da, ni skanda ya da, ti ni kachi ya: ―Ndokuñɨ, koto ma yuꞌu ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ti ni ka ndeꞌe da, ko tukaa ga ndoo ni ka jini da, ni ɨɨn chaa un. Tukaa ga ndoo iyo, chi maa ɨɨn ni ga Jesús kandichi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ti nu ni ka nandee da xini yuku un kuankoyo da, ni taꞌu Jesús jniñu siaꞌan nuu da: ―Koto kani ra jnuꞌun nuu ni ɨɨn yɨvɨ ja siaꞌan ni ka jini ra, undi na jaa kɨvɨ na nandoto ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yukan na ti ni ka jikajnuꞌun ndajaꞌa ya un maa ya, ti ni ka kachi da: ―¿Ti ndoo ka kaꞌan chaa ka xnaꞌan ley un, ja xnakan Elías chaa nu? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ti ni kachi Jesús: ―Jandaa kuu ja xnaka Elías kii, ti satuꞌva da yɨvɨ naa i, ");
INSERT INTO mpmNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ko na kachi ri nuu ra ja, ja ni kii Elías, ko tu ni ka ndeꞌe da nuu da, chi ni ka saꞌa da nava ni ka kuu ini da jiin da. Ti ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, suni siaꞌan kondoꞌo ri ndaꞌa chaa un naa da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yukan ti ni ka chaku ini ndajaꞌa un ja ni kaꞌan ya jnuꞌun Juan, chaa ni skuanducha un. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nu ni ka nchakoyo da nuu kaꞌiin uu ga ndajaꞌa jiin yɨvɨ kuaꞌa un, ti ɨɨn chaa un ni tuꞌva da nuu Jesús, ni jakunjitɨ da nuu ya, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Jitoꞌyo, kundaꞌu ini ni nuu seꞌe yɨɨ na, chi jnaꞌan i kueꞌe jiꞌi yɨꞌɨ xaan tonto. Ti tɨjnɨ jinu nduva i nuu ñuꞌun, ti kana kava i ini nducha. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ti jaꞌa yɨndaꞌa na i nuu ndajaꞌa ni, ko tu ka kujnuni ja saꞌa da jiin yɨ ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ti ni kachi Jesús nuu tendɨꞌɨ yɨvɨ un: ―Xaan ga tu ka kandixia ra jniñu saꞌa Yandios. Xaan ga niꞌin ini ra naa ra ja tu ka jandatu ra nuu Yandios. ¿Nasa ga ti sa kandixia ra naa ra, ja siaꞌan niꞌin ini ra? Ti ja ni kujnaꞌan ja ndoꞌo nene ri ja sɨkɨ roꞌo naa ra. Chaan ni chaa lulu jña, na kii da jaꞌa naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yukan ti ni nduxaan niꞌin ya nuu tachi xaan un, ti yukan ni kendava ni kuaꞌan. Ti yachi ni ni nduvaꞌa chaa lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ko nu ni kuu nuu ga, ni ka jikajnuꞌun ndajaꞌa ya un maa ya: ―¿Ndoo tu ni kuu keniꞌin na tachi xaan un kiꞌin naa na? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ti ni kachi Jesús: ―Sɨkɨ ja tu ka iyo ni ini ra naa ra ja ka kandixia nɨ ini ra Yandios. Ti na kachi ndaa ri nuu ra naa ra, ja nu na kandixia ra Yandios, vasu ɨɨn tɨꞌlɨ, kuꞌva ɨɨn ndɨkɨn lulu, ti nu siaꞌan na, ti kachi ra jiin yuku jaꞌa: “Kuxio jaꞌa ti kuaꞌan undi yukan”, kachi ra jiin. Yukan ti kuxio kiꞌin. Ti nu siaꞌan na kandixia ra Yandios, ti taka ni ga kuu saꞌa ra, chi tu iyo ni ɨɨn jniñu ja kendo siaꞌan ni, nu nɨ ini yo na saꞌa yo. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko ɨɨn tachi xaan nanu siaꞌan, tu kendava kutɨ kiꞌin nu tu kakantaꞌu yo, ti koo ndicha ini yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nɨ ka jikonuu Jesús jiin ndajaꞌa ya ñuu Galilea, ti kachi ya ja maa ya, ja kuu ya Seꞌe Yɨvɨ Ñuyɨvɨ, iyo ɨɨn ndajaꞌa ya ja nakuaꞌa da ya nuu ndaꞌa chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ti kaꞌni yɨvɨ un ya, ko nu uni kɨvɨ ti nandoto tuku ya. Nu ni ka jinisoꞌo ndajaꞌa ya jnuꞌun un, ti ni ka kukuiꞌya xaan ini da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nu ni jaa Jesús jiin ndajaꞌa ya ñuu Capernaum, ti ni ka jaꞌan chaa ka kinyaꞌu puesto nuu veñuꞌun kaꞌnu Israel un, ti ni ka jikajnuꞌun da Pedro siaꞌan: ―¿Tu chaꞌu maestro ra puesto da ja kuu nuu veñuꞌun yo nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yukan ti ni kachi Pedro: ―Kuu ―ni kachi da. Yukan ti nu ni ndɨvɨ Pedro ini veꞌe. Ti xnakan maa ya ni kaꞌan, ti ni jikajnuꞌun ya Pedro: ―¿Nasa ndoꞌo ini ra, roꞌo Simón? ¿Nau nuu yɨvɨ kinyaꞌu chaa ka kuu rey nuu ñuyɨvɨ jaꞌa, nuu yɨvɨ ñuu da xi nuu yɨvɨ ɨnga ñuu nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ti ni kachi Pedro: ―Nuu yɨvɨ ɨnga ñuu ―ni kachi da. Yukan ti ni kachi Jesús: ―Nusa, ti tu ka chaꞌu maa yɨvɨ ñuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko ja nava tu kutɨ ini yɨvɨ naa i, kuaꞌan yuꞌu mar un, ti chunde ra yoꞌo jiin skanchu ra nuu nducha un, ti tava ra ɨɨn chāká ja kenda undi nuu un. Ti ndata yuꞌu tɨ, ti yukan niꞌin ra ɨɨn xuꞌun, ti chaꞌu ra nuu da ja kuu nuu maa ri, jiin ja kuu nuu maa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti yukan ni ka tuꞌva ndajaꞌa Jesús nuu ya, ti ni ka jikajnuꞌun da ya: ―¿Nau kuu ja kuñaꞌnu ga ja kuu nuu taꞌu Yandios jniñu nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yukan ti ni kana Jesús ɨɨn suchi lulu, ni jani ya suchi un maꞌñu da naa da, ");
INSERT INTO mpmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ti ni kachi ya: ―Na kachi ndaa ri ja nu tu nakani ini ra naa ra, ja inijnuni ra na nduu vita ini ra nanu ɨɨn suchi lulu jaꞌa, ni tu ndɨvɨ kuɨtɨ ra ñuu nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ja yukan kuu ja yɨvɨ ka kuñaꞌnu ga nuu taꞌu Yandios jniñu, ka kuu i nanu ɨɨn suchi lulu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jiin jniñu ndiso ri na kachi ri ja nu na kundaꞌu ini ra ɨɨn suchi lulu siaꞌan, ti ja ni kuu ra ɨɨn yɨvɨ ni jantaꞌu ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Siin Jesús ndaku ya, ti ni kachi ya: ―Ɨɨn nundoꞌo kaꞌnu xaan kundatu yɨvɨ nu na xndaꞌu i ɨɨn suchi lulu siaꞌan, ja tu kandixia i ruꞌu. Vaꞌa ga nu na kundikun sukun i jiin ɨɨn yoso molino, ti na kiꞌin i chii nducha lago un. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Xaan ga ndaꞌu yɨvɨ ñuyɨvɨ jaꞌa ja jiin kuachi maa i ka nukoyo uu ga yɨvɨ nuu kuachi. Ti siaꞌan ka saꞌa i, ko na ndaꞌu ga yɨvɨ ka saꞌa siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ti nu iyo ɨɨn ja kuni saꞌa ja na kanakava ra nuu kuachi, nu ndaꞌa ra xi jaꞌa ra kuu ja kuni saꞌa un, kaꞌncha na kiꞌin. Chi vaꞌa ga nu kuꞌlu ra na najaa ra nuu taꞌu Yandios jniñu, ti ansu ja na najaa ndɨꞌɨ ra jiin jaꞌa ra jiin ndaꞌa ra, ti kiꞌin ra nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ti nu nduchi ra kuu ja saꞌa ja na kanakava ra nuu kuachi, tava ti skaña ra na kiꞌin. Chi vaꞌa ga ja na najaa ra nuu taꞌu Yandios jniñu jiin ɨɨn ni nduchi ra, ti ansu ja najaa ra jiin ndɨnduu nduchi ra, ti kiꞌin ra nuu infiernu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Siin Jesús xndaku ya, ti ni kachi ya: ―Koto skexiko ra nuu ɨɨn ɨɨn suchi kuachi jaꞌa naa ra. Chi na kachi ri ja ángel maa i, kancha andɨvɨ ti ndito i suchi, ti kaꞌan i jaꞌa suchi un ja kuu nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chi na kachi ri ja ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, ni chaa ri ja na nama ri taka yɨvɨ ni ka sana i ka jika i nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Na kachi ri ja nasa ka ndoꞌo ini ra sɨkɨ ɨɨn jnuꞌun jaꞌa. Nu ɨɨn chaa ñavaꞌa ɨɨn ciento rɨɨ, ti skuita da ɨɨn tɨ. ¿Xi tu xndoo da ndɨꞌɨ kuun xiko xiaꞌan kuun ga kɨtɨ un, ti kiꞌin nunduku da kɨtɨ ni sana un undi yuku un nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ti nu ni naniꞌin da tɨ, ti jandaa kuu ja kusɨɨ xaan ga ini da jiin kɨtɨ un, ti ansu jiin ndɨ kuun xiko xiaꞌun kuun ga rɨɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ti suni siaꞌan kuu nuu Tata ra Yandios ja kancha ya andɨvɨ, chi tu kuni ya ja na naa ni ɨɨn suchi kuachi siaꞌan ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nu na saꞌa ndevaꞌa ñani ra jiin ra, kuaꞌan maa ni ra ti ndajnuꞌun ra jiin da sɨkɨ ja ni saꞌa da un. Ti nu ni jantaꞌu da jnuꞌun kaꞌan ra ja ni nakuni da falta da, yukan na ti ja ni ndumani ra jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko nu tu jantaꞌu da jnuꞌun kaꞌan ra, ti kana ɨɨn xi uu ga yɨvɨ ja na kujiin yɨ jiin ra, nava jiin jnuꞌun kaꞌan uu xi uni ga testigo un, ti na ndundaa jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ti nu tu chuꞌun soꞌo da nuu jnuꞌun ka kaꞌan testigo un, yukan na ti kasjnuꞌun nuu taka ga yɨvɨ ka kandixia un nu ka ndututu i ka skuaꞌa i. Ti nu suni tu ni jantaꞌu da jnuꞌun ka kaꞌan yɨvɨ ni ka ndututu un, yukan na ti sia da na kiꞌin maa da, chi ni kuu da nanu yɨvɨ tu kandixia jnuꞌun Yandios, xi nanu chaa kinyaꞌu nuu puestuo ja ka sa ndevaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na kachi ndaa ri ja taka ra ndajnuꞌun ra sɨkɨ ɨɨn falta siaꞌan, ti siaꞌan kendo undi nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Suni na kachi ri ja nu vasu uu roꞌo naa ra na ndumani ini, ti kakantaꞌu ra nuu Tata ri Yandios, ya kancha andɨvɨ, ja kuu savaꞌa ni ga ndajniñu ka nandɨꞌɨ ra, ti kuaꞌa ya nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chi nu ni ka ndututu uu xi uni yɨvɨ ka chiñuꞌun i ruꞌu, ti ka ndakuniꞌin yɨ sɨvɨ ri, ti maꞌñu yɨvɨ un kancha maa ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yukan ti ni tuꞌva Pedro nuu ya, ti ni jikajnuꞌun da: ―Jitoꞌyo, ¿Nasa jinu kuu ja kuankaꞌnu ini na nuu ñanijnaꞌan na nu na saꞌa ndevaꞌa da jiin na nusa? ¿Xi undi uxia jinu nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ti ni kachi Jesús: ―Tu kachi ri ja uxia jinu, chi undi uni xiko uxi uxia jinu. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja siaꞌan kuu ja nuu taꞌu Yandios jniñu kuu nanu ɨɨn rey ja ni nanduku jnuꞌun da taka jniñu ka saꞌa muzu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ni kejaꞌa sandoo da jniñu un. Ti ni jaa ɨɨn chaa tau ɨɨn millón pesu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ti tu ni kuu chunaa chaa un xuꞌun kuaꞌa un, chi tundo ñavaꞌa da. Yukan ti ni taꞌu jitoꞌo da un jniñu ja na kuyaꞌu da jiin ñasɨꞌɨ da nɨɨ jiin seꞌe da, jiin taka ja ñavaꞌa da, nava na ndenaa ja tau da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ti chaa un ni jakunjitɨ da nuu jitoꞌo da, ti ni kaꞌan ndaꞌu da jiin da siaꞌan: “Niꞌin ja kuu ni jitoꞌo na, kundaꞌu ini ni saña, ti sakaꞌnu ini ni nuu na sa na chunaa ndɨꞌɨ na xuꞌun ni”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ti rey un ni kundaꞌu ini da, ti ni jankaꞌnu ini nuu muzu da un, ti ni sia da chaa un kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ko sa ni kenda muzu un kuaꞌan da, ti ni ndejnaꞌan da jiin ɨnga jnaꞌan muzu da nuu ka junukuachi da un, ti chaa un tau jaku ni xuꞌun nuu maa da. Ti ni jnɨɨ da sukun chaa un, ni kejaꞌa skuaꞌña da chaa, ti ni kachi da: “¡Chunaa ja tau ra nuu ri”! ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ti ɨnga chaa un ni jakunjitɨ da nuu da, ti ni kaꞌan ndaꞌu da jiin da: “Kundatu kuee tɨꞌlɨ, ti na chunaa ndɨꞌɨ ri xuꞌun ra”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ko maa chaa un tu ni kuni da. Ti ni kankuachi da, ti ni chunde da chaa un vekaa undi ni chunaa ndɨꞌɨ da ja tau da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ko nu ni ka jini uu ga jnaꞌan muzu un ja siaꞌan ni kuu, ti ni ka naꞌnu xaan ini da, ti ni ka jaꞌan ka kasjnuꞌun da nuu jitoꞌo da taka nava ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yukan ti ni kana jitoꞌo un chaa ni saꞌa siaꞌan un, ti ni kachi da jiin da: “Roꞌo, chaa ka kuaꞌan ka vaji kuu ra. Ni jankaꞌnu ini ri nuu ra taka ja tau ra, chi ni kandaꞌu ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ti suni siaꞌan roꞌo kuankaꞌnu ini ra nuu jnaꞌan muzu ra un ni kuu, nanu ni jankaꞌnu ini ri nuu maa ra”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yukan ti ni kɨtɨ xaan ini jitoꞌo da un, ti ni taꞌu da jniñu ja na kɨvɨ chaa un vekaa undi na chunaa da taka ja tau da un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ti sandɨꞌɨ ni ga ni kachi Jesús: ―Ti suni siaꞌan saꞌa Tata ri Yandios jiin ra naa ra nu tu kuankaꞌnu ini ra naa ra nuu ñanijnaꞌan ra jiin ni ini ni añu ra, nu savaꞌa ni ga ja na saꞌa da jiin ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ni kee ya ñuu Galilea, ti kuaꞌan ya ichi ñuu Judea ja kendo ichi nuu kaña ndikandii, nuu yucha Jordán. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kuaꞌa xaan yɨvɨ ni ka jaꞌan jiin Jesús, ti yukan ni saꞌa ya tajna yɨvɨ ka kuꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yukan ti ni ka tuꞌva sava chaa fariseo nuu Jesús ja ka kuni skanakava da ya jiin ɨɨn jnuꞌun kaꞌan ya, ti ni ka jikajnuꞌun da ya: ―¿Kuu xndoo ɨɨn chaa ñasɨꞌɨ da nu savaꞌani ga sɨkɨ ndoo na kuu nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yukan ti ni kachi Jesús: ―¿Va tu ka skuaꞌa ra tutu Yandios naa ra, ja undi nuu ni saꞌa Yandios ɨɨn chaa jiin ɨɨn ñasɨꞌɨ nusa? ");
INSERT INTO mpmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Suni ni kachi ya: “Ja yukan kuu ja ɨɨn chaa nuu na niꞌin da ñasɨꞌɨ da, ti xndoo da tata da jiin nana da, ti ndɨnduu da ni ka nduu ɨɨn ni ga. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ja yukan kuu ja tukaa ga ka kuu da uu yɨvɨ, chi ni ka nduu da ɨɨn ni ga yɨvɨ”, kachi ya. Ja yukan kuu ja ɨɨn chaa, tu kuu saꞌa sɨɨn da ja ni chajnaꞌan Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yukan ti ni ka jikajnuꞌun tuku da: ―¿Ndoo ni kachi Moisés ja ɨɨn chaa, kuu xndoo da ñasɨꞌɨ da nu na ndokani da ɨɨn tutu, ti kuaꞌa da nuu ña ja ni ka kusɨɨn da nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ti ni kachi Jesús: ―Siaꞌan ni kuu, chi vanuxia ndee niꞌin ini ra naa ra. Ja yukan kuu ja ni jaꞌa Moisés jnuꞌun ja na xndoo ra ñasɨꞌɨ ra naa ra, ko undi nuu tu ni iyo siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na kachi ri nuu ra naa ra, ja nu ɨɨn chaa na xndoo da ñasɨꞌɨ da, ko nu tu ni kanakava ña jiin ɨnga chaa, ti nandaꞌa da jiin ɨnga ña, suni ni nchakuachi da, chi ja ni yɨsɨkɨnchaa da ñasɨꞌɨ da undi nuu. Ti suni nu ɨɨn chaa na nandaꞌa jiin ɨɨn ñasɨꞌɨ ni kendo, suni ni nchakuachi da ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yukan ti ni ka kachi ndajaꞌa ya: ―Ti nu siaꞌan kuu jiin chaa un naa da ja nu na nandaꞌa da jiin ɨɨn ñasɨꞌɨ, ti iyo vaꞌa ga nu tu nandaꞌa da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ti ni kachi Jesús tuku: ―Ansu tendɨꞌɨ yɨvɨ ka chaku ini jnuꞌun un, chi nɨnɨ yɨvɨ ni jaꞌa Yandios inijnuni, yukan ni kuu ja ka chaku ini. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iyo tɨjnɨ nuu jnuꞌun ja jasɨ ja tu kuu nandaꞌa ɨɨn chaa. Iyo chaa sa vaji da undi chii nana da ja tu kuu kunchaka da ñasɨꞌɨ. Ti ka iyo sava chaa ja ni ka kuu tajna da nava tu kuu kunchaka da ñasɨꞌɨ. Ti ka iyo sava ga chaa ka kendo siaꞌan ni, sɨkɨ ja ka ñukuu ini da siuku da nava taꞌu Yandios jniñu. Nau roꞌo ka kuni kuantaꞌu jnuꞌun jaꞌa, ti kuantaꞌu ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yukan na ti sava yɨvɨ un ni ka janchaka i tɨjnɨ suchi kuachi nuu Jesús ja na chuxndee ya ndaꞌa ya xini i, ti na kakantaꞌu ya ja kuu suchi kuachi un nuu Yandios. Ko ndajaꞌa ya ni ka nduxaan da jiin chaa vekoyo jiin suchi kuachi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yukan ti ni kachi Jesús: ―Sia naa ra na kikoyo i nuu ri, ti tu kasɨ ra naa ra. Chi taka yɨvɨ ka kuni kɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, ti kuni ja na kɨvɨ i nanu suchi kuachi jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yukan ti ni chuxndee ya ndaꞌa ya xini suchi kuachi un ja na koto ndaꞌu Yandios maa i naa i. Yukan na ti ni kee ya kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ti yukan ni jaꞌan ɨɨn chaa riku nuu kande Jesús, ni jikajnuꞌun da ya, ti ni kachi da: ―Chaa vaꞌa kuu ni, maestro. Ti kachi ni, ¿naa jniñu vaꞌa saꞌa na ti nava niꞌin taꞌu na ja na kuchaku na ja kuu saa ni? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ti ni kachi ya jiin da: ―¿Ndoo kaꞌan ra ja chaa vaꞌa kuu ri, ti tu ni ɨɨn chaa vaꞌa iyo, chi maa ɨɨn ni Yandios? Ko nu kuni ra ja na niꞌin taꞌu ra, ti kuandatu taka jniñu taꞌu Yandios ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ti ni kachi chaa un: ―¿Nau ja kuu nusa? ―kachi da. Ti ni kachi Jesús jiin da: ―Tu kaꞌni ra ndɨyɨ, tu xndaꞌu ra ñasɨꞌɨ, tu sakuiꞌna ra, tu chakuachi ra yɨvɨ, ");
INSERT INTO mpmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kuandatu nuu tata ra nuu nana ra, ti kundaꞌu ini ñanijnaꞌan ra nanu kundaꞌu ini ra nuu maa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ti ni kachi chaa un: ―Ja ni ndɨꞌɨ un ni siuku na undi lulu na, ¿Ti ndoo kumani ga nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ti ni kachi tuku Jesús: ―Nu kuni ra ja na kendo vaꞌa ra, kuaꞌan ti xiko ra taka ja ñavaꞌa ra, ti kuaꞌa nuu yɨvɨ ndaꞌu naa i. Yukan na ti na kuaꞌa Yandios taꞌu ra iyo andɨvɨ. Yukan na ti sa kii ra na choꞌo ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu ni jinisoꞌo chaa un ja siaꞌan ni kachi Jesús, ni kukuiꞌya xaan ini da ti kuaꞌan da, chi vanuxia chaa riku xaan kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yukan na ti ni kachi Jesús jiin ndajaꞌa ya: ―Jandaa na kachi ri nuu ra naa ra, ja yɨɨ xaan kaa ja kuu ɨɨn chaa riku ja na xndoo da ichi maa da, ti kɨvɨ da ndaꞌa Yandios ja na taꞌu ya jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na kachi tuku ri ja va yachi ga yaꞌa ɨɨn camellu yau ɨɨn yɨkɨ tɨkuɨ, ti ansu ja najaa ɨɨn chaa riku nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu ni ka jinisoꞌo ndajaꞌa ya jnuꞌun un, so ni ka naa ini da, ti ka jikajnuꞌun jnaꞌan da: ―¿Nau kuu ja nanitaꞌu nusa? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ni ndeꞌe Jesús nuu da naa da, ti ni kachi ya: ―Ni ɨɨn yɨvɨ tu kuu saꞌa un, ko Yandios, chi taka ni, ja kuu saꞌa ya ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yukan ti ni kachi Pedro jiin ya: ―Jitoꞌyo, saña naa na, ni ka xndoo na taka ja ka ñavaꞌa na ti vekoyo na jiin ni, ¿ti ndoo niꞌin na nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ti ni kachi Jesús: ―Jandaa na kachi ri nuu ra naa ra, ja nu na jaa kɨvɨ ja ndujaa ñuyɨvɨ jiin andɨvɨ, ti nduñaꞌnu roꞌo naa ra. Ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, nduñaꞌnu xaan ga ri, ti nukoo ri andɨvɨ nuu xndichi ri tendɨꞌɨ kuɨtɨ yɨvɨ naa i. Ti taka roꞌo ja ka kuu ra ndajaꞌa ri, suni nduñaꞌnu ra, ti nukoo ra nuu uxi uu teyu ka kuñaꞌnu. Ti yukan xndichi ra nuu ndɨ uxi uu familia ja ni ka nakaya nuu nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ti taka yɨvɨ ni ka xndoo veꞌe ñani, xi kuaꞌa, tata xi nana, ñasɨꞌɨ xi seꞌe da, ja ka kuni kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, ti naniꞌin i viꞌi ga ja kuu taka ja ni ka xndoo i un. Ti nanitaꞌu i nuu Yandios ja na kuchaku i ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ko kuaꞌa yɨvɨ ka kunuu un vijna, ti yɨvɨ un ndundaꞌu ga i ñuu nuu taꞌu Yandios jniñu. Ti kuaꞌa yɨvɨ ndaꞌu ja tu ka kuñaꞌnu vijna, ti yɨvɨ un kuu ja nduñaꞌnu ñuu nuu taꞌu Yandios jniñu ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Siin Jesús xndaku ya, ti ni kachi ya: ―Nuu ñuu nuu taꞌu Yandios jniñu, nu kuaꞌa ri kuu taꞌu yɨvɨ ri, kuu nanu ɨɨn chaa ñavaꞌa kuaꞌa jniñu ja ni kenda da ɨɨn jañaꞌan, kuan nduku da muzu ja na kaꞌncha ndeꞌe tɨkaꞌya. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ni ka ndajnuꞌun da jiin muzu un, ja chaꞌu da nava kuu yaꞌu da nuu ɨɨn kɨvɨ. Ti ni taji da chaa un kuan saꞌa da jniñu nuu ñuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ni kuu ka ɨɨn jañaꞌan, ni kenda da kuaꞌan da nuu yaꞌu, ti yukan ni jini da kaꞌiin uu ga chaa ka iyo nuña. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ti ni kachi da: “Kuan saꞌa jniñu nuu ñuꞌun ri ti chaꞌu vaꞌa ri kɨvɨ ra”, ni kachi da. Ti chaa un kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ni kuu sava nduu, ti ni jaꞌan tuku da. Suni ni niꞌin tuku da uu ga muzu. Ni kuu ka uni ti ni jaꞌan tuku da, ti ni niꞌin da uu ga muzu. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nu kuan kuu ka uꞌun jaꞌini, ni jaꞌan tuku da nuu yaꞌu. Yukan ni jini da kaꞌiin tuku uu ga chaa ka iyo nuña, ti ni kachi da jiin chaa un: “¿Ndoo kaꞌiin ra siaꞌan ni jaꞌa nɨ nchaka, ndoo tu ka saꞌa jniñu ra”? ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ti ni ka kachi chaa un: “Tuu, chi tu kenda ni ɨɨn chaa nduku muzu”, ni ka kachi da. Ti ni kachi chaa un: “Kuan saꞌa jniñu nuu ñuꞌun ri un naa ra, ti chaꞌu vaꞌa ri roꞌo”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nu ni kuaa, ti ni kachi da jiin chaa yɨndaꞌa muzu un: “Kana chaa ka saꞌa jniñu un, ti chaꞌu ra nuu da, ko kejaꞌa chaꞌu ra nuu chaa ni ka kɨvɨ sandɨꞌɨ ni ga un, ti sandɨꞌɨ ni ga chaꞌu ra chaa ni ka kɨvɨ undi ñaꞌan un”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yukan ti ni ka jakoyo chaa ni ka kɨvɨ ka uꞌun jaꞌini un, ti taka da ni ka kinyaꞌu vaꞌa da nava ka kinyaꞌu da ɨɨn kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yukan ti nu ni ka jakoyo chaa ni ka kɨvɨ undi na ñaꞌan un, ni ka ndoꞌo ini da ja viꞌi ga kinyaꞌu da niku, ko suni ɨɨn nuu ni ni ka kinyaꞌu da naa da nava kuu yaꞌu da nuu ɨɨn kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ni ka kiꞌin da xuꞌun yaꞌu da un, ti ni ka kejaꞌa ka kankuachi da sɨkɨ chaa xiin jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ni ka kachi da: “Chaa ni ka jakoyo sandɨꞌɨ ni ga jaꞌa, ɨɨn hora ni ni ka saꞌa da jniñu, ti ɨɨn nuu ni ni chaꞌu ni da jiin saña naa na, ja ni ka saꞌa jniñu na nchaka nchaa nuu niꞌni xaan un, ti niꞌin xaan ni ka sajniñu na”, ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ti ni kachi chaa xiin jniñu un nuu ɨɨn da: “Ndeꞌe naa kachi ri. Ansu xndaꞌu ri roꞌo ja saꞌa ndevaꞌa ri. ¿Xi ansu ni ka ndajnuꞌun yo ja chaꞌu ri nuu ra nava kinyaꞌu ra ɨɨn kɨvɨ nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kiꞌin xuꞌun yaꞌu ra ti kuan noꞌon. Chi ruꞌu maa ri, kuni ri chaꞌu ri chaa ni ka kɨvɨ sandɨꞌɨ ni ga jaꞌa, nanu ni chaꞌu ri roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Xi tu iyo ichi ri ja saꞌa ri nava kuu ini maa ri jiin xuꞌun ri nu? ¿Xi kuu kuasun ini ra ja vaꞌa ni chaꞌu ri nu”? kachi da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ti ja sɨkɨ jnuꞌun chaa ni ka saꞌa jniñu un, ni kachi Jesús nuu ndajaꞌa ya: ―Ja siaꞌan kuu ja kuaꞌa yɨvɨ ka kundaꞌu vijna, nduñaꞌnu i ñuu nuu taꞌu Yandios jniñu. Ti kuaꞌa yɨvɨ ka kuñaꞌnu vijna ndundaꞌu i ñuu nuu taꞌu Yandios jniñu ja kuu saa ni, chi kuaꞌa yɨvɨ na stutu ya ja ka kɨvɨ i ñuu nuu taꞌu ya jniñu, ko jaku ni kuu ja ni nakaji ya ja na nduñaꞌnu i, ti tatu ya ɨɨn jniñu ñaꞌnu ga nuu i ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nu kuaꞌan Jesús ichi ñuu Jerusalén, ni kana sɨɨn ya ndɨ uxi uu ndajaꞌa ya un, ti ni kachi ya jiin da: ");
INSERT INTO mpmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ja ka jini ra naa ra ja, ja kuankoyo yo ichi ñuu Jerusalén. Ti yukan ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa yɨvɨ ruꞌu nuu sutu ka kuñaꞌnu jiin nuu chaa ñaꞌnu ja ka xnaꞌan ley un, ti kaꞌni da ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nakuaꞌa chaa un ruꞌu nuu ndaꞌa yɨvɨ ɨnga nación, ti kusɨkɨ nchaa yɨvɨ un ruꞌu, kuaꞌa da tau ri, ti katakaa da ruꞌu nuu ndaꞌa cruz, ja na kuū ri. Ko nu uni kɨvɨ ti nandoto tuku ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yukan ti nana Jacobo jiin Juan, chaa ka kuu seꞌe yɨɨ Zebedeo, ni ka tuꞌva da jiin ña nuu Jesús, ni jakunjitɨ ña nuu ya ja jikan ña ɨɨn taꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ni jikajnuꞌun ya ñaꞌan un, ti ni kachi ya: ―¿Ndoo kuni ra nusa? ―ni kachi ya. Ti ni kachi ñaꞌan un jiin ya: ―Nu na najaa ni ñuu nuu taꞌu ni jniñu, ti kuaꞌa ni xiin ni na kunchuku uu ndɨnduu seꞌe na jaꞌa, ɨɨn da na kuncha nundaꞌa kuaꞌa ni, ti ɨnga da na nukoo nundaꞌa sajni ni ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ti ni kachi Jesús nuu ña jiin seꞌe ña: ―Roꞌo naa ra, tu ka jini ra ndoo ka jikan ra. ¿Xi kuu kondoꞌo ra jiin ri nuu ɨɨn nundoꞌo kii sɨkɨ ri nu? ―kachi ya. Ti maa da ni ka kachi da: ―Kuu saꞌa na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yukan ti ni kachi ya: ―Jandaa kuu ja kuu kondoꞌo jnaꞌan ra jiin ri jiin nundoꞌo kii sɨkɨ ri. Ko ja na nukoo ra nundaꞌa kuaꞌa ri jiin nundaꞌa sajni ri, ansu ruꞌu kuu ja kuaꞌa un, chi maa Tata ri Yandios, kuu ya jini nau yɨvɨ ni satuꞌva ya ja na kunchuku un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu ni ka jinisoꞌo ndɨ uxi ga ndajaꞌa un naa da, ti ni ka kɨtɨ xaan ini da nuu ndɨnduu chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ko ni kana Jesús chaa un naa da, ti ni kachi ya jiin da: ―Ja ka jini ra naa ra, ja chaa ka taꞌu jniñu nuu ɨnga nación, ka taꞌu da jniñu nanu ɨɨn chaa taꞌu jniñu nuu muzu da. Ti chaa ka kuñaꞌnu un, suni ka iyo ja ka taꞌu niꞌin ga jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko tu kuu siaꞌan jiin roꞌo naa ra, chi nu nau roꞌo ka kuni kuñaꞌnu, ti suꞌva na kunukuachi ra nuu ñanijnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ti nu nau roꞌo ka kuni kunuu, ti suꞌva nduu ra muzu nuu taka ga da naa da, ");
INSERT INTO mpmNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","siaꞌan nanu ruꞌu. Tu ni chaa ri ja kunukuachi yɨvɨ nuu ri, chi ni chaa ri ja kunukuachi ri nuu yɨvɨ, ti nakuaꞌa ri yɨkɨ kuñu ri ja nama ri sɨkɨ yɨvɨ naa i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nu ni ka kee da ñuu Jericó, ti kuaꞌa xaan yɨvɨ ni ka ndikun kuankoyo jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ti yuꞌu ichi un kanchuku uu chaa kuaa, ti nu ni ka jinisoꞌo da ja kuan yaꞌa Jesús, ti ni ka kanajiin da: ―¡Jitoꞌyo, niꞌin ja taꞌu ni jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña naa na! ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ti yɨvɨ kuankoyo un ni ka kanajiin nuu da ja na kasɨ yuꞌu da, ko maa da viꞌi ga ni ka kana koꞌo da: ―¡Jitoꞌyo, ja taꞌu ni jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña naa na! ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yukan ti ni jakuɨñɨ Jesús, ni kana ya xini da, ti ni jikajnuꞌun ya maa da: ―¿Ndoo ka kuni ra ja saꞌa ri jiin ra, nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ti ni ka kachi da: ―Jitoꞌyo, ja na ndundijiin nduchi na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yukan ti ni kundaꞌu ini Jesús nuu da naa da. Ni kueꞌe ya nduchi da, ti ni ka ndundijin ni nduchi da. Ti ni ka ndikun da kuankoyo da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nu ni kuyajni Jesús jiin ndajaꞌa ya ñuu Jerusalén, ni jaa ya ñuu Betfagé, yajni yuku Olivos, ti ni taji ya uu ndajaꞌa ya, ");
INSERT INTO mpmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ti ni kachi ya jiin da: ―Kuaꞌan ranchu kande yajni un naa ra. Ti yukan naniꞌin ra nuu ndikun ɨɨn burra jiin ɨɨn burru lulu. Ndaji tɨ, ti kii ra jiin tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ti nu nau yɨvɨ ni kenda kaꞌan, ti kachi ra ja maa jitoꞌo ra jikan tɨ, ko vinañuꞌni kii nunchaka na tɨ, kachi ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ti siaꞌan ni kundaa nava ni kachi profeta na ni chaa da nuu tutu: ");
INSERT INTO mpmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kachi jiin ñuu Sion naa ra: “Ndeꞌe, xaan ndaꞌu vaji rey ra naa ra, chi vaji ya jiin burra, ti yoso ya sɨkɨ seꞌe tɨ. Ti seꞌe tɨ un kuu ɨɨn burru lulu, seꞌe ɨɨn kɨtɨ ndiso carga.” Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yukan ti ni ka jaꞌan ndajaꞌa ya un nava ni taꞌu ya jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ni ka chakoyo da jiin burra un, ndɨnduu tɨ jiin seꞌe tɨ. Ni ka chuku da saꞌma da sɨkɨ tɨ, ti ni yoso ya tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ti yɨvɨ kuaꞌa kuankoyo un ni ka chuku i saꞌma i ini ichi un, ti sava i ni ka jaꞌncha ndaꞌa yujnu. Ti ni ka chuku i ini ichi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ti yɨvɨ ka yoxnuu jiin yɨvɨ kuankoyo ichi jata, ni ka kejaꞌa ka kuvaa i ka kanajaa i Yandios, ti ni ka kachi i: ―¡Niꞌin kuu chaa kuñaꞌnu, chi maa ni kuu jnaꞌan rey David na janaꞌan! Na kuantaꞌu yo nuu Jitoꞌyo Yandios, chi ni taji ya ɨɨn chaa ndiso jniñu ñaꞌnu nuu ya? ¡Na kachi ndajaꞌa ya undi andɨvɨ un ja na kuñaꞌnu Chaa jaꞌa! ¡Siaꞌan na kachi ya! ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nu ni kɨvɨ Jesús ñuu Jerusalén, ti ni ka kuvaa yɨvɨ ñuu, ti ka jikajnuꞌun i: ―¿Naa chaa kuu jaꞌa? ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ti ni ka kachi yɨvɨ un naa i: ―Jaꞌa kuu Jesús chaa kuu profeta, kuu da ɨɨn chaa ñuu Nazaret, ɨɨn ndañuu Galilea ―kachi yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nu ni jaa Jesús nuu yuxeꞌe veñuꞌun kaꞌnu un, ti ni keniꞌin ya taka yɨvɨ ka xiko jiin ja ka jaan un kuankoyo i. Ni skuikokava ya taka mesa nuu kanchuku chaa ka sama xuꞌun yɨvɨ naa i, jiin taka silla nuu kanchuku ja ka xiko sata. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ti ni kachi ya jiin yɨvɨ un: ―Siaꞌan yoso nuu tutu Yandios: “Veꞌe ri konani veꞌe nuu kakantaꞌu yɨvɨ naa i”, ko roꞌo naa ra, ni ka nasaꞌa ra veꞌe ri nuu ka nataka ñakuiꞌna ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti nuu yuxeꞌe veñuꞌun un ni ka tuꞌva tɨjnɨ yɨvɨ kuaa jiin yɨvɨ ni ka kuu tɨkuku nuu Jesús, ti ni saꞌa ya tajna yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko sutu ka kuñaꞌnu un jiin chaa ñaꞌnu ka xnaꞌan ley un, ni ka kɨtɨ ini da, chi ni ka jini da jniñu ñaꞌnu ni saꞌa Jesús, jiin ja ni jinisoꞌo da ja ka kanajiin suchi kuachi un ini veñuꞌun un siaꞌan: “¡Na kuñaꞌnu ni, chi ni nakaji Yandios niꞌin ja na nukuñɨ ni nuu rey David na janaꞌan, ti taꞌu ni jniñu!” ―kachi i naa i. Yukan ti ni ka kɨtɨ ini chaa ka kuñaꞌnu un, ");
INSERT INTO mpmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ti ni ka kachi da jiin Jesús: ―¿Jinisoꞌo ra jnuꞌun ka kaꞌan suchi kuachi jaꞌa nu? ―ni ka kachi da. Ti ni kachi Jesús jiin da naa da: ―Ñusoꞌo ri, ko ¿xi tu ka kaꞌu ra nuu tutu Yandios ja kaꞌan ja na nakanajaa i ya nu? Ko siaꞌan kaꞌan nuu tutu un: Ni saꞌa ra ja taka suchi kuachi jiin suchi ka yaxin, ja vaꞌa na kanajaa i roꞌo. Kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yukan na ti ni xndoo ya yɨvɨ un, ni kee ya ñuu un, ti kuaꞌan ya ñuu Betania. Ti yukan ni kendo ya jakuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ti nu ni kundijin ɨnga kɨvɨ, ni nandeokuñɨ tuku Jesús ñuu Jerusalén, ti ni kejaꞌa jiꞌi ya soko. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ni jini ya kandichi ɨɨn nutɨchɨ vixi yajni yuꞌu ichi un, ni tuꞌva ya jaꞌa, ko tundo ni niꞌin ya xini, chi mani ndaꞌa kuu, ti ni kachi ya jiin nutɨchɨ un: ―¡Na kachi ri ja jankɨvɨ ñuu ga kuaꞌa ra tɨchɨ vixi! ―ni kachi ya. Ti hora ni ni ichi nutɨchɨ vixi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nu ni ka jini ndajaꞌa ya un, ni ka naa ini da, ti ni ka jikajnuꞌun da ya: ―¿Nasa kuu ja xaan yachi ni ichi nutɨchɨ un? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ti ni kachi Jesús: ―Jandaa na kachi ri nuu ra naa ra ja nu ka kandixia ni ini ra Yandios, ti tu kondoꞌo sɨkɨ ini ra, ti ansu nɨnɨ ja ni saꞌa ri jiin nutɨchɨ jaꞌa kuu saꞌa ra. Chi suni kuu kachi ra jiin yuku jaꞌa: “Kuxio jaꞌa ti kuan kɨvɨ ini lago un”, ti siaꞌan kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ti taka ja na kakantaꞌu ra nuu Yandios, ko nu na kandixia ni ini ra Yandios, ti niꞌin ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yukan ti ni kɨvɨ Jesús nuu veñuꞌun kaꞌnu un, ti nu xnaꞌan ya nuu yɨvɨ un, ni ka tuꞌva sutu ka kuñaꞌnu un jiin tɨjnɨ chaa ka kuñaꞌnu ñuu Israel, ti ni ka jikajnuꞌun da ya: ―¿Nau ja ni taꞌu jniñu ja saꞌa ra taka jniñu jaꞌa? ¿Xi nau ja ni jaꞌa jniñu ñaꞌnu jaꞌa nuu ra nusa? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti ni kachi Jesús jiin da: ―Suni ruꞌu, na kajnuꞌun ri roꞌo naa ra ɨɨn jnuꞌun. Ti nu ni ka kachi ndaa ra nuu ri, ti sa na kachi ri nuu ra nau ja ni jaꞌa jniñu jaꞌa nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kachi nuu ri, ¿nau ja ni tatu jniñu nuu Juan ja ni kii skuanducha da yɨvɨ un nusa? ¿Ɨɨn yɨvɨ ni tatu jniñu un nuu da xi maa Yandios nú? ―ni kachi ya. Yukan ti ni ka kejaꞌa ka ndajnuꞌun maa da naa da, ti kachi da: ―Nu na kachi yo ja Yandios ni taji chaa un, ti kachi da jiin yo: “¿Ndoo tu ni ka kandixia ra jnuꞌun ni kaꞌan da nusa”? kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ti nu na kachi yo ja yɨvɨ ni taji da, ti yuꞌu yo yɨvɨ, chi tendɨꞌɨ yɨvɨ ka kandixia ja Juan ni kuu ɨɨn profeta, ja ni kaꞌan jnuꞌun Yandios ―kachi da ka ndajnuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yukan na ti ni ka kachi da jiin Jesús: ―Tu ka jini na ―ni ka kachi da. Yukan na ti ni kachi ya jiin da naa da: ―Vanuxia tu ka kuni kachi ra, ti suni ruꞌu, tu ra kachi ri nuu ra nau ja ni jaꞌa jniñu ñaꞌnu jaꞌa nuu ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ni kachi ya jiin chaa ñaꞌnu un: ―¿Nasa ka ndoꞌo ini ra nu na kachi ri ɨɨn jnuꞌun jaꞌa nusa? Ɨɨn chaa ni iyo uu seꞌe yɨɨ, ni kachi da jiin ɨɨn seꞌe da un: “Hijo, kuan saꞌa jniñu nuu nutɨkaꞌya yo vijna”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ko ni kachi chaa lulu un: “Tu kuni na kiꞌin na”, ni kachi da. Ko kuee ga ni nakani ini da, ti ni jan saꞌa da jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yukan na ti ni kaꞌan tuku tata da un jiin ɨnga seꞌe yɨɨ da, ti suni siaꞌan ni taꞌu tuku da jniñu nuu suchi un, ti chaa lulu un ni kachi da: “Kuu, na kiꞌin na”, ni kachi da. Ko tu ni jaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nau ɨɨn ɨɨn chaa un ni jandatu nava ni taꞌu tata da jniñu un nusa? ―ni kachi Jesús. ―Chaa ni kaꞌan da jiin undi nuu un ―ni ka kachi chaa ka kuñaꞌnu un. Yukan na ti ni kachi Jesús jiin da naa da: ―Jandaa na kachi ri nuu ra naa ra, roꞌo kuu ra chaa ka kuñaꞌnu. Ja kuu chaa ka kinyaꞌu nuu puesto un jiin ñaꞌan sɨɨ ini ja tɨndɨ ña chaa, va tu uꞌu nakani ini yɨvɨ un, ti yachi ga kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Yachi ga kɨvɨ yɨvɨ un ja kuu roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chi ni kii Juan, chaa ni skuanducha un, ti ni xndaku da nava kachi Yandios ja na nakani ini ra naa ra, ko tu ni ka kandixia ra jnuꞌun ni kaꞌan da. Ti chaa ka kinyaꞌu puesto jiin ñaꞌan sɨɨ ini un naa ña, chi ni ka kandixia ndaa da. Ti roꞌo naa ra, vasu ni ka jini ra ja, ja ni ka nakani ini yɨvɨ ni ka jika kueꞌe un, ko tu ni ka nakani kuɨtɨ ini ra ja na kandixia ra jnuꞌun ni kaꞌan da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Siin Jesús xndaku ya sɨkɨ muzu ja ni ka sajniñu ndevaꞌa, ti ni kachi ya: ―Kunsoꞌo ɨnga jnuꞌun na kachi ri nuu ra naa ra. Ɨɨn chaa ni ñavaꞌa kuaꞌa xaan ñuꞌun ni xndee kuaꞌa da nutɨkaꞌya, ti ni chiꞌi da ɨɨn jaku nɨɨ kani yuꞌu ñuꞌun da un. Ni saꞌa da ɨɨn nundoo kaꞌnu xaan nuu kaxin da tɨkaꞌya un, ti ni jani da ɨɨn veꞌe sukun xaan ja na kundijin kotonchaa da nuu nɨ tuꞌu jniñu da un. Yukan na ti ni jakanchaa da ñuꞌun un nuu chaa ka sajniñu un, ti kuaꞌan da ɨɨn viaje. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nu ni jaa kɨvɨ nastutu da tɨkaꞌya un, ti ni taji da muzu ja na kin kakan da sava tɨkaꞌya ja kuu maa da nuu chaa ka yɨndaꞌa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ko chaa ka sajniñu un ni ka jaꞌa da tau ɨɨn chaa ka kuu muzu un, ni ka jaꞌni da ɨnga da, ti ni ka stau da yuu sɨkɨ ɨnga muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ti chaa xiin ñuꞌun un ni taji tuku da tɨjnɨ ga muzu da ja kuu chaa ni ka jaꞌan undi nuu, ko chaa ka jito ñuꞌun, suni siaꞌan ni ka saꞌa tuku da jiin muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sandɨꞌɨ ni ga, ti ni taji da maa seꞌe yɨɨ da, chi ni ndoꞌo ini da: “Va kuaꞌa da ja yɨñuꞌun seꞌe ri”, ni ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko nu ni ka jini chaa ka sajniñu un nuu seꞌe chaa xiin ñuꞌun un, ti ni ka kachi da: “Chaa jaꞌa kuu ja xiin taꞌu. Vaꞌa ga na kaꞌni yo ti na kendo ndɨꞌɨ yo jiin yaji jaꞌa”, ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ni ka jnɨɨ da chaa un, ni ka keniꞌin da chaa un fuera nuu ñuꞌun un, ti ni ka jaꞌni da chaa. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ko nu na chaa chāā xiin ñuꞌun un, ti ¿ndoo saꞌa da jiin chaa ka sajniñu un nusa? ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti ni ka kachi chaa ka kuñaꞌnu un: ―Naa ii da chaa un, chi kaꞌni ndɨꞌɨ da chaa, chi tu kundaꞌu kuɨtɨ ini da chaa un naa da. Ti kakanchaa tuku da ñuꞌun un nuu uu ga chaa ka sajniñu vaꞌa, nava na nakuaꞌa da sava jniñu un nuu da jiin kɨvɨ nu ni kaña jniñu ―ni ka kachi chaa ka kuñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yukan ti ni kachi Jesús jiin da naa da: ―Ja ka jini vaꞌa ra nasa kaꞌan nuu tutu Yandios: Yuū ni ka skaña chaa ni ka saꞌa nama un, jaꞌa kuu yuū kanuu ga ja ndiso teyɨɨ ga jɨkɨ ɨɨn veꞌe. Maa Yandios ni saꞌa jniñu un, ti so ka naa ini yo ka ndeꞌe yo. Kachi tutu Yandios. Ti roꞌo naa ra, ɨɨn nuu kanda ra jiin chaa ni ka saꞌa nama un, chi tu ni ka kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yukan kuu ja tukaa kuaꞌa Yandios jnuꞌun ja kɨvɨkoyo kuaꞌa ra ndaꞌa ya ja na taꞌu ya jniñu nuu ra naa ra. Chi kuaꞌa ya nu nɨnɨ yɨvɨ ni ka nakani ini ti ni ka kandixia i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ti siaꞌan nanu ni ka saꞌa chaa ni ka skaña yuū un, vasu ni kuu yuū kanuu ga, suni siaꞌan ka kuu yɨvɨ tu ka jantaꞌu ruꞌu. Ti siaꞌan nanu ka tuji yɨvɨ ka jiokava sɨkɨ ɨɨn yuū, suni siaꞌan jnaꞌnu ndatu yɨvɨ tu kandixia ruꞌu. Ko kɨvɨ na saꞌa ndaa Yandios kuachi i, ti yɨvɨ tu ni kandixia ruꞌu, kondoꞌo i nanu jnaꞌan ɨɨn yɨvɨ kanakava ɨɨn yuū sɨkɨ i, ti taxiin i, kukuachi i saꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu ni ka jinisoꞌo sutu ka kuñaꞌnu un jiin chaa fariseo un ja siaꞌan ni kaꞌan Jesús, ti ni ka chaku ini da ja sɨkɨ maa da ni kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yukan na ti ni ka nduku da nasa jnɨɨ da ya yukan, ko vanuxia ni ka yuꞌu da yɨvɨ, chi tendɨꞌɨ yɨvɨ ka chiñuꞌun i ya, ja ni kuu ya ɨɨn profeta ja kaꞌan jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ni kejaꞌa tuku Jesús kaꞌan ya nuu yɨvɨ un jiin tɨjnɨ jnuꞌun, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ti ja na kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, kuu nanu ɨɨn rey ja ni saꞌa da ɨɨn viko ni nandaꞌa seꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ni taji da chaa ka junukuachi nuu da un, ja na kin kana da chaa, ni kaxjnuꞌun da nuu ja na jakoyo viko un. Ko vanuxia tu ni ka kuni chaa un kinkoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ni taji tuku da uu ga chaa ka junukuachi nuu da un, ti ni kachi da: “Kachi nuu yɨvɨ ni kaxjnuꞌun ri nuu un ja, ja iyo tuꞌva ri. Ja ni jaꞌni ri xndɨkɨ ri, ti suni ja ni ka jiꞌi taka kɨtɨ ni xneñu ri un. Ja ni ndɨꞌɨ iyo tuꞌva ti kachi jiin chaa ka kana yo un ja na nduku ndee da, na kikoyo da viko ri, ti koto kukuee da”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ko chaa ni ka kana rey un, tu ni ka saꞌa da nanu nuu chaa ka junukuachi un. Ɨɨn da kuaꞌan rancho kuan sajniñu da. Ɨnga da kuaꞌan da nuu xiko da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ti sava da ni ka kiꞌin da chaa ka junukuachi nuu rey un, ti ni ka jaꞌa da tau da undi ni ka jaꞌni da chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yukan na ti ni kɨtɨ xaan ini rey un, ni taji da soldado da ja na kaꞌni da chaa ni ka jaꞌni ndɨyɨ un, ti ni ka jaꞌma da ñuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yukan ti ni kachi da jiin chaa ka junukuachi un: “Ja iyo nakoo ja kuu viko niku, ko chaa ni kana ri un, tu ni ka kuni kikoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kuankoyo naa ra taka calle un, ti kana savaꞌa ni ga yɨvɨ na kikoyo i viko nandaꞌa jaꞌa”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ni kekoyo chaa ka junukuachi un kuankoyo da calle un, ti ni ka stutu da savaꞌani ga yɨvɨ ni ndejnaꞌan da jiin, kuu yɨvɨ vaꞌa ini jiin yɨvɨ kuaꞌan kanda, ti ni chitu yɨvɨ un veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yukan ti ni kɨvɨ rey un kuandeꞌe da yɨvɨ ni jakoyo un. Ti ni ndeꞌe da nuu ɨɨn chaa nukoo un, ko tu ñuꞌun da saꞌma ka ñuꞌun yɨvɨ kuu viko nandaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ti ni kachi da jiin da: “Amigo, ¿nasa kuu ja ni kɨvɨ ra jaꞌa ti tu ñuꞌun ra saꞌma ja kuu viko nandaꞌa”? ni kachi da. Ti maa chaa un tu ni kaꞌan kuɨtɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yukan ti ni kachi rey un jiin chaa ka janukuachi nuu mesa un: “Kuꞌni sɨꞌɨn da jiin ndaꞌa da naa ra, ti keniꞌin ra da na kiꞌin da fuera nuu ñaa un. Ti yukan na ti na ndeꞌe da, ti na kuꞌyu jnuꞌun da”, ni kachi rey. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Suni siaꞌan na kachi ri ja kuaꞌa yɨvɨ ni kana ri, ko jaku ni kuu ja ni nakaji ri ja na ndɨvɨ i ndaꞌa Yandios ja na kundiso jniñu i jiin ri ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yukan na ti kuankoyo chaa fariseo un ti ni ka ndajnuꞌun da nasa nduku da, ja na kankuachi da jaꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yukan ti ni ka taji da sava chaa ka yɨꞌɨ jiin da, jiin sava chaa ka yɨꞌɨ jiin Herodes chaa kuñaꞌnu un, ja na kaꞌan da jiin Jesús, ti ni ka kachi da: ―Maestro, ka jini na ja kaꞌan ndaa ni, ti xnaꞌan ndaa ni ichi Yandios, ti tu yuꞌu ni ndeꞌe ni ni ɨɨn chaa vasu kuñaꞌnu ga da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nusa ti kachi ni nuu na nasa ndoꞌo ini ni: ¿Iyo vaꞌa ja na chaꞌu yo xuꞌun nuu gobierno Romano xi tuu nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ko ja jini Jesús ja tu ka ndoꞌo vaꞌa ini da, ti ni kachi ya: ―Chaa ñaa xini ka kuu ra. ¿Ndoo ka kuni xndaꞌu ra ruꞌu? ");
INSERT INTO mpmNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xnaꞌan ɨɨn xuꞌun ja ka chaꞌu ra puesto un nuu ri ―ni kachi ya. Ti ni ka xnaꞌan da ɨɨn xuꞌun plata nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ni ndeꞌe ya nuu xuꞌun un, ti ni kachi ya: ―¿Naa nūū kuu ja nchaa nuu xuꞌun jaꞌa, ti naa sɨvɨ kuu ja yoso jaꞌa nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ti ni ka kachi da: ―Nūū maa rey nación Roma kuu ―ni ka kachi da. Yukan ti ni kachi Jesús: ―Nusa ti kuaꞌa nuu rey nación Roma ja kuu maa da, ti kuaꞌa nuu Yandios ja kuu maa Yandios ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu ni ka jinisoꞌo da ja siaꞌan ni kaꞌan ya, so ni ka naa ini da. Ni ka xndoo da ya, ti kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Suni maa kɨvɨ yukan, ni ka jaꞌan sava chaa saduceo nuu Jesús. Ti chaa saduceo un ka kaꞌan da ja tukaa ga ka nandoto ndɨyɨ un, ti ni ka kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, ni kachi Moisés ja nu na kuū ɨɨn chaa ni iyo ñasɨꞌɨ, ti nu tu ni iyo seꞌe da jiin ña, ti kuu nandaꞌa ñani ndɨyɨ un jiin ña ja na koo seꞌe ña, ti suchi un nduu nanu seꞌe maa ndɨyɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ti nuu kanchuku na jaꞌa ni ka iyo uxia chaa ni ka kuu ñani naa da. Ti chaa núú un ni nandaꞌa da, ti ni jiꞌi da, ko tu ni iyo seꞌe da. Ti nandaꞌa tuku ñaꞌan un jiin ɨnga ñani da, chaa kuu uu. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Suni siaꞌan ni jnaꞌan chaa kuu uu un, suni chaa kuu uni, ti siaꞌan ni ka ndekava ndɨ uxia da ni ka nandaꞌa jiin ña, ko ni ndɨꞌɨ da ni ka jiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yukan na ti sandɨꞌɨ ni ga, ti ni jiꞌi ñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ti nu na nandoto ndɨyɨ un naa da, ¿Nau ndɨꞌɨ uxia chaa un xiin ñasɨꞌɨ un, ja siaꞌan tendɨꞌɨ da ni ka nandaꞌa da jiin ña? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yukan na ti ni kachi Jesús: ―Ka yuji ra naa ra, chi tu ka chaku ini ra tutu Yandios, ni tu ka chaku ini ra jniñu ñaꞌnu saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Chi nu na nandoto ndɨyɨ un, tukaa kuu nandaꞌa i, ni tu kuaꞌa i seꞌe sɨꞌɨ i ja na nandaꞌa ña, chi nduu i nanu ángel Yandios ja kanchuku nuu andɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ko sɨkɨ ja nandoto ndɨyɨ un tuku, xi tu ka chaku ini ra nu ni ka kaꞌu ra tutu, nu ni kachi Yandios jiin Moisés, na ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ruꞌu kuu Yandios ja ni kanajaa Abraham, Isaac jiin Jacob.” Siaꞌan ni chaa Moisés jnuꞌun Yandios, ja Yandios tu kuu ya Yandios nuu yɨvɨ ni ka jiꞌi un, chi kuu ya Yandios nuu yɨvɨ ka chaku ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nu ni ka jinisoꞌo yɨvɨ un jnuꞌun un, ti so ni ka naa ini i ja siaꞌan ni xnaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nu ni ka niꞌin chaa fariseo jnuꞌun ja ni jasɨ Jesús yuꞌu chaa saduceo, ni ka ndututu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ti ɨɨn chaa xnaꞌan ley Israel un ni kuni da xndichi da Jesús, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿nau ɨɨn jnuꞌun kuu ja kanuu ga ja kuu nuu ley Yandios nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ti ni kachi Jesús jiin chaa un: ―“Kuu ini nuu Yandios jiin nɨ ini nɨ añu ra, nɨ jiin inijnuni ra.” ");
INSERT INTO mpmNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jnuꞌun jaꞌa kuu ja kanuu ga ja kaꞌan nuu ley Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ti ja kuu uu un, suni ɨɨn ni kaꞌan: “Kundaꞌu ini nuu ñanijnaꞌan ra nanu kundaꞌu ini ra nuu maa ra”, kachi ley un. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndɨnduu jnuꞌun jaꞌa ka kuu ja kanuu xaan ga ja kaꞌan nuu nɨ tuꞌu ley Yandios ja ni xnaꞌan Moisés, jiin jnuꞌun Yandios ni ka xnaꞌan profeta un na janaꞌan―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nɨ kaꞌiin ga chaa fariseo yukan, ti ni jikajnuꞌun Jesús maa da naa da, ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Nasa ka ndoꞌo ini ra nuu Cristo ja ni taji Yandios ja ndiso ya jniñu ñaꞌnu nu? ¿Nau jnaꞌan kuu ya nusa? ―ni kachi ya. Ni ka kachi chaa un: ―Seꞌe David, chaa ni kuu rey na janaꞌan, yukan kuu da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yukan na ti ni kachi Jesús: ―¿Nasa kuu ja David jiin inijnuni Espíritu Santo ni skonani da ya jitoꞌo da nusa? Ti maa David ni kaꞌan da, ti ni chaa da nuu tutu: ");
INSERT INTO mpmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yandios ni kachi jiin Jitoꞌyo Cristo: “Nukoo jiin ri, chi taꞌu ra jniñu jiin ri. Iyo yɨvɨ jito uꞌu roꞌo ko kundee ra jiin, chi chindee ri roꞌo.” Kachi Yandios, ni kachi David. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nu siaꞌan kuu ja maa David ni skonani da ya jitoꞌo da, ti ¿nasa kuu ja Cristo kuu ɨɨn jnaꞌan rey David janaꞌan? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yukan na ti ni ɨɨn yɨvɨ tukaa ni kuu xndeokani ni ɨɨn jnuꞌun nuu ya. Ti undi kɨvɨ un, ni ɨɨn da tukaa ga ni tava ini da kajnuꞌun ga da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yukan na ti ni kachi Jesús nuu yɨvɨ kuaꞌa un jiin nuu ndajaꞌa ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Chaa ka xnaꞌan ley Moisés jiin chaa fariseo un, ka kuñaꞌnu da ja ka xnaꞌan da ley. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ja yukan kuu ja kuandatu nuu da naa ra, saꞌa taka jniñu ka taꞌu da, ko koto ma natejnaꞌan ra nava ka saꞌa da, chi tu ka siuku da maa jnuꞌun ka xnaꞌan da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ka xnaꞌan da kuaꞌa jnuꞌun, ti taꞌu da jniñu ja na siuku yɨvɨ jnuꞌun un naa i, ko maa da tu ka jandatu kuɨtɨ da jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ka jajnaꞌan ini da kuꞌni da ɨɨn tutu lulu yujiña da jiin sɨkɨ ndaꞌa da, ti nuu tutu lulu un ka chiso da tɨꞌlɨ jnuꞌun Yandios. Siaꞌan ka saꞌa da nava na kuni yɨvɨ naa i ja ka junukuachi da nuu Yandios. Suni ka jajnaꞌan ini da kuꞌun da ɨɨn manga kani ga ja kuu taka ga yɨvɨ. So ka saꞌa da taka jniñu un nava na kuaꞌa yɨvɨ ja yɨñuꞌun maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ti ka kusɨɨ xaan ini da jiin jnuꞌun yɨñuꞌun jiin nuu nu kunchuku da ja kaji da staa ɨɨn viko. Suni ka jajnaꞌan ini da silla yɨñuꞌun ga nuu kunchuku da ini veñuꞌun kaꞌnu Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ti ka kuni da ja na kaꞌan yɨñuꞌun yɨvɨ jiin da nuu yaꞌu, ti na kaꞌan yɨñuꞌun i jiin da, “Maestro, maestro.” ");
INSERT INTO mpmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ko roꞌo naa ra ja ka kuu ra ndajaꞌa ri, koto ma konani ra “maestro”, chi tendɨꞌɨ ra ka kuu ñani nuu jnaꞌan ra naa ra, chi maa ɨɨn ni Maestro ra iyo, ya kuu Cristo. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Suni tu kaꞌan ra “tata yo” nuu savaꞌa ni ga yɨvɨ ñuyɨvɨ jaꞌa, chi vajnuꞌun ni Tata yo iyo, ya kancha andɨvɨ, ti ii ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Suni koto ma kachi ra ja kuñaꞌnu ra, chi maa ɨɨn ni Cristo kuu ya kuñaꞌnu nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yɨvɨ junukuachi nuu ñanijnaꞌan i, yɨvɨ yukan kuu ja kuñaꞌnu ga ja kuu roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ti yɨvɨ kuni kuñaꞌnu, suꞌva ndukuiꞌya ini i. Ko yɨvɨ ja kukuiꞌya ini un, suꞌva nduñaꞌnu i, chi maa Yandios kuu ja kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! ¡Chaa ñaa xini ka kuu ra! Jiin jnuꞌun ra ka jasɨ ra ichi yɨvɨ ja na kɨvɨ i ndaꞌa Yandios, ti na taꞌu ya jniñu nuu i. Ni tu ka kuni kɨvɨ maa ra naa ra, ko ni tu ka kuni ra ja na kɨvɨ ɨnga yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chaa ñaa xini ka kuu ra. Ka jisonchaa ra veꞌe ñaꞌan ni ka kendo ndaꞌu. Ti ja na kendo vaꞌa ra, ti naꞌan xaan ka jikantaꞌu ra naa ra. Ko jiin jniñu ka saꞌa ra un, ti viꞌi ga jnaꞌnu ndatu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Xaan ga ndaꞌu roꞌo ja xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chaa ñaa xini ka kuu ra. Ka jikonuu ra taka ñuu ja ka xndaꞌu ra yɨvɨ naa i, ja na kandixia i jnuꞌun ka xndaku ra. Ti nu ni kandixia yɨvɨ un, ti ka saꞌa ra ja viꞌi ga na jnaꞌnu ndatu yɨvɨ un nuu infiernu ja kuu maa ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Xaan ga ndaꞌu roꞌo naa ra! Chi ka kuu ra nanu chaa kuaa tu ka jini na ichi kiꞌin da, chi ka kaꞌan ra: “Nu ɨɨn yɨvɨ na chisojnuꞌun i sɨkɨ veñuꞌun kaꞌnu Israel, va tundo kuu un. Ko nu na chisojnuꞌun i sɨkɨ oro ja iyo ini veñuꞌun un, ti kanuu kuu ja na siuku i”, ka kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ko jiin jnuꞌun un jini yo ja ka kuu ra nanu chaa ñaa jiin chaa kuaa. Chi tu ka jini ra ja ɨɨn ni kuu veñuꞌun jiin oro un ja kancha ini veñuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ti suni ka kaꞌan ra naa ra: “Nu ɨɨn yɨvɨ na chisojnuꞌun i ja kuu altar ini veñuꞌun un, va tundo kuu. Ko nu na chisojnuꞌun i ja kuu ja ka soko i nuu altar un, ti yukan kuu ja na siuku i”, ka kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Suni jiin jnuꞌun un jini yo ja nanu chaa ñáá, chaa kuáá ka kuu ra, chi tu jini ra ja ɨɨn ni kuu altar un jiin ndajniñu ka soko ra un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yɨvɨ chisojnuꞌun ja kuu nuu altar, ko ansu nɨnɨ nuu altar un, chi jiin tendɨꞌɨ ndajniñu kanchuku ja ka soko i un, undi jiin yukan ka chisojnuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ti yɨvɨ chisojnuꞌun sɨkɨ veñuꞌun un, suni chiso jnuꞌun i ja kuu Yandios, chi kancha ya yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ti suni yɨvɨ chisojnuꞌun ja kuu andɨvɨ un, suni chisojnuꞌun i nuu kancha Yandios, jiin suni nuu maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Xaan ga ndaꞌu roꞌo naa ra ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chi chaa ñaa xini ka kuu ra. Roꞌo ka jaꞌa ra tɨꞌlɨ ni nuu taka ja ka ñavaꞌa ra, ja kuu nuu chaa junukuachi nuu Yandios. Ka jaꞌa ra tɨꞌlɨ ni nuu taka jajaꞌan xiko asun, nanu tamino, yuku anís jiin yuku comino. Taka un ka saꞌa ra, ti ka naa ini ra jnuꞌun kanuu ga ja kuu nuu ley Yandios, ja na kaka ndaa yo nuu Yandios, ja na kuandatu yo nava taꞌu ya jniñu jiin jnuꞌun kundaꞌu ini, jiin ja na kandixia ndaa yo jnuꞌun maa ya. Yukan kuu ja kanuu ga ja saꞌa ra, ti koto naa ini ra ja kuaꞌa ra tɨꞌlɨ nuu taka ja kaa ñavaꞌa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nanu chaa kuaa ka kuu ra ja ka xnaꞌan ra jnuꞌun maa ra nuu yɨvɨ naa i. Ka jitu ndiꞌi ini ra jiin savaꞌni ga jniñu kuachi un. Chi ka ndundoo xaan ini ra ja ka sijin ra chukun ndiꞌi un jiin ɨɨn tela ja tu yaꞌa tɨ nuu nducha. Ko ka naa ini ra koko ra ɨɨn camellu. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chaa ñaa xini ka kuu ra. Ndundoo koꞌo ra, ndundoo yajin ra, chi ka ndoꞌo ini ra ja ka iyo ndoo ra nuu Yandios, ko vasu jaku ga kanda ra. Ka kuu ra nanu yɨvɨ ja ka nakacha nɨnɨ ichi jata koꞌo un jiin yajin, ko tu ka nakacha i ichi ini, vasu jñaꞌan ga ichi ini. Siaꞌan ka kuu ra, chi kanda ra nanu yɨvɨ vaꞌa, vasu ichi ini ra ka ñuꞌun mani jnuꞌun kuiꞌna jiin taka ga jnuꞌun kueꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nanu chaa kuaa ka kuu ra roꞌo chaa fariseo, chi tu ka nakuni ra ja mani jniñu ndevaꞌa saꞌa ra. Xnakan nakani ini nuu kuachi un nava na ndundoo ini añu ra, nava suni siaꞌan na ndundoo taka jniñu ka saꞌa ra ja ka ndeꞌe yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chaa ñaa xini ka kuu ra, chi ka kuu ra nanu ñaña ndɨyɨ kaꞌiin panteon, nuu vaꞌa xaan ni ka saꞌa da. Ti ni ka nakaꞌyu da jiin kaka, ti jandaa kuu ja vii xaan ni kendo ichi fuera, ko ichi chii ñuꞌun un, ñuꞌun chitu mani yɨkɨ ndɨyɨ jiin taka ga ja teꞌyu. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ti siaꞌan kanda ra naa ra jiin jniñu ka saꞌa ra, ti siaꞌan ka kendo vaꞌa ra nuu yɨvɨ naa i, chi ka ndoꞌo ini i ja ka iyo ndoo ini añu ra ja kuu nuu Yandios. Ko tu ka jini i ja chaa ñaa xini ka kuu ra, chi mani jniñu kueꞌe un ka ñuꞌun ini añu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan ley! ¡Xaan ga ndaꞌu roꞌo, chaa fariseo! Chaa ñaa xini ka kuu ra. Ka saꞌa ra nama nuu ñaña chaa ni ka kuu profeta un, ti nɨnɨ ka naskutu ra ñaña chaa vaꞌa un ja ka chiñuꞌun ra da. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ti ka kaꞌan ra naa ra: “Sa ti yoꞌo naa yo, ni ka chaku yo na ni ka chaku yɨvɨ janaꞌan, ti va tu kuaꞌa yo jnuꞌun ja kaꞌni yɨvɨ chaa ni ka kuu profeta, ja ni kaꞌan jnuꞌun Yandios niku”, ka kaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jiin jnuꞌun yukan ni, ti ka xnukoyo jnaꞌan ra ja ka kuu jnaꞌan ra jiin chaa ni ka jaꞌni profeta un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nusa ti kuan siuku naa ra nava ni ka saꞌa jnaꞌan ra janaꞌan, chi ɨɨn nuu kanda ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nanu koo xaan jiin seꞌe tɨ ka kuu roꞌo naa ra. Chi vaꞌa jito ra, ko ndevaꞌa kuɨtɨ ka saꞌa ra. Ja siaꞌan ti tu kaku kuɨtɨ ra naa ra ja tu kiꞌin ra nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ja yukan kuu ja na taji ri profeta ka kaꞌan jnuꞌun Yandios nuu ra naa ra. Ti taji ri chaa tuꞌva ja ka jini vaꞌa jnuꞌun Yandios, suni chaa ka xnaꞌan vaꞌa jnuꞌun ya. Ko roꞌo naa ra, chi kaꞌni ra da, xi katakaa ra da ndaꞌa cruz naa ra, ti sava da kuaꞌa ra tau da ini veñuꞌun ra naa ra. Ti koto uꞌu ra uu ga da, ti taka ñuu kundikun ra da naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Taka kuachi un nukuncha sɨkɨ ra. Ti suni nukundiso ra kuachi taka chaa vaꞌa ni ka jaꞌni ra un, undi nɨñɨ Abel jiin undi nɨñɨ Zacarías, seꞌe yɨɨ Berequías, chaa ni ka jaꞌni jnaꞌan ra na janaꞌan un, sava maꞌñu altar ini veñuꞌun Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jaꞌa ti na kachi ndaa ri nuu ra naa ra, ja sɨkɨ taka jniñu kueꞌe ni ka saꞌa ra un, ja kii ɨɨn nundoꞌo xaan tonto sɨkɨ roꞌo, yɨvɨ nación Israel ja kanchuku vijna ―ni kachi Jesús jiin yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ni kachi Jesús sɨkɨ yɨvɨ Israel: ―Roꞌo, yɨvɨ ñuu Jerusalén, ja ka jaꞌni ra profeta, chaa ni ka kaꞌan jnuꞌun Yandios, ti ka jaꞌa ra yuu sɨkɨ chaa kaꞌan jnuꞌun ya vekoyo nuu ra naa ra. ¡Nasa jinu ni kundaꞌu ini ri roꞌo naa ra! Chi ni nakana ri roꞌo ja na nama ri sɨkɨ ra nuu nundoꞌo, nanu saꞌa ɨɨn chuun ja nakana tɨ seꞌe kuachi tɨ, ja na ndututu chii ndijin tɨ, ko tu ni ka jantaꞌu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vijna na ti na xndoo ii ri roꞌo naa ra jiin ñuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chi na kachi ri jiin ra ja, jankɨvɨ ga kuni ra ruꞌu naa ra, undi na jaa kɨvɨ nu kachi ra naa ra: “Ñaꞌnu na koo sɨvɨ ya, ti na kanajaa yo yaa ja vaji ya nuu maa Yandios” ―siaꞌan ni kaꞌan Jesús sɨkɨ ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ni kee Jesús veñuꞌun kaꞌnu un, ti kuaꞌan ya. Ko ni ka tuꞌva ndajaꞌa ya, ti ni ka kejaꞌa ka jitonchaa da veñuꞌun kaꞌnu un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ti ni kachi Jesús jiin da naa da: ―Ndɨꞌɨ jaꞌa ka jitonchaa ra naa ra. Ko jandaa na kachi ri nuu ra naa ra ja ni ɨɨn yuū tukaa kendo kosojnaꞌan jaꞌa, chi ndɨꞌɨ jaꞌa naa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yukan na ti kuaꞌan ya jiin ndajaꞌa ya undi yuku Olivos, ti yukan ni nukoo ya ti nuu nukoo ya un ni ka tuꞌva ndajaꞌa ya, chi maa ni ga da kaꞌiin un jiin ya, ti ni ka jikajnuꞌun da ya siaꞌan: ―Ka kuni na ja na kachi ni nuu na naa na, ja nama kundaa taka jnuꞌun ni kaꞌan ni un. ¿Ti naa seña koo nu kuan kuyajni nchaa ni, jiin ja na ndɨꞌɨ ñuyɨvɨ nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yukan na ti ni kachi Jesús jiin da naa da: ―Koto maa ra naa ra. Koto maa xndaꞌu yɨvɨ roꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chi kuaꞌa yɨvɨ kikoyo, ti ndaku niꞌin yɨ sɨvɨ ri, ti kachi: “Ruꞌu kuu Cristo ja ni taji Yandios ja saꞌa jniñu ñaꞌnu”, kachi. Ti siaꞌan kuu xndaꞌu i yɨvɨ kuaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ti kuni jnuꞌun ra ja ya yukan koo guerra. Ko koto yuꞌu ra naa ra, chi siaꞌan ndixia kuu, ko jiin yukan ti changa ga jaa kɨvɨ ja ndɨꞌɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chi kanaa ɨɨn nación jiin ɨnga nación, suni ɨɨn ñuu jiin ɨnga ñuu. Ti koo jnama xaan. Suni kii kueꞌe xaan tonto, jiin ñujnaa xaan tonto nuu savaꞌni ga nuu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ti taka un kuu seña ja kuan kuyajni kejaꞌa nundoꞌo kii nuu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yukan na ti roꞌo ja ka kandixia ra ruꞌu, ti jnɨɨ yɨvɨ roꞌo naa ra, ti kuaꞌa i tau ra, ti kaꞌni i roꞌo. Ti tendɨꞌɨ yɨvɨ koto uꞌu i roꞌo naa ra ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti yɨvɨ ni ka kaꞌan ja ka kandixia i ruꞌu, nandeokava ini i nu na jaa kɨvɨ un. Koto uꞌu jnaꞌan i, ti siukoyo jnaꞌan i nuu stisia. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ti kenda kuaꞌa yɨvɨ ja xndoñaꞌan, ti kachi i ja ka kaꞌan i jnuꞌun Yandios, ti xndaꞌu i yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndevaꞌa kuɨtɨ ni ga saꞌa yɨvɨ un naa i ja tukaa ga kunchuku mani i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko yɨvɨ na kuñɨɨ ini jiin jnuꞌun ri, ti siuku ni ini i undi kɨvɨ sandɨꞌɨ ni ga un, ti ketaꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ti jnuꞌun kaꞌan ja nasa kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, kuichanuu jnuꞌun un kiꞌin nɨɨ tuꞌu ñuyɨvɨ ja na nakuni yɨvɨ taka nación. Yukan na sa chaa kɨvɨ sandɨꞌɨ ni ga ja naa ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Daniel, chaa ni kuu profeta na janaꞌan un, ni chaa da nuu tutu ja jaa ɨɨn nundoꞌo xaan nuu veꞌe ii un, ti yukan kuu ja saꞌa ja natɨvɨ nɨɨ tuꞌu veꞌe ii un. Ti nu na kuni ra nundoꞌo un naa ra ja, ja ni jaa veꞌe ii kande ini veñuꞌun kaꞌnu un, yukan sa chaku ini ra nau ja kuu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yukan na ti yɨvɨ kanchuku ñuu Judea, na kinkoyo i undi yuku un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yɨvɨ ka ndetatu yuxeꞌe i, koto ma kiꞌin i ndajniñu i ini veꞌe i, ko na kunu xaan i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ti yɨvɨ kaꞌiin nuu jniñu, koto maa ndeokuñɨ i veꞌe i ja stutu i saꞌma i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Na ndaꞌu ñaꞌan ka ñuseꞌe xi ñaꞌan ka nchaka suchi yɨkɨn ja kuu kɨvɨ un! ");
INSERT INTO mpmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kakantaꞌu nuu Yandios naa ra ja koto maa kii nundoꞌo yukan nuu ra kɨvɨ vijin xaan, xi ja kuu ɨɨn kɨvɨ ndetatu. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chi saa kuu ja koo xaan nundoꞌo, ja jankɨvɨ ni iyo undi na ni jankoo ñuyɨvɨ, ti ni jankɨvɨ ga koo tuku ɨnga. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sa ti tu ni xnuku Yandios kɨvɨ un, ti va ni ɨɨn yɨvɨ tu nanitaꞌu i. Ko ni xnuku ya kɨvɨ un ja ni kundaꞌu ini ya nuu yɨvɨ ka kandixia, ja ni nakaji ya un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nu ni jaa kɨvɨ un, koto ma kandixia ra kaꞌan yɨvɨ jiin ra, chi kachi i: “Ndeꞌe, jaꞌa kancha Cristo ja ni taji Yandios ja saꞌa jniñu ñaꞌnu”, xi kachi: “Ndeꞌe, yukan kancha ya.” Ti koto ma kandixia ra jnuꞌun kaꞌan i. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chi kikoyo yɨvɨ ka xndoñaꞌan, ti kachi i ja maa i kuu Cristo, xi ja maa i kuu chaa kaꞌan jnuꞌun Yandios, ti saꞌa i tɨjnɨ nuu jniñu ñaꞌnu xaan ja na xndaꞌu i yɨvɨ. Ti kachi i xndaꞌu i yɨvɨ ni nakaji ya ja ka kandixia i ruꞌu, ko tu kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","26","Ja yukan kuu ja, ja ni ndɨꞌɨ jnuꞌun jaꞌa ni kachi ri nuu ra naa ra, ti koto kandixia ra nu na kachi yɨvɨ un: “Ndeꞌe naa ra, yukan kande Cristo nuu ñuꞌun teꞌe un”, ka kachi i. Ti koto maa kiꞌin ra yukan. Ko xi nu na kachi i: “Ndeꞌe naa ra. Ja kancha ya ini veꞌe jaꞌa”, ti koto ma kandixia ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chi kɨvɨ nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti kuni ndijin ra naa ra nanu saꞌa nu janducha, ti ndinchaa nɨ tuꞌu undi nuu kaña ndikandii jiin undi nuu kee ndikandii. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chi ndeꞌe ra ja nuu ka kututu tiji un, katuu kɨtɨ ni jiꞌi, ti suni siaꞌan kuni ndijin ra nu ndenda ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nu ni yaꞌa taka nundoꞌo un, ti kuu ñaa ndikandii, ti yoo tukaa ga kuaꞌa nduva. Ti nukoyo chuxini nuu andɨvɨ un, ti nɨꞌɨn undi andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yukan kuu ɨɨn seña nuu andɨvɨ ja nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. Ti taka yɨvɨ ñuyɨvɨ jaꞌa, ndeꞌe i ti kuni i ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, ndii ri nuu viko un jiin jnuꞌun ja ni nduñaꞌnu xaan ri nuu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ti taꞌu ri jniñu nuu ángel, Yandios ja kinkoyo ya ndɨ kuun jɨkɨ ñuyɨvɨ. Ti nu na tɨvɨ ɨɨn ndɨkɨ, yukan na ti nastutu i yɨvɨ ni nakaji Yandios, ja kanchuku savaꞌa taka nuu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ndeꞌe naa ra ja kuu jiin nutɨchɨ vixi un. Nu ni ka nduu yucha numa i ti ni nduu xatɨ ndaꞌa, ti yukan ja ni chaku ini yo ja kuan kuyajni viko sau. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ti suni siaꞌan jiin roꞌo naa ra, nu ni ka jini ra ja kuan kundaa taka jnuꞌun ni kaꞌan ri un, ti chaku ini ra naa ra ja kuan kuyajni ndaa kuɨtɨ ni ga kɨvɨ nchaa ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ti jandaa na kachi ri ja xnaka taka un kundaa, ti sa kuū yɨvɨ ka iyo kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Va naa andɨvɨ jiin ñuyɨvɨ, ko jnuꞌun kaꞌan ri, chi jankɨvɨ naa, ti kundaa taka un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ko kɨvɨ yukan, ni ɨɨn yɨvɨ tu jini na kɨvɨ kuu, xi na hora kuu, ni ángel ja ka junukuachi nuu Yandios, ni maa Seꞌe Yandios, tu jini na hora kuu. Chi vajnuꞌun ni maa Tata yo Yandios kuu ja jini na hora kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chi nanu ni iyo kɨvɨ ni chaku Noé, ti suni siaꞌan kuu nu na jaa kɨvɨ nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kɨvɨ na ti kii ga sau xaan un, ni kunchuku vatu yɨvɨ naa i, chi ka ndoꞌo ini ja kukuee nuu i naa i. Ka yaji i, ti ka jiꞌi i, ka nandaꞌa i, ti ka jaꞌa i seꞌe sɨꞌɨ i ka nandaꞌa ña naa ña, undi ni jaa kɨvɨ nu ni kɨvɨ Noé ini barco da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ko tu ni ka chuꞌun ini taka ga yɨvɨ ñuyɨvɨ un ja kii ɨɨn sau xaan tonto un. Ko nu ni jinu ndixia sau xaan un, ti ni ka naa i. Ti nava ni ka iyo naa ini yɨvɨ kɨvɨ un, suni siaꞌan konaa ini yɨvɨ ja kuu kɨvɨ na nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti kɨvɨ un kuꞌiin uu chaa nuu jniñu da, ɨɨn da nakuaka ya, ti ɨnga da kendo. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu uu ñasɨꞌɨ ka ndiko, ti ɨɨn ña nakuaka ya, ti ɨnga ña kendo. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kondito ini naa ra, chi tu ka jini ra na kɨvɨ nchaa maa jitoꞌo ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ndeꞌe naa ra, sa ti ɨɨn chaa ja jini da na hora jaa ñakuiꞌna veꞌe da ɨɨn jakuaa, va kondito da, ti tu kuaꞌa da jnuꞌun kɨvɨ ñakuiꞌna veꞌe da un, ja na tava ndajniñu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ja yukan kuu ja suni kotuꞌva ra naa ra, chi jaa ɨɨn kɨvɨ, ja iyo naa ini ra, ti nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chaa kuu muzu vaꞌa ja junukuachi vaꞌa un, ti kanu ini chaa xiin veꞌe un ja na kɨndaꞌa da uu ga muzu un, ti suni jiin hora na kuaꞌa da ja kaji uu ga muzu un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ndatu chaa kuu muzu un nu na najaa chaa xiin veꞌe un, ti naniꞌin da chaa saꞌa jniñu da, siuku da nava ni taꞌu jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ti na kachi ndaa ri ja kusɨɨ ini chaa xiin veꞌe un, ti xndoo da chaa ja na kɨndaꞌa da taka ja ñavaꞌa chaa kuu jitoꞌo da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko nu chaa junukuachi un na saꞌa ndevaꞌa da, ja ndoꞌo ini da ja kukuee ga chaa xiin veꞌe un, ");
INSERT INTO mpmNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ti kejaꞌa nduxaan da nuu uu ga muzu un, ti kejaꞌa da kaji da, koꞌo da jiin taka chaa jini un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ti iyo naa kuɨtɨ ini da, ja tundo ndoꞌo ini da ja najaa yachi chaa xiin veꞌe un, ja tu jini da na kɨvɨ najaa jitoꞌo da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ti kuaꞌa da tau chaa un jiin ɨɨn nundoꞌo ja jnaꞌnu ndatu da, nava ka jnaꞌan chaa ñaa xini. Yukan na ti ndeꞌe da nuu nundoꞌo un, ti kuꞌyu jnuꞌun da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Siin Jesús xndaku ya, ti ni kachi ya: ―Nuu taꞌu Yandios jniñu kuu nanu ni ka jnaꞌan uxi ñaꞌan kuachi ja ka yɨndaꞌa ña candil ña, ti ni ka jaꞌan ña ɨɨn viko nandaꞌa ja kundatu ña novio. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uꞌun ñaa kuachi un ka iyo naa ini ña, ti uꞌun ga ña kuachi un ka iyo ndito ini ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ñaꞌan naa ini un, ni ka yɨndaꞌa ña candil ña, ti ni ka naa ini ña kundaꞌa ña aceite olivo ja na nachuꞌun tuku ña chii candil ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko ñaꞌan ka ñundito ini, ni ka yɨndaꞌa ña candil ña, ti ni ka yɨndaꞌa sɨɨn ña botella aceite olivo ja na naskutu ña candil ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ko ni kukuee novio un najaa da, ti ni chaa maꞌna nuu ña naa ña, ti ni ndɨꞌɨ ña ni ka kixi. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yukan ti yajni kuu ñuu, ti ni ka jinisoꞌo ña ka kana jiin: “¡Ja vaji novio, kekoyo kii ra naa ra”! ―kachi ka kaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tendɨꞌɨ ña ni ka ndoko ti ni ka kejaꞌa ka satuꞌva ña candil ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ti ndɨ uꞌun ñaꞌan naa ini un ni ka kachi ña jiin uꞌun ga ñaꞌan ka ñundito ini un: “Kuaꞌa tɨꞌlɨ aceite ra nuu ri naa ri, chi kuni ndaꞌva candil ri”, kachi ña naa ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ko ñaꞌan ka iyo tuꞌva un, ni ka kachi ña: “Tuu, chi tu kujaa ja kuu maa ri naa ri. Vaꞌa ga kuankoyo nuu kuyaꞌu un, ti kuaan ra ja kuu maa ra naa ra”, ni ka kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ko nɨ kuankoyo ndɨ uꞌun ñaꞌan naa ini un, ja kin kuaan ña aceite ña, ti ja ni najaa novio un. Ti ñaꞌan ka iyo tuꞌva un ni ka kɨvɨ ña viko nandaꞌa un jiin novio un, ti ni nandiꞌyu yuxeꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kuee ga ti ni ka najakoyo uꞌun ga ñaꞌan kuachi un, ti ni ka kachi ña: “Taa, kuiña ni yuxeꞌe na kɨvɨ na”, ni ka kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ko ni kachi novio un: “Na kachi ndaa ri ja tukaa ga nuña veꞌe ri”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ja yukan kuu ja kondito ini ra naa ra, ti kotuꞌva ra, chi tu ka jini ra na kɨvɨ, ni na hora kuu ja nchaa ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Siin Jesús xndaku ya, ti ni kachi ya: ―Nuu taꞌu Yandios jniñu kuu nanu ɨɨn chaa riku, ja ñuꞌichi da kiꞌin da ɨnga ñuu. Ni kana da muzu da ti ni tatu da nuu ja na koto xuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nuu ɨɨn da ni jaꞌa da yajni uꞌun mil xuꞌun. Nuu ɨnga da ni jaꞌa da yajni uu mil xuꞌun, ti nuu ɨnga da ni jaꞌa da yajni ɨɨn mil xuꞌun. Siaꞌan ni tejnaꞌan da nuu ɨɨn ɨɨn muzu da un nasa xini maa da naa da. Yukan na ti ni kee da ti kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chaa ni niꞌin uꞌun mil xuꞌun un, ni saꞌa da tratu jiin xuꞌun un, ti ni naniꞌin da uꞌun ga mil. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Suni siaꞌan ni saꞌa chaa ni kiꞌin uu mil un, ti ni naniꞌin da uu mil ga xuꞌun sɨkɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko chaa ni kiꞌin ɨɨn mil xuꞌun un, ni jaꞌan da ti ni chisaꞌyɨ da xuꞌun un chii ñuꞌun, ja ni jaꞌa chaa un nuu da ti ni savaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ni yaꞌa tɨjnɨ kɨvɨ, ti ni najaa chaa xiin xuꞌun un, ti ni na xndichi da muzu un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Xnaka ni jaa chaa ni kiꞌin uꞌun mil un, ti ni nakuaꞌa da uꞌun ga mil xuꞌun un, ti ni kachi da: “Taa, ni jaꞌa ni uꞌun mil xuꞌun nuu na, ti jaꞌa iyo uꞌun ga mil ja ni niꞌin na sɨkɨ”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ti ni kachi chaa xiin xuꞌun un: “Iyo vaꞌa xaan, roꞌo kuu ɨɨn muzu vaꞌa ga, chi ni sajniñu ni ini ra jiin, ti vasu tɨꞌlɨ ni jaꞌa ri ko ni sajniñu ni ini ra jiin. Vijna ti nakuaꞌa ri ɨɨn jniñu kanuu ga nuu ra ja kɨndaꞌa ra. Ko kuan ndɨvɨ ini veꞌe ri vinañuꞌni, chi koo yo ɨɨn jnuꞌun sɨɨ ini naa yo”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yukan sa ni jaa chaa ni kiꞌin uu mil un, ti ni kachi da: “Taa, ni jaꞌa ni uu mil nuu na, ko jaꞌa iyo uu ga mil ja ni niꞌin na sɨkɨ”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ni kachi chaa xiin xuꞌun un: “Iyo vaꞌa nusa. Roꞌo kuu muzu vaꞌa ga, chi ni sajniñu ni ini ra jiin xuꞌun ri, ti vasu tɨꞌlɨ ni jaꞌa ri, ko ni sajniñu ni ini ra jiin. Vijna ti nakuaꞌa ri ɨɨn jniñu kanuu ga nuu ra ja kɨndaꞌa ra. Ndɨvɨ ini veꞌe ri, chi koo yo ɨɨn jnuꞌun sɨɨ ini naa yo”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ko nu ni jaa chaa ni kiꞌin ɨɨn mil xuꞌun un, ti ni kachi da jiin chaa xiin xuꞌun un: “Taa, ja jini na ja kuu ni chaa tu ñundaꞌu ini, chi kuaꞌa ga nandakan ni ti ansu ja ni jaꞌa ni, ti suꞌva kuni ga ni. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ja yukan kuu ja ni yuꞌu na ti ni chisaꞌyɨ na xuꞌun un chii ñuꞌun, ko jaꞌa na nakuaꞌa na xuꞌun ni”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ti ni kachi chaa xiin xuꞌun un: “Roꞌo kuu ɨɨn chaa ndéhé xaan tonto, ɨɨn chaa kuxi. Ti kaꞌan ra ja viꞌi ga nandakan ri ansu ja ni jaꞌa ri, ti suni kaꞌan ra ja suꞌva viꞌi ga kuni ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ti nu siaꞌan kuu nusa, ¿ndoo tu ni januu ra xuꞌun ri nuu chaa ka sajniñu sɨkɨ tratu, nava nu ni nchaa ri ti nakiꞌin ri xuꞌun ri jiin seꞌe i niku”? ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yukan ti ni kachi da jiin uu ga muzu un: “Kuisonchaa ɨɨn mil xuꞌun jña nuu da, ti kuaꞌa nuu chaa yɨjnɨ uxi mil un naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chi yɨvɨ ka ñavaꞌa, ti suꞌva kii ga nuu i, ti viꞌi ga kuñavaꞌa i. Ko yɨvɨ tundo ñavaꞌa, ti vasu tɨꞌlɨ ja ñavaꞌa i un, kuxio kiꞌin. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ti muzu ja tu kaxaan jaꞌa, keniꞌin da na kiꞌin da nuu ñuu ñaa fuera un. Ti yukan na ndeꞌe da ja na nakani ini da, ti na kuꞌyu yuꞌu da”, ni kachi chaa xiin xuꞌun un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Siin Jesús xndaku ya, ti ni kachi ya: ―Ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨɨ, kɨvɨ na nchaa ri jiin jniñu ñaꞌnu xaan, jiin tendɨꞌɨ ángel ka junukuachi nuu Yandios, ti taꞌu ri jniñu nuu nɨ tuꞌu yɨvɨ ñuyɨvɨ jaꞌa, chi maa Tata ri Yandios kuaꞌa jniñu un nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ti tendɨꞌɨ yɨvɨ taka nación ndututu nuu ri, ti sasɨɨn ri i nanu sasɨɨn yo rɨɨ jiin ndixiꞌyu. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ti yɨvɨ vaꞌa sasɨɨn ri i nundaꞌa kuaꞌa ri. Ti sasɨɨn ri yɨvɨ kueꞌe un nundaꞌa sajni ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yukan na ti kachi ri jiin yɨvɨ kanchuku ndaꞌa kuaꞌa ri: “Ichi chaꞌa kikoyo ra, chi ja ni nakaji Tata ri roꞌo naa ra. Kɨvɨkoyo ra nuu taꞌu Yandios jniñu, chi ja iyo tuꞌva ja kuu roꞌo naa ra undi na ni saꞌa Yandios ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ni niꞌin taꞌu ra, chi ni jiꞌi ri soko, ti ni ka jaꞌa ra ja ni yee ri. Ni ichi ri nducha, ti ni ka jaꞌa ra nducha ni jiꞌi ri. Ni yaku ri nanu chaa ñuu jika, ti ni ka jaꞌa ra veꞌe ni kendo ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ni kumani saꞌma ri, ti ni ka jaꞌa ra naa ra. Ni kuꞌu ri, ti ni ka jandeꞌe ra ruꞌu. Ni kunde ri vekaa, ti ni ka jandeꞌe ra ruꞌu naa ra.” Siaꞌan kaꞌan ri jiin yɨvɨ kunchuku nundaꞌa kuaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yukan na ti yɨvɨ ni ketaꞌu un kachi i: “Jitoꞌyo, ¿nama ni jiꞌi ni soko, ti ni ka jaꞌa na ja ni yee ni? ¿Xi nama ni ichi ni nducha, ti ni ka jaꞌa na ja ni jiꞌi ni? ");
INSERT INTO mpmNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Xi nama ni yaku ni nanu chaa ñuu jika, ti ni ka jaꞌa na veꞌe ni kendo ni? ¿Xi nama ni kumani saꞌma ni, ti ni ka jaꞌa na? ");
INSERT INTO mpmNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Xi nama ni kuꞌu ni xi ni kundee ni vekaa, ti ni ka jandeꞌe na niꞌin?” ");
INSERT INTO mpmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yukan na ti ruꞌu, ja kuñaꞌnu ga, ti kachi ri: “Jandaa kuɨtɨ na kachi ri, ja siaꞌan ni ka saꞌa ra jiin ɨɨn ñani ndaꞌu ri ja ni kandixia da ruꞌu, ti saꞌa ri ja nuu maa ri ni ka saꞌa ra”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yukan na ti suni kachi ri jiin yɨvɨ kanchuku ndaꞌa sajni ri un: “Kuxio naa ra, roꞌo ja ni ka jnaꞌnu ndatu, ti kuankoyo nuu infiernu un, nuu kayu ñuꞌun ja kuu saa ni, chi ja iyo tuꞌva infiernu un ja kuu jaꞌuꞌu un jiin ángel da ja ka kuu ndajaꞌa da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Siaꞌan kondoꞌo ra, chi ni jiꞌi ri soko, ti tu ni ka jaꞌa ra ja kaji ri. Ni ichi ri nducha, ti suni tu ni ka jaꞌa ra nducha koꞌo ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ni yaku ri nanu chaa ñuu jika, ti tu ni ka jaꞌa nuu ra veꞌe kendo ri. Ni kumani i saꞌma ri, ko tu ni ka jaꞌa ra. Ni katuu ri ni kuꞌu ri, ni kunde ri vekaa, ko tu ni ka kii ndeꞌe kuɨtɨ ra ruꞌu naa ra”, kachi ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yukan na ti kachi yɨvɨ un: “Jitoꞌyo, ¿nama ni jiꞌi ni soko, xi ni ichi ni nducha, xi ni jikonuu ni nanu chaa ñuu jika, xi ni kumani saꞌma ni, xi ni kuꞌu ni, xi ni kunde ni vekaa, ti tu ni ka chindee na niꞌin naa na nu”? ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ti ruꞌu, chaa kuñaꞌnu kachi ri: “Jandaa kuɨtɨ na kachi ri ja tu ni ka saꞌa ra siaꞌan nuu ɨɨn yɨvɨ ndaꞌu jaꞌa ja ka kuu i ñani ri, ja kandixia i ruꞌu, ti saꞌa ri ja jiin maa ri ni ka saꞌa ra”, kachi ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yukan na ti kinkoyo yɨvɨ un nuu infiernu naa kondoꞌo koo nene i ja kuu saa ni. Ti yɨvɨ ni sasɨɨn Yandios ja kuu i yɨvɨ vaꞌa, nukoyo i nuu kuchaku i ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ti ni kachi ya jiin ndajaꞌa ya: ");
INSERT INTO mpmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ja ka jini ra ja uu ni ga kɨvɨ, ti jaa yo viko pascua. Ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa yɨvɨ ruꞌu ja na kundaka ri nuu ndaꞌa cruz ja na kuū ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti kɨvɨ un ni ka ndututu taka sutu ka kuñaꞌnu un jiin chaa ka xnaꞌan ley ini veñuꞌun kaꞌnu un, jiin taka chaa ka kuñaꞌnu ñuu Israel. Ti ni ka ndututu da nuu yuxeꞌe palacio maa sutu kuñaꞌnu ga, ja nani Caifás yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ti yukan ni ka ndajnuꞌun da nasa jnɨɨ xeꞌe da Jesús, ti kaꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko kachi da naa da: ―Tu saꞌa yo ja kuu kɨvɨ viko jaꞌa, chi ndonda yɨvɨ sɨkɨ yo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nɨ kande Jesús ñuu Betania, ti kancha ya veꞌe Simón, ɨɨn chaa ni ndoꞌo kueꞌe ndɨꞌyɨ teꞌyu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti nuu yee ya staa, ni tuꞌva ɨɨn ñaꞌan yɨndaꞌa ña ɨɨn tɨndoꞌo lulu alabastro, ti yukan ñuꞌun chitu aceite perfume ja nchaa yaꞌu xaan. Ti ni chiꞌi ña xini Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nu ni ka jini ndajaꞌa ya ja siaꞌan ni saꞌa ñaꞌan un, ni ka kɨtɨ ini da, ti ni ka kejaꞌa da ka kaꞌan da: ―¿Ndoo stɨvɨ ñaꞌan un aceite perfume un? ");
INSERT INTO mpmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿Ndoo tu ni xiko ña ti yaꞌu xaan nchaa, ti yukan kenda xuꞌun ja chindee ña yɨvɨ ndaꞌu? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ni jinisoꞌo Jesús ja siaꞌan ka kaꞌan da, ti ni kachi ya: ―Sia ña, ndoo ka skuɨtɨ ra ini ña. Ti iyo vaꞌa ɨɨn jniñu ni saꞌa ña jiin ri jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Va yɨvɨ ndaꞌu un nɨnɨ kancha i jiin ra naa ra, ko ruꞌu, ansu siaꞌan ni kuncha ri jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jniñu ni saꞌa ña jaꞌa, kuu ja, ja ni chiꞌi ña aceite perfume sɨkɨ yɨkɨ kuñu ri ja na kotuꞌva ja kuu kɨvɨ jakunduji ri. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ko jandaa kuɨtɨ na kachi ri ja savaꞌni ga nu nanu na kuichanuu jnuꞌun ri ja na sketaꞌu ri yɨvɨ, ti suni nukuꞌun ini yɨ jniñu ni saꞌa ñaꞌan jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yukan na ti ɨɨn ndajaꞌa Jesús nani Judas, chaa ñuu Cariote, ni jan kaꞌan da jiin sutu ka kuñaꞌnu un, ");
INSERT INTO mpmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ti ni kachi da: ―¿Nasa chaꞌu ni saña nu na nakuaꞌa na Jesús nuu ni naa ni? ―ni kachi da. Yukan ti ni ka chaꞌu sutu un oko uxi xuꞌun plata nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Undi kɨvɨ un ni kejaꞌa Judas nduku da nasa nakuaꞌa da Jesús nuu ndaꞌa chaa un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti maa kɨvɨ ni kejaꞌa viko ka yee staa stila tu yɨꞌɨ levadura, ti kɨvɨ un ni ka tuꞌva ndajaꞌa Jesús nuu ya ti ni ka jikajnuꞌun da ya: ―¿Nanu kuni ni ja savaꞌa na nuu kuxini yo vijna kɨvɨ pascua nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ti ni kachi Jesús: ―Kuaꞌan undi nuu veꞌe ɨɨn chaa un, ti kachi ra jiin da: “Kachi maa Maestro na. Ja ni kuyajni kɨvɨ kuū ri, ti veꞌe ra kuu nuu siaꞌa ri viko pascua jiin ndajaꞌa ri”, kachi ra naa ra ―ni kachi Jesús jiin ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ni jaꞌan ndajaꞌa un, ti ni ka saꞌa da nava ni taꞌu Jesús jniñu, ti ni ka satuꞌva da ja kuxini viko pascua un. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nu ni kuaa ti ni jaa Jesús jiin ndɨ uxi uu ndajaꞌa ya, ti ni ka tuꞌva yuꞌu mesa ka yee da staa. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ti nɨ yaji ya staa jiin da naa da, ti ni kachi ya: ―Jandaa na kachi ri, ja ɨɨn roꞌo ja kanchuku jaꞌa, kuu ja nakuaꞌa ruꞌu nuu chaa ka jito uꞌu ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yukan ti ni ka kukuiꞌya xaan ini da naa da ja siaꞌan ni kaꞌan ya, ti ni ka kejaꞌa ka jikajnuꞌun ndɨ ɨɨn ndɨ ɨɨn da ya: ―¿Jitoꞌyo, xi saña kuu nusa? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ti ni kachi Jesús jiin da naa da: ―Ɨɨn ja chuntoo staa stila nuu koꞌo ri, yukan kuu ja kin nakuaꞌa ruꞌu nuu chaa ka jito uꞌu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, ve siuku ndaa ri nava yoso nuu tutu Yandios ja siaꞌan saꞌa yɨvɨ jiin ri, ko na ndaꞌu ga chaa kin nakuaꞌa ruꞌu un. Sa nu tu ni kaku da niku ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yukan na ti ni kaꞌan Judas, chaa kin nukuaꞌa ya un, ti ni kachi da: ―Maestro, ¿xi saña kuu nusa? ―ni kachi da. Ti ni kachi Jesús: ―Suu roꞌo kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ni ka yaji da staa, ni kiꞌin Jesús ɨɨn staa stila, ni nakuantaꞌu ya nuu Yandios, ti ni sakuachi ya staa stila un, ti ni tejnaꞌan ya nuu ndajaꞌa ya, ti ni kachi ya: ―Kaji naa ra, chi jaꞌa kuu nanu yɨkɨ kuñu ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yukan na ti ni kiꞌin ya ɨɨn vasu vino, ni nakuantaꞌu ya nuu Yandios, ti ni siaꞌa ya nuu da naa da ja koꞌo da tɨꞌlɨ tɨꞌlɨ, ti ni kachi ya: ―Tendɨꞌɨ ra na koꞌo tɨꞌlɨ tɨꞌlɨ ja ñuꞌun copa jaꞌa naa ra, ");
INSERT INTO mpmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","chi jaꞌa kuu nanu nɨñɨ ri ja soko ri. Ti nɨñɨ ri un stuu ja, ja ni saꞌa Tata ri Yandios ɨɨn tratu jaa. Ti yukan kuu ja kaꞌan ndaa kuɨtɨ ja nama ri sɨkɨ kuaꞌa xaan yɨvɨ. Chi ja chunaa ri nuu i jiin nɨñɨ ri ja katɨ ri kiꞌin un. Ti jiin yukan nanitaꞌu kuaꞌa xaan yɨvɨ nuu Yandios. Ti kuankaꞌnu ini ya nuu i, chi ja kenchaa kuachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ko na kachi ndaa ri ja tukaa ga koꞌo ri vino jaꞌa jiin ñanijnaꞌan yo taka jinu ja ka nasaꞌa i viko jaꞌa, undi na jaa kɨvɨ koꞌo yo nuu kancha Tata ri Yandios, chi yukan kuu nuu niꞌin ri ɨɨn jniñu ñaꞌnu ga. Ti yukan taꞌu ri jniñu jiin maa ya nuu nɨ tuꞌu taka ja iyo. Ti yukan kuu nuu nasaꞌa jaa yo viko jaꞌa naa yo ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nu ni ndɨꞌɨ ni ka kuxini da, ti ni jita ya ɨɨn himno jiin da naa da. Yukan na ti ni kenda ya kuaꞌan ya undi yuku Olivos jiin da naa da, ");
INSERT INTO mpmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ti yukan ni kachi Jesús jiin da naa da: ―Tendɨꞌɨ ra yuꞌu jakuaa vijna ja sɨkɨ ruꞌu, chi siaꞌan yoso jnuꞌun un nuu tutu Yandios: “Kuaꞌa ri jnuꞌun ja na kaꞌni yɨvɨ chaa ndito rɨɨ un, ti yuꞌu rɨɨ un naa tɨ, ti kuichanuu tɨ kinkoyo tɨ”, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko nu na nandoto ri, ti kandu ri kiꞌin ri ñuu Galilea, ti sa jakoyo ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yukan ti ni kachi Pedro: ―Vasu tendɨꞌɨ da na yuꞌu, ti kunu da kinkoyo da ko saña, chi tu yuꞌu kuɨtɨ na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yukan ti ni kachi Jesús jiin da: ―Jandaa na kachi ri nuu ra ja, jakuaa vijna nu ti kana ga liꞌi, ti ja kaꞌan ra uni jinu ja chisaꞌyɨ ra ruꞌu, ti roꞌo kachi ra ja tu jini ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ti ni kachi Pedro jiin ya: ―Vasu na kuū na jiin ni, ko tu chisaꞌyɨ na niꞌin ―ni kachi da. Ti suni siaꞌan ni ka kachi taka ga ndajaꞌa ya naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ni jaa Jesús jiin ndajaꞌa ya ɨɨn nuu nani Getsemaní, ti ni kachi ya jiin da naa da: ―Jaꞌa ni kunchuku ra naa ra, ti ruꞌu na kin kakantaꞌu ri yukan ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ni kana ya Pedro jiin ndɨnduu seꞌe yɨɨ Zebedeo kuaꞌan ya jiin, ti ni kejaꞌa kukuiꞌya xaan ini ya, ti ni kejaꞌa ndɨꞌɨ ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ti ni kachi ya jiin da naa da: ―Jatu añu ri ja kukuiꞌya xaan ini ri, chi ja ni kuyajni kuu ri. Ti jaꞌa ni kundatu ra naa ra ti koto kusu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ti ni jika ya tɨꞌlɨ ga. Ti yukan ni jankunjitɨ ya undi nuu ñuꞌun, ti ni jikantaꞌu ya nuu Yandios, ni kachi ya: ―Tata na Yandios, nu kuu ti chajiyo ni nundoꞌo kii sɨkɨ na un jaꞌa, ti nama ni saña. Ko ansu nava kuni maa na, chi na kuu nava kuni maa ni ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ni nandeokuñɨ ya nuu kanchuku ndajaꞌa ya, ti ni jini ya ja ka kixi da, ti ni kaꞌan ya jiin Pedro: ―¿Xi tu ni kuu kundito ra tɨꞌlɨ jiin ri vasu ti ɨɨn hora nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kondito naa ra, ti kakantaꞌu nuu Yandios nava tu kotojnuni jaꞌuꞌu un roꞌo, ti chisaꞌyɨ ra ruꞌu. Chi jandaa ndixia ja añu ra, chi iyo ndee ini, ko yɨkɨ kuñu ra kuu ja tu iyo ndee ini ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti kuaꞌan tuku ya jinu kuu uu, ti siaꞌan ni jikantaꞌu tuku ya: ―Tata na, ti nu tu kuu kuxio nundoꞌo jaꞌa sɨkɨ na, nusa ti na kuu nava kuni maa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ni nandeokuñɨ tuku ya nuu kanchuku ndajaꞌa ya un, ko ja ka kixi tuku da, chi tukaa ga kundee nduchi da jiin maꞌna. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ni xndoo ya maa da, ti kuaꞌan tuku ya jinu kuu uni ni jikantaꞌu tuku ya nuu Yandios, nava ni jikantaꞌu ya undi nuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yukan na ti ni najaa tuku ya nuu kanchuku ndajaꞌa ya un, ti ni kachi ya: ―Vijna na, ndetatu ti kusu naa ra. Chi ja ni jaa hora ja ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa yɨvɨ ruꞌu nuu yɨvɨ ka nchakuachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndoko naa ra na choꞌo, chi ja vaji chaa ni nakuaꞌa ruꞌu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti nɨ kaꞌan ga ya siaꞌan jiin da naa da, ti ja ni kenda Judas, ɨɨn chaa ni kuu ndajaꞌa ya un. Ti ka jindandikun kuaꞌa xaan yɨvɨ kuaja jiin da, ti ka yɨndaꞌa espada jiin yujnu. Ti yɨvɨ un ka kuu ja ni ka taji sutu ka kuñaꞌnu jiin taka chaa ka kuñaꞌnu nuu ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ti Judas ja ni ndajnuꞌun vaꞌa da jiin chaa un naa da: ―Chaa kanxiaꞌu ri jiin, ti teyuꞌu ri nuu, yukan kuu ja ka nanduku yo. Ti chaa yukan jnɨɨ ra naa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yukan ni jaa Judas, ni tuꞌva da nuu Jesús, ti ni kachi da: ―Too ni kuaa, maestro ―ni kachi da. Ti ni teyuꞌu da nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yukan ti ni kachi Jesús jiin da: ―¿Ti roꞌo, naa sɨkɨ vaji ra nusa? ―ni kachi ya. Yukan ti ni ka tuꞌva chaa un, ni ka jnɨɨ da presu ya, ti kuankoyo da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ti ɨɨn chaa kaꞌiin jiin Jesús yukan, ni tava da espada da, ti ni jaꞌncha da soꞌo ɨɨn chaa kuu muzu nuu sutu kuñaꞌnu ga un. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yukan ti ni kachi Jesús jiin da: ―Na savaꞌa espada ra. Chi taka yɨvɨ kanaa jiin espada, suni jiin espada un kuū i. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Xi tu jini ra ja kuu kakantaꞌu ri nuu Tata ri, ti vijna ñuꞌni taji ya viꞌi ga uni xiko uxi uu mil ángel ja ka junukuachi nuu ya, ja na kii nama ya ruꞌu nu? ");
INSERT INTO mpmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko nu na kii nama ángel un ruꞌu, ti va tu kuu kundaa nava yoso nuu tutu Yandios ja siaꞌan kondoꞌo ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yukan na ti ni kaꞌan Jesús jiin yɨvɨ kuaꞌa un: ―¿Va nu ɨɨn chaa kuiꞌna kuu ri, xi ni ndonda ri sɨkɨ gobierno nu? ¿Xi ndoo kuu ja vekoyo ra jiin espada jiin yujnu ja ve jnɨɨ ra ruꞌu nusa? Taka kɨvɨ ni kuncha ri jiin ra naa ra ini veñuꞌun kaꞌnu un, na ni xndaku ri nuu ra naa ra, ti tu ni ka jnɨɨ ra presu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko siaꞌan kuu nava na kundaa nava yoso nuu tutu ja ni ka chaa profeta najanaꞌan, na ni ka kaꞌan da jnuꞌun Yandios ―ni kachi Jesús. Yukan na ti tendɨꞌɨ ndajaꞌa ya un ni ka yuꞌu da, ni ka xndoo da maꞌɨɨn ni ga Jesús, ti ka jinu da kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ti chaa ni ka jnɨɨ presu Jesús, kuankoyo da jiin ya undi nuu sutu kuñaꞌnu ga nani Caifás. Yukan ni ka ndututu taka chaa ka xnaꞌan ley un jiin taka chaa ka kunaꞌnu ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ti Pedro jika ni ndikun da kuaꞌan da undi ni jaa da yuxeꞌe sutu kuñaꞌnu ga un. Yukan ni kɨvɨ da, ti ni nukoo da jiin chaa ka kuu policia un, ja na kuni da nasa saꞌa chaa un jiin Jesús naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Taka sutu ka kuñaꞌnu un jiin chaa ka kuñaꞌnu nación Israel un, jiin yɨvɨ ni ka ndututu nuu junta kuñaꞌnu nación Israel un, ka nduku da ɨɨn jnuꞌun nasa chakuachi da sɨkɨ Jesús, vasu ɨɨn kuachi ñaa, nava na kaꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko tu ni ka niꞌin da na jnuꞌun chakuachi da sɨkɨ ya, vasu kuaꞌa yɨvɨ ni ka chakuachi ñaa sɨkɨ ya. Ti sandɨꞌɨ ni ga ni ka kenda uu chaa ni ka chakuachi sɨkɨ ya, ");
INSERT INTO mpmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ti ni ka kachi da: ―Chaa jaꞌa ni kachi: “Ruꞌu, kuu xnaa ri veñuꞌun Yandios, ti nuu uni kɨvɨ ti nasaꞌa jaa tuku ri”, ni kachi da ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yukan na ti ni ndokuɨñɨ sutu kuñaꞌnu ga un, ti ni kachi da jiin Jesús: ―¿Tu kaꞌan kuɨtɨ ra nusa? ¿Naa jnuꞌun kuu ja ka kaꞌan kuachi chaa jaꞌa sɨkɨ ra nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko Jesús tu ni kaꞌan kuɨtɨ ya. Yukan na ti sutu kuñaꞌnu ga un ni kachi jiin ya: ―Jiin sɨvɨ Yandios chaku, kaꞌan ndaa kuɨtɨ ri jiin ra, ti kachi ndaa kuɨtɨ nu maa ra kuu Cristo, Seꞌe Yandios ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yukan na ti ni kachi Jesús: ―Ruꞌu kuu nava ni kaꞌan ra un. Ti suni na kachi ri nuu ra naa ra ja ruꞌu, undi vijna kuni ra naa ra ja maa ri kuu maa Seꞌe Yɨvɨ Ñuyɨvɨ, kinoꞌon ri andɨvɨ, ti yukan nukoo ri ndaꞌa kuaꞌa Yandios ja na kundiso ri ɨɨn jniñu ñaꞌnu jiin ya, ti kuni ra ruꞌu naa ra ndii ri nuu viko nuu andɨvɨ un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ti sutu kuñaꞌnu ga un, nu ni jinisoꞌo da jnuꞌun ni kaꞌan ya, ni ndata da saꞌma da ja ni kɨtɨ xaan ini da, ti ni kachi da: ―¡Yɨsɨkɨnchaa chaa jaꞌa Yandios jiin jnuꞌun kaꞌan da un! ¿Nau ga ɨnga testigo nandɨꞌɨ yo nusa? Ti ja ni ka jinisoꞌo ra taka jnuꞌun ni kaꞌan da un. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ti nasa ka ndoꞌo ini ra naa ra nusa? ―ni kachi da. Ti tendɨꞌɨ yɨvɨ un ni ka kachi: ―Nchakuachi da ja kaꞌan da siaꞌan, ti vaꞌa ga ja na kuū da ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yukan na ti ni ka tɨvɨ sɨꞌɨ da nuu ya, ti ni ka jaꞌa da tau ya jiin jikɨ. Ti sava ga da ni ka katu da nuu ya, ");
INSERT INTO mpmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ti ka kachi da naa da: ―Nu maa ra kuu Cristo, ti kachi nau ja ni kani roꞌo ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ti nu kancha Pedro nuu yuxeꞌe un, ni kenda ɨɨn ñaꞌan junukuachi un, ni tuꞌva ña nuu da, ti ni kachi ña: ―Roꞌo, suni ni yaku ra jiin Jesús, chaa ñuu Galilea un ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ko Pedro tu ni kachi ndaa kuɨtɨ da, ti ni kachi da: ―Tu jini ri naa jnuꞌun kaꞌan ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ni kenda Pedro yuxeꞌe un, ti yukan ni jini ɨnga ñaꞌan un nuu da, ti ni kachi ña jiin yɨvɨ kaꞌiin un: ―Chaa jaꞌa, suni ni jikonuu da jiin Jesús, chaa ñuu Nazaret un ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ko tu ni kachi ndaa tuku Pedro, ti nanu ja ni kaꞌan ndaa da, ni kachi da: ―Tu jini ri naa chaa kuu ja kaꞌan ra un ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ni kuu nuu ga, ti ni ka tuꞌva chaa kaꞌiin un nuu Pedro, ti ni ka kachi da: ―Jandaa ndixia kuu ja suni jnaꞌan chaa un kuu ra, chi janyɨɨ ni kaꞌan ra yuꞌu chaa Galilea ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yukan ti kuan niꞌin Pedro ja tu jini da, ti tu jini da, ti ni kachi da: ―Tu jini kuɨtɨ ri chaa yukan ―ni kachi da. Ti nɨ kaꞌan ga da siaꞌan, ni kana ni ɨɨn liꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yukan ti ni nukuꞌun ini Pedro jnuꞌun ni kaꞌan Jesús jiin da: “Ja nu ti kana ga liꞌi, ti chisaꞌyɨ ra ruꞌu uni jinu ja tu jini ra ruꞌu.” Ti yukan ni nakani xaan tonto ini da, ni kenda da kuaꞌan da, ti ni ndeꞌe xaan tonto da ja jnuꞌun kuiꞌya ini. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nu kuan kundijin, ti ni ka ndajnuꞌun taka sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌnu ñuu Israel naa da, nasa kuu kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ni ka juꞌni da ya ti ni ka yɨndaꞌa da ya nuu Poncio Pilato, chaa romano ja ni kuu da gobernador. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nu ni jini Judas ja kuankoyo da jiin Jesús ja na kaꞌni da ya, ni nakani xaan tonto ini da. Ti ni nakuaꞌa da ndɨ oko uxi xuꞌun plata un nuu sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌnu ñuu Israel un, ");
INSERT INTO mpmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ti ni kachi da nuu da: ―Ni chakuachi na maa na, ja ni nakuaꞌa na ɨɨn chaa tu ni iyo ni ɨɨn kuachi, ja na kuū da ―ni kachi Judas. Yukan ti ni ka kachi chaa un jiin da: ―Ja yukan, tundo ka jitu ini ruꞌu naa ri. Ti yukan kuu kuachi maa ra ―ni ka kachi da jiin Judas. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yukan ti ni siukoyo Judas ndɨ oko uxi xuꞌun plata un ini veñuꞌun un, ti ni kee da kuaꞌan da. Ti ni skuaꞌña da maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sutu ka kuñaꞌnu un ni ka nastutu da xuꞌun un, ti ni ka kachi da: ―Tu kuu nachuꞌun yo xuꞌun jaꞌa nuu ñuꞌun xuꞌun ka soko yɨvɨ un naa i, chi xuꞌun yaꞌu nuu nɨñɨ kuu ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yukan ti ni ka ndajnuꞌun da ja kuan da ɨɨn nduꞌva ñuꞌun kixin nuu ka saꞌa da kɨsɨ un. Ti nuu ñuꞌun yukan kuu nuu chunduji da yɨvɨ ñuu jika naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja yukan kuu ja undi vijna nani ñuꞌun un nduꞌva nɨñɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yukan ni kundaa nava ni kaꞌan Jeremías, chaa ni kuu profeta, ja ni kachi da: “Ni ka kiꞌin da ndɨ oko uxi xuꞌun plata un, ja ni kuu xuꞌun ni kuyaꞌu ɨɨn chaa vaꞌa ja ni ka xiko maa chaa ka kuñaꞌnu ñuu Israel naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ti jiin xuꞌun un ni ka nakuan da nduꞌva ñuꞌun kixin un. Ti yukan kuu jnuꞌun ni xndaku jitoꞌo na Yandios nuu na”, ni kachi Jeremías. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ni ka yɨndaꞌa da Jesús nuu gobernador, ti chaa un ni jikajnuꞌun da ya: ―¿Maa ra kuu rey chaa Israel nu? ―ni kachi da. Ti ni kachi Jesús: ―Maa ri kuu, nava ni kachi ra. Kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ti taka sutu ka kuñaꞌnu un jiin chaa ka kuñaꞌnu ñuu Israel ka kankuachi da sɨkɨ Jesús, ko maa ya tu ni kaꞌan kuɨtɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yukan ti ni kachi Pilato jiin ya: ―¿Ñusoꞌo ra taka jnuꞌun ka kankuachi yɨvɨ jaꞌa sɨkɨ ra nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko Jesús, tu ni kaꞌan kuɨtɨ ya ni ɨɨn jnuꞌun. Ti chaa kuu gobernador un, so ni naa ini da, ti so ni saꞌu ini da, chi tu kujnuni ini da nasa saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ti ni iyo jnuꞌun maa chaa kuu gobernador un, ja sia da ɨɨn presu ja kuu kɨvɨ viko pascua un, nuu nau ja na nakaji yɨvɨ ja na sia da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti kɨvɨ un kande presu ɨɨn chaa nani Barrabás, ja ni sasɨɨn da yɨvɨ, ti ni ndonda da sɨkɨ gobierno. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ti nu ni ka ndututu kuaꞌa xaan ga yɨvɨ un nuu Pilato, ti Pilato ni jikajnuꞌun da nuu yɨvɨ un: ―¿Nau chaa ka kuni ra naa ra ja na sia ri nusa? ¿Sia ri Barrabás, xi sia ri Jesús ja ka skonani ra Cristo naa ra nu? ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Siaꞌan ni kaꞌan da, chi kuni nama da Jesús, chi ni jini da ja sɨkɨ jnuꞌun kuasun ini ni ka nakuaꞌa sutu un Jesús nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ni nukoo Pilato mesa nuu taꞌu da jniñu un, ti undi nuu kancha da un ni taji ñasɨꞌɨ da razón nuu da, ni kachi ña: “Sia chaa jña. Koto ma ndeꞌe ra ndo kuu sɨkɨ da, chi kuu da ɨɨn chaa vaꞌa, ndo kúní ni siuꞌu xaan ɨɨn jani ruꞌu, ja sɨkɨ chaa jña”, kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌnu un, ni ka skaꞌan da yɨvɨ ja na kakan i ja na sia Pilato Barrabás, ti na kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yukan ti ni jikajnuꞌun tuku chaa kuu gobernador un nuu yɨvɨ, ti ni kachi da: ―Ja ndɨnduu chaa jaꞌa, ¿nau chaa ka kuni ra ja na sia ri kiꞌin nusa? ―ni kachi da. Ti ni ka kachi yɨvɨ un: ―Sia ni Barrabás ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yukan ti ni jikajnuꞌun Pilato yɨvɨ un: ―¿Ti ndoo saꞌa ri jiin Jesús, ja ka skonani Cristo nusa? ―ni kachi da. Yukan ti tendɨꞌɨ yɨvɨ un ni ka kachi: ―¡Katakaa ni da ndaꞌa cruz, na kuū da! ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yukan na ti ni kachi tuku Pilato jiin yɨvɨ un: ―¿Ti nau kuachi ni saꞌa da nusa? ―ni kachi da. Ko viꞌi ga ni ka kejaꞌa kana koꞌo yɨvɨ un: ―¡Katakaa ni chaa jña ndaꞌa cruz, na kuū da! ―ni ka kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nu ni jini Pilato ja tu kundee da jiin yɨvɨ un, chi viꞌi ga ni ka ndondaa i, ka kuvaa i, yukan ti ni jikan da nducha, ti ni nandaꞌa da nuu yɨvɨ kuaꞌa un, ti ni kachi da: ―Tu kiꞌin kuachi sɨkɨ ri ja kuu chaa vaꞌa jaꞌa, chi na kiꞌin kuachi sɨkɨ maa ra naa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ti ni ka kachi tendɨꞌɨ yɨvɨ kuaꞌa un: ―Na kunchakuachi sɨkɨ maa na naa na jiin seꞌe na ja kuu saa ni, nuu nɨñɨ chaa jña nu na kuū da ―ni ka kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yukan na ti ni sia Pilato Barrabás kuaꞌan da. Ti ni taꞌu da jniñu ja na kuaꞌa da tau Jesús. Yukan na ti ni nakuaꞌa da ya nuu yɨvɨ un ja, na katakaa da ya nuu nda cruz. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yukan na ti soldado chaa kuu gobernador un kuaꞌan da jiin Jesús ichi yuxeꞌe palacio un, ti ni ka nastutu jnaꞌan tendɨꞌɨ kuɨtɨ da nuu ya naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ni ka tevichi da ya jiin saꞌma ñuꞌun ya, ti ni ka naskuiꞌna da ya jiin ɨɨn saꞌma kuaꞌa vixi. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ni ka saꞌa da ɨɨn corona iñu, ni ka chuxndee da xini ya. Ti ni ka chiꞌi da ɨɨn yujnu xii ndaꞌa kuaꞌa ya. Yukan na ti ka jakunjitɨ da nuu ya ja ka kuu ichi ini da nuu ya, ti ni ka kachi da: ―Too ni ndii, Rey chaa Israel. Na kuchaku naꞌan ni ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ti ka tɨvɨ sɨꞌɨ da nuu ya. Ka kiꞌin da yujnu xii yɨjnɨ ya un, ti ni ka kani da xini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ni ndɨꞌɨ ni ka ske ichi da ya, ja ni ka saꞌa ndevaꞌa da jiin ya. Yukan na ti ni ka tava da saꞌma kuaꞌa vixi ñuꞌun ya, ti ni ka naskuiꞌna tuku da ya jiin saꞌma maa ya. Ti kuankoyo da jiin ya ja na kundaka ya ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nu ni ka kee da kuankoyo da, ti ni ka ndejnaꞌan da jiin ɨɨn chaa ñuu Cirene ja nani Simón, ti ni ka chayɨka da chaa un ja na kundiso da cruz Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ti siaꞌan kuankoyo da undi ni ka jakoyo da nuu nani Gólgota, ti jnuꞌun un kuni kaꞌan “ñuꞌun yɨkɨ xini.” ");
INSERT INTO mpmNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yukan ni ka skoꞌo da Jesús vino sakanuu jiin mirra, ja na koꞌo ya nava tu ndoꞌo xaan ya ja jatu ya. Ko ni soyuꞌu ya tɨꞌlɨ, ti tukaa ga ni jiꞌi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nu ja ni ka jatakaa da Jesús ndaꞌa cruz, ti soldado un ni ka chuꞌun da suerte, ja na tejnaꞌan nuu jnaꞌan da saꞌma ya naa da. Yukan ni kundaa nava ni kachi profeta siaꞌan: “Ni ka chuꞌun da suerte sɨkɨ saꞌma ri, ti ni ka kiꞌin da.” ");
INSERT INTO mpmNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yukan na ti ni ka nukoo da un ja na kundito da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ti ichi xini ya yukan ni ka chaa da ɨɨn tutu ja kaꞌan naa sɨkɨ ni jiꞌi ya. Ti nuu tutu un yoso siaꞌan: “Jaꞌa kuu Jesús, chaa kuu Rey yɨvɨ nación Israel.” ");
INSERT INTO mpmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Suni ni ka jatakaa da uu ñakuiꞌna jiin ya, ɨɨn da ndaꞌa kuaꞌa ya, ti ɨnga da ndaꞌa sajni ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ti yɨvɨ ka yaꞌa ichi yukan, ka ku ichi ini nuu ya, ti ka skuiko i xini i, ");
INSERT INTO mpmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ti ka kaꞌan ndevaꞌa kuɨtɨ i: ―Roꞌo ja ni kaꞌan ra ja xnaa ra veñuꞌun kaꞌnu Israel, ti nuu uni kɨvɨ ni ti nakani jaa tuku ra, nama maa ra vijna. Ti nu Seꞌe Yandios kuu ra, ti kuan kuun ndaꞌa cruz jña ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ti suni siaꞌan ka cu ichi ini chaa ka kuu sutu kuñaꞌnu un, jiin taka chaa ka xnaꞌan ley un, jiin suni chaa fariseo, jiin taka chaa ñaꞌnu ñuu Israel un, ti ka kaꞌan da: ");
INSERT INTO mpmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ni nama da sava yɨvɨ ko vijna na, ti tu kuu nama da maa da. Ti nu ndixia da ja maa da kuu Rey yɨvɨ ñuu Israel, na kii kuun da ndaꞌa cruz un, ti sa na kandixia yo jnuꞌun kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ni kuu kanu ini da Yandios. Ti maa Yandios na nama ya maa da vijna nusa, nu ndixia da ja kuu ini Yandios maa da. Chi maa da ni kachi da nuu yo ja maa da kuu Seꞌe Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Suni ñakuiꞌna ka ndakoyo ndaꞌa cruz un, suni siaꞌan ni ka ku ichi ini nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yukan ti ni kuñaa nɨ tuꞌu ñuyɨvɨ, ni kejaꞌa undi sava nduu, ti kuaꞌan undi ka uni jaꞌini. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ti hora un ni kanajiin Jesús: ―Elí, Elí, ¿lama sabactani? ―ni kachi ya. Ti jnuꞌun un kuni kaꞌan: “Yandios maa na, Yandios maa na, ¿ndoo ni xndoo maa ɨɨn ni saña vijna”? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ti sava yɨvɨ kaꞌiin un ni ka jinisoꞌo ja siaꞌan ni kanajiin ya, ti ni ka kachi: ―Kunsoꞌo naa ra, chi kana da xini profeta Elías ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yukan ti jinu ɨɨn chaa un ni jan kiꞌin da tɨꞌlɨ kachi, ni chuntoo da nuu vino iya, ti ni chuxndee da xini ɨɨn yujnu kani, ti ni chaa da yuꞌu ya ja na koꞌo ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ko uu ga da ni ka kachi: ―Sia da, na ndeꞌe yo nu kii Elías kii nama da chaa ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yukan na ti ni kanajiin koꞌo Jesús, ti ni jiꞌi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti maa hora ni jiꞌi ya un, ni teꞌnde sava saꞌma yɨndaka ini veñuꞌun kaꞌnu Israel un. Ja undi nuu sukun, ti undi nuu jaꞌa ni ndata. Ni nɨꞌɨn ñuyɨvɨ jiin ɨɨn ñujnaa. Ti ni ka ndata kava un. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ti kuaꞌa ñaña ndɨyɨ un ni ka nuña, ja ni ka nandoto yɨkɨ kuñu yɨvɨ kuaꞌa ni ka kandixia ndaa Yandios ja ja ni ka jiꞌi un. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nu ni nandoto Jesús, ti ni ka ndenda yɨvɨ ni ka nandoto un, ni ka ndɨvɨ i ñuu ii Jerusalén, ti kuaꞌa yɨvɨ ni ka nakuni nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nu ja ni jiꞌi Jesús, ti capitán soldado un jiin taka ga da ja chaa ka ndito Jesús, nu ni ka jini da ja siaꞌan ni kuu ja, ja ni nɨꞌɨn ñuꞌun jiin taka ga ja ni kuu un, ti ni ka yuꞌu xaan da, ti ni ka kachi da: ―Jandaa kuɨtɨ kuu ja Seꞌe Yandios ni kuu chaa jaꞌa ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ti yajni un, ni kaꞌiin tɨjnɨ ñasɨꞌɨ, ka ndeꞌe ña, ñaꞌan un ni ka kuu ñaꞌan ni ka kii jiin Jesús undi ñuu Galilea, ja ka chindee ña maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ti ñaꞌan un ka kuu María ñaa ñuu Magdala, María nana Jacobo jiin José, jiin nana seꞌe yɨɨ Zebedeo. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nu kuan kuaa, ti ni jaa ɨɨn chaa ñuu Arimatea nani José, ni kuu da ɨɨn chaa riko ja suni ni skuaꞌa da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ni jan kakan da yɨkɨ kuñu Jesús nuu Pilato. Ti Pilato ni taꞌu da jniñu ja na kuaꞌa soldado un yɨkɨ kuñu Jesús nuu José. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ni kiꞌin José yɨkɨ kuñu Jesús, ti ni suku da ya jiin ɨɨn manta finu, ");
INSERT INTO mpmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ti ni chunde da ya ini ɨɨn yau jaa, ja ni jacha maa da jika ɨɨn kava. Ni jasɨ da yuꞌu yau un jiin ɨɨn yuu kaꞌnu. Yukan na ti kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ti yukan kaꞌiin María ñaa ñuu Magdala jiin ɨnga María, kanchuku ña yuꞌu ñana nuu ni chunde da Jesús yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti ɨnga kɨvɨ, ja kuan kuyajni kɨvɨ ndetatu, ti ka jaꞌan chaa ka kuu sutu ka kuñaꞌnu un, jiin chaa fariseo nuu kande Pilato, ");
INSERT INTO mpmNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ti ni ka kachi da: ―Niꞌin Pilato, ni ka nukuꞌun ini na ja ni kachi chaa ni xndoñaꞌan un, na ni chaku ga da, ja nu uni kɨvɨ ti nandoto tuku da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yukan kuu ja taꞌu ni jniñu, ti na ndiꞌyu vaꞌa yuꞌu yau un undi kɨvɨ uni. Sandau kinkoyo ndajaꞌa da un jakuaa, ti tava da yɨkɨ kuñu chaa un, ti kachi da naa da nuu yɨvɨ ja, ja ni nandoto ndixia da nuu ñujiꞌi. Chi nu siukan na, ti viꞌi ga xndoñaꞌan da yɨvɨ naa i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yukan ti ni kachi Pilato jiin da naa da: ―Kuankoyo maa ra naa ra, kundaꞌa nasa soldado kuni maa ra naa ra. Ti saꞌa kutu yuꞌu ñaña un nava ka kuni maa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yukan na ti kuankoyo chaa un naa da, ti vaꞌa xaan tonto ni ka sakutu da yuꞌu ñaña un. Ti ni chunsama da uu yoꞌo sɨkɨ yuu un, ndɨ kuun jikɨ ja kuu nanu ɨɨn sello da naa da. Ti ni ka xndoo da soldado un ka ndito da. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nu ni yaꞌa kɨvɨ ndetatu un, ti ja kuan kundijin kɨvɨ nukuñɨ semana, ti María ñaa ñuu Magdala, jiin ɨnga María un, kuankoyo ña kuan ndeꞌe ña nuu ñunduji Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ti hora un ni kii ɨɨn ñujnaa xaan. Siaꞌan ni kuu, vanuxia ɨɨn ángel junukuachi nuu Yandios, ni kuun ya ichi andɨvɨ vaji ya, ti ni chaa ya yuꞌu ñaña un, ni stuncha ni ya yuu ndiꞌyu un kuaꞌan, ti ni nukoo ya sɨkɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Janducha ii ya nanu taja, ti saꞌma ñuꞌun ya xkɨyɨ niꞌni. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nu ni ka jini soldado un nuu ángel un, ti ni ka nɨꞌɨn da naa da ja ni ka yuꞌu da, ti so ni ka sana ini da nanu ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yukan na ti ni kachi ángel un jiin ñasɨꞌɨ un naa ña: ―Koto yuꞌu ra naa ra. Ja jini ri ja ka nanduku ra Jesús, yaa ni ka jatakaa yɨvɨ ndaꞌa cruz un. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ko tukaa ga kande ya jaꞌa, chi ja ni nandoto ya nava ni kachi ya. Ñaꞌan ti ndeꞌe naa ra nuu ni katuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vijna na ti kuankoyo yachi naa ra, ti kani ra jnuꞌun nuu ndajaꞌa ya: “Chi ni jiꞌi ya ko ja ni nandoto ya, ti koxnuu ya kiꞌin ya ñuu Galilea sa kinkoyo ra. Ti yukan nakuni ra ya naa ra.” Jnuꞌun jaꞌa vee kachi ri nuu ra naa ra ―ni kachi ángel un jiin ña naa ña. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yukan na ti kuankoyo ña, ni ka nduñama sɨꞌɨ ña vasu ka yuꞌu ña, ko suni ka kusɨɨ ini ña. Ti kuan kaxnuꞌun ña nuu ndajaꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ko ni kuankoyo ña ichi un, ti ni ka ndejnaꞌan ña jiin Jesús, ni kanxiaꞌu ya jiin ña naa ña. Ti maa ña ni ka tuꞌva ña nuu ya, ni ka nanuu ña jaꞌa ya ja ni ka nachiñuꞌun ña ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ti maa ya ni kachi ya jiin ña: ―Koto yuꞌu ra naa ra. Kuan kaxjnuꞌun nuu chaa ka kandixia ruꞌu ja na kinkoyo ñuu Galilea, ti yukan ndejnaꞌan ri jiin yɨvɨ un naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ni kuankoyo ñasɨꞌɨ un naa ña, ti sava soldado ni ka ndito un, kuan nukoyo da ñuu un, ti ni ka jani da jnuꞌun taka nava ni kuu un nuu sutu ka kuñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ti sutu un ni ka kee ni ka jaꞌan kaꞌan jiin taka chaa ka kuñaꞌnu un, ti yukan ni ka ndajnuꞌun nava ɨɨn ni jnuꞌun na koo yuꞌu da naa da. Yukan ti ni ka jaꞌa da xuꞌun kuaꞌa nuu soldado un, ");
INSERT INTO mpmNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ti ni ka kachi jiin da: ―Roꞌo, kachi ra naa ra ja ni ka naa ini ra ni ka kixi ra jakuaa un, ti ni jakoyo ndajaꞌa Jesús, ti ni ka sakuiꞌna da yɨkɨ kuñu chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ti nu na kuni gobernador jnuꞌun un, ti maa ri na kaꞌan jiin da, ti na nama ri sɨkɨ roꞌo naa ra ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ni ka kiꞌin soldado un xuꞌun un ti kuankoyo da, ti ni ka kachi da nava ni taꞌu jniñu nuu da. Ti jnuꞌun ni ka kaꞌan soldado un, ni kendo ka kaꞌan yɨvɨ nación Israel undi kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yukan na ti ndɨ uxi ɨɨn ndajaꞌa ya un kuan nukoyo da ñuu Galilea, undi yuku nuu ni kachi Jesús ja kinkoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nu ni ka jini ndajaꞌa un nuu ya, ti ni ka nachiñuꞌun da ya. Ko uu ga da, tu ka kandixia vaꞌa da ja maa ya kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yukan ni tuꞌva maa ya nuu da naa da, ti ni kachi ya: ―Ja ni jaꞌa Yandios ɨɨn jniñu ñaꞌnu nuu ri ja na kuñaꞌnu ri nuu savaꞌa ni ga ja iyo nuu nɨ kaꞌnu ñuyɨvɨ jiin andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Vijna na ti na tatu ri ɨɨn jniñu jaꞌa nuu ra naa ra. Kuankoyo nuu yɨvɨ taka nación, ti xnaꞌan ra jnuꞌun ri nuu i nava na kandixia i ruꞌu. Ti skuanducha ra i nu ja ni ka kandixia ndaa i maa Tata yo Yandios, jiin Seꞌe ya, jiin Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ti xnaꞌan ra ja na kuandatu i taka jniñu ni taꞌu ri nuu ra naa ra. Ti kuꞌun ini ra ja kancha ri jiin ra naa ra taka ni kɨvɨ undi na ndɨꞌɨ ñuyɨvɨ. Ti siaꞌan na koo ―kachi ya. Jaꞌa kuu jnuꞌun Yandios ni chaa Mateo.");
INSERT INTO mpmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jaꞌa kejaꞌa jnuꞌun Jesús, ya kuu Cristo, Seꞌe Yandios. Ti jnuꞌun un kuu ja ni kii ya ja ni nama ya yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chi siaꞌan ni chaa profeta Isaías tutu, na ni kaꞌan da jnuꞌun Yandios undi na janaꞌan. Ti ni chaa da jnuꞌun Juan nuu tutu siaꞌan: “Kunsoꞌo ra”, kachi Yandios jiin Seꞌe ya, chi taji ri ndajaꞌa ri. Koxnuu da kiꞌin da, ti xndaku da nuu yɨvɨ naa i, ja na kotuꞌva i ja kuu kɨvɨ jaa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ti kunde chaa un undi nuu ñuꞌun teꞌe un, ti kaꞌan niꞌin da nuu yɨvɨ siaꞌan: “Kotuꞌva ra naa ra, chi ja yajni chaa Jitoꞌyo. Ti kuni ja na kaka ndaa ra”, kachi da, ni kachi Yandios jiin Seꞌe ya. Ni kachi Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yukan ti ni kundaa jnuꞌun Yandios nava ni kachi Isaías, chi ni kenda Juan undi nuu ñuꞌun teꞌe un. Ti kuaꞌa yɨvɨ vekoyo ja na skuanducha da i, ti ni kachi da: ―Nakani ini nuu kuachi ra naa ra, ti kuanducha naa ra nava na kuankaꞌnu ini Yandios nuu kuachi ra ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ti kuaꞌa yɨvɨ ñuu Jerusalén jiin kuaꞌa yɨvɨ ndañuu Judea ni ka jaꞌan kunsoꞌo i jnuꞌun ni kaꞌan Juan. Ti yɨvɨ un, nu ni ka kachi i ja ni ka nakani ini i nuu kuachi i, yukan na ti skuanducha da i ini yucha Jordán. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ti saꞌma Juan ni kuu jiin ixi camellu. Ni yɨꞌɨ ɨɨn sanchi ñɨɨ chii da. Ndeyu da ni kuu ndɨkuaꞌyɨ jiin nduxi ñuñu yuku. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ti siaꞌan ni xndaku Juan nuu yɨvɨ: ―Kuan kuyajni ɨɨn chaa kuñaꞌnu ga ja kuu ruꞌu. Ti kuñaꞌnu ga da ja tu kuu kandu ri nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ti maa da tu skuanducha da roꞌo jiin nducha nanu saꞌa ruꞌu, chi chaa un skuanducha da roꞌo jiin Espíritu Santo naa ra. Ti yaa yukan kuu ya kuncha jiin ra naa ra ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yukan ti ni kee Jesús ñuu Nazaret, ja kuu ndañuu Galilea. Ti ni skuanducha Juan ya ini yucha Jordán. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nu ni kee Jesús ini nducha un, ni ti nuña andɨvɨ nuu kancha Yandios, ti ni jini Jesús ja vaji Espíritu Santo sɨkɨ ya, ti kaa ya nanu kaa ɨɨn sata. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti ichi andɨvɨ un ni kii ɨɨn ndusu nu ni kaꞌan Yandios jiin Jesús: ―Roꞌo kuu Seꞌe ri ja kundaꞌu xaan ini ri, ti kusɨɨ xaan ini ri jiin ra ―ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yukan ti ni yɨndaꞌa Espíritu Santo un maa Jesús undi nuu ñuꞌun teꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ti yukan ni kuncha ya uu xiko kɨvɨ nuu ka iyo kɨtɨ yuku un. Ti jaꞌuꞌu un ni kuni skaꞌan Jesús ja na saniꞌin ini ya nuu Yandios. Ko ni kikoyo ángel, ja ka kuu ndajaꞌa Yandios, ti ni ka chindee i maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ti yukan ni ka chondee da Juan vekaa, ti Jesús ni nandeokuñɨ ya ñuu Galilea. Ti yukan ni xnaꞌan ya jnuꞌun Yandios nuu yɨvɨ naa i, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","―Ja ni jaa kɨvɨ nuu taꞌu Yandios jniñu nuu nɨ tuꞌu ñuyɨvɨ. Vijna na ti nakani ini naa ra ti kandixia jnuꞌun ichi Yandios, chi yukan kuu ɨɨn ichi vaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ɨɨn kɨvɨ ni yaꞌa Jesús yuꞌu lago Galilea, ti ni jini ya kaꞌiin Simón jiin ñani da Andrés, ka jnɨɨ da chāká jiin ɨɨn ñunu, ");
INSERT INTO mpmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ti ni kana ya xini da: ―Kundikun ruꞌu naa ra, na choꞌo. Ni ka jnɨɨ xaan ra chāká, ko vijna ruꞌu na xnaꞌan ri roꞌo nasa nastutu ra yɨvɨ, ti xnaꞌan ra yɨvɨ un maa jnuꞌun Yandios kandixia i ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ti luego ni, ni ka xndoo da ñunu da, ti kuankoyo da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ni jika ya tɨꞌlɨ ga. Yukan ni jini ya nuu Jacobo jiin Juan, seꞌe yɨɨ Zebedeo, ka nachaa da ñunu da nuu ɨɨn barco. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Suni ni kana ya xini da: ―Ñaꞌan na choꞌo ―kachi ya. Ti chaa un ni ka xndoo da tata da Zebedeo ini barco un jiin muzu da, ti kuankoyo da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ni jakoyo da ñuu Capernaum. Ti ni kɨvɨ Jesús ini veñuꞌun Israel jañaꞌan ɨɨn kɨvɨ ka ndetatu yɨvɨ Israel. Ti ni xnaꞌan ya jnuꞌun Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti so ka naa ini i ni ka ñusoꞌo i jnuꞌun ni kaꞌan ya, chi ni xnaꞌan vaꞌa ya nuu i, nanu ɨɨn chaa ndiso jniñu nuu Yandios. Ti chaa ka xnaꞌan ini veñuꞌun un, tu ka xnaꞌan da nanu ni xnaꞌan maa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti yukan kande ɨɨn chaa jnaꞌan tachi xaan ini veñuꞌun un, uni ni kanajiin koꞌo da, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Kuxio ni nuu na naa na, niꞌin Jesús, chaa ñuu Nazaret. ¿Ndoo kɨvɨ nduu ni jiin na, xi vaji ni ja xnaa ni saña nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti Jesús ni nduxaan ya nuu tachi xaan un, ti ni kachi ya: ―Kasɨ yuꞌu, ti xndoo chaa jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ti tachi xaan un ni saꞌa ja na kuyɨꞌɨ chaa un, ti undi ni kanajiin koꞌo ti ni kee kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ti so ni ka saꞌu ini yɨvɨ un ja so ka naa ini ka ndeꞌe i, ti ka jikajnuꞌun jnaꞌan i: ―¿Na jnuꞌun kuu jaꞌa, xi na saꞌan kuu jaꞌa? ¿Xi kuñaꞌnu chaa un ja undi tachi xaan un ka jandatu nuu da, ti ka kekoyo kuaꞌan nu? ―ni kachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti yachi xaan ni jichanuu jnuꞌun Jesús nɨ ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yukan ni ka kekoyo da ini veñuꞌun un, ti kuankoyo da ichi veꞌe Simón jiin Andrés. Ti Jesús kuaꞌan ya jiin Jacobo jiin Juan jiin uu ga chaa ka skuaꞌa jiin ya, nu ni ka jakoyo da veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti nana chiso Simón kuꞌu ña. Katuu ña jiin kueꞌe kiji xaan, ti ni ka kachi da nuu Jesús ja kuꞌu ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Luego ni kɨvɨ ya nuu katuu ña. Ni jnɨɨ ya ndaꞌa ña, ni ndokani ya maa ña, ti ni nduvaꞌa ni ña jiin kueꞌe kiji un, ti ni ndokuɨñɨ ña. Yukan ti ni saꞌa ña ndeyu ni yaji ya jiin uu ga yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Nu ni kee ndikandii ti ni kɨꞌvɨ, ti tendɨꞌɨ yɨvɨ ñuu un, ni ka chitu ndɨɨ nɨ yuxeꞌe nuu kancha Jesús. Ka yɨndaꞌa i kuaꞌa yɨvɨ ka kuꞌu jiin chaa ka jnaꞌan tachi xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ti Jesús, ni saꞌa ya tajna kuaꞌa yɨvɨ ka kuꞌu un. Suni ni kenchaa ya kuaꞌa tachi xaan. Ko tu ni jaꞌa ya jnuꞌun ja kaꞌan tachi xaan un, chi ka jini na seꞌe kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jañaꞌan ɨnga kɨvɨ, ni iñaa ga, ni ndoko Jesús ti kuaꞌan ya nuu ñuꞌun teꞌe nuu tu iyo yɨvɨ. Ti yukan ni jikantaꞌu ya nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ko Simón jiin uu ga da, kuan nunduku da ya naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nu ni ka naniꞌin da ya, ti ni ka kachi da jiin ya: ―Kuaꞌa xaan yɨvɨ ka jikajnuꞌun niꞌin ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ti ni kachi ya: ―Na choꞌo uu ga ñuu kaꞌiin yajni jaꞌa, ti na xnaꞌan ri jnuꞌun Yandios nuu i. Chi ja yukan kuu ja ni taji Yandios ruꞌu vaji ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yukan na ti kuaꞌan ya nɨ ñuu Galilea, ni kaꞌan ya jnuꞌun Yandios ini veñuꞌun yɨvɨ Israel jiin taka ndaꞌa ñuu un, ti kenchaa ya tachi xaan ka jnaꞌan sava yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɨɨn kɨvɨ ni tuꞌva ɨɨn chaa jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu. Ni jakunjitɨ da nuu Jesús, ti ni kandaꞌu da jiin ya: ―Nu kuni ni, ti kuu sandoo ni saña jiin kueꞌe jnaꞌan na jaꞌa―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ti ni kundaꞌu ini ya maa da, ni skaa ya ndaꞌa ya, ni kueꞌe ya maa da, ti ni kachi ya jiin da: ―Kuni ri, na ndundoo ra vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nu ni kaꞌan ya siaꞌan, ti ni nduvaꞌa ni chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yukan na ti niꞌin xaan ni xndaku ya nuu da, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Koto kani ra jnuꞌun nuu ni ɨɨn yɨvɨ ja siaꞌan ni saꞌa ri tajna roꞌo. Kuaꞌan nuu sutu Israel un, ti na ndeꞌe da roꞌo. Nu ni ndeꞌe da roꞌo, ti kundaꞌa ja soko ra nuu Yandios sɨkɨ ja, ja ni ndundoo ra, nava kachi ley Moisés. Ti na soko sutu un nuu Yandios, nava na kuni yɨvɨ ja, ja ni kenchaa ndɨꞌyɨ un roꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko tu ni jandatu chaa un jnuꞌun ni kaꞌan Jesús. Ti kuaꞌan da, jani da jnuꞌun nuu taka yɨvɨ nava ni jnaꞌan da. Ja yukan kuu ja tukaa ni kuu kɨvɨ ndijin Jesús taka ñuu, chi jini ya ja nu na kɨvɨ ndijin ya, ti kinkoyo kuaꞌa xaan ga yɨvɨ nuu ya. Ja yukan kuu ja ni jikonuu ya nuu ñuꞌun teꞌe nuu tukaa iyo yɨvɨ, ko undi yukan ni ka kikoyo kuaꞌa yɨvɨ taka ñuu nuu kande ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nu ni kuu ga kɨvɨ ni nandeokuñɨ Jesús ñuu Capernaum. Ti ka jani da jnuꞌun ja, ja ni nchaa tuku ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yukan ti vekoyo kuaꞌa xaan yɨvɨ nuu kancha ya, ja tukaa ni kujaa veꞌe un, chi ni chitu ndɨɨ nɨ tuꞌu undi fuera. Ti yukan ni xnaꞌan ya jnuꞌun Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ko vekoyo ga yɨvɨ, ti kuun da ka ndiso ɨɨn chaa tɨkuku nuu ɨɨn yúú. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka kuni kundaꞌa da chaa un undi nuu kancha Jesús, ko tu kuu yaꞌa da ja xaan chitu yɨvɨ. Ti ni ka skaa da chaa kuꞌu un ichi xini veꞌe. Ni ka kenchaa teja un, ti ni ka sino da chaa kuꞌu un nuu kancha Jesús, ti yukan ni ka sino da chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ti nu ni jini Jesús ja ka kandixia da maa ya ja kuu saꞌa ya tajna, ti ni kachi ya jiin chaa tɨkuku un: ―Ndaꞌu seꞌe ri, ja ni jankaꞌnu ini ri nuu kuachi ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ti yukan kaꞌiin tɨjnɨ chaa ka xnaꞌan ini veñuꞌun yɨvɨ Israel. Ti nu ni ka jinisoꞌo da jnuꞌun ni kaꞌan Jesús jiin chaa tɨkuku un, ni ka ndoꞌo ini da: ");
INSERT INTO mpmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nau ja kuu ɨɨn chaa jaꞌa ja ndoꞌo ini da ja kuu da Yandios, ti kaꞌan da sɨkɨ Yandios ja kaꞌan da siaꞌan? Ti jaꞌa tu iyo ni ɨɨn ja kuankaꞌnu ini nuu kuachi yo, chi vajnuꞌun ni maa Yandios”, ni ka ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ko maa Jesús ja ni jini ya ndoo ka ndoꞌo ini da, ti ni kachi ya jiin da: ―¿Ndoo ka ndoꞌo ini ra siaꞌan? ");
INSERT INTO mpmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Chi na kachi ri ja ruꞌu kuu maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti ndisojniñu ri ja kuankaꞌnu ini ri nuu kuachi yɨvɨ naa i. Vijna ti na stuu ri ɨɨn jniñu saꞌa ri jaꞌa ―ni kachi ya. Yukan na ti ni kachi ya jiin chaa tɨkuku un: ");
INSERT INTO mpmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ndokunɨ, nastuu yúú ra, ti kuanoꞌon veꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti chaa un ni kiꞌin da yúú da, ti ni kee da kuaꞌan da. So ni ka naa ini yɨvɨ un, ti ni kuvaa i ni ka nakanajaa i Yandios: ―¡Kaꞌnu ɨɨn jniñu saꞌa Yandios ja tu ka jini kuɨtɨ yo ɨɨn jnuꞌun siaꞌan undi vijna! ―kachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yukan na ti kuaꞌan tuku Jesús yuꞌu lago Galilea, ti ni ka taka kuaꞌa xaan yɨvɨ nuu ya. Ti ni xnaꞌan ya nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ichi kuaꞌan ya ni yaꞌa ya yajni ɨɨn oficina nuu kinyaꞌu puesto. Yukan nukoo Leví, seꞌe yɨɨ Alfeo, kinyaꞌu da puesto. Ti ni kachi Jesús jiin da: ―Ñaꞌan na choꞌo, ti kundikun ra ruꞌu ―kachi ya. Ti ni ndokuɨñɨ Leví, ti kuaꞌan da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ɨɨn kɨvɨ ni kana Leví Jesús ja na kiꞌin ya veꞌe da ja na kee ya staa jiin chaa ka skuaꞌa jiin ya, jiin chaa ka kinyaꞌu puesto, jiin chaa tu ka siuku jnuꞌun ka kaꞌan chaa ka xnaꞌan ini veñuꞌun Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ti yukan kaꞌiin chaa ka kuu maestro ja ka xnaꞌan ley, ka kuu da maa chaa fariseo. Nu ni ka jini da ja yee Jesús staa jiin taka yɨvɨ un, ti ni ka kachi da jiin chaa ka skuaꞌa jiin ya: ―¿Ndoo yee Jesús staa jiin taka chaa ka kinyaꞌu puesto, suni jiin chaa tu ka siuku jnuꞌun ka kaꞌan ri yukan? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ni jinisoꞌo Jesús jnuꞌun ka kaꞌan da, ti ni kachi ya jiin da: ―Chaa kuꞌu kuu chaa nandɨꞌɨ ɨɨn médico, ansu chaa iyo ndendajnu. Ruꞌu ni chaa ri ja kaꞌan ri jnuꞌun Yandios nuu yɨvɨ ka nakuni i kuachi i, ti ansu yɨvɨ ka ndoꞌo ini ja ka iyo ndoo jiin kuachi i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ni kuu ja ni jaa ɨɨn kɨvɨ ka iyo ndicha ini taka chaa fariseo jiin chaa ka skuaꞌa jiin Juan, chaa skuanducha. Ti sava yɨvɨ un ni ka chakoyo i nuu Jesús, ti ni ka jikajnuꞌun i ya: ―¿Ndoo chaa ka skuaꞌa jiin Juan jiin chaa ka skuaꞌa jiin chaa fariseo, ka iyo ndicha ini da, ti chaa ka skuaꞌa jiin ni, ndoo tu ka iyo ndicha ini da nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ti ni kachi Jesús: ―¿Ti kuu koo ndicha ini yɨvɨ kaꞌiin ɨɨn viko nandaꞌa xi tuu nu? Ti nu kancha novio un jiin i, tu kuu kuꞌiin ndicha i viko un. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Suni nu kancha ri jiin chaa ka skuaꞌa jiin ri, tu kuu koo ndicha ini da. Ko jaa ɨɨn kɨvɨ nu na kuxio ri kiꞌin ri, ti kɨvɨ un sa na koo ndicha ini da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Siaꞌan kuu ja tu kuu chajnaꞌan ra jnuꞌun xnaꞌan ri jiin jnuꞌun janaꞌan. Ɨɨn ni kuu ja nachaa yo ɨɨn pedazo saꞌma jaa, ti ndundoo ga nuu ɨɨn saꞌma tuꞌu. Chi saꞌma jaa un ndɨyɨ, ti kuu kaꞌnu ga yau nuu saꞌma tuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɨɨn ni kuu ja chuꞌun yo vino jaa ini ñɨɨ tuꞌu, chi vino jaa un ndata ti kaꞌncha ñɨɨ un, ti xnaa yo ndɨnduu. Vanuxia siaꞌan ja chuꞌun yo vino jaa chii ñɨɨ jaa. Yukan kuu ja tu kuu chajnaꞌan ra jnuꞌun ri jiin jnuꞌun janaꞌan―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɨɨn kɨvɨ ndetatu ni yaꞌa Jesús jiin chaa ka skuaꞌa jiin ya, ti ni ka yaꞌa da ɨɨn ñuꞌun nuu kaa triu. Ti chaa un ni ka kejaꞌa ka jnuꞌun da yoko triu un, ti ka yaji da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ni ka jini chaa fariseo un jniñu ka saꞌa chaa un, ti ni ka kachi da jiin Jesús: ―Ndeꞌe, ¿ndoo ka saꞌa chaa ka jika jiin ra jniñu ja tu kuu saꞌa yo ɨɨn kɨvɨ ndetatu nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ti ni kachi Jesús jiin da: ―¿Ndoo ka kaꞌan ra siaꞌan, xi tu ni ka kaꞌu ra ja ni jnaꞌan tata yo David na janaꞌan, na ni jiꞌi da soko jiin chaa ni kunchuku jiin da un nu? ");
INSERT INTO mpmNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ni kɨvɨ da ini veꞌe Yandios, ni jikantaꞌu da nuu sutu Abiatar, ti ni kiꞌin da staa stila ni soko sutu un nuu Yandios. Ni yee da jiin chaa ni kunchuku jiin da, ja tu kuu kaji savaꞌni ga yɨvɨ, ti xnaꞌan ley Moisés ja nɨnɨ sutu kuñaꞌnu kuu, ja kaji staa stila un. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nusa ti iyo vaꞌa jniñu ka saꞌa chaa vekoyo jiin ri. Chi ni saꞌa Yandios kɨvɨ ndetatu un ja na kendo kuu ɨɨn kɨvɨ saꞌa yo ja vaꞌa, ti ansu ja na saꞌa yo ja ii xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vanuxia ruꞌu kuu maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti kuñaꞌnu ga ri ja na taꞌu ri jniñu nasa saꞌa yɨvɨ kɨvɨ ndetatu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ni kɨvɨ tuku Jesús ini ɨɨn veñuꞌun yɨvɨ Israel, ti yukan kande ɨɨn chaa ni ichi ndaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Suni yukan kanchuku chaa fariseo ka iyo listo da ja nu saꞌa Jesús tajna kɨvɨ ndetatu un. Ti nu na saꞌa ya tajna, ka ndoꞌo ini da ja kankuachi da jaꞌa ya ja janiꞌin ini ya nuu ley. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ko ni kachi Jesús jiin chaa kuꞌu un: ―Ndokuñɨ, ti kundichi ra maꞌñu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yukan ti ni jikajnuꞌun ya yɨvɨ un: ―¿Nasa kachi ley ndoo saꞌa yo vijna kɨvɨ ndetatu nusa? ¿Iyo vaꞌa ja saꞌa yo tajna ɨɨn chaa kuꞌu xi kuaꞌa ini yo na kuū da nu? ―kachi ya. Ti chaa un tu ni ka kaꞌan kuɨtɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yukan ni kɨtɨ ini Jesús ni ndeꞌe ya nuu da, ti ni kukuiꞌya xaan ini ya, chi ni jini ya ja tu ka ñuꞌun ndaꞌu kɨtɨ ini da. Ti ni kaꞌan ya jiin chaa kuꞌu un: ―Skaa ndaꞌa ra ―kachi ya. Ni skaa da ndaꞌa da. Ti luego ni, ni nduvaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yukan ti ni ka kekoyo chaa fariseo un, ka saꞌa da ɨɨn junta jiin chaa ka yɨꞌɨ i jiin partido Herodes. Ka ndajnuꞌun da nasa kuu kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Kuaꞌan Jesús ichi yuꞌu lago Galilea jiin taka chaa ka skuaꞌa jiin ya. Ti ka ndikun yɨvɨ kuaꞌa un kuankoyo i suni, chi ni ka jini i taka jniñu ñaꞌnu saꞌa ya. Ni kikoyo yɨvɨ kuaꞌa taka ñuu nanu ñuu Galilea, ñuu Jerusalén, ñuu Idumea. Suni yɨvɨ kanchuku ɨnga yuꞌu yucha Jordán, jiin suni yɨvɨ ñuu Tiro jiin Sidón. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ti saꞌa ya tajna taka yɨvɨ ka kuꞌu ni ka chakoyo un, ko so ka chindajnaꞌan maa ni ga yɨvɨ un ja ka kuni tuꞌva i nuu ya, ti jnɨɨ i vasu tɨꞌlɨ saꞌma ya, ja nduvaꞌa i jiin savaꞌa ni ga kueꞌe ka ndoꞌo i. Ko ja xaan chitu yɨvɨ un, ti ni kachi ya jiin chaa ka skuaꞌa jiin ya ja na satuꞌva da ɨɨn barco lulu, na kinkɨvɨ ya nava tu kaxin yɨvɨ un ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Suni ni kikoyo kuaꞌa yɨvɨ ka jnaꞌan tachi xaan. Nu ni ka jini nuu ya, ti ni ka nduva nuu jaꞌa ya. Ti ni ka kanajiin: ―¡Roꞌo kuu Seꞌe Yandios! ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko maa ya ni kaꞌan niꞌin ya: ―Tu nau ja kuu roꞌo ja kaꞌan ra ja ruꞌu kuu Seꞌe Yandios ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Yukan ti ni kana ya taka chaa ka skuaꞌa jiin ya, ti kuaꞌan ya jiin da undi yuku un. Yukan ni nakaji ya uxi uu ndajaꞌa ja na nakujin da jiin ya. Ti ni kachi ya jiin chaa un naa da ja na taji ya da kinkoyo da taka ñuu, ti kaꞌan da jnuꞌun Yandios nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ti kundiso da jniñu ñaꞌnu ja kenchaa da tachi xaan ka jnaꞌan sava yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ti jaꞌa ka kuu ndɨ uxi uu chaa ni nakaji ya: Simón ja ni skonani ya da Pedro; ");
INSERT INTO mpmNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo jiin Juan, seꞌe yɨɨ Zebedeo, ja suni ni skonani ya da naa da Boanerges, ja kuni kaꞌan seꞌe taja; ");
INSERT INTO mpmNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés; Felipe; Bartolomé; Mateo; Tomás; Jacobo, seꞌe yɨɨ Alfeo; Tadeo; Simón, ja yɨꞌɨ da nuu partido cananista; ");
INSERT INTO mpmNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jiin Judas, chaa ñuu Cariote, chaa ni nakuaꞌa Jesús nuu chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nu ni niꞌin ya chaa kujin jiin ya, ti ni nandeokuñɨ ya jiin da naa da ɨɨn veꞌe. Ti yachi ni kataka tuku yɨvɨ kuaꞌa veꞌe un, ja tu ka jaꞌa i jnuꞌun ja kaji ya staa jiin ndajaꞌa ya, chi ka jikantaꞌu i ja na chindee ya maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nu ni ka jini taka jnaꞌan ya jnuꞌun ja saꞌa ya taka nuu jniñu un, ti kuan nukiꞌin da ya, chi ni ka ndoꞌo ini da ja ni nduu kuꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ti suni chaa ka xnaꞌan ley ini veñuꞌun yɨvɨ Israel ja vekoyo da undi ñuu Jerusalén, ni ka kachi da: ―Yɨꞌɨ chaa jaꞌa jiin maa jaꞌuꞌu un. Yukan kuu ja jiin sɨvɨ maa jaꞌuꞌu un keniꞌin da tachi xaan un nuu yɨvɨ ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yukan ti ni kachi Jesús: ―Kunsoꞌo naa ra na kaꞌan ri. ¿Va nu kuu keniꞌin chaa uꞌu un tachi xaan kiꞌin ti nu ndajaꞌa da ka kuu nu? ");
INSERT INTO mpmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Suni nu ndajaꞌa ɨɨn gobierno, na kusɨɨn ini da naa da ti kejaꞌa kanaa da, ti gobierno un tu kuñɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ti nu ɨɨn familia kejaꞌa kanaa naa, ti familia un tu kuu kunchuku mani. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Suni siaꞌan kuu jiin chaa uꞌu un. ¿Xi ka jani ini ra ja na kuñɨɨ da nu na keniꞌin da tachi xaan un kiꞌin, nusa? ");
INSERT INTO mpmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ko ja sɨkɨ maa chaa uꞌu un, saꞌa yo nanu ja ɨɨn ni kuu nu ɨɨn chaa niꞌin xaan, kuni sakuiꞌna yo veꞌe da, ti nu kancha da, ti xnakan kuꞌni yo da, sa sakuiꞌna yo veꞌe da. Ɨɨn ni kuu ja ni kundee ri jiin chaa uꞌu un, chi ni keniꞌin ri ndajaꞌa da un kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jandaa na kachi ri ja iyo jnukaꞌnu ini Yandios nuu yɨvɨ ka saꞌa taka nuu kuachi. Suni yɨvɨ ka kaꞌan ndevaꞌa, vatu ni sakaꞌnu ini Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko yɨvɨ na kusɨkɨnchaa maa Espíritu Santo jiin jnuꞌun ndevaꞌa kuɨtɨ, jankɨvɨ sakaꞌnu ini Yandios nuu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Siaꞌan ni kaꞌan Jesús, chi chaa ka xnaꞌan ini veñuꞌun Israel ni ka kaꞌan ja ja ni nduu uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ti yukan ni chaa nana ya jiin ñani ya, ti ni ka kendo ña fuera. Yukan ni tatu ña ɨɨn yɨvɨ ni kaxnuꞌun nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ti yɨvɨ kanchuku jiin ya ni ka kachi: ―Nana ni jiin ñani ni ka kaꞌiin da fuera. Ka kuni kaꞌan da jiin ni ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ti ni kachi ya: ―Na kachi ri nuu ra naa ra nau ja kuu nana ri, ti nau ja ka kuu ñani ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ti ni ndeꞌe ya nuu taka yɨvɨ kanchuku jiin ya yukan, ti ni kachi ya: ―Jaꞌa kanchuku yɨvɨ ka kuu nana ri jiin ñani ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Chi savaꞌni ga yɨvɨ na siuku jnuꞌun Yandios, yukan kuu nana ri, kuu kuaꞌa ri, ti kuu ñani ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɨnga kɨvɨ ni kejaꞌa xnaꞌan Jesús nuu yɨvɨ yuꞌu lago Galilea. Nu ni ka taka kuaꞌa xaan tonto yɨvɨ nuu kande ya, ni kɨvɨ ya nuu ɨɨn barco kaꞌnu, ti ni kuxio ya tɨꞌlɨ nuu nducha un. Ti yɨvɨ un ni ka kendo i nuu ñɨtɨ yuꞌu nducha un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ni nukoo ya nuu barco un ti ni xndaku ya nuu yɨvɨ naa i, ti jnuꞌun ni xndaku ya kuu jaꞌa: ");
INSERT INTO mpmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Chunsoꞌo naa ra na kachi ri jnuꞌun ɨɨn chaa ni saka triu. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ti nuu kuaꞌan da jacha da triu, sava triu un ni nukoyo ini ichi. Ti ni chakoyo saa ni ka nachii tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Uu ga triu un ni nukoyo nuu kanchuku yaxin ñuꞌun nuu yuu ti ni kaña yachi, ko tu ni kee kunu yoꞌo i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ko nu ni kaña ndikandii, ti ni ichi triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Uu ga ni nukoyo nuu yɨꞌɨ kuaꞌa yoꞌo nuꞌiñu, ti ni kaña triu un, ko nu ni nakuaꞌnu numa nuꞌiñu un ti tukaa ni jaꞌnu triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko sava ga triu ni nukoyo nuu yɨꞌɨ kokon ñuꞌun, ni kaña ti vaꞌa ni jaꞌnu, ti ni kuu xaan. Sava ni nakuaꞌa oko uxi triu ja ɨɨn triu lulu un, ti sava ni nakuaꞌa uni xiko, ti uu ga ni nakuaꞌa ɨɨn ciento ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yukan ti ni kachi Jesús: ―Yɨvɨ chunsoꞌo ti na chunsoꞌo i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti nu kuankoyo yɨvɨ un, ti ni ka tuꞌva ndɨ uxi uu chaa ka kuu ndajaꞌa ya jiin uu ga yɨvɨ ni ka kendo un, ti ni ka jikajnuꞌun da ya nasa kuni kaꞌan jnuꞌun ni xndaku ya un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti ni kachi ya: ―Ja ni xnaꞌan Yandios nuu ra naa ra nava taꞌu ya jniñu, ko ja kuu yɨvɨ tu kandixia, na xndaku ri nuu i jiin jnuꞌun jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chi vasu ñusoꞌo i jnuꞌun kaꞌan ri, ti ndeꞌe i jniñu saꞌa ri, ko tu chaku ini i. Tu chaku ini i chi tu kuni xndoo i jnuꞌun kueꞌe ka kaꞌan i. Ti nu tu kuni nakani ini i nuu kuachi i, ti tu sakaꞌnu ini Yandios nuu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Suni ni kachi ya jiin da: ―Ti nu tu ni ka chaku ini ra jnuꞌun ni kaꞌan ri un, ni tu kuu chaku ini ra uu ga jnuꞌun na kaꞌan ri nusa. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kaꞌan ri ja nanu kuu ɨɨn chaa saka triu, suni siaꞌan kuu chaa xndaku jnuꞌun Yandios nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chi sava yɨvɨ kuu i nanu triu ni nukoyo ini ichi un, chi ni ka ñusoꞌo i jnuꞌun Yandios, ti jaku ni kɨvɨ ti ni kundee jaꞌuꞌu un jiin i, ti naa ini i jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Uu ga yɨvɨ kuu i nanu triu ni nukoyo nuu kanchuku yaxin ñuꞌun nuu yuu. Chi ka ñusoꞌo i jnuꞌun Yandios, ti kusɨɨ xaan ini i jiin. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ko tu kukutu jnuꞌun Yandios ini i, ti yachi ka nandeokava i sɨkɨ ya, nuu ka jnaꞌan i nundoꞌo sɨkɨ ja ka jito uꞌu yɨvɨ maa i, ja ni ka kandixia i jnuꞌun ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ti uu ga yɨvɨ kuu i nanu triu ni nukoyo nuu iñu un. Chi ka ñusoꞌo i jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ko ka ndoꞌo xaan ini i jniñu iyo nuu ñuyɨvɨ jaꞌa, ja ñukuu ini i kuu riko i. Ti taka yukan saꞌa ja jasɨ ini yɨvɨ un, ti naa ini i jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ti sava ga yɨvɨ un kuu i nanu triu ni nukoyo nuu yɨꞌɨ ñuꞌun vaꞌa. Ni jinisoꞌo i jnuꞌun Yandios, ti ni kandixia ndaa kuɨtɨ i. Kuu i nanu ɨɨn triu ja ni nakuaꞌa oko uxi, xi uni xiko, xi ɨɨn ciento triu, chi siuku ndaa i jnuꞌun Yandios. Yukan kuu ja kuni kaꞌan jnuꞌun chaa saka triu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ti ni kachi tuku ya jiin da: ―Nu skuikun yo ɨɨn yɨtɨ, ti tu kani yo chii ɨɨn cajón, ni tu kani yo chii ɨɨn jito. Chi suꞌva kani yo nuu sukun ja na kundijin vaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Suni siaꞌan kuu jiin jniñu kuaꞌa ri nuu ra naa ra, chi tu kendo saꞌyɨ. Vasu vijna ñuꞌni tu jini ni ɨɨn yɨvɨ, ko jaa ɨɨn kɨvɨ nu kenda ndijin ti kuni kuaꞌa yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yɨvɨ ñusoꞌo ti na chunsoꞌo i nasa kuni kaꞌan jnuꞌun jaꞌa ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Suni ni kachi ya jiin da: ―Chunsoꞌo vaꞌa jnuꞌun kaꞌan ri. Nu jiin kuꞌva un chikuaꞌa ra, ti suni siaꞌan jiin kuꞌva un nachikuaꞌa Yandios nuu ra. Ti viꞌga kuaꞌa ya nuu ra nu na chunsoꞌo ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Chi yɨvɨ ni chunsoꞌo ti chindee Yandios maa i ja na niꞌin ga i inijnuni i. Ko yɨvɨ tu chunsoꞌo vaꞌa, suꞌva kenchaa ya jnuꞌun vaꞌa ni kendo inijnuni i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ti ni kaꞌan ga Jesús jiin da naa da: ―Kaꞌan ri ɨɨn jnuꞌun nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. Ti yukan kuu nanu triu ni saka nuu ñuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chi nu ni ndɨꞌɨ ni saka da triu un, ti sɨɨn sɨɨn jniñu saꞌa da taka kɨvɨ. Ti nu ni kuu una uxi kɨvɨ, ti kejaꞌa jinu, ti jaꞌnu kuaꞌan, vasu tu jini da nasa jaꞌnu triu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Chi maa ñuꞌun un saꞌa ja jaꞌnu. Xnakan jinu ti kejaꞌa jaꞌnu. Yukan na ti kaña yoko ti jakɨꞌɨ triu chii. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti nu ja ni kuaan triu un, kiꞌin da vusu, ti kin kaꞌncha da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Siin Jesús kaꞌan ya ti ni kachi ya: ―Kaꞌan ri ɨnga jnuꞌun nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Kuu nanu ɨɨn ndɨkɨn lulu xaan, ko nu ni xndee yo ti kejaꞌa jaꞌnu. Jaꞌnu nanu ɨɨn nuyukun, ti undi saa un ka saꞌa tɨ taka tɨ chii ndaꞌa yujnu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Taka jnuꞌun yukan ni jajniñu Jesús nu ni xndaku ya jnuꞌun Yandios nuu yɨvɨ naa i, ja na kendoꞌo ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ti mani siaꞌan ni xnaꞌan ya nuu yɨvɨ naa i. Ko nu ni ka kendo maa ni ga ndajaꞌa ya, ti ni xndaku ya nasa kuni kaꞌan taka jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yukan ti jaꞌini kɨvɨ un ni kachi Jesús jiin ndajaꞌa ya: ―Choꞌo naa yo ɨnga yuꞌu lago ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yukan ti ni ka kɨvɨ da ini barco nuu kande ya. Ni ka kanxiaꞌu da jiin yɨvɨ un ti ni ka jika da jiin barco un nuu lago. Suni kuankoyo uu ga barco jiin da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ti ni kejaꞌa ɨɨn tachi sau xaan tonto nuu lago un. Ti ni kejaꞌa kɨvɨ nducha ini barco da, ti kuni chitu jiin nducha. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ko Jesús kixi kixi ni ya ichi jata barco. Ti ni ka xndoto chaa un ya, ti ni kachi da: ―Maestro, tu ndɨꞌɨ ini ni ja kuni kekaꞌnu yo chii nducha, ti xaan kixi kixi ni ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yukan ni ndokuɨñɨ Jesús, ti ni kachi ya jiin tachi sau xaan un jiin lago un: ―Jakuñɨ ti naꞌin ni koo ra ―ni kachi ya. Yukan ti naꞌin kuɨtɨ ni ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yukan ti ni kachi ya jiin ndajaꞌa ya: ―¿Ndoo xaan ka yuꞌu ra? ¿Xi kaja ni ini ra ja tu kuu chindee Yandios roꞌo naa ra nu? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ti ndajaꞌa ya un ni ka yuꞌu xaan da, ti ka ndajnuꞌun da naa da: ―¿Nusa ti naa chaa kuu chaa jaꞌa ja undi tachi sau un jiin mar un ka jandatu i nuu da? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yukan ti ni ka jakoyo da ɨnga yuꞌu lago, ñuu Gadara. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Nu ni kee Jesús ini barco, ni kenda ɨɨn chaa jnaꞌan tachi xaan. Ti chaa un nchaa da taka nuu ka ñunduji ndɨyɨ. Ni nduu loco xaan da, chi ni ɨɨn yɨvɨ tu kundee jiin da vasu na kundikun da jiin cadena. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tɨjnɨ xaan jinu ni ka juꞌni da chaa un jiin cadena, kuu ndaꞌa da kuu sɨꞌɨn da, ko kundee da jaꞌncha da, ti sakuachi da cadena un. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kuu nduu kuu ñuu kanajiin da yaku da chii yuku un jiin taka nuu ñaña ndɨyɨ, ti stuji da maa da jiin yuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ko nu ni jito nchaa jika da ja vaji Jesús, ni jaꞌa da corrɨ, ti kuaꞌan da undi nuu vaji ya. Ni jakunjitɨ da, ");
INSERT INTO mpmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ti ni kanajiin koꞌo da: ―Niꞌin Jesús, Seꞌe Yandios ja kancha undi andɨvɨ, jikantaꞌu xaan tonto na nuu ni ja koto xndɨꞌɨ ni ini na ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Siaꞌan ni kanajiin da, chi ja ni taꞌu ya jniñu ja na xndoo tachi xaan un maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti ni jikajnuꞌun ya sɨvɨ da: ―¿Ndoo nani ra nusa? ―kachi ya jiin da. Ti ni kachi da: ―Legión nani na, chi kuaꞌa xaan jnaꞌan na ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ti kandaꞌu da jiin Jesús ja tu keniꞌin ya tachi xaan un kiꞌin ɨnga ñuu yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ti yajni yukan kaꞌiin kuaꞌa xaan kɨnɨ ka yee tɨ yuku jika yuku un. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ti tachi xaan un ni ka kandaꞌu jiin Jesús: ―Kuaꞌa ni jnuꞌun na kinkoyo na jiin kɨnɨ un naa na ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yukan ti ni jaꞌa ya jnuꞌun ja na kinkoyo. Ti tachi xaan un ni xndoo chaa un ti ni ka jankuncha jnaꞌan jiin kɨnɨ un naa tɨ. Ka iyo yajni uu mil kɨtɨ un. Ti ni ka jaꞌa tɨ corrɨ ni ka nukoyo tɨ ɨɨn xaꞌva, ti ni ka kɨvɨ tɨ nuu lago un ni ka jiꞌi tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ti yɨvɨ ka ndito kɨnɨ un, ni ka yuꞌu xaan. Ni ka jaꞌa corrɨ ni ka kaxnuꞌun nuu yɨvɨ ñuu jiin yɨvɨ kanchuku ranchu. Ti ni ka kikoyo yɨvɨ kuaꞌa ni ka kin ndeꞌe ndoo ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nu ni ka jakoyo yɨvɨ nuu kancha Jesús, ti ni ka jini nuu chaa ni jnaꞌan tachi xaan un, ja ni nduvaꞌa da. Ti ja ñuꞌun da saꞌma kancha da jiin Jesús, ti ni ka yuꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ti yɨvɨ ni ka jini nava ni jnaꞌan chaa un. Suni nava ni kuu jiin kɨnɨ un, ni ka jani da jnuꞌun nuu yɨvɨ ni ka chakoyo un. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ti tendɨꞌɨ yɨvɨ un ni ka kaꞌan jiin Jesús ja na kuxio ya na kiꞌin ya ñuu i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti nu ni ndɨvɨ Jesús ini barco, kandaꞌu chaa ni jnaꞌan tachi xaan un ja na kiꞌin da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko Jesús tu ni jaꞌa ya jnuꞌun, chi ni kachi ya: ―Kuanoꞌon veꞌe ra ti kani ra jnuꞌun nuu taka jnaꞌan ra, suni nuu amigo ra, nava ni chindee Yandios roꞌo ja ni kundaꞌu ini ya maa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yukan ti kuaꞌan chaa un, ti ni jani da jnuꞌun nɨ ñuu Decápolis nava ni saꞌa Jesús jiin da. Ti taka yɨvɨ ni ka jinisoꞌo un, ni ka naa ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nu ni najaa Jesús ɨnga yuꞌu lago un, ni ka kututu tuku yɨvɨ kuaꞌa nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yukan kande ya jiin da naa da. Ti ɨɨn chaa kuñaꞌnu ini ɨɨn veñuꞌun Israel ja nani da Jairo, nu ni jini da Jesús, ni jakunjitɨ da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ti ni kandaꞌu xaan da jiin ya: ―Kuni kuu seꞌe sɨꞌɨ na. Kaꞌan ndaꞌu na jiin favor na choꞌo, ti chuxndee ni ndaꞌa ni sɨkɨ yɨ, na nduvaꞌa i ti na kuchaku i ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ti kuaꞌan Jesús jiin da. Ko kuankoyo kuaꞌa xaan yɨvɨ jiin ya ja undi ka jaxin jnaꞌan i. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maꞌñu yɨvɨ un kuaꞌan ɨɨn ñasɨꞌɨ jnaꞌan kueꞌe nɨñɨ xaan tonto ja ni ndoꞌo ña jiin kueꞌe un uxi uu kuiya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ti ni xnaa ña taka ja ñavaꞌa ña jiin kuaꞌa chaa tajna ja kuni ña nduvaꞌa ña, ko sa suꞌva viꞌga ni kuu kaꞌu ga ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nu ni jinisoꞌo ña taka jniñu ñaꞌnu saꞌa Jesús, ti ni ndoꞌo ini ña: ―Nu na kundee ri kueꞌe ri vasu tɨꞌlɨ saꞌma ya ti va nduvaꞌa ri ―kachi ña. Ja yukan kuu ja vaji ña jiin yɨvɨ un, ni tuꞌva ña ichi jata Jesús, ti ni keꞌe ña saꞌma ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti yachi ni ni jini ña ja ni nduvaꞌa ña, chi ni ichi ni nɨñɨ un maa ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ko ni jini Jesús ja ni saꞌa ya tajna ɨɨn yɨvɨ jiin jniñu ndiso ya. Ni ndeokoto ya nuu yɨvɨ un ti ni jikajnuꞌun ya: ―¿Nau ja ni keꞌe saꞌma ri? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ti ni ka kachi ndajaꞌa ya: ―¿Ndoo jikajnuꞌun ni nau ja ni keꞌe saꞌma ni, ti jini ni ja yɨvɨ kuaꞌa vaji jiin yo? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ko ni ndeꞌe vaꞌa ya yayukan nuu nau ja ni keꞌe saꞌma ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ti ñaꞌan ni keꞌe saꞌma ya un, ni yuꞌu xaan ña chi jini ña ja ni nduvaꞌa ña. Ni jakunjitɨ ña nuu ya ti ni kachi ña taka nundoꞌo ni jnaꞌan ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ti ni kachi Jesús jiin ña: ―Hija, ni nudvaꞌa ra chi ni kandixia ra ruꞌu, ja kuu saꞌa ri tajna maa ra. Koo sɨɨ ini, ti tukaa kondoꞌo ra kueꞌe un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ko ni kaꞌan ga ya siaꞌan jiin ñaꞌan un, ja ni ka chakoyo yɨvɨ kaꞌiin veꞌe Jairo, ti ni kachi jiin da: ―Ja ni jiꞌi sesɨꞌɨ ni. Tukaa ndoo saꞌa ni ja kiꞌin ni jiin maestro ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ko ni jinisoꞌo ya ja siaꞌan ka kaꞌan da jiin Jairo. Ti tu ni kiꞌin ya jnuꞌun un, chi ni kachi ya: ―Koto yuꞌu ra. Kandixia ti ni kuu ni ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yukan ti kuaꞌan ya jiin Jairo, ko tu ni jaꞌa ya jnuꞌun ja kinkoyo yɨvɨ kuaꞌa un, chi nɨnɨ Pedro, Santiago jiin Juan, chaa kuu ñani Santiago ni kuankoyo. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nu ni jaa ya veꞌe chaa kuñaꞌnu un ni jini ya ja ka ndeꞌe xaan yɨvɨ kaꞌiin un, ja undi ka kanajiin koꞌo i ti ka ndɨꞌɨ ini i. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ni kɨvɨ Jesús ti ni kachi ya: ―Ndoo xaan ka kuvaa ra ka ndeꞌe ra ti suchi un tu ni jiꞌi yɨ, chi kixi yɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ko so ni ka jaku yɨvɨ un ja siaꞌan ni kaꞌan ya, chi ni ka jini ja ni jiꞌi ndixia suchi un. Ko ni keniꞌin ya tendɨꞌɨ kɨtɨ yɨvɨ un kuankoyo ichi fuera. Ti ni tuꞌva ya nuu katuu suchi un jiin tata i jiin nana i jiin ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ni jnɨɨ ya ndaꞌa yɨ ti ni kaꞌan ya: ―Talita kumi, (kachi ya, ja kuni kaꞌan: ndoko, suchi lulu.) ");
INSERT INTO mpmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti suchi un ja iyo uxi uu kuiya i, ni ndoko i ti ni jika i. Tata i, nana i jiin ndajaꞌa ya, so ni ka naa ini da, ti ka yuꞌu xaan da ja ni nandoto suchi lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yukan ti niꞌin xaan ni taꞌu ya jniñu ja koto kani kɨtɨ da jnuꞌun nuu ni ɨɨn yɨvɨ ja siaꞌan ni kuu. Ti ni kachi ya: ―Kuaꞌa staa na kaji yɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yukan ti kuanoꞌon Jesús ñuu Nazaret nuu ni jaꞌnu ya, ti kuankoyo ndajaꞌa ya suni. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ti ɨɨn kɨvɨ ndetatu ni kɨvɨ ya ini veñuꞌun un, ti ni xnaꞌan ya nuu yɨvɨ un. Kuaꞌa xaan yɨvɨ ni ka ñusoꞌo jnuꞌun ni kaꞌan ya, ja so ni ka naa ini, ti ka kaꞌan: ―¿Nanu ni niꞌin chaa jaꞌa jnuꞌun kaꞌan da un? ¿Nanu ni kutuꞌva da jniñu un ja undi jniñu ñaꞌnu kuu saꞌa da? ");
INSERT INTO mpmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ti ansu jaꞌa kuu chaa ni tuji yujnu, seꞌe yɨɨ María, ja kuu ñani Jacobo, José, Judas, jiin Simón nu? Ti jaꞌa kanchuku kuaꞌa da jiin yo naa yo ―kachi naa. Siaꞌan ni ka jini yɨvɨ un maa ya nanu ɨɨn chaa ndevaꞌa ni. Ja yukan kuu ja tu ni ka ndeꞌe nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ko ni kachi Jesús: ―Savaꞌa ni ga ɨnga ñuu ka jaꞌa yɨvɨ ja yɨñuꞌun nuu ɨɨn profeta, ja kaꞌan jnuꞌun Yandios. Ti ansu maa yɨvɨ ñuu da, ni ɨɨn jnaꞌan da, ti ni familia ini veꞌe da, tu kuantaꞌu i maa da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ti tu ni kuu saꞌa ya kuaꞌa jniñu ñaꞌnu yukan. Chi jaku ni yɨvɨ kuꞌu ni saꞌa ya tajna. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","So ni kukuiꞌya ini ya, chi tu ni ka kandixia yɨvɨ un jniñu saꞌa ya. Yukan ti kuaꞌan ya ni jikonuu ya taka ñuu kuachi kendo yajni un, ni xnaꞌan ya jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yukan na, ti ni kana ya ndɨ uxi uu ndajaꞌa un. Ti ni taꞌu ya jniñu nuu ndɨ uu ndɨ uu da, ti ni kachi ya: ―Kuankoyo naa ra ti kaꞌan ra jnuꞌun Yandios, ti kundiso ra jniñu ñaꞌnu ja keniꞌin ra tachi xaan un kinkoyo. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ko tundo kundaꞌa ra ja kuu ichi, ni ñunu staa, ni xuꞌun, chi nɨnɨ ɨɨn yujnu xii kuu ja kɨtuu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Suni ni kachi ya ja na kɨꞌɨ da ndijña ndaꞌu, ti ɨɨn ni saꞌma na kuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ti ni kachi ya jiin da: ―Nu ni ka jakoyo ra ɨɨn veꞌe, kendo ra naa ra un, undi nu kuankoyo ra ɨnga ñuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ti nu ni jakoyo ra ɨɨn ñuu, ti nu tu ka chunsoꞌo yɨvɨ un jnuꞌun ka kaꞌan ra, kɨsɨ tɨkacha ini jaꞌa ra, na kuu ɨɨn seña ja ni ka kendo kuiꞌya i ja tu ni ka jantaꞌu i roꞌo naa ra, ti kuankoyo ɨnga ñuu. Chi jandaa na kachi ri ja kɨvɨ na chaa juicio, ti viꞌga koo ndoꞌo yɨvɨ un nu tu kuantaꞌu i jnuꞌun kaꞌan ra, ti ansu ñuu Sodoma jiin Gomorra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yukan ti kuankoyo ndajaꞌa ya, ni ka jikonuu da taka ñuu, ni ka xndaku da nuu yɨvɨ ja na nakani ini i nuu kuachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tɨjnɨ jinu ni ka keniꞌin da tachi xaan ka jnaꞌan sava yɨvɨ. Suni ni ka saꞌa da tajna tɨjnɨ yɨvɨ ka kuꞌu, ja ni ka jaka da aceite olivo xini i, ti ni ka nduvaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ni iyo ɨɨn rey nani Herodes, ɨɨn chaa ni yɨndaꞌa nɨ ñuu Galilea. Ti Herodes ni niꞌin da jnuꞌun ja nɨ ñuu ka kaꞌan sɨkɨ jniñu ñaꞌnu xaan saꞌa Jesús. Ti sava yɨvɨ un ka kaꞌan: ―Juan ja ni skuanducha un kuu, chi ni nandoto. Yukan kuu ja kuu saꞌa jniñu ñaꞌnu un ―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ti uu ga ka kaꞌan: ―Profeta Elías ja ni kii na janaꞌan un kuu da ―kachi naa. Ti sava ga yɨvɨ un ka kaꞌan: ―Ɨɨn profeta kuu, ɨɨn ni kuu jiin chaa ni ka kaꞌan jnuꞌun Yandios na janaꞌan―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko ni kachi rey Herodes: ―Juan ja ni skuanducha un kuu. Ni nandoto vasu ni kenchaa ri xini ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Rey Herodes ni jisonchaa da Herodías, ñasɨꞌɨ ñani da Felipe. Ti Juan ni kachi jiin Herodes ja tu vaꞌa ja kuncha da jiin ñasɨꞌɨ ñani da. Ti ñaꞌan un ni kɨtɨ xaan ini ña nuu Juan ja siaꞌan ni kaꞌan da, undi ni kundee ña ni juꞌni Herodes Juan jiin cadena, ti ni chondee da chaa vekaa, chi kuni ña ja na kuū da. Ko Herodes ni nama da Juan, chi jini da ja ɨɨn chaa vaꞌa kuu Juan. Jajnaꞌan ini da jnuꞌun kaꞌan Juan, vasu tu chaku vaꞌa ini da jnuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ti kuu nava ni ndoꞌo ini Herodías. Kɨvɨ ni kusɨɨ ini Herodes ni nasaꞌa da viko kɨvɨ ni kaku da. Ni jaꞌa da ɨɨn ja kuxini nuu taka chaa ka kuñaꞌnu jiin da jiin chaa ka kuu generál, suni jiin chaa ñaꞌnu ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti ni kanchuku da ka kuxini da, ni kɨvɨ seꞌe sɨꞌɨ Herodías. Ni jitajaꞌa ña nuu kanchuku Herodes jiin taka chaa ka kuñaꞌnu un. Ti Herodes jiin chaa ka kuñaꞌnu un ni ka kusɨɨ ini da ja ni jitajaꞌa ñaꞌan un. Ti ni kachi Herodes jiin ña: ―Kakan nuu ri savaꞌni ga ndoo kuni ra, ti na kuaꞌa ri ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ni kachi Herodes ja siuku da kuaꞌa da savaꞌni ga ndoo na kakan ña, vasu sava ñuu nuu taꞌu da jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ti ñaꞌan un tu ni kaꞌan ña, ti ni kenda ña ni jikajnuꞌun ña nana ña, ti ni kachi ña: ―¿Ndoo kakan na nuu da? ―kachi ña. Ti ni kachi Herodías: ―Kakan xini Juan, chaa skuanducha un ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ni nandeokuñɨ ñaꞌan lulu un, ti ni kachi ña jiin rey un: ―Vijna na ti kuni na ja na taꞌu ni jniñu na kin kiꞌin da xini Juan, chaa skuanducha un. Na kii nuu na nuu ɨɨn koꞌo xita ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nu ni jinisoꞌo rey un ja siaꞌan ni kaꞌan ña, ni kukuiꞌya xaan ini da. Ko vanuxia ni ka jinisoꞌo chaa kanchuku jiin da un. Ti ni siuku da jnuꞌun ni kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ti ni taji da soldado ndito yuxeꞌe un kuaꞌan da ini vekaa un. Ni kenchaa da xini Juan. Ti ni nandeokuñɨ da jiin xini da un nuu ɨɨn koꞌo xita. Ti Herodes ni nakuaꞌa da nuu ñaꞌan lulu un, ti ñaꞌan lulu un ni nakuaꞌa ña nuu nana ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nu ni ka jini chaa ka skuaꞌa jiin Juan ja siaꞌan ni kuu, ni ka janukiꞌin da yɨkɨ kuñu ndɨyɨ un, ti ni ka chunduji da. Siaꞌan ni ka jaꞌni da Juan, chaa skuanducha. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nu ni ka nchakoyo ndajaꞌa un, ti ni ka jani da jnuꞌun taka jniñu ni ka saꞌa da jiin ja ni ka xnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ti kɨvɨ un kuaꞌan vaji yɨvɨ kuaꞌa nuu kancha Jesús, ja tu ni kuu kaji da staa naa da. Ti ni kachi ya: ―Na choꞌo naa yo undi nuu kuu ndetatu ra naa ra tɨꞌlɨ ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ni ka kɨvɨ da nuu ɨɨn barco, ti ni ka jika da kuaꞌa da naa da nuu iyo vaꞌa, nuu ni kaꞌiin maa da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko sava yɨvɨ ni ka jini nuu ni kee barco un kuaꞌan, ni ka nakuni. Ti ni ka kututu kuaꞌa xaan yɨvɨ taka ñuu kendo yajni un. Ni ka jika i nɨ yuꞌu mar un, ti xnakan i ni ka jakoyo, sa ni jaa barco un jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nu ni kee ya ini barco un, ni jini ya ja kaꞌiin kuaꞌa xaan yɨvɨ. Ti ni kundaꞌu xaan ini ya maa i. Chi kaꞌiin yɨ nanu rɨɨ tu jitoꞌo. Ti yukan ni kundee ya nchaka ni xndaku ya jnuꞌun Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nu kuan ini, ti ni ka kachi ndajaꞌa ya: ―Ja kuan kɨꞌvɨ ti jaꞌa tundo iyo. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Na taji ni taka yɨvɨ jaꞌa na nukoyo i taka ranchu jiin taka ñuu kendo yajni jaꞌa, ti na kuaan i staa kuxini i ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko ni kachi Jesús: ―Kuaꞌa maa ra naa ra staa na kee i ―kachi ya. Ti ni ka kachi tuku ndajaꞌa un: ―Saꞌa yo jniñu ɨɨn kuiya sa niꞌin yo xuꞌun ja kuaan kuaꞌa yo staa stila ja kuu yɨvɨ jaꞌa. ¿Kuni ni ja xnaa yo xuꞌun nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ti ni kachi tuku ya: ―Kuandeꞌe naa ra nasa staa stila ka ñavaꞌa yɨvɨ jaꞌa―kachi ya. Ka jandeꞌe da, ti ni ka nandeokuñɨ da nuu ya: ―Iyo uꞌun staa stila jiin uu chāká ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti ni kachi ya jiin ndajaꞌa ya: ―Kachi jini yɨvɨ ja na nukoo yukun i nuu icha un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ti ni ka nukoo i uu xiko uxi xi ɨɨn ciento i ɨɨn ɨɨn yukun. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yukan ti ni kiꞌin Jesús ndɨ uꞌun staa stila un jiin uu chāká un. Ni ndakoto ya andɨvɨ. Ni nakuantaꞌu ya nuu Yandios. Ti ni kiꞌin ya ndɨ uꞌun staa stila un, ni sakuachi ya, ni jaꞌa ya nuu ndajaꞌa ya ja na tejnaꞌan da nuu yɨvɨ un naa i. Suni ni sakuachi ya ndɨ uu chāká un, ti ni tejnaꞌan ya nuu yɨvɨ un ja na kaji i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tendɨꞌɨ yɨvɨ un ni ka yaji i nasa ni kundee maa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nu ni ndɨꞌɨ ni ka yee i staa, ni ka nastutu ndajaꞌa ya un uxi uu chika staa stila jiin chāká un ja ni kendoso kuaꞌa ga. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ti chaa ni ka yee staa stila un ni ka iyo uꞌun mil. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nu ni ndɨꞌɨ ni ka nastutu ndajaꞌa ya ja ni kendoso un, ti ni kachi ya jiin da ja na kɨvɨ da barco, ti na kinkoyo da ɨnga yuꞌu lago un undi ñuu Betsaida, nuu ni kendo ya ni kanxiaꞌu ya jiin yɨvɨ un kuankoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yukan ti kuaꞌan ya undi yuku un ja na kakantaꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nu kuan kɨꞌvɨ, ti barco un ja kuaꞌan undi maꞌñu lago un. Ti Jesús kande maa ɨɨn ya undi nuu ñuꞌun ichi. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nu ni kuu kaa uni jañaꞌan, ni jini ya ja ka jnaꞌan da nundoꞌo ja skaka da barco un, chi kee xaan tonto tachi ichi sajni. Yukan ti kuaꞌan Jesús jika ya nuu nducha lago un undi nuu kaꞌiin da naa da. Ti ni ndoꞌo ini ya ja yaꞌa ndoo ya kiꞌin ya niku. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko nu ni ka jini da ja jika ya kuaja ya nuu nducha un, ni ka ndoꞌo ini da ja ɨɨn niꞌna kuu, ti ni ka yuꞌu xaan da undi ka kanajiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tendɨꞌɨ da ka yuꞌu xaan, ko ni kaꞌan ya: ―Maa ri kuu, koto yuꞌu ra naa ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ni ndɨvɨ ya nuu barco un, ti ni kuu naꞌin tachi un. So ka naa ini da ni ka ndeꞌe da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vasu ka jini da jniñu saꞌa ya, ko tu ni ka chaku ini da ja jika ya nuu nducha un, ti ni jakuñɨ tachi un, chi changa ga kandixia vaꞌa da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nu ni ka kendajiyo da yuꞌu lago un, ni ka jakoyo da ñuu Genesaret. Yukan ni ka kuun da, ti ni ka juꞌni da barco da. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ti yɨvɨ kaꞌiin un ni ka nakuni i Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Ti ni ka jaꞌa i corrɨ, ni ka kaxnuꞌuni nuu nɨ yɨvɨ ñuu, taka ranchu jiin taka ñuu kuachi kendo yajni un, ja na kundaꞌa i taka yɨvɨ ka kuꞌu nuu ya. Ti savaꞌni ga ñuu nuu yaꞌa ya, yukan ka skatuu da yɨvɨ ka kuꞌu yuꞌu ichi un, ja na saꞌa ya tajna i. Ti ka kandaꞌu i jiin ya, ja na kuaꞌa ya vasu tɨꞌlɨ yuꞌu saꞌma ya na jnɨɨ i, ti na nduvaꞌa i naa i. Ti taka yɨvɨ ni ka kueꞌe saꞌma ya, ni ka nduvaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɨɨn kɨvɨ ni katuꞌva chaa fariseo jiin chaa ka xnaꞌan ley ini veñuꞌun Israel, ja vekoyo da ichi Jerusalén nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Ja ni ka jini da ja ndajaꞌa ya tu ni ka nandaꞌa da ti ka yee da staa, ja tu ka siuku da jnuꞌun chaa un naa da. Chi chaa fariseo jiin chaa Israel ka siin da jiin jnuꞌun janaꞌan, ja nɨnɨ ka nandaꞌa da tɨjnɨ jinu ti sa kaji da staa, suni nu ni ka jaꞌan da yaꞌu. Chi ka ndoꞌo ini da ja nu na saꞌa da siaꞌan, ti ka kendo vaꞌa da nuu Yandios. Suni siaꞌan ka saꞌa da jiin taka ndajniñu, ka nakacha da taza, koꞌo, tɨndoꞌo, kɨsɨ, suni jito da. Ti nu ni ka jini da ja ndajaꞌa Jesús tu ka siuku da jiin jnuꞌun un, ti ni ka kachi da jiin Jesús: ―¿Ndoo tu ka nandaꞌa ndajaꞌa ra nava iyo jnuꞌun janaꞌan? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ti ni kachi Jesús: ―Jandaa ni chaa profeta Isaías na janaꞌan, ja jiin jnuꞌun ra un ka stuu ra maa ra ja tu ka chiñuꞌun ra jnuꞌun Yandios, na ni kachi da: Ko yɨvɨ jaꞌa, so jiin yuꞌu i ka chiñuꞌun i ruꞌu, ko añu i, chi jika kuu ini i jito i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ti so ka xndaꞌu i ja ka kandixia ndaa i jnuꞌun Yandios, chi ka siin i jiin jnuꞌun maa i. Ti ka kaꞌan i ja ɨɨn ni kuu jiin jnuꞌun Yandios. Ni kachi Yandios ja ni chaa Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Suni siaꞌan ka kuu ra, chi roꞌo ni ka xndoo ra ley Yandios ja siin ra jiin jnuꞌun ka ndoꞌo ini maa ra naa ra, ja niꞌin ini ra naa ra. Chi ka xndoñaꞌan ra jiin jnuꞌun un, ti ka chaa xio ra ley Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ja yukan ni kachi Moisés: “Kuandatu nuu tata ra nuu nana ra”, ti “Nu nau ja na kaꞌan ndevaꞌa nuu tata nuu nana, ti vaꞌa ga na kuū”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko roꞌo naa ra, ka kaꞌan ra ja tu kuu chindee ra tata ra nana ra. Chi ka kaꞌan ra: “Ni jito na niꞌin ni kuu, ko vijna tukaa, chi taka ja ñavaꞌa na ja ni soko na nuu Yandios.” ");
INSERT INTO mpmNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ti tu ɨɨn yɨvɨ na kaꞌan siaꞌan, yukan ti kaꞌan ra jandaa ja tukaa koto i nuu tata i ni nana i. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yukan kuu ja ka siuku ra savaꞌni ga jnuꞌun ka jajnaꞌan ini maa ra, undi ja ka kuñaꞌnu ga ra ja kuu maa jniñu taꞌu Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yukan ti kana tuku ya yɨvɨ un, ti ni kachi ya: ―Chunsoꞌo vaꞌa naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nchakuachi ɨɨn chaa, ko ansu jiin ja kɨvɨ yuꞌu da, chi suꞌva jiin ja kaña yuꞌu da ja kaꞌan da un. Yukan kuu ja saꞌa ja nchakuachi da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ni xndoo ya yɨvɨ kuaꞌa un, ti ni ndɨvɨ ya ini veꞌe. Ti ndajaꞌa ya ni ka jikajnuꞌun da nasa kuni kaꞌan jnuꞌun ni kaꞌan ya nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ti ni kachi Jesús: ―¿Vanu ɨɨn ni kanda ra jiin yɨvɨ un naa i, ja tu ni ka chaku ini ra jnuꞌun kaꞌan ri nusa? Ni ɨɨn yɨvɨ tu nchakuachi i nuu savaꞌni ga ndeyu yaji i. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi ja yaji i tu kɨvɨ ini añu i ja ndoꞌo ndevaꞌa ini i, chi kuaꞌan chii jitɨ i ―kachi ya. Siaꞌan ni kachi ndaa Jesús ja iyo ndoo taka nuu ndeyu yaji yo. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nchakuachi ɨɨn chaa ndoꞌo ndevaꞌa ini añu da ti saꞌa ndevaꞌa da, chi taka jnuꞌun ndevaꞌa un kaña undi ini añu da. Yukan saꞌa ja ka ndoꞌo ndevaꞌa ini yɨvɨ, ti tu kuu naꞌiin ini i jiin. Kuni sakuiꞌna i, jiꞌyo i kaꞌni i ndɨyɨ, ");
INSERT INTO mpmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kuni kuisonchaa i ndajniñu ñanijnaꞌan i kuasun ini i, jaꞌa ini i, xndoñaꞌan i, saꞌa i jniñu ja chakuachi i ɨnga yɨvɨ, ndoꞌo vixi ini i, tu kaꞌan yɨñuꞌun i, jika i sɨkɨ vicio, chaa un ka xndaꞌu da ñasɨꞌɨ ja ka yɨsɨkɨnchaa jnaꞌan da, ti ndoꞌo kueꞌe ini da sɨkɨ savaꞌni ga yɨvɨ ja jiꞌyo da kusu da jiin. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ti taka yukan vaji undi ini añu da, ti saꞌa ja nchakuachi xaan da jiin ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yukan ti kuaꞌan Jesús undi ñuu Tiro jiin Sidón. Ni niꞌin ya ɨɨn veꞌe ni kendo ya. Ti tu kuni ya ja kuni yɨvɨ nuu kancha ya yukan, ko tu ni kuu kɨsaꞌyɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ti ñuu un iyo ɨɨn ñaꞌan lulu ja jnaꞌan tachi xaan. Ti nu ni jinisoꞌo nana ña jnuꞌun Jesús, ni jaꞌan ña nuu kancha ya ti ni jakunjitɨ ña nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ti ansu ñaꞌan ñuu Israel kuu ña, chi ñaꞌan ñuu Sirofenicia kuu ña, chi yukan ni kaku ña. Ti jikantaꞌu ña nuu Jesús ja na kenchaa ya tachi xaan jnaꞌan ɨɨn seꞌe sɨꞌɨ ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ko ni kachi Jesús jiin ña: ―Sia, xnakan na saꞌa ri jniñu nuu chaa ñuu ri, ti sa na saꞌa ri jniñu kuni ra. Chi tu kuu ja kuisonchaa yo staa yuꞌu suchi kuachi nu ka yee i, ti kuaꞌa yo nuu ina un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ti ñaꞌan un ni kachi ña: ―Jandaa kaꞌan ni Jitoꞌyo, ko ina un chi kaꞌiin tɨ chii mesa, ti nastutu tɨ staa nukoyo yuꞌu suchi kuachi un ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ti ni kachi Jesús: ―Ni kachi ndaa ra chi ni kandixia ra ruꞌu. Vijna ti kuanoꞌon veꞌe ra, chi tachi xaan un ja ni kenchaa nuu sesɨꞌɨ ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yukan ti kuanoꞌon ña. Ni najaa ña ti ni ndeꞌe ña ja ndetatu sesɨꞌɨ ña un nukoo nuu jito, ti ja ni nduvaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jaku ni kɨvɨ ti ni kee ya ñuu Tiro, ti kuaꞌan ya. Ni yaꞌa ya ichi ñuu Sidón jiin ñuu Decápolis ti ni najaa ya undi yuꞌu lago Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yɨvɨ ñuu Decápolis un, ni ka kinchaka ɨɨn chaa soꞌó, ti ni ka jikantaꞌu da nuu Jesús ja na chuxndee ya ndaꞌa ya sɨkɨ chaa un ti na nduvaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ti Jesús ni kana ya chaa soꞌó un. Ti ni chundee ya xini ndaꞌa ya ini soꞌo da. Ni tɨvɨ sɨꞌɨ ya xini ndaꞌa ya. Ti ni kueꞌe ya yaá da. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ni ndakoto ya ichi andɨvɨ, ti ni jakan ini ya ja kukuiꞌya ini ya, ti ni kachi ya: ―Efata (ja kuni kaꞌan: Nuña) ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti hora un ni jinisoꞌo ni chaa un, ti ni kuu kaꞌan vaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ti ni kachi Jesús jiin yɨvɨ un ja tu kani kuɨtɨ i jnuꞌun ja ni saꞌa ya jniñu ñaꞌnu un. Ko vasu siaꞌan ni kachi ya, ko viꞌga ni ka jani yɨvɨ un jnuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ti taka yɨvɨ ni ka jinisoꞌo un, ni ka naa ini i, ti ni ka kachi i: ―Taka jniñu saꞌa da iyo vaꞌa. Chi nduvaꞌa chaa soꞌó jiin chaa ñɨꞌɨn un saꞌa da ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kɨvɨ un ni ka taka tuku kuaꞌa xaan yɨvɨ nuu ya, ko tu ka ndiso i staa kaji i. Yukan ti ni kachi ya jiin ndajaꞌa ya: ");
INSERT INTO mpmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Kundaꞌu ini ri yɨvɨ kuaꞌa jaꞌa, chi ja ni kuu uni kɨvɨ kaꞌiin yɨvɨ jaꞌa jiin ri, ti tukaa ndoo kaji yɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu na nataji ri yɨvɨ jaꞌa nukoyo ndicha i, ti va kuita i sava ichi un, chi iyo yɨvɨ vekoyo jika ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ti ni ka kachi ndajaꞌa ya un: ―¿Nanu kii ja kuaꞌa yo nuu yɨvɨ jaꞌa, ti jaꞌa tu kanchuku ni ɨɨn yɨvɨ? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ti ni jikajnuꞌun ya da: ―¿Nasa ga staa stila kandiso ra nusa? Ti ni ka kachi da: ―Kandiso na uxia staa stila ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nusa, ti kaꞌan jiin yɨvɨ na nukoo i naa i ―kachi ya jiin da. Ti ni kiꞌin ya ndɨ uxia staa stila un, ni nakuantaꞌu ya nuu Yandios, ni sakuachi ya, ti ni jaꞌa ya nuu ndajaꞌa ya un, ja na tejnaꞌan da naa da nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Suni iyo jaku ga chāká kuachi. Ni kiꞌin ya ti ni nakuantaꞌu ya nuu Yandios ja kuu chāká un. Ti suni ni jaꞌa ya nuu ndajaꞌa ya ja na tejnaꞌan da nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kɨvɨ un ni ka iyo kuun mil yɨvɨ, ti tendɨꞌɨ i ni ka yee i nava kuu ini maa i. Ti ni kendoso uxia ga chika naꞌnu staa stila ja ni ka nastutu ndajaꞌa ya. Yukan na ti ni nataji ya, ti kuan nukoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ni ndɨvɨ ya ini barco jiin ndajaꞌa ya, ti kuaꞌan ya ichi ñuu Dalmanuta. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nu ni jaa barco un, ti ni ka chakoyo chaa fariseo ni ka jandeꞌe da Jesús, ti ni ka kejaꞌa ka xndichi da ya, ja kuni kotonchaa da ya. Ni ka kaꞌan da jiin ya ja na saꞌa ya ɨɨn jniñu ñaꞌnu, nava na kuni ndaa da ja maa Yandios ni taji Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Uꞌu ni jitu ini ya, ti ni kachi ya: ―¿Ndoo ka jani ini ra ja saꞌa ri jniñu ñaꞌnu nuu ra naa ra, ti sa kandixia ra ja Yandios ni taji ruꞌu nusa? Ko nuu ra naa ra tu saꞌa ri ni ɨɨn jniñu ñaꞌnu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ni xndoo ya da naa da, ti ni ndɨvɨ ya nuu barco jiin ndajaꞌa ya. Ti kuaꞌan ya ɨnga yuꞌu lago un. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ni ka naa ini ndajaꞌa ya ja kundaꞌa da staa stila, chi ɨɨn ni ga staa stila ka yɨndaꞌa da. Ti nu kuankoyo da nuu barco un, ti ni kachi Jesús: ");
INSERT INTO mpmNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","―Koto ra naa ra jiin jnuꞌun ka kaꞌan chaa fariseo jiin jnuꞌun kaꞌan rey Herodes, chi yachi kuan kuichanuu jnuꞌun un nuu nɨ ñuu, nanu yachi keniꞌno levadura chii yujña kuu staa stila ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ti ndajaꞌa ya ni ka kejaꞌa ka ndajnuꞌun da naa da ndoo ni kaꞌan ya siaꞌan: ―¿Xi ja tu ka yɨndaꞌa yo staa stila kuu ja kaꞌan ya siaꞌan nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ni jini Jesús ja tu ni ka chaku ini da sɨkɨ jnuꞌun kaꞌan ya, ti ni kachi ya jiin da: ―¿Ndoo ka kaꞌan ra ja tu ka ndiso ra staa stila? Tu ni ka chaku ini ra nusa. Xaan ga ndava ini ra ja tu ka chaku ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ka ndeꞌe ra jiin nduchi ra taka jniñu saꞌa ri, ti ka ñusoꞌo ra taka jnuꞌun kaꞌan ri, ti tu jaꞌi chaku ini ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Tu ka naꞌan ra kɨvɨ na ni tejnaꞌan ri uꞌun staa stila nuu uꞌun mil yɨvɨ un naa i nusa? ¿Ti nasa staa stila ni ka nastutu ra ja ni kendoso nusa? ―kachi ya. ―Ni ka nastutu na uxi uu chika staa stila ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Ti suni na ni tejnaꞌan ri uxia staa stila nuu kuun mil yɨvɨ un, ¿nasa chika naꞌnu ni ka nastutu ra un nusa? ―kachi ya. ―Uxia chika naꞌnu ni ka nastutu na ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","―¿Ti ndoo tu ka chaku ini ra nusa? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nu ni jaa ya ñuu Betsaida, sava yɨvɨ ni ka yɨndaꞌa ɨɨn chaa kuáá nuu Jesús. Ti ni ka kaꞌan da jiin ya ja na saꞌa ya tajna chaa kuáá un. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ni jnɨɨ ya ndaꞌa chaa un, ti kuaꞌan ya jiin da yuꞌu ñuu un. Ti yukan ni jaka ya tɨꞌlɨ tɨsɨꞌɨ ya nduchi da. Ni chuxndee ya ndaꞌa ya sɨkɨ da, ti ni jikajnuꞌun ya da: ―¿Ja kuu ndeꞌe ra tɨꞌlɨ, xi tuu nu? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti chaa un ni ndeꞌe da, ti ni kachi da: ―Jini na yɨvɨ, ko na kanda yujnu kanda ti ka jika kuankoyo ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ni chaa tuku ya ndaꞌa ya nduchi da, yukan ti sa ti ni kuu nandeꞌe vaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ti ni kachi ya jiin da: ―Kuanoꞌon veꞌe ra, ko tukaa kiꞌin ra ichi ñuu. Ti koto kani ra jnuꞌun nuu ni ɨɨn yɨvɨ un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yukan ti kuaꞌan Jesús jiin ndajaꞌa ya ñuu Cesarea, ɨɨn ndañuu Filipo. Ti ichi kuankoyo da ni jikajnuꞌun ya nuu da naa da: ―¿Ndoo ka ndoꞌo ini yɨvɨ ja naa chaa kuu ri? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ti ni ka kachi da: ―Ka kaꞌan i ja kuu ni Juan, chaa ni skuanducha. Sava i ka kaꞌan ja kuu ni Elías, chaa ni kaꞌan jnuꞌun Yandios undi na janaꞌan. Ti sava ga i ka kaꞌan ja kuu ni ɨnga profeta na janaꞌan―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Ti maa ra, ¿nasa ka ndoꞌo ini ra nusa? ―kachi ya. Ti ni kachi Pedro: ―Maa ni kuu Cristo, ja ni taji Yandios ja ndiso jniñu ñaꞌnu ―kachi da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","―Maa ri kuu, ko koto kani ra jnuꞌun naa ra nuu ni ɨɨn yɨvɨ ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yukan ni kachi ya jiin ndajaꞌa ya: ―Ruꞌu ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, koo ndoꞌo koo nene ri. Chi taka chaa ka kuñaꞌanu nación Israel, jiin taka sutu kuñaꞌnu, jiin suni chaa ka xnaꞌan ley ini veñuꞌun un, tu kuajnuꞌun da ruꞌu. Chi kaꞌni da ruꞌu, ko nu uni kɨvɨ ti nandoto ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ni kachi kaji ya ja siaꞌan kondoꞌo ya. Ti Pedro ni kachi da jiin ya ja koto kuaꞌa ya jnuꞌun ja koo yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ko Jesús ni nandeokuñɨ ya nuu uu ga ndajaꞌa ya un, ti ni kaꞌan ya nuu Pedro: ―Kuxio kiꞌin ra, chi xndaku ra nanu xndaku jaꞌuꞌu. Chi so ja sakanuu ini ri kuu roꞌo, chi tu ndoꞌo ini ra ja kin siuku ri nava kuni maa Yandios, chi roꞌo ndoꞌo ini ra nava ka ndoꞌo ini yɨvɨ ñuyɨvɨ jaꞌa ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yukan ti ni kana ya ndajaꞌa ya jiin yɨvɨ kuaꞌa un, ti ni kachi ya jiin i: ―Nu nau ja kuni siin jiin ri sɨkɨ jnuꞌun Yandios ja kaꞌan ri, ti na xndoo i taka ja ndoꞌo ini i, ti na tava ini i ja taka kɨvɨ na koo ndoꞌo koo nene vasu na kuu i ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chi yɨvɨ kandio ini ja kunchuku vaꞌa i nuu ñuyɨvɨ jaꞌa, ja tu kandixia i jnuꞌun ri, ti xnaa i maa i. Ko yɨvɨ na kondoꞌo koo nene i ja na kandixia i ruꞌu jiin ja kaꞌan i jnuꞌun ri, ti yɨvɨ un na kunchuku i nuu andɨvɨ ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jandaa na kachi ri ja tundo niꞌin yɨvɨ ja ka ndiyo ini i niꞌin yɨ taka ja iyo nuu ñuyɨvɨ jaꞌa, ti xnaa i maa i, ja tu kuncha i jiin Yandios nuu andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jandaa na nachi ri ja tu iyo kuɨtɨ naa jiin chunaa yɨvɨ un ja nama i añu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ko nu ɨɨn yɨvɨ kukanuu i ja sɨkɨ ruꞌu, ja tu kuni kaꞌan i nuu yɨvɨ ja kandixia i ruꞌu, vasu nuu yɨvɨ ka yɨsɨkɨnchaa jnuꞌun ri, nusa ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, suni kukanuu ri ndakuniꞌin ri sɨvɨ i kɨvɨ na nchaa ri jiin taka ángel ja ka junukuachi nuu Yandios. Chi ja kuu kɨvɨ un kundiso ri jniñu ñaꞌnu ja tatu Tata ri Yandios nuu ri naa ri. Yukan ti tu nakuni kuɨtɨ ri taka yɨvɨ ja tu ni kuni kaꞌan i ja kandixia i ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yukan ti ni kachi Jesús: ―Jandaa na kachi ri ja sava roꞌo ja kaꞌiin jaꞌa kuchaku ra ti kuni ra nchaa Seꞌe Yandios jiin jniñu ñaꞌnu xaan ga, ti taꞌu ya jniñu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nu ni kuu iñu kɨvɨ ti ni kana ya Pedro, Jacobo jiin Juan, ti kuaꞌan ya jiin da yuku sukun ga un nuu ni kuꞌiin da naa da. Ti Jesús ni nasama nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Saꞌma ya ndinchaa ii. Ti ni ndukɨyɨ xaan tonto ja ni ɨɨn yɨvɨ ñuyɨvɨ jaꞌa tu nakacha siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ti yukan ni ka jini da ja ni ka ndenda uu chaa ni ka kuu profeta na janaꞌan Elías jiin Moisés, ja ni kuu da ɨɨn chaa kuñaꞌnu ga nuu nación Israel, ka ndajnuꞌun da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ti ni kachi Pedro: ―Maestro, vaꞌa ga na kendo yo jaꞌa. Na saꞌa na veꞌe kuii na kunchaa yo. Ɨɨn kuu maa ni, ɨnga na kuu Moisés, ti ɨnga na kuu Elías ―kachi da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Siaꞌan ni kaꞌan Pedro, chi so ni ka saꞌu ini da naa da ja ka yuꞌu da, ti tu ni jini da nau kuu jnuꞌun kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yukan ni jakava ɨɨn viko nuꞌun sɨkɨ da naa da, ti nuu viko un ni ka jinisoꞌo da ɨɨn ndusu ja ni kaꞌan: ―Jaꞌa kuu Seꞌe ri ja kundaꞌu ini ri. Chunsoꞌo ti kuandatu ra naa ra jnuꞌun kaꞌan ya ―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ti nu ni ka ndeꞌe da un, tukaa ndoo iyo Moisés jiin Elías, chi maa ni ga Jesús ni ka jini da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nu ni ka nandeokuñɨ da xini yuku un, ti ichi ka noꞌon da ni kachi Jesús ja tu kani kuɨtɨ da jniñu naa da ndoo ni ka jini da, chi undi nu ni nandoto ya ja kuu ya maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yukan ti tu ni ka jani kuɨtɨ da jnuꞌun nuu ni ɨɨn yɨvɨ, chi so ka ñuꞌun ini maa da nasa kuu ja kuū ya, ti nandoto ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ni siin da kuankoyo da ti sa ni ka jikajnuꞌun da Jesús: ―¿Ndoo ka kaꞌan chaa ka xnaꞌan ley ini veñuꞌun un ja xnakan ndii tuku profeta Elías, ti sa kii Cristo nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ti ni kachi ya jiin da: ―Jandaa kuu ja xnakan Elías ndii tuku, ti satuꞌva da yɨvɨ jiin tendɨꞌɨ ja iyo ini ñuyɨvɨ jaꞌa, chi siaꞌan kaꞌan nuu tutu ii. Nu siaꞌan kuu, ¿ti ndoo kaꞌan ga nuu tutu un ja koo ndoꞌo koo nene maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti skexiko yɨvɨ maa ya, ti koto uꞌu i nuu ya nu? ");
INSERT INTO mpmNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko na kachi ri ja Elías, chi ja ni kii da, ko ni ka saꞌa ndevaꞌa yɨvɨ nava kuu ini jiin da. Yukan ni kundaa nava yoso nuu tutu ii ja siaꞌan kuu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yukan ti ni najaa ya nuu kaꞌiin uu ga ndajaꞌa ya, ni jini ya kaꞌiin kuaꞌa xaan yɨvɨ nuu da, ti suni kaꞌiin chaa ka xnaꞌan ley un, ti ka kaꞌan nchaa jnaꞌan chaa un jiin ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nu ni ka jini yɨvɨ un ja ni najaa Jesús, so ni ka naa ini i ka ndeꞌe i nuu ya. Ti ni ka jaꞌa i corrɨ kuan kanxiaꞌu jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yukan na ti ni jikajnuꞌun ya ndajaꞌa ya: ―¿Ndoo ka kijnaꞌan ra jiin chaa un naa da? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ti ɨɨn chaa ni kachi: ―Maestro, yɨndaꞌa na ɨɨn seꞌe na nuu ni ja ndoꞌo i tachi xaan, ti undi kuu ñɨꞌɨn i saꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu ni ndejaꞌa kueꞌe un, undi jiyɨꞌɨ i ti jiokava i nuu ñuꞌun, ti kaña tiꞌiñu yuꞌu i. Suni kuꞌyu jnuꞌun i, ti undi kuu tɨkuku i. Ni kachi na jiin ndajaꞌa ni ja na kenchaa da tachi xaan un kiꞌin, ko tu ni kujnuni ja saꞌa da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yukan ti ni kachi ya jiin ndajaꞌa ya: ―Xaan niꞌin ini ra naa ra. Nasa ga kɨvɨ ti sa kandixia ra nusa. Ti ja ni kunaꞌan ja ndoꞌo nene ri jiin ra naa ra. Kuan kiꞌin chaa lulu un na kii da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ti ni ka jankiꞌin da chaa lulu un. Ni jini tachi xaan un nuu Jesús, ti luego ni, ni saꞌa ja na kuyɨꞌɨ chaa lulu un. Ni nduva i nuu ñuꞌun, ni kejaꞌa jiokava i, ti kaña tiꞌiñu yuꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ti ni jikajnuꞌun ya maa tata i: ―¿Nasa kuiya ni kuu ja jnaꞌan i tachi xaan jaꞌa? ―kachi ya. Ti ni kachi tata i: ―Undi lulu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ti tɨjnɨ jinu kuni kaꞌni tachi xaan un yɨ. Iyo nduva i nuu ñuꞌun. Iyo kanakava i ini nducha. Ti nu kuu chindee ni saña, kundaꞌu ini ni nuu na jiin seꞌe na, ti saꞌa ni tajna i ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ti ni kachi Jesús jiin da: ―Koto kaꞌan ra siaꞌan, chi jandaa kuu ja saꞌa ri jniñu ñaꞌnu un nu na kandixia ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ti tata suchi lulu un ni kaꞌan jaa da: ―¡Kandixia na, ko chindee ni saña nava na kandixia ndaa ga na! ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nu ni jini Jesús ja kuan kututu ga yɨvɨ naa i, ti ni kachi ya jiin tachi xaan un: ―Roꞌo tachi xaan, ja saꞌa ñɨꞌɨn ra, ti saꞌa soꞌo ra chaa lulu jaꞌa, kuankee ti koto xnañaꞌan ga ra nuu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ti tachi xaan un ni kɨsɨ chaa lulu un, ni saꞌa ja na kuyɨꞌɨ tuku da, ni kanajiin, ti ni kenda kuaꞌan. Ti suchi un undi ni jiꞌi naa i katuu i. Ni ka ndoꞌo ini sava yɨvɨ un ja ja ni jiꞌi yɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko Jesús ni jnɨɨ ya ndaꞌa i, ni ndokani ya i, ti ni ndokuɨñɨ i kandichi i. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nu ni ka najaa da veꞌe, ni ka jikajnuꞌun ndajaꞌa un ya: ―¿Ndoo tu ni kuu kenchaa na tachi xaan un kiꞌin naa na? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ti ni kachi Jesús: ―Ja keniꞌin yo ɨɨn tachi xaan siaꞌan, ti kuni ja na kakantaꞌu nɨ ini nɨ añu yo nuu Yandios. Chi tu kuu saꞌa yo nu tu kuñukuu ini yo ja maa Yandios kuu ya saꞌa jniñu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yukan na ti kuaꞌan ya jiin ndajaꞌa ya ɨnga ichi, ni ka yaꞌa da ñuu Galilea. Ko kuankoyo xeꞌe da jiin ya, chi kuni xndaku ya ɨɨn jnuꞌun kanuu ga nɨnɨ nuu maa da naa da, ti tu kuni ya ja kuni yɨvɨ nanu kancha ya. Yukan ti ni kachi ya nuu da: ―Maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa yɨvɨ maa ya nuu chaa kanda kuaꞌan kanda vaji un, ti kaꞌni da maa ya. Ko nuu uni kɨvɨ ti nandoto ya ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ko tu ni ka chaku ini ndajaꞌa ya un jnuꞌun ni kaꞌan ya, ti ni ka yuꞌu da kajnuꞌun da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ti nu ni ka jaa da ñuu Capernaum, ni ka kɨvɨ da ɨɨn veꞌe, ti ni jikajnuꞌun ya nuu ndajaꞌa ya: ―¿Ndoo ka kaꞌan ra ichi vaji yo? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ti maa da tu ni ka kaꞌan kuɨtɨ da, chi ichi un ka ndajnuꞌun da siaꞌan: ―¿Nau ɨɨn ɨɨn yo kuñaꞌnu ga nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yukan ti ni nukoo Jesús, ni kana ya ndɨ uxi uu ndajaꞌa un, ti ni kachi ya: ―Nu nau ja kuni kunúú, ti kuni kuñaꞌnu, vaꞌa ga na kendo sandɨꞌɨ ni ga, ti na kunukuachi nuu uu ga da un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Ti ni jnɨɨ ya ɨɨn suchi lulu, ti ni jununchaa ya i, ti ni kachi ya jiin ndajaꞌa ya: ―Jiin jniñu ndiso ri na kachi ri ja nu na kundaꞌu ini ra ɨɨn suchi lulu siaꞌan, ti ja ni kuu ra ɨɨn yɨvɨ ni jantaꞌu ruꞌu. Ti ja jantaꞌu ra ruꞌu, ansu nɨnɨ ruꞌu jantaꞌu ra, chi suni jantaꞌu ra Yandios, ya ni taji ruꞌu vaji ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yukan ti ni kachi Juan: ―Maestro, ni ka jini na ɨɨn chaa ja jiin sɨvɨ ni keniꞌin da tachi xaan ka jnaꞌan sava yɨvɨ. Ti ni ka kachi na jiin da ja tu saꞌa da jniñu un, chi tu yaku da jiin yo ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti ni kachi Jesús: ―Tu kaꞌan ra nuu da niku, chi chaa ndaku niꞌin sɨvɨ ri ja saꞌa da ɨɨn jniñu ñaꞌnu nanu saꞌa ri kaꞌan vaꞌa da ti tu kaꞌan da sɨkɨ ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi yɨvɨ tu kaꞌan sɨkɨ yo ja chindee i yoꞌo, suꞌva kaꞌan i jaꞌa yo. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jandaa kuu ja ɨɨn yɨvɨ na kuaꞌa ɨɨn vasu nducha koꞌo ra ja sɨkɨ ja ka yɨꞌɨ ra jiin Cristo, ti jandaa kuɨtɨ kuu ja iyo taꞌu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Ɨɨn nundoꞌo kaꞌnu xaan kundatu ɨɨn chaa nu na xndaꞌu da ɨɨn suchi lulu, ti siaꞌan tukaa kandixia i ruꞌu. Iyo vaꞌa ga nu na kundikun sukun da jiin ɨɨn yoso molino, ti na kiꞌin da chii nducha mar. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chi nu nau yɨvɨ kaña ini ja kuni saꞌa i ɨɨn kuachi jiin ndaꞌa i, ti yachi na nakani ini i ja tu vaꞌa. Na saꞌa i nanu ja, ja ni kenchaa ndaꞌa i un kuaꞌan. Chi vaꞌa ga na koo ɨɨn ni ndaꞌa i, ti kunukuachi i nuu Yandios ansu ja koo ndɨ nduu ndaꞌa i, ti kiꞌin i nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ti yukan, tɨndaku un tu kuū tɨ, ti ñuꞌun un tu ndaꞌva kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Xi nu nau yɨvɨ kaña ini i ja kuni kunchakuachi i jiin sɨꞌɨn i, ti na nakani yachi ini ja tu vaꞌa. Ti na saꞌa i nanu ja, ja ni kenchaa sɨꞌɨn i un kuaꞌan. Ti vaꞌa ga na koo kuꞌlu i najaa i nuu Yandios, ti ansu ja jiin ndɨnduu sɨꞌɨn i kiꞌin yɨ nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ti yukan tɨndaku un, tu kuū tɨ, ti ñuꞌun un tu ndaꞌva kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ti nu nduchi i saꞌa ja na saꞌa i kuachi, ti yachi na nakani ini i ja tu vaꞌa. Ti na saꞌa i nanu ja, ja ni tava i kuaꞌan. Chi vaꞌa ga na najaa i nuu Yandios jiin ɨɨn ni nduchi i ti ansu ja kiꞌin yɨ jiin ndɨnduu nduchi i nuu infiernu. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ti yukan tɨndaku tu kuū tɨ, ti ñuꞌun un tu ndaꞌva kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ko ja kuu maa ra naa ra, kuu nanu ja ni ka kɨvɨ ra nuu ñuꞌun, chi ja kondoꞌo koo nene ra, kuu nanu ja soko ra maa ra jiin nundoꞌo kondoꞌo ra un. Chi nanu ni ka chiꞌi ra ñɨɨ ja na sandoo ja ni soko ra nuu Yandios, nava ni kachi ley Moisés, ti siaꞌan sandoo Yandios roꞌo naa ra jiin nundoꞌo un, nava na kunukuachi vaꞌa ra nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Saꞌa yo nanu ja ka kuu ra nanu ñɨɨ, chi nu ni naa xiko, tukaa kuajniñu yo ja kuu nuu ndeyu. Suni siaꞌan kuni ri jiin ra naa ra ja na kukutu ini ra jiin jnuꞌun xndaku ri, ti siaꞌan na kukuee kunchuku ra naa ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yukan ni kee ya ñuu Capernaum, ti kuaꞌan ya ichi ñuu Judea undi ɨnga yuꞌu yucha Jordán. Ti ni ka kututu yɨvɨ nuu ya. Ti ni kejaꞌa tuku ya xndaku ya nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ti yukan ni ka jakoyo tɨjnɨ chaa fariseo ja ka kuni xndichi da ya, ti ni ka jikajnuꞌun da: ―¿Iyo vaꞌa ja xndoo ɨɨn chaa ñasɨꞌɨ da nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ti ni kachi Jesús: ―¿Ndoo ni kachi ley Moisés? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yukan ni ka kachi da: ―Kachi ley Moisés ja ɨɨn chaa kuu xndoo da ñasɨꞌɨ da, nu na kuaꞌa da ɨɨn tutu nuu ña, ti kuu kendo ña ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yukan ti ni kachi Jesús: ―Siaꞌan ni kaꞌan Moisés, chi ndee niꞌin ini ra naa ra, kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko undi na ni nukoo ñuyɨvɨ, ni saꞌa Yandios taka ndajniñu iyo nuu ñuyɨvɨ jaꞌa, ti ni saꞌa ya ɨɨn chaa jiin ɨɨn ñasɨꞌɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Yukan kuu ja nu ni nandaꞌa ɨɨn chaa jiin ɨɨn ñasɨꞌɨ, ti ndɨnduu da ni ka nduu da ɨɨn ni ga jiin ñasɨꞌɨ da. Tukaa ka kuu sɨɨn sɨɨn yɨvɨ, chi ɨɨn ni ga ni ka kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yukan kuu ja ɨɨn chaa, tu kuu sasɨɨn da ja ni chajnaꞌan maa Yandios ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yukan na ti ndajaꞌa ya, nu ni ka na jaa da veꞌe jiin Jesús, ti ni ka jikajnuꞌun da ya nasa kuni kaꞌan jnuꞌun ni kaꞌan ya jiin yɨvɨ un, ");
INSERT INTO mpmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ti sa ni kachi ya: ―Nu ɨɨn chaa na xndoo da ñasɨꞌɨ da, ti nandaꞌa da jiin ɨnga ña, ti yɨsɨkɨnchaa da ñasɨꞌɨ da undi nuu ja siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Suni siaꞌan kuu jiin ɨɨn ñasɨꞌɨ nu na xndoo ña yɨɨ ña undi nuu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yukan ti ni ka chakoyo yɨvɨ nuu ya jiin suchi kuachi ja na jnɨɨ ya i. Ko ni ka jini ndajaꞌa ya ja siaꞌan ka kuni yɨvɨ un, ti tu ni ka jaꞌa da jnuꞌun ja tuꞌva yɨvɨ un nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ti nu ni jini Jesús ja ka nduxaan da nuu yɨvɨ un, ni kuɨtɨ ini ya, ti ni kachi ya jiin da: ―Sia, na kikoyo i nuu ri, ti tu kasɨ ra ichi i naa ra. Chi yɨvɨ ja tu vixi ini, ti ndeꞌe ini i nanu suchi kuachi siaꞌan, kuu kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chi na kachi ndaa ri ja tu yɨɨ kuantaꞌu ɨɨn suchi lulu jnuꞌun Yandios ja na taꞌu ya jniñu nuu i, chi ti kuniꞌin ga ini i, ti ansu ɨɨn yɨvɨ ñaꞌnu ja, ja ni kuniꞌin ini, chi tu jantaꞌu i ja kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ti ni kiꞌin ya ndɨ ɨɨn ndɨ ɨɨn suchi kuachi un, ni jununchaa ya i, ni chuxndee ya ndaꞌa ya sɨkɨ i, ti ni jikantaꞌu ya nuu Yandios ja na koto ya i. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yukan ni siin ya ichi kuaꞌan ya, ti jinu xaan ɨɨn chaa ni chaa nuu ya. Ni jakunjitɨ da, ti ni kachi da: ―Chaa vaꞌa kuu ni maestro. Ti kachi ni, ¿naa jniñu vaꞌa saꞌa na, ti na ni taꞌu na nuu Yandios, ti kuncha na nuu andɨvɨ ja kuu saa ni? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti ni kachi Jesús: ―Ndoo kaꞌan ra ja chaa vaꞌa kuu ri, ti tu iyo ni ɨɨn chaa vaꞌa, chi maa ɨɨn ni Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jini ra ja tu kusɨkɨnchaa ra ñasɨꞌɨ, tu sakuiꞌna ra, tu kaꞌan ra sɨkɨ yɨvɨ, tu xndoñaꞌan ra, kuandatu nuu tata ra nuu nana ra, kachi ley ya ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yukan ti kachi da: ―Maestro, taka jniñu un ja ni siuku na undi lulu na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ko ni ndeꞌe vaꞌa Jesús nuu da, ni kundaꞌau ini ya, ti ni kachi ya: ―Ɨɨn ni ga jniñu kumani ja saꞌa ra. Kuaꞌan ti xiko ndɨꞌɨ ra taka ja ñavaꞌa ra, ti tejnaꞌan xuꞌun un nuu yɨvɨ ndaꞌu. Siaꞌan ti sa kuñavaꞌa ra yaji nuu andɨvɨ. Nu ni ndɨꞌɨ ni saꞌa ra un, yukan ti ñaꞌan na choꞌo ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ko nu ni jinisoꞌo da ja siaꞌan ni kaꞌan Jesús, ni ndɨꞌɨ ini da, ti ni kukuiꞌya xaan ini da ti kuaꞌan da, chi vanuxia riko xaan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yukan ti ni ndeꞌe vindaa ya nuu ndajaꞌa ya, ti ni kachi ya: ―Xaan ga yɨɨ ja kɨvɨ ɨɨn chaa riko ndaꞌa Yandios ja na taꞌu ya jniñu nuu da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","So ni ka naa ini ndajaꞌa ya ja siaꞌan ni kaꞌan ya. Ko ni kachi tuku ya: ―Hijo naa ra, xaan ga yɨɨ ja kɨvɨ ɨɨn chaa riko ndaꞌa Yandios ja na taꞌu ya jniñu nuu da, chi ñukuu ga ini da taka ja ñavaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yachi ga kɨvɨ ɨɨn camellu yau ɨɨn yɨkɨ tɨkuɨ, ansu ja na kɨvɨ ɨɨn chaa riko ndaꞌa Yandios ti taꞌu ya jniñu nuu da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ko maa ndajaꞌa ya, viꞌga ni ka naa ini da, ti ka ndajnuꞌun da: ―¿Nau kuu chaa nanitaꞌu nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yukan ni ndeꞌe ya nuu da naa da, ti ni kachi ya: ―Ja kuu yɨvɨ, tu kuu kuɨtɨ saꞌa i, ko Yandios chi taka ni kuu saꞌa ya, ti tu iyo ni ɨɨn ja kendo siaꞌan ni ja tu kuu saꞌa ya ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yukan na ti ni kachi Pedro jiin ya: ―Ndeꞌe ni, saña naa na, ni ka xndoo na taka ja ka ñavaꞌa na, ti vekoyo na jiin ni ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ti ni kachi ya: ―Jandaa ndixia kuu ja na kachi ri nasa kuu jiin yɨvɨ ja kuni kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, vasu na xndoo i veꞌe i, kuaꞌa i, ñani i, tata i, nana i, ñasɨꞌɨi jiin seꞌe i jiin ñuꞌun i. Ja siaꞌan ti suꞌva na niꞌin yɨ viꞌga ja kuu taka ja ni ka xndoo i un. Chi koto uꞌu yɨvɨ maa i, ko nuu kuncha i andɨvɨ, tukaa kuu kuɨtɨ i. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko na jaa kɨvɨ ja xndichi Yandios nuu taka i, ti chaa ka ndoꞌo ini ja ka kuñaꞌnu da vijna, nduu da sandɨꞌɨ ni ga. Ti chaa ka kuu sandɨꞌɨ ni ga vijna, nduu ñaꞌnu ga da ja kuu kɨvɨ un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yukan ti ni ka kaa da ichi ñuu Jerusalén kuankoyo da. Yoxnuu Jesús, ti ka jindandikun ndɨ uxi uu ndajaꞌa un, ko so ka naa ini da kuankoyo da ti ka yuꞌu da, chi kuaꞌan ya ichi nuu ka jito uꞌu yɨvɨ ya. Suni kuankoyo ga yɨvɨ ka skuaꞌa jiin ya, ko suni ka yuꞌu i. Yukan ni kana sɨɨn ya ndɨ uxi uu ndajaꞌa ya un, ti ni kachi ya taka nundoꞌo ja kii sɨkɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ti kachi ya: ―Ja ka jini ra ja ni ka kaa yo vekoyo yo ichi ñuu Jerusalén. Ti yukan nakuaꞌa yɨvɨ maa Seꞌe Yɨvɨ Ñuyɨvɨ nuu taka sutu Israel ka kuñaꞌnu, jiin nuu chaa ka xnaꞌan ley ini veñuꞌun kaꞌnu Israel. Ti chakuachi da ya, ti nakuaꞌa da ya nuu yɨvɨ ɨnga nación. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ti chaa un kusɨkɨnchaa da maa ya, tɨvɨ sɨꞌɨ da nuu ya, kuaꞌa da tau ya, ti kaꞌni da ya. Ko nu uni kɨvɨ, ti nandoto tuku ya maꞌñu ndɨyɨ un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yukan na ti Jacobo jiin Juan, seꞌe yɨɨ Zebedeo, ni ka tuꞌva da nuu Jesús ti ni ka kachi da: ―Maestro, ka kuni na ja kuaꞌa ni ja ka jikan va ―ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ti ni kachi Jesús: ―¿Ndoo ka kuni ra nusa? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ti ni ka kachi da: ―Ka kuni na ja na nukoo na jiin ni kɨvɨ na nduñaꞌnu xaan ni, ja taꞌu ni jniñu nuu nɨ tuꞌu ñuyɨvɨ, ɨɨn na ndaꞌa kuaꞌa ni, ti ɨnga na ichi ndaꞌa sajni ni ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti ni kachi ya: ―Ko roꞌo, tu jini ra ndoo ka jikan ra, ¿xi kundee ra koo ndoꞌo koo nene ra jiin ri taka nundoꞌo kii sɨkɨ ri, ti tava ini ra koto ra nundoꞌo un, vasu na kuū ra naa ra nu? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ti ni ka kachi da: ―Tava ini na ja kondoꞌo na jiin ni ―ni ka kachi da. Ti ni kachi tuku ya: ―Jandaa ndixia kuu ja ka tava ini ra kondoꞌo ra jiin ri, ti koto ra nundoꞌo un vasu na kuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko ja nukoo ɨɨn ra ichi ndaꞌa kuaꞌa ri ti ɨnga ra ichi ndaꞌa sajni, tu kachi ri, chi yukan ja ka iyo tuꞌva ja kunchuku nu nau ja na kachi maa Yandios ja kuncha jiin ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nu ni ka jinisoꞌo ndɨ uxi ga ndajaꞌa un, ti ni ka kɨtɨ ini da nuu Jacobo jiin Juan. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ko ni kana Jesús tendɨꞌɨ da, ti ni kachi ya: ―Ka jini ra ja chaa kuñaꞌnu nuu ɨɨn nación, ti maa da xiin, chi kuñaꞌnu ga da, ti taka chaa ka kuñaꞌnu jiin da, taꞌu da jinñu nuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Ko ansu siaꞌan kuu jiin ra naa ra. Chi suꞌva, nu nau roꞌo ka kuni kuñaꞌnu ga nuu uu ga chaa jaꞌa, ti suꞌva na kuanukuachi da nuu ra naa ra. Chi savaꞌni ga ja na kuni kuñaꞌnu, ti suꞌva nduu nanu ɨɨn muzu. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi maa Seꞌe Yɨvɨ Ñuyɨvɨ, ni chaa ya, ko ansu ja kunukuachi yɨvɨ nuu ya, chi suꞌva ja na kunukuachi ya nuu yɨvɨ. Ti nakuaꞌa da maa ya ja na chunaa ya nuu kuachi yɨvɨ naa i, nava na nanitaꞌu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yukan ti ni ka jaa da ñuu Jericó. Ko ni siin ya kuaꞌan ya jiin ndajaꞌa ya, ti kuaꞌa yɨvɨ kuankoyo. Ko nu ni kenda ya yuꞌu ñuu un, yukan nukoo ɨɨn chaa kuaa nani Bartimeo, kuu da seꞌe yɨɨ ɨɨn chaa nani Timeo, ti yukan jikan da xuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti nu ni jinisoꞌo da ja Jesús, chaa ñuu Nazaret, kuu ya vaji un, ni kanakoꞌo da: ―¡Niꞌin Jesús! ¡Maa ni taꞌu jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña! ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tɨjnɨ yɨvɨ ni ka nduxaan nuu da ja na kasɨ yuꞌu da, ko maa da viꞌga ni kanakoꞌo da: ―¡Niꞌin Jesús! ¡Maa ni kuu ja taꞌu jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña! ―kachi tuku da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yukan ni jakuɨñɨ Jesús, ti ni kachi ya: ―Kana da na kii da ―kachi ya. Ni ka kana da chaa un, ti ni ka kachi da jiin da: ―Koto ndɨꞌɨ ini ra. Ndokuɨñɨ, ñaꞌan na choꞌo, chi kana ya roꞌo ―kachi da jiin chaa kuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ti chaa un ni skaña da tɨkachi da, ti ni ndokuɨñɨ da kuaꞌan da nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ti Jesús ni jikajnuꞌun ya maa da: ―¿Ndoo kuni ra ja saꞌa ri jiin ra nusa? ―kachi ya. ―Maestro, kuni na ja na ndundijin nduchi na ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ti ni kachi Jesús jiin da: ―Kuanoꞌon, ja ni nduvaꞌa ra, chi ni kandixia ra jniñu saꞌa ri ―kachi ya. Ti hora ni, ni ndundijin nduchi chaa kuaa un, ti ni nandikun da Jesús, ti kuaꞌan da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nu ni kuyajni ya ñuu Jerusalén, yajni ñuu Betfagé jiin Betania, yajni yuku Olivos, ");
INSERT INTO mpmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ti yukan ni taji ya uu ndajaꞌa ya, ti ni kachi ya: ―Kuankoyo ñuu kande ndijin un. Ti yuꞌu ñuu un ndiku ɨɨn burru, ja ti koso ga yɨvɨ tɨ. Ndaji tɨ ti kii ra jiin tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ti nu nau chaa jikajnuꞌun ndoo ka ndaji ra tɨ, ti kachi jiin da “Maa Jitoꞌyo nandɨꞌɨ da tɨ”, kachi ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ti kuankoyo nduu ndajaꞌa ya un, ti ni ka naniꞌin ndixia da burru un ndikun tɨ yuꞌu ichi un, yajni ɨɨn veꞌe. Ti ni ka kejaꞌa ka ndaji da tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ti ɨɨn chaa kaꞌiin un ni kachi: ―¿Ndoo ka saꞌa ra, ja sa burru jña ka ndaji ra? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ti maa da ni ka kachi da nava ni kachi Jesús jiin da, ti sa ni ka jaꞌa chaa un jnuꞌun kuankoyo da jiin burru un. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ni ka nandeokuñɨ da jiin burru un nuu ya. Ni ka chuku da tɨkachi da sɨkɨ tɨ, ti ni kaa Jesús sɨkɨ tɨ, ti ni ka siin da ichi kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kuaꞌa xaan yɨvɨ ni ka chuku i tɨkachi i ini ichi un nuu kuan yaꞌa ya. Ti sava ga yɨvɨ un ka jaꞌnu i ndayuku ti ka chuku i ini ichi un. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ti yɨvɨ ka yoxnuu nuu Jesús jiin yɨvɨ ka jindandikun ichi jata ya, ni ka kejaꞌa ka kuvaa i, ka kanajaa i Yandios: ―Na kutaꞌu yo nuu Yandios, ja ni taji ya ɨɨn chaa kuñaꞌnu xaan vaji, nakuaꞌa ya ja vaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vaji da ja na taꞌu da jniñu siaꞌan nanu ni taꞌu tata yo rey David na janaꞌan. ¡Na kanajaa ndajaꞌa ya undi andɨvɨ un ja na kuñaꞌnu chaa jaꞌa! ¡Siaꞌan na kachi ya! ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Siaꞌan ni kɨvɨ Jesús ñuu Jerusalén. Ti kuaꞌan ya undi veñuꞌun kaꞌnu Israel. Yukan ni jini ya taka ja ka saꞌa yɨvɨ un. Ti nu kuan ini, ti ni nandeokuñɨ ya ñuu Betania jiin ndɨ uxi uu ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nu ni kuxian ɨnga kɨvɨ, ni kee ya ñuu Betania, ni nandeokuñɨ tuku ya ñuu Jerusalén, ti ichi kuaꞌan ya ni chaa sokō ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti jaa yajni tɨꞌlɨ un ni jini ya ɨɨn nutɨchɨ vixi, ko tu ni niꞌin ya ni ɨɨn tɨchɨ, chi ansu yoo iyo tɨchɨ kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yukan ti ka ñusoꞌo ndajaꞌa ya ni kaꞌan ya jiin nutɨchɨ un: ―¡Na kachi ri ja jankɨvɨ ga kuaꞌa ra tɨchɨ vixi! ―kachi ya jiin yujnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nu ni jaa ya ñuu Jerusalén, ni kɨvɨ ya ini veñuꞌun kaꞌnu un, ti ni keniꞌin ya taka yɨvɨ ka xiko jiin ja ka jaan yuxeꞌe un kuankoyo i. Ni skuiokava ya mesa chaa ka sama xuꞌun, jiin silla chaa ka xiko sata. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ti tu ni jaꞌa ya jnuꞌun ja kɨvɨ yɨvɨ ka ndiso ndajniñu ja xiko nuu yuxeꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yukan ti ni xndaku ya nuu yɨvɨ un: ―Ka jini ra naa ra ja yoso nuu tutu ii Yandios: “Veꞌe ri konani veꞌe nuu kakantaꞌu yɨvɨ taka nación.” Ko roꞌo naa ra ni ka nasaꞌa ra veꞌe ri nuu ka nataka ñakuiꞌna ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ti chaa ka kuu sutu kuñaꞌnu un jiin chaa ka xnaꞌan ley ini veñuꞌun un, ni ka jinisoꞌo da jnuꞌun ni kaꞌan Jesús. Tu ni ka jajnaꞌan ini da. Ti ni ka kejaꞌa ka nduku da nasa kaꞌni da ya. Ko kɨvɨ un tu ni ka saꞌa da, chi ka yuꞌu da sa kɨtɨ ini yɨvɨ un naa i, chi tendɨꞌɨ yɨvɨ un ka kusɨɨ xaan ini i ka ñusoꞌo jnuꞌun kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ko nu kuan kuñaa, ti kuaꞌan Jesús jiin ndajaꞌa ya ɨnga ñuu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yukan ti jañaꞌan ɨnga kɨvɨ, kuankoyo tuku da ichi un, ti ni ka jini da nutɨchɨ vixi un ja, ja ni ichi undi yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yukan ti ni nukuꞌun ini Pedro jnuꞌun ni kaꞌan Jesús, ti ni kachi da jiin ya: ―Maestro, ndeꞌe ni nutɨchɨ vixi jaꞌa, ja ni kaꞌan ni sɨkɨ iku, ja ni ichi ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yukan ti ni kachi Jesús jiin da: ―Kandixia ndaa nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chi nu nɨ ini nɨ añu ra na kakantaꞌu ra nuu Yandios, ti kachi ra jiin ɨɨn yuku jaꞌa: “Kuanchaꞌa ti kiꞌin ra nuu mar un”, ti nu ñukuu nɨ ini ra ja siaꞌan na kuu, yukan ti jandaa ni kuu ja kuandatu yuku un nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chi jandaa na kachi ri ja taka ndoo na kakantaꞌu ra nuu Yandios, ti kuaꞌa ya nu ñukuu nɨ ini ra ja niꞌin ra, ti niꞌin ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ti nu ka jikantaꞌu ra, kuankaꞌnu ini nuu yɨvɨ jito uꞌu roꞌo, nava Tata yo Yandios, ya kancha andɨvɨ, na kuankaꞌnu ini ya nuu kuachi ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko nu tu kuankaꞌnu ini ra nuu yɨvɨ, suni siaꞌan tu kuankaꞌnu ini Tata yo Yandios, ya kancha andɨvɨ, nuu kuachi ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nu ni ka jaa da ñuu Jerusalén, ti kuankoyo tuku da nuu yuxeꞌe veñuꞌun kaꞌnu un. Yukan jikonuu Jesús ti ni ka tuꞌva sutu ka kuñaꞌnu, jiin chaa ka xnaꞌan ley ini veñuꞌun un, jiin taka chaa kuñaꞌnu un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti ni ka jikajnuꞌun da ya: ―¿Nau ja ni jaꞌa jniñu nuu ra ja saꞌa ra taka jniñu jaꞌa? ¿Nau ja xiin jniñu ñaꞌnu jaꞌa ja saꞌa ra? ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ti ni kachi ya jiin yɨvɨ un: ―Suni ruꞌu na kajnuꞌun ri roꞌo naa ra, ti nu ni ka kachi ra, ti sa na kachi ri nuu ra nau ni jaꞌa jniñu jaꞌa nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kachi naa ra: ¿Nau ja ni taji Juan, chaa ni kii skuanducha yɨvɨ naa i, Yandios xi ɨɨn yɨvɨ nusa? ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ti ni kejaꞌa ka ndajnuꞌun chaa un naa da: ―¿Nasa kachi yo nusa? Chi tu kuu kachi yo ja Yandios ni taji Juan chi kachi Jesús jiin yo: “¿Ndoo tu ni ka kandixia ra jnuꞌun ni kaꞌan da nusa?” ");
INSERT INTO mpmNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ni tu kuu kachi yo ja yɨvɨ ni taji chaa un ―ni ka kachi da. Ti siaꞌan nɨ ka ndajnuꞌun da ja tu kachi da naa da, chi ka yuꞌu da sa kɨtɨ ini yɨvɨ nuu da, chi tendɨꞌɨ i ka jini ja Yandios ni taji Juan ni kii da. ");
INSERT INTO mpmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ti yukan ni ka kachi da jiin Jesús: ―Tu ka jini na nau ja ni taji chaa un ―kachi da. Yukan na ti ni kachi ya: ―Vanuxia tu ka kuni ra kachi ra, ti suni ruꞌu tu kachi ri nuu ra naa ra nau ja ni jaꞌa jniñu ñaꞌnu jaꞌa nuu ri, ja kuu saꞌa ri taka jniñu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yukan ni kejaꞌa Jesús xndaku ya nuu da naa da, ti ni kachi ya: ―Ɨɨn chaa ni saꞌa da ɨɨn huerta, ti ni xndee kuaꞌa da nutɨkaꞌya. Ni chiꞌi da jaku yuu huerta un. Suni ni saꞌa da ɨɨn nundoo kaꞌnu xaan nuu kaxin da tɨkaꞌya un. Ni saꞌa da ɨɨn veꞌev sukun, nuu kotonchaa da nɨ tuꞌu ñuꞌun da. Yukan ti ni jakanchaa da nuu uu chaa ka saꞌa jniñu un, ti kuaꞌan da viaje. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Yukan ti ni jaa kɨvɨ nakiꞌin da jniñu da, ti chaa xiin huerta un, ni taji da ɨɨn muzu kuan nukiꞌin sava jniñu un nava niꞌin da kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko chaa ka yɨndaꞌa huerta un, ni ka kiꞌin da muzu un ni ka kani da, ti ni ka nataji da kuanoꞌon. Ti tundo ni ka jaꞌa kuɨtɨ da kundaꞌa chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ti chaa xiin huerta un ni taji tuku da ɨnga muzu kuaꞌan. Ti chaa ka yɨndaꞌa huerta un ni ka stuji da xini, ti ni ka jaꞌa xaan da tau muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ni taji tuku da ɨnga muzu kuaꞌan, ko chaa ka sajniñu un ni ka jaꞌni da muzu un. Yukan ti ni taji tuku da tɨjnɨ ga muzu un kuankoyo, ko suni siaꞌan ni ka jaꞌa da tau muzu un. Sava da ni ka ndoꞌo, ti sava ga da ni ka jiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ko iyo vajnuꞌun ga seꞌe yɨɨ chaa un ja kundaꞌu xaan ini da, ti suni ni taji da chaa lulu un kuaꞌan da, chi ndoꞌo ini da, “Va kuandatu chaa ka sajniñu un nuu seꞌe ri, chi ka jini da ja seꞌe ri kuu i”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ko nu ni jaa chaa lulu un yuxeꞌe chaa ka saꞌa jniñu un, ti ni ka kachi da: “Jaꞌa kuu seꞌe yɨɨ jitoꞌo huerta jaꞌa. Vaꞌa ga na kaꞌni yo, ti nava na kendo yo jiin huerta jaꞌa”, ni ka kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yukan na ti ni ka jnɨɨ da chaa lulu un, ni ka jaꞌni da, ti ni ka jan skaña da ndɨyɨ un nuu yuꞌu huerta un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Ja siaꞌan ni kuu, ¿nasa ka ndoꞌo ini ra ja saꞌa chaa xiin huerta un nusa? Xi kiꞌin da ti kaꞌni da chaa ni ka saꞌa jniñu un, ti kuaꞌa da ñuꞌun nuu ɨnga yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Xi tu ka kaꞌu ra nasa kaꞌan nuu tutu Yandios: Yuū ni ka skaña chaa ni ka saꞌa nama jaꞌa, kuu yuū kanuu ga ja ndiso ndɨꞌɨ jikɨ veꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maa Yandios ni saꞌa siaꞌan, ti so naa ini yo ndeꞌe yo jniñu ni kuu jiin yuū jaꞌa. Kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nu ni kaꞌan Jesús siaꞌan, ti chaa ka kuñaꞌnu Israel un, ni ka nduku da nasa kuu jnɨɨ da Jesús, ko ni ka yuꞌu da ndeꞌe da yɨvɨ un. Chi ni ka chaku ini da ja sɨkɨ maa chaa ka kuñaꞌnu un, ni kaꞌan Jesús jnuꞌun un. Yukan ti ni ka xndoo da ya ti kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yukan sa ni ka taji da sava chaa fariseo jiin sava chaa ka yɨꞌɨ jiin Herodes, ja na nduku da nasa kaꞌan da jiin ya ɨnga jnuꞌun, ti siaꞌan na kuu chakuachi da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ni jakoyo chaa un, ti ni ka kachi da: ―Maestro, jini na ja kuu ni ɨɨn chaa yɨñuꞌun, chi kaꞌan ndaa ni, ti tu kiꞌin ni jnuꞌun vasu nasa ka kaꞌan yɨvɨ sɨkɨ ni. Suni tu yuꞌu ni ndeꞌe ni yɨvɨ kuñaꞌnu ga. Chi suꞌva xnaꞌan ndaa ni ichi Yandios nuu i. Ko kachi ni, ¿iyo vaꞌa ja chaꞌu yo xuꞌun puestu nuu gobierno Romano xi tuu nu? ¿Vaꞌa ga ja tu chaꞌu yo nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ko Jesús ja jini vaꞌa ya nasa ka ndoꞌo ini da ja ka jikajnuꞌun da jnuꞌun un, ti ni kachi ya: ―¿Ndoo ka ndoꞌo ñaa ini ra ja ka kuni xndaꞌu ra ruꞌu naa ra, ja ka kuni ra chakuachi ra sɨkɨ ri? Chan ɨɨn xuꞌun na Kotonchaa ri ―kachi ya jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ti ni ka jaꞌa da ɨɨn xuꞌun nuu ya. Yukan na ti ni kachi ya: ―¿Naa nūū kuu ja nchaa nuu xuꞌun jaꞌa, ti naa sɨvɨ kuu ja yoso nuu xuꞌun jaꞌa nusa? ―kachi ya. Ti ni ka kachi da: ―Nūū maa rey nación Roma kuu ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yukan na ti ni kachi Jesús: ―Nusa ti kuaꞌa nuu rey nación Roma ja xiin maa da, ti kuaꞌa nuu Yandios ja xiin maa Yandios ―ni kachi ya. Ti so ni ka naa ini da jnuꞌun ni kaꞌan Jesús jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Suni ni ka kikoyo tɨjnɨ chaa Saduceo nuu Jesús, chaa ka kaꞌan ja tukaa ga ka nandoto kuɨtɨ ndɨyɨ. Ti ni ka kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, nuu ley Moisés kaꞌan ja nu ɨɨn chaa ni nandaꞌa, ti nu na kuū da, ti xndoo da ñasɨꞌɨ da. Ti nu tu ni ɨɨn seꞌe da ni iyo, ti ñani ndɨyɨ un nandaꞌa tuku jiin ñaꞌan un nava na koo ɨɨn seꞌe da jiin ña, ja tu ni iyo seꞌe ña jiin ndɨyɨ un. Ti suchi lulu un nakiꞌin yɨ sɨvɨ ndɨyɨ un, ti kendo i jiin tendɨꞌɨ yaji ni xiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ko ɨɨn jinu ni iyo uxia chaa ni ka kuu ñani, ti chaa ñaꞌnu un ni nandaꞌa da, ko ni jiꞌi da, ti tu ni iyo ni ɨɨn seꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ti chaa kuu uu un, ni nandaꞌa jiin ñaꞌan un, ko suni ni jiꞌi da, ti tu ni iyo ni ɨɨn seꞌe da jiin ña. Ti suni siaꞌan ni jnaꞌan chaa kuu uni. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Siaꞌan ni kuu jiin ndɨ uxia da, vasu ni ka nandaꞌa da jiin ñaꞌan un, ko tendɨꞌɨ da ni ka jiꞌi, ti tu ni ka iyo ni ɨɨn seꞌe da jiin ña. Ti sandɨꞌɨ ni ga suni ni jiꞌi ñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nusa ti nu na nandoto ndɨyɨ un ti kuchaku tuku da, ¿nau ɨɨn ɨɨn da xiin ñasɨꞌɨ un, ja siaꞌan ndɨ uxia da ni ka nandaꞌa jiin ña nusa? ―kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yukan na ti ni kachi Jesús jiin da naa da: ―Ka yuji ra jnuꞌun ka kaꞌan ra naa ra, chi va tu ni ka chaku ini ra nava yoso nuu tutu ii. Ni tu chaku ini ra ɨɨn jniñu ñaꞌnu saꞌa Yandios. Yukan kuu ja ka kaꞌan ra siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ko kɨvɨ na nandoto ndɨyɨ un naa i, tukaa kuu i nanu ni kanda i nuu ñuyɨvɨ jaꞌa. Ni tu nandaꞌa i, ni tu xnandaꞌa i sesɨꞌɨ i, chi kuu i nanu ángel Yandios kanchuku nuu andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ti sɨkɨ jnuꞌun ja nandoto ndɨyɨ un, ti ka chaku ini ra, xi tu ka kaꞌu ra nuu tutu ni chaa Moisés, nuu kachi ja maꞌñu yañuꞌun un ni kaꞌan Yandios jiin da, ti ni kachi ya: “Ruꞌu kuu Yandios ni ka nchañuꞌun Abraham, Isaac jiin Jacob.” ");
INSERT INTO mpmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Siaꞌan ni kaꞌan Yandios jiin Moisés, chi maa ya kuu Yandios yɨvɨ ka chaku, ansu Yandios yɨvɨ ni ka jiꞌi. Yukan kuu ja ka yuji ra naa ra jiin jnuꞌun ka kaꞌan ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ti ɨɨn chaa xnaꞌan ini veñuꞌun Israel kande da un, ti ni jinisoꞌo da jnuꞌun ndajnuꞌun Jesús jiin chaa un. Ni jini da ja vaꞌa kaꞌan ya, ti ni jikajnuꞌun da ya: ―¿Nau ɨɨn ley Yandios kuu ja kanuu xaan ga nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti ni kachi Jesús. ―Ɨɨn ley Yandios ja kanuu xaan ga kuu jaꞌa: “Chunsoꞌo naa ra roꞌo yɨvɨ Israel. Tata yo Yandios maa ɨɨn ni ya iyo. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Na kuu ini ra Tata yo Yandios jiin nɨ ini nɨ añu ra, jiin ndɨꞌɨ inijnuni ra, ti jiin nɨini ra kunukuachi ra nuu ya.” Yukan kuu ley undi nuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ti ɨnga ley kanuu xaan kuu jaꞌa: “Kundaꞌu ini nuu ñanijnaꞌan ra nanu kundaꞌu ini ra nuu maa ra.” Ndɨnduu ley yukan kuu ja kanu xaan ga siuku ra, ti tukaa iyo ɨnga ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yukan ti ni kachi chaa xnaꞌan ley jiin Jesús: ―Vaꞌa ni kaꞌan ra, Maestro. Jandaa kaꞌan ra ja maa ɨɨn ni Tata yo Yandios iyo, ti tukaa iyo ɨnga, ");
INSERT INTO mpmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ja na kuu ini yo nuu Yandios jiin nɨ ini nɨ añu yo, jiin inijnuni yo, ti jiin nɨini yo na kunukuachi yo nuu ya. Ti na kundaꞌu ini yo nuu ñanijnaꞌan yo nanu kundaꞌu ini yo nuu maa yo. Chi kanuu xaan ga ndixia uu ley jaꞌa ja na kuandatu yo, ti ansu ja soko yo taka ja ñavaꞌa yo nuu altar un ―kachi da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ni jini ya ja ni ka kaꞌan ndaa kuɨtɨ da, ti ni kachi ya: ―Ja kuan kuyajni ndɨvɨkoyo ra ndaꞌa Yandios ja taꞌu ya jniñu nuu ra ―kachi ya. Yukan ti ni ɨɨn chaa ka kuñaꞌnu un tukaa ni ka kaꞌan kuɨtɨ ga da ja kajnuꞌun ga da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nu ni xnaꞌan Jesús ini veñuꞌun kaꞌnu Israel yukan, ni kachi ya: ―¿Nasa kuu ja ka jani ini chaa ka xnaꞌan ini veñuꞌun un, ti ka kaꞌan da ja Cristo kuu seꞌe nuu tata yo David na janaꞌan? Ko na kachi ndaa ri ja kuñaꞌnu ga Cristo nuu tata yo David. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti maa David ni chaa da nuu tutu jiin inijnuni Espíritu Santo nuu kachi siaꞌan: Maa Yandios ni kachi siaꞌan jiin Cristo, ya kuu jitoꞌo ri: “Nukoo ndaꞌa kuaꞌa ri, chi taꞌu ra jniñu jiin ri. Iyo yɨvɨ jito uꞌu roꞌo, ko kundee ra jiin, chi chindee ri roꞌo.” Ni kachi Yandios, kachi David. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nusa, ¿ti nasa kuu Cristo ɨɨn jnaꞌan rey David janaꞌan, ti maa da ni kachi ja Cristo kuu jitoꞌo da nusa? ―ni kachi Jesús. Ti nu ni kaꞌan ya siaꞌan, ti ni ka kusɨɨ ini yɨvɨ kuaꞌa kaꞌiin un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Siin Jesús xnaꞌan ya, ti ni kachi ya: ―Koto maa ra jiin chaa ka xnaꞌan ley ini veñuꞌun un. Koto saꞌa ra nava ka saꞌa da naa da. Chi chaa un ka jajnaꞌan ini da kuꞌun da saꞌma nani nava na nakuni yɨvɨ ja chaa kuñaꞌnu ka kuu da. Ti nu ka jikonuu da calle un, kuni da ja na kanxiaꞌu yɨñuꞌun yɨvɨ jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ti ja kuu ini veñuꞌun ka nduku da nuu nukoo da nuu kuñaꞌnu ga kunchuku da. Suni ja kuu ɨɨn viko, xnaka da ka nukoo yuꞌu mesa nuu iyo vaꞌa ga. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Suni ka jisonchaa da veꞌe ñaꞌan ni ka kendo ndaꞌu, ti ja na chisaꞌyɨ da jniñu ni ka saꞌa da un, ti naꞌan xaan ka jikantaꞌu da nuu Yandios. Siaꞌan ka saꞌa da nuu chitu yɨvɨ. Ko ja kuu maa da, kii ɨɨn nundoꞌo kaꞌnu xaan ga ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ɨɨn kɨvɨ nukoo Jesús nuu veñuꞌun kaꞌnu un, yajni nuu kancha ɨɨn kaja nuu kɨvɨ xuꞌun ka soko yɨvɨ. Ndeꞌe ya ka chuꞌun ka chuꞌun yɨvɨ xuꞌun nuu kaja un. Ni jini ya ja taka yɨvɨ riko, kuaꞌa xuꞌun ka chuꞌun nuu kaja un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ti sandɨꞌɨ ni ga ni jaa ɨɨn ñaꞌan ndaꞌu xaan, ti ni chuꞌun ña uu xuꞌun cobre kuachi ini kaja un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yukan ti ni kana Jesús ndajaꞌa ya, ti ni kachi ya jiin da: ―Ndeꞌe naa ra. Ñaꞌan un, yaꞌu xaan ga nchaa xuꞌun ni jaꞌa ña nuu Yandios ansu xuꞌun ni ka jaꞌa chaa riko un. ");
INSERT INTO mpmNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chi yɨvɨ riku un ka jaꞌa da jaku ni ja ka ñavaꞌa da. Ko ñaꞌan ndaꞌu un, vasu nandɨꞌɨ ña ja kuu gastu ña, ko ni soko ndɨꞌɨ ña nuu Yandios ―ni kachi ya jiin da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nu ni kee Jesús veñuꞌun kaꞌnu un, ti ɨɨn ndajaꞌa ya ni kachi jiin ya: ―Maestro, ndeꞌe ni. Xaan naꞌnu yuū jaꞌa, ti xaan vii kaa veñuꞌun jaꞌa―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ti ni kachi Jesús: ―Ndixia ra chi vii xaan kaa, ko jaa ɨɨn kɨvɨ ja ni ɨɨn yuu tukaa kendo kosojnaꞌan, chi ndɨꞌɨ jaꞌa naa ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yukan ti kuankoyo da undi yuku Olivo, ja kendo yajni ichi nuu yuxeꞌe veñuꞌun kaꞌnu un, ti ka tuꞌva Pedro, Jacobo, Juan jiin Andrés, ti ni ka jikajnuꞌun da ya: ");
INSERT INTO mpmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¿Naa kɨvɨ kundaa jnuꞌun ni kaꞌan ni ja naa veñuꞌun kaꞌnu un? ¿Ti naa seña kuni na nu ja kuan kuyajni kundaa jnuꞌun jaꞌa? ―ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ti ni kachi ya jiin da: ―Koto maa ra naa ra nava tu xndaꞌu yɨvɨ roꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chi kuaꞌa yɨvɨ kikoyo, ti ndaku niꞌin yɨ sɨvɨ ri, ti kachi yɨ ja maa i kuu Cristo, ko so ja na xndaꞌu i kuaꞌa xaan yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ti nu ni ka jini ra ja iyo guerra, xi ja koo guerra, koto yuꞌu ra. Siaꞌan kuu, ko changa ga jaa kɨvɨ ndɨꞌɨ ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chi kanaa ɨɨn nación jiin ɨnga nación. Suni kanaa ɨɨn ñuu jiin ɨnga ñuu, ti koo guerra taka ñuu. Suni kii ñujnaa ya yukan, ti koo jnama xaan tonto, ti ndɨꞌɨ xaan ini yɨvɨ. Ko ansu jaꞌa ni kuu ndɨꞌɨ, chi sa ni kejaꞌa nundoꞌo un, ti suꞌva kii ga ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Siin Jesús kaꞌan, ti ni kachi ya: ―Koto ra maa ra chi ɨɨn kɨvɨ ti jnɨɨ yɨvɨ presu roꞌo, ti kiꞌin ra nuu juez jiin nuu chaa ka kuñaꞌnu ini taka veñuꞌun Israel, ti kani da roꞌo naa ra. Ti undi nuu ndajaꞌa gobierno stuu ra maa ra ja ka kandixia ra ruꞌu jiin jnuꞌun kaꞌan ri. Chi siaꞌan ti sa kunisoꞌo da jnuꞌun ichi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chi xnakan kuichanuu jnuꞌun Yandios nuu yɨvɨ taka nación ti sa ndɨꞌɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ti nu ni ka jnɨɨ yɨvɨ presu roꞌo, tu xndɨꞌɨ ra ini ra ja nasa koo jnuꞌun kaꞌan ra nuu justicia. Chi hora kuaꞌa ra jandaa nuu da, ti maa Espíritu Santo kuaꞌa taka jnuꞌun kaꞌan ra un. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti yɨvɨ un naa i, nakuaꞌa yɨ ñani yɨ nuu sticia ja na kaꞌni da i sɨkɨ ja ka kandixia ra ruꞌu. Ko nu nau ja tu kaka yata, ti siin ndaa kuɨtɨ jiin jnuꞌun ri undi kɨvɨ sandɨꞌɨ ni ga, ti yɨvɨ un kuu ja nanitaꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ti taka ñuu koto uꞌu yɨvɨ roꞌo naa ra sɨkɨ ja ka kandixia ra ruꞌu. Ko nu nau ja tu kaka yata ti siin ndɨ kuɨtɨ jiin jnuꞌun ri undi kɨvɨ sandɨꞌɨ ni ga, ti yɨvɨ un kuu ja na nitaꞌu ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Siin kaꞌan Jesús, ti ni kachi ya: ―Nu ni ka jini ra ja kandichi ɨɨn ndajniñu kueꞌe nuu veꞌe ii ini veñuꞌun kaꞌnu un, yukan ti yɨvɨ kaꞌu tutu jaꞌa na chaku ini i nau ja kuu. Ti yɨvɨ kanchuku ñuu Judea, na kuaꞌa i corrɨ na nama i maa i undi chii yuku un. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nu ɨɨn yɨvɨ ndetatu i yuxeꞌe i, koto ndɨvɨ i ini veꞌe i ja kiꞌin yɨ ndajniñu i. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ti yɨvɨ kande ɨɨn rancho, koto nandeokuñɨ i veꞌe i ja kiꞌin i saꞌma i. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na ndaꞌu ñaa ka ñuseꞌe xi ñaa ka nchaka suchi yɨkɨn, chi tu kanda ña kunu yachi ña ja kuu kɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kakantaꞌu naa ra nuu Yandios ja tu kuaꞌa ya jnuꞌun kondoꞌo ra yukan ja kuu ɨɨn viko sau xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi kɨvɨ un koto ra nundoꞌo kaꞌnu xaan tonto ja tu ni ka ndoꞌo ra undi na ni saꞌa Yandios ñuyɨvɨ. Ti ni tukaa ga koo ɨnga nundoꞌo nanu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko sa ti tu ni xnukuu Yandios kɨvɨ un, ti va ni ɨɨn yɨvɨ tu kaku. Ko ni xnukuu ya kɨvɨ un sɨkɨ ja ni kundaꞌu ini ya taka yɨvɨ ni nakaji ya ja na nanitaꞌu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Siin kaꞌan Jesús, ti ni kachi ya: ―Nu ni jaa kɨvɨ un, koto kandixia ra naa ra jnuꞌun kaꞌan yɨvɨ ti kachi: “Ndeꞌe, jaꞌa kancha Cristo ja ni taji Yandios ja taꞌu jniñu ñaꞌnu”, xi kachi: “Ndeꞌe, yukan kancha ya.” ");
INSERT INTO mpmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi kikoyo kuaꞌa yɨvɨ xndoñaꞌan, ti kachi i ja maa i kuu Cristo, xi kachi ja kuu ɨɨn chaa kaꞌan jnuꞌun Yandios. Ti saꞌa i tɨjnɨ nuu jniñu ñaꞌnu ja na xndoñaꞌan i yɨvɨ ka kandixia. Nu na kuu, ti suni xndaꞌu yɨvɨ ni nakaji Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ko koto kandixia ra naa ra ja xndaꞌu yɨvɨ un roꞌo, chi ja ni kachi ri taka seña kii ja kuni ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ko nu ja ni ndɨꞌɨ ni kii nundoꞌo un, yukan ti kuñaa nuu ndikandii, ti yoo, tukaa ga kuaꞌa nduva. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ti nukoyo chuxini nuu andɨvɨ, ti nɨꞌɨn nɨ tuꞌu ja iyo nuu andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yukan na ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kuni ra ndenda ri nuu viko un, ti nchaa ri jiin jniñu ñaꞌnu xaan ga. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ti taji ri Yandios kinkoyo undi sandɨꞌɨ ni ga ndɨ kuun jikɨ ñuyɨvɨ jiin andɨvɨ, ti nastutu i taka yɨvɨ ni nakaji Yandios ja kuu seꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ndeꞌe ra ɨɨn nutɨchɨ vixi ti kuni ra. Nu ja ni ndɨꞌɨ ni nakoyo ndaꞌa yujnu un ti vee nene numa, yukan ni jini yo ja kuan sama kɨvɨ ti kuan kuyajni viko sau. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Siaꞌan kuu jiin ra naa ra, chi nu ja ni ndɨꞌɨ nundoꞌo un kuan kundaa, yukan ti chaku ini ra ja kuan kuyajni ndaa ni ga kɨvɨ nchaa ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chi na kachi ndaa ri ja taka yɨvɨ ka chaku vijna, tu naa i undi na jaa kɨvɨ kundaa taka jnuꞌun kaꞌan ri jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ti andɨvɨ jiin ñuyɨvɨ ndɨꞌɨ kuɨtɨ naa, ko jnuꞌun kaꞌan ri chi jankɨvɨ naa, ti ndɨꞌɨ un kundaa. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ko ja kuu kɨvɨ un, maa Yandios kuu ja jini na kɨvɨ kundaa taka jnuꞌun un. Ni ángel Yandios tu ka jini, ni ruꞌu ja kuu ri seꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ko roꞌo naa ra, kundito ini ra, chi ni tu ka jini ra na kɨvɨ kundaa taka jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","35","Kuu nanu ɨɨn chaa kuaꞌan viaje, ti tu ni kachi da na kɨvɨ nchaa da. Ti ni xndoo da muzu da ja na koto tendɨꞌɨ jniñu iyo. Ni tejnaꞌan da jniñu nuu ɨɨn ɨɨn muzu un. Ti ni taꞌu da jniñu nuu ɨnga muzu ja na koto veꞌe da. Ko muzu un naa da, tu ka jini da na kɨvɨ nchaa jitoꞌo da. Suni siaꞌan roꞌo naa ra, tu ka jini ra na kɨvɨ nchaa ri. Yukan kuu ja kotuꞌva naa ra, chi tu ka jini ra nu nchaa ri kuan kuu tɨkɨꞌvɨ, xi nchaa ri ñúú, xi hora kana liꞌi ni ga, xi kuan kuxian ni ga ti nchaa ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chi sanaa ini ra naa ra ti nchaa ri, ti na niꞌin ri roꞌo ka kixi ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jnuꞌun kaꞌan ri jiin ra naa ra, suni siaꞌan kaꞌan ri jiin tendɨꞌɨ yɨvɨ naa i. Yukan kuu ja kotuꞌva naa ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ka nasaꞌa chaa Israel uu viko ja tu ka naa ini da na ni keniꞌin Yandios maa da naa da ñuu Egipto, ja ni kundaꞌu ini ya maa da. Ti viko un kuu viko pascua, jiin viko ka yee da staa stila tu yɨꞌɨ levadura. Ko kumani uu ga kɨvɨ ja kuu viko un. Ti sutu ka kuñaꞌnu jiin chaa ka xnaꞌan ley ini veñuꞌun un, ka kuni jnɨɨ xeꞌe da Jesús, ti kaꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ko ka ndajnuꞌun da: ―Tu kuu saꞌa yo kɨvɨ viko jaꞌa, chi sandau ndondaa yɨvɨ sɨkɨ yo ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yukan ti kancha Jesús veꞌe Simón ñuu Betania, ɨɨn chaa ni jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu. Nukoo ya yuꞌu mesa yee ya staa. Ti yukan ni jaa ɨɨn ñasɨꞌɨ yɨndaꞌa ña ɨɨn tɨndoꞌo lulu alabastro. Ti ñuꞌun chitu aceite perfume mani ita nardo, ja nchaa yaꞌu xaan tonto. Ni taꞌu ña tɨndoꞌo lulu un, ti ni chuꞌun ña perfume un xini Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ti sava yɨvɨ kanchuku un, tu ni ka jajnaꞌan ini i jniñu saꞌa ña un. Ti ni ka kaꞌan i: ―Tu stɨvɨ ña un perfume un siaꞌan niku. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sa ti ni kuyaꞌu, ti niꞌin ña xuꞌun ti kuu tejnaꞌan yo nuu yɨvɨ ndaꞌu niku ―kachi da. Ti ni ka kɨtɨ ini da nuu ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko ni kachi ya jiin da: ―Sia ña, ndoo ka skɨtɨ ra ini ña. Jniñu ni saꞌa ña jiin ri, iyo vaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yɨvɨ ndaꞌu, chi nɨnɨ kanchuku i jiin ra naa ra, ti nu ka kuni ra ti kuu chindee ra i. Ko ruꞌu, chi ansu siaꞌan ni kuncha ri jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ñaꞌan jaꞌa ni saꞌa ña nava iyo ini ña, chi ja ni chiꞌi tuꞌva ña perfume yɨkɨ kuñu ri ja kuu kɨvɨ kuū ri. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kuni ra ja nɨ tuꞌu ñuyɨvɨ, savaꞌni ga nanu na kaꞌan i jnuꞌun ri ja na sketaꞌu ri yɨvɨ, ti kani i jnuꞌun jniñu ni saꞌa ña jaꞌa ja na nukuꞌun ini yɨvɨ un maa ña ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yukan ti Judas, ɨɨn chaa ñuu Cariote, ja suni kandee da jiin ndɨ uxi uu ndajaꞌa un naa da, ni jaꞌan ndajnuꞌun da jiin sutu ka kuñaꞌnu un, ti ni kachi da ja nakuaꞌa da Jesús nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nu ni ka jinisoꞌo chaa un jnuꞌun ni kaꞌan Judas, ni ka kusɨɨ xaan ini da, ti ni ka kaꞌñu da xuꞌun nuu da. Yukan ti ni kejaꞌa nduku da nasa nakuaꞌa da Jesús nuu chaa un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Maa kɨvɨ kejaꞌa viko ka yee staa stila tu yɨꞌɨ levadura un, suni kɨvɨ un ka jaꞌni da lélú ja ka soko da ja kuu viko pascua. Ti ndajaꞌa ya ni ka jikajnuꞌun da ya: ―¿Nanu kuni ni ja na kin satuꞌva na ja kuxini yo vijna pascua? ―kachi da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yukan na ti ni taji ya uu da, ti ni kachi ya jiin da: ―Kuaꞌan naa ra undi ñuu, ti yukan ndejnaꞌan ra jiin ɨɨn chaa ndiso ɨɨn kɨyɨ nducha, ti kundikun ra da kiꞌin ra jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti nuu ndɨvɨ da un, yukan kaꞌan ra jiin maa chaa xiin veꞌe un: “Kachi maa Maestro na ja nanu iyo ɨɨn veꞌe ja kuaꞌanuu ni nuu kuxini da jiin ndajaꞌa da vijna kɨvɨ pascua”, kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ti maa da na xnaꞌan nuu ra ɨɨn veꞌe kaꞌnu ja kendo piso nuu sukun, ti yukan ja iyo nakoo, ti satuꞌva ra naa ra ja kuxini yo ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ti kuankoyo da undi ñuu un, ti ni ka naniꞌin da taka nava ni kachi Jesús. Yukan ni ka satuꞌva da ja kuxini. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nu ni kuaa, ti ni jaa Jesús veꞌe un jiin ndɨ uxi uu ndajaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ti nu kanchuku da ka yee da staa nuu mesa un, ni kachi Jesús jiin da naa da: ―Jandaa na kachi ri ja ɨɨn roꞌo ja yee staa jiin ri jaꞌa, nakuaꞌa ruꞌu nuu chaa ka jito uꞌu ruꞌu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ti ndajaꞌa un ni ka kukuiꞌya xaan ini da ja siaꞌan ni kaꞌan ya. Ti ndɨ ɨɨn ndɨ ɨɨn da ni ka kachi: ―¿Xi saña kuu nu? ¿Xi saña kuu nu? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ti ni kachi ya: ―Ja ndɨ uxi uu roꞌo naa ra ɨɨn ra kuu, ja chutoo staa stila nu koꞌo ri, yukan kuu. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kundaa nava yoso nuu tutu Yandios ja nakuaꞌa da maa seꞌe Yɨvɨ Ñuyɨvɨ nuu chaa ka jito uꞌu ya. Ko xaan ga kaꞌnu nundoꞌo kondoꞌo chaa kin nakuaꞌa ruꞌu. Sa nu tu ni kaku da niku ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nɨ ka yee da staa. Ti ni kiꞌin Jesús ɨɨn staa stila, ni jikantaꞌu ya nuu Yandios, ni sakuachi ya, ti ni tejnaꞌan ya nuu ndajaꞌa ya, ti ni kachi ya: ―Kaji naa ra. Jaꞌa kuu nanu yɨkɨ kuñu ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yukan na ti ni kiꞌin ya ɨɨn vaso vino, ni nakuantaꞌu ya nuu Yandios, ti ni jaꞌa ya nuu da ja na koꞌo da tɨꞌlɨ tɨꞌlɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ti ni kachi ya jiin da: ―Ti nɨñɨ ri un stuu ja ni saꞌa Tata ri Yandios ɨɨn tratu jaa. Ti yukan kuu ja kaꞌan ndaa kuɨtɨ ja nama ri sɨkɨ kuaꞌa xaan yɨvɨ, chi nɨñɨ ri ja katɨ ri kiꞌin, yukan kuu ja chunaa ri nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ko na kachi ndaa ri ja tukaa ga koꞌo ri vino jaꞌa jiin ñanijnaꞌan yo, kɨvɨ ka nasaꞌa i viko jaꞌa, undi na jaa kɨvɨ koꞌo yo nuu kancha Tata ri Yandios, chi yukan kuu nuu niꞌin ri ɨɨn jniñu ñaꞌnu ga, ti yukan taꞌu ri jniñu jiin maa ya nuu tendɨꞌɨ nɨ tuꞌu ja iyo. Ti yukan kuu nuu nasaꞌa jaa yo viko jaꞌa naa yo ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ni ndɨꞌɨ ni ka kuxini da, ti ni ka jita da ɨɨn himno, ti kuankoyo da undi yuku Olivos. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yukan ti ni kachi Jesús: ―Tendɨꞌɨ ra naa ra kuichanuu ti xndoo ra ruꞌu jakuaa vijna, chi siaꞌan kaꞌan nuu tutu Yandios: “Chi Yandios, kuaꞌa ya jnuꞌun ja na kuū pastor, ti rɨɨ da un kuichanuu tɨ kiꞌin tɨ.” ");
INSERT INTO mpmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko kɨvɨ na nandoto ri, ti koxnuu ri kiꞌin ri ñuu Galilea, ti yukan kundatu ri roꞌo naa ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yukan na ti ni kachi Pedro: ―Vasu tendɨꞌɨ da na xndoo niꞌin, ko saña tu xndoo kuɨtɨ na maa ni ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ti ni kachi Jesús jiin da: ―Jandaa na kachi ri nuu ra, ja kuu jakuaa vijna, nu ti kana ga liꞌi uu jinu, ti kachi ra uni jinu ja tu jini ra ruꞌu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ko Pedro, nɨ ini da kaꞌan da: ―Vasu na kuū na jiin ni, ko tu xndoo kuɨtɨ na niꞌin ―kachi da. Ti tendɨꞌɨ ndajaꞌa ya un, suni siaꞌan ni ka kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nu ni ka jakoyo da nuu nani Getsemaní, ti ni kachi ya jiin da naa da: ―Jaꞌa ni kunchuku ra ti ruꞌu na kin kankantaꞌu ri nuu Yandios ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yukan ti kuaꞌan ya tɨꞌlɨ ga ichi ndaku un jiin Pedro, Santiago jiin Juan. Ti ni kejaꞌa kukuiꞌya xaan ini ya, ti kaña ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ti kachi ya jiin da: ―Jatu añu ri ja kukuiꞌya xaan ini ri, chi ja ni kuyajni kuū ri. Ko jaꞌa ni kundatu ra naa ra ti koto kusu ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yukan na ti ni jika ya tɨꞌlɨ ga, ti ni jakunjitɨ ya, ti jikantaꞌu ya, ja nu kuni Yandios, ti tu kondoꞌo ya nundoꞌo kii nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ti ni kachi ya: ―Tata maa na, ja kuu maa ni, taka ni ja kuu saꞌa ni. Nusa ti chajiyo ni saña nuu nundoꞌo vaji nuu na. Ko ansu nava kuni maa na, chi nava kuni maa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yukan na ti na nandeokuñɨ ya nuu kaꞌiin ndajaꞌa ya un, ko ni jini ya ja ka kixi da, ti ni kachi ya jiin Pedro: ―Simón, ¿ja kixi ra nu? Tu ni kuu kundito ra vasu ɨɨn hora nusa. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Koto kusu ga ra naa ra. Kanajaa, ti kakantaꞌu nuu Yandios ja na kotuꞌva ra nava tu kotojnuni jaꞌuꞌu un oꞌo, ti chisaꞌyɨ ra ruꞌu, kachi ra ja tu ka jini ra ruꞌu. Chi vaꞌa ndiyo ini ra ja siuku ra, ko yɨkɨ kuñu ra, chi tu iyo ndee ini. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yukan ti kuaꞌan tuku ya, ti ni jikantaꞌu ya, ti suni jnuꞌun un ni kaꞌan tuku ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nu ni nandeokuñɨ tuku ya, ni jini ya ja ka kixi tuku da, chi ka jiꞌi xaan da maꞌna ja undi ka kuvee nduchi da, ti tu ni kujnuni nasa kachi da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ti nu ni nandeokuñɨ ya jinu kuu uni, ni kachi ya jiin da: ―Vijna na, ndetatu ti kusu naa ra. Ko ja ni jaa hora ja ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa da ruꞌu nuu yɨvɨ ka nchakuachi. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndoko naa ra na choꞌo, chi ja vaji chaa ni nakuaꞌa ruꞌu un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ni kaꞌan ga Jesús siaꞌan, ti ja ni chaa Judas, ɨɨn ja ni kuu ndɨ uxi uu ndajaꞌa un. Ti vekoyo yɨvɨ kuaꞌa jiin da, ka yɨndaꞌa i espada jiin yujnu. Vekoyo i jiin jniñu ni ka taꞌu taka sutu ka kuñaꞌnu jiin chaa ka xnaꞌan ini veñuꞌun kaꞌnu un jiin taka chaa ka kuñaꞌanu ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ichi kuankoyo da ni kachi Judas jiin chaa un naa da: ―Chaa teyuꞌu ri nuu, chaa un kuu ja nanduku yo. Jnɨɨ naa ra. Koto sia ra kiꞌin ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ti nu ni jaa Judas, ni tuꞌva da nuu Jesús, ti ni kachi da: ―Maestro, maestro ―kachi da. Ti ni teyuꞌu da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yukan ti chaa un ni ka jnɨɨ ni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ti ɨɨn chaa kaꞌiin jiin Jesús un, ni jista da espada da, ti ni jaꞌncha da soꞌo ɨɨn muzu sutu kuñaꞌnu ga. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yukan na ti ni kachi Jesús jiin chaa ni ka jnɨɨ ya un: ―¿Va nu ɨɨn ñakuiꞌna kuu ri ja vekoyo ra jiin espada jiin yujnu ja jnɨɨ ra ruꞌu kiꞌin ri presu nu? ");
INSERT INTO mpmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ti taka kɨvɨ ni xnaꞌan ri nuu ra naa ra ini veñuꞌun kaꞌnu un, ti tu ni ka jnɨɨ ra presu ruꞌu. Ko siaꞌan kuu ja na kundaa nava kaꞌan nuu tutu Yandios ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ti yukan tendɨꞌɨ ndajaꞌa ya ni ka jinu da kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ko ɨɨn chaa lulu ni chindikun da jata yɨvɨ kuankoyo jiin Jesús, ti suku da nɨnɨ ɨɨn saꞌma, ti suni ni ka jnɨɨ chaa un maa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ko ni keniꞌni chaa lulu un chii saꞌma un, ti vichi lɨɨ da, ko ni kundee da kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yukan ti kuankoyo yɨvɨ un jiin Jesús undi veꞌe ɨɨn sutu kuñaꞌnu ga, chi yukan ni ka ndututu taka sutu ka kuñaꞌnu un, taka chaa ka kuñaꞌnu jiin taka chaa ka xnaꞌan ley ini veñuꞌun kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ti Pedro ndikun jika da ichi jata chaa kuankoyo jiin Jesús, ni kɨvɨ da yuxeꞌe palacio un, ti ni nukoo da jiin policía un ka nanduxin da yunuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ti sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌanu ñuu Israel, ka nduku da nasa kaꞌan kuachi ga da sɨkɨ Jesús, chi ka kuni kaꞌni da ya. Ko tu kujnuni na jnuꞌun ga kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ti kuaꞌa yɨvɨ ni ka xndoñaꞌan, ja ka chakuachi sɨkɨ Jesús, ko tu ni kejnaꞌan kuɨtɨ jnuꞌun ka kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ti sandɨꞌɨ ni ga ni ka ndokuɨñɨ sava da, ti ni ka kankuachi da sɨkɨ ya siaꞌan: ");
INSERT INTO mpmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Saña naa na, ni ka jinisoꞌo na jnuꞌun ni kaꞌan da: “ruꞌu, xnaa ri veñuꞌun jaꞌa, ja ni ka saꞌa yɨvɨ naa i jiin ndajaꞌa i, ti nuu uni kɨvɨ, ti na saꞌa tuku ri ɨnga veñuꞌun ja tu kuu jiin ndaꞌa yɨvɨ”, siaꞌan ni kachi chaa jña ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko vasu siaꞌan, tu ni kejaꞌan tuku jnuꞌun ka kaꞌan da sɨkɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yukan na ti ni ndokuɨñɨ maa chaa kuu sutu kuñaꞌnu ga un nuu chitu un, ti ni jikajnuꞌun da Jesús: ―¿Tu kaꞌan kuɨtɨ ra nusa? ¿Xi jandaa kuu jnuꞌun ka kaꞌan da sɨkɨ ra nu? ―kachi da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ko Jesús tu ni kaꞌan kuɨtɨ ya. Yukan na ti ni jikajnuꞌun tuku sutu kuñaꞌanu un ya: ―Kachi nu maa ra kuu Cristo, Seꞌe Yandios ii, ja kancha andɨvɨ ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ti ni kachi Jesús: ―Maa ri kuu, ti kuni ra naa ra ja maa Seꞌe Yɨvɨ Ñuyɨvɨ, nukoo ya ndaꞌa kuaꞌa Yandios ti kuñaꞌnu ya jiin ya. Suni kuni ra nchaa ya ñuyɨvɨ jaꞌa nuu viko andɨvɨ un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nu ni jinisoꞌo sutu ñaꞌnu ga un, ni ndata da saꞌma da ja ni kɨtɨ ini da, chi ni ndoꞌo ini da ja yɨsɨkɨnchaa Jesús maa Yandios jiin jnuꞌun un. Ti ni kachi da jiin yɨvɨ kaꞌiin un: ―¿Nau ɨnga testigo nandɨꞌɨ yo jaꞌa naa yo? ");
INSERT INTO mpmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ja ni ka jinisoꞌo ra ja kaꞌan ndevaꞌa da sɨkɨ Yandios. ¿Nasa ka ndoꞌo ini ra naa ra? ―kachi da. Ti tendɨꞌɨ yɨvɨ un ni kachi ja na kuū ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yukan na ti sava yɨvɨ un ni ka tɨvɨ sɨꞌɨ nuu ya. Ni ka jasɨ nduchi ya jiin saꞌma, ti ni ka kani jikɨ nuu ya, ti kachi: ―roꞌo chaa kaꞌan jnuꞌun Yandios, kachi nau ja ni kani roꞌo ―kachi jiin ya. Yukan na ti soldado kaꞌiin un, ni ka jaꞌa jikɨ nuu ya. Yukan kuu ja ni jnaꞌan Jesús nu ni ka xndichi da ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti nukoo Pedro nuu yuxeꞌe un, ti ɨɨn ñaꞌan junukuachi veꞌe sutu kuñaꞌanu ga un, ni yaꞌa ña ichi chukan. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ti nu ni jini ña nduxin da ñuꞌun, ni ndeꞌe vaꞌa ña nuu da, ti ni kachi ña: ―roꞌo, suni ni yaku ra jiin Jesús, chaa ñuu Nazaret un ―kachi ña jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko Pedro ni kachi da ja tu jini da: ―Tu jini ri na jnuꞌun kaꞌan ra jiin ri ―kachi da. Ti ni kenda da kuaꞌan da ichi yuxeꞌe un ni jakuɨñɨ da. Ti yukan ni kana ɨɨn liꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ñaa junukuachi un, ni jini tuku ña nuu da, ti ni kejaꞌa kaꞌan ña jiin taka yɨvɨ kaꞌiin un: ―Suni ndajaꞌa chaa yukan kuu chaa jaꞌa ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ko Pedro ni kachi tuku da ja tu jini da. Ni kuu nuu ga, ti chaa kaꞌiin un ni ka kachi da jiin Pedro: ―Ndaa ndixia kuu ja roꞌo kuu ɨɨn ndajaꞌa Jesús un, chi suni chaa Galilea kuu ra ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ko ni kachi tuku Pedro: ―Va kunchakuachi na nu na xndoñaꞌan na, ko kaꞌan ndaa kuɨtɨ na ja tu jini na chaa ka kaꞌan ni un ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ko nɨ kaꞌan ga da siaꞌan, ti ni kana liꞌi jinu kuu uu. Ti yukan ni nukuꞌun ini da jnuꞌun ni kaꞌan Jesús: “Nu ti kana ga liꞌi jinu kuu uu, ti kachi ra uni jinu ja tu jini kuɨtɨ ra ruꞌu.” Ti yukan ni nakani xaan ini da, ti ni jakunchaa da ndeꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nu ni kundijin ɨnga kɨvɨ, ni ka ndajnuꞌun sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌnu, suni chaa ka xnaꞌan ley ini veñuꞌun kaꞌnu Israel, jiin uu ga chaa ka kuñaꞌnu ñuu un. Ka ndajnuꞌun da nasa saꞌa da jiin Jesús, ja ni ka jnɨɨ da ya. Yukan na ti ni ka juꞌni da ya, ti kuankoyo da jiin ya nuu Pilato, chaa kuu gobernador. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ti Pilato ni jikajnuꞌun da Jesús: ―¿Xi roꞌo kuu Rey, ja taꞌu jniñu nuu nɨ tuꞌu nación Israel nu? ―kachi da. Ti ni kachi Jesús: ―Ruꞌu kuu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ti sutu ka kuñaꞌnu un ni ka chakuachi da tɨjnɨ nuu jnuꞌun sɨkɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ti ni jikajnuꞌun tuku Pilato un ya: ―Ndeꞌe na ka chakuachi da sɨkɨ ra, ¿ti tu kaꞌan kuɨtɨ ra nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko Jesús tu ni kaꞌan kuɨtɨ ya. Ja yukan na ti so ni naa ini Pilato, ti tu kujnuni nasa saꞌa da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taka viko pascua ni iyo ɨɨn jnuꞌun ja na sia Pilato ɨɨn chaa kande vekaa, nau ja na kachi maa yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti kɨvɨ un kande ɨɨn chaa nani Barrabás vekaa jiin tɨjnɨ chaa ni ka ndonda sɨkɨ gobierno, chi ni ka jaꞌni da ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ja yukan kuu ja ni ka jakoyo yɨvɨ un ka jikan i nuu Pilato, ja na sia da ɨɨn presu nava iyo jnuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti ni jikajnuꞌun Pilato nuu yɨvɨ un: ―¿Kuni ra naa ra ja na sia ri chaa kuu Rey nuu nɨ nación Israel nu? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Siaꞌan ni jikajnuꞌun Pilato, chi ni jini da ja ka kuu kuasun ini sutu un, ja kuaꞌa yɨvɨ ni ka kandixia jnuꞌun ni kaꞌan Jesús. Ja sɨkɨ yukan ni ka nakuaꞌa da ya nuu Pilato, ti Pilato kuni sia da Jesús niku. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko sutu ka kuñaꞌnu un ni ka skaꞌan da yɨvɨ ja na kakan i nuu Pilato, ti na sia da chaa nani Barrabás. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yukan na ti ni jikajnuꞌun tuku Pilato yɨvɨ un: ―Nusa ti, ¿ndoo kuni ra naa ra ja saꞌa ri jiin chaa jaꞌa, chaa ka skonani ra Rey nación Israel nusa? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ti ni ka kuvaa yɨvɨ un ka kana koꞌo: ―¡Katakaa ni chaa jña ndaꞌa cruz, na kuū da! ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ti ni kachi Pilato: ―¿Ko nau kuachi ni saꞌa da nusa? ―kachi da. Ti yɨvɨ un viꞌi ga ka kana koꞌo: ―¡Katakaa ni chaa jña ndaꞌa cruz, na kuū da! ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yukan na ti Pilato, ja na kusɨɨ ini yɨvɨ un jiin da, ni sia da Barrabás kuaꞌan da. Ti ni taꞌu da jniñu nuu soldado un ja na kani da Jesús jiin yoꞌo ñɨɨ, ti na kiꞌin da jiin ya ja na kundaka ya ndaꞌa cruz, ti na kuū ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yukan na ti kuankoyo soldado un jiin Jesús undi nuu yuxeꞌe palacio nuu nani Pretorio. Ni ka nastutu jnaꞌan da jiin tendɨꞌɨ ga soldado. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ti ni ka naskuiꞌna da ya ɨɨn saꞌma kuaꞌa ndiꞌi. Ni ka saꞌa da ɨɨn corona iñu, ti ni ka chuxndee da xini ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yukan ti ni ka kejaꞌa ka kanajiin da, ka sakata da nuu ya: ―Na kuchaku naꞌan Rey, chaa ñuu Israel ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ni ka kani da yujnu xini ya, ni ka tɨvɨ sɨꞌɨ da nuu ya, ti ni ka jakunjitɨ da nuu ya, nanu ja kuu ya ɨɨn rey. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ni ndɨꞌɨ ni ka sakata da nuu ya, ni ka tava da saꞌma kuaꞌa ndiꞌi ñuꞌun ya, ti ni ka naskuiꞌna da ya jiin saꞌma maa ya. Ti kuankoyo da jiin ya ja ka taka da ya nuu ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ichi kuankoyo da ni ka ndejanaꞌan da jiin ɨɨn chaa ñuu Cirene nani Simón, ja chaa kuu tata Alejandro jiin Rufo, vendi da ja ni jaꞌan da nuu rancho da, ti soldado un ni ka chayɨka Simón ja na kundiso da cruz Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Siaꞌan kuankoyo da jiin Jesús undi ɨɨn ñuꞌun nani Gólgota, ja kuni kaꞌan, “ñuꞌun yɨkɨ xini.” ");
INSERT INTO mpmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nu ni ka jakoyo da yukan, ni ka jaꞌa da vino sakanuu jiin ɨɨn nuu suxia ja nani mirra, ja na koꞌo ya nava tu kondoꞌo xaan ya ja jatu ya. Ko maa Jesús tu ni jantaꞌu ya ja koꞌo ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Yukan na ti ni ka chijnɨɨ da ya nuu ndaꞌa cruz jiin nduyukaa. Ti soldado un ni ka chuꞌun da suerte sɨkɨ saꞌma ya, ja na tejnaꞌan nuu jnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja ni kuu ka ɨɨn jañaꞌan na ni ka jatakaa da Jesús nuu ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ti xini cruz un ni ka chijnɨɨ da ɨɨn tutu ja kaꞌan ndoo yɨndaka ya yukan. Kachi siaꞌan: “Jaꞌa kuu Rey nuu yɨvɨ nación Israel.” ");
INSERT INTO mpmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Suni ni ka jatakaa da uu ñakuiꞌna jiin ya nuu uu ga cruz, ɨɨn ichi ndaꞌa kuaꞌa, ti ɨnga ichi ndaꞌa sajni ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Siaꞌan ni kundaa nava yoso nuu tutu Yandios ja kachi: “Kaꞌni da ya nanu ɨɨn ñakuiꞌna.” ");
INSERT INTO mpmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ti yɨvɨ ka yaꞌa ichi chukan, ka skuiko xini ja ka kuu ichi ini nuu ya, ti ka kaꞌan ndevaꞌa: ―Vijna na ti roꞌo ja ni kaꞌan ra ja xnaa ra veñuꞌun kaꞌnu Israel, ti nuu uni kɨvɨ ti na saꞌa jaa ra. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nama maa ra vijna, ti kuan kuun nuu ndaꞌa cruz jña ―kachi jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Suni taka sutu ka kuñaꞌnu un jiin chaa ka xnaꞌan ley ini veñuꞌun un, ka kaꞌan ndevaꞌa kuɨtɨ da nuu ya, ti ka ndajnuꞌun da: ―Ni nama da sava yɨvɨ, ko tu kuu nama da maa da vijna. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ko vijna ti nu na kandixia yo ja kaꞌan ndaa da ti kuun da nuu ndaꞌa cruz un, ti sa na kandixia yo ja kuu da Cristo ni taji Yandios, ja kuu da Rey nuu nɨ tuꞌu nación Israel. Yukan ti kandixia yo ja vaji da undi nuu andɨvɨ ―ni ka kachi da. Ti suni undi uu ga chaa ka ndakoyo yukan jiin ya, ni ka kaꞌan ndevaꞌa da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nu ni kuu sava nduu, ni kuñaa nɨ tuꞌu ñuyɨvɨ, ti ni ndundijin undi ka uni jaꞌini. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti hora un ni kanajiin koꞌo Jesús: ―Eloi, Eloi, ¿lama sabactani? ―kachi ya. (Ja kuni kaꞌan: “Yandios maa na, Yandios maa na, ¿ndoo ni xndoo maa ɨɨn ni saña vijna”? ―kachi ya.) ");
INSERT INTO mpmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sava yɨvɨ kaꞌiin yajni yukan ni ka jinisoꞌo, ti ni ka kachi: ―Kunsoꞌo naa ra, chi kana da xini profeta Elías na janaꞌan―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yukan ti ɨɨn da ni jaꞌa corrɨ, ni chutoo da kachi nuu vino iya, ni chuxndee da xini ɨɨn nuyoo kani, ti ni jaꞌa da ja na koꞌo Jesús, ti kachi da: ―Na ndeꞌe yo nu kii Elías kii nama da chaa ―ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko Jesús, uni ni kanajiin koꞌo ya, ti ni jiꞌi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ti maa hora ni jiꞌi Jesús, ni teꞌnde sava saꞌma ii yɨndaka ini veñuꞌun kaꞌnu Israel un, ni ndata sava kuɨtɨ saꞌma un undi nuu sukun ti undi nuu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ti ɨɨn soldado kuu capitán kandichi nuu Jesús hora un. Nu ni jini da nava ni jiꞌi Jesús, ti ni kachi da: ―Jandaa kuɨtɨ kuu ja Seꞌe Yandios ni kuu chaa jaꞌa ―kachi da. Yukan ni jiꞌi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Suni kaꞌiin sava ñasɨꞌɨ ka jitonchaa jika ña. Ñaa un kuu María Magdalena, Salomé, jiin María nana Santiago, chaa suchi, jiin José. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ñaa jaꞌa ni ka kandixia ña Jesús. Ni ka yaku ña jiin ya, ti ni ka junukuachi ña nuu ya na ni yaku ya ñuu Galilea. Suni yukan kaꞌiin tɨjnɨ ga ñasɨꞌɨ ja ni ka jaꞌan ña jiin ya undi Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ti ɨɨn chaa ñuu Arimatea, nani José, ni kuu da ɨɨn chaa kuñaꞌnu ja kuu nuu junta kaꞌnu Israel. Ti ndiyo ini da ja kuni da nu na jaa kɨvɨ taꞌu Yandios jniñu. Chi ni kandixia da jnuꞌun ni xnaꞌan Jesús ja kuu kɨvɨkoyo yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, ti yukan niꞌin yɨvɨ un ɨɨn taꞌu ya ti kundisojniñu i jiin ya. Ti vanuxia ja ni jaa vispera kɨvɨ ndetatu, ti ni tava ini da ni kaꞌan da jiin Pilato jaꞌini kɨvɨ un, ti ni jikan da permiso ja na kiꞌin da jiin yɨkɨ kuñu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ti Pilato ni naa ini da nu ni jinisoꞌo da ja, ja ni jiꞌi Jesús. Ni kana da capitán soldado un, ti ni jikajnuꞌun da nu ja ni jiꞌi ndixia ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ti capitán un ni kachi ja, ja ni jiꞌi ndixia ya. Yukan na ti Pilato ni jaꞌa da permisu nuu José ja na kiꞌin da jiin yɨkɨ kuñu ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ti José ni jaan da ɨɨn saꞌma finu, ni kuniꞌin da yɨkɨ kuñu ya nuu ndaꞌa cruz un, ti ni nasuku da yɨkɨ kuñu ya. Yukan ti ni chunde da ya ɨɨn yau jaa, ja ni jacha da chii ɨɨn kava. Ti ni nakasɨ da jiin ɨɨn yuu kaꞌnu xaan. ");
INSERT INTO mpmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ti María Magdalena jiin ɨnga María nana José, kaꞌiin ña yukan, ti ni ka jini ña nuu ni ka chunde da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nu ni yaꞌa kɨvɨ ndetatu un, ti María Magdalena jiin ɨnga María, nana Santiago, jiin Salomé, ni ka jaan yachi ña perfume ja kin chiꞌi ña sɨkɨ yɨkɨ kuñu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ñaꞌan xaan kɨvɨ ni nukuñɨ semana kuankoyo ña yuꞌu ñaña un. Ja ni kaña ndaa ndikandii ni ka jakoyo ña nuu ñaña un. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ti ichi kuankoyo ña ka ndajnuꞌun ña: ―¿Nanu niꞌin yo ɨɨn ja chajiyo yuu nuu ñaña un? ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nu ni ka jakoyo ña, ti ni ka jini ña ja, ja ni kuxio yuu kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ni ka kɨvɨ ña ini yau un. Yukan ni ka jini ña ɨɨn ángel Yandios nukoo ndaꞌa kuaꞌa. Ti ñuꞌun ya ɨɨn saꞌma kani, xkɨyɨ niꞌni. Ni naxnaꞌan ya nuu ña nanu ɨɨn chaa lulu. Ti ñaꞌan un ni ka yuꞌu ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ko ángel un ni kachi: ―Koto yuꞌu ra naa ra. Chi jini ri ja ka nanduku ra Jesús, chaa ñuu Nazaret ja ni jiꞌi nuu ndaꞌa cruz un. Ko tuu kande ya jaꞌa, chi ja ni nandoto ya. Ndeꞌe, jaꞌa kuu nuu ni ka xndoo da yɨkɨ kuñu ya, ko tukaa ndoo iyo. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vijna ti kuaꞌan naa ra ti kachi ra nuu Pedro, ti suni nuu uu ga chaa ka kuu ndajaꞌa ya: “Koxnuu ya kiꞌin ya ñuu Galilea, ti yukan kundatu ya roꞌo naa ra. Ti nakuni ra ya nava ni kachi ya jiin ra naa ra” ―kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ti ñaꞌan un ni ka kee ña ini yau un, ti ni ka jaꞌa ña corrɨ, chi ni ka yuꞌu xaan ña ja undi ka nɨꞌɨn ña, ti so ni ka sana ini ña. Ko tu ni ka kachi ña nuu ni ɨɨn yɨvɨ ja siaꞌan ni kuu, chi ni ka yuꞌu xaan ña. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jañaꞌan kɨvɨ ni nukuɨñɨ semana, nu ni nandoto Jesús, ti xnakan ni ndenda ya nuu María Magdalena, ñaa ni keniꞌin ya uxia tachi xaan yukan. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ti maa ña ni jan kaxnuꞌun nuu uu ga chaa ni ka jika jiin ya. Chi ka naꞌnu da ya, ka kukuiꞌya xaan ini da, ti ka ndeꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ko nu ni ka jinisoꞌo da ja chaku Jesús, tu ni ka kandixia da, vasu kachi ña un ja ni ndejnaꞌan ña jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kuee ga, ti ni ndenda Jesús sɨɨ tuku nuu uu chaa ni ka kuu ndajaꞌa ya ichi kuankoyo da ranchu da. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chaa un, ni ka nandeokuñɨ da, ti ni ka kachi da nuu uu ga ndajaꞌa un, ko suni tu ni ka kandixia da jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sandɨꞌɨ ni ga, ni ndenda Jesús nuu uxi ɨɨn ndajaꞌa ya nuu kanchuku da ka yee da staa. Ti ni kanajiin ya nuu da naa da, ndoo tu ka kandixia da ja ni nandoto ya, ndoo xaan ga niꞌin ni nduu ini ra naa ra ja tu ka chunsoꞌo ra jnuꞌun ka kaꞌan yɨvɨ ni ka ndejnaꞌan jiin ya, chi ni ka kachi i ja, ja ni nandoto ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yukan na ti ni taꞌu ya ɨɨn jniñu nuu da naa da, ti ni kachi ya: ―Kuankoyo naa ra nɨ tuꞌu ñuyɨvɨ, ti kaꞌan ra jnuꞌun Yandios nuu taka yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yɨvɨ kandixia, ti kuanducha i, ti nanitaꞌu i nuu Yandios. Ti yɨvɨ tu kandixia, na jnaꞌnu ndatu i jiin kuachi i. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yɨvɨ na kandixia ti kuu saꞌa i jniñu ñaꞌnu jiin sɨvɨ ri. Kuu kenchaa da tachi xaan kiꞌin. Ti kaꞌan da yuꞌu ɨnga yɨvɨ ja tu ka jini da. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nu na kuꞌuun ini ra ti jnɨɨ ra ɨɨn koo, xi kuꞌuun ini ra ti koꞌo ra veneno, ti tundo jnaꞌan kuɨtɨ ra. Chuxndee a ndaꞌa ra sɨkɨ yɨvɨ ka kuꞌu, ti nduvaꞌa i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu ni ndɨꞌɨ ni kaꞌan Jitoꞌyo Jesús jiin ndajaꞌa ya, ti ni ndaa ya kuanoꞌon ya andɨvɨ. Ti ni nukoo ya ndaꞌa kuaꞌa Yandios nuu ni nduñaꞌnu ya kancha ya. ");
INSERT INTO mpmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ti ndajaꞌa ya jiin chaa ka skuaꞌa jiin ya, ni ka yaku da taka ñuu ni ka kaꞌan da jnuꞌun Yandios nuu yɨvɨ naa i. Ti maa Jitoꞌyo ni chindee chituu ya da jiin jniñu ñaꞌnu ni ka saꞌa da, ti ni ka jini yɨvɨ ja iyo ndaa jnuꞌun ni ka kaꞌan da. Jaꞌa kuu jnuꞌun Yandios ni chaa Marcos.");
INSERT INTO mpmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nde tɨjnɨ chaa ni ka nanduku ndaa nasa ni kuu na ni kii Cristo Jesús jiin taka jniñu ni saꞌa ya, ja ni ka jini yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Siaꞌan nava ni ka xnaꞌan yɨvɨ ni ka jini jniñu ni saꞌa Jesús undi nuu, yɨvɨ ni ka jika jiin ya ti ni ka chindee ya jiin jnuꞌun ni xndaku ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ti suni ruꞌu Lucas, ni nanduku ndaa ri taka nasa ni kuu undi nuu, na ni kii Jesús. Ti ndoꞌo ini ri ja iyo vaꞌa ja na chaa ri tutu jaꞌa nuu ra, amigo Teófilo, na kachi ri taka jniñu ni saꞌa Jesús, undi na ni kejaꞌa ya ti undi ni xndɨꞌɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ti siaꞌan na kuni ndaa ra ja iyo ndaa taka jnuꞌun ni kutuꞌva ra sɨkɨ Jesús. Yukan kuu ja chaa ri tutu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na ni kuu Herodes rey ñuu Judea, ni iyo ɨɨn sutu Israel ni nani Zacarías, ti chaa un yɨꞌɨ da jiin grupo sutu ni nani Abías. Ti ñasɨꞌɨ da ni nani ña Elisabet, ni kuu ña jnaꞌan ɨɨn sutu janaꞌan ni nani Aarón. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ti ndɨnduu da ni ka jandatu vaꞌa da nuu Yandios, ti suni ni ka siuku ndaa da taka ley ni taꞌu maa Jitoꞌyo Yandios. Ti ni ɨɨn yɨvɨ tu ni ka kaꞌan ndevaꞌa i sɨkɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ko tu ni ka iyo seꞌe da, chi Elisabet tu ni iyo seꞌe ña. Ti ndɨnduu da ja ni ka jaꞌnu xaan da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ti ɨɨn kɨvɨ ni kendo Zacarías nuu jniñu da ja junukuachi da, ja kuu da sutu nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Siaꞌan nava ni iyo jnuꞌun ja kuu sutu un naa da, ni kuu suerte maa Zacarías ja ni kɨvɨ da veꞌe ii, ini veñuꞌun kaꞌnu Jitoꞌyo Yandios ja kaꞌma da suxia kutu. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ko ni jaꞌma da suxia kutu un, ti ichi jata veꞌe ii un kaꞌiin yɨvɨ kuaꞌa ka jikantaꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ti ni kenda ɨɨn ángel Jitoꞌyo Yandios nuu Zacarías ja kandichi xiin nuu altar nuu kayu suxia kutu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ti nu ni jini Zacarías nuu ángel un ni yuꞌu da, ti tu ni kujnuni ini da nasa saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko ni kachi ángel jiin da: ―Zacarías, koto ma yuꞌu ra, chi ni jinisoꞌo Yandios jnuꞌun ni jikantaꞌu ra nuu ya, ti koo ɨɨn seꞌe ñasɨꞌɨ ra Elisabet vijna. Skaku ña ɨɨn suchi yɨɨ lulu, ti skonani ra i Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti kusɨɨ xaan ini ra jiin suchi lulu un, ti suni kuaꞌa xaan yɨvɨ kusɨɨ ini jiin yɨ kɨvɨ na kaku i, ");
INSERT INTO mpmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ti kuaꞌa Yandios ɨɨn jniñu ñaꞌnu nuu i. Tu koꞌo i vino ni ndɨxɨ, ti kunchaa Espíritu Santo jiin i, vasu ni ñuꞌun ga i chii nana i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ti saꞌa i ja kuaꞌa yɨvɨ nación Israel na nakani ini i ti kuandatu i nuu Jitoꞌyo Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti Juan un kuu ja koxnuu kiꞌin satuꞌva yɨvɨ ja kuu maa Jitoꞌyo, ya kiji un, ti kuñavaꞌa da jnuꞌun nde Espíritu nava ni ñavaꞌa profeta Elías. Ti saꞌa da ja taka tata na ndundaꞌu ini da nuu seꞌe da, ti yɨvɨ niꞌin ini ja kanda kuaꞌan kanda vaji un kutuꞌva i kuandatu i. Ti siaꞌan satuꞌva da yɨvɨ naa i ja na kotuꞌva i kɨvɨ na chaa maa Jitoꞌyo ―ni kachi ángel Yandios un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yukan ti ni jikajnuꞌun Zacarías ángel un: ―¿Nasa kuni ndaa na nu jandaa ndixia kuu nusa? Chi ja ni jaꞌnu xaan na, ti suni ñasɨꞌɨ na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ko ni kachi ángel un: ―Ruꞌu kuu Gabriél, junukuachi ri nuu Yandios, ti ni taji ya ruꞌu vaji ri ja na kasjnuꞌun ri ɨɨn jnuꞌun vaꞌa jaꞌa nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ko vijna, vanuxia tu ni kandixia ra jnuꞌun ni kaꞌan ri, ti kendo ñɨꞌɨn ra, ti tukaa ga kuu kaꞌan ra undi na jaa kɨvɨ kundaa jnuꞌun jaꞌa, ja kaku suchi lulu un. Ti jnuꞌun jaꞌa kundaa nava ni kachi ri ―ni kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti ni ka ndajnuꞌun Zacarías jiin ángel un, ti kaꞌiin yɨvɨ ichi fuera ka ndatu i maa da, ti ka jani ini i ja ndoo jnaꞌan da ja ni kunaꞌan kukuee da ini veꞌe ii un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ko nu ni kenda Zacarías, ti tukaa kuu kaꞌan da jiin yɨvɨ un naa i. Yukan ti ni ka chaku ini yɨvɨ un ja iyo ɨɨn ja ni naxnaꞌan Yandios nuu da ini veꞌe ii un. Ti seña ni ga ni saꞌa da chi ni kendo ñɨꞌɨn da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nu ni jinu kɨvɨ ni junukuachi Zacarías ini veñuꞌun un, ti kuanoꞌon da veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yukan na ti ni jakuꞌun seꞌe ñasɨꞌɨ da Elisabet, ti tukaa ni kee ña veꞌe ña nuu uꞌun yoo, chi ndoꞌo ini ña: ");
INSERT INTO mpmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Siaꞌan ni saꞌa maa Jitoꞌyo jiin ri, ti vijna tukaa ga kukanuu ri nuu taka yɨvɨ ja skexiko i ruꞌu”, siaꞌan ndoꞌo ini ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nu ja ni kuu iñu yoo ja ñuꞌun seꞌe Elisabet, ti ni taji Yandios ángel Gabriél nuu ndañuu Galilea ja nani Nazaret. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni jan kaꞌan da jiin ɨɨn ñaꞌan suchi ñuꞌun nani María. Ti ja ni kundaa ja nandaꞌa ñaꞌan un jiin ɨɨn chaa nani José, ɨɨn chaa kuu jnaꞌan chaa ni kuu rey ni nani David. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ni jaa ángel un nuu kancha ña, ti ni kachi da: ―Too ni ndii. Ndatu ni kuu ra nuu Yandios, ti kancha Jitoꞌyo jiin ra, ti ndatu xaan ga ni kuu ra nuu Yandios ja kuu taka ga ñasɨꞌɨ ―ni kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ko nu ni jini María nuu ángel un, ti ni sana inijnuni ña, ti ni kuñaa inijnuni ña ja siaꞌan kaꞌan ángel un. Ti ndoꞌo ini ña naa jnuꞌun kuu ja kaꞌan ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ti ni kachi tuku ángel un: ―Koto yuꞌu ra María, chi ni kundaꞌu ini Yandios roꞌo ja ni jaꞌa ya ɨɨn jniñu ñaꞌnu nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vijna na ti jakuꞌun seꞌe ra. Ti kuu i ɨɨn suchi yɨɨ, ti skonani ra i Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nduñaꞌnu i, ti kuu i maa Seꞌe Yandios kancha andɨvɨ. Ti saꞌa Jitoꞌyo Yandios ja na kuu i rey nanu ni kuu David, chaa ni kuu jnaꞌan i janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ti taꞌu i jniñu nuu nación Israel ja kuu saa ni ti jankɨvɨ ga ndɨꞌɨ jniñu taꞌu i un ―ni kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yukan na ti ni jikajnuꞌun María nuu ángel un siaꞌan: ―¿Nasa kundaa jnuꞌun ni kaꞌan ni un, ti changa ga koo yɨɨ na? ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yukan ti ni kachi ángel un jiin ña: ―Maa Espíritu Santo saꞌa ja na jakuꞌun suchi lulu un, chi ɨɨn jniñu ñaꞌnu kuu ja saꞌa Yandios jiin ra. Ti suchi lulu ii ja kaku un, kuu i Seꞌe maa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Suni na kachi ri nuu ra ja Elisabet, ñaa kuu jnaꞌan ra un, koo ɨɨn seꞌe ña, vasu ja ni nchɨɨ ña. Ja yukan kuu ja ñaꞌan ka kaꞌan ja tu iyo seꞌe un, vijna ti ja iyo iñu yoo ja nchaa kuꞌu ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chi Yandios, taka ni ja kuu saꞌa ya, ti tu iyo ni ɨɨn ja tu kuu saꞌa ya ―kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yukan na ti ni kachi María: ―Siaꞌan na koo nusa, chi maa ya kuu ja yɨndaꞌa saña, ti na kuu nava ni kachi ni ―kachi ña. Yukan na ti kuaꞌan ni ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yukan ti uu uni ni kɨvɨ ti ni kee María, ti kuaꞌan ña ɨɨn ñuu kande yuku ñuu Judea. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ni jaa ña veꞌe Zacarías, ti ni kanxiaꞌu ña jiin Elisabet. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ti nu ni jinisoꞌo Elisabet ja kanxiaꞌu María jiin ña, ti yukan ni kanda suchi lulu un chii ña, ti ni chaa Espíritu Santo nuu ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yukan na ti jaa xaan ni kaꞌan ña: ―Jandaa ndixia kuu ja ni chindee chituu Yandios roꞌo. Ti ndatu xaan ga ni kuu ra ja kuu taka ga ñasɨꞌɨ. Ti suni na chindee xaan ga maa ya suchi ñuꞌun chii ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ti xaan ndatu ri ja ni chaa nana Jitoꞌyo ri kii ndeꞌe ña ruꞌu, ti ansu ɨɨn ñaꞌan kuñaꞌnu kuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti naa ini ri na ni jinisoꞌo ri jnuꞌun ni kaꞌan ra, ti ni kanda suchi lulu jaꞌa chii ri ja ni kusɨɨ ini i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na chindee chituu ya roꞌo ja ni kandixia ra jnuꞌun ni kaꞌan ya jiin ra. Ti jaa kɨvɨ nu kundaa nava ni kachi maa Jitoꞌyo nuu ra ―ni kachi Elisabet. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yukan na ti ni kachi María: Jiin ni ini ri kana jaa ri maa Jitoꞌyo ja kuñaꞌnu xaan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ti kusɨɨ ini ri jiin Yandios ja ni nama ya ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi maa Yandios ja ni kundaꞌu ini ya ruꞌu, ɨɨn ñaꞌan junukuachi nuu ya. Ti undi vijna kaꞌan taka yɨvɨ naa i ja ndatu xaan ni kuu ri nuu Yandios, ti siaꞌan ndaku niꞌin yɨvɨ ruꞌu ja kuu taka ni kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ti kaꞌnu jniñu ni saꞌa ya jiin ri, chi kuñaꞌnu maa Yandios, ti Yandios ii Yandios ndoo kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ti ja kuu saa ni kundaꞌu ini ya nuu taka yɨvɨ ka jandatu nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti ni saꞌa ya jniñu ñaꞌnu jiin jnuꞌun maa ya, ti ni kundee ya jiin yɨvɨ ka ndoꞌo vixi ini. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ti chaa ka kuñaꞌnu ni kenchaa ya jniñu nuu da, ti ni nakuaꞌa ya nuu yɨvɨ ndaꞌu ja na nduñaꞌnu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ti yɨvɨ ka jiꞌi soko ni jaꞌa ya ja na kaji vaꞌa i. Ti yɨvɨ riko ni sia ya maa i kuankoyo siaꞌan ni jiin ndaꞌa iyu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ni chindee ni chituu ya yoꞌo, yɨvɨ nación Israel, ja ka junukuachi yo nuu ya. Chi ñukuu ini ya yoꞌo ja kundaꞌu ini ya yoꞌo naa yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chi siaꞌan ni chisojnuꞌun ya nuu taka tata yo, nuu Abraham jiin taka jnaꞌan da ja kikoyo ɨnga kuiya. Ni kachi María. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ti ni kendo ña uni yoo jiin Elisabet, ti sa ni nandeokuñɨ ña veꞌe ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nu ni jaa kɨvɨ ja kaku seꞌe Elisabet, ti ni iyo ɨɨn suchi yɨɨ lulu nuu ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ti taka yɨvɨ kanchuku yajni un jiin taka jnaꞌan ña, ni ka jini yɨvɨ un ja ni kundaꞌu ini Yandios maa ña, ti ni ka kenda i ni ka jajnuꞌun i maa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nu una kɨvɨ, ti ni ka chakoyo yɨvɨ un ni ka ndututu i ja ni ka saꞌa i ɨɨn seña nuu yɨkɨ kuñu suchi yɨkɨ un (ti yukan kuu ɨɨn seña nuu yɨkɨ kuñu taka suchi yɨɨ nación Israel, ja jnaꞌan ja ka kuu i yɨvɨ Yandios). Ti ka kuni skonani da suchi un sɨvɨ maa tata i Zacarías. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ko ni kachi nana i: ―Tuu, chi Juan konani i ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ti ni ka kachi yɨvɨ un jiin ña: ―¿Ti ndoo nusa? Ti tu iyo ni ɨɨn jnaꞌan ra ja ni nani siaꞌan ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yukan na ti ni ka jikajnuꞌun da maa tata i jiin seña ja nasa kuni da ja na konani i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ti ni jikan da ɨɨn tabla lulu, ti ni chaa da nuu: “Juan konani yɨ”, kachi da. Ti tendɨꞌɨ yɨvɨ un ni ka naa ini i nu ni ka jinisoꞌo i jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ti hora un ni kuu ndokaꞌan Zacarías, ti ni kejaꞌa kanajaa da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ti taka yɨvɨ kanchuku yajni un, so ni ka naa ini i jiin jnuꞌun un, ti jnuꞌun un ni jichanuu nɨ yuku ñuu Judea ja siaꞌan ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ti taka yɨvɨ ka jinisoꞌo jnuꞌun un, ti ni ka kejaꞌa ka ndoꞌo ini, ti ka jikajnuꞌun jnaꞌan: ―¿Nau ja kuu suchi lulu un nu na kuaꞌnu i nusa? ―ni ka kachi i. Siaꞌan ni ka kaꞌan yɨvɨ un, chi jandaa ndixia kuu ja ndito Yandios suchi lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yukan ti ni chaa Espíritu Santo sɨkɨ Zacarías, ti ni kaꞌan da jnuꞌun ni jaꞌa maa Yandios nuu da, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Xaan ga vaꞌa ini maa Jitoꞌyo Yandios ja ndito ya yɨvɨ nación Israel, chi ni kindeꞌe ya nuu yo ja ka kuu yo yɨvɨ ñuu ya, ti ni nama ya yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ti ni taji ya ɨɨn ja kuñaꞌnu ja ki nama yoꞌo. Ti ya un kuu jnaꞌan rey David na janaꞌan, chaa ni junukuachi nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chi siaꞌan ni chisojnuꞌun ya nava ni ka kachi profeta undi janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ti nama ya yoꞌo nuu yɨvɨ ka jito uꞌu yoꞌo, jiin nuu taka yɨvɨ ka kɨtɨ ini jito yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ti kundaꞌu ini ya nuu ñanijnaꞌan yo na janaꞌan, ti tu ni naa ini ya jnuꞌun kanuu ni kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ja ni chisojnuꞌun kaji nuu tata yo Abraham na janaꞌan, ");
INSERT INTO mpmNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ja kin nama ya yoꞌo nuu yɨvɨ jito uꞌu yoꞌo, ti nava tu yuꞌu yo ja kuanukuachi yo nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kani ndaa kuɨtɨ ini yo ja kunukuachi yo nuu ya nɨ kɨvɨ na kuchaku yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ti seꞌe yɨɨ lulu ri jaꞌa, nu na kuaꞌnu i, ti kuu i ɨɨn profeta. Kaꞌan jnuꞌun Yandios kancha andɨvɨ, chi koxnuu i kiꞌin i nuu Jitoꞌyo. Ti satuꞌva i yɨvɨ naa i sa na kii ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ti kaꞌan i ɨɨn jnuꞌun nuu yɨvɨ ñuu ya ja nama ya maa i, ti koo jnuꞌun kaꞌnu ini ya nuu kuachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Siaꞌan na koo, chi vaꞌa ini Yandios yo, ti kundaꞌu ini ya yoꞌo. Yukan kuu Yandios, ja kancha andɨvɨ, na xnaꞌan ya nuu yo ɨɨn ichi vaꞌa ja kuu taka kɨvɨ kuxian yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Saꞌa ya ja na kujnuni ini yɨvɨ, ti nakuni ga i jnuꞌun ya, ja kuaꞌan i ichi ñuñaa nuu ñujiꞌi. Ti kundaꞌa ya yoꞌo nuu ɨɨn ichi vaꞌa nuu koo ndee koo sɨɨ ini yo, ja na kukuee kunchaa yo. Ni kachi Zacarías. ");
INSERT INTO mpmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ni jaꞌnu suchi lulu un, ti ni yɨxia ini jnuni i jiin jnuꞌun ya. Ti yukan ni kunchaa i nuu ñuꞌun teꞌe un undi ni jaa kɨvɨ ni ka natuꞌva yɨvɨ Israel nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na kuiya un ni taꞌu rey Augusto jniñu nuu taka nación ja yɨndaꞌa ñuu Roma, ti ni jachanuu da jnuꞌun nuu nɨ tuꞌu nación nuu yɨndaꞌa da un, ja na ndoko ɨɨn censo nuu ndututu ndɨꞌɨ vii kuɨtɨ sɨvɨ yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ti Cirenio ni kuu gobernador nuu ñuu Siria na ni ka nastutu da sɨvɨ yɨvɨ naa i. Yukan ni kuu ɨɨn censo undi nuu kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ti tendɨꞌɨ yɨvɨ ni ka nandeokuñɨ i nani ñuu i, ja na chiso i sɨvɨ i un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ni kee José ñuu Nazaret, ɨɨn ndañuu Galilea, ti kuanoꞌon da ichi ñuu Judea undi ñuu Belén nuu ni kaku rey David na janaꞌan, chi José ni kuu da jnaꞌan David. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ni jan chiso da sɨvɨ da jiin María, chi ja ni nandaꞌa da jiin ña, ti ja nchaa kuꞌu ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ti ni kuu ja, ja kaꞌiin da ñuu Belén, ti ni jaa kɨvɨ ja kaku seꞌe María. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yukan ni iyo ɨɨn suchi núú nuu ña, ti ni kuu i suchi yɨɨ. Yukan ni nasuku ña i saꞌma vita, ti ni skatuu ña i ini ɨɨn nundoo nuu ka yaji kɨtɨ un, chi tukaa ga nuña mesón nuu kendo. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti yajni ñuu Belén kaꞌiin uu chaa ka ndito rɨɨ undi yuku un jakuaa kɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ti sana ini da naa da, ti ni kenda ɨɨn ángel maa Jitoꞌyo Yandios, ti nduva maa Jitoꞌyo ni janducha nɨ nuu kaꞌiin da un, ti ni ka yuꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko ni kachi ángel un jiin da naa da: ―Koto yuꞌu ra naa ra, chi ve kachi ri ɨɨn jnuꞌun vaꞌa nuu ra naa ra, ti jiin jnuꞌun un na kusɨɨ xaan ini yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ti jaꞌa kuu ɨɨn jnuꞌun vaꞌa, chi undi ñuu David ni kaku ya kii nama roꞌo vijna naa ra, ti Cristo maa Jitoꞌyo kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ti jiin seña jaꞌa kuni ndaa ra ja siaꞌan iyo, naniꞌin ra suchi lulu un suku i jiin saꞌma vita, ti katuu i ini ɨɨn nundoo nuu ka yaji kɨtɨ ―ni kachi ángel. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sanaa ni ti ni kenda kuaꞌa xaan ga ángel nuu andɨvɨ, ka kanajaa i Yandios, ti ka kaꞌan i: ");
INSERT INTO mpmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―¡Na nakanajaa yo maa Yandios ja kancha ya nuu sukun! Ti vijna na ndusɨɨ ini taka yɨvɨ ñuyɨvɨ, chi ni ndundaꞌu ini ya nuu i naa i ―ni ka kachi ángel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yukan na ti nu kuan nukoyo ángel un ichi andɨvɨ, ti ni kejaꞌa ka ndajnuꞌun chaa ka ndito rɨɨ un: ―Na choꞌo naa yo undi ñuu Belén, na choꞌo ndeꞌe nau ja kuu ja ni kasjnuꞌun maa Jitoꞌyo nuu yo ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ti ni ka kekoyo da kuaꞌan da, ni ka naniꞌin da nuu kancha María jiin José jiin suchi lulu un ja katuu i ini nundoo kɨtɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nu ni ka jini da nuu suchi lulu un, ni ka jani da jnuꞌun nava ni kachi ángel un nuu da sɨkɨ suchi lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti taka yɨvɨ ni ka jinisoꞌo jnuꞌun ni ka kaꞌan chaa ka ndito rɨɨ un, so ni ka naa ini i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko María ni chuꞌun ini ña taka jnuꞌun un, ti ndoꞌo xaan ini ña sɨkɨ jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti ni ka nandeokuñɨ chaa ka ndito rɨɨ un kuankoyo da, ka nakanajaa da Yandios ti ka kaꞌan da: ―¡Xaan ga kaꞌnu jniñu saꞌa maa Yandios, ja ni kundaa taka ja ni ka jinisoꞌo yo, jiin ja ni ka jini yo! ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nu una kɨvɨ ja ni kaku suchi lulu un, ni ka ndututu da, ti ni ka saꞌa da ɨɨn seña yɨkɨ kuñu i, ti ni ka skonani da i Jesús, nava ni kachi ángel un nuu María, na ti jakuꞌun ga seꞌe ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nu ni jinu kɨvɨ ja kin siuku ña jnuꞌun ja na ndundoo ña nuu Yandios nava jnuꞌun kaꞌan ley, ja ni jaꞌa Yandios nuu Moisés. Ti ni ka jaꞌan María jiin José jiin suchi lulu un undi ñuu Jerusalén ja na kotonchaa Jitoꞌyo Yandios maa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Siaꞌan ni ka saꞌa da, vanuxia siaꞌan ni taꞌu Jitoꞌyo Yandios jniñu nuu ley Moisés ja taka suchi yɨɨ kaku, ti nu ka kuu i suchi núú, na nakuaꞌa da i nuu maa Jitoꞌyo Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ni ka jaꞌan soko da ja kuu nuu Yandios nava jnuꞌun kaꞌan maa ley Jitoꞌyo Yandios, ja na soko da uu ndɨvɨ xi uu sata, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti kuiya un ni iyo ɨɨn chaa ni nani Simeón ñuu Jerusalén, ti ni kuu da ɨɨn chaa yɨñuꞌun, ja ni nchañuꞌun da Yandios. Ti ñukuu ini da ja kii maa Jitoꞌyo ja kii nama ya nación Israel. Ti maa Simeón, jika Espíritu Santo jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ja yukan kuu ja ni jini jnuni da ja tu kuu yachi da undi nu tu kuni da nuu Cristo, ja taji maa Jitoꞌyo Yandios ja na saꞌa ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maa Espíritu Santo ni yɨndaꞌa chaa un kuaꞌan da nuu veñuꞌun kaꞌnu Israel un. Ti nu ni jakoyo María jiin José jiin suchi lulu un ja nani i Jesús, ti ni ka yɨndaꞌa da i nuu veñuꞌun kaꞌnu un ja na siuku da jiin i nava jnuꞌun kaꞌan ley Moisés. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ti ni kiꞌin Simeón suchi lulu un, ni nunchaa da i nuu ndaꞌa da, ti ni kanajaa da Yandios, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jitoꞌyo, vijna na ti sia ni saña, na kuū na vaꞌa na, chi ja ni siuku ni jnuꞌun ni chisojnuꞌun ni nuu saña ja kuu na muzu ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ti ni jini na jiin nuu na nuu ya, kii nama ya sɨkɨ yɨvɨ naa i, ");
INSERT INTO mpmNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ja ni taji ni nuu taka yɨvɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Maa ya kuu nanu ɨɨn nduva ja kɨvɨ ini yɨvɨ taka nación ja na jnuu ini i. Ti saꞌa ya ja na nduñaꞌnu yɨvɨ maa nación Israel. Kachi Simeón. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José jiin nana Jesús, so ni ka naa ini da ja siaꞌan ni kaꞌan Simeón sɨkɨ suchi lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yukan na ti ni jikantaꞌu Simeón nuu Yandios ja kuu maa da naa da jiin suchi lulu un, ti ni kachi da jiin María, nana Jesús: ―Ja ni nakaji Yandios suchi lulu jaꞌa vaji i nava na kandixia kuaꞌa yɨvɨ nación Israel, ti nanitaꞌu i. Ti sava ga yɨvɨ tu kandixia, jnaꞌnu ndatu i. Ti maa ya kuu ja kaꞌan jnuꞌun Yandios, ko kuaꞌa yɨvɨ tu kuantaꞌu jnuꞌun kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ti maa ya saꞌa ja na ndundijin taka ja ka ndoꞌo ini añu taka yɨvɨ naa i. Ti ja kuu maa ra jatu yeniꞌni ini añu ra, ja naꞌnu xaan ra i, ja nanu jaꞌncha yuchi ini ra ―ni kachi Simeón. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ti yukan kande ɨɨn ñaꞌan junukuachi yuxeꞌe veñuꞌun kaꞌnu un, ja suni kaꞌan ña jnuꞌun Yandios. Nani ña Ana. Yɨɨ ña ni nani Fanuel, ti kuu ña jnaꞌan Aser, chaa ni ka xnukoo ñuu Israel na janaꞌan. Ti ja ni jaꞌnu xaan ña. Nɨ suchi xaan ña ni nandaꞌa ña, ti ni kuncha ña uxia kuiya jiin yɨɨ ña, ");
INSERT INTO mpmNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ti ni kendo ndaꞌu ña ja undi vijna kuu ña ñaꞌan maa un nuu kuun xiko kuun kuiya. Ti tu kuxio ña nuu yuxeꞌe veñuꞌun kaꞌnu un ja junukuachi ña nuu Jitoꞌyo kuu nduu kuu ñuu, kendo ndicha ini ña, ti jikantaꞌu ña nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti maa hora kaꞌiin María jiin José un ni kenda ña ni tuꞌva ña nuu da naa da, ti ni nakuantaꞌu ña nuu Yandios. Ti ni kejaꞌa ña ni kaꞌan ña sɨkɨ Jesús lulu nuu taka yɨvɨ kaꞌiin ini veñuꞌun un, ja ka ñukuu ini i ja kii maa ya kii nama ya sɨkɨ Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nu ni ndɨꞌɨ ni ka siuku da taka jniñu taꞌu ley maa Jitoꞌyo Yandios, ti ni ka nandeokuñɨ da kuan nukoyo da ñuu da Nazaret ja kuu ɨɨn ndañuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ti kuan kuaꞌnu ndendajnu ga Jesús, ti kuan kuu ndichi xaan inijnuni i, chi maa Yandios ni chindee chituu ya maa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na kuiya yukan chi taka kuiya ka jaꞌan tata i jiin nana i undi Jerusalén, ja kuu viko pascua nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ti nu ja iyo uxi uu kuiya Jesús, ti kuankoyo taka da ñuu Jerusalén, chi siaꞌan ni ka jaꞌan da taka kuiya ja kuu viko un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ti nu ni yaꞌa viko un, ni ka nandeokuñɨ da kuan nukoyo da. Ti Jesús ni kendo i undi Jerusalén, ko tu ni ka jini José jiin María ja ni kendo i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ti ka ndoꞌo ini da ja kuaꞌan Jesús maꞌñu yɨvɨ kuaꞌa un, ti siaꞌan ni ka jika da nchakanchaa ɨɨn kɨvɨ. Ti sa ni ka nanduku da i maꞌñu taka jnaꞌan da jiin maꞌñu yɨvɨ kuankoyo un, ");
INSERT INTO mpmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ko tu ni ka naniꞌin da i. Yukan na ti ni ka nandeokuñɨ da undi ñuu Jerusalén, ja ka nanduku da i yukan. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nu uni kɨvɨ sa ni ka naniꞌin da i ini veñuꞌun kaꞌnu Israel un, nukoo i maꞌñu chaa ka xnaꞌan ley un, ñusoꞌo i jnuꞌun ka kaꞌan da, ti xndichi i chaa un jiin jnuꞌun ka kaꞌan da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ti taka ja ka ñusoꞌo jnuꞌun kaꞌan i, so ni ka naa ini ja ndichi xaan kaꞌan i, ti vaꞌa xaan naxndeokani i jnuꞌun un nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti nu ni jini tata i jiin nana i nuu i ja yukan kancha i, ti so ni ka naa ini da ni ka ndeꞌe da nuu i ja nukoo i yukan. Ti ni kachi nana i jiin i: ―Ndaꞌu seꞌe ri. ¿Ndoo ni saꞌa ra siaꞌan jiin ri? Ruꞌu jiin tata ra ka ndɨꞌɨ xaan ini ri ka nanduku ri roꞌo ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yukan na ti ni kachi Jesús: ―¿Ndoo ka nanduku ni saña naa ni? ¿Xi tu ka jini ni ja kanuu ga ja na kunchaa na ini veꞌe ii Tata na Yandios nu? ―kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko maa da, tu ni ka chaku ini da ndoo kuu ja ni kendo i yukan. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yukan na ti kuanoꞌon i jiin da naa da ichi ñuu Nazaret, ti maa i ni siin i jandatu i nuu da naa da. Ti María ni chuꞌun ini ña taka jnuꞌun un, ti ndoꞌo xaan ini ña sɨkɨ jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yukan ti kuan kuaꞌnu ndendajnu ga Jesús, ti kuan kundichi ga xini i. Ti ni niꞌin i ja yɨñuꞌun nuu Yandios jiin nuu yɨvɨ naa i, chi maa Yandios ni chindee chituu ya i. Ti siaꞌan kuan kuaꞌnu ga Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nu xiaꞌun kuiya ja ni kenchaa taꞌu rey Tiberio jniñu nuu taka nación yɨndaꞌa ñuu Roma, ti Poncio Pilato ni kuu gobernador ñuu Judea, Herodes ni kuu gobernador ñuu Galilea, ti ñani da Felipe ni kuu gobernador ñuu Iturea jiin ñuu Traconite, ti Lisanias ni kuu gobernador ñuu Abilinia. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ti sutu ka kuñaꞌnu Israel ni ka kuu Anás jiin Caifás na kuiya un. Ti ni kaꞌan Yandios jiin Juan, seꞌe yɨɨ Zacarías. Ni kaꞌan ya jiin da nuu kande da undi nuu ñuꞌun teꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ti Juan ni jikonuu da taka ñuu kaꞌiin yajni yucha Jordán, ti ni kachi da nuu yɨvɨ ja na nakani ini i, ti na kuanducha i nava na kuankaꞌnu ini Yandios nuu kuachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ti yukan ni kundaa nava ni chaa Isaías nuu tutu ja kachi siaꞌan: Kin kaꞌan ɨɨn chaa, kin kaꞌan undi nuu ñuꞌun teꞌe un, ti kachi da: Kotuꞌva naa ra, chi ja yajni chaa Jitoꞌyo. Ti kuni ja na kaka ndaa ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Na kotuꞌva yɨvɨ naa i, ti taka xaꞌva na ndundaa, ti taka yuku jiin loma na ndu ɨɨn nuu, ti taka ichi yakua na ndundoo, ti taka ichi kueꞌe na nduu ɨɨn nuu. Ti siaꞌan kuni yo ja na ndundaa añu yɨvɨ nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ti taka yɨvɨ ñuyɨvɨ nakuni i nasa kii nama Yandios maa i. Siaꞌan ni kaꞌan Juan nava ni chiso Isaías nuu tutu na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ti nu ni ka kejaꞌa ka jakoyo yɨvɨ kuaꞌa nuu Juan ja na skuanducha da i, ti ni kachi da nuu i: ―Roꞌo, ka kuu ra nanu koo. ¿Xi ka jani ini ra ja nama ra maa ra nuu ɨɨn nundoꞌo kuan kuyajni nuu ra naa ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Na kachi ri ja kava yɨñuꞌun naa ra nava na kuni ndaa yo ja, ja ni ka nakani ini ra. Ti nava siaꞌan na nduu ra nanu ɨɨn yujnu vixi ja jaꞌa ndeꞌe vaꞌa, chi ka saꞌa ra jniñu vaꞌa. Ti siaꞌan ka stuu ra maa ra ja, ja ni ka nakani ndixia ini ra, ti ni ka xndoo ra kuachi ra. Ti tu kondoꞌo vixi ini ra naa ra ja kaꞌan ra: “Maa yo naa yo chi ka kuu yo jnaꞌan Abraham na janaꞌan.” Tu kaꞌan ra siaꞌan, chi na kachi ri nuu ra ja suni undi yuu jaꞌa, ti kuu saꞌa Yandios ja na kuu i jnaꞌan Abraham. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ti yɨvɨ ja tu ka kuni nakani ini nuu kuachi un, ja iyo tuꞌva Yandios ja kuaꞌa ya ɨɨn nundoꞌo ja kondoꞌo i. Ti yukan kuu nanu ɨɨn chaa ja iyo tuꞌva da ja kin sandoo da nuu huerta da, ti kaꞌncha da yujnu ja tukaa jaꞌa ndeꞌe vaꞌa un, ti kiꞌin nuu ñuꞌun ja na kayu ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ti ni ka kachi yɨvɨ un: ―¿Ti ndoo saꞌa na vijna naa na nusa? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ti ni kachi Juan: ―Nu roꞌo ka ñavaꞌa uu saꞌma, ti kuaꞌa ɨɨn nuu yɨvɨ ja tundo ka ñavaꞌa, ti nau roꞌo ka iyo ja kaji, ti kuaꞌa nuu yɨvɨ ja tundo ka ñavaꞌa ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Suni ni ka jaꞌan sava chaa ka kinyaꞌu puestu un nuu Juan, ja na skuanducha da chaa, ti ni ka kachi da: ―Maestro, ¿Ti ndoo saꞌa saña naa na, nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ti ni kachi Juan: ―Kinyaꞌu ndaa naa ra nava kaꞌan ley, ti koto skaa yaꞌu ga ra ja kinyaꞌu ra nuu puesto ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ti suni siaꞌan ni ka jikajnuꞌun uu soldado un maa da, ti ni ka kachi: ―¿Ti saña, ndoo saꞌa na nusa? ―ni ka kachi da. Ti ni kachi tuku Juan: ―Koto ma kuisonchaa ra ni ɨɨn ndajniñu yɨvɨ naa i ja siuꞌu ra i, xi ja na chakuachi ra i nu tundo ka saꞌa i. So nɨnɨ kuu ja na kuantaꞌu ra xuꞌun yaꞌu ra ni ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ti yɨvɨ kuaꞌa un ka ndoꞌo ini i ja xi Juan kuu Cristo ja ka ndatu i ja kii un, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ko maa Juan ni kachi da nuu yɨvɨ kuaꞌa un: ―Jandaa kuu ja ruꞌu skuanducha ri roꞌo naa ra jiin nducha, ko vaji ɨɨn ja kuñaꞌnu ga ja kuu ruꞌu, ti maa chaa yukan skuanducha da roꞌo naa ra, ti kuaꞌa da Espíritu Santo ja na kunchaa ya jiin ra. Ti siaꞌan nanu sandoo ɨɨn ñuꞌun nuu kayu, suni siaꞌan sandoo Espíritu Santo undi ini añu ra naa ra. Ti tu kuu kandu ri nuu da, chi kuñaꞌnu ga da ja kuu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ti chaa un xndichi da yɨvɨ nanu ɨɨn chaa ja ja yɨjnɨ tuꞌva da pala da ja xndeche da triu da, ti kenso da paja kiꞌin ti savaꞌa da triu da ini veꞌe, ti kaꞌma da paja un. Ko chaa un, chi kuaꞌa da nundoꞌo nuu yɨvɨ jiin ɨɨn ñuꞌun ja tu ndaꞌva kuɨtɨ ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ti jnuꞌun jaꞌa jiin tɨjnɨ ga jnuꞌun ni xndaku Juan, ti ni kaꞌan da jnuꞌun Yandios nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Suni ni kachi Juan nuu Herodes ja tu iyo vaꞌa ɨɨn jniñu saꞌa da. Chi Herodes kuu da gobernador, ti ni jaka da Herodías, ñasɨꞌɨ ñani da Felipe, ja na kunchaa ña jiin da. Ti suni ni kaꞌan da ja tɨjnɨ ga jniñu kueꞌe saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ko Herodes, tu ni jandatu da jnuꞌun ni kaꞌan Juan, chi suꞌva viꞌi ga ni saꞌa ndevaꞌa da ja ni chunde da Juan vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na ti kɨvɨ ga Juan vekaa, ni kunde da ni skuanducha da yɨvɨ, ti suni ni skuanducha da Jesús. Ti hora ni skuanducha da Jesús ni jikantaꞌu ya nuu Yandios, ti ni nuña ni andɨvɨ nuu kancha Yandios, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ti ni kuun Espíritu Santo, ti ni jinu xini ya, ti kaa nanu ɨɨn sata. Yukan ti ichi andɨvɨ ni kaꞌan Yandios jiin Jesús: ―Roꞌo kuu Seꞌe ri ja kundaꞌu xaan ini ri, ti kusɨɨ xaan ini ri jiin ra ―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na ni kejaꞌa Jesús undi nuu kuɨtɨ jiin jniñu ni tatu Yandios nuu ya, ja iin ya yajni oko uxi kuiya. Ti ka jani ini yɨvɨ ja ni kuu ya seꞌe yɨɨ José. Ti jnaꞌan José ni kuu seꞌe yɨɨ Elí, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ti Elí ni kuu seꞌe Matat, ti Matat ni kuu seꞌe Leví, ti Leví ni kuu seꞌe Melqui, ti Melqui ni kuu seꞌe Jana, ti Jana ni kuu seꞌe José, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ti José ni kuu seꞌe Matatías, ti Matatías ni kuu seꞌe Amós, ti Amós ni kuu seꞌe Nahum, ti Nahum ni kuu seꞌe Esli, ti Esli ni kuu seꞌe Nagai, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ti Nagai ni kuu seꞌe Maat, ti Maat ni kuu seꞌe Matatías, ti Matatías ni kuu seꞌe Semei, ti Semei ni kuu seꞌe José, ti José ni kuu seꞌe Judá, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ti Judá ni kuu seꞌe Joana, ti Joana ni kuu seꞌe Resa, ti Resa ni kuu seꞌe Zorobabel, ti Zorobabel ni kuu seꞌe Salatiel, ti Salatiel ni kuu seꞌe Neri, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ti Neri ni kuu seꞌe Melqui, ti Melqui ni kuu seꞌe Adi, ti Adi ni kuu seꞌe Cosam, ti Cosam ni kuu seꞌe Elmodam, ti Elmodam ni kuu seꞌe Er, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ti Er ni kuu seꞌe Josué, ti Josué ni kuu seꞌe Eliezer, ti Eliezer ni kuu seꞌe Jorim, ti Jorim ni kuu seꞌe Matat, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ti Matat ni kuu seꞌe Leví, ti Leví ni kuu seꞌe Simeón, ti Simeón ni kuu seꞌe Judá, ti Judá ni kuu seꞌe José, ti José ni kuu seꞌe Jonán, ti Jonán ni kuu seꞌe Eliaquim, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ti Eliaquim ni kuu seꞌe Melea, ti Melea ni kuu seꞌe Mainán, ti Mainán ni kuu seꞌe Matata, ti Matata ni kuu seꞌe Natán, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ti Natán ni kuu seꞌe David, ti David ni kuu seꞌe Isai, ti Isai ni kuu seꞌe Obed, ti Obed ni kuu seꞌe Booz, ti Booz ni kuu seꞌe Salmón, ti Salmón ni kuu seꞌe Naasón, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ti Naasón ni kuu seꞌe Aminadab, ti Aminadab ni kuu seꞌe Aram, ti Aram ni kuu seꞌe Esrom, ti Esrom ni kuu seꞌe Fares, ti Fares ni kuu seꞌe Judá, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ti Judá ni kuu seꞌe Jacob, ti Jacob ni kuu seꞌe Isaac, ti Isaac ni kuu seꞌe Abraham, ti Abraham ni kuu seꞌe Taré, ti Taré ni kuu seꞌe Nacor, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ti Nacor ni kuu seꞌe Serug, ti Serug ni kuu seꞌe Ragau, ti Ragau ni kuu seꞌe Peleg, ti Peleg ni kuu seꞌe Heber, ti Heber ni kuu seꞌe Sala, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ti Sala ni kuu seꞌe Cainán, ti Cainán ni kuu seꞌe Arfaxad, ti Arfaxad ni kuu seꞌe Sem, ti Sem ni kuu seꞌe Noé, ti Noé ni kuu seꞌe Lamec, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ti Lamec ni kuu seꞌe Matusalén, ti Matusalén ni kuu seꞌe Enoc, ti Enoc ni kuu seꞌe Jared, ti Jared ni kuu seꞌe Majalaleel, ti Majalaleel ni kuu seꞌe Cainán, ");
INSERT INTO mpmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ti Cainán ni kuu seꞌe Enós, ti Enós ni kuu seꞌe Set, ti Set ni kuu seꞌe Adán, ti Adán ni kuu seꞌe Yandios, chi maa ya ni saꞌa ya maa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nu ni niꞌin Jesús Espíritu Santo ja ni kukutu ini ya jiin, na ni kee ya ini yucha Jordán, ti maa Espíritu Santo ni yɨndaꞌa ya undi nuu ñuꞌun teꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yukan ni kuncha ya uu xiko kɨvɨ, ti jaꞌuꞌu un kuni keꞌe ya. Ti nɨ kɨvɨ un, tu ni yee kuɨtɨ ya staa. Ti nu ni yaꞌa kɨvɨ un, ti ni chaa soko ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yukan na ti ni kachi jaꞌuꞌu un jiin ya: ―Nu ndixia ra ja Seꞌe Yandios kuu ra, ti saꞌa ja taka yuu jaꞌa na nduu staa kaji yo ―kachi jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ti ni kachi Jesús: ―Suꞌva yoso nuu tutu Yandios ja ansu jiin nɨnɨ staa kuchaku yɨvɨ naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yukan na ti ni yɨndaꞌa jaꞌuꞌu un maa ya undi xini yuku sukun un. Ti yukan ɨɨn jinu kuɨtɨ ni ni xnaꞌan nuu ya taka ñuu kaꞌiin nuu nɨɨ kaꞌnu ñuyɨvɨ, ");
INSERT INTO mpmNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ti ni kachi jaꞌuꞌu jiin ya: ―Kuaꞌa ri ɨɨn jniñu nuu ra ti taꞌu ra jniñu nu taka ñuu un, chi vii xaan kanda, chi maa ri kuu ja xiin un. Ti kuu kuaꞌa ri nuu ra, nuu nau ja kuu ini maa ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nusa ti jakunjitɨ ra nuu ri, ti chiñuꞌun ra ruꞌu, ti maa ri na kuaꞌa ndɨꞌɨ taka un nuu ra ―ni kachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ko ni kachi Jesús: ―Kuxio nuu ri roꞌo jaꞌuꞌu, chi suꞌva kachi nuu tutu Yandios: “Chiñuꞌun nuu maa Jitoꞌo ra Yandios, ti nuu maa ɨɨn ni ya kunukuachi ra”, kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yukan na ti ni yɨndaꞌa tuku jaꞌuꞌu un ya undi ñuu Jerusalén, ti ni skaa ya xini veñuꞌun kaꞌnu un, ti ni kachi: ―Nu ndixia ra ja kuu ra Seꞌe Yandios, ti skanakava maa ra undi nuu ñuꞌun, ");
INSERT INTO mpmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","chi siaꞌan yoso nuu tutu Yandios: Taꞌu Yandios jniñu nuu ángel ya ja na koto ya roꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ti na kindaꞌa ya roꞌo nava tu stuji ra sɨꞌɨn ra nuu ni ɨɨn yuu ―ni kachi jaꞌuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ti ni kachi Jesús: ―Tuu, chi suꞌva yoso nuu tutu Yandios: “Koto ma xnaꞌan ga ra nuu maa jitoꞌo ra Yandios” ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja yukan ti tukaa ga ni kojnuni ini jaꞌuꞌu un nasa saꞌa jiin Jesús, ti ni kuxio kuaꞌan jaku kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yukan ti ni nandeokuñɨ Jesús ichi ñuu Galilea, chi siaꞌan ni yɨndaꞌa Espíritu Santo maa ya. Ti nɨ ndañuu ja yɨꞌɨ jiin Galilea, yukan ni jichanuu jnuꞌun ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ti xnaꞌan ya jnuꞌun Yandios ini veñuꞌun Israel taka nuu ka ndututu, ti tendɨꞌɨ yɨvɨ nuu un ni ka jajnuꞌun i ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yukan ti ni nandeokuñɨ ya ñuu Nazaret nuu ni jaꞌnu ya. Ti ɨɨn kɨvɨ ndetatu ni kɨvɨ ya ini veñuꞌun un nava jini saꞌa ya. Ti ni ndokuɨñɨ ya ja na kaꞌu ya tutu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ti ni ka jaꞌa da tutu ni chaa profeta Isaías nuu ya. Ni jiña ya tutu un, ti ni naniꞌin ya nuu yoso siaꞌan, ti ni kaꞌu ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Maa Espíritu Jitoꞌyo Yandios kancha jiin ri. Yukan ni jaꞌa ya jniñu nuu ri ja xndaku ri nuu yɨvɨ ndaꞌu, ja kaꞌan ri ja kundaꞌu ndixia ini ya nuu i naa i. Ni taji ya ruꞌu ja na kuaꞌa ri jnuꞌun ndee ini nuu yɨvɨ ka kukuiꞌya ini, ja na kaꞌan ri ɨɨn jnuꞌun vaꞌa nuu yɨvɨ ka yɨndiꞌyu nuu kuachi, nava na ketaꞌu i. Saꞌa ri ja na kujnuni ini yɨvɨ tu ka jnuu ini. Suni ja na nama ri yɨvɨ ni ka skexiko yɨvɨ maa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ti suni ja na kachi ri ja, ja ni jaa kuiya nu ni ndundaꞌu ini Jitoꞌyo Yandios nuu yɨvɨ naa i. Kachi tutu ja ni kaꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ni nakasɨ Jesús tutu un, ti ni nakuaꞌa ya nuu chaa junukuachi ini veñuꞌun un, ti ni nukoo ya. Ko vanuxia tendɨꞌɨ yɨvɨ kaꞌiin ini veñuꞌun un ka ndeꞌe nuu ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ti ni jakunchaa ya ni kaꞌan ya: ―Vijna na ti ni kundaa nava yoso nuu tutu Yandios ja ni ka jinisoꞌo ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tendɨꞌɨ yɨvɨ un ni ka jajnuꞌun i Jesús, ti so ka naa ini i ja vii xaan kaꞌan ya jiin i, ti ka jikajnuꞌun jnaꞌan i: ―¿Ti ansu seꞌe José kuu chaa jaꞌa nu? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti ni kachi Jesús jiin yɨvɨ un: ―Ja jini vaꞌa ri nava ka ndoꞌo ini ra, ti suni ka kaꞌan ra jnuꞌun jaꞌa jiin ri: “Nu ndixia ni ja kuu ni médico, saꞌa ni tajna ti sa na kandixia na naa na maa ni.” Ti suni kachi ra jiin ri: “Jnuꞌun ni ka jinisoꞌo na, ja ni saꞌa ni ñuu Capernaum, saꞌa ni suni ñuu maa ni jaꞌa” ―ni kachi ya jiin i. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yukan na ti ni siin Jesús kaꞌan ya, ti ni kachi ya: ―Jandaa na kachi ri nuu ra naa ra ja ni ɨɨn profeta kaꞌan jnuꞌun Yandios, tu ka jantaꞌu yɨvɨ ñuu da maa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chi jandaa kuu ja ni ka iyo kuaꞌa ñaꞌan ni ka kendo ndaꞌu nación Israel undi janaꞌan na ni kii profeta Elías, na ni kii jnama xaan ini nɨɨ nación un, ja uni kuiya sava tukaa ga ni kuun sau. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko Elías tu ni jaꞌan da nuu kanchuku ñaꞌan ni ka kendo ndaꞌu ñuu Israel, chi ni jaꞌan da nuu kancha ɨɨn vajnuꞌun ni ñaꞌan ni kendo maa ɨɨn ñaa nuu ñuu Sarepta, yajni ñuu Sidón, ɨɨn ñuu ja tu ni yɨꞌɨ jiin Israel. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Suni ñuu Israel ni ka iyo kuaꞌa yɨvɨ ni ka kuꞌu jiin ndɨꞌyɨ teꞌyu na ni kii profeta Eliseo, ko tu ni ka nduvaꞌa ni ɨɨn yɨvɨ ka kuꞌu un, chi maa ɨɨn ni Naamán ni nduvaꞌa, ja ni kuu da chaa ñuu Siria, ɨɨn ñuu ja tu ni yɨꞌɨ jiin ñuu Israel ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nu ni ka jinisoꞌo yɨvɨ jnuꞌun ni kaꞌan ya, ti tendɨꞌɨ yɨvɨ kaꞌiin ini veñuꞌun un, ni ka kɨtɨ xaan ini nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ti ni ka ndonda yɨvɨ un sɨkɨ ya ja ni ka keniꞌin da Jesús undi fuera yuꞌu ñuu un. Ti kuankoyo da jiin ya undi yuꞌu yuku un ja ka kuni skanakava da yaa kava un. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko Jesús ni nayaꞌa ya maꞌñu da naa da, ti kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yukan na ti kuaꞌan Jesús ñuu Capernaum, ɨɨn ndañuu Galilea. Yukan ni jaꞌa kunchaa ya ni xnaꞌan ya nuu yɨvɨ un ɨɨn kɨvɨ ndetatu. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ti so ka naa ini yɨvɨ un ka ñusoꞌo i jnuꞌun kaꞌan ya, chi kaꞌan ya jnuꞌun ndaa kuɨtɨ nanu kaꞌan ɨɨn chaa ndiso jniñu nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti ini veñuꞌun un kande ɨɨn chaa jnaꞌan tachi xaan, ja ni kanajiin koꞌo, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Kuxio ni nuu na naa na, niꞌin Jesús, chaa ñuu Nazaret. ¿Ndoo kɨvɨ nduu ni jiin na, xi vaji ni ja xnaa ni saña nu? Ja nakuni na niꞌin, ti jini na ja maa ni kuu seꞌe ii Yandios ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ti Jesús ni nduxaan ya nuu tachi xaan un, ti ni kachi ya: ―Kasɨ yuꞌu ti xndoo chaa jaꞌa ―ni kachi ya. Yukan na ti tachi xaan un ni saꞌa ja na kuikokava chaa un nuu yɨvɨ un, ti ni kee kuaꞌan. Ti tundo ni saꞌa jiin chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ti so ni ka saꞌu ini yɨvɨ un ja so ka naa ini i ka ndeꞌe i, ti ka jikajnuꞌun jnaꞌan i: ―¿Naa jnuꞌun kuu jaꞌa ja siaꞌan ni kuu? Kuñaꞌnu chaa jaꞌa ja taꞌu da jniñu nuu tachi xaan un, ti ka jandatu nuu da, ti ka kekoyo kuaꞌan ―kachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ti jnuꞌun Jesús ni jichanuu taka nuu ñuu Galilea yukan. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yukan na ti ni kee Jesús ini veñuꞌun un ti kuaꞌan ya ichi veꞌe Simón. Ni kɨvɨ ya veꞌe da. Ti ini veꞌe Simón kancha nana chiso da kuꞌu ña jiin kueꞌe kiji xaan. Ti ni kakandaꞌu da jiin Jesús ja na saꞌa ya tajna ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ni jankudandijin Jesús, ti ni kachi ya ja na kee kiji un, ti ni kenchaa ni kiji un kuaꞌan. Ti ni ndoko ni ña, ti ni kejaꞌa satuꞌva ña ja ni yaji ya jiin da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nu kuan kee ndikandii, ti taka yɨvɨ ka ñavaꞌa yɨvɨ kuꞌu, ja ka jnaꞌan i tɨjnɨ nuu kueꞌe, ni ka yɨndaꞌa i yɨvɨ un nuu Jesús, ti Jesús ni chaa ya ndaꞌa ya sɨkɨ ɨɨn ɨɨn yɨvɨ un, ti ni ka nduvaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ti maꞌñu tendɨꞌɨ yɨvɨ kuꞌu un, ka iyo yɨvɨ ka jnaꞌan tachi xaan, ko ni keniꞌin ya kuankoyo. Ti nu ni ka kekoyo kuaꞌan, ka kanajiin ti ka kaꞌan: ―Roꞌo kuu Seꞌe Yandios ―kachi. Ko Jesús ni nduxaan ya jiin tachi xaan un ja tukaa ni jaꞌa ya jnuꞌun ja kaꞌan, chi ja ka jini ja maa ya kuu Cristo, ja ni taji Yandios ja ndiso ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nu ni kundijin ɨnga kɨvɨ, ti ni kee maa ɨɨn ni Jesús kuaꞌan ya ɨɨn yuꞌu ñuu un nu tukaa yɨvɨ. Ko ni ka nanduku yɨvɨ un ya naa i, ti ni ka naniꞌin i nuu kande ya. Tu ka kuni i ja kiꞌin tukuu ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ko ni kachi ya jiin yɨ: ―Kanuu kuu ja kiꞌin ri uu ga ñuu un suni, ja na kaꞌan ri ti na xndaku vaꞌa ri nasa kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, chi sɨkɨ yukan ni taji Yandios ruꞌu vaji ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ti siaꞌan ni jikonuu Jesús ni kaꞌan ya jnuꞌun Yandios nuu taka veñuꞌun Israel ka iyo ñuu Galilea un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ti ɨɨn kɨvɨ kande Jesús yuꞌu lago Genesaret. Ti ni ka kututu yɨvɨ kuaꞌa xaan nuu ya ja undi ka jaxin jnaꞌan i, ja ka kuni kunsoꞌo i jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ti ni jini ya ja kaꞌiin uu barco yajni yuu lago un, chi chaa ka jnɨɨ chāká un, ni ka kee da ka nakacha da ñunu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ti ni kɨvɨ Jesús ini ɨɨn barco ja xiin Simón, ti ni kaꞌan ya jiin Simón ja na skaka da ɨɨn tɨꞌlɨ barco un na kiꞌin nuu nducha un. Yukan na ti ni nukoo ya nuu barco un, ti undi nuu barco un ni xndaku ya nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nu ni ndɨꞌɨ ni xndaku ya nuu yɨvɨ un, ti ni kachi ya jiin Simón: ―Kuaꞌan jiin barco jaꞌa undi nuu kunú ga nducha un, ti skuita kaꞌnu ra ñunu ra naa ra chii nducha un, ti niꞌin kuaꞌa ra chāká ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ti ni kachi Simón: ―Maestro, nɨ niñu ni ka sajniñu na, ko ni ɨɨn chāká tu ni ka niꞌin na. Ko ja kachi maa ni kuu, ti na skuita kaꞌnu na ñunu na nusa ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ko nu ni ka saꞌa da nava ni kachi Jesús, ti ni ka niꞌin da kuaꞌa xaan chákā ja ni kejaꞌa teꞌnde ñunu da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ti ni ka saꞌa da seña nuu uu ga chaa kaꞌiin nuu ɨnga barco da, ja na kin chindee da maa da. Ni ka chindee jnaꞌan da ti ni ka skutu da chāká nuu ndɨnduu barco un, ja kuni kekaꞌnu ni ga chii nducha un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nu ni jini Simón Pedro ja siaꞌan ni kuu, ni jakunjitɨ da nuu Jesús, ti ni kachi da: ―Vaꞌa ga kuxio ni nuu na Jitoꞌyo, chi kuu na ɨɨn chaa nchakuachi ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chi Simón jiin uu ga chaa kaꞌiin jiin da un, so ni ka saꞌu ini da ja ni ka niꞌin kuaꞌa da chāká ni saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Suni Jacobo jiin Juan, seꞌe yɨɨ Zebedeo, ja suni kaꞌiin da jiin Simón yukan. Suni so ni ka saꞌu ini da. Ko ni kachi Jesús jiin Simón: ―Koto ma xndɨꞌɨ ini ra, chi undi vijna ti tukaa ga jnɨɨ ra chāká, chi ruꞌu na xnaꞌan ri nuu ra nasa nastutu ra yɨvɨ, ti xnaꞌan ra yɨvɨ un maa jnuꞌun Yandios ja na kandixia i ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yukan na ti nu ni ka tava da barco un nuu ñuꞌun ichi, ti ni ka xndoo ndɨꞌɨ kuɨtɨ da ndajniñu un, ti kuankoyo da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ti ni kuu ja kande Jesús ɨɨn ñuu un, ti ni jaa ɨɨn chaa kuꞌu kueꞌe ndɨꞌyɨ teꞌyu. Ti nu ni jini da nuu Jesús, ti ni jankunjitɨ da nuu ya, ti ni sino da nuu da undi nuu ñuꞌun, ti ni kandaꞌu da jiin Jesús: ―Jitoꞌyo, nu kuni ni, ti kuu sandoo ni saña jiin kueꞌe jnaꞌan na jaꞌa―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yukan ti Jesús ni kueꞌe ya maa da jiin ndaꞌa ya, ti ni kachi ya: ―Kuni ri, na ndundoo ra vijna ―ni kachi ya. Ti nu ni kaꞌan ya siaꞌan, ni nduvaꞌa ni chaa kuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yukan ti ni xndaku niꞌin ya nuu da ja tu kani kuɨtɨ da jnuꞌun nuu ni ɨɨn yɨvɨ. Ko ni kachi ya: ―Kuaꞌan ti kiꞌin ra nuu sutu kuñaꞌnu un, na ndeꞌe da roꞌo ja, ja ni nduvaꞌa ra. Ti kundaꞌa ja soko ra nuu Yandios sɨkɨ ja, ja ni ndundoo ra nava taꞌu ley Moisés jniñu. Ti na soko sutu un nuu Yandios, nava na kuni yɨvɨ ja, ja ni kenchaa ndɨꞌyɨ un roꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ti jnuꞌun Jesús, viꞌi ga ni jichanuu kuaꞌan ja sɨkɨ ɨɨn jniñu ñaꞌnu ni saꞌa ya yukan. Ti ja yukan kuu ja kuaꞌa xaan ga yɨvɨ ka kututu ja ka kuni kunsoꞌo i jnuꞌun kaꞌan ya, jiin ja na saꞌa ya tajna maa i, nuu taka kueꞌe ka ndoꞌo i. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ko tɨjnɨ jinu kee sɨɨn maa ya kuaꞌan ya nuu tukaa yɨvɨ, ti yukan jikantaꞌu ya nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti ɨɨn kɨvɨ kande Jesús xnaꞌan ya nuu yɨvɨ naa i, ti ichi chukan kanchuku sava chaa fariseo jiin chaa ka xnaꞌan ley Moisés ja vekoyo da taka ñuu Galilea, jiin ñuu Judea, jiin ñuu Jerusalén. Ti ka ndeꞌe da jniñu saꞌa Jesús, ja jiin jniñu ñaꞌnu maa Yandios saꞌa ya tajna yɨvɨ kuꞌu naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yukan ti ni ka jakoyo jaku chaa ka yɨndaꞌa ɨɨn chaa tɨkuku nuu ɨɨn yúú, ti ka kuni skɨvɨ da chaa un ini veꞌe, ti skatu da chaa nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ko tu ni kuu kɨvɨ da naa da, chi kuaꞌa xaan yɨvɨ kaꞌiin un. Yukan na ti ni ka kaa da xini veꞌe, ti ni ka xndonda da teja un, ti ni ka sino da chaa kuꞌu un jiin yúú da maꞌñu yɨvɨ kuaꞌa un nuu kancha Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nu ni jini Jesús ja ni ini da ka kandixia da ja kuu saꞌa ya tajna chaa kuꞌu un, ti ni kachi ya jiin chaa kuꞌu un: ―Ndaꞌu seꞌe ri, ja ni jankaꞌnu ini ri nuu kuachi ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yukan na ti chaa ka xnaꞌan ley un jiin chaa fariseo un ni kejaꞌa ka ndoꞌo ini da: ―¿Nau kuu chaa jaꞌa ja ndoꞌo ini da ja kuu da Yandios, ti siaꞌan kaꞌan kaꞌan ndevaꞌa da sɨkɨ Yandios jiin jnuꞌun un nusa? Ti tu ni ɨɨn ja kuankaꞌnu ini nuu kuachi yo, chi vajnuꞌun ni maa Yandios ―ni ka ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ko Jesús ja ni jini ya ndoo ka ndoꞌo ini da, ti ni kachi ya: ―¿Ndoo ka ndoꞌo ini ra siaꞌan? ");
INSERT INTO mpmNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Chi na kachi ri ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti ndiso jniñi ri ja kuan kaꞌnu ini ri nuu kuachi yɨvɨ naa i. Vijna ti na stuu ri ɨɨn jniñu saꞌa ri jaꞌa ―kachi Jesús. Yukan na ti ni kachi ya jiin chaa tɨkuku un: ―Ndoko, nastuu yúú ra, ti kuanoꞌon veꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti hora ni, ni ndoko chaa tɨkuku un maꞌñu yɨvɨ kuaꞌa un, ni nakiꞌin da yúú nu ni katuu da nuu un, ti kuanoꞌon da veꞌe da. Ti ni nakanajaa da Yandios ja ni nduvaꞌa da ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ti tendɨꞌɨ yɨvɨ un so ni ka naa ini i ja siaꞌan ni saꞌa ya. Ti ni ka kanajaa i Yandios, ti ni ka kaꞌan i: ―Vijna ndixia ti ni ka jini yo ɨɨn jniñu ñaꞌnu xaan ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yukan na ti ni kee Jesús ti kuaꞌan ya, ti ni jini ya nuu ɨɨn chaa kinyaꞌu puesto ja nani Leví, nukoo da nuu kinyaꞌu puestu un, ti ni kachi ya jiin da: ―Ñaꞌan na choꞌo, ti kundikun ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ti ni ndokuɨñɨ Leví, ni xndoo ndɨkuɨtɨ da ja ñavaꞌa da un, ti kuaꞌan da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yukan na ti ni nasaꞌa da ɨɨn viko kaꞌnu veꞌe da ja kusɨɨ ini da jiin Jesús, ti yukan ni kaꞌiin kuaꞌa chaa ka kinyaꞌu nuu puestu jiin uu ga yɨvɨ ni kunchuku jiin da naa da nuu mesa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ko chaa fariseo jiin chaa ka xnaꞌan ley Moisés, ni ka kejaꞌa ka kaꞌan nchaa da sɨkɨ ndajaꞌa Jesús, ti ni ka kachi da: ―¿Ndoo ka yee ra ka jiꞌi ra jiin chaa ka kinyaꞌu nuu puestu un, jiin taka chaa tu ka siuku ley Israel? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti ni kachi Jesús: ―Yɨvɨ iyo vaꞌa ndendajnu, tu ka nandɨꞌɨ i médico, chi yɨvɨ kuꞌu kuu ja ka nandɨꞌɨ tajna un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja yukan kuu ja ruꞌu tu vaji ri ja kaꞌan ri jnuꞌun Yandios nuu yɨvɨ ka ndoꞌo ini ja iyo ndoo jiin kuachi. Chi suꞌva ni nchaa ri ja kaꞌan ri jnuꞌun Yandios nuu yɨvɨ ka nakuni nuu kuachi i nava nakani ini i nuu Yandios ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yukan na ti ni ka jikajnuꞌun da nuu Jesús: ―¿Ndoo chaa ka skuaꞌa jiin Juan jiin chaa ka skuaꞌa jiin chaa fariseo, nɨnɨ ka iyo ndicha ini da, ti tɨjnɨ jinu ka jikantaꞌu da, ti ndajaꞌa ni nɨnɨ ka yee da, ti ka jiꞌi da? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti ni kachi ya jiin da: ―¿Xi kuu koo ndicha ini yɨvɨ kaꞌiin ɨɨn viko nandaꞌa nu nɨ kancha novio un jiin yɨ nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko jaa ɨɨn kɨvɨ ja kuxio novio nuu i. Yukan na ti sa na koo ndicha ini i. Suni nu kancha ri, tu kuu koo ndicha ini chaa ka skuaꞌa jiin ri. Ko jaa ɨɨn kɨvɨ nu na kujiyo ri, yukan na sa na koo ndicha ini da naa da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ti ni kachi ya jaꞌa nuu da: ―Ni ɨɨn yɨvɨ tu kaꞌncha i ɨɨn pedasu saꞌma jaa ti nachaa i nuu ɨɨn saꞌma tuꞌu. Chi nu siaꞌan na saꞌa i, ti stɨvɨ i saꞌma jaa un, chi tu kejnaꞌan ja jaa jiin ja tuꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni tu kuu chuꞌun yo vino jaa chii ɨɨn ñɨɨ tuꞌu. Chi nu siaꞌan na kuu ti xnaa yo ndɨnduu. Chi vino jaa un ndata ñɨɨ tuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ja yukan kuu ja na chuꞌun yo vino jaa chii ñɨɨ jaa, chi siaꞌan ti ni ɨɨn tu xnaa yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ti ni ɨɨn ja ja ni jiꞌi vino ava ti koꞌo tuku vino jaa, chi vanuxia ka kaꞌan yɨvɨ ja nɨnɨ vaꞌa ga vino ni kuu ava ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ɨɨn kɨvɨ ndetatu ni yaꞌa Jesús jiin ndajaꞌa ya nuu kaa triu. Ti ndajaꞌa ya kuankoyo da ka kenchaa da yoko triu un, ka kɨɨn da ini ndaꞌa da ti ka yee da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yukan ti sava chaa fariseo ni ka jikajnuꞌun da ya: ―¿Ndoo ka saꞌa ra jniñu ja tu kusaꞌa yo ɨɨn kɨvɨ ndetatu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ti ni kachi Jesús jiin da: ―¿Xi tu ni ka kaꞌu kuɨtɨ ra tutu nasa ni saꞌa David na ɨɨn jinu ja ni jiꞌi da soko jiin taka chaa ni kanchuku jiin da nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ja ni kɨvɨ da ini veꞌe ii Yandios, ti ni kiꞌin da staa stila ii ja ni soko sutu nuu Yandios, ti ni yee da. Ti suni ni jaꞌa da nuu yɨvɨ kanchuku jiin da, ja tu kaꞌan nuu ley ja tu kuu kaji ɨnga yɨvɨ, chi maa ni maa sutu kuu ja yaji staa stila un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Suni ni kachi ya jiin da: ―Ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kuñaꞌnu ga ri ti taꞌu ri jniñu nuu kɨvɨ ndetatu jaꞌa―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ti ɨnga kɨvɨ ndetatu, ni kɨvɨ Jesús ini veñuꞌun Israel, ti ni xnaꞌan ya nuu yɨvɨ naa i. Ti yukan kande ɨɨn chaa ni ichi ndaꞌa kuaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ti chaa ka xnaꞌan ley jiin chaa fariseo, ka jito yuꞌu da Jesús ja nu saꞌa ya tajna chaa un nuu kɨvɨ ndetatu un, ti siaꞌan niꞌin da ichi ja kankuachi da jaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ko maa ya chi ja jini ya ndoo ka ndoꞌo ini da naa da, ti ni kachi ya jiin chaa ni ichi ndaꞌa un: ―Ndokuɨñɨ ti kundichi ra maꞌñu jaꞌa―ni kachi ya. Ni ndokuɨñɨ chaa un ti ni jakuɨñɨ da maꞌñu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yukan na ti ni kachi Jesús jiin taka yɨvɨ un: ―Na kajnuꞌun ri ɨɨn jnuꞌun nuu ra naa ra: “¿Nau ɨɨn ja iyo vaꞌa ja saꞌa yo vijna kɨvɨ ndetatu nu? ¿Xi kuu saꞌa yo ja vaꞌa, xi vaꞌa ga saꞌa ndevaꞌa yo? ¿Kuu nama yo ɨɨn chaa kuꞌu un, xi kuaꞌa ini yo na kuū da nu”? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ti ni ndeꞌe vaꞌa Jesús nuu tendɨꞌɨ yɨvɨ un, ti ni kachi ya jiin chaa kuꞌu un: ―Skaa ndaꞌa ra ―ni kachi ya. Ti chaa un ni skaa da ndaꞌa da, ti hora ni, ni nduvaꞌa ndaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ko sava yɨvɨ kaꞌiin un, ni ka kuɨtɨ xaan ini ja siaꞌan ni kuu, ti ni ka kejaꞌa ka ndajnuꞌun nasa saꞌa da ndonda da sɨkɨ Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ni kuu jaku kɨvɨ kuaꞌan Jesús undi yuku un ja kakantaꞌu ya, ti yukan ni kendo ya nɨ niñu ni jikantaꞌu ya nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nu ni kundijin ɨnga kɨvɨ ti ni kana ya chaa ka skuaꞌa jiin ya, ti ni nakaji ya ndɨ uxi uu da, ja ni skonani ya da apóstol, chi kundiso jniñu da ja na kaꞌan da jnuꞌun ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ti chaa un ka kuu Simón ja ni skonani ya da Pedro, jiin ñani da Andrés; Jacobo jiin Juan; Felipe jiin Bartolomé; ");
INSERT INTO mpmNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo jiin Tomás; Jacobo, seꞌe yɨɨ Alfeo; Simón, chaa ni yɨꞌɨ jiin partido cananista; ");
INSERT INTO mpmNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, seꞌe yɨɨ Jacobo; jiin ɨnga Judas, ɨɨn chaa ñuu Cariote ja kuee ga ti ni nakuaꞌa da Jesús nuu yɨvɨ jito uꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yukan na ti ni nūū Jesús xini yuku un jiin ndajaꞌa ya, ti ni jakuɨñɨ ya ɨɨn nduꞌva. Ti kuaꞌa xaan yɨvɨ ndañuu Judea, yɨvɨ ñuu Jerusalén jiin yɨvɨ vekoyo ichi yuꞌu mar Tiro jiin Sidón, ni ka kututu un ja ve kunsoꞌo jnuꞌun xnaꞌan Jesús, jiin suni ja na nduvaꞌa i jiin kueꞌe ka ndoꞌo i. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ti yɨvɨ ka ndoꞌo tachi xaan suni ni ka nduvaꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ti tendɨꞌɨ yɨvɨ un ka kuni kueꞌe i saꞌma Jesús, chi jiin jniñu ndiso ya un saꞌa ya tajna tendɨꞌɨ yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yukan na ti ni ndeꞌe vaꞌa Jesús nuu ndajaꞌa ya ti ni kachi ya: ―Na kachi ri ja kandichi Yandios jiin roꞌo yɨvɨ ndaꞌu, chi jandaa kuu ja kɨvɨ ra ñuu nuu taꞌu ya jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kandichi Yandios jiin roꞌo ja ka jiꞌi soko vijna naa ra, chi jaa kɨvɨ ja kee ndendajnu ra naa ra. Kandichi Yandios jiin roꞌo ja vijna ka iyo ra jnukuiꞌya ini, chi ɨnga kɨvɨ ti kusɨɨ ini ra, ti kuaku ra na ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kandichi Yandios jiin ra naa ra, chi koto uꞌu yɨvɨ roꞌo ti keniꞌin i roꞌo ichi fuera, kaꞌan ndevaꞌa i nuu ra, ti skexiko i roꞌo naa ra nanu ja ka kuu ra yɨvɨ ndevaꞌa ja sɨkɨ ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ko kɨvɨ un ti ndusɨɨ ini ra, chi kusɨɨ xaan ini ra, chi kaꞌnu xaan koo taꞌu ra nuu andɨvɨ, chi suni siaꞌan ni ka saꞌa ndevaꞌa jnaꞌan da jiin chaa ni ka kuu profeta, ni ka kaꞌan jnuꞌun Yandios na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ko na ndaꞌu ga taka roꞌo chaa riku, chi vijna ni ga ka iyo sɨɨ ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Na ndaꞌu roꞌo naa ra ja ka iyo ndendajnu ra vijna, ko jaa kɨvɨ ja kuu ra soko. Na ndaꞌu ra naa ra, vijna chi ka jaku ra, ko jaa kɨvɨ ja ndukuiꞌya ini ra ti ndeꞌe ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Na ndaꞌu ra naa ra, chi kuajnuꞌun yɨvɨ roꞌo, chi siaꞌan ni ka jajnuꞌun i chaa ni ka xndoñaꞌan ja ka kuu da profeta, chaa ni ka kaꞌan jnuꞌun Yandios vasu tu ni kuu da, chi mani chaa ni ka xndoñaꞌan ni ka kuu da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Siin Jesús xndaku ya, ti ni kachi ya: ―Ko roꞌo naa ra kunsoꞌo jnuꞌun na kaꞌan ri. Kundaꞌu ini ti kaꞌan vaꞌa ra jiin yɨvɨ jito uꞌu roꞌo. Saꞌa ja vaꞌa ja kuu yɨvɨ ka saꞌa ndevaꞌa nuu ka kuɨtɨ ini i nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kaꞌan vaꞌa jiin yɨvɨ jikantaꞌu jaꞌa ra ja na jnaꞌan ra ɨɨn nundoꞌo. Kakantaꞌu nuu Yandios ja kuu yɨvɨ ka chakuachi sɨkɨ ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Koto kinjnaꞌan ra jiin yɨvɨ kani roꞌo, chi suꞌva nu ni kani ɨɨn nuu ra, ti kuaꞌa ɨnga nuu ra na kani tuku i. Nu ɨɨn yɨvɨ kuni kuisonchaa i saꞌma ra, sia na kiꞌin yɨvɨ un jiin, ti suni koto kinyɨɨ ra camisa ra, kuaꞌa na kiꞌin yɨvɨ un jiin. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kuaꞌa nuu nuu yɨvɨ jikanuu nuu ra, ti nu ɨɨn yɨvɨ jisonchaa i ja ñavaꞌa ra, kuaꞌa ra kiꞌin, ti koto ma nandakan ga ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nu kuni ra ja na kaꞌan yɨñuꞌun yɨvɨ jiin ra, ti kava yɨñuꞌun tu maa ra nava na kaꞌan yɨñuꞌun yɨvɨ jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Chi nu nɨnɨ yɨvɨ mani ra jiin kaꞌan vaꞌa ra, ¿Nau taꞌu ra iyo nusa? Chi undi chaa ka saꞌa ndevaꞌa ka saꞌa siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ti nu nɨnɨ nuu yɨvɨ chindee roꞌo ni yukan chindee ra, ¿nau taꞌu ra iyo nusa? Chi undi chaa ka saꞌa ndevaꞌa ka saꞌa siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ti nu kuaꞌa ra nɨnɨ nuu yɨvɨ jini ra ja kuu chunaa i nuu ra, ¿nau taꞌu ra iyo nusa? Chi undi chaa ka saꞌa ndevaꞌa, suni ka jaꞌa nuu nuu jnaꞌan da, chi jini da ja chunaa i nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ko maa ra naa ra, kaꞌan vaꞌa jiin yɨvɨ ka jito uꞌu roꞌo, ti chindee yɨvɨ un. Kuaꞌa nuu nuu da, ti tu kuñukuu ini ra ja kakan ra yaꞌu nuu da. Chi nu siaꞌan saꞌa ra, ti iyo kuaꞌa taꞌu ra nuu Yandios, chi siaꞌan jaꞌa ra jandaa ja ka yɨꞌɨ ra jiin Yandios, ya kancha andɨvɨ. Chi maa ya vaꞌa ini ya jiin taka ni yɨvɨ, vasu ɨɨn yɨvɨ ja tu jini nakuantaꞌu nuu ya jiin yɨvɨ ndevaꞌa xaan. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ja yukan kuu ja na kava ndaꞌu ini ra naa ra, siaꞌan nanu ñundaꞌu ini Tata ra Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Siin Jesús xndaku ya, ti ni kachi ya: ―Koto kuu ichi ini ra nuu yɨvɨ ja kaꞌan ndoo ra. Chi nu siaꞌan na saꞌa ra, ti kankuachi Yandios sɨkɨ ra, ja suni siaꞌan kaa tu maa ra. Koto kankuachi ra jaꞌa yɨvɨ. Chi nu siaꞌan kaꞌan ra ti kankuachi Yandios sɨkɨ ra. Koto ma kachi ra ja ni jnaꞌnu ndatu ñanijnaꞌan ra. Chi nu siaꞌan na kaꞌan ra, ti kachi Yandios ja ni jnaꞌnu ndatu maa ra. Kuankaꞌnu ini nuu ñanijnaꞌan ra nava na kuankaꞌnu ini Yandios nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ti ansu nɨnɨ ja na kuankaꞌnu ini ra nuu ñanijnaꞌan ra, chi suni kuaꞌa savaꞌni ga ja nandɨꞌɨ da, ti maa Yandios na nakuaꞌa ya viꞌi ga nuu ra. Ti chikuaꞌa vaꞌa ya nuu ra nanu ni chikuaꞌa maa ra nuu ñanijnaꞌan ra undi na chitu ndɨɨ bolsa ra. Siaꞌan saꞌa ra, chi nu jiin kuꞌva un chikuaꞌa ra nava nandɨꞌɨ ñanijnaꞌan ra, ti suni siaꞌan na nachikuaꞌa Yandios nava nandɨꞌɨ tu roꞌo ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Suni ni xnaꞌan Jesús ɨnga jnuꞌun nuu yɨvɨ un, ti ni kachi ya: ―Na kajnuꞌun ri nuu ra naa ra. ¿Xi kuu koxnuu ɨɨn chaa kuaa nuu ɨnga chaa kuaa ja nduku da ichi kiꞌin da nu? ¿Xi ansu ndɨnduu da nukoyo ɨɨn yau nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yukan kuu ja kuu maa ra naa ra, nu ka kuu ra maestro ja xnaꞌan jnuꞌun Yandios nuu ɨnga yɨvɨ. Tu iyo ni ɨɨn ndajaꞌa ja ndu ɨɨn nuu jiin maestro da, chi xnakan na kutuꞌva da taka ja xnaꞌan maestro un. Yukan na ti sa ndu ɨɨn nuu da jiin maestro da. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¡Suni na kajnuꞌun ri nuu ra! ¿Xi vatuni ja kaꞌan ndoo ra ja kuu ichi ini ra ndeꞌe ra ñanijnaꞌan ra, nu iyo ɨɨn kuachi i, vasu jakuu ga kaa tu maa ra jiin kuachi ra xino? ");
INSERT INTO mpmNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Xi vatuni ja kaꞌan ndoo ra sɨkɨ ñanijnaꞌan ra, ja kaꞌan vixi ra sɨkɨ da xino? Ndeꞌe naa kaa jniñu saꞌa ra, ti xaan yuji ra jiin kuachi un. Ko na kachi ri ja yɨvɨ ñaa xini kuu ra, ja tu jini ra ja xnakan ndeꞌe vaꞌa ra nasa kancha ra jiin kuachi ra, ti sa kuu kotonchaa ra kuachi lulu saꞌa ñanijnaꞌan ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Siin Jesús xndaku ya nuu yɨvɨ un, ti ni kachi ya: ―Saꞌa yo nanu. Ja ka jini ra ja tu iyo ni ɨɨn yujnu vaꞌa ja kuaꞌa ndeꞌe kueꞌe, ni tu iyo ni ɨɨn yujnu kueꞌe ja kuaꞌa ndeꞌe vaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chi nakuni yo nau nuu taka yujnu kuu nu jini yo naa ndeꞌe kuaꞌa. Suni tu kuniꞌin yo tɨchɨ vixi xini nuꞌiñu xaan, xi kuniꞌin yo ndeꞌe tɨkaꞌya xini ɨɨn nuꞌiñu. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Siaꞌan kuu chaa vaꞌa, chi ndoꞌo ini da mani jniñu vaꞌa. Ti chaa ndevaꞌa un, mani jniñu kueꞌe ndoꞌo ini da. Ti yuꞌu da, chi kaꞌan nava ndoꞌo ini da ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yukan ti ni kachi Jesús nuu yɨvɨ kuaꞌa ni ka ndututu un: ―Nde kuaꞌa ra kachi jiin ri naa ra: “Niꞌin kuu jitoꞌo na, ti saña kuu seꞌe ni.” Vasu ka kaꞌan ra siaꞌan, ko tu ka jandatu ra jnuꞌun ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ko vijna na xnaꞌan ri nasa kuu yɨvɨ vekoyo nuu ri, ja chunsoꞌo jnuꞌun kaꞌan ri, ti jandatu i jnuꞌun ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yɨvɨ un kuu i nanu ɨɨn chaa ni saꞌa ɨɨn veꞌe. Kunuu teyɨɨ ni skee da yuu ndiso nama veꞌe un. Yukan ni kii ɨɨn sau xaan, ti ni ndaa nducha ja kuni xnaa veꞌe un, ko tu ni kanda veꞌe un, chi kutu xaan ni kee jaꞌa veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ti yɨvɨ ka chunsoꞌo jnuꞌun kaꞌan ri, ti tu ka jandatu i, yɨvɨ un kuu i nanu ɨɨn chaa ni saꞌa veꞌe da, ko tu ni skee kunu da yuu ja kundiso nama veꞌe un. Ti ñuu ni jaꞌa ɨɨn sau xaan ti ni ndaa nducha, ti ni nduva veꞌe un kuaꞌan, ti ni naa ii ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nu ni ndɨꞌɨ ni kaꞌan Jesús nuu yɨvɨ un, ti kuaꞌan ya ichi ñuu Capernaum. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ti yukan kande ɨɨn chaa kuu capitán, ja kuu chaa yɨndaꞌa ɨɨn ciento soldado, ja ka yɨꞌɨ i jiin ejército ñuu Roma. Ñavaꞌa da ɨɨn muzu junukuachi nuu da, ti kundaꞌu xaan ini da chaa un. Ni kiꞌin kueꞌe maa da ja kuni kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ti nu ni jinisoꞌo da jnuꞌun Jesús, ti ni taji da uu chaa ka kuñaꞌnu Israel, ja na kiꞌin kandaꞌu da jiin Jesús, ja na kin saꞌa ya tajna chaa junukuachi nuu da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ni ka tuꞌva da nuu Jesús, ti ni ka kandaꞌu xaan tonto da siaꞌan: ―Kuni capitán un ja na chindee ni da, ti vaꞌa ga ja na saꞌa ni, ");
INSERT INTO mpmNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","chi mani da jiin yɨvɨ ñuu na. Ti maa da ni taꞌu jniñu ja ni kuu veñuꞌun na naa na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yukan na ti kuaꞌan Jesús jiin da naa da. Ko nu kuan kuyajni ya veꞌe capitán un, ti chaa un ni taji da uu amigo da ja na kachi da nuu Jesús siaꞌan: ―Jitoꞌyo, kuñaꞌnu ga ni ja kuu saña, ti tu ɨɨn nuu na jiin ni. Ja yukan kuu ja tu kuni na ja kɨvɨ ni veꞌe na. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja yukan kuu ja tu ni kuni na ja jaa maa na ja nanduku na niꞌin. Chi so kuni na ja na taꞌu ni jniñu ti na nduvaꞌa muzu na. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chi saña suni iyo ɨɨn chaa kuñaꞌnu taꞌu jniñu nuu na, ti suni maa na ñavaꞌa na soldado na. Ti kachi na jiin ɨɨn da “kuaꞌan”, ti kiꞌin da. Ti kachi na jiin ɨnga “ñaꞌan jaꞌa”, ti kii da. Ti taꞌu na jniñu nuu muzu ja na saꞌa i jniñu un, ti saꞌa i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nu ni jinisoꞌo Jesús jnuꞌun un, so ni naa ini ya. Ti ni ndeokoto ya nuu yɨvɨ kuaꞌa kuankoyo jiin ya un, ti ni kachi ya: ―Jandaa na kachi ri nuu ra naa ra ja nɨ tuꞌu ñuu Israel tu iyo ni ɨɨn yɨvɨ kandixia da ruꞌu nanu ni kandixia chaa jaꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nu ni ka najakoyo chaa ni taji da un veꞌe, ti ni ka jini da ja, ja ni nduvaꞌa chaa kuꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nu ni yaꞌa un, ti kuaꞌan Jesús ɨɨn ñuu nani Naín. Suni kuankoyo ndajaꞌa ya jiin kuaꞌa xaan ga yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti nu kuan kuyajni ya ñuu un, ti ni jini ya kuankoyo yɨvɨ kuan chunduji i ɨɨn ndɨyɨ, ti maa ɨɨn ni ndɨyɨ yukan ni kuu seꞌe yɨɨ ɨɨn ñaꞌan ni kendo maa ɨɨn. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nu ni jini Jesús nuu ñaꞌan un, ti ni kundaꞌu ini ya maa ña, ti ni kachi ya jiin ña: ―Koto ndeꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yukan ti ni tuꞌva Jesús, ti ni keꞌe ya jajnu ndɨyɨ un, ti ni ka jankuñɨ chaa ka ndiso jajnu un, ti ni kachi ya jiin ndɨyɨ un: ―Chaa lulu, na kachi ri jiin ra: ¡Ndokoo! ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yukan ti ni ndoko chaa lulu ja ja ni jiꞌi un, ti ni kejaꞌa da kaꞌan da, ti ni nakuaꞌa Jesús maa da nuu nana da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nu ni ka jini yɨvɨ un, ti ni ka yuꞌu xaan i, ti ni ka kejaꞌa ka nakanajaa i Yandios siaꞌan: ―Ni kenda ɨɨn profeta kuñaꞌnu nuu kanchuku yo naa yo vijna ―ni ka kachi i. Suni ni ka kachi i siaꞌan: ―Ni chaa Yandios ja vee chindee ya ñuu ya ―kachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yukan ti ni jichanuu jnuꞌun jniñu ni saꞌa Jesús nɨ ñuu Judea jiin taka ga ñuu kaꞌiin yajni un. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yukan ti chaa ni ka kuu ndajaꞌa Juan, ni ka jani da jnuꞌun nuu da sɨkɨ taka jniñu saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ti ni taji da uu ndajaꞌa da un ja na kinkoyo da nuu kande Jesús, ja na kajnuꞌun da ya nu maa ya kuu Cristo ja kii un, xi kundatu da ɨnga, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ni jakoyo chaa un nuu kande Jesús, ti ni ka jikajnuꞌun da ya: ―Juan, chaa skuanducha un, ni taji da saña naa na nava na kajnuꞌun na ja nu maa ni kuu Cristo ja ni chisojnuꞌun Yandios ja kii un. ¿Xi kundatu yo ɨnga? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti hora ni jakoyo chaa un, ni kuu ja saꞌa Jesús jniñu ñaꞌnu kenchaa ya taka nuu kueꞌe ka jnaꞌan yɨvɨ un, ti keniꞌin ya tachi xaan, jiin ja ka ndundijin nduchi tɨjnɨ yɨvɨ kuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ti ni kachi Jesús jiin chaa ni taji Juan: ―Kuankoyo naa ra ti kani jnuꞌun nuu Juan naa ra sɨkɨ taka ja ni ka jini ra jiin taka jnuꞌun ni ka jinisoꞌo ra jaꞌa naa ra. Kachi nuu da ja yɨvɨ kuaa un ka ndundijin nduchi i, jiin yɨvɨ tɨkuku un ja ka jika i, jiin suni ka ndundoo chaa ka jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu un, jiin yɨvɨ soꞌo un ka ndundijin soꞌo i jiin ja ka nandoto ndɨyɨ un naa i, jiin ja kuu nuu yɨvɨ ndaꞌu kaꞌan ri jnuꞌun Yandios ja nasa nanitaꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ti kachi jiin da ja kandichi Yandios jiin yɨvɨ, ti tu yuꞌu i kundikun i ruꞌu vasu na kondoꞌo koo nene i ja sɨkɨ ruꞌu ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nu ni ka yaꞌa chaa ni taji Juan un kuankoyo da, ti ni kejaꞌa Jesús kaꞌan ya jiin yɨvɨ un sɨkɨ naa chaa kuu Juan, ti ni jikajnuꞌun ya: ―Na ni ka jandeꞌe ra undi nuu ñuꞌun teꞌe un, ¿Ndoo ka ndoꞌo ini ra ja saꞌa chaa un? Ti tu ni ka jini ra ɨɨn chaa nanu ɨɨn yoko icha ja kanda saꞌa tachi un, ti chaa un tu ni sama nuu nuu da jnuꞌun kaꞌan da, chi ɨɨn ni jnuꞌun ni kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ti nu ni ka jandeꞌe ra yukan, ¿xi ni ka jini ra ja ñuꞌun da saꞌma vaꞌa nu? Va tuu, chi na kachi ri ja yɨvɨ ka ñuꞌun saꞌma fino kanchuku da ini veꞌe chaa ka kuu rey. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ti ndoo ni ka jandeꞌe ra nusa? ¿Xi ka jani ini ra ja maa da kuu profeta ja kaꞌan jnuꞌun Yandios nu? Ti jandaa ndixia kuu ja chaa un, kuu da ɨɨn profeta ja kaꞌan da jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan ni kuu chaa kaꞌan nuu tutu Yandios nuu kachi siaꞌan: Na taji ri tajnu ri ja na koxnuu da jaa da. Ti na satuꞌva da yɨvɨ naa i sa kiꞌin ra. Ni kachi Yandios, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jandaa na kachi ri ja tukaa ga ni ɨɨn yɨvɨ nanu Juan ja kuñaꞌnu ga ja kuu Juan chaa skuanducha un. Ko yɨvɨ ja, ja ni ka jantaꞌu jnuꞌun sɨkɨ nasa taꞌu Yandios jniñu, vasu tu ka ndiso ni ɨɨn jniñu nanu Juan, ko kuni ga yɨvɨ un jniñu ñaꞌnu ga ja saꞌa ya ansu maa da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chaa ka kinyaꞌu puesto jiin kuaꞌa ga yɨvɨ un, ni ka kuu yɨvɨ ni skuanducha Juan. Ja yukan kuu ja ni ka jantaꞌu i jnuꞌun ni kaꞌan Jesús, ti ni ka jaꞌa i jandaa ja mani jnuꞌun Yandios ni kuu ja ni kaꞌan Jesús, chi vanuxia ni ka janducha i nuu Juan ja sɨkɨ ja ni ka nakani ini i nuu kuachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko chaa fariseo un jiin taka chaa ka xnaꞌan ley, tu ni ka jantaꞌu da jnuꞌun Yandios ni kaꞌan Jesús, chi vanuxia tu ni ka jantaꞌu da jnuꞌun ni kaꞌan Juan ni tu ni ka janducha da naa da. Ni ka skexiko da nava kuni saꞌa Yandios jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ti Jesús ni kaꞌan tuku ya, ti ni kachi ya: ―Jaꞌa na kachi ri jiin nau ja skejnaꞌan ri yɨvɨ kanchuku kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chi yɨvɨ ka iyo vijna ka kuu i nanu suchi kuachi nu ni ka nukoo i nuu yaꞌu ti ka yɨsɨkɨ i, ti ka kana xini jnaꞌan i: “Ka tɨvɨ yo xkili, ko tu ni ka jitajaꞌa i. Ti kuaka xaan ni ka jita yo ɨɨn yaa, ko tu ni ka ndeꞌe i”, ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Suni siaꞌan kɨvɨ vijna, chi ni kii Juan, chaa ni skuanducha un, ni kuncha da. Tu ni jiꞌi da ndɨxɨ, ti iyo nasa xndondicha da ini da. Ti roꞌo ni ka kaꞌan ra ja ni yɨꞌɨ da jiin ɨɨn tachi xaan. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yukan na ti ni chaa tu ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ ja tu iyo nasa xndondicha ri ini ri, ti jiꞌi ri. Ko ka chakuachi ra ruꞌu ja yaji xaan ri, ti jiꞌi xaan ri vino, ti kejnaꞌan ri jiin chaa ka kinyaꞌu nuu puesto jiin taka ga yɨvɨ ka saꞌa kuachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nusa ti tu ni ka kandixia ra jniñu ni saꞌa Juan, ni tu ka kandixia ra jniñu ni saꞌa ruꞌu. Ko tundo saꞌa, chi yɨvɨ tuꞌva ka jini i ja iyo vaꞌa savaꞌni ga jniñu ni tatu Yandios nuu ri jiin Juan ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yukan ti ɨɨn chaa fariseo ni kana Jesús ja kusama da jiin ya. Ni jaa ya veꞌe da, ti ni nukoo ya nuu mesa. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti ñuu yukan iyo ɨɨn ñaꞌan sɨɨ ini. Ni niꞌin ña jnuꞌun ja kuaꞌan Jesús veꞌe Simón kuan kusama ya, ti yukan ni jaa ña jiin ɨɨn tɨndoꞌo lulu alabastro ja ñuꞌun chitu aceite perfume. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ni nukoo ña nuu jaꞌa Jesús, ndeꞌe ña, ti ni xndaji ña jaꞌa ya jiin nducha nuu ña, ti ni nasichi ña jiin ixi xini ña. Yukan ti ni teyuꞌu ña jaꞌa ya, ti ni skuchi ña jiin aceite perfume un. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nu ni jini chaa fariseo, chaa ni kana Jesús yukan, ti ni kejaꞌa ndoꞌo ini da: “Nu siaꞌan ti ndixia chaa jaꞌa ja kuu da ɨɨn profeta, ti va kuni da naa ñaꞌan kuu ña, chi kuu ña ɨɨn ñaꞌan sɨɨ ini”, ni ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yukan ti ni kachi Jesús jiin chaa fariseo un: ―Simón, iyo ɨɨn jnuꞌun kuni kaꞌan ri jiin ra ―kachi ya. Ti ni kachi chaa fariseo un: ―Kachi ni maestro ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yukan ti ni kachi Jesús: ―Na kani ri ɨɨn jnuꞌun. Ni ka iyo uu chaa ka tau xuꞌun nuu ɨɨn chaa jaꞌa nuu xuꞌun. Ɨɨn da tau uꞌun ciento xuꞌun plata, ti ɨnga da tau sava ciento. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ko ndɨnduu chaa un tu ka niꞌin da ja chunaa da un. Yukan na ti chaa ni jaꞌa nuu un ni jankaꞌnu ini da nuu ndɨnduu chaa un. Siaꞌan ni kuu jnuꞌun. Vijna ti kachi nuu ri, ¿Nau ɨɨn ɨɨn chaa un kundaꞌu ga ini chaa ni jaꞌa nuu xuꞌun un nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ti ni kachi Simón: ―Ja ndoꞌo ini na va chaa ni tau kuaꞌa ga nuu da un ―ni kachi da. Ti ni kachi Jesús: ―Jandaa kuu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yukan ti ni ndeꞌe Jesús nuu ñaꞌan un, ti ni kachi ya jiin Simón: ―Ndeꞌe nuu ñaꞌan jaꞌa. Ni kɨvɨ ri veꞌe ra ko tu ni siuku ra jnuꞌun ra. Tu ni jaꞌa ra nducha ndundoo jaꞌa ri. Ko ñaꞌan jaꞌa ni xndaji ña jaꞌa ri jiin nducha nuu ña, ti ni nasichi ña jiin ixi xini ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tu ni teyuꞌu ra ruꞌu ja kanxiaꞌu ra jiin ri, ko ñaꞌan jaꞌa, undi ni kɨvɨ ri ni kejaꞌa ña teyuꞌu ña jaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tu ni chuꞌun ra aceite perfume xini ri, ko ñaꞌan jaꞌa, chi ni skuchi ña jaꞌa ri jiin aceite perfume. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaꞌa ti na kachi ri nuu ra ja ndeꞌe mani xaan ña ruꞌu ja na kuankaꞌnu ini ri nuu taka kuachi ni saꞌa ña. Ko ɨɨn yɨvɨ ja tu stuu i maa i ja mani i jiin ri va tu nakani ini i ja iyo kuaꞌa kuachi sɨkɨ i, ni tu nduku i jnuꞌun kaꞌnu ini nuu ri ja na kenchaa kuachi i ―ni kachi Jesús jiin Simón. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yukan ti ni kachi ya jiin ñaꞌan un: ―Ja ni jankaꞌnu ini ri nuu kuachi ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yukan na ti yɨvɨ ni ka jakoyo kanchuku jiin ya yukan, ni ka kejaꞌa ka ndajnuꞌun naa: ―¿Naa chaa kuu chaa jaꞌa ja jankaꞌnu ini da nuu kuachi un? ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ko maa Jesús ni kachi ya jiin ñaꞌan un: ―Ja ni ketaꞌu ra, chi ni kandixia ra ruꞌu. Na kukuee kiꞌin ra vijna ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yukan, ti ni kejaꞌa Jesús jikonuu ya taka ñuu jiin taka rancho, ti xndaku ya nasa kɨvɨ yɨvɨ ndaꞌa Yandios ti taꞌu ya jniñu nuu i. Ka jikonuu ndɨ uxi uu ndajaꞌa ya jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ti suni ka jikonuu tɨjnɨ ñasɨꞌɨ ni saꞌa ya tajna ja ni kenchaa ya tachi xaan ni ka jnaꞌan ña jiin tɨjnɨ nuu ga kueꞌe ni ka jnaꞌan ña naa ña. Ti yukan ni kaꞌiin María, ja suni nani ña Magdalena, ñaꞌan ni keniꞌin ya uxia tachi xaan. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Suni kuaꞌan Juana ñasɨꞌɨ Chuza, chaa ni taꞌu jniñu nuu muzu Herodes chaa ni kuñaꞌnu un. Suni Susana jiin tɨjnɨ ga ñaꞌan ni ka chindee ya jiin ja ka ñavaꞌa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kuaꞌa xaan yɨvɨ uu ga ñuu ni ka jakoyo nuu kande Jesús, ti nu ni ka taka kuaꞌa ga yɨvɨ un, ti ni kejaꞌa Jesús xnaꞌan ya nuu yɨvɨ un siaꞌan, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Ɨɨn chaa jitu triu ni kenda da kuan saka da triu. Ti nuu kuaꞌan da jacha da triu un, sava triu un ni ka nukoyo ini ichi, ni ka jañu niꞌnu yɨvɨ, ti ni ka chakoyo saa un naa tɨ, ti ni ka nastutu tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sava ga triu un ni ka jinu maꞌñu yuu, ti ni jinu triu un, ko nu ni naꞌichi ñuꞌun, ti ni ka ichi. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sava ga triu un ni ka jinu nuu yɨꞌɨ yoꞌo nuꞌiñu. Ti nu ni kaña numa nuꞌiñu un, ti ni ka jasɨ i nuu triu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko sava ga triu un ni ka jinu i nuu yɨꞌɨ ñuꞌun vaꞌa, ti ni kaña triu un ti ni jaꞌnu, ti vaꞌa xaan ni kuu. Ni ka nakuaꞌa undi ɨɨn ciento triu nuu ɨɨn triu tata ―ni kachi ya. Yukan na ti jaa xaan ni kaꞌan Jesús siaꞌan: ―Nau roꞌo na chunsoꞌo, ti nakani ini nasa kuni kaꞌan jnuꞌun un ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yukan na ti ni ka jikajnuꞌun taka chaa ja skuaꞌa jiin Jesús nasa kuni kaꞌan jnuꞌun ni xndaku ya un, ");
INSERT INTO mpmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ti ni kachi ya: ―Ja kuu roꞌo naa ra chi xnaꞌan kaji Yandios nuu ra nasa taꞌu ya jniñu, ko yɨvɨ tu kandixia, na xndaku ri nuu i jiin jnuꞌun un. Chi vasu ñusoꞌo i jnuꞌun kaꞌan ri, ti ndeꞌe i jniñu saꞌa ri, ko jini ri ja tu kuɨtɨ kuni i chaku ini nasa taꞌu ya jniñu. Chi vasu ka ñusoꞌo i jnuꞌun kaꞌan ri, ti ndeꞌe i jniñu saꞌa ri, ko tu chaku ini i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Siin Jesús xndaku ya, ti ni kachi ya: ―Siaꞌan kuni kaꞌan jnuꞌun un. Saꞌa yo nanu ja triu un kuu jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ti yɨvɨ un kuu triu ja ni jinu ichi un, chi chunsoꞌo i jnuꞌun Yandios, ko nu ni chaa jaꞌuꞌu un, ti xndaꞌu da ja tu kandixia i, ti nava tu ketaꞌu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti triu ni jinu nuu yuu yukan kuu nanu yɨvɨ ni ka jinisoꞌo jnuꞌun kaꞌan ri, ni ka jantaꞌu i, ti ka kusɨɨ ini i jiin. Ko vanuxia ja changa ga kuñɨɨ ini i jiin jnuꞌun un, ti nu ni ka kejaꞌa ka jito uꞌu yɨvɨ i ja sɨkɨ jnuꞌun un, ti ka nakani ini i, ti tukaa ga ka kandixia i. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ti triu ni ka jinu nuu yɨꞌɨ yoꞌo nuꞌiñu kuu nanu yɨvɨ ni ka chunsoꞌo jnuꞌun un, ko ka ndɨꞌɨ ga ini i ja kuu taka ga ja iyo nuu ñuyɨvɨ jaꞌa, ja na kuu riku i. Ti yukan kuu ja jasɨ ja tu ka siin jiin jnuꞌun Yandios, chi tukaa kuni kuandatu i nuu jnuꞌun ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko triu ni ka jinu nuu ñuꞌun vaꞌa un kuu nanu yɨvɨ ka chunsoꞌo nɨɨ ini i jnuꞌun Yandios, ti ka chaku ini i nasa kuu jnuꞌun un, ti ka siuku i jiin. Yɨvɨ un ka kuu nanu triu ni ka nakuaꞌa undi ɨɨn ciento triu nuu ɨɨn triu tata ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Siin Jesús xndaku ya, ti ni kachi ya. ―Yɨvɨ yɨndaꞌa ɨɨn yɨtɨ, tu skuikun i ti kasɨ i nuu, ni tu kani yɨ chii jito. Chi suꞌva chuxndee i yɨtɨ un nuu sukun, ti nava na kundijin nuu yɨvɨ ka jakoyo un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Suni siaꞌan kuu jiin jniñu kuaꞌa ri nuu ra naa ra, chi vijna ñuꞌni jaku ni yɨvɨ ka jini, ko jaa ɨɨn kɨvɨ nu kuaꞌa yɨvɨ kuni ndijin. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yukan ti na chunsoꞌo vaꞌa i jnuꞌun kaꞌan ri, chi sɨkɨ yɨvɨ ja kandixia jnuꞌun ri, ti viꞌi ga niꞌin jnaꞌan i inijnuni i ja kunukuachi i nuu ya. Ko yɨvɨ ja tu kandixia, ti viꞌi ga kendo i, ti tu chindee Yandios maa i. Chi suꞌva naa ini i jnuꞌun ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yukan ti ni jakoyo nana Jesús jiin ñani ya nuu kande ya, ti ka kuni ña kaꞌan ña jiin Jesús, ko tu kuu nasa kɨvɨkoyo ña nuu kande ya, chi kuaꞌa xaan yɨvɨ kaꞌiin nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ni jaꞌan ɨɨn chaa ni jan kasjnuꞌun nuu ya, ti kachi da: ―Nana ni jiin ñani ni kaꞌiin da fuera, ti ka kuni kaꞌan da jiin ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ti ni kachi ya jiin chaa un: ―Yɨvɨ ka chunsoꞌo jnuꞌun Yandios ti ka jandatu i jnuꞌun un, yukan kuu nanu nana ri jiin ñani ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɨɨn kɨvɨ ni kɨvɨ Jesús jiin ndajaꞌa ya ini ɨɨn barco, ti ni kachi ya: ―Na choꞌo ɨnga yuꞌu mini un ―ni kachi ya. Yukan ti kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ko nɨ kuankoyo da nuu nducha un, ti ni kixi Jesús. Ichi kuankoyo da ti ni ndonda ɨɨn tachi sau xaan tonto nuu mini un ja kava nuu mani ga nducha un nuu barco un, ti kuni kee kaꞌnu kiꞌin. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ti ni ka xndoto ndajaꞌa un ya, ti ni ka kachi da: ―¡Maestro! ¡Maestro! Ka kuni kekaꞌnu yo chii nducha ―ni ka kachi da. Yukan ti ni ndokuɨñɨ ya ti ni taꞌu ya jniñu nuu tachi sau xaan un jiin mini un, ti naꞌiin kuɨtɨ ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yukan ti ni kachi ya jiin ndajaꞌa ya: ―¿Ndoo ka jnaꞌan ra naa ra nusa? ¿Ka jani ini ra ja tu kuu chindee Yandios roꞌo naa ra nu? ―ni kachi ya. Ko maa da naa da, so ka naa ini da ja ni ka yuꞌu da, ti ni ka kejaꞌa ka jikajnuꞌun jnaꞌan da: ―¿Naa chaa kuu chaa jaꞌa ja undi tachi sau xaan un jiin mini un ka jandatu nuu da? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yukan sa ni ka jakoyo da nuu ñuꞌun ñuu Gadara ja kande ɨnga yuꞌu mini Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nu ni kee Jesús ini barco un, ti ni tuꞌva ɨɨn chaa ñuu un nuu ya. Ti ja ni kuu naꞌan xaan ja jnaꞌan chaa un tachi xaan un. Tu ñuꞌun da saꞌma, ni tu nchaa da veꞌe, chi mani sɨkɨ kava nuu ka ñunduji ndɨyɨ un nchaa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nu ni jini da nuu Jesús, ti ni nduva da nuu jaꞌa ya, ti ni kanajiin da siaꞌan: ―¿Ndoo kɨvɨ nduu ni jiin na, niꞌin Jesús, Seꞌe Yandios kancha andɨvɨ? ¡Jikantaꞌu na nuu ni ja tu kuaꞌa ni nundoꞌo saña! ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Siaꞌan ni kanajiin da, chi Jesús ja ni taꞌu ya jniñu nuu tachi xaan ja na xndoo maa da. Tɨjnɨ jinu jnɨɨ tachi xaan un maa da, ti vasu ka juꞌni yɨvɨ ndaꞌa da jiin sɨꞌɨn da ja na kunuꞌni da, ko kundee da jaꞌncha da, ti kuaꞌan tachi xaan un jiin da undi yuku teꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ni jikajnuꞌun Jesús maa da: ―¿Nasa nani ra? ―ni kachi ya. Ti ni kachi da: ―Nani na Legión ―ni kachi da. Siaꞌan ni kaꞌan da chi Legión kuni kaꞌan ja ka iyo kuaꞌa xaan soldado, ti kuaꞌa xaan tachi un jnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ti tachi un ni ka kandaꞌu jiin Jesús ja tu taji ya kinkoyo ini xnduchi kunu un nuu koto nundoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ti yuku un kaꞌiin kuaꞌa xaan kɨnɨ ka nduku tɨ ja kaji tɨ, ti ni ka kandaꞌu tachi un jiin Jesús ja na kuaꞌa ya jnuꞌun ja na kinkoyo jiin tɨ, ti Jesús ni jaꞌa ya jnuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yukan ti ni ka xndoo tachi xaan un chaa un, ti ni ka kekoyo kuaꞌan, ti ni ka jankuncha jnaꞌan jiin kɨnɨ un. Yukan ti ndɨꞌɨ tɨ ni ka jaꞌa tɨ corrɨ, ni ka nukoyo tɨ xaꞌva, ti ni ka kɨvɨ tɨ nuu nducha mini un, ti ni ka kanchaa tɨ nducha un, ti ni ka jiꞌi tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nu ni ka jini chaa ka ndito kɨnɨ un ja siaꞌan ni ka jnaꞌan kɨnɨ da, ni ka yuꞌu xaan da. Ti ni ka jaꞌa da corrɨ ni ka jan kasjnuꞌun da nuu yɨvɨ ñuu jiin taka yɨvɨ rancho. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yukan ti ni ka kee yɨvɨ ñuu un ni ka jandeꞌe i ja ni kuu un. Nu ni ka jakoyo yɨvɨ un nuu kande Jesús, ti ni ka jini i chaa ni jnaꞌan tachi xaan un nukoo da nuu jaꞌa Jesús, ja ni nduvaꞌa da ti ja ñuꞌun da saꞌma da. Ti nu ni ka jini yɨvɨ un ni ka yuꞌu xaan i. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ti uu ga yɨvɨ ni ka jini i jniñu ñaꞌnu ni saꞌa Jesús ni ka jani i jnuꞌun nasa ni nduvaꞌa chaa ni jnaꞌan tachi xaan un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ko ja sɨkɨ jniñu ñaꞌnu un ni ka yuꞌu xaan tendɨꞌɨ yɨvɨ ñuu Gadara un, ti ni ka kaꞌan da jiin ya ja na kee ya na kiꞌin ya ñuu da un naa da. Yukan na ti ni ndɨvɨ Jesús barco ti kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ko chaa ni jnaꞌan tachi xaan un, na ti kiꞌin ga Jesús ni kaꞌan ndaꞌu da jiin Jesús ja kuni da kiꞌin da jiin ya. Ko maa ya ni kachi jiin da ja na kendo da, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Kuanoꞌon veꞌe ra, ti kani ra jnuꞌun taka ja ni saꞌa Yandios jiin ra ―ni kachi ya. Yukan na ti kuaꞌan chaa un, ti ni jani da jnuꞌun nɨ ñuu nava ni saꞌa Jesús jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu ni nayaꞌa tuku Jesús ɨnga yuꞌu nducha un, ti ni ka kusɨɨ ini yɨvɨ ja ni nchaa tuku ya, chi ka ndatu i ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ti yukan ni jaa ɨɨn chaa nani Jairo, chaa yɨndaꞌa ɨɨn veñuꞌun Israel un. Ni jakunjitɨ da nuu jaꞌa Jesús, ti ni kandaꞌu da jiin ya ja na kiꞌin ya veꞌe da, ");
INSERT INTO mpmNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","chi kuni kuu seꞌe sɨꞌɨ da, ti ma ɨɨn xini i, ko ja iin i uxi uu kuiya. Ti kuaꞌan Jesús jiin da. Ko kuankoyo kuaꞌa xaan yɨvɨ jiin ya ja undi ka jaxin jnaꞌan yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti maꞌñu yɨvɨ un kuaꞌan ɨɨn ñasɨꞌɨ jnaꞌan kueꞌe nɨñɨ xaan tonto ja ni ndoꞌo ña jiin kueꞌe un uxi uu kuiya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ni tuꞌva ña ichi jata Jesús, ti ni keꞌe ña sɨkɨ saꞌma ya. Ti hora ni ni jakuɨñɨ nɨñɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yukan ti ni jikajnuꞌun Jesús yɨvɨ un: ―¿Nau ja ni kueꞌe ruꞌu? ―ni kachi ya. Ti tendɨꞌɨ yɨvɨ un ka kaꞌan ja tuu. Ti Pedro jiin uu ga ndajaꞌa un ni ka kachi da jiin Jesús: ―Maestro, yɨvɨ kuankoyo jaꞌa ka jaxin jnaꞌan i, ti ka chindaꞌa jnaꞌan i, ti jikajnuꞌun ni ja nau ja ni chindaꞌa niꞌin ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yukan ti ni kachi Jesús: ―Iyo ɨɨn yɨvɨ ni keꞌe ruꞌu, chi ni jini ri ja jiin jniñu ndiso ri ni saꞌa ri tajna ɨɨn yɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nu ni jini ñaꞌan un ja ni jini Jesús ja ni keꞌe ña ya, ti undi nɨꞌɨn ña ni tuꞌva ña, ti ni jakunjitɨ ña nuu ya. Ti nuu chitu un ni kachi ña ndoo ni kuu ja ni keꞌe ña saꞌma ya, ti ni nduvaꞌa ña nuu ni kueꞌe ña saꞌma ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yukan ti ni kachi Jesús jiin ña: ―Ndee saꞌni ra hija. Ja ni nduvaꞌa ra chi ni kandixia ra ruꞌu ja kuu saꞌa ri tajna maa ra. Ti na kukuee kiꞌin ra vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ti kaꞌan Jesús siaꞌan, ti ni jaa ɨɨn chaa kande veꞌe Jairo, ti ni kachi da jiin Jairo: ―Ja ni jiꞌi seꞌe sɨꞌɨ ni. Tukaa ndoo saꞌa ni ja kiꞌin ni jiin maestro ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ti Jesús ni jinisoꞌo ya ja siaꞌan ni ka kaꞌan da jiin Jairo. Ko tu ni kiꞌin ya jnuꞌun, ti ni kachi ya jiin Jairo: ―Koto yuꞌu ra, so kuni ri ja na kandixia ra ti nava na nduvaꞌa seꞌe sɨꞌɨ ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nu ni jaa ya veꞌe Jairo, ti tu ni jaꞌa ya jnuꞌun kɨvɨkoyo yɨvɨ jiin ya, chi nɨnɨ Pedro, Jacobo jiin Juan, jiin tata suchi lulu un, jiin nana i ni ka kɨvɨ jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ti tendɨꞌɨ da ka ndeꞌe ja ka naꞌnu ini da suchi lulu un, ko ni kachi Jesús: ―Tu ndeꞌe ra naa ra, chi tu ni jiꞌi suchi lulu jaꞌa, chi so kixi i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ti yɨvɨ kaꞌiin un so ni ka jaku i ja siaꞌan ni kaꞌan Jesús, chi ja ni ka jini da ja ni jiꞌi suchi lulu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ti maa Jesús ni jnɨɨ ya ndaꞌa suchi lulu un, ti jaa xaan ni kaꞌan ya siaꞌan: ―¡Suchi lulu, ndoko! ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ti hora ni, ni nandoto suchi lulu un, ti ni ndoko i. Ti ni taꞌu Jesús jniñu nuu nana i ja na kuaꞌa ña ja kaji i. ");
INSERT INTO mpmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","So ni ka naa ini tata i. Ko maa Jesús ni taꞌu ya jniñu ja tu kani da jnuꞌun ja siaꞌan jniñu ni saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ni nastutu Jesús ndɨ uxi uu ndajaꞌa ya, ti ni jaꞌa ya jniñu ñaꞌnu nuu da naa da ja na kuu keniꞌin da taka nuu tachi xaan, ti suni na saꞌa da tajna yɨvɨ ka jnaꞌan taka nuu kueꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ni taji ya da ja na xnaꞌan da jnuꞌun Yandios sɨkɨ ja nasa kuu kɨvɨ i ndaꞌa ya ja na taꞌu ya jniñu nuu i. Ti ni jaꞌa ya jniñu ja na kenchaa da kueꞌe naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ti ni kachi ya jiin da naa da: ―Tundo kundaꞌa ra naa ra ja kuu ichi, ni ɨɨn yujnu xii, ni ñunu staa, ti ni xuꞌun. Ti suni ɨɨn ni suꞌnu kuu ja kundaꞌa ra naa ra, tu kundaꞌa ra uu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nu ni ka jakoyo ra ɨɨn veꞌe, kendo un naa ra undi nu kuankoyo ra ɨnga ñuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ti taka yɨvɨ ja tu ka jaꞌa veꞌe, ni tu ka chunsoꞌo jnuꞌun Yandios ka kaꞌan ra, kekoyo veꞌe un jiin ñuu i. Ti nu ni kekoyo ra, ti kɨsɨ tɨkacha ini ndijña ra naa ra, na kuu ɨɨn seña ja tu ni ka kandixia jnuꞌun ni ka kaꞌan ra nuu yɨvɨ yukan ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ni kekoyo ndajaꞌa un, ti ni ka jikonuu da taka ñuu ka xnaꞌan da jnuꞌun Yandios, ti ka saꞌa da tajna yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti kuiya un kuu Herodes gobernador nuu ñuu un, ti ni niꞌin da jnuꞌun taka jniñu saꞌa Jesús, ko tu kojnuni ini da sɨkɨ jniñu ñaꞌnu saꞌa Jesús, chi sava yɨvɨ un ka kaꞌan ja Juan kuu, chi ja ni nandoto da maꞌñu ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sava ga ka kaꞌan ja ni ndenda profeta Elías ja ni kii na janaꞌan, ti sava i ka kaꞌan ja ɨnga profeta ni kii na janaꞌan ni nandoto maꞌñu ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ti ni kachi Herodes: ―Ko maa ri ni taꞌu jniñu ja na kaꞌncha da xini Juan, ti ¿naa chaa kuu ja kaꞌan yɨvɨ ja saꞌa taka nuu jniñu ñaꞌnu un nusa? ―ni kachi da. Ti ndiyo ini Herodes ja na kuni da nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yukan ti ni ka nandeokuñɨ ndɨ uxi uu ndajaꞌa Jesús, ja ka nani apóstol, undi ñuu nuu ja ni ka jaꞌan da ni taji ya da naa da. Ti vijna ja ka nani da apóstol, chi ni ka kuu da chaa ni nakaji Jesús ja kujiin da jiin ya. Ti ni ka nakani da jnuꞌun nuu Jesús taka jniñu ni ka saꞌa da. Yukan ti ni yɨndaꞌa Jesús maa da kuankoyo sɨɨn da ɨɨn ñuꞌun teꞌe ja kande yajni ñuu Betsaida. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko ni ka jini yɨvɨ taka nuu kuaꞌan ya, ti ni ka chindikun i kuankoyo i. Ti Jesús ni jantaꞌu ya maa i naa i. Ti ni xnaꞌan ya jnuꞌun Yandios sɨkɨ nasa kuu kɨvɨ i ndaꞌa ya, ja na taꞌu ya jniñu nuu i naa i. Ti suni ni saꞌa ya tajna yɨvɨ ka kuꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ko vanuxia ja kuan kuñaa, ti ni ka tuꞌva ndɨ uxi uu ndajaꞌa un nuu Jesús, ti ni ka kachi da: ―Kaꞌan ni jiin yɨvɨ ja na kiꞌin ndetatu i naa i, ti na nduku i ja kaji i taka rancho jiin ñuu kaꞌiin yajni, chi tundo iyo nuu kaꞌiin yo jaꞌa ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti ni kachi Jesús jiin da naa da. ―Kuaꞌa maa ra ja kaji i naa ra ―ni kachi ya. Ti ni ka kachi da naa da: ―Ko tukaa ga ndoo ka yɨndaꞌa na, chi uꞌun ni ga staa stila jiin uu chāká ni ga ka yɨndaꞌa na. Ti nanu kuan na ja kaji yɨvɨ kuaꞌa jaꞌa naa i nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ti iyo yajni uꞌun mil chaa ni kaꞌiin un. Ti ni kachi Jesús jiin ndajaꞌa ya: ―Kachi jiin yɨvɨ ja na nukoo yukun i sava ciento naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Siaꞌan ni kachi ndajaꞌa ya nuu yɨvɨ un, ti ni ka nukoo i nuu icha un. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yukan na ti ni jnɨɨ Jesús ndɨ uꞌun staa stila un jiin uu chāká un ini ndaꞌa ya. Ni ndakoto ya andɨvɨ, ti ni nakuantaꞌu ya nuu Yandios. Ni sakuachi ya, ti ni jaꞌa ya nuu ndajaꞌa ya ja na tejnaꞌan da nuu yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tendɨꞌɨ yɨvɨ un ni ka yee i nasa ni kundee maa i. Nu ni kuu ni ka yee i, ti ni ka nastutu da uxi uu chika jiin pedazu ni kendoso un. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɨɨn kɨvɨ kancha sɨɨn Jesús jikantaꞌu ya nuu Yandios, ti kaꞌiin yajni ndajaꞌa ya jiin ya. Yukan ti ni jikajnuꞌun ya da naa da siaꞌan: ―¿Nau ja ka kaꞌan yɨvɨ ja kuu ri? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ti ni ka kachi da naa da: ―Sava yɨvɨ ka kaꞌan ja kuu ni Juan ja ni skuanducha un. Sava ga ka kaꞌan ja maa ni kuu profeta Elías, ja ni kii na janaꞌan. Ti sava ga ka kaꞌan ja kuu ni ɨnga profeta janaꞌan, ja ni nandoto maꞌñu ndɨyɨ ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yukan ti ni jikajnuꞌun ya da naa da: ―Ti roꞌo naa ra, ¿nau ja ka ndoꞌo ini ra ja kuu ri? ―ni kachi ya. Ti ni kachi Pedro: ―Maa ni kuu Cristo, Seꞌe Yandios, ja ni taji ya ja ndiso ni jniñu ñaꞌnu ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yukan na ti ni kachi Jesús jiin ndajaꞌa ya ja koto ma kani kuɨtɨ da jnuꞌun nuu yɨvɨ ja maa ya kuu Cristo, ja ni taji Yandios ja ndiso ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ti ni kachi Jesús jiin da naa da: ―Ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, kondoꞌo koo nene ri. Ti taka chaa ka kuñaꞌnu nación Israel, jiin sutu ka kuñaꞌnu, jiin taka chaa ka xnaꞌan ley Israel ini veñuꞌun un, tu kuantaꞌu da ruꞌu. Chi suꞌva kaꞌni da ruꞌu. Ko nu uni kɨvɨ ti nandoto ri maꞌñu ndɨyɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yukan na ti ni kachi ya jiin tendɨꞌɨ yɨvɨ ni ka ndututu un: ―Nu nau yɨvɨ kuni kundikun ruꞌu, ja siuku i jnuꞌun kaꞌan ri, ti na xndoo i taka ja ka ndoꞌo ini i un, ti na tava ini i ja taka kɨvɨ na kondoꞌo koo nene i vasu na kuu i ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chi yɨvɨ kandio ini ja kunchuku vaꞌa i nuu ñuyɨvɨ jaꞌa ja tu kandixia i jnuꞌun ri, ti xnaa i maa i. Ko yɨvɨ na koo ndoꞌo koo nene i ja sɨkɨ ruꞌu, ti suꞌva niꞌin taꞌu i ja kunchuku i nuu andɨvɨ ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Chi tundo niꞌin kuɨtɨ ɨɨn yɨvɨ, vasu na kundee i niꞌin i taka ja iyo nuu ñuyɨvɨ jaꞌa, ti xnaa i añu i nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ko nu ɨɨn yɨvɨ kukanuu i ja sɨkɨ ruꞌu, ja tu kuni kaꞌan i nuu ɨnga yɨvɨ ja kandixia i ruꞌu, nusa ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, suni na kachi ri ja tu ka yɨꞌɨ kuɨtɨ yɨvɨ un jiin ri. Siaꞌan kachi ri kɨvɨ nchaa ri tuku jiin taka ángel ndoo ja ka junukuachi nuu Yandios. Chi ja kuu kɨvɨ un kundiso ri jniñu ñaꞌnu tatu Tata ri Yandios nuu ri naa ri. Yukan ti tu nakuni kuɨtɨ ri taka yɨvɨ ja tu ni kuni xnaꞌan i ja kandixia i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ti ja sɨkɨ kɨvɨ un, na kachi ri ja sava roꞌo ja kaꞌiin jaꞌa kuchaku ra, ti kuni ra nchaa tuku ri jiin ɨɨn jniñu ñaꞌnu xaan ga, ja ɨɨn ni ga jniñu ka taꞌu ri jiin Yandios nuu tendɨꞌɨ ja iyo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Siaꞌan ni kaꞌan Jesús, nu ni yaꞌa yajni una kɨvɨ. Yukan ti ni ka jaꞌan ya jiin Pedro, Jacobo jiin Juan xini ɨɨn yuku, kuan kakantaꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɨ jikantaꞌu ya nuu Yandios, ni nasama nuu ya, ti saꞌma ya ni nduskuɨyɨ xaan nanu ɨɨn nduva ndikandii. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ti yukan ni ka jini da kajiin uu chaa ka ndajnuꞌun jiin ya. Ti ɨɨn chaa un ni kuu ɨɨn chaa ni kuñaꞌnu nuu nación Israel na janaꞌan ni nani Moisés, ti ɨnga chaa un ni kuu profeta ni nani Elías ja ni kii suni undi na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ti vii xaan ni nduu nuu kajiin da, ti nɨ ka ndajnuꞌun da ja kaꞌni yɨvɨ Jesús nuu ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ti Pedro jiin uu ga chaa un, vasu ka jiꞌi xaan da maꞌna, ko ni ka ndoto nduchi da, ti ni ka ndeꞌe da nuu kajiin Jesús jiin uu ga chaa un, ti ni ka nakuni da ja ni nduñaꞌnu xaan Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ti nu ni ka xndoo Moisés jiin Elías Jesús, ti ni kachi Pedro jiin ya: ―Maestro, xaan vaꞌa ja kaꞌiin yo jaꞌa. Na saꞌa yo uni veꞌe kuachi kunchuku yo, ɨɨn kuu ni, ɨnga na kuu Moisés, ti ɨnga na kuu Elías ―ni kachi da. Ko vasu Pedro, tukaa jini da naa jnuꞌun kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti nɨ kaꞌan ga da siaꞌan, ti ni jinu ɨɨn viko nuꞌun ja ni nasuku da naa da, ti yukan ni ka yuꞌu xaan da nu ni kasuku viko un da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ti nuu viko un ni kaꞌan ɨɨn ndusu siaꞌan: ―Jaꞌa kuu seꞌe ri ja kundaꞌu ini ri ti kusɨɨ ini ri jiin. Ti chunsoꞌo jnuꞌun kaꞌan da ―kachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nu ni ndɨꞌɨ ni kaꞌan ndusu un, ti ni ka ndeꞌe da ja maa ɨɨn ni ga Jesús kandichi. Yukan ti naꞌiin kuɨtɨ ni ka kuu da. Tu ni ka jani da jnuꞌun nuu ni ɨɨn yɨvɨ ja siaꞌan ni ka jini da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nu ni ka najinu da jaꞌa yuku un ɨnga kɨvɨ, ti kuaꞌa xaan yɨvɨ ni ka jaꞌan nujnaꞌan Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ti ɨɨn chaa un ni kana xini Jesús, ti jaa xaan ni kachi da: ―Maestro, kandaꞌu na jiin ni ja na kin ndeꞌe ni seꞌe na, chi maa ɨɨn ni jaꞌa kuu seꞌe na. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɨɨn tachi xaan un jnɨɨ i, skanajiin i ti jaꞌni yɨꞌɨ i, kaña tiꞌiñu yuꞌu i. Jaꞌa xaan nundoꞌo i, ti tu kuni sia maa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ja ni kandaꞌu na jiin ndajaꞌa ni ja na kenchaa da kiꞌin, ko tu ni kuu saꞌa da naa da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ti ni kachi Jesús nuu tendɨꞌɨ yɨvɨ un: ―Xaan ga tu ka kandixia ra jniñu saꞌa Yandios. Xaan ga niꞌin ini ra naa ra ja tu ka jandatu ra nuu Yandios. Nasa ga ndoꞌo nene ri ja sɨkɨ roꞌo naa ra. Chaan chaa lulu jña, na kii da naa ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ko nu kuan tuꞌva chaa lulu un nuu Jesús, ni skuiko tuku tachi xaan un maa da nuu ñuꞌun un, ti jaꞌni yɨꞌɨ tuku maa da. Yukan ti ni nduxaan niꞌin ya nuu tachi xaan un, ti ni nduvaꞌa chaa lulu un. Ti ni nakuaꞌa ya nuu tata da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ti tendɨꞌɨ yɨvɨ un ni ka naa ini i jiin jniñu ñaꞌnu saꞌa Yandios. Nɨ ka naa ini yɨvɨ un jiin jniñu ñaꞌnu ni saꞌa Jesús, ti ni kachi ya jiin ndajaꞌa ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Chunsoꞌo vaꞌa jnuꞌun jaꞌa, ti koto naa ini ra naa ra. Ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti iyo ɨɨn da ja nakuaꞌa da ruꞌu nuu ndaꞌa chaa ka jito uꞌu ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ko ndajaꞌa ya tu ka chaku ini da jnuꞌun ni kaꞌan ya un, chi tu ni jaꞌa ya jnuꞌun ja chaku ini da naa da. Ti ka yuꞌu da kaꞌan da jiin ya ja na xndaku ya jnuꞌun ni kaꞌan ya un nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ɨɨn kɨvɨ ti ni ka kejaꞌa ndajaꞌa Jesús ka jikajnuꞌun jnaꞌan da na ndenu nau ɨɨn ɨɨn da kuu ja kuñaꞌnu ga. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ko ni jini Jesús nava ka ndoꞌo ini da. Yukan ni kiꞌin ya ɨɨn suchi lulu, ni jani ya xiin ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ti ni kachi ya jiin da naa da: ―Jiin jniñu ndiso ri na kachi ri ja nu na kundaꞌu ini ra ɨɨn suchi lulu siaꞌan, ti ja ni kuu ra ɨɨn yɨvɨ ni jantaꞌu ruꞌu. Ti ja jantaꞌu ra ruꞌu, ansu nɨnɨ ruꞌu jantaꞌu ra, chi suni jantaꞌu ra Yandios, ya ni taji ruꞌu vaji ri. Ja yukan kuu ja taka roꞌo ja ka ndoꞌo ini ja nukuu ga ja kuu taka ra naa ra, ja tu ka ndoꞌo vixi ini ra, yukan kuu ja kuñaꞌnu ga ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yukan ti ni kachi Juan jiin Jesús: ―Maestro, ni ka jini na ɨɨn chaa ja jiin sɨvɨ ni ni kenchaa da tachi xaan un kuaꞌan, ti ni ka nduxaan na jiin da, chi tu yaku da jiin yo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ti ni kachi Jesús jiin da: ―Tu kasɨ ra ja saꞌa da, chi chaa kenchaa tachi xaan nanu saꞌa ri, suni chindee da yoꞌo naa yo, chi tu kaꞌan da sɨkɨ yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nu kuan kuyajni kɨvɨ ja kee Jesús ñuyɨvɨ jaꞌa noꞌon ya andɨvɨ, ni chundee ini ya ti kuaꞌan ya ichi ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ni taji ya uu chaa ka yoxnuu, ti chaa un ni ka jaꞌan ɨɨn ndañuu Samaria ka nduku da nuu kendo ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ko yɨvɨ Samaritano un tu ni ka jantaꞌu ja kendo ya yukan, chi ni ka jini ja Jerusalén kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yukan ti nu ni ka jini Jacobo jiin Juan ja yɨvɨ Samaritano un, tu ni ka jantaꞌu i Jesús, ti ni ka kachi da: ―Jitoꞌyo, kuaꞌa ni jnuꞌun ti na taꞌu yo jniñu ja na jinu ñuꞌun andɨvɨ, ti na xnaa yo yɨvɨ Samaritano un, nanu ni saꞌa profeta Elías na janaꞌan―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yukan ti ni ndeꞌe Jesús nuu da naa da, ni nduxaan ya, ti ni kachi ya: ―Roꞌo naa ra, tu ka jini ra na jnuꞌun ka kaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Chi ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, tu vaji ri ñuyɨvɨ jaꞌa ja xnaa ri yɨvɨ naa i, chi suꞌva, vaji ri vee nama ri sɨkɨ yɨvɨ naa i ―ni kachi ya. Yukan na ti kuankoyo da ɨnga ñuu tuku. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nɨ kuankoyo da ichi un, ti ni kenda ɨɨn chaa ni kachi jiin Jesús: ―Jitoꞌyo, kuni kiꞌin na jiin ni vasu savaꞌa ni ga ichi na kiꞌin ni, ti kiꞌin yo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ti ni kachi Jesús jiin da: ―Ñukuii un chi ka iyo yau kava ka yɨꞌɨ tɨ. Ti saa un suni ka iyo taka tɨ nuu ka ndetatu tɨ. Ko ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, va sa nanu iyo nuu ndetatu tɨꞌlɨ xini ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yukan ti ni kachi Jesús jiin ɨnga da: ―Kundikun ruꞌu na choꞌo ―ni kachi ya. Ti ni kachi chaa un: ―Jitoꞌyo, kundatu ni na kin chunduji na tata na xnakan, sa chaa na, ti na choꞌo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ti ni kachi Jesús jiin da: ―Jini ra ja ka iyo yɨvɨ un ja kanchuku i nanu ndɨyɨ, chi tu ka chunsoꞌo i jnuꞌun Yandios. Ti sia yɨvɨ un na chunduji jnaꞌan maa i. Ko roꞌo, kin xnaꞌan ra jnuꞌun Yandios nau yɨvɨ kuu kɨvɨkoyo i ndaꞌa maa ya, ja na taꞌu ya jniñu nuu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yukan ti ni kenda ɨnga chaa ni kachi jiin ya: ―Jitoꞌyo, kuni kiꞌin na jiin ni, ko kundatu ni na kin kanxiaꞌu na jiin yɨvɨ ni ka kendo veꞌe na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti ni kachi Jesús jiin da: ―Saꞌa yo nanu ja iyo yɨvɨ ni chisojnuꞌun ja na kin kunukuachi i nuu Yandios, ko tu kundee i jiin jnuꞌun ni chiso i un. Yɨvɨ un kuu nanu ɨɨn chaa kiꞌin latu da ja na kutu da itu da, ko tu kundee da xndɨꞌɨ da jniñu un. Ti yɨvɨ un tu kaxaan ja kunukuachi i nuu taꞌu Yandios jniñu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nu ni yaꞌa yukan na ti ni nakaji Jitoꞌyo Jesús uni xiko uxi ga yɨvɨ, ti ni taji ya ndɨ uu ndɨ uu da ka yoxnuu da kuankoyo da taka ñuu nuu kiꞌin maa ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ti ni kachi ya jiin da naa da: ―Jniñu Yandios kuu nanu kɨvɨ ka nastutu yo triu, chi jandaa ndixia kuu ja, ja ni kuu ja teꞌnde triu un, ko jaku ni muzu iyo ja kin sajniñu un. Siaꞌan kuu yɨvɨ jaꞌa naa i, chi ndaꞌu ka saꞌa i ja tundo xndaku nuu i, chi kumani chaa kin xndaku un. Yukan kuu ja kaꞌan ri ja kakantaꞌu nuu maa Yandios, ya xiin jniñu un, ti na chuꞌun ya muzu kin nastutu jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kuankoyo naa ra, ko nduku ndee ra, chi taji ri roꞌo naa ra nanu rɨɨ ja kuaꞌan tɨ nuu kaꞌiin kuɨtɨ xaan. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tu kundiso ra xuꞌun ni ñunu staa ja kuu ichi, ti tu kundaꞌa ra ndijña, ti koto jakuñɨ ra ja kanxiaꞌu konuꞌun ra jiin yɨvɨ ichi naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu ka kɨvɨ ra ɨɨn veꞌe ko xnaka kachi ra: “Na kukuee ja kuu veꞌe jaꞌa.” ");
INSERT INTO mpmNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ti nu yukan kanchuku yɨvɨ vaꞌa ini, jiin jnuꞌun kukuee, ti na kuu ja kuu yɨvɨ un naa i. Ko nu tu vaꞌa ini yɨvɨ un, va tu kukuee kanchuku i. Kanxiaꞌu jiin i ti kuankoyo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kendo veꞌe nuu kanchuku yɨvɨ vaꞌa ini, ti kaji ra koꞌo ra ndoo na kuaꞌa yɨvɨ un nuu ra naa ra, chi ɨɨn chaa saꞌa jniñu, suni iyo ichi da ja kinyaꞌu da. Ti koto kakanuu ra naa ra ja ndukunuu ra ɨnga veꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nu ni jakoyo ra ɨɨn ñuu naa ra, ti kaji vasu ndoo na kuaꞌa yɨvɨ nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Saꞌa tajna yɨvɨ ka kuꞌu ka iyo yukan naa ra, ti kachi jiin i: “Jiin jniñu ñaꞌnu un ja ni ka jini ra ja, ja ni jaa kɨvɨ taꞌu Yandios jniñu, ti kuu kɨvɨ ra ndaꞌa ya na taꞌu ya jniñu nuu ra naa ra.” ");
INSERT INTO mpmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko nu na jakoyo ra ɨɨn ñuu nuu tu kuantaꞌu yɨvɨ roꞌo naa ra, kekoyo ichi un, ti kachi naa ra: ");
INSERT INTO mpmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Undi tɨkacha ñuꞌun ñuu ra ja ni jnɨɨ jaꞌa ri naa ri, na kɨsɨ ri, ti yukan na kuu seña ja tu ni ka jantaꞌu ra ruꞌu naa ri. Ko kuñukuu ini ra ja, ja ni jaa kɨvɨ ja kɨvɨkoyo ra ndaꞌa Yandios ja na taꞌu ya jniñu nuu ra naa ra”, kachi ra nuu yɨvɨ ñuu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na kachi ri ja nu na chaa juicio, ti kaꞌnu ga kuu nundoꞌo ja kuu ñuu un, ti ansu yɨvɨ ñuu Sodoma ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Siin Jesús xndaku ya, ti ni kachi ya: ―¡Na xaan ndaꞌu roꞌo yɨvɨ ñuu Corazín! ¡Na xaan ndaꞌu roꞌo yɨvɨ ñuu Betsaida! Sa ti ñuu Tiro jiin Sidón ni saꞌa ri taka jniñu ñaꞌnu un nava ni saꞌa ri nuu ñuu ra naa ra, va ja ni kuu naꞌan ni ka nakani ini yɨvɨ un niku, ti kuꞌun i saꞌma ndaꞌu, ti kuchi i yaa, ja na kuu seña i ja ni ka nakani ini i. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ko na kachi ri ja kɨvɨ nu na chaa juicio, ti niꞌin ga kii nundoꞌo sɨkɨ ra ja kuu yɨvɨ ñuu Tiro jiin Sidón. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ti roꞌo, yɨvɨ ñuu Capernaum, koto ndoꞌo ini ra ja nduñaꞌnu ga ñuu ra. Chi suꞌva nukuu ga ñuu ra, ti ndundaꞌu ga ja kuu taka ga ñuu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ti ni kachi ya nuu ndajaꞌa ya tuku: ―Nu ɨɨn yɨvɨ na kuantaꞌu jnuꞌun ri ja ka kaꞌan ra, ti ɨɨn ni kuu ja kuantaꞌu i ruꞌu. Ko yɨvɨ ja tu kuantaꞌu roꞌo naa ra, ɨɨn ni kuu ja tu kuantaꞌu i ruꞌu. Ti yɨvɨ tu ni jantaꞌu i ruꞌu, ɨɨn ni kuu ja tu kuantaꞌu i Yandios ja ni taji ruꞌu nuu ñuyɨvɨ jaꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ni ka ndenda ndɨ uni xiko uxi chaa ni taji Jesús. Ni ka kusɨɨ ini da, ti ni ka kachi da: ―Jitoꞌyo, undi tachi xaan un ni ka jandatu nuu na, ja ni ka ndaku niꞌin na sɨvɨ ni ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ti ni kachi Jesús: ―Siaꞌan chi jini ri ja, ja ni xnaa jaꞌuꞌu un jniñu ñaꞌnu maa, nanu ja ni sana ini, nanu iyo naa ini yo ti ndinchaa jinu ɨɨn taja nuu andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ti nuu ra naa ra ja ni jaꞌa ri jniñu ñaꞌnu, ti kuu kuañu ra sɨkɨ savaꞌni ga koo xi ndɨsuꞌma, ti kundee ra jiin savaꞌni ga ja jito uꞌu roꞌo, ti ni tundo jnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko tu kusɨɨ ini ra naa ra ja ka jandatu tachi xaan un nuu ra. Chi suꞌva na kusɨɨ ini ra, chi ja ni nakuni Yandios nau ka kuu ra, ti ni nakiꞌin ya roꞌo ndaꞌa maa ya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti hora un ni kusɨɨ xaan ini Jesús ja ni saꞌa Espíritu Santo, ti ni kanajaa ya nuu Yandios: ―Tata na, nakanajaa na niꞌin ja kuu ni jitoꞌo ja taꞌu ni jniñu nɨ tuꞌu andɨvɨ jiin nɨ tuꞌu ñuyɨvɨ jaꞌa, chi ni xnaꞌan ni taka jniñu ñaꞌnu ni nuu yɨvɨ ndaꞌu, ti ni ka chaku ini i. Chi suꞌva ni chisaꞌyɨ ni nuu yɨvɨ tuꞌva ja ndichi xini. Siaꞌan na koo jiin maa ni, Tata na, chi siaꞌan ni kuu ini maa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yukan ti ni kaꞌan Jesús nuu yɨvɨ un: ―Maa tata ri ni nakuaꞌa ya taka jniñu jaꞌa nuu ri. Ti maa ɨɨn ni ya jini nau kuu inijnuni ruꞌu ja kuu ri seꞌe ya. Ti suni ma ɨɨn ni ruꞌu ja kuu ri seꞌe ya, jini ri nau kuu inijnuni maa Tata ri Yandios. Ti suni ruꞌu, ja kuu ri seꞌe ya, na xndaku ri nuu yɨvɨ nau kuu maa Tata ri Yandios ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yukan na ti ni ndeꞌe ya nuu chaa ka skuaꞌa jiin ya, ti ni kachi ya nuu maa ni da naa da: ―Kancha Yandios jiin taka yɨvɨ ka ndeꞌe i jiin nduchi i taka jniñu ñaꞌnu ja ka jini ra vijna. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ti jandaa na kachi ri nuu ra naa ra, ja kuaꞌa xaan profeta ni kikoyo na janaꞌan, jiin taka chaa ni ka kuu rey, ni ka ñukuu ini da ja kuni da taka ja ka jini ra jaꞌa vijna, ko tu ni ka jini da. Suni ni ka ñukuu ini da ja kunsoꞌo da taka jnuꞌun ka jinisoꞌo ra jaꞌa vijna, ko tu ni ka jinisoꞌo da ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yukan na ti ɨɨn chaa xnaꞌan ley Israel un, ni kenda da ni jan kaꞌan da jiin Jesús, chi kuni kotojnuni da ya, ti ni jikajnuꞌun da ya: ―Maestro, ¿nau kuu ja saꞌa na ti ni taꞌu na ja kuchaku na nusa ja kuu saa ni? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti ni kachi Jesús: ―¿Nasa yoso nuu tutu ley Moisés, ti naa jnuꞌun kaꞌu ra yukan, nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ti ni kachi chaa xnaꞌan ley un: ―Kachi ley un ja kuu ini nuu Jitoꞌyo Yandios jiin ni ini ni añu ra, jiin nɨ tuꞌu ra, undi jiin inijnuni ra, ti kundaꞌu ini nuu ñanijnaꞌan ra nanu kundaꞌu ini ra nuu maa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yukan na ti ni kachi Jesús jiin da: ―Jandaa kuɨtɨ ni nachiso ra. Ti nu siaꞌan na saꞌa ra, ti niꞌin taꞌu ra ja kuchaku ra ja kuu saa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko chaa xnaꞌan ley un, kuni nama da jnuꞌun ni kaꞌan da un nuu Jesús, ti ni kachi da: ―¿Ti nau kuu ñanijnaꞌan na nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ti ni kachi Jesús jiin da: ―Na kani ri jnuꞌun nava ni jnaꞌan ɨɨn chaa ni jnaꞌan. Ni kenda da ichi ñuu Jerusalén, ti kuaꞌan da undi ñuu Jericó. Ko ichi un ni ka kenda uu ñakuiꞌna nuu da ja ni ka sakuiꞌna ndajniñu da. Ni ka kenchaa taka ja yɨndaꞌa da, jiin undi saꞌma da ni ka kiꞌin. Ni ka jaꞌa tau da, ti kuankoyo, ti ni kendo chaa un katuu da nanu ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ti ndo ichi yukan ni yaꞌa ɨɨn sutu Israel. Ni jini da nuu katuu chaa un, ko tu ni veꞌe da nuu da, ti ni yaꞌa da ɨnga yuꞌu ichi un, ti ni yaꞌa da kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Suni ichi un ni yaꞌa ɨɨn chaa Israel ja kuu da ɨɨn ndajaꞌa nuu sutu levita naa da. Suni ni jini da nuu katuu chaa un, ko tu ni ndeꞌe da nuu chaa un, ti ni yaꞌa da kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ko ɨɨn chaa ñuu Samaria, ja kuaꞌan da suni ichi yukan, ti nu ni jini da chaa katuu un, ni kundaꞌu ini da maa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ni tuꞌva da nuu katuu chaa un, ti ni saꞌa da tajna nuu ni tuji chaa un jiin aceite, jiin vino yɨndaꞌa da un. Ti ni suku da nuu ni tuji un jiin saꞌma. Yukan na ti ni ndaniꞌin da chaa un, ni skaa da chaa sɨkɨ burru da, ti kuaꞌan da jiin da undi nuu iyo ɨɨn veꞌe ni kendo da. Ti ni jito vaꞌa da chaa jakuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti ɨnga kɨvɨ kuaꞌan chaa ñuu Samaria un, ko ni tava da uu xuꞌun plata, ti ni chunaa da nuu chaa xiin veꞌe un, ti ni kachi da: “Koto vaꞌa ni chaa jaꞌa, ti nu ni xnaa ga ni jiin da, ti na chunaa na nuu ni kɨvɨ nandeokuñɨ na”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Vijna ti kachi nuu ri, ¿nau ndɨ uni chaa un ni kundaꞌu ini nuu ñanijnaꞌan da nusa? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ti ni kachi chaa xnaꞌan ley un: ―Chaa ni kundaꞌu ini un kuu chaa vaꞌa ―ni kachi da. Yukan na ti ni kachi Jesús jiin da: ―Kuaꞌan nusa, ti siuku nava ni saꞌa chaa un, ti kundaꞌu ini nuu taka yɨvɨ naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ti ni siin Jesús ichi kuaꞌan ya, ti ni jaa ya ɨɨn ñuu lulu. Ti ɨɨn ñaꞌan nani Marta yukan, ni kana ña ya kuaꞌan ya veꞌe ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ti iyo ɨɨn kuꞌu Marta ja nani ña María, ti María ni nukoo ña nuu jaꞌa Jesús, ti ni ñusoꞌo ña taka jnuꞌun kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko Marta kujneñu xaan ña jiin jniñu iyo ini veꞌe ña. Ti ni tuꞌva ña nuu Jesús, ti ni kachi ña: ―Jitoꞌyo, tu ndɨꞌɨ kuɨtɨ ini ni ja kuꞌu na María, ni xndoo maa ɨɨn ña saña jiin taka jniñu jaꞌa. Kachi ni jiin ña na chindee ña saña ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ko Jesús ni kachi ya: ―¡Marta! ¡Marta! Kujneñu xaan ra ti ndɨꞌɨ xaan ini ra jiin taka jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko vijna iyo ɨɨn ja kanuu ga ja kuu jniñu ra un. Ti María ni nakaji ña ja kanuu ga un. Ti jankɨvɨ ga naa ini ña taka jnuꞌun ni ñusoꞌo ña vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ni kuu ja ɨɨn kɨvɨ kande Jesús jikantaꞌu ya nuu Yandios, ti nu ni ndɨꞌɨ ni jikantaꞌu ya, ti ɨɨn chaa kuu ndajaꞌa ya un, ni kachi da: ―Jitoꞌyo, xnaꞌan ni saña naa na nasa kakantaꞌu na, nanu ni xnaꞌan Juan nuu ndajaꞌa da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ti ni kachi Jesús: ―Suꞌva kaꞌan ra naa ra nuu ka jikantaꞌu ra: Tata yo Yandios, ja kancha ni andɨvɨ. Kava yɨñuꞌun yo nuu maa ni, chi maa ni kuu ja kuñaꞌnu ga. Jika na nuu ni ja yachi na kiji kɨvɨ taꞌu ni jniñu ñaꞌnu nuu nɨɨ tuꞌu ñuyɨvɨ. Ka kuni na ja yɨvɨ ñuyɨvɨ jaꞌa na kuandatu i jnuꞌun ni, nanu jandatu ángel kanchuku andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ti kuaꞌa ni staa na kaji na vijna ja kuu ja ndendajnu na ɨɨn kɨvɨ ɨɨn kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kuan kaꞌnu ini ni nuu kuachi ka saꞌa na, chi suni saña ka jankaꞌnu ini na nuu taka ja ka saꞌa yɨvɨ jiin na. Ti koto ma kuaꞌa ni jnuꞌun ja kotojnuni jaꞌuꞌu un saña, ti suꞌva nama ni saña nuu nundoꞌo un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ti suni ni kachi ya: ―Saꞌa yo nanu ja nau roꞌo iyo ɨɨn yɨvɨ mani ra jiin, ti ñuu kuɨtɨ jaa ra veꞌe da, ti kana ra xini da, ti kachi ra: “Amigo, kuaꞌanuu ti uni staa nuu ri, ");
INSERT INTO mpmNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chi ɨɨn amigo ri kuaꞌan da viaje, sa ni nchaa da veꞌe ri, ti tu nau ja iyo ja kuaꞌa ri ja kaji da”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ti kaꞌan chaa xiin veꞌe un undi ini veꞌe da: “Tu xnañaꞌan ra ruꞌu, chi tu kuu ndoko ri kuaꞌa ri ja kuni ra, chi ka kixi seꞌe kuachi ri jiin ri, ti vijna ndiꞌyu yuxeꞌe ri”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ti kachi ri ja vasu tu kuni da ndoko da, vasu mani ra jiin da, ko vanuxia siin ra xnañaꞌan ra nuu da. Ti ndoko da kuaꞌa da ja kuni ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ja yukan kuu ja na kachi ri: Kakantaꞌu nuu Yandios, ti na kuaꞌa ya ja kuni ra. Nduku taka ja vaꞌa ja iyo nuu ya, ti niꞌin ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ti siin kakantaꞌu nuu ya undi niꞌin ra, nanu saꞌa ɨɨn yɨvɨ ja siin i skajan i yuxeꞌe undi na nuña, ti sa kɨvɨ i. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Xi iyo ɨɨn roꞌo ja kuu tata suchi kuachi, xi kuaꞌa ra ɨɨn yuū nuu seꞌe ra nu ka jikan i staa nu? ¿Xi kuaꞌa ra ɨɨn koo nuu i nu ka jikan i chāká nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Xi kuaꞌa ra ɨɨn ndɨsuꞌma nuu i nu ka jikan i ndɨvɨ nuu ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Roꞌo naa ra, vasu ka saꞌa ra kuachi, ko suni iyo jniñu vaꞌa ka saꞌa ra ja ka nduku ra ja vaꞌa ja kuu seꞌe ra. Ti suni siaꞌan Tata ra Yandios, ja kancha ya andɨvɨ, kuaꞌa ya Espíritu Santo nu siaꞌan na kakantaꞌu ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti ɨɨn kɨvɨ ni keniꞌin Jesús tachi xaan un ja ni saꞌa ñɨꞌɨn ɨɨn chaa un. Ko ni kee tachi xaan un kuaꞌan, ti ni ndokaꞌan chaa ñɨꞌɨn un, so ni ka naa ini yɨvɨ jiin jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko sava i ni ka kaꞌan: ―Keniꞌin chaa jaꞌa tachi xaan un, ko jiin sɨvɨ maa jaꞌuꞌu kuñaꞌnu un (ja suni nani Beelzebú), ja yɨndaꞌa taka tachi xaan un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ko sava ga yɨvɨ un, ka kuni kotojnuni da ya, ti ka jikan da ɨɨn jniñu ñaꞌnu ja na koo nuu andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko maa ya ja jini vaꞌa ya ndoo ka ndoꞌo ini i, ti ni kachi ya: ―Nu ndajaꞌa ɨɨn gobierno kusɨɨn ini da naa da ti kejaꞌa kanaa da naa da, ti gobierno un tu kuñɨɨ, chi naa. Ti nu tendɨꞌɨ ɨɨn familia kejaꞌa kanaa naa, ti familia un tu kuu kunchuku mani. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Suni siaꞌan kuu nu maa jaꞌuꞌu un na sasɨɨn jnaꞌan jiin tachi xaan un, ¿ti ka jani ini ra ja nasa kuñɨɨ jiin jniñu un nusa? Na kachi ri jaꞌa nuu ra chi ka kaꞌan ra ja jiin sɨvɨ jaꞌuꞌu un kuu ja keniꞌin ri tachi xaan un kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ti nu siaꞌan kuu, ti va suni yɨvɨ ka skuaꞌa jiin ra naa ra, suni kuu ja kuu keniꞌin i tachi xaan jiin sɨvɨ jaꞌuꞌu un. Ja siaꞌan ti ka stuu i ja maa ni ra ka yuji jiin jnuꞌun ka kaꞌan ra un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko ruꞌu, jiin sɨvɨ maa Yandios keniꞌin ri tachi xaan un kuaꞌan. Yukan kuu ja, ja ni chaa jniñu ñaꞌnu Yandios ja kuu nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ti ja sɨkɨ jaꞌuꞌu un, saꞌa yo nanu ja ɨɨn ni kuu nu ɨɨn chaa kaña niꞌin xaan da ja ndito vaꞌa da veꞌe da, ti kaꞌiin vaꞌa ja ñavaꞌa da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko nu na chaa ɨnga chaa niꞌin ga ja kuu maa da, ti kundee chaa un jiin da, kuisonchaa da taka machete jiin espada ja ndito da veꞌe da jiin un, ti kɨvɨ da keniꞌin da taka ja ñavaꞌa chaa un. Ɨɨn ni kuu ja ni kundee ri jiin chaa uꞌu un, chi ni keniꞌin ri ndajaꞌa da un kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ti suni na kachi ri nuu ra naa ra sɨkɨ yɨvɨ ja tu kaꞌan vaꞌa sɨkɨ ri, ti yɨvɨ un jito uꞌu i ruꞌu. Yɨvɨ tu kejnaꞌan jiin ri, jachanuu i yɨvɨ ka kuni kejnaꞌan jiin ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Siin Jesús xndaku ya, ti ni kachi ya: ―Nu ɨɨn tachi xaan na xndoo ɨɨn chaa ti kiꞌin, kuaꞌan ti jikonuu nuu ñuꞌun ichi, nduku nuu ndetatu. Nu tu niꞌin, ti ndoꞌo ini: “Na nandeokuñɨ tuku ri veꞌe nuu ni kunde ri un.” ");
INSERT INTO mpmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko nu ni najaa, ti jini ja iyo nuña ini chaa un nanu ɨɨn veꞌe iyo nuña, ja iyo ndoo, ja iyo nakoo. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yukan na ti kiꞌin tachi un, ti kin kuaka uxia ga tachi xaan un ja jaku ga kanda ga ja kuu maa. Yukan na ti nchaa, ti ñdɨvɨkoyo kunchuku jiin chaa un. Yukan na ti chaa un viꞌi ga nduu da ansu nava ni kaa da undi nuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nɨ kaꞌan ga Jesús jnuꞌun un, ti ni kana koꞌo ɨɨn ñaꞌan kandichi maꞌñu yɨvɨ kuaꞌa un xini Jesús, ti ni kachi ña: ―¡Xaan ga ndatu ñaꞌan ni skaku niꞌin, ti ni skaxin ña niꞌin! ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ti ni kachi Jesús: ―Ko suꞌva ndatu ga yɨvɨ ka jinisoꞌo jnuꞌun Yandios, ti ka jandatu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti ni ka nakuikonduu ni ga yɨvɨ kuaꞌa un nuu Jesús, ti ni kejaꞌa kaꞌan Jesús jnuꞌun jaꞌa: ―Taka yɨvɨ ka chaku vijna, tu kuni kuandatu i nuu Yandios, ka kuni i ja na saꞌa ri ɨɨn jniñu ñaꞌnu nuu i. Ko jankɨvɨ saꞌa ri jniñu ñaꞌnu un, chi nɨnɨ jiin vanuxii nundoꞌo ni jnaꞌan Jonás, chaa ni kuu profeta na janaꞌan, yukan ni kuu ja xnaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Chi yɨvɨ ñuu Nínive ni ka nakuni i ja ni kaꞌan profeta Jonás maa jnuꞌun Yandios nuu i. Ti suni siaꞌan ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kaꞌan ri jnuꞌun Yandios nuu roꞌo naa ra vijna. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Suni ɨɨn ñaꞌan ni kuu reina ja ni taꞌu jniñu ɨɨn ñuu ichi sur, nandoto ña kɨvɨ na chaa juicio, kɨvɨ na kii xndichi ya yɨvɨ kɨvɨ vijna. Ti naa ini ña ndeꞌe ña nuu yɨvɨ kɨvɨ vijna ja niꞌin ini i, chi maa ña undi jika xaan ni kii ña ja na kunsoꞌo ña jnuꞌun ndichi ni kaꞌan rey Salomón, na janaꞌan. Ti vijna kuñaꞌnu ga jniñu saꞌa ri ja kuu Salomón, ti roꞌo naa ra tu ka chunsoꞌo ra jnuꞌun xndaku ri nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ti ja kuu sɨkɨ ñuu Nínive, nuu ni jaꞌan profeta Jonás, ti yɨvɨ ni kunchuku ñuu un, nandoto i kɨvɨ na chaa juicio ja xndichi ya yɨvɨ kɨvɨ vijna, ti naa ini i ndeꞌe i nuu yɨvɨ kɨvɨ vijna, chi tendɨꞌɨ yɨvɨ ñuu Nínive ni ka nakani ini i na ni kaꞌan profeta Jonás jnuꞌun Yandios nuu i. Ko ruꞌu, chi kuñaꞌnu ga jniñu saꞌa ri ja kuu Jonás, ti roꞌo naa ra, tu ka chunsoꞌo ra tu nakani ini ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Siin Jesús xndaku ya, ti ni kachi ya: ―Tu ni ɨɨn yɨvɨ ja skuikun ɨɨn yɨtɨ, ti chisaꞌyɨ chii ɨɨn janu. Chi suꞌva kani i yɨtɨ un nuu sukun nava na kundijin nuu yɨvɨ ja kɨvɨ ini veꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ti nduchi yo kuu nanu ɨɨn yɨtɨ ja kuu yɨkɨ kuñu yo, ti nuu nduchi ra iyo ndijin, ti suni siaꞌan iyo vaꞌa nɨ yɨkɨ kuñu ra. Ko nu nduchi ra tu kundijin, ti nasa kundijin na ichi kiꞌin ra nusa. Ti ñuñaa kuaꞌan ra nu siaꞌan, ti sana ini ra ti nduva ra. ¿Ti nasa ndoko ra ja ñaa xaan ichi kuaꞌan un nusa? ");
INSERT INTO mpmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Koto yukun inijnuni ra jiin jnuꞌun kaꞌan ri nava tu naa ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko nu kujnuni vaꞌa ini ra jnuꞌun kaꞌan ri, ti tu naa ini ra, chi ñukuu ini ra. Chi ja ni nakuni ndijin ra ja ichi Yandios kuu nu kiꞌin ra nanu ja nu ndinchaa nduva yɨtɨ ja kundijin ichi kiꞌin ra ñuñaa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ti ɨɨn chaa fariseo ni kana da Jesús ja na kaji ya staa jiin da veꞌe da. Ni jaa ya veꞌe da, ti ni nukoo ya mesa ja kee ya staa jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ko ni naa ini chaa fariseo un nu ni jini da, ja tu ni nandaꞌa ya nava iyo jnuꞌun ja xnaka ka nandaꞌa da tɨjnɨ jinu, sa ka yee da staa. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko maa Jitoꞌyo ni kachi ya: ―Roꞌo chaa fariseo naa ra, ndundoo koꞌo ndundoo yajin ra, chi ndoꞌo ini ra ja ka iyo ndoo ra nuu Yandios, vasu jaku ga kanda ra. Ka kuu ra nanu yɨvɨ ka nakacha nɨnɨ ichi jata koꞌo i jiin yajin i, ko tu ka nakacha i ichi ini, vasu jñaꞌan ga ichi ini un. Siaꞌan ka kuu ra, chi ka ndoꞌo ini ra ja ka kuu ra yɨvɨ vaꞌa, vasu mani jnuꞌun kuiꞌna jiin taka ga jnuꞌun kueꞌe ka ñuꞌun ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Yɨvɨ niꞌin ini ka kuu ra! ¡Xi tu jini ra ja Yandios ni saꞌa ya nɨ tuꞌu yɨkɨ kuñu ra jiin añu ra, ti ni jaꞌa ya inijnuni ra! ");
INSERT INTO mpmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja yukan kuu ja nakani ini naa ra, ti nakuaꞌa taka ja ni ka jisonchaa ra nuu yɨvɨ ndaꞌu un. Siaꞌan na ti ka stuu ra ja, ja ni ka nundoo undi ini añu ra ja kuu nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Xaan ga ndaꞌu roꞌo naa ra chaa fariseo! Chi ka siuku ra taka jniñu kuachi, ti tu ka siuku ra jniñu kanuu ja kuu nuu Yandios. Chi jakuu ni ka jaꞌa ra nuu taka ja ka ñavaꞌa ra, ka jaꞌa ra ja kuu nuu chaa junukuachi nuu Yandios. Ka jaꞌa ra jakuu nuu taka ja yɨꞌɨ xiko asun nanu ita tamino, jiin ruda, jiin savaꞌni ga ɨnga nuu yuku tajna, jiin yuku yɨꞌɨ xiko asun. Taka un ka saꞌa ra, ko ni ka naa ini ra jnuꞌun kanuu ga ja kaka ndaa ra nuu ichi Yandios, ti kuu ini ra nuu ya. Taka jaꞌa kanuu ga ja saꞌa ra, ti koto naa ini ra ja kuaꞌa ra taka nuu ja kaa ñavaꞌa ra un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Xaan ga ndaꞌu roꞌo chaa fariseo naa ra! Chi ka jajnaꞌan ini ra jnuꞌun yɨñuꞌun ga nuu nukoo ra ini veñuꞌun Israel un. Ti kuni ra ja na kaꞌan yɨñuꞌun yɨvɨ jiin ra nuu yaꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Xaan ga ndaꞌu roꞌo ja ka xnaꞌan jiin chaa fariseo naa ra! Ka kuu ra nanu ñaña ndɨyɨ ja ni ndaꞌva chi ka yaꞌa yɨvɨ sɨkɨ, ko tu ka jini i ja kande ndɨyɨ chii un. Ti siaꞌan ka kuu roꞌo naa ra, chi yɨvɨ ka kandixia jnuꞌun ra, va tu chaku ini i ja jnuꞌun ra kuu nanu ndɨyɨ ja kuan teꞌyu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yukan ti ni nachiso ɨɨn chaa xnaꞌan ley un: ―Maestro, jiin jnuꞌun ni kaꞌan ni un suni ni kaꞌan ndevaꞌa ni sɨkɨ na naa na ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ti ni kachi Jesús: ―¡Suni xaan ga ndaꞌu tu roꞌo ja ka xnaꞌan ley! Kuaꞌa jnuꞌun ka xnaꞌan ra, ti taꞌu ra jniñu ja na siuku yɨvɨ jnuꞌun un naa i, vasu maa ra naa ra, tu ka siuku kuɨtɨ ra jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Na ndaꞌu ra naa ra! Chi ka saꞌa ra nama nuu ñaña chaa ni ka kuu profeta na janaꞌan ja ni ka jaꞌni ndɨyɨ velu ra naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jiin jniñu ka saꞌa ra vijna, jini yo ja ka kejnaꞌan ini ra jiin jniñu ni ka saꞌa ndɨyɨ velu ra, chi maa da ni ka saꞌa ja ni ka jiꞌi profeta un. Ti vijna roꞌo naa ra, ka nasaꞌa ra nama nuu ñaña ndɨyɨ ni ka kuu profeta un. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja sɨkɨ yukan kuu ja undi janaꞌan ni kachi Yandios ɨɨn jnuꞌun ndichi: “Taji ri profeta ja na kaꞌan da jnuꞌun ri jiin chaa kuu apóstol nuu yɨvɨ naa i, ti sava da kaꞌni yɨvɨ da, ti sava ga da koto uꞌu yɨvɨ da naa da.” ");
INSERT INTO mpmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ko roꞌo naa ra jiin taka ga yɨvɨ ka iyo kɨvɨ vijna, chi kandiso ra nɨñɨ chaa ni ka kuu profeta ja ni ka jiꞌi da undi na ni nukoo ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kandiso ra undi nɨñɨ Abel jiin nɨñɨ Zacarías, ja ni ka jaꞌni jnaꞌan ra janaꞌan sava maꞌñu altar jiin veꞌe ii ini veñuꞌun Israel un. Ti na kachi ndaa ri nuu ra naa ra ja taka nundoꞌo un nanduku jnuꞌun Yandios, ti kii kuachi un sɨkɨ taka yɨvɨ kanchuku kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Xaan ga ndaꞌu roꞌo chaa ka xnaꞌan ley! Chi jiin jnuꞌun ra ka jasɨ ra ja na chunsoꞌo yɨvɨ jnuꞌun Yandios. Ti ni maa ra tu ka kuni chunsoꞌo ra jnuꞌun ya, ni tu ka jaꞌa ra jnuꞌun ja kunsoꞌo yɨvɨ ka kuni skuaꞌa jnuꞌun ya ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ti nu ni kaꞌan Jesús taka jnuꞌun un, ti chaa ka xnaꞌan ley jiin chaa fariseo, ni ka kuɨtɨ xaan ini da nuu ya. Ti ni ka kejaꞌa ka xnañaꞌan da jiin tɨjnɨ jnuꞌun ka jikajnuꞌun da nuu ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ja ka nduku da na ndee nuu tu yuji ya ɨɨn jnuꞌun kaꞌan ya, nava yukan ti kuu kankuachi da sɨkɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti nɨ kakuu da siaꞌan ti yachi xaan ni ka kututu tɨjnɨ mil yɨvɨ naa i, ti ni ka taka yɨvɨ ja undi ka jaxin jnaꞌan i naa i. Ti ni jakunchaa Jesús xndaku ya nɨnɨ nuu maa ni ndajaꞌa ya, ti ni kachi ya: ―Koto maa ra naa ra jiin jnuꞌun ka kaꞌan chaa fariseo, chi yachi xaan kuan kuichanuu nanu keniꞌno levadura chii yujña staa stila. Ka kenda da nanu chaa vaꞌa ga, ko vanuxia mani jnuꞌun xndoñaꞌan kuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chi tu iyo nɨ ɨɨn ja kendo saꞌyɨ ja kuu nuu Yandios, chi taka ni kenda nuu ndijin. Ni tu iyo ni ɨɨn ja yɨsaꞌyɨ ja tu kuni ndaa yo, chi taka ni kuni ndaa yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ti taka jnuꞌun ni ka ndajnuꞌun xeꞌe ra jiin yɨvɨ, ti kenda ndijin vasu tu nau ɨnga yɨvɨ ni jinisoꞌo. Vasu ni ka jasɨ ra yuxeꞌe, ti ni ka ndajnuꞌun ra un, ko kuichanuu kiꞌin, ti ya yukan kani yɨvɨ jnuꞌun un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Roꞌo naa ra, amigo ri, na kachi ri ja tu koyuꞌu ra koto ra yɨvɨ jaꞌni yɨkɨ kuñu, chi nu na kaꞌni i roꞌo ko nɨnɨ yɨkɨ kuñu ra kaꞌni i. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ko na kachi ri nuu ra nau ɨɨn ja koyuꞌu ra ndeꞌe ra. Koyuꞌu ra Yandios, chi maa ya ndiso jniñu ñaꞌnu ja xnaa ndɨꞌɨ ya roꞌo, ti kuu chunde ya roꞌo nuu infiernu. Ti yukan ndixia kuu ja koyuꞌu ra ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Maa Yandios kuu ja kachi nasa koo jiin ra naa ra. Jini yo ja jandaa kuu yukan, chi undi uꞌun saa kuachi un, ka kuyaꞌu tɨ ja uu pesu, ko jito vaꞌa Yandios tɨ, chi ni ɨɨn tɨ tu naa ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ti ja kuu roꞌo naa ra, chi undi ixi xini ra ni kaꞌu ya ndɨ ɨɨn ndɨ ɨɨn. Yukan kuu ja koto xndiꞌi ra ini ra chi yaꞌu ga nchaa ra naa ra nuu Yandios ja kuu ɨɨn jnɨɨ saa kuachi un ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Siin Jesús xndaku, ti ni kachi ya: ―Ti na kachi ri ja taka yɨvɨ nu na kaꞌan ndaa i, ti stuu i ruꞌu nuu ɨnga yɨvɨ, suni ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, suni kaꞌan ndaa ri ja stuu ri yɨvɨ un nuu ángel ka junukuachi nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ko nu na chisaꞌyɨ i ruꞌu nuu yɨvɨ, suni siaꞌan skexiko ri yɨvɨ un nuu ángel ka junukuachi nuu Yandios, chi kachi ri ja tu ka yɨꞌɨ i jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Suni na kachi ri ja savaꞌa ni ga yɨvɨ na kaꞌan ndevaꞌa sɨkɨ ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, va iyo jnuꞌun kaꞌnu ini nuu i. Ko nu ɨɨn yɨvɨ na kaꞌan ndevaꞌa sɨkɨ Espíritu Santo, jankɨvɨ iyo jnuꞌun kaꞌnu ini nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nu na jnɨɨ chaa ka kuñaꞌnu ini veñuꞌun Israel roꞌo naa ra, xi stisia, xi juez jnɨɨ da roꞌo naa ra, ti koto ma xndiꞌi ra ini ra naa ra ja nasa koo jnuꞌun kaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Chi nu na jaa hora kaꞌan ra, ti maa Espíritu Santo kachi nasa koo jnuꞌun kaꞌan ra hora un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ti ɨɨn yɨvɨ kandichi maꞌñu yɨvɨ kuaꞌa un ni kachi jiin Jesús: ―Maestro, kachi ni jiin ñani na, na kuaꞌa da tɨꞌlɨ ñuꞌun kuu taꞌu na ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ko ni kachi Jesús: ―¿Ndoo kaꞌan ra siaꞌan? Ti tu kuu ri juez ja tejnaꞌan ri taꞌu ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti suni ni kachi ya nuu yɨvɨ un: ―Ndeꞌe, koto vaꞌa maa ra naa ra, ti koto kundio ini ra ja kuñavaꞌa kuaꞌa ra ndajniñu ja kuu riku ra. ¿Ti va nu ja kuaꞌa xaan ja ñavaꞌa ra, ti nama un roꞌo ja kuchaku naꞌan ra nu? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yukan na ti ni kaꞌan ya jnuꞌun jaꞌa nuu yɨvɨ un: ―Ni iyo ɨɨn chaa riko xaan ja ni ñavaꞌa kuaꞌa da ñuꞌun, ti vaꞌa xaan ni kuu itu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ti ni kejaꞌa ndoꞌo ini chaa riko un: “¿Nasa saꞌa ri vijna? Ti tukaa ga nuña yaka nuu kuꞌun nɨñɨ ri.” ");
INSERT INTO mpmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yukan ti ni ndoꞌo ini da: “Suꞌva na saꞌa ri. Na kanu ndɨꞌɨ ri taka yaka ri, ti na saꞌa ri ɨɨn ja kaꞌnu ga, ti yukan kujaa savaꞌa ndɨꞌɨ ri nɨñɨ ri jiin taka ja ñavaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yukan ti kachi ri: Vijna ti kuaꞌa xaan ja ñavaꞌa ri ti kujaa ja kuu tɨjnɨ kuiya. Vijna ti na ndetatu ri, ti kaji koꞌo ri ja jnuꞌun sɨɨ ini”, kachi da, ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ko ni kachi Yandios jiin da: “¡Chaa ñaa kuu ra! Ja tu jini ra ja jakuaa vijna kuū ra. ¿Ti ndoo kendo jiin taka ja ñavaꞌa ra un nusa”? ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Siaꞌan ka jnaꞌan yɨvɨ kandio ini ja kuu riku i naa i, ti tu ka nakututu ini i ja kuu taꞌu i nuu Yandios, naa i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yukan sa ni kachi Jesús jiin ndajaꞌa ya: ―Na kachi ri nuu ra naa ra, ja koto maa xndiꞌi ra ini ra ja kuu ja kaji ra, ja na kuchaku ra, xi ja kuu saꞌma kuꞌun ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Chi nu ni jaꞌa Yandios ja kuchaku ra, va suni kuaꞌa ya ja kaji ra jiin saꞌma kuꞌun ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndeꞌe naa ra nasa chaku tɨkaka un. Tu naa jniñu ka saꞌa tɨ ja nastutu tɨ ini yaka tɨ, ko maa Yandios jito ya tɨ ja ka yee tɨ. ¿Ti ansu kanuu ga roꞌo naa ra ja kuu kuɨtɨ un nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Ko ndoo niꞌin ra naa ra vasu na xndiꞌi xaan ini ra jiin ja kuchaku ra, xi ja kundii kusuku ra yukan? Tu nijniñu ja siaꞌan ka xndiꞌi xaan ini ra, chi ni tu niꞌin ra ja vaꞌa ga ja kuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu tu kuu saꞌa ra vasu ɨɨn jniñu lulu siaꞌan, ¿ti ndoo xaan ka ndɨꞌɨ ini ra ja kuu taka ga ja kuchaku ra nusa? ");
INSERT INTO mpmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ko ndeꞌe naa ra, nasa jaꞌnu ita yuku un, ti tu jini yo nasa jaꞌnu, ko vii xaan kanda. Ko na kachi ri ja ni rey ni nani Salomón na janaꞌan, tu ni suku da nanu ita yuku un, vasu vii xaan ni kaa saꞌma da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ti maa Yandios skuaꞌnu ya ita yuku un, ti vii xaan na skutu ya i. Ko vasu vii xaan kanda vijna, ti ijña ja ni ichi, ti kaꞌma ya nuu ñuꞌun ini horno. Ja yukan kuu ja nu siaꞌan saꞌa Yandios, ja jito ya ita yuku un, ¿ti ansu kanuu ga roꞌo naa ra ja jito vaꞌa ya roꞌo naa ra nu? Ko ka ndɨꞌɨ xaan ini ra, chi tu kandixia ndaa ra ja maa Tata ra Yandios jito vaꞌa ya roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ja yukan kuu ja tu nakukutu ini ra kuyaku ra ja nduku ra nasa kaji ra, nasa koꞌo ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Chi taka un ka nduku yɨvɨ naa i ja tu ka nakuni i nau kuu Yandios, ko roꞌo naa ra, iyo ɨɨn Tata ra ja kuu Yandios kancha andɨvɨ, ti ja jini ya ja taka un ka nandɨꞌɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ti roꞌo naa ra kukutu ini ja na kɨvɨ ra ndaꞌa Yandios ja na taꞌu ya jniñu nuu ra naa ra. Ti nu na kundio ini ra un, ti kuaꞌa ya taka ja ka nandɨꞌɨ ra ja kuchaku ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Koto yuꞌu ra naa ra chi ka kuu ra nanu ɨɨn ataju lulu rɨɨ, ja ndito vaꞌa jitoꞌo tɨ maa tɨ, ti ruꞌu ndito vaꞌa ri roꞌo naa ra. Ti maa Tata ri ja ni jaꞌa ya jnuꞌun ja na ndɨvɨ ra ñuu nuu taꞌu ya jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ti koto xndiꞌi ini ra ja niꞌin ra kuaꞌa ndajniñu nuu ñuyɨvɨ jaꞌa. Vaꞌa ga kuaꞌan ti xiko ra taka ja ka ñavaꞌa ra, ti kuaꞌa xuꞌun un nuu yɨvɨ ndaꞌu naa i. Siaꞌan ti sa nakaya taꞌu ra nuu Yandios ja kancha ya andɨvɨ, ti yukan tu kututu nanu nu savaꞌa yo xuꞌun ini ɨɨn jajnu. Ti andɨvɨ yukan tu kɨvɨ ñakuiꞌna, ni tikixin tu kɨvɨ tɨ ja stɨvɨ tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ti savaꞌni ga nanu ndoꞌo ini ra ja nakaya ra yaji ra, ti yukan kundio ini ra ja na niꞌin ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Vaꞌa nusa, ti suni koto maa ra naa ra, kotuꞌva ra ja kuu kɨvɨ nchaa jitoꞌo ra, ");
INSERT INTO mpmNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nanu ɨɨn muzu ja kayu kayu ni candil da, ja ndatu da jitoꞌo da vendi da nu ni jaꞌan da ɨɨn viko nandaꞌa. Ti muzu un kuiña da yuxeꞌe savaꞌni ga hora na nchaa amu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ko ndatu muzu un, nu na nchaa jitoꞌo da ti kuni da ja ndito muzu da. Ti na kachi ri ja maa jitoꞌo da un, suꞌva kuanukuachi da, chi savaꞌa da mesa da, ti kana da muzu da un ja na nukoo da ti kee da staa. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ti kee vaꞌa muzu un nu ndito da savaꞌni ga hora na nchaa jitoꞌo da, vaꞌa ni ñuu, xi kuan ndii ni ga. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndeꞌe naa ra, sa ti ɨɨn chaa xiin veꞌe ja jini da na hora jaa ñakuiꞌna veꞌe da ɨɨn jakuaa, va kondito da, ti tu kuaꞌa da jnuꞌun ja sakuiꞌna veꞌe da, ti tava ndajniñu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ja yukan kuu ja suni kotuꞌva ra naa ra, chi jaa ɨɨn kɨvɨ, ti sana ini ra, ti nchaa ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yukan ti ni jikan jnuꞌun Pedro ya: ―Jitoꞌyo, ¿nuu taka maa ni na ni kaꞌan ni jnuꞌun jaꞌa, xi ni kaꞌan ni ja kuu tendɨꞌɨ yɨvɨ nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti ni kachi maa Jitoꞌyo: ―Chaa kuu muzu vaꞌa ja junukuachi ndaa un, ti kanu ini chaa xiin veꞌe un ja na kɨndaꞌa da uu ga muzu un, ti suni jiin hora na kuaꞌa da ja kaji uu ga muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ndatu chaa kuu muzu un nu na najaa chaa xiin veꞌe un, ti kuni da chaa siuku da nava ni taꞌu jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ti na kachi ndaa ri ja kusɨɨ ini maa jitoꞌo da un, ti xndoo da chaa ja na kɨndaꞌa da taka ja ñavaꞌa da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ko nu chaa junukuachi un na saꞌa ndevaꞌa da, chi ndoꞌo ini da ja kukuee ga jitoꞌo da un, ti kejaꞌa nduxaan da nuu uu ga muzu un, jiin ñaꞌan ka junukuachi, ti kejaꞌa kaji koꞌo da ti kejaꞌa najini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yukan ti iyo naa ini da ti nchaa jitoꞌo da. Ti kuaꞌa da tau chaa un jiin ɨɨn nundoꞌo ja jnaꞌnu ndatu da. Siaꞌan ka jnaꞌan yɨvɨ tu ka ñukuu kuɨtɨ ini i Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ko muzu ja tu chunsoꞌo taka jniñu kuni jitoꞌo da ja saꞌa da, vasu jini da jniñu taꞌu jitoꞌo da, ti tu jandatu da ja siuku da taka nava kuni jitoꞌo da, ni tu iyo tuꞌva da ja kuu kɨvɨ nchaa jitoꞌo da. Ti muzu un, ndoꞌo xaan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ko muzu ja tu jini na jniñu kuni jitoꞌo da ja saꞌa da, ti saꞌa da ɨɨn jniñu ja tu jajnaꞌan ini jitoꞌo da, ti muzu un jaku ni ndoꞌo da. Chi vanuxia tu ni kujnuni ini da naa jniñu kuni jitoꞌo da. Suni siaꞌan kuu jiin ɨɨn yɨvɨ ni kutuꞌva vaꞌa chi kuaꞌa ja nakuaꞌa i jnuꞌun, chi jitoꞌo i kuni ja na kuanukuachi vaꞌa i nuu da, ti na siuku ndaa i jiin taka jniñu ni taꞌu da nuu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Ruꞌu ni chaa ri, ko so ja na skuikun ri ñuꞌun, nanu ka nakaꞌma yo icha ja na ndundoo yuku. Chi ka iyo sava yɨvɨ ja nasaꞌa ndoo ri undi ini añu i, ko ka iyo sava yɨvɨ niꞌin ini, ti ja kuu yɨvɨ un, kuu ri nanu ɨɨn ñuꞌun nuu ka nakaꞌma yɨvɨ yuku, chi xnaa ri yɨvɨ un. Chi yukan kuu ja ve saꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ko iyo ɨɨn nundoꞌo kii sɨkɨ ri, nanu nundoꞌo jnaꞌan ɨɨn yɨvɨ kekaꞌnu chii nducha. Ti kukuiꞌya xaan ini ri jiin nundoꞌo jaꞌa undi na siuku ndɨꞌɨ ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Xi ka jani ini ra ja ni chaa ri, ti saꞌa ri ja na kunchuku mani yɨvɨ naa i nuu ñuyɨvɨ jaꞌa nu? Ko na kachi ri ja tuu. Chi suꞌva kusɨɨn ini yɨvɨ naa i ja sɨkɨ ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ti undi vijna kejaꞌa kusɨɨn ini yɨvɨ ja sɨkɨ ruꞌu. Chi nu ka iyo uꞌun yɨvɨ ini ɨɨn veꞌe, uni yɨvɨ un kuantaꞌu i ruꞌu, ti uu ga yɨvɨ un, tu kuantaꞌu i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ti chunsama ini tata jiin seꞌe ja tu kunchuku mani ti koto uꞌu jnaꞌan i. Ti koto uꞌu nana jiin seꞌe sɨꞌɨ, ti seꞌe sɨꞌɨ jiin nana. Koto uꞌu seꞌe janu un jiin nana chiso, ti nana chiso un jiin seꞌe janu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ni ndɨꞌɨ ni kaꞌan ya nuu ndajaꞌa ya, ti ni kaꞌan tuku ya nuu yɨvɨ kuaꞌa un. Ti ni kachi ya: ―Nu ni ka jini ra nuu kuꞌiin viko ichi nuu kee ndikandii, ti ka kaꞌan ra ja kuaꞌi sau, ti siaꞌan kuu ndixia. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ti nu ni kejaꞌa kee tachi ichi vee, ti ka kaꞌan ra ja nandii, ti jandaa ndixia kuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ko chaa ñaa xini ka kuu ra, vasu tuꞌva ra, ko ka xndoñaꞌan ra. Chi ka jini vaꞌa ra nasa nakani kɨvɨ nuu andɨvɨ jiin ja ndenda nuu ñuꞌun, ¿ti nasa kuu ja tu ka chaku ini ra nau ja kuu ruꞌu, ja saꞌa ri taka jniñu ñaꞌnu kɨvɨ vijna nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Siin xndaku Jesús nuu yɨvɨ un, ti ni kachi ya: ―Kani ini nuu jniñu ñaꞌnu saꞌa ri, nanu ja ka nakani ini ra nasa ndumani ra jiin yɨvɨ kankuachi jaꞌa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chi nu ɨɨn yɨvɨ na kankuachi jaꞌa ra, ti kiꞌin ra veꞌe sticia. Xnakan ndajnuꞌun mani naa ra ichi kuankoyo ra ti na kukuee, nava tukaa ga kiꞌin da jiin ra veꞌe sticia, chi nakuaꞌa juez un roꞌo nuu policia, ti chindiꞌyu da roꞌo vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ti na kachi ndaa ri nuu ra naa ra ja tu kaña ra yukan undi nu tu chunaa ndɨꞌɨ ra xuꞌun tau ra un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti kɨvɨ yukan ni ka chakoyo tɨjnɨ chaa, ti ni ka jani da jnuꞌun nuu Jesús nava ni saꞌa gobernador Pilato jiin tɨjnɨ chaa ñuu Galilea, ja nanu ka jaꞌni da kuɨtɨ ja soko da nuu Yandios ni jakoyo soldado Pilato ti ni ka jaꞌni da chaa Galilea un, ti undi ni ka nasakanuu nɨñɨ da jiin nɨñɨ kuɨtɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ti ni kachi Jesús: ―Va nu ja siaꞌan ni ka jnaꞌan chaa un, ti ka ndoꞌo ini ra ja iyo ga kuachi maa da ja kuu taka ga chaa ñuu Galilea un. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ko na kachi ri ja tuu. Chi roꞌo naa ra, nu tu nakani ini ra nuu kuachi ra, ti suni jnaꞌnu ndatu ra ti xnaa ra maa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Xi ka jani ini ra ja ndɨꞌɨ xiaꞌun uni yɨvɨ ja ni ka jiꞌi chii torre Siloé na ni nduva sɨkɨ da, xi ni iyo ga kuachi chaa un ja kuu taka ga yɨvɨ kanchuku ñuu Jerusalén nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ko na kachi ri ja tuu. Chi roꞌo naa ra, nu tu nakani ini ra nuu kuachi ra, ti suni jnaꞌnu ndatu ra ti xnaa ra maa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yukan ti ni kachi Jesús jnuꞌun jaꞌa, ja xnaꞌan ya nau kuu yɨvɨ ja tu siuku jnuꞌun xndaku Yandios: ―Kuu i nanu ɨɨn nutɨchɨ vixi ja kandichi nuu ñuꞌun ɨɨn yɨvɨ, ti chaa xiin un jan nduku da tɨchɨ vixi xini yujnu un, ko tundo niꞌin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yukan na ti ni kachi da jiin chaa ndito ñuꞌun da un: “Vijna ti ja ni kuu uni kuiya kin nduku ri tɨchɨ vixi xini yujnu jaꞌa, ko tu jaꞌa ni ɨɨn tɨchɨ. Kiꞌin ti kaꞌncha ra vaꞌa ga, chi so xnañaꞌan kandichi nuu ñuꞌun jaꞌa”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ko ni kachi chaa ndito ñuꞌun un: “Taa, sia ni na kundichi tɨꞌlɨ ga kuiya vijna, na staya na ñuꞌun jaꞌa, ti na chiꞌi na jaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na ndeꞌe yo nu tu kuun tɨchɨ xini ɨnga kuiya. Ti nu tuu, ti sa kaꞌncha ni”, ni kachi muzu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ni kuu ja ɨɨn kɨvɨ ndetatu, kande Jesús ini ɨɨn veñuꞌun Israel ja xnaꞌan ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ti yukan kande ɨɨn ñaꞌan ja, ja ni kuu xiaꞌun uni kuiya kuꞌu ña. Ja ni kuu tɨꞌɨ sɨkɨ ña ni saꞌa ɨɨn tachi xaan, ti tu kuu kuɨtɨ kaka ndaa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ti nu ni jini Jesús maa ña, ni kana ya ña, ti ni kachi ya: ―Roꞌo ñasɨꞌɨ, vijna ti nduvaꞌa ra jiin kueꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ti ni chuxndee ya ndaꞌa ya xini ña, ti hora ni, ni ndokuɨñɨ ndaa ña. Ti ni kejaꞌa ña nakanajaa ña Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ko chaa ndiso jniñu ini veñuꞌun un, ni kuɨtɨ ini da, chi Jesús ni saꞌa ya tajna kɨvɨ ndetatu un. Ti ni kachi da nuu yɨvɨ un naa i: ―Iyo iñu kɨvɨ ja saꞌa yo jniñu, ti nuu ɨɨn kɨvɨ un kikoyo ra ja nduvaꞌa ra, ti ansu ja kikoyo ra kɨvɨ ndetatu jaꞌa ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ko ni kachi Jitoꞌyo jiin da: ―Chaa xndaꞌu ka kuu ra. ¿Va nu tu ka ndaji ra xndɨkɨ ra naa ra xi burru ra ja kin skoꞌo ra tɨ nducha ɨɨn kɨvɨ ndetatu nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ti ñaꞌan jaꞌa ja kuu ña ñanijnaꞌan tata yo Abraham na janaꞌan, chi na kaa ni ndikun ña xiaꞌun uni kuiya ni saꞌa jaꞌuꞌu un. ¿Xi tu kuu kenchaa yo kueꞌe jnaꞌan ña un vijna kɨvɨ ndetatu nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ti nu ni kaꞌan ya siaꞌan, ti ni kukanuu chaa jito uꞌu ya un, ko taka ga yɨvɨ kuaꞌa un ni ka kusɨɨ ini jiin jniñu ñaꞌnu ni saꞌa ya un. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yukan na ti ni kachi Jesús: ―Na kaꞌan ri ɨɨn jnuꞌun nuu ra nava kuni ra nasa kuu ja ka nakaya yɨvɨ taꞌu Yandios jniñu nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Siaꞌan kuu nanu ɨɨn ndɨkɨn lulu, ja nu ni xndee ɨɨn yɨvɨ nuu ñuꞌun i, ti yukan kejaꞌa jaꞌnu undi kuu ɨɨn yujnu kaꞌnu xaan, ti yukan ka jaꞌan saa un ka saꞌa tɨ taka tɨ nuu ndaꞌa yujnu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Suni ni kaꞌan tuku Jesús: ―Siaꞌan ka nakaya yɨvɨ taꞌu Yandios jniñu nuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kuu i nanu ɨɨn levadura ja kiꞌin ɨɨn ñasɨꞌɨ ti sakanuu ña jiin uni kilo yuchi triu, ti saꞌa levadura un ja na najinu nɨ tuꞌu chii yujña un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ichi kuaꞌan Jesús ñuu Jerusalén xnaꞌan ya nuu yɨvɨ ini veñuꞌun Israel taka ñuu nuu yaꞌa ya kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ti ni kenda ɨɨn chaa ni jikajnuꞌun ya, ti ni kachi da: ―Jitoꞌyo, ¿Jandaa kuu ja jaku ni yɨvɨ kuu ja ketaꞌu i nu? ―ni kachi da. Ti ni kachi Jesús: ");
INSERT INTO mpmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Nduku ndee naa ra ti kɨvɨkoyo ra ñuu nuu taꞌu Yandios jniñu. Nduku ndee ra nanu yɨvɨ kuni kɨvɨkoyo i ɨɨn veꞌe nuu iyo ɨɨn yuxeꞌe lulu. Chi na kachi ri nuu ra naa ra ja nde kuaꞌa yɨvɨ ka kuni kɨvɨkoyo i ñuu nuu taꞌu ya jniñu, ko tu ka naniꞌin i ichi, ");
INSERT INTO mpmNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","chi maa Yandios nakasɨ ya yuxeꞌe nava tukaa kɨvɨkoyo i. Kasɨ ya nanu ɨɨn chaa xiin veꞌe ja ndokuɨñɨ da ti kasɨ da yuxeꞌe da, ti tukaa kuaꞌa da jnuꞌun kɨvɨkoyo yɨvɨ veꞌe da. Vasu na kendo i ichi fuera ti kachi i: “Jitoꞌyo, kuni kɨvɨkoyo na nuu taꞌu ni jniñu.” Ko kachi ya: “Tu kuantaꞌu ri roꞌo naa ra, ni tu jini ri naa ichi vekoyo ra naa ra”, kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yukan ti kejaꞌa ra kachi ra naa ra: “Ko ka jini na maa ni, chi taka yo ni ka yee staa, ti maa ni, ni xnaꞌan ni jnuꞌun ni nuu ñuu na naa na”, kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ko maa ya chi kachi tuku ya: “Ja ni kachi ri ja tu jini ri naa yɨvɨ ka kuu ra. Kuanchaꞌa naa ra, roꞌo ja ka saꞌa jniñu ndevaꞌa naa ra”, kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yukan na ti kejaꞌa ra ndeꞌe ra naa ra ti kuꞌyu jnuꞌun ra sɨkɨ jnuꞌun kuiꞌya ini. Chi kuni ra nuu chaa janaꞌan, ja ni ka kuu tata yo, Abraham, Isaac, jiin Jacob jiin taka ga profeta janaꞌan ja kaꞌiin da nuu taꞌu Yandios jniñu, ti roꞌo sa suꞌva kekoyo ra kiꞌin ra fuera naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Chi chakoyo yɨvɨ kaꞌiin ndɨ kuun jikɨ ñuyɨvɨ, ichi ninu, ichi vee, ichi nuu kaña ndikandii, jiin ichi nuu kee ndikandii, ti nukoo i ti kaji i ini ñuu nuu taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ko kuaꞌa yɨvɨ ndaꞌu ja tu kuñaꞌnu vijna, ti yɨvɨ un kuu ja nduñaꞌnu ñuu nuu taꞌu Yandios jniñu. Ti kuaꞌa yɨvɨ ka kunuu vijna, ti yɨvɨ un ndundaꞌu i nuu taꞌu Yandios jniñu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti suni kɨvɨ un ni jakoyo sava chaa fariseo un, ti ni ka kachi da jiin Jesús: ―Vaꞌa ga ja na kee ra ñuu jaꞌa ti kiꞌin ra, chi rey Herodes kuni kaꞌni da roꞌo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ti ni kachi Jesús jiin da: ―Kuankoyo naa ra nuu Herodes, ja kuu da chaa kuaꞌan, chi kuni kaꞌni da ndɨyɨ, ti kachi ra jiin chaa un: “Ndeꞌe, vijna jiin ijña keniꞌin ri tachi xaan un kinkoyo, ti isa sa xndiꞌi ri jniñu un.” ");
INSERT INTO mpmNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ko siin ri ichi kuaꞌan ri vijna, ijña, jiin isa, ¿xi vatuni ja kuū ɨɨn profeta Yandios fuera ñuu Jerusalén xino? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yukan ti ni kachi ya sɨkɨ yɨvɨ ñuu Jerusalén: ―Roꞌo, yɨvɨ ñuu Jerusalén, ja ka jaꞌni ra profeta najanaꞌan, chaa ni kaꞌan jnuꞌun Yandios, ti ka jaꞌa ra yuu sɨkɨ chaa ka kaꞌan jnuꞌun Yandios ja ni taji ya. Nasa jinu ni kundaꞌu ini ri nuu ra naa ra, ja nama ri roꞌo nuu nundoꞌo un nanu saꞌa chuun ja kana tɨ seꞌe kuachi tɨ ja na ndututu chii ndijin tɨ, ko tu ni ka jantaꞌu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vijna na nusa, ti na xndoo ri roꞌo naa ra jiin ñuu ra. Chi na kachi ri jiin ra ja jankɨvɨ ga kuni ra ruꞌu naa ra undi na jaa kɨvɨ ja kachi ra naa ra: “Ñaꞌnu na koo maa rey yo, chi Tata yo Yandios ni taji ya maa chaa ja ndiso jniñu ñaꞌnu nuu ya”, kachi ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ɨɨn kɨvɨ ndetatu ni kuu, na ni kana ɨɨn chaa fariseo kuñaꞌnu un Jesús, ni jan kaji ya staa veꞌe da, ti sava ga chaa fariseo un ka jito yuꞌu da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ti nuu kande Jesús yukan kande ɨɨn chaa ndoꞌo kueꞌe kuɨñɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yukan ti ni jikajnuꞌun ya chaa ka xnaꞌan ley Israel un jiin chaa fariseo, ti ni kachi ya: ―¿Kuu saꞌa yo tajna ɨɨn yɨvɨ kuꞌu ja kuu kɨvɨ ndetatu, xi tuu nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ti ni ka jasɨ yuꞌu yɨvɨ un, tukaa ni ka kaꞌan. Ti maa ya ni jnɨɨ ya chaa kuꞌu un, ni saꞌa ya tajna da, ti ni kachi ya jiin da ja na kiꞌin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yukan ti ni kachi ya jiin chaa fariseo un: ―¿Nu ɨɨn ɨɨn ra na kanakava ɨɨn seꞌe ra xi ɨɨn xndɨkɨ ra ini soko, ti tu tava ra tɨ hora ni, vasu kuu ɨɨn kɨvɨ ndetatu nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yukan na ti tukaa ni kuu ndeokani chaa un ɨɨn jnuꞌun maa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nu ni jini Jesús ja ka nakaji yɨvɨ ni ka jakoyo viko un nuu vaꞌa ga ja kunchuku i nuu mesa un, ti ni xndaku ya ɨɨn jnuꞌun nuu i, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nu na kana yɨvɨ roꞌo ɨɨn viko nandaꞌa naa ra, koto nukoo ra nuu silla kanuu ga un, chi tu jini ra xi jaa ɨɨn chaa kuñaꞌnu ga ja kuu roꞌo, ");
INSERT INTO mpmNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ti chaa ni kana roꞌo un, kuu kachi da jiin ra: “Kuaꞌa silla ra na nukoo ɨnga chaa jaꞌa.” Yukan na ti koñaa ra nuu kanuu, chi kuaꞌa da ɨɨn silla kancha undi sandɨꞌɨ kuɨtɨ ni ga kuncha ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ti vaꞌa ga ja nu na kana yɨvɨ roꞌo, ti nukoo undi sandɨꞌɨ ni ga, ti nava nu na jaa chaa ni kana roꞌo un, ti kachi da: “Amigo, ñaꞌan ti kuncha ra undi nuu kanuu ga jaꞌa”, kachi da. Yukan na ti kuni yɨvɨ kanchuku mesa jiin ra un ja suni kuu ra ɨɨn chaa kuñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ti yɨvɨ kuni kuñaꞌnu, suꞌva niꞌin yɨ jnuꞌun kanuu, ko yɨvɨ kuiꞌya kaa un, suꞌva nduñaꞌnu i, chi maa Yandios kuu ja saꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yukan ti ni kachi Jesús nuu chaa ni kana ya un siaꞌan: ―Nu kuni ra kuaꞌa ra ɨɨn ndeyu ja kaji yɨvɨ, ti koto kana ra ɨɨn amigo ra, xi ñani ra, xi ɨɨn ɨɨn jnaꞌan ra, xi ɨɨn ɨɨn chaa riko kanchuku yajni jiin ra, chi suni na kana yɨvɨ un roꞌo, ti yukan naniꞌin ra ja ni jaꞌa ra un. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ti vaꞌa ga ja nu na saꞌa ra ɨɨn viko, ti kana taka yɨvɨ ndaꞌu un, yɨvɨ tu ka kuu saꞌa jniñu, yɨvɨ ni ka tɨyɨ un jiin yɨvɨ kuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti nu siaꞌan na saꞌa ra vasu ja kundatu ra, chi tu kuu chunaa yɨvɨ un nuu ra. Ko maa ra, chi naniꞌin ra taka ja ni jaꞌa ra un kɨvɨ na nachaku ra, ti kuncha ra nuu kaꞌiin yɨvɨ vaꞌa ja ni nakaji Yandios ja kunchuku i, i jiin ya ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nu ni ka jinisoꞌo yɨvɨ jnuꞌun un, ti ni kachi ɨɨn chaa nukoo mesa un jiin Jesús: ―Xaan ndatu yɨvɨ kaji i staa ñuu nuu taꞌu Yandios jniñu ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yukan ti ni kachi Jesús jiin da: ―Saꞌa yo nanu sɨkɨ ɨɨn chaa ni saꞌa ɨɨn viko kaꞌnu, ni jaꞌa da ɨɨn ja ni kuxini, ti ni kana da kuaꞌa xaan yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nu ni jaa hora kuxini, ti ni taji da chaa ka junukuachi nuu da un, kuan kana da chaa ni kana da un, ti ni kachi muzu da jiin chaa un naa da: “Choꞌo naa ra, chi ja ni kuu nakoo ja kuxini yo”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ko tendɨꞌɨ chaa un ni ka kandaꞌu. Undi nuu ni kachi ɨɨn da: “San ni jaan ri ɨɨn pedazu ñuꞌun, ti yukan kin ndeꞌe ri, ti kandaꞌu ri jiin ra ja na sakaꞌnu ini ra nuu ri”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɨnga da ni kachi: “San ni jaa ri uꞌun yunta, ti kuni ri skuaꞌa ri tɨ. Ja yukan kuu ja sakaꞌnu ini ra nuu ri”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ti ɨnga da ni kachi: “San ni nandaꞌa ri, ti ja yukan kuu ja tu kuu kiꞌin ri”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nu ni nandeokuñɨ muzu un, ni nakani da jnuꞌun nuu jitoꞌo da ja siaꞌan ni ka kaꞌan chaa un. Yukan ti ni kuɨtɨ xaan ini jitoꞌo un, ti ni kachi da jiin muzu da un: “Kuaꞌa corrɨ. Kuaꞌan taka ichi ka iyo ñuu yukan, ti kana taka yɨvɨ ndaꞌu un, jiin taka yɨvɨ tu ka kuu saꞌa jniñu un, jiin yɨvɨ ni ka tɨyɨ un, jiin taka yɨvɨ kuaa un na kikoyo i”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nu ni kuu naꞌan ga, ti ni kachi tuku muzu un: “Jitoꞌo na, ja ni jaꞌan ndɨꞌɨ na nava ni taꞌu ni jniñu, ko nuña ga ini veꞌe ni”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yukan ti ni kachi tuku jitoꞌo da jiin da: “Kuaꞌan tuku taka calle un jiin taka ichi un, ti chayɨka yɨvɨ na kikoyo i, ti nava na chitu ini veꞌe ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chi na kachi ri nuu ra naa ra, ja ni ɨɨn yɨvɨ ni kana ri undi nuu un, tu kuxini da veꞌe ri”, ni kachi da ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ni kuu kuaꞌa xaan yɨvɨ kuankoyo i jiin Jesús, ti ni ndeokoto Jesús ja xndaku ya nuu i, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Nu nau yɨvɨ na kuni kundikun ruꞌu, ko nu ka ndɨꞌɨ ga ini i ja kuu tata i, nana i, ñasɨꞌɨ i, seꞌe i, ñani i, kuaꞌa i, jiin maa i, ja kuu ruꞌu, ti na kachi ri ja tukaa ga yɨꞌɨ i jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ti nu tu ka ñukuu ini ra ruꞌu ja kundikun ra ruꞌu, ti vasu na kuū ra, ko tukaa ga ndɨvɨ ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ti nu ɨɨn ɨɨn ra ka kuni saꞌa ɨɨn veꞌe sukun ja na kundijin kotonchaa ra nɨ tuꞌu ñuꞌun ra, ¿xi ansu jandaa kuu ja xnakan nukoo ra, ti ndeꞌe ra nasa gastu kuu, na ndenu kujaa xuꞌun ra undi xndiꞌi ra jniñu un nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ti nu na kejaꞌa ra saꞌa ra nama jaꞌa, ti tu sinu ra, ti taka yɨvɨ kuni un, kejaꞌa i kuaku i ndeꞌe i roꞌo, ");
INSERT INTO mpmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ti kachi i: “Ni tejnaꞌan chaa un veꞌe da ko tu ni sinu da”, kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xi ɨɨn rey kuni da kanaa jnaꞌan da jiin ɨnga rey, ¿xi ansu jandaa kuu ja xnakan nukoo da, ti ndeꞌe da nu kundee uxi mil soldado da ja kinjnaꞌan da jiin oko mil kikoyo jiin ɨnga rey un nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ti nu ni jini da ja tu kundee da, ti nu nɨ jika vaji ɨnga rey un, ti taji da sava chaa ka ndiso jniñu, ja na kin kaꞌan ndaꞌu jiin chaa un ja na kukuee. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ti suni siaꞌan kuu jiin roꞌo naa ra, nu kuni kundikun ra ruꞌu, ti kuñu kuu ini ra ja xndoo ra taka ndajniñu ñavaꞌa ra. Xi nu tuu, ti na kachi ri ja tukaa ga yɨꞌɨ ra jiin ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Siin Jesús xndaku ya, ti ni kachi ya: ―Kuanjniñu yo ñɨɨ ja kuu nuu ndeyu, ko nu na naa xiko uꞌua ñɨɨ un, ti tukaa kuajniñu yo, ");
INSERT INTO mpmNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ni vasu ja sakanuu yo jiin ñuꞌun, ni ja sakanuu yo jiin jaꞌan. Tukaa kaxaan. Yukan ti so kacha yo kiꞌin. Yɨvɨ chunsoꞌo, ti na chunsoꞌo vaꞌa i jnuꞌun un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yukan ni ka tuꞌva tɨjnɨ ga yɨvɨ nuu Jesús naa i ja ka ñusoꞌo i jnuꞌun kaꞌan ya. Ti kaꞌiin chaa ka kinyaꞌu puesto un jiin uu ga yɨvɨ ja tu ka siuku ley Israel. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ti chaa ka xnaꞌan ley Israel un jiin chaa fariseo un ka kaꞌan da sɨkɨ Jesús, ti ni ka kachi da: ―Jantaꞌu chaa jaꞌa yɨvɨ tu siuku ley Israel, ti yaji jnaꞌan da jiin i vasu ka kuu i yɨvɨ ka saꞌa ndevaꞌa ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yukan ti ni jani Jesús ɨɨn jnuꞌun ja xndaku ya nuu yɨvɨ un, ti ni kachi ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nu ɨɨn ɨɨn ra ñavaꞌa ɨɨn ciento rɨɨ, ti skuita ra ɨɨn tɨ, ¿ti va nu tu xndoo ra ndɨꞌɨ kuun xiko xiaꞌun kuu ga tɨ un yuku un, ti kin nunduku ra kuɨtɨ ni skuita ra un undi nu tu naniꞌin ra tɨ xino? ");
INSERT INTO mpmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ti nu na naniꞌin ra tɨ, ti kusɨɨ ini ra, nachuxndee ra tɨ nuu soko ra, ti kuanoꞌon ra jiin tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nu ni najaa ra veꞌe ra, ti nastutu ra amigo ra jiin ñanijnaꞌan ra, ti kachi ra: “Na kusɨɨ ini yo, chi ja ni ndenda rɨɨ ni skuita ri un”, kachi ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ti na kachi ri jiin ra naa ra ja suni siaꞌan iyo jnuꞌun sɨɨ ini nuu andɨvɨ nuu kancha Tata yo Yandios jiin ɨɨn yɨvɨ ja ni nakani ini i nuu kuachi i, ansu jiin kuun xiko xiaꞌun kuun yɨvɨ ja ka ndoꞌo ini i ja tu iyo kuachi i, ti ka ndoꞌo ini i ja tu nɨɨ kuu ja nakani ini i nuu kuachi i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Siin Jesús xndaku ya, ti ni jani ya ɨɨn jnuꞌun siaꞌan: ―Jikajnuꞌun ri nuu ra naa ra. ¿Nu ɨɨn ñasɨꞌɨ yɨjnɨ ña uxi xuꞌun plata ti skuita ña ɨɨn, xi ansu jandaa kuu ja skuikun ña yɨtɨ ña, ti vii vii najista ña undi nuu tu naniꞌin ña xuꞌun ña nu? ");
INSERT INTO mpmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nu ni ndenda xuꞌun ña un, ti nastutu jnaꞌan ña, jiin amigo ña, jiin ñanijnaꞌan ña ja kanchuku yajni un, ti kachi ña: “Na kusɨɨ ini yo vijna, chi ja ni ndenda xuꞌun ni skuita ri un”, kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ti na kachi ri ja suni siaꞌan kusɨɨ ini ángel ka junukuachi nuu Yandios jiin ɨɨn yɨvɨ, ja nu ni nakani ini i nuu kuachi i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Siin Jesús xndaku ya, ti ni jani ya ɨɨn jnuꞌun siaꞌan: ―Ɨɨn chaa ni iyo uu seꞌe da, ");
INSERT INTO mpmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ti chaa suchi ga un ni kachi da jiin tata da: “Taa, kuaꞌa ni tɨꞌlɨ taꞌu na, tɨꞌlɨ ñuꞌun jiin xuꞌun na kuu na”, ni kachi da. Yukan ti ni chunsava tata da un taꞌu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jaku ni kɨvɨ, ti ni xiko chaa suchi un taꞌu da ja ni jaꞌa tata da un, ti jiin xuꞌun un kuaꞌan chaa un, kuan kuikonuu da ɨnga ñuu, ti yukan ni xnaa ndevaꞌa kuɨtɨ da xuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nu ja ni ndɨꞌɨ xuꞌun da ni xnaa da, ti kuiya un ni iyo ɨɨn jnama xaan tonto ñuu yukan, ti chaa un ni kejaꞌa jiꞌi da soko. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yukan ti ni kee da ni jan nduku da jniñu nuu ɨɨn chaa ñuu yukan, ti chaa un ni taji da chaa kuan koto da kɨnɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ko ni kejaꞌa jiꞌi xaan da soko, ti kuni da kaji da, ndeꞌe da ka yee kɨnɨ un, ko tu ni ɨɨn yɨvɨ ja kuaꞌa ja kaji da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yukan ti ni kejaꞌa da ndoꞌo ini da: Iin kuaꞌa muzu veꞌe tata yo ja tu kumani staa kaji da, ko maa yo, kande yo jaꞌa, ndoꞌo nene yo ti jiꞌi xaan yo soko ja kuni kuū yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vaꞌa ga na nandeokuñɨ yo nuu tata yo, ti na kachi yo jiin da: Taa, ni chaa kuachi na maa na nuu Yandios, ti suni nuu maa ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yukaa ga saꞌa ni nanu ja kuu na seꞌe ni, chi saꞌa ni nanu ja kuu na ɨɨn muzu ni. Siaꞌan ndoꞌo ini da ja kachi da jiin tata da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yukan ti ni kiꞌin da ichi, ti kuanoꞌon da nuu kancha tata da. Ti jika ga kuaꞌan da, ti ni jini tata da nuu da, ti ni kundaꞌu ini da seꞌe da. Ni jaꞌa da corrɨ, ni janujnaꞌan da chaa, ti ni ka nanuu janaꞌan da, ti ni ka teyuꞌu nuu jnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yukan na ti ni kachi seꞌe da un: “Taa, ni chaa kuachi na maa na nuu Yandios, ti suni nuu maa ni. Tukaa ga saꞌa ni nanu ja seꞌe ni kuu na”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ko chaa ñaꞌnu un, ni kachi da jiin muzu da ka junukuachi nuu da un: “Yachi ro naa ra, tava ɨɨn saꞌma vaꞌa ga yukan, ti na skuiꞌna ra da naa ra. Suni nachiꞌi ɨɨn xeꞌe xini ndaꞌa da, ti nachiꞌi ra ndijña da naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kuan kiꞌin chelu ni neñu un, ti kaꞌni ra naa ra. ¡Na saꞌa yo ɨɨn viko, ti na kaji yo naa yo! ");
INSERT INTO mpmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chi ni ndoꞌo ini ri ja, ja ni jiꞌi seꞌe ri jaꞌa, ko nanu ja ni nandoto da, chi ni ndenda tuku da. Ni skuita ri da, ko ni naniꞌin ri da”, kachi da. Ti ni ka kejaꞌa da ni ka saꞌa da viko naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ti seꞌe da chaa ñaꞌnu ga, kande da nuu jniñu, ti nu ni nandeokuñɨ da jaꞌi ni, ni kuyajni da veꞌe, ti ni jinisoꞌo da kuu yaa, ti ka jitajaꞌa yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yukan ti ni kana da ɨɨn chaa kuu muzu un, ti ni jikajnuꞌun da chaa ndoo kuu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ti chaa un ni kachi da: “Tuu, chi ñani ra ni nchaa, ti ni taꞌu tata ra jniñu ja na kuu chelu ni neñu un, chi ni nchaa vaꞌa da”, ni kachi muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ti chaa ñaꞌnu un ni kuɨtɨ ini da, ti tu kuni da ndɨvɨ da veꞌe da. Ti yukan ni kee maa tata da un, ni jan kaꞌan da jiin da ja na ndɨvɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ti ni kachi da jiin tata da: “Ja jini ni nasa ja ni kuu kuiya junukuachi na nuu ni, ti ni ɨɨn kɨvɨ tu kuniꞌin ini na nuu ni, ko ni ti kuaꞌa ga ni vasu ɨɨn ndixiꞌyu nuu na ja saꞌa na ɨɨn viko jiin amigo na. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ti vijna ni nchaa ɨnga seꞌe ni jaꞌa ja ni jaꞌan xnaa ndevaꞌa xuꞌun ni jiin ñaꞌan sɨɨ ini, ti ni jaꞌni ni chelu ni neñu un ja na saꞌa ni viko da”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yukan ti ni kachi tata da un jiin da: “Roꞌo, suni seꞌe ri kuu ra, ti taka ja ñavaꞌa ri jaꞌa kuu ja kuu maa ra, chi ndɨ kɨvɨ kancha ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ko vijna chi kanuu ja na saꞌa yo ɨɨn viko sɨɨ ini, chi ñani ra jaꞌa, ja ni jiꞌi da, ti nanu ja ni nandoto da chi ni ndenda tuku da. Ja ni ka skuita yo da, ko ni ka naniꞌin tuku yo da”, ni kachi chaa ñaꞌnu un ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yukan ti ni xndaku Jesús nuu ndajaꞌa ya, ti ni kachi ya: ―Ɨɨn chaa riku, ni iyo ɨɨn muzu da ja ndiso jniñu nuu ɨnga muzu, ko ni ka jani yɨvɨ jnuꞌun nuu da ja ni kejaꞌa xnaa ndevaꞌa chaa un ja ñavaꞌa chaa riku un. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yukan ti ni kana chaa riko un muzu da un, ti ni kachi da jiin da: “¿Ndoo kuu ja ka jani yɨvɨ jnuꞌun ra siaꞌan? Nakuaꞌa jnuꞌun taka jniñu ra, ti tukaa ga siin ra kuu ra muzu ri vijna na”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yukan na ti ni kejaꞌa ndoꞌo ini chaa kuu muzu un: “¿Nasa saꞌa yo vijna na, ja nu na kenchaa jitoꞌo yo jniñu yo? Ti maa yo, tu kundee yo kutu yo nuu ñuꞌun yo ja kuchaku yo. Ti kukanuu yo kakan yo caridad”, ni ndoꞌo ini da. Ko ni nakani tuku ini da siaꞌan: ");
INSERT INTO mpmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Suꞌva na saꞌa yo savaꞌa ni ga kɨvɨ na kenchaa da jniñu ndiso yo, ti nava na koo mani yɨvɨ ñuu yo jiin yo, ti kuu kɨvɨ yo ini veꞌe i. Ja jini yo nasa saꞌa yo vijna”, ni ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yukan ti ni kana da ndɨ ɨɨn ndɨ ɨɨn chaa ka tau nuu jitoꞌo da. Ti ni kachi da jiin ɨɨn da: “¿Nasa tau ra nuu jitoꞌo ri”? ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ti ni kachi chaa un: “Tau ri uni mil litro aceite”, ni kachi da. Yukan ti ni kachi muzu kuñaꞌnu ga un: “Jaꞌa iyo tutu ra ja tau ra un, nukoo ti vijna vijna saꞌa ra ɨnga ja ɨɨn mil sava ni ga”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yukan ti ni jikajnuꞌun da ɨnga chaa, ti ni kachi da: “Ti roꞌo, ¿Nasa tau ra nuu da nu”? ni kachi da. Ti ni kachi chaa un: “Tau ri ɨɨn ciento nundoo triu”, ni kachi da. Ti ni kachi tuku chaa kuu muzu kuñaꞌnu un: “Jaꞌa iyo tutu ra ja tau ra un, ko saꞌa tuku ɨnga ja kuun xiko ni ga”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yukan ti ni niꞌin jitoꞌo un jnuꞌun sɨkɨ muzu xndoñaꞌan un ja, ja ni ndu vivo da jiin jnaꞌan da, chi vivo xaan ni ka ndajnuꞌun da jiin jnaꞌan da un. Siaꞌan ni saꞌa chaa un chi jandaa kuu ja yɨvɨ ñuyɨvɨ jaꞌa, ka kuu vivo ga i jiin jniñu ka saꞌa jnaꞌan i, ti ansu yɨvɨ ka kandixia jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ko na kachi ndaa ri nuu roꞌo naa ra, ja ka kuu ra ndajaꞌa ri, ja ka saꞌa ra mani jniñu vaꞌa jiin taka ja ñavaꞌa ra. Ti kuaꞌa ra jaku ja ka nandɨꞌɨ yɨvɨ ndaꞌu nava na ndumani i jiin ra. Yukan ti nu ni ndɨꞌɨ ja ñavaꞌa ra nuu ñuyɨvɨ jaꞌa, ti kuaja ra andɨvɨ, ti yukan, taka yɨvɨ ndaꞌu ni chindee ra ñuyɨvɨ jaꞌa, na kuaꞌa i jandaa ja ni ka chindee ndixia ra i. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Saꞌa yo nanu. Taka yɨvɨ ka saꞌa niña jniñu vaꞌa jiin jaku ja ka ñavaꞌa i ja ka chindee i ɨnga yɨvɨ, suni siaꞌan na saꞌa vaꞌa i nu iin kuaꞌa ndajniñu i ja chindee i ɨnga yɨvɨ. Ko nu tu saꞌa i jniñu vaꞌa ja chindee i ɨnga yɨvɨ jiin jaku ja ka ñavaꞌa i, ti suni siaꞌan tukaa ga na saꞌa kuɨtɨ i jniñu vaꞌa nu ñavaꞌa i kuaꞌa ndajniñu. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ti nu tu ni saꞌa ra ja vaꞌa ja chindee ra ɨnga yɨvɨ ñuyɨvɨ jaꞌa, ti koto ma tatu ga Yandios roꞌo jiin jniñu ñaꞌnu ja kuu nuu nɨ kani andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ti nu tu saꞌa ra jniñu vaꞌa jiin taka ja ni jaꞌa ya nuu ra ñuyɨvɨ jaꞌa, ti koto ma tatu ga Yandios roꞌo jniñu ñaꞌnu ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yukan na kachi ri nuu ra naa ra ja ni ɨɨn muzu tu kuu kuanukuachi nuu uu jitoꞌo, chi kendo vaꞌa jiin ɨɨn da, ti kendo kuiꞌya i jiin ɨnga da. Ni tu kuu kuanukuachi i nuu Yandios, ti kundio ini i xuꞌun jiin ñuꞌun. Ja yukan kuu ja tu kuu kuanukuachi ra nuu Yandios, ti kuñukuu ini ra niꞌin ra xuꞌun jiin ñuꞌun ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ti chaa fariseo un naa da, ni ka skee ichi da ya nu ni jinisoꞌo da jnuꞌun ni kaꞌan Jesús, chi tɨndɨ da xuꞌun naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yukan ti ni kachi Jesús jiin da: ―Roꞌo naa ra, chi ka kuni ra ja na kaꞌan yɨñuꞌun xaan yɨvɨ nuu ra ja chaa ndaa ka kuu ra. Ko Yandios, ja jini ya nasa kaa ichi ini ra. Chi vixi ini ra jiin taka jniñu ka saꞌa ra, ti ja kuu nuu Yandios kuu mani jniñu kueꞌe jiin jniñu ndevaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Siin Jesús xndaku ya, ti ni kachi ya: ―Undi naa janaꞌan ni kii Juan, chaa ni skuanducha, ti ni kejaꞌa kaꞌan da jnuꞌun Yandios. Ti undi naa ni kii Juan ni taꞌu Yandios jniñu nuu ra naa ra jiin ley ni jaꞌa ya nuu Moisés, chaa ni kii na janaꞌan jiin uu ga profeta ni ka kii na janaꞌan. Ko vijna, ti Juan nu ni kejaꞌa kaꞌan da ɨɨn jnuꞌun jaa, ni jani da jnuꞌun sɨkɨ nasa jantaꞌu Yandios yɨvɨ naa i, ti kuu kɨvɨ i ndaꞌa ya. Ti kuaꞌa yɨvɨ ni ka ndusɨɨ ini i ja ni ka jinisoꞌo i jnuꞌun un. Vijna ti kuaꞌa yɨvɨ ka jantaꞌu i jnuꞌun ri, ja na kuu kɨvɨ i ndaꞌa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ko vanuxia ja iyo ɨɨn jnuꞌun jaa vijna. Na kachi ndaa ri nuu ra naa ra, ja yachi ga naa andɨvɨ jiin ñuyɨvɨ ti ansu ja na kenchaa ɨɨn letra nuu ley ni jaꞌa ya nuu Moisés jiin uu ga profeta. Ko jnuꞌun kaꞌan ley un, chi tu naa kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ja yukan kuu ja nu ɨɨn chaa na xndoo da ñasɨꞌɨ da, ti nandaꞌa da jiin ɨnga ñasɨꞌɨ ti nchakuachi da, chi yɨsɨkɨ nchaa da ñasɨꞌɨ da. Ti suni nu ɨɨn chaa na nandaꞌa jiin ɨɨn ñaꞌan ni xndoo yɨɨ, suni nchakuachi da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Siin Jesús xndaku ya, ti ni kachi ya: ―Saꞌa yo nanu. Ni iyo ɨɨn chaa riku xaan ja taka kɨvɨ saꞌa da viko kaꞌnu, ja vaꞌa xaan saꞌa da viko un, ti ñuꞌun da niña saꞌma vaꞌa, saꞌma fina. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ti suni ni iyo ɨɨn chaa ndaꞌu xaan tonto ja ni nani Lázaro, ti jan nukatuu da yuxeꞌe chaa riko un, ti nɨ tuꞌu da iin ndɨꞌyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti chaa ndaꞌu un, nɨnɨ jiꞌi xaan da soko, ti kuni da kaji da vasu savaꞌa ni ga ndeyu ja nukoyo yuꞌu mesa chaa riku un. Ti undi ina un ka tuꞌva tɨ nuu da, ti ka nayuu tɨ nuu ndɨꞌyɨ da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yukan ti ni jaa kɨvɨ ja ni jiꞌi chaa ndaꞌu un, ko ni jakoyo ángel Yandios ti kuankoyo ya jiin da nuu andɨvɨ un ja na kuncha da jiin chaa ni kuu tata yo na janaꞌan ni nani Abraham. Ti chaa riku un suni ni jiꞌi da, ti ni jakununduji da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ti nu ni kejaꞌa ndoꞌo da nundoꞌo nuu kaꞌiin ndɨyɨ un, ni ndokani da xini da, ti ni ndeꞌe da ja jika tɨꞌlɨ, ti yukan kaꞌiin Abraham jiin Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yukan na ti ni kanajiin da, ni kachi da: “Tata na Abraham, kundaꞌu ini ni saña. Kachi ni jiin Lázaro na kin chutoo da tɨꞌlɨ xini ndaꞌa da nuu nducha, ti na kii stoo da tɨꞌlɨ nuu yaa na, chi ndoꞌo xaan na nundoꞌo nuu yaa ñuꞌun jaꞌa”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ti ni kachi Abraham jiin da: “Hijo, nukuꞌun ini ja vaꞌa xaan ni kuncha ra nuu ñuyɨvɨ, ti Lázaro chi ndaꞌu xaan ni jnaꞌan da. Ko vijna chi iyo jnuꞌun ndee ini jiin da jaꞌa, ti roꞌo ko ndoꞌo ko nene ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko vijna iyo ɨɨn xaꞌva kaꞌnu maꞌñu nuu kaꞌiin yo jaꞌa, ja yukan kuu ja tu kuu yaꞌa yɨvɨ kaꞌiin jiin ri jaꞌa jiin nuu kaꞌiin ra jña. Ni yɨvɨ kaꞌiin jiin ra jña tu ku yaꞌa i nuu kaꞌiin ri jaꞌa”, ni kachi Abraham. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Yukan na ti ni kachi chaa riku un: “Kaꞌan ndaꞌu na jiin ni, tata na Abraham. Taji ni Lázaro na kiꞌin da veꞌe tata na, ");
INSERT INTO mpmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chi yukan kanchuku uꞌun ga ñani na. Ti na xndaku da nuu da naa da nava tu kikoyo da jaꞌa, chi iyo xaan ga kaa nundoꞌo jito na jaꞌa”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ko ni kachi Abraham jiin da: “Ka ñavaꞌa da tutu ni chaa Moisés jiin jnuꞌun ni ka chaa profeta na janaꞌan, ti nuu jnuꞌun un na chuꞌun ini da”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ti ni kachi tuku chaa riku un: “Jandaa kuu un, tata na Abraham, ko nu ɨɨn ndɨyɨ na nandoto ti kiꞌin nuu kanchuku da, ti va nakani ini da naa da”, kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ti ni kachi Abraham jiin da: “Ko nu tu ka kandixia da jnuꞌun Yandios ni kaꞌan tutu ni chaa Moisés, jiin jnuꞌun ya ja ni ka chaa profeta na janaꞌan, ti suni tu kandixia kuɨtɨ da vasu na nandoto ɨɨn ndɨyɨ ti kiꞌin nuu da”, ni kachi Abraham ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Nɨnɨ iyo ɨɨn jniñu saꞌa ja na kunchakuachi yɨvɨ naa i, ko ɨɨn nundoꞌo kaꞌnu xaan kundatu yɨvɨ ja skanakava jnaꞌan i nuu kuachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaꞌa ga na kundikun sukun i jiin yoso molino, ti na kiꞌin i chii nducha, ansu ja xndaꞌu i ɨɨn suchi lulu ja koto ma kandixia i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Koto vaꞌa ra maa ra. Nu na saꞌa ndevaꞌa ñani ra sɨkɨ ra, ti ndajnuꞌun ra jiin da sɨkɨ ja ni saꞌa da un. Ti nu nakani ini da, ti kuankaꞌnu ini nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Vasu uxia jinu na saꞌa ndevaꞌa da sɨkɨ ra ɨɨn kɨvɨ, ti ndɨ uxia jinu un jaa da ti kachi da: “Tukaa ga ndoo saꞌa ri nuu ra vijna na”, kachi da. Ti kuankaꞌnu ini nuu da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yukan ti apóstol, chaa ni nakaji ya ja kundiso jniñu un, ni ka kachi da jiin Jitoꞌyo Jesús: ―Saꞌa ni ja na kandixia ni ini ga na taka jniñu ja taꞌu ni nuu na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yukan ti ni kachi Jesús jiin da: ―Nu kandixia ndaa ra, vasu kuꞌva ɨɨn ndɨkɨn lulu, ti kuu kachi ra jiin yujnu jaꞌa: “Kuxio nuu kandichi ra jaꞌa ti kuaꞌan nuu mar un kundichi ra”, kachi ra naa ra, ti yujnu un chi kuandatu i nuu ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Siin Jesús xndaku ya nuu ndajaꞌa ya, ti ni kachi ya: ―Saꞌa yo nanu. Nu ɨɨn ɨɨn ra ñavaꞌa ɨɨn muzu ja sajniñu, ko tu niꞌin da ja kuu yaꞌu da, ti chaa un kin saꞌa da jniñu, xi kin koto da xndɨkɨ ti nchaa da, ¿xi va nu kachi ra jiin da siaꞌan naa ra? “¿Kuan yaꞌa ti nukoo ra kaji ra staa un xino?” ");
INSERT INTO mpmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jandaa ni kuu ja tuu, chi suꞌva kachi ra jiin da: “Savaꞌa ja na kuxini ri, chuꞌun ra ndeyu kaji ri, ti chuꞌun ra nducha na koꞌo ri xnakan, ti sa kuu nukoo ra ti kee ra staa.” ");
INSERT INTO mpmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Xi va nu nakuantaꞌu ra nuu muzu ra un, ja ni saꞌa da taka jniñu ni taꞌu ra nuu da un nu? Jandaa ni kuu ja tuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ti suni siaꞌan roꞌo naa ra, nu ni ndɨꞌɨ ni ka saꞌa ra taka jniñu, ti tu nduvixi ini ra naa ra, ti kachi ra: “Tu kanuu ja nakuantaꞌu ya nuu yo, chi sa nɨnɨ jniñu ni taꞌu ya ni ka saꞌa yo naa yo”, kachi ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nu ni siin Jesús ichi kuaꞌan ya ichi ñuu Jerusalén, ni yaꞌa ya ñuꞌun ñuu Samaria jiin Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nu ni jaa ya ɨɨn rancho, ti yukan ka janujnaꞌan uxi chaa ni ka jnaꞌan kueꞌe ndɨꞌyɨ teꞌyu ya. Ni ka jankuñɨ jika da tɨꞌlɨ, ");
INSERT INTO mpmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ti ni ka kanajiin da siaꞌan naa da: ―¡Jesús! ¡Maestro! Kundaꞌu ini ni saña naa na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nu ni jini Jesús da naa da, ti ni kachi ya: ―Kuan stuu maa ra nuu sutu Israel un naa ra ―ni kachi ya. Nɨ kuankoyo da naa da, ti ni ka ndundoo da jiin kueꞌe ka jnaꞌan da un. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ti ɨɨn da, nu ni jini da ja, ja ni ndundoo kueꞌe da un, ni nandeokuñɨ da, kanajiin da nakanajaa da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ni jakunjitɨ da nuu Jesús, ni sinu da nuu da undi nuu ñuꞌun ja nakuantaꞌu da nuu ya. Ti maa ɨɨn ni chaa un ni kuu ɨɨn chaa ñuu Samaria. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yukan ti ni kaꞌan Jesús: ―¿Xi ansu ka iyo uxi jnaꞌan ra ja ni ka ndundoo jiin kueꞌe ka jnaꞌan ra un nu? ¿Nanu kaꞌiin uu ga jnaꞌan ra un naa da? ");
INSERT INTO mpmNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Xi maa ɨɨn ni chaa ñuu jika jaꞌa kuu ja ni nandeokuñɨ ja nakanajaa da Yandios nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yukan ti ni kachi ya jiin chaa un: ―Ndokuñɨ ti kuaꞌan, chi ja ni nduvaꞌa ra ti kendo ndaa ra nuu Yandios, chi ni kandixia ndaa ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chaa fariseo un ni ka jikajnuꞌun da Jesús nama kuu ja kejaꞌa Yandios taꞌu ya jniñu nuu ñuu da naa da, ti ni kachi ya jiin da: ―Na chaa jniñu taꞌu Yandios, ko tu kuni ndijin ra nasa kejaꞌa ya taꞌu ya jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ti tu kuu kachi ra: “Jaꞌa kande”, xi kachi ra: “Yukan kande.” Chi na kachi ri ja, ja ni chaa Ɨɨn ja taꞌu jniñu nuu ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yukan sa ni kachi ya jiin chaa ka skuaꞌa jiin ya: ―Jaa ɨɨn kɨvɨ ja kundiyo ini ra naa ra ja maa Seꞌe Yɨvɨ Ñuyɨvɨ na ndenda ya nuu ra, ko tukaa ga kuni ra maa chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ti kachi yɨvɨ jiin ra naa ra: “Jaꞌa kande ya”, xi kachi: “Yukan kande ya.” Koto ma kandixia ra naa ra jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chi kɨvɨ nchaa maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti kuni ndijin ra naa ra nanu saꞌa nu janducha, ti ndinchaa nɨ tuꞌu undi nuu kaña ndikandii jiin undi nuu kee ndikandii. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ko xnakan kuu yaku ri nuu ñuyɨvɨ jaꞌa, ti kondoꞌo koo nene ri, chi vijna tu kuantaꞌu yɨvɨ ñuyɨvɨ jaꞌa ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Chi nanu ni iyo kɨvɨ ni chaku Noé, chaa ni kii na janaꞌan, ti suni siaꞌan kuu nu na jaa kɨvɨ nchaa maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ni kunchuku vatu yɨvɨ naa i nani kuncha Noé, chi ka ndoꞌo ini i ja kukuee nuu i naa i. Ka yaji i, ti ka jiꞌi i, ka nandaꞌa i, ti ka jaꞌa i seꞌe sɨꞌɨ i ka nandaꞌa ña naa ña, undi ni jaa kɨvɨ nu ni kɨvɨ Noé ini barco kaꞌnu da. Ko nu ni kuun ɨɨn sau xaan un, ti ni ka naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ti suni siaꞌan ni kuu na ni chaku Lot. Ni kunchuku vatu yɨvɨ. Ka yee i, ka jiꞌi i, ka jaan i savaꞌni ga ndajniñu, ti ni ka xiko i, ka saꞌa i jniñu, ti ka saꞌa i veꞌe i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ko nu ni kee Lot yuꞌu ñuu Sodoma, ti ni jinu ñuꞌun jiin azufre ja ni kii ichi andɨvɨ, ti ni ndɨꞌɨ ni yɨvɨ un ni ka jiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti suni siaꞌan kuu nu na jaa kɨvɨ ndenda maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ti ja kuu kɨvɨ un, yɨvɨ ka ndetatu i yuxeꞌe i, koto ma kiꞌin i ɨɨn ndajniñu i ini veꞌe i, ti na kunu xaan i naa i. Ti yɨvɨ kaꞌiin nuu jniñu, koto ma ndeokuñɨ i veꞌe i ja stutu i ni ɨɨn ndajniñu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ti nukuꞌun ini naa ra nasa ni ndoꞌo ñasɨꞌɨ Lot ja sa naa ni ti ni jiꞌi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Chi taka yɨvɨ ja kuni nama i maa i ñuyɨvɨ jaꞌa, ti tukaa nanitaꞌu i nuu Yandios ja kuu saa ni. Ti taka yɨvɨ vasu na kuu i ja sɨkɨ ruꞌu, ko yukan kuchaku i ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na kachi ri nuu ra naa ra nasa kuu ja kuu kɨvɨ un. Ti nu ka kixi uu yɨvɨ nuu ɨɨn jito jakuaa un, ti ɨɨn ni kiꞌin, ko ɨnga chi kendo. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ti koo uu ñasɨꞌɨ ka ndiko nduu ña; ɨɨn ña kiꞌin ri jiin, ti kendo ɨnga ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nu uu chaa kaꞌiin yuku xi nu ka saꞌa da jniñu, ɨɨn da kiꞌin ri jiin, ti kendo ɨnga da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nu ni ndɨꞌɨ ni ka ñusoꞌo ndajaꞌa Jesús, yukan na ti ni ka jikajnuꞌun da ya: ―¿Ti nanu kuu nu kuu siaꞌan Jitoꞌyo? ―ni ka kachi da. Ti ni kachi Jesús: ―Ndijin ndaa ndeꞌe yo ka kututu tiji nuu katuu kuɨtɨ ni jiꞌi. Ti suni siaꞌan ndijin ndaa ndeꞌe yo nu ndenda maa Seꞌe Yɨvɨ Ñuyɨvɨ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yukan ti ni jani Jesús jnuꞌun nuu chaa ka skuaꞌa jiin ya, ja kanuu ga ja tu xndoo da jnuꞌun kakantaꞌu da nuu Yandios, ja na koo ndee ini da ti siuku da taka jniñu tatu ya nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ti ja ni xndaku ya yukan nuu da, ti ni jani ya ɨɨn jnuꞌun siaꞌan: ―Ni iyo ɨɨn ñuu nuu ni iyo ɨɨn juez ja tu chiñuꞌun da jnuꞌun Yandios, ni tu jandatu da nuu ni ɨɨn yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti suni ñuu yukan ni iyo ɨɨn ñaꞌan maa ɨɨn. Ti ñaꞌan un jaꞌan ña, jaꞌan ña nuu juez un, kandaꞌu ña jiin da ja na nama da ña nuu ɨɨn yɨvɨ ka kanaa jiin ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ni kuu naꞌan jaꞌan ña, ko tu kuni juez un saꞌa da justicia. Ko ni jaa ɨɨn kɨvɨ, ti ni nakani ini da ti ni ndoꞌo ini da: “Vasu tu chiñuꞌun yo Yandios, ni tu saꞌa yo nanu nuu ni ɨɨn yɨvɨ, ");
INSERT INTO mpmNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ko ñaꞌan jaꞌa ni kuu nuu nuu xnañaꞌan ña nuu yo. Vaꞌa ga ja na nama yo ña, ti nava tukaa ga kiji ña chi so skuɨtɨ ña ini yo”, ni ndoꞌo ini da ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti ni kachi tuku Jitoꞌyo Jesús: ―Yukan kuu jnuꞌun ni ndoꞌo ini juez un ja tu vaꞌa ini da, ti ni nama da ñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ti suni siaꞌan saꞌa Yandios ja kuu taka yɨvɨ ka kandixia ja ni nakaji ya, ja kuu nduu kuu ñuu ka kandaꞌu i jiin ya. Ti jandaa ni kuu ja tu kukuee ya nama ya maa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na kachi ri ja tu kundatu ra, chi nama ya sɨkɨ ra. Ko nu na jaa kɨvɨ nchaa maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti na ndeꞌe yo nu kuni ya yɨvɨ ka siuku ndaa i jnuꞌun ya, ja ka kandixia ndaa i maa ya xi tuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ti nuu kaꞌiin tɨjnɨ chaa vixi ini, ja ka saꞌa yɨñuꞌun da maa da, ti ka skee ichi da ñanijnaꞌan da. Ti nuu chaa un ni kaꞌan Jesús jnuꞌun jaꞌa: ");
INSERT INTO mpmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Uu chaa ni ka jaꞌan sɨɨn da veñuꞌun kaꞌnu Israel ja ka jikantaꞌu da nuu Yandios. Ɨɨn da kuu chaa fariseo, ti ɨnga da kuu chaa kinyaꞌu puesto. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Chaa fariseo un chi kandichi da jikantaꞌu da, ti kachi da: “Niꞌin Yandios, nakuantaꞌu na nuu ni ja tukaa na nanu kanda sava yɨvɨ naa i, ja ka sakuiꞌna i, kanda kuaꞌan i, ti ka nchaka i uni kuun ñasɨꞌɨ, ni tukaa na nanu kaa chaa kinyaꞌu puesto jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Uu jinu kendo ndicha ini na ɨɨn semana, ti jaꞌa na tɨꞌlɨ tɨꞌlɨ nuu taka ja niꞌin na nuu niꞌin Yandios”, ni kachi chaa fariseo un. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ti chaa kinyaꞌu puesto un, chi jika ni kandichi da nuu chaa fariseo un, ti ni tu ni tava ini da ndakoto da ichi andɨvɨ, chi so ni kejaꞌa kani da ndaꞌa da jika da, ti kachi da: “Ay Yandios, kuankaꞌnu ini ni nuu na, chi kuu na ɨɨn chaa nchakuachi”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ti na kachi ri nuu ra ja chaa kinyaꞌu puesto un, ni jankaꞌnu ini Yandios nuu kuachi da ja ni kendo vaꞌa da nuu ya, sa kuan noꞌon da veꞌe da. Ti chaa fariseo un, chi tuu. Yukan, na kachi ndaa ri ja taka yɨvɨ saꞌa yɨñuꞌun i maa i ja kuni kuñaꞌnu i, ti suꞌva ka ndukuiꞌya ini i. Ko yɨvɨ ja kukuiꞌya ini un vijna suꞌva nduñaꞌnu i, chi maa Yandios saꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yukan ti ni ka yɨndaꞌa yɨvɨ suchi kuachi nuu Jesús ja na chuxndee ya ndaꞌa ya xini i. Ko nu ni ka jini ndajaꞌa ya, ti ni ka kejaꞌa ka nduxaan da jiin yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ko ni kana Jesús ja na tuꞌva suchi kuachi un nuu ya, ti ni kachi ya jiin ndajaꞌa ya: ―Sia naa ra na kikoyo i nuu ri ti tu kasɨ ra naa ra. Chi taka yɨvɨ ja kuni kɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, ti kuni ja na kɨvɨ i nanu suchi kuachi jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na kachi ri nuu ra naa ra ja tu yɨɨ kuantaꞌu ɨɨn suchi lulu jnuꞌun Yandios ja na taꞌu ya jniñu nuu i, ti ansu ɨɨn yɨvɨ ñaꞌnu ja, ja ni kuniꞌin ini, ti tu ka kuni kɨvɨ i ndaꞌa Yandios ja na taꞌu ya jniñu nuu i ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yukan ti ɨɨn chaa kuñaꞌnu un ni jikajnuꞌun da Jesús: ―Chaa vaꞌa kuu ni, maestro. Ti kachi ni, ¿naa jniñu vaꞌa saꞌa na ti niꞌin taꞌu na ja kuchaku na siaꞌan ni nuu andɨvɨ ja kuu saa ni? ―kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ti ni kachi Jesús: ―Ndoo kaꞌan ra ja chaa vaꞌa kuu ri, ti tu ni ɨɨn chaa vaꞌa iyo, chi maa ɨɨn ni Yandios iyo. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ja jini ra jnuꞌun taꞌu Yandios nuu yo: “Tu kunchaka ra tɨjnɨ ñasɨꞌɨ. Tu kaꞌni ra ndɨyɨ. Tu sakuiꞌna ra. Tu chakuachi ra yɨvɨ. Kuandatu nuu tata ra, nuu nana ra” ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ti ni kachi chaa riko un: ―Ja ni ndɨꞌɨ un ni jandatu na undi lulu na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja siaꞌan ni kaꞌan da, ti ni kachi Jesús jiin da: ―Ko iyo ɨnga jniñu kumani ja saꞌa ra. Xiko ndɨꞌɨ ja ñavaꞌa ra ti kuaꞌa nuu yɨvɨ ndaꞌu. Yukan na ti sa niꞌin ra taꞌu ra undi andɨvɨ. Yukan na ti sa kii ra na choꞌo ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nu ni jinisoꞌo chaa un ja siaꞌan ni kachi Jesús, ni kukuiꞌya xaan ini da ti kuaꞌan da, chi vanuxia chaa riko xaan kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ti ndeꞌe Jesús nuu da ni kee da kuaꞌan da, ti ni kachi ya jiin uu ga yɨvɨ un: ―Yɨɨ xaan ja kuu ɨɨn chaa riko ja na xndoo da ichi maa da, ti kɨvɨ da ndaꞌa Yandios ja na taꞌu ya jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jandaa ndixia ja va yachi ga yaꞌa ɨɨn camellu yau ɨɨn yɨkɨ tɨkuɨ, ti ansu ja kɨvɨ ɨɨn chaa riko ndaꞌa Yandios ja na taꞌu ya jniñu nuu da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yukan na ti yɨvɨ ni ka jinisoꞌo un ni ka kachi: ―Nusa, ¿ti nau kuu ja nanitaꞌu nu? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ti ni kachi Jesús: ―Ni ɨɨn yɨvɨ tu kuu saꞌa un, ko Yandios chi taka ni ja kuu saꞌa ya ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ti ni kachi Pedro: ―Saña naa na, ni ka xndoo na taka ja ka ñavaꞌa na ti vekoyo na jiin ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yukan ti ni kachi Jesús: ―Na kachi ndaa ri sɨkɨ nasa kuu jiin yɨvɨ ja kuni kɨvɨ i ndaꞌa Yandios ja taꞌu ya jniñu nuu i, vasu nu na xndoo da veꞌe da, xi ñasɨꞌɨ da, xi ñani da, xi tata da jiin nana da, xi seꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ja siaꞌan ti naniꞌin da viꞌga ja kuu taka ga ja ni ka xndoo da un, nava kuchaku da nuu ñuyɨvɨ jaꞌa, ti nanitaꞌu da nuu Yandios ja kuchaku da ja kuu saa ni―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ni kana sɨɨn Jesús ndɨ uxi uu ndajaꞌa ya un, ti ni kachi ya: ―Ja kuankoyo yo ichi ñuu Jerusalén, ti yukan na kundaa nava ni ka chiso profeta na janaꞌan ja kuu sɨkɨ ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nakuaꞌa yɨvɨ ruꞌu nuu yɨvɨ ɨnga nación, ti kusɨkɨnchaa yɨvɨ un ruꞌu, ti tɨvɨ sɨꞌɨ i nuu ri, kani i ruꞌu, ti kaꞌni i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ko nu uni kɨvɨ ti nandoto ri maꞌñu ndɨyɨ un chi ruꞌu kuu maa Seꞌe Yɨvɨ Ñuyɨvɨ, ja ni nakaji Yandios vaji ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ko ndajaꞌa ya un, tu ni ka chaku ini da ni tɨꞌlɨ jnuꞌun ni kaꞌan ya, chi jnuꞌun un tu ni kɨvɨ inijnuni da naa da. Yukan kuu ja tu ni ka chaku ini da nasa kuni kaꞌan jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nu kuan kuyajni Jesús ñuu Jericó, ti yuꞌu ichi un nukoo ɨɨn chaa kuaa jikan da xuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nu ni jinisoꞌo da ja ka yaꞌa yɨvɨ kuaꞌa, ti ni jikajnuꞌun da ndoo kuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ti ni ka kachi yɨvɨ un ja Jesús, chaa ñuu Nazaret kuu ja kuaꞌan ichi un. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yukan ti ni kanajiin da: ―¡Niꞌin Jesús! Maa ni ja taꞌu jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ti yɨvɨ ka yosjnuu un ni ka nduxaan jiin da ja na kasɨ yuꞌu da, ko maa da viꞌga ni kanakoꞌo da: ―¡Niꞌin Jesús! ¡Maa ni ja taꞌu jniñu nanu ni saꞌa rey yo David na janaꞌan, kundaꞌu ini ni saña! ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yukan ti ni jakuñɨ Jesús, ti ni kachi ya ja na kin kiꞌin da chaa un naa da. Nu ni jaa da nuu ya, ti ni jikajnuꞌun ya maa da: ");
INSERT INTO mpmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Ndoo kuni ra ja saꞌa ri jiin ra, nusa? ―ni kachi ya. Ti ni kachi chaa un: ―Jitoꞌyo, ja na ndundijin nduchi na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ti ni kachi Jesús jiin da: ―Na ndundijin nduchi ra. Ni nduvaꞌa ra vijna na chi ni kandixia ndaa ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti hora ni, ni nduvaꞌa nduchi chaa un, ti ni chindikun da kuaꞌan da jiin Jesús, ti nakuantaꞌu da nuu Yandios. Ti suni taka yɨvɨ ni ka jini jniñu ñaꞌnu un, ni ka kejaꞌa ka nakanajaa i Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yukan ti ni kɨvɨ Jesús ñuu Jericó, ti kuan yaꞌa ya maꞌñu ñuu yukan, ");
INSERT INTO mpmNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ti yukan iyo ɨɨn chaa riko nani Zaqueo, chaa kuñaꞌnu nuu chaa ka kinyaꞌu puesto un. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ti chaa un ndiyo ini da ja kuni da nuu Jesús, ko tu jini da ya chi yɨvɨ kuaꞌa kaꞌiin un ni jasɨ i nuu ya. Ti Zaqueo chi lɨkɨ da tɨꞌlɨ. Ja yukan kuu ja tu kuu kuni da nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yukan ti ni jaꞌa da corrɨ ni kandu da ti ni kaa da xini ɨɨn nutɨchɨ vixi kandichi yajni nuu yaꞌa Jesús, nava na kuni da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nu ni jaa Jesús jaꞌa yujnu un, ni ndakoto ya nuu kaxndee Zaqueo, ti ni kachi ya jiin da: ―Zaqueo, yachi ro ti kuan nuu, chi kuni ri kendo ri veꞌe ra vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yukan ti yachi ni nuu Zaqueo, ti ni kanxiaꞌu da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nu ni ka jini taka ga yɨvɨ un, ti ni ka kejaꞌa ka kaꞌan sɨkɨ Jesús ja kuni kendo ya veꞌe ɨɨn chaa kinyaꞌu puesto, vanuxia tu ni siuku ndaa da ley Moisés. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yukan ti ni ndokuɨñɨ Zaqueo, ti ni kachi da jiin Jitoꞌyo Jesús: ―Ndeꞌe ni Jitoꞌyo. Ja ndɨꞌɨ ja ñavaꞌa na, ti na kuaꞌa na sava nuu yɨvɨ ndaꞌu naa i, ti nu iyo ɨɨn ɨɨn yɨvɨ ni xndoñaꞌan na ja ni jisonchaa na ja ñavaꞌa i, ko vijna ti na nakuaꞌa na kuun ga jinu ja kuu ɨɨn ja ni jisonchaa na un ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ti ni kachi Jesús jiin da: ―Na kachi ndaa ri nuu roꞌo Zaqueo chi jandaa kuu ja kuu ra ɨɨn jnaꞌan tata yo Abraham na janaꞌan, ti ni kandixia ndaa ra ruꞌu vijna nanu ni kandixia tata Abraham na janaꞌan. Ti suni yɨvɨ kanchuku veꞌe ra jaꞌa ni ka jantaꞌu i ruꞌu, ti ja ni ka kandixia i ruꞌu. Yukan kuu ja kendo vaꞌa ra ti ketaꞌu ra nuu Yandios naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chi na kachi ri ja ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ ni chaa ri ja na chunaa ri nuu taka yɨvɨ nava tukaa kinkoyo i nuu infiernu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nɨ ka ñusoꞌo yɨvɨ jnuꞌun kaꞌan Jesús yukan, ti ni xndaku ya nuu i jiin ɨnga jnuꞌun sɨkɨ nasa taꞌu Yandios jniñu. Yukan kuni xndaku ya, chi ja yajni jaa ya ñuu Jerusalén, ti ka ndoꞌo ini yɨvɨ un ja ja ni jaa hora ja nduñaꞌnu ya ti taꞌu ya jniñu nuu nɨ tuꞌu nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ni ja ni ya ɨɨn jnuꞌun siaꞌan, ti ni kachi ya: ―Ni iyo ɨɨn chaa riko, ti ni ndoꞌo ini da ja kiꞌin da ɨnga nación jika, ja niꞌin da jniñu kunchaa da ti taꞌu da jniñu sɨkɨ ñuu da, ja na nduu da rey sɨkɨ ñuu da, ti sa ndeokuñɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na ti kiꞌin ga da, ti ni kana da uxi muzu ka junukuachi nuu da un, ti ni jaꞌa da ɨɨn ɨɨn xuꞌun nchaa yaꞌu xaan nuu da naa da, ti ni kachi da: “Nu na kiꞌin ri ti sajniñu naa ra jiin xuꞌun jaꞌa nava na nakaya seꞌe xuꞌun jaꞌa ja kuu kɨvɨ nchaa ri”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ko vanuxia yɨvɨ ñuu da un ka kuɨtɨ ini nuu da, ti ni ka taji da tɨjnu chaa kuaꞌan jata da nuu ɨnga ñuu, ja na kachi nuu chaa ñaꞌnu ɨnga ñuu un: “Tu ka jajnaꞌan ini yɨvɨ ja kundiso jniñu chaa jaꞌa nuu na naa na”, ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ko chaa riku un, chi ni niꞌin da jniñu kuncha da ja taꞌu da jniñu sɨkɨ ñuu da ja ni nduu da rey, ti ni nandeokuñɨ da nuu ñuu da. Yukan ti nu ni najaa da ñuu da tuku, ti ni kana da taka chaa ni jaꞌa da xuꞌun un nuu, ndenu nasa ni ka niꞌin ɨɨn ɨɨn chaa un, nu ni ka nataꞌu seꞌe xuꞌun ni jaꞌa da un xi tuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ni jaa ɨɨn muzu nuu chaa riko un, ti ni kachi da: “Taa, jiin ɨɨn xuꞌun ni un ni naniꞌin na uxi ga xuꞌun”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ti ni kachi rey un: “Iyo vaꞌa, ni kuu ra ɨɨn muzu vaꞌa, ja vaꞌa ni saꞌa jniñu ra jiin ɨɨn xuꞌun un. Vijna na ti na tatu ri ɨnga jniñu nuu ra ja na nduu ra ɨɨn chaa kuñaꞌnu, ti taꞌu ra jniñu nuu uxi ñuu”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yukan ti ni jaa ɨnga muzu, ti ni kachi da: “Taa, jiin ɨɨn xuꞌun un ni naniꞌin na uꞌun ga xuꞌun”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ti ni kachi tuku rey un jiin muzu da: “Iyo vaꞌa. Vijna na ti na tatu ri ɨnga jniñu nuu ra ja na nduu ra ɨɨn chaa kuñaꞌnu, ti taꞌu ra jniñu sɨkɨ uꞌun ñuu”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yukan sa ni jaa ɨnga muzu, ti ni kachi da jiin rey un: “Taa, jaꞌa iyo xuꞌun ni. Ni savaꞌa na chii ɨɨn pañitu. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yuꞌu na chi ja jini na ja kuu ni chaa tu ñundaꞌu ini, chi kuaꞌa ga nandakan ni, ti ansu ja ni jaꞌa ni, ti suꞌva kuni ga ni”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yukan ti ni kachi rey un jiin da: “Roꞌo chaa ndevaꞌa, jiin jnuꞌun kaꞌan ni ra xndichi ra maa ra. Ti kaꞌan ra ja viꞌi ga nandakan ri ansu ja ni jaꞌa ri. Ti suni kaꞌan ra ja suꞌva viꞌi ga kuni ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ti nu siaꞌan kuu nusa, ¿ndoo tu ni januu ra xuꞌun ri nuu chaa ka sajniñu sɨkɨ tratu, nava nu ni nchaa ri, ti nakiꞌin ri xuꞌun ri jiin seꞌe i niku”? ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yukan ti ni kachi da jiin chaa kaꞌiin un: “Kuisonchaa xuꞌun nuu muzu jaꞌa, ti kuaꞌa nuu chaa yɨjnɨ uxi xuꞌun un”, ni kachi rey un. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ti ni kachi chaa un naa da: “Taa, ti ndoo ti ja ñavaꞌa chaa un uxi jnaꞌan”, ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ti ni kachi rey un: “Na kachi ri jiin ra naa ra ja nu yɨvɨ ñavaꞌa un, ti suꞌva kii ga nuu i, ti kuñaꞌnu ga i jiin jniñu ndiso i. Ko yɨvɨ tundo ñavaꞌa, ti vasu tɨꞌlɨ jniñu ja ndiso i un, kuxio kiꞌin. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ti yɨvɨ ka jito uꞌu ruꞌu un, ja tu ka kuni ja kuu ri rey, kuan kiꞌin ti kaꞌni ra naa ra nuu ri jaꞌa”, kachi da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ti ni siin ya kuaꞌan ya ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nu ja yajni jaa ya ñuu Betfagé jiin Betania, yajni yuku Olivos, ti ni taji ya uu ndajaꞌa ya, ti ni kachi ya jiin da naa da: ");
INSERT INTO mpmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Kuankoyo rancho kande yajni un naa ra, ti nu jakoyo ra un, naniꞌin ra nuu ndikun ɨɨn burru ja ti koso ga yɨvɨ tɨ. Ndaji tɨ ti kikoyo ra jiin tɨ naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ti nu ka jikajnuꞌun yɨvɨ roꞌo ja ndoo ka ndaji ra tɨ, ti kachi jiin da naa ra ja maa Jitoꞌo ra nandɨꞌɨ da tɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kuankoyo ndajaꞌa ya, ti ni ka naniꞌin da burru un nava ni kachi Jesús nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja ka ndaji da burru un ti ni kekoyo chaa xiin tɨ un, ti ni ka kachi da: ―¿Ndoo ka ndaji ra burru un naa ra? ―ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ti ni ka kachi ndajaꞌa un: ―Maa Jitoꞌyo nandɨꞌɨ tɨ ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yukan ti kuankoyo da jiin tɨ nuu kande Jesús, ni ka chuku da saꞌma da sɨkɨ tɨ, ti ni ka skaa da Jesús sɨkɨ tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ti ichi kuaꞌan Jesús ni ka chuku yɨvɨ saꞌma i ini ichi un. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nu ni ka kuyajni ya nuu kande yuku Olivos, ti tendɨꞌɨ yɨvɨ ni ka kandixia ya ni ka kejaꞌa ka kanajiin ja ka kusɨɨ ini ti ka nakuantaꞌu i nuu Yandios ja ni ka jini i taka jniñu ñaꞌnu ni saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ti kachi i naa i: ―Ñaꞌnu na koo maa rey yo, chi Tata yo Yandios ni taji ya maa chaa ndiso jniñu ñaꞌnu nuu ya. Ja ni ndumani Yandios jiin yɨvɨ ñuu ya vijna. ¡Na kachi ndajaꞌa ya undi andɨvɨ un ja na koo ñaꞌnu chaa jaꞌa! ¡Siaꞌan na kachi da! ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yukan ti sava chaa fariseo kuan koyo jiin yɨvɨ un, ni ka kachi jiin ya: ―Maestro, nduxaan ni nuu ndajaꞌa ni jaꞌa ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ti ni kachi Jesús jiin da naa da: ―Na kachi ri jiin ra naa ra, ja nu na kasɨ yuꞌu yɨvɨ jaꞌa na i, ti suni kuu saꞌa Yandios ja na kanajiin yuu un naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nu ni kuyajni ya ñuu Jerusalén, ni jitonchaa ya ñuu un, ti ni ndukuiꞌya ini ya. Ti ni ndeꞌe ya ja sɨkɨ yɨvɨ un, ");
INSERT INTO mpmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ti ni kachi ya: ―Roꞌo, yɨvɨ ñuu Jerusalén, sa ti ni ka chaku ini ra vasu ɨɨn tɨꞌlɨ ja vijna kuu kɨvɨ ja ndumani ra jiin Yandios naa ra niku, ko vijna tukaa chi ja ni yaꞌa un, ti ja yɨsaꞌyɨ, ti tukaa ga kuni ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chi suꞌva, jaa kɨvɨ ja kondoꞌo ra ɨɨn nundoꞌo xaan, ti chakoyo yɨvɨ ka jito uꞌu roꞌo, kuikonduu i ñuu ra, ti kasɨ kutu i jiin yuu, ti ya yukan ndonda i sɨkɨ ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ti ndɨꞌɨ veꞌe ra kanuu i, ti kaꞌni i tendɨꞌɨ ra. Ti tukaa xndoo i ni ɨɨn veꞌe ja kosojnaꞌan ga ɨɨn yuu. Siaꞌan na koo nundoꞌo un nuu ra chi tu ni ka jantaꞌu ra ruꞌu, ja ni taji Yandios ja chunaa ri nuu roꞌo naa ra ―kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nu ni jaa Jesús nuu yuxeꞌe veñuꞌun kaꞌnu un, ti ni kejaꞌa keniꞌin ya taka yɨvɨ ka xiko ini veñuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ti ni kachi ya jiin yɨvɨ un: ―Siaꞌan yoso nuu tutu Yandios: “Veꞌe ri konani veꞌe nuu kakantaꞌu yɨvɨ naa i”, ko roꞌo naa ra, ni ka nasaꞌa ra veꞌe nuu ka nataka ñakuiꞌna ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Taka kɨvɨ ni xnaꞌan Jesús nuu yuxeꞌe veñuꞌun kaꞌnu un, ko sutu ka kuñaꞌnu un jiin taka chaa ka kuñaꞌnu ñuu un, ka nduku da nasa kuu kaꞌni da ya naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ko tu kuu nasa saꞌa da naa da, chi tendɨꞌɨ yɨvɨ un ka kusɨɨ xaan ini i jiin taka jnuꞌun ni xnaꞌan Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɨɨn kɨvɨ kande Jesús nuu yuxeꞌe veñuꞌun kaꞌnu un xnaꞌan ya nuu yɨvɨ, ti kaꞌan ya jnuꞌun Yandios nuu i naa i, ti ni ka jakoyo sutu ka kuñaꞌnu un jiin chaa ka xnaꞌan ley Israel jiin chaa ka kuñaꞌnu nación Israel, ti ni ka kachi da jiin ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","―Kachi nuu ri, ¿nau ni taꞌu jniñu ñaꞌnu ja saꞌa ra taka jniñu jaꞌa? ¿Xi nau ja ni jaꞌa jniñu ñaꞌnu jaꞌa nuu ra? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ti ni kachi Jesús jiin da naa da: ―Suni ruꞌu, na kajnuꞌun ri roꞌo naa ra ɨɨn jnuꞌun. Na kachi ri, ");
INSERT INTO mpmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿nau ja ni tatu jniñu nuu Juan ja ni kii skuanducha da yɨvɨ nusa? ¿Ɨnga yɨvɨ ni tatu jniñu un nuu da, xi maa Yandios nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yukan ti ni ka kejaꞌa ka ndajnuꞌun maa da naa da, ti ni ka kachi da: ―Nu na kachi yo ja Yandios ni taji chaa un, ti kachi da jiin yo: “¿Ndoo tu ni ka kandixia ra jnuꞌun ni kaꞌan da nusa?” ");
INSERT INTO mpmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ti nu na kachi yo ja yɨvɨ ni taji da, ti va tendɨꞌɨ yɨvɨ kaꞌiin jaꞌa kaꞌni yoꞌo jiin yuu, chi tendɨꞌɨ yɨvɨ ka kandixia ja Juan ni kuu ɨɨn profeta, ja ni kaꞌan jnuꞌun Yandios ―siaꞌan ka ndajnuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yukan sa ni ka kachi da: ―Tu ka jini ri nau ja ni taji Juan, ja ni kii skuanducha da yɨvɨ ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yukan na ti ni kachi ya jiin da naa da: ―Vanuxia tu ka kuni kachi ra, ti suni ruꞌu tu kachi ri nuu ra nau ja ni jaꞌa jniñu ñaꞌnu jaꞌa nuu ri ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yukan ti ni xndaku Jesús nuu yɨvɨ un jiin jnuꞌun jaꞌa, ti ni kachi ya: ―Ɨɨn chaa ni xndee kuaꞌa da nutɨkaꞌya, ti ni jakanchaa da ñuꞌun un nuu chaa ka sajniñu un, ti ni kee da kuaꞌan da, ti ni kunaꞌan kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nu ni jaa kɨvɨ nastutu da tɨkaꞌya un, ti ni taji da ɨɨn muzu ja na kin kakan da sava tɨkaꞌya un ja kuu maa da nuu chaa ka yɨndaꞌa un. Ko ni ka kiꞌin da chaa un, ni ka kaja da chaa nuu ñuꞌun, ti ni ka nataji da chaa kuanoꞌon da siaꞌan ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ti chaa xiin jniñu un, ni taji tuku da ɨnga muzu da kuaꞌan, ko suni ni ka kaꞌan ndevaꞌa chaa ka ndito un nuu da, ni ka kaja da chaa, ti kuanoꞌon da siaꞌan ni tuku. Tundo ni ka jaꞌa da nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chaa xiin un, ni taji tuku da ɨnga da, ko chaa ka ndito jniñu un ni ka stuji da chaa, ti ni ka keniꞌin da chaa kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yukan na ti chaa xiin ñuꞌun un, ni ndoꞌo ini da: “¿Nasa saꞌa yo vijna na? Va na taji yo seꞌe yo na kiꞌin da vaꞌa ga, ti nu na kuni chaa un nuu da, ti va kuandatu da naa da”, ni ndoꞌo ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko nu ni ka jini chaa ka ndito jniñu un nuu seꞌe chaa xiin ñuꞌun un, ti ni ka kachi da: “Chaa jaꞌa kuu ja xiin taꞌu. Vaꞌa ga na kaꞌni yo, ti na kendo ndɨꞌɨ yo jiin yaji jaꞌa”, ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ni ka jnɨɨ da chaa un, ni ka keniꞌin da chaa fuera yuꞌu ñuꞌun un, ti ni ka jaꞌni da chaa. ¿Ti ndoo saꞌa chaa xiin ñuꞌun un jiin chaa ka ndito jniñu ja siaꞌan? ");
INSERT INTO mpmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Va najaa da ti kaꞌni da chaa ka kuu muzu un, ti kuaꞌa da ñuꞌun un nuu ɨnga yɨvɨ ka ndito un ―ni kachi Jesús. Nu ni ka jinisoꞌo yɨvɨ jnuꞌun un, ti ka kaꞌan: ―¡Ni tu kachi Yandios ja koo siaꞌan nuu yo, nanu ni jnaꞌan muzu ni ka ndito i ñuꞌun tɨkaꞌyɨ un! ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yukan ti ni ndeꞌe Jesús nuu yɨvɨ un, ti ni kachi ya: ―Nusa ti ¿ndoo kuni kaꞌan jnuꞌun yoso nuu tutu Yandios ja kachi siaꞌan? Yuū ni ka skaña chaa ni ka saꞌa nama jaꞌa, kuu ja kanuu ga ja ndiso jniñu jikɨ ɨɨn veꞌe. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ti nanu ni ka saꞌa chaa ni skaña yuū un, suni siaꞌan na kuu yɨvɨ tu ka jantaꞌu ruꞌu. Ti siaꞌan nanu ka tuji yɨvɨ ka jiokava sɨkɨ ɨɨn yuū, suni siaꞌan jnaꞌnu ndatu yɨvɨ tu kandixia ruꞌu. Ko kɨvɨ na saꞌa ndaa Yandios kuachi i, ti yɨvɨ tu ni kandixia ruꞌu, koo ndoꞌo i nanu jnaꞌan ɨɨn yɨvɨ kanakava ɨɨn yuū sɨkɨ i ti kundiꞌi kukuachi i saꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti chaa ka kuu sutu ka kuñaꞌnu un jiin chaa ka xnaꞌan ley Israel un, ni ka nduku da nasa kuu jnɨɨ da Jesús hora un. Ko vanuxia ni ka yuꞌu da ndeꞌe da yɨvɨ un. Chi ni ka chaku ini da ja sɨkɨ maa chaa ka kuñaꞌnu un, ni kaꞌan Jesús jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yukan ti chaa ka kuñaꞌnu un ni ka nduku da chaa ni ka nduku jnuꞌun, ja na saꞌa da ja chaa vaꞌa ka kuu da, ja na nduku da ɨɨn jnuꞌun, na ndenu naa jnuꞌun kani Jesús, ti nava siaꞌan ti na niꞌin da ichi ja kankuachi da jaꞌa ya, nava nakuaꞌa da ya nuu gobernador. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja yukan kuu ja ni ka jikajnuꞌun da ya siaꞌan: ―Maestro, ka jini na ja kaꞌan ndaa ni, ti xnaꞌan ndaa ni ichi Yandios, ti tu yuꞌu ni ndeꞌe ni ni ɨɨn chaa vasu kuñaꞌnu ga da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nusa ti kachi ni nuu na nasa ndoꞌo ini ni. ¿Iyo vaꞌa nu chaꞌu yo xuꞌun nuu gobierno Romano xi tuu nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ko ja jini Jesús ja tu ka ndoꞌo vaꞌa ini da, ti ni kachi ya: ―¿Ndoo ka kuni xndaꞌu ra ruꞌu? ");
INSERT INTO mpmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xnaꞌan ɨɨn xuꞌun un nuu ri. ¿Naa nūū kuu ja nchaa nuu xuꞌun jaꞌa, ti naa sɨvɨ kuu ja yoso un nusa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ti ni ka kachi da: ―Nūū maa rey nación Roma kuu ―ni ka kachi da. Yukan ti ni kachi Jesús: ―Nusa ti kuaꞌa nuu rey nación Roma ja xiin maa da, ti kuaꞌa nuu Yandios ja xiin maa Yandios ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yukan ti tu ni kuu chakuachi da jiin jnuꞌun xnaꞌan ya nuu yɨvɨ un. Chi suꞌva ni ka naa ini da ja siaꞌan ni nachiso ya nuu da, sa ni ti ni ka jasɨ yuꞌu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nu ni yaꞌa un, ti ni ka jaꞌan sava chaa saduceo ni ka jandeꞌe da Jesús. Chaa saduceo un ka kaꞌan ja tukaa ga ka nandoto ndɨyɨ un, ti ni ka kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, ni kachi Moisés ja nu na kuū ɨɨn chaa ni iyo ñasɨꞌɨ, ti tu ni iyo seꞌe da jiin ña, ti kuu nandaꞌa ñani ndɨyɨ un jiin ña ja na koo seꞌe ña, ti suchi un nduu nanu seꞌe maa ndɨyɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ti yukan ni iyo uxia da mani ñani da naa da. Ti chaa ñaꞌnu un ni nandaꞌa da, ko tu ni iyo seꞌe ñasɨꞌɨ da, ti ni jiꞌi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni nakiꞌin chaa kuu uu un ñaꞌan un, ko suni tu ni iyo seꞌe da jiin ña, ti ni jiꞌi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ti chaa kuu uni un ni nakiꞌin tuku da ñaꞌan un, ti siaꞌan ni ka saꞌa ndɨ uxia da, ko ndɨ uxia da ni ka jiꞌi, ti tu ni iyo ni ɨɨn seꞌe ñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sandɨꞌɨ ni ga ti ni jiꞌi tu maa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ti nu na nandoto ndɨyɨ un naa da, ¿nau ndɨꞌɨ uxia ñani un xiin ñasɨꞌɨ un, ja siaꞌan ni ka nandaꞌa da jiin ña nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yukan ti ni kachi Jesús jiin da naa da: ―Ja kuu nuu ñuyɨvɨ jaꞌa, chi kuu chaa, kuu ñasɨꞌɨ ka nandaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ko nu na nandoto ndɨyɨ un, ti kachi Yandios ja kuu kɨvɨ i ñuu nuu taꞌu ya jniñu, ko tukaa kuu nandaꞌa i ni tu kuaꞌa i seꞌe sɨꞌɨ i ja nandaꞌa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ti yukan tukaa ga ka jiꞌi ndɨyɨ un, chi nduu i nanu ángel Yandios. Ka kuu i yɨvɨ Yandios ja kuu saa ni, chi maa Yandios ni naxndoto ya i. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Suni nu ka kaꞌu ra nuu tutu Yandios ja ni chaa Moisés, ti ni kaꞌan da sɨkɨ chaa ka chaku vasu ja ni ka jiꞌi da na janaꞌan. Chi nuu kayu yukū un, ni kachi Yandios nuu da: “Maa ri kuu Yandios ja ka kanajaa Abraham jiin Isaac jiin Jacob.” Siaꞌan ni chaa Moisés jnuꞌun Yandios, chi ni ka chaku chaa un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yukan kuni kaꞌan ja Yandios tu kuu ya Yandios nuu yɨvɨ ni ka jiꞌi un, chi kuu ya Yandios nuu yɨvɨ ka chaku, ja tu ka kendo i maꞌñu ndɨyɨ, chi ni ka nandoto taka ndɨyɨ un ja ka chaku i nuu ya, ja ka chiñuꞌun da Yandios ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yukan ti sava chaa ka xnaꞌan ley Israel un, ni ka kachi jiin Jesús: ―Iyo vaꞌa jnuꞌun kaꞌan ni, maestro ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yukan ti ni ɨɨn yɨvɨ, tukaa ni ka tava ini da kajnuꞌun ga da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yukan ti ni kachi Jesús jiin chaa ñaꞌnu Israel un: ―Kaꞌan yɨvɨ ja Cristo kuu ɨɨn jnaꞌan rey David na janaꞌan, vasu maa Yandios ni taji ya ja na kundiso ya ɨɨn jniñu ñaꞌnu ga ja kuu maa David. Ko vasu kuu ja siaꞌan ka kaꞌan yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ti maa David ni kaꞌan da nuu tutu Salmo siaꞌan: Yandios ni kachi nuu Jitoꞌo Cristo: “Nukoo ndaꞌa kuaꞌa ri, chi taꞌu ra jniñu jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Iyo yɨvɨ jito uꞌu roꞌo, ko kundee ra jiin, chi chindee ri roꞌo.” Ni kachi Yandios, kachi David. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nu siaꞌan kuu ja maa David ni skonani da ya jitoꞌo da, ti ¿nasa kuu ja Cristo kuu ɨɨn jnaꞌan rey yo David na janaꞌan nusa? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nu tendɨꞌɨ yɨvɨ un ka ñusoꞌo i jnuꞌun xndaku Jesús, ti ni kachi Jesús jiin ndajaꞌa ya siaꞌan: ");
INSERT INTO mpmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Koto maa ra naa ra jiin chaa ka xnaꞌan ley Israel. Koto ma saꞌa ra nava ka saꞌa da naa da. Chi chaa un ka jajnaꞌan ini da kuꞌun da saꞌma nani, ja na kuni yɨvɨ ja chaa kuñaꞌnu ka kuu da nuu veñuꞌun Israel. Ti ka kuni da ja na kaꞌan yɨñuꞌun yɨvɨ jiin da nuu yaꞌu, ti na kaꞌan xiaꞌu i jiin da, “Maestro, maestro.” Suni ka jajnaꞌan ini da silla yɨñuꞌun ga nuu kunchuku da ini veñuꞌun Israel un. Ti ka kusɨɨ xaan ini da jiin jnuꞌun yɨñuꞌun nuu kunchuku da kaji da staa nuu ɨɨn viko. ");
INSERT INTO mpmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Suni ka jisonchaa da veꞌe ñaꞌan ni kendo maa ɨɨn ña naa ña, ti ja tu kuni yɨvɨ jniñu kueꞌe ka saꞌa da un, ti kani xaan ka jikantaꞌu da nuu Yandios. Ti ja kuu maa da kii ɨɨn nundoꞌo kaꞌnu xaan ga ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nuu yuxeꞌe veñuꞌun kaꞌnu un ni jini Jesús ja ka chuꞌun chaa riku un xuꞌun nuu jajnu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Suni ni jini ya ja ni jaa ɨɨn ñaꞌan ndaꞌu xaan ni chuꞌun ña uu xuꞌun cobre kuachi, ");
INSERT INTO mpmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ti ni kachi ya jiin yɨvɨ kaꞌiin yajni un: ―Ndeꞌe naa ra. Na kachi ndaa ri ja ɨɨn ñaꞌan ndaꞌu xaan ga jaꞌa, yaꞌu xaan nchaa xuꞌun ni jaꞌa ña un nuu Yandios ja kuu xuꞌun ni ka jaꞌa chaa riku un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chi yɨvɨ riku xaan un, ni ka jaꞌa da jaku ni ja ka ñavaꞌa da. Ko ñaꞌan ndaꞌu un, tu ñavaꞌa kuaꞌa ña xuꞌun, ko ni jaꞌa ndɨꞌɨ ña ja ñavaꞌa ña, vasu nandɨꞌɨ ña ja kuu gastu ña ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ti sava ndajaꞌa Jesús ka kaꞌan da ja nde vii kaa veñuꞌun kaꞌnu un, ja nde vii kanda yuu un jiin taka ja ni ka soko yɨvɨ nu ni ka saꞌa da veñuꞌun un. Ti ni kachi Jesús: ");
INSERT INTO mpmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ndɨꞌɨ jaꞌa ka jitonchaa ra naa ra. Ko jandaa na kachi ri nuu ra naa ra ja, jaa ɨɨn kɨvɨ ja ni ɨɨn yuu tukaa kendo koso jnaꞌan jaꞌa, chi ndɨꞌɨ jaꞌa naa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yukan na ti ni ka jikajnuꞌun ndajaꞌa ya naa da: ―Maestro, ¿nasa da ti sa kundaa jnuꞌun kaꞌan ni un? ¿Ti naa seña koo ja kuan kuyajni kundaa taka jnuꞌun un? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ti ni kachi Jesús: ―Koto maa ra naa ra. Koto ma xndaꞌu yɨvɨ roꞌo. Chi kuaꞌa yɨvɨ kikoyo, ti ndaku niꞌin yɨ sɨvɨ ri, ti kachi: “Ruꞌu kuu Cristo”, kachi i. Xi ɨnga yɨvɨ kaꞌan: “Vijna kuu kɨvɨ ja ni taji Yandios ruꞌu ja saꞌa ri jniñu ñaꞌnu”, kachi. Koto kundikun ra jnuꞌun xndaku yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ti kuni ra jnuꞌun ja ya yukan koo guerra, ti kanaa yɨvɨ. Koto yuꞌu ra naa ra, chi siaꞌan ndixia kuu. Ko jiin yukan ti ni ti jaa ga kɨvɨ ja ndɨꞌɨ ñuyɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yukan ti ni siin Jesús kaꞌan ya: ―Kanaa ɨɨn nación jiin ɨnga nación, suni ɨɨn ñuu jiin ɨnga ñuu. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Koo ñujnaa xaan, jiin jnama xaan, jiin kueꞌe xaan ya yukan. Ti koo seña nuu andɨvɨ ja undi yuꞌu yɨvɨ naa i ndeꞌe i un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ko xnakan roꞌo ja ka kandixia ra ruꞌu, jnɨɨ yɨvɨ roꞌo naa ra, ti kuaꞌa i tau ra. Ti nakuaꞌa i roꞌo naa ra nuu chaa ka kuñaꞌnu ini taka veñuꞌun Israel, ja na xndichi da roꞌo naa ra, ti jnaa da roꞌo vekaa naa ra. Ti suni ja sɨkɨ ruꞌu, ti nakuaꞌa da roꞌo naa ra nuu chaa ka kuu rey ja ka taꞌu jniñu nuu nɨ tuꞌu ɨɨn nación, ti suni na kuaꞌa da roꞌo nuu gobernador sɨkɨ ja ka kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Siaꞌan kuu kaꞌan vaꞌa ra nuu chaa ka kuñaꞌnu un, ja sɨkɨ ruꞌu kuu ja ka jnaꞌan ra nundoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Siaꞌan ti koto xndiꞌi ra ini ra ja nasa koo jnuꞌun kaꞌan ra nuu chaa ka kuñaꞌnu un ja nama ra maa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chi maa ri kuu ja kuaꞌa inijnuni ra ja nasa koo jnuꞌun kaꞌan ra naa ra, ti nava ni ɨɨn yɨvɨ ja koto uꞌu roꞌo tu kundee chajnaꞌan jnuꞌun kaꞌan jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti undi tata ra, ñani ra, jnaꞌan ra, jiin amigo ra kinaa ñaꞌan da roꞌo naa ra, ti kachi da ja na kuū ra naa ra. Ti jandaa ni kuu ja tɨjnɨ ra naa ra kuū. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ti tendɨꞌɨ yɨvɨ ja tu ka kandixia i jnuꞌun ri, koto uꞌu i roꞌo naa ra ja ni ka kandixia ra ruꞌu jiin jnuꞌun kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ko tu naa ni ɨɨn ixi xini ra naa ra, chi koto ya roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ti nu ka ñukuu nɨ ini ra jnuꞌun ri, ti kuchaku ra ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","―Nu ni ka jini ra ja, ja ni ka jiconduu soldado ñuu Jerusalén, yukan na ti kuni ra ja kuan kuyajni kɨvɨ ja naa ñuu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ti yɨvɨ kanchuku ñuu Judea, na kinkoyo i undi yuku un. Ti yɨvɨ kanchuku ñuu Jerusalén, na kekoyo i ñuu un, ti yɨvɨ kaꞌiin yuku xi nuu jniñu, koto ma ndeokuñɨ ga i ñuu un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chi kɨvɨ un kuu kɨvɨ kii nundoꞌo kaꞌnu xaan nanu yoso nuu tutu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Na ndaꞌu ñaa ka ñuseꞌe xi ñaa ka nchaka suchi yɨkɨn ja kuu kɨvɨ un! Ko nundoꞌo xaan taka nuu ñuyɨvɨ ja kuu kɨvɨ un, ti kii ɨɨn nundoꞌo kaꞌnu xaan ja kuu yɨvɨ ñuu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kuaꞌa yɨvɨ ñuu kuū nuu guerra un. Ti sava ga yɨvɨ un kinkoyo i presu nuu yɨvɨ ɨnga nación. Ti ndunúú yɨvɨ ñuu jika un nuu yɨvɨ ñuu Jerusalén, ti saꞌa ndevaꞌa i jiin da undi na jaa kɨvɨ na kachi maa Yandios ja siaꞌan koo jiin yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nu ni ndɨꞌɨ un, yukan na ti koo ɨɨn seña nuu ndikandii, yoo, jiin choxini. Ti nuu ñuyɨvɨ jaꞌa sana ini yɨvɨ taka nación, chi yuꞌu i ja saꞌa iyo nducha mar jiin ja iyo ndonda nuu nducha un. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti so saꞌu ini yɨvɨ naa i ja siaꞌan na koo nuu ñuyɨvɨ. Nɨꞌɨn nutuꞌu andɨvɨ ti nukoyo chuxini. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yukan na ti ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, kuni yɨvɨ naa i ndenda ri, ti ndii ri nuu viko un, jiin jniñu ja ni nduñaꞌnu xaan ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nu ni kejaꞌa kuu ndaa taka jaꞌa, koo ndee ini naa ra ti nava na kosɨɨ ini ra, chi ja yajni ketaꞌu ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Suni ni kachi ya ɨnga jnuꞌun jaꞌa, ti ni kachi ya: ―Ndeꞌe naa ra, nutɨchɨ vixi un jiin savaꞌa ni ga ɨnga nuu yujnu, ");
INSERT INTO mpmNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","nu ja ni nduyucha numa i, ti ja ni chaku ini yo ja kuan kuyajni viko sau. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti suni siaꞌan kuu nu ja ni kejaꞌa kuu ndaa taka jnuꞌun jaꞌa, ti ni jini yo ja kuan kuyajni ndaa kɨvɨ nu kejaꞌa taꞌu ri jniñu jiin Yandios nuu nɨɨ tuꞌu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ti jandaa na kachi ri ja taka un kuu ndaa xnakan, ti sa kuū yɨvɨ ka iyo kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Va naa andɨvɨ jiin ñuyɨvɨ, ko jnuꞌun kaꞌan ri, jankɨvɨ naa kuɨtɨ, chi taka un kuu ndaa. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Koto maa ra naa ra ja tu kinikava ra nuu kuachi nava ka ndoꞌo ini ra, ja najini ra jiin ndɨxɨ, xi ɨnga jniñu kueꞌe, xi ja kujneñu ra nduku ra ja kuchaku ra, nava tu kinaa ri roꞌo naa ra kɨvɨ nchaa ri, nanu ɨɨn vekaa nu ni nandiꞌyu. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chi siaꞌan kii kɨvɨ un sɨkɨ taka yɨvɨ kanchuku nuu nɨɨ tuꞌu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yukan kuu ja nɨnɨ kotuꞌva ra naa ra, ti kondito ra ja na kakantaꞌu ra nava na ketaꞌu ra nuu taka nundoꞌo kii un. Nu siaꞌan na ti tu kukanuu ra kujiin ra nuu ruꞌu ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti na kɨvɨ un ni xnaꞌan Jesús nuu yɨvɨ nuu yuxeꞌe veñuꞌun kaꞌnu un ja kuu nduu, ti ja kuu jakuaa jaꞌan kendo ya undi yuku nani Olivos. ");
INSERT INTO mpmNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ti ñaꞌan ka jakoyo yɨvɨ kuaꞌa ja na kunsoꞌo i jnuꞌun kaꞌan ya ini veñuꞌun kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yukan ti kuan kuyajni ndaa viko ja ka yee da staa stila ja tu yɨꞌɨ levadura, ja suni ka kaꞌan da viko pascua. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti sutu ka kuñaꞌnu jiin chaa ka xnaꞌan ley Israel un, ka ndajnuꞌun da ja nasa kuu ti kaꞌni da Jesús. Ko ka yuꞌu da sa kuvaa yɨvɨ sɨkɨ da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yukan ti Judas, ja suni nani da, chaa ñuu Cariote, ni kɨvɨ jaꞌuꞌu un ini da, ti ni ndoꞌo ini da ja nakuaꞌa da Jesús nuu sutu ka kuñaꞌnu un. Ti maa da suni kuu da ɨɨn jnaꞌan nuu ndɨ uxi uu apóstol un nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ti chaa jaꞌa ni jaꞌan da nuu sutu ka kuñaꞌnu un jiin suni nuu chaa ka yɨndaꞌa veñuꞌun kaꞌnu un, ti ni ndajnuꞌun Judas jiin da naa da ja nasa nakuaꞌa da Jesús ndaꞌa chaa un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ti ni ka kusɨɨ xaan ini da jiin jnuꞌun ni kaꞌan Judas, ti ni kachi da ja kuaꞌa da xuꞌun nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ti Judas ni jantaꞌu da nava ni ka kachi chaa un. Ti ni kejaꞌa nduku da nasa kuu nakuaꞌa da Jesús nuu chaa un naa da, ɨɨn hora ja tu kaa ga naa yɨvɨ iyo. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yukan ti ni jaa kɨvɨ viko ja ka yee da staa stila ja tu yɨꞌɨ levadura. Ti suni kɨvɨ yukan ka jaꞌni da ɨɨn lelu ja ka soko da nuu Yandios ja kuu viko pascua un. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yukan ti ni taji Jesús Pedro jiin Juan, ti ni kachi ya jiin da naa da: ―Kuankoyo ti satuꞌva ra ja kuxini yo vijna viko pascua naa yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ti ni ka jikajnuꞌun da: ―¿Nanu kuni ni ja kinkoyo na satuꞌva na naa na nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ti ni kachi ya: ―Nuu na jaa ra ñuu un, ti yukan ndejnaꞌan ra jiin ɨɨn chaa ndiso ɨɨn kɨyɨ nducha. Kundikun ra da undi na najaa da veꞌe da, ");
INSERT INTO mpmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ti kachi ra jiin chaa xiin veꞌe un naa ra: “Kachi Maestro na: ¿Nanu kande ɨɨn veꞌe nuu satuꞌva ri ja kuxini ri jiin ndajaꞌa ri vijna viko pascua”? kachi ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yukan na ti kin xnaꞌan da roꞌo ɨɨn veꞌe kaꞌnu ja kaxndee nuu sukun un, ti ja iyo nakoo, ti yukan satuꞌva ra naa ra ja kuxini yo ―ni kachi Jesús jiin Pedro jiin Juan. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti kuankoyo da naa da undi ñuu nava ni kachi Jesús, ti ni ka naniꞌin da veꞌe ni kachi ya un. Ti yukan ni ka satuꞌva da ja kuxini da naa da ja kuu viko pascua. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nu ni kuu hora ja kuxini, ti ni jaa Jesús jiin uu ga ndajaꞌa ya, ti nɨ kanchuku da nuu mesa ka yee da staa. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yukan ti ni kachi Jesús jiin da naa da: ―Xaan ga ñukuu ini ri ja xnakan kuxini ri jiin ra naa ra, vijna kɨvɨ viko pascua, ti sa na kuū ri. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chi na kachi ndaa ri nuu ra naa ra ja tukaa ga kunchuku yo siaꞌan kuxini yo undi na kundaa kɨvɨ ja niꞌin ri jniñu ñaꞌnu ga ja kuaꞌa Tata ri Yandios nuu ri, ja na taꞌu ri jniñu jiin maa ya nuu tendɨꞌɨ nɨtuꞌu ja iyo. Undi yukan ti sa na kuxini tuku yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yukan sa ni kiꞌin Jesús ɨɨn vasu vino, ni nakuantaꞌu ya nuu Yandios, ti ni kachi ya: ―Koꞌo tɨꞌlɨ tɨꞌlɨ naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chi jandaa na kachi ri ja tukaa ga koꞌo ri nu ka saꞌa jnaꞌan yo viko jaꞌa, undi na jaa kɨvɨ ti nasaꞌa yo ñuu nuu niꞌin ri jniñu ñaꞌnu ga nuu Tata ri Yandios, ti taꞌu ri jniñu jiin maa ya nuu nɨ tuꞌu ja iyo. Ti nu kunchuku jnaꞌan yo ñuu un, yukan na ti sa nasaꞌa jaa yo viko jaꞌa ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ti suni ni kiꞌin ya ɨɨn staa stila, ti ni nakuantaꞌu ya nuu Yandios. Yukan na ti ni sakuachi ya, ti ni tejnaꞌan ya nuu da naa da ja na kee da, ti ni kachi ya: ―Jaꞌa kuu nanu yɨkɨ kuñu ri ja soko ri, ja na chunaa ri nuu kuachi ra naa ra. Ti nɨnɨ saꞌa ra siaꞌan naa ra ja ka nukuꞌun ini ra ruꞌu ja ni jiꞌi ri ja kuu nuu maa ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yukan ti nu ni ndɨꞌɨ ni ka kuxini da ti ni kiꞌin ya vasu vino un, ti ni kachi ya: ―Ja ñuꞌun vaso jaꞌa kuu nanu nɨñɨ ri ja soko ri. Ti stuu ndijin nɨñɨ ri ɨɨn jnuꞌun jáá ni kachi Tata ri. Ti jnuꞌun un kaꞌan ndaa kuɨtɨ ja nama ya kuaꞌa yɨvɨ, chi katɨ ri nɨñɨ ri ja chunaa ri nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ko vijna ti chaa ja kin nukuaꞌa ruꞌu nuu chaa ka jito uꞌu ruꞌu un, kaxndee ndaꞌa da jiin ndaꞌa ri nuu mesa jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chi ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, siuku ndaa ri nava ni kachi maa Yandios, ko xaan ga ndaꞌu chaa nakuaꞌa ruꞌu nuu chaa ka jito uꞌu ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yukan ti ni kejaꞌa ka jikajnuꞌun jnaꞌan da naa da nau ɨɨn da kuu ja nakuaꞌa ya nuu chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yukan na ti ndajaꞌa Jesús ni ka kejaꞌa ka ndajnuꞌun da na ndenu nau ɨɨn da kendo kuñaꞌnu ga. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti ni kachi Jesús jiin da naa da: ―Chaa ka kuu rey nuu taka ga nación, vanua maa da ka xiin nación un, ti ja yukan kuu ja nde kuaꞌan ga da jiin yɨvɨ nación da. Ti jaa siaꞌan xaan ini da, ti ka saꞌa yɨvɨ ja nakuaꞌa i ja yɨñuꞌun nuu chaa kuñaꞌnu un, nava na kuu vaꞌa ini da nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ko roꞌo naa ra, tu saꞌa ra siaꞌan, chi nuu nau ja kuñaꞌnu ga nuu ra naa ra, suꞌva na kuanukuachi da nanu ja tu ndiso jniñu da, chi nau ja taꞌu jniñu, suni na kuanukuachi. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Xi nau kuu ja kuñaꞌnu ga nu? ¿Ja nukoo nuu mesa xi ja kunukuachi nuu mesa un nu? ¿Xi ansu jandaa kuu ja kuñaꞌnu ga chaa nukoo mesa un nu? Ko ruꞌu chi kancha ri jiin ra naa ra nanu ɨɨn chaa junukuachi ni. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ti roꞌo naa ra, nɨnɨ kaꞌiin ra jiin ri taka kɨvɨ ja jito ri nundoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ti ja yukan kuu ja na kuaꞌa ri ja kuu taꞌu ra naa ra. Nu na niꞌin ri ɨɨn jniñu ñaꞌnu ga nuu Tata ri Yandios ja na taꞌu ri jniñu jiin maa ya nuu tendɨꞌɨ nɨtuꞌu ja iyo, ti suni kuaꞌa ri jniñu ñaꞌnu nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kundiso ra ɨɨn jniñu ja na nukoo ra naa ra ɨɨn ɨɨn silla kanuu ga, ti xndichi ra ndɨ uxi uu familia jnaꞌan yo ja ka kuu i yɨvɨ nación Israel. Yukan kuu jniñu ñaꞌnu niꞌin ra, ti suni yukan kaji koꞌo ra jiin ri nuu mesa ñuu nuu taꞌu ri jniñu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Suni ni kachi Jitoꞌyo Jesús jiin Simón: ―Simón, Simón, na kachi ri nuu ra ja sɨkɨ jaꞌuꞌu un, chi ni jikan ja kotojnuni taka roꞌo ja ka kuu ndajaꞌa ri. Ja sɨkɨ nundoꞌo kii un, kuni jaꞌuꞌu uu siuꞌu roꞌo ti kɨsɨ roꞌo naa ra nanu saꞌa yo jiin triu. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ko maa ri ja ni jikantaꞌu ri jaꞌa ra nuu Yandios nava tu nukoyo ra nuu kuachi, ti kachi ra ja tukaa ka kandixia ra ruꞌu. Ko nu na kachi ra ja tu kandixia ndaa ra ruꞌu kɨvɨ chaa nundoꞌo un, ko nu yukan ti nakani tuku ini ra nuu kuachi un, ti kuankaꞌnu ini Yandios nuu ra, Simón. Yukan na ti chindee ñanijnaꞌan ra ti kuaꞌa ra jnundee ini da, nava na siin nɨ ini da ti na kandixia ndaa da ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yukan na ti ni kachi Simón: ―Jitoꞌyo, ja iyo tuꞌva na ja kondoꞌo na jiin ni undi vekaa vasu na kuū na jiin ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ti ni kachi Jesús jiin da: ―Pedro, jandaa na kachi ri ja vijna, ti kana ga liꞌi, ti ja chisaꞌyɨ ra ruꞌu uni jinu, ja kachi ra ja tu jini ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yukan ti ni jikajnuꞌun Jesús nuu tendɨꞌɨ ndajaꞌa ya un: ―Na ni taji ri roꞌo ni ka jaꞌan ra naa ra ja ni kaꞌan ra jnuꞌun Yandios, ti tu ni ka yɨndaꞌa ra bolsa, ni xuꞌun, ni ndijña, ¿xi nau ja ni kumani nuu ra naa ra nusa? ―ni kachi ya. Ti ni ka kachi da: ―Tu kuɨtɨ ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yukan na ti ni kachi ya jiin da naa da: ―Ko vijna ti na kachi ri, nu nau ja ka ñavaꞌa bolsa, ti na kundaꞌa kiꞌin jiin. Xi nu ñavaꞌa ra xuꞌun ti kundaꞌa ra. Ko nu nau chaa tu ñavaꞌa espada ja koto da maa da, ti na xiko da tɨkachi da ti na kuan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chi na kachi ri ja kundaa jiin ri nava yoso nuu tutu ja siaꞌan kondoꞌo ri: “Saꞌa yɨvɨ jiin ri nanu ka saꞌa i jiin ɨɨn chaa ndevaꞌa ja tu ka jandatu da nuu ley.” Chi taka ja yoso nuu tutu sɨkɨ ri, vijna ti kundaa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yukan ti ni ka kachi da: ―Jitoꞌyo, ko jaꞌa iyo uu espada ―ni ka kachi da. Ti ni kachi Jesús: ―Sia ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yukan na ti kuaꞌan Jesús undi chii yuku Olivos nava saꞌa maa ya, ti ni ka ndikun ndajaꞌa ya kuankoyo da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ti nu ni ka jakoyo da chii yuku un, ti ni kachi ya jiin da: ―Kakantaꞌu naa ra jaꞌa nava tu kaña ini añu ra ja saꞌa ra ɨɨn jniñu kueꞌe ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yukan ti ni jika ya tɨꞌlɨ ga kuaꞌan ya, kuꞌva jika skiꞌin yo ɨɨn yuu, ti yukan ni jakunjitɨ ya, ja kakantaꞌu ya nuu Yandios, ");
INSERT INTO mpmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ti ni kachi ya: ―Tata na Yandios, nu kuni ni ti chajiyo ni nundoꞌo kii sɨkɨ na un, ti nama ni saña, ko ansu nava kuni maa na, chi na kuu nava kuni maa ni ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ti yukan ni ndenda ɨɨn ángel Yandios ja ni kii nuu andɨvɨ, ti ni jaꞌa ángel un jnundee ini ya ja na siuku ya taka nundoꞌo un. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ti ja xaan kukuiꞌya ini ya, ti viꞌi ga ni kejaꞌa jikantaꞌu ya jiin nɨɨ ini da, ti kejaꞌa kaña kaꞌni nuu ya, ti kejaꞌa too nuu ñuꞌun un, nanu naꞌnu yuyu nɨñɨ too nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu ni ndɨꞌɨ ni jikantaꞌu ya, ni nandeokuñɨ ya nuu kaꞌiin ndajaꞌa ya. Ti ni jini ya ja ka kixi da, chi jiin jnukuiꞌya ini un tukaa ga ni ka kundee da kakantaꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yukan na ti ni kachi ya: ―¿Ndo xaan ka kixi ra naa ra? Ndoko ti kakantaꞌu ra nava tu kotojnuni jaꞌuꞌu un roꞌo, kachi ra ja tu ka jini ra ruꞌu, ti chisaꞌyɨ ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ti ni kaꞌan ga ya siaꞌan, ja ni ka kenda kuaꞌa xaan yɨvɨ kuajakoyo nuu ya. Ti chaa nani Judas, ja suni ni kuu da ɨɨn ndajaꞌa nuu Jesús, yoxnuu da vaji da nuu chaa un naa da. Ti ni tuꞌva da nuu Jesús, ti ni teyuꞌu da nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ti kachi ya jiin da: ―Judas, ¿xi ja so teyuꞌu ra nuu ri ti kinaa ra ruꞌu, ti siaꞌan nakuaꞌa ra maa Seꞌe Yɨvɨ Ñuyɨvɨ nuu yɨvɨ ka saꞌa ndevaꞌa nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ti nu ni ka jini chaa kaꞌiin jiin Jesús ja siaꞌan kuu, ti ni ka jikajnuꞌun da: ―Jitoꞌyo, ¿kiꞌin na sɨkɨ yɨvɨ jaꞌa jiin espada nu? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ti ɨɨn chaa kaꞌiin jiin Jesús ni stuji da soꞌo ɨɨn muzu sutu kuñaꞌnu un, ti ni jaꞌncha da soꞌo da soꞌo kuaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ko ni kachi Jesús: ―Sia da naa ra, chi ja ni kuu siaꞌan ni ―ni kachi ya. Yukan ti ni kueꞌe Jesús soꞌo chaa un, ti ni nduvaꞌa ni da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yukan na ti ni kachi ya jiin sutu ka kuñaꞌnu un, jiin chaa ka yɨndaꞌa veñuꞌun kaꞌnu un, jiin nuu taka chaa ka kuñaꞌnu nación Israel ja vekoyo da ja kiꞌin da jiin ya, ti ni kachi ya: ―¿Va nu ɨɨn chaa kuiꞌna kuu ri, xi ni ndonda ri sɨkɨ gobiernu nu? ¿Xi ndoo kuu ja vekoyo ra jiin espada jiin yujnu ja jnɨɨ ra ruꞌu naa ra? ");
INSERT INTO mpmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ti taka kɨvɨ ni kuncha ri jiin ra naa ra ini veñuꞌun kaꞌnu un, ko ni tu ni ka jnɨɨ ra presu ruꞌu. Ti kɨvɨ vijna vekoyo ra naa ra, chi ka ndoꞌo ndevaꞌa kuɨtɨ ini ra sɨkɨ ri. Ti vijna kuu ja na siuku ra naa ra, chi nuu ñuñaa ka saꞌa ra nava kuu ini maa ra na ra. Chi jniñu jaꞌa kuu ja ndiso jaꞌuꞌu un ja yɨndaꞌa ñuñaa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ni ka jnɨɨ da presu Jesús ti kuankoyo da jiin ya undi veꞌe sutu kuñaꞌnu un, ti Pedro jika jika ni, ni ndikun da jata yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ti sava yuxeꞌe chaa un ni ka xnaꞌan policia un ɨɨn ñuꞌun, ti ni ka nakuiconduu da kanchuku da yunuꞌun un ka nduxin da. Ti suni ni nukoo Pedro maꞌñu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ti ɨɨn ñaꞌan junukuachi veꞌe un ni jini ña nukoo Pedro yuñuꞌun un. Ni ndeꞌe vaꞌa ña nuu da, ti ni kachi ña: ―Suni kande chaa jaꞌa jiin chaa ni ka jnɨɨ da un niku ―kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ko ni chisaꞌyɨ Pedro ja tu jini da Jesús, ti ni kachi da: ―Tu jini kuɨtɨ ri chaa yukan ―ni kachi da jiin ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ni kunuu ga, ti ni jini ɨnga chaa un nuu Pedro, ti ni kachi: ―Roꞌo, suni kuu ra jnaꞌan chaa un ―ni kachi da. Ko ni kachi Pedro: ―Ansu kuu ri, vasu na kajnuꞌun ndaa ra ruꞌu ―kachi da jiin chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ni kuyajni ɨɨn hora, ti ni kachi tuku ɨnga da: ―Ndixia ra naa ra, ja suni ni kunde chaa jaꞌa jiin chaa un, chi suni chaa ñuu Galilea kuu da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yukan sa ni kachi Pedro jiin chaa un: ―Tu jini kuɨtɨ ri naa jnuꞌun kaꞌan ra jiin ri ―kachi da. Ti hora un, nɨ kaꞌan ga da siaꞌan, ti ni kana ɨɨn liꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yukan ti ni ndeokoto Jitoꞌyo Jesús, ti ni ndeꞌe ya nuu Pedro. Ti Pedro ni nukuꞌun ini da nava ni kachi Jitoꞌyo Jesús jiin da: “Ja nu ti kana ga liꞌi, ti kachi ra uni jinu ja tu jini ra ruꞌu.” ");
INSERT INTO mpmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yukan na ti ni kenda da kuaꞌan da, ti ni ndeꞌe xaan tonto da ja ni nakani ini da. Ti ni kukuiꞌya xaan ini da ja ni kachi da ja tu jini da ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ti taka chaa ka ndito Jesús, ni ka ku ichi ini da nuu ya, ti ni ka kani da ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ni ka jasɨ da nduchi ya, ti ni ka kani da jikɨ nuu ya, ti kachi da jiin ya: ―Kachi nau ja ni kani roꞌo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ti kuaꞌa ga jnuꞌun ndevaꞌa ni ka kaꞌan da nuu ya, ja ka skuɨtɨ da ini ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nu ni kundijin ɨnga kɨvɨ, ti ni ka ndututu taka chaa ñaꞌnu nación Israel, jiin taka sutu ka kuñaꞌnu un, jiin taka chaa ka xnaꞌan ley Israel un. Ti ka yɨndaꞌa policia un Jesús nuu ni ka ndututu chaa ka kuñaꞌnu un, ti yukan ni ka jikajnuꞌun da ya: ");
INSERT INTO mpmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Kachi ndaa nuu maa ra kuu Cristo ja vaji nuu Yandios ―ni ka kachi da. Ti ni kachi ya: ―Nu na kachi ri ja maa ri kuu, ni tu kandixia ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ti nu kajnuꞌun ri roꞌo naa ra ja nasa ka ndoꞌo ini ra sɨkɨ ri, va ni tu kachi kuɨtɨ ra, ti ni tu sia ra ruꞌu naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko vijna na kachi ndaa ri ja ruꞌu, maa seꞌe Yɨvɨ Ñuyɨvɨ, kinoꞌon ri nuu andɨvɨ ti yukan nukoo ri ndaꞌa kuaꞌa Yandios, ja na taꞌu ri jniñu jiin ya nuu tendɨꞌɨ nɨtuꞌu ja iyo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yukan na ti tendɨꞌɨ yɨvɨ un ni ka jikajnuꞌun maa ya: ―¿Nusa, ti maa ra kuu Seꞌe Yandios nu? ―kachi naa. Ti ni kachi Jesús: ―Maa ri kuu nava ni ka kachi ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yukan na ti ni ka kachi da: ―¿Nanu nandɨꞌɨ ga yo ɨnga testigo? Ti ja ni ka jinisoꞌo yo jnuꞌun ni kaꞌan da jiin ndusu yuꞌu maa da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yukan na ti ni ka ndokuɨñɨ yɨvɨ un ti kuankoyo jiin Jesús nuu Pilato, chaa kuu gobernador. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ti yukan ni ka kejaꞌa yɨvɨ ka kankuachi sɨkɨ ya, ti kachi naa: ―Ni ka jnɨɨ na chaa jaꞌa chi skaꞌan da yɨvɨ ja na ndonda i sɨkɨ taka chaa ka kuñaꞌnu. Ti kachi da ja tu chaꞌu yo puestu nuu gobiernu romano, ti suni kaꞌan da ja maa da kuu Cristo, ja kuu rey ja ni taji Yandios ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yukan na ti ni jikajnuꞌun Pilato maa ya: ―¿Maa ra kuu rey nuu yɨvɨ nación Israel nu? ―kachi da. Ti ni kachi Jesús: ―Maa ri kuu, nava ni kachi ra ―kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yukan ti ni kachi Pilato nuu sutu ka kuñaꞌnu un jiin nuu taka yɨvɨ un: ―Tu ni ɨɨn kuachi niꞌin ri sɨkɨ chaa jaꞌa―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko viꞌi ga ni ka kaꞌan yɨvɨ un: ―Ja ni skaꞌan da taka yɨvɨ ñuu Judea ja na ndonda i jiin jnuꞌun xnaꞌan da un. Ni kejaꞌa da jiin jnuꞌun un undi ñuu Galilea, ti vijna ni chaa da undi nuu kanchuku yo jaꞌa―kachi i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu ni jinisoꞌo Pilato jnuꞌun un, ti ni jikajnuꞌun da nuu yɨvɨ un ja nu Jesús kuu ya chaa ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nu ni ka kachi yɨvɨ un ja suu kuu ya, ti ni taji da ya kuaꞌan ya nuu Herodes, chaa ni kuu gobernador ñuu Galilea, ja suni kande da ñuu Jerusalén kɨvɨ yukan. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ti nu ni jini Herodes nuu Jesús, ni kusɨɨ xaan ini da, chi ja ni kuu naꞌan ndoꞌo ini da ja kuni da nuu ya. Chi ni jinisoꞌo da ka jani yɨvɨ jnuꞌun sɨkɨ ya, ti kuni da ja na saꞌa ya ɨɨn jniñu ñaꞌnu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kuaꞌa xaan jnuꞌun ni jikajnuꞌun da Jesús, ko tu ni nachiso kuɨtɨ ya ni ɨɨn jnuꞌun nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ti suni kaꞌiin taka sutu ka kuñaꞌnu un jiin chaa ka xnaꞌan ley Israel un, ja niꞌin xaan ka jikan kuachi da jaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yukan ti Herodes jiin soldado da, ni ka ku jaꞌa ini da nuu ya, ti ni ka yɨsɨkɨnchaa da ya. Ni ka naskuiꞌna da ya jiin ɨɨn saꞌma vaꞌa xaan, nanu ja kuu ya ɨɨn rey. Yukan ti ni nataji tuku Herodes Jesús nuu Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti undi kɨvɨ yukan sa ni ka ndumani jnaꞌan Pilato jiin Herodes, chi undi nuu ni ka jito uꞌu jnaꞌan da naa da niku. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yukan na ti ni nastutu Pilato taka sutu ka kuñaꞌnu un, jiin chaa ka ndiso jniñu ñaꞌnu nuu nación Israel, jiin yɨvɨ ñuu un, ");
INSERT INTO mpmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ti ni kachi da: ―Ni ka chakoyo ra jiin chaa jaꞌa nuu ri. Ti ka kaꞌan ra ja skaꞌan da yɨvɨ. Ko ndeꞌe ra naa ra ja ni jikajnuꞌun ri da, ti tu niꞌin ri ni ɨɨn kuachi sɨkɨ da nava ka chakuachi ra jaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Suni Herodes tu ni niꞌin da ni ɨɨn kuachi sɨkɨ chaa jaꞌa. Ja yukan kuu ja ni nakuaꞌa tuku da chaa jaꞌa nuu yo. Ja ka jini ra naa ra ja tu ni saꞌa da ni ɨɨn kuachi ja kuū da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na taꞌu ri jniñu nuu soldado ja na kuaꞌa da tau chaa jaꞌa, ti sa na sia ri da kiꞌin da ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ti iyo jnuꞌun ja taka viko pascua sia Pilato ɨɨn presu, nau ja na kachi yɨvɨ ja sia da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko tendɨꞌɨ yɨvɨ un ni ka kejaꞌa ka kanakoꞌo: ―¡Na kendo chaa jña na kuū da! ¡Sia Barrabás! ―kachi yɨvɨ un naa. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti kande Barrabás vekaa sɨkɨ, ja ni ndonda da sɨkɨ gobierno ja ni ka kanaa da ñuu un, ti ni jaꞌni da ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ko Pilato, kuni sia da Jesús, ti ni kachi tuku da jiin yɨvɨ un ja na xndaku da nuu i ja na sia da Jesús, chi Barrabás iyo xaan kuachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko yɨvɨ un viꞌi ga ni ka kanajiin koꞌo: ―¡Katakaa ni chaa jña ndaꞌa cruz! ¡Katakaa ni chaa jña ndaꞌa cruz, na kuū da! ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ko jinu ku uni ni kachi tuku Pilato jiin yɨvɨ un: ―¿Ko naa kuachi ni saꞌa da nusa? Ja ruꞌu tu nau ni ɨɨn kuachi niꞌin ri sɨkɨ da ja jiin kuachi un na kuū da. Na taꞌu ri jniñu ja na ndoꞌo da ti sa na sia ri da na kiꞌin da ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ko yɨvɨ un ni ka siin ka kanakoꞌo, ja ka jikankuachi ja na katakaa da Jesús nuu ndaꞌa cruz. Ti ni ka siin da ka kanakoꞌo da jiin chaa ka kuñaꞌnu un, undi ni ka kundee da ja ni kuu nava ka kuni da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yukan ti ni jaꞌa Pilato jnuꞌun ja na kuu nava ka kuni da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ti ni sia da chaa ni ka jikan yɨvɨ un nuu da, chaa kande vekaa ja ni ndonda da sɨkɨ gobierno, jiin ja ni jaꞌni da ndɨyɨ. Ti ni nakuaꞌa Pilato Jesús nuu yɨvɨ un, ja na saꞌa i nava ka kuu ini maa i jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ichi nuu kuankoyo da jiin Jesús ja katakaa da ya, ni ka ndejnaꞌan da jiin ɨɨn chaa ñuu Cirene nani Simón, ja vendi da ni jaꞌan da ranchu da. Ti ni ka chayɨka da chaa un ja na kundiso da cruz Jesús, ti na kundandikun da jata ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yukan kuankoyo yɨvɨ kuaꞌa. Ti suni kuankoyo kuaꞌa ñasɨꞌɨ ja ka kanajiin koꞌo ña, ka ndeꞌe ña, ja ka kundaꞌu xaan ini ña ja kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ko ni nandeokoto Jesús nuu ña naa ña, ti ni kachi ya: ―Roꞌo, ñaꞌan Jerusalén naa ra, tu ndeꞌe ra jaꞌa ri. Ndeꞌe naa ra ja kuu jaꞌa maa ra jiin seꞌe ra, ");
INSERT INTO mpmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","chi kiji kɨvɨ ja koo nundoꞌo xaan sɨkɨ ra, ti kachi ra naa ra: “Xaan ga ndatu ñaꞌan tu seꞌe, ja tu ni ka ñuꞌun seꞌe ña, ja tu ni ka nchaka ña suchi yɨkɨn ja kaxin i jika ña.” ");
INSERT INTO mpmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti kɨvɨ un kachi yɨvɨ naa i: “Vaꞌa ga ja na nduva yuku jaꞌa sɨkɨ ri naa ri, ti na kuū ri.” Ti kachi i jiin yuku un: “Vaꞌa ga ja chisaꞌyɨ ruꞌu naa ri”, kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chi na kachi ndaa ri nuu ra ja yɨvɨ jaꞌa, ja ka saꞌa ndevaꞌa i siaꞌan jiin ri, ka saꞌa i nanu ja ka jaꞌma i yujnu yɨꞌɨ ja tu kuni kayu, chi tu chaku vaꞌa ini i ndoo ka saꞌa i jiin ri. Ti yɨvɨ ka saꞌa ndevaꞌa siaꞌan jiin ri vijna, ti ja kuu kɨvɨ un kii ɨɨn nundoꞌo xaan ga sɨkɨ i. Ti yachi kii nundoꞌo un sɨkɨ i nanu ja nu kaꞌma yo ɨɨn yujnu ichi ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Suni ka yɨndaꞌa da uu chaa ni ka jaꞌni ndɨyɨ, ja na kuu da naa da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ti nu ni ka jakoyo da ɨɨn ñuꞌun ja nani “yɨkɨ xini”, ti yukan ni ka jatakaa da ya nda cruz jiin ndɨnduu chaa ni ka jaꞌni ndɨyɨ un, ɨɨn da ichi ndaꞌa kuaꞌa ya, ti ɨnga da ichi ndaꞌa sajni ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti hora ka chijnɨɨ da ya nuu ndaꞌa cruz, ti ni kachi ya: ―Tata na Yandios, kuankaꞌnu ini ni nuu yɨvɨ jaꞌa, chi tu ka jini i ndoo ka saꞌa i ―ni kachi ya. Ti soldado un ni ka chuꞌun da suerte sɨkɨ saꞌma Jesús, ja na tejnaꞌan nuu jnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yɨvɨ kaꞌiin un ka ndeꞌe vaꞌa nuu ya, ti undi chaa ka ndiso jniñu ñaꞌnu un, suni ni ka ske ichi ini da nuu ya, ti ka kaꞌan da: ―Ni nama da sava yɨvɨ, ko vijna na ti na nama da maa da nu jandaa ndixia kuu ja maa da kuu Cristo, ja ni nakaji Yandios ja kii ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ti suni undi soldado un ni ka kuu ichi ini da nuu ya. Ni ka tuꞌva da, ti ni ka jaꞌa da vino iya ja na koꞌo ya, ");
INSERT INTO mpmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ti ni ka kachi da jiin ya: ―Nu ndixia ra ja maa ra kuu rey nuu nación Israel, ti nama maa ra vijna ñuꞌni ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ti xini cruz ya yukan ni ka teña da ɨɨn tutu ja yoso jiin letra griego, jiin latín, jiin hebreo, ja kachi siaꞌan: “Chaa jaꞌa kuu Rey nuu yɨvɨ nación Israel.” ");
INSERT INTO mpmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ti ɨɨn chaa yɨndaka ndaꞌa cruz un ni kaꞌan ndevaꞌa da nuu ya, ti kachi da: ―Nu maa ra kuu Cristo, nama maa ra vijna, ti nama ruꞌu naa ri ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ko ɨnga chaa yɨndaka jiin da un, ni nduxaan da nuu da, ti ni kachi da: ―Ja tu yuꞌu ra ndeꞌe ra Yandios. ¿Xi tu jini ra ja kunchakuachi ga yo nuu ya nu? Ti ɨɨn ni ja ka ndoꞌo yo naa yo. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Maa yo chi vatu ni ka ndoꞌo yo, chi jaꞌa niꞌin yo sɨkɨ ja ni ka saꞌa ndevaꞌa yo. Ko chaa jaꞌa, tu na ɨɨn kuachi ni saꞌa da ja kondoꞌo da jiin yo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yukan ti ni kachi da jiin Jesús: ―Jesús, nukuꞌun ini ni saña kɨvɨ na kejaꞌa taꞌu ni jniñu ñaꞌnu nuu nɨ tuꞌu ja iyo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti ni kachi Jesús jiin da: ―Jandaa na kachi ri jiin ra ja undi vijna ti ndii ra jiin ri andɨvɨ, nuu vii xaan kaa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nu ni kuu sava nduu, ni kuñaa nɨ kaꞌnu ñuyɨvɨ, ti ni ndundijin undi ka uni jaꞌini. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ti ni kuñaa nuu ndikandii. Ti undi saꞌma yɨndaka ini veñuꞌun kaꞌnu Israel un, ni ndata sava kuɨtɨ undi nuu sukun ti undi nuu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yukan ti ni kanajiin Jesús: ―Tata na Yandios, na kiꞌin ni añu na vijna ―ni kachi ya. Siaꞌan ni kaꞌan ya, ti ni jiꞌi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nu ni jini chaa kuu capitán romano un ja siaꞌan ni kuu, ti ni kaꞌan da ja kuñaꞌnu xaan Yandios, ti ni kachi da: ―Jandaa kuɨtɨ kuu ja tu ni iyo ni ɨɨn kuachi chaa jaꞌa―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tendɨꞌɨ yɨvɨ kaꞌiin un, ni ka jini ja siaꞌan ni kuu. Ti ichi kuankoyo i, ka kani i jikɨ jika i, chi ni ka yuꞌu i ja siaꞌan ni ka janhan i un. Ni ka kuu kuiꞌya ini i ja ka naꞌnu i ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ko taka yɨvɨ ja ni ka jini jnaꞌan jiin ya, kaꞌiin yɨ un jiin suni taka ñasɨꞌɨ ja vekoyo ña jiin ya undi ñuu Galilea. Ni ka kendo jika ña ka ndeꞌe ña taka ja ni kuu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ni iyo ɨɨn chaa vaꞌa, ja ni jika ndaa da, nani da José, ni kuu da chaa ñuu Arimatea, ja kuu ɨɨn ndañuu Judea. Yɨꞌɨ da nuu junta kuñaꞌnu nación Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ti ni kandixia chaa un jnuꞌun ni xnaꞌan Jesús, ja kuu kɨvɨ yɨvɨ ndaꞌa Yandios ja na taꞌu ya jniñu nuu i, yukan ti niꞌin yɨvɨ un ɨɨn taꞌu ñuu ya ja kundiso i jniñu jiin ya. Ti maa da tu ni kejnaꞌan da jiin chaa ni ka ndututu nuu junta un ja ni ka kachi da ja na kuū Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja yukan kuu ja ni jaꞌan da nuu Pilato, ti ni jikan da yɨkɨ kuñu Jesús ja na chunduji da. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nu ni kuniꞌin da yɨkɨ kuñu Jesús nuu ndaꞌa cruz un, ti ni nasuku da ya jiin ɨɨn saꞌma finu. Ti ni chunde da ya ini ɨɨn yau jaa, ja ni jacha maa da jika ɨɨn kava, ja ti jakunduji ga ni ɨɨn ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chi jaꞌini kɨvɨ yukan kejaꞌa kɨvɨ ka ndetatu yɨvɨ nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ti ñaꞌan ni ka kikoyo jiin Jesús undi ñuu Galilea, ni ka jaꞌan ña jiin José, ti ni ka jini ña nuu ni chunde da ya, ti ni ka jini vaꞌa ña nava ni ka skatuu da yɨkɨ kuñu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ti nu ni ka nandeokuñɨ ña veꞌe ña, ti ni ka satuꞌva ña perfume, jiin ɨɨn nuu pomada ja na kin chiꞌi ña sɨkɨ yɨkɨ kuñu Jesús. Yukan ti ni ka chiñuꞌun ña kɨvɨ ndetatu un nava iyo ley Moisés. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ñaꞌan xaan kɨvɨ domingo ni ka jaꞌan ñaꞌan yukan nuu ñunduji Jesús, ti ka yɨndaꞌa ña perfume ja ni ka satuꞌva ña. Ti suni kuankoyo tɨjnɨ ga ñasɨꞌɨ jiin ña naa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ti nu ni jakoyo ña, ti ni ka jini ña ja, ja ni kuxio yuu ndiꞌyu yuꞌu ñaña un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ni ka kɨvɨ ña, ko tukaa ga ni ka naniꞌin ya yɨkɨ kuñu Jitoꞌyo Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ni ka ndoꞌo kueꞌe ini ña ja ni ka jini ña ja tukaa ga yɨkɨ kuñu ya, ti tu ka kujnuni ini ña nasa saꞌa ña naa ña. Ti nɨ ka ndoꞌo ini ña siaꞌan, ti ni ka ndenda ni uu chaa ka ñuꞌun saꞌma xkɨyɨ niꞌni, ja janducha ii, ti kajiin da xiin ña naa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ni ka yuꞌu xaan ña, ti ni jakundandijin nuu ña undi nuu ñuꞌun, ti chaa un ni ka kachi da: ―¿Ndoo ka nanduku ra ɨɨn chaa chaku nu kaꞌiin ndɨyɨ jaꞌa? ");
INSERT INTO mpmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tu kande ya jaꞌa chi ja ni nandoto ya. Nukuꞌun ini naa ra nasa ni kachi ya nuu ra na ni kunde ga ya ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Chi ni kachi ya: “Ruꞌu, maa Seꞌe Yɨvɨ Ñuyɨvɨ, nakuaꞌa yɨvɨ ruꞌu nuu yɨvɨ ndevaꞌa kuɨtɨ, ti kin katakaa da ruꞌu nuu ndaꞌa cruz, ko nu uni kɨvɨ, ti nandoto tuku ri”, ni kachi ya ―ni ka kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ti ni ka nukuꞌun ini ña nava ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti ni ka kee ña nuu ni ñunduji ya, ti kuanukoyo ña, ni ka jani ña jnuꞌun nuu ndɨ uxi ɨɨn chaa ni ka kuu ndajaꞌa ya, jiin nuu taka ga yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ti ñaꞌan ni ka jani jnuꞌun nuu ndajaꞌa ya un, ni ka kuu María ñaa ñuu Magdala, jiin Juana, jiin María ñaꞌan kuu nana Jacobo, jiin tɨjnɨ ga ñasɨꞌɨ un naa ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ko ndajaꞌa ya un ni ka jani ini da ja ni ka nduloco xini ña, ti tu ni ka kandixia da jnuꞌun ni ka kaꞌan ña. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ti vasu tu ka kandixia da naa da, ko Pedro ni jaꞌa da corrɨ kuan ndeꞌe da nuu ñaña un. Ni jaa da ti ni ndeꞌe da ini yau un, ti ni jini da ja mani ga saꞌma manta un kanchuku. Yukan ti kuanoꞌon da veꞌe da, ko so ni naa ini da ja siaꞌan ni kuu un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti uu chaa un ni ka kee da suni kɨvɨ yukan, ti kuankoyo da ɨɨn ñuu nani Emaús ja kendo uxi ɨɨn kilometro jiin Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ti ichi kuankoyo da, ka ndajnuꞌun da sɨkɨ taka ja ni kuu kɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti nɨ ka ndajnuꞌun da, ti ka kaꞌan ka kaꞌan da kuankoyo da, ti ni tuꞌva maa Jesús kuaꞌan ya jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ti vasu kuaꞌan ya jiin da, ko tu ni ka nakuni kuɨtɨ da ja maa ya kuu, nanu ja so ni jasɨ ini da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ti maa Jesús ni jikajnuꞌun ya naa da: ―¿Naa jnuꞌun ka ndajnuꞌun ra ichi vekoyo ra jaꞌa? ¿Ti ndoo ka kukuiꞌya ini ra naa ra? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ti ɨɨn chaa nani Cleofas ni kachi da: ―Nɨ kaꞌnu yɨvɨ ñuu Jerusalén ka jini i taka ja ni kuu ñuu un. ¿Xi maa ɨɨn ni roꞌo kuu ja tu jini taka ja ni kuu un, vasu yukan kancha ra nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ti maa ya ni jikajnuꞌun: ―¿Ndoo ni kuu nusa? ―ni kachi ya. Ti ni ka kachi da: ―Nundoꞌo ni jnaꞌan Jesús, chaa ñuu Nazaret, ja ni kuu da profeta ni kaꞌan da jnuꞌun Yandios. Ndichi xaan ni kaꞌan da, ti ni saꞌa da taka jniñu ñaꞌnu ja vaji nuu Yandios. Nuu taka yɨvɨ ni ka jini. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko chaa ka kuu sutu ka kuñaꞌnu un jiin chaa ka ndiso jniñu ñaꞌnu un, ni ka nakuaꞌa da chaa ja na kuu da nuu nda cruz. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti ka ñukuu ini ri ja maa da kin nama yɨvɨ nación ri Israel nuu gobierno ñuu Roma. Ko vijna ja iyo uni kɨvɨ ja ni jiꞌi da ja sɨkɨ jniñu ni saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ti sava ñasɨꞌɨ ka jini jnaꞌan ri jiin, ni ka siuꞌu ña ruꞌu, chi jañaꞌan xaan vijna ni ka jaꞌan ña nuu ñaña un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ti ka jani ña jnuꞌun ja tukaa ga ni ka jini ña yɨkɨ kuñu da ini ñaña un. Ti ni ka nchakoyo ña ka jani ña jnuꞌun ja, ja ni ka jini ña uu ángel Yandios. Ti ángel un ni ka kachi da ja chaku Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yukan ti sava ñanijnaꞌan ri ni ka jandeꞌe nuu ñaña un, ti ni ka jini da ja jandaa ndixia kuu jnuꞌun ka kaꞌan ñaꞌan un, ko tukaa ga ni ka jini da nuu maa Jesús ―ni ka kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yukan ti ni kachi Jesús jiin da naa da: ―¡Chaa tu ka chaku ini ka kuu ra! Xaan ga uꞌu ti kandixia ra naa ra jnuꞌun ni ka kaꞌan profeta na janaꞌan, ja kaꞌan sɨkɨ Cristo, ja taji Yandios nava na saꞌa ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Va nu tu kanuu kondoꞌo Cristo taka nundoꞌo jaꞌa xnakan, ti sa kin noꞌon ya andɨvɨ ti nduñaꞌnu ya nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yukan na ti ni kejaꞌa xndaku ya taka jnuꞌun yoso nuu tutu Yandios, ja kaꞌan nasa kondoꞌo maa ya. Ni kejaꞌa xndaku ya nava kaꞌan nuu tutu Yandios ni chaa tutu Moisés, ti ni siin ya jiin tutu Yandios ni ka chaa profeta na janaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ti nu ni ka jakoyo da ñuu nuu kuankoyo da un, ti Jesús ni saꞌa ya ja siin ya ichi kiꞌin ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ti maa da naa da ni ka chayɨka da ya ja na kendo ya jiin da, ti ni ka kachi da: ―Kendo jiin ri jaꞌa na kendo yo naa yo, chi ja ni ini xaan, ti ja kuan kɨꞌvɨ ―ni ka kachi da. Yukan ti ni kɨvɨ Jesús ja kendo ya ni naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ti nu ni nukoo ya mesa jiin da ja kuxini da, ti ni kiꞌin ya ɨɨn staa stila, ni nakuantaꞌu ya nuu Yandios, ti ni tejnaꞌan ya nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ti ja siaꞌan ni saꞌa ya, sa ni ka nakuni da ya, ja maa Jesús kuu ya. Ko nu ni ka nakuni da ya, ti ni ndoñuꞌun ni ya kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ti ni ka kachi da: ―Jandaa ni kuu ja ka naꞌnu ini yo ya, ko nu ni ndakuniꞌin ya nava kaꞌan tutu Yandios sɨkɨ Cristo, na ichi vaji yo, ti ni ka ndusɨɨ xaan ini yo jiin jnuꞌun ni ndaku niꞌin ya nuu yo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yukan ti tukaa ni ka kendo da, chi ni ka nakiꞌin da ichi kuanukoyo da undi Jerusalén nuu kanchuku ndɨ uxi ɨɨn apóstol jiin taka ga jnaꞌan da, ja ni ka ndututu da kanchuku da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ti yachi ni ka nchakoyo da, ti ni ka kachi chaa kanchuku un: ―¡Jandaa kuɨtɨ kuu ja ni nandoto Jitoꞌyo, ti ni ndenda ndijin ya nuu Simón! ―ni ka kachi chaa kanchuku veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yukan na ti ni ka jani da jnuꞌun nava ni ka ndejnaꞌan da jiin ya ichi kuankoyo da, jiin ja nasa ni ka nakuni da ya na ni tejnaꞌan ya staa stila nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti ni ka ndajnuꞌun ga da jnuꞌun un, ti ni ndenda ndijin Jesús kandichi ya maꞌñu da naa da, ti ni kanxiaꞌu ya siaꞌan jiin da naa da: ―Na kukuee nuu ra, ti na kusɨɨ ini ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ko maa da naa da ni ka yuꞌu xaan da, ti ka ndoꞌo ini da ja so ni naxnaꞌan ya maa ya nuu da, chi tu ni ka nakuni ndaa da ja maa ya kuu ndixia. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ti maa Jesús ni kachi ya jiin da naa da: ―¿Ndoo ka jani sɨkɨ ini ra ti ka yuꞌu ra naa ra? ");
INSERT INTO mpmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ndeꞌe ndaꞌa ri jiin sɨꞌɨn ri naa ra, ti kuni ndaa ra ja maa ri kuu ndixia. Keꞌe ruꞌu jiin ndaꞌa ra ti kuni ndaa ra, chi ɨɨn tachi ja naxnaꞌan nuu yo tu iyo yɨkɨ kuñu nanu ka ndeꞌe ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nu ni kaꞌan ya siaꞌan, ni xnaꞌan ya ndaꞌa ya jiin jaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ko vanuxia maa da naa da, changa ga kandixia vaꞌa da, ti ka kusɨɨ ini da, ko so ka saꞌu ini da naa da. Ti ja yukan ni kachi Jesús: ―¿Ka ñavaꞌa ra tɨꞌlɨ ja kaji yo jaꞌa naa ra nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ti maa da ni ka jaꞌa da ɨɨn pedazu chāká ja ni ka tau da nuu ñuꞌun, jiin ɨɨn staa nduxi ñuñu nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ti ni kiꞌin ya un, ti ni yaji ya nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yukan ti ni kachi ya: ―Nundoꞌo ni jnaꞌan ri, yukan kuu jnuꞌun ni jani ri nuu ra naa ra na ni kuncha ga ri jiin ra naa ra, ja kanuu ja na siuku ri nava yoso taka tutu Yandios, tutu ya ja nani ley Moisés, jiin nuu tutu ya ni ka chaa profeta na janaꞌan, jiin nuu tutu ya ja nani Salmo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yukan na ti ni kachi ndaa ya nuu da nasa kuni kaꞌan taka jnuꞌun yoso nuu tutu Yandios sɨkɨ maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ti ni kachi ya: ―Siaꞌan yoso nuu tutu ja sɨkɨ ruꞌu ja kuu ri Cristo, ja taji Yandios ruꞌu saꞌa ri jniñu ñaꞌnu, koo ndoꞌo koo nene ri ti kuū ri. Ti nu uni kɨvɨ ti nandoto ri maꞌñu ndɨyɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ti sɨvɨ ri kuu ja kuichanuu kiꞌin nuu taka nación, ja na kuni yɨvɨ jnuꞌun ri naa i. Ti kejaꞌa undi ñuu Jerusalén, kachi nuu i ja na nakani ini yɨvɨ naa i nuu kuachi i, nava na kuankaꞌnu ini Yandios nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ti maa ra naa ra, kuaꞌa ra jandaa nuu taka ja ka jini ra jiin taka ja ni ka jinisoꞌo ra. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ko kundatu ra ñuu Jerusalén jaꞌa, chi taji ri maa ya ni chisojnuꞌun Tata ri Yandios nuu ra naa ra. Ko kundatu ra ñuu jaꞌa undi na niꞌin ra maa ya kii nuu Yandios, ya kancha andɨvɨ, sa kuu saꞌa ra jniñu tatu ri nuu ra naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yukan na ti ni kee ya Jerusalén jiin da naa da, ti kuaꞌan ya undi ñuu Betania. Ti yukan ni kaniꞌin ya ndɨnduu ndaꞌa ya, ti ni jikantaꞌu ya nuu Yandios ja na kuaꞌa ya jnundee ini nuu da naa da, ti na koto ndaꞌu ya naa da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ti nɨ kaꞌan ga ya siaꞌan, ni kuxio ya maꞌñu da ti ni ndaa ya kuanoꞌon ya andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti maa da naa da ni ka chiñuꞌun da ya, ti sa kuan nukoyo da Jerusalén, ko ka kusɨɨ xaan ini da kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ti yukan nɨnɨ ka jaꞌan da ini veñuꞌun kaꞌnu Israel un, ja ka nakanajaa da Yandios ja ñaꞌnu kuu taka jniñu ni saꞌa ya. Jaꞌa kuu jnuꞌun Yandios ni chaa Lucas.");
INSERT INTO mpmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na ti saꞌa ga Yandios ñuyɨvɨ jiin taka ga iyo, ti ja iyo Ɨɨn ja kancha jiin ya ja nani Jnuꞌun. Siaꞌan ni nani chi xnaꞌan nasa kaa maa Yandios. Ti ɨɨn ni kuu Jnuꞌun un jiin maa Yandios. Ti suni siaꞌan ɨɨn nuu ini maa Yandios jiin Jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Siaꞌan ni ja iyo kancha Jnuꞌun un jiin Yandios sa ni saꞌa ya ndɨꞌɨ ga ja iyo. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ti maa ɨɨn ni Jnuꞌun un ni saꞌa nava ni kachi Yandios, ni saꞌa taka ja iyo. Tu ni iyo ni ɨɨn ja tu ni saꞌa Jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ni saꞌa Jnuꞌun un ja taka ja iyo na kuchaku. Ti nava na kujnuni ini yɨvɨ nau kuu Yandios, chi Jnuꞌun un ni kuu nanu ɨɨn ñundijin ja na ndinchaa ichi i nava na kujnuni ini i nau ja kuu ya. Tu ka kuni kuɨtɨ i ja na ndinchaa ñuꞌun un nuu i. Vasu siaꞌan tu ka kuni i tu ni ka kundee i ndaꞌva i ñuꞌun un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ti vasu siaꞌan ni kuu, ko tu ni ka kujnuni ini i nau ja kuu ya, chi kanchuku i nanu ñuñaa kuɨtɨ. Ni chaa ya ti ni kuu ya nanu ɨɨn ñuꞌun ja na ndundijin nuu ñaa un. Ti vasu siaꞌan ni kuu ko tu ni ka kujnuni ini yɨvɨ nau ja ni kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yukan ti sa ni nakaji Yandios ɨɨn chaa ni nani Juan, ");
INSERT INTO mpmNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ti ni jaꞌa ya ɨɨn jniñu nuu da ja na kaꞌan da jnuꞌun ya nuu yɨvɨ. Ni kaꞌan da, ti ni kachi da: “¡Ja ni chaa Chaa un”! ―ni kachi da. Siaꞌan ni kaꞌan da, chi ni kachi da ja Chaa un kuu ja kuaꞌa inijnuni yɨvɨ. Chi kuu da nanu ɨɨn ñuꞌun ja xndinchaa nava na kujnuni ini yɨvɨ na ichi kinkoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Siaꞌan ni kaꞌan Juan chi ni kachi da ja ansu maa da kuu Chaa kuu nanu ñuꞌun un, chi so kachi da ja na kandixia yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Undi ni chaa Chaa un, ti sa ni ka kujnuni ini yɨvɨ naa ichi kinkoyo i, chi ni jaꞌa da inijnuni yɨvɨ ñuyɨvɨ. Ti jnuꞌun kaꞌan da un, ni kuu nanu ɨɨn nduva ja ndinchaa nuu ñuñaa. Chi ni xnaꞌan naa ichi kinkoyo yɨvɨ naa i. Ti siaꞌan na kujnuni ini i nau ja kuu maa Yandios. Jiin jnuꞌun ni kaꞌan chaa un, ni ka jini i naa ichi kinkoyo i. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Vasu maa Chaa un ni saꞌa ñuyɨvɨ jaꞌa ti ni kuncha da nuu, ko tu ni ka jantaꞌu yɨvɨ maa da. Chi tu ni ka nakuni i nau chaa kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni kuncha Chaa un nuu kanchuku yɨvɨ ñuu da, ja su ndɨꞌɨ i kuantaꞌu maa da, ja maa da kuu Seꞌe Yandios, ya kuu Cristo. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ti yɨvɨ ni ka jantaꞌu ya yukan, ni ka kuu i yɨvɨ ka kandixia. Ni jaꞌa ya jnundee ini yɨvɨ un, ti siaꞌan ni ka nduu i yɨvɨ Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti ka kuu i yɨvɨ Yandios, chi siaꞌan ni kuu ini maa ya. Ti ansu ja ni ka kuu ini maa yɨvɨ naa i, chi ja ni kuu ini maa Yandios ni kuu ja ni ka nduu i seꞌe maa ya, ti tukaa ga kuu i nanu kuu ɨɨn seꞌe tata jiin nana. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chaa ni kuu Jnuꞌun ja ni kuncha undi nuu jiin Yandios un, ni kii da ni kaku da nuu ñuyɨvɨ jaꞌa. Ni kuncha da jiin yɨvɨ naa i, ti ruꞌu naa ri ni ka jini ri ja ɨɨn ni kuñaꞌnu da jiin Tata da Yandios. Jiin jniñu ni saꞌa da ni stuu da ja kuñaꞌnu Yandios. Ti yukan sa ni ka jini ri ja maa da kuu Seꞌe Yandios, chi ɨɨn ni ka kuñaꞌnu ya jiin maa Yandios. Ni nakachi ya taka jnuꞌun ndaa vaji nuu maa Yandios. Siaꞌan ni kuu na ni chaa Jnuꞌun un nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan, chaa ni skuanducha un, ni kaꞌan da jnuꞌun ya nuu yɨvɨ, ti ni kachi da: ―Sɨkɨ Chaa jaꞌa ni kaꞌan ri nuu ra naa ra na, ni kachi ri ja jaa ɨɨn kɨvɨ ti chaa ɨɨn Chaa kuñaꞌnu ga, chi xnaka Chaa un iyo, ti sa ni kaku ruꞌu ―ni kachi Juan, chaa ni skuanducha un. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iyo xaan jnuꞌun ndee ini nuu ya nuu Yandios. Ja yukan kuu ja kundaꞌu ini ya yoꞌo naa yo, ti chindee xaan ya yoꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xnaka Moisés ni xnukoo ley Yandios, ti sa ni taji ya Jesús, ya kuu Cristo, ti maa ya kuu ja kundaꞌu ini yoꞌo. Ti Jesús kuu ya ni xndaku taka ga jnuꞌun vaji nuu maa Yandios nuu yo naa yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tu jaꞌi nakuni yɨvɨ nuu Yandios, chi maa ɨɨn ni seꞌe ya kuu ja kancha jiin ya. Ja yukan kuu ja ni kii ya, ni kii stuu ya nava kaa maa Tata ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yukan ti chaa ka kuñaꞌnu nuu nación Israel, ja kanchuku ñuu Jerusalén, ni ka jaꞌa da jniñu nuu tɨjnɨ sutu jiin ndajaꞌa da ja ni ka nani levitas. Ni ka taji da chaa un nuu kande Juan ja na kajnuꞌun da, na ndenu nau sɨkɨ kuu jniñu saꞌa da un. Ti jaꞌa kuu jnuꞌun ni kaꞌan Juan jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tu ni nduku da ɨnga jnuꞌun ja xndaꞌu da chaa un, chi suꞌva ni kachi ndaa da: ―Ansu ruꞌu kuu maa Cristo ja ni taji Yandios ja saꞌa jniñu ñaꞌnu un ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yukan na ti ni ka jikajnuꞌun tuku chaa un: ―¿Nau ja kuu ra nusa? ¿Xi maa ra kuu profeta Elías ja ni kaꞌan jnuꞌun Yandios un nu? ―ni ka kachi da. ―Ansu kuu ri ―ni kachi Juan. Ti ni ka jikajnuꞌun tuku da: ―Kii ɨɨn chaa kii kaꞌan jnuꞌun vaji undi nuu maa Yandios. ¿Xi maa ra kuu chaa un nu? ―ni ka kachi da. Ti ni xndeokani Juan: ―Tuu ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yukan na ti ni ka jikajnuꞌun tuku da, ti ni ka kachi da: ―¿Nau ja kuu ra nusa? Kachi, nava siaꞌan na niꞌin ri jnuꞌun nakani ri nuu chaa ñaꞌnu ni ka taji ruꞌu un, ¿Ko na chaa kuu maa ra nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ti ni kachi Juan: ―Maa ri kuu ja ve kaꞌan undi nuu ñuꞌun teꞌe jaꞌa, ja na kachi ri nuu yɨvɨ: “Satuꞌva maa ra naa ra, chi ja yajni chaa Jitoꞌyo Yandios”, chi siaꞌan ni kaꞌan Isaías na ni chaa da jnuꞌun Yandios na janaꞌan―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ti chaa vekoyo nuu chaa fariseo un ni ka jikajnuꞌun da Juan, ti ni ka kachi da: ―¿Ti ndoo skuanducha ra yɨvɨ, ti nu tu kuu ra maa Cristo, ni Elías, ni ɨnga profeta ja kaꞌan jnuꞌun vaji undi nuu maa Yandios nusa? ¿Ndoo kuu ja saꞌa ra un nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ti ni kachi Juan jiin da naa da: ―Saña chi skuanducha na jiin nducha, ko iyo ɨnga Chaa ja chaa nuu ni naa ni, ti niꞌin, tu ka nakuni ni chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xnaka saña ni chaa, sa chaa Chaa un. Ko vanuxia kuñaꞌnu ga da ja kuu saña. Kuñaꞌnu xaan ga da ja tu kuu kandu na nuu da, ni ansu jniñu na kuu jakuitandijin na ti tava na ndijña da ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Siaꞌan ni kaꞌan Juan na ni kunde da yajni ñuu Betábara, ja kande ɨnga yuꞌu yucha Jordán nu ni skuanducha da yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ɨnga kɨvɨ ti ni jini Juan nuu Jesús ja vaji ya nuu kande da, ti ni kachi da jiin yɨvɨ: ―Ndeꞌe naa ra, jaꞌa vaji maa Lelu Yandios, ti kuu ya nanu lelu ni ka jaꞌni yɨvɨ Israel ja ni ka soko i ja na kencha kuachi i. Ti maa ya kuu Lelu Yandios, chi siaꞌan ni chaa ya ja na kencha ya kuachi yɨvɨ ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Undi nuu ni kaꞌan ri jnuꞌun ya ja ni kachi ri: “Xnaka ruꞌu, ni kenda ti sa kenda maa Chaa kuñaꞌnu ga un. Kuñaꞌnu ga ya chi ja iyo ya, ti sa ni kaku ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Undi na sa ti kuni ga ri nau kuu maa ya. Ko xnaka ni kenda ri skuanducha ri jiin nducha nava siaꞌan na stuu ri maa ya nuu yɨvɨ Israel. Yukan na ti sa na nakuni yɨvɨ Israel nau kuu ya” ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yukan na ti ni jani Juan jnuꞌun, ti ni kachi da: ―Ni jini ri ni kuun Espíritu Yandios vaji ya undi andɨvɨ, vaji ya nanu ɨɨn sata, ni jinu ya ti ni kendo ya jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Undi sa ti kuni ga ri nau kuu ya, ko vijna ti ja ni jini ri chi maa Yandios ni taji ya ruꞌu. Ni jaꞌa ya jniñu nuu ri ja na skuanducha ri yɨvɨ jiin nducha. Ni kaꞌan ya jiin ri, ti ni kachi ya: “Nu ni jini ra ni kuun Espíritu Yandios ti jinu ya sɨkɨ ɨɨn chaa un. Ti Chaa yukan kuu ja taji Espíritu Yandios ja na kuncha ya jiin yɨvɨ naa i”, ni kachi Yandios jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ruꞌu Juan, na kachi ri ja, ja ni jini ri Chaa un, ti jaꞌa ri jandaa ja maa ndixia da kuu maa Seꞌe Yandios. Ti jandaa kuɨtɨ kuu ja Chaa un kuu maa Seꞌe Yandios ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ɨnga kɨvɨ ti kande tuku Juan jiin uu chaa ka jika jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ni jini da nuu Jesús ni yaꞌa ya yukan, ti ni kachi da: ―Ndeꞌe naa ra, Chaa un kuu maa Lelu Yandios ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ni ka jinisoꞌo chaa ka jika jiin Juan ja siaꞌan ni kaꞌan da, ti ni ka chindikun chaa un jata Jesús kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ni ndeokoto Jesús, ni jini ya ja ka ndikun chaa un kuankoyo da jata ya. Ni kaꞌan ya, ti ni kachi ya: ―¿Ndoo ka nduku ra naa ra? ―ni kachi ya. Ti ni ka kachi da naa da: ―Maestro, ¿Nanu nchaa ni? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ti ni kachi Jesús: ―Ñaꞌan na choꞌo, ti kuni ra ―ni kachi ya. Kuankoyo da jiin ya naa da ti ni ka jini da nuu kancha ya. Ti yukan ni ka kendo da jiin ya kɨvɨ un, chi ja ni kuu kaa kuun ja ini. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ɨɨn chaa un ni kuu Andrés, ñani Simón Pedro. Ni jini da ja siaꞌan ni kaꞌan Juan, ti ni chindikun da jata Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yukan na ti ni jan nunduku Andrés ñani da Simón Pedro, ti ni kachi da jiin da: ―Ni nakejnaꞌan ri jiin Cristo, ya ni taji Yandios ja saꞌa jniñu ñaꞌnu un ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yukan na ti kuaꞌan da jiin ñani da nuu kancha Jesús. Nu ni jini Jesús nuu Simón, ti ni kachi ya: ―Maa ra kuu Simón, seꞌe yɨɨ Jonás. Undi vijna ti kendo ra konani ra Cefas ―ni kachi ya. (Cefas kuni kaꞌan Pedro nuu saꞌan ni ka kaꞌan yɨvɨ un.) ");
INSERT INTO mpmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ɨnga kɨvɨ ti ni kiꞌin Jesús ichi kuaꞌan ya ichi ñuu Galilea. Yukan ni ndejnaꞌan ya jiin Felipe. Ni kachi ya jiin da: ―Ñaꞌan na choꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti Felipe ni kuu da ɨɨn chaa ñuu Betsaida, nu kuu ñuu Andrés jiin Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ni nanduku Felipe Natanael, ti ni kachi da jini da: ―Ja jini ra nava ni chiso Moisés jiin taka ga profeta ni ka kaꞌan da jnuꞌun Yandios na janaꞌan. Ni ka kaꞌan da ja chaa ɨɨn chaa kuñaꞌnu ja kuu ɨnga kuiya. Ni ka ndejnaꞌan ri jiin chaa un, ti maa da kuu Jesús, seꞌe yɨɨ José, chaa ñuu Nazaret ―ni kachi Felipe. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ti ni kachi Natanael jiin Felipe: ―Ti va nu iyo ɨɨn chaa vaꞌa kenda nuu ñuu Nazaret ―ni kachi da. Ti ni kachi Felipe jini da: ―Na choꞌo, ndeꞌe ti kuni ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ni jini Jesús ja kuaja Natanael, ti ni kachi ya jiin da: ―Jaꞌa vaji ɨɨn maa chaa ñuu Israel ja tu jini da xndaꞌu ñaꞌan da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ti ni kachi Natanael jiin Jesús: ―¿Nasa ni nakuni ni saña? ―ni kachi da. Ti ni kachi Jesús jiin da: ―Na ti kana ga Felipe xini ra, ti ja ni jini ri roꞌo kande ra ndatɨ nutɨchɨ vixi un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ti ni kachi Natanael: ―Maestro, maa ni kuu Seꞌe Yandios. Ti maa ni kuu rey taꞌu jniñu nuu nɨ tuꞌu nación Israel ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ti ni kachi Jesús jiin da: ―Ni kandixia ra ruꞌu chi ni kachi ri jiin ra ja, ja ni jini ri kande ra ndatɨ yujnu un. Ko ndeꞌe ra ti kuni ra ja suꞌva naꞌnu ga jniñu saꞌa ri, chi suꞌva nduñaꞌnu ga ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ni siin Jesús kaꞌan ya jiin da, ti ni kachi ya: ―Jandaa na kachi ri nuu ra ja vijna na ti kuni ra nuña andɨvɨ, ti ndeꞌe ra chakoyo ndajaꞌa Yandios (ja ka nani ángel), ti ka ndaa ka nuu i nuu kancha ruꞌu, ja kuu ri seꞌe Yɨvɨ Ñuyɨvɨ jaꞌ ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nu ni yaꞌa uni kɨvɨ, ti ni iyo ɨɨn viko nandaꞌa ñuu Caná, ja kuu ndañuu Galilea. Ti yukan kande nana Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Suni kuaꞌan Jesús jiin chaa ka skuaꞌa jiin ya, chi ni ka kana yɨvɨ un maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti nu ni jaa hora ja ni ndɨꞌɨ vino ni ka jiꞌi yɨvɨ un, ti ni kachi nana Jesús jiin ya: ―Ja ni ndɨꞌɨ vino ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ti ni kachi Jesús jiin ña: ―Koto xndiꞌi ni ini ni, chi tu jaꞌi jaa kɨvɨ ja saꞌa na ɨɨn jniñu ñaꞌnu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yukan na ti ni kachi nana Jesús nuu chaa ka jicondiso vasu un: ―Saꞌa taka ndoo na kachi maa ya nuu ra ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ti yukan kajiin iñu tenaja yuu naꞌnu ja kɨvɨ kuun xiko xi undi ɨɨn ciento litro nducha chii. Ti jnuꞌun yɨvɨ hebreo ni kuu ja ka jajniñu i tenaja un ja kuu nducha ja ka nandaꞌa i jiin ja ka na sandoo i koꞌo i, nava siaꞌan na kendo vaꞌa i nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ni kachi Jesús nuu chaa ka jicondiso vasu un: ―Chuꞌun chitu nducha chii tenaja jaꞌa ―ni kachi ya. Ti ni ka chuꞌun chitu chaa un nducha chii tenaja un. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yukan ti ni kachi Jesús: ―Tava tɨꞌlɨ ti kuaꞌa ra nuu chaa yɨndaꞌa viko un ―ni kachi ya. Ni ka tava da tɨꞌlɨ ti kuankoyo da jiin nuu chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ni ka jiꞌi da tɨꞌlɨ, ti so ni naa ini da chi vaꞌa xaan ga iyo vino un. Ti tu jini da nasa ni jaa un. Ko maa chaa ka jicondiso un chi ni ka jini da. Yukan na ti ni kana chaa ndisojniñu un xini chaa ni nandaꞌa un, ");
INSERT INTO mpmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ti ni kachi da jiin da: ―Taka yɨvɨ chi xnaka ka jaꞌa i vino vaꞌa un ka jiꞌi yɨvɨ kuaꞌa un, ti sandɨꞌɨ ni ga sa ka jaꞌa i vino ndaꞌu ga. Ko roꞌo, chi suꞌva sandɨꞌɨ ni ga ni xndoo ra ja vaꞌa ga. Jaꞌa kuu ja vaꞌa xaan ni saꞌa ra ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yukan ni kuu ɨɨn jniñu ñaꞌnu ni saꞌa Jesús undi nuu kuɨtɨ. Undi ñuu Caná, ja kuu ɨɨn ndañuu Galilea, siaꞌan ni saꞌa ya. Yukan ti viꞌi ga ni ka kandixia chaa ka skuaꞌa jiin ya naa da. Ni saꞌa ya ɨɨn jniñu ñaꞌnu un ja na kuni yɨvɨ ja ni jaꞌa Yandios ɨɨn jniñu ñaꞌnu ga nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yukan na ti sa kuaꞌan ya ichi ñuu Capernaum. Nana ya, ñani ya, jiin chaa ka skuaꞌa jiin ya suni kuankoyo da jiin ya, ti yukan ni kaꞌiin da jaku kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kuan kuyajni viko ka saꞌa yɨvɨ hebreo ja ka nukuꞌun ini i na ni keniꞌin Yandios maa i ñuu Egipto na janaꞌan. Ti viko un nani viko pascua. Kuaꞌan Jesús ñuu Jerusalén ja ni kuu kɨvɨ viko un. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ti nuu veñuꞌun kaꞌnu un ni jini ya ka xiko yɨvɨ xndɨkɨ, jiin rɨɨ, jiin sata. Ti suni kaꞌiin chaa ka xndayɨ xuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nu ni jini Jesús yukan ti ni kuɨtɨ ini ya. Ti yukan ni saꞌa ya ɨɨn cuarta ñɨɨ, ti ni keniꞌin ya yɨvɨ un kuankoyo i. Ni keniꞌin ya yɨvɨ un ichi fuera yuxeꞌe un. Ni keniꞌin ya rɨɨ, ni keniꞌin ya xndɨkɨ. Ni skuiokava ya mesa chaa ka xndayɨ xuꞌun un, ti ni ka jichanuu xuꞌun un kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ti nuu chaa ka xiko sata un ni kachi ya: ―Keniꞌin jaꞌa naa ra, ti tukaa saꞌa ra yaꞌu ini veꞌe Tata ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yukan ti ni ka nukuꞌun ini chaa ka skuaꞌa jiin ya ja kaꞌan nuu tutu ii Yandios sɨkɨ Jesús: “Ndɨꞌɨ xaan ini na veꞌe ni, ja na kuu ɨɨn veꞌe ii”, kachi nuu tutu. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yukan sa ni ka jikajnuꞌun chaa hebreo un maa ya: ―Nu ndixia ra ja ndisojniñu ra ja saꞌa ra yukan, ti jaꞌa kuaꞌa ra jandaa vijna. ¿Ti na ɨɨn jniñu ñaꞌnu ndiso ra nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ti ni kachi Jesús nuu da naa da: ―Kuu kanuu na veñuꞌun jaꞌa kiꞌin, ko nuu uni kɨvɨ ti nakani tuku ni na kundichi ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ti ni ka kachi yɨvɨ hebreo un: ―Uu xiko iñu kuiya ni ka saꞌa yɨvɨ jniñu ti sa ni ka jani i veñuꞌun kaꞌnu jaꞌa kandichi, ti roꞌo ndoꞌo ini ra ja nuu uni ni kɨvɨ ti nakani tuku ra kundichi ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ja siaꞌan ni kaꞌan Jesús jnuꞌun veñuꞌun kaꞌnu un, ko ni kaꞌan ya ja sɨkɨ yɨkɨ kuñu maa ya, ");
INSERT INTO mpmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ja nandoto tuku ya nuu ñujiꞌi. Ti yukan sa ni ka nukuꞌun ini chaa ka skuaꞌa jiin ya. Ni ka nukuꞌun ini da jnuꞌun ni kaꞌan ya, ti sa ni ka kandixia da ja siaꞌan ndixia kaꞌan nuu tutu Yandios. Suni ni ka kandixia da jnuꞌun ni kaꞌan maa Jesús na kɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na ni kunde Jesús ñuu Jerusalén ja ni kuu kɨvɨ Pascua, nde kuaꞌa yɨvɨ ni ka kandixia ja maa ya kuu Cristo, chi yukan ni ka jini i jniñu ñaꞌnu saꞌa ya ja ndisojniñu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","So ja tu kachi kaji ya, ko maa ya ja jini ya nasa kanda taka yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ja yukan kuu ja tu nɨnɨ kuu ja kachi ɨɨn yɨvɨ nuu ya nasa kanda i, chi vanua ja jini vaꞌa maa ya nasa ka ndoꞌo ini yɨvɨ, jiin undi inijnuni i. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ni iyo ɨɨn chaa fariseo ni nani Nicodemo. Ti ni kuu da ɨɨn chaa kuñaꞌnu nuu yɨvɨ nación hebreo. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ti ɨɨn jakuaa ni jaꞌan da nuu kancha Jesús, ti ni kachi da jiin ya: ―Maestro, ja ka jini na ja maa Yandios ni taji niꞌin ja na xnaꞌan ni jnuꞌun ya nuu na naa na. Tu ka kuu saꞌa ɨɨn yɨvɨ ɨɨn jniñu ñaꞌnu nanu saꞌa maa ni nu tu chindee Yandios maa i. Ti jiin yukan ka jini na ja maa ya ni taji niꞌin vaji ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ti ni kachi Jesús jiin da: ―Jandaa na kachi ri nuu ra ja nu tu nakaku jaa ɨɨn yɨvɨ nuu Yandios, ti tu kuu kɨvɨ i ñuu nuu taꞌu Yandios jniñu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ti ni kachi Nicodemo: ―¿Ti nasa kuu nakaku jaa ɨɨn chaa ñaꞌnu, ti nu ja ni jaꞌnu da nusa? ¿Xi va nu kuu ndɨvɨ tuku da chii nana da, ti sa nakaku tuku da nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yukan na ti ni kachi Jesús jiin da: ―Jandaa na kachi ri nuu ra ja nu tu nakaku jaa ɨɨn yɨvɨ, ti tu kuu kɨvɨ i ñuu nuu taꞌu Yandios jniñu. Ti yukan kuu ja saꞌa maa Espíritu Yandios ja na nakani ini i ti na kuanducha i, nava na kondoo undi ini añu i, ti ansu ja na nakaku i nuu jaꞌa nana i. Chi ja na nakaku i kuu ja saꞌa maa Espíritu Yandios. Yukan na ti sa kuu kɨvɨ i ndaꞌa Yandios ja na taꞌu ga jniñu nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Saꞌa yo nanu ja nu na kaku ɨɨn yɨvɨ, ko kaku i jiin yɨkɨ kuñu ñuyɨvɨ jaꞌa. Ko ja saꞌa Espíritu Santo kuu ja na nakaku jaa i undi ini añu i. Yukan kuu ja na nakaku jaa ɨɨn yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ti va so naa ini ra jiin jnuꞌun ni kaꞌan ri un, chi nu ka kuni kɨvɨkoyo yɨvɨ ñuu nuu taꞌu Yandios jniñu, ti tukaa iyo ɨnga ichi kinkoyo i, chi ɨɨn ni ichi iyo. Ti yukan kuu ja saꞌa maa Espíritu ii ja na nakaku jaa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ndeꞌe ra nu kee tachi, ti jinisoꞌo yo ko tu kuu kuni yo jiin nduchi yo, ni tu kuu jnɨɨ yo jiin ndaꞌa yo, ni tu kuni yo na ichi kuaꞌan. Suni siaꞌan saꞌa Espíritu Yandios jiin yɨvɨ, chi tu ka jini i nasa saꞌa ya ja na nakaku jaa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ni jikajnuꞌun tuku Nicodemo: ―¿Ti nasa kuu ja nakaku jaa yɨvɨ nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ti ni kachi Jesús jiin da: ―Kuu ra ɨɨn maestro, ti kuñaꞌnu ra nuu jnaꞌan yo ja ka kuu yɨvɨ Israel, ti tu kujnuni ini ra jnuꞌun jaꞌa, ¿Va tu jini ra nusa? ");
INSERT INTO mpmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jandaa na kachi ri nuu ra, ja ka jini ndaa ra taka jnuꞌun kaꞌan ri, ti jani ndaa ri jnuꞌun taka ja ni jini ri. Ko so ja roꞌo, tu kandixia ra jnuꞌun kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ja siaꞌan tu kandixia ra jniñu saꞌa Yandios nuu ñuyɨvɨ jaꞌa, ¿Ti ndee ga ja kandixia ra nu na kachi ri nasa jito Yandios taka jniñu saꞌa ya undi nuu kancha maa ya nusa? Va tukaa ga kandixia ra yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni ɨɨn tundo jaꞌan andɨvɨ ja kuni nasa iyo yukan, chi maa ɨɨn ni ja ni chaa nuu ñuyɨvɨ jaꞌa kuu ja jini. Maa ɨɨn ni ruꞌu ja kuu ri Seꞌe Yɨvɨ Ñuyɨvɨ, ja ni kuncha ri andɨvɨ, ti jini ndaa ri nasa iyo. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ko yukan na ti katakaa yɨvɨ ruꞌu nuu ndaꞌa cruz, ja kuu ri Seꞌe Yɨvɨ Ñuyɨvɨ. Na ni ka jikonuu yɨvɨ hebreo nuu ñuꞌun teꞌe un na janaꞌan, ni jatakaa Moisés ɨɨn koo kaa nuu ɨɨn ndaꞌa yujnu un un. Ti suni siaꞌan kuu vijna, chi katakaa yɨvɨ ruꞌu nuu ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yukan na ti taka yɨvɨ kandixia ruꞌu, tukaa jnaꞌnu ndatu i. Siaꞌan na ti sa kuu kunchuku i jiin Yandios ja kuu saa ni. Chi siaꞌan saꞌa Yandios jiin taka yɨvɨ ka kandixia Seꞌe Yɨvɨ Ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ni kundaꞌu xaan ini Yandios yɨvɨ ñuyɨvɨ. Ja yukan kuu ja ni taji ya seꞌe ya ni kii ya, vasu maa ɨɨn ya ni kuu Seꞌe Yandios. Ni kii seꞌe ya nuu ñuyɨvɨ nava taka yɨvɨ na kandixia ya, ti tukaa jnaꞌnu ndatu i, ti kunchuku i jiin Yandios ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Siaꞌan ni taji Yandios Seꞌe ya nuu ñuyɨvɨ. Ko tu ni taji ya Seꞌe ya ja na kaꞌnu ndatu ya yɨvɨ, chi suꞌva ja na nama ya yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Taka yɨvɨ ni ka kandixia ya, tukaa jnaꞌnu ndatu i, ko yɨvɨ ja tu ka kandixia i ya, ja ni ka jnaꞌnu ndatu i. Ko ni ka jnaꞌnu ndatu i ja tu ni ka kandixia i maa Seꞌe Yandios, ja maa ɨɨn ni ya kuu ja nama sɨkɨ yɨvɨ naa i. Siaꞌan ni kundaꞌu ini Yandios yɨvɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyo kuaꞌa yɨvɨ ja tu ka kandixia jniñu ni saꞌa Yandios. Ka saꞌa ndevaꞌa i, ti jiin jniñu ka saꞌa i un jini yo ja ka jnaꞌnu ndatu i. Ja ni taji Yandios seꞌe ya nuu ñuyɨvɨ, ti kuu ya nanu ɨɨn ñuꞌun ja ndinchaa nuu ñuñaa, ja na kuni yɨvɨ na ichi kinkoyo i, ko tu ka jandatu i. Chi ka ndiyo ini i ja saꞌa ndevaꞌa i nanu ɨɨn chaa jajnaꞌan ini kaka jakuaa. Suni siaꞌan ka ndiyo ini i kundikun i kuachi un. Siaꞌan ka stuu yɨvɨ un maa i ja ka jnaꞌnu ndatu i nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ja ni taji Yandios seꞌe ya nuu ñuyɨvɨ, ti ni kuu ya nanu ɨɨn nduva ñuꞌun ja ndinchaa nuu ñuñaa, nava na kuni yɨvɨ ichi kinkoyo i. Ko sa suꞌva ka jito uꞌu i Yandios jiin seꞌe ya ja xnaꞌan ya na ichi kinkoyo i. Ti ka jito uꞌu i jnuꞌun ya, chi tu ka na kuni i yukan sa ni ka jini i ja iyo kuachi sɨkɨ naa. Tu ka jantaꞌu i jnuꞌun ya, chi ka ndiyo ini i ja siin i jiin kuachi un. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko ka iyo yɨvɨ ka jantaꞌu Seꞌe Yandios, ja kuu ya nanu ɨɨn nduva ñuꞌun ja ndinchaa nuu ñuñaa. Chi xnaꞌan ya naa i ichi kinkoyo i, ti ka kusɨɨ ini kaka ndaa i ichi un, chi tu ka yuꞌu i saꞌa i jniñu vaꞌa ja kuni Yandios. Ti siaꞌan ka stuu kaji ja ka saꞌa i taka jniñu vaꞌa kuni maa Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yukan na ti kuaꞌan Jesús ichi ñuu Judea. Suni kuankoyo chaa ka skuaꞌa jiin ya. Yukan ni kuꞌiin da jiin ya jaku kɨvɨ, ti yukan ni skuanducha ya yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Suni ni kundee Juan ni skuanducha da ñuu Enón, chi yukan ni iyo kuaꞌa nducha. Ñuu yukan kendo yajni jiin ñuu Salím. Ni ka jaꞌan yɨvɨ nuu da, ti ni skuanducha da i. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yukan ni saꞌa Juan undi na ti kɨvɨ ga da vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Uu xi uni jnaꞌan chaa ka skuaꞌa jiin Juan, ti ni ka kejaꞌa ka kaꞌan da jiin chaa hebreo un. Ti ka kaꞌan da sɨkɨ ja nasa kuu ja ka ndundoo yɨvɨ nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yukan na ti ni ka jaꞌan da nuu kande Juan, ti ni ka kachi da: ―Maestro, ni jini ni chaa ni jaa nuu ni kunchuku yo ichi ɨnga yuꞌu yucha Jordán, ja ni kachi ni na chaa kuu chaa un. Vijna ti ja skuanducha da, ti tendɨꞌɨ yɨvɨ kuankoyo nuu da un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ti ni kachi Juan: ―Nu tu chindee Yandios, ti tu kuu saꞌa yɨvɨ ɨɨn jniñu nava kuni maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ja ka jini vaꞌa ra ja ni kachi ri ja tu kuu ri maa Cristo. Ko ni taji Yandios ruꞌu ve saꞌa ri ɨɨn jniñu ti jniñu un kuu ja na kaxnuꞌun ri nuu yɨvɨ ja kii ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na kani ri ɨɨn jnuꞌun. Nu na nandaꞌa ɨɨn chaa jiin ñasɨꞌɨ da, ka saꞌa da viko jiin amigo da. Ti amigo da un kuu chaa taꞌu jniñu nuu viko un, ti amigo da un kajnuꞌun nu iyo sɨɨ ini da ja nandaꞌa da xi tu. Nu ni kachi chaa nandaꞌa un ja iyo sɨɨ ini da, yukan ti amigo da un, suni kusɨɨ xaan ini da. Ti suni siaꞌan kusɨɨ xaan ini ri ja na kinkoyo yɨvɨ nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sɨkɨ ja ka kaꞌan ra un, ti kanuu ga ja na nduñaꞌnu ga maa ya, ti suꞌva na nukuu ga ruꞌu ―ni kachi Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ti maa ɨɨn ni ya kuu ja vaji undi andɨvɨ, yukan kuu ja kuñaꞌnu ga ya nuu tendɨꞌɨ yɨvɨ. Taka yɨvɨ ni ka kaku nuu ñuyɨvɨ jaꞌa ka kuu i seꞌe ñuyɨvɨ jaꞌa, ti ka kaꞌan i mani maa jnuꞌun iyo nuu ñuyɨvɨ jaꞌa. Ko ɨɨn ja vaji undi andɨvɨ, chi kuñaꞌnu ga nuu tendɨꞌɨ yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ti kaꞌan ya taka ja ni jini ya, ti jani ya jnuꞌun taka ja ni jinisoꞌo ya, ko tu ka kuni chunsoꞌo yɨvɨ taka jnuꞌun kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Taka yɨvɨ ni ka chunsoꞌo jnuꞌun ya, ni ka nakuni ndaa i ja iyo ndaa jnuꞌun ni kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ti jandaa ndixia kuu un, chi ni taji Yandios maa ya, ti maa ya kuu ja ni kaꞌan taka jnuꞌun kaꞌan Yandios, vanuxia kancha maa Espíritu Yandios jiin ya, ti tu yɨkuꞌva Espíritu ni jaꞌa Yandios ja na kuncha jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xaan ga mani Yandios jiin seꞌe ya. Ti ja yukan kuu ja ni nachiꞌi ya taka ja iyo nuu ndaꞌa seꞌe ya ja na taꞌu ya jniñu nuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yɨvɨ kandixia Seꞌe Yandios ja nama ya i, ti kunchuku i jiin ya ja kuu saa ni. Ko yɨvɨ ja tu kandixia Seꞌe ya, tu kuu kunchuku i jiin ya, chi suꞌva viꞌi ga kuɨtɨ ini Yandios nuu i, ti kuaꞌa ya nundoꞌo koo ndoꞌo koo nene i ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ni ka niꞌin chaa fariseo un jnuꞌun ja kuaꞌa ga yɨvɨ ka jika jiin Jesús, ti ni skuanducha ya kuaꞌa xaan ga yɨvɨ ja kuu Juan. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Vasu ansu maa Jesús ni skuanducha yɨvɨ, chi chaa ni ka skuaꞌa jiin ya un ni ka saꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ni jaa jnuꞌun un nuu Jesús ja siaꞌan ni ka jini chaa fariseo. Yukan kuu ja ni kee ya ñuꞌun ñuu Judea, ti kuanoꞌon ya ichi nuu ñuꞌun ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ti ichi kuaꞌan ya ni yaꞌa ya nuu ñuꞌun ñuu Samaria. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ni jaa ya ñuu Sikar ja kuu ɨɨn ndañuu Samaria. Ñuu un kande yajni ɨɨn ñuꞌun ni jaꞌa Jacob nuu seꞌe da José na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yukan iyo ɨɨn soko nducha ni nani soko Jacob. Ni kuita Jesús ja kuaꞌan ya ichi un, ti yukan ni jakuɨñɨ ya yuꞌu soko un. Ko ja ni kuu koxiuu kɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ti ni jaa ɨɨn ñaꞌan ñuu Samaria kuaja kiꞌin ña nducha. Ti ni kachi Jesús jiin ña: ―Kuaꞌa tɨꞌlɨ nducha na koꞌo ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ti chaa ka skuaꞌa jiin ya, kuankoyo da ñuu un kuan kuaan da ja kaji da jiin ya naa da, ti ni kendo maa ɨɨn ni ga ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ti ñaꞌan ñuu Samaria un ni kachi ña jiin ya: ―Niꞌin ja kuu ni chaa hebreo. ¿Ndo jikan ni nducha koꞌo ni nuu na, ti saña kuu na ñaꞌan ñuu Samaria? ―ni kachi ña. Siaꞌan ni kaꞌan ña, chi yɨvɨ hebreo un, tu mani i jiin yɨvɨ ñuu Samaria. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ti ni kachi Jesús jiin ña: ―Tu jini ra nasa kaa ɨɨn taꞌu vaꞌa ja kuni kuaꞌa maa Yandios nuu ra. Ni tu chaku ini ra, ti ni tu jini ra na chaa kuu ɨɨn ja kaꞌan jiin ra jaꞌa ja na kuaꞌa ra nducha koꞌo. Ko nu na kakantaꞌu ra nuu ri, ti kuaꞌa ri ɨɨn nuu nducha koꞌo ra ja na kuchaku ra ja kuu saa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yukan ti ni kachi ña jiin ya: ―Taa. Ko niꞌin, ni tu ñavaꞌa ni najin tava ni nducha. Ti soko jaꞌa chi kunu xaan. ¿Ti nanu kin kiꞌin ni nducha ja kaꞌñu ni nuu na nusa? ");
INSERT INTO mpmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jacob chaa ni kuu tata jnaꞌan na undi na janaꞌan. Chaa un ni jacha soko jaꞌa ti ni kendo jiin na naa na. Jaꞌa ni ka jiꞌi maa da nducha, ti suni jaꞌa ni ka jiꞌi taka jnaꞌan da jiin taka kuɨtɨ ni ka nchaka da. Ɨɨn chaa ni kuñaꞌnu ni kuu chaa un, ¿ti xi kuñaꞌnu ga niꞌin ja kuu chaa un nu? ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ti ni kachi Jesús jiin ña: ―Taka yɨvɨ koꞌo nducha jaꞌa, ti ichi tuku i. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko nu na koꞌo i ɨɨn nducha kuaꞌa ri nuu i, ti tukaa ga ichi kuɨtɨ i. Kuaꞌa ri nducha un nuu i, ti yukan nduu nanu ɨɨn soko nuu kaña nducha kuaꞌa. Yukan na ti kuncha i jiin Yandios ja kuu saa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ti ni kachi ñaꞌan un jiin ya: ―Taa. Kuaꞌa ni nducha yukan, na koꞌo na nava tukaa ichi kuɨtɨ na, ti nava tukaa kii kiꞌin kuɨtɨ na nducha soko jaꞌa ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ti ni kachi Jesús jiin ña: ―Kuan kana yɨɨ ra ti kii ra jiin da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ti ni kachi ña jiin ya: ―Tu na yɨɨ na iyo ―ni kachi ña. Ti ni kachi Jesús jiin ña: ―Ndaa jnuꞌun kaꞌan ra ja tu na yɨɨ ra iyo, ");
INSERT INTO mpmNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vanuxia, ja ni kuu uꞌun chaa ni kunchuku jiin ra, ti chaa kancha jiin ra vijna chi ansu yɨɨ ra kuu da. Jaꞌa ni kachi ndaa ra vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ti ni kachi ña jiin ya: ―Taa. Ko ndoꞌo ini na ja maa ni kuu ɨɨn profeta ja kaꞌan jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tata yɨvɨ ñuu Samaria na janaꞌan, ni ka chiñuꞌun i Yandios xini yuku jaꞌa. Ti niꞌin ka kaꞌan ni ja Jerusalén kuu ñuu nuu kunchañuꞌun yo Yandios ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ti ni kachi Jesús jiin ña: ―Roꞌo ñasɨꞌɨ. Kandixia jnuꞌun kaꞌan ri. Chi jaa ɨɨn kɨvɨ ja ni ansu ga yuku jaꞌa, ti ni ansu ga ñuu Jerusalén kuu nuu kunchañuꞌun ra maa Yandios, ya kuu Tata ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Roꞌo yɨvɨ ñuu Samaria naa ra, ka nchañuꞌun ra Yandios, ko vanuxia tu ka jini ra nasa kaa Yandios. Ko ruꞌu yɨvɨ hebreo chi ka jini ri nasa kaa Yandios, ka jini ri ja nɨnɨ nuu yɨvɨ hebreo vaji Ɨɨn ja nama sɨkɨ yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na kachi ri ja, ja ni jaa kɨvɨ kunchañuꞌun yɨvɨ Yandios, ja tukaa ka nandɨꞌɨ ɨɨn ni veñuꞌun nuu chiñuꞌun i ga. Ko chiñuꞌun i ya undi jiin nɨ ini nɨ añu i. Chi siaꞌan kuu ja kuni maa Yandios ja na kunchañuꞌun yɨvɨ maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tu kuu kuni yɨvɨ nuu Yandios, chi maa ya kuu Espíritu. Yukan kuu ja nu ɨɨn yɨvɨ kuni i chiñuꞌun i ya, ko kanuu ja na chiñuꞌun ndaa i ya jiin nɨ ini nɨ añu i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ti ñaꞌan un ni kachi tuku ña: ―Jini na ja kii ɨɨn ja ni nakaji Yandios ja nama sɨkɨ yo, ɨɨn ja konani Cristo. Nu na chaa chaa yukan, yukan ti xnaꞌan kaji ga da taka jnuꞌun un nuu yo ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ti ni kachi Jesús jiin ña: ―Maa ri kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nɨ kaꞌan ga ya jiin ñaꞌan un, ti ni ka najakoyo chaa ka skuaꞌa jiin ya. So ka naa ini da ja siaꞌan ka ndajnuꞌun ya jiin ñaꞌan un. Ko ni ɨɨn tu ni ka tava ini da ja kajnuꞌun da ya: “¿Ndo nduku ñaꞌan un?” Xi kachi da jiin ya: “¿Na ndoo kaꞌan ni jiin ñaꞌan un?” Tu kuɨtɨ ni ka kaꞌan da siaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ñaꞌan un ni xndoo ña kɨyɨ nducha ña ti kuaꞌan ni ña ichi ñuu. Ni jaa ña ti ni kejaꞌa ña kaꞌan ña jiin yɨvɨ un: ");
INSERT INTO mpmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Ñaꞌan na choꞌo naa ra, ti kuni ra ɨɨn chaa ni kachi ndɨꞌɨ nuu ri taka ja ni saꞌa ri! ¿Ti ansu maa da kuu Cristo nu? ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yukan ti ni ka kee yɨvɨ ñuu un kuankoyo i nuu kande Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ni ti jakoyo ga yɨvɨ un, ti chaa ka skuaꞌa jiin Jesús, ka kandaꞌu da jiin ya: ―Maestro, kaji ni ɨɨn vanuxii staa, na kaji yo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ti ni kachi Jesús jiin da: ―Iyo ɨɨn staa yaji ri ja roꞌo naa ra, tu ka jini ra nasa kaa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yukan ti chaa ka skuaꞌa jiin ya ka jikajnuꞌun jnaꞌan da naa da: ―¿Xi ja ni ka kinchaka yɨvɨ staa ni yaji ya nu? ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ti ni kachi Jesús jiin da: ―Siaꞌan ni kachi ri, chi saꞌa ri nava kuni maa ya ni taji ruꞌu vaji ri ja na saꞌa ri jniñu ya. Ti yukan kuu nanu ja na niꞌin jnuꞌun ndee ini yɨkɨ kuñu ri, nanu niꞌin yo jnuꞌun ndee ini jiin ɨɨn ndeyu yaji yo. Ti ndiyo ini ri ja sinu ri jniñu ni jaꞌa ya nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ti ja saꞌa yo jniñu kaꞌncha triu, ti vatu ni ka kaꞌan ra ja undi kuun yoo ti sa nastutu yo. Ko na kachi ri ja xnaka ndeꞌe vaꞌa ra naa ra, ndeꞌe vaꞌa ti kuni ra, chi vinañuꞌni ka iyo kuaꞌa xaan yɨvɨ nanu triu ja, ja ni kuaan ja kaꞌncha yo, chi yɨvɨ kuaꞌa ka tuꞌva i ti ka kandixia i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Xaan ndatu yɨvɨ nastutu jniñu un chi iyo xaan taꞌu i, chi saꞌa i jniñu ja nastutu i yɨvɨ, ti nasavaꞌa i nuu kunchuku yɨvɨ un jiin Yandios ja kuu saa ni. Ja siaꞌan ti nanu kusɨɨ ini chaa ni saꞌa jniñu un, suni siaꞌan kusɨɨ ini chaa nastutu. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ndaa jnuꞌun kaꞌan ɨɨn jnuꞌun, ja “Sɨɨn chaa saꞌa jniñu, ti ɨnga da nastutu.” ");
INSERT INTO mpmNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Suni siaꞌan taji ri roꞌo naa ra ja ka skuaꞌa jiin ri, ja na kachanuu ra jnuꞌun ri kiꞌin. Chi ka kuu ra nanu ɨɨn chaa nastutu triu. Vasu ansu maa ra ni ka jachanuu jnuꞌun un, chi ɨnga yɨvɨ ni ka jachanuu jnuꞌun ri, ko roꞌo kuu nanu nastutu jniñu ni ka saꞌa chaa un naa da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ja siaꞌan kuu ja kuaꞌa xaan yɨvɨ ñuu un ni ka kandixia i Jesús, chi ni kachi ñaꞌan un: “Ni kachi ndɨꞌɨ da taka ja ni saꞌa na”, ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nu ni ka jakoyo yɨvɨ ñuu Samaria un nuu kande Jesús, ti ni ka kaꞌan ndaꞌu i jiin ya ja na kendo ya jiin yɨ ti jaku kɨvɨ. Ti ni kendo ya yukan ni kundee ya uu kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kuaꞌa xaan i ni ka kandixia ya ja sɨkɨ jnuꞌun vaꞌa ni kaꞌan ya yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yukan na ti sa ni ka kachi yɨvɨ jiin ñaꞌan un: ―Tukaa nɨnɨ kuu ja undi kani ra jnuꞌun ti sa kandixia ri ya, chi suni ni ka jinisoꞌo maa ri jnuꞌun ni kaꞌan ya. Yukan na ti ni ka jini ndaa yo ja maa ya kuu maa Cristo, ya ni nakaji Yandios ja nama ya sɨkɨ yɨvɨ ñuyɨvɨ ―ni ka kachi yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nu ni yaꞌa uu kɨvɨ, ni kee Jesús ñuu Samaria, ti ni nakiꞌin ya ichi kuanoꞌon ya nuu ñuꞌun ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ti maa ya ni kaꞌan undi nuu, na ni kachi ya ja tu kuaꞌa yɨvɨ ja yɨñuꞌun nuu ɨɨn chaa kaꞌan jnuꞌun Yandios, ñuu nuu ni jaꞌnu da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ko nu ni jaa ya ñuu Galilea, ti ni ka jantaꞌu yɨvɨ un ya, chi ni ka jini i jniñu ñaꞌnu ni saꞌa ya ñuu Jerusalén ja ni kuu kɨvɨ viko un, chi suni ni ka jaꞌan i yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yukan na ti ni ndeokuñɨ Jesús ichi ñuu Caná ja kuu ndañuu Galilea, nuu ni nasaꞌa ya vino jiin nducha un. Ti ñuu Capernaum ni iyo ɨɨn chaa kuñaꞌnu ja ndiso jniñu da nuu rey. Ti kuꞌu seꞌe chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ni niꞌin da jnuꞌun ja ni kee Jesús ñuu Judea, ti ni nandeokuñɨ ya ichi ñuu Galilea. Yukan ti ni jaꞌan chaa kuñaꞌnu un nuu kancha Jesús, ti ni kejaꞌa jikantaꞌu da nuu Jesús ja na kiꞌin ya jiin da veꞌe da: ―Saꞌa ni tɨꞌlɨ tajna seꞌe na ―ni kachi da. Siaꞌan ni kaꞌan chaa kuñaꞌnu un chi ja yajni kuū seꞌe da niku. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ti ni kachi Jesús jiin da: ―Maa ra jiin tendɨꞌɨ yɨvɨ ɨɨn nuu kanda jiin ra, nu tu ndeꞌe ra jiin nuu ra ɨɨn jniñu ñaꞌnu saꞌa ri, ti ni tu kandixia kuɨtɨ ra ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ti ni kachi chaa kuñaꞌnu un: ―Taa. Jikantaꞌu xaan na nuu ni. Ko nu tu kiꞌin ni veꞌe na, ti va kuū seꞌe na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ti ni kachi Jesús jiin da: ―Kuanoꞌon veꞌe ra chi tu kuū ndixia seꞌe ra ―ni kachi ya. Ni kandixia chaa un jnuꞌun ni kaꞌan Jesús, ti kuanoꞌon ni da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kuan nduyajni da veꞌe da, ti ja kuaja ɨɨn chaa kuū muzu da un, ti ni kachi da jiin chaa kuñaꞌnu un: ―Ja ni nduvaꞌa seꞌe ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yukan ni jikajnuꞌun da muzu da un: ―¿Na hora ni nduvaꞌa seꞌe ri nusa? ―ni kachi da. Ti ni kachi muzu un: ―Ja yajni na koxiuu ni kee kiji un maa i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yukan ti ni nukuꞌun ini da ja hora yukan ni kachi Jesús jini da: “Kuanoꞌon veꞌe ra, chi tu kuu seꞌe ra”, ni kachi ya. Yukan ti ni kandixia da Jesús, ti suni ni ka kandixia tendɨꞌɨ yɨvɨ kanchuku veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yukan kuu ɨnga jniñu ñaꞌnu ni saꞌa Jesús na ni kee ya nuu ñuꞌun ñuu Judea ti kuanoꞌon ya ichi ñuu Galilea. Sa yukan kuu uu jniñu ñaꞌnu ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nu ni yaꞌa yukan na ti sa ni nandeokuñɨ Jesús ñuu Jerusalén, ti yukan nukuꞌun ɨɨn viko ka nasaꞌa yɨvɨ hebreo. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ni iyo ɨɨn pila kaꞌnu nducha ñuu Jerusalén. Ni nani Betesda nuu yuꞌu ka kaꞌan yɨvɨ hebreo. Ni iyo uꞌun yuxeꞌe lulu nuu ka kɨvɨ yɨvɨ nuu nducha un. Kendo yajni yuꞌu ñuu, ti yuxeꞌe un ni nani Yuxeꞌe Nuu Ka Yaꞌa Rɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ti yukan kandatu kuaꞌa yɨvɨ ka kuꞌu. Kandatu yɨvɨ kuaa nduchi, yɨvɨ rengo jiin yɨvɨ tɨkuku. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ti suni yukan katuu ɨɨn chaa ja ja ni kuu oko xiaꞌun uni kuiya kuꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ni jini Jesús nuu chaa un katuu da. Suni ni jini ya ja ja ni kuu naꞌan xaan kuꞌu da, ti ni jikajnuꞌun ya maa da: ―¿Kuni ra nduvaꞌa ra nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ti ni kachi chaa kuꞌu un: ―Taa, kuni na, ko tu iyo ni ɨɨn chaa chindee saña. Ni ɨɨn yɨvɨ tu kii chindee i saña ja na kɨvɨ na nuu nducha un nuu kejaꞌa kanda. Chi taka jinu ja kuni kɨvɨ na, ti xnakan ja kɨvɨ ɨnga yɨvɨ ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ti ni kachi Jesús jiin da: ―¡Ndokuñɨ! Nastuu yuu ra, ti kaka kuanoꞌon veꞌe ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ni ndoko da ni nastuu da yuu da, ti ni kejaꞌa jika da kuaꞌan da. Yukan ni kuu ɨɨn sabado, kɨvɨ ka ndetatu yɨvɨ hebreo. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ti chaa hebreo ka kuñaꞌnu un, ni ka kachi da jiin chaa ndaꞌu un: ―Kɨvɨ ndetatu kuu vijna, ti tu vaꞌa ja kundiso ra yuu ra kiꞌin ra jiin ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ti ni kachi chaa ni nduvaꞌa un: ―Ɨɨn chaa ni saꞌa tajna saña yukan ni kachi da ja na kundiso na yuu na ti na kiꞌin na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ni ka jikajnuꞌun chaa un maa da: ―¿Nau chaa kuu ja ni kachi jini ra ja na nakiꞌin ra yuu ra ti kiꞌin ra nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ti chaa ni nduvaꞌa un, tu ni jini da nau chaa kuu, chi vanuxia kuaꞌa xaan yɨvɨ kaꞌiin yukan, ti Jesús kuaꞌan ni ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kuee ga sa ni ndejnaꞌan Jesús jiin da yuxeꞌe veñuꞌun kaꞌnu un, ti ni kachi ya jiin da: ―Ja ni nduvaꞌa ra vijna. Vijna na ti koto ma saꞌa ga ra kuachi. Chi nu na saꞌa tuku ra, yukan na ti kii ɨɨn nundoꞌo kaꞌnu xaan ga sɨkɨ ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yukan na ti kuaꞌan chaa un, ni jani da jnuꞌun nuu chaa hebreo ka kuñaꞌnu un: ―Jesús kuu ja ni saꞌa tajna saña ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ti sɨkɨ ja ni saꞌa Jesús ɨɨn jniñu un kɨvɨ ndetatu, ja yukan kuu ja ni ka kejaꞌa ka jito uꞌu chaa hebreo ka kuñaꞌnu un Jesús, ti ka kuni kaꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ti ni kachi Jesús jiin da naa da: ―Na kachi ri nuu ra ja taka ni hora sajniñu Yandios. Maa Tata ri, sajniñu ya taka ni kɨvɨ. Ti suni siaꞌan sajniñu tu ruꞌu taka ni kɨvɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ja siaꞌan ni kaꞌan Jesús, ti viꞌi ga ni ka nduku da nasa kaꞌni da ya, chi tu ni jandatu ya jnuꞌun kaꞌan ley ja kuu kɨvɨ ndetatu un, jiin suni ja ni kachi ya ja Tata maa ya kuu Yandios, chi siaꞌan ni skejnaꞌan ya maa ya jiin maa Yandios. Yukan kuu ja ka kuni da kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ni kachi Jesús jini chaa hebreo ka kuñaꞌnu un: ―Na kachi ndaa ri nuu ra naa ra ja maa ri kuu Seꞌe Yandios, ti ni ɨɨn yɨvɨ tu kuu saꞌa ja saꞌa maa ya. Ti jandaa ndixia kuu yukan chi ruꞌu saꞌa ri taka ja saꞌa maa Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ti siaꞌan kuu ndixia chi mani Yandios jiin Seꞌe ya, ti xnaꞌan ya nuu Seꞌe ya taka ja saꞌa ya. Ti suꞌva ñaꞌnu ga jniñu xnaꞌan ya nuu seꞌe ya, ja undi so naa ini ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chi Ɨɨn ni ka kuñaꞌnu ya kuu Seꞌe jiin Tata ya. Tata yo Yandios, naxndoto ya yɨvɨ nuu ñujiꞌi, ti nachaku tuku i. Ti suni siaꞌan saꞌa maa seꞌe ya, chi suni naxndoto ya yɨvɨ naa i nuu ñujiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jaꞌa kuu ja ɨɨn ni kuñaꞌnu ya kuu Seꞌe jiin Tata ya. So ja maa Tata yo Yandios tu xndichi ya kuachi sɨkɨ ni ɨɨn yɨvɨ, chi ni jaꞌa ya jniñu ñaꞌnu un nuu Seꞌe ya ja na xndichi ndaa kuɨtɨ ya sɨkɨ kuachi yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Siaꞌan ti na chiñuꞌun yɨvɨ Seꞌe Yandios naa i nanu ka chiñuꞌun i maa Yandios. Ko nu nau yɨvɨ tu nachiñuꞌun Seꞌe ya, suni siaꞌan tu nachiñuꞌun i Tata ya, vasu ɨɨn ni ka kuñaꞌnu ya jiin Seꞌe ya, chi maa Tata Yandios kuu ja ni taji ya Seꞌe ya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ni siin Jesús kaꞌan ya ti ni kachi ya: ―Jandaa na kachi ri ja nu na chuꞌun ini yɨvɨ jnuꞌun kaꞌan ri, ti kandixia ndaa i ja maa Yandios ni taji ruꞌu, yukan na ti tu jnaꞌnu ndatu i. Vasu na kuu i ko tu kondoꞌo i nundoꞌo. Suꞌva ndɨvɨ i ndaꞌa maa Yandios ti yukan kuchaku i jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jandaa na kachi ri ja jaa ɨɨn kɨvɨ ti kundaa nava ni kachi ri, ti kɨvɨ yukan ja ni jaa. Yɨvɨ ka chaku vijna, ka kuu i nanu ndɨyɨ, ko nu na chuꞌun ini i jnuꞌun kaꞌan Seꞌe Yandios, ti kandixia i naa i, yukan na ti ja ka yɨꞌɨ i ndaꞌa maa Yandios, ti ka jika i ichi ya. Tukaa ka kuu i nanu ndɨyɨ, chi suꞌva ja ni ka nachaku i kanchuku i jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Siaꞌan saꞌa Yandios jiin Seꞌe ya vanuxia ɨɨn ni kuu seꞌe ya jiin maa ya. Ti kaꞌnu ɨɨn jniñu saꞌa Yandios chi saꞌa ya ja na kuchaku yɨvɨ naa i. Ti nanu saꞌa maa Yandios suni siukan saꞌa Seꞌe ya, chi saꞌa ya ja na kuchaku yɨvɨ naa i ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sɨkɨ ja ɨɨn ni kuu Yandios jiin Seꞌe ya, yukan kuu ja ni jaꞌa ya jniñu nuu Seꞌe ya, chi maa ya kuu maa Seꞌe Yɨvɨ Ñuyɨvɨ. Ti nanduku vindaa ya kuachi sɨkɨ yɨvɨ naa i nuu nasa iyo. Ti maa Seꞌe ya na kachi nau kuu yɨvɨ ni ka jnaꞌnu ndatu, ti nau kuu yɨvɨ ni ka nitaꞌu. Ti xndichi ndaa kuɨtɨ ya yɨvɨ naa i, chi maa ya kuu Seꞌe Yɨvɨ Ñuyɨvɨ, ti maa Tata ya ni jaꞌa jniñu un nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Koto ma naa ini ra ɨɨn jnuꞌun kaꞌan ri jaꞌa sɨkɨ jniñu ndiso ri, ja ɨɨn ni kuu ri jiin Tata ri Yandios, chi nu na jaa kɨvɨ, ti taka ndɨyɨ ka ñunduji un kunisoꞌo i jnuꞌun kaꞌan Seꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Yukan na ti taka yɨvɨ ni ka saꞌa ja vaꞌa, nandoto i ti kunchuku i jiin Yandios. Ti taka yɨvɨ ni ka saꞌa ndevaꞌa un suni nandoto i, ko kɨvɨkoyo i nuu jnaꞌnu ndatu i naa i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ni siin Jesús kaꞌan ya jiin chaa hebreo ka kuñaꞌnu un, ti ni kachi ya: ―Siuku ndaa kuɨtɨ ri taka nava kuni maa Tata ri Yandios, chi tu iyo ni ɨɨn ja saꞌa ri ja kuu ini maa ri. Ti xndichi ndaa ri yɨvɨ naa i siaꞌan nava ni kachi maa Tata ri. Siaꞌan xndichi ri yɨvɨ, chi tu saꞌa ri nava kuu ini maa ri. Chi suꞌva siuku ri nava kuu ini maa ya, chi ja sɨkɨ yukan ni taji ya ruꞌu vaji ri nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ko nu na kaꞌan ri ja ndoꞌo ini maa ri, ti kaꞌan ri ja kusɨɨ ini ri, yukan na ti kachi ra ja tu nijniñu kuɨtɨ jnuꞌun kaꞌan ri, chi tu iyo ɨnga ja kuaꞌa jandaa jaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ko iyo ɨnga ja ndakuniꞌin ruꞌu ti kachi nau ja kuu ri, ti kaꞌan ndaa chaa un chi jini da ruꞌu. Ti jini ri ja iyo ndaa jnuꞌun kaꞌan chaa un ti niꞌin jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Maa ra naa ra, ni ka taji ra chaa ni ka jaꞌan kajnuꞌun Juan, chaa ni skuanducha un. Ti chaa un, ni kachi ndaa kuɨtɨ ni da ja kuu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ti vasu siaꞌan ko tu nandɨꞌɨ ri ja ɨnga yɨvɨ kachi nasa jniñu saꞌa ri. Siaꞌan kaꞌan ri ja na kundaa jnuꞌun ni kaꞌan Juan sɨkɨ maa ri nava na kandixia ra taka jnuꞌun ni kaꞌan da un, ti nava na kuu nama ra maa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saꞌa yo nanu Juan ni kuu da nanu ɨɨn ñuꞌun ja ni ndinchaa nuu ñuñaa, chi ni xnaꞌan ndaa da ichi Yandios nuu yɨvɨ. Ko jaku ni kɨvɨ ni ka chiñuꞌun ra jnuꞌun ni xnaꞌan da un. Vanuxia yukan ni kuu ɨɨn jniñu ni saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ti kuaꞌa ni kuu ɨɨn jnuꞌun ni ndakuniꞌin Juan sɨkɨ maa ri. Ko kaꞌnu ga kuu jnuꞌun kaꞌan maa Tata ri jaꞌa ri, chi ni jaꞌa ya jniñu ñaꞌnu nuu ri. Yukan na ti kuni ndaa ra nau ja kuu ruꞌu, ti kuni ndaa ra ja maa Tata ri ni taji ya ruꞌu vaji ri, chi saꞌa ri jniñu ñaꞌnu ni jaꞌa ya nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata ri ni taji ruꞌu, ti stuu kaji ya taka nau ja kuu ri. Ni kachi kaji ya nau ja kuu ruꞌu, vasu tu ni ka jini ra jiin nuu ra nuu Tata ri, ti ni tu ni ka jinisoꞌo ra ndusu yuꞌu maa ya. Ko jandaa kuu ja ni tu ka chuꞌun ini ra jnuꞌun kaꞌan Tata ri. Yukan kuu ja tu ka kandixia ra ja kaꞌan ɨɨn Chaa ni taji maa Tata yo Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ni tu ka chuꞌun ini ra jnuꞌun ni kaꞌan Tata ri. Ti ni tu ka kandixia ra Ɨɨn ja ni taji maa ya. Tu ka kandixia ra, chi tu ka jantaꞌu ra jnuꞌun kaꞌan maa Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ka skuaꞌa xaan ra tutu ii Yandios ja ni ka chaa yɨvɨ janaꞌan. Ka skuaꞌa xaan ra tutu un, chi ka ndoꞌo ini ra ja jiin yukan ti na nitaꞌu ra ja kunchuku ra jiin ya ja kuu saa ni. Ko maa tutu un kuu ja kaꞌan ndaa sɨkɨ ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ti roꞌo tu ka kuni kuɨtɨ ra kandixia ra ruꞌu nava na ndɨvɨ ra ndaꞌa Yandios ti kunchuku ra jiin ya. Ko ni ka kuu niꞌin xaan tonto ini ra, chi tu ka kuni kandixia ra ruꞌu naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ni siin Jesús kaꞌan ya ti ni kachi ya: ―Tu nandɨꞌɨ ri ja kuaꞌa ra ja yɨñuꞌun ruꞌu. Ni tu nduku ri ja kaꞌan yɨvɨ ja kuñaꞌnu ri nu tu iyo ndaa ini i. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko ruꞌu chi jini vaꞌa ri nasa kaa undi ini jnuni ra. Ti jini ndaa ri ja tu ka iyo ini ra ja chiñuꞌun ra Yandios, ti jini vaꞌa ri chi yɨjiyo ndeꞌe ri roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jini ri ja tu ka jantaꞌu ra ruꞌu. Ko maa ri kuu, ni chaa ri nuu ñuyɨvɨ jaꞌa ti ndaku niꞌin ri jnuꞌun kaꞌan Tata ri Yandios. Nu na nakuni ra ruꞌu, ti suni siaꞌan nakuni ra nasa kaa Yandios. Ko sa ti nakuni ra ruꞌu, ti suni nakuni ra ja kuñaꞌnu Yandios nuu tendɨꞌɨ ja iyo. Ti vasu siaꞌan kuu, ko tu ka jantaꞌu ra ruꞌu. Ko nu na kii ɨnga chaa, ti ndakuniꞌin da nanu maa da, ti va kuantaꞌu ni ra chaa yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yukan kuu ja tu kuu nasa kandixia ra ruꞌu, chi niꞌin xaan ka ñukuu ini ra ja na kuantaꞌu ɨɨn yɨvɨ roꞌo, ti ansu ja na kuantaꞌu maa Yandios roꞌo naa ra. Viꞌi ga ka nakutu ini ra ja, nakuaꞌa ja yɨñuꞌun nuu jnaꞌan maa ra, ko tu ka nakutu ini ra ja na nakuantaꞌu maa Yandios roꞌo naa ra. Yukan kuu ja tu kuu nasa kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ti vasu siaꞌan iyo, ko tu kani ini ra ja kankuachi ri sɨkɨ ra nuu Tata yo Yandios. Ko ley ni jaꞌa Yandios nuu Moisés, yukan kuu ja kankuachi sɨkɨ ra naa ra. Ti jandaa ndixia kuu, chi vasu ka ndoꞌo ini ra ja ka iyo ndoo ra nuu Yandios, ko so ja ka siuku ra ley Moisés ti ka ndoꞌo ini ra siaꞌan. Ko jiin yukan ti ja kankuachi Moisés sɨkɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ko nu ka kandixia ndaa ra jnuꞌun Moisés, ti suni kandixia ndaa ra ruꞌu niku. Chi vanua undi na janaꞌan xaan ni chaa da tutu nuu kaꞌan sɨkɨ ruꞌu ja chaa ri nuu ñuyɨvɨ kɨvɨ vijna. ");
INSERT INTO mpmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ko roꞌo tu ka ñukuu ndaa ini ra jnuꞌun ni chaa Moisés. Yukan kuu ja tu kuu nasa kandixia ra jnuꞌun kaꞌan ri vijna. Tu kuu kuɨtɨ ―ni kachi Jesús jini chaa hebreo ka kuñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yukan na ti sa kuaꞌan Jesús jiin chaa ka skuaꞌa jiin ya ichi ɨnga yuꞌu mini Galilea. Ti mini un suni nani mini Tiberias. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kuaꞌa xaan yɨvɨ ni ka ndikun i Jesús, chi ni ka jini i taka jniñu ñaꞌnu saꞌa ya. Ni saꞌa ya jniñu ñaꞌnu xaan ga, chi ni saꞌa ya ja ni ka nduvaꞌa yɨvɨ ka kuꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yukan ti kuaꞌan Jesús jiin ndajaꞌa ya, ni ndaa ya ɨɨn yuku, ti yukan ni jakuɨñɨ ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ti ja kuan kuyajni kɨvɨ viko Pascua ka nasaꞌa yɨvɨ hebreo, ja ka nukuꞌun ini i kɨvɨ ni ka kekoyo i nuu ñuꞌun nación Egipto na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ni jitonuu Jesús ti ni jini ya ja kuaꞌa xaan yɨvɨ ni ka kaa kuankoyo. Ti ni kachi ya jiin Felipe: ―¿Nanu kin kuaan yo ja kaji yɨvɨ jaꞌa naa i? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Siaꞌan ni ni kaꞌan ya, chi kuni ya ja na ndee nu nasa kaꞌan Felipe nu kandixia ndaa da maa ya xi tuu, vanuxia ja jini vaꞌa maa ya nasa saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ti ni kachi Felipe jiin ya: ―Nu na kuaan yo uu ciento xuꞌun staa, ti ni tu kujaa ja kaji yɨvɨ jaꞌa, vasu ni ɨɨn tɨꞌlɨ ɨɨn ɨɨn yɨvɨ naa i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ti ɨnga ndajaꞌa ya ni kaꞌan da, ti chaa un kuu Andrés, ñani Simón Pedro. Ti kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Chukan kande ɨɨn chaa lulu, ndiso da uꞌun staa stila cebada jiin uu chāká. Ko yukan tu kujaa chi kuaꞌa xaan yɨvɨ naa i ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yukan na ti ni taꞌu Jesús jniñu nuu ndajaꞌa ya: ―Kachi jini yɨvɨ ja na nukoo i nuu icha jña naa ra ―ni kachi ya. Ti yukan mani icha kuii kuu, ti yukan ni ka nukoo yɨvɨ naa i. Ti va ka iyo uꞌun mil niña kuɨtɨ chaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ti ni kiꞌin Jesús ndɨ uꞌun staa yukan, ti ni nakuantaꞌu ya nuu Yandios. Ti ni jaꞌa ya nuu ndajaꞌa ya ja na tejnaꞌan da nuu yɨvɨ kanchuku yukan. Suni siaꞌan ni saꞌa ya jiin chāká un, ti jiin yukan ni ni ka yaji vaꞌa yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nu ni kuu ni ka yaji vaꞌa yɨvɨ un staa, ti ni kachi Jesús jiin ndajaꞌa ya: ―Nastutu pedazu ni kendoso jña, nastutu ra chi tu stɨvɨ yo naa yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ni ka nastutu da, ti ni chitu uxi uu chika jiin pedazu staa un. Siaꞌan chika ni ndututu vasu uꞌun ni jnaꞌan staa ni tejnaꞌan Jesús, ko uxi uu chika pedazu staa un ni kendoso. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nu ni ka jini yɨvɨ jniñu ñaꞌnu ni saꞌa Jesús yukan, so ni ka naa ini i, ti ka kaꞌan jiin jnaꞌan i: ―Va ndaa ndixia ja chaa jaꞌa kuu ja kaꞌan nuu tutu ii Yandios, ja kii ɨɨn profeta nuu ñuyɨvɨ, kii kaꞌan da jnuꞌun ya ―ni ka kachi yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yukan ti ni jinijnuni maa Jesús ja ka kuni yɨvɨ kin kiꞌin i ya, ti chayɨka i ya ja na kuu ya rey, ti na taꞌu ya jniñu nuu i naa i. Yukan kuu ja ni kaa ga Jesús kuaꞌan ya undi xini yuku un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ja kuan ini, ti chaa ka skuaꞌa jiin Jesús, ni ka nuu da jaꞌa yuku un, ti ni ka najakoyo da yuꞌu mini un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ni ka kɨvɨ da barco, ti kuankoyo da ichi ɨnga nuu yuꞌu mini undi ñuu Capernaum. Ni kuu ñaa, ti tujaꞌi najaa Jesús nuu kaꞌiin da un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ti ni jakunchaa ɨɨn tachi xaan, ja ni kejaꞌa saꞌiyo nuu nducha mini un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ti va sa uꞌun xi iñu ni mil metro kuu ja ni ka jika da jiin barco da, ti ni ka jini da jika Jesús kuaja ya nuu nducha mini un, kuan kuyajni ya nuu barco un. Ti chaa un ni kejaꞌa ka yuꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ti ni kachi maa Jesús jiin da naa da: ―Koto yuꞌu ra naa ra chi maa ri kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yukan na sa ni ka ndusɨɨ ini da ja ni kɨvɨ Jesús ini barco un. Siaꞌan na sa ni ka jakoyo yachi da nuu kuankoyo da un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ni kuxian ɨnga kɨvɨ, ti yɨvɨ kuaꞌa ni ka kendo i ɨnga nuu yuꞌu mini un. Ni ka jini i ja ɨɨn ni barco ni kunde yuꞌu mini un. Ti suni ni ka jini i ja ndajaꞌa Jesús ni ka kɨvɨ da barco un ti kuankoyo da. Ko ni ka jini vaꞌa i ja tu ni kɨvɨ Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ti yukan kaꞌiin tɨjnɨ ga barco ja ni ka jakoyo ichi ñuu Tiberias, ni ka jakoyo yajni nuu ni nakuantaꞌu Jesús nuu Yandios, na ni jaꞌanya staa ni ka yaji yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ni ka jini yɨvɨ ja tu kande Jesús yukan, ti suni ni ka jini i ja, ja kuankoyo ndajaꞌa ya. Yukan kuu ja ni ka kɨvɨ i barco ti kuankoyo i undi ñuu Carpernaum, kuan nunduku i Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ni ka jakoyo yɨvɨ naa i undi ɨnga yuꞌu nducha un, ti yukan ni ka nakejnaꞌan i jiin Jesús. Ti ka jikajnuꞌun i ya: ―Maestro, ¿na hora ni chaa ni jaꞌa? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ti ni kachi Jesús: ―Jandaa na kachi ri jiin ra naa ra ja ka nanduku ra ruꞌu, ko ansu ja ni ka chaku ini ra nasa kuni kaꞌan jniñu ñaꞌnu un, chi ka nanduku ra ruꞌu, ko sɨkɨ ja ni jaꞌa ri staa ni ka yaji ra undi ni ka chitu vaꞌa chii ra, yukan kuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ko ɨɨn ja yaji yo, tu kuñɨɨ. Ti na kachi ri jiin ra ja koto nakutu ini ra so nɨnɨ ja kuu ja kaji ra nuu ñuyɨvɨ jaꞌa. Chi suꞌva ja na nakutu ini ra ja na kendo ndaa ra nuu Yandios, nava na kunchuku ra jiin ya ja kuu saa ni. Ti yukan kuu ja kuaꞌa maa chaa kuu Seꞌe Yɨvɨ Ñuyɨvɨ nuu ra naa ra. Chi maa Tata yo Yandios, ni jaꞌa ya jniñu jaꞌa nuu Seꞌe ya ja na nakuni ra naa ra nau kuu ya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yukan na ti ni ka jikajnuꞌun tuku i Jesús: ―¿Nau ja saꞌa na ja siuku na jniñu kuni maa Yandios nusa? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ti ni kachi Jesús: ―Maa Yandios ni taji ya ɨɨn vanuxii ni chaa vaji nuu kancha maa ya. Ti nu na kandixia ra un, yukan ni kuu ja kuni maa Yandios ja na siuku ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ti ni ka kachi yɨvɨ un jiin ya: ―¿Nau ɨɨn jniñu ñaꞌnu saꞌa ni nusa? Nu na saꞌa ni ɨɨn jniñu nuu na ja na ndeꞌe na jiin nuu na, yukan ti sa na kandixia na. ¿Ko nau ɨɨn ɨɨn jniñu ñaꞌnu saꞌa ni nusa? ");
INSERT INTO mpmNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chi chaa ni ka kuu jnaꞌan tata na na janaꞌan, ni ka yaji da ɨɨn nuu staa ja ni nani “maná”, ja ni jaꞌa maa Yandios nuu da naa da. Ni ka yaji da maná un nuu ñuꞌun teꞌe nanu kaꞌan nuu tutu Yandios, ja kachi: “Ni jaꞌa ya staa ni ka yaji yɨvɨ. Ja ni kuun ichi andɨvɨ.” Siaꞌan kaꞌan nuu tutu Yandios ―ni ka kachi yɨvɨ un jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti ni kachi Jesús jiin yɨvɨ un naa i: ―Na kachi ndaa ri nuu ra ja ansu Moisés ni jaꞌa ja ni ka yaji yɨvɨ na janaꞌan un, chi maa Yandios ni skuun yukan ni kii ichi andɨvɨ ja na kuchaku yɨvɨ naa i. Ko vijna na ti maa Yandios, ya kuu Tata i, ni taji ya ɨɨn ja kuchaku ra, ti yukan ndixia kuu ja kuaꞌa ja ndendajnu roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chi ja vaji ichi andɨvɨ, yukan saꞌa ja na kuchaku yɨvɨ naa i jiin Yandios. Chi ni kuun vaji ichi andɨvɨ ti ni chaa nuu ñuyɨvɨ ja na kaji yɨvɨ naa i, nava siaꞌan na nakuni ndaa i nau kuu ja ni chaa nuu ñuyɨvɨ jaꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yukan ti ni ka kachi tuku yɨvɨ un: ―Taa, kuaꞌa ni ja ni kachi ni yukan na kaji na ndɨ kɨvɨ naa na ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti ni kachi Jesús: ―Maa ri kuu yukan, chi jiin yukan ti kuchaku ra. Ko ruꞌu kuu ja saꞌa ja na kunchuku ra saa ni ga jiin Yandios. Nu na kandixia ra ruꞌu, ti kuu ra nanu yɨvɨ ka ñavaꞌa ndɨꞌɨ ja kaji i jiin ja koꞌo i ja na kuchaku i nuu ñuyɨvɨ jaꞌa. Ti maa ɨɨn ni ruꞌu kuu ja na kandixia ra. Chi tu iyo ɨnga ja saꞌa ja na nduu ra yɨvɨ Yandios ti kunchuku ra jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ja ni kachi ri nuu ra naa ra ja vasu ni ka jini ra jniñu ñaꞌnu saꞌa ri, ko tu ka kuni kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Taka yɨvɨ ja ni nachiꞌi Tata ri ndaꞌa ri ti ja ni kandixia i ruꞌu, yukan kuu ja nakɨndaꞌa ri yɨ. Ti jantaꞌu ri taka yɨvɨ ka kuni kɨvɨkoyo nuu ri, ti tu nataji ri ni ɨɨn yɨvɨ un ja na kiꞌin yɨ, chi sa suꞌva nakinseꞌe ri yɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ti jandaa ndixia kuu chi vaji ri ichi andɨvɨ, ko ve saꞌa ri nava kuni maa ya ni taji ruꞌu, ansu ja saꞌa ri nava kuni maa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ti jniñu kuni Tata ri kuu ja ni ɨɨn yɨvɨ yɨndaꞌa ri, koto ma skuita ri yɨ, ti naa i. Chi sa suꞌva na koto vaꞌa ri yɨ nava naxndoto ri i ja kuu maa kɨvɨ kaꞌnu, kɨvɨ nasaꞌa ndaa maa Yandios kuachi yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ja kuni Tata ri kuu ja na kuchaku siaꞌan ni ga yɨvɨ ka kandixia ndaa maa Seꞌe ya. Nu na jaa maa kɨvɨ kaꞌnu ti xndichi ndaa Yandios yɨvɨ ni ka saꞌa ndevaꞌa. Ti kɨvɨ un naxndoto ri yɨvɨ ka kandixia ja kunchuku i jiin ya ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yukan na ti tu ni ka jajnaꞌan ini chaa hebreo ka kakuñaꞌnu un. Chi ni ka kejaꞌa ka kaꞌan da sɨkɨ Jesús. Ni ka kejaꞌa ka ndajnuꞌun xeꞌe da: ―Tu iyo vaꞌa nava ni kaꞌan Jesús, ndoo kaꞌan da siaꞌan: “Maa ri kuu nanu ɨɨn staa ni kuun ichi andɨvɨ?” Ko tu iyo vaꞌa kuɨtɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chi vanuxia ka jini yo tata da, jiin nana da. Tata da un kuu José, ti maa da nani Jesús. Tu iyo vaꞌa ja kaꞌan da ja ni kii da ichi andɨvɨ ―kachi yɨvɨ un, ka ndajnuꞌun xeꞌe i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yukan sa ni kachi Jesús: ―Koto kaꞌan ra sɨkɨ ri naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tata ri Yandios, ni taji ya ruꞌu ja na kundiso jniñu ri. Ti nu tu kuaꞌa ya inijnuni ra naa ra ti tu kuu kandixia ra ruꞌu. Ko nu na kandixia ra ruꞌu, yukan na ti naxndoto ri roꞌo ja kuu maa kɨvɨ kaꞌnu, kɨvɨ nasaꞌa ndaa maa Yandios kuachi sɨkɨ yɨvɨ ni ka saꞌa ndevaꞌa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Undi na janaꞌan, yoso jnuꞌun Yandios nuu tutu ni ka chaa profeta un naa da ja kachi: “Kuaꞌa Yandios inijnuni nuu tendɨꞌɨ yɨvɨ ja na kandixia i ya”, kachi nuu tutu ya. Yukan kuu ja nu na chunsoꞌo ra jnuꞌun kaꞌan Tata ri, ti nu na saꞌa ra nava kachi ya, yukan na ti nduu ra yɨvɨ ka kandixia ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ti vasu siaꞌan kaꞌan ri, ko ansu kachi ri ja iyo yɨvɨ ni ka jini nuu maa Tata ri. Ko iyo Ɨɨn ja vaji nuu maa ya ja ndiso jniñu. Ti maa Ɨɨn ni yukan kuu ja ni jini nuu maa Tata ya Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ko jandaa kaꞌan ri, ja nu na kandixia ra ruꞌu, yukan na ti kuchaku ra jiin ri ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maa ri kuu nanu staa kaji ra, chi saꞌa ri ja na kuchaku ra saa ni jiin Yandios saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ndeꞌe naa ra. Chaa ni ka kuu tata ra na janaꞌan, ni ka yaji da maná ni jaꞌa Yandios, ko ni jaa kɨvɨ ni ka jiꞌi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko vijna na ti ni taji Yandios Ɨɨn ja kuu nanustaa kaji ra, ti jiin yukan na ti tukaa ga naa ra nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ti maa ri kuu nanu staa yukan, chi nu na kaji ra, yukan na ti tukaa ga kendo ra kunchuku ra nuu ñuyɨvɨ jaꞌa, chi nukoyo ra ti kunchuku ra jiin Yandios ja kuu saa ni. Nu na kuantaꞌu ra ja kuaꞌa ri nuu ra jaꞌa, ti kuchaku ra ja kuu saa ni. Ti staa kuaꞌa ri un, yukan kuu yɨkɨ kuñu maa ri ja chunaa ri nuu yɨvɨ ñuyɨvɨ jaꞌa naa i, nava na ketaꞌu i ti noꞌon i kunchuku i jiin Yandios ―ni kachi Jesús jiin yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yukan na ti ni ka kejaꞌa chaa hebreo ka kuñaꞌnu un ka ndajnuꞌun da, ti ka kaꞌan da: ―¿Nasa kuu ja kachi chaa jaꞌa ja kuaꞌa da yɨkɨ kuñu da un nusa? ¿Xi kuu kaji yo yɨkɨ kuñu da un nu? ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti ni kachi Jesús: ―Jandaa na kachi ri nuu ra naa ra, ja nu tu kaji ra yɨkɨ kuñu maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti nu tu koꞌo ra nɨñɨ da, yukan ti tu najaa ra ja kunchuku ra jiin Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko nu na kaji ra yɨkɨ kuñu ri, ti koꞌo ra nɨñɨ ri, yukan na ti, naxndoto ri roꞌo nu najaa kɨvɨ kaꞌnu ja na saꞌa ndaa Yandios kuachi yɨvɨ, ti sa kuu kɨvɨ ra ti kunchuku ra jiin Yandios ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi nu na kandixia ra jniñu saꞌa ri jiin yɨkɨ kuñu ri jiin nɨñɨ ri. Ti yukan saꞌa ja na kuchaku ra ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu na siuku ra taka yukan, yukan na ti kuncha ri jiin ra, ti maa ra suni kunchuku ra jiin ri, ti ɨɨn ni ga ni ka nduu yo naa yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maa ya ñaꞌnu, ya kuu Tata ri, chaku ya. Ti maa ya kuu ja ni taji ruꞌu jiin jniñu jaꞌa. Yukan kuu ja kancha ri jiin maa ya, ti chaku ri. Ko nu na kɨvɨkoyo ra nu kancha ri, ti kanuu ja na kandixia ra ja ruꞌu kuu nanu staa, ja saꞌa ja na kuchaku ra ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Maa ri kuu ja ni kii ichi andɨvɨ, ti kuu ri nanu staa ja kaji ra naa ra, ko jiin yukan ti tukaa jnaꞌan ra nanu ni ka jnaꞌan yɨvɨ ni ka kuu jnaꞌan ra na janaꞌan. Chi tendɨꞌɨ i ni ka yaji maná, ko ni jaa kɨvɨ nu ni ndɨꞌɨ i ni ka jiꞌi. Ko roꞌo, nu na kinkoyo ra nuu kancha ri, yukan na ti kunchuku ra jiin ri ja kuu saa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Siaꞌan ni kaꞌan Jesús jiin yɨvɨ naa i ini veñuꞌun Israel kande ñuu Capernaum nuu ni skuaꞌa ya jiin yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ko yukan na ti kuaꞌa yɨvɨ ka skuaꞌa jiin Jesús, ni ka jinisoꞌo i jnuꞌun un ja siaꞌan ni kaꞌan ya. Ti ni kejaꞌa ka ndajnuꞌun i: ―Xaan ga yɨɨ iyo jnuꞌun kaꞌan ya, ja tu iyo ni ɨɨn jnuꞌun chaku ini yo ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ko maa Jesús, ni jini ni ya ja siaꞌan ka ndajnuꞌun xeꞌe i ja yɨɨ xaan jnuꞌun ni kaꞌan ya, ti ni kachi ya: ―Tu ni ka chaku ini ra jnuꞌun ni kaꞌan ri un. ¿Ja siaꞌan tu ka jajnaꞌan ini ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Xi nu ka jani ini ra ja yɨɨ xaan jnuꞌun un, ti ¿nasa kachi ga ra nu na kuni ra ruꞌu, ja kuu ri maa Seꞌe Yɨvɨ Ñuyɨvɨ, ndaa ri kinoꞌon ri nuu ni kuncha ri undi nuu nusa? ¿Va nasa kachi ga ra nu siaꞌan nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ko sa ti chaku ini ra nava iyo jnuꞌun kaꞌan ri, yukan na ti sa kuni ndaa ra taka ja saꞌa Espíritu Yandios ja kancha ya jiin ra. Chi yɨkɨ kuñu ra ja ka chaku ra jiin nuu ñuyɨvɨ jaꞌa, yukan tu kuxii chi jaa ɨɨn kɨvɨ ti naa. Ko ja saꞌa maa Espíritu Yandios kuu ja na kuchaku ra ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ko ka iyo sava ra ja tu ka kandixia jnuꞌun un ―ni kachi Jesús jiin yɨvɨ naa i. Siaꞌan ni kaꞌan Jesús chi vanuxia ja jini vaꞌa maa ya nau yɨvɨ kuu ja tu ka kandixia, ti suni ja jini vaꞌa ya nau kuu ja nakuaꞌa ya nuu yɨvɨ ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ni kachi tuku Jesús: ―Ja ni kachi ndaa ri ja maa Tata ri Yandios kuu ja ni nakuaꞌa ya roꞌo ndaꞌa ri. Chi nu tu chindee ya roꞌo, ti ni tu nakuni ra jnuꞌun ja kandixia ra ruꞌu naa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Undi kɨvɨ yukan ti kuaꞌa yɨvɨ ni ka skuaꞌa jiin Jesús, ni ka xndoo i ya. Ti tukaa ni ka siin yɨ jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ni jikajnuꞌun nuu Jesús ndɨ uxi uu ga chaa ka skuaꞌa jiin ya, ti ni kachi ya: ―¿Ti suni ka kuni kinkoyo tu roꞌo jiin yɨvɨ un nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ti ni kachi Simón Pedro: ―Jitoꞌyo. Tu iyo ɨnga nanu ga kiꞌin na. Maa ɨɨn ni niꞌin kuu ja kachi nasa kɨvɨkoyo na ndaꞌa Yandios, ti kunchuku na jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ka kandixia ndaa na maa ni, chi ka jini na ja maa ni kuu Cristo. Maa ni kuu Seꞌe maa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ti ni kachi Jesús jiin da naa da: ―Vasu maa ri ni nakaji ndɨ uxi uu roꞌo ja na kaka ra jiin ri, ko iyo ɨɨn ra ja kuu ɨɨn jaꞌuꞌu. Ɨɨn ra kuu ja kin saꞌa jniñu saꞌa jaꞌuꞌu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Siaꞌan ni kaꞌan Jesús sɨkɨ Judas, seꞌe yɨɨ Simón, chaa ñuu Cariote, chi chaa yukan kuu ja kin nukuaꞌa ya nuu chaa ka jito uꞌu ya. Yukan kuu ja kin saꞌa Judas vasu ni jikonuu jnaꞌan da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ti yukan ni jikonuu Jesús nɨ ñuu Galilea. Tu ni kuni ya kin kuikonuu ya ñuu Judea, chi jnaꞌan ya, yɨvɨ hebreo yukan, ka kuni kaꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kuan kuyajni kɨvɨ ka nasaꞌa yɨvɨ hebreo un viko veꞌe kuii, ti kɨvɨ yukan kuu kɨvɨ ka nukunchuku i veꞌe kuii kachi naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ti ni ka kachi ñani Jesús jiin ya: ―Vaꞌa ga kiꞌin ra ñuu Judea. Vaꞌa ga ja na kin saꞌa ra ɨɨn jniñu ñaꞌnu yukan ti nava na kandixia ndaa ga yɨvɨ yukan ti na kundikun i roꞌo, ti nava na kuni i naa jniñu saꞌa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","¿Xi iyo vaꞌa ja saꞌa xeꞌe ra jniñu un nu? Ko nu kuni ra ja na kuni yɨvɨ roꞌo ti na kuantaꞌu i roꞌo, ti kuan saꞌa ɨɨn jniñu ñaꞌnu nuu chitu yɨvɨ un naa i ―ni ka kachi da jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Siaꞌan ni ka kaꞌan ñani ya jiin ya, chi ni maa ñani ya tu ka kandixia da ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yukan ti ni kachi Jesús: ―Ti jaa ga kɨvɨ kiꞌin ri. Ko vaꞌa roꞌo naa ra, chi kuu kinkoyo ra na kɨvɨ ka kuni maa ra, ");
INSERT INTO mpmNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","chi tu ka kuɨtɨ ini yɨvɨ un nuu ra. Ko ruꞌu, chi ka kuɨtɨ ini i ka jito uꞌu i ruꞌu, chi vanua kaꞌan kaji ri nuu i nava kanda i jiin taka jniñu kueꞌe ka saꞌa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kuankoyo viko un naa ra. Ruꞌu tu kiꞌin ri, chi tujaꞌi jaa kɨvɨ ja kuni yɨvɨ kuaꞌa un nau ja kuu ruꞌu. Yukan kuu ja tujaꞌi jaa kɨvɨ ja kiꞌin ri un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Siaꞌan ni kaꞌan Jesús jiin da naa da, ti ni kendo ya nuu ñuꞌun ñuu Galilea. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kuankoyo ñani Jesús viko un naa da. Yukan na ti sa kuaꞌan maa Jesús suni. Tu ni ka jini yɨvɨ ja kande ya yukan, chi tu ni stuu ya maa ya. Tu ni jaꞌan ya jiin taka ga yɨvɨ Galilea un. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ko ka nanduku chaa hebreo ka kuñaꞌnu un maa ya nuu viko un, ti ka kaꞌan da naa da: ―¿Nanu kande chaa yukan nusa? ―kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ti yɨvɨ kaꞌiin yukan ka ndakuniꞌin xaan i jnuꞌun Jesús. Sava i ka kaꞌan: “Chaa vaꞌa kuu chaa un.” Ko sava ga i ka kaꞌan: “Tuu, chi so xndaꞌu da yoꞌo”, ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko so ja tu ka stuu ndijin i jnuꞌun Jesús, chi ka yuꞌu i sa kuɨtɨ ini chaa hebreo ka kuñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ja ni kuu sava viko, ti sa ni kenda Jesús, ni kaa ya kuaꞌa ya yuxeꞌe veñuꞌun kaꞌnu un, ti ni kejaꞌa xnaꞌan ya nuu yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ti so ka naa ini chaa hebreo ka kuñaꞌnu un, ti ni ka kachi da: ―¿Nasa kuu ja xaan ndichi kaꞌan chaa jaꞌa jnuꞌun un, ti tu ni skuaꞌa da? ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ti ni kachi Jesús jiin da: ―Jnuꞌun xndaku ri nuu ra naa ra jaꞌa, ansu ja kuu ini maa ri ti kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taka jnuꞌun xnaꞌan ri jaꞌa, ansu jnuꞌun ndoꞌo ini maa ri kuu. Ti nu ka ndiyo ini ra ja siuku ra jniñu kuni Yandios, yukan ti sa nakuni ra ruꞌu, ja kaꞌan ri niña jnuꞌun ni jaꞌa maa Yandios nuu ri, ti tu kaꞌan ri jnuꞌun ja jani ini maa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Chi nu na kaꞌan vixi ɨɨn yɨvɨ ja kuu maa i, ti jandaa ni kuu ja nduku i ja na nakuaꞌa yɨvɨ ja yɨñuꞌun nuu i. Ko ruꞌu, chi suꞌva kuni ri ja na nakuaꞌa i ja yɨñuꞌun nuu maa Yandios, chi maa ya ni taji ruꞌu ti ndiso jniñu ri nuu ya. Yukan kuu ja kaꞌan ri niña jnuꞌun ndaa, ti tu jajnaꞌan ini ri xndoñaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ka kaꞌan vixi ra ja Moisés kuu ja ni jaꞌa Ley Yandios nuu ra naa ra. Ti nu jandaa kuu, ¿ndoo kuu ja ni ɨɨn ra tu ka kuni siuku Ley yukan nusa? ¿Xi ndoo kuu ja ka kuni kaꞌni ra ruꞌu, ti ruꞌu kuu ja kaꞌan jnuꞌun Yandios nuu ra naa ra jaꞌa? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ti ni ka na ndeokani yɨvɨ un siaꞌan: ―Ja kaꞌan ra siaꞌan va kancha ɨɨn tachi uꞌu jiin ra. ¿Xi nau chaa kuu ja ka kuni kaꞌni roꞌo nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ti ni kachi Jesús: ―Ni saꞌa ri ɨɨn jniñu ñaꞌnu ja ni kuu ɨɨn kɨvɨ ndetatu, ti yukan ni kuu ja ni ka jini ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ni xndoo Moisés ɨɨn jnuꞌun ja na saꞌa ra ɨɨn seña nuu yɨkɨ kuñu suchi yɨɨ kuachi vasu ɨɨn kɨvɨ ndetatu. Ko ansu maa Moisés ni saꞌa yukan, chi undi janaꞌan ga vaji jnuꞌun un ja kuu ley ni jaꞌa Moisés ja kuu kɨvɨ ndetatu. Ti siaꞌan ka siin tu roꞌo naa ra, chi ka saꞌa ra jniñu un vasu ɨɨn kɨvɨ ndetatu. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka siin ra jnuꞌun un naa ra, vasu ɨɨn kɨvɨ ndetatu, chi ka ndiyo ini ra ja siuku ra Ley Moisés. Ko suꞌva ni ka kuɨtɨ ini ra nuu ri ja ni saꞌa ri tajna ɨɨn yɨvɨ kuꞌu ja ni kuu kɨvɨ ndetatu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ti siaꞌan ka kankuachi ra sɨkɨ ri naa ra. Ko na kachi ri ja tukaa ga kani ini ra siaꞌan, chi suꞌva kani ini nu ka siuku ndaa yɨvɨ naa i xi tu. Yukan kuu ja koto ma kankuachi ra sɨkɨ yɨvɨ nu tu ka iyo kuachi i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yukan na ti sava yɨvɨ ñuu Jerusalén un, ka jikajnuꞌun jnaꞌan i: ―¿Ti ansu chaa jaꞌa kuu ja ka nanduku chaa ka kuñaꞌnu un ja kaꞌni da nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ko jaꞌa ni kancha da ti kaꞌan da nuu chitu un, ¿ti ndoo tundo ka saꞌa chaa ka kuñaꞌnu un jiin da nusa? ¿Ndoo tu ka jasɨ da ja kaꞌan chaa jaꞌa? Va xi ka ndoꞌo ini chaa ka kuñaꞌnu un ja maa chaa jaꞌa kuu Cristo ja ni taji Yandios, ja na saꞌa jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko yoꞌo chi ka jini vaꞌa yo nanu vaji chaa jaꞌa. Ko kɨvɨ na chaa Cristo ti ni ɨɨn yo tu kuni na ichi kii ya ―ni ka kachi yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ti yukan ni kaꞌan jaa Jesús nuu ni xnaꞌan ya yuxeꞌe veñuꞌun un, ti ni kachi ya: ―¿Va nu ja ka jini ra nau ja kuu ri nu? ¿Xi ka jani ini ra ja nanu vaji ri xino? Ko ansu vaji ri ti kancha ri ñuyɨvɨ jaꞌa ja so ja kuu ini maa ri. Ti ansu siaꞌan kuu. Chi suꞌva maa Yandios, ni kuu ini ya ja ni taji ya ruꞌu. Ti roꞌo naa ra tu ka jini kuɨtɨ ra nasa kaa Yandios, ti ni tu ka jini ra nasa kaa jniñu saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ko ruꞌu, chi jini vaꞌa ri nasa kaa Yandios, chi vaji ri undi nuu kancha maa ya. Maa ya kuu ja ni taji ruꞌu vaji ri, ti ndiso jniñu ri nuu ya ―ni kachi Jesús nuu yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yukan na ti ni ka nduku da nasa jnɨɨ da ya ti chondee da ya vekaa. Ko ni ɨɨn da tu ni kuu jnɨɨ da ya naa da, chi vanuxia tujaꞌi jaa maa kɨvɨ ni kachi maa Yandios ja kuu ya. Tujaꞌi jaa hora ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ti kuaꞌa xaan yɨvɨ kaꞌiin yukan ni ka kandixia i ya, ti ni ka kejaꞌa ka kaꞌan i: ―Jandaa ndixia kuu ja chaa jaꞌa kuu Cristo ni taji Yandios ja saꞌa jniñu ñaꞌnu, chi kaꞌan ɨɨn jnuꞌun ja siaꞌan saꞌa Cristo nu na chaa ya. Ti va tu nau ɨnga jniñu saꞌa Cristo ja tu kuu saꞌa chaa jaꞌa ―ni ka kachi yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yukan na ti chaa fariseo un jiin sutu ka kuñaꞌnu un, ni ka taji da policía ka ndito veñuꞌun un, ja na kin jnɨɨ da Jesús. Chi ni ka jinisoꞌo chaa fariseo un ja ka jantaꞌu yɨvɨ jnuꞌun kaꞌan ya. Yukan kuu ja ni ka taji da policía ja na jnɨɨ da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti ni kachi Jesús: ―Jaku ni ga kɨvɨ kuncha ri jiin ra naa ra. Yukan na ti kinoꞌon tuku ri nuu kancha ɨɨn ja ni taji ruꞌu vaji ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kɨvɨ jña ti nanduku ra ruꞌu, ko tu naniꞌin ra ruꞌu. Ti ni tu kuu jakoyo ra nuu kiꞌin ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yukan ti chaa hebreo ka kuñaꞌnu un, ni ka kejaꞌa ka jikajnuꞌun jnaꞌan da, ti ka kachi da: ―¿Nachi kiꞌin chaa jaꞌa ja tu kuu naniꞌin yo da nusa? ¿Xi kiꞌin da ɨnga nación nuu kanchuku jnaꞌan yo hebreo jiin yɨvɨ Grecia un nu? ¿Xi kin skuaꞌa da jiin yɨvɨ ñuu jika un nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ti na jnuꞌun kuu ja ni kaꞌan da ja kachi da ja nanduku yo da ti tu naniꞌin yo da, ti ni tu kuu kinkoyo yo nuu kande da un nu? Tu chaku ini yo ndo kuni kaꞌan chaa un ja kaꞌan da siaꞌan ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kɨvɨ ni ndɨꞌɨ viko un ni kuu ɨɨn kɨvɨ kaꞌnu ga, ni jakuɨñɨ Jesús ti ni kaꞌan jaa ya nuu yɨvɨ kaꞌiin yukan, ti ni kachi ya: ―Nu nau roꞌo ka ichi nducha naa ra, ñaꞌan nuu ri jaꞌa ti na kuaꞌa ri nducha koꞌo ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nu nau ɨɨn yɨvɨ na kandixia ruꞌu, jankɨvɨ ga kendoꞌo jnuꞌun ri kiꞌin, chi jankoo ini añu i, ti kuñɨɨ ja kuu saa ni. Kuu ini i nanu ɨɨn yucha kaꞌnu nu jika ni ga nducha ti jankɨvɨ ichi ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Siaꞌan ni kaꞌan Jesús jnuꞌun sɨkɨ Espíritu Santo, chi ni kachi ya nasa kuu kuncha Espíritu jiin yɨvɨ kandixia maa ya. Ko vanuxia tujaꞌi chaa Espíritu Santo, chi tujaꞌi ndaa maa Jesús andɨvɨ nuu nduñaꞌnu ya. Yukan kuu ja tujaꞌi chaa Espíritu Santo ja kuncha ya jiin yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sava yɨvɨ kuaꞌa kaꞌiin un ni ka jinisoꞌo i jnuꞌun, ni kaꞌan Jesús, ti ni ka kachi i: ―Jandaa ndixia kuu ja chaa yukan kuu maa Profeta ja kaꞌan jnuꞌun vaji undi nuu maa Yandios ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","―Chaa jaꞌa kuu maa Cristo ja ni taji Yandios, chi ndiso ya ɨɨn jniñu ñaꞌnu ―ni ka kachi i. Ko sava ga i ni ka kachi: ―Tuu, chi ansu ñuu Galilea kii Cristo. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chi kachi nuu tutu Yandios ja Cristo kuu ɨɨn jnaꞌan tata yo David, chaa ni kuu rey undi na janaꞌan. Ti kaku ya ñuu Belén, ñuu nuu ni kaku maa tata yo David undi na janaꞌan xaan tonto ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ti yukan ni ka kuu sava yɨvɨ un, chi tu ni kejnaꞌan ɨɨn nuu ini i sɨkɨ ja nanu vaji Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sava i ka kuni jnɨɨ i ya ja na kiꞌin ya vekaa, ko ni ɨɨn i tu ni ka tava ini ja jnɨɨ i ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tu ni ka jnɨɨ policía un Jesús. Vaꞌa ga ja ni ka nandeokuñɨ da nuu chaa fariseo un jiin sutu ka kuñaꞌnu un, ti chaa un ni ka jikajnuꞌun da policía un: ―¿Ndo tu ni ka kii ra jiin chaa un? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ti ni ka kachi policía un: ―Tuu, chi jnuꞌun kaꞌan da un, tu ni ɨɨn chaa kaꞌan nanu kaꞌan chaa yukan ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ti ni ka kachi chaa fariseo un: ―¿Xi suni ja ni xndaꞌu chaa un roꞌo naa ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ko ni ɨɨn jnaꞌan yo tu ka kandixia chaa un. Ni ɨɨn yoꞌo ja ka kuñaꞌnu jiin chaa fariseo, tu ka kandixia da naa da. ¿Ti roꞌo, xi ja ni ka kandixia ra chaa un naa ra nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ti yɨvɨ kuaꞌa un chi tu ka jini vaꞌa i ley yo naa yo nanu maa ra naa ra, ti ka kuu i nanu yɨvɨ ni ka jnaꞌnu ndatu. Tu ka jini kuɨtɨ i nava ka saꞌa i ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ti suni yukan kande Nicodemo nuu ni ka ndututu chaa un. Kuu da ɨɨn chaa kuñaꞌnu nuu yɨvɨ hebreo, ja ɨɨn jakuaa ni jaꞌan kaꞌan da jiin Jesús. Ni ndokuɨñɨ da ti ni kachi da jiin naꞌan da un: ");
INSERT INTO mpmNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Kachi Ley yo ja tu kuu kankuachi yo sɨkɨ ɨɨn chaa, nu tu kunsoꞌo yo xnaka na jnuꞌun kaꞌan da, nava siaꞌan ti sa kuni yo na kuachi ni saꞌa da ―ni kachi Nicodemo. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ti ni ka kachi chaa un naa da: ―¿Va nu suni chaa ñuu Galilea kuu tu roꞌo? Nanduku vii ndaa nuu tutu Yandios, ti kuni vaꞌa ra ja ni ɨɨn chaa kaꞌan jnuꞌun Yandios, tu kenda kuɨtɨ ñuu Galilea ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yukan na ti ndɨ ɨɨn ndɨ ɨɨn da ni ka nakiꞌin ichi, ti kuan nukoyo da veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yukan na ti kuaꞌa Jesús ichi yuku Olivos. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yukan ti jañaꞌan ɨnga kɨvɨ, ti ja ni najaa tuku ya veñuꞌun kaꞌnu un. Kuaꞌa yɨvɨ ni ka ndututu tuku nuu kande ya. Ni nukoo ya ti ni kejaꞌa skuaꞌa ya jiin yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yukan ti chaa ka xnaꞌan ley Israel jiin chaa fariseo un, ni ka yɨndaꞌa da ɨɨn ñasɨꞌɨ nuu Jesús. Ni ka jnɨɨ da ñaꞌan un nuu kande ña jiin ɨnga chaa. Ni ka jani da ña sava maꞌñu yɨvɨ kaꞌiin nuu Jesús un, ");
INSERT INTO mpmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ti ni ka kachi da jiin ya: ―Maestro, ni ka jnɨɨ na ña jaꞌa maa hora kande ña jiin chaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti nu ɨɨn ñaꞌan saꞌa siaꞌan kachi nuu ley Moisés ja na kuaꞌa yo yuu xini ña nava na kuū ña. Yukan kuu ja kaꞌan ley ni jaꞌa Moisés, chaa ni kuu tata yo na janaꞌan. Ti niꞌin, ¿nasa kachi ni? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Siaꞌan ni ka kachi da ja na ndenu nasa kachi ya, nu kuantaꞌu ya nava kaꞌan ley un xi tuu. Ti nu tuu, ti kankuachi da sɨkɨ ya. Yukan ti ni jankuitandijin Jesús, ti kejaꞌa saꞌa ya letra nuu ñuꞌun jiin xini ndaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko maa da ka kaꞌan ka kaꞌan da. Ni ndokuɨñɨ Jesús, ti ni kachi ya: ―Nuu nau ɨɨn roꞌo ndoꞌo ini ja tu na kuachi ra iyo, kanduu ti kiꞌin ɨɨn yuu ti kuaꞌa ra xini ña ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yukan ti ni jankuitandijin tuku Jesús, ti saꞌa ya letra nuu ñuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ko nu ni ka jinisoꞌo da ja siaꞌan ni kaꞌan Jesús jiin da, ni ka kukanuu da, ti ndɨ ɨɨn ndɨ ɨɨn da ni ka kekoyo kuaꞌan. Xnakan chaa ñaꞌnu ga ni kenda kuaꞌan, siaꞌan undi ni ndɨꞌɨ da kuankoyo. Yukan ti ni kendo ma ɨɨn ni ga ñaꞌan un jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ni ndokuɨñɨ Jesús, ti ni kachi ya jiin ña: ―Roꞌo ñasɨꞌɨ, ¿vanu ja kuankoyo chaa ka kankuachi sɨkɨ ra un? ¿Vanu tukaa ni ɨɨn chaa kankuachi sɨkɨ ra nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ti ni kachi ña: ―Tukaa ni ɨɨn da, taa ―ni kachi ña. Ti ni kachi Jesús: ―Ni ruꞌu tu kuu kankuachi ri sɨkɨ ra. Kuaꞌan ti koto saꞌa ga ra kuachi un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ni kaꞌan tuku Jesús jiin yɨvɨ ni ka ndututu veñuꞌun kaꞌnu un, ti ni kachi ya: ―Maa ri kuu nanu ñuꞌun ja ndinchaa ichi yɨvɨ kanchuku nuu ñuyɨvɨ jaꞌa. Nu na kandixia ra ruꞌu, ti tukaa kaka ra ichi ñuñaa. Chi kuncha ri jiin ra, ti kuu ri nanu ñuꞌun ja ndinchaa, nava na kuni ra na ichi kiꞌin ra. Nava tukaa ga kiꞌin ra ichi ñuñaa un, chi ja ni ka ndundijin nuu ra. Siaꞌan ti niꞌin ra ja kuchaku ra ja kuu saa ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ti ni ka kaꞌan chaa fariseo un jiin ya: ―Roꞌo, chi kaꞌan ra ja kuu maa ra. Ja siaꞌan kuu ja tu kaꞌan ndaa kuɨtɨ ra ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ti ni kachi Jesús: ―Vasu kaꞌan ri ja kuu jnuꞌun maa ri, ti jandaa kuu, chi jini ndaa ri nanu vaji ri, ti jini ndaa ri nuu kiꞌin ri. Ko roꞌo, tu ka jini ra nanu vaji ri ti ni nanu kiꞌin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Roꞌo naa ra, chi ka kaꞌan ra ja jnaꞌnu ndatu ri, ko so ka kaꞌan ra ja ka ndoꞌo ini maa ra. Ko ruꞌu, nu kachi ri ja jnaꞌnu ndatu yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko nu na nasaꞌa ndaa ri jiin yɨvɨ naa i, yukan na ti kundaa ndixia taka jnuꞌun kaꞌan ri. Ka iyo uu ja xndichi yɨvɨ. Maa ri kuu ja xndichi ri yɨvɨ jiin maa Tata ri, chi maa ya kandichi jiin ri, ti ni taji ya ruꞌu jiin jniñu jaꞌa vaji ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ti nu ley ra yoso ja nu ka iyo uu chaa ka jaꞌa jandaa, ti nu ni kejnaꞌan jnuꞌun ka kaꞌan chaa un naa da. Yukan na ti ni jini yo ja iyo ndaa jnuꞌun kaꞌan ka kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yukan kuu ja maa ni ri kuu ja kaꞌan ja kuu maa ri. Ti ɨnga ja jaꞌa jandaa jaꞌa ri kuu maa Tata ri, ya ni taji ruꞌu jiin jniñu jaꞌa―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","―¿Nanu kancha tata ra nusa? ―ni kachi da. Ti ni kachi Jesús: ―Siaꞌan ka kaꞌan ra chi tu ka jini kuɨtɨ ra nau ja kuu ri. Suni siaꞌan tu ka jini kuɨtɨ ra nasa kaa maa Yandios. Ni tu ka jini ra nasa sajniñu ya. Ko nu siaꞌan ti kuni ra nau ja kuu ri, ti suni siaꞌan nakuni ndaa ra nau ja kuu Tata ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yukan kuu jnuꞌun ni kaꞌan Jesús na ni skuaꞌa ya ini veñuꞌun kaꞌnu un, yajni nuu kancha jajnu ka soko yɨvɨ xuꞌun nuu Yandios. Ko tu ni ka jnɨɨ ni ɨɨn da ya, chi tu jaꞌi jaa hora ni kachi Yandios ja kuū ya. Tu jaꞌi jaa maa hora ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ni kaꞌan tuku Jesús jiin yɨvɨ ni ka ndututu yukan, ti ni kachi ya: ―Ruꞌu, kiꞌin ri ti nanduku ra ruꞌu, ko tu naniꞌin ra ruꞌu. Jaa kɨvɨ kuū ra, ko yukan kendo kuachi sɨkɨ maa ra. Chi tukaa iyo jnukaꞌnu ini, ni tu kuu kinkoyo ra nuu kiꞌin ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ti yɨvɨ hebreo un ka ndajnuꞌun da ti kachi da naa da: ―Va kin kaꞌni chaa jaꞌa maa da ja kachi da ja tu kuu kiꞌin yo nuu kiꞌin da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ti ni kachi Jesús nuu da naa da: ―Roꞌo chi ka yɨꞌɨ ra jiin yɨvɨ ñuyɨvɨ jaꞌa. Ko ruꞌu chi yɨꞌɨ ri jiin ya kancha andɨvɨ. Ka yɨꞌɨ ra jiin yɨvɨ ñuyɨvɨ jaꞌa. Ko ruꞌu tu yɨꞌɨ ri jiin ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ja yukan kuu ja ni kachi ri ja jaa ɨɨn kɨvɨ ti kuū ra, ko kendo kuachi sɨkɨ maa ra. Tukaa koo jnukaꞌnu ini Yandios nuu ra naa ra. Chi nu tu kandixia ra nava kaꞌan ri, yukan na ti nu na kuū ra ti kendo kuachi ri ja maa ri kuu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yukan ti ni ka kachi da jiin ya: ―Nusa ti, ¿nau ja kuu ra? ―ni ka kachi da. Ti ni kachi Jesús: ―Undi nuu ja ni kachi ri nau ja kuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ti iyo kuaꞌa ga jnuꞌun kuni kaꞌan ri jiin ra, ti suni iyo kuaꞌa ga ja kuni xndichi ri roꞌo naa ra. Ko jnuꞌun kaꞌan ri vijna kuu mani jnuꞌun ni jini ri nuu maa ya ni taji ruꞌu. Ti maa ya kuu Yandios ndaa ndixia. Ti ruꞌu, kaꞌan ri mani maa jnuꞌun ni kachi maa ya nuu ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko tu ni ka chaku ini yɨvɨ un ja ni kaꞌan Jesús jnuꞌun Tata ya, ya kancha andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yukan ti ni kachi Jesús nuu da naa da: ―Jaa kɨvɨ nu katakaa ra ruꞌu nuu ndaꞌa cruz, ko nu na saꞌa ra taka yukan jiin ri, ruꞌu ja kuu ri Seꞌe Yɨvɨ Ñuyɨvɨ, yukan na ti kuni ra ja maa ri kuu ndɨꞌɨ nava ni kachi ri. Nakuni ra ja tu ni saꞌa ri ja kuu ini maa ri. Chi suꞌva saꞌa ri nava ni xnaꞌan maa Tata ri, ti yukan kuu taka ja saꞌa ri nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Maa Tata ri ni taji ruꞌu jiin jniñu jaꞌa. Nɨnɨ kancha ya jiin ri. Tu xndoo ya maa ɨɨn xini ri ja saꞌa ri nava kuni ri. Chi suꞌva taka ni kɨvɨ saꞌa ri nava kuni maa ya sa jajnaꞌan ini ya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ja siaꞌan ni kachi Jesús, ti kuaꞌa yɨvɨ ni ka kejaꞌa ka kandixia i ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ni kachi Jesús nuu jnaꞌan ya hebreo, chaa ni ka kandixia ya: ―Nu na siuku ndaa ra jnuꞌun xnaꞌan ri, yukan na ti ka kuu ndixia ra chaa ka skuaꞌa jiin ri. Nu siaꞌan na ti ni kundaa ndixia ja ka yɨꞌɨ ra ndaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yukan na ti nakuni vaꞌa ini jnuni ra ja jnuꞌun kaꞌan ri kuu mani jnuꞌun ndaa. Chi natava ri roꞌo nuu nundoꞌo nava tukaa ga kɨvɨ ra jiin kuachi un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ko tɨjnɨ yɨvɨ un ni ka kachi: ―Ka kuu ri yɨvɨ kuu jnaꞌan tata ri Abraham, chaa ni chaku undi na janaꞌan. Ti tu ni ka yɨꞌɨ ri ndaꞌa ni ɨɨn ja kuñaꞌnu ja kunukuachi ri nuu. ¿Ti nasa kuu ja kaꞌan ra ja natava ra ruꞌu naa ri nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ti ni kachi Jesús: ―Jandaa ndixia na kachi ri ja taka yɨvɨ ka saꞌa kuachi, niꞌin xaan ka siin jiin kuachi un, ti tu kuu nasa nama i maa i nuu, chi niꞌin xaan ka yɨjnɨ i nuu ndaꞌa kuachi un, ti so ka junukuachi kaꞌa i nuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Saꞌa yo nanu, ɨɨn yɨvɨ sajniñu kaꞌa, tu kuu i jnaꞌan yɨvɨ xiin veꞌe nuu sajniñu i un. Ko ɨɨn seꞌe, chi kuu i jnaꞌan yɨvɨ xiin veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko ruꞌu ja kuu ri Seꞌe Yandios, nama ri roꞌo nava tukaa ga sajniñu kaꞌa ra nuu kuachi un, ja siaꞌan na ti kundee ra sɨkɨ kuachi un. Ko vijna ti ka sajniñu kaꞌa ra nuu kuachi un, vasu ka kuu ra jnaꞌan Abraham, chaa ni kuu tata yo na janaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jini ri ja ka kuu ra jnaꞌan tata yo Abraham, ti vasu siaꞌan iyo, ko ka kuni kaꞌni ra ruꞌu, chi tu ka kuni kuantaꞌu ra jnuꞌun kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ruꞌu, chi kaꞌan ri jnuꞌun ni xnaꞌan Tata ri nuu ri. Ko roꞌo naa ra, chi ka saꞌa ra ɨɨn jniñu kuni maa tata ra, ja kuu chaa uꞌu un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ti ni ka kachi da: ―Ka kuu ri jnaꞌan tata ri Abraham ―ni ka kachi da. Ko ni kachi Jesús nuu da naa da: Ti nu jandaa kuu ja ka kuu ra jnaꞌan Abraham, ti saꞌa jniñu vaꞌa naa ra, siaꞌan nanu ni saꞌa maa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ko vaꞌa ndeꞌe ra jniñu saꞌa ra, chi ka kuni kaꞌni ra ruꞌu, vasu ni kaꞌan ri mani jnuꞌun ndaa nuu ra naa ra, nanu ni xnaꞌan Tata ri Yandios nuu ri. Ko vaꞌa ndeꞌe ra naa ra, chi tu ni saꞌa ndevaꞌa Abraham nanu ka kuni saꞌa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Roꞌo chi ɨɨn ni kuankoyo ra jiin jniñu ka saꞌa maa tata ra naa da ―ni kachi ya. Ti ni ka kachi da: ―Ruꞌu, tu ka kuu ri seꞌe ja tu iyo tata, chi iyo ɨɨn ni tata ri, ti maa ya kuu Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ti ni kachi Jesús nuu da naa da: ―Nu ndixia ra ja ka kuu ra yɨvɨ Yandios, ti va koo mani ra jiin ri niku. Chi ruꞌu, undi nuu Yandios ni kee ri vaji ri. Ti tu vaji ri ja kuu ini maa ri, chi maa ya ni taji ruꞌu jiin jniñu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ko roꞌo naa ra, tu ka chaku ini ra. Tu ka kuni chuꞌun ini ra jnuꞌun kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Siaꞌan kuu chi vanuxia maa tata ra kuu jaꞌuꞌu un, ti ka ndiyo ini ra saꞌa ra nau jniñu taꞌu tata ra un. Chi maa jaꞌuꞌu un ni kejaꞌa jaꞌni ndɨyɨ undi na ni kejaꞌa ñuyɨvɨ yo. Ti tu jini kuɨtɨ jaꞌuꞌu un ni ɨɨn jnuꞌun ndaa. Ni undi vijna tu kaꞌan kuɨtɨ ni ɨɨn jnuꞌun ndaa. Mani jnuꞌun xndoñaꞌan kaꞌan. Ti hora xndoñaꞌan, kaꞌan nanu ja jandaa ndixia kuu, vanuxia maa jaꞌuꞌu un kuu tata yɨvɨ ka xndoñaꞌan un. Ti yukan kuu ja kunuu jiin yɨvɨ ka xndoñaꞌan un. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ko vijna ti ruꞌu ja kaꞌan ri taka jnuꞌun ndaa, ti roꞌo tu ka kandixia ra ruꞌu naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Va nu iyo ɨɨn ra kuu chakuachi ruꞌu ja ja ni saꞌa ri ɨɨn kuachi xino? Ti vasu tu kuu kaꞌan ra siaꞌan, ko tu ka kuni kandixia ra ruꞌu ja kaꞌan ri niña jnuꞌun ndaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yɨvɨ ka kuu yɨvɨ Yandios, ti ka chuꞌun ini i jnuꞌun kaꞌan ya. Ko roꞌo naa ra, tu ka kuni chuꞌun ini ra, chi tu ka kuu ra yɨvɨ Yandios ―ni kachi ya nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yukan na ti ni ka kachi chaa hebreo un jiin Jesús: ―Va vatuni ka ndoꞌo ini ri ja kuu ra ɨɨn chaa ñuu Samaria, ti va nu tu jika ɨɨn tachi uꞌu jiin ra, ¿ndoo kaꞌan ra siaꞌan nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ti ni kachi Jesús: ―Tu jika ni ɨɨn tachi uꞌu jiin ri. Chi suꞌva jiin jnuꞌun kaꞌan ri, jaꞌa ri ja yɨñuꞌun nuu Tata ri. Ko maa ra naa ra, tu ka jaꞌa ra ja yɨñuꞌun ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ko tu kaꞌan ri ja kuu maa ri, ja nduku ja kuñaꞌnu ri. Ko iyo ɨɨn ja saꞌa ja kuñaꞌnu ri. Ti nu na jaa kɨvɨ, ti maa ya kuu ja sandaa kuachi sɨkɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jandaa na kachi ri ja taka yɨvɨ nu na siuku ndaa jnuꞌun ri, tu naa kuɨtɨ i, chi kiꞌin i kuncha i jiin Yandios ja kuu saa ni ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yukan ti yɨvɨ hebreo un ni ka kachi i: ―Vijna ti ka jini ndaa ri ja ni nduu kuꞌu xini ra, ti kancha ɨɨn tachi uꞌu jiin ra. Chi tata ri Abraham na janaꞌan, jiin taka ga chaa ni ka kuu profeta na janaꞌan un, ni ka jiꞌi da. Ko roꞌo, chi kachi ra ja kuu kuncha ri ja kuu saa ni nu na siuku ndaa ri jnuꞌun kaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Jani ini ra ja ñaꞌnu ga ra ja kuu taka jnaꞌan Abraham na janaꞌan, xi ñaꞌnu ga ra ja kuu taka chaa ni ka kuu profeta un nu? ¿Vanu kuñaꞌnu ga ra ja kuu maa da naa da xino? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ti ni kachi Jesús: ―Nu maa ni ri na kaꞌan ja kuñaꞌnu ri, ti tu nijniñu. Ko maa Tata ri kuu ya kachi ja kuñaꞌnu ri. Roꞌo naa ra, ka kaꞌan ra ja ka nchañuꞌun ra Yandios. Ko vanuxii maa ya kuu maa Tata ri, ti maa ya kuaꞌa ja yɨñuꞌun ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ti vasu siaꞌan ka kaꞌan ra, ko tu ka jini ra maa ya. Ti ruꞌu, chi jini vaꞌa ri maa ya. Nu na kaꞌan ri ja tu jini ri maa ya, ti kuu ri ɨɨn chaa xndoñaꞌan nanu roꞌo naa ra. Ko tuu, chi jini ndixia ri ya. Yukan kuu ja siuku ndaa ri jnuꞌun kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Suni tata ra Abraham, ni jini jnuni da ja kii kaku ri nuu ñuyɨvɨ jaꞌa. Yukan ti ni kusɨɨ ini da. Chi ni kandixia ndaa da ja siaꞌan kuu ndaa, ti ni kusɨɨ ini da ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ti ni kachi chaa hebreo un jiin Jesús: ―Va ni tu iin ra uu xiko uxi kuiya, ¿ti nasa kuu ja kaꞌan ra ja ni jini ra nuu Abraham nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ti ni kachi Jesús: ―Jandaa na kachi ri nuu ra naa ra ja undi na ti kaku ga Abraham, ti ja iyo ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yukan ti ni ka kiꞌin da yuu ja kuaꞌa da ya. Ko maa Jesús, xeꞌe ni ni kenda ya ini veñuꞌun kaꞌnu un, ti kuaꞌan ni ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ichi kuaꞌan Jesús, ni jini ya ɨɨn chaa kuaa, ja kuaa nduchi da undi ni kaku da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ti chaa ka skuaꞌa jiin ya, ni ka jikajnuꞌun da ya: ―Maestro, ¿ndoo ni kuu ja ni kaku kuaa chaa jaꞌa? ¿Ja ka iyo xaan kuachi tata da, nana da, xi kuachi maa da kuu nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ti ni kachi Jesús jiin da naa da: ―Ni ansu kuachi maa da, ti ni ansu kuachi tata da xi nana da kuu ja ni kaku da siaꞌan. Chi ja ni kaku da siaꞌan kuu ja na kuni yɨvɨ naa i ɨɨn jniñu ñaꞌnu ja saꞌa Yandios jiin da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Saꞌa yo ja nu nɨ iin ndijin tɨꞌlɨ ga, ti kuu saꞌa yo jniñu, ko nu tukaa ndijin, ti tukaa ga kuu saꞌa jniñu yo. Suni siaꞌan ja kuu ruꞌu, chi kanuu ja na saꞌa ri ɨɨn jniñu vijna nɨ ndijin tɨꞌlɨ ga, chi jan ɨɨn kɨvɨ ja tukaa ga kuu saꞌa jniñu ni ɨɨn yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ruꞌu, nɨ kancha ri nuu ñuyɨvɨ jaꞌa, ti kuu ri nanu ɨɨn ñuꞌun ja ndinchaa ichi yɨvɨ kanchuku nuu ñuyɨvɨ, chi xnaꞌan ri nasa kuu saꞌa yɨvɨ ɨɨn jniñu kuni Yandios ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Siaꞌan ni kachi ya, ti ni tɨvɨsɨꞌɨ ya nuu ñuꞌun. Ni saꞌa ya ndeꞌyu jiin tɨsɨꞌɨ ya, ti ni jaka ya ndeꞌyu un nduchi chaa kuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yukan na ti ni kachi ya jiin da: ―Kuaꞌan yuꞌu pila nducha Siloé un, ti nakacha ra nduchi ra ―ni kachi ya. (Siloé kuni kaꞌan: “Ja ni taji ri.”) Yukan na ti kuaꞌan chaa un, ni nakacha da nduchi da, ti ni ndundijin nuu da. Yukan na ti kuanoꞌon da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yɨvɨ ñuu da un jiin taka ga yɨvɨ ka jini ja kuu da ɨɨn chaa kuaa, ka jikajnuꞌun jnaꞌan i: ―¿Ti ansu chaa jaꞌa kuu ja ni jikan da xuꞌun nukoo da un nu? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ni ka iyo sava yɨvɨ ni ka kachi: ―Suu kuu da. Ti sava ga i ni ka kachi: ―Ansu kuu da, ko siaꞌan kaa da. Ko maa da ni kachi da: ―Maa ri kuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yukan ti ni ka jikajnuꞌun yɨvɨ un maa da: ―¿Nasa kuu ja ni ndundijin nduchi ra nusa? ―ni ka kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ti ni kachi da: ―Ka jini ra ɨɨn chaa nani Jesús. Chaa yukan, ni saꞌa da ndeꞌyu jiin tɨsɨꞌɨ da, ni jaka da nduchi ri, ti ni kachi da ja na kiꞌin ri yuꞌu pila nducha Siloé un, ti na nakacha ri nduchi ri. Ni jaꞌan ri yukan, ni nakacha ri nduchi ri, ti ni ndundijin vaꞌa ndeꞌe ri vijna ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ti ni ka jikajnuꞌun chaa un maa da: ―¿Nanu kande chaa un nusa? ―ni ka kachi da. ―Tu jini ri ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yukan ti ni ka janchaka da chaa ni kaku kuaa un nuu chaa fariseo un. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ni kuu un ɨɨn kɨvɨ ndetatu, kɨvɨ ii, na ni saꞌa Jesús ndeꞌyu ja ni saꞌa ya tajna nduchi chaa kuaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yukan na ti ni ka jikajnuꞌun chaa fariseo un maa da nasa kuu ja ni ndundijin nduchi da. Ti ni kachi da: ―Ni saꞌa chaa un ndeꞌyu ti ni jaka da nduchi na, ni janukacha na nuu na, ti vijna ja ni ndundijin vaꞌa nduchi na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yukan na ti sava chaa fariseo un ni ka kachi da: ―Ansu Yandios ni taji chaa un jiin jniñu saꞌa da un, chi tu chiñuꞌun da kɨvɨ ii ―ni ka kachi da. Ti sava ga chaa fariseo un ni ka kaꞌan: ―Nu ansu chaa vaji nuu Yandios kuu da, ¿ti nasa kuu ja kuu saꞌa da jniñu ñaꞌnu un nusa? ―ni ka kachi da. Ti ni ka kusɨɨn ini da naa da ja sɨkɨ Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ni ka jikajnuꞌun tuku da chaa ni kaku kuaa un: ―Maa ra kachi ja chaa un kuu ja ni saꞌa tajna roꞌo, ja ni ndundijin vaꞌa nduchi ra vijna. Vijna na ti ¿ndoo ndoꞌo ini ra nau ja kuu chaa yukan nusa? ―ni ka kachi da. Ti ni kachi chaa un: ―Maa da kuu ɨɨn profeta ni taji Yandios ja na kaꞌan da jnuꞌun ya ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ti chaa hebreo un, tu ka kuni kandixia da ja ni kaku kuaa chaa yukan, chi vanua ja ni nduvaꞌa nduchi da. Ja yukan kuu ja ni ka kana da tata da jiin nana da, ");
INSERT INTO mpmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ti ni ka jikajnuꞌun da chaa un naa da: ―¿Seꞌe ra kuu chaa jaꞌa nu? ¿Kuaa ndixia da undi ni kaku da nu? ¿Nasa ni kuu ja ni ndundijin nduchi da vijna nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ti ni ka kachi tata da jiin nana da: ―Seꞌe na kuu da, ti kuaa ndixia nduchi da undi ni kaku da, ");
INSERT INTO mpmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ko tu ka jini na nasa kuu ja ni nduvaꞌa nduchi da, ti ni ndundijin vijna. Ni tu ka jini na nau ja ni saꞌa tajna nduchi da. Kajnuꞌun ni maa da chi ja ñaꞌnu da, ti na kani maa da jnuꞌun ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Siaꞌan ni ka kaꞌan tata da jiin nana da, chi ni ka yuꞌu da ndeꞌe da chaa hebreo ka kuñaꞌnu un. Chi vanua ka ndajnuꞌun chaa un ja nu nau ɨɨn ɨɨn yɨvɨ na kachi ja Jesús kuu Cristo, ya ni taji Yandios jiin jniñu ñaꞌnu, ti keniꞌin da yɨvɨ un, ti tukaa kuu ndɨvɨ i ini veñuꞌun kaꞌnu yɨvɨ hebreo. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ja yukan kuu ja siaꞌan ni ka kachi tata da jiin nana da: ―Kajnuꞌun maa ni da naa, chi ja ñaꞌnu da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ni ka kana tuku chaa hebreo ka kuñaꞌnu un, chaa ni iyo kuaa un, ti ni ka kachi da jiin da: ―Nakuantaꞌu nuu maa Yandios, ti koto kuaꞌa ra ja yɨñuꞌun chaa nani Jesús yukan, chi ka jini ri ja maa da kuu ɨɨn chaa nchakuachi ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ti ni kachi chaa un: ―Tu jini na nu iyo kuachi da xi tu, ko ja jini na kuu ja ni iyo kuaa nuu na, ti vijna ja ni ndundijin vaꞌa nduchi na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yukan ti ni ka jikajnuꞌun vaꞌa da: ―¿Ndoo ni saꞌa chaa un jiin ra nusa? ¿Nasa ni saꞌa da tajna nduchi ra nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ti ni kachi chaa un: ―Ja ni kachi na nuu ni naa ni, ti tu ka kuni ni kandixia ni, ¿nasa kuni ni ja na kachi tuku na inga jinu nusa? ¿Xi suni ka kuni kundikun ni maa da ja skuaꞌa ni jiin da nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yukan ti ni ka kejaꞌa ka nduxaan chaa un jiin da, ti ni ka kachi da: ―Roꞌo, va yɨꞌɨ ra jiin chaa un nusa. Ko ruꞌu, chi ka yɨꞌɨ ri jiin tata ri Moisés naa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ka jini ndaa ri ja ni kaꞌan maa Yandios jiin Moisés, ko chaa yukan, tu ka jini ri na ichi vaji da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ti ni kachi chaa ni iyo kuaa un: ―Naa ini na ja tu ka jini ni nanu vaji chaa un, ko ni saꞌa da tajna nduchi na. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ka jini yo ja tu siuku Yandios nava ka jikantaꞌu yɨvɨ ka iyo kuachi. Ko siuku ya nava ka jikantaꞌu yɨvɨ ka nchañuꞌun ya, ti ka saꞌa i nava kuni maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Undi ni jankoo ñuyɨvɨ, ti undi vijna, tu ka jini yo ɨɨn yɨvɨ saꞌa tajna nduchi ɨɨn yɨvɨ ni kaku kuaa. Ni ɨɨn. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti nu ansu nuu maa Yandios vaji chaa yukan, va ni tu kuu kuɨtɨ saꞌa da ɨɨn jniñu siaꞌan ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ti ni ka kachi chaa un naa da: ―Roꞌo chi iyo xaan kuachi ra undi kɨvɨ ni kaku ra. Nusa ti tu chunsoꞌo kuɨtɨ ri ni ɨɨn jnuꞌun ja kuni ra xndaku ra ―ni ka kachi da. Yukan na ti ni ka keniꞌin da chaa un kuaꞌan da fuera. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ni jini Jesús ja siaꞌan ni ka keniꞌin da chaa ndaꞌu un, ti ni jan nunduku ya maa da. Nu ni ndejnaꞌan ya jiin da, ti ni jikajnuꞌun ya maa da: ―¿Kandixia ra maa Seꞌe Yɨvɨ Ñuyɨvɨ jaꞌa nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ti ni kachi da: ―Taa, ¿ko nau chaa kuu chaa yukan? Xnaꞌan ni chaa un tɨꞌlɨ saña, ti na kandixia na da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ti ni kachi Jesús jiin da: ―Ja ni jini ra maa da, ti chaa un kuu chaa kaꞌan jiin ra jaꞌa vijna ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yukan na ti ni jakunjitɨ da nuu ya ja nachiñuꞌun da ya, ti ni kachi da: ―Kandixia na niꞌin, Jitoꞌyo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ti ni kachi Jesús: ―Vaji ri nuu ñuyɨvɨ jaꞌa ja xndichi ri kuachi yɨvɨ naa i. Yɨvɨ ja tu ka jini kuɨtɨ, na saꞌa ri ja na ndundijin undi inijnuni i. Ti yɨvɨ ka ndoꞌo ini ja ka jini ndaa kuɨtɨ i, na saꞌa ri ja tukaa chaku kuɨtɨ ini i naa i ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Suni kaꞌiin tɨjnɨ chaa fariseo yajni nuu kandichi Jesús yukan. Nu ni ka jinisoꞌo da ja ni kachi ya siaꞌan, ti ni ka jikajnuꞌun da ya: ―¿Kachi ra ja suni ruꞌu, tu ka jini kuɨtɨ ri naa ri nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ti ni kachi Jesús jiin da: ―Nu siaꞌan ti tu ka jini kuɨtɨ ra, va tu koo kuachi sɨkɨ ra. Ko tu ka kaꞌan ra siaꞌan. Chi suꞌva ka kaꞌan ra ja ka jini ndaa kuɨtɨ ra. Yukan kuu ja ka nchakuachi ga sɨkɨ ra naa ra, ti tukaa kuɨtɨ iyo jnukaꞌnu ini ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Na kachi ndaa ri nuu ra naa ra, ja ɨɨn chaa kanda savaꞌni ga yuꞌu ndaꞌa jaku rɨɨ ti kɨvɨ xeꞌe da, chaa un kuu ɨɨn ñakuiꞌna. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ko maa chaa xiin rɨɨ un chi kɨvɨ ndaa da ichi yuꞌu jaku tɨ. Ti chaa yukan kuu maa chaa nchaka rɨɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Chaa ndito rɨɨ un kuiña da yuꞌu jaku rɨɨ, ti kɨvɨ maa chaa xiin rɨɨ un. Kana da xini tɨ, ti kuɨtɨ un ka nakuni tɨ ndusu yuꞌu da, kekoyo tɨ kiꞌin tɨ, ti tu kusɨɨn tɨ kinkoyo tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu ni ndɨꞌɨ rɨɨ da ni keniꞌin da, nastutu da tɨ ti kinkoyo tutu tɨ jiin da, chi ka ñunuu tɨ ja maa da kuu jitoꞌo tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ti tu kaka tutu tɨ jiin ɨnga yɨvɨ, chi vanua tu ka nakuni tɨ ndusu yɨvɨ un, ti suꞌva kuichanuu tɨ kinkoyo tɨ, chi ansu maa jitoꞌo tɨ kuu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Siaꞌan ni kaꞌan Jesús jiin yɨvɨ un, ko tu ni ka chaku ini i nasa kuni kaꞌan ya jiin jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ti yukan ni xndaku Jesús siaꞌan ―Jaꞌa na kachi ndaa ri nuu ra naa ra. Maa ri kuu nanu yuꞌu jaku nuu kɨvɨkoyo rɨɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na ti chaa ga ruꞌu, ni ka kii chaa ni ka kuni nastutu yɨvɨ ri. Chaa un ni ka kuu da ɨɨn ñakuiꞌna, chi ni ka xndaꞌu da yɨvɨ naa i. Ti yɨvɨ ka kuu nanu rɨɨ un, tu ni ka saꞌa i nanu nuu chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ruꞌu, kuu ri nanu ɨɨn yuꞌu jaku nuu kɨvɨkoyo rɨɨ un. Taka yɨvɨ kɨvɨkoyo i yuxeꞌe un, nu na kandixia i ruꞌu, yukan na ti kendo ndaa i nuu Yandios. Koto vaꞌa ri yɨvɨ un nuu kunchuku i, ti koo taka ja nandɨꞌɨ i. Siaꞌan kuu ri nanu ɨɨn yuxeꞌe ja kuu yɨvɨ kɨvɨkoyo nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Saꞌa yo nanu. Chaa ka xndoñaꞌan un, ka kuu da nanu ɨɨn ñakuiꞌna, chi jaa da nuu kaꞌiin rɨɨ un, sakuiꞌna da tɨ, kaꞌni da tɨ ti xnaa da tɨ. Ko ruꞌu, tu saꞌa ri siaꞌan. Chi suꞌva, vaji ri na nakana ri yɨvɨ ja na ndɨvɨkoyo i ndaꞌa Yandios, ti ka kusɨɨ ini i, chi ka jika i ichi maa ya nuu ñuyɨvɨ jaꞌa. Ti siaꞌan kunchuku i jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Maa ri kuu nanu ɨɨn chaa xiin rɨɨ un, ja jito vaꞌa da rɨɨ da. Nu ni jini da ja iyo ɨɨn nundoꞌo xaan nuu rɨɨ da, ti yachi nduku da nuu kuu nasa nama da tɨ. Ti vasu na kuu da, ko nama da rɨɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ko ɨɨn chaa saꞌa jniñu ja kin yaꞌu da, nu ni jini da ja kuan kuyajni ɨɨn vaꞌu nuu rɨɨ da, xndoo da rɨɨ un, ti jaꞌa da corrɨ kuaꞌan da, chi vanua ansu rɨɨ maa da kuu kuɨtɨ ndito da un. Ti vaꞌu un kɨvɨ tɨ maꞌñu rɨɨ un, ti kachanuu tɨ rɨɨ un kinkoyo. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Siaꞌan ka saꞌa chaa ka kuu muzu, chi ka saꞌa da jniñu, ko so ja na niꞌin da xuꞌun yaꞌu da, ti ansu ja koto vaꞌa da rɨɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ko ruꞌu, kuu ri nanu ɨɨn chaa vaꞌa ja jito vaꞌa da rɨɨ da. Jini ndaa ri nau ndɨꞌɨ ka kuu yɨvɨ ri, ti maa i ka nakuni vaꞌa i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Suni siaꞌan maa Tata ri, chi mani xaan ya jiin ri, ti maa ri, jini vaꞌa ri nuu maa ya. Nanu kuu ɨɨn chaa vaꞌa ja nama da rɨɨ da, suni siaꞌan kuu ruꞌu ja nama ri sɨkɨ yɨvɨ yɨꞌɨ jiin ri, chi kuu ri ja kuu maa i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ti suni ka iyo yɨvɨ ɨnga nación ja kɨvɨkoyo i ndaꞌa ri, vasu tujaꞌi natuꞌva i ruꞌu. Ko jaa ɨɨn kɨvɨ ti nastutu ri yɨvɨ un. Tendɨꞌɨ i natuꞌva ruꞌu, ti kuandatu i nuu ri. Tendɨꞌɨ yɨvɨ un najnaꞌan i, ti koo ɨɨn ni chaa kɨndaꞌa maa i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yukan kuu ja kundaꞌu xaan ini Tata ri ruꞌu, chi tava ini ri kuū ri ja na nama ri yɨvɨ ri naa i. Ti kuū ri, ko nandoto tuku ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni ɨɨn chaa ka ndiso jniñu, tu kuu kaꞌni da ruꞌu nu tu kuu ini maa ri. Chi kuū ri, ko ja kuu ini maa ri ti kuū ri. Iyo ɨɨn jniñu ndiso ri, ja yukan kuu ja maa ri na kuaꞌa jnuꞌun ja kuū ri. Ti jniñu ndiso ri, yukan kuu ja saꞌa ja na nandoto tuku ri, chi siaꞌan ni taꞌu maa Tata ri jniñu ―ni kachi Jesús nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ja siaꞌan ni kaꞌan Jesús, ti ni ka kusɨɨn tuku ini chaa hebreo un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kuaꞌa yɨvɨ un ni ka kachi: ―Jnaꞌan da ɨɨn tachi xaan, yukan kuu ja ni ndukuꞌu xini da. Koto ma ndeꞌe ga ra nuu da ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko sava ga i ni ka kaꞌan: ―Ansu siaꞌan kaꞌan ɨɨn chaa jnaꞌan tachi xaan. Chi nu jnaꞌan da tachi xaan, ti va ni tu kuu saꞌa da tajna nduchi ɨɨn chaa ni kaku kuaa ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na ɨɨn viko ñuu, ni ka nasaꞌa yɨvɨ ñuu Jerusalén ɨɨn viko ja ka nukuꞌun ini i kɨvɨ ni kuu ii veñuꞌun kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ti yukan jikonuu Jesús yuxeꞌe veñuꞌun un, nuu nani yuxeꞌe Salomón. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yukan ni ka nataka chaa ka kuñaꞌnu un, ti ni ka kachi da: ―¿Nasa ga ti sa kaꞌan kaji ra nuu ri naa ri nusa? Nu jandaa kuu ja maa ra kuu Cristo, ni taji Yandios ja saꞌa jniñu ñaꞌnu. Nu jandaa kuu ti kachi kaji nuu ri naa ri vinañuꞌni ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ti ni kachi Jesús: ―Ja ni kachi ri nuu ra, ko tu ka kandixia ra naa ra. Ja ni ka jini ra jniñu ñaꞌnu ni saꞌa ri. Ni saꞌa ri taka un, chi maa Tata ri ni jaꞌa jniñu un nuu ri. Ti jiin yukan xnaꞌan kaji ya ja maa ya ni taji ruꞌu vaji ri, ti siaꞌan sa na kuni ra nau ja kuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tu ka kandixia ra ruꞌu, vanuxia tu ka yɨꞌɨ ra jiin ri. Tu ka kuu ra nanu ka kuu rɨɨ ja ka ñunuu tɨ nuu maa chaa ndito tɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ko yɨvɨ ka yɨꞌɨ jiin ri, ka nakuni i ruꞌu, ti ruꞌu nakuni ri maa i. Ti nanu ka nukunuu rɨɨ un tachi maa jitoꞌo tɨ, suni siaꞌan ka nakuni yɨvɨ naa i jnuꞌun kaꞌan ri, ti ka natuꞌva i ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ti kuaꞌa ri nuu kunchuku i jiin ri ja kuu saa ni. Ti tukaa naa kuɨtɨ i, ti ni tundo kuisonchaa i nuu ndaꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Maa Tata ri ni nachiꞌi yɨvɨ un ndaꞌa ri. Ti maa ya kuu ja kuñaꞌnu ga ja kuu nuu taka ga. Ti ni ɨɨn tu kuu kencha ja yɨndaꞌa maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ruꞌu jiin Tata ri, ɨɨn ni ga yɨvɨ ka kuu ri naa ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ti yukan ni ka kaniꞌin chaa un yuu ja kuaꞌa da sɨkɨ Jesús niku. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ti ni kachi Jesús jiin da naa da: ―Maa Tata ri ni jaꞌa ya jnuꞌun ndee ini ruꞌu, ti ni saꞌa ri kuaꞌa jniñu vaꞌa ja kuu roꞌo naa ra. ¿Va nu xi kuaꞌa ra yuu sɨkɨ ri ja ni saꞌa ri yukan nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yukan ti ni ka kachi chaa hebreo ka kuñaꞌnu un: ―Ansu ja ni saꞌa ra jniñu ñaꞌnu un kuu ja kuaꞌa ri yuu sɨkɨ ra, chi sɨkɨ ja ni kaꞌan ndevaꞌa ra sɨkɨ Yandios kuu. Chi maa ra kaꞌan ja ɨɨn ni kuu ra jiin maa Yandios. Vasu suni ɨɨn chaa siaꞌan ni kuu ra, ti kaꞌan ra ja ɨɨn nuu ra jiin Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ti ni kachi Jesús nuu da naa da: ―Yoso nuu tutu Yandios ka ñavaꞌa ra, nuu kaꞌan ya siaꞌan: “Yandios ka kuu roꞌo naa ra”, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Siaꞌan ni kachi Yandios ja yɨvɨ ni ka kaꞌan jnuꞌun ya, ni ka kuu i nanu Yandios. Siaꞌan ti tu kuu kaꞌan yo sɨkɨ tutu Yandios ja tu kaꞌan ndaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ko roꞌo naa ra, ka kaꞌan ra ja kaꞌan ndevaꞌa ri sɨkɨ Yandios, so ja ni kachi ri ja kuu ri Seꞌe maa ya. Siaꞌan ka kaꞌan tu roꞌo naa ra. Ko vasu maa ya ni jaꞌa ɨɨn jniñu nuu ri, ti ni taji ya ruꞌu vaji ri nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ti nu tu saꞌa ri nava kuni maa Tata ri, ti tu kanuu kuu ja kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ko nu na saꞌa ri nava kuni maa ya, ti suni kanuu kuu ja kandixia ra ruꞌu. Ko kandixia taka jniñu saꞌa ri. Yukan na ti sa kuni ndaa ra ja kancha maa Tata ri jiin ri, ti maa ri suni kancha ri jiin maa ya, ti kɨvɨ undi inijnuni ra ja jandaa ndixia kuu un ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yukan ti ka kuni tuku da jnɨɨ da ya, ko ni kenda ya ti kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yukan na ti kuanoꞌon Jesús. Ni nayaꞌa ya undi ɨnga yuꞌu yucha Jordán, ichi nuu kaña ndikandii, nuu ni skuanducha Juan undi nuu yukan, ti yukan ni kundee ya tɨjnɨ kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kuaꞌa yɨvɨ ni ka kendo jiin ya, ti sava i ka ndajnuꞌun siaꞌan: ―Tu ni saꞌa Juan jniñu ñaꞌnu nanu saꞌa chaa jaꞌa vijna, ko taka jnuꞌun ni kaꞌan da ja saꞌa chaa jaꞌa, ti kundixia nava ni kachi da ―ni ka kachi yɨvɨ un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ti kuaꞌa yɨvɨ yukan ni ka kandixia i Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ni kuncha ɨɨn chaa ñuu Betania ja ni nani Lázaro, ni kuu da kuaꞌa María jiin Marta. Ti ni kuꞌu xaan da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María un kuu ña ni chiꞌi aceite perfume jaꞌa Jitoꞌyo, ti ni nasichi ña jiin ixi xini ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ti ñaꞌan un ni ka taji razón nuu Jesús, ja kachi: ―Taa, chaa mani xaan ni jiin, kuꞌu da vijna, ni kachi ña ―kachi muzu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ni jini Jesús jnuꞌun un, ti ni kachi ya: ―Kuꞌu da ko va tu kuu da. Kuꞌu da chi siaꞌan ti sa kuni yɨvɨ nasa kuñaꞌnu ya ni taji ruꞌu, maa Seꞌe Yandios. Jiin kueꞌe jaꞌa ti stuu ri ja suni kuñaꞌnu ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mani Jesús jiin Marta, jiin kuꞌu ña, jiin Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ti vasu siaꞌan, ko ni kendo ya uu ga kɨvɨ nuu kancha ya na ni niꞌin ya jnuꞌun ja kuꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yukan ti sa ni kaꞌan ya jiin chaa ka skuaꞌa jiin ya: ―Ñaꞌan na choꞌo, chi nandeokuñɨ yo ñuu Judea ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Chaa ni ka skuaꞌa jiin ya ni ka kachi da: ―Maestro, ja jini ni ja yɨvɨ hebreo un ka kuni kuaꞌa i yuu sɨkɨ ni na ni kunde ni yukan, ti va kuaꞌa yɨvɨ un yuu sɨkɨ ni nu na jaa tuku ni yukan. ¿Ti kuni kiꞌin tuku ni yukan nu? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ti ni kachi Jesús nuu da naa da: ―Iyo uxi uu hora ɨɨn kɨvɨ ja na kuni ndaa yo na ichi kiꞌin yo. Ti nu saꞌa yo nanu ka saꞌa yɨvɨ ka jikonuu nduu, ja saꞌa yo jniñu vaꞌa, ti tu naa yo, chi ka jini ndaa yo na ichi kiꞌin yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko nu saꞌa yo nanu ka saꞌa yɨvɨ ka jikonuu nuu ñaa kuɨtɨ ja saꞌa yo jniñu ndevaꞌa, yukan na ti naa yo, chi tu jini ndaa yo na ichi kiꞌin yo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nu ni ndɨꞌɨ ni kaꞌan ya siaꞌan, ti ni kachi ya: ―Amigo yo Lázaro ja ni kixi da, ti kiꞌin ri ja na naxndoto ri da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yukan ti ni ka kaꞌan chaa ka skuaꞌa jiin ya: ―Taa, nu kixi da, ti ni jini yo ja nduvaꞌa da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ko so siaꞌan ni kaꞌan Jesús jiin da, chi ja ni jiꞌi Lázaro. Ko ka jani ini chaa ka skuaꞌa jiin ya ja so kixi ndixia da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ti sa ni kachi ndaa Jesús: ―Ja ni jiꞌi Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ti kusɨɨ ini ri ja tu ni kuncha ri yukan, chi siaꞌan na ti kandixia vaꞌa ra ruꞌu. Ñaꞌan na choꞌo ndeꞌe ndɨyɨ un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yukan ti Tomás, chaa nani kuati un, ni kaꞌan da jiin uu ga chaa ka skuaꞌa jiin ya: ―Suni na choꞌo tu yoꞌo, nava na kuu yo jiin da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yukan ti ni jaa Jesús ñuu Betania. Ko ni ka jani yɨvɨ jnuꞌun nuu ya ja ja ni yaꞌa kuun kɨvɨ ja ñunduji Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñuu un kendo yajni jiin ñuu Jerusalén, jika uu kilómetro sava. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ti kuaꞌa jnaꞌan yɨvɨ hebreo ni ka kenda nuu kanchuku Marta jiin María ja kaꞌan ndee jiin jnaꞌan ña, ja siaꞌan ni jiꞌi kuaꞌa ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yukan ti nu ni niꞌin Marta jnuꞌun ja vaji Jesús, ti ni kee ña kuan nujnaꞌan ña ya. Ti María ni kendo ña veꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni kachi Marta jiin Jesús: ―Taa, sa ti ni kuncha ni jaꞌa ti va tu kuu kuaꞌa na niku. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ti vasu siaꞌan ko jini na ja taka ndo na kakan ni nuu Yandios, ti saꞌa ya ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ti ni kachi Jesús: ―Na ndoto kuaꞌa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ti ni kachi Marta: ―Jini na ja nandoto da kɨvɨ na nandoto taka ndɨyɨ, undi kɨvɨ kaꞌnu ga ja saꞌa ndaa Yandios yɨvɨ ñuyɨvɨ ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ti ni kachi Jesús jiin ña: ―Ruꞌu kuu ja naxndoto yɨvɨ ja na kuchaku i jiin Yandios. Nu kandixia i ruꞌu, ti vasu na kuu i ko nandoto i ja kuncha i jiin Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yɨvɨ chaku ti nu kandixia i ruꞌu, jankɨvɨ ga kuu i, chi kuchaku i ja kuu saa ni. Ti roꞌo Marta, ¿kandixia ra jnuꞌun jaꞌa nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ti ni kaꞌan Marta: ―Kandixia na, taa. Kandixia na ja maa ni kuu Cristo. Maa ni kuu Seꞌe Yandios, ja ni taji ya nuu ñuyɨvɨ jaꞌa ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Siaꞌan ni kaꞌan Marta ti kuaꞌan ña. Kuan kana xeꞌe ña kuꞌu ña. Ni kachi ña jiin ña: ―Maa maestro ni chaa, ti kana ya roꞌo ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Siaꞌan ni kachi ña ti yachi ni ndokuɨñɨ María ti kuaꞌan ni ña nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti changa ga kɨvɨ Jesús ñuu un, chi ni kendo ya nu ni janujnaꞌan Marta ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jnaꞌan ña hebreo ja kanchuku ini veꞌe jiin María, ja ka jaꞌa i jnuꞌun ndee ini maa ña. Ni ka jini i ja ni ndokuɨñɨ yachi ña kuaꞌan ña. Ni ka chindikun i ña, chi ka ndoꞌo ini i ja kuaꞌan ña nuu ñaña ndɨyɨ un kuaꞌan ndeꞌe ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yukan ti ni jaa María nuu Jesús. Nu ni jini ña nuu ya, ti ni jakunjitɨ ña nuu ya. Ti ni kachi ña: ―Taa, sa ti ni kuncha ni jaꞌa ti va tu kuu kuaꞌa na niku ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ni jini Jesús ja ndeꞌe xaan ña jiin ja ka ndeꞌe xaan yɨvɨ hebreo un. Ja yukan ti so ni jakaꞌnu ini ya, chi ni kundaꞌu xaan ini ya nuu i. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ni jikajnuꞌun ya maa ña: ―¿Nanu ni chunduji ra da nusa? ―ni kachi ya. ―Choꞌo ti kuni ni, taa ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nu ni jini Jesús yukan ni kukuiꞌya ini ya, ti ni ndeꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ti yɨvɨ hebreo un ni ka kaꞌan jiin jnaꞌan i: ―Jandaa ndixia kuu ja mani xaan ni iyo da jiin ndɨyɨ un, chi suni kukuiꞌya ini da ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko sava i ni ka kachi: ―Ni saꞌa da tajna chaa ni kaku kuaa un. Ti va suni kuu saꞌa da ja tu kuu Lázaro niku ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ti ni ndukuiꞌya tuku ini Jesús nu ni jaa ya nuu ñunduji Lázaro. Ɨɨn yau kava kuu, ti yukan ndiꞌyu ɨɨn yuu kaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ni kachi Jesús nuu da naa da: ―Chajiyo yuu un naa ra ―ni kachi ya. Marta, kuaꞌa ndɨyɨ yukan, ni kachi ña: ―Taa, va ja ni kuxiko xaan da, chi ja iyo kuun kɨvɨ ja ni jiꞌi da ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ko ni kachi Jesús jiin ña: ―Ni kachi ri ja nu kandixia ra, ti kuni ra ja kuñaꞌnu xaan Yandios jiin jniñu saꞌa ya ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yukan ti ni ka chajiyo da yuu ndiꞌyu yuꞌu yau ndɨyɨ un. Ti Jesús ni ndakoto ya ichi andɨvɨ, ti ni kachi ya: ―Tata na, nakuantaꞌu na nuu ni ja ni jinisoꞌo ni jnuꞌun kaꞌan na. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ja jini na ja nɨnɨ chunsoꞌo ni jnuꞌun kaꞌan na, ko ni kachi na siaꞌan, chi kuni kaꞌan na jnuꞌun ndaa nuu yɨvɨ kaꞌiin jaꞌa, ti nava siaꞌan na kandixia i ja maa ni ni taji saña vaji na jiin jniñu jaꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ni ndɨꞌɨ ni jikantaꞌu ya, ti ni kanajiin koꞌo ya siaꞌan: ―¡Lázaro! ¡Ñaꞌan ti kenda! ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ti ni kenda Lázaro. Suku da saꞌma ndɨyɨ. Ndikun saꞌma ndaꞌa da jiin sɨꞌɨn da, ti suni suku ɨɨn saꞌma nuu da. Yukan ti ni kachi Jesús nuu yɨvɨ un: ―¡Ndaji da naa ra! Ti sia ra da na kiꞌin da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yɨvɨ hebreo ja ni ka jaꞌan veꞌe María, ni ka jini i jniñu ni saꞌa Jesús, ti kuaꞌa i ni ka kandixia ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko sava yɨvɨ un kuaꞌan i nuu ka ndututu chaa fariseo, ti ni ka jani i jnuꞌun jniñu ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yukan ti ni kachi sutu kuñaꞌnu ga un nuu chaa fariseo un naa da ja na ndututu taka chaa ka yɨꞌɨ jiin junta kaꞌnu nuu nación Israel. Nu ni ka ndututu da, ti ni kejaꞌa ka ndajnuꞌun da: ―¿Ndoo saꞌa yo vijna? Chi Jesús yukan, kuaꞌa jniñu ñaꞌnu saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu tu kasɨ yo yuꞌu da, ti va ndɨꞌɨ yɨvɨ kandixia i, ti kundikun i maa da. Jiin jnuꞌun kaꞌan da un ti chaa soldado ñuu Roma, ti xnaa da veñuꞌun kaꞌnu yo. Kaꞌni da yoꞌo jiin yɨvɨ ñuu yo. Yukan ti koo nundoꞌo sɨkɨ yo nu tu nakutu yachi ini yo nasa saꞌa yo jiin chaa un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ti kancha Caifás yukan, ja kuu da ɨɨn sutu kuñaꞌnu ga kuiya un, ti ni kachi da: ―Tu ka jini kuɨtɨ ra nasa saꞌa ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Va nu tu ka jini ra ja vaꞌa ga ja ɨɨn chaa na kuu ja kuu nuu nɨ ñuu, ti ansu ja kuu tendɨꞌɨ kuɨtɨ yo naa yo. Vaꞌa ga ja na kuu Jesús nava na nama yo maa yo jiin yɨvɨ ñuu yo ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Maa da kuu sutu kuñaꞌnu ga kuiya yukan. Ko tu jini da ja ansu sɨkɨ maa da ni kaꞌan da ja kachi da ja na kuu Jesús nava na ketaꞌu yɨvɨ nɨ ñuu hebreo. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko ansu sɨkɨ maa ɨɨn ni yɨvɨ hebreo kuu ya. Chi kuu ya ja kuu nɨ kaꞌnu yɨvɨ ñuyɨvɨ, nava siaꞌan na ti nastutu ndɨꞌɨ ya yɨvɨ ni ka kandixia Yandios, ti na nduu i ɨɨn ni ga yɨvɨ nuu ya, vasu jika xaan ni ka jichanuu i nuu kanchuku i nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ja siaꞌan kuu ja undi kɨvɨ jña, chaa hebreo ka kunaꞌnu un ni ka kejaꞌa ka nduku da nasa kaꞌni da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ja yukan tukaa ni jikonuu Jesús nuu kaꞌiin chaa ka kuñaꞌnu un, chi ni kee ya ñuu Judea, ti kuaꞌan ya ɨɨn ñuu nani Efraín, nu iyo yajni ñuꞌun teꞌe un. Yukan ni kendo ya jiin chaa ka skuaꞌa jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kuan kuyajni kɨvɨ viko pascua ka nasaꞌa yɨvɨ hebreo un, ja ka nukuꞌun ini i kɨvɨ na ni nama Yandios maa i ñuu Egipto na janaꞌan. Ja yukan kuaꞌa yɨvɨ ni ka jakoyo yachi ja ka nasandoo i maa i, ti na ndu ii yɨ nuu Yandios naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ti ka nanduku i Jesús ñuu Jerusalén yukan, ko tu ni ka naniꞌin i ya. Ni ka jakoyo i veñuꞌun kaꞌnu un, ti ni kejaꞌa ka ndajnuꞌun i jiin jnaꞌan i: ―¿Ndoo ndoꞌo ini ra? ¿Kii chaa un viko jaꞌa vijna xi tuu nu? ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ti sutu ka kuñaꞌnu jiin chaa fariseo un, ni ka taji da jnuꞌun, ja nu ni ka jini yɨvɨ nuu kande Jesús, ti na kaxnuꞌu ni nuu da, nava na jnɨɨ da presu Jesús, ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kumani iñu ga kɨvɨ ja kejaꞌa viko pascua, ti ni jaa Jesús ñuu Betánia, nuu kancha Lázaro, chaa ni naxndoto ya nuu ñujiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nu ni jaa Jesús ti ni ka saꞌa ɨɨn viko lulu ja kuu maa ya. Marta ni savaꞌa ja kuu viko un. Ti Lázaro kancha da nuu mesa jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Suni kancha María yukan. Ti ja iyo tuꞌva ña sava litro aceite perfume, mani maa nardo, ja nchaa yaꞌu xaan tonto, ti ni chiꞌi ña sɨkɨ jaꞌa Jesús. Ti na nasichi ña jiin ixi xini ña. Ti ni chitu xiko vixi ini veꞌe jiin xiko perfume un. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti Judas, chaa ñuu Cariote, suni kancha da un, chi suni ni skuaꞌa da jiin Jesús. Ko so ja maa da kuu ɨɨn ja kin nukuaꞌa Jesús nuu chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ti ni kachi da: ―¿Ndoo tu ni xiko ña aceite perfume un? Ti i niꞌin ña uni ciento xuꞌun plata ja chindee ña yɨvɨ ndaꞌu niku ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Siaꞌan ni kachi da, ko ansu ja kundaꞌu ini da yɨvɨ ndaꞌu, chi vanuxia kuu da ɨɨn chaa kuiꞌna. Ti maa da kuu ja ndiso xuꞌun ja kuu nuu ndajaꞌa Jesús, ti tava da xuꞌun ja ka jaꞌa yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yukan ti ni kachi Jesús: ―Sia na saꞌa maa ña, chi ja satuꞌva ña ruꞌu ja kuu kɨvɨ jakunduji ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ko yɨvɨ ndaꞌu un naa i, chi siaꞌan ni kunchuku i jiin ra, ko ruꞌu chi ansu siaꞌan ni kuncha ri jiin ra naa ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kuaꞌa yɨvɨ hebreo ni ka niꞌin yɨ jnuꞌun ja kande Jesús ñuu Betania, ti ni ka kee i kuankoyo i yukan, kuandeꞌe i ya. Ko ansu nɨnɨ Jesús kuan ndeꞌe da naa da, chi suni kuan ndeꞌe da Lázaro, chaa ni naxndoto Jesús nuu ñujiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ti sutu ka kuñaꞌnu un, suni ni ka ndoꞌo ini da ja kaꞌni da Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chi kuaꞌa xaan yɨvɨ hebreo un ni ka jini i nava ni kuu jiin Lázaro, ni ka kusɨɨn i jiin sutu un, ti ni kejaꞌa ka kandixia i Jesús. Ni ka kandixia i Jesús chi ni ka jini i jniñu ñaꞌnu ni saꞌa ya jiin Lázaro. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kuaꞌa yɨvɨ ka kuchitu ñuu Jerusalén, chi ni ka jakoyo i ja kuu viko pascua. Ɨnga kɨvɨ, ti ni ka niꞌin yɨ jnuꞌun ja chaa Jesús ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ni ka kenda i ti kuan nujnaꞌan i ya jiin ndaꞌa yuku ñuu. Ti ni kejaꞌa ka kanajaa i: ―Ñaꞌnu na koo maa ya ja ni taji Yandios ja vaji ya. Vaji ya jiin jniñu maa Jitoꞌyo Yandios. Na taꞌu ya jniñu nuu nɨ tuꞌu yɨvɨ ñuu Israel ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ni niꞌin Jesús ɨɨn burru lulu, ti ni yoso ya tɨ nava ni kachi tutu ii Yandios ja ni kaꞌan jaꞌa Jesús: ");
INSERT INTO mpmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Roꞌo, yɨvɨ ja kanchuku nuu ñuꞌun ñuu Sión, koto ma yuꞌu ra. Maa ya ja kii taꞌu jniñu nuu ra, ja vaji ya, ti yoso ya ɨɨn burru. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kɨvɨ un tu ni ka chaku ini chaa ni ka skuaꞌa jiin Jesús ja nasa kuni kaꞌan tutu ii Yandios, ja siaꞌan kii Jesús nuu ñuu Jerusalén. Ko nu ni nandoto tuku Jesús nuu ñujiꞌi, ti sa ni ka nukuꞌun ini da. Ni kejaꞌa ka nukuꞌun ini da ja ni kachi tutu Yandios ja siaꞌan koo, ti siaꞌan ni kundaa ndixia nava ni jnaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yukan kaꞌiin yɨvɨ ni ka jan ndeꞌe na ni naxndoto ya Lázaro, ti ka jani i jnuꞌun ja ni ka jini i nu ni ñunduji da, ti suni ni ka jini i nasa ni kana ya xini da hora ni nandoto da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ja yukan kuu ja kuankoyo i kuan nujnaꞌan i Jesús, vanuxia ja ni ka jinisoꞌo i ja ni saꞌa ya jniñu ñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko chaa fariseo un, ni ka kejaꞌa ka ndajnuꞌun da naa da: ―Ja ni ka jini yo ja tukaa ga ndo kuu saꞌa yo vijna na. Chi ja ni ndɨ kuɨtɨ yɨvɨ kuankoyo i jiin chaa un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Suni ni iyo yɨvɨ ñuu Grecia ja ni ka jakoyo i ñuu Jerusalén, chi kuan chiñuꞌun i kɨvɨ viko un. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ni ka ndejnaꞌan i jiin Felipe, ɨɨn ndajaꞌa Jesús ja kuu da chaa ñuu Betsaida, ja kuu ɨɨn ndañuu Galilea. Ti ni ka kachi i: ―Taa, ka kuni kaꞌan na jiin Jesús ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ni jaꞌan Felipe, ni kaxnuꞌun da nuu Andrés. Ti ndɨnduu da siaꞌan kuan kaxnuꞌun nuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yukan ti ni kachi ya nuu da naa da: ―Ja ni jaa kɨvɨ ja kuu Seꞌe Yɨvɨ Ñuyɨvɨ, nava na kuni yɨvɨ naa i ja nduñaꞌnu ri saꞌa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yukan kuu ja na kachi ndaa ri nuu ra nasa kuu jiin ɨɨn ni triu. Chi jini yo ja nu tu kanakava triu un nuu ñuꞌun ti ndiꞌyu sɨkɨ, ni tu ndoto kuɨtɨ. Ti saꞌa yo nanu ja ni jiꞌi triu un. Chi nani kaa ni kaa triu un. Ko nu na kanakava triu un chii ñuꞌun, yukan na ti nandoto ti nakaya kuaꞌa xaan. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Suni siaꞌan kuu jiin roꞌo naa ra. Nu ndɨꞌɨ kuu ini ra nasa niꞌin ga ra ja kuñavaꞌa ra nuu ñuyɨvɨ jaꞌa, ko na kachi ri ja jiin yukan ti naa ra nuu Yandios. Ko nu suꞌva na saꞌa ra nanu triu un, ja saꞌa ra nanu ja tukaa ga chaku ra, yukan ti ni tukaa kundiyo ini ra ndajniñu iyo nuu ñuyɨvɨ jaꞌa. Nu siukan na saꞌa ra ti kendo ndaa ra nuu Yandios, chi nakutu ini ra ja kuu nuu maa ya. Siaꞌan na ti kuncha ra jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ko nu kancha ra ñuyɨvɨ jaꞌa ti saꞌa ra jniñu ja kuu maa ri, ti siuku ndaa ra jniñu ri. Nu siaꞌan saꞌa ra, ti kuncha ra jiin ri, chi saꞌa ra jniñu ja kuu nuu maa ri. Nu sajniñu ra ja kuu ruꞌu, ti na saꞌa Tata ri ja na nduñaꞌnu ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Siin Jesús kaꞌan ya ti ni kachi ya: ―Vijna ti ndɨꞌɨ xaan ini ri ja undi ndaꞌu kuu ini ri. Ti tu jini ri nasa kaꞌan ri jiin Tata ri. Ko tu kachi ri ja na nama ya ruꞌu nuu nundoꞌo kii sɨkɨ ri, chi ja sɨkɨ jniñu yukan vaji ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ko na kachi ri jiin ya: “Tata na, vijna ti na kaꞌan yɨvɨ ja kuñaꞌnu xaan ni” ―ni kachi Jesús. Yukan ti ichi andɨvɨ ni kaꞌan ɨɨn ndusu yuꞌu Yandios, ti ni kachi ya: ―Ja ni ka jini yɨvɨ ja kuñaꞌnu xaan ri, ko na kuni tuku i ja kuñaꞌnu xaan ndixia ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ti yɨvɨ kaꞌiin yukan ni ka jinisoꞌo da ndusu un, ti sava i ni ka kachi: ―Taja ni kaꞌan ―kachi da. Ko sava ga yɨvɨ un ni ka kachi: ―Ɨɨn ángel Yandios ni kaꞌan jiin ya ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yukan ti Jesús ni kachi ya nuu da naa da tuku: ―Ansu nuu ruꞌu ni kaꞌan Yandios jnuꞌun un, chi suꞌva, nuu roꞌo naa ra ni kaꞌan ya nava na kuni ra ja ni kaꞌan ndixia ya jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti na kachi ri nuu ra naa ra ja ja ni jaa kɨvɨ ja xndichi Yandios kuachi sɨkɨ yɨvɨ ñuyɨvɨ jaꞌa. Ti ɨɨn ja taꞌu jniñu nuu i kuxio kiꞌin ɨɨn. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ko kɨvɨ na ndaniꞌin yɨvɨ ruꞌu, yukan na ti saꞌa ri ja na kandixia da sɨvɨ da naa da, ti nakuaka ri yɨ kunchuku da jiin ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jiin jnuꞌun un ni jani ya jnuꞌun nasa kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ti yɨvɨ un ni ka kaꞌan da jiin ya: ―Ka jini na ja tutu ii Yandios ni kachi ja kuaꞌa Yandios jniñu nuu Cristo, ti kuchaku ya ja kuu saa ni. Nusa ti, ¿nasa kuu ja kuu Seꞌe Yɨvɨ Ñuyɨvɨ? ¿Nau kuu Seꞌe Yɨvɨ Ñuyɨvɨ un nusa? ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yukan ni kachi Jesús nuu da: ―Maa ɨɨn ja kuu nanu ñuꞌun ndinchaa, kuncha jiin ra jaku ni ga kɨvɨ. Ja siaꞌan kuu ja kanuu ja na kaka ndaa ra, chi maa ñuꞌun ndijin un ndinchaa nuu ichi ra. Koto maa kɨvɨ ra nuu ichi ñuñaa un, chi siaꞌan na ti xnaa ra maa ra. Ko nu ka jikonuu ra nuu ñuñaa, ti tu ka jini kuɨtɨ ra na ichi kiꞌin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vijna ti maa Ɨɨn ja kuu nanu ñuꞌun ndijin kancha jiin ra. Vijna ti kandixia maa ya naa ra, chi siaꞌan na ti nduu ra yɨvɨ ka jika nuu ichi ndaa ―ni kachi ya. Jnuꞌun yukan ni kaꞌan Jesús ti kuaꞌan ya. Ni saꞌu ya kuaꞌan ya. Ti tukaa ga ni ka jini yɨvɨ naa da nachi kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yɨvɨ hebreo un ni ka jini da jniñu ñaꞌnu ni saꞌa Jesús, ko tu ni ka kandixia da ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ja yukan ti ni kundaa jnuꞌun ni kaꞌan profeta Isaías na janaꞌan, chi ni kachi da nuu Yandios: Jitoꞌyo, tu iyo ni ɨɨn yɨvɨ ja kandixia ra jnuꞌun ni kaꞌan ri. Ni tu ni kandixia ra ja saꞌa ri jniñu ñaꞌnu. Ni kachi Isaías. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ja yukan tu ni kuu kandixia da, ti siaꞌan ni kaꞌan Isaías tuku: ");
INSERT INTO mpmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tu ni jaꞌa Yandios ja na kujnuni ini da. Ni sia ya maa da nava na nduniꞌin ga undi ini añu da. Ka kuu da nanu yɨvɨ kuaa ja tu ka jini da na ichi kiꞌin da, chi tu chaku kuɨtɨ ini da. Ja yukan nu tukaa sia da jniñu ndevaꞌa un, ti ni tu nduvaꞌa undi ini añu da. Ni kachi Jesús, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yukan ni kachi Isaías chi ni jini da ja kuñaꞌnu xaan Jesús, ti ni jani da jnuꞌun sɨkɨ nasa koo kɨvɨ kii ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Vasu ni iyo kuaꞌa ga yɨvɨ hebreo ja tu ni kandixia i Jesús, ko kuaꞌa yɨvɨ ni kejaꞌa ka kandixia da ya. Suni kuaꞌa chaa ka kuñaꞌnu ja ka taꞌu jniñu nuu yɨvɨ hebreo un, ni ka kejaꞌa ka kandixia da. Ko tu ni ka stuu da maa da ja kaꞌan da jnuꞌun ja ka kandixia da, chi ka yuꞌu da chaa fariseo. Chi sandau tukaa kuaꞌa chaa un jnuꞌun ja kɨvɨ da ini veñuꞌun kaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Siaꞌan ni ka saꞌa chaa un, chi ni ka ndiyo xaan ini da ja na kuaꞌa yɨvɨ ja yɨñuꞌun nuu da, ti ansu ja na kuaꞌa maa Yandios ja yɨñuꞌun nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ni kaꞌan jaa Jesús, ti ni kachi ya: ―Yɨvɨ ja ka kandixia ruꞌu, ansu maa ɨɨn ni ruꞌu kandixia da, chi suni kandixia da undi maa Tata ri, ya ni taji ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ti yɨvɨ jini nuu ri, suni ka jini da nuu maa ya ni taji ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kuu ri nanu ɨɨn ñuꞌun ja ndinchaa ñuyɨvɨ jaꞌa, ja na kuni yɨvɨ na ichi kaka da. Nu na kandixia da ruꞌu, ti tukaa ga ka jika da nanu yɨvɨ ka jikonuu nuu ñuñaa, ja tu ka niꞌin da na ichi kiꞌin da. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Ko nu tu kuni kandixia ra ruꞌu, ni tu kuni kuantaꞌu ra jnuꞌun kaꞌan ri. Ko iyo Ɨɨn ja kankuachi sɨkɨ ra ti saꞌa ndaa ya kuachi ra. Chi kii kɨvɨ juicio ja saꞌa ndaa ya sɨkɨ ra, ti xndichi ya roꞌo ndenu ni ka jantaꞌu ra jnuꞌun ri xi tuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ko tu kaꞌan ri jnuꞌun jaꞌa ja kuu ini maa ni ri, chi Tata ri ni taji ruꞌu jiin jniñu jaꞌa. Ti maa ya kuu ja ni kachi nasa koo jnuꞌun kaꞌan ri nuu yɨvɨ ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jini ndaa ri ja nu na saꞌa ra nava kachi Yandios, ti kunchuku ra jiin ya ja kuu saa ni. Ja yukan kuu ja kaꞌan ri jnuꞌun jaꞌa nava ni kachi maa Tata ri nuu ri ―ni kachi Jesús jiin yɨvɨ un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kumani ɨɨn kɨvɨ ga ja kejaꞌa viko pascua un. Ti jini Jesús ja, ja ni jaa kɨvɨ ja kee ya nuu ñuyɨvɨ jaꞌa ti kin noꞌon ya nuu Tata ya. Siaꞌan ja jini ya, kuu ndaꞌu xaan ini ya taka yɨvɨ ni ka skuaꞌa jiin ya. Vijna ti stuu kaji ya ja kundaꞌu ini ya maa da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ko ja ni jini Jesús ja, ja ni kueꞌe jaꞌuꞌu un ini añu Judas, seꞌe Simón, chaa ñuu Cariote, ja nakuaꞌa da Jesús nuu chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Suni jini Jesús ja maa Tata ya ni jaꞌa jniñu nuu ya ja yɨndaꞌa ya taka ja iyo. Jini ya ja vaji ya nuu kancha Tata ya, ti jini ya ja nandeokuñɨ tuku ya nuu kancha Tata ya. Siaꞌan ni ndoꞌo ini ya kɨvɨ ni kuxini ya jiin chaa ka skuaꞌa jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nɨ ka kuxini da ti ni ndokuɨñɨ Jesús. Ni chajiyo ya saꞌma ya, ti ni kiꞌin ya ɨɨn toalla. Ni juꞌni da chii ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yukan ti ni chuꞌun ya nducha ini ɨɨn tɨ jaꞌan, ti ni kejaꞌa nakacha ya jaꞌa ndajaꞌa ya. Ti nasichi ya jaꞌa da jiin toalla nuꞌni chii ya un. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ni jaa ya nuu kancha Simón Pedro, ti ni kachi Pedro jiin ya: ―Jitoꞌyo, ¿va nu nakacha ni jaꞌa na xino? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ti ni kachi Jesús jiin da: ―Tu chaku ini ra ndoo saꞌa ri vijna, ko jaa kɨvɨ ti ndɨꞌɨ nukuꞌun ini ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ti ni kachi Pedro: ―Siaꞌan ko tu nakacha kuɨtɨ ni jaꞌa na ―ni kachi da. Ti ni kachi Jesús: ―Nu tu kuantaꞌu ra ja nakacha ri jaꞌa ra, ti tu niꞌin ra taꞌu ja kuncha ra jiin ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yukan ti ni kaꞌan Pedro jiin ya: ―Jitoꞌyo, vatuni nu na nakacha ni jaꞌa na, ko suni nakacha ni ndaꞌa na jiin xini na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti maa Jesús ni kachi ya jiin da: ―Ɨɨn yɨvɨ sa ni jichi, tukaa nɨnɨ kuu ja kuchi da uu jinu, chi so jaꞌa ni ga da na ndundoo, chi ja iyo ndoo nɨ tuꞌu da. Roꞌo naa ra, chi ja ka iyo ndoo undi ini añu ra, vasu ansu taka ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Siaꞌan ni kachi ya chi ja ni jini ya na chaa kuu ja kin nakuaꞌa ya. Ja yukan kuu ja ni kachi ya ja tu ka iyo ndoo taka da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nu ni ndɨꞌɨ ni nakacha Jesús jaꞌa da naa da, ni nakuiꞌna tuku ya saꞌma da, ti ni nukoo tuku ya nuu mesa. Ni nukoo tuku ya nuu mesa un, ti ni kachi ya jini da naa da: ―¿Ni ka chaku ini ra jniñu ni saꞌa ri jaꞌa xi tuu nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Roꞌo chi ka kaꞌan ra ja kuu ri Maestro ra sɨkɨ ja ni xnaꞌan ri roꞌo ra naa ra. Ti ka kaꞌan ra ja kuu ri jitoꞌo ra, chi kuñaꞌnu ri. Ti vatuni ka kaꞌan ra, chi siaꞌan kuu jniñu ndiso ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ti nu ruꞌu ja kuu ri Maestro, ja kuñaꞌnu ri nuu ra naa ra, ti ni nakacha ri jaꞌa ra. Ti suni siaꞌan roꞌo naa ra, nakacha jaꞌa ñanijnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jniñu jaꞌa ni saꞌa ri ja ni xnaꞌan ri nuu ra naa ra ja na chun ini chun añu ra ja suni siaꞌan saꞌa ra jiin ñanijnaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jandaa na kachi ri ja tendɨꞌɨ ka kuu muzu, chi ni ɨɨn muzu tu kuñaꞌnu ga da nuu jitoꞌo da. Vanuxia kuñaꞌnu ga chaa taꞌu jniñu un. Suni siaꞌan chaa kuu tajnu, tu kuñaꞌnu ga da ja kuu chaa nataꞌu jniñu nuu da, chi chaa nataꞌu jniñu un kuñaꞌnu ga da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ka jini vaꞌa ra tendɨꞌɨ jnuꞌun. Ko kanuu ja na siuku ra siaꞌan nava kachi ri, nava na kunchaa Yandios jiin ra, ti kosɨɨ ini ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ko tu kaꞌan ri sɨkɨ nasa koo jiin tendɨꞌɨ ra naa ra. Chi jini vaꞌa ri nasa kuu jiin taka yɨvɨ ni nakaji ri, ko kanuu ja na jinu ndaa nava kachi tutu Yandios, chi ni kachi sɨkɨ ruꞌu: “Iyo ɨɨn ja kaji staa jiin ri, ti yukan kuu ja saꞌa ndevaꞌa sɨkɨ ri”, kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Siaꞌan ja kaxnuꞌun ri jnuꞌun un nuu ra vijna ti changa ga kundaa ga. Nava nu na kundaa, yukan na ti kandixia ra ja maa ri kuu Cristo ni taji Yandios, chi koo nundoꞌo sɨkɨ ri siaꞌan nava ni kachi ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jandaa na kachi ri ja iyo yɨvɨ taji ri. Ti nu kuantaꞌu yɨvɨ da, suni kuantaꞌu da ruꞌu, ti yɨvɨ kuantaꞌu ruꞌu, suni kuantaꞌu da maa ya ni taji ruꞌu jiin jniñu jaꞌa ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nu ni ndɨꞌɨ ni kaꞌan Jesús jnuꞌun un, ti ni kejaꞌa ndɨꞌɨ kuu ini ya ja undi kaña añu ya. Ja yukan na ti ni kachi kaji ya nuu da naa da: ―Na kachi kaji ri ja ɨɨn ra kuu ja nakuaꞌa ruꞌu nuu yɨvɨ ka jito uꞌu ruꞌu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yukan ti ni ka kejaꞌa ka ndeꞌe nuu jnaꞌan da, chi tu ka jini da nau ɨɨn ɨɨn da kaꞌan ya sɨkɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ti yajni xiin Jesús nukoo ɨɨn chaa mani ga ya jiin, ti ka ndajnuꞌun da jiin ya ni hora ka yaji da staa. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ti Simón Pedro ni saꞌa da ɨɨn seña nuu chaa un ja na kajnuꞌun da ya na ndenu nau sɨkɨ chaa kaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Chaa un ni tuꞌva ga da xiin Jesús, ti ni jikajnuꞌun da ya: ―Jitoꞌyo, ¿na chaa kuu nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ti ni kachi Jesús jiin da: ―Na chuntoo ri ɨɨn pedazu staa stila, ti chaa kuaꞌa ri nuu, chaa yukan kuu ―ni kachi ya. Yukan ti ni chuntoo ya ɨɨn pedazu staa stila, ti ni jaꞌa ya nuu Judas, seꞌe yɨɨ Simón, chaa ñuu Cariote. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ti hora ni jaꞌa ya staa un nuu Judas ni yee da, hora un ni nakueꞌe jaꞌuꞌu un maa da. Yukan ti ni kachi Jesús jiin da: ―Ja ɨɨn jniñu saꞌa ra, ti kuan saꞌa vinañuꞌni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ti ni ɨɨn chaa kanchuku mesa nuu ka yee da staa un, tu ni ka chaku ini da ndoo ni kaꞌan Jesús siaꞌan jiin Judas. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chi vanuxia Judas kuu chaa ndiso xuꞌun da naa da, ti sava da ni ka ndoꞌo ini ja ni kaꞌan Jesús jiin da ja na kin kuaan da nau ja ka nandɨꞌɨ da ja kuu kɨvɨ viko un. Sava ga da ni ka ndoꞌo ini ja na kuaꞌa jaku xuꞌun nuu yɨvɨ ndaꞌu un naa i. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nu ni ndɨꞌɨ ni yaji Judas staa yukan, ti ni kee da kuaꞌan da. Ko ja ni kuaa kuu. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nu ni yaꞌa Judas kuaꞌan da, ti ni kachi Jesús: ―Vijna na ti kuni yɨvɨ ja maa Ɨɨn ni ya kuu Seꞌe Yɨvɨ Ñuyɨvɨ, ja kuñaꞌnu xaan ga jiin ɨɨn jniñu kin saꞌa ya vijna. Ti na kuni ndijin yɨvɨ naa da ja vii kuñaꞌnu Tata yo Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Vijna na ti maa Seꞌe ya xnaꞌan nasa kuñaꞌnu Yandios jiin jniñu saꞌa ya. Vijna na ti nakuaꞌa ndixia Yandios ja yɨñuꞌun nuu maa Seꞌe ya. Vijna ti saꞌa Yandios ja na nduñaꞌnu ga maa Seꞌe ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hijo, ndee kundaꞌu ini ri roꞌo naa ra, ko xaan ga kuɨtɨ hora jaꞌa, ja ɨɨn nundaa ni ga kuncha ri jiin ra ti kiꞌin ri. Ko nanu ni kachi ri nuu yɨvɨ hebreo un, suni siaꞌan na kachi ri nuu ra naa ra vijna. Chi nanduku ra ruꞌu, ko tu kuu kiꞌin ra nuu kiꞌin ri. Tu kuu kundikun ra ruꞌu vijna. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ko na taꞌu ri ɨɨn jniñu jáá nuu ra naa ra, ja na kundaꞌu ini nuu jnaꞌan ra, siaꞌan nanu ni kundaꞌu ini maa ri roꞌo. Ti siaꞌan na kunchuku vii na kunchuku mani ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ti nu vii vii kanchuku ra, ja ka kundaꞌu ini nuu jnaꞌan ra, ti kuni yɨvɨ naa i ja ni ka skuaꞌa ra jiin ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ni kachi Pedro jiin Jesús: ―Jitoꞌyo, ¿nanu kiꞌin ni nusa? ―ni kachi da. Ti ni kachi Jesús jiin da: ―Tu kuu kiꞌin ra nuu kiꞌin ri vijna, ko kuee ga ti sa jaa ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yukan ti ni kachi Pedro: ―Jitoꞌyo, ¿ti ndoo tu kuu kiꞌin na jiin ni vijna? Ja iyo tuꞌva na ja nama na niꞌin vasu na kuū na ja sɨkɨ ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ti ni kachi Jesús jiin da: ―¿Nusa ti tava ini ra kuu ra ja sɨkɨ ruꞌu nu? Ko na kachi ndaa ri ja uni jinu kachi ra ja tu jini ra ruꞌu, ti sa kana ɨɨn liꞌi ja ñaꞌan ijña ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Siin kaꞌan Jesús, ti ni kachi ya: ―Koto xndiꞌi ra ini ra naa ra. Kandixia ndaa nuu maa Yandios. Ti suni kandixia ndaa ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na kachi ndaa ri nuu ra naa ra ja nuu kancha Tata ri, iyo kuaꞌa xaan veꞌe nuu kunchuku yɨvɨ naa i. Ti siaꞌan kaꞌan ri chi jandaa ndixia kuu. Chi sa ti tu, va tu kachi ri siaꞌan nuu ra. Ko vanuxia kin noꞌon ri yukan, ti yukan satuꞌva ri nuu kunchuku ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kiꞌin ri ti satuꞌva ri nuu kunchuku ra. Ti nu ja ni kuu nakoo, nandeokuñɨ tuku ri ti nchaa ri kii nukuaka ri roꞌo naa ra, nava na kunchuku ra nuu kuncha ri yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ko ja ka jini ra ichi nuu kiꞌin ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ti Tomás ni jikajnuꞌun da Jesús: ―Jitoꞌyo, tu ka jini na nachi kiꞌin ni. ¿Ti nasa kuu naniꞌin na ichi un naa na? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ti ni kachi Jesús jiin da: ―Maa ri kuu nanu ɨɨn ichi, ti jnuꞌun kaꞌan ri na kuu ɨɨn ichi ndaa un, chi kaꞌan ri taka jnuꞌun ndaa nuu yɨvɨ, nava na kuni yɨvɨ nau ichi kuu ichi ndaa. Maa ɨɨn ni ruꞌu kuu ja saꞌa ja na kuchaku yɨvɨ ja kuu saa ni, ti kunchuku i jiin Yandios. Ko nu tu kandixia ni ɨɨn yɨvɨ ruꞌu, ti tu kuu kuɨtɨ jakoyo i nuu kancha Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni ka nakuni ra Tata ri chi ja ni ka nakuni ra ruꞌu. Ti undi vijna ja ni ka nakuni ra maa ya, chi ka ndeꞌe ra nuu ya ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yukan ti ni kachi Felipe jiin ya: ―Jitoꞌyo, kuaꞌa ni jnuꞌun ja na ndeꞌe na nuu maa Tata yo Yandios. Jiin yukan ni ti na kuvaꞌa ini na naa na ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ti ni kachi Jesús jiin da: ―Felipe, ja ni kuu naꞌan kancha ri jiin ra ¿ti tu jaꞌi nakuni ra ruꞌu nusa? Ja ni jini ra nuu Tata ri, chi ja ni jini ra ruꞌu. Nusa ti nasa ga kuni ra ja na xnaꞌan ri Tata ri nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kanuu ja na kandixia ra ja kancha Tata ri jiin ri, ti kancha ri jiin maa ya. Jnuꞌun kaꞌan ri nuu ra vijna, tu kaꞌan ri ja ñuꞌun xini maa ri, chi maa Yandios kancha jiin ri, ti maa ya kuu ja saꞌa jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ko kandixia ja kancha Tata ri jiin ri, ti kancha ri jiin ya. Ti nu tu kandixia ra nava kaꞌan ri, ko kandixia ruꞌu ja sɨkɨ taka jniñu saꞌa ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ti na kachi ndaa ri nuu ra naa ra ja nu na kandixia ndaa ra ruꞌu, ti suni kuu saꞌa ra jniñu saꞌa ri, ti vasu ɨɨn jniñu ñaꞌnu ga, ti kuu saꞌa ra naa ra. Chi ruꞌu, kiꞌin ri nuu kancha Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ti taka ndoo na kakan ra nuu Tata ri, ti kakan ra jiin sɨvɨ ri sɨkɨ ja ka yɨꞌɨ ra jiin ri. Chi ndiso ri jniñu ja kuaꞌa ri savaꞌa ni ga ndoo na kakan ra. Ti na ndeꞌe yɨvɨ jniñu saꞌa ruꞌu, ja kuu ri seꞌe ya, ti na kachi i ja kuñaꞌnu xaan Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko na kachi ndaa ri ja taka ndoo na kakan ra nuu ri sɨkɨ ja ka yɨꞌɨ ra jiin ri ti kuaꞌa kueꞌe ri, chi ndiso ri jniñu ja siaꞌan saꞌa ri ―ni kachi Jesús ");
INSERT INTO mpmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Siin kaꞌan Jesús, ti ni kachi ya: ―Nu ka ñukuu ini ra ruꞌu ja mani ri jiin ra, ti kuandatu jniñu taꞌu nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ti ruꞌu, na kakantaꞌu ri nuu Tata ri ja na taji ya Ɨnga ja chindee roꞌo naa ra, ja kuncha ya jiin ra ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Maa ya kuu Espíritu Yandios, ti maa ya ndaa kuɨtɨ kuu ya. Chi mani jnuꞌun ndaa kaꞌan ya. Kuaꞌa ya jnundee ini roꞌo naa ra, ti siaꞌan ni kuncha ya jiin ra ja kuu saa ni. Ko tu chindee ya yɨvɨ ñuyɨvɨ jaꞌa, yɨvɨ ka saꞌa ndevaꞌa un, chi tu ka nakuni kuɨtɨ i maa ya. Ko roꞌo naa ra chi ka nakuni ra maa ya, chi kancha ya jiin ra vijna. Ko jaa ɨɨn kɨvɨ ja kendoꞌo jnuꞌun ya undi ini añu ra, ti yukan kuncha ya ja kuu saa ni jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ko tu xndoo kuɨtɨ ri roꞌo ja kendo ndaꞌu ra naa ra. Chi suꞌva, nchaa tuku ri ti kuncha ri jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ko ja ɨnga yɨvɨ ñuyɨvɨ jaꞌa, jaku ni ga kɨvɨ ti tukaa ga kuni i ruꞌu. Ko roꞌo naa ra, chi nakuni ra ruꞌu, chi vanuxia nachaku tuku ra siaꞌan nanu nachaku tuku ruꞌu. Chi nandoto tuku ri, ti suni siaꞌan nandoto tu roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kɨvɨ na nachaku ri, yukan ti kuni ra ja kancha ri jiin Tata ri, ti maa ya kunchaa ya jiin yo naa yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nu ñuꞌun ini ra jniñu taꞌu ri ti siuku ra, ti yukan ni kundaa ndixia ja mani ra jiin ri. Ti nu mani ra jiin ri, ti suni koo mani Tata ri jiin ra. Nu ñukuu ini ra ja siuku ra jniñu taꞌu ri, ti sa ni ruꞌu koo mani ri jiin ra. Naxnaꞌan ri maa ri nuu ra ja kancha ndixia ri jiin ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yukan ti ni kaꞌan Judas (ko ansu Judas chaa ñuu Cariote), ti ni jikajnuꞌun da: ―Jitoꞌyo, ¿nasa naxnaꞌan ndijin ni maa ni nuu na naa na, ti nuu yɨvɨ ñuyɨvɨ, ndoo tuu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ti ni kachi Jesús jiin da: ―Nu mani yɨvɨ jiin ri, ti jandatu i jnuꞌun kaꞌan ri ti siuku i. Ti undi Tata ri ti suni koo mani ya jiin yɨvɨ un naa i. Ti ruꞌu jiin Tata ri, chaa ri ti kunchuku ri jiin yɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko yɨvɨ ja tu mani jiin ri, chi tu siuku i jnuꞌun kaꞌan ri. Ti jnuꞌun kaꞌan ri jaꞌa, ansu jnuꞌun maa ri kuu. Chi jnuꞌun ni kaꞌan maa Tata ri kuu, vanuxia maa ya ni taji ruꞌu jiin jniñu ja siaꞌan na kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ja ni kuu kuaꞌa jnuꞌun ni xnaꞌan ri nuu ra naa ra vijna nɨ kancha ga ri jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ko Tata ri na taji ya Ɨɨn ja na chindee roꞌo. Ti yukan kuu ja kii nuu ruꞌu, ti maa ya kuu Espíritu Santo. Chaa ya ti xnaꞌan ya roꞌo naa ra, xndaku ya nuu ra, ti saꞌa ya ja na nukuꞌun ini ra taka jnuꞌun ni kaꞌan ri jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sandee ini ra nuu kuaꞌan ri, ko tu xndiꞌi ra ini ra, chi saꞌa ri ja na kosɨɨ ini añu ra, ti na kukuee kunchuku ra. Chi jnuꞌun kaꞌan ri ti siuku ri, ti tu saꞌa ri nanu ka saꞌa yɨvɨ ñuyɨvɨ jaꞌa, ja ka jaꞌa i jnundee ini, ko so ka kaꞌan i. Yukan kuu ja koto kukuiꞌya ini ra jiin taka nundoꞌo, ti koto ma yuꞌu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ja ni ka jini ra ja ni kaꞌan ri ja kin noꞌon ri, ko ndixia ri ja kii tuku ri nuu kanchuku ra nu ka iyo mani ini ra jiin ri. Yukan ti kusɨɨ ini ra naa ra ja kiꞌin ri, chi kiꞌin ri nuu kancha Tata ri. Ti maa ya kuñaꞌnu ga ja kuu ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ni kachi ri nuu ra naa ra ja kin noꞌon ri, ti ndeocuñɨ tuku ri ti kuncha ri jiin ra. Ja ni jani ri jnuꞌun ja siaꞌan koo. Ti sa na kandixia ra nu ja ni kundaa jnuꞌun ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tukaa na jnuꞌun kuaꞌa kaꞌan ri jiin ra naa ra, chi ja vaji jaꞌuꞌu un ja ndiso jniñu nuu yɨvɨ ñuyɨvɨ jaꞌa. Ko tu ndiso jniñu ja nataꞌu jniñu nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na siukun ri siaꞌan nava ni kachi Tata ri nuu ri. Ti siaꞌan nava na nakuni yɨvɨ ñuyɨvɨ ja mani ri jiin Tata ri ti kuu ini ri ya. Ndokuñɨ naa ra, ti ñaꞌan na choꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Siin kaꞌan Jesús, ti ni kachi ya nuu da naa da: ―Maa ri na kuu nanu ɨɨn yoꞌo nuu nutɨkaꞌya vaꞌa, ti Tata ri na kuu nanu ɨɨn chaa jitu nuu nutɨkaꞌya un. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ti maa ra naa ra, chi ka kuu ra nanu ndaꞌa yuku tɨkaꞌya un. Chi nu tu saꞌa vaꞌa ra jniñu ya, ti saꞌa yo nanu ja tu jaꞌa ra ndeꞌe, ti sasɨɨn Tata ri roꞌo, nanu ja kaꞌncha yo ɨɨn ndaꞌa nuu tɨkaꞌya ja tu jaꞌa ndeꞌe un. Ko nu saꞌa vaꞌa ra jniñu ya, ti sandoo ga ya roꞌo, nanu ja sete yo ndaꞌa nuu tɨkaꞌya un nava na kuaꞌa ga ndeꞌe. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ja ni ka ndundoo ra undi ini añu ra, chi ni ka kandixia ra jnuꞌun ni kaꞌan ri jiin ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ko nu na jakuñɨ niꞌin ra jiin ri, ti suni maa ri na kundaka niꞌin ri roꞌo, chi saꞌa ra jniñu vaꞌa nuu ya nu tu jakuñɨ niꞌin ra jiin ri. Suni siaꞌan kuu jiin ndaꞌa yuku nuu tɨkaꞌya un. Nu na kencha ɨɨn ndaꞌa nuu yɨjnɨɨ un, ti tukaa kuaꞌa ndeꞌe, chi nasa kuu kuaꞌa ndeꞌe ti tukaa ga yɨjnɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Maa ri kuu nanu yoꞌo nuu tɨkaꞌya un, ti roꞌo naa ra ka kuu ra nanu ndaꞌa yujnu un. Nu roꞌo na natuꞌva ruꞌu, ti maa ri na kɨndaꞌa niꞌin ri roꞌo naa ra. Yukan na ti vaꞌa xaan kuu jniñu ya, chi nakaya kiꞌin, nanu ja kuun vee ndeꞌe xini nuu tɨkaꞌya un. Ko nu tu kɨndaꞌa niꞌin ri roꞌo naa ra, ti va tu kuɨtɨ na jniñu vaꞌa saꞌa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu tu jakuñɨ niꞌin ra jiin ri, ti sasɨɨn Tata ri roꞌo, nanu ja kaꞌncha yo ndaꞌa yujnu ja tu jaꞌa ndeꞌe, na ichi. Yukan na ti nastutu yo ja na kayu nuu ñuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ko nu ni ka jakuñɨ niꞌin ra jiin ri, ti kuꞌun ini ra jnuꞌun kaꞌan ri. Yukan na ti kakan ra ja kuni ra, ti kuaꞌa ri savaꞌni ga ndoo na kakan ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu siaꞌan na siuku ra taka un, yukan na ti ka stuu ra maa ra ja ka kundixia ra yɨvɨ ka skuaꞌa jiin ri. Siaꞌan na ti nakuni yɨvɨ ja kuñaꞌnu xaan ga Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mani ri jiin ra naa ra siaꞌan nanu mani Tata ri jiin ri. Yukan kuu ja niꞌin kujiin ra naa ra ti kunchuku mani ra sɨkɨ ja kundaꞌu ini ri roꞌo. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu siaꞌan na saꞌa ra ti kuandatu ra jniñu taꞌu ri. Yukan ti ka ñukuu ini ra ruꞌu ja mani ri jiin ra. Chi suni siaꞌan ni jandatu ri nuu Tata ri, ti ñukuu ini ri ja mani ya jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Taka jnuꞌun jaꞌa xndaku ri nuu ra naa ra ja na kuandatu ra, nava siaꞌan na niꞌin ra jnuꞌun ndee ini ti na koo sɨɨ ndixia ini ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ti jaꞌa kuu ɨɨn jniñu taꞌu ri nuu ra, ja na kundaꞌu ini nuu jnaꞌan ra, siaꞌan nanu ni kundaꞌu ini ri roꞌo naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nu vasu na kuu ɨɨn chaa, ja nama da amigo da sɨkɨ ja kundaꞌu ini da, ti yukan kuu ɨɨn jniñu kaꞌnu ja kuu nuu Yandios. Chi tukaa iyo ɨɨn jniñu kanuu ga ja kuu saꞌa yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ti roꞌo naa ra, ka kuu ra amigo ri nu ka siuku ndaa ra jniñu taꞌu ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vijna ti tukaa kachi ri ja ka kuu ra nanu muzu ri, chi ɨɨn muzu tu jini da nasa ndoꞌo ini jitoꞌo da. Na kaꞌan ri amigo vijna na, chi ja ni kachi ndaa ri nuu ra naa ra taka ja ni kaꞌan Tata ri jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tu ni ka nakaji ra ruꞌu ja na kundichi ri jiin ra. Chi suꞌva, maa ri ni nakaji roꞌo ja na kɨꞌɨ ra jiin ri. Ni jaꞌa ri jniñu saꞌa ra, ti nu na saꞌa ra ɨɨn jniñu ja kendo vaꞌa, ti ni tukaa naa. Ti kuaꞌa Tata ri ndɨꞌɨ ja na kakan ra nuu ya sɨkɨ ja ka yɨꞌɨ ra jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ti jaꞌa kuu ɨɨn jniñu taꞌu ri nuu ra naa ra, ja na kundaꞌu ini nuu jnaꞌan ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Nu na kuɨtɨ ini yɨvɨ ñuyɨvɨ nuu roꞌo naa ra, ti ja ka jini ra ja xnakan nuu maa ri ni ka kuɨtɨ ini i. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sa ti ɨɨn nu kanda ra jiin yɨvɨ ñuyɨvɨ, ti va koo mani i jiin ra niku, siaꞌan nanu mani i jiin jnaꞌan i. Ko suꞌva, ka kuɨtɨ ini i chi ni nakaji ri roꞌo naa ra ja na kujiin ra jiin ri. Chi tukaa ga ka saꞌa ra ja ka saꞌa yɨvɨ ñuyɨvɨ un. Ja yukan kuu ja ka kuɨtɨ ini i nuu ra naa ra, chi tukaa ka kuu ra nanu yɨvɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Koto naa ini ra ja ni kachi ri, chi ni kachi ri ja ɨɨn muzu tu kuñaꞌnu ga da nuu jitoꞌo da, chi chaa taꞌu jniñu un, kuñaꞌnu ga da. Yukan kuni kaꞌan ja kuaꞌa yɨvɨ nundoꞌo roꞌo ra naa ra, ja ka yɨꞌɨ ra jiin ri, suni siaꞌan nanu ni ka saꞌa i jiin ri. Siaꞌan kuu yɨvɨ un, chi nu ni ka jantaꞌu i jnuꞌun ri, ti suni siaꞌan na kuantaꞌu jnuꞌun kaꞌan ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Siaꞌan saꞌa i jiin ra chi vanuxia ka yɨꞌɨ ra jiin ri. Siaꞌan saꞌa ndevaꞌa yɨvɨ un jiin ra, chi vanua tu ka nakuni kuɨtɨ i maa Yandios, ya ni taji ruꞌu jiin jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ni kii ri ti ni kachi ndaa ri nuu yɨvɨ naa i ja ka iyo kuachi sɨkɨ i. Vijna ti tu kuu kaꞌan i ja tu jini i ja ka iyo kuachi sɨkɨ i. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ti yɨvɨ kuɨtɨ ini nuu ri, yukan ti suni ja kuɨtɨ ini i nuu Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iyo kuachi sɨkɨ i chi ni saꞌa ri jniñu ñaꞌnu nuu i, ko tu ni ka kandixia i. Kɨvɨ ja ja ni yaꞌa, tu ni ɨɨn chaa ni saꞌa siaꞌan, ko vijna ti ni ka jini yɨvɨ naa i jniñu ñaꞌnu ni saꞌa ri. Ti vasu siaꞌan ko ka kuɨtɨ ini i nuu ri jiin Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Siaꞌan ka saꞌa i nava na kee ndaa jnuꞌun yoso nuu tutu ley Yandios, ja kachi: “Ni kuɨtɨ ini i nuu ri, vasu tu na kuachi ri”, kachi tutu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Kɨvɨ na najaa ri nuu kancha Tata ri, ti taji ri Ɨɨn ya kii chindee ga roꞌo, ti maa ya kuu Espíritu Santo, ti Espíritu yukan kuu ja xnaꞌan jnuꞌun ndaa. Chaa ya ti kuaꞌa ya jandaa jaꞌa ri ja kuu nuu taka jnuꞌun ni kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yukan kuu ja suni roꞌo naa ra, kuaꞌa ra jandaa jaꞌa ri ja kaꞌan ra jnuꞌun ri, chi ni ka jika ra jiin ri undi na ni kejaꞌa kaꞌan ri jnuꞌun un nuu yɨvɨ naa i ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Siin kaꞌan Jesús, ti ni kachi ya: ―Taka jnuꞌun ni xnaꞌan ri nuu ra naa ra na saꞌa ja na kundee ini ra ti tu xndoo ra jnuꞌun ri, vasu na kii nundoꞌo un sɨkɨ ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Chi keniꞌin yɨvɨ roꞌo ti tukaa kuaꞌa da jnuꞌun kuꞌiin ra veñuꞌun. Jaa kɨvɨ ti kaꞌni roꞌo, ti kani ini da ja ɨɨn jniñu vaꞌa ni saꞌa da nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ti siaꞌan saꞌa i chi tu ka jini kuɨtɨ da ruꞌu, ni tu ka jini kuɨtɨ i nuu Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ni kachi ri jnuꞌun jaꞌa nuu ra nava nu ni jaa kɨvɨ ja kondoꞌo ra, yukan na ti nukuꞌun ini ra ja siaꞌan ni kachi ri nuu ra naa ra ―ni kachi ya. Siin Jesús kaꞌan ya, ti ni kachi ya: ―Tu ni kachi ri yukan nuu ra undi nuu, chi nɨ kuncha ga ri jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ko vijna chi kinoꞌon ri nuu kancha maa ya ni taji ruꞌu. Ti vasu yukan kaꞌan ri, ko ni ɨɨn ra tu ka jikajnuꞌun nanu kiꞌin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chi sa ka kukuiꞌya xaan ini ra ja ni kaꞌan ri taka jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ko jandaa kaꞌan ri ja vaꞌa ga kendo ra nu na kinoꞌon ri. Chi nu tu noꞌon ri, ti maa ya kii chindee roꞌo, tu kuu kii ya. Ko vaꞌa ga na kiꞌin ri, ti na taji ri maa ya na kii ya nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Nu na chaa ya, ti na xnaꞌan kaji ya nuu yɨvɨ naa i ja ka iyo kuachi i, chi maa kuachi un saꞌa ja tu ka kandixia i ruꞌu. Na xnaꞌan ya na ichi kuu ichi vaꞌa ja na kendo ndaa yɨvɨ naa i nuu Yandios. Chi vanuxia kinoꞌon ri nuu Tata ri, ti tukaa ga kuni ra nuu ri. Na xnaꞌan kaji ya ja nasaꞌa ndaa Yandios kuachi yɨvɨ, chi ja ni kundaa ja jnaꞌnu ndatu maa jaꞌuꞌu ja kuñaꞌnu nuu ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ti iyo kuaꞌa ga jnuꞌun ja kuni kachi ri nuu ra naa ra. Ko tu kuu kachi ri, chi roꞌo tu chaku ini ra vijna. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na chaa maa ya kuu Espíritu Santo, ti sa na xnaꞌan ndaa ya jnuꞌun un, chi maa ya kuu ya ndaa ndixia. Ti tu kaꞌan ya ja ndoꞌo ini maa ya. Chi suꞌva, kaꞌan ya jnuꞌun ni kaꞌan maa Yandios. Ti xnaꞌan ya taka ja koo kɨvɨ vaji. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xnaꞌan ya ja kuñaꞌnu ri, chi nakachi ya jnuꞌun un nuu ra taka jnuꞌun ni kachi ri nuu ya, ti saꞌa ya ja na nukuꞌun ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndɨꞌɨ nasa kuñaꞌnu Tata ri, suni siaꞌan kuñaꞌnu maa ri. Yukan kuu ja ni kachi ri ja Espíritu Santo kuu ya nakachi ndɨꞌɨ jnuꞌun un nuu ra taka jnuꞌun kaꞌan ri, ti saꞌa ya ja na chaku ini ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Jaku ni ga kɨvɨ ti tukaa ga kuni ra ruꞌu. Ko na kuu uni kuun kɨvɨ ti nakuni tuku ra ruꞌu ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yukan ti sava chaa ka skuaꞌa jiin ya, ka jikajnuꞌun jnaꞌan da: ―¿Ndoo ni kaꞌan ya jiin yo siaꞌan? Kaꞌan ya ja jaku ni ga kɨvɨ ti tukaa ga kuni yo maa ya, ti nu na kuu ni ga kɨvɨ ti nakuni tuku yo ya. Suni ni kachi ya ja kin noꞌon ya nuu kancha Tata ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ndoo ni kachi ya ja siaꞌa jaku ni ga kɨvɨ nusa? Tu ka chaku ini yo nasa kuni kaꞌan ya ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ni jini Jesús ja ka kuni kajnuꞌun da ya. Yukan ti ni kachi ya nuu da naa da: ―Ni kaꞌan ri ja jaku ni ga kɨvɨ ti tukaa ga kuni ra ruꞌu, ti nu na yaꞌa jaku ni kɨvɨ ti nakuni tuku ra ruꞌu. ¿Ti yukan kuu ja ka jikajnuꞌun jnaꞌan ra nasa kuni kaꞌan jnuꞌun un nu? ");
INSERT INTO mpmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Vanuxia na kachi ndaa ri nuu ra ja koo ra jnukuiꞌya ini ti katɨ ra nducha nuu ra. Ko yɨvɨ ñuyɨvɨ jaꞌa chi sa suꞌva katu ndaꞌa da ja xaan tonto sɨɨ kuu ini da. Ti jandaa ni kuu ja koo ra jnukuiꞌya ini naa ra nu na jaa kɨvɨ. Ko nu na yaꞌa kɨvɨ un ti ndusɨɨ xaan tonto ga ini ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Saꞌa yo nanu. Ɨɨn ñaꞌan ja kuan kuyajni kaku seꞌe ña, ti jaꞌncha i chii ña, chi ja ni jaa kɨvɨ ja kaku suchi lulu un. Ko nu ja ni kaku suchi lulu un, ti tukaa naꞌan ña ja ni ndoꞌo ña, chi kusɨɨ xaan ini ña ja ni yaꞌa vaꞌa ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ti suni siaꞌan kuu ja ka kukuiꞌya ini ra vijna, ko jaku ni kɨvɨ ti nakuni jnaꞌan tuku yo. Yukan na ti ni ɨɨn tundo kasɨ ja xaan sɨɨ kuu ini ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nu na jaa kɨvɨ noꞌon ri nuu Tata ri, ti tukaa ndoo kajnuꞌun ra ruꞌu. Chi jandaa na kachi ri ja nuu maa Tata ri kuu nu kakan ra, ti na kuaꞌa ya ndɨꞌɨ ja ka jikan ra, sɨkɨ ja ka kandixia ra ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Undi vijna ti tundo ka jikan ra nuu Tata ri sɨkɨ ja ka yɨꞌɨ ra jiin ri. Ko vijna ti kakan ra nuu ya jiin sɨvɨ ri sɨkɨ ja ka yɨꞌɨ ra jiin ri. Kakan naa ra nuu Tata ri, ti na kuaꞌa ya nuu ra, nava yukan ti na kusɨɨ xaan ga ini ra ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Siin Jesús kaꞌan ya, ti ni kachi ya: ―Ja ni jani ri jnuꞌun nuu ra naa ra, ko ndee tɨjnɨ jinu ni kaꞌan ri jnuꞌun yɨɨ tɨꞌlɨ ja chaku ini ra. Ko jaa kɨvɨ nuu tukaa kaꞌan ri siaꞌan, chi sa suꞌva kachi ndaa ri nuu ra nasa saꞌa jniñu Tata ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kɨvɨ yukan na ti kakan ra nuu Tata ri sɨkɨ ja ka yɨꞌɨ ra jiin ri. Ti tu kachi ri ja tukaa kakantaꞌu ri jaꞌa ra naa ra, chi vanua ja ka jini ra ja nɨnɨ kaꞌan ri jiin Tata ri ja na kuaꞌa ya ja ka jikan ra nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ti jandaa ndixia kuu yukan, chi kundaꞌu ini Tata ri roꞌo naa ra sɨkɨ ja ka iyo mani ra jiin ri, ti ka kandixia ra ja vaji ri undi nuu maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni kee ri undi nuu kancha Tata ri, ti ni kenda ri nuu ñuyɨvɨ. Vijna ti kee ri nuu ñuyɨvɨ jaꞌa, ti kinoꞌon tuku ri nuu Tata ri ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ti ni ka kachi chaa ka skuaꞌa jiin ya: ―Vijna na ti kaꞌan kaji ni, chi tukaa kaꞌan ni jnuꞌun yɨɨ ja tu chaku ini na. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vijna ti ni jini na ja jini ndɨꞌɨ kuɨtɨ ni. Tu nɨnɨ kuu ja kajnuꞌun yɨvɨ maa ni, chi ja jini ni nau ja ndoꞌo ini i ja kajnuꞌun i nuu ni. Ja yukan na kandixia ndaa na ja vaji ni undi nuu kancha maa Yandios ―ni ka kachi da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ti ni kachi Jesús jiin da naa da: ―Undi vijna ti sa ni ka kandixia nusa. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ko ja ni kuyajni ndaa kɨvɨ, ti ja ni jaa hora ja kuichanuu ra kinkoyo ra, ti ndɨ ɨɨn ndɨ ɨɨn ra nachanuu ra veꞌe ra. Ti xndoo ra maa ɨɨn ni ga ruꞌu kendo ri. Ti vasu na xndoo maa ɨɨn ra ruꞌu, ko kancha Tata ri jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Siaꞌan kaꞌan ri nava na kukuee undi ini añu ra. Chi jandaa ndixia kuu ja kondoꞌo konene ra nuu ñuyɨvɨ jaꞌa, ti koto ndukuiꞌya ini ra naa ra, kuaꞌa saꞌa ini ra naa ra maa ra, suꞌva na kosɨɨ ini añu ra, chi ja ni kundee ri jiin ɨɨn ja kanaa sɨkɨ ra nuu ñuyɨvɨ jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yukan ti ni ndakoto Jesús ichi andɨvɨ ti ni kachi ya jiin Tata ya: ―Tata na, ja ni jaa kɨvɨ ja kondoꞌo na. Vijna ti stuu ni ja kuñaꞌnu na, ja kuu na seꞌe ni, nava suni maa na na stuu na ja kuñaꞌnu ga maa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ni jaꞌa ni jniñu nuu na ja na taꞌu na jniñu nuu yɨvɨ kanchuku nuu nɨ tuꞌu nɨ kaa nuyɨvɨ naa i. Ti ni saꞌa ni ja yɨvɨ ni nakaji ni, na ndɨvɨ i ndaꞌa na, ja na kuchaku i jiin yo ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ti siaꞌan kuchaku da chi ni ka nakuni i niꞌin, ja niꞌin kuu maa ɨɨn ni Yandios ndaa. Suni ni ka nakuni da saña ja kuu na Jesús, ya kuu Cristo ni taji ni jiin jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ni xnaꞌan na nuu yɨvɨ ñuyɨvɨ ja kuñaꞌnu ni, ti ni sinu na jniñu ni tatu ni nuu na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ti vijna, Tata na, saꞌa ni ja na nduñaꞌnu tuku na undi nuu kancha ni, siaꞌan nanu ni kuñaꞌnu na jiin ni undi na ti jankoo ga ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ni nachiꞌi ni yɨvɨ ñuyɨvɨ jaꞌa nuu ndaꞌa na, ti ni xnaꞌan na nuu da nau kuu niꞌin. Maa ni ni yɨndaꞌa da undi nuu, ti vijna ni nachiꞌi ni i nuu ndaꞌa na, chi ni ka jandatu da jnuꞌun ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vijna ti ka jini ndaa da ja undi nuu maa ni vaji taka ja saꞌa na, jiin taka jnuꞌun kaꞌan na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ni nakachi na nuu da naa da, siaꞌan nava ni kaꞌan ni jiin na. Ti ni ka chunsoꞌo da jnuꞌun ni kaꞌan na, chi ni ka nakuni ndaa da ja undi nuu maa ni vaji na, ti ka kandixia da ja maa ni kuu ja ni taji saña jiin jniñu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ti jikantaꞌu na nuu ni ja kuu taka yɨvɨ ni ka kandixia, ansu ja kuu yɨvɨ ñuyɨvɨ ja tu ka kandixia. Siaꞌan kandaꞌu na jiin ni ja kuu yɨvɨ ni nachiꞌi ni ndaꞌa na, chi nuu ndaꞌa maa ni ni ka yɨꞌɨ i, ko vijna ti ja ni nduu nanu na i. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chi taka ja yɨꞌɨ ndaꞌa na, suni ja kuu maa ni kuu. Ti taka ja kuu maa ni, suni ja kuu maa na kuu. Chi vanuxia ka kandixia da saña, ti jiin jnuꞌun yɨñuꞌun kanchuku da nuu ñuyɨvɨ jaꞌa ti ka stuu da ja kuñaꞌnu na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Saña, tukaa kuncha na nuu ñuyɨvɨ jaꞌa, chi na jaa na nuu kancha ni. Ko yɨvɨ ni nachiꞌi ni ndaꞌa na, chi kendo i kunchuku ga i nuu ñuyɨvɨ jaꞌa. Yukan kuu ja jikantaꞌu na nuu ni Tata na, ja ii kuu sɨvɨ ni ti ndoo xaan ga ni, chi maa ni kuu ya kuñaꞌnu. Koto ndaꞌu ni taka yɨvɨ ni nachiꞌi ni nuu ndaꞌa na nava tu naa i, ti na koo ɨɨn nuu ini i siaꞌan nanu ka iyo ɨɨn nuu ini maa yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ni kuncha na jiin i nuu ñuyɨvɨ jaꞌa. Ni jito naa i ti ni na maa i ja ni ndito vaꞌa na i, chi vanuxia siaꞌan ni tatu ni saña ja na koto vaꞌa na i. Ti ni ɨɨn tu ni ka naa, chi nɨnɨ ɨɨn vajnuꞌun ni da ni naa ja na kundaa nava yoso nuu tutu ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Vijna ti ndeokuñɨ na nuu ni Tata na, ko kaꞌan na jnuꞌun jaꞌa nava na kusɨɨ ini da siaꞌan nanu iyo sɨɨ ini maa na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ni xndaku na jnuꞌun ni nuu da naa da. Ti sa suꞌva ni ka kejaꞌa ka jito uꞌu yɨvɨ ñuyɨvɨ jaꞌa maa da. Chi vanuxia ansu ɨɨn ni ka kuu da jiin yɨvɨ ñuyɨvɨ jaꞌa. Chi tu ka ndoꞌo ini da nanu ka ndoꞌo ini yɨvɨ ñuyɨvɨ jaꞌa, nanu maa na tu ndoꞌo ini na nanu ka ndoꞌo ini yɨvɨ ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tu kaꞌan na ja na keniꞌin ni maa da naa sa nuu ñuyɨvɨ jaꞌa. Chi suꞌva jikantaꞌu na nuu ni Tata na, ja na koto vaꞌa ni maa da, nava jaꞌuꞌu un tu kuu saꞌa ndevaꞌa sɨkɨ da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Vanuxia ansu ka kuu da nanu yɨvɨ ñuyɨvɨ jaꞌa, nanu maa na suni tu yɨꞌɨ na jiin yɨvɨ ñuyɨvɨ jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ja siaꞌan ka saꞌa jniñu da nuu ni, ti na sandoo ni maa da jiin jnuꞌun ni. Chi jnuꞌun ni kuu maa jnuꞌun ndaa. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ni taꞌu na jniñu nuu da naa da, siaꞌan nanu ni taꞌu ni jniñu nuu maa na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ja kuu nuu maa da naa da kuu ja soko na maa na ja na kuū na, nava suni maa da kondoꞌo maa ni konene da nuu nɨ kanchuku i nuu ini ñuyɨvɨ jaꞌa. Yukan saꞌa i chi ka nakutu ini i jiin maa jnuꞌun ndaa ―siaꞌan ni jikantaꞌu Jesús nuu Tata ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Siin kaꞌan Jesús jiin Yandios, ti ni kachi ya: ―Jikantaꞌu na nuu ni Tata na, ja kuu sɨkɨ maa da naa da, ko suni jikantaꞌu na nuu ni ja kuu sɨkɨ yɨvɨ kunsoꞌo jnuꞌun ka kaꞌan da, ti na kandixia i saña. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jikantaꞌu na ja ɨɨn nuu na koo ini da naa da chi ɨɨn ni ga ka kuu da ja ni ka kandixia da saña, siaꞌan nanu ɨɨn ni kuu maa na jiin niꞌin. Tata na. Siaꞌan na koo ɨɨn nuu ini da jiin ñanijnaꞌan da nava na ndeꞌe yɨvɨ ñuyɨvɨ yukan, ti na kandixia i ja maa ni kuu ja ni taji saña. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni saꞌa ni ja na nakuni yɨvɨ ja ɨɨn ni kuñaꞌnu na jiin maa ni, Tata na. Suni siaꞌan ni saꞌa na jiin yɨvɨ ka kandixia saña. Ni sañaꞌnu na maa da naa da nava ɨɨn nuu ni ka kuu i jiin na, nava siaꞌan na nakuni yɨvɨ ñuyɨvɨ ja ka iyo ɨɨn nuu ini i jiin yo. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɨɨn ni ga ni ka kuu i jiin na, siaꞌan nanu ɨɨn ni kuu na jiin maa ni. Ja yukan kuu ja ɨɨn nuu kuɨtɨ ka iyo ini da naa da, nava nu na kuni yɨvɨ ñuyɨvɨ yukan, ti nakuni ndaa i ja maa ni ni taji saña. Na nakuni ndaa yɨvɨ ñuyɨvɨ un ja mani xaan ni jiin da naa da, siaꞌan nanu mani xaan ni jiin maa na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata na, ni nachiꞌi ni maa i nuu ndaꞌa na naa i, ko vijna ti kuni na ja na kunchuku i jiin na nuu kuncha na, nava na kuni i nasa vii xaan kuñaꞌna na jiin jniñu ni jaꞌa ni nuu na. Siaꞌan na kuni i ja mani xaan ni jiin na undi changa ga jankoo ñuyɨvɨ ti undi vijna. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata na, iyo ndaa kuɨtɨ jniñu saꞌa ni. Ti vasu siaꞌan, ko yɨvɨ ñuyɨvɨ, tu ka nakuni kuɨtɨ i niꞌin. Ko maa na, chi nakuni na niꞌin. Ti yɨvɨ jaꞌa, mani i jiin na, chi ka jini i ja maa ni ni tatu jniñu nuu na. ");
INSERT INTO mpmNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ni xnaꞌan na nuu i naa i da ja maa ni kuu Yandios vaꞌa. Ti siin ga na xnaꞌan na yukan nuu i nava na koo mani xaan i jiin ñanijnaꞌan i, siaꞌan nanu iyo mani xaan ni jiin maa na. Ti xndaku na nuu i ja kuncha na jiin i kɨvɨ vaji ga. Yukan kuu ja jikantaꞌu na nuu ni, Tata na, ti siaꞌan kaꞌan na jaꞌa yɨvɨ mani jiin na ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Siaꞌan ni kaꞌan Jesús, yukan na ti kiꞌin ga. Kuaꞌan ya jiin ndajaꞌa ya. Ni yaꞌa ya ɨnga yuꞌu yucha Cedrón. Ni ka jakoyo da nuu iyo ɨɨn huerta mani yujnu vixi, ti yukan ni ka kɨvɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ti suni jini Judas nuu kande huerta un, chi vanuxia tɨjnɨ jinu ni ndututu Jesús jiin chaa ka skuaꞌa jiin ya yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ti yukan ni jaa Judas jiin kuaꞌa xaan soldado, jiin tajnu ni ka taji sutu ka kuñaꞌnu un jiin chaa fariseo, ti ni ka jakoyo da yukan. Ti ndinchaa kuaꞌa ni ga ñuꞌun yɨtɨ ka yɨjnɨ da kuajakoyo da. Ti ka ndiso da espada jiin yujnu. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ko ja jini maa Jesús na nundoꞌo vaji sɨkɨ ya. Ni kenda ya ichi nuu da naa da, ti ni kachi ya: ―¿Na chaa ka nanduku ra naa ra? ");
INSERT INTO mpmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ti ni ka kachi da: ―Ka nanduku na Jesús, chaa ñuu Nazaret ―ni kachi da. Ti ni kachi Jesús: ―Maa ri kuu ―ni kachi ya. Ti yukan kandichi Judas maꞌñu chaa un naa da, vanuxia maa da kuu ja ni nakuaꞌa Jesús nuu chaa ka jito uꞌu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nu ni kachi Jesús: “Maa ri kuu”, ti ni ka jika yata chaa un, ti ni ka jiokava da nuu ñuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yukan ti ni jikajnuꞌun tuku ya: ―¿Na chaa ka nanduku ra nusa? Ti ni ka kachi da: ―Ka nanduku na Jesús, chaa ñuu Nazaret. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ti ni kachi tuku Jesús nuu da naa da: ―Ja ni kachi ri ja maa ri kuu, ti nu ruꞌu ka nanduku ra ko sia chaa jaꞌa na kinkoyo da, nuu maa ri ve kiꞌin ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Siaꞌan ni kachi ya nava na kundaa jnuꞌun ni kaꞌan ya jiin Tata ya: “Tu ni jaꞌa na jnuꞌun ja naa ni ɨɨn chaa ni jaꞌa ni nuu na”, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yukan ti ni tava Pedro espada da, ti ni jaꞌncha da soꞌo kuaꞌa ɨɨn chaa nani Malco, chaa kuu muzu maa sutu kuñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ti ni kachi Jesús jiin Pedro: ―Nasavaꞌa espada ra ini cubierta. Chi siuku ri nava ni kachi Tata ri ja kondoꞌo ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yukan na ti soldado un jiin capitán da, jiin policía chaa hebreo un, ni ka jnɨɨ da Jesús, ti ni ka juꞌni da ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ti kuankoyo da jiin ya xnakan veꞌe Anás, chaa kuu tata chiso Caifás. Ti Caifás kuu maa sutu kuñaꞌnu ga na kuiya yukan. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás ni kuu chaa ni kachi nuu jnaꞌan da hebreo ja vaꞌga ja na kuū ɨɨn ni chaa ja kuu nuu yɨvɨ nɨ ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ni ndikun da Jesús nuu kuaꞌan ya jiin soldado un. Suni ni ndikun ɨnga ndajaꞌa Jesús. Ti sutu kuñaꞌnu ga un ni jini mani da jiin chaa un. Yukan kuu ja ni kɨvɨ da jiin Jesús nuu yuxeꞌe sutu kuñaꞌnu ga un. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ko ni kendo Pedro yajni yuxeꞌe. Chi iyo ɨɨn ñaꞌan ndito yuxeꞌe un. Ti yukan ni kenda chaa ni jini mani jiin sutu kuñaꞌnu ga un, ti ni kaꞌan da jiin ñaꞌan ndito yuxeꞌe un. Yukan na sa ni kɨvɨ Pedro yuxeꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ko ñaꞌan un ni kachi ña jiin Pedro: ―¿Ansu niꞌin kuu ɨɨn ja ni jika jiin Jesús nu? ―kachi ña. Ti ni kachi Pedro: ―Ansu kuu ri ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ti muzu un jiin policía, ni ka joto da ñuꞌun jiin tɨkayɨ, ti yukan kaꞌiin da ka nduxin da, chi vijin xaan saꞌa. Ti Pedro, suni kandichi da yukan, nduxin da ñuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yukan na ti Anás, ja kuu sutu kuñaꞌnu un, ni kejaꞌa jikajnuꞌun da Jesús nau ka kuu yɨvɨ ka skuaꞌa jiin ya. Jikajnuꞌun da ya na jnuꞌun ni xnaꞌan ni nuu yɨvɨ naa i. Ti ni kachi Jesús: ");
INSERT INTO mpmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","―Nɨnɨ ni kaꞌan ri nuu chitu un nuu yɨvɨ naa i. Ni xnaꞌan ri tɨjnɨ veñuꞌun Israel jiin ini veñuꞌun kaꞌnu nuu ka ndututu jnaꞌan yo un. Tu ni ɨɨn jnuꞌun ni chi saꞌyɨ ri. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Koto kajnuꞌun ra ruꞌu. Kajnuꞌun maa yɨvɨ naa i, chi ni ka jinisoꞌo i ndɨ kuɨtɨ jnuꞌun ni kaꞌan ri. Ti ka jini ndaa i na jnuꞌun ni kaꞌan ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Siaꞌan ni kachi Jesús, ti ɨɨn policía ndito veñuꞌun kaꞌnu un, kandichi yajni da xiin Jesús, ti ni kani ni da ɨɨn jikɨ nuu ya, ti ni kachi da: ―¿Vanu siaꞌan kaꞌan ra jiin sutu kuñaꞌnu nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ti ni kachi Jesús: ―Nu ni kaꞌan ndevaꞌa ri, ¿ti kachi na ɨɨn jnuꞌun kueꞌe ni kaꞌan ri nusa? Ko nu suꞌva ni kaꞌan ndaa ri, ¿ti ndo ni jaꞌa ra jikɨ nuu ri? ―ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yukan ti Anás, ni nasiaꞌa da ya nuu kancha Caifás, chaa ni kuu maa sutu kuñaꞌnu ga. Ti nuꞌni ya kuaꞌan ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti Simón Pedro siin da nduxin da yuñuꞌun yukan, ti ni ka jikajnuꞌun sava chaa un maa da: ―¿Ti ansu ni skuaꞌa ra jiin Jesús nu? Ti ni kachi Pedro: ―Tuu, tu ni skuaꞌa ri jiin da ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Suni yukan kandichi ɨɨn muzu ja junukuachi nuu sutu kuñaꞌnu ga un. Kuu da jnaꞌan chaa ni jaꞌncha Pedro soꞌo un, ti ni kachi da jiin Pedro: ―¿Ndoo tuu, ti ni jini ri roꞌo yukan, na hora ni ka jnɨɨ da Jesús nuu huerta un? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ko ni kachi tuku Pedro ja ansu maa da kuu. Ti hora un ni kana liꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yukan ti ni ka kekoyo da nuu kancha Caifás, ti ni ka nasiaꞌa da Jesús undi nuu kancha gobernador ja yɨꞌɨ jiin chaa romano. Ja kuan kuxian tɨꞌlɨ kuu. Ti chaa hebreo un tu ni ka kuni kɨvɨ da ini veꞌe palacio gobernador nava tu chakuachi da sɨkɨ da, chi ka kuni da koo ndoo da ja na kuxini da lelu viko pascua. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yukan kuu ja ni kenda Pilato fuera nuu kaꞌiin yɨvɨ un, ti ni jikajnuꞌun da: ―¿Na kuachi ka kaꞌan ra sɨkɨ chaa jaꞌa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ti ni ka kaꞌan da: ―Ɨɨn chaa jaꞌni ñaꞌan kuu chaa jña. Ja yukan kuu ja vee nchaka na da nuu ni ―ni kachi yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yukan ti ni kachi Pilato: ―Xndichi maa ra chaa jaꞌa nava kaꞌan ley ra naa ra ―ni kachi da. Ti ni ka kachi tuku yɨvɨ hebreo un: ―Tu ka iyo ichi na ja kaꞌni na ni ɨɨn yɨvɨ ―ni ka kachi i. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yukan ni kundaa nava ni kaꞌan Jesús, chi ni kachi ya nasa kuū ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ni kana da Jesús, ti ni jikajnuꞌun da ya: ―¿Maa ra kuu ja taꞌu jniñu nuu yɨvɨ hebreo nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ti ni kachi Jesús: ―¿Siaꞌan ndoꞌo ini maa ra, xi ɨnga yɨvɨ ni kachi ja siaꞌan kuu nu? ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ti ni kachi Pilato: ―Ansu chaa hebreo kuu ri ja kaꞌan ra siaꞌan. Sutu ka kuñaꞌnu jiin jnaꞌan maa ra hebreo un ni ka nakuaꞌa da roꞌo nuu ri jaꞌa. ¿Ndo ni kuu, xi ndoo ni saꞌa ra nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ti ni kachi Jesús: ―Jniñu ndiso ri tu yɨꞌɨ jiin ñuyɨvɨ jaꞌa. Chi sa ti siaꞌan, ti va kanaa taka yɨvɨ ka jika jiin ri ja nama i ruꞌu, ti tu kuaꞌa i jnuꞌun ja jnɨɨ yɨvɨ hebreo ruꞌu. Ko ansu siaꞌan kuu, chi jniñu ndiso ri tu yɨꞌɨ jiin ñuyɨvɨ jaꞌa ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yukan ti ni kachi Pilato jiin ya: ―¿Nusa ti ndiso jniñu ra ja taꞌu ra jniñu nuu yɨvɨ ñuyɨvɨ nusa? ―kachi da. Ti ni kachi Jesús: ―Ni kachi ra ja taꞌu ri jniñu nuu yɨvɨ. Ti jandaa ndixia kuu, chi ja yukan vaji ri nuu ñuyɨvɨ jaꞌa. Ja sɨkɨ yukan ni kaku ri jaꞌa ja na kaꞌan ri taka jnuꞌun ndaa. Nau yɨvɨ ka ndoꞌo ndaa ini, ti na chunsoꞌo i jnuꞌun kaꞌan ri ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ni jikajnuꞌun Pilato nuu ya: ―¿Nau ja kuu maa jnuꞌun ndaa nusa? ―ni kachi da. Siaꞌan ni jikajnuꞌun Pilato, ti ni kee da nuu kaꞌiin yɨvɨ hebreo yukan, ti ni kachi da: ―Tu na kuachi niꞌin ri sɨkɨ chaa jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ko roꞌo ka ñavaꞌa ra ɨɨn jnuꞌun ja na sia ri ɨɨn chaa kande vekaa ja kuu kɨvɨ viko pascua. ¿Kuni ra ja na sia ri maa chaa taꞌu jniñu nuu ra nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yukan ti ni ka kuvaa kuɨtɨ yɨvɨ un, ti ka kana: ―¡Koto sia ni chaa jña! ¡Vaꞌa ga sia ni Barrabás! ―ni ka kachi. Vasu Barrabás ni kuu da ɨɨn chaa kuiꞌna. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yukan ti Pilato ni kachi da ja na kani soldado un Jesús jiin yoꞌo ñɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ti soldado un ni ka saꞌa da ɨɨn corona iñu, ti ni ka chuxndee da xini ya. Ti ni ka naskuiꞌna da ya ɨɨn saꞌma kuaꞌa tɨjnuu, nanu ja kuu ya ɨɨn rey. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ni ka tuꞌva da nuu kandichi Jesús, ti ni ka kachi da: ―Na kuchaku naꞌan chaa kuu rey taꞌu jniñu nuu yɨvɨ hebreo ―ni ka kachi da. Ti ka kani da xiɨkɨ nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ni kee tuku Pilato, ti ni kachi da nuu yɨvɨ hebreo un: ―Vee nchaka ri chaa jaꞌa nava na kuni ra ja tu na kuachi niꞌin ri sɨkɨ da ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yukan ti ni kenda Jesús. Ñuꞌun ya corona iñu ti ñuꞌun ya ɨɨn saꞌma kuaꞌa tɨjnuu ndiꞌi. Ti ni kachi tuku Pilato nuu yɨvɨ un: ―Ndeꞌe vaꞌa nuu da naa ra, chi jaꞌa kandichi da ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ti sutu ka kuñaꞌnu ndeꞌe da taka policía, ni ka jini da nuu ya, ti ni ka jakunchaa da ka kanakoꞌo da: ―¡Na kuū da! ¡Na kuū da! Ti ni kachi Pilato: ―Nusa ti jnɨɨ maa ra da naa ra ti kaꞌni ra da, chi tu na kuachi niꞌin kuɨtɨ ri sɨkɨ da ―ni kachi Pilato. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ko ni ka kachi yɨvɨ hebreo un: ―Nuu ley yo kachi ja na kuū da, chi ni kachi da ja Seꞌe Yandios kuu da ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nu ni jinisoꞌo Pilato jnuꞌun un ni kejaꞌa yuꞌu da, chi ni ka kachi ja yɨvɨ un Seꞌe Yandios kuu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ni ndɨvɨ tuku da ini palacio, ti ni jikajnuꞌun da Jesús: ―¿Na ñuu vaji ra nusa? ―kachi da. Ko tu ni kaꞌan kuɨtɨ Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yukan ti ni kachi Pilato jiin ya: ―¿Ndoo tu kaꞌan ra ja kaꞌan ri? ¿Va nu tu jini ra ja iyo ichi ri ja sia ri roꞌo kiꞌin ra? ¿Ti suni iyo ichi ri ja kaꞌni ri roꞌo nu? ―ni kachi da? ");
INSERT INTO mpmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yukan ti ni kaꞌan Jesús: ―Nu tu ni jaꞌa Yandios ɨɨn jniñu nuu ra niku, ti va ni tu kuu saꞌa ra justicia jaꞌa ri. Yukan kuu ja chaa ni ka nakuaꞌa ruꞌu nuu ra, yukan kuu ja ja niꞌin ga ka iyo kuachi sɨkɨ ja kuu roꞌo ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti undi hora yukan ni kejaꞌa ndɨꞌɨ ini Pilato ti nduku da nasa sia da ya. Ko yɨvɨ hebreo un ka kana koꞌo kaꞌiin: ―¡Nu sia ni chaa jaꞌa, ti tu kuu ni ɨɨn chaa mani jiin César, chaa kuñaꞌnu ga un! Ti Jesús jaꞌa, chi ni ndonda da sɨkɨ César, ti kuni taꞌu da jniñu nuu nɨ tuꞌu nacion yo ―ni ka kachi yɨvɨ hebreo un. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ni jinisoꞌo Pilato jnuꞌun ka kaꞌan yɨvɨ hebreo un, ti ni kachi da ja na keniꞌin soldado un Jesús undi ichi yuxeꞌe. Yukan ti ni nukoo Pilato nuu sillón da nuu taꞌu da jniñu, nuu mani yuu ni jankava. Yukan nani Gabata nuu yuꞌu ka kaꞌan maa yɨvɨ hebreo un. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kɨvɨ un ka satuꞌva yɨvɨ naa i ja kuu viko pascua, ti ja kuan kuyajni koxiuu kuu hora un. Ni kaꞌan Pilato ti ni kachi da jiin yɨvɨ hebreo un: ―¡Ndeꞌe naa ra! Jaꞌa kuu maa chaa taꞌu jniñu nuu ra naa ra ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ti ni ka kana koꞌo yɨvɨ un: ―¡Na kuū da! ¡Na kuū da! ¡Katakaa ni da na kuū da nuu ndaꞌa cruz! ―ni ka kachi. Ti ni kachi Pilato: ―¿Ka jani ini ra ja kaꞌni ri chaa taꞌu jniñu nuu ra nu? ―ni kachi da. Ti ni ka kaꞌan sutu ka kuñaꞌnu: ―Maa ɨɨn ni César kuu ja taꞌu jniñu nuu na naa na, ti tukaa iyo ɨnga ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yukan ti ni taꞌu Pilato jniñu ja na kuū Jesús. Ni ka jnɨɨ soldado romano un maa ya ti kuankoyo da jiin ya, ja na katakaa da ya nuu ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni kenda Jesús, ndiso ya cruz ya. Kuankoyo da jiin ya ɨɨn ñuꞌun nani “Yɨkɨ Xini”, ja yuꞌu chaa hebreo un nani Gólgota. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yukan ni ka jatakaa da ya nuu ndaꞌa cruz. Ti suni ni ka jatakaa da uu ga chaa nuu uu ga cruz, ɨɨn ɨɨn da xiin ya, ti maa ya ni kendo maꞌñu. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Suni ni kachi Pilato ja na koso letra xini cruz ya nuu kachi: “Jesús, kuu chaa ñuu Nazaret, chaa taꞌu jniñu nuu yɨvɨ hebreo.” ");
INSERT INTO mpmNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yukan ti kuaꞌa yɨvɨ hebreo un ni ka kaꞌu da jnuꞌun yoso nuu tutu un, vanuxia yajni yuꞌu ñuu Jerusalén kuu nuu ni ka jatakaa da ya. Ti jnuꞌun un yoso nuu saꞌan hebreo, jiin griego jiin latín. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yukan ti ni ka kachi sutu ka kuñaꞌnu un nuu Pilato: ―Tu iyo vaꞌa jnuꞌun kaꞌan tutu un, ja taꞌu da jniñu nuu yɨvɨ hebreo. Vaꞌa ga ja na kaꞌan: “Ni kachi da ja taꞌu da jniñu nuu yɨvɨ hebreo” ―ni ka kachi sutu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ko ni kachi Pilato nuu da naa da: ―Siaꞌan na kendo nava yoso, chi ja ni chiso ri ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nu ni ndɨꞌɨ ni ka jatakaa soldado un Jesús nuu ndaꞌa cruz, ni ka kiꞌin da saꞌma ya, ti ni ka saꞌa da kuun pedazu. Ti ɨɨn ɨɨn pedazu ni ka tejnaꞌan nuu jnaꞌan da. Suni ni ka kiꞌin da saꞌma kuita ya. Ko vanuxia saꞌma un tu ni kuiku, chi so ni kee nɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ti yukan ni ka ndajnuꞌun soldado un: ―Ko tu kaꞌncha yo saꞌma jaꞌa, chi vaꞌa ga na chuꞌun yo suerte sɨkɨ, ti na ndeꞌe yo na ɨɨn yo niꞌin ―ni ka kachi da. Siaꞌan ni ka saꞌa da, ti ni kundaa nava yoso nuu tutu ii Yandios, ja kachi: “Ni ka kiꞌin da saꞌma ri ti ni ka tejnaꞌan nuu jnaꞌan da. Ti ni ka chuꞌun da suerte sɨkɨ saꞌma kuita ri”, kachi tutu. Ti siaꞌan ndixia ni ka saꞌa soldado un. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ti yajni jaꞌa cruz nuu yɨndaka Jesús, yukan kandichi nana ya, jiin kuꞌu ña María, ñasɨꞌɨ Cleofas, jiin María ñaꞌan ñuu Magdala. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ni jini Jesús nuu nana ya kandichi ña xiin ɨɨn ndajaꞌa, chaa ni kuu mani xaan ya jiin niku. Ti ni kachi ya jiin nana ya: ―Naa, yukan kandichi seꞌe ni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ti ni kachi ya jiin chaa un: ―Yukan kandichi nana ra ―ni kachi ya. Ti undi hora yukan ni nakuaka da ña ini veꞌe da, ti ni jito da ña nanu nana maa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yukan ti ni jini Jesús ja ja ni jinu taka jniñu vaji ya, ti ja na kundaa nava kaꞌan nuu tutu ii Yandios. Ti ni kachi ya: ―Ichi ri nducha ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ti yukan kandichi ɨɨn tɨndoꞌo, ñuꞌun chitu nducha iya. Ni ka chuntoo da kachi nuu nducha iya un, ti ni ka chaa da xini ɨɨn ndaꞌa yujnu hisopo, ti ni ka chaa da yuꞌu ya ja na koꞌo ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yukan ni jiꞌi Jesús nducha iya un, ti ni kachi ya: ―Ja ni ndɨꞌɨ ni kuu nakoo vijna na ―ni kachi ya. Ti ni skanindee ya xini ya, ti ni jiꞌi ni ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Chaa hebreo un ni ka kaꞌan da jiin Pilato ja na taꞌu da jniñu, ja na kaꞌnu da yɨkɨ saꞌnda chaa ka ndakoyo nuu ndaꞌa cruz un. Yukan ti na kuu da nu tu jaꞌi kuu da, ti na kuniꞌin da chaa nuu ndaꞌa cruz un. Siaꞌan ni ka ndoꞌo ini yɨvɨ hebreo un, chi ja ka satuꞌva da ja kuu viko pascua, chi ɨnga kɨvɨ ni ga kuu ɨɨn kɨvɨ ii, ɨɨn kɨvɨ ii xaan ga. Ja yukan kuu ja tu ka kuni da ja kendo ndɨyɨ un kundakoyo i nuu ndaꞌa cruz yukan kuu kɨvɨ ndetatu. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yukan ti ni jakoyo soldado un ni ka jaꞌnu da sɨꞌɨn ndɨnduu chaa ka ndakoyo jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ko nu ni ka tuꞌva da nuu Jesús, ti ni ka jini da ja, ja ni jiꞌi ya. Yukan ti tu ni ka jaꞌnu da sɨꞌɨn ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ko ɨɨn soldado un ni kuji da lanza da nuu yɨkɨ jika ya, ti ni kaña nɨñɨ jiin nducha nuu ni tuji un. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ti chaa jani jnuꞌun jaꞌa kuu ɨɨn chaa ni jini, ti jani ndaa da jnuꞌun nava ni kuu un, ti nava siaꞌan na kandixia ra Jesús naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Siaꞌan ni kuu, ti yukan ni kundaa nava yoso nuu tutu ii Yandios, ja kachi: “Tu kaꞌnu yɨvɨ ni ɨɨn yɨkɨ ya.” ");
INSERT INTO mpmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ti suni iyo ɨnga nuu yoso: “Ɨɨn kɨvɨ ti ndeꞌe yɨvɨ nuu ya ni ka stuji yɨvɨ yɨkɨjika ya”, kachi. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yukan na ti José, chaa ñuu Arimatea, ni kandaꞌu da jiin Pilato ja na kuniꞌin da yɨkɨ kuñu Jesús. Chi vanuxia ni kuu da chaa ni kandixia Jesús niku. Ko tu ni ka jini yɨvɨ un ja mani da jiin ya, chi tu ni stuu da maa da, chi yuꞌu da sa kuni jnaꞌan da hebreo un. Ti ni jaꞌa Pilato jnuꞌun nuu da ja na kuniꞌin da yɨkɨ kuñu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti suni Nicodemo ni jaꞌan da jiin José. Nicodemo un ni kuu chaa ni jaꞌan kaꞌan jiin Jesús ɨɨn jakuaa na ti kuu ga ya. Ni jaa da jiin yajni oko uxi kilo crema vixi, ja ni sakanuu jiin suxia mirra jiin áloe. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yukan na ti José jiin Nicodemo, ni ka kiꞌin da yɨkɨ kuñu Jesús, ni ka suku da jiin saꞌma finu, ti ni ka jaka da crema un nɨ chii saꞌma un nava iyo jnuꞌun ja ka saꞌa yɨvɨ hebreo, ka chunduji i ndɨyɨ i. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yajni nuu ni jiꞌi Jesús un ni iyo ɨɨn huerta, ti nuu huerta yukan, kande ɨɨn yau ja ni ka jacha yɨvɨ ɨɨn jika xaꞌva. Ni kuu ɨɨn yau jaa, nuu ti kunde ga ni ɨɨn ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yukan ni ka chundee da yɨkɨ kuñu Jesús, chi vanuxia kande yajni, ti vijna ja kuan kuyajni kejaꞌa kɨvɨ ii ja ka ndetatu yɨvɨ hebreo un. Ti kachi ley ja tu kuu chunduji da ndɨyɨ nuu ja ni jaa kɨvɨ ii un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ni kuu jañaꞌan domingo, ti María, ña ñuu Magdala, ni jaꞌan ña nuu ñunduji Jesús. Nɨ ñaꞌan xaan ga ja ni iin ña ga na ni jaꞌan ña. Ni jaa ña ti ni jini ña ja tukaa ga ndiꞌyu yuu ni ka jasɨ da yuꞌu yau un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ti yukan ni jinu ña kuaꞌan ña nuu kancha Simón Pedro jiin nuu ɨnga chaa ni iyo mani ga Jesús jiin un niku. Ti ni kachi ña: ―Ni ka tava yɨvɨ Jitoꞌyo nuu ni ñunduji ya, ti tu ka jini yo nanu ni ka janchaka da ya ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yukan ti ni ka kee Pedro jiin ɨnga ndajaꞌa un kuankoyo da nuu ñunduji Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ndɨnduu da ka jinu tayu da kuankoyo, ko ɨnga chaa un chi niꞌin ga ni jinu da, ti xnakan da ni jaa sa ni jaa Pedro nuu ñaña un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ni jito niꞌni da ini yau un, ti ni jini da kanchuku saꞌma un, ko tu ni kɨvɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ti jata da ndikun Simón Pedro ni jaa da, jaa da ti ni kɨvɨ ni da ini yau un. Ti suni ni jini da ja kanchuku saꞌma un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ti saꞌma ni suku xini Jesús, ti tu kanchuku tutu jiin uu ga saꞌma un, chi ni stuu saꞌma un ti katuu sɨɨn. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yukan na ti sa ni kɨvɨ chaa ni jaa undi nuu yuꞌu yau un. Ni jini da ja siaꞌan ni kuu, ti ni kandixia da ja ni nandoto Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Siaꞌan ni kuu vasu ti chaku ga ini da jnuꞌun kaꞌan nuu tutu ii Yandios, ja nandoto Jesús nuu kaꞌiin ndɨyɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yukan na ti ni ka nandeokuñɨ ndajaꞌa un veꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yukan ti ni kendo María kandichi ña ichi fuera nuu ni ñunduji Jesús, ti ni jakunchaa ña ndeꞌe xaan ña. Ndeꞌe ña ndeꞌe ña, yukan ti ni jito niꞌni ña ini yau un. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ti ni jini ña uu ángel Yandios, ka ñuꞌun da saꞌma kɨyɨ laꞌlɨ, ti ka nukoo ya nuu ni katuu Jesús. Ɨɨn da nukoo da nuu ni kendo xini Jesús, ti ɨnga da nukoo nuu ni kendo jaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ti ka jikajnuꞌun da maa ña: ―Roꞌo ñasɨꞌɨ, ¿ndo kuu ja ndeꞌe ra? Ti ni kachi ña: ―Ja ni ka kiꞌin da yɨkɨ kuñu jitoꞌo na, ti tu jini na nanu ni ka janchaka da ya ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Skan ni kaꞌan ña siaꞌan, ni ndeokoto ña, ti ni jini ña Jesús kandichi ya yukan, so ja tu jini ña ja maa Jesús kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ti ni kachi Jesús jiin ña: ―Roꞌo ñasɨꞌɨ, ¿ndo kuu ja ndeꞌe ra? ¿Nau kuu ja nanduku ra? ―ni kachi ya. Ko maa ña ni ndoꞌo ini ña ja chaa ndito huerta yukan kuu, ti ni kachi ña: ―Taa, nu maa ni kuu ja ni chajiyo ndɨyɨ jaꞌa, kachi ni nuu na nanu ni janchaka ni ya, ti nava na kin nu kiꞌin na ya ―ni kachi ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yukan na ti ni kachi Jesús: ―¡María! ―ni kachi ya. Ni ndeokoto ña nuu ya, ti ni kaꞌan ña saꞌan hebreo: ―¡Raboni! ―ni kachi ña. Ti jnuꞌun un kuni kaꞌan: “Maestro.” ");
INSERT INTO mpmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yukan ti ni kachi Jesús: ―Koto jnɨɨ ra ruꞌu, chi changa ga ndaa ri noꞌon ri nuu kancha Tata ri, ko ja yajni kiꞌin ri. Vijna ti kuaꞌan nuu kanchuku ñani ri chaa ni ka skuaꞌa jiin ri un naa da, ti kachi ra nuu da ja kinoꞌon ri nuu kancha Tata ri Yandios. Maa ya kuu Tata ra naa ra suni ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yukan ti María, ñaa ñuu Magdala un, kuaꞌan ña, ti ni kaxnuꞌun ña nuu chaa ni ka skuaꞌa jiin ya un, ja ja ni jini ña nuu maa Jitoꞌyo. Ti ni jani ña jnuꞌun nava ni kachi ya nuu ña. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nu ni kuñaa jaꞌini kɨvɨ domingo, ni ka ndututu chaa ni ka skuaꞌa un. Ko vaꞌa ndiꞌyu yuxeꞌe veꞌe nuu kanchuku da un, chi vanuxia ka yuꞌu da jnaꞌan da chaa hebreo un. Ko ni kɨvɨ Jesús. Ti ni jankuɨñɨ ya maꞌñu da naa da, ti ni kachi ya: ―Kukuee kanchuku ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Siaꞌan ni kachi Jesús. Yukan ti ni xnaꞌan ya ndaꞌa ya nuu da naa da. Ni xnaꞌan ya yɨkɨ jika ya suni. Ja yukan ti ni ka ndusɨɨ tuku ini da, ja ni ka jini da nuu maa jitoꞌo da. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yukan ti ni kachi tuku Jesús jiin da: ―Na kukuee kunchuku ra naa ra. Siaꞌan nava ni taji Tata ri ruꞌu, ti suni siaꞌan taji ri roꞌo naa ra kinkoyo ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yukan ti ni tɨvɨ ya nuu da naa da, ti ni kachi ya: ―Na kunchaa Espíritu Santo jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ko na tatu ri ɨɨn jniñu nuu ra naa ra ja na sakaꞌnu ini ra nuu yɨvɨ nava na kuankaꞌnu ini Yandios nuu kuachi da. Ti nuu yɨvɨ ja tu ni jankaꞌnu ini Yandios, ni tu kuankaꞌnu ini ra nuu da naa da, ti nchakuachi sɨkɨ da ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Suni Tomás ni kuu da ɨɨn ndajaꞌa Jesús ja ni ka skonani yɨvɨ maa da (Tomás), chaa kuati. Ti tu kancha da jiin uu ga chaa un kɨvɨ ni ka ndututu da na ni kii Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ko kuee ga sa ni ka nakani uu ga chaa un jnuꞌun nuu da: ―Ni ka jini ri Jitoꞌyo ―ni ka kachi da. Ti ni kachi Tomás jiin da naa da: ―Undi nu tu kuni ri ndaꞌa ya, ti chunde ri xini ndaꞌa ri nuu ni kɨvɨ nduyu kaa un, ti chunde ri ndaꞌa ri yɨkɨ jika ya, ti tu kandixia ri ja ni nandoto ya nuu ñujiꞌi ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nu una kɨvɨ ti ni ka ndututu tuku da, kanchuku da ini ɨɨn veꞌe, ti kancha Tomás jiin da naa da kɨvɨ un. Ti vasu vaꞌa ndiꞌyu yuxeꞌe, ko ni kɨvɨ Jesús, ni jankuɨñɨ ya maꞌñu da naa da, ti ni kachi ya: ―Kukuee kanchuku ra nu ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yukan ti ni kachi ya jiin Tomás: ―Ndeꞌe ini ndaꞌa ri ti skɨvɨ xini ndaꞌa ra. Skaa ndaꞌa ra ti chunde yɨkɨ jika ri, ti kandixia. Koto ma kachi ra ja tu kandixia ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ti ni kachi Tomás: ―¡Jitoꞌo na Yandios! ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ti ni kachi Jesús jiin da: ―Tomás, undi ni jini ra ruꞌu, vijna sa ni kandixia ra. Ko iyo yɨvɨ ja vasu tu kuni da jiin nuu da ruꞌu, ti kandixia da. Ti na kachi ri ja ndatu ga koo yɨvɨ un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ti iyo kuaꞌa xaan ga jniñu ñaꞌnu ni saꞌa Jesús ja ni ka jini yɨvɨ ni ka skuaꞌa jiin ya. Ko tu ni chiso ndɨꞌɨ ri un nuu tutu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko taka jnuꞌun ni chiso ri jaꞌa kuu ja na kandixia ra naa ra ja Jesús kuu Cristo, ya ni taji Yandios jiin jniñu ñaꞌnu, ja kuu ya maa Seꞌe Yandios. Ti nu na kandixia ra maa ya, kuu kɨvɨ ra ndaꞌa ya vijna, ti kuchaku ra jiin ya ja kuu saa ni. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yukan ti ni yaꞌa jaku kɨvɨ, ti ndajaꞌa Jesús ni ka ndejnaꞌan tuku da jiin ya undi yuꞌu mini Tiberias. Ti jaꞌa na kachi ri nasa ni ndenda ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ni ka ndututu Simón Pedro, jiin Tomás, chaa ni kaku kuati un, jiin Natanael, chaa ñuu Caná ja kuu jiin ndañuu Galilea, ndɨnduu seꞌe Zebedeo, jiin uu ga ndajaꞌa ya un. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siaꞌan ni ka ndututu da, ti ni kachi Simón Pedro jiin da: ―Maa ri, kin jnɨɨ ri chāká vaꞌga. Ti ni ka kachi sava ga da un: ―Ti nu kiꞌin ra, ti na choꞌo taka yo naa yo suni ―ni ka kachi da. Ti kuankoyo da, ni ka kɨvɨ da ɨɨn barco lulu, ti kuan jnɨɨ da chāká. Ko jakuaa un tu ni ka jnɨɨ kuɨtɨ da ni ɨɨn tɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ti kuan ndii ni ga ni kenda Jesús kandichi ya yuꞌu mar yukan. Ko tu ni ka nakuni da ja Jesús kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yukan ti ni kachi Jesús: ―Amigo, ¿tu ni niꞌin ra chāká ja kaji yo nu? ―ni kachi ya. Ti ni ka kachi da: ―Tu kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ti ni kachi Jesús: ―Chunde ñunu ra ichi ndaꞌa kuaꞌa, ti na niꞌin ra tɨ ―kachi ya. Ti siaꞌan ni ka saꞌa da. Ni ka chunde da ñunu un nuu ɨnga barco da, ti yukan tukaa kuu kuɨtɨ natava da, chi ni kuu vee ii ja xaan kuaꞌa chāká ni ka kɨvɨ ini. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Suni yukan kande chaa mani ga jiin Jesús, ti ni kachi da nuu Pedro: ―¡Ndeꞌe! ¡Maa Jitoꞌyo kuu ja kandichi yukan! Nu ni jinisoꞌo Simón Pedro ja maa Jitoꞌyo kuu ya, ti ni nakuiꞌna da saꞌma da, chi tu ñuꞌun da saꞌma da nikuu. Ti ni ndava ni da kuaꞌan da nuu nducha un, ti sucha da kuaꞌan da undi yuꞌu mini. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ti uu ga chaa un kuankoyo kuee da jiin barco da, chi vanua yajni kendo yuꞌu mini un, va kuu ɨɨn ciento ni ga metro. Ti ka jista da ñunu da kuankoyo da jiin. Siaꞌan undi ni ka jakoyo da yuꞌu mini, vanuxia vee xaan ñunu un, chi kuaꞌa xaan chāká ka ñuꞌun. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nu ni ka kee da ini barco un, ni ka jini da ja kayu ñuꞌun. Ti ja kasun ɨɨn chāká, ti suni ja iyo staa. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yukan ti ni kachi Jesús jiin da naa da: ―Kuan kiꞌin jaku chāká ja ni ka jnɨɨ ra vinañuꞌni, ti na skasun yo tɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ti ni kɨvɨ Simón Pedro ini barco, ti ni jista da ñunu un undi nuu ñuꞌun ichi. Ko mani maa chāká naꞌnu ka ñuꞌun chii ñunu un. Undi ɨɨn ciento uu xiko uxi uni tɨ. Ti vasu kuaꞌa xaan tɨ, ko tu ni teꞌnde ñunu un. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yukan ti ni kachi Jesús nuu da naa da: ―Ñaꞌan naa ra, ti na ka sini yo ―ni kachi ya. Ko ka yuꞌu da tɨꞌlɨ ja kajnuꞌun da Jesús nuu maa ya kuu xi tuu, ko ja ka jini ndaa da ja maa jitoꞌo da kuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yukan ti ni tuꞌva Jesús yuñuꞌun un, ni kiꞌin ya staa, ni jaꞌnu sava ya, ti ni tejnaꞌan ya nuu da naa da. Suni siaꞌan ni saꞌa ya jiin chāká un. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jaꞌa kuu jinu kuu uni ja ni ndenda Jesús nuu chaa ni ka skuaꞌa jiin ya, ja ni nandoto ya nuu ñujiꞌi. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nu ni ndɨꞌɨ ni ka yasini da, yukan ti ni kachi Jesús jiin Simón Pedro: ―Simón, seꞌe Jonás, ¿kundaꞌu ga ini ra ruꞌu ja kuu taka ga ndajaꞌa ri jaꞌa, ja ka kundaꞌu ini da ruꞌu nu? Ti ni kachi Pedro: ―Jitoꞌyo, jini ni ja kundaꞌu ini na niꞌin. Ti ni kachi Jesús: ―Nusa ti chindee ra yɨvɨ ka yɨꞌɨ ndaꞌa jiin ri, chi ka kuu i nanu lelú. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yukan ti ni kaꞌan tuku Jesús jiin Pedro: ―Simón, seꞌe Jonás, ¿kundaꞌu ini ra ruꞌu nu? Ti ni ndeokani Pedro: ―Ja jini ni ja kundaꞌu ini na maa ni, Jitoꞌyo. Ti ni kachi Jesús: ―Nusa ti koto vaꞌa ra yɨvɨ yɨꞌɨ ndaꞌa ri, chi ka kuu i nanu rɨɨ ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ko ni kaꞌan tuku Jesús jiin da, ti jaꞌa kuu uni jinu ja kaꞌan ya, ti ni kachi ya: ―Simón, seꞌe Jonás, ¿kundaꞌu ndixia ini ra ruꞌu nusa? Ti ni kukuiꞌya ini Pedro ja ni kachi ya uni jinu: “¿Kundaꞌu ndixia ini ra ruꞌu nu?” Ti ni kachi Pedro: ―Jitoꞌyo, maa ni jini ndɨꞌɨ nasa ndoꞌo ini na, ti jini ni ja kundaꞌu ndixia ini na maa ni. Ti ni kachi Jesús: ―Nusa ti koto yɨvɨ yɨꞌɨ ndaꞌa ri vijna, chi ka kuu i nanu rɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Chi jandaa na kachi ri nuu ra vijna, ja undi na suchi ra ni nakiꞌin maa ra saꞌma ra, ti ni jika ra ichi ni kuu ini maa ra. Ko na nchɨɨ ra, ti ansu ga ja kuu ini maa ra, chi ɨnga yɨvɨ kundaꞌa da roꞌo nuu tu kuu ini ra kiꞌin ra, ti naskaa ra ndaꞌa ra kɨvɨ kuu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Siaꞌan ni kachi Jesús ja ni stuu ya nasa kuū Pedro, ja kuū da nuu nda cruz. Ti stuu da ja kuñaꞌnu xaan Yandios, chi ni jandatu da nuu ya vasu na kuū da. Yukan ti ni kaꞌan ga ya: ―Vijna ti kundandikun ruꞌu, ti saꞌa ra jniñu ni tatu ri nuu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Yukan ti ni ndeokoto Pedro, ti ni jini da ja ichi jata da vaji chaa mani ga jiin Jesús. Chaa un kuu ja ni kuncha xiin Jesús na ni ka kuxini da jiin ya kɨvɨ pascua un. Chaa un kuu ja ni jikajnuꞌun Jesús: “Jitoꞌyo, ¿nau kuu ja nakuaꞌa niꞌin nuu yɨvɨ ka jito uꞌu maa ni?” ");
INSERT INTO mpmNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ni jini Pedro nuu chaa yukan, ti ni jikajnuꞌun da Jesús: ―Jitoꞌyo, ¿ti nasa koo jiin chaa yukan nusa? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ti ni kachi Jesús jiin Pedro: ―Nu kuni ri ja na kuchaku da undi kɨvɨ nchaa tuku ri, va tundo saꞌa un. Ko roꞌo, ndoo jitu ini ra. Kundikun ruꞌu, ti saꞌa ra jniñu ni tatu ri nuu ra ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ja sɨkɨ yukan ti ni ka kaꞌan yɨvɨ ka kandixia Jesús ja tu kuū chaa yukan. Ko tu ni kachi Jesús ja tu kuū da, chi ni kachi ya: “Nu kuni ri ja na kuchaku da undi kɨvɨ nchaa tuku ri, va tundo saꞌa un. Ko roꞌo, ndoo jitu ini ra”, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Maa chaa mani ga jiin Jesús, kuu chaa kaꞌan jnuꞌun jaꞌa, ti taka yukan ni chaa da nuu tutu. Chi ni jini vaꞌa da nasa ni kuu undi na saa. Ti yukan ka jini ndaa yo ja kaꞌan ndaa da. ");
INSERT INTO mpmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Suni iyo kuaꞌa xaan ga jniñu ni saꞌa Jesús. Ko jini ri ja tu kuu chaa yo ndɨ ɨɨn ndɨ ɨɨn, taka ja ni saꞌa ya, chi va tu kujaa yo kaꞌu yo, vanua kuaꞌa xaan ga ja ni saꞌa ya. Ti siaꞌan na koo. Jaꞌa kuu jnuꞌun Yandios ni chaa Juan.");
INSERT INTO mpmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, nuu tutu ni saꞌa ri undi nuu, ni chiso ri taka jniñu ni saꞌa Jesús ");
INSERT INTO mpmNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","undi ni ndaa ya andɨvɨ. Jesús ni nakaji ya taka apóstol, chaa kujiin jiin ya, ti ni taꞌu ya jniñu nava saꞌa da naa da. Ti ni taꞌu Jesús jniñu nuu taka apóstol ya nava ni kachi maa Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nuu uu xiko kɨvɨ ja ni jiꞌi ya, ni ndenda kaji ya nuu da naa da ja chaku ya. Ni kaꞌan ya nasa taꞌu Yandios jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nɨ kaꞌiin tutu ga Jesús jiin taka apóstol ja kajiin jiin ya un, ti ni kachi ya: ―Tu kuxio ra ñuu Jerusalén naa ra. Kundatu ra naa ra undi na jinu jnuꞌun ni kaꞌan Tata ri, nava ni kachi ri nuu ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jandaa kuu ja Juan ni skuanducha da jiin nducha, ko jaku ni kɨvɨ ti niꞌin ra Espíritu Santo naa ra ―siaꞌan ni kachi Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ka ndututu tuku da jiin Jesús, ti ni ka jikajnuꞌun da ya: ―¿Jitoꞌyo Jesús, vijna kuu ja saꞌa ni ja na kuñaꞌnu nación Israel nu? ");
INSERT INTO mpmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ti ni kachi Jesús: ―Tu kanu kuu ja kuni ra naa ra, chi maa Yandios jini ya nava saꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ko kanu kuu ja na niꞌin ra Espíritu Santo naa ra. Ti kuñaꞌnu ra naa ra, ti ndakuniꞌin ra sɨvɨ ri, ti xnaꞌan ra jnuꞌun ri nuu yɨvɨ ñuu Jerusalén, ñuu Judea, ñuu Samaria, ti undi nuu nɨ tuꞌu ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nu ni ndɨꞌɨ ni kaꞌan ya jnuꞌun yukan, nɨ ka ndeꞌe da nuu ya, ni ndondaa ya ti kuaꞌan ya andɨvɨ. Ni kɨvɨ ya chii ɨɨn viko, ti tukaa ni ka jini da ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ka ndakoto da andɨvɨ ti ni ka jini da uu chaa ka ñuꞌun saꞌma kuijin kajiin nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ti ni ka kachi chaa un: ―Roꞌo chaa Galilea, ndoo ka ndakoto ra andɨvɨ naa ra. Nanu kuaꞌan Jesús, suni siaꞌan nchaa tuku ya ―siaꞌan ni ka kachi chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ni ka kee da yuku Olivos, ti kuankoyo da ñuu Jerusalén ja kendo yajni yukan, nava iyo ley ja kaka da ɨɨn kɨvɨ ndetatu. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ti yukan ni ka kaa da sɨkɨ veꞌe kuu uu nuu kanchuku da. Yukan kaꞌiin Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo seꞌe Alfeo, Simón, chaa ni kuu partido político ni nani cananista, jiin Judas ñani Jacobo. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Taka da siaꞌan ni kejnaꞌan ini da, ti ni ka najnaꞌan da ka jikantaꞌu da nuu Yandios jiin ñani Jesús, nana ya nani María, jiin taka ga ñasɨꞌɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kɨvɨ jña ni ndokuɨñɨ Pedro maꞌñu ɨɨn ciento oko yɨvɨ un, ti ni kachi da: ");
INSERT INTO mpmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Kuunsoꞌo naa ra, ni kuu nava ni chiso David nuu tutu ja ni kachi Espíritu Santo sɨkɨ Judas, ja ni yoxnuu da nuu chaa ni ka jnɨɨ presu Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Suni ni yaku Judas ni saꞌa da jniñu jaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ti jiin xuꞌun ni ka chaꞌu yɨvɨ un da, ni jaan da ɨɨn ñuꞌun, ko yukan ni skuaꞌña da maa da, ni teꞌnde yoꞌo un, ni kanakava da, ti ni ndɨꞌɨ jitɨ da ni kaña. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nu ni ka jini yɨvɨ Jerusalén yukan, ti ni ka kachi da ja na konani ñuꞌun un Acéldama, ja kuni kaꞌan nduꞌva nɨñɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chi nuu tutu Salmo kaꞌan siaꞌan: Na kendo veꞌe da, tundo kuncha ini. Suni kachi siaꞌan: Ɨnga na nakiꞌin jniñu da. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jaꞌa kaꞌiin chaa ni ka yaku jiin yo undi janaꞌan na ni kuncha Jesús jiin yo, ");
INSERT INTO mpmNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","undi na ni skuanducha Juan ya, ti undi kuaꞌan ya andɨvɨ. Nɨnɨ kuu ja na nukuɨñɨ ɨɨn da jiin yo na kani da jnuꞌun ja ni nandoto ya ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yukan ni ka tava da uu jnaꞌan da un, José nani da Barsabás ti suni nani da Justo, jiin Matías. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ti ni ka jikantaꞌu da nuu Yandios siaꞌan: ―Jitoꞌyo Jesús, niꞌin ja jini ni ini taka yɨvɨ. Ja uu chaa jaꞌa, nau chaa jaꞌa na saꞌa da jniñu apóstol ni xnaa Judas, ja ni kuu sɨɨn da kuaꞌan da nuu kaꞌiin yɨvɨ ka iyo kuachi un ―siaꞌan ni ka jikantaꞌu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ni ka chuꞌun da suerte, ti ni kendo Matías ja undi hora jña ni ndɨvɨ da jiin ndɨ uxi ɨɨn chaa un naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kuaꞌa yɨvɨ ka kandixia Jesús, ni ka ndututu da kɨvɨ Pentecostés, kɨvɨ ka nakuaꞌa da taꞌu triu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kanchuku da ini veꞌe, ti ni ka jinisoꞌo da kuu iyo andɨvɨ, nanu nuu vaji ɨɨn tachi xaan. Ti ni kulajan veꞌe un. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ti ni ka jini da yaa ja kandaꞌa nuu ñuꞌun, ti ni jicha nuu sɨkɨ da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ti hora un ni ka niꞌin da Espíritu Santo, ti sɨɨn sɨɨn yuꞌu ni ka kaꞌan ɨɨn ɨɨn da, nava ni kachi maa Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti ñuu Jerusalén yukan, kaꞌiin taka chaa Israel ja vekoyo da nɨ ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tendɨꞌɨ yɨvɨ un ni ka kututu nu ni ka jinisoꞌo ja ni kulajan un, ti tu ka kujnuni ndoo saꞌa, ja siaꞌan ni ka jinisoꞌo ja ka kaꞌan chaa un yuꞌu ka kaꞌan ɨɨn ɨɨn yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ni ka naa ini, tu ka chaku ini, ti ni ka jikajnuꞌun jnaꞌan: ―¿Ansu chaa Galilea ka kuu tendɨꞌɨ ja ka kaꞌan jaꞌa? ");
INSERT INTO mpmNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ndoo ja ni ndɨꞌɨ ka kaꞌan jnuꞌun ka kaꞌan ɨɨn ɨɨn yo naa yo? ");
INSERT INTO mpmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Jaꞌa kaꞌiin yɨvɨ ñuu Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO mpmNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","yɨvɨ ñuu Frigia, Panfilia, Egipto, yɨvɨ ñuu Lybia, ja kendo chii ñuu Cirene. Suni kaꞌiin chaa romano ja kanchuku jaꞌa; sava ka kuu chaa Israel, ti sava ni ka kaꞌan yuꞌu chaa Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Suni kaꞌiin yɨvɨ Creta jiin Arabia jaꞌa, ko tɨndɨꞌɨ yo ka jinisoꞌo ja ka kaꞌan taka jniñu ñaꞌnu saꞌa Yandios, ko yuꞌu ka kaꞌan ɨɨn ɨɨn yo naa yo ka kaꞌan ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ni ka naa ini yɨvɨ un, ti tu ka niꞌin jniñu saꞌa, ti ka jikajnuꞌun jnaꞌan: ―¿Na jnuꞌun kuu ndɨꞌɨ? ―kachi ka kaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko sava ka kuu ichi ini, ti ka kaꞌan: ―Ka jini da naa da ―kachi naa. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ni ndokuɨñɨ Pedro jiin ndɨꞌɨ uxi ɨɨn apóstol yukan, ti ni kaꞌan da nuu yɨvɨ un: ―Roꞌo chaa Israel naa ra, jiin tɨndɨꞌɨ ja kanchuku ñuu Jerusalén. Kunsoꞌo ra naa ra na kaꞌan ri. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tu ka jini chaa jaꞌa nava ka ndoꞌo ini ra naa ra, chi sa kaa ɨɨ̄n jañaꞌan kuu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Suꞌva iyo, jaꞌa kuu jnuꞌun ni kachi profeta Joel na ni kaꞌan da jnuꞌun Yandios: ");
INSERT INTO mpmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","18","Kɨvɨ sandɨꞌɨ ni ga kachi Yandios: Kachanuu ri Espíritu Santo nɨ ñuyɨvɨ, ti yɨvɨ ñaꞌnu yɨvɨ kuachi ka junukuachi nuu ri, kaꞌan i jnuꞌun ri. Naxnaꞌan jani nuu chaa kuachi, ti suni koo nuu chaa ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Jniñu ñaꞌnu saꞌa ri andɨvɨ, kuu ɨɨn seña ja na yuꞌu yɨvɨ. Ti uu ga seña ja kuu ñuyɨvɨ kuu ja na chaku ini yɨvɨ nava saꞌa ri. Koo nundoꞌo, chi kuū yɨvɨ, ti kayu ñuꞌun, ti koo xaan ñuꞌma. Ndaꞌva ndikandii ti ndukuaꞌa yoo. Ndukuaꞌa nanu nɨñɨ. Siaꞌan kuu nu ni kuyajni kɨvɨ nchaa Jesús, ja kuu ɨɨn kɨvɨ kaꞌnu ga. Ti kɨvɨ jña kuu ja kii xndichi ya ñuyɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ti taka yɨvɨ ka kandixia, ti kakantaꞌu i nuu ya, kɨvɨ jña kuu ja ketaꞌu i. Siaꞌan ni kachi Yandios, ni kachi Joel ―kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ni siin Pedro kaꞌan da: ―Roꞌo chaa Israel, chunsoꞌo naa ra na kachi ri. Na kachi ri nau chaa ni kuu Jesús, chaa ñuu Nazaret. Ni kuu da ɨɨn chaa ni kii nuu Yandios nuu ra naa ra. Ti ja ni ka jini ra seña, taka jniñu ñaꞌnu ni saꞌa ya, nava ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iyo yɨvɨ ja ka saꞌa ndevaꞌa, ti ni ka jaꞌa ra jnuꞌun ni ka jatakaa da Jesús ndaꞌa cruz, nava ni kachi Yandios undi janaꞌan. Ti siaꞌan ni ni ka jaꞌni ra Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ko Yandios ni naxndoto tuku ya Jesús, ti ni kuxio ya nuu kaꞌiin ndɨyɨ un, chi tu ni kundee ñujiꞌi un jiin ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Suni ni kaꞌan David nava ni jnaꞌan Jesús na ni kachi da: Jini na ja kancha Yandios jiin na. Nɨnɨ kancha ya jiin na. Ti tu ndɨꞌɨ ini na. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yukan kuu ja kuu sɨɨ ini na. Ti kaxnuꞌun na nuu ni ja iyo sɨɨ ini na. Ti jini na ja nandoto tuku na. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tu ndɨꞌɨ ini na, chi tu xndoo ni saña nanu kaꞌiin ndɨyɨ. Iyo ɨɨn seꞌe ni ja kin saꞌa jniñu ñaꞌnu, ti tu kachi ni ja kendo yɨkɨ kuñu ya teꞌyu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ni xnaꞌan ni saña nava ni kuncha na ñuyɨvɨ, ti suni ni xnaꞌan ni saña ichi kiꞌin na andɨvɨ. Ti kusɨɨ ini na chi kuncha na jiin ni. Siaꞌan ni kaꞌan David ja siaꞌan jnaꞌan Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Siin Pedro kaꞌan da, ti ni kachi da: ―Saꞌa ri ja ñani ri ka kuu ra naa ra, ti na kachi ndaa ri nasa ni jnaꞌan David, chaa ni kuñaꞌnu ñuu yo, ");
INSERT INTO mpmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","na ni kaꞌan David jnuꞌun Yandios najanaꞌan. Ti ni jini da ja saꞌa Yandios nava ni kachi ya nuu da, chi ni kachi ya: “Chaa ɨɨn jnaꞌan ra, ti taꞌu da jniñu ñaꞌnu nanu saꞌa ra vijna”, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ni jini David najanaꞌan ti ni kachi da ja nandoto tuku Cristo, chaa taꞌu jniñu ñaꞌnu un. Siaꞌan ni kachi David sɨkɨ Cristo: “Tu xndoo Yandios niꞌin nuu infiernu, ti ni tu teꞌyu yɨkɨ kuñu ni”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tendɨꞌɨ ri naa ri ka kaꞌan ja ni ka jini ri ja maa Yandios ni naxndoto tuku ya Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nu ni najaa Jesús andɨvɨ, ni jaꞌa Yandios jniñu ñaꞌnu nuu ya. Xnaka ni kachi Yandios najanaꞌan: “Jaa ɨɨn kɨvɨ ja kachanuu ri Espíritu Santo nɨ ñuyɨvɨ”, ni kachi ya. Yukan kuu ja ni taji Jesús Espíritu Santo vijna. Ti yukan kuu taka jniñu ka saꞌa ri vijna ja ka ndeꞌe ra, ti ka jinisoꞌo ra jaꞌa vaji nuu maa ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ni kachi David nava kuaꞌan Jesús andɨvɨ, chi ansu maa da kuaꞌan andɨvɨ. Chi maa David ni kaꞌan nava ni jnaꞌan Jesús: Yandios ni kachi nuu Jitoꞌyo Jesús: “Nukoo nuu ndaꞌa kuaꞌa ri, chi taꞌu ni jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Iyo yɨvɨ kuasun ini, ko kundee ra jiin, chi chindee ri maa ra.” Yukan kuu jnuꞌun ni kaꞌan Yandios, kachi David. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Siin Pedro kaꞌan da, ti ni kachi da: ―Roꞌo naa ra, ni ka jatakaa ra Jesús nda cruz, ko Yandios ni kachi ja na taꞌu ya jniñu nuu nɨ ñuyɨvɨ. Suni na kuankaꞌnu ini ya nuu yɨvɨ, ti nama ya sɨkɨ i. Tendɨꞌɨ roꞌo, chaa Israel naa ra, na kuni ndaa ra naa ra taka jnuꞌun kaꞌan ri nuu ra ―siaꞌan ni kachi Pedro nuu tendɨꞌɨ yɨvɨ ni ka ndututu yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nu ni ka jinisoꞌo yɨvɨ un jnuꞌun ni kaꞌan Pedro, ni ka kukuiꞌya ini, ti ni ka jikajnuꞌun Pedro jiin taka ga apóstol yukan: ―Na saꞌa mani jnaꞌan yo naa yo, ti kachi ni nasa saꞌa na naa na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ni xndaku Pedro nuu da naa da, ti ni kachi da: ―Xndoo kuachi ra naa ra, ti nakani ini nuu Yandios, ti tendɨꞌɨ ra kuanducha ja ni ka kandixia ra jnuꞌun Jesús, ya kuu Cristo, nava na kuankaꞌnu ini ya nuu kuachi ra naa ra. Ti na kuaꞌa Yandios Espíritu Santo ja na kuncha ya jiin ra naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Undi na janaꞌan ni kachi Yandios. Ti Espíritu Santo yukan kuncha jiin taka yɨvɨ ka kandixia jnuꞌun Yandios ―kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tɨjnɨ jinu ni xndaku Pedro nuu da naa da, ti ni kachi da: ―Kani ini nasa jniñu saꞌa ra naa ra, ti natuꞌva ra nuu Yandios nava tu skuita ra maa ra jiin yɨvɨ kueꞌe un ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Taka yɨvɨ ni ka chunsoꞌo, ti ni ka kandixia jnuꞌun ni kaꞌan Pedro, ni ka janducha. Ti kɨvɨ jña ni ka najnaꞌan uni mil yɨvɨ un jiin uu ga yɨvɨ ka kandixia Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ni ka kejnaꞌan ini da. Taka kɨvɨ ka ndututu da. Ti ka skuaꞌa da jiin chaa ka kuu apóstol yukan. Suni ka yee da staa ja ka nukuꞌun ini da nava ni saꞌa Jesús, ti ka nakanajaa da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ti tendɨꞌɨ yɨvɨ un ni ka naa ini, ti ni ka yuꞌu i nuu ni ka jini i taka jniñu ñaꞌnu ni ka saꞌa apóstol. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tendɨꞌɨ yɨvɨ ni ka kandixia un ka ndututu da, ti ka chindee jnaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ka xiko da ñuꞌun da jiin taka ja ka ñavaꞌa da, nasa ka nandɨꞌɨ ɨɨn ɨɨn da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ti taka kɨvɨ ni ka ndututu da ini veñuꞌun kaꞌnu yɨvɨ Israel. Ti suni veꞌe, ka yee tutu da. Ka kusɨɨ ini da. ");
INSERT INTO mpmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ka nakanajaa da Yandios, ti uu ga yɨvɨ un ka kuvaꞌa ini nuu da naa da. Ti taka kɨvɨ saꞌa Yandios ja na kandixia uu ga yɨvɨ un, ti na najnaꞌan i jiin taka yɨvɨ ja ni ka kandixia un. Siaꞌan ni saꞌa Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɨɨn kɨvɨ kuankoyo nduu Pedro jiin Juan nuu veñuꞌun kaꞌnu yɨvɨ Israel. Kaa uni jaꞌini kuu hora ka jikantaꞌu chaa Israel un. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kuan kuyajni da yukan, ti ni ka yaꞌa chaa ka ndiso ɨɨn chaa ni kaku tɨkuku. Ti taka kɨvɨ ka xndoo da chaa un ɨɨn yuxeꞌe nuu nani “yuxeꞌe vii kaa.” Yukan ni kendo chaa un, jikan da xuꞌun nuu yɨvɨ kuaꞌa ka jaꞌan veñuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nu ni jini da Pedro jiin Juan kuan kɨvɨ da veñuꞌun, ti ni jikan da xuꞌun nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ni ka jankuɨñɨ da, ti ni ka ndeꞌe vaꞌa da nuu chaa un, ti ni kachi Pedro: ―Ndeꞌe nuu ri naa ri ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ni ndeꞌe chaa tɨkuku un nuu da naa da, chi ni ndoꞌo ini da ja kuaꞌa Pedro jiin Juan xuꞌun nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ko ni kachi Pedro: ―Tu ñavaꞌa ri xuꞌun, ko na chindee ri roꞌo. Jiin jniñu ñaꞌnu ndiso Jesús, ya kuu Cristo, ja kuu ya ɨɨn chaa ñuu Nazaret, na kachi ri nuu ra: ndokuɨñɨ ti kaka ra ―siaꞌan ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ti ni jnɨɨ da ndaꞌa chaa tɨkuku un, ti ni ndokani da chaa. Ti hora jiña ni ndojnaꞌnu sɨꞌɨn da jiin sukun jaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ti yachi ni kuu ni ndokuɨñɨ da, ti ni kejaꞌa jika da. Ni kɨvɨ da veñuꞌun un jiin Pedro, jiin Juan. Jikonuu da, kanda da, ti nakanajaa da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ti tendɨꞌɨ yɨvɨ kaꞌiin ini veñuꞌun un ni ka jini ja jikonuu da, ti nakanajaa da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ti ni ka nakuni yɨvɨ un nuu da, ja maa da kuu chaa ni kuncha yuxeꞌe veñuꞌun un, ni jikan da xuꞌun. Ti ni ka naa ini, ti tu ka chaku ini nasa ni nduvaꞌa chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ti chaa ni iyo tɨkuku un, tu kuni da xndoo da Pedro jiin Juan. Ti yachi xaan ni ka kututu yɨvɨ nuu kaꞌiin da, ɨɨn yuxeꞌe un nuu nani “Salomón.” Ti ka naa ini yɨvɨ un ka ndeꞌe chaa ni nduvaꞌa un. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nu ni jini Pedro ja ni ka kututu yɨvɨ un, ti ni kachi da: ―Roꞌo chaa Israel naa ra. Ndoo ka naa ini ra ja ni ka jini ra ni nduvaꞌa sɨꞌɨn chaa jaꞌa. Ti ka ndeꞌe ra nuu ri naa ri, chi ka ndoꞌo ini ra ja ruꞌu taꞌu jniñu, xi ka ndoꞌo ini ra ja ruꞌu ka kuu chaa vaꞌa ga nuu Yandios. Ja yukan kuu ja ni kuu jika da. Ko ansu siaꞌan iyo. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chaa ni ka kuu jnaꞌan yo janaꞌan Abraham, Isaac, jiin Jacob, ni ka nchañuꞌun da Yandios, ti maa Yandios ni jaꞌa ya jniñu ñaꞌnu nuu seꞌe ya Jesús, ya ni ka jnɨɨ ra presu. Ti ni ka nakuaꞌa ra ya nuu Pilato. Ko nu ni kachi Pilato ja sia da ya, ti roꞌo tu ni ka kuni ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ii ga ni kuu Jesús, ko tu ni ka jantaꞌu ra ya. Ti tu ni ka kuni ra ja sia Pilato ya, chi ni ka kachi ra ja na sia da ɨɨn chaa jaꞌni ñaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ti ni ka jaꞌni ra Jesús, ti maa Jesús ni saꞌa ja ka chaku yo. Ko Yandios ni naxndoto ya Jesús, ti tu ni kendo ya nuu kaꞌiin ndɨyɨ un. Ti ruꞌu naa ri, ni ka jini ri ja chaku tuku Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ja ni ka jini ra chaa ni iyo tɨkuku jaꞌa. Ka nakuni ra da. Ni kandixia da ja ndiso jniñu ñaꞌnu Jesús, ti Yandios ni saꞌa ja ni nduvita sɨꞌɨn da, chi ni kandixia da Jesús. Yukan kuu ja ni nduvaꞌa da, ti tendɨꞌɨ ra naa ra ni ka jini. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Siin Pedro kaꞌan da, ti ni kachi da: ―Saꞌa ri ja ñani ri ka kuu ra naa ra. Ti ja jini ri ja tu ni ka chaku ini ra jniñu ni ka saꞌa ra na ni ka jaꞌni ra Jesús, ni chaa ka taꞌu jniñu nuu ra un, tu ni ka chaku ini da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Undi janaꞌan ni kachi ndaa Yandios nava ni ka kaꞌan chaa ni ka kaꞌan jnuꞌun ya, ja na kondoꞌo Cristo ti kuū ya. Yukan ni jnaꞌan Jesús ja ni saꞌa Yandios nava ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ko nakani ini nuu kuachi ra naa ra, ti kandixia ra Yandios, nava na kenchaa kuachi ra un naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ti siaꞌan sa kuantaꞌu ya roꞌo naa ra ti ndusɨɨ ini ra. Siaꞌan kuu, ti Yandios, taji tuku ya Jesús, chi ni nakaji ya Jesús ja kuu Cristo ja na taꞌu ya jniñu ñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Vijna ti kancha Jesús andɨvɨ undi na ndujaa ñuyɨvɨ, nava ni kachi Yandios undi janaꞌan. Siaꞌan ni ka kaꞌan chaa ni ka kaꞌan jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Suni siaꞌan ni kaꞌan Moisés nuu chaa ni ka kuu jnaꞌan yo najanaꞌan: ―Taji Yandios ɨɨn chaa kuu jnaꞌan yo nanu ni taji ya ruꞌu, ti kaꞌan da jnuꞌun Yandios. Ti chunsoꞌo ra naa ra taka jnuꞌun kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chi nu tu chunsoꞌo ra naa ra, ti kusɨɨn ra nuu Yandios. Siaꞌan ni kachi Moisés ―kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Siin Pedro kaꞌan da, ti ni kachi da: ―Tendɨꞌɨ chaa ni ka kaꞌan jnuꞌun Yandios najanaꞌan, ni ka kachi ja chaa Jesús, ti ni kundaa, chi ni chaa ya. Suni jnuꞌun yukan ni kaꞌan Samuel, ti taka ga chaa ka ndikun jata suni ni ka kaꞌan jnuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jnaꞌan yo ni ka kuu chaa ni ka kaꞌan jnuꞌun Yandios. Ja ni kachi Yandios nuu jnaꞌan yo janaꞌan, ti suni jnuꞌun yukan siin undi vijna jiin ra naa ra. Ti ni kachi ya nuu Abraham: “Chaa ɨɨn chaa kuu jnaꞌan ra ti nama da ñuyɨvɨ”, ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jesús kuu ya junukuachi nuu Yandios. Ti maa Yandios ni taji Jesús ja na chindee ya roꞌo nava na xndoo ra kuachi ra naa ra ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nɨ ka kaꞌan Pedro jiin Juan nuu yɨvɨ un, ti ni ka jakoyo sutu chaa Israel, jiin chaa saduceo, jiin chaa ka kuñaꞌnu ja ka ndito veñuꞌun un. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ka kuɨtɨ ini ja ka xnaꞌan Pedro jiin Juan nuu yɨvɨ un ja ni nandoto tuku Jesús nuu kaꞌiin ndɨyɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ti ni ka jnɨɨ da presu Pedro jiin Juan, ti ni ka jnaa da vekaa. Ti undi ɨnga kɨvɨ sa xndichi da naa da, chi ja ni ini xaan kuu, ti ja kuni kuñaa. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ti kuaꞌa xaan yɨvɨ ni ka jinisoꞌo jnuꞌun ni ka kaꞌan Pedro jiin Juan, ni ka kandixia i Jesús. Ja ni jinu uꞌun mil chaa, ti sɨɨn ñasɨꞌɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ɨnga kɨvɨ ni ka ndututu sutu ka kuñaꞌnu, jiin taka chaa ñaꞌnu, jiin chaa ka xnaꞌan ley Israel. Ni ka ndututu da ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Suni ni ka ndututu Anás, ja kuñaꞌnu ga nuu sutu ka kuñaꞌnu un, jiin Caifás jiin Juan jiin Alejandro jiin taka ga yɨvɨ ja ka kuu jnaꞌan sutu kuñaꞌnu ga un. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ni ka kana Pedro jiin Juan, ni ka jakuñɨ da nuu taka chaa kuñaꞌnu un, ti ni ka xndichi da naa da, ti ni ka kachi: ―Nasa ni ka saꞌa ra ja ni nduvaꞌa chaa tɨkuku un. Nau ja ni taꞌu jniñu nuu ra naa ra ―kachi ka kaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jiin inijnuni Espíritu Santo ni kachi Pedro: ―Taka niꞌin chaa ñaꞌnu naa ni, ");
INSERT INTO mpmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿ndoo ka jikajnuꞌun ni saña vijna naa ni, ja ni ka chindee na chaa tɨkuku un? Ti ka jikajnuꞌun ni nasa ni ka saꞌa na ja ni nduvaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nu ja yukan kuu ja ka xndichi ni saña naa na, na kachi na nuu ni jiin nuu taka yɨvɨ ñuu Israel. Ni nduvaꞌa chaa un, chi Jesús, ya kuu Cristo, ɨɨn chaa ñuu Nazaret, ni taꞌu ya jniñu. Ni ka jatakaa ni Jesús ndaꞌa cruz, ko ni nandoto tuku ya nuu ñujiꞌi, chi ni jaꞌa Yandios jniñu ñaꞌnu nuu ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Saꞌa yo nanu ja ɨɨn ni ka kuu ni jiin chaa ka saꞌa veꞌe jiin yuu, ja ka sasɨɨn da yuu vaꞌa ga, ti Jesús ni kuu nanu ɨɨn yuu vaꞌa ga. Ko ni ka sasɨɨn ni ya, ti maa ya kuu ɨɨn chaa kuñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nuu Jesús kuu nuu nanitaꞌu yɨvɨ naa i, ti tu iyo ɨnga, chi maa ɨɨn ni Jesús kuu Seꞌe Yandios, ti maa ya kuu ja nama sɨkɨ yo naa yo ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ni ka jini ja tu ka yuꞌu Pedro jiin Juan. Chi ka jini ja tu naꞌan ni ka skuaꞌa da. Yukan kuu ja ni ka naa ini, ko ja ni ka jini ja ni ka skuaꞌa da jiin Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Suni ni ka jini chaa ka kuñaꞌnu un ja kandichi chaa tɨkuku un, ti ja ni nduvaꞌa da. Yukan kuu ja tu ni kuu nachiso da jnuꞌun ni kaꞌan Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ni ka keniꞌin da Pedro jiin Juan fuera chi ka kuni ndajnuꞌun maa da naa da: ");
INSERT INTO mpmNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―Nasa saꞌa yo jiin chaa jaꞌa naa da. Ti tu kuu kaꞌan yo ja tundo ni ka saꞌa da, chi ni ka saꞌa da jniñu ñaꞌnu, ti ja ni ndɨꞌɨ yɨvɨ ñuu jaꞌa ka jini. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na siuꞌu yo da, ti na kachi yo jiin da ja tukaa ga ndakuniꞌin da sɨvɨ Jesús, nava tukaa ga xnaꞌan da nuu yɨvɨ jaꞌa naa i ―kachi da ni ka ndajnuꞌun da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yukan ti ni ka kana tuku da Pedro jiin Juan, ti ni ka kachi da nuu da: ―Tukaa ga ndakuniꞌin ra sɨvɨ Jesús, ti tukaa ga xnaꞌan ra nuu yɨvɨ naa ra ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ti ni ka kachi Pedro jiin Juan nuu da: ―Kani ini ni naa ni. Ndeo nuu nau ja vaꞌa ga ja kuu nuu Yandios. Vaꞌa ga ja kuandatu na nuu ni, xi vaꞌa ga ja kuandatu na nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tu kuu kasɨ yuꞌu na naa na, chi kanu kuu ja kani na jnuꞌun taka ja ni ka jini na, ti ni ka jinisoꞌo na ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yukan ti ni ka siuꞌu tuku chaa ka kuñaꞌnu un maa da. Ti ni ka sia da, chi tu ni ka niꞌin nasa chakuachi da naa da. Ti ni ka yuꞌu ja kuɨtɨ ini yɨvɨ naa i. Tendɨꞌɨ yɨvɨ un ka kanajaa i Yandios ja ni nduvaꞌa chaa tɨkuku un. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Viꞌi ga uu xiko kuiya ni kuꞌu chaa un, ti sa ni nduvaꞌa da. Yukan ni ka jini yɨvɨ jniñu saꞌa Yandios, chi ni nduvaꞌa chaa tɨkuku un. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu ni ka sia chaa ka kuñaꞌnu un Pedro jiin Juan, ti kuankoyo da nuu ni ka ndututu taka ga apóstol un naa da. Ti ni ka jani da jnuꞌun nava ni ka kaꞌan sutu ka kuñaꞌnu un jiin taka ga chaa ka kuñaꞌnu un nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ni ka jinisoꞌo taka ga chaa un jnuꞌun ni ka kaꞌan da, taka da ni ka nakanajaa da Yandios, ti ni ka kachi da: ―Niꞌin Yandios kuu ja taꞌu jniñu nuu na naa na. Ni saꞌa ni andɨvɨ, ñuyɨvɨ, jiin mar, jiin taka ja iyo ñuyɨvɨ, jiin andɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Undi najanaꞌan ni jaꞌa ni Espíritu Santo nuu David, chaa ni junukuachi nuu ni. Ti jiin inijnuni Espíritu Santo ni kachi da: Ni ka ndututu chaa ka kuñaꞌnu tɨjnɨ nación ja ka kuni kanaa jiin Seꞌe Yandios, ya kuu Cristo. Ti suni yɨvɨ Israel ka nduniꞌin ini, ko tu ka jini na jnuꞌun ka kaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni ka ndututu chaa ka kuñaꞌnu tɨjnɨ nación. Ka kuni kanaa jiin ni, Yandios jiin Seꞌe ya Cristo, ya ni taji ya ja na taꞌu jniñu ñaꞌnu un, ni kachi David. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ñuu jaꞌa ni ka ndututu Herodes, jiin Poncio Pilato, jiin taka chaa vekoyo ɨnga nación, jiin yɨvɨ Israel, ti ni ka skejnaꞌan da jnuꞌun ja na kuū Jesús, ti ni ka jaꞌni da Seꞌe ii ni Jesús, ya junukuachi nuu ni, ya ni taji ni ja na taꞌu jniñu ñaꞌnu nuu nɨ tuꞌu ja iyo. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yukan ni ka saꞌa da, chi undi janaꞌan ni kachi ni ja siaꞌan koo. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ti vijna ndeꞌe ni, niꞌin Yandios kuu ja taꞌu jniñu nuu na naa na. Ka kuni siuꞌu yɨvɨ saña. Kuaꞌa ni jnuꞌun ndee ini saña naa na, chi ka junukuachi na nuu ni. Tu kuaꞌa ni jnuꞌun ja siuꞌu yɨvɨ saña naa na. Ti siaꞌan na kundee ini na kaꞌan na jnuꞌun ni. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ti suni kachi ni ja na nduvaꞌa yɨvɨ ka kuꞌu, saꞌa na naa na. Ti kachi ni ja na koo tɨjnɨ ga jniñu ñaꞌnu, nava na kuni yɨvɨ taka jniñu saꞌa Jesús, Seꞌe ii ni, ya junukuachi nuu ni ―siaꞌan ni ka nakanajaa taka apóstol un Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nu ni ndɨꞌɨ ni ka nakanajaa da Yandios, ti ni jnaa veꞌe nuu kaꞌiin da un. Ti hora jña ni ka niꞌin da Espíritu Santo, ti ni ka kundee ini da ka kaꞌan da jnuꞌun Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ti tendɨꞌɨ yɨvɨ ka kandixia jnuꞌun Jesús ni ka ndu ɨɨn nuu ini i. Ti nau ndajniñu ka ñavaꞌa ɨɨn ɨɨn i, yukan kuu ja kuu taka i. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ni ka ndundee ini taka apóstol un, chi taka yɨvɨ ni ka kandixia jnuꞌun Jitoꞌyo Jesús, ka chindee jnaꞌan. Ni ka siin apóstol un ka kaꞌan da ja ni nandoto Jesús. Ti uu ga yɨvɨ un ka kuu vaꞌa ini nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Taka chaa ni ka kandixia un, tu ni ka jnaꞌan da nundoꞌo, chi taka da ka chindee jnaꞌan da. Nu ka ñavaꞌa da ñuꞌun xi veꞌe, ka xiko da ti ka nakuaꞌa da xuꞌun nuu apóstol. Ti apóstol un ka tejnaꞌan da nasa ka nandɨꞌɨ ɨɨn ɨɨn da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Siaꞌan ni saꞌa ɨɨn chaa ni nani José. Ti apóstol un ni ka na skonani da Bernabé, chi ni jaꞌa da jnundee ini apóstol un naa da. Ni kaku da ñuu nani Chipre, ti ni kuu jnaꞌan da jiin familia Leví, chaa ni kuu sutu nuu Yandios najanaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni xiko da ñuꞌun da, ti ni nakuaꞌa da xuꞌun nuu apóstol. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ni jnaꞌan ɨɨn chaa ni nani Ananías jiin ñasɨꞌɨ da Safira. Suni ni xiko da ñuꞌun da. Ti Ananías ni chisaꞌyɨ da jaku xuꞌun ja ni ka niꞌin da nuu ñuꞌun da un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti jaku ni ni nakuaꞌa da nuu apóstol, ti ni kachi da ja yukan ni kuu ndɨꞌɨ xuꞌun da ja ni ka niꞌin da jiin ñuꞌun da. Siaꞌan ni saꞌa da, ko ni jini ñasɨꞌɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","4","Ti ni kachi Pedro nuu da: ―Va ni jikun jaꞌuꞌu un roꞌo Ananías, ja yukan kuu ja kuni ra xndaꞌu ra Espíritu Santo niku. Ni chisaꞌyɨ ra sava xuꞌun ni niꞌin ra jiin ñuꞌun ra. Na ti xiko ga ra ñuꞌun un, ni kuu ñuꞌun maa ra, ti kuu saꞌa ra nava kuu ini ra jiin. Ti nu ni xiko ra, ni niꞌin ra xuꞌun un, ko suni xuꞌun maa ra kuu. Ni ndoꞌo ini ra ja xndaꞌu ra ruꞌu naa ri. Ko ansu ruꞌu ni xndaꞌu ra, chi maa Yandios kuni xndaꞌu ra ―kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nu ni jinisoꞌo Ananías jnuꞌun ni kaꞌan Pedro, ni nduva da, ti ni jiꞌi ni da. Tendɨꞌɨ yɨvɨ ni ka jini jnuꞌun un ni ka yuꞌu xaan. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ti yukan kaꞌiin tɨjnɨ chaa kuachi. Ni ka tuꞌva da nuu katuu ndɨyɨ un, ni ka suku da ɨɨn saꞌma. Ni ka ndokani da ndɨyɨ un, ti ni ka jaꞌan chunduji da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ni kuu naꞌan ti ni chaa Safira, ñasɨꞌɨ ndɨyɨ Ananías. Ti kuni ga ña nundoꞌo ni jnaꞌan Ananías. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ti ni jika jnuꞌun Pedro nuu ña, ni kachi da: ―¿Ni kuyaꞌu ñuꞌun un nava ni ka kachi ra nu? Ti ni kachi Safira: ―Yaꞌu yukan kuaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ti ni kachi Pedro: ―Tu vaꞌa ja ni ka kijnaꞌan ra ti maa Espíritu Yandios ka kuni xndaꞌu ra. Ndeꞌe chaa vekoyo yukan ni ka jan chunduji yɨɨ ra, ti vijna kiꞌin da jiin maa ra suni ―ni kachi Pedro jiin ña. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hora jña ni nduva ña nuu jaꞌa Pedro, ti ni jiꞌi ni ña. Ni ka ndɨvɨ chaa un, ni ka jini da ja suni ja ni jiꞌi ña. Ni ka kaniꞌin da ña, ti ni ka jan chunduji da ña xiin yɨɨ ña un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ndɨꞌɨ yɨvɨ ka kandixia Jesús un jiin uu ga yɨvɨ ni ka jinisoꞌo, ti ni ka yuꞌu xaan i. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tɨjnɨ jniñu ñaꞌnu ni ka saꞌa taka apóstol. Ti siaꞌan sa ni ka jini yɨvɨ un jniñu saꞌa Yandios. Ti tendɨꞌɨ yɨvɨ ni ka kandixia Jesús un ni ka ndututu yuxeꞌe nani Salomón. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ti taka yɨvɨ ja tu ka kandixia Jesús ka yuꞌu najnaꞌan jiin yɨvɨ ka kandixia un, ko ni ka jini ja mani chaa vaꞌa ka kuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ti ni kuu kuaꞌa ga yɨvɨ ni ka kejaꞌa ka kandixia jnuꞌun Jesús. Kuu chaa, kuu ñasɨꞌɨ ni ka kandixia, ti ni ka najnaꞌan jiin yɨvɨ ka kandixia un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yukan ti ka kejaꞌa ka yɨndaꞌa yɨvɨ ka kuꞌu un jiin tɨkachi xi jiin yuu. Undi yuꞌu ichi un, ti yukan ka xndoo yɨvɨ ka kuꞌu un. Siaꞌan ni ka saꞌa, chi ka ndoꞌo ini ja nu na yaꞌa Pedro yukan, ti kuikun ndatɨ da sɨkɨ yɨvɨ ka kuꞌu un, ti nduvaꞌa i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Suni ni ka kii yɨvɨ ñuu kaꞌiin yajni Jerusalén. Ka ndiso i yɨvɨ kuꞌu jiin yɨvɨ ka jnaꞌan tachi xaan, ti ni ndɨꞌɨ un ni ka nduvaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nu ni ka jinisoꞌo sutu ka kuñaꞌnu un jiin chaa saduceo taka jniñu ka saꞌa apóstol un, ni ka kuu kuasun ini da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ti ni ka jnɨɨ da taka apóstol un, ti ni ka jnaa da vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ti jakuaa ni jaꞌan ɨɨn tajnu Yandios ni jiña yuxeꞌe vekaa un, ti ni keniꞌin da naa da, ti ni kachi tajnu un nuu da: ");
INSERT INTO mpmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Kuaꞌan ni veñuꞌun kaꞌnu Israel un, ti kani ni jnuꞌun nasa nanitaꞌu yɨvɨ, ti na kunchuku i jiin Yandios ―ni kachi tajnu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sa ni ndɨꞌɨ ni kaꞌan tajnu un, ti ni kundijin. Kuankoyo da ti ni ka kɨvɨ da yuxeꞌe veñuꞌun un, ti ni ka kejaꞌa da ka xnaꞌan da nuu yɨvɨ kaꞌiin un. Yukan kaꞌiin da ti sutu kuñaꞌnu ga un jiin taka ndajaꞌa da ni ka ndututu da. Ni ka kana da tendɨꞌɨ chaa ka kuñaꞌnu ñuu un jiin taka ga chaa ka kuñaꞌnu nación Israel. Ti ni ka taꞌu da jniñu nuu chaa ka ndito vekaa un ja na keniꞌin da apóstol. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kuankoyo tajnu un kuan kiꞌin da apóstol un naa da. Ko tukaa ga kaꞌiin da. Ti ni ka nandeokuñɨ tajnu un ni ka jani da jnuꞌun nuu taka chaa ka kuñaꞌnu un ja siaꞌan ni kuu. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ti ni ka kachi da: ―Ni jakoyo na, ko ni ka jini na ja ndiꞌyu vaꞌa yuxeꞌe vekaa un. Ti kajiin policía yuxeꞌe un ka ndito da. Ni ka jiña na, ko tukaa ga ndoo kaꞌiin ini vekaa un ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nu ni ka jinisoꞌo chaa ka yindaꞌa veñuꞌun Israel un, jiin taka sutu ka kuñaꞌnu un, jnuꞌun ni ka kaꞌan tajnu un, ka kejaꞌa ka ndoꞌo ini. Ti tu ka jini nasa saꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɨ ka ndoꞌo ini siaꞌan, ti ni jaa ɨɨn chaa ni jani jnuꞌun, ti ni kachi da: ―Chaa ni ka jnaa ni vekaa iku un, ja kaꞌiin da ini veñuꞌun un ka xnaꞌan da yɨvɨ ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yukan na ti kuaꞌan chaa ka yindaꞌa veñuꞌun un jiin tajnu da, ni ka jan kiꞌin vii da apóstol un naa da, chi ka yuꞌu da ja kuaꞌa yɨvɨ un yuu sɨkɨ da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ni chakoyo da jiin apóstol un, ni ka jani da chaa nuu chaa ka kuñaꞌnu un. Ti ni kejaꞌa sutu kuñaꞌnu un ni xndichi da apóstol un naa da: ");
INSERT INTO mpmNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ja ni kachi ri nuu ra naa ra ja tukaa ga skuaꞌa ra jiin yɨvɨ jaꞌa naa i, ko tu ni ka chunsoꞌo ra, ti ka siin ra ka xnaꞌan ra jnuꞌun Jesús nuu yɨvɨ. Ti ja ni ndɨꞌɨ yɨvɨ ñuu Jerusalén ka jini, ti suni ka kaꞌan ra naa ra ja ruꞌu ni ka jaꞌni Jesús ―ni ka kachi chaa ñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ti ni kachi Pedro: ―Xnakan kuandatu na nuu Yandios ti sa kuandatu na nuu yɨvɨ naa i. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jnaꞌan yo najanaꞌan, ni ka nchañuꞌun da Yandios, ti maa Yandios ni naxndoto ya Jesús tuku. Ni ka jaꞌni ni Jesús, ni ka jatakaa ni ya ndaꞌa cruz. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ti vijna kuñaꞌnu Jesús, chi Yandios ni jaꞌa jniñu ñaꞌnu nuu ya ja na taꞌu ya jniñu, ti na kuankaꞌnu ini ya nuu yɨvɨ. Ti kuni ya ja taka yɨvɨ nación Israel na xndoo kuachi nava na kuankaꞌnu ini ya nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ni jaꞌa Yandios Espíritu Santo nuu taka yɨvɨ ka jandatu nuu ya. Yukan kuu ja ka kaꞌan na jiin inijnuni Espíritu Santo, chi ja ni ka jini na taka jniñu ni saꞌa Jesús ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nu ni ka jinisoꞌo chaa ka kuñaꞌnu un taka jnuꞌun ni kaꞌan Pedro, ni ka kuɨtɨ xaan ini da, ti ka kuni da kaꞌni da taka apóstol un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yukan kande ɨɨn chaa fariseo nani Gamaliel. Suni kuu da ɨɨn chaa kuñaꞌnu ñuu Israel. Ti suni ni skuaꞌa da tutu Yandios janaꞌan. Ti taka yɨvɨ ka jandatu nuu da. Ni ndokuɨñɨ da, ti ni kachi da ja na kekoyo apóstol un ɨɨn nundaa kuɨtɨ, chi kuni da ndajnuꞌun da jiin uu ga chaa ka kuñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yukan ti ni kachi da nuu chaa un naa da: ―Tendɨꞌɨ ra naa ra, kani ini nasa saꞌa ra jiin chaa jaꞌa naa ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ka nukuꞌun ini ra ja na janaꞌan. Ni iyo ɨɨn chaa ni nani Teudas, ti ni kachi da ja maa da kuu ɨɨn chaa kuñaꞌnu. Ni ka kandixia kuun ciento yɨvɨ ni ka ndikun da. Ti ni ka kanaa da jiin chaa ka kuñaꞌnu un. Ti ni ka jaꞌni da chaa, ti ndɨꞌɨ yɨvɨ ka ndikun da un ni ka jichanuu, ti tundo ni kuu kuɨtɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ni yaꞌa un ti ni jaa ɨɨn kɨvɨ ni ka ndokani da ɨɨn censo nación yukan. Kuiya jña ni iyo ɨɨn chaa Galilea nani Judas. Ti suni kuaꞌa yɨvɨ ni ka ndikun jiin da. Suni ni ka jaꞌni da chaa un, ti taka yɨvɨ ni ka ndikun jiin da un ni ka jinu. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yukan kuu ja vaꞌa ga ja na sia ra chaa jaꞌa naa ra. Na kinkoyo da. Chi nu ka saꞌa da ja ñuxini maa da, ti tu kuñɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ko nu ka saꞌa da jniñu taꞌu Yandios, tu kuu xnaa ra naa ra. Sia da na kinkoyo da, chi tu kuu kanaa ra jiin Yandios ―ni kachi Gamaliel nuu da naa da. Ni ka jandatu chaa ñaꞌnu un, ti ni ka saꞌa da nava ni kachi Gamaliel. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yukan ti ni ka kana tuku da apóstol un ni ka jakoyo da, ti ni ka taꞌu jniñu nuu da. Ni ka kachi: ―Tukaa ga kaꞌan ra jnuꞌun Jesús naa ra ―ni ka kachi chaa ka kuñaꞌnu un nuu da. Ti ni ka sia da kuankoyo da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ni ka kee apóstol un nuu chaa ka kuñaꞌnu un, ti ni ka kusɨɨ ini da, chi ni kachi Yandios ja kondoꞌo da ja sɨkɨ Jesús naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tu ni ka jandatu da jnuꞌun ni ka kaꞌan chaa ka kuñaꞌnu un, chi ni ka siin da ka skuaꞌa da jiin yɨvɨ ini veñuꞌun Israel, ti suni veꞌe, ti ni ka kachi da: ―Ka ndatu ra Cristo naa ra, ti Jesús kuu Cristo ni kii un ―ni ka kachi apóstol. Yukan kuu jnuꞌun ni ka xnaꞌan da taka veꞌe yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kɨvɨ jña kuan kukuaꞌa ga yɨvɨ ka kandixia jnuꞌun Jesús. Ka iyo yɨvɨ ni ka kaꞌan jnuꞌun griego, jiin yɨvɨ ka kaꞌan jnuꞌun hebreo. Yɨvɨ ka kaꞌan jnuꞌun griego ni ka kejaꞌa ka kankuachi sɨkɨ yɨvɨ ka kaꞌan jnuꞌun hebreo, ti ni ka kachi: ―Ñaꞌan ni ka jiꞌi yɨɨ un, tu ka niꞌin ña taka ja ka jaꞌa apóstol un taka kɨvɨ ―ni ka kachi. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ni ka nastutu apóstol taka yɨvɨ ka kandixia Jesús, ti ni ka kachi da: ―Tu kuu xndoo ri jniñu ri ja ka kaꞌan ri jnuꞌun Yandios, ti kuaꞌa ri ja kaji yɨvɨ ndaꞌu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Taka ra naa ra ja ka kandixia, vaꞌa ga ja na nakaji ra uxia chaa kunukuachi, ti na kuaꞌa da ja kaji yɨvɨ un. Nduku ra chaa ka jini junukuachi, chaa ni ka niꞌin Espíritu Santo, ti na kuaꞌa ri jniñu nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ti ruꞌu naa ri, na siin ri kakantaꞌu ri nuu Yandios, ti na kaꞌan ri jnuꞌun ya taka kɨvɨ ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Siaꞌan ni kuu, ti tendɨꞌɨ da ni ka kusɨɨ ini. Ti ni ka nakaji da Esteban, chi ni kandixia nɨ ini añu da Jesús, ti ni niꞌin da Espíritu Santo. Suni ni ka nakaji da Felipe, Prócoro, Nikanor, Timón, Parmenas jiin Nicolás, chaa ñuu Antioquía, ja tu ni kuu da chaa Israel, chi tu jaꞌi kuni da jnuꞌun Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ni ka jakuɨñɨ chaa un nuu apóstol, ti apóstol un ni ka jikantaꞌu da nuu Yandios. Ti ni ka chuxndee da ndaꞌa da xini chaa un ja na saꞌa da jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kuaꞌa yɨvɨ ni ka jinisoꞌo jnuꞌun Yandios, ti ni ka kejaꞌa ka kandixia, ti kuan kukuaꞌa ga yɨvɨ ñuu Jerusalén ka kandixia. Ti suni kuaꞌa sutu veñuꞌun Israel ka kejaꞌa ka kandixia jnuꞌun Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tɨjnɨ jniñu ñaꞌnu ni saꞌa Esteban nuu yɨvɨ un, chi siaꞌan ni taꞌu Yandios jniñu nuu da, ti ni chindee ya maa da. Nu ni ka jini yɨvɨ un taka jniñu taꞌu Yandios ja ni saꞌa Esteban, ni ka yuꞌu. Ti tendɨꞌɨ yɨvɨ ka jandatu nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ti yukan kaꞌiin yɨvɨ ka junukuachi ini veñuꞌun Israel ja ni nani “Chaa ni ka ketaꞌu”, chi tukaa ga ka sajniñu kaꞌa da. Suni kaꞌiin chaa Israel ja kanchuku ñuu Cirene, ñuu Alejandría, ñuu Cilicia jiin Asia. Ti ni ka chajnaꞌan da jnuꞌun jiin Esteban. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ti tu kuu nandeokani da jnuꞌun kaꞌan Esteban, chi Esteban kaꞌan da jiin inijnuni Espíritu Santo. Yukan kuu ja vaꞌa ni kaꞌan Esteban nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ni ka nduku chaa Israel un tɨjnɨ chaa ka xndaꞌu ñaꞌan ja na kachi da: ―Ni ka jinisoꞌo na jnuꞌun ni kaꞌan Esteban sɨkɨ Moisés jiin Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yukan ti ni ka kuɨtɨ xaan ini yɨvɨ un jiin taka chaa ñaꞌnu, jiin chaa ka xnaꞌan ley Israel. Ni ka jnɨɨ da presu Esteban, ti kuaꞌan da jiin da nuu ni ka ndututu taka chaa ka kuñaꞌnu nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ti ni ka kachi chaa ka xndoñaꞌan un: ―Taka kɨvɨ kaꞌan Esteban ja tu kaxan veñuꞌun kaꞌnu yo, ti suni kaꞌan da ja tutu Yandios najanaꞌan, tukaa kaxan. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Suni ni ka jinisoꞌo na jnuꞌun ni ka kaꞌan da ja Jesús, chaa ñuu Nazaret, kanuū da veñuꞌun kaꞌnu jaꞌa, jiin ja sama da jnuꞌun ni xndoo Moisés jiin yo ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yukan ti taka chaa ka kuñaꞌnu un jiin tendɨꞌɨ yɨvɨ kanchuku un, ni ka ndeꞌe vaꞌa nuu Esteban. Ti ni ka jini ja jito da nanu ɨɨn tajnu Yandios, chi ndinchaa nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ti ɨɨn sutu kuñaꞌnu un ni jikajnuꞌun da Esteban, ti ni kachi da: ―¿Jandaa kuu jnuꞌun ka kaꞌan chaa jaꞌa nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yukan ti ni kachi Esteban: ―Tendɨꞌɨ niꞌin chaa ka kuñaꞌnu naa ni jiin taka ga yɨvɨ kaꞌiin jaꞌa, kunsoꞌo ni na kaꞌan na. Ka jini yo ja tundo kejnaꞌan jiin Yandios, ko ni ndenda ya nuu Abraham, ti Abraham ni jini da ya jiin nuu da. Ti jnaꞌan Abraham ka kuu yo. Nɨ kancha ga da ñuu Mesopotamia, ti kiꞌin ga da Harán na ni jini da Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ti ni kachi Yandios nuu da: “Kuxio ñuu ra, xndoo jnaꞌan ra, ti kiꞌin ra ɨɨn ñuu nuu xnaꞌan ri roꞌo”, ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yukan kuu ja ni xndoo Abraham ñuu Mesopotamia nuu kanchuku yɨvɨ Caldea, ti kuaꞌan da ñuu Harán. Yukan ni kuncha da. Yukan ni jiꞌi tata da. Ti ni kachi Yandios nuu da ja na ndiji da ñuu Israel nuu kanchuku yo jaꞌa vijna. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tu ni kuni Yandios ja kuñavaꞌa da ñuꞌun maa da, ni vasu ɨɨn tɨꞌlɨ nuu kuañu da, ko ni kachi Yandios nuu da: “Kuaꞌa ndɨꞌɨ ri ñuꞌun jaꞌa nuu ra kuu ra. Nu na jaa ɨɨn kɨvɨ kuū ra, ko kendo jiin jnaꞌan ra”, ni kachi Yandios jiin Abraham, vasu ti koo ga seꞌe da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Suni ni kachi Yandios: “Jaku ni kuiya kunchuku jnaꞌan ra ɨɨn ñuu jika, nuu kanchuku ɨnga yɨvɨ. Chayɨka yɨvɨ un da saꞌa da jniñu, kuaꞌa tau da, ti kondoꞌo da kuun ciento kuiya ja tu kinyaꞌu da ni ɨɨn xuꞌun”, ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ti suni ni kachi ya: “Ruꞌu na xndichi ri yɨvɨ kuaꞌa nundoꞌo nuu jnaꞌan ra un. Xnaka kondoꞌo da sa kekoyo da, ti nchakoyo da ñuꞌun Israel jaꞌa, ti kunchañuꞌun da ruꞌu”, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Siaꞌan ni kachi Yandios nuu Abraham undi na janaꞌan. Yukan kuu ja ni xndoo Yandios ɨɨn jnuꞌun ja na saꞌa yɨvɨ ɨɨn seña yɨkɨ kuñu da nava ni kachi Yandios. Suni siaꞌan ni saꞌa Isaac jiin seꞌe da Jacob, ti suni siaꞌan ni saꞌa Jacob jiin ndɨ uxi uu seꞌe da. Ni ka jaꞌnu chaa un, ti ni ka xnukoo da nación Israel ―ni kachi Esteban nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Siin Esteban kaꞌan da nuu chaa ka kuñaꞌnu un, ti ni kachi da: ―Ti ni iyo ɨɨn seꞌe Jacob ni nani José, ti taka ñani da un ni ka kuu kuasun ini jiin da. Yukan kuu ja ni ka xiko da José nuu chaa ka jika ichi ja kuankoyo ichi ñuu Egipto, ko Yandios tu ni xndoo ya maa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Maa ya ni saꞌa ja tu ni iyo xaan da nundoꞌo. Ni chindee Yandios José, ti Faraón, chaa ni kuñaꞌnu nuu nɨ ñuu Egipto yukan, ni jini da ja iyo inijnuni José, chi chindee Yandios maa da. Yukan ni kuu ja ni jaꞌa da jniñu nuu José, ti José ni taꞌu da jniñu nɨ ñuu Egipto, ti suni ni taꞌu da jniñu nuu yɨvɨ ni ka junukuachi ini veꞌe Faraón ―ni kachi Esteban nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Siin Esteban kaꞌan da nuu chaa ka kuñaꞌnu un, ti ni kachi da: ―Kuiya jña ni kii ɨɨn jnama xaan nɨ ñuu Egipto jiin Canaán, ti ni ka jiꞌi yɨvɨ soko. Ti jnaꞌan yo na janaꞌan un, tukaa ga ni ka niꞌin da ja kaji da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ko nu ni jini Jacob ja iyo triu ñuu Egipto, ti ni taji da seꞌe da ni ka jan kuan da triu yukan. Ni ka jaꞌan da ɨɨn jinu. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ni ka nandeokuñɨ tuku da ɨnga jinu, sa ni stuu José nuu da naa da ja ñani da kuu da. Yukan ti ni jini Faraón chaa ka kuu jnaꞌan José. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yukan na ti ni kachi José jiin ñani da ja na kiꞌin tata da Jacob jiin taka ga jnaꞌan da un. Ti ja tɨndɨꞌɨ da, iyo uni xiko xiaꞌun yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yukan ti kuaꞌan Jacob ñuu Egipto. Yukan ni kuncha da undi ni jiꞌi da. Ti tɨndɨꞌɨ seꞌe da ni ka jiꞌi yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yukan ti ni jaa ɨɨn kɨvɨ ja ni ka nakiꞌin jnaꞌan da un yɨkɨ da jiin yɨkɨ taka seꞌe da kuanoꞌon undi ñuu Siquem, ti ni ka chunduji da yɨkɨ un ɨɨn ñaña nuu ni jaan Abraham nuu seꞌe Hamor undi najanaꞌan. Ja ni chaꞌu da jiin xuꞌun plata na ni kuncha da ñuu Siquem. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ni ka kaya xaan jnaꞌan Abraham ñuu Egipto un. Kuan kuyajni kuiya ja kuaꞌa Yandios ñuꞌun nuu jnaꞌan Abraham nava ni kachi ya undi nuu. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nu ni kɨvɨ ɨnga chaa taꞌu jniñu ñuu Egipto, tu ni jini da jniñu ni saꞌa José, chi ja ni kuu naꞌan xaan ni jiꞌi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ni xndaꞌu chaa taꞌu jniñu un jnaꞌan yo, ti ni ka jito da nundoꞌo. Ko ni ka kaya xaan da naa da. Ti ni kachi chaa taꞌu jniñu un ja nu ni kaku ɨɨn suchi lulu, na skaña da i ti na kuū i, chi kuan kaya xaan jnaꞌan Abraham, ni kachi chaa taꞌu jniñu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kuiya jña ni kaku Moisés. Ni kuncha i uni yoo jiin tata i, ko ni jini Yandios ja kuu i ɨɨn suchi vaꞌa, ti ni jajnaꞌan ini ya maa i. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ni jaa ɨɨn kɨvɨ ja tukaa ga ni kuu kɨsaꞌyɨ i veꞌe i, ti ni ka chajiyo tata i maa i. Ko seꞌe sɨꞌɨ maa chaa taꞌu jniñu un ni naniꞌin yɨ, ti ni na kiꞌin ña kuaꞌan jiin ña. Yukan ni skuaꞌnu ñaꞌan un nava seꞌe maa ña. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yukan ni skuaꞌa Moisés taka ja ka jini chaa Egipto, ti ni kuñaꞌnu da. Ni kuu ndichi xini da jiin taka jniñu ni saꞌa da jiin yɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nu uu xiko kuiya da, ti ni ndoꞌo ini da ja kin ndeꞌe da nasa kanchuku jnaꞌan da ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɨɨn kɨvɨ ni jini da ja kani ɨɨn chaa Egipto un ɨɨn jnaꞌan da, ti Moisés ni nama da jnaꞌan da un, ni kani da chaa Egipto un, ti ni jaꞌni da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ni ndoꞌo ini da ja kachi jnaꞌan da un ja Yandios ni taji maa da ja na nama da, ko tu ni ka chaku ini chaa un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ti ɨnga kɨvɨ ni jini da ka kanaa uu chaa Israel un, ti ɨɨn da kundee jiin ɨnga da. Ti ni ndoꞌo ini Moisés ja kaꞌan da jiin da na ndumani da, ti ni kachi da: “Kunsoꞌo naa ra, tu vaꞌa ja ka kanaa ra, chi kuu jnaꞌan ra naa ra.” ");
INSERT INTO mpmNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ti chaa ni kundee un ni chindaꞌa da Moisés, ti ni kachi da: “Ansu niꞌin kuu chaa taꞌu jniñu nuu na ja xndichi ni saña naa na. Tundo ni taꞌu jniñu nuu ni. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Xi kuni ni kaꞌni ni saña nanu ni jaꞌni ni chaa Egipto un iku”, ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu ni jinisoꞌo Moisés ja ni kaꞌan chaa un siaꞌan, ni yuꞌu da ti kuaꞌan da ɨnga ñuu nani Madián. Yukan ni kuncha da ɨɨn ñuu jika un. Yukan ni nandaꞌa da, ti ni iyo uu seꞌe da ―ni kachi Esteban nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Siin Esteban kaꞌan da: ―Yukan ni kuncha Moisés uu xiko kuiya, ti ɨɨn kɨvɨ ni jaꞌan da nuu ñuꞌun teꞌe un. Ni yaꞌa da yuku nani Sinaí, ti ni ndeꞌe da kayu nuꞌiñu ndiꞌi un. Maꞌñu ñuꞌun un kandichi ɨɨn ángel ja kuu tajnu ni taji Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nu ni jini da yukan ti ni naa ini da. Kuan tuꞌva da ja kin ndeꞌe vaꞌa da. Ti ni jinisoꞌo da kaꞌan Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ti ni kachi ya: “Maa ri kuu Yandios. Tendɨꞌɨ jnaꞌan ra najanaꞌan ni ka nchañuꞌun da ruꞌu. Abraham, Isaac jiin Jacob ni ka nchañuꞌun da ruꞌu”, ni kachi ya. Ti ni kejaꞌa Moisés nɨꞌɨn da ja ni yuꞌu da, ti tukaa kuni da ndeꞌe da yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ti ni kachi tuku Yandios nuu da: “Tava ndijña ra, chi kachi ri ja ñuꞌun ii kuu nuu kandichi ra jña. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Jini ri ja ni ka ndoꞌo yɨvɨ Israel ñuu Egipto, ti kundaꞌu ini ri. Ni jinisoꞌo ri ka kaꞌan i ja tukaa ga ka kundee i kuchaku i. Yukan kuu ja ni kuun ri venama ri i. Ti roꞌo, noꞌon ra ñuu Egipto”, ni kachi Yandios ―ni kachi Esteban nuu yɨvɨ un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Siin Esteban kaꞌan da, ti ni kachi da: ―Ni taji Yandios Moisés kuaꞌan da Egipto, vasu tu ka kuvaꞌa ini yɨvɨ Israel nuu da, chi ni kachi da: “Ansu niꞌin kuu chaa taꞌu jniñu nuu na ja xndichi ni saña. Tundo ni taꞌu jniñu nuu ni”, ni ka kachi. Ko Yandios ni jaꞌa ya jniñu nuu Moisés ja na kuñaꞌnu da, ti nama da sɨkɨ yɨvɨ Israel, ti ni chindee tajnu Yandios un Moisés jiin taka jniñu ni saꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yukan kuu ja kuaꞌa jniñu ñaꞌnu ni saꞌa Moisés ñuu Egipto, ti chaa kuñaꞌnu un ni yuꞌu da nu ni jini da taka jniñu saꞌa Yandios. Yukan sa ni ka jini chaa Israel un nasa jniñu saꞌa Yandios. Yukan ni kuꞌiin da uu xiko kuiya. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Suni maa Moisés un ni kachi da nuu yɨvɨ Israel: “Taji Yandios ɨɨn jnaꞌan ra ti kaꞌan da jnuꞌun ya nanu ni taji ya maa ri. Ti chunsoꞌo ra jnuꞌun kaꞌan chaa un naa ra”, ni kachi Moisés. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na kuaꞌan Moisés jiin yɨvɨ Israel nuu ñuꞌun teꞌe un. Ni jaꞌan da yuku Sinaí, ti yukan ni kaꞌan da jiin ɨɨn tajnu Yandios. Ti yukan kuu nuu ni niꞌin da jnuꞌun Yandios ja na kuandatu yɨvɨ Israel, ti ni xndoo da jiin yo undi vijna ―kachi Esteban. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Siin Esteban kaꞌan, ti ni kachi da: ―Ko jnaꞌan yo na janaꞌan, tu ni ka jandatu da nuu Moisés, chi ka kuni da ndeokuñɨ da ñuu Egipto. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yukan kuu ja nɨ kande Moisés yuku Sinaí un, ni ka kejaꞌa chaa Israel un ka kaꞌan da jiin Aarón, ñani da: “Natejnaꞌan ɨɨn santu na koxnuu nuu yo nandi kiꞌin yo, chi ni yoxnuu Moisés nuu yo na ni ka kee yo ñuu Egipto, ko tu jini yo ndo ni jnaꞌan da vijna”, ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ti ni ka saꞌa da ja natejnaꞌan da ɨɨn xndɨkɨ lulu. Yukan ni ka nachiñuꞌun da, ti ni ka jaꞌni da kuɨtɨ da ni ka soko da nuu un. Ni ka kusɨɨ ini da jiin ja ni ka saꞌa da un. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yukan kuu ja ni xndoo Yandios maa da, ni ka siin da nava ichi kuankoyo da, ja suni ni ka nchañuꞌun da ndikandii, yoo jiin chuxini. Chi siaꞌan kaꞌan nuu tutu ni ka saꞌa chaa ni ka kaꞌan jnuꞌun Yandios na janaꞌan, chi nuu tutu un kachi siaꞌan: “Roꞌo chaa Israel naa ra, ni ka jikonuu ra nuu ñuꞌun teꞌe, tu ni ka nchañuꞌun ra ruꞌu, chi tu ni ka jaꞌni ra kuɨtɨ ra ja soko ra nuu ri. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Taka nuu ni ka jikonuu ra ni ka ndiso ra veꞌe ñɨ lulu nuu ni kunde santu nani Moloc. Ti suni ni ka ndiso ra ɨnga santu ni nani Renfán ja ni ka natejnaꞌan ra nanu ɨɨn chuxini. Ni ka nchañuꞌun ra santu un ja kuu santu ni ka saꞌa maa ra naa ra. Yukan kuu ja tukaa jito ri roꞌo naa ra. Ti taji ri roꞌo kinkoyo ra undi ɨnga ñuu Babilonia”, ni kachi Yandios ―kachi Esteban. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Siin Esteban kaꞌan, ti ni kachi da: ―Na ni ka jikonuu jnaꞌan yo nuu ñuꞌun teꞌe un na najanaꞌan, ni ka ñavaꞌa da ɨɨn veꞌe ñɨ nuu ni ka nchañuꞌun da Yandios. Ni ka saꞌa da veꞌe un nava ni kachi Yandios nuu Moisés. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yukan ti nu ni jaa ɨɨn kɨvɨ ni taꞌu Josué jniñu nuu jnaꞌan yo najanaꞌan, ni ka kaniꞌin da veꞌe un kuaꞌan da jiin undi nuu ñuu Canaán. Ti ni ka keniꞌin da yɨvɨ ñuu un kuaꞌan, chi ni chindee Yandios maa da naa da. Siaꞌan ni ka ñavaꞌa da veꞌe ñɨ un undi kɨvɨ ni kɨvɨ David ni taꞌu da jniñu. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ni kuu ini Yandios David. Yukan kuu ja ni jikan David ɨɨn taꞌu nuu Yandios, chi ni ndoꞌo ini da ja saꞌa da ɨɨn veꞌe vaꞌa ja kuu Yandios, ya ni nchañuꞌun tata da najanaꞌan Jacob, ko tu ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ti Salomón, seꞌe yɨɨ David kuu ja ni saꞌa veꞌe Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Vasu tu kancha Yandios chaku ini veꞌe ka saꞌa yɨvɨ, nava ni kachi chaa ni kaꞌan jnuꞌun Yandios undi janaꞌan: ");
INSERT INTO mpmNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Taꞌu ri jniñu andɨvɨ ti suni nuu ñuyɨvɨ, Ti tu ka saꞌa ra ɨɨn veꞌe ja kuncha ri ndetatu ri. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Chi maa ri ni saꞌa tendɨꞌɨ ja iyo jaꞌa. Siaꞌan ni kachi Yandios, ni kachi profeta un ―kachi Esteban. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Siin Esteban kaꞌan, ti ni kachi da: ―Roꞌo chaa Israel naa ra, nɨnɨ ka kuniꞌin ini ra naa ra. Tu ka chunsoꞌo ra jnuꞌun Yandios. Tu ka jandatu ra nuu Espíritu Santo. Ka saꞌa ra nanu ni ka saꞌa jnaꞌan ra najanaꞌan, ");
INSERT INTO mpmNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","na ni ka jaꞌa da tau chaa ni ka kaꞌan jnuꞌun Yandios. Ti ni ka kachi profeta un ja chaa ni ka kaꞌan jnuꞌun Yandios. Ti ni ka kachi profeta un ja chaa ɨɨn chaa vaꞌa, ko ni ka jaꞌni yɨvɨ chaa un naa da. Ni chaa Jesús, ko roꞌo ni ka jnɨɨ ra ya, ti ni ka jaꞌni ra ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Undi najanaꞌan ni kaꞌan ɨɨn tajnu Yandios jnuꞌun ya nuu jnaꞌan yo ja na kuandatu da, ti ja ka jini ra, ko tu ka jandatu ra jnuꞌun ni kaꞌan tajnu un ―ni kachi Esteban nuu da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nu ni ka jinisoꞌo da jnuꞌun ni kaꞌan Esteban, ni ka kejaꞌa ka kuꞌyu yuꞌu da, chi ni ka kuɨtɨ xaan ini da naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jiin inijnuni Espíritu Santo ni ndakoto Esteban ichi andɨvɨ, ti ni jini da nukoo Yandios taꞌu ya jniñu, ti kandichi Jesús nuu ndaꞌa kuaꞌa ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yukan ti ni kachi Esteban: ―Ndeꞌe naa ra, nuña andɨvɨ, ti ndeꞌe vaꞌa ri ja kandichi maa Seꞌe Yɨvɨ Ñuyɨvɨ, ti yukan kuu Jesús ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tendɨꞌɨ chaa un ni ka saꞌa soꞌo da, ti ni ka kana jiin koꞌo da, chi ni ka kuɨtɨ xaan ini da. Ni ka kututu yachi da nuu kandichi Esteban. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ni ka keniꞌin da Esteban undi yuꞌu ñuu ja na kuaꞌa da yuu sɨkɨ da. Tendɨꞌɨ yɨvɨ un ni ka tava manga ka ñuꞌun, ti ni ka xndoo jiin ɨɨn chaa nani Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ni ka kejaꞌa ka jaꞌa da yuu sɨkɨ Esteban, ti Esteban ni jikantaꞌu da nuu Jesús ti ni kachi da: ―Jitoꞌyo Jesús, nakiꞌin ni saña ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yukan ti ni jakunjitɨ da, ni kanajiin koꞌo da, ti ni kachi da: ―¡Jitoꞌyo Jesús. Tu chakuachi ni yɨvɨ jaꞌa ja jniñu ka saꞌa i jaꞌa! ―ni kachi da. Nu ni ndɨꞌɨ ni kaꞌan da jnuꞌun un, ti ni jiꞌi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ni kusɨɨ ini Saulo ja ni ka jaꞌni da Esteban. Yukan kaꞌiin tɨjnɨ chaa ka kandixia Jesús, ni ka chunduji da Esteban, ti ni ka ndeꞌe xaan da ja ni jiꞌi Esteban. Yukan ti ni ka kuɨtɨ ini yɨvɨ tu ka kandixia jnuꞌun Jesús, ti yɨvɨ ka kandixia Jesús kuankoyo da ɨnga ñuu. Sava da kuankoyo ichi ñuu Judea, ti sava da kuankoyo ichi ñuu Samaria, ti ni ka kendo apóstol ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ko Saulo ni siin da jaꞌa da nundoꞌo nuu taka yɨvɨ ka kandixia jnuꞌun Jesús. Ti kɨvɨ da veꞌe yɨvɨ un, ti ni jnɨɨ da presu chaa jiin ñasɨꞌɨ, ti ni jnaa da vekaa. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Taka yɨvɨ ni ka kee Jerusalén, ni ka kaꞌan da jnuꞌun Yandios taka ñuu ni ka yaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Suni ni kee Felipe ti kuaꞌan da ñuu Samaria, ti yukan ni kaꞌan da nuu yɨvɨ taka jniñu ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ni ka chunsoꞌo yɨvɨ un jnuꞌun ni kaꞌan Felipe, ti suni tɨjnɨ jniñu ñaꞌnu ni saꞌa da. Ti tendɨꞌɨ yɨvɨ un ni ka kuvaꞌa ini nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ti kuaꞌa tachi xaan ka jnaꞌan yɨvɨ un ni kenchaa da. Nu ni ka kee tachi xaan un, ti maa tachi xaan un ni ka kanajiin koꞌo. Ti suni kuaꞌa yɨvɨ tɨkuku ni ka nduvaꞌa. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yukan ti ni ka kusɨɨ ini tendɨꞌɨ yɨvɨ ñuu yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ti yukan ni iyo ɨɨn chaa tasɨ ni nani Simón. Ti ka kundaꞌu ini yɨvɨ un maa da, chi ni saꞌa da jniñu ja tu kuu saꞌa ɨnga yɨvɨ, ti ni kachi da ja kuu da ɨɨn chaa kuñaꞌnu. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ti tendɨꞌɨ yɨvɨ un ka chunsoꞌo taka jnuꞌun kaꞌan da. Kuu chaa ñaꞌnu kuu chaa kuachi ni ka chunsoꞌo ti ni ka kachi: ―Ndiso da jniñu ñaꞌnu nuu Yandios ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ni ka chunsoꞌo yɨvɨ jnuꞌun ni kaꞌan da, chi jiin jniñu tasɨ un ni xndaꞌu da yɨvɨ tɨjnɨ kɨvɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ti Felipe ni kachi da nasa kuu kɨvɨ i ndaꞌa Yandios ja taꞌu ya jniñu nuu i. Ti suni ni kaꞌan da jnuꞌun Jesús. Yukan ti ni ka kandixia yɨvɨ jnuꞌun ni kaꞌan Felipe, ti ni ka janducha i. Kuu chaa, kuu ñasɨꞌɨ ni ka janducha. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Suni undi maa Simón ni kandixia da, ti ni janducha da. Ti ni kejaꞌa da jikonuu da jiin Felipe, ti ni jini da taka jniñu ñaꞌnu saꞌa da. Ni naa ini Simón nu ni jini da taka jniñu ñaꞌnu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nɨ kaꞌiin apóstol ñuu Jerusalén, ni ka jini da ja ni ka kandixia yɨvɨ Samaria jnuꞌun Jesús. Yukan ti ni ka taji uu ga apóstol un Pedro jiin Juan kuankoyo da ñuu Samaria. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ni jakoyo da ñuu Samaria, ti ni ka jikantaꞌu da nuu Yandios, ti ni ka kachi da: ―Kuaꞌa ni Espíritu Santo nuu yɨvɨ jaꞌa ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Siaꞌan ni ka kachi da, chi ja ni ka janducha chaa un jiin sɨvɨ Jitoꞌyo Jesús, ko tu jaꞌi niꞌin da Espíritu Santo naa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yukan ti ni ka chuxndee Pedro jiin Juan ndaꞌa da sɨkɨ yɨvɨ un, ti ni ka niꞌin da Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ni jini Simón ja so ni ka chuxndee apóstol un ndaꞌa da sɨkɨ yɨvɨ un, ti ni ka niꞌin i Espíritu Santo. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Yukan ti ni kachi Simón: ―Kuaꞌa ni jniñu jaꞌa nuu na, na chuxndee na ndaꞌa na sɨkɨ yɨvɨ, ti na niꞌin i Espíritu Santo, ti chaꞌu na niꞌin ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ti ni kachi Pedro jiin da: ―Na naa xuꞌun ra jiin ra, chi ndoꞌo ini ra ja kuan ra ja jaꞌa Yandios nuu yo. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tu kuu saꞌa ra jniñu jaꞌa, chi tu iyo ndaa ini ra nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xndoo jniñu kueꞌe ndoꞌo ini ra, ti kakantaꞌu nuu Yandios na kuankaꞌnu ini ya nuu ra. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ja jini ri ja jiin kuachi ra xnaa ra maa ra, chi niꞌin xaan ndikun ra jiin kuachi ra. Ti yukan kuu ja xnaa ra maa ra jiin ―ni kachi Pedro. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yukan ti ni kachi Simón: ―Kakantaꞌu ni nuu Yandios ja tu jnaꞌan na nava ni kachi ni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yukan ti ni ka siin Pedro jiin Juan ka kaꞌan da jnuꞌun Yandios. Ti ka kaꞌan da jnuꞌun Yandios nɨ ndañuu Samaria nasa nanitaꞌu yɨvɨ. Sa ni ka nandeokuñɨ da ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yukan ti ni kachi ɨɨn tajnu Yandios nuu Felipe: ―Saꞌa tuꞌva ra maa ra ti kiꞌin ra ñuu Gaza. Kiꞌin ra ichi ja ndejnaꞌan jiin ichi Jerusalén, ti kiꞌin ra ñuu Gaza. Yaꞌa ra nu tu kanchuku yɨvɨ un, ti jaa ra ñuu Gaza. Siaꞌan ni kachi tajnu un nuu da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yukan ti ni kee Felipe kuaꞌan da. Ti ichi kuaꞌan da ni ndejnaꞌan da jiin ɨɨn chaa Etiopía. Ni kuu da ɨɨn chaa ndisojniñu nuu ɨɨn reina ni nani Candace, ni taꞌu jniñu ñuu Etiopía. Ni kuu da chaa savaꞌa xuꞌun nuu ñaꞌan un. Chaa Etiopía un ni jaꞌan da ñuu Jerusalén, chi nchañuꞌun da Yandios nava iyo jnuꞌun chaa Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nukoo da nuu ɨɨn carreta kuanoꞌon da ichi ñuu da. Ti skuaꞌa da ɨɨn tutu Yandios ni chaa Isaías najanaꞌan. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ti Espíritu Santo ni kachi nuu Felipe: ―Kuaꞌan ti najnaꞌan ra jiin chaa nukoo nuu carreta un ―ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yukan ti ni jaꞌa da corrɨ kuaꞌan da nuu kuaꞌan carreta un, ti ni jinisoꞌo da ja skuaꞌa chaa Etiopía un jnuꞌun ni chiso Isaías, ti ni kachi Felipe jiin da: ―¿Chaku ini ra jnuꞌun kaꞌu ra jaꞌa nu? ");
INSERT INTO mpmNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ti ni kachi chaa un: ―Tu chaku ini na, chi tundo xndaku nuu na ―ni kachi da. Yukan ti ni kana da Felipe ja na nukoo da nuu carreta da un. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ti nuu kaꞌu da un kachi siaꞌan: Ka jankuñɨ rɨɨ nuu chaa ka sete tɨ, ko tu ka ndeꞌe tɨ. Ka janchaka yɨvɨ rɨɨ i nuu kuu tɨ, ko tu ka ndeꞌe tɨ. Suni siaꞌan kondoꞌo chaa un, ko tu kaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ni ka saꞌa yɨvɨ nava kuu ini jiin da. Tu ni ka xndichi ndaa maa da, vasu tu ni iyo kuachi da. Ko tundo jini nasa yɨvɨ kandixia jniñu ni saꞌa da. Ni ka jaꞌni yɨvɨ da, ti ni kee da ñuyɨvɨ jaꞌa. Siaꞌan kaꞌan nuu tutu nuu skuaꞌa chaa un. Kachi tutu. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yukan ti ni jikajnuꞌun chaa Etiopía un Felipe, ti ni kachi da: ―Kachi ni tɨꞌlɨ nuu na nasa kuni kaꞌan jnuꞌun jaꞌa. Na chaa kuu ja kaꞌan profeta jaꞌa. Kaꞌan da nu maa da, xi kaꞌan da sɨkɨ ɨnga yɨvɨ ―siaꞌan ni jikajnuꞌun da nuu Felipe. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yukan ti ni kejaꞌa Felipe ni xndaku da. Xnaka ni kachi Felipe nuu chaa Etiopía un ja Jesús kuu chaa ni kaꞌan tutu un, ti sa ni kachi da taka ga jniñu ni saꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kuankoyo da ichi un, ti ni jakoyo da nuu ñuꞌun nducha, ti ni kachi chaa Etiopía un: ―Ndeꞌe ni. Jaꞌa ñuꞌun nducha ¿tu kuu skuanducha ni saña jaꞌa nu? ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ti ni kachi Felipe: ―Nu kandixia nɨ ini ra Jesús, ti vatuni ―ni kachi da. Ti ni kachi chaa un: ―Kandixia na ja maa ɨɨn Jesús kuu Seꞌe Yandios ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yukan ti ni kachi chaa Etiopía un ja na jakuɨñɨ carreta un. Ni ka kuun da nuu ñuꞌun nducha un, ti ni skuanducha Felipe maa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ni ka ndaa da yuꞌu nducha un, ti Espíritu Santo kuaꞌan ya jiin Felipe ichi ɨnga ñuu nani Azoto. Ti tukaa ni jini chaa Etiopía un nuu da, chi kuaꞌan da. Ni siin chaa Etiopía un ichi kuaꞌan da, ko ja ni ndusɨɨ ini da, chi ja ni kandixia da Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ni kunde Felipe ñuu nani Azoto. Ni kee da yukan, ti kuaꞌan da kaꞌan da taka jniñu ni saꞌa Jesús. Siaꞌan ni kaꞌan da taka ñuu ni yaꞌa da undi ni jaa da ñuu Cesarea. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Tu jaꞌncha ini Saulo ja ka kanaa da jiin yɨvɨ ka kandixia Jesús. Ni kachi da ja kaꞌni da yɨvɨ un. Yukan ti ni jaꞌan da nuu sutu kuñaꞌnu ga ñuu Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ti ni jikan da tutu nuu sutu kuñaꞌnu ñuu Jerusalén ja kiꞌin nuu sutu kaꞌiin ñuu Damasco. Yukan ni niꞌin jnuꞌun ndee ini da ja jnɨɨ da presu taka yɨvɨ ka kandixia Jesús ja ndejnaꞌan da jiin. Ti kin nchaka da presu yukan undi ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yukan ti ni kee da kuaꞌan da. Ni kuyajni da ñuu Damasco, ti ni ndinchaa ɨɨn nduva sɨkɨ da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ni nduva Saulo nuu ñuꞌun, ti ni jinisoꞌo da ɨɨn ndusu andɨvɨ ni kachi: ―Roꞌo Saulo, ¿ndoo ka kanaa ra jiin ri? ―ni kachi ndusu un. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ti ni kachi Saulo: ―Taa, ¿nau niꞌin kaꞌan? Ti ni kachi tuku ndusu un: ―Maa ri kuu Jesús, ti roꞌo kuu ja ka kanaa jiin ri. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ndokuñɨ ti kɨvɨ ra ñuu, ti ɨɨn yɨvɨ ñuu yukan kachi nuu ra ndoo saꞌa ra, ni kachi ya. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Chaa kuankoyo jiin Saulo, tu ni ka kaꞌan da chi ni ka yuꞌu xaan da. Ni ka jinisoꞌo da ja ni kaꞌan, ko tundo ni ka jini da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ni ndokuɨñɨ Saulo, ni jiña da nduchi da, ko tukaa ga ni kuu ndeꞌe da, chi ni kukuaa da. Yukan ti ni ka jnɨɨ chaa kuankoyo jiin da un ndaꞌa da, ti ni ka kɨvɨ da ñuu Damasco. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ni kuncha da uni kɨvɨ ja tu ni kuu ndeꞌe da. Tu ni yee da staa, ni tu ni jiꞌi da nducha. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ti ñuu Damasco un kancha ɨɨn chaa kandixia Jesús, nani da Ananías. Ti nuu ɨɨn jani ni kachi Yandios nuu da: ―Roꞌo Ananías. Ti ni kachi Ananías: ―Jiꞌin Yandios, ¿na jniñu kuni ni saña? ");
INSERT INTO mpmNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ti ni kachi Yandios: ―Ndokuɨñɨ ti kiꞌin ra ɨɨn ichi nani Ichi Ndoo. Ti veꞌe Judas yukan kajnuꞌun ra ɨɨn chaa ñuu Tarso, nani Saulo. Vinañuꞌni nakanajaa da ruꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ni jini da vaji ɨɨn chaa nani Ananías, ti chuxndee da ndaꞌa da sɨkɨ da ja na kuu ndeꞌe tuku da ―ni kachi Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yukan ti ni kachi Ananías: ―Niꞌin Yandios, tɨjnɨ yɨvɨ ka kaꞌan jnuꞌun chaa un, ti ka kaꞌan da naa da ja ni jaꞌa xaan da nundoꞌo nuu yɨvɨ ka kandixia Jesús ñuu Jerusalén. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ti vijna kancha da ñuu jaꞌa, chi ja ndisojniñu da nuu sutu ka kuñaꞌnu un ja na jnɨɨ da presu yɨvɨ ñuu yo ka kandixia Jesús ―ni kachi Ananías nuu Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yukan ti ni kachi Yandios nuu Ananías: ―Tu yuꞌu ra kiꞌin ra nuu kancha Saulo, chi ruꞌu ni taꞌu jniñu nuu da. Ni nakaji ri chaa un kaꞌan da jnuꞌun ri nuu yɨvɨ tɨjnɨ nación yukan, jiin yɨvɨ nación Israel. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ti na kuni da nasa kondoꞌo da ja sɨkɨ ruꞌu ―ni kachi Yandios nuu Ananías. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yukan ti kuaꞌan Ananías veꞌe nuu kancha Saulo un. Ni kɨvɨ da ini veꞌe un, ti ni chuxndee da ndaꞌa da sɨkɨ Saulo, ti ni kachi da: ―Ñani Saulo, ja ni jini ra Jitoꞌyo Jesús ichi vaji ra. Maa ya ni taji ruꞌu vaji ri ja na kuu ndeꞌe tuku ra, ti niꞌin ra Espíritu Santo ―ni kachi Ananías nuu Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Yukan na ti ni ndundijin nduchi Saulo, chi ni kenchaa viko nduchi da, ti ni kuu ndeꞌe da, ti ni janducha da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ni ndokaji da, ti ni ndundee ini da. Yukan ni kuncha Saulo tɨjnɨ kɨvɨ jiin yɨvɨ ka kandixia Jesús kanchuku ñuu Damasco. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ni jaꞌan Saulo veñuꞌun yɨvɨ Israel, ti ni kachi da ja maa ɨɨn ni Jesús kuu Seꞌe Yandios. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ni ka jinisoꞌo yɨvɨ un jnuꞌun ni kaꞌan Saulo, ti tendɨꞌɨ ni ka naa ini, ti ni ka kejaꞌa ka ndajnuꞌun: ―Ndoꞌo ini yo ja ni chaa Saulo ja na jnɨɨ da presu taka yɨvɨ ka kandixia Jesús ñuu yo, ti kin nchaka da nuu sutu ka kuñaꞌnu un, ko vijna tukaa saꞌa da siaꞌan ―ni ka kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ni jaꞌa Yandios jnundee ini Saulo, ti ni kachi da nuu chaa Israel kanchuku ñuu Damasco un, ja Jesús kuu Cristo ja ni taji Yandios ja taꞌu jniñu ñaꞌnu. Ti chaa un tu ni ka kuu ndeokani da jnuꞌun ni kaꞌan Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nu ni kuu kɨvɨ, ti ni ka ndajnuꞌun chaa Israel un nasa kaꞌni da Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ni jini Saulo ja siaꞌan ka ndoꞌo ini chaa un. Suni kuu nduu kuu ñuu ka ndito da yuxeꞌe nama kaꞌnu ja ndasɨ yuꞌu ñuu un ja ka kuni kaꞌni da Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Suni ni ka iyo yɨvɨ ni kejnaꞌan ini jiin Saulo, ja ni ka kejaꞌa ka kandixia jnuꞌun Jesús ni kaꞌan da. Ni ka nama da chaa ɨɨn jakuaa. Ni ka chundee da Saulo ini ɨɨn chika kaꞌnu, ti ni ka skuun da chaa yuꞌu nama un jiin yoꞌo. Yukan ni kaku da, ti ni jinu da kuaꞌan da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kuanoꞌon Saulo ñuu Jerusalén tuku ja kuni da najnaꞌan da jiin taka ga yɨvɨ ka kandixia Jesús yukan, ko ni ka yuꞌu chaa un ndeꞌe da Saulo, chi tu ka kandixia da ja ni nduu Saulo ndajaꞌa Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yukan ni nakiꞌin Bernabé Saulo, ti ni janchaka da chaa nuu apóstol, ni nama da chaa un, ti ni kachi da: ―Saulo jaꞌa, ni jini da Jesús ichi kuaꞌan da ñuu Damasco, ti ni kaꞌan Jesús jiin da. Ja yukan kuu ja ni kuu ndee ini da ni kaꞌan da jnuꞌun Jesús ñuu un ―ni kachi Bernabé. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yukan ti ni ka nakiꞌin apóstol un Saulo, ni ka jikonuu da ñuu Jerusalén. Ti suni ni kaꞌan da jnuꞌun Jesús jiin jnundee ini yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ni kaꞌan da jnuꞌun un nuu chaa Israel ja ka kaꞌan yuꞌu griego, ko tu ni ka jantaꞌu chaa un maa da, ti ka kuni da kaꞌni da Saulo. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nu ni ka jini uu ga ndajaꞌa un ja ka kuni da kaꞌni da Saulo, ti ni ka taji da uu chaa kuankoyo jiin da ñuu Cesarea. Ti yukan ni ka nataji da chaa kuanoꞌon da ñuu da Tarso. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ti kuiya yukan, tukaa ni iyo nundoꞌo nuu yɨvɨ ka kandixia Jesús ñuu Judea, ñuu Galilea, jiin ñuu Samaria. Ni ka ndundee ini yɨvɨ un, ti ni ka kejaꞌa ka ndukuaꞌa, ti ka jandatu i jniñu taꞌu Yandios. Ti Espíritu Santo, jaꞌa ya jnundee ini i naa i. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Yukan ti ni jaꞌan Pedro taka ñuu nuu kanchuku yɨvɨ ka kandixia Jesús. Suni ni jaꞌan da ñuu Lida ja na kuni da nasa kanchuku yɨvɨ ka kandixia Jesús yukan. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yukan ni jini da ɨɨn chaa nani Eneas ja kuꞌu da. Ni katuu da una kuiya ja ni kuu tɨkuku sɨꞌɨn da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ni kachi Pedro jiin da: ―Roꞌo Eneas, ja ni saꞌa Jesús tajna roꞌo vijnañuꞌni. Ndoko ti na stuu ra yuu ra ―ni kachi da. Yukan ti ni ndoko da, chi ja ni nduvaꞌa da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tendɨꞌɨ yɨvɨ kanchuku ñuu Lida jiin yɨvɨ ñuu Sarón, ni ka jini ja ni nduvaꞌa da, ti ni ka kejaꞌa ka kandixia jnuꞌun Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ñuu Jope kancha ɨɨn ñasɨꞌɨ nani Tabita, ja ni nani ña Dorcas nuu yuꞌu griego. Suni ni kandixia ña Jesús, ti ka jaꞌa yɨvɨ ja yɨñuꞌun maa ña, chi chindee ña yɨvɨ ndaꞌu. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kɨvɨ jña ni kejaꞌa kuꞌu ña, ti ni jiꞌi ña. Ni ka skuchi yɨvɨ un yɨkɨ kuñu ña, ti ni ka skatuu ña ini ɨɨn veꞌe kuu uu. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ti ni ka jini ndajaꞌa Jesús ñuu Jope un ja kancha Pedro ñuu Lida. Yukan ni ka taji da uu chaa kuankoyo nuu kancha Pedro ñuu Lida, chi tu jika xaan. Ni ka jakoyo da yukan, ti ni ka kaꞌan ndaꞌu da jiin Pedro ja na kiꞌin da ñuu Jope, chi katuu ɨɨn ndɨyɨ ja na nɨ chaku i, kuu i ɨɨn yɨvɨ vaꞌa. Ti ni kachi da: ―Choꞌo ñuu un vijnañuꞌni ―ni kachi da. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yukan ti ni kee Pedro kuaꞌan da jiin da. Ni jaa da, ti ni kaa da nuu katuu ndɨyɨ yukan. Yukan kaꞌiin tɨjnɨ ñaꞌan ni kendo maa ɨɨn ka ndeꞌe xaan ña, ti ni ka xnaꞌan ña taka saꞌma ni saꞌa Dorcas na ni chaku ña. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Tendɨꞌɨ ñaꞌan un ni keniꞌin Pedro kuankoyo ña, ni jakunjitɨ da ti ni jikantaꞌu da nuu Yandios. Yukan ni tuꞌva da nuu katuu ndɨyɨ un, ti ni kachi da: ―Ndoko Tabita ―ni kachi da. Yukan ti ni jiña ña nduchi ña. Ni ndeꞌe ña nuu Pedro, ti ni nukoo ña. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ni jnɨɨ da ndaꞌa ña, ti ni ndokani da ña. Yukan ti ni kana Pedro taka yɨvɨ, ndajaꞌa Jesús jiin ñaꞌan un, ti ni xnaꞌan da nuu yɨvɨ un ja chaku tuku ña. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tendɨꞌɨ yɨvɨ ñuu Jope un ni ka jini nava ni jnaꞌan Dorcas, ti kuaꞌa ni ka kejaꞌa ka kandixia Jitoꞌyo Jesús. ");
INSERT INTO mpmNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Yukan ni kuncha Pedro tɨjnɨ kɨvɨ, ni nchaa da veꞌe ɨɨn chaa nani Simón, ɨɨn chaa steꞌyu ñɨɨ. ");
INSERT INTO mpmNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kancha ɨɨn chaa nani Cornelio ñuu Cesarea. Ni kuu da ɨɨn capitán ni taꞌu da jniñu nuu ɨɨn ciento soldado. Ni ka yɨꞌɨ nuu soldado vekoyo ñuu Italia. ");
INSERT INTO mpmNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ñavaꞌa da jnuꞌun chaa Israel, ansu maa chaa Israel ni kuu da, ko ni nchañuꞌun da Yandios jiin taka jnaꞌan da. Ti kuaꞌa xuꞌun ni jaꞌa da nuu yɨvɨ