﻿USE sofia;
DROP TABLE IF EXISTS sofia.mpj_vpl;
CREATE TABLE mpj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mpj_vpl WRITE;
INSERT INTO mpj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yini ngaakajaya mitunyjanirriya julyju nyinapayi, Jiijaj Kurayijmili walyjakaja. Yipurampa Jiijajmili walyja julyju nyinapayi. Yipuramja marlakarti nyinapayi Tayipitpa, Jiijajmili walyja. ");
INSERT INTO mpj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yipuramkura kaja Yajikpa nyinapayi. Yajikkura kaja nyinangu Jayikappa. Jayikapkura kaja Juuta nyinangu. Jayikapkura kajakaja yarnnga nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juutakura kaja kujarrapula nyinangu, Piirijkamu Jiiraku. Jiiraku yipira nyinangu, Tama. Piirijkura kaja Yijaranpa nyinangu. Yijarankura kaja Raampa nyinangu. ");
INSERT INTO mpj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raamkura kaja Yaminatappa nyinangu. Yaminatapkura kaja Najanpa nyinapayi. Najankura kaja Jaalmanpa nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jaalmankura kaja Puuyajpa nyinangu. Puuyajju Ruujjupula manu kaja Yupitpa. Yupitkura kaja Jiijiyi nyinangu. ");
INSERT INTO mpj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jiijiyikura kaja Tayipitpa nyinangu. Tayipit-janampa maaja maju nyinangu. Tayipitkura kaja Jalamunpa nyinangu. Martu Yurayamili nyupalu manu Jalamunpa, Tayipitju ngulyulu manuka marlalu kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jalamunkura kaja Riyapumpa nyinangu. Riyapumkura kaya nyinangu Yapayija. Yapayijakura kaja nyinangu Yayija. ");
INSERT INTO mpj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yayijakura kaja nyinangu Jiyujapatpa. Jiyujapatkura kaja nyinangu Juurampa. Juuramkura kaja nyinangu Yaajaya. ");
INSERT INTO mpj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yaajayakura kaja nyinangu Juujampa. Juujamkura kaja nyinangu Yiijajpa. Yiijajkura kaja nyinangu Yijikaya. ");
INSERT INTO mpj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yijikayakura kaja nyinangu Manaja. Manajakura kaja nyinangu Yiimujpa. Yiimujkura kaja nyinangu Juujaya. ");
INSERT INTO mpj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Juujayakura kaja nyinangu Jikanaya. Jikanayamili marlajukaja nyinangu. Palu tayimu-jananya maaja majulu-jananya kangu ngurra Papilunkarti, Yijurilmili marlajanukaja. ");
INSERT INTO mpj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jikanayakura kaja nyinangu Jiyiltilpa. Jiyiltilkura kaja nyinangu Jarapapulpa. ");
INSERT INTO mpj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jarapapulkura kaja nyinangu Yapiyutpa. Yapiyutkura kaja nyinangu Yilayikimpa. Yilayikimkura kaja nyinangu Yayijuru. ");
INSERT INTO mpj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yayijurukura kaja nyinangu Jaatakpa. Jaatakkura kaja nyinangu Yikimpa. Yikimkura kaja nyinangu Yiliyutpa. ");
INSERT INTO mpj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Yiliyutkura kaja nyinangu Yilija. Yilijakura kaja nyinangu Majanpa. Majankura kaja Jayikappa nyinangu. ");
INSERT INTO mpj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jayikapkura kaja nyinangu Juujappa. Juujappa jii Miirimili nyupa nyinangu. Miirilupula Juujapju manu Jiijajpa. Martukajaluya yini kujupa jiinya wajalpayi, ‘Kurayijpa’ ");
INSERT INTO mpj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yipuramungka marlajanuya puutin wulikaja nyinangu, ka-janampa maaja Tayipitpa nyinangu. Palujanu puutin wulikaja kujupaya nyinangu, Tayipitja marlakarti. Palujanu maaja majulu-jananya kangu ngurra Papilunkarti. Palunyajanu puutin wulikaja kujupaya marlajanu nyinangu, kayila Jiijaj Kurayijpa puunarringu. ");
INSERT INTO mpj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiijaj Kurayijpa pakarnu miralarringu japukurlu. Yiltangulyu jingularringu. Palunyara yakurtinga yini Miiri. Pilyurrpara Miiriku Juujappa. Yunguraya ngaanya wanti Miiri Juujapku, Miirilu yanku Juujapkarti ngulampa. Mirtapula ngurra ngarringu, paki, ngurrpara kirtaku Miiri. Palunyangkayilapa Miiri jijiwintirringu. Palunyangkara Juujappa nintirringu jijiku Miirimiliku, ngurinyjirringura. Ngangkulpayi, “Nganakurnu jiinya jiji? Nganara mamapartarnu?” Yiltangulyu Juujappa ngurrpa nyinapayi. Mirta kirtakurnu jijinga Miirimilinga, paki, kurtingulu Mamalu palumili Kurrurnpa Miirikarti. Wajarnila jilanya. Jiinya Kurrurnpa Mamamili, Kurrurnpa kunyjunyu Mamajanu, yuu. Kurrurnpa kunyjunyu Mamajanulu kurrungu Miiringka, kayila jijiwintirringu Miiri. Mamapartarnura jijiku Miirimiliku Kurrurnpa kunyjunyu Mamajanu. Ngurrpangulyu Juujappa nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pilyurrpara Miiriku yirna kunyjunyu nyinapayi, Juujappa yiltapayi. Ngangkulpayi, “Ngunjurlparnara. Yaalumankurna? Parlanyparnara ngukarrilkuraku Miiri wumungka wangkakarrangka, Miiri kurntarrijaku. Kurntarrijakungkamarra, kanyilkurnaju wangka.” Kangku wajarnu, “Wajalkurna kurtingku Miiri kumpilu, yuu, junkurna yanku kumpilu.” ");
INSERT INTO mpj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Palunyangka parra kulilpayi Juujapju. Mamaluyilalu kurtingu wikarru palumili Juujapkarti. Palunyangka Juujapju nyangu wikarru kapukurrilu. Wikarrulura wajarnu, “Juujappa!, nyinaniran mitunyjarripurlukaku Tayipitku marlajanu. Mirtan ngurlurri!, mirtaran ngunjularri Miiriku!, paki, marrangku Miiringa, nyupangku. Kangkungkun ngurrakarti nyuntumilikarti. Yiltangulyu jijiwintirringu Miiringa. Mirta kirtakurnu jiji jiinya, paki, Mamapartarnura jijiku Miirimiliku Kurrurnpa kunyjunyu Mamajanu. ");
INSERT INTO mpj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Yuu, Miirilu kanyilku murtilya japuwarta, kajara, kan yinijunku yini Jiijajpa. Jiijajju-jananya wankalku yarnnga martukaja. Jiilungurninyjinga-jananya wankalku palumilikaja walyjamarrikaja. Ka-janampa wajalku Jiijajju, ‘Walykunyurra nyinapayi, kayilarna-nyurranya wankalku. Palunyangkanyurra wiyurrpa kunyjunyu nyinaku.’ Jilanya-janampa wajalku Jiijajju ngulampa.” Yuu, jilanyara wajarnu wikarrulu Mamamililu Juujapku. ");
INSERT INTO mpj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Julyju Mama wangkangu, palunyangka yiltarringu, yuu. Mamalura yungu wangka martu julyjujanu, yininga martu Yayijaya. Palunyara martu nyinapayi Mamamili wangka jakurlpurluka. Palunyangka-janampa martulu jakurlpurukalu Yayijayalu wajarnu wangka Mamamili. Kayila wakarnu mirlimirlingka wajarnuka. ");
INSERT INTO mpj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jilanya wakarnu wangka, “Kulilaya! Wantinga yurrkanypanga jijiwintirriku, ngurrpara kirtangka ngarriraku. Palulu wantilu jiji kanyilku, yutirrikura kaja. Kayilaya yinijunku yini Yimanyuwilpa.” Wangka-janampa “Yimanyuwilpa”. Wajarnila ngayunju, “Mama-lanya nyinani ngayurtinja.” Yiltangulyu ngaanya wangka julyjujanu, palunyangka yiltarringu. ");
INSERT INTO mpj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Palunyangka Juujappa kanarringu kunyalajanu. Wurrkulilpayi, “Wikarruluju wajarnu, mankurakurna Miiri.” Kalu yanu. Palunyajanu Juujapju manu jiinya wanti, nyupararrarringupula. Kapula yanu ngurrakarti Juujapmilikarti. ");
INSERT INTO mpj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mirtangkupula ngamulkirra ngarringu, paki, ngulawiyajupula ngarripayi, jampa Jiijajpa yutirringu. Palunyangka kanyirnu kaja Miirilu. Kayila yinijunu yini Jiijajpa Juujapju. ");
INSERT INTO mpj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngurra Juutiyangka tawun Pijiliyamja Jiijajpa jiji japuwarta puunarringu, maaja maju Yirutpa palunya tayimu nyinapayi. Palujanuya martu karlkinpa kakarrajanu Jarujalumkarti yankupayi. Kurtalyakajaya nintilu nyakura ka kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jarujalummartajiya-jananya yankura japilpayi, jilanya, “Juwuku-janampa maaja maju wanyjangka nyininpa? Kuwarri puunarringu. Kurtalyalaju kakarrara nyangu, ka nintilulaju kulirnu, ‘Maaja maju palunga puunarringu.’ Kurtalyalu-lanyaju nintirnu maaja maju kujupa, puunarringu. Maajalaju palunya marninypungkura palukulaju yankupayi.” ");
INSERT INTO mpj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wangka palunya kulirnu maaja Yirutju ka ngurlurringu. Kulirnu, “Maaja palu majurriku karni palulu pungkujaku, kayilapa maaja nyinakuraku.” Jarujalummartajilurrjuya ngurlurringu Yirutjamarra, jumajiya kulilpayi Yirutju maaja maju kujupa kuliraka wirrilyirrijaku, ka pungkujaku-jananya, Jarujalummartaji. ");
INSERT INTO mpj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Palujanu Yirutpa-janampa mirrangu, maaja karlkinku, yatilypa majukajaku, Muujajmili wangkapurlukakajakulurrju. Kujungkanu-jananya ka japirnu jilanya, Yirutju, “Juwukajamili maaja maju Kurayijpa wanyjangka puunarriku? Mamalu julyju jamartapungu, kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wajarnuraya, “Ngurra Juutiyangka tawunja Pijiliyamja, palungka. Mamamili wangka jakurlpurlukalu julyju wakarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tawun Pijiliyammartajiluya kulila! Nyunturtinku-ngkuya ngurra miinwanpa, mirta walyku. Ngurra Juutiyawanaya ngurra karlkinpa walyku nyininpa, nyunturtinmili-ngkuya miinwanpa nyininpa. Nyunturtinmili ngurrangka maaja maju puunarriku. Palulu-jananya maaja majulu Yijurilmili marlajanukaja ngula ngampurrju kanyilku.’” ");
INSERT INTO mpj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Palujanu Yirutju kuju wangkawinti kurtingu yankuraku-jananya wajalkura, yirnakajangka kakarrajanu, jilanya “Yankurakurniya wangkaraku.” Mirta-jananya Yirutju palumili warrkamupurlukakajangka wajarnu, jumajiya martukaja karlkinpa nintirrijaku wangkaku. Palujanurniya kakarrajanu jiikaja yanurni, ka Yirutju-jananya japirnu jilanya, “Nyaartanyurra nyangu kurtalya jii yutirringu?” ");
INSERT INTO mpj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wajarnuraya, “Yuwa, nyangulaju julyju kurtalya yutirringu.” Ka wajarnu-janampa Yirutju, “Yarraya tawun Pijiliyamkarti!, nyakurakuyan jiji palunyaku. Ka marlakurrikurniyan ngayungka wajalku. Palunyajanurna ngayulu yanku palunya marninypungku.” ");
INSERT INTO mpj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wangkaya palunya kulirnuka yanu. Mayajanuya pakarnu ka kurtalya palunyaya nyangu pukurlarringu, kaya yarrarnu wanarnu. Kurtalya-janampa palunya kurranyirringu ka yanu Pijiliyamja yikipayi, ngurra kujungka. Palungka Jiijajpa japuwarta ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mayangka palungkaya kurrunguka nyangu yipirarrapula, Miirikamu jiji japuwarta. Nyangukaya murtingka nyinatingu, kaya pupatingu. Maaja majuya kulirnu kaya marninypungkupayi. Palujanu wartakaja-ngkuya mankupayi yungkurakuraya, jiji palunya. Kuulukajaraya yungkupayi kamu jinyjiyuru kunyjunyu parntiwinti, wamayurulurrju wartajanu. ");
INSERT INTO mpj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Palunyajanuya jukurrju nyangu, Mama ngarnawarrapurlukalu-jananya marrkurnu, mirtaya marlaku Yirutkarti yankuraku. Palujanuya ngurra walyjakarti kujupawana marlaku yanu yaka, Yirutjamarra. ");
INSERT INTO mpj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jampaya marlaku yanu, palujanu Juujapju jukurrju nyangu Mamamili wikarrululu wajarnu jilanya, “Pipurrulu-pulanya marra kati ngurra Yijipikarti!, Yirutjamarra. Yirutju kulini ngurrilkura ka mitu pungkukijalu, jiji japuwarta, palunya. Ngurra Yijipingkapula wululyu nyinama!, ngularnanta wajanyjangka kayilapanyurra yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jampa mungajarrarringu kangu-pulanya ngurra Yijipikarti. ");
INSERT INTO mpj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yijipingkaya kurrungu, kaya rawa nyinangu, kayila maaja Yirutpa miturringu. Palu wangka Mamamili yiltarringu. Mamamili wangka jakurlpurlukalu julyju wakarnu jilanya, “Ngurra Yijipijanurna wajarnu kurtingu ngayuku kaja.” ");
INSERT INTO mpj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Palujanu wirrilyirringu-janampa maaja Yirutpa yirnakajaku kakarramaluku, jampa-jananya ngangkurnu, yanuya yaka kujupawana. Palumili jantulwintikaja-jananya wajarnu kurtingu, murtilyakajaya-jananya pungkura miturntalkuraku, ngurra Pijiliyamja, kamu ngurra ngamukaja palungka. Wajarnu-jananya, “Murtilyakaja-jananyaya pungkura, ngarrilarakajakamu nyinalurrukaja, kamu parra yankunyjalurrju kamu kujarra yiiyakaja.” Yirutju julyju kulirnu, “Wajarnurniya kakarrapurlukalu yiiya kujarrangkaya nyangu jii kurtalya yikipayi. Palujanu maaja jiinya kujarra yiiyangka puunarringu.” Palunyangka Yirutju-jananya wajarnu pungkuraku-jananyaya murtilyakaja kujarra yiiyakaja, Jiijajpa japuwarta pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Palujanuya jantulwintikaja yanuya-jananya pungkupayi murtilyakaja japuwartakaja. Palujanuyila Mamamili wangka kujupa yiltarringu. Mamamili wangka jakurlpurlukalu Jirimayalu julyju wajarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tawun Ramangkaya Yijurilmili marlajanukaja ngurrangka yulaninpa, jijiya-janampa japuwartakaja jumaji pungkuninpa. Jijikajaya japukaja miturringu, palunyangkaya-jananya purtu jiimartaji karlki kujupalu marrkurni. Wuluya yulaninpa.” ");
INSERT INTO mpj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Palujanu ngula maaja Yirutpa miturringu. Ka Juujappa ngurra Yijipingka kunyala ngarripayi, ka jukurrju nyangu, ");
INSERT INTO mpj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Mamamili wikarrulu wangkangu, “Marra-pulanya kawa ngurra walyjakarti! Yirutju kulilpayi nyuntumili kaja pungkuraku. Kuwarri Yirutpa palu miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Palujanu Juujapju-pulanya yipirarra kangu, ");
INSERT INTO mpj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","kayilapa kutungka jakurlpa kulirnu Yirutmili kaja Yakiyalajpa maaja nyinapayi, Juutiyamartajiku martukajaku. Ka Juujapju kulirnu ngurlurringu. Ka palulu yarrarnu jukurrju nyangu, Mamamililu wikarrulu marrkurnu mirta yankura, ngurra Juutiyakarti. ");
INSERT INTO mpj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Palujanu Juujapju-pulanya katingu ngurra Kaliliyakarti, tawun Najarijkarti. Tawun jiingkaya nyinapayi. Palujanu Mamamili wangka kujupa yiltarringu. Mamamili jakurlpurlukakajaluya julyju wajarnu jilanya, “Martukajaluya wajalku, palunga Najarijmartaji.” ");
INSERT INTO mpj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Palujanu ngurra Juutiyangka-jananya pujimanwana Jaanju parra wajalpayi, ka kalyungka-jananya jarrpajunma. ");
INSERT INTO mpj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jilanyalu-jananya martukajangka wajalpayi, “Walykuwintinyurra nyinani, jurraya junga nyinama Mamaku!, jumaji tayimu ngamurringu. Mamalu-jananya palumili walyjakaja ngampurrju kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jaanpa julyju wajarnu Yayijayalu, Mamamili jakurlpurlukalu jilanya, “Martu kujulu-jananya pujimanwana yukuriparniwana parra wajalku, jilanya, ‘Maajakuranyurra palya nyinaranku wanalkuralunyurra jungalu. Yiwarrangkaluya wanalkura palyalu. Maajangampa-nyurrampa ngula warinykatiku nintijulkuraku-nyurranya.’” ");
INSERT INTO mpj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jaanpa kulujpa kujupawinti nyinapayi, kamalmili pankukajawinti. Nanpa kanyilpayi kamalmili likarrajanu. Palunyalu purntarlkakaja ngalkupayi ka jurtipirrikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Palujanuya martukaja yanu Jaanpaya kulilkuraku, Juutiyamartajilu, Jarujalummartajilukamu karru Juutanmartajilulurrju. ");
INSERT INTO mpj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wajalpayiluya Jaanja walykukajaya ngapilpayi, palujanu-jananya Jaanju kalyungka jarrpajunkupayi, karrungka Juutanja. ");
INSERT INTO mpj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","Parajikajakamu maaja kujupakajaya yanurni, Jaanju-jananya kalyungka jarrpajunkuraku. Nyangu-jananya Jaanju ka warrkirnu-jananya jilanyalu, “Jilayurunyurra nyinani, warungkamarrayan ngurlu pinirrinpa. Pinirringurninyurra ngayukarti, kalyungkarna-nyurranya jarrpajulkuraku, Mama ngarnawarraluntaya mitu pungkujakungkamarra, walykuwintikaja. Mirtanyurra kalyungkawiyaju jarrpara ka pakalkura, walykukajaya jurra!, karaya Mamaku junga nyinama! ");
INSERT INTO mpj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mirtanyurra jilanya kulila! ‘Mitunyjarripurlukakulara Yipuramku marlajanukaja nyininpa. Mirta-lanya pungku Mamalu miturntanku, jumajila Yipurammili walyja, marlajanukaja.’ Kulilaya jilanya!, Mamalu-nyurranya walykukajawinti pungkunirra miturntalku. Kayilapa Mamalu-jananya kujupakaja martukaja yalyjirrju ngapilku yapujanu. Palujanu-jananya Mamalu wajalku, ‘Nyunturtinpayan Yipurammili marlajanukaja nyinani.’” ");
INSERT INTO mpj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Kuwarriya walykukaja jurra!, Mamalu-nyurranya wirrilyirrira mitu pungkujaku. Martu yikini yilipiwinti wartakaja walykukaja putalkuraku, warungka warningkuraku. Wartakaja walykukajayuruya martukaja nyininpa. Mama ngarnawarrapurlukanga martuyuru paluyuru, yilipiwinti yikini, martu walykukaja-jananya pungkula miturntalkuraku, warukutu-jananya warningkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jaanju-jananya yarrarnu wajarnu, “Ngayulurna-nyurranya kalyungka jarrpajunkuni, martu yarnngaluya nyakura ka jilanya kulilkuya, ‘Yilta ngaakajaya Mamaku nyininpa, walykukajaya junu yanu.’ Kayilaparni kujupa maaja maju yanku Kurayijpa, ngayungka munkarra maaja majujura. Jiilu-nyurranya karlkinpa Mamamili Kuurti kurrujunmalpa, murlpirrpanyurra nyinaraku, junga. Ka karlki kujupa-jananya payilku kurtingku warukarti. Kurayijpa-lampa jii yankurni, maaja majuminyirri, karnara ngayu palumili warrkamupurluka. ");
INSERT INTO mpj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wantilu tiijingka wilykikaja yungkalku, walykukaja punkalkuraku. Ka walykukaja kangku warningku warungka. Wangka jilanyayuru nyininpa Mamalu palumili walyjakaja kangku kanyilku palumili ngurrangka, kayila wilyki walykukajayuru karlki kujupa martukaja kangku warningku warungka.” ");
INSERT INTO mpj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Palujanu ngurra Kaliliyajanu Jiijajpa yanu karru Juutankarti Jaankartilu, kalyungka jarrpajunkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jaanjura Jiijajpa japirnu jilanya, “Nganakurnin japini nyuntulu? Mirtarnanta nyuntu jarrpajunkura, nyuntulurnin jarrpajunkungara.” ");
INSERT INTO mpj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Palujanu Jiijajjura wajarnu, “Kunyjunyungulyurnin kuwarri jarrpajunku, Mama jilanyaku pukurlarrinpa.” Palujanu Jaanju kulirnu ka pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jaanjuyila kalyungka Jiijajpa jarrpajunu. Palunyajanuyila Jiijajpa kalyujanu pakarnu yanu marlaku yikingu. Palujanu ngarnka wupunarringu. Jaanju nyangu Mamamili Kuurti turruyuru yankupayi, kayila Jiijajjalu nyinatingu. ");
INSERT INTO mpj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Palujanu Mamalu ngarnawarrajanu wangkangu Jiijajja jilanya, “Ngaanyaju ngayuku kaja, layikamurnara nyininpa pukurlparnara.” ");
INSERT INTO mpj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mamamili Kuurtilu Jiijajpa katingu pujimankarti, malpulu muunpungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pujimanja palungka rawa nyinapayi, jikij wiikingka. Mirta ngalkunma rawalu, Mamawiyaju marninypungkupayi. Nyinangu kalyparturringu. ");
INSERT INTO mpj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Palujanu malpulu Jiijajpa parra yajiyajilpayira wangkangu jilanya, “Yiipin nyuntu Mamamili kaja nyininpa, Mamara japila!, yapukaja ngaakaja mirrkamankura.” ");
INSERT INTO mpj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jiijajjura wajarnu, “Wangka Mamamili jilanya nyininpa, ‘Martulu mirrka ngalkuraka wanka nyininpa. Palunyayuru yiipi martulu Mamamili wangka kulinmalpa, palujanuyila wanka nyinaku. Martulu mirrka ngalkuraka ngula miturriku, ka yiipi Mamamili wangka kulinmalpa palujanu wanka nyinamalpa.’” Malpulura purtu kulirnu, wangkaku ngaaku ka yakarringu. ");
INSERT INTO mpj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jilanya purtu muunpungu malpulu kayila tawun Jarujalumkarti kangu Jiijajpa. Juwumili jaaji majungka kangu ngarnawarra nyinajunu. Ka wajarnulu, ");
INSERT INTO mpj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Yiipin nyuntu Mamamili kaja, ngarnawarrajanu wuulangka!” Kara malpulu yarrarnu wajarnu, “Mamamili ngarnawarrapurlukamili wangka kujupa jilanya nyinani, ‘Mamamili wikarrukaja-jananya Mamalu wajalku, ngampurrjuntaya kanyilkura, parnangkan punkaljaku.’” ");
INSERT INTO mpj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jiijajjura wajarnu, “Mamamili wangka jilanya nyininpa, ‘Mirta walyjalula kuliraka ngapilkura, Mamamili wangkawiyajula kulira ka ngapilkura.’” ");
INSERT INTO mpj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jilanya purtu muunpungu malpulu. Kayilapa katingu Jiijajpa yapu majuwartakarti, ka yapungka ngarnawarra junu. Jiingkalu kangu nintijunu parna parlparriwana, mayakaja nyinapayi, wartakajalurrju, parlkarra maju, martukajalurrjukamu manikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nintijunu kalu wajarnu, “Ngaaku warrarnkajaku, wartakajakulurrju martukajakulurrjurnanta ngayulu maaja maju junku, yiipirnin ngayu pupatiku parnangka marninypungku.” ");
INSERT INTO mpj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Palujanura Jiijajju wajarnu, “Yarra malpu! Mamamili wangka jilanya nyinani, ‘Mama ngarnawarrapurlukawiyajula marninypungkuraku, palukulara maaja majuku junga nyinakura.’” ");
INSERT INTO mpj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Malpulu palulu purtu muunpungu ka junu. Palujanuya Mamamili wikarrukaja yanurni, kaya ngampurrju kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Palujanu Jiijajju wangka kulirnu, Jaanpaya jantulwintikajalu manu jiilja kurrujunu. Palujanu ngurra Juutiya junu yanu, ka kayili yanu ngurra Kaliliyakarti. ");
INSERT INTO mpj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tawun Najarijwana yanu tawun Kapaniyamukarti, wulu nyinakuraku. Tawunpa palunga kalyu Kaliliyangka kinti yikipayi. Mitu kujarraku Jipiyulankamu Naputaliku marlajanukajaya jiingka parra nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngurra palungka Jiijajpa nyinapayi. Jiingka Kurayijpa nyinakuraku, Mamamili jakurlpurlukalu Yayijayalu julyju wajarnu. Wangka palunga yiltarringu. Jilanya Yayijayalu wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jipiyulankamu Naputaliku marlajanukajaku ngurra karru Juutanja yapurra yikipayi, kalyungka majungka yini Kaliliyangka. ");
INSERT INTO mpj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ngurra palunya Juwuparnikajaku-janampa ngurra. Jiimartajiya martukaja ngurrpa Mamaku nyininpa, mungajarrayuruya nyininpa. Ngularaya Kurayijku ninti nyinaku, layitingkayuruya nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Palujanu-jananya Jiijajju martukaja parra nintijulpayi jilanya, “Walykuwintinyurra nyinani. Jurraya junga nyinama Mamaku!, jumaji tayimu ngamurringu, Mamalu-jananya kanyilkura. Mamalu-jananya palumili walyjakaja ngampurrju kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jiijajpa yanu yirritiwana kalyungka Kaliliyangka. Nyangu-pulanya yirna kujarra, kalyungkapula wirrupungkupayi niitingpa kukaku, piijku. Palu kujarrangapula kurtararra yini Jayimunkamu Yanturu. Jayimunpa palunga yini kujupa Piija. Palu kujarrapula warrkamupurluka kalyungkapula piijpa mankupayi, puntu laltuku. ");
INSERT INTO mpj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jiijajpa-pulanya yanurni kujungkarringu. Wajarnu-pulanya jingulpa, “Jurrapula warrkamu!, karnipula yankura wulikaja! Julyjunyurra warrkamurrira piijkaja mankupayi, ka kuwarrirna-nyurranya nintilku Mamamili warrkamunyurra ngapilkura, wangka-jananyanyurra jakurljulkura ka nintijulkura Mamamili walyjarrikurakuya.” ");
INSERT INTO mpj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Palunyalu kujarralupula junu yanu niitingpa, wulikajarringuya yanu Jiijajmapu, kalyungka yirritiwana. ");
INSERT INTO mpj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yanuya nyangu yupalpaya nyinapayi puutka. Mamararranjuya niitingpa kunyjunyunkula nyinapayi puutkalu, warrkamupurlukalulurrju, laltuluya. Palunyangaya yini Jayimijpa, Jaanpa, jirlpi Jipiti mama-pulampa. ");
INSERT INTO mpj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jiingkaya Jiijajmapu yikipayi, ka Jiijajpa-pulampa mirrangu, “Yarrarnipula!” Palunyalupula warrkamupurlukakaja junu yanu, mamalurrju. Yanulupula Jiijajkarti kulirnu. Palujanu kujungkarriraya yanu. ");
INSERT INTO mpj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ngurra Kaliliyawana Jiijajju-jananya parra nintijulpayi. Juwumili jaajikajangka-jananya parra wajalpayi. Ngarntakaja-jananya ngurra parlparriwana kunyjunyulpayi. Wangka kunyjunyu-jananya wajalpayi jilanya, “Mamalu-jananya palumili walyjakaja ngampurrju kanyini.” ");
INSERT INTO mpj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jilanyalu-jananya kunyjunyulpayi, kamu wangka-jananya parra wajalpayi martukajangka, kayilaya jakurlpa kangu ngurra Jiriyawana. Kulirnuya jiimartajilu kayila-jananyaya martukaja yarnnga ngarntawinti katingu, Jiijajkarti, malpuwintikaja, parralayijikajakamu, ngakumpakajalurrju. Jiijajju-jananya yarnnga kunyjunyunu. ");
INSERT INTO mpj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Martu yarnngaluya Jiijajpa wanarnu kulilpayi, Kaliliyamartajilukamu Tikapulijamartajilukamu Jarujalummartajilukamu ngurra Juutiyamartajilu, karru Juutanja kakarraramartajilulurrju. ");
INSERT INTO mpj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Martukaja yarnngaya kujungkarringu Jiijajpa kulilkijalu. Ka Jiijajpa yapungka takarnu japuwartangka nyinangu, ka nintilpayi-jananya. Palujanu palumili wangka-nintikajaluya kujungkarringu. ");
INSERT INTO mpj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jilanya-jananya nintilpayi, ");
INSERT INTO mpj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Karlkikajanyurra nyarru nyininpa! Pukurlpaya nyinama!, Mamalu-nyurranya palumili walyjakaja ngampurrju kanyinmalpa. ");
INSERT INTO mpj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Karlkikajanyurra nyininpa wirla walyku. Pukurlpaya nyinama!, Mamalu-nyurranya pukurlmanku. ");
INSERT INTO mpj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Karlkikajanyurra nyininpa, mirtangkunyurra walyjalu marninypungkuninpa. Pukurlpaya nyinama!, Mamalu-nyurranya palumili walyjakaja ngampurrju kanyinmalpa. ");
INSERT INTO mpj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Karlkikajanyurra nyininpa Mamamili wangka kuliraka jungalu ngapilkura. Pukurlpaya nyinama!, Mamalu-nyurranya yilta nintilku, junganyurra nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Karlkikajanyurra nyininpa, karlki kujupakunyurra nyarrurrira nyininpa. Pukurlpaya nyinama!, Mamalu-nyurranya puntaji nyarrurriku kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Karlkikajanyurra nyininpa Mama ngarnawarrapurlukakuwiyajunyurra junga nyininpa. Pukurlpaya nyinama!, ngulanyurra yilta Mama nyakuka kujungkanyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Karlkikajanyurra nyininpa. Jurtapayimapukajanyurra marrkurni, kunyjunyuya nyinakuraku. Pukurlpaya nyinama!, Mamalu-nyurranya palumili walyjakaja ngampurrju kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Karlkikajanyurra nyininpa, Jiijajmilinyurra walyja. Karlkinju-nyurranyaya warrkiraka pungkuni, jumajinyurra Jiijajmili walyjakaja. Pukurlpaya nyinama!, Mamalu-nyurranya kulini, yiltanyurra wulu junga nyininpa. Mamalu-nyurranya palumili walyjakaja ngampurrju kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Karlki kujupakajanyurra nyininpa Jiijajmili. Karlkinju-nyurranyaya warrkiraka pungku. Jiikajalu-nyurranyaya jankamalpa, jumajinyurra Jiijajmili walyjakaja. Pukurlpaya nyinama!, Mamalu-nyurranya ngampurrju kanyilku. Martu karlkinyurunyurra nyininpa, Mamamili jakurlpurlukakajaya-jananya julyju warrkiraka pungkupayi.” ");
INSERT INTO mpj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jiijajju-jananya wangka juku wajarnu, “Juulujanu kuka kunyjunyurrinpa. Juulu palunya kunyjunyu. Juulu rawa ngarrinyjanpa yarlkawana putarriku. Juulu puta minyjilarriku. Juulu kunyjunyuyurunyurra nyininpa, ngayuku puntu walyja. Karlkinju-nyurranyaya kunyjunyu nyaku, ka-nyurranyaya kujungkarriku nyuntunja, karninyurra Jiijajpa wanalku. Juulu kunyjunyuyurunyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mayakajaya yapungka ngarnawarra yikiku, layitiwinti. Martukajaluya layiti nyakuraka kujungkarriku mungajarra. Palunyayuruyan layitiyuku ngayuku walyjakaja nyinin. Martukajaya ngayuku ngurrpakaja nyakura-nyurranyaya kujungkarriku layitiyurungka, ngayuku wangkaya kulilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Laampula tilini, mirtala turampungka kukujarri junku, yutila junku martukajaluya nyakura nyinakuraku. ");
INSERT INTO mpj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wangka palunyayuru nyininpa. Yiipinyurra ngayuku junga nyinaku, ka kunyjunyukaja ngapinmalpa, layitiyurunyurra nyinaku. Palujanu martukajalu-nyurranyaya nyaku ka kujungkarriku, ngayumili wangkaya kulilku, kaya Mama marninypungkumalpa. ");
INSERT INTO mpj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mayitpinyurra jilanya pakiwana kulini, ‘Jiijajparna yanurni Muujajmili wangka katamatulkuraku, wangka kujupakajalurrju, Mamamili jakurlpurlukaluya julyju wajalpayi.’ Mirtarna yanurni wangka palurna katamatulkuraku. Wangka palunya yiltarringu, jamparna ngayu parnatu yanurni. Jiikajalurniya Muujajmapjukamu Mamamili jakurlpurlukakajalu ngayu wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wangka ngaanyaya kulila! Wangka palunga Muujajmilikamu Mamamili jakurlpurlukakajalu wakarnu, palunyanga wulu nyinaku. Mirta kutungka pakirriku, ngulanga ngarnkakamu parna pakirriku, palujanuyila wangka ngaanya pakirriku. ");
INSERT INTO mpj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wangka ngaanga maju nyininpa. Martuluya kuliraka junga nyinakuraku. Yilta ngaanga wangka maju nyininpa. Yiipi martulu kulilku junku, palujanu martu kujupakaja-jananya nintijulku, wangka jiinyaya junkuraku, kayilapa mirta Mamamili walyjakajangka kujungka nyinaku. Yiipi martulu ngaanya wangka kulilku, ka jungalu-jananya nintijunku, palujanu Mamamili walyjakajangka kujungka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Martukajaluya wajarni, ‘Muujajmili wangkapurlukakajakamu Parajikajaya junga nyininpa, Muujajmili luwuku.’ Ngayulurna-nyurranya wajani. Palukajangka munkarranyurra jungaminyirri nyinaku luwuku paluku. Palujanunyurra Mamamili walyjakajangka kujungka nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jiijajju-jananya yarrarnu nintilpayi, “Juwukajaya julyju nyinapayi, ka Muujajju-jananya Mamamili luwu wajalpayi. Jilanyakunyurra ninti nyininpa. Muujajjuntaya jilanya wajalpayi, ‘Martu kujupanyurra mirta mitu pungkuraku, paki! Yiipinyurra martu kuju mitu pungku, ka kujupakajalu-nyurranyaya kuutkarti kangku, kaya wajalku, mitu pungkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jiijajju-jananya yarrarnu wajarnu, “Martu kujupanyurra mirta mitu puwa! Jilanya Muujajju-nyurranya wajarnu. Ka ngayulurna-nyurranya wajani wangka kujupa. Martu kujupakunyurra mirta wirrilyi nyinama! Yiipinyurra wirrilyi nyinaku, Mamalu-nyurranya wajalku kurtingku. Yiipi martu kujupalu jilanya wajalku, ‘Nyuntun puta rapiji nyininpa.’ Palujanuyilaya kuutja yikijunku. Yiipi martu kujupalu jilanya wajalku, ‘Nyuntun puta mayunyju.’ Kayilapa Mamalu ngula warukarti wajalku kurtingku. ");
INSERT INTO mpj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Jilanyangkamarraya walyja kujupakajaku yiwilyi nyinama! Yiipin jaaji majungka nyinaku Mamamili mirtayirti yungkukijalu. Mayitpin kuranarriku kulilku, ‘Ngaaju ngayuku walyja, wirrilyi nyininpa, yiwilyiparni.’ ");
INSERT INTO mpj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Palujanun mirtayirti junkuka yanku wajalku yiwilyilu. Yiwilyirrikupulan wangkaku kayilapan marlaku yanku, Mamamili mirtayirti yungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wangka kujupaya kulila! Mayitpi nyunturan yirna kujupaku walyku ngapilku. Palujanunta pulijimanungka juntumanku. Mayitpi pulijimanulunta kuutkarti katijaku, palunyangkamarralu martu palunyangka yarra wangka!, yiwilyirri!, kuutku maajangkanta yikijuljaku, ka payiranta kurtingkujaku jiilkarti. ");
INSERT INTO mpj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Palujanun jiilja wulu nyinamalpa. Ngulan pakalku jampangkun mani payamunku, payinku. ");
INSERT INTO mpj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muujajju-janampa julyju Mamamili luwu wajarnu jilanya, ‘Mirtanyurra martu kujupaku nyupa ngulyulu kanyila!’ Wangka jiikulara ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka wangka kujuparna-nyurranya wajani. Mirtanyurra wanti nyaku ka kulilku ngarriraku. Yiipi nyuntulu kulini wantingka ngarriraku, palujanun nyuntulu walyku ngapirni, jumajin yiltayurulu kanyirninpa.” ");
INSERT INTO mpj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jiijajju-janampa wangka kujupa wajarnu jilanya, “Yiipin kurulu nyaku walyku ngapilkijalu kulini. Jilanya kuliraka ngapilkijalu kurungku jawala warniwa! Jilanyayuru kuliraka ngapila! Kunyjunyun nyuntu nyinaku kuru kujukarti walyku ngapilparni, warukartinta kurtingkujaku, yiipin walyku ngapiljaku. ");
INSERT INTO mpj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yiipin kulini maralu walyku ngapilkijalu. Jilanyalun kulini walyku ngapilkijalu, palujanu marangku putala wirrupuwa! Jilanyayuru kulilaka ngapila! Palunyangkan mara kujukarti kunyjunyu nyinaku, walyku ngapilparni, warukartinta kurtingkujaku, yiipin walyku ngapiljaku.” ");
INSERT INTO mpj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Muujajju-janampa julyju Mamamili luwu wajarnu jilanya, ‘Yiipi martulu kulirni palumili wanti junku yankuraku, mirlimirlira wakalku yungku, mirlimirliwinti yankuraku.’ ");
INSERT INTO mpj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka wangka kujuparna-nyurranya wajarni. Yiipi nyupararrapula nyinani, mirtangku yirnalu nyupa kurtingkuraku, kujupa mankuraku! Jampangku nyupa kurtingku, palunyajanu walyku ngapini. Yiipi wantilu yirna junku yanku ka manku yirna kujupa, palujanunga walyku ngapini. Palujanuyila yirna ngaalu walyku ngapini, jumaji wanti ngaanya manu, yirna kujupangkalu. Yiipi wanti yirna kujupakutulu yanku, palujanun kunyjunyulu kurtingku. ");
INSERT INTO mpj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","36","Jiijajju-janampa wangka kujupa wajarnu, “Muujajju-janampa julyju Mamamili luwu wajarnu jilanya, ‘Yiipin nyuntulu wajalku martungka jilanya, “Mamangka mirangkarnanta wajarni jungalurnangku ngapilku, yiipi pakingkanga Mamalurni pungkujaku.” Palujanu jilanya ngapila jungalu!, mirtan nyuntulu pakiwana wajala!, ngapilkuraku ka yumurrikuka junku.’ Karna-nyurrampa Jiijajju wangka kujupa wajarni. Mirtanyurra wangka palukaja wajalkura, paki. ");
INSERT INTO mpj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jilanyawiyajuya wajala!, ‘Yuwa ngapilkurna.’ Mayitpi kujupakartilkunyurra wangka!, ‘Mirtarna ngapilku.’ Jungaluwiyajuya wajala ngapilkijalu!, mirtanyurra jilanya wajala!, ‘Mamangka mirangkarna jungalu wajarni.’ Jilanyanga mayunyjulu wajani, mirtanyurra jilanya wajala!” ");
INSERT INTO mpj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jiijajju-janampa wangka kujupa wajarnu, “Muujajju-janampa julyju Mamamili luwu wajarnu jilanya, ‘Yiipi yirna kujulunta kuru pungku pampurunku marawintilu, palujanun puntajilu kuru pungku pampurunku marawintilu. Yiipi kujupalunta yirra pungku ka warlangku marawintilu, palujanun puntajilu yirra pungku warlangku marawintilu.’ ");
INSERT INTO mpj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka ngayulurna-nyurranya wajarni wangka kujupa. Yiipi martu kujupalunta putamanku, mirtan marlaku putamala! Yiipi martu kujupalunta ngumpanyu pungku kujukarti, kanta nyurnimanku, palujanu yungkuran kujupakartinta ngumpa pungkuraka nyurnimankurakunta. ");
INSERT INTO mpj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yiipinta martu kujupalu purtu maniku japilku, puntajiluran payamulkuraku, nyuntuluran kuluju marlaku yungku. Palujanu maniparningkanga, yiipinta japilku jaartaku, kayilaparan yungku, jaartakamu kuurtulurrju. ");
INSERT INTO mpj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Yiipinta jantulwintilu wajalku, wartakajaran kangkura ngamu junkura, palujanuran kangku wartakaja wirrirli, palumili ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yiipi martu kujupalunta japilku, manikukamu wartaku, palujanu yuwara! Yiipi martu kujupalunta japilku wartakaja yumulu kanyilkura, palujanu yuwara!, mikuparnilu. ");
INSERT INTO mpj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Julyjuya martukajalu wajalpayi jilanya, ‘Walyjakajaku-janampaya layikamurrira nyinama!, ka karlki kujupaku-janampaya parlanypa nyinama!’ ");
INSERT INTO mpj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Karna-nyurrampa Jiijajju wajarni wangka kujupa jilanya. Yiipi martukaja-ngkuya nyuntuku parlanypa nyininpa, palukajaku-janampa layikamu nyinama! Yiipi karlki kujupaluntaya warrkira ka pungku, palujanunyurra Mama ngarnawarrapurluka japilku kunyjunyu-janampa ngapilkura. Mirta-janampayan parlanypa nyinaku, kunyjunyu-janampayan nyinaku! ");
INSERT INTO mpj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jilanyayurunyurra kunyjunyu martukajaku nyinakura, Mama ngarnawarrapurlukayuru. Mama-lampa wulikajaku layikamurrira nyininpa, walykukajaya ngapini, palukajakulurrju. Wulikajaku-lampa jirntu Mamalu ngapirnu, jirntulu-lanya wakalkuraku. Ka wulikajaku-lampa Mamalu kalyu kurtingkuni, yukurikaja pakalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jiijajju-janampa wajalpayi, “Kulinirna jilanya. Walyjakaja-nyurrampaya layikamurrira nyininpa, palujanu-janampanyurra puntaji layikamurrira nyininpa, walyjakajakuwiyaju. Mirta jilanyaku Mama pukurlarrini, martu wulikajakunyurra pukurlarrira nyinara. Martu walykukajakunyurra parlanypa nyininpa. Jiikajalurrjuya pukurlarrini, palumili walyjakajakuwiyaju, nyunturtinyuru. ");
INSERT INTO mpj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yiipinyurra walyjakajangkawiyaju marlpakajangka wangkamalpa, palunga pakiwananyurra nyininpa. Karlkinparaya Mamaku ngurrpa nyininpa, nyunturtinyuru walyjakajangkawiyajuya wangkaninpa. ");
INSERT INTO mpj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nyunturtinmili Mama ngarnawarrapurluka junga nyininpa, palujanuya nyunturtinpa junga nyinama!” ");
INSERT INTO mpj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jiijajju-jananya yarrarnu nintijunu jilanya, “Mirtanyurra jilanya kulila!, ‘Martu yarnngangka kurungkarna jungalu ngapilku, Mama ngarnawarrapurlukaku, martukajalurniya ngayuwiyaju nyakuraka marninypungkuraku.’ Yiipin jilanya kulilku nyinaku, martukajaluntaya nyuntuwiyaju marninypungkuraku, Mama ngarnawarrapurlukangku mirta pukurlarriku, mirtan palumili walyjakaja nyinaku. Mama ngarnawarrapurlukawiyajuya marninypungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Yiipilunyurra nyarrungka mani yungkuraku, mirtan martukajangka yarnngangka kurungka yuwa!, jiikajaluntaya nyakuraka marninypungkujaku, Mamawiyajuya marninypungkuraku. Palujanura mani kukulu yuwa!, martuluntaya yarnngalu nyakujaku. Karlkin kujupaya pakikajalpa nyinani, mirtaraya Mama ngarnawarrapurlukaku junga nyinani. Palukajaluya martu nyarru ruutungka nyakuni, karaya mani yungkuni martu yarnngangka kurungka. Juwumili jaajingkalurrjuya yungkuni, martu yarnngaluya nyakuni, marninypungkurakuya-jananya. Kuwarri-jananya yilta martukajalu nyakuraka marninypungkuni, ka ngula Mamalu-jananya nyaku junku, mirtaya palumili ngurrangka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yiipin nyuntulu mani nyarrungka yungku, yuwara kukujarrilu!, martu yarnngaluya nyakujaku, nyuntumili marlpalulurrju nyakujaku. ");
INSERT INTO mpj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yiipiran kukujarrilu nyuntulu yungku, palujanuyila Mamalu nyaku, kayilapa pukurlarriku, ngulanta yilta nyuntu marninypungku, palumili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Mirtanyurra Mamangka japila!, pakikajalyurulu. Palukajaluraya Mamangka japini, kujupaluya-jananya nyakura ka marninypungkuraku. Juwumili jaajikajangkaya yikiraka Mama japirni, ruutungkalurrjuya yikiraka Mama japirni, kujupaluya-jananya nyakuraka marninypungkuraku. Kuwarri-jananyaya martukajalu marninypungkuni, ka ngula-jananya kuutja Mamalu mirta marninypungku. ");
INSERT INTO mpj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yiipinyurra Mama ngarnawarrapurluka japilkuraku ngurrangka, kurruwa!, yinjayiti tuwu jatamapula!, kara japila!, martu kujupalunta nyakujaku. Mirtala nyakuninpa Mama, palunyaluwiyajunta nyuntu nyakuraka kulilku, ka kunyjunyungku ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jiijajju-jananya yarrarnu nintilpayi, “Yiipinyurra Mamangka japilku, mirtarayan wangka kuju wululu wajanmalpa, ngakumpayurulu. Juwuparnikajaluya Mamaku ngurrpakajaluya jilanyalu wululu japini, ngakumpayurulu. Jiikajaluya Mamayuru kujupa marninypungkuni. Kuliniya jilanya, ‘Mamalu-lanya kulilku, yiipila rawalu japilku.’ ");
INSERT INTO mpj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mirtayan jilanya kulila!, Mamaku ngurrpakajayurulu. Mamalu kulini, nyuntuluran kuranju kulini palu japilkuraku. Palujanu palupalajira ninti nyininpa, nyuntulun marlalu japirni. ");
INSERT INTO mpj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Palujanuraya jilanyalu Mama ngarnawarrapurluka japila! ‘Mama! Nyuntungan ngurra ngarnawarrapurluka, yilta Mama-lampajun nyininpa. Nintijula-lanyaju!, nyuntulajunta marninypungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngampurrju-lanyaju kanyinma!, nyuntumili walyjakaja. Maaja majulu-lanyaju nyuntulu nintijula!, junga-lajungku nyinaraku. Mamamili wikarrukajaya junga nyininpa nyuntuku, palunyayuru-lajungku junga nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yuwa-lanyaju mirrka!, ngalkuralaju karrpuparaku karrpungka. ");
INSERT INTO mpj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jamparni martu kujupalu putamalku, mirtarna puntajilu putamalku, yankurnalu wangkaku kawalyaliju nyinakuraku. Jilanyarnalu wangkaku, ka palujanu ngayulurnanta japini, walykukajaju warniwa! ");
INSERT INTO mpj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jampa-lanyaju muunpungku malpulu, mirtalaju kulilkuka ngapilku, paki. Ngampurrju-lanyaju kanyinma!, malpulu-lanyaju kujupawana kangkujaku. Yiltan nyuntu maaja majuwarta-lampajun, wulikajaku. Nyuntun kunyjunyu, maparn majuwinti nyininpa. Wulun jilanya nyuntu nyinamalpa. Amin.’ ");
INSERT INTO mpj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yiipi martu kujupalunta putamanku, mirtan puntajilu putamala!, kawalyaran nyinaku, palujanu Mama ngarnawarrapurlukalungku walykukaja warningku. ");
INSERT INTO mpj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yiipi martu kujupalunta putamanku, ka nyuntulun puntajilu putamalku, yiipiran mirta kawalya nyinaku, palujanunta Mama ngarnawarrapurlukalu mirta walykukaja warningku, nyuntumili, paki. ");
INSERT INTO mpj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Yiipin nyuntulun kulirnin mayi junkuka Mamaran japilku, pukurlju nyinara Mamara japila!, mirtan kujilpa nyinama!, karlki kujupayuru. Jiikajaya parra yaninpa kujilpa, mirta-ngkuya kata kuumurninpa, ngumpalurrju mirta waajamuninpa. Kulirninpaya jilanya, ‘Martukajalurniya kujilpa nyakuka marninypungku, “Jii Mamamili walyja kunyjunyu parra yaninpa, mayiparnilu Mamawiyaju japirninpa.” ’ Mirta jilanyayurunyurra kulira nyina! Jiikaja-jananyaya martukajaluwiyaju marninypunginpa, mirta Mamalu-jananya ngula marninypungku. ");
INSERT INTO mpj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yiipin nyuntulun kulirnin mayi junkuka Mamaran japilku, jilanya pukurlpa nyina! Kata kuumulangku ngumpalurrju waajamula!, ka pukurlpa parra yarra!, ");
INSERT INTO mpj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","martukajaluntaya nyakuka kulilku, mirtan nyuntulu Mama marninypunginpa, mayiparnilu. Jilanyalun nyuntulu Mama marninypungku mayiparnilu, Mamaluwiyajungku nintilu kulilku. Ngulanta puntajilu Mamalu marninypungku.” ");
INSERT INTO mpj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jiijajju-jananya yarrarnu nintijunkupayi, “Mirtanyurra kulinma!, warta maju mankuraku, mirtanyurra jilanyalu maju mankura kanyilku. Yiipi jilanyanyurra kanyilku, ngulyuya-nyurrampa mankumalpa, ka pingakajaluya ngalkunirra. ");
INSERT INTO mpj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Jilanyaya kulinma!, Mamamili warrkamuwiyaju! Mamakuranyurra junga nyinaku, kanyurra Mamakuwiyaju warrkamu ngapilmalpa, palujanu-nyurranya wartakajayuru kunyjunyuminyirri yungku, ka-nyurranya wanka kanyilku, palumili ngurrangka. Mirta-nyurrampaya ngulyulu ngurra jiingka manku, paki, ka pingakajaluya mirta palukaja ngalkunirra, paki. ");
INSERT INTO mpj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yiipiranyurra kulilku junga nyinakura Mamaku, palunyajanunyurra pukurlpa nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yiipinyurra kulilku walykukaja ngapilkura, walykunyurra nyinaku, Mamakuranyurra ngurrpa. ");
INSERT INTO mpj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Warrkamupurluka maaja kujukuwiyaju nyinaku, mirta kujarraku. Maaja kujarralurapula wajalku kujuku warrkamupurlukaku ‘Ngaa ngapila!’, kayilapara maaja kujupalu wajalku, ‘Nyarra ngapila!’ Jii kujulu warrkamupurlukalura purtu kulilku. Warrkamupurluka jii kunyjunyura maaja kujuku nyinaku junga, kara parlanypa kujupaku nyinaku. Jilanyayurunyurra nyinaku, mirta Mamakukamu wartakajaku, manikulurrju, kujuwiyajunyurra Mama wanalkuka jungaranyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Jilanyalunyurra mirta wartakamu mani wurrkulinma! Mirtaranyurra mirrkakukamu kalyuku wurrkulinma!, kulujkulurrju. Mamalu-nyurranya ngampurrju kanyirnin, wankanyurra nyininpa, pukurlpaya nyinama!, mirtanyurra wurrkulinma!, manikamu mirrkalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kulilaya-jananya turrukaja!, pukurlpaya parra yaninpa, mirtaya kulirnin wilykikajaya parnangka tuunyjunkura yukuri pakalkuraku. Mirtaya mirrka wumura katira juninpa mayangka ngulampaku-ngkuya. Mamalu-jananya ngampurrju yunginpa, ngalkurninpaya. Palunyayuru Mamalu-nyurranya kulirnin mirrkakamu kalyu kulujulurrju manilurrju ngampurrju yunginpa. ");
INSERT INTO mpj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Martu kujulu yatunalu wululu purtu kulini, palu warlpukurru nyinaraku, palujanu mirta warlpukurru nyinaku. Mamaluwiyaju-langku junkuni, warlpukurrukamu yatunala nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Purtipulawukajaya kulila! Mirtaya martuyurulu kulujkaja ngapirninpa, kunyjunyuya ngarinpa kuluj nyuwankurluyuru. Mirtaranyurra kulujku kulinma! ");
INSERT INTO mpj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Julyju maaja maju Jalamunpa mani majuwintikamu kuluj majuwinti nyinapayi. Kuluj nyuwankajawinti wulu nyinapayi. Purtipulawukajaya Jalamanja munkarra ngarin, kuluj nyuwanwintiyuru. ");
INSERT INTO mpj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","31","Purtipulawukamupula yukuri rawaparni yikira tikirlarrinpa, jii-pulanya Mamalu ngampurrju kanyirninpa. Palunyayuru-nyurranya kulira ngampurrju kanyirni. Mirtanyurra ngunjularriraka nyina, kulujukajakukamu mirrkaku, paki, Mama ngarnawarrapurlukawiyajuya kulinma!, paluluntaya ngampurrju kanyini. ");
INSERT INTO mpj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","“Mamaku ngurrpakajaya jilanyanga ngunjularrinpa. Mamalu-nyurranya kuliraka yunginpa. ");
INSERT INTO mpj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kujupawanaya kulira nyinama!, Mamakuranyurra junga nyinaraku. Jilanyaya kulinma!, ‘Mamalu-langku walyjakaja ngampurrju kanyirnin.’ Yiipi jilanyaranyurra junga nyinaku, Mamalu-nyurranya kulilkuka yungku. ");
INSERT INTO mpj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Karlkinjuya jilanya kulirninpa, ‘Jampa yungun pakalku, mayitiju mirrka ngarriku, mayiti paki. Mayiti mirrkaparnirna nyinaku, mayitirna ngarntarriku.’ Kuwarrila mirta jilanya kulinma!, pukurlpawiyajula nyinaku. Mamalu-lampa kulirninpa yungunpa wanyjalmankura. ");
INSERT INTO mpj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Jiijajju-janampa wituka nintijunkupayi, “Mirta martu kujupanyurra minyjiljunama!, kintilulunyurra kulinmalpa, Mamalu-nyurranya ngulampa warrkira kurtingkujaku. Yiipilunyurra martu kujupangka kintilu kulilku, minyjiljunkuparnilu, Mamalu-nyurranya ngula kintilu kulilku warrkira kurtingkuparnilu. ");
INSERT INTO mpj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Karlkilunyurra walyjalu walyku ngapirnuka jilanya wajalku, ‘Martu jiilu walyku ngapirnu, puta nyininpa.’ Mirtanyurra jilanya mayunyjuyurulu pinyijunkura. Nyuntulungkura japila Mama!, walykungkura wirrupungkura, mirtan kujupa kulilkuka pinyijunku. Mamaluwiyajura kulilku. ");
INSERT INTO mpj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mamamili parlanykajangka-jananyanyurra mirta Mamamili wangka jakurljula!, mayiti-nyurranyaya wirrilyirriraka pungkujaku.” ");
INSERT INTO mpj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jiijajju-jananya wituka nintijunkupayi, “Mamaranyurra wululu japinma!, yungkuyila-nyurranya. ");
INSERT INTO mpj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mama yiniwanaluranyurra japilmalpa, Mamalu-nyurranya kunyjunyulu yungku. ");
INSERT INTO mpj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kajalura japirninpa mama walyja mayiku, palunyangkara mama walyjalunga yunginpa. Mayi kanyiraka mirtara yapu mankula yunginpa, mayiwiyajura yunginpa. ");
INSERT INTO mpj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mamalu kuka piij kanyinyjanju, jampara palumili kajalu japilku kuka piijku, mirtara manku jila wanka yungku, piijpara yungku. ");
INSERT INTO mpj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Karlkinyurra walyku nyininpa, kuliraka-jananyanyurra nyuntumili jijikajanga jungalu mankula yunginpa. Ka Mama ngarnawarrapurluka ngaa kunyjunyu nyinani, paluluntaya jijikajayuru jungaminyirrilu yunginpa, jamparanyurra japirnin. ");
INSERT INTO mpj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mayitinyurra karlkilu kulirninpa, ‘Martu jiiluju putamanu, jungaluju ngapilngara.’ Yiipin kulini kujupalunta jungalu ngapilkura, ka martu karlkinku-janampan jungalu ngapilku. Jilanya nyininpa Muujajmili luwukamu Mamamili jakurlpurlukakajaku-janampa. ");
INSERT INTO mpj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jiijajju-jananya wituka nintijunkupayi, “Ruutu jukujukuwanaya yarra!, kiitu wujuwananyurra jarrpaku, wankanyurra wulu nyinaraku. Mirtanyurra yarra ruutu majuwana kiitu majukarti!, maanyurra warungka jarrpajaku. Ruutu jiiwana majuwananga kunyjunyu, mirta purliwana ngarrinpa, martu yarnngaya jiiwananga yaninpa. ");
INSERT INTO mpj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kiitu wujuminyirri jiinga, ruutu jukujuku maa ngarrinpa purliwana, kiitu wujukarti. Martu kujunkujunpaya jiiwananga yaninpa, wanka wulu nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mamamili jakurlpurlukayuru-nyurranyaya karlki kujupa yankurni, mayunyjukaja. Jiikaja-nyurranyaya yankurni jiipu kuwayitpalayuru. Mirtaya yilta jiipu kuwayitpalayuru, paki, jarntu jikipalayuru-nyurranyaya yankuni, mayunyjukaja. ");
INSERT INTO mpj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jiikaja-jananyanyurra nyaku yiltaluya walykukaja ngapinmalpa, ka palujanu kulilkunyurra, ‘Yiltaya mayunyjukaja.’ Warta karlkinpa mayikurluyuru ngarinpa, yumu mayiparni, jilanyayuruya mayunyjukaja nyinaku. Warta karlkinpa mayikurluya kunyjunyu ngarinpa, mirta mayunyjukajayuruya jiikaja nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Warta karlkinpaya wiltu ngarinpa, mayi majuwinti, kaya warta karlkinpa tikirlpa ngarin, mayi putakurlu. Warta tikirlyuruya mayunyjukaja nyinaku. Warta tikirlkajangka mirta mayi kunyjunyu pakalku. ");
INSERT INTO mpj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaatanmayapurlukalu warta tikirlkajanga putalku warungka wirrupungku. ");
INSERT INTO mpj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jiikaja-jananyanyurra nyaku yiltaluya walykukaja ngapinmalpa, ka palujanu kulilkunyurra, ‘Yiltaya mayunyjukaja.’” ");
INSERT INTO mpj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jiijajju-jananya yarrarnu nintijulpayi, “Martu karlkinjurniya marninypunginpa jilanyarniya wajarnin, ‘Maaja-lampajun nyininpa.’ Palujanuluya yankula walyku ngapirninpa. Mirta-jananya walyjakaja Mamalu ngampurrju kanyinmalpa. Karlki kujupawiyaju-jananya ngampurrju kanyilku, Mamamili wangkaya kulilkukaraya junga nyinaku, kaya-janampa karlki kujupaku kunyjunyu ngapilku. ");
INSERT INTO mpj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngularniya kuutja karlkilu wajalku, ‘Maaja! Nyuntumili wangka-lajungku parra wajalpayi. Malpukajalaju-jananya wajara kurtingkupayi nyuntumili maparnwintilu. Yalyjirrjulaju-jananya kujupa kujupa ngapilpayi.’ ");
INSERT INTO mpj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Karna-janampa wajalku, ‘Ngurrparna-nyurrampa mirtajunyurra ngayumili walyjakaja. Walykukajaya maa yarra!’ ");
INSERT INTO mpj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Jampa ngayumili wangka kulilkuka yirninyju nyinaku, martu jii Jiijajmili, martu kujupayuru warrkamupurluka ngaayuru nintiyuru nyinaku. Warrkamu jiilu nintilu maya junga ngarajunku yapu majungka pulatwanja. ");
INSERT INTO mpj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Palujanu kalyu maju punkalku, ka kalyu karrujanu ngarnawarrarriku mayakarti. Ka wangalju purtu maya yurripilyalku, wulu wiltu ngaramalpa, jumaji yapu majungka ngarinpa. ");
INSERT INTO mpj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Warrkamupurluka kujupalu ngurrpalu maya ngarajunku parnangka karrungka yitingka. ");
INSERT INTO mpj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Palujanu kalyu maju punkalku, ka kalyu karrujanu ngarnawarrarriku mayakarti. Ka wangalju jii mayanga yungkalku punkajingalku. Punkalku wiyarriku. Warrkamukura ngurrpa jiinga nyinaku. Warrkamu jiiyuru, ngurrpayuru kujupa nyininpa ngayumili wangka kulilkuka junku yanku, ngurrpaju nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jiijajju-jananya wangka palukaja wajarnu, kaya martukaja kulirnuka kuru pakarnu, “Yiltalu-langku junga wajarnin, murlpirrju.” ");
INSERT INTO mpj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jiijajju-jananya yiltalu murlpirrju wajalpayi, mirta kujupakajayuru. Jiikajaluya-jananya Muujajmili wangkapurlukakajalu murlpirrparnilu nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jiijajpa tiputingu yapujanu, ka yanu, martu yarnngaluluya wanalpayi. ");
INSERT INTO mpj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jiingkalu yirna yanu kujungkarringu ngarnta lipurijikurlu. Kalu pupatingu murti jurrpujurrpu, kara japirnu Jiijajpa, “Maaja! Nyuntungan maparn maju, kajirnin kunyjunyunku?” ");
INSERT INTO mpj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ka maralu pampurnu kara wajarnu, “Yuu! Kunyjunyurri!” Palunyangkayila kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jiijajjura marrkurnu, “Mirtan-jananya martukajangka yanku wajalku, yankulun yatilykarti, jaaji majukarti. Yatilyjalun nintijulku karan wajalku kunyjunyurringun. Karan mirtayirti manku yungku yatilyku, kayila martukajaluntaya nyakuka kulilku, ‘Ngaa martu kunyjunyurringu.’ Jilanya-lampa wajarnu Muujajju.” ");
INSERT INTO mpj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka palujanu Jiijajpanga yanu tawun Kapaniyamukarti. Kara Jiijajpa japirnu jantulwintikajaku maajalu, Juwuparnilu, ");
INSERT INTO mpj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ngayumili warrkamupurluka ngarnta maju ngarrinpa mayangka, parralayijirringu.” ");
INSERT INTO mpj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","8","Kara Jiijajju wajarnu, “Nyuntumili ngurrakartirna yanku, ka kunyjunyunku.” Kara marrkurnu, “Paki! Nyuntun maaja maju, ngaanguruwiyajura wajala!, kayila ngayumili warrkamupurluka kunyjunyurriku. ");
INSERT INTO mpj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngayumili maaja majukajalurniya wajarni, palunyangkarna ngapirni. Ngayululurrjurna-jananya maajalu wajarni ngayumilikaja, palunyangkayilaya ngapirni. Kujukurnara wajalku, ‘Maa yarra jiikarti!’, palunyangka maa yanku. Jamparnara kujupaku wajalku, ‘Yarrarni!’, palunyangkarni yankurni. Kujupakurnara warrkamupurlukaku wajalku, ‘Jilanya ngapila!’, palunyangka ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wangka jilanya Jiijajju kulirnuka kuru pakarnu, ka-janampa wajarnu, palumilikajaku, “Yilta ngaalurni kulirninpa maparn maju. Yijurilmili marlajanukajangka mirtarna ngaayuru nyanguka kulirnu. ");
INSERT INTO mpj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mamalu-jananya ngampurrju kanyilmalpa palumili walyjakaja yarnnga, Yipuramkamu Yajikpa, Jayikaplurrju. Mamalu-jananya kujungka ngampurrju kanyilku, Juwuparnikaja yarnnga ngurra kakarrajanu, ngurra yapurrajanu. ");
INSERT INTO mpj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ka-jananya Juwukaja Mamalu ngumpalku wiyalku, kujungkaya-jananya nyinajaku, warungkaya nyinamalpa, wilyjiwilyjirriraya wulu yulamalpa. Jiikaja-jananya Mamalu julyju kulilpayi ngampurrju-jananya kanyilkura, palunyangkamarraya junu yanu.” ");
INSERT INTO mpj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jiijajjura maaja palukura wajarnu, “Ngurrakarti yarra! Nyuntulurnin kulirni, kayila kunyjunyurriku.” Palunya tayimu maajakura warrkamupurluka yilta kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Palujanu Jiijajpa yanu Piijamili ngurrakarti, kayila nyangu Piijakura yumari, ngarnta ngarripayi, parltiparlti, piitingka. ");
INSERT INTO mpj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Maralu pampurnu, kayila kunyjunyurringu. Ka pakarnuka mayira manu yungu. ");
INSERT INTO mpj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jampa jirntu jarrpakijalu martukajaluya-jananya katingurni malpuwintikajakamu ngarntakaja, Jiijajkutu. Jiijajju-janampalura malpukaja ngumpara kurtingkupayi, ka-jananya ngarntawintikaja kunyjunyunkupayi. ");
INSERT INTO mpj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jilanyalu Mamamili wangka yiltarringu. Julyju Mamamili jakurlpurlukalu wakarnu Yayijayalu, “Martu jiilu-jananya kunyjunyunkuka malpu-janampalura payilku kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kangku Jiijajju kulirnu, “Marturniya yarnngarringuka ngarinpa.” Ka-janampa palumili wangka-nintikajaku wajarnu, “Puutungkala tatilku yanku, parna kujupakarti.” ");
INSERT INTO mpj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muujajmili wangkapurluka yanura japirnu, “Ngayulurnanta kulirninpa marlpayirrali kujungka yankura, wulu.” ");
INSERT INTO mpj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jiijajjura wajarnu, “Walytakikajaya pirti walyjangka nyinin. Turrukajaya warta walyjangka nyinin. Ngayurna martu yarnngakurna-janampa marlpa, mirtarna ngurra walyja kanyirnin, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kara martu kujupalu wajarnu, Jiijajmili walyjalu, “Maaja! Ngayurna ngurra walyjakarti yanku, karna ngayumili mama kanyilku tuunyjunku, karnanta marlakurriku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jiijajjura wajarnu, “Kuwarrirnin kujungkarriku yanku. Ngula nyuntumili mama miturrinyjangka, kujupakajaluya tuunyjunku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiijajkamu palumili wangka-nintikajaya puutungka tatirnu yanu. ");
INSERT INTO mpj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Palunyangka-jananya wangaljukamu kalyulu pakarnu pungkupayi, puutpa jarrpajunkungara, jampa Jiijajpa puutungka kunyalarripayi. ");
INSERT INTO mpj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ngurlurringukaya yanu Jiijajpa kanarnu, karaya wajarnu, “Maaja pakala! Wankala-lanyaju, miturrijakula!” ");
INSERT INTO mpj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jiijajju-janampa wajarnu, “Mirtanyurra ngurlurriwa!, ngangkularniya ngayurna maparn maju!” Ka pakarnu ngaranguka marrkurnu, kayila wangalpanga yatarnarringu, kayila kalyunga marlaku jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka-ngkuya wajalpayi, “Ngana ngaa martu? Wangaljukamu kalyulu kulirninpa. Ngaanya maparn majuminyirri.” ");
INSERT INTO mpj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yanuya parnangka warinykatingu ngurra Katarangka, puutjanuya tiputingu. Palunyangkapula pirnkijanu martu kujarra-jananyapula yanu kujungkarringu. Palunya kujarrangapula mitumili pirnkingka nyinama, ngunu mitukurnupula kanyilpayi, jikipala kujarra, martu pungkupayi. Mirtaya martukaja yankupayi jiiwana ruutuwana, jumaji palu kujarrangkamarra. ");
INSERT INTO mpj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kujungkarringu-jananyapula kayilapula wiltu mirrangu, “Mamamili kaja! Nganakun yanurni? Kulirninpaliju ngulampa-linyaju Mama ngarnawarrapurlukalu payilku kurtingku. Mayitpi-limpajun kuwarri yanurni ngumpara-linyaju kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nguurrnguurrkajaluya jiiwananga ngalkula parra ngarapayi. Kaya ngunukaja-pulanyaya nyinapayi, martu jii kujarrangka. ");
INSERT INTO mpj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Karaya ngunukajalu Jiijajkuraya wajarnu, “Nyuntulun kulirninpa ngayunpa-lanyaju ngumpara yiyalkuraku. Yiyala-lanyaju nguurrnguurrkajakarti!, jiikajangkalaju-jananya nyinaraku.” ");
INSERT INTO mpj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jiijajju-janampa wajarnu, “Pakalaya-jananya yarra!, nguurrnguurrkajakarti.” Kaya-jananya yanu nguurrnguurrkajangka jarrpangu nyinapayi. Palunyangkaya nguurrnguurrkajaya yapu yirrirriwana yanuka kalyungka jarrpangu miturringu, wulikaja. Palunyangkapula ngunuwinti kujarranga pipurru kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Martulu-jananyaya ngampurrju nguurrnguurrkaja kanyilpayi, nyangu-jananyaya kalyungka jarrpanguya miturringu. Palunyangka-jananyaya yanu tawunwana parra jakurljunkupayi, “Nguurrnguurrkaja-lampajuya miturringu, kapula martu kujarra ngunuwinti kujarranga kunyjunyurringu.” ");
INSERT INTO mpj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Palunyangkaya martukaja tawunjanu yanurni Jiijajpaya nyakuraku. Maparn majuwintiya kulirnukaluraya ngurlurringu, karaya wajarnu, “Yarra-lampajura ngurra kujupakarti!” ");
INSERT INTO mpj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiijajmapuya tatirnu puutungka, kaya marlaku yanu kalyuwana, Jiijajmili tawunkarti. ");
INSERT INTO mpj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Puutjanuya tiputingu parnangka ngarapayi. Kaya martukajalu katinguluya ngarnta parralayiji Jiijajkarti, piitingka. Jiijajju-jananya kulirnu, “Yilta martu ngaakajalurniya kulirnin, ngayurna maparn majuwinti.” Kara Jiijajju wajarnu ngarntapurlukaku, “Pukurlarri! Ngayulurnangkura walykukaja wirrupungin.” ");
INSERT INTO mpj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jiingkaya ngarapayi Muujajmili wangkapurlukakaja, ka-ngkuya wajarnu, “Mama ngarnawarrapurlukaluwiyaju walykukaja wirrupunginpa, mirta ngaalu, martulu.” ");
INSERT INTO mpj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jiijajju-jananya ngarala kulilpayi, ka-janampa wajarnu, “Nganakurninyurra jankanin? ");
INSERT INTO mpj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wangka ngaaya kulila! Ngayulurna wajarnu walykukajarnangkura wirrupungu. Palujanu mayitpinyurra kulirni, mayitpirnalura wirrupungu, mayitpi paki. Yiipirna wangka kujupa jilanya wajalku, ‘Pakala kunyjunyurrira yarra!’ Jampa mirta pakalku, palunyangkarninyurra kulilku, mayunyju. Wangka jiirnara wajalku ngayurna mayunyjuparni kulilkuranyurra. ");
INSERT INTO mpj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngayurninyurra kulilkura, Mamamili maparnwintilurna walykukaja wirrupunginpa. Ngayurna martu yarnngakurna-janampa marlpa.” Kara ngarntapurlukaku wajarnu, Jiijajju, “Pakala! Piitingku marraka yarra ngurrakarti!” ");
INSERT INTO mpj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ka yiltangulyu pakarnuka piitingku rulumapirnuka pakarnu yanu ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Martukajaluya nyanguka ngurlurringu, kuwarriwiyajuya nyangu maparn majuwintilu ngapini, palujanuya Mama ngarnawarrapurluka marninypungkupayi, “Yilta ngaanya nyuntumili maparnwinti nyininpa, walykukaja wirrupunginpa.” ");
INSERT INTO mpj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Palujanu Jiijajju ngurra jii junu yanu, ka nyangu martu kujupa yini Maajurru, yupujingka nyinapayi, mani kapamanku-janampa mankupayi. Kara Maajurruku wajarnu, “Pakala!, kujungkali yankura!” Warrkamu junu yanu, kalu pakarnu wanarnu. ");
INSERT INTO mpj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Palujanuya Jiijajmapuya yanu Maajurrumili mayakarti, kaya ngalkupayi. Kujupakajaya-jananya warinykatingu kujungkarringu nyinangu. Karlkiluya kapamanku mani mankupayi, karlki kujupaya Juwumili luwukuraya parlanypa nyinapayi. Jiikajaluya kujungka Jiijajja ngalkupayi. ");
INSERT INTO mpj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Maya jiingkaya Parajikaja nyinapayi. Palukajaraya Jiijajku wirrilyirringu, jumaji-jananya Jiijajpa nyinapayi, Mamaku ngurrpakajangka. Jiikajaluya-jananya Jiijajmili wangka-nintikaja japirnu, “Nganaku-jananya Jiijajju nintipurlukalu kujungkalu ngalkurninpa, putakajangka?” ");
INSERT INTO mpj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Jiijajjunga-jananya kulirnu kujupawana wangkangu jilanya Muujajmili wangkapurlukakajaluya kulilkura, “Mirta maparnju martu ngarntaparni pampuni, paki, ngarntakurluwiyaju pampuni. Pakiwananyurra kulirninpa. Ngayurna jiiyuru maparnwinti yankupayi, martu putakaja nintijunkuraku, mirtarna-janampa ngayu yanurni martu kunyjunyukajawiyaju nintijulkuraku, paki. Yuu, yanurnirna Mamaku ngurrpakajarna-jananya nintijunkuraku.” Jiijajju-janampa yarrarnu wajanu, “Martukajalunyurra kintilu kulila!, ngaa Mamamili wangka, julyju jilanya wakarnu, ‘Mamarnara layikamurrinpa, martu karlkiku-janampanyurra junga nyinara. Layikamurrira-ngkuya nyina!, mirtarninyurra mirtayirtiwiyaju kangku yungkura, ka pakiwana nyinara, paki.’ Kujupakajaku-janampanyurra layikamurrira nyina!” ");
INSERT INTO mpj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Palujanuya yanu Jiijajkarti japilkuraku, Jaanmili wangkapurlukakaja. Jaanju-jananya jiilu julyju martukaja kalyungka jarrpajunkupayi. Palumilikajaluraya Jiijajpa japirnu, “Nganakuya nyuntumili wangka-nintikajaluya ngalkurninpa mirrka? Nyinangaraluraya kaya marninypungkungaraya, Mama ngarnawarrapurlukawiyaju, ngalkuparnilu. Parajikajalukamu ngayunjula Jaanmili wangkapurlukalu Mamawiyaju marninypunginpa, mirtala ngalkurnin, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jiijajju-janampa wajarnu wangka yumuwanpa kulilkurakuya, “Nyupararralupula marrirtikijalu kujungkarrinila mirrka ngalkuraku, ka turlku yinkaraku, pukurlju. Kunyjunyuya-pulampa jilanya pukurlju ngalku, kuwarripa marrirtirrikija yirna palu. Ngulangaya yirna palunyanga ngaluraya katiku, palunyangkaya palumili walyjakaja nyinaku mirrkaparni, Mamaya japilkura.” Jiijajju-janampa jilanya yumulu wajarnu kurranyilu. “Yirna palunya marrirtingayuru, kayilarniya ngalulku katiku. Palunyangkajunyurra mirrkaparni nyinaku Mama ngarnawarrapurlukawiyaju japira nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jiijajju-janampa wangka yumuwanpa wajarnu, “Jaartakamu jawuja jampapula wuurlpalarriku palunyangapula yaarryanku. Mirtanyurra kujupajanu nyuwanjanu yaarrpungkula junku wuurlpalangka niitulkurlulu wakalku, paki, yitiwana, wulungulyungku jiinga yaarryankumalpa niituljanuwana. Jiingkamarranyurra kujupajanu mirta manku wuurlpalangka junku miintamulku, paki, junkunyurra.” ");
INSERT INTO mpj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","(Juwukajaluya paatuljarramunungka karrkarta kanyilpayi nyurungka.) Wangka yumuwanpa kujupawana-jananya wajarnu, Jiijajju, “Kuripijjanungka nyupirala karrkarta yintini. Jiipukurnungkala nyurungka karrpira jatamapura, yintira kanyini. Mirtala yintira wuulpalangka nyurungka kanyini, paki, palunyanga taalpalku. Nyuru nyuwanangkawiyaju yintirala karrkarta kanyini, taalpalparningka. Palya palunga karrkartanga. Nyuru nyuwanpanga palya nyinaku.” Wangka jiinya-jananya Jiijajju wajarnu, jilanyaya kulilkura, nyuru wuulpalayuru Muujajmili wangka nyinani, ka nyuru nyuwanyuru Jiijajmili wangka nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wangka palu-janampa wajalpayi, ka Juwumili maajalu yanurni japilkura. Parnangkalu pupatingu murti jurrpujurrpu, kara Jiijajpa japirnu, “Pinyirringurna kuwarri yurntalja. Kujungkali yarra!, ngayumili ngurrakarti, pampulkun wankamanku.” ");
INSERT INTO mpj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jiijajpa pakarnu kapula kujungka yanu, palumili wangka-nintikajalurrju, martu kujupakajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Martu jiikajangka-jananya yankupayi wanti ngarnta. Palunga ngarnta nyukurnijanu nyinapayi purtuya wankara junkupayi, maparnkajalu. Julyju-janampa luwu jilanya nyinapayi, wanti jiiyuruluya rawa wulu ngarnta nyinapayi, paluyuruluya mirta martu kujupa pampulkura kulujukurlu, paki. Kulirnungku wanti palunyalu, “Yiipi Jiijajmilirnara kuurtu pampulku palyarrikuyilarna.” Marlawanajanulu yanurnika pampurnu. ");
INSERT INTO mpj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jiijajju pijurringuka nyanguka wajarnu, “Wanti, murlpirrarri! Nyuntulurnin maparn maju kulirninpa, palunyangkan kunyjunyurringu.” Palunyangkayila yilta kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Palunyangkaya yanu maaja palumilingka Jiijajpa kurrungu. Jarrpanguya-jananya nyangu, martu yarnnga yulapayi, karlki kujupaluya nyuwijiki ngarlpuyungkupayi, kujilju. ");
INSERT INTO mpj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jiijajju-janampa wiltulu wajarnu, “Yarraya yawujayiti! Ngaa kuyurnpa kunyala ngarrin.” Nyurniraya yikarrirringu. ");
INSERT INTO mpj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yanuya yawujayiti ngarapayi, kalu Jiijajpa yanu wantikarti ka mara ngalurnu, kayila kanarringuka walyja pakarnu. ");
INSERT INTO mpj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Martukajaluya nyangu kunyjunyurringu, kayilaya yanu tawun kujupawana tawun kujupawana parra wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tawunpa jiinya Jiijajpa junu yanu. Pampuru kujarralupula Jiijajpa kulirnukalupula wanalpayi. Jiijajkurapula wiltulu wajarnu jilanya, “Nyarrurri-limpaju!, nyuntu Tayipitmili walyja marlajanu.” ");
INSERT INTO mpj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jiijajpa yanu maya kujupangka kurrungu. Wanarnulupula jiingka mayangka jarrpangu. Jiijajju-pulanya japirnu, “Kulirninpanpula?, ngayulurnantapula maparn majulu kunyjunyunku?” Wajarnurapula, “Yuu! Maaja!” ");
INSERT INTO mpj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka Jiijajju-pulanya kuru pampurnuka wajarnu-pulampa, “Ngayurninpula yiltalu kulirni, palunyangkarnangkupula ngayulu wajarnin, ‘Kunyjunyurripula!’” ");
INSERT INTO mpj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Palunyangkapula pipurru kuru kunyjunyurringu. Ka-pulanya Jiijajju marrkurnu, “Mirtan-jananyapula jakurljunama!, yakapula nyinama!” ");
INSERT INTO mpj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kulirnupula junu Jiijajmili wangka yanu-jananyapula parra jakurljunkupayi, tawun kujupawana tawun kujupawana. ");
INSERT INTO mpj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Palujanu karlki kujupaluya martu wangkaparni katingu Jiijajkarti, martu jiinga malpuwinti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jiijajjulura malpunga wajarnu kurtingu, kayila kunyjunyurringuka wangkapayi. Martukajaluya nyanguka kuru pakarnu. Ka-ngkuya wajalpayi, “Kuwarriwiyajulaju nyangu maparn majulu kunyjunyunkunyja, Yijurilmili marlajanukajalu.” ");
INSERT INTO mpj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Karlkilu-ngkuya Parajikajalu pakiwana wajarnu, “Malpuku maajamili maparnwintilu-jananya malpukaja payira kurtingkuni.” ");
INSERT INTO mpj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiijajpa parra yankupayi tawun kujupawana tawun kujupawana, parra-jananya martukaja nintilpayi, tawunja yitiwanalurrju. Juwumili jaajikajangka-jananya tawun parlparriwana parra nintilpayi. Martukajaku-janampa jilanya wajalpayi, “Wangka kunyjunyuya kulila! Mamalu-nyurranya palumili walyjakaja ngampurrju kanyilku.” Ngarntakaja-jananya kujupa kujupa kunyjunyunkupayi. ");
INSERT INTO mpj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jiijajju-jananya martu laltu nyakupayi, ka-janampa nyarrurripayi, jilanya kulilpayi, “Nyarruya nyininpa, mirta maajalu-jananya ngampurrju kanyirninpa, jiipukajayuruya maajaparni.” ");
INSERT INTO mpj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Jilanya kulirnuka-janampa wajarnu palumili wangka-nintikajaku, “Martuya laltu nyininpa, Mamamili wangkaya kulilkuraku, kaya nintipurluka kujunkujunwiyajuya nyininpa. Mamaya japila!, nintipurluka laltu kujupa-jananya nintijulkuraku, jiikajaluya-jananya yankula parra wajalkuraku. Martu laltu jiikaja nyinara warningkuni wiiti laltuyuru, warrkamupurlukalu kujunkujunjuraya purtu kulirninpa yankuraya wiitikaja parlparri ngaranyjanpa katupungkura mankuran. Wiitiku maajaya japilku jiilu-janampa wajalku laltu kujupaku, yankuraya wiitikaja katupungkura mankura.” ");
INSERT INTO mpj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiijajju-jananya palumili wangka-nintikaja mirrangu kujungkarnu, ka-janampa jilanya wajarnu, “Kuwarrirna-nyurranya Mamamili maparnpa yungku ngarntakaja-jananyanyurra kunyjunyunkuranku, ka malpu-janampaluranyurra payira kurtingkuran.” ");
INSERT INTO mpj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Jilanyaya nyinapayi palumili wangka-nintikaja, palumili jakurlpurlukakaja. Jii tuwal wulikajaya yinikurluya nyinapayi jilanya, Jayimunpa palunga yini kujupa Piija, palumili marlaju Yanturu, Jayimijpa, Jaanpa, Pilapu, Pajalamu, Tamajpa, Maajurru Jayimijpa kujupa Yalpiyajkurnu kaja, Jatiyajpa, Jayimunpa kujupa, Juutajpa Yijikariyatmartaji. Jayimijkamu Jaannga palunyangapula kurtararra nyinapayi, Jipitikurnu kaja kujarra. Maajurru palunga kapamanmapuku-janampa mani mankupayi. Jayimun, jii julyju Ruumanpurlukaku parlanypa-janampa nyinapayi. Juutajju-jananya ngula wajanu maajakajangka, yankuraya Jiijajpa ngalulkura ka katikura. ");
INSERT INTO mpj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tuwal wulikaja-jananya Jiijajju wajarnu kurtingu, palumili wangkaya parra wajalkuran. Jilanya-janampa wajarnu, “Mirta-jananyanyurra parra yanku Juwuparnimili ngurrawana, ngurra Jamiriya jiiwana tawunkajawananyurra mirta parra yanama! ");
INSERT INTO mpj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yijurilmili marlajanukajangka-jananyanyurra parra yankula jakurljunama!, jiipukajayuruya parra yaninpa maajaparni. ");
INSERT INTO mpj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jilanyaya-jananya nintijula!, ‘Mamalu-jananya palumili walyjakaja kuwarri ngampurrju kanyilku.’ ");
INSERT INTO mpj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ngarntakajaya-jananya wankanma!, mitukajalurrju-jananyanyurra wankanma! Ngarnta lipurijiwintikaja-jananyanyurra kunyjunyunkunma!, malpuwintiku-janampanyurra malpukaja payira kurtingkuma! Ngayulurna-nyurranya Mamamili maparnpa yumulu yunginpa, palunyangka-jananyanyurra martu ngarntawintikaja yumulu kunyjunyunkunmalpa, maniku japilparnilu. ");
INSERT INTO mpj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mirtanyurra manikamu kuulu pakitingka jarrpajula parra katima! ");
INSERT INTO mpj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mirtanyurra payiki mirrkakurlu parra katima! Mirtanyurra Jaartakamu jinapuka kujupawinti parra yanama! Mirta kujarra wartawintinyurra parra yanama!, kujuwintiwiyaju. Warrkamuku-nyurranyaya martukajalu mirrkakamu mani yungamalpa, ngayumili warrkamupurlukakajanyurra parra yaninpa. ");
INSERT INTO mpj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Jampa tawun kujupakartinyurra yanku ka warinykatiku jii tawunja, karanyurra martu kunyjunyuku parra ngurrilku. Jampa-nyurrampa jii martu pukurlarriku, kalunyurra wulu nyinama!, palumili ngurrangka, mirtanyurra maya kujupangka maya kujupangka nyinama! ");
INSERT INTO mpj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jampanyurra jii martumilingka mayangka jarrpaku, jampa palumili walyjakaja-nyurrampaya pukurlarriku, jilanya-janampaya wajala!, ‘Kunyjunyunyurra nyinama!, murlpirrpa.’ ");
INSERT INTO mpj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka-janampanyurra kunyjunyu wulu nyinaku, kunyjunyu-janampanyurra nyinaku. Jampa parlanyarriku-nyurrampaya jilanya-jananyanyurra wajalku, ‘Pakiwanalulaju-nyurranya julyju wajarnu, “Kunyjunyuya nyinama!, murlpirrpa.” Wajalparnilulaju-nyurranya junkungara.’ ");
INSERT INTO mpj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jampa maya kujungka-nyurrampaya parlanyarriku, palunyangka-jananyanyurra junku yanku. Jampa tawun jiimartaji-nyurrampaya parlanyarriku, ka Mamamili wangkaraya junku yanku, palunyangka-jananyanyurra junku yanku. Yankurakunyurra jinapuka yarralku ka parna pungku. Jiimartajilu-nyurranyaya nyaku kulilku, ‘Ngaakajaluya Mamamili wangka kangurni, kala-jananya nyurnimanin, palunyangkaya parna pungu. Mayitpi-lanya yilta pungku Mama ngarnawarrapurlukalu, jumajila-jananya nyurnimanu.’” ");
INSERT INTO mpj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jiijajju-janampa yarrarnu wajarnu, palumili wangka-nintikajangka, “Ngulampa Mama ngarnawarrapurlukaluntaya wajalku kuutja martungka yarnngangka, Julyjuya martu nyinapayi ngurra Jutumjakamu ngurra Kamurangka, walykuya nyinapayi. Jiikaja-jananya Mamalu wajalku kurtingku, waruwakiya yankuraku. Ngaakaja-jananya nyurnipayikaja Mama ngarnawarrapurlukalu rawalu warrkilku, ka-jananya kurtingku yankurakuya waruwaki, jumaji-nyurranyaya nyurnimani. ");
INSERT INTO mpj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ngangkulaya! Ngayulurnantaya kurtingkuni yankunyurran parra wajalku ngayumili wangka, martukajangka. Karlkilu-nyurranyaya parlanykajalu warrkilkuka pungku, mirta-janampayan parlanyarriku, kunyjunyu-janampaya nyina! ");
INSERT INTO mpj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wurlkumartanyurran yanku, karlkiya martukaja ngayukujuya parlanypa. Jampa-nyurranyaya nyaku, mankuntaya kangku kuutkarti, Juwumili jaajkarti, jiingkantaya wiipamulku wiipwintilu, ka-nyurranyaya junku yanku. ");
INSERT INTO mpj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Palujanu kujupakajalu-nyurranyaya manku kujupakarti kuutkarti kangku. Palunyangkanyurran yikiku maaja majuwartakajangka, Juwuparnikajangka kuutja, jumajinyurra ngayumili walyjakaja nyinani. Jampanyurran jiingka kuutja yikijulku jakurljulku-jananyanyurran ngayumili wangka kunyjunyu. ");
INSERT INTO mpj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mirtanyurran karratarri!, murlpirrpanyurran yikiku. Mamamililu Kuurtilu-nyurranya nintijulku, kuranarrikunyurran wajalkuraku. Mirtanyurran ngurinyjirriku yaalunyurran wangkaraku, paki, jiilu Kuurtiluntaya wangka nintijulku. Jilanya wangka mirta nyuntumili, Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Palungka tayimungka nyuntumililu walyjakajalu kangku-nyurranyaya kuutja yikijunku, jumajijunyurran ngayumili walyjakaja, martukaja nyinani. Kurtaluyingku marlaju walyja kangku yikijulku kuutja, miturriraku, jumajiju palunya marlajupartarnu ngayumili Jiijajmili walyja. Mamapartarnulu-pulanya kangku yikijulku kuutja yurntalkamu kaja, miturrirakupula, jumajijupula ngayumili Jiijajmili walyja kujarra. Kajalukamu yurntaljupula kangku mamakamu yakurti yikijulku kuutja, miturrirakupula, jumajijupula walyja kujarra ngayumili, Jiijajmili. ");
INSERT INTO mpj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Martukaja-nyurrampaya parlanypa nyinaku, jumajijuyan ngayuku walyjakaja. Jamparnin wululu wanalku, martu karlkiluntaya nyaku warrkilmalpantaya pungkumalpantaya, nyuntulurnin nyurilu wanalku, Mamaluyilapanta manku kangku wulu kanyilku ngarnawarra, ngurra kunyjunyungka. ");
INSERT INTO mpj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jampa-nyurrampaya tawunja kujungka parlanyarriku, jumajinyurran ngayumili wangka nintirnu, ka-nyurranyaya warrkilku ka pungku, yankunyurran tawun kujupakarti. Jampa-nyurranyaya jiingka tawunja warrkilku ka pungku, yankunyurran tawun kujupakarti. Yarralkunyurran yanku tawun kujupakarti, tawun yupalkarti, kayilaparna ngayu marlakurriku, martuku yarnngaku marlpa. Mirtanyurran ngayumili warrkamu pakilku, mirtanyurra-jananyan parra wajalku tawunja yarnngangka ngayumili wangka, paki. Ngayulurna jampakarta pakalku. ");
INSERT INTO mpj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Walykukajajuya mirta ngayuku ngurlurripayi, maajaku, paki, warrkilpayirniya pungkupayirniya. Palurtinju mirta-nyurranyaya nyaku junku ngurlulu, ngayumili warrkamupurlukakaja, paki, warrkilku-nyurranyaya pungku-nyurranyaya ngayuyuru. Pukurlpanyurran nyinaku jilanyanyurran ngangkulku, ‘Jiijajpaya warrkilpayi kaya pungkupayi, paluyurula nyinaku.’ Walykukajalurniya ngayu warrkilpayi, ‘Nyuntungan walykun, malpuyuru!’ Jilanyayuru-nyurranyaya warrkilku, ngayumili walyjakaja. Wajarinaku-nyurranyaya nyaa nyirrinyirri. ");
INSERT INTO mpj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","“Mirtanyurran ngurlurri!, kurrurn wiltulunyurra-jananyan ngayumili wangka wajalku. Ngayurna-nyurranya wangka karlkinpa wajalpayi kujunkujunja, mirta yarnngangka. Nyurrartinju-jananyanyurran yanku wangka palu wajalku yarnngangka. ");
INSERT INTO mpj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yarnngangkanyurra-jananyan wangka ngayumili wajalku, mirtanyurran junku wangka palu, jumajiya karlki martu parlanypaya nyinani, nyurinyurran wangkaku. Jiilu karlki martulu-nyurranyaya mayitpi pungku miturntalku, Mamaluyilapantaya manku kangku palumili ngurrakarti. Mirta-janampanyurran ngurlurri!, Mama majuku maajakuwiyajunyurran ngurlurriku. Martu jiinya walyku Mamalu warrkilku kurtingku waruwaki. ");
INSERT INTO mpj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mamaluntaya ngangkura mukumukulu kanyini. Pilurnkajalurrju Mamalu ngangkura kanyini. Pilurnpa julijuli miturriku, Mamalu ngangkuni pilurn palunya. ");
INSERT INTO mpj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mamalu-lanya ngangkuni katangkala purrunypa kanyini, palunyanga kawuntamuni, ngangkuni nampakaja, nintilu. ");
INSERT INTO mpj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jampantaya walykukajalu pungku miturntalku, palunyanga Mamalu ngangkuni, pilurnyuru, mirtanta junku yanku, paki, kangkunta Mamalu ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Martulu-jananyanyurran yankura wangka jilanya parra jakurljunkuraku martungka yarnngangka, ‘Ngayurna walyja Jiijajmili.’ Karnalu Mamangka wajalku kurlunga kuutja, ‘Yilta ngaanga ngayurni wanani, walyjaju.’ ");
INSERT INTO mpj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jampa martulu-jananya yanku jakurljulku jilanya, ‘Mirtarna ngayulu wanani Jiijajpa, paki, ngurrparnara.’ Karnalu Mamangka wajalku kurlunga kuutja, ‘Ngurrparnara ngaaku martuku, mirtarnara ninti, paki.’ ");
INSERT INTO mpj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","“Ngayurna parnakarti yanurni, wajalkurakurnantaya Mamamili wangka. Karlkiluya ngangkulku pukurlpaya nyinaku Mamakuraya, karlkiluya ngangkura Mamaku parlanyarrimalpa. Jiikaja-janampaya Mamamili walyjakajaku parlanyarrimalpa. Kajara parlanyarriku mamapartarnukura, jumaji mamapartarnura Jiijajkura walyja. Jilanya-janampaya kaja parlanyarriku mamapartarnukajaku. Yurntalpara parlanyarriku yakurtipartarnuku, jumaji yakurtipartarnura Jiijajkura walyja. Jilanya-janampaya yurntalpa parlanyarriku yakurtipartarnukajaku. Ngunyarrirangkupula parlanymarriti nyinaku, jumajira kujunga Jiijajmili walyja. Jilanyaya ngunyarrimarriti nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Martu kujura Jiijajku walyjara nyinaku, palukuraya karlki martumili jiimili walyjakaja parlanypaminyirri nyinaku, jiikuraya martuku, jumajira Jiijajkura walyja. Martu karlkiraya parlanypa nyinaku martu jiiku Jiijajkura walyja, mirtaya parlanyminyirri nyinaku, martumili jiimili walyjakajayuru. ");
INSERT INTO mpj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Jampa martu kujulu ngayumili wangkakura ninti nyinani, yirnkulurni kuwarri wanalkuraku, mirta Jiijajku parlanykaja ngangkuraka wanalkuraku. Mirta martulu ngangkulku jilanya, ‘Mamakamupula yakurti mirtarapula Jiijajku pukurlpa, paki, parlanyparapula. Palunyangkarna ngayulu kuwarri Jiijajpa junku yanku, mirtarna wanalku kuwarri, mayiti kurlungarna wanalku.’ Jampa-pulanya jiilu martulu jilanyalu ngangkulku, mirtaju ngayuku walyja nyinaku, paki, jumajirni junkura yankuni. Mirta martulu ngangkulku jilanya, ‘Kajakamupula yurntalpa mirtarapula Jiijajku pukurlpa, paki, parlanyparapula. Palunyangkarna ngayulu kuwarri Jiijajpa junku yanku, mirtarna wanalku kuwarri, mayiti kurlungarna wanalku.’ Jampa-pulanya martulu jiilu jilanyalu ngangkulku, mirtaju ngayuku walyja nyinaku, paki, jumajirni junkura yankuni. ");
INSERT INTO mpj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“Martu walykukajalurniya warrkira pungkupayi, kuwarrirniya wiltijulku wartangka karna miturriku. Ngulampa-nyurranyaya martu walykukajalu warrkiraka pungku ngayuyuru. Mirta-janampanyurran ngurlurri!, karninyurran junku yanku, paki, nyurilurniya wanala! Karlkiya-nyurranya pungkura ngurlulmalpa, karninyurra ngayu junku yanku, mirtajunyurran walyja nyinaku, paki. ");
INSERT INTO mpj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jampa martu jiinya ngurlurriku, karni junku yanku, kayila miturriku, mirtalu yanku Mamakarti wanka nyinaraku, paki. Jampa martulurni nyurilu wanalku, mirtarni junku yanku, palu miturriku yanku Mamakartilu, ka wanka nyinaku, pukurlpa.” ");
INSERT INTO mpj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Palumili wangka-nintikajaku-janampa Jiijajju yarrarnu wajarnu, “Jampa martungku pukurlarriku, ngayukulurrjuju pukurlarriku. Jampaju ngayuku martu pukurlarriku, Mamakulurrjura pukurlarriku. Mama jiilurni kurtingu parnakarti. ");
INSERT INTO mpj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jampara martu Mamamili wangka jakurlpurlukakura pukurlarriku, jakurlpurlukakamu-pulanya martu palunya marninypungku kuutja, ngulampa. Jampara martu Mamamili walyjaku pukurlarriku, Mamamili walyjakamu-pulanya martu palunya marninypungku kuutja ngulampa. ");
INSERT INTO mpj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jampangku Jiijajmili walyja kuwarrijanungku martu pukurlarriku, kanta yungku kalyu yalta jikilkurakun, ngangkulku, ‘Kalyurnara yungkura Jiijajkura walyja.’ Yilta martu palu kurlunga marninypungku kuutja, Mamalu.” ");
INSERT INTO mpj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jilanya-jananya wajarnu palumili wangka-nintikajangka. Palujanu Jiijajpa palumili wangka-nintikaja yanuya tawun kujupakarti, nintilkuraku-jananyaya. Parraya yanu tawunja. Yarrarnuya yanu tawun kujupakarti, ka tawun kujupakarti. Tawunpa yarnngangka-jananya nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Palunya tayimunga Jaanpa jiinya kalyupurluka, jiilta nyinapayi. Jaanju-jananya ngangkurnu jakurlpa, jakurljunuluya, Jiijajju-jananya nintilpayi Mamamili wangka, ka-jananya maparnjulpayi ngarntakaja. Jaanju-jananya palumili wangka-nintikaja kurtingu, yankuraya japilkuraku Jiijajpa. ");
INSERT INTO mpj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yanuraya Jiijajpa japirnu, “Kajin yilta nyuntunga Kurayijpa?, mayitpin kujupa. Mayitpi majalkulara Kurayijparni ngula yankura?” ");
INSERT INTO mpj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jiijajju-jananya wajarnu, Jaanmili wangka-nintikajangka, “Yarraluya marlaku wajala Jaanja!, nyurrartinjunyurran nyakuni, ngaarna-jananya ngayulu ngarnta wankani. ");
INSERT INTO mpj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pampurukajaluya nyakuni, mukuntukajaya parra yankuni. Ngarntaya rawalu kanyilpayi palukajaya kunyjunyurringu. Ngakumpaya nyinapayi palukajaluya ngangkuni. Mitujanuya kanarrini. Nyarrukajangkalaju-jananya Mamamili wangka kunyjunyu wajani. ");
INSERT INTO mpj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jilanyalunyurran yanku Jaanja wajalku. Wajalaluya jilanya!, ‘Ngayurna yilta Kurayijpa Mamalurni kurtingu, mirtan paki karala!, wululurni ngangkula!’” ");
INSERT INTO mpj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jampaya Jaanmili wangka-nintikaja marlaku yanu, Jiijajpa-jananya martukajangka wangkapayi, “Julyjunyurran warrarnpa pujimankarti yankupayi, ngangkulkurakunyurran Jaanpa wangkapayi. Yanulunyurran ngangkulkurakunyurran Jaanpa wangkapayi, mirta kurntarripayi, kurrurnpa wiltuntaya wangkapayi. Jiinyurran ngangkunu ka pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nyurrartinjunyurran ngangkunu yankunyurran nyakuraku Jaanpa pujimanpa. Mirta jawuja kunyjunyuwinti, paki, mirta jaarta kunyjunyuwinti, paki, yumu walykuwalykuwinti nyinapayi. Yiltamartangampaya mayangka nyinani, jawujakamu jaarta nyuwanwintinga. ");
INSERT INTO mpj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Julyjunyurran ngangkunu yankunyurran palunga Jaanpa nyakuraku, Mamamili jakurlpurluka. Mamamili jakurlpurlukakajaya julyju nyinapayi, Jiinga Jaanpanga palukajangkamarra munkarra-janampalura nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Julyju Mamamili mirlimirlingka kujupalu wangka wakanu jilanya, ‘Mamalu julyju wajarnu, “Ngayulurna kurranyulu kurtingku wangkapurluka yanku-jananya jakurljulkuraku, martukajangka. Ka Kurayijparna marlakarti kurtingku.” ’” ");
INSERT INTO mpj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jiijajpa-jananya yarrarnu wangkapayi, “Jiinya Jaanpa martungkamarra-janampalura yarnngangkamarra munkarra nyinani. Kaya ngayumili walyjakaja Jaanyuru martukajangka munkarra nyinani, jumajiya ngayumili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jiilu-jananya Jaanju parra wajalpayi martukajangka Mamamili wangka, ka kuwarringa ngayulurnantaya yarrarnuka parra wajani, wangka jilanya, ‘Mamaluntaya walyjakaja ngampurrju kanyilku.’ Palunyangkarniya walykukajalu warrkiraka pungkukijalu. ");
INSERT INTO mpj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","15","Julyju Muujajju-jananya wangka wakarnu yungu Mamamili, ka-jananya wajalpayi. Palujanu kujupakajalu-jananyaya Mamamili jakurlpurlukakajalu parra wajalpayi. Jiikajaluya julyju wajarnu Jaanpa nyinakuraku kalyupurluka. Kaya wajarnu, Jaanpanga nyinaku Yilayijayuru. Wangka palukajanyurran ngangkuraka junga nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Martukajangaya kuwarri jilanyayuru nyinani, japukajayuru. Karlkiluya yinkalku turlku, kaya karlkilu ngangkura junkumal. ");
INSERT INTO mpj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Karlkiluya wajalku, ‘Yinkarnulaju-nyurrampa, mirtanyurran nampingu. Pinyikulajura wururringu, ka yulapayi, mirta-lanyajuyan kujungkarringuka kulurnu.’ ");
INSERT INTO mpj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Japukajaluyintaya nyurnimani, palunyayurunyurran Jaanpanyurra nyurnimalpayi, ‘Malpuwinti nyinani, walyku. Mirta wama jikilpa, mirta mirrka ngalku, paki. Jiilu mirrka junkuni, Mama marninypungkuraku, mirtalaju jilanya nyinani.’ ");
INSERT INTO mpj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngayurnantaya julyju nyinapayi, martukajaku yarnngaku marlpa, karna nyurrartinyurulu ngalkupayi, jikilpayi, karninyurran nyurilu nyurnimalpayi. Wajarnujunyurran pakiwana jilanya, ‘Ngaanya walyku!, mirrka maju ngalkuni, wama maju jikini, martungka-jananya walykungka, yankura nyinani. Jiikajaluraya karlkilu Muujajmili wangka mirtaraya wanani, paki, ka karlkiluya martulu kapamanku-janampaya mani mankuni. Paluyurungka-jananya yankura nyinani, martungka walykungka.’ Yiltarniya jilanyalu karlkilu nyurnimanu. Ngulampa-linyajuyan karlkilu nintipukalu ngangkulku, ‘Yiltapula ngaanya yirnkurapula nyinapayi Mamaku, wanalpayilupula yirnkulu, Jaanjukamu Jiijajju.’” ");
INSERT INTO mpj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tawun kujupa kujupangka-jananya Jiijajju parra wajalpayi Mamamili wangka, ngarntakaja-jananya wankalpayi. Ka tawun jiikajangka martukajaluya ngangkuraka junkupayi, mirtaya wanalpayi. Palujanu-jananya tawun jiimartajikaja martukaja-jananya Jiijajju nyurnimanu. ");
INSERT INTO mpj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mamalu-jananya warrkilku kurtingku ngulampa Kurajinmartajikamu Pijajmartaji, jumajiya mirta Mamamili wangka ngangkurni, paki. Taayamartajikamu Jayitanmartaji-jananyaya wajani putaya nyinani, Mamakuraya ngurrpa nyinani. Mirta-jananyaya karlkilu Mamamili wangka parra wajalpayi, paki. Ngayulurna-jananya Jiijajju mirta yanurna-jananya wajalpayi, paki, jumajiya Juwuparni nyinani. Ngangkulaya wangka jilanya! Jamparniya Taayamartajilukamu Jayitanmartajilu ngangkulngara ngayumili wangka, jiilungarniya wanalngara. Jamparna-janampa ngarntakaja wankalngara, ngangkurakarniya wanalngara. Julyjurniya ngayumili wangka ngangkulngara, karniya wanalngara. Jurnpayintaya nyutilngara ngumpangka, mara kujarrangka juntawana, kulujungkaluya walykuwalykungka kurrungkungara karniya wanalngara. Martu karlkilu-jananyaya nyakuraka wajalngara, ‘Walykukajaya junukaya Mama wanani.’ ");
INSERT INTO mpj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngangkukurakuya!, Kurajinmartajilukamu Pijajmartajilu, wangka ngaanya. Ngulampa-jananya kuutja Mamalu warrkilku kurtingku, jumajirniya ngangkura junkupayi, ka-janampa Mama ngarnawarrapurluka Taayamartajikukamu Jayitanmartajiku nyarrurriku-janampa, jumajiraya ngayumiliku wangkaku ngurrpa. ");
INSERT INTO mpj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ngangkulkuraya Kapaniyamumartajilu! Ngangkuniya jilanya, ‘Tawunpa-lampa majuwarta yikini, tawunpa kujupakajangkamarra munkarra.’ Nyaakuya pakiwana ngangkuni? Mamalu-janampa tawunpa Kapaniyamu warlangku pakilku. Ngayulurna-jananya maparnju wankalpayi, karlkirna-jananya yalyjirrju nintilpayi, maparnju, karniya nyakuraka ngangkuraka junkupayi. Jampaluya julyju maparn palukajalu ngapilngara tawunpa Jutumja, jiingaluya Mamangka wanalngara, tawunpa jiinya kuwarringa yikingara. Julyju-jananya kamparnu pakirnunirra jumajiya walykuya nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngulampa-jananya Kapaniyamumartaji kuutja Mamalu warrkilku kurtingku, jumajirniya ngangkura junkupayi, ka-janampa Jutummartajiku nyarrurriku-janampa, ngayumilikuraya wangkaku ngurrpa, mirtarna-jananya yanu parra wajalpayi, jumajiya julyju pakirringu.” ");
INSERT INTO mpj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Palunyangka-jananya wangka-nintikajangka nyinapayi, ka palunyangka Jiijajpalu Mamangka wangkangu, “Mama! Nyuntungan maaja majuwarta nyinani, parnapurlukaku-janampan kamu ngarnkapurlukaku. Martukajalu-jananyaya ngayumili wangka-nintikaja nyurnimani, mirtaya yankupayi kuulkarti, paki. Karnanta marninypungkuni nyuntulu-jananya nintinu nyuntumili wangka ngaakajangka, ngayumili wangka-nintikajangka. Karlkingka-jananyan junu kuulku nintipukangka mirtaya kuranarrini. ");
INSERT INTO mpj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jilanya-jananya nyuntulu nintijunu, ngayumili wangka-nintikajangka, nintiya nyinaraku nyuntumili wangkaku.” ");
INSERT INTO mpj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka-jananya jilanya Jiijajju wajarnu, palumili wangka-nintikajangka, karlkingka martungka yarnngangka, “Mamalurni ngayu junu maaja majuwarta. Mamawiyajuju ngayuku ninti nyinani, karnara ngayuwiyaju Mamaku ninti nyinani. Karlkiranyurran Mamaku ninti nyinani, ngayulurnantaya Mama nintijunu, karlkingkalurrjurna-jananya nintijuni. ");
INSERT INTO mpj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","“Karlkilunyurran jiinya purtu ngangkuni Mamangkaluyan yirnkulu wanalkuraku. Parajikajalu-nyurranyaya pakiwana nintijulpayi luwu kujupa kujupawananyurra nyinakura. Ngangkularniya! Ngayulurnantaya jungalu nintijulku yaalujunyurran yirnku nyinaraku ngayuku, pukurlpajunyurran nyinaraku. Mirtarna-nyurranya warrkilku, paki, pukurljurnantaya kanyilku, karrartanyju majulu. Jamparninyurran Mamamili ngayu ngangkulku, palunyangkanyurran wanka nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Palujanu Jiijajkamu palumili wangka-nintikaja yankupayiya wilykiwana, wilyki yini wiiti, mirrka ngalkupinti. Karrpungkaya yankupayi Jarritingka. Jiijajmili wangka-nintikaja yankupayiya kalyparturringu, kaya yinalpayi wilykikaja ngalkungunaraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ka karlki martu jiingkaya yikipayi yini Parajikajaya. Nyangu-jananyaya Jiijajmilikajaluya wangka-nintikajalu ngalkupayi mirrka wilykikaja. Ka Parajikajalu wangkanguluya Jiijajja, wajarnuraya, “Nyaakuya ngalkuni kuwarringa Jarriti? Nyawa-jananya nyuntumili wangka-nintikajalu ngalkuni. Nyampanga-lampa luwu nyinani, mirtala warrkamurrini Jarritingka, paki. Nyuntumilikajalu wangka-nintilu warrkamurrini, yinaniya wilykikaja.” ");
INSERT INTO mpj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Ka-janampa Jiijajju wajarnu, Parajikajaku, “Mamamili wangka jilanya nyinani, ngangkulngaranyurran. Julyju Tayipitmaluluya mirrkaya ngalkupayi Juwumilingka jaajingka. Jaaji palunga Mamamili. Mirrka jiinga kangkuraya junkupayi jaajingka Mamakura, ngarnawarrapurlukaku, martukajaluya, jaajipurlukalu yatilyjuwiyaju ngalkuraku. Jilanya-janampa luwu nyinapayi, jaajipurlukaluwiyajuya ngalkuraku. Mirrka palunya Tayipitmaluluya kalyparturringu, kaya ngalkupayi, mirtaya jaajipurluka nyinapayi.” Palunyayuru-jananya Jiijajju maajalu wajarnu palumili wangka-nintikajaluya palya mirrka jiinya ngalkuraku, Jarritingka. ");
INSERT INTO mpj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jiijajju-janampa yarrarnu wajanu, “Kuwiyiya kangkuni jaaji majuwartakarti martukajalu, jaajipurlukaluya yatilyju pungkura kujalkuraku. Jilanya-janampa warrkamu, Jarritingkanga, ka-janampa Mamanga pukurlarrini. Jilanyaya kuwiyi pungkuraka kujani, Muujajmilinga luwu. Luwu jiinyanyurran Parajikajalu riitamuraka ngangkulngara. ");
INSERT INTO mpj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","7","Ngangkuninyurran jilanya, ‘Jiinga jaaji majuwartakungalara pukurlarrini, jumani Mamalu-lanya ngarnawarrapurlukalu yungu.’ Mirtaranyurran jaaji palunyakuwiyaju pukurlarrira, Mamamiliraya wangka ngaa ngangkulaka yirnku nyina!, ‘Mamalurna-nyurranya wajanu, jaajikartinyurran majuwartakarti kuwiyi kangkura junkuraku, ngayurninyurran yungkuraku, Mamakarti. Wangka jilanyanyurran ngangkuraka jilanya kangkupayi kuwiyi, ka martu kujupakajaku-janampanyurran parlanypa nyinani. Mirta-janampanyurran parlanyarri!, kunyjunyuyingkuya nyina!’ Jiinyanyurran Mamamili wangka ngangkura junkuni, mirta-janampanyurran kunyjunyu nyinapayi, ngayumili wangka-nintikajaku, paki, junkungara-jananyanyurran, kunyjunyuluya ngalkungara. Ngangkulngaranyurran yirnkulu, ngayurninyurran mirta marrkulngara, jilanya, ‘Mirtaya nyuntumili wangka-nintikajalu ngalkura Jarritingka.’, junkungararninyurran marrkulparnilu, yirnkulurninyurran ngangkulngara. ");
INSERT INTO mpj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngayurna maaja maju nyinani, martuku yarnngaku marlpa. Ngayulurna kunyjunyuni martukaja Jarritingka. Ngayurna-jananya wajani mirrkaya ngalkuraku Jarritingka.” ");
INSERT INTO mpj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Palujanu Jiijajkamu palumili wangka-nintikaja yanuya Juwumilikarti jaajikarti. ");
INSERT INTO mpj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jiijajpa kurrungu jaajingka, ka nyangu martu mara walyku, ngarntajanu. Karlkiya martu jiingka nyinapayi, Jiijajkuraya parlanypa nyinapayi. Ngangkulpayiya, “Mayiti ngaanya martu mara kunyjunyulku Jarritingka kuwarri. Ngayurtinku-lampa luwu mayiti warlangku.”, jilanyaya ngangkulpayi. Karaya Jiijajparaya japirnu, “Kajin yaalu ngangkuni? Luwu-lampa jilanya nyinani?, kuwarri ngarnta maparnwintilu wankalku, Jarritingka?, mayitpi paki?” ");
INSERT INTO mpj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka-jananya Jiijajju wajarnu, “Martu kujulu-jananya jiipukaja kanyilmalpa, kuju yanku luujarriku, ka punkalku pirtingka, karrpungka Jarritingka.” Jiijajju-jananya japirnu, “Yaalulku jiinya jiipupurlukalu? Yanku nyaku junku, jumaji Jarriti, mayiti manku. Jiinya jiipu manku pirtijanu ngarrira miturrijaku, jilanya wankalku kalu marlaku kangku. ");
INSERT INTO mpj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jiinya wangka jilanyayuru martukamula-jananya Jarritingka wankalkuraku, luwu-lampa jilanya nyinani. Mamalu ngangkuni jiipungala munkarra nyinani, martukaja. Jarritingkala-jananya martukamu wankalkura.” ");
INSERT INTO mpj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ka Jiijajjura martuku jiiku wajarnu, “Marangku turitpalala!” Mara turitpalarringu kayilapa kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Palujanu Parajikajaraya wirrilyirringu, jumaji Jiijajju Jarritingka martu mara wankarnu. Yumuyuruya yaka yanu Parajikaja, kaya wangkapayi Jiijajpaya pungkura miturntalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Palujanulu yanu jakurljunu kujupalu martulu Jiijajja, “Parajiluntaya jumani pungkuntaya miturntalkuraku.” Palujanu Jiijajju ngangkunu ka ngurra jii junu yanu. Karlkiluya martulu yarnngalu wanarnu Jiijajpa pukurlparaya nyinaraku. Jii-jananya Jiijajju ngarntawintikaja kunyjunyulpayi. ");
INSERT INTO mpj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka-jananya Jiijajju marrkulpayi, mirta yankuraka jakurljulkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Julyjukurlu Mamamili wangkawinti Yayijaya nyinapayi, Mamakura jakurlpurluka. Jilanya wajarnu Kurayijkura wangka ngaanya yiltarringu. ");
INSERT INTO mpj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Julyju ngayulurna Mamalu ngarnawarrapurlukalu warrkamupurluka yintarnu junu, Kurayijpa. Ngayurnara mukumuku, pukurlpa nyinani. Ngayukuju Kurrurnjarra palu nyinaku, palulu-jananya martu yarnngangka parra wajalku. Wajalku-jananya, ‘Jampaya walyku wulungulyu nyinaku, ngayulurna-jananya kurlunga kuutja warrkilku kurtingku.’ ");
INSERT INTO mpj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Palulu-jananya parnangka ngaangka Kurayijju mirta wirrilyirriku-jananya warrkilku, paki. Wajalku Kurayijju, ‘Ngayungarnara warrkamupurluka Mamaku, mirtarnaju walyjalu marninypungkuni.’ ");
INSERT INTO mpj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kurayijpa jiinya martukajaku-janampa nyinaku karrartanyju. Jilanya-jananya nintijulku rawalu, Mamakuraya ninti nyinaraku, palumili wangkaraya wanalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ngurra kujupa kujupajanu martulurniya yarnngalu Mamamili kaja ngangkulkukaluya pukurlarriku nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Palunyajanu martu karlkiluya kangkupayirniluya pampuru wangkapunaja. Mirta wangkapayi, paki, malpulu nyinapayi. Jampa Jiijajju wankarnu ka martu palunyalu nyangu ka wangkangu. ");
INSERT INTO mpj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaya martukaja kuru pakarnu kaya wajarnu, “Mayitira ngaanya Kurayijpa nyinani, mitunyjarripurlukakura Tayipitku marlajanu.” ");
INSERT INTO mpj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jampaya ngangkurnu Parajikajalu Jiijajku parlanykajalu, kaya wajarnu, “Mirta jiinya Kurayijpa, paki. Martukajaraya pukurlarrini, jumajiya ngangkuni, maparnwinti. Jiinga malpu maajamili jiinya maparnpa kanyirni, malpu-jananya wuramara kurtingkuni, maparn palunyawintilu.” Parajikajaluya jilanya pakiwana ngangkurnu. ");
INSERT INTO mpj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jiijajju-jananya nintilujaru ngangkunu, ka-janampa wajarnu, “Jampayintaya kujupajanulu ngurrajanulu pungkuyintaya rawalu miturntalku, pakirrikunirraya. Jampayintaya tawunpa kujujanulu rawalu pungku, miturntalku, kaya pakirrikunirra. Jampayintaya walyjamarrilu kujujanulu rawalu pungku, miturntalku, kaya pakirrikunirra. ");
INSERT INTO mpj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","27","Ngaanya jilanya wangka. Jampayintaya malpukajalu pungku rawalu, miturntalku, pakirrikunirraya. Nyurrartinjunyurran ngangkuni pakiwana, ngayulurna-jananya malpumiliwintilu maparnju wuramara kurtingkuni, malpukaja. Jiinga paki mirta yilta. Yiipirna-jananya malpumiliwintilu maparnju wuramaraka kurtingkungara, kayilapaya pakirrira wanalngara, malpukaja yarnngalyu.” Parajikajangka-jananya yarrarnu wajarnu Jiijajju, “Nyurrartinmiliya walyjakajalu maparnwintilu wuramara kurtingkuni malpukaja. Kajiya nganamili maparnwintilu wuramara kurtingkuni, malpukaja?, malpumiliwintilu maparnju?, paki, Mamamili maparnwintiluya wuramara kurtingkuni. ");
INSERT INTO mpj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ngayungarna palurtinyuru Mamamiliwintilurna maparnju wuramara kurtingkuni malpukaja, mirta malpumiliwintilu, paki. Mamamili maparnwintilurna-jananya wuramara kurtingkuni, malpukaja, nyakurakarninyurran ngangkulngara, ‘Kuwarri-jananya Mamalu palumili walyjakaja ngampurrju kanyilku.’” ");
INSERT INTO mpj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Wangka kujupa-jananya Jiijajju wajarnu, “Yirna murlpirrpa nyinaku, jantulkurlu. Mirtarni kujupa yankurni ngulyuku, wartakaja mankuraku, jumaji murlpirrju pungkujaku. Yiipi yirna kujupalu maparnwintilu yanku yirna palunga kurranyilu karrpilku ruupwintilu, palujanu manku ngulyulu murlpirrmili wartakaja.” Yirna paluyuru murlpirryuru, malpumili maaja murlpirrpa nyinani. Ka Jiijajpa palu martuyuru maparnwintiyuru, maparn maju nyinani. Ka palulu malpukaja payira kurtingkuni Mamamili maparnwintilu, palumili Kuurtiwintilu. ");
INSERT INTO mpj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jiijajju-janampa yarrarnu wajarnu, “Jampa martulu ngayumili wangka ngangkulkuka junku, mirtaju ngayuku walyjarriku, palunyajura parlanypa nyinaku. Jampaju mirta martu ngayuku walyjarriku, mirtaju ngayumili warrkamu ngapilku. ");
INSERT INTO mpj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ka yiipi martulu Mamamili Kuurti nyurnimanku, jilanyalunga walyku ngapini, ka japilku Mama walyku jiira warningkura, palujanura Mamalu mirta warningku, paki, jumaji palulu Mamamili Kuurti nyurnimanu. Martu jiilura purtu japinmalpa walyku jiikajara warningkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jampa martulu ngayumili Jiijajmili wangka ngangkulkukara parlanyarriku. Kalu marlaku yanku japilku Mamangka yirnkulu wanalkuraku, Mamara nyarrurriku ka manku marlakulu. Yiipi martulu Mamamili Kurrurnjalu jankangkuka junku yanku. Palunyaku martuku mirtara nyarrurriku, jiinga pinyijulku wulu, mirtara walyja nyinaku, jumaji Kurrurnjalu jankangu. ");
INSERT INTO mpj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Jampa warta yukuri yikiku, mirrkalu kunyjunyu nyinaku, martulura nyakuka pukurlarriku. Jampa warta kujupa tikirlpa yikiku mirrkalu walyku nyinaku, martulu nyaku ka mirtara pukurlarriku. Warta jiinya mirrka walykuwintiyurunga, nyunturtinpayuru martu walykukaja nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Jiijajju-janampa yarrarnu wajarnu, “Karlkinyurran walyku nyinani, rawalunyurran ngangkuni walykukajanyurran ngapiyinaraku, pakiwananyurran parra wajani. Martu karlkiya kunyjunyu nyinani, rawaluya ngangkuni kunyjunyukajaya parra ngapilkuraku, kaya walykukajalu rawalu ngangkuni walykukajaya ngapiyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngangkulaya! Kurlunga martunyurran yarnnga yikiku kuutja, ka Mamaluntaya japilku, ngananyurra parnangkalu pakiwana kulilpayi, jampanyurran parnawana nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kantaya Mamalu ngangkulku, ka martu kunyjunyukajayingku kanyilku, ka martu walykukaja warrkilku kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jiinyaya nyinapayi, Muujajmili wangkapurlukakaja, ka Parajikaja. Palunyaluraya Jiijajku wajarnu, “Nintipuka! Nyuntun maparnkamu yalyjirrpa, nintila-lanyaju kujupa kujupakaja!” ");
INSERT INTO mpj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jiijajju-janampa wajarnu martukajaku, “Jiinyanyurran walykukaja Mamaku ngurrpakaja nyinani. Japilpayirninyurran rawalu yalyjirrjurna-ngkuya maparnju kujupa kujupa ngapilkuraku. Paki, mirtarna-nyurrampa kujupa kujupakaja ngapilku. Kurlungarninyurran ngangkulku, ngayurni Mamalu kurtingu. Julyjukurlu Juuna Mamamili jakurlpurluka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jiimarta piijju nyuulkurnu, piijjalu wirlangka nyinapayi. Rawalu nyinangu karrpu kujarrarringu. Paluyururna ngayu Jiijajpa mitu ngarriku karrpu kujarrarriku, pirnkingka. Palunganyurran ngangkulku ngayurni Mamalu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Piijju jii Juuna kanyirnuka kurlpajunu junu parnangka. Palujanu Juunalu-jananya yanu martukajangka tawun Ninapumartajingka parra-jananya wajalpayi, Mamamili wangka. Palujanu Juunaya ngangkunu, karaya yirnku nyinapayi Mamaku. Kurlunga Ninapumartajilu-nyurranyaya kuutja warrkilku, jumajinyurran jankani Mamamili wangkangka. Jiinya Juunangkamarrarnalura ngayu Jiijajpanga munkarra nyinani, maaja majuwarta. Jampajunyurran ngayumili wangka ngangkulngara, yirnkulurninyurran wanaraka nyinangara. ");
INSERT INTO mpj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Julyju nyinapayi wanti, maaja maju-janampa Jiipamartajikajaku. Palunya wanti wirrirli yanu, ngangkulkuraku Jalamanmili wangka. Jalamanjulu nintipukalu wanti palungka jakurljunu Mamamili wangka. Kurlunga wanti jiilu-nyurranya kuutja warrkilku, jumajinyurran jankani Mamamili wangkangka. Jiinya Jalamanjamarrarnalura ngayunga munkarra nyinani, maaja majuwarta, jampajunyurran ngayumili wangka ngangkulngara, yirnkulurninyurran wanaraka nyinangara.” ");
INSERT INTO mpj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jiijajju-janampa ngaanya wangka wajara wanalpayi, ka-janampa yarrarnu wajarnu, “Jampa martululura martu kujupangkamarra wuramalku kurtingku malpu, malpu palunya parra yanku pararrawana parra ngurrilku pirnkingka nyinaraku. Purtura pirnkiku ngurrilkuka, ");
INSERT INTO mpj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","malpu palulu ngangkulku, kalu marlaku yanku martu walyjakarti. Jampa nyaku kunyjunyu nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Malpu palulu-jananya yanku malpu kujupakaja manku, malpukaja jiikajaya walykuminyirri. Kangku-jananya martu walyjakarti, kaluya kurrungku. Jampaluya martu palungka kurrungku malpu palukaja, martu palu walykurrikuminyirri, jumajiya yarnnga nyinaku malpukaja. Jampa martu kujupalu Mamamili wangkangka jankangku, martu jiiyuru nyinaku walykuminyirri.” ");
INSERT INTO mpj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jiijajju-jananya wangka ngaakaja wajalpayi mayangka yinjayiti. Palunyangka Jiijajmili yakurtikamu marlajuraya yanu yikingu, yawujayiti. Martu kujuya wajarnu kurtingu, yankulu wajalkuraku Jiijajja palumili yakurtikamu marlajuraya yawujayiti yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Martu palunyalulu yanu Jiijajja wajarnu, “Nyuntumili Yakurtikamu marlajukaja-ngkuya majani yawujayiti, wangkani-ngkuya yanku-jananyan ngangkulkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Ka-jananya Jiijajju wajarnu, “Ngayumili walyjakajaya yawujayiti yikini, ka ngayurna-janampa walyja. Karnara kujupakulurrju walyja nyinani, Mama ngarnawarrapurlukaku.” Maralu-jananya yilijunuka wajarnu, “Palujanu yiipinyurra Mamamili walyjakaja nyinani, ngayukujuyan walyjakaja nyinani. Karlkinpanyurra yakurtiyurujunyurra nyinani. Kajunyurra karlki kujupa mamayuru nyininpa. Ka karlki kujupajunyurra marlangukajayuru nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yiipi martukajalunyurra Mamamili wangka kulilku, ka junga nyinaku, ngayumili walyjakajajunyurra nyinaku, karlkijunyurra marlangukaja nyinaku, ka karlki kujupajunyurra yakurtikaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","2","Palujanu mayangka-jananya wangkayungu junu yanu. Ka yanu kalyu yini Kaliliyakarti. Yarnngaya martu kujungkarringu ruumuparniya nyinapayi. Jiijajpa takarnu puutja nyinapayi. Nintilpayi-jananya puutjalu. ");
INSERT INTO mpj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wangka yumuwanpa-jananya wajalpayi. Jilanya-jananya wangka kujupa yumuwanpa nintijulpayi, “Ngangkulaya! Kaatanmayapurluka kaatanmayakarti yanku wilyki warningku, pakalkuraku mirrka. ");
INSERT INTO mpj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wilyki karlki yiwarrangka punkalku ka marlalu pilurnju yanku ka ngalku-jananya wiyalku. ");
INSERT INTO mpj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Karlki wilyki punkalku yapulyukurrungka, parna julijulingka. Marla pakara tikirlarriku, parnaparningka, yapulyukurrungka. ");
INSERT INTO mpj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jirntulu wakara tikirlmanku. ");
INSERT INTO mpj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Karlki wilyki punkalku jilkarnkurrungka. Purtu pakara ngaraku, julijuliwiyaju. Jilkarnju putamanku mirta pakalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Karlki wilyki pakalku parna kunyjunyungka, mirrkawintirriku. Karlkiya pakalku mirrka majuwinti, karlkiya pakalku mirrka juliwinti, karlkiya pakalku mirrka yupalwinti.” ");
INSERT INTO mpj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jiijajju-jananya wajarnu, “Wangka palukajanyurra kuliraka junga nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Palujanu wangka-nintikajaluraya japinu Jiijajpa, “Nyaaku-jananyan wangka paluyuru yumuwanpa nintini?, purtuya ngangkuni, mirtaya kuranarrini.” ");
INSERT INTO mpj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka-jananya Jiijajju wajarnu palumili wangka-nintikajangka, “Ngayulurnantaya nyurrartinja ngayumilikajangka rawalu wangka nintilpayi turitpala, mirtarna-nyurranya yumuwanpa nintilpayi. Nintilpayirnantaya yaaluntaya Mamalu palumili walyjakaja kunyjunyulu kanyilku. Karna-jananya martungka yarnngangka mirta jilanya nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Martu karlkilunyurran ngayumili wangka ngangkuraka nintirringu, kanyurran ngangkulkuka yarralku nintirriku, palujanunyurran ninti yiltaminyirri nyinaku. Ka martu karlki jiikajaluya ngayumili wangka ngangkuraya, mirta nintirrini. Jiikajaya martukaja ngurrpayuruya nyinani, mirtajuya ninti. ");
INSERT INTO mpj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Martukaja jiiyuru ngurrpajuraya ngayuku nyinani, palujanurna-jananya wangka yumuwanwiyajurna-jananya nintilpayi. Ngayumili wangkakuraya mirta nintirrini, ngangkurakaya ngurrpayuru nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Julyjuminyirri Mamamili jakurlpurlukalu Yayijayalu jilanya wakarnu, ‘Mamalu wajarnu. Martukajaluya ngayumili wangka ngangkuraka ngurrpayuru nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Palukajalurniya purtu ngangkulku, jumajiya jankanyjankany. Jampaya jankapunajalu kunyjunyulu ngangkulngara, kajuya nintirringara, palujanuyilaparna-jananya wankalngara.’” ");
INSERT INTO mpj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yarrarnu Jiijajju wajarnu, palumili walyjakajaku, “Yiltamartanyurran nyurrartinpa mirtanyurran jankanyjankanypa, ngangkuninyurran Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Wangka ngaanyaya kulila! Julyjuminyirri Mamamili jakurlpurlukakajakamu martu kujupakaja Mamamili walyjakaja julyjuya nyinapayi. Ngayurna Kurayijpa marla yanurni parnakarti. Palurtinjuya julyju wajarnu, ‘Mayitpila kuwarri nyaku Kurayijpa, Mamalu kurtingku ngarnawarrapurlukalu. Ka-lanyangku mayiti jakurljulku Kurayijju, Mamalu kurtingunyjajanu.’ Pakilyu mirtarniya nyangu, Kurayijpa.” ");
INSERT INTO mpj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yarrarnu-jananya Jiijajju wajarnu palumili wangka-nintikajangka, “Ngangkulaya!, ngaarnantaya nintilku wangka jiinyarna-jananya martukajangka purtu nintirnu, martu kujulu wilyki liwarrpungkupayi. Martu kuju jii wilykipurlukayuru Mamamili wangka nintipurluka nyinani, palulu-jananya parra wajalpayi Mamamili wangka jilanya, ‘Mamalu-nyurranya ngampurrju kanyilku palumili walyjakaja.’ ");
INSERT INTO mpj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wilyki karlkinpa yiwarrangka punkanu, ka pilurnju yanu ngalangu wiyanu. Jampa Mamamili nintipurlukalu Mamamili wangka nintijulku palujanuyila martulu kulilku junku, jumaji malpumili maajalu muunpungku wangka jiikura ngakumparrikura. Malpu palunyanga pilurnyuru, jii pilurnju yanu ka ngalangu wilykikaja wiyanu, palunyayuru malpulu martu ngakumpani, kuliljaku Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wilyki karlkinpa yapulyukurrungka punkanu. Wangka jiiyuruya wilykiwanyuru martu karlkilu Mamamili wangkaya kulilku, karaya pukurlarriku. ");
INSERT INTO mpj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ngulampa martulu-jananya yanku muunpungku Mamaya junkuraku. Palunyakajaluya Mama junku ka pakirriku, wilykiyuru yapulyukurrungka punkara ka, tikirlarringu pakirringu, palunyayuru. ");
INSERT INTO mpj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Karlki wilyki punkanu jilkarnkurrungka, jilkarnju putamanu. Wangka jiiyuru jilkarnju putamanu, martu karlkiluya Mamamili wangkaraya kulilku. Kaya junga rawa nyinaku. Palunyajanuya wamakamu maniwiyaju kulinmalpa, palujanuyilaya Mama junku yanku. Ka wamalukamu manilu-jananya putamanku, jilkarnyurulu, jiilunga wilykikaja putamanu, pakaljakuya. ");
INSERT INTO mpj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Karlki wilyki punkanu parna kunyjunyuwana, ka mirrkakajawinti pakanu. Karlkinpaya mirrka majuwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya wululu Mamamili warrkamu parra ngapinmalpa. Karlkinpaya mirrka juliwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya rawaparnilu Mamamili warrkamu parra ngapinmalpa, kaya warrkamu junku yanku. Karlkinpaya mirrka yupalwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya yupal tayimulu Mamamili warrkamu parra ngapilku, kaya warrkamu junku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Palujanu-jananya kujupa Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku, jilanyayuru-jananya kanyilkuraku. Martulu kaatanmayapurlukalu karrpungkalu yanku-jananya wilykikaja parra liwarrpungku, kaatanmayangka. ");
INSERT INTO mpj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Palujanu jampa mungajarrarriku yanku marlaku martu palumili mayakarti ka kunyalarriku. Ka martu kujupa mungangka yankulura marlapungkuka wilykikaja walykukaja liwarrpungku, jiingkamarra martu kunyala ngarrini, palumili kaatanmayangka. ");
INSERT INTO mpj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka-jananya kaatanmayapurlukalu kurlunga wajalku kurtingku martu kujupakajangka yankuraya nyakuraku mirrkawintirringuya, karaya yiltalu yanku nyaku. Nyaku-jananyaya kunyjunyukajangka walykukajaluya pakarnu mirrkapunajakaja. ");
INSERT INTO mpj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaluya marlaku yanku wajalku maajangka, ‘Nyuntulun julyju parra liwarrpungkupayi wilykikaja, palunyangkaluya kunyjunyukajangka pakarnu, wilyki walykukaja, mirrkapunajakaja. Kajiya wanyjajanu mirrkapunajakaja walykukaja yikini?’ ");
INSERT INTO mpj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ka-janampa maajalu wajalku, ‘Jiingampa ngayuku parlanyju yanu liwarrpungkupayi, walykukaja mirrkapunajakaja.’ Kaluya maajangka japirnu, ‘Kajilaju marlaku yanku walykukaja wulykulkunirra?’ ");
INSERT INTO mpj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ka-janampa maajalu wajalku, ‘Paki, jurra-jananya!, mayiti-jananyanyurran mirrka kunyjunyuwintilurrju yilalkurtanirra. ");
INSERT INTO mpj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jampa mirrkakaja munyjulyarriku martu karlkiluya warrkamupurlukakajalu kurlunga yanku nayipuwintilu katupungkunirra mirrkawinti kunyjunyuwintikaja. Wajalkurna-jananya “Mirrkapunajakajanyurra-jananyan wulykulkunirra ka kujungkalku, karrpilku, ka kangku warungka warningkunirra. Ka-jananyanyurran mirrkawintikaja manku ka kujungkalku ka kangku junku mirrkapintingka, ngayumili mayangka.” ’” ");
INSERT INTO mpj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Palujanu-jananya Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku. Jilanyayuru palunya tayimu nyinaku. Martulu mankula katiku wilyki jukujuku parnangka jarrpajunku. ");
INSERT INTO mpj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kayila kalyu punkalkulu palungka. Kujarra wiikingka, warta palunya pakalku yiltangulyu ngaraku parrkakurlurriku. Palunyajanu walyjiyila puri majurriku, ka wilykikurlurriku. Yiltangulyuya pilurnkaja yankurniya jiikarti walyjikarti purikarti, mirrkaku. Kaya wulu nyinaku warta palunyangka. Kayilaya niijpaya palyamanku wartangka, kaya jiingka nyinaku. Yilta palunya wilyki jukujukujanu wartarriku ka majurriku yikiku.” ");
INSERT INTO mpj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Palujanu-jananya kujupa Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku. Jilanyayuru palunya tayimunga nyinaku. Jampa wanti kujulu pikinpawutu pulawangka kujungkalku, kalu kalyu yintilku, ka murlimurlilku, palujanu warungka junku. Kayila pakalku majuwarta, jumaji pikinpawutujanu.” Jii pikinpawutu julijuliyuruya Jiijajmili walyjakaja yupalpa nyinani. Palujanuya palukaja maapurriku, yarnngaminyirriya nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","35","Jiijajju-jananya martukajangka wangka yumuwanpa wajalpayi, martu karlkiluya kulilkuraka nintirrira, ka karlkinjuya mirta kulira nintirrira. Ngaanya jilanya Mamamili wangka jakurljunu-jananya julyju, Mamamili jakurlpurlukalu jilanya wajarnu. Wangka ngaanya yiltarringu. “Martukajangkarna-jananya parra wajalku, wangka yumuwan. Wangkarna-janampa julyjujanu miralmalku. Ngaanya wangka mirtaya ngangkulpayi julyjukurlu, kuwarriwiyajurna-jananya miralmalku, ngurrparaya.” ");
INSERT INTO mpj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jampa-jananya Jiijajju martukaja junu yanu, ka yanu kurrungu mayangka, nyinapayiyilapa mayangka kaninyjarra. Jiijajmili wangka-nintikajaluya yanu Jiijajjaluya wajarnu, “Nintila-lanyaju!, wangka-jananyan yumuwanpa martukajangka wajalpayi mirrka kunyjunyukamu walykuwanpa, palunya.” ");
INSERT INTO mpj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","38","Jiijajju-jananya wajarnu, “Kaatanmayapurlukanga ngayuyuru nyinani, martukurna-janampa yarnngaku marlpa, paluyuru. Kaatanmayapurlukalu martulu parra liwarrpungkupayi, wilykikaja kunyjunyukaja. Paluyururna ngayulu parra wajalpayi Mamamili wangkarna-jananya martukajangka yarnngangka. Karlkiluya martulu ngayumili wangka ngangkuraka kunyjunyuya nyinani, wilyki kunyjunyuyuru. Yiltalu-jananya Mamalu ngampurrju kanyini. Ka wilyki walyku mirrkapunajayuruya karlki martukaja walyku nyinani, malpu-janampa maaja nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Martu kujupa mungangka yanulura marlapunguka wilykikaja walykukaja liwarrpungu. Martu jiiyuru malpunga nyinani. Malpulu-jananya martukaja muunpungkuni, walykuya nyinaraku, wilyki walykuyurukaja. Jampa mirrkakaja munyjulyarriku martu karlkiluya warrkamupurlukakajalu kurlunga yanku nayipuwintilu katupungkunirra mirrkawinti kunyjunyuwintikaja. Martu jiinya warrkamupurlukayuru Mamamili wikarrukaja paluyuruya nyinaku. Kurlunga-jananyaya kuutja martukaja kujungkalku, yikikuraya, Mamamili wikarrukajalu. ");
INSERT INTO mpj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Ngayulurna-jananya Mamamili wikarrukajangka wajalku kurlunga, yanku-jananyaya mankuraku martukaja walykukaja, kangkura-jananyaya yikijulmalpa kujungka. Walykukajalu jiikajalu-jananyaya martu karlki kunyjunyukaja walykulpayi. Jiikaja-jananyaya martu walykukaja kangkura warningkumalpa warungka, Mamamili wikarrukajalu. Warungkayilapaya wulu kampamalpa, purtuya yulamalpa. Palunyayuruya Mamamili wikarrukajayuru warrkamupurlukakajalu mirrkapunajakaja wulykulkunirra ka kujungkalku, karrpilku, ka kangku warungka warningkunirra. ");
INSERT INTO mpj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Palungka tayimungkanga Mamamili wikarrukajalu-jananyaya martukaja Mamamilikaja walyjakaja, yanku manku, kangku Mamamilingka ngurrangka, kunyjunyu junku, Mamalu-jananya kanyilkuraku pukurlpa. Jiingkaya kujupayururrikuya, nyinamalpaya jinajina wayitwanwintiyuru. Wangka palukajanyurran ngangkuraka junga nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Palujanu-jananya kujupa Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku, Jilanyayuru palunya tayimu nyinaku. Martu kujupalu parra yanku parna kujupangka ka parra ngurrilku kuulukura, nyakuyilapa, parnalu jutulku, martu kujupalu nyakujaku. Palujanu pukurlarriku marlaku yanku ngurra walyjakarti, ka jalamulkuyingku maya walyja, parna walyja, ka mani manku. Yanku marlaku maniwinti ngurra palukarti kuuluwintikarti. Yankulu payamulku maajangka, ngurra kuuluwinti wululu kanyilkuraku. Mirtalu maaja jiingka wajalku, kuulu ngarrinyjajanu, paki, kukujunkulura. Martu jiilu kuuluku layikamurrira kanyilku. Martu jiiyuru Mamalu palumili walyjaku layikamurrira kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Palujanu-jananya kujupa Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku. Jilanyayuru palunya tayimu nyinaku. Martu kujupa yapupurluka warrkamurriku yapukaja parra mankuraku. ");
INSERT INTO mpj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Palulu martulu yapupurlukalu yanku nyaku martu kujulu yapu kanyini tayimunpa yapu puukuwana. Ngangkulku jilanya yapupurlukalu, ‘Yapu jiinya juriminyirri kanyini.’ Yapupurluka jiinya marlaku yanku ngurra walyjakarti ka jalamulkuyingku maya walyja, parna walyja, purnunkajalurrju, kayila mani manku. Ka yanku marlakulu ngurra palukarti, ka nyaku jiinya martu yapu kanyini tayimunpa puukuwana. Yankulu payamulku, martungka palungka.” Martu jiilu tayimunku layikamurrira kanyilku, martu jiiyurulu Mamalu palumili walyjaku layikamurrira kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Palujanu-jananya kujupa Jiijajju wajarnu, wangka ngaanya yumuwanpa, “Mamalu-jananya palumilikaja ngampurrju kanyilku, jilanyayuru-jananya kanyilkuraku. Karlkiya yanku warrkamupurluka piijpaya mankuraku. Jinanguluya parra warningkumalpa niitingpa, kaya piijkaja yarnnga yilalmalpa, kujupa kujupa piijkaja. ");
INSERT INTO mpj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Yilaraya kangkura parnangkaya junku niitingpa piijwinti. Kaya wirningkaya mankuraka piijkaja kunyjunyu yintara junkunaku wirningka, ka piijpa walykukajanga marlaku warningkumal kalyungka. ");
INSERT INTO mpj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Jiikajaya warrkamupurlukakaja Mamamili wikarruyurukaja. Kurlungaya Mamamili wikarrukajalu-jananyaya parra yanku martukaja walykukaja manku piijyuru walykuyuru jilanya. Ka-jananyaya walykukaja kangku warningku warungka. Warungkayilapaya wulu kampamalpa, purtuya yulamalpa.” ");
INSERT INTO mpj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka-jananya wajanu Jiijajju palumili wangka-nintikajangka, “Wangka palukajarnantaya nintilpayi, kajinyurran ngangkura nintirrini?” Karaya yuujunu palumili wangka-nintikajalu. ");
INSERT INTO mpj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jiijajju-jananya wajarnu, “Ngangkulaya! Muujajmili wangkapurlukakaja, karlkijuya ngangkuraka ngayuku walyjarringu. Mamalu-jananya yilta ngampurrju kanyilku. Jiikajaya martu Muujajku luwuku ninti nyinani, karaya ngayumili wangkakulurrjuya ninti nyinani. Ka-jananyaya jiikajalu nintiminyirrilu ngayumili walyjakaja nintijulku.” ");
INSERT INTO mpj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jilanya-jananya Jiijajju yumuwanpa wangkakaja wajalpayi, ");
INSERT INTO mpj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kayilapa yanu marlaku tawun walyjakarti. Palumili wangka-nintikajalurrjuya kujungka yanu, kangu-jananya Jiijajju. Jiingka tawunja yanu kurrungu Juwumilingka jaajingka. Jiingka jaajingka Jiijajmili wangkaya ngangkunuka kuruya pakarnu. Kayilaya karlkinga ngunjul ngunjularringu, kaya wajarnu, “Yiltaminyirri ngaanya nintipuka. Wanyjangkara nintirringu? Palulu-janampa yalyjirrjujaru kujupa kujupa ngapini. ");
INSERT INTO mpj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ngaanga Miirimilikamu Juujapmili kaja. Juujappa jiinya kapantamarta warrkamurrini. Palukuraya marlajukaja ngaangka nyinani, ngapimapu?, Jayimijpa, Juujappa, Jayimunpa, Juutajpa. ");
INSERT INTO mpj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Palumiliraya marlajulurrju nyinani wantikaja. Ngaanga parnapurluka, mirta ngarnawarrapurluka.” ");
INSERT INTO mpj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jankapayiluya jilanyalu, mirtaya ngangkulpayi, Mamakura kaja ngarnawarrapurlukaku. Jiijajju-janampa wajarnu, “Jampa Mamamili jakurlpurlukarna-jananya yankupayi ngurra kujupakarti martujuya pukurlarripayi. Ka ngayumili tawunja martujuya ngaamartaji mirta pukurlarrini, ngayumili walyjalurrjujuya mirta pukurlarrini.” ");
INSERT INTO mpj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Palungka tawunja mirta-jananya Jiijajju wankalpayi ngarntakaja, mirta-janampa maparnpa nintilpayi, jumajiya mirta ngangkunu Jiijajpa Mamamili maparnwinti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","4","Yirutkura marlaju nyinapayi Pilapu. Pilapu nyinapayi wantiwinti, wanti palunya yini Yirutiyajpa. Yirutjulu nyangu palu wantingka, kalu mamarnulu palumili marlajungka Pilapungka, rawaluyila kanyilpayi, Yirutju. Jaanju kalyupurlukalu julyju nyangu kalu wajarnu, “Jurra!, nyuntumili marlajukura wanti!” Rawalura wajalpayi Jaanju, junkuraku. Jampa Jaanju marrkurnu junkurakura wanti, Yirutiyajju Yirutja muunpungu, ka-janampa wajarnu, palumili warrkamupurlukakajaku, mankuya Jaanpa kurrujulkuraku jiilja. Kaya manu jiilta kurrujunu. Rawa nyinapayi jiilja. Jiinwintiluya karrpirnu jina pakara yankujaku, jiiljanu. ");
INSERT INTO mpj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yirutju ngangkulpayi pungkuraku Jaanpa. Yarrara ngangkulpayi, “Martuluya yarnngalu ngangkuni Jaanpara Mamamili jakurlpurluka. Jiikajalurniya wirrilyirrira pungkujaku, mirtarna kuwarri pungku, paki, kurlungarna pungku.” ");
INSERT INTO mpj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yirutkura paajayi nyinapayi. Warrkamupurlukakajaya wumurripayi, mirrkaraya ngalkuraku paajayi. Palunyangka wanti Yirutiyajku yurntalpa yanurni-janampa nyarnpipungkuraku, nyakurakuya, martukajalu. Nyanguya wanti kuju nyarnpingu pakirringu, karaya pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Palunyangkara maaja Yirutpa pukurlarringu wantiku, kalu japirnu wantingka, “Jamparnin japilku, yungkurnanta nyaa nyirrinyirri. Japilarni!, nganakuran?, karnanta yiltalu yungku.” ");
INSERT INTO mpj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Palunyangka wanti palulu yanura japirnu Yirutiyajpa, palumili yakurti, “Nganarnara wajalku?” Yirutiyajjura wajarnu, “Yarralu wajala pungkuraku Jaanpa!, ka pulayitingka kata junkuraku, kanta kangku yungku.” Jaanpa palu kalyupurluka nyinapayi. Marlakulu yanu wanti palu wajarnu, Yirutja, “Jaanparni yuwa pulayitingka kata!” ");
INSERT INTO mpj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jampa Yirutju ngangkurnu kayilapa ngurlurringu, ka kulinu, “Yiipirna-jananya wajalku Jaanpaya mitu pungkuraku, kayilaparniya martukajalu pungkujaku, jumajiraya Jaanku pukurlarrini.” Jilanyalurrju Yirutju ngangkurnu, “Kaanparnalu wantingka paki kajalku, yiltarnara wajarnu, yungkuraku nyaa nyirrinyirri wanti palungka, martu yarnngangkarnara wajarnu, kurungka.” Yumurringu kurtingu-jananya palumili warrkamupurlukakaja, Jaanpaya pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yanuya jiilkarti, punguya Jaanpa, kataya putarnu tawunpungu, kaya pulayitingka junu. ");
INSERT INTO mpj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kanguraya wanti yungu Jaanpa kata pulayitingka. Wantilu manu kangura yungu palumili yakurti, Yirutiyajpa. ");
INSERT INTO mpj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jaanmili wangka-nintikajaluya ngangkurnu Jaanpa miturringu. Kaya yanu jiilkarti, manuya Jaanpa kanguya jampajunu. Kaluya yanu Jiijajja jakurljunu. Yirutpa maaja maju nyinapayi Kaliliyangka martuku-janampa, Kaliliyapurlukaku. Yirutju ngangkurnu Jiijajju-jananya wankalpayi, martukaja, ka ngangkurnu Yirutju, “Pakimpa, Jaanpa pakarnu mitujanu, ka-jananya parra wankani.” Palujanu warrkamupurlukakajaku-janampa wajarnu Yirutju, “Jiinyaya martukajalu wajani Jiijajpa. Ngayulurna ngangkuni Jaanpa, marlaku wankarringu mitujanu, ka palulu-jananya wankarni, maparnju.” ");
INSERT INTO mpj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jiijajju ngangkurnu jakurlpa, Yirutmapuluya Jaanpa pungu miturntarnu. Palujanuya puutja tatirnu yanu kalyu majuwana yini Kaliliyawana, Jiijajmili wangka-nintikajalurrju. Ngangkurnuya, “Yankula warrarn kujupakarti martupunajawanala nyinaku.” Jiijajpa puutja tatirnu martukajaluya nyangu, kaya jayitiwana yanu kalyungka yini Kaliliyangka. Jampa-jananyaya tawunpa kujupajanulu nyangu kujungkarringuluya wanarnu. Yanuya kurranyurringuraya majalpayiya. ");
INSERT INTO mpj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jiijajmapuya kuwarrara yankupayirni kalyungka kutuwana puutja. Kaya yanu parnangkarringu. Jampa Jiijajpa tipukarnu puutjanu nyangu-jananya yarnngaya martukaja parra yikipayi. Jampa-jananya nyangu nyarrurringu-janampa, ka-jananya wankalpayi karlki martukaja, ngarntawintikaja. ");
INSERT INTO mpj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jampa yukarturringu palumili wangka-nintikajaluya wajarnu, “Nyawa!, yukarturrini. Wajala-janampa yankurakuya!, yanku-ngkuya mirrkakaja payamulkuraku, pakingka mirrkapunajangka warrarnwiyaju.” ");
INSERT INTO mpj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jiijajju-janampa wajarnu, “Paki, kaanpaya yanku, nyunturtinju-jananyaya yuwa mirrka!” ");
INSERT INTO mpj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jiijajparaya wajarnu, palumili wangka-nintikajalu, “Ngaangalaju kanyini payip wulikaja karlukarlu japuwartakaja, ka kujarra piijpa.” ");
INSERT INTO mpj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jiijajju-janampa wajarnu, “Kawarniya mirrka palunya, piijpalurrju!” Karaya manu yungu, wangka-nintikajalu. ");
INSERT INTO mpj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Palujanu-janampa wajarnu Jiijajju martukajaku nyinarakuya parnawana yukuringka. Ka karlukarlukamu-pulanya piijpa manu marangka ngalurnu, ka ngarnawarra nyangu, kalu Mamangka wangkangu, “Mama nyuntulu-lanyajun mirrkakamu piijpa yungkuni, kalajunta marninypungkuni.” Palujanu mirrkakamu piij manu ka warlangkupayi, yungkupayi-jananya wangka-nintikajangka. Ka-jananyaya wangka-nintikajalu yungkupayi martukaja, mirrkakamu piij ngalkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kaya ngalangu parljarringu yarnngalu. Karlkiluya ngalkula junkupayi parnangka. Wangkanintikajaluya turampungka parra mankupayi, martuluya mirrkakamu piijpa, ngalanguya junujajanu. Jii turampukaja tuwal wulikaja parraya kangkupayi wangka-nintikajalu. Turampukajangka mirrkakaja majurringu. ");
INSERT INTO mpj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jilanyaya martuya yirnakajanga payip jawujunpa nyinapayi, wantikamu ngulyikajalurrju, yarnngaminyirri. ");
INSERT INTO mpj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jiijajju-jananya wajarnu wangka-nintikajaku, puutjaya tatira yankuraku kurranyu ngurra kujupakarti. Palu nyinangu wajalkuraku-jananya martukajangka marlakuya yankuraku ngurra walyjakutu. ");
INSERT INTO mpj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Palujanu Jiijajpa kujurringu yanu yapukarti, yanulu Mamangka wangkangu. Wangkangulu mungajarrarringu. ");
INSERT INTO mpj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Puutpaya Jiijajmili wangka-nintikajalu yurntulpayi wartawintilu, kalyungka kutungka, wangalju-jananya marlaku yurntulpayi, ka-janampa puutpa kalyulu murlimurlilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jirntu raakangkupayi Jiijajpa-jananya yankupayirni kalyungka ngarnawarra, ");
INSERT INTO mpj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","jampaya nyangu ngurlurripayiya. Kaya wajarnu, “Kuurtirni yankuni!”, kaya ngurluwinti mirrangu. ");
INSERT INTO mpj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jiijajpa-janampa wangkangu, “Mirtanyurra ngurlurri!, ngayurna-nyurranya yankuni.” ");
INSERT INTO mpj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kara Piijalu wajarnu, “Maaja! Kajin yilta nyuntu? Wajalarni yankurakurnanta kalyungka ngarnawarra!” ");
INSERT INTO mpj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kara Jiijajju wajarnu, “Yarrarni!” Kalu Piija tipukanu puutjanu yankupayilu kalyungka ngarnawarra. ");
INSERT INTO mpj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wangalpa ngangkurnu yankupayirni, ka Piija ngurlurringu, ka kalyungka mawu kurrungu. Ka Piijalu wajarnu, “Maaja! Ngalularni!, kalyungkarna kurrungkurta.” ");
INSERT INTO mpj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka Jiijajju wirrurrulu ngalurnu, “Nyaajanun nyuntu ngurlunyngurlunypa? Mirtarnin ngangkurnu, ngayulurnanta kalyungka ngarnawarra kunyjunyulu kanyilpayi maparnju.” ");
INSERT INTO mpj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Palujanu jampapula kujarrangulyu maa yanu puutja tatirnu, wangalpa pakirringu. ");
INSERT INTO mpj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Palunyangkaya Jiijajmili wangka-nintikajalu marninypungu, “Yilta ngaanga Mamamili kaja.” ");
INSERT INTO mpj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ka palujanu yanuya kartanypunguya kalyu Kaliliyangka. Yanuya pakarnu parna ngapi?, yini Kinijaritpa. ");
INSERT INTO mpj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jiingkaya karlkilu martulu nyanguya nintiraya Jiijajpa palu yikurntanuya. Karaya karlkilu martulu kurtingu ngarntakajaku. Ngurra yarnngajanu-jananyaya ngarntakaja kangkupayirni Jiijajju-jananya wankalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jiijajpa-jananya yanu karlkiluraya japirnu pampulkuraya, kuurtu ngarntakajalu. Jiijajpa-jananya kutungka yankupayi, kaya pampura kunyjunyurripayi ngarntakajalu. ");
INSERT INTO mpj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palujanu Muujajmili wangkapurlukakajakamu Parajikaja tawunpa Jarujalumjanuya yankupayi. Yanuluya Jiijajkarti, ");
INSERT INTO mpj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","kaluya Jiijajja jilanya wajarnu, “Nyuntumili wangka-nintikajaluya mitunyjarrimili luwu ngangkuraya junkuni. Mirta-ngkuya mara waajamuni mirrkaya ngalkuraku, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jiijajju-janampa japirnu, “Nyaakunyurran Mamamili wangka ngangkuraka junkuni, nyurrartinmili mitunyjanirrimiliku wangkakuranyurra nyurirrini? ");
INSERT INTO mpj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Julyju-lampa Mama ngarnawarrapurlukalu wajanu jilanya, ‘Mamakamu yakurti-pulanyaya ngampurrju kanyila!, mirta nyurnimankuraku, kunyjunyulunyurran kanyilkuraku.’ Ka wangka kujupa ngaanya Mamalu wajanu, ‘Jampa-pulanya mamakamu yakurti nyurnimalku, martu palunyanyurran pungku miturntalku jumaji nyurnipayi.’ ");
INSERT INTO mpj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wangka paluyurukajanyurran ngangkuraka junkuni, ka-jananyanyurran pakiwana parra nintijuni jilanya, ‘Jampanyurran manikamu purnunpa manku, mirtanyurran yakurtikamu mamarti yungku, jurraya!’ Jilanyanyurra pakiwana nintijuni. Jilanya-jananyanyurra pakiwana wajani, ‘Mama ngarnawarrapurlukakurnara ngaanya manikamu purnunpa yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jilanyanyurra-jananyan nyunturtinju nintini, pakiwana yakurtikamu mamarti nyakura junkuraku, maningkunyurra walyja kanyilkuraku. Mamamili wangkanganyurran warlangkuni, Parajikajalu, nyunturtinmili mitunyjanirrimili kurannyurran nyurirrini. ");
INSERT INTO mpj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","8","Mayunyjuyurunyurra nyininpa, mirta-jananyanyurra Mamamili wangka jungalu nintini. Julyju Mamamili wangka jakurlpurlukalu Yayijayalu wajarnu-nyurranya mayunyjunyurra nyinaku. Jilanya wajarnu, ‘Mama ngarnawarrapurlukalurni wajarnu. Ngulaya martukaja mayunyju nyinaku. Jaaluwiyajurniya wajalku, mirtarniya yiltalu marninypungku. ");
INSERT INTO mpj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Purturniya marninypungku mitunyjarrimili luwuwanaya nyinakijalu. Mirta-jananyaya ngayumili wangka nintijulku, pakiwanaya wulu nyinaku.’” ");
INSERT INTO mpj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","(Juwukajalu-ngkuya murrarnilu mara waajamunkupayi ngalkuraku, mitunyjanirrilu wajanyjangka. Tawunja payamunuraya katipayi, mirrkakamu kuka. Murrarnilu-ngkuya mara waajamulpayi mirrkakamu kuka ngalkuraku. Parajikajaluya kulilpayi jilanya. Jampa martulu mara waajamunkuparnilu ngalku, Mamamili luwu warlangku.) Jiijajju-jananya martukajaku mirrangu kujungkanu, ka-jananya wajarnu, “Wangka ngaanyaya ngangkula! Jampa martulu mara waajamulkuparnilu ngalku, mirta Mamamili luwu warlangku. Jampa martulu jaalu martu kujupa warrkilku, ka nyurnimalku palujanu Mamamili luwu warlangku.” ");
INSERT INTO mpj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jiijajmili wangka-nintikajaluya yanu Jiijajja wajarnu, “Wangkan jiinya nyuntulu kuwarri wajarnu, Parajikajaluya kulirnu kaya wirrilyirringu.” ");
INSERT INTO mpj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ka Jiijajju-janampa yarrarnu wajarnu, “Yarra-janampaluraya Parajikajangkamarra!, jumajiya mayunyjuyuru nyininpa. Mamamili wangkaya mirta jungalu nintini, pampuruyuruya nyininpa. Martu pampurulu kujupa martu winira kangku, kapula punkalku pirtingka. Palunyayuruya pampuruyuru Parajikaja nyininpa, mirtaya jungalu martukaja nintini, paki. Parajikajaya nyininpa wartayuru mirrkaparni. Kaatanmayapurlukalu-jananya ngula yukulku warningku warukarti.” ");
INSERT INTO mpj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piija wangkangura Jiijajku jilanya, “Wangka jiinya-lanyaju nintijula! Jampa martulu mirrka waajamulkuparnilu ngalku, mirta Mamamili luwu warlangku. Jilanya-lanyaju nintijula!” ");
INSERT INTO mpj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka Jiijajju-jananya wajarnu, “Kaji ngurrpanyurra? Mirtanyurra ngayumili wangka kulini? ");
INSERT INTO mpj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ngangkulaya! Martulu mirrka waajamuraka ngalkuni palujanu mirrka nyuruwana yankuni. Ka pakirrini jampa yankuni tuyilitkarti. Mirta Mamamili luwu warlangkuni, yiipi mirta mara waajamulkuraka ngalkuni. Kunyjunyulunyurra kukakamu mirrka ngalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yiipi martulu kulilku walyku ngapilkuraku, ka yanku walyku ngapilku, jiilunga Mamamili luwu warlangkuni. ");
INSERT INTO mpj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yiipi martulu kulilku martu kujupa pungkukijalu, ka palujanu yankuka pungku, jilanyanga yiltalu walyku ngapini. Yiipi martulu kulilku martu kujupamili wartakaja wululu kanyilkuraku, ka palujanu yanku mankuka wulu kanyilku, jilanyanga yiltalu walyku ngapini. Yiipi martulu kulilku martu kujupangkalu kajalkuraku, ka palujanu yankulu palungka kajalku, jilanyanga yiltalu walyku ngapini. Yiipi martulungku nyupa walyja junku yanku, ka yanku nyupa kujupangkalu ngarriku, jilanyanga yiltalu walyku ngapini. Yiipi martulu martu kujupa nyurnimanku, jilanyanga yiltalu walyku ngapini. ");
INSERT INTO mpj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yiipi martulu kulilku jilanyayurukaja walykukaja ngapilkuraku, ka yanku walyku jiikaja ngapilku, jiilunga Mamamili luwu warlangkuni, yiltalu walyku ngapini. Yiipi martulu kukakamu mirrka ngalkuni, mara waajamulparnilu, mirta Mamamili luwu warlangkuni, paki, ka mirta jilanyalu walyku ngapini. Jilanya Parajikajaluya pakiwana nintilpayi.” ");
INSERT INTO mpj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngurra jiinya Jiijajju junu yanu, kayiliya yanu ngurra kujupakarti, palumili wangka-nintikajalurrju, tawun Taayangkakamu tawun Jayitanja ngaparti. ");
INSERT INTO mpj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wantilu jiimartajilu Juwuparnilu nyangu Jiijajpa, ka wajarnura, “Nyarrurriwaju!, yurntalpaju yarra kunyjunyula! Mitunyjarripurluka Tayipitku nyuntun nyinani marlajanu, Kurayijpa. Ngayumili yurntalpa ngarnta maju nyinani malpuwinti.” ");
INSERT INTO mpj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jiijajju ngangkunu yakayila yankupayi. Palumili wangka-nintikajaluluya yanu wajarnu Jiijajja, “Wantilu jiilu-langku marlakartilu wanani, nyurilu-langku wanani wiltu wangkani, ‘Yurntalpaju kunyjunyula!’” Wajarnuluya Jiijajja, “Jii wanti wajalalu yankura!” ");
INSERT INTO mpj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jiijajju-janampa wajarnu, “Mamalu ngarnawarrapurlukalurni kurtingu Juwukajawiyajurna-jananya nintilkura, ka kunyjunyulkura, Yijurilmili marlajanukaja, mirtarna Juwuparni kunyjunyulkura. Ngayumili walyjakaja Juwukaja jiipuyuruya nyinani, maajaparni.” ");
INSERT INTO mpj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka wanti jiinya yanulu Jiijajkutu, kayila nyinangu murtingka ka pupangu. Wajarnulu, “Maaja! Kunyjunyulaju yurntalpa!” ");
INSERT INTO mpj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wajarnura wantiku Jiijajju, “Mirtalajura mankura mirrka yungkuni jarntu, jijimili.” ");
INSERT INTO mpj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wantilura wajarnu, “Yilta wangka jiinyan wajarnu. Wangka ngaanya ngangkula! Jarntulu ngalkuni mirrka jijimili warningunyjangka, tiipulja kaninyjarra.” Wantilu jilanya wajarnu, Jiijajja, “Ngayulurnanta maparnwintingka jarntu jiiyurulu japirnin mirrkayuruku. Yurntalpaju wankala!, jii maparnwintilu.” (Juwukajaluya martu kujupa Juwuparni nyakuraka nyurnimankupayi jilanya, “Jiinya walyku, jarntuyuru.”) ");
INSERT INTO mpj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jiijajjura wajarnu, “Wanti! Ngangkunirnanta, yiltalun ngangkuni, ngayulurna-jananya maparnju kunyjunyuni. Japilpayirnin nyuntumili yurntalparna kunyjunyulkura, kuwarri kunyjunyurriku.” Palujanuyila yurntalpara kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Palujanuya Jiijajkamu palumili wangka-nintikaja yankupayiya kalyungka yirrirringka, yini Kaliliyangka. Palujanu Jiijajpa yanu takarnu yapungka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ngurra kujupajanuya martukaja yarnnga yanu kujungkarringuluya Jiijajja, ngarntakajawinti. Ngarnta jilanyaya, pampurukaja, mukuntukaja wangkapunaja, ngarnta kujupakajalurrju. Yanuluya Jiijajkutu, nyinanguluya jiikaja ngarntawinti. Ka-jananya kunyjunyunu, Jiijajju. ");
INSERT INTO mpj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Martu kujupaluya nyangu Jiijajju-jananya kunyjunyulpayi, nyangukaya kuru pakarnu. Jiikajalu-jananyaya nyangu pampurujanukajaya parra nyakupayi, mukuntujanukajaya parra yankupayi, wangkapunajajanuya wangkapayi. Palujanuya marninypungu Mama ngarnawarrapurluka. ");
INSERT INTO mpj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Palujanu Jiijajpa-janampa mirrangu palumili wangka-nintikajaku. Wumunu-jananya, ka-janampa wajarnu, “Martukajaku ngaakajakurna-janampa nyarrurrini, jumajiya mirrkaparnirringu. Karrpuparakuya ngaangka warrarnja nyinapayi mirrkaparni, wirrirlijanu. Mirtarna-jananya kurtingku ngurra walyjakarti, mayitiya kutungka yankura punkaljaku. Mirrkala-jananya ngaangka yungku.” ");
INSERT INTO mpj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kaluya japirnu, Jiijajpa, “Kaji wanyjangkala-janampa warrarnja manku mirrka maju ngaakajaku?” ");
INSERT INTO mpj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jiijajju-jananya japirnu, “Kajinyurra mirrkakamu kuwiyi kanyini?, mayiti paki.” Kaluya wajarnu, “Yuu. Ngaalaju kanyini piij japuwartakajakamu karlukarlu yupalpa, japan wulikaja.” ");
INSERT INTO mpj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jiijajju-janampa wajarnu martukajaku, “Nyinaya parnangka!” ");
INSERT INTO mpj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Palujanu Jiijajju manu piijkamu-pulanya karlukarlu, kalu Mamangka wangkangu, “Mama! Marninypungkunilajunta yungu-lanyajun ngaanya karlukarlukamu piij.” Palunyangka Jiijajju-jananya warlangkura yungkupayi, palumili wangka-nintikaja. Jiikajalu-jananyaya karlki martu kangkura yungkupayi. ");
INSERT INTO mpj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Mirrkakamu piijpa Jiijajju-jananya yalyjirrju majurnu yungkura wanarnu. Palujanuya yarnngaluya ngalangu parljarringu. Yirnakajaluya puu jawujun wulikajaluya, ngalangu ngilypikajalukamu jijikajalurrjuluya. Mirrka majuya purtu ngalangu, kaya karlki warningkupayi. Palujanuya wangka-nintikajalu mirrkakaja mankupayi, kaya pilamapulpayi japan wulikajangka turampukajangka. ");
INSERT INTO mpj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Palujanu-jananya Jiijajju martukaja kurtingu, kayilapaya Jiijajmapuya puutungka tatirnuka yanu parna Makatankarti. ");
INSERT INTO mpj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palujanuya Jaajmili maajakajakamu Parajikaja yankupayiluya Jiijajkarti. Wajarnuluya, “Nyuntulu yalyjirrju ngapila!, ka kulilkulajunta nyuntun yilta Mamamili.” Jilanyaya kulilpayi, “Yiipi Jiijajju pakiwana wajalku ngulala kuutja wajalku.” ");
INSERT INTO mpj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jiijajju-jananya wajarnu jilanya, “Rukangka yiipi martulu nyaku yurnturrparni kulilku, ‘Yungunpa kalyu mirta punkalku’ ");
INSERT INTO mpj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Palujanu yungunpa martulu pakalku nyaku yurnturrpa nyininpa kulilku, ‘Kalyulu-lanya kuwarri pungkukija.’ Yurnturrpanyurra nyakuraka kulirnin, kanyurra ninti nyininpa, karanyurra ngurrpa nyininpa Mama ngarnawarrapurlukalu yalyjirrju kuwarri ngapilku. ");
INSERT INTO mpj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mamamili wangkanyurra putalu kulira junkuni, kayilaparniyan japini yalyjirrjurna ngapilkura. Mirtarna-nyurrampa kuwarri yalyjirrju ngapilkura, paki. Jilanyawiyajurna-nyurranya wajalku. Julyju Juuna mituyuru piijingka nyurungka ngarripayi karrpu kujarrangka, ka wankarringu. Palunyayuru ngulanga nyinaku.” Palujanu-jananya Jiijajju junu yanu. ");
INSERT INTO mpj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Palujanuya Jiijajkamu palumili wangka-nintikaja puutungka tatirnu yanu. Yanuya parnakuturringu kayilapaya kulirnu jilanya, “Karlukarluparnirringula, mankurala kangkungararni.” ");
INSERT INTO mpj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Palujanu Jiijajju-janampa wajarnu jilanya, “Wurlkumartaya Parajikajangkamarra!, maaja jaajimili maajakajangkamarralurrju. Palukajaya puta nyininpa, pikinpawutuyuru.” ");
INSERT INTO mpj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Palunyangkaya purtuya kulirnu, ka-ngkuya japirnu, “Ngana-lanya wajarnu?, mayitpi mirrkala mirta kangkura.” ");
INSERT INTO mpj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jiijajju-jananya nintilu kulirnu, ka wajarnu-jananya, “Kulilngararninyurra ngayu Mamamili maparn majuwarta. Ngayulurna mirrkaparningka mirrka ngapilku. ");
INSERT INTO mpj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kulilngararninyurra ngayulurna julyju mirrka ngapilpayi. Ngayulurna-jananya martukaja karlukarlu payip wulikaja warlangu yungu. Palujanuya martulu payip jawujunju mirrka ngalangu, munkurringu. Kayilapaya karlkinpa mirrkakaja warningkupayi. Turampukajanyurra pilamapunu, mirrkakaja. Kaji turampu yupalpa yikipayi? ");
INSERT INTO mpj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kulilngaranyurra. Ngayulurna-jananya martu kujupakaja karlukarlu japan wulikaja warlangu yungu. Martukajalu puu jawujunkajalu ngalangu munkurringu. Kayilapaya karlkinpa mirrkakaja warningkupayi. Turampukajanyurra pilamapunu, mirrkakaja. Kaji turampu yupalpa yikipayi? ");
INSERT INTO mpj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mirtarna-nyurranya wajarnu karlukarluparni kangkuraku. Yarralkurna-nyurranya wajalku, ‘Wurlkumartaya Parajikajangkamarra!, maaja Jaajmili maajakajangkamarralurrju. Palukajaya puta nyininpa, pikinpawutuyuru.’” ");
INSERT INTO mpj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Palujanuya wangka-nintikajalu kulirnu. Jilanya Jiijajju-lanya nintirnu, mirtala-jananya Parajikaja palukaja wangka kulilkura. ");
INSERT INTO mpj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiijajkamu palumili wangka-nintikajaya yankupayi tawunu Jijariyapilapakarti, kaya kintirringu. Ka Jiijajju-jananya japirnu, “Puntu laltulurniya kulirnin ngayu puntu julyju miturrinyjajanurna. Ngayurna puntu yarnngaku marlpa. Nganarniya yini wajarnin?” ");
INSERT INTO mpj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Martukajaluya kulilpayi Jiijajpa julyju nyinapayi, ka miturringu, kayilapa wankarringu. Wajarnuraya, wangka-nintikajalu “Karlkiluntaya wajani, nyuntun Jaanpa mitujanu wankarringu. Jaanju-jananya palulu julyju kalyungka jarrpajunkupayi. Ka karlki kujupaluntaya wajarni nyuntun Yilayija mitujanu wankarringu. Ka karlki kujupaluntaya wajarnin, nyuntun Jirimaya mitujanu wankarringu. Ka karlki kujupaluntaya wajarnin, nyuntun Mamamili jakurlpurluka kujupa mitujanu wankarringu.” ");
INSERT INTO mpj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Palujanu Jiijajju-jananya yarrarnu japirnu, “Wanyjalpanyurra kulini?, nganarna ngayu?” Ka ");
INSERT INTO mpj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Piijalulu wajarnu, “Yuwa. Nyuntun Kurayijpa, Mama ngarnawarrapurlukaku kaja. Mamalu-jananya julyju jamartajunu nyuntunta kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kara Jiijajju wajarnu Piijaku, “Jayimunpa, nyuntulun jungalun kulini, Jaanku kajalu. Mirta nyuntulun walyjalu kulirnin, Mama ngarnawarrapurlukalunta wajani, ka jungalun kulirnin, ngayu Mamamili kaja nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jiijajjulu Piijangka yarrarnu wajarnu, “Ngayulurnanta kuwarri yini kujupa yungkuni, ‘Piija’. Yini palungalaju wajani ‘Yapu’. Nyuntu yapuyuru wiltu yikini. Nyuntulu-jananyan murlpirrju ngayumili wangka parra wajanmalpa. Mirta-jananya malpuku maajalu ngayumili walyjakaja pungkumalpa, kamu wajara kurtingkumalpa. ");
INSERT INTO mpj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ngayulurnanta junku maaja ngayumili walyjakajaku. Nyuntulu-jananyan martukajangka parra wajalku, Mamamili ngurrangkaya nyinakura, palumili walyjakaja. Palujanu Mamalu-jananya ngula kangku nyinajunku palumili ngurrangka. Nyuntulu-jananya jakurljunku, yiipiya mirta kulilku, junku-jananyan, mirtaya Mamamili ngurrakarti yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jiijajju-jananya wajarnu palumili wangka-nintikajangka, “Mirtanyurra kuwarri parra wajanma!, ngayurna Kurayijpa Mamamili kaja.” ");
INSERT INTO mpj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Palujanu Jiijajju-jananya wajalpayi palumili wangka-nintikajangka, “Ngularniya ngayu tawun Jarujalumungka pungku miturntalku. Tawunja jiingka-jananyaya maajakajalukamu yatilykajalu, Muujajmili wangkapurlukakajalu wajalku kujupakajangka ngayurniya yungkalkura miturntalkura. Jiikajalurniya miturntalku, ka karrpu kujarrangkarna mitu ngarriku, karna wankarriku pakalku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Palujanu Piijalu manu Jiijajpa kangu jaalpupula wangkapayi. Ka Piijalura wajarnu, “Mirtan jilanya nyuntu wangka! Mirtantaya pungku miturntanku, Mama ngarnawarrapurlukalunta ngampurrju kanyini.” ");
INSERT INTO mpj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Palujanu Jiijajjulu nyangu Piijangka kurungka, kalu wajarnu, “Paki, jurrarni ngayu! Mayitpi malpuku maajalunta wajarninpa. Mirtarna malpumili wangka kulini, paki. Ka Mamalu kulini ngayurniya martu walykukajalu pungkuraku miturntalku.” ");
INSERT INTO mpj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Palujanu Jiijajju-janampa wajarnu, palumili wangka-nintikajaku, “Yiipinyurra martulu kulini ngayuku nyinakuraku, mirtanyurra kulilkuraku manikukamu wartaku, ngayukuwiyajunyurra nyinaku. Mayitpi Mamakuraya parlanypa, yiipi palukajaluntaya pungku, wulunyurra ngayuku nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yiipinyurra palukajangkamarra ngurlurriku, ka ngayurninyurra junku yanku, mirtanyurra Mamamili ngurrangka nyinaku. Yiipinyurra palukajangkamarra mirta ngurlurriku, ka ngayukujunyurra junga nyinaku, palujanu wulunyurra wanka nyinaku, Mamamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngangkulaya! Yiipirninyurra ngayu junku yanku, ka mankunyurra mani majukamu warta majukamu maya yarnnga, mirtanyurra wanka wulu pukurlpa nyinaku Mamamili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jiijajju-jananya yarrarnu wajarnu, “Ngulalaju parnakutu yankurni wikarrukajalurrju. Mamaku maparn majuwintirna puntuku yarnngaku marlpa yankurni. Kuutjarna-jananya martukaja wajalku walykukajangka yankurakuya, ka walyjakajajuya nyinakura, wanka wulu. ");
INSERT INTO mpj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wajanirna-nyurranya yilta. Kurlungarna-nyurrampa maaja maju nyinaku, ngayumili walyjakajaku. Mirta ngula kuwarriparninyurra ngaakajalu nyaku maaja maju, puntu yarnngaku marlpa.” ");
INSERT INTO mpj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Palujanu wiiki kujungka Jiijajju-jananya kangu Piija, Jayimijpa Jaanpa yapukarti. Jayimijpapula Jaanpa kurtararra nyinapayi. Kaya yapungka takarnu palukajawiyaju. ");
INSERT INTO mpj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaya palukajalu nyakupayi Jiijajpa yarnangu kujupayururringu. Ngumpa palumili rantarnu jirntuyuru, ka palumili kuluju piirlpiirlarringu. ");
INSERT INTO mpj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kayilapapula Muujajkamu Yilayija yutirringulupula, kaya wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Palujanu Piijalulu wangkangu Jiijajja, “Maaja, kunyjunyula ngaangka nyinani. Purikajarna-nyurrampa ngapilku, puri kuju nyuntuku, ka puri kujura Muujajku, ka puri kujura Yilayijaku.” ");
INSERT INTO mpj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Jampa Piija wangkapayi yurnturrju-jananya purijunu ngarnawarralu. Yurnturrpa palu rantalpayi. Yurnturrjanu wangkangu jilanya, “Ngaanyaju ngayuku kaja. Pukurlparnara nyinani. Palumili wangkanyurra kulilkura!” ");
INSERT INTO mpj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jiijajmili wangka-nintikajaluya kulirnu palu wangka, kaya ngurlurringu, kaya wartuyikingu. ");
INSERT INTO mpj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Palujanu Jiijajju-jananya yanu pampurnu wajarnu-janampa, “Mirtanyurra ngurlurri, pakalaya!” ");
INSERT INTO mpj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jampaya wartuyikipayi kaya nyangu Jiijajpawiyaju, kuju yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jampaya marlaku yankupayi yapujanunga Jiijajju-jananya kuranjunu jilanya, “Mirta-jananyanyurra kuwarri parra wajala martukajangka!, kuwarrinyurra nyangunyjangka. Ngulawiyajunyurra wajalku, jamparna ngayu mitujanu pakalku, martu yarnngaku marlpa.” ");
INSERT INTO mpj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Palujanu Jiijajku walyjakajaluraya japirnu, “Kaji Yilayijarni kurranyi yanku?, ka Kurayijpa marlarni yanku? Jilanyaya wajalpayi Muujajmili wangkapurlukakajalu.” ");
INSERT INTO mpj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jiijajju-janampa wajarnu, “Yilta, Yilayijarni kurranyi yanku, martukaja-jananya nintilkura Kurayijku. ");
INSERT INTO mpj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","13","Yilayijalu-jananya julyju Mamamili wangka jakurljulpayi. Yiltangulyu kuwarrirni yanu Jaanpa, Yilayijayuru Mamamili wangka-jananya jakurljulpayi, kalyungka-jananya jarrpajunkupayi. Mamamili wangka jakurlpurlukaluya julyju wajalpayi Yilayijayururni yanku. Martukajaluya Jaan palu kulira junkupayi, kaya miturntanu. Paluyuru ngayurniya martu yarnngaku marlpa kulira junkupayi, karniya miturntalku.” Wangkanintikajaluya kulirnu Jaanpa Yilayijayuru nyinapayi. Jaanju-jananya kurranyilu martukaja nintijunkupayi Kurayijku. ");
INSERT INTO mpj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Palujanu Jiijajmapuya yanu marlaku martukajakarti. Kayilapalu yirnalu yanu Jiijajkarti, ka pupatingu, ");
INSERT INTO mpj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ka japirnura, “Maaja, ngayumili kajakuju nyarrurriwa kunyjunyula! Kajaju ngayumili ngarntarrini malpuwinti, ka punkani kalyungka, warungkalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kangurna-jananya ngayumili kaja wangka-nintikajakarti, kayilapaya purtu wankalpayi.” ");
INSERT INTO mpj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jiijajju-janampa wajarnu martukajaku, “Purturna-nyurranya wajarni, mirtanyurra wangka kulini. Ngakumpanyurra nyinani. Ngayumili wangkajunyurra purtu kulilpayi. Kawarni murtilya ngaakutu!” ");
INSERT INTO mpj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Palujanu Jiijajju warrkirnulu kurtingu malpu. Kayilapa malpu yanu, ka kunyjunyuyila nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Martukaja yankunyjangka kayilapaya wangka-nintikaja yanu Jiijajpa japirnu, “Nganajanulaju mirta malpu warrkirnu kurtingu?” ");
INSERT INTO mpj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ka Jiijajju-janampa wajarnu, “Kulilngaranyurra ngayulurna-nyurranya julyju wajarnu, ngayumili maparnwintiluyan warrkilku malpu kurtingku. Jilanyanyurra kulilngara ngayumili wangka. Ngangkulaya ngaa wangka! Yiipinyurra ngayumili wangka kulilku ka yapukuranyurra wajalku yankuraku kujupakarti. Palujanuyila yilta yapu yanku. Yiipinyurra ngayumili wangka kulilku kujupa kujupanyurra yalyjirrju ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Palujanuya Jiijajmapu yankupayi ngurra kujupa ngurra parraya-jananya wajalpayi, parna Kaliliyawana. Palunya tayimu Jiijajju-jananya wajarnu jilanya, “Yirna kujulu-jananya yanku jakurljunku maaja majukajangka, ngayurniya kangkura miturntalkura. Karrpu kujarrangkarna mitu ngarriku, ka Mama ngarnawarrapurlukalurni wankalku.” Wangka ngaaya kulirnu Jiijajmili wangka-nintikajalu, kaya wirla walykurringu. ");
INSERT INTO mpj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Palujanuya Jiijajkamu palumili wangka-nintikaja yanu tawun Kapaniyamukarti. Jiingkaya yikipayi yirnakaja yupalkaja jaajipurlukakaja. Jiikajaluya martukaja japilpayi maniku, jaajiya ngampurrju kanyilkuraku. Jiikajaluraya Piija japirnu, “Jiijajju jaajiku mani yunginpa?” ");
INSERT INTO mpj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka Piijalura wajarnu, “Yuwa, yungkupayi.” Palujanuya Jiijajmapu yanu ngurratu. Jiingkara Jiijajju Piija japirnu, “Wanyjalpa nyuntulu kulini? Yiipi kapamanku mani pakirriku, wanyjangkaya manku manikaja?, mayitpiya ngurra kujupangka manku?, mayitpiya ngurra walyjangka manku?” ");
INSERT INTO mpj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ka Piijalura wajarnu, “Ngurra kujupangka.” Ka Jiijajjura wajarnu, “Yuwa, ngurra walyjangkaya martulu mirta mani yungkuni. Ngayulurna-jananya mirta mani yungkungara, jaajpurlukakaja, jumaji ngayurna Mama ngarnawarrapurlukaku kaja nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yiipirna-jananya mirta yungku, wirrilyirrikujuya. Palujanurna-jananya yungku, wirrilyirrijakujuya. Mirtarna mani kanyini, palujanu Piija, nyuntu yarra kalyukarti!, kan wirrupungku layinpa kalyungka, piijpan mankuraku. Yiipi piijilu pajalku nyuntulun yilalku. Nyuntulun nyaku jaangka kanyini mani. Manin palun manku ngayu kujarramili, ka kangku-jananyan yungku jaajiku.” Kayilapalu Piijalu kulinu Jiijajja kayilapa yanu manu piijpa, jaangka kanyilpayi mani. ");
INSERT INTO mpj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Palujanu palumili wangka-nintikajaluya Jiijajja yanu japirnu jilanya, “Mamalu-lanya palumili walyjakaja ngampurrju kanyilku. Nyuntu-lampajukun maaja maju nyinaku, ngana-lampa kujupa maaja maju nyinaku? Mayitpi ngaangka palu yikininpa.” ");
INSERT INTO mpj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Palujanuya jijikaja jayitingka yikipayi. Kayilapa Jiijajju yanu kuju manu, kayilapa kangu kutungka yikijunu, kayilapalu yikipayi ngamu jijingka. ");
INSERT INTO mpj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Palujanuyila-janampa palumili wangka-nintikajaku wajarnu, “Wangka ngaanyaya kulila! Jijikajaluya yiltalu kulini, yiipi martulu wajanyjangka. Nyunturtinjuyan yiltalu Mamamili wangka kulilku, jiji ngaayurulu. Pakingkanga mirtanyurra Mamamili walyja nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yiltalunyurra kulilku jiji ngaayurulu, kanyurra Mamamili walyja nyinaku, maaja majukaja. ");
INSERT INTO mpj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jiji ngaayururna-jananya ngayulu ngampurrju kanyirni, karna-janampa pukurlarrinpa. Yiipiranyurra jijikajaku pukurlarriku, kajunyurra ngayukulurrju pukurlarriku.” ");
INSERT INTO mpj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","“Ngayumili walyjakajaluya walykukaja ngapini. Yiipiya jilanya ngapini, mirtajuya junga nyinani. Yiipi martu kujupalu muunpungku ngayumili walyjakaja walyku ngapilkuraku, kayilapa Mamalu warrkilku pungku. Martu palunya Mamalu warrkira pungkujakungkamarra, jumaji ngayumili walyja muunpungu, martu karlkinjuya palu manku ngalyingka tayimapulku yapu majuwintilu, kaya kalyungka warningku. Yilta martu palunyayuru muunpungkupayi, Mamalu pungku.” ");
INSERT INTO mpj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jiijajju-janampa yarrarnu wangka yumuwanpa wajarnu kulilkuraya nintirriraku, “Ngayumili walyjalu mara kujarrawintilu ngulyulu mankukuraku kulilku. Palujanu palulungku mara kujukarti katupungku ngulyungkamarra, warukartilurrju kujarrawinti yankujakungkamarra. Kayilapa kunyjunyu nyinaku mara kujukarti. Wangka palunyayuru jilanya. Yiipi ngayumili walyjalu kulilku jinawintilu yankura ngulyulu mankuraku. Palujanu palulungku jina kujukarti katupungku ngulyungkamarra, warukartilurrju kujarrawinti yankujakungkamarra. Kayilapa kunyjunyu nyinaku jina kujukarti. ");
INSERT INTO mpj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yiipi ngayumili walyjalu kuruwintilu nyaku nyupa kujupangka, ka kulilku ngulyulu mankuraku, ka palulungku kuru wakala walykula!, nyakujakungkamarra, warukartilurrju yankujakungkamarra, kuru kujarrawinti. Kayilapa kunyjunyu nyinaku kuru kujuwinti.” ");
INSERT INTO mpj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Jiijajju-jananya wajarnu, “Jiji ngaayuruya mirta walyku nyinani, ngayuku walyjajuya nyinani. Mirta-jananyanyurra nganarnpuwa!, wikarrukajalu-jananya wululu jijikaja ngampurrju kanyini. Yiltarna-nyurranya wajarnin. Yiipi martulu-jananya nganarnpungku, palujanu wikarrukajalu-jananya Mamangka jakurljunku.” ");
INSERT INTO mpj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wangka kujupa-jananya Jiijajju wajarnu, “Wanyjalpanyurra kulini? Mayitpi kujulun ngula jiipupurlukalu kanyilku jiipukaja yantarta wulikaja. Yiipi kuju jiipu yanku luujarriku. Wanyjalarrikun? Nyuntun jilanyarriku. Junku-jananyan yanku karlkinpa jiipukaja, karan yanku ngurrilku kujuku, jiipuku luujarrinyja. Yuwa, jiipupurlukara kujuku kulini ngampurrju kanyilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yiipi jiipupurlukara yanku ngurrilku manku, kayilapa pukurlarrikuminyirri. ");
INSERT INTO mpj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jiiyuru jiipupurlukayuru Mamalu kulini, palumili walyjaku kujuku ngampurrju kanyilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Yiipi martulungku nyuntuku putamanku, palujanuran yanku kawalyalu wajalku kujungka palungka. Yiipinta kulilku, ka kunyjunyu nyinaku, jilanyanga kunyjunyu. ");
INSERT INTO mpj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yiipinta mirta kulilku, junkukan yanku-jananyan kujarra kujupa manku, kayilapalunyurra yanku kawalya palungka wangkaku. Palu kujarralupula wangka kulinmalpa, nyuntumili kujarraku wangkaku. Jilanya Mamamili wangka nyininpa, kujarra kujupalupula wangka kulinmalpa. ");
INSERT INTO mpj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yiipi-nyurranya mirta kulilku, junkukanyurra yanku-jananyanyurra jaajingka manku. Kanyurra kangku palu martu, kayilapanyurra wangkaku kujungka. Yiipi palu martulu-nyurranya mirta kulilku, jilanyaranyurra wajalku, ‘Mirtarnin nyuntu yarra!, ngaakarti, jaajikarti, paki.’” ");
INSERT INTO mpj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jiijajju-jananya yarrarnu wajanu, “Ngangkulaya! Ngayulurna-nyurranya junku maajakaja, ngayumili walyjakajaku. Nyunturtinju-jananyanyurra martukajangka parra wajalku, Mamamili ngurrangkaya nyinakura, palumili walyjakaja. Palujanu Mamalu-jananya ngula kangku nyinajunku palumili ngurrangka. Nyunturtinju-jananyanyurra jakurljunku, yiipiya mirta kulilku junku-jananyanyurra, mirtaya Mamamili ngurrakarti yanku. ");
INSERT INTO mpj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Wangkaya ngaanya ngangkula! Yiipi yupaljunyurra Mama kujungkalu japilku, palujanu-nyurranya kulilku, ka yirnilu ngapilku. Ka yiipi kujarralupulan Mama kujungkalu japilku, kayilapantapula Mamalu kulilku, ka yirnilu ngapilku. ");
INSERT INTO mpj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yiipi yupalpanyurra kujungkarriku Mama japilkuraku, ka marninypungkuraku, palujanurna ngayu Jiijajpalurrju kujungkarriku. Yiipi kujarrapulan kujungkarriku Mama japilkuraku, ka marninypungkuraku, palujanurna ngayu Jiijajpalurrju kujungkarriku.” ");
INSERT INTO mpj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Palujanu Piijalu yanu Jiijajpa wajarnu, “Yiipi nyuntuku walyjalurni walykumanku, ngayurnara nyarrurriku yanku kawalya wangkaku. Mayitirni japan tayimu walykumanku, palujanurnara ngayulu nyarrurriku, ka yanku kawalya japan tayimu wangkaku.” Piijalura yarrarnu japirnu, “Yiipirni yarralku walykumanku, palujanurna junku yanku?, mirtarnara nyarrurriku kawalya wangkaku?” ");
INSERT INTO mpj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kayilapa Jiijajjura wajarnu, “Mirta japan tayimuwiyaju, japanti japan tayimulun nyuntu nyarrurriku, ka kawalya wangkaku. ");
INSERT INTO mpj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wangka ngaa ngangkula! Ngayulurna-nyurranya nintilku Mamalu-nyurranya ngula walyjakaja ngampurrju kanyilkuraku. Maajalu-jananya palumili warrkamupurlukakaja mani yungku, kayilapaya warrkamurriku maniya muu ngapilkuraku. Kaya palukaja warrkamurrimalpa. Palujanu ngula maajalu-jananya mirraku kujungkalku, ka japilku-jananya yaaluya mani ngapirnu. ");
INSERT INTO mpj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","25","Ka karlkinpa-jananya kunyjunyu japilku. Kayilapara kujupa japilku. Ka martu palulura mirta katingu mani yungu, jumaji pakirringu. Palulura yungkungara pipiti jawujun tala. Palujanura maajalu paluku wajalku, ‘Nyuntuku mayakamu nyupa jijikajalurrju, kamu parnakamu wartalurrju wajalkurna-jananya warrkamupurlukakajangka jalamunkurakuya, kaya mani mankuraka kangkurakurniya yungkuraku.’ ");
INSERT INTO mpj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kara warrkamupurlukalu pupatiku maajangka, kayilapalu wajalku, ‘Nyarrurriwaju! Ngayulurnanta ngula wulikaja mani manku, ka yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kara maaja paluku nyarrurriku, kayilapara wajalku, ‘Pakala yarra!, mirtarnin marlaku ngaparrju yuwa!’ ");
INSERT INTO mpj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Palujanu jii warrkamupurluka ngurrakarti yankukija, nyakuyila kujupa martu, palulura mirta yungu jilpakaja. Purtura japilkuka ngalyinyuku ngalulku, kara wajalku, ‘Manirni yuwa!, kuwarringulyu!’ ");
INSERT INTO mpj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Palujanu martu palunya pupatiku, kara wajalku, jii warrkamupurlukaku, ‘Nyarrurriwaju! Ngayulurnanta ngula wulikaja mani manku, ka yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kayilapara jii warrkamupurluka mirta nyarrurriku, kara wajalku, ‘Paki! Wajalkurna-jananya nyuntuntaya kangkura jiilkarti.’ Kaya kujupakajalu kangku jiilja kurrujunku nyinaraku. Ngulayila pakalku, yiipi mani palunya wulikaja payamunku. ");
INSERT INTO mpj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Kaya warrkamupurluka kujupakajalu kulilku, karaya nyarrurriku martu paluku jiilja kurrungunyja. Palujanuya yanku jakurljunku maajangka. ");
INSERT INTO mpj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Julyju warrkamupurluka jiikura maaja nyarrurringu ka kurtingu. Palukura mirraku, kalu maajalu wajalku, ‘Nyuntun warrkamupurluka puta! Nyuntulurnin julyju wajarnu nyarrurringkurakurnangku, karnangku ngayu yiltangulyu nyarrurringu, mirtarna mani paluku wajarnu, junurnanta. ");
INSERT INTO mpj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Palujanuran martu jiiku nyarrurringara, jiilkartin mirta wajara kurtingkungara.’ ");
INSERT INTO mpj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Maajara wirrilyirriku ka wajalku-jananya palumili warrkamupurlukakajangka, ‘Ngaaya kawa jiilkarti!, nyinara ka ngula pakalku, jamparni mani wulikaja payamunku.’” ");
INSERT INTO mpj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jiijajju-jananya yarrarnu wajarnu, “Wangka paluyuru nyininpa. Martu kujupakunyurra nyarrurriku ka kawalya wangkaku. Pakingkanga Mamalu-nyurranya ngarnawarrapurlukalu maaja palunyayurulu ngula kuutja wajalku kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wangka palu-jananya wangkangu martukajangka, palujanuyilaya yanu Jiijajmapu, parna Kaliliyajanu, ngurra Juutiyakarti. Yanuya Juutiyangka karru Juutanja kakarrakarti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kayilapa-jananyaya martukaja kujungkarringu, ka wanarnu-jananyaya Jiijajmapu. Kayilapa Jiijajju-jananya martukaja maapu pampurnu. ");
INSERT INTO mpj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Palujanu Parajikajaluraya yanu Jiijajpa japilkuraku. Jilanyaya kulilpayi, “Yiipi Jiijajju pakiwana wajalku ngulala kuutja wajalku.” Jiijajparaya jilanya japirnu, “Kaji, Muujajmili wangka jilanya nyininpa?, Yirnalungku wanti kanyilkuka parlanyarrikuka kurtingku?” ");
INSERT INTO mpj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Jiijajju-janampa wajarnu, “Kulilngaranyurra! Mamamili wangka jilanya nyininpa julyjujanu. Julyju Mamalu-jananya nyinajunu yirnakaja jaalpu, ka wantikaja jaalpu. ");
INSERT INTO mpj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Palujanupula yirnakamu wanti nyupararra nyininpa jaalpu, mirtalupula mamingkakamu mamangka nyininpa, wulupula jaalpu nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ngurra kujungkapula nyininpa, jungapula nyininpa. Mamalu-pulanya jilanya nyinajunu, mirta-pulanya martu kujupalu wajalku jaalpupula nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wajarnuraya Jiijajku, “Muujajju wajarnu kunyjunyula nyupa walyjaku parlanyarriku ka kurtingku, mirlimirliwinti yankuraku. Jilanya mirlimirlilu wajarni, ‘Nyupa walyjakurna parlanyarringu karna kurtingu, kujupalu mankuraku.’ Jiijajpa wanyjalpan nyuntulu kulini?” ");
INSERT INTO mpj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Jiijajju-janampa wajarnu, “Mitunyjarrikajaya purtu kulilpa nyinapayi. Palujanu Muujajju-janampa wangka palu wakarnu, nyupanyurra kurtingkuraku. Yiltanyurra palukajayuru purtu kulilpa nyininpa. Julyju Mama ngarnawarrapurlukalu-pulanya nyupararra nyinajunu, palujanu mirtaya nyupakaja kurtingkupayi.” ");
INSERT INTO mpj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jiijajju-janampa yarrarnu wajarnu, “Nyupararranpayan nyininpa, mirta-ngkuyan nyupakaja kurtiwa!, kujupalu mankuraku. Yiipinyurra nyupakaja kurtingku Mamaku wangkanyurra warlangkuni. Yiipi wanti yirna kujupakutu yanku, palujanun kunyjunyulu kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jiijajmili wangka-nintikajaluya kulirnu, kaluya Jiijajja wajarnu, “Nyuntulu-lanyajun nintirnu. Yiipi yirnara nyupaku parlanyarriku, mirta kurtingkuraku. Palujanu wanyjalarrikula yiipila nyupaku parlanyarriku? Mayitpila nyinangara kunyjunyu, nyupaparni.” ");
INSERT INTO mpj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jiijajju-janampa wajarnu, “Paki, nyupararranyurra nyinakura. Yupalwiyajuya kunyjunyu nyinaku nyupaparni, Mamalu-jananya murlpirrmaninpa, kunyjunyuya nyupaparni nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Karlkinjuya purtu kulini nyupa mankuraku, jumajiya-jananya kurlurrpa mankura warningkupayi. Karlkin kujupaluya purtu kulini nyupa mankuraku, jumajiya kurlurrpa walykurringu. Karlkin kujupaya nyupaparni nyininpa Mamamili wangkaya parra wajalkura, martu yarnngaluya kulilkuraku, kaya Jiijajmili walyjarriraku. Yiipi martulu kulini Mamamili warrkamu ngapilkuraku kunyjunyu nyupaparni nyinaraku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Palujanuya martukajalu jijikaja katipayi Jiijajkarti, yampulkuraku. Kulilpayiya martukajalu “Jiijajju-jananya julyju yampulpayi, kalu Mamangka wangkapayi, jijikaja-jananya ngampurrju kanyilkura.” Kayilapa-jananyaya martukaja marrkulpayi, Jiijajmili wangka-nintikajalu, “Mirtaya-jananya jijikaja kangkurakurni!” ");
INSERT INTO mpj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka-jananya Jiijajju marrkurnu, “Jurra-jananyaya!, kangkurakurniya jijikaja ngayukutu. Jiji ngaakajayuru Mamalu-jananya ngampurrju kanyini, palumili walyjakaja.” ");
INSERT INTO mpj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Palujanu Jiijajju-jananya yampurnu jijikaja. Kayilapa-jananya Jiijajju martukaja junu yanu, ka palumili wangka-nintikajawinti yanu ngurra kujupakarti. ");
INSERT INTO mpj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Palujanulu warrinyjilu yanurni Jiijajkarti, kara japirnu jilanya, “Nintipuka! Yaalurrikurna wankarna wulu nyinakuraku? Nganarna kunyjunyu ngapilku?” ");
INSERT INTO mpj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka Jiijajjura wajarnu, “Nganakurnin japini kunyjunyun ngapilkura? Mama ngarnawarrapurlukawiyaju kunyjunyu nyinani. Palumili wangkakuran nyuntulu jungalu kulilkura, palujanun wanka wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kara palulu warrinyjilu japirnu, “Mamamili wangka yarnnga nyininpa. Nganakurnara junga nyinaku?” Kara Jiijajju wajarnu, “Nyuntun junga nyinaku wangka ngaakajaku. Martulun mirta pungku martu kujupa mitu. Martuluran mirta yirna kujupaku wanti kangku. Martu kujupakuran mirta manku ngulyulu. Martu kujupangkalun mirta paki kajalku. ");
INSERT INTO mpj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mamakukamu yakurtikuran kunyjunyu nyinama!, mirta-pulanyan nganarnpuwa! Martu walyjakulara pukurlpa nyinani, paluyurula martu kujupakajaku pukurlpa nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Warrinyji palulura Jiijajku wajarnu, “Wangka jiikajakurna junga nyinapayi. Jijirna junga nyinapayi, kuwarrirna wulu junga nyinani. Nyaakajarna ngapilku jungarna nyinaraku?” ");
INSERT INTO mpj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jiijajjura wajarnu, “Nyuntu jungaminyirri nyinaku ngaakajan jilanya ngapilku. Wartakajakamun maya jalamunku, kayilapan mani manku, ka-jananyan kangku yungku nyarrukaja. Nyuntun maniparni nyinaku, palujanu jungajun nyinaku. Palujanunta Mamalu ngula ngurrangka ngampurrju kanyilku, wanka wulu nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka warrinyji palulu purtu kulirnu, mirta jalamulkijalu wartakamu maya. Wirla walykurringu, ka yanu. ");
INSERT INTO mpj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiijajju-janampa wajarnu, palumili wangka-nintikajaku, “Mamalu-jananya ngampurrju kanyilku palumili walyjakaja. Kaya warta majukajawintilu purtuya kulilku wartakajaya junku yankuraku, kayilapaya Mamamili walyjakajangka nyinakuraku, palumili ngurrangka. Mirtaya jiingka kurrungku wartakajawinti. ");
INSERT INTO mpj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kamalpa purtu kurrungku niitulja tapurrja, paki. Paluyuru wartawintikajaya purtu kurrungku mamamili ngurrangka, jumajiya mikurrini wartakamu maniku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wangkanintikajaluya jilanya pakiwana kulilpayi, “Mamalu-jananya wartakajakamu mani yungu wartakajawinti, palujanu Mamalu-jananya kangku ngampurrju kanyilku palumili ngurrangka.” Palujanu jilanya-ngkuya japirnu wangka-nintikajalu, “Ngana kujupa wanka wulu nyinaku Mamamili ngurrangka? Wajarnu-lanya wartakajawintiya mirta nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jiijajju-jananya nyangu, ka wajarnu, “Martulu purtu kulilku Mamamili walyjakajangka-jananya nyinakura. Mamaluwiyaju kuliraka kangku nyinajunku palumili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ka Piijalura wajarnu, “Ngayurtinjulaju wartakamu mayalurrju, ka martu walyjakajalurrju junu yanu. Kalajunta nyuntungka kujungkarringu nyininpa. Yaalurrikulaju?” ");
INSERT INTO mpj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Ngularna ngayu maaja maju nyinaku, martu yarnngaku marlpa. Palujanula maaja maju wulikaja nyinaku, Yijurilmili marlajanukajaku. Yijurilmili kaja kurranyijanu Ruupinpa nyinapayi. Paluku marlajanukaja nyininpa yarnnga. Ruupinku marlangu yini Juuta nyinapayi. Paluku marlajanukaja nyininpa yarnnga. Juutaku marlangu yini Pinjaminpa nyinapayi. Palukura marlajanukaja nyininpa yarnnga. Jilanyaya kurtararranpa tuwal wulikaja nyinapayi Yijurilmili kaja. Palukajaya marlajanukaja nyininpa kuwarri, yarnngaminyirri. Palukajaku-janampayan maaja maju nyunturtinpa tuwal wulikaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jiijajju-janampa yarrarnu wajarnu palumili wangka-nintikajaku, “Yiipinyurra junu yanu ngurrakajakamu martu walyjakaja, kayilapanyurra junga ngayuku nyinaku. Ngulanga Mamaluntaya puntajilu yungku, ngurra kujupakamu walyjakajalurrju. Palujanuntaya kangku nyinajunku wanka wulunyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Parnangkaya kuwarri maajakaja nyininpa, ngula ngurra palungkaya warrkamupurluka nyinaku. Ka kujupakajaya kuwarri warrkamupurlukakaja nyininpa, ngulaya ngurra palungka maajakaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jiijajju-janampa wajarnu, “Mamalu-jananya palumili walyjakaja kanyilku ngampurrju. Palu tayimu jilanya nyinaku. Maajalu kanyilku kaatanmaya, kuripijkaja kuruwumunmalpa. Yaarlipala kurnpungka yanku tawunkarti mankuraku-jananya warrkamupurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ka wajalku-jananya, ‘Manirna-nyurranya ruka yungku pipiti tala karrpuku kujuku.’ Ka kulilkuya pukurlarriku. Palujanu-jananya katiku warrkamukarti, palumili kaatanmayakarti. ");
INSERT INTO mpj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ka yaarlipala maaja palu yarralku yanku tawunkarti. Kayilapa-jananya nyaku, martu kujupakaja warrkamuparniya yikini, tawunja kaninypa. Jiingkaya majani martukaja warrkamuku. ");
INSERT INTO mpj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka wajalku-jananya, ‘Nyunturtinpaya yarra!, kaatanmayakarti warrkamurriraku. Ka rukarna-nyurranya manikaja yungku.’ Pukurlarrikuya, ka-jananya kangku warrkamukarti. ");
INSERT INTO mpj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka maaja palunya karrpungka yarralku yanku tawunkarti. Ka kujupakaja-jananya nyaku, ka kangku warrkamukarti. Ka ruka yarralku palu yanku tawunkarti, ka nyaku-jananya kujupakaja yikini. Ka-jananya kangku warrkamukarti. ");
INSERT INTO mpj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Palujanu rukaruka, kayila yarralku yanku tawunkarti kujupakajaku. Ka nyaku-jananya wajalku, ‘Nyaakunyurra wulu ngaangka yikini warrkamuparni?’ ");
INSERT INTO mpj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Karaya wajalku, ‘Mirta-lanyajuya maajakajalu mirrangu kangu warrkamukarti.’ Ka wajalku-janampa, ‘Nyunturtinpalurrjurniya yarra kaatanmayakarti!, warrkamukarti.’ Yankukaya rawaparni warrkamurriku. ");
INSERT INTO mpj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Jirntu kurrungkunyjangka maajalulu wajalku palumili warrkamupurlukangka, jiimartajingka, ‘Mawu-jananya yarra marra warrkamupurlukakaja!, mani-jananyan yungkuraku, ngaanya. Jiikajarna-jananya kangkupayi rukaruka, palukajapalaji-jananya yuwa! Palujanu rukarna-jananya kangkupayi, palukaja-jananyan yungku. Ka palujanu karrpungkarna-jananya kangkupayi, palukaja-jananyan yungku. Palujanu yaarlipalarna-jananya manu palukaja-jananyan yungku. Ka yaarlipala kurnpungkarna-jananya manu, palukaja-jananyan marla yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Palujanu rukaruka maajalu-jananya kangkupayi, jiikaja warrkamupurlukakaja, kayilapa-jananya palumililu warrkamupurlukalu yungkumalpa pipiti tala wulikajaku, kujunkujunku. Palujanu ruka maajalu-jananya kangkupayi, jiikaja warrkamupurlukakaja, kayilapa-jananya palumililu warrkamupurlukalu yungkumalpa pipiti tala wulikajaku, kujunkujunku. Jilanyalu-jananya pipiti talakaja wulikaja yungkumalpa. ");
INSERT INTO mpj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Karlkinpaya warrkamupurlukakaja kurnpungkaya yaarlipala warrkamurripayi, palukajaluya nyaku, pipiti tala-jananya wulikaja yungkupayi, kaya kulilku, ‘Mayitpila muu mani manku, pipiti talangka munkarra.’ Palujanu warrkamupurluka palulu-jananya yungku pipiti tala, kujunkujunku. ");
INSERT INTO mpj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Palujanuraya maajaku paluku wirrilyirrikuraya, karaya wajalku, ‘Kaatanmayangka rukarukaya jiikaja warrkamurripayi rawaparni, kaya pipiti tala manu. Ka ngayurtinpalaju rawa warrkamurripayi, jirntungka yaatpalangka, ka-lanyaju yungu pipiti talawiyaju.’ ");
INSERT INTO mpj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka maajalu-janampa wajalku, ‘Ngayumili miirtikaja! Mirtarna-nyurranya ngayulu raapamunu. Kurnpungkanyurra pukurlarringu, ngayulurna-nyurranya yungkuraku pipiti tala. ");
INSERT INTO mpj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Nyamungulyu, yarraya ngurrakarti!, mani palunyawinti. Ngayulurna kunyjunyulu kulinu mani pipiti talarna-jananya yungu, marlajanukaja. Mirtarninyurra wajala!, ngayulurna mani walyja yungkuraku. Mayitpijunyurra wirrilyirrini, jumajirna-jananya ngayulu yirnilu yungu.’” ");
INSERT INTO mpj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jiijajju-janampa yarrarnu wajarnu, “Parnangkaya kuwarri maajakaja nyininpa, ngula ngurra Mamamilingkaya warrkamupurluka nyinaku. Ka kujupakajaya kuwarri warrkamupurlukakaja nyininpa, ngulaya ngurra palungka maajakaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Palujanuya Jiijajmapukamu martu kujupakaja kujungka yankupayi tawunu Jarujalumkarti. Ka Jiijajpa-janampa mirrangu palumili wangka-nintikajaku, ka-jananya jaalpu yikijunu. ");
INSERT INTO mpj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ka-jananya wajarnu, “Ngangkulaya! Wulikajala yaninpa Jarujalumkarti, ka ngurra palungkarniya manku, martu yarnngaku marlpa, karniya kangku Yatilykajakartikamu Muujajmili wangkapurlukakajakarti. Jiikajalurniya kangku kuutja yikijunku, ka wajalkurniya miturntalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Palujanurniya kangku Juwuparnikajakarti. Jiikajalurniya nyurnimanku, karniya wiipuwintilu pungku. Palujanurniya wiltijunku, karna miturriku. Palujanurna mitu ngarriku karrpu kujarrangka, karna wankarriku pakalku.” ");
INSERT INTO mpj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yirna Jipitimili nyupakamu palumili kaja kujarra, palurtinpaya yankupayi Jiijajkarti. Ka wantilu palulu pupatingu kalu Jiijajja japirnu, “Kajijun nyuntulu kunyjunyu ngapilku?” ");
INSERT INTO mpj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka Jiijajjura wajarnu, “Nganarnangku ngapilku?” Kara wantilu wajarnu Jiijajku, “Nyuntun ngula maaja maju nyinaku, kayilapantapula ngaa kujarra, kaja kujarra maaja maju kiin nyinaku. Kajirnin jilanya wajalku?” ");
INSERT INTO mpj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jiijajjura wajarnu, “Pakiwanan nyuntu wangkani. Ngurrpalun nyuntulu wajani.” Ka-pulampa wajarnu kaja kujarraku, “Kuwarrirniya warrkiraka pungku. Kujungkalanyaya warrkiraka pungku? Jilanyapulan kulini?” Kapula palu kujarralu wajarnu, “Yuwa, paluwanaliju kulini.” ");
INSERT INTO mpj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka Jiijajju-pulampa wajarnu, “Yiltantapulaya kujupakajalu warrkiraka pungku. Ka Mamaluwiyaju wajalku ngayungkarni maaja kujupa nyinakurakurni, mirtarna ngayulu wajalku.” ");
INSERT INTO mpj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka Jiijajmili wangka-nintikajaluya kulirnu, kaya wirrilyirringu-pulampaya, jumajipula maaja nyinakijalu. ");
INSERT INTO mpj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Palujanu Jiijajpa-janampa mirrangu ngamurriraya kulilkuraku. Ka-janampa wajarnu, “Ngangkulaya! Juwuparnikajaya yarnnga maaja-janampaya wiltu nyinani. Wirrilyilu-jananyaya kanyini. Jilanyakunyurra ninti nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Kayilapanyurra mirta maaja paluyuru nyinakura. Yiipin kujulu kulini maaja nyinakura, nyuntulu-janampan warrkamu ngapilkura jiikajaku, ");
INSERT INTO mpj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ngayulurna-nyurrampa warrkamu ngapini, jiiyuru. Ngayurna martuku yarnngaku marlpa yanurni warrkamurna-ngkuya martu wulikajaku ngapilkura. Jilanyarnara warrkamu Mamaku ngapilku, karna miturriku martuya yarnnga wankarriraku. Mirtarna yanu ngaa parnakarti martukajalujuya warrkamu ngapilkura, maaja majuku, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tawun Jirikuya junu yanu, kaya yankupayi Jiijajmapu, ka-jananyaya wanarnu martukajalu. ");
INSERT INTO mpj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka ruutungka ngamupula yirna kujarra, pampuru kujarra nyinapayi. Jiijajpa ruutungka yankupayi, kapula pampuru kujarralu kulirnu, wati yankupayi. Kapula wiltu mirrangu, “Nyuntun Tayipitmili marlajanu! Yarrarni nyarrurri-limpajuku!” ");
INSERT INTO mpj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaya martukaja kurranyiya yankupayi, jiikajaluya marrkurnu-pulanyaya, “Yakapula nyina!” Palujanu wulurapula wiltu mirrapayi. “Maaja! Nyuntun Tayipitmili marlajanu! Yarrarni nyarrurriwa-limpajuku!” ");
INSERT INTO mpj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ka Jiijajju ngangkurnu ka mirrangu-pulampa, yankurakurnipula. Japirnu-pulanya, “Nyaakupulan mirrangu? Nganarnangkupula ngapilku?” ");
INSERT INTO mpj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kapula wajarnu, “Kuru-linyaju kunyjunyula!” ");
INSERT INTO mpj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ka nyarrurringu-pulampa Jiijajpa, ka-pulanya kuru pampurnu. Kapula kuru kunyjunyurringu, kalupula kujungka Jiijajja yankupayi. ");
INSERT INTO mpj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Palujanuya Jiijajkamu wangka-nintikaja yankupayi tawun Jarujalumkarti. Yanuya tawun Piijpayijja ngamurringu, yapu majuwartangka yini Yalipajja nyinangu. Ka-pulampa Jiijajju palumili wangka-ninti kujarraku wajarnu, kurtingkuraku-pulanya, “Yarrapula tawun jiikutu! Nyakuyilapulan tangki yangupalawinti yikini, ruuppawintipula yikini. Kurtiwa-pulanyapula jii kujarra!, kayila-pulanyanpula marlakurni katiku, ngaakarti. ");
INSERT INTO mpj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mayitpintapula martulu kujupalu jiimartajilu japilku, ‘Nyaakupulan ruupu tikamaturni?’ Ka-jananyanpula jilanya wajalku, ‘Maajalu ngangkuni takalkurakulu, ka kangkuraku.’ Palujanuntapula jiimartajilu wajalku, ‘Yuwa kawapula!’” ");
INSERT INTO mpj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","Palujanupula jii kujarra yanu, Jiijajju-pulanya wajanyjangka, jilanyapula ngapirnu. Tangkikamu kujarrapula kangu yikijunu. Kayilapapula kuurtungkupula tikamaturnu, kapula junu tangki kujarrangka. Kayilapa Jiijajpa takarnu yangupalajarangka. Jilanya mamamili wangka jakurlpurlukalu julyju wajarnu, “Wajala-jananya Jarujalumumartajingka!, ‘Nyakurakuya nyurrartinmili maaja majurni yaninpa. Mirtangku walyjalu marninypungkuni, warrkamupurlukayuru yaninpa tangki yangupalangka.’” Wangka ngaanya Mamamili yiltarringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ka ruutungkaya martu yarnnga yankupayi kujungka. Karlkin kujupaluya kuurtukaja tikamatura junkupayi tangkilu jinalu kantulkuraku. Ka karlkin kujupaluya wartakaja parrkakaja warlangkupayi ka ruutungkaya junkupayi, tangkilu kantulkuraku. (Jilanyaluya Juwukajalu yarnngalu murrarni junkutinpa maajalu majulu tangki katiraku. Jilanyaya junkutinpa maaja majukuwiyaju.) ");
INSERT INTO mpj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Martukajaluya Jiijajja kurranyilu mirrara marninypungkupayi, kaya karlkin kujupalu Jiijajja marlakarti marninypungkupayi. Jilanyaya wiltulu marninypungkupayi martukajalu jiikajalu, “Maaja majuwarta ngaanya. Marninypungkuwala ngaa Tayipitku marlajanu! Yilta ngaanya Mamamili. Mamala marninypungkura!” ");
INSERT INTO mpj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jilanyaya wululyu yanu Jarujalumungka pakarnu. Kaya jiimartaji martukaja kujungkarringu maapurringuya. Ka japirnu-ngkuya, “Ngana ngaanyarni yankuni?” ");
INSERT INTO mpj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka karlki kujupaluya wajarnu, “Ngaanga yilta Mamamili jakurlpurluka, Jiijajpa. Palunga parna Kaliliyamartaji, tawun Najarijja.” ");
INSERT INTO mpj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kayilapa Jiijajpa yanu Juwumilingka jaaji majungka kurrungu. Jiijajju-jananya nyangu turrukajaya maapu jalamunkupayi. Karlkin kujupaluya turrukaja payamunkupayi yatilykaja yungkuraku. Jiijajpa-janampa wirrilyirringu ka-jananya warrkinu kurtingu. Kayilapa-janampa tiipulkaja manu warningu, turrupurlukakajakukamu manipurlukakajaku. Nyinapintikajalurrju-janampa manu warningu. ");
INSERT INTO mpj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jiijajju-jananya payirnu jilanya, “Mamamili jaaji ngaanya mirtanyurra jalamunma kuwiyikaja ngaangka! Mirtanyurra ngulyunyjumapu ngaangka kumpilkura, maajakajalu-nyurranyaya mankujakungkamarra, paki. Mamamili wangka julyjujanu nyininpa jilanya, ‘Ngaanga ngayumili jaaji, ngayurninyurra marninypungkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Palujanu Jiijajju-jananya martukaja pampulpayi, pampurukajakamu mukuntukaja, kaya kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yatily majukajaluya nyangu Jiijajju-jananya pampura kunyjunyunkupayi, kayilapaya wirrilyirringu. Jaajingkaya jiingka jijikajalu Jiijajpa wiltulu marninypungkupayi, “Maaja majuwarta ngaanya, marninypungkuwala!, Tayipitmili marlajanu.” Kayilapa yatily majukajaluya kulirnu, kayilaparaya Jiijajku wirrilyirringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Palujanuraya japirnu Jiijajpa, “Jijikaja-jananyan kulini?” Ka Jiijajju-janampa wajarnu, “Yuu. Kulinirna-jananya, kunyjunyuya wangkani. Kulinngaranyurra Mamamili wangka palu, julyjujanu. Jilanya nyininpa, ‘Mama! Nyuntulu-jananyan nintirnu jiji majukajakamu japukaja, nyuntuntaya marninypungkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wangka palu-jananya Jiijajju wajarnu, kayilapa-jananya junu yanu. Tawun Piijanikarti yanu ngarringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Palujanu yaarlipala Jiijajkamu palumili wangka-nintikajaya marlaku ruutuwana yankupayi Jarujalumukarti. Jiijajpa yanu, ka kalyparturringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ruutungka jayitingka nyangu warta yukuri yikipayi, ka kulirnu, “Mayitpi mirrkawinti yikini.” Kayilapa jiikutu yanu pakira nyangu. Kayilapara wajarnu wartaku, “Mirtan nyuntu mirrkawinti yikiku, paki.” Kayilapa warta tikirlarringu. ");
INSERT INTO mpj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Palujanuya palumili wangka-nintikajalu nyangu ka kuru pakarnu, kayilapaya wajarnu, “Yaaluku ngaanya wirrurru tikirlarringu?” ");
INSERT INTO mpj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Yiipinyurra kulilku maparnparna-nyurranya yungku ngapilkuraku, kanyurra wajalku wartangka, palujanuyila tikirlarriku, jiiyuru. Kujupa kujupayurunyurra ngapilku jilanya, ngayumili maparnwintilu. Yiipinyurra wajalku yapu jiiku jilanya, ‘Mawu yarra kalyungka kurruwa!’ Palujanu yilta mawu yanku kurrungku. ");
INSERT INTO mpj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yiipirninyurra ngayu maparnwinti kulilku, ka Mama japilku, palulu-ngkuya kunyjunyu ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Palujanu Jiijajpa Jarujalumungka kurrungu, ka yanu jaaji majukarti, ka martukaja-jananya palungka nintilpayi. Kayilaparaya yatily majukajalukamu maajakajalu, yirnakajalu yanurni Jiijajpa japirnu, “Maaja nganalunta wajarnu martukaja-jananyan nintilkuraku?, kamu wankalkuraku?” ");
INSERT INTO mpj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jiijajju-janampa wajarnu, “Kurlurnantaya japilkura. Ngayulurnantaya japilku, palujanu mirta-ngkuyan ‘Ngurrpa’ wajala! Yiipirninyurra jungalu wajalku, ‘Ngurrpa’ wajalparnilu, ngayulurna-nyurranya jungalu wajalku, maajalurni kurtingkura. Ngangkulaya wangka ngaanya! ");
INSERT INTO mpj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jaanju-jananya kalyungka jarrpajunkupayi. Maajalulu nganalu Jaanja wajarnu?, martukaja jarrpajunkuraku, mayitpi Mama ngarnawarrapurlukalu, mayitpi martulu, maajalu.?” Ngangkunukaya yaka wangkapayi-ngkuya jaalpu, jilanya, “Yiipilalu Jiijajja wajalku Mamalulu wajarnu Jaanja, palujanu-lanya Jiijajju wajaljaku, ‘Jaanmili wangkanyurra kulinngara, Mamamili.’ Mirtalalu jilanya wajalku Jiijajja, ‘Mamalulu wajarnu.’ ");
INSERT INTO mpj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yiipilalu Jiijajja wajalku, martulu maajalu Jaanja wajarnu, palujanu martukaja-lampaya wirrilyirriku. Kulirninpaya Jaanpa Mamamili wangka jakurlpurluka. Palujanulalu wajalku ‘Ngurrpala’” ");
INSERT INTO mpj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Palujanuluya Jiijajja wajarnu, “Ngurrpalaju. Maajalu nganalulu wajarnu, Jaanja?” Ka Jiijajju-janampa wajarnu, “Ngayulurrjurna-nyurranya ngurrpa wajarni. Mirtarna-nyurranya wajalku maajalurni wajarnu.” ");
INSERT INTO mpj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jiijajju-jananya yarrarnu wajarnu, yumuwanpa wangka kulilkurakuya. “Yirna nyinamalpa kaja kujarrawinti. Kaja kurranyijarangkalu wajalku, ‘Kaja! Yarra warrkamurri kaatanmayangka kuripijja!’ ");
INSERT INTO mpj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kajalura wajalku, ‘Paki, mirtarna yanku, nyinamalparna.’ Palujanu kajalu palulu nyinaku rawaparni, ka walyjalu kulilku yanku warrkamurriku kaatanmayangka. ");
INSERT INTO mpj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mamara ngurrpa nyinapayi, palu warrkamukutu yanu. Palujanu yirna palululu yanku wajalku kaja kujupangka, ‘Kaja! Yarra warrkamurri kaatanmayangka!’ Kayilapa kaja jiilu wajalku, ‘Yuu, yankurna warrkamukarti.’ Palujanuyila nyinaku, mirta yanku warrkamukarti.” ");
INSERT INTO mpj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ka Jiijajju-janampa japirnu jilanya, “Kulilaya! Wanyjajarulu kajalu kulirnuka ngapirnu?” Karaya maajakajalu Jiijajku wajarnu, “Kaja kurranyijaralu.” Ka Jiijajju-janampa maajakajaku yarrarnu wajarnu, “Wangka ngaanyaya kulila! Mamalu-jananya palumili walyjakaja ngampurrju kanyilku. Karlki kujupaya walykukaja kapamanku maniya mankuni, ka wanti karlkinpaya walyku nyinani, kurlanyjukaja. Palurtinpaya nyunturtinjamarra kurranyi nyinaku, mamamili walyjakajangka. Yiltanyurra purtu kulilpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Julyju Jaanju-nyurranya nintilpayi junga nyinakura. Palulu-jananya martukaja kalyungka jarrpajunkupayi. Jaanpa palunyurra mirta ngangkulpayi, ka karlki kujupaluya ngangkulpayi, jiiluya kapamanku maniya mankuni, kamu wanti kurlanyjukajalu. Yilta jiikajaluya Jaanmili wangka ngangkulpayi. Nyangu-jananyanyurra, ka mirtanyurra jungalu kulilpayi, Jaanmili wangka. Purtu kulilpanyurra wulu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jiijajju-jananya yarrarnu wajarnu, yumuwanpa wangka kulilkurakuya. “Martu maajalu junkura wananmalpa kuripijku wilykikaja. Piinyjikaja junku wanalku tinkijunku. Palujanu maya ngarnawarra ngapilku, nyakupinti, kuripijpaya ngulyulu mankujaku. Piinyjingka jayitingka tapurrpa jawalku junku ngulaku. Tapurrja palungka jinaluya kuripijkaja kantunmalpa, kayilapa karrkartakaja yintinmalpa tapurrkarti. Kayilapa maaja palulu mirraku-janampa martu karlkinku, warrkamurriraya kaya ngampurrju kanyilkura. Palujanu ngurra kujupakarti yanku warrkamurriraku. ");
INSERT INTO mpj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Palujanuya kuripijkaja yurnmirriku. Kayilapa maajalu-jananya warrkamupurlukakaja yupalpa kurtingku, yankuraya mankuraku kuripijkaja yaapu. Kaya junku yaapu kuripijkaja kaatanmayapurlukakajaku. ");
INSERT INTO mpj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kaya kaatanmayapurlukakajalu nyaku-jananyaya kayilapa-jananyaya pungku. Kujuya mitu pungku, ka kujupaya ngurlulku wanalku yapuwintilu. ");
INSERT INTO mpj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Palujanu yarralku-jananya maajalu kurtingku kujupakaja yarnnga warrkamupurlukakaja. Kayilapa-jananyaya nyaku kaatanmayapurlukakajalu, kayilapa-jananyaya pungku kurtingku. ");
INSERT INTO mpj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Palujanuyila-jananya maajalu kurtingku palumili kaja. Kulilku, ‘Mayitiraya ngayumili kajaku nyarrurriku, ka kuripijku-jananya japilku, karaya yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kaya kaatanmayapurlukakajalu nyaku kaya wangkaku, ‘Jiirni yankuni palumili kaja. Jiilu kajalu kanyilku kaatanmayakamu maya ngaanya, yiipi miturriku palumili mama. Mitula pungkura!, kayilapala ngaanya kanyilku kaatanmayakamu maya.’ ");
INSERT INTO mpj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Palujanu kaja palu kaatanmayangka kurrungku. Kayilapaya mitu pungku, kaya katikuya wirrupungku yawujayiti.” ");
INSERT INTO mpj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Parajikajaya kamu yatily majukaja jiingkaya yikipayi, martukajangka. Ka Jiijajju-jananya japirnu, “Ka maajalu-jananya yanku, kaatanmayapurlukakaja wajalmanku?” ");
INSERT INTO mpj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Karaya martukajalu wajarnu, “Maajalu-jananya yanku wulikaja pungku miturntanku, kaatanmayapurlukakaja. Ka-janampa kujupakajaku mirraku, warrkamurrirakuya yungkurakuraya yiltamarta yaapu, kaatanmayajanu.” Wangka palunya-jananya Jiijajju wajarnu maajakajangka, jilanyaya kulilkuraku, “Maajakura kaja palu Jiijajyuru Mamamili kaja.” ");
INSERT INTO mpj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jiijajju-janampa yarrarnu wajarnu, maajakajaluya kulilkuraku. “Mamamili wangkanyurra kulilngara, jilanya nyininpa. ‘Martukajaluya puri ngapilku, kaya warta kujarra narnnguwinti yikijunku. Kayilapaluya warta kujupa wiltu, warlpukurru ngarrijunku ngarnawarra. Kayilapaya nyakuka warta palu wiltu manku warningku, pinyi karalkuya. Mama ngarnawarrapurlukalu warta palu warningunyja mankuka ngapilku puri. Palujanula nyaku puri kunyjunyuminyirri, jiijanu wartajanu.’” Jiijajju-jananya wangka palu wajarnu, maajakajaluya kulilkuraku jilanya, “Jiijajparna nyinani paluyuru warta wiltuyuru. Juwukajalurniya manku kangku miturntanku pinyi karalkurniya.” ");
INSERT INTO mpj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Jiijajju-jananya maajakajangka yarrarnu wajarnu, “Wajarnirna-nyurranya Mamalu yilta palumili walyjakaja ngampurrju kanyilku. Mirta-jananyanyurra jiikajangka nyinaku. Mamalu-nyurranya junku, ka kujupakaja nintilku palumili walyjakajangka junga nyinakuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","46","Wangka paluya kulirnu, kaya wirrilyirringu Parajikajakamu yatily majukaja. Kulilpayiya jilanya, “Palulu-lanya wajarnu, ka nganarnpungkuni-lanya. Kuwarrila yanku manku kangku pungku.” Jilanyaya ngangkunuka junu, martukajangkamarra. Kulinuya jilanya, “Martukajalu-lanyaya pungkujaku, jurrala! Martukajaluya kulini, jumaji Jiijajpa Mamamili wangka jakurlpurluka.” ");
INSERT INTO mpj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiijajju-janampa wangka yumuwanpa wajarnu, kulilkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mamalu-jananya palumili walyjakaja ngampurrju kanyilku. Palunya tayimuya jilanya nyinaku. Maaja maju nyinaku, warrkamupurluka yarnnga kanyilku. Maaja paluku kaja marrirtikijalu, maaja jii-janampa warrkamupurlukakajaku mirraku. ");
INSERT INTO mpj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka-jananya wajalku, ‘Palukajangka-jananyaya yarra wajala!, ngularniya mirrkaku yankurakurni.’ Ka yanku-jananyaya wajalku, kayilapaya kulilku junku. ");
INSERT INTO mpj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Palujanu yarralku-jananya warrkamupurlukakaja kujupakaja kurtingku, jilanya-jananyaya wajalkura, ‘Mirrkakamu kilakaja ngarrinpa, yarrarniya! Kilakajaya katupunguka junu.’ ");
INSERT INTO mpj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ka martu palukajaluya kulilku junku wuluya warrkamurriku. Kuju kaatanmayakarti yanku ka warrkamurriku. Ka kujupa tuumayakarti yanku warrkamukarti. ");
INSERT INTO mpj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka karlki kujupaluya maaja majumili warrkamupurlukakaja pungku miturntanku. ");
INSERT INTO mpj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kayilapa maaja majulu palulu kulilku ka-janampa wirrilyirriku. Palujanu jantulwintikaja-jananya kurtingku jiiku martukajaku, pungkuraku-jananyaya miturntalkuraku. Yiltangulyuya miturriku, kayilapa tawunpa-janampaya kampaku wiyalku. ");
INSERT INTO mpj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Palujanu maaja majulu-jananya palumili warrkamupurlukakajangka wajalku, ‘Ngayukuju kaja marrirtirrikijalu, palujanu mirrkakamu kilakaja ngarrinpa. Martu palukajarna-jananya junkungara, mirtarna-jananya wajalngara mirrkakurniya yankuraku. Palukajaya purtu wajalpa. ");
INSERT INTO mpj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nyunturtinpaya yarra ruutuwana!, martukaja-jananyanyurra nyakuka japilku, yankurakurniya mirrkaku.’ ");
INSERT INTO mpj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Palujanuya yanku ruutuwana kujungkalku-jananyaya martukaja, kunyjunyukajakamu walykukaja. Palujanu manku-jananyaya kangku maaja majumili mayakarti. Ka-jananyaya warrkamupurlukalu kuurtu kunyjunyukaja yungku, kurrungkuraluya, kuurtu kunyjunyuwintiluya ngalkura ka pukurlarriraku. Mayangka palungkaya kujungkarriku yarnngaminyirri. ");
INSERT INTO mpj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Maaja majulu palulu yanku mayangka kurrungku, ka nyaku kuju martu, kuurtu kunyjunyuparniwinti yikini. ");
INSERT INTO mpj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka yankulu wajalku, ‘Nyaajanun nyuntu kuurtu kunyjunyuparni yikini?’ Kulilkuka yaka yikiku. ");
INSERT INTO mpj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ka maaja majulu palulu-jananya wajalku, palumili warrkamupurlukakajangka, ‘Yarraya tayimapula ruupuwintilu!, marakamu jina kujarra, kanyurra kangku warningku yawujayiti, mungangka yikiraku. Jiingkayilapa yulamalpa wilyjiwilyji majuwinti.’” ");
INSERT INTO mpj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jiijajju-janampa yarrarnu wajarnu, “Martu karlkinjuya Mamamili wangka kulilku, kaya walyjarriku. Ka yarnnga kujupaluya kulilku junku, mirtaya Mamamili walyjarriku.” ");
INSERT INTO mpj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","16","Palujanu Parajikajaya kujungkarringu, ka-ngkuya wangkangu, “Yupalpala-jananya kurtingku Jiijajkarti japilkuraku. Palumili wangkaya kulilkuka-lanyaya katiku wajalku. Wangka palumilila wajalku kuutja, kuutpurlukangka, Jiijajpaya miturntalkuraku.” Palujanu jiikajalu Parajikajalu-jananyaya kurtingu Parajikaja yupalpakamu Yirutmili wangkapurlukakajalurrju Jiijajkarti. Ka Jiijajparaya japirnu jilanya, “Nintipuka! Kulirninpalajunta nyuntulun jungalu wajani. Mama ngarnawarrapurlukalunta nintini, palujanu-lanyajun nyuntulu jungalu wajarninpa. Mirta-jananyan nyuntulu maajakajangka ngurlurrini, nyuntulu-jananyan wululu Mamamili wangka wajarninpa, yakaparnilu. ");
INSERT INTO mpj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kuwarri-lanyaju jungalu wajala!, wanyjalpan nyuntulu kulini? Luwu wanyjalpa-lampa nyininpa? Kajila ngayurtinju kapamanpa maaja maju mani yungkuraku?, yini Tayipiriyajpa, mayitpi mirtalara yungku kapamanpa.” ");
INSERT INTO mpj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jiijajju kulirnu, “Mayitpi ngaakajalurniya japini, ngularniya kuutja wajalkuraku.” Palujanu-janampa wajarnu, “Mayunyjulurninyurra japini, pakilurrju. Jilanya japilparnilurniyan junkungara. ");
INSERT INTO mpj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mani jilpa kujula kapamanpa yungkuni. Mani palu jilparniya kawa nintijula!, nyakurakurna.” Jilparaya kangu yungu. ");
INSERT INTO mpj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jiijajju-jananya japirnu, “Ngumpa nganamili ngaanya? Yini ngana ngaanya?” ");
INSERT INTO mpj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kaluya wajarnu, “Kapamanpa maaja maju, Tayipiriyajpa.” Ka-jananya Jiijajju wajarnu, “Warrkamupurlukaluntaya japilku maniku kapamanku, palujanu yungkuraku-jananyanyurra, kayilaparaya kangku yungku maaja Tayipiriyajpa. Paluyuru yiipi Mamamili warrkamupurlukaluntaya japilku maniku, palujanu-jananyanyurra yungku mani, kayilaparaya kangku junku Mamamili warrkamuku.” ");
INSERT INTO mpj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jilanya-jananya Jiijajju yalyjirrju wajanu, palujanuya purtu kulinu kuutja ngula wangkakuraku. Palujanuya Parajikajakamu, Yirutmili wangkapurlukakaja yaka yikipayi kayilaya junu yanu ");
INSERT INTO mpj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Martu karlkinpaya nyinapayi Jaajmili maajakaja. Jilanyaya kulilpayi pakiwana, “Martuya mirta mitujanu ngula pakalku, paki, wuluya mitu ngarrimalpa.” ");
INSERT INTO mpj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Jiikajaluya yanu Jiijajpa japirnu, “Nintipuka! Muujajju-lampa julyju jilanya luwu wakarnu. Yiipi kurtalu wanti manku, ka jijiparni nyinaku, palujanu miturriku. Kayilapa palumililu marlangulu manku wanti palunya. Yiipipula jiji manku, kaya martukajalu kulilku, ‘Kurtakura jiinya jiji.’” (Martukajalula mirta jii kulini, ka Juwukajaluya jilanya kulilpayi.) ");
INSERT INTO mpj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kaluya Jiijajja yarrarnu wajarnu, “Jiikajaya kurtararranpa nyinapayi japan wulikaja. Majujaralu manu nyupa kanyilpayi. Jijiparnipula nyinapayi, palujanu yirna palu miturringu. Ka palumili marlangulu wanti jii manu. ");
INSERT INTO mpj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nyinapayipula jijiparni kayilapa yirna palu miturringu. Wantiwiyaju wanka nyinapayi. Kayilapa kujupalu marlangulu wanti palu manu. Jijiparnipula nyinangu, kayilapa yirna palu miturringu. Jilanyayuruya wanti palu kanyirnu marlangukajalu, kaya miturripayi jijiparni. ");
INSERT INTO mpj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Palujanu wanti palu wanka kuju nyinangu, ka jijiparni miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka Jiijajkuraya yarrarnu japirnu, “Ngulampanga mayitpi martukaja mitujanu wankarriku, kayila wanti palunya mitujanu wankarriku, ka palumili nyupakajalurrju. Palujanu nganakura wanti palu nyinaku? Julyju-jananya japan wulikaja kanyilpayi.” ");
INSERT INTO mpj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka Jiijajju-jananya wajarnu, “Pakiwananyurra kulini. Mamamiliku wangkakunyurra ngurrpa. Mirtanyurra kulini Mama ngarnawarrapurlukalu yalyjirrju ngapini, maparn majuwintilu. ");
INSERT INTO mpj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngulaya martukaja mitujanu pakalku, mirtaya nyupawinti nyinaku, paki. Wikarrukajayuruya Mamamili ngurrangka nyinaku, nyupaparni. ");
INSERT INTO mpj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Martu mitujanu yilta wankarriku nyinaku, Mamamili ngurrangka. Jilanya Mamalu wajarnu. Wangka jiiyuru riitamurrira kanyurra kulilngara. Yipurammapuya miturringu julyju, kayilapa Muujajju wangka palunya wakarnu, marlalu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngayurna Mama ngarnawarrapurlukarna-janampa maaja maju nyinani Yipuramku, Yajikkukamu Jayikapku.’ Yiltaya palukaja wanka nyinani ngarnawarra Mamamili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kaya martukajalu kulirnu, kayilapaya kuru pakarnu, “Yilta yalyjirrju-lanya nintini.” Kaya Jaajmili maajakajalu purtu kulirnu, ka yakarringu. Purtuya kulilpayi ngaparrpa wangkakuraku. ");
INSERT INTO mpj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Palujanuya Parajikajalu maajakajalu yanurni kaya kulirnu, “Jaajmili maajakajaluya purtu kulirnu, kaya yakarringu Jiijajku.” ");
INSERT INTO mpj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Palujanulu kujulu Muujajmili wangkapurlukalu jiilu jilanya kulilpayi, “Yiipi Jiijajju pakiwana wajalku ngularna kuutja wajalku.” Ka yanu japirnu Jiijajpa, “Nintipuka! Muujajju-lampa Mamamili luwu yarnnga wajarnu. Mayiti kuju luwu majuwarta nyinani, kaya luwu karlkinpa ngalyarlpa nyinani. Wanyjajara luwu maju nyinani?” ");
INSERT INTO mpj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Jiijajjura wajarnu, “Luwu majuwartanga palunga jilanya nyinani, ‘Mama ngarnawarrapurluka-lampa kuju maaja nyininpa. Palukuwiyajunyurra layikamurrira nyinara. Paluwiyajunyurra kuliraka nyinara.’ ");
INSERT INTO mpj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yilta wangka palu majuwarta nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka kujupa paluyuru majuwarta nyinani jilanya, ‘Ngurra walyjakajakulara layikamurrira nyinani. Palunyayurula-janampa ngurra kujupakajaku layikamurrira nyinaku.’ ");
INSERT INTO mpj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Luwu palu kujarrapula maju nyinani, luwu karlkinpaya ngalyarlpa nyinani. Luwu palunya kujarra-pulanyaya julyju Mamamili jakurlpurlukalu kulira wajalpayi.” ");
INSERT INTO mpj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parajikajaya wulu yikipayi. Ka Jiijajju-jananya yumulu japirnu, ");
INSERT INTO mpj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mamamili wangka jakurlpurlukaluya wajalpayi, ‘Kurayijparni ngula yanku.’ Wanyjalpanyurra kulini? Kurayijpara nganaku marlajanu yankurni? Maaja nganamili?” Ka wajarnuraya, “Maaja Tayipitmili marlajanu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka Jiijajju-janampa wajarnu, “Julyju Mamamili Kuurtilu Tayipitpa nintirnu, palujanu Tayipitju jilanya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Mama ngarnawarrapurlukalura wajarnu Kurayijja “Kujarrali nyinaku, maaja kujarra ngaangka. Ngayulu Mamalurna-jananya warrkilku kurtingku nyuntungkamarra Kurayijjamarra.” ’ Tayipitju yarrarnu wajarnu, ‘Kurayijpa jiinya ngayumili maaja nyinani.’” ");
INSERT INTO mpj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka Jiijajju-jananya yarrarnu wajarnu, “Tayipitju Kurayijpa wajarnu, ‘Ngayukuju maaja.’ Yilta Kurayijpa jiinya Mamamili, mirta Tayipitmili marlajanuwiyaju.” ");
INSERT INTO mpj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaya purtu kulirnu Parajikajalu maajakajalu Jiijajpaya japilkuraku. Kaya kurntarringu jumaji Jiijajju-jananya wajarnu jungalu. Mirtaraya ngula yarrarnu japirnu, junuya. ");
INSERT INTO mpj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Martukajaya yarnnga yikipayi, Jiijajmili wangka-nintikajalurrju. Ka Jiijajju-janampa wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Muujajmili wangkapurlukakajakamu Parajikajaya ninti nyinani Muujajmili luwuku. ");
INSERT INTO mpj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jiikajalu-nyurranyaya nintilku, kulilkunyurra junga Muujajmili luwuwana nyinakura. Jiikajaya pakiwana nyinani kuwarri, ka mirtanyurra jiikajayuru pakiwana nyinakura. Jiikajaluya Parajikajalukamu Muujajmili wangkapurlukakajalu wangka nintini, kayilapa mirtaya paluwana wangkawana junga nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Muujajmili luwuwanaya nintini, martukajaraya luwu paluku junga nyinakura, palujanu-jananyaya wangka kujupa kujupalurrju mawu nintini, martukaja luwu palukajakulurrjuya junga nyinaraku. Wangka jiikunyurra purtu kulini, junga nyinaraku, ka mirtaya luwu paluwana junga nyinani, paki. ");
INSERT INTO mpj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jungayuruya nyinani, martulu-jananyaya nyakura marninypungkura. Pawuji japuwartaya ngalyangkakamu marawana tayimapura, kaya kangkuni. Mamamili wangkaya mirlimirlingka wakara junkuni, kaya pawuji jiingkaya junkuni. Puulyuruya karrpira kuluju junkupayi, kaya kuurtungka wiltiyikipayi, martukajaluya nyakuraku. Jilanyaya pawujikamu puulkaja kangkuni, martukajaluya nyakuraka marninypungkuraku jilanya, ‘Yilta jiinga Mamamili walyja, pawujiwintikamu puulkajawinti parra yankuni.’ ");
INSERT INTO mpj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Palukajaya yankura Juwuku jaajingka maajamilingkawiyaju nyinapintingka nyinani, mirtaya martukajangka kujungka nyinani, paki. Yiipiya martukajalu mirrka pukurlju kujungka ngalkuni, palukajaluya yulupirtilu yankuraka maajamilingka nyinapintingka nyinani, mirtaya martukajangka nyinani, paki. ");
INSERT INTO mpj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","8","Martukajaya tawunwana kutungka kujungkarrini mirrkaya payamulkuraku. Jiikajaya Parajikajakamu Muujajmili wangkapurlukakaja kutuwanaya maajayuru parra yankuni, nyakuraku-jananyaya. Yiipi martu kujupalu wajani, ‘Nintipuka! Nyuntu-lampajukun maaja.’ Palujanuya Parajikajakamu pukurlarrini.” Jiijajju-janampa yarrarnu wajanu, “Mirta martu kujupaluntaya wajalkura, ‘Nyuntu-lampajukun maaja’, paki. Wulikajanyurra kurtararranpayuru nyinani, maajaparni. Maaja kuju-lampa nyinani, Mama ngarnawarrapurluka.” ");
INSERT INTO mpj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jiijajju-janampa yarrarnu wajarnu, “Mirtanyurra martu kujupa marninypuwa!, ‘Maaja! Mamayuru-lampajun nyininpa’, paki. Mamawiyaju-lampa kuju nyininpa, ngarnawarrapurluka. ");
INSERT INTO mpj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mirta kujupanyurra, ‘Maaja!’ marninypungkura, maaja kuju-lampa nyininpa, Kurayijpa. ");
INSERT INTO mpj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yiipi martulu kulilku maajayuru nyinakura, palujanu warrkamupurlukayuru nyinaku. Yiipi martu kujulu kulilku, ka maajayuru nyinamalpa, palujanu Mama ngarnawarrapurlukalu kurntangkalku, ka warrkamupurlukayuru nyinamalpa. Yiipi martu kujulu kulilku ka warrkamupurlukayuru nyinaku, palujanuyila Mama ngarnawarrapurlukalu maaja maju junku.” ");
INSERT INTO mpj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Palujanu Jiijajju-janampa yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Mirta-jananyanyurra Mamamili wangka jakurljuni jungalu, martukajaluya kulira nyinakura wanka, paki. Jungalu-jananyanyurra nintiljunngara, ka Mamamili walyjaya nyinangara, palulu-jananya ngampurrju kanyinngara. Nyunturtinpalurrjunyurra mirta Mamamili walyja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jiijajju-jananya yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Wirrirlinyurra yankuni puutja tatiraka martukaja nintilkuraku. Nyuntumili wangka-jananyanyurra nintini, palujanuya pakiwana nyinani, nyunturtinyuru. Mamalu-nyurranya wulikaja warukutu kurtingku. ");
INSERT INTO mpj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","22","Martu pampurulu mirta nyakuni, ngurrpara wartakukamu mayaku. Jiikajayurunyurra nyininpa ngurrpa, Mamamili wangkaku, mirtanyurra nintipuka nyininpa.” Jiijajju-janampa yarrarnu wajanu, “Martukajaluya wajarni, ‘Mama ngarnawarrapurlukangkarnanta kurungka, wajarni, jungalu ngapilkuraku.’ Jilanyaluya karlkilu martukajalu jungalu wajani, ka jungalu ngapini. Ka Parajikajalukamu Muujajmili wangkapurlukakajalu-jananyanyurra pakiwanalu nintijunkupayi, jungalu-jananyanyurra nintijunkura, martukajaluya kajalparnilu wajalkura jilanya, ‘Mama ngarnawarrapurlukangkarnanta kurungka, wajarni, jungalu ngapilkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Palujanu Jiijajju-jananya yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Wilykikajanyurra tuunyjuni pakalkuraku kaatanmayangka. Palujanu yiipi yurnmirrini, mankurakanyurra katamatuni japuwarta, kanyurra jungalu kangkura yungkuni jaajingka. Kanyurra mirta junga nyinani, mirtanyurra Muujajmili wangka kulini. Mirtanyurra martukajaku junga ngapini, ka-janampanyurra mirta nyarrurrini. “Mamamili wangkakuranyurra junga nyinakura. Kunyjunyulunyurra wilykikaja kangkura yungkuni jaajingka, kanyurra junga nyinangara nyarrurringara-janampanyurra martukajaku. ");
INSERT INTO mpj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yiltalunyurra Muujajmili luwu kuliraka junkuni, mayunyjukajalu. Jiikajaku-janampanyurra karlkiku luwu japuwartakajaku junga nyinani, ka palumili luwunyurra majukaja kulira junkuni.” ");
INSERT INTO mpj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","26","Palujanu Jiijajju-jananya yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Malyanyurra nyininpa manikukamu wartaku, jurtawartakaja. Mamamili warrkamupurlukayurunyurra parra yaninpa, mayunyjukaja. Mirtanyurra jilanyayuru nyinaku, junganyurra nyinaku Mama ngarnawarrapurlukaku.” ");
INSERT INTO mpj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Palujanu Jiijajju-jananya yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Kulininyurra pakiwana, jilanya, ‘Martukajalu-lanyaya marninypungkura, jumajila Mamaku junga nyinani.’ Yiltangulyunyurra pakiwana nyinani, mirtaranyurra Mamaku junga nyinani, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Palujanu Jiijajju-jananya yarrarnu wajarnu, “Parajikajakamu Muujajmili wangkapurlukakaja nyarrukajanyurra nyinani, Mamalu-nyurranya warrkilku ka pungku, jumajinyurra mayunyjukaja nyininpa. Julyju-jananyaya Mamamili jakurlpurlukakajalu jakurljulpayi mitunyjarringka Mamamili wangka. Kaya kulira junkupayi wirrilyirripayiya, palujanu-jananyaya pungkura mitu junkupayi, Mamamili jakurlpurlukakaja. Jiikajaya Mamamili jakurlpurlukakaja ngaangka parnangka mitu ngarrini. Kuwarri-jananyanyurra purtipulawukaja kangkura junkuni, kulilkuraku-jananyanyurra, mitunyjarrikajangka. ");
INSERT INTO mpj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jilanyanyurra Parajikajalu pakiwana wajani, ‘Yiipi ngayurtinpalaju julyju nyinangara, palujanulaju-jananya mirta wirrilyirrira pungkungara mitu, Mamamili jakurlpurlukakaja.’” ");
INSERT INTO mpj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jiijajju-jananya yarrarnu wajarnu, “Yilta mitunyjarrikajalu-jananyaya pungu Mamamili jakurlpurlukakaja. Jiiku mitunyjarrikajakunyurra marlajanu nyininpa, Parajikajakamu Muujajmili wangkapurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mitunyjarrikajayurunyurra nyininpa pakiwana, purtu kulilpa. ");
INSERT INTO mpj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yiltanyurra mayunyjukaja nyininpa purtu kulilpanyurra. Mamalu-nyurranya ngula warukutu kurtingku. ");
INSERT INTO mpj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yiltarna-nyurranya wajani. Ngayulukamu Mamaluliju kurtingku Mamamili jakurlpurlukakaja kujupakaja, karlki kujupaliju kurtingku Mamamili nintipukakaja. Ka karlki-jananyanyurra mitu pungku, ka karlki-jananyanyurra wartangka wiltijunku, ka miturntanku. Karlki kujupa-jananyanyurra wiipulu pungku Juwumili jaajingka, ka ngurlulku kurtingku tawun kujupakarti. Ngulanyurra yanku tawun jiikarti, ka-jananyanyurra ngurlulku kurtingku tawun kujupakarti. ");
INSERT INTO mpj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ngula, Mamalu-nyurranya Juwukaja warrkilkuka pungku, jumajinyurra wululu martukaja mitu pungkupayi, nyunturtinmili mitunyjarrikajalulurrju. Julyju Yayipulpa nyinapayi, walyku mirta ngapirnu, kayilapa kujupajaralu palu mitu pungu. Palujanuya kujupakajalu Jakaraya mitu pungu, Pirajamili kaja, jaaji majungka, tiipulja jayitingka. Tiipulja palungkaya kujalpayi mirtayirtikaja Mama ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wangka ngaanyaya kulila! Ngula Mamalu-nyurranya Juwukaja warrkilkuka pungku, jumajinyurra wululu martukaja mitu pungkuni, jumajiya nyunturtinmililu mitunyjarrikajalu mitu pungkupayi.” ");
INSERT INTO mpj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","38","Jiijajju-janampa martukajaku yarrarnu wajarnu, “Nyarrurrinparna-ngkuya Jarujalumumartajiku, jumaji nyunturtinmililu mitunyjarrikajalu-jananyaya Mamamili jakurlpurlukakaja mitu pungkupayi. Jiikajaluya-jananya yapuwintilu yungkara miturntalpayi. Pawurlalu-jananya palumili jijikaja manku, ka-jananya yampulku jarrpajunku ngampurrju kanyilkuraku. Mamamili wangkarna-nyurranya nintilpayi ngampurrjurna-nyurranya kanyilkuraku pawurla palunyayurulu jijikaja ngampurrju yampura kanyini. Kajunyurra ngayumili wangka kulira junkupayi. Palujanu Mamalu-nyurranya warrkilku kurtingku, mirtanyurra tawunja ngaangka Jarujalumungka nyinaku. Jaaji majuwiyaju-nyurrampa yikiku, martuparni. ");
INSERT INTO mpj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mirtarninyurra parna ngaangka yarralku nyaku, ngulawiyajurninyurra nyaku, marlakurrinyja, parna ngaakutu. Palu tayimurninyurra martukajalu nyaku wajalku, ‘Maaja maju-lampa yanurni Mamamili maparnwinti. Mamala marninypungkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jiijajpa ngurra kujupakarti yankupayi, ka jaaji maju junu yanu. Karaya palumili wangka nintikajalu wajarnu, “Jiinya jaaji maju yikini, nyawara! Yilta kunyjunyu yikini.” ");
INSERT INTO mpj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka Jiijajju-janampa wajarnu, “Ngula, Mamamili parlanykajaluya jaaji jii punkajulku, kayilapa yapukajawiyaju ngarrira wananmalpa.” ");
INSERT INTO mpj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Palujanuya Jiijajmapu yanu yapukarti yini Yalipajkarti, kaya martuparningka nyinapayi. Karaya Jiijajmili wangka-nintikajalu japirnu, “Nyaarta jaaji palu majuwarta warlangku? Kulinilaju ngula nyuntun parna ngaakarti yarralku yankuni, kayilapa parnakamu ngarnka pakirriku. Nganalaju nyaku nintirriku?, yiipi palu tayimu ngamurriku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jiijajju-janampa kujupakarti wajarnu, “Wuulkumartaya nyinama!, pakiwana-nyurranyaya kajaljaku, ");
INSERT INTO mpj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","martukajaluntaya kujunkujunju, Kurayijyurulu yankura kajaljaku. Wangka jilanya-nyurranyaya kajalku, ‘Ngayurna-ngkuya maaja Kurayijpa marlakurringu. Mamalu julyju wajarnu ngayurna-nyurrampa marlakurriku.’ Jilanyaya martu yarnngalu yilta karanyja kulilku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jiijajju-janampa yarrarnu wajarnu, “Martukajalu-ngkuya jurta pungkumalpa ngurra kujupangkakamu ngurra kujupangka. Kayilapa palu tayimu mirta parnakamu ngarnka pakirriku, ngula pakirriku. Yiipinyurra jakurlpa kulilku, jurta-ngkuya pungkuni jilanyaya kulila!, ‘Mirta parnakamu ngarnka pakirriku kuwarri, ngula pakirriku.’ ");
INSERT INTO mpj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ka warrarn kujupa kujupawana-ngkuya jurta pungkumalpa, kayilapa parnakamu warta mayalurrjuya yurriku, parna yaarrangkaku. Palunya tayimuraya martukajalu mirrkaku purtu kulilku, mirrka-janampa pakirriku. ");
INSERT INTO mpj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jilanyaya martukaja ngula nyinaku, kanyurra kulilku, ‘Kuwarri-langkuya warrkilkuka pungku, Jiijajmili martu walyjakaja.’ Jampa-nyurranyaya jilanya warrkilkuka pungku, mirtanyurra pakiwana kulilku, jilanya, ‘Parnakamu ngarnka kuwarri pakirriku’, paki. Jilanyanyurra kulilkura, ‘Jampangulyu parnakamu ngarnka pakirriku.’” ");
INSERT INTO mpj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ka Jiijajju-jananya yarrarnu wajarnu, “Karlkilu-nyurranyaya parlanykajalu mankuka katiku mitu pungku, jumajinyurra ngayumili walyjakaja. Martu yarnnga-nyurrampaya parlanypa nyinaku ngayumili walyjakajaku. ");
INSERT INTO mpj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jiikaja parlanykajangkamarra pungkujakungkamarra, ngayurniya karlkinju junku yanku. Ka jiikajaya parlanypa nyinaku, Jiijajmili walyjakajaku. Ka-jananyaya maajakajangka yanku jakurljulku Jiijajmili-jananyaya mitu pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Palu tayimu martukajaya yankurni kujunkujunpa. Wangka jilanya-nyurranyaya kajalku, ‘Ngayurna-ngkuya maaja Kurayijpa marlakurringu. Mamalu julyju wajarnu ngayurna-nyurrampa marlakurriku.’ Jilanyaya martu yarnngalu yilta karanyja kulilku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Palu tayimuya martukaja walyku nyinaku, ka ngayumili walyjakaja-janampaya ngurlurriku, ka karlkilurniya junku yanku. ");
INSERT INTO mpj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yiipi karlkinyurra ngayuku junga nyinaku, palujanu Mamalu-nyurranya wanka wulu kangku kanyilku. Yilta Mamalu palumili walyjakaja ngampurrju kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wangka jilanyanyurra parra wajalku martukajangka warrarn kujupangkakamu warrarn kujupangka. Palunyayuruya karlkin kujupalu-jananyaya parra wajalku martu kujupangka, warrarn kujupangkakamu warrarn kujupangka. Martu karlkiluya kulilku, karlkin kujupaluya mirta kulilku. Palujanu parnakamu ngarnka pakirriku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jiijajju-janampa yarrarnu wajarnu, “Jurtawarta martuyuru ngula nyinaku, Mama ngarnawarrapurlukakura parlanypa. Jilanya julyju Mamamililu jakurlpurlukalu, Taniyalju wajarnu. Martuya wulikaja ngurlujaka nyinaku parna Juutiyamartaji. Juwumilingka jaaji majungka palu jurtawarta nyinaku. Ka martukajaluya nintilu kulilku, ‘Mirta palu jurtawarta jaaji majungka nyinaku, paki.’ ");
INSERT INTO mpj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yiipinyurra nyaku palu jurtawarta nyinani jaajingka, palujanunyurra ngurlu pinirriku, yapukarti, paluluntaya pungkujaku. Kuranjanyurra wangka palu kulilkuka kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Palu tayimunga, yiipi martu kuju mayangka yawujayiti nyinaku, puringka, mirta palu kurrungku mayangka, palumili wartakaja mankuraku, junkuralura, yapukarti pinirrikura. ");
INSERT INTO mpj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka martu kujupa warrkamurrimalpa kaatanmayangka. Palujanuyila mirta marlaku yankura purikarti, kuurtukura mankuraku, junkuraku, yapukarti pinirrikura. ");
INSERT INTO mpj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Palu tayimu nyarruya nyinaku wantikaja manarrkajakamu jiji yampulpayikaja. Purtuya kulinmalpa wala yankuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jiijajju-janampa wajarnu, “Mamaluwiyaju palu tayimukura ninti. Mamaraya japila!, mirtanyurra kalyu tayimu yarra yapukarti!, kalyulu-nyurranya pulakamuljaku. Luwu-nyurrampa nyininpa, mirta Jarritingkanyurra parra yankura wirrirli. Palujanuraya Mama ngarnawarrapurluka japila!, mirtanyurra yapukarti yankuraku Jarritingka. ");
INSERT INTO mpj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Palu tayimu jurtawarta palu nyinaku rawa walykuminyirri, ka-nyurranya rawalu pungamalpa, ngurlujakanyurra nyinamalpa. Palujanu ngula mayitpi jurtawarta kujupakaja nyinaku, kayilapa mirtaya martukaja ngurlujaka nyinaku. Julyju mirta jurtawarta jiiyuru walykuminyirri nyinapayi, paki. Mirtaya martukaja ngurlujaka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Palu tayimu mirta jurta rawa nyinaku, martukajaya pakirrijaku. Mamalu-jananya marrkulku, wirlarra yupaljawiyaju-ngkuya jurta pungku, jumaji palumili walyjakaja pakirrijaku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Jiijajju-janampa palumili wangka-nintikajaku yarrarnu wajarnu, “Yiipi martu kujupaluntaya yanku wajalku, ‘Nyawaya!, jiinya Kurayijpa, Mama ngarnawarrapurlukalu julyju wajarnu kurtingkuraku.’, kayilapanyurra ngangkulku junku. Yumuluntaya palunga kajalku. ");
INSERT INTO mpj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yarnnga-nyurranyaya yankurni kujunkujunpa, ka-nyurranyaya kajalku jilanya, ‘Ngayurna Kurayijpa yankupayi, Mama ngarnawarrapurlukalu julyju wajarnu ngayurni kurtingkuraku.’ Jilanyaya paki kajalku, kanyurra ngangkulku junku. Jiikajaya yankurni, ka maparnwintiluya yalyjirr kujupa kujupa ngapinmalpa, Mamamili maparnwintiluyuru, Mamamili walyjakajalu-jananyaya yilta kulilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Palujanuya wurlku nyina!, jiikajaluntaya muunpungkujaku. Wangka jiirnantaya kurranyilu wajani, ngangkulkuranyurra ninti nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Yiipi martu kujupaluntaya yanku jakurljunku jilanya, ‘Ngurra kujupangka pujimanja Kurayijpa nyininpa. Yankurala nyakura.’ Wangka palu kulilkukanyurra junku. Mayitintaya kujupalu jilanya jakurljunku, ‘Mayangka jiingka Kurayijpa kukurrini. Yankurala nyakura.’ Wangka palu kulilkukanyurra junku. ");
INSERT INTO mpj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Martuluya yarnngalu nyakuninpa layitningpa. Paluyuru martu yarnngalurniya nyaku, mirtarna kukujarri yankurni. Martu yarnngalurniya nyaku martu yarnngaku marlpa, jamparna parnakarti yankurni. ");
INSERT INTO mpj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mayitpi kuka mitu ngarrini, kayilapaya turrukaja kujungkarrini ngalkurakuya. Paluyuru ngayurna yankurni parnakarti, ka martukajarniya kujungkarriku. ");
INSERT INTO mpj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Palu tayimu marla jurta majungka jirntukamupula wirlarra pakalku kujupawana, mirta rantalku, mungajarrarriku. Ka kurtalyakajaya punkalku. ");
INSERT INTO mpj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Palujanurniya nyaku martu yarnngaku marlpa yurnturrjarna tiputimalpa, maaja maju. Wikarrukajalurrjurniya tiputiku. Kaya walykukajalu kulilku, ‘Mama ngarnawarrapurlukalu-lanya kuwarri pungku’, ka palujanuya yulamalpa. ");
INSERT INTO mpj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Palujanu ngarnawarra puulpintiyuru wiltu mirraku, karna-jananya wikarrukaja wajalku kurtingku, parna parlparriwanaya yankuraku. Yanku-jananyaya Mamamili walyjakaja martukaja manku, ka-jananyaya kangku kujungkalku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jiijajju-janampa yarrarnu wajarnu, “Wangalpaya ngangkula nintirriwa! Jampa wangalpa kakarrajanu wangkaku, ngangkulkunyurra jiinga wantajarrarriku. Wantajarraku-lanya wangalju nintijuninpa. ");
INSERT INTO mpj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Palunyayuru jirntukamu wirlarralu-langku nintijunku, kanyurra ngangkulku, ‘Kuwarrirni maaja maju-lampa marlaku yankuni.’ ");
INSERT INTO mpj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Wangka ngaanyaya kulila! Martukajanyurra kuwarri nyininpa, marlanyurra miturriku, wangka ngaanyarna-nyurranya wajani, yilta nyinaku. Jarujalumumartaji-nyurranyaya pungku, ka jaaji majuya pungku punkajunku. ");
INSERT INTO mpj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yilta parnakamu ngarnka pakirriku, ka ngayumili wangkaju yilta wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jiijajju-janampa yarrarnu wajarnu, “Palu tayimula ngurrpa wulikaja nyinaku, ngayulurrju. Mamamili wikarrukajaya ngurrpa nyinaku, kujuwiyajura Mama ninti nyinani. ");
INSERT INTO mpj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Julyju mitunyjarripurluka yini Nuuwa nyinapayi. Palu tayimuya martukaja nyinapayi, Mamakuraya parlanypa nyinapayi. Yurtuyurtuluya mirrka ngalkura nyinapayi, kamu nyupawintiya yurtuyurtu nyinapayi. Jilanyaya yurtuyurtu nyinapayi, ka kalyu majulu-jananya miturntanu. Kalyu maju punkalkija, kaya Nuuwamapu kurrungu puutja majungka nyinapayi, kaya wankarringu kalyu majungkamarra. Jilanyayuruya martukaja yarnnga yurtuyurtu nyinaku, jamparna ngayu martu yarnngaku marlpa marlakurriku. ");
INSERT INTO mpj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Ka palunya tayimu yirna kujarrapula kaatanmayangka warrkamurrimalpa. Ka yirna kujuya wikarrukajalu manku katiku, ka yirna kujupaya junku yanku. ");
INSERT INTO mpj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kayilapa wanti kujarralupula wilyki yungkanmalpa. Ka kuju wantiya wikarrukajalu manku katiku, ka wanti kujupaya junku yanku. ");
INSERT INTO mpj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Wurlkumarta, jungajuya wulu nyinama!, maaja Jiijajparna-nyurrampa marlaku yankuninpa. Tayimuku palukunyurra ngurrpa, ngayurna marlaku yankunyjangka. ");
INSERT INTO mpj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wangka yumuwanpa ngaaya kulila! Maajalu maya kanyilku wartakajawinti, ka yurtuyurtu yanku. Kayilapa martu kujupalu yanku kurrungku, ka ngulyulu manku wartakaja. Yiipi maajalu nintilu kulinngara, ‘Martu jiinya ngulyukurni yankuni’, kayilapa maaja palu ninti nyinangara, mirta yurtuyurtu yankungara. ");
INSERT INTO mpj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wangka yumuwanpa maaja jiiyurunyurra mirta yurtuyurtu yankura, kayilapanyurra Mamaku junga nyinakura, yurtuyurtuparni, jamparna ngayu marlaku yankurni, martu yarnngaku marlpa.” ");
INSERT INTO mpj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","51","Jiijajju-janampa yarrarnu yumuwanpa wangka wajarnu, “Maajalu kanyilku maya, kayilapara mirraku palumili warrkamupurlukaku nintipurlukaku. Wajalkulu jilanya, ‘Maajarnanta junkuninpa karlki warrkamupurlukakajaku. Nyuntulu-jananyan yungkumalpa mirrkakamu kukalurrju, warrkamurriraya maya kanyilkuraku.’ Palujanuyila maaja palu yanku. Yiipi warrkamupurluka nintipurlukalu palulu jilanya kulilku, ‘Maaja wirrirli yanu, ngulawiyaju yankurni.’ Palujanu-jananya karlki warrkamupurlukakaja pungkumalpa, mirta-jananya mirrka yungkumalpa. Ka yanku-jananya wamapurlukakajangka jikinmalpa, kujungkalu. Palujanuyila ngula maaja palu marlaku yankurni, kayilapa warrkamupurluka nintipurluka yurtuyurtu nyinamalpa, kayilapa julurrangkaku. Maajalu jakurlpa kulilku, kayilapa nayipuwintilu katupungku yarnngalku miturriraku. Jampa palu maaja ngurra kujupangka nyinamalpa, ka yiipi warrkamupurlukalu nintipurlukalu kulilku, ka kunyjunyulu ngapilku. Kayilapa ngula maaja palurni marlaku yanku, ka nyaku warrkamupurluka nintipurluka kunyjunyulu maya kanyilpayi. Kara pukurlarriku wajalkulu, ‘Nyuntun warrkamupurluka kunyjunyu nyinapayi, ka ngayulurnanta junku maaja maju, mayakukamu jiipukajakamu pulukuku, ngurra parlparrikulurrju.’” Jiijajju-janampa yarrarnu wajarnu, “Palu warrkamupurluka nintipurluka pakiwana nyinapayi. Ka paluyurukaja Mamalu wajalku kurtingku warukarti, jiingkaya yulamalpa wilyjiwilyjiwinti.” ");
INSERT INTO mpj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jiijajju-janampa yarrarnu wajarnu, “Mamalu palumili walyjakaja ngampurrju kanyilku. Palu tayimu jilanya nyinaku. Yirnalu marrirtikijalu wantingka, wajalku-jananya kujungkarrirakuya pukurlju ngalkuraku, maya majungka, wantimili walyjakajamilingka. Kaya yurrkanykaja tin wulikaja maya majukutu jiikutu yanku, kujunkujunwintiya laampuwinti. Majalkuya yawujayiti jiiku yirnaku, ngulaya kurrungkuraku, mayangka jiingka majuwartangka. ");
INSERT INTO mpj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ka yurrkany payip wulikajaluya kurranyilu nintilu kulilku, ka-ngkuya laampukaja pilamapulku karrijinwintilu. Kaya paatul kujupangka-ngkuya kujunkujunja pilamapulku karrijinpa, kayilapaya katiku maya majukarti, karaya majalku, jii yirnaku. Karlkin kujupaluya payip wulikajalu ngakumparriku, ka-ngkuya laampungkawiyaju pilamapulku karrijinpa, kaya yanku maya majukarti, majalkuraku. Mirta-ngkuya paatul kujunkujunja pilamapulku, paki. ");
INSERT INTO mpj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yirna palu marrirtikijalu marlarriku, kayilapa mungajarrarriku. Palujanuya yurrkanykaja tin wulikaja purtu majalku, kaya kunyalarriku, laampukajawiyaju-janampa kampamalpa. ");
INSERT INTO mpj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kayilapa martu kujupalu-jananya yanku kanalku, ‘Pakalaya! Kuwarrirni palu yirna yankurni.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Palujanu yurrkany nintikajaluya pakalku, ka-ngkuya laampukajangka yintilku pakilku karrijinkaja paatuljanu, kaya tililku. ");
INSERT INTO mpj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kaya yurrkany ngakumpakajalu purtu japilku-jananyaya jilanya, ‘Karrijinpa-lanyajuya yuwa!, laampu-lajungku pilamapulkuraku, laampu-lampajuku juturrijaku.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka yurrkany nintikajalu-janampaya wajalku, ‘Paki! Yiipilajuntaya yaapu yungku laampu-lampajuku jampalyu juturriku, ka nyunturtinmililurrju laampukaja jampalyu juturriku. Yarraya karrijin kujupa payamula!’ ");
INSERT INTO mpj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Palujanuya yurrkany ngakumpakaja yanku karrijinpa payamulkuraku, kayilapa marla yirna palu yankurni wantikura. Palujanu yirna palurni yanku, kaya kujungkarriku yurrkany nintikajalurrju. Kayilapaya yanku maya majungka kurrungku, kayilapa warrkamupurlukalu tuwukaja jatamapulku. Palujanuya mayangka ngalku pukurlarriku. ");
INSERT INTO mpj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Palujanuya yurrkany ngakumpakajalu-ngkuya karrijinpakaja payamunku, laampungka-ngkuya yintilkuraku, kayilaparniya marlaku maya majukarti yankurni, yawujayiti yikiku. Kayilaparaya yirna paluku mirraku jilanya, ‘Maaja! Kurrujula-lanyaju!, mayangka.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka yirna palulu-janampa wajalku, ‘Paki! Ngurrparna-nyurrampa.’” ");
INSERT INTO mpj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jiijajju-janampa wajarnu, “Yirna palu-jananya yanurni jampaya yurtuyurtu nyinapayi, mirtaya yurrkany ngakumpakaja wurarti nyinapayi. Palujanunyurra paluyurungkamarra jungajunyurra wurarti majanmalpa, jamparna ngayu marlakurriku.” ");
INSERT INTO mpj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jiijajju-janampa yarrarnu wajarnu, “Mamalu palumili walyjakaja ngampurrju kanyilku. Palu tayimu jilanya nyinaku. Yirna maaja ngurra kujupakarti wirrirli yankukijalu, palumili warrkamupurluka yupal wulikajaku mirraku-janampa. Ka-janampa wajalku palumili mayakamu wartakaja, parnalurrjuya ngampurrju kanyilkura. ");
INSERT INTO mpj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kara kuju warrkamupurluka, mani maju yungku payip jawujun tala, palunga warrkamuku nintipukaminyirri. Ka kujupara yungku mani tuu jawujun tala, palunga warrkamuku ninti. Ka kujupara mani yungku wan jawujun tala, palunga mirta warrkamuku ninti. Ka wajalku-jananya kintiluya wartakaja payamulkura jiipwanpa, palujanu ngula jiikajaya jalamunkura mani majuku. Palujanu maaja palu ngurra kujupakarti wirrirli yanku. ");
INSERT INTO mpj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Palulu warrkamupurlukalu nintipukaminyirrilu yanku payamunku wartakaja jiipwankaja, payip jawujun talawintilu. Kayilapa kanyilku ngulayila kangku-jananya jalamunku, kayilapa mani maju manku, tin jawujun tala wulikaja. ");
INSERT INTO mpj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kayilapa warrkamupurluka nintilu palulu yanku payamunku wartakaja jiipwankaja, tuu jawujun talawintilu. Kayilapa kanyilku ngulayila kangku-jananya jalamunku, kayilapa mani maju manku, puu jawujun tala wulikaja. ");
INSERT INTO mpj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Palujanu kujupalu mirta warrkamukura ninti, palulu yanku wan jawujun tala jawalku jampajunku, kujupaluya ngulyulu mankujakungkamarra. ");
INSERT INTO mpj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Palujanuyila ngula maaja palurni marlaku yanku, kayilapalu wajalku warrkamupurlukangka, ‘Mirra-janampa jii warrkamupurlukakajaku!, palukajalurniya wajalkura, yaaluya manikaja ngapirnu.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kayilapalu warrkamuku nintiminyirrilu yanku ka manilu yungku maajangka, kalu wajalku, ‘Maaja! Nyuntulurnin yungu payip jawujun tala, karna jiiwintilu muu ngapirnu. Ka yungkunirnanta, tin jawujun tala.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka maajalura wajalku, ‘Warrkamupurluka kunyjunyun nyuntulu ngapirnu, jungalu. Kuwarri maaja majurnanta junku martu yarnngakukamu wartakaja majukulurrju. Maaja maju kujarrali kujungka nyinaku.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kayilapalu warrkamuku nintilu yanku, ka manilu yungku maajangka, kalu wajalku, ‘Maaja! Nyuntulurnin yungu tuu jawujun tala, karna jiiwintilu muu ngapirnu. Ka yungkunirnanta, puu jawujun tala.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka maajalura wajalku, ‘Warrkamupurluka kunyjunyun nyuntulu ngapirnu, jungalu. Kuwarri maaja majurnanta junku martu yarnngakukamu wartakaja majukulurrju. Maaja maju kujarrali kujungka nyinaku.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Warrkamupurluka kujupa mirta warrkamuku ninti, jiilu kangku wan jawujun tala maajakarti, kalu wajalku, ‘Maaja! Nintirnangku nyuntun maaja wiltu nyininpa. Nyuntulu-jananyan wajarni warrkamupurlukakajangka warrkamurriraku, maniya ngapilkuraku, ka mirta-jananyan maju yungkuni mani warrkamujanu, julijuliwiyaju-jananyan mani yungkuni. ");
INSERT INTO mpj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Palujanurna ngayurnangku ngurlurringu, kayilaparna palu mani, wan jawujun tala kangu jawarnu jampajunu, kujupaluya mankujaku ngulyulu. Ngaarnanta yungkuni wan jawujun tala.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kalu maajalu palungka payilku wajalku, ‘Nyuntun warrkamupurluka walyku, liijipaka. Nyuntulun nintilu kulini, ngayulurna-jananya warrkamupurlukakajangka wajarni, warrkamurriraya mani ngapilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ngayumili manijun kangkungara payingkingka junkungara. Kayilapanta ngula payingkipurlukalu muu mani yungkungara, kayilaparna ngayulu muu mani mankungara.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","30","Kara maaja palulu wajalku warrkamupurluka kujupangka, ‘Mani palu wan jawujun talalu marra!, kayilaparan kangku yungku warrkamupurluka nintiminyirri, palulu kanyilkuraku. Kayilapan warrkamupurluka walyku ngaanya kangkun yawujayiti kurtingku warukarti yankura, wulu mungajarrangka nyinakura, wilyjiwilyjiwinti.’” Jiijajju-janampa yarrarnu wajarnu, “Yiipira martulu Mama ngarnawarrapurlukaku jungalu ngapilku, warrkamupurluka nintiminyirriyurulu, palujanura Mamalu puntajilu kunyjunyulu ngapilku. Ka yiipi mirta martulu jungalura Mamaku ngapilku, jiiyuru warrkamukura ngurrpa, palujanura mirta Mama ngarnawarrapurlukalu puntajilu kunyjunyulu ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jiijajju-janampa yarrarnu wajarnu, “Ngayurna martu yarnngaku marlpa marlaku yankurni, maaja maju, kayilarna-nyurranya kuutja yikijunku wajalku martu wulikaja. Kujungkalaju yankurni wikarrukajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Martu wulikajaya kuutja jiingka yikiku, warrarn kujupajanukamu parna kujupajanukamu martu kujupa kujupayuru. Kayilaparna-jananya katamatulku jiipuku maajayurulu. Martu ngayumili walyjakajaya jiipuyuru jaalpu kujungka yikiku, kaya martu walykukaja nanikurtyuru jaalpu kujungka yikiku. ");
INSERT INTO mpj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Palujanurna-jananya wajalku jiipukajayurungka, ‘Ngayumili Mama ngarnawarrapurluka-ngkuya pukurlarrini. Yarrarniya!, kangkurakurna-nyurranya Mamamili ngurrangkanyurra nyinakura. Julyju Mamalu-nyurranya kulirnu, jampa parnakamu ngarnka ngapilkijalu, palumili ngurrangkantaya kanyilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Julyjunyurra parnangka nyinapayi, kayilaparninyurra mirrka yungu, jamparna ngayu kalypartu nyinapayi. Kalyuparnirna marrku nyinapayi, kayilarninyurra kalyu yungu. Wamparlarna yankupayi, kajunyurra mirrangu mayakarti mirrkakamu kuka, pulanykartilurrju yungu, ngarriraku. ");
INSERT INTO mpj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kayilapa kulujuparnirna nyinapayi, kayilarniyan manu kuluju yungu. Ngarntarna nyinapayi, kayilaparniyan yanu ngampurrju kanyilpayi. Jiiljarna nyinapayi, palujanurniyan yankura kanyilpayi.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Palujanurniya jiikajalu purtu kulilku, karniya japilku, ‘Maaja, nyaartalajunta nyangu kalypartun nyinapayi?, kalajunta mirrka yungu, munkurrirakun? Ngurra wanyjangkalajunta nyangu marrkun nyinapayi?, kalajunta kalyu yungu, jikilkurakun? Purtulaju kulini.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ka yarralkurniya japilku, ‘Nyaartalajunta wamparla nyangu?, ka mirrkakamu kuka pulanykartilurrju yungu? Ngurra wanyjangkalajunta kulujuparni nyangu?, ka kulujukaja yungu? Purtulaju kulini. ");
INSERT INTO mpj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ngurra wanyjangkalajunta ngarntapurluka ngampurrju kanyilpayi? Nyaartalajunta jiilja nyangu kuju nyinapayi?, kalajunta yanu kanyirnu. Purtulaju kulini.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Palujanurna-janampa wajalku, ‘Wangka ngaanyaya kulila! Ngayumili walyja kalypartu nyinapayi, kayilaparanyurra mirrkakamu kuka yungu, munkunu. Jilanyaluranyurra ngayuku walyja yungu, palujanurna ngayu pukurlarringu, jumaji palu ngayumili pamuli. Yiipirna ngayu jiingka kalypartu nyinangara ngayukulurrjunyurra nyarrurringara, karninyurra yungkungara.’” ");
INSERT INTO mpj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jiijajju-janampa yarrarnu wajarnu, “Karna-jananya kujupakajangka wajalku, nanikurtyurukajangka, ‘Mawu yarraya warukarti! Mamalu julyju wajalpayi walykukajanyurra warukarti yankuraku. Julyju wajalpayi malpumili maajakamu malpukajaya warukarti yankuraku. ");
INSERT INTO mpj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Julyjunyurra parnangka nyinapayi, kayilaparninyurra mirrka mirta yungu, jamparna ngayu kalypartu nyinapayi. Kalyuparnirna marrku nyinapayi, kayilarninyurra mirta kalyu yungu. ");
INSERT INTO mpj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Wamparlarna yankupayi, kajunyurra mirta mirrangu mayakarti mirrkakamu kuka, pulanykartilurrju yungu, ngarriraku, paki. Kayilapa kulujuparnirna nyinapayi, kayilarniyan mirta manu kuluju yungu. Ngarntarna nyinapayi, kayilaparniyan mirta yanu ngampurrju kanyilpayi. Jiiljarna nyinapayi, palujanurniyan mirta yankura kanyilpayi.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Palujanurniya jiikajalu purtu kulilku, karniya japilku, ‘Maaja, nyaartalajunta nyangu kalypartun nyinapayi?, kalajunta mirrka mirta yungu, munkurrirakun? Ngurra wanyjangkalajunta nyangu marrkun nyinapayi?, kalajunta mirta kalyu yungu, jikilkurakun? Purtulaju kulini.’ Ka yarralkurniya japilku, ‘Nyaartalajunta wamparla nyangu?, ka mirrkakamu kuka pulanykartilurrju mirta yungu? Ngurra wanyjangkalajunta kulujuparni nyangu?, ka kulujukaja mirta yungu? Purtulaju kulini. Ngurra wanyjangkalajunta ngarntapurluka mirta ngampurrju kanyilpayi? Nyaartalajunta jiilja nyangu kuju nyinapayi?, kalajunta mirta yanu kanyirnu. Purtulaju kulini.’ ");
INSERT INTO mpj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Palujanurna-janampa wajalku, ‘Wangka ngaanyaya kulila! Ngayumili walyja kalypartu nyinapayi, kayilaparanyurra mirta mirrkakamu kuka yungu, munkunu. Ngayuku walyjaranyurra mirta yungu, palujanurna-ngkuya ngayu mirta pukurlarringu, jumaji palu ngayumili pamuli. Yiipirna ngayu jiingka kalypartu nyinangara ngayukulurrjunyurra mirta nyarrurringara, karninyurra mirta yungkungara.’” ");
INSERT INTO mpj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jiijajju-janampa yarrarnu wajarnu, “Yilta waru majukartiya yanku wulu nyinamalpa, kaya ngayumili walyjakaja wanka wulu nyinamalpa, Mamamili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jiijajju-jananya wangkapayi martukajangka wangka-nintikajangka palumilingka. Nintilpayi-jananya, kayila-janampa wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Juwukajala kujungkarripayi mirrkaku Mamayilala marninypungkura. Palunya karrpuparaku-lampa yini Pajuwupa. Karrpu kujarrangkala palunya ngalulku martukajalu. Jiingkarniya karrpungka ngalulku, martu yarnngaku marlpa. Karlkilurniya yurntulku yungku, karniya karlki kujupalu wiltijunku wartangka, karna miturriku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Palunyajanuya jiingka karrpungka martukaja Juwukaja kujungkarringu. Pakarnuya yatilyparaku majuparaku, yirnakajalurrju. Wumurringuya, nyinapayiya wangkakarra. Nyinapayiya mayangka Kayapajmilingka. Mayangkaya majuwartangka nyinapayi. Kayapajpanga-janampa Yatilypa majuminyirri martukajaku Juwukajaku. Wangkapungkupayiya, ngalulkijaluya wuralu Jiijajpa, kaya pungkukijalu mitu. ");
INSERT INTO mpj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Maajakajalu-ngkuya wajarnu, “Jampaya martukaja kujungkarriku nyinaku turlku yini Pajuwupaku, mirtala ngalulku, paki. Junkula kurlunga!, wuralula ngalulku. Pakingkangaya martukaja wirrilyirrijaku, jurtarrijaku-lampaya.” ");
INSERT INTO mpj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Palunyangka Jiijajkamu palu wangka-nintikajalurrjuya tawunja Piijaningka nyinapayi, puntu Jayimunku ngurrangka. Jayimun julyju ngarnta lipurujiwinti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jiijajju mangarri ngalkupayi, yanulu yurrkanyju katangka yintirnu jinyji, paatuljanu wupuntamunuka. Jinyji palunga mani jumawarta. Julyju payamunu kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Karlkinparaya palumili wangka-nintikaja wirrilyirringu. Wajarnu-ngkuya, “Nyaaku palu yurrkanyju jinyji yintirnunirra. Yungkungara-langku katirala jalamunkungara mani majuwartaku. Ka yungkungarala-jananya nyarrukaja wulpipulpa, ngarntawintikaja, mani.” Palunyajanu yurrkanykuraya wirrilyirringu. ");
INSERT INTO mpj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Palunyangka Jiijajju-jananya wajarnu, “Jurraya!, yurrkanypa nyarru. Nyamurni yintirnu, palyaminyirri.” ");
INSERT INTO mpj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jiijajju-janampa yarrarnu wajarnu, “Jiikajangaya nyarrukaja wulpipulkaja nyininpa kunyjunyu-janampanyurra palukajaku ngapilkura. Ngayukulurrjukujunyurra kuwarri kunyjunyu ngapilkura, mirtarna-nyurranya rawa nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wanti jiilurni kuwarri kunyjunyu ngapirnu. Murrarnila jinyji mitungka yintirni. Palunyayururni yurrkanyju ngaalu yintirnu kurranyi, nintipukalu. Marlawanalurniya tuunyjunku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jiijajju-jananya yarrarnu wajarnu, “Wangka ngaanyaya kulila! Wangka ngayukurnu wajalkunyurra yinta kujupangkakamu yinta kujupangka, yarnngalu, marlajanukajalulurrjuya. Wangka ngaa kujupalurrjuya parra wajalku, ngaalurni yurrkanyju yintirnu, katangka, jinyji. Yuwa, wangka jiikuraya martu yarnngalu kulilku karaya ninti nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Julyju-jananya wumurnu Jiijajju martukaja, walyjamarrikajaya. Tuwalpaya nyinapayi, palumili wangka-nintikaja. Jiingka yarnngangka nyinapayi Juutajpa, Yijikariyatmartajinga. Palunyajanu-jananya Juutajpa yanu yatilyparakukarti majuparakukarti Juwuparakukarti. ");
INSERT INTO mpj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ka-jananya japirnu, “Jamparna-nyurranya yungku Jiijajpa, nganarninyurra yungku puntaju?” Palunyajanuraya manu yungu mani. Yunguraya jilpakaja yapukaja yarnnga jaarti wulikaja. Mani-janampa julyjujanu, mani maju. ");
INSERT INTO mpj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Palunyajanu ngarrurta majalpayi Juutajpa, yungkukijalu-jananya Jiijajpa Juutajju. ");
INSERT INTO mpj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Juwukajaya Pajuwupakuraya kujungkarripayi, kukurnjarriya pungkupayi ngalkukijalu. Palunyangka Jiijajmili wangka-nintikajaluya japirnuraya Jiijajpa, “Ngurrangkala wanyjangka junku mirrkakamu kukurnjarri?, ngalkurala ngayunju.” ");
INSERT INTO mpj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wajarnu-janampa Jiijajju walyjaku palumiliku wangka-nintiku, “Nyingka martu nyinani Jarujalumungka mayawinti? Yarraluya wajala jilanya!, ‘Maajalu-lanyaju wajarnu kurtingu ngayurtinmililu, wajalkuralajunta palumili wangka. Jiijajju wajarnu jilanya, “Jampakartangulyurna miturrikijalu, ngalkulajunta mirrkakamu kukurnjarri nyuntumilingka mayangka ngayunju.” ’” ");
INSERT INTO mpj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Palunyajanuraya wangka kangu. Kayilaya kujarnu mirrka, kukurnjarrilurrju. ");
INSERT INTO mpj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jampa mungarrmungarrarringu, yanuya mayakarti Jiijajmalu. Nyinangu-jananya Jiijajpa tuwalja palumilikajangka, wangka-nintikajangka. ");
INSERT INTO mpj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jampaya ngalkupayi, Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Ngaangka martu nyinin kuju ngalkuraka. Palunyalu-jananya wajalku, ngayurniya mankuraku karniya kangku kanyilkura.” ");
INSERT INTO mpj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kulirnuya wirla walykurringu. Jiijajpaya japirnu kujunngurulu kujunngurulu, “Kajirnin ngayu wajarni? Ngayurna ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jiijajju-jananya wajarnu, “Ngayuku walyjajunyurra tuwal wulikaja. Kujulu-jananya yanku wajalku, ngayurniya mankuraku. Palunyangka jiilunga kujulu ngaangkaliju karrkartangka mirrka tupurljuninpa. ");
INSERT INTO mpj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ngayurna-nyurrampa puntu yarnngaku marlpa nyininpa. Yiltarniya kuwarri miturntanku. Jilanya Mamamili wangka jakurlpurlukalu julyju mirlimirlingka wakarnu. Martu palunyalu-jananya yanku wajalku ngayurniya mankuraku. Yilta-jananya ngayuku jakurljunku. Palunyangka wirla walyku nyinaku, mirta pukurlpa. Palunyangka Mamalu palu martu warrkilku yiyalku ngulampa, mirta Mamamilingka ngurrangka kurrungku.” Palujanu Jiijajju-janampa yarrarnu palumili wangka-nintikajaku wajarnu jilanya, “Palunga yilta walyku nyinaku. Palya nyinangara jii martu jakurljunkuparni. Juku miturringara palunyangka Mamalu katingara ngurrakarti, palumilikarti.” ");
INSERT INTO mpj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Juutajpalu nyinangu Jiijajja. Palunyalunga juntumalkukija ngulampa Jiijajpa, kaya karlkilu pungku miturntalku Jiijajpa. Wajarnura Jiijajku, “Nintipuka! Kajirnin ngayu wajarni? Ngayurna ngurrpa.” Palunyajanura wajarnu Jiijajju, “Yuu. Nyuntulungulyurnin.” ");
INSERT INTO mpj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ngalkupayiya Jiijajmalulu jaapa. Ka Jiijajju karlukarlu manu ka Mamangkalu marninypungu, “Mirrka-lanyajun ngaanya yungkuni.” Ka warlangu yunguyila-jananya. Wajarnu-jananya, “Nyii! Mirrka ngaa ngalaya! Ngayu kawurninyurra ngalkurni.” ");
INSERT INTO mpj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Palunyangka wama manu kaapungka. Ka Mamangkalu marninypungu, “Wama-lanyajun ngaanya yungkuni.” Ka-jananya kaapu yungu, jikilkurakuya. “Jikilaya wama ngaanya!” ");
INSERT INTO mpj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ka-janampa Jiijajju yarrarnu wajarnu, “Wama ngaa ngayurninyurra jikirnu mijiyuru. Julyjuya kuka mirtayirti pungkula miji yintilpayi, Mamalu-janampa walyku wirrupungkula kunyjunyulkura. Kuwarrirna-nyurrampa wartangka miji yintiku mirtayirtiyuru, puntukajakurna-nyurrampa, walyku wirrupungkula kunyjunyulku. Jamparna miturriku Mamaluntaya martukaja jamartapungku walykukaja wirrupungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mirtarna wituka jikilku ngaanya wama parnangka, paki. Ngurra kujupangkarna jikilku ngula. Mamalu-jananya ngampurrju kanyilku palunyamili puntu walyja. Kujungkarrikurna-jananya jikilku wama kujupa.” ");
INSERT INTO mpj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mamakuraya yinkarnu turlku, kaya pakarnu yanu yapukarti, yini Yalipajkarti. ");
INSERT INTO mpj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jiijajju-jananya wajarnu wangka-nintikajangka, “Kuwarrirninyurra junku yanku. Palunyayuru Mamakurnu wangka nyinin jilanya, ‘Kukurnjarriku maajaya pungku. Palunyangkaya pinipinirriku, kukurnjarri kujunkujun.’” ");
INSERT INTO mpj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jiijajju-jananya yarrarnu wajarnu, “Mamalurni mitujanu wankalku, karna yanku marlaku parna Kaliliyakarti. Kurranyirna ngayu yanku, ka marlarniyan yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piijalura wajarnu, “Karlkiluntaya junku yanku ngayulurnanta mirta junku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiijajjura Piijaku wajarnu, “Wangka ngaanya kulila! Kuwarri mungajarra pawurla mirraku. Palunyangka kurranyi ngayukujun ngurrpajunku, yupal tayimu.” ");
INSERT INTO mpj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piijalura wajarnu, “Mirtarnangku ngurrpa wajalku. Yiipi nyuntuntaya pungkukijalu, palunyangkali kujungka ngaraku, ngayu kujarra-linyaya pungkuraku.” Jiijajmili wangka-nintikajaluya wajarnu, “Yuu, palunyangkala kujungka ngaraku jijaku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Palunyajanuya Jiijajmapu purnukutu yanu, yini Kajimanikarti. Jiijajju-jananya marrkurnu, “Ngaangkajuya purnungka majala!, yankurarnalu Mamangka wangkakura.” ");
INSERT INTO mpj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Karlki-jananya marrkurnu ka yupalpa-jananya katingu, Piija, Jayimijpa, Jaanpa. Wirla walykurringu Jiijajpa. Jii kujarra, Jayimijpakamu Jaanpa, yirna Jipitimili kaja kujarra. ");
INSERT INTO mpj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ka wajarnu-janampa, “Wirlarna walykurrinpa, jampangulyurna miturriku. Ngaangkajuya majala!, nyakumarniya!, wiyanyurra kunyalarri!” ");
INSERT INTO mpj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jiijajpa maa yanu parnangka wartuyikingu. Ka Mamangkalu wangkangu jilanya, “Mama, nyuntun maparn maju, palyalu-jananya marrkulku, ngayungkamarra! Mayitin nyuntulu kulirni pungkurakurniya. Waal palya ngayurniya pungku, jumajin nyuntulu kulirni, palya.” ");
INSERT INTO mpj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Palunyajanu-jananya Jiijajju yanu nyangu kunyalaya ngarrinyjanpa. Piija kanarnu Jiijajju, kara wajarnu, “Jayimun Piija! Nyaajanun nyuntu kunyalarringu? Rawaparnirna yanu marlakurringu. Kananyurra nyinangara nyakungarajunyurra.” Yarrarnu-jananya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Kanaya nyinama!, nyakumajuya! Mamangkaluya wangka!, kujupalu-nyurranya muunpungkujaku, ngayurninyurra junkula yankujaku. Palyalunyurra kulirni, ngayukujunyurra junga nyinakuraku, kujupalu-nyurranya mayitpi muunpungkujaku, ngayurninyurra junku yankuraku. Palunyangkamarranyurra Mama japinmalpa.” ");
INSERT INTO mpj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jiijajpa marlaku yanu yarrarnulu Mamangka wangkangu, “Mama, mayitin nyuntulu kulirni pungkurakurniya. Waal palya ngayurniya pungku, jumajin nyuntulu kulirni, palya.” ");
INSERT INTO mpj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wangkanintikajaya nyinangu nyuurrarringu, ka kunyalarringu. Palunyajanu-jananya marlaku yanu nyangu kunyalaya ngarrinyjanpa, mirtaya kana nyinangu, paki. ");
INSERT INTO mpj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jiijajpa wituka yanu marlaku Mamangkalu wangkapayi, wangka palunyayuru. ");
INSERT INTO mpj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Palunyajanu-jananya marlaku yanu wajarnu, “Nyaakunyurra kunyala ngarrinpa? Nyamu pakalaya! Kuwarrirniya manku katikurniya yungku walykukajangka, martu yarnngaku marlpa. ");
INSERT INTO mpj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pakalaya!, kujungkala yanku. Jii-jananyaya nyawa!, yaninparniya laltu. Kuju jiingkarni yaninpa palulunga-jananya jakurljunu, ngayurniya mankuraku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Palunyangka Juutajpa yanurni palungara Juutajpanga wangka-ninti nyinapayi, Jiijajku. Juutajmapuya yankupayi, karlkinpangaya nayipu majuwinti yankupayi, ka karlkinpangaya wanawinti. Jaajmapulu-jananyaya wajarnu yiyarnu, yirnakajalukamu, yatilyparakulukamu. ");
INSERT INTO mpj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nayipuwintikamu wanawintilurrju-jananya kurranyilu Juutajju wajarnu, “Palunyarna-nyurranya Jiijajpa nintilku, yankurna nyunyjulku. Palunyangkanyurra manku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Juutajpalu yanu Jiijajja wangkangu, “Nintipuka! Nyuntun kunyjunyu?” Palunyajanu nyunyjurnu. (Murrarniluya Juwukajalu julyju nyunyjunma-ngkuya kujungkarrira.) ");
INSERT INTO mpj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jiijajjura wajarnu, “Walalurni wanyjalmala!” Palunyangkaya Jiijajpa manu nayipukajawintilu, kaya ngalulpayi. ");
INSERT INTO mpj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jiijajmili wangka-nintilu nayipu majuwintilu yilarnuka katupungu kuran punkajunu, kuju yatily majumili warrkamupurluka. ");
INSERT INTO mpj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Palunyajanura wajarnu Jiijajju puntu walyjaku nayipuwintiku palunyamiliku, “Jurra! Jurrangku marlaku nayipu! Nyingka wangka julyjujanu. ‘Jampa martulu nayipuwintilu wakalku kujupa martu, palunyajanuya nayipuwintilu wakalku miturntalku puntajulu, karlkilu.’ ");
INSERT INTO mpj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ngurrpa wulun?” Jiijajjura wajarnu. “Jamparnara kuwarri japiljaku ngayumili Mama, kurtingkurakurni palunyamili wikarrukaja yarnngaminyirri, kajuya pipurru yankura purnturrijaku. ");
INSERT INTO mpj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mirtarna kuwarri japilku Mama, yiyalkura-jananya wikarrukaja, paki. Jamparnijuya wikarrukaja yanku, mirtarna miturriku, paki. Nyampaya julyjukurlulu wangka wakarnu mirlimirlingka Mamamili wangka jakurlpurlukakajalu. Wajarnuya, ngayurna miturriraminyirri. Kuwarriyila yiltarringu wangkanga, yuu. Miturrikurna.” ");
INSERT INTO mpj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Palunyajanu-jananya wangkangu Jiijajpa martungka jurtawartakajangka. Wajarnu-janampa, “Mirtarna ngayu winyjurrurninti! Nganakurninyurra yanu yarnnga? Nganakurninyurra yanu jantulwinti?, nayipukamu jurtinywinti. Karrpu kujarra karrpurninyurra nyangu jaaji majungka. Nintilpayirna-jananya martungka jiiwatingulyu. Mirtarninyurra ngalurnu palunyawati, paki, junurninyurra. ");
INSERT INTO mpj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Julyjuya wangka wakarnu mirlimirlingka Mamamili wangka jakurlpurlukakajalu. Wajarnuya, ngayurna miturriraminyirri. Palunyajanuyila yiltarringu kuwarri, yuu.” Palunyajanuluraya junuka pinirringu wangka-nintikaja palunyamilikaja yarnnga. ");
INSERT INTO mpj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jiijajpaya winirnu katingu maaja majukarti Yatilykarti, palumili ngurrakarti. Maaja palu-janampa yini Kayapajpa kurranyi mirrangu kujungkarriraku, Muujajmili wangkapurlukakajakamu yirnakaja. Kujungkarriraya majalpayi Jiijajku, maajamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piijalu Jiijajja marlakarti wanalpayi wirrirlilu. Maajamilingka ngurrangka piinyjingka jarrpangu. Jiingkaya jantulwintikaja nyinapayi. Ka yanu-jananya nyinatingu, ka ngunjulpayi, “Jiijajpaya wanyjalmalku?” ");
INSERT INTO mpj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mayangka kaninyjarra maajakajalu-ngkuya japirnu, “Kuutja ngaangka nganalu-lampa wajalku?, jii Jiijajju ngana putamanu.” ");
INSERT INTO mpj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Purtu-ngkuya jilanya japirnu, martulu jungalu jakurljunkuraku. Palunyangkaya karlkin kujupalu pakarnu mayujunu. Karlkinjuya pakiwana wajalpayi. Mirtaya wangka kuju wananma. Palujanupula kujarra kujupalu pakarnu jakurljunu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Kulirnuliju jiilu Jiijajju wajarnu jilanya, ‘Jaajpa maju paluya martu laltulu palyara ngarajunu karna ngayulu warlangku. Palujanurna karrpu yupaljarna ngayulu palyalku ngarajunku, jaajpa kujupa, mirta martu laltulu, paki.’” ");
INSERT INTO mpj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Palujanu Maaja majulu palulu pakarnu Jiijajja japirnu, “Nyaapula palu kujarralu wajanu?, nyuntulun jaaji kujupa ngapilkuraku. Wajala-lanyaju!” ");
INSERT INTO mpj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jiijajpa yaka yikipayi, mirta wangkangu. Maaja majulu palunyalu yarrarnu japirnu, “Mama ngarnawarrapurlukangka kurungka, junga-lanyaju wajala! Kajin nyuntu Kurayijpa ngarinpa?, Mamaku kaja?” ");
INSERT INTO mpj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jiijajjura wajarnu, “Yuwa. Ngulangarninyurra nyaku Mamangkarnalu kujungka nyinaku, ngayurna-nyurrampa puntu yarnngaku marlpa. Maaja maju kujarraliju jiingka nyinaku maparn majuwinti. Ngularninyurra nyaku yurnturrjarna tiputiku, ngarnkajanu.” ");
INSERT INTO mpj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Maaja majura wirrilyirringu ka kulujpangku warlangu. Jiiyuruya Juwukajalu murrarnilu-ngkuya kulujpa warlangkuni, jampa kujupalu wajalku jilanya, “Mama ngarnawarrapurlukaliju maaja maju kujarra nyinani.” Jampangku warlangu kulujpa wajarnu-jananya, “Ngaalu pakiwana wajanu, mirta palu ngarnkapurluka, paki, ngaanya martu ngaamartaji, parnapurluka. Mirtala karlkikula-janampa mirraku wangkakura. Nyamula kuwarri kulirnu, palulungku wajanu, Mama ngarnawarrapurlukakamupula palu kujungka nyinani. Yilta, luwu-lampa warlangu. ");
INSERT INTO mpj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngananyurra wajalku? Yaalu mankula?” Yarnngaluya mitujunu. Wajarnuya, “Jantulwintikajaluya katira mitu puwa!” ");
INSERT INTO mpj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Palunyangkaluya Jiijajja ngumpangka jangajunma. Jiijajpaya karrpirnu kuru, nyakujakungkamarra, kaya ngumpa pungama. ");
INSERT INTO mpj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ngarlpungarlpuluya japinma, “Nganalunta pungama ngumpa? Wajala-lanyaju! Nyuntun Kurayijpa nyininpa maparn maju. Wajala-lanyaju!” Jantulwintikajaluya jiiyuru Jiijajpa wituka pungama. ");
INSERT INTO mpj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Palunyangka Piija mayawati yaartungka nyinapayi. Maaja jiiku warrkamupurlukalu yurrkanyju yintarnu ka japirnu, “Kajin Jiijajjalun nyuntu nyinapayi?, Kaliliyamartajingka?” ");
INSERT INTO mpj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piijalu kajarnu jilanya, “Ngurrparna! Purturnanta kulirnin. Nganan wajarni?” ");
INSERT INTO mpj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piija pakarnu yanu kiitukutu ngarapayi. Yurrkanyju kujupalu warrkamupurlukalu nyangu Piija, ka-jananya wajarnu, “Yilta jiinyalu puntu Jiijajja Najarijmartajingka yankupayi.” ");
INSERT INTO mpj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piijalu yarrarnu-jananya wajarnu, “Mama ngarnawarrapurlukangka kurungkarna-nyurranya jungalu wajani, ngurrparnara martu paluku.” ");
INSERT INTO mpj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kinti ngarapayiluya wajarnu Piijangka, “Yilta, nyuntulun Jiijajja yankupayi, nyuntun Kaliliyamartaji, palunyayuru, wangka kujupan wangkin.” ");
INSERT INTO mpj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piijalu-jananya yarrarnu ngurrpajunu jilanya, “Mama ngarnawarrapurlukangka kurungka jungalurna-nyurranya wajarnin, ngurrparnara. Yiipirna paki wajarni, Mamalurni ngarnawarrapurlukalu pungku. Yiltarna-nyurranya wajarnin, ngurrparnara.” Palunyangka pawurla mirrangu. ");
INSERT INTO mpj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mirranyjanpa Piijalu kulirnu. Palungka Jiijajmili wangkangka kulirnu, ka yulapayi. Jilanya Jiijajju kurranyilu wajarnu, “Pawurla mirraku. Palunyangka kurranyilujun ngurrpajunku yupal tayimu.” Piija yilta yulangu kurntawinti. ");
INSERT INTO mpj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Palunyangka karrpu kujupangka jampa jirntu pakarnu, kujungkarringuya yanurni kujarraka yatilyparaku majuparaku, yirnakajalurrju. Wangkapunguya, kaya yiwilyirringu. Wajarnuya, “Yuu, yungkula-jananya Jiijajpa karlkingka, pungkurakuya.” ");
INSERT INTO mpj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Palunyajanuya karrpirnu Jiijajpa marawati mirrilyiwintilu. Palunyajanuya winitingu. Katinguraya yungu Payilatpa. Payilatpanga tawun Ruumjanu yanu, ka nyinapayi-janampa Juwukajaku maaja maju kapamanmili. ");
INSERT INTO mpj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mungangka-jananya Juutajju wajarnu yungu Jiijajpa. Karrpurrinyjangka nyangu Jiijajpa mirrilyiwinti Juutajju. Palunyajanu Juutajpa wuyurr kujuparringu. Palunyajanu-jananya yanu marlaku yatilyparakukarti majuparakukarti, yirnakajakartilurrju. Marlaku-jananya yungkukijalu mani jilpakaja yarnnga, jaarti wulikaja. ");
INSERT INTO mpj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Palunyajanu-janampa wajarnu Juutajju, “Ngayungulyurna walyku. Wajarnurna-nyurranya yungu puntu palya Jiijajpanga. Mirta walyku palu, paki. Kayilaya pungku karlkilu!” Palunyajanuraya wajarnu Juutajku, “Ngurrpalajura! Jiingangku nyuntuku!” ");
INSERT INTO mpj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Palunyajanu yanu Juutajpa Juwumili jaaji majukarti. Kurrunguka warningu mani jilpa mayangka jiingka. Kayila yanu. Palunyajanu yanu. Karrpirnungku Juutajju wartangka mirrilyiwintilu. Kayila wiltiyikipayi, ka miturringu. ");
INSERT INTO mpj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Palunyajanuya manu jurntarnu jilpa yatilyparakulu. Palunyajanu-ngkuya wajarnu, “Wanyjalmankula ngaanya mani? Ngaalara yungu mani, pungkukijalula Jiijajpa. Yuu, yintikuyila miji palunyamili. Miturriku Jiijajpa. Jampala mani ngaanya marlaku junku jaaji ngaangka, kunkarrikula. Putamankula luwu ngayurtinmili.” ");
INSERT INTO mpj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Palunyajanuya wururringuka wangkapungkupayi. Kaya yiwilyirringu. Palunyajanuya payamulkijalu paatiki. Kalyupintiya karlkilu palyanma jiingka paatikingka. Jampaya miturriku wamparlakaja jiingka Jarujalumungka, jiingka-jananyaya paatikingka karlkilu jampajunamalpa. ");
INSERT INTO mpj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Palunyajanuya yinijunu paatiki “Mijijanu Parna”. Yinijunuya Jiijajpa pukarrarrinyjangka. ");
INSERT INTO mpj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Julyjulu Mamamili wangka jakurlpurlukalu yini Jirimayalu jilanya wajarnu, “Yijurilmartajiluya wangkapungu. Kaya-jananya yungkukijalu martu jilpakaja, jaarti wulikaja. Palunyajanuya manu karlkilu jiinya mani jilpakaja. Palunyajanuya maniwintilu jaartiwintilu payamunu paatiki. Kalyupintiya ngapinma jiingka paatikingka karlkilu. Jilanyangulyurni wajarnu Mama ngarnawarrapurlukalu.” Palunyangkayila yiltarringu Jirimayamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Maaja majululu yini Payilatju Jiijajja japirnu, “Juwuku-janampan maaja maju yikini?” Ka Jiijajjulu wajarnu, “Yuwa. Nyuntumili wangka palu yilta nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Palunyangkaya yatilyparakulukamu yirnakajalulu Jiijajpa kuru wajalpayi, Payilatja mirangka, ka Jiijajpa yaka yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Payilatjura Jiijajku yarrarnu japirnu, “Jilanyantaya jiikajalu yupal tayimu kuru wajarnu. Nganan wajalku?” ");
INSERT INTO mpj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jiijajpa wulu wangkaparni ngarama. Mirta-jananya wangkangu, ka Payilatju purtu kulirnu. ");
INSERT INTO mpj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Juwukajaluya kujungkarripayi mirrkaku Mamayilaya marninypungkura. Palunya karrpuparaku-janampa yini Pajuwupa. Pajuwupa palunyangka Payilatju-janampa murrarnilu purijina kuju walajula yiyala, jampa Juwukajaluya Payilatpa japila. ");
INSERT INTO mpj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Palunyangka puntu kuju Parapajpa jiilja nyinama. Palunga yini kujupa Jiijajpa. Palukuraya martuku ninti yarnnga. ");
INSERT INTO mpj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Palunyajanuluya wumurringu Payilatwati mayangka martukaja. Ka-jananya japirnu Payilatju, “Wanyjajararna-nyurranya kurtingku? Mayitpirna kurtingku Parapajpa, mayitpirna kurtingku Jiijajpa. Karlkiluya yini palu wajalpayi, Kurayijpa. Kuliniya Mamalu julyju jamartapungu, kurtingkuraku” ");
INSERT INTO mpj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wangka paluku-jananya japirnu Payilatju, Jiijajpa walajunkura yiyalkura. Kurranyilu kulirnu Payilatju, “Juwumili maajakajaraya Jiijajku parlanypa nyininpa, jumajiraya martu yarnnga pukurlarrinpa. Palunyangkarniya katingu yikijunu.” ");
INSERT INTO mpj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Palunyajanuyila Payilatpa nyinapayi. Kulilpayi-jananya wangkanyjanpa. Palunyajanura yiyarnu wangka Payilatku nyupalu palunyamililu. Wangka jilanya, “Mirta putamanku jiinya kirta Jiijajpa. Jiinya nyarru, puntu palya. Kapukurrilurna nyangu Jiijajpa mungajarra. Karna wulu kana ngarripayi.” ");
INSERT INTO mpj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Payilatju-jananya wangka paluku, japirnu jilanya “Nganakuranyurra wangkani?” Palunyangka yatilyparakulukamu yirnakajalu-jananyaya parra yanu martukajangka muunpungkupayi, “Parapajpaya wajala!, mirta Jiijajpa. Jiijajpangaya mitu pungkuraku.” Jilanyalu-jananyaya muunpungkupayi martukaja. ");
INSERT INTO mpj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Payilatju-jananya yarrarnu japirnu, “Wanyjajararna-nyurranya kurtingku?, mayitpi kurtingkurna Parapajpa?, mayitpi kurtingkurna Jiijajpa?” Wiltuluya wajarnu, “Yiyala Parapajpa!” ");
INSERT INTO mpj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Payilatju-jananya yarrarnu japirnu, “Puntu kujupa Jiijajpa wanyjalmalkurna? Karlkiluya wajalpayi palunga yini Kurayijpa. Kuliniya Mamalu julyju jamartapungu, kurtingkuraku.” Ka wiltuluya wajarnu, “Wartangkaya martu jiinya wiltijula, miturntala!” ");
INSERT INTO mpj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Payilatju-jananya yarrarnu japirnu, “Jiinya ngurrpa. Ngana putamanu? Nganajanula wiltijunku?” Wululuya wiltulu wajalpayi, “Wartangkaya wiltijula miturntala!” ");
INSERT INTO mpj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Palunyajanu Payilatju wurrkulirnu, “Mirtarniya ngaakajalu kulirnin, paki. Jurtarrijakujuya, ngayulurna-jananya wajalku, ‘Ngurrparnara’.” Palunyajanu Payilatju lupungka kalyu manu. Kangku waajapungu mara mirakartilu. Ka-janampa wajarnu Payilatju, “Jampa miturriku jiinya martu, mirtarninyurra ngukarrila!, ngurrparnara. Jiinga-nyurrampa nyunturtinku!” ");
INSERT INTO mpj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Palunyajanuraya wajarnu yarnngalungulyu Payilatku, “Yuu. Jiinga-lampaju ngayurtinku, ngayunmiliku-janampa marlawanajanukulurrju. Yuu, wajarnilaju, miturriraku jiinya martu!” ");
INSERT INTO mpj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Palunyangka Payilatju Parapajpa kurtingu martukaja-jananya yarnnga pukurlmanu. Ka wajarnu-jananya jantulwintikajangka Payilatju, Jiijajpa wiipwintiluya pungkuraku. Yungkalpayiya. Palunyangka-jananya wajarnu Payilatju kangkuraya jantulwintikajalu wartangka wiltijunkura. ");
INSERT INTO mpj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Palunyajanuya jantulwintikajalu Payilatmilikajalu katingu Jiijajpa. Katinguya mayakarti Payilatmilikarti majuwartakarti. Ngurra palunyangka-janampaya jantulwintikajaku kujupakajaku mirrangu ka kujungkarnu. ");
INSERT INTO mpj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kujungkarringuya jantulwintikaja yarnnga. Kaluya palunyajanu wikilypungu Jiijajmili wara. Kaluya junu kujupa wara. Junuluya kuurtu mijimiji Jiijajja. ");
INSERT INTO mpj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yakirriyuruluya palyarnuka junu jilkarnkajawinti, katangkaluya. Kaya manu wana warlpukurru, kaluya junu marangka jungakartingka. Ngarlpungarlpuluya pupangu ka nyurnilu wajanma jilanya, “Maaja maju, wulu nyinama! Juwuku-janampan maaja maju yilta.” ");
INSERT INTO mpj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Palunyajanuluya warta paluwintilu manuka pungkupayi, katanyuku. Yumuluya pupatipayi, ka nyurniluya wajalpayi, ka Jiijajjaluya jangajunama. ");
INSERT INTO mpj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kuurtuya mijimiji tikamaturnu ka junuluya kulujpa walyja, marlaku. Kaya manu katingu wartakarti wiltijunkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tawunpaya junu yanu, ka nyanguya Jayimunpa, Jarinimartaji. Wajarnuraya Jayimunku jantulwintikajalu, “Ngaanya warta Jiijajkura marra kati!, yapu jiikutu.” Ka Jayimunju manu katingu. ");
INSERT INTO mpj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yapu yini Kulkujakutuya Jiijajpa katingu. Kulkuja wangka kujupa-janampa. Jilanyaya wajalpayi, “Kata tarrka ngurra.” ");
INSERT INTO mpj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Palunyajanuraya Jiijajjpa yungu wama, mitijinwinti, jikilkura. Jiijajju purtu yajinuka junu. ");
INSERT INTO mpj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngurra palunyangkaluya kulujpa tikamaturnuka wartangka nyiilamunu. Palunyajanuya warta Jiijajwinti yikijunu, wulu yikira miturrikura. Kaya jantulwintikaja parangkupayi kaartangkayuru Jiijajmili kulujkajawinti. ");
INSERT INTO mpj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Palunyajanuya jantulwintikaja nyinapayi. Kayilaya yirra nyakura kanyilpayi Jiijajpa wartangka wiltingaranyjanja. ");
INSERT INTO mpj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wartangkaya katu nyiilamunu pukujingka wangka jilanyawinti, “Ngaanya yini Jiijajpa, Juwuku-janampa maaja maju.” Kuutpurlukalu maajalu wajarnu, “Wangka jiinyaya nyiilamula jurra!” Murrarniluya wakara junkupayi, wangka martulu putamankunyjajanu. ");
INSERT INTO mpj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ngulyujanu-pulanyaya kujarra warta kujupa kujarrangka nyiilamunu yikijunu. Yupalpaya palungka ngarangu Jiijajpa kutungka. ");
INSERT INTO mpj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Martukajaya yiwarrajunma ka Jiijajpa wulu wanka wiltiyikipayi. Kaluya nyurnilu nyakura kaluya wajanma jilanya, ");
INSERT INTO mpj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nyuntulu-lanyajun wajarnu Juwumili jaajpa maju warlangkukijalun. Ka karrpu jurripalangkan marlaku palyalkija maparnwintilu. Wangka palunyan wajarnu. Palunyangka yiipin nyuntu Mama ngarnawarrapurlukamili kaja wiltiyikini, maparn majulungku tiputi ka wankala!” Jilanyaraya ngarlpulu wajarnu, mirta yiltalu. ");
INSERT INTO mpj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wangka palunyayuruya martukaja nyurniya wangkapayi, yatilyparakukamuya Muujajmili wangkapurlukakajakamu yirnakaja. Wangka kujupaya wajanma ngarlpungarlpulu, ");
INSERT INTO mpj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Jiilu-jananya martu kujupakaja wankalpayi. Mirtangku walyjalu wankarninpa. Mayitpi ngaa Juwuku-lampa maaja maju yilta wiltiyikininpa. Yiipi tiputiku jaalpu, palunyangkala kulilku Mamamili maparn maju nyininpa, yilta Kurayijpa.” ");
INSERT INTO mpj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kaya wajarnu, “Palunyalulu mirrjurni Mamangka. Jampara Mama pukurlpa paluku, Mamaluyila wankalkura kuwarri, yuu. Wajalpayi palulu, ‘Ngayurnara Mamaku kaja.’” ");
INSERT INTO mpj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Palu ngulyupurluka kujarralupula wartangka wiltingarapayi. Jii kujarralupula Jiijajja wangka jilanyayuru kiin nyurnilu wangka wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jirntu karrpungka parna parlparringka mungarringu. ");
INSERT INTO mpj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Palunyajanu rukayila marlaku jirnturringu. Jiijajju wartangkalu Mamangka wiltulu japirnu, “Yiluyi yiluyi lama japakajani.” Wangka walyjalu japirnu jilanya, “Mama ngarnawarrapurluka, nyaajanulurnin junu yanu?” ");
INSERT INTO mpj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngamuya karlki ngarangu wangka paluya purtu kulirnu. Pakiwanaya wajarnu, “Kulilaya! Mitupurlukakura Yilayijaku mirraninpa, julyju palunga miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kujupalura pinirringu wartangka kulujpa karrpirnuka wama yurnangka tupurljunu. Kalu yitijunu yungu. ");
INSERT INTO mpj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka-ngkuya wajarnu, “Kurlu nyawaya! Mayitpi Yilayija wankarriku ka yankurni kurtingku parnakutu, palu Jiijajpa.” ");
INSERT INTO mpj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Palunyajanu Jiijajpa yarrarnu wiltu mirrangu ka miturringu. ");
INSERT INTO mpj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Palunyangka jaajja majungka Juwuku-janampa kaliki yaarrangkangu, kaliki jiinya wiltu yikipayi. Palunyajanu parna yungkulypungu. Palunyajanuya purlikaja yaarryanu. ");
INSERT INTO mpj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jampa Jiijajpa miturringu, yaarryanuya mitupinti pirnkikaja. Karlkiya martukaja pukurrajanu wankarringu marlaku. Jiikajaraya julyju walyja nyinapayi Mamaku. ");
INSERT INTO mpj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jampa Jiijajpa ngulampa mitujanu wankarringu pakarnu, palunyajanuya yanu tawunkarti Jarujalumukarti. Mamakura tawunpa Jarujalumunga. Yarnngalu-jananyaya nyangu martukaja wankarrinyja mitujanu. ");
INSERT INTO mpj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Parra yikipayiya jantulwintikaja, nyakuraya kanyilpayi Jiijajpa. Maaja-janampa nyinapayi jiingkangulyu wituka. Kaya nyangu parna yurriyurrirrinyja, kaya nyangu karrpujanu mungarrinyja, kayilaya karratarringu. Ka-ngkuya wajarnu, “Yuu, yiltangulyu, ngaangara Mamaku kaja!” ");
INSERT INTO mpj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jiijajpa kurranyikurlu wanka wiltiyikipayi, palunyangkaya wantikajalu wirrirlijanulu nyakuma. Jampaya julyju Jiijajkamu wangka-nintikaja parna Kaliliyawana nyinapayi. Wanti palunyakajalu-jananyaya kanyilpayi ngampurrju, mirrkaya-jananya kujara yungkupayi. Wanti jiikaja-jananyaya Jarujalumukarti yanurni Jiijajmapungka. ");
INSERT INTO mpj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wanti kujarrangapula jiikajangka kujungka yikipayi yinipula Miiri Makatalamartajikamu, Miiri kujupa yakurti-pulampa Jayimijkukamu Juujapku. Palukajangka-jananya wanti yikipayi. Palungara yirna Jipitiku nyupa. ");
INSERT INTO mpj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Karrpu Purayitingka Jiijajpa miturringu. Rukarrinyjangka puntu Juujappa Yaramajiyamartaji yanurni. Palunga mani majuwinti nyinapayi. Yungunpa Jarriti-janampa ngarangu. Juwukajaya warrkamuparni nyininpa, Jarritingka, mirtaya tuunyjunkuninpa Jarritingka. Juujappangara Jiijajku walyja nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Juujappa palu yanu Payilatmili, mayakarti, ka jarrpangu Payilatpara japirnu, Jiijajpa mitu tipujunkula ka katira tuunyjunkura. Payilatjulu wajarnu Juujapja, kangkura tuunyjunkura. ");
INSERT INTO mpj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Juujapju julyju payamunu kanyilpayi, warntu mitupinti. Wartangkaya Juujapmapulu tipujunu kaya katingu warntungka tayimapurnu. ");
INSERT INTO mpj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kaya katingu pirnkingka ngarrijunu, ka yapuluya marlaku juturnu, Juujapmapulu. Pirnki palunya jiikajaluya jawarnu pirnkirnu, julyju, Juujappa ngulampaya mitu ngarrijunkuraku. ");
INSERT INTO mpj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wanti kujarralupula nyakupayi paluya Jiijajpa pirnkingka junu, yini Miiri Makatalamartajilukamu Miiri kujupalu. ");
INSERT INTO mpj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Juwukajaya nyina yurlta Jarritingka yulupirti. Mirrkanga-ngkuya kujala Purayitingka. Jiijajpa miturringu Purayitingka karrpungka, Yangamapungka. Palunyajanu jampa yungunjarrarringu Jarritingka, yanuluya Yatilyparaku majuparaku Payilatkarti, Parajikajalurrju. Parajikajaluya luwukaja Juwumilikaja ngampurr kanyinma. ");
INSERT INTO mpj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Karaya yanuka wajarnu Payilatku, “Yirna. Wurrkulirnilajura wangkaku palumiliku Jiijajku. Paki kajalpa jiinya martu! Wankalulpi wajarnu palulu, ‘Ngarrikurna mitu karrpu kujarra, karna wankarrikuka pakalku.’ ");
INSERT INTO mpj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Karu, wajala-jananya kurtiwa jantulwintikaja pirnkikarti! Kayilaya yankuka nyakura kanyilku ngurra yupalja, pakingkangaya palumilikajalu wangka-nintikajalu yankura ngulyulu mankujaku pinyipinyi jiinya. Ka-jananyaya karlkingka wajalku, marlaku wankarrinyja mitujanu. Julyjukurluya paki kajalpayi. Kuwarringaya wajaljaku yiltaminyirri paki!” ");
INSERT INTO mpj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Palunyajanu-janampa wajarnu Payilatju, “Kawa-jananyaya karlki jantulwintikaja! Yarraya! Jurra-jananyaya pirnkiwati!, kaya-jananya wajala!, ‘Pukunyjunyurra nyakura kanyilku!’” ");
INSERT INTO mpj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yanuya pirnkikarti. Kirtijunuya limpilimpingka tinkijunu. Kaya mirrilyi junu kutuwana. Ka-jananyaya jiingkangulyu junu jantulwintikaja Juwukajalu. Palunyajanuya jantulwintikajalu pukunyju nyakura kanyilpayi pinyipinyi. ");
INSERT INTO mpj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jarriti nyinangu ka Jaanti jirntu pakalkuraku kapula yanu wanti kujarra pirnkikarti mungawana, nyakurakupula pirnki, Miiri Makatalamartajilukamupula Miiri kujupalu. ");
INSERT INTO mpj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Palunyajanuyilarni Mamamili wikarru tiputingu ngarnkajanu, kayila parna yurringu wiltuminyirri. Palunyajanu wikarru palu yanu pirnkikarti, ka maa yurnturnu kurtikurtijingarnu yapu limpilimpi. Ka nyinatingu yapungka katu. ");
INSERT INTO mpj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jiilunga wikarrulunga rantalpayi karrpuyurulu. Kara waranga piirlpiirlminyirri. ");
INSERT INTO mpj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jampaya nyangu Mamamili wikarru jantulwintikajalu, karratawintiya tititipungu, kaya punkarnu parnangka. Mituyuruya ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","6","Palunyangka-pulanya wikarru palulu wajarnu, “Mirtapula ngurlu yikima! Ngurrirninparanpula Jiijajku Najarajamartajiku. Wartangka wiltiyikingu ka miturringu, kayilapa wankarringu yanu. Ngaawana ngarripayi, nyawapula!, pakirringulura.” ");
INSERT INTO mpj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wikarru palulu-pulanya yarrarnu wajarnu, “Parna Kaliliyakutu pakarnuka maa yaninpa, kurranyi-nyurrampa. Ngurra palunyangkanyurra yanku nyaku, Jiijajju-nyurranya kurranyilu wajarnu jiingkanyurra nyakuraku. Wangka palunya-jananyanpula wanti kujarralu yanku jakurljunku wangka-nintikajangka.” ");
INSERT INTO mpj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Palunyajanupula jawarnu yanu pirnkijanu wanti kujarra, ngurlujaka. Kapula pinirringu pukurlwinti, wajalkijalu-jananyapula wangka-nintikajangka jakurlpa. ");
INSERT INTO mpj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngaamarntu-pulanya Jiijajpa warinykatingu. Ka-pulanya wajarnu, “Wayiwanpula?” Kalupula yanu pupatingu jinawati, kapula yampurnu jinawati. Kapula pukurlju warlkulpayi Jiijajpa. ");
INSERT INTO mpj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Palunyajanu-pulampa wanti kujarraku Jiijajju wajarnu, “Mirtanpula ngurlurri!, paki. Yarra-jananyapula wajala ngayumilikajangka walyjamarringka!, yankuraya Kaliliyakarti! Nyakurniya palunyawati.” ");
INSERT INTO mpj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jampapula wanti kujarra yankupayi, karlkiya jantulwintikaja yanu marlaku tawunkarti Jarujalumukarti. Ka-jananyaya jakurljunu Yatilyparakungka majuparakungka. Karlkiya jantulwintikaja nyuri nyinapayi pirnkingka. ");
INSERT INTO mpj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Palunyajanu-jananyaya yatilyparakulu wumurnu yirnakaja. Kaya wangkapungu, yiwilyirringu. Palunyajanuya mani maju manu, ka-jananyaya yungu mani jantulwintikaja. ");
INSERT INTO mpj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ka-janampaya muunpungu jantulwintikajaku, “Jilanyanyurra wajalku, ‘Jampalaju pirnkiwati kunyala ngarripayi, yanurniya Jiijajmili wangka-nintikaja mungangka. Kaya manu katingu ngulyulu pinyipinyi.’ Yuu, jilanyanyurra wajalku. ");
INSERT INTO mpj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jampa kulilku Payilatju ngaa jakurlpa, wirrilyirrijakungkamarralaju marrkulku. Mirtanyurra wirla karratarri Payilatjamarra!, paki.” ");
INSERT INTO mpj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Palunyajanuya manuka mani kangu jantulwintikajalu. Ka-janampaya wangka kangu yatilyparakuku. Kaya nyurilu yimpirni jiinya wangkanga kuwarrilunga Juwukajalu. ");
INSERT INTO mpj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Palunyajanuya yanu ngurra Kaliliyakarti wangka-nintikaja. Yarnngaya liipan wulikaja yanu. Yanuya yapukarti, Jiijajju-janampa wajanyjangka. ");
INSERT INTO mpj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jampaya nyangu Jiijajpa, warlkurnuya. Karlkiya ngunjularripayi, “Kaji Jiijajpa ngaanya yikini, mayitpi kujupa.” ");
INSERT INTO mpj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Palunyajanu-jananya Jiijajpa yanurni. Ka-janampa wajarnu, “Mamaluju wajarnu, ngayurna nyinara maaja maju, yuu. Yilta, nyinanirna-janampa maaja yarnngaku martuku. Nyinanirna-janampa maaja yarnngaku parnangkaku, ngarnawarrakulurrju. ");
INSERT INTO mpj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yuu, nyinanirna-nyurrampa maaja, karna-nyurranya yiyarnin. Yankuranyurra yinta kujarra yintakarti. Ka-jananyanyurra wangka ngayumili nintipungku martukajangka yarnngangka. Yiipiya kulilkuka ngayumili walyjarriku, kayila-jananyanyurra jarrpajunamalpa kalyungka. Jampa-jananyanyurra jarrpajunku kalyungka, wajalkunyurra jilanya, ‘Nyuntumili maaja maju nyinani, yini jilanya Mama ngarnawarrapurluka, palunga yini kujupa Mamamili kaja, palunga yini kujupa, Mamamili Kuurti.’ ");
INSERT INTO mpj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yuu, yungurna-nyurranya ngayumili wangka. Kayila-jananyanyurra maa yungkumalpa wangka ngayumili karlkingka martungka. Nintila-jananyaya!, kangkuraya wangka ngayumili. Yuu, yiltarna-nyurranya nyinaku wulungulyu. Parnanga wiyarrinyjangka, nyurirna-nyurranya nyinaku. Yuu, wulungulyurna-nyurranya nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ngaa-lampa wangka palya Jiijajpa Kurayijkurnu. Jiijajpa palunya kajapartarnu Mamakura, ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mamakurnu wangka jakurlpurlukalu Yayijayalu wakara junkupayi, jilanyangulyu, “Mamalu ngarnawarrapurlukalu wajarnu, ‘Kurranyirnangku yiyalku ngayumili wangkapurluka yiwarralkatikungku marlakartilulun wanalku. Kurranyilun-jananya nintijulkatimalpa puntukajangka’ ");
INSERT INTO mpj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pujimanpa pararrawana yukuriparniwana jilanyayuru-nyurranya nintijulku. ‘Maajakuranyurra palya nyinaranku wanalkuralunyurra jungalu. Yiwarrangkaluya wanalkura palyalu. Maajangampa-nyurrampa ngula warinykatiku nintijulkuraku-nyurranya.’” ");
INSERT INTO mpj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Maakjurna-nyurrampa ngaanya wangka wajarninpa. Wangka palunya Yayijayakurnuyuru Jaanpa-nyurrampa kurranyu yanurni, nintijulkuranpa-nyurranya, kalyungka-nyurranya jarrpajunkuran. Jaanju-jananya pujimanwanalu-jananya parra nintijulkatipayi, wunalu yankunyjanju, jilanya, “Wiyanyurra nyinama puta!, Mamakuraya palya nyinama!. Palunyajanungkayilaparna-nyurranya kalyungka jarrpajunamalpa. Jampanyurra kalyungka pakanyjangka Mamalu-nyurranya puta manku wirrupungku, ngulyjulkuyila-nyurranya kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ngurrangka Juutiyangka yankuraya wururripayi Jaankutu, kulilkurakuluya wangkaku, Jarujalumujanulurrjurniya pakalpayi. Kujungkarringuluya wangkapayiluya Jaanja kurilypungkula-jananya Mamalu, putalurrju-janampalura mankura wirrupungkura. Kujunnguru kujunnguruluraya yankupayiluya Jaankarti japilpayi, “Mama-lampajura japila!, puta-lampajukura mankura wirrupungkura, Mamakulajura junga nyinara.” Wangka palya nyinakijangka Jaanjunga-jananya kuliraka kalyungka jarrpajunkupayi, karru Juutanja. ");
INSERT INTO mpj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaanpa kulujpa kujupawinti nyinapayi, kamalmili pankukajawinti. Nanpa kanyilpayi kamalmili likarrajanu. Palunyalu purntarlkakaja ngalkupayi ka jurtipirrikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jaanju-jananya puntu nintijulpayi jilanya, “Warrkamupurlukarnara nyininpa, ngulampa-lampa pakalkurni maaja maju. Kurayijpa-lampa jii yankurni, maaja majuminyirri, karnara ngayu palumili warrkamupurluka.” ");
INSERT INTO mpj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jaanju-jananya wituka wajarnu, “Ngayulurna-nyurranya kalyungkawiyaju jarrpajunkupayi. Kayilaparni kujupa maaja maju yanku, Kurayijpa. Jiilu-nyurranya Mamamili Kuurti kurrujunmalpa, murlpirrpanyurra nyinaraku, junga.” ");
INSERT INTO mpj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tawunpa Najarajangka Jiijajpa nyinangu warrinyjirringu jukujanu, parnangka Kaliliyangka. Karrungka-jananya Jaanju jarrpajulpayi martukaja. Jiijajpalu yanu warinykatingu. Kayilara wangkangu Jaanku, “Ngayulurrjurni kalyungka jarrpajula!” Palunyangkayila maa winirnuka jarrpajunu, karrungka Juutanja. ");
INSERT INTO mpj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Palunyajanuyila Jiijajpa kalyujanu pakarnu yanu marlaku yikingu. Palujanu ngarnka wupunarringu. Jaanju nyangu Mamamili Kuurti turruyuru yankupayi, kayila Jiijajjalu nyinatingu. ");
INSERT INTO mpj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Palunyajanu Mama wangkangu ngarnawarrajanu. Jilanya wajarnu, “Ngaanyajun ngayuku kaja, layikamurnangku nyininpa, pukurlparnangku.” ");
INSERT INTO mpj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Palunyajanu Mamakurnulu Kurrurnju kurtingu pujimankarti. ");
INSERT INTO mpj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pujimanpa wiikiparaku nyinapayi, wirlarra kujungka. Jiingkangulyuyilapalu warinykatingu, malpuku maaja. Jiingkangulyuyilapalu muunpungu, “Mirtalun kulila nyuntukurnu Mamangka!, ngayungkarni kulila!, ngayulurnanta yungkujaku, nganampayilurrju.” Mamakurnu wikarrukajaluya ngarnawarrajanungaya kintilungulyuya kanyilpayi Jiijajpanga, jantukajangkamarra pikalyakajangkamarra, jiimartajiluya pajaljakungkamarraya. Malpulu purtu muunpungu, ka Jiijajpanga marlaku yanu, palumili walyjakarti. ");
INSERT INTO mpj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Palunyajanungayilaparaya yirrpirnkurlu pakarnu Jaanku. Winirnuya katingu lakamapurnu junu jiilja. Ngulamparrinyjanga Jiijajpa yanu parna Kaliliyakarti. Jiijajjunga-jananya wamparulu kujupa-jananya wangka nintijulpayi, Mamakurnu wangka, yintapartu yinta. ");
INSERT INTO mpj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wajanma-jananya jilanya!, “Kulilaya! Tayimu kintirringu, Mamalu-nyurranya kuwarri ngampurrju kanyilku, palumilingulyukaja. Nyukurni-nyurranya jamartajunkupayi wangkalu. Palunyangkaya nyinaraya kunyjunyu. Karniya ngayumilingka wangkangka kulilku kunyjunyungka.” ");
INSERT INTO mpj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jiijajpa yanu yirritiwana kalyungka Kaliliyangka. Nyangu-pulanya yirna kujarra, kalyungkapula wirrupungkupayi niitingpa kukaku, piijku. Palu kujarrangapula kurtararra yini Jayimunkamu Yanturu. Palu kujarrapula warrkamupurluka kalyungkapula piijpa mankupayi, puntu laltuku. ");
INSERT INTO mpj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jiijajpa-pulanya yanurni kujungkarringu. Wajarnu-pulanya jingulpa, “Jurrapula warrkamu!, karnipula yankura wulikaja! Julyjunyurra warrkamurrira piijkaja mankupayi, ka kuwarrirna-nyurranya nintilku Mamamili warrkamunyurra ngapilkura, wangka-jananyanyurra jakurljulkura ka nintijulkura Mamamili walyjarrikurakuya.” ");
INSERT INTO mpj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Palunyalu kujarralupula junu yanu niitingpa, wulikajarringuya yanu Jiijajmapu, kalyungka yirritiwana. ");
INSERT INTO mpj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yanuya nyangu yupalpa nyinapayi puutka. Mamararranjuya niitingpa kunyjunyunkula nyinapayi puutkalu, warrkamupurlukalulurrju, laltuluya. Palunyangaya yini Jayimijpa, Jaanpa, jirlpi Jipiti mama-pulampa. ");
INSERT INTO mpj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jiingkaya Jiijajmapu yikipayi, ka Jiijajpa-pulampa mirrangu, “Yarrarnipula!” Palunyalupula warrkamupurlukakaja junu yanu, mamalurrju. Yanulupula Jiijajkarti kulirnu. Palujanu kujungkarriraya yanu. ");
INSERT INTO mpj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yanuya tawunkarti Kapaniyamukarti, Jiijajmapuya yanu jarrpangu jaajka, Juwumilingka, Jarritingka. Palujanu Jiijajkuraya japirnu nintilkuraku, Mamakurnu wangka. Palunyalu-jananya pakarnu nintijunkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jiijajpa-jananya puntukajangka laltungka raka wangkangu. Wangka kuwarrijanu-jananya nintilpayi. Palunyangkaya kulirnu yakarringu. Karlkiya nyinapayi jiingka Muujajmili wangkapurlukakaja. Palunyakajaluya wulu nintijunkupayi jaajja, rakaparnilu. Jarritingka-jananya kujulu nintijunkupayi rakalu, Jiijajju. ");
INSERT INTO mpj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jiijajju-jananya nintijunkupayi, palunyangka yirna kuju jarrpangurni jaajka malpukurlu. Wiltulu Jiijajkalu wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nyuntunga Jiijajpa Najarajapurluka kulila! Nganaku-lampajukun yankupayi? Kaji-lampajukun ngayurtinku malpukajaku yanurni pungku-lanyajun kurtingkura? Ngayurnangku ninti. Nyuntungaran Mamakurnu ngarnawarrapurlukakurnu.” ");
INSERT INTO mpj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jiijajju payirnu malpu jilanya, “Yakarriwa! Jiinya puntu kuju jurra yarra!” ");
INSERT INTO mpj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Malpulu yurntura wirrupungu, kalu ngamu mirrangu malpu, ka pinirringu. ");
INSERT INTO mpj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Puntuluya nyangu kaluraya yakarringu. Kayila-ngkuya japilpayi, “Ngaalu-lanya wangka kuwarrijanu nintirnin? Ngaanga wangkinpa maparnwinti. Kulirnuya jiilunga-jananya maparnju majulu-jananya ngumparnu wiyarnu. Malpukajaya kulira ngurlu jawarnu yanu, maparnkamarra, ngurlu, wulu.” ");
INSERT INTO mpj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jiijajju-jananya martukaja maparnmankula kunyjunyunkupayi, ka malpu-jananya ngumpara maa wiyalpayi. Puntuluya nyakupayiya maparnpa maju. Kaya yankula ngurra kujupa kujupangka wajalpayi, parna Kaliliyawana. Jiijajju-jananya wankarnu ");
INSERT INTO mpj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaajjanuya pakarnu yanu Jiijajmapu ngurrakarti, Jayimunku Yanturuku mayakarti. Jarrpanguya lalturtuka mayangka, Jayimijpa, Jaanpalurrju. ");
INSERT INTO mpj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yumarira Jayimunkurnu ngarnta ngarripayi, parltiparlti. Wajarnuraya Jiijajku, “Jiinya kunyjunyula maparnkurlulu!, miturrijaku.” ");
INSERT INTO mpj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jiijajju yanu mara ngalurnu nyinajunu, kayila kunyjunyurringu. Ka pakarnuka mayi-jananya manu yungu. ");
INSERT INTO mpj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jiimartajiluya kulirnu Jiijajpa. Kaya mungarrmungarr winirnu katingurni ngarntakurlukamu malpukurlulurrju, Jiijajju-jananya wankalkura. ");
INSERT INTO mpj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Palunyajanulurrjuya yanurniya mayakarti kujungkarringu, Jiijajpaya maparnkurlu wankaranyja nyakukijalu. ");
INSERT INTO mpj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yiltalu-jananya ngarntakurlu maparnmankula wankarnu. Ka malpu-jananya ngurlura wiyalpayi ka-jananya wankalpayi, Jiijajju. Jiijajju-jananya marrkulpayi malpu, “Yakarriya ka maa yarra!, jiiwananyurra mirta wangka!” Jiijajju kulirnu, “Ngulamparna-jananya wajalku ngayurna Mamamili, mirtarna-jananya kuwarri wajalku.” Jilanya kulirnuka marrkulpayi-jananya malpukaja, mirtaya wangkaraku Jiijajpa Mamamili. ");
INSERT INTO mpj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jiijajmalukajaya ngarripayi mungajarra. Yungunyungunpa Jiijajpa pakarnu yanu martuparningka. Kayilalu wangkangu Mamangka, ngarnawarrapurlukangka. ");
INSERT INTO mpj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kaya Jayimunmaluluya kanarringu pakarnu. Kaluya jina wanarnu. ");
INSERT INTO mpj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wanarnuluya kujungkarringu, kaluya wajarnu, “Martulu-ngkuya ngurrini!”, ");
INSERT INTO mpj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jiijajju-janampa wajarnu, “Paki, yaninpala kujupakarti, tawunpa laltukarti. Yankularna-jananya Mamamili wangka wajalkijalu, tawun kujupa kujupangka. Witurnurni wiyarnu Ngarnawarrapurlukalu, Mamalu, palumili wangkarna-jananya parra wajalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Palujanu Jiijajju-jananya yiltangulyu-jananya parra wajalpayi ngurra kujupa kujupangka, Mamakurnu wangka, jiiwana parna Kaliliyawana. Juwuku jaajka jarrpara-janampa wajalma. Ngurra kujupa kujupawanalurrju ngumpara malpu-janampalura wiyalma. ");
INSERT INTO mpj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yirna kujulu yanu ngarnta lipurijikurlulu pupatingu murti jurrpujurrpu, kara japirnu Jiijajpa, “Maaja! Nyuntungan maparnpa maju, kajirnin kunyjunyunku?” ");
INSERT INTO mpj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Jiijajpara nyarrurringukara wajarnu, “Yuu! Kunyjunyurri!” Palunyangkayila kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jiijajjura marrkurnu, “Mirtan-jananya martukajangka yanku wajalku, yankulun yatilykarti, jaaji majukarti. Yatilyjalun nintijulku karan wajalku kunyjunyurringun. Karan mirtayirti manku yungku yatilyku, kayila martukajaluntaya nyakuka kulilku, ‘Ngaa martu kunyjunyurringu.’ Jilanya-lampa wajarnu Muujajju.” ");
INSERT INTO mpj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yirna palunya pukurlarrira yanu-jananya wajalkatipayi, ngurra kujupa ngurra kujupawana. Jilanya-jananya wajalpayi, “Ngayurna kunyjunyurringu. Nyawarniya!, Jiijajjurni wankarnu.” Palunya mirta yaka yankupayi. Martukajaluya ngaranguya kulirnu, “Jiijajju palunya kunyjunyurnu.” Palujanuya yankula wajalpayi, tawunkajawana laltuwana. Kayila Jiijajjunga-jananya nintijulkijalu tawunwana, palulu-jananya tiwajanu nyangu martukaja laltukuyarra, wururripayiraya paluku Jiijajku. Nyangu-jananya junuka-janampalura tawunu yitiwanarrikula yanu. Ngurra kujupawana-jananya nintijunkutipayi, tawunparniwana. Purtuya Jiijajmapulu kulilpayi manarrwintiya jaalpu nyinaraku. Palunyangkaya tawunparniwana yitiwana nyinapayi, mirta-jananya Jiijajju tawunja kutuwana nintijunkupayi, paki. ");
INSERT INTO mpj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Karrpu yupalja parra-jananya nintijunu ngurra kujupawana. Palunyajanu Jiijajpa marlaku yanungkura tawun walyjakarti, Kapaniyamukarti. Maya walyjangka nyinama. ");
INSERT INTO mpj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Palujanuluya karlkiluya jakurljunkutipayi martukajangka jilanya, “Jiijajpa maya jiingka kaninyjarra nyininpa.” Palujanuluya yankulaluya wururrima palukurnungka mayangka, jarrpajarrpapayiluya. Palujanuluya martukajalu tuwu ngka juturnu ngarapayi. Jiijajju-jananya kaninyjarralu nintijunkupayi, ngarnawarrapurlukakurnu Mamakurnu wangka. ");
INSERT INTO mpj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka puu wulikajaluya martulu katingurni Jiijajkarti martu ngarnta, parralayijirringu wulu ngarripayi, paangkangka wartawanja. Katinguya mayakutu. ");
INSERT INTO mpj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Purtuya jarrpajunu martuya laltu ngarapayi, yangajunuka. Palunyajanuya yanu yitiwana, kaya tatirnu ngarnawarra tatilpintingka. Katinguya mayangka ngarnawarra. Palujanuluya pungu tapurrpungu. Kaya wiyarnu ruupkurlulu kaninyjarra ngarnta palunya. ");
INSERT INTO mpj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jiijajju kulirnu, “Ngaalungarniya puu wulikajalunga kulini ngayurna maparnwinti. Mirtaya katingu marlaku, martu laltungkamarra, wululurniya katingu ngarrijunu ngayungka.” Jiijajjulu wajarnu ngarntapurlukangka, “Yangupala! Mankurnangkura wirrupungku, walykukaja.” ");
INSERT INTO mpj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Muujajmili wangkapurlukakajaya jii ngarangu, karlkilu kulirnu, ");
INSERT INTO mpj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nganaku jiilu Jiijajju pakiwana wajarnu? Mama ngarnawarrapurlukaluwiyaju walykukaja wirrupunginpa, mirta ngaalu, martulu.” ");
INSERT INTO mpj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jiijajju-jananya ngarala kulilpayi, ka-janampa wajarnu, “Nganakurninyurra jankanin? ");
INSERT INTO mpj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wangka ngaaya kulila! Ngayulurna wajarnu walykukajarnangkura wirrupungu. Palujanu mayitpinyurra kulirni, mayitpirnalura wirrupungu, mayitpi paki. Yiipirna wangka kujupa jilanya wajalku, ‘Pakala kunyjunyurrira yarra!’ Jampa mirta pakalku, palunyangkarninyurra kulilku, mayunyju. Wangka jiirnara wajalku ngayurna mayunyjuparni kulilkuranyurra. ");
INSERT INTO mpj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngayurninyurra kulilkura, Mamamili maparnwintilurna walykukaja wirrupunginpa. Ngayurna martu yarnngakurna-janampa marlpa.” Kara ngarntapurlukaku wajarnu, Jiijajju, ");
INSERT INTO mpj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Pakala! Warntungku marraka yarra ngurrakarti!” ");
INSERT INTO mpj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Palunyangka yiltangulyu wankarringkula pakarnu yanu. Martukajaluya nyangu ka yakarringu. Palunya Mama ngarnawarrapurlukaya marninypungkupayi. Pukurlarriraya wangkapayi jilanya, “Palunyanga maparnpa majukurlu nyinin. Kalaju kuwarriwiyaju jilanya nyangu, martu pakarnu parralayijijanu.” ");
INSERT INTO mpj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Palunyangka Jiijajpa yanu kalyu Kaliliyakarti. Martu kujupaluya marlakarti wanarnuluya kujungkarringu. Palunyalu-jananya Jiijajju nintijunkupayi, martukaja-jananya. ");
INSERT INTO mpj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Palujanu Jiijajpa yanu kalyungka yirritiwana, ka nyangu Lipayi, Yalpiyajkurnu kaja, yupujingka nyinapayi, ka-janampa mani kapamanku mankupayi. Kara Maajurruku wajarnu, “Pakala!, kujungkali yankura!” Warrkamu junu yanu, kalu pakarnu wanarnu. ");
INSERT INTO mpj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yanupula Lipayiku ngurrakarti, Jiijajku wangka-nintikajalurrjuya kujungkarriraya yanu. Mayangkaya kuka mirrkalurrju ngalkula nyinapayi. Kujupakajaya-jananya warinykatingu kujungkarringu nyinangu. Karlkiluya kapamanku mani mankupayi, karlki kujupaya Juwumili luwukuraya parlanypa nyinapayi. Jiikajaluya kujungka Jiijajja ngalkupayi. Jiikajaya mayakarti yanu Jiijajku wangka kulilkura. Jiikajaku-janampaya parlanypaya nyinapayi, jii Muujajmili wangkapurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jiiya karlki Muujajmili wangkapurlukakaja, Parajikaja yankuraya kujungkarriraya nyinama, mayangka. Palukajaraya Jiijajku wirrilyirringu jumaji-jananya Jiijajpa nyinapayi, Mamaku ngurrpakajangka. Jiikajaluya-jananya Jiijajmili wangka-nintikaja japirnu, “Nganaku-jananya Jiijajju kujungkalu ngalkurninpa, putakajangka?” ");
INSERT INTO mpj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jiijajjunga-jananya kulirnu kujupawana wangkangu jilanya Muujajmili wangkapurlukakajaluya kulilkura, “Mirta maparnju martu ngarntaparni pampuni, paki, ngarntakurluwiyaju pampuni. Pakiwananyurra kulirninpa. Ngayurna jiiyuru maparnwinti yankupayi, martu putakaja nintijunkuraku, mirtarna-janampa ngayu yanurni martu kunyjunyukajawiyaju nintijulkuraku, paki. Yuu, yanurnirna Mamaku ngurrpakajarna-jananya nintijunkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ngulampaya karrpu kujupangka Jaanku warrkamupurlukakajaya ngalkuparni nyinapayi, Mamaya marninypungkuraku. Parajikajalurrjuya mirrka ngalkuparni nyinapayi. Martu karlki kujupaluya jilanyaya kulilpayi, kaluya yanu Jiijajkarti, japirnuluya, “Nganakuya nyuntumili wangka-nintikajaluya ngalkurninpa mirrka? Nyinangaraya mirrkaparni kaya marninypungkungara, Mama ngarnawarrapurluka. Karlkilungaya Jaanku warrkamupurlukalu Mama marninypungkuraku mirta ngalkurnin, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jiijajju-jananya wajarnu wangka yumuwanpa jilanya, kulilkurakuya, “Nyupararralupula marrirtikijalu kujungkarrinila mirrka ngalkuraku, ka turlku yinkaraku, pukurlju. Kunyjunyuya-pulampa jilanya pukurlju ngalku, kuwarripa marrirtirrikija yirna palu. ");
INSERT INTO mpj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngulangaya yirna palunyanga ngaluraya katiku, palunyangkaya palumili walyjakaja nyinaku mirrkaparni, Mamaya japilkura.” Jiijajju-janampa jilanya yumulu wajarnu kurranyilu, “Yirna palunya marrirtingayuru, kayilarniya ngalulku katiku. Palunyangkajunyurra mirrkaparni nyinaku Mama ngarnawarrapurlukawiyaju japira nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jiijajju-jananya yarrarnu wajarnu wangka yumuwanpa, kulilkuraya, “Jaartakamu jawuja jampapula wuulpalarriku palunyangapula yaarryanku. Mirtanyurra kujupajanu nyuwanajanu yaarrpungku ka junku jaartangka wuulpalangka niitulkurlulu wakalkuraku, paki. Wulungulyungku jiinga jaarta wuulpala yaarryankumalpa niituljanuwana. Jiingkamarranyurra nyuwanpa mirta manku wuurlpalangka junku miintamulku, junkunyurra.” ");
INSERT INTO mpj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","(Juwukajaluya paatuljarramunungka karrkarta kanyilpayi nyurungka.) Wangka yumuwanpa kujupawana-jananya wajarnu, Jiijajju, “Kuripijjanungka nyupirala karrkarta yintini. Jiipukurnungkala nyurungka karrpira jatamapura, yintira kanyini, mirtala yintira wuulpalangka nyurungka kanyini, paki palunyanga taalpalku. Nyuru nyuwanangkawiyaju yintirala karrkarta kanyini, taalpalparni.” Wangka jiinya-jananya Jiijajju wajarnu, jilanyaya kulilkura, nyuru wuulpalayuru Muujajmili wangka nyinani, ka nyuru nyuwanyuru Jiijajmili wangka nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Palujanu Jiijajkamu palumili wangka-nintikaja yankupayiya wilykiwana, wilyki yini wiiti, mirrka ngalkupinti. Karrpungkaya yankupayi Jarritingka. Jiijajmili wangka-nintikaja yankupayiya kalyparturringu, kaya yinalpayi wilykikaja ngalkungunaraku. ");
INSERT INTO mpj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka karlki martu jiingkaya yikipayi yini Parajikajaya. Nyangu-jananyaya Jiijajmilikajaluya wangka-nintikajalu ngalkupayi mirrka wilykikaja. Ka Parajikajalu wangkanguluya Jiijajja, wajarnuraya, “Nyaakuya ngalkuni kuwarringa Jarriti? Nyawa-jananya nyuntumili wangka-nintikajalu ngalkuni. Nyampanga-lampa luwu nyinani, mirtala warrkamurrini Jarritingka, paki. Nyuntumilikajalu wangka-nintilu warrkamurrini, yinaniya wilykikaja.” ");
INSERT INTO mpj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ka-janampa Jiijajju wajarnu, Parajikajaku, “Mamamili wangka jilanya nyinani, ngangkulngaranyurran. Julyju Tayipitmaluluya mirrkaya ngalkupayi Juwumilingka jaajingka. Jaaji palunga Mamamili. Mirrka jiinga kangkuraya junkupayi jaajingka Mamakura, ngarnawarrapurlukaku, martukajaluya, jaajipurlukalu yatilyjuwiyaju ngalkuraku. Jilanya-janampa luwu nyinapayi, jaajipurlukaluwiyajuya ngalkuraku. Mirrka palunya Tayipitmaluluya kalyparturringu, kaya ngalkupayi, mirtaya jaajipurluka nyinapayi. Jilanyaluya Tayipitmaluluya ngalkupayi, jampa Yapayaja yatily maju nyinapayi.” Palunyayuru-jananya Jiijajju maajalu wajarnu palumili wangka-nintikajaluya palya mirrka jiinya ngalkuraku, Jarritingka. ");
INSERT INTO mpj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wulu-jananya ngarala Jiijajju wajalpayi, “Jarritinga wulungulyu nyininpa, warrkamuparni. Pakinyurra kulirni. Mirta-janampanyurra parra yankula Jarritingka nyakura ka warrkamupurlukakaja payilkijalu, paki. ");
INSERT INTO mpj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngayungarna martuku marlpa nyininpa, martu laltuku maajarna nyininpa. Ka ngayulurna wajani, palyangulyuya Jarritingka mirrka wilykinga maralu yungkara ngalkunmalpa.” ");
INSERT INTO mpj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiijajpa kurrungu jaajingka Juwukurnungka, ka nyangu martu mara walyku, ngarntajanu. ");
INSERT INTO mpj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Karlkiya martu jiingka nyinapayi, Jiijajkuraya parlanypa nyinapayi. Ngangkulpayiya, “Mayiti ngaanya martu mara kunyjunyulku Jarritingka kuwarri. Ngayurtinku-lampa luwu mayiti warlangku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jiijajjulu nyangu mara walykungka kara wajarnu “Yarrarni!” ");
INSERT INTO mpj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ka Jiijajju-jananya japirnu, martu Muujajmili wangkapurlukakajakamu kujupakaja, “Muujajkurnu luwuwanala nyininpa. Kaji wanyjalpanyurra kulini? Luwu paluwanala martu kujupa wankalku Jarritingka? Mayitila martu palu junkuka yanku wankalparnilu. Kaji wanyjalpanyurra kulirni?” Palunyaya kulirnu kaluraya yaka wangkaparni ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jiijaj-janampa wirrilyirringu palungaya wulu kulilparni ngarapayi. Palujanu Jiijajpa-janampa nyarrurringu Mamakurnu wangkaku ngurrpaya nyinapayi. Ka Jiijajjura martuku jiiku wajarnu, “Marangku turitpalala!” Mara turitpalarringu kayilapa kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Palujanu Parajikajaraya wirrilyirringu, jumaji Jiijajju Jarritingka martu mara wankarnu. Yumuyuruya yaka yanu Parajikaja, ka-jananyaya kujungkarringu Jaajimili maajakajangka. Wajarnu-ngkuya yakalu, “Jii Jiijajpala mitu pungku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jiijajmaluya palukurnu wangka-nintikajaya yanu, kalyu Kaliliyakarti. Marlakarti-jananyaya martu laltulu wanalpayi, parna Kaliliyamartajilukamu parna Juutiyamartajilu, tawun kujupa kujupajanulurrju. ");
INSERT INTO mpj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jilanyajanuya yankupayi Jarujalumujanu, Taayajanu, Jayitanjanu, ngurra kujupakajajanulurrju, Yitumiyajanukamu, karru Juutanwanajanulurrju. Jiijajju-jananya jiijanu wankara palyamankupayi. Palujanuluya jakurlpa katingu wajarnu laltukuyarrangka, kayilaparniya yanurni. ");
INSERT INTO mpj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jiijajju-jananya nyangu martu laltukuyarra, palunyakurnu wangka-nintikajangka-jananya wajarnu, “Jiinya-lampa yarra puutpa marra! Katirni yikijula ngamu!, yurntuljaku-lanyangkuya kalyukarti.” Palunyangka kuju Jiijajpa tatirnu puutka nintijunkuwa-jananya wangka Mamakurnu. ");
INSERT INTO mpj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Martu laltulu-ngkuya yurntulpayi Jiijajkarti yankurakuya, ngarntakurlulurrjuluya yurntulpayi Jiijajpaya japilkuraku jilanya, “Pampulkurarni!, kunyjunyunkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Malpukurlulurrjurniya yanurni wartungaratingu Jiijajja. Kaluya wajalpayi wiltulu, “Yiltangulyun Mamakun ngarnawarrapurlukakurnun kaja ngarin!” ");
INSERT INTO mpj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jiijajju-jananya marrkulpayi malpukurluwinti, “Yakarriwaya!” Jilanya-jananya Jiijajju marrkurnu, yarraraya wajaljaku, Jiijajpanga Mamakurnu. Jiijajjunga kulirnu ngula-jananya wangka jiinya nintilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kalyu Kaliliyajanuya yanu yapukarti, Jiijajju-jananya kumu katingu wangka-nintikaja. Katingu-jananya yapu jayitingka junu. Kayila Jiijajpa tatirnu ka jaalpu-janampalura ngamungulyu nyinangu. ");
INSERT INTO mpj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka-jananya kujunkujunja wajanu yankuraya nyinakura kujungka Jiijajwati. Palunyakungaraya tuwal wulikaja wangka-nintikaja. Jilanya-jananya wajanu, “Ngayumili marlpakajanyurra nyinaku, ngayumili jakurlpurkakaja. Ngularna-nyurranya kurtingku ngayumili wangkanyurra parra jakurljunkura.” ");
INSERT INTO mpj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ka yarrarnu-jananya wajanu, “Ngayulurna-nyurranya murlpirrmanku malpukaja-jananyanyurra wajara kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","18","Tuwalpa martuya yinikurluya nyinapayi jilanya, Jayimunpa, Jayimijpa Jaanpa, Yanturu, Pilapu, Pajalamu Maajurru, Tamajpa, Jayimijpa kujupa Yalpiyajkurnu kaja, Jatiyajpa, Jayimunpa kujupa, Kayinanmartaji, Juutajpa Yijikariyatmartaji. Jayimunpa palunga Jiijajju yinijunu yini kujupa, Piija. Jayimijkamu Jaannga palunyangapula kurtararra nyinapayi, Jipitikurnu kaja kujarra. Jiijajju-pulanya julyju yinijunu, “Jurtapayi kujarra”. Jayimun, jii julyju Ruumanpurlukaku parlanypa-janampa nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Juutajju-jananya ngula wajanu maajakajangka, yankuraya Jiijajpa ngalulkura ka katikura. ");
INSERT INTO mpj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Palujanuya Jiijajmapu yanu marlaku palumili ngurra walyjakarti. Ka jiimartajiluya kulinu Jiijajpa nyinapayi, kaluya laltu kujungkarringu Jiijajka, warnmarlakuyarra, kulilkuraya wangka. Nintijulpayi-jananya Jiijajju wululu. Kaya purtu kulilpayi yankuraya ngurra kujupangka ngalkukijalu, Jiijajmapuluya. ");
INSERT INTO mpj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Palunyajanuluya karlkikajalu nyakulaya wajarnu, wangka pakiwana jilanya “Jiijajpanga kuranpa kawarnkawarnarringu.” Jiijajkura yipilu marlangupirtilurrjuluya kulirnu jakurlpa. Karaya pakarnu yanu, Jiijajpaya winira katikurarni. ");
INSERT INTO mpj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka Jiijajju-jananya nintijulpayi, kaya karlki kujupalu ngaralaya wajarnu, Jarujalumumartajilu, Muujajmili wangkapurlukakajaluya. Pakiwanaya wajarnu, “Jiinga Jiijajpanga malpuwinti, puta nyininpa. Palunyalunga malpumili maajawintilu maparnwintilu malpukaja payira kurtingkuni.” ");
INSERT INTO mpj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jiijajpa-janampa mirrangu, “Yarrarniya wangkaku!” Wangkangu-janampa wangka yumuwanpa jilanya, kulilkurakuya, “Kulilaya! Malpumili maaja nyininpa-janampa warrkamupurluka yarnngaku, malpu yarnngaku. Mirta malpumili maajalu payira kurtingkuni, palumili warrkamupurluka malpu, paki, jumaji walyjalura. Malpu kujupakaja-jananya mirta payira kurtingkuni, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jiijajju-jananya yarrarnu wajarnu, “Wangka kujupaya kulila! Yiipi martu walyjalu-ngkuya jurtalu mitu pungkumalpa, palunyajanuya mirta martukaja nyinaku, paki, miturrikuya. Jampa jurtaparniya nyinaku, wuluya wanka nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jiiyuru Jiijajju-jananya yarrarnu wajarnu, “Yiipi martu kurtararranju-ngkuya jurtalu mitu pungkumalpa, palunyajanuya mirta kurtararranpa nyinaku, paki, miturrikuya. Jampa jurtaparniya nyinaku, wuluya wanka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wangka jii kujarrayuru jilanya. Yiipi malpu laltulu-ngkuya jurtalu mitu pungkumalpa, palunyajanuya mirta wanka nyinaku, paki, miturrikuya. Yiipi malpumili maajalu-jananya palumili warrkamupurlukakaja, kurtingku kayilapaya mirta palumili walyjakaja nyinaku, paki. Nganakujunyurra pakiwana wangkangu, ngayulurna malpu payira kurtingkuni, malpumili maparnwintilu. Yaalula malpumili maparnwintilu payira wiyarnin, malpu walyja? Ngayurna mirta malpukurnu maparnwinti nyinin, paki, Mama ngarnawarrapurlukamili maparnwintirna nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Wangka kujupa-jananya Jiijajju wajarnu, “Yirna murlpirrpa nyinaku, jantulkurlu. Mirtarni kujupa yankurni ngulyuku, wartakaja mankuraku, jumaji murlpirrju pungkujaku. Yiipi yirna kujupalu maparnwintilu yanku yirna palunga kurranyilu karrpilku ruupwintilu, palujanu manku ngulyulu murlpirrmili wartakaja.” Yirna paluyuru murlpirryuru, malpumili maaja murlpirrpa nyinani. Ka Jiijajpa palu martuyuru maparnwintiyuru maparn maju nyinani. Ka palulu malpukaja payira kurtingkuni Mamamili maparnwintilu, palumili Kuurtiwintilu. ");
INSERT INTO mpj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Wangka kujupa-jananya wajarnu, “Martulu walykukaja ngapilku, ka yiipira Mama japilku walykukaja warningkuraku, palujanura Mamalu warningku. ");
INSERT INTO mpj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ka yiipi martulu Mamamili Kuurti nyurnimanku, jilanyalunga walyku ngapini, ka japilku Mama walyku jiira warningkura, palujanura Mamalu mirta warningku, paki, jumaji palulu Mamamili Kuurti nyurnimanu. Martu jiilura purtu japinmalpa walyku jiikajara warningkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jiijajju-jananya wangka jii nintilpayi jilanyaya kulilkura, “Jiijajpanga mirta malpukurlu maparnwinti nyinin. Jiinga nyininpa Mamakurnu Kuurtiwinti, palumili maparnwinti.” ");
INSERT INTO mpj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mayangka kaninyjarra Jiijajju-jananya nintilpayi. Palunyangkaya Jiijajmili yakurtikamu marlangukaja yanurniya ngarangu yawujayiti. Kayilaya kuju wajarnu kurtingu, “Yarrara nyawa!, mayangka kaninyjarra, kan wajalku Jiijajku, yankurakurni!” ");
INSERT INTO mpj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yirna palunya yanu ka-jananya wajarnu, palujanu Jiikajaluraya Jiijajku wajarnu, “Nyuntumili yakurtikamu marlajukaja-ngkuya majani yawujayiti, wangkani-ngkuya yanku-jananyan ngangkulkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wangka palu kulinu ka Jiijajju-jananya wajarnu, “Ngayumili walyjakajaya yawujayiti yikini, ka ngayurna-janampa walyja. Karnara kujupakulurrju walyja nyinani, Mama ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Palujanu yiipinyurra Mamamili walyjakaja nyinani, ngayukujuyan walyjakaja nyinani. Karlkinpanyurra yakurtiyurujunyurra nyinani. Kajunyurra karlki kujupa mamayuru nyininpa. Ka karlki kujupajunyurra marlangukajayuru nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yiipi martukajalunyurra Mamamili wangka kulilku, ka junga nyinaku, ngayumili walyjakajajunyurra nyinaku, karlkijunyurra marlangukaja nyinaku, ka karlki kujupajunyurra yakurtikaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Palujanuya Jiijajmalu yanu kalyu Kaliliyakarti, yirrirringkaya nyinapayi. Yarnngaya martu kujungkarringu ruumuparniya nyinapayi. Jiijajpa takarnu puutja nyinapayi. Nintilpayi-jananya puutjalu. ");
INSERT INTO mpj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wangka yumuwanpa-jananya wajalpayi. Jilanya-jananya wangka kujupa yumuwanpa nintijulpayi, ");
INSERT INTO mpj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngangkulaya! Kaatanmayapurluka kaatanmayakarti yanku wilyki warningku, pakalkuraku mirrka. ");
INSERT INTO mpj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wilyki karlki yiwarrangka punkalku ka marlalu pilurnju yanku ka ngalku-jananya wiyalku. ");
INSERT INTO mpj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Karlki wilyki punkalku yapulyukurrungka, parna julijulingka. Marla pakara tikirlarriku, parnaparningka, yapulyukurrungka. ");
INSERT INTO mpj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jirntulu wakara tikirlmanku. ");
INSERT INTO mpj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Karlki wilyki punkalku jilkarnkurrungka. Purtu pakara ngaraku, julijuliwiyaju. Jilkarnju putamanku mirta pakalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Karlki wilyki pakalku parna kunyjunyungka, mirrkawintirriku. Karlkiya pakalku mirrka majuwinti, karlkiya pakalku mirrka juliwinti, karlkiya pakalku mirrka yupalwinti.” ");
INSERT INTO mpj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jiijajju-jananya wajarnu, “Wangka palukajanyurra kuliraka junga nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Puntu laltuya pakara yanu ngurrakutu. Palujanuluya marlakarti japirnu karlkilu, wangka-nintikajalurrjuluya. “Jiijajpa! Nintimala-lanyaju kaatanmayapurlukaku!, wangka paluku.” ");
INSERT INTO mpj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jiijajpa-jananya wangkangu, “Mamalu ngarnawarrapurlukalu kulirninpa nintinyurra palumili walyjakaja nyinakura, kaatanmayapurlukaku wangka paluku, kayilanyurra wangka kujupakajakulurrjunyurra ninti nyinakura. Karlkingaya ngurrpa nyinaku wangka palukajaku, purtuya kulilku. Wangka yumuwanpawiyajuya kulilku junku. ");
INSERT INTO mpj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Jii karlkiluya wangka yumuwanpa kulilku junku, mirtaya ninti nyinaku. Ngayulurna-jananya wajalku wangka yumuwanpa, kaya kulilku junku. Yiipiraya Mamamili wangka kulilku, palulu-janampa walykukaja warningku.’” ");
INSERT INTO mpj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jiijajju-jananya japirnu palumili wangka-nintikaja, “Purturanyurra ngangkuni?, wangka kaatanmayapurlukaku. Wangka jiinya julijulinyurra ngangkulngara. Ngularna-nyurrampa wajalku wangka wiltu, purturanyurra kulilku. ");
INSERT INTO mpj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ngangkulaya! Kaatanmayapurlukaku wangkaku jungalunyurra kulilkura. Kuwarrirna-nyurrampa wajalku. Wilyki palunyanga Mamamili wangka. Kaatanmayapurlukalu wilyki palunya warningku, nganayurulu?, Mamamili nintipurlukayuru. Palulu-jananya martukaja parra nintilku Mamamili wangka, palunga wilykiyuru. ");
INSERT INTO mpj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wilyki karlkinpa yiwarrangka punkanu, ka pilurnju yanu ngalangu wiyanu. Jampa Mamamili nintipurlukalu Mamamili wangka nintijulku palujanuyila martulu kulilku junku, jumaji malpumili maajalu muunpungku wangka jiikura ngakumparrikura. Malpu palunyanga pilurnyuru, jii pilurnju yanu ka ngalangu wilykikaja wiyanu, palunyayuru malpulu martu ngakumpani, kuliljaku Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wilyki karlkinpa yapulyukurrungka punkanu. Wangka jiiyuruya wilykiwanyuru martu karlkilu Mamamili wangkaya kulilku, karaya pukurlarriku. ");
INSERT INTO mpj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ngulampa martulu-jananya yanku muunpungku Mamaya junkuraku. Palunyakajaluya Mama junku ka pakirriku, wilykiyuru yapulyukurrungka punkara ka, tikirlarringu pakirringu, palunyayuru. ");
INSERT INTO mpj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Karlki wilyki punkanu jilkarnkurrungka, jilkarnju putamanu. Wangka jiiyuru jilkarnju putamanu, martu karlkiluya Mamamili wangkaraya kulilku. Kaya junga rawa nyinaku. Palunyajanuya wamakamu maniwiyaju kulinmalpa, palujanuyilaya Mama junku yanku. Ka wamalukamu manilu-jananya putamanku, jilkarnyurulu, jiilunga wilykikaja putamanu, pakaljakuya. ");
INSERT INTO mpj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Karlki wilyki punkanu parna kunyjunyuwana, ka mirrkakajawinti pakanu. Karlkinpaya mirrka majuwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya wululu Mamamili warrkamu parra ngapinmalpa. Karlkinpaya mirrka juliwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya rawaparnilu Mamamili warrkamu parra ngapinmalpa, kaya warrkamu junku yanku. Karlkinpaya mirrka yupalwinti nyinangu. Wangka jiiyuru martuluya karlkilu kulilku Mamamili wangka, kayilaya junga nyinaku wulungulyu, kayilaya yupal tayimulu Mamamili warrkamu parra ngapilku, kaya warrkamu junku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yarrarnu Jiijajju-jananya wajarnu palumili wangka-nintikajangka, ka martu laltungka. “Laampunga warukurlu ngarnawarra nyinaku. Mirta martulu kanyirnin kaninyjarra paangkangka, turampungka, pulawamilingka, paki. Jiinga laampu nyinin ngarnawarra, rantalkuraku.” Wangka palunya-jananya yumuwanpa Jiijajju wajarnu, kulilkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wangka yumuwanpa kujupa yarrarnu wajarnu, “Wartakaja ngulampawiyaju yutirriku, kukujanu.” ");
INSERT INTO mpj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jiijajju-jananya yarrarnu wajarnu, “Wangka palukajanyurra kuliraka junga nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jiijajju-jananya yarrarnu wajanu, “Jiingara Mamakurnu wangka kulilaya wanyulu! Wangka jiinyanyurra pukurlarrira kulilku, palujanu Mamalu-nyurranya wangka kujupa nintilku, kulilkunyurra. ");
INSERT INTO mpj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yiltangulyu Mamakurnu wangka kunyjunyunyurra kulini, palumili wangka kujupa-nyurranya nintilku Mamalu palunyalu. Martu kujupalu kulilparnilu wanyulu palunya wangkaku ngakumparriku nyinaku. Jiinga Mamalu ngakumpalku wulu.” ");
INSERT INTO mpj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wajarnu-jananya Jiijajju, “Mamalu-jananya ngampurrju kanyilku wulu, palumili walyjakaja. Jiingaya yupalyuruya nyininpa. Kaji yaalu palunyamili walyjakaja lalturriku? Wangka yumuwanpa ngaayuru. Katira wilyki yintilkatiku parnangka, martu kujulu. ");
INSERT INTO mpj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Palunyajanulu marlaku yankula ngarrimalpa. Karrpu yupalka nyinaku. Kayila yanku nyaku wajalku, ‘Parrka jukujuku, pakarnu yikini.’ Kujulu martulu nyaku kayila purtu kulilku, ‘Yaalu pakarnu jiinya warta? Jiinga yiltangulyu pakarnu walyja, ngayungarnara ngurrpa jiiku.’ ");
INSERT INTO mpj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jiingaya pakalku warta japukaja, kuwarripa. Ngulampa mirrkakurlurriku, jampa warta jumarriku. ");
INSERT INTO mpj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Palunyaluyila martu kujulu nayipukurlulu yirrkiliyurukurlulu mirrkanga katupungkula manku, mirrka jiinya. Wangka jiiyuruya martulu purtu kulini yaaluya ngayumili walyjakaja lalturriniya. Mamaluwiyaju kulini ka ngayumili walyjakaja laltumaninpa.” ");
INSERT INTO mpj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiijajju-jananya wajarnu, “Mamalu-jananya ngampurrju kanyilku wulu palunyamili walyjakaja. Jiingaya yupalyuruya nyininpa. Kaji yaalu palunyaku walyjakaja lalturriku?, wangka yumuwanpa ngaayuru. ");
INSERT INTO mpj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Martu kujulu wilyki japuwartaminyirri manku kangku parnangka jawalku tuunyjulku. ");
INSERT INTO mpj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka warta pakalku japuwartajanu majuwarta, majuminyirri. Wartangka palungka majuwartangka pilurnkajaya yankura nyinamal, kunyjunyungkajaru.” Jii pilurnkajayurula Mamamili walyjakaja ngurra kunyjunyungka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiijajju-jananya martu laltungka wangka yumuwanpa, wajalpayi, Mamamili wangka nintilkijalu. Wangka jukujuku-jananya nintilpayi wangka majukungaraya Mamamiliku, purturaya kuliljaku. ");
INSERT INTO mpj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Martukajaluya laltulu wulungulyu kujungkarriraya kulilpayi. Wangka yumuwanwiyaju wulurtuka-jananya wajalpayi. Ngaralaya kulira marlaku yankupayi ngurrakarti. Martukajaya karlki ngarapayi wulu kulilkuraya wangka maju. Jiijajju-jananya marlakarti wajalpayi wangka-jananya majuwarta karlkingka martukajangka, wangka-nintikajangkalurrju. Yiltangulyu Jiijajju yutimankupayi wangka yumuwanjanu, Mamaku wangka maju, kukujarrijanu. ");
INSERT INTO mpj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jirntu rukangka-jananya Jiijajju puutja tatirnu wajarnu, wangka-nintikajangka. “Yankuwala kalyuwana puutja, parna kujupakarti.” ");
INSERT INTO mpj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jiijajpanga puutja wulu nyinapayi, katinguya kalyungka kutuwana, palumili nintikajalu. Puut kujupakajangaya ngarapayi, parnangka ngamu. Puutkurluya Jiijajmapu yankupayi kalyungka kutuwana. ");
INSERT INTO mpj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Palunyangka-jananya wangaljukamu kalyulu pakarnu pungkupayi, puutpa jarrpajunkungara. ");
INSERT INTO mpj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Katawatingku piila junu Jiijajju ka kunyala ngarripayi, puutja marlakarti. Ngurlurringuya yanu Jiijajpa kanarnu, karaya wajarnu, “Nintipuka! Pakala miturrijakula!, mirtan kunyala ngarrima!” ");
INSERT INTO mpj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Palujanu Jiijajpa pakarnu ka marrkurnu, “Yakarripula, wangalpakamu kalyu!” Kayila yiltangulyu pakirringu, kalyukamu wangalpa. ");
INSERT INTO mpj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wajarnu-jananya, “Nganakunyurra ngurlurrinpa? Ngangkularniya!, ngayu Mamamili kaja, maparn yuwinwinti.” ");
INSERT INTO mpj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Palunyaku wangka-nintikajaya yakarringu, jumajiya kalyu nyangu pakirringu. Ka-ngkuya wajarnu, “Ngana ngaa martu? Wangaljukamu kalyulu kulirninpa. Ngaanya maparn majuminyirri.” ");
INSERT INTO mpj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiijajmapuya kalyuwana yanu nyarrakartirringu parna Kirijinakutu. Ngurra palunyanga kalyu Kaliliyangka kakarrakarti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Puutja Jiijajpanga kurranyu tiputingu ngarangu. Jiimartaji martu kuju Kirijinamartaji, kawarnkawarn nyinapayi. Martukajangka mitungka-jananya nyinapayi, katu. Palunga martu kujunga purtuya karrpira nyinajunkupayi, julyju. ");
INSERT INTO mpj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Laltungkaya mirna kujarra, jina kujarra karrpilpayi. Palunyalunga jiinkajanga warlangkupayi. Martu palunga wiltu, murlpirrpa nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kawarnkawarn palunyanga wulu parra yankula mirrapayi, mitukajangka katu. Kuurti mitukurnu kanyilpayi. Wulurtuka mirrapayi mungangkalurrju. Yapungka ngarnawarralurrju tatira mirrapayi, karni marlaku yankupayi. Purlikurlulungku katupungkupayingku walyjalu ngakumpalu palunyalu. ");
INSERT INTO mpj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Martu palunyalu nyangu Jiijajpanga. Kalu kawarnkawarnpangalu pinirringu murti jurrpujurrpulu nyinangu. Kuurti mitukurnu laltu kanyilpayi. Jiijajju kuurti laltukaja-jananya payirnu kurtingu, “Yarraluraya martungkamarra!” Martu palunya mirrangu punkarnu, kayila wiltulu wajarnu, “Nyuntungan yini Jiijajpa Mamakurnu kaja, maparnkurlun, majukurlun. Nganakurnin yanurni ngaakutu? Jurrarni nyarru mirtarnin putamala!” ");
INSERT INTO mpj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jiijajjura japirnu, “Nganan nyuntu yini?” “Ngayurna yini laltupurluka. Jilanyarnanta wajarni, ngayungarna ngunukurlu laltukurlu.” ");
INSERT INTO mpj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","12","Nguurrnguurrkajalungaya yapungka yirritiwanaluya ngalkula yankupayi. Ngunukurlulungara Jiijajpa japirnu, “Mirta-lanyajun ngunukaja ngumpala wiyala!, ngurra kujupakarti, tiwa!, ngaalaju nyinaku nguurrnguurrkajangka.” ");
INSERT INTO mpj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jiijajpa-janampa yuujunu. Palunyangkaya ngunuparaku pakaraya yanu jarrpangu, nguurrnguurrkuyarrangka. Nguurrnguurrpangaya kujarra jawujunpaya nyinapayi. Nguurrnguurrpangaya yiltangulyu ngunukurlu jawarnu yanuya yapungka yirritiwana kalyukarti. Pinirringuya jarrpangunirra kalyungka wulikaja miturringu. Ngunulurrjuya miturringu kalyungka. ");
INSERT INTO mpj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","16","Ngunu wiyarringulura martu palu kunyjunyurringu. Nguurrnguurrku maajakajaluya nyakula yanu, jakurlkurlu, ngurra kujupakarti. Maa-jananyaya jakurljunkutipayi ngurra kujupawana, ngurra kujupawana, tawunwanalurrju. Palunyaluya ngurra jiimartajilu kulilpayi. Kuliraya pakara yankupayi kujungkarripayi, nyakukijaluya Jiijajpakamu martu ngakumpajanu palyarrinyja. Nguurrnguurrku maajakajaluya-jananya wajarnu jilanya, “Nguurrnguurrlurrjuya kalyungka jarrpangu miturringu, kuurtikamulurrju.” Nyanguya martukajalu ngakumpa palu kunyjunyurringu. “Jawujakamu jaartakurlu palunyanga nyinin. Jiinga ngunukurlu kunyjunyurringu.” ");
INSERT INTO mpj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jiimartaji maajakamulurrju ngurlurringu, nyanguya maparnpa maju. Karaya wajarnu, “Jurra-lampaju ngurra!, ka yarra ngurra kujupakarti!” ");
INSERT INTO mpj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jiijajpa yanu jarrpangu puutka, yankukijalu. Martu palu ngunujanulura japirnu, “Yankuli kujungka?” ");
INSERT INTO mpj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jiijajjura wajarnu, “Yarra marlaku!, nyuntumili martu walyjakarti. Wajala-jananya jilanya!, ‘Ngayurni maaja jiilu maparn majulu wankarnu. Nyangu kaju nyarrurringu. Ngayungarna kuurtikurlu ngakumparna nyinapayi.’” ");
INSERT INTO mpj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Palujanu martu palunyalu yiltangulyu-jananya parra yankula jakurljunkupayi, ngurrawana, mayawanalurrju. Palukajaluya palumili wangka kulirakaya kuru pakalpayi, jumaji Jiijajju maparn majulu kunyjunyunu. ");
INSERT INTO mpj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Puutjaya tatirnu Jiijajkamu palunyamili wangka-nintikaja. Kalyuwanaya yanu ngurra kujupakarti. Wumurripayiya jiimartajinga warnmarlakuyarrarringu wangkaluya kulilkuraku, Jiijajja. ");
INSERT INTO mpj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Murrarniya wumurrima Jarritingka. Jaajkungara Jarajpa maajanga nyinama. Kulirnuyilapa yanu nyangu Jiijajpa palunyangkayilalu pupatingu, ngaranyjanja. ");
INSERT INTO mpj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kayilapalu wajarnu, “Jijiju wanti ngarnta maju ngarrin. Yankurali, ngalurajun wankalkura.” ");
INSERT INTO mpj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kapula Jiijajpa kujungka yanu. ");
INSERT INTO mpj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Martukajangka-jananya laltungka ngarapayi wanti ngarnta. Palunya nyinapayi ngarnta nyukurnijanu, purtu wankaraya junkupayi, maparnkajalu. ");
INSERT INTO mpj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Manikajangangku wirrupungunirra maparnkajaku, wulu ngarnta nyinapayi, mirta kunyjunyurringu, paki. ");
INSERT INTO mpj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nyukurninga-jananya Jiijajju pampura palyamankupayi, palunyayila kulirnu wantilunga. Kulirnungku palunyalu, “Jiijajmilirnara kuurtu pampulku palyarrikuyilarna.” Palujanu marlawanajanulu yanurnika pampurnu. ");
INSERT INTO mpj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Palunyangkayilapa ngarntanga wiyarringu. Jiingkangulyuyilapangku kulirnu, “Ngarntaparnirringurna palyarringu.” ");
INSERT INTO mpj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jiijajjungku ngungkujunu pampunyja. Palunyajanu pijurringu ka-jananya japirnu, “Nganaluparni ngalurnu?” ");
INSERT INTO mpj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Palumili wangka-nintilu wajarnu, “Nganaku-jananyan japirninpa? Yarnngalu-lanyangkuya yangajuninpa.” ");
INSERT INTO mpj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jiijajjungara maa ngurrilpayi, nganaluminyirri ngalurnu. ");
INSERT INTO mpj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Palunya pampunyjajanunga tujunga wangkaparnirtuka ngurlu tititipungkupayi. Ka yanu Jiijajkartilu ka pupatingu. ");
INSERT INTO mpj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jilanyalu wangkangu, “Ngayulurnanta ngalurnu.” Jiijajjura wajarnu, “Nyuntulurnin wantilu kulirninpa maparn majuwinti, nyinamalpayilapan ngarntaparni. Pukurlpan yanku nyinamalpa, palyarrinyja.” ");
INSERT INTO mpj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Palujanuya Jarajmili warrkamupurlukakaja ngurrajanu yanurni, kaluya Jarajja wajanu, “Paki, Jiijajpa jurra yarra!, nyuntumilingku yurntalpanga pakirringu.” ");
INSERT INTO mpj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jiijajjulu wajarnu Jarajja, “Wanyuli yankura nyuntumili ngurrakarti. Mirtan wirla walykurri!, ngayurni kulinma!, maparn maju.” ");
INSERT INTO mpj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jiijajju-jananya marrkurnu karlki wangka-nintikaja, palunyakurnu, “Majalajuya ngaangka!, yupalpalajulu wanalkura ngurrakarti.” Ka karlki kujupa-jananya Jiijajju katingu jilanya Piija, Jayimijpa, Jaanpa. Jayimijpakamu Jaanpa kurtararrapula. ");
INSERT INTO mpj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kulilkatipayiya ngurrangkaya wiltu yulapayi. ");
INSERT INTO mpj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mayangkaya jarrpangu Jiijajmapu. Jiijajju-jananya marrkurnu, “Yakarriya! Yipilypanyurra yulinpa kunyala ngarrinpa. Jiijajju kulirnu mitu ngarrinyjanpa.” ");
INSERT INTO mpj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kulirnukaya yikarringu karlkinga. Ngaanga wulu mitu ngarripayi. Jiijajju-jananya mirrangu kujungkanu, paluku mamakamu yipi, palumili wangka-nintikajalurrju. Karlki kujupa-jananya witurnu yiyarnu, yankuraya wirrirli nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Palunyangkayilapa Jiijajju wanti palu mara winirnu, ka wajanu, “Talija kumi!” Wangka palu walyja wajarnu, jilanyala wajani, “Kuyurn, pakalarni!” ");
INSERT INTO mpj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wangkangka jiingkartuka paarlarnu, kayila pakarnuka parra yankupayi. Kurnurringuluya nyakula parra wanalpayi, jumaji mitujanu kanarnu Jiijajju. ");
INSERT INTO mpj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jiijajju-jananya marrkurnu, “Mirta-jananyanyurra yankura wajalkuran, ngaanyurra nyakunyjajanulu, paki, lalturniya wumurrijakunpa.” Palunyajanungkalu yakupartarnungka wajarnu, “Mirrkara yuwa!” ");
INSERT INTO mpj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Palunyajanuya Jiijajkamu wangka-nintikaja walyjakaja yanuya marlaku, ngurra walyjakarti, Jiijajmilikarti. ");
INSERT INTO mpj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ngurra palumartajiya kujungkarrira jarrpapayi Juwukurnungka jaajja, Jarritingka. Jiijajpa wangka-nintikajalurrjuya yanuya jarrpangu, jaajja. Wajarnuraya jiimartajilu Jiijajku, “Pakala-lanyaju nintijula!, Mamamili wangka.” Yiltangulyu Jiijajpa pakarnu wangka kunyjunyu-jananya wajalpayi. Palunyangka martukajaya yakarringu wanarnu. Palunyajanuluya wajalpayi-ngkuya, “Jiinga wangka majukurlu.” ");
INSERT INTO mpj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Karlki kujupaluya marlalu wajarnu, “Ngaanga Miirimilikamu Juujapmili kaja. Palunga kapanta warrkamurripayi. Palukuraya marlajukaja ngaangka nyinani, ngapimapu?, Jayimijpa, Juujappa, Jayimunpa, Juutajpa. Palumiliraya marlajulurrju nyinani wantikaja. Ngaanga parnapurluka, mirta ngarnawarrapurluka.” Jankapayiluya jilanyalu, mirtaya ngangkulpayi, Mamakura kaja ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jiijajju-jananya wajanma, “Jampa Mamamili jakurlpurlukarna-jananya yankupayi ngurra kujupakarti martujuya pukurlarripayi. Ka ngayumili tawunja martujuya ngaamartaji mirta pukurlarrini, ngayumili walyjalurrjujuya mirta pukurlarrini.” ");
INSERT INTO mpj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Palukajaluya nyurnimalpayi Jiijajpa maparn majukurlu. Yupalwiyaju-jananya maralu pampuraka wankalpayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ka Jiijajjungku kulilpayi, “Nyaakurniya ngayu maparn majuwinti kulira junkuni?” Palujanu Jiijajpa tawun kujupa kujupakarti-jananya yanu, kayila-jananya nintijunkupayi, Mamakurnu wangka. ");
INSERT INTO mpj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jiijajpa-janampa mirrangu palumiliku wangka-nintikajaku, “Yarrarniya kulila! Kujarra kujarrangururna-nyurranya kurtingku ngayukurnu wangkanyurra nintijunkuraku. Mamamili maparnparnantaya yungku martukaja-jananyanyurra wankalkuraku, kamu malpu payira wiyalkura.” ");
INSERT INTO mpj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Palunyangka-jananya Jiijajjunga yungu maparnpa. Wiyalkijalu-janampa wajarnu, “Yankukijalunyurra wartakajakamu mirrka mirta kati!, manilurrju. Wartanyurra kuju katiku, ngurra kujupakarti, jarntu pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jinapuka walyjakamu, jaarta walyjakurlun yanku. Mirtan kujupa kati!, junkun ngurrangka, yanku.” ");
INSERT INTO mpj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jiijajju-janampa yarrarnu wajarnu, “Yankupulan tawunkarti ngurra kujungkapulan nyinaku. Palujanu pakarapulan yanku tawun jiiwana Mamamili wangka-jananyapulan nintijunku, martukajangka. Palujanupulan pakara yanku tawun kujupakarti. Wululupulan maa nintijunkumalpa tawun kujupa kujupakajangka, Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tawun kujupanguruluntayapula jampa nyurnimanku, ka nyuntu kujarramili wangkantayapula kulilku junku. Palunyangkapulan jinapuka yarralku parna pungku, jii tawunpa junku yankukijalu. Palunyangkaya jiimartajilu kulilku, ‘Mamamili wangkangka, jiingapula yanurni. Jii kujarralaju-pulanya nyurnimanu, palunyajanupula pungu parna. Mayitpi-lanya yiltangulyu nyurnijanu pungku maparnju, Mama ngarnawarrapurlukalu.’” ");
INSERT INTO mpj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Palunyangkaya wangka-nintikaja yankupayi tawun laltuwana. Kujarralupula Mamamili wangka wajalkatima, tawunwana. Kujarra kujupalupula maa wajalkatima tawun kujupawana. Kujarra kujupalupula maa wajalkatima tawun kujupawana. Jilanyaluya wululu Jiijajmililu tuwal wulikajalu parra wajalkatipayi. Nintijulpayi-jananyaya walykukajaya junkuraku, karaya Mamaku junga nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Malpukaja-jananyaya payira kurtingkupayi, malpukajawintikajangka. Ka-jananyaya martu ngarntakaja jinyjilu yinyara wankalkatipayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","19","Ngurra kujupajanulu-jananya martukaja Juwukaja kanyinma maajalu majulu Yirutju. Pilapu nyinapayi Yirutkura marlangu. Julyju Yirutju muntaralu kanyilpayi Pilapuku nyupa yini Yirutiyajpa. Jaanju Yirutpa marrkurnu, “Mirtaran kanyilkura nyuntuku marlanguku nyupa, jurra!” Jilanyalu marrkurnu Jaanju, kara wanti Yirutiyajpa wirrilyirringu ka kulirnu Jaanpa mitu pungkukijalu. Yirutju jakurlpa kulirnu, ka wajarnungku, “Jaanparna kanyilku jiilja, Yirutiyajmapuluya pungkujakungkamarra.” Yirutju-jananya witurnu wiyarnu palunyamili warrkamupurlukakaja, Jaanpaya tayimapura ka nyinajunkuraku, jiilja, jumaji Yirutiyajju julyju wajarnu Jaanpaya mitu pungkukijalu. Wanti jiilu purtu kulirnu pungkukijalu jumaji jiilja nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yirutpara Jaanku ngurlu nyinangu ka kulilpayi, “Yilta, Jaanpa Mamaku junga nyininpa, ngarnawarrapurlukaku.” Wulu jiilkarti yankura ka marlakurripayi Jaanmili wangka palya kulilpayi. Nyinaraka purtu kulilpayi Mamakura junga nyinakura. ");
INSERT INTO mpj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yirutku paajayi nyinapayi. Warrkamupurlukakajaya wumurrira nyinapayi, murrarni. Kaya mirrka pukurlju ngalkula nyinapayi, wamalurrjuya jikilpayi. Wanti jiilu Yirutiyajju kulirnu, “Kuwarriya kujungkarriku, kayilaparnalu Yirutja wajalku kurungka yarnngangka, Jaanpaya mitu pungkuraku.” Yirutpa-janampa mirrangu wumurriraya yankurakurni, yarnngakuyarra. Palunyangkaya maaja majukajaya yanurni palunyamilikutu mayakutu, kapamanpurlukakajakamu, jantulwintiku maajaparakulurrju. Parna Kaliliyamartajilurrjuya, yarnngakuyarra yanurni. ");
INSERT INTO mpj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jiikajaya nyinapayi mayangka kaninyjarra. Pukurljuya ngalkula mirrkakamu kuka, wamalurrjuya jikilpayi. Wanti Yirutiyajkura yurntalpa yanurni-janampa nyarnpipungkupayi, nyakurakuya, yirnakajalu. Nyanguya jii yurrkanypa palulu nyarnpipungkupayi, kaya pukurlarringu. Palunyangka maajalu Yirutjura yurrkanypa palu japirnu, “Nganarnanta yungku? Wajalkurnin nganarnanta yungkuraku?” ");
INSERT INTO mpj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yirutjura jamartapungu jilanyalu, “Nyuntulurnin wajanyjangka, yiltalurnanta yungku, mayiti mayakaja, mayiti warntukaja, mayiti manikaja, mayiti murtitikirlkaja. Wajalarni!, ka katamatulkurnanta yungku.” ");
INSERT INTO mpj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yurrkanyjura jiilu yanu japirnu Yirutiyajpa palumili yipi, “Nganarnara wajalku?” Palumili yipilura wajarnu, “Yarralu wajala!, Jaanpaya mitu pungkura, kaya kata, wangkulyingka jurra, ka katirni nintijula! Jaanju palunyalu-jananya kalyungka yirrpilpayi.” ");
INSERT INTO mpj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Marlaku wirrjarnu yurrkanyju kara japirnu, Yirutpa. ");
INSERT INTO mpj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yirutju kulirnu ka wirla walykurringura Jaanku. Purtu kulirnu yurrkanyjalu walyjangka pakijunkuraku, jumaji jamartapungulu julyju, maajaparakukajangka kurungka. ");
INSERT INTO mpj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Palunyangka Yirutju jantulwintingka wajarnu yiyarnu Jaanpa kata katupungkura warlangkura. Yanu jiilkutu ka kata katupungu warlangu, ka manu katingu marlaku. Katingura wangkulyingka yungu yurrkanypa palu. Ka yurrkanyju palulu katingu palunyamilikarti yipikarti, Yirutiyajkarti, kara yungu. ");
INSERT INTO mpj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jaanmili wangka-nintikajaluya jakurlpa kulirnu kaya jiilkarti yanu. Mankuraya katingu tuunyjunkukijalu pirtingka. Martukajaluya nyakupayi Jiijajju-jananya wankalpayi maparn majulu. Kaya martukajaluya karlkilu Jiijajpa kulirnu, “Yilta ngaanga Jaanpa mitujanu pakarnu, maparnwinti.” Ka martu karlkinjuya kulilpayi jilanya, “Jiijajpanga yumuwanpa yini. Yiltangurninyjinga martu palu julyjujanu, Yilayija. Palunga wankarringu kuurtijanu. Jiilu-jananya wankani maparnju majulu.” Kaya martu karlkin kujupaluya Jiijajpa kulirnu, “Jiinga martu julyjujanu mitujanu wankarringu, ka-jananya wankarninpa, Mamamili wangka jakurlpurlukalu.” Palunyanga Jiijajpanga Yirutju kulilpayi, ka wajanu, “Yilta Jaanpa jiinga mitujanu pakarnu. Mamalu wankarnu nyinajunu. Jaanju-jananya wankarninpa, maparnju majulu.” ");
INSERT INTO mpj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jiijajmili wangka-nintikajalu-jananyaya wankalpayi yarnngangka tawunja. Nintijunkupayi-jananyaya Mamamili wangka, kaya palunyamili wangka-nintikaja marlakurringu. Jiikajangala-jananya wajani yini kujupa, Jiijajmili jakurlpurlukakaja. Jiikajaya yanurni kaluya Jiijajja jakurljunkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Palujanuyilaya yarnnga ngarala wanalpayi, Jiijajmili wangka kulilkuraku. Wuluya ngarala kulilpayi, kaya purtu kulilpayi mirrka ngalkuraku. Jiijajju-jananya wajarnu wangka-nintikajangka, “Kujungkala yanku ngurra kujupakarti jaalpula nyinakura.” Jiijajmaluya puutja tatirnu, kaya yanu kalyuwana. ");
INSERT INTO mpj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","33","Puutjaya kalyuwana yankupayi, ka martukajalu-jananyaya nyanguka wanalpayi, yirritiwanalu. Tawun kujupajanu, tawun kujupajanu-jananyaya kujungkarringu kaya yarnngakuyarrarringu. Kaya yanu Jiijajmapuku majalpayi. Kayilapaya Jiijajmapu puutja warinykatingu. ");
INSERT INTO mpj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jiijajpa tiputingu ka-jananya nyangu martu yarnnga, ka-janampa nyarrurringu, jumajiya maajaparni. Jiipuyuruya yarnngayuru ngarala wanalpayi, jiipupurlukaparniyuru. Martu yarnnga jiinya mirta-jananya maajalu ngampurrju kanyilpayi. Ka-jananya Jiijajju Mamamili wangka nintijunkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Wulu-jananya nintijunu uuu, nintijunu uuu rukarringu. Jiijajku wangka-nintiluraya Jiijajku wajarnu, “Nyawa!, yukarturrini. Wajala-janampa yankurakuya!, yanku-ngkuya mirrkakaja payamulkuraku, pakingka mirrkapunajangka warrarnwiyaju.” ");
INSERT INTO mpj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jiijajju-janampa wajarnu wangka-nintikajangka, “Paki, kaanpaya yanku, nyunturtinju-jananyaya yuwa mirrka!” Purtuya kulirnu japirnuluya, “Kajila yanku mirrka mankuraku?, tawunja kinti, mani majuwintilu?, tuu jawujunwintilu?” ");
INSERT INTO mpj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jiijajjulu wangka-nintingkalu japirnu, “Yawumini karlukarluya kanyirni? Yarra-jananya japila!” Wangkanintilu jiilu yanu-jananya japirnukalu yanulu jakurljunu Jiijajja, “Kanyinilaju karlukarlu payip wulikaja, ka kujarra piijpa.” ");
INSERT INTO mpj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jiijajju-jananya wajarnu martukajangka, walyjararranpa walyjararranpaya nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kulirnuka jilanyayuruya nyinatingu walyjararranpa walyjararranpa. ");
INSERT INTO mpj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka karlukarlukamu-pulanya piijpa manu marangka ngalurnu, ka ngarnawarra nyangu, kalu Mamangka wangkangu, “Mama nyuntulu-lanyajun mirrka yungkuni, kalajunta marninypungkuni.” Palujanu mirrkakamu piij manu ka warlangkupayi, yungkupayi-jananya wangka-nintikajangka. Ka-jananyaya wangka-nintikajalu yungkupayi martukaja, mirrkakamu piij ngalkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Kaya ngalangu parljarringu yarnngalu. Karlkiluya ngalkula junkupayi parnangka. Wangkanintikajaluya turampungka parra mankupayi, martuluya mirrkakamu piijpa, ngalanguya junujajanu. Jii turampukaja tuwal wulikaja parraya kangkupayi wangka-nintikajalu. Turampukajangka mirrkakaja majurringu. Jilanyaya martuya yirnakajanga payip jawujunpa nyinapayi, wantikamu ngulyikajalurrju, yarnngaminyirri. ");
INSERT INTO mpj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Palujanu Jiijajju-jananya tatijunu puutja palumili wangka-nintikaja, ka ngarapayi. Ka-janampa wajarnu, kurranyiya yankuraku, tawunkarti Pijajkarti. Ka-janampa puntu yarnngakuyarraku wajarnu, ngurrakutuya marlaku yankuraku. ");
INSERT INTO mpj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","47","Kayilapa purlingka tatirnu palunya, Mamangkalu wangkakija. Mungajarrarrinyjangka Jiijajpa ngarapayi purlingka ngarnawarra. Palunyangka Jiijajmili wangka-nintikajaya tiwa yankupayi kalyungka kutukutungka puutja. ");
INSERT INTO mpj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tiwajanulu-jananya nyangu rawaluya yungkalkatipayi wanakurlulu. Kaya jakajakarringu wangalju-jananya ngaparrju yungkalpayi. Kaya manarrarringu ngarapayi kalyungka kutukutungka. Yungunyungunpa Jiijajpa yankupayi kalyungka ngarnawarra, kutungka. Puutja wirrirliyuru wati yankupayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Palunyamililu wangka-nintikajaluya tiwa nyangu, kaya ngurlurringu, warnapa kararnuya. Kaya ngurluwinti mirrangu. ");
INSERT INTO mpj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ka Jiijajju-jananya wirrirlijanulu marrkurnu, “Ngurluparnirriwayawu! Ngayulurna-nyurranya nyanginpawu! Ngurluparniya nyinamawu!” ");
INSERT INTO mpj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Palujanu puutkutu yanu ka tatirnu Jiijajpa kuju. Palunyangka wangalpa yatarnarringu. Wangkanintikajaya yakarringu kulira nyinapayi, jumaji wangalpa yatarnarringu, mirtaya kulilpayi maparnkurlu jumakurlu nyinanyjanpa. ");
INSERT INTO mpj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Puntu yarnngakuyarraku-janampa mirrka palyarnu maparn jumalu. Jiiya kulilngara Jiijajpa Mamamili maparnkurlu. Mirtaya kulilpayi, yumuya yurtuyurtu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kalyuwanaya yankupayi wulu parnakutu Kinijarijakutu. Tiputinguya puutpa karrpirnu, wangalju mankura katijakungkamarra. ");
INSERT INTO mpj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Palunyamartajiluya Jiijajpa yintarnuya ngalya. Ngarnta-jananyaya kangurni, Jiijajju wankalkuraku-jananya. Tawunpa kujupa kujupangka Jiijajju-jananya nintijunkupayi. Tawunpa palunyamartajiluya jakurlpa katipayi. “Jiijajpa yaninparni tawunu ngaakutu.” Palunyangka tawunpa jiimartajiluya ngarnta-jananyaya laltukuyarra katipayi. Yarnngaya-jananya paangkangka katipayi. ");
INSERT INTO mpj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tawunpa kujupa kujupawanalu Jiijajju ngarnta-jananya wankara junkutipayi. Mamamili wangka-jananya nintijunkupayi. Ngurrangka yumu nyinakija Jiijajpa mayangka jarrpapayi, palunyangkaya karlkinju ngarnta yarnnga mankura katira kanyilpayi yitingka, Jiijajju wankalkuraku. Jiiyuru-jananyaya ngarntakaja wululu katipayi tawun kujupa kujupangka. Tawunja kutungkaya parlkarrangka puntuya wumurripayi. Jiijajpa puntu jiikajawana-jananya yankupayi. Palunyangkaraya Jiijajpa japilpayi kuurtuya pampulkijalu ngarntakajalu. Ngarntakajaluya yarnngalu palumili kuurtu pampurnu kaya palunyangka wankarringu. ");
INSERT INTO mpj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palunyajanuluya Jiijajja kujungkarringu Muujajmili wangkapurlukakajakamu Parajikaja, Jarujalumujanuya. ");
INSERT INTO mpj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jiikajalu-jananyaya nyangu Jiijajmili wangka-nintikaja, mirta-ngkuya mara waajamunu, mirrka ngalkukijalu. Ka jiikajaluya kulilpayi, “Jiijajmili wangka-nintikajalu-lampaya mirta ngayurtinmili luwu kulini, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Muujajmili wangkapurlukakajalukamu Parajikajalu murrarnilu-ngkuya mara waajamuni ngalkuraku, mitunyjanirrilu wajanyjangka. ");
INSERT INTO mpj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tawunja kutungka payamuniya katini, mirrkakamu kuka. Murrarnilu-ngkuya mirrkakamu kuka waajamurninpa. Murrarniluya tiijikamu puliti kartaku yarnnga kujupakirli waajamurninpa, mitunyjanirrilu wajanyjangka. ");
INSERT INTO mpj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Muujajmili wangkapurlukakajalukamu Parajikajaluya jilanyaluya Jiijajja wajarnu, “Nyuntumili wangka-nintikajaluya mitunyjarrimili luwu ngangkuraya junkuni, mirta-ngkuya mara waajamuni mirrkaya ngalkuraku, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jiijajju-jananya wirrilyilu wajarnu jilanya, “Mayunyjuyurunyurra nyininpa, mirta-jananyanyurra Mamamili wangka jungalu nintini. Julyju Mamamili wangka jakurlpurlukalu Yayijayalu wajarnu-nyurranya mayunyjunyurra nyinaku. Jilanya wajarnu, ‘Mama ngarnawarrapurlukalurni wajarnu. Ngulaya martukaja mayunyju nyinaku. Jaaluwiyajurniya wajalku, mirtarniya yiltalu marninypungku. ");
INSERT INTO mpj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Purturniya marninypungku mitunyjarrimili luwuwanaya nyinakijalu. Mirta-jananyaya ngayumili wangka nintijulku, pakiwanaya wulu nyinaku.’” ");
INSERT INTO mpj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wituka-jananya Jiijajju wajarnu Muujajmili wangkapurlukakajakamu Parajikaja, “Mitunyjanirrilu wajanyjangkawiyaju kulirninpanyurra. Mamamili wangkanyurra kulira juninpa.” ");
INSERT INTO mpj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jiijajju-janampa japirnu, “Nyaakunyurran Mamamili wangka ngangkuraka junkuni?, nyurrartinmili mitunyjanirrimiliku wangkakuranyurra nyurirrini. ");
INSERT INTO mpj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Julyju-lampa Muujajju wajanu jilanya, ‘Mamakamu yakurti-pulanyaya ngampurrju kanyila!, mirta nyurnimankuraku, kunyjunyulunyurran kanyilkuraku.’ Ka wangka kujupa ngaanya Mamalu wajanu, ‘Jampa-pulanya mamakamu yakurti nyurnimalku, martu palunyanyurran pungku miturntalku jumaji nyurnipayi.’ ");
INSERT INTO mpj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wangka paluyurukajanyurran ngangkuraka junkuni, ka-jananyanyurran pakiwana parra nintijuni jilanya, ‘Jampanyurran manikamu purnunpa manku, mirtanyurran yakurtikamu mamarti yungku, jurraya!’ Jilanyanyurra pakiwana nintijuni. Jilanya-jananyanyurra pakiwana wajani, ‘Mama ngarnawarrapurlukakurnara ngaanya manikamu purnunpa yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Jilanyanyurra-jananyan nyunturtinju nintini, pakiwana yakurtikamu mamarti nyakura junkuraku, maningkunyurra walyja kanyilkuraku. Mamamili wangkanganyurran warlangkuni, Parajikajalu, nyunturtinmili mitunyjanirrimili kurannyurran nyurirrini. Jilanyayuru mitunyjanirrilu wajanyjawiyajunyurra kulirninpa, Mamakurnu wangka kulilparnilu.” ");
INSERT INTO mpj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","(Juwukajalu-ngkuya murrarnilu mara waajamunkupayi ngalkuraku, mitunyjanirrilu wajanyjangka. Tawunja payamunuraya katipayi, mirrkakamu kuka. Murrarnilu-ngkuya mara waajamulpayi mirrkakamu kuka ngalkuraku. Parajikajaluya kulilpayi jilanya. Jampa martulu mara waajamunkuparnilu ngalku, Mamamili luwu warlangku.) Jiijajju-jananya martukajaku mirrangu kujungkanu, ka-jananya wajarnu, “Wangka ngaanyaya ngangkula! Jampa martulu mara waajamulkuparnilu ngalku, mirta Mamamili luwu warlangku. Jampa martulu jaalu martu kujupa warrkilku, ka nyurnimalku palujanu Mamamili luwu warlangku.” ");
INSERT INTO mpj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiijajju-jananya kurtingu, ka-jananya karlkinpa palumili wangka-nintikaja katingu jarrpajunu mayangka. Wangkanintilu karlkinjuraya japirnu, wangka palunyaku martulu Mamamili luwu warlangkuni, wangka jiikuraya nintirrikuraku. ");
INSERT INTO mpj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jiijajju-jananya ngaparrju japirnu, “Kajinyurra ngurrpa wulu nyininpa? Ngangkulaya! Martulu mirrka waajamuraka ngalkuni palujanu mirrka nyuruwana yankuni. Ka pakirrini jampa yankuni tuyilitkarti. Mirta Mamamili luwu warlangkuni, yiipi mirta mara waajamulkuraka ngalkuni. Kunyjunyulunyurra kukakamu mirrka ngalkuraku.” (Wangka jilanya Jiijajju wajarnu. Palunyangkala kulirninpa. Kukakamu mirrkala yarnnga ngalkuraku, karlkinpa junkuparnilu.) ");
INSERT INTO mpj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jiijajju-jananya wituka wajarnu, “Jampa martulu Mamamili wangka junkuni ka kujupawana wajani, palujanunga Mamamili wangka warlangkuni. ");
INSERT INTO mpj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yiipi martulu kulilku walyku ngapilkuraku, ka yanku walyku ngapilku, jiilunga Mamamili luwu warlangkuni. Yiipi martulu kulilku warta kujupamili ngulyulu mankuraku, ka palujanulu yankukalu ngulyulu manku, jilanyanga yiltalu walyku ngapini. Yiipi martulu kulilku martu kujupa pungkukijalu, ka palujanu yankuka pungku, jilanyanga yiltalu walyku ngapini. ");
INSERT INTO mpj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Yiipi martulu kulilku martu kujupamili wartakaja wululu kanyilkuraku, ka palujanu yanku mankuka wulu kanyilku, jilanyanga yiltalu walyku ngapini. Yiipi martulu kulilku martu kujupangkalu kajalkuraku, ka palujanu yankulu palungka kajalku, jilanyanga yiltalu walyku ngapini. Yiipi martulungku nyupa walyja junku yanku, ka yanku nyupa kujupangkalu ngarriku, jilanyanga yiltalu walyku ngapini. Yiipi martulu martu kujupa nyurnimanku, jilanyanga yiltalu walyku ngapini. Yiipi martulungku walyjalu marninypungkumalpa, jilanyanga yiltalu walyku ngapini. Yiipi martulu Mamamili wangka kulira junkumalpa, jilanyanga yiltalu walyku ngapini.” ");
INSERT INTO mpj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jiijajju-janampa yarrarnu wajanu, “Yiipi martulu kulilku jilanyayurukaja walykukaja ngapilkuraku, ka yanku walyku jiikaja ngapilku, jiilunga Mamamili luwu warlangkuni, yiltalu walyku ngapini. Yiipi martulu kukakamu mirrka ngalkuni, mara waajamulparnilu, mirta Mamamili luwu warlangkuni, paki, ka mirta jilanyalu walyku ngapini.” ");
INSERT INTO mpj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Palunyangka Jiijajjukamu wangka-nintikajalurrju junkulaya yanu ngurra kujupakarti, parna Taayakartikamu parna Jayitankarti. Ngurra palunyangkaya mayangka jarrpangu nyinapayi. Martungkamarra-janampaluraya jarrpangu yaka nyinapayi, mayangka. Kaya martukajalu kulinu Jiijajpa jiingka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ka wantilu jakurlpa kulirnu kayila yanu mayakarti jarrpangu nyangu Jiijajpa. Yiltangulyu wanti palunya pupatingu Jiijajjalu. Kayila japirnura wiltulu, “Yurntalpaju ngarntarringu ngarrin. Yarralu payila malpu wiyala!” ");
INSERT INTO mpj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wanti jiinga Juwuparni nyinapayi Panijiyamartaji. Parna Jiriyamartaji Juwukajaluya kulira wajalpayi, “Panijiyamartajiya jarntuyuru nyininpa, martu puta, mirtaya Mamamili wangka kulira nyinani.” Palunyakura yurntalpa ngarripayi ngarnta maju. ");
INSERT INTO mpj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jiijajjulu wajarnu wangka yumuwanpa wantingka, “Mirtalajura mankura mirrka yungkuni jarntu, jijimili.” ");
INSERT INTO mpj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wanti palunyalura wajarnu, “Yuwa, kulinirnanta. Ka wangka kujupa ngaa yilta nyinani. Jarntulu ngalkuni mirrka jijimili warningunyjangka, tiipulja kaninyjarra. Ngayulurnanta maparnwintingka jarntu jiiyurulu japirnin mirrkayuruku. Yurntalpaju wankala!, jii maparnwintilu.” (Juwukajaluya martu kujupa Juwuparni nyakuraka nyurnimankupayi jilanya, “Jiinya walyku, jarntuyuru.) ");
INSERT INTO mpj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jiijajjura wajarnu, “Wangka jiin wajarnu kuwarri junga. Palunyajanu yurntalpangku kuwarri kunyjunyurringu ka nyininpa. Ngayurnara mirta yanku wankalkuraku. Palujanu yarra marlaku!, nyuntumili ngurrakarti, kayilapan nyaku, nyuntumili yurntalpanga wankarringu.” ");
INSERT INTO mpj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Palunyajanu yanu wanti ka nyangu kunyjunyurrinyja, mirta malpuwinti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ngurra Taayajanu Jiijajmapuya marlaku yanu ngurraparaku ngurrawana, parna Jayitanwanakamu parna Tikapulijawana. Kalyu Kaliliyakutuya yanu parra nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Palunyajanuluya martu jiimartajilu Jiijajkutu katingu yirna ngakumpa ngakumpa, wangkaparni. Japirnuluya pampulkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jiijajju winirnu katingu yirna jaalpu ngamungulyu. Ka wakarnu kuran kujarra mara kujarralu. Jiijajju marangkangku jangajunu, ka pampurnu nyanyjarla yirna palu, mara jangawintilu. ");
INSERT INTO mpj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pampunyjalu yirra nyangu ka ngaanymanu. Kalu martungka Jiijajpa wangkangu, “Yipapaja.” Wangka palunga jilanya, “Wangkawintirri!” ");
INSERT INTO mpj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Palunyangka kulirnu ka wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Ka Jiijajju-jananya marrkunu mirtaya parra jakurljunkuraku, jumaji martu jiinya wankanu. Kaya kulinu junu kaya nyurilu parra jakurljunkupayi. Kaya kujupakajalu jakurlpa kulinu kayilapa-ngkuya pukurlpa wangkapayi jilanya, “Yiltalu pampura-jananya wankani, maparn majulu. Yalyjirrju pampurninpa-jananya.” ");
INSERT INTO mpj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Palunyajanuya puntuya yarnngakuyarra Jiijajjaluya kujungkarringu kulilpayi. Rawaluya kulira nyinapayi mirrkaparnilu. Jiijajpa-janampa nyarrurringu, ka palunyakurnu wangka-nintikajaku-janampa wajarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Martukajaku ngaakajakurna-janampa nyarrurrini, jumajiya mirrkaparnirringu. Karrpuparakuya ngaangka warrarnja nyinapayi mirrkaparni, wirrirlijanu. ");
INSERT INTO mpj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mirtarna-jananya kurtingku ngurra walyjakarti, mayitiya kutungka yankura punkaljaku, karlkinpaya tiwajanu. Mirrkala-jananya ngaangka yungku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kaluya japirnu, Jiijajpa, “Kaji wanyjangkala-janampa warrarnja manku mirrka maju ngaakajaku?” ");
INSERT INTO mpj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jiijajju-jananya japirnu, “Kajinyurra mirrka kanyini?, mayiti paki.” Kaluya wajarnu, “Yuu. Ngaalaju kanyini karlukarlu yupalpa, japan wulikaja.” ");
INSERT INTO mpj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jiijajju-janampa wajarnu martukajaku, “Nyinaya parnangka!” Palujanu Jiijajju manu karlukarlu, kalu Mamangka wangkangu, “Mama! Marninypungkunilajunta yungu-lanyajun ngaanya karlukarlu.” Palunyangka Jiijajju-jananya warlangkura yungkupayi, palumili wangka-nintikaja. Jiikajalu-jananyaya karlki martu kangkura yungkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Piijpa yupalpaya kanyilpayi. Jiijajju manu piijkaja, kalu Mamangka wangkangu, “Mama! Marninypungkunilajunta yungu-lanyajun ngaanya piijpa.” Palunyangka Jiijajju-jananya warlangkura yungkupayi, palumili wangka-nintikaja. Jiikajalu-jananyaya karlki martu kangkura yungkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mirrkakamu piijpa Jiijajju-jananya yalyjirrju majurnu yungkura wanarnu. Martuluya yarnngalu ngalangu munkurringu, puu jawujun wulikajalu. Ngalanguya wulikajalu munkurringu, kaya mangarri karlkinpa parnangka warningkupayi. Kaya wangka-nintikajalu parra yankura mankupayi, kaya junkupayi turampukajangka, japan wulikajangka, kaya pilamapura wanarnu. ");
INSERT INTO mpj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Palunyajanu Jiijajju-jananya wajarnu, martukaja yiyarnu. Kaya tatirnuka puutja yanu ngurra kujupakutu, parna Talamanujakutu, Jiijajmapu. ");
INSERT INTO mpj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kaya tirritingu puutja Jiijajmapu kaluya yanu Parajikaja Jiijajkutu. Jilanyaya kulilpayi, “Yiipi Jiijajju pakiwana wajalku ngulala kuutja wajalku.” Kaluya wajarnu, “Ngapila-lampaju maparnju yalyjirrju!, nyakuralajunta. Kalajunta kulilku yiltan ngarnawarrajanu.” ");
INSERT INTO mpj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jiijajju-jananya wajarnu, “Paki. Wulurninyurra japirnin ngurra parlparriwanalu, ngapilkurarna yalyjirrju. Jungalunyurra kulilngara kurranyilu, mirtarna-nyurrampa ngapilku yalyjirrju, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jilanya-janampa wajarnu kaya puutja tatirnu yanu, ngurra kujupakarti, palumili wangka-nintikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Puutjaya yankunyjanju kulirnu mirrkaparniya, karlukarlu kujuwiyajuya katipayi, wangka-nintikajalu. Ka-janampa Jiijajju wajarnu kujupakarti, ");
INSERT INTO mpj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","“Wurlkumartaya Parajikajangkamarra!, maaja Yirutjamarralurrju. Palukajaya puta nyininpa, pikinpawutuyuru.” ");
INSERT INTO mpj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Palunyakurnu wangka-nintikajaluya purtu kulirnu ka japirnu-ngkuya, “Ngana-lanya wajarnu?, mayitpi mirrkala mirta kangkura?” ");
INSERT INTO mpj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jiijajpa-jananya wangkangu, “Kulilngararninyurra ngayu Mamamili maparn majuwarta. Ngayulurna mirrkaparningka mirrka ngapilku. Wulunyurra nyininpa kulinyjaparni, kawarnkawarnyuru. ");
INSERT INTO mpj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kurulunyurra nyanginpa, ka pampuruyurunyurra nyininpa, nyakunyjaparni. Kulirninpanyurra wangka, ka kawarnkawarnyurunyurra nyininpa, kulilparni. Maparnjurna kunyjunyukaja ngapilpayi, kulilngararninyurra. ");
INSERT INTO mpj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kulilngararninyurra ngayulurna julyju mirrka ngapilpayi. Ngayulurna-jananya martukaja karlukarlu payip wulikaja warlangu yungu. Palujanuya martulu payip jawujunju mirrka ngalangu, munkurringu. Kayilapaya karlkinpa mirrkakaja warningkupayi. Turampukajanyurra pilamapunu, mirrkakaja. Kaji turampu yupalpa yikipayi?” Ka wajarnuluya wangka-nintikajalu, “Tuwal wulikaja jiinga turampukajanga yikipayi.” ");
INSERT INTO mpj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jiijajju-jananya wituka wajarnu, “Kulilngaranyurra. Ngayulurna-jananya martu kujupakaja karlukarlu japan wulikaja warlangu yungu. Martukajalu puu jawujunkajalu ngalangu munkurringu. Kayilapaya karlkinpa mirrkakaja warningkupayi. Turampukajanyurra pilamapunu, mirrkakaja. Kaji turampu yupalpa yikipayi?” Kaluya wajarnu, “Japan wulikaja jiinga turampukajanga yikipayi.” ");
INSERT INTO mpj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jiijajju-janampa wajarnu, “Ngayulurna mirrka ngapilpayi maparnju. Kanyirninyurra karlukarlu kuju, mirrka japuwarta. Kulilngaranyurra ngayulurna mirrka palu japuwartajanu mirrka yarnngamalku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kalyuwanaya puutja yankupayi Jiijajmapu, kaya parnangkarringu tirritingu yanu tawun Pijayitakarti. Tawunja palunyangkaya jarrpangu, kaya nyangu martu karlkinju Jiijajpa. Kaluya katingu yirna pampuru nyakunyjaparni. Karaya japirnu Jiijajpa, kuru kunyjunyumankura. ");
INSERT INTO mpj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Palunyajanu Jiijajju winirnu katingu. Tawunja yitingka ngarajunu. Kalu jangajunu kurungka, ka pampurnu maralu. Kara japirnu, “Nyanginpan?” ");
INSERT INTO mpj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","“Punturna-jananya nyanginpa wartayuru paalypaalypa.” ");
INSERT INTO mpj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ka Jiijajju wituka yarrarnuka pampurnu, ka taarrkunu wirrirli kayilapa warrarnpa yutirrinyja nyangu. ");
INSERT INTO mpj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jiijajju marrkurnu palunya yirna, “Ngurrakutu marlaku yarra!, tawunja yitiwana. Mirtan-jananya yarra jakurljula!, jurra!” ");
INSERT INTO mpj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wuluya yankupayi ngurra kujupa ngurra kujupangka-jananyaya nintijunkupayi tawun Jijariyapilapangka yitingka, Jiijajjukamu wangka-nintikajalu. Jiijajju-jananya japirnu wangka-nintikaja, “Puntu laltulurniya kulirnin ngayu puntu julyju miturrinyjajanurna. Nganarniya yini wajarnin?” ");
INSERT INTO mpj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Martukajaluya kulilpayi Jiijajpa julyju nyinapayi, ka miturringu, kayilapa wankarringu. Wajarnuraya, wangka-nintikajalu, “Karlkiluntaya wajani, nyuntun Jaanpa mitujanu wankarringu. Jaanju-jananya palulu julyju kalyungka jarrpajunkupayi. Ka karlki kujupaluntaya wajarni nyuntun Yilayija mitujanu wankarringu. Ka karlki kujupaluntaya wajarnin, nyuntun Mamamili jakurlpurluka kujupa mitujanu wankarringu.” ");
INSERT INTO mpj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Palujanu Jiijajju-jananya yarrarnu japirnu, “Wanyjalpanyurra kulini, nganarna ngayu?” Ka Piijalulu wajarnu, “Yuwa. Nyuntun Kurayijpa, Mamalu-jananya julyju jamartajunu nyuntunta kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Palunyajanu-jananya Jiijajju marrkurnu, “Mirtanyurra kuwarri parra wajanma!, ngayurna Kurayijpa Mamamili kaja.” ");
INSERT INTO mpj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Palunyajanu palunyakurnu wangka-nintikajangka-jananya Jiijajju wajarnu, “Ngayurna-nyurrampa puntu yarnngaku marlpa. Ngularniya ngayu tawun Jarujalumungka pungku miturntalku. Tawunja jiingka-jananyaya maajakajalukamu yatilykajalukamu, Muujajmili wangkapurlukakajalu wajalku kujupakajangka ngayurniya yungkalkura miturntalkura. Jiikajalurniya miturntalku, ka karrpu kujarrangkarna mitu ngarriku, karna wankarriku pakalku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ka palunyajanu Piijalu winirnu kara wajarnu, “Paki, wankan wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Palunyajanu-jananya Jiijajju pijurringu nyangu, wangka-nintikajangka karlkinja, kalu Piijangkawiyaju wajanu, “Paki, jurrarni ngayu! Mayitpi malpuku maajalunta wajarninpa. Mirtarna malpumili wangka kulini, paki. Ka Mamalu kulini ngayurniya martu walykukajalu pungkuraku miturntalku.” ");
INSERT INTO mpj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Palunyajanu-janampa Jiijajpa mirrangu yarnnga kujupaku, martukajakukamu palunyamili wangka-nintikajaku, kujungkarriraya. Ka wajarnu-janampa, “Yiipinyurra martulu kulini ngayuku nyinakuraku, mirtanyurra kulilkuraku manikukamu wartaku, ngayukuwiyajunyurra nyinaku. Mayitpi Mamakuraya parlanypa, yiipi palukajaluntaya pungku, wulunyurra ngayuku nyinaku. ");
INSERT INTO mpj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yiipinyurra palukajangkamarra ngurlurriku, ka ngayurninyurra junku yanku, mirtanyurra Mamamili ngurrangka nyinaku. Yiipinyurra palukajangkamarra mirta ngurlurriku, ka ngayukujunyurra junga nyinaku, kanyurra ngayumili wangka parra wajalku, palujanu wulunyurra wanka nyinaku, Mamamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ngangkulaya! Yiipirninyurra ngayu junku yanku, ka mankunyurra mani majukamu warta majukamu maya yarnnga, mirtanyurra wanka wulu pukurlpa nyinaku Mamamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kuwarriya martukaja walyku nyininpa mirtaya kulirnin Mama ngarnawarrapurluka. Wuluraya parlanypa nyinani. Jiikajalu-jananyaya ngayumili walyjakaja muunpungkuninpa pakiwanaya nyinaraku. Yiipi ngayumili walyjalu-jananya kulilku, ka ngayurni junku yanku, pukurlparnilu, palujanu ngularna palu ngayulu pukurlparnilu kuutja junku yanku, mirta ngayumili ngurrangka wanka nyinaku, paki. Yiltarna ngayu marlakurriku ngayumili wikarrukajawinti, karna-nyurranya kuutja wajalku.” ");
INSERT INTO mpj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jiijajju-jananya wajarnu palunyakurnungka wangka-nintikajangka, “Ngulampa Mamalu-jananya ngampurrju kanyinmal palunyakurnu puntu walyja. Wangka ngaanyaya kulila! Karlkinyurra wanka nyinaku ka-jananyanyurra nyaku kujupakaja Mamamili walyjakajaya, yarnnga nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Palujanu wiiki kujungka Jiijajju-jananya kangu Piija, Jayimijpa Jaanpa yapukarti. Kaya yapungka takarnu palukajawiyaju. Kaya palukajalu nyakupayi Jiijajpa yarnangu kujupayururringu, ");
INSERT INTO mpj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ka palumili kuluju piirlpiirlarringu, mirta kalyujanuyuru, kuralypungkunyjajanuyuru, paki. ");
INSERT INTO mpj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kayilapapula Muujajkamu Yilayija yutirringulupula, kaya wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Palujanu Piijalulu wangkangu Jiijajja, “Nintipuka! Kunyjunyula ngaangka nyinani. Purikajalaju-nyurrampa ngapilku, puri kuju nyuntuku, ka puri kujura Muujajku, ka puri kujura Yilayijaku.” ");
INSERT INTO mpj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kuurti nyakunyjalu ngurlurringu, kayila palunya wangkangu. Kujarra kujupapula ngurlurringu wituka. ");
INSERT INTO mpj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Palunyajanu yurnturrju-jananya purijunu ngarnawarralu. Yurnturrpa palu rantalpayi. Yurnturrjanu wangkangu jilanya, “Ngaanyaju ngayuku kaja. Pukurlparnara nyinani. Palumili wangkanyurra kulilkura.” ");
INSERT INTO mpj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Palunyajanuya wangka-nintikajalu Jiijajwiyaju nyangu, ka-pulampaya purtu parra nyangu kujarra kujupaku. ");
INSERT INTO mpj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jampaya marlaku yankupayi yapujanunga Jiijajju-jananya kuranjunu jilanya, “Mirta-jananyanyurra kuwarri parra wajala martukajangka!, kuwarrinyurra nyangunyjangka. Ngulawiyajunyurra wajalku, jamparna ngayu mitujanu pakalku, martu yarnngaku marlpa.” ");
INSERT INTO mpj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Palujanuya mirta parra jakurljunkupayi, paki. Ka kulilpayiya rawalu, “Wanyjalpa miturrikuka marlaku wankarriku?” Kulirnuya mirtaraya jungalu japirnu. ");
INSERT INTO mpj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Karaya yumurringu. Palujanu Jiijajku wangka-nintikajaluraya japirnu, “Kaji Yilayijarni kurranyi yanku?, ka Kurayijpa marlarni yanku? Jilanyaya wajalpayi Muujajmili wangkapurlukakajalu.” ");
INSERT INTO mpj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jiijajju-janampa wajarnu, “Yuu, Yilajijayuru yilta pakarnu nyukurni, Jaanpa. Puntu-jananya parra nintirnu, jungaraya nyinaraku, Mamaku. Yiltarna-nyurrampa wajarni. Mirtaya martulu yikurntanu, palunyajanuya kulilparnilu pungu. Martulu julyju mirlimirlingka wakarnu, Mamamili wangka, Yilayija marlakurrinyja. Wangka jilanya yiltarringu. Jaanpaya jii pungu kulilparnilu. Palunyayururniya ngayu pungku, kulilparnilu. Mamakurnu wangka nyininpa ngayurniya pungku wituka. Wangkayila palunya yiltarriku.” ");
INSERT INTO mpj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yapujanuya tipukanu Jiijajkamu wangka-ninti yupalpa. Yanu-jananyaya nyangu wangka-nintikaja kujupakajakamu martu yarnngakaja. Jii Jiijajmili wangka-nintikajalukamu Muujajmili wangkapurlukakajalu-ngkuya warrkilpayi. ");
INSERT INTO mpj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Karlkiluya nyangu Jiijajpa. Kaluya yarnnga pukurlarrira pinirringurni japilkija. ");
INSERT INTO mpj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jiijajpa-jananya yanu palumili walyjakajaku wangka-nintikajaku, ngarangu ka-jananya japirnu, “Nyakungkunyurra warrkini?” ");
INSERT INTO mpj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yirna kujulura wajarnu Jiijajku, “Kulila! Kajarna katingurni nyuntukarti pampulkuran, maparnjun kunyjunyunkura. Kajaju malpukurlu nyinin, mirtaju wangkinpa. ");
INSERT INTO mpj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jampa malpulu pajarni palunyangka punkara tititipungkula ngarripayi. Palujanu yirra pakarni ka jangalurrju pakarni. Purturna-jananya japirnu nyuntuku wangka-nintikaja, ngumparaluraya wiyalkura, malpu. Purtuya yajirnu.” ");
INSERT INTO mpj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jiijajju-janampa wajarnu laltuku, “Kuwarrilunyurra ngayumili wangka kulira juninpa, laltulu ngurra kujupa kujupajanululurrju. Rawalurnantaya nintijunkupayi, ngurra kujupawanalurrju, palujanunyurra ninti nyinangara. Ngana tayimunyurra kulilku? Murtilyarni jiinya katirni!” ");
INSERT INTO mpj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Murtilya palunya manu katingu ngarajunu ngamu, Jiijajjaluya. Malpulu nyangu Jiijajpa kayila murtilya pajarnu ka karurringu, kayilapa punkarnu kutikutiyanu. Palunyangkalu janga pakarnu yirrawana kayila ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jiijajjulu japirnu murtilyamilingka mamangka, “Kaji kuwarriwiyaju karurringu? Kaji julyju karurrira punkalpayi?” Mamalulu wajarnu, “Jiinga ngarnta jiji japujanu karurrira ka punkalpayi. ");
INSERT INTO mpj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kalyukarti warukarti wululungulyu wirrupungkupayi malpulu, pungkula miturntankuraku. Kajiran ninti malpuluran ngumpara wiyalkura? Kaji nyarrurrikujun ngumparajun wiyalkura?” ");
INSERT INTO mpj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jiijajjulu wajarnu, “Ngayungarni kulila!, maparnpa majurna nyinin. Yiipirnin kulilku ngayu maparnkurlu, pukurlarrikun. Ngayulurnangku wankalku murtilya, karna ngumpalku wiyalku malpu.” ");
INSERT INTO mpj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Palunyaku tati yulakijarringu wajarnulu Jiijajja, “Nyamurnanta kulirni, nyuntungan maparnpa maju. Wulurni nintijula!, wulurnanta kulilkura.” ");
INSERT INTO mpj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ngalyaya pinirringu ngamurringu laltu martu kujupakaja. Palunyangka Jiijajju walalu malpu ngumpalkuraku malpungkalu jilanya wajarnu, “Nyuntulun putamanu murtilya ngaa, mirta wangkinpa, ka mirta kulirnilurrju. Murtilya jii jurra ka yarra!, mirtan marlakurri!, wululura yarra!” ");
INSERT INTO mpj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Murtilya pajarnu karurnu, kayila murtilya mirrangu ka punkarnu. Palunyangkalura malpu pinirringu, kayila mituyuru ngarripayi. Nyakulaya karlkilu wajarnu, “Jiinga murtilyanga miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jiijajju murtilya palunya winirnu ngarajunu kunyjunyu. ");
INSERT INTO mpj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jiijajmapuya wangka-nintilurrju yanuya mayakarti, jarrpangu nyinapayi. Wangkanintiluraya wajarnu, “Jiilajura malpu purtu payilpayi. Nganajanulaju?” ");
INSERT INTO mpj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jiijajju-jananya wajarnu, “Jiinga malpunyurra purtu payilpayi, mirtaranyurra Mamangkalunyurra wangkangu. Mamanyurra japira ka payira wiyalngara.” ");
INSERT INTO mpj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Palunyajanu Jiijajmaluya yanuya ngurra kujupawana Kaliliyawana, tawunkajangka yitingka, martu yarnngangkamarra. Wangkanintikajawiyaju-jananya katingu, ");
INSERT INTO mpj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nintijunkura-jananya wangka. Ka-janampa wajarnu, “Martu kujulurni wajalku yungku, ngayurniya pungkukija, mitu. Ngayurna-nyurrampa puntu yarnngaku marlpa. Miturrikurna karna palunyajanu marlaku wankarriku, munga kujarrangka.” ");
INSERT INTO mpj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Palunyakurnu wangka-nintikajaluya purtu kulirnu. Mirtaluya Jiijajja japirnu, kurntarringuya junu. ");
INSERT INTO mpj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yanuya jarrpangu tawun Kapaniyamungka, Jiijajkamu palukurnu wangka-nintikajalurrju. Yanuya mayakutu kaya jarrpangu nyinapayi. Palunyajanu Jiijajju-jananya japirnu wangka-nintikaja, “Nganajanulungkunyurra wajalkatipayi marlakarti?” ");
INSERT INTO mpj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kaya kurntarrira kurnurringu wanarnu, wangka jilanyaya wajanyjajanu, “Ngana-lampa maaja kujupa nyinaku?, Jiijajkamupula nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Palunyangka-jananya Jiijajju nyinanyjanju palunyakurnu wangka-nintikaja mirrangu wajarnu, “Maajayurungulyu-nyurrampa jiinga nyinaku wangka-ninti. Mirta marninymarninypa nyinaku, warrkamurrimalpa-nyurrampa.” ");
INSERT INTO mpj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jiijajjura mirrangu jiji japuwartaku. Ka ngarajunu kutungka. Ka yampurnu ka-jananya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jiji ngaayururna-jananya ngayulu ngampurrju kanyirni, karna-janampa pukurlarrinpa. Yiipiranyurra jijikajaku pukurlarriku, kajunyurra ngayukulurrju pukurlarriku. Ka yiipijunyurra ngayuku pukurlarrinpa, ka Mamakulurrjuranyurra pukurlarrinpa. Mama jiilurni parnakarti kurtingu.” ");
INSERT INTO mpj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jaanjulu wajarnu Jiijajja wangka kujupa, “Nintipuka! Nyangulaju puntu kujupa kuwarri, malpu payirnu yiyarnu, nyuntukurnu yiningka. Kalaju marrkurnu, mirta payira yiyalkura. Mirta-lanya parra wanalpayi, ngayunja, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jiijajjulu wajarnu Jaanja, “Mirtanyurra marrkula!, puntu palunya, jurraya! Ngayukurnu yiningka payirnu yiyarnu, ngayukuju mirta parlanypa nyininpa, kunyjunyu, mirtarni ngayungka jankaku. ");
INSERT INTO mpj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Martu-lampa parlanyparni nyininpa, ka kunyjunyu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jiijajju-jananya yarranuka wajarnu, “Wangka ngaanyaya kulila! Martu kujulu-nyurranya yungku, kalyu jikilkuraku, ngayukurnu puntu walyja. Palunyangka ngayukurnu Mamalu rawalu kulinmal, kara wituka yungku, ngulampa.” ");
INSERT INTO mpj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jiijajju-jananya wajarnu, “Ngayumili walyjakajaluya walykukaja ngapini. Yiipiya jilanya ngapini, mirtajuya junga nyinani. Yiipi martu kujupalu muunpungku ngayumili walyjakaja walyku ngapilkuraku, kayilapa Mamalu warrkilku pungku. Martu palunya Mamalu warrkira pungkujakungkamarra, jumaji ngayumili walyja muunpungu, martu karlkinjuya palu manku ngalyingka tayimapulku yapu majuwintilu, kaya kalyungka warningku. Yilta martu palunyayuru muunpungkupayi, Mamalu pungku.” ");
INSERT INTO mpj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Jiijajju-janampa yarrarnu wangka yumuwanpa wajarnu kulilkuraya nintirriraku, “Ngayumili walyjalu mara kujarrawintilu ngulyulu mankuraku kulilku. Palujanu palulungku mara kujukarti katupungku ngulyungkamarra, warukartilurrju kujarrawinti yankujakungkamarra. Kayilapa kunyjunyu nyinaku mara kujukarti. Waru jii wulu kampamalpa. ");
INSERT INTO mpj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Wangka palunyayuru jilanya. Yiipi ngayumili walyjalu kulilku jinawintilu yankura ngulyulu mankuraku. Palujanu palulungku jina kujukarti katupungku ngulyungkamarra, warukartilurrju kujarrawinti yankujakungkamarra. Kayilapa kunyjunyu nyinaku jina kujukarti. ");
INSERT INTO mpj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yiipi ngayumili walyjalu kuruwintilu nyaku nyupa kujupangka, ka kulilku ngulyulu mankuraku, ka palulungku kuru wakala walykula!, nyakujakungkamarra, warukartilurrju yankujakungkamarra, kuru kujarrawinti. Kayilapa kunyjunyu nyinaku kuru kujuwinti. ");
INSERT INTO mpj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Waru nyarra wulu nyininpa wiyarriparni, wulu kampinpa. Jiingka warungka-jananyaya lunkiyurulu ngalkula wiyamamalpa. ");
INSERT INTO mpj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngayumili puntu walyja martu putalu muunpungku, ka Mamalu ngulampa warrkilku yiyalku. Puntu palunyayuru mirta nyinaku ngayukurnuwana.” ");
INSERT INTO mpj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jiijajju-jananya wangka yumuwanpa wajarnu, “Juulujanu kuka kunyjunyurrinpa. Juulu palunya kunyjunyu. Juulu rawa ngarrinyjanpa yarlkawana putarriku. Juulu puta minyjilarriku. Juulu kunyjunyuyurunyurra nyininpa, ngayuku puntu walyja. Karlkinju-nyurranyaya kunyjunyu nyaku ka-nyurranyaya kujungkarriku nyuntunja, karninyurra Jiijajpa wanalku. Juulu kunyjunyuyurunyurra nyinaku, kujungkarrira wulu.” ");
INSERT INTO mpj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Palunyajanuya Jiijajkamu wangka-nintikaja kujungkaya yanu parna kujupakutu, Juutiyakutu. Yanurranpaya karru Juutunja. Ka-jananyaya martu yarnngakuyarra kujungkarringu ka wanarnu Jiijajmalungka. Ka-jananya puntu yarnnga nintijunkupayi. Jilanyangulyu-jananya nintijunkupayi, ");
INSERT INTO mpj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Palujanu Parajikajaluraya yanu Jiijajpa japilkuraku. Jilanyaya kulilpayi, “Yiipi Jiijajju pakiwana wajalku ngulala kuutja wajalku.” Jiijajparaya jilanya japirnu, “Kaji, Muujajmili wangka jilanya nyininpa?, Yirnalungku wanti kanyilkuka parlanyarrikuka kurtingku?” ");
INSERT INTO mpj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jiijajju-jananya puntajilu japirnu, “Ngana-janampa julyju wajarnu Muujajju, nyupararrapula nyinara?” ");
INSERT INTO mpj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wajarnuluya, “Muujajju-janampa wajarnu palyaya yiyalkuraku nyupa walyja, mirlimirlingka wakanyjalunga. Kala palya mirlimirliwinti yiyalku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka Jiijajju-janampa wajarnu, “Mitunyjarrikajaya purtu kulilpa nyinapayi. Palujanu Muujajju-janampa wangka palu wakarnu, nyupanyurra kurtingkuraku. Yiltanyurra palukajayuru purtu kulilpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Julyju Mama ngarnawarrapurlukalu-pulanya nyupararra nyinajunu, palujanu mirtaya nyupakaja kurtingkupayi. Jilanya Mamamili wangka julyjujanu nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Palujanupula yirnakamu wanti nyupararra nyininpa jaalpu, mirtalupula mamingkakamu mamangka nyininpa, wulupula jaalpu nyinamalpa. Ngurra kujungkapula nyininpa, jungapula nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mamalu-pulanya jilanya nyinajunu, mirta-pulanya martu kujupalu wajalku jaalpupula nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jiijajmaluya yanu jarrpangu mayangka nyinapayi. Palungkaluya japirnu palunyakurnu wangka-nintikajalu, palunya wangka. ");
INSERT INTO mpj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jiijajju-jananya wajarnu, “Nyupararrapula nyinanyjanju mirta nyupangku yiyala!, kujupa mankukijalu. Jampangku nyupa yiyalku, jilanyalunga Mamamili luwu warlangkuni. ");
INSERT INTO mpj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wantilu yirna junku yanku, ka manku yirna kujupa, jilanyalunga Mamamili luwu warlangkuni.” ");
INSERT INTO mpj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Palujanuya martukajalu jijikaja katipayi Jiijajkarti, yampulkuraku. Kulilpayiya martukajalu “Jiijajju-jananya julyju yampulpayi, kalu Mamangka wangkapayi, jijikaja-jananya ngampurrju kanyilkura.” Kayilapa-jananyaya martukaja marrkulpayi, Jiijajmili wangka-nintikajalu, “Mirtaya-jananya jijikaja kangkurakurni!” ");
INSERT INTO mpj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka-janampa Jiijajpa wirrilyirringu palumili wangka-nintikajaku, Ka-jananya marrkurnu, “Jurra-jananyaya!, kangkurakurniya jijikaja ngayukutu. Jiji ngaakajayuru Mamalu-jananya ngampurrju kanyini, palumili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Wangka ngaanyaya kulila! Mamalu-jananya ngampurr kanyirni, palunyakurnu puntu walyja. Jijiluya wangka kujupamili kulini, mirta ngangkura junkuni, paki. Palujanunyurra martukajalu ngayumilikamu Mamamili wangka kulinmalpa jii jijiyurulu, mirtanyurra ngangkura junkumalpa, paki. Palujanunyurra Mamamili walyjakaja kujungka nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Palunyajanu-jananya Jiijajju yampurnu jijikaja, kalu wangkapayi Mamangka. ");
INSERT INTO mpj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jiijajkamu wangka-nintikajaya yankukija, ngurra kujupakutu. Ka puntu kujupalu pinirringu Jiijajkutu. Ka pupatingu kalu japirnu, “Nintipuka! Kunyjunyun nyuntu. Wanyjalarrikurna wankarna nyinakija, wulu?” ");
INSERT INTO mpj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jiijajjura japirnu, “Nganakurnin japirnu palunya wangka, kunyjunyurna ngayu?, Mama ngarnawarrapurlukawiyaju kunyjunyu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jiijajjulu wajarnu, “Nyuntun junga nyinaku wangka ngaakajaku. Martulun mirta pungku martu kujupa mitu. Martuluran mirta yirna kujupaku wanti kangku. Martu kujupakuran mirta manku ngulyulu. Martu kujupangkalun mirta paki kajalku. Mamakukamu yakurtikuran kunyjunyu nyinama!, mirta-pulanyan nganarnpuwa!” ");
INSERT INTO mpj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Puntu palunyalu Jiijajja wajarnu, “Wangka palunyakajaku jungarna-janampa nyinapayi. Warrinyjirna junga nyinangu, kuwarrirna wulu junga nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jiijajjura nyarrurringura wajarnu, “Nyuntu jungaminyirri nyinaku ngaakajan jilanya ngapilku. Wartakajakamun maya jalamunku, kayilapan mani manku, ka-jananyan kangku yungku nyarrukaja. Nyuntun maniparni nyinaku, palujanu jungajun nyinaku. Palujanunta Mamalu ngula ngurrangka ngampurrju kanyilku, wanka wulu nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ka puntu palulu purtu kulirnu, mirta jalamulkijalu wartakamu maya. Wirla walykurringu, ka yanu. ");
INSERT INTO mpj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jiijajju-janampa wajarnu, palumili wangka-nintikajaku, “Mamalu-jananya ngampurrju kanyilku palumili walyjakaja. Kaya warta majukajawintilu purtuya kulilku wartakajaya junku yankuraku, kayilapaya Mamamili walyjakajangka nyinakuraku, palumili ngurrangka, mirtaya jiingka kurrungku wartakajawinti.” ");
INSERT INTO mpj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wangkanintikajaluya purtu kulirnu wangka jiiku, warta majukajaku. Wiyawanaluya kulilpayi, “Mamalura wartakaja maju yungu, jiijanura pukurlpara nyininpa. Yiltaya warta majuwintikajaya Mamamilingka puntu walyjangka nyinaku.” Jiijajju-jananya wajarnu, “Wangkanintikaja, kulilarniya! Mamamili puntu walyjakajaya nyinaku. Warta majukajawintiluya purtu kulilku, kujungkarrikuraya nyinaraku, jumajiya wartakajaku pukurlpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamalpa purtu kurrungku niitulja tapurrja, paki. Paluyuru wartawintikajaya purtu kurrungku mamamili ngurrangka, jumajiya mikurrini wartakamu maniku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wangkanintikajaluya jilanya pakiwana kulilpayi, “Mamalu-jananya wartakajakamu mani yungu wartakajawinti, palujanu Mamalu-jananya kangku ngampurrju kanyilku palumili ngurrangka.” Palujanu jilanya-ngkuya japirnu wangka-nintikajalu, “Ngana kujupa wanka wulu nyinaku Mamamili ngurrangka? Wajarnu-lanya wartakajawintiya mirta nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jiijajju-jananya nyangu, ka wajarnu, “Martulu purtu kulilku Mamamili walyjakajangka-jananya nyinakura. Mamaluwiyaju kuliraka kangku nyinajunku palumili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piijalu Jiijajja wajarnu, “Ngayurtinjulaju wartakamu mayalurrju, ka martu walyjakajalurrju junu yanu. Kalajunta nyuntungka kujungkarringu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jiijajju-janampa yarrarnu wajarnu palumili wangka-nintikajaku, “Yiipinyurra junu yanu ngurrakajakamu martu walyjakaja, kayilapanyurra junga ngayuku nyinaku. Ngulanga Mamaluntaya puntajilu yungku. Puntu kujulu ngurra, puntu walyjakaja, mayalurrju junku, ka ngayukuju junga nyinaku, palunyangkara Mamalu yungku puntu walyjakaja kujupa, ngurra nyinaraku. Mayiti walyja jiiyuru junku, kurta, yakurti, mama, marlangu, jijilurrju. Jiikajayuru junku ka ngayuku warrkamu palyalku. Yiipi martu ngayuku junga nyinaku, palya, mayiti karlkiluya warrkira pungku, Mamaku parlanyparaya. Jiijanu ngula wanka wulu nyinaku, martu palunya. ");
INSERT INTO mpj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Parnangkaya kuwarri maajakaja nyininpa, ngula ngurra palungkaya warrkamupurluka nyinaku. Ka kujupakajaya kuwarri warrkamupurlukakaja nyininpa, ngulaya ngurra palungka maajakaja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Palunyajanuya Jiijajmapuya tawunkarti Jarujalumukarti yanu. Palumili wangka-nintikajaya marlakarti yanu, ngurlurringkupayiya. Marlawanaya laltu kujupa yankupayi, ngurlurripayiya. Jiijajpa-janampa palumili wangka-nintikajaku mirrangu ka katingu-jananya martu laltungkamarra. Wangkangu-jananya jilanya, ");
INSERT INTO mpj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ka-jananya wajarnu, “Ngangkulaya! Wulikajala yaninpa Jarujalumkarti, ka ngurra palungkarniya manku, martu yarnngaku marlpa, karniya kangku Yatilyparakukartikamu Muujajmili wangkapurlukakajakarti. Jiikajalurniya kangku kuutja yikijunku, ka wajalkurniya miturntalkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Palujanurniya kangku Juwuparnikajakarti. Jiikajalurniya nyurnimanku, karniya wiipuwintilu pungku. Palujanurniya wiltijunku, karna miturriku. Palujanurna mitu ngarriku karrpu kujarrangka, karna wankarriku pakalku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Palunyangkapula Jayimijjukamu Jaanju yanu Jiijajkarti japirnu, kurtararralu, “Nintipuka! Kulirninpaliju japilkijalijunta. Yiipi ngayululijunta japilku, palyan jilanya palyalku?” ");
INSERT INTO mpj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jiijajju-pulanya puntajilu japirnu, “Nganapulan kulirni? Wanyjalmalkurnangkupula?” ");
INSERT INTO mpj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wajarnupula jilanya, “Nyuntun ngula maaja maju nyinaku. Kajila maaja maju yupalpa nyinaku? Kuwarri-linyajun jamartapungku, maajaliju nyinara.” ");
INSERT INTO mpj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jiijajju-pulanya wajarnu, “Kuwarrirniya warrkiraka pungku. Kujungka-lanyaya warrkiraka pungku? Jilanyapulan kulini?” ");
INSERT INTO mpj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kapula palu kujarralu wajarnu, “Yuwa, paluwanaliju kulini.” Jiijajju-pulanya wajarnu, “Yiltantapulaya kujupakajalu warrkiraka pungku. ");
INSERT INTO mpj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ka Mamaluwiyaju wajalku ngayungkarni maaja kujupa nyinakurakurni, mirtarna ngayulu wajalku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ka Jiijajmili wangka-nintikajaluya kulirnu, kaya Jayimijkukamu Jaanku wirrilyirringu-pulampaya, jumajipula maaja nyinakijalu. ");
INSERT INTO mpj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Palujanu Jiijajpa-janampa mirrangu ngamurriraya kulilkuraku. Ka-janampa wajarnu, “Ngangkulaya! Juwuparnikajaya yarnnga maaja-janampaya wiltu nyinani. Wirrilyilu-jananyaya kanyini. Jilanyakunyurra ninti nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Kayilapanyurra mirta maaja paluyuru nyinakura. Yiipin kujulu kulini maaja nyinakura, nyuntulu-janampan warrkamu ngapilkura jiikajaku. ");
INSERT INTO mpj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngayurna martuku yarnngaku marlpa yanurni warrkamurna-ngkuya martu wulikajaku ngapilkura. Jilanyarnara warrkamu Mamaku ngapilku, karna miturriku martuya yarnnga wankarriraku. Mirtarna yanu ngaa parnakarti martukajalujuya warrkamu ngapilkura, maaja majuku, paki.” ");
INSERT INTO mpj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yanuya tawunkutu Jirikukutu jarrpanguya nyinapayi, Jiijajmapu. Palujanuya ngurra kujupakartiya yankupayi martukajalurrju. Yanuya tawunja yawujayiti nyangu puntu pampuru ruutungka nyinapayi, yini Patamiyajpa, Timiyajaku kaja nyinapayi. Maniku-jananya japilpayi martukaja. ");
INSERT INTO mpj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jiijajpa Najarajamartaji wati yanu wangkayila kulirnu pampurulu. Ka wiltu mirrangu Jiijajku, “Jiijajpawu! Nyuntun Tayipitmili marlajanu! Yarrarni nyarrurriju!” ");
INSERT INTO mpj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaya martukaja kurranyiya yankupayi, jiikajaluya marrkurnu, “Yaka nyina!” Palujanu wulura wiltu mirrapayi. “Nyuntun Tayipitmili marlajanu! Yarrarni nyarrurriju!” ");
INSERT INTO mpj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jiijajju kulirnu ka yikingu wajarnu, “Mirrara ngalyarnirni yankuraku!” Pampuruku palunyakuraya mirrangu. Wajarnuluya, “Pakala pukurlpa!, mirraninpangku.” ");
INSERT INTO mpj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Palunyajanu kuurtungku tikamaturnu wirrupungu, ka wala yanu Jiijajkarti. ");
INSERT INTO mpj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jiijajjura japirnu, “Nyaakuran mirrangu? Nganarnangku ngapilku?” Wajarnulu, “Maaja, kururni pampula!” ");
INSERT INTO mpj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jiijajjura wajarnu, “Nyamu, yanama!, ngayurnin maparnpa kulirnu, maju. Palunyajanun kurun palyarringu.” Yilta, kuru palyarringu Jiijajja kujungkalu yanu, pukurlpa. ");
INSERT INTO mpj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jiijajjukamu wangka-nintikajaluya kulinu, tawun Jarujalumukarti yankukija. Yanuya tawun Piijpayijwanakamu Piijaniyawana. Kaya purlingka Jarujalumja ngamu nyinapayi. Purli palunga yini Yalipajpa. Ka-pulampa Jiijajju palumili wangka-ninti kujarraku wajarnu, kurtingkuraku-pulanya, “Yarrapula tawun jiikutu! Nyakuyilapulan tangki yangupala yikini, ruuppawinti yikini. Ngurrpara palunya puntuku. Mirta puntuku tatilkuraku, ngurrpara. Kurtiwapula jii!, kayilanpula marlakurni katiku, ngaakarti. ");
INSERT INTO mpj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mayitpintapula martulu kujupalu jiimartajilu japilku, ‘Nyaakupulan ruupu tikamaturni?’ Ka-jananyanpula jilanya wajalku, ‘Maajalu ngangkuni takalkurakulu, ka kangkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Palunyangkapula yanu nyangupula mayangka tuwu ngka kinti, ngarapayi tangki, ruupkurlu. Tangkingkalupula ruupu tikamatunu. ");
INSERT INTO mpj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tangkikuraya maajaparakulu japirnu-pulanyaya, “Nganakijalupulan tangki tikamatuni?” ");
INSERT INTO mpj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wajarnu-jananyapula Jiijajju wangka kurranyi wajanyjangka. Palunyangka-pulanyaya kurranyi wajarnu wiyarnu, puntu karlkinju. ");
INSERT INTO mpj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Katingupula Jiijajkarti yungulupula tangki. Wangkaninti kujarralungkupula kuurtu tikamatunu, kalupula murrpungka purlpujunulupula. Ka Jiijajpa tatirnulu nyinatingu murrpungka. ");
INSERT INTO mpj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ka ruutungkaya martu yarnnga yankupayi kujungka. Karlkin kujupaluya kuurtukaja tikamatura junkupayi tangkilu jinalu kantulkuraku. Ka karlkin kujupaluya wartakaja parrkakaja warlangkupayi ka ruutungkaya junkupayi, tangkilu kantulkuraku. (Jilanyaluya Juwukajalu yarnngalu murrarni junkutinpa maajalu majulu tangki katiraku, Juwukajalu yarnngalu. Jilanyaya junkutinpa maaja majukuwiyaju.) ");
INSERT INTO mpj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Martukajaluya Jiijajja kurranyilu mirrara marninypungkupayi, kaya karlkin kujupalu Jiijajja marlakarti marninypungkupayi. Jilanyaya wiltulu marninypungkupayi martukajalu jiikajalu, “Maaja majuwarta ngaanya. Marninypungkuwala ngaa Tayipitku marlajanu! Yilta ngaanya Mamamili. Mamala marninypungkura!” ");
INSERT INTO mpj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yarrarnuya wiltulu marninypungkupayi jilanya, “Ngaanya ngarnawarrajanu, Kurayijpa. Kuwarri-lanya ngampurrju kanyilku maajalu, maaja Tayipityurulu. Julyju-jananya palyalu ngampurrju kanyilpayi. Jiiyurulu-lanya kuwarri kanyilku palyalu. Palunyangka Mama ngarnawarrapurlukala marninypunginpala.” ");
INSERT INTO mpj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jiijajpa tangkikurlu yankupayi Jarujalumungka kutungka tiputingu, Juwukurnu jaajji majungka. Yanu jarrpangu, kaninykurtiwanalu nyakutipayi. Rukarrinyjangkaya marlaku yanu ngurrakarti, tawun Piijaniyakarti, wangka-nintikurlujarra. ");
INSERT INTO mpj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mungajarrarrinyjangkaya ngarringu yungun pakarnu. Jiijajmapuya yanu wangka-nintiparakuya kaya yankupayi Jarujalumukarti, wanyu wulu. Jiijajpa yanu kalyparturringu. ");
INSERT INTO mpj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ruutungka yirrirri nyangu warta. Yanura mirrkaku purtu nyangu, parrkawiyaju ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wartangkalu wajarnu, “Puntulunta mirta ngalku.” Jilanyalu warta jii putamanu palunyalu, ka wangka-nintiluya kulirnu. ");
INSERT INTO mpj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yanuya Jiijajmapu wangka-nintiparaku Jarujalumungkaya jarrpangu. Kayilapa Jiijajpa yanu Juwumilingka jaaji majungka kurrungu. Jiijajju-jananya nyangu turrukajaya maapu jalamunkupayi. Karlkin kujupaluya turrukaja payamunkupayi yatilykaja yungkuraku. Jiijajpa-janampa wirrilyirringu ka-jananya warrkinu kurtingu. Kayilapa-janampa tiipulkaja manu warningu, turrupurlukakajakukamu manipurlukakajaku. Nyinapintikajalurrju-janampa manu warningu. ");
INSERT INTO mpj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wartapurlukakaja ngumparnu-jananya wiyarnu, Jiijajju. ");
INSERT INTO mpj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jiijajju-jananya payirnu jilanya, “Mamamili jaaji ngaanya mirtanyurra jalamunma kuwiyikaja ngaangka! Mirtanyurra ngulyunyjumapu ngaangka kumpilkura, maajakajalunyurrunyaya mankujakungkamarra, paki. Mamamili wangka julyjujanu nyininpa jilanya, ‘Ngaanga ngayumili jaaji, ngayurninyurra marninypungkuraku, martu yarnngalu.’” ");
INSERT INTO mpj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jiijajju-janampa muntarnu wirrupungu, jakurlpaya kulirnukaya wirrilyirringu, Yatilyparaku, Muujajmili wangkapurlukakajalurrju. Kulirnuya junu ngulaya mituya pungkukijalu, Jiijajpa. Purtuya kulirnukaya marrkurnu-ngkuya palunyanju, “Junkurala, mirtala kuwarri pungkura, palunyalu-lanyaya pungkujaku, martulu yarnngalu. Kulirninpaya pakiwana jilanya, ‘Jiijajpa palya-lampa wangkinpa, Mamakurnu kaja.’” Ngurluya nyinapayi yarnngakuyarrangkamarra, pungkujaku-jananyaya. ");
INSERT INTO mpj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rukarrinyjangkaya Jarujalumu junu yanu Jiijajmapu, wangka-nintilurrjuya. Ruutuwanaya yanu ngarringu kutungka, mungajarrarrinyjangka. ");
INSERT INTO mpj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngarringuya yungun pakarnu ka marlakuya yanu. Kaya warta palunya nyangu tikirlarringu. Jiijajju warta jiinya putamanu, karrpu kujupangkalu. ");
INSERT INTO mpj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piijalu kulirnu wajarnulu, Jiijajja, “Nintipuka! Jii warta nyawa!, tikirlarrinyja. Nyuntulun putamanyjangka palunyangka warta tikirlarringu.” ");
INSERT INTO mpj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jiijajju-jananya wajarnu, “Mamanyurra kulilkura. ");
INSERT INTO mpj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wangka ngaanyaya kulila! Yiipinyurra purlingka jiingka wajalku, kalyukarti pakara yankuraku. Ka purlilu palunyalu puntuyurulu kulilkuka pakalku yanku parrayinku, ka kalyungka jarrpaku. ");
INSERT INTO mpj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Palunyayuru Mamangkalunyurra japilkura. Yiipinyurra japilku Mamangka. Kulilkuranyurra japilkijalunga jilanya, ‘Mamalurni yilta yungku.’ Palunyayurulu puntulu japinyjangka Mamalu kulilkuka yungku.” ");
INSERT INTO mpj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Jiijajju-janampa yarrarnu wajarnu, wangka kujupa, “Mamangkalu japilkijalu kulila ka majala! Mayitpi puntu kujupakuran wirrilyi nyinin, jumajinta julyju warrkirnu, mayitpinta pungu. Kara palunyaku pungkunyjajanuku wangkara kawalyarrira. Palunyajanulu Mamangka japila! Palunyangka Mamalungku putakaja wirrupungku, kawalyangku nyinaku. Yiltalunta yungku japinyjajanu.” ");
INSERT INTO mpj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jarujalumungkaya yanu jarrpangu Jiijajmapu. Yanuya jarrpangu yankupayiya Juwukurnu jaajja majungka, kaninyjarrawana. Jiijajkamu wangka-nintikaja yanu-ngkuya kulurnu Yatilyparakukamu Muujajmili wangkapurlukakajakamu yirnaparaku. ");
INSERT INTO mpj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jiijajkuraya wirrilyirringu karaya japirnu kujungkarringuka, “Maaja nganalunta wajarnu?, martukaja-jananyan nintilkuraku, kamu wankalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jiijajju-janampa wajarnu, “Kurlurnantaya japilkura. Ngayulurnantaya japilku, palujanu mirta-ngkuyan ‘ngurrpa’ wajala! Yiipirninyurra jungalu wajalku, ‘ngurrpa’ wajalparnilu, ngayulurna-nyurranya jungalu wajalku, maajalurni kurtingkura. ");
INSERT INTO mpj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ngangkulaya wangka ngaanya! Jaanju-jananya kalyungka jarrpajunkupayi. Maajalulu nganalu Jaanja wajarnu?, martukaja jarrpajunkuraku, mayitpi Mama ngarnawarrapurlukalu, mayitpi martulu, maajalu?” ");
INSERT INTO mpj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ngangkunukaya yaka wangkapayi-ngkuya jaalpu, jilanya, “Yiipilalu Jiijajja wajalku Mamalulu wajarnu Jaanja, palujanu-lanya Jiijajju wajaljaku, ‘Jaanmili wangkanyurra kulinngara, Mamamili.’ Mirtalalu jilanya wajalku Jiijajja, ‘Mamalulu wajarnu.’ ");
INSERT INTO mpj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yiipilalu Jiijajja wajalku, martulu maajalu Jaanja wajarnu, palujanu martukaja-lampaya wirrilyirriku. Kulirninpaya Jaanpa Mamamili wangka jakurlpurluka. Palujanulalu wajalku ‘ngurrpala’.” ");
INSERT INTO mpj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Palujanuluya Jiijajja wajarnu, “Ngurrpalaju. Maajalu nganalulu wajarnu, Jaanja?” Ka Jiijajju-janampa wajarnu, “Ngayulurrjurna-nyurranya ngurrpa wajarni, mirtarna-nyurranya wajalku maajalurni wajarnu.” ");
INSERT INTO mpj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiijajju-jananya yarrarnu wajarnu, yumuwanpa wangka kulilkurakuya. “Martu maajalu junkura wananmalpa kuripijku wilykikaja. Piinyjikaja junku wanalku tinkijunku. Palujanu maya ngarnawarra ngapilku, nyakupinti, kuripijpaya ngulyulu mankujaku. Piinyjingka jayitingka tapurrpa jawalku junku ngulaku. Tapurrja palungka jinaluya kuripijkaja kantunmalpa, kayilapa karrkartakaja yintinmalpa tapurrkarti. Kayilapa maaja palulu mirraku-janampa martu karlkinku, warrkamurriraya kaya ngampurrju kanyilkura. Palujanu ngurra kujupakarti yanku warrkamurriraku. ");
INSERT INTO mpj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Palujanuya kuripijkaja yurnmirriku. Kayilapa maajalu warrkamupurluka kurtingku, yankura mankuraku kuripijkaja yaapu. Ka-janampa junku yaapu kuripijkaja kaatanmayapurlukakajaku. ");
INSERT INTO mpj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kaatanmaya palunyangkaya martulu yupalju jiimartajilu warrkamupurluka palunya pungku marlaku yiyalku. Kuripijpaya kanyinmalpa yungkuparnilu. ");
INSERT INTO mpj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Maaja palunyalu purtu majalku warrkamupurluka kujupa yiyalku, kuripijpa marlaku mankura katiraku. Palunyajanu yanku jarrpaku, kaya kata pungku yintilku. Ka kata miji yintinmalpa. Payilkuya marlaku wiyalku, kuripijparni. ");
INSERT INTO mpj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Maaja palunyalu warrkamupurluka kujupa wiyalku-jananya kuripijpa mankura marlaku katirarniku. Palunyangkaya mitu pungkuya. Palunyayuru kujunkujunnguru warrkamupurluka-jananya wajara wiyalku, yarnnga. Karlkinpa-jananya mitu pungku, karlkin kujupa-jananya pungkula yiyalku. ");
INSERT INTO mpj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Maajaku ngurrapurlukaya pakirriku, mirtaya nyinaku, palumili ngurrangka, paki. Palunyamili kajawiyaju ngurrangka nyinaku, ka maajalu kulilku jilanya, ‘Mayitiraya ngayumili kajaku nyarrurriku, ka kuripijku-jananya japilku, karaya yungku.’ ");
INSERT INTO mpj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kaya kaatanmayapurlukakajalu nyaku kaya wangkaku, ‘Jiirni yankuni palumili kaja. Jiilu kajalu kanyilku kaatanmayakamu maya ngaanya, yiipi miturriku palumili mama. Mitula pungkura!, kayilapala ngaanya kanyilku kaatanmayakamu maya.’ ");
INSERT INTO mpj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Palujanu kaja palu kaatanmayangka kurrungku. Kayilapaya manku kangku yawujayiti warningku, palujanuya miturntanku. ");
INSERT INTO mpj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kaatanku maajalu yanku-jananya wanyjalmanku? Kaatanmartaji putaparaku-jananya mitu pungku. Karlkin kujupaku-janampa mirraku kaatanpa jungalu kanyilkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Jiijajju-janampa yarrarnu wajarnu, maajakajaluya kulilkuraku. “Mamamili wangkanyurra kulilngara, jilanya nyininpa. ‘Martukajaluya puri ngapilku, kaya warta kujarra narnnguwinti yikijunku. Kayilapaluya warta kujupa wiltu, warlpukurru ngarrijunku ngarnawarra. Kayilapaya nyakuka warta palu wiltu manku warningku, pinyi karalkuya. Mama ngarnawarrapurlukalu warta palu warningunyja mankuka ngapilku puri. Palujanula nyaku puri kunyjunyuminyirri, jiijanu wartajanu.’” Jiijajju-jananya wangka palu wajarnu, maajakajaluya kulilkuraku jilanya, “Jiijajparna nyinani paluyuru warta wiltuyuru. Juwukajalurniya manku kangku miturntanku pinyi karalkurniya.” ");
INSERT INTO mpj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wangka paluya kulirnu, kaya wirrilyirringu Juwumili maajakaja. Kulilpayiya jilanya, “Palulu-lanya wajarnu, ka nganarnpungkuni-lanya. Kuwarrila yanku manku kangku pungku.” Jilanyaya ngangkunuka junu, martukajangkamarra. Kulinuya jilanya, “Martukajalu-lanyaya pungkujaku, jurrala! Martukajaluya kulini, jumaji Jiijajpa Mamamili wangka jakurlpurluka.” ");
INSERT INTO mpj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Palunyajanu-jananyaya Juwumili maajakajalu yiyarnu Jiijajkarti, Parajikajakamu, jaajimili maajakajalurrju. Yanuya jilanya kulilpayi, “Wangka palumilila kulilku ka wajalku kuutja, kuutpurlukangka, Jiijajpaya miturntalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yanuluya Jiijajja wajarnu, “Nintipuka! Kulirninpalajunta nyuntulun jungalu wajani. Mama ngarnawarrapurlukalunta nintini, palujanu-lanyajun nyuntulu jungalu wajarninpa. Mirta-jananyan nyuntulu maajakajangka ngurlurrini, nyuntulu-jananyan wululu Mamamili wangka wajarninpa, yakaparnilu. Kuwarri-lanyaju jungalu wajala!, wanyjalpan nyuntulu kulini? Luwu wanyjalpa-lampa nyininpa? Kajila ngayurtinju kapamanpa maaja maju mani yungkuraku?, yini Tayipiriyajpa? Mayitpi mirtalara yungku kapamanpa.” ");
INSERT INTO mpj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jiijajju kulirnu, “Mayitpi ngaakajalurniya japini, ngularniya kuutja wajalkuraku.” Palujanu-janampa wajarnu, “Mayunyjulurninyurra japini?, pakilurrju. Jilanya japilparnilurniyan junkungara. ");
INSERT INTO mpj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mani jilpa kujula kapamanpa yungkuni. Mani palu jilparniya kawa nintijula!, nyakurakurna.” Jilparaya kangu yungu. Jiijajju-jananya japirnu, “Ngumpa nganamili ngaanya? Yini ngana ngaanya?” Kaluya wajarnu, “Kapamanpa maaja maju, Tayipiriyajpa.” ");
INSERT INTO mpj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka-jananya Jiijajju wajarnu, “Warrkamupurlukaluntaya japilku maniku kapamanku, palujanu yungkuraku-jananyanyurra, kayilaparaya kangku yungku maaja Tayipiriyajpa. Paluyuru yiipi Mamamili warrkamupurlukaluntaya japilku maniku, palujanu-jananyanyurra yungku mani, kayilaparaya kangku junku Mamamili warrkamuku.” Palujanuya Jiijajmili wangka kulirnukaya yakarringu, kaya junu yanu Parajikajakamu, Yirutmili wangkapurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Martu karlkinpaya nyinapayi Jaajmili maajakaja. Jilanyaya kulilpayi pakiwana, “Martuya mirta mitujanu ngula pakalku, paki, wuluya mitu ngarrimalpa.” Jiikajaluya yanu Jiijajpa japirnu, ");
INSERT INTO mpj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nintipuka! Muujajju-lampa julyju jilanya luwu wakarnu. Yiipi kurtalu wanti manku, ka jijiparni nyinaku, palujanu miturriku. Kayilapa palumililu marlangulu manku wanti palunya. Yiipipula jiji manku, kaya martukajalu kulilku, ‘Kurtakura jiinya jiji.’” (Martukajalula mirta jii kulini, ka Juwukajaluya jilanya kulilpayi.) ");
INSERT INTO mpj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kaluya Jiijajja yarrarnu wajarnu, “Jiikajaya kurtararranpa nyinapayi japan wulikaja. Majujaralu manu nyupa kanyilpayi. Jijiparnipula nyinapayi, palujanu yirna palu miturringu. ");
INSERT INTO mpj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka palumili marlangulu wanti jii manu. Nyinapayipula jijiparni kayilapa yirna palu miturringu. Wantiwiyaju wanka nyinapayi. Kayilapa kujupalu marlangulu wanti palu manu. Jijiparnipula nyinangu, kayilapa yirna palu miturringu. ");
INSERT INTO mpj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jilanyayuruya wanti palu kanyirnu marlangukajalu, kaya miturripayi jijiparni. Palujanu wanti palu wanka kuju nyinangu, ka jijiparni miturringu. Palujanu jii wanti miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka Jiijajkuraya yarrarnu japirnu, “Ngulampanga mayitpi martukaja mitujanu wankarriku, kayila wanti palunya mitujanu wankarriku, ka palumili nyupakajalurrju. Palujanu nganakura wanti palu nyinaku? Julyju-jananya japan wulikaja kanyilpayi.” ");
INSERT INTO mpj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka Jiijajju-jananya wajarnu, “Pakiwananyurra kulini. Mamamiliku wangkakunyurra ngurrpa, mirtanyurra kulini Mama ngarnawarrapurlukalu yalyjirrju ngapini, maparn majuwintilu. ");
INSERT INTO mpj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngulaya martukaja mitujanu pakalku, mirtaya nyupawinti nyinaku, paki. Wikarrukajayuruya Mamamili ngurrangka nyinaku, nyupaparni. ");
INSERT INTO mpj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Martu mitujanu yilta wankarriku nyinaku, Mamamili ngurrangka. Jilanya Mamalu wajarnu. Wangka jiiyuru riitamurrira kanyurra kulilngara. Yipurammapuya miturringu julyju, kayilapa Muujajju wangka palunya wakarnu, marlalu jilanya. Warta kampara yikini. Wangka palunyangka kinti nyinani wangka kujupa. Mamalu jilanya wajarnu, ‘Ngayurna Mama ngarnawarrapurlukarna-janampa maaja maju nyinani Yipuramku, Yajikkukamu Jayikapku.’ ");
INSERT INTO mpj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yiltaya palukaja wanka nyinani ngarnawarra Mamamili ngurrangka. Yilta-jananyaya Mamalu wankanu ka kanyini, palumili ngurrangka, paluyuru-lanya wankalku kanyilku palumili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jiijajju-jananya marlakulu wajalpayi, martu kujupalu kurnulu kulinu pukurlarringu, Muujajmili wangkapurlukalu. Jiijajpara japirnu, “Muujajju-lampa Mamamili luwu yarnnga wajarnu. Mayiti kuju luwu majuwarta nyinani, kaya luwu karlkinpa ngalyarlpa nyinani. Wanyjajara luwu maju nyinani?” ");
INSERT INTO mpj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jiijajjura wajarnu, “Luwu majuwartanga palunga jilanya nyinani, ‘Yijurilmili marlajanukajaluya kulila! Maaja-lampa Mama ngarnawarrapurluka, kuju nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Palukuwiyajunyurra layikamurrira nyinara. Paluwiyajunyurra kuliraka nyinara.’ ");
INSERT INTO mpj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Palunyayuru luwu majuwarta kujupa nyinani. ‘Ngurra walyjakajakulara layikamurrira nyinani. Palunyayurula-janampa ngurra kujupakajaku layikamurrira nyinaku.’ Luwu palu kujarrapula maju nyinani, luwu karlkinpaya ngalyarlpa nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Muujajmili wangkapurlukalu wangka kulirnu ka Jiijajpa marninypungu, “Nintipuka!, jungalun wajarnu. Yilta palunyanga maaja maju-lampa, palunya kuju nyinani, mirta maaja palunyayuru kujupa nyinani, paki. ");
INSERT INTO mpj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Palunyangkalara layikamurrira nyinamalpa. Kuranjula kulira junga wulu nyinamalpa. Yuwa, nyuntulun junga wangka wajarnu. Ngurra kujungkajaru-langku layikamurrira nyinani. Palunyayurula-jananya nyinaku karlkingka. Juwukajalulara kuka mirtayirti pungkula kujani Mamaku, ngarnawarrapurlukaku. Palyalara pungkula kujarni. Kujanyjanjula wangka palu kujarraku junga nyinara. Mirtala walykulku, yintuljula katiku wangka palunya kujarra. Palunyajanulara palyalu kujalku katiku Mamaku.” ");
INSERT INTO mpj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Muujajmili wangkapurlukalu palunyalu jungalu kulirnu. Jiijajpara pukurlarringukara wajarnu, “Mamalu-jananya ngampurrju kanyirninpa palumilikaja walyjakaja. Jungan kulirnin ngayumili wangka, jampangulyu-jananyan nyinaku Mamamili walyjakajangka.” Palunyangkaya martulu karlkilu mirta japirnu Jiijajpa, paki, purtuya kulirnu, jumaji palunyalu-janampa jungalu wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jaajja majungka-jananya Jiijajju wulu nintijunkupayi martukajangka. Nintilkijalu-jananya Jiijajju jilanya japirnu, “Nyaakuya wajani Muujajmili wangkapurlukakajalu?, ‘Kurayijpa parnapurlukaku-janampa maaja kuju maju nyinaku, maaja Tayipityuru. Kurayijpa maaja Tayipitku marlajanu nyinaku.’ Nyaakuya jilanya wajarnin?” Jiijajju-jananya yarrarnu wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Mamamili Kurrurnju Tayipit nintirnu. Palunyangka Tayipitju jilanya wajarnu, ‘Mama ngarnawarrapurlukalura wajarnu Kurayijja, “Kujarrali nyinaku, maaja kujarra ngaangka. Ngayulu Mamalurna-jananya warrkilku kurtingku nyuntungkamarra Kurayijjamarra.” Tayipitju yarrarnu wajarnu, ‘Kurayijpa jiinya ngayumili maaja nyinani.’” ");
INSERT INTO mpj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ka Jiijajju-jananya yarrarnu wajarnu, “Tayipitju Kurayijpa wajarnu, ‘Ngayukuju maaja.’ Yilta Kurayijpa jiinya Mamamili, mirta Tayipitmili marlajanuwiyaju.” ");
INSERT INTO mpj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jiijajju-jananya yarrarnu marrkurnu jilanya, “Ngampurrpaya nyinama!, Muujajmili wangkapurlukakajangkamarra! Palunyakajalu-ngkuya kuurtungka kurrungkuni, kaya tawunja kutuwana parra yankuni, martukajaluya-jananya nyakura marninypungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Palunyakajaya jaajkarti yankura nyinani, maajamilingkawiyaju tiipulja, mirtaya martukajawana nyinani. Jampaya martukaja wumurriku ka kujungkarriku ngalkura pukurlarriraku. Muujajmili wangkapurlukakajaya palunyakaja yankura nyinani, maajamilingkawiyaju, tiipulja. ");
INSERT INTO mpj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wantikajaya karlkinpa nyininpa yirnaparnikaja, julyju-janampaya yirnakaja miturringu. Palunyakajaluya-janampa Muujajmili wangkapurlukakajalu wanti jiikajaku wartakaja ngulyulu-janampaya maninpa, ngapi wajaraka, ‘Ngampurrmankurnanta.’ Palunyakajaluya jaajja Mamangka rawa wangkani, nyakulaya marninypungkuraku, martu karlkilu. Mamalu-jananya yiltaminyirri rawalu warrkilku kurtingku wulu, ngurra kujupakarti, mirtaya Mamamilingka ngurrangka nyinaku, paki. Martu jiikaja putakaja-jananya pipurrulu warrkilku kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jiijajpa jaajja majungka nyinapayi. Nyakupayi-jananya maniraya kangkura junkupayi, wirningka, Mamaku. Mani majuwintiluya mani maju junkupayi. ");
INSERT INTO mpj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wantilu katingu junu jilpa kujarra japu kujarra, maniparnilujaru. Palunya wanti nyinapayi yirnaparni, julyjura miturringu. ");
INSERT INTO mpj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jiijajju jampa nyangu wanti palunya mani japu katingu junu, ka mirrangu-janampa wajarnu palumili wangka-nintikajaku. “Wangka ngaanyaya kulila! Wanti palulu mani majuyuru katingu junu. Kaya karlkilu mani juliyuru katingu junu. ");
INSERT INTO mpj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Palunyakajaluya mani junu kaya mani maju kanyirni. Wanti palunyalu mani julijuli junu ka maniparnirringu nyinani. Mirta mani kanyirni mirrkaku, paki, yungu pakirnu. Mamara yiltaminyirri layikamurrini.” ");
INSERT INTO mpj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Juwuku jaajpa majujanuya Jiijajmalu pakarnu yanu. Palumililu, wangka-nintilu jaajpa maju nyangu pukurlarringu wajarnura, “Nintipuka! Nyawa ngaanya jaajpa maju!, kunyjunyu-lampa yikini.” ");
INSERT INTO mpj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jiijajju-janampa wajarnu, “Nyawaya jaaji jiinya! Ngula, Mamamili parlanykajaluya jaaji jii punkajulku, kayilapa yapukajawiyaju ngarrira wananmalpa.” ");
INSERT INTO mpj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Palujanuya Jiijajmalu yapu Yalipajkarti yanu ka nyinapayi. Martuparningkaya yanu nyinapayi. Wangkanintikajaluraya japirnu, Jiijajpa palunyamilikajalu, ngapimalu?, Piijalu, Jayimijju, Jaanju Yanturulu. Jiikajaluraya japirnu, ");
INSERT INTO mpj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nyaarta jaaji palu majuwarta warlangku? Kulinilaju ngula parnakamu ngarnka pakirriku. Nganalaju nyaku nintirriku?, yiipi palu tayimu.” ");
INSERT INTO mpj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jiijajju-janampa kujupakarti wajarnu, “Wuulkumartaya nyinama!, pakiwana-nyurranyaya kajaljaku, ");
INSERT INTO mpj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","martukajaluntaya kujunkujunju, Kurayijyurulu yankura kajaljaku. Wangka jilanya-nyurranyaya kajalku, ‘Ngayurna-ngkuya maaja Kurayijpa marlakurringu. Mamalu julyju wajarnu ngayurna-nyurrampa marlakurriku.’ Jilanyaya martu yarnngalu yilta karanyja kulilku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jiijajju-janampa yarrarnu wajarnu, “Martukajalu-ngkuya jurta pungkumalpa ngurra kujupangkakamu ngurra kujupangka. Kayilapa palu tayimu mirta parnakamu ngarnka pakirriku, ngula pakirriku. Yiipinyurra jakurlpa kulilku, jurta-ngkuya pungkuni jilanyaya kulila!, ‘Mirta parnakamu ngarnka pakirriku kuwarri, ngula pakirriku.’ ");
INSERT INTO mpj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ka warrarn kujupa kujupawana-ngkuya jurta pungkumalpa, kayilapa parnakamu warta mayalurrjuya yurriku, parna yaarrangkaku. Palunya tayimuraya martukajalu mirrkaku purtu kulilku, mirrka-janampa pakirriku. Jilanyaya martukaja ngula nyinaku, kanyurra kulilku, ‘Kuwarri-langkuya warrkilkuka pungku, Jiijajmili martu walyjakaja.’ Jampa-nyurranyaya jilanya warrkilkuka pungku, mirtanyurra pakiwana kulilku, jilanya, ‘Parnakamu ngarnka kuwarri pakirriku.’, paki. Jilanyanyurra kulilkura, ‘Jampangulyu parnakamu ngarnka pakirriku.’” ");
INSERT INTO mpj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Jiijajju-jananya palunyamilikajangka wajarnu, “Wangka ngaanyaya pukunyju kulila! Karlkiluya-nyurranya martulu parlanykajalu manku katiku pungku, ka-nyurranyaya kangku kuutkarti. Juwumilingka-nyurranyaya jaajkajangka kangkura pungkumalpakamu yungkalmalpa, wartawintilu. Martuluya-nyurranya parlanykajalu mankura kangkura ngarajunkumalpa maajangka majuwartangka kapamanja. Jampa-nyurranyaya kangku yikijunku maajangka, wajalkunyurra-jananya wangka ngayumili. ");
INSERT INTO mpj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ngurra kujupa ngurra kujupanyurra ngayumili wangkanyurra wajalku. Palunya tayimu marla parnakamu ngarnka pakirriku. ");
INSERT INTO mpj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Martu karlkilu-nyurranyaya manku kuutkarti katiku. Palunyangka kuutpurlukalu maajalu-nyurranya japilku ka rakanyurra nyinaku, mirtanyurra ngurlurriku. Mirtanyurra kurranyilu kulila!, ‘Nganarna wajalku kuutja?’, Mamalu-nyurranya nintijunku palumili Kurrurnju, palyanyurra wangkaraku. ");
INSERT INTO mpj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Palunya tayimu nyuntunkurnu walyjaluntaya katiku kuutkarti yikijunku, jumaji ngayukujunyurra walyja martukaja nyinin. Kurtalu katiku marlangu yikijunku kuutja wajalku mituya pungkuraku, jumaji marlangu palunya walyjaju nyinani. Mamalu-pulanya katiku kajakamu yurntalpa yikijunku, kuutja wajalku mitu-pulanyaya pungkuraku, jumajipula ngayuku walyja nyinani. Kajalupula yurntalju katiku mamikamu mama yikijunku kuutja ka wajalku mitu-pulanyaya pungkuraku, ngayukupula walyja jumaji nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Karlkinpa-ngkuya martukaja yarnnga wirrilyi nyinaku, jumaji karlkinpangajuya ngayuku walyja nyinaku. Yiipijuya ngayuku junga wulu nyinaku, palunyangkaya wanka wulu nyinaku, Mamamili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jiijajju-janampa yarrarnu wajarnu, “Jurtawarta martuyuru ngula nyinaku, Mama ngarnawarrapurlukakura parlanypa. Martuya wulikaja ngurlujaka nyinaku parna Juutiyamartaji. Juwumilingka jaaji majungka palu jurtawarta nyinaku. Ka martukajaluya nintilu kulilku, ‘Mirta palu jurtawarta jaaji majungka nyinaku, paki.’ Yiipinyurra nyaku palu jurtawarta nyinani jaajingka, palujanunyurra ngurlu pinirriku, yapukarti, paluluntaya pungkujaku. Kuranjanyurra wangka palu kulilkuka kanyilku. ");
INSERT INTO mpj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Palu tayimunga, yiipi martu kuju mayangka yawujayiti nyinaku, puringka, mirta palu kurrungku mayangka, palumili wartakaja mankuraku, junkuralura, yapukarti pinirrikura. ");
INSERT INTO mpj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ka martu kujupa warrkamurrimalpa kaatanmayangka. Palujanuyila mirta marlaku yankura purikarti, kuurtukura mankuraku, junkuraku, yapukarti pinirrikura. ");
INSERT INTO mpj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Palu tayimu nyarruya nyinaku wantikaja manarrkajakamu jiji yampulpayikaja. Purtuya kulinmalpa wala yankuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jiijajju-janampa wajarnu, “Mamaluwiyaju palu tayimukura ninti. Mamaraya japila!, mirtanyurra kalyu tayimu yarra yapukarti!, kalyulu-nyurranya pulakamuljaku. Palujanuraya Mama ngarnawarrapurluka japila!, mirtanyurra yapukarti yankuraku kalyu tayimu. ");
INSERT INTO mpj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Palu tayimu jurtawarta palu nyinaku rawa walykuminyirri, ka-nyurranya rawalu pungamalpa, ngurlujakanyurra nyinamalpa. Palujanu ngula mayitpi jurtawarta kujupakaja nyinaku, kayilapa mirtaya martukaja ngurlujaka nyinaku. Julyju mirta jurtawarta jiiyuru walykuminyirri nyinapayi, paki, mirtaya martukaja ngurlujaka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Palu tayimu mirta jurta rawa nyinaku, martukajaya pakirrijaku. Mamalu-jananya marrkulku, wirlarra yupaljawiyaju-ngkuya jurta pungku, jumaji palumili walyjakaja pakirrijaku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jiijajju-janampa palumili wangka-nintikajaku yarrarnu wajarnu, “Yiipi martu kujupaluntaya yanku wajalku, ‘Nyawaya!, jiinya Kurayijpa, Mama ngarnawarrapurlukalu julyju wajarnu kurtingkuraku.’, kayilapanyurra ngangkulku junku. Yumuluntaya palunga kajalku. ");
INSERT INTO mpj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yarnnga-nyurranyaya yankurni kujunkujunpa, ka-nyurranyaya kajalku jilanya, ‘Ngayurna Kurayijpa yankupayi, Mama ngarnawarrapurlukalu julyju wajarnu ngayurni kurtingkuraku.’ Jilanyaya paki kajalku, kanyurra ngangkulku junku. Jiikajaya yankurni, ka maparnwintiluya yalyjirr kujupa kujupa ngapinmalpa, Mamamili maparnwintiluyuru, Mamamili walyjakajalu-jananyaya yilta kulilkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Palujanuya wurlku nyina!, jiikajaluntaya muunpungkujaku. Wangka jiirnantaya kurranyilu wajani, ngangkulkuranyurra ninti nyinaraku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“Palu tayimu marla jurta majungka jirntukamupula wirlarra pakalku kujupawana, mirta rantalku, mungajarrarriku. Ka kurtalyakajaya punkalku. ");
INSERT INTO mpj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Palunyangkarniya nyaku puntu yarnngaku marlpa yurnturrja tiputinpa. Maaja majurna-janampa tiputiku ka rantalku. ");
INSERT INTO mpj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tiputikurna Mamamili wikarrukajawinti. Karna-jananya wikarrukaja wajalku kurtingku, parna parlparriwanaya yankuraku. Yanku-jananyaya Mamamili walyjakaja martukaja manku, ka-jananyaya kangku kujungkalku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jiijajju-janampa yarrarnu wajarnu, “Wangalpaya ngangkula nintirriwa! Jampa wangalpa kakarrajanu wangkaku, ngangkulkunyurra jiinga wantajarrarriku. Wantajarraku-lanya wangalju nintijuninpa. ");
INSERT INTO mpj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Palunyayuru jirntukamu wirlarralu-langku nintijunku, kanyurra ngangkulku, ‘Kuwarrirni maaja maju-lampa marlaku yankuni.’ ");
INSERT INTO mpj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Wangka ngaanyaya kulila! Martukajanyurra kuwarri nyininpa, marlanyurra miturriku, wangka ngaanyarna-nyurranya wajani, yilta nyinaku. Jarujalumumartaji-nyurranyaya pungku, ka jaaji majuya pungku punkajunku. ");
INSERT INTO mpj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yilta parnakamu ngarnka pakirriku, ka ngayumili wangkaju yilta wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jiijajju-janampa yarrarnu wajarnu, “Palu tayimula ngurrpa wulikaja nyinaku, ngayulurrju. Mamamili wikarrukajaya ngurrpa nyinaku, kujuwiyajura Mama ninti nyinani. ");
INSERT INTO mpj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ngampurrpaya nyinama!, palunya tayimukulara ngurrpa, junga wulujuya nyinama! ");
INSERT INTO mpj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","36","Wangka palunya yumuwanpa nyininpa jilanya. Maaja ngurra kujupakutu yanku. Wajalku-jananya palumili warrkamupurlukakajangka, mayakamu wartakaja ngampurrju kanyilkura. Warrkamupurluka kuju warrkamurriku tuwungka, wupuntamunkura-janampa, jarrpajunkuraku kaninyjarra. Maajalura wajalku, ‘Tuwungkalu ngarama!, ngayukuju nyakuma!, tuwuju wupuntamunkura, mirtan kunyalarrira.’” Jiijajju-janampa yarrarnu wajarnu, “Mayiti maaja yankurni ruka, mayiti kutuwartirni, mayiti yungunyungunpa. Nyakularaya nyinama!, maaja walarni marlaku yankujakungkamarra, mayiti nyakujaku-nyurranya kunyala ngarrinpa.” ");
INSERT INTO mpj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jiijajju-jananya yarrarnu wajarnu, “Wangka jiiyuru, nyakulajuya nyinama!, marlakurna maaja yankurni.” ");
INSERT INTO mpj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Juwukajaya kujungkarripayiya mirrkaku Mamayilaya marninypungkura. Palunya karrpuparaku-janampa yini Pajuwupa. Palunyangkaya mirrka pikinpawutuparni ngalkupayi. Nyukurniya kulirnu Jiijajpaya mitu pungkukijalu, Muujajmili wangkapurlukakajalu, yatilyparakululurrju. Pajuwupa palunyangkaya kurranyi karrpu kujarrangka jaalpuya kujungkarringu wangkangu Jiijajpaya mankura mitu pungkuraku. Jilanyaya wangkangu, “Mirtala manku laltungka, Pajuwupangkala kuwarri nyininpa, laltulu-lanyaya wirrilyiwintilu pungkujaku. Jiijajkuraya martukaja pukurlarrinpa.” ");
INSERT INTO mpj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Palunyangka Jiijajkamu palu wangka-nintikajalurrjuya tawunja Piijaningka nyinapayi, puntu Jayimunku ngurrangka. Jayimun julyju ngarnta lipurujiwinti nyinapayi. Jiijajju mangarri ngalkupayi, yanulu yurrkanyju katangka yintirnu jinyji, paatuljanu wupuntamunuka. Jinyji palunga mani jumawarta. Julyju payamunu kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Karlkinparaya martukaja wirrilyirringu. Wajarnu-ngkuya, “Nyaaku palu yurrkanyju jinyji yintirnunirra? ");
INSERT INTO mpj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yungkungara-langku katirala jalamunkungara mani majuwartaku. Ka yungkungarala-jananya nyarrukaja wulpipulpa, ngarntawintikaja, mani.” Palunyajanu yurrkanykuraya wirrilyirringu. ");
INSERT INTO mpj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Palunyangka Jiijajju-jananya wajarnu, “Jurraya!, yurrkanypa nyarru. Nyamurni yintirnu, palyaminyirri.” ");
INSERT INTO mpj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yarrarnu-jananya wajarnu, “Jiikajangaya nyarrukaja wulpipulkaja nyininpa, kunyjunyu-janampanyurra palukajaku ngapilkura. Ngayukulurrjukujunyurra kuwarri kunyjunyu ngapilkura, mirtarna-nyurranya rawa nyinaku. Wanti jiilurni kuwarri kunyjunyu ngapirnu. ");
INSERT INTO mpj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Murrarnila jinyji mitungka yintirni. Palunyayururni yurrkanyju ngaalu yintirnu kurranyi, nintipukalu. Marlawanalurniya tuunyjunku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jiijajju-jananya yarrarnu wajarnu, “Kulilarniya! Wangka ngaanyaya kulila! Wangka ngayukurnu wajalkunyurra yinta kujupangkakamu yinta kujupangka, yarnngalu, marlajanukajalulurrjuya. Wangka ngaa kujupalurrjuya parra wajalku, ngaalurni yurrkanyju yintirnu, katangka, jinyji. Yuwa, wangka jiikuraya martu yarnngalu kulilku karaya ninti nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wangkanintikaja Jiijajkuraya nyinapayi tuwal wulikaja. Kuju yini Juutajpa, Yijikariyatmartaji. Palunyangka Juutajju yanu-jananya wajarnu, yatilyparaku jaajmapu, “Ngularna-nyurranya nintijulku, Jiijajpa mankurakunyurra.” ");
INSERT INTO mpj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kulirnuya wangka jaajmapulu kaya pukurlarringu. Wajarnuraya, “Manilajunta yungku ngula.” Palunyangka Juutajju manikijalu kulirnu ka jilanyalurrju kulilpayi, Jiijajpaya mankuraku, yatilyparakulu. Kulirnu Juutajju jilanya, “Yupalpaya nyinaku Jiijajmilikaja, karna ngayulu yanku wajalkurna-jananya Jiijajpaya mankuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Juwukajaya Pajuwupakuraya kujungkarripayi, kukurnjarriya pungkupayi ngalkukijalu. Palunyangka Jiijajmili wangka-nintikajaluya japirnuraya Jiijajpa, “Ngurrangkala wanyjangka junku mirrkakamu kukurnjarri?, ngalkurala ngayunju.” ");
INSERT INTO mpj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wangkaninti kujarrangka-pulanya Jiijajju wajarnu, kurranyi yankupula junkuraku rayiti mirrkakaja. Jilanya-pulampa wajarnu, “Yankupulan tawunkarti. Jampapulan nyaku martu kuju kalyuwinti yankuni. Wanalkupulan mayakarti. ");
INSERT INTO mpj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kurrungkupulan mayangka ka japilkurapulan maaja jilanya, ‘Ngayu kujarraku maajalu-linyaju yiyarnu. Maya ngaangkalaju wanyjangka ngalku?, mirrkakamu kukurnjarri, Jiijajmili wangka-nintikajalu’ ");
INSERT INTO mpj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Maajalu palunyaluntapula tatijunku ngarnawarra nintijunku tiipulwinti. Palunyangkapulan mirrkakamu kukurnjarri junku.” Jilanya Jiijajju-pulanya palu kujarra wajarnu ka yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Palunyangka yanupula nyangu kalyuwinti martu yankupayi. Wanarnulupula ka wajarnulupula Jiijajmili wangka. Kapula mirrkakaja kukurnjarri rayitipula junu yanu, ka marlakupula yanu Jiijajkarti. ");
INSERT INTO mpj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jampa mungarringu wangka-nintikajakamu Jiijajlurrjuya yanu mayakutu palukarti. ");
INSERT INTO mpj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nyinaraya tiipulja ngalkupayi. Ka Jiijajju-jananya wajarnu, “Wangka ngaanyaya kulila! Ngaangka martu nyinin kuju ngalkuraka. Palunyalu-jananya wajalku, ngayurniya mankuraku karniya kangku kanyilkura.” ");
INSERT INTO mpj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kulirnuya wirla walykurringu. Jiijajpaya japirnu kujunngurulu kujunngurulu, “Kajirnin ngayu wajarni? Ngayurna ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jiijajju-jananya wajarnu, “Ngayuku walyjajunyurra tuwal wulikaja. Kujulu-jananya yanku wajalku, ngayurniya mankuraku. Palunyangka jiilunga kujulu ngaangkaliju karrkartangka mirrka tupurljuninpa. ");
INSERT INTO mpj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngayurna-nyurrampa puntu yarnngaku marlpa nyininpa. Yiltarniya kuwarri miturntanku. Jilanya Mamamili wangka jakurlpurlukalu julyju mirlimirlingka wakarnu. Martu palunyalu-jananya yanku wajalku ngayurniya mankuraku. Yilta-jananya ngayuku jakurljunku. Palunyangka wirla walyku nyinaku, mirta pukurlpa. Palunyangka Mamalu palu martu warrkilku yiyalku ngulampa, mirta Mamamilingka ngurrangka kurrungku.” Palujanu Jiijajju-janampa yarrarnu palumili wangka-nintikajaku wajarnu jilanya, “Palunga yilta walyku nyinaku. Palya nyinangara jii martu jakurljunkuparni. Juku miturringara palunyangka Mamalu katingara ngurrakarti, palumilikarti.” ");
INSERT INTO mpj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tiipuljaya ngalkupayi. Ka Jiijajju karlukarlu manu ka Mamangkalu marninypungu, “Mirrka-lanyajun ngaanya yungkuni.” Ka warlangu yunguyila-jananya. Wajarnu-jananya, “Nyii! Mirrka ngaa ngalaya! Ngayu kawurninyurra ngalkurni.” ");
INSERT INTO mpj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Palunyangka wama manu kaapungka. Ka Mamangkalu marninypungu, “Wama-lanyajun ngaanya yungkuni.” Ka-jananya kaapu yungu, jikilkurakuya. Palujanu wulikajaluya jikinu. ");
INSERT INTO mpj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ka-janampa Jiijajju yarrarnu wajarnu, “Wama ngaa ngayurninyurra jikirnu mijiyuru. Julyjuya kuka mirtayirti pungkula miji yintilpayi, Mamalu-janampa walyku wirrupungkula kunyjunyulkura. Kuwarrirna-nyurrampa wartangka miji yintiku mirtayirtiyuru, puntukajakurna-nyurrampa, walyku wirrupungkula kunyjunyulku. Jamparna miturriku Mamaluntaya martukaja jamartapungku walykukaja wirrupungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mirtarna wituka jikilku ngaanya wama parnangka, paki, ngurra kujupangkarna jikilku ngula. Mamalu-jananya ngampurrju kanyilku palunyamili puntu walyja. Kujungkarrikurna-jananya jikilku wama kujupa.” ");
INSERT INTO mpj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mamakuraya yinkarnu turlku, kaya pakarnu yanu yapukarti, yini Yalipajkarti. ");
INSERT INTO mpj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jiijajju-jananya wajarnu wangka-nintikajangka, “Kuwarrirninyurra junku yanku. Palunyayuru Mamakurnu wangka nyinin jilanya, ‘Kukurnjarriku maajaya pungku. Palunyangkaya pinipinirriku, kukurnjarri kujunkujun.’” ");
INSERT INTO mpj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jiijajju-jananya yarrarnu wajarnu, “Mamalurni mitujanu wankalku, karna yanku marlaku parna Kaliliyakarti. Kurranyirna ngayu yanku, ka marlarniyan yanku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piijalura wajarnu, “Karlkiluntaya junku yanku ngayulurnanta mirta junku yanku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiijajjura Piijaku wajarnu, “Wangka ngaanya kulila! Kuwarri mungajarra pawurla mirraku. Palunyangka kurranyi ngayukujun ngurrpajunku, yupal tayimu.” ");
INSERT INTO mpj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piijalura wiltulu wajarnu, “Mirtarnangku ngurrpa wajalku. Yiipi nyuntuntaya pungkukijalu, palunyangkali kujungka ngaraku, ngayu kujarra-linyaya pungkuraku.” Jiijajmili wangka-nintikajaluya wajarnu, “Yuu, palunyangkala kujungka ngaraku jijaku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Palunyajanuya Jiijajmapu purnukutu yanu, yini Kajimanikarti. Jiijajju-jananya marrkurnu, “Ngaangkajuya purnungka majala!, yankurarnalu Mamangka wangkakura.” ");
INSERT INTO mpj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Karlki-jananya marrkurnu ka yupalpa-jananya katingu, Piija, Jayimijpa, Jaanpa. Wirla walykurringu Jiijajpa. ");
INSERT INTO mpj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka wajarnu-janampa, “Wirlarna walykurrinpa, jampangulyurna miturriku. Ngaangkajuya majala!, nyakumarniya!, wiyanyurra kunyalarri!” ");
INSERT INTO mpj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jiijajpa maa yanu parnangka wartuyikingu. Ka Mamangkalu wangkangu jilanya, “Mama! Mayitin jilanya kulirni, ngayurniya pungkujakungkamarra, mitu. Palunyangka-jananya walykukaja marrkula!, ngayurniya junkuraku, jilanyakurnanta japirni. ");
INSERT INTO mpj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mama nyuntun maparn maju, palyalu-jananya marrkulku, ngayungkamarra! Mayitin nyuntulu kulirni pungkurakurniya. Waal palya ngayurniya pungku, jumajin nyuntulu kulirni, palya.” ");
INSERT INTO mpj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Palunyajanu-jananya Jiijajju yanu nyangu kunyalaya ngarrinyjanpa. Piija kanarnu Jiijajju, kara wajarnu, “Jayimun Piija! Nyaajanun nyuntu kunyalarringu? Rawaparnirna yanu marlakurringu. Kanan nyinangara nyakungarajun.” Yarrarnu-jananya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Kanaya nyinama!, nyakumajuya! Mamangkaluya wangka!, kujupalu-nyurranya muunpungkujaku, ngayurninyurra junkula yankujaku. Palyalunyurra kulirni, ngayukujunyurra junga nyinakuraku. Kujupalu-nyurranya mayitpi muunpungkujaku, ngayurninyurra junku yankuraku. Palunyangkamarranyurra Mama japinmalpa.” ");
INSERT INTO mpj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jiijajpa marlaku yanu yarrarnulu Mamangka wangkapayi, wangka palunyayuru. ");
INSERT INTO mpj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wangkanintikajaya nyinangu nyuurrarringu, ka kunyalarringu. Palunyajanu-jananya marlaku yanu nyangu kunyalaya ngarrinyjanpa, mirtaya kana nyinangu, paki. Jiijajju-jananya kanarnu, kaya kurntarrira yaka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jiijajpa wituka yanu marlaku Mamangkalu wangkapayi. Palunyajanu-jananya marlaku yanu wajarnu, “Nyaakunyurra kunyala ngarrinpa? Nyamu pakalaya! Kuwarrirniya manku katikurniya yungku walykukajangka, martu yarnngaku marlpa. ");
INSERT INTO mpj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pakalaya!, kujungkala yanku. Jii-jananyaya nyawa!, yaninparniya laltu. Kuju jiingkarni yaninpa palulunga-jananya jakurljunu, ngayurniya mankuraku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Palunyangka Juutajpa yanurni palungara Juutajpanga wangka-ninti nyinapayi, Jiijajku. Juutajmapuya yankupayi, karlkinpangaya nayipu majuwinti yankupayi, ka karlkinpangaya wanawinti. Jaajmapulu-jananyaya wajarnu yiyarnu, yirnakajalukamu, yatilyparakulukamu, Muujajmili wangkapurlukakajalu. ");
INSERT INTO mpj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nayipuwintikamu wanawintilurrju-jananya kurranyilu Juutajju wajarnu, “Palunyarna-nyurranya Jiijajpa nintilku, yankurna nyunyjulku. Palunyangkanyurra manku wiltulu katiku, yankujakungkamarra.” ");
INSERT INTO mpj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Juutajpalu yanu Jiijajja wangkangu, “Nintipuka!” Palunyajanu nyunyjurnu. Murrarniluya Juwukajalu julyju nyunyjunma-ngkuya kujungkarrira. ");
INSERT INTO mpj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Palunyangkaya Jiijajpa manu nayipukajawintilu. ");
INSERT INTO mpj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jiijajmili wangka-nintilu nayipu majuwintilu yilarnuka katupungu kuran punkajunu, kuju yatilymili warrkamupurluka. ");
INSERT INTO mpj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jiijajju-jananya nayipuwintingka wajarnu, “Ngayurninyurra martu walykuyuru mankukija yanurni nayipuwintilukamu, wanawintilulurrju. ");
INSERT INTO mpj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jaajpa majungkarna-nyurranya nintilpayi karrpu kujupa karrpu. Jiingkarninyurra mankungara, mirtarninyurra jiingka manu, paki. Ngayulurna mirta walykukaja ngapilpayi, paki. Palujanurninyurra junkungara. Palyalurninyurra manku katiku, jumaji Mamamili wangka jilanya nyininpa. Wangka palunya kuwarri yiltarriku. Mamamili wangka jakurlpurlukakajaluya julyju wajarnu, ngayurninyurra mankura katiku.” ");
INSERT INTO mpj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jiijajpaya manu ka mawu katingu. Palunyangkaya Jiijajmilikaja wangka-nintikaja ngurlu pinipinirringu. ");
INSERT INTO mpj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ka kujulu yangupalalu marlawanalu wanalpayi. Mirta kulujukurlu yankupayi, pulanykartikurlu yankupayi. Yangupalaya nyangu nayipuwintikajalu kaya karlkilu muntarnuluya pulanykarti, ka ngurlu pinirringu kulujuparni. ");
INSERT INTO mpj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jiijajpaya winirnu katingu maaja majukarti yatilykarti, palumili ngurrakarti. Maaja palu-janampa kurranyi mirrangu kujungkarriraku, yatilyparakukamu, Muujajmili wangkapurlukakajakamu yirnakaja. Kujungkarriraya majalpayi Jiijajku, maajamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piijalu Jiijajja marlakarti wanalpayi wirrirlilu. Maajamilingka ngurrangka piinyjingka jarrpangu. Jiingkaya jantulwintikaja warungkaya nyinapayi. Ka yanu-jananya nyinatingu, waru nganyjilpayi. ");
INSERT INTO mpj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mayangka kaninyjarra maajakajalu-ngkuya japirnu, “Kuutja ngaangka nganalu-lampa wajalku?, jii Jiijajju ngana putamanu.” Palunyangkaya karlkin kujupalu pakarnu mayujunu. ");
INSERT INTO mpj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Karlkinjuya pakiwana wajalpayi, mirtaya wangka kuju wananma. ");
INSERT INTO mpj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Karlkin kujupaluya pakarnu mayujunu jilanya, ");
INSERT INTO mpj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kulirnulaju jiilu Jiijajju wajarnu jilanya, ‘Jaajpa maju paluya martu laltulu palyara ngarajunu, karna ngayulu warlangku, palujanurna karrpu yupaljarna ngayulu palyalku ngarajunku, jaajpa kujupa, mirta martu laltulu, paki.’” ");
INSERT INTO mpj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jiiwanaya karlki kujupa pakiwana wangkangu, mirtaya wangka kuju wananma. Palunyangka maajakajaluya purtu kulirnu, jilanya wajalkuraku, Jiijajpaya karlki kujupakajalu miturntankuraku. Jumajiya mirta palukajalu wangka kuju wanalpayi, paki. ");
INSERT INTO mpj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Palujanu Maaja majulu pakarnu Jiijajja japirnu, “Nyaaya palukajalu wajanu?, nyuntulun jaaji kujupa ngapilkuraku. Wajala-lanyaju!” ");
INSERT INTO mpj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jiijajpa yaka yikipayi, wiya wangkangu. Maaja majulu palunyalu yarrarnu japirnu, “Junga-lanyaju wajala! Kajin nyuntu Kurayijpa ngarinpa, Mamaku kaja?” ");
INSERT INTO mpj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jiijajjura wajarnu, “Yuwa. Ngulangarninyurra nyaku Mamangkarnalu kujungka nyinaku, ngayurna-nyurrampa puntu yarnngaku marlpa. Maaja maju kujarraliju jiingka nyinaku maparn majuwinti. Ngularninyurra nyaku yurnturrjarna tiputiku, ngarnkajanu.” ");
INSERT INTO mpj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Maaja majura wirrilyirringu ka kulujpangku warlangu. Jiiyuruya Juwukajalu murrarnilu-ngkuya kulujpa warlangkuni, jampa kujupalu wajalku jilanya, “Mama ngarnawarrapurlukaliju maaja maju kujarra nyinani.” Jampangku warlangu kulujpa wajarnu-jananya, “Ngaalu pakiwana wajanu, mirta palu ngarnkapurluka, paki, ngaanya martu ngaamartaji, parnapurluka. Mirtala karlkikula-janampa mirraku wangkakura, nyamula kuwarri kulirnu, palulungku wajanu, Mama ngarnawarrapurlukakamupula palu kujungka nyinani. Yilta, luwu-lampa warlangu, ngananyurra wajalku? Yaalu mankula?” Yarnngaluya mitujunu. Wajarnuya, “Jantulwintikajaluya katira mitu puwa!” ");
INSERT INTO mpj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Palunyangkaluya Jiijajja ngumpangka jangajunma. Jiijajpaya karrpirnu kuru, nyakujakungkamarra, kaya ngumpa pungama. Ngarlpungarlpuluya japinma, “Nganalunta pungama ngumpa? Wajala-lanyaju! Nyuntun Kurayijpa nyininpa maparn maju. Wajala-lanyaju!” Jantulwintikajaluya jiiyuru Jiijajpa wituka pungama. Piijalu ngurrpa wajarnu ");
INSERT INTO mpj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Palunyangka Piija warungka nganyjira nyinapayi. Maaja jiiku warrkamupurlukalu yurrkanyju yintarnu ka japirnu, “Kajin Jiijajjalun nyuntu nyinapayi?, Najarajamartajingka?” ");
INSERT INTO mpj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piijalu kajarnu jilanya, “Ngurrparna! Purturnanta kulirnin. Nganan wajarni?” Piija pakarnu yanu kiitukutu ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yurrkanyju palulu yarrarnu nyangu Piija, ka-jananya wajarnu, “Yilta, jiinyalu puntu Jiijajja yankupayi.” ");
INSERT INTO mpj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piijalu yarrarnu-jananya wajarnu, “Ngurrparna.” Kinti ngarapayiluya wajarnu Piijangka, “Yilta, nyuntulun Jiijajja yankupayi, nyuntun Kaliliyamartaji, palunyayuru.” ");
INSERT INTO mpj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Piijalu-jananya yarrarnu ngurrpajunu jilanya, “Mama ngarnawarrapurlukangka kurungka jungalurna-nyurranya wajarnin, ngurrparnara. Yiipirna paki wajarni, Mamalurni ngarnawarrapurlukalu pungku. Yiltarna-nyurranya wajarnin, ngurrparnara.” ");
INSERT INTO mpj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Palunyangka pawurla mirrangu. Mirranyjanpa Piijalu kulirnu. Palungka Jiijajmili wangkangka kulirnu, ka yulapayi. Jilanya Jiijajju kurranyilu wajarnu, “Pawurla mirraku. Palunyangka kurranyilujun ngurrpajunku yupal tayimu.” Piija yilta yulangu kurntawinti. ");
INSERT INTO mpj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jirntu pakarnu, palunyangkaya kujungkarringu, yatilyparakukamu, yirnaparakukamu, Muujajmili wangkapurlukakajakamu, yirna kujupakajalurrju. Kujungkarringuya miitingpa wangkangu. Wangkanguya wajarnu, Jiijajpa karrpira katira maaja majukarti, yini Payilatkarti, kapamankarti. Katinguya yikijunu. ");
INSERT INTO mpj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Payilatjulu Jiijajja japirnu, “Juwuku-janampan maaja maju yikini?” Ka Jiijajjulu wajarnu, “Yuwa. Nyuntumili wangka palu yilta nyinani.” ");
INSERT INTO mpj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Palunyangkaya yatilyparakulu Jiijajpa kuru wajalpayi, Payilatja mirangka. ");
INSERT INTO mpj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Payilatjura Jiijajku yarrarnu japirnu, “Jilanyantaya jiikajalu yupal tayimu kuru wajarnu. Nganan wajalku?” ");
INSERT INTO mpj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jiijajpa wulu wangkaparni ngarama, mirta-jananya wangkangu. Ka Payilatju purtu kulirnu. ");
INSERT INTO mpj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Juwukajaluya kujungkarripayi mirrkaku Mamayilaya marninypungkura. Palunya karrpuparaku-janampa yini Pajuwupa. Pajuwupa palunyangka Payilatju-janampa murrarnilu purijina kuju walajula yiyala, jampa Juwukajaluya Payilatpa japila. ");
INSERT INTO mpj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Palunyangka puntu kuju Parapajpa jiilja nyinama. Parapajmapuluya julyju kapamanmapumili martukaja pungama. Palu tayimu Parapajju kuju puntu pungu mitu. ");
INSERT INTO mpj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Juwukajaluya martukajalu Payilatmili mayakutu yanu japirnu, purijina kuju walajunkura. ");
INSERT INTO mpj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Payilatju-janampa puntajilu japirnu, “Purijina nganakuranyurra wangkani?, mayitpi maaja majuku paluku. Palunganyurra martukajalu wajani, Juwukajamili maaja maju.” ");
INSERT INTO mpj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wangka paluku-jananya japirnu Payilatju, Jiijajpa walajunkura yiyalkura. Kurranyilu kulirnu Payilatju, “Yatilyparakuraya Jiijajkuraya parlanypa nyininpa, jumajiraya martu yarnnga pukurlarrinpa. Palunyangkarniya katingu yikijunu.” ");
INSERT INTO mpj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Payilatju-jananya wangka paluku, japirnu jilanya “Nganakuranyurra wangkani?” Palunyangka yatilyparakulu-jananyaya parra yanu martukajangka muunpungkupayi, “Parapajpaya wajala!, mirta Jiijajpa.” Jilanyalu-jananyaya muunpungkupayi martukaja. Palunyangka martukajaluraya japirnu Parapajku. ");
INSERT INTO mpj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payilatju-jananya yarrarnu japirnu, “Puntu kujupa wanyjalmalkurna? Kulirnurna Juwukajalunyurra wajalpayi maaja maju-nyurrampa jiinya.” ");
INSERT INTO mpj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka wiltuluya wajarnu, “Wartangkaya martu jiinya wiltijula, miturntala!” ");
INSERT INTO mpj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Payilatju-jananya yarrarnu japirnu, “Jiinya ngurrpa. Ngana putamanu? Nganajanula wiltijunku?” Wululuya wiltulu wajalpayi, “Wartangkaya wiltijula miturntala!” ");
INSERT INTO mpj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Palunyangka Payilatju Parapajpa kurtingu martukaja-jananya yarnnga pukurlmanu. Ka wajarnu-jananya jantulwintikajangka Payilatju, Jiijajpa wiipwintiluya pungkuraku. Yungkalpayiya. Palunyangka-jananya wajarnu Payilatju kangkuraya jantulwintikajalu wartangka wiltijunkura. ");
INSERT INTO mpj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jantulwintikajalu-ngkuya ngurrakarti katingu Jiijajpa. Ngurra palunyangka-janampaya jantulwintikajaku kujupakajaku mirrangu ka kujungkarnu. ");
INSERT INTO mpj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kujungkarringuya jantulwintikaja yarnnga. Ka Jiijajjaluya kuurtu tikamaturnu ka junuluya kujupa kuurtu marumaru, maaja majukurnu. Yakirriyuruluya palyarnuka junu jilkarnkajawinti, katangkaluya. ");
INSERT INTO mpj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngarlpungarlpuluya pupangu ka nyurnilu wajanma jilanya, “Maaja maju, wulu nyinama! Juwuku-janampan maaja maju yilta.” ");
INSERT INTO mpj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Palunyajanuluya wartawintilu manuka pungkupayi, katanyuku. Yumuluya pupatipayi, ka nyurniluya wajalpayi, ka Jiijajjaluya jangajunama. ");
INSERT INTO mpj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kuurtuya marumaru tikamaturnu ka junuluya kulujpa walyja, marlaku. Kaya manu katingu wartakarti wiltijunkurakuya. ");
INSERT INTO mpj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tawunpaya junu yanu, ka nyanguya Jayimunpa, Jarinimartaji. Martu palunga parna kujupajanu yankupayi, Jarujalumukarti. Jayimunpa palunga Yalikijantakukamu Ruupajaku-pulampa Mama nyinapayi. Wajarnuraya Jayimunku jantulwintikajalu, “Ngaanya warta Jiijajkura marra kati!, yapu jiikutu.” Ka Jayimunju manu katingu. ");
INSERT INTO mpj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yapu yini Kulkujakutuya Jiijajpa katingu. Kulkuja wangka kujupa-janampa. Jilanyaya wajalpayi, “Kata tarrka ngurra.” ");
INSERT INTO mpj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Palunyajanuraya Jiijajjpa purtu yungu wama, mitijinwinti, jikilkura. Jiijajju purtu yajinuka junu. ");
INSERT INTO mpj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ngurra palunyangkaluya kulujpa tikamaturnuka wartangka nyiilamunu. Palunyajanuya warta Jiijajwinti yikijunu, wulu yikira miturrikura. Kaya jantulwintikaja parangkupayi kaartangkayuru Jiijajmili kulujkajawinti. ");
INSERT INTO mpj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Karrpukarrpuya Jiijajpa wiltijunu. ");
INSERT INTO mpj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wartangkaya katu nyiilamunu pukujingka wangka jilanyawinti, “Ngaanya Juwuku-janampa maaja maju.” Kuutpurlukalu maajalu wajarnu, “Wangka jiinyaya nyiilamula jurra!” Murrarniluya wakara junkupayi, wangka martulu putamankunyjajanu. ");
INSERT INTO mpj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ngulyujanu-pulanyaya kujarra warta kujupa kujarrangka nyiilamunu yikijunu. Yupalpaya palungka ngarangu Jiijajpa kutungka. ");
INSERT INTO mpj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Martukajaya yiwarrajunma ka Jiijajpa wulu wanka wiltiyikipayi. Kaluya nyurnilu nyakula kaluya wajanma jilanya, “Nyuntulu-lanyajun wajarnu Juwumili jaajpa maju warlangkukijalun. Ka karrpu jurripalangkan marlaku palyalkija maparnwintilu. ");
INSERT INTO mpj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wangka palunyan wajarnu. Palunyangka maparn majulungku tiputi ka wankala!” Jilanyaraya ngarlpulu wajarnu, mirta yiltalu. ");
INSERT INTO mpj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wangka palunyayuruya martukaja nyurniya wangkapayi, yatilyparakukamuya Muujajmili wangkapurlukakaja. Wangka kujupaya wajanma ngarlpungarlpulu, “Jiilu-jananya martu kujupakaja wankalpayi, mirtangku walyjalu wankarninpa. ");
INSERT INTO mpj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mayitpi ngaa Juwuku-lampa maaja maju yilta wiltiyikininpa. Yiipi tiputiku jaalpu, palunyangkala kulilku Mamamili maparn maju nyininpa, yilta Kurayijpa.” Palu ngulyupurluka kujarralupula wartangka wiltingarapayi. Jii kujarralupula Jiijajja wangka jilanyayuru kiin nyurnilu wangka wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jirntu karrpungka parna parlparringka mungarringu. Palunyajanu rukayila marlaku jirnturringu. ");
INSERT INTO mpj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jiijajju wartangkalu Mamangka wiltulu japirnu, “Yiluyi yiluyi lama japakajani?” Wangka walyjalu japirnu jilanya, “Mama ngarnawarrapurluka, nyaajanulurnin junu yanu?” ");
INSERT INTO mpj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngamuya karlki ngarangu wangka paluya purtu kulirnu. Pakiwanaya wajarnu, “Kulilaya! Mitupurlukakura Yilayijaku mirraninpa, julyju palunga miturringu.” ");
INSERT INTO mpj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kujupalura pinirringu wartangka kulujpa karrpirnuka wama yurnangka tupurljunu. Kalu yitijunu yungu. Ka-ngkuya wajarnu, “Kurlu nyawaya! Mayitpi Yilayija wankarriku ka yankurni kurtingku parnakutu, palu Jiijajpa.” ");
INSERT INTO mpj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Palunyajanu Jiijajpa wiltu mirrangu ka miturringu. ");
INSERT INTO mpj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Palunyangka jaajja majungka Juwuku-janampa kaliki yaarrangkangu, kaliki jiinya wiltu yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jantulwintikajaku-janampa maaja ngarapayi. Ka nyangu Jiijajpa mirranyja ka wajarnu, “Yilta, puntu ngaa Mamaku kaja wiltiyikini, ngarnawarrapurlukaku.” ");
INSERT INTO mpj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jiijajpa kurranyikurlu wanka wiltiyikipayi, palunyangkaya wantikajalu wirrirlijanulu nyakuma. Wanti kujarrangapula jiikajangka kujungka yikipayi yinipula Miiri Makatalamartajikamu, Miiri kujupa yakurti-pulampa Jayimijkukamu Juujapku. Palukajangka-jananya wanti yikipayi yini Jalumpa. ");
INSERT INTO mpj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jampaya julyju Jiijajkamu wangka-nintikaja parna Kaliliyawana nyinapayi, wanti palunyakajalu-jananyaya kanyilpayi ngampurrju, mirrkaya-jananya kujara yungkupayi. Wantikaja karlki kujupa-jananyaya Jarujalumukarti yanurni Jiijajmapungka. Kujungkarringuya ngarala nyakupayi. ");
INSERT INTO mpj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Karrpu Purayitingka Jiijajpa miturringu. Rukarrinyjangka puntu Juujappa Yaramajiyamartaji yanurni. Yungunpa Jarriti-janampa ngarangu Juwukajaya warrkamuparni nyininpa, Jarritingka, mirtaya tuunyjunkuninpa Jarritingka. Juujappa-janampa Juwukajaku maaja maju nyinapayi. Wuluya jii maajakaja kujungkarripayi Jarujalumungka. Juujappangara Mamaku walyja nyinapayi, ngarnawarrapurlukaku. Juujappa palu yanu Payilatmili, mayakarti, ka ngurluparni jarrpangu Payilatpara japirnu, Jiijajpa mitu tipujunkula ka katira tuunyjunkura. ");
INSERT INTO mpj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Palunyangka Payilatjura japirnu, “Yilta, Jiijajpa kuwarri mitu wiltiyikini?” Palunyajanu Payilatju mirrangura maajaku, jantulwintikajaku kara japirnu, “Jiijajpa kaji mitu?, mayiti wanka wiltiyikini.” ");
INSERT INTO mpj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mitu kulirnuka Payilatjulu wajarnu Juujapja, kangkura tuunyjunkura. ");
INSERT INTO mpj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Juujapju julyju payamunu kanyilpayi, warntu mitupinti. Wartangkaya Juujapmapulu tipujunu kaya katingu warntungka tayimapurnu. Kaya katingu pirnkingka ngarrijunu, ka yapuluya marlaku juturnu, Juujapmapulu. Pirnki palunya jiikajaluya jawarnu pirnkirnu, julyju. ");
INSERT INTO mpj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wanti kujarralupula nyakupayi paluya Jiijajpa pirnkingka junu, yini Miiri Makatalamartajilukamu Miirilu, Juujamili yipilu. ");
INSERT INTO mpj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jarritingka mungangkaya payamunu kanyilpayi, jinyji nyirtilpinti, Miirilu Makatalamartajilu, Jalumju, ka Miiri kujupalu Jayimijku yipilu. Kulirnuya yungunpa Jiijajpaya yankula jinyjiluya yintilkijalu. ");
INSERT INTO mpj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jaantingkaya yungunpa yanuya jii pirnkikarti. ");
INSERT INTO mpj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yanamaya kutungka japirnu-ngkuya jilanya, “Nganalu-lampa pirnkijanu yapu palu ruulumunku ka wupuntamunku? Yapu jii purtulypa.” ");
INSERT INTO mpj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tiwajanuluya nyangu jii yapu wupunpa yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yanuya pirnkingka kurrungu. Kaya nyangu kuju warrinyji pirnkingka nyinapayi, wayitwankurlu kulujkurlu. Nyangukaya ngurlurringu yikipayi. ");
INSERT INTO mpj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Palunyangka-jananya warrinyjilu wajarnu, “Mirtanyurra ngurlu yikima! Ngurrirninparanyurra Jiijajku Najarajamartajiku. Wartangka wiltiyikingu ka miturringu, kayilapa wankarringu yanu. Ngaawana ngarripayi, nyawaya!, pakirringulura.” ");
INSERT INTO mpj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Warrinyjilu-jananya yarrarnu wajarnu, “Parna Kaliliyakutu pakarnuka maa yaninpa, kurranyi-nyurrampa. Ngurra palunyangkanyurra yanku nyaku, Jiijajju-nyurranya kurranyilu wajarnu jiingkanyurra nyakuraku. Wangka palunya-jananyanyurra wantikajalu yanku jakurljunku wangka-nintikajangka, Piijangkalurrju.” ");
INSERT INTO mpj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaya ngurlurringuka purtu kulirnu. Pirnkijanuya pakarnu tititipungkupayi ngurluwinti, ka walaya pinirringu. Martukajangka-jananyaya kutungka mirta wajarnu. ");
INSERT INTO mpj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jiijajpa Jaantingka yungunpa mitujanu wankarringu. Ka Miiringka Makatalamartajingkalu yutirringu, kurranyi. Martu karlkingka-jananya marla yutirringu. Miiringkalu palungka julyju Jiijajju malpukaja japan wulikaja payirnu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kayilapa Miiri palulu-jananya yanu nyangu, wangka-nintikajaraya yulapayi, Jiijajku mituku. ");
INSERT INTO mpj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wajarnu-jananya, “Nyangurna, wanka nyininpa.” Kulirnukaya paki kararnu. ");
INSERT INTO mpj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Palunyajanu Jiijajpa-pulanya yutirringu palumili wangka-ninti kujarrangka, ruutuwanapula ngurra kujupakutu yankupayi. Jiijajpa ngumpa kujuparringu jampa yutirringu-pulanya. Marlapula nintirringu pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Marlakupula Jarujalumukutu wala yanu. Ka wajarnupula-jananya, “Jiijajpaliju nyangu, wanka nyininpa.” Kulirnuya paki kararnuya wituka. ");
INSERT INTO mpj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Palunyajanu Jiijajpa-jananya palumilikajangka, lipin wulikajangka, wangka-nintikajangka yutirringu, jampaya ngalkupayi. Yutirringu-jananya ka wajarnu, jumajiya wantikajamili wangkakaja paki karalpayi, jumajiya Jiijajpa mirta ngangkulpayi, wankarriraku. ");
INSERT INTO mpj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wajarnu-jananya jilanya Jiijajju, “Yankunyurra parna kujupa kujupangka, ngurra parlparriwanangka ngayumili wangka-jananyanyurra wajala!, martungka yarnngangka. ");
INSERT INTO mpj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yiipi martuluya wangka palunya kulilku, palunyangka-jananyanyurra kalyungka jarrpajula! Palujanuya martu palukaja wankarriku, yiltaya wanka wulu nyinamalpa. Yiipiya martu kujupakajalu mirta kulilku, ngayumili wangka, mirtaya Mamakurnu ngurrangka nyinaku. Ngula Mamalu-jananya warrkilku yiyalku. ");
INSERT INTO mpj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Martuluya yiipi kulilku ngayukurnu wangka. Palunyangka ngayumili maparnparna-jananya yungku, yalyjirrjuya palyalkura. Malpuya, palyalu payira yiyalku, ka wangka kujupaya wangkaku, ngayurniya marninypungkuraku. ");
INSERT INTO mpj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jilaya manku maralu kanyilku, mirta-jananya pajalku. Yiipi ngayuku walyjalu palya karalku payijinpa jikilku, mirta miturriku, wanka nyinaku. Ngarnta maju ngarrinyjanpa ngayuku walyjalu maralu pampulku, palunyangkayilapa wankarriku. Jilanyaya yalyjirrju ngapinmalpa. Martukajaluya nyaku ka kulilku, ‘Yiltaya Jiijajmili maparn majuwinti nyininpa.’” ");
INSERT INTO mpj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Palunyajanu maaja Jiijajpa-jananya yarrarnu wangkangu, ka ngarnawarra yanu, Mamangkalu kujungka nyinakuraku. ");
INSERT INTO mpj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Palunyajanuya wangka-nintikajaya yanu ngurra parlparri, Jiijajmili wangkawinti. Nintilpayi-jananyaya palyalu, jumaji Jiijajju-jananya rakamanu, ngarnawarrajanulu. Palya-jananyaya ngarntapurlukakaja wankalpayi, ka malpu-jananyaya payira yiyalpayi. Martukajalu-jananyaya nyangu kulirnuya, “Yilta-lanyaya Mamakurnu wangka nintijuninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","3","Julyju mirta parna nyinapayi ngaangka, palunyangka kurranyi Mamamili wangkapurluka nyinapayikamu Mama ngarnawarrapurluka. Maparn kujuwintipula kujungka nyinapayi. Kujungkalupula parna ngaanya wulikaja ngapirnu, Mamamili wangkapurlukalu. ");
INSERT INTO mpj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","5","Wangkapurluka jiilu-lanya martukaja wanka kanyirni, ka nintini-lanya junga nyinakura Mamaku. Martukajaya layitikarti yankura kujungkarrini mungajarra, palunyayuru jii wangkapurluka layitiyuru-lampa nyinani, nyakurala kujungkarrini, palumili wangkala kulilkuraku. Wangkapurluka jii layitiyuru wulu-lampa nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Mamalu yirna kuju wajarnu junu yini Jaanpa, parra wajalkuraku, jii wangkapurlukaku, layitiyuruku. Mamalu jii Jaanpa junu wajalkuraku-jananya, ka martukajaluya jii wangkapurluka kulilkuraku jilanya, “Yilta wangkapurluka jii Mamamili kaja nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Martu karlki kujupaluya wajarnu, “Jaanpa jii wangkapurluka layitiyuru nyinapayi.” Wangka jilanya pakiwanaya wajalpayi. Jaanpa mirta jii wangkapurluka layitiyuru nyinapayi, kujupa wangkapurluka layitiyuru nyinapayi. Jaanju palunya-jananya wangkapurluka parra wajalpayi, martukajangka. ");
INSERT INTO mpj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wangkapurluka jiinya layitiyuru julyju Mamalu parnakutu kurtingu, martukajalula palunya yilta kulilkura Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yilta wangkapurluka jiilu parna ngaanya julyju ngapirnu, ka julyju parnakutu ngaakutu yanu nyinapayi. Kayilapaya martukajalu palumili wangka kulira junkupayi, mirtaya kulilpayi Mamamili walyja. ");
INSERT INTO mpj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Palumili walyjakajaluya Juwukajalu ngurra kujungkaya nyinapayi. Jiikajaluya mirta kulilpayi, palunya Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Palujanuya karlkilu kulirnu, “Yilta, Mamamili walyja ngaanya.”, ka-jananya jiilu wangkapurlukalu walyjamanu, ka Mamamiliraya jijikaja nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Martulu yipilukamu mamalu palumili jijikaja mankuni. Mirta Mamalu jijikaja mankuni martuyurulu, walyjaluwiyaju kulira ka palumili jijikaja walyjamani. Jilanya-lampa yilta Mama nyininpa, jijikajaku palumili walyjakajaku. ");
INSERT INTO mpj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yiltangulyu wangkapurluka jiinya yanurni marturringuka, nyinapayi-lanyaju. Palu-lampaju nyarrurringu ka kunyjunyurringu-lampaju ka jungalu-lanyaju Mamamili wangka nintilpayi. Palunyalaju kurulu nyangu ka kulirnulaju, “Yilta ngaanya maaja maju, Mamamili kaja.” ");
INSERT INTO mpj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Julyju Jaanju-jananya wajarnu, jii wangkapurluka. Jilanya wajarnu, “Martu jiinyaya nyawa! Wangkapurluka palunyarna-nyurranya wajalpayi, jiinya yankurni. Palukurna-nyurranya wajalpayi, ‘Palunyarni ngayungka marla yankurni, maaja maju nyinaku, ngayurna mirta maaja maju nyinani. Palunga maaja majuminyirri yilta nyinaku. Ngayurna jiji japuwarta nyinapayi, palunyanga kurranyi maaja maju nyinapayi.’” ");
INSERT INTO mpj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Palunyangka ngayulurna-nyurranya Jaanju wajarni, Jiijajmili wangka-nintilu. Maaja maju jiinya-lampa pukurlpa nyinani, ka wanka-lanya kanyirni ka kunyjunyu-lampa wululu ngapini. ");
INSERT INTO mpj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Julyjura Mamalu yungu Muujajpa palumili luwu, martukaja-jananya nintijulkuraku. Ka kuwarri-lampa Mama kunyjunyurringu Jiijaj Kurayijpa kurtingu, jampala kulilku Mamalu-lanya wanka kanyilku. Yilta-lampa Mama jiinya kunyjunyurringu. ");
INSERT INTO mpj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mama jiinyaya mirta martulu nyangu kurulu, paki. Palumili kajawiyajula martulu nyakupayi maparn kujuwintipula kujungka nyinapayi. Mamalu jiilu kaja jiinya kurtingu ka yutirringu-lanyaju. ");
INSERT INTO mpj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tawun Jarujalumungka-jananyaya Juwukajalu maajakajalu kurtingu yatilykajakamu Lipayiku wangkapurlukakaja, yankuraya Jaanpa japilkura. Jilanyaya japirnu, “Kajin Kurayijpa nyinani?” ");
INSERT INTO mpj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jaanju-jananya jungalu wajarnu, “Pakiwananyurra kulini, mirtarna Kurayijpa nyinani. Mirtarni ngayu kurtingkuraku Mamalu jamartapungu, paki.” ");
INSERT INTO mpj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jaanpaya yarrarnu japirnu jilanya, “Ngana nyuntu nyinani? Mayitpin kuurti pakarnu mitujanu, mayitpin Yilayija? Julyjun nyinapayi, Mamamili jakurlpurluka?” Palujanu wajarnu-janampa, “Paki!” Karaya yarrarnu japirnu, “Mayitpin mitujanu kuurti kujupa pakarnu, Mamamili kujupa, jakurlpurluka?” Palujanu wajarnu, “Paki!” ");
INSERT INTO mpj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Wajala-lanyaju! Nganalunta maajalu wajarnu, martukajangka wangka parra wajalkuraku? Wajala-lanyaju maaja kujupakajangkalaju yankura jakurljulkura.” ");
INSERT INTO mpj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jaanju-jananya jilanya wajarnu, julyju Mamamili jakurlpurlukalu Yayijayalu wajarnu jilanya, “Ngayulurna-jananya pujimanwana martukajangka parra wajalpayi jilanya, ‘Maajakuranyurra palya nyinaranku wanalkuralunyurra jungalu. Yiwarrangkaluya wanalkura palyalu. Maajangampa-nyurrampa ngula warinykatiku nintijulkuraku-nyurranya.’” ");
INSERT INTO mpj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Palunyakajaluya yarrarnu Jaanpa japirnu, “Nyuntulu-lanyajun wajarnu, mirtan Kurayijpa, mirtan Yilayija, mirtan Mamamili kujupa jakurlpurluka nyinani. Purtulaju kulini. Maaja nganalunta wajarnu, martukaja-jananyan kalyungka jarrpajunkura?” ");
INSERT INTO mpj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jaanju-jananya jilanya wajarnu, “Ngayulurna-jananya martukaja kalyungka jarrpajunkuni, jungaya nyinakuraku, ka kujupalu-jananya maaja majulu wanka kanyilku. Maaja majuku jiikunyurra ngurrpa. ");
INSERT INTO mpj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngayurna pakirriku, marla maaja maju palu nyinaku. Kurayijpa-lampa jii yankurni, maaja majuminyirri, karnara ngayu palumili warrkamupurluka.” ");
INSERT INTO mpj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wangka jilanya Jaanju-jananya wajarnu, tawun Piijaningka karrungka Juutanja kakarrakarti. Jiingka-jananya karrungka Jaanju martukaja jarrpajunkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yungun kujupangka Jaanju Jiijajpa nyangu ngalyarnirni yankupayi, ka-jananya martukaja nintirnu ka wajarnu jilanya, “Jiinyaya nyawa! Mamalu ngarnawarrapurlukalu kurtingu walykukaja-lampa warningkuraku, martukajaku wulikajaku. Jiinga mirtayirtiyuru. Julyju martukajaluya jiipu mitu pungkupayi, kaya palu mirtayirti yatilyja yungkupayi, Mamalu-janampa walykukaja warningkuraku, Jilanyayuru Jiijajpa miturriku mirtayirtiyuru. ");
INSERT INTO mpj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kulilaya! Wangka julyjurna-nyurranya wajarnu jilanya, ‘Palunyarni ngayungka marla yankurni, maaja maju nyinaku. Ngayurna mirta maaja maju nyinani, palunga maaja majuminyirri yilta nyinaku. Ngayurna jiji japuwarta nyinapayi, palunyanga kurranyi maaja maju nyinapayi.’” ");
INSERT INTO mpj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jaanju-jananya yarrarnu wajarnu, “Jiikurnara julyju ngurrpa nyinapayi. Kulilpayiwiyajurna jilanya, ‘Mamalu ngula Kurayijpa kurtingkuraku, julyju jamartapungu.’ Ka Mamalurni nintijunu jii Kurayijpa, jamparna jiinya kalyungka jarrpajunu. Jilanyanyurra Yijurilmili marlajanukajalu yilta kulilkura palunga Kurayijpa, Mamamili.” ");
INSERT INTO mpj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Palujanu Jaanju-jananya yarrarnu wajarnu, “Martu jiinyarna kalyungka yikijunu, jarrpajunkuraku, kayilaparna nyangu Mamamili Kuurti ngarnawarrajanu yankupayi turruyuru. Tiputingukalu jiingka martungka jarrpangu Kuurti, palujanu Kuurtiwinti yankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Palunyangkarnara ngurrpa wulu nyinapayi, jiinya martuku, mirtarna kulirnu Kurayijpa, Mamamili. Julyju Mamalurni wajarnu martukajarna-jananya kalyungka jarrpajulkuraku. Palujanurni wajarnu jilanya, ‘Nyuntulun ngula Mamamili Kuurti nyaku, yankurni ngarnkajanu kalu martu kujungka jarrpaku, palujanu martu jii Kuurtiwinti yanku. Jaanjurni nyuntulu kulila! Martu jiilu-jananya martukajangka Kuurti Mamamili jarrpajunmalpa.’ Wangka jiinyarna kulirnu, ka yilta marlalurna kulirnu martu jiilu-jananya Kuurti jarrpajunmalpa, Kurayijju Mamamililu. ");
INSERT INTO mpj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yiltarna nyangu Mamamili Kuurtilu yanu jarrpangu martu jiingka, palunyangka ngayulurna-nyurranya wajani, yilta ngaanya martu Kurayijpa, Mamamili kaja!” ");
INSERT INTO mpj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Karrpu kujupangkaya Jaanku wangkapurluka kujarrakamu Jaanpa yikipayi. ");
INSERT INTO mpj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kayila Jiijajpa nyangu wati yankupayi, ka Jaanju jilanya wajarnu, “Jiinya wati yaninpa palunga Mamamili mirtayirtiyuru. Ngula mirtayirtiyuru miturriku, ka martukajaku-lampa walykukaja warningku.” ");
INSERT INTO mpj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kulirnupula kalupula wanarnu Jiijajja. ");
INSERT INTO mpj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ka-pulanya pijurringu nyangu Jiijajju, kayila-pulampa wajarnu, “Nganakurnipulan wanarni?” ");
INSERT INTO mpj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wajarnurapula, “Nintipuka! Wanyjangkan ngurrangka nyinani?” Ka wajarnu-pulanya jilanya, “Kujungkala yanku kayilapa nyakunpula ngayuku ngurra.” Palujanuya ruka kujungka yanu, palumili ngurrangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ngurra jiingka-jananya nyinapayi kujungka, yirna yini Yanturu, Jayimun Piijaku marlaju. ");
INSERT INTO mpj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Palujanu Yanturulu yanu manu, palumili kurta, Jayimunpa, wajalkuralu. Nyangukalu wajarnu jilanya, “Ngayunjulaju nyangu Kurayijpa, Mamalu julyju jii jamartapungu kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yanturulu winirnu katingu Jiijajkartilu. Ka Jiijajju nyanguka wajarnu, “Nyuntun Jayimunpa, Jaanku kaja. Yini kujupan nyuntu kuwarri nyinaku, yini ‘Jiipajpa’” Jilanya kiriki wangkawintilu yini palunya wajarni, “Piija.” ");
INSERT INTO mpj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jampa yaarlipalarringu, Jiijajpa parna Kaliliyakarti yankuraku, kulilpayi. Palujanu Pilapu yanu nyangu, ka wajarnura, “Yankurali kujungka!, nyuntujun ngayumili wangka-ninti nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilapunga Pijayitamartaji, ka Yanturukamupula Piija jiipurlukalurrju. ");
INSERT INTO mpj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Palujanu Pilapulu yanu manu Najaniyalpa, kalu wajarnu, “Nyangulaju Kurayijpa yini Jiijajpa Najarijmartaji, Juujapku kaja. Julyju yilta Muujajju wakarnu mirlimirlingka palunyarni yankuraku, kaya Mamamili jakurlpurlukakajalulurrju wakarnu palunyarni yankuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Najaniyalju wajarnu, “Najarijmartajiya martukaja walyku nyinani, mirta kuju jiipurluka kunyjunyu nyinani, paki.” Pilapulura wajarnu, “Yankurali nyakura!” ");
INSERT INTO mpj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tiwarnipula yankupayi, ka Jiijajju-pulanya nyangu, ka-jananya karlki kujupangka wajarnu, “Jiinyaya nyawa! Juwu jungaminyirrirni yankuni, mirta jii mayunyju, paki.” ");
INSERT INTO mpj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Palujanupula yanu kujungkarringu, Jiijajmapungka wangkapayiya. Kayilapa Najaniyalju japirnu Jiijajpa, “Yaalurnin yintarnu?” Kara Jiijajju wajarnu, “Pilapulunta walanu, ka kurranyilurnanta nyangu walyjingkan nyinapayi.” ");
INSERT INTO mpj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Najaniyalju kulirnu, “Yiltarna walyjingka nyinapayi.” Kayila kuru pakarnu Najaniyaljura wajarnu, “Nintipuka! Nyuntun yilta Mamamili kaja. Yijurilmili marlajanukajaku-lampajun maaja maju nyuntu.” ");
INSERT INTO mpj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiijajjulu wajarnu, “Nyuntulurnin kulini Mamakurnara, jumajirnanta jungalu wajarnu walyjingkan nyinapayi, palujanurnin kulini Mamamilirnara walyja. Nyuntulun ngula nyaku ngayulurna yalyjirrpa kujupa kujupa ngapini, maparn majuwintilu.” ");
INSERT INTO mpj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jiijajju-jananya yarrarnu wajarnu, “Ngayulurna-nyurranya yilta wajarni. Ngulanyurra nyaku ngarnka wupunarriku, kayilarna ngayu martuku yarnngaku marlpa parnangka nyinaku kaya Mamamili wikarrukaja ngarnawarrajanu tiputikurniya ngayungka, kaya marlaku takalku.” ");
INSERT INTO mpj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Karrpuparakungkaya kujungkarringu martukaja, wantikamupula yirna marrirtirrikijalu. Palukuya kujungkarringu, tawun Kayinangka, parna Kaliliyangka. Jiijajmili yipilurrju jiingka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Julyju-jananyaya japirnu Jiijajmapu, yankura-jananya jiingka nyinakura. Kaya warinykatingu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kujungkaya yarnnga jikira nyinapayi, ka-janampa wama pakirringu. Kalu Jiijajja palumili yipilu wajarnu, “Wama pakirringu.” ");
INSERT INTO mpj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kayilapa Jiijajjura wajarnu, “Yipi! Mirtarni wajala yuwa!, ngayulurna walyjalu kulilku ka yalyjirrju ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Palujanu yipilu-jananya wajarnu warrkamupurlukakajangka, “Jampa-nyurranya jiilu wajalku, ngapilkunyurra.” ");
INSERT INTO mpj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Turampu jikij wulikaja yikipayi kalyuparni, pitulpintiyuru turampukaja. Julyju turampu palukaja kalyuwinti yikipayi. Kalyu jiiwintilu-ngkuya Juwukajalu mara waajamulpayi, Jilanya luwu-janampa nyinangu. ");
INSERT INTO mpj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jiijajju-jananya warrkamupurlukakaja wajarnu, “Turampu jiikajaya kalyu yintila pilamapula!” Yintirnuya pilamapurnu. ");
INSERT INTO mpj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yarrarnu-jananya Jiijajju wajarnu, “Yintiraluya wirningka kawa!, turlkupurluka maajakarti.” Yintirnuraya katingu yungu. ");
INSERT INTO mpj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Palujanu maaja jiilu jikirnu ka yajirnu, wamaminyirri. Ngurrpara nyinapayi kalyu jiiku wamarriraku. Warrkamupurlukawiyajuya ninti nyinapayi kalyu jii wamarringu. ");
INSERT INTO mpj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Mirrangura jiiku yirnaku, marrirtirrikijalu kara wajarnu, “Karlki kujupaluya-jananya yunginpa kurranyilu wama kunyjunyuminyirri, palujanu marlaluya-jananya yungin wama puta. Ka nyuntulu-lanyajun wama kunyjunyu kurranyilu yungu, palunyangka ngaanga marlawana wama kunyjunyuminyirri-langku yungkuni.” ");
INSERT INTO mpj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jiijajju yalyjirrju jilanyayuru wama ngapirnu, tawun Kayinangka, parna Kaliliyawana. Mirta palunyayuru julyju Jiijajju yalyjirrju ngapirnu, paki. Kuwarriwiyaju yalyjirrju ngapirnu. Jilanyalu yalyjirrju ngapirnu kaya palumili wangka-nintikaja kuru pakarnu, kaya kulirnu, “Yilta ngaanga Mamamili, maparn majuwinti.” ");
INSERT INTO mpj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Palujanuya Jiijajmapuya yanu tawun Kapaniyamukarti palumili yipikamu palumili marlajukaja, ka palumili wangka-nintikaja. Jiingkaya nyinapayi karrpuparakungka. ");
INSERT INTO mpj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Turlku Pajuwupa ngamurripayi, palunyangka Jiijajpa yanu tawun Jarujalumkarti. ");
INSERT INTO mpj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Palungka warinykatingu ka yanu Juwumilingka jaaji majungka kurrungu. Ka jiingka-jananya nyangu jaajingka majungka jiipukajakamu pulukukaja, turrukajalurrjuya jalamulpayi. Manikajalurrjuya jiingka jiinyjamulpayi. Mirtaya jiingka jalamulngara, ngurra kujupangkaya jalamulngara. Mirtaya manilurrju jiingka jiinyjamulngara. ");
INSERT INTO mpj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wiipuyuru ngapirnu ka Jiijajju-jananya warrkirnu kurtingu jaaji majujanu, yirnakaja, jiipukaja, pulukukaja. Ka tiipulkajalurrju-janampa maniwinti mankura warningu kurtingu, mani-janampa punkarnunirra. ");
INSERT INTO mpj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wajarnu-janampa turrupurlukakajangka, “Mawuya kati!, mirtanyurra ngayumili Mamamilingka mayangka jalamunma!, mirta ngaanya tuumaya nyinani.” ");
INSERT INTO mpj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Palumili nintipurlukakajaluya Jiijajpa nyangu kaya kulirnu jilanya, julyju Tayipitju mirlimirlingka wakarnu jilanya, “Mama, ngayulurna kulirni, nyuntumili jaajingkantaya marninypungkuraku, mirtaya pinyijunkura. Ngayulurna jilanya murlpirrjuminyirri kulirni.” ");
INSERT INTO mpj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Palujanuya jaajipurluka maajakaja yanurni yikipayi karaya Jiijajpa japirnu, “Mayitpi Mamalunta jilanya wajarnu, warrkira-jananyan kurtingkuraku, mayitpi paki. Kuwarri-lanyajun nintijunku yalyjirrju kujupa kujupa ngapilkura, nyakuralaju kulilkura nyuntun Mamamili, jumaji Mamalunta wajarnu.” ");
INSERT INTO mpj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jiijajju-janampa wajarnu, “Yiipi jaaji ngaanyayurunyurra warlangkunirra, palujanu ngayulurna marlaku ngapilku, karrpu yupalja.” ");
INSERT INTO mpj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Karaya maajakajalu wajarnu, “Martuluya yarnngalu ngaanya rawalu ngapirnu, puuti jikij yiiyangka, kayilapan mirta nyuntulu kujulu marlaku ngapilku, karrpu yupalja, paki.” ");
INSERT INTO mpj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jiijajju-jananya wangka palunya kujupakarti wajarnu jilanya, palunyakajaluya Jiijajpa ngula pungkura miturntankura, palujanu karrpu yupalja marlaku wankarriku. ");
INSERT INTO mpj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngula Jiijajpa mitujanu wankarringu, palunyangka wangka palunya jaajiyuru wajalpayi, kaya palumili wangka-nintikajalu kulirnu nintilu, “Yilta wangka palunya yiltarringu, karrpu yupalja wankarringu.” ");
INSERT INTO mpj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jarujalumungka jiingka turlku Pajuwupangka Jiijajpa nyinapayi, palunyangkaya Jiijajpa yarnngalu nyakura kaya, kulilpayi, “Mamamili palunya”, jumaji yalyjirr kujupa kujupakaja ngapilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Ka palujanuya nyinangu ka kulirnu, “Mirta jiinya Jiijajpa Mamamili, paki.” Jiijajju nintilu kulilpayi, “Jiikajajuya pukurlarringu ka marlakurniya paki kukani.” Palujanu mirta-jananya Jiijajju yuti wajarnu, “Ngayu Mamamili nyinani.” ");
INSERT INTO mpj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yirna Nikatimajpa Paraji nyinapayi, Juwuku-janampa maaja. ");
INSERT INTO mpj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jiilu yanu mungajarra Jiijajjalu wangkakijalu. Jilanyara wajarnu, “Nintipuka! Ninti-lajungku nyuntunta Mamalu ngarnawarrapurlukalu kurtingu, jumajin nyuntulu yalyjirrpa kujupa kujupa ngapilpayi, Mamamili maparnwintilu.” ");
INSERT INTO mpj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jiijajjura wajarnu, “Yiltarnanta wajarni. Martukajanyurra nyunturtinpa yarralku yutirriku, kayilapanyurra Mamamili walyjarriku nyinaku. Jiikajawiyaju Mamalu ngampurrju kanyirni.” ");
INSERT INTO mpj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ka Nikatimajpa ngunjularringu, kara wajarnu, “Yaalula martukaja julyjujanukaja yarrara yutirrira? Mirtala yipingka yarralku jarrpaku, ka yarralku yutirriku.” ");
INSERT INTO mpj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Wajarnura jilanya Jiijajju, “Yiltarnanta wajarni. Mamamili Kuurtilu jarrpara ka walyjamanin, jampa kalyungkaya jarrpajunku. Palunyajanuwiyajuya Mamakuraya walyjakaja kujungka nyinaku. Jiikajawiyaju Mamalu ngampurrju kanyirni. ");
INSERT INTO mpj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jiji japuwarta yipilukamu mamalu maninpa, ka Mamamili walyjakaja palumili Kuurtilu walyjamanin. ");
INSERT INTO mpj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ngayulurnanta Jiijajju palunya wajarnu, yarralkunyurra yutirriku, mirtan nyuntu ngunjularrira nyinama! Mamamili Kuurti jungalu kulila! Nintilkurnanta jilanya. ");
INSERT INTO mpj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wangalpa kulila! Mayiti wirrirlijanu wangkinpa, mayiti ngamujanu wangkinpa. Martulula purtu kulirnin, wanyjajanu wangkinpa? Palunyayurula wangalyuru purtu kulirni, jampa Mamamili Kuurtilu martungka jarrpani ka walyjamanin.” ");
INSERT INTO mpj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikatimajjura wajarnu, “Yaalu-lanya Mamamili Kuurtilu walyjamanin?” ");
INSERT INTO mpj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kara Jiijajju wajarnu, “Nyuntun nintipurluka maju nyininpa, Juwukajaku nintipurluka. Nyuntulun wangka jii nintilu kulilngara. ");
INSERT INTO mpj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yiltarnanta jilanya wajarni. Nintiluliju Mamakamulu wajalpayi, ka-linyajuyan Juwukajalu kulira junkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngaangkarna-nyurranya parnangka martumili wangka parra wajalpayi, kanyurra kulira junkupayi. Palujanu yaalunyurra Mamamili ngurraku wangka kulilku? Yilta wangka jiinyalurrjunyurra kulilku junku. ");
INSERT INTO mpj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Martuya mirta Mamamili ngurrakutu yanu, kujuwiyajurna ngurra jiiku ninti, martu yarnngaku marlparna. Jiijanurna yanurni parnatu.” ");
INSERT INTO mpj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mitunyjarrilu Muujajju pujimanwana julyju jilayuru yayinjanu ngapirnu, ka wartangka wiltijunu. Palunyayururniya ngayu wartangka wiltijunku, martu yarnngaku marlpa. ");
INSERT INTO mpj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Palunyangkarna wartangka ngayu wiltiyikiku, miturriku, martu wulikajaku. Yiipirniya martulu kulilku, ngayurna Mamamili, palujanuya wulu wanka nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mama ngarnawarrapurluka-nyurrampa martu wulikajaku layikamuminyirri nyininpa, kayilaparni palumili kaja kuju kurtingu. Martulurninyurra ngayu yilta kulilku, ka-nyurranya mirta Mamalu ngula warrkilku kurtingku, kanyurra wanka wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mamalurni kaja palumili kurtingu martukajarna-nyurranya wankalkura, mirtarni kurtingu martukajarna-nyurranya ngula kuutja wajara kurtingkura, walykukajawinti. ");
INSERT INTO mpj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yiipi martulurninyurra palumili kaja kulilku, mirta-nyurranya Mamalu kuutja wajalku kurtingku. Yiipi martulurninyurra wululu kulira junku, Mamalu jiiyuru kuwarri kulilku junku, ka ngula kuutja wajalku kurtingku, jumajirni ngayu palumili kaja kujuwiyaju mirta kulirni. ");
INSERT INTO mpj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wangka ngaanyaya kulila! Yiipi martukajanyurra jilanya nyinaku, Mamalu-nyurranya ngula kuutja wajalku kurtingku. Mamalurni kurtingu parna ngaakutu, layitiyururna-nyurrampa nyininpa. Martukajaya kujungkarrini layitingka mungajarra, palunyayururninyurra layitiyurungka martukaja kujungkarriku, ngayumili wangkanyurra kulilkuraku. Martu karlkilunyurra mirta ngayumili wangka kulirni. Mungangkayurunyurra nyininpa, mirtanyurra layitikarti yankura kujungkarrini. Mungangkayurunyurra nyinamalpa jumajinyurra, walykunyurra wulu ngapirni. ");
INSERT INTO mpj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yiipinyurra karlkilu walyku ngapilku, palujanu ngayungkamarranyurra layitingkamarra nyinaku, walyku wulunyurra ngapilku, ka mungajarrayurungkanyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yiipinyurra karlki kujupa junga nyinaku Mamaku, palujanu ngayungkarninyurra layitiyurungka nyinaku. Kaya martu kujupalu nyakuya ka kulilku, “Yiltaraya Mamaku jiikaja junga nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Palujanuya Jiijajkamu palumili wangka-nintikajaya yanu parna Juutiyakarti. Jiingkaya nyinapayi ka-jananya palumili walyjakaja nintijulpayi. Ka martu kujupakajalurrju-jananya Jiijajju nintijulpayi ka kalyungka-jananya jarrpajunkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kayilapa-jananya tawunu Yananja Jaanju martukaja kalyungka jarrpajulpayi. Tawun jiinya Yananpa, tawun Jilamangka kinti nyinapayi. Jiingka-jananya Jaanju martukaja jarrpajunkupayi, kalyu majuwartangka. Wululuya martukaja yankupayi Jaankarti kulilkurakuya, ka-jananya kalyungka jarrpajunkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Palujanu ngula Yirutju wajarnu-jananya palumilikajangka yankuraya Jaanpa mankuraku, kaya jiilkarti kangkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jaanmili wangkapurlukakajaya yanu kujungka, kaluya Juwumili maajangka wangkapayi jilanya. Jaanmiliwanaya kalyungka jarrpajunkuraku, ka kujupalu wajalpayi Jiijajmiliwanaya-jananya jarrpajunkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Palunyajanuya Jaanmili wangkapurlukakaja yanuluya Jaankarti, wajarnu jilanya, “Nintipuka! Yirna palunya julyjupulan kujungka parra yankupayi karru Juutanja kakarrakarti. Nyuntulu-lanyajun wajarnu paluku, yirnaku. Palunyalu-jananya kuwarri kalyungka jarrpajuninpa martukaja. Martuluya wulikaja yaninpa palukarti.” ");
INSERT INTO mpj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka Jaanju-janampa wajarnu, “Martukajaya pukurlarrinpa jiiku yirnaku, jumaji Mamara pukurlarrinpa. ");
INSERT INTO mpj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyuntunpanyurra ninti wangka paluku, jilanyarna-nyurranya wajalpayi, ‘Mamalurni mirta ngayu julyju jamartapungu kurtingkuraku, mirtarna Kurayijpa nyininpa. Ngayurni Mamalu junu, kurranyilurna-nyurranya wajalkuraku, ka marlawana Kurayijpa maaja maju nyinaku. Jiijaj palunya Kurayijpa nyininpa.’” ");
INSERT INTO mpj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jaanju-janampa yarrarnu wajarnu, “Wangka ngaanyaya japuwarta kulila! Yirnapula nyupararra marrirtirriraku nyinakija yikiku. Wantira jiinya yirnaku nyupa yikiku. Kara makurnta pukurlpa yikiku, ka yirna jiinya nyupawinti martukajangka-jananya wangkaku. Makurntayururna jiiyuru ngayu Jaanpa pukurlpa nyininpa Jiijajku, jampa-jananya yirna nyupawintiyuru Jiijajpa martukajangka wangkani. ");
INSERT INTO mpj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Palujanu-janampa maaja Jiijajpa nyinakura, ngayurna mirta maaja nyinaku, nintirnurna-jananya pakirringu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jaanju-janampa yarrarnu wajarnu jilanya. “Maaja maju jii ngarnawarrapurluka yanurni Mamamili maaja majuminyirri, karna ngayu parnapurluka nyininpa, martumili wangkawiyajurna wajani ngaangka parnangka. ");
INSERT INTO mpj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jiingka ngarnawarra nyinapayi ka kulilpayi Mamamili wangka, palujanu yanurni parnakarti ka martukajangka-jananya parra wajalpayi. Ka kuliraya junkupayi palumili wangka. ");
INSERT INTO mpj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yiipi martulula kulilku Jiijajmili wangka, ka Mamamili wangkalurrjula kulilku. Jilanyala kulilku, ‘Mamalu yilta wajarni, mirta paki kajarni.’ ");
INSERT INTO mpj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mamalu kurtingu Jiijajpa, ka jiilu-jananya Mamamili wangka parra wajalpayi, jumajilu Mamalu palumili Kuurti jarrpajunu, ka palumili maparnwintilu-jananya parra wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamara jiiku palumili kajaku layikamuminyirri nyininpa. Jiinyawiyaju kuju maaja maju junu, ngarnkapurlukakajakukamu parnapurlukakajaku, ka malpukajakulurrju. ");
INSERT INTO mpj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yiipi martulu jiinya kaja kulilku Mamamili, palujanu martu wanka wulu nyinaku. Yiipi martulu kaja jiinya mirta kulilku Mamamili, palujanuyila mirta wanka wulu nyinaku. Mamalu jiinya ngula warrkilku kurtingku, kuutja.” ");
INSERT INTO mpj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Martuluya yarnngalu kulira Jiijajmili wangka kaya walyjakaja nyinama. Ka palunyakaja-jananyaya kalyungka jarrpajunma. Mirta Jiijajju-jananya kalyungka jarrpajunkupayi, palumili wangka-nintikajaluya-jananya jarrpajunkupayi. Ka Jaanju-jananya yupalwiyaju jarrpajunkupayi ngurra kujupawana. Parajikajaluya jakurlpa kulirnu jilanya, Jiijajmili walyjakajaya yarnngarringu, ka Jaanmili walyjakajaya yupalarringu. Jiikajaraya Parajikaja wirrilyirringu Jiijajku. ");
INSERT INTO mpj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Jiijajju jilanya kulirnuka yanu palunyakajangkamarra kayilikarti parna Jamiriyawana, parna Kaliliyakarti. ");
INSERT INTO mpj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Parna Jamiriyawanaya yanu palumili wangka-nintikajalurrju ka tawun Jayikangkaya kinti nyinapayi. Palungkaya tawunja yawujayiti yanu kalyukarti, mitunyjarripurlukakura Jayikapku. Jiingka kintira parnawiyaju nyinani, mitunyjarripurlukaku Juujapku. Jayikapjura julyju parna jii yungu. ");
INSERT INTO mpj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jiingka kalyungka Jiijajpa kintirringu ka nyinapayi, wiilja, karrpuwartirringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jiijajmili wangka-nintikajaya yanu tawunkarti, mirrkaya payamulkuraku, Jiijajpaya junu yanu, kuju nyinapayi. Ka wantilu Jamiriyapurlukalu yankupayi, kalyu mankuraku. Kintirringu kara Jiijajju japirnu jilanya, “Kalyurni yuwa!” ");
INSERT INTO mpj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kara wanti jiilu Jiijajku wajarnu, “Nyuntun Juwu nyininpa, ngayurna Jamiriyamartaji. Mirtarni ngayu japilkura, jumaji jilanya luwu-nyurrampa nyinani.” Juwukajaluya mirta Jamiriyamartajiku wirningka jikirni. ");
INSERT INTO mpj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jiijajjura wajarnu, “Nyuntulun mirta kulini jilanya. Mamalunta kujupayuru yungkuraku kulini. Ngayulurnanta japini kalyuku. Nyuntujun ngurrpa, mirtarnin kulirni, ngayulungarnanta kujupa kalyuyuru yungkujaku, kalyu wankalpayi.” ");
INSERT INTO mpj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wantilura wajarnu, “Nyuntun kartakuparni nyininpa. Kalyu ngaanya wirrirli kaninyjarra nyininpa. Wanyjangkan manku kalyu jii wankalpayi? ");
INSERT INTO mpj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mitunyjarrilu Jayikapju-lampa kalyu ngaanya junu yanu. Palunyamililuya jijikajalu ka pulukukajalurrjuluya jikilpayi. Jayikappa-lampa maaja maju mitunyjarripurluka nyinapayi. Kalyu ngaanya yalyjirrju jawarnu manu, ka nyuntulun yalyjirrparnilu kulirni. Wanyjangkan kalyu wankalpayi manku?” ");
INSERT INTO mpj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Jiijajjura wajarnu, “Kalyu ngaanya wiilja martulu jikilku yarralku marrkurriku. ");
INSERT INTO mpj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ka kalyu wankalpayi ngayulurna-nyurranya yungku. Jikilkukanyurra mirta yarralku marrkurriku, marrkuparniyurunyurra nyinaku. Kalyu palunya martungka ngururrpa ngarriku jurnuyuru, mirta pakirriku. Kanyurra martu kalyuyuruwinti palunyawinti wulu wanka nyinamalpa.” ");
INSERT INTO mpj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka wantilura wajarnu, “Kalyurni jiinya yuwa!, kalyu pakirrijakungkamarra, marlakurna ngaakutu yankujakungkamarra.” Jii wantilu purtu kulirnu, “Nganarni yungkuraku wajarnu? Wajarnuju kalyu wankalpayi.” Jiijajju palunya kalyu wankalpayi yungkuraku, jiinga kujupakarti wajalpayi, wanka wulu nyinakuraku, jampa Jiijajpa kulilkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jiijajjura wajarnu, “Nyuntumili nyupa yarra marra!, palujanupula yarra ngaakarti!” ");
INSERT INTO mpj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka wantilura wajarnu, “Mirtarna nyupa kanyirni.” Jiijajjura wajarnu, “Yuwa yiltalun wajarnu. ");
INSERT INTO mpj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Yirna payip wulikaja-jananyan junu yanu. Kuwarrin yumu nyininpa yirna kujupangka, mirta walyja nyuntumili. Wangka jilanyarnin yiltalu wajarnu, nyupaparnin nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wantilura kulilpayi, “Yaaluju ngaanya ninti?, yalyjirrju kulini. Mayitpi ngaanya Mamamili jakurlpurluka nyinin.” Kara wantilu wajarnu, “Yintarnirnanta nyuntu, mayitin Mamamili jakurlpurluka. Wangka kujuparnanta wajalkura mayiti nyuntu ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mitunyjarri-lampajuya Jamiriyamartajilu, ngaangka yapungka Mama ngarnawarrapurluka marninypungkupayi. Kanyurra nyunturtinju Juwukajalu wajarni, Mamala marninypungkura tawun Jarujalumungka. Wanyjangkaminyirrila jii Mama marninypungkura?” ");
INSERT INTO mpj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jiijajjura wajarnu wantiku, “Kulila! Pakiwanan kulini. Ngulala mirta Mama marninypungku ngaawanakamu Jarujalumuwana. ");
INSERT INTO mpj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyuntunpanyurra Jamiriyamartaji ngurrparanyurra Mamaku pakiwananyurra marninypungkuni. Ngayunpalajura Juwukaja ninti Mamaku ngarnawarrapurlukaku, palujanulaju nintilu marninypungkuni. Kulirninpalaju Juwukajaku-lampaju nyinani, Kurayijpa walyja. Jiilu-lanya wankanu martu wulikaja, wanka wulula nyinakuraku. ");
INSERT INTO mpj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kuwarrila Mama marninypungku, palumili Kuurtilu-lanya nintilku jungala Mama marninypungkuraku, ngurra kujupa kujupawanalurrju. Mamalu kulini jilanyala martukajalu jungalu Mama marninypungkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mamala mirta nyakuni kurulu, mirta martuyuru nyininpa. Palumiliwiyaju Kuurtilu-lanya nintini, kala Mama jungalu kulira marninypungkuni.” ");
INSERT INTO mpj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wanti jiilura Jiijajku wajarnu, “Nintilurna kulini, Kurayijpa kuwarri yankurni, julyju Mamalu jiinya jamartapungu kurtingkuraku. Palunyarni yanku Kurayijpa ka nintijulku-lanya wanyjalpala nyinakuraku ngula.” ");
INSERT INTO mpj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiijajjura wajarnu, “Ngayurna palu Kurayijpa nyininpa. Kurayijparnanta wangkinpa.” ");
INSERT INTO mpj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kayilaparniya Jiijajmili wangka-nintikaja marlaku yankupayi. Ngunjularringuya kulirnu, “Nyaakulu Jiijajpa wanti palunyangka wangkinpa?” Yakaya ngarapayi, mirtaluya wajarnu Jiijajja. ");
INSERT INTO mpj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Palujanuyila wantilu jiilu junu yanungku kartaku, ka marlaku yanu tawunkarti. Ka-jananya tawunmartajingka martukajangka jakurljunu jilanya, ");
INSERT INTO mpj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Yirna nyarralurni wajarnu yaalurna ngayu julyju nyinapayi, mayitpi palu Kurayijpa nyininpa. Yankurala kujungka nyakura.” ");
INSERT INTO mpj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ka tawunjanuluya Jiijajkarti yanu. ");
INSERT INTO mpj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nyarra-jananya wantilu jakurljulpayi tawunja, palunyangkaya Jiijajmili wangka-nintikajalu wajarnu Jiijajja jilanya, “Nintipuka! Mirrka ngala!” ");
INSERT INTO mpj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka Jiijajju-jananya wajarnu, “Mirrkarna kanyirni. Mirrkayurukunyurra paluku ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Japirnu-ngkuya, “Nganalura katingu mirrka yungu?” ");
INSERT INTO mpj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jiijajju-janampa wajarnu, “Yiipi martulu mirrka ngalku, palunyangka wirla ngarrurtarriku. Palunyayururna ngayu ngarrurta nyininpa Mamakurna warrkamu ngapilkura. Palumili warrkamurnara wululu ngapilku pakirrikurakuminyirri, jumaji Mamalurni jii wajarnu. ");
INSERT INTO mpj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jilanyala wajarni, ‘Ngulanyurra mirrka mankura wilykikaja, jampa yurnmirriku.’ Jilanyala wajarni ngula mankuraku, mirta kuwarri. Ngayulurna-nyurranya wajarni, kuwarriya wilykikajayuru yurnmirringu, kaya martukaja majarni, kuwarrila-jananya mankuraku Mamaku. Nyawa-janampaya!, martukajarniya ngalyarni yankuninpa, jiikajaya wilykiyuru nyininpa. Ngayunjula-jananya wajalku kala-jananya manku Mamakuraya walyja nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pukurlarrinparna-janampa jiikajaku jumajiya yankuni Mamamili wangka kulilku. Yiipiya jungalu kulilku, palunyajanuya wanka nyinaku, kayilapala wulikaja pukurlarriku, Mamamili warrkamupurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Wangka kujupa jilanya ngarrini, ‘Martulu kujulu kurranyilu wilykikaja tuunyjunku, palujanu ngula yurnmirriku, ka kujupalu martulu yanku manku.’ Martu jiilu wilyki tuunyjunku, martu palunyayururna ngayulu kurranyilu Jamiriyamartajingkarnalu Mamamili wangka wajarnu, wanti palunyangka. Palujanu marlalunyurra martu kujupayurulu yanku manku mirrkakaja, martu palunyayurulunyurra kuwarrilu yanku manku martukaja jiikaja, Mamamiliraya walyja nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kayilapaya parna Jamiriyamartajilu, tawunja jiingkaya kulirnu Jiijajmili wangka kaya walyjarringu, jumaji wanti jiilu-jananya yanu wajarnu jilanya, “Yirna nyarralurni wajarnu yaalurna ngayu julyju nyinapayi, mayitpi palu Kurayijpa nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pukurlarringuya jiimartaji karaya japirnu Jiijajpa nyinaraku, kayilapa-janampa Jiijajkukamu wangka-nintikajaku karrpu kujarrarringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yarnnga kujupaluya martukajalu kulirnu Jiijajmili wangka kaya walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jiimartajiluya wajarnu wanti jiingkaluya, “Nyuntulu-lanyajun jakurljunu. Mirtalaju junga kulira nyinapayi. Kuwarrilaju kulirnu wangka Jiijajmili ka walyjarringulaju. Kulirninpalaju yilta ngaanya Kurayijpa nyinani, jiilu-langku wanka kanyilku, martu wulikaja.” ");
INSERT INTO mpj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tawun palunyangkaya karrpu kujarra nyinangu kaya parna Kaliliyangka yanu ngamurringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Julyju Jiijajju-jananya wajarnu, palumili wangka-nintikajangka jilanya, “Mamamili jakurlpurlukakuraya martukaja pukurlarrini, jampa wirrirli tawun kujupawana parra jakurljuni, Mamamili wangka. Ka yiipi tawun walyjawana parra jakurljuni, palunyangkaraya mirta martukaja pukurlarrini.” Wangka jiinya kulirnu Jiijajju ka kulilpayi, “Mirtajuya jiimartaji ngayuku pukurlarriku Kaliliyangka, ngayumili ngurrangka.” ");
INSERT INTO mpj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Palujanuya parna Kaliliyangka warinykatingu karaya Jiijajku pukurlarringu. Julyjuya jiimartaji yanu turlku Pajuwupakarti Jarujalumkarti, jiingkaya nyakupayi Jiijajju kujupa kujupa yalyjirrju ngapilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kayilapaya marlaku yanu Jiijajmapu tawun Kayinakarti. Tawun palunyangka Jiijajju julyju yalyjirrju kalyu ngapirnu ka wamarringu. Tawun kujupangka Kapaniyamungka maaja kapamanpa nyinapayi, kara palumili kaja ngarnta ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ka palunyalu maajalu jakurlpa jilanya kulirnu, “Jiijajpa parna Juutiyajanu yanurni ngaangka nyinani, parna Kaliliyangka.” Ka palulu maajalu yanulu Jiijajkarti jilanya wajarnu, “Walali yankura tawun Kapaniyamukarti, jumaji ngayumili kaja ngarnta maju ngarrini, miturrikijalu. Palunyangkan nyuntulu wankalkura.” ");
INSERT INTO mpj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jiijajju-janampa wajarnu, “Ngayulurna kujupa kujupa yalyjirrju ngapirni, jilanyawiyajuyan kulira nyininpa, mirtarninyurra ngayu Mamamili kulirni.” ");
INSERT INTO mpj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Palunyangka maajalura wajarnu Jiijajku, “Walali yankura, mayiti ngayumili kaja pakirrijaku.” ");
INSERT INTO mpj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jiijajjura wajarnu, “Yarrara nyawa!, nyuntumili kaja wanka nyinaku.” Maaja jiilu Jiijajmili wangka kulirnu ka wala yanu, ka kutungka ngarringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jampa jirnturringu, Maaja palunya yankupayi ruutungka kaya palumili warrkamupurluka ngaparrpa yankupayi, kaluya jakurljunu, “Nyuntuku kaja kunyjunyu nyinani.” ");
INSERT INTO mpj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Japirnu-jananya, “Nyaartaju ngayuku kaja wankarringu?” Kaluya wajarnu, “Karrpungka palunya yaltarringu nyinangu.” ");
INSERT INTO mpj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kayila maaja palunyalu kulirnu, “Yuwa karrpungkarni Jiijajju wajarnu, ‘Kajangku kunyjunyu nyinamalpa.’” Ka Jiijajpa kulirnu kayilara Jiijajku walyjarringu, ka palumili pamulilurrjuya walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiijajju julyju yalyjirrju ngapirnu, jampa kalyu ngapirnu wamarriraku parna Kaliliyangka, ka kuwarri yalyjirrju yarrarnu ngapirnu, maajakura kaja ngarnta majujanu wankarnu. ");
INSERT INTO mpj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Palunyajanuya Juwukaja kujungkarringu tawun Jarujalumungka Mamamili turlkukuraya, ka Jiijajpalurrju yanu palukarti tawunkarti. ");
INSERT INTO mpj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tawun palunyangka piinyji ngarnawarralu tinkijunu. Ka piinyji palungka kiitukaja yupalpa ngarapayi. Kalyu maju ngarripayi kiitungka ngamu, ka kiituwanaya palungka jiipukaja karrujulpayi. Kalyu palunyaya Yaramayik wangkangka wajalpayi jilanya, “Piijajpa.” Palungka kalyungka ngamu purikaja payip wulikaja, ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Martukajaya palungka puringka ngarripayi, ngarntakaja, pampurukaja, mukuntukajakamu kujupakaja wuluya ngarnta ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jiingka martu kuju ngarripayi ngarnta. Rawa ngarnta ngarringu jaarti yayit yiiyangka. Palumili walyjakajaluya parra katipayi ngarntawinti. ");
INSERT INTO mpj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jiijajju palunya yirna ngarntawinti nyangu ka kulirnu, “Ngaanya rawa yilta ngarripayi, ngarntawinti.” Kara japirnu, “Kulirnin nyuntulu wankarriraku?” ");
INSERT INTO mpj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Palujanu ngarntawintilura wajarnu, “Yuu! Yirna kujupalurniya mirta katini kalyukarti, jarrpajunkuraku, jampa kalyu yurrirrinpa. Purturnara kulini jiingkarna kalyungka wankarriraku. Martu kujupa wulujura kurranyi yankura jarrpani.” Jiipurlukaluya kulilpayi, jampa kalyu palu yurrimalpa, palujanu yiipi martu kurranyi yanku jarrpaku, palujanuyila wankarriku. ");
INSERT INTO mpj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jiijajjura wajarnu, “Pakala!, warntukajangku marra!, ka yankun.” ");
INSERT INTO mpj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Palujanu kunyjunyurringu ka manungku warntukaja ka parra yankupayi. Karrpu palungka Jarriti ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kayilapaya Juwumili maajakajaluya wajarnu, jiingka yirnangka, “Kuwarringa Jarriti ngarinpa, mirtan jii warntukaja kawa! Ngaangka-lampa luwu nyininpa, mirtala Jarritingka warrkamurrinpa, mirtala warntukajayuru parra katikuranpa.” ");
INSERT INTO mpj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yirnalu jiilu-jananya wajarnu, “Palunyalurni wankarnu ka wajarnuju warntukajarna mankura katikura.” ");
INSERT INTO mpj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Karaya maajakajalu japirnu jilanya, “Yirna nganalunta wajarnu, warntukajan mankura katikura?” ");
INSERT INTO mpj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yirna palunyara Jiijajku yiniku ngurrpa nyinapayi, kara purtu nyakupayi jumaji martu yarnngangka pakirringulura. ");
INSERT INTO mpj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngulanga Jiijajju yirna palunya nyangu jaaji majungka, kara wajarnu, “Kulilarni! Kunyjunyun yikini, mirtan wululu walykukaja ngapila! Yiipin yarralku walykukaja ngapilku, mayitpin miturriku.” ");
INSERT INTO mpj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Palujanu yirna palunyalu-jananya yanu Juwukajangka, maaja jiikajangka jakurljunu, “Yini Jiijajjurni ngayu wankarnu.” ");
INSERT INTO mpj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Palunyangkaraya Juwukaja maajakaja Jiijajku wirrilyirringu, kaya warrkirnu, jumaji Jarritingka wankarnu, luwu-janampa warlangu. ");
INSERT INTO mpj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Palujanu Jiijajju-jananya wajarnu, jiikajangka, “Ngayumili Mamaju warrkamurrinpa Jarritingkalurrju, palujanurna ngayu wulu warrkamurrinpa, Mamayuru.” ");
INSERT INTO mpj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wangka palunyaya kulirnu karaya maajakaja wirrilyirringu mituya pungkukijalu. Jilanyaya kulirnu, “Luwu-lampa warlangu, Jarritingka warrkamurripayi. Jilanyalurrju wajarnu, Mamara ngarnawarra nyininpa. Pakiwana wajarnu, jiinga parnapurluka martu nyininpa, Mama ngarnawarrapurlukapula mirta kujungka nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Maaja jiikajangka-jananya wajarnu Jiijajju, “Mirtarna ngayuluwiyaju kunyjunyu ngapirni, Mamalurni nintijuninpa, karna ngayulu kulini palujanuyilarna ngayulu ngapini. Mamalu kunyjunyu ngapini, palujanurna ngayulu kunyjunyu ngapini. ");
INSERT INTO mpj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ngayukuju Mama layikamurrira nyininpa ka nintirninparni. Jiilu Mamalu kulira ngana ngapilkijalu, palunyangkarni ngayu nintijuninpa. Kuwarrinyurra kuru pakarnu, yirna palunyarna ngayulu wankarnu. Palunyayururni ngula Mamalu nintijunku yalyjirrminyirrirna ngapilkura, kayilapanyurra palungka yiltaminyirri kuru pakalku. ");
INSERT INTO mpj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngayuku Mamalu-jananya martukaja mitujanu wankani, maparn majuwintilu. Palunyayururna ngula ngayulu kulilku ka marturna-jananya mitujanu wankalku. ");
INSERT INTO mpj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Wangka ngaanyalurrjuya kulila! Kulirninyurra Mamaluntaya wulikaja ngula kuutja wajalku, kuutpurlukayurulu. Jilanyanga pakiwananyurra kulini, palumili kajaluntaya kuutja wajalku, kuutpurlukayurulu. ");
INSERT INTO mpj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Palunyangkanyurra wulikajalu kaja palunya kulilkura Mamayuru maaja maju-nyurrampa nyinani. Yiipinyurra mirta martukajalu kaja palunya kulini, maaja maju nyininpa, palunyangkanyurra mirta Mama ngarnawarrapurluka maaja maju kulirninpa. Maparn majuwintipula kujungka nyinani, palu kujarra. Mama jiilu palumili kaja kurtingu ngaakarti parnakarti.” ");
INSERT INTO mpj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jiijajju-jananya yarrarnu wajarnu, “Wangka ngaanyaya kulila! Yiipi martulu ngayumili wangka kulilku, ka kulilku Mamalurni ngayu kurtingu marturna-jananya wankalkuraku, ka palujanuya martu jiinya wanka wulu nyinaku, Mamamili ngurrangka. Mirtarna martu jiinya ngula kuutja wajalku kurtingku. Mamalu yilta martu jiinya wanka kanyirni, palujanu ngula palumili ngurrangka wanka kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka Jiijajju yarrarnu-jananya wajarnu, “Wangka ngaanyaya kulila! Jampa-janampa Mamamili kaja mirraku, palujanuya mitukajalu kulilku kaya wankarriku pakalku. ");
INSERT INTO mpj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mamalu-lanya ngapirni wankala nyinakuraku, palujanu wanka kanyirni-lanya palumili ngurrangkala wanka nyinakura. Palunyayuru palumili kajalu-lanya wanka kanyirni, palumili ngurrangkala nyinakuraku. ");
INSERT INTO mpj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mamalu palumili kaja junu maaja maju, kuutja-lanya ngula wajalkura, kuutpurlukayurulu, jumaji palumili kaja marturringu, martuku ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wangka kujupa ngaanyaya kulila! Yilta, jampa-janampa Mamamili kaja mirraku, palujanuya mitukajalu kulilku kaya wankarriku pakalku. Mirtanyurra ngunjularri!, wangka jiiku, Mamamili kajalu-jananya yiltalu mitujanu wankalku. ");
INSERT INTO mpj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Parnajanuya pakalku wulikaja palujanuya kuutja ngaraku. Kunyjunyukaja kuutpurlukalu-jananya mirraku ka katiku-jananya palumili ngurrakarti, wankaya wulu nyinakuraku. Kayila walykukaja-jananya wajalku kurtingku kuutja, yankurakuya warukarti.” ");
INSERT INTO mpj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jiijajju-jananya yarrarnu wajarnu, “Mirtarna ngayuluwiyaju kunyjunyu ngapirni, Mamalurni nintijuninpa, karna ngayulu kulini palujanuyilarna ngayulu ngapini. Palujanu ngayulurna jungalu ngapirni, jumaji Mamalurni nintijuni, mirtarna ngayulu walyjalu kulira ngapini. ");
INSERT INTO mpj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Jilanyanyurra kulini. Yiipiya martu yupalpa wangkaku kujunkujun, ka wangkaya kuju wanalku, palujanunyurra wangka jiinya junga kulirni. Ngayurna mirta yupalyuru nyininpa, kujurna nyininpa. Yiipirna ngayulu wangka wajalku, palujanu mayiti pakiyurunyurra kulilku. ");
INSERT INTO mpj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka kujupalu ngarnkapurlukalu, ngayumili kuju wangka wanalku. Palukura wangka jungaminyirri yilta nyininpa. Ngayulurna nintilu kulirni jungaminyirrira wangka paluku. ");
INSERT INTO mpj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jaanjulurrju ngayumili wangka julyju wanarnu. Jiilu-janampa wajarnu julyju, nyuntumili wangkapurlukakajangka, ngayurna Mamamili. Jiilu-jananya jungalu wajarnu. ");
INSERT INTO mpj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wangka jiinyarna-nyurranya wajarni ngayurninyurra kulira ka wanka nyinakura. Mirta martu kujupalurniya wajalkura jilanya, ‘Yilta jiinya nyininpa Mamamili.’ Ngayulurna nintilu kulini, yiltarnara nyininpa, Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jaanpa layitiyuru nyinapayi. Martuluya layiti nyakuni kaya kujungkarrini. Jiiyurunyurra layitiyuru Jaanpa nyakura ka kujungkarripayi. Kurranyilunyurra palumili wangka kulira ka pukurlarripayi. Jaanju jiilu kunyjunyu wajarnu ngayurna Mamamili nyinakura. ");
INSERT INTO mpj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jilanyalurrjunyurra munkarra kulilkura, ngayulurna yalyjirrju ngapilpayi Mamamili maparnwintilu, kujupa kujuparna yalyjirrju ngapilpayi. Jilanyanyurra nyakura kulinngara, ngayurna Mamamili, palulurni parnakarti kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ka Mama jiilu-jananya julyju palumili jakurlpurlukajangka wajarnu, ngayurni parnakarti kurtingkuraku. Palumili Mamamili wangkanyurra kulira junkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mirtanyurra Mamamili wangka kuranju kanyirni, jumajirninyurra pinyijuninpa, ngayurni Mamalu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mamamili wangkanyurra wululu riitamura nyinapayi. Jilanya kukarninyurra kulini, jampanyurra wululu riitamulkura kanyurra wanka nyinakijalu, Mamamili ngurrangka, palunyayuru kukaninyurra. Mamamili jakurlpurlukajaluya wakarnu, Mamamili wangkangka jiingka ngarrini, ngayurni Mamalu kurtingkukijalu. ");
INSERT INTO mpj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Karninyurra mirta kulini, ngayulurna-nyurranya wanka kanyilkuraku, ngayurninyurra pinyijuninpa. ");
INSERT INTO mpj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ngayulurna kulini, mirtarninyurra martukajalu marninypungkura nyinama, Mamawiyajuju ngayuku pukurlpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ngayulurna-nyurranya nintilu kulini, mirtanyurra Mamaku pukurlpa nyinani. ");
INSERT INTO mpj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Maaja majulurni Mamalu kurtingurni-nyurrampa, karninyurra mirta kulirninpa. Yiipi martu kujupa-nyurranya yankurni wajalku, ‘Ngayurna nintipurluka, kulilarniya!’ Palujanuyilanyurra pukurlju palu kulilku. ");
INSERT INTO mpj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Martukajalunyurra kulini, martu kujupakunyurra kunyjunyu nyinakura, palujanuyilantaya nyuntu puntajilu marninypungku. Jilanyanyurra mirta kulini, Mamakuranyurra kunyjunyu nyinakura, kayilantaya puntajilu marninypungku. Palungkamarranyurra Mama kulira junkuni, ngayulurrjurninyurra Mamayuru kulira junkuni. ");
INSERT INTO mpj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","46","Mirtanyurra jilanya kulila!, ‘Mayitpi Jiijajju-lanya ngula kuru wajalku kuutja, jumajila Jiijajpa kulira junkupayi.’ Mirta jilanya. Muujajjuntaya ngula kuru wajalku kuutja. Muujajmili wangkanyurra kulinngara jungalu, ngayulurrjurninyurra kulinngara jungalu. Palulu wakarnu, ngayurni Mamalu kurtingkuraku, palumili wangkanyurra kulinngara. Kulilpayinyurra jilanya kukanyja, ‘Muujajmili wangkawanala junga nyinakura, kala wanka nyinakura, Mamamili ngurrangka.’ ");
INSERT INTO mpj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Palujanunyurra Muujajmili wangka kulira junkuni kanyurra ngayumili wangkalurrjunyurra kulira junkuninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Palujanuya puutungka tatirnu yanu wirrirlikarti kalyu Kaliliyawana, Jiijajmapu. Kalyu Kaliliya palu yiniya kujupa wajalpayi, “Tapiriyajpa.” Kuwarripaya turlku Pajuwupaku Jarujalumungka kujungkarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Julyju jiimartajiluya nyangu Jiijajju-jananya yalyjirrju ngarntakaja maparnwintilu wankalpayi. Palujanuluya nintilu kulirnu, kaya yarnngaminyirri Jiijajmapungka kujungkarringu kaya yanu. ");
INSERT INTO mpj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Kurranyiya yanu Jiijajkamu palumili wangka-nintikaja, kaya yapungka tatirnu kutungka, nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yapu palungkaya tatirnu ka Jiijajju-jananya nyakupayi, martukaja wulikaja, yankupayiluya palukarti. Ka Jiijajjulu Pilapungka wajarnu jilanya, “Wanyjangkala payamunku mirrkakaja?, jii martukajaluya ngalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ka Jiijajjura yumulu yajinyjanju japirnu, Pilapulu maparnwinti palunya kulilkuraku. Jiijajju nintilu kulirnu mirrka-janampa yalyjirrju ngapilkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilapulura wajarnu, “Martuya ngaa yarnngaminyirri, mirrkakajaya maapu payamulkuraku. Mirrka wanyjangkala payamulku?, martuluya jaalpulu ngalkuraku. Mani majuwintilula jiiyuru payamulkuraku, ngapiyurulu?, puu jawujun talawintilu.” ");
INSERT INTO mpj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jiijajmili wangka-ninti kujupa nyinapayi, yini Yanturu, Jayimun Piijaku marlaju. Palunyalura wajarnu, Jiijajku, ");
INSERT INTO mpj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ngaanya murtilya yikini, palunyalu kanyirni karlukarlukaja japuwartakaja payip wulikajakamu, kujarra kalyupurluka, piijpa, japu kujarra. Mirrka ngaanya japuwarta kanyirni, mirtaya martukajalu yarnngalu ngalku munkurriku, paki.” ");
INSERT INTO mpj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka Jiijajjura wajarnu, “Wajala-jananya martukajangka nyinatirakuya!” Yapu palungkanga yukurikaja kurajukaja pakalpayi. Jiingkaya nyinatingu, yirnakaja payip jawujun, wantikajakamu, jijikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","12","Ka Jiijajju mirrka palunya manukalu Mamangka wangkangu, “Mama nyuntulu-lanyajun mirrka yungkuni, kalajunta marninypungkuni.” Palujanuyila warlangkura-jananya wululu yungkupayi, martukajangka yarnngangka. Piijpalurrju-jananya warlangkura wululu yungkupayi. Kaya wulikajalu ngalangu munkurringu. Kaya karlkinpa munkuwintilu warningkupayi parnawana. Palumili nintikajangka-jananya Jiijajju wajarnu, parra yankuraya mirrkakaja mankura ka turampukajangka junkuraku, ngarrira pirninyarrijaku. ");
INSERT INTO mpj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tuwal wulikajangkaya turampukajangka mirrkakaja pilamapurnu. Turampu palukajangka pilamapurringu karlukarlu payip wulikajajanukamu kujarra piijjanu. ");
INSERT INTO mpj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jiiya nyangu Jiijajju yalyjirrju mirrkakaja ngapirnu, ka martukajalu wajarnu, “Ngaanga Mamamili jakurlpurluka nyinani, yilta Mamalu jamartapungu julyju kurtingkuraku, parnatu.” ");
INSERT INTO mpj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jiijajju jilanya kulilpayi, “Nyurilurniya martukajalu kuwarri katiku, maaja maju nyinajunku.” Palunyangkamarra kulirnu ka Jiijajpa yanu yapu kujupakarti, jaalpu nyinakija. ");
INSERT INTO mpj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Jampa rukarringu palumili wangka-nintikajawiyajuya yanu puutja tatirnu, kalyuwanaya yankukijalu tawun Kapaniyamukarti. Yanuya mungajarrarringu ka Jiijajpa wulu parnangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yanuya kalyungka ka wangalpa majurringu kalyululurrju-janampa puutpa parra yurntulpayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wartawintiluya puutpa yurntulpayi yankuraku. Wululuya wartawintilu yurntulpayi, kaya munkarra Jiijajpa nyangu kalyungka ngarnawarra jinangu yankupayi. Mirtaya Jiijajpa yikurntanu, karrpirl kukarnuya, jampa ngamurringu ngurlurringuya. ");
INSERT INTO mpj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka Jiijajju-janampa wajarnu, “Mirtanyurra ngurlurrima!, ngayurna yankuni.” ");
INSERT INTO mpj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kulirnuya Jiijajpa kaya pukurlarringu takajunu puutja. Palujanu puutpa-janampa jaalpu yanu pipurru parnakarti ka yikipayi, tawun Kapaniyamungka ngamu. ");
INSERT INTO mpj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Martukajaluya mirrka ngalangu palungka, Jiijajju-janampa yalyjirrju ngapirnu, kaya ngarringu. Palujanu yaarlipalarringu martu jiikajaluya pakarnuka purtu nyangu Jiijajku. Kaya jilanya kulirnu, “Nyangula rukangka kuju puutpa yikipayi, ka palungkaya tatirnu palumili wangka-nintikaja kaya yanu. Jiijajpa palungka mirta tatirnu yanu.” ");
INSERT INTO mpj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Purtuya nyinara kulilpayi ka puut kujupakajarniya yanu, jiikarti tawun Tapiriyajjanu. Kaya tatira puutkajangka yanu tawun Kapaniyamukarti, Jiijajkuraya ngurrilkijalu. ");
INSERT INTO mpj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Palujanuya tawun Kapaniyamungka tiputingu karaya yanu Jiijajku ngurrilpayi. Kaya nyangu Jiijajpa japirnuraya jilanya, “Nintipuka! Nyaartan nyuntu ngaangka yanu kurrungu?” ");
INSERT INTO mpj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jiijajju-jananya wajarnu, “Wangka ngaanyaya kulila! Ngurrinijunyurra ngayuku, mirrkanyurra ngalangu munkurringuka. Yalyjirrjurna-nyurrampa mirrka ngapilpayi, kulilngararninyurra ngayurna Mamamili. Mirtarninyurra jilanya kulini, mirrkawiyajunyurra kulini. ");
INSERT INTO mpj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mirtanyurra kulira mirrkakuwiyaju nyinama, kujupakulurrjuya kulira nyinama! Mamangka wanka nyinakuraku. Mirrka kujupakuwiyajuya kulira nyinama!, wanka kanyilpayiku. Mirrka jiiyururna-nyurranya yungku, martu yarnngaku marlpalu, palujanunyurra wanka wulu nyinaku. Mamalurni maparnpa yungu, palunyangkarna-nyurranya wanka kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Japirnuraya, “Wanyjalpalaju Mamaku junga nyinaku? Nganalara Mamaku junga ngapilku?” ");
INSERT INTO mpj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jiijajju-janampa wajarnu jilanya, “Mamalu kulini jilanya. Nyuntunjurninyurra Kurayijpa kulilkura yiltarna Mamamili. Yilta Mamalurni ngayu julyju jamartapungu kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka wajarnuraya, “Yalyjirrpa kujupa kujupa ngapila!, nyakuralajunta ka kulilkura, nyunturan Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Julyju mitunyjarriluya pujimanwana mirrka ngalkupayi. Mamalu-jananya yungkupayi, karrpuparaku karrpuparakungka. Mirrka palunya yini nyinapayi, maana. Muujajju-jananya maajalu ngampurrju kanyilpayi, ka-jananya jii maana yungkupayi. Jilanya Mamamili wangka nyinani, mirlimirlingka, ‘Mamalu-jananya mirrka ngarnawarrajanu yungkupayi kaya ngalkupayi.’ Jilanya-lanyaju yalyjirrju yuwa!, mirrkakaja karrpuparaku karrpuparakungka.” ");
INSERT INTO mpj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Mirta-jananya mitunyjarripurlukalu Muujajju mirrka jii ngarnawarrajanu yungkupayi, paki, ");
INSERT INTO mpj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mamaluwiyaju-jananya yungkupayi. Jilanyayuru Mamalu-nyurranya mirrka kujupayuru yungku, yilta mirrkaminyirri jiinga. Mirrkayuru jiiyuru Mamalu-nyurrampa ngarnawarrajanu kurtingku. Mirrka jiiyuru martulu ngalku ka wanka wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wajarnuraya, “Nintipuka! Mirrka palunyayuru-lanyaju wululu yungama!” ");
INSERT INTO mpj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jiijajju-jananya wajarnu, “Mirrka palunyanga ngayurna. Yiipirniya martulu ngayu kulilku Mamamili, palujanuyila wanka wulu nyinaku. Jiiyuru mirrkayuru ngalku ka wanka wulu nyinaku, mirta kalyparturriku ka mirta marrkurriku. ");
INSERT INTO mpj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Julyjurna-nyurranya jilanya wajarnu. Ngayurninyurra nyakupayi ka mirtanyurra kulilpayi ngayurna Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ka yiipi Mamalu martu kuju yintalku kulilku martu jii palumili walyja nyinakura, palujanu martu jiilu ngayumili wangka kulilku ka walyjarrikuju nyinaku. Yiipi martulu kulilku ngayumili wangka ka walyjarriku, palujanu mirtarna junku yanku. ");
INSERT INTO mpj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mamajanurna yanurni ngarnawarrajanu, ka Mamalurni wajanyjangka palunyarna kuliraka ngapirni, mirtarna walyjalu kulira ngapirni. ");
INSERT INTO mpj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mamalu jiilu kulini, ngayulurna-jananya ngampurrju kanyilkura, ngayumili walyjakaja, mirtarna-jananya junku yankura. Mamalu jiilu kulini, ngayulurna-jananya ngayumilikaja wulikaja, ngula kuutja wanka kanyilku ka ngampurrju kanyinmalpa, Mamamili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yiipirni martulu ngayu kulilku Mamamili, karna ngayulu wanka kanyilku, wulu martu jiinya wanka nyinaku, Mamamili ngurrangka. Jilanya ngayulurna-jananya wanka kanyilku Mamalu kulini. Jiikajarna-jananya kuutja ngula ngayulu wanka kanyilku wanka wuluya nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Martukajakamu Juwumili maajakajalu-ngkuya karlkilu japirnu jilanya, “Nyaaku-lanya Jiijajju wajarnu?, ‘Mirrkayururna, Mamamili ngarnawarrajanu.’” ");
INSERT INTO mpj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ka wajarnu-ngkuya, “Ngaa Jiijajpa, Juujapku kaja, palumili mamakamu yipinga walyja-lampa. Mirtangku wajalkura ngarnawarrajanu yankupayi, paki.” ");
INSERT INTO mpj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jiijajju-jananya kulirnu ka-janampa wajarnu, “Mirta jilanyanyurra wangkama!, pakiwananyurra kulini. ");
INSERT INTO mpj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jilanyaya kulila! Mamalu martu nintilku ngayumili wangka kulilkura, palujanu ngayurni kulilku Mamamili. Martu jiinyarna ngula kuutja wanka kanyilku ka wanka wulu nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jiijajju-jananya yarrarnu wajarnu, “Julyju Mamamili jakurlpurlukaluya jilanya wakarnu, ‘Mamalu-jananya ngula martukaja nintilku.’ Wangka jilanyayuru yiipi Mamalu martu nintilku ngayumili wangka kulilkuraku, palujanu martu jiilu ngayumili wangka kulilku walyjarriku. ");
INSERT INTO mpj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mirta Mamalu yutilu jilanya nintilku, mirta martulu kurulu nyaku. Mirtanyurra jilanyawana kulila! Ngayuluwiyajurna Mama kurulu nyakupayi, Mamajanulu. ");
INSERT INTO mpj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wangka ngaanyaya kulila! Yiipirni martulu kulilku, ngayurna Mamamili, palujanu wanka wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngayurna mirrkayuru, wanka kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nyuntunmili mitunyjarriluya mirrka yini maana wululu ngalkupayi pujimanwana, palujanuya yirnarringukaya miturringu. ");
INSERT INTO mpj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka mirrkayuru kujupa ngarnawarrajanu ngalkunyurra, mirtanyurra miturriku jiikajayuru, wankanyurra wulu nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngayurna jiinya mirrkayuru nyininpa, ngarnawarrajanurna yankupayi, Mamamili. Mirrkayururna nyininpa. Ngayumili kawu yiipi martulu ngalku wanka wulu nyinamalpa. Ngayurna miturriku martukajaya wanka wulu nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Martukajalu-ngkuya japirnu, “Yaalu-lanya yungku kawu palumili ngalkurakula?” ");
INSERT INTO mpj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","54","Ka Jiijajju-jananya wajarnu, “Wangka ngaanyaya kulila! Ngayurninyurra martu yarnngaku marlpa, kawu ngalku, ka miji jikilku, palujanunyurra wanka wulu nyinaku. Marturna-nyurranya ngula kuutja wanka kanyilku, wankanyurra wulu nyinakura. Yiipinyurra mirta ngayu yarnangu ngalku ka miji jikilku, kanyurra mirta wanka wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ngayurna yarnangu mirrkayurunyurra ngalkuraku, ka ngayurna mijiyurunyurra jikilkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yiipi martulurni ngayumili yarnangu ngalku, ka mijiju jikilku, palujanu kujungkaliju nyinamalpa walyjararra. ");
INSERT INTO mpj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mamaju ngayuku wulu nyinamalpa wanka, jiilurni kurtingu parnatu. Palunyayururna ngayu wanka wulu nyinamalpa. Palunyangka yiipi martulurni ngayu yarnangu ngalku, kayilapa wulu wanka nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jilanyarna mirrkayuru nyininpa, ngarnawarrajanu Mamamili. Julyjuya mitunyjarrikajalu mirrka ngalkupayi ngarnawarrajanu, kaya miturringu. Mamalu-janampa kurtingkupayi mirrka jiiyurukaja. Mirtarna mirrka jiiyuru nyininpa, paki. Mirrkarna ngayu yiipi martulu ngalku, palunyangka wanka wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Wangka jiinya-jananya Jiijajju nintilpayi, Juwumili jaajingka, tawun Kapaniyamungka. ");
INSERT INTO mpj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Karlkin kujupaluya Jiijajmili wangka julyju kulirnu kaya walyjarringu. Jiikajalu-ngkuya wajarnu, “Mirtala wangka jiiyuru kulilkura!, junku yankurala!” ");
INSERT INTO mpj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Palujanu Jiijajju-jananya nintilu kulilpayi ka-janampa wajarnu, “Nyuntunjunyurra kulini, ngayurninyurra junku yankuraku? Mayitinyurra kulini?, pakiwanarna-nyurranya nintijulpayi? ");
INSERT INTO mpj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ka ngula purtunyurra kulilku ngayurninyurra nyaku, marlakurna yanku ngarnawarrakarti, martu yarnngaku marlpa. ");
INSERT INTO mpj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wangka ngaanyurra kulilkura. Mamamili Kuurtilu-lanya walyjamanin, palunyangkala wanka wulu nyinaku. Martulu-lanya mirta jilanyalu wanka nyinajunku, wulula wanka nyinakuraku, paki. Wangka jiirna-nyurranya wajarnu, yiipi martulu kulilku ka Mamamili Kuurtilu wanka wulu kanyilku. ");
INSERT INTO mpj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngayulurna-nyurranya nintilu kulini, karlkilunyurra mirta wangka ngayumili kulini.” Julyju Jiijajju nintilu kulilpayi, palumiliya wangka kuliraka junku yanku. Kayilapa kulilpayi Juutajjulurrju ngula maajakajangka-jananya wajalkuraku, Jiijajpaya mankuraku. ");
INSERT INTO mpj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jiijajju-jananya yarrarnu wajarnu, “Paki karaninyurra ngayumili wangka, mirta Mamalu-nyurranya nintinu, ngayumili wangkanyurra kulilkura. Wangka jiirna-nyurranya wajarnu. Mamalu martu nintilku ngayumili wangka kulilkura, palujanurni kulilku walyjarriku.” ");
INSERT INTO mpj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Palujanuya karlkilu palumili walyjakajalu junu yanu, mirtaya kulilpayi. Mirtaya Jiijajja kujungka yankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nyangu-jananya Jiijajju palumili walyjakaja yankupayi, ka wajarnu-jananya palumili wangka-nintikajangka, “Nyuntunjulurrjurniyan junku yankukijalu?” ");
INSERT INTO mpj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jayimun Piijalura wajarnu, “Nyaakulaju yanku? Nyuntumili wangkawiyaju martulu kulilku ka wanka wulu nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kuwarrilaju kulini nyuntun Mamamili Kurayijpa, Mamalunta kurtingu.” ");
INSERT INTO mpj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiijajju-janampa wajarnu, “Ngayulurnantaya tuwal wulikaja yintarnu manu. Kuju-nyurranya nyininpa, malpumilijayiti.” ");
INSERT INTO mpj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jilanya Jiijajju wajarnu Juutajpa, Jayimun Yijikariyatmili kaja. Ngula Jiijajmili wangka-nintilu-jananya Juutajju jakurljunu maajakajangka, Jiijajpaya mankuraku. ");
INSERT INTO mpj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Palujanu Jiijajpa parna Kaliliyawana parra yankupayi, mirta parna Juutiyangka yanu, Juwukaja maajakajaluya mitu pungkujakungkamarra. ");
INSERT INTO mpj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kayilapa palungka Jarujalumungka turlku maju nyinakijalu, yini palunya turlku, ‘Purikajawinti’ ");
INSERT INTO mpj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ka Jiijajmili marlajukajaluraya wajarnu, “Parna ngaanya jurra yarra!, ka parna Juutiyawana yarra, turlku palukarti! Jiiwanan nyuntu yanku ka nyuntumili walyjakajalukamu martukajaluntaya nyaku ka pukurlarriku, jiiwanan yalyjirrju kujupa kujupakaja ngapilku, ");
INSERT INTO mpj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","mirtan ngaangka nyuntu nyina! Kuwarriya kujungkarrini turlkuku. Yiipin nyuntulu kulirni, martukaja-ngkuya pukurlarriraku, palunyangka yarra-jananya kujungkarri! Nyuntulun yalyjirrju kujupa kujupa ngapilku, palunyangka martu wulikajaluntaya nyaku pukurlarriku.” ");
INSERT INTO mpj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Palumili marlajukajaluya mirta kulilpayi, Jiijajpa Mamamili, paki. ");
INSERT INTO mpj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jiijajju-janampa wajarnu, palumili marlajukajaku, “Ngayulurna walyjalu kulilku, ka ngularna-jananya mayiti yanku, ka yalyjirrju ngapilku. Kuwarrinyurra kunyjunyu yanku turlkukarti, palukarti. ");
INSERT INTO mpj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Martukaja-nyurrampaya kunyjunyu nyininpa, mirtaya wirrilyirrinpa. Kayilapajuya ngayuku wirrilyi nyininpa, jumajirna-jananya wajalpayi, walykuya nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Turlku palunyakartiya mawu yarra!, mirtarna ngayu yankukijalu. Ngayulurna walyjalu kulilku ka ngularna mayiti mawu yanku.” ");
INSERT INTO mpj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jilanya Jiijajju-jananya wajarnu ka parna Kaliliyangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Palujanu Jiijajpa jaalpu yanu tawun Jarujalumkarti, tawunja jukunjukunja yanu, martu yarnngangkamarra. ");
INSERT INTO mpj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Turlkukuraya kujungkarripayi martukaja, jiingkaraya Juwumili maajakajalu ngurrilpayi Jiijajku, Jarujalumungka. Purtu ngurrirnukaya japirnu-ngkuya, “Wanyjangka Jiijajpa nyininpa?” ");
INSERT INTO mpj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Purtuya-jananya martukaja parra japilpayi. Karlkiluya martukajalu wajalpayi, “Jiinga Jiijajpa kunyjunyu.” Ka karlki kujupaluya wajalpayi, “Paki. Jiijajpanga mayunyju. Pakiwana-jananya nintini.” ");
INSERT INTO mpj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Martukajaya yaka wangkapayi, Jiijajpaya yini mirta wiltulu wajalpayi, ngangkuljaku-jananyaya Juwumili maajakajalu. ");
INSERT INTO mpj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Palungkaya turlkungka nyinapayi, karrpu yupalja, palujanuyila Jiijajpa yanu Juwumili jaaji majukarti. Kurrunguka-jananya martukaja nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kaya Juwumili maajakajalu palumili wangka kulilpayi, ka wajarnu-ngkuya, “Wanyjalpa ngaanya wangkaku ninti nyininpa?, mirta palunya ngayurtinmili kuulkarti yanu.” ");
INSERT INTO mpj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Palunyangka Jiijajju-jananya nintilu kulirnu ka wajarnu, “Mamalurni nintini palujanurna kulira karna-nyurranya wajani, mirtarna walyjalu kulira nintirrini. Mama jiilurni kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yiipi martulu kulini Mamamili wangka jungalu ngapilkura, palunyalurni ngayu kulini Mamamilirnara walyja, palumilirnara wangka jungalu wajarni, palujanu nintilu kulilku, mirtarna walyjalu kulira nintini. ");
INSERT INTO mpj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yiipi nintipurlukalu walyjalu kulilku martukaja-jananya nintijulkuraku, jilanya kulilku, ‘Ngayulurna-jananya yalyjirrju nintijulku, palujanurniya puntajilu marninypungku.’ Jilanya-jananya nintini, martukajaluya marninypungkuraku. Ka ngayulurna kulini nintipurlukalu Mamanyurra marninypungkuraku. Palunyajanunyurra kulilku jilanya, ‘Nintipurluka ngaanya jungalu wajani, mirta mayunyju.’” ");
INSERT INTO mpj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Jiijajju-janampa wajarnu wangka kujupawana, “Wangka ngaanyaya kulila! Muujajju-jananya julyju Mamamili luwu nintilpayi, Jarritingkaya mirta warrkamurriraku. Mirtanyurra jiiwana luwuwana junga nyininpa. Kulininpanyurra ngayulurna luwu palu warlangu, palujanunyurra kulini ngayurninyurra mitu pungkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Karaya martukajalu wajarnu, “Nyuntulun pakiwana wajani. Nganalunta mitu pungkukijalu? Mayitpi malpulunta ngakumpanu.” ");
INSERT INTO mpj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ka Jiijajju-janampa wajarnu, “Julyjurna martu kuju wankarnu Jarritingka, kanyurra kuru pakarnu. ");
INSERT INTO mpj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muujajju-nyurranya wajarnu jiji japukaja yirnamalkuraku. Mirta Muujajjuwiyaju, kaya mitunyjarrilu julyju wajarnu jijikaja yirnamalkura. Palujanu kuwarrinyurra Jarritingka jijikaja yirnamani. ");
INSERT INTO mpj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jilanyanyurra kulini, ‘Kunyjunyulula jijikaja yirnamani, Jarritingka, mirtala luwu warlangkuni. Ka mirtala warrkamu Jarritingka ngapini, luwu-lampa jilanya nyininpa.’ Jilanyanyurra kulini. Julyju ngayulurna martu Jarritingka wankarnu, palujanujuyan ngayuku wirrilyirringu. Mirtajunyurra wirrilyirringara, jumajinyurra Jarritingka yirnamarninpa jijikaja. ");
INSERT INTO mpj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jungalunyurra kulinngara, Jarritingkanyurra jijikaja yirnamani warrkamuparnilu, palunyangkarna ngayulu martu wankarnu Jarritingka nyunturtinyurulu, warrkamuparnilu.” ");
INSERT INTO mpj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Karlki kujupalu-ngkuya Jarujalummartajilu japilpayi jilanya, “Kajiya maajakajalu yilta martu jiinya mitu pungkukijalu? ");
INSERT INTO mpj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nyarra yikininpa nintini-jananya martukaja, mirtaya maajakajalu marrkurninpa. Mayitpiya kulini jii maajakajalu, Mamalu kurtingu Kurayijpa palunya.” ");
INSERT INTO mpj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kaya karlkin kujupalu martukajalu wajarnu, “Jiijajpa mirta Kurayijpa nyininpa, palumili ngurrakulara ninti nyininpa, palumili walyjakajaya kayili nyininpa. Kurayijpanga ngurra ngarnawarrapurluka. Martukajala ngurrpa Kurayijmiliku ngurraku.” ");
INSERT INTO mpj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wangka jiinya Jiijajju nintilu kulilpayi-jananya jaaji majungka. Ka-janampa wajarnu, “Ngayumili ngurrakujunyurra ngurrpa, mirtaranyurra ninti nyininpa. Ngayurna mirta kulirnuka ngaakutu ngurrakarti yankupayi, kujupalurni kurtingu. Jiinga yilta jungaminyirri nyininpa. Jiikuranyurra ngurrpa. ");
INSERT INTO mpj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngayuwiyajurnara ninti nyininpa, palumili ngurrajanurna yanurni, jiilurni kurtingu.” Palujanuya maajakajaluya kulirnu, Jiijajpaya mankuraku. Ngurlurringukaya junu, jumaji Mamalu kulirnu mirtara tayimu nyinapayi mankurakuya. ");
INSERT INTO mpj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Palujanuya maajakajalu kulirnu, Jiijajpaya mankuraku. Palunyajanu Mamalu-jananya marrkurnu, jumaji Mamalu kulirnu mirtara tayimu nyinapayi, Jiijajpaya mankuraku. ");
INSERT INTO mpj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Martukajaluya Jiijajpa kulirnu Mamamili, kaya wajarnu, “Ngaanga Kurayijpa, yalyjirrju kujupa kujupa ngapilpayi. Mirta martu kujupalu jilanya ngapilpayi.” ");
INSERT INTO mpj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Palujanuya Parajikajalukamu yatily majukajalu kulirnuya-jananya martukaja Jiijajpaya wajalpayi, Kurayijpa. Kaya ngalyikarrpilkajaya-jananya wajarnu kurtingu, Jiijajpaya yankura mankura. ");
INSERT INTO mpj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yanuya Jiijajpa mankukija, ka-janampa Jiijajju wajarnu, “Rawaparnirnantaya nyinaku, karna marlaku yanku Mamakarti. Jiilurni kurtingu ngaakarti. ");
INSERT INTO mpj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kajunyurra purtu ngurrilku ka yumurriku nyinamalpa. Kayilaparninyurra mirta nyaku, ngurra kujupakartirna yanku. Purturanyurra kulilku jiikarti ngurrakarti yankuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ka-ngkuya Juwumili maajakajalu kulirnuka japirnu, “Wanyjatu palunya yankuni?, ngayurtinjamarra nyakujakula. Mayitpi yanku wirrirli Juwuparnikajakarti-jananya, nintilkuraku, martu walykukajakarti. ");
INSERT INTO mpj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Purtulara kulini, wanyjakarti yankuni? Palulu wajarnu purtulara ngurrilku ka yumurriku nyinaku. Mirtala palumili ngurrakarti yanku. Ngana wajalpayi? Purtulara kulini.” Ngalyikarrpilkajaluya mirta palungka manu. ");
INSERT INTO mpj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Turlku palunyangkaya nyinapayi pakirrikijalu, ka yungunpaya kulilpayi Juwukajalu jilanya, “Karrpu maju-lampa kuwarri nyinaku.” Ka karrpu jiingka Jiijajju-jananya wajarnu, “Yiipi martu marrku nyininpa, palujanu ngayukartirni yanku jikilkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mamamili wangka jilanya nyininpa, ‘Yiipi martulu ngayurni kulilku Mamamilirna, palujanu wanka wulu nyinaku, kalyuwintiyuru nyinaku munku, marrkuparni.’” ");
INSERT INTO mpj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jilanya Jiijajju wajarnu palumili walyjakajaraya kalyuwintiyuru nyinaku. Palunyayuruya wanka nyinaku Mamamili Kuurtiwintiya nyinaku. Palunya tayimuya mirta Mamamili Kuurtiwinti nyinapayi, ngula Jiijajpa marlaku yankunyjangka Mamakarti, maajapula kujarrangulyu nyinapayi kujungka. Palujanu-jananya Mamamili Kuurti jarrpapayi, martukajangka. ");
INSERT INTO mpj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Karlkiluya martukajalu kulirnu wangka jiinya martu kalyuwintiyuru nyinaku, kaya-jananya wajarnu karlki kujupangka jilanya, “Jiinga Mamamili jakurlpurluka yikini, Muujajyuru.” ");
INSERT INTO mpj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kaya karlki kujupalu wajarnu, “Jiinga Kurayijpa yikini. Mamalu julyju jamartapungu kurtingkuraku.” Kaya karlki kujupalu wajarnu, “Paki, Kurayijpa mirta parna Kaliliyamartaji. ");
INSERT INTO mpj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mamamili wangka jilanya nyininpa, Kurayijpa tawun Pijiliyamungka yutirriku. Mitunyjarripurlukamili Tayipitmili marlajanu Kurayijpa nyinaku, jii Tayipitmili tawunja yutirriku, Pijiliyamungka. Julyju Tayipitpa tawun jiingka nyinapayi.” ");
INSERT INTO mpj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","44","Wangka jiinyaya karlkiluya martukajalu kulilpayi, “Kurayijpa mirta nyininpa.” Kaya kulilpayi Jiijajpa mankuraku. Ka karlki kujupaluya kulilpayi, “Jiijajpa, yilta Kurayijpa nyininpa.” Mirtaya palukajalu kulilpayi Jiijajpaya mankuraku. Palujanu mirtaya Jiijajpa manu. ");
INSERT INTO mpj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ngalyikarrpilkajaluya Jiijajpa wangka kulirnu, kaya marlaku yanu yatily majukajakartikamu Parajikajakarti. Ka jiikajalu-jananyaya japirnu, “Nyaakunyurra mirta kangurni ngalyarni?” ");
INSERT INTO mpj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Palunyangkaya wajarnu, “Wangka kunyjunyu wangkapayi, palunya. Mirta martu kujupa palunyayuru wangkani.” ");
INSERT INTO mpj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ka Parajikajaluya nyurnilu wajarnu, “Palumili wangkanyurra nyunturtinjulurrju kulira pukurlarrini?” ");
INSERT INTO mpj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Yarrarnuya-jananya wajarnu Parajikajalu, “Martulu ngurrpaluwiyajuya palumili wangka kulira pukurlarrini, Muujajmili luwukuya ngurrpa ka ngurrpakaja-jananya Mamalu ngula warrkilku kurtingku. Mirtala Parajikajalukamu maajakajalu kulini palumili wangka, paki, nintilula kulira juninpa. Muujajku luwukulara ninti nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikatimajpa Paraji nyinapayi, jiingka-jananya kujungka nyinapayi. Palunyalu julyju Jiijajkarti yanu wangkangu. Jiilu-jananya wajarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mirta-lampa luwu nyininpa, palunyayurula-jananya mankuraka kangkura pungkura. Palumili wangkapalajila kulilkura kuutja.” ");
INSERT INTO mpj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wajarnuraya, “Nyuntungan parna Kaliliyamartajiyuru, wangkaniran puntu. Palunya Jiijajpa Kaliliyamartaji. Nyuntulu Mamamili mirlimirli riitamulku, mirtan nyaku palunya Kurayijpa parna Kaliliyangka yutirriku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jiijajmili wangkaya kulirnu martukajalu, palujanuya ngurrakarti marlaku yanu. Kayilapa Jiijajpa yanu yapukarti. Yini palu yapunga Yalipajpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ngarringu yaarlipalarringu ka marlaku yanu, tawunkarti, Juwumili jaaji majukarti. Palujanuya Jiijajpa nyangu kaya martukaja kujungkarringu. Ka Jiijajpa nyinatingu ka-jananya nintijulpayi. ");
INSERT INTO mpj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Palujanuya Muujajmili wangkapurlukakajalukamu, Parajikajalu wanti manu kangkupayi kaya Jiijajjaluya kinti yikijunu. Wanti jiinya yirna kujupawintiya nyangu kujungkapula ngarripayi. Jampalu ngarripayi, palunyangkaya manu. ");
INSERT INTO mpj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kaluya Jiijajja wajarnu, “Nintipuka! Wanti ngaanyaya manu yirna kujupawinti ngarripayi. Kuruluya nyangu kaya manu palu katipayi, ngaakarti. ");
INSERT INTO mpj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muujajmili luwu jilanya nyininpa, wantila ngaanya yungkalku yapuwintilu miturntalku. Wanyjalpan nyuntulu wajani?” ");
INSERT INTO mpj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jilanyaya japirnu, Jiijajmili wangka kulilkuraya, ngana wajalkuraku. Kulilpayiya jilanya, “Yiipi Jiijajju wajalku, ‘Nyarruya jurra!’ Yiipi jilanya wajalku ngulala kuutja kangku wajalku, ‘Muujajmili luwu warlangu Jiijajju.’” Jiijajju-jananya kulirnu ka wangkaparnilu pupatingu parnangka marawintilu wakalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wululuya japilpayi, ka pakarnu-jananya wajarnu, “Yiipinyurra mirta walyku ngapirnu, palunyangkanyurra kurranyilu yungkala!” ");
INSERT INTO mpj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yarrarnu pupatingu parnangka maralu wakalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jampaya wangka kulirnu palunya kurntarringuya, kaya yanunirra kujunkujunpa, jumajiya kulirnu, “Yuwa ngayurna walykuwinti nyinani.” Jirlpikajapalajiya yanu, palujanuya yirnakaja kaya warrinyjikaja marla yanu. Wulikajaya kurntarrira yanu. Ka Jiijajjalu wanti palunya yikipayi. ");
INSERT INTO mpj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jiijajpa pupanyja palunyangkalu ngarnawarra wantingka nyangu, kara wajarnu, “Wanti! Yaalurringuya? Mirta kujunta yikini yungkaranta miturntalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kara wantilu wajarnu, “Yirna! Yuu, mirtarniya yikini mitu pungkuraku.” Ka Jiijajjura wajarnu, “Ngayululurrjurnanta mirta yungkalkijalu wajarni, mawu yarra!, mirtan yarrala walyku ngapila!” ");
INSERT INTO mpj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Palujanu ngula Jiijajju-jananya yarrarnu wajarnu Parajikajangka jilanya, “Ngayurna layitiyuru nyininpa, martuku wulikajaku. Martukajaluya mungajarra layiti nyakuraka kujungkarrini. Palunyayuru ngayungkarniya layitiyurungka, kujungkarrini wangkaya kulilkuraku. Yiipirni martulu ngayu kulilku Mamamili, palujanu wanka nyinaku. Yiipi martu jiinya ngayungka nyinaku layitiyurungka ngayukuju ninti nyinaku, palujanu mirta mungajarrayurungka nyinaku, ngayukuju ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parajikajaluya Jiijajmili wangkangka jankapayi, wajarnuraya, “Pakiwanan wajani, walyjalun kuliraka, katajanun wajani. Karlki kujupaluntaya wajanngara nyuntun Mamamili, mirtangkun walyjalu wajala! Pakiwanan nyuntulu wajarni.” ");
INSERT INTO mpj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jiijajju-janampa wajarnu, “Walyjalurna kuliraka jungawiyaju wajarni. Yiltangulyurna ngarnawarrajanu yankupayi, karna marlaku yanku. Jungarna wajani, jumajirna Mama ngarnawarrapurlukamili. Nyunturtinparninyurra jankani, mirtarninyurra kulini, ngarnawarrajanurna yankupayi, karna marlaku yanku. ");
INSERT INTO mpj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyunturtinjunyurra nyakura martungka jankanin, mirtanyurra kintilu wangka kulirninpa. Karna ngayulu mirta martu nyakuraka jankanin. Ngayulurna jungalu wajalku. ");
INSERT INTO mpj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngularna ngayulu kuutja martu wajalku, palungkarna jungalu wajalku. Mirtarna ngayulu kujulu wajalku, Mamaluliju kujungkalu wajalku. Jiilurni parnakarti kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Luwu-nyurrampa jilanya nyininpa. Yiipipula martu kujarralu wangka wanarninpa kuju, wangka palunyanga junga nyininpa. Kujarralupula mirta paki kajarninpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngayulurna-nyurranya wangka jungalu wajarninpa ka Mamalulurrjuntaya jungalu wajarninpa, ngayukuju purnturrinpa. Kujarraluliju jungalu wajarninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Japirnuraya, “Wanyjangkangku mama nyininpa?” Jiijajju-janampa wajarnu, “Nyunturtinpanyurra ngurrpa ngayu kujarraku, Mamakamuku. Yiipijunyurra ninti nyinangara, Mamakulurrjuranyurra ninti nyinangara.” ");
INSERT INTO mpj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Wangka jilanya-jananya Juwumili jaajingka majungka nintilpayi, Jiijajju. Jaajingka palungka yinjayiti turampuyuru yikipayi, manikajaya jiingka junkupayi. Paluwarti ngamu Jiijajju-jananya nintilpayi. Mirtaya maajakajalu manu, paki. Mamalu-jananya marrkurnu, mirtaya Jiijajpa mankuraku. Ngulawiyajuya Jiijajpa mankuraku, tayimungka. ");
INSERT INTO mpj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yarrarnu-jananya Jiijajju wajarnu, “Ngurra kujupakartirna yankuni. Purtujunyurra palujanu nyaku. Mirtanyurra jiikarti ngurrakarti yanku. Ngaangkanyurra nyinaku miturriku, mirtanyurra wanka wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juwukajalu maajakajalu-ngkuya japinma, “Mayitpingku walyjalu yanku wakalku miturntalku?, jumaji jilanyayuru wajarnu, ‘Mirtanyurra jiikarti ngurrakarti yanku.’” ");
INSERT INTO mpj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jiijajju-janampa wajarnu, “Nyunturtinpanyurra parnawinti ngurrawinti. Ngayurna ngarnkawinti ngurrawinti. ");
INSERT INTO mpj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wangka palunyarna-nyurranya wajarnu, walykuwintiyan wulu nyinaku miturriku. Yiipirninyurra ngayu mirta kulilku, walykuwintiyan wulu miturriku. Ngayulurna-jananya martukaja wankarnin.” ");
INSERT INTO mpj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","26","Wajarnuraya, “Mirtan nyuntu ngarnkapurluka!” Ka Jiijajju-janampa wajarnu, “Yiltangulyurna ngayu ngarnkapurluka. Jilanyarna-nyurranya rawalu wajalpayi. Ngayulurna-nyurranya jungalu wajalpayi, palujanurninyurra ngayungka jankaninpa. Kulilkuranyurra Mamalu wululu jungawiyaju wajarninpa. Jiilurni wajarni, palujanurna ngayulu jungalu wajarni, martukajangka.” ");
INSERT INTO mpj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wangka palunyaya kujupayuru kulilpayi. Mirtaya kulilpayi Jiijajpa Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Palujanu-jananya Jiijajju wajarnu, “Ngularninyurra yikijunku wartangka, martu yarnngaku marlpa, palujanurninyurra kulilku, ngayurna Kurayijpa. Martukajarna-jananya wankarnin, jilanyanyurra kulilku. Mamalurni wajarni, palujanurna ngayulu jungalu martukajangka wajarni. Mirtarna ngayulu kujulu kulira wajarni, Mamarna kulirni, palujanurna wajarni. ");
INSERT INTO mpj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mama jiilurni kurtingu parnakarti ngaakarti, mirtarni junu yanu kujungkaliju nyininpa. Jumajiju pukurlpa nyininpa, ngayulurna palumili wangka kuliraka junga nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Martukajaluya palumili wangka kulirnu kaya palumili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ka-jananya Jiijajju wajarnu, jiikajangka palumili walyjakajangka, “Yiipinyurra ngayumili wangka kulilku, ka junganyurra nyinaku, palujanunyurra ngayumili walyjakaja nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kanyurra nintilu kulilku, ngayulurna martukajamili walykukaja warningkuni, palujanu mirtanyurra walykukaja kulinmalpa ngapilkuraku, walykukajanyurra junku yanku. Warrkamupurlukayurunyurra nyininpa, maaja walykuluntaya kanyini.” ");
INSERT INTO mpj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Martukajaluya kulirnu ka wajarnu, “Mirta-lanya maajalu walykulu warrkamupurluka kanyini. Nyininpalaju Yipurammili marlajanukaja, maajakaja, mirta-lanyaju warrkamupurluka maajalu walykulu kanyini. Nganan nyuntulu wajani?, warrkamupurlukalaju maajaku nyinin?” ");
INSERT INTO mpj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jiijajju-janampa yarrarnu wajarnu, “Martulu maaja kulira nyininpa, jilanyala kulini. Yipi martu kujupalu wululu walyku ngapinmalpa, martu jiilu walyku kulira nyininpa, maajayuru. ");
INSERT INTO mpj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Warrkamupurluka wulu maajamili ngurrangka warrkamurrini ka ngula warrkamu kujupa yanku ngapilku ngurra kujupangka. Mirta warrkamupurluka maajamili pamulikajangka wulu nyininpa, kaja walyjawiyajura wulu pamulikajangka jiingka nyininpa. Kaja palunyayururna ngayu Mamamili walyja wulu nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Warrkamupurlukalu maaja kulira nyininpa. Palunyayuru martulu walykukaja kulira nyininpa, maajayuru. Yiipi ngayulurna-nyurranya walykukaja warningku, Mamamili kajalu, palujanunyurra mirta walykukaja kulira nyinamalpa, mirtanyurra maajayuru kulira nyinamalpa, walykukaja. Warrkamupurlukaparninyurra nyinamalpa, walykukajanyurra mirta kulira nyinamalpa, maajayuru.” ");
INSERT INTO mpj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jiijajju-jananya yarrarnu wajarnu, “Ngayulurna-nyurranya kulirninpa, Yipurammili marlajanunyurra nyininpa, mirtanyurra kunyjunyu nyininpa. Ngayurninyurra kulini mitu pungkukijalu, jumaji ngayumili wangkanyurra kulira junkurni. ");
INSERT INTO mpj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngayulurna-nyurranya wajani, Mamalurni nintini, karna-nyurranya wajarni. Kanyurra nyunturtinmili mama kulira kanyurra ngapini.” ");
INSERT INTO mpj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jiikajaluraya wajarnu, “Ngayurtinmili mama maju, Yipurampa nyinapayi.” Ka Jiijajju-jananya wajarnu, “Yumunyurra nyininpa, mirta Yipurammili marlajanukaja, walyjakaja. Yiipinyurra Yipurammili marlajanukaja kunyjunyunyurra nyinangara, Yipuramuyurunyurra nyinangara kunyjunyu. ");
INSERT INTO mpj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngayulurnantaya wululu Mamamili wangka jungalu wajalpayi, jii Mamalurni nintinyjangka, karninyurra kulini mitu pungkukijalu. Mirta jilanyalu Yipuramju kulilpayi, miturni pungkukijalu, paki. ");
INSERT INTO mpj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyunturtinmili mamalu julyju ngapilpayi, kanyurra kuwarri, mama palu kulira ka ngapini.” Ka wajarnuraya, “Mama ngarnawarrapurluka ngayunku-lampaju mama nyininpa. Yiltalaju nyinin palumili walyjakaja, kajaparaku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ka Jiijajju-jananya wajarnu, “Yumulunyurra wajani. Yiipi Mamakuranyurra kunyjunyu nyinangara, ngayurninyurra layikamurrira kulira nyinangara, jumajirna ngayu Mamajanu yankupayi. Mirtarna walyjalu kulirnu ka ngaakarti yanurni, Mamalurni kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngayumili wangkanyurra kulira juninpa, purtunyurra kulini. ");
INSERT INTO mpj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yiltanyurra nyininpa malpuku maajaku walyjakaja. Malpu jiilu-nyurranya muunpungkuni, ka kuliranyurra jiiwana ngapini. Malpu jiilu julyju kulira ka martu mitu pungkupayi. Wulu mayunyju nyinapayi, julyju, ka kuwarri wulu mayunyju nyininpa. Mirta junga wajalpayi, paki kajalpayi. Ka kuwarri wululu paki kajarni. ");
INSERT INTO mpj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ka ngayulurna-nyurranya wululu jungalu wajarni, karninyurra kulira juninpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngayulurna mirta walykukaja ngapini, karna mirta paki kajani. Ngayulurna-nyurranya jungalu wululu wajarni, palujanunyurra ngayumili wangka jungalu kulinngara. ");
INSERT INTO mpj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yiipi martu Mamamili walyja nyininpa, palumili wangka jungalu kulini. Kanyurra mirta Mamamili walyja nyininpa, ngayumili wangkanyurra kulira juninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juwukajalu maajakajaluya wajarnu, “Yiltalaju jungalu wajalpayi. Nyuntungan malpuwinti, ngurra Jamiriyamartaji.” Juwukajaluya Jamiriyamartajikaja nyurnimankupayi jilanya, “Jii Jamiriyamartajiya walyku nyinani, Mamakuraya ngurrpa nyinani.” ");
INSERT INTO mpj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Palujanu Jiijajju-jananya wajarnu, “Mirtarna ngayu malpuwinti, ngayurnara pukurlpa Mamaku nyininpa. Kayilapajunyurra mirta pukurlpa nyininpa, jankaninparninyurra. ");
INSERT INTO mpj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mirtarna kulini martukajajuya pukurlarrikura, paki. Ngayumili Mamalurni kuju kulini ngayurni marninypungkuni, ngayukuju punturrinpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wangka ngaanyaya kulila! Yiipiju martulu ngayuku wangka nyurilu kulinmalpa, mirta wulu miturriku, wanka wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wajarnuraya, “Yiltan nyuntu malpuwinti. Mitunyjarri-lampaya nyinangu miturringu Yipurampakamu Mamamili jakurlpurlukakaja. Wulikajala nyinaku miturriku. Wanyjalpan nyuntulu wajani?, ‘Martulu ngayuku wangka nyurilu kulinmalpa, mirta wulu miturriku?’ ");
INSERT INTO mpj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nyuntun mirta miinwanpa Yipuramja munkarra. Yipurampa miturringu, nyuntulurrjun miturriku, nyuntumili wangkapurlukalurrjuya miturriku.” ");
INSERT INTO mpj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jiijajju-jananya wajarnu, “Mayitpirnaju ngayulu marninypungkujaku, palunyangka martu kujupalurni wajaljaku, ‘Nyuntun mayunyju, walyjalungkun marninypungkuninpa.’ Kuliranyurra pukurlarrinpa Mama ngarnawarrapurlukaku, jiilurni ngayu marninypungkuninpa. ");
INSERT INTO mpj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Palunyakuranyurra ngurrpa nyininpa, ngayuwiyajurnara ninti nyininpa. Yiipirna ngayulu kajalngara, ‘Ngayurnara ngurrpa Mamaku.’ Palunyangkarna mayunyju nyinangara, nyunturtinyururna mayunyju nyinangara. Yiltarnara ninti nyininpa, palumili wangkarna kuliraka jungalu ngapini. ");
INSERT INTO mpj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mitu-lampa Yipuramu julyju pukurlarringu, jamparna ngayu ngula parnakutu yankukijalu. Parnaturna yanurni palujanurni nyangu ka pukurlarringuju.” ");
INSERT INTO mpj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wajarnuraya, “Mirtan mitunyjarripurluka Yipurampa nyangu, paki, nyuntu warrinyji.” ");
INSERT INTO mpj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Jampa Yipurampa julyju nyinapayi, ngayurna wulu kurranyi nyinapayi.” ");
INSERT INTO mpj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jiikajaluya kulirnu jilanya, “Jiijajpa jii parnapurluka, mirta ngarnawarrapurluka, paki.” Palunyajanuya wirrilyirringu yapukajaraya manu yungkalkijaluya Jiijajpa. Ka kukurringu-janampalura Juwumili jaaji maju junu yanu. ");
INSERT INTO mpj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Palujanu Jiijajpa ruutuwana yankupayi, ka kuju yirna nyangu pampuru. Pampuru wulu nyinapayi julyju japuwartajanu. ");
INSERT INTO mpj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Palumililu wangka-nintikajaluraya japirnu jilanya, “Nintipuka! Jiinya pampuru nyininpa jumaji kaji walyku ngapirnu? Mirta japuwartalu walykukaja ngapilpayi, paki. Kajipula palumili yipilukamu mamalu walyku ngapilpayi?” ");
INSERT INTO mpj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jiijajju-janampa wajarnu, “Mirtanyurra kulinma!, walyku ngapinyjanjanu pampuru nyininpa, paki. Mirta japuwarta pampuru nyininpa, palumili mamalukamu yipilu walyku ngapirnu. Mama ngarnawarrapurlukalu julyju kulirnu, ngaanyarna ngayulu pampulku kunyjunyunku, kaya martukajalu nyakura marninypungkuraku Mama. ");
INSERT INTO mpj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Karrpungkala warrkamurrinpa, ka mungangkala mirta warrkamurrinpa, purtula nyakuninpa. Jilanyayurula ngayurtinju Mamamili warrkamu karrpungka ngapirninpa. Mungajarrarriku, palujanula purtu kulilku, palumili warrkamu ngapilkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Parnangkarna nyinaninpa ngayurna-janampa layitiyuru nyininpa, martuku yarnngaku. Martulurniya yarnngalu ngayu kulilku, kaya wanka nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jiijajju-janampa wangka jiikaja wajarnu, kayila parnangka jangajunu. Jampa jangajunu parnangka manuyila parnawintilurrju, kalu pampurungka kurungka junu. ");
INSERT INTO mpj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wajarnura, “Yarrangku kalyungka ngumpa waajamula!, kalyu yini Jalumpa.” Kalyuya palunga wajarni, yini “Kurtiwa!” Yanungku kalyungka palungka waajamunu, kayilapa nyakupayi. Pampurujanu kuru kunyjunyurringu, ka marlakulu yanu Jiijajkarti. ");
INSERT INTO mpj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Martu karlkinjuya nyangu pampurujanu kunyjunyu parra yankupayi, palumili walyjakajalulurrju. Nyangukaya kuru pakarnu. Jiikajaluya julyju nyakupayi pampuru nyinapayi, ngajilpayi-jananya manikukamu mirrkaku. Japilpayi-ngkuya, “Jiinya nyinapayi ngajilpayiwiyaju?” ");
INSERT INTO mpj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Karlkilungaya wajarnu, “Yuu palungulyu yilta.” Karlki kujupaluya wajarnu, “Paki, kujupa jiinga ngajilpayiyuru.” Yirnalu jiilu kulirnu-jananya ka wajarnu, “Ngayungulyurna pampurujanu yikininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Japirnuraya, “Yaalun kuru kunyjunyurringu?” ");
INSERT INTO mpj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wajarnu-jananya, “Yirna palu, martuluya yini Jiijajpa wajani, jiilu jangajunu parnangka ka manurni kurungka junu. Jiilurni wajarnu kalyu Jalumjarnaju ngumpa waajamulkura, palujanurna kuru kunyjunyurringu.” ");
INSERT INTO mpj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ka japirnuraya, “Jiinya Jiijajpa yaalurringu?” “Ngurrpa.” jilanya-jananya wajarnu, jiilu pampurujanulu. ");
INSERT INTO mpj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Palujanuya karlki kujupalu pampurujanu winirnu katingu Parajimapukarti. ");
INSERT INTO mpj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Parajikajaku luwu-janampa nyininpa, mirtaya Jarritingka warrkamurrinpa. Palungka karrpungka Jiijajju pampuru palunya kunyjunyunu. ");
INSERT INTO mpj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parajimapuluraya yarrarnu japirnu, “Kuru pampurujanun yaalu kunyjunyurringu?” Wajarnu-jananya, “Jiilu jangajunu parnangka, kayilapa manurni kurungka junu. Karnaju waajamunu ngumpa kalyungka, kuruyilaparna kunyjunyurringu.” ");
INSERT INTO mpj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Karlkinjuya purtu kulilpayi, “Yirna palunga mirta Mamamili, Jarritingka palunga warrkamurringu, pampuru jiinya kunyjunyunu.” Karlkin kujupaluya wajarnu, “Paki, mirta Jiijajju Mamamili luwu warlangu, kunyjunyunu Mamamili maparnwintilu.” Jilanyaya karlkin kujupa ngunjularripayi. ");
INSERT INTO mpj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Palujanuraya yarrarnu japirnu, “Wajarnu-lanyajun palulunta kuru kunyjunyunu. Wanyjalpan nyuntulu kulini paluku?” Ka wajarnu-janampa, “Palunga Mamamili jakurlpurluka.” ");
INSERT INTO mpj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Parajikajaya wulu ngunjularripayi jilanyaya wajalpayi, “Mirta ngaa pampuru nyinapayi.” Palujanuya mirrangu palumili mamakukamu yipiku. ");
INSERT INTO mpj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Japirnu-pulanyaya, “Ngaanyangku nyuntuku kaja?” Ka yuujunupula. Kayilapa yarrarnu-pulanyaya japirnu, “Wajarnipulan kuru pampuru ngaanya nyinapayi. Yaalu kuru kunyjunyurringu?” ");
INSERT INTO mpj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wajarnu-jananyapula, “Yilta ngaanya kaja-limpaju, kuru pampuru nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Purtuliju kulini, yaalu kuru kunyjunyu nyinani. ‘Nganalu kunyjunyunu?’ Purtuliju kulini. Ngaanya yikini yirna, murtilyaparni. Nyunturtinjuraya japila!” ");
INSERT INTO mpj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jilanyapula wangkangu, jumajipula ngurlurripayi Parajikaja maajakajangkamarra. Kulirnupula julyju Parajikajaluya wajalpayi, “Yiipi martuluya Jiijajpa Kurayijpa wajalku Mamamili, palujanuya Juwumili jaajingka kurrungkunyjangka, ngumpalkuya kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jiingkamarrapula ngurlurripayi, jilanyalupula wajarnu ngurluwintilu, “Japilaraya yirna jiinya!, murtilyaparni.” ");
INSERT INTO mpj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yarrarnuraya muunpungu Parajikajalu yirna paluku, pampurujanuku, “Kulirninpalajura Jiijajpa jiinya mirta Mamamili jakurlpurluka nyininpa. Jilanyan nyuntulu kulilkura! Ngarnawarrapurlukangka Mamangka kurungka jungalu-lanyaju wajala jilanya!, ‘Jiijajpa mirta Mamamili.’” ");
INSERT INTO mpj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wajarnu-janampa, “Mayitpi Mamamili luwu warlangu, mayitpi paki, ngurrparnara. Jilanyakuwiyajurna ninti nyininpa, julyjurna kuru pampuru nyinapayi, kuwarrirna kunyjunyu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Japirnuraya pampurujanu, “Wanyjalpanta kuru kunyjunyunu?” ");
INSERT INTO mpj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wajarnu-janampa, “Julyjurna-nyurranya palunya wajarnu, palujanunyurra kulirnu junu. Mirtarna-nyurranya wangka palunya yarrara wajalkura. Ngayulurna kulini mirtanyurra kulini Jiijajkuranyurra walyja nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kayilapa payirnuluya, “Nyuntungaran Jiijajku palunyaku pukurlarrinpa, palumili wangkan nyuntulu kulini. Ka ngaalajura mitunyjarripurlukaku Muujajku pukurlarrinpa, palumili wangkalaju kulirnin. ");
INSERT INTO mpj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mamalu yilta Muujajpa wajalpayi. Muujajmili wangkalaju kulini, jumaji Mamamili. Jiijajju mirta Mamamili wangka kanyirninpa, paki. Mirtalaju kulirni palu ngarnkajanu.” ");
INSERT INTO mpj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pampurujanulu palunyalu-jananya wajarnu, “Palulurni Mamamili maparnwintilu kuru kunyjunyunu. Nintiranyurra nyinangara, palu ngarnkajanurni yankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jilanyala kulini yarnngalu. Yiipilara parlanypa Mamaku, jampalara japilku Mama, palujanu mirta-lampa kunyjunyu ngapilku, paki. Jiijajpara mirta Mamaku parlanypa nyininpa, yilta palunga Mamamili. Yiipilara pukurlpa Mamaku, jampalara japilku Mama, palujanuyilapa kunyjunyu-lampa Mamalu ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yarrarnu-janampa pampurujanulu wajarnu, “Mitunyjarriluya mirta julyju kuru kunyjunyulpayi, purtuya-jananya pampurukaja kunyjunyulpayi. ");
INSERT INTO mpj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ka ngayurni kuru kunyjunyunu palulu, Mamamili maparnwintilu. Yiltangulyu palunga Mamamili, ngarnkajanu.” ");
INSERT INTO mpj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wirrilyirringu kaluya jankangu. Wajarnuraya, “Nyuntun walykuwinti nyinani. Nyuntumili mamakamu yipipula walykuwinti nyinapayi, palujanu nyuntu kuru pampururringu. Mirta-lanyajun wajala wangka palukaja! Nyuntun mirta nintipurluka.” Kayilapaya jaaji majujanu payirnu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Palujanu Jiijajju jakurlpa kulirnu, pampurujanu palunyaya jumaji payirnu kurtingu. Kayilapara Jiijajju parra ngurrilpayi. Nyangukara japirnu, “Martuku yarnngaku marlpakun nyuntulu kulini, palu Mamamili?” ");
INSERT INTO mpj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jiijajkura wajarnu, “Ngayulurna purtu kulini. Ngana martuku yarnngaku marlpa? Ngayurna layikamurrinpa, ngana palurna kulilkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jiijajjura wajarnu, “Julyjurnin nyangu martu yarnngaku marlparna wangkaninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jiijajkura wajarnu, “Maajawu! Kulinirnanta Mamalunta ngalyarni kurtingu.” Pupatingu Jiijajpa marninypungu. ");
INSERT INTO mpj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ka-janampa martukajaku Jiijajju wajarnu, “Parnakuturna ngayu yankupayi martukajarna-jananya katamatulkuraku. Karlkiya kuru pampuruyuru nyininpa. Ngayuku wangkaya kulilku kaya walyjarriku, kuru kunyjunyuyuruya nyinaku. Ka karlki kujupaya kuru kunyjunyuyuru nyininpa, ngayukujuya parlanypa. Ngayuku wangkajuya kulilku junku, kuru pampuruyuruya nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ngamuluya yikipayi Jiijajja Parajikaja. Palukajaluya kulirnu karaya wajarnu, “Mirtalaju palunyakajayuru kuru pampurukajayuru nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jiijajju-jananya wajarnu, “Yiipinyurra Mamaku ngurrpa nyinangara, kuru pampuruyurunyurra nyinangara, walykukajanyurra yurtuyurtulu ngapinngara. Kayilapa-ngkuyan kajarnin, ‘Mamamili wangkalaju kulirni, nintilaju nyininpa.’ Jilanyanyurra kulini kanyurra nintilu walykukaja ngapini, ngayurninyurra junkura yankurni, Mamamili, palujanu Mamalu-nyurranya ngula warrkilku kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Jiijajju-jananya yarrarnu wajarnu, “Wangka ngaanyaya kulila! Jiipukura maaja jiipumili yaartungka kiitungka yankura kurrungkuni. Ka kujupalu maajaparnilu piinyjingka takara ngulyulu mankuni. ");
INSERT INTO mpj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kiitungka palungka nyininpa kiitupurluka, warrkamupurluka. Jiilu kurrujuni yaartungka jiipupurlukawiyaju maaja. Maaja jii-jananya palumili jiipukajaku mirraku, jiipu palunyaya yiniwinti nyininpa. Jampa maajalu-jananya yini wajalku, ka jiikajaluya maaja walyja kulilku, kaluya wanalku. ");
INSERT INTO mpj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kurranyi-janampa maaja yanku, kaluya jiipukajalu marlawanalu wanalku. Jampa-janampa maaja mirraku, kaluya pinirriku, jumajiraya ninti palumili wangkaku. ");
INSERT INTO mpj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jampa maaja kujupalu-janampa mirraku, mirtaluya wanalku. Wangka kujupaya kulilku, kaya ngurlu pinirriku, jumaji wangka palumilikuraya ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Wangka palunya-jananya yumuwanpa Jiijajju wajarnu, Parajikajangka, kulilkurakuya kaya nintirrikurakuya. Palujanu purturaya wangkaku paluku kulirnu. ");
INSERT INTO mpj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Purtu kulirnukaya, palujanu Jiijajju-jananya yarrarnu wajarnu, “Wangka ngaanyaya ngangkula! Martu walykukajaya yanku yaartukarti, jiipuku mirraraku, ka ngulyuluya mankuraku. Kayilapaya jiipukajalu kulilku wangka kujupa, kayilapaya ngurlu pinirriku wirrirli, palukajangkamarra. Ngayurnara paluku yaartuku kiitupurlukayuru, Jiipuku maaja nyininpa. Ngayulurna-jananya wajalku, karniya jiipukajalu kulilku kaya kurrungku. Jilanyayururniya jampa martukajalu kulilku, kaya Mamamili ngurrangka kurrungku wanka nyinamalpa. Ngayulurna-jananya yaartungkayuru ngampurrju kanyilku, kaya kunyjunyu nyinaku, jiipuyuru mirrkawintikamu kalyuwinti. Jamparniya kujupakaja walykukaja ngayukarti kiitukarti yanku, karna-jananya warrkilku kurtingku, jumajiya walykukaja, jiipu ngulyupayikajayuru. ");
INSERT INTO mpj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jiikajaluya ngulyupayikajalu jiipukaja manku, kaya kangku miturntanku. Mirtarna ngayu jiikajayuru, ngayulurna-nyurranya martukaja walyjakaja kangkura wanka ngampurrju kanyini. ");
INSERT INTO mpj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ngayurna jiipuku maajayururna kunyjunyu nyinani. Martukajarna-jananya wanka kanyini. Jiipuyururna-jananya wululu wanka kanyini, mirtarna-jananya junku yanku, yiipirniya kujupakaja yankurni, mitu pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Karlkin kujupaluya warrkamupurlukalu jiipukaja kanyini, maajalu-jananya payamulkuraku. Jiikajaluya yumulu jiipukaja kanyini, maajakuraya. Ka tingku jikipalarni yanku, kaya jiikajalu warrkamupurlukalu mirta pungku, ngurluya pinirriku. Jiilu tingkulu jiipukaja pajalku, kayilaya jiipukaja ngurlu pinirrikunirra. Kayilaya warrkamupurlukakaja ngurlu pinirriku. Mirta jiipukaja-jananyaya ngampurrju kanyilku, palungaya yumu maniku warrkamurrini. ");
INSERT INTO mpj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngayurna jiipuku maajayururna kunyjunyu nyinani. Ngayumili Mamakurnara ninti nyininpa, ka puntajiju ngayuku ninti nyininpa. Palunyayururna-janampa martukajaku walyjakajaku ninti nyininpa, palunyangkajuya puntaji ngayuku ninti nyininpa. Jiipukajayururna-jananya ngampurrju kanyilku, karna-janampa miturriku. ");
INSERT INTO mpj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Karlkin kujupaya nyininpa, ngayuku walyjakaja, Juwuparnikaja, jiipuyuruya yaartu kujupangka nyininpa. Ngayulurna-jananya yanku manku, karna-jananya yaartungka kujungka junku, Juwukajangka. Ngayumili wangkaya kulilku, ka kujungkarrikuya, Juwukajakamu Juwuparnikaja. ");
INSERT INTO mpj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ngayumili Mamaju layikamurrira nyininpa, jumajirna kulini jilanya, ‘Martuku yarnngakurna-janampa miturriku, palujanurna mitujanu wankarriku. ");
INSERT INTO mpj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mirta kujupalurniya walyjalu kuliraka kuwarri pungku, ngula ngayuluwiyajurna kulilku, palunyangkarniya pungku, palunya tayimungka. Ngayuluwiyajurna kulilku miturriraku, palujanurna wankarriku. Jilanyarna miturriku karna wankarriku, Mamaluju wajarnu.’” ");
INSERT INTO mpj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jiijajmili wangkaya purtu kulirnu, kaya ngunjularringu. Karlkin kujupaluya wangka kuju kulirnu, ka karlkin kujupaluya wangka kujupa kulirnu. ");
INSERT INTO mpj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wajarnu-ngkuya karlkilu, “Palunga malpuwinti, ngakumpa nyininpa, mirtala kulilkura.” ");
INSERT INTO mpj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ka karlkin kujupaluya wajarnu, “Mirta malpuwinti palunga wangkinpa. Mirta malpuwintilu kuru kunyjunyuni, maparnwintilu kuru kunyjunyuni.” ");
INSERT INTO mpj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wantajarrangka martukajaya Jarujalumja kujungkarripayi turlkungka nyinakuraku. Turlku-janampa yini “Titikajinpa.” nyinapayi. Jiingkaya Mama marninypungkupayi, jaaji majungka. Jilanyaya kulilpayi, “Mamalu-lanyaju jaaji ngaanya yungu.” Jaaji palukuya pukurlarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Palungka Jiijajpa yanu yikipayi, puringka yini, Jalamanmilingka. ");
INSERT INTO mpj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Palujanu Juwukajaluraya maajakajalu japirnu, “Purtulaju kulini, mayitpin nyuntu Kurayijpa, Mamalu julyju jamartapungu kurtingkuraku, mayitpi paki. Wajala-lanyaju yiltalu!” ");
INSERT INTO mpj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jiijajju-jananya wajarnu, “Ngayulurnantaya julyju wajarnu, kulirnunyurra junu. Ngayulurna Mamamili maparnwintilu ngapilpayi, kanyurra nyakuraka yiltalu kulilngara. ");
INSERT INTO mpj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nyakurakanyurra juninpa. Ngayumilinyurra mirta jiipukajayuru nyininpa, ngayumilinyurra mirta walyjakaja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Karlki kujupaya nyininpa ngayumili jiipuyurukaja, ngayumili walyjakaja. Palukajaluya ngayumili wangka kulini, kaya jungalu ngapirninpa. Yilta, nintirna-janampa nyininpa. Ngayurniya wanarninpa, jiipukajayurulu. ");
INSERT INTO mpj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngayulurna-jananya ngampurrju kanyini, wanka wuluya nyinakuraku, mirtaya mitu rawa wulu ngarriku. Ka martu kujupalu-jananyaya purtu muunpungku, ngayurniya junku yankuraku. ");
INSERT INTO mpj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ngayumili Mamalu-jananya yintarnu junu, ngayumili walyjakaja, ka kujupalu-jananyaya purtu muunpungku, ngayumili Mamaya junku yankuraku. Mamalu-jananya wululu maparn majuwintilu kanyinmalpa, Mamamili marangkaya nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ngayulurrjurna maparn majuwinti nyininpa, Mamararraliju maparn majuwinti kujuwinti nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Palujanuya Juwukajalu maajakajalu wangka palunya kulirnu, kaya wirrilyirringu. Kaya yapukaja manu yungkaraya Jiijajpa miturntalkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jiijajju-janampa wajarnu, “Kulilaya! Rawalurna-nyurrampa ngayulu Mamamili maparnwintilu kunyjunyu ngapilpayi, mirtanyurra jilanya kulini. Ngananyurra kulini yungkalkurakurniyan?” ");
INSERT INTO mpj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wajarnuraya, “Nyuntulun kunyjunyu ngapilpayi, kulirninpalaju. Nyuntulun kuwarri pakiwana wajarnu jilanya, ‘Mamararraliju maparn majuwinti kujuwinti nyininpa.’ Mirtan nyuntu maparn majuwinti Mamayuru nyininpa, nyuntun martu parnapurluka nyininpa, palujanulajunta kuwarri yungkarninpa.” ");
INSERT INTO mpj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jiijajju-janampa wajarnu, “Mamamili wangka nyininpa, mitunyjarriluya julyju wakarnu jilanya, ‘Mamayurunyurra nyininpa, maparn majuwinti.’ ");
INSERT INTO mpj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mamamili wangka wulu yiltangulyu, nyininpa, jilanyala yarnngalu kulirninpa. Julyjuya martukajalu Mamamili wangka kuliraka pukurlpa nyinapayi. Mamalu-jananya wajarnu, ‘Mamayurunyurra nyininpa, maparn majuwinti.’ ");
INSERT INTO mpj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ka Mama jiilurni yintarnu ka parnatu ngaakartirni kurtingu. Mirtarninyurra wajala!, ngayulurna palu wangka pakiwana wajarni. Wangka jilanya, ‘Mamararraliju maparn majuwinti kujuwinti nyinani, palumili kajarnara nyinani.’ Pakiwananyurra kulini. ");
INSERT INTO mpj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngayumili Mamalurni wajanyjangka mayitpirna mirta ngapilku, palujanurninyurra kulilku junku. ");
INSERT INTO mpj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngayulurna yiltalu Mamamili wangka kulini ka jungalu ngapini. Palujanunyurra jungalu kulilngara jilanya, ‘Yilta jiilu maparn majuwintilu ngapirni, yilta jiinga Mamamili. Maparn majuwintipula kujarra nyininpa.’” ");
INSERT INTO mpj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yarrarnuya kulirnu Jiijajpa mankukijalu, kayila Jiijajpa-janampalura maapungka martungka yaka yanu. ");
INSERT INTO mpj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Karrungka kakarrara Juutunja Jiijajpa yanu nyinapayi. Palungka-jananya julyju Jaanju kalyungka jarrpajunkupayi, martukaja. ");
INSERT INTO mpj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","Jiijajjaluya martu yarnnga yankura kujungkarripayi, palumili wangkaya kulilkuraku. Yarnngaluya Jiijajpa kulirnu karaya Jiijajku walyjarringu. Wajarnu-ngkuya martukajalu, “Ngaalu kujupa kujupa yalyjirrju ngapini, ka Jaanju jilanya mirta yalyjirrju ngapilpayi. Jaanju yiltalu-lanyaju wajalpayi, ngaanya yiltaminyirri yalyjirrpa.” ");
INSERT INTO mpj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yirna kuju yini Lajarajpa ngarnta ngarripayi palumili ngurrangka, tawun Piijaningka. Palumili marlaju kujarrapula ngurra palunyangka nyinapayi, yini kujunga wanti Maajajpa ka kujupanga wanti yini Miiri. ");
INSERT INTO mpj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Palunyalulu Miirilu ngula yintirnu jinyji parnti kunyjunyu, Jiijajja jinangka. Jampalu yintirnu jinangka, kayilapa kata palumililu jina wayipamurnu. Jilanyaluya jinyjikaja yintinma, Juwukajalu. ");
INSERT INTO mpj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jurturarralupula kuju wangkapurluka kurtingu, Jiijajpa yankura mankuraku. Ka Jiijajpa ngurra wirrirlingka palu nyinapayi, kalu yanu jakurljunu, “Maaja! Yirnakuran nyuntu pukurlpa nyininpa, palunyanga ngarnta maju ngarrinpa.” ");
INSERT INTO mpj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jiijajju kulirnu kalu wajarnu, “Lajarajpa mirta wulu miturriku. Mamalu kulirni Lajarajpa ngarnta maju ngarrini, kayilapaya martulu ngula kulilku, kaya Mama marninypungku. Ngayulurrjurniya palumili kaja marninypungku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jiijajpa-janampa layikamu nyinapayi, Lajarajkamu Maajajku, ka Miiriku. ");
INSERT INTO mpj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lajarajpa ngarnta ngarripayi, palujanu Jiijajju kulirnu, ka karrpu kujarrangka majalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Palujanu Jiijajju-janampa palumili wangka nintikajaku wajarnu, “Ngurra Juutiyakartila marlaku yanku!” ");
INSERT INTO mpj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ka wajarnuraya, “Nintipuka! Julyjuntaya ngurra palupurlukalu yungkanngara, yapuwintilu. Nyaaku-jananyan marlaku yaninpa, palukarti?” ");
INSERT INTO mpj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jiijajju-janampa wangka wajalpayi, nintijulkuraku-jananya jilanya, “Karrpu yikiku rawa ka mungajarrarriku. Martuya karrpungka parra yankuni, mirtaya pirtingka punkani. ");
INSERT INTO mpj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ka martuya mungajarra parra yankuni, pirtingkaya punkani, jumajiya mirta nyakuni.” ");
INSERT INTO mpj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ka Jiijajju-janampa yarrarnu wajarnu, “Lajarajpa-lampa marlpa kunyala ngarrinpa. Yankula palukarti karna ngayulu wankalku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wajarnuraya, “Kunyalajanu walyja kanarriku, ka parra yankumalpa.” ");
INSERT INTO mpj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","14","Jiijajju kulirnu Lajarajpa mitu ngarripayi, kaya kulirnu kunyala ngarripayi. Pakiwanaluya kuliljaku Jiijajju-janampa jilanya wajarnu, “Lajarajpa mitu ngarrinpa. ");
INSERT INTO mpj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kunyjunyula ngaangka majani, kulilkurakurniyan ngula, ngayulurna martukaja wankani. Nyamu yankurala.” ");
INSERT INTO mpj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jiijajmili wangka-ninti Tamajpa nyinapayi palungka. Palu yini kujupaya wajalpayi, “Tuwinpa.” Wajarnu-jananya jiilu, karlki kujupangka, wangka-nintikajangka, “Yurtuyurtula yankura, kujungka-lanyaya pungkura mitu.” ");
INSERT INTO mpj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Tawun Piijaninga ngamu yikipayi tawun Jarujalumungka. Kaya Jiijajmapu yanu tawun Piijaningka kurrungu. Lajarajpanga julyju miturringu, ka pirnkingka ngarripayi, karrpu puu wulikajangka. ");
INSERT INTO mpj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juwukajaya ngurra kujupajanu, ngurra kujupajanu kulirnu, kaya ngurra palungka kujungkarringu, jampa Lajarajpa miturringu, palumili marlaju kujarra-pulanyaya yanu kululkuraku. ");
INSERT INTO mpj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jiijajpa yanurni ngamurringu, ka Maajajju jakurlpa kulirnu, kayila maya junu yanu, ka Jiijajjalu kujungkarringu. Palu tayimu Miiringa mayangka wulu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maajajjulu Jiijajja wajarnu, “Maaja! Yiipin nyuntu ngaangka nyinangara, kunyjunyulaju kurtararranpa nyinangara, mituparni. ");
INSERT INTO mpj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngayulurnanta kulini, yiipiran nyuntulu Mama ngarnawarrapurluka kuwarri japilku, yalyjirrjungku ngapilku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jiijajjura wajarnu, “Nyuntumili kurtangku wankarriku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wantilu yini Maajajjura wajarnu, “Yuu. Palunga ngula wankarriku pakalku, jampaya mitujanu ngula pakalku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jiijajjura wajarnu, “Ngayulurna-jananya mitujanu martukaja wankarninpa. Jampa martulurni ngayu kulilku Mamamili, jampa miturriku, palujanuyila wanka wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jamparni yiltalu ngayu kulilku Mamamili, palujanu yilta wanka wulu nyinamalpa, mirta wulu mitu ngarrimalpa. Kajin wangka nyuntulu jilanya yiltalu kulini?” ");
INSERT INTO mpj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ka Maajajjura wajarnu, “Yuwa maaja! Nyuntunyan Kurayijpa Mamamili kaja, parnakutun julyju yanurni. Wangkarna palu yiltalu kulini.” ");
INSERT INTO mpj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maajajju ngaanya wajalpayi, ka yanu palumili marlaju Miiri manu. Ka yanulu yakalu jakurljunu, “Nintipurlukarni yankuni, ka nyuntukungku wangkangu, yankuralun wangkakura.” ");
INSERT INTO mpj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Miirilu kulirnuka pipurrulu pakarnu yanu. Ngurra paluwarti nyangu, Maajajju julyju palungka nyangu. Jiijajpa tawunu Piijaningka kinti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Miirimililu walyjakajaluya kujungka yulapayi. Palukajaluya nyanguka wanarnu kulilpayiya, “Mayitpi ngaa pirnkikarti yankuni, jiingka yulakuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ka Miirilu yanu Jiijajja pupatingu, kalu wajarnu, “Maaja! Yiipin ngaangka nyinangara, ngayuku kurtaju wanka nyinangara.” ");
INSERT INTO mpj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Palujanuya Miirimapu yulapayi. Ka Jiijajju-jananya nyangu, ka-janampa nyarrurringu wirla walykurringu. ");
INSERT INTO mpj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Japirnu-jananya, “Wanyjangkayan ngarrijunu?” Ka wajarnuluya, “Maaja ngalyarnirni yarra!, nintijulkulajunta.” ");
INSERT INTO mpj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kulirnu Jiijajju ka yulapayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jiikajaluya nyanguka wajarnu, “Nyawaraya mituku palukura layikamu nyinapayi!, palujanu yulani.” ");
INSERT INTO mpj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Karlkiluya wajarnu, “Palulunga kuru pampuru kunyjunyunu maparnwintilu, yiipi ngaangka nyinangara, kunyjunyunngara mitu palunya.” ");
INSERT INTO mpj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jiijajpa yarrarnu wirla walykurringu, ka yanu pirnkikarti. Miirikamu Maajajmapuluya julyju pirnkingka palungka yapu majuwartaluya juturnu tuunyukungka. ");
INSERT INTO mpj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ka-jananya wajarnu Jiijajju, “Yapuya yurntula tuungkamarra!, yutila nyakuraku.” Maajajju wajarnu, “Maaja! Karrpu puu wulikajangka mitu ngarripayi. Yiipila yapu majuwarta wupuntamunku, palujanu yurna parntiyikiku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jiijajjura wajarnu, “Yiltalu kulila!, ngayulurnanta palu wajarnu. Mamalu maparn majuwintilu kuwarri kunyjunyunku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Palujanuya yapu palunya wupuntamunu kurtingu. Kayila Jiijajju ngarnawarra nyanguka wajarnu, “Mama ngayumili! Marninypungkunirnanta, wangkajun ngayumili nyuntulu yiltalu kulini. ");
INSERT INTO mpj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nintirnangku, nyuntulurnin wululu ngayu kulirni. Mama kulila! Wangka jilanyarna kuwarri wajarni, martu ngaakajaluya kuwarri kulilkuraku. Jilanyaya kulilkuraku, ‘Yilta Mamalu Jiijajpa kurtingu, Mamamili.’” ");
INSERT INTO mpj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Palujanu Jiijajpa wiltu mirrangu, “Lajarajpawu! Pakalarni yarra!” ");
INSERT INTO mpj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kayilapa mitujanu Lajarajpa pakarnu, pantijikajawinti. Mirtaya nyangu ngumpa, jumaji pantijikajawinti. Murrarniluya Juwukajalu mitukaja pantijiwintilu karrpila yarnangu parlparri. Ka Jiijajju-janampa wajarnu, “Pantijikajaluya tikamatula!” ");
INSERT INTO mpj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Miirimililu walyjakajaluya nyangu Lajarajpa wankarringu, kaya Jiijajpa kulirnu, Mamamili kaja. ");
INSERT INTO mpj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Karlki kujupaluya Miirimili walyjakajalu yanu jakurljulpayi, Parajikajangka, “Jiijajju wankarnu mitujanu.” ");
INSERT INTO mpj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Juwumili maajakajaya kujungkarringu, Parajikajakamu yatilypa majukaja. Jiikajaya kujungkarringu kaya wangkangu, “Yaalulkula? Palulu-jananya yalyjirr kujupa kujupa ngapirni, kayilapaya martukajalu palu kulini. Yiipila palunya mirta manku, palujanuyilaya martu yarnngalu palu kulilku, palunga Mamamili, Kurayijpa. Palujanuyilaya mayitpi Jiijajjpa maaja maju junkujaku, palujanuyila maaja maju-lampa Rumanpurlukalu jantulwintikaja kurtingkujaku, kayilapa-langkuya pungkujaku, ka jaaji maju-lampaya warlangkujaku, ngurralurrju-lampaya warlangkujaku, martukajalurrju-langkuya pungkujakunirra, mirtala Juwukaja yarnnga nyinajaku.” ");
INSERT INTO mpj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","Murrarniya puyulyurru tayimungka maaja majuya yatilypa junkupayi, Juwukajalu. Julyjuya yatilypa maaja maju junu, yini Kayapajpa. Kayapajju palulu-jananya miitingja wajarnu jilanya, “Pakiwananyurra kulini. Jilanyaya kulila!, Ruumanmapulu-langkuya yankuka wulikaja pungkujaku, palunyangkamarraya karlkilu kuwarri Jiijajpa mitu puwa!, yarnngangkamarra.” ");
INSERT INTO mpj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Juwukajaluya kulilpayi, yatilypa maaja majunga Mamalu kurranyi nintirninpa, “Mayitpi jampinguku ngula.” Yilta Mamalura nintinu ngaanya wangka wajalkura, “Jiijajpaya mitu puwa!” Jilanya Kayapajju kurranyi wajarnu, Jiijajpa ngula miturriku, ka Juwukajaya Mamamili ngurrangka wanka nyinakura, Juwuparnikajalurrju. Jiikajaya Juwuparnikaja nyinani, ngurra kujupakamu ngurra kujupangkalurrju. Juwukajakamu Juwuparnikajalurrjuya Jiijajkuraya walyjarrira karaya palumili walyjakaja kujungka nyinakura. ");
INSERT INTO mpj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Palujanu Juwukajaluya maajakajalu kulilpayi, “Yaalula Jiijajpa pungku?” ");
INSERT INTO mpj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Palukajangkamarra Jiijajpa yanu tawun Yipuramkarti. Tawun palunga pujimanwarti yikini, yitingka. Jiingkaya kujungka nyinapayi, Jiijajmapu, mirtaya Juutiyawana parra yankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kuwarripaya Juwukaja nyinakuraku turlku yini Pajuwupangka, Jarujalumungka. Ngurra kujupakajajanuya yankura kujungkarringu, tawun Jarujalumja Mamaraya kurranyilu yungkuraku, mirtayirti. Kulujukajalurrju-ngkuya waajamulpayi, kurranyilu, Pajuwupangkamarra. Jilanya-janampa luwu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jiikajaluraya Jiijajku purtu parra nyakupayi, jaaji majungka. Japirnu-ngkuya, “Wanyjalpayan kulini? Turlku Pajuwupakurni mayitpi mirta Jiijajpa yanku, palukajangkamarra.” ");
INSERT INTO mpj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Parajikajalukamu yatily majukajaluya julyju wajarnu, “Yiipinyurra Jiijajpa nyaku, palujanunyurra jakurljunku ngayunja, kayilapalaju yanku manku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Turlku yini Pajuwupa kuwarripa nyinakuraku, wiiki kujungka, palu tayimu Jiijajpa yanu marlaku tawun Piijanikarti. Tawun jiingka Jiijajju julyju Lajarajpa mitujanu wankarnu. ");
INSERT INTO mpj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lajarajmili ngurrangka yanu nyinapayi. Jurturarralupula mirrka ngapirnu, ngalkuraku. Kujungkaya nyinapayi, Lajarajpalurrju ka Maajajju-jananya yungu mirrka. ");
INSERT INTO mpj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Miirilu jinyji parntiwinti kunyjunyu kanyilpayi, julyju mani majungka payamunu. Jinyji palunyalu Miirilu manu, ka Jiijajjalu jinyji japuwarta yintirnu, jina kujarrangka. Palujanu kata palumiliwintilu jina kujarra wayipamunu. Jinyji palunya kunyjunyu parntiyikingu, mayawana. ");
INSERT INTO mpj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jiijajmili wangka-ninti Juutaj Yijikariyatpa jiingka nyinapayi. Jiilu Juutajju ngula-jananya jakurljunu, Jiijajpaya mankuraku. Juutajju-janampa Jiijajmapuku wajarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Jinyji palunya nyaaku karlki wiijamurnu?, junkungara! Kangkungarala jalamunngara, mani majula mankungara, kala-jananya nyarrukaja parra yungkungara.” ");
INSERT INTO mpj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mirta Juutajju kulilpayi, nyarrukaja-jananya yungkuraku. Jilanya wajarnu mani mankuraku, jumaji palunga ngulyupayi. Jiijajmapuku-janampa mani kanyilpayi, ka ngulyulu mankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jiijajjura wajarnu, “Wanti jiinya jurra! Kunyjunyulu jiinya jinyji kanyini, ngularni yintilku jamparna miturriku.” Murrarniluya Juwukajalu jinyji yintini, mitukajangka. ");
INSERT INTO mpj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Jiijajju-janampa wajarnu, “Ngayungkapalajirni wantilu jinyji yintirnu, kunyjunyulu, ngula-jananya nyarrukaja kulilku ka yungku. Jiikajangaya nyarrukaja wulpipulkaja nyininpa kunyjunyu-janampanyurra palukajaku ngapilkura. Ngayukulurrjukujunyurra kuwarri kunyjunyu ngapilkura, mirtarna-nyurranya rawa nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juwukajaluya jakurlpa kulirnu Jiijajpa tawun Piijaningka nyinapayi. Kayilapaya tawun palukarti yanu, Jiijajkamu Lajarajpaya nyakuraku. Julyju Jiijajju Lajarajpa mitujanu wankarnu. ");
INSERT INTO mpj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Palujanuya yaka wangkapayi Lajarajkamu Jiijajpa-pulanyaya mitu pungkuraku, yatily majukajalu. ");
INSERT INTO mpj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kulilpayiya, “Martukajaraya Jiijajku pukurlarrinpa, palumiliraya wangka kulini, ka ngayunku-lampaya parlanyarrinpa, jumaji Lajarajpa wanka nyinajunu. Palujanula Jiijajkamu Lajarajpa mitu pungku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Karrpu kujupangka martukajaluya jakurlpa kulirnu, Jiijajpa yankukijarni, tawun Jarujalumkarti. Martu palunyakajangaya julyju jarrpangu tawun jiingka, turlku Pajuwupangka nyinakija. Warta parrkakajaya kaarlpunguka tawun jiijanuluya yanu kujungkarringu Jiijajja, martu yarnnga. Wiltuluya marninypungkutikatima jilanya, “Yilta ngaanya Mamamili. Mamala marninypungkuran! Ngaa-lampa maaja maju marninypungkurala, Yijurilmili marlajanukajaku!” ");
INSERT INTO mpj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jiijajju julyju tangki yangupala manu tatirnuluka katipayi. Mamamili wangka jilanya ngarrinpa, ");
INSERT INTO mpj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tawun Jayunmartajiluya kulila!, mirtanyurra ngurlu nyinama! Maaja maju-nyurrampa yaninparni tangkikurlu, yangupalakurlu.” ");
INSERT INTO mpj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mamamili wangka palunyanga yiltarringu. Mirta Jiijajmili wangka nintikajaluya kulilpayi, ngulampawiyajuya kulirnu. Jampa Jiijajpa ngarnkakutu marlaku yanu jilanyaya kulilpayi, “Mamamili wangka yiltarringu, Jiijajpa tangkikurlu yangupalakurlu yankupayi. Nyangula.” ");
INSERT INTO mpj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Palunyangkaya martu laltulu yanu Jiijajpa marninypungkupayi, jumajiya julyju kulirnu Lajarajpa mitujanu wankarnu. Karlki kujupaluya julyju nyangu, Jiijajju Lajarajpa mitujanu wankarnu. Kaya-jananya palukajalu yanu parra wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Parajikajaluya kulirnu, laltuluya Jiijajpa marninypunginpa, karaya wirrilyirringu Jiijajku. Wajarnu-ngkuya, “Mirtala rawa majalku, pipurrulula pungkura, jumaji yarnngaluya wanarnin.” ");
INSERT INTO mpj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Julyju karlki kujupaya wangka Kirikiwinti yanu Jarujalumkarti, turlku Pajuwupakarti. ");
INSERT INTO mpj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jiikajaluya yanu wangkangu, Jiijajmili wangka-nintingka Pilapungka. Pilapu jiinya tawunu Pijajmartaji. Tawun palunga parna Kaliliyangka yikipayi. Pilapukuraya wajarnu jilanya, “Kulirninpalaju, Jiijajjalajulu wangkara.” ");
INSERT INTO mpj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilapulu yanu Yanturungka wangkangu, palujanulupula yanu Jiijajkarti. Japirnulupula jilanya, “Jiikajaluntaya Kiriki wangkawintilu yankurantaya kulilkura?” ");
INSERT INTO mpj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jiijajju-janampa martukajaku wajarnu wangka kujupawana, “Mamalu julyju kulirnu, ngayurniya martu yarnngaku marlpa mitu pungkuraku. Kuwarrirniya yiltalu pungku. ");
INSERT INTO mpj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wangka ngaanyaya kulila! Martulu wilyki junku parnangka, kayila yukuri pakalku. Yukuri pakanyjangka wilykingayila pakirriku, palunyangkalu yukurijanu wilykinga yarnngarriku. Palunyajanu wilyki kujujanunga yarnngarriku. Jampa martulu wilyki kanyilku, mirta parnangka junku, palunyajanu wilyki jiinya kuju wulu nyinamalpa. Wangka paluyuru wilyki palu pakirriku, palunyayururna ngayu miturriku. Palujanu ngayumili walyjakajaya yarnngarriku, yukurijanuyuru wilykikajayuru. ");
INSERT INTO mpj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jampa wululu walyjalu kulilku, palunyajanu miturriku. Jampa kujupakajaku yirninyju kunyjunyu nyinaku, palunyajanu wanka wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jampa ngayukuju warrkamu palyalkuraku, palunyajanuju junga nyinaku. Martu jiiyuru ngayungkarni kujungka nyinaku, Mamamili ngurrangka. Palunyajanuyila Mamara pukurlarrikuka marninypungku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kuwarrirna wirla walyku nyininpa, pungkurniya mitu. Mayitpirnara Mama japilku ngayurniya mitu pungkujaku. Paki, miturrikijarna-janampa yanurni martu yarnngaku ngaangka parnangka. ");
INSERT INTO mpj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jilanyarna kulirnin, ‘Mama, palyarniya pungku, jilanyalun nyuntu kulirnin.’” Palunyajanu ngarnkajanu wangkangu jilanya, “Martukajalurniya marninypungkupayi, jumajin nyuntu wulu junga nyinapayi. Kan jampa kuwarri junga nyinaku, palunyajanurniya wululu ngulanga marninypungkumal.” ");
INSERT INTO mpj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Martukajaluya wangka jiinya kulirnu, ngarnkajanulu wangkangu, kaya karlkilu wajarnu, “Kalyu wangkinpa.” Karlki kujupaluya wajarnu, “Paki, Mamamili wikarrulu wangkangu.” ");
INSERT INTO mpj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jiijajju-janampa wajarnu, “Ngarnkajanu wangkangu Mama, kulilkuranyurra ngayurna Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kuwarri-nyurranya martu wulikaja kuutja wajalku, jumajinyurra walykukaja ngapilpayi. Malpuku maajalu-nyurranya muunpunginpa, kuwarri palunyanga payilku kurtingku, Mama ngarnawarrapurlukalu. ");
INSERT INTO mpj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jamparniya martu yarnngaku marlpa wiltijunku wartangka, walykukajarna-janampalura wirrupungku, palunyajanu martukajalurniya kulilkuka wankarriku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jiijajju-janampa wajarnu wangka palu martukajalurniya wiltijunku wartangka. Jilanya Jiijajju nintilu kulinu, “Wartangkarniya wiltijunku ka miturntanku.” Mirtaya martukajalu jilanya nintilu kulilpayi, ngulawiyajuya nyanguka nintirringu. ");
INSERT INTO mpj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Martukajaluya Jiijajja wajarnu, “Muujajmili wangka jilanya, Kurayijpa wulu wanka nyinamalpa. Nganakun nyuntulu wajarnu martukajaluntaya yikijunku?, kantaya miturntanku.” Karlkiluya pakiwana kulilpayi, mirta Jiijajpa martu yarnngaku marlpa, kujupa karalpayiya. Karaya ngunjularrira japirnu, “Ngana-lampaju, ngayunku martu yarnngaku marlpa?” ");
INSERT INTO mpj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36","Jiijajju-janampa wangka kujupawana wajalpayi, “Martulu layitingka yuti nyanginpa. Kuwarrirna-nyurrampa layitiyuru nyininpa, ngayungkarninyurra Mamamili wangka yuti kulirni, layitiyurungka. Rawaparnirna-nyurranya nyinaku pakirriku. Jungaraya wulu Mamaku nyinama!, marlakunyurra walykuwana nyinajaku. Ngayurninyurra kuliraka wulu junga nyina!” Palunyajanu Jiijajju-jananya junu yanu ka-janampalura yanu, jaalpu nyinakija. ");
INSERT INTO mpj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jiijajju-janampa julyju yalyjirrju kujupa kujupa ngapilpayi, nyakula jankapayiluya, mirtaya kulirnu Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Julyju-jananya Mamamili jakurlpurlukalu Yayijayalu wajarnu, martukajaluya Kurayijja jankamalpa. Jilanya wajarnu, “Maajalu kulila! Martukajaluya nyuntumili jakurlpa kulira junamalpa. Nyuntulun kujupa kujupa yalyjirrju ngapilku, nyakulantaya jankamalpa.” ");
INSERT INTO mpj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wangka palunyayurungkaluya martukajalu jankapayi. Mamamili jakurlpurlukalu Yayijayalu wangka palunyayuru yarrarnu-janampa wajarnu. ");
INSERT INTO mpj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kuranja-jananya juturnu Mamalu kuliljakungkamarra, kuliraya Mamamili ngurrangka nyinajaku, Mamalu-jananya wankaljaku.” ");
INSERT INTO mpj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yayijayalu julyju kapukurrilu nyangu maaja maju Jiijaj Kurayijpa, palujanu wangka palu wajarnu. ");
INSERT INTO mpj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Palunya tayimuya karlkilu Jiijajpa Mamamili kulirnu, Juwukajalu, maajakajalu. Mirtaya-jananya karlkinja jakurljunkupayi, jumaji Parajikajangkamarra, jiikajaluya-jananya warrkira kurtingkujaku, mirtaya jaaji majungka Juwukurnungka kujungkarrijaku. ");
INSERT INTO mpj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Maaja jiikajaluya Jiijajpa kulilpayi, kaya-jananya mirta jakurljunkupayi, “Ngayurna Jiijajmili walyja nyininpa.” Kaya-janampa Parajikajaku kunyjunyu nyinapayi. Mama ngarnawarrapurlukakuraya kunyjunyu nyinangara, kaya-jananya parra jakurljunkungara, “Ngayurna Jiijajmili walyja nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","45","Jiijajju-janampa martukajaku wiltulu wajarnu, “Yiipi martulurni ngayu kulirninpa Mamamili, palunyajanu kulirni ngayumili Mama. Jiilurni ngayu kurtingurni. ");
INSERT INTO mpj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Martulu layiti nyakulaka kujungkarrinpaluya. Palunyayururna ngayu layitiyuru, marturniya kulira kujungkarrira ngayumili wangka kulilkura. Jilanyalurniya kulilkuka wanka nyinaku, wulujuya ngurrpa nyinajaku. ");
INSERT INTO mpj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yiipiju ngayumili wangka junku yanku, ngulampanga kujupalu warrkilku kurtingku, mirtarna ngayulu. Yanurnirna-nyurrampa martuku yarnngaku parna ngaakutu, wankalkurakurna-nyurranya, mirtarna-nyurranya kuutja warrkira kurtingkuraku yanurni. ");
INSERT INTO mpj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jampaju ngayukurnu wangka kulilku junku, Mamaluyila ngulampa warrkilku kurtingku, kuutja. Martu jiilu kuutjangku kulilku, ‘Ngayulurna jungalu kulilngara Jiijajmili wangka, palunyajanurni kuwarri kurtingkurni.’ Yiltalujuya kulira junkupayi ngayumili wangka, palunyangka-jananya Mamalu kurtingku, ngulampa. ");
INSERT INTO mpj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mirtarna ngayulu kujulu kulira wajarni, ngayuku Mamalurni muunpunginpa. Jiilurni ngaakutu parnakutu kurtingu, palunyamiliwiyajurna kulira wajarnin. ");
INSERT INTO mpj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yiipi martulu wululu Mamamili wangka kulilku, palujanuyila wulu wanka nyinaku. Witukarna-nyurranya wajarnin, ngayuku Mamalurni ngarnawarrapurlukalu muunpungin wajalkuranparna-nyurranya.” ");
INSERT INTO mpj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Turlku yini Pajuwupa yungunpa ngarakija, palunya tayimu Jiijajju kulilpayi, “Kuwarrirniya ngayu pungku miturntanku, palujanurnalu marlaku yanku, Mamakarti.” Jilanya Jiijajju kulilpayi, ka wulu-janampa palumilikajaku nyarrurrira nyinapayi. Jilanyalu-janampa rawa nyarrurrira nyinapayi, palujanuyila miturringu. ");
INSERT INTO mpj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jiijajkamu palumili wangka-nintikajaya kujungkarringu kaninyjarra mayangka nyinapayi. Mayiya ngalkura nyinapayi, Juutajjulurrju. Julyjungulyura malpuku maajalu muunpungu Juutajpa, nintijunkura-jananya Jiijajpa mankuraya. Juutajpa jii nyinapayi Jayimun Yijikariyatmili kaja. ");
INSERT INTO mpj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jiijajju kulilpayi, “Maajarni-janampa maju junu, Mamalu, ngaakajaku martukajaku. Mamalurni jiilu kurtingu. Ngaangkarna nyinara marlaku yanku Mamakarti.” ");
INSERT INTO mpj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jiijajju ngalangu ka pakarnu kuurtungku tikamaturnu. Tawulungku manu ka nanpajunu. ");
INSERT INTO mpj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Palunyajanu kalyu yintirnu wirningka, kalu yanu nyinatingu ka jina waajamurnu, palumili wangka-ninti. Palujanu jina mankura wayipamulpayi, tawulwintilu. Palujanu kujupangkalu yanu nyinatinguka jina waajamunu. Jilanyalu-jananya parra waajamunu, kalu yanu Piijangka nyinatingu. ");
INSERT INTO mpj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Piijalura jilanya wajarnu, “Maaja! Mirtarnin jina waajamula!” ");
INSERT INTO mpj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jiijajjura wajarnu, “Nyuntulun purtu kulirnin, ngayulurnanta jina waajamulkura. Ngulampalun nyuntulu kulilku.” ");
INSERT INTO mpj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kara Piijalu wajarnu, “Paki, mirtarnin waajamula!” Jiijajjura wajarnu, “Yiipi ngayulurnanta mirta waajamulku, mirtajun ngayumili walyja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Piijalura wajarnu, “Maaja! Waajamunkurnin katakamu jina maralurrju!” ");
INSERT INTO mpj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jiijajjura wajarnu, “Martulungku waajamunkunyjajanu kilinpala nyininpa, jinawiyajurnanta waajamulku. Yarnnganyurra kilinpala nyininpa, kujuwiyaju ngaangka walyku nyinin.” ");
INSERT INTO mpj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jiijajju kulirnu kujulu-jananya Juutajju nintilku Jiijajpa maajakajangka. Palujanu wajarnu, “Kujuwiyaju ngaangka walyku nyinin.” ");
INSERT INTO mpj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jiijajju-jananya yarnnga jina waajamurnu kilinpalarnu, ka pakarnulu marlaku kuurtungka jarrpangu. Ka marlaku nyinatingu tiipulja. Jiijajju-jananya japirnu, “Purtunyurra kulirnin, nganakurna-nyurranya waajamunkupayi?” ");
INSERT INTO mpj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yarrarnu-jananya nintijunu, “Nintipurlukarninyurra marninypunginpa, maajalurrjurninyurra marninypungin. Jungalurninyurra marninypungin, yiltarna-nyurrampa maaja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Maajalurna-nyurranya kuwarri waajamunkupayi, warrkamupurlukayurulu. Palunyayurulungkunyurra yaalpamulku, warrkamupurlukayurulu. ");
INSERT INTO mpj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jilanyalungkunyurra warrkamupurlukayurulu wulikajalungkunyurra yaalpamunkumalpa, mirtangkunyurra kulinma maajayuru! Martu karlkilurrju-jananyanyurra yalpamulku ngapilmalpa, ngayuluyuru. ");
INSERT INTO mpj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wangka ngaanyaya kulila! Warrkamupurluka mirta maajangka munkarra nyinin, paki. Jilanyayuru maajalu wangkapurluka kurtingku, mirtala kulilku wangkapurluka munkarra nyininpa, maajawiyaju nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jilanyanyurra kulirnin kuwarri warrkamupurlukayuru nyinakura. Yiipi-jananyanyurra martu karlkinpa warrkamupurlukayurulu ngapinmalpa, kanyurra pukurlpa wulikaja nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mirtanyurra wulikaja pukurlpa nyinaku, kujuwiyaju-nyurranya walyku nyinin. Ngayulurna-nyurranya kulirni karlkin kujupawiyajujunyurra junga nyininpa. Julyjurna-nyurranya yintarnu manu, ngayuku wangka-nintikajajunyurra nyinakija. Mamamili wangkaya julyju wakanyjajanu, kuwarriyila yiltarriku, ‘Ngayungkarni kujungkalu ngalkunmalpa, palunyajanurni junku yanku.’ ");
INSERT INTO mpj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kurranyilurna-nyurranya wajarnin ngulampangarni junku yanku. Palujanunyurra kulilku, ‘Yilta Jiijajpa Mamamili. Kurranyilu-lampa wajalpayi.’ ");
INSERT INTO mpj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Wangka ngaanyaya kulila! Ngayulurna wangkapurluka kurtingku, kayilaraya wangkapurlukaku pukurlarrimalpa, ngayukulurrjujuya pukurlarrimalpa maajaku. Jilanyayurujuya jampa ngayuku pukurlarriku, palunyajanu ngayumili Mamakuraya pukurlarrimalpa, ngayumili maajaku.” ");
INSERT INTO mpj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Palujanu Jiijajpa wirla walykurringu, ka-janampa wajarnu, “Wangka ngaanyaya kulila! Ngaangka martu nyinin kuju ngalkuraka. Palunyalu-jananya wajalku, ngayurniya mankuraku karniya kangku kanyilkura.” ");
INSERT INTO mpj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kuru-ngkuya nyangu kaya parraya kulilpayi, “Nganalu-jananya wajalku yungku?” ");
INSERT INTO mpj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ngayurna Jaanpa Jiijajjarnalu ngamu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ngayurni Jayimun Piijalu mara nintirnuka japirnu, “Wanyjajara Jiijajju wajarnu? Japilalu!” ");
INSERT INTO mpj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Palunyajanurnara ngayulu ngamu nyinanyjanju japirnu, “Maaja! Nganalunta wajalku yungku?” ");
INSERT INTO mpj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jiijajjuju wajarnu, “Mayi ngaarnalu tupurljunku, yungkurnara.” Kayilara tupurljunu yungu Juutajku, Jayimun Yijikariyatmili kajaku. ");
INSERT INTO mpj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Palunyangka Juutajju mankunyjangkara malpumili maajalura muunpungu, yankura-jananya wajalkura. Jiijajjura wajarnu Juutajku, “Nyuntulun wanyjalpa kulirnin, yarra pipurrulu ngapila!” ");
INSERT INTO mpj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Karlki kujupaluya wulikajalu purturaya kulirnu, “Nganakulu Juutajja jilanya wajarnu?” ");
INSERT INTO mpj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Juutajju-janampa mani kanyilpayi, Jiijajkukamu palumili wangka-nintikajaku. Karlkinjuya kulirnuka ngapi kukarnu, yankula-janampa mayi payamunkukija, Juutajju, kujungkaluya ngalkuraku, turlku Pajuwupangka. Karlkin kujupaluya kulirnu, yankula-jananya puupalakaja maniparni, yungkura. Palunya kukarnuya. ");
INSERT INTO mpj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juutajju mayi jii manu ka pakarnu pipurru yanu, mungangka. ");
INSERT INTO mpj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jampa Juutajpa yankunyjangka-jananya marlalu wajarnu, palumilikajangka, “Kuwarrirniya martu yarnngaku marlpa pungku miturntanku, palujanuyilarni Mamalu marninypungku. Jilanyangulyurna miturrinyjangkayilaya martu yarnngaluyilaya Mamanga marninypungku. ");
INSERT INTO mpj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ngayulurna Mama ngarnawarrapurluka wululu marninypungkupayi. Mama jiilurni wululu ngayu marninypungkupayi. Kuwarrirni Mamalu yilta marninypungku. ");
INSERT INTO mpj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngayuku walyjakajajunyurra nyininpa. Kuwarrirna-nyurranya wululu kulirnin. Kuwarrirna-nyurranya rawaparni nyininpa. Ngayurna kuwarri yankunyjangkajunyurra purtu ngurrilku. Wangka jilanyayururna-jananya Juwukajangka maajakajangka wajarnu, ‘Ngurra kujupakuturna yanku, mirtarninyurra kuwarrilu wanalku.’ ");
INSERT INTO mpj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Wangka kujuparna-nyurranya wajarni, kuwarrijanu, ‘Layikamurrirangkunyurra nyinaranku. Ngayurna-nyurrampa layikamurrira nyinapayi, palunyayurungkunyurra layikamurrira nyinamal!’ ");
INSERT INTO mpj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yiipingkunyurra layikamurrira nyinamalpa, martu kujupakajalu-nyurranya nyaku ka kulilku, ‘Yuwa yilta-ngkuya layikamurrira nyininpa, jumajiya Jiijajmili walyjakaja.’” ");
INSERT INTO mpj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jayimun Piijalura japirnu, “Maaja! Wanyjakartin yaninpa?” Jiijajjura wajarnu, “Mirtarninyurra kuwarrilu wanalku, ngulanyurra ngurra jiikarti marlawana yanamalpa.” ");
INSERT INTO mpj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piijalura yarrarnu wajarnu, “Maaja! Nganakurnin junkura yanin?, kujungkali yankura miturriku. Nyuntuntaya pungkunyjangka ngayurnangku kurranyirriku, palunyangkarniya ngayu pungku.” ");
INSERT INTO mpj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jiijajjura Piijaku wajarnu, “Yiltajun kurranyirriku, pungkurantaya? Yiltarnanta wajarnin, ruuja yungunpa wangkanyjangka kurranyilujun yupal tayimu ngayuku ngurrpajunku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jiijajju-janampa wajarnu wangka-nintikajaku palumilikajaku, “Mirtanyurra nyinaku wirla walyku, paki, kunyjunyunyurra nyinaku, mirtanyurra ngurlurri!, paki. Kangkuniranyurra Mamamili wangka, kangkujunyurra ngayumili wangka wituka. ");
INSERT INTO mpj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yarnngaya nyinani ngurrakaja ngayuku Mamamilingka ngurrangka. Ngurrakaja-janampaya yarnngaku nyinani ngayuku Mamamilingka ngurrangka martuku. Yiltarna-nyurrampa wajarni, mirtarna ngayu pakipayi. Kurranyurnalu yanku marlaku Mamakarti, ngurrajunkurna-nyurrampa, nyunturtinku-nyurrampaya wulujarra. ");
INSERT INTO mpj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Palunyajanurna-nyurrampa marlakurriku mankuraku ngulampa. Jamparna marlakurriku, kangkurna-nyurranya nyarrakarti ngayuku Mamamilikarti ngurrakarti. Nyinakurninyurra ngayungka wulu. Kujungkarrikula ngayuku Mamamilingka ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyunturtinparanyurra ninti, wanyjakartirna yanku ngayu. Nintiranyurra, wanyjangkarna yanku nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jampa-janampa Jiijajju wajarnu jilanya, wangka-nintilu kuju wangkangu Jiijajja, yininga wangka-nintinga Tamajpa. Wajarnura, “Nyampali! Ngurrpalajura, wanyjakartin yankuni. Wanyjalpalaju ninti nyinaku? Yaalulajunta wanalku nyarrakutu?” ");
INSERT INTO mpj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jiijajjura wajarnu, “Mamakartirna-jananya martukaja winirni kangkuni ngayuluwiyayiju. Nintimankunirna-jananya yilta wangka ngayuluwiyayiju, karaya nintirriku Mamaku. Wankanirna-jananya martukaja ngayuluwiyayiju, kaya nyinaku wirla kunyjunyu wulu. Purtulu yanku martu Mamakarti ngayupunaja, marlpayirralijulu yanku Mamakarti, yuu. Marlpayirrawiyayijulijulu yanku ngayu kujarra.” ");
INSERT INTO mpj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Palunyajanu-janampa wajarnu Jiijajju wangka-nintikajaku palunyamilikajaku, “Jampajunyurra ngayuku ninti, Mamakuranyurra ngarnawarrapurlukaku ninti wituka, yuu. Kuwarringulyuranyurra Mamaku ngarnawarrapurlukaku ninti. Nyangunyurra Mama julyjungulyu.” ");
INSERT INTO mpj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Palunyangkara Pilapulu wajarnu Jiijajku, “Nintijula-lanyajun Mama ngarnawarrapurluka!, nyakuyilalaju kurulu, kayilalaju wirla mukumukurriku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jiijajjura wajarnu Pilapuku, “Rawala nyinani kujungka wurungka. Pilapu, wuurtujun ninti? Kajirnangku ngurrpa? Jamparni nyakuni martulu ngayu, nyakuni Mama ngarnawarrapurluka wituka. Nyaajanun wajarnu, ‘Nintila-lanyaju Mama ngarnawarrapurluka!’” ");
INSERT INTO mpj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Japirnura Jiijajju, “Pilapu, kajin ngurrpamarta? Mamakamuliju ngayu kujarra kujungka nyininpa. Ngayurnalu nyinani Mamangka, karni nyinani Mama ngayungka.” Palunyangka-janampa Jiijajju wajarnu wangka-nintikajaku palumilikajaku, “Yuu, Mamarni wulu nyinani ngayungka, kujungkaliju nyinani. Mamanga murlpirrminyirri, karni nyinani ngayungka. Jamparna-nyurranya wangkani, mirtarna-nyurranya wangka ngayumili walyjamili wajarni, paki, Mamalurni yungkuni palunyamili wangka. Karna-nyurranya wajarni palunyamili wangka. ");
INSERT INTO mpj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wangka ngaanyaya kulila! Ngayurnalu nyinani Mamangka, karni nyinani Mama ngayungka. Wangkaya ngayumili kulila! Pakingkanyurra kulilku, yaalurna ngapilpayi ngayulu. Martukajarna-jananya wankarnu ngarntawintikaja, mitukajalurrju. Warrkirnurna-jananya kurtingu malpukaja, kaluraya mawu yanu martungkamarra, yuu. Jilanyayururna ngapilpayi. Palunyajanunyurra kulilkura, ‘Yiltangulyu Jiijajpalu nyinani Mamangka, kalu Mama nyinani palunyangka.’” ");
INSERT INTO mpj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jiijajju-janampa wajarnu, “Wangka ngaanyaya kulila! Jampajunyurra kangku wangka ngayumili nyuntunju, parranyurra yanku ngayuyuru, ngapilkunyurra ngayuyurulu. Parrarna yankupayi ngaangkawiyaju kujungka warrarnja. Karnalu yanku marlaku Mamakarti ngarnawarrapurlukakarti kuwarri kuwarri nyinaku, yuu, junkurna-nyurranya yanku. Murlpirrminyirringulyunyurra wiyurrpa nyinaku, kanyurra yinta kujarra yintakarti parra yankumalpa. Wajalku-jananyanyurra ngayumili wangka kunyjunyu martukajangka yarnngangka. Palunyajanujuya yarnngakuyarralu martukajalu kangku wangka ngayumili parlparri. ");
INSERT INTO mpj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wangkamaluya Mamangka ngarnawarrangka. Wangkakujunyurra ngayuku, walyjaranyurra Mamaku ngarnawarrapurlukaku. Yinijunkurninyurra yini ngayu, jampalunyurra wangkaku Mamangka, kalajulu wangkaku Mamangka kujungka. Ngayungarna yiltanyju, karna-nyurrampa karrartanyju nyinaku. Jamparna jilanya nyinaku karrartanyju, marninypungkuyilaya martukajalu yarnngalu ngayumili Mama, yuu. Wajalkuya, ‘Mamanga majuminyirri! Palunyanga kunyjunyuminyirringulyu!’ ");
INSERT INTO mpj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuu, wangkakujunyurra ngayuku. Yinijunkurninyurra yini ngayu, jampalunyurra wangkaku Mamangka. Ngayungarna yiltanyju, karna-nyurrampa karrartanyju nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Jampajunyurra Kurrurnjarra ngayuku nyinaku, kanyilkunyurra ngayumili wangka kuranja. ");
INSERT INTO mpj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yuu, japilkurnara Mamaku, kurtingkuraku-nyurranya marlpa kujupa ngayuyuru. Palunyajanu-nyurranya Mamalu yiyalku marlpa jiinya, karrartanyju-nyurrampa nyinaku. Jiinya marlpa kujupa, ka-nyurranya wulungulyu nyinaku, mirta-nyurranya marlpalu karrartanyjulu junku yanku, paki, wulungulyu-nyurranya nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Marlpanga jiinga Kurrurnpa kunyjunyu Mamamili. Nintimankuni-nyurranya yilta wangka palulu, karanyurra nintirriku Mamaku. Karlkinparaya nyinani martukaja parlanypa Mamaku, ngurrparaya kurrurnku kunyjunyuku Mamamiliku. Purtuya nyakuni. Mirtaraya wajarni Kurrurnku kunyjunyuku Mamamiliku, ‘Yarra-lanyaju nyina ngayunja!’ Mirta-jananya nyinani palunya, paki. Nyuntunjanyurra nyinani Kurrurnpa kunyjunyu ngamungulyu. Ka-nyurranya kurrungku nyinaku nyuntunja ngulampa, yuu, nintiranyurra Kurrurnku kunyjunyuku Mamamiliku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jiijajju-jananya wajarnu, “Mirtarna-nyurranya wulu junku yanku, Mamamili Kuurtilu-nyurranya ngampurrju kanyinmalpa. Yankurnalu Mamakarti karna-nyurrampa marlakurriku. ");
INSERT INTO mpj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Rawaparnirna-nyurranya nyinaku yanku. Martu ngurrpakajalujuya purtu ngurrilku, mirtarniya nyaku, karninyurra kurulu nyaku. Palunyajanurna wankarriku wanka nyinamalpa, palunyayuruyilanyurra wulu wanka nyinamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ngayurna wankarriku nyinaku, palunyangkarninyurra nyakuka kulilku, ‘Jiijajpalu yilta Mamaku walyja nyininpa maparn kujuwinti. Jiijajpa-langku yilta walyja nyininpa, kalara walyja palumili nyininpa.’” ");
INSERT INTO mpj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jiijajju jilanya yarrarnu wajarnu, “Jampa ngayumili wangka kulilkuka yirninyju nyinaku, palunyangkaju yilta layikamu nyininpa. Ngayulurna palunyanga nintinmalpa. Jampaju ngayuku layikamu nyinaku, palunyangka Mamara layikamu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juutaj kujupalura wajarnu, mirta Juutaj Yijikariyatju. Jilanyara wajarnu, “Maaja! Nyuntulu-lanyajun wajarnu martu wulikajaluntaya nyaku, jampan nyuntu marlakurriku. Yaalu ngayunjuwiyajulajunta nyaku?, kantaya mirta martu karlkinju nyaku.” ");
INSERT INTO mpj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jiijajjura wajarnu, “Mirtanyurra ngulakuwiyaju kulilaka nyina!, ngayuwiyajurninyurra layikamurriraka nyina!, palujanurnantaya kujungka nyinamalpa. Jampaju martu layikamurrira nyinaku, palunyangaju yirninyju nyinaku. Ka Mamalurrjura layikamurriku nyinaku, palunyaku. Palunyakamu ngayuliju kujungka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jampaju ngayuku mirta layikamurrira nyinaku, palunyangkaju mirta yirninyju nyinaku. Wangka jiirna-nyurranya wajarnin, mirtarna ngayuluwiyaju kulira wajarni, Mamaluju wajarninpa. Jiilurni parnakarti kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","26","“Jilanyayurulurna-nyurranya nintirninpa, palunyangka ngulampa-nyurranya Mamamili Kuurtilu nintilku, marlpa-nyurrampa nyinaku. Kuurti jiilu-nyurranya kuranpa wupuntamulku, palunyangkanyurra kuliraka ngapilmalpa ngayulurna-nyurranya nintinyjajanu. ");
INSERT INTO mpj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ngayulurna-nyurrampalura walykukaja wirrupungu, palunyangkalunyurra kawalya Mamangka nyininpa. Palunyajanunyurra pukurlpa nyinama! Mamalu-nyurranya wululu pukurlmankumalpa. Mamaku ngurrpakajaluwiyajuraya purtu kulirninpa pukurlmankuraku. Jumajirna ngayu yaninpa mirtanyurra wirla walykurrira nyinamalpa. Murlpirrpanyurra nyinaku, mirtanyurra ngurlurrimal. ");
INSERT INTO mpj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Julyjurna-nyurranya wajarnu, ‘Ngurra kujupakartirna yaninpa. Yankurna-nyurrampa ngulampa marlakurriku.’ Ngayurnalu pukurlpa marlaku yanin Mamakarti, palunyangkanyurra pukurlpa nyinama!, mirtanyurra wirla walyku nyinara. Yiltajunyurra layikamurrira nyininpa, palujanunyurra kulilngara, ‘Kunyjunyu-lampa ngayunku yaninpa Mamakarti, Mamalu palunyanga marninypungku. Jiikulara pukurlpa nyinara.’” ");
INSERT INTO mpj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jiijajju-janampa wajarnu, “Wangka jiirna-nyurrampa kurranyilu wajarnin, ngulanyurra kulilku, ‘Yilta Jiijajpanga Mamamili, julyju-lampa wajarnu, yankuralu Mamakarti.’ ");
INSERT INTO mpj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Ngamurrinyjangkarna-nyurranya rawaparnilu wajarninpa. Malpuku maaja-janampa martukajaku nyininpa, mirtarni ngayu jiilu wajarnin, kulirarni juninpa. Mamaluwiyaju wajanyjangkarna kulira ngapirninpa, jumajirnara Mamaku layikamurrira nyininpa. Wangka jilanyaya martukajalu nintilu kulilkura.” Palunyangka-janampa wajarnu, “Nyamu. Yankurala.” ");
INSERT INTO mpj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jiijajju-jananya wajarnu, palumili walyjakaja, “Ngayurna warta kuripijyuru. Kaatanmayapurlukalu kalyukurlulu kurrpilku, palunyajanu warta pakalku, wululu ngampurrju kanyinmalpa. Kaatanmaya jiipurlukayuru ngayumili Mamalu ngampurrju-langku kanyirninpa. ");
INSERT INTO mpj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngayurna kuripij warta kultuyuru, ngayukujunyurra walyjakaja warta jukujukuyuru yarnngayuru. Warta jukujuku karlki putarriku, mayiparnirriku. Karlkinpanyurra jilanyayuru puta nyinaku, Kaatanmayapurlukalu purtura mayiku nyaku, ka putalku walangku. Warta jukujukuya karlki mayikurlu pakalku, karlkinpanyurra warta jiiyuru ngayukurnu wangka kulilkuka yirninyju nyinaku. Kaatanmayapurlukalu jiiwarta mayikurlu jukujukuwiyaju walangku, palunyajanu mayi maju pakalku. ");
INSERT INTO mpj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Karlkinyurra nyininpa jilanyayuru warta jukujuku jii mayi majuwintiyuru, jungaminyirrinyurra nyininpa ngayukujunyurra. Ngayumili wangkanyurra kulirnin jungalu, jumaji-nyurrampalura Mamalu walykukaja wirrupungu. ");
INSERT INTO mpj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wulujunyurra junga nyinama!, warta jukukuju mayikurluyuru. Warta jukujuku wulu mayikurlu ngaraku, kayilapa jampa wangalju yungkalku ka punkajunku ka warta palu mayiparnirriku. Ngayukujunyurra wulu junga nyinamalpa, warta paluyuru mayikurluyuru. Yiipirninyurra ngayu junku yanku, Mamalu-nyurranya warrkilku kurtingku, palunyajanunyurra mirta ngayumili walyja nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ngayurna kuripij warta kultuyuru, ngayukujunyurra walyjakaja warta jukujukuyuru yarnngayuru. Warta jukujuku warta kultujanu pakalkuka mayikurlu ngaraku, kaatanmayapurlukalu mirta warlangku, palujanu mayi wulu tayimu, rawa ngaramalpa. Warta jukujuku jiiyuru karlkinyurra nyininpa, ngayuku yirninyju wulu nyinaku, palujanu kunyjunyuminyirrinyurra ngapinmalpa, ngayuku. ");
INSERT INTO mpj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Warta jukujuku walykukaja mayiparnikaja, kaatanmayapurlukalu warlangkuka wirrupungku, warungka. Warta juku jiiyurulurni kulilkuka junku yanku, Mamalu warrkilku kurtingku warukarti. ");
INSERT INTO mpj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yiipi yirninyjunyurra nyinaku wulu, Mamakunyurra japilku, Mamalu-nyurranya yungku. ");
INSERT INTO mpj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yiipinyurra yirninyju nyinaku wulu, martukajaluya Mama marninypungku, kaya kulilku, ‘Yiltaraya junga nyininpa Jiijajku, walyjakaja palumili.’ ");
INSERT INTO mpj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngayuku Mamaju layikamurrira nyininpa, palunyayururna-nyurrampa layikamurrira nyininpa. Yirninyjujuya wulu nyinama!, ngayulurna-nyurranya layikamurrira kanyilku. ");
INSERT INTO mpj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yiipiranyurra ngayumili wangkaku yirninyju wulu nyinaku, wulurna-nyurranya layikamurrira nyinaku. Palunyayururnara yirninyju palumili wangkaku nyininpa, palujanuju Mama layikamurrira nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Wangka jiirna-nyurranya wajarnin, kuliranyurra pukurlarrira. Ngayulurna-nyurranya pukurlmaninpa, pukurlpaminyirrinyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jilanyarna-nyurranya wajarni, ngayurna-nyurrampa layikamurrira nyininpa, jilanyangkunyurra layikamurrira nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Martulu wajalku, ‘Yiltarnara ngayu marlpaku layikamurrira nyininpa. Jampa kujupalu mitu pungkukija, palunyangkarnara kurranyirriku ngayu ngaraku, pungkujakuya. Ngayurniya kurranyi mitu pungku.’ Jilanyarna-nyurrampa Jiijajpa ngayumili walyjakajaku miturriku, karlkilu-nyurranyaya pungkujaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ngayulurna-nyurranya wajanyjangka, yiipinyurra yirninyju nyinaku, kanyurra ngayumili marlpakaja yilta nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maajalu walyjalu kulira nyininpa, kayilalu jakurljuninpa palunyamili marlpangkawiyaju, mirtalu warrkamupurlukangka jakurljunin. Mirtarna-nyurranya kulirninpa, warrkamupurlukanyurra nyininpa, paki, ngayukujunyurra marlpakaja nyininpa. Ngayulurna-nyurranya wulikaja Mamamili wangka jakurljunkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ngayulurna-nyurranya manu ngayumilijunyurra marlpakaja nyinaraku, mirtarninyurra nyuntunju manu. Manurna-nyurranya junu, ngayumilijunyurra wangkakaja parra wajalkuranku, martu karlkinpajuya kulira walyjarriraku. Mamalu-nyurranya murlpirrmanku, jilanyalunyurra parra wajalkuranku. Japilmalpalunyurra murlpirrmankura-nyurranya jilanya, ‘Jiijajpa-lampaju maaja maju nyininpa, palunyangka-lanyaju murlpirrmala!’ ");
INSERT INTO mpj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kulilaya ngayumili wangka!, kangkunyurra layikamurrira nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jiijajju-janampa yarrarnu wajarnu, “Yiipi-nyurrampaya martukaja Mamaku parlanykaja wirrilyirrimalpa, jilanyaya kulila! Julyjujuya Mamaku parlanykaja ngayuku wirrilyirripayi. ");
INSERT INTO mpj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yiipiranyurra Mamaku parlanypa nyinangara, jiikajaya-nyurrampa kunyjunyu nyinangara. Ngayulurna-nyurranya manu, Mamaku walyjakajaranyurra nyinaraku, palunyajanu-nyurrampaya wirrilyi nyininpa, jumaji mirta-janampanyurra walyja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kulilaya! Julyjurna-nyurrampa jilanya wajarnu, ‘Maajara warrkamupurlukaku munkarra nyininpa.’ Maajarniya karlkilu yiltalu warrkira pungkupayi, palunyayuru-nyurranyaya warrkamupurluka karlkilu warrkira pungkumalpa. Karlkiluya ngayuku wangka kuliraka junga nyininpa Mamaku, palunyayuruluya karlkinju nyuntunmili wangka kulilkukaraya junga nyinaku Mamaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jilanyalu-nyurranyaya karlkilu warrkira pungkumalpa, jumajijunyurra ngayumili walyja nyininpa, mirtaya kulilku Mamalurni ngayu kurtingurni. ");
INSERT INTO mpj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Parnakuturna yanurni, karna-jananya parra Mamakurnu wangka jakurljunkupayi, martukajangka. Kuliraya junkupayi, kaya wululu walykukaja ngapirni, Mama kulilparnilu. Mirtaluya jilanyalu kajalku, ‘Paki, ngurrpalulaju walykukaja ngapirninpa, mirta-lanyaju kujupalu jakurljunkupayi, Mamamili wangka.’ Mirtaluya jilanyalu kajalku, jumajirna-jananya wajalpayi Mamamili wangka, jiikurna-janampa parnakutu yanurni. ");
INSERT INTO mpj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yiipi martuluju kulilku junku ngayumili wangka, parlanypaju nyinaku, palunyangkara ngayumili Mamaku parlanypa nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Martukajangkarna-jananya kujupa kujupa yalyjirrju ngapilpayi, karna-jananya Mamamili wangka jakurljunkupayi, mirta-janampa kujupalu jilanyalu ngapilpayi. Kulirarniya junkupayi, parlanypa-limpajuya nyininpa, ngayumili Mamakukamu. Mamalu jiilu kulirninpa, ‘Yiltaya walykuwinti nyininpa, jumajiya Jiijajpa junu yanu.’ ");
INSERT INTO mpj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jilanyayuru Mamamili wangka ngarrinpa, mirlimirlingka, ‘Ngayurniya junu yanu parlanyju, mirtarna-janampa putamanu.’ Wangka jiinya kuwarri yiltarringu, ngayurniya junu yanu parlanypajuya nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Julyjurna-nyurrampa wajarnu, Mamamili-nyurrampa Kuurti marlpa yankuni, kanyilkuranku-nyurranya. Ngayulurna-nyurrampa kurtingku Kuurti palunya, jiilu-nyurranya nintinmalpa Mama ngarnawarrapurluka, ngayurnilurrju. ");
INSERT INTO mpj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ngayumili wangkanyurra parra jakurljunamalpa, ngurra kujupa ngurra kujupawana, jumajijunyurra ngayumili wangkaku ninti nyininpa, rawala kujungka nyinapayi.” ");
INSERT INTO mpj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jiijajju-janampa yarrarnu wajarnu, “Wangka jiirna-nyurranya wululu nintilpayi, kuliranyurra junga nyinaraku, rawaparninyurra nyinaraka kujupawana yankujaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","3","Ngula-nyurranyaya Juwukurnu jaajijanu ngumpalku yiyalku, Mamaku ngurrpakajalu. Karlkinpa-nyurranyaya warrkilkuka mitu pungku, Mamaku ngurrpakajaluya jilanya karalkuya kulilku, ‘Kunyjunyulula-jananya Jiijajmili walyjakaja punginpa, Mama-lampa pukurlarrinpa.’ Yilta-limpajuya jiikaja ngurrpa nyinaku, Mamakukamu. ");
INSERT INTO mpj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","“Wangka jiirna-nyurranya nintilpayi, ngulanyurra kulilku, jurtapayikajaluntaya warrkilkuka mitu pungku. Jilanyanyurra kulilku, ‘Yuu, Jiijajju-lampa julyju jilanya wajalpayi. Murlpirrpala kuwarri nyinaku.’ Mirtarna-nyurranya wangka jilanya julyju wajalpayi, jumajila kujungka nyinapayi, ngayuwiyajurniya warrkira pungkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Kuwarrirnalu yanku Mamakarti, jiilurni Mamalu julyju parnakarti kurtingu. Japilngararninyurra pukurlju, ‘Wanyjakarti nyuntu yaninpa?’ Paki, wirlanyurra walykurrini, jumajinyurra kulirninpa ngayulurna-nyurranya junku yanku. ");
INSERT INTO mpj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wangka ngaanyaya kulila! Kunyjunyurnalu Mamakarti yanku, palujanu Mamamili Kuurti-nyurrampa yankurni, marlpa-nyurranya nyinaraku. Ngayulurna-nyurrampa palunyanga yiyalku. Jamparna ngayu ngaangka nyinaku, mirta-nyurrampa Mamamili Kuurti yankurni. ");
INSERT INTO mpj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kuurti palunya-nyurrampa marlpa yankurni, ka-nyurranya nintilmalpa martu wulikaja. Jilanya-nyurranya nintilku. Jampa Mamamili luwu warlangku, palunyanga walykuwinti nyinaku. Wangka jilanyalurrju-nyurranya nintilku, ngayurna Jiijajpa wulu junga nyinapayi. Wangka kujupalurrju-nyurranya nintilku, jampa martu walykuwinti nyinaku, Mamalu ngulanga warrkilku kurtingku. ");
INSERT INTO mpj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Martu walykuwintilurni kulilku, palunyajanurnalu walyku manku wirrupungku. Mirtaya martukajalu jilanya jungalu kulirni, ngayurniya junkula yaninpa. ");
INSERT INTO mpj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Martukajalurniya paki karani ngayulurna-jananya yiltalu wankarni. Palujanurnalu yanku Mamakarti, karninyurra mirta nyaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Martukajaluya mirta kulirninpa, Mamalu julyju wajarnu, malpuku maaja miturriraku, kayilapa yilta ngulanga pakirriku. ");
INSERT INTO mpj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Wangka kujuparna-nyurranya kuwarri wajalkija, yumurrirarna juninpa, purturanyurra kuliljaku, jumaji wangka wiltu. ");
INSERT INTO mpj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mamamili Kuurtilu nintirni Mama ngarnawarrapurluka. Kuurti jii parnakuturni yankurni, ka-nyurranya nintinmalpa wangka yiltakaja. Kuurti palunyalu-nyurranya mirta walyjalu nintinmalpa, Mamaluwiyajulu nintinmalpa wajanyjanja, ka wajanmalpa. Kurranyilu-nyurranya jiilu Kuurtilu wajalmalpa, ngulangayila yiltarriku. ");
INSERT INTO mpj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ngayulurna-jananya wangka martukajangka parra wajalpayi, ka-nyurranya wangka palu jiilu Kuurtilu wajalmalpa, jilanyalurni Jiijajpa marninypungkumalpa. ");
INSERT INTO mpj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamamili wangkarna-nyurranya wajalpayi, palunyajanu palunyalu Kuurtilu-nyurranya wangka palunyawana wajalmalpa, ngayulurna julyju wajalpayi.” ");
INSERT INTO mpj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yarrarnu-janampa wajarnu Jiijajju, palumili wangka-nintikajaku, “Rawaparninyurra nyinaku mirtarninyurra nyaku, palunyajanurninyurra ngula yarralku nyaku.” ");
INSERT INTO mpj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Palunyamili wangka nintikajalu-ngkuya karlkilu japirnu, “Purtulara kulirnin, ngana wajarnin jilanya?, ‘Rawaparninyurra nyinaku mirtarninyurra nyaku, palunyajanurninyurra ngula yarralku nyaku.’ Wangka kujupakulurrjulara purtu kulirnin, ‘Mirtarninyurra nyaku ngayurnalu Mamakarti yaninpa.’ ");
INSERT INTO mpj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ngana wajarnu, wangka palu ‘rawaparni’? Purtula kulirni.” ");
INSERT INTO mpj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jiijajju kulirnu palunyakajaluraya japilkuraku, palujanu-janampa wajarnu, “Ngayulurna-nyurrampa wajarnu, ‘Rawaparninyurra nyinaku mirtarninyurra nyaku, palunyajanurninyurra ngula yarralku nyaku.’ Wangka jiikungkunyurra kuwarri japirni? ");
INSERT INTO mpj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wangka ngaanyaya kulila! Ngayukujunyurra yulakuka wirla walykujunyurra nyinaku, kaya martu walykukaja pukurlpa nyinaku ngayurna yankunyjangka. Yilta wirla walykunyurra nyinaku, kanyurra pukurlminyirri nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jampa wanti jijiparni nyinaku, mirta pukurlpa nyinaku, jampa jijiwintirriku palujanu pukurlpa nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wangka jiiyurunyurra wanti jijiparniyuru kuwarri pukurlparni nyininpa, ngula ngayurninyurra yarralku nyakuka, kanyurra pukurlminyirri nyinaku. Palujanunyurra yilta pukurlpa wulu nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Palunyangka mirtarninyurra ngayu japilmalpa yungkuraku, Mamalu-nyurranya yungkumalpa, jamparanyurra japilku, jilanya, ‘Jiijajpa-lampa maaja maju nyininpa, palunyangkalajunta Mama japirninpa.’ ");
INSERT INTO mpj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Julyjuranyurra Mama japilpayi, mirta yini ngayuwanalu. Kuwarriranyurra Mama japilku jilanyalu, ‘Jiijajpa-lampa maaja maju nyininpa, palunyangkalajunta Mama japirninpa.’ Jilanyaluranyurra japilku, Mamalu-nyurranya yungku, ka palujanu pukurlpayilanyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Julyjurna-nyurranya ngayulu wangka yumuwanpa wajalpayi. Ngularna miturriku karna wankarriku karna-nyurranya Mamamili wangka jungalu wajalku, mirta wangka yumuwanpa. ");
INSERT INTO mpj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Palu tayimuranyurra Mama japilku jilanya, ‘Jiijajpa-lampa maaja maju nyininpa, palunyangkalajunta Mama japirninpa.’ Palunyangka-nyurranya Mamalu yungku. Palunya tayimurna-nyurrampa mirta Mama japilku, Mamalu-nyurranya nintilu kulirninpa, ka-nyurranya yungku. ");
INSERT INTO mpj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mama jii-nyurrampa layikamurrira nyininpa, jumajijunyurra layikamurrira nyininpa, kanyurra kulirnin jilanya, ‘Yilta Jiijajpa Mamajanu yanurni, Mamamili.’ ");
INSERT INTO mpj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yiltarna Mamamili parnakarti yanurni, Mamamili ngurrajanu. Kuwarrirnalu marlaku yanku Mamakarti.” ");
INSERT INTO mpj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Palumili wangka-nintikajaluraya wajarnu, Jiijajku, “Yuu, wangka jungalu-lanyajun wajarnin, mirta wangka martulu ngapinyjayuru. ");
INSERT INTO mpj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kuwarrilajunta nintilu kulirnin, yilta nyuntunga nintipuka, wulikajaku ninti. Jampalaju kulirninpa, mirtalajunta jakurljunani nyuntulun nintilu kulirnin, jumajin yilta Mamamili.” ");
INSERT INTO mpj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","32","Jiijajju-janampa wajarnu, “Kuwarrirninyurra yiltalu kulirnin, ngulampangarninyurra junku yanku, ngurra walyjakutunyurra marlaku yanku, kujurna nyinamalpa. Mamalurni ngampurrju kanyinmalpa. ");
INSERT INTO mpj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Wangka jiirna-nyurranya wajalpayi, kulilkuranyurra ngula jilanya, ‘Yilta kurranyilu-lampa wajalpayi, palunyangkala pukurlpa nyina!, Jiijajmili walyjakaja.’ Mamaku ngurrpakajaluntaya warrkira pungku, palunyangkaya murlpirrpa nyinama!, jilanyaya kulinma!, ‘Jiijajpa-lampa maaja maju nyininpa, purtuya walykukajalu pungu.’” ");
INSERT INTO mpj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jiijajju-jananya jilanya wangka nintilpayi, palujanu yirra nyangulu Mamakarti, kalu wangkangu, “Mama! Kuwarrirniya pungku. Ngayurni murlpirrmarra!, martukajarna-jananya wankalkura, palujanurnanta marninypungku. ");
INSERT INTO mpj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Maaja majurnin nyinajunu, martu wulikajaku, ngayulurna-jananya wankalkura. Nyuntulun kulirnu martu yarnngaya wanka wulu nyinaraku, palukajarna-jananya wankalkura. ");
INSERT INTO mpj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yiipi palukajalu-linyajuya Mamakamu ngayu kulilku, kaya wulu wanka nyinaku. Nyuntuwiyajun maju nyininpa, mirta karlkikamu, nyuntulurnin parnakutu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Martukajarna-jananya nintilpayi parnangka jilanya, ‘Mamawiyaju-lampa maaja maju nyininpa, mirta karlkikamu.’ Mama! Nyuntumili warrkamurna wululu ngapira pakirnu. ");
INSERT INTO mpj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kuwarrirnin kangku nyuntumili ngurrangka junku, maajali kujungka nyinaku. Julyjuli jilanya kujungka nyinapayi ngarnkaparningkakamu parnaparningka. ");
INSERT INTO mpj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Julyjun kulirnu, ngaakajajuya wangka-nintikaja ngayuku nyinakura. Nyuntulun-jananya yintarnuka yungurni-jananya ngayumiliya nyinaraku. Nyuntumili wangkaya kulira nyininpa. Ngayulurna-jananya nintilpayi rawalu, nyuntu. ");
INSERT INTO mpj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Nintiluya kulirninpa, nyuntulurnin nintilpayi, palunyangkarna-jananya nintilpayi. Wangka jiinya nyuntumili yiltaluya kulirninpa. Yiltaluya kulirninpa ngayurna nyuntumili yanurni, nyuntulurnin kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Palukajakurnanta-janampa kuwarrilu japirni, jumajiya nyuntumili walyjakajaya nyininpa. Mirtarna kuwarri martu yarnngaku japirni, ngaakajakuwiyajurna-janampa. ");
INSERT INTO mpj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngayumili walyjakajakamu nyuntumili walyjaya kujarraku-limpaya nyininpa. Palukajalurniya parra wajaraka marninypungamalpa. ");
INSERT INTO mpj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kuwarrirnanta nyuntukarti yanku, mirtarna ngaangka parnangka nyinaku, kaya palukaja wulu nyinaku ngaangka parnangka. Mama majurnanta-janampa japirninpa. Nyuntulun-jananya maparn majuwintilu ngampurrju kanyilku, wuluya walyjararranpa nyinaraku, ngayu kujarrali walyjararra nyinanyjayuru. Jilanyayururnin maparn majuwintilu ngampurrju kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kujungkarna-jananya nyinapayi, karna-jananya ngampurrju kanyilpayi nyuntumili maparn majuwintilu. Kujungka ngayungka martu kuju nyinapayi palunyalurni ngayu junku yanku. Mama nyuntulun kulirnin martu palunya, nyuntumili wangkangka julyjujanu, jilanya nyininpa, martu palulurni ngayu junku yanku. Karna-jananya karlki kujupa wululu ngampurrju kanyilpayi, ngayumili wangka-nintikaja, mirta kujujura kujupawana yanu. ");
INSERT INTO mpj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kuwarrirnanta marlaku yanku. Wangka ngaarna parnangka wajarni, ngaakajaluya kulilkuka pukurlpa wulu nyinaraku, ngayurna wulu pukurlpa nyininpa, palunyayuru. ");
INSERT INTO mpj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ngayulurna-jananya nyuntumili wangka nintilpayi, palujanu Mamaku parlanykajaya-janampa parlanypa nyininpa, jumajiya-janampa mirta walyja nyininpa, ngayuyuru. Ngayurna-janampa Mamaku parlanykajaku mirta walyja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mama kuwarrirnanta japirni, mirtan-jananya nyuntumili ngurrakarti katira, wululun-jananya ngaangka ngampurrju kanyinma!, malpuku maajangkamarra. ");
INSERT INTO mpj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ngayurna-janampa Mamaku parlanykajaku mirta walyja nyininpa. Paluyuru mirtaya-janampa ngaakaja walyja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mama jurra-jananya!, nyuntumili warrkamupurlukaya nyinara, parraya-jananya nyuntumili wangka parra wajalkuranku, jii nyuntumili wangka yilta. ");
INSERT INTO mpj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Julyjurnin kurtingu martukajangkarna-jananya parra wajalkura, nyuntumili wangka. Palunyayururna-jananya ngayulu kurtingu julyju, nyuntumili wangka-jananyaya martukajangka parra wajalkura. ");
INSERT INTO mpj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mama! Nyuntulun kulirnin, ngayurna-janampa miturriraku, martukajaku. Ngayurna-janampa yilta martukajaku miturriku, jilanyaju warrkamu ngayuku. Palunyajanu ngaakajaku-janampa warrkamu, nyuntumili wangka-janampaya parra wajalkuranku. ");
INSERT INTO mpj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ngaakajaluya nyuntumili wangka parra wajalku, kaya martu laltulu wangka jii kulilkukaya ngayumili walyjarriku. Palukajakurnanta japirni, mirta ngaakajakuwiyaju. ");
INSERT INTO mpj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Palukajaya walyjararrarriku, kunyjunyu-ngkuya nyinaku, jilanyakurnanta japirni. Ngayu kujarrali walyjararra nyininpa, palunyayuru-ngkuya kunyjunyu nyinaku. Jampa jilanyaya nyinaku, martukajaluya yilta kulilku, ‘Yilta-janampa Jiijajpa Mamamili.’ ");
INSERT INTO mpj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Mama! Nyuntulurnin wajarnu, ngayurna-janampa martukajaku miturrira, karna-jananya wankalkura, jiiju ngayumili warrkamuju. Ngaakajakurna-janampa wajarnu, nyuntumili warrkamuya parra palyalkuranku, kujungkalu. Jilanyayuruli kujungkalu warrkamu ngapirninpa. Ngayumili walyjakaja-ngkuya kunyjunyu nyinakura. Jampa jilanyaya nyinaku, martukajaluya yilta kulilku, ‘Yilta-janampa Jiijajpa Mamamili, Mamara layikamurrira nyininpa. Palunyayuru-lampa layikamurrira nyininpa.’ ");
INSERT INTO mpj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama! Ngaakajan-jananya julyju yintarnu manu, ngayumili walyjaya nyinaraku. Ngayulurna kulirni, ngaakajantaya Mamakarti yankuraku, kala kujungka nyinara. Jiingka-lingkuya maaja kujarra nyakuka pukurlarriku. Jilanyali julyju maaja kujarra nyinapayi, parnaparningkakamu ngarnkaparningka, layikamurrira-lingku nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yuu Mama! Wulun junga nyininpa, jungalun-jananya martukaja wajarnin. Martukaja-ngkuya ngurrpa nyininpa, ngayukamu ngaakajawiyaju-lajungku nintinga nyininpa. Nintiluya kulirninpa ngayungarna nyuntumili, Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngayulurna-jananya nintilpayi nyuntunga Mama, karna-jananya wululu nintinmalpa, nyuntunga. Ngayulurna-jananya wululu nintinmalpa, layikamurrira-ngkuya nyinaku palukaja, nyuntuju ngayuku layikamurrira nyininpa, palunyayuru.” ");
INSERT INTO mpj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mama-janampalura japilpayi, palunyajanuya karrukarti yanu Jiijajkamu palumili wangka-nintikaja, karru jii yini Kiturunkarti. Karrungkaya yanu tiputinguya yanu kujupakarti maa yanu maa tatirnu. Yanuya kaatanmayangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kaatanmaya jiiku ninti Juutajpa nyinapayi. Jiijajmapuya wulu kujungkarrira jiingka nyinapayi. Juutajju jiilu julyju-jananya yanu wajarnu, Jiijajpaya mankuraku. ");
INSERT INTO mpj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Palujanu Juutajju-jananya kangu jiikarti, jantulwintikaja, Ruumanpurlukakamu ngalyikarrpilkaja. Jiikajaya ngalyikarrpilkaja warrkamurripayi Juwukurnu jaajingka majungka. Mungajarraya kangkupayi laampukamu nayipulurrju, karlkiluya jantulwintilu katipayi, kawu. Palukajaya-jananya Parajikajalukamu yatily majukajalu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jiijajju kurranyilu kulirnu yilta jilanyarrikija. Palujanu kurranyirringu-janampalura ka-jananya japirnu, “Nganakuranyurra ngurrirni?” ");
INSERT INTO mpj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Karaya wajarnu, “Jiijajku, Najarijmartajiku.” Juutajpa jii-jananya kujungkarringu ngarapayi. Ka-janampa Jiijajju wajarnu, “Ngaarna ngayu ngarinpa.” ");
INSERT INTO mpj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kayilapaya kujupa karanu, ka ngurluwintiya parnangka punkarnu, kaya kulirnu, “Palunga Jiijajpa yikini, maparn majuwinti.” ");
INSERT INTO mpj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ka-jananya yarrarnu Jiijajju japirnu, “Nganakuranyurra ngurrirni?” “Jiijajku Najarijmartajiku.” ");
INSERT INTO mpj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ka-janampa Jiijajju wajarnu, “Palunyarna-nyurranya wajarnu, ngayurna ngarinpa. Yiipirninyurra yanurni ngayurninyurra mankuraku, ngaakaja-jananyanyurra kurtiwa!” ");
INSERT INTO mpj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Julyju Jiijajju Mamangka wajarnu, “Ngayulurna-jananya ngayumili walyjakaja wululu ngampurrju kanyilpayi, mirta kujujura kujupawana yanu.” Wangka jilanya kulira Jiijajju wajarnu-janampa, “Ngaakaja-jananyanyurra kurtiwa!” ");
INSERT INTO mpj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jayimun Piijalu nayipu kanyilpayi, warlpukurru. Palujanu yilarnuka kuranpa katupungu warlangu, yatily majumili warrkamupurluka, kuranpa jungakarti, yini palunyanga Malkajpa. ");
INSERT INTO mpj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jiijajjura Piijaku wajarnu, “Jurra! Marlaku jarrpajurra!, jii nayipu. Mamalu kulirninpa ngayurniya mankura katikuka pungku.” ");
INSERT INTO mpj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Palunyangkaya Jiijajpa manuka karrpirnu, jantulwintikajalukamu maaja-janampa palukajaku, ngalyikarrpilkajalulurrju. ");
INSERT INTO mpj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kanguya maaja Yanajku ngurrakarti. Yanajpa palungara kaja nyinapayi yatily majuku Kayapajku, ka Kayapajpangara yungkujarra Yanajku. Kayapajpa-janampa palu tayimu yatily maju nyinapayi. Jilanyaya-jananya puyulyurrungka puyulyurrungka kujupangka mankupayi yatily maju kujupa. ");
INSERT INTO mpj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapajju-jananya wajarnu julyju, Juwumili maajakajangka, “Ruumanmapulu-langkuya yankuka wulikaja pungkujaku, palunyangkamarraya karlkilu kuwarri Jiijajpa mitu puwa!, yarnngangkamarra.” ");
INSERT INTO mpj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jayimun Piijalukamu Jiijajmili wangka-ninti kujupalu wanarnu-jananyapula, jampaya Jiijajpa kangu. Jiijajmili wangka-ninti jii wanarnu-jananya kujungkarringu kurrungu, yatily majumili mayangka yaartungka. Yatily majukura ninti nyinapayi palu Jiijajmili wangka-ninti. Kayilapa yatily majumililu warrkamupurlukalu jarrpajunu yaartungka. ");
INSERT INTO mpj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piija yawujayitungka yaartungka ngarapayi. Jiijajmili wangka-ninti palu marlaku yanu kiituwarti wantingkalu wangkangu, kayila Piija jarrpajunu. ");
INSERT INTO mpj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wanti jiilu kiitupurlukalu Piijakura wajarnu, “Nyuntungan jiiku Jiijajkuran walyja!” Piijalura wajarnu, “Ngurrparnara!” ");
INSERT INTO mpj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ngalyikarrpiljukamu warrkamupurlukaluya waru kujarnu yaartungka, jumaji yalta. Kaya parra ngarangu tinkijunu, kaya waru nganyjilpayi. Ka Piija-jananya yanu kujungkarringu ngarapayi, ka waru nganyjilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mayangka jiingka yatily majulura Jiijajpa japirnu-janampa palumili wangka nintikajaku. Yarrarnura japirnu Jiijajpa wangka yaaluyuru-jananya martukaja nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jiijajjura wajarnu, “Ngayulurna-jananya nintilpayi yutilu, martu kujupakajangka kurungka. Ngayulurna-jananya nintilpayi jaaji Juwukurnungka parlparriwana, jaaji majungkalurrju, martu kujupakajangkalurrjungka, mirtarna-jananya karlkinpawiyaju nintilpayi, kukulu. ");
INSERT INTO mpj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nganakurnin ngayu japirninpa? Japila-jananya jiikaja martukaja jilanya!, ‘Jiijajju-nyurranya wangka ngana nintilpayi?’ Martu jiikajalurniya nintilu kulirninpa, ngayulurna-jananya nintilpayi”. ");
INSERT INTO mpj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jilanyara Jiijajju wajanyjangka, ngalyikarrpilju pungu ngumpawarti, kara wajarnu, “Nyuntun maajangka jikipalarringu, mirtan yatily maju jilanyalu wajala!” ");
INSERT INTO mpj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jiijajjura wajarnu, “Yiipirnalu ngayulu kajarninpa, wiltulu-jananya ngaakajangka wajala! Ngayulurna yatily majungka junga wajarnu, nganakurnin ngumpa pungu?” ");
INSERT INTO mpj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Palujanu maaja Yanajju kurtingu Jiijajpa maaja Kayapajkarti, yatily majukarti, wulu tayimapu. ");
INSERT INTO mpj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Palujanuraya karlkilu Piijaku wajarnu, jampa warungka ngarapayi, “Mayitpiran jiiku Jiijajmili walyja!” Ka-janampa Piijalu wajarnu, “Ngurrparnara!” ");
INSERT INTO mpj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yatily majukura warrkamupurluka jiingka ngarapayi, julyju Piijalu palunyamili walyjanga kurannyuku katapungu. Jiilura Piijaku wajarnu, “Yuu, yiltarnanta ngayulu nyangu jiingka kaatanmayangka.” ");
INSERT INTO mpj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kara Piijalu wajarnu, “Paki, mirtarnin nyangu!” Kayila ruuja wangkangu. ");
INSERT INTO mpj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Raayankunyjangka Jiijajpaya winirnu katingu, Payilatmili mayakarti, Kayapajmili ngurrajanu. Juwukajaya maajakaja jiingka mayangka kujungkarringu, mirtaya kaninyjarra kurrungu yawujayitiya ngarapayi, jumajiya luwu jilanya kulilpayi, “Juwukajalula mirrka Pajuwupa ngalkukija, mirtala kurrungku, Juwuparningka mayangka, luwu-lampa jilanya.” ");
INSERT INTO mpj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Luwu palunya Payilatju nintilu kulirnuka, pakarnu-janampa yawujayitirringu. Ka jilanya-jananya japirnu, “Ngananyurra wajarninpa?, ngaalu Jiijajju ngana putamanu?” ");
INSERT INTO mpj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wajarnuraya, “Yuu, yilta ngaalu putamanu. Pakingka, mirtalajunta kuwarri katingararni.” ");
INSERT INTO mpj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Payilatju-janampa wajarnu, “Ngayurna ngurrpa. Nyuntunjuya kati wanyjalmala!, nyuntunmili luwuwana.” Wajarnuraya, “Ngayunmili luwungkalaju mitu pungkura. Purtulajura kulirninpa, Ruumanpurlukalun wajalkura kuutja.” Jiikajaluya kulirnu, “Maajalu Ruumanpurlukalu wajalku, wartangka wiltijunkuraka miturntalkura.” ");
INSERT INTO mpj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wangka jilanyayuru-janampa Jiijajju martukajaku julyju wajarnu nintilu, “Jamparniya wiltijunku wartangka.” Jiijajmili wangka jilanya yutirringu. ");
INSERT INTO mpj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Payilatpa marlaku kurrunguka nyinatingu, maaja kuutpurlukamilingka. Ka-janampa wajarnu jantulwintikajaku Jiijajpaya katiraku. Kanguya Jiijajpa yikijunu. Payilatjura japirnu, “Kajin-janampa nyuntu Juwukajaku maaja maju?” ");
INSERT INTO mpj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jiijajjura wajarnu, “Kaji nyuntulurnin kulirnuka japirnu?, mayitpintaya Juwukajalu maajakajalu muunpungu.” ");
INSERT INTO mpj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Payilatjura wajarnu, “Mirtarna Juwu nyininpa, ngurrparnara Juwumili luwuku. Nyuntumili walyjakajalu Juwukajaluntaya kangurni ngayukarti, yatily majukajalulurrju. Ngana nyuntulu putamanu?” ");
INSERT INTO mpj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jiijajjura wajarnu, “Mirtarna maaja maju parnapurlukayuru. Ngayulurna-jananya ngampurrju kanyilpayi, ngayumili walyjakaja. Yiipirna maaja parnapurluka nyinangara, ngayumili walyjakajaluya-jananya Juwu karlki kujupa pungkungara, Juwuku maajakajalurniya mankula ngaakarti katijaku. Paki, kangurniya ngaangka yikijunu, mirtarna maaja maju parnapurlukayuru.” ");
INSERT INTO mpj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Payilatjura yarrarnu japirnu, “Kajin-janampa nyuntu Juwukajaku maaja maju?” Jiijajjura wajarnu, “Yuu! Ngayurna ngarnkajanu martukajangkarna-jananya junga wajalkura yanurni. Yiipi martura pukurlarrinpa junga kulilkuraku, ngayumili wangka pukurlju kulilku.” ");
INSERT INTO mpj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Payilatjura wajarnu, “Jurra!, mirtarnanta kulilku. Ngayurna ngunjulpa nyinani. Nganalu jungalu wajani?, mayiti palukajalu, mayiti nyuntulu?” Palujanu-jananya martukajangka Payilatpa marlaku yanu ngarangu, ka-janampa wajarnu, “Martu jiirnara purtu japirnu, mirta putamanu. ");
INSERT INTO mpj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Murrarnilurna-nyurrampa ngaayuru tayimu jiiljanu martu kuju kurtingku, jumaji turlku-nyurrampa Pajuwupa kintirringu. Kaji ngaarna-nyurrampa kurtingku?, Juwukajaku-nyurrampa maaja maju?” ");
INSERT INTO mpj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wajarnuraya martukajalu, “Mirta jiinya, Parapajpa-lampaju kurtiwa!” Parapajpa jii jurtapayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Payilatju-janampa wajarnu, jantulwintikajaluya Jiijajpa wiipuwintilu pungkura. Kaya kangu yungkalpayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Warta jilkarnwintiya jangkurruyuru ngapirnukaluya katangka junu. Kuurtuwiyajuya wikilypunguka kuurtuluya jarrpajunu, kuurtu palunga kunyjunyuminyirri. ");
INSERT INTO mpj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kujungkarringuluya ngarangu tinkijunu, karaya nyurnilu wajarnu, “Rawan-janampa nyuntu nyinaku, Juwukajaku maaja maju.” Palunyajanuya ngumpawana pungkupayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Palujanu-jananya Payilatju yanu martukajangka wajarnu, “Kulilaya! Martu paluya ngaakarti katikurni, nyakukanyurra kulilku mirta palunyalu putamanu. Mirtarna ngayulu palu mitujunu.” ");
INSERT INTO mpj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kaya Jiijajpa katingu yikijunu, kaya martukajalu nyangu jangkurru jilkarnwintikamu kuurtu marumaruwinti yikipayi. Payilatju-janampa wajarnu, “Nyawaraya martu ngaaku!” ");
INSERT INTO mpj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yatily majukajalukamu ngalyikarrpilkajalu nyangukaya wiltulu wajarnuraya, “Wartangka wiltijula!, miturntala! Wartangka wiltijula!, miturntala!” Payilatju-janampa wajarnu, “Ngurrparna, mirtarna mitujuninpa. Nyuntunjuya kati wiltijula!” ");
INSERT INTO mpj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Martukajaluraya wajarnu, “Palunyanga miturrira. Ngayunku-lampaju luwu Juwumili warlangu, jumajingku wajarnu, ‘Ngayurna Mamamili kaja.’” ");
INSERT INTO mpj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wangka palu Payilatju kulirnuka ngunjularringu, ka kulirnu jilanya, “Yiipirna-jananya Jiijajpa yungku miturntankuraku, mayitpi Mama ngarnawarrapurlukalurni pungkujaku.” ");
INSERT INTO mpj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Marlaku Jiijajpa mayangka jarrpajunu ka japirnu, “Wanyjajanun nyuntu?” Jiijajpa wulu yaka yikipayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Payilatjura wajarnu, “Nyuntulurni maaja majungka jakurljula! Ngayulurna-janampa mayitpi wajanyjangka, wiltijunkukantaya miturntalku. Mayitpirna-janampa wajalku kurtingkurantaya, palujanuntaya kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jiijajjuraya wajarnu, “Mama ngarnawarrapurlukalu kulirninpa, nyuntu maajaluju wajalkura, Mama jii majuminyirri nyininpa, nyuntun maaja jukujuku. Maaja kujupa jii walykuminyirri nyininpa, manurni katingurni nyuntukarti, yatily majulu.” ");
INSERT INTO mpj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Payilatju wangka jii kulirnuka kulilpayi yiyalkuraku, kaya martukajaluraya wululu wajalpayi jilanya, “Yiipi nyuntulu kurtingku, mayiti maaja maju nyinajaku, mirtaran maaja marlpa nyinaku, maaja majuku Tayipiriyajku. Mirta maaja-lampapula kujarra nyininpa Jiijajpakamu, paki, Tayipiriyajwiyaju.” ");
INSERT INTO mpj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","14","Jirntu kutuwartingka Payilatju wangka jii kulirnuka Jiijajpa katingu yapukutu, ka Payilatpa nyinapintiyurungka nyinangu, yapungka. Jiingka nyinapintiyurungka yapungka kuutpurlukalu murrarnilu-jananya nyinara wajalpayi. Martukajaluya yini jii wajalpayi, “Yapu pulatwan.” Yaramayik wangkawintiluya wajalpayi, “Kapaja.” Yungunpa turlku Pajuwupangka nyinakijaya Juwukaja, Payilatpa jii yapungka nyinatinguka-janampa wajarnu martukajaku, “Nyawaya! Ngaa-nyurrampa ngarinpa maaja maju, Juwukajaku.” ");
INSERT INTO mpj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Martukajaluya wajarnu, “Pipurrulu wiltijula miturntala!” Payilatju-janampa wajarnu, “Ngaa-nyurrampa maaja maju, mirtarna wajalku wiltijura miturntankuraku.” Karaya yatily majukajalu wajarnu, “Maaja maju-lampa kuju nyininpa, Tayipiriyajpa.” ");
INSERT INTO mpj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ka-jananya Payilatju Jiijajpa yungu kurtingu, jantulwintikaja, katiraya wiltijunkura. Jantulwintikajaluya manuka katipayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Katingu manu yunguraya warta majuwarta, Jiijajpaya wiltijunkuraku, kayila Jiijajju katipayi yapukarti. Martukajaluya yininga jii yapunga wajalpayi, “Kata tarrka”, Yaramayik wangkawintiluya wajalpayi, “Kulkuja.” ");
INSERT INTO mpj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yapu jiingkaya Jiijajpa niilamunuka warta majuwarta yikijunu, Jiijajkurlu. Jiijajpa jii wartangka wiltingarapayi. Martu kujarra kujupaya-pulanya jiingka wiltijunu, kujupa jungakarti, kujupa jampukartilupula wiltingarapayi, Jiijajpa kutungka. ");
INSERT INTO mpj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Payilatju julyju wajarnulu palumili warrkamupurlukangka, jilanya wakalkuraku Yaramayik wangka. Yini ngaalpa wakarnu, “Jiijajpa ngaanga Najarijmartaji, maaja maju-janampa Juwukajaku.” Palujanu kaninyjarrawana wangka palu wakarnu Laatin wangka, palujanu kaninyjarrawana wangka palu wakarnu Kiriki wangka. Ka yungu-jananya wangkawinti katiraluya Jiijajwarti wartangka pungkula murrujunkura. Martu yarnngaluya wangka palunyanga riitamunu, jumaji jiinya wiltingarangu ngamu Jarujalumwarti. ");
INSERT INTO mpj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yatily majukajaluya nyanguka wajarnuraya Payilatku, “Pakiwanan wakarnu, ‘Jiijajpa Juwukajaku maaja maju.’ Jilanyan wakalngara, ‘Jiijajju ngaalu pakiwanalu wajarnu jilanya “Ngayurna-janampa Juwukajaku maaja maju.” ’” ");
INSERT INTO mpj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Payilatju-janampa wajarnu, “Nyamu, juninparna. Wangka jii wulu ngaraku.” ");
INSERT INTO mpj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jiijajpaya wiltijunkukijalu kulujuraya tikamaturnu, karaya kujupaku junu, karaya kujupaku junu, kaya manu kujupakuraya junu, puu wulikajalu-ngkuya katamatunuka junu. Jiijajmili kuurtuya jaalpuya junu, yalyjirrjuya julyju palyarnu kuju, mirta kulujuya karlkijanu palyarnu. ");
INSERT INTO mpj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kuurtuya jii nyanguka jaalpu junu ka-ngkuya wajarnu, “Mirtala yaarrpungku-langku yungku, ngarlpurrikukala kujulu manku.” Mamamili wangka julyjujanu yiltarringu, jilanya ngarrinpa, “Ngayumili kulujuya katamatulmalpa, palujanuya ngarlpurrimalpa ngayumili kuurtu kujulu mankuraku.” Jilanya-ngkuya parangkupayi jantulwintikajalu. ");
INSERT INTO mpj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jampa Jiijajpa wartangka wiltingarapayi, palumili yipi kujarrapula ngamu yikipayi, wanti kujupa kujarralurrju, Miiri nyupara Kuliyapkukamu Miiri Makatalamartaji. ");
INSERT INTO mpj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ngayurna Jaanpa yitingkalu ngarapayi, Jiijajmili yipingka. Jiijajju-linyaju nyanguka kara wajarnu, palumili yipiku, “Jiinya nyuntumili kajayuru ngarinpa.” ");
INSERT INTO mpj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kaju ngayuku wajarnu, “Jiinya nyuntumili yipiyuru ngarinpa.” Karna ngayulu kulirnuka Jiijajmili yipi ngampurrju kanyilpayi, ngayumili ngurrangka. ");
INSERT INTO mpj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Palujanu Jiijajju nintilu kulirnu, “Ngayulurna Mamamili warrkamu ngapirnu wiyamarnu.” Palujanu wajarnu, “Ngayurna marrkurrinpa.” Jilanya Mamamili wangka julyjujanu yiltarringu. Julyju jilanya wakarnu, “Martu palulu wajalku, ‘Ngayurna marrkurrinpa.’” ");
INSERT INTO mpj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jiingka wirni ngarripayi, wayinu putakurlu. Jantulwintilu warta warlpukurrungka kuluju karrpirnu ka wayinja tupurljunukalu yitijunu, Jiijajju jikilkura. ");
INSERT INTO mpj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jiijajju wartajanu jikirnuka, wajarnu-janampa, “Mamamili warrkamurna nyamu ngapirnu.”, kayila miturringu. ");
INSERT INTO mpj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yungunpa Jarriti ngarakija, Juwukajaluraya maajakajalu jilanya kulirnu, “Luwu-lampa ngarinpa mirta mitu wiltingaraku Jarritingka kuwarringka, palunyangkala-jananya kuwarri juntakamu tarrka kaarlpungkura, pipurruya miturrira.” Kulirnukaya yanuraya japirnu Payilatpa, “Kajilaju-jananya yanku tarrkakamu junta warlangku?, kalaju-jananya manku tipujunku, Jarritingkamarra.” Yuujunu-janampa. ");
INSERT INTO mpj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Palujanu yanuya-jananya jantulwintikaja, kaya kuju tarrkakamu junta kaarlpungu, kaya kujupa jilanyarnu, ");
INSERT INTO mpj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","kaya Jiijajpanga junu, jumaji julyju miturringu. ");
INSERT INTO mpj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka jantulwinti kujupalu Jiijajpa wakarnu kultunyuku, karuwintilu, kayilalu kalyukamu, miji yintingu. ");
INSERT INTO mpj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jilanyarna ngayulu Jaanju nyangu, karna-nyurranya jakurljuninpa, kulilkuranyurra wululu, Jiijajpa yilta Mamamili. ");
INSERT INTO mpj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jilanyangulyu Jiijajpaya junu, tarrka kaarlpungkuparnilu. Mamamili wangka jilanya ngarrinpa, kayila yiltarringu. Julyju jilanya wakarnu Mamamili wangka, “Palunyangkaya martu mirta tarrka kaarlpungku.” ");
INSERT INTO mpj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mamamili wangka kujupa jilanya ngarrinpa, “Martukajaluya nyaku martu palunya, wakanyjajanu.” ");
INSERT INTO mpj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","39","Palunyajanu Juujapju Yaramajiyamartajilu yanura japirnu, Payilatpa, Jiijajpa wartajanu tipujunkura, ka katira pirnkingka junkura. Payilatpara yuujunu. Juujappa jii Jiijajmili walyja nyinapayi, mirta-jananya martu kujupakajangka wajalpayi. Ngurlurripayi-janampalura Juwukajaku maajakajaku. Juujappalu jii yanu kujungkarringu Nikatimajja. Nikatimajpa jiilu julyju yanu mungajarra Jiijajkarti wangkakuralu. Nikatimajju manu jinyji parnti kunyjunyuwinti, jinyji jii yapipala pulawu payiki yupalyuru. ");
INSERT INTO mpj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yanupula Jiijajpa tipujunu, kapula pantijiwintilu karrpirnu jinyji palunyawintilu. Jilanyankupayiya Juwumili luwungka. ");
INSERT INTO mpj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jiijajpa miturringu, jiingka kinti kaatanmayangka yikipayi, mitumili pirnki. Julyjuya pirnki jii jawarnu junu, mirta mitu kujupa ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kulirnupula pipurrulu katirapula ngarrijunkura, Jarritingkamarra, palujanupula kinti pirnkingka jiingka ngarrijunu, Jiijajpa mitu. ");
INSERT INTO mpj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jampa yaarlipalarringu kurnpungka Jaantingka Miiri Makatalamartaji yanu jii pirnkikarti. Jiingka pirnkingkangaluya julyju yapu majuwarta ruulamunu jatamapunu. Yanu Miirilu jiilu nyangu pirnkinga wupunpa. ");
INSERT INTO mpj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ka marlaku pinirringu, wajalkura-linyaju Jiijajmili wangka-ninti kujarrangka, ngayungkakamu Piijangka, “Maaja-lampaya manu kangu pirnkijanu. Katinguya wanyjangka ngarrijunu?” ");
INSERT INTO mpj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kulirnukaliju walarringu pinirringu Piijakamu. ");
INSERT INTO mpj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ngayurna pinirringu kurranyirringu pirnkingka Piijangkamarrarnalura. ");
INSERT INTO mpj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pupatingukarna nyangu pantijiwiyaju ngarripayi, mirtarna pirnkingka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Piija yanurni pipurru pirnkingka jarrpangu, ka nyangu pantiji, ");
INSERT INTO mpj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","katawanaya karrpinyjajanulurrju ngarripayi. Katawanajanunga pantijinga jaalpu ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Karna ngayulu Jaanju jarrpangu nyangu, karna kulirnu, “Yilta Miirimili wangka kunyjunyu, mirta ngarrinpa ngaangka.” ");
INSERT INTO mpj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Palu tayimulaju Jiijajmili wangka-nintikajalu mirta kulilpayi, Jiijajpa wankarrira. Mamamili wangka julyjujanu ngarripayi Kurayijpa wankarrira, mitujanu. Mirtalaju wangka jiiwana kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Palujanuliju marlaku yanu ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Miiringa wulu yikira yulapayi, pirnkingka, kayila pupangu pirnkingka nyakukija. ");
INSERT INTO mpj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ka-pulanya nyangu kujarra Mamamili wikarru kujarra, kuluju wayitwanwinti, kuju nyinapayi katawarti, kujupa nyinapayi jinawarti, Jiijajpa ngarrinyjajanungka. ");
INSERT INTO mpj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Japirnurapula, “Wanti. Nganakuran yulinpa?” Wajarnu-pulampa, “Karlkiluya manu kangu ngayumili maaja. Wanyjangkaya ngarrijunu?” ");
INSERT INTO mpj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kayila pijurringu nyangu martu yikipayi, mirta kulirnu jiinya Jiijajpa. Jiijajjura japirnu, ");
INSERT INTO mpj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Wanti. Nganakuran yulinpa? Nganakuran ngurrirninpa?” Miirilu kaatanmayapurluka kararnu, kara japirnu, “Yiipin nyuntulu manu kangu, wajalarni!, wanyjangkan ngarrijunu, kayilarna ngayulu yanku manku.” ");
INSERT INTO mpj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jiijajjura wajarnu, “Miiri.” Kayila Miirilu pijurringuka wajarnu Yaramayik wangkawintilu, “Rapuna.” Jilanya wajarnu, “Nintipuka.” ");
INSERT INTO mpj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ka Jiijajjura marrkurnu, “Mirtarni yampula!, ngayurnalu kuwarri Mamakarti yaninpa. Yarra-jananya ngayumili walyjakajangka jakurljula jilanya!, ‘Ngayurnalu kuwarri Mamakarti yaninpa, maaja majukarti. Palunyalurrju-janampa Mama ngarnawarrapurluka nyininpa, maaja maju.’” ");
INSERT INTO mpj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ka-jananya Miirilu yanu jakurljunu, Jiijajmili wangka-nintikajangka, “Jiijajparna kuwarri nyangu.” Ka-jananya jakurljunu wangka Jiijajmili. ");
INSERT INTO mpj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jantayi mungajarra Jiijajmilikajaya wangka-nintikaja mayangka kaninyjarra nyinapayi. Tuukamu wintakajaya wiltulu jatamapurnu, kaya kaninyjarra ngurlu nyinapayi, Juwumili maajakajangkamarra. Jiijajpa yanurni yuti-jananya ngarapayi, ka-janampa wajarnu, “Kunyjunyuya nyinama!, murlpirrpaya nyinama!” ");
INSERT INTO mpj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Karaya nyanguka Jiijajku pukurlarringu. Ka-jananya mara nintirnu, ka kultu karujanu nintirnu. ");
INSERT INTO mpj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yarrarnu-janampa wajarnu, “Kunyjunyuya nyinama!, murlpirrpaya nyinama! Mama ngarnawarrapurlukalurni ngayu kurtingu warrkamurnara ngapilkura, palunyangkarna-nyurranya ngayulu nyuntunpa kurtingkuni warrkamujunyurra ngapilkuraku.” ");
INSERT INTO mpj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ka-jananya puyurnu wajarnu-janampa, “Mamamili Kuurti-nyurranya jarrpinpa. ");
INSERT INTO mpj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yanku-jananyanyurra martu kujupa martu kujupangka wajalku, walykukaja wirrupungkura, ka-janampalura Mamalu manku walykukaja wirrupungku. Yiipinyurra mirta jilanya wajalku, mirta-janampalura Mamalu walykukaja manku wirrupungku.” ");
INSERT INTO mpj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jampa Jiijajpa-jananya yutirringu, palumili wangka nintikajangka mayangka, Tamajpa mirta nyinapayi jiingka. Tamajpa jii Jiijajmili wangka-ninti. Tamajpangaya jiinya yini kujupa wajalpayi, “Tuwinpa”. ");
INSERT INTO mpj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jiijajmili walyjakajalu Tamajpa nyangukaluya jakurljunu, “Maaja palulaju Jiijajpa kuwarri nyangu.” Tamajju paki kararnuka-janampa wajarnu, “Mirta wankarringu, paki. Jamparna Jiijajpa yuti nyaku, karna mara niiljanu pampulku, karna kultu karujanu pampulku, palunyajanuyilarna kulilku.” ");
INSERT INTO mpj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Palujanu wiiki kujupangkaya Jiijajmilikaja wangka-nintikaja mayangka kaninyjarra nyinapayi, Tamajpalurrju. Tuukamu wintakajaya wiltulu jatamapurnu. Ka Jiijajpa-jananya yutirringu ka-janampa wajarnu, “Kunyjunyuya nyinama!, murlpirrpaya nyinama!” ");
INSERT INTO mpj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tamajkura jilanya wajarnu, “Mararni pampula!, karni kultu pampula! Ngayu wanka ngarinpa, paki karaljakun.” ");
INSERT INTO mpj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tamajjura wajarnu, “Nyuntungajun ngayumili maaja maju ngarin, Mama ngarnawarrapurlukakamu.” ");
INSERT INTO mpj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jiijajjura wajarnu, “Ngayurnin nyangu karnin kulirnu, ngayurna wanka. Laltu kujupalurniya mirta ngayu nyaku, kulilkuwiyajurniya ngayurna Mamamili, kajuya pukurlarriku.” ");
INSERT INTO mpj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jiijajmili wangka-nintikajangka-jananya kurungka rawalu kujupa kujupa yalyjirrju nintilpayi, Jiijajju. Mirlimirli ngaangka mirta wangka wulikaja ngarrinpa, wangka karlkinpawiyaju. ");
INSERT INTO mpj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mirlimirli ngaangka yilta ngarrinpa riitamuranyurra kulilkura, Jiijajpa yilta Kurayijpa, Mamamili kaja nyininpa. Julyju-lampa jamartapungu Mamalu Jiijajpa kurtingkura. Jilanyalunyurra kulilkuka wulu wanka nyinaku. ");
INSERT INTO mpj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Palujanu Jiijajpa-lanyaju wituka yutirringu jilanya, palumili wangka-nintikajangka. Kalyungkalaju nyinapayi yini Tapiriyajja. ");
INSERT INTO mpj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jilanyalaju nyinapayi, Jayimun Piija, Tamajpa yini kujupa “Tuwinpa”, Najaniyalpa tawun Kayinamartaji. Tawun jiinya ngurra Kaliliyangka yikini. Ngayu kujarraliju kaja kujarra yirna Jipitikulijura jiingka nyinapayi, Jiijajmili wangka-ninti kujarralurrjupula. ");
INSERT INTO mpj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Piijalu-lampaju wajarnu, “Yaninparna piijikajarna-jananya mankuraku.” Wajarnulajulu, “Kujungkala yankura.” Palunyajanulaju puutungka tatirnu, ka yanu kalyuwana. Wulululaju niitingkaja kalyungka wirrupungkupayi, mungajarra, mirtalaju piijkaja mankupayi. ");
INSERT INTO mpj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yungunarringu jirntu pakarnu, nyangulaju martu kalyungka yirriti ngarapayi. Mirtalaju Jiijajpa yintarnu, kujupa kukarnulaju. ");
INSERT INTO mpj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Japirnu-lanyajura Jiijajju, “Warrinyjikajawu. piijikajanyurra maninpawu?” Wajarnulaju, “Paki.” ");
INSERT INTO mpj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wajarnu-lampaju, “Kujupakartiya wirrupuwa jiikaja niitingkaja!, palunyajanunyurra piijkaja manku.” Wirrupungukalaju purtu yilalpayi, piijikajawinti yarnngawinti. ");
INSERT INTO mpj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Karna ngayulu yintarnukarnara wajarnu Piijaku, “Jii-lampa maaja ngarinpa.” Piijalurni wangka kulirnu kuurtu walyja manukalu jarrpangu, ka pipurru kalyukutu tiputingu, kalyuwanalu yankupayi Jiijajkarti. ");
INSERT INTO mpj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Puutuyila parnangka kinti yikipayi. Karlki kujupalulaju puutu parnakarti katingu, jiilaju niitingpa yilalpayi kalyuwana parnakarti. ");
INSERT INTO mpj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Puutjanulaju tiputinguka nyangu waru kampapayi. Piijikajaya warungka kampapayi, mayilurrju kinti ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiijajju-lampaju wajarnu, “Piijikajaya marra!, jiinyurra kuwarri manu.” ");
INSERT INTO mpj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Piija yanu puutukarti, ka niitingpa yilarnu piijikajawinti, ka parnangka junu. Piijikaja jiingka yarnngaya ngarripayi, wan yantartan pipiti jurri wulikaja. Karlkinpaya piijikaja maju ngarripayi. Niiting jiinga mirta yaarryanu piijikajawinti. ");
INSERT INTO mpj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Palunyajanu Jiijajju-lampaju wajarnu, “Yarrarniya ngalkurala!” Yarnngalulaju kulilpayi, “Yilta Jiijajpa ngaanya ngarin, maaja-lampa.”, mirta kujupa ngurrpa ngarangu. ");
INSERT INTO mpj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jiijajju piijikamu mirrkakaja-lampaju manu, ka katingu-lanyaju yungu kujunnguru kujunnguru. ");
INSERT INTO mpj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jilanyarna-nyurrampa wajarnu, Jiijajpa-langku wituka yutirringu, mitujanu wankarringuka. ");
INSERT INTO mpj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mayikamu kukalaju ngalangu wiyarnu. Palujanu Jiijajjura japirnu, Jayimun Piijaku, “Piija, Jaanmili kaja. Nyuntujun pukurlarrira nyininpa, ngaakajangkamarra munkarra?” Piijalura wajarnu, “Yuu, maaja. Nyuntulun kulirninpa, ngayurnangku pukurlarrira nyininpa.” Jiijajjura wajarnu, “Ngayumili walyjakajan-jananya kanyinma!, jiipuyuru yangupalakajayuru.” ");
INSERT INTO mpj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jiijajjura wituka japirnu, “Piija, Jaanmili kaja! Nyuntujun pukurlarrira nyininpa?” Piijalura wajarnu, “Yuu, maaja. Nyuntulun kulirninpa, ngayurnangku pukurlarrira nyininpa.” Jiijajjura wajarnu, “Ngayumili walyjakajan-jananya kanyinma!, jiipuyuru.” ");
INSERT INTO mpj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jiijajjura wituka japirnu, “Piija, Jaanmili kaja! Nyuntujun pukurlarrira nyininpa?” Piija kujilarringu, jumaji yupal tayimura Jiijajjura wangka palunya japirnu. Piijalura wajarnu, “Yuu, maaja. Nyuntu-lampajun nintipuka. Nyuntulun kulirninpa, ngayurnangku pukurlarrira nyininpa.” Jiijajjura wajarnu, “Ngayumili walyjakajan-jananya kanyinma!, jiipuyuru. ");
INSERT INTO mpj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yiltalurnanta wajarninpa. Nyuntun yangupala nyinapayi, walyjalun kuliraka ngurra kujupakarti yankupayi. Jampan ngulampa nyuntu jirlpirriku, kayila martu kujupalunta mara karrpilkuka, winilku katiku ngurra kujupakutu, ngurra palunyakuran parlanypa nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jilanyalu Jiijajju Piija wajarnu, yarnngalula kulilkura, “Piija mirta walyja miturringu, kujupalu katingu miturntarnu. Palunyangka martu laltuluya marninypungkupayi Mama, jumaji Piija junga nyinapayi, Mamaku.” Jiijajjura wajarnu Piija, “Nyamu. Ngayukuju wulu junga nyinama!” ");
INSERT INTO mpj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piijalu pijurringurni nyangu ngayu Jaanpa. Ngayunpalajulu julyju Jiijajja nyinapayi, kujungkalulaju mayi ngalkupayi. Ngayurnalu ngamu yitingka nyinapayi, Jiijajparnara japirnu, “Maaja! Nganalunta wajalku yungku?, walykukajaku.” ");
INSERT INTO mpj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piijalurni nyangu, kara Jiijajpa japirnu, “Maaja! Martu jii wanyjalarriku?” ");
INSERT INTO mpj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jiijajjura wajarnu, “Mayitirna ngayulu kulirninpa, mayiti wulu wanka nyinaku, ngayurna marlakurrinyjakutuwiyaju. Mirtan nyuntu ngunjularrira, ngayuluwiyajurnangku kulilkura. Nyuntuju wulu junga nyinama!” ");
INSERT INTO mpj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Palunyajanu-ngkuya Jiijajmili walyjakajalu wajalpayi, “Yilta, mirta Jaanpa miturriku.” Wiyawanaluya kulilpayi. Jiijajjurni mirta ngayurni wajarnu, miturriraku, jilanyawiyaju wajarnu, “Mayitirna ngayulu kulirninpa, mayiti wulu wanka nyinaku, ngayurna marlakurrinyjakutuwiyaju. Mirtan nyuntu ngunjularrira, ngayuluwiyajurnangku kulilkura.” ");
INSERT INTO mpj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ngayulurna Jaanju wangka yilta ngaa wakarni, kulilkuranyurra. Ngayumili wangka ngaa yilta ngarrini, martu yarnngaluya jilanya kulirni. ");
INSERT INTO mpj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Julyju, jampa Jiijajpa parnangka nyinapayi. Jiijajju wululu-jananya martukaja wankalpayi, yalyjirrju-janampalura walykukaja mankura wirrupungkupayi. Wululu-janampalura yalyjirrju kujupa kujupa ngapilpayi. Mirta jilanya wulikaja ngaangka mirlimirlingka ngarrini. Yiipirna ngayulu wulikaja mirlimirlingka palu wangkakaja wakalngara, jii mirlimirlinga yarnnga ngarringara. ");
INSERT INTO mpj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jiyupulajalurni kulila! Julyjurnangku wakarnu mirlimirlingka, Jiijajju-jananya wajarnu, kayila-jananya parra wankalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mirlimirlingka jiingka jilanyarna junu, Jiijajju-jananya nintilpayi martukaja. Palunyangka-jananya kanalpayi martu kujupakaja. Palunyajanu Jiijajpa marlaku yanu ngarnawarra. Palunyangka kurranyu Jiijajju-jananya wajarnu yiyarnu palunyamilipurlukakaja, wangka-nintikaja, parraya wajalkuranpa, ngurrapartu ngurrapartu. Jiijajpa-jananya ngarnkakutu marlaku yankukijalu nintirnu, palumili warrkamu jungaluya palyalkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jiijajpa mitujanu wankarringu. Jiikajangka-jananya yutirringama, palunyamili wangka-nintikajangka. Laltu tayimu-jananya yutirrima wirlarra kujungka. Jiijajpaya nyakupayi rawalu yuti. Nyanguya kulirnuya, “Yilta wanka yutirringu, Jiijajpa.” Jiijajju-jananya nintilpayi yutirringuka, “Yilta Mamalu-nyurranya ngampurrju kanyilku, palumili walyjakaja wulikaja.” ");
INSERT INTO mpj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jiijajmili wangka-nintikajaya nyinapayi. Jiijajpa-jananya pakarnu ka-janampa wangkangu, “Mirtanyurra yarra!, majalaya ngaangka, Jarujalumja! Mamalu-nyurrampa yiyalku palunyamili Kuurti, jarrpaku-nyurranya kurrurnja, panyanyjunyurra nyinara. Mamalu-nyurranya Kuurti jarrpajunku, ngarnawarrapurlukalu. Jarrpajunkukija jamartapungu julyju. ");
INSERT INTO mpj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Palunyayuru julyju Jaanju-jananya jarrpajunkupayi kalyungka. Ngaa-nyurranya Kuurti jarrpajunku, Mamalu.” ");
INSERT INTO mpj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jiijajju-jananya julyju martukaja wajarnu yiyarnu, palumili wangka-nintikaja. Yanu-jananyaya nintilpayi ngurra kujupakarti, kujupakarti. Palujanuya palumili wangka-nintikajaya kujungkarringu, Jiijajja. Jiijajpaya japirnu martulu jiikajalu, “Kuwarri-lampajukun yarnngaku maajarriku?, Juwukajaku?” ");
INSERT INTO mpj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jiijajju-janampa wajarnu, “Yiltarna maaja nyinaku, ngula. Tayimkulara nyaangulaku ngurrpa, Mamawiyajura kuju ninti. Yiltampa-lampa wajarnu Mamalunga. Jilanyaya kulila! ");
INSERT INTO mpj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mamamili Kurrurnpa-nyurranya jarrpaku, kayila nyinakunyurra punparrpa. Palunyajanunyurra ngayumili wangka jakurljanu wajalku, ngayujanu. Ngurra kujupa kujupa parlparrijanunyurra parra wajalmalpa, ngurra Juutiyawana, ngurra Jamiriyawana, tawunu Jarujalumuwanalurrju. Parra-jananyanyurra wajalmalpa parlparriwana yapurrapurluka, kayilipurluka, kakarrapurluka, yulparipurluka.” ");
INSERT INTO mpj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Palujanu Jiijajpa ngarnkakutu ngurrakarti yanu. Yirra nyangamaluya ngarnawarra Jiijajja. Yanu yurnturrpuru kayila wiyarringu. Mamalu katingu palumili ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yirra nyakupayiluya palunyangka, kayilapula yutirringu puntu kujarra, Mamamili kulujpa mirtamirtawinti, parnangka. ");
INSERT INTO mpj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wajarnu-janampapula, “Kulilaya Kaliliyamartajilu! Wiyanyurra parra ngarama! Jiinga wiya wulu yankuni. Ngulampa, parra ngaraku marlakurriku yankurni. Jiinga yanu yurnturrpuru, kayila marlakurriku yurnturrpuru.” ");
INSERT INTO mpj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ngurra jiingkaya Jiijajmili wangka-nintikaja ngarangu purlingka, Yalipajja. Kumuya marlaku yanu Jarujalumkarti. Purli Yalipajpanga Jarujalumja kinti ngarangu. ");
INSERT INTO mpj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yanuya jarrpakatingu kaninyjarra mayangka, palunyangka. Ngarnawarraya tatirnu, kayilaya nyinapayi. Puntukajaya nyinapayi wangkakarra, Piija, Jaanpa, Jayimijpa, Yanturu, Pilapu, Tamajpa, Pajalamu, Maajurru, Jayimij kujupa jirlpi Yalpiyajku kaja. Jayimunjiluta, Juutajpa, palunya jirlpi Jayimijku kaja. ");
INSERT INTO mpj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kumuluraya nyinapayi Mamakuraya wangkapayi, ngarnawarrapurlukakuraya. Tujukamuluraya nyinapayi, wangkapayi, Miiri, yipira Jiijajku, tujulurrju. Kumuraya nyinapayi Jiijajku marlangulurrju. Jilanyaya kumurripayi wulu. ");
INSERT INTO mpj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Palunyajanuya kujungka wiikingkaya kujungkarringu laltukuyarra, wan yantarta an tuwinti, Jiijajmili walyjakaja. Piijalu-janampa wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Walyjakajaluya kulila! Julyju Mamakurnulu Kuurtilu wangkangulu Tayipitja. Tayipitju kulirnu mirlimirlingka wakarnu jilanya, ‘Juutajpa ngula nyinaku warrinyji miturriku. Palunya miturringu. Wiya martu kujupa nyinaku ngurra jiingka. Palunyamili warrkamu kujupalu manku.’ Palunyajanu yilta miturringu kuwarri. Juutajju-jananya yanu wajarnu maajakajangka ngalulkurakuya Jiijajpa, jantulwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jiijajmili julyju wangka-ninti Juutajpa nyinapayi, kumula Mamakurnu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ngayulurna-nyurrampa Luukju wajarninpa. “Jiikajaluraya maajakajalu maniraya yungu, Juutajju wajanyjanju. Mani jiiwintilu kayila yanu payamunu parna. Parna jiingka miturringu ngarntawinti. Nyuru nyinangu raparrkurringu. ");
INSERT INTO mpj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jarujalumumartajiluya jilanya kulirnu wangka walyja wajalpayi, ‘Yakaltama’ Ngayunjula jilanya wajalpayi, ‘Parna jiinya puta, mijikurlu.’ ");
INSERT INTO mpj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mamakurnu wangka ngarrinpa, Tayipitju wakarnu julyju jilanya, ‘Palunya miturringu. Wiya martu kujupa nyinaku ngurra jiingka.’ Jirlpi Tayipitju yarrarnu wajarnu, ‘Palunyamili warrkamu kujupalu manku.’” ");
INSERT INTO mpj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Piijalu-janampa yarrarnu wajarnu, “Palunyajanu martu kujupala manku, kumula warrkamurriku. Jiijajmili kumula wangka parra wajalku. Jilanyalurrjula parra wajalku Jiijajpa miturringu, kana pakarnu. Purrkalula manku, martu kujupa. Jilanyaya kulila!, martu mankukijalu. Jiijajpawana julyju parra yankupayi, martu palunya. Jaanju-jananya kalyungka tupulyjulpayi martukaja. Palunyangkala kumu parra yankupayi, martu palunya. Jiijajpa yanu ngarnkakutu kumulula yirra nyakupayi, martu palunyalu. Martula jiiyuru manku. Martulula kumulula parra wajanmalpa, Jiijajmili wangka.” ");
INSERT INTO mpj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Miitingjaya wangkangu, kayila kujarra martu manu. Jii martu kujarra Juujappa kayila Majayajpa. Martu jii yini yupalwinti, Juujappa, Pajapajpa, Jajajjpa. ");
INSERT INTO mpj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Martu kuju junkukijaluya Mama ngarnawarrapurluka japirnu nintilkuraku. Jilanyaluraya Mama japirnu, “Maaja! Nyuntu-janampan yarnngaku nintipuka. Nyuntulu kulini martukaja wanyjalarrikijalu. Wanyjalpan kulini nyuntulu? Nganalaju junku? Nintila-lanyaju! Nganalu Juutajku warrkamu manku? Nyuntumili warrkamu junu yanu, kayila palya yanu warukarti.” ");
INSERT INTO mpj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Purliya marraka ngarlpurrima, kayila Majayajpa winarringu. Jiijajmili martukaja kumurringu Majayajpa, kayila jii martukaja tuwalparringu. ");
INSERT INTO mpj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juwukajaya wantapuru kujungkarripayiya, Pintikajja nyinaraku. Palunyangkaluya kujungkarripayi mayi ngalkura, Mamaya marninypungkuraku. Jilanyaya kujungkarripayi wantapurukamu wantapuru, wulu. Pintikajjaya kujungkarrira nyinapayi. Palunyangkaya Jiijajmili walyjakajaya mayangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Palunyangkaya ngarnkajanu kulirnu wangalyuru, maya jiiwana wiltu wangkangu. ");
INSERT INTO mpj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Waruyuru-jananya yutirringu wulikajangka, katawana. Waru jangiyuru-jananya tilingarangu. ");
INSERT INTO mpj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Palunyangkaya wangka kujupa kujupaya wangkapayi. Martu kuju wangkapayi, kujupa. Martu kujupa wangkapayi kujupa. Jilanyaya wangkapayi Mamaku Kuurti-jananya jarrpanyjangka. Kuurtilu-jananya Mamamililu nintirnu, wangkaraku. ");
INSERT INTO mpj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Palunyangkaya nyinapayi Jarujalumja Juwukaja, Mamamili walyjakaja. Jiikajaya ngurra kujupajanu, ngurra kujupajanu yankuraluya kujungkarripayi, Jarujalumja. ");
INSERT INTO mpj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","8","Ngarnkajanuya laltulu kulilpayi wangalyuru, kaya kujungkarripayi, laltukuyarra. Wangka walyjaya kulira pukurlarripayi Jiijajmili walyjakajaluya wangkanyjan. Jiikajaluya Juwukajalu kulirnu, “Ngayunkurnu-lampaya wangka walyja wangkani.” Parna kujupajanuya-jananya kulirnuka kuru pakarnu. Wajalpayi-ngkuya, “Ngayunkurnu-lampaya wangka yilta wangkani. Ngaakajaya Kaliliyamartaji murrarni wangka kujupa wangkani. Yaalula-jananya kulirnin ngayunmili wangka wangkanyjanpaya? ");
INSERT INTO mpj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ngayunpala wangka kujupakurlu kujupakurlu, ngurra yarnngajanula. Ngurra jilanyajanu, Pajiya, Mitija, Yilumaja, Mijuputamiya, Juutiya, Kapatujiya, Puntuja, Yayija. ");
INSERT INTO mpj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Ngurra jiijanulurrju Purijiya, Pampiliya, Yijipi, Ruuman, Kuuriti, Yarapiya. Karlkinpaya Lipiyamartaji. Jii Lipiya parna Jariningka ngamu nyininpa. Yarnngalula wangka walyja kulini, Juwukajalukamu, Juwuparnilu. Karlkinpaya Juwuparni Mamaku walyjakaja nyininpa.” Yarrarnu-ngkuya wajalpayi, “Nintirninpa-lanyaya Mamaku ngarnawarrapurlukaku. Palunya-lampa maju nyinin, ngampurrju-lanya kanyirnin.” ");
INSERT INTO mpj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Palunyangkaraya purtu kulilpayi, “Yaalujanuya wangka kujupa kujupa wangkin?” ");
INSERT INTO mpj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Karlkiluya-jananya nganarnpungu, Jiijajmili walyjakaja. Jilanyaya wajarnu, “Ngaakajaya wama jikinyjajanu wangka kujupa kujupa wangkin.” ");
INSERT INTO mpj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jiijajmili jakurlpurlukakajaya, palumpa wangka-nintikaja kujungka yikipayi. Piijalu-jananya martukajangka wiltulu wajarnu, “Kulilaya Juwukajalu, ngaamartajilulurrju! Yakaluya kulila! ");
INSERT INTO mpj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mirtalaju ngayun wama jikinyjajanu wangkin, ngaangalaju yaarlipala pakarnu wangkinpa. Jikiraya rukawiyaju turangkarrinpa. ");
INSERT INTO mpj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jilanya julyju wajarnu Jawulju Mamamili wangka jakurlpurlukalu. ");
INSERT INTO mpj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mamalurna-jananya ngarnawarrapurlukalu ngula jilanyangku. Ngayulurna-jananya ngayumili Kuurti jarrpajunku, martu yarnngangka. Nyuntunmili kajalukamu yurntaltu parra-jananyaya wajalmalpa, ngayumili wangka. Nyuntunmili yirnalukamu warrinyjilurniya kapukurrilmal. ");
INSERT INTO mpj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","‘Karlki kujupangkarna-jananya warrkamupurlukangka ngayumili Kuurti jarrpajunku, yirnakajangka, wantikajangkalurrju. Kaya jiikajalu wajalmal ngayumili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ngarnkawanarna yalyjirrju kujupa kujupa palyalku. Parnawanalurrjurna kujupa kujupa palyalku. Jurta-ngkuya pungkumal parnanga mijimijirriku. Parnawana warulurrju kamparra wanalmal. Puyulurrju pakara wanalmal. Jiiyuruya martukajalu nyakula ngurlurrimalpa. Wajalmalpa-ngkuya, “Mama ngarnawarrapurluka maparn yiltaminyirri.” ");
INSERT INTO mpj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Palu tayimu jirntu mungarriku, ka wirlarra mijimijirriku. Palunyajanu-jananya wumulkuka kuru wajalku, Mama ngarnawarrapurlukalu, martu wulikajangka. ");
INSERT INTO mpj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Palunyangkayila martukajaluraya japinmalpa wankaya nyinakijalu, Mamalu-jananya wankalku’ Wangka jilanya Jawulju-jananya julyju wajarnu.’” ");
INSERT INTO mpj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piijalu-jananya yarrarnu wajarnu, “Yijurilkurnu marlajanukajalula kulila! Mamalu-lanya nintinma Jiijajpa Najarajamartaji, maparn maju. Palunyajanu Jiijajju kujupa kujupa-lanyangku nintilpayi, Mamamililurrju-lanya wangka yalyjirrju nintilpayi. Jiijajpanga maparnkurlu, Mamamili nyakupayinyurra. Nintilunyurra kulirni. ");
INSERT INTO mpj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Julyju Mamalu kulirnuka, ka yiyarnu Jiijajpa kanyurra pungkura miturntankuraku. Jilanya julyju kulirnu Jiijajpanyurra mankura-jananyanyurra yungku, walykukaja kaya katira wiltijunku, kayila miturntanku. Yiltaya Jiijajpa ngaangka miturntanu. ");
INSERT INTO mpj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Palunyajanuyila Mamalu Jiijajpanga mitujanu wankarnuka manu ngarajunu. Jiijajpanga maaja maju yarnngaku-lampa mirta mitu wulu ngarringu, paki. ");
INSERT INTO mpj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yirna Tayipitju julyju wakarnu Kurayijpanga ngulampanga yutirriku. “Jilanyara wakarnu, ‘Ngayulurna kulirni maaja majurni nyininpa, ngampurrjurni kanyirni. Mirtarna-janampa ngurlurriku martu karlkiku, jurtapayiku. Maajalurni palunyalu ngampurrju kanyirni. ");
INSERT INTO mpj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Palunya wuluyilarna marninypungkula nyinin, pukurlju. Kulirninparna ngulampangarna miturrikuka, wankarrikuka wanka nyinamal. ");
INSERT INTO mpj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mirtarni maajalu junku yanku, wulurna mitu ngarriku, yurnarriku. Wankalkurni ka ngampurrju kanyilku, nyuntumili warrkamupurluka kunyjunyu. ");
INSERT INTO mpj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nyuntulurnin nintirnuka miturrirarna wanka nyinamal. Palunyajanurna pukurlpa nyinaku, nyuntungkarnanta.’” ");
INSERT INTO mpj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piijalu-jananya yarrarnu nintilpayi, “Walyjakajalurniya kulila! Jungalurna-nyurranya wajarnin. Yirna Tayipitpa yilta miturringu. Palunyangkaya julyju tuunyjunu pirtingka, kaluya yapu ngarajunu. Kintilu yikini, nyakupayila. ");
INSERT INTO mpj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tayipit jii Mamamili wangka jakurlpurluka nyinapayi. Jilanyalu julyju jamartapungu, Mamalu, ‘Ngulampangarna nyuntumili marlajanu kujurna junku, ka-janampa maaja maju nyinaku, puntu yarnngaku.’” ");
INSERT INTO mpj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yarrarnu-jananya Piijalu wajalpayi, “Julyju Tayipitju kulirnu, ngulampanga Mamalu palyalku. Palunyajanu Kurayijpa mirlimirlingka wakarnu, ngulampanga mitujanu pakalku. Jilanya wakarnu, ‘Mirta Mamalu junku yanku mitu ngarriku, yurnarriku.’ ");
INSERT INTO mpj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wangka palunyayuru yilta Mamalu wankarnu Jiijajpa, mitujanu. Kurululaju nyangu kalajura ninti nyinin. ");
INSERT INTO mpj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Palunyangayila ngarnawarra ngarnkakutu yanu. Kalu Mamangka kujungka nyinin, maparn kujuwintipula nyininpa. Mamalura yungu palumili Kuurti. Yungkukijalura julyju jamartapungu. “Palunyajanuyila Jiijajju-lanyaju Kuurti jarrpajunkunyjangka, palunyangkayila kuwarrila murlpirrpa wangkinpa wangka kujupa kujupa. Mamamili wangkanyurra palya kulirni. ");
INSERT INTO mpj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Wangka kujupa Tayipitju wakarnu jilanya, ‘Maaja majulu wajarnu ngayumili maaja, Kurayijpa kujungkapula nyinaraku. Ngayulurna-jananya marrkulku nyuntungkamarra, walykukajaluntaya pungkujaku. Palunyakajaku-janampan maaja nyinamal.’ Wangka jilanya Tayipitju wakarnu.” Piijalu-jananya wajalpayi, “Mirta Tayipitpa ngarnawarra yanu Mamangkalu maaja nyinin, kujupalu Kurayijpa nyinin.” ");
INSERT INTO mpj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Piijalu-jananya martukajangka wajalpayi, “Juwu wulikajalunyurra kulilkura. Yilta Jiijaj palunya Kurayijpa maaja maju-lampa nyininpa. Jiijaj jiinyurra wiltijunu ka miturntanu. Maaja-lampa jilanya junu Mamalu ngarnawarrapurlukalu. Julyju-langku jamartapungu, junkura yankukijalu.” ");
INSERT INTO mpj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wangka jilanyaya kulirnuka wirla walykurringu, martukaja. Piijamapungka-jananyaya japirnu, Jiijajmili jakurlpurlukakajangka “Walyjakajalunyurra kulirni. Wanyjalmankulaju?” ");
INSERT INTO mpj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piijalu-janampa wajarnu, “Yiwarraya walykuwana jurra kayilaya jungaranyurra Jiijajku nyinama!, kujunguru kujunguru, palunyangka-nyurranyaya kalyungka jarrpajura. Jarrpajunkunyjangkayila Mamalu walyku manku wirrupungku. Kayila palunyamili Kuurti-nyurranya Mamamili jarrpajunku. ");
INSERT INTO mpj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jilanya-nyurranya julyju jamartapungu, Kuurti-nyurranya Mamalu ngarnawarrapurlukalu yungku-nyurranya, nyuntumili kajararrankamu yurntalrarran. Laltu kujupalurrju tiwaya nyinanyjan, Mamalu-jananya kujungkanku, ka-jananya palunyamili Kuurti jarrpajunku. Jilanya jarrpajunkukijalu julyju jamartapungu.” ");
INSERT INTO mpj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piijalu-jananya yarrarnu marrkulpayi. Wangka kujupa-jananya wajalpayi. Palujanu wangka jilanya wajalpayi, “Kuwarriya martukajaya puta nyinara wanarnin, ngulampanga-jananya Mamalu pungku. Jilanyangkamarraya walyku jurra!, karaya Mamaku junga nyinama!” ");
INSERT INTO mpj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yarnngakuyarraluya jii Piijakurnu wangka kulirnu, ka-jananyaya kalyungka jarrpajunkupayi. Yarnngakuyarraya Jiijajmili walyja kujungkarringu, jurri jawujun wulikaja. Laltu kujungkaya-jananya kujungkarringu, julyju Jiijajmilikajangka. ");
INSERT INTO mpj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Palunyangkayilaya-jananya nyinara kulilpayi, Jiijajmili wangka-nintikajangka, Jiijajmili jakurlpurlukakajangka. Kujungkaluya mayi ngalkupayi. Kujungkaluya Mama marninypungkula kaya japirakaluya wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mamalu-jananya Jiijajmili jakurlpurlukakaja nintirnu yalyjirrju kujupa kujupaya palyalkuranku. Martu laltuluya-jananya nyakulaka kuru pakalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jii Jiijajmili walyjakajaya kujungka parra nyinapayi, Mama marninypungkulaka. Kujungkankuya ngaparrku yinyjanunga yungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jiijajmili walyjakajalungaya mayakamu parna, wartakajalurrju jalamunkurakaya mani mankupayi. Kaya-jananya martu karlki kujupa yungkupayi, Jiijajmili walyjakaja, mayiparniya nyinanyjan, kulujuparni. ");
INSERT INTO mpj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Karrpu kujupa karrpu kujupaya kujungkarrira Juwumilingka jaaji majungka. Kaya marninypungkulaya kujungka mayinga ngalkupayi, maya walyjawana. Pukurljuya Mama nyinara marninypungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Karlkiya-janampa Jarujalumumartaji kulirnuka pukurlarringu nyinapayi. Kulirakaya-jananya karrpuparaku karrpuparaku kujungkarripayi, puntu laltukuyarranga. Jilanyaya puntu laltukuyarra wankarringu, Jiijajmili walyjarringu. Mamalu jilanyarnu-jananya. ");
INSERT INTO mpj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piijakamupula Jaan ruka yanu Jaajikarti, majukarti, Juwukurnukarti. Jiikartiya murrarni Juwukaja ruka yankupayi, Mamangka wangkaraku, ngarnawarrapurlukangka. ");
INSERT INTO mpj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jaajingka jiingka nyinapayi yirna mukuntu. Jiji juku nyinangu mukuntu majurringu. Jaajingka tuwungka nyinapayi. Tuwu jiiya wajalpayi, “Tuwu kunyjunyu.” Jiingkaya katira nyinajunkupayi palumili walyjakajalu, ngajilkuranpa-jananya, maniku. ");
INSERT INTO mpj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Piijakamupula Jaan kurrungkukija jaajingka ngajirnu-pulanya, mukuntulu. ");
INSERT INTO mpj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","5","Piijalukamu Jaanjupula nyangu, kalu Piija wangkangu, “Nyawa-linyaju!” Nyangu-pulanya ka kulirnu, “Mayitpirnipula yungku?” ");
INSERT INTO mpj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piijalura wajarnu, “Maniparnirna jampingurnangku ngapilku. Jiijaj Kurayijju Najarijmartajilu martu wankani, maparn majulu, palunyangka pakala yarra!” ");
INSERT INTO mpj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piijalu manu mara ka ngarajunu. Kayila palyarringu ka ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Mukuntujanu pukurlarringu, ka parra wuurlkalpayi, jaajjaya jarrpangu, yupalpa. Yirna mukuntujanu wuurlkalpayi kaninyjarra, pukurlpa, ka marninypungkupayi Mama, ngarnawarrapurluka. ");
INSERT INTO mpj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Nyanguya kuru pakarnu, purtuya kulirnu, “Yilta ngaa tuwungka nyinapayi, mukuntu.” ");
INSERT INTO mpj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mayangka yawujayiti yirnalu-pulanya mara ngalunma Piijakamu Jaan, puringka. Puri jiiya martukajalu wajalpayi, “Jalamanku ngurra.” Martukajaluya nyanguka pinirringuka kujungkarringu, martuya palunya nyakuraku. ");
INSERT INTO mpj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piijalu-jananya wajarnu, “Ngayumili martukajaluya kulila! Nganajanunyurra kuru pakarnu?, mirtanyurra kulinma jilanya! Ngayu kujarraluliju wankarnu ngaa mukuntu martu, yalyjirrju. Mirtanyurra kulinma! Mamakulijura junga nyinapayi, palunyangka ngaa wankarringu, paki. Jiijajkurnu maparnjuliju wankarnu. ");
INSERT INTO mpj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Jiijajpa Mamaku warrkamupurluka nyinani. Mamalu-lampa junu palunya maaja maju, ngayurtinku. Kulirninpanyurra Mamalu-jananya ngampurrju kanyilpayi julyju, Yipuram, Yajik, Jayikap. Mamalu palunyalu Jiijajpa yilta junu-lampa maaja maju. Nyuntunjunyurra manu katingu Jiijajpa, yungu-jananyanyurra maajakaja katiraya pungkuraku, mitu. Maajangka Payilatja Jiijajpa ngarapayi. Payilatju-nyurrampa wajarnu yiyalkijalu, kanyurra paki wajarnu. ");
INSERT INTO mpj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ngaanga Jiijajpanga ngurrpa mirta pungu junu martu. Wulu kunyjunyu nyinapayi, Mamaku junga. Martu kujupanyurra yiyalkura wajarnunyurra. Martu palunya puta, pungu junu martu kujupa. ");
INSERT INTO mpj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","“Payilatjanyurra Jiijajpa yarlpamulngara, jiilu martu juninpa wanka wulu nyinaranpa. Ngaampanyurra junu, jilanyanyurra wajarnu Jiijajpa miturrira. Palujanu Mamalu mitujanu wankarnu. Jiijajpa wankalaju nyangu kalaju-nyurranya wajarninpa. ");
INSERT INTO mpj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yirna ngaa junta kunyjunyurringu, Jiijajju maparnju palyamanu. Kunyjunyunyurra nyanginpa, palunyalu kulirnu Jiijajpa maparnwinti.” ");
INSERT INTO mpj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jilanya Piijalu-jananya nintilpayi. “Ngayumili martukajaluya kulila! Kulirninparna nyuntunjunyurra Jiijajpa miturntarnu kulilparnilu Mamamili. Nyuntunmili maajaluya mirta kulirnu. ");
INSERT INTO mpj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Julyjuya Mamamili wangka jakurlpurlukalu wajalpayi, Kurayijpaya pungkuraku. Julyjuya wajaranpa, wangka palunya yiltarringu. ");
INSERT INTO mpj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Palunyajanu puta junkula Mamakuraya junga nyinama!, puta-nyurrampa wirrupungkuraku, murlpirrparanyurra nyinaku. ");
INSERT INTO mpj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Palunyangka Mamalu marlaku yiyalku palumili-nyurrampa, Jiijajpa. Julyju jamartapungu Mamalu Kurayijpa marlaku yankurarni. ");
INSERT INTO mpj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mamamili ngurrangka Jiijajpa wulu nyinamalpa, Mamalu parnakamu palyamanku. Palu tayimu marlakurni yanku. Jilanya julyjuya wajarnu palumili wangka jakurlpurlukalu.” ");
INSERT INTO mpj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Piijalu-jananya yarrarnu wajalpayi, martukajangka, “Yirna Muujajju-jananya julyju wajarnu, ‘Maajalu-nyurrampa ngarnawarrapurlukalu maaja kujupa kurtingku Mamamili wangka jakurlpurluka, nyuntumili ngurra walyjajanu. Ngayurni Muujajpa-nyurrampa kurtingu nintilkura. Ngayuyuru maaja kujupa-nyurrampa ngula kurtingku. Maaja palunya purinyjunyurra kulilkura! ");
INSERT INTO mpj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yiipinyurra maaja jii kulilku junku, Mamamili wangka jakurlpurluka, Mamalu-nyurranya mitu pungku wiyalku, mirtanyurra nyinaku Mamamili walyjakaja.’ ");
INSERT INTO mpj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Mamamili wangka jakurlpurlukaluya yarnngalu wajalpayi, julyjulu Kurayijparni yanku, yirna Jamiyuljulurrju. Karlkinjuya wajalpayi wangka jii marlalu. Jilanyaya wajalpayi kuwarri yiltarringu. ");
INSERT INTO mpj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Julyju-jananya Mamalu jamartapungu, mitunyjanirrikaja kanyilkuraku. Jilanyayuruya wajalpayi Mamamili wangka jakurlpurlukakajalu. Nyininpanyurra marlajanukaja, mitunyjanirriku palunyakajaku. Nyuntunpalurrju-nyurranya kanyilku, julyju-jananya jamartapungu. Mamalu julyju wajarnu mitunyjarripurlukangka Yipuramja, ‘Nyuntumili marlajanu nyinaku. Palunyajanu yarnnga kujuparna-jananya kanyilku ngampurrju. Yarnngakuyarraya pukurlpa nyinaku, nyuntumili marlajanu.’” ");
INSERT INTO mpj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Piijalu-jananya jilanya wajalpayi martukajangka, “Palunyajanu Mamalu-lampa palumili kaja kurtingu ngayunkarti Juwukajakarti kurranyulu, ngayunpala kulira pukurlarrira. Mamalu witulkijalu kulirnu Jiijajmili wangkanyurra kulilku, walykunyurra junkura kanyurra junga nyinara Mamaku.” ");
INSERT INTO mpj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piijalukamu Jaanju martukaja-jananyapula nintijulpayi, karlkinpa-jananyaya yanu jarrpangu yatilykajakamu Jaajmili maajakaja, maaja kujupalurrju. Maaja jiilu-jananya kanyilpayi, jantulwintikaja. ");
INSERT INTO mpj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kulirnuka-pulampaya wirrilyirringu Piijakukamu Jaanku, jumajipula jilanya wajarnu, “Mamalu Jiijajpa wankarnu mitujanu, palunyajanu ngayunpalurrjula miturriraka wankarriku.” ");
INSERT INTO mpj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","4","Martu yarnngalu-pulanyaya wangka kulirnu, yiltaya Jiijajpa Mamakurnu kulirnu. “Jiijajkulara junga nyinara!” jilanyaya kulirnu Jiijajmili walyjakajalu. Kujungkarringu-jananyaya nyinapayi yarnnga kujupa, Jiijajmili walyjakajangka. Julyjuya Jiijajmili walyjakajarringu. Yarnngakuyarraya Jiijajmili walyja nyinapayi, payip jawujun, jiingka tawun Jarujalumja. Piijakamu Jaanpa-pulanyaya manu katingu jiilkarti, jiikajalu yatilykajalu, Jaajmili maajakajalu. Mungajarrapula nyinangu yungun pakarnu. ");
INSERT INTO mpj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Ngurra jiingka Jarujalumungkaya yungunpa kujungkarringu, Juwuku-janampaya maajakaja, yirnakaja, Muujajmili wangkapurlukakajalurrju, martu kujupakajalurrju. Maaja yatily kujarrapula kujungkarringu, Yanajpakamu Kayapajpa. Walyja-pulampaya nyinangu, Jaan Yalikijantalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kujarra-pulanyaya witurnu yiyarnu yankura-pulanya Piijakamu Jaan mankura katira. Katingu-pulanya ngarajunu miitingja. Maajalu-pulanya japirnu, “Wanyjalupulan mukuntu kunyjunyunu? Nganakurnu maparnwintilu?” ");
INSERT INTO mpj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mamamili Kurrurnpalu Piijangka jarrpangu. Mirta-janampa ngurlurringu murlpirrpa ngarangu. Piija Jilanya wangkangu, “Maajakajaluya kulila!, yirnakajalulurrju. ");
INSERT INTO mpj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Japirnu-linyajuyan yirna mukuntu kunyjunyurrinyja. ");
INSERT INTO mpj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kulilkuranyurra Juwu yarnngalulurrju! Mukuntu ngaa kunyjunyu ngarinpa, Jiijajkurnu maparnjanu. Julyjunyurra wajarnu katira wiltijunkula miturntara, Jiijajpa Najarajamartaji. Jiijajpa mitujanu wankarnu Mamalu. ");
INSERT INTO mpj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Julyju mitunyjarripurlukalu wakarnu wangka Mamamili, Jiijajpa maaja nyinamalpa. Jilanya wakarnu, ‘Puntuparakuluya puri palyalku warta wiltu warta kujarrangka ngarnawarra ngarrijunku. Warta wiltu jiinyaya mankura wirrupungku puta karalku. Mamalu warta wiltu palunya manu palyarnu puri. Palunyangkala nyangu yakarringu, yalyjirrju warta palunya mankula ngarnawarra ngarrijunu. Ngurra palyayila ngarangu. Warta wiltu wululu yikiku. Jiijajpa paluyuru warta wiltuyuru wulu nyinaku, maaja maju-lampa.’” ");
INSERT INTO mpj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Piijalu-jananya yarrarnu wajalpayi, “Jiijajjuwiyaju martuku puta maninpa, wirrupungkula kunyjunyuni. Kujupalu paki putajanu kunyjunyunku. Mirta Mamalu wajarnu kujupa puta mankuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Maajakajaluya purtu kulirnu, “Yaalupula nintipuka wangkinpa? Mamamili wangkapula murlpirrpa wangkin, nintipurlukapula. Mirtapula kuulja jarrpangu nintirringu.” Marlaluya kulirnu, “Jiijajju-pulanya nintirnu. Jiijajku walyjapula nyinapayi.” ");
INSERT INTO mpj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Maajakajaluya purtu kulirnu japilkija, kaya yaka nyinama, jumaji mukuntuya nyangu, kunyjunyu ngarapayi. Kujungkaya ngarapayi Piijakamu Jaan ka mukuntuyila. ");
INSERT INTO mpj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Palunyangka-jananyaya wajarnu mawu yankuraya yitiwana ngarakura, jumajiya wangka kuliljaku, Piijamapulu. Maajakajalu-ngkuya japirnu, ");
INSERT INTO mpj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Wanyjalmalkula-pulanya jii kujarra? Yarnngaya ninti, jii kujarralupula wankarnu jii mukuntujanu, maparnwintilu. Wiyala-jananya wajalku martukajangka jii kujarrapula puta. ");
INSERT INTO mpj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jiijajkurnu wangka martu karlkinjuya tiwajanuluya kuliljaku, wiyapula jii kujarralu parra wajalkura.” ");
INSERT INTO mpj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Palunyajanu-pulanyaya katingu ngarajunu, maajakajangka. Wajarnu-pulanyaya, “Mirtapulan wangka katima, ka parra wajanma!, Jiijajkurnu wangka, laltungka.” ");
INSERT INTO mpj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Piijalupula Jaanju wajarnu, “Ngananyurra kulirni, nyuntunju? Wanyjalpa Mama ngarnawarrapurluka pukurlarriku? Mayitpiliju nyuntumili wangkaliju kulira palyalku. Mayitpi jiiku pukurlarriku Mama? Mayitpiliju Mamamili wangka kulira palyalku. Mayitpi jiiku Mama pukurlarriku? Kuranjunyurra kulilkura. ");
INSERT INTO mpj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wiyaliju yaka nyinaku, jumaji nyanguliju Jiijajpa, palumili wangka murlpirrpa.” ");
INSERT INTO mpj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kulirnukaya wirrilyirringu ka-pulanyaya wajarnu, “Wiyanpula Jiijajmili wangka parra wajanmalpa, jurrapula!” Wajarnu-pulanyaya yiyarnu, purtuya kulirnuka, jiilja-pulanyaya jarrpajulkija, martuluya-jananya warrkiljaku. Martu laltuya jiiku mukuntujanuku pukurlarringu, kaya Mama ngarnawarrapurluka, marninypungu. ");
INSERT INTO mpj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yirna jii mukuntu nyinapayi puutiyi yiiya, rawa. ");
INSERT INTO mpj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Piijakamu Jaanpapula palujanu pakarnu yanu. Yanupula Jiijajmili martukajangka wajarnu, maajakajalu-pulanyaya warrkirnu, mirtapula Jiijajmili wangka parra wajalkura. ");
INSERT INTO mpj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kulirnuya ngurlurringu kaya Mamangkaluya wangkangu jilanya, “Maaja-lampajukun maju nyuntu. Palyarnun warrarnpa parlparri, ka kukakamu mayilurrju, parnakamu ngarnka. Yilta nyuntu Maaja maju, murlpirrpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Julyju nyuntumili wangka wakarnu mitunyjarripurlukalu Tayipitju, nyuntumili Kuurtilu nintirnu. Jilanya nyuntumililu warrkamupurlukalu wakarnu, ‘Ngurra kujungkaya laltu kujungkarringu, maajakaja jurtakija, Mamaku ngarnawarrapurlukaku, palumili Kurayijkulurrju. Kurayijpa jiinya Mamalu julyju jamartapungu, yiyalkija. Mirta-pulampaya jii kujarraku wirrilyirrikura, Mamaku ngurrpakaja. Mirta Kurayijpaya minyjilpa kulilkura.’” ");
INSERT INTO mpj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yarrarnuluya wangkangu Jiijajmili walyjakaja, Mamangka, “Kujungkarringu-pulanyaya ngurra Jarujalumungka, ngaangka, Yirutkamu Payilatja, Juwukajakamu Juwuparnilurrju. Kujungkarringukaya wangkangu Jiijajpa mitu pungkuraku. Jiijajpa jiinya nyuntumili kunyjunyu, nyuntumili warrkamupurluka. Mamalun julyju jamartapungu jii Kurayijpa yiyalkijan. ");
INSERT INTO mpj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Julyju nyuntulun walyjalu kulilpayi, Kurayijpaya wiltijura miturntankura, ka nyuntulu kulirnu marlaku wankalkura. Jilanyalun kulira pukurlarripayi. Jilanyaya yilta palunya kujungkarringu Kurayijpa pungkukijalu ");
INSERT INTO mpj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ngaa kujarrangka-pulanyaya marrkurnu, mirtapula Jiijajmili wangka wajalkuran laltungka. Mama, kulinma-lanyaju! Murlpirrmala-lanyaju!, nyuntumiliku wangkakulaju wajalkuran nyurilu, nyuntumili warrkamupurlukalu. ");
INSERT INTO mpj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Murlpirrmala-lanyaju!, yalyjirrjulaju wankalkuran, kujupa kujupalurrju nintilkuran, Jiijajmililu maparnju.” ");
INSERT INTO mpj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mamangkaluya wangkangu, ka maya yurriyurrirringu, palumili Kuurti-jananya jarrpangu. Palujanuya Mamamili wangka parra wajalpayi, murlpirrwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jiijajku walyjakajaraya Mamaku murlpirrpa nyinapayi, yilta. Mirta-ngkuya jurtarringkupayi, kunyjunyu-ngkuya nyinapayi. Mirtaya mikujaka nyinapayi paki, yungkupayi-ngkuya yirnilu, wartakaja, mayikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jiijajmili jakurlpurlukaluya murlpirrju parra wajalpayi. Jilanyaya wajalpayi, “Jiijajpa yiltangulyu mitujanu wankarringu, kurululaju nyangu.” Mamalu-jananya wulikaja murlpirrmanu, kunyjunyuya nyinaraku, kujungka. ");
INSERT INTO mpj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Jiijajmili walyjakajaluya mayakamu parna, wartalurrju jalamununirra ka maniya-jananya yungkupayi, Jiijajmili jakurlpurlukaja. Kayila maniya-jananya kangkura yungkupayi, kujunkujunpa, mirrkaku, wartakulurrju. Palunyajanu mirtaya karlkinpa maral nyinapayi, paki. Yungkupayiya-jananya karlkinpa maralpa. ");
INSERT INTO mpj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Jiingka nyinapayi yirna Juujappa. Parnangku jalamunu ka mani-jananya kangu yungu, Jiijajmili jakurlpurlukakajangka. Juujappa jii Jayipurijmartaji, mitu palumili Lipayi julyju nyinapayi. Jiijajmili jakurlpurlukaluya yini wajalpayi, ‘Panapaj’. Yini palu ngayunjula wajani, ‘Pukurlmalpayi.’ ");
INSERT INTO mpj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nyupararralupula parna kanyilpayi walyja, Yananayajjukamu Japaralu. Palunyapula parna jalamunu. ");
INSERT INTO mpj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yirna palunyalu mani manuka karlki kanyirnu, karlki-jananya katingu yungu Jiijajmili wangka-nintikaja, Jiijajmili jakurlpurlukakaja. Wanti palunya ninti nyinapayi yirnalura ngarranpungu yungu karlki. ");
INSERT INTO mpj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piijalulu wajarnu, “Yananayaj! Kulila! Malpuku maajalunta muunpungu, manin karlki ngarranpungkula kanyilkuraku. Kuliran junkungara. Mirtarnin ngayungkawiyaju kajarnin, Mamamili Kurrurnjalurrjulun kajarnin. Manin karlki kukujunu kanyirninpa, parna jalamunuka. ");
INSERT INTO mpj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Parnangku nyuntuku yilta nyinangu. Jalamunun parna ka mani manu. Maningku jiinya nyuntuku walyja ngarripayi. Nyaakun jilanyalu lurrparnu? Wajalngararnin karlkin mani ngarranpungu. Pakirnin kajarnu mirta ngayungkawiyaju Mamangkalurrjulun kajarnu, ngarnawarrapurlukangka.” ");
INSERT INTO mpj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yananayajju jampa wangka jiinya kulirnu punkarnu miturringu. Jampaya yarnngalu kulirnu Yananayaj punkarnu miturrinyja ngurlurringuminyirriya. Mamalu maparn majulu miturntanu. ");
INSERT INTO mpj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yangupalakajaluya wararringka miturrinyja murljirnu katingu tuunyjunu. ");
INSERT INTO mpj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wanti pukurramili ngurrpajaru-jananya yanu yikipayi, Piijamalungka. ");
INSERT INTO mpj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piijalulu japirnu, “Kaji mani ngaa wulikaja parnanpula jalamunyjajanu?” ");
INSERT INTO mpj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Palunyangkalu wantilu wajarnu, “Yuu mani ngarrinpa wulikaja.” Piijalulu wajarnu wantingka, “Mamamili Kurrurnjanpula kajarnu, lurrpalparnilunpula junkungara. Yangupalakajaya kuwarri marlakurriku, nyuntumiliya nyupa kangu tuunyjunu. Kantaya nyuntu kangku tuunyjunku.” ");
INSERT INTO mpj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ka jampa jii wangka kulirnu wantilu, ka jiingkalyu punkarnu miturringu. Yangupala jiikajaluya marlakurringu nyangu mitu, ka manu katingu tuunyjunu. ");
INSERT INTO mpj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jiijajmili walyjakajaluya kulirnu, ka karlkilurrjuya yarnnga ngurlurringuminyirri, “Mamalu-pulanya pungu.” ");
INSERT INTO mpj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Palunyajanuya-jananya yalyjirrju kujupa kujupalu nintijulpayi wankalpayi, wangka-nintikajalu, Jiijajmili jakurlpurlukakajalu. Jiijajmili walyjakajaya rawa wumurripayi, jaajingka majungka Juwumilingka, yawujayiti puringka. Puri palunyaya wajalpayi, “Jalamanku ngurra”, martukajalu. ");
INSERT INTO mpj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jarujalummartajiya ngurlurringu Jiijajmilikajangkamarra. Jiimartajiluya karlkilu kulilpayi, “Jiijajmili walyjakajaya palya nyininpa.” Karlkiya-jananya jiimartaji wumurripayi, yirnakamu wantikaja. ");
INSERT INTO mpj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Palukajaraya ngurrpa nyinapayi. Kulirnuya Jiijajmili wangka, kaya-jananya walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jiijajmili jakurlpurlukakajalu-jananyaya kujupa kujupa wankalpayi, martukaja. Palunyajanuya karlkinju-jananyaya ngarntakaja ngarrijunkupayi, pulanykartingka, ruutuwati. Kulilpayiya Piija wati yankunyjangka, palumili purilu wankalku-jananya. ");
INSERT INTO mpj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Martu yarnngarniya ngurra kujupa kujupajanu yankupayi Jarujalumkarti. Katipayirningku-jananyaya ngarntakaja. Karlkinpaya yilta ngarnta, karlkinpaya malpujanu ngarnta. Jiingka-jananyaya yarnnga wankarnu, Jiijajmilikajalu. ");
INSERT INTO mpj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yatilypa maju, palumili walyjakajalurrjuya-janampa wirrilyirringu, Jiijajmili jakurlpurlukakajaku. Yatilypa jiimapuya nyinapayi, Jaajmili maajakaja. ");
INSERT INTO mpj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jiikajaluya-jananya manu katingu jiilja junu, Jiijajmili jakurlpurlukakaja. ");
INSERT INTO mpj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mungangka Mamamili wikarru pakarnu kiitu wupuntamunu-janampa. Winirnu-jananya katingu yawujayiti junu. ");
INSERT INTO mpj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Wajarnu-janampa, yankuraya majukarti jaajikarti, martukaja-jananyaya nintilkuraku, Jiijajmili wangkaya kulira nintirrira, ka wanka nyinara. ");
INSERT INTO mpj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kulirnuya mungangka yanu jaajkarti. Yungun pakarnuya jarrpangu jaajingka, nintilpayi-jananya martukaja. Yatilypa maju nyinapayi ngurrpa, mirta-jananya kulirnu, Jiijajmili jakurlpurlukakajaya pakarnu jiiljanu. Yatily majuluya-jananya wumurnu, palumili walyjakaja, maajakaja, Juwukaja. Wumurringuya nyinapayi. Wajarnuya-jananya yiyarnu, warrkamupurlukakaja, yupalpa, jiilkarti. Wajarnu-jananyaya Jiijajmili jakurlpurlukakaja mankura kangkurarni-jananyaya. ");
INSERT INTO mpj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Jiilkartiya yanu jarrpangu, purtu-janampaya ngurrirnu. Palunyajanuya marlaku yanu jilanya-janampa wajarnu, maajakaja, ");
INSERT INTO mpj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Jiilkartilaju yanu nyangulaju kiitu jatamapu. Jantulwintikajaya yikipayi. Kalaju wupunamunu kiitpa nyangulaju-janampa, paki. Palunyakajaya yanu.” ");
INSERT INTO mpj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Maajakajaluya purtu kulirnu, jantulwintikajaku maajalurrju. Purtuya kulirnu, ka-ngkuya japirnu, “Wanyjalarringuya?” ");
INSERT INTO mpj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Martulu kujulu yanu-jananya wajarnu, “Kulilaya! Jiikajaya nyinapayi jiilja. Kuwarriya nyininpa majungka jaajingka, nintini-jananyaya.” ");
INSERT INTO mpj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jantulwintikajaya yanuya jaajikarti, maajalurrju. Pukunyju-jananyaya manu katingu, maajakajakarti, Jiijajmili jakurlpurlukakaja. Pukunyju-jananyaya manu katingu, martu yarnngangkamarra, wirrilyirriraya yungkaljakungkamarra-jananyaya, purliwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Katinguya-jananya yikijunu, maajakajangka. Yatily majulu-jananya warrkirnu, ");
INSERT INTO mpj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Julyjulaju-nyurranya wajarnu, mirtayan wajalkuran Jiijajmili wangka. Wangkayan kulirnu junu, Jarujalumwana nyuriluyan wajalpayi. Wangka jilanyalurrjuyan wajalpayi, ‘Yatilymapuluya Jiijajpa pungu.’ Mirtalaju jilanyanu.” ");
INSERT INTO mpj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Palunyangka Piijamapuluya wajarnu jilanya, “Nyinakulajura junga Mamaku, ngarnawarrapurlukaku, mirtalaju kulilku martu karlkinja. ");
INSERT INTO mpj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mamalu-jananya kanyilpayi mitunyjarrikaja. Jiilu maparn majuwintilu Jiijajpa wankarnu, mitujanu. Jiijajpanyurra nyunturtinju wajarnu wiltijunkura wartangka miturrira. ");
INSERT INTO mpj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Palunyajanu Mamalu wankarnu, ka-lampa junu maaja maju. Kujungkapula nyininpa Jiijajkamu Mama. Jiijajju-lanya mankura walykukaja warningkuni, ka-lanya wankani. Mamalu Jiijajpa junu Juwukajaku-lampa, ngayurtinjula kulira walyku junkuraku, kalara Mamaku nyinara, junga. ");
INSERT INTO mpj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jiijajpa yilta wankarringu mitujanu. Nyangulaju kalaju-nyurranya jakurljuninpa. Mamamili Kuurtilulurrju nyanguka kulini. Mamalu jarrpajuninpa Kuurti martukajangka, jampala Mamamili wangka jungalu kulilku.” ");
INSERT INTO mpj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wangkaya kulirnu kaya wirrilyirringu, maajakaja. Kaya wajarnu Jiijajmili jakurlpurlukakajangka-jananyaya pungkuraku mitu. ");
INSERT INTO mpj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kujulu maajalu wajarnu, katira-jananya, junkura yawujayiti, Jiijajmili jakurlpurlukakaja, mirtaya wangka kulilkura maajamili. Maaja palu yini Kamiliyal, Juwuku nyinapayi nintipuka. Maaja jiilu-jananya nintilpayi, Muujajku wangka. Kaya wajarnu martukajalu, palunyanga maaja palya. ");
INSERT INTO mpj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Palulu-jananya wajarnu, “Walyjakajaluya kulila!, Yijurilmili marlajanukajalu. Mirtanyurra ngarrutalu wajala jiikaja-jananya pungkura, mitu! ");
INSERT INTO mpj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nyukurni nyinapayi Jatiyajpa, nintiluyan kulirni. Jilanya-jananya wajalpayi, martukajangka, ‘Maajarna maju nyininpa, kulilkurarniyan.’ Laltuluya kulilpayi kaya wanarnu, ngapilu?, puu yantartakajalu. Palunya kujupalu pungu mitu. Palunyangkaluraya yanu, mirtaluya kujungka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Palunyayuru-janampa kujupa Juutajpa nyinapayi, Kaliliyamartaji. Martu laltuku-janampa maaja majurringu. Julyjuya kapamankajaluya mirlimirlingka wakarnu, martu yini. Palunya tayimu Juutajpa-janampa maaja majurringu. Palunya tayimu marturaya laltu kujungkarrira nyinapayi. Palunyayuru kujupalu mitu pungu. Palunyajanuluraya yanu wiyarringu. Jumajiya Jiijajpa julyju pungu, palujanuya martukaja palumilikaja pakirrikunirra. ");
INSERT INTO mpj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Palunyangkala-jananya Jiijajmili jakurlpurluka mirta wajalku pungkuraku. Yiyalaya-jananya! Mayitiya walyjalu Mamamili wangka kulirninpa, pakiwanalu. Jii pakiwanaya parra wajarninpa. Palunyangaya mirta martulu kulilku, jumaji martukurnu wangka. Palunyajanuya Jiijajmili wiyarriku. ");
INSERT INTO mpj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jampa palukajaluya Mamakurnu wangka nintini, purtula-jananya mitu pungku, jumajiya laltu kujupaluya Mamamili wangka nintinmalpa. Mamalu-jananya ngampurrju kanyilku, mayiti Mamakuranyurra jurtarrinpa. Yumurringuluya maajakajalunga kulirnu.” ");
INSERT INTO mpj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yiyarnuya-jananya warrkamupurlukakaja, yankulaya Jiijajmili jakurlpurlukakaja mankuraya-jananya katirarni. Katinguya-jananya ngarajunu. Palunyangkaya-jananya wiipukurlulu pungkupayi. Marrkurnuya-jananya mirtaya Jiijajmili wangkaya wajalkuranpa, kaya-jananya yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pukurlarringuya, yanu jumaji Jiijajkuraya junga ngarangu. Kulirnuya, “Mama-lampa pukurlarrin, jumajila Jiijajmili nyininpa. Julyjuya Jiijajpa pungkupayi, palunyayuru-lanyajuya kuwarri pungkupayi. palunyangkamarra-langkuya pungkupayi.” ");
INSERT INTO mpj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nyuriluya-jananya Juwuku jaajingka majungka jarrpara nintilpayi. Jiijajmili walyjakajangkalurrjuya-jananya mayawana jarrpara nintilpayi, wangka kunyjunyu, Jiijajmili. Nintilpayiya-jananya “Yilta Jiijajpa nyinin, Kurayijpa, Mamalu-jananya julyju jamartapungu, yiyalkura.” ");
INSERT INTO mpj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jiijajmiliya lalturrira nyinangu. Jaajipurlukaluya-jananya karrpuparaku karrpuparaku wululu yungkupayi, mayiya payamura ngalkuraku, wanti yirnaparnilu. Karlkiya-janampa wirrilyirringu, Kiriki wangkawinti, Yipuru wangkawintiku. Kiriki wangkawintiluya jilanya wajarnu, “Ngayurtinkurnu-lampaya mani julijuli ngarranpungkula yunginpaya-jananya wanti yirnaparni. Wanti yirnaparnikaja kujupaya-jananya Yipuru wangkawinti mani maju yunginpa.” ");
INSERT INTO mpj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Palunyangkaya-jananya mirrangu kujungkanu wulikaja, Jiijajmili jakurlpurlukakajalu, tuwal wulikajalu. Jilanyaya-jananya wajalpayi, “Ngayunjulaju-nyurranya Mamamili wangka nintirninpa, mirtalaju jii warrkamu junku, manilaju-jananya jii wanti yirnaparni yungkukija. ");
INSERT INTO mpj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Palunyangkamarranyurra-jananya martu japan wulikaja manku, wanti yirnaparniya-jananya ngampurrju kanyilkuran. Palunyakajangaya Mamaku nintipukakaja manku-jananyanyurra, Mamamili Kuurtiwinti, Mamakuraya murlpirrpa. ");
INSERT INTO mpj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Palunyangkalaju-nyurranya Mamamili wangka nintilmal, Mamalajura japilmal.” ");
INSERT INTO mpj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Laltuluya kulirnu pukurlarringu. Yintarnuya-jananya manu martu japan wulikaja, Tiipan. Jii Mamakura punparrju nyinangu, Mamamili Kuurtiwinti. Martu kujupanga Pilapunga, Purukuruja, Nikanu, Timun, Paminaj, Nikulaj jii Yantiyukamartaji, Juwuparni. Juwuyurulu palunyalu marninypungkula nyinapayi, Mama. ");
INSERT INTO mpj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Palunyangkaya-jananya manu katingu ngarajunu, Jiijajmili jakurlpurlukangka, wangka-nintikajangka. Maraya-jananya katangka junukaya Mamaraya japirnu, maaja-jananyaya junkukija. ");
INSERT INTO mpj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Palunyajanuya martu yarnngakuyarralu Mamamili wangka kulirnuka Jiijajmili walyjarringu nyinapayi, Jarujalumungka. Yatilykajalulurrjuya kulirnuka lalturringuka, Jiijajmilirringu kaya nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tiipanju-jananya yalyjirrju kujupa kujupa nintilpayi, ngarntalurrju-jananya yalyjirrju wankalpayi, jumaji Mamalunga murlpirrmara kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Martu karlkinjuya Tiipanpanga ngaparrpungkula warrkilpayi, Juwuku jaajipurlukaluya. Jaaji-janampa palunyanga yininga, “Ngaakajala warrkamurrira mani mankupayi. Ngurra ngaa-lampa.” Jaaji palunyangkangaya kujungkarripayi, Juwukaja Jarinimartaji, Yalikijantaramartajilurrju. Jiimartaji karlkiya-jananya kujungkarringu Juwukaja, Jilijiyamartajikamu Yayijamartaji. Jilanyaluya kujungkarringuka Tiipanja ngaparrpungkulaya warrkilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mamakurnu Kuurtilu jarrpangu ka murlpirrmanu, Tiipanju-jananya ngaparrpungu, ka-jananya junga wajarnu. Karaya purtu kulirnu ngaparrpungkulaluya wajalkura. ");
INSERT INTO mpj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Palunyajanuraya Tiipanku wirrilyirringu. Kaya-jananya karlki kujupa mani yungu, kaya-jananya karlki kujupangka parra paki jakurljunkupayi. Jilanyaluya-jananya kajalpayi, “Kulirnulaju Tiipanju Mama ngarnawarrapurlukakamu mitunyjarripurluka Muujajpa nganarnpungu-pulanya.” ");
INSERT INTO mpj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jilanyaya wangka paki kulirnuka wirrilyirringuraya martukaja, yirnakaja, Muujajmili wangkapurlukakajalurrju. Tiipanpaya yanu winirnu katingu ngarajunu, maajakajangka. ");
INSERT INTO mpj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mirranguya-janampa kaya paki kajalpayi-jananyaya. Jilanyaluya-jananya wangka wajalpayi, “Martu ngaalu mitunyjarripurlukakurnu Muujajkurnu wangka nganarnpungkupayi. Jaaji maju-lampa kaarlpungkula wiyalkura, wajalpayi.” ");
INSERT INTO mpj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kulirnulaju jilanya wajarnu. “Jiijajju jaaji maju kaarlpungkula wiyalku, Najarajamartajilu. Muujajju-lampa jii luwu yungu, Jiijajju-lampa jiilu kaarlpungku, ka-lampa luwu kujupa ngarajunku.” ");
INSERT INTO mpj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka maajakajaluya nyangu Tiipanmili ngumpa kujuparringu, Mamakurnu wikarruyururringu. ");
INSERT INTO mpj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yatilyparakuku-janampa maaja maju nyinapayi. Jiilulu Tiipanja japirnu, “Wangka jungaya jakurljuninpa?” ");
INSERT INTO mpj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tiipanju-janampa jilanya wajarnu, “Walyjakajalurniya kulila!, yirnakajalulurrju. Mama ngarnawarrapurluka maparn maju nyininpa. Mitungka-lampalura Yipuramja julyju yutirringu, palunyanga Yipurampa parna Mijuputamiyangka nyinapayi. Palunyajanu yankula nyinapayi, tawunu Yaranja. ");
INSERT INTO mpj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yutirringukalu jilanyara wajarnu, ‘Nyuntunmili ngurra walyjakamu walyjakajalurrju junkun yanku. Yankun ngurra kujupakutu. Katikurnanta nintilku ngurra palunyanga.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Palunyajanuyila Yipurampanga yanu tawunu Yarankarti, ngurra walyja junu yanuka. Nyinangu mamangayilara jiingkalyu wiyarringu. Palunyajanuyila Mama ngarnawarrapurlukalu wajarnu yiyarnu, ngurra ngaakutu. Ngurra ngaangkala nyinin. Yipurampa yanu ngurra ngaangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Palunyajanu mirtara Mamalu parna yungu walyjalu kanyilkuranku, paki, ngurra kujupakurnungka nyinapayi. Palunyangka Mamalulu jamartapungu ngulampara parnanga yungkukijalu, palunyamili marlajanukajaluraya kanyilkura. Jilanyara Mamalu wajarnu, jampa Yipurampa jijiparni nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yipuramjalu Mamalu yarrarnu wajarnu, ‘Nyuntumili marlajanukaja ngulangaya parna kujupawana nyinamal. Parna jiinga-janampa mirta walyja-janampa nyinaku. Parna jiimartajiluya-jananya warrkamukuya-jananya miikamura kanyilku. Wuluya warrkamurrira maniparni nyinaku. Maajakajaluya-jananya wiipukurlulu pungamalpa, warrkamurriraya. Jii nyuntumili marlajanukajaya wulu nyinamal warrkamurriraka, puu yantarta yiiya. ");
INSERT INTO mpj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngulampangarna-jananya jiikajanga martu walykukajanga pungku. Palunyajanuya nyuntumili marlajanukajalu ngurraya jii junku yanku. Ngurra ngaakutuya yanku, karniya ngayu marninypungamal, Mama ngarnawarrapurluka.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Palunyajanu Mamalulu nintirnu Yipuramja, jiji julijuli yirnamalkura. Yipuramju kulirnu, ‘Julyjurni Mamalu jamartapungu ngurra yungkukijalu. Wajarnurni jijirna jukujuku yirnamalku. Jilanyarna Mamaku wangka kuliraka junga nyinaku.’ Palunyajanu ngula Yipuramju palunyamili kaja Yajikpa yirnamarnu, jiji jukujuku, karrpuparakungka. Yajikju majurringuka palunyamili kaja yirnamarnu, Jayikappa. Palunyajanuyila Jayikapju majurrirakayila-jananya palunyamili kajakaja yirnamarnu. Jayikapku kajakaja tuwal wulikajarringu. Jiinpa-lampaya ngayunku mitunyjarrikaja lalturringu. ");
INSERT INTO mpj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Jayikapku kajakajaraya nyinapayi jurtarringuraya palunyankurnu marlanguku, Juujapku. Ngalurnuya kanyirnu kaya-jananya jalamunu, kamalkajawintingka, martu karlkingka. Palunyajanuya parna Yijipikutuya katingu. Katinguya junu warrkamurrira wulurtuka nyinapayi, maniparni. Warrkamupurluka jalayipa nyinapayi, jii Juujappa. Palunyanga Mamalu ngarnawarrapurlukalu ngampurrju kanyilpayi, karlki kujupaluya nyurnimankupayi. Parna Yijipingka maaja maju nyinapayi, Piiru. Palunyangkaluya Juujappa katingu ngarajunu. Palunyangka Mamalu Juujappa murlpirrmanu ka nintipuka wangkapayi. Piirulu kulirnukara pukurlarringu. Ka palunyajanu maaja maju junu. Piiruku warrkamupurlukakulurrju-janampa maajarringu, maaja-janampa puntu laltuku nyinangu, parna Yijipiwana-janampa nyinangu, wulikajaku. ");
INSERT INTO mpj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Palunyajanu-janampa kalyukamu mayi wiyarringu, parna Yijipiwanakamu parna Kayinanwana. Mitunyjanirriluraya purtu mayiku ngurrilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Parna Yijipiwana mayinga wulu ngarripayi. Parna Kayinanjanu mitunyjarripurlukalu Jayikapju kulirnuka ka-jananya palumili kajapartarnukaja junu yanu. Ka wajarnu-jananya yiyarnu. Parna jiikuraya ngurrparaya. ");
INSERT INTO mpj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yanuya mayikaja manu kayilaya marlaku yanu. Wiyarrinyjangkangaya witukaraya marlaku yanu. Palunyangka-jananya Juujapju maaja majulu wajarnu palunyamili kurtakajangka, ‘Ngayurna ngarinpa Juujappa, nyuntunkurna-nyurrampa marlangu.’ Palunyajanuyila maaja maju-janampa Piiru kulirnuka nintirringu-janampa. ");
INSERT INTO mpj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Palunyajanuyila-jananya Juujapju wajarnu yiyarnu Mamakamu karlki kujupaya-jananya mankura marlaku katirarni, parna Yijipikutu. Jilanyaya laltu nyinapayi japanti payip wulikaja. ");
INSERT INTO mpj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jayikapmapuya pakarnu yanu parna Yijipikutu. Yanuya mayikurlulpi nyinapayi. “Parna Yijipingkaya wululpi nyinangu. Miturringunirraya Jayikapkamu palunyamili kajakaja. ");
INSERT INTO mpj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kajakajaluya-jananya mitu tarrkakajanga-janampa marlaku katingu parna Kayinankarti. Ngurra Jikimjaya-jananya tuunyjunkupayi, tarrkakaja. Ngurra Jikimpanga Yipuramju julyju manikurlulu payamunu, mitukajaya-jananya walyjakaja tuunyjunkuranku. Yamamapuluya julyju ngurra palunyanga kanyilpayi. Palunyangka-jananya Yipuramju parnanga payamunu.” ");
INSERT INTO mpj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tiipanju-janampa yarrarnu wajarnu, “Mamalulu ngarnawarrapurlukalu julyjulu jamartapungu Yipuramja, parna Kayinanpanga-jananya yungkukija, palunyamili marlajanukaja. Tayimurringu-janampa, Mamalu kulirnu, ngurra-jananya yungkukija. Palunyangkaya parna Yijipingka laltukuyarrarringuya, nyinapayi, ngayunku-lampaya mitunyjanirri. ");
INSERT INTO mpj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Palunyajanu Piiru maaja wiyarringu. Palunyangka-janampa maaja kujupa nyinapayi, Yijipimartajiku-janampa. Maaja palunyangara ngurrpa Juujapkunga nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","“Maajalu-jananya majulu, walykulu muunpungkura-jananya yiyalpayi jijinkuya-jananya katira junkupayi, ngurrangka yitiwana, ngarriraya miturripayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jilanyangkayila Muujajpa jiji juku puunarringu, kunyjunyuminyirri. Palunyangkayila Muujajpanga palunyamili yipilunga jijinga kukujura kanyinma, ngurrangkartuka, wirlarra yupal wulikajangka. ");
INSERT INTO mpj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Maaja Piirulura wajanyjangkayila, palunyamili yipilu katingu, kalyungka tartalpa, puutjartuka ngarrijunu junu. Palunyangkayila Piiruku yurntalpartarnulu manu kanyirnu majumanu, yipi walyjayurulu. ");
INSERT INTO mpj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Majurrinyjayilaya Yijipimartajilu martuluya nintilpayi, yipirrijingkura kulirnu nintirringu. Palunyalu yalyjirrju pamparrjulu ngapilpayi, junga nintipukajaru wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Muujajpa nyinangu yatilyarringu. Ka-janampa marlaku yanu palunyamili walyjakajaku Yipuru wangkawintiku. Palunyangka-jananya walyjakajangka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka-pulanya nyangu Yijipimartajilu pungkupayi palunyamili walyja. Purnturringuka mitu pungu Yijipimartaji. ");
INSERT INTO mpj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Muujajju jilanyalu kulilpayi, ‘Kulirninpaya ngayumili walyjakajalu, Mamalurni ngarnawarrapurlukalu yiyarnu, ngayulurna-jananya walajura katiraku, ngurra kujupakarti.’ Mirtaya jilanya kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Karrpu kujupangka-pulanya Muujajju nyangu jurtangkupula warrkilpayi, palunyamili walyja kujarralungkupula. Ka-pulanya marrkulpayi, ‘Mirtankunpula jurtalu warrkinma!, kunyjunyupula nyinama!’ ");
INSERT INTO mpj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jurta walyjajarralunga yurnturnu junu yanu, Muujajpa. Kara wajarnu, ‘Mirta-lampajun maaja maju nyuntu, paki. Mirta-linyaju marrkunma! ");
INSERT INTO mpj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nyuntulungarnin pungkula junkujaku, Yijipimartaji jiiyuru.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wangka jii kulirnuka Muujajpanga junuka yanu, ngurra kujupangka parna Mitiyangka nyinapayi. Ngurra jiingkartuka nyinangu nyupakurlurringu. Ka nyinanguka kaja kujarrakurlurringu.” ");
INSERT INTO mpj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yarrarnu-jananya Tiipanju jilanyartuka wajalpayi, “Palunyanga rawa jiingkartuka nyinapayi, puutiyi yiiya. Palunyajanulu Mama ngarnawarrapurlukamili wikarru yutirringu, purli Janiyangka ngamu. Palunyangkayila Muujajju nyangu wartanga, tiliyikipayi, ka mirta palu warta punkarnu. ");
INSERT INTO mpj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Purtu ngurinyjirringukalu yanu kintirringu. Palunyangkayila Mama ngarnawarrapurlukalu wangkangu. ");
INSERT INTO mpj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ngayurna Mama ngarnawarrapurluka. Ngayurna-janampa mitunyjanirriku maaja maju nyinapayi, Yipuramku, Yajikku, Jayikapku.’ Muujajjunga kulirnuka tititipungkupayi, ngurlu. Kulirnukalura nyuurrarringu. ");
INSERT INTO mpj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Mamalura yarrarnu wajarnu, ‘Parna ngaanga ngurlu. Jinapukangangku yarrala jurra! ");
INSERT INTO mpj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nyakupayirna-jananya ngayun kujarramili walyjakaja, Yijipingkaya nyinanyjanpa. Maajakajaluya-jananya putalu pungkula kanyilpayi. Palunyangkayilaya mungajarra ngarrira warlkurninpa. Yiltarna-jananya kulirnin. Yanurnirna-janampa walajurarna-jananya yiyalkija, ngurra kujupakartiya, maaja putangkamarra. Nyamurnanta junkula yaninpa, yankun parna Yijipikutu.’” ");
INSERT INTO mpj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tiipanju-jananya yarrarnu wajalpayi, “Muujajpangaya palunyanga nyurnimanu junu, Yijurilmili marlajanukajalu. Jilanyaraya wajarnu, ‘Mirta-lampajun nyuntu maaja nyinin, paki. Mirta nyuntulu-lanyajun maajayurulu wajalkuran.’ Ka Mama ngarnawarrapurlukalu Muujajpanga-janampa junu yanu, maaja-janampa nyinaku. Yankula-jananya walajura yiyalkura, parna kujupakartiya yankura. Mamamili wikarrulu yutirringu, waru palunyangka. Kara Mamalu yiyarnu, Mamamili wikarru marlpararralu-jananyapula, yankura walajura yiyalkura. ");
INSERT INTO mpj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Muujajju-jananya Yijurilmili marlajanukaja walajunu ka katingu, parna Yijipijanu. Palunyalunga yalyjirrju-jananya kujupa kujupa palyara nintilpayi, parna Yijipiwana, kalyu mijimijiwana, ngurra kujupawanalurrju. Wululungulyu-jananya nintilpayi, puutiyi yiiya. ");
INSERT INTO mpj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Muujajju-jananya palunyakajanga Yijurilmili marlajanukaja wajarnu, ‘Ngulampanga-nyurrampa Mama ngarnawarrapurlukalu-nyurrampa yiyalku Mamamili wangka jakurlpurluka. Ngayurni-nyurrampa yiyarnu Mamalu, palunyayuru-nyurrampa yiyalku. Palunyanga-nyurrampa walyja yiyalku.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Muujajpa-jananya jii parra nyinapayi, yitiwana pujimanwana, ngayunku mitunyjanirriwana. Mamamili wikarrulu wangkangu yapu Janiyangka. Palunyangka jiilu Muujajju Mamamili wangka yapungka wakarnuka. Ka-jananya yungu ngayunku-lampa martu parlparriku. Martulula palunyanga wangkanga kuliraka wanka nyinamalpa. Yilta Muujajpanga maaja-janampa maju nyinapayi, yalyjirrpa. ");
INSERT INTO mpj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mitunyjanirriluya Muujajmili wangka nyurnimanukaya yurntunu ngarajunu yankuraya marlaku, parna Yijipikarti. ");
INSERT INTO mpj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Muujajpa yapungka Janiyangka nyinapayi, Yiranpa-janampa yatilypa nyinapayi. Wajarnukaya ‘Muujajjulanku junu yanu, jiilulanku parna Yijipijanu katingu. Nyuntulu-lampa miikamula maaja kujupa!, Mama ngarnawarrapurlukayuru.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Palunyajanuya miikamunu pulukuyuru, kuulungkaya, kayilaya marninypungkupayi, Mama ngarnawarrapurlukayuru. Karaya pukurlarringu, kaluya katira mirtayirti junkupayi. Pulukukuraya jiiku pukurlarringu kujungkarringu, kaluya mayi ngalkulaka yinkalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Palunyangka-jananya Mamalu junu yanu, jiirtukaya pulukukamu kurtalya wululurtuka marninypungkuran. Jilanyartuka Mamamili jakurlpurlukalu julyju wakarnu, ‘Yijurilmili marlajanukajaluya kulila! Purtujuranyurra katira pungkula yungkupayi, mirtayirti kuka, pujimanwana, wululu puuti yiiya. ");
INSERT INTO mpj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mama ngarnawarrapurlukayuru-jananyanyurra marninypungkula nyinapayi, jii Muluka, Ripana, kurtalyakajalurrju. Kalikinyurra Muluka jiiku miikamunu, ka parra katipayi. Maralunyurra palyara parnawana junkunyjan, kurtalyayuru. Jiinyurra yini wajalpayi, Ripina. Palunyangkarna-nyurranya yiyalku tiwa, ngurra Papilunja munkarranyurra nyinamal.’” ");
INSERT INTO mpj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tiipanju-jananya wajalpayi, “Mitunyjanirriluya pujimanwanaluya tiinti parra katipayi. Palunyangara tiintinga murtitikirljanuya kiinanuka parra katipayi. Ngurra palunyanga parra katira ngarajunkupayi, jiingkaluya Mama marninypungkuraku. Julyjulu Mamalu Muujajja wajarnu, kayilaya jiiwana jungalu wakarnu palyamanu. ");
INSERT INTO mpj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mitunyjanirriluya-jananya kanyirnu yunguya-jananya palunyamili kajakaja. Kaja jiikajaluya-janampa jiinya tiintinga katingu parna Kayinankarti. Palunya tayimunga-janampa Jajuwa maaja nyinapayi. Palunyamartajinga-jananya Mamalu pungu yiyarnu, palunyamili kajakajaya-janampa kunyjunyu nyinara. Ngurra jiingkangaya tiintinga jiinga ngarajunu. Ngarangu, wulurtuka ngarangu Tayipit maaja tayimukutu. ");
INSERT INTO mpj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mama ngarnawarrapurlukara maaja Tayipitku pukurlpa nyinapayi. Palunyangkara Tayipitju Mama japirnu, maya kujupa murlpirrpa palyalkura, Mamakura. Palunyajanu Mamalunga marrkurnu, ‘Ngulampaju nyuntukurnu kajalu miikamunku.’ ");
INSERT INTO mpj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","“Palunyajanu Jalamanju palunyamili kajalu miikamunu. ");
INSERT INTO mpj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mama-lampa ngarnawarrapurluka jiinga maju nyininpa, mirta mayangka nyininpa, martulu miikamunkunyjajanungka. Jilanyangulyu Mamamililu wangka jakurlpurlukalu wakarnu, julyju, ");
INSERT INTO mpj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Mamalu-jananya wajarnu. Ngayulungarna ngarnkawanakamu parnawana kanyirni. Mirtarna mayawana nyininpa, martulu miikamunkunyjajanungka. Ngayulungarna wamumpu palyarnu, majuminyirrilu. Mirtarna ngurra kujungka nyininpa, parlparriwanarna nyinin.’” ");
INSERT INTO mpj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tiipanju-jananya yumurringu warrkirnu, “Mirtanyurra kulira Mamamiliwana nyininpa. Mannganyjulunyurra kulira nyuntunkurnuwana nyininpa. Ngakumpanyurra yiltaluminyirrinyurra Mamamili wangkanga nyurnimaninpa. Nyuntunkurnu mitunyjanirriyurunyurra nyininpa, mannganyjuminyirri. Mamamili Kurrurnju-nyurranya nintilpayi, kayilanyurra kulira junkupayi. Yiltanyurra ngakumpa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nyuntunkurnu mitunyjanirriluya-jananya Mamamili wangka jakurlpurlukakajanga pungkula miturntankupayi. Mirta kujukamu wanka nyinapayi, wulikajaya-jananya pungu wiyamanu. Jiikajaluya Mamamili wangka jakurlpurlukakajalu julyju wajarnu, Kurayijparni ngulampanga yankurni, Mamamili warrkamupurluka kunyjunyu. Kulilparnilunyurra palunyalurrju pungu miturntarnu, manilunyurra yunguka. ");
INSERT INTO mpj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yiltalunyurra Mamamili wangka kanyirnin, palunyamili wikarrukajalu julyju nintinyjajanu. Kulinyjaparninyurra wulu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jii maajakajangaraya wirrilyiminyirrirringu, Tiipanku, yirra-ngkuya pajara wanarnu. ");
INSERT INTO mpj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tiipanju ngarnkakutu yirra nyanguka, Mamakamu Jiijajpa-pulanya. Jirntuyurulupula rantarnuka ngarapayi. Jilanyartuka Tiipanjunga nyangu, Mamamili Kurrurnwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yirra nyanguka-janampa wajarnu, “Nyarraya nyawa! Ngarnka wupunarrinyjangkarna-pulanya nyanginpa, yarnngaku-lampa marlpakamupula Mama. Kujungkapula ngarin, maaja maju kujarra.” ");
INSERT INTO mpj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tiipanju-jananya wajanyjangka, ka-ngkuya kulinyjangkamarra, mara kuran kujarrangka junuka kaya pinirringu, maranguru winirnu. ");
INSERT INTO mpj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Winirnuya katingu tawunja yitiwana wirrupungu. Kaya yapuwintilu yungkalkijalu kuurtukaja-ngkuya yarrara wirrupungkutingu, warrinyjikutuluya, Juulkutu. ");
INSERT INTO mpj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wululurtukaya yungkalpayi, yapuwintilu. Palunyangkayilara Jiijajpa japirnu, Tiipanju. Jilanyara wajarnu, “Maaja Jiijajpa! Kuwarrirna miturriku, kurrurnparni marra kati!” ");
INSERT INTO mpj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pupatingukalu Mamangka wiltu wangkangu, “Mama! Walykulurniya punginpa. Mirtan-jananya ngaanpa puntajulu pungku, jurra-jananya!” Palunyajanuyila miturringu. ");
INSERT INTO mpj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Juulju nyangu Tiipanpa miturrinyja, kayila pukurlarringu. Karrpu palunyangkaya kulirnukaya, kaya-jananya Jiijajmili walyjakaja, yankura pungkura, martu karlkinju, Jarujalummartajilu. Palunyangkamarraya Jiijajmili walyjakaja junuka pinirringu tiwa, parna Juutiyawanakamu parna Jamiriyawana. Jiijajmili jakurlpurlukawiyajuya nyinapayi, Jarujalumungka. ");
INSERT INTO mpj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Martu karlkinjuya Mamamili walyjakajalu, Tiipankuraya yulangukaya manu katingu tuunyjunu. ");
INSERT INTO mpj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Juulju-jananya palunyamili warrkamupurlukakaja muunpungu, Jiijajmili walyjakajaya-jananya mayangka jarrparra yilalpayi. Mankulakaya-jananya yilatira jiilja jarrpajunkupayi, yirnakajakamu wantikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jiijajmilikajalungaya yanu parlparrirringu. Yankunyjanjungaya yankula parra wajalpayi, Jiijajmili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilapunga yanu tawun majukarti, parna Jamiriyangka. Yanu-jananya parra nintilpayi, jiingka, “Jiijajpanga yilta Kurayijpa nyininpa, Mamalu julyju jamartapungu-langku yiyalkijalu-lampa.” ");
INSERT INTO mpj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Martukajalungaya yakalu kulilpayi. Pilapulunga yalyjirrju kujupa kujupa palyalpayi. Jiingkanga-jananya Pilapulunga ngarntawinti-jananya wankalpayi, parralayijikamu mukuntu. Malpulurrju-janampalura payira yiyalpayi. Payinyjangkanga-janampalura malpunga pakara wiltu mirrara pinirripayi. ");
INSERT INTO mpj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jamiriyamartajilungaya Pilapu nyangukaraya pukurlarripayi, jumaji-jananya ngarntawintikamu malpuwinti kunyjunyunkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tawun jiingkanga-jananya martu kujupalu Jayimunju wankalpayi maparnwintilu, yalyjirrju-janampa kujupa kujupa palyalpayi. Jiimartajiluya nyakura kuru pakalpayi. Palunyalungangku marninypungkupayi, wajalpayi-jananya, “Ngayungarna maju maparnwinti.” ");
INSERT INTO mpj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Palunyangkaya martu jiimartajilunga wajalpayi, “Palunyanga maparn majuwinti, Mama ngarnawarrapurlukalura yungu maparnpa. Yilta Mamakurnu nyininpa.” Palunyamili wangka yarnngaluya kulirakaraya pukurlarripayi, maniwintikajalukamu puupalakajalulurrju. ");
INSERT INTO mpj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pilapulu-jananya jakurljunkupayi, Mamalu-jananya palunyamili walyjakaja ngampurrju kanyilmal, Jiijajmili wangkalurrju. Kulirayilaraya pukurlarripayi. Palunyangkayila-jananya kalyungka jarrpajunkupayi, laltukuyarra, yirnakajakamu wantikaja. ");
INSERT INTO mpj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jayimunpanga Jiijajmili wangka kulirnuka kalyungka jarrpangu. Kalu pakarnu Pilapungka ngarapayi. Palunyalunga nyangukara ngurinyjirringu, Pilapulu yalyjirrjuminyirri kujupa kujupa palyalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Palunyajanungkaya Jarujalummartajilu walyjakajalu, Jiijajmili jakurlpurlukakajalu, jakurlpaya kulirnu, martu laltuluya Mamamili wangka kulira pukurlarringu. Palunyajanuyila Piijakamu Jaanpaya-pulanya yiyarnu tawun jiikarti Jamiriyakarti. ");
INSERT INTO mpj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yanupula jarrpangu, karapula Mamangkalupula wangkangu. Japirnurapula Mamamili Kurrurnpa jarrpajunkura-jananya, Jiijajmili walyjakajangka, kuwarrijanungka. ");
INSERT INTO mpj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","17","Palunyangka-jananyapula Piijalukamu Jaanju mara katangka junu, kalupula Mamangka wangkangu, Mamamili Kuurtiyila-jananya jarrpapayi. Palunyamartajingka-jananya mirta julyju Mamamili Kurrurnpa jarrpangu, paki, Jiijajmili wangkawiyajuya kuliraka kalyungka jarrparra nyinapayi. Yiltaya kulirnu, “Jiijajpanga maaja maju-lampa nyininpa.” Mama ngarnawarrapurlukakuraya Kuurtiku ngurrpa nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jayimunjunga palunyalunga nyangu Mamamili Kurrurnpa-jananya jarrpapayi. Palunyangka-pulanya mani yungkukija japirnu-pulanya, ");
INSERT INTO mpj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nintilarnipula. Ngayululurrjurna-jananya Mamamili Kuurti jarrpajunkuran. Yungkurnantapula maninga.” ");
INSERT INTO mpj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ka Piijalu wajarnu, “Wiya! Mamaluwiyajura Kurrurnpanga yunginpa, mirtan palunyanga manikurlulu payamurninpa. Pakiwanan kulirnin, manikamulyunpula warungka kamparra wiyarrijaku. ");
INSERT INTO mpj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nyuntungan ngurrpa, mirtala kujungkalu Mamamili warrkamunga palyalku, mirtaran Mamaku kulira junga nyininpa, paki. ");
INSERT INTO mpj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Mirta pakiwana kulinma!, jiiyuru walyku jurra! Mamara japila!, walykungkura mankura wirrupungkura. Japilara! Mayitpiran purtu japilku. Ngayulurnanta kulirnin, mayitin wulu walykurrira nyinin. Nyuntu-limpajun mikurrin.” ");
INSERT INTO mpj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jayimunju-pulampa wajarnu, Piijakukamu Jaanku, “Nyuntu kujarralujuranpula japila Mama!, yiltarrijaku nyuntu kujarramili wangka.” ");
INSERT INTO mpj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jilanyalu-jananyapula Jiijajmili wangka nintilpayi, julyjupula Jiijajpa nyakunyjajanulu. Palunyajanupula marlaku Jarujalumukarti yankunyjanju-jananyapula nintilkatipayi, ngurra parlparriwana, parna Jamiriyawana. ");
INSERT INTO mpj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","28","Mamamili wikarrulu Pilapungkalu wajarnu, “Nyamu! Wartakamu payikingku marraka yarra yulparirra!, ruutu majukarti. Ruutu jiinga pujimanwana wati yanin, tawun Kaajajanu, Jarujalumkarti.” Pilapulu wartakajangku manuka yanu, ruutu palunyawana. Ruutu jiinga julyjujanu, mirtaya jiiwanakamu yanin. Palunyangka ruutu jiiwananga yirna turilakurlu yankupayi, Jarujalumja Mama ngarnawarrapurluka marninypunguka. Turilanga yawartalu yilalpayi. Yankupayi yirna jiinga Yijiyupiyamartaji. Yijiyupiyangkanga maaja maju wanti nyinapayi, yini Kantiji. Yirna jiingkanga nyinapayira, warrkamupurluka wantiku, manikajara kanyinma. Yirnanga palunyanga kirriji nyinama nyupaparni. Palunyanga turilangka yankunyjanjura riitamulkatipayi, Mamamili wangka. Wangka jiinga Mamamili wangka jakurlpurlukalu julyju wakarnu, Yayijayalu. ");
INSERT INTO mpj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Palunyangka Pilapulu nyangu turila yawartawinti. Palunyangka Mamamili Kuurtilulu wajarnu, “Turilanga jiinga wanala!” ");
INSERT INTO mpj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilapulu pinirrira kulilkatipayi, Mamaku wangka riitamunyjanpa. Palunyangka Pilapululu japirnu, “Kajin nintilu riitamulkatin?” ");
INSERT INTO mpj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wajarnulu, “Purturna riitamulkatin, kujupalurni nintilkura!” Pilapura japirnu, “Nyunturnin turilangka tatilku?” Pilapunga tatirnuka kujungkapula nyinatikatipayi. ");
INSERT INTO mpj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jiinga Mamamili wangkanga ngarangu jilanya, “Palunyanga jiipuyuru nyinaku. Mankuya katiku mitu pungkukijalu, martu karlkinju, yaka ngaranyjanpa, jiipu jukujukuyuru. Jiipu jukujukumpa murrarni yaka ngarinpa, mitu pungkunyjangkanga. Yaka ngaramalpa jampaya wuuna katungkunyjan. Yilta palunyayuru ngaramalpa, yaka. ");
INSERT INTO mpj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Martu laltuluya palunyanga nyurnimanku, mirtaya jungalu walajunku, miturrijakungkamarra. Ngulampangaya martu jiikajangaya nyinaku putaminyirri, jumajiya mirta jungalu walajunku. Yiltaluya miturntanku.” Jilanya Yayijayalu julyju wakarnu. ");
INSERT INTO mpj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kara yirna palulu japirnu Pilapunga, “Wajalarni! Nganampa palunyanga? Mayiti Yayijaya, mayiti martu kujupa?” ");
INSERT INTO mpj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kara wajarnu Pilapulu, “Jiijajpa palunga.” Palunyangkalu Mamamili wangka Pilapulu nyakula nintilkatipayi. Nintilkatipayilu yilta palunyanga Kurayijpanga, Jiijajkurnu wangkalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ruutuwanapula yanu, yanukapula kalyu nyangu. Kara Pilapuku wajarnu, “Nyarra kalyu ngarrin. Jiingkarnin kalyungka jarrpajunku.” ");
INSERT INTO mpj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilapululu wajarnu, “Ngayulurnanta kalyungka jarrpajunku, jampan Jiijajpa yiltalu kulilku, Mamakurnu.” Pilapungkalu wajarnu, “Palunyangarna yiltalu kulirnin. Jiijaj Kurayij yilta Mamakurnu kaja nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kayila turilanga yikijunkuraku wajarnu palumili warrkamupurlukangka. Tiputinguyilapula yanu kalyungka jarrpangu. Palunyangayila Pilapulu kalyungka jarrpajunu. ");
INSERT INTO mpj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Palunyangkapula kalyujanu pakarnu tatirnu. Kayila Pilapunga Mamamili Kuurtilu winirnu katingu, tiwa, mirta palunyalu martulu Pilapunga yarrarnu nyangu, paki. Purtura ngurrirnu yumurringuyila turilangka tatirnu yanu. Jiijajpa yilta kulirnuka pukurlarringuka yanu. ");
INSERT INTO mpj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilapu yanu tawunu Yajututangka yutirringu. Palunyajanulu-jananya yankula wajalkatipayi Jiijajmili wangka. Tawunkaja yiwarrawana ngarapayi, jiiwanalu-jananya wajalkatipayi. Yanu tawunu Jijariyangka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Juulpa parra yankupayi, wajalpayi-jananya, “Wanyjaya Jiijajmili walyjakaja? Mankurna-jananya katiku jiilkarti, mitu pungkuraku-jananyaya, karlkinju.” Yanu Jarujalumkarti, yatilypa majuwartakarti, ka japirnura mirlimirliku. ");
INSERT INTO mpj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Juulju kulirnu, katikijalu mirlimirli, ngurra yini Tamajakajkarti, katira nintilkija, Juwukurnungka jaajingka maajakajangka, mirlimirli. Kulirnu Juulju “Mirlimirliya nyakura palya wajalkuraya, mankurakurna-jananya, Jiijajmili walyjakaja. Mankurna-jananya marlaku katiku ngaatu Jarujalumkarti, ka jiiljarna-jananya junku, yirnakajakamu wantikajalurrju.” ");
INSERT INTO mpj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Juulpa yankupayi, Tamajakajkarti ka kintirringu, nyanguyila tili. Palu tili majuwartalu rantarnu, ngamu Juulja. ");
INSERT INTO mpj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Palunyangka parnangka punkanyjanju ngangkurnu wangka. Jilanya kulirnu, “Juulpa Juul! Nyaaku-lampajun putarringu, ngayumiliku walyjakajaku. Nyaaku-jananyan mankurni.?” ");
INSERT INTO mpj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Juuljura japirnu, “Nganan nyuntu maaja wangkinpa?” Juuljalu wajarnu, jilanya, “Ngayurna Jiijajpa Nyuntulurnin putamanu.” ");
INSERT INTO mpj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yarrarnura wajarnu Juulku, “Pakala yarra, nyarra tawunkarti! Palunyangka martu kujupalunta nintijulku, nganan ngapilkura.” ");
INSERT INTO mpj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Palunyamili warrkamupurlukakajaya ruutungkaya yikipayi, kaya kulirnu wangkapayilu Jiijajpa. Kulirnuya ngurlurringu, kaya yaka ngarapayi, martu kujupa nyakuparni. ");
INSERT INTO mpj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Juulju pakarnu purtu nyangu, kuru pampururringu. Palunyangkaya mara winirnu katingu tawunpa Tamajakajkarti. ");
INSERT INTO mpj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Karrpuparakungka nyinangu mirrka ngalkuparni, ka kalyu jikilparni. ");
INSERT INTO mpj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Palunyangka tawunja jiingka nyinapayi, yirna Yananayajpa, Jiijajmili walyja. Yananayajju jukurrmanu, Jiijajpara mirrangu. Ka Yananayajju wajarnu, “Maaja! Ngaangkarna nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jiijajjura yarrarnu wajarnu jilanya, “Pakala yarra jiiwana ruutungka!, yiwarra kujupakutu. Martuluya yiwarra jii wajarninpa, ‘Yintulpa’ Ngurrilara jiiwana Juutajku ngurraku. Japilara Juulku!, Taajajmartajiku. Jiingka ngurrangka Mamangkalu wangkinpa.” ");
INSERT INTO mpj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yarrarnulu Jiijajpa Yananayajja wangkangu, “Juuljunta jukurrju nyuntungka nyakupayi. Nyuntulun yanku pampulku kuru maralu, palunyangkayila nyaku. Jiinganta nyakuninpa maralun pampurninpa.” ");
INSERT INTO mpj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yananayajju Jiijajja wajarnu, “Maaja! Ngurlurrinparna mayitirni jiilkarti kangkujaku. Wajarnurniya jiilu-jananya yirnalu Jarujalumungka, mankula katipayi jiilkarti, nyuntumili walyjakaja. Yilta-jananya jiilu putamankupayi. ");
INSERT INTO mpj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kuwarri Juulpa palu ngaakarti ngurrakarti yankupayi, nyuntumili walyjakaja-jananya mankura kangkupayi jiilkarti. Jarujalummartajiluya yatilypa majulu palu yiyarnu, mankuraku-jananya nyuntumilikaja, walyjakaja.” ");
INSERT INTO mpj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Maajalura Jiijajju wajarnu, Yananayajja, “Kuwarrilu yarra Juulkarti! Ngayukuju warrkamupurluka nyinaku, kuwarrirna junku. Ngayulurna kulirninpa, ngayukuju wangka-jananya parra wajalku, Juwuparnikajangka, maajakajangkalurrju, ka Juwukajangkalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ngula Juulpa jiinya wirrilyirrikuya pungku, ngayukuju jampa nyinaku. Jilanya Juuljarnalu wajalku.” ");
INSERT INTO mpj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Palujanu Yananayajpa yanu mayangka jarrpangu. Juuljalu mara junuka wajarnu, “Juulpa! Nyuntu ngayukujun walyja. Maaja Jiijajjurni yiyarnu nyunturnanta kuru pampulkura, kunyjunyunkura, nyuntungkarnanta palumili Kuurti jarrpajulkura. Jiijajpan jii kulirnu ruutungka.” ");
INSERT INTO mpj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","19","Palunyangka kuru pampurnu Yananayajju, ka nyakupayi. Palunyangka Yananayajju manu kalyungka jarrpajunu. Mayiyila ngalangu murlpirrarringu. Karrpuparakungka-jananya Juulpa kujungkarringu nyinapayi, Jiijajmili walyjakajangka. ");
INSERT INTO mpj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Juwukurnungka jaaji laltungka-jananya Juulju yanu nintijunkupayi. Jilanya-jananya nintijunkupayi, “Jiijajpa yilta Mamaku kaja nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Palunya wangkaya kulirnu, yakaya ngarapayi. Wajarnu-ngkuya, “Ngaalu-jananya yirnalu Jarujalumungka ngurrangka mankura pungkupayi, Jiijajmili walyjakaja. Jilanyaku ngaakutu yankupayi, mankuraku-jananya kangkura yungkuraku, yatilyparaku Jarujalumungka.” ");
INSERT INTO mpj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Juulju-jananya murlpirrju nintilpayi. Jungalu-jananya Juwukajangka, Tamajakajmartajingka nintilpayi. Jiijajmili wangka-jananya jilanya nintilpayi, “Mamalu julyju jamartapungu Kurayijpa kurtingkijalu. Yiltangulyu-lampa Kurayijpa kurtingu, yini Jiijajpa.” Wangka palunyayuru Juulju-jananya yilta jungalu wajarnu. Palunyangkaya purtu kulirnu ngaparrjuya warrkilkijalu, Jiijajku ngurrpakajalu. ");
INSERT INTO mpj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Palunyajanuya karrpuparakungka Juwukajaya kujungkarringu wangkapayi, Juulpaya pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Palunyangka kujupalulu jakurljunu Juulja, pungkurakuya. Tawunja palungka tinkijunu wuulju, kiitukurlu ngarapayi. Kiitungka jiingkaya, purtu majalpayi Juulku, mankuraya pungkuraku. Jirntu karrpungkaraya majalpayi, mungangkalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Juulku ngulyjukajaluya mungangka wirningka majungka karrpirnuya ruupuwintilu, kurtingu wintawanalu, wuulja nyarrakarti, pungkujakungkamarraya, walykukajalu. ");
INSERT INTO mpj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Juulpa Jarujalumkarti yanu, Jiijajmili walyjakarti-jananya yanu, nyinaraku-jananya. Nyanguya ngurlurringu pungkujaku-jananya, Juulpaya pakikajal karanu. Kulirnuya, “Wiya palunyara Jiijajku walyja, mayitpi-lanya pungkukijalu.” ");
INSERT INTO mpj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Panapajju palunyangka winirnu katingu, Jiijajmili walyjakajakarti, palumili jakurlpurlukakarti. Panapajju-jananya jakurljunu, ruutungka Juulju kulirnu maaja Jiijajpa, wangkangulu. Wajarnu-jananya jilanya, “Juulju-jananya Tamajakajja wangka Jiijajmili, murlpirrju nintilpayi.” ");
INSERT INTO mpj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","29","Palunyangka-jananya Jarujalumungka Juulpa Jiijajmili walyjakajangka nyinapayi. Jarujalumungka-jananya Juulju-jananya parra wajalpayi, murlpirrju, Jiijajmili wangka, martu laltungka. Juwukajangka-jananya minyirrju nintilpayi. Palumili wangkaya kulira junkupayi, Kiriki wangkawintikajalu. Wangkanguya pungkurakuya, mitu. ");
INSERT INTO mpj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jiijajmili walyjakajaluya kulirnu, kaya katingu tawun kujupakarti, Jijariyakarti. Palunyajanuya katingu yiyarnu, tawun Taajajkarti. ");
INSERT INTO mpj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Palunyajanuya Jiijajmili walyjakaja kunyjunyu nyinapayi, parna parlparriwana, parna Juutiyawana, parna Kaliliyawana, parna Jamiriyawanalurrju. Mirtaya-jananya pungkupayi, paki, kunyjunyuya nyinapayi. Jiijajmili walyjakajaya murlpirrpa nyinangu, yiltaminyirri, kurrungu-jananya Mamamili Kuurti. Kuurti palunyalu-jananya murlpirrmanu. Laltu kujupaluya kulirnuka kujuparringu, Jiijajmilirringu, walyja. Maajakuraya Jiijajku yilta nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Palunyajanu Piijalu-jananya tawun kujupa, tawun kujupangka kujungkara-jananya nintilpayi, Jiijajmili walyjakaja. Yanu tawunkarti yini Liitangka jarrpangu, Jiijajmili walyjakaja nintilkura. ");
INSERT INTO mpj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yirna Yaniji, ngarnta yanu nyangu, parralayiji ngarripayi, warntungka. Wulu ngarripayi ngarnta, yayit wulikajangka yiiyangka. ");
INSERT INTO mpj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piijalura wajarnu, “Yaniji! Jiijajjunta kunyjunyurnin ka pakala warntungku ruulamula!” Palunyangka palunyalu kulirnu ka yiltangulyu pakarnu. ");
INSERT INTO mpj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Parrayila yankupayi kaya nyanguka kulirnu, “Yiltangulyu Jiijajpa Mamamili.” Jilanyaya kulirnukaya Jiijajmili walyjarringu, Liitamartajilu ka tawun Jaranmartajilu. ");
INSERT INTO mpj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Palunyangka kinti tawun kujupangka ngilypi kuju nyinapayi, Jiijajmili walyja. Yini palunga Tapija. Wangka palu Kiriki wangkapayi, palunyangkaya yini palu wajalpayi, ‘Tuukaja’. Ngilypi palunyalu-jananya kulujpa wakara yungkupayi, nyarrukaja, maniparnikaja. Yulupirti-jananya yungkura ngampurrju kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Palunyajanu ngilypi palunya ngarnta majurringu, ka miturringu. Murrarniluya mayangka ngarnawarra ngururrpa mitukaja ngarrijunkupayi, tuunyjunkuraku, ngula. Jilanyaluya mitu palunya waajamura kangkura ngarnawarra ngarrijunu. ");
INSERT INTO mpj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jakurlpaya kulirnu Piija tawun Liitangka nyinapayi. Tawunpa Jaapa Liitangka kinti ngarapayi. Jaapamartajiluya Jiijajmili walyjakajalu yiyarnu martu kujarra Jiijajmili, Piijaku mankuraku. Yanulupula Piijakarti ka mirrangurapula jilanya, “Yirna! Yarrarni wala!” ");
INSERT INTO mpj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Palunyangka Piija pakarnu ka kujungkaya wala yanu marlaku, maya palunyakarti. Mayangkaya palungka katingu jarrpajunu, kaya ngarnawarra tatirnu, mitukutuluya. Ngilypikajaya nyupaparnikaja yulara yikipayi. Piijangkaluya nintirnu, kulujkaja wakara-jananya yungkupayi, ngilypi palunyalu. ");
INSERT INTO mpj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piijalu-janampa wajarnu, jaalpuya yankura ngarakura. Palunyajanuya jiinpa yanu ngarapayi. Ka Piijalu pupatingu Mamangka wangkangu. Ka mitungkalu nyanguka wangkangu, “Tapija! Pakala!” Kurungku paarlanu, ka Piijangkalu nyanguka pakarnu, mitujanu. ");
INSERT INTO mpj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Mara winirnu Piijalu, ka palungka ngaratingu. Ngarajunuka-janampa mirrangu, Jiijajmili walyjakajakukamu ngilypikajaku, nyupaparnikajaku. Nintijunu-jananya wanka ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ngilypi wankarringu kaya yanu wajalpayi, parlparri Jupawana, kaya Jiijajku walyjarringunirra. ");
INSERT INTO mpj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piija Jupangka wulu nyinapayi, Jayimunmili ngurrangka. Jayimunju palu kiinkaja ngapilpayi, wulura warrkamu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tawunja Jijariyangka maaja Kuniliyaj nyinapayi. Maaja-janampa jantulwintikajaku nyinapayi. Jantulwintikajaya jiinya yini “Yitaliyankaja”. ");
INSERT INTO mpj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kuniliyaj maaja maju, Mamakura nyinapayi, ngarnawarrapurlukaku, palumili walyjakajalurrju. Palunya Mamangkalu wangkara nyinapayi. Yungkupayi-jananya manikamu warta martukaja nyarrukaja. ");
INSERT INTO mpj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rukarukangka yirna jiilu Kuniliyajju jukurrmanu nyangu, Mamamili wikarru. Jiinya wikarru palumilingkalu mayangka jarrpangu. Jiilulu wajarnu, “Kuniliyaj!” ");
INSERT INTO mpj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Palunyangka Kuniliyaj ngurlurringukalu nyakupayi. Ka japirnura, “Maaja, nganawayi?” Kuniliyajkura wajarnu, “Mamangku pukurlpa nyinani. Nyuntulun wangkapayi Mamangka, kulilpayinta. Mamalunta nyakupayi, nyuntulu-jananyan yungkupayi, martukaja, nyarrukaja.” ");
INSERT INTO mpj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yarrarnura wajarnu wikarrulu, “Warrkamupurlukakaja-jananya yiyala tawun Jupakutu!, mankuraya kuju yirna, yini Piija. Palumili yini kujupa Jayimunpa. ");
INSERT INTO mpj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jayimun kujupangkalu palu nyininpa, kiinkaja ngapirninpa. Jayimunmili maya palu yikini kujungurrungka yirritingka.” ");
INSERT INTO mpj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mamamili wikarrululu wajarnu jilanya, ka yanu. Palunyangka-janampa Kuniliyajpa mirrangu, jantulwintiku, ka warrkamupurluka kujarraku. Jantulwinti jii Kuniliyajkura mirti nyinapayi, Mamakulurrjura walyja. Julyjura Kuniliyajku warrkamurripayi. ");
INSERT INTO mpj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Wangka jiinya wikarrulu wajanyjangka, Kuniliyajju-janampa wajarnu. Palunyajanu yiyarnu-jananya tawun kujupakarti, Jupakarti, Piijaku mankuraku. ");
INSERT INTO mpj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jiikajaya yankupayi mungarringuyila-janampa. Jupangkaya kinti yankupayi ka karrpurringuyila. Piija yurtuyurtungka mayangka tatirnu, ngarnawarra, Mamangkalu wangkakura. ");
INSERT INTO mpj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Palunyajanu wangkangu kalyparturringu. ");
INSERT INTO mpj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Piija mayiku majarnuka jukurrju nyangu, ngarnka wupunarringu. Kaliki majuyuru nyangu, tiputilpayi. Kaliki jiinya kuuna puu wulikaja nyangu, ruupuwintiyuru karrpirnu, kuunakaja. ");
INSERT INTO mpj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kalikingka palungka nyangu, kukaparnikaja, ngarripayi. Kaarnkakajayuru, wukukajayuru, jilakajayuru, jilanya kukaparni laltu ngarripayi. Kukaparni palunyakajaya Juwukajalu mirta ngalkupayi, luwu-janampa jilanya nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ngarnawarrajanulu Piijangka wajarnu, “Piija pakala puwa ngala!” ");
INSERT INTO mpj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piijalura wajarnu, “Maaja! Luwu-lampaju jilanya, mirtalaju ngalkurnin. Ngayurna parlanypa jiiyurukurna, mirta ngalkurninpa. Jiikajaya puta, mirtarna ngalkurninpa.” ");
INSERT INTO mpj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Piijangkalu yarrarnu wajarnu, “Jiikajan palyalu ngalku, Mamalunta wajarni. Mirtan jiikaja puta wajala!” ");
INSERT INTO mpj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jiiyuru Piijalu yupalja kulirnu, palunyajanu marlakuya yanu wulikaja, mirrkaparnikaja. ");
INSERT INTO mpj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jilanya ngarangu Piija ngurinyjirringu, “Nganarni jilanyalu nintirni?” Palunyangkaya Jijariyamartaji kiitungka ngarapayi. Jiikajaluya julyju japirnu, “Wanyja Jayimunku maya?” Japirnukaya yanu kiitungka ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Japirnuluya Piijaku, jilanya, “Mayitpi Jayimunpa ngaangka nyininpa, yini kujupa Piija?” ");
INSERT INTO mpj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piijalu jukurrju nyangu ka ngurinyjirripayi. Ka Mamamili Kuurtilu wajarnu, “Kulila! Yirna yupalju-ngkuya ngurrini. ");
INSERT INTO mpj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pakala tiputi ka kujungkaya yarra!, mirta-jananyan parlany ngaraku, ngayulurna-jananya yiyarnu.” ");
INSERT INTO mpj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piija tiputingu ka-jananya wajarnu, “Ngayurna Piija ngarinpa, kajijunyurra ngurrirninpa? Nganakujunyurra yanurni?” ");
INSERT INTO mpj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wajarnuluya, “Kuniliyajju-lanyaju yiyarnu, jantulwintikajamili maajalu, Mamamili walyjalu. Juwukajaluya palunya wajarninpa, ‘Kuniliyajpa yirna kunyjunyu.’” Piijangkaluya yarrarnu wajarnu, “Mamamililu wikarrulu wajarnu Kuniliyajja, nyuntulajunta mankuraku. Kujungkala yankuraku Kuniliyajmilikarti, ngurrakarti. Yirna jiilunta wangka kulilkuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Palunyangka Piijalu-jananya wajarnu, “Mayangkala kurrungkura ngalkura, ka ngarrikura yungunpala yankura!” Kaya kurrungu nyinapayi. Yungunpaya pakarnu kujungka yanu, Piija, Kuniliyajku warrkamupurlukakaja, ka Jupamartaji karlki, Jiijajmili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yanuya kutungka ngarringu. Yungunarringu kaya tawunja Jijariyangka jarrpangu. Kuwarripaya kurrungkukija jii tawunja, Kuniliyajju-jananya mirrangu kujungkarnu, palumili walyjakaja, marlpakajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piijamapuya yanu yawujayiti ngarapayi. Palujanu Kuniliyajpa yanulu Piijangka pupatingu ka marninypungu. ");
INSERT INTO mpj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ka Piijalu winirnu ka wajarnu, “Yiki! Wiyarnin marninypuwa!, ngayurna martu nyuntuyuru.” ");
INSERT INTO mpj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wangkangupula yanu mayangka kurrungu. Kurrungu-jananya Piijalu nyangu, yarnngaya nyinapayi, Juwuparnikaja. ");
INSERT INTO mpj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piijalu-jananya wajarnu jilanya, “Juwukajalulaju murrarni martu kujupa, Juwuparni, parna kujupamartaji nyakura junkupayi. Wiyalaju kujungka nyinapayi. Jilanyakunyurra ninti. Yilta Juwuparnilaju nyakura junkupayi. Kuwarri Mamalurni nintirnu, ngarnawarrapurlukalu, wiyarna martu kujupamartaji nyakura junkuraku, wiyarnara puta wajalkuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kuniliyajjalu wajarnu, “Nyuntumili wangkarna kulirnukarnanta pakarnu yanu, karlki kujupalurniya walarnu. Yanurnirnanta ngarinpa, Nyaakujun japinu ngaakartirna yankurakurni?” ");
INSERT INTO mpj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kuniliyajjura wajarnu, “Karrpuparaku karrpuparakulajulu murrarni Mamangka wangkaninpa. Karrpu yupaljarnalu ngaayurungka Mamangka wangkapayi, ngayumili mayangka, rukaruka. Karna jiingka nyangu, ngarapayi kulujpa wayitwankurlu. ");
INSERT INTO mpj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Palulurni wajarnu, ‘Mamalunta kulira nyinapayi, nyuntulun japilpayi. Nintilu kulini, nyuntulu-jananyan manikamu wartakaja yungkupayi, martukaja, nyarrukaja. Palunyajanungku pukurlpa nyininpa.’ ");
INSERT INTO mpj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yarrarnurni wajarnu, Mamamili wikarrulu, ‘Warrkamupurluka-jananya yiyala tawun Jupakarti!, yirna kujuya mankuraku, yini Piija, paluku yini kujupa Jayimunpa. Jii nyinin kujupakurnu mayangka Jayimunkurnungka, kiinkaja ngapirninpa. Jayimunmili maya jaalpu ngarinpa, kujungurruwati.’ ");
INSERT INTO mpj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Wikarrulu jii wangka wajanyjangka, palunyangkarnangku pipurru mirrangu. Kunyjunyun nyuntu yanurni. Kuwarrila yilta Mamangka kujungka nyinaku. Kujungkarringula nyininpa, nyuntumili wangkalaju kulilkura, Mamalunta nintinunyja, Maajalu.” ");
INSERT INTO mpj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Piijalu-jananya wajalpayi, “Ngayulurna kulirni jilanya, Mama-lampa pukurlpa nyininpa yarnngaku, mirta-lampaju Juwukuwiyaju pukurlpa nyininpa, paki. Jampa martu Mamaku junga nyinaku, marninypungku, palunyangka Mama pukurlarriku, mirta-lampaju Juwukuwiyaju pukurlarriku, paki. ");
INSERT INTO mpj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mamalu-lampaju jakurlpa junu yanu, Juwukajaku. Jakurlku palunyakunyurra ninti nyininpa. Mamalu jilanya jakurljunu, martula kawalya Mamaku nyinara, Jiijajpa kulilkula maaja maju-lampa. ");
INSERT INTO mpj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Jakurlpa jiinyaya parna Juutiyawanalu jakurljulpayi. Nintilunyurra kulirninpa, Jiijajpa Najarijmartaji parna Kaliliyawana nyinapayi. Julyju-jananya Jaanju nintilpayi, ka-jananya kalyungka jarrpajulpayi. Palunyajanu marlaya wangka jiinya parra wajalpayi, Jiijajpa maaja maju-lampa nyinapayi. Mamalura maparn maju yungu, palumili Kuurtilu jarrpajunu, palunyajanu murlpirrpa nyinapayi. Parlparriwanalu-jananya parra nintilpayi, ka wankalpayi-jananya ngarntakaja. Karlki kujupaku-janampa malpu payira kurtingkupayi, Mamamili maparnwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Jiijajju Juwumili ngurrawanalu-jananya parlparri parra wankalpayinirra, ngurra Jarujalumwanalurrju. Jilanyalaju kurulu nyakupayi. Palunyajanu Jiijajpaya wartangka nyiilamunu wiltijunu, miturntanu. ");
INSERT INTO mpj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Palunyajanu Mamalu mitujanu wankarnu, karrpu kujarrangka mitu ngarringu. Palujanu yutirringu-lanyaju martukajangka. ");
INSERT INTO mpj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mirtaya martulu yarnngalu nyangu, paki, karlkinjuwiyajulaju martulu nyangu. Julyju Mamalu kulirnu, ngayunjulaju Jiijajpa mitujanu nyakuraku. Ngayunjulaju Jiijajja kujungka ngalangu marla, jampa mitujanu wankarringu. ");
INSERT INTO mpj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Palunyajanu Jiijajju-lanyaju wajarnu, palunyamili wangkalaju parra jakurljulkuraku. Wangka jilanyalurrjulaju parra jakurljulkuraku, Mamalu jiinya Jiijajpa maaja maju-lampa junu. Ngulaya mitukaja wankarriku ngaraku, wankakajalurrju. Jiijajju-lampa wajalku, karlki-jananya warukarti kurtingku, ka-jananya karlki, palumili ngurrakarti katiku. Jilanya-lampa wajalku, Jiijajju, parlparriku. ");
INSERT INTO mpj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mamamili jakurlpurlukakajaluya jilanya wajalpayi, ‘Jampa martuluya Kurayijpa kulilku, Mamakurnu kaja. Palunyangka Mamalu-jananya walykukaja warningku, ka kunyjunyunku kurrurnpa. Kurayijpa maparn maju murlpirrminyirri.’” ");
INSERT INTO mpj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","46","Piijalu jilanya wajanyjangka, Mamamili Kuurti-jananya jarrpangu Juwuparnikajangka, ka wangka kujupa kujupaya wangkapayi, Mamaya marninypungkupayi. Palunyangkaya Piijamapuya kuru pakarnu, Jaapamartaji, Juwukaja, jumaji Mamamili Kurrurnpa-jananya jarrpangu, Juwuparnikajangka. ");
INSERT INTO mpj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Piijalu-janampa wajarnu Jaapamartajiku, “Ngananyurra kulirninpa? Palyaya kalyungka ngaanpa jarrpaku? Yilta-jananya Mamamili Kuurti ngaanja jarrpangu, ngayunja-lanyaju julyju jarrpangu, palunyayuruya.” ");
INSERT INTO mpj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Palunyangka Piijalu wajarnu palunyakajaya kalyungka jarrparaku, jilanya, “Jumaji Jiijajpa maaja maju-lampa, ngaankulurrju nyininpa.” Palunyajanu Piijangkaluya wajarnu, nyinakuraku-jananya karrpuparaku karrpu. ");
INSERT INTO mpj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Juwuparnikajaluya Mamamili wangka kulilpayi. Jilanyaya kulilpayi jakurlpa karlki kujupamili, Jiijajmili jakurlpurlukakajalu, Jiijajmili walyjakajalulurrju, parna Juutiyawanalu. ");
INSERT INTO mpj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Palumapungka, Juwuparnikajangka nyinapayi Piija, ka marlaku yanu Jarujalumkarti. Yanu jarrpangu kaya kuru wajarnu, Jiijajmili walyjakajalu, Juwukajalu. ");
INSERT INTO mpj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Jilanyaraya wajarnu, “Mirtan nyuntu Juwuparniwanangka nyinara ngalkura. Jurra-jananya! Nyaaku-jananyan yanu ngalangu.?” ");
INSERT INTO mpj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piijalu-jananya jilanya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tawun Jupangkarna nyinapayi. Mamangkarnalu wangkangu, ka jukurrjurna nyangu, kalikiyuru maju tiputingu, ngarnawarrajanu. Kaliki jiinya kuuna puu wulikajarna nyangu, ruupuwintiyuru karrpirnu, kuunakaja. ");
INSERT INTO mpj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kalikingka palungkarna kintilu nyangu, kukaparnikaja, ngarripayi, kaarnkakajayuru, wuukukajayuru, jilakajayuru, jilanya kukaparni laltu ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ngarnawarrajanulurni wajarnu. Jilanyarni wajarnu, ‘Piija! Pakala puwa ngala!’ ");
INSERT INTO mpj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ngayulurnara wajarnu, ‘Maaja! Luwu-lampaju jilanya, mirtalaju ngalkurnin. Ngayurna parlanypa jiiyurukurna, mirta ngalkurninpa. Jiikajaya puta, mirtarna ngalkurninpa.’ ");
INSERT INTO mpj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ngayungkarni yarrarnu wajarnu, ‘Jiikajan palyalu ngalku, Mamalurnanta wajarni, mirtan jiikaja puta wajala!’ ");
INSERT INTO mpj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jiiyururna yupalja kulirnu. Palunyajanu marlakuya yanu wulikaja, mirrkaparnikaja. ");
INSERT INTO mpj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Palunyangkaya yanu ngarapayi, mayangka yawujayiti, Jijariyamartajikaja. Maaja Kuniliyajju-jananya kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mamamili Kuurtilurni wajarnu, mirtarna-jananya parlany ngaraku, kujungkalaju yankura. Palunyajanulaju yanu Kuniliyajmili ngurratu, ka jarrpangulaju nyinangu, Jupamartajilurrjulaju yanu wulikaja. Ngaangkaya ngarinpa, jii Jupamartaji Jiijajmili walyjakaja, jikij wulikaja. ");
INSERT INTO mpj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kuniliyajju-lanyaju wajarnu, Mamamili wikarru nyangu. Jilanyalu wikarrulu wajarnu, Kuniliyajja, ‘Yiyala-jananya nyuntumili warrkamupurluka!, tawun Jupakutu, mankurakun Piija, yini kujupa Jayimun. ");
INSERT INTO mpj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jiilu-nyurranya Mamamili wangka nintilku. Palunyanyurra kulilku, ka Mamalunta wankalku nyuntun wulu nyinakura, nyuntumili walyjakajalurrju.’” ");
INSERT INTO mpj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Piijalu-jananya yarrarnu wajarnu, “Jungarna yanu Kuniliyajmili ngurrakutu, Mamamili wangkarna-jananya nintilpayi. Palunyangka Mamamili Kuurti-jananya jarrpangu, julyju-lanyaju ngayunja jilanya jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Palunyangkarna kulirnu, Jiijajju-lanya julyju wajarnu, ‘Jaanju-jananya kalyungka jarrpajulpayi, jilanyayuru ka ngulanga Mamalu-nyurranya palumili Kuurti jarrpajunku.’” ");
INSERT INTO mpj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Piijalu-janampa yarrarnu wajarnu, “Julyjula Jiijajpa kulilpayi, ka Mamalu-lanya jarrpajunu palumili Kuurti. Palunyayuru-jananya Mamalu kuwarri jarrpajunu Kuurti, Kuniliyajmapungka. Palunyangkarna wiya ngayulu marrkurnu Mama, mirta-jananya Kuurti jarrpajunkuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jiijajmili jakurlpurlukakajaluya kulirnu Piijamili wangka, kaya yaka nyinapayi. Purtuya kulirnu ngaparrpaya wangkakuraku, mirtaya warrkirnu. Palunyajanuya Mama marninypungkupayi, jilanya, “Mama kunyjunyuminyirri nyininpa, Juwukaja-lanya wankarninpa, ka-jananya Juwuparnikajalurrju wankarninpa, walykuya junkuraku, ka kunyjunyuya nyinaraku.” ");
INSERT INTO mpj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Juwukajaluya julyju Tiipanpa pungu. Palunyajanuya Jiijajmili walyjakaja yanu parlparri, mankujaku-jananyaya. Parna Panijiyakutuya yanu, parna Japurijkutulurrju, ka tawun Yantiyukakutulurrju. Juwukajangkaya-jananya yankura jakurljulpayi, Jiijajmili wangka, mirta Juwuparnikajangka, wiya. ");
INSERT INTO mpj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jiijajmili walyjakajaya yanu tawun Yantiyukakarti, Japurijmartajiya. Jiingkaya Jiijajmili wangka jakurljulpayi, Juwuparnikajangka, Kiriki wangkawintikajangka. Tawun jiikutu-jananyaya yanu nintilpayi Jiijajmili wangka, parna Jarinimartajilu. ");
INSERT INTO mpj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Palunyakajaluya Mamamili maparnwintilu parra nintilpayi, murlpirrju. Palunyajanuya Yantiyukamartajilu yarnngalu, martulu kulirnu, Jiijajpa maaja maju yilta. ");
INSERT INTO mpj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kulirnuya Jarujalummartajilu yiltaya Jiijajmili walyjarringu nyinapayi, Juwuparnikaja, yarnngakuyarra, kujungka. Palunyajanu Panapajpaya kurtingu, tawun Yantiyukakarti. ");
INSERT INTO mpj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yanu tawun palunyakarti jarrpangu Panapajpa, ka nyangu-jananya pukurlarringu, jumaji Mamalu-jananya wankarnu pukurlmanu. Panapajju-jananya nintilpayi, wuluya junga nyinaraku, Jiijajku. ");
INSERT INTO mpj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapaj jii yirna kunyjunyu nyinapayi, Mamamililu Kuurti jarrpangu. Jiijajkura junga wulu nyinapayi. Panapajku wangka jiimartajiluya kulirnu Jiijajku walyjarringuya nyinapayi, yarnngakuyarra. ");
INSERT INTO mpj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Palunyajanu Panapaj yanu tawun Taajajakarti, Juulkura ngurrilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Juulpa manu ka marlaku katingu tawun Yantiyukakarti. Jiingkapula Jiijajmili walyjakaja nintilpayi, rawalu yiiyangka kujungka. Ngurra jiingkaya wajalpayi, kuwarriwiyajuya jilanya, “Ngaanpaya Kirijinpa nyininpa.” Mirta jilanyaya julyju wajalpayi, paki. ");
INSERT INTO mpj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Palunyajanuya Mamaku wangka jakurlpurlukakajaya yanu tawun Yantiyukakarti, Jarujalumjanu, ");
INSERT INTO mpj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yantiyukangkaya jarrpangu. Ka jiikajangka kuju nyinapayi yini Yakapajpa. Yakapajjalu Mamamili Kuurtilu nintirnu. Palunyangka palu Yakapajpa ngarangu ka wajarnu, jilanya, “Ngurra parlparriwana ngula mayiparnirrikula, ka kalyuparnirrikulurrjula.” Jilanya-janampa wajarnu Yakapajju. Wangka palunya yiltarringu, maaja Kulutiyajpa tayimu. ");
INSERT INTO mpj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mirrka pakirrijaku ka kalyu pakirrijakulurrjuya kurranyi kujungkarringu, Jiijajmili walyjakaja, Yantiyukamartaji. Yakapajmili wangkaya kulirnukaya wangkangu maniya-janampa warningkura kaya, kurtingkura, parna Juutiyamartajiku, Jiijajmili walyjakajaku. ");
INSERT INTO mpj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Maniya pirtijunu ka yunguya-jananya katirakuya, jaajiku maajakajaku. Juuljupula Panapajju mani palunya katingu-jananyapula yungu. ");
INSERT INTO mpj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Parna Juutiyangka maaja maju nyinapayi, yini Yirutpa. Jiijajmili walyjakaja-jananya mankura pungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Maaja jiilura wajarnu Jayimijpa wakara junkuraku, nayipu warlpukurruwintilu. Jayimijpangara palunyanga Jaanku kurta nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yiltaya Jayimijpa wakarnu junu. Palunyangkaya pukurlarringu Juwukaja kaya maajanga palunyanga marninypungkupayi. Palunyajanu maaja Yirutju kulirnu yarrara-jananya pukurlmankura. Ka-janampa wajarnu, yankuraya Piija mankura. Kaya yanu Piija manu, jantulwintikajalu. Murrarniya kujungkarrima turlku Pajuwupangka nyinakura. Palunyangkaya Juwukajalu mayi pikinpawutuparni ngalkupayi, Mama marninypungkuraku. Jilanyaya ngalkupayi mayi-janampa yini Pajuwupa. Palunya tayimungaya Piija manu katingu, ");
INSERT INTO mpj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","jiilja jarrpajunu, ka wulu kanyinma, jantulwintikajalu, pinirrijakungkamarra. Jilanyaluya kanyilpayi, puu wulikajalu, jirntu jarrpanyjangka. Puu kujupaluya kanyilpayi kutuwartirnikutu. Palunyajanu puu kujupaluya kanyilpayi jirntu pakanyjangka. Puu kujupaluya kanyinma karrpuwarti. Puu kujupaluya kanyilpayi jirntu jarrpanyjangka. Jilanyaluya Piija wiltulu kanyilpayi. Juwukajaluya ngalangu mayi Pajuwupa wiyarrinyjangka, maajalu kulirnu Piija katira ngarajunkura. ");
INSERT INTO mpj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piija jiilja nyinanyjanja Jiijajmili walyjakajaluya Mamangkaluya wulu wangkapayi, Piijaya mitu pungkujaku. ");
INSERT INTO mpj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","7","Piija mungajarrarrinyja kunyala ngarripayi, jantulwinti kujarrangka, kutungka, jiin kujarrakurlu. Kiitungka yawujayiti, kujarra kujupapula jantulwinti ngarapayi. Palunyangka mungangka maaja Yirutju kulilpayi, yungunjarrarrinyja Piijaya katira maaja Juwukajangka ngarajunkura. Munga palunyangka Mamalu yiyarnu wikarru, yanu rantara ngarapayi jiilja. Wikarru jiilu yanu Piija ngurnti pampurnuka kanarnu. Kara wajarnu, “Pakala!” Pakarnu ngaranyjangka jiinpa kujarralu marajanu wupulyanuka parnangka punkarnu. ");
INSERT INTO mpj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ka yarrarnu wajarnu, “Marra nanpangku yilpijula! Marra jakapiringkalu jarrpa!” Palunyangka Piijalungku manu nanpajunu, kalu jakapiringka jarrpangu. Kara wajarnu, “Kuurtungkalu jarrpa, yarrarni!” ");
INSERT INTO mpj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piijalu palunyanga wikarrungkangalu wanarnu, ka ngurinyjirrikatipayi, kapukurril kukalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Yankulapula jantulwintinga nyakula junkutikatipayi. Wululu-jananyapula nyakula junkutikatipayi. Yanupula kiitukutu, jiinya kiitungara walyja wupunarringu. Yanupula ruutuwatirringuka ngarapayi, ruutu jiinga tawunkutu maa yanu. Ruutu jiiwanapula yanu, ka Piija junu yanu, Mamamili wikarrulunga. ");
INSERT INTO mpj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piijalu kulirnu, “Mirtarna kapukurrirnin, Mamamili wikarrulurni yilta walajunu yiyarnu, Mamalura wajanyjangka. Walajunurni Yirutjurni pungkujaku, Juwukajalulurrju.” ");
INSERT INTO mpj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Piijalu yikira purtu kulirnukayila, yumurringukayila Miiriku mayakutu yanu. Miirira yipi nyinapayi, Jaan Maakku. Palunyangkangaya mayangkanga Jiijajmili walyjakajaraya nyinapayi, Mamangkaluya wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piijalu yanu tuwuwati pungkupayi. Palunyangkayila wanti Ruuta kulirnuka pakarnu yanu, tuungka ngarapayi. Ruutanga wanti jiinga palunyangka mayangka warrkamurripayi. ");
INSERT INTO mpj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Palunyangka Piijaku wangka kulirnuka-jananya marlaku pinirringu, karlkingka jakurljunu, tuwu wupuntamulparnilu. Wajarnu-jananya, “Piija yawujayiti ngarinpa!” ");
INSERT INTO mpj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Paki kararnuya, wantikuraya wajarnu, “Ngakumpayurulun paki kulirnin.” Kayila-jananya wiltulu wajarnu, “Yilta jii ngarinpa.” Karaya wajarnu, “Piijayuru, kujupa Mamamili wikarru, ngarinpa.” ");
INSERT INTO mpj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Palunyangka Piijalu wululu tuwunga pungama. Yumurringukaraya tuwu wupuntamunu. Nyangukaya kuru pakarnu. Nyangukaluya kujungkarringu. ");
INSERT INTO mpj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kayila-jananya maralu marrkurnu, yakaya ngararaku. Jakurljunu-jananya jiilja nyinanyjanjanu, Mamamili wikarrulu walajunu yiyarnu. “Yiltarni walajunu yiyarnu, Mamalu ngarnawarrapurlukalu.” Yarrarnu-jananya wajarnu, “Yarraya-jananya jakurljula!, Jayimijjakamu Jiijajmili walyjakajangka, ngayurni Mamalu walajunkunyjajanu.” Jilanya-jananya Piijalu wajarnu, kayila pakarnu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yungun pakanyjangka, pakarnuraya purtu kulirnu, jantulwintikajalu. ");
INSERT INTO mpj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yirutjaluya jakurljunkunyjangka, kulirnuka-janampa wajarnu, “Yarraraya parra ngurrila!” Palunyajanuraya Piijaku purtu ngurrilpayi. Yirutju-jananya kujungkanu purtu japilpayi. Ka wajarnu-janampa palumili warrkamupurlukakajangka, “Jiikaja-jananya jantulwintikaja, mitu pungkura!” Palunyajanu maajanga Yirutpanga tawun Jijariyakutu tiwa yanu, wulu nyinapayi, parna Juutiyanga junu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Palunyajanu-janampa Yirutpa maaja nyinangu wirrilyirringu, Taayamartajiku, Jayitanmartajikulurrju. Wirrilyirringu-janampa, ka-jananya mayi mirta yungkupayi. Kaluya maajakaja jiimartaji yanu maaja Pulajajja wangkangu. Maaja Pulajajpa jii Yirutmili mayakura warrkamupurluka nyinapayi. Maaja Pulajajparaya yanu jilanyalu japirnu, “Yarra-lampajura maaja Yirutpa japila!” Yuwajunuka-jananya jarrpajunu. Kaluya yanu maaja Yirutja wangkangu, “Kunyjunyu-lajungku wulu nyinaku. Mayikulajura purtu kulirnin.” Yirutju kulirnuka-janampa wajarnu, “Ngula karrpu kujupangkarna-nyurranya wajalku.” ");
INSERT INTO mpj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Palunya tayimurrinyjanga maaja Yirutpangalu kuut palyangka jarrpangu. Murrarniluya maaja majukajanga kuut palyangka jarrpapayi, jiiyangka palyangkalurrjuya, nyinapayi, wangka majuya wajalkuraku. Maaja Yirutpanga jarrpanguka nyinanguka-jananya wangkangu, martukajaya laltukuyarra kujungkarrinyjangka. ");
INSERT INTO mpj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Martukajaluya Yirutmili wangka kulirnu wiltulu wajarnu, “Mirta martunga nyininpa, yilta Mama ngarnawarrapurluka yuti nyininpa. Yilta Mama ngarnawarrapurluka-langku wangkin.” ");
INSERT INTO mpj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Palunyajanu Mamamili wikarrulu Yirutpanga ngarntamanu, jumaji-jananya mirta marrkurnu. Wajalngara-janampa “Mirtarna ngayu Mama ngarnawarrapurluka, paki.” Palunyajanuyila ngarnta maju ngarripayi, wilyjiwilyji, ka miturringu. ");
INSERT INTO mpj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Palunyajanuya martukajalunga Mamamili wangka kulirnuka, laltukuyarraya Jiijajmili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Panapajjukamupula Juulju parra wajalpayi, Mamamili wangka, kapula tawun Jarujalum junu yanu. Kayilipula yanu tawun Yantiyukakarti. Jaan Maakpapula manu katingu. ");
INSERT INTO mpj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jiijajmili walyjakajaya Yantiyukangka nyinapayi. Karlkiya Mamamili wangka jakurlpurluka nyinapayi. Karlkin kujupaya Mamamili nintipurlukaya nyinapayi, Mamamili wangka-jananyaya nintilpayi. Nintipurlukaya jiikaja, nyinapayi, yini Panapaj, Jimiyan. Jimiyan jii wajalpayiya yini kujupa, ‘Maru’. Karlki kujupangaya yini Lujiyaja jii Jarinimartaji, Juul, Manayin. Jiingara julyju maaja Yirutkura warrkamurripayi. ");
INSERT INTO mpj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jiijajmili walyjakajalungaya Mama nyinara marninypungkupayi, mayi ngalkunyjaparnilu. Palunya tayimu Mamamili Kurrurnju-jananya wajarnu, jilanya, “Yiyalaya-pulanya!, ngayuku warrkamupula parra nintilku, Panapajjupula Juulju. Ngayulurna-pulanya witurnin, ngayumili wangkapula parra nintilkuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Palunyajanuluya wituka Mamangka wangkapayi, mayiparni. Palunyajanuya-pulanya mara junu, kaluya Mamangka wangkangu, kayilaya-pulanya yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Mamamili Kurrurnju-pulanya nintirnu Panapajkamu Juulpa, kayilaya yanu tawun Jalijiyakarti, Jaan Maakpalurrju. Jiingkaya tawunja puutungka tatirnu, yanuya parna Jayipurijkarti. Yanuya tiputingu tawun Jalamijja. Jaan Maakju-pulanya ngampurrju parra wanalpayi. Yanuya jarrpangu jaajingka, Juwumilingka, ka-jananyapula nintilpayi, Mamamili wangka. Palunyajanuya jaaji laltuwana parra wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Parna Japurijpa kalyungka kutungka ngarapayi. Parna palunyawanaya kutuwana yankuraka jarrpangu, tawun Paapujja. Yirna yalyjirrpa jiingka nyinapayi, yini Pajijaj, yini kujupaya wajalpayi, ‘Yilimaj’. Julyju yirna palunyalu-jananya yalyjirrju kujupa kujupa jiimartajingka, nintilpayi. Jilanyalu-jananya pakiwana wajalpayi, “Ngayungarnara Mamamili wangka jakurlpurluka.” Palunga Juwu nyinapayi. Yanuluya kujungkarringu, Juulmapu. ");
INSERT INTO mpj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yirnanga jiingara miirti nyinapayi, maaja majuku jiimartajiku, yini Jajajpulajaku. Jiinga Jajajpulajpa nintipuka nyinapayi. Jiilu-pulampa wajarnu Panapajkamu Juulku yankurakupula, palunyamili mayakarti, Mamamili wangka-pulanya kulilkura. Palunyalunga wangka-pulanya Mamamili kulirnuka pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Palunyangka Pajijajju kulirnuka marrkurnu, maaja jiimartaji Jajajpulajpa, kulira-pulampa junkura. ");
INSERT INTO mpj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Palunyangkalu Mamamili Kurrurnpa jarrpanguka murlpirrmanu Juulpa. Yini kujupaya wajalpayi, ‘Puulpa’. ");
INSERT INTO mpj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Puulju warrkirnuka kuru wajarnu Pajijajpa. Jilanyara wajarnu, “Nyuntun malpukurnu, jungan mirta nyininpa. Wulun walyku nyinin, yalyjirrjun walykuwiyaju palyarnin. Mirtan Mamamiliwana wangkin, walyjalun kuliraka wangkinpa. Mamamili wangkan kuliraka kujupakartirnin. ");
INSERT INTO mpj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kuwarrinta pampurulku Mamalu, nyakunyjaparnin nyinamalpa karrpuparaku.” Palunyajanu yilta pampururringu. Parra-jananya martukaja japilpayi, parraya winitiranku. ");
INSERT INTO mpj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Maaja Jajajpulajju nyangu kuru pampururrinyja, Jiijajkurnu wangkayila kulirnuka walyjarringu. Puulmili wangka julyjujanu kulirnuka pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Puulmapuya tawun jiingka puutungkaya tatirnuka yanu, parna Pampiliyakarti, tawun Paakakarti. Jiingkanga-pulanya Jaan Maakju junu yanuka marlaku yanu, Jarujalumkarti. ");
INSERT INTO mpj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Palunyajanupula parna Pijitiyakarti yanu, tawun Yantiyukakarti. Jiingkangapula karrpu Jarritingka Juwukurnu jaajingka jarrpangu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jaajiku maajakajaluya riitamulpayi, Muujajku wangka. Palunyajanuya wangka kujupa riitamulpayi, Mamamili wangka jakurlpurlukalu julyju wakanyjajanu. Jiikajaluya-pulanya wikarru yiyarnu japilkura. Jilanyaya japirnu, “Walyjalu-lanyajunpula mayiti Mamamili wangka nintilku? Mayitintapula julyju Mamalu nintinyjajanu.” ");
INSERT INTO mpj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Puulju-jananya pakarnu maralu marrkurnu, yakaya nyinaraku. Nintilpayi-jananya jilanyalu, “Ngayunku walyjakajaluya Juwukajalu kulila!, karlkinjulurrju Mamamili walyjakajalu, Juwuparnikajalu. ");
INSERT INTO mpj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","18","Juwukajaku-lampa Mama ngarnawarrapurluka maju, maaja nyinin, Yijurilmili marlajanukajaku. Ngayunku mitunyjanirrikuwiyaju-janampa wajarnu, palunyaku walyjakajaraya nyinaraku. Jiikuraya walyjakaja lalturringu, jumaji-jananya Mamalu ngampurrju kanyilpayi, parna Yijipingka. Mama jiilu-jananya maparn majulu walyjakaja walarnu katingu, kalyuparniwana, pujimanwana. Rawalu-jananya katipayi, puuti yiiya. Nyarrurringuka-jananya ngampurrju katipayi, yankularaya jurtarrikatipayi, Mamaku. ");
INSERT INTO mpj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","“Palunyajanuya parna Kayinanja jarrpangu. Palunyamartajiya ngurra japan wulikajangka jaalpu jaalpu nyinapayi. Parna jiimartaji-jananya Mamalu pungkura wiyarnu. Ka-jananya ngurra jiingka palumili walyjakaja junu, parna palunyangkangaya nyinangu walyjarringu. Rawaya nyinapayi, puu yantartan pipiti yiiya. ");
INSERT INTO mpj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Palunyajanu-janampa maajakaja junkupayi, Mamalu. Maaja-janampa nyinara wiyarripayi. Palunyangka kujupa junkupayi. Jilanyartukaya nyinapayi, maaja yarnnga. Maajakaja nyinaraya, maaja Jamiyul tayimurringu. Jiinga Mamamili wangka jakurlpurluka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Mitunyjanirrikajaluya japirnu Jamiyulpa, maaja kujupa-janampa kiingu nyinara. Palunyajanu-janampa Mamalu junu yini Juulpa, maaja maju-janampa wulu nyinangu, puuti yiiya. Juulpanga jiinga nyinapayi, Kiijaku kaja. Kiijamapungaya nyinapayi Pinjaminkurnu marlajanukaja. ");
INSERT INTO mpj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Juulpanga payirnu yiyarnuka maaja kujupa junu, yini Tayipitpa. Mamalu wajarnu jilanya, ‘Tayipitpanga yilta kunyjunyu nyininpa. Ngayulurnara pukurlarrinpa, Jiijiyiku kajaku. Ngayulurna wajanyjangka yirnilu palyarnin.’ ");
INSERT INTO mpj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jiijajpanga yilta mitunyjarripurlukakura Tayipitku marlajanu nyinapayi. Mamalu-lampa Jiijajpanga junu, wankalkura-langku, Yijurilmili marlajanukaja. Wankalkura-langku julyju-lanya Mamalu jamartapungu, Jiijajpa-lampa yiyalkura. ");
INSERT INTO mpj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Julyju-jananya Jaanju Yijurilmili marlajanukaja nintilpayi, Jiijajpanga marlawana yankurarni. Jilanya Jaanju-jananya nintilpayi, walykuwintikajalungaya walyku junkurakaya junga Mamaku nyinara. Kaya kalyungka jarrpara palyarrira palya nyinaku. ");
INSERT INTO mpj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","“Jaanju-jananya wululu nintilpayi. Palunyajanu maaja kujupalu kulirnu jiilja mankura jarrpajunkura. Palunyangka Jaanju-jananya martukaja jilanya nintilpayi, ‘Nganarninyurra ngayu kulirni? Kurayijpa-lampa julyju jamartapungu maaja-lampa yiyalkurarni. Mirtarna ngayu maaja Kurayijpa, paki. Kurayijpa-lampa jii yankurni, maaja majuminyirri, karnara ngayu palumili warrkamupurluka.’” ");
INSERT INTO mpj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Puulju-jananya wituka wajarnu, “Walyjararranjuya kulila! Yipurammili walyjakajala nyininpa. Wulikajaluya kulila!, karlki kujupalulurrju, Juwuparnikajalu, Mamamili walyjakajalu. Wulikajaku-lampa wangka kunyjunyu yiyarnu Mamalu, ngayunpala wankarrira. ");
INSERT INTO mpj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jarujalumumartaji martukajakamu maajakajaraya ngurrpa nyinapayi, Kurayijku, martukaja-langku wankalku. Mamamili wangka jakurlpurlukaluya julyju wakarnu, Kurayijpa yankurni. Jarriti kujupa Jarriti kujupaluya Jarujalummapulu purtuya kulilpayi, wangka palunyanga, riitamunyjanjanu. Jiikajaluya wajarnuraya Jiijajpaya mitu pungkura. Wangka palunyanga yiltarringu, Jiijajpa miturrinyjangka. ");
INSERT INTO mpj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Purturaya kulirnu Jiijajpaya mitu pungkuraku. Mirta putamanu, wiya. Manngarripayiraya Jiijajpaya pungkuraku, Payilatparaya muunpungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Mitunyjarrikajalukamu Mamamili wangka jakurlpurlukaluya kulirnuka julyju wakara wanarnu, Jiijajpaya mankura wartangka wiltijunku. Wangka palunyawananga yiltarringu. Yiltaluya Jiijajpanga wiltijunu miturntanu. Palunyajanuya wartajanu tipujunu katingu pirnkingka ngarrijunu. ");
INSERT INTO mpj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Palunyajanu Mamalu palunyanga wankarnu. ");
INSERT INTO mpj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Palunyajanuluya palunyamilikajalunga karrpuparakungka nyakupayi, wanka parra yankunyjan. Julyjuya Jiijajmili walyjakajaya Jiijajjaluya kujungkarringulu yanu Jarujalumkarti, parna Kaliliyajanu. Palunyakajaluya-jananya kuwarrilu parlparri parra wajarnin, Jiijajmili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ngayunjulaju-nyurranya jakurljuninpa wangka kunyjunyu Mamamili. Mama ngarnawarrapurlukalu-jananya julyju mitunyjanirringka jamartapungu, Kurayijpa mitujanu wankalkura. ");
INSERT INTO mpj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","“Kuwarri Mamalu jilanyalu Jiijajpa yilta wankarnu, mitujanu. Jilanyalu julyju, mitunyjarripurlukalu Tayipitju Mamamili wangka wakarnu. Turlku laltu wakarnu. Nampa tuungka ngarrin jilanya. ‘Nyuntungan ngayuku kaja nyinin. Kuwarrirnanta maaja maju junu, martukajangka mirangka.’” ");
INSERT INTO mpj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Puulju-jananya wituka nintilpayi, “Yarrarnu-jananya wajarnu Mamalu, Jiijaj Kurayijpa mitujanu wankalku, mitu ngarrira kawu yurnarrijaku. Jilanya julyju wajarnu, ‘Ngayulurnangku jungalu palyalku, Maaja Tayipitkurnara ngayulu jungalu julyju palyarnu, palunyayuru.’ ");
INSERT INTO mpj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tayipitjulu wangka kujupa wajarnu, Mamangka. Jilanyalu wajarnu, ‘Mirta nyuntulu junku, nyuntumili warrkamupurluka, mitu ngarrira yurnarrijaku.’” ");
INSERT INTO mpj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Puulju-janampa wituka wajarnu, “Mitu Tayipit palunyangara Mamaku junga nyinangu, miturringu. Palunyangaya katingu mitunyjanirri karlkinjaya-jananya tuunyjunu. Mitu yilta yurnarringu. ");
INSERT INTO mpj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Martu kujupa mitujanu Mamalu wankarnu, mirta ngarringu yurnarringu. Martu palunyanga Jiijajpa, Mamalu wankarnu, mitujanu. ");
INSERT INTO mpj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Kulilaya walyjakajalu! Jiijajpa-lampa kuju nyininpa. Jiijajjuwiyaju-lampalura walyku mankula wirrupunginpa. Palunyangkalaju-nyurranya wangka palya kuwarri wajarnin, Jiijajjuwiyaju-langku wankalku. Julyju-janampa Muujajju Mamaku luwu wakarnu. Jilanya-lampa Muujajku luwu ngarinpa. Martu walykuwintilu kuka mirtayirti mankura pungkura, kara Mama yungkura, ngarnawarrapurluka. Jilanyaya julyju Mama yungkupayi, palujanuya wulu walykuwinti nyinapayi. Yiipi martulu Muujajmili luwu wanalku, wulu walykuwinti nyinaku. Ka yiipi Jiijajmili wangka kulilkuka Jiijajjura walyku wirrupungku.” ");
INSERT INTO mpj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Puulju-jananya wituka wajarnu, “Purrkaluya kulila!, jilanyarrijakunyurra. Mamamili wangka jakurlpurlukalu julyju jilanya wajarnu, ");
INSERT INTO mpj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Karlkinjuluyurra Mama ngarnawarrapurluka jankani. Kulilaya! Purtu kulilkunyurra nyinaku miturriku. Ngayulurna-nyurrampa yalyjirrju kujupa kujupa ngapirninpa, kuwarri. Nyakuranyurra purtu kulilku. Palunyangka-nyurranya martu kujupalu purrkalu kujupa kujupa nintijunku, palunyangkaranyurra purtu kulilku, wululu.’” Kulirnuya yakarringu, jiimartajilu. ");
INSERT INTO mpj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Palunyajanupula wangkangu wiyarringu, Juwukurnu jaajingka. Palunyangkaya-pulanya martu karlkilu japirnu, Jarriti kujupangkapula marlakurrira, wangka palunyayuru-jananyapula nintilkura. ");
INSERT INTO mpj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Laltu kujupangaya yanu ngurra walyjakarti, karlki kujupaluya-pulanya wanarnu. Wanaraya kulilkura Mamamili wangka, jiikajangaya Juwukajakamu Juwuparni. Juwuparnikajangaya Mamakuraya walyja nyinapayi. Palunyakajangka-jananyapula wajarnu, “Wuluraya junga nyinama!, palulu-nyurranya Mamalu ngampurrju kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Palunyajanuya Jarriti kujupangka martu laltukuyarra kujungkarripayi, Mamamili wangkaya kulilkura. ");
INSERT INTO mpj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Martu laltukuya-janampa Juwukaja nyangu wirrilyirringu, jumajiya mirta martukajaya-jananya kujungkarripayi Juwukajangka. Kaya-pulampa Puulkukamu Panapajku mikurringu. Palunyajanuya Puulpa warrkirnuka pinyijunu. ");
INSERT INTO mpj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Junkuparnipula wulu wangkapayi, jilanyapula, “Juwukajaluya kulila! Mamalu-linyaju nintirnu Juwukajaliju-nyurranya kurranyilu nintilkura. Mirtanyurra jungalu kulirni, kuliranyurra junin, palujanu mirtanyurra wanka wulu nyinaku Mamamili ngurrangka. Palunyajanu juninpaliju-nyurranya. Yankuliju-jananya Juwuparniwana, parra nintilmal. ");
INSERT INTO mpj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“Mamalu-linyaju julyju wangka yungu. Jilanya nyininpa, ‘Yintarnurnanta manu, nintilkuran-jananya martu yarnngakuyarra, wankalkuran-jananya, Juwuparnikaja. Mungajarraya martulu tili nyakuka kujungkarrikuluya. Palunyayuru tiliyurun-janampa nyinaku. Nyuntungkantaya kujungkarrira ngayumili wangka kulilkuka wankarriku.’” ");
INSERT INTO mpj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wangka jilanyaya kulirnuka pukurlarringu, Juwuparnikaja, kaya Mama ngarnawarrapurluka marninypungama, Juwuparnilurrju-jananya wankalkura. Laltuluya Jiijajmili wangka kulirnukaya Jiijajmilikaja yarnngarringu. Jiinga Jiijajmilikajanga julyjungulyu-janampa wangka junu, Mama ngarnawarralu. ");
INSERT INTO mpj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Palunyajanuya martukajalunga Mamamili wangka kulirnuka, laltukuyarraya Jiijajmili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tawun jiingka Yantiyukangka Juwu karlkinjuya-jananya maaja jiimartaji muunpungu, Puulkukamu Panapajku wirrilyiya-pulampa nyinara. Jiingkangaya maaja Juwukaja yirnakajakamu Juwuparnikaja, wantikaja nyinapayi. Jiikajalungaya wantikajalunga Mama marninypungkupayi, Juwuyurulu. Palunyangka jii maajakajalungaya-jananya muunpungu martu karlkinjuya-pulanya yiyalkura, parna kujupakarti, Puulkamu Panapaj. ");
INSERT INTO mpj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Yanupula tawun yitiwanalu jakapiri yarrarnuka, wiilypungu. Murrarniluya Juwukajalu jilanyarninpa, martukajaya-jananya jankanyjangka. Palunyajanupula tawun Yakuniyamkarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jiijajku walyjakaja, Yantiyukamartajiya pukurlarringu nyinapayi, Mamamili Kurrurnpa-jananya jarrpanyjangka ");
INSERT INTO mpj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tawun Yakuniyamjapula yanu jarrpangu, Juwuku jaajingka, Puulkamu Panapaj. Jii kujarralu-jananyapula wangka Jiijajmili nintilpayi. Wangkaya kulirnu Jiijajmili kaya walyjarringu yarnnga, Juwukajakamu Juwuparnikaja. ");
INSERT INTO mpj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Jiiku wangkakuya Juwu karlkinpa wirrilyirringu, kaya-jananya yanu muunpungkupayi wirrilyilu, Juwuparnikajangka. Palunyajanu jiikaja Juwuparnikaja-janampaya wirrilyirringu, Puulkukamu Panapajku, Jiijajmili walyjakajakulurrju. ");
INSERT INTO mpj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ngurluparnilupula wululu nintilpayi, tawunja palungka, Mamamili wangkapula murlpirrju wajalpayi. Mamalu-pulanya nintirnu yalyjirrju kujupa kujupapula ngapilkura. Martu jiimartajiluya karlkilu kulirnu jilanya, “Yalyjirr kujupa kujupa-lanyajupula nintirni. Yiltapula Mamaku wangka wajarnin. Yilta-lampa Mama nyarru nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jiimartajiluya purtu kulirnu, karlkiya Puulkukamu Panapajku pukurlarringu, karlkinpaya Juwukurnuku wangkaku pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Palunyajanuya Juwu karlkikamu Juwuparni karlki kujungkarringu yaka wangkangu, pungkuraku-pulanyaya yiyalkuraku purliwintilu, Puulkamu Panapaj. ");
INSERT INTO mpj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Wangka jiipula kulirnu wala yanu tawun Lijarakarti. Jiingka kinti tawun Taapi nyininpa. Tawun palunya kujarrapula parna Lakuniyangka nyinin. Ngurra jiiwanapula parra wajalpayi, Jiijajmili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tawun Lijarangka yirna mukuntu nyinapayi, jinangu wiya yankupayi. Palunya yirna mukuntu julyju nyinapayi, japuwartajanu. ");
INSERT INTO mpj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Puulpa wangkapayi palunyangka mukuntulu kulilpayi. Puulju palunya nyakupayi mukuntu kulirnu, “Mamamili wangka kulirninpa. Yilta Mamalu kuwarri wankalku.” ");
INSERT INTO mpj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Palunyangka Puuljura wiltulu wajarnu, mukuntuku, “Pakala yiki!” Palunyajanu pakarnu pipurru, parra yankupayi. ");
INSERT INTO mpj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jinangka parra yankupayi palunyangkaya laltulu nyanguka wiltulu wajarnu, Lakuniya wangkawintilu “Yiltapula jii kujarra ngarnkajanu yankupayi, palu kujarra, yini Jiyajakamu Yamijpa. Marturringupula ngarinpa.” ");
INSERT INTO mpj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Lakuniyamartajiluya laltulu marninypungkupayi, Mamayuru kujarra. Yini jilanyaya marninypungkupayi Jiyajakamu Yamijpa. Kulilpayiya, “Jii kujarrapula ngarnkajanu.” Panapajpaya nyangu ka yini wajarnu, ‘Jiyaja’. Ka Puulpaya nyangu ka yini ‘Yamijpa’ wajarnu. Jilanyaya wajarnu Puulpa Yamijyuru wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jaaji, Jiyajaku tawunja yitingka ngarapayi. Yatilypa jiimartajilu pulukukaja kangu jaaji jiikarti, pungkura marninypungkuraku-pulanya Puulkamu Panapaj, puritipulawakajalurrju kangu. Katingu pulukukaja ngarajunu kiitungka jaajja, martuluya pungkuraku, yarnngalu. ");
INSERT INTO mpj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Martu kujupalu-pulanya yanu jakurljunu, “Jaajingkaya pulukukaja kuwarri pungku, nyuntu kujarrantayapula marninypungkuraku, jumajipulan ngarnkajanu.” Martukajapula wala pinirringu marrkurnu, jaartangkupula yarrpungkupayi. Juwukajalu jilanya murrarni jaarta yarrpungkupayi, martu karlkilu pakiwana kulinyjangka, martukajaluya nyakura junkuraku, pakiwanaya marninypungkujaku. Jilanya-jananyapula Puuljukamu Panapajju wajarnu, ");
INSERT INTO mpj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nganangkamarranyurra puluku pungkukija? Mirta-linyajuyan marninypuwa!, martuliju nyuntunyuru. Yanuliju-nyurranya ngaakutu wajalkijalu wangka Mamamili kunyjunyu. Wajarninpaliju-nyurranya Jiyaja, Yamijkamu junkura, marninypungkuparnilu. Jurraya minyjilypa!, Mama ngarnawarrapurlukawiyajunyurra marninypungkura. Jii maparnpa maju nyininpa, Mamalu jiilu ngarnka, parna kalyu ngapirnu. ");
INSERT INTO mpj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","17","“Julyju-jananya Mamalu marrkulparni junkupayi, Mamakuraya yumu nyinara, martukaja. Mama jiilu-nyurrampa kalyu yiyalpayi, palunyajanu yukuri pakarni, mirrka wartangka. Palunyalu-nyurranya mirrka yunginpa pukurlpanyurra nyinara. Mama jilanya-nyurrampa nyininpa. Mama julyjunyurra kulilngara, parnakamu kalyu nyangu. Yiltalu-nyurranya ngampurrju kanyirnin.” ");
INSERT INTO mpj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jilanyapula rawa wangkangu, mirtaya puluku pungkura, palunyangkaya junu. ");
INSERT INTO mpj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Palunyangkaya Lijarangka Juwu karlkinpaya kuwarriwiyaju yanu nyinapayi, tawun Yantiyukamartaji. Kujupakajalurrjuya kuwarriwiyaju yanu nyinapayi, tawun Yakuniyammartaji. Tawun palunya Yantiyuka, parna Pijitiyangka ngarapayi. Jiikajalu-jananyaya Lijaramapu martukaja wirrilyimanu, Puulku, yarnngaluya Puulpa purliwintilu yungkalpayi. Palunya parnangka punkarnuka ngarripayi, mituyuru. Mitu kararnuya Puulpa yilatingu katingu, tawunja yitingka wirrupungu, kaya junu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jampa Puulpa ngarripayi, Jiijajmili walyjakajaya kujungkarringu. Palunyajanu Puulpanga pakarnu yanu tawunkarti. Yungunjarrarrinyjangapula Puulkamu Panapaj yanu ngaparti tawun Taapikutu. ");
INSERT INTO mpj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Yanu-jananyapula Jiijajmili wangka kunyjunyu nintilpayi, karaya martu lalturringuraya kulirnu nyinangu, Jiijajku. Palunyajanupula marlaku yanu yapurra, tawun Lijarakarti. Nyinangupula yumurringupula kayili yanu tawun Yakuniyamkarti. Jiingkapula nyinangu yapurrarringupula yanu tawun Yantiyukakarti. ");
INSERT INTO mpj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ngurra jiiwana Jiijajmili walyjakaja-jananyapula murlpirrmankupayi, Jiijajkuraya junga nyinaraku. Jilanyalu-jananyapula nintilpayi, “Mamalu-jananya palumilikajanga ngampurrju kanyirni. Palunyakajangkala-jananya kujungkarriku nyinaku, Mamakulara wulu junga nyinaku. Jiinju karlkinju-langkuya jankanyjanja, jungalara wulu nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Parna jiiwana-jananyapula yirnakaja junkura wanarnu, ngampurrju-jananya Jiijajmilikaja kanyilkuranku. Tawun kujupangka-jananyapula junkupayi yupalpa, Tawun kujupangka yupalpa junkupayi. Wululu-jananyapula jilanyalungulyu junkupayi, yirnakaja. Tawun kujungka-jananyapula yirna junkukijalu mayi ngalkuparnilu kujungkarriraluya Mamangka wangkapayi. Jilanyalupula wangkapayi, “Mama! Kulininpalaju Nyuntumili walyjakaja-lanyajun kanyirnin. Ngampurrju ngaakaja-jananya yirnakaja kanyila!” ");
INSERT INTO mpj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Palunyajanupula yanu ngaparti parna Pijitiyawana tawun Paakangka warinykatingu. Tawun palunyanga parna Pampiliyangka nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jiijajmili wangkapula wajarnu, kapula tawun Yatilayakarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Palunyajanupula puutungka tatirnuka kakarra marlaku yanu, tawun Yantiyukakarti, tawun jiingkangapula julyju nyinapayi. Jiingkanga tawunjanga Jiijajmili walyjakajaluya, Mamaya-pulampalura japirnu. Yiltalupula Mamamili warrkamu palyarnu wiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Yantiyukangkapula warinykatingu-jananyapula kujungkarnu, ka jakurljunkupayi, Jiijajmilikajangka, Mamalu-pulanya ngampurrju kanyilpayi. Jilanyapula jakurljulpayi Mamalu-jananya martukajangka yalyjirrju ngapilpayi. Jilanya-jananyapula wajalpayi, “Mamalu-linyaju nintirnu wanyjaljuliju-janampa Juwuparnikajaku yiwarra wupuntamunu, Jiijajkuya kulirakaya walyjarrira.” ");
INSERT INTO mpj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wulu-jananyapula nyinapayi, tawun jiingka, Jiijajmili walyjakajangka. ");
INSERT INTO mpj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Karlkinpaya Jiijajmili walyjakaja tawun Yantiyukakarti yanu, parna Juutiyajanu. Warinykatinguya-jananya nintilpayi, Jiijajmili walyjakaja jilanya, “Mitunyjarripurlukalu-lampa Muujajju wajarnu, murtilyakamu yirnakaja-jananyanyurra yirnamalkura. Yirnamankunyjaparninga mirta Mamalu wankalku.” ");
INSERT INTO mpj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wangka palunyajanu Puulkamu Panapaj-janampapula wirrilyirringu, ka-jananyapula ngaparrju wajarnu, “Mirta-jananyanyurra Jiijajmili walyjakaja yirnamalkura.” Palunyangkaya-pulampa wajarnu yankuraya Jarujalumkarti kujungkarrira wangkara japilkurapula-jananya, martu karlkinjaya-jananya Yantiyukamartajingka, yankuraya Jiijajmili jakurlpurlukakajangka wangkara, japilkura-jananyapula yirna jiimartajingkalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Palujanuya-jananya Yantiyukamartaji kujungkarringu, Jiijajmili walyjakajaya-jananya yiyarnu ngarran kujupa Jarujalumkarti. Puulkamu Panapajjaya-pulanya yanu. Parna Panijiyawanaya yanu parna Jamiriyakutu. Yanuya-jananya maa jakurljunkutikatipayi, “Kaya parna jiiwana Jiijajmili walyjarringu, lalturringu Juwuparnikaja.” Jiijajmilikajaya-janampa kulirnuka pukurlarringu, parna jiiwana. Yanuya tawun Jarujalumungka warinykatingu. ");
INSERT INTO mpj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Puulmalu-janampaya nyangu pukurlarringu, Jiijajmilikaja, palunyamili jakurlpurlukakajakamu yirnakajalurrju. Puulmapulu-jananyaya jakurljunu, Juwuparnikajaya yarnnga Jiijajmili walyjarringu, Mamalu-jananya maparn majulu martukaja wankarnu, kujupa kujupa-janampa palyarnu. Jilanyalu-jananyaya jakurljunu. ");
INSERT INTO mpj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jiijajmili walyjakajalu karlkinjuya-janampa pakarnu wajarnu, Parajikajalu, “Juwuparnikaja-jananyanyurra jiikaja yirnamalku. Wajalkura-jananyanyurra Muujajku luwukuraya junga nyinaraku.” ");
INSERT INTO mpj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Palunyangkaya Jiijajmili jakurlpurlukakajakamu yirnakaja kujungkarringu wangkangu. ");
INSERT INTO mpj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wululu-ngkuya ngaparrku paanypungkupayi. Palunyajanu Piijalu-jananya pakarnu wajarnu, “Walyjakajalurniya kulila! Julyjurni Mamalu yintarnu manu, yankurarna-jananya nintilkura, Juwuparnikaja, Jiijajmili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mama-janampa pukurlarringu, jumajiya Jiijajmili wangka kulirnuka walyjarringu. Yilta Mamanga-lampa ngayunku laltukuyarraku ninti nyininpa. Yilta-janampa pukurlarringu-jananya palunyamili Kurrurnpanga jarrpajunu. Ngayunja-langku julyju jarrpajunu, palunyayuru. Palujanurna kulini, Mama-janampa pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mamanga-janampa layikamurrira nyininpa, Juwuparnikajaku, ngayunkuyuru-lampa. Walyku-janampalura yiltalu wirrupunginpa, Jiijajmili wangkaya yiltalu kulirnin. ");
INSERT INTO mpj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Palunyangka, nganaku Mamaranyurra yajirninpa? Mirtaya Juwuparnikaja Juwuyuru nyinaku, Muujajku luwukuraya yumu nyinaku, mirtaya Juwuyuru nyininpa. Mitunyjanirrikajaluraya purtu kulirnu, Muujajmiliku luwuku jungaraya nyinaraku, ngayunjulurrjulara purtu kulirnin. ");
INSERT INTO mpj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wangka palunyawananyurra mirta kulinma!, maaja Jiijajpa-lampa wulu wulikajaku kunyjunyu-lampa nyininpa, Juwuparnikajaku, Juwukulurrju. Wulikajalula kulira walyjarrinpalara, wulikaja-lanya jiilu wankarninpa.” ");
INSERT INTO mpj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Palunyajanulu-jananyapula Puuljukamu Panapajju pakarnu jakurljunkupayi, Juwuparnikajaluya Jiijajpa kulirnu walyjarringuraya, Mamalu-pulanya maparn majulu murlpirrmanu yalyjirrju kujupa kujupapula ngapilkura, nyakulaya kulilkura. Jilanya-jananyapula jakurljunkupayi, palunyangkaluya yakalu kulira nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Palunyajanupula nyinatingu. Jayimijpa kujupa pakarnu, wangkangu, “Walyjakajaluya kulila! ");
INSERT INTO mpj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jayimunju kuwarri-langku nintirnu, kurranyilu Juwuparnikaja Mamalu-jananya kulirnu, kuwarrilu-jananya ngampurrju manu kujungkanu, palunyamili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wangka palunyayuru julyjujanu ngarrinpa. Mamamili wangka jakurlpurlukalu jilanya wakarnu, ");
INSERT INTO mpj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ngulamparna-jananya marlakurriku, ngampurrju wumulku kanyilku, mitunyjarripurlukamilikaja Tayipitmilikaja. Tayipitja martu marlajanu maajarna-janampa parna parlparriku nyinajunku. ");
INSERT INTO mpj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Palunyangkayilajuya Juwuparnikaja martu laltukuyarrarriku, ngayuku walyjarriku, kujungkarrikurniya. Julyjurna-jananya kulilpayi ngayuku walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Jilanyarna julyjurna-janampa ngayulu Mamalu wangka junu.’” ");
INSERT INTO mpj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jayimijju wituka-janampa wajarnu, “Mamamili wangka palunyala kulirnu, Mama-janampa Juwuparniku pukurlarrini, yiltaya Mama kulini. Palunyajanurna-janampa ngayulu kulirni, Mirtala-janampa putamanku, mirtala-janampa wajalku, Juwukurnu luwungkaya nyinaraku, jiikaja Juwuparnikaja. ");
INSERT INTO mpj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mirlimirlingkala-janampa luwu yupalwiyaju wakalku, jilanya. Juwuparnikajaluya murrarniraya mayikamu kuka mirtayirti katiraluya yungkupayi Mamayurungka. Palunyajanuluya mankura ngurrangka katira ngalkupayi. Mirtaya Juwuparnikajalu mayikamu kuka jilanyalu ngalkunma!. Nyupa walyjakurluwiyajuya ngarrima!. Kukaya pungkula miji yintilku wiyalku. Palunyayururaya ngalkunma! Kukakurnu mijiya mirta jikilku. Wangka jiikajawiyajuya kulilkukaraya junga Mamaku nyinaku, jumaji jilanyartuka Muujajku wangka nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Juwukajalula jilanya Muujajmili wangka riitamurninpa. Muujajkurnu wangkaya jilanyartuka riitamulpayi, Jarriti kujupa Jarriti, parna parlparriwanalu, Juwukurnu jaajikajangka. Muujajkurnu wangkalurrjuya parra wajalpayi, tawun kujupa tawun kujupawana. Palunyangkaya Juwuparnikajaraya walyja nyinaku Muujajku luwukuwiyaju, yupalku.” ");
INSERT INTO mpj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Miiting palunyangkaya-janampa kulirnu pukurlarringu, Jiijajmilikaja, jakurlpurlukakajakamu yirnakaja. Kulirnuya karlkiya-jananya yiyalkija, Yantiyukakarti. Puulkamu Panapajkamungkaya-pulanya yumurringuya-pulanya manu Juutajkamu Jayilaj. Juutajpa jii yini kujupaya wajalpayi, ‘Paajapaj’. Jii kujarrakuya-pulampa rawa pukurlpa nyinapayi, jiimartaji, Jiijajmili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mirlimirliya-pulanya wakarnu yungu yiyarnu. Mirlimirlingkaya jilanya wakarnu, “Mirlimirlilaju-nyurrampa ngaa yiyarni, Jiijajmili jakurlpurlukakajalukamu yirnakajalu. Ngayunpalaju-nyurrampa walyjakaja nyininpa. Jiijajmili walyjakajakulaju-nyurrampa pukurlarrinpa, Juwuparnikajaku. Ngurra parlparriwananyurra nyininpa, ngurra Yantiyukangka, parna Jiriyawana, parna Jilijiyawanalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jakurlpalaju kulirnu, parna ngaamartajilu-nyurranyaya karlkilu yanu pakiwana wajarnu. Palunyajanunyurra juni walykurringu. Ngayunjulaju-jananya mirta yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","Palunyangkalaju wangkangu martu kujarralaju-pulanya yiyarnu, maa yankula-nyurranyapula wangkaraku, Juutajjukamu Jayilajju-nyurranyapula wangka mirlimirlingka ngaajanu jakurljunku. Kujungkaya-pulanya yanku Puulkamu Panapajja. Layikamurriralaju-pulampa nyinin, Puulkukamu Panapajku. Wululupula jii kujarralunga maaja Jiijajmili wangka parra wajalpayi, jampaya-pulanya pungkukijarripayi. ");
INSERT INTO mpj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Mamamili Kurrurnwintilulaju kulirninpa junganyurra nyinaraku, Muujajkurnu luwuku yupalkuwiyaju. Luwu-nyurrampa yupalpa jilanya nyinin. ");
INSERT INTO mpj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Murrarniluya mayikamu kuka mirtayirti katiraluya yungkupayi, Mamayurungka. Palunyajanuluya mankura ngurrangka katira ngalkupayi. Mirtanyurra mayikamu kuka jilanyalu ngalkunma! Kukakurnu mijinyurra mirta jikilku. Kuka pungkula miji yintilkunyurra wiyalku! Jilanyayururaya ngalkunma! Nyupa walyjakurluwiyajunyurra ngarrima! Wangka jiikajakuwiyajunyurra junga nyinaku, kanyurra Jiijajmili walyjakaja kunyjunyu nyinaku. Kulilkunyurra yiltalaju-nyurrampa pukurlarrin.” ");
INSERT INTO mpj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jakurlwintiya-jananya yiyarnu. Kayiliya yanu tawun Yantiyukangka kujungkanuya-jananya Jiijajmili walyjakaja, kaya-jananya mirlimirli yungu. ");
INSERT INTO mpj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mirlimirli jiiya riitamunu pukurlarringu, wangka palya junga ngarringu. ");
INSERT INTO mpj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yantiyukangka laltu-jananyapula wululu nintirnu, pukurlmanu, Juutajjukamu Jayilajju. Jii kujarrangapula Mamamili wangka jakurlpurlukapula nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Rawa-jananyapula nyinangu, kapula marlaku yankukija. Wajarnuya-pulanya jiimartajilu, “Yankunpula ngampurrpa, Mamaluntapula katinpa.” Yanupula marlaku ngaparti, Jarujalumkarti. ");
INSERT INTO mpj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Puulkamupula Panapaj wulu nyinapayi, Yantiyukangka. Kujungkaluya-jananya Mamamili wangka nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ngulampa Puulju Panapajku wajarnu, “Yankurali Jiijajmilimapukarti, julyjuli-jananya tawun jiiwana parra nintilpayi. Yankuli-jananya wangka kulilku, wanyjalpaya nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Panapajju kulilpayi Jaan Maakpa katiraku. ");
INSERT INTO mpj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ka Puulju marrkurnu, “Jurra!, jumaji-lingku julyju junu yanu parna Pampiliyangka. Kujungkalula-jananya nintilngaranpa.” ");
INSERT INTO mpj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ngaparrpungku-langkupula wajarnu jaalpurringupula yanu. Panapajju Jaan Maakpa katingu. Puutjapula tatirnu yanu yapurra, parna Jayipurijkarti. ");
INSERT INTO mpj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Puulju manu Jayilaj. Jiijajmili walyjakajaluya Mama ngarnawarrapurlukaraya japirnu, ngampurrju-pulanya katira. ");
INSERT INTO mpj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Puulkamupula kayili yanu parna Jiriyawana. Palunyajanupula parna Jilijiyawana yankupayi. Parna jiiwanalupula-jananya Jiijajmilikaja nintira murlpirrmankutikatipayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Puulkamupula yapurra yanu tawun Taapikutu, kapula yanu tawun Lijarakutu. Tawun Lijarangka, Timiti nyinapayi, Jiijajmili walyja. Timitimili yipinga nyinangu Juwu, Jiijajmili walyja. Palunyamili mamanga kiriki wangkawinti nyinangu. ");
INSERT INTO mpj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timitikuraya pukurlarrira nyinapayi tawun Lijaramartajikamu tawun Yakuniyammartaji, Jiijajmili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Puulju Timiti kulirnu katiraku, kujungkalu-jananyaya parra wajalkuranku. Kayila katikijalu yirnamarnu, Juwukajaya jiiwana wirrilyirrijaku. Juwu jiiwanaluya kulilpayi Timitiku, mamangara Kiriki wangkawinti, Juwuparni. ");
INSERT INTO mpj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Palunyajanuya tawun laltuwana parra nintilpayi-jananyaya, Jiijajmili walyjakajangka. Nintilpayi-jananyaya luwu yupalpa, mirlimirlingkaya-janampa kurranyi yiyanyjajanu, Jarujalumumartajilu, Jiijajmili jakurlpurlukalukamu yirnakajalu. Wajalpayi-jananyaya jungaya nyinaraku, luwu jiikajaku. ");
INSERT INTO mpj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Palunyajanuya Jiijajmilikaja lalturringu, parna jiiwana. Karrpu kujupangka karrpu kujupangkaya-jananya karlki kujupa walyjarripayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Puulmapuya yanu kayili parna Purijiyawana. Parna jiiwana Jiijajmili wangka-jananyapula parra wajalpayi, parna Kilijiyawanalurrju. Mamamili Kuurtilu-pulanya marrkurnu, mirtapula-jananya parna Yayijawana nintilkura. ");
INSERT INTO mpj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Parna Majiyangka yitiwanapula yanu. Purtupula yanu jarrpangu parna Pijiniyangka, Jiijajmili Kuurtilu-pulanya ngampapungu. ");
INSERT INTO mpj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Palunyajanupula parna Majiyangka yitiwana yapurrakarti yanu tawun Turuwajangka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mungajarra Puulju kapukurrinu nyangu, yirna ngarapayi, Majatuniyamartaji. Wajarnura Puulku, “Yarrarni-lampaju ngayunmili ngurrakarti!, parna Majatuniyakarti, nintilkura-lanyaju.” ");
INSERT INTO mpj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Puulju palunyanga kapukurrilu nyanguka, raatirringulaju, jumaji-lanyaju Mamalu wajarnu yankuralaju-jananya nintilkura, Jiijajmili wangka kunyjunyu. Ngayurna-pulanya Luukpa kujungkarringu Puuljakamu Jayilajja. ");
INSERT INTO mpj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Puutjalaju tatirnuka junga yapurra yanu parna Jamujarikarti. Palunyajanulaju karrpu kujupangka yanu puutja tawun Niyapulajakarti, puutjanulaju tiputingu. ");
INSERT INTO mpj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Palunyajanulaju jinangu kayili yanu tawun Pilipayikarti. Jiinga tawununga jantulwintikajalu palyarnu, julyju, Ruumanmartajikajalu. Tawun jiinga majuminyirri ngarapayi, tawun jiikajangkamarrangka-janampalura majuminyirri. Jiingkangalaju karrpuparaku nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jarritingkalaju yanu tawunja yitiwana. Kulirnulaju, “Mayitiya murrarni Juwukaja yankupayi palunyakartinga karrukarti, Mamangkaluya wangkakura.” Yanulaju-jananya nyangu karrungkanga wantikaja. Yanulaju-jananya nyinanguka wangkapayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Palunyakajangka-jananya wanti kuju nyinapayi, yini Litiya, Jayatayamartaji, Mamakura walyja nyinapayi. Palunyalunga kuluj maru-jananya jalamulkupayi. Jiilunga wantilunga Puulkurnu wangka kulirnuka Jiijajmili walyjarringu, jumaji Mamaku Kuurtilulu nintirnu. ");
INSERT INTO mpj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Palunyajanuya-jananya Litiyamapu kalyungka jarrpajunu, palunyamili walyja karlkilurrju. Palunyajanu-lanyaju Litiyalu marrkurnu. Jilanya-lampaju wajarnu, “Kuwarrirna ngayulu yiltalu Jiijajpa kulirnin, ngayumili mayangkaya yarra nyinama!” Jilanyalu-lanyaju marrkurnu, yanuyilalaju nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Palunyajanulaju yankukija ngurra palukarti, karrukarti. Mamangkalaju wangkakija, kutungka-lanyaju warinykatingu, wanti malpuwinti, maajakajaku-janampa warrkamupurluka. Wantingkalu malpu nyinanyjajanungka palunyangka-janampa wajalkatipayi ngulampanga yiltarriku. Wantiya jii parra katira nyinajunkupayi, martukajalu wantimili wangka kulira manira yungkuraku. Palujanu jiilu-jananya wantilu mani karlkinja mankura yungkuran maajakaja. ");
INSERT INTO mpj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Puulmapungka-lanyaju wanalpayi, wantilunga wajalkatipayi, “Ngaakajaya Mama ngarnawarrapurlukaku warrkamupurluka, maparn majukuraya. Wajalkatinpa-nyurranyaya wanyjalpanyurra wankarriku, Mamakuranyurra walyjarriku.” ");
INSERT INTO mpj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jilanyalu-jananya wanara wajalkatipayi, karrpu kujupa karrpu. Palunyangka Puulpara wirrilyirriraka pijirringu wajarnura, “Jiijajmiliwintilurnanta maparnwintilu wajarninpa. Pakalalura yarra!” Palunyajanu pipurrulura malpunga pakarnu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","20","Wanti jiinga palyarringu nyinapayi. Palunyangkaraya maajakajalunga purtu kulilpayi, wanyjaljuya mani mankuran. Puulju wankanyjangka yumurringuraya wirrilyirringu. Palunyajanuya-pulanya Puulkamu Jayilaj winirnu katingu, maajakajakarti. Tawunja kutungkaya-pulanya katingu ngarajunu, kuutja. Tawunja kutungkaya murrarni mayinga payamunkupayi parlkarrangkaya-pulanya jiiwati ngarajunu. Kaya-jananya kuutpurlukangka wajarnu, “Ngaa kujarrangapula Juwu kujarra, ngaamartaji-jananyapula jaarramurnin. ");
INSERT INTO mpj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ngaa kujarralu-lanyajupula marrkurninpa luwula Ruummili junkura, luwu kujupawintila nyinara. Ngaangkangala Ruumanmapu nyinin.” ");
INSERT INTO mpj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Martu laltuya-pulampa wirrilyirringukaya-pulanya warrkira pungkupayi. Kaya-pulampa kulujkaja yarrpungu wirrupungu, kuutpurlukakajalu. Kaya-janampa karlki kujupaku wajarnu wartawintiluya-pulanya yungkalku, Puulkamu Jayilaj. ");
INSERT INTO mpj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wululuya-pulanya yungkarnu katingu Jiilja jarrpajunu. Jiilku maajangkaluya wajarnu ngampurrju-pulanya kanyilkura. ");
INSERT INTO mpj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Jilanyaluya wajanyjangka palunyajanuyila-pulanya katingu Jiilja kutungka nyinajunu, pakarapula yankujaku. Palunyajanu-pulanya jina kujarra, karrpirnu witurrpungu junu. ");
INSERT INTO mpj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kutuwatirnipula Puuljukamu Jayilaj Mamangkalupula wangkara yinkalpayi, Mamapula marninypungkupayi. Jiiljaya laltu kujupa nyinanyjanjuya-pulanya kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Palunyangka parnakamu maya yurriyurringu, palunyangka mayangka jiingka tuwukaja wupunarringu. Martukajangka-jananya yarnngangka jinajanukamu marajanu jiinkaja wupulyanu. ");
INSERT INTO mpj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jiilku maajayila kanarringu pakarnu nyangu tuwukaja wupunpa. Kulirnuyila ngurlurringu, “Jiiljanukajaya yilta pakarnu yanu, ngayukurnulu maajalurni mitu pungku.” Palunyajanuyila palunyamili nayipu warlpukurru yilarnukangku wakalkijarringu. ");
INSERT INTO mpj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Palunyajanu Puuljulu wiltulu wajarnu, “Jurrangku!, ngaalaju wamumpu nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Maaja palunyalu tili manuka, pinirringu-pulanya murti pupatinguka, tititipungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yitiwana-pulanya winirnu katingu-pulanya japirnu, “Mamalurni wankalkura, wanyjalmankurna?” ");
INSERT INTO mpj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wajarnurapula, “Kulila! Maaja Jiijajkuran junga nyinaku, palunyajanuyilan wankarriku. Jiijajpayilaya kulilkuka, nyuntumili walyjakajalurrju wankarriku.” ");
INSERT INTO mpj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Palunyajanuyila-jananyapula Jiijajmili wangka nintilpayi, Jiilku maajangka, palunyamili walyjakajangkalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Palunyajanu-pulanya maajalu katingu ngarnta pantimulpayi. Palunyajanu-jananyapula mungajarra Puulju kalyungka jarrpajunu ");
INSERT INTO mpj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Maajaluya-pulanya Puulkamu Jayilaj manu katingu mayangka jarrpajunu, kaya-pulanya mayi yungu. Ngalangukaya pukurlarringu, jumajiya kuwarri Jiijajmili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yungunjarrarrinyja kuutpurlukaluya-jananya ngalyikarrpilkaja wajarnu yiyarnu jiilkarti, yankuraya-pulanya yiyalkura. Kaluya wajarnu jiilku maajangka, jii kujarra-pulanya yiyalku. ");
INSERT INTO mpj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jiilku maajalu Puulkura wajarnu, “Pakalapula yarra! Kuutpurlukakajalurniya wajarnu, ‘Kunyjunyupula pakala yarra!’ Mamaluntapula ngampurrju katiku.” ");
INSERT INTO mpj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ka-janampa Puulju wajarnu, ngalyikarrpilkajaku, “Paki. Kuutpurlukalu-linyajuya yankurni yiyalku, mirta-linyajuya yakalu yiyalkura. Yankurni-linyajuya martu laltungka kurungka yiyalku, jumaji-linyajuya wartawintilu yungkarnu jarrpajunu. Mirtaliju putamanu, paki, ngayu kujarrangaliju Ruumanmartaji nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Palunyajanuya-jananya marlaku yanu wangka jakurljunu, kuutpurlukakajangka. Kuutpurlukakajaluya kulirnuka ngurlurringu, jumajipula Ruumanmartaji kujarra. ");
INSERT INTO mpj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Palunyajanuya kuutpurlukakajaya yanu jiilkutu, kaluya Puulja wangkangu, “Yungkalparnilulajuntapula junkungara, pakiwanalulajuntapula yungkalpayi.” Palunyajanuya-pulanya yiyarnu, kaya-pulampa purrkarringu wajarnu tawunpa palunyapula junkuraka yankura. ");
INSERT INTO mpj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Yumurringupula yanu Litiyaku mayakarti, jiingkaya mayangkanga Jiijajmilikaja nyinapayi. Wangkangu-jananyapula murlpirrmanu junukapula yanu. ");
INSERT INTO mpj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Puulkamupula Jayilaj yulparirra yanu tawun Yampipulijawana. Kapula yanu tawun Yapuluniyangka warinykatingu. Palunyajanupula wulu yapurra yanu tawun Jijaluniyangka warinykatingu. Jiingkapula yanu Juwukurnu jaajingka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Puulpanga murrarni yankula jarrpapayi, Juwukurnu jaajingka, tawun kujupangka. Jurripalangka Jarritingka-jananya Puulju wululu Mamamili wangka nintilpayi, kaya ngaparrpa japilpayiya. ");
INSERT INTO mpj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jilanyalu-jananya nintilpayi, “Mamamilingka wangka jilanya ngarrinpa. Kurayijpanga yiltaya pungku. Ngarrikuka yilta marlaku wankarriku.” Wituka-jananya Puulju jilanyalu nintilpayi, “Ngayulurna-nyurranya nintirnin martu kujupa, palu yini Jiijajpa, yilta Kurayijpanga nyininpa, Mamalu julyju jamartapungu kurtingkuraku.” ");
INSERT INTO mpj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juwu karlkinjuya Puulkurnu wangka kulirnuka Jiijajmili walyjarringu, kiriki wangkawintilurrju, jiikajangaya Mamaku walyjaraya julyju nyinapayi. Maaja wantikajalurrjuluya kulirnuka Jiijajmili walyjarringu. Martukaja yarnngaya-pulanya kujungkarripayi Puuljakamu Jayilajja. ");
INSERT INTO mpj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Palunyangkaya-janampa Juwu karlkinpa wirrilyirringu, Jiijajmili walyjakajaku. Jurtarringuya-janampa kujungkarnu karlki kujupa, martu walykukaja. Palunyajanuya-jananya jiimartaji wirrilyinu. Jayijanku mayangkaya-pulanya kulirnu kukurripayipula Puulkamu Jayilaj. Palunyangkaya yurnturnu tuwu wupuntamunu jarrparaya-pulanya mankuraku. Kulirnuya, mankulaya-pulanya katira kuutja ngarajunkura. ");
INSERT INTO mpj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Puulkukamu-pulampaya purtu ngurrirnu yumurringuya-jananya Jiijajmili karlki kujupa manu, Jayijanlurrju. Manuya-jananya katingu tawunku maajakajangka ngarajunu. Ngarajunukaya-janampa wajarnu, “Jayijanju-pulanya ngaalu kanyilpayi mayangka Puulkamu Jayilaj. Jiilu kujarra-jananyapula martu yarnnga jaarramulpayi, tawun kujupawana tawun kujupawana. Kuwarripula ngayunkurnu tawunkarti yanurni. Ngaakajaya maaja Yukajajku luwuku parlanypa nyininpa. Jilanyaya wajarni, ‘Maaja kujupa-lampa nyininpa Jiijajpa.’” ");
INSERT INTO mpj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Palunyajanuya-jananya wangkangu jiimartaji jaarramurnu, martukaja, maajakajalurrju. Warrkilpayi-ngkuya. ");
INSERT INTO mpj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Maaja kuutpurlukaluya-jananya maniku japirnu, Jayijanmapu. Mani manuka-jananya wajarnu, “Puulkamu Jayilajpula kukurringu, mirtapula yanu. Palu kujarrapula yankunyjangkalaju-nyurranya mani marlaku yungku.” Palunyajanu-jananyaya yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mungajarraya-pulanya junu yanu, Puulkamu Jayilaj, Jiijajmili walyjakajalu, Juwukajangkamarra. Ngapartipula yanu tawun Puriyakarti. Puriyangkapula warinykatinguka yanu Juwuku jaajingka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Puriyamartajiya palya nyinapayi. Mamaku wangkakuraya kulira pukurlarripayi, mirtaraya parlanypa nyinapayi, Jijaluniyamartajiyuru. Karrpuparakuya karrpu Mamamili wangka riitamura nyinapayi. Puuljukamu Jayilajju-jananya Mamaku wangka nintilpayi, kayilaya ngurrirnu nyangu mirlimirlingka Puulju-jananya wajanyjajanungka. Kulirnuya, “Mayiti-lanyangku wiyawana wajarnin.” Palujanuya mirlimirlingka nyangu. ");
INSERT INTO mpj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Palunyajanuya jiimartajilu Jiijajmili wangka kulirnuka walyjarringu, Juwukaja, Kiriki wangkawintikajalurrju, jiinpaya karlkinpa wantikaja maajakaja. ");
INSERT INTO mpj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Puulju-jananya Mamamili wangka tawun Puriyangka nintilpayi. Jijaluniyamartajiluya Juwukajalu jakurlpa kulirnuka yanuya Puriyakarti. Yanuya-jananya wirrilyinu Puulkukamu Jayilajku. ");
INSERT INTO mpj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Palunyajanuya Puriyamartajilu Puulpa wajarnu yiyarnu, Jiijajmili walyjakajalu, pungkujakuya, tawunkutu kalyungka yirrirringka. Jayilajkamupula Timiti tawun Puriyangka wulu nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Puriyamartajikajaluya Puulpa walarnu katingu yulparirra tawun Yajankarti. Puulju-jananya marlaku wajarnu yiyarnu, Jayilajjakamuya-pulanya Timitingka jakurljunkura. Jilanya-janampa wajarnu, “Yarrarnipula walayuru tawun Yajankarti!” Kaya-pulampa marlaku yanu Puriyakutu. ");
INSERT INTO mpj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Puulpa-pulampa majalpayi tawun Yajanja. Wulu-jananya Puulju nyinara nyakupayi, Mamayuruya laltu ngarajunkupayi, marninypungkuraku. Jiimartajiluya-jananya laltu marninypungkupayi. Jumajiya Mama ngarnawarrapurlukaku ngurrpa, Puulju-jananya nyangu, nyarrurringu-janampa. ");
INSERT INTO mpj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Palunyajanu Juwuku jaajikutu yanu-jananya wangkapayi. Nintilpayi-jananya Jiijajmili wangka, Juwukajangkakamu Juwuparnikajangka, kaya marlaku japilpayi. Jiiya Juwuparnikajaya Mamakuraya walyja nyinapayi. Tawunja kutungkalurrju-jananya wajalpayi, Jiijajmili wangka. Puulju-jananya nyurilu wajalpayi, jampaya jiiwana karrujunkupayi, karlkiluraya japilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Karlkiluya mitunyjarripurlukamili wangka nintilpayi, Yipikurujkurnu. Jiinjuya Puulpa warrkilpayi, karlkinjulurrju Juwikaku wangka-nintikajalu. Jilanya-ngkuya japirnu, “Ngana wajarni, pakikaja?” Karlkinjuya wajarnu, “Mama kujupala marninypunkuraku wangkinpa, mirta mamakaja-lampa ngarnkajanu-lampa wangkinpa, paki.” Jilanyaya wangkapayi Puulju-jananya wajalpayi Jiijajpa mitujanu wankarringu. ");
INSERT INTO mpj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Palunyangkaya katingu Puulpa kanjulkutu. Murrarniya kujungkarripayi yapu palungka wangka kujupa kulilkuraku. Karaya wajarnu, “Wajala-lanyaju wangka palunya! Nganan wangka wajalpayi? ");
INSERT INTO mpj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kuwarrilaju wangka palunya kulirnu, wangka kujupa kujupa. Nintila-lanyaju wangka palunya!” ");
INSERT INTO mpj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Yajanjamartajiya kujungkarripayi, kaya pukurlarripayiya wangka kujupaya kulilkuraku. Murrarniya kujungkarripayi wangka kujupa kujupaya wajaraka kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kanjulukajangka-jananya Puulju ngaranguka wajarnu jilanya, “Martukajalurniya kulila!, ngaamartajilu ngurralu. Ngayulurna tawunja ngaawanalu nyakupayi, Mama kujupayurunyurra marninypunkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mama kujupayurunyurra purlijanu ngapira marninypunkupayi. Kujurna nyangu mama kujupa, yiniparni. Purli jiinya wakarnunyurra jilanya, ‘Purli ngaanyanyurra nyakura mama kujupa kulirni, yiniparni.’” Puulju-jananya yarrarnu wajarnu, “Mamayuru palunya yiniparni nintilkurna-nyurranya. Palunyakurayan ngurrpa, marninypunkurayan. ");
INSERT INTO mpj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mama palunyalu parnakamu ngarnka, kalyukamu martulurrju ngapirnu. Mirta palunya jaajingka nyininpakamu purlingka, paki, palunga yilta murlpirrminyirri nyininpa, parnakukamu ngarnkakulurrju, maaja. ");
INSERT INTO mpj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mirtalara Mama ngapira parnajanu yunginpa, paki, palunyalu ngaanya parna ngapirnu. Mirrkakamu kukalurrju-lanya yunginpa, ka wanka kanyini-lanya. ");
INSERT INTO mpj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Palunyalu yirna kuju ngapirnu, palunyajanuya martuya laltu yarnngarringu. Martuya laltu wangka kujupa kujupa-jananya ngapirnu, nyinajunu parlparri. Mamalu-jananya karlki parna kujupa kujupangka nyinajulpayi, ngurra walyjangka, warrarn kujupangka. Mamalu-janampa kurtingkuni kalyu tayimungka, palunyajanu-janampa yukuri pakarni, mirrka wartangka. Mamalu-janampa tayimpa kanyirni. ");
INSERT INTO mpj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mamalu-jananya jilanya mangarri yungkupayi, martukajaluya palunya kulilkura jilanya, ‘Yilta Mama ngarnawarrapurluka nyininpa, mangarri-lanya yunginpa. Yilta-lanya kulini, mirta-lampa yurtuyurtu nyininpa.’” Puulju-janampa yarrarnu wajarnu, “Mirta-lampa Mama yurtuyurtu nyinani, wirrirli, paki, ngamu-lanya nyinani, kulini-lanya. ");
INSERT INTO mpj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kujupalu julyju wajarnu, ‘Mama-lanya nyinani, palunyangkala wanka nyininpa.’ Nyuntunku-nyurrampa mirlimirlipurlukalu wajarnu jilanya, ‘Mamakulara jijikajayuru nyininpa.’ ");
INSERT INTO mpj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Mamalu-lanya ngarnawarrapurlukalu wanka nyinajunu, mirtala kulilkura palunya purlijanukamu kuulujanu, paki, mirtaya yalyjirrju ngapirnu mama purlijanukamu kuulujanu, wiya, paki. ");
INSERT INTO mpj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Julyjuya martukaja Mamakuraya ngarnawarrapurlukaku ngurrpa nyinapayi. Palunyangka-jananya Mamalu mirta pungkupayi, jampaya nyinapayi wuumurru, junkupayi-jananya. Kuwarri Mamalu-lanya nintirni parlparringka walykukajala junkura, kala Mamaku junga nyinara. ");
INSERT INTO mpj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mamalu-lanya ngula kuutja ngarajunku, walykukaja-jananya wajalku wiyalku. Kuutja jiingka Jiijajpa maaja nyinaku, Mamalu wajarnu. Palunyangka tayimja Jiijajju-jananya wajalku jungalu, walykukajangka. Julyju Mamalu maaja maju Jiijajpa wankarnu, mitujanu. Ngayunjulaju nintilu kulirni Mamalu palunya mitujanu wankarnu, ka maaja maju nyinajunu kuutja.” ");
INSERT INTO mpj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jilanyaya kulirnu Jiijajpa mitujanu wankarringu, karlkiya nyurni yikarringu. “Wiya, paki wajarni.” Karlki kujupaluya wajarnu Puulja, “Karrpu kujupangkalajunta kulilku.” ");
INSERT INTO mpj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Palunyangka-jananya Puulju junu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Karlkiluya wanarnu kaya kujungkarrira wangkamaya. Karlkiluya kulirnu Jiijajku wangka junga, jiingka kuju nyinapayi yini Tiyunijiyajpa, maaja palunyamartajiku, wantiyila yini Tamariyajpakamu martu karlkinpalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Palunyajanu Puulpa tawunpa Yajanjanu junu yanu, ka tawun Kurinyjikutu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ngurra jiingka nyanguka kujungkarringupula nyupararrapula, Juwu kujarra. Yirna palunya yini Yakuwila, Puntujmartaji, ka wanti palunya yini Pirijila. Palu kujarrapula parna Yitalijanu yankupayi, tawun Ruumjanu. Juwukajaya tawun palunya junu yanu, maaja Kulutiyajju-jananya wajarnu yiyarnu. ");
INSERT INTO mpj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Puulpa-pulanya yanu kujungkarringu nyinatingu, murrarniluya tiinpa kaliki ngapilpayi. Palunyajanupula nyinangu tiinpa ngapilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Palunyangka tawunja jaajingka Juwukurnungka Puulpa jarrpangu nintijulpayi-jananya. Wangkara warnipayi-ngkuya murrarni, Jarriti kujupangka Jarriti kujupangka. Jilanya-jananya Puulju nintilpayi, Juwukajangkakamu Juwuparnikajangka. ");
INSERT INTO mpj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Palunyangkapula yankupayi ngurra Majatuniyajanu, Jayilajkamu Timiti. Ka Puulju-jananya Juwukajangka nintilpayi karrpuparakungka karrpuparakungka. Nintijulpayi-jananya Jiijajpa yiltaminyirri Kurayijpa nyinani, Mamalu nyukurni jamartapungu yiyalkija. ");
INSERT INTO mpj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Puulpaya Juwukajalu wirrilyilu warrkirnu, palunyangka Puulju-jananya parna juturnu. Palunyangka jilanya-jananya Puulju wajarnu, “Nyamu! Ngayulurna-nyurranya junku yankuni. Palunyarnantaya nintijunkupayi jungalunyurra kulinngara, Mamalu-nyurranya ngula wajara kurtingku. Nyamu! Yankurna-jananya Juwuparnikaja nintijunku.” ");
INSERT INTO mpj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ka junu-jananya yanu Titiyaj Jajajku ngurrakutu nyinapayi. Yirna palu Juwuparni Mamaku walyja nyinapayi. Palumili maya Juwukurnu jaajingka kinti ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yirna kujupa tawunja jiingka nyinapayi, yini Kirijpaj, Juwukurnu jaajiku maaja nyinapayi. Yirna palunya Puulkurnu wangka kulirnu ka Jiijajku walyjarringu, palumili walyjakajalurrju. Jiimartajiya laltu kujupalu kulirnuka Jiijajku walyjarringu, kalyungkaya jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Palujanu mungajarrarringu ka Puulju kapukurrinu. Ka kulirnu Mamalu jilanya wajarnu, “Ngurluparni wulungulyu wangkama!, mirtan yakarri! Ngayu kujarrali kujungka ngaraku, pungkujakuntaya kujupalu. Ngaangkaya nyinani karlki kujupa, kaya kulilku wangka ngayumili ka walyjarriku.” ");
INSERT INTO mpj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Puulju-jananya wululu nintilpayi, Mamaku wangka wantajarra kujarrangkayuru. ");
INSERT INTO mpj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Puulpa ngurrangka palungka nyinapayi, maaja Kaliyu nyinapayi, palu tayimu. Kaliyu-janampa parna Yakayamartajiku maaja nyinapayi. Palujanuya Juwukajalu winirnu Puulpa katingu kuutkarti. Kuutku maajangkaluya jakurljunu jilanya, ");
INSERT INTO mpj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Yirna ngaalu-jananya marrkurni Juwukaja Muujajkurnu luwuya junkura, kaya Mama marninypunkuraku yiwarra kujupa kujupawana, Jiijajmili wangka.” ");
INSERT INTO mpj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Puulpa ngaparrpa wangkakijalu ka maaja Kaliyulu-jananya marrkurnu, Juwukaja jilanya, “Juwukajaluya kulila! Wangka jilanyayururna wiya kulirni, mirtarna wajalku. Mayitpi ngaalu ngulyulu mankujaku, mayitpi yirna kujupa pungkujaku, palunyangkarna ngayulu wajanngara, ngaa jiilkarti yankuraku. ");
INSERT INTO mpj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wirrilyirrinparanyurra ngaaku, jumaji wangka kujupa nintini. Nyuntukurnu luwu warlangkuninpa, palunyanyurra wirrilyirrinpa. Nyurrartinju-ngkuya palyamala!, ngayurna wiya, ngurrpa.” ");
INSERT INTO mpj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Maajalu kuutja-jananya warrkirnu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Palujanuya Juwukajalu yanu Jajiyanpa wirrilyilu winirnu, kaya kuutkutu katingu. Jajiyanpa jii Juwuku jaajiku maaja nyinapayi, kanguya kuutja yawujayiti pungkupayi, wartawintilu. Kaliyulu kulirnu junuka yumu nyinapayi, wiya-jananya marrkurnu. ");
INSERT INTO mpj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Palujanu Puulpa wulu nyinapayi, tawun palungka Kurinyjingka. Nyinanguka Jiijajmili walyjakaja-jananya junu yanu, kaya yanu tawunu Kinkiriyakutu, wulikaja Pirijilakamu Yakuwila. Yanuya tawun Kinkiriyakutu jarrpangu. Palunyangka Puuljungku kata katupungu. Murrarni-ngkuya katupungkuni Mamakuraya junga nyinaraku. ");
INSERT INTO mpj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Puutjaya tatirnu tawunu Yipajajkutu yanu tiputingu. Puulju-pulanya junu yanu ka Juwuku jaajingka yanu jarrpangu. Jaajingka Puulju-jananya wajalpayi Jiijajmili wangka Juwukajangka, kaya marlaku japilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","21","Wangkamaya wulu kaya palumartajilu Puulku wajarnu, “Ngayunja-lanyaju nyinama!” Palunyangka wajarnu, “Wiya, yaninparna. Mayitpirni Mamalu ngula wajalku kurtingku. Palunyangkarna ngayu marlakurriku.” Palunyangka Puulpa tatirnu puutungka ka tawun Jijariyakarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ka palungka tawunja tiputingu, ka Jiijajmili walyjakajangka-jananya kujungkarringu. Puulpa-jananya wangkangu ka tawun Yantiyukakarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wulu nyinangu ngurra palunyangka ka yanu parna Kilijiyawana, parna Purijiyawanalurrju. Tawunparakungka parra yankupayi, nintilpayi-jananya Jiijajmili walyjakaja murlpirrminyirriya wangkaraku, nyinarakulurrju. ");
INSERT INTO mpj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Palujanu yirna kuju Yapulujpa tawun Yipajajkutu yanu nyinangu, palunya Juwu nyinapayi, tawun Yalikijantaramartaji. Wangka kunyjunyu-jananya nintilpayi, nintipukalu. Mamakurnu wangkakura nintiminyirri nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Jaanju-jananya julyju kalyungka jarrpajunu ka nintirnu. Jaankurnu wangkakura ninti nyinapayi. Jiijajmili wangkalurrju-jananya jakurljulpayi, ngurrpa ngurrpalu, mirta kulirnu, Mamalu palumili Kuurti martukajangka jarrpajunkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yapulujju-jananya jaajingka murlpirrju nintilpayi, Juwukurnungka. Palunyangkapula Pirijilakamu Yakuwilalu kulirnu ka katingupula palumili ngurrakarti, nintirnu Jiijajmili wangka junga nintilkura. ");
INSERT INTO mpj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Yapulujpa jiingka nyinangu, ngurra Yakayakutu yankukija kulirnuka wangkangu. Palujanuya Jiijajmili walyjakaja pukurlarringu wajarnu, “Yuwa. Palyan yanku parna palukarti. Mirlimirli-lajungku wakalku, katiku-jananyan nintilku. Mirlimirlingkaya nyaku nyuntuku-ngkuya pukurlarriku.” Jilanyaraya wakarnu yungu. Ngurra palukarti yanu Yapuluj, ka-jananya nintijulpayi, Jiijajmili walyjakaja. Murlpirrmanu-jananya. Jiipurlukaya pukurlarringu kaya ngampurrju kanyilpayi, Jiijajmili walyjakajalu. Jiipurlukaya julyju walykuwinti nyinapayi, ka Mama-janampa nyarrurringu, ka kunyjunyu-janampa nyinapayi, palujanuya Jiijajmili wangka kulirnu. ");
INSERT INTO mpj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jiimartaji Juwukajangka-jananya Yapulujju nyurilu murlpirrju wajalpayi jilanya, “Jiijajpa yiltaminyirri Kurayijpa nyininpa, Mamalu julyju jamartapungu yiyalkija.” Purtuya kulirnu japilkijara, marlaku. ");
INSERT INTO mpj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Yapulujpa tawun Kurinyjingka nyinapayi. Palunyangka Puulpa yapuwana yanu, tawun Yipajajja jarrpangu. Puulju-jananya nyangu kujupakaja, Jiijajmili walyjakaja ka kujungkarringu-jananya. ");
INSERT INTO mpj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Japirnu-jananya, “Julyjunyurra Jiijajmili walyjarringu, kaji jarrpangu-nyurranya, Mamamili Kuurti?” Wajarnuluya, “Paki. Mamamili Kuurtikulajura ngurrpa, mirtalaju kulirnu.” ");
INSERT INTO mpj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Puulju-jananya japirnu, “Kajinyurra kalyungka jarrpangu?, Jiijajmili walyjarringu?” Wajarnuluya, “Jaanju-jananya kalyungka jarrpajunkupayi, palunyayuku-lanyajuya kalyungka jarrpajunkupayi.” ");
INSERT INTO mpj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Puulju-jananya wajarnu jilanya, “Jaanju wajarnu, ‘Walykuya jurraka junga nyina! Palunyangka kalyungkarna-nyurranya jarrpajunku.’ Yarrarnu-janampa wajarnu, Jaanju Yijurilmili marlajanukajaku jilanya, ‘Kujuparni marlakarti ngayungka yanku. Palunyanyurra nyakura ka kulilku yilta Mamamili.’” Palujanu Puulju-janampa wajarnu, palunya Jiijajpa julyjurni yanu. ");
INSERT INTO mpj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wangkaya jilanya kulirnuka wajarnuluya, “Jiijajpa-lampa yilta maaja nyininpa, jilanyalaju kulirninpa. Palunyangka-lanyaju kalyungka jarrpajula!” Palunyangkaya kalyungka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","7","Puulju-jananya maralu pampurnu wanarnu. Palunyangka Mamakurnu Kuurti-jananya jarrpangu, kaya wangkapayi, wangka kujupa kujupa. Mamakurnu wangkalurrjuya wajalpayi. Yirna tuwal wulikajaya nyinangu, wantikajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Puulpa Juwuku jaajingka yanu jarrpangu. Wululu-jananya murlpirrju nintilpayi, yupalja wirlarrangka. Jilanya-jananya wajalpayi kaya ngaparrju japilpayi. Nintilpayi-jananya, Mamalu-janampa ngampurrju kanyilkuraku, palumili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Karlkinjuya mirta kulirnu wangka Jiijajmili, parlanyarripayiya. Puulpaya nganarnpungu Jiijajmili wangkawinti, palujanu Puulju-jananya Jiijajmili walyjakaja katingu maya kujupakarti. Maya jiingka-jananya martulu yini Tayiranajalu julyju nintilpayi, palumili walyjakaja. Palungkaya mayangka Jiijajmili walyjakaja kujungkarripayi, karrpuparaku karrpu. Jiingkaya wangkama Jiijajkurnu wangka. Puulju-jananya wululu jiingka nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jiingkaya kujungkarringu nyinangu rawa, yiiya kujarrangka. Kayilapaya martukaja jiimartaji wangkaya kulilpayi Jiijajmili, kaya walyjarrima. Parna Yayijamartajiluya Juwukajalukamu Juwuparnilulurrju kulinma Jiijajmili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Palunyajanu Puulju kujupa kujupa yalyjirrju ngapilpayi, Mamamili maparnju. ");
INSERT INTO mpj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Palunyangka Puulmili yangkijikamu wara mankupayiya, kaya kangkura pampulpayi ngarntakaja, martukaja, kaya kunyjunyurripayi. Malpuwintikajaya kunyjunyurrima, yangkijiwintilu-jananyaya jampa pampulpayi. ");
INSERT INTO mpj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Karlkinpaya Juwukaja parra yankupayi, malpuwintikaja payira kurtingkura, maparnwintilu. Jilanyaya malpu payira kurtingkukijalu wajalpayi, “Ngayulurnanta payirni maparn Jiijajmililu. Pakala yarralura! Jilanya Puulju-jananya wajarni, kayila ngayulurnanta wajarni.” ");
INSERT INTO mpj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yatilypa maju Kiipalu japan wulikaja kaja kanyilpayi. Palu kajaparakuluya yankura malpukaja payira kurtingkupayi. Jilanyaya malpuwinti kujungkaluya wajarnu, “Ngayunjulajunta payirni maparn Jiijajmililu. Pakala yarralura!” ");
INSERT INTO mpj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Malpulu-janampa wajarnu, “Ngananyurra wajarni? Nintirna-pulampa Jiijajkukamu Puulku. Ngananyurra nyunturtinpa?” ");
INSERT INTO mpj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Martu palu malpuwintilu-jananya pakarnu kurtakaja pungku. Kulujkajalurrju-janampa warlangu kaya nikitpala pinirringu, mijikurlu. ");
INSERT INTO mpj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jilanya-jananya malpulu pungunyjangkaya kulirnu Yipajajmartaji ngurlurringu, Juwukajakamu Juwuparnikaja, kaya Jiijajpa kuju marninypungu. ");
INSERT INTO mpj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Karlkinjuya Jiijajmili walyjakajalu nyuwanju kulirnuya kaya jakurljunu Jiijajmili walyjakajangka, jumajiya walyku nyinapayi, kaya jungarringu. ");
INSERT INTO mpj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Karlkin kujupaluya mirlimirlikaja manu kaya kujungkanu kampangu warungka. Mirlimirli palunyaya kanyilpayi walyku, malpumili, martu kujupaya pungkupayi. Kaya tilirnu warungka, yarnngaluya kurulu nyangu. Mirlimirli palunyaya julyju payamunu mani majuwintilu, pipiti jawujun talawintilu. ");
INSERT INTO mpj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Palunyangkaya martumapukuyarraluya kulirnu kaya Jiijajmili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Palunyangka Puulju kulirnu tawun Jarujalumkarti yankukija, parna Majatuniyawana ka parna Yakayawanalurrju. Palunyalu-jananya jilanya wajarnu, “Jarujalumkuturna yanku, karna tawun Ruumkarti yanku.” ");
INSERT INTO mpj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Puulju-pulanya kurtingu walyja kujarra, Timitikamu Yirajajpa parna Majatuniyakarti, Jiijajmili wangka-jananya nintijulkura. Puulpa parna Yayijangka wulu nyinama, tawun Yipajajja. ");
INSERT INTO mpj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Palunyangkaya yarnnga kujupa wirrilyirringu Puulku, jumaji Jiijajmili wangka nintijulpayi. ");
INSERT INTO mpj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tawunja jiingka Yipajajja ngarapayi wanti Tayanaku jaaji. Ngururrpa jaajingka ngarapayi Tayana, Mamayuruya yankula marninypungkupayi, kuulujanuya ngapirnu. Palunyangka yirna kujulu yini Timitirijju ngapilpayi jaaji julikaja. Jaaji julikaja jiinya Tayanaku jaajiyuru ngapilpayi, jilpajanu. Martukajaluya jaaji julikaja palunya payamulaya kaya kati ngurra walyjangka marninypuwa. Yarnngaluya mankupayi mani maju, Timitirijmapulu, palumili warrkamupurlukakajalu. ");
INSERT INTO mpj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Karlki kujupaluya jilpangka warrkamurripayi, Timitirijju-janampa mirrangu kujungkanu, palumili warrkamupurlukalurrju. Wajarnu-jananya jilanya, “Yarnngaluya kulila! Ngayunpala jilpangka warrkamurrinpa. Jilpa palunyala jalamuninpa kala maju mani maninpa, jiikunyurra ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Martu yarnngangka-jananya Puulju wajarnu marrkurnu, ‘Wiyanyurra marninypuwa!, purli kuulujanukamu jilpajanu, Mamayuru.’ Yilta Puulju-janampa wajarnu, palunyangkaya martukajalu mirta payamulkuranpa, mani-lampa pakirriku. Martukajalu yarnngaluya kulirnuya Puulpa kaya mirta payamunkupayi, ngaamartajilu ka parna Yayijamartajilu. ");
INSERT INTO mpj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Martukajaluya mirta-lampaya payamunku jilpakaja ka yaalurrikula?, warrkamupa-lampa pakirriku. Yarnngaluya martukajalu Yayijamartajilu marninypunginpa Tayana ngarnkajanu, ka parna kujupalulurrjuya. Yaalurrikula? Tayana ngaa minyjilyarriku, palumili mayalurrju.” ");
INSERT INTO mpj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wangka jiinyaya kulirnu, kaya wirrilyirringu, ngarnkangka mirrapayi jilanya, “Tayana-lampajuku murlpirrpa, maparn maju yilta, Yipajajmartajiku.” ");
INSERT INTO mpj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Palujanu yanuya-jananya karlkinpa jaarramunu, wirrilyiwintilu, kaya yarnnga karlkinpa wirrilyirringu Yipajajmartaji. Puulku walyja kujarra-pulanyaya yanu winirnu Kiyajkamu Yarajakajpa, palunya kujarrapula parna Majatuniyamartaji. Yankupayilupula kujungka Puulja. Winirnu-pulanyaya katingu parlkarrakarti, murrarniya kujungkarrima, palungka. ");
INSERT INTO mpj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Puulju kulirnu yankura ka-jananya wangkara marrkulkura. Palunyangkaya Jiijajmili walyjakajalu marrkurnu, ka wajarnuya, “Mirta-jananya marrkula!, jurra!” ");
INSERT INTO mpj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Maaja karlkin kujupaluraya kurtingu mirlimirli, Puulmili walyjalu. Wajarnuraya mirta parlkarra palungka yutirrira, pungkujakungkamarraya. ");
INSERT INTO mpj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Parlkarrangka palungkaya kujungkarringu kaya mirrara-ngkuya warrkilpayi jurtalu. Karlkin kujupaluya purtu kulilpayi, “Nyaakuya mirraninpa?” ");
INSERT INTO mpj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juwukajaluraya wajarnu maaja Yalikijantaku yankura purantakutu. Palujanu karlkin kujupaluya kulirnu, “Mayiti jiilu-jananya maaja Yalikijantalu jaarramunu.” Palunyangka Yalikijantalu-jananya maralu marrkurnu, martukaja yakarrirakuya. Purtu-jananya marrkurnu. ");
INSERT INTO mpj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kaya yintarnu, “Jiinga maaja Yalikijanta Juwu ngarani.” Kaya wulungulyu wiltu mirrapayi, “Tayana-lampa kuju maparn majuminyirri, Yipajajmartajiku.” Jilanyaya mirrangu rawa puri yapurrakartijanu puri kakarrakartirringu, “Tayana-lampajuku murlpirrpa, maparn maju yilta, Yipajajmartajiku.” ");
INSERT INTO mpj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Palunyajanu-jananya tawunku maajalu-jananya yakamanu. Kaya yakarringu wajarnu-jananya, “Yipajajmartajiluya kulila! Martukaja wirrirlijanulurrjukamu ngaamartajilu nintirayan Tayanaku, maparn majuminyirri nyininpa, ngaangkala Tayanaku jaajpa ngampurrju kanyirni. Purli palunya punkarnu-lanya ngarnkajanu, palunyala ngampurrju kanyirni. Jilanyaya martu yarnngalu kulirni, nintilu. ");
INSERT INTO mpj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Karlkilu-langkuya purtu warrkilku, ngayunjula mirta paki kanyirni. Palunyangkanyurra wiya martukaja pungkuraku, jurraya! ");
INSERT INTO mpj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Palunyangkapula ngaa kujarralu mirta Tayana nganarnpungu, paki. Ngaa kujarralupula mirta Tayanaku wartakaja ngulyulu kangu, ngurrpapula. ");
INSERT INTO mpj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Palunyangka Timitirijmapuya yankura kuutja wangkaraku, mirta ngaangka. Kuutjaya yarra wangkama!, kuutpurlukangkaluya, kuwarringa yupunpa. ");
INSERT INTO mpj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mayitpinyurra wangka kujupa kulirninpa, wangkakija. Majalaya ngulaku miitingku yiltakumarta! ");
INSERT INTO mpj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Kuwarrila kujungkarringu warrkirnu-langku, palunyangka kapamanju-langku warrkiljaku, kuutja. Palunyangkala purtu kuliljaku ngaparrpa wangkakura. Jilanyangkamarra ngurrakutuya yarra!” ");
INSERT INTO mpj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Palunyajanu Puulju-jananya martukaja, Jiijajmili walyjakaja wangka kurtingu, yankuraya kujungkarrira. Kujungkanu-jananya ka Puulju wangkangu-jananya murlpirrmanu. Wangkangu-jananya junu yanu parna Majatuniyakijakarti. ");
INSERT INTO mpj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Parna paluwana yankura ka Jiijajmili walyjakaja-jananya wangkara murlpirrmankupayi, tawunpartu tawun kujupakaja. Palujanu parna Kirijikarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Parna palungka Puulpa nyinangu wirlarra yupalja. Puulju kulirnu puutja tatilkija, parna Jiriyakartiku. Palujanuya Juwu karlkinpa kujungkarringu jaalpu wangkapayi, Puulpaya pungkukijalu. Puulju jakurlpa kulirnu, pungkukijaya. Palunyangka jinangu yanu, marlaku parna Majatuniyawana. ");
INSERT INTO mpj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kujungkaya yanu Jupata Puriyamartaji, Pirajaku kaja. Karlkin kujupa yiniya Yarajakajpa, Tikuntaja tawun Jijaluniyamartaji, Kiyajpa tawun Taapimartaji, Timiti. Tijikajpula Turupimaj parna Yayijamartajipula. ");
INSERT INTO mpj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Jilanyaya yanu tawun Taruwajukutu, kaya Taruwajungkaya majarnu ngayurtinku. ");
INSERT INTO mpj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ngayurtinpalaju Luukpakamu Jiijajmili walyjakaja kujupa tawun Pilipayingka nyinapayi. Tawun palungkalaju Juwukurnungka turlkungka nyinapayi. Turlku palunyangka murrarniya Juwukajalu yinkalpayi, ka mirrkaya ngalkupayi, pikinpawutuparni, ka Mamaya marninypungkupayi. Turlku palungkalaju nyinangu ka puutungka tatirnu, tawun Pilipayilaju junu yanu. Puutjalaju payip karrpuparakungkalaju yanu tawun Taruwajungka warinykatingu. Kujungkarringulaju-jananya Puulmapungka kujungka wiikingkalaju-jananya nyinangu. ");
INSERT INTO mpj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kujungkarringulaju Jaantingka mirrka ngalangu ka kulirnu, Jiijajkurnu wangka, jiimartajilurrju. Puulju-lanyaju wululu nintirnu kutuwatirringu, jumaji yungunpa yankukijalu. ");
INSERT INTO mpj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Maya majungkalaju nyinapayi, ngarnawarrangka, layitikajawinti. ");
INSERT INTO mpj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kujungkalaju nyinara kulilpayi, warrinyji kujulu, yini Yutikajju. Wintangka palungka nyinangu kunyalarringu, Yutikajpa, jampa Puulpa wulu wangkapayi. Palujanu Yutikajpa wintajanu maya ngarnawarrajanu punkarnu, parnakutu. Tiputinguya, kaya nyangu mitu ngarripayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Puulju tiputingu yampurnu ka wajarnu-janampa, “Mirtanyurra yulama!, ngaanga mitujanu wanka ngarrini.” Yilta wanka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Palujanu Puulju tatirnu mirrka ngalkupayi. Wulu-lampajuku wangkapayi, yungunkarti. Palunyajanulaju yanu. ");
INSERT INTO mpj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Warrinyji palunya wankarringu kaya pukurlarringu, kangu ngurrakarti. ");
INSERT INTO mpj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Puulkulajura kurranyirringu puutja tatirnu yanu tawun Yajujakarti. Tawun palunyangkalaju kulirnu Puulpa tatijunkukijalu. Julyju Puulju-lanyaju kurranyinu ka marla jinangu yankurakurni. ");
INSERT INTO mpj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tawun Yajujangkalaju kujurringu ka Puulpa puutja tatirnu. Kalaju kujungka yanu puutja tawun Mitilinikarti. ");
INSERT INTO mpj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mitilinilaju junu yanu kalaju yanu parna Jiyujawana yirritingka ka mungarringu. Wululaju yanu tawun Jamujakarti mungarringu. Palujanulaju yanu puutja tawun Yipajajpalaju nyangu junu yanu. Kalaju yanu mungarringu ka yungunarringu. Kayilapalaju tawun Malitajja yanu jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tawun Yipajajjalaju yanurranpa mirtalaju tiputingu. Puulju kulirnu, mirta nyinaraku parna Yayijawana, jumaji junga yankupayi wala Jarujalumkarti, Jarujalumja turlku yini Pintikajja nyinakija. ");
INSERT INTO mpj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tawun Malitajjalaju tiputingu, ka Puulju kuju martu kurtingu wangkawinti, Jiijajmili maajakaja-jananya kangkurakurni, Yipajajmartaji. ");
INSERT INTO mpj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kulirnukaya Puulkartiluya yanu. Puulju-jananya wajarnu jilanya, “Julyjula kujungka nyinapayi, Yipajajja, palujanu nintijunyurra ngayuku. Julyjurna parna Yayijangka jarrpangu nyinapayi junga, Mamaku ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ngayurnara junga nyinapayi Mamaku, palunyangka Juwukajajuya parlanypaminyirri nyinapayi, warrkilpayirniya. Jaalpuya wangkapayi ngayurniya pungkuraku. Karlkinjuya Jiijajmili wangka kulirnu, kaya marlaku yanu walykukarti. Palunyangkarna-janampa ngayu yulama. Ngayurna junga wulu nyinama Mamaku, karna marninypungama, mirtarnaju walyja marninypungama. Wulurna Mamaku warrkamupurluka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wulurna-nyurranya nintilpayi wangka kunyjunyu, mirtarna kurntarrira junkupayi. Nyuntunkurnu ngurrangkarna-nyurranya nintilpayi ngurra kujupangka ngurra kujupangka. Jilanyakunyurra ninti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","“Yarnngangkarna-nyurranya nintilpayi Juwukajangkakamu Kiriki wangkakajangka. Marrkulpayirna-nyurranya walykunyurra junkura ka Mamangkanyurra junga nyinara, maajangka Jiijajjalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kuwarrirna Jarujalumkarti yaninpa. Mamamili Kuurtilurni nintirnu tawun palukartirna yankuraku. Tawun palungkarniya wanyjalmanku? ");
INSERT INTO mpj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Purturna kulirni, wanyjalmankurniya? Jilanyarna kulirni. Mamakurnu Kuurtilurni marrkurnu, mayitpirniya warrkilkukamu pungku, mayitpirniya jiilja jarrpajunku. Jilanyarni marrkurnu tawun kujupangkakamu tawun kujupakajangka. ");
INSERT INTO mpj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Jiikurna mirta ngurlurrini, pungkurakurniya mitu. Jiijajkurnara wulu junga nyinamalpa. Ngayulurna kulini Mamakurnara warrkamu ngapilku. Maajalu Jiijajjurni wajarnu palu warrkamurnara ngapilkura. Jilanyarni Jiijajju wajarnu, ‘Martukaja-jananya nintijula!, ngayumili wangkaya kulira junga nyinaraku, ka-janampa Mamalu walykukaja nyarrurrikuka warningku.’ ");
INSERT INTO mpj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ngayulurna-nyurranya nintilpayi jilanya. Mamalu-nyurranya palumili walyjakaja ngampurrju kanyirni, palumili walyjakaja kujupakajalurrju. Jilanyakunyurra ninti nyininpa. Kuwarrirna yaninpa, nintilurna-nyurrampa wajarni. Mirtarna-nyurrampa ngula marlakurriku, paki, mirtarna-nyurranya wituka nyaku, paki. ");
INSERT INTO mpj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Palunyangkarna-nyurranya marrkurni jilanya. Mayitpinyurra martu karlkinju Mamamili wangka kulira nyinara ka ngula junku. Palunyangka Mamalu-nyurranya ngula kuutja kurtingku, purtulunyurra jilanya kajalku, ‘Puulju-lanyaju mirta nintilpayi Jiijajku.’ Jilanya mirtanyurra wajalku, ngayulurna-nyurranya junga nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mamamili wangkarna-nyurranya wulikaja jungalu nintilpayi, mirta yaapurna-nyurranya nintilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Palunyangka ngampurrpaya nyinama!, wuluraya Mamaku, karlki kujupalu-nyurranyaya yankura nintijuljaku, wuumurru. Jiijajmili walyjakajalurrjuya-jananya Yipajajmartaji ngampurrju kanyila, maaja jungalu!, Mamamili Kuurtilu-nyurranya junu maajalu-jananyanyurra jungalu kanyilkura. Jiijajmiliya walyjarringu palukaja jumaji-janampa Jiijajpa miturringu, miji-janampa yintingu. ");
INSERT INTO mpj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nintilurna kulirni. Karlkinparniya yanku kaya pakiwana wajalku-nyurranyaya. Palunyangka ngampurrpaya-janampa nyinama! ");
INSERT INTO mpj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yiltarna-nyurranya wajarni. Karlkinjuya walyjakajalu pakiwana nintilku. Palujanu Jiijajmili walyjakajaluya karlkinju kulilkuya kaya kujungkarriku-jananyaya maaja palukajangka, nintipurluka walykukajangka. ");
INSERT INTO mpj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Palunyangka ngampurrpaya nyinama!, palunyakajangkamarra. Mirtanyurra manarrarri!, maajalu-jananyaya kunyjunyulu kanyila! Jilanyaya kulinma! Ngayulurna-nyurranya maaja kunyjunyulu nintilpayi, wululu, karrpungka mungangkalurrju, jurri yiijakarti. Martu karlkiluya purtu kulilpayi ngayurna-janampa yulapayi nyarrukajaku. Palujanu maajaluya-jananya kunyjunyulu kanyila! ");
INSERT INTO mpj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Kuwarrirna ngayu yankuni, Mamaluntaya ngampurrju kanyilku. Mama-nyurrampa nyarru nyininpa, mirta-nyurranya junku yanku. Palumili wangkanyurra kulilku ka murlpirrpanyurra nyinaku. Jilanya-nyurranya wulu ngampurrju kanyilku, Mamalu, palumili walyjakaja kujupayuru.” ");
INSERT INTO mpj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Puulju-janampa yarrarnu wajarnu, “Ngayurna parlanypa nyinapayi kulujpa kujupakukamu manikulurrju, mirtarna-jananya japilpayi ngurrangka nyakuraka. ");
INSERT INTO mpj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Walyjarnaju warrkamurrira mani mankupayikamu kulujpa, jilanyakunyurra ninti nyinani. Kujungkalaju ngayunpa yankupayi, palunyangkarna-janampa payamunkura yungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Jilanyayururna nyinara warrkamurripayi, kajunyurra ninti nyinapayi karninyurra nyakupayi. Palunyayuruyan warrkamurrira nyinaku. Jilanyayurunyurra warrkamurrira ka mani-jananyanyurra yungkura, karlkinpa nyarrukaja. Maaja Jiijajju julyju wajarnu jilanya, ‘Martu nyarrukaja-jananyanyurra yungkura, kanyurra yilta pukurlpa nyinaku.’” ");
INSERT INTO mpj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wangkangu jilanyayuru Puulpa. Palunyangkaya kujungka pupatingu, ka Jiijajjaluya wangkangu. ");
INSERT INTO mpj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Palunyangkaraya yulapayi, kaya Puulpa yampurnu kaya nyunyjurnu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kujilarringuraya Puulku jumaji mirta marlakurrikijalu wajarnu. Palujanuya wanarnu kujungka puutukarti. ");
INSERT INTO mpj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yipajajpurluka martukajalaju-janampa wajarnu, “Palulyu”. Junu yanulaju-jananya, ka puutja tatirnu. Jungalaju yanu parna Kuujuwana ka mungarringu. Palunyajanu parna Ruutuwanalaju yanu tawun Patarangka jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Jiingkalaju tiputingu ka ngurrirnu puutu kujupaku ka tatirnulaju parna Panijiyakutu yankukija. ");
INSERT INTO mpj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tatirnulaju yanu parna Japurijpa nyangu. Nyakuralaju kakarrarringu yanu parna Jiriyakarti, tawun Taayangkalaju jarrpangu. Palujanu puutpurlukalu-janampaya wartakajakamu mirrka junu-janampaya. ");
INSERT INTO mpj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jiingkalaju tiputingu ka ngurrilpayilaju-janampa, ka kujungkarringu, Jiijajmili walyjakajangka. Palungkalaju-jananya ngurrangka nyinangu kujungka, wiikingka. Mamamili Kuurtilu-jananya nintilpayi palumartaji, kaya Jiijajmili walyjakajalu kulirnu, karaya Puulku wajarnu, mirta Jarujalumkarti yankuraku. ");
INSERT INTO mpj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Puutu yankukijalu palunyangkalaju yanu tatilkuraku. Jiijajmili walyjakajalurrjulaju yanu palumili nyupakajalurrju, jijikajalurrju. Yanulaju kalyuwarti parnangka yirritingka pupangu, ka Mamangkalajulu wangkangu. ");
INSERT INTO mpj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Wajarnulaju-jananya, “Palulyu.” Ka puutungkalaju tatirnu, palunyangkaya ngurratu marlaku yanu. ");
INSERT INTO mpj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tawun Taayajanulaju yanu tawun Talamayijakarti. Tawun jiingkalaju tiputingu ka Jiijajmili walyjakajangka kujurringu. Ka nyinangulaju karrpungka kujungka. ");
INSERT INTO mpj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Yungunarringu ka pakarnulaju puutja tatirnu yanu tawun Jijariyakarti. Tiputingulaju ka yanu Pilapuku mayangka jarrpangu nyinapayi. Jiilu Pilapulu Jiijajmili wangka parra wajalpayi, julyjulu. Kuju nyinapayi palunya julyjuya-jananya yintalpayi japan wulikaja yirnakaja, Jarujalumungka. Jiijajmili warrkamuya ngapira nyinapayi, wantikaja yirnaparnikajaya-jananya ngampurrju kanyilkura. ");
INSERT INTO mpj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pilapu palunya nyinapayi puu wulikaja yurrkanywinti, yurntalkajaraya, nyupaparniya nyinapayi. Palukajaluya parra wajalpayi, Mamamili wangka. ");
INSERT INTO mpj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Karrpu yupaljalaju mayangka palungka nyinapayi. Palunyangka Yakapajpa Mamamili wangka jakurlpurluka parna Juutiyajanurni yankupayi, ka mayangka warinykatingu jarrpangu. ");
INSERT INTO mpj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Palunyajanu Puulmili nanpa tikamaturnu, kayilapangku mara kujarra tayimapurnu, jina kujarralurrju. Jilanya-jananya wajarnu, yirna Yakapajju, “Nanpakura ngaaku walyja jilanyayuruya tayimapulku Juwukajalu, Jarujalumja, kayilapaya katiku yungku Juwuparnikajangka. Jilanyarni Mamamililu Kuurtilu nintirnu.” ");
INSERT INTO mpj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Palunyangkalaju kulirnu kalajulu Puulja purtu wajarnu, mirta yankuraku Jarujalumukutu. ");
INSERT INTO mpj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Palunyangka-lanyaju wajarnu, “Mirtajunyurra yulama!, kunyjunyurna Jarujalumkarti yanku. Mayitpirniya tayimapulku, mayitpirniya pungku mitu. Kunyjunyurnara Jiijajku yanku miturriku, jumajirnara wulu walyja nyinaku.” ");
INSERT INTO mpj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Purtulaju wajarnu yumurringu. Kalaju wajarnu, “Nyamunta Mamalu ngampurrju kanyilku.” ");
INSERT INTO mpj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Palujanulaju Puulmapulu wartakaja manu ka tawun Jarujalumkarti jinangu yanu. Ngayulurrjurna Luukpa kujungkalaju yanu ");
INSERT INTO mpj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Karlkinju Jijariyamartajilu-lanyajuya katingu mayakarti. Kutungkalaju Majankurnungka mayangka nyinapayi. Julyju nyinapayi Jayipurijja, Jiijajkura nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yanulaju tawun Jarujalumkarti jarrpangu. Palunyangka-lampajukuya Jiijajmili walyjakaja, pukurlarringu. ");
INSERT INTO mpj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yungunpa-lanyaju Puulju katingu Jayimijjalaju nyakuraku. Palungkaya nyinapayi, Jaajipurluka maajakajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Puulju-janampa pukurlarringuka, jakurljunu-jananya jilanya, “Mamalurni ngampurrju kanyilpayi, Juwuparningkarna-jananya nintilpayi Jiijajmili wangka. Laltuluya kulirnu kaya Jiijajmili walyjarringu.” Jilanyalu-jananya rawalu jakurljulpayi. ");
INSERT INTO mpj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Palunyangkaya kulirnu Puulpa, kaya Mama marninypungkupayi. Kaluya Puulja wajarnu jilanya, “Juwukajaya laltu ngaamartaji Jiijajmili wangka kulira, kaya Jiijajmili walyjarringu nyininpa. Juwukurnu luwulurrjuya kulira walyja nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jakurlpaya kulirnu jilanya, ‘Puulju-jananya Juwuparnikaja ngurrangka nintilpayi. Palungka-jananya nintilpayi, Juwukaja ngurra tiwapurlukakaja, Muujajkurnu luwuya junkuraku. Nintijulpayi-jananya mirtaya-jananya jijikaja julijulikaja yirnamalkuraku, mirtaya Muujajkurnu luwu wanalkuraku.’” ");
INSERT INTO mpj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yarrarnuya Puulja Jaajpurlukakajalu wajarnu, “Juwukajaluntaya ngaamartajilu kulilku nyuntun yanurni. Nyuntukuya wirrilyi nyininpa. Wanyjalmalkula?” ");
INSERT INTO mpj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Yarrarnuya Puulja Jaajpurlukakajalu wajarnu, “Kulirninpalajunta jilanyan nyuntulu ngapilku. Kangku-jananyan puu wulikaja Jiijajmili walyjakaja, ngaamartaji jaaji majukarti. Julyjuya Mamangkaluya jamartapungu jungaya nyinakija. Kuwarriya yanku nyaku-jananya yatilyju, Muujajkurnu luwuya wanarni. ");
INSERT INTO mpj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nyuntu-jananyan kujungka yanku ka mirtayirti payamula yuwa-jananyan!, yatilypa yungkuraku. Palunyajanu-ngkuya jii puu wulikajalu kata katapungkuraku, jilanya Muujajkurnu luwu nyininpa. Jilanyan nyuntu nyinaku jaajingka Muujajkurnu luwu wanalku, Juwukajaluntaya nyuntu nyakura pukurlarrira. Jilanyaya kulilku, mirtan pakiwana nyininpa, Muujajkurnun luwu nyuntulu wanarni.” ");
INSERT INTO mpj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Palunyangka Jayimijmapulu-janampa yarrarnu wajarnu, “Tiwamartajipurlukakulaju-janampa Juwuparnikajaku julyju kurtingu mirlimirli, Jiijajmilikajaku. Wakarnulaju jilanya, ‘Mirtayirtiya yunginpa Mamayuru kujupaku. Mirtanyurra mirtayirti jilanya ngalkuranpa. Mirtanyurra mijikaja jikilkuraku. Kamu mirtanyurra kuka miji ngalkuraku, miji yintira ngalkuraku. Kanyurra mirta nyupa kujupangka ngarriraku, kujupakurnungka.’” ");
INSERT INTO mpj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Karrpu kujupangka Puulju-jananya katingu jaajikarti majukarti puu wulikaja. Kujungkaya palungka turlkungka nyinangu, jaajingka. Ka yatilyjalu Puulju yanu wajarnu, wiikingka kujungkaya mirtayirti yungkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wiikingka palungka pakirrinyjangka, Puulpaya nyangu jaajingka majungka, Juwukajalu, parna Yayijamartajilu. Parna Yayijamartajiluya nyangukaya jakurljunu Puulpa karlkinja Juwukajangka, Jarujalumumartijingka. Palunyangkaya wirrilyirringuraya martukaja, kaya ngalurnu kanyilpayi jaaji majungka. ");
INSERT INTO mpj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Jilanyaya wangkangu, “Juwukajaluya kulila! Ngaalu-jananya Puulju parna parlparriwana nintijulpayi martukaja, ka Juwukaja-lanya minyjilypa warningu, jaaji majulurrjukamu Muujajmili luwu. Palulu-jananya kuwarri Kiriki wangkawinti, Juwuparnikaja katingu jaaji majungka jarrpajunu. Wiyala-jananya jarrpajunin ngaangka Kiriki wangkawinti, Juwuparnikaja, paki, jumaji Mamakura ngarnawarrapurlukaku ngurra.” ");
INSERT INTO mpj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kujungkapula yankupayi Puulkamu Turupimajja Yipajajmartaji, Kiriki wangkawinti. Mirtapula yanu jarrpangu jaaji majungka. Palunyayuru kararnuya kaya Puulku wirrilyirringu. ");
INSERT INTO mpj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jilanyaya kulirnu kaya wirrilyiwinti kujungkarringu pinirringu manu Puulpa, kaya yilarnu yawujayiti katingu jaaji majuwartajanu, kaya kiituya jatamapurnu. ");
INSERT INTO mpj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Palunyangkaya martukajalu Puulpa pungkukijalu mitu, kaluya karlkin kujupalu yanuya-jananya jakurljunu jantulwintikajangka, Ruumanmartajingka. Jilanyaya-jananya jakurljunu, “Jarujalummartajilu-ngkuya pungkuninpa.” ");
INSERT INTO mpj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kulirnukaya pinirringu Ruumanpurluka maaja, jantulwintikajalurrju. Yanuya-jananya ngarlkilmalpayi martukaja. Jantulwintikajaya-jananya nyangu kaya Puulpa junu, pungkuparnilu. ");
INSERT INTO mpj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Jantulwintikajaku-janampa maajalu wajarnu, ka yanupula jantulwinti kujarralu Puulpa winirnu, ka mara kujarrapula tayimapurnu, jiinwintilu. Palunyangka-jananya maajalu martukaja japirnu, “Ngana ngaa martu? Nyaa ngapirnu?” ");
INSERT INTO mpj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Karlkiluya wangka kuju wajalpayi, karlkin kujupaluya wangka kujupa wajalpayi. Palunyangka-jananya maajalu purtu kulirnu. Ka wajarnu-jananya jantulwintikajaku kangkurakuya Puulpa, jantulwintikajaku mayakarti. ");
INSERT INTO mpj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Palujanuya jinangu Puulpa jantulwintikajalu katingu. Kaya jantulwintikajangka mayangka tuungka kintirrinyja Puulpaya jarlirnu katingu, jumajiya martukajalu pungkujaku, wirrilyiwintiluminyirri. ");
INSERT INTO mpj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Jampaya jantulwintikajalu katipayi, palunyangkaya martukaja wanarnukaya mirrapayi, “Pungkuralaju mitu junkura!” ");
INSERT INTO mpj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Palunyangkaya mayangka jarrpajulkijalu, kalu wajarnu Puulju maajangka jilanya, “Japilkurnanta?” Kara maajalu wajarnu, “Nyunturan Kiriki wangkaku ninti?” Kayilapa Puulju yuujunu. ");
INSERT INTO mpj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Maajalura yarrarnu wajarnuka, “Kulirnurna, Yijipimartajilu-jananya kuwarri kujungkanu-jananya maaja majukaja kapamankaja pungkukijalu. Jurtawartakaja-jananya kujungkanu pujimankarti kangu, laltuminyirri, puu jawujun. Kajin nyuntu maaja palukajaku?” ");
INSERT INTO mpj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Palunyangka Puulju wajarnu, “Paki. Ngayurna parna Jilijiyamartaji, tawun Taajajmartaji, Juwurna nyininpa, tawunpaju Taajajpa nyininpa, maju. Ngayurna-janampa maaja nyininpa. Kajirna-jananya wangkaku?, martukajangka ngaakajangka?” ");
INSERT INTO mpj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Palunyangka maajalura Puulku yuujunu. Puulpa-jananya tuwungka ngururrpa ngarnawarra wangkangu, martukajangka. Ka marrkurnu-jananya maralu yakarrikuraya. Palunyangkaya yakarringu ka-jananya wangkangu, Yipuru wangka. ");
INSERT INTO mpj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Yikingu-jananya Puulju jilanya wajarnu, “Walyjakajalurniya kulinma, ngayungka wangka!” ");
INSERT INTO mpj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Puulju-jananya Yipuru wangkalu wajarnu. Kulirnukaya yakarringu. Jilanya-jananya yarrarnu wajarnu, ");
INSERT INTO mpj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ngayurna Juwu yikininpa karna Jilijiyamartaji, tawun Taajajpaju ngayuku ngurra. Jijirna Jarujalumja yanurni nyinapayi ka majurringurna. Nintipukalurni yirnalu Kamayilalu nintirnu, kuulja. Pukurrakajamilirni nintilpayi, luwu rawalu. Palunyangkarnara Mamaku ngarnawarrapurlukaku nintilu kulini. Mamakuranyurra nintilu kulini, palunyangkarnara nyuntuyuru ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Julyjurna-jananya Jiijajmili walyjakaja wululu mankupayi. Parlanyparna-janampa nyinapayi wajalpayirna-janampa, ngayumili warrkamupurlukakajaluya-jananya mitu pungkura. Winirarna-jananya katipayi jiilkarti, yirnakajakamu wantikaja. ");
INSERT INTO mpj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ngayulurna-jananya jilanyalu mankupayi, kajuya yatilypa, maaja majukamu kanjulukaja ninti nyininpa. Jiikajalurniya mirlimirli yungu, katirarna-jananya nintilkura, Juwukaja Tamajakajmartaji, Jiijajmili walyjakajarna-jananya mankuraku. Palunyajanu tawun Tamajakajkartirna yanu Jiijajmili walyjakajarna-jananya mankuraku, jiirnmuntulkuraku ka Jarujalumkartirna-jananya kangkuraku, jiiljaya jarrparaku. ");
INSERT INTO mpj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Tawun Tamajakajakartirna yanu kintirringu, jirntu kutuwarti. Palunyangkarni layiti maju yikingu, ngarnawarrajanu. ");
INSERT INTO mpj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Parnangkarna punkarnu karna wangka kulirnu jilanya, ‘Juulpawu! Juulpawu! Kulilarni! Nyaakujun jurtarringu?, pungkukija-jananyan ngayumili walyjakaja.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kulirnukarna wajarnu, ‘Ngana nyuntu maaja wangkinpa?’ Wajarnuju, ‘Ngayurna Jiijajpa Najarijmartaji, nyuntujun jurtarripayi.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ngayuku walyjakajajuya kujungka yankupayi, palunyangkaya layiti majuwarta nyangu. Mirtaya wangka palunyalu kulirnu, ngayulurna kujulu. ");
INSERT INTO mpj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Wajarnurna, ‘Maaja! Wanyjalmalkurna?’ Wajarnurni, ‘Pakala!, tawun Tamajakajkarti yarra kurruwa! Palunyangkanta kujupalu nintilku, nyaan ngapilkuraku.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pakarnurna purtu nyakupayi, kururna pampururringu. Layiti palunyalurni kuru pampururnu. Palunyangkarniya mara winirnu katingu tawun palukarti. ");
INSERT INTO mpj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Tawun palunyangka Yananayajpa nyinapayi, Juwukurnu luwukura ninti palu nyinapayi, junga. Juwukajaluya palumartajilu wajalpayi, ‘Yananayajpa yirna kunyjunyu.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Palunyarni yanu ngaranguka Yananayajju wajarnu, ‘Juulpa! Ngayukujun walyja. Kuru kunyjunyurri!’ Pipurrulurna kunyjunyulu nyakupayi. ");
INSERT INTO mpj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wajarnurni, ‘Mamalunta julyju yintarnu wangkangungku nyuntuku, palumili wangkan parra wajalkuranpa. Mamalunta yintarnu, layitin nyangu, palunyangka Jiijajmili wangkan kulilkuraku. Kayilan kulirnu yiltaminyirri Jiijajpanta wangkapayi, ruutungka. ");
INSERT INTO mpj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Palunyangkan Jiijajmili wangka parra wajanmalpa, jumajin kulirnu Jiijajpa yiltaminyirri, wangkangunta.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yananayajjurni yarrarnu wajarnu, ‘Nyamu pakala!, ka kalyungka jarrpa! Maaja Jiijajpa japila!, walykukajangku warningkura.’” ");
INSERT INTO mpj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Puulju-jananya martukajangka jantulwintikajangkalurrju-jananya mayangka, ngarnawarralu yarrarnu wajarnu, ");
INSERT INTO mpj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","“Jarujalumkartirna marlaku yanu, ka Juwukurnu jaaji majuwartangkarnalu Mamangka wangkangu. Jiingkarna nyangu kapukurrilu Maaja ngarnawarrapurluka. Palunyalurni wajarnu, ‘Wala pakala yarra!, Jarujalumja ngaangka mirtaya nyuntumili wangka kulilku, jampa-janampan ngayukurnu wangka wajanyjan, paki.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Puuljurna wajarnu, ‘Maaja! Nyuntuku walyjakajarna-jananya mankura pungkupayi, Juwukurnu jaaji kujupangkakamu jaaji kujupa kujupakajangka. Jiiljarna-jananya katira junkupayi. Jaajpurluka maajakajajuya ninti nyininpa, Jarujalummartaji. ");
INSERT INTO mpj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nyuntumili wangka Tiipanju wajalpayi. Palunyangkaya pungu, ngayurna pukurlpa yikipayi. Kuurturniya warningkupayi, palunyaya yungkalkijalu. Ngayulurna pukurljurna-janampa kuurtukaja kanyilpayi.’ ");
INSERT INTO mpj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Palunyangkarni Maajalu Mamalu Puulja wajarnu, ‘Tawunpa ngaanya jurra yarra!, ka yarra-jananya Juwuparnikajangka jakurljurra!’” ");
INSERT INTO mpj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Yakaluya wululu kulilpayi Puulkurnu wangka, martukajalu. Palunyangkaya kulirnu jilanya, “Juwuparnikajangka-jananya jakurljulkijalu, Puulju” Karaya Puulku wirrilyirringu. Kaya wiltulu wajalpayi jilanya, “Jiinyala pungku junku, mirta palunya wanka nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Mirrapayiya ka parnalurrjuya warningkupayi ngarnkangka. Kaya kulujulurrju-ngkuya warlangkupayi, Puulku wirrilyiwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jantulwintikajaku maajalu wajarnu-jananya winira katira Puulpa, mayangka yinjayiti. Ka maajalu purtu kulirnu, “Nyaakuya martukaja wirrilyirrini, Puulku? Mayitpirna pungkunyjangka wajalkurni.” Ka maajalu-jananya wajarnu, jantulwintikajangka Puulpaya wiipuwintilu pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pungkukijaluya wiipuwintilu manuya tayimapunu ngarajunu. Palunyangka jantulwinti kujungkalu Puulju wajarnu jilanya, “Ngayurna Ruumanpurluka. Kaji kulirninyurra kunyjunyu wiipuwintilurniya pungkura? Mayitirninyurra kuutja kurranyi katira ngarajunkura?” ");
INSERT INTO mpj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Jantulwintilu kulirnu Puulku wangka, palunyangka yanu jantulwinti maajangka wajarnu, “Yirna palu Ruumanpurluka ngarinpa, mirtala pungkura, junkurala!” ");
INSERT INTO mpj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Palunyangka jiilu maajalu yanulu Puulja japirnu, “Yiltan nyuntu Ruumanpurluka ngarinpa?” Puulju wajarnu, “Yuwa, yiltarna.” ");
INSERT INTO mpj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Puuljalu wajarnu maajalu, “Ngayurna Ruumanpurluka, mirtaju ngayuku mama Ruumanmartaji nyinapayi, paki. Palunyangkarnara mani maju yungurnara Ruumanmartaji maaja maju. Palunyangkarni wajarnu, ‘Nyunturnanta ngarajuni, yilta Ruumanpurluka.’” Puuljura wajarnu jilanya, “Ngayukuju mama Ruumanmartaji nyinapayi, palunyangkarna ngayu Ruumanpurluka nyinani.” ");
INSERT INTO mpj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Palunyangkaya jantulwintikajalu kulirnukaya Puulku ngurlurringu. Jilanyaya kulirnu, “Martu palunyala tayimapunu jiinwintilu. Junkungarala jumaji Ruumanpurluka. Luwu-lampa nyininpa, mirtala-jananya Ruumanpurluka tayimapuni, mirta pungkuraku.” Palunyangkamarraya junu, pungkuparnilu. Maaja majulu palunyalu kulirnu ka ngurlurringu, jumaji Ruumanpurluka kulirnu. ");
INSERT INTO mpj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yaarlipalarringu palunyangka maajalulu palumili warrkamupurluka kurtingu, Puulja tikamatunkura jiinpa. Maaja jiilu wululu purtu kulilpayi, “Nyaajanuraya wirrilyirringu?, ngaaku, Juwukaja?” Jantulwintikajaku maajalu-jananya wajarnu kujungkanu miitingku, Juwumili maajakaja, yatilykajakamu kanjulukaja. Maaja jiilu-jananya jilanya purtu japirnu, “Nyaajanunyurra wirrilyirrini?, paluku pungkuraku.” Palujanu maaja jiilu-jananya Puulpa katingu yikijunu. ");
INSERT INTO mpj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Maajakajangka-jananya palukajangka Puulju yikinguka-jananya murlpirrju nyakupayi. Ka-jananya wajarnu, “Walyjakajaluya kulila! Mama ngarnawarrakurnara rawa junga nyinapayi, ka kuwarrirnara junga wulu nyinani. Jilanyarna ngayulu kulini.” ");
INSERT INTO mpj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Wangka palunya kulirnuka maaja majulu, yatilyju wajarnulu Yananayajjulu, martu kujupangka, pungkuraku Puulpa yirranyuku. ");
INSERT INTO mpj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pungkunyjangka Puulpa palunyangkara yatily majuku wajarnu, “Nyuntun mayunyju. Mama ngarnawarralunta puntaju pungku. Nyuntun nyinani Muujajkurnu luwungka ngayurnin jungalkijalu. Palunyangkan luwu palunya warlangu, wajarnu-jananyan pungkurakurniya.” ");
INSERT INTO mpj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Kinti yikipayi palunyangkalu Puulja wajarnu, “Mirtan kuru wajala maaja maju!, yatilypa, paki, Mama ngarnawarrapurlukalu maaja junu ngaanya.” ");
INSERT INTO mpj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Puulju wajarnu, “Ngurrpalurna kuru wajarnu, maaja majungka yatilyja, wajalparnilurna junkungara. Jilanya Mamamili wangka nyinani, ‘Martuluya mirta maaja maju kuru wajani.’” ");
INSERT INTO mpj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Puulju-jananya yintarnu, karlkinpaya nyinapayi Parajikajakamu karlkin kujupa Jaajmili maajakaja. Jaajmili maajakajaluya kulira nyinapayi, martuya mirta ngula wankarrini mitujanu. Puulju-janampa yarrarnu wajarnu, “Walyjakajalurniya kulila! Ngayukuju mama Paraji nyinapayi, palunyayururna ngayu Paraji nyinani. Ngayulurna kulini, Mama ngarnawarrapurlukalu-lanya ngula martukaja mitujanu wankanmalpa, palunyarna ngayulu kulini. Palunyangkamarrarniya ngayu ngaangka kangu yikijunu.” ");
INSERT INTO mpj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kaya wangka jiinya kulirnuka-ngkuya ngaparrju warrkilpayi, Parajikajakamu Jaajmili maajakajalu. ");
INSERT INTO mpj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Karlkin kujupaluya kulirnu, Jaajmili maajakajalu, mirtaya ngula martukaja mitujanu wankarriku. Wangka kujupalurrjuya jilanya kulirnu, mirtaya wikarrukaja nyinin kamu malpukaja. Jilanyaya kulira nyinapayi, ka karlki kujupaluya Parajikajalu yilta kulira nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wirrilyirringuya kaya Parajikajalu pakarnu wajarnu jilanya, “Ngayurtinjulaju kulini, yirna ngaanya Puulpa yikini, mirta walykukaja ngapirnu. Mayitpilu Kuurti ngaangka Puulja wangkangu, mayitpilu Mamamili wikarru wangkangu.” ");
INSERT INTO mpj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Palunyangka jurtalu-ngkuya warrkirnuka pungu. Puulpaya pungkujakungkamarra palunyangka jantulwinti maajalu wajarnu-janampa, Puulpaya yankura winira katira marlaku, mayakarti, jantulwintikajalu. Jantulwintikajamili mayakartiya katingu junu. ");
INSERT INTO mpj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Palungka mayangka mungajarra maaja Jiijajpa Puuljalu yutirringu wangkangu, “Mirtan ngurlurri! Nyuntun kunyjunyu wangka-jananyan wajarnu ngayumili, ngaangka Jarujalumja. Ngula-jananyan Ruumja yanku wajalku, jilanyalu.” ");
INSERT INTO mpj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Yungun pakarnukaya Juwukaja kujungkarringu jaalpu wangkangu, Puulpaya pungkukijalu, mitu. Jilanyaluya Mamangka wajarnu, “Kuwarrila Puulpa pungku mitu. Jilanyawiyajula kulini, mirtala mirrkaku kulini, kala palunyajanu mirrka ngalkukamu kalyu jikilku.” ");
INSERT INTO mpj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jilanyaya wajarnu, laltuluya puuti wulikajalu, pungkukijalu. ");
INSERT INTO mpj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Palunyangkaya jurtawartakaja yanu maaja majukajakarti yatilykajakartikamu maaja yirnakajakarti. Yanuya-janampa jilanya wajarnu, “Ngayunjulaju Mamangka wajarnu, Puulpalaju kuwarri pungkukijalu. Mirtalaju kuwarri mirrka ngalkukamu kalyu jikilku, Puulpalaju mitu pungku, palunyajanulaju mirrka ngalkukamu kalyu jikilku. ");
INSERT INTO mpj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Palunyangkaluyan jantulwintikajaku maaja majungkaluyan wangka kurtingkura. Jilanyaluyan wajalku, ‘Puulpaya winila katirni miitingkarti wangkakura!, ngayunjula kintilu japira kulilkura.’ Palunyangka Puulpaya katini kutukarti ngayunjulaju pungkura junkura.” Jilanyaluya maajakajangka wajarnu. ");
INSERT INTO mpj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Puulku puuyilu, palumili jurtuku kajalu kulirnu wangka palunya, ka jantulkajamili mayangka yanulu jakurljunu Puulja. ");
INSERT INTO mpj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wangka palunya Puulju kulirnu ka jantulwintikura mirrangu. Palungkarni yanu kara Puulju japirnu, “Kajin ngayuku puuyiju katiku, maaja majukarti?, wangka wajalkuralu.” ");
INSERT INTO mpj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jantulwintilu palunyalu Puulmili puuyi katingu maaja majukartilu. Katingu yikijunu ka wajarnu, “Puuljurni wajarnu jilanya, murtilyarna ngaanya kangkura wangkarakunta.” ");
INSERT INTO mpj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Maaja majulu murtilya palunya yawujayiti katingu, martu kujupaluya kuliljaku. Ka japirnura, “Nyaarnin wajalkijalu?” ");
INSERT INTO mpj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Murtilyalura wajarnu, “Juwukajaluya kujungkarringuya kulini nyuntuntaya japilkura, jilanyantaya yumulu japilkura Puulpayan katira yungunpa miitingkarti. Jilanyantaya kajalku, ‘Puulpaya katira miitingkarti, maajakajaluya kintilu japira kulilkuraku.’ ");
INSERT INTO mpj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mirta-jananyan kulila!, karlki kujupaluya Puulpa jurtawartakajalu kutungka pungkujaku, martu puuti wulikajalu. Palunyakajaluya Mamangka ngarnawarrapurlukangka wajarnu, Puulpaya mitu pungkukijalu, palunyangkaya mirta mirrka ngalkukijalukamu kalyuya mirta jikilkuraku. Puulpa mitu ngarrinyjangkawiyajuya palujanu mirrka ngalkukamu kalyu jikilku.” Murtilyalu yarrarnu wajarnu jilanya, “Karlkiluntaya japilkijalu majani.” ");
INSERT INTO mpj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jantulwintipurlukalu maajalu murtilyangkalu wajarnu jilanya, “Ngayungkarnin nyuntulu jakurljunu, mirta-jananyan karlki kujupangka jakurljula!” Palujanu murtilya palunya wajarnu kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Maaja majulu palunyalu jantulwinti kujarraku-pulampa mirrangu ka wajarnu-pulampa, “Jantulwintikajaku-janampapula mirra!, yankurakurniya kujungkarrikura, tuu yantarta wulikajaku, kaya Puulpa tawun Jijariyakarti kangkura. Jilanyakulurrjupula mirra!, jantulwintikajaku, japanti wulikaja yawartawinti. Palunyangka karlki kujupakupula mirra!, jantulwintikajaku, tuu yantarta wulikajaku. Palunyakajapulan kujungkalku ka mungajarranyurra yanku, mirta kutuwatirni, kurranyi kurranyi. ");
INSERT INTO mpj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Puulkulurrjuraya yawarta yupalpa marra!, kanyurra kintilu katiku, maaja Pilikijkarti, pungkujakungkamarraya.” ");
INSERT INTO mpj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jantulwintimili maaja majulu, mirlimirli wakarnu jilanya, ");
INSERT INTO mpj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ngayulurna Kulutiyaj Layijalu mirlimirli ngaanya wakarnu, nyuntukarti, maaja majukarti, Pilikijkarti. Kunyjunyun nyininpa? ");
INSERT INTO mpj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yirna ngaanyaya Puulpa Juwukajalu manu, mituya pungkukijalu. Ngayunjulaju jantulwintikajalu manu katingu, mituya pungkujakungkamarra. Karlkilurniya wajarnu palunya Ruumanmartaji, palunyangkarna yanu wankarnu, pungkujakungkamarraya. ");
INSERT INTO mpj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Purturna kulirnu, ‘Nyaapa ngaalu putamanu?’ Palunyangkarna katingu ngarajunu, Juwumili kanjulukajangka, kulirarna nintirriraku. ");
INSERT INTO mpj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Juwukajaluya palunya kuru wajarnu, jumaji Juwukurnu luwungka-jananya warrkilpayi. Mirtaya ngukarrinu ngulyulu mankupayikamu martu kujupa pungkupayi, paki, palujanurna purtu kulirnu, jiilja wulu kanyilkuraku. Mirta palunyaya mitu pungkuraku, mirta walyku ngapirnu. ");
INSERT INTO mpj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Martu kujupalurni wajarnu, Juwukajaluya jaalpu wangkapayi, Puulpa mitu pungkukijaluya. Palunyangkamarra ngayulurnanta pipurrulu kurtingkuni. Wajarnurna-jananya Juwukajangka kuutja wangkara nyuntumili tawunja, jiikajaya yankura wangkara nyuntungka.” Wangka palunya mirlimirlingka wakarnu, Kulutiyajju, yungura maaja Pilikijkartilu kangkura yungkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Palujanuya katingu Puulpa mungangka, tawun Yantipatirijikarti, maaja majulu wajanyjangka. ");
INSERT INTO mpj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yungunpaya tawun jiingka jantulwintikajaluya karlkinjuya junu yanu, kaya marlaku jinangu yanu, tawun Jarujalumkarti. Karlkin kujupaluya Puulpa wululu katingu tawun Jijariyakarti, yawartawintikajalu. ");
INSERT INTO mpj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Tawunja Jijariyangkaya jarrpangu karaya mirlimirli yungu, maaja majungka, Pilikijja. Maaja palunyangkaluya Puulpa yikijunu. ");
INSERT INTO mpj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Maaja palunyalu mirlimirli riitamunu ka-jananya japirnu, “Parna wanyjapurluka jiinya Puulpa?” Palunyangkaluya wajarnu, “Puulpa parna Jilijiyapurluka.” Kulirnuka maaja Pilikijjulu wajarnu, Puulja, ");
INSERT INTO mpj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Karlkinkula-janampa majalku, nyuntuntaya kuru wajalku kuutja. Palunyangkarna kulilku, nyuntumili wangka.” Palunyajanu-janampa jiilu maajalu wajarnu, jantulwintikajaku, Puulpaya nyakura ngampurrju kanyilkura, Yirutmili mayangka, mirta jiilja. Yirutpa palunya maaja maju nyinapayi Pilikijku. ");
INSERT INTO mpj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Palujanu payipu wulikajangka karrpungka yatilypa maaja maju Yananayajmapuya pakarnu tawun Jarujalumjanu, kaya jarrpangu tawun Jijariyangka. Kujungkaya pakarnu Yananayajpakamu maaja majukaja, Tatalajlurrju, Tatalajpa kuutja wangkapayi. Maaja Pilikij nyinapayi, palunyangkaya kuutja jarrpangu Puulpaya nyurnimankupayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Palunyangkara maaja Puulku mirrangu, yankura nyinakuraku. Kayila Tatalajpa pakarnu wangkangu jilanya, “Nyuntun maaja yilta. Nyuntu-lampajun maaja ninti nyinapayi. Kunyjunyulu-lanyajun kanyilpayi, ngampurrju, palunyangka palyalaju nyinapayi, mirta-lanyajuya pungkupayi, karlkin kujupalu, paki. ");
INSERT INTO mpj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Jilanya-lanyajun nyuntulu kunyjunyulu kanyilpayi, palunyalaju kulirnuka pukurlpa nyinin. ");
INSERT INTO mpj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Palunyangkarnanta wangka juku wajalku, rawan nyuntu nyinajakungkamarra, kulilku-lampajun kuju wangka juku. ");
INSERT INTO mpj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Yirna ngaanya Puulpanga jurtawarta. Ngaalu-jananya Juwukaja wangkara jaarramulpayi, parna parlparriwanalu. Ngaa-janampa maaja Jiijajmili walyjakajaku. Jiijajpa Najarijmartaji ngaa marninypungkura nyinapayi, pakiwana. ");
INSERT INTO mpj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ngaalu Puulju martu kuju, Juwuparni katingu Juwuku jaaji majungka jarrpajulkija. Mirtaya Juwuparni jaaji jiingka jarrpinpa, paki, Juwukajawiyajulaju jarrpinpa. Palunyangkalaju Puulpa winirnu manu, jumaji jaaji-lampaju jiinya walykurrijaku. ");
INSERT INTO mpj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Japilalu Puulpa!, nintirrikuyilaran wangkaku palumiliku. Nyuntuyilan kulilku, ngayukurnuju wangka junga nyinin.” ");
INSERT INTO mpj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Palunyangka Juwu karlkin kujupaluya kulirnuka wajarnu, “Tatalajpa ngaa junga wangkinpa.” ");
INSERT INTO mpj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Maaja Pilikijjura mara wangkangura nintirnulu Puulja, wangkakuraku. Palunyangka Puulju wajarnu, “Pukurlarrinparnangku nyuntuku. Nyuntu-lampajun maaja maju nyinapayi, rawa, kuutpurluka. ");
INSERT INTO mpj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wiiki kujarrangkarna tawun Jarujalumungkarna jarrpangu nyinapayi, Mama ngarnawarrapurlukarna marninypungkupayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Kunyjunyurna nyinapayi mirtarna-jananya warrkilpayi, jaaji majungkakamu Juwukurnu jaaji kujupangka, paki, mirtarna-jananya jaarramulpayi, Jarujalumungka, paki. ");
INSERT INTO mpj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wangka palunyaya Juwukajalu paki wajarnu. Wangka yiltayuruya wajarnu. Wajala-jananya!, jungalurniya wajalkura. ");
INSERT INTO mpj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Wangka jilanyawiyajuya yilta wajarnu, ngayulurna Mama ngarnawarrapurluka marninypungkupayi, Jiijajpalurrjurna wanalpayi. Jilanyaya Juwukajalu kulirni, ngayulurna pakiwana Jiijajpa wanarni. Muujajkurnu luwurna ngayulu kujungkalu kulira wanalpayi. Luwu kujupalurrju Mamamili jakurlpurlukakamuluya mitunyjarrilu mirlimirlingka junkupayi julyju, kulirarna ngayulu wanalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Kujungkalaju Juwukajalu ngaanju kulira nyinapayi jilanya, Mama ngarnawarrapurlukalu-lanya martukaja mitujanu ngula wankalku ka kuutja-lanya wajalku, palumili walyjakajakamu walykukajalurrju. ");
INSERT INTO mpj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Palunyangkarnara Mamaku junga nyininpakamu, martukajakulurrjurna junga nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Puulju-janampa yarrarnu wajarnu, “Tawun kujupa kujupangkarna yarnngangka yiiyangka nyinapayi. Jarujalumkartirna yanurni jarrpangu, ngayuku martukaja walyjakaja mani yungkurakukamu mirtayirti yungkuraku, Mama ngarnawarrapurlukaku. ");
INSERT INTO mpj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mamakurnara jaaji majungka mirtayirti kangkura yungkupayi, nyakupayirniya Juwukajalu Palunyangkarna-jananya mirta warrkilpayi, kujurna palungka nyinapayi, mirtalaju yarnnga nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Karlkin kujupalurniya nyangu Jaajingka palungka Juwukajalu, parna Yayijamartajilu. Palunyakajaluya yanurni wajalngara ngaangka kuutja, jamparna walyku ngapinngara. ");
INSERT INTO mpj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ngaakajangkarna-jananya Juwukajangka wangkangu kuutja Jarujalumungka. Jiikajaluntaya wajalkura jamparna walyku ngapinu. ");
INSERT INTO mpj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mayitpintaya jiikajalu wangka kuju wajalku, jilanyarna-jananya wajarnu, ‘Ngaangkarna-nyurranya yikini jumajirna ngayulu kulini, “Mitukajaya ngula wankarriku.” ’” ");
INSERT INTO mpj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Wangka palunya kulirnu ka maaja Pilikijju-janampa wajarnu, “Ngularna-nyurranya wituka kulilku, maaja Layijiyajparni yanku.” Maaja Pilikijpa Jiijajmiliku wangkaku ninti nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Palunyangkalu kujungka jantulwinti maajangka wajarnu, Puulpaya kintilu ngampurrju kangkura kanyilkura, mayangka. Palunyangka palya wajarnu Puulmililuya walyjakajalu yankura nyakura, ka mirrkalurrju, wartakamu yungkurakuraya. ");
INSERT INTO mpj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ngulapula maaja Pilikijkamu palumili nyupa Turijila yanu jiilkarti Puulpa nyakukijalu. Maaja jiilura Puulku kurtingu palumili warrkamupurluka yankura mankuraku. Puulju-pulanya Jiijajmili wangka wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Puulju-pulanya wulu nintilpayi, martuluya Mamamili wangka kulilkura ka jungaya nyinakura, mirtaya walyjalu kulira nyinakura. Ngula Mamalu-jananya kuutjayuru kuru wajalku, martukaja yarnnga. Wangka palunya kulirnuka ngurlurringu, Pilikijpa. Wajarnulu, “Nyamu, maa yarra!, ngularnangku mirraku.” ");
INSERT INTO mpj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pilikijju wangka kujupawana kulirnu, “Mayitpirni Puulju mani yungku, jamparna kurtingku.” Palunyangka Maaja jiilura wululu Puulku kurtingkupayi palumili warrkamupurluka yankura mankuraku, wangkakuraku. Wululu wangkara kulilpayi, “Mayitpi Puuljurni mani yungku.” ");
INSERT INTO mpj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Wulu Puulpa nyinapayi tawun Jijariyangka, yiiya kujarrangka. Pilikijju Puulpa jiilja wululu kanyirnu, Juwukaja-jananya pukurlmankuraku. Palujanu maaja kujupa Pujiyaj Piijaj nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tawun Jijariyakarti maaja Pujiyaj Piijajpa yanurni jarrpangu, maaja-janampa palu nyinakijalu. Yupal wulikajangka karrpungka nyinangu ka tawun Jarujalumukarti yanu. ");
INSERT INTO mpj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","3","Puulpaya walyku jakurljunu, maaja Pijajja, Juwuku maajakajalukamu, yatily majukajalu. Palunyangka maaja Pijajjaluya wajarnu, Puulpaya Jarujalumukarti katira, kuutja ngarajunkuraku. Jaalpuya julyju yaka wangkangu, Puulpaya kutungka pungkukijalu. ");
INSERT INTO mpj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Maaja Pijajju-janampa wajarnu, “Puulpaya wululu kanyilkura tawun Jijariyangka. Ngularna marlaku yanku tawun palukarti. ");
INSERT INTO mpj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Palunyangka kujungkala yanku kuutkarti jiikarti wangkaraku. Jiingkanyurra nyunturtinju kuru wajalku, mayitpi walyku ngapinyjangka, Puulju.” ");
INSERT INTO mpj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Maaja Pijajpa Jarujalumja nyinangu wiiki kujungka, palunyangka marlaku yanu tawun Jijariyakarti, Juwukajalurrju. Palunyangka yungunarringu ka kuutja jarrpangu nyinapayi, ka wajarnu Puulpa kangkurakurni. ");
INSERT INTO mpj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Juwukajaya jiingka kuutja nyinapayi, Puulparni yanu. Palunyangkaya Juwukajalu kuru wajarnu, kuutja jilanya, wangka pakiwana yiltayuru parra wajalpayi. Mirtaya katingu kurulu nyakunyjanjanulu junga wajalkuraku, pakiya wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Palujanu Puulju wajarnu jilanya, “Mirtarna ngayulu minyjilypa junkupayi Juwukajaku luwu. Mirtarna-janampa jaaji maju minyjilypa junu. Mirtarna maaja maju yini Yukajajpa minyjilymanu, Ruumanmartajiku maaja, paki.” ");
INSERT INTO mpj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Palunyajanu maaja Pijajju kulirnu, Juwukaja-jananya pukurlmankuraku. Ka japirnura Puulpa jilanya, “Kunyjunyun kulini?, jantulwintikajaluntaya Jarujalumkarti kangkura marlaku, kuutjarnin ngayungka wangkaraku.” ");
INSERT INTO mpj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Palujanu Puulju wajarnu, “Kunyjunyurna yikini maaja Yukajajjkurnu kuutja ngaangka. Ngaangkarninyurra kuru wajalkura. Mirtarna-jananya Jarujalumungka Juwukaja walykumanu, jiikuran nyuntu ninti nyinani. ");
INSERT INTO mpj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Mayitpirna walyku ngapinyjangka palunyangkarninyurra mitu pungku. Pakiwanarniya Juwukajalu kuru wajarni, palunyangka mirtarnin Jarujalumukarti kurtiwa, Juwukajakarti!, paki. Ngayulurnanta japirni maaja Yukajajjarna kuutja yanku wangkakura.” ");
INSERT INTO mpj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Maaja Pijajju kulirnuka yanu-jananya wangkapayi, palumili warrkamupurlukakajangka. Palujanulu yanu Puulja wajarnu, “Japirnurnin Maaja Yukajajjan wangkakuraku. Nyamurnanta ngayulu kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Palujanu ngulapula maaja Yakiripapula Punija paluku jurtu, yanupula Jijariyakarti, maaja Pijajpapula nyakuraku. ");
INSERT INTO mpj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Karrpuparakungkapula palungka nyinapayi. Palujanu Pijajjulu maaja Yakiripangka jakurljunu Puulpa jilanya, “Yirna kuju Puulpa wulu nyinapayi, jiilja ngaangka, kuwarri wulu nyininpa, mirta maaja Pilikijju palunya kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Julyjurna Jarujalumukarti yanu. Palujanurniya yatily majukajalu Puulpa ngukarrinu, yirnakajalulurrju. Wajarnurniya Puulju julyju walyku ngapirnu. Palunyajanurniya wajarnu Puulpaya mitu pungkuraku, Juwukajalu. ");
INSERT INTO mpj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Wajarnurna-jananya jilanya, ‘Ruumanmartajilulaju mirta punginpa, kurranyilulaju kuutja murrarnilu kangkura yikijunin, mirtalaju-jananya karlkin kujupa yungkunin, pungkurakuya.’ Wajarnurna-jananya kuutjawiyajuya kuru wajalkura, jumaji Puulpa puntaju wangkakura. ");
INSERT INTO mpj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Palujanu Juwukajaya yanurni ka pipurrurna yanu kuutja nyinapayi. Karnara Puulku mirrangu kangkurakurniya. ");
INSERT INTO mpj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Puulpa yanu yikipayi, palunyangka mirtaya ngukarrinu jii walykukaja ngapilpayi, mirtaya wajarnu palunyalu ngulyulu mankupayikamu martukaja-jananya pungkupayi, paki. Palunyayuru kakanurna kulilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Warrkirnuya jumaji Juwuku luwu walykumalpayi, ka warrkilpayi-ngkuya Jiijajjamarralurrju. Julyju Jiijajpa jiinya miturringu, ka Jiijajpa Puulju wajalpayi mitujanu wankarringu.” ");
INSERT INTO mpj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Maaja Pijajjulu maaja Yakiripangka yarrarnu wajarnu jilanya, “Purturna ngayulu kulirnu, palunyangkarna Puulpa japirnu, wituka yankuraku kuutkarti, Jarujalumukarti, Juwukajaluya jiingka kuru wajalkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Puuljurni japirnu, maaja Yukajajkartilu yankura kuutja wangkakura. Japirnurni ngaangkaya jantulwintikajalu ngampurrju kanyilkura, ngulalu maaja Yukajajkarti yankuraku. Ngayurnara yuujunu.” ");
INSERT INTO mpj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Maaja Yakiripalulu wajarnu maaja Pijajja, “Ngayulurna kulilkura Puulpa.” Pijajju wajarnu, “Yuwa. Yungunpan kulilku.” ");
INSERT INTO mpj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Palujanu yungunpa maaja Yakiripakamupula paluku jurtu Punija jarrpangupula kulujungka kunyjunyungka, kapula yanu maajakarti. Jantulwintikajalu-pulanyaya katingu kintilu kuutkarti jarrpajunu. Kaya jantulkajamili maaja majukajalurrju jarrpangu marlakarti, tawun Jijariyamartaji maajakajalurrju. Palujanu maaja Pijajju wajarnu Puulpaya kangkurakurni. ");
INSERT INTO mpj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Puulpa yanu yikingu ka maaja Pijajju wajarnu jilanya, “Maaja Yakiripa, kulila, karlkinjulurrju! Nyawaya yirna ngaanya! Juwukajaluya ngaanya ngukarrinu walyku nyinapayi, Jarujalumumartajilukamu ngaamartajilu. Wiltulurniya wajalpayi ngaaya mitu pungkuraku. ");
INSERT INTO mpj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ngayulurna ngaangka japilpayi rawalu, karna kulirni mirtaya ngaanya mitu pungkuraku, jumaji mirta walyku ngapirnu. Ngaalurni japirnu, Puulju maaja Yukajajkartilu yankura kuutja wangkakura. Palunyangkarna kurtingkura maaja Yukajajkarti. ");
INSERT INTO mpj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Purturna kulini, ‘Yaalurnara mirlimirli wakalku?’ Mirlimirliraya maaja Yukajajkutu kangkura. Murrarnilulaju kurtingkuni mirlimirli maaja majukarti, kuutpurlukakarti, jampaya walyku ngapini. Ngaarnanta kangu Puulpa yikijunu, nyuntulun Yakiripalu Puulpa japilkura, ka kulilkurarna, palunyangkarna mayitpi walykukaja mirlimirlingka wakalku kurtingkura. ");
INSERT INTO mpj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ngayulurna purtu kulini Puulpa kurtingkuraku mirlimirliwinti. Purturna kulini nyaarnara wakalku, mirlimirlingka. Ngana walyku ngapirnu?” ");
INSERT INTO mpj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Maaja Yakiripalulu Puulja wajarnu, “Nyamu wajala!” Puulju maralu yuujunu wangkakijalu. ");
INSERT INTO mpj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Jilanya-jananya wajarnu, “Pukurlarrinparnangku nyuntuku maaja Yakiripaku, ngayukujun wangka kulilku. Wajalkurnanta Juwukajalurniya ngukarrini. ");
INSERT INTO mpj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ngayulurnanta kulini, nyunturan Juwumili luwuku ninti, murrarnilu-ngkuya warrkirninpa, palujanu japirnirnanta ngayumili wangkan kintilu kulilkura.” Puuljulu yarrarnu wajarnu maaja Yakiripangka, ");
INSERT INTO mpj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ngayurna jiji nyinapayi ngayuku ngurra walyjangka. Palujanurna Jarujalumungka nyinapayi, jilanyakujuya Juwukaja ninti nyininpa. ");
INSERT INTO mpj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ngayurna julyju Juwumili luwukurna junga nyinapayi. Juwu karlkinlurrjuya junga nyinapayi ka ngayurna jungaminyirri nyinapayi, Paraji. Yilta Parajikajalaju jungaminyirri nyinapayi jiiku, luwuku. Jilanyakuya Juwukaja nintijuya nyininpa, ngayurna Paraji nyinapayi. Kuutjaya jilanya julyju wajalngara. ");
INSERT INTO mpj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kuwarrirna yikini ngaangka jumajirna kulirni, martukajaya ngula mitujanu wanka pakalku. Jilanya Mama ngarnawarrapurlukalu-janampa jamartapungu mitunyjarriku. ");
INSERT INTO mpj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Juwukajala walyjakaja tuwal wulikaja nyininpa. Jiikajala wangka palunya kulini, yilta Mamalu-lanya ngula mitujanu wankalku. Wangka jilanyala kulini ka Mamala marninypungkuni wululu. Maaja Yakiripa, kulilarni! Wangka jiinyarna kulirni, palunyangka Juwukajalurniya kuru wajalpayi.” ");
INSERT INTO mpj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yarrarnu Puulju-janampa wajarnu, “Nyaanyurra kulini?, Mamalu-jananya mirta ngula mitujanu wankalku?” Yiltanyurra kulinngara. ");
INSERT INTO mpj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ngayulurna julyju kulira nyinapayi jilanya, ‘Palyarna-jananya Jiijajmili walyjakaja pungkura nyinapayi, Jiijajparna Najarijmartaji minyjilyjunkupayi.’ ");
INSERT INTO mpj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Palunyayururna kulilpayi. Tawun Jarujalumungka Jiijajmili walyjakajarna-jananya mankura jiilja jarrpajunkupayi, yatily majukajalurniya wajalpayi. Jiijajmili walyjakajaya kuutjaya yikipayi, palunyangka ngayulurna-jananya kujungkalulaju maajakajalulurrju, wajalpayi mituya-jananya pungkuraku, Jiijajmili walyjakaja. ");
INSERT INTO mpj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Juwumili jaajikajangkarna-jananya parra yankura mankupayi, karna-jananya jiilkarti katipayi, Jiijajmili walyjakaja. Marrkulpayirna-jananya mirtaya Jiijajpa marninypungkura, karna-janampa wirrilyirripayi. Tiwarna yankupayi tawun kujupatu tawun kujupakuturna-jananya wanara mankupayi, wirrilyiwintilu. ");
INSERT INTO mpj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Jilanyakurna tawun Tamajakajkartirna yanu, yatily majukajalurniya wajarnu yiyarnu.” ");
INSERT INTO mpj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Palunyangkalu Puulju wajarnu maaja Yakiripangka jilanya, “Maaja kulilarni! Ngayurna tawun jiikarti Tamajakajkarti yankupayi. Kintirrinyjalurna nyangu, layiti maju, karrpungka, rantarnu-lanyaju yiltaminyirri, ngarnawarrajanu, jirntuyuru. ");
INSERT INTO mpj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Parnangkalaju punkarnu ngarripayi. Kulirnurna Yipuru wangkawintilurni wajarnu jilanya, ‘Juulpa! Juulpa! Nyaakujun jurtarringu, ngayumili walyjakaja-jananyan pungkuninpa. Mirtan kulirnin walyjalungkun pungkuninpa.’ ");
INSERT INTO mpj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Palujanu ngayulurna wajarnu, ‘Maaja nganan nyuntu wangkinpa?’ Maajalurni wajarnu, ‘Ngayurna Jiijajpa, nyuntujun jurtarrinpa. ");
INSERT INTO mpj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Pakala yiki!, nyuntujun ngayuku warrkamupurluka nyinaku. Nyuntulu-jananyan yanku wajalku martukajangka, kuwarrirnin ngayu nyangu. Parra wajalku-jananyan ngayumili wangka. Wangka kujuparnanta nintilku ngula, wangka jiilurrju-jananyan parra wajalku. ");
INSERT INTO mpj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ngayulurnanta ngampurrju kanyilku Juwukajangkamarrakamu Juwuparningkamarra. Jiikajakartirnanta Juwuparnikajakarti kurtingku, ngayumilin wangka parra wajalkura. ");
INSERT INTO mpj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nintinmalpa-jananyan jiikaja Mamakuraya ngurrpa nyinajakukamu, malpuku maajakuraya nyinajaku. Nintinmalpa-jananyan Mamakuraya junga nyinakura. Ngayurniya Jiijajpa kulilku, palujanu Mamalu-jananya walykukaja warningku, palujanuya nyinakura Mamaku walyjakaja.’” ");
INSERT INTO mpj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Puuljulu yarrarnu wajarnu maaja Yakiripangka, “Maaja, kulila! Wangka jilanyarna ruutungka kulirnu junga, ka mirtarna kulirnu junu. ");
INSERT INTO mpj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Jungalurna-jananya yanu nintilpayi, Tamajakajmartaji. Palujanurna yanu Jarujalumungkarna-jananya nintilpayi, parna Juutiyawanalurrju. Palujanurna yanu ngurra kujupakajangka Juwuparningkalurrju nintilpayi. Jilanyarna-jananya wulikaja nintilpayi, ‘Walykuya jurra jungaya nyina Mamaku! Kunyjunyu-janampanyurra nyinakura, martu karlkinku.’ ");
INSERT INTO mpj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Jilanyarna-jananya parra wajalpayi, palujanurniya Juwukajalu manu mitu pungkukijalu, Jarujalumungka, jaaji majungka. ");
INSERT INTO mpj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mamalurni wululu murlpirrmaninpa, palunyangka kuwarrirna-nyurranya wajarninpa, ngurluparnilu maajakajangkakamu martukajangka. Mirtarna-jananya wangka kujupa parra wajalpayi, Muujajmili wangkakamu Mamamili jakurlpurlukakajaku wangkarna parra wajalpayi. ");
INSERT INTO mpj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Jiikajaluya Muujajjulurrjuya wajalpayi jilanya, ‘Kurayijpa yiltaya pungku mitu, ka pakalku wanka. Palunya kurranyi mitujanu pakalku, palunyayuruya palumili walyjakaja ngula pakalku, mitujanu. Yilta Kurayijpa wankarriku ka-jananya wajalku palumili wangkaya kulilkura martulu, kaya wanka wulu nyinakura. Jilanya-jananya wajalku, Juwukajangkakamu Juwuparnikajangka.’” ");
INSERT INTO mpj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Puulju jiinya wangka wajalpayi ka maaja Pijajju wajarnu wiltulu jilanya, “Puulpa! Nyuntun ngakumpa, Mirlimirlin nyuntulu wululu nyakura ngakumparrinin.” ");
INSERT INTO mpj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Puuljulu wajarnu maajangka, “Jungarna wajarni, mirtarna ngakumpa. Jungalurnanta wajarninpa.” Palujanu Puuljulu yarrarnu wajarnu maaja Yakiripangka, ");
INSERT INTO mpj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","“Yakiripa! Nyuntun wangkakuran palunyaku ninti nyininpa, palunyangkarnanta murlpirrju wajarni. Nyuntulu-jananyan kulilpayi jakurlpurlukakajangka palunyaya wajalpayi, jamparniya manu kanyilpayi.” ");
INSERT INTO mpj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Maaja Yakiripara japirnu, “Kaji-jananyan kulini wangka?, jakurlpurlukakajaluya julyju Mamamili wangkaya wajalpayi. Nintirnangku, yiltan nyuntulu Mamamili wangka palunya kulini.” ");
INSERT INTO mpj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Maaja Yakiripalura wajarnu, “Mirtarna Jiijajmili walyjarriku, pipurru kuwarri. Pakiwanan kulini nyuntulu.” ");
INSERT INTO mpj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Puuljura wajarnu, “Ngayulurna kulini nyuntun Jiijajmili walyja nyinakura, mayiti kuwarri, mayitpi ngula. Karlkin kujupalurrjuya ngaangka nyininpa, Jiijajmili walyjaya nyinakura. Ngayuyukunyurra nyinakura Jiijajmili, jirnmuntuparni. Jilanyakurna Mama japilku.” ");
INSERT INTO mpj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Palujanuya maaja Yakiripakamu Pijajpa, Punijalurrjuyila pakarnu yanu, karlkin kujupalurrjuya. ");
INSERT INTO mpj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pakaraya yawujayiti yanu, kaya wajalpayi, “Jiinya yirna Puulpa mirta walykukaja ngapirnu. Palunyangka mirta jiilja nyinakurakamu, mirtaya mitu pungkura.” ");
INSERT INTO mpj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Maaja Yakiripalulu wajarnu Pijajja, “Yirna jiilunta Puulju julyju japirnu, maajaminyirringkalu yankura wangkakura, kuutja, maaja yini Yukajajja. Jilanyanta mirta japirnu kali kuwarri kurtingkungara. Nyamu, maaja Yukajajkartili kuwarri kurtingku.” ");
INSERT INTO mpj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Parna Yitalikartiya Puulpa kurtingkuraku wajarnu, maaja majukarti yini Yukajajkarti. Puulpaya kujungka katingu yungu, maaja Juliyajja, karlki kujupalurrjuya jiirnmuntu. Juliyajpa jii maaja maju-janampa jantulwintikajaku. Martukajaluya wajalpayi jii jantulwintikajaya yini, “Maaja Yukajajmapu”. ");
INSERT INTO mpj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ngayurna-jananya Luukpa kujungkarringu Puulmapungka, kalaju yanu puutja tatirnu tawun Yaturamitiyamja. Puutpa jiinya yankupayi parna Yayijakarti. Takarnulaju kujungka yanu Yarajakajpa, parna Majatuniyamartaji. Palukura ngurra Jijaluniya. ");
INSERT INTO mpj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Yanulaju mungajarrarringu. Palujanulaju yanu tawun Jayitanja ka yungunpalaju jarrpangu. Palujanu maaja Juliyajjulu nyarrurringu Puulja wajarnu, yankura-jananya nyakuraku, palumili walyjakaja, mayitpi yungkurakuraya wartakajakamu, mirrkakaja. ");
INSERT INTO mpj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Palujanulaju puutja tatirnu yanu. Wangaljamarralaju yanu yirritingka parna Jayipurijwana wuungkuwana. ");
INSERT INTO mpj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Parna Jilijiyawanakamu parna Pampiliyawanalaju yirritiwana yanu tawun Marangka warinykatingu, parna Lajiyangka. ");
INSERT INTO mpj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Jantulwinti maajalu tiputingu yanu ngurrirnu manu, kujupa puutu, parna Yitalikarti ngarapayi. Puutu palu tawun Yalikijantajanu yankupayi. Maaja palulu marlakurringu-lanyaju manu kalaju tatirnu. ");
INSERT INTO mpj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kintilaju yanu karrpuparakungka, wangalkarti. Palujanulaju tawun Jintajja yitiwana yanu, ka parna Kuuritiwanalaju wuungkuwana yanu, wangaljamarra. Yanurranpalaju parna Jalamanwana. ");
INSERT INTO mpj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Parna yirritiwanalaju wulu kinti yankupayi parna kutu kujarrangka. Palunyangka jiingka wuungkungkalaju jarrpangu puutpa ngarajunu. Wuungku palunya yini ‘Piyipan’ ngarapayi. Palunyangka kinti tawun Lajiya ngarapayi. ");
INSERT INTO mpj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Jiingka wuungkungkalajura wulu majalpayi, jumaji wangalpa majuwarta wangkapayi. Wululaju majalpayi palujanu wantajarrakijalu. Murrarniluya puutpurlukalu kulilpayi, wuungkungkaya puutwinti majala, wangalpa ngula julirrinyjangkaya yankura kalyuwana. ");
INSERT INTO mpj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Palujanu Puulju-jananya marrkurnu jilanya, “Majalkurala ngulala yankura, jumaji wangalju-langku majulu yungkaljaku, palunyangka warlangku-lampa puutu, wartakajalurrju pakirrijaku, martukajalurrju.” Jilanya-jananya purtu marrkurnu. ");
INSERT INTO mpj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Jantulwintiku maajalu Puulja ngangkurnu junu, ka-pulanya maaja kujupa kujarra kulirnu, puutku maajakamu puut walyjajarra. ");
INSERT INTO mpj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Puutku warrkamupurlukakajaluya jilanya wajarnu, “Mirtala wulu ngaangka wuungkungka nyinakija, wangalju majulu-langku yungkaljaku, jumaji wuungku julijuli. Palyala mayitpi kuwarri yanku tawun Pinikijkarti. Jiingkalaju kunyjunyu wantajarra nyinamalpa, wuungkuwana.” Tawun jiinya parna Kuuritingka nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Wangal ngapartijanu kinti wangkapayi, palunyangkaya kulirnu, “Kunyjunyurringu, yankurala tawun Pinikijkarti.” Yayinpa jiinkurluya warrkamupurlukalu yilalpayi, kalyujanu, ka puutungka junu. Yayin palunyaya julyju warningu kalyungka puutpa-lampaju ngalulkura. Maalaju yanu kalyu majuwartangka parna Kuuritingka yirritingka. ");
INSERT INTO mpj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Yankupayilaju palunyangka wangal majulu-lanyaju yungkalpayi. Wangal palunyaya wajalpayi yini ‘Kayilikarta’. ");
INSERT INTO mpj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Purtulaju kayili yanu, wangal majulu-lanyaju yungkalpayi. Palunyangkaya puutu marlakurnu ka-lanyaju wangalju yurntura wanalpayi, marlaku. ");
INSERT INTO mpj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Murrarniluya puut majukajalu puutpa jukujukukaja yilarninpa, ruupwintilu. Ngapartilaju wulu yankupayi parna Kuutangka wuungkuwana. Wuungkuwanalaju yanu ka puutpa julijulilaju ruupuwintilu yilalpayi, marlakarti, kalaju takajunu karrpirnu junu puutungka, punkaljaku. ");
INSERT INTO mpj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Palujanu puutku warrkamupurlukaluya ruupuwintilu puutpa maju kultuwana karrpirnu ka tayimapurnu. Ka witukaya ruupu kujupawintilu kultuwana karrpirnu ka tayimapurnu. Ka witukaya ruupu kujupawintiluya kultuwana karrpirnu ka tayimapurnu. Jilanyaya karrpirnu, jumaji wangalju yungkara yaarrpungkujaku, kayila kurrungkujakulu kalyu, ka puutu jarrpajuljaku, kaninyjarra kalyungka. Kalikiya karrpirnu tipujunu, wangalju yungkaljakungkamarra, jumajiya ngurlulu jilanya kulirnu, “Mayitpi kaliki maju-lampa wangalju yungkaljaku, ka parnakarti-lampa yurntulku kangku, parna Lipiyakarti. Jiingka-lampa mayitpi warlangku puutpa.” ");
INSERT INTO mpj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kurluwa majulu-lanyaju pungkupayi, kaya karrpu kujupangka wartakajakamu mirrkakajaya puutpurlkakajalu warningkupayi, kalyungka, jumaji parliljaku puutpa ka jarrpajaku. ");
INSERT INTO mpj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Palujanu karrpu kujupangkaya warningkupayi ruupukajakamu puutmili wartakaja. ");
INSERT INTO mpj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kurluwalu majulu-lanyaju pungkupayi wululu. Ka puutu ngaa wangalju majulu yurntulpayi. Purtulajura jirntukukamu kurtalyakajaku nyakupayi karrpuparaku karrpuparakungka. Purtulaju kulilpayi, “Yiltalaju wankaparni nyinaraku, jumaji-lanyaju kurluwalu majulu pungkuninpa, pungkura-lanyaju kalyungka mitu jarrpajulkija.” ");
INSERT INTO mpj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Puutpurlukakajaluya warrkamurringu rawa ngalkuparnilu. Ka-janampa Puulju wajarnu, “Yirnakaja! Kulinngararninyurra ngayungka julyjurna wajalpayi, parna Kuuritingkala nyinangara wuungkungka. ");
INSERT INTO mpj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Wajarninparna-nyurranya kuwarri murlpirrpaya nyinama, pukurlpa! Mirtala miturriku, mirtala kalyungka kurrungku, wankala nyinamalpa, ngaanya puutuwiyaju-lampa warlangku kalyungka jarrpaku. ");
INSERT INTO mpj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mama ngarnawarrapurlukaju ngayuku maaja nyininpa, palunyarna marninypungkuni. Palunyalurni mungajarra palumili wikarru kurtingu. ");
INSERT INTO mpj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Jiilurni yutirringuka wajarnurni jilanya, ‘Puulpa. Ngurluparni nyinama!, yiltaminyirrin nyuntu maaja Yukajajja yikiku, Ruummartajingka. Palujanurna-jananya kujupakaja puutungka kalyungkamarra wankalkurna-jananya, wulikaja.’ ");
INSERT INTO mpj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","26","Yirnakaja! Ngarnkajanulurni, Mamamili wikarrulu wangka jilanya wajarnu, palujanu murlpirrpaya nyina!, ngayulurna kulirni Mamamili wangka yiltarriku. Wangal majulu-lanya katiku parnakarti.” ");
INSERT INTO mpj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Wiiki kujarrangkalaju puutungka yankupayi wuungkujanu tawunu Pinikijjanu, kurluwalu-lanyaju wululu pungkupayi. Kalyu jiinyaya yini wajalpayi, ‘Mititiriniyanpa.’ Palunyangkaya kutuwartini kulirnu puutpurlukakajalu, parna ngamurringu. ");
INSERT INTO mpj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Palujanuya ruupu yapuwinti warningu kalyungka, parnakuya pampulkuraku, mayitpi ngamurrini. Yilarnuya ruupu palunya, kaya miijaramunuya parnaku. Yanuya kaya wirrupungu marlaku ruupu kalyungka, ka marlakuya yilarnu miijaramunu, parna ngamurripayi. ");
INSERT INTO mpj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kulirnuya ngurlurringu, “Mayitpi puutulu yapukaja pungkujaku.” Palujanuya jiinpa yayinkurluya puu wulikaja warningu puutja marlakarti, parnangka ngalulkuraku puutpa. Palujanuya Mamangkaluya japirnu, jirntuya nyakuraku. ");
INSERT INTO mpj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Puutpurlukakajaluya Puutu japuwarta kalyungka tipujunu. Kajarnuya-jananya, “Yayinpa jiinwintilaju kurranyi katikija, puutukarti.” Jilanyaya-jananya kajarnu ngaampaya puutungka japuwartangka yankukija parnatu. ");
INSERT INTO mpj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Jiikaja-jananya nyangu Puulju ka jantulwintikajangka maajangkalurrju jakurljunu jilanya, “Jiinyaya puutpurlukakaja nyinaraku puutja ngaangka, warrkamurrira. Mirtaya parnakutu yankuraku. Pakingkangala wulikaja miturriku.” ");
INSERT INTO mpj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Palujanuya jantulwintikajaluya puutmili ruupu katupungu yiyarnu, jaalpu yanu martuparni. ");
INSERT INTO mpj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","34","Yaarlipalangka Puulju-jananya marrkurnu wajarnu, “Mirrkaya ngala!, wiiki kujarrangkanyurra wulu mirrkaparni yankupayi. Palujanuya mirrka ngala! Mirrkanyurra ngalku kanyurra kurrurnpa murlpirrarriku. Mirtanyurra ngurlurrira, murlpirrpanyurra nyinakura. Mirtanyurra miturriku, paki, kumurlparninyurra yanku.” ");
INSERT INTO mpj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Puulju palu wajarnu ka mirrka manu, ka Mamangkalu wangkangu marninypungu, ngalanguyila. Nyanguya wulikajalu, ");
INSERT INTO mpj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","kulirnukaya pukurlarringu kaya wulikajalu ngalangu. ");
INSERT INTO mpj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Jiingkalaju martu yarnnga nyinapayi, wulikaja jiirri yantartayuru. ");
INSERT INTO mpj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mirrkaya wulikajalu ngalangu kaya karlkinpa mirrka wilykikaja warningu puutjanu kalyungka, jumaji purtulyarrijaku puutpa. ");
INSERT INTO mpj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Jirntu pakanyjangka, puutpurlukakajaluya purtu parna yintalpayi. Jiingkaya nyangu karru majuwarta ngarripayi, kaya jilanya kulirnu, “Karru jiikutula puutpa katiku, ka jiingka parnangkala yikijunku.” ");
INSERT INTO mpj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Palunyangkaya jiinpa yayinwintikaja katupungu kaya junu yanu. Puutungka marlakarti warta yikipayi, puutpaya tarnamulkurakuranpa. Palunyaya julyju ruupuwintilu karrpirnu. Ruupukajaya palukaja katupungu, puutpaya tarnamulkuraku. Kaya kaliki yikijunu wangalju yungkalkura ka yurntulkuraku, karrukartiya palukarti yankukijalu. ");
INSERT INTO mpj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Yankuraya parnangka jarrpangu, mirtaya nyangu kalyungka ngururr ngarripayi. Puutu kurranyikarti parnalu ngalurnu ka marlakarti kalyulu yurnturnu yurnturnu warlangu. ");
INSERT INTO mpj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Palujanu jantulwintikajaya wangkangu jaalpu jirnmuntukajaya-jananya pungkuraku mitu, kalyungkaya jarrpara parnakarti yankura kaya kuku pinirrijaku. ");
INSERT INTO mpj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Jantulwinti maajalu-jananya marrkurnu mirtaya-jananya pungkuraku, Puulpalurrjuya pungkujakungkamarra. Maaja jiilu-jananya wajarnu, “Martukajayan nintikaja kalyuku jarrparaku, kurranyiyan parnakarti yankura, ");
INSERT INTO mpj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ka karlkin kujupayan kalyuku ngurrpa, marlayan tiputiku puutmili wartakaja ngalulku ka yanku.” Palujanulaju martukaja wulikaja yanu parnakarti, wankalaju wulikajangulyu. ");
INSERT INTO mpj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Parnangkalaju palungka yanu nyinapayi. Palunyamartajilu-lanyajuya nintilpayi jilanya, “Parna ngaanya yini Multa.” ");
INSERT INTO mpj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Palunyamartajilu-lanyajuya nyangu walyjarringu, ka-lanyaju kalyulu pungkupayi, kayilalaju yaltarringu. Nyarrurringu-lampajukuya ka waru-lampajukuya kangurni kujarnu, ka warungkalaju yikingu junpurrarringu. ");
INSERT INTO mpj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Puulju warukaja yanu manu kangu kujungka junu, jumaji warukaja kampangu japurringu. Warungka palungka kaninyjarra jila ngarripayi, ka pakarnu Puulpa pajarnu. Mara pajarnuka wulungulyu kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Martukajaluya jiimartajilu nyanguka-ngkuya wajarnu, “Mayitpi martu kuju pungu mitu ngaalu, kalyungka miturringara. Ngaanya kalyujanu wankarringu, kuwarringa miturringara jilajanu.” Jilanyaya murrarnilu kulilpayi, “Jilalu-lanya nintini, palunyangkala kulirninpa, ngaalu julyju martu mitu pungu.” ");
INSERT INTO mpj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Puulju marajanungku yurrijingarnu, ka jila warungka warningu, palunyangka wulu ngarntaparni yikipayi. ");
INSERT INTO mpj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Jiimartajiluya purtu majalpayi, nyaarta Puulpa punkalkura mitu. Mirta juurlaparringu. Purtuya majarnu kaya kulirnu, “Ngaanga ngarnkajanu, marturringu ka ngarinpa.” ");
INSERT INTO mpj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Palunyamartajiku-janampa maaja yini Papiliyajpa nyinapayi. Paluku kaatanmayakamu maya ngamu yikipayi. Maaja jiilu-lanyaju wajarnu palumili mayakartilaju yankura nyinakura. Jiingkalaju nyinapayi yupalja ngurrangka, ngampurrju-lanyaju kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Palumili mama ngarnta ngarripayi, parltiparlti ngarripayi, jurninyjirri. Puulpalu yanu mayangka palungka jarrpangu ka marangku junu, ka kunyjunyurringu palumili mama. ");
INSERT INTO mpj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","11","Palunyangka kunyjunyurrinyja jakurlpaya kulirnu, ka ngarnta kujupakajaluya Puulkarti yanu. Pampurnu-jananya kaya kunyjunyurringu. Wululu-lanyajuya wartakaja yungkupayi. Puutu kujupa jiingka yikipayi wantajarrangka rawa, puutu palunya Yalikijantaramartaji. Puutu jiinyaya yini wajalpayi, ‘Kurtararra ngarnkajanu.’ Multangkalaju wirlarra yupalja nyinapayi. Kalaju puutja jiingka tatilkijalu, ka-lanyajuya jiimartajilu pukurlwintilu mirrkakajakamu kukakajalurrju kangu puutja junu, yirnilu. Kalaju tatirnu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","13","Kalyuwanalaju yanu tawun Jarakurujangka warinykatingu. Tawun jiingkalaju karrpu yupalja nyinapayi, ka puutjalaju wulu yanu tawun Rijiyamakarti. Yungunpa wangalpa ngapartikarti wangkapayi, palunyangkalaju yanu karrpu kujarrangka tawun Putiyulingka warinykatingu. ");
INSERT INTO mpj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tawun jiingkalaju tiputingu yanu kalaju-jananya kujungkarringu, Jiijajmili walyjakajangka. Jiingka-lanyajuya japirnu kujungkalaju wiikingka nyinaraku, palujanulaju jiingkalaju nyinapayi. Palujanulaju yanu tawun Ruumkarti yankukija. ");
INSERT INTO mpj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Jiijajku walyjakajaluya kulirnu Ruummartajilu kaya yanu tuumaya yupalwana kujungkarringu-lanyajuya, tawun Yapipurumangka. Puulju-jananya nyangu ka pukurlarringu-janampa, Mama ngarnawarrapurluka marninypungu. ");
INSERT INTO mpj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Yanulaju tawun Ruumja warinykatingu. Puulpa mirta jiilja nyinapayi, maya kujupangka jaalpu nyinapayi, jantulwintilu kujulu ngampurrju kanyilpayi. ");
INSERT INTO mpj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Karrpu yupalja nyinapayi, palujanu Puulju-janampa wangka kurtingu, Juwukajaku, maajakajaku, yankurakurniya kujungkarriraku. Jiingkaya mayangka kujungkarringu, ka-jananya Puulju jilanya wajarnu, “Ngayuku walyjakaja. Ngayulurna mirta walyku ngapirnu. Mitunyjarrikurna-janampa luwu mirta putamanu, mirtarna Juwu kujupa nganarnpungu, paki. Pakikurniya jiingkamarra winirnu Jarujalumja. Jii jantulwinti maajalurni kuutja yikijunu, Ruumanpurlukangka maajangka. ");
INSERT INTO mpj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Maaja jiilurni kulirnuka wajarnu kurtingkurakurni. Jilanya wajarnu, ‘Puulju mirta puta walykumanu. Mirtaya Puulpa mitu pungkuraku, kunyjunyu yankuraku.’ ");
INSERT INTO mpj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Juwukajaluya Jarujalumumartajilu kulirnu, karniya wulu jankapayi. Palujanurna ngayulu japirnu maaja Yukajajkarti yankuraku, ngayumili wangka kulilkuraku. Maajangka jiingkarnalu mirta wajalkijalu, jiikajarna-jananya Juwukaja nyurnimankukija, jumajijuya ngayuku walyja. Kunyjunyurna jiinparni nyinakijalu wajalku maaja jiingka. ");
INSERT INTO mpj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Wangka jilanyanyurra kulilkurakurna-nyurrampa wangkapurluka kurtingu. Juwukajalara majarni Kurayijku, Mama ngarnawarrapurlukalu-lampa Kurayij jiinya julyju jamartapungu, kurtingkukijalu. Kurayij jiikurnara junga nyininpa, palunyangkamarrarniya jiinamunu. Kuwarri wulurna jiinwinti nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Palujanuya Juwukajalu Ruummartajilu wajarnu jilanya “Mirtalaju mirlimirli manu Juutiyajanu, nyuntumili. Mirtaya martukaja yanurni Juutiyajanu wajalkurakuya, nyuntulun puta ngapirnu, paki. ");
INSERT INTO mpj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nyuntumili wangkalajunta kulilkura. Jakurlpalaju kulirnu Jiijajmili walyjakajaya-jananya nyurnimani, ngurra kujupakamu ngurra kujupawana.” ");
INSERT INTO mpj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Jilanyaya wajarnu kujupangka karrpungkaya Puulpa kujungkarrira kulilkura. Jiingka jirntungkaya Puulku mayangka kujungkarringu, martukaja yarnnga kulilkurakuya. Puulju-jananya wululu nintilpayi ka mungajarrarringu. Nintilpayi-jananya Mamalu-jananya palumili walyjakaja ngampurrju kanyini. Yarrarnu-jananya wajalpayi jilanya, “Jiijajpa yilta Kurayijpa nyininpa, Mamalu julyju jamartapungu kurtingkukijalu.” Jilanya-jananya Puulju jakurljulpayi, Muujajju wajalpayikamu Mamamili jakurlpurlukalulurrjuya wajalpayi, jilanya Kurayijpa yiltangulyu ngula nyinaku. ");
INSERT INTO mpj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Puulmili wangkaya karlkinju kulirnu, ka karlkin kujupaluya mirta kulirnu, kulirnuya junu. ");
INSERT INTO mpj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","29","Puulju-jananya wajarnu mitunyjarripurlukamili Yayijayamili wangka jilanya, “Jungalu Mamamili Kuurtilu-jananya wajarnu, mitunyjarringka, wangka jilanya. Yayijayalu julyju mirlimirlingka wakarnu, ‘Martu ngaakajangka-jananya yarra wajala! Ngangkulkunyurra kuranju, palujanunyurra purtu jungalu kulilku. Nyakunyurra kurulu, palujanunyurra purtu yintalku. Yapuyurunyurra nyinaku purtunyurra jungalu Mamamili wangka kulilku, Mamamili wangkanyurra kulilku junku. Mirtarninyurra kulira japirni walykukajarna-nyurrampa warningkuraku, paki, walykukajawintinyurra wulu nyinakijalu kulirni.’” Jilanya Puulju-jananya wajarnu, palujanu-ngkuya ngaparrju warrkilpayi. Yarrarnu-jananya wajarnu, “Kulilaya! Kuwarri, Mamalu kunyjunyu kulirni Juwuparnilu wangka jiinyaya kulilkura. Kurayijpa maaja maju nyininpa kulilkuya junga nyinaku. Walykukaja-jananya warningku, Mamalu, ngarnawarrapurlukalu.” Juwu jiikajaluya kulirnukaya ngurrakutu yanu. ");
INSERT INTO mpj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Puulpa tawun Ruumja nyinapayi wulu, yiiya kujarrangka. Maya kujupangka payamura nyinapayi. Jiikartiya martukaja yarnnga yankupayi, palunya nyakura kulilkija. ");
INSERT INTO mpj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Nintilpayi-jananya martukajangka maaja Jiijaj Kurayijkurnu wangka, Mamalu-jananya ngampurrju kanyilkuraku, palumili walyjakaja. Jungalu-jananya wululu nintilpayi, mirtaya maajakajalu marrkulpayi. ");
INSERT INTO mpj_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Kurinyjimartajikuliju-nyurrampa ngaa mirlimirli wakara kurtingkuni, Puuljukamu Jaajanju. Mama ngarnawarrapurlukalurni Puulpa junu, Jiijajmili jakurlpurluka. Jaajanpalurrju nyinani Jiijajmili walyja. ");
INSERT INTO mpj_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Kurinyjimartajinyurra Jiijajmili walyjakaja nyinani. Mirlimirli ngaa-lijungkuya nyunturtinku wakara kurtingkuni. Yiltanyurra Mamamili walyjakaja nyinani. Mamalu-nyurranya julyju kulinu palumili walyjanyurra nyinaku. Wulikajalula ngurra kujupa ngurra kujupawanalu Mama ngarnawarrapurluka marninypungkuni, Jiijajmili walyjakajalu. ");
INSERT INTO mpj_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Mamalijura japini, palulukamu Jiijaj Kurayijjuntaya ngampurrju kanyilkura, pukurlpanyurra nyinakura. ");
INSERT INTO mpj_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Mamarna wululu marninypungkupayi, jumaji Jiijaj Kurayijpa-lampa kurtingu walykukaja-lampa warningkuraku. Karna Mama marninypungkupayi, jumaji Jiijaj Kurayijpanyurra Kurinyjimartaji kulinuka palumili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Jiijajju-nyurranya nintijuni, palumili wangkanyurra jungalu kuliraka jakurljunkuraku. ");
INSERT INTO mpj_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Julyjulajuntaya yanu jakurljunu Jiijajmili wangka, palujanunyurra kuwarri kulini jilanya, “Puulmapju-langkuya jungalu jakurljunkupayi, Jiijajmili wangka.” ");
INSERT INTO mpj_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ka Jiijajkunyurra junga nyinani, kayilapa Mamalu-nyurrampa kunyjunyu ngapini. Jiilu-nyurrampa wululu kunyjunyu ngapilku, jampa Jiijajpa marlaku yankurni. ");
INSERT INTO mpj_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Paluluntaya kanyilku junga wulunyurra nyinakura, jampa Jiijajpa marlakurriku. Kanyurra palu tayimu kunyjunyunyurra yikiku kuutja, mirta Mamaluntaya kuutja warrkilku kurtingku. ");
INSERT INTO mpj_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Jilanya-nyurranya Mamalu yiltalu kanyilku. Paluluntaya julyju kulinu, Jiijajmili walyjakajarayan nyinaku. Jiinga Jiijajpanga nyinani palumili kaja, maaja maju-lampa. ");
INSERT INTO mpj_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Walyjakajaluya wangka ngaanya ngangkula! Ngayulurnantaya Jiijaj Kurayijmililu walyjalu wajani kunyjunyungkunyurra nyinakura, mirta-ngkuyan warrkiraka wirrilyi nyinama!, warrkilparniya kujungka nyinama! ");
INSERT INTO mpj_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Wanti palu yini Kuluwi jiingka nyinani. Palumapuya nyinani jiingka Jiijajmili walyjakaja. Palumapujanurniya yupalju yanu jakurljunu, nyunturtinju-ngkuyan warrkiraka nyinani. ");
INSERT INTO mpj_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Jiikajalurniya wajanu. Karlkilunyurra wajani jilanya, “Ngayurtinpala Puulmili nyininpa, palu-lampa nintipurluka maaja nyininpa.” Kanyurra karlki kujupalu wajani jilanya, “Ngayurtinpala Yapulujmili nyininpa, palu-lampa nintipurluka maaja nyininpa.” Kanyurra karlki kujupalu wajani jilanya, “Ngayurtinpala Piijamili nyininpa, palu-lampa nintipurluka maaja nyininpa.” Ka karlki kujupalunyurra wajani jilanya, “Ngayurtinpala Kurayijmili nyininpa, palu-lampa nintipurluka maaja nyininpa.” ");
INSERT INTO mpj_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Karlkilunyurra nyunturtinju wajani, Kurayijmili walyjakajanyurra nyinin. Jilanyanyurra wajani “Kurayijpa-lampajuku ngayurtinku maaja nyininpa, ka mirta kujupakajaku-nyurrampa maaja nyininpa.” Pakiwananyurra jilanya kulini. Kurayijpa-nyurrampa wulikajaku maaja nyininpa, mirta nyunturtinkuwiyaju, paki. Karlkilunyurra kulini Puulkujuyan ngayumili walyjakaja nyininpa. Wanyjalpanyurra kulini?, kaji ngayurniya wartangka wiltijunu, miturrirarna-ngkuya?, paki. Kurayijwiyajuya jilanyanu. Wanyjalpanyurra kulini? Julyjuntaya nintipurlukakajalu kalyungka jarrpajunkupayi. Jampa-nyurranyaya kalyungka yikijunkupayi, kajirniya palukajalu yini ngayu wajanu?, maajarna-nyurrampa nyinakura?, paki, yini Jiijajwiyajuya wajanu, maaja maju-nyurrampa nyinakura. ");
INSERT INTO mpj_vpl VALUES ("C11_14","076_1_14","1CO","1","14","17","Yiipirna-nyurranya julyju yarnngaminyirri kalyungka jarrpajunngara, yarnngalurninyurra jilanya yini wajalngara, “Puulpa-lampa maaja nyininpa, jumaji-lanya kalyungka jarrpajunu.” Mirtarna-nyurranya yarnnga kalyungka jarrpajunu, paki, yupalwiyajurna-nyurranya jarrpajunu. Yininyurra Kirijpajkamu Kiyajpa, Japanajmapulurrju. Purturna kulini, mirtarna-jananya kujupakaja kalyungka jarrpajunu, paki. Yini Jiijaj Kurayijwiyajuya wajanu, jampanyurra kalyungka jarrpangu, mirtarniya yini ngayu wajarnu, paki. Mirtarni Kurayijju junu kalyungkarna-nyurranya jarrpajunkura, junurni palumili wangkawiyajurna parra jakurljunkura. Palujanurna pukurlju kulini, jilanya, “Mirtanyurra jiimartajilu Kurinyjimartajilu yarnngalu kulini, Puulju-lanya kalyungka jarrpajunu, paki.” Mirtarna-jananya martumili wangka martukajangka murlpirrju rawalu wajalpayi, paki. Jiijajjurni junu palumili wangkarna kintilu wajalkura, martukajaluya wangka yuti kulilkura jilanya, “Jiijajpa-lampa wartangka miturringu, walykukaja-lampa warningkura, yiipila kulilku, kala palumili walyjarriku.” ");
INSERT INTO mpj_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kurayijpa-lampa wulikajaku wartangka miturringu. Wangka jiingkaluya nintiminyirrilu parlanykajalu kuliraka jankani. Jiikaja-jananya Mamalu ngula warrkilku kurtingku. Kayilapala wangka jiinya ngayurtinju kulinu ka Jiijajmili walyjarringu, kayilapala jilanya kulini, “Yiltangulyu Jiijajpa-lampa miturringu, kayilapa Mama ngarnawarrapurlukalu-lampa maparn majuwintilu walykukaja warningu, Jiijajmili walyjakajalara nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Mamamili wangka kujupa julyjujanu jilanya nyinani, Karlkinjuya kulini Mamaku parlanykajalu jilanya, ‘Nintiminyirrila nyinani, kala-jananya karlki kujupangka jankani.’ Mamalurna-jananya jii parlanykaja kurlunga kurntajunku, ngurrpayuruya ngunjulpa nyinakura.” ");
INSERT INTO mpj_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ngayulu Puuljurna-nyurranya wangka ngaanya wajani. Karlkinjuya kulini jilanya, “Ngayurtinpala nintiminyirri nyininpa.” Kaya karlki kujupalu jilanya kulini, “Ngayurtinjula nintilu Mamamili wangka jakurljuni.” Ka karlki kujupaluya jilanya kulini, “Nintiminyirrila nyininpa, kaya kujupakaja puta, purtu kulilpa nyininpa.” Jiikajaluya pakiwana kulini. Kaya Jiikajaya purtu kulilkaja nyininpa mirtaya nintiminyirri nyininpa, Mamawiyaju nintipurlukaminyirri palukajangkamarra nyininpa. ");
INSERT INTO mpj_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Mamalu julyju nintilu jilanya kulinu, “Mamakuraya parlanykajalu nintiminyirrikajalu purtu kulilku, ngayukujuya walyjarriraku.” Mamalu wajarnu, Jiijaj Kurayijwiyajuya kulila!, ka palumili walyjarrikunyurra. Wangka jiinyaya parlanykajalu kuliraka jankani, kayilapala wangka jiinya nintilu parra wajani. ");
INSERT INTO mpj_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Juwukajalu-lanyajuya wajalpayi, “Mirtayan Jiijajmili wangka palunya wajala!, yalyjirr kujupa kujupaya ngapila!, Mamamili maparnwintilu.” Kiriki wangkawintilu-lanyajuya wajalpayi jilanya, “Mirtayan Jiijajmili wangka palunya wajala!, wangka kujupaya maju wajala!, nintipurlukalulaju kulira pukurlarriraku.” ");
INSERT INTO mpj_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Kalaju Jiijajmili wangkawiyaju parra wajalpayi jilanya, “Jiijaj Kurayijpa wartangka wiltiyikingu, walykukaja-lampa warningkura.” Juwukajaluya wangka palunya kuliraka parlanyarrini, kaya Kiriki wangkawintilu kuliraka wajani jilanya, “Jiinga wangka Jiijajmili yumuwanpa, wajala-lanyaju wangka kujupa majuwarta!, kulirakalaju pukurlarrira.” ");
INSERT INTO mpj_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Wangka jiinya Jiijajkura ngayurtinjulaju parra wajalpayi, kayilapaya Juwukajalu karlkilu kulinu, ka palumili walyjarringu. Kayilapaya jilanya kulini, “Mama ngarnawarrapurlukalu maparn majulu Jiijajpa kurtingu, maaja maju-lampa nyinakura.” Kayilapaya karlki kujupalu Kiriki wangkawintilu kulinu, ka Jiijajmili walyjarringu. Kayilapaya jilanya kulini, “Mama ngarnawarrapurlukalu nintiminyirrilu Jiijajpa kurtingu, maaja maju-lampa nyinakura.” Jiikaja-jananya julyju Mamalu kulinu palumili walyjaya nyinakura. ");
INSERT INTO mpj_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Martu karlkiluya pakiwana kulininpa, “Mama ngarnawarrapurluka mirta nintiminyirri nyininpa.” Ngayunjula kulininpa Mama ngarnawarrapurluka yilta nintiminyirri nyininpa, martukajangka wuupa. Martu karlkinjuya pakiwana kulininpa, “Mama ngarnawarrapurluka mirta maparn maju nyininpa.” Ka ngayunjula kulininpa Mama ngarnawarrapurluka yiltaminyirri maparn maju nyininpa, martu maparnwintingka wuupa nyininpa. ");
INSERT INTO mpj_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Walyjakajaluya wangka ngaanya ngangkula! Julyjunyurra Mamaku ngurrpa nyinapayi, kanyurra mirta nintiminyirrikaja nyinapayi. Martu kujupakajaluntaya jankapayi, nyunturtinjakamu nyunturtinmili pamulikajangkalurrju-jananyaya jankapayi jilanya, “Jiikajaya nyininpa purtu kulilkaja, mirtaya nintiminyirrikaja nyininpa.” Kayilapa yupalpanyurra palu tayimu maaja nyinapayi. ");
INSERT INTO mpj_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Palujanuntaya Mamalu kulinu, “Jiikajaluya purtu kulilkajalu ngayumili wangka kulinu, kaya walyjarringu.” Walyjakajaluya wangka ngaanya ngangkula! Jampanyurra palumili walyjarringu, kaya kujupakajalu nintiminyirrikajalu kulinu jilanya, “Nyaakuya jii purtu kulilkaja Mamamili walyja nyininpa?, ngayurtinpala nintiminyirrikajapalaji Mamamili walyja nyinangara.” Jilanyaya nintiminyirrikaja ngunjularringu. ");
INSERT INTO mpj_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Parlanykajaluntaya nintiminyirrilu nyanguka jankapayi, ka Mamaluntaya nyanguka manu, palumili walyjanyurra nyinakura, kaya parlanykajalu nintiminyirrikajalu jilanya kulinu, “Mamalu pakiwana kulilpayi, mirta-jananya jiikaja walykukaja, purtu kulilkaja mankungara, junkungara-jananya. Mama-lampa nintiminyirrikajaku pukurlarringara.” ");
INSERT INTO mpj_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Mamalu-jananya purtu kulilkaja nintijulpayi, palumili walyjaya nyinakura, mirta-jananya nintiminyirrikaja nintijulpayi, paki, jumaji-ngkuya ngula walyjalu marninypungkujaku jilanya, “Mamalu-lanya manu palumili walyja junu, jumajila nintiminyirri nyinani.” ");
INSERT INTO mpj_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Yiltanyurra nyinani Mamamili walyjakaja. Mama jiilu Jiijaj Kurayijpa kurtingu miturriraku-lampa, kalara palumili walyjarriraku. Jiijajju jiilu-lanya nintini Mamakulara junga nyinakura, kalara nintiminyirri nyinakura. ");
INSERT INTO mpj_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Yiipi martulu kulini marninypungkurangku, jurra!, ka Jiijaj Kurayijpawiyaju marninypuwa! Jilanya Mamamili wangka julyjujanu nyinani. ");
INSERT INTO mpj_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Walyjakajaluya wangka ngaanya ngangkula! Julyjurna-nyurranya mawu yanu nyinapayi, ka wajalpayi Mamamili wangka. Julyju wangka jii Mamalu mirta yutinu, paki. Ka palulu-lanyaju wajarnu wangkalaju jiinya yutilkura, ka parra wajalkura. Mirtarna-nyurranya rawalu martumili wangka nintilpayi, paki, kintilurna-nyurranya Mamamili wangka jii yutilpayi, ka nintijulpayi. ");
INSERT INTO mpj_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Jilanyarna kulilpayi, jilanyarnantaya nintijulkuraku, “Jiijaj Kurayijpaya wartangka wiltijunu, ka miturringu-lampa walykukaja warningkuraku.” ");
INSERT INTO mpj_vpl VALUES ("C12_3","076_2_3","1CO","2","3","4","Julyjurna-nyurranya kurranyilu nintijulpayi, palu tayimurna ngurlurripayi, karna tirritipungkupayi. Ngurrangkarna-nyurranya wangkakija, karna nyuri tirritipungkupayi. Kulilpayirna jilanya, “Mirtarna wangka maju wajalku, ngaakajajuya pukurlarriraku, paki, kintilurna-jananya wajalku, ka Mamamili Kuurtilu-jananya nintijulku paluwana.” ");
INSERT INTO mpj_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Palujanunyurra wangka jii kulinu ka Jiijajmili walyjarringu, mirta ngayumili wangkawiyajuyan kulinu, Mamamili Kuurtiluntaya nintinu. ");
INSERT INTO mpj_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Martu kujupakajaya rawa nyinapayi, Jiijajmili walyja, kaya palumili wangkaku nintiminyirri nyinani. Ngayulurna-jananya Mamamili wangka majukaja nintijulpayi. Wangka jiikaja majukajaya parlanykajalu purtu kulilku, kaya maaja majukajalu wangka jiikaja majukaja purtu kulilku. Jiikajaya parnangka nyinaku, ka pakirriku. ");
INSERT INTO mpj_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Mamamili wangkalajuntaya kujupa yutimani. Julyju wangka jii Mamalu mirta martukajangka wangka yutinu, paki. Jampa parnakamu ngarnka mirta nyinapayi, Mamalu kurranyilu kulinu, ngayurtinjula wangka jiinya kulira ka palumili walyja nyinakura. ");
INSERT INTO mpj_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Parnapurlukaluya maajalu mirta kulilpayi wangka palunya, paki. Yiipiya kulinngara, Jiijajpaya mirta wartangka wiltijunngara. Jiinya Jiijajpa-lampa maaja maju nyinani. ");
INSERT INTO mpj_vpl VALUES ("C12_9","076_2_9","1CO","2","9","11","Mamamili wangka julyjujanu jilanya nyinani, “Mamalu kulini kunyjunyulu ngapilkuraku, palumili walyjakajaku, mirta-janampa julyju jilanya Mamalu ngapilpayi, paki. Ka martukajalula purtu kulini yaalu Mamalu kunyjunyu ngapilku.” Yuu, Mamamili Kuurtilu-lanya nintijuni, Mamalu-lampa kunyjunyu ngapilkuraku. Jampala martulu walyjalu kulini, mirta martu kujupalu-lampaya ninti, nyaayurula kulini. Ka Mama ngarnawarrapurlukalu walyjalu kulini, kara palumili Kuurtilu nintilu kulini. Kuurti paluluntaya nyaakaja wulikaja nintini. ");
INSERT INTO mpj_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Kayilapa Mamalu-lanya Kuurti palumili jarrpajunu, palujanula kujupawana kulini junga nyinaraku, mirta pakiwana. Kala nintilu kulini jilanya, “Yilta Mamalu-lampa kunyjunyukaja ngapilku.” Mirtala parlanykajayurulu walykukaja ngapilkuraku kulini, paki, Mamakulara kulira nyinani. ");
INSERT INTO mpj_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Mamamili Kuurtilu-lanya nintini, jungala-jananya martukajangka wangkakura, mirta-lanya martu kujupalu jilanya nintini, paki. Martu karlkinpa-jananya Kuurtilu nintini, jampalaju-jananya jiikajangka Mamamili wangka maju jakurljuni, Kuurti jiilu-lanyaju nintini. ");
INSERT INTO mpj_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Yiipi Jiijajmili walyja Kuurtiwinti nyinani, palulunga nintilu kulini, Mamalu-lampa kunyjunyulu ngapilku. Ka karlkinja-jananya mirta Mamamili Kuurti nyinani, mirtaya kulini, Mamalu-lampa kunyjunyu ngapini, ngurrpaya nyinani. ");
INSERT INTO mpj_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Yiipi martu Mamamili Kuurtiwinti nyinaku, ka Kuurti palulu nintijunmalpa, jungalu wajalkuraku, jampaya kujupakaja ngunjulpa nyinamalpa. Martu jiikuraya Mamamili Kuurtiwintiku, Mamaku ngurrpakajalu mirta maajayurulu wajalkura. ");
INSERT INTO mpj_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Mamamili wangka julyjujanu jilanya nyinani, “Jampa Mama ngarnawarrapurlukalu walyjalu kulini, mirtala martulu palu nintilu kulini, paki. Mama palu mirta ngunjularrini, kala mirta maajayurulu palungka wajalkura, paki.” Yiltangulyu mirtala martulu palu nintilu kulini, jampa Mamalu walyjalu kulini. Ka Kuurtilu-lanya nintini Jiijaj Kurayijyurula kulilkura, ka palunyayurula ngapilkura. ");
INSERT INTO mpj_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Walyjakajaluya wangka ngaanya ngangkula! Mamaku ngurrpakajayurunyurra karlkinpa nyinani, palujanurna purtu kulini, yaalurnantaya nintijulkura. Purturna kulini, mayitpinyurra nyinani Mamamili Kuurtiwinti, mayitpi paki. Jiijajmili walyjakaja kuwarrijanuyurunyurra nyinani. ");
INSERT INTO mpj_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Julyju ngayulurnantaya wangka julijulikaja nintijunkupayi, kayilapa mirtanyurra Mamamili wangkaku kujupaku nintirripayi. ");
INSERT INTO mpj_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Wulunyurra nyinani Mamaku ngurrpakajayuru. Warrkirangkunyurra wirrilyirrini. Kujupakajaluntaya nyakuka kulilku jilanya, “Jiikajaya mirta Mamamili Kuurtiwinti nyinani, paki, Mamakuraya ngurrpa nyinani.” ");
INSERT INTO mpj_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Karlkilunyurra wajani, “Puulpa-lampa maaja nyinani.” Ka karlki kujupalunyurra wajani, “Yapulujpa-lampa maaja nyinani.” Jilanyaya Mamaku ngurrpakajalu kulini, maaja kujupa kujupakuya pukurlarrini, kayilapa-ngkuya warrkini. ");
INSERT INTO mpj_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Mirta-lijungkuya Yapulujkamu ngayu maaja maju nyinani, paki, Mamamili warrkamupurlukaliju nintipurluka nyinani. Jiijajmili wangkalijuntaya nintijulpayi, palujanunyurra nyinani, Jiijajmili walyjakaja. Jilanya-linyaju Mamalu warrkamu nintijunu, nyunturtinpalijuntaya nintijunkuraku. ");
INSERT INTO mpj_vpl VALUES ("C13_6","076_3_6","1CO","3","6","7","Kurranyilurnantaya ngayulu Jiijajmili wangka parra wajalpayi, ka marlaluntaya Yapulujju nintijunu, ka murlpirrmalpayi. Ka Mama ngarnawarrapurlukawiyajunyurra kulilkura. Paluluntaya nintinu palumili wangkanyurra kulinu, karayan palumili walyjarringu. ");
INSERT INTO mpj_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Ngayu kujarralulijuntaya nintijulpayi, mirtarna ngayu nintipurluka maju Yapulujja munkarra nyinani, paki, kujungkaliju nintipurluka nyinani. Ngula-limpajuku Mama ngarnawarrapurluka pukurlarriku. ");
INSERT INTO mpj_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Marlpararraliju nyinani kujungkaliju Mamamili warrkamu ngapini. Kanyurra nyunturtinpa Mamamili walyjakaja nyinani, paluluntaya ngampurrju kanyini. ");
INSERT INTO mpj_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kurranyirnantaya mawu yanu, karnantaya Jiijajmili wangka nintijunkupayi. Palujanu marlaluntaya nintipurlukakajalu kujupakajalu nintijunkupayi, kantaya murlpirrmankupayi. Yiipinyurra martu nintijunkuraku, nintipurlukaluya kintilu kulila jilanya!, “Jiijajmili walyjakajarna-jananya jungalu nintijunkura.” ");
INSERT INTO mpj_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Jiijaj Kurayijwiyajuya martukajalu kulilaka palumili walyjarri!, mirtarayan nintipurlukaku pukurlarri!, Jiijajkuwiyajuraya pukurlarri! ");
INSERT INTO mpj_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Jiijajmili walyjakajangka-jananyaya karlkinju nintipurlukalu kintilu nintijuninpa, ka karlkinju-jananyaya mirta kintilu nintijuninpa. ");
INSERT INTO mpj_vpl VALUES ("C13_13","076_3_13","1CO","3","13","15","Ngula Mamalu-jananya kuutja japilku yaaluya palumili wangka kujupakajangka nintijunkupayi. Yiipiya kintilu nintijunkupayi palujanuya martukaja walyjarripayi, ka-janampa Mama pukurlarriku. Ka yiipiya mirta karlki kujupalu kintilu nintijunkupayi, kaya mirta walyjarripayi, palujanu Mama-janampa mirta pukurlarriku, ka-jananya warrkilku. Mirta-jananya warukarti kurtingku, paki, nyarrurriku-janampa ka-jananya ngampurrju kanyilku. ");
INSERT INTO mpj_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Wangka ngaanyanyurra ngangkulkura! Mamamili walyjakajanyurra karlkinpa nyinani, kantaya Mamamili Kuurti nyinani. ");
INSERT INTO mpj_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Mama ngarnawarrapurluka junga nyinani, paluyuruyan karlki junga nyinani. Yiipintaya nintipurlukalu pakiwana nintijunku, kayilapa Mamalu ngula palu warrkilku kurtingku. ");
INSERT INTO mpj_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Wangka ngaanyanga yilta nyinani jilanya. Karlkinjuyan jilanya kulini, “Mamakuraya ngurrpakaja nyinani, karlkinpaya nintiminyirri nyinani. Palukajayurula nintiminyirri nyinani.” Mirtaya nintiminyirri nyinani, purtu kulilkajaya nyinani. Jiikajaluya kulinngara Jiijajmili wangka, kaya palumili walyjarringara. Palujanuraya Mamaku ninti nyinangara. ");
INSERT INTO mpj_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Mama ngarnawarrapurluka nintiminyirri nyinani, kayilapa palulu kulini, “Ngayuku parlanykajaya mirta nintiminyirri nyinani, purtu kulilkajaya nyinani.” Jilanya Mamamili wangka julyjujanu nyinani. “Mamalu-jananya parlanykaja ngula warrkilku kurtingku, jumajiya nintiluminyirri kulini-ngkuya walyjalu.” ");
INSERT INTO mpj_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ka Mamamili wangka kujupa julyjujanu nyinani jilanya. “Mamalu kulini, parlanykajaluya nintiluminyirri parnangka ngapiraka pakirrini.” ");
INSERT INTO mpj_vpl VALUES ("C13_21","076_3_21","1CO","3",