﻿USE sofia;
DROP TABLE IF EXISTS sofia.mph_vpl;
CREATE TABLE mph_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mph_vpl WRITE;
INSERT INTO mph_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Punyi God nuyi ta ngarrunmalkpany ta kanpani kapa yurrng. Ngarri ngarrungmiyarma ngarrkarrayirrk ngarrungpawurrun nuyi ta nukurlyak mira. ");
INSERT INTO mph_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngarri kurrunmiyarma ta kanguken ngarru. Ngarri ngarrungmiyarma amparrkamparrk wukarrayirrk kunak arrkpanamin tuka nuyi kungmiyarma, kapin wigarrayirrk kapa yurrng kamin tuka nuyi kungmiyarma. ");
INSERT INTO mph_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kurruntakajpun ngarrununi walij ta kayirrk. ");
INSERT INTO mph_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kurruntakajpun kungpaka ngarru ta nungmurrunti ngatpin la anpanarrapularngalk kirrk ta nungmurrunti, ngarri ngatpanarrapularlngalk ta nungmurrunti kamin ngarru. ");
INSERT INTO mph_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngarri kurruntakajpun arrkpayirtiki nuyu marrik ngatpi ta nungmurrunti, ngarri kurruntakajpun arrkpayirtiki ja kiwken manya marrik ngarruningulay ngarriyarru yanat. ");
INSERT INTO mph_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tukapa ta nungmalal ta ngaralk alaj Jesus Christ ja God inimalkpany. Tukapa ta ngungpanunma nuwurru. ");
INSERT INTO mph_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wularrut mira marrik Jesus ilurrangkena, God iminy nuyu ja arrarrkpi ingurlaj Isaiah ja inininy monmon God nuyu ta wulatpiyi animirrawung tuka jurra nuyu, “God iwanilangakaga ja arrarrkpi ja angpaningulakan nuyu. Nukapa ja arrarrkpi iwanini monmon nuyu la angpaningulakan nuyu la pata arrarrkpi awanalyu nuyu. ");
INSERT INTO mph_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wakapa iwalaja wu pata arrarrkpi pata kawani tuka karrape iwanamin pu, ‘Nuwurripa kurrkulinngulina! Warrwakapa ja God iwanaga kani tuka kunak la kutpawani orka. Kurrungpangula angkat nuyu ta alan.’” ");
INSERT INTO mph_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Malany ja Isaiah inininy monmon John ja aningurtpulukpuning pu. Kayirrk la God inilangakanka angpaningulakan nuyu Jesus. La John annyunmangung wu ta God nuyu ta ngaralk wu pata arrarrkpi. Yanatapa yarrangung tuka karrapey la iyarning manpurrwa iwunguliny ja camel iwiya la muj iyarning ingiri ja karrungmarluta. Yanat inilangung itpiyitpi la kakurl. Kayirrk la John inininy monmon pu pata arrarrkpi pata awaning karrapey. La iminy pu, “Nuwurri ta arrarrkpi kutpangulingulin angkat, kurrungarutpanyi ta aliwi ta kurrungatpi la kurrungpanatpi ta God nuyu.” Kayirrk la yanat iminy pu, “Malany ta nuwurri kutpamilkpungen kutpanarra rtil God la ngapi kurrunpawinypun ta wungurlyak ta ngungpangurtpulukpun nuwurru.” Malany muj pata ararrkpi pata awulinganka Jerusalem wakapa ta karrpin ta kunak ngaw Judea la muj pata tuwuran waka wiyu Judea awuranka amalkpany tuka karrapey wakapa awanalyu nuyu John. Pata arrarrkpi aminy nuyu ja John, “Ngarri ngarrungatpi ta aliwi.” Wakapa yanatapa aningurtpulukpuning wu tuka wumawurr ta wungurlaj Jordan. ");
INSERT INTO mph_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kayirrk la John iminy pu, “Nuka ja arrarrkpi kerraga ja nulawarrkurlyak mira. La ngapi marrik ngamalal la marrik ngawatping nuyu yurnu la ngertpirranyjing ja katiyarni yurnu nuyu. Ngapi ta marrik ngangurlyak mira. ");
INSERT INTO mph_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","La ngapi ngungurtpulukpun nuwurru wupaj la yanat angpaningurtpulukpun nuwurru ja Nyunyuk ja Iyarlmu.” ");
INSERT INTO mph_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Malany wakapa iwaning Jesus tuka wulijap ta kunak wungurlaj Nazareth kapa Galilee. Kayirrk ja Jesus annyarutpan ta kunak nuyu la yarrangung parak walem tuka wumawurr ngaw Jordan. La tuka John aningurtpulukpuning wu pata arrarrkpi wakapa. ");
INSERT INTO mph_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kayirrk la ja Jesus imalkpanyka wu ilatpan parak tuka wumawurr kayirrk la John aningurtpulukpung nuyu ja Jesus. Kayirrk la yurtinyka wawurri Jesus yukeny yurrng annyayawng antajing tuka yurrng la ilatpanka ja Nyunyuk ja Iyarlmu kapin rlumpuk ilatpanka tuka yanat ilangaling. ");
INSERT INTO mph_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kayirrk la yalyungan God inilakajpungka kapa yurrng iminy, “Nuyi ta ngapi kunmalkpany. Ngapi kunmiyarma mira la ngapi ngamin marrmarr nuwu.” ");
INSERT INTO mph_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kayirrk la ja Nyunyuk ja Iyarlmu inimany parak ja Jesus tuka karrapey. ");
INSERT INTO mph_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Malany wakapa iwaningan tuka karrapey warntatarr la ninguwu aniyarruning arntulyak 40 ta ngurrij. Malany ja yukenang pu pata weliwiyut ja ingurlaj Satan imalkpany nuyu Jesus yurtpiny ngilikilik nuyu. La ja Satan marrik inimiyarmanyi Jesus yalyunyi nuyu God. La yanat animiyarmangung iwanuken nuyu Jesus. La ja Jesus marrik animanyi nuyu ngaralk. Malany pata anpulirri pata kawarra mirlak awulangaling wakapa tuka karrapey kayirrk la God nuyu pata wingurlyakut pata kangkumaga wurluj awuranka iwayatayantung Jesus. ");
INSERT INTO mph_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kapapa ta kunak Jerusalem iwaning ja yukenang pu ja ingurlaj Herod. Malany yanat marrik inimiyarmanyi ja John la iwumany anpulirri iwumany parak iwarlguntiny iwaning iwutikinang. Kayirrk la Jesus imurnanganiny parak kapa Galilee annyunmangung pu ta nungmalal ta wurluj ta God nuyu. ");
INSERT INTO mph_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kayirrk la iminy, “Kayirrkapa la yanat God iwanamin ngarrurru ja yarakapju parang ja numalal Iwanuken ngarrurru amparrkamparrk. Nuwurripa kurralyunyi kutpamilkpungen la kurrungpayarrun God nuyu alan. Nuwurripa kutpamartukpun nuyu ta wurluj!” ");
INSERT INTO mph_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kayirrk la Jesus yarrangung tuka nungpanpal ta wurl kapa Galilee. Malany yukeny parak awunnyayawng ngarrkarrk pata arrarrkpi mampakangung mata panampi iwumangung kiyap. Tukapa ta wenat pu ta awuyamangung. Yarakap ja iwuwarnangajpuning Simon la ja jara ja awulingan akutju ingurlaj Andrew. ");
INSERT INTO mph_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wakapa Jesus iminy pu, “Arta, nuwulyanat, ngawu! Ngapi kurrunmiyarma kutpanaga arrkpanarra rtil. Ngapi kurrunmiyarma kurriwanawun larr yunyi muj kurrima ja kiyap la kurriwanama rtalk kutpunpanama arrarrkpi ngartu.” ");
INSERT INTO mph_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wakapa awarran parak Simon la Andrew mamparutpan mata panampi la awarrangung rtil warak Jesus. ");
INSERT INTO mph_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kayirrk la Jesus yarrangung ajputajput warak la yanat awunnyayawng ja nuwarlkparrakan ja arrarrkpi ingurlaj Zebedee la ngarrkarrk pata yanat awunimalkpangung akutju James la John. Wenat mampumany angkat mata panampi wu nuyu iwanama kiyap ");
INSERT INTO mph_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kapin wularrut iminy pu pata wera, Jesus ilajantiny pu pata James la John angparutpan kirrk ta awuyamangung iwuyarrung yanat. Wakapa awuran iwarutpan ja mayakpu la pata wera pata arrarrkpi pata awuyamangung rtil tuka kapala la iwuyarrung Jesus. ");
INSERT INTO mph_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus la pata ngarrkarrk la ngarrkarrk pata wurrwurr pata awarrangung rtil wiyu nuyu awuran tuka kunak wungurlaj Capernaum. La ta Saturday warntatarr ta Jew wu ta wungurlyak ngurrij, Jesus yuran tuka Jew awaning ngarlakarlak ta akurlyak kurrumpalk wakapa inimany rtalk ininnyang monmon pu God nuyu ta ngaralk wu pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Malany pata arrarrkpi awalyungan nuyu awurlkpalangkeny murnin Jesus ininnyang monmon pu manjat la aralpa ta ngaralk. La wenat angkuwurruning ta ininnyang monmon ta God nuyu ngaralk ta manjat parak. La pata Jew pata awunpukikang ta wulatpiyi marrik awunginkanyi iwulakurlanyi mira kapin tuka. ");
INSERT INTO mph_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kayirrk wakapa awaning ngarlakarlak, ja arrarrkpi innyatpang ja yaliwi ");
INSERT INTO mph_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ilajantiny parak, “Ngarrunarutpanyi, Jesus nuyi ta nukpuran Nazareth. Kunuka nuyu ngarruntuntu ngarri? Kurlingka nuyi ngarrunpanawun kirrk ta ngarri ta ngarraliwi pa ngatpamaju? Ngarri kurrunpurrun! Nuyi ta God nuyu ta nukurlyak arrarrkpi!” ");
INSERT INTO mph_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kayirrk la Jesus inilakajpung martapapa mira ja yaliwi “Ankakujpina! Anmalkpanyiga tuka yanat.” ");
INSERT INTO mph_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Malany ja yaliwi annyeny kirrkirrk nuyu ja arrarrkpi innyakan warntayurr. Malany iyirrurlkeny manilarraniny wakapa imalkpanyka tuka arrarrkpi la innyarutpan yuran. ");
INSERT INTO mph_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Malany pata arrarrkpi awulangaling iwayantung wakapa awurlkpalangkeny kirrk. Kayirrk la awunpulakajpuning la wemin, “Kiki kangmin parak? Nuka ja arrarrkpi kanyunma ta wurrwurr ta yanat kannyatpi ta nuntawarrkurlyak mira! Yanat kimin pu pata Satan kawuyama nuyu pata weliwiyut ‘Kutpamalkpa tuka arrarrkpi ingijalk la kutpana’ kayirrk la kamalkpa kawarra warak.” ");
INSERT INTO mph_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wigarra yirrk pata arrarrkpi awuran angpunmangung pu pata wera tuka kiki iminang ja Jesus. Malany pata awaning Galilee awalyungan ta kiki iminang. ");
INSERT INTO mph_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kayirrk la awaningan ngarlakarlak warrwak la Jesus awuran rtil warak Simon la Andrew tuka wenat wu ta kurrampalk. La James la John awuran rtil. ");
INSERT INTO mph_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Malany jita Simon ingawng waramumpik inymajung kuyak inyung tuka palapala. Malany pata arrarrkpi wakapa awaning rtil aminy nuyu Jesus alaj ta inyanatapa inymajung. ");
INSERT INTO mph_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Malany Jesus innyiyarrung parak tuka inyanat innyung atimany ngaw yurnu innyimajpungkuny. Malany wakapa akutju ja kuyak innyarutpan wakapa inyngulikingan. Inymajpungkiny pa akawunyangung walij awunngawng la wemin apuwany. ");
INSERT INTO mph_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Malany ta inyuriliny parak wurlmupurlmut wigarra yirrk pata arrarrkpi awuntumangung parak pata amajunmajung nuyu Jesus la muj pata weliwiyut awunnyatpang awuntumangung parak tuka Simon nuyu kurrampalk. ");
INSERT INTO mph_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wakapa wigarra akutju awaning yalayala tuka kurrampalk. ");
INSERT INTO mph_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Malany wakapa Jesus awuningulakantung wigarra yirrk pata arrarrkpi pata iwatpang jara jara ja kuyak. La inimalkpangung igarra yirrk ja yaliwi ja iwatpang pata arrarrkpi. La pata weliwiyut iwuwurruning ja Jesus ja God inimalkpany, la yanat iminy pu, “Kutakujpina marrik kurrkinkay!” ");
INSERT INTO mph_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kayirrk la ta nungmatpa ngurrij Jesus imajpungkiny ta warak iyirtpirrakenangka, jita muwarn marrik inymajpungkinaga la yuran anyarutpan ta kunak yuran palat iling iwarruj. ");
INSERT INTO mph_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Warrwak la Simon la pata wera amajpungkiny wenatapa iwuyalmangung ja Jesus. ");
INSERT INTO mph_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kayirrk la iwayawng la aminy nuyu, “Wigarra pata arrarrkpi kunpuyalma nuyi.” ");
INSERT INTO mph_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kayirrk la Jesus iminy pu, “Ngawupa, arrkpana! Ngapi ngana tuka nungmatpa kunak awk wakapa ngungpanunma wu ta nungmalal wurluj. Malany nungpakapa nguranka pa nganayama warak.” ");
INSERT INTO mph_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesus yuran yarrangung juju tuka karrpin ta kunak ngaw Galilee. La wakapa yanat inininy monmon pu God nuyu ngaralk tuka awaning ngarlakarlak ta akurlyak kurrampalk. La yanat innyakangung wu ja yaliwi wigarra yirrk pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Malany ja arrarrkpi animarrajpung warak tuka Jesus. La yanat innyatpang ja namurarri tuka ingiri. Yanat innyeny kartawarrkartawarr tuka Jesus ilangaling la angkat inilakajpukpuning, “Nganngulakanti!” Kayirrk la nukapa ja arrarrkpi iminy, “Ngapi ngungpurrun ta nuyi kungmiyarmang, nuyi nganngulajanyjing ngapipa.” ");
INSERT INTO mph_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Malany Jesus apa iniwurlkpungkuny ja arrarrkpi la iminy nuyu, “Ngapi ngungmiyarma kunpangulakan.” Kayirrk la Jesus imarreny iniwelkpung la iminy, “Nuyipa anngulikiny!” ");
INSERT INTO mph_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","La wakapa ja namurarri innyarutpan. ");
INSERT INTO mph_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kayirrk la Jesus inyarnangkatikiny iminy nuyu, “Ngapi marrik ngungmiyarmang nuyi kungunmay wu ta tukapa! La ngapi kunmiyarma nuyi anpana anpunpanuki ta nukiri pata kawuken wu pata Jewish arrarrkpi pata kawulangali mulil. Malany wenatapa kuntayan ta nuyi anngulikiny. La nuyi anpana tuka God nuyu ta nyunyuk kurrampalk la anpalangali mulil kuwawunya ja karlurri tuka Moses arrunyung murnin anngulikingan, la anpanamin nuyu God ta nungmalal mira. Malany yanatapa yarakapju ja karruningulakan. Tukapa ta ankingan mulil, pata amparrkamparr kuntayan la angkawurrun ja God iminy nuwu ta nungmalal.” ");
INSERT INTO mph_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","La ja arrarrkpi marrik imina tuka Jesus iminy nuyu. La yanatapa yuran la iminy pu amparrkamparr ja Jesus iningulikiny nungmalal. Warrwak apa pata arrarrkpi awalyungan ja arrarrkpi kayirrk la wenatapa awuranka wugarra yirrk kunak. Malany wimurra pata arrarrkpi awuranka nuyu Jesus marrik kiki imina la animarrajpuni warak palat tuka kunak makiny la yuran tuka karrapey. La pata arrarrkpi angkat awarrangungka wugarra yirrk kunak la amalkpany nuyu. ");
INSERT INTO mph_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Warrwakapa Jesus imurnanganiny parak tuka kunak wungurlaj Capernaum. Malany pata arrarrkpi awalyungan Jesus imurnanganinyka tuka kunak nuyu. ");
INSERT INTO mph_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wakapa wenat awarran parak iwayawng ilangaling tuka kurrampalk la angkuwung kulul la muj wimurra awulangaling yalayala akutju. Malany wakapa Jesus ilangaling wukej, ininnyang monmon pu arrarrkpi ta God nuyu ta wurluj. ");
INSERT INTO mph_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Malany yara pata arrarrkpi awuranka tuka kurrampalk ilij nuyu ja inimany pirl yung ilij japirri nuyu. La wenat angkumiyarmangung nuka ja arrarrkpi iwumanyi warak wanyjikap tuka Jesus wakapa Jesus iwaningulakan. ");
INSERT INTO mph_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Malany puka pata arrarrkpi awunpayawng wimurra pata arrarrkpi angkuwung rtal tuka kurrampalk. Kayirrk la wenat iwumany parak ja kimaju ja arrarrkpi tuka yurrng ta kurrampalk la angkuwung rturr. Kayirrk la ja arrarrkpi iwumajpungkuny ilij japirri iwakan tiyip parak wumarrk tuka antajing. Wakapa iwutpan tuka Jesus ilangaling. ");
INSERT INTO mph_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kayirrk la Jesus awunnyayawngka ta alaj amartukpung nuyu la iminy nuyu ja inimany pirl, “Nuyi kungpurrun ta aliwi anminang. Ngapi ngungpaka nuwu ta aliwi ta anminang la yanat God marrik iyintukuy nuwu. ");
INSERT INTO mph_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","La yara pata awunpukikang ta wulatpiyi wu pata Jew arrarrkpi awalyung nuyu Jesus inginkangung wu la angkuwurruning mira, ");
INSERT INTO mph_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Makiny, yanat marrik imi ta nungpakapa! Yarakapju parang God iwanginka iwanamin parak! Kimin mali yanat ja God. Yanatapa kiningula God kinyetpi wurwiny tuka kinginka!” ");
INSERT INTO mph_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Malany Jesus aniwurrung wu pata Jew arrarrkpi tuka angkuwurruning, kayirrk la iminy pu, “Kurlingka kurrungpurrun ta ngapi nganamin ja God marrik iyintukuy nuwurru murnin marrik nganti muj aniwurru ta ngapi ngimanma lagarr. La nuwurri ajirrik kurrungpurrun ta ngapi marrik ngami nuyu ja arrarrkpi ‘Anmajpungkina, kumanyi nuwu ja atjiyarrkarrk kungmarrajpuni warak kunak!’ la ta marrik imi inimang ja atjiyarrkarrk animarrajpu warak kunak arrarrkpi awanamin ‘Jesus ja kinima lagarr’. ");
INSERT INTO mph_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kayirrk ngapi kurrunpanuki ta ngawunpangulakan pata arrarrkpi la God akutju iminy ta ngapi nganarra pularnngalk kirrk ta nungmurrunti ta kutpinang la God marrik iyintukuy nuwurru. La muj kayirrk kurrunpaniki ngapi ta ngangurlyak mira nganilangakanka God la ngungatpi wutkut ta nungmalal la manjat ta ngaminy nuwurru. Akutju wutkut ngungatpi ta ngayama!” Kayirrk la Jesus yukeny innyayawng ja inimany pirl la iminy nuyu, ");
INSERT INTO mph_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngawu, anmajpungkina kumanyi nuwu ja atjiyarrkarrk la anngurakanyi!” ");
INSERT INTO mph_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nungpakapa ja arrarrkpi imajpungkiny iniwutikiny ja atjiyarrkarrk tuka awulangaling arrarrkpi la yurakan parak kunak. La iwayawng amparrkamparrk awurlkpalangkeny murnin Jesus iningulikiny. Kayirrk la awunpulakajpuning la wemin, “Arriwanawun ngij God ja numalal mira. La marrik wularrut arrungayanti ta ayuk!” ");
INSERT INTO mph_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Warrwakapa ja Jesus atjarutpan ta kurrampalk yarrangung juju warak tuka angarilil ngaw wurl. La puka pata arrarrkpi pata tuwuran ilurrngarni awangkungka nuyu, la yanatapa angkat ininnyang monmon pu. ");
INSERT INTO mph_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pata Roman arrarrkpi awukenangapa ta kunak wu wakapa la wenatapa awuyamangung pu pata Jew arrarrkpi la iwumangung ja tax rrupiya la inimangung ja Roman arrarrkpi ja yukenang pu. La yarakap ja arrarrkpi iyamangung wu pata Roman arrarrkpi ja ingurlaj Levi, la ja inimalkpany ingurlaj Alphaeus. Wakapa Jesus yarrangung parak la innyayawng Levi la iminy nuyu, “Ngapi kunmiyarma arrkpanarra rtil nuyi. Ngawu, nganpayarrun ngapi!” Kayirrk la imajpungkiny ja Levi la awarrangung rtil warak Jesus. ");
INSERT INTO mph_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wakapa ta arukaruk ta apulangung walij, Jesus la pata awarrangung rtil wiyu nuyu, la wimurra pata arrarrkpi akutju, apulangung ta walij tuka Levi nuyu ta kurrampalk la muj apulangung wimurra pata arrarrkpi akutju pata awuyamangung iwumangung ja tax rrupiya, la wera pata arrarrkpi apulangung rtil la marrik angkuwurruni ta God nuyu. ");
INSERT INTO mph_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kayirrk la pata Jew arrarrkpi pata awunpukikang ta wulatpiyi, la pata awukenang ta wulatpiyi wu pata awuntuwarnangajpuning Pharisees, iwayawng Jesus apulangung rtil walij pata arrarrkpi. La pata awukenang wulatpiyi awunpulakajpung pata Jesus awarrangung rtil wiyu nuyu, “Kunuka nuyu Jesus kapula rtil walij pata arrarrkpi marrik angpuyarru warak ta God nuyu?” ");
INSERT INTO mph_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","La ja Jesus yalyungan pu, la iminy pu, “Kutpanalyu ta ngapi ngungpanunma nuwurru - puka pata arrarrkpi pata kamaju kiwumiyarma ja marrgijpu, la arrarrkpi pata marrik amajung marrik iwumiyarmang ja marrgijpu. La ngapi ngamin nuwurru ngapipa ta kapin marrgijpu. La nuwurrri kutpin mali puka pata arrarrkpi kamin ta nungmurrunti, la ngapi ngatpayirtiki awamilkpungen angkayarrun ta nungmalal. Nuwurri ta kutjama kurrima tax ja rrupiya atjirrik kurrungpurrun kutpin mali marrik kutpi ta nungmurrunti warak la marrik ngapi atjirtiking!” ");
INSERT INTO mph_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","La pata Pharisee pata awukenang wulatpiyi wu awulakuwuning ta walij murnin angpuyarruning ta wulatpiyi wu la yanat John ja aningurtpulukpuning pu pata awarrangung rtil la yara wenat akutju awulakuwuning. Malany yara pata arrarrkpi awuranka nuyu Jesus la iwulakajpung yanat, “Kunuka nuyu puka kapula akut ta walij pata nuyi nuwu pata kurrara rtil la pata Pharisees la John ja kaningurtpulukpun wu pata kawarra rtil wiyu nuyu yara kawulakuwun?” ");
INSERT INTO mph_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kayirrk la Jesus iminy “Ta mulil ta awanaga awanurlgen pata jawirna nuyu ta alaj inypanima la yamin apanatpi ta walij apanala rtil yanatapa ja arrarrkpi. Kapin ngapi akutju. Ngapi kani akutju ngawani la pata jawirna ngartu kamin marrmarr ta ngatpani rtil ngarrata. ");
INSERT INTO mph_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Malanypi pata arrarrkpi ngantanama warak ngantanawun warrwak la pata jawirna ngartu ngawunpawurlkpungku la awalakuwun ta walij.” ");
INSERT INTO mph_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kayirrk la Jesus annyunmangung pu tuka awunnyukikang. La iminy pu, “Kapin ta kotping iwugi ja pajupaju ja yarlangke marrik kumangka kwirrkpu ilij ja wurrwurr ja manpurrwa. Malany ta kuwawinypun nakapa iwanarlangken la ja pajupaju ja numurrunti marrik anjarning. ");
INSERT INTO mph_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","La muj tuka ta karrunta ta wurrwurr naka marrik arrungpu rlaw ja pujurlung ja imi rtapartap. Wakapa tuka karrunta nakapa kanti jir la kanya yirrk! Malany karrungpulawn parak ja wurrwurr ja pujurlung. La ta wulatpiyi wu pata Jew arrarrkpi la tuka ngapi kurrunukiki marrik angpartawkunyjili.” ");
INSERT INTO mph_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Malany puka pata Jew arrarrkpi angpatpang jirl ta wungurlyak ngurrij, la Jesus la pata awarrangung rtil wiyu nuyu awarrangung juju warak tuka apuyurlkangung walij. Wakapa wenat awarrangung parak wakapa amajungan wirrngak la apumany ta wanpirlk la apuwany. ");
INSERT INTO mph_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","La pata Jew arrarrkpi pata awukenang wu iwayawng Jesus la pata awarrangung rtil wiyu nuyu la marrik amina marrmarr. La wenatapa iwuluntuny ja Jesus aminy nuyu, “Nuwurripa ta kurrunjarrun nungmurrunti warak! Kayirrkapa ta Jew wungurlyak ngurrij la tukapa ta wulatpiyi ngarrurru. Parangapa la wenatapa apumangung ta wanpirlk tuka atjurjinang. La pukapa pata awuyamangung! Wenatapa angpukpung ta wulatpiyi!” ");
INSERT INTO mph_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kayirrk la Jesus iminy pu wenat, “Arta! Kurrungpurrun ta ngungpanunma ta wularrut ja King David ja yukenang pu la pata arrarrkpi nuyu. La wakapa ja Abiathar ja yukenang ngarrurru ta wulatpiyi. Malany David la pata arrarrkpi nuyu amajungan wirrngak, ");
INSERT INTO mph_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","kayirrkapa la David yuran yurlgeny tuka God akurlyak kurrampalk atimanyka ta akurlyak ta walij. La wenatju parang pata kawuken ta wulatpiyi wu pata Jew arrarrkpi kapula ta akurlyak walij. La David la pata arrarrkpi nuyu apuwany ta walij, la nungpakapa angpukpung ta wulatpiyi ngarrurru ta Jew arrarrkpi! La God marrik iyintukuna wu.” ");
INSERT INTO mph_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kayirrk la Jesus iminy pu, “Kurralyunyi ngartu! God nuyu ta wungurlyak ngurrij pata arrarrkpi wakapa kangpaka wirrngak, la marrik angpuyarru warak ta wulatpiyi! ");
INSERT INTO mph_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nungpakapa nungmalal ta alaj apumany ta wanpirlk pata jawirna ngartu, ngapi ta ngangurlyak ta God nganilangakanka. Ngapi ta nguken ngarrurru ta Jew wungurlyak ngurrij akutju!” ");
INSERT INTO mph_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Malany Jesus yurlgeny tuka iwarruj kurrampalk ta Jew wu wungurlyak ngurrij. Wakapa yarakap arrarrkpi iwaning ja apartipartiyi yurnu tuka kanimarratpi. ");
INSERT INTO mph_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Malany yara pata arrarrkpi pata awukenang ta wulatpiyi wu iwayantung mira ja Jesus. La angkumiyarmangung iwayanti ta iningulakanti ja arrarrkpi ta Jew wu wungurlyak ngurrij. ");
INSERT INTO mph_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Malany Jesus iminy nuyu nakapa ja arrarrkpi ja apartipartiyi yurnu tuka kanimarratpi iminy, “Anmajpungkina ankangalinga kani tuka kapal kuntayan wigarra yirrk.” ");
INSERT INTO mph_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Malany Jesus iminy pu pata arrarrkpi pata awukenang pu ta wulatpiyi wu, “Wularrut ta wulatpiyi angputpan anyung wu ta wungurlyak ngurrij. Kurlingka nungmalal ta karrunjarrun? Kurlingka aliwi ta karrunjarrun? Kurlingka ngapi ngiwangulakan ja arrarrkpi nungmalal kurlingka ngiwanawun?” La puka pata arrarrkpi Jew pata kawuken marrik muj kiki amina. ");
INSERT INTO mph_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kayirrk la Jesus yukeny awunnyayawng la ilirrinyminy la muj iwuwurlkpungkuny murnin awunnyayawng marrik awuntuwurruni pata arrarrkpi. La wenatapa angkuwurruningju ta wularrut ta wulatpiyi wu. Kayirrk la Jesus inginkan iminy nuyu ja apartipartiyi yurnu tuka kanimarratpi, “Anmarrena!” Malany ta imarreny akulikingan nuyu yurnu kayirrk la ingulikiny nungmalal kirrk. Malany ja arrarrkpi atjutpan ta yurnu nuyu wakapa ingulikingan. Kayirrkapa yanat ta yurnu nuyu marrik muj apartipartiyi. ");
INSERT INTO mph_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Malany pata awukenang ta wulatpiyi wu iwarutpan awuran amalkpany pu pata jawirna nuyu ja yukenang pu Herod. Kayirrk la awaning ngarlakarlak aminy pu la wemin, “Arriwanawun Jesus.” ");
INSERT INTO mph_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wakapa la Jesus la pata awarrangung rtil wiyu nuyu awuran tuka wurl ta karrkpin. ");
INSERT INTO mph_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Malany pata arrarrkpi iwuyarrungka yirrk awk pata tuwuran Galilee la Judea la Jerusalem la Idumea la muj iwuyarrungka pata tuwuran kinymalkpa muwarn Jordan wumawurr la muj pata tuwuran nungmatpa kunak awk wungurlaj Tyre la Sidon. La pukapa pata arrarrkpi awalyungan ta Jesus iminy pu la angkumiyarmangung iwayanti tuka iminang. ");
INSERT INTO mph_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Nungpakapa ta warntatarr Jesus awuningulakantiny wimurra pata arrarrkpi nungmalal. Kayirrk la wigarra akutju iwumiyarmany iwetpa Jesus awuningulakanti. Warrwak la wigarra yirrk mira pata arrarrkpi iwulirrngkakantiny wanyjikap tuka yanat, makiny la iminy pu pata awarrangung rtil wiyu nuyu, “Kurrimanyi angkat ngartu ja kapala. Kapin ta wenat ngantalirrngkakan angkat nakapa nganalurrangken tuka kapala.” ");
INSERT INTO mph_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","La yara pata arrarrkpi iwatpang yaliwi tuka wingijalk pularr wu. La wenatapa iwayantung ja Jesus pata weliwi wakapa anyeny kirrkirrk wu pata arrarrkpi mawarlkanyiny kirrk tuka Jesus ilangaling, aminy nuyu, “Nuyi ta kunimalkpany God.” ");
INSERT INTO mph_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","La ta awulajantung awuniluntuny ja Jesus iminy pu, “Kutakujpina!” Kayirrk la iminy pu, “Yunyi kutpin pu ngapi ta God nganimalkpany.” ");
INSERT INTO mph_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Malany Jesus yuran tuka murrgu la ilajantiny pu arrarrkpi pata awunimiyarmany. Malany wenat iwuyarrung parak tuka ilangaling. ");
INSERT INTO mph_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Kayirrk la awunimany 12 arrarrkpi pata awanarra rtil wiyu nuyu pata wingurlyakut. La iminy pu, “Ngapi kurrunmany pa atpanarra rtil la muj kurrunpalangaka kurriweni monmon pu. La muj God kurrunpannyun wutkut ta kurriwaka wu ja yaliwiyut.” La yanat awuniwarnangajpuning puka pata Wingurlyakut Pata Kawarra rtil Kawunilangaka Kawuyama Nuyu. Ta Apostles takapa arakap ta karrungparnangajpun. ");
INSERT INTO mph_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","La pukapa pata 12 arrarrkpi Jesus awunimany. Simon - ja Jesus innyung jara ja ingurlaj Peter. James la ja awulingan John - pata awunimalkpangung Zebedee. Malany Jesus awunnyung wingurlaj “Marrarawk arrarrkpi” murnin anpulirri arrarrkpi. Andrew, Philip, Bartholomew, Matthew, Thomas, James ja Alphaeus inimalkpany, Thadeus, Simon - ja arrarrkpi ja awunnyarnamangung pata Roman wimunpimun pata iwuwarnangajpuning Zealot, la Judas Iscariot - ja arrarrkpi ja awuniyarruning parak pata tumatpa wiwalu la awuyirtikiny tuka iwumany parak ja Jesus iwutikinang. ");
INSERT INTO mph_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Malany Jesus yuran yurlgeny tuka kunak la wakapa awaning iwumirlajuning pata napulurrumpi. Malany Jesus la pata awarrangung rtil wiyu nuyu marrik muj apulanyi ta walij - murnin wimurra mira pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Malany nganti yirrik yuran iminy pu pata yanat witparlarrut, “Naka kinima kalajarr.” Kayirrk la puka pata witparlarrut awuranka iwumanyi warak tuka kunak la iwayatayan. ");
INSERT INTO mph_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Malany yara pata awunpukikang pata Jews wu ta wulatpiyi pata tuwuran Jerusalem. La wenat awuranka la aminang mali naka ja yaliwi ja Beelzebul ja jara ja ingurlaj Satan ja yukenang pu ja yaliwiyut kiwani nuyu Jesus. Kayirrk la aminy pu la wemin, “Naka ja Kiwken pu ja yaliwi kinnyun wutkut Jesus tuka kinnyaka wu ja yaliwiyut.” ");
INSERT INTO mph_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Malany Jesus aniwurruning ta aminang pata awunpukikang ta wulatpiyi wu. Kayirrk la Jesus ilajantiny wu la iminy pu, “Ngawu! Kurralyunyi ngartu!” Kayirrk la anyunman pu la inininy monmon wu ta manjat la aralpa, “Kurlingka ja Satan ja kiwken pu pata weliwiyut, yanat piyu iwu iwularr? Nungpakapa marrik imi ta tukapa. ");
INSERT INTO mph_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kurralyunyi ngartu! Malany puka pata arakap pu kunak kawunginka kawunparnama la wemin awawunjilin awarlartpalililmin awamirtjilingken kirrk. ");
INSERT INTO mph_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nungpakapa akutju pata puka pata witparlarrut kamin, kapin ta awunginkay nakapa apijarlangkey marrik muj awunpatping la wemin pata witparlarrut. ");
INSERT INTO mph_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kapin ja Satan la pata weliwiyut kawunginka la kawunparnama la wemin pata weliwiyut, malany yanatapa iwarlartpalililmin wakapa angpana yirrk nuyu ta wutkut! Wakapa marrik muj imi. Nuwurri marrik kurrungpurru mira.” ");
INSERT INTO mph_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kurralyunyi ngartu! Nukapa ja arrarrkpi animiyarmany iwalangali wumpulaj nuyu ja nulatparlangat ja arrarrkpi tuka kurrampalk. Kayirrk la inimany iniwutikiny werrk ja nulatparlangkat warrwakapa la yanat inimany kirrk awk tuka yanat nuyu ja arrarrkpi ja nulatparlangkat. La nungpakapa ta ngungunma nuwurru ja Satan nakapa ja nulatparlangkat la ngapi kapin ja arrarrkpi ja iniwutikiny. La ja Satan la pata yanat nuyu wenatapa awulatparlangkayin la wenatapa marrik ngarrurri ngarrurru. Malany kayirrkapa ngapi ngawunma warak ngartu pata arrarrkpi tuka awaning awunnyatpang yanatapa. ");
INSERT INTO mph_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","La ngapi ngamin nuwurru aralpa! Puka pata arrarrkpi aliwi awanamin la muj iwanini monmon God ta nungmurrunti ta ngaralk warrwakapa la awawurlkpungku nuyu tuka awanamin ta aliwi awk la tuka awanginka ta nungmurrunti ngaralk la yanat angpanyaka wu ta nungmurrunti. ");
INSERT INTO mph_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Malany ja Nyunyuk Iyarlm kiwani tuka ngapi ngangijalk. La kapin nganti ja iwanginka nungmurrunti ta ngaralk nuyu ja Nyunyuk ja Iyarlmu kapin imi, ‘Satan kinnyun ja Nyunyuk Iyarlmu ta wutkut’, nungpakapa angkat angkanatpi ta nungmurrunti marrik muj anjarrkpujili wu ta aliwi parang la God iwayintukun wu la wenat angkanatpi ta nungmurrunti akut la akut. ");
INSERT INTO mph_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Malany Jesus iminy pu nungpakapa murnin yara pata Jews pata awunpukikang ta wulatpiyi wu aminang naka yaliwi kiwani nuyu. ");
INSERT INTO mph_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Malany Jesus inyalkpany nuyu la pata awulinganut awuranka tuka annyunmangung pu. Wenatapa iwulangakan yarakap iwanima Jesus iwamalkpaga la awunpanilakajpun. ");
INSERT INTO mph_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wakapa wimurra pata arrarrkpi awaning iwuwurlngan aril Jesus awalyung nuyu. La pata arrarrkpi aminy nuyu, “Jita nuyi inyalkpany nuwu la pata nuyi kutinganut kawulangali yalayala la kunpuyalma nuyi.” ");
INSERT INTO mph_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Kayirrk la Jesus yukeny awunnyayawng pata arrarrkpi awaning wakapa la iminy, “Nganti jita ngapi inyalkpany ngartu la warra nganti pata ngapi ngatinganut?” Kayirrk la yukeny awunnyayawng pata arrarrkpi awaning iwuwulngan aril la iminy, “Kutpunayanti puka pata ngapi awalkpangung ngartu la pata ngapi ngatinganut. ");
INSERT INTO mph_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nganti ja kimartukpun nuyu God pukapa pata ngapi ngatinganut arrarrkpi la warramumpik la puka pata awalkpangung ngartu”. ");
INSERT INTO mph_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Malany Jesus yarran parak tuka wurl inimany rtalk awunnyukikang. La wakapa pata napulurrumpi pata arrarrkpi iwuwulngan aril awanalyu nuyu. Malany wimurra pata arrarrkpi la Jesus yarran parak ilatingan tuka kapala la yuran ap. Wakapa iwulirrngkantiny parak awuran ap tuka wawurri pata awaning awalyung nuyu la ininyang monmon wu. ");
INSERT INTO mph_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wakapa yanat annyunmangung pu la awunnyukikang wugarra tuka iminang pu. Kayirrk la Jesus annyunmangung pu, yanat iminy, ");
INSERT INTO mph_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nuwurripa kurralyunyi ngartu. Nuka ja arrarrkpi atimiyarmany apaniyurlka wanpirlk ");
INSERT INTO mph_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Malany ta innyakakan tuka kunak yara yuran yurrjurr tuka alan. Malany awuranka karlurri iwuwany kirrk ja wanpirlk. ");
INSERT INTO mph_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","La yarrangung juju ja arrarrkpi innyakangung akutju la yara yangkung yurrjurr tuka waryatparyat tuka kunak anyung anyak la wakapa waryatparyat anyung. Malany apalkpanyka ta aparligaj murnin marrik annyunyi wumurra ta kunak la anyung wumurra ta waryat. Malany inyakatakan imurranyminy ja wanpirlk kayirrk la ta inymajpungkinyka jita muwarn apelkpiny ta aparligaj la apajungan murnin mata mamarligaj marrik angena ta kunak awarranyi warak wukej. Malany ta apalkpanyka ta aparligaj apelkpiny. ");
INSERT INTO mph_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","La nukapa ja arrarrkpi yarrangung akutju la innyakangung yara ja wanpirlk la yangkung yurrjurr tuka wikulk ilangaling. Malany ta apalkpanyka ta aparligaj la atiwutikiny nakapa wikurl pa marrik muj apalkpanyi ta wun ngaw. ");
INSERT INTO mph_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","La yara ja wanpirlk innyakangung naka yangkung yurrjurr tuka nungmalal ta kunak tuka apalkpanyka ta aparligaj la apurranyminyka la akatpang apurra ta wun ngaw yara 30 la yara 60 la yara ngarrkarrk kurlajuk. ");
INSERT INTO mph_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kayirrk la Jesus iminy, “Kurralyunyi nuwurri kutpatpi larlngalk kurrungpawurrun ta ngapi ngamin nuwurru.” ");
INSERT INTO mph_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Malany Jesus awunnyarutpan pata napularrumpi iwaning. Malany yanatapa la pata 12 wingurlyakut pata awarrangung rtil wiyu nuyu la wera pata arrarrkpi awaning rtil. La iwulakajpung aminy nuyu, “Kulakulanyi mira ngarru tuka kungunmangung ngarru.” ");
INSERT INTO mph_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","La Jesus iminy pu, “Nuwurri ta karrara rtil, nuka ja God kanimiyarma ta nuwurri kurrungpawurrun mira ta ngapi ngilakuliny nuwurru. Tukapa ta kannyunma ja God ja Kiwken ngarrurru amparrkamparrk. La wera arrarrkpi pata marrik muj ngapi nganpuyarru, wenatapa marrik angkumang la awalyung. Kayirrkapa marrik ngungunmay wu ta kanyu ta wulatpiyi. ");
INSERT INTO mph_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wakapa ngamin murnin kanyu warak ta wulatpiyi tuka God nuyu ja jurra kanyunmaga ta aralpa mira: Nungpakapa awanuken pata arrarrkpi. Angkayan la marrik angkumiyarmang angkuwurru ta ngapi ngamin pu. Kapin ta awanalyu ta ngapi ngamin pu naka marrik muj angkumiyarmang angkumang mira ta wulatpiyi nuyu God. La kapin ta awalyung, angkuwurru mira ta ngapi ngamin pu la amilkpunge nuyu God, nakapa yanat annyakay wu ta aliwi awk kamin. Parangapa la marrik angkumiyarmang angkuwurru ta nungpakapa. ");
INSERT INTO mph_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kayirrk la Jesus angkat ininnyang monmon pu. La yanat iminy, “Kurlingka marrik kurrungpurru mira ta ngungunmangung nuwurru? La ta marrik kurrungpurru mira nakapa nuwurri marrik kurrungpurru ta ngiwalakula nuwurru ta kayirrk. ");
INSERT INTO mph_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","La tuka ngungunman nuwurru, arrarrkpi ja innyakangung wanpirlk atiyurjiny ta walij. La tukapa kapin ja arrarrkpi kanyunma tuka God nuyu ta wurluj pa awanalyu pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Malany tukapa ta ngungunman, ja wanpirlk yuran yurrjurr tuka alan, la ta kunak nakapa arnangkat, malany wakapa ja wanpirlk yung yurrng. Malany marrik muj mamalkpanyi mata mamarligaj mata wurrwurr. La kapin nukapa ja wanpirlk kannyunmaga ta God nuyu wulatpiyi. La wera pata arrarrkpi marrik awalyung nuyu God. Malany nungpakapa kangpuyarrun ta arnangakat ta alan. La puka pata karlurri kapin yaliwi ja karriwarnangajpun Satan. La yanatapa kiw ngilikilik wu wakapa wenat kawarra pularlngalk ta ngaralk nuyu ja God. ");
INSERT INTO mph_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tukapa ngungunmangung nuwurru ta kunak nakapa waryatparyat kirrk. Malany kapin arrarrkpi pata kamin marrmarr kawalyu nuyu God wulatpiyi la wenatapa kamartukpun kirrk nuyu. ");
INSERT INTO mph_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","La muj puka pata arrarrkpi kamartukpun ta wulatpiyi nuyu la wera kangpungula wu lirri. Wakapa wenatapa kiwuwun larr marrik muj awalyung ta wulatpiyi. Wakapa wenat kamilkpungen kiwun kirrwara la kangkumarrajpun parak kangparutpa God nuyu ta wulatpiyi. ");
INSERT INTO mph_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tuka ngungunmangung nuwurru ja arrarrkpi innyakangung ja wanpirlk tuka wikurl mata angawuning rtal wakapa marrik apalkpanyi la apurranymina. Kapin pukapa pata arrarrkpi pata kawalyu nuyu God ta ngaralk, ");
INSERT INTO mph_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kayirrk la wenat wiyu kanima put wu ja yaliwi. Malany wakapa wenat kangkuwurrun wumurra mira ta wenat wiyu wu akutju. La wenat muj kiwuwurrun rrupiya ja kawunyaka-arlarlng. La wenat kiwumiyarma akut ja jara ta wu wiyu wakapa kiwuwurrun marr. La muj kangkuwurrun parak ta wenat wiyu wu wakapa kanima put wu ta God nuyu ta ngaralk, la nungpakapa puka pata arrarrkpi marrik iwarnartpikping mira ja God. ");
INSERT INTO mph_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tuka ngungunmangung, ja wanpirlk ja yuran yurrjurr tuka nungmalal ta kunak imurranyminyka nungmalal, la mata mamaligaj mamurranyminy karrkpin la mangatpang wanpirlk mata wurrwurr. Tukapa kanyunmaga pata arrarrkpi wularrut kawalyu nuyu God ngaralk tuka yanat kiminka ngarrurru. La puka pata arrarrkpi kapin mata mamarligaj mata mamurranyminy mangatpang mamurra mata warnpirlk.” ");
INSERT INTO mph_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","22","Jesus iminy pu, “Kapin nganti yirrik ja manimangka mata kangayirran naka marrik mannyutpay tuka panikin arta? La muj marrik mannyutpay wukej tuka palapala arta? Kapin atputpay yurrng angpayirran yalayala pa arrungayanjing. Tukapa kangmin ta God nuyu ta ngaralk. Yara marrik kurrungpurru akutju la God kutpayirtiki rtil nuyu kurrungpawurrun. La yara kangparlunjin marrik kurrungpurru la God kutpayitiki rtil la kurrungpawurrun akutju. ");
INSERT INTO mph_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nuwurri kutpatpi larnngalk tuka kurralyu ngartu la kurrungpanama ngartu ngaralk.” ");
INSERT INTO mph_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","La muj Jesus iminy pu, “Kutpanalyu mira ngartu la kurrungpawurrun tuka kurralyungan. Kapin ta kurralyungan ta wurluj nakapa God kutpayirtiki kurrungpawurrun mira tuka yanat parak la kutpayirtiki tuka kurrungpawurrun mira tuka yanat nuyu ta wulatpiyi. Kapin ta marrik kurrungmang mira ta wurluj tuka ngamin nuwurru nakapa God marrik kutjirtiking kurrungpurru mira.” ");
INSERT INTO mph_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","La muj Jesus awunnyukikang la iminy pu, “Ngapi ngungmiyarma ngungpanunma nuwurru tuka nuwutpurra kutpanurlgenka nuyu ja arrunimalkpany God. La kayirrk ngungpanunma nuwurru ja arrarrkpi animiyarmany atiyurjiny wanpirlk ta walij pa innyakakangung ja wanpirlk tuka kunak. Yara yuran yurrjurr tuka kunak kayirrk la yarran parak la innyarutpan ja wanpirlk. Kayirrk la apalkpanyka ta aparligaj atjanat piyu ja arrarrkpi marrik aniwurruni ta kunuka atingulangung apurranyminang la nakapa God atingulangung apurranyminang. Mata wanpirlk ta walij nakapa apurranyminy aparligaj werrk awarntulyakpiny kayirrk la apalkpanyka wun ngaw. Malany awurrurtpiny kirrk pa awuranka pata arrarrkpi apulalkuny ta aparligaj la apumany ta wun ngaw. God ja kiwken ngarrurru la arrarrkpi pata kamartukpun nuyu nakapa awanurlgenka nuyu wigarra yirrk kapin ja wanpirlk tuka kayirrk ngungunmangung nuwurru.” ");
INSERT INTO mph_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kayirrk la Jesus iminy pu, “Ngapi ngungpurruning tora ta ngungpanunma nuwurru tuka kurrungpawurrun mira tuka arrarrkpi pata arrunimalkpany God nuyu. ");
INSERT INTO mph_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","La kayirrk parak God nuyu arrarrkpi kapin wanpirlk ja ilijap. La kurrungpurrun mata walurru ja wanpirlk ilijap mira arta? ");
INSERT INTO mph_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Malany ta kiwuyurka nakapa kapalkpa ta aparligaj kayirrk la kawarntulyakpin ta karrkpin warrwak ta kamamurranymin mata karrkpin mira la kamangatpi magarra mata mamawurr wularr. Malany pata karlurri awk kawaga kangpungula kunak la kawani mawngkumawngku. Nungpakapa kangmin parak wu pata God nuyu arrarrkpi ta awungalme.” ");
INSERT INTO mph_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Jesus inilakulangung pu tuka iminang pu pata arrarrkpi. Wakapa Jesus la pata awarrangung rtil wiyu nuyu awaning palat ininnyang monmon mira wu ta wulatpiyi. ");
INSERT INTO mph_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wakapa akutju Jesus awunnyukikang pata arrarrkpi la jita muwarn wularrut inyurying parak la yanat angkat ilatikinang tuka kapala. Pa ilakujpiny tuka awunyukikang la iminy pu pata awarrangung rtil wiyu nuyu, “Arrungpanawun pirl wurrkaraga.” ");
INSERT INTO mph_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Malany yara awunparutpan pata arrarrkpi warrwak la pata awarrangung rtil wiyu nuyu angkuwuning parak angkuwuning pirl wurrkaraga. Yara pata arrrarrkpi awulatingan tuka kapala ja jara awk pa awunpuyarruning parak. ");
INSERT INTO mph_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Malany wakapa orka marlu apukpangung ta natatparlangkat pa ta wupaj awunngawuning la antatinang parak ta wupaj tuka kapala. Wularrut yarlgenang parak ja kapala. ");
INSERT INTO mph_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus yurnparrang tuka wurlun la aniwalkariny ta wanji tuka palungang. La pata awarrangung rtil wiyu nuyu amurtpiny pa iwikpung la awulajantung aminy nuyu, “Oy! Nuyi ta Ngarrunukiki, ngarrurripa arrkpanarlkan la nuyi marrik ngarrunpurru! La kiki anmina warak!” ");
INSERT INTO mph_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus imajpungkinyapa la ilarrajpany kayirrk la inginkan iminy ngaw ta marlu la marrngarla, “Anjintuna!” Parangapa la angpung mapurlarr marrik muj kunuka iyirrnguna. ");
INSERT INTO mph_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus iminy pu pata awarrangung rtil wiyu nuyu, “Kunuka nuyu kutpurtpin? Kurlingka marrik kutpartukpu ngartu?” ");
INSERT INTO mph_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pata awarrangung rtil wiyu nuyu amurtpiny mira la aminy pu la wemin, “Arta kurrayanti! Ta inginkan ta marlu la marrngarla amartukpung nuyu! Yanat ja Nulawarrkurlyak mira!” ");
INSERT INTO mph_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu angkuwuning pirl warak amalkpany wurrkaraga tuka kunak ngaw Gerasenes. ");
INSERT INTO mph_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","5","Wakapa iwaning ja arrarrkpi innyatpang yaliwi. La yanat inimany kalajarr. Nukapa ja arrarrkpi iwaning tuka kunak tuka awunpuyurlkangung. Yarran wularrut mira warntatarr la wupurrk, yarrangung juju tuka yurk la murrgu ilajantung la iwuning yanat piyu waryat. La marrik nganti innyanartpikpa ta algaj iwutakangung ja wirlmurr. La yanat iwutpan nuyu ja wirlmurr la innyartpirrrakantung ja wirlmurr la innyukpukpuning tuka winti nuyu la innyukpukpung kirrk. Malany ja Jesus ilurrangkenyka tuka kapala ilarrajpany ");
INSERT INTO mph_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","la ja arrarrkpi innyayawng ilangalingka warakapa la ingurrinyka mawarlkenyiny tuka Jesus ilangaling. ");
INSERT INTO mph_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","La Jesus iminy nuyu ja yaliwi, “Anmalkpanyiga korutpanyi ja arrarrkpi, nuyi ta nuwaliwi.” Yanat ja yaliwi ilajantiny la iyirrurlkeny, “Kunuka nuyu annguranka? Ngapi kunpurrun. Nuyipa Jesus. Nuyi ta kunimalkpany God. Yanatapa ja kiwken kirrk ngarrurru. Aralpa anpanamin ngartu la yunyi nganpun!” ");
INSERT INTO mph_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kayirrk la Jesus inilakajpung, “Nuyi nganti nukurlaj?” Ja yaliwi iminyka, “Ngapi ngangurlaj Ngatpurra mira, la ngatpurra mira ngarrulgeny tuka arrarrkpi imarrk.” ");
INSERT INTO mph_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pata weliwiyut awurlkpungkang angkat aminang nuyu, “Yunyi ngarruntangaka warak ta kunak.” ");
INSERT INTO mph_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","La wakapa awulangaling 2000 pikipiki, awulangaling apulantangung tuka wanyji murrgu. ");
INSERT INTO mph_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","La aminy nuyu pata weliwiyut, “Ngarruntangakanyi ngatpanurlgen tuka pikipiki.” ");
INSERT INTO mph_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus iminy pu, “Ee.” Kayirrk la pata weliwiyut amalkpanyka tuka arrarrkpi imarrk awurlgeny tuka wimurra pata pikipiki awulangaling tuka murrgu. Wakapa awungurriny parak angparlukpan jirrjirr tuka wurl ta karrkpin la angkuwany marnngalk. ");
INSERT INTO mph_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pata arrarrkpi pata awunpayatayantung pata pikipiki amurtpiny awungurriny parak kunak angpunman pu amparrkpamparrk. Wenatapa aminy pu pata arrarrkpi pata awaning kunak la kunak la kapa karrapey. Amparrkamparrk iwakatakan parak wu wiyu angpayawng. ");
INSERT INTO mph_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kayirrk la wenatapa awungurriny parak tuka kunak wakapa tuka Jesus ilangaling. Wenatapa iwayawng ja arrarrkpi iwaning malakpuj la iyarning manpurrwa. Kayirrk yanatapa marrik muj inimanyi kalajarr la muj. Kayirrkapa pata arrarrkpi amurtpinang. ");
INSERT INTO mph_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pata arrarrkpi awunpatpang pata pikipiki angpunman pu pata wera ta wurluj tuka nukapa arrarrkpi la pikipiki. ");
INSERT INTO mph_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Warrwakapa pata arrarrkpi aminang nuyu Jesus, “Anyanyji ngarrunarutpanyi ngatpalangali palat.” ");
INSERT INTO mph_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus yalyungan pu la ilurrangkeny tuka kapala. Kayirrk la ja arrarrkpi ja innyatpang yaliwi inilakajpung Jesus iminy nuyu, “Arrkpanarra rtil nuyi.” ");
INSERT INTO mph_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Parang la Jesus iminy nuyu, “Makiny, anpana anpamurnangani tuka pata nuwutpalanparlarrut. La kungpanunma wu anpanamin pu ja God iyamany nuwu.” ");
INSERT INTO mph_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Malany ja arrarrrkpi yarran parak ta nungpanpal kunak ta wungurlaj Wurrkamaj Yurnu la Wurrkamaj Yurnu ta Kunak anyunmangung pu amparrkamparrk ta wurluj. Kayirrk yanatapa annyunman pu ta iningulakantiny ja Jesus. Wakapa amparrkamparrk pata arrarrkpi awurlkpalangeny. ");
INSERT INTO mph_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu angkuwung pirl warak wurrkaraga tuka wurl. Malany wakapa iwumirlajuning pata napulurrumpi pata arrarrkpi tuka ajput. ");
INSERT INTO mph_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Malany ja arrarrkpi ingurlaj Jairus yuranka imalkpany pu. Yanatapa ja yukenang pu Jew arrarrkpi wakapa tuka awaning ngarlakarlak ta iwarruj kurrampalk. Kayirrk la innyayawng Jesus la yarran parak wanyjikap la inyukpung ngarlwak tuka yanat. ");
INSERT INTO mph_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kayirrk la iminy nuyu ja Jesus “Kinymaju mira jita ngapi nginymalkpany la ngungpurrun inypamaju. Ngungmiyarma kunypanatpi jita ngapi nginymalkpany nuyu inypangulikin.” ");
INSERT INTO mph_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kayirrk la Jesus awuran rtil warak ja Jairus la pata napulurrumpi pata arrarrakpi iwulirrngkakantung parak ja Jesus. ");
INSERT INTO mph_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wakapa tuka angkumarrajpuning warak la juka jita warramumpik inyjangaling inyjalkenang. Malany wularrut mira ta ingamany rtalk innyarrangung ja maningul marrik ilakujpina. ");
INSERT INTO mph_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Inyanat inyuran awunngeyawng wimurra pata marrgijpu pata inypatpung, awunmeny arlarrarr. La akalulkanyang pu ja rrupiya la marrik inyngulikina. Inyarranapa ja kuyak iwinpilminy. Malany 12 ja jungkarra angkat innyarrangung ja maningul. ");
INSERT INTO mph_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Inyanat inyalyungan nuyu Jesus ta awunnyatpang, angawurrungapa inyminy, “Ta ngetping nuyu ja kiyarni nakapa nganangulikin.” Kayirrk la inyanat tuka kirrwara nuyu inyarran parak ingatpung nuyu ja iyarning. ");
INSERT INTO mph_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Malany ta ingatpung ja manpurrwa nakapa inyngulikiny la mata maningul nakapa malakujpiny. La angawurruning, “Aralpa nganingulikiny.” ");
INSERT INTO mph_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Malany Jesus yalyungan ta wutkut nuyu anguran. Kayirrk la imilkpungeny awunilakajpung pata napulurrumpi awulangaling, “Nganti innyatpung ngartu ja manpurrwa?” ");
INSERT INTO mph_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kayirrk la pata awarrangung rtil wiyu nuyu aminy nuyu, “Pata napulurrumpi kunpulirrngkakantiny la kunuka nuyu ngarruntakajpun, ‘Nganti ngannyatpung?’. Wimurra pata arrarrkpi kunpulirrngkakantiny!” ");
INSERT INTO mph_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Parang angkat yukekenang ja Jesus, “Nganti ja naka ngannyatpung animany ta wutkut ngartu?” ");
INSERT INTO mph_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kayirrk la inymurtpiny jita warramumpik angawurruning mira ta karrkpin mira ta algaj inyngulikiny mawarlkanyiny tuka wanyji yurnu nuyu la angunman nuyu tuka kiki angminy parak ngaw. Kayirrk la inyminy nuyu Jesus, “Ngapi pa kunatpung.” ");
INSERT INTO mph_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kayirrk la Jesus iminy ngaw, “Wirlupirlu, parang la anmartukpung ngartu la anngulikinganapa nungmalal. Anpanuraka tuka nuyi nuwu ta kunak. Marrik kunuka muj kunilang. Kayirrk marrik anmajung akut!” ");
INSERT INTO mph_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wakapa Jesus inyilakajpuning jita warramumpik, la nganti yirrik ilinganka tuka Jairus nuyu kurrampalk la iminy, “Juka jita nuyi kunymalkpany inymajungan. Yunyi kungpurrun muj Jesus.” ");
INSERT INTO mph_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Malany ja Jesus awunimarrkinyang la iminy nuyu ja Jairus, “Yunyi kanmurtpin! La anmartukpuni ngartu!” ");
INSERT INTO mph_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kayirrk la Jesus iminy pu, “Yunyi kurrurlgen tuka kurrampalk!” Yanat awunimany werawungut pata arrarrkpi awarran parak ilij nuyu ja inyimalkpany la jita nigi, la ngarrkarrk la werakap pata awarrangung rtil wiyu nuyu pata Peter, James la John wenat ju parang awuran rtil. ");
INSERT INTO mph_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Malany tuka amalkpany tuka kurrampalk Jesus yalyungan wera pata arrarrkpi wukej angpulakantung. Wenatapa awararrkenang la awaning wanalaya ngaw jita inymajungan ");
INSERT INTO mph_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","La Jesus yarran parak yurlgeny wukej la iminy pu pata arrarrkpi, “Kunuka nuyu kutpararrken? Jita warrawurnji marrik inymajunyi juka ninyarnankat la inyanat inyurnparrang.” ");
INSERT INTO mph_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wenat angkuwurruning inyanatapa jita warrawurnji inymajungan la wenatapa iwuwuning parr yanat, parang la iminy pu, “Kutpalkpanyi yalayala!” Kayirrk la Jesus awunimany pata mayakpu la jita nigi ngaw jita warrawurnji la pata ngarrkarrk la werakap pata awarrangung rtil wiyu nuyu iminy pu, “Arrkpanurlgen ilij ngartu.” Kayirrk la awurlgeny tuka kurrampalk tuka jita warrawurnji inyung. ");
INSERT INTO mph_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kayirrk la atimany ngaw yurnu ja Jesus pa iminy ngaw tuka wenat pu ta ngaralk, “Talitha Koum!” (La ta kanyu ta wulatpiyi “Anmajpungkinaga warrawurnji!”) ");
INSERT INTO mph_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wakapa ta inymajpungkiny jita warrawurnji la inyjarrajpany la inyarrangung juju wukej tuka kurrampalk! Malany pata nigi la mayapu awurlkpalangkeny ta inypayawng murnin jita warrawurnji inymajpungkinyapa! Malany ja walmat ngaw 12. ");
INSERT INTO mph_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","La Jesus iminy pu, “Yunyi kutpin pu ta juka jita warrawurnji ngapi nginymajpungkuny.” Kayirrk la yanat iminy pu, “Ma! Kurrinypanawn apangala ta walij.” ");
INSERT INTO mph_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus la pata awarrangung rtil wiyu nuyu angparutpan amurnanganiny tuka Jesus nuyu ta kunak wungurlaj Nazareth. ");
INSERT INTO mph_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Puka pata Jew arrarrkpi wu ta wungurlyak ngurrij Jesus yarran parak tuka Jew arrarrkpi wu tuka awaning ngarlakarlak ta akurlyak kurrampalk la inimany rtalk ininyang monmon pu pata arrarrkpi ta God nuyu ta ngaralk. Wimurra pata arrarrkpi awalyungan nuyu awurlkpalangkeny. Kayirrk la aminy pu la wemin, “Arta, nuka ja karriwurrun ja arrarrkpi. Yanatapa ja nuwuran kanipa. Jita inyalkpany nuyu Mary ninypuran kani la muj pata awulinganut James, Joses, Judas la Simon la muj pata warramuntujut nuyu. Malany yanat iyamangung atjarnekenang. Kurlingka yanat kaniwurrun kirrk? La ngampiwi animany ta tuka ta wutkut ta arrarrkpi kawunnyatpi?” Puka pata tuwuran Nazareth arrarrkpi marrikpan mali marrik angkumiyarmanyi awalyunyi nuyu. ");
INSERT INTO mph_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kayirrk la Jesus iminang pu, “Tuka God kinnyun ja arrarrkpi kinini monmon ta ngaralk nuyu, pata arrarrkpi amparrkamparrk kamartukpun nuyu. La puka pata arrarrkpi kangkuwurrun ja nukapa ingurlyak arrarrkpi tuka iminang warranyngiw, malany marrik kayirrk amartukpu nuyu. Kapin muj pata witparlanparlarrut akutju marrik awalyung nuyu.” ");
INSERT INTO mph_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Puka pata arrarrkpi pata tuwuran wakapa marrik muj angkumiyarmanyi ta ngaralk awuningulakanti wakapa. La yanatju awunnyatpung werawungut pata arrarrkpi la awuningulakantiny nungmalal. ");
INSERT INTO mph_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","La yanatapa ja Jesus iwurlkpalangkeny murnin wenat amilkpungeny iwung kirrwara la marrik awalyunyi nuyu ta ngaralk. ");
INSERT INTO mph_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Kayirrk la Jesus yuran kunak la kunak awunnyukikang God nuyu ta wurluj. ");
INSERT INTO mph_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","11","Malany wakapa Jesus awaning ngarlakarlak pata wurrkamaj yurnu la wurrkamaj yurnu la ngarrkarrk pata wingurlyakut pata yanat awarrangung rtil wiyu nuyu. Yanat iminy pu, “Nuwurri kutpana kunak la kunak kurrungpanunma ta God nuyu ta wurluj wu pata arrarrkpi. La wenat akutju kurruntayatayan tuka kutpunpayarrun parak. La yunyi kurrima warak ja palaji la walij, la ja rrupiya la muj manpurrwa. Nuka kurriwanama warak ja kajarntangali la mata yumparljumparl nuwurru. Warrwak tuka kutpamalkpa tuka kunak, la pata arrarrkpi awanamin marrmarr nuwurru pa kutpawani rtil, malany nuwurri wakapa kutpawani tuka arakap ta kurrampalk. La pata arrarrkpi marrik kurruntumiyarmang ta wakapa, la marrik wenat awalyung nuwurru ta ngaralk, wakapa kurrungpanarutpa warak. Kapin ta kurrungpanarutpa, la kurrapanawun tawktawk kurrungpaka ta yurlngpuj nuwurru tuka yurnu murnin nungpakapa ta wulatpiyi nuwurru. Nuwurripa kutpanamin pu, ‘Nuwurri marrik kurralyunyi nuyu ta ngaralk ja God la yamin wali iwanamin nuwurru la iwayintukun nuwurru.’” Kayirrk la Jesus iminy pu pata awarrangung rtil wiyu nuyu, “Ngapipa kayirrk kurrunpanawn ta wutkut tuka kurriwaka wu ja yaliwiyut pata arrarrkpi.” Kayirrk la wakapa ja Jesus awunilangakan tuka awayama nuyu God. Yanatapa awunilangakan pata 12 pata awarrangung rtil weminpi la wemin ngarrkarrk la muj ngarrkarrk pata arrarrkpi tuka awuyamany nuyu. ");
INSERT INTO mph_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wenat awuyamany tuka Jesus iminy pu. Wakapa awuran tuka kunak la kunak la angpunmangung pu amparrkamparrk tuka God nuyu wurluj. Wenat aminy pu pata arrarrkpi, “Kutpilkpungena, kurrungarutpanyi ta kurrunngetpi la kurrunjarruni ta God nuyu”. ");
INSERT INTO mph_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pukapa pata awarrangung rtil wiyu nuyu Jesus pata arrarrkpi iwakakan wu ja yaliwi ja iwatpang. La muj awunpulatpantiny ta yirri pata arrarrkpi pata amajunmajung la awungulikiny kirrk. ");
INSERT INTO mph_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","29","Nungpakapa ta ngungpanunma nuwurru ta angmalkpany nuyu John ja Aningurtpulukpuning pu. Malany wakapa ja yukenang pu Herod inyimany wumpulaj warramumpik ninyngurlaj Herodius jita Philip nuyu ja awulingan Herod. La John yarran parak iminy nuyu manjat ja Herod, “Arta! Yunyi kunyma wumpulaj juka jita nuyi kutingan nuyu jita warramumpik.” Kayirrk la inyjirrinyminy angarnamangung ingawuni jita Herodius ja John la marrik kiki inymina, murnin ja Herod awunilangakan pata arrarrkpi iwumanyi ja John kayirrk la iwawutikin iwanutpa tuka kawuntuwutaka ta kunak. Kayirrk la jita Herodius marrik kiki inymina nuyu. Malany Herod imurtpiny murnin aniwurruning yanat John ja manjat ja numalal ja arrarrkpi la aniyarruning ta God nuyu ta alan akut la akut. Kayirrk la Herod inimiyarmany awaninga ngarlakarlak la ta John iminang nuyu wakapa yalyungan la marrikpan mali ja Herod. Warrwak la Herod anilangakan wurluj wu pata arrarrkpi pata awukenang pu la ja Herod nuyu pata arrarrkpi pata wimunpimun pata awukenang pu Galilee nuyu awulangaling mulil ta algaj ilurrang. La jita Herodius inyminy mali iwangawun ja John. Wakapa la jita Herodius inyalkpany ngaw jita warrawurnji ingarlukpangung nungmalal aminy marrmarr mira. Kayirrk la Herod iminy ngaw, “Ta kumiyarma tuka ta kunak awk nakapa kunpanawn. Ta kungmiyarma nakapa kunpawilkpun kunpanawn kunak la ngiwawilkpun ngiwanutpa tuka kunak ngartu la yara ja ngapi ngiwanatpi. La kunuka kumiyarma? Nungpakapa manjat ta ngapi ngamin nuwu. Ngapi marrik kuntagarru.” Jita ninyngalalk inyuran yalayala inyngalakajpung jita nigi, “Kiki nganamin nuyu la ngiwalakajpun?” La jita nigi inyminy, “Anpamurnangani warak kuwalakajpun ja Kiwken iwanilangaka ja arrarrkpi iwanimarlalku ja John ja Aningurtpulukpuning wu arrarrkpi la ta wanji nuyu kunpannyun.” Malany jita warrawurnji inyngurriny tuka Herod, inymalkpany nuyu la inyminy nuyu, “Ngungmiyarma kuwamarlalku kungpaka nuyu wanji John ja Aningurtpulukpuning pu arrarrkpi la kungpanutpa ta wanji tuka wilampilam, kayirrk la nganpanawn ngapi.” Kayirrk la yalyungan ja yukenang pu Herod la marrikpan mali. Parang la aniwurruning mira marrik animiyarmanyi annyukpuni ta wulatpiyi murnin awalyungan nuyu ta annyutpan ngaralk pata arrarrkpi awk. Kayirrk la iminy pu pata awuyamangung nuyu Herod ja yukenang pu, “Kutpana kurriwamarlalku ja John la kurrungpanamaga ta wanji nuyu kani tuka wilampilam.” Awarran parak pata awuyamangung nuyu tuka wukej tuka iwaning iwutikinang ja John wakapa iwumarlalkuny. Warrwak angkumany ta wanji nuyu angputpan tuka wilampilam kayirrk la angkumany parak inypung jita warrawurnji kayirrk la inyngawng jita warrawurnji jita nigi. Malany ta awalyungan ta aminang nuyu John ja Aningurlpulukpuning pu pata Herod nuyu arrarrkpi awarran parak pata John jawirna nuyu iwumany ja ingijalk iwuyurjiny tuka yurk. Warrwak la pata arrarrkpi awalyungan ja Jesus iyamangung wu la iwinyang monmon yanatapa. Yara pata arrarrkpi aminang nuka ja Jesus aminang mali nuka Elijah - la nuka ja nuwarlkparrakan annyunmangung ja God nuyu ngaralk ta wularrut mira - wera aminang yanat ja God inimurnanganinyka yarnangkat akutju. La wera pata arrarrkpi kamin nuka ja Jesus ja arrarrkpi ja kinilakula tuka God nuyu, kapin wera pata arrarrkpi aminang inilakulangung ngaralk God nuyu ta wularrut mira. La wera arrarrkpi aminang nuka Jesus ja John ja Aningutpulukpuning wu, la aminang nukapa God inimajpungkuny John akutju la innyung ta wutkut ta nuntatparlangkat mira. Nuka ja Herod ja Kiwken yalyungan tuka angpunmakpangung la iminy, “Ngapi ngawunatpi arrarrkpi pata John iwumarlalkuny tuka wanyji, la puka pata arrarrkpi kangkuwurrun - yanatapa John ja Kaningurtpulukpun wu. La ngapi ngungpurrun God inimajpungkuny yarnangkat akutju.” ");
INSERT INTO mph_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kayirrk la pata Jesus nuyu pata 12 pata wingurlyakut pata awarrangung rtil wiyu nuyu amurnanganingka kapa tuka wugarra yirrk kunak la angpunmangung nuyu ta kiki aminang wu pata arrarrkpi ta algaj awuyamangung. ");
INSERT INTO mph_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wakapa tuka awaning ngarlakarlak wimurra pata arrarrkpi awunpuyarrung parak tuka Jesus ilangaling la Jesus la pata awarrangung rtil wiyu nuyu malany angpatpang wugarra, marrik muj kiki amina apulanyi ta walij. Parang la Jesus ilajantiny pu pata awarrangung rtil wiyu nuyu iminy pu, “Ngawu! Arrkpanarra warak tuka tora ta kunak nuyu arrungpaka wirrngak?” ");
INSERT INTO mph_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu awulurrang tuka kapala angkuwuning pirl wurrkaraga kapa tuka mapurlarr yirrk ta kunak ajirrik awaninga palat la makiny. ");
INSERT INTO mph_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Malany pata arrarrkpi awk awunpayantung yirrirri ja kapala awarrangung parak angkuwuning pirl warak, angkuwurrung kayirrk la awurakan iwiyirnukpung wurrkaraga kayirrk la pata tuwuran wugarra ta kunak, amalkpany. ");
INSERT INTO mph_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Malany ja Jesus yurtiny parak ilurrang tuka kapala kayirrk la Jesus awunnyayawng wakapa pata arrarrkpi iwumirlajuning, wakapa awulangaling wimurra mira. Yarran parak awunnyayawng iwuwurlkpungkun pata arrarrkpi kapin pata larnngalkpu pata marrik nganti awunnyayatayanjing. Wakapa annyunmangung pu ta nungmalal wurluj. ");
INSERT INTO mph_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Awulangalinganapa arukaruk la pata awarrangung rtil wiyu nuyu aminy nuyu Jesus, “Arta, wularrutapa arukaruk la kani marrik nganti iwaning la kinyuryi warakapa. ");
INSERT INTO mph_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Anpuntangakanyi pata arrarrkpi nuyu apayalma walij apanala.” ");
INSERT INTO mph_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kayirrk la Jesus iminy pu, “Nuwurri kutpunpanawn ta walij!” Kayirrk la pata awarrangung rtil wiyu nuyu aminy nuyu, “Ngarri marrik ngarrawatping ta walij apurra. Kurlingka nuyi ngarrunmiyarma ngatpana ngarriwaka imurra ja rrupiya ta walij nuyu la ngarri ngatpunpanarlikpi pata arrarrkpi?” ");
INSERT INTO mph_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kayirrk la Jesus iminy pu, “Kiki ja kurratayanti ta walij kiki kapin ta katju?” Awarran parakapa apayawng pa aminy, “Tuka awalinjinyut wurrkamaj yurnu ta kantijawa la ngarrkarrk ja kiyap.” ");
INSERT INTO mph_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Kayirrk la Jesus iminy pu pata awarrangung rtil wiyu nuyu, “Kutjanyji kutpina wu pata arrarrkpi, ‘Kutpawani purrkut la purrkut.’” Kayirrk la awarran parak pata napulurrumpi pata arrarrkpi awuntumangung la wemin yera awaning 100 la yara 50. ");
INSERT INTO mph_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kayirrk la Jesus atimany ta kantijawa ta awalinyjinyut la kiyap inimany kayirrk la atimajpungkun ta kantijawa la kiyap parang la inilakajpung ja God. Atiwirlkpukpuning ta kantijawa la kiyap iniwirlkpukpuning kayirrk la awunnyung pata awarrangung rtil wiyu nuyu la awunpuning pata arrarrkpi pata wakapa awaning. ");
INSERT INTO mph_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Malany wimurra pata arrarrkpi awarran parak apuwany ta walij awarran parakapa amarlmanpung kirrk. ");
INSERT INTO mph_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La warrwak pata Jesus awarrangung rtil wiyu nuyu apumangung akpaj ta awarawungut ta awutpiny ta walij. Wenatapa apulatikiny 12 tuka yangali ta walij ta marrik apulanyi. ");
INSERT INTO mph_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngungpurrun wimurra mira pata arrarrkpi ngungpurrun napulurrumpi 5000 awulangaling la muj warramumpik la warrayngiw. ");
INSERT INTO mph_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Wakapa Jesus iminy pu pata awarrangung rtil wiyu nuyu, “Kutatina tuka kapala kurrungpanawun pirl wurrkaraga Bethsaida.” Kayirrk la Jesus iminy pu pata napulurrrumpi, “Kurrarakanyi!” ");
INSERT INTO mph_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kayirrk la awunilangakan awurakan parak kunak kayirrk la yanat yuran tuka murrgu iling iwarruj. ");
INSERT INTO mph_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Malany angpung wupurrk pata awarrangung rtil wiyu nuyu awulatinang tuka kapala awulangaling tuka wungijalk la Jesus ilangaling palat wawurri. ");
INSERT INTO mph_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Warrwak la Jesus awunnyayawng pata awarrangung rtil wiyu nuyu amijantung miri la marlu apukpangungka la awunnyakangung. Ta iyirtpirrakenangka Jesus awuniyarrung parak yarrangung juju warak tuka wupaj la iniyarruning parak ja kapala la kapin awuniwarlkijpangung parak. ");
INSERT INTO mph_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Iwayawng yarrangung jujuga tuka wupaj amurtpiny pata awarrangung rtil wiyu nuyu aminy mali manya. La iwayawng apa awurlalmangkany kirrk la awuyirrulkeny. Kayirrk la Jesus iminy, “Nungmalal! Ngapi kani! Yunyi kutpurtpin!” ");
INSERT INTO mph_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kayirrk la Jesus ilurrangkeny tuka kapala awulatinang rtil la marlu atakujpiny la awurlkpalangkeny kirrk ");
INSERT INTO mph_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","murnin wenat marrik angkuwurruni mira tuka awunnyung walij la kiyap. Marrik muj amartukpuni nuyu. ");
INSERT INTO mph_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kayirrk la wenatapa awarran parak ta karrpin ta kunak ta wungurlaj Gennesaret malany wakapa mampuwanpuriny ja kapala. ");
INSERT INTO mph_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","La wimurra pata arrarrkpi nakapa iwayawng ja Jesus ilurrangenyka tuka kapala la iwayawng iwunman yanatapa. ");
INSERT INTO mph_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Parang la awarran parak awuntumangungka nuyu Jesus pata amajunmajung tuka japirri. ");
INSERT INTO mph_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Malany pata arrarrkpi iwuyarrukuning tuka ngampiwi yarrangung juju tuka nungpanpal kunak, awuntumangungka tuka japirri pata arrarrkpi pata amajunmajung la awunputpangung tuka kunak nuyu Jesus awunpaningulakan. La iwulajakpuning ja Jesus angkumiyarmangung iwatpa nuyu manpurrwa nuyu awangulikin, la pata amajunmajung iwatpang nuyu manpurrwa nakapa awungulikinang. ");
INSERT INTO mph_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Wakapa yara pata Jew arrarrkpi pata awukenang pu ta wulatpiyi awuntuwarnangajpuning Pharisees. Malany ta wularrut mira angputpangung parrparr ta wulatpiyi ta wenat wiyu wu pata arrarrkpi. Tukapa ta wulatpiyi marrik annyung tuka God nuyu ja jurra. Arakap muj tuka angpungulakantung ta wulatpiyi tuka wenat wiyu wu: Tuka marrik apulanyi wenatapa la apuwinypuning yurnu wu werrk warrwak la apulangung tuka wenat wiyu wu angpuyarruning. Kayirrk la arrarrkpi warrwak awarrangungka pata awulakpolorrkang yirrk kayirrk la apuwinypuning akutju ta yurnu wu. Wakapa awukenang ta wulatpiyi anyung akutju tuka awungurrinang wularrut mira, tuka iwuwinypuning ja kap, la panikin, la muj ja kapuwunyaka walij la muj mata katpani kal mata jaya warrwak la wenat awaning kal la apulangung ta walij. Tukapa ta wulatpiyi marrik anyung parak tuka God nuyu. Yara pata Pharisees, la wera pata wulatpiyi awunpukikang, awuranka kapa Jerusalem iwayan ja Jesus la pata awarrangung rtil wiyu nuyu. Wenat awunpayawng pata Jesus awarrangung rtil wiyu nuyu marrik apuwinypuni ta yurnu wu tukapa ta wenat wu ta wungurlyak la walij apuwany ");
INSERT INTO mph_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","la puka pata kawuken ta wulatpiyi iwuluntuny ja Jesus la aminy nuyu, “Kurlingka puka pata nuyi kurrarra rtil marrik angkuwurru ta wulatpiyi tuka tuwarlkparrakanut pata awukenang pu awunpuyurtutpakpan wularrut mira? Pukapa pata nuyi kurrarra rtil wiyu nuwu apuwanyju la marrik wenat apuwinypuni ta yurnu apuwanyju la marrik angpuyarruni warak manjat. Kunuka nuyu wenat marrik apuwinypuni ta yurnu murnin tuka mulil wenatapa wularrut angpuyarruning parak la apulangung?” ");
INSERT INTO mph_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kayirrk la Jesus iminy parak wu, “Nuwurripa amparrkamparrk kutpin mali awanamin nuwurri ta nuwutpalalut la kurrungpurrun kirrk, la nuwurripa marrik nuwutpalalut. Nuwurri kurriwurrun ja nuka ja ingurlaj Isaiah ja iwaning wularrut mira la animirrawung ta God nuyu ngaralk, yanat animirrawung ta wulatpiyi tuka manjat ta ngaralk nuwurru nuwurri. Yanatapa animirrawung tuka jurra, ‘Pukapa pata arrarrkpi kamartukpun ngartu tuka ngaralk wu la kiwuma lagarr la puka kangkuwurrun ta wenat wiyu wu. ");
INSERT INTO mph_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Malany wenat kangpatpi ta mulil ngartu, la wenatapa ta kangpatpiga nungmurrunti ngartu. Wenat kawunpukiki ta wulatpiyi tuka arrarrkpi pata kangpungula ta wenat wiyu wu, la wenat kangpunma wu amparrkamparrk ta tukapa ta God nuyu ta wulatpiyi.’ ");
INSERT INTO mph_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kayirrkapa ta nuwurri wiyu nuwurru. Murnin nuwurri kutpilkpungeny nuyu God nuyu ta wulatpiyi la nuwurri kurrungatpi jir ta arrarrkpi kangpungula ta wulatpiyi wu.” ");
INSERT INTO mph_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kayirrk la wenat angkat Jesus inilakulangung pu, yanat iminy pu, “Nuwurripa kutpilkpungen la kurrunjarrun parak la kurryun kirrwara tuka God nuyu ta wulatpiyi la kurrunjarrun parak tuka nuwurri wiyu nuwurru ta wulatpiyi. ");
INSERT INTO mph_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tukapa kangmin parak: God iminy nuyu ja Moses, ‘Anpanamin pu pata arrarrkpi awuntayatayan pata tuwarlkparrakanut.’ La Moses animirrawung tuka ta wulatpiyi: ‘Nuwurri kutpamartukpun wu pata punyi la kamu. Kapin nganti ja awunpannyarnama kamu la punyi, yanat akutju kurriwanawun iwamaju ja arrarrkpi!’ ");
INSERT INTO mph_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kurlingka nuwurri kurrungpurrun ja arrarrkpi kimin nuyu ja punyi la kamu ‘Kapin ngapi atjirtiking nuwurri ta nuwutparlkparrakanut arrarrkpi la makiny, ngapi marrik kurrunu nuwurri ja kurrimiyarma nuwurri murnin ngapi ngiwarlkung ngiwanawn ja God.’ ");
INSERT INTO mph_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kurlingka nuwurri kurrungpurrun nungmalal ta marrik imi wu pata punyi la kamu tuka marrik awuyitiking la annyatping tuka yanat wiyu nuyu? ");
INSERT INTO mph_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nungpakapa kangmin parak ta nuwurri kurrungpanama warak ta God nuyu ngaralk la wenat pata arrarrkpi angkayarrun nuwurru ta nuwurri nuwurru ta wulatpiyi. Nuwurripa kutpin tukapa akut la akut.” ");
INSERT INTO mph_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kayirrk la Jesus ilajantiny pu pata arrarrkpi iminy pu, “Kutpanalyu ngartu la kurrungpawurrun mira ta ngapi ngamin nuwurru. ");
INSERT INTO mph_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yunyi kurrungpurrun mira ta kurrata ta walij tuka nuwutakpirij la kurrungpawurrun mira tuka kurrkinka parangju. Malany God iwanalyu ta aliwi kangmalkpa tuka nuwutakpirij yanat iwanamin nuwurru nuwurri aliwi kurrungatpi tuka nuwurrkijalk.” ");
INSERT INTO mph_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kayirrk la Jesus awunnyarutpan la yurlgeny wukej iwaning. Malany pata awarrangung rtil wiyu nuyu iwulakajpung aminy nuyu, “Tuka ta ngaralk ta nuyi kannginka kiki kangmin parak?” ");
INSERT INTO mph_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Kayirrk la Jesus iminy pu, “Kurlingka nuwurri kalajarr marrik kurrungpurru mira? Kurralyunyi, kapin ta walij kurrata nakapa kawarra warak tuka wurak nuwurru malany ta warrwakapa la kapalkpa tuka awalijap ta kurrampalk ta kutja. Naka marrik awarray warak tuka walmukpuk. Malany ja God atjayanyjing ta walij la marrik imi nuwurru nuwurri ta nuwutpurrunti.” (Tukapa ta Jesus iminy pu tuka wularrut angpuyarruning tuka yara ta walij marrik apulanyi la ta kayirrk tuka awk ta walij arrapanala yirrk murnin nungmalal yirrk.) ");
INSERT INTO mph_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","23","La Jesus angkat awunnyukikang pata awarrangung rtil wiyu nuyu, yanat iminy, “Arrarrkpi kangkuwurrun tuka wanji wu ta aliwi wenatapa kawungurrin arlalng - kayirrk la wenat kamajpungkin kangpuyarrun ta aliwi - la God kimin puka pata weliwiyut. Tukapa ta wenat awanamin parak: La wenat angkawurru ta wenat wiyu wu ta aliwiyut. La muj wenat kawarra warak kawu rtil pata wera. La muj wenat kamangirrakan. La wenat muj iwumiyarmang kapin pata wera arrarrkpi kiwetpi. La wenat muj awuling wumpulaj. La wenat muj marnti awuntuwu la amajung pata wera pata arrarrkpi. La muj wenat awarray purup la ja jara wularrut iwurnyakpiny. La muj wenat angpularrukuy nuyu pata arrarrkpi. La muj wenat awuntuwu namarlaja pata wera pata arrarrkpi. La muj wenat kamin mali wenat wiyu pata wingurlyak mira. La wenat kangkuwurrun tuka wenat wiyu wu. La wenat muj ami ta aliwi tuka kangmalkpaga wu tuka wanyji. La muj wenat ami ta nungmurrunti aliwi. Nungpakapa ta aliwiyut kangmalkpaga tuka kangkuwurrun tuka wanji wu. Ta karrungatpi nungmurrunti la God kimin puka pata arrarrkpi tumurrunjut.” ");
INSERT INTO mph_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wakapa Jesus imajpungkiny awunnyarutpan pata awaning Galiliee ta kunak yuran imalkpany tuka kunak ta wungurlaj Tyre. Tukapa ta kunak tuka wanyji kurrula. Wakapa Jesus yuran yurlgeny tuka kurrampalk la iwaning palat wakapa tuka marrik nganti aniwurruni tuka yurlgeny la makiny. Pata arrarrkpi awalyungan ta yanat iwaning tuka kurrampalk la wenat awuranka amalkpany nuyu. ");
INSERT INTO mph_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","La ninyarakap jita warramumpik inyjangaling. Malany marrik Jew jita warramumpik la inyanat ninypuran ta kunak wungurlaj Phoenecia wakapa ta Syria ngaw. La jita inyanat inyalkpany ngaw ingatpang ja yaliwi tuka ninyngijalk pularr. Malany wakapa inyarran parak tuka Jesus ilangaling, mawalkanyiny tuka yurnu nuyu. Wakapa inypurlkpungkang nuyu inyminy nuyu, “Kokanyi yirrk ngaw ja yaliwi jita ngapi ngalkpany!” ");
INSERT INTO mph_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kayirrk la Jesus iminy ngaw, “Ngapipa ta Jew ngatpuran. La ngapi ngawunpayatayan pata ngapi ngartu pata arrarrkpi werrk, la nuwurri marrik ta Jew arrarrkpi. Nungpakapa ngapi ngawunpanalikpi werrk pata warranyngiw ngartu. La marrik nungmalal ta ngapang warak ta wenat wu la ngartakay warak ta walij tuka luluj.” ");
INSERT INTO mph_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wakapa jita warramumpik inynginkan inyminy, “Aralpa, nuyi ta Ngarrunukiki. Pata luluj kawulangali wilik tuka kamalangali palapala kapula awalinyjinyut ta walij. Tuka katja yurrjurr warranyngiw kapatpi wirijpirij. Ngapi marrik Jew parangapa la ngungpurrun nungmalal ta arrkpayirtiki.” ");
INSERT INTO mph_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wakapa Jesus iminy ngaw, “Nungpakapa nungmalal anminyka ngartu. La nuyipa kayirrk kanmartukpun ngartu. Kayirrkapa nuyi anpanuraka kunak. La ngapi nginyngulakantiny la ja yaliwi inyarutpan jita nuyi anngalkpany ngaw.” ");
INSERT INTO mph_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wakapa jita nigi inyurakan tuka kunak inyngayawng jita inyalkpany ngaw inyung angkat tuka palapala la ja yaliwi inyarutpan. ");
INSERT INTO mph_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kayirrk la Jesus annyarutpan ta wungurlaj Tyre la yarran parak imalkpany ta wungurlaj Sidon, la yanat yarran parak inimarrawulngan aril tuka wurl ngaw Galilee yarran parak ta kunak wungurlaj ‘Wurrkamaj Yurnu la Wurrkamaj Yurnu Kunak’. ");
INSERT INTO mph_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","La wera pata arrarrkpi iwumanyka ja arrarrkpi nuyu Jesus. Nuka ja arrarrkpi ja inimany kalajarr la marrik inginkanyi mira. La pata arrarrkpi pata jawirna nuyu nakapa wenat iwulakajpung Jesus aminy nuyu, “Kawutpanyi ta yurnu tuka ngarri jawirna ngarru la kuwangulakan la iwangulikin.” ");
INSERT INTO mph_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kayirrk la Jesus inimany parak nakapa ja arrarrkpi awarran parak la awunparutpan pata arrarrkpi la wakapa atjutpan ta yurnu nuyu tuka arrarrkpi larnngalk nuyu. Kayirrk la Jesus iminy juk tuka yurnu nuyu la anyatpung ta ngaralk nuyu ja arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Wakapa Jesus yukeny yurrng tuka kuynu la ilingan iwarruj nuyu ja arrarrkpi. Yanat iminy, “Ephphatha!” tuka kangmin parak, “Anmatpalanti!” ");
INSERT INTO mph_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La wakapa tuka iminy parak manjat ja arrarrkpi yalyungan la inginkan ta ngaralk martapapa mira. ");
INSERT INTO mph_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kayirrk la Jesus imurnanganiny parak iminy pu, “Yunyi kurrungunma wu tuka kiki ngaminy.” La wenat marrik awalyunyi nuyu ja Jesus. Angkat iminang pu, “Kutakujpina!” la angkat wenat aminang pu pata arrarrkpi, “Ja Jesus iningulikiny ja arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amparrkamparrk awurlkpalangkeny la aminy pu la wemin, “Jesus iminy kirrk tuka manjat mira. Yanat kawuningulakan pata kalajarr la pata marrik awunginkay ngaralk - yanat kawuningulakan pa nuyu awanginka.” ");
INSERT INTO mph_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wakapa Jesus inininy monmon pu pata arrarrkpi wakapa tuka kunak. La wimurra pata arrarrkpi awalyungan nuyu. Malany ngarrkarrk la arakap ngurrij la wakapa wenatapa apuyarrkpung ta walij. Kayirrk la Jesus ilajantiny pu pata awarrangung rtil wiyu nuyu la iminy pu, ");
INSERT INTO mph_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ngapi ngantuwurlkpungku puka pata arrarrkpi. Wenatapa kamaju wirrngak marrik kunuka iwulanyi! ");
INSERT INTO mph_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Marrik ngawuntangakay warak amurnanganing tuka kunak wu. Wera pata arrarrkpi angkumarrajpungka warak la amalkpany kani la ta amurnanganing parak kunak wenatapa marnti awulatpalililmi la mawarlkanying. Kayirrk ngarrurri arrkpunpanawn ta walij.” ");
INSERT INTO mph_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Malany Jesus pata awarrangung rtil wiyu nuyu aminy nuyu, “Arta! Ngarrurri marrik arrawetping ta walij kani tuka karrapey la arrkpunu puka pata arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kayirrk Jesus iminy pu, “Kiki kurrawatpi ta kantijawa?” Wenat aminyka, “Ngarrawatpi wurrkamaj yurnu la ngarrkarrk ta kantijawa.” ");
INSERT INTO mph_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Parang la Jesus iminy pu pata arrarrkpi, “Kutpaninga tuka kunak.” Kayirrk la atimajpungkuny ta wurrkamaj yurnu la ngarrarrk ta kantijawa la ilingan iwarruj nuyu God ta walij kayirrk la atjukpung la awunnyung pata awarrangung rtil wiyu nuyu la wenat awunpung pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wakapa nganti yirrik innyatpang ilinjinyut ja kiyap la wenat iwung Jesus. La yanat ilingan iwarruj nuyu God ja kiyap akutju, kayirrk la awunnyung pata awarrangung rtil wiyu nuyu la awunpung pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Parangapa apuwany kirrk amarlmanpung kirrk. Malany apumany apurra muj ta aparutpakpan ta walij apulatikang tuka wurrkamaj yurnu la ngarrkarrk ja yangali. ");
INSERT INTO mph_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Malany warrwak pata arrarrkpi apuwularrung kirrk kayirrk la Jesus iminy pu, “Nuwurri kutpanuraka kunak.” Wakapa awaning 4000 arrarrkpi la amarlmanpung kirrk wakapa. ");
INSERT INTO mph_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wakapa awarran parak Jesus la pata awarrangung rtil wiyu nuyu awulatinang tuka kapala awarran parak tuka kunak wungurlaj Dalmanutha kapa wurrkaraga tuka wurl. ");
INSERT INTO mph_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wakapa pata awukenang pu ta wulatpiyi pata awuntuwarnangajpuning Pharisees wakapa awaning tuka kunak. Kayirrk la wenat awalyungan pata arrarrkpi ja Jesus iwaning wakapa la awarran parak iwulakajpung yanat. Malany wenatapa angpulagarrukung nuyu pa wenat awanginka yanatapa. Wenat iwalakajpung aminy nuyu, “Nuyi anpanamin tuka ta wungurlyak la ta wutkut, la ngarri ngarrungpawurrun nuyi ta arrarrkpi ta kunilangakanka God.” ");
INSERT INTO mph_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kayirrk la Jesus marrik imina marrmarr, yanat annyakan wumurra wirrngak la iminy, “Nuwurri ta kurrungmiyarma kurrungpayan ta wutkut warrwak la kutpamartukpun kutpanamin God nganilangakanka ta ngapi. Kurralyunyi! Ngapi nganamin nuwurru manjat. Ngapi kayirrk marrik kurrungayanjing ngartu ta wutkut ta nuwurri ta kani.” ");
INSERT INTO mph_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu awarrangung parak awunparutpan pata Pharisees awulatingan tuka kapala la angkuwung pirl warak kapa wurrkaraga. ");
INSERT INTO mph_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Puka pata Jesus awarrangung rtil wiyu nuyu marrik awularrkpolorrka ta walij kapa ta Dalmanutha. Wenatapa awarran pularngarlk. Warrwak tuka kapala angkuwung pirl warak orka tuka wurl, warrwakapa la angkuwurrungapa. Warrwak la wenat awukeny tuka palaji wu la apayawng awarakap ta awarkalu ta kantijawa. ");
INSERT INTO mph_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kayirrk la Jesus awunilakajpung pata awarrangung rtil wiyu nuyu tuka kapala awulatinang. La yanat iminy pu, “Nuwurri kurrungpurrun ta karrungminyjama ja katimurranyma ta kantijawa kapin rlurlapa ta walij. Ngungatpi, ngapi ngungpanunma nuwurru tukapa, yunyi kutpartawkunyjilin wu puka pata Pharisee pata kawuken ta wulatpiyi wu tuka aliwi tuka kangpatpi la angmurranymi warak, la yanat marrik muj kutpartawkunyjili akutju yanat ja Kiwken ja Herod nungpakapa kimin akutju. ");
INSERT INTO mph_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Malany pata awarrangung rtil wiyu nuyu marrik angkuwurruni tuka Jesus iminy pu la awunpulakajpuning la wemin. Wenat aminang mali awuniluntuny marrik apumanyi ta kantijawa pa nuyu angkumarrajpu warak. ");
INSERT INTO mph_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus aniwurrung wularrut wu ta awunpulakajpuning la wemin kayirrk la iminy pu, “Kunuka nuyu kurrunpaka la nuwurrimung kuyi walij? Nuwurri marrik kurrungpurru mira ta ngapi kurrunukikang ta nuwurri. ");
INSERT INTO mph_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nuwurri kutpatpi mata wun la marrik kurrukey. La nuwurri larnngalk kutpatpi la marrik kurralyung. La marrik muj kurrungpurru awk ta nuwurripa. ");
INSERT INTO mph_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kurlingka nuwurri kurrungpurrun ta arrawetpang wurrkamaj yurnu ta kantijawa la ngapi ngawunung ta walij pata 5000 napularrumpi arrarrkpi? Kiki ja yangali ta aparutpakpan ta nuwurri kurrapany akpaj?” La wenat aminy, “Wurrkamaj yurnu la wurrkamaj yurnu la ngarrkarrk ja yangali ngarratatikiny mampal.” ");
INSERT INTO mph_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kayirrk la Jesus iminy, “Nuwurri kurrungpurrun muj ta wurrkamaj yurnu la ngarrkarrk ta kantijawa ngapilkpukpung wu pata 4000 pata arrarrkpi la kiki ta aparutpakpan?” La wenat aminy, “Wurrkamaj yurnu la ngarrkarrk ja yangali ngarratatikiny mampal.” ");
INSERT INTO mph_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Malany ja Jesus iminy pu, “Kurlingka nuwurri marrik kurrungpurru ngapi ta God nganilangakanka? Ta ngapi nungmiyarma ngapi wiyu ngakulay nuwurru ta kantijawa.” ");
INSERT INTO mph_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu angkuwung pirl parak tuka wurl ta karrkpin amalkpany awuran tuka kinyuryi muwarn ta kunak wungurlaj Bethsaida. Wakapa wera pata arrarrkpi iwumany parak ja inimany punyikarlu nuyu Jesus kayirrk la iwulakajpung ja Jesus, “Kuwanatpi kuwangulakan.” ");
INSERT INTO mph_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kayirrk la Jesus atimany nuyu yurnu ja arrarrkpi inimalkpany parak yalayala wu pata kawani tuka kunak. Kayirrk la Jesus imijuk nuyu tuka wun la atjutpan ta yurnu nuyu tuka yanat la iminy nuyu, “Malanyapa kannguken la kungayan ta kayirrk?” ");
INSERT INTO mph_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Malany ja arrarrkpi yukeny la iminy, “Ee ngawunayan pata arrarrkpi la puka kawuyirrngun kapin warlk.” ");
INSERT INTO mph_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kayirrk la Jesus muj akutju atjutpan ta yurnu tuka wun nuyu ja arrarrkpi. Kayirrk la yukeny akutju nakapa nungmalal kirrk annyayantung. ");
INSERT INTO mph_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kayirrk la Jesus iminy nuyu, “Anpanuraka!” Yanat iminy, “Kapin ta anpanuraka tuka kunak, yunyi kanngarra warak tuka kawani arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu angparutpan Galilee ta kunak angkumarrajpuning warak tuka kunak ngaw Caesarea Phillipi. Malany ta awarrangung parak tuka alan Jesus awunilakajpung pata awarrangung rtil wiyu nuyu iminy pu, “Malany pukapa pata arrarrkpi ngapi nganpini monmon, wenat kamin mali ngapi nganti?” ");
INSERT INTO mph_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Malany wenat aminy, “Yara pata arrarrkpi kamin nuka John ja aningurtpulukpuning pu imurnanganinyka yarnangkat. La pata wera pata arrarrkpi kamin nuka Elijah nukapa ja arrarrkpi ja wularrut mira iwaning. La pata wera pata arrarrkpi kamin nuyi ta kunininy monmon ta God nuyu wulatpiyi wularrut mira.” ");
INSERT INTO mph_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wakapa la Jesus iminy pu, “La nuwurri kutpin mali ta ngapi nganti?” Kayirrk la Peter iminy parak nuyu manjat, “Nuyipa ta arrarrkpi God kunilangakanka pa anpunpanatpi jir arrarrkpi - nuyi ta arrarrkpi kurrunparnangajpun ‘Christ’.” ");
INSERT INTO mph_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kayirrk la Jesus inginkangung la awunnyung ngaralk iminy pu, “Yunyi kutpin pu pata wera ta ngapi nganti!” ");
INSERT INTO mph_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kayirrk la Jesus annyunman pu pata awarrangung rtil wiyu nuyu ta aliwi angpanaga nuyu la yanat iminy, “Pata wimunpimun la muj pata kawuken ta wulatpiyi la pata kawunpukiki wulatpiyi wenatapa ngantumulutpulun ngapi murnin ngapi ta ngangurlyak ta arrarrkpi ta God nganilangakanka. Pukapa ngantanawun ngapi ngantamalanymakpa la ngantanawun ngawularr. Ngapipa nganamaju nganaw ngarrkarrk ta ngurrij, kayirrk la nganamajpungkin nganawani rtirr ngarnangkat akutju.” ");
INSERT INTO mph_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus inininy monmon pu manjat tuka yanat kiki angpanamin parak nuyu warrwak. Malany Peter marrik animiyarmanyi imartukpuni nuyu ta nungpakapa. La Peter inimany parak awurtpiny parak awunparutpan pata wera la iniluntuny yanatapa ja Jesus la inininy monmon nuyu, “Yunyi kanmin ta nungpaka.” ");
INSERT INTO mph_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kayirrk la Jesus imilkpungeny awunnyayawng pata awarrangung rtil wiyu nuyu, kayirrk la iminy nuyu manjat ja Peter, “Annyanyji nganarutpanyi! Nuyipa kapin Satan! Nuyi marrik kungpurru tuka God nuyu ta wulatpiyi la kungpurrun parak tuka arrarrkpi ta wulatpiyi.” ");
INSERT INTO mph_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kayirrk la Jesus ilajantiny pu amparrkamparrk pata arrarrkpi wakapa awulangaling. Yanat ilajantiny pu la iminy pu la muj pata awarrangung rtil wiyu nuyu, “Ngawu kutjanyjiga kani wanyjikap.” Kayirrk la iminy pu amparrkamparrk, “Kapin nganti kanimiyarma mira nganpaniyarrun ngapi la yunyi kiwurrun ta nuyu wiyu. La yanat iwanamin kapin ngapi. Yanat iwangulinngulin murnin angpanaga ta iwamaju, aralpa, yanat iwamaju kapin ja arrarrkpi ja annyukpung ta wulatpiyi wakapa iwuwarlkarin iwanarnti tuka warlk, kapin ngapi. ");
INSERT INTO mph_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kapin nuka ja arrarrkpi kanimiyarma angpaniyarrun tuka yanat piyu nuyu nakapa marrik annyatping parak - la yanatapa iwalarrutpin marrik yurrng ngatpaning rtil ngapi. La ja kimin marrmarr nganti angpannyarutpa yirrk kani pa tuka kunak-tuka angpaniyarrun warak tuka ngapi la angpanyunma wu pata arrarrkpi ta nungmalal ta wurluj tuka ngapi-yanatapa angpaniyarrun tuka aralpa mira-yanatapa ngatpawani rtil akut la akut. ");
INSERT INTO mph_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kurrungpawurrun, ja arrarrkpi ja kimangirrakan kirrk kani ta kunak ta yanat wiyu nuyu, malany yanatapa iwalarrutpin marrik muj yarray warak yurrng, nuka ja kapirtpalikin nuyu naka ja numurrunjut. ");
INSERT INTO mph_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","La nuka ja kapirtpalikin nuyu nakapa marrik inimang parak tuka yurrng iwaning tuka wungurlyak kunak la angpaniyarrun tuka manjat la aralpa. ");
INSERT INTO mph_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nuwurri kurrungpurrun puka pata arrarrkpi ta kayirrk wenatapa tumurrunjut murnin marrik iwuwurru ja God. Kapin ta iwulagarru nakapa yanat wurwiny inyatping ngartu murnin ta wurluj ta ngungunman nuwurru ta ngapi ngartu, warrwak ngapipa wurwiny nganpanyatpi nuyu. Ngapi ta God nuyu arrarrkpi ta ngangurlyak mira, Malanypi ja ngapi nganimalkpany, ja God, yanatapa nganpaningurlyakpa, la ngapi ngatpamurnanganiga kani ilij pu pata kawani yurrng pata God nuyu pata wurluj kangkumaga. Nganti ja naka kinnyatpi wurwiny ngartu ta kayirrkapa, wakapa ngapipa wurwiny nganpanyatpi nuyu tuka nganamurnanganiga ngapi.” ");
INSERT INTO mph_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kayirrk la Jesus iminy, “Kurralyunyi tuka ta ngaralk ngapi ngamin nuwurru ta kayirrkapa. Nuwurri nuwurrara arrarrkpi kurrungpayan ta wungurlyak mira. Ja God kurrunpanyuki ta yanatapa iwanuken kirrk la nuwurripa kurriwayan yanat ja nulawarrkurlyak mira. Nuwurripa kurrungpayan tuka angpanaga nuyu kayirrk la warrwak nuwurripa kutpamaju.” ");
INSERT INTO mph_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wurrkamaj yurnu ta ngurrij awutpiny Jesus awunimany parak pata Peter, James la John tuka murrgu wakapa awaning palat. Kayirrk la awukeny iwayawng Jesus imelngawung. ");
INSERT INTO mph_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","La ja manpurrwa ja iyarning nakapa iwarlkparrantung mira. Kapin ta arrarrkpi iwuwinypu ja manpurrwa naka marrik iwarlkparranyjing mira kapin ja Jesus iyarning ");
INSERT INTO mph_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","La pata Peter, James la John awunpayawng ngarrkarrk arrarrkpi pata tuwul wularrut - Moses ja yukenang pu ta wularrut mira la Elijah ja ininnyang monmon pu God nuyu ta wurluj - wakapa awaning ngarlakarlak ja Jesus ");
INSERT INTO mph_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","La Peter, James la John amurtpiny mira la marrik muj kiki amina. Parangapa la marrik kiki amina la awunginkanyi la Peter inginkanju iminy nuyu Jesus, “Nuyi ta Ngarrunukiki la tuka ta nungmalal mira ta wungurlyak ta ngarrungayawng! La ngarri ngatanalanganing mata mawngku marakap mata nuyi nuwu la marakap mata Moses nuyu la marakap mata Elijah nuyu!” ");
INSERT INTO mph_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kayirrk la kuynu awunngalakpuyantiny kirrk la God awunilakajpungka tuka kuynu la iminy, “Nuka ja ngapi ngimalkpany ngapi ngimiyarma mira. La nuwurripa kutpanalyu nuyu!” ");
INSERT INTO mph_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kayirrk la Peter, James la John awukekenang wu pata tuwarlkparrakanut la marrik muj awunpayanti. Yarakapju Jesus awulangaling rtil. ");
INSERT INTO mph_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Warrwakapa la awulatpanka tuka murrgu, pa awarrangung parak la Jesus iminy pu ta manjat, “Yunyi kurrungunma wu pata wera tuka kurrungayawng. Kurrungpamirlajunju ta ngapi ta ngangurlyak ta God nganilakangalanka nganamaju werrk warrwak la nganamurnanganiga akutju nuwurru. Kayirrk la kurrungpanunma wu warrwak pata wera tuka kurrungayawng.” ");
INSERT INTO mph_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Malany Peter, James la John awulakujpiny angpatpangju marrik muj nganti amina nuyu. Parang la awunpulakajpuning la wemin ta Jesus iminy tuka iwamaju la iwamurnanganiga. Angkuwurruning mira murnin marrik angkumanyi mira tuka iminang pu. ");
INSERT INTO mph_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kayirrk la iwulakajpung Jesus aminy nuyu, “La pata kawunpukiki ta wulatpiyi awk? Wenat kamin arrarrkpi ja nuwulwularrut ingurlaj Elijah iwamurnanganiga warrwak la God iwanilangakaga yanat nuyu ja ingurlyak arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Kayirrk la Jesus iminy, “Pata kawunpukiki ta wulatpiyi awk angpunman ta aralpa. Ja arrarrkpi ja ingurlaj John yurankapa inininy monmon pu ta God nuyu ta wurluj, kapin Elijah iminy pu ta wularrut mira. Nukapa John ja aningulinnguliny angkat ngartu, parangapa la pata tumurrunjut pata arrarrkpi iwuwung la malany warrwak awanamin akutju ngartu ngapi ta ngangurlyak arrarrkpi ta God nganilangakanka. Ngantanawn kirrwara marrik muj awalyung ngartu. Tukapa kanyu kirrk tuka God nuyu ja jurra.” ");
INSERT INTO mph_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Warrwak la amurnanganiny awulatpanka tuka murrgu tuka awulangalinganka wakapa amalkpany pu pata wera pata awarrangung rtil wiyu nuyu Jesus pata awunpakangung la wemin pata awunpukikang ta wulatpiyi awk. ");
INSERT INTO mph_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wakapa awulangaling awk pata napulurrumpi. Awukeny iwayawng ja Jesus awurlkpalangkeny, kayirrk la iwulimany parak. ");
INSERT INTO mph_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kayirrk la Jesus awunilakajpung, “Kunuka nuyu nuwurri kurrungpaka la nuwurrimung?” ");
INSERT INTO mph_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iwaningan ja arrarrkpi imalkpanyka nuyu Jesus la iminy nuyu, “Nuyi ta Ngarrunukiki ja ngapi ngimalkpany kinnyatpi ja yaliwi la marrik inginkay. ");
INSERT INTO mph_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ja yaliwi kannyen kirrkirrk nuyu la ja marryun kinnyaka warntayurr. La yanat kamawarlkanyi tuka kunak kernangkeyikin kimanpun ta yiyigi la kamaniwun malagatagat. La ngapi ngawuntakajpung pata kurrarra rtil ta iwakanyi nuyu ja yaliwi la makiny marrik iwakanyi nuyu.” ");
INSERT INTO mph_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","La Jesus iminy, “Kurlingka nuwurri marrik kutpartukpu ngartu? Murnin ngapi marrik angkat arrkpaning ngayamang nuwurru. Kurrimanyiga ja marryun ngartu ngapi!” ");
INSERT INTO mph_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","La pata arrarrkpi iwumanyka ja marryun nuyu Jesus. Innyayawng ja yaliwi ja Jesus wakapa annyeny kirrkirrk nuyu ja marryun warntayurr innyakan - imirtujpikpiny kapin arukin tuka kunak la maniwuning malagatagat. ");
INSERT INTO mph_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kayirrk la Jesus inilakajpung ja mayakpu, “Kurlingka arntulyak ja marryun tukapa iminang?” Kayirrk la ja mayakpu iminy, “Malany tukapa arntulyak mira tuka iminang ilijap. ");
INSERT INTO mph_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Malany wugarra yirrk mira ja yaliwi annyenang kirrkirrk nuyu mawarlkanyang parak tuka yungku la tuka wupaj. La ja yaliwi kimin mali iwaniwun iwularr! Kurlingka marrik kawatping ngarru wurlk? La kungulakanyjing.” ");
INSERT INTO mph_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kayirrk la Jesus iminy, “Nuyi ankangkarlekeny ngartu, Kurlingka nuyi marrik kuwurru ja God ja ingurlyak mira ta imi yirrk nuwu la anmartukpu nuyu?” ");
INSERT INTO mph_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Wakapa ja mayakpu ilajantiny, “Ngapi ngamartukpun nuyu God iwayama nuyu! Ngapi ngalajaka nuwu arrkpayirtiki tuka nganamartukpun mira nuwu!” ");
INSERT INTO mph_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","La Jesus yukeny awunnyayawng wigarra yirrk pata arrarrkpi awarrangungka angkumiyarmangung iwayanti. Kayirrk la ilirrinyminy inilarraniny ja yaliwi kayirrk la inginkan iminy nuyu ja yaliwi, “Nuyi ta nuwaliwi kungen kirrkirrk wu arrarrkpi marrik awunginkay la marrik awalyung, ngapi ngamin nuwu anmalkpanyiga kayirrk korutpanyi ja marryun. Marrik muj nuyi anmurnanganingka nuyu!” ");
INSERT INTO mph_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kayirrk la ja yaliwi ilajantiny la annyeny kirrkirrk nuyu ja marryun innyakan akutju ja warntayurr la yuratjurr tuka kunak, warrwakapa la innyarutpan ja yaliwi ja marryun la iwayawng ja marryun la aminy mali imajungan la pata wigarrayirrk pata arrarrkpi aminy, “Ortoko, aniwularrung!” ");
INSERT INTO mph_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Parangapa la Jesus atimany nuyu yurnu la inimajpungkuny la wakapa ja mayakpu inimany ja marryun la awurakan tuka kunak. ");
INSERT INTO mph_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Warrwak la Jesus la pata awarrangung rtil wiyu nuyu awuran awurlgeny tuka kurrampalk, la pata awarrangung rtil wiyu nuyu iwulakajpung, “Kunuka nuyu ngarri marrik ngarryakanyi nuyu ja yaliwi ja marryun?” ");
INSERT INTO mph_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kayirrk la Jesus iminy pu, “La arakapju kutpi tuka kurryakay ja yaliwi nakapa kutangaling iwarruj la kurrilakajpu God pa yanat innyakay!” ");
INSERT INTO mph_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Warrwak la Jesus la pata awarrangung rtil wiyu nuyu angparutpan wakapa ta kunak la awarrangung parak Galilee ngaw ta kunak. Malany tuka awarrangung parak nakapa awunnyukikang parak pata awarrangung rtil wiyu nuyu. Marrik animiyarmanyi wigarrayirrk angkuwurruni tuka awarrangung parak. Malany tuka awarrangung parak marrik muj nganti aniwurruni murnin malakpuj awarrangung parakju. Kayirrk la iminy pu tuka yanat kiki angpanamin parak nuyu la yanat iminy pu, “Pata tumurrunti pata arrarrkpi ngantanama warak, ngapi ta ngangurlyak arrarrkpi ta God nuyu, la ngantanawun ngawularr. Kayirrk la nganaw ngarrkarrk ta ngurrij la nganamajpungkin.” ");
INSERT INTO mph_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","La pata Jesus awarrangung rtil wiyu nuyu marrik angkuwurruni mira tuka iminang pu murnin amurtpinang ta iwulakajpuni. ");
INSERT INTO mph_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Malany ta awarrangung parak tuka alan pata Jesus awarrangung rtil wiyu nuyu awunpakangung la wemin la aminang, “Ta Ngarrurri ta karrarra rtil Jesus nganti ja ingurlyak mira?” Malany awarran parak amalkpany Capernaum. Kayirrk la awarran parak awurlgeny tuka kurrampalk tuka awanaw. Kayirrk la Jesus awunilakajpung, “Kunuka nuyu kurrunpakangung la nuwurrimung tuka alan tuka atjangungka?” La pata awarrangung rtil wiyu nuyu awunnyatpung wurwiny marrik muj iwulakpanyi. ");
INSERT INTO mph_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Malany Jesus yuranap la iminy pu, “Nganti ja kanimiyarma iwanuken? Nakapa ja arrarrkpi marrik iwurru ta nuyu wiyu la imi ngapi ta ngangurlyak la iwayama wu wigarrayirrk.” ");
INSERT INTO mph_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Malany wakapa ilangaling ja warrayngiw anyak la Jesus inimany inimajpungkuny la iminy pu, “Kurrayanti nuka ja warrayngiw anyak. Kapin ta ngarrunjarru ngapi la kurrimiyarmang la nuwurri kutjirtiking ja warrayngiw anyak kapin nuka, nakapa kapin ngapi akutju ngarrunmiyarmang. La ta ngarrunmiyarmang mira ngapi wakapa kurriwamiyarma mira ja ngapi nganimalkpany ja kiwani yurrng. Yanatapa ja nganilangakanka. ");
INSERT INTO mph_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kayirrk la John iminy nuyu Jesus, “Nuyi ta Kannguken ngarru, ngarrayawng ja arrarrkpi kuniwarnangajpukpuning nukurlaj awunnyatpang la awuningulakantung innyakangung ja yaliwi wu pata arrarrkpi la yanat ja marrik ngarrurri ngarrurru la ngarri ngatpiny nuyu, ‘Yunyi kanmin!’” ");
INSERT INTO mph_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kayirrk la Jesus iminy, “Makiny! Yunyi kurriwirtata. Kapin nganti ja awunpaningulakan tuka ngantuwarnangajpukpun ta ngangurlaj marrik muj imilkpungay inginkay ta aliwi ngaralk ngartu ngapi. ");
INSERT INTO mph_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kapin tukapa: nganti yirrik ja marrik arruniwirtatay nakapa ja kaniyarrun parak tuka ngarrurri ngarrurru. ");
INSERT INTO mph_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","La muj nganti yirrik ja kaniwurrun nuwurri ta ngapi karrarra rtil la yanat kanimiyarma kutpayirtiki tuka kurrunpannyartawn wupaj yanat, malany ja God apanilulkanyi nuyu tuka nungmalal iminang nuyu.” ");
INSERT INTO mph_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“La ja arrarrkpi ja iniwutakay ilij ta waryat tuka majarr la inyakay tuka kurrula anilang marngnalk nungpakapa nungmurrunti ta angpanamin nuyu ja arrarrkpi. La ja arrarrkpi kinnyukiki ta aliwi ja warranyngiw anyak ja nganimiyarma la kaniyarrun warak ta nungmurrunti ja warranyngiw nukapa God iwayintukun nuyu nungpaka nungmurrunti mira angpanamin nuyu ja arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kapin ta kunuka yirrik kuningulay anmi ta nungmurrunti nungpakapa kungpanarutpa ta aliwi. Kapin tuka yurnu ta kungmarrartpi kanmin ta aliwi nakapa kungarutpanyi yunyi kanmin ta nungpaka - la kapin ta katalkung awarakap yurnu. Nakapa nungmalal ta anngarray kawatping awarakap yurnu pa marrik annying ngarrkarrk yurnu tuka nungmurrunti kunak. Wakapa tuka nungmurrunti kunak kamala mata yungku akut la akut marrik muj mamajung! ");
INSERT INTO mph_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kapin nungpakapa akutju tuka kungarlukpa kunngangulay anngarray warak tuka aliwi la anmi ta aliwi, kungpanarutpa ta nungpaka - la kapin katalkung awarakap yurnu tuka kungarlukpa. Nakapa nungmalal ta kawatping awarakap yurnu tuka kungarlukpa pa marrik annying ngarrkarrk yurnu tuka nungmurrunti kunak. ");
INSERT INTO mph_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Malany mata wun nungpakapa akutju kangunmin. Kapin mata nuyi nuwu mata wun koyan yaliwiyut awk la kanmin ta aliwi, kuwanawun larr yunyi kanmin ta nungpaka kapin ta anmakay mata wun. Nungpakapa nungmalal ta kutpaning rtil God ta anmatping marakap namalal mata wun la marrik muj annying anmatping parak ngarrkarrk mata wun tuka nungmurrunti kunak. ");
INSERT INTO mph_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Malany wakapa tuka nungmurrunti kunak nakapa nungmurrunti mira la pata arrarrkpi pata kawarrra warak wakapa awunpangarajpukpun akut la akut. La awunpannyen kapin wirtu awunpanila akut la akut la muj awanala kapin yungku awanalyu akut la akut. La tuka awunpangarajpukpun marrik muj antakujpi.” ");
INSERT INTO mph_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Akutju Jesus iminy pu, “God angpannyatpi nuwurru arnangkat nuwurrkarra yirrk ta marrik kurralyung nuyu ja Kiwken. Kapin tuka angpanamin parak yungku mannyanakaga awanala yirrk.” ");
INSERT INTO mph_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kayirrk la Jesus iminy, “Nuwurri kurriwurrun ja jirla naka numalal. La ta karryutpa tuka walij karratalken napalal. La kapin ta kiw kerrikpa ja jirla nakapa numurrunti karryaka. Nungpakapa kangmin parak nuwurru ta nuwurri. Nuwurri kutpanamin kapin jirla wu pata arrarrkpi. Nuwurri kutpanunmen tuka kutpunpanuki tuka awawani nungmalal warak. La nuwurri akutju kutpawani rtil nungmalal kirrk kurruntanama la nuwurrimung.” ");
INSERT INTO mph_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Malany Jesus annyarutpan wakapa ta kunak la yuran ta kunak ngaw Judea la muj aniwukpirl wurrkaraga ta wumawurr ngaw Jordan. Malany wakapa amalkpanyka nuyu napulurrumpi pata arrarrkpi. Wakapa Jesus ininnyang monmon pu kapin tuka yurakan iminang la ininnyang monmon pu. ");
INSERT INTO mph_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Malany yara pata Jew arrarrkpi pata awukenang ta wulatpiyi awk wu pata Pharisees awuranka wakapa tuka Jesus. Malany wenat angkumiyarmangung iwulagarruni tuka iwulakajpuni. La aminy nuyu, “Kurlingka nungmalal ja arrarrkpi ta innyarutpay jita kawani la innyilangakay inying?” ");
INSERT INTO mph_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus iminy, “Kunuka ta Moses animirrawung ta wulatpiyi tuka God nuyu ja jurra?” ");
INSERT INTO mph_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Malany Jew pata awukenang ta wulatpiyi awk aminy, “Moses animirrawung nungmalal ja arrarrkpi inyarutpay jita kawani. Nakapa ja arrarrkpi animirrawu tuka jurra annyutpay ta inypannyarutpa jita awaning. Yanat inypannyun ja jurra la inypanilangaka inypana.” ");
INSERT INTO mph_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus iminy pu, “Moses animirrawung ta wulatpiyi iminy nungpakapa murnin nuwurri ta arrarrkpi kurrungmajput mata larlngalk nuwurru la marrik muj kurralyung nuyu ja God. ");
INSERT INTO mph_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","La God nuyu ja jurra kimin ngarrurru God ininguliny ilinyjinyut imun la muj arrarrkpi la warramumpik awuninguliny. ");
INSERT INTO mph_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","La kimin ngarrurru ta arrarrkpi la warramumpik ta awuntanarutpa pata mayakpu la nigi la inypanima la yamin. ");
INSERT INTO mph_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","La marrik muj wenat ngarrkarrk makiny. Kapin kayirrk wenatapa werakap ta wingijalk tuka kinyima la yamin. ");
INSERT INTO mph_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kurrungayanti kurrungpawurrun tuka God ja kawuningula kawunimirtujpa arakapju parang, malany marrik muj nganti awunnyartpirray.” ");
INSERT INTO mph_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Warrwak la Jesus la pata awarrangung rtil wiyu nuyu amurnanganiny parak tuka kurrampalk la iwulakajpung angkumiyarmangung ininyang monmon mira wu. ");
INSERT INTO mph_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Malany Jesus iminy pu, “Kapin ja arrarrkpi kinyarutpa la yamin la kinyima ninyara jita warramumpik, jita kawu rtil jita warramumpik naka marrik manjat. Kannyukpun ta God nuyu ta wulatpiyi ta kimin, nungpaka nungmurrunti ta kinyarutpa jita kawani jita yanat nuyu. ");
INSERT INTO mph_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kapin jita warramumpik kingarutpa la yamin ja kawani la kingama jara ja arrarrkpi kawu rtil la naka marrik manjat la inyanat kangowkpun ta God nuyu ta wulatpiyi.” ");
INSERT INTO mph_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Warrwak la yara pata arrarrkpi awuntumany parak wenat pu pata warrayngiw nuyu Jesus. Wenat angkumiyarmangung Jesus annyatpa wu wanji la inilakajpuni God pa awunpannyayatayan. Malany pata Jesus awarrangung rtil wiyu nuyu awunpuluntuny pata arrarrkpi la aminy pu, “Kutpunmanyi warak pata warrayngiw.” ");
INSERT INTO mph_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Malany Jesus awunnyayawng pata awarrangung rtil wiyu nuyu ta awunpulatpaniny pata warrayngiw ta awarranyi warak tuka yanat la ilirrinyminy. Yanat iminy, “Yunyi kutpuntatpani pata warrayngiw! Kutpunarutpanyi awanyjiga tuka ngapi! Pukawk nuyu pata arrarrkpi God kawunimiyarma. Malany God nuyu pata arrarrkpi kapin pukapa pata warrayngiw. ");
INSERT INTO mph_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta ngamin nuwurru ta manjat, kapin kutpunayanti pata warrayngiw ta kamartukpun pu ja mayakpu la jita nigi. Kapin ta nuwurri kutpartukpu ngartu ngapi kapin puka pata warrayngiw la kamartukpun pu pata nigi la mayakpu. Kapin ta marrik kutpartukpu kapin puka pata warrayngiw nakapa nuwurri ta marrik God nuyu ta arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kayirrk la Jesus awunimany pata warrayngiw awunilagatpung la ilingan iwarruj pu inilakajpung God tuka awunpannyayatayan. ");
INSERT INTO mph_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Warrwakapa la Jesus imajpungkiny yarrangung parak. Kayirrk la yarakap arrarrkpi ingurriny parak tuka yanat la innyeny kartawarrkartawarr la iminy, “Nuyi ta nukpalal ta Ngarrunukiki, kiki nganamin tuka nganawani warak nungmalal la muj nganawani akut la akut?” ");
INSERT INTO mph_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kayirrk la Jesus iminy, “Kunuka nuyu nganparnangajpun, ‘nukpalal?’ Nuyi kungpurrun God yarakapju ja numalal. Nuyi kunuka kungpurrun mira tuka ngapi ngartu? ");
INSERT INTO mph_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","la nuyi kungpurrun ta God nuyu ta wulatpiyi. Yunyi kutpunpun wiwularr pata arrarrkpi. Yunyi kurrinyma wumpulaj jita warramumpik jita jara nuyu ja arrarrkpi kawani. Yunyi kutiwumpulakaj wu wera pata arrarrkpi. Yunyi kurrimanmalagarr warak wu pata wera. Yunyi muj kutpuntagarrukun la kurrima wu pata wera. Kutpamartukpun wu pata nigi la mayakpu.” ");
INSERT INTO mph_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kayirrk la nakapa ja arrarrkpi iminy, “Nuyi ta Ngarrunukiki ngapi ngungatpakjir ta tukapa. Ta ngapi ngaminang ngalijap nungpakapa ngungatpang.” ");
INSERT INTO mph_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kayirrk la Jesus yukeny innyayawng inimiyarmany la muj iniwurlkpungkuny. La Jesus iminy, “Wakapa arakap akutju anpanamin. Annyanyji ankakpolorrka kunuka ja kotpi la kuwanama ja rrupiya kayirrk la anpana anpunpanawn kirrk ja rrupiya pata arrarrkpi murnin tuwunirri marrik kunuka iwatping. Nungpakapa anpanamin kirrk, pa God iwanamin marrmarr nuwu la muj kunpannyun kirrk nungmalalut. Malany yanatju ja kiwani yurrng kinnyatpi nuwu. La nuyipa, ngawu nganpayarrun ngapi arrkpanarra rtil kunpanukiki pa kungpawurrun mira.” ");
INSERT INTO mph_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Malany yanatpa ja arrarrkpi ta yalyungan ta Jesus iminy nuyu yanat marrik muj imina marrmarr murnin innyatpang imurra ja rrupiya murnin Jesus yurakan iminy nuyu, “Anpunpanawn kirrk kunuka ja kotpi awk.” La yanat marrik muj imina marrmarr la imajpungkiny yarrangung kuyulk parak. ");
INSERT INTO mph_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Warrwak yanatapa ja arrarrkpi ta yuran Jesus yukeny la awunnyayawng pata awarrangung rtil wiyu nuyu la iminy pu, “Arrarrkpi pata kiwatpi imurra rrupiya marrik angkumiyarmang God yuke wu. La wenat angkanatpi arnangkat mira tuka wenat wiyu wu.” ");
INSERT INTO mph_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Pata awarrangung rtil wiyu nuyu awurlkpalangkeny ta awalyungan tukapa pa yanat inininy monmon mira wu. La yanat iminy, “Tukapa arnakat mira la wimurra pata arrarrkpi marrik angkumiyarmang God yuke wu. Kurriwurruni ja karrpin ja camel. Kurlingka yurlge parrwarr tuka wulijap ta kantaji tuka needle? Makiny marrik kiki imi. Ngapi ngamin nuwurru tuka. La ja karrkpin ja camel marrik yurlge parrwarr tuka wulijap ta kantaji kapin ja arrarrkpi ja kinnyatpi imurra rrupiya yanat akutju marrik yarray warak tuka God nuyu. Malany arrarrkpi pata kiwatpi imurra rrupiya kangpayan arnangkat tuka wu wiyu marrik angkumiyarmang God yuke wu.” ");
INSERT INTO mph_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Malany pata awarrangung rtil wiyu nuyu awurlkpalangkeny la aminy pu la wemin, “Malany warra nganti pata God awunpannyatpi la iwanuken pu? Ngungpurrun marrik nganti muj!” ");
INSERT INTO mph_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","La Jesus yukeny awunnyayawng la iminy pu, “Marrik nganti yarray warak tuka God la awunnyatping la yuke wu. La yanatju yarakap God iyamang pu. Malany yanat God iwayama nuwurru yanatju kaniwurrun kirrk.” ");
INSERT INTO mph_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kayirrk la Peter iminy nuyu Jesus, “Ngarri ngarrungarutpan kirrk la karrarra rtil nuyi. La ngarri kiki ngatpanamin?” ");
INSERT INTO mph_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Malany Jesus iminy, “Malany nganti ja annyarutpan kirrk nakapa iwana angpannyunma wu pata arrarrkpi ta God nuyu ta nungmalal wurluj malany God awunpannyunka wugarra yirrk tuka iwayama wu. Kapin nganti ja angpannyarutpa ta kunak nuyu la pata awulinganut la jita nigi la ja mayakpu la pata warrayngiw awunpannyarutpa la ngatpanarra rtil ngapi la angpannyunma wu ta nungmalal ta wurluj pa awawani warak nungmalal kirrk la muj God awunpaningurlyakpa awunpannyun wugarra ta kunak la muj awunpannyun wimurra pata awulinganut la wimurra pata warra nigi la wimurra pata warrayngiw muj kunak awunpannyun. La tuka muj nganamin nuwurru, kapin ta tukapa awanamin ta awayama ngartu ngapi nakapa wera pata arrarrkpi awuntanarnama. Malany ta warrwak nakapa awawani rtil God akut la akut kapa yurrng tuka nungmalal kunak. ");
INSERT INTO mph_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Malany pata arrarrkpi pata wimunpimun pata kawuken pu angkayan ta wenat tuwurnirri marrik kunuka iwatping. Malany warrwak la God awunpannyun tora tuka awayama wu weminpi la wemin. Malany pata arrarrkpi pata kawuyama kayirrk wakapa warrwakapa awanuken pu.” ");
INSERT INTO mph_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Malany Jesus la pata awarrangung rtil wiyu nuyu awarrangung parak kapa Jerusalem la Jesus yurakan parak. Malany wenat pata awarrangung rtil wiyu nuyu awurlkpalangkeny. Malany wenat wularrut angkuwurruning ta angkanama lirri wakapa Jerusalem. Malany wera pata awarrangung rtil amurtpiny akutju. La Jesus ilarrajpany la awunimany pata awarrangung rtil wiyu nuyu la awunnyarutpan pata wera pata arrarrkpi la annyunman pu ta yanat warrwak kiki yirrik angpanamin parak nuyu. ");
INSERT INTO mph_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Malany Jesus iminy pu, “Kayirrk ngarrurri karrarra yirrk warak kapa Jerusalem wakapa nganti yirrik ja awunpaniyarrun parak pata tumatpa wiwalu la awayirtiki tuka ngantanama ngapi. La muj pata tumatpa wiwalu pata wimunpimun la pata kawuken wulatpiyi awk la pata kawunpukiki. La ngapipa ta ngangurlyak ta God nganilangakanka. Malany pata wimunpimun pata Jew arrarrkpi ngantanama la ngantanama warak tuka kawani pata kawuken pata Roman arrarrkpi. La awanamin ngartu ngapi ta ngungukpung ta wulatpiyi wu pata Jew arrarrkpi la awanamin pu pata kawuken pu pata Roman arrarrkpi, “Kurriwanawun.” ");
INSERT INTO mph_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Malany pata Roman arrarrkpi ngantamalanymakpa la ngantamarnparrukun maralngkiny. La muj ngantanawun wilkpujpilkpuj kayirrk la ngantanawun ngawularr. Warrwak la ngarrkarrk ta ngurrij la nganamajpungkin nganawani rtirr ngarnakat.” ");
INSERT INTO mph_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James la John (pata awunimalkpangung Zebedee) iwulakajpung Jesus aminy nuyu, “Ngarrungmiyarma anpanamin ngarru ta nungmalal.” ");
INSERT INTO mph_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kayirrk la Jesus awunilakajpung, “Kiki nganamin nuwurru?” ");
INSERT INTO mph_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kayirrk la wenat aminy, “La warrwak nuyipa ta anpanuken mira. La nuyi ta warrwak ngarri ngarrungmiyarma ngatpanuken akutju la nuyi anpanuraka ngarru la ngarri kurrunpalulkuwi. Malany ta nuyi anpawani tuka kapal la ngarri ngatpawani wurrkara wurrkara.” ");
INSERT INTO mph_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Malany Jesus iminy pu, “Nuwurri marrik kunuka kurrungpurru ta ngarruntakajpun. Kurlingka nuwurri kutpanarra warak tuka arnangkat angpanaga nuwurru kapin ngapi nganamin? Tuka nganpangarajpukpun-la kapin ngungpanala ta nuntakputirri ta wupaj, la muj kapin nganarra warak tuka marrngarla ta iwanimajpungkuga.” ");
INSERT INTO mph_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Malany James la John aminy nuyu, “Ee! Malany nungpakapa ngatpanamin.” La Jesus iminy, “Nungpakapa aralpa! Kurrungpanatpi ta arnakat kapin ngapi, la nuwurri kurrungpanatpi la muj kurrungpangarajpukpun kapin ngapi ngungpanatpi.” ");
INSERT INTO mph_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Malany ngapi marrik kurrunutpay tuka nuwurri kurrungmiyarma. Malany yanat God iwanamin nganti ja iwanuken, la yanatapa ja awunpannyutpa tuka awawani wurrkara wurrkara tuka ngapi ngatpawani rtil kapa yurrng.” ");
INSERT INTO mph_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","La muj pata wera pata 10 pata awarrangung rtil wiyu nuyu ta awalyungan pu pata James la John ta iwulakajpung, nakapa wenat awulirrinyminy. ");
INSERT INTO mph_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kayirrk la Jesus awunimany awunimirtujpany la iminy pu, “Malany nuwurri kurrungpurrun wu pata wimunpimun pata kawuken kanipa tuka kunak awk tuka katpani wenat kangkumiyarma ta awanuken mira wu pata wigarra yirrk. Kapin kangmin tuka wugarra yirrk ta kunak awk malany pata wimunpimun kangkumiyarma awanuken mira wu pata wigarra yirrk. ");
INSERT INTO mph_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Malany ngapi marrik ngungmiyarmang kutpi nungpakapa. Kapin ta kurrungmiyarma kutpanuken pu pata ngapi ngartu arrarrkpi nakapa kutpayirtiki rtil la kutpayama mira wu la marrik muj kurriwurru ja rrupiya. Kapin ta kurrungmiyarma kutpanuken mira nakapa kutpayama wu wigarra yirrk. ");
INSERT INTO mph_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","La nuwurri kurrungayan pata awanuken wu arrarrkpi pata ngapi ngartu nakapa nungpakapa awanamin kapin ngapi ngamin, ngapi nungpakapa ngamin. La ngapi ta ngangurlyak arrarrkpi God nganilangakanka la marrik ngungmiyarmang ngapi nguke nuwurru la ngawunjurrngpukpuy pata arrarrkpi awuyamang ngartu. La ngapi nguranka nganayama nuwurru amparrkamparrk. La ngapi God nganilangakanka nuyu nganalulkanyi nuwurru nuwurri ta kurrungatpi nungmurrunti-la muj nguranka nganamaju nuwurru nuwurrkarra yirrk ta arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Malany Jesus la pata awarrangung rtil wiyu nuyu awarrangung parak kapa Jerusalem, malany ta awarrangung parak nakapa angkuwarlkijpangung parak ta kunak wungurlaj Jericho. Malany ta angparutpan ta kunak Jericho wakapa wigarra yirrk pata arrarrkpi awarrangung rtil warak tuka alan. Malany ja punyikarlu ja arrarrkpi ja iwaning wakapa tuka alan awunilakajpukpuning pata arrarrkpi rrupiya pa ilakpolorrka nuyu walij. Malany ja ingurlaj Bartimaeus, (malany ja yanat inimalkpany ingurlaj Timaeus.) ");
INSERT INTO mph_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Malany ja Bartimaeus yalyungan ta Jesus ja nuwuran Nazareth, ta yangkungka tuka alan, pa inimajrtalk ta ilajantung iminang, “Jesus nuyi ta David kanmin nuyu wawupawu la ngapi ngungpurrun kirrk ta nuyi, malany nuyi anpanuken ngarru kapin yanat iminang. La kunpurlkpungka ta ngapi la nganngulakanti!” ");
INSERT INTO mph_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kayirrk la pata wigarra yirrk pata arrarrkpi iwuluntuny la aminy nuyu, “Ankakujpina!” Malany yanat angkat ilajantung ta murr mirayu iminang, “Jesus nuyi ta David kanmin nuyu wawupawu la ngapi ngungpurrun ta nuyi malany anpanuken ngarru kapin yanat iminang. La kunpurlkpungka ta ngapi la nganngulakanti!” ");
INSERT INTO mph_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kayirrk la ja Jesus ilarrajpany la iminy, “Kutpina nuyu yanyjiga kani tuka ngapi.” Pa awulajantiny nuyu aminy, “Batimaeus, anmina marrmarrapa. Anmajpungkina! Jesus kilaja nuwupa!” ");
INSERT INTO mph_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Malany nakapa ja punyikarlu imajpungkiny ilarrajpany la iniyarrung parak ja Jesus. La innyarutpan nuyu ja pajupaju warrwak. ");
INSERT INTO mph_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kayirrk la Jesus inilakajpung iminy nuyu, “Malany? Kiki nganamin nuwu?” Kayirrk la ja punyikarlu inilakpany iminy nuyu, “Nuyi ta Ngarrunukiki, ngapi ngungmiyarma nganukan!” ");
INSERT INTO mph_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kayirrk la Jesus iminy nuyu, “Kapin nuyi ta kayirrk ngapi kanmartukpun ngartu malany kunpangulakan kayirrkapa”. Kayirrk la iminy nuyu, “Anngurakanyi tuka kunak.” Malany wakapa mannyatpalantiny mata wun nuyu ja Bartimaeus la yukenyapa, kayirrk la awuniyarruning parak wera pata arrarrkpi kayirrk la iwuyarrung yirrk parak ja Jesus tuka alan. ");
INSERT INTO mph_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Malany Jesus la pata awarrangung rtil wiyu nuyu angkat awarrangung parak la amalkpangung parak ta Jerusalem. Kayirrk la awuranka tuka ngarrkarrk ta kunak wungurlaj Bethany la Bethphage, tuka murrgu kamalangali mata Olive mata warlk. ");
INSERT INTO mph_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Malany wakapa Jesus iminy pu ngarrkarrk pata awarrangung rtil wiyu nuyu, “Kutpana tuka wanyji kunak.” Kayirrk la iminy pu, “Malany ta kutpamalkpa wakapa kurriwayan ja miyul iwuwutiny alguru tuka warlk. Marrik nganti muj innyarlkpanyi akutju nakapa ja wurrwurr ja miyul. Malany ngapi kurrunmiyarma kutanartpirra nuyu mata alguru la kurriwanamaga ngartu ngapi. ");
INSERT INTO mph_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Malany nganti ja kurrunpanilakajpun nuwurri, ‘Kunuka nuyu kurrima warak ja miyul’, la kutpanamin nuyu, ‘Ja ngarri kiwken ngarru kinimiyarma, la yunyi kuwurrun, malany iwanimurnanganiga nuwu warrwak.’” ");
INSERT INTO mph_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Malany pata ngarrkarrk arrarrkpi awuranapa tuka kunak. Malany warrwakapa la iwayawng ja miyul, parangapa la mampartpirrantung nuyu mata alguru tuka wanyji kurrampalk ilangaling. ");
INSERT INTO mph_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Malany yara pata arrarrkpi awulangaling wakapa aminy pu, “Malany nuwurri kiki kutpin? Nuwurri kunuka nuyu kutpartpirra nuyu mata alguru nuka ja wurrwurr ja miyul?” ");
INSERT INTO mph_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kayirrk la pata Jesus awarrangung rtil wiyu nuyu aminy pu, “Jesus ngaralk nuyu iminy ngarru.” Malany pukapa pata arrarrkpi awunparutpanapa iwumany parak. ");
INSERT INTO mph_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kayirrk la iwumany parak ja miyul nuyu Jesus. Malany wakapa iwuwalkariny nuyu manpurrwa ja miyul, kayirrk la Jesus yuranap tuka manpurrwa ja tuka miyul iwutpan nuyu parangapa la innyarkpangung parak kapa Jerusalem. ");
INSERT INTO mph_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Malany wigarra yirrk pata arrarrkpi iwutpangung ja manpurrwa wu tuka alan angpungulangung alan nuyu ja miyul la yara pata arrarrkpi awuran tuka karrape la mampulalkungung mawiya awk la mamputpangung tuka alan akutju pa wakapa yarrangung juju warak ja miyul tuka merrk mamputpangung awk. ");
INSERT INTO mph_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Malany yara pata arrarrkpi awurakangung nuyu ja Jesus la yara pata warrwak iwululkungung. Parangapa la awulajantung la aminang, “Hosanna! God nuyi ta nukurlyak la nuyi kungurlyakpany nuka ja arrarrkpi ingurlyakpiny akutju. Malany nuwulyanatju ngarrunpanatpi jir. Hosanna! God nuyi kuwung ta wutkut nuka ja arrarrkpi la ta kayirrkapa ngarri kerraga ngarru. ");
INSERT INTO mph_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nuyi God kurruntakajpun kuwangurlyakpa nuka ja arrarrkpi iwanuken ngarru amparrkamparr kapin ja yanat kimin wawupawu ja yukenang pu David. God ta kanpani tuka yurrng nuyi ta nukurlyak la muj nuyi kungurlyakpany nuka ja arrarrkpi akutju. Malany nuwulyanatju ngarrunpanatpi jir!” ");
INSERT INTO mph_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Malany Jesus imalkpany tuka Jerusalem wakapa yarran parak yurlgeny tuka God nuyu ta karrpin mira ta akurlyak kurrampalk. Kayirrk la yukekenang annyayantung ta kiki aminang. La jita muwarn wularrut inyuryiling parak kayirrk la ja Jesus la pata 12 pata awarrangung rtil wiyu nuyu amalkpany yalayala amurnangannyang parak kapa Bethany. ");
INSERT INTO mph_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","Kayirrk la ta nungmatpa ngurrij Jesus la pata awarrangung rtil wiyu nuyu amajpungkinyka kapa Bethany amurnangannyang parak kapa Jerusalem. Malany Jesus mannyayawng mata warlk malany wakapa wanyji malangaling. Mukapa mata warlk kamangatpi mangijalk kapin yirrkari. Malany Jesus imajung wirrngak kayirrk la yarran parak yukeny arlarrarr la mawiya marntiking muj arlarrarr ja ingijalk. (Murnin ja ingijalk marrik iningulanyi, malanypi warrwak la ingijalk iwaningula.) ");
INSERT INTO mph_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kayirrk la pata Jesus awarrangung rtil wiyu nuyu awalyungan nuyu ta kiki iminy ngaw mata warlk, “Marrik muj nganti inilang ja ingijalk mata nuyi nuwu mata warlk”. ");
INSERT INTO mph_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu amalkpany Jerusalem. Malany awurlgeny parak tuka God nuyu ta karrpin mira ta akurlyak kurrampalk. Malany wakapa ta wukej tuka God nuyu ta karrpin mira ta akurlyak kurrampalk pata arrarrkpi awulakpolorrkang karlurri awk la angpatpang mulil. La wera pata arrarrkpi awukunyjilinang pata Roman wu ja rrupiya la pata Jew wu ja rrupiya pa awunpuning parak pata awukenang pu tuka God nuyu ta karrpin mira ta akurlyak kurrampalk ja Jew wu ja rrupiya. Malany tukapa aminang tuka God nuyu ta karrpin mira akurlyak kurrampalk. Malany marrik muj angpatpa wanji nungpaka nungmurrunti ta aminang. La yara pata arrarrkpi pata awulakpolorrkang nakapa awuling wumpulaj. Malany Jesus wakapa awunimalkpany kirrk pata arrarrkpi wakapa pata awulangaling awk tuka God nuyu ta karrpin mira ta akurlyak kurrampalk - pata awulakpolorrkang la pata awukunyjilinang. Malany yanat mannyakan parak mata palapala tuka rrupiya awk yung, la muj mannyakan parak warlk mata awarnting pata arrarrkpi la awulakpolorrkang karlurri awk. ");
INSERT INTO mph_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Malany yanat awunilatpaniny marrik muj nganti inimalkpanyi la innyaluntanyiga yirrk awk tuka God nuyu ta karrpin mira ta akurlyak kurrampalk la muj tuka mingkaga. ");
INSERT INTO mph_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Malany tukapa iminang ja Jesus tuka awunnyukikang, la warrwak la iminy, “Ta wularrut mira God iminy pu pata yanat nuyu arrarrkpi, ‘Kurrungpamirrawun tuka ta ngaralk tuka ngapi ngartu jurra’ ‘God kawunimiyarma arrarrkpi pata tuwuran wugarra yirrk kunak ta awanaga awalangali iwarruj nuyu tuka yanat nuyu ta karrpin mira ta akurlyak kurrampalk.’ Malany kayirrk nuwurripa kurrungmilkpungeny tuka God nuyu ta karrpin mira ta akurlyak kurrampalk ‘la kayirrkapa kutpin nungmurrunti mira tuka kuti wumpulaj wu pata wera.’” ");
INSERT INTO mph_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Malany pata Jew pata awunpukikang ta wulatpiyi wu la muj pata awukenang pu ta awulangaling mulil marrik amina marrmarr. Malany wenat awalyungan ta kiki iminy ja Jesus tuka God nuyu ta karrpin mira ta akurlyak kurrampalk parangapa la aminang pu la wemin, “Kiki atpanamin la arriwanawun?” La pata Jew arrarrkpi pata awukenang pu amurtpiny iwumurtpan. Parangapa la pata wigarra yirrk pata arrarrkpi naka aminang marrmarr mira nuyu ja Jesus la muj angkumiyarmangung mira tuka awalyung nuyu tuka awunyukikang. ");
INSERT INTO mph_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Malany ta inyuriliny parak Jesus la pata awarrangung rtil wiyu nuyu angparutpan ta Jerusalem. ");
INSERT INTO mph_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malany ta ngulamngulam Jesus la pata awarrangung rtil wiyu nuyu awarrangung parak la mampuwarlkijpangung parak mata warlk mata manilakajpung ta nungmatpa ngurrij. Malany ta awukeny mampayawng nakapa mamajungan mawelpikpiny kirrk. ");
INSERT INTO mph_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kayirrk la Peter aniwurrung parakapa tuka Jesus inginkan la iminy, “Nuyi ta Ngarrunukiki nakapa mata warlk mamajungan mawelpikpiny kirrk tuka nuyi annginkan la anminy ngaw mata warlk, ‘Marrik muj nganti inilang ja ingijalk mata nuyi nuwu mata warlk.’” ");
INSERT INTO mph_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kayirrk la Jesus iminy nuyu, “Nuyi muj anmi akutju nungpakapa kapin ta anmartukpu mira nuyu God. ");
INSERT INTO mph_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Malany ngapi ngamin nuwu ta aralpa kapin ta kulakajpu ja God la anmartukpu mira nuyu nakapa iyamang nuwu. Kapin ta anmartukpu mira nuyu martapapa nakapa anmi ngaw ta murrgu, ‘God kunpanimajpungku kunpannyaka tuka kurrula’ malany yanat God yalyung nuwu la imi nungpakapa. ");
INSERT INTO mph_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kurralyunyi ngartu! Kapin ta kutpartukpun mira nuyu God nakapa kurriwalakajpun kunuka ja kurrimiyarma mira. La muj kapin ta kutpartukpu nuyu akut la akut - kapin nuyi kanmartukpun nuyu tuka wularrut kunnyung - malany yanat God iwanalyu nuwu tuka anpalangali iwarruj nuyu la kunpannyun ta nungmalal. ");
INSERT INTO mph_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Malany tuka nuyi wiyu anpalangali iwarruj nakapa kungpawurrun werrk ta tukapa: la kapin nganti yirrik ja iminy nuwu ta nungmurrunti naka marrik muj kungatping parak la anpanarra purlalngalk nuyu ja arrarrkpi - la muj kungatpi tuka kiki iminy nuwu la nuyi anpanarra purlalngalk nuyu ja arrarrkpi. Kapin ta anmi nungpakapa nakapa God angpannyaka yirrk nuwu ta aliwiyut tuka anminang. Yanat angpannyaka yirrk nuwu tuka kunpurtjung la muj tuka nungmurrunti ami nuwu la nuyimung. Malany nuyi werrk kungpaka yirrk nuwu ta aliwi la muj anpanarra pularlngalk wu pata wera pata arrarrkpi pata aminang nuwu ta nungmurrunti. Kayirrk la anpalangali iwarruj nuyu ja God.” ");
INSERT INTO mph_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Malany warrwak la Jesus la pata awarrangung rtil wiyu nuyu awuran Jerusalem la awurlgeny parak tuka God nuyu ta karrpin mira ta akurlyak kurrampalk. Malany ta yanat yarran parak la yara pata Jew arrarrkpi awukenang pu iwuyarrung parak ja Jesus. Malany wenat apa pata awukenang ta awulangaling mulil la muj pata awunpukikang ta wulatpiyi la muj pata wimunpimun wakapa awulangaling kirrk. ");
INSERT INTO mph_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kayirrk la iwulakajpung Jesus, “Nganti iminy nuwu tuka anmakangung mata palapala la mata jaya la anpunmalkpany yirrk puka pata arrarrkpi kani kawulangali tuka God nuyu ta kurrampalk? Nganti ja kiwken iminy nuwu ta anminy pu?” ");
INSERT INTO mph_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kayirrk la Jesus iminy pu, “Nuwurri werrk ngarrunpalakpa. Kapin ta ngarrunpalakpa nakapa nganamin nuwurru ja kiwken ja iminy ngartu ngawunpamalkpa tuka ta God nuyu ta karrpin mira ta akurlyak kurrampalk. ");
INSERT INTO mph_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tukapa nganamin nuwurru: nuwurri kurriwurrun ja John ja aningurtpurlukpuning pu? Malany nganti iminy nuyu ta aningurtpurlukpuning pu pata arrarrkpi pa angpakangung kirrk tuka aliwi aminang? Kurlingka pata arrarrkpi angpungulinyju ta wu wiyu, la kurlingka God iminy nuyu ja John ta aningurtpurlukpuning pu?” ");
INSERT INTO mph_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Malany pata Jew awukenang pu awuntumany la wemin la awunpulakajpuning la wemin la aminy pu la wemin, “Malany kapin ta arrkpi nuyu, ‘ja John nakapa imartukpung nuyu God’ nakapa arrungma kit lirri. La imi ngarrurru, ‘La kunuka nuyu nuwurri marrik kurralyunyi nuyu?’ ");
INSERT INTO mph_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Malany marrik muj arrkpi wu, ‘Puka pata arrarrkpi wenat wiyu angpunguliny tuka aningurtpulukpuning pu’”. Malany wenat pata wimunpimun wularrut angkuwurruning ta puka pata arrarrkpi ta angkuwurruning ja John ja ingurlyak ja arrarrkpi tuka ininnyang monmon pu ta God nuyu ta wurluj. Malany wenatapa pata wimunpimun angkuwurruning la aminy, “Ngampi awkpi arruntuwu kapin ta arrkpi nuka marrik inguryak.” Malany wenatapa awuntumurtpangung pata arrarrkpi. ");
INSERT INTO mph_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kayirrk la pata Jew awukenang pu aminy, “Ngarri ngarrungmuy ta nganti iminy nuyu ja John ta aningurtpulukpuning pu.” Kayirrk la Jesus iminy pu, “Kapin ta marrik ngarruntakpang ngapi marrik muj ngami nuwurru. La marrik muj ngami nuwurru nganti ja kiwken ta iminy ngartu ta ngamin tukapa awk!” ");
INSERT INTO mph_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Malany warrwakapa la Jesus annyunmangung pu la iminy pu, “Ja arrarrkpi animiyarmany apaniyurka walij tuka wungurlyak kunak. Malany yanat manilanganiny mingkaga tuka walij atiyurjiny la muj atjakan yurrng ta palapala tuka arrarrkpi awanarnti mampayatayan mata warlk. Malany yanatapa aninguliny manjat kirrk. Kayirrk la yanatapa ja arrarrkpi nakapa awunimany pata wera muj pata arrarrkpi pata wemin apayatayantung ta walij. Malany nukapa ja arrarrkpi la wenat angpungulinnguliny kirrk pa apululkanyang nuyu ta walij tuka awuyamangung tuka yanat nuyu ta kunak. Warrwak la yanatapa ja nuyu kunak yuran tuka nungmatpa kunak. ");
INSERT INTO mph_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Malany warrwakapa ta apururrk walij apalkpany la ja arrarrkpi ja nuyu kunak inilangakan ja iyamangung nuyu pa apanima ta walij tuka yanat nuyu atiyurjiny. ");
INSERT INTO mph_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Malany pata arrarrkpi pata awulangaling wakapa tuka mingkaga iwumany nuka ja arrarrkpi la iwuwuning la iwakan yalayala marrik kunuka muj atimurnanganya warak nuyu ja nuyu kunak. ");
INSERT INTO mph_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Malany ja nuyu kunak inilangakan parak jara ja arrarrkpi tuka atjurjinang walij. Malany wenatapa pata arrarrkpi nakapa iwuwung wilkpujpilkpuj akutju la iwungalkpung tuka wanji. ");
INSERT INTO mph_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kayirrk la ja nuyu kunak inilangakan jara ja arrarrkpi tuka atjurjinang ta walij la wenatapa pata arrarrkpi iwuwung iwularr. Malany nungpakapa angminang akut ta awunilangakangung pata awuyamangung nuyu pa apumanyi nuyu ta walij la makiny, arrarrkpi pata wakapa awulangaling tuka mingkaga nakapa awuntuwuning yara pata awuntuwuning wiwularr la yara pata awuntuwuning kayirrk la awunpulangakangung. ");
INSERT INTO mph_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Malany ja nuyu kunak wakapa tuka atjurjinang ta walij awk innyatpang yarakapju ja arrarrkpi ta iwanilangaka pa apanima nuyu ta walij. Malany ja nuyu kunak iminy ta nuyu wiyu, ‘Kija nganunmen arakap akutju ngiwalangaka ja ngapi wiyu ngimalkpany. Malany ngapi ngimiyarma mira malany wenatapa pata arrarrkpi pata kawulangali tuka katjurjin ta walij awk nakapa awamartukpun nuyu.’ ");
INSERT INTO mph_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Malany pata arrarrkpi wakapa awulangaling tuka atjurjinang walij awk iwayawng ja nuyu kunak inimalkpany la aminy pu la wemin, ‘Kapin ta iwamaju ja nuwarlkparrakan nuka ja marryun angpanima nuyu kunak. La arriwanawun nuka ja marryun kayirrk la arrungpanama kani tuka katjurjin walij awk la atpanuken ngarrurri wiyu.’ ");
INSERT INTO mph_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kayirrk la iwumany nakapa ja marryun la iwuwung imajungan la iwakan yalayala. ");
INSERT INTO mph_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Malany kiki iwanamin ja nuyu kunak? Wakapa iwana tuka katjurjin ta walij awk la awunpaniwun kirrk pata arrarrkpi. Kayirrk la awunpannyun parak wera pata arrarrkpi pa angkayatayan nuyu. ");
INSERT INTO mph_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Malany nuwurri kurrungpawurrun tuka iwumirrawung tuka God nuyu ja jurra: ‘Malany pata arrarrkpi angkumany waryat la apunguliny kurrampalk. Malany pata awuyamangung aminang mali arakap ta waryat aliwi pa angpakan. La makiny! La tukapa ta waryat ta wungurlyak mira murnin wenat marrik angkuwurruni mira. ");
INSERT INTO mph_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Malany God aninguliny tukapa ta waryat wungurlyak mira. La pata God nuyu arrarrkpi kamin marrmarr ta nungpakapa ta iminy ta wunguryak mira.’” ");
INSERT INTO mph_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Malany pata awukenang pu pata Jew arrarrkpi awalyungan ta annyunmangung pu la wularrut angkuwurrung parak ta wenat animangung pu - malany wenatapa kapin pata tumurrunti pata awuyamangung tuka atjurjinang walij awk. Malany wenatapa marrikpan mali la angkumiyarmangung iwumanyi warak tuka iwuwutakanyi. Malany wenat amurtpiny awuntumurtpan pata arrarrkpi kayirrk la iwarutpan ja Jesus la awuran. ");
INSERT INTO mph_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Malany ta warrwak yara pata Jew arrarrkpi pata awukenang pu awuntumirtujpan yara pata arrarrkpi. Malany yara awuntumany pata awunpukikang pata awukenang pu ta awulangaling ta wulatpiyi wu pata awuntuwarnangajpuning Pharisees la yara pata jawirna nuyu ja yukenang pu Herod. Malany pata awukenang awunpulangakan arrarrkpi pa iwulagarruni ja Jesus. Malany wenatapa awunmeny nuyu tuka inginkanyi ajirrik ta aliwi, pa angpungulanyi nuyu lirri. ");
INSERT INTO mph_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Malany wenatapa aminy nuyu ja Jesus, “Nuyi ta Ngarrunukiki, ngarri ngarrungpurrun tuka nuyi kungmiyarma kanmin ta manjat la kannginka aralpa ta ngaralk. Kapin ta nuyi kannginka wu amparrkamparrk nakapa kanmin parak pu ta manjat kirrk wu pata kawuken la muj pata wera. Malany nuyi kanpunukiki akut ta God nuyu ta ngaralk tuka manjat warakju. Kiki ja ngarruntakpanyi: ‘Kurlingka manjat la nungmurrunti ta ngarri ta Jew ta ngarratulkanyi wu ja karriwarnangajpun tax pata Roman kawuken tuka ngarrurri ngarrurru ta kunak?’” ");
INSERT INTO mph_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Malany Jesus wularrut aniwurruning kapin tuka imi, “Makiny nungpaka nungmurrunti ta kurratulkanyi nakapa ja rrupiya” nakapa animanyi kit lirri iwarnamanyi pata Roman kawuken la kapin ta imina “Ee kurratulkanya ja tax rrupiya” nakapa animanyi kit ta lirri iwarnamanyi pata Jew arrarrkpi - murnin wenat angkumiyarmangung marrik awukena wu pata Roman kawuken. Kayirrk la Jesus iminy pu, “Yunyi ngarruntagarrukun. Kurlingka nuwurri kurryatpi ja rrupiya? Ngungmiyarma ngiwayan.” ");
INSERT INTO mph_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Malany pata arrarrkpi iwung Jesus ja waryat la yukeny innyayawng la iminy, “Nuka nganti kilangali tuka waryat? Nganti ja nuka la nganti ingurlaj?” Malany wenatapa pata arrarrkpi aminy, “Nuka Caesar - ja kiwken wu pata Roman pata wimunpimun.” ");
INSERT INTO mph_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Malany Jesus iminy pu, “Ma, nuwurri ja kutpunpanawn pata Roman kawuken ja nuka awk ja wenat pu, la nuwurri kurriwanawn God ja yanat nuyu akutju.” Malany wenatapa awurlkpalangkeny kirrk ta awalyungan nuyu. ");
INSERT INTO mph_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wakapa awaning yara pata Jew arrarrkpi malany wenat angkuwurruning kapin ta ngantiyirrik ja kaniwularrun naka marrik muj imajpungkiga. Malany wenatapa awuntuwarnangajpuning ‘Sadducees’. La muj awunmeny ta iwulagarruni Jesus. ");
INSERT INTO mph_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Malany wenat aminy nuyu, “Nuyi ta Ngarrunukiki, ja Moses ta animirrawung tuka God nuyu ta wulatpiyi tuka kangmin parak: Kapin ja arrarrkpi kawani jita warramumpik tuka kaniwularrun la marrik awunpatping warrayngiw nakapa ja awulingan kinyima kawani jakapa jita warramumpik. Malany nakapa ja arrarrkpi la warramumpik iwanatpi warrayngiw ja yanat nuyu ja awulingan ja imajungan. ");
INSERT INTO mph_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kapin tuka kangmin parak. Malany awaning wurrkamaj yurnu la ngarrkarrk pata awulinganut. Malany ja wulku inyimany warramumpik awaning warrwak la imajungan la marrik muj ingatpa ja warrayngiw. ");
INSERT INTO mph_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kayirrk la ja numatpa wulku inyimany awaning jakapa jita warramumpik malany nungpakapa aminang angpuyarruning ta God nuyu ta wulatpiyi. Kayirrk la imajungan ja numatpa wulku la marrik muj ingatpa ja warrayngiw. Kayirrk la ja jara ja awulingan inyimany akutju la imajungan akutju la marrik muj ingatpa ja warrayngiw. ");
INSERT INTO mph_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nungpakapa angminy parak pu pata awulinganut. Malany wenatapa angpuyarrung ta God nuyu ta wulatpiyi tuka inyjumangung jakapa warramumpik awaning. Malany wenatapa pata arrarrkpi amajungan kirrk la marrik muj awunpatpa warrayngiw. Malany ta warrwakapa la jita warramumpik inymajungan akutju. ");
INSERT INTO mph_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Arta! Nuwurri kutpin mali pata amajungan pata arrarrkpi awk awamajpungkinka awawani rtirr wernangkat akutju, tukapa ta kurruntakajpun: malany wenatapa pata awulinganut la jakapa jita warramumpik ta awamurnanganiga awawani rtirr akutju, malany wenatapa pata awulinganut nganti ja inypanima awawani? Malany wurrkamaj yurnu la ngarrkarrk pata awulinganut awaning jakapa jita warramumpik warrwakapa la angawularrung.” ");
INSERT INTO mph_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Malany Jesus iminy pu, “Nuwurri kurlingka kurrungatpi wularri? Nuwurri marrik kurrungpurru ta God nuyu ta ngaralk martapapa mira la muj marrik kurrungpurru ta God nuyu ta wutkut ta kannyatpi. ");
INSERT INTO mph_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Malany pata amajungan pata arrarrkpi awamajpungkinka wernakat akutju malany awanamin kapin pata God kangkumaga nuyu wurluj ta kapa yurrng. Malany wenatapa pata kangkumaga God nuyu ta wurluj ta kapa yurrng marrik awuntumang la wemin. La pata arrarrkpi kawani kapa yurrng marrik ami ta nungpakapa akutju. La marrik awuntuwarlku la awunpu la wemin. ");
INSERT INTO mph_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","Malany nuwurri kutpin mali pata arrarrkpi ta kamaju marrik muj amajpungkiga. Nuwurri kurrungpurruni tuka angkumirrawung tuka God nuyu ja jurra tuka kiki angminy parak ja Moses - tuka yukeny mannyayawng warlk mata malijap malangung yungku la God iminy nuyu Moses, ‘Ngapi ta God nuyu Abraham la God nuyu Isaac la God nuyu Jacob.’ Yanat God marrik imina wu yanat ja God wu pukapa pata ngarrkarrk la werakap pata arrarrkpi ta wularrut. La yanat iminy ngapipa ta kayirrk ta God wu puka pata ngarrkarrk la yarakap pata arrarrkpi. Malany ta wulatpiyi kangmin parak wenatapa pata ngarrkarrk la yarakap arrarrkpi kawani rtirr wernakat akutju marrik amajunyi akutju. Malany kayirrk kawani rtil God. Ta tuka kutpin nuwurri naka marrik aralpa.” ");
INSERT INTO mph_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Malany yarakap arrarrkpi ta Jew wulatpiyi awunnyukikang yalyungan nuyu ja Jesus la aniwurrung tuka Jesus awunilakpany ta manjat. Kayirrk la inilakajpung Jesus, “Ngampiwi ta God nuyu ta wulatpiyi ta wungurlyak mira?” ");
INSERT INTO mph_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kayirrk la Jesus inilakpany, “Ta wungurlyak mira ta God nuyu ta wulatpiyi tukapa: ‘Kurralyunyi ngartu nuwurri ta Israel arrarrkpi, God ja kiwken mira nuwurru amparrkamparr. Yanatju yarakap kutpanalyu nuyu ");
INSERT INTO mph_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yanatju God kurriwamiyarma martapapa mira. Nuwurri kurriwamiyarma mira God tuka nuwurrijalk pularr. Nuwurri kurriwamiyarma God tuka kurralyu kiki kutpin la kurrungpurrun. La muj kurriwamiyarma God tuka kiki kutpin awk.’ ");
INSERT INTO mph_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kayirrk la warrwak ta wungurlyak mira ta God nuyu ta wulatpiyi tuka kangmin parak: ‘Nuwurri kutpunpamiyarma werrk wera pata arrarrkpi la muj kutpunpayatayan kapin kutpiyarma ta nuwurru wiyu la kurrayatayan ta nuwurru wiyu.’ Malany tuka ta ngarrkarrk ta wulatpiyi nuntatparlangkat la wungurlyak mira.” ");
INSERT INTO mph_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Malany ja Jew ja kawunnyukiki ta wulatpiyi wu iminy, “Nungpakapa ta anminy ta nungmalal mira, nuyi ta Ngarrunukiki! God yarakapju ja kiwken ngarrurru amparrkamparrk. Nuyipa kanmin ta manjat, ‘Marrik nganti muj ja jara ja god la Yanatju parang!’ ");
INSERT INTO mph_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","La ngarrurri arriwamiyarma God aralpa mira, marrik ta lagarrukuj. La muj ngarrurri arriwamiyarma God tuka arrkijalk pularr ngarrurru. Malany ngarrurri arriwamiyarma mira God tuka karralyu kiki katpin la muj tuka karrungpurrun. La muj arriwamiyarma mira tuka katjama. Tukapa ta arrungpamiyarma mira ngarrurri ngarrurru ta arrungpayarrun God nuyu ta wulatpiyi la marrik arrungmiyarmang ta arrunjarru ta mulil kapin tuka arriwunyay ngarrurri irratat arriyu.” ");
INSERT INTO mph_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Malany ta Jesus yalyungan nuyu ja arrarrkpi ta inginkangung la aniwurruning ta manjat kirrk. Kayirrk la Jesus iminy, “Malany nuyipa kungpurrun ta manjat parak. Malany nuyipa wanyji ta God iwanuken nuwu.” Ta warrwak marrik muj iwulakajpukpuni ja Jesus la muj iwulagarruni. ");
INSERT INTO mph_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Warrwak la Jesus awunnyukikang arrarrkpi wukej tuka God nuyu ta karrpin mira ta akurlyak kurrampalk. Malany iminy, “Nuwurri kurriwurrun ja David ja iwaning wularrut mira, la kayirrk pata karrunpukiki ta wulatpiyi kamin ngarrurru ja ingurlyak ja arrarrkpi nakapa kimin wawupawu ja David. Malany kiki kangmin parak ta nungpakapa? ");
INSERT INTO mph_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Malany kurrungpawurrun ta tukapa: La ja God nuyu ja Nyunyuk Iyarmu iminy nuyu David, “Kungpamirrawun tuka ta ngaralk: Malany God iminy nuyu ja ngapi kiwken ngartu ‘Ngawu kani atpawani rtil, malany ta warrwakapa la anpanuken pu pata lirri nuwurru.’” ");
INSERT INTO mph_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nungpakapa ja David ininnyang monmon nakapa ja ingurlyak ja arrarrkpi ja God inilangakanka, la David iniwarnangajpuning ja Kiwken. Kiki kangmin parak nukapa ja arrarrkpi ja David kimin wawupawu?” Malany wigarra yirrk pata arrarrkpi ta awalyungan nuyu ja Jesus la aminy marrmarr kirrk nuyu. ");
INSERT INTO mph_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Malany ja Jesus angkat awunnyukikang pata arrarrkpi. La iminy, “Kutpunpayan mira pata kawunpukiki ta wulatpiyi awk. Wenat kamin mali wingurlyakut. La kawuyarni ja manpurrwa ja yarntulyakut pa kamamin pu mali arrarrkpi awuntayan. La muj wenat kangkumiyarma arrarrkpi ta kawunpilima warak tuka kawa kawulakpolorrki. ");
INSERT INTO mph_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Malany wenatapa pata kawunpukiki wulatpiyi awk kangkumiyarma tuka awamartukpun pu la muj kangkumiyarma awanarnti tuka mangurlyak mata warlk tuka karrungatpi iwarruj. La muj kapin ta kawa tuka kangpatpi mulil nakapa kangkumiyarma awanarnti tuka mangulyak mata warlk akutju. ");
INSERT INTO mph_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Malany wenatapa kawunpulagarrukun pata tuwarlkparrakanut pata warramumpik pata marrik nganti awunnyayatayanyjing. La muj kawuli wumpulaj pu kurrampalk la kunuka yirrik ja kiwatpi awk. La wenatapa pata kawunpukiki ta wulatpiyi awk kawa tuka kurrampalk tuka kangpatpi akut iwarruj la kawulangali iwarruj arntulyak pa awuntangula ajirrik wigarra yirrk awanamin puka pata tumalalut mira. La naka kiwumalagarr ta kiwuyarrun God! La malany God iwayintukun pu pata arrarrkpi ta nungmurrunti ta kamin. La pukapa pata arrarrkpi kawunpukiki ta wulatpiyi nakapa iwayintukun mira wu.” ");
INSERT INTO mph_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Malany ta warrwak Jesus yuran ap wanyji tuka rrupiya iwutpangung tuka God nuyu ta kurrampalk. Malany iwaning awunnyayantung pata arrarrkpi ta iwutpangung ja rrupiya nuyu ja God. Malany yara pata imurra rrupiya iwatpang pata arrarrkpi iwutpangung imurra. ");
INSERT INTO mph_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kayirrk la jita namarlaja jita warramumpik inyurlgenyka. Malany ninypurnirri arrarrkpi imajungan ngaw. Malany inyanat ingutpan ngarrkarrk ja ilinyjinyut ja rrupiya tuka iwulatikang rrupiya awk. ");
INSERT INTO mph_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kayirrk la Jesus ilajantiny pu pata awarrangung rtil wiyu nuyu la iminy pu, “Ngapi nganamin nuwurru manjat: juka jita namarlaja jita warramumpik ingutpan kirrk ja ingatpang la pata iwatpang imurra rrupiya nakapa iwulatiny anyakju. ");
INSERT INTO mph_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Malany wenatapa pata iwatpang imurra rrupiya kamin mali iwutpan imurra ja rrupiya, la naka kiwatpi akutju imurra kiw wu tuka kunak. La jita namarlaja jita warramumpik naka ingutpan kirrk ja ingatpang. Marrik muj kunuka ingamurnanganya, marrik muj ingatpa ja walij nuyu inyjakpolorrka.” ");
INSERT INTO mph_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus la pata awarrangung rtil wiyu nuyu angparutpan tuka God nuyu ta karrpin mira ta akurlyak kurrampalk kapa Jerusalem la amalkpany awuran yalayala. La yarakap iminy, “Arta nuyi ta Ngarrunukiki, anngukena kartayanti tuka ta kurrampalk ta napalal mira. La muj kungayanti tuka waryat ta karrkpin awk. Tuka ta napalal mira ta kurrampalk ta apunguliny nuyu God!” ");
INSERT INTO mph_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kayirrk la Jesus iminy, “Kurlingka nuwurri kurrartayan tuka ta napalal ta kurrampalk? Malany tuka ta kurrampalk kani marrik muj atangaling parak. Malany nganti yirrik apaniwun apannyaka warak. La apanaw purrkut kapin waryat.” ");
INSERT INTO mph_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kayirrk la Jesus la pata awarrangung rtil wiyu nuyu angparutpan ta Jerusalem la awuran tuka murrgu tuka Olive warlk ngaw la wakapa awuran ap. Malany tuka awaning nakapa apayantung parak ta God nuyu ta karrpin mira ta akurlyak kurrampalk. Kayirrk la Peter, James, John la Andrew marlakan iwulakajpung Jesus, ");
INSERT INTO mph_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Malany kiki la apanawun ta kurrampalk? La kunuka yirrik arrunpanilangkatpa ta kiki yirrik angpanamin parak?” ");
INSERT INTO mph_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Malany Jesus iminy, “Kurrungayanti! Nuwurripa kutpayan kirrk la marrik nganti kurrunilagarru. ");
INSERT INTO mph_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Murnin wigarra yirrk awanaga la ngantawarnangapukpun ngapi la awanamin ‘Ngapi ta Christ ta nganilangakanka God,’ la muj wigarra yirrkapa awuntalagarrukun. ");
INSERT INTO mph_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kapin ta kutpanalyu angkanunma nuwurru tuka awanginka lirri ta karrpin, kapin ta nganti yirrik annyunmay nuwurru ta karrpin ta lirri angpanaga. Malany wakapa ta kutpanalyu yunyi kutpurtpin. La naka awanginka ta lirri la ta kunak marrik anjarrkpunyjili akutju. ");
INSERT INTO mph_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Malany wugarra yirrk ta lirri awanginka. Malany pata arrarrkpi weminpi la wemin awanginka la muj wera pata arrarrkpi pata tuwuran nungmatpa kunak nakapa awamajpungkinka awanginka pata tuwuran nungmatpa kunak awk. Malany ta nungmatpa kunak awk nakapa angpayirrngun ta kunak wula awunpangatpi. La yara walij apayarrkpunyjilin wu pata arrarrkpi awamaju wirrngak. Malany tukapa nungmurrunti angpanamin parak kayirrk la ta warrwak nakapa karrkpin mira ta lirri angpanaga. Nuwurri kurrungpurrun jita warramumpik ta kinyalkpa ja warrayngiw nakapa kinyiwunpun werrk warrwakapa la kapalkpa ta atjak la ta kanimurlutpurlun. La ta lirri tuka ngungunman nuwurru nakapa angpanamin parak kapin tuka kinyiwunpun jita warramumpik. Warrwakapa la ta lirri angpamalkpaga ta karrpin. ");
INSERT INTO mph_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Malany nuwurri kutpayan kirrk la muj kutpayatayan mira ta nuwurru wiyu. Nuwurri ta karrarra rtil ngapi la arrarrkpi pata nganparnama nakapa nuwurri kurruntarnama akutju. Malany kurruntanama warak tuka kurrungpanunma la kurruntanawun yalayala. Kurruntangula kutpalangali tuka pata kawuken pata wimunpimun. Tukapa ta kurrungpanunma wu amparrkamparrk ta ngapi ngartu, ");
INSERT INTO mph_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","la puka pata arrarrkpi pata kawani wugarra yirrk kunak ngantawurrun ngapi. Malany arrarrkpi pata kawani wugarra yirrk kunak awanalyu ta nungmalal wurluj ta ngapi ngartu warrwakapa la angpayarrkpunyjilin ta kunak. ");
INSERT INTO mph_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Malany aralpa pata arrarrkpi kurruntawuta la kurruntanama warak tuka kurrungpanunma malany yunyi kamarrikpa mali ta kiki kutpanamin nuyu ja kiwken. Malany ja Nyunyuk ja Iyarlmu kurrunpannyun ta manjat ta ngaralk ta kutpanamin pu malany ja Nyunyuk ja Iyarlmu iwanamin nuwurru tuka kutpanamin pu. ");
INSERT INTO mph_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Malany tukapa ta lirri angpanaw ta karrkpinapa tuka awanginka pata witparlanparlarrut awk. La muj yara pata awulinganut awayirtiki wera pata arrarrkpi awuntanama pata awulinganut wiyu la awuntanawun. La yara pata mayakpu nungpakapa akutju awanamin pu pata awuntumalkpangung. La yara pata arrarrkpi awamilkpungen awuntarnanama pata mayakpu la nigi awk la awuntanama warak wu arrarrkpi la awuntanawun. ");
INSERT INTO mph_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Malany wigarra yirrk kurruntanarnama murnin nuwurri ngapi karrarra rtil. La kapin ta kutartparlangkayi la kurrarrang parak nakapa God kurrunpannyatpi jir.” ");
INSERT INTO mph_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Malany Jesus angkat ilangaling ngarlakarlak - la nganti yirrik ja iwannyakajpun angpaniwurrun mira ta ngamin nuwurru - Jesus iminy, “Ja yaliwi ja numurrunti mira iwanaga la angpannyarrikpakpa wugarra yirrk la iwannyarnama God. La muj iwana iwalangali tuka God ta karrpin mira ta akurlyak kurrampalk ta katangali kapa Jerusalem la wakapa tuka kurrampalk marrik nungmalal ta ilangaling. Kapin ta kurrayanyjing imi, nuwurri ta kutpani Judea kutpamila kutpamajpungkin la kutpangurrin kili tuka murrgu. ");
INSERT INTO mph_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","La nuwurri ta kutangali yalayala tuka kurrampalk yunyi kutpurnangani kurrurlgen la kurrimang nuwurru atjigarrkarrk. ");
INSERT INTO mph_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","La nuwurri ta kutangali tuka karrape yunyi kutpurnangani tuka kurrampalk la kurrimang nuwurru atjigarrkarrk la pajupaju. La kutpamila kutpangurrin kili. ");
INSERT INTO mph_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Malany tukapa angpanamin arnakat wu pata warramumpik pata kawurlu la muj warramumpik pata kawunpatpi warrayngiw pata wilinyjinyut ta nungpakapa. ");
INSERT INTO mph_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Malany nuwurri kutpalangali iwarruj la kurriwalakajpun God, ‘Kungpawirtata ta lirri pa marrik yingka ngarru marlu la walmat ngarrunnyatping malany marrik muj ngatjing ngampi yirrik.’ ");
INSERT INTO mph_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Malany tukapa ta lirri angpanaw wu arnangkat pata arrarrkpi. Malany ta wiyinirrk mira God ininguliny ilinyjinyut imun la ta lirri annyung wakapa la ta kayirrk ta kannyu akutju la ta tora angpanaga muj ta karrkpin mira. Malany ta warrwak anyak ta lirri angpanaw. ");
INSERT INTO mph_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kapin God marrik aniwirtatay ta lirri nakapa amparrkamparrk awamaju yirrk. Malany God awunimany yara pata arrarrkpi la marrik animiyarmang amajung. Malany yanat angpaningula wulurtpuj ta lirri pa marrik amajung. ");
INSERT INTO mph_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kapin ta nganti yirrik imi, ‘Ngarri ngarrayawng Christ ja ingurlyak ja God inilangakanka, ‘Kayirrk nuka kilangali,’ yunyi kurrungma wu ngaralk. La kapin ami, ‘Napaka kilangali,’ yunyi kurrungma wu ngaralk. ");
INSERT INTO mph_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kapin angpanamin parak wu wigarra yirrk pata arrarrkpi iwanamalagarr la awanamin, ‘Ngapi ta ngangurlyak ta Christ ja God nganilangakanka,’ la nakapa kurrunpulagarrukun. La yara pata arrarrkpi kiwuma lagarr la awanamin puka pata kawunginka ta God nuyu ta ngaralk, la wenat awayama tuka wungurlyak parak. Malany puka pata arrarrkpi angkawurrun, ‘Malany atpunpalagarrun pata arrarrkpi pata God awunimany.’ La marrik nungpaka angmi. ");
INSERT INTO mph_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","La kutpayan kirrk! Ngapi ngamin nuwurru ta kayirrk malany ta angpamalkpa nakapa wularrut kurrungpawurrun parak.” ");
INSERT INTO mph_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Malany Jesus angkat ilangaling ngarlakalak la iminang pu, “Malany tukapa ta lirri angpalakujpin kirrk warrwak la jita muwarn iwanima numurtput la ja kurrana marrik muj aniyirranyjing. ");
INSERT INTO mph_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","La jita wirlamurrk awk la muj ja jara awk ja kannyapi wutkut tuka yurrng nakapa iwayirrngukun kirrk la manawarlkanyiga. (Tukapa kannyu yirrk tuka God nuyu ja jurra.) ");
INSERT INTO mph_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kayirrk la amparrkamparrk ngarrunpayan ngapi ta God nuyu ta ngangurlyak arrarrkpi nganamurnanganiga tuka kuynu. Malany pata arrarrkpi ngantayan ta ngapi ta ngalatparlangkat mira la ngungatpi wumurra wutkut la muj nganawarlkparran kirrk. ");
INSERT INTO mph_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kayirrk la ngawunpalangaka pata God nuyu kangkuma warak nuyu wurluj wu amparrkamparrk pata wugarra yirrk kunak kawani la muj pata kawani tuka yurrng malany wakapa ngawunpamirtujpa pata God nuyu arrarrkpi - la puka pata arrarrkpi ngawunmany ngapi wiyu ngartu. La wenatapa pata kangkuma warak nuyu wurluj God awuntanamaga pata arrarrkpi nuyu God.” ");
INSERT INTO mph_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Malany Jesus angkat inginkangung, “Malany nuwurri kurrungpawurrun mira. Ta nuwurri kutanayan wurrwurr mata mawiya tuka kurnpi nakapa kinyjapurr kanyaga. Malany mata wurrwurr mata mawiya kamamalkapa nakapa nuwurri wularrut kurrungpurrun. ");
INSERT INTO mph_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Malany nungpakapa ngungunmangung nuwurru tuka angpanamin parak kayirrk la kurrungpawurrun parak tuka wanyji pa angpamalkpaga. Kapin ta kurrungpayan tukapa angpanamin parak nakapa kurrungpawurrunka ta ngapi wanyji kannyaga ngartu ta nganamurnanganiga. ");
INSERT INTO mph_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Malany ngapi nganamin nuwurru ta manjat! Malany tuka ngininy monmon nuwurru nungpakapa angpanamin parak nuwurru nuwurri ta kayirrk kutpani rtirr. ");
INSERT INTO mph_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Malany nungpakapa angpayarrkpunyjilin kirrk tuka yurrng la tuka kunak - ilinyjinyut imun iwayarrkpunjilin kirrk la ta ngapi ngartu ta ngaralk marrik anjarrkpunyjili. La ngapi ngartu ta ngaralk angpanaw akut la akut. La marrik muj anjarrkpunyjili akut.” ");
INSERT INTO mph_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Malany Jesus angkat ilangaling ngarlakalak iminy pu, “Ngapi nganamin nuwurru ta manjat! Marrik nganti muj aniwurru tuka God iwanamin tukapa. La muj marrik nganti aniwurru ta ngurrij la muj jita muwarn. La pata God nuyu kangkuma warak wurluj kapa tuka yurrng marrik angkuwurru la muj ngapi wiyu marrik ngungpurru. La ja ngapi nganimalkpany ja kiwani yurrng yanatju yarakap kaniwurrun. ");
INSERT INTO mph_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Malany nuwurri marrik kurrungpurru ta God iwanamin tukapa. Kayirrk nuwurri kurrungpawurrun angkat ta tukapa tuka ngaminy nuwurru - la yunyi kurrurnparra la kutpawani rtirr. ");
INSERT INTO mph_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","La kayirrk nuwurri kutpanalyu tuka ta ngungpanunma nuwurru. Wakapa ja arrarrkpi atjarutpan ta kurrampalk la yuran. Malany yanat iminy pu pata awuyamangung nuyu, “Kurrungpayatayan ta kunak la kutpayama ngartu.” Yanat iminy nuyu ja annyayatayantung tuka awurlgenangka, “Angkat anpanuken pa nganpayan ta nganamurnanganiga.” ");
INSERT INTO mph_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Malany pata awuyamangung nuyu marrik inyjuwurruni jita muwarn tuka iwamurnanganiga ja nuyu kurrampalk. Ngungpurrun imurnanganingka ta inypanuryi warak la yara ngungpurrun yingka ta wupurrk wungijalk la yara ngungpurrun imurnanganiga ta iyirtpirrakega ta karlurri kinginka. Malany nuwurri kapin pukapa pata awuyamangung nuyu - nuwurri marrik kurrinypurru jita muwarn ta nganamurnanganiga kanipa la nuwurri kutpangulinngulin angkat ngartu. La nuwurri kutpawani rtirr angkat ngartu ngapi kapin nukapa ja kilangali ja kiwken tuka karrurlgenka. La yunyi kutartpalililmin la kurrunngawunpun ngurrij. ");
INSERT INTO mph_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Malany ngapi kurruntangkatpa la muj ngawunpalangkatpa akutju wigarra yirrk la marrik kurrurnparray la kutpawani rtirr!” ");
INSERT INTO mph_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Pata awukenang pu tuka awulangaling mulil wu pata Jew arrarrkpi la muj pata awunpukikang wulatpiyi awk angkumiyarmangung iwuwuni Jesus pa awuntumany la wemin pa iwumulutpulung ngampi warak iwanama ja Jesus. Pata Jew arrarrkpi angpatpang ta mulil wu ta Passover jungkarra la jungkarra la apulangung kantijawa ta marrik iwutpanyi ja katimurranyma ta kantijawa. Ngarrkarrk ta ngurrij annyungka pa angkanatpi ta mulil wu malany aminy pu la wemin pata awukenang pu la pata awunpukikang ta wulatpiyi awk aminy, “Wigarra yirrk kiwumiyarma ja Jesus. Malany marrik arrimang akutju murnin kani arrkpalangali yirrk mulil la marnti awulirrinymi anturrangkenyjing ta lirri.” ");
INSERT INTO mph_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","La Jesus ilangaling kapa ta kunak wungurlaj Bethany la apulangung rtil walij tuka Simon nuyu ta kunak. (Malany ta wularrut awaning ja Simon innyatpang namurarri malany ta warrwakapa la ingulikingan.) Kayirrk la jita warramumpik inyurlgeny parak tuka kurrampalk inyarrangung yitkit pujurlung ta yirri antatinang la angputjirrantung nungmalal mira. Malany igarra ja waryat ja awulokpolorrkang. ");
INSERT INTO mph_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Malany ta mangatpalawng ta yirri la angawulawng tuka Jesus wanji nuyu. La yara pata arrarrkpi wakapa awaning inypuluntuny. La aminy ngaw, “Kunuka nuyu kungpulawng ta yirri? ");
INSERT INTO mph_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","La tukapa ankakpolorrka igarra ja waryat pa anpununi pata namarlanmarlaja la kunuka nuyu marrik ankakpolorrka?” ");
INSERT INTO mph_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kayirrk la Jesus iminy pu, “Kurrinyarutpanyi! Yunyi kurrungayanayan ngaw! Ta nganngalartpantiny tukapa nungmalal. ");
INSERT INTO mph_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","La pata namarlanmarlaja nakapa kutpanarra rtil akut malany ta kurrungpamiyarma nuwurri nakapa kutpunpanawn ja waryat. La ngapipa wanyji kurrunpanarutpa! ");
INSERT INTO mph_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Malany ta wanyji ta nganamaju la ngantayurka. La juka jita warramumpik ta nganngalartpantiny ta yirri nakapa murnin ta nganamaju nakapa ngantarlatpan werrk yirri. Nungmalal yirrk ta inyminy ngartu. ");
INSERT INTO mph_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","La kurralyunyi ngartu. Ta ngapi ngungunma nuwurru ta aralpa! Ta wugarra yirrk kunak pata arrarrkpi angkanunma tuka God nuyu ta wurluj nakapa inyjeni monmon jukapa jita warramumpik tuka kiki inyminy kayirrk. Tukapa ta nungmalal mira la wigarra yirrk inyjawurrunapa.” ");
INSERT INTO mph_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariot ilij nuyu pata 12 arrarrkpi ta awunimany ja Jesus. Malany yanatapa iwilkpung la awuniyarrung pata Jew awukenang pu ta awulangaling mulil wu. La iminy pu, “Ngapi arrkpayirtiki nuwurri arriwawutaka Jesus.” ");
INSERT INTO mph_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Malany ta awalyungan nuyu iminy nungpakapa aminy marrmarr mira. La aminy nuyu, “Malany ngarrapalulkanyi nuwu rrupiya.” Pa Judas angkat aniwurruning ta nungpakapa la animirlajuning ta ngurrij ta awayirtiki iwanama ja Jesus. ");
INSERT INTO mph_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kayirrkapa ta ngurrij angmalkpanyka wu pata arrarrkpi ta iwanawun ja wurrwurr ja larlngalk nuyu la iwawunya la iwanala. Malany nungpakapa aminang ta iwumangung rtalk awulangaling mulil ta Passover (Ta Passover mulil tuka angkuwurruning parak pata Israel arrarrkpi ta awaning kapa Egypt la ja God nuyu kanima wurluj awuniwarlkijpan parak marrik muj awuniwuni wiwularr). Malany wenat apulangung kantijawa ta marrik iwutpanyi ja katimurranyma ta nungpakapa. La nungpakapa ta ngurrij yara pata awarrangung rtil wiyu nuyu Jesus iwuyarrung parak la iwulakajpung aminy nuyu, “Ngampiwi kungmiyarma arrapanala ta walij. Pa ngatpana ngarrungpangulanngula angkat ta kunak.” ");
INSERT INTO mph_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","La Jesus iminy, “Nungmalalapa nuwurri ta ngarrkarrk kutpana kapa Jerusalem, malany ta kutpamalkpa wakapa nuwurri kurriwayan ja arrarrkpi iwanarra yitkit panikin ja karrkpin malany kantatin wupaj mampal. Kurriwayarrun parak malany iwanarra warak iwanurlgen tuka kurrampalk. ");
INSERT INTO mph_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kayirrk la kurriwalakajpun ja nuyu kurrampalk kutpanamin nuyu, ‘Ja ngarri Ngarrunnyukiki kanimiyarma nuyi ngarrunpanuki ngampi warak tuka ngarrapanala tuka nuyi nuwu ta kurrampalk. La muj kanimiyarma ngarrapanala wakapa ta Passover mulil ta walij yanat la ngarri ta ngarrarra rtil wiyu nuyu.’ ");
INSERT INTO mph_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kayirrk la nakapa ja nuyu kurrampalk kurrunpanima warak yurrng ta kannyu wukaj tuka nungpanpal ta kunak tuka wularrut yanat aningulinnguliny angkat. Wakapa nuwurri kurrapanutpa angkat ngarrurru ta walij.” ");
INSERT INTO mph_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Malany pukapa pata ngarrkarrk arrarrkpi awuranapa kapa Jerusalem. La malany nungpakapa angminy parak tuka algaj Jesus iminy pu. Pa apumany ta walij la aputpan angkat tuka angkanatpi ta wungurlyak Passover mulil nuyu. ");
INSERT INTO mph_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Malany ta inyuryiliny parak jita muwarn Jesus la pata wingurlyakut pata awarrangung rtil wiyu nuyu awarran parak wakapa tuka kurrampalk pa apanala ta Passover mulil nuyu ta walij. ");
INSERT INTO mph_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Malany tuka apulangung akutju, la Jesus iminy pu, “Yarakap ja arrarrkpi karrata rtil walij ngapi kayirrk karrpani rtil, malany yanat awayirtiki arrarrkpi pata kangkumiyarma ngantanawun ngapi.” ");
INSERT INTO mph_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Malany pata 12 pata awarrangung rtil wiyu nuyu marrikpan mali awunpulakajpung la wemin, “Ngapi ta mungu! Kurlingka ngapi kungmany ngartu ngapi?” ");
INSERT INTO mph_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus iminy pu, “Yarakapju ja ngarrapaka yaw rtil ngapilyanat tuka panikin kayirrkapa. ");
INSERT INTO mph_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ngapi ta ngangurlyak arrarrkpi ta God nganilangakanka la malany nganamaju murnin wularrut kanyu tuka God nuyu ja jurra. La nukapa ja arrarrkpi awayirtiki pata nganparnama la ngantanama ngapi nakapa angpanima kit lirri ta karrkpin mira tuka God! Malany nungmalal ta marrik ilurrangkena.” ");
INSERT INTO mph_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Malany ta warrwak, tuka apulangung akutju ta walij, Jesus atimany ta kantijawa la ilingan iwarruj nuyu God, kayirrk la atjukpung la atiwung awalinyjinyut la awunnyung pata awarrangung rtil wiyu nuyu la iminy, “Tuka ta kantijawa ta ngapi ngangijalk, kurrapanyi la kurratanyi.” ");
INSERT INTO mph_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kayirrk la inimajpungkuny ja panikin antatinang ta maningul la ilingan iwarruj nuyu God, kayirrk la awunnyung angkuwany wulijap weminpi la wemin ta maningul. ");
INSERT INTO mph_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kayirrk la iminy pu, “Tuka ta maningul ta ngapi ngartu mata mangurlyak maningul. Ta nganamaju la mana jurr ngartu maningul wu wigarra yirrk pata arrarrkpi. Kayirrk la ngarruntanama la ngarrurrimung ta lirri la arruntamiyarma la ngarrurrimung tuka lirri la yanat apanilulkanyi nuwurru God. ");
INSERT INTO mph_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngapi ngamin nuwurru ta manjat, marrik muj nguntang ta maningul akutju, malany ta ngurrij ta angpamalkpaga tuka ngatpawani rtil God la ngarrungpanala la iwanuki nuwurru yanatju ja yarakap Kiwken ngarrurru.” ");
INSERT INTO mph_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Malany tuka Jesus iminy kirrk wu warrwakapa la amirawning nuyu God, kayirrk la awuran tuka murrgu wungurlaj Olive mata Warlk. ");
INSERT INTO mph_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Malany ta awarrangung parak tuka alan, Jesus iminy pu, “Nuwurri kutpangurrin kili la ngarrunpanarutpa. La ta wiyiniyirrk mira God iminy nuyu ja yanat nuyu ja arrarrkpi, ‘Kungpamirrawun tuka ngapi ngartu ja jurra ta ngapi nganamin nuwu.’ La animirrawung: ‘God iwaniwun arrarrkpi ja kawunnyayatayan pata larlngalk pu, la yanat nuyu pata larlngalk pu awangurrin kili.’ ");
INSERT INTO mph_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Malany ngapi nganamaju, nakapa ja arrarrkpi wularrut animirrawung, kayirrk la ta warrwak God nganpanimajpungku nganawani rtirr akutju. Kayirrk la nganuraka warak kapa Galilee ngaw ta kunak la kurrunpamirlajun wakapa. Malany ngarrunpayan wakapa.” ");
INSERT INTO mph_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Malany Peter iminy, “Ngungpurrun wera awangurrin kili la ngapi makiny!” ");
INSERT INTO mph_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","La Jesus iminy nuyu, “Anngalyunyi ngartu, Peter. Kayirrk ta wupurrk nuyi anpanginka kuwanama lagarr wu pata arrarrkpi la anpanamin pu ta nuyi marrik nganpurru ta ngapi. Kayirrk la kalakalak iwalaja ta wupurrk, kapin ta kangmin akut warrwakapa la muwarn inypamalkpaga. Malany pata arrarrkpi awanalyu nuwu ta anpanamin ngarrkarrk la arakap nukpawurr ta nuyi marrik nganpurru kayirrk la iwalaja ja kalakalak ngarrkarrk imawurr.” ");
INSERT INTO mph_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Malany ja Peter annyarnangkatikiny tuka iminy nuyu ja Jesus. La iminy, “Makiny! Pata arrarrkpi marrik nganpungulay nganginkay la ngami ta nungpakapa. La muj kapin ta ami ngartu ‘kurrunpanawun,’ naka marrik muj ngami ta ngapi marrik kunpurru.” La muj wera pata awarrangung rtil wiyu nuyu aminy nungpakapa akutju. ");
INSERT INTO mph_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Malany Jesus la pata awarrangung rtil wiyu nuyu awuranka tuka kunak wungurlaj Gethsemane. La iminy pu, “Kurrunmiyarma kani kutpawani ngarrunpamirlajun. La ngana nganalangali iwarruj nuyu God.” ");
INSERT INTO mph_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kayirrk la awunilakajpung pata Peter, James la John tuka awana rtil yanat, wakapa awuran la awunparutpan pata wera awaning. Malany tuka awarrangung parak, ");
INSERT INTO mph_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","yanat iminy orka wu, “Ngapi ngalyu ngawurlkpungku mira ta kayirrk. La ngawurlkpungku mira la ngalyu kapin ngatalken! Kani kutpawani la kutpanuken lirri angmalkpang.” ");
INSERT INTO mph_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kayirrk la Jesus yarran parak yurtpiny apakawi la wenat warrwak awaningka kayirrk la innyeny kartawarrkartawarr tuka kunak. ");
INSERT INTO mph_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","La iminy nuyu God, “Punyi tukapa nuyi kungmiyarma ta anpanamin la anminapa. La kungakanyi ngartu ta nuntatparlangkat ta lirri kannyaga ngartu. Malany tuka nuyi kungmiyarma anpanamin ta tukapa, marrik ngapi ngungmiyarmang.” ");
INSERT INTO mph_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Malany ja Jesus ta imurnanganiny parak tuka ngarrkarrk la werakap pata awarrangung rtil nuyu la awunnyayawng awurnparrang. La iminy nuyu ja Peter, “Anmajpungkina Simon. Kurlingka marrik arrkpaning arruke rtil arntulyak. ");
INSERT INTO mph_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngapi kurrunmiyarma nuwurri kutpawani kutpanuken tuka lirri annyingka. La ngapi kurrunmiyarma nuwurri kutpalangali iwarruj nuyu God pa marrik kurrurnparray. La ngapi ngungpurrun tuka nuwurri kurrungmiyarma kutpanamin nungmalal, la ta nuwurrkijalk muj kutartpalililmin la kurrungmiyarma kutpanurnparra.” ");
INSERT INTO mph_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kayirrk la Jesus awunnyarutpan akutju, la yuran ilingan iwarruj akutju. La yanat angkat inilakajpuning God iminang ta yurakan iminy akutju. ");
INSERT INTO mph_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kayirrk la imurnanganiny parak tuka pata awarrangung rtil wiyu nuyu la wenat awurnparrang akutju, murnin awulartparlililminy mira. Pukapa pata ngarrkarrk la werakap pata arrarrkpi marrik muj awaninga rtirr. Malany warrwak ta amajpungkiny la wurwiny awunnyatpung marrik muj iwulakpanyi. ");
INSERT INTO mph_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kayirrk la Jesus yuran ilingan iwarruj akutju. La imurnanganinyka tuka pata awarrangung rtil wiyu nuyu la iminy pu, “Kurlingka nuwurri angkat kutju ngurrij? Nuwurri yunyi kurrurnparra marr ta kayirrk. Kurrungayanti! Ngapi ta ngangurlyak arrarrkpi nuyu God la pata tumurrunti arrarrkpi wanyjipa awanaga la ngantanama ta ngapi. ");
INSERT INTO mph_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Arta, kija kutpajpungkina, la atpana ta kayirrkapa. Kurrayanti nukapa ja arrarrkpi ja kawuyirtiki pa ngantanama ngapi.” ");
INSERT INTO mph_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Malany pata awukenang pu pata Jew arrarrkpi pata awulangaling mulil la pata awunpukikang ta wulatpiyi wu la pata wimunpimun awunpulangakan pata napulurrumpi algaj nuyu Judas pa iwanama iwawutaka ja Jesus. Malany wenatapa pata arrarrkpi iwatpang manjawak awk la mata murrkuwanga. ");
INSERT INTO mph_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","45","Malany wenatapa pata napulurrumpi la Judas amalkpany wakapa la Judas iniyarrung parak Jesus tuka ilangaling ininnyang monmon pu la Judas iminy nuyu, “Nuyi ta Ngarrunukiki. Nuyi ta Ngarrunukiki,” kayirrk la inilakujpany tuka nangartam, nuyu angkawurrun wenatapa pata arrarrkpi tuka iwanama la iwawutaka. ");
INSERT INTO mph_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kayirrk la wenatapa iwumany wurlurlu ja Jesus. ");
INSERT INTO mph_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","La yarakap ja jawirna nuyu Jesus ja ilangaling wakapa kayirrk la inimalkpanyka ja manjawak ja yarntulyak. La manilalkuny nuyu larlngalk yarakap arrarrkpi ja iyamangung nuyu ja yukenang pu pata Jew arrarrkpi tuka awulangaling mulil. ");
INSERT INTO mph_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kayirrk la Jesus iminy pu pata napulurrumpi, “Kunuka nuyu nuwurri kurryatpi manjawak ja yarntulyakut la murrkuwanga? La ngapi ta arrarrkpi ta marrik ngalirrinymi! Makiny! ");
INSERT INTO mph_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngapi ngalangaling tuka God nuyu ta karrpin mira ta akurlyak ta kurrampalk la ngawunukikang pata arrarrkpi angpuning ngurrij la ngurrij, la nuwurri marrik muj ngarrunmanyi la ngarrunputakanyi wakapa. La parangapa la kayirrkapa ngarrunmanyi ngarrunputakanyi, murnin ta wularrut mira pata arrarrkpi iwinnyang monmon tuka God nuyu aminy tukapa angpanamin parak. La angkumirrawung tuka God nuyu ja jurra.” ");
INSERT INTO mph_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kayirrk la pata Jesus awarrangung rtil wiyu nuyu amurtpiny la awungurrinykili iwarutpan ilangaling wakapa. ");
INSERT INTO mph_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Malany wakapa ja marryun ja yarrangung parak warrwak iniyarrukuning parak Jesus, malany manpurrwa iwutinang. ");
INSERT INTO mph_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","La wenatapa pata napulurrumpi ajirrik iwumanyi wurlurlu, la iwumany nuyu manpurra la yanat ingurriny kili jularra. ");
INSERT INTO mph_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","Malany puka pata napulurrumpi iwumany parak ja Jesus tuka ta kurrampalk tuka ja yukenang pu Jew tuka awulangaling mulil. Malany tukapa ta kurrampalk mingkaga mampulanganiny malany apuwulngan aril ta kurrampalk. La ja Peter warrwak awunyarruning parak pata napulurrumpi. Yarran parak yurlgeny tuka mingkaga la yuran ap tuka yungku algaj wu pata wupaja pata tuka God nuyu ta karrpin mira ta akurlyak kurrampalk awuyamangung. La wera pata awukenang Jew ta awulangaling mulil la pata wimunpimun la muj pata awunpukikang ta wulatpiyi awuntumany la wemin awurlgeny tuka kurrampalk nuyu ja yukenang pu ta mulil angpatpang. ");
INSERT INTO mph_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Malany pata wimunpimun pata awulangaling mulil awuntumanyi pata arrarrkpi ajirrik iwumanyi lagarr nuyu la amina ta algaj iwayawng iminang ta nungmurrunti pa nungpakapa iwuwuni, la marrik angpunmanyi ta manjat. ");
INSERT INTO mph_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wigarra yirrk pata arrarrkpi amajpungkiny iwumangung lagarr nuyu ja Jesus, malany marrik muj amartukpuni wu la wemin. ");
INSERT INTO mph_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Malany yara pata arrarrkpi amajpungkiny awularrajpany la iwumany lagarr nuyu. ");
INSERT INTO mph_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","La aminy, “Ngarri ngarralyungan nuka ja arrarrkpi iminy, ‘Ngapi ngapanawun ngapaka warak ta God nuyu ta karrpin mira ta akurlyak kurrampalk la ngapangula ta awara ta ngarrkarrk ta ngurrij. Wigarra yirrk pata arrarrkpi aparnakeny tuka ta kurrampalk la ngapi ngapanarnaken ta wurrwurr ngapi palat.’” ");
INSERT INTO mph_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Malany wenatapa pata arrarrkpi angkuwung wugarra ta iwumangung lagarr nuyu malany marrik amartukpuni wu la wemin. ");
INSERT INTO mph_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Malany ja yukenang pu pata Jew tuka awulangaling mulil imajpungkiny tuka awaning angpunmangung la iminy nuyu ja Jesus, “Puka pata arrarrkpi aminy nuyi anminang ta nungmurrunti. Malany ta anngalyungan nuyi kiki anpanamin?” ");
INSERT INTO mph_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Malany ja Jesus marrik muj inilakpanyi. La ilakujpiny. Kayirrk la ja yukenang pu iminy, “Ma, la anmina ngarru: Kurlingka nuyi ta nukurkyak mira nukurlaj Christ, ta God iminy ngiwalangakaga? La kurlingka nuyi ta God kunimalkpany?” ");
INSERT INTO mph_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kayirrk la Jesus iminy, “Ee, ngapipa. Ngapipa ta ngangurlyak arrarrkpi ta yanat nuyu God, malany nuwurri ta napulurrumpi malany ngarrunpayan ta warrwak. Ngapi nganawani kapa yurrng tuka wurulwurul akut nuyu God, ja nulawarrkurlyak mira. La muj ngarrunpayan ta nganamurnanganiga tuka kuynu.” ");
INSERT INTO mph_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Kayirrk la ja yukenang pu tuka Jew awulangaling mulil ilirrinyminy la innyarlawng yarrjarrk nuyu manpurra la iminy pu, “Kurlingka tukapa kurralyungan? Ta iminy yanat kapin God! La marrik muj arrungmiyarmang nganti inginkay. La arralyungan ngarrurri wiyu. Malany nuwurri kiki kutpin, kurlingka annyukpung ngarrurru wulatpiyi ay makiny?” Kayirrk la amparrkamparrk aminyka, “Kapin ta nungpakapa iminy. Nukapa yanat annyukpung ta wulatpiyi ngarrurru la malany iwamaju.” ");
INSERT INTO mph_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yara pata wupaja pata tuka God nuyu ta karrpin mira ta akurlyak kurrampalk awuyamangung wakapa tuka awaning ngarlakalak iwumartparrukuning maralngkiny. La muj iwuwutiny manpurra tuka wun pa marrik yukena, kayirrk la iwuwuning yurnu wu la aminy, “Arta! Nuyi kanmin mali God kuninguliny ta murrparl mira. Ma la kayirrk anmina ngarru, nganti kuniwung?” Kayirrk la pata iwumany parak ja Jesus la iwuwuning. ");
INSERT INTO mph_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Malany ja Peter angkat iwaning tuka wanyji yungku malany wukej tuka mingkaga tuka ja yukenang pu tuka Jew ta awulangaling mulil. Malany ninyarakap warrawurnji jita inyjamangung wakapa tuka kurrampalk inyarran parak ingayawng ja Peter wakapa. Ingayawng la inyminy, “Arta. Ngungpurrun nuyi kurrarrangung rtil nuka ja arrarrkpi ja nuwuran Nazareth ingurlaj Jesus?” ");
INSERT INTO mph_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kayirrk la Peter iminy, “Makiny! Ngapi marrik ngungpurru ta kanmin ngartu.” Kayirrk la Peter imurnanganiny parak tuka ja karrurlgenka la kalakalak inginkan. ");
INSERT INTO mph_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Malany jakapa jita warrawurnji inyjamangung wakapa ingayawng tuka ja karrurlgenka la inyminang pu pata arrarrkpi wakapa, “Nuka ja Jesus jawirna nuyu.” ");
INSERT INTO mph_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kayirrk la Peter iminy akutju, “Makiny ngapi ta mungu!” Warrwakapa la pata arrarrkpi wakapa awulangaling tuka karrurlgenka aminy nuyu Peter, “Nuyi ta kannginka kapin pata tuwuran Galilee kawunginka, la ja Jesus nuwuran Galilee, malany ta nuyi yanat kurrarra rtil wiyu nuyu.” ");
INSERT INTO mph_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Malany ja Peter ilirrinyminy la iminy, “Ngapi ngamin nuwurru ngapi marrik ngiwurru nuka ja arrarrkpi! Ngapi marrik ngungpurru ta kurruni monmon! God kaniwurrun tuka ta aralpa, kapin ta makiny yanat malany nganpaniwun!” ");
INSERT INTO mph_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kayirrk la ja kalakalak inginkan akutju. Malany wakapa ja Peter la aniwurrung tuka Jesus yurakan iminy nuyu malany Jesus iminy, “Pata arrarrkpi awanalyu nuwu anpanamin ngarrkarrk la arakap nukpawurr ta nuyi marrik nganpurru ngapi la iwalaja ja kalakalak ngarrkarrk imawurr.” Kayirrk la Peter iwararrkenang. Marrik muj ilakujpina. ");
INSERT INTO mph_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Malany ta ngulamngulam pata arrarrkpi pata awukenang pu pata Jew awaning ngarlakarlak tuka kiki awanamin nuyu ja Jesus. Malany wenatapa pata awukenang pu ta awulangaling mulil, la pata awunpukikang ta wulatpiyi wu la muj pata wimunpimun. Malany wenatapa iwuwutiny ja Jesus la iwumany parak yarran juju warak tuka ilangaling ja arrarrkpi ja ingurlaj Pilate ja Roman yukenang pu. Wenatapa iwulakajpung Pilate pa iwanini yatjat ja Jesus. ");
INSERT INTO mph_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kayirrk la ja Pilate inilakajpung, “Kurlingka nuyi ta kannguken wu pata Jew arrarrkpi awk?” Kayirrk la Jesus inilakpany, “Nungpaka ta anminyka.” ");
INSERT INTO mph_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pata awukenang pu ta mulil wu pata Jew arrarrkpi iwurtjung ja Jesus la aminy nuyu ja Pilate, “Nuka iminang ta nungmurrunti.” Malany ja Jesus marrik muj inginkanyi. ");
INSERT INTO mph_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kayirrk la ja Pilate iminy nuyu, “Anngalyunyi wu ta kiki kamin. Kunuka nuyu nuyi marrik annginkay ta nuyi wiyu nuwu?” ");
INSERT INTO mph_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","La ja Jesus marrik muj inginkanyi, malany ja Pilate iwurlkpalangkeny. ");
INSERT INTO mph_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta angpuning jungkarra la jungkarra tuka mulil angpatpang wungurlaj Passover, ja Pilate iminang akut kunuka yirrik ta wungurlyak wu pata arrarrkpi kapa Jerusalem. Yanat inimalkpangung yarakap ja arrarrkpi tuka iwaning iwutikinang. ");
INSERT INTO mph_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","8","Malany tuka Passover angpatpang pata Jerusalem arrarrkpi tuka iwuyarruning parak ja Pilate la iwulakajpuning pa inimalkpangung yarakapju ja arrarrkpi ja iwutikinang imalkpangung la yangkung. Ta iwuyarrung parak ja Pilate malany ja Jesus wakapa akutju ilangaling. Wakapa akutju ja arrarrkpi ja awuniwuning wera pata arrarrkpi ja ingurlaj Barabbas iwaning iwutikinang. Malany yanatapa awaning awutikinang rtil pata jawirna nuyu murnin awuntuwuning pata anpulirri. ");
INSERT INTO mph_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","11","Ja Pilate wularrut aniwurruning pata awukenang ta Jew awulangaling mulil awk nakapa iwarnamangung ja Jesus malany nungpakapa iwumany parak nuyu ja Pilate. La wenat angkumiyarmangung Pilate iwaniwun. Malany arrarrkpi pata tuwuran Jerusalem iwulakajpung ja Pilate ta iwanimalkpa yarakap ja iwutikinang iwamalkpa iwana, la iminy, “Aku. Kurlingka marrik Jesus imalkpang ying, nukapa ja arrarrkpi ja kutpin ja kiwken nuwurru nuwurri ta Jew arrarrkpi awk. Malany nuwurri kiki kutpin?” La pata wulatpiyi awukenang awunpuyurrngpukpung pata arrarrkpi, la aminy nuyu ja Pilate, “Makiny! Naka ja mungu! Ngarri kurrunmiyarma kuwamalkpa Barabbas iwamalkpa iwana tuka iwaning iwutikinang.” ");
INSERT INTO mph_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kayirrk la ja Pilate iminy, “Malany kiki ngarrunmiyarma nganamin nuyu nuka ja arrarrkpi ja kutpin kiwken nuwurru ta Jew arrarrkpi awk?” ");
INSERT INTO mph_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kayirrk la mampularraniny kirrk, “Kurriwuni! Kurryarnakena tuka warlk la kurriwanarutpa iwamaju!” ");
INSERT INTO mph_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kayirrk la Pilate iminy, “Kunuka nuyu? La kiki iminy ta nungmurrunti mira?” La marrik muj awalyunyi, la wenat mampularraniny murr mira, “Kurriwuni! Kurryarnakena tuka warlk!” ");
INSERT INTO mph_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","La ja Pilate marrik muj animiyarmanyi lirri, pa nungpakapa iminy puka pata napulurrumpi angkumiyarmany. Yanat inimalkpany yuran Barabbas tuka iwaning iwutikinang la iminy pu pata Roman anpulirri ta iwanawun pilkuj Jesus. Malany ta warrwak ta angkuwularrung tuka iwuwuning pilkuj, Pilate iminy pu, “Kurryarnakena tuka warlk la kurriwanarutpa iwamaju.” ");
INSERT INTO mph_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Malany pata anpulirri iwumany parak ja Jesus wukaj tuka mingkaga tuka Pilate nuyu ta kunak. La awulajantiny pu pata tumatpa wiwalu pata anpulirri awurlgeny parak wakapa tuka mingkaga. ");
INSERT INTO mph_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La wenatapa iwuyarniliny ja numalal mira ja manpurrwa ja Jesus kapin ja wenat awuyarniny pata wimunpimun. La muj wenat mampayawng wikurl la mampunguliny kapin ja kangpuyarni wanji pata wimunpimun. Kayirrk la mamputpan tuka Jesus wanji nuyu ");
INSERT INTO mph_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","La iwuwung namarlaja. Kayirrk la iweny kartawarrkartawarr tuka yanat kumpil nuyu la aminy, “Arta, nuyi ta kannguken. Nuyi ta kannguken wu pata Jew!” ");
INSERT INTO mph_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La angkat iwuwuning tuka wanji warlk, la muj iwumartparruning maralngkiny. ");
INSERT INTO mph_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Malany ta angkuwularrung kirrk tuka iwumalanymakpangung la iwartpirrantiny nuyu ja purple manpurwa la iwuyarniliny ja yanat nuyu ja manpurrwa. Kayirrk la iwumany parak tuka nungmatpa kunak tuka iwanawun iwularr. ");
INSERT INTO mph_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Malany wakapa ja arrarrkpi ingurlaj Simon yarrangung parak kunak malany ilinganka tuka karrape. Malany ja Simon nuwuran ta kunak wungurlaj Cyrene la awunnyatpang ngarrkarrk pata awunimalkpangung, wingurlaj Alexander la Rufus. La pata anpulirri iwuyurrngpukpung ja Simon manimany kit Jesus nuyu mata warlk. ");
INSERT INTO mph_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Awarran parak tuka kunak wungurlaj Golgotha la ta kanyu warak ta wulatpiyi Iyarrmulu Kunak. ");
INSERT INTO mph_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kayirrk la pata anpulirri awunmakpeny nuyu iwuni Jesus ta nuntirri la ajirrik anilanyi. Malany ta nuntirri angkuwinyjamany mejijin ingurlaj myrrh. Malany Jesus marrik anilanyi. ");
INSERT INTO mph_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","La pata anpulirri iwarnakeny ja Jesus tuka yurnu tuka kanimarratpi la tuka kannyarlukpa tuka warlk, kayirrk la mampumajpungkuny, la iwarutpan wakapa iwamaju. Kayirrk la mamputpan warlk mata malijap yurrng tuka wanji nuyu malany angkumirrawung wakapa tuka warlk ta kunuka nuyu ta iwuwung. Malany tuka angkumirrawung tuka kangmin Ja Kiwken wu pata Jew. Malany jita muwarn inyminy rtutrtutka ta Jesus iwarnakeny tuka warlk. Kayirrk la ta warrwak pata anpulirri awuling lintij tupulu ja yanat nuyu ja manpurra. ");
INSERT INTO mph_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","La pata anpulirri awunparnakeny ngarrkarrk pata tumurrunjut tuka warlk wanyji tuka Jesus yarnting. Malany yarakap tuka inyjaku akut nuyu Jesus la jara tuka wurulwurul akut. ");
INSERT INTO mph_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Malany yara pata arrarrkpi pata iwuwarlkijpakpangung Jesus la iwumalanymakpangung. La wakapa awulangaling angpuyirrngukuning wanji wu nuyu innyatpa wurwiny yanat. La aminy nuyu, “Nuyi kanmin mali nuyi kapanawun kapaka warak ta God nuyu ta karrpin mira ta akurkyak kurrampalk kayirrk la kapangulakan akutju ta ngarrkarrk ta ngurrij.” ");
INSERT INTO mph_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","La awulangkarlakeny nuyu la aminy nuyu, “Mapa, kiki ja nuwu wiyu anngatpa jir! La ankatpanyiga tuka kanngarnti!” ");
INSERT INTO mph_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Malany pata awukenang Jew awulangaling mulil la muj pata wulatpiyi awunpukikang awuntumany la wemin la iwuwuning parr Jesus. La aminy pu la wemin, “Yanat awunnyatpang jir wera pata arrarrkpi la ta nuyu wiyu marrik yatpay jir. ");
INSERT INTO mph_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Malany kimin mali yanatapa ja God inilangakanka. Yanat kimin mali ja kiwken ngarrurru, la muj kiwken wu pata Israel arrarrkpi. La makinyju! Ngarri marrik ngatpartukpu nuyu la kapin ta ngarrayanyjing ilatpangka wumarrk tuka kiwalkarin wakapa tuka warlk!” La wera pata arrarrkpi pata awarnting tuka warlk awuntumany la wemin la iwayanayantung Jesus. ");
INSERT INTO mph_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Malany jita muwarn inypaning yurrng akutju, ta warntatarr wungijalk, ta wugarra yirrk kunak inimany nungmutput, angminy parak kapin wupurrk akut. Malany ta inimany nungmutput ta arukaruk inyalimpulngan ta 3 oꞌclock. ");
INSERT INTO mph_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kayirrk la Jesus ilajantiny murr mira la yanat wiyu nuyu ta ngaralk iminy, “Eloi Eloi lema sabachthani?” Nungpakapa ta iminy, “Ngapi ngartu ja God, ngapi ngartu ja God, kunuka nuyu nganung kirrwara la nganarutpan ngapi palat?” ");
INSERT INTO mph_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Malany yara pata arrarrkpi awulangaling wakapa awalyungan nuyu Jesus ta kiki iminy. La wenat aminy mali kilaja nuyu Elijah nuyu iwalatpaga. ");
INSERT INTO mph_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","La yarakap arrarrkpi ingurriny manimany mata kapin manjarrpin la mannyakan jaw tuka nuntirri. Kayirrk la maniwutiny tuka warlk la manimajpungkuny tuka Jesus ilakpirij nuyu iwanamin yurlk anyak. La nakapa ja arrarrkpi iminy, “Aku. La arriwanarutpa. La arriwamirlajun Elijah arriwayan iwanaga iwannyutpa wumarrk.” ");
INSERT INTO mph_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kayirrk la Jesus ilajantiny akutju, la imajungan. ");
INSERT INTO mph_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Malany tuka God nuyu ta karrpin mira ta akurlyak kurrampalk kapa Jerusalem atangaling wakapa ja karrpin ja manpurrwa iling ayay aniwuning rtal tuka nyunyuk ta kunak. Malany angunminy ta Jesus imajungan, la nakapa ja manpurrwa iling ayay yarlangkeny kapawi la kapawi ngarrkarrk apa iling ayay, malany tuka yarlangkeny yurrng yarran parak wumarrk ora. ");
INSERT INTO mph_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Malany tuka warlk, ja yukenang pu pata Roman anpulirri ilarrajpany tuka wanyji Jesus, la innyayawng ta imajungan, la nakapa ja nulirri iminy, “Aralpa mira nuka ja arrarrkpi inimalkpany God!” ");
INSERT INTO mph_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ta wiyinirrk wigarra yirrk pata warramumpik awarrangung rtil ja Jesus wugarra yirrk kunak kapa Galilee. La iwayatayantung wakapa, kayirrk la awuran rtil kapa Jerusalem. Malany wenatapa awularrajpany warak la mata warlk malangalingka warak la angpayawng kirrk tuka kiki angminy parak nuyu ja Jesus. Jita Mary Magdalene algaj ngaw awulangaling la Salome la jita ninymatpa Mary jita inyalkpangung pu pata warrawarrwak James la Joses, pata awarrangung rtil wenatapa. ");
INSERT INTO mph_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Malany ja Jesus imajungan ta nungpakapa ta warntatarr la pata Jew arrarrkpi angpungulinnguliny angkat wu nuyu ta angkanatpi ta wungurlyak ta warntatarr wungurlaj Sabbath, malany wenatapa marrik awuyamanyi ta nungpakapa ta warntatarr. Malany ta inyuriliny parak ");
INSERT INTO mph_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ja arrarrkpi yuran tuka Pilate. Malany ingurlaj Joseph la yanat ilinganka ta kunak wungurlaj Arimathea. La wigarra yirrk aminy nuka ja numalal ja arrarrkpi ja Joseph. La yanat animirlajuning tuka God iwanuki nuyu wiyu ta yanat ja kiwken mira ngarrurru amparrkamparrk. Malany yanatapa ja Joseph ilij nuyu kawungurrin tuka Jew Wulatpiyi. La marrik muj imurtpina ta yuran imalkpany nuyu ja Pilate. La inilakajpung iminy, “Nungmalal ta ngiwanama warak ja Jesus la ngiwangulanngula tuka ngarri warak?” ");
INSERT INTO mph_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Malany ja Pilate iwurlkpalangkeny. La iminy, “Kurlingka nakapa ja arrarrkpi wularrut imajungan?” Kayirrk la inilangakan yarakap yuran inimany ja yukenang pu pata anpulirri wakapa la inilakajpung, “Kurlingka aralpa wularrut imajungan ja arrarrkpi?” La nakapa ja yukenang pu pata anpulirri iminy nuyu Pilate, “Ee, aralpa.” Kayirrk la ja Pilate iminy nuyu ja Joseph, “Kumanyi warak ja Jesus ingijalk.” ");
INSERT INTO mph_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kayirrk la Joseph inimany parak ja kiwarlkparran ja manpurrwa. La inimany ja Jesus ingijalk innyakan tirip la innyutpan wumarrk tuka yarnting mata warlk la iniwutikiny nakapa ja manpurrwa. (Malany yanatapa ja Joseph yurakan aniyawung ta yurk tuka murrgu.) Kayirrk la inimany parak ja Jesus ingijalk la innyutpan wakapa tuka yurk. Kayirrk la animalanmanmany waryat ta karrkpin la animajput ta yurk. ");
INSERT INTO mph_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malany wenatapa pata warramumpik, Mary Magdalene la ninymatapa Mary jita inyalkpany nuyu Joses, malany wenat iwayawng ja Joseph ta innyutpan ja Jesus ingijalk. ");
INSERT INTO mph_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Malany ta nungmatpa ngurrij nungpakapa ta angpatpung ta wungurlyak ta warntatarr angkuwarnangajpuning Sabbath. Malany ta inyuryiliny parak nungpakapa ta wungurlyak ta warntatarr ta algaj angkuwularrung. Kayirrk la Mary Magdalene, Salome la Mary jita inyalkpany nuyu James angkumanyka yirri ta kangputjirran pa iwarlatpan Jesus ingijalk, wakapa iwayurka nungmalal kirrk. ");
INSERT INTO mph_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Malany ta Sunday ngulamngulam jita muwarn inymajpungkinyka wenatapa awuran tuka yurk tuka Joseph innyutpan ja Jesus ingijalk yung. ");
INSERT INTO mph_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Malany tuka awarrangung parak wakapa la aminy pu la wemin, “Nganti angpanimilkpunge ta waryat pa mannyanatpalan ta yurk ngarrurru? Murnin tuka karrkpin mira marrik kiki atpi.” ");
INSERT INTO mph_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Malany wenatapa pata warramumpik amalkpany wakapa malany ta awukeny yurrng la wularrut nganti yirrik animilkpungeny ta waryat. ");
INSERT INTO mph_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kayirrk la awurlgeny parak wukej tuka yurk la iwayawng ja marryun iwaning wakapa tuka wurulwurul akut, malany iyarning ja iwarlkparrantung mira ja manpurrwa. Malany awurlkpalangkeny. ");
INSERT INTO mph_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kayirrk la iminy pu, “Yunyi kutpurtpin. Nuwurri kurruken nuyu Jesus ingijalk ja arrarrkpi ja nuwuran Nazareth ja iwuwung iwuwalkariny tuka warlk. God inimajpungkuny akutju-malany yanat kani arlarrarr. Malany kanipa iwutpan ta ingijak, la kayirrkapa arlarrarr ta kani.” ");
INSERT INTO mph_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","La iminy pu, “Kutpurnangannya warak pu pata awarrangung rtil wiyu nuyu la kutpanamin pu awamurnangani warak kapa Galilee ngaw ta kunak. La muj kurrungpawurrun ta Peter kutpanamin nuyu. La kutpanamin pu ta Jesus iwanuraka warak wakapa ta kunak, malany ta kutpamurnangani wakapa kurriwayan yanat. La kurrungpawurrunka, tuka yanat iminang nuwurru ta nungpakapa.” ");
INSERT INTO mph_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Malany pata warramumpik marrik kunuka muj angkuwurruni. Murnin amurtpinang la awulililmikpinang. Kayirrk la amalkpanyka tuka yurk la awungurriny kili. Malany wenatapa pata warramumpik amurtpiny mira la marrik muj nganti iwulakajpuni la awungurriny kili warak. ");
INSERT INTO mph_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Malany Jesus imajpungkiny akutju ta Sunday ngulamngulam. La yanat yurakan la yujiny ngaw Mary Magdalene ta ingayawng. (Malany ta wiyinirrk mira Jesus innyakan ngaw yaliwi ja ingatpang wurrkamaj yurnu la ngarrkarrk nakapa innyakakan kirrk ngaw.) ");
INSERT INTO mph_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kayirrk la Mary inyuran tuka Jesus jawirna nuyu pata awarrangung rtil wiyu nuyu. Malany tuka inymalkpany wakapa, awunngayawng marrik amina marrmarr mira la awararrkenang. ");
INSERT INTO mph_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kayirrk la Mary inyminy pu, “Jesus napaka yarnangkat! Kayirrk ngeyawng!” La wenat marrik muj angkumanyi ngaw ngaralk. ");
INSERT INTO mph_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Malany ta warrwak la pata ngarrkarrk akutju pata Jesus awarrangung rtil wiyu nuyu awarrangung parak malany awulinganka Jerusalem la awarrangung parak tuka nungmatpa kunak. Malany wakapa Jesus imalkpany pu la yujiny pu iwayawng. Malany yanat imelngkawung wu, malany ta wiyinirrk ta iwayawng marrik iwayanti iwunmanyi la ja nukapa yanat. ");
INSERT INTO mph_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Malany ta warrwakapa la iwayawng mira, wakapa akutju la amurnanganiny parak kapa Jerusalem la aminy pu pata Jesus akutju awarrangung rtil wiyu nuyu ta iwayawng. Malany wenatapa pata wera marrik angkumanyi wu ngaralk. ");
INSERT INTO mph_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Malany ta warrwakapa, la puka pata 11 pata Jesus awarrangung rtil wiyu nuyu apulangung walij kayirrk la Jesus imalkpany pu wakapa la yujiny pu. La yanat awuniluntuny iminy pu, “Kunuka nuyu nuwurri marrik kurralyunyi wu pata ngapi nganpayawng? Malany tuka aminy nuwurru nungpakapa aralpa la nuwurri marrik kurrungmanyi wu ngaralk.” ");
INSERT INTO mph_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Warrwak la iminy pu pata awarrangung rtil wiyu nuyu, “Nuwurri kutpana wugarra yirrk kunak la kurriweni monmon pu amparrkamparrk ta nungmalal wurluj ta ngapi ngartu. ");
INSERT INTO mph_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Malany yara pata arrarrkpi awamartukpun nuwurru ta kutpanamin pu - malany nuwurri kurrungpangurtpulukpun pu wupaj malany God awunpannyatpi jir. La God marrik awunnyatping jir arrarrkpi pata marrik amartukpu nuyu ta ngaralk - la iwanamin pu wenat ta apalulkanyi tuka nungmurrunti aminang. ");
INSERT INTO mph_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","La arrarrkpi pata kamartukpun ngartu ngapi nakapa awanamin ta nungmalalut murnin nungpakapa awanuki wu pata arrarrkpi ta wenatapa pata God nuyu arrarrkpi. Malany ta awayama ta ngapi ngartu ta wutkut tuka awanamin tuka iwayurrngpukpun ja yaliwiyut iwamalkpaga iwana ja kiwani tuka arrarrkpi wingijalk la muj awanginka tora ta ngaralk tuka marrik wularrut awunginkanyi. ");
INSERT INTO mph_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","La kapin ta iwumang ja nulirri ja arukin, naka marrik muj awunirrkay, la kapin ta angpulang ta nungpurnnyak aliwi, naka marrik muj awuniwu wiwularr, la muj tuka awuntanatpi pata kamaju pata arrarrkpi, la God awunpaningulakan nungmalal kirrk pata kamaju pata arrarrkpi.” ");
INSERT INTO mph_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Malany ta warrwak tuka Jesus aniwularrung tuka inininy monmon kirrk pu pata awarrangung rtil wiyu nuyu, la God inimany parak yurrng kapa tuka yanat nuyu ta kunak. La Jesus iwaningan tuka wurulwurul akut nuyu God, ta kunak tuka ja ingurlyak mira ja arrarrkpi iwawani. ");
INSERT INTO mph_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Malany ta warrwakapa la pata awarrangung rtil wiyu nuyu awuran wugarra yirrk kunak la iwinnyang monmon pu wigarra yirrk ta nungmalal ta wurluj ta Jesus nuyu. La God awuyamangung rtil. La yanat awunnyung wukut ta aminang ta wungurlyakut nuyu la wigarra yirrk angkuwurruning ta wenatapa God awarrangung rtil, la ta wurluj angpunmangung nungpakapa aralpa ta Jesus nuyu. Malany wenatapa pata warramumpik awuran tuka Peter la pata jawirna nuyu la aminy pu tuka kiki angminy parak. Malany ta warrwakapa la Jesus imalkpany pu la awunilangakan pata awarrangung rtil wiyu nuyu wugarra yirrk kunak-kapa kinymalkpa muwarn la kinyuryi muwarn iwinnyang monmon pu ta nungmalal ta wurluj nuyu Jesus, pa awunpannyatpi jir marrik muj amajung pa awawani rtirr warak akut la akut. Tukapa ta wurluj ta wungurlyak mira la angpanaw akut la akut. Malany parangapa. Aralpa. ");
INSERT INTO mph_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Kapa Bethlehem Joseph la Mary angpuyalmangung kunak ngapiwi awanawng, makiny la awuntpiny tuka mampulangung larlngalkpu. Wakapa inyjalkenang jita Mary la ilurrang ja warranyngiw. Ingamang ja warranyngiw ingawutikiny ja manpurra, kapin wera warramumpik kamin. Ingutpan yung tuka aputpangung walij larlngalkwu. ");
INSERT INTO mph_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wakapa wanyji kunak ta wupurrk, yara arrarrkpi awaning tuka warra mirlalk awunpayatantantung larlngalkpu. ");
INSERT INTO mph_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","God inilangakanka ja arrarrkpi, ilatpanka kapa yurrng, animanyka wurluj. Ilarrajpany, la God aniyirrantiny kirrk wakapa, awurlpalangeny la amurntpiny. ");
INSERT INTO mph_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","La nakapa ja arrarrkpi iminypu, “Yunyi kurtputpin. Ngapi ngungmanyka numalal wurluj nuwurru, nuwurri amparrkamparrk. ");
INSERT INTO mph_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","12","Kayirrkapa ja warranyngiw ilurrang kapapa Bethlehem tuka, ta kunak tuka David imurranyminy. Kutpana wakapa la kurriwayan yanatapa. Iwuwutikiny ja manpurra la iwutpan tuka aputpangung walij larlngalk wu. Malany ta kurriwayan wakapa kurrungpawurrun ta tukapa ta wurluj ta aralpa mira. Yanatapa ja kurrunpanyatpijir nuwurri arrarrkpi. Yanat ja Kiwken God. Wularrut mira, God iminypu tuka inilanganganka ngarrurru ja iwanuken nuwurru.” ");
INSERT INTO mph_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus iminy, “Ngapipa ta Alan, la ngapipa ta Aralpa, la ngapipa ta Wirrngak. Marrik muj anngarray warak tuka Punyi God. La ngapi wiyu kurrunmangparak tuka yanat.” ");
INSERT INTO mph_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pata awarrangung-rtil wiyu nuyu ja Arrkingan iminy nuwurri ja nyunyuk iyarlmu kurrungpannyun ta wutkut. Kutpana kurrungpaka ngartuk ngaralk wu arrarrkpi ta ngapi. Nuwurri kutpana Jerusalem kapa Judea la Samaria kunak wakapa kutpana wugarrayirrk kunak la kurrungpanuma wu ta ngarrunpanimonmon ngapi.” ");
INSERT INTO mph_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ja Arrkingan iminy pu yirrk pata awurrangung-rtil. Parangapa God inimajpunguny parak yurrng kunak. Pata awarrangung-rtil iwayantung irrirri yarrangung parak yurrng. Kayirrk la kuynu awurrunka ingalakpuyawng ja Arrkingan, la pata awarrangung-rtil marrik iwayanti muj. ");
INSERT INTO mph_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wenat angkat awukengang tuka kuynu, La wakapa ngarrkarrk arrarrkpi awuyarning ja kiwarlkparran ja manpurra la awularrajpany wanji wu pata awarrangung-rtil. ");
INSERT INTO mph_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wenat aminy, “Nuwurri arrarrkpi ta nuwutpuran Galilee, kunuka angkat kurruken yurrng? Ja Arrunimalkpany inimany parak ja Jesus kapa yurrng kunak malany yanat iwamurnanganinga malanypi. Wakapa ta yuran yurrng kunak la kayirrk, kurriwayan akutju iwalatpaga.” ");
ALTER TABLE mph_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
